﻿USE sofia;
DROP TABLE IF EXISTS sofia.ppo_vpl;
CREATE TABLE ppo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ppo_vpl WRITE;
INSERT INTO ppo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ita, Yesu Keriso deyaairaalu, deté wale whi̧rapené doirape asȩyóló muló beterapó. Abraham-né deale naalené mepaae whi̧ deté fóló, Depit dealepó. Depit-né deale naalené mepaae whi̧ deté fóló, Yesu Keriso dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ai whi̧rapené doirapeta i ape. Abraham-né Aisak dealepó. Aisak-né Jekop dealepó. Jekop-né ti Judaró ama nomarapetamo dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judané Peres-ró Seratamo dealepó. Atimaamoné hamata, Tamar-pó. Kale whi̧ Peres-né Hesron dealepó. Hesron-né Ram dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram-né Aminadab dealepó. Aminadab-né Nason dealepó. Nason-né Salmon dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon-né Boas dealepó. Boas-né ama hamata, Rahab-pó. Boas-né Obed dealepó. Obed-né ama hama ti Rut-pó. Obed-né Jesi dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesiné ti kale tȩteróló kaae tare doasi topo whi̧ Depit dealepó. Depit-né Solomon dealepó. Solomon-né hamata, Uria-né dokale so wulia betepa, kale doasi topo whi̧ Depit-né dokalepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon-né Rehoboam dealepó. Rehoboam-né Abaija dealepó. Abaijané Asa dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asané Jehosapat dealepó. Jehosapat-né Joram dealepó. Joram-né Usia dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiané Jotam dealepó. Jotam-né Ahas dealepó. Ahas-né Hesekia dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiané Manase dealepó. Manasené Amon dealepó. Amon-né Josaia dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaiané Jekoniaró ama nomarapetamo dealepó. Ai whi̧rapeta, kale Israel fake so whi̧ bóe whi̧rapené Babilon hae kwiapaae wae sóró faaitere alimó dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Atéró, atima u Babilon hae kwiapaae wae sóró fele sisópaae Jekoniané Sealtiel dealepó. Sealtiel-né Serubabel dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel-né Abiud dealepó. Abiud-né Eliakim dealepó. Eliakim-né Asor dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor-né Sadok dealepó. Sadok-né Akim dealepó. Akim-né Eliud dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud-né Eliasar dealepó. Eliasar-né Matan dealepó. Matan-né Jekop dealepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop-né Maria dokale whi̧ Josep dealepó. Mariané ti Yesu dealepó. Ai sekȩ́ta, so whi̧ feané Kerisopó du betere whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Atéró, i doi mole whi̧rape deté wale whi̧ Abraham-mó kaae sóró bitiré wóló, Depit betale alimó sókó wale whi̧rapené doirape fea touróturaalu, 14 whi̧rapepó. Téró, Depit betale alimó kaae sóró bitiré wóló, kale bóe whi̧rapené atima u Babilon hae kwiapaae wae sóró bitiré fele alimó sókó wale whi̧rapené doirape fea touróturaalu, 14 whi̧rapepó. Téró, u kale Babilon hae kwiapaae wae sóró fele alimó kaae sóró bitiré wóló, Kótóné so whi̧ tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Keriso betale alimó sókó wale whi̧rapené doirape fea touróturaalu, 14 whi̧rapepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Keriso etéró dealepó. Ama hama Maria a̧ dokaai tukóló beteró betere whi̧ Josep-tamo kuni ha̧le betepatei, Dȩi Kepe Wisiné naale eró betepa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Atépa, kale so dokaai yale whi̧ Josep a̧ me dowi alakélé ini, mo donoi whi̧ wisinaale betereteiné so whi̧ feané erateremó, kale so a̧ hale yao̧sóró, kikiti tokó̧ daalaai kisipa mualepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Atei kisipa mutu betepa, nokenarótei Talené ensel-né Josep-paae duraalu, “Depit-né deté wale whi̧né naalema Josep-ó, Mariané ai ere naaleta, kale Dȩi Kepe Wisinétei eró beterapa ya̧ haleni, naao sopa dokaai dapesó fae. ");
INSERT INTO ppo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ama ai ere naale detepata, ti so whi̧ feané du betere dowi alamó saaire kwia tokó̧ló kemeróló tao saalopóló, ama doi Yesu mulae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ai alarape feata, ha̧le kaayóló ini, Talené fo eratere ko̧ló whi̧né mo taketi asȩyóló muló betere fo dokonóturaalu, yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ai fo i ape. “Beta̧ so seimale whi̧ metamo kunipatei, naale yaalopó. Ai naale deyóló betepa so whi̧ feané a̧ kilituraalu, ita Emanuel-pó yaalo ai ape,” erapó. Ai fo bete feteyóló Kótó da̧tamo beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Atéró, kale whi̧ Josep a̧ turukó horóló, Talené ensel-né nokenaró a̧paae yae yale alatóró sya fóló, kale so Maria dokaai ama bepaae dape salepó. ");
INSERT INTO ppo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Téyaletei, ama somatamo kotere ala ini, ha̧le bitiré fóló kale so naale detepa, Josep-né ai naalené doi Yesu mulalepó. Atéyale ki̧lipaae ti atimaamo kwȩalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Judia hae kwiamó tȩne Betelehem be huluamó, Yesu deyale ki̧lipaae etéyalepó. Jerusalem bemó Herot a̧ doasi topo whi̧ betale sukamó, kale ho̧rené dere ala bete kisipare whi̧rape atima suka hotereró wóló, ai be huluamó betó mole so whi̧paae woseturaalu, “Kale Juda fake so whi̧ tȩteróló kaae tawaaire topo whi̧-a, momó deyóló betere? Ti noatepae, da̧ suka hotereró bitu, a̧ deyóló beteretei kisipa yó̧póló, ó sa̧mó daale ho̧re dȩ yó tapa kolóló, a̧ ao̧mó bitu ama doi hale sóró horaai da̧ i wale ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tétepa, doasi topo whi̧ Herot-né ai fo woseturaalu, ama kisipa feléni, a̧ doasi whaaliatu betalepó. Atétepa, kale Jerusalem be huluamó betó mole so whi̧kélé ama mutere kisipa kaaetóró mutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kale doasi topo whi̧ Herot-né so whi̧mó Talepaae momaratere topo whi̧raperó Moses-né yóló muló betere fo yó matere whi̧rapetamopaae ape yóló woseturaalu, “Kótóné so whi̧ fea tȩteróló kaae tanó̧póló, sóró beteró betere doasi topo whi̧ Keriso-a, mé bemó deyaalopóló asȩmó yóló muló betere?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ti fo depa, atimané tokó̧ mótu duraalu, Judia hae kwiamó tȩne Betelehem be huluamó deyaalopóló, mo taketi Kótóné ama ko̧ló whi̧né asȩyóló muló betere fo i ape. ");
INSERT INTO ppo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Juda haemó tȩne Betelehem be huluamó betó mole so whi̧ diaao̧ kisipané-a, Juda fake so whi̧ tȩteróló kaae tare topo whi̧rape kuamó, da̧kó doi munipó fo du bitu de? Meipó. Kótóné so whi̧ tȩteróló kaae tawaaire topo whi̧ beta̧ dia̧ tua̧mótei, sókó waalo ai ape. Ai sekȩ́né amata, sipsip hupurape tȩteróló kaae taru dere kaae, ya̧lo Israel fake so whi̧ tȩteróló kaae tawaalopó erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Téró, Herot-né kale ho̧rené dere ala bete kolóló kisipare whi̧rapepaae ape, fo kikiti yó faralepó. Atéró kale whi̧rape wapa, atimasisi bitu duraalu, “Diaao̧ kelalepó dere ho̧re-a, noa sukamó kelaleé?” yóló wosetepa, atimané a̧paae mo i be dȩmótóróti kelalepóló, yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ama atima Betelehem be huluapaae dotonaai duraalu, “Kale naale momó sóró beteréró kelaasepóló, mo wisiyóló keka̧e. Atéró kekenalemó, sóró betere tiki keletepa, ti mo hapale tétitóró ȩpaae ene ape. Ti ȩkélé a̧ ao̧mó sinóló bitu, ama doi hale sóró horaairaalu, fenérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Atéró, kale doasi topo whi̧ Herot-né atimapaae yae yale fotóró wosóló, atima faai wale tikipaae furaalu, atima take suka hotereró bitu kelale ho̧retóró ó sa̧mó ha̧le fu betepa kelalepó. Atétepa, atimakélé ai ho̧re foletei kelené kaae sóró felemó, kale naale deyóló betere tikimótóró kei̧yóló daane felepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ai ho̧rené dere ala kilituraalu, atimakélé mo doasi hȩkesené sinalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Atima ai bemó sókó felemó, kale naaleró hama Mariatamo betepa kólóló, atima bukutiri teya̧ró bitu, Doa Tale-ó yóló, a̧ hale sóró horalepó. Atéró, atimané kale naalemó ha̧le melaairaalu sóró wale wisi wisi o̧larape kold kapakélé, si keletómó bilitepa, felé kȩlaa wale o̧lakélé, mur wel wȩikélé, tȩyóló melalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tale Kótóné kale whi̧rapepaae nokenaró atimané hae kwiapaae momó fesaae furaalu, Herot betereró fao̧se yale fo kisiparu, Herot betere tu̧ró feni kae tu̧mó felepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Atéró, atima fi sisópaae Talené ensel Josep noke firepaae wóló, nokenarótei duraalu, “Herot-né ai naale daairaalu keka̧alo ai ape. Térapa, ya̧lo ya̧paae ape dere alimó waasepóló, ya̧ turukó holóló ai naaleró hamatamo dape sóró u Isip hae kwiapaae botokó fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ai fo woseturaalu, kale whi̧ a̧ mo dikitamotei turukó holóló, kale naaleró hamatamo dapesó u Isip hae kwiapaae faairaalu, felepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Atéró, kale whi̧ Herot suki̧ tikimó waairaalu, atimaamo u Isip hae kwiamó bitiré felepó. Mo take Talené ama ko̧ló whi̧né asȩyóló muló betere foné duraalu, “Ya̧lo naale u Isip hae kwiamó betepa, ai hae kwia taaróló ape,” yalepó. Ai fo dokonóturaalu, motóró yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kale topo whi̧ Herot-né ama yaaire ala kikiti hiróló kale ho̧rené dere ala kisipare whi̧rape dilika̧letei, atimané kilirapóló a̧ mo doakale fopaae bualepó. Tétu, ama diki tare whi̧rapepaae yóló mulótu duraalu, Betelehem be huluaró ai hae kwiamó tȩ mole ipu betamomó mióti teó sóró betó mole naalerapemó kaae sóró dilé fóló, ba fo tamo kemeyóló betó mole naalerapekélé mo fea dóló kemerae yóló dotȩyalepó. Ti aita ha̧le meipó. Kale ho̧rené dere ala bete kisipare whi̧rapepaae wosetepa, atimané a̧paae yó melale be dȩ tuȩ́ muluraalu, atéró dóló kemerae yóló dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ti aita ha̧le tua̧mó kaayóló inipó. Kótóné ama ko̧ló whi̧ Jeremaiané i fo asȩyóló muló beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama bemó betere so Resel-né dekȩné suki̧ moló doasi du betepa, mepaae so whi̧né a̧ kisipa felératere fo yalemó, mo wosenipó. Ti noatepae, ama naale senaale fea sisiraae feleteinépó.” Ti ai naalerape dele alata, kale yóló muló betere fo mo dokonóturaalu yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Téró etéyalepó. Kale doasi topo whi̧ Herot suki̧tikimó, kale whi̧ Josep Isip hae kwiamó betepa, nokenaró Talené ensel-né duraalu, “Josep-ó, ai kale naale daairaalu du betale whi̧rapeta, ai suka̧le ape. ");
INSERT INTO ppo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Térapa, ya̧ turukó horóló, ai naaleró hamatamo dape sóró u Israel hae kwiapaae tokó̧ fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tétepa, Josep a̧ turukó horóló, kale naaleró hamatamo dapesó Israel hae kwiapaae felepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Atéró Josep a̧ Judia hae kwiapaae biti̧ faai yaletei, ai hae kwia kale doasi topo whi̧ Herot betale sirimó, naalema Akelausiné tȩteróló kaae tarapó dere fo wosóló, witepa taaralepó. Talené a̧paae nokenaró Judia hae kwiapaae biti̧ fao̧se yale fo kisipa iruraalu, Kaleli hae kwiamó tȩne Nasaret be huluapaae tokó̧ felepó. ");
INSERT INTO ppo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Atéró feleteita, mo taketi Kótóné ama ko̧ló whi̧rapené asȩmó duraalu, “So whi̧ feané a̧ Nasaret be hulua whi̧kópó yaalo ai ape,” ere fo mo dokonóturaalu, atima Nasaret be huluapaae tokó̧ felepó. ");
INSERT INTO ppo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Atéró bitiré wóló etéyalepó. Kale wȩi tópuratere whi̧kó Jon a̧ Judia hae kwia tua̧mó so whi̧kélé bitini, ha̧le kópu ka̧ae fi tikimó sókó wóló beterepó. A̧ aimó betepa, mepaae a̧ beterepaae wuatere so whi̧paae Kótóné fo wisi yó mótu duraalu, “Tale Kótóné ama hepen bemó tȩteróló kaae tare ala mió mo felekemó walapa, dia̧né du betere dowi ala taaróló, kisipa tiki feteyóló betae,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ti a̧ta, me kae mei, mo take Kótóné ama ko̧ló whi̧ Aisaiané waalopóló, bope du betale whi̧pó. Aisaiané ama asȩyóló muló betere fo i ape. “So whi̧ bitini ha̧le kópu ka̧ae fi tikimó, beta̧ whi̧ wóló daalu, fo fakeyóló duraalu, ‘Tale waaire tu̧ donoróló aleyae,’” erapó. ");
INSERT INTO ppo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon-né ama derótua yale kutita, kamel hupu nikiné aleyale kuti derótua yóo, ama sua yale tokélé hupu sekaȩné aleale to sua yóo, yalepó. Ama nukua yale o̧lakélé meke wȩiró ero nusutamo maaté nukua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalem be hulua taaróló wua yale so whi̧kélé, Judia hae kwiamó betó mole so whi̧kélé, kale Jordan wȩi felekemó betó mole so whi̧kélé, mo fea a̧ beterepaae wua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Atimané dowi ala fea ha̧keamó yó mótua depa, Jon-né atima Jordan fole wȩimó tópurótua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Téyaletei, Farisi whi̧raperó Sadyusi whi̧rapetamo so whi̧ wȩi tópurótu betere tikipaae wua depa, ama atimapaae duraalu, “Dia̧ dowi wuli kaae so whi̧ dilikitu betere whi̧rape-ó, Kótóné dia̧tamo fopaae buturaalu kwia melao̧sóró, botokó fae fo né yaleé? ");
INSERT INTO ppo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Diaao̧ ai du betere dowi ala taaróló, motóró kisipa feteyóló wapa, ti diaao̧ du betere alakélé mo kisipa tiki fetere whi̧né dere ala kaaetóró yae. ");
INSERT INTO ppo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Dia̧ta, Abraham-né deté wale naale senaale betereteiné dia̧paae me ala eraalomeipóló kisipa muao̧sé. Ya̧lo dia̧paae mo i dere ape. I muó mole kaporapetei, Kótóné ama mo su̧mó Abraham-né naale senaale aleyóló beteranérapó. ");
INSERT INTO ppo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mepaae nirapetamo naaire du wisi olenitepa, ti diyóló si duku betere dolopaae taae deraalopó. Atéyaairaalu, kutó talené ai ni baalemó ka̧wei ai bukó tare ape. ");
INSERT INTO ppo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ya̧lo dia̧ wȩi tópurótu betereteita, diaao̧ dere dowi ala taaróló, kisipa feteyóló wó̧póló tópurótu beterapó. Tétu betepatei, ya̧lo ki̧lipaae waaire whi̧ beta̧ta ȩ kaae meipó. A̧ mo doasi fotoko̧ bole whi̧ betepa, ȩ naale beleka̧amale kaae, a̧ ao̧mó beterapó. A̧ atei kaae doasi fotoko̧ bole whi̧ bitu, dia̧ wȩi tópuróturaalu, ti kale Dȩi Kepe Wisiró sitamoné tópuraalopó. ");
INSERT INTO ppo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ama naasené ti kale whit o fumi besȩ́né só fó̧póló, ka̧ayóló taae fótua dere ekepé fake tarapó. Kale whit duné fumirape ama fuóló taae faróló, mo whit ke maaté ti mulótua dere be dolopaae mulaalopó. Atéró fumirapeta, ti sukó̧kélé feni ha̧le dótóró tare si dolopaae fesekée deraalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Téró, Yesu a̧ Jordan wȩimó Jon-né wȩi tópuró̧póló, Kaleli hae kwia taaróló, Jon beterepaae walepó. ");
INSERT INTO ppo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tétepa, Jon-né Yesupaae ya̧ wȩi tópuraalo meipóló seséyóló duraalu, “Naao ȩpaae ya̧ wȩi tópurae dere-a, ȩ whi̧ wisi betepa ya̧ tópuraró de? Naaotei ȩ wȩi tópuraasepólópo,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ai fo depa, Yesuné a̧paae duraalu, “Aita mo deretei, mió da̧moné i dere alané Talené ama so whi̧ donoraaitere ala mo dokonó̧pólópa, naao ȩ wȩi tópurae,” depa, Jon-né wisirapóló a̧ wȩi tópuralepó. ");
INSERT INTO ppo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Atéró, Yesu a̧ wȩi tópuóló tétitóró hae taopaae taae hotepa kelalemó, ó hepen be tu̧ tukwȩ fóló, Kótóné Dȩi Kepe Wisi ba ho̧kósere kaae, ama tikimó biti̧ dorowalepó. ");
INSERT INTO ppo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Atéró, ó hepen bemó fo tekerótu duraalu, “A̧ta, ya̧lo yaala sókó fóló mo hosaa mole Naale ai ape. Ama dere ala fea ya̧lo kilitu, ȩ mo doasi hȩkesené sinitu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Téró etéyalepó. Satan-né Yesu a̧ su̧ sóró dée naló̧póló, so whi̧kélé bitini kópu ka̧ae fi tikipaae Dȩi Kepe wisinétei a̧lisóró felepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","A̧ aimó be dȩtereró dikiteretamo whi̧ siki tamo bitu, o̧la mo sawakélé néni wote siri ha̧le betaletikimó, a̧ mo wotené sinalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Atéró betepa, dowi ala yó̧póló su̧ sóró dée nalatere sekȩ́ wóló a̧paae duraalu, “Ya̧tamo Kótóné Naalemapata, ti i kanerapepaae bred o alée fae yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ai fo depa, Yesuné a̧paae tokó̧ mótu duraalu, “I fo asȩyóló muló beterapó. ‘Whi̧ betere beteta, mo o̧la nokoleteiné maaté bitini, Kótóné ama dere fo fea woseturaalu bitiré fenérapó,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Téró, kale dowi Satan-né Yesu a̧ Kótóné mo kae tȩnó betere doasi be huluapaae dapesó fóló, aimó tȩne momatere be mo ó hulua tómó daalalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Atéró daaróló a̧paae duraalu, “Ya̧tamo Kótóné Naalemapata, ti naaotei ya̧ haepaae tu̧wó derepae. Ti i fo asȩyóló muló beterapó. ‘Ya̧ a haepaae muni durupuraalu, kaponé kotóo sóró doalé yao̧sóró, Kótóné ama ensel-rapené naase tómó muni dorowó̧póló, ya̧ tao sae yaalopó,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ai fo depa, Yesuné a̧paae tokó̧ mótu duraalu, “Ti i fokélé asȩyóló muló beterapó. ‘Beta̧ whi̧nékélé a̧ tȩteróló kaae tare Tale Kótóné noa alakó déró ka̧ae kelaai dapóló su̧ sao̧se,’ erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","9","Atéró kale dere kaae, momó dowi Satan-né a̧ mo doasi sokore hasi fosópaae dapesó holóló, i hae kwia feamó kae kae doasi whi̧rapené tȩteróló kaae tare alaraperó ai ala tua̧mó mole mepaae doasi wisi wisi alarapetamo yó mótu duraalu, “Ya̧lo i dere fotamo naao mo beta̧ wosóló, ya̧ ȩ ao̧mó bukutiri tea̧ró bitu, doa whi̧-ó yóló ȩpaae moma depa, ti ai o̧la o̧la fea naao tȩteróló kaae tanó̧póló, ya̧lo ya̧paae melaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ti fo depa, Yesuné a̧paae duraalu, “Satan-ó, ya̧ ȩ taaróló fae. Ti i asȩyóló muló betere fo wosae. ‘Naao Tale Kótópaae beta̧ doasi-ó, yóló a̧ ao̧mó bitu, ama alatóró erótu betae,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Atétepa, kale dowi Satan-né Yesu taaróló foletamo, Kótóné ama ensel-rape wóló, a̧ tao salepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Atéró Jon dipula beteralepó dere fo Yesuné ama wosóló, a̧ Kaleli hae kwiapaae momó fesaayóló felepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Atéró a̧ betere Nasaret be hulua taaróló, Kaleli wȩi kȩla felekemó tȩne Kapeneam be huluapaae tokó̧ fóló betalepó. Ai be huluata, Sepulun hae kwiaró Naptali hae kwiatamo tua̧mó tȩnapó. ");
INSERT INTO ppo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Atéyaleteita, Kótóné ama ko̧ló whi̧ Aisaiané yóló muló betere fo dokonóturaalu yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ai fo i ape. “Sepulun fakeró Naptali faketamoné hae tikita, u kale Jordan fole wȩiró Kaleli wȩi kȩlatamo molepaae eróló erapó. Ai hae tikita, Sepulun fakeró Naptali faketamoné haetei, Juda meire fake tokó̧ fóló, atimané hae aleróló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ai hae tikimó betó mole so whi̧ atima diliki dolomó beteretei, mió mo doasi dȩ wisinaale kolóló betó mulapó. Mepaae so whi̧ta, sinitere alané dilikiró betepatei, mo dȩi suka sókó huturaalu dȩró betepa, ai dȩ tua̧mó betó mulapó,” fo asȩyóló muló beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Atéyale sukamó kaae sóró, Yesuné ama fo so whi̧ feapaae ha̧keamó yó mótu duraalu, “Kótóné hepen bemó tȩteróló kaae tare ala mió mo felekemó ai walapa, diaao̧ dowi ala taaróló kisipa tiki feteyae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Atéró, Yesu a̧ kale Kaleli wȩi kȩla fóku sesekȩ durupu bitu kelalemó, Saimon doi mupatei, Pitapó du betere whi̧ró ama noma Andrutamo ha̧leke wa wȩi kulu tua̧paae derótu beterepó. Ti atimaamota, ya siré kotere whi̧ tamopó. ");
INSERT INTO ppo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tétu betepa, Yesuné atimaamopaae duraalu, “Diaamo ai ya su dere kaae, so whi̧ atéró siré kwȩyaasepóló, da̧ fea beta̧mó kuturaalu, ya̧lo diaamopaae yó melaalopa ȩ sya ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ai fo depa, atimaamoné ha̧leke warape muló̧póló taaróló, mo hapale tétitóró a̧ sya felepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","22","Atéró a̧ tu̧mó fu betalemó, me whi̧ró nomatamokélé daapa kelalepó. Ai whi̧ tamota, Sebediné naalema Jems-ró Jon-tamopó. Atimaamoné alimakélé atima fea wȩi nukumó bituraalu, atimané ha̧leke warape tukó faletei, wisi wisiyóló numutu betepa kelalepó. Atétu betepa, Yesuné atimaamopaae duraalu, “Diaamokélé ȩ sya ape,” depa, kale whi̧ tamo mo hapale tétitóró turukó holóló, atimaamoné wȩi nukukélé, alimakélé betepatei taaróló, a̧ sya felepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Atéró, Yesu a̧ ai Kaleli hae kwia tua̧mó kuturaalu, Kótóné tȩteróló kaae tare ao̧mó mole kisi fo wisi so whi̧ feané wosó̧póló, atimané fo wosetere be doko̧ yó maté kwȩyalepó. Atéturaalu, ai so whi̧ kuamó dowi hepo daae mole so whi̧ró mepaae tiki momaare so whi̧tamokélé wisiraté kutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ama so whi̧ fea atéró wisirótu beterapó deté kotere fo Siria hae kwiamó betó mole so whi̧né woseturaalu, kae kae dowi kisi daale so whi̧kélé, doasi dele su betere so whi̧kélé, dowi kepe tepeyóló betó mole so whi̧kélé, mepaae kae kae kisiné kele olopa olopa yóló sinaaitu betere so whi̧kélé, mepaae momaayóló betere so whi̧kélé, mo fea a̧ beterepaae dapesó wua depa, ama wisirótua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Atéró, kale Kaleli hae kwia taaróló wale so whi̧kélé, Dekapolis hae kwia taaróló wale so whi̧kélé, Jerusalem be hulua taaróló wale so whi̧kélé, Judia hae kwiaró, Jordan wȩi fóku uté tȩró betó mole so fea a̧ beterepaae wóló, ama dere ala kelaai dapóló Yesutamo touyóló kutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Téró Yesuné kelalemó, so whi̧ mo ha̧le o̧la kaae wóló touró betepa, a̧ sokore du ao̧paae holóló beterepó. Atéró beteremó, ama yó matere whi̧rape a̧ beterepaae walepó. Atéró wóló betó mupa, ama atimapaae yó mótu duraalu, ");
INSERT INTO ppo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mepaae so whi̧ dené ya̧lo kepe bete tua̧mó me wisi alakélé muni, mo ya̧ya̧rapó du betepa, ti Kótóné wisiró beterapóló hai̧né sukutu betae. Ti noatepa meipó. Ai so whi̧ta, Kótóné hepen bemó tȩteróló kaae tare ala sóró ai tare ape. ");
INSERT INTO ppo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mepaae atima dekȩné sukutu wole du betere so whi̧ta, Kótóné wisiró beterapóló hai̧né sukutu betae. Ti noatepa meipó. Mió dekȩné sukó̧ló wole du beteretei, take Kótóné atima tuȩ́ tiki feléraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mepaae naame yóló mo dua betere so whi̧ ti Kótóné wisiró beterapóló, hai̧né sinitu betae. Ti noatepa meipó. Kótóné hae tiki mo turó atimamó matepa saalopó. ");
INSERT INTO ppo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mepaae so whi̧ de woteró wȩi nokoletamo du dere kaae, Kótóné mo donoi ala wisi eraairaalu ekȩle du betepa, ti Kótóné wisiró beterapóló hai̧né sukutu betae. Ti noatepae, atétere so whi̧paaeta Talené ama donoi ala mo ti su̧raalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mepaae so whi̧ denétamo mené a̧paae me dowi ala eratepa me o̧la meipóló ha̧le kemeróo, me whi̧ sekȩi ala tua̧mó betepa ko̧lené sukutu tao sóo du betepa, ti atétere so whi̧ Kótóné ko̧lené sukutu tao sóró, atimané dowi alakélé ama kemeró beterapa, hai̧né sukutu beteró̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mepaae so whi̧ atimané hosaa tua̧mó me alatamo hosekéni, mo wisi alatóró erótu betepa, ti hai̧né sukutu betae. Ti noatepae, atétere so whi̧né ti Kótó mo kelaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ho̧le sere ala ó bóe dele ala taalae yóló, filitere so whi̧ta ti Kótóné wisiró beterapóló hai̧né sukutu betae. Ti noatepae, atétere so whi̧ kilituraalu, ita Kótóné ama naale senaale beterapó yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mepaae so whi̧tamo Kótóné mo donoi alamaaté erótu beteremó, kae kae sekȩi alané só derótu betepa, ti Kótóné wisiró beterapóló hai̧né sukutu betae. Ti atétere so whi̧né Kótóné hepen bemó tȩteróló kaae tare ala sóró ai tare ape. ");
INSERT INTO ppo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Dia̧ ya̧lo ala erótu beteremó, mepaae so whi̧né dia̧paae kae kae sekȩi ala eratepa, ó so whi̧ feané keletómó kapala fo yóló faletepa, ó kae kae eratere fo yóló dia̧ só deratepakélé, Kótóné wisiró beterapóló hai̧né sukutu betae. ");
INSERT INTO ppo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ti noatepa meipó. Take Kótóné ama ko̧ló whi̧rapepaaekélé mió dia̧paae ai erótu betere sekȩi ala kaae, erótu bitipakalepó. Atérapa ó hepen bemó mole doasi dupu saaireteimó, mo kée yóló hai̧né sukutu betae,” ");
INSERT INTO ppo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Dia̧ta, i haemó betó mole so whi̧tamo kó felé kaae yóló ai betere ape. Téretei, kóné felé kemetepa, ti momó kae netéró felé bulaaloé? Mo meipó. Atéró felé initere kó me ala enénipó. Atétere kó taae faróló hae tikimó beseké yóló mupa, so whi̧né tȩiya tȩiya yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Dia̧ta, i haemó betó mole so whi̧tamo mo dȩ kaae beterapó. Doasi sokore hae du tómó mo ha̧keamó tȩ mole be hulua bóe whi̧né kelao̧sóró, me o̧lané kinanénipó. ");
INSERT INTO ppo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Atére kaae, mepaae whi̧né lamp sa̧ dȩróló doasi ni fake ao̧mó kinóló mulótimipó. Ti noa yo̧póló meipó. Be tua̧mó betó mole so whi̧ fea dȩmó beteró̧póló kisipa mutu, sa̧ dȩróló mulatere ni fake tómótóró ha̧keamó mulótua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Atétu dere kaae, dia̧ tua̧mó ere dȩ so whi̧ feané koló̧póló, ha̧keamó dȩró betae. Atépa, so whi̧né kilituraalu, ó hepen bemó betere diaao̧ Ayané doi sóró horótu beteró̧póló, wisi ala ha̧keamó erótu betae.” ");
INSERT INTO ppo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ȩ waleteita, Moses-né yóló muló betere foró Kótóné ama ko̧ló whi̧rapené yó melale fotamo tokó̧ló aluraai wénitei, ai asȩmó yóló muló betere fo dokonaairaalu wóló i betere ape. ");
INSERT INTO ppo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ya̧lo dia̧paae mo i dere ape. Ó sa̧ró i haetamo kemeyaai teópa, Moses-né yóló muló betere fo kwia mo sawakélé aluyaalomeipó. Atéyaalopóló muló betere fo fea ha̧sókó feni, dokonóló motóróti eraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Whi̧ me dené i asȩyóló muló betere fo mo sawakélétamo tikitepa, ó me whi̧paaekélé ai ala tukóló yae yóló yó matepa, ti atétere so whi̧ Kótóné tȩtéróló kaae tare hepen be tua̧mó doikélé mo muaalomeipó. Téyaalotei, mepaae so whi̧ dené kale yae yóló muló betere fo wosóló eróo, mepaae so whi̧paaekélé i fo sya fóló erae yóló yó melóo, du betere so whi̧ta, hepen bemó Kótóné tȩteróló kaae tare ao̧mó doasi doi muaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ya̧lo dia̧paae mo i dere ape. Dia̧né dere mo donoi ala wisinaalené kale Moses-né asȩmó ere fo yó mótu betere whi̧raperó, Farisi whi̧rapetamoné du betere donoi ala tȩteró bitinipa, ti ó hepen bemó betere Kótóné tȩteróló kaae tare ao̧mó mo sókókélé faalomeipó.” ");
INSERT INTO ppo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mo take diaao̧ noutererapepaae yóló mulale fo i ape. Me whi̧ mo ti dóló sukunao̧se. Atétepa, ti ai whi̧ a̧ kwia moleteiné taleyóló só deraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Atépatei, ya̧lo dia̧paae dere fo i ape. Whi̧ me dené ama no hamomatamo me bete munipatei, ha̧le fopaae depa, ti atétere whi̧ a̧ kwia moleteiné taleyóló só deraalopó. Atétere kaae, whi̧ me dené me whi̧ hamoma eratere fo depa, ti atétere whi̧ fo taletere whi̧rape beterepaae dapesó faalopó. Téyaalotei, whi̧ me dené ama no hamomapaae duraalu, ya̧ topo doyóló kisipa tikikélé okokoi-ó depa, ti atétere so whi̧ doasi kwia moleteiné mo ha̧le dótóró tare dowi sipaae faai ai du betere ape. ");
INSERT INTO ppo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Térapa, naao me o̧la Kótópaae ha̧le melaai dapóló, kale momatere tikipaae sóró fenalemótamo, naao noné ya̧tamo sekȩrapó depa, ti Kótópaae ha̧le melaaire o̧la melaaitei folosóró, naao notamo mole sekȩpi teraayóló wisirae. Atéró nalo ti naao ha̧le melaaire o̧la Kótópaae melae. ");
INSERT INTO ppo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Whi̧ me dené ya̧tamo fo tokó̧tamo yaai ya̧ dapesó fupa, ti diaamo tu̧ tua̧mó furaalutei a̧ kisipa wisi mulóló, hapale donorae. Até initepa, ti ya̧ taletere whi̧ beterepaae dapesó fóló, fo tokó̧tamo yóló, ai whi̧némo dipula be tȩteróló kaae tare whi̧rapené doasi topo whi̧né naase tua̧mó mulaalopó. Ai whi̧né amamo ya̧ dipula beterao̧sóró kisipa mutu dapó. ");
INSERT INTO ppo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ya̧lo dia̧paae mo i dere ape. Ya̧ dipula beteretei sokó̧póló, da̧le mulale kwia beleka̧amale sonaai monikélé mo turó kemeróló menitepa, ti ya̧ dipula ha̧le bitiré fóló, kemeróló duputere sukamó sokaalo ai ape. Meitepa, ti ya̧ dipula ha̧le betó tawaalopó.” ");
INSERT INTO ppo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“I dere fota, diaao̧ taketi woseté wou beterapó. ‘So ó whi̧ nópu nao̧se,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ai fo epatei, ya̧lo dia̧paae mo i dere ape. Whi̧ me denétamo me so kelené kolóló kisipa tikiné au nukupa, ti atétere whi̧né ama hosaa tua̧mó nópu mo ai nale ape. ");
INSERT INTO ppo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Naao turu kelenétamo ya̧ dowi ala yó̧póló dée nalatepa, ti atétere kele sokóló taae falae. Ti noatepae, naao tiki turó dowi si duku beterepaae fao̧sóró, ya̧ atéró dée nalatere tiki kwia tukóló taae faróló, wisi tikipaae fupa mo wisirapó. ");
INSERT INTO ppo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Naao turu naasenétamo ya̧ dowi ala yó̧póló dée nalatepa, ti ai naase tukóló taae falatepa mo wisirapó. Ti noatepae, ya̧ dée nalatere naase tukóló taae farénitepa, naao tiki turó dowi si duku beterepaae fao̧sóró dapó.” ");
INSERT INTO ppo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Upulé i fo asȩyóló muló beteretei diaao̧ ai tuȩ́re ape. ‘Whi̧ me dené ama sotamo tokó̧ falaai depa, ti tokó̧ fatere asȩ sóró fó̧póló sopaae melae,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ai fota mo epatei, ya̧lo dia̧paae i dere ape. Whi̧ me dené ama so me whi̧tamo nópu nénipatei ha̧le tokó̧ fatepa, ti soma amatei nópu nalatapó. Atéró tokó̧ fatere so me whi̧némo dokotepa, ti ai whi̧ a̧kélé nópu nukulapó.” ");
INSERT INTO ppo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yesuné atimapaae duraalu, “Take bitiré wale so whi̧paae yóló mulale fo me i ape. ‘Naao Talepaae i ala mo yaalopóló, malo yale fo tikini, motóró eró tawae,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tépatei, ya̧lo dia̧paae mo dirii fo i dapa wosae. Malo dere alakélé momókó yao̧se. Naao dere fo diriróturaalu, hepen be doi yóló malo momókó yao̧se. Ti noatepae, ó hepen beta, fea ala fea tȩteróló kaae tare Kótó betere tikipó. ");
INSERT INTO ppo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ó diaao̧ dere fo diriróturaalu, i haekélé doi yóló malo momókó yao̧se. Ti i haeta, Kótóné ama hó dée daaló betere tiki ai ape. Jerusalem be hulua doi yólókélé momókó malo yao̧se. Ti noatepae, ai be huluata, fea ala fea tȩteróló kaae tare doasi topo whi̧ betere tikipó. ");
INSERT INTO ppo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Diaao̧ dere fo diriróturaalu, naase horóló kutiri teketere alakélé momókó yao̧se. Ti noatepae, naao topo niki mo beta̧kélé dȩ niki ó diliki niki biliranénipó. ");
INSERT INTO ppo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Dia̧né me ala mo ipa, ti ȩ́pó yalepótóró yae. Inipa, ti mo inipótóró yae. Naao ai dere fo mopó yó̧póló, mepaae kae kae ho̧ko fotamo touróló dereteita, ti dowi Satan-né yae yóló tȩnatepa dapó.” ");
INSERT INTO ppo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mo take yóló muló betepa, diaao̧ woseté wou betere fo i ape. ‘Whi̧ menétamo me whi̧ kele doratepa, ti menémo ama kelekélé dorae. Me whi̧nétamo me whi̧ sereke dukutepa, ti menémo ama serekekélé dukae,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ai fo mo epatei, ya̧lo dia̧paae i dere fo wosae. Me whi̧nétamo dia̧paae me dowi ala eratepa, ti diaao̧mo atimapaae momó tokó̧ matere ala yao̧se. Me whi̧nétamo ya̧ faamumó okolope deké supa, ti me tikiró faamumókélé dó̧póló yó melae. ");
INSERT INTO ppo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mepaae whi̧né ya̧tamo fo tokó̧tamo yóló, naao deró betere kuti sokotepa, ti me fo̧loi kutikélé só̧póló sókó melae. ");
INSERT INTO ppo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mepaae whi̧nétamo, ya̧paae 1 kilomitamó ama o̧la o̧la beleróló fae yóló sȩtepa, ti naaomo me beleróló, 2 kilomita alerae. ");
INSERT INTO ppo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Whi̧ menétamo ya̧paae me o̧lakó kematepa, ti ama ai kematere o̧la melae. Me whi̧nétamo naao me o̧lakó kapala asiri saai dapóló ya̧paae wosetepa, melaalomeipóló ama dere fo sisópaae erao̧se.” ");
INSERT INTO ppo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Taketi yóló muló betepa, diaao̧ woseté wou betere fo i ape. ‘Naao be whi̧ so whi̧paae yaala sókó furaalu, bóe whi̧ hó̧róló bóe du betae,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tépatei, ya̧lo dia̧paae i dere ape. Diaao̧ bóe whi̧rape hȩkesené sinóló yaala sókó furaalu, wisi ala erótu betae. Mepaae whi̧nétamo dia̧paae sekȩi ala eratepa, atétere whi̧ Tale Kótóné tao sóró, kisipa tiki wisi muló̧póló momarae. ");
INSERT INTO ppo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Atétepa, ti dia̧ ó hepen bemó betere diaao̧ Ayané naale senaaletóró betaalo ai ape. Talené suka dȩrótu betereteita, dowi ala dere so whi̧paaekélé, wisi ala dere so whi̧paaekélé erótu beterapó. Ama hali anatere alakélé, dowi ala du betere so whi̧ró donoi ala du betere so whi̧tamo wusurópaae anótua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Dia̧nétamo, mepaae dia̧ hȩsekené sukó̧ló yaala sókó fole so whi̧paae maaté yaala sókó fu beteretei doasi alapakó, Kótóné dia̧mó dupu melaalopóló de? Ti kale takis moni siré kotere whi̧rapenékélé atei kaae ala dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Diaao̧ mo no ne apupaae maaté naamei fo yóló, ko̧leó du betere-a, ai doasi alaé? Ti mepaae Kótó tuȩ́ inire so whi̧nékélé ai ala dua dapó. Tépatei, ha̧le mo so whi̧paaekélé naameiné ko̧leó du betepa, ti mo doasi ala ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Térapa, ó hepen bemó betere diaao̧ Aya a̧ me wisi ala ya̧ya̧ni, mo ti su̧ru ere kaae, dia̧kélé wisi alatóró eraté fóló, Talené ama ala mo ti su̧re whi̧ betae.” ");
INSERT INTO ppo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Diaao̧ du betere wisi ala so whi̧né kolóló dukiró̧póló, momókó yao̧se. Diaao̧ dere wisi ala tamo kolóló dukiró̧póló du betepa, ti ó hepen bemó betere diaao̧ Ayané melaaitere dupu saalomei ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Até yao̧sórópa, dia̧né mole o̧la o̧larape mepaae ya̧ya̧re so whi̧mó ha̧le melaai depa, ti tiki tua̧paae dorutei tó tikiné ha̧le siki̧litere whi̧rapené wisi ala dapó yó̧póló, du betere ala kaae mo yao̧se. Ti ai whi̧rapenéta, fo wosetere berapemókélé, tu̧ tómókélé, so whi̧né atima doi hale sóró horó̧póló kisipa mutu, touró betere so whi̧né keletómó dua dapó. Ya̧lo dia̧paae mo i dere ape. Atétere whi̧rape atima me dupu kaae saalomei, mo su̧mótóró ai sóró tare ape. ");
INSERT INTO ppo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Térapa, naao o̧la o̧la mepaae ya̧ya̧re so whi̧mó ha̧le melóló, ya̧lo etei kaae o̧la melalepóló kisipa yó tani, mo keterae. ");
INSERT INTO ppo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Diaao̧ mepaae o̧la o̧la ya̧ya̧re so whi̧mó materetei so whi̧ feané kelao̧sóró kikiti melae. Ti atéró kikiti dere ala keletere Aya Talené amatóró diaao̧ ai dere alamó dupu melaalopó.” ");
INSERT INTO ppo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Téyaalopa, diaao̧ Talepaae momaturaalu, tua̧paae dorutei wisire nisiyóló ha̧le siki̧litu betere whi̧rapené dere moma kaae mo yao̧se. Ti atimané momaturaalu, fo wosetere berapemókélé, doasi tu̧ tómókélé, so whi̧ feané dukiró̧póló dua dapó. Ya̧lo dia̧paae mo i dere ape. Atétere so whi̧né duputa me kae muni, mo su̧mótóró ai sere ape. ");
INSERT INTO ppo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Téni, Talepaae moma yaairaalu, naao be dolopaae fóló tu̧ kinóló bitu, kelené kilinire diaao̧ Aya Talepaae beta̧ momayae. Atétepa, ti kikiti kinóló dere ala keletere Ayané dia̧mó dupu melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Diaao̧ Talepaae momaturaalu, Kótóné ala kisipa inire whi̧rapené bete munire forape ha̧le ho̧ko deté fu dere kaae yao̧se. Ti atimané atéró fo̧lo si̧yóló dere momata, Talené wosaalopóló kisipa muóló dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Térapa, atimané ai dere ala kaae diaao̧kélé yao̧se. Ti noatepae, diaao̧ ya̧ya̧re o̧la a̧paae wosaai teópatei, diaao̧ Ayané ama mo kisiparapó. ");
INSERT INTO ppo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Térapa, diaao̧ Talepaae momaturaalu etéró yae. ‘Hepen bemó betere da̧né Aya-ó, Ya̧ta dowi ala mo beta̧kélé muniruraalu, naao ere ala mo kaepó. Téreteiné ya̧ta, fea alané bete Tale betepa, so whi̧né naao doi hale sóró horóló, mo doasi doi muló̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Naao tȩteróló kaae tare ao̧mó mole ala wisinaale wó̧póló yae. Naao kisipa mole ala ai hepen bemó irure kaae, i haemókélé atéró̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Da̧né mió i be dȩmó naaire o̧lakélé naao su̧mó a̧lae. ");
INSERT INTO ppo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mepaae whi̧rapené da̧paae erale dowi ala kwia da̧né tani, me o̧la meipóló ha̧le kemerótu yale kaae, da̧né dowi ala kwiakélé naao ha̧le kemerae. ");
INSERT INTO ppo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Da̧ me dowi ala yóló dée naaire tikipaae a̧lisóró fao̧sóró, naao seséyóló tu̧ wisitei yó mótu betae. Téturaalu, da̧ dowi ala yó̧póló sesemeratere bóe whi̧né só derao̧sórópa, ai tu̧ naao seséyóló da̧ tao sae,’ yóló dua yae. ");
INSERT INTO ppo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ti mepaae whi̧rapené dia̧paae erale dowi alatamo, me o̧la meipóló ha̧le kemeratepa, ti ó hepen bemó betere diaao̧ Ayané dia̧né yale dowi alakélé, ha̧le kemeraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Téyaalotei, mepaae whi̧rapené erale dowi ala me o̧la meipóló, diaao̧tamo ha̧le kemerénitepa, ti ó hepen bemó betere Ayané diaao̧ dowi alakélé, ha̧le kemeraalomeipó.” ");
INSERT INTO ppo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Diaao̧ Talepaae momayaairaalu, o̧la weyóló ha̧le betere sukamó, tua̧paae dorutei tó tikiné siki̧litere whi̧rapené dere ala su̧róló yao̧se. Ti so whi̧né atima mo wisirapó yó̧póló kisipa mutu, o̧la weyóló atimané kelepaa hu̧mula yóló bitua dapó. Ya̧lo dia̧paae mo i dere ape. Ai whi̧rape atimané duputa, me kae saalomei, mo su̧mó ai sere ape. ");
INSERT INTO ppo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tépatei, dia̧ moma yaai o̧la weyóló bituraalu, diaao̧ topo nikimó wel wȩi dilóo, diaao̧ kelepaakélé fokóo du betae. ");
INSERT INTO ppo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ti noa yao̧sóró meipó. Mepaae whi̧rapené dia̧ o̧la weyóló beterapóló kisipa yao̧sóró dapó. Diaao̧ kelené keleneire Ayané ama beta̧ diaao̧ ai kikiti dere ala kelerapó. Atére Aya Talené amatóró dia̧mó dupu wisi melaalo ai ape.” ");
INSERT INTO ppo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Dia̧ i haemó bituraalu, ekȩle yóló ita ya̧lo o̧lapóló, beta̧paae huatu betao̧se. Ti noatepae, i haemóta hoti dakóló ó dowi ero siné turukóló ó o̧lémi nokole whi̧rapenékélé kikiti be fulukóló sua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aténi, diaao̧ wisi wisi o̧la ó hepen bemó beta̧paaeróló mulaté holó̧póló yae. Ti ai bemóta ero sinékélé, hotinékélé doréni, o̧lémi nokole whi̧rapenékélé be fulukóló o̧lémi saalomeipó. ");
INSERT INTO ppo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ti naao wisi wisi o̧la mole tikimótóró naao hosaakélé mo turó ai mole ape. ");
INSERT INTO ppo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Naao keleta, ti tiki turó dȩró betere lamp sa̧ su̧ ai ape. Naao kele tamo wusuró wisipa, ti tiki turó dȩyó falapó. ");
INSERT INTO ppo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Téni, naao keletamo dilikipa, ti tikikélé turó dilikirapó. Naao tiki tua̧mó ere dȩtamo aluróló dilikipa, ti naao betere betekélé mo turó diliki yó falapó. ");
INSERT INTO ppo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Beta̧ kutó diratere whi̧nétei tȩteróló kaae tare whi̧ tamoné kutó diranénipó. Ti me whi̧né du, i kutó dirae, me whi̧nékélé i kutó dirae depa, atimaamo wusuróné kutó beta̧ whi̧né diraaire mo su̧nipó. Ti noatepae, me whi̧ hó̧róló me whi̧paaemo hȩkesené sinóló yaala sókó fole ala yaalo ai ape. Ó me whi̧paaemo doasi hȩkesené sinóló yaala sókó fóo, me whi̧mo hó̧róló sisópaae eróo yaalopó. Tétereteiné beta̧ whi̧tei Kótóné ala eratere whi̧ betóo, moni dia̧ tȩteróló kaae tare whi̧ ao̧róló, moniné kutó diratere whi̧kélé betóo, enénipó.” ");
INSERT INTO ppo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Térapa, ya̧lo dia̧paae i dere ape. Dia̧ betere beteta diaao̧ naaire o̧la ó wȩi nisiyóló ȩ noa naaloé? ó kuti noa deraaloé? yóló, whaalia du betao̧se. Ti ai o̧la o̧la-a, doasi o̧lapa whaalia du betere? Ya̧ betere beteta, ti mo doasi topo o̧la ai ape. Naao deró betere kuti-a doasi topo o̧lapa, whaalia du betere? Naao tikita, ti mo doasi topo o̧la ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Barapepaae eratere ala dia̧né kisipa muae. Atimané naaire o̧la wae bilitere ala ó o̧la sóró bepaae mulatere ala dua de? Tétumitei, ó hepen bemó betere diaao̧ Ayané atimané naaire o̧la su̧mó mótua dapó. Ti ai barapeta doasi o̧la meitei, ama tao sua dapó. Ti dia̧ so whi̧ta, mo doasi o̧la beterapa, ama kisipa keteraalopóló de? ");
INSERT INTO ppo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Me whi̧né ama whaalia dere alané a̧ bitiré faaire be dȩ ama su̧mó hi̧kili faranére? Mo meipó. ");
INSERT INTO ppo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Dia̧ kuti noa deraaloé yóló, whaalia du betere-a, kale ho̧ko yó mole nerape kisipa muae. Ti atima kémi bisikó̧ló kuti nomotere ala dumipó. Mo meipó. ");
INSERT INTO ppo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tépatei, ya̧lo dia̧paae i dere ape. Mió i yó mole nerapené ere au wisiné kale doasi topo whi̧ Solomon-né sua yale kuti wisinaalené ere aukélé mo teraae falapó. ");
INSERT INTO ppo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dia̧ tuȩ́ tiki tiratere ala tómó dakeró betere whi̧rape-ó, i haemó yó mole nerapeta, mió beta̧ yóló dóta, doyaaire o̧latei, Kótóné ama mo wisiyóló aurótua dapó. Ti Talené ai ne aurótu dere kaae, diaao̧ saaire kuti dia̧mó su̧mó melaalomeipóló du bitu de? ");
INSERT INTO ppo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Atérapa, o̧laró wȩitamo noa naaloé? ó kuti ȩ noa saaloé? yóló, whaalia du betao̧se. ");
INSERT INTO ppo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ti noatepae, ha̧le ho̧ko betó mole so whi̧rapené ai o̧la o̧larape saaitapóló doasi ketekȩ butu beterapó. Tépatei, dia̧né ai ya̧ya̧ du betere o̧la o̧lata, ó hepen bemó betere diaao̧ Ayané ama mo kisiparapó. ");
INSERT INTO ppo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Térapa, folosóró Kótóné ama tȩteróló kaae tare alaró, mo donoi ala wisinaaletamota, mo doasi bete mole alapa, ketekȩ buóló erótu betae. Atétepa, ti mepaae ya̧ya̧tere o̧la o̧lakélé fea Talené ama mo su̧mó melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Atérapa, dó be dȩmó noa ala yaaloé yóló whaalia du betao̧se. Ti dó be dȩmó yaaire alata, ai be dȩmótóró eró̧póló yae. Upaae bitiré faaire be dȩmó yaaire sekȩi ala, mió i be dȩmó dere alatamo tourao̧se.” ");
INSERT INTO ppo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Dia̧ Tale ao̧yóló mepaae no ne hamomané dere ala taleyóló só derao̧se. Ai ala deremó, Talené dia̧kélé taleyóló só derao̧sórópa taalae. ");
INSERT INTO ppo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ti noatepa meipó. Mepaae so whi̧paae dia̧né me noa kaae ala eróló tale itikimó, ti naao me whi̧paae ai erale ala mo su̧tóró Talené ya̧paaekélé eraalo ai ape. Naao me noa kaae ala me whi̧ hamomapaae erélipa, ti ai erale su̧tóró Talené ya̧paaekélé eraalopó. ");
INSERT INTO ppo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Naao kele dolomó doasi ni fake bupatei bunire ao̧yóló, naao no hamomané kele dolomó sawatamo bole mome kolóló, no-ó, naao kelemó ai bole mome sokaalopa maé dere fo-a, noatepa du betere? ");
INSERT INTO ppo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Naao kele dolomó bole doasi ni fake-a, sokoni ha̧le bupatei, me no hamomapaae naao kele dolomó bole mome sokotapa maé fo-a, noatepa du betere? ");
INSERT INTO ppo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tó tikiné wisire nisiyóló ha̧le siki̧li du betere whi̧rape-ó, folosóró naao kele dolomó bole doasi ni fakepi sokae. Atéró naao kele feléyóló, o̧la o̧la diriyóló kilituraalu, ti naao noné kele dolomó bole mome wisiyóló sokonérapó. ");
INSERT INTO ppo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kótóné ama mo kaae tukóló muló betere o̧la hao̧rape nó̧póló melao̧se. Meleke wisinaale hupurape daae mole tikipaae fesekée falao̧se. Dia̧nétamo ai ala depa, ti hupurapené hóné tȩiya tȩiya yóló, momó fesaae wouraalu dia̧tei dósuyóló naalo ai ape.” ");
INSERT INTO ppo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Dia̧ ya̧ya̧tere o̧la Kótópaae wosetepa, ti diaao̧ ai wosetere o̧la ama mo melaalopó. Me o̧lakó saai dapóló keketepa, ti diaao̧ keketere o̧la mo kólóló saalopó. Diaao̧ tu̧ tuki̧yae yóló tu̧ dupa, ti ama tu̧ tuki̧aalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mepaae so whi̧ atima ya̧ya̧tepa, wosetere o̧la mo sua dapó. Whi̧ me dené senée yóló keketere o̧la ti mo sua dapó. Tu̧ tuki̧yae yóló, tu̧ du betere so whi̧ fea be dolopaae wó̧póló, tu̧ tuki̧tua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","10","Dia̧ ai betó mole whi̧ beta̧né naalemané alimapaae aya-ó, okó a̧maletamo a̧lae depa ai kematere o̧la taaróló, kapo fake nae yóló melaaloé? ó yakó a̧lae depa, ai kematere o̧la meni whi̧ tukó nokole dowi wuli betepatei, nae yóló melaaloé? Meipó. ");
INSERT INTO ppo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Dia̧ i haemó dowi ala du betere whi̧rape bitutei, dia̧né naale senaalemó wisi wisi o̧la ha̧le matere ala ti dia̧ mo asarapó. Atére kaae, ó hepen bemó betere diaao̧ Ayanéta, mepaae whi̧ dené a̧paae kematere wisi wisi o̧la mo hamokoróló melatere alané, i haemó betere ayané matere ala mo ti bosene falapó. ");
INSERT INTO ppo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Térapa, Kótóné ama ko̧ló whi̧rapené ere foró Moses-né yóló muló betere fotamo fea touróturaalu, ere fo beteta me kaae mei ai ape. Kae kae ala yaairaalu, mepaae whi̧rapené ya̧paae eranée dere alatóró mepaae so whi̧paaekélé erótua yae.” ");
INSERT INTO ppo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Dia̧ sawatamo betekȩne tu̧ serekemó sókó fae. Mo ti aluyaaitere tikipaae faai fole tu̧ fake yóo, mo tu̧kélé doasi fake yóo erapó. Ti mo dekéró so whi̧ta, ai fakere tu̧tóróti sya fu beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Téretei, mo ti betó tawaaire tikipaae fole tu̧ta, so whi̧ feané kilini, beta̧ beta̧ so whi̧né maaté ai betekȩne tu̧ kekó̧ló sya fu beterapó.” ");
INSERT INTO ppo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Dia̧ kó̧paae fó̧póló, dilika̧ai Kótóné ama ko̧ló whi̧ ao̧yóló waalopa, mo hotowaró kaae tawae. Atima atéró wouraalu, kale sipsip hupu niki kaae bilipa mo hi̧ti nisiyaalotei, atimané tiki tua̧paaeta, ti whi̧ dóló nokole dowi bete hao̧né tiki daalapó. ");
INSERT INTO ppo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ti atima noa kaae whi̧ beterémóló, folosóró atimané dere alapi ka̧ae kolóló tuȩ́ yae. Ti noatepae, so whi̧né besa̧ae teketuraalu, ha̧le ho̧ko képimó olopa tekaaloé? Nose dukélé ha̧le ho̧ko nimó olopa tekaaloé? Mo meipó. ");
INSERT INTO ppo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Atétu dere kaae, wisi niné ti wisi du oleyóo, dowi niné ti dowi dutóró oleyóo, dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Wisi nimó ti dowi ni du oleyóo, dowi nimó wisi ni du oleyóo, dumipó. ");
INSERT INTO ppo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mepaae du wisiyóló woleneitere nirape feata, ti diyóló sipaae taae derótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Térapa, ai kale whi̧rapené du betere ala mo wisiyóló ka̧ae keletepa, ti atima etei kaae whi̧rape beterapóló, mo diriyóló kisipa yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","So whi̧ mo feané atima hepen-paae faalopóló kisipa muturaalu, ya̧lo doi yóló Tale-ó, Tale-ó, du betepatei, ai so whi̧ mo fea faalomeipó. Ai tua̧mótei, mepaae so whi̧ de ó hepen bemó betere ya̧lo Ayané ama kisipa mole ala sya fóló, erótu betere so whi̧ beta̧ mo su̧mó fenérapó. ");
INSERT INTO ppo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Taletere be dȩmó, mepaae so whi̧né ya̧lo doi yóló Tale-ó, Tale-ó, da̧ naao ko̧ló whi̧ bitu, so whi̧paae Kótóné fo i ape yóló yó melóo, naao doimó da̧né mepaae dowi keperape so whi̧ tua̧mó beteretei dóló ho̧kó falóo, mepaae kelemei alarapekélé eróo, du betalepó, yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ai fo depa, ya̧lo atimapaae ha̧keamó teraae faróló duraalu, ‘Dia̧ dowi ala du betale so whi̧-ó, dia̧ ȩ mo tuȩ́kélé inipa taae fae,’ yaalopó.” ");
INSERT INTO ppo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Tépatei, mepaae whi̧ dené ya̧lo fo mo wisiyóló wosóló, sya fóló eró tapa, ti kisipa tiki fosó fosóre whi̧né ama be tȩyaairaalu mo hae ka̧ayóló taae faróló, kapo tómó tȩtu dere kaae dapó. ");
INSERT INTO ppo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Atépa, doasi hali tiki wóo, wȩi milikélé wóo, doasi besȩ́ tikikélé wóo duraalu, ai bemó hairaletei tokó̧ fenipó. Ti noatepae, ai be kapo tómó tȩyaleteiné mo dirirapó. ");
INSERT INTO ppo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tépatei, mepaae whi̧rapené ya̧lo fo wisiyóló wosólótei sya fóló erénitepa, ti kale kolea koleare whi̧né wȩi atika̧ tómótei be ho̧ko tȩtu dere kaae dapó. ");
INSERT INTO ppo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Atépa, doasi hali tiki wóo, wȩi mili wóo, doasi besȩ́ tiki wóo duraalu, ai kale bemó hairale tikimó, mo ti kolokó felepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Téró, Yesuné ai forape yóló kemetepa, aimó wóló touró betere so whi̧ mo feané ama yó mótu betale fomó haió! yóló, siratu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ti noatepa meipó. Ama atéró yó mótu betale fota, Moses-né yóló muló betere fo yó matere whi̧rapené dere kaae yó meni, me doasi tȩteróló kaae tare whi̧né sóró beteratepa yó matere fo kaae, mo bete tokó̧ló yó matapó du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ai ala yóló kemetepa, Yesu a̧ ai du sokore ao̧mó beteretei taaróló, dorowou betalemó, so whi̧ mo feané a̧ sya wou betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","A̧ atéró daalemó, dowi humu fuluné tiki dore whi̧ a̧ beterepaae wóló, bukutiri teya̧ró bitu a̧paae woseturaalu, “Tale-ó, naao fotoko̧né ȩ wisiraai kisipa mutepa, ti mo su̧mó wisiranérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Atéró, Yesuné kale whi̧né tikimó naase mulóló duraalu, “Naao tiki doretei mió ya̧lo wisiraai dapa, mo ti wisi yae,” yalepó. Ai fo deretamo, ama tiki mo turó wisiyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Téró, Yesuné a̧paae duraalu, “Wosae, mió naao tiki ai wisi yalepa, ha̧le mo so whi̧paae i ala yalepó fo momókó yao̧se. Téni ya̧ fóló, Talepaae momaratere whi̧né maaté naao tiki fopeyó̧póló, yó melae. Téró, mo take Moses-né yóló muló betere fo sya furaalu, naao tiki wisirateremó Talepaae melae ere o̧la melae. Atimané ai ala kilituraalu, ita Talené eró beterapó fo yó̧póló dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Atéró, Yesu a̧ Kapeneam be huluamó sókó felemó, 100 Rom diki tare whi̧rape tȩteróló kaae tare topo whi̧ beta̧ wóló a̧paae duraalu, “Tale-ó, ya̧lo kutó diratere whi̧ beta̧ doasi hepo daalu ama tikikélé mo da̧amu sókó fóló, bemótóró ha̧le fió mulapó. Téruraalu, doasi dele su beterapa naao ȩ tao saaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ti fo depa, Yesuné a̧paae duraalu, “Ya̧lo a̧ wisiraai faalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ti fo depa, kale topo whi̧né a̧paae tokó̧ mótu duraalu, “Tale-ó, ȩ whi̧ wisi bitupakó ya̧ ya̧lo bepaae ape yaalomeipa, imó naao fonémaaté ama kisi bete wisiyae depa, su̧mó wisiyaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ti noatepa meipó. Ȩkélé ȩ tȩteróló kaae tare whi̧rape betepa, atima ao̧mó beterapó. Atéruraalu, ya̧lokélé mepaae diki tare whi̧rape tȩteróló kaae tarapó. Ai whi̧rapekó beta̧paae ya̧lo fae depa a̧ fóo, ape depa wóo dua dapó. Ya̧lo kutó diratere whi̧paae i kutó diyae depa, ama ai alatóró dua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesuné ai whi̧né dere fo wosóló, haió yóló siratu, a̧ sya wou betere so whi̧paae duraalu, “Ya̧lo dia̧paae mo i dere ape, i whi̧né doasi kisipa tiki tiró betere kaae ere whi̧ Israel hae kwiamó betepa, ya̧lo mo kilinipó. ");
INSERT INTO ppo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ya̧lo dia̧paae i dere fo wosae. Suka hoterepaae betere so whi̧kélé, suka doropolepaae betere so whi̧kélé, atimané be taaróló o̧la detere tikipaae wóló, atima beteró̧póló tukóló muló betere tikimó o̧la naai betaalopó. Atima atéró touróló, Abraham, Aisak, Jekop-sépitamo hepen bemó betere Kótóné tȩteróló kaae tare tua̧mó bituraalu, ai doasi detere o̧la atima fea beta̧mó nuku betaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Téyaalotei, mepaae so whi̧ Kótóné tȩteróló kaae tare ao̧mó ama naale senaale beteró̧póló yóló mulaletei, diliki tua̧mó beteró̧póló, belapaae ho̧kó deraalopó. Aimó doasi dele su bituraalu, atimatei yale alamópóló dekȩné sukó̧ló wole du betaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Téró, Yesuné kale doasi topo whi̧paae duraalu, “Naao kisipa tiki tiratere alatóró ya̧lo ya̧paae mo eraalopa, fae,” yalepó. Mo ai fo deremotóró kale whi̧né ama kutó diratere whi̧né kisi bete wisi ipakalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Téró, Yesu a̧ Pitané bepaae sókó felemó, Pitané ama somané hama sere tiki suputere kisiné sinóló mupa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Atépa kolóló, kale soné naasemó ama wolaa yó salemó, ama tiki supu du betale kisi bete wisitepa, kale so a̧ turukó holóló, Yesumó o̧la kaae sóró biliralepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Atéró, be dikiteretamo dowi kepe tepeyóló betó mole so whi̧ mo turó a̧ beterepaae dapesó wua depa, dowi keperape foné sua yalemó, sókó fua yóo, atima so whi̧ feané hepo betekélé mo ti wisitua yóo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ai alata ha̧le inipó. Kótóné ama ko̧ló whi̧ Aisaiané yóló muló betere fo dokonóturaalu yalepó. Ai fo i ape. “Da̧né momaare tikiró kisi betetamo fea ama tikimó sóró tokó̧ló aluraai walepó,” erapó. ");
INSERT INTO ppo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Atéró kelalemó, so whi̧ mo ha̧le o̧la kaae a̧ bopera̧le wapa, Yesuné ama yó matere whi̧rapepaae duraalu, “Da̧ wȩi kȩla tȩyóló uté tȩró faalopa fiépe,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Atétepa, Moses-né yóló muló betere fo yó matere whi̧ beta̧ a̧ beterepaae wóló duraalu, “Yó matere whi̧-ó, ya̧ mopaae fupa, ti ȩkélé ya̧ sya waalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ai fo depa, Yesuné a̧paae tokó̧ mótu duraalu, “Kale hao̧naraperó barapetamota, atima fitere tiki ai ere ape. Téretei, kale whi̧né Naalema a̧ beta̧ ama topo beleróló fitere tiki meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ti fo depa, ama yó matere whi̧ beta̧né duraalu, “Tale-ó, folosóró ya̧lo ayapi doura̧le faaipa, naao ȩpaae fae fo enére?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ai fo depa, Yesuné a̧paae duraalu, “Sinale whi̧rapeta, ti sinale whi̧rapenétóró douró̧pólópa, ya̧ ȩ sya ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Atéró, a̧ kale wȩi nukupaae biti̧ hotopa, ama yó matere whi̧rapekélé a̧tamo beta̧ nukupaae biti̧ holalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Atéró, atima wȩi tua̧mó fu betalemó, mo doakale hali tikiró besȩ́ tikitamo kilitainé hapale sókó walapó duraalu, wȩi asya wóló atima betere nuku dolopaae wȩi bosenée horóló, kale nuku buó deraai depatei, Yesu a̧ noke ha̧le fió molepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yesu atéró fipa, ama yó matere whi̧rapené a̧ turukuróló duraalu, “Tale-ó, da̧ felekemó wȩiné aluraai dapa, naao da̧ tao sae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ai fo depa, Yesuné atimapaae tokó̧ mótu duraalu, “Dia̧ noatepa wi du bitu de? Diaao̧ kisipa tiki tiró betere ala tómó ai ererapó,” yalepó. Tétepa, a̧ turukó holóló, kale wȩi asyaró besȩ́ tikitamopaae tikae yóló foné salepó. Atéyalemó, kale wȩi asyaró besȩ́ tikitamo tukóló ama ere kaae mo dono felepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Atétepa, kale whi̧rape atimasisitei duraalu, “Haió! i whi̧ta, noa kaae whi̧rópó. Kale wȩi asyaró besȩ́ tikitamonékélé mo whi̧né dere kaae, ama dere fo mo beta̧tóró wosóló, erótua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Atéró, Yesu a̧ uté tȩró tȩ fóló Kadarin hae kwiamó sókó felepó. Aimó dowi kepe tepeyóló betere whi̧ tamo whi̧ dourótua dere tikimó biti, a̧tamo hokolaa yaai dapóló walepó. Ai whi̧ tamo dowi kepené sesemeratepa doasi fopaae butu, sereke fisikó̧ sóró whi̧ daai du betepa, so whi̧ fea wituraalu ai tu̧mó fua inipó. ");
INSERT INTO ppo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Até du betere whi̧ tamoné fo fakeyóló duraalu, “Kótóné Naalema-ó, naao da̧mopaae noa alakó eraai waleé? Tukóló mulale suka teópatei, ya̧ ipaae da̧mo susupuraai waleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Téró, mepaae hupurape mo ha̧le o̧la kae mo umó kimimó daae molepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kale dowi keperape atima witepa Yesupaae kema duraalu, “Naaotamo da̧ dóló ho̧konaai depata, ti u hupurapené depe tua̧paae dotonaasepe,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Atéró, ama kale keperapepaae duraalu, “Dia̧ whi̧ tua̧mó beteretei taaróló sókó fae,” depa, atima kale whi̧né depe tua̧mó betaletei taaróló, hupurape tiki tua̧paae tepeyóló biti̧ fupa, kale hupurape fea botokó furaalu, kula dolomó derepeletikimó, wȩiné soroko̧ fóló kale hupurape sisiraae felepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Atétepa, ai hupu kaae tare whi̧rape atima ai ala kilitu, mo hapale doasi be huluapaae fóló, i kale whi̧ tamopaae erale alaró mepaae eratepa kelale alatamo so whi̧ feapaae yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Atétepa, ai be huluamó betó mole so whi̧ fea Yesu kelaai dapóló walepó. Atéró walemó Yesu betepa kilitu, atimané a̧paae ya̧ i hae kwia taaróló fae, yóló sȩtu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Atéró, Yesu a̧ wȩi nukupaae biti̧ holóló, ai wȩi kȩla tȩyóló a̧ betere be huluapaae felepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Atéró a̧ aimó betepa, mepaae whi̧rapené beta̧ tiki da̧amui whi̧ besekȩtamo turó Yesu beterepaae beleyóló walepó. Atétepa atima kisipa tiki tiróló wale ala Yesuné kolóló, kale tiki da̧amui whi̧paae duraalu, “Ti naale-ó, naao dowi ala kwia mió ya̧lo i kemeratapa whaalia ini, naao hosaa diriyóló dua betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ai fo depa, mepaae Moses-né ere fo yó mótu betere whi̧rape atima kisipanétei duraalu, “I whi̧né a̧ Kótó kaae beterapóló du betere foné, Kótóné doi doróló faletu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesuné atimané atéró mutere kisipa kolóló duraalu, “Diaao̧ atei kaae dowi kisipa noatepa mutu bitu de? ");
INSERT INTO ppo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Fo tamo mulapa, so whi̧né taleyóló mé fo diaao̧ enére? Naao dowi alamó saaire kwia ya̧lo aluratapó fo enérepé, ya̧ turukó horóló naao besekȩ sóró fae fo enére? Dia̧ tuȩ́ tekeyóló kisipa yae. ");
INSERT INTO ppo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Atérené i haemó betó mole so whi̧né dowi ala kwia tokó̧ló aluraaire fotoko̧ Whi̧né Naalemané su̧mó bulapóló, kisipa muó̧pólópa,” kale whi̧paae, “Ya̧ turukó horóló naao besekȩ sóró bepaae fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ti fo depa, kale whi̧ turukó holóló ama besekȩ sóró bepaae felepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Atétere ala aimó betó mole so whi̧ feané kolóló, atima doasi hokomó sókó furaalu sira yalepó. Mo whi̧né etei kaae ala yó̧póló Kótónétei sóró beteró beterapóló, ama doi hale sóró horalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Atéró Yesu a̧ ai hae tiki taaróló fu betalemó, takis moni siré kotere whi̧ Matyu takis moni saairaalu, tȩne furu bemó betepa kelalepó. Atépa ama a̧paae duraalu, “Ya̧ ȩ sya ape,” depa, kale sekȩ́ a̧ turukó horóló Yesu sya felepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Atéró, Yesu a̧ kale whi̧ Matyuné bemó betepa, takis moni siré kotere whi̧raperó mepaae dowi ala dere whi̧rapetamo mo turó wóló, Yesuró ama yó matere whi̧rapetamo fea touyóló o̧la nuku beterepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Atéró o̧la nuku betepa, mepaae Farisi whi̧rapené kolóló ama yó matere whi̧rapepaae duraalu, “Dia̧ yó matere whi̧-a, takis moni siré kotere whi̧raperó dowi ala dere whi̧rapetamotei, noatepa o̧la beta̧mó nuku bitu de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ai fo wosóló Yesuné duraalu, “Kisi daanire so whi̧ dokta beterepaae fumi, kisi daale so whi̧maaté fua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kótóné asȩyóló muló betere fo i ape. ‘Simó suku̧laa dalóló ha̧le matere ala Kótóné a̧ saai doasi hȩkeseni, ko̧lené sinóló ha̧le tao sere ala depa, ti a̧ mo doasi hȩkeserapó,’ erapó. Térapa dia̧ fóló, ai ere fo bete wosóló kisipa tekeyae. Ti ȩ waleteita, donoi ala dere so whi̧paae ape yaai anitei dowi ala dere so whi̧paae ape yaai walepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Téró, Jon-né yó matere whi̧rape Yesu beterepaae wóló a̧paae woseturaalu, “Da̧ró Farisi whi̧rapetamota me sukamó o̧la weyóló ha̧le bitua depatei, naao yó matere whi̧rapemo o̧la weyóló ha̧le bitinitere-a, noatepa de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ai fo depa, Yesuné atimapaae tokó̧ mótu duraalu, “Kale so dokaaire whi̧ a̧ ama fulumu whi̧rapetamo ha̧le betepatei, ama fulumu whi̧rape dekȩtu moló̧mó betaaloé? Téni, nalo kale so dokore whi̧ mené dapesó fupa, ti ama fulumu whi̧rape atima o̧la weyóló ha̧le betaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mo whi̧ beta̧nékélé, kisi kuti kwia sóró si kutitamo nomotumipó. Ti noatepae, kisi kuti kwia sóró deraakele kutitamo dakoróló nomonalemó, momó bisa̧ae fóló mo ti fake yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Whi̧ beta̧nékélé, kisi wain wȩi tepeturaalu, upulé moi hupu sekaȩné nomóló mole wutimó tepetumipó. Atéró tepetepa, ti kale moi hupu sekaȩmó tepeyale wain wȩi tóputuraalu, fulukó fóló wȩi sunée faalopó. Atéyao̧sóró, atima kisi wain wȩi tepeturaalu, ti kisi hupu sekaȩné aleale wutimótóróti tepetua dapó. Atétepa, ti kale wutiró wȩitamo wusuró mo wisiyóló muó tawaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Atéró ama fo teó du betepatei, beta̧ doasi topo whi̧ wóló a̧ daalemó bukutiri teya̧ró bitu duraalu, “Doa whi̧-ó, ya̧lo senaale mo miótóróti sinalepó. Téyaletei, ya̧ wóló ama tikimótamo naao naase mulatepata, ti a̧ mo kepaanérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Atétepa Yesu a̧ turukó horóló kale whi̧tamo fupa, ama yó matere whi̧rapekélé felepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Até deretamo, beta̧ so wéliéné du betepatei, 12 ba fo kemere so Yesuné sisóró sókó wóló, ama deró betere kuti salemó wolaayalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kale soné ama i kisipa mualepó. “Ya̧lotamo ama kuti salemó wolaatepa, ti ya̧lo kisi bete su̧mó wisiyaalopó.” ");
INSERT INTO ppo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tétepa, Yesu a̧ fetée fóló kale sopaae duraalu, “Ti senaale-ó, naao kisipa tiki tirale alané naao kisi bete wisiralepa, hosaa tua̧mó sekȩni, diriyóló dua fae,” yalepó. Ai fo deremótóró kale soné kisi bete mo ti wisiyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Atéró, Yesu a̧ kale doasi topo whi̧né be dolopaae sókó felemó, so whi̧ fea fo tiki whaa du bitu, fó wuti hale yóló moló-u du betepa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Até du betepa, Yesuné atima foné sóró duraalu, “Ai senaaleta sukuni, a̧ noke firapa dia̧ taae fae,” deremó atimané a̧ do̧ nalalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Atéró, ai touró betere so whi̧ fea belapaae ho̧kó deróló, Yesu a̧ kale senaale mole be dolopaae fóló, kale senaalené naasemó tao salemó, a̧ mo ti suka̧letei momó kepaayalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Atéró, Yesuné i ala yalepóló, ai be hulua feapaae deté kwȩyóló fakeralepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Atéró Yesu ai be taaróló fu betalemó, kele dilikire whi̧ tamoné a̧ sya wou fo fakeyóló duraalu, “Depit-né deté yale whi̧né Naalema-ó, naao da̧mo ko̧lené sukutu tao sae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Atétepa, Yesu a̧ be tua̧paae sókó fi tikimó nalo kale kele dilikire whi̧ tamo a̧ beterepaae wapa, atimaamopaae woseturaalu, “Ya̧lo diaamo su̧mó wisiranérapóló kisipa mute?” depa, atimaamoné duraalu, “Tale-ó, naao fotoko̧né da̧mo mo su̧mó wisiranérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ai fo depa, ama kale whi̧tamoné kelemó wolaa yóló duraalu, “Diaamoné kisipa tiki tiró betereteiné i wisiratere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ai fo yalemó, kale whi̧tamoné kele fisa̧ae fóló wisitepa Yesuné atimaamopaae fo mulóló duraalu, “Ya̧lo diaamopaae i erale ala so whi̧paae momókó deté kwȩyao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Téyaletei, atimaamo be hulua feapaae fóló, Yesuné i ala yalepóló deté kwȩyóló fakeralepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Atéró kale whi̧tamo fi tikimó, dowi kepe tepeyóló bituraalu ko̧ló nomóló fokélé initere whi̧ beta̧ Yesu beterepaae dapesó walepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Atétepa, Yesuné kale dowi kepe dóló ho̧konaletikimó, kale ko̧ló nomóló betale whi̧tei, fo kaae sóró yalepó. Atéteremó, so whi̧ feané kolóló siraturaalu, “Take bitiré wale alimó etei kaae ala Israel hae kwiamó depa mo kolókélé inipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ai fo depa, kale Farisi whi̧rapené duraalu, “Ai dowi keperape dóló ho̧konaleteita, dowi keperapené doasi topo whi̧né fotoko̧ratepa, dóló ho̧konótua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Atéró etéyalepó. Yesu a̧ doasi be huluapaaekélé, sawa be huluapaaekélé, ai be huluamó tȩ mole fo wosetere berapemókélé, Kótóné tȩteróló kaae tare ao̧mó mole ala i ape yóló, kale mió wosetere kisi fo wisi yó melaté kwȩyóo, mepaae tiki momaare whi̧raperó hepo daale whi̧rapetamokélé wisiraté kwȩyóo yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Téró, so whi̧ mo ha̧le o̧la kaae betó mupa kelalemó, atima tao saaire whi̧kélé meiruraalu, bokonaale sipsip hupurape ao̧yóló betó mupa, Yesu ko̧lené sukutu ama hosaamó salepó. ");
INSERT INTO ppo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Atépa ama yó matere whi̧rapepaae duraalu, “Kutómó ere o̧lata, mo dekéró u̧luméretei o̧la saaire whi̧ beta̧ doaló meipó. ");
INSERT INTO ppo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Térapa, ai kutómó u̧lumére o̧la saaire whi̧rape dotonó̧póló, ai kutó Talepaae wosae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Atéró, Yesuné ama yó matepa wosetere 12 whi̧rape a̧ beterepaae ape yalepó. Mepaae so whi̧ tua̧mó betere dowi kepe ho̧kó falóo, mepaae kae kae hepo daale so whi̧ró tiki momaare so whi̧tamo wisiróo yó̧póló, atima fotoko̧ mo su̧mó bulóló sóró beteralepó. ");
INSERT INTO ppo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Ama ai sóró beterale 12 aposel whi̧né doirape i ape. Folosóró sale whi̧ta, Saimon doi mupatei, Pitapó du betere whi̧ró ama noma Andrutamo yóo, Sebediné naalema tamo Jems-ró noma Jon-tamo yóo, Filip-ró Batolomiu-tamo yóo, Tomas-ró takis moni siré kotere whi̧ Matyu-tamo yóo, Alpias-né naalema Jems-ró Tadeus-tamo yóo, ka̧lo ka̧loi whi̧ Saimon-ró Iskariot be whi̧kó Yesu dó̧póló eleké deyale whi̧ Judas-tamo yóo yóló, atima atérópó. ");
INSERT INTO ppo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesuné ama dosa̧ayóló sóró beteró betere 12 whi̧rape dotonaairaalu, folosóró atimapaae i fo yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","“Juda fake mei, kae fakené be huluaró Samaria whi̧rapené be huluatamopaae feni, sipsip hupu kaae fókó fale Israel fake beterepaae fae. ");
INSERT INTO ppo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dia̧ furaalu, i fo so whi̧ feapaae ha̧keamó yó maté kwȩyae. Hepen bemó betere Kótóné tȩteróló kaae tare ao̧mó mole ala wóló, mió mo felekemó i mole ape. ");
INSERT INTO ppo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mepaae kisi daae mole so whi̧ wisiróo, sinale so whi̧rape kepaaróo, mepaae humu fuluné tiki dore so whi̧ wisiróo, tiki tua̧móbetere dowi kepe doló ho̧konóo, yae. Ai ala yaaire fotoko̧ diaao̧ moniné dupuyóló sini, ya̧lo dia̧paae ha̧le melalepó. Téyalepa, diaao̧mo me dupu sini, so whi̧ ha̧le tao sóró wisiraté kwȩyae. ");
INSERT INTO ppo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Dia̧ atéró furaalu, kold ó silpa ó kopa moni sóró fao̧se. ");
INSERT INTO ppo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Naao wa ó tómó deró betere kuti, ó horó betere hó be, ó dotó tikikélé tawóló fao̧se. Ti noatepae, ai kutó diratere whi̧rape atimané naaire o̧lakélé, ó fiyaaire bekélé ti ai be talenétóró melatepa ti mo wisirapó. ");
INSERT INTO ppo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Dia̧ mé doasi be huluamó ó sawa be huluamó sókó fupa, ti mo wisi kisipa mole whi̧kó aimó beterémóló kelenaalemó betepa, ti mo ai whi̧tamotóró bitiré fóló, dia̧ me bepaae furaalu, ti ai be taalae. ");
INSERT INTO ppo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Dia̧ ai whi̧né ama bemó sókó huturaalu, atimapaae ko̧leó, Talené dia̧ wisiró beterapa, hosaa muni deyóló dua betae fo yae. ");
INSERT INTO ppo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ai be talerape wisi kisipa mole whi̧tamo betepa, ti dia̧né hosaa muni deyóló mo dua betae dere foné atima su̧mó tao sóró wisiraalopó. Atima wisi tuȩ́ mole whi̧tamo bitinipa, ti dia̧né hosaa muni deyóló dua betere ala wisinaale ha̧le besekéréni, dia̧paae momó fesaae wó̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mepaae whi̧nétamo dia̧ wisiyóló dape sini yóo, diaao̧ yó matere fokélé wisiyóló woseni yóo depa, ti dia̧ ai betere be, ó doasi be hulua taaróló faairaalu, atimané ai be hae diaao̧ hómó dakepatei fao̧sóró, aimó terepée deróló fae. ");
INSERT INTO ppo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ya̧lo dia̧paae mo i dere ape. Kótóné taleyóló kwia melaaire sukamó, dia̧ wisiyóló dape sinitere be huluamó betó mole so whi̧paae eraaire sekȩi alata, Komoraró Sodom be huluatamomó betó muale so whi̧paae eraaire sekȩ bosenóló, mo doakale dowi sekȩ melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Dia̧ta, kale bete hao̧ betó mole tua̧paae sipsip hupu kaae ya̧lo i dotonatere ape. Térapa, dia̧ wuliné kisipa kaae fosó fosó irutei, dia̧ me dowi ala muniru, kale ba ho̧kóserape kaae, naame yóló mo dua betae. ");
INSERT INTO ppo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ti noatepae, mepaae whi̧rapené kae kae sekȩi ala dia̧paae mo eraalopa, dia̧ mo hotowayóló kaae tawae. Téturaalu, atimané dia̧ fo tokó̧tamo yóló taletere whi̧rapené naase tua̧paae mulóo, atimané fo wosetere berape tua̧mókélé dia̧ susupuróló fokosói ala yóo yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dia̧ ya̧lo doi erótu beteremó, tȩteróló kaae tare Gavman whi̧raperó doasi topo whi̧rapetamo beterepaae fo tokó̧tamo yaai dapesó faalopó. Atéró, fo tokó̧lo dere ala Juda meire so whi̧nékélé wosóló kisipa yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Téyaalotei, atimané dia̧ dipula beteraai dapesó fupa, dia̧ noa fo yaaloé ó fo neyóló yaaloé yóló, whaalia yao̧se. Atéró fo tekȩtere be dȩmótóróti diaao̧ yaaire fo Tale Kótóné ama yó melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ti atéró yaaitere fo dia̧né kisipané yaalomeitei, diaao̧ Ayané ama Kepe Wisiné i fo yae yóló yó mótu betepa, yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Me whi̧né ama nomatei me whi̧né dó̧póló eleké deyaalo ai ape. Beta̧ whi̧né ama naale senaale me whi̧né mo ti dóló sukunó̧póló eleké deyaalo ai ape. Naale senaalené hama alimatamo bóe dóló só deróló, mepaae whi̧né dó̧póló melaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Dia̧ ya̧lo ala erateremó, so whi̧ feané dia̧ hó̧róló, bóe du betaalo ai ape. Tétu betepatei, whi̧ me detamo ai sekȩi ala ha̧le beleté fóló kemetere kwiapaae sókó fupa, ti atétere so whi̧ aluyao̧sóró, ya̧lo tao saalopó. ");
INSERT INTO ppo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Dia̧ ai be huluamó sókó fȩlalemó, ai be hulua so whi̧né dia̧tamo bóe dóló dia̧paae susupui ala eratepa, ti ai be taaróló me be huluapaae botokó fae. Ya̧lo dia̧paae mo i dere ape. Ai Israel fakené be huluarape doko̧ fea kwȩyóló kemeréni teó kutu betepatei, kale Whi̧né Naalema sókó waalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Beta̧ skul naalené a̧ yó matere whi̧ ama tȩteranénipó. Atétere kaae, kutó diratere whi̧nékélé a̧ tȩteróló kaae tare whi̧ ama tȩteranénipó. ");
INSERT INTO ppo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kale skul naale a̧ kisipa siré fóló, ama kisipare alakélé a̧ yó matere whi̧né kisipare alatamo beta̧ su̧ yóo, kale kutó diratere whi̧né dere alakélé a̧ kaae tare whi̧né dere alatamo beta̧ su̧ yóo epata, ti mo wisirapó. Mo so whi̧né be tale kilituraalu, a̧ta dowi keperapené doasi topo kepe Belsebul-pó du betepa, ti ama be whi̧ so whi̧paaekélé beta̧ kaae eratere fotóró yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Atérapa, atima ai whi̧rape kolóló wiyao̧se. Ti noatepae, mió kinóló mole o̧la o̧larape fea take ha̧kearatepa kelaalopó. Kinóló mole ala ó fo so whi̧ feané kisipa yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ya̧lo dia̧paae dilikitamo yó mótu betere fota, ti be dȩtamo ha̧keamó yae. Diaao̧ kikiti wosȩ́li dolomó du betere fo ti so whi̧ feané wosó̧póló, siki bemó daalu ha̧keamó yó melae. ");
INSERT INTO ppo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ti diaao̧ kepe bete doréni, mo tó tikimaaté sukó̧póló dele mo whi̧rape koróló, dia̧ wiyao̧se. Téni, naao tikiró kepe betetamo wusuró dowi si duku beterepaae taae deranére Talepaae beta̧ wiyae. ");
INSERT INTO ppo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Whi̧rapené ba male tamo duputuraalu, sonaai moni kené dupu dua dapó. Téretei, diaao̧ Aya Kótóné ama kisipané ai ba beleka̧amale haepaae derepae initepa, ti haepaae derepenénipó. ");
INSERT INTO ppo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Diaao̧ topomó bilire niki feata, Tale Kótóné ama dosa̧ayóló mo tuȩ́rapó. ");
INSERT INTO ppo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Atérapa, dia̧ whaalia yóló wiyao̧se. Ti i haemó betó mole ba beleka̧atiki kolósu, dia̧ kolósu depa, dia̧ta mo doasi o̧la ereteiné Kótóné ama dia̧ kisipa keteraalopóló de? Mo meipó. ");
INSERT INTO ppo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mepaae whi̧ denétamo amatei, so whi̧ feané keletómó, ȩta Keriso whi̧ beterapó depata, ti atétere whi̧ ó hepen bemó betere ya̧lo Ayané keletómó ita ya̧lo ne nopó yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Téyaalotei, mepaae whi̧ dené so whi̧ feané keletómó, ȩta Keriso whi̧ meipó depa, ti ya̧lokélé hepen bemó betere ya̧lo Ayané keletómó a̧ ya̧lo ala eratere whi̧ meipó yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ȩ i haepaae waleteita, ti i haemó betó mole so whi̧ fea bóe dele ala taaróló, dua beteró̧póló wale nisiyao̧se. Téni, i haemó betó mole so whi̧ tua̧mó tekeróló me fake kae beteróo, me fake kae beteróo yaairaalu walepó. ");
INSERT INTO ppo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ȩ wóló betere bete i ape. ‘Naaleró alimatamo tua̧mó tekeróló bóe delóo, senaaleró hamatamo betere alakélé tua̧mó tekeróló bóe delóo, whi̧né dokore soné ama hyama seretamo bóe dóo, yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Whi̧ mené ama fake so whi̧ ó a̧tamo beta̧mó betere so whi̧nétei, a̧tamo bóe daalo ai ape,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mepaae whi̧ dené ȩ sisópaae eróló, ama alima ó hamapaae doasi hȩkesené sukó̧ló yaala sókó fu betepa, ti atétere so whi̧ ȩtamo beta̧mó betaaire su̧nipó. Mepaae whi̧ dené ama naale ó senaalepaae yaala sókó furaalu, ȩ sisópaae eratepa ti atétere so whi̧ ȩtamo beta̧mó betaaire su̧nipó. ");
INSERT INTO ppo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mepaae whi̧ dené a̧ suka̧aire filipaa ni amatei beleyóló ȩ sya a̧nitepa, ti ai so whi̧ ya̧lo fo wosetere so whi̧ betaaire su̧nipó. ");
INSERT INTO ppo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mepaae whi̧ dené ama betere bete me ala yao̧sórópóló, amatei hotowayóló kaae tapa, ti atétere whi̧né ama betere bete aluyaalo ai ape. Mepaae whi̧ dené ya̧lo ala eraairaalu, ama betere bete me o̧la meipóló aluratepa, ti atétere whi̧né ama betere bete aluni, ha̧le muó tawaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Whi̧ me dené dia̧ wisiyóló dape sóró kaae tatepa, ti ȩtei wisiyóló dape sirapó. Mepaae whi̧ dené ȩ wisiyóló dape supata, ti ȩ dotȩyale sekȩ́ ya̧lo Ayatei wisiyóló dape sirapó. ");
INSERT INTO ppo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Whi̧ me dené mepaae whi̧ kilituraalu, Kótóné ama fo eratere ko̧ló whi̧póló, mo wisiyóló dape supa, ti atétere whi̧né Kótóné ama ko̧ló whi̧né sere dupu su̧tóróti saalopó. Whi̧ me dené mepaae whi̧ kilituraalu, a̧ta mo donoi ala dere whi̧póló mo wisiyóló dape supa, ti atétere whi̧né kale mo donoi ala dere whi̧né sere dupu su̧tóróti saalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ya̧lo dia̧paae mo i dere ape. Whi̧ me denétamo mo belei sokótei betere whi̧ ya̧lo ala erótu betere whi̧póló siri wȩi nae yóló melatepa, ti ai ala deremó dupu ha̧sókó feni, motóró saalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Atéró, Yesuné yó matere 12 whi̧rapepaae fo yó melóló kemetepa, ai betere tiki taaróló, a̧ Kaleli hae kwiamó tȩ mole be huluapaae felepó. Atéró fóló, ha̧le mo betó mole so whi̧paae kale kisi fo wisi yó melóo, ama fo wosetu betere so whi̧paaekélé yó melaté kwȩyóo yaairaalu felepó. ");
INSERT INTO ppo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Kale Jon dipula bitu, Yesu Kerisoné i ala du beterapóló deté kotere fo wosóló, ama yó matere whi̧rapepaae I fo wasae yóló dotȩyalepó. “Ya̧ta kale waalopóló bope du betale whi̧ hi̧tipé, whi̧ me kae wó̧póló kaae tawaaloé yóló wosene fae,” yalepó. Atétepa, kale Jon-né dotonale whi̧rape fóló, Yesupaae wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tétepa Yesuné atimapaae duraalu, “Dia̧ Jon beterepaae fóló, diaao̧ wosale foró kelale alatamo a̧paae yó móturaalu, i fo yae. ");
INSERT INTO ppo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kale kele diliki yóló betale whi̧rape wisiróo, hó doyóló betale whi̧rape wisiróló falóo, mepaae dowi humu fulu dorowóló betale whi̧rape wisiróo, wosȩ́li ki̧ne so whi̧ tukwȩ falóo, mepaae mo ti sinale so whi̧tei kepaaróo, yoleale yóló betere so whi̧paae kale kisi fo wisi yó mótu betóo, du beterapó ene fae. ");
INSERT INTO ppo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mepaae whi̧tamo ya̧lo du betere ala kolóló, ȩ sya waletei hó̧turaalu, dée nénitere whi̧ ti Kótóné wisiratepa, hai̧né sukutu beteró̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Atéró, kale Jon-né ama yó matere whi̧rape fi kinipaae, Yesuné Jon-né du betere alamó tuȩ́ muturaalu, aimó betó mole so whi̧paae yó melaai duraalu, “So whi̧kélé bitinire ha̧le kópu ka̧ae fi hae tikipaae fua yaletei-a, noakó kȩle fua yaleé? Besȩ́né féporótu betere kape kelaai fua yaleé? Mo meipó. ");
INSERT INTO ppo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Dia̧ upaae noakó kelaai fua yaleé? Whi̧ beta̧ mo kuti wisinaale deróló betepa kȩle fua yaleé? Meipó. Atei kaae kuti wisinaale deró betere whi̧ta, ti kale doasi topo whi̧rape bitua dere tiki dokélé ini, mo sisi yóló soroko̧i be wisinaalemó bitua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Téretei, dia̧ noakó kȩle fua yaleé? Kótóné ama ko̧ló whi̧ kelaai dapóló fua ipa, ti a̧tóróti mo hi̧ti ai ape. Ya̧lo dia̧paae mo i dere ape. Kótóné ama ko̧ló whi̧rape fea beteretei, ai whi̧né ama ditere kutóné mepaae ko̧ló whi̧rapené ditere kutó mo bosene falapó. ");
INSERT INTO ppo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ai sekȩ́mó kisipa mutu, Kótóné asȩmó i fo erapó. ‘Ya̧ waai teópa ya̧lo fo eraaire whi̧ folosóró a̧pi wó̧póló dotȩyaalopó. Ai whi̧né amata, ya̧ waaire tu̧ donoróló wisiraalopó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ya̧lo dia̧paae mo i dere ape. I haemó betó mole sorapené deyale whi̧rapekélé fea betó moletei, kale wȩi tópuratere whi̧kó Jon-né atima fea tȩteróló bosene falapó. Tépatei, Kótóné tȩteróló kaae tare ao̧mó belei sókó deóló betere whi̧né ti kale wȩi tópuratere whi̧ Jon tȩteró beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kale wȩi tópuratere whi̧ Jon betale alimó kaae sóró, hepen bemó betere Kótóné tȩteróló kaae tare ao̧mó mole ala mo doasi fotoko̧tamo wouraalu, fakeraté wou beterapó. Ai ala saairaalu, ketekȩ buóló bóe du betere whi̧rapené ai ala kekeparó fasó sua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kótóné ama fo eratere ko̧ló whi̧raperó Moses-né asȩre fotamoné Kótóné i ala yaalopóló yó maté wóló, kale wȩi tópuratere whi̧kó Jon betale alimó sókó walepó. ");
INSERT INTO ppo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Térené diaao̧ kisipanétamo waalopóló kale bopetu betale whi̧ Elaijata Jon a̧tóróti hi̧tipóló kisipa mutupa, ti mo wisirapó. ");
INSERT INTO ppo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","So whi̧ de wosȩ́li daapa i dere fo mo wisiyóló wosóló kisipa muae. ");
INSERT INTO ppo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mió i alimó betó mole so whi̧ etérapóló bete kisipa yó̧póló, ya̧lo noa ala su̧róló yaaloé? Atimata, etei kaae naale senaale kaaené kelerapó. So whi̧ toura̧leta dere tikimó bituraalu, mepaae naale senaalené mepaae naale senaalepaae melaa yaalopa ape yóló etei fo dapó. ");
INSERT INTO ppo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Da̧né fó wutiné haleratepa, dia̧né mepaae wole forape yóló sama kilini yóo, da̧né mepaae wole forape depa diaao̧ moló ini yóo yaletei-a, noatepa ha̧le daae mualeé?’ dua dapó. Ai kale keteirapené dere ala kaaetóróti diaao̧kélé ai du betere ape. ");
INSERT INTO ppo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kale wȩi tópuratere whi̧ Jon wóló beteretei o̧lakélé, wain wȩikélé nénitere ala mepaae so whi̧né kolóló, ama depe tua̧mó dowi kepe bituraalu dapó dua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kale Whi̧né Naalema wóló bitu, o̧laró wȩitamo nokole kilitu, so whi̧ feané ai whi̧ta, o̧lakélé wain wȩikélé dekéró nuku betere whi̧pó. A̧ta, kale takis moni siré kotere whi̧raperó dowi ala dere whi̧rapetamoné fulumu whi̧pó, ai du betere ape. Tétu beteretei, mepaae whi̧né ama dere ala ka̧ae kolóló, ai whi̧ta Kótóné mo dotoróȩ fale kisipa muluraalu dapó yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Téró, Yesuné ama kae kae kelemei alarape erale be huluarapemó betó mole so whi̧ dowi ala taaróló, Talepaae kisipa tiki feteyóló bitini yalemó, ai so whi̧ só deraai yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Atéró ama duraalu, “Korasin be huluaró Betsaida be hulua so whi̧rapetamo-ó, dia̧ tua̧paae mo dowi sekȩi ala waalo ai ape. Ya̧lo dia̧ tua̧paae erótua yale kelemei alarape kaaetamo, Tair be huluaró Saidon be huluatamomó erólua̧sóró, ti atimané dowi ala mo taketitei taaróló, tuȩ́ tiki feteyóló kili diyóló yei kutitamo bitua̧pó. ");
INSERT INTO ppo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ya̧lo dia̧paae mo i dere ape. Tale Kótóné taleyóló kwia matere sukamó, Kótóné i haemó betó mole so whi̧paae kwia matere alata, ti kale Tair be huluaró Saidon be huluatamopaae melaaire kwia mo bosene faalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Dia̧ Kapeneam be huluamó betó mole so whi̧-ó, dia̧ ó sa̧paae holaalopóló kisipa mute? Mo meipó. Dia̧ta, mo apaae derepale dolopaae Kótóné sóró deraalo ai ape. Dia̧ ai Kapeneam be hulua tua̧mó erale kelemei alarape kaae, Sodom be hulua tua̧mó erólua̧sóró, ti ai be hulua dorólua̧meipó. Miókélé ha̧le tȩ tawua̧pó. ");
INSERT INTO ppo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Téretei, ya̧lo dia̧paae i dere ape. Tale Kótóné Sodom so whi̧ taletere sukamó doasi kwia melaalotei, dia̧paae eraaire sekȩi alata, ti bosenóló mo doasi ala eraalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Atéyale sukamó, Yesuné ama Alima Kótóné doi hale sóró horóló duraalu, “Sa̧ró i haetamo tȩteróló betere Aya Tale-ó, naao mió i alimó yó mótu betere alarape feata, doasi kisipa sóró betó mole whi̧rapené kelao̧sóró hyó̧ mulóló, i naale beleka̧atikiné maaté koló̧póló, ha̧keamó yó melaleteiné ya̧paae mo kée dapó. ");
INSERT INTO ppo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aya-ó, mo dapó. Ti ai alata, mo naao kisipa mole alatóróti ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Fea alata, ya̧lo tȩteróló kaae tanó̧póló, ya̧lo Ayané ȩpaae meló beterapó. Mo whi̧ beta̧nékélé Naalema kisipa initei, Alimané ama beta̧ kisiparapó. Térure kaae, mo whi̧ beta̧nékélé Alima kisipa initei, Naalemané beta̧ ama Alima kisiparapó. Naalemané ama kisipa mole so whi̧paae ya̧lo Ayata, etei kaae Tale beterapóló, yó matere so whi̧né maaté tuȩ́ yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Dia̧ mepaae whi̧ sekȩi o̧la beleyaletikimó, fóturuyóló bétu betere so whi̧-ó, dia̧ sa̧a nóló mo dua betaaire ala ya̧lo melaalopa, ȩ beterepaae ape. ");
INSERT INTO ppo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ya̧lo hu̧lumó belere ni fake beleyóló, da̧mo wusóró furaalu, ya̧lo dere ala kolóló kisipa sae. Ti noatepae, ya̧lo hosaa tua̧mó mole naamei ala wisi diaao̧ kisipa yaasepóló, yó melaalopa, ape. Até depata, ti diaao̧ hosaa muni deyóló mo dua betaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ti noatepae, ya̧lo kutó ditere alaró beleyóló fole o̧latamo sekȩni, mo esepelérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Atéyale sukamó, Yesuró ama yó matere whi̧rapetamo whit kutó tua̧mó kutu betalepó. Téyalemó, ama yó matere whi̧rape wotetepa sa̧a nó̧póló da̧le muló betere sukamótei, kale ai kutómó yó mole whit du ka̧aesu yóló nukulé fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Atei ala depa, Farisi whi̧rapené kolóló Yesupaae duraalu, “Naao yó matere whi̧rapené sa̧a nóló beteró̧póló tukóló muló betere be dȩmótei, kale yóló muló betere fo tukóló, o̧la ai su betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ai fo depa ama atimapaae duraalu, “Depit-ró ama fulumu whi̧rapetamo atima wotetepa yale ala diaao̧ dosa̧ayóló, kisipa muni airapó. ");
INSERT INTO ppo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A̧ Kótóné be tua̧paae holóló bituraalu, mo kae muló betere bred o Depit-ró ama fulumu whi̧rapetamo atima wotepa sóró nalepó. Ti ai ota, Kótópaae melaletei, mo ha̧le whi̧rapené nao̧sóró fo mupa, Kótópaae momaratere whi̧rapené maaté nukua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Moses-né yóló muló betere fo sya furaalu, momatere be kaae tare whi̧rape kale da̧le muló betere sukamótei atimané ditere kutó diyaai be dolopaae fua dapóló, ere fo diaao̧ dosa̧ayóló kisipa muni airapó. Ti kale yóló muló betere fota, mo tikitu betepatei, me dowi ala yalepóló inipó. ");
INSERT INTO ppo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ya̧lo dia̧paae mo i dere ape. Kótóné ama momatere beta, doasi o̧lapatei, Kótóné ama ala erótu betere sekȩ́ró, mió ama erótu betere alatamoné ai momatere be tȩteróló teraae falapó. Atére sekȩ́ta, mió dia̧tamo beta̧mó i betere ape. ");
INSERT INTO ppo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tale Kótóné i fo asȩyóló muló beterapó. ‘Kale sipsip hupu ó me o̧la simó suku̧laa daróló momaratere alata, ti ya̧lo hȩkesere ala meipó. Me whi̧ ko̧lené sinóló tao sere alata, ti ya̧lo hȩkesere alapó,’ erapó. Ai fotamo dia̧né tuȩ́ ua̧sóró, ti dowi ala munire whi̧rape só derólua̧meipó. ");
INSERT INTO ppo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ti noa betené meipó. Kale Whi̧né Naalemata sa̧a nóló beteró̧póló, da̧le muló betere be dȩ tȩteróló kaae tare Tale beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","10","Téró Yesu a̧ aimó betaletei taaróló, atimané fo wosetere be tua̧paae sókó felemó, aimó beta̧ naase dowi whi̧ betepa kelalepó. Atima mepaae so whi̧né a̧ dowi ala yale whi̧póló só deraaire bete kikitu Yesupaae woseturaalu, “Sa̧a nóló beteró̧póló da̧le muló betere sukamótei, whi̧ wisiratere ala depa fo mulepé meié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ai fo depa ama atimapaae duraalu, “Dia̧kó whi̧ me denétamo, kale sa̧a nóló beteró̧póló tukóló muló betere sukamó beta̧ sipsip hupu nóku dolomó doropóló mupa, tao saalomeié? ");
INSERT INTO ppo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tépatei, whi̧ta ti mo doasi bete mole o̧la ereteiné whi̧ tao sere alané sipsip hupu tao sere ala bosene falapó. Atérené sa̧a nóló beteró̧póló da̧le mulale sukamó wisi ala depa, fo munipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Téró ai fo yóló kemetepa, kale naase dore whi̧paae duraalu, “Naao naase teréȩ falae,” depa, kale whi̧né ama dore naase teréȩ faralemó, me tikiró wisire naase kaae yó felepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Atétepa, kale Farisi whi̧rape atima belapaae tóȩ fóló, Yesu netéró daaloé yóló fo dokalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Até yaaire ala Yesuné ama kisipa yóló, a̧ betale tiki taaróló felepó. Atétepa, kisi daae mole so whi̧ feané a̧ sya wou betepa, ama wisirótua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Atéró, ama atimapaae fo mulótu duraalu, “Ya̧lo i dere ala kolóló ȩ etei kaae whi̧ beterapóló mepaae so whi̧paae momókó yao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yesuné ai du betale alata, mo take Kótóné ama ko̧ló whi̧ Aisaiané asȩyóló muló betere fo motóró dokonóturaalu yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ama ai ere fo i ape. “Ya̧lo kutó diró̧póló, sókó sóró kae beteró betere whi̧ i betere ape. Ama dere alamó, ȩ hai̧né sukutu a̧paae yaala sókó fóló, mo hosaa mulapó. Atérené ya̧lo kepe bete a̧ tua̧paae beteratepa, amamo Talené mo donotóró taleyóló kwia melaaire fo i hae kwiamó kae kae tiki daae mole so whi̧paae ha̧kearóló yó melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Téró ya̧lo kutó diratere whi̧ ho̧le sere alaró ho̧le fotamo ini dereteiné, ai be belamó ó tu̧mó fua wua dere so whi̧né mo wosókélé yaalomeipó. ");
INSERT INTO ppo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kale kape siki ka̧ae faairaalu, bitiki̧ne tikimó ama mo ti ka̧ayaalomeipó. Téturaalu, kale wisiyóló dó tanire sa̧kélé ama hapale sukunéni, ha̧le dó tanó̧póló kaae taté faalopó. I haemó du betere kae kae dowi alamó, mo donótóró taleyóló kwia melaaire alané ho̧ko taletere ala aluraté fóló, mo donoyóló taletere alané tȩteróló kaae tawaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Atéturaalu, hae kwia feamó betóló fale so whi̧né a̧paae kisipa tiki tiróló hai̧né sukutu bitu, i sekȩ́néta, da̧ mo tao saalopó du betaalo ai ape,” erapó. ");
INSERT INTO ppo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Téró, beta̧ whi̧ dowi kepe tepeyóló bituraalu, kele diliki yóo, ko̧lókélé nomóo ere whi̧ Yesu beterepaae dapesó wapa, ama wisiralepó. Atéró wisiratepa fo yóo, kelené o̧la o̧lakélé wisiyóló kolóo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","So whi̧ feané ai ala kolóló sirayóló duraalu, “Ai whi̧ta Depit-né deté wale fake tua̧mó, waalopóló bopetu betale whi̧ hi̧ti irurapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ai fo kale Farisi whi̧rapené wosóló duraalu, “Meipó. Ai whi̧ta, doasi keperapené topo kepe Belsebul-né fotoko̧ratepa, dowi kepe ai dóló ho̧konótu betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Atéró, atimané mutere kisipa tiki Yesuné kolóló atimapaae duraalu, “Mepaae hae kwia tȩteróló kaae tare doasi topo whi̧rape atimasisitei bóe dupa, ti atimané tȩteróló kaae tare ala mo doraalo ai ape. Atéturaalu, doasi be hulua ó beta̧ bemó betere so whi̧ atimasisitei bóe dupa, ti mo wisiyóló bitini, mo doyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satan-né ama fake whi̧tamotei bóe dóló ho̧kó fatepa, ti ama tȩteróló kaae tare ala amatei teketepa, ti netéró fotoko̧ buóló daayaaloé? ");
INSERT INTO ppo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Atére kaae diaao̧ duraalu, i sekȩ́néta kale dowi kepené doasi topo kepe Belsebul-né fotoko̧ratepa dóló ho̧konalepó dere-a, diaao̧ be whi̧né dowi kepe dóló ho̧konótua deteretei né fotoko̧ratepa, du betere? Atétepa, ti atimanétei dia̧tamo fo tokó̧tamo yóló, taletere sukamó dia̧ só deraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Téretei, Tale Kótóné Dȩi Kepe Wisiné ȩ fotoko̧rótu betereteiné, dowi kepetamo ya̧lo dóló ho̧konótu betepa, ti kale Kótóné tȩteróló kaae tare ao̧mó mole ala dia̧ tua̧paae wóló mulapóló kisipa yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Whi̧ mené mo doasi fotoko̧ bole whi̧né o̧la o̧la o̧lémi saairaalu, noa alapi yaaloé? Folosóró kale sekȩ́pi dirii képiné dokóló mulóló, nalo ama bemó muó mole o̧la o̧la sóró fenérapó. ");
INSERT INTO ppo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ȩtamo beta̧mó bitinire whi̧né ti bóe dóló ȩ só derótu beterapó. Mepaae whi̧né ama o̧la o̧la ȩtamo mulénitepa, ti atétere whi̧né ama o̧la o̧la ho̧ko besekérótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Atétu betereteiné ya̧lo dia̧paae mo i dere ape. Mepaae kae kae dowi alaró Kótó faletere fotamo yólótei, nalo Talepaae kemerae depa, ti Tale Kótóné me o̧la meipóló ha̧le kemeraalopó. Tépatei, kale Dȩi Kepe Wisiné erótu betere alatamo faletepa, ti Tale Kótóné me o̧la meipóló kemeraalomeipó. ");
INSERT INTO ppo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Atére kaae, mepaae whi̧nétamo kale whi̧né Naalema falatepa, ti ama ai dowi ala kwia me o̧la meipóló ha̧le kemeraalotei, mepaae whi̧ dené kale Dȩi Kepe Wisiné erótu betere alatamo faletepa, ti mió i betere alimókélé ó take nalo waaire alimókélé, ama ai dowi ala kwia kemeréni, ha̧le muó tawaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ni wisi daapa, ti ama dukélé wisi oleyaalopóló kisipa muóo, Dowi niné ama dukélé ti mo dowitóró oleyaalopóló kisipa muóo, yae. Ti noatepae, so whi̧né olere du kilituraalu etei kaae nipóló kisipanérapó. ");
INSERT INTO ppo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Dia̧ whi̧ tukó nokole dowi wulirape-ó, dia̧ dowi alané fa̧anuraalu wisi fo noayóló yaaloé? Ti noatepae, so whi̧ feané hosaa tua̧mó fa̧ayóló mole alatóróti ko̧lónékélé foparóló ha̧keamó dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Whi̧ wisiné ama hosaa tua̧mó ti wisi alatóró fa̧ayóló muluraalu, ama dere fokélé wisi fotóróti dua dapó. Dowi whi̧né ama hosaa tua̧mó ti dowi alatóró fa̧ayóló muluraalu, dowi fotóróti dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Térapa, ya̧lo dia̧paae mo i dere ape. Diaao̧ dere fotamo, kisipa tekeyóló ini, hapale ho̧ko depa, ti take taletere sukamó dia̧paae etei kaae ho̧ko fo noatepa yaleé yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ti noatepae, taleyaaire sukamó diaao̧ yale wisi fonétei dia̧ ha̧le fó̧póló eróo, mepaae yale dowi fonétei dia̧ só deróló kwia melóo, yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Téró, mepaae Farisi whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamoné a̧paae duraalu, “Yó matere whi̧-ó, Talenétei eratapóló da̧né kisipa yaai dapa, kelemei alakó erótumié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ai fo depa ama atimapaae duraalu, “Dia̧ nópu nokole alaró mepaae sonaalei dowi alatamo du betere whi̧rape-ó, Talenétei eratapóló sira yaaire ala erae yóló, wosó maaté tarapó. Me sira yaaire alakó yó melaalomeitei, Kótóné ama ko̧ló whi̧ Jonapaae erale ala kaae beta̧ eratepa kelaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ti noatepae, kale whi̧ Jona be dȩ sore yóo, diki sore yóo yóló, doasi yané depe dolomó bitu yale kaae, kale Whi̧né Naalemakélé, be dȩ sore yóo, diki sore yóo yóló, dou dolomó ha̧le muaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Téyaalotei, take nalo kale Ninipa be hulua whi̧rape taletere be dȩmó mió i alimó betó mole so whi̧ mo só deraalopó. Ti noatepae, atima Jonané yó mótu betale fo wosóló, dowi ala taaróló kisipa tiki feteyalepó. Téyaletei, Jonakélé tȩteróló bosene fale whi̧ i betepatei, kisipa tiki tirénitere-a, noatepa de? ");
INSERT INTO ppo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Talené taletere be dȩ sókó wapa, beta̧ Saut-paae mole hae kwiamó betere doasi kwin so a̧ turukó holóló daalu, dia̧ mió i alimó betó mole so whi̧ só deratere fo yaalopó. Ti noatepae, ai sota, mo saletópaae betale sotei, kisipa tiki dotoróȩ fóló mole whi̧ Solomon-né yó matere fo wosaai dapóló weipakalepó. Téyaletei, Solomon-né kisipa tiki fosó fosóre alakélé tȩteróló bosenée fale whi̧ i betere ape. ");
INSERT INTO ppo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kale dowi keperape whi̧né depe tua̧mó beteretei taaróló furaalu, i ala dua dapó. A̧ kópu ka̧ae fi tikimó mo wisiyóló betaai dapóló keka̧ai fȩlalemó, betaaire tiki kilinitepa momó fesaae wóló duraalu, ‘Ya̧lo taaróló wale bepaae, ȩ momó biti̧ faaitapó,’ dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Atéró, a̧ fóló kelera̧lemótamo whi̧ mekélé bitini kale be fuóló taae faróló o̧la o̧la fea hotowaró beta̧paaeró betepa, keletapó. ");
INSERT INTO ppo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Atépa kale dowi kepe a̧ momó fesaae fóló, mepaae doasi dowi alamaaté du betere wȩikeró keperape dapesó wóló, kale whi̧ tua̧mó biti̧ walapó. Atétepa, ai whi̧ a̧ take folosóró betale ala sawa doretei, mió kale wȩikeró dowi keperape biti̧ waleteiné, kale whi̧né betere bete mo ti doratapó. Atétere kaae, mió i alimó dowi ala du betere so whi̧paaekélé eraalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuné ai touró betere so whi̧paae fo ha̧le du betepatei, ama hamaró nomarapetamoné a̧tamo fo yaairaalu, wóló belamó daae molepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tépa whi̧ beta̧né duraalu, “Naao haeró norapetamoné ya̧tamo fo yaai wóló belamó daae mulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ti fo depa Yesuné duraalu, “Ya̧lo haeró norapetamo-a, deé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ti fo yóló, ama yó matere whi̧rape beterepaae naasené yóló duraalu, “Ya̧lo haeró norapetamota, ti i betó mole ape. ");
INSERT INTO ppo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ti mepaae so whi̧ denétamo hepen bemó betere ya̧lo Aya Kótóné ama kisipa mole ala erótu betepata, ti ya̧lo no ne ó haetóró ai betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Atéyale be dȩmótóró Yesu a̧ ai be tua̧mó yó mótu betaletei taaróló, kale doasi wȩi kȩla fókupaae biti̧ derepelepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Atéró, ai wȩi fókumó so whi̧ mo ha̧le o̧la kaae bopéróló daae moleteiné a̧ daayaaire tȩ munipa, nuku tua̧paae daane horalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Atéru, so whi̧paae du betale fo fea ti fo sale maaté yóló duraalu, “Whi̧ beta̧né o̧la wae kerape ama kutómó terepété kwȩyaai sóró felepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Atéró, kale whi̧né ama o̧la wae kutómó terepeté kuturaalu, mepaae ke ti tu̧ tómó sókóta yóló mupa, barapené nalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mepaae kerape ti kane tómó dakere haepaae taae durupua yalepó. Atéyale o̧la waeta, mo haepaae derepéni, kane tómó dakere haemó taae derepeleteiné, kale o̧la wae mo hapale holalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Téyaletei, mo dirii sukané kale o̧la mo hapale botokole yó salepó. Ti noatepae, ama feleke mo apaae derepénireteinépó. ");
INSERT INTO ppo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mepaae kerape, ti kale mu daai ne tua̧mó taae durupua yalepó. Téturaalu, kale o̧la wae dowi mu daai netamo beta̧mó holale tikimó, ai kale dowi nené kale mo o̧la bopée sóró aluralepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mepaae kerape ti mo hae wisimó taae durupua yalepó. Atéyale o̧la ti mo wisiyóló holóló, du wisinaale woleyalepó. O̧la wae bi̧li furaalu, yo beta̧ sóró feletei, o̧la u̧lumétepa suraalu ti 100 yorape mepaae 60 yorape ó 30 yorape fa̧anóló sóró walepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mepaae whi̧ de wosȩ́li daapa, ti i dere fo bete wisiyóló wosóló kisipa muae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Atéró, ama yó matere whi̧rape wóló a̧paae woseturaalu, “So whi̧paae naao fo salené maaté du betere-a, noatepa de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ai fo depa ama tokó̧ mótu duraalu, “Ó hepen bemó betere Kótóné ama tȩteróló kaae tare tua̧mó kinóló mole kisipa tiki wisinaale dia̧paaeta meló beteretei, atimapaae ti meló bitini ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mepaae whi̧ dené kale fo wisitamo sóró tapa, ti ai tómó mepaae kae beleróló melaalopó. Téturaalu, ai whi̧ a̧ mo dekéró muaalo ai ape. Mepaae whi̧ dené kale fo wisi sóró tanitepa, ti ama sawatamo tareteikélé fasó saalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ya̧lo atimapaae fo salené maaté i yó mótu betereteita, ha̧le meipó. I ere fo dokonóturaalu, erapó. ‘Atimané kelené mo kilirutei, me o̧la wisiyóló koló fumipó. Atimané wosȩ́linékélé wosetu bitutei, bete wisiyóló kisipa mutumipó.’ ");
INSERT INTO ppo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ai so whi̧ tua̧mó ere alata, Aisaiané asȩyóló muló betere fo dokonóturaalu dapó. Ai asȩre fo i ape. ‘Diaao̧ wosóta yaalotei, fo bete wisiyóló kisipa muaalomeipó. Diaao̧ kelenée yaalotei, wisiyóló kelaalomeipó. ");
INSERT INTO ppo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ti noatepa meipó. Ai so whi̧né hosaa ta̧róo, kelekélé dilikiróo, atimané wosȩ́likélé kinóo erapó. Ti noa yao̧sóró meipó. Atimané kelené mo bete kolóo, wosȩ́liné wosóló bete kisipa yóo, yao̧sóró erapó. Ai ala ere so whi̧ atima ȩ beterepaae momó feteóló wapa, ti ya̧lo atima su̧mó wisiranérapó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Téretei, diaao̧ kelenékélé mo wisiyóló kolóo, wosȩ́linékélé fo wisiyóló wosóo yaleteiné, Kótóné dia̧ wisiró beterapóló, hai̧né ai sukutu betere ape. ");
INSERT INTO ppo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ya̧lo dia̧paae mo i dere ape. Mo take Kótóné ama ko̧ló whi̧raperó mo donoi alamaaté dere whi̧rapetamo feané mió diaao̧ kilitu betere ala atimané kelenée du betaletei mo kilinipó. Diaao̧ wosetu betere fokélé atima feané wosenée du betaletei, mo wosókélé inipó. ");
INSERT INTO ppo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","I kale o̧la wae ke terepeté kwȩyale whi̧né yale fo sale fo bete i dapa, diaao̧ mo wisiyóló wosae. ");
INSERT INTO ppo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mepaae whi̧ de Kótóné tȩteróló kaae tare ao̧mó mole fo wisi wosóló, bete wisiyóló kisipa initere so whi̧ta, ti kale o̧la wae ke tu̧ tua̧mó sókóta yóló mupa, barapené nale kaaeta, ti kale dowi Satan-né atima hosaa tua̧mó muló betere fo wisi tokó̧ sua du beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kale kane tómó dakere haemó taae derepele o̧la waeta, ti mepaae so whi̧ dené kale fo wisi hapale wosóló, hȩkesetu dere kaaepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tépatei kale fo wisi wosóló, ama feleke mo apaae derepéniruraalu, sawa ha̧leke sukamó beteró, su̧sere ala ó me sekȩi ala wapa, ti kale sekȩ́ hapale tétitei dée nóló Talené ama fo wisi erateretei mo ti taalatua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kale dowi mu daai ne tua̧ dolomó taae durupu yale kaaeta, ti whi̧ me de Kótóné fo wosólótei, i haemó doasi moni sóró néli whi̧ betenée dere alaró whaaliané sukutere alatamota, mo doasi bete mole nisiyóló sya furaalu, Kótóné fo aluróló du wisiyóló ulutimipó. ");
INSERT INTO ppo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kale hae wisi bolemó taae derepele o̧la wae kaaeta, ti whi̧ me de Kótóné fo wisiyóló wosóló, kisipa mutere so whi̧ ai ape. Atétere whi̧ta, kale o̧la u̧lumétepa, mepaae 100 mepaae 60 mepaae 30 yorape deyóló fa̧anótu dere kaaepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Atéró, Yesuné so whi̧paae fo sale fo me kae yóló duraalu, “Ó hepen bemó betere Kótóné tȩteróló kaae tare ao̧mó mole alata, i ala dere kaaepó. Whi̧ beta̧né ama kutómó o̧la wae wisi biliyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Atéró biliyóló, so whi̧ fea noke firepaae ama bóe whi̧ wóló, kale o̧la wae ke biliyó mole tikimó dowi nené kekélé terepée daalóló, felepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kale o̧la wae holóló du woleyaaire alimó, kale dowi netamo wusuró beta̧mó hopa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Atépa, kale kutó diratere whi̧rapené ai kutó talepaae duraalu, ‘Doa whi̧-ó, naao kutómó mo wisi o̧la wae ke maaté biliyaletei, dowi nemo noayóló sokaleé?’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ti fo depa kale kutó talené tokó̧ mótu duraalu, ‘Aita, bóe whi̧né du yalepó,’ depa ama kutó diratere whi̧rapené a̧paae duraalu, ‘Da̧ fóló ai dowi ne tokó̧ farópé nearóé?’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ai fo depa ama duraalu, ‘Meipó. Diaao̧ kale dowi ne tekȩturaalu whit-tamotei tokó̧ falao̧sórópa, ama eró̧póló taalae. ");
INSERT INTO ppo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kale whit-tamo wusuró enó̧póló kaae tawóló, o̧la u̧lumétepa sere sukamó yaasepólópó. Atéró o̧la sere sukamóta, ti kale o̧la sere whi̧rapepaae siré kwȩyae depa, dowi nerapepi tokó̧ló si biliraai beta̧paae eróló mulaalopó. Téró kale mo naaire whit maaté siré kwȩyóló beta̧paae yóló, mulatere bepaae mulaalo ai ape,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Atéró, ama atimapaae fo sale fo me yóló duraalu, “Ó hepen bemó betere Kótóné tȩteróló kaae tare ao̧mó mole alata, ti beta̧ whi̧né kale mastard niné ke ama kutómó biliyale kaaepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ai kale mastard niné keta, mepaae i yó mole niné ke kaae meipó. I niné keta mo beleka̧amaletei huturaalu, ti mepaae kutómó ere nirape fea tȩteróló mo doakale ni ami daatua dapó. Atépa, ai ni tȩirapemó barape daaneta dua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Atéró ama kale dere kaae, fo sale fo me yóló duraalu, “Hepen bemó betere Kótóné tȩteróló kaae tare ao̧mó mole alata, beta̧ soné flawa o bula duraalu tópuó̧póló bulatere sawa o̧la yist kaaepó. Ai sawa o̧lanétei flawa o bula doasi tóputua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Atéró, Yesuné so whi̧ feapaae yó matere doko̧ fo saletamo touróló yó du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ama ai ala du betaleteita, ti Kótóné ko̧ló whi̧rapené yóló muló betere fo dokonóturaalu, du betalepó. Kale fo i ape. “Take i hae kwia fea kaaraaipatei, kinóló mulaté wóló, mió i alimókélé ha̧le kinóló mole forape fea, ti ya̧lo fo sale fonétóró yó melaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Téró, ai touró betere so whi̧ fea betó mupatei taaróló, a̧ be dolopaae felepó. Atétepa, ama yó matere whi̧rape a̧ beterepaae wóló duraalu, “Kutó tua̧mó dowi ne botokorapó dere fo salené bete da̧paae yó a̧lae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ai fo depa, ama atimapaae tokó̧ mótu duraalu, “Wisi o̧la wae ke feseketé kotere whi̧ta, ti kale Whi̧né Naalema ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kale kutóta, ti so whi̧ fea betó mole hae tiki ai ape. Kale o̧la wae ke wisita, ti Kótóné tȩteróló kaae tare ao̧mó betó mole so whi̧ ai ape. Kale dowi neta, ti dowi Satan-né naale senaale ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kale dowi ne du biliyale bóe whi̧ta, ti dowi Satan-pó. Kale kutómó ere o̧la u̧lumétepa saaitere sukata, ti kale kemeyaaitere be dȩpó. Kutómó ere o̧la u̧lumétepa sere whi̧rapeta, ti kale ensel-rape ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kale dowi nerape tokó̧ló sipaae taae fatu dere kaae, take kemetere sukamó atéyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Atéró, kale Whi̧né Naalemané ama ensel-rape dotonóló, Kótóné tȩteróló kaae tare ao̧mó betó mole so whi̧ró dowi ala dere so whi̧tamo hoseké yóló betao̧sóró, ama ensel-rapené tokó̧su deté kwȩyaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Atéró, me whi̧ dowi ala yó̧póló dée nalatere so whi̧ró dowi ala du betere so whi̧tamo si duku betere dolopaae taae deraalopó. Aimó siné duku bitu, doasi wole yóló kaketuraalu, atima serekené atimatei tukó nuku betaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Atima atéró ki̧lipaae ti mo donoyóló betere so whi̧ atimané Aya Kótóné tȩteróló kaae tare ao̧mó, suka wisi duraalu dȩ tekée fu dere kaae, dȩ tekée fi so whi̧ betaalopó. Whi̧ me de wosȩ́li daapata, ti i dere fo wosóló bete mo wisiyóló kisipa muae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Atéró, Yesuné duraalu, “Hepen bemó betere Kótóné tȩteróló kaae tare ao̧mó mole alata, ti etei ala dere kaaepó. Whi̧ beta̧né ama hae kwiamó doasi moni sere wisi wisi o̧la bupa kikiti koló salepó. Atéró kale o̧la hyó̧ muóló, a̧ bepaae hȩkesetamo felepó. Atéró fóló, ama bemó muó mole o̧la o̧la fea mepaae whi̧tamo dotonóló moni sóró, kale wisi wisi o̧la mole hae tiki ama dupu yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Atére kaae, hepen bemó betere Kótóné tȩteróló kaae tare ao̧mó mole alata, ti meleke kaae dui o̧la o̧la wisi kekó̧ló keletepa, dotonóló moni sere whi̧né dere kaaepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ai kale meleke kaae dui o̧la wisi mupa koló sóró fóló, ama tare o̧la o̧la mo fea dotonóló, ai kale o̧la wisinaale dupu yalepó.” ");
INSERT INTO ppo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Fo sale fo me i ape. Ó hepen bemó betere Tale Kótóné ama tȩteróló kaae tare ao̧mó mole alata, mepaae ya siré kotere whi̧rapené ya saairaalu, atimané ha̧leke wa wȩi kulupaae deróló, kae kae yarape sutere kaaepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Atéró, kale ha̧leke wamó dere yarape taleyaairaalu, ha̧leke wa tukó sóró wȩi fókumó turukwȩ mulóló, taleyóló wisire ya yopaae derótua yóo, doretei ti taae fatua yóo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Atétu dere kaae, take kemetere sukamókélé, ai ala yaalo ai ape. Kótóné ama ensel-rape wóló, wisi ala du betere so whi̧ taleyóló kaepaae beteróo, dowi ala du betere so whi̧ kaepaae beteróo, yaalopó. Atéró bukótamo yóló, dowi ala du betere so whi̧ta, si duku beterepaae taae deraalopó. Aimó siné duku bitu, atimanétei yale dowi alamópóló doasi wole yóló serekené tukó nuku betaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Téró Yesuné atimapaae duraalu, “Ai yale forape fea diaao̧ wosóló bete wisiyóló kisipa yaleé?” depa, atimané duraalu, “Ȩ́pó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tétepa Yesuné duraalu, “Moses-né asȩyóló muló betere fo yó mótu betere whi̧rapepaae, Kótóné hepen bemó tȩteróló kaae tare ao̧mó mole ala i ape yóló, mené yó matepa kisipare whi̧ta, ti be tale kaaepó. Beta̧ be talené ama wisi wisi o̧la muó mole tikimó mió sale kisi o̧lakélé, mo take mole o̧latamo touróló, Talené ala erótu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuné ai fo sale forape yó melóló ki̧lipaae a̧ ai be hulua taaróló felepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Atéró, ama turuku bemó sókó fóló bituraalu, atimané fo wosetere bemó fo kaae sóró yó mótu betalepó. Ama atéró yó matere fomó sirayóló duraalu, “Ai whi̧né kisipa tiki dotoróȩ fale alaró kae kae eratere kelemei alarapetamo-a, né yó matepa du bitutérópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","I naaleta, kale be tȩtere whi̧né naalema hi̧ti meié? Ama hamata Maria ai ape. Kale Jems, Josep, Saimon, Judas, ai whi̧rapeta, ti ama nomarape ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ama nemarapekélé, da̧tamo i betere ape. Ama doa ai du betere ala feata, momó sóró du bitu dérópóló, a̧tamo dei tuȩ́ mualepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Atéró, Yesuné a̧tamo dei kisipa mutere ala kolóló, ama atimapaae duraalu, “Be hulua feamóta Kótóné ama ko̧ló whi̧né doi doasi moletei, ama turuku be hulua so whi̧ró ama fake so whi̧tamo tua̧mó, ti doasi doi muni ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Atimané ama dere fo wosóló kisipa tiki tirénireteiné ai be hulua tua̧mó, ama kae kae doasi fotoko̧i kelemei alarape mo dekéró eréni, tóróti eralepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Atéyale sukamó, kale Kaleli hae kwia tȩteróló kaae tare whi̧ Herot-né Yesuné i alarape du beterapó dere fo wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ai fo wosóló ama kutó diratere whi̧rapepaae duraalu, “Aita, kale wȩi tópuratere whi̧ Jon kepaayóló biturapó. Atéru, mo kae kae doasi kelemei alarape ai erótu betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ai fota, ha̧le inipó. Herot-né Yesuné i alarape du beterapó dere fo wosaai bitutei, i ala yalepó. Jon-né Herot-paae duraalu, “Naao no Filip-né so Herodias-tei noatepa tokó̧ló dokaleé?” yale fomótei, kale Herot-né Jon dipula beteralepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ai fo deremó, kale Herot-né Jon dipula beteróló daai yaletei so whi̧ kolóló a̧ wituraalu, dipula bemó ha̧le beteró̧póló taaralepó. Ti noatepae, Jon-ta, Kótóné ama ko̧ló whi̧póló, so whi̧ feané kisiparapó. ");
INSERT INTO ppo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Kale doasi topo whi̧ Herot-né ama hamané a̧ deyale be dȩ wapa, doasi o̧la deyóló nuku betalepó. Até du betepa, kale so Herodias-né senaalema wóló, o̧la nuku betere so whi̧rapené keletómó ki̧litu betalepó. Atéró ki̧litu betepa, Herot a̧ mo doa hȩkesené sukutepa kale so seimalepaae duraalu, “Naao ȩpaae noa o̧lakó kematepa, ti naao ai kematere o̧latóróti ya̧lo ya̧mó melaalopóló,” doasi dirii fo yóló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ai fo depa, kale so Herotasiné senaalepaae ya̧ fóló, kale wȩi tópuratere whi̧ Jon-né topo tukóló a̧lae fo ene fae depa, kale senaale a̧ fóló Herot-paae duraalu, “Wȩi tópuratere whi̧ Jon-né topo beta̧ tukóló nuku tómó beleróló a̧lae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Kale doasi topo whi̧ Herot-né ai fo wosetu a̧ mo doasi fomoné suka̧letei, ama o̧la naai wale so whi̧né keletómó i ala mo yaalopó yóló mulale fo tikinépa, ama diki tare whi̧rapepaae Jon-né depa tikae yóló, dotonalepó. Atétepa atima fóló, Jon dipula bemó betepa, depa tukóló ama topo nuku mó beleróló sóró walepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Atéró, kale whi̧né topo du nuku tómó beleróló kale senaalepaae melatepa, ama sóró fóló, hamapaae melalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Atétepa, Jon-né ama yó matere whi̧rape wóló, kale sekȩ́né ama tupuló tiki sóró fóló douralepó. Téró atima fóló, Yesupaae i alarape yalepóló ene felepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Atei ala yalepó dere fo Yesuné wosetu, ai so whi̧ betó mole tiki taaróló, ama yó matere whi̧rape atimanale maaté wȩi nuku sóró so whi̧ bitinire tikipaae felepó. Aimó betó muale so whi̧ feané Yesu upaae felepó dere fo wosóló, atima betere doasi be huluarape taaróló, a̧tamo hokolaa yaai dapóló atima hae tu̧mó felepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Atéró, Yesu a̧ hae tópaae taae fóló kelalemó, so whi̧ mo ha̧le o̧la kaae wóló betó mupa kolóló, ama hosaa tua̧mó mo doasi ko̧lené sukutepa, atimané hepo beterape wisiralepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Atéró, be felekemó diki yaaiteretamo, ama yó matere whi̧rape a̧ beterepaae wóló duraalu, “Da̧ so whi̧kélé bitini ha̧le tua̧ tikimó betepatei be dikiyalepa, felekemó tȩ mole be huluarapepaae atimané naaire o̧lakó dupuyaai fó̧póló, dotonae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ai fo depa, Yesuné tokó̧ mótu duraalu, “Imó da̧né menanénipa, atima dupune fó̧póló de? Diaao̧tei, atimané naaire o̧la melótumié,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","18","Ti fo depa, ama yó matere whi̧ beta̧né duraalu, “Da̧né imó moleteita, bred o bula aporó yóo, ya tamo yóo yóló beta̧ i mole ape,” depa, ama duraalu, “Ai o̧larape ȩpaae sóró ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Atéró, ama so whi̧ feapaae ai ne tómó betae yóló atima fea betó mupa, ama kale bred o bula aporó sóo, ya tamo sóo yóló taruraalu, hepen-paae kese horóló Tale Kótópaae mo kée yóló, terekéeraalu yalepó. Atéró ama yó matere whi̧rapepaae melatepa, atimamo so whi̧mó melaté kwȩalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Atéró, so whi̧ mo fea nóló su̧tepa, buki muni feletei kale yó matere whi̧rapené beta̧paae yóló, 12 yorape deyóló fa̧analepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Atéró, ai kale o̧la nale so whi̧rapeta, soraperó naale senaaletamo dosa̧ani, whi̧rape maaté dosa̧ayóló touróturaalu, 5000 whi̧rapepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Atéró Yesuné ama yó matere whi̧rapepaae duraalu, “Ȩta, i betó mole so whi̧ atimané be séle sélepaae fó̧póló dotonóló walapa, wȩi tȩ utéró betaai dia̧pi ai nukutamo fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Téró, so whi̧ fea fó̧póló dotonóló ki̧lipaae Yesu a̧ ama wotoró du sokore ao̧mó momayaairaalu holalepó. A̧ aimó wotoró betepatei, be dikiyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Aimó betepatei, kale wȩi nuku wȩi kulu tua̧mó ha̧le fu betepa doasi wȩi asyaró besȩ́ tikitamo atima faaire tikiró waleteiné, kale nuku hapale feni, dua wóputé fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Felekemó be dȩyó holaai deretamo, Yesu ama yó matere whi̧rape beterepaae waairaalu, wȩi tómó daaté wou betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","A̧ atéró daaté wou betepa atimané a̧ kolóló, mo doasi witu diri furu furu yóló duraalu, “Kepe ai wale ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Atéteretamo Yesuné atimapaae duraalu, “Ita ȩpa dia̧ wini, hosaa diriyóló mo dua betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tétepa Pitané Yesupaae duraalu, “Tale-ó ya̧pata, ti ȩkélé ya̧tamo hokolaa yaai wȩi tómó daaté waaitapa, ape yae,” depa ama duraalu “Ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ti fo depa, Pita wȩi nuku taaróló wȩi tópaae taae doropóló, Yesu walepaae daaté felepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Téyaletei, doakale besȩ́ tiki wale kolóló wituraalu, wȩi dolopaae buó deyaai depa ama fo fakeyóló duraalu, “Tale-ó, wȩiné ȩ felekemó aluraai dapa, tao sae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Atéteretamotóró, Yesuné ama naasemó taosu duraalu, “Naao kisipa tiki mo ti tiró bitini airapó. Noatepa kisipa tiki tamo dekaaporóló mualeé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Atéró, atimaamo wȩi nukupaae biti̧ holalemó, kale besȩ́ tiki tikalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tétepa, kale ai nuku tua̧mó betó mole whi̧rape Yesu ao̧mó sukó̧ló bitu, ama doi hale sóró horótu duraalu, “Ya̧ta so whi̧ fea tȩteróló kaae tare Tale Kótóné Naalematóró mo hi̧tipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Atéró, atima ai wȩi da̧ala tȩyóló, Kenesaret hae utéró sókó felepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ai be huluamó betó mole so whi̧né a̧ kolóló ita, kale Yesu airapó yóló kisipa mutu ai hae kwiamó betó mole be hulua so whi̧paae Yesu wóló i betere ape, yó faralepó. Atétepa, kale kisi daae mole so whi̧rape atimané a̧ beterepaae dapesó wua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Atéró wóló betó mulu, whi̧rapené a̧paae woseturaalu, i kisi daae mole so whi̧né naao kuti salemómaaté wolaa yó̧póló yae yalemó, téyae depa a̧ wolaatua yale so whi̧né kisi beterape fea wisitua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Téró, kale mepaae Farisi whi̧raperó Moses-né yóló muló betere fo yó matere whi̧rapetamo, Jerusalem be huluamó biti wóló, Yesu beterepaae fóló woseturaalu, “Naao yó matere whi̧rapené da̧né ayarapené mara mole ala noatepa tikitu bitu de? Atimané o̧la naairaalu, folosóró naase fukunipatei o̧la nuku betere-a, noatepa de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ti fo depa, Yesuné atimapaae tokó̧ mótu duraalu, “Mo diaao̧tóró dia̧né ayarapené mara mole ala sya fu bituraalu, Kótóné yae yóló muló betere fo noatepa tikitu betere? ");
INSERT INTO ppo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ti noatepae, Kótóné duraalu, ‘Naao hae aya wisi doi muó̧póló hale sóró horótu betae,’ fo erapó. ‘Mepaae whi̧nétamo ama hama alimané doi doróló, dowi tekani fo depata, ti sinó̧póló,’ mo ti daae erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“Ai fo asȩyóló mupatei, diaao̧ etei fo dua dapó. Whi̧ beta̧né ama mole o̧la ó monikó alimaró hamatamo tao sóró melólua̧tei, ita Kótópaae melaaipó yaleteiné, diaamo melanénipó dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Atéturaalu, hamaró alimatamo ao̧mó bitu, atimaamoné doi hale sóró horatere ala iniyóló alurótu beterapó. Diaao̧ ayarapené mara mole ala sya fóló du betereteiné, Kótóné fo ha̧le o̧la kaae ao̧róló alurótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Dia̧ tiki tua̧paae dorutei, ha̧le siki̧li du betere whi̧rape-ó, diaao̧ ai du betere alamó Kótóné ama ko̧ló whi̧ Aisaiané asȩre fota, ti mo dia̧paaetóró erapó. ");
INSERT INTO ppo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ai asȩre fo i ape. ‘I so whi̧né ha̧le ko̧lónémaaté ya̧lo doi hale sóró horótu bitu, atimané ȩ hosaa tua̧mó muló bitini, kisipa keteróló mo sisópaae eró beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Atimané ȩpaae, “Aya Tale doa whi̧-ó,” du beteretei ti mo ha̧le du beterapó. Atéró yó mótu betere fota, ti mo whi̧né tuȩ́né kekeme nóló i ala yae yóló, yó matere fotei yó mótu beterapó,’ erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuné aimó daae mole so whi̧ feapaae ape yóló duraalu, “I dere fo bete dia̧né wisiyóló wosóló kisipa muae. ");
INSERT INTO ppo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Whi̧ betere bete doratereteita, mo nokole o̧lané dorótimitei, whi̧né tiki tua̧mó kaayóló ko̧lómó sókó wale foné beta̧ Kótóné keletómó ai whi̧né betere bete mo dorótua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tétepa, ama yó matere whi̧rape a̧ beterepaae wóló duraalu, “Ai Farisi whi̧rapené naao ai du betere fo woseturaalu, atima dei kisipa mutu beteretei naao kelere?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ti fo depa ama duraalu, “Ó hepen bemó betere ya̧lo Ayané ama biliniyale o̧larapeta, ti ama feleketamo turó tokó̧ saalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ti ai whi̧rape atimata, kele dilikirutei mepaae whi̧rape ai a̧lisóró fu beterapa, atima atétóró du beteró̧póló taalae. Me kele dilikire whi̧né me kele dilikire whi̧paae tu̧ i mole ape yóló a̧lisóró fupa, ti atimaamo wusurótóró dée nóló, kulu dolopaae derepaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ai fo depa Pitané duraalu, “Tale-ó, naao nokole o̧lané whi̧ dorótumipó, yale fo salené bete da̧paae ha̧kearóló yó a̧lae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ti fo depa, Yesuné atimapaae duraalu, “Dia̧kélé ya̧lo ai yale fo bete wisiyóló kisipa muni, diaao̧ kutirikélé hapólu ai ere ape. ");
INSERT INTO ppo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Whi̧né ko̧lómó nóló, depepaae biti̧ doropole o̧lané whi̧né tiki dorótumipó. Ai o̧lata, depepaae biti̧ doropóló nalo, di alée fua deretei diaao̧ kisipanié? ");
INSERT INTO ppo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Téretei hosaa tua̧mó kaayóló, whi̧né ko̧lómó sókó wale foné beta̧ ti whi̧ dorótua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","“Whi̧né hosaa tua̧mó kaayóló wouraalu, whi̧ doratere alarape ti i ape. Doi ala yaai mutere dei tuȩ́kélé, whi̧ dele alakélé, whi̧né dokore so ó so dokore whi̧tamo nópu nokole alakélé, kokopei ó seimalené kae kae nópu nokole alakélé, kikiti o̧la o̧lémi sere alakélé, whi̧ me dilikó̧ló ama o̧la o̧la sere alakélé, fo tokó̧ló taleturaalu kapala fo dere alakélé, me whi̧ eratere alakélé, ai alarape feané so whi̧ dorótua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Whi̧ doratereteita, naase fukuni bólutamo o̧la nokole alané dorótimipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Atéró Yesu a̧ ai kale Juda so whi̧né hae tiki taaróló, Tair-ró Saidon be huluatamo felekemó mole hae kwiapaae felepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Téyalemó, ai Juda meire be huluamó betere Kenan fake so beta̧ Yesu beterepaae wóló, fo fakeyóló duraalu, “Depit-né deté yale whi̧né Naalema Tale-ó, ya̧lo senaale dowi kepe tepeyóló bitu, mo sonaalei dowi ala eróló, ama tiki doasi susupu su beterapa, naao ȩ ko̧letu tao sae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ai fo deté wou betepatei, Yesuné kale sopaae me fo tokó̧ menitepa, ama yó matere whi̧rapené a̧paae duraalu, “Ai soné da̧ sya wouraalu dotopoi fo deté wou beterapa, fó̧póló ho̧kó falótumié?” yóló sȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ai fo depa ama kale sopaae tokó̧ mótu duraalu, “Ȩta, Israel fake so whi̧ tua̧mó fokó fóló betó mole hupurape tao só̧póló, dotonatepa wóló i betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tétepa, kale so Yesu daalemó bukutiri tea̧ró bitu duraalu, “Tale-ó, ȩ naao tao sae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ti fo depa ama kale sopaae duraalu, “Kale naale senaalené nokole o̧latei yuwirape nó̧póló melatere-a wisire?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ai fo depa kale sokó duraalu, “Tale-ó, naao dere fota mo deretei, hao̧rapenékélé a̧ whaatere whi̧né bemó, o̧la nokole ni fake tómó beleróló nokole o̧la folope ao̧mó sorokóta deretei nukua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tétepa, Yesuné kale sopaae tokó̧ mótu duraalu, “Ti so-ó, ya̧ beta̧ mo doasi kisipa tiki tiróló beterapa, naao ȩpaae eraasepé dere ala mió i eratere ape,” yalepó. Ai fo deretamotóróti kale soné senaalemané kisi bete mo ti wisi ipakalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Atéró Yesu ai hae kwia taaróló, Kaleli wȩi kȩla fóku sesekȩ fu beteró, du sorokó mole ao̧paae holóló beterepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Atéró beteremó, ho̧leke momaare so whi̧kélé, kele dilikire so whi̧kélé, tiki dore so whi̧kélé, ko̧ló nomone so whi̧kélé, mo ha̧le o̧la kaae mepaae so whi̧né beleóló a̧ daalemó mulaleta depa, atimané kisi beterape ama wisirótua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kale ko̧ló nomóló betale so whi̧rapetei fo yóo, ho̧leke momaayóló betale whi̧rapekélé wisi yóo, bukutiri doyóló betale whi̧rapekélé mo wisi yóo, kele dilikiyóló betale whi̧rapekélé kele wisiyóló kolóo, depa so whi̧ feané sirayóló Israel so whi̧né Kótóné doi hale sóró horótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Atéró, Yesuné ama yó matere whi̧rape a̧ beterepaae ape yóló duraalu, “I so whi̧ mo doa ko̧lené sinitapó. Ti noatepae, atima o̧lakélé néni wote siri betepa be dȩ sore kemeyaleteiné atima tu̧ tua̧mó wotené sisiraae fao̧sóró, dotonaalo meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ti fo depa, ama yó matere whi̧rapené duraalu, “So whi̧kélé bitini, ha̧le tua̧ tikimó beterapa, doai betó mole so whi̧né naaire o̧la momó mupa melaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ai fo depa Yesuné atimapaae woseturaalu, “Dia̧né meteró bred o bularape tare?” depa atimané a̧paae duraalu, “Wȩikeró o bularape yóo, ya beleka̧atiki sawa téti yóo yóló beta̧ i tare ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ti fo depa, ai betó mole so whi̧ feapaae duraalu, “Ai hae tikimó betó muae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Téró, ama kale wȩikeró o bularaperó yarapetamo taruraalu, Tale Kótópaae mo kée yóló, terekée daalu yóló ama yó matere whi̧rapepaae melatepa, atimanémo so whi̧mó a̧liralepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Atéró, atima mo fea nóló su̧tepa, buki muni feletei ama yó matere whi̧rapené beta̧paae daseté kwȩyóló 7 yorape deóló fa̧anóló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ai kale o̧la nale so whi̧ta, soraperó naale senaaletamo dosa̧ani, whi̧rape maaté dosa̧ayóló touróturaalu, 4000 whi̧rapepó. ");
INSERT INTO ppo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Atéró, Yesuné so whi̧ fea dotonóló nalo a̧ wȩi nukupaae biti̧ holóló, Makatan be hulua felekemó ere hae kwiapaae biti̧ felepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Téró, kale Farisi whi̧raperó Sadyusi whi̧rapetamo Yesu beterepaae wóló, a̧ ka̧ae kolóló su̧ saairaalu i fo yalepó. “Kótóné ó hepen bemó mole ala kolóló, ita Talenétei eratapóló sira yaai dere kelemei alakó da̧maletamo kelaaitapa, erótumié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ai fo depa ama atimapaae duraalu, “Be kuluka sa̧ko sonaa dere ala kolóló, dóta suka wisi yaalo ai ape dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Hi̧ka be suka sokoteretamokélé sa̧ko dilikiyóló sonaatepa, diaao̧ i fo dua dapó. Mió doasi hali waai dapó, dua dapó. Sa̧né dere ala bete diaao̧ wisiyóló kolóló kisipa irutei, mió i alimó me ala yaairemó dere alarape dia̧né kolóló kisipa enénipó. ");
INSERT INTO ppo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Dia̧ mió i alimó, dowi ala du betere so whi̧ró nópu nuku betere so whi̧tamonétei Kótó mo beterapóló kisipa muó̧póló, mo doa yaai dere kelemei alakó eratepa, kelenée yóló ketekȩ butu beteretei, kelemei ala me kae eraalomeipó. Jonapaae erale ala kaae beta̧ eratepa, diaao̧ kelaalo ai ape,” yalepó. Atéró, ai whi̧rape atima betó mupatei Yesu a̧ felepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Atima nukutamo ai wȩi kȩla tȩ fóló, kelalemó ama yó matere whi̧rapené bred o sini, kȩyó yóló weipakalepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tétepa, Yesuné atimapaae duraalu, “Farisi whi̧raperó Sadyusi whi̧rapetamoné bred o tópuratere o̧la yist-né dia̧ dorao̧sórópa, mo hotowayóló kaae tawae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yesuné ai fo depa, atimasisitei fo kȩlaaróló duraalu, “Ti ama ai dere fota, da̧né bred o sóró anipa du dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Atimasisi atéró kȩlaarótu betepa, Yesuné kisipa yóló, atimapaae duraalu, “Dia̧ tómó maaté kisipa tiró betere whi̧rape-ó, dia̧sisitei noatepa fo kȩlaaróló, bred o sóró anipó du bitu de? ");
INSERT INTO ppo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Diaao̧ Ya̧lo yale alarape kolóló, wisiyóló kisipa muni airapó. Kale 5000 whi̧rapemó aporó bred o bula terekeyóló melaletei-a, dia̧né kisipa keteraleé? Kale buki muni fele bred o diaao̧ beta̧paae yóló, metéró yorape fa̧analeé? ");
INSERT INTO ppo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ó kale wȩikeró bred o bularape terekeyóló, 4000 whi̧rapemó melatepa, nóló buki muni feletei diaao̧ beta̧paae yóló, meteró yorape fa̧anóló mulaleé? ");
INSERT INTO ppo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ya̧lo take yale fota, bred omó kisipa muóló iniyaletei, diaao̧ wosóló kisipa munié? Ti ai yale fota, kale Farisi whi̧raperó Sadyusi whi̧rapetamoné yist-né dia̧ dorao̧sóró, kisipa mutu yalepó.” ");
INSERT INTO ppo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Téró, atimané ai dere fo wosóló, ama yale fota, kale bred o tópuó̧póló bulatere o̧la yist-mó initei, Farisi whi̧raperó Sadyusi whi̧rapetamoné yó matere foné da̧ atima dorao̧sóró, hotowaró kaae tawae yóló irapóló kisipa salepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Atéró, Yesu Filipainé tȩale be Sesaria Filipai doi mole hae kwiamó sókó fóló, ama yó matere whi̧rapepaae woseturaalu, “Mo so whi̧né kale Whi̧né Naalema-a, depó du bitu de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ai fo depa atimané a̧paae duraalu, “Mepaae so whi̧néta, ya̧ kale wȩi tópuratere whi̧kó Jon-pó du beterapó. Mepaae so whi̧némo, ti Elaijapó du beterapó. Mepaae so whi̧némo, Jeremaiapó du beterapó. Tétepa, mepaae so whi̧né duraalu, Kótóné ama beta̧ ko̧ló whi̧kó duyalepó, du beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ti fo depa ama atimapaae woseturaalu, “Ti aita atimané mutere kisipapa, diaao̧ kisipané ȩ-a, depó du bitu de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ai fo depa Saimon Pitané duraalu, “Ya̧ta, mo ha̧le betótóró tare Kótóné Naalema so whi̧ fea tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Keriso ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tétepa Yesuné a̧paae duraalu, “Jonané naalema Saimon-ó, ya̧ beta̧ Kótóné wisiró betereteiné mo hai̧né sinitu betere whi̧ ai ape. Ti noatepae, naao ai yale fota, mo whi̧né ya̧paae yó menitei, ó hepen bemó betere ya̧lo Ayané yó matepa dapó. ");
INSERT INTO ppo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Térapa, ya̧lo ya̧paae i dere ape. Ya̧ta Pitapó. I doasi kapo fake tómó be tȩtu dere kaae, ya̧lo so whi̧ doasi fake firaalo ai ape. Atéró tȩyóló betepa, sukutere alané bole fotoko̧né bóe daalotei, ya̧lo tȩtu betere be fisikóló mo doraalomeipó. ");
INSERT INTO ppo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Téyaalomeitei, ó hepen bemó tȩteróló kaae tare tua̧paae faaire be tu̧ tuki̧yaaire kirape ya̧lo ya̧ melaalo ai ape. Diaao̧ i haemó dowi ala deretei dokóló mulatepa, ti Kótóné hepen bemókélé dokóló muló beterapó. I haemó diaao̧ teraayóló ha̧keamó mulatepa, ti Kótóné ó hepen bemókélé, teraayóló ha̧keamó muló beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Téró, Yesuné ama yó matere whi̧rapepaae dirii fo yóló mulótu duraalu, “Ȩta, Kótóné so whi̧ fea tȩteróló kaae tanó̧póló sóró beteró betere whi̧ Kerisopó fo mepaae so whi̧paae momókó yao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mo ai be dȩmó kaae sóró, Yesuné ama yó matere whi̧rapepaae duraalu, “Ȩ Jerusalem be huluamó fóló betepa, kale whi̧ disiraperó mo so whi̧mó Talepaae momaratere topo whi̧rapenékélé, Moses-né yóló muló betere fo yó matere whi̧rapenékélé ȩpaae kae kae susupui ala eróló, ȩ mo ti sukó̧póló daalopó. Atéró sukó̧ló sore be dȩ kemetepa, ȩ momó kepaayóló betaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ti fo depa, Pitané a̧ tu̧ dȩpaae dapesó fóló duraalu, “Tale-ó, mené ya̧paae atei kaae ala mo yaalomeipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ai fo depa Yesuné Pitapaae duraalu, “Satan-ó, ya̧ taae fae! Ȩ faai dere tu̧ wisi naao ai dere alané sesé dapó. Naao ai dere alata, Kótóné kisipa mole ala mei, mo whi̧né kisipa mole ala ai dere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Téró Yesuné ama yó matere whi̧rapepaae duraalu, “Whi̧ me detamo ȩ sya waai kisipa mutepata, ti ama yaai kisipa mole ala taaróló, a̧ dóló oloraaire filipaa ni, amatei beleyóló wó̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ti noatepa meipó. Mepaae whi̧ dené ama kisipané a̧ betere bete me ala yao̧sórópóló, amatei hotowayóló kaae tapata, ti ai whi̧né ama betere bete aluyaalo ai ape. Téyaalotei, mepaae whi̧ dené ya̧lo erae dere ala sya fóló eróturaalu, ama betere bete me o̧la meipóló a̧ sinitepata, ti atétere whi̧né ama betere bete aluni, mo ti betó tawaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","I haemó yó mole wisi wisi o̧la fea whi̧ beta̧né amatórótipóló tawóló betera̧lemó, ai whi̧né ama betere bete alutepa, ti me noa o̧latamo dupu yóló ama betere bete momó saaloé? Ama betere bete mo ti aluyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ti noatepae, kale Whi̧né Naalema ama Alimané ere au wisinaaletamo ama ensel-rapetamo wouraalu, so whi̧ doko̧ feané yale alarape su̧mótóróti dupu melaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ya̧lo dia̧paae mo i dere ape. Dia̧ i betó mole whi̧rape mepaae sukuni ha̧le betepatei, kale Whi̧né Naalema ama tȩteróló kaae tare alatamo wapa, kelaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Naase apomiró be dȩ kemetepa, Yesuné a̧tamo faairaalu, Pita, Jems-ró noma Jon-tamo atimanale mo doasi hasi fosópaae holalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Atéró holóló bituraalu, atimané kele tómótei Yesuné tiki mo kae daane wóló, ama kelepaakélé, sukané dȩ kaae yó felepó. Atéturaalu, ama deró betere kutikélé fea mo dȩ tekée felepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Atima atéró daae mupa, Moses-ró Elaijatamo sókó wóló Yesutamo fo du betepa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Atétu betepa, Pitané Yesupaae duraalu, “Tale-ó, da̧ fea imó betepa mo wisirapó. Naao kisipanétamo furu be sore ȩpaae tȩyae depa, ti me ya̧ betóo, me Ilaija betóo, me Moses betóo yaairetei, ya̧lo tȩnaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ama ai fo ha̧le du betepatei, mo dȩi sa̧koné atima husura̧le dorowóló ai sa̧ko dolomó i fo depa atimané wosalepó. “I whi̧ta, ya̧lo mo doasi hosaa muóló yaala sókó fóló mole naalepó. Ama dere ala ya̧lo kilitu, ȩ mo doasi hȩkeserapó. Atérapa, diaao̧ ama dere fotóró mo wisiyóló wosae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ama ai dere fo woseturaalu, atima mo doasi winé sinitu, haemó deraapisa fóló muó molepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Atépa, Yesu a̧ wóló, atima tikimó olaayóló duraalu, “Dia̧ wiyao̧se, turukó holóló betó muae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ai fo depa atimané kelalemó, whi̧ me daale kilini, Yesu beta̧ ama wotoró daapa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Atéró, atima hasi fosómó dorowou bitu, Yesuné kale whi̧rapepaae fo mulótu duraalu, “Kale Whi̧né Naalema mo ti dóló momó kepaayóló betaaire suka teópatei, i ala depa kelalepóló, mepaae so whi̧paae momókó yao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tétepa, ama yó matere whi̧rapené a̧paae duraalu, “Ti Moses-né ere fo yó matere whi̧rapené Elaijapi folosóró waalopó du betere-a, noa betené du bitu de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ti fo depa, Yesuné atimapaae duraalu, “Ti aita mo dapó. Ilaija a̧ wouta, take folosóró wisiyóló mole o̧la o̧la fea dopa, ama momó wisiróló mulaalo ape. ");
INSERT INTO ppo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ai alata mo yaalotei, ya̧lo dia̧paae i dere ape. Elaijata, ti mo walepó. Téyaletei, ita Elaijapóló kisipa muni, atimané a̧paae eraai kisipa mole ala fea mo erótua yalepó. Atéyale kaae, ai whi̧rapené kale Whi̧né Naalemapaaekélé kae kae sekȩi alarape eraalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ai fo depa, ama yó matere whi̧rapené kale wȩi tópuratere whi̧kó Jon-mó dapóló kisipa yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Atéró, atima so whi̧ fea betó mole tua̧paae sókó walemó, whi̧ beta̧ Yesu daalepaae wóló, a̧ daalemó bukutiri tea̧ró bitu duraalu, “Tale-ó, ya̧lo naale topo doturaalu, hó naase kotoko̧ yó sóró, si dolopaae ó wȩi dolopaae biliyó sua du beterapa, naao ko̧lené sukuturaalu tao saaloé? ");
INSERT INTO ppo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Naao yó matere whi̧rape beterepaae dapesó waletei, atimané wisiraairetei su̧nipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ai fo depa, Yesuné tokó̧ mótu duraalu, “Dia̧ mió i alimó betó mole so whi̧ta, Kótópaae kisipa tiki tiróló betaaire tu̧ wisi mupatei, kisipa tiréni, dowa̧ae fóló kó̧paae ai fu betere ai ape. Dia̧ tu̧ wisipaae fó̧póló kisipa mutu, ȩ dia̧tamo betale su̧mó hó̧né sukutapa, ai naale ȩ beterepaae dapesó ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Atéró, kale naale Yesu beterepaae dapesó wapa, Yesuné foné seremó, dowi kepe sókó felepó. Mo ai be dȩmótóróti kale naale topo doretei, mo ti wisiyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Téró, ama yó matere whi̧rape Yesu beterepaae wóló, atimasisi bitu a̧paae woseturaalu, “Da̧né ai kale dowi kepe dóló ho̧konalemó, sókó feniyaletei, noa betené yalerópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ti fo depa, ama atimapaae duraalu, “Diaao̧ kisipa tiki tiró betere ala tómó ereteiné ai yale ape. Ya̧lo dia̧paae mo i dere ape. Diaao̧ kisipa tiki tiró betere alata, sawatamo mastard ni ke kaae bulu, diaao̧ i ulupaae duraalu, ‘Hili̧ki fóló tumó daayae,’ depa ai ulu mo hili̧ki fóló daane faalo ai ape. Diaao̧ kisipa tikitamo mo ti tiró betepa, ti fea ala fea su̧mó enérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Téró, ama yó matere whi̧rape atima Kaleli haemó toura̧le wóló bitu, ama atimapaae duraalu, “Kale Whi̧né Naalema dó̧póló mené eleké deyóló, mepaae whi̧rapené naase tua̧paae mulaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Atéró atimané a̧ mo ti doló sukunaalotei, tamo be dȩmó maaté doumó muóló, sore be dȩné ti a̧ momó kepaayaalo ai ape,” depa, ama yó matere whi̧rape atima dekȩné sukutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Atéró, nalo Yesuné ama yó matere whi̧rapetamo Kapeneam bemó sókó felemó, kale momatere bemó takis moni siré kotere whi̧rape Pita beterepaae wóló woseturaalu, “Dia̧ yó matere whi̧né momatere bemó takis moni mótua dépé meié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ai fo depa, ama tokó̧ mótu duraalu, “Ȩ́pó. Mótua dapó,” yalepó. Atéró, Pita a̧ be tua̧paae sókó holalemó, folosóró Yesunépi Pitapaae woseturaalu, “Saimon-ó, naao noa kisipa mute? Naao kisipané i haemó betó mole doasi topo whi̧rapené kae kae o̧la o̧lamó moni suatere alaró takis moni siré kotere alatamo, mo atimané naalerapepaaekélé a̧lae dua dépé, mo whi̧rapepaae maaté a̧lae yóló, sua de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ti fo depa, Pitané a̧paae tokó̧ móturaalu, “Mepaae mo whi̧rapepaae maaté a̧lae yóló sua dapó,” depa, Yesuné duraalu, “Atétepa, ti doasi whi̧rapené naalerapepaae a̧lae yóló sinitu dapó. ");
INSERT INTO ppo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tépatei, da̧motamo atima dei tuȩ́ muao̧sórópa, ya̧ naao kemei sóró wȩipaae derane fae. Atéró dera̧lemó ya supa, ti ai folosóró sere yané ko̧ló da̧ayóló kelenaalemótamo, 4 drakima moni ke bupa kelaalo ai ape. Ai moni sóró fóló, da̧mo wusuróné takis mulae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Atéyale sukamó, Yesuné ama yó matere whi̧rape a̧ beterepaae wóló woseturaalu, “Hepen bemó Kótóné tȩteróló kaae tare ao̧mó whi̧ fea betó moletei, mo doasi topo betere whi̧-a, de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Ai fo depa, ama beta̧ naale beleka̧amale dape sóró atima betó mole tua̧mó daaló bitu duraalu, “Ya̧lo dia̧paae mo i dere ape. Dia̧ kisipa tiki feteyóló, etei naale ketei kaae bitinitepa, ti Kótóné tȩteróló kaae tare ao̧paae mo sókó faalomeipó. ");
INSERT INTO ppo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Térapa, mepaae so whi̧ detamo amatei deróló i naale male kaae mo dua betepa, ti ó hepen bemó betere Kótóné tȩteróló kaae tare ao̧mó topo whi̧ ai betere ape. ");
INSERT INTO ppo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mepaae whi̧ dené etei kaae naale male ya̧lo doimó, mo wisiyóló dape supa, ti ȩtei wisiyóló dape sirapó. ");
INSERT INTO ppo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Téretei, mepaae whi̧ denétamo mepaae doi muni, ȩpaae kisipa tiki tiróló betere belei sókó dei so whi̧ dowi ala yó̧póló me ala eratepa, ti atétere whi̧né depamó mo doakale kane fake duwóló wȩi kȩla tua̧paae taae falua̧sóró mo wisi wua̧pó. ");
INSERT INTO ppo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mepaae i haemó betó mole so whi̧né mepaae so whi̧ dowi ala yóló dée nó̧póló, mepaae alarape mo eraalo ai ape. Atétere whi̧ a̧tei mo dowi kwia saaireteimó, doasi wiyó̧póló yae! Ai alarape mo yaalotei, u kale whi̧ dowi ala yóló, dée naaitere tu̧ muao̧sóró yae. Me whi̧ atéró dowi ala yó̧póló, tȩ mulatere whi̧ ti doakale dowi kwia saaireteimó wió yae! ");
INSERT INTO ppo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Naao naase ó hóné ya̧ dowi ala yó̧póló dée nalatepa, ti atétere naase ó hó tukóló taae falae. Ti noatepae, naao naase ó hó beta̧ daayóló, mo ti betó tawaaire be tua̧paae sókó fupa wisirapó. Naao hó ó naase tamo daayóló betera̧le tikimó, Talené mo ti dó tare si dolopaae taae deratepa mo dorapó. ");
INSERT INTO ppo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Naao kelenétamo ya̧ dowi ala yó̧póló dée nalatepa, ti atétere kele sokóló taae falae. Ti noatepae, beta̧ keletamó bitu, mo ti betere be tua̧paae sókó fupa wisirapó. Naao kele tamo daayóló betepa, mo ti dó tare dowi sipaae Talené ya̧ taae derao̧sóró dapó.” ");
INSERT INTO ppo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ya̧lo dia̧paae mo i dere ape. I betó mole naale momale mo doi muni belei sokótei betepa, dia̧ teteirapepóló tȩterao̧se. Ti noatepae, atima kaae tare ensel-rape ó hepen bemó betere ya̧lo Aya Kótóné kelepaa koló tarapó. ");
INSERT INTO ppo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","I dere fo wosóló, diaao̧ noa kisipa mute? Whi̧ beta̧né ama 100 sipsip hupurape whaanalemó, beta̧ hupu alutepa, ama neté yaaloé? Kale 99 hupurape du sokoremó betó mupatei taaróló, kale beta̧ aluyale hupu kekene faalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ya̧lo dia̧paae mo i dere ape. Kale whi̧né ai aluyale hupu keletepa, ti a̧ mo hai̧né sinóló betaalo ai ape. Ti noatepae, betó mole 99 sipsip hupurape kilitu hai̧tu betepatei, kale aluyale sipsip hupu keletepa, dere hai̧né mo teraae falapó. ");
INSERT INTO ppo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Atére kaae, i kale doi muni belei sokótei so whi̧ beta̧kélé aluyao̧sóró, ó hepen bemó betere diaao̧ Ayané doasi kisipa mutu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Naao noné ya̧paae me dowi ala eratepa, ti ya̧ a̧ beterepaae fóló, diaamosisi beta̧mó bitu no-ó, naao ȩpaae etei kaae dowi ala eralepóló yó melae. Ama naao dere fotamo wosóló, hapale donoratepa, ti diaamo tua̧mó muale sekȩ kemeyóló, beta̧mó wisiyóló ai betere ape. ");
INSERT INTO ppo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aténi, naao dere fotamo woseni hó̧róló dowa̧ae fupa, ti kale asȩmó yóló muló betere fo sya furaalu, fea ala fea mo yalepóló, kelale whi̧ tamo ó sore dapesó fóló, dia̧ fea bituraalu, teraayóló ai sekȩ wisirae. ");
INSERT INTO ppo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Amatamo dia̧né dere fokélé wosenitepa, ti touró betere Keriso fake so whi̧né keletómó ha̧keamó yó meló̧póló yae. Atéra̧lemókélé, Keriso so whi̧né dere ma fo woseni hó̧ratepa, ti a̧ Keriso doi muni, ha̧le mo whi̧ kaae ó takis moni sere whi̧ kaae beteró̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ya̧lo dia̧paae mo i dere ape. Naao me whi̧ hamopaae erale dowi ala, mo yalepóló teraayóló kemeréni ha̧le muó tapa, ti Kótóné ó hepen bemókélé dokóló ai muló betere ai ape. Naaotamo me whi̧ hamomapaae erale dowi ala mo yalepóló teraatepa, ti Tale Kótóné ó hepen bemókélé, teraayóló muló beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ya̧lo dia̧paae i dere ape. Atétere kaae, dia̧kó whi̧ tamo mo beta̧ kisipa muóló ó hepen bemó betere ya̧lo Aya Talepaae momaturaalu, me o̧lakó wosetepa, ti ai wosetere o̧la ama mo melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ti noatepae, ya̧lo doi hale sóró horaairaalu, whi̧ tamo ó sorekélé touróló betepa, ti atima tua̧mó ȩkélé beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tétepa, Pita Yesu beterepaae wóló a̧paae woseturaalu, “Tale-ó, ya̧lo noné ȩpaae erale dowi ala ha̧le kemeraalopóló meteró fapo enére? Wȩi keró fapomó maaté yóló su̧póló taaranére?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ai fo depa, Yesuné a̧paae tokó̧ mótu duraalu, “Ya̧lo ya̧paae mo i dere ape. Wȩikeró félimó maaté deretei su̧nipa, deté fu beteró 77 félimó, ama dowi ala kemera̧le wó̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Atéró kale ó hepen bemó betere Talené tȩteróló kaae tare ao̧mó mole alata, etei ala dere kaaepó. Beta̧ doasi topo whi̧né ama moni kwia mulóló saletei, ama kutó diratere whi̧rapené meteró saleró taleyaai a̧ beterepaae ape yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Atéró, kaae sóró taletu betalemó, beta̧ 10,000 kold kapa sekȩ da̧le sóró, kwia mulóló sale whi̧ kale doasi topo whi̧ beterepaae dapesó walepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ai whi̧né ama kwia mulóló sale moni tokó̧ melaairetei su̧mó tanipa, ama doasiné mepaae kutó diratere whi̧paae duraalu, ai whi̧kélé, ama somakélé, naale senaalekélé, mené wae sóró dupu yó̧póló dotonóo, ama o̧la o̧lakélé mo fea me whi̧né dupu yó̧póló dotonóo, yae. Téró, ai moniné ti ama mole kwia kemeraairaalu, sóró ape yóló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ai ala yaaitepa, kale whi̧ a̧ ama doasi daale felekemó bukutiri tea̧ró bitu dua naamei fo yóló duraalu, ‘Ya̧lo ya̧ betemó kwia mulóló sale o̧la o̧la fea tokó̧ melaalopa, sawa kaae tawae,’ du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kale kutó diratere whi̧né fo depa, ama doasiné a̧ kelalemó, a̧ ko̧lené sukuturaalu, kwia mole moni me o̧la meipóló, kale whi̧ a̧ ha̧le fó̧póló dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Téyaletei, ai kale whi̧ a̧mo furaalu, ama 100 denarias moni kwia mulóló sale whi̧ kȩle felepó. Ti ai whi̧ta, atimaamo beta̧ kutó ditere whi̧póló kisipa muni, ama depamó botokó̧ sóró taru, mo deteraayóló duraalu, ‘Ya̧lo 100 denarias moni ya̧paae kwia mulapa, mo miótitei, hapale tokó̧ a̧lae’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ai fo depa, kale whi̧ a̧ bukutiri tȩane doropóló, mo dua naameiné a̧paae duraalu, ‘Ya̧lo tokó̧ melaalopa, sawa kaae tawae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Téyaletei, kale whi̧né kaae tawaalomeipóló, dipula be kaae tare whi̧paae duraalu, ‘Ama kale kwia sale moni tokó̧ melatere sukamó ti a̧ sókó daalaasepólópa, ha̧le beteró̧póló yae,’ depa, kale whi̧ dipula beteralepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Atétepa, mepaae atima beta̧ kutó ditere whi̧rapené ai ala kolóló, atimakélé dei tuȩ́ muóló sekȩtepa, atimané doasi topo whi̧paae i ala yalepóló a̧paae yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Atéró ene wale fo wosóló, kale doasiné ai ala yale whi̧paae ape yóló, a̧paae duraalu, ‘Ya̧ta mo dowi ala yó tare kutó diratere whi̧ ai ape. Naao ȩpaae mo dua naamei fo depa, ya̧lo ya̧paae doasi kwia moletei, me o̧la meipóló taaralepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Térapa, ya̧lo ya̧ ko̧lené sukó̧ló taalótu yale kaae, naaokélé diaamo beta̧ kutó ditere no hamoma ko̧leturaalu, ai ala iniyólópó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Atéró, kale doasi topo whi̧ a̧ fopaae buólo, u kale dipula be kaae tare whi̧paae duraalu, ‘Ama kwia mole moni momó tokó̧ meló̧pólópa, a̧ dipula beteróló, susupuróló fokosói ala deté fu betae,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ai fo deté fóló kemetepa, Yesuné ama yó matere whi̧rapepaae duraalu, “Naao no hamomané ya̧paae erale dowi ala me o̧lameipóló, mo hosaa turóné kemerénitepa, ti ó hepen bemó betere ya̧lo Ayané dia̧ doko̧ feapaaekélé ai kaae alatóró eraalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Atéró, Yesuné ai forape yóló kemetepa, ai Kaleli hae taaróló Judia hae kwiamó fole Jordan wȩi tȩyóló uté fakeró felepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Atéró fóló beteremó, so whi̧ feané a̧ sya wou betepa, atimané kisi beterape wisirótua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Atéró, mepaae Farisi whi̧rape Yesu beterepaae wóló a̧ ha̧sókó fuléró ka̧ae kelaai woseturaalu, “Kale yóló muló betere foné beta̧ whi̧né ama so sawa ha̧sókó fole ala, ó mepaae kae kae doasi dowi ala depakélé tokó̧ falatepa Kótóné fo mulepé munié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ti fo depa, Yesuné ama tokó̧ mótu duraalu, “Asȩmó yóló muló betere fo dosa̧ayóló diaao̧ kisipa munié? Take keké nale alimó so whi̧ aleturaalu, whi̧ kae aleyóo, so kae aleyóo erapó. ");
INSERT INTO ppo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Atére betené beta̧ whi̧ a̧ so dokoturaalu, ama alimaró hamatamo taaróló, ama somatamo mo beta̧ tikitóró daayóló betaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","“Atimaamo tamotei, Kótóné dekaaporóló mo beta̧ tikitóró alée faló beteretei, mo whi̧né tekeyao̧sóró yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ai fo depa, kale Farisi whi̧rapené a̧paae duraalu, “Ti ai fo epateimo, Moses-né yóló muló betere foné duraalu, whi̧ beta̧né ama soma tokó̧ falaai depata, ti so tokó̧ falatere asȩ ai soné sóró fó̧póló, melae ere fomo, ha̧le noatepa yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ai fo depa, Yesuné atimapaae tokó̧ mótu duraalu, “Moses-né ai ere fota, diaao̧ dowa̧ae fóló du betere alamó, so tokó̧ falaai depa, ha̧le ho̧ko tokó̧ feni, asȩ sóró fó̧póló melae yóló ai ere ape. Ti atéró so tokó̧ fatu betere alata, take keké nale alimó, Talené atei ala yae yóló inipó. ");
INSERT INTO ppo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ya̧lo dia̧paae mo i dere ape. Mepaae whi̧né ama soma me nópu nénipatei, ha̧le tokó̧ faróló, ai whi̧ a̧ me kae sotamo dokotepa, ti atétere whi̧ a̧ dowi ala yóló mo ti folokoleratapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ti fo depa, ama yó matere whi̧rapené a̧paae duraalu, “So dokóló betere ala doasi hapólu ereteiné da̧ so dokoni ha̧le betepakélé, mo wisirapóló kisipa mutapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tétepa, Yesuné atimapaae duraalu, “Whi̧ fea so dokoni, ha̧le betenénitei, atei ala yó̧póló Talené ama tukóló muló betere whi̧né beta̧ mo su̧mó enérapó. ");
INSERT INTO ppo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ti noatepae, take mepaae whi̧rape hamané deyale sukamótei, nóluku fopei deyóo, mepaae whi̧rape ti mo whi̧nétei nóluku sokóo, mepaae whi̧rape ti Kótóné ó hepen be tua̧mó tȩteróló kaae tare ao̧mó mole ala eraairaalu, so dokotere ala taaróló, Talené kutó beta̧ diróo dua dapó. Mepaae whi̧rapené i dere fo sya fóló, ya̧ naao wotoró bitu Talené ala mo su̧mó eranérapóló kisipa mutepata, ti téyó̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Téró, so whi̧ atimané naale senaale Yesuné naase mulóló momaró̧póló dapesó walepó. Téyaletei, ama yó matere whi̧rapené ai kale naale senaale dapesó wale so whi̧ foné sóró seséyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Atétepa, Yesuné duraalu, “Mepaae so whi̧tamo i naale senaale kaae betepa, ti Kótóné tȩteróló kaae tare hepen bemó mole alarape saalo ai ape. Térapa, ai naale senaale atima ȩ beterepaae wó̧pólópa, sesé yao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Atéró, ama atimané tikimó naase mulóló momayóló kemetepa, atima ai betere tiki taaróló felepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Téró, whi̧ beta̧ Yesu beterepaae wóló woseturaalu, “Yó matere whi̧-ó, mo ti betó tare bete saairaalu, noa wisi alakó yaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ti fo depa, Yesuné a̧paae duraalu, “Noa wisi alakó yaaloé? yóló, ȩpaae wosetere-a, noatepa de? Ti wisi ala erótu betere Tale beta̧ beterapa, ai ti betere bete saaitepa, ti ama yae yóló muló betere fo beta̧ wisiyóló sya fóló eró tawae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ai fo depa, kale whi̧né duraalu, “Noa ala maaté?” depa, Yesuné a̧paae tokó̧ móturaalu, “Whi̧ me ti dóló sukunao̧se, so nópu nao̧se, o̧la o̧lémi sao̧se, me whi̧ dilikó̧ló só deraairaalu, kapala fo yao̧se erapó. ");
INSERT INTO ppo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Naao dere alaró dere fotamoné naao hae aya wisi doi muó̧póló hae aya ao̧mó naameyóló mo dua betae. Téturaalu, naaotei ya̧ yaala sókó fu dere kaae, naao be whi̧ so whi̧paaekélé, atéró yaala sókó fu betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tétepa, kale kokopei whi̧né duraalu, “Ai yae yóló muló betere alarape beta̧kókélé ya̧lo tikini, betere doko̧ fea ya̧lo sya fóló eró tarapa, me noa alakómo ha̧sókó fóló ya̧lo inire?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ti fo depa, Yesuné a̧paae duraalu, “Naao kisipanétamo mo beta̧ alakókélé ha̧sókó feni, mo turó sya fóló eratere whi̧ betaai kisipa mutepa, ti ya̧ fóló, naao tare o̧la o̧larape fea dotonóló moni sóró yoleale yóló betere whi̧rapemó ha̧le melae. Atétepa, ti naao saaire o̧la o̧la ó hepen bemó mo doasi horóló mupa, saalo ai ape. Atéró melólóta, ya̧ ȩ sya ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Téró, kale kokopei whi̧né ai dere fo wosóló furaalu, a̧ o̧la o̧la fea tare néli whi̧ betereteiné, a̧ fomoné sinité felepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Téró, Yesuné ama yó matere whi̧rapepaae duraalu, “Ya̧lo dia̧paae mo i dere ape. Fea o̧la o̧la mole néli whi̧ Kótóné tȩteróló kaae tare hepen be tua̧paae sókó faairetei mo dirirapó. ");
INSERT INTO ppo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ya̧lo dia̧paae momó i dapa wosae. Kamel hupuné ketȩ́li dolomó sókó fenéretei, o̧la o̧la fea tare néli whi̧ Kótóné tȩteróló kaae tare hepen be tua̧paae sókó faairetei mo doasi dirirapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tétepa, ama yó matere whi̧rapené ai dere fo wosóló atima fomo depa, a̧paae woseturaalu, “Noa kaae whi̧mo aluyao̧sóró, tao saaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ai fo depa, Yesu atima beterepaae fetée fóló duraalu, “Atei ala fea mo whi̧né enénitei, Kótóné ama beta̧ fea ala fea mo su̧mó enérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ti fo depa, Pitané a̧paae duraalu, “Tale-ó, mióta da̧né tare o̧la o̧la fea taaróló, ya̧ sya walapa, naao da̧paae noa o̧lakó melaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ai fo depa, Yesuné atimapaae duraalu, “Ya̧lo dia̧paae mo i dere ape. Take i haeró sa̧tamo ó o̧la o̧la fea momó kae kisi aleyóló mulatere sukamóta, kale Whi̧né Naalema tȩteróló kaae tare doasi betere tikimó ama mo kae ere au wisinaale yóló betepa, kelaalopó. Téró, dia̧ ȩ sya wale whi̧rapekélé ai kale 12 doasi topo whi̧ betere tikimó bituraalu, 12 Israel fakerape taleyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mepaae whi̧ dené ama be ó noma ó nema ó hama alima ó ama naale senaale ó ama kutó ó hae tikikélé fea taaróló, ya̧lo ala eraairaalu fupa, ti ai taaróló wale o̧la o̧lamó Talené beleróló, 100 félimó melaalo ai ape. Téturaalu, ai tómó mo ti betó tare betekélé matepa saalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Téyaalotei, mepaae mió mo doasi doi mole so whi̧rape take nalo atima doi munire whi̧ kaae betaalopó. Mió mepaae doasi doi muni, ha̧le ho̧ko sókó deyóló betere so whi̧, ti take nalo mo doasi doi mole topo whi̧ kaae betaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ó hepen bemó Kótóné tȩteróló kaae tare alata, etei ala kaaepó. Beta̧ hae tale mo hi̧kati ama wain kutó diró̧póló, whi̧rape sóró beteraai dapóló felepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Atéró, kale kutó talené mepaae whi̧rape sóró atimapaae duraalu, ‘Beta̧ be dȩmó ditere kutómó denarias moni beta̧ melaalopa, ya̧lo wain kutó dirane faaloé?’ yóló wosalemó, téyaalopó depa, dini fó̧póló dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Atéró, hi̧ka 9 kilok sukakelemó, kale kutó tale a̧ momó fóló kelalemó, mepaae whi̧rape so whi̧ fea touratere tikimó ha̧le daae mupa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","5","Atépa, ama atimapaae duraalu, ‘Diaao̧ ditere kutó su̧tóróti dia̧kélé ya̧lo dupu yaalopa, ya̧lo wain kutó dirane fae,’ depa, atima felepó. Atéró, 12 kilok sukakelemókélé, mepaae whi̧rape ha̧le daae mupa kale dere fo kaae yóló dotonóo, kuluka 3 kilok-mókélé, atéró dotonóo yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mo kuluka 5 kilok-mó a̧ momó fóló kelalemó, kale dere kaae mepaae whi̧rape ha̧le daae mupa kolóló, duraalu, ‘Dia̧ imó ha̧le noatepa daae mulu de?’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ai fo depa, atimané duraalu, ‘Me whi̧né da̧ ama kutó diró̧póló sinitepa ha̧le i daae mole ape,’ depa, kale whi̧né duraalu, ‘Dia̧kélé, ya̧lo kutó dirane fae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Atéró, be diki deretamo kale kutó talené ama kutó diratere whi̧rape kaae tare whi̧paae duraalu, ‘Ai kutó diratere whi̧rapepaae ape yóló, atimané dupu mótu, nalo ki dini wale whi̧rapemó kaae sóró melaté fóló, folosóró wale whi̧rapepaae kemera̧le fae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Téró, kuluka 5 kilok-mó kaae sóró kutó diyale whi̧rapekélé fea denarias moni beta̧tóró matepa sua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Atérótóró maté fóló kemetepa, kale folosóró hi̧kati kutó dini fele whi̧rape atimané moni horóló melaalo nisi yalemó, kale nalo wale whi̧ melale denarias monitóró atima fea beta̧ beta̧ yóló matepa, sua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Atéró moni sóró kemetepa, kale kutó taletamo dei tuȩ́ muturaalu, monimó dokó dokó dere ala kaae sóró du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Atima mo hi̧kati kaae sóró kutó dirale whi̧rapené kale kutó talepaae duraalu, ‘Da̧ta, doasi suka suputamokélé, mo depe tukó wei kutó ditu betalepó. Téyaletei, kuluka mo beta̧ sukakelemó kutó dirane wale whi̧rapekélé, da̧ melale su̧tóróti ai melale ape,’ yóló, kale kutó taletamo fo tokó̧tamo du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tétepa, ama atimakó whi̧ beta̧paae duraalu, ‘No-ó, ya̧lo naao moni tukóló menéni, mo donotóróti i matere ape. Take hi̧kati da̧mo fo dokoturaalu, ya̧paae denarias moni beta̧tóró melaalopó fo ya̧paae inié? ");
INSERT INTO ppo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Térapa, mió naao moni sóró fae. Nalo ya̧lo kutó dirane wale whi̧rapekélé, dia̧ melale kaaetóró, atimakélé melaai kisipa mutapó. ");
INSERT INTO ppo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ya̧lo moniné me ala enépa, ti ya̧lo mo su̧mó enérapó. Ya̧lo hamokoturaalu me whi̧paae eratere alamó naao ȩtamo noatepa dei kisipa mutu de?’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ai ala du dere kaae, nalo wale whi̧ folosóró fóo, folosóró fele whi̧ ti nalo wóo yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Téró, Yesu a̧ Jerusalem be huluapaae holaairaalu, ama yó matepa wosetere 12 whi̧rape atimasisi fu bitu tu̧ dȩpaae dapesó fóló, atimapaae duraalu, “Mióta da̧ Jerusalem be huluapaae holaai i fole ape. Téteretei, kale whi̧né Naalema mepaae whi̧né eleké deyóló, so whi̧mó Talepaae momaratere whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamoné naase tua̧mó mulale faalopó. Ai whi̧rapenémo a̧tamo fo tokó̧tamo yóló, a̧ só deróló, mo ti sinó̧póló, daairaalu fo dokaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Atéró, ai whi̧rapenémo ti Juda mei, kaae fakené naase tua̧paae mulatepa, atimané a̧ faleyóló doka doka yóo, fokosói ala yóló susupuróo, filipaa ni tómó oleróló dóo yaalo ai ape. Atéró mo ti suka̧alotei, sore be dȩmó ti Talené a̧ momó kepaaróló beteraalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Téró, kale Sebediné naalema tamo hamané Yesu beterepaae dapesó walepó. Atéró, wóló kale so a̧ bukutiri tȩane doropóló bitu duraalu, “Ya̧lo i eraasepé yóló ya̧paae wosetere ala wisinaalekó naao eraaloé?” yóló wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tétepa, ama a̧paae duraalu, “Ya̧lo ya̧mó noa alakó eró̧póló kisipa mute?” depa, kale soné duraalu, “Naao tȩteróló kaae tare be tua̧mó, ya̧lo i naale tamokó me naale naao turu naase dȩmó beteróo, me naale naao fȩ́ naase dȩmó beteróo, yaasepóló dapó” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ai fo depa, Yesuné kale whi̧ tamopaae duraalu, “Diaamoné ȩpaae ai wosetere fo beteta, diaamo kisipa inipó. Dowi ala kwia tokó̧ló aluraairaalu, susupu sóró sinaaire ala, diaamonékélé su̧mó senére?” depa, atimaamoné duraalu, “Da̧monékélé su̧mó senérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ai fo depa, Yesuné atimaamopaae duraalu, “Ya̧lo naaire wutimó belere wȩi diaamonékélé su̧mó naalotei, turu naase ó fȩ́ naase dȩmó betaaire alata, ti ya̧lo tȩteróló kaae tanipó. Ai alata, ya̧lo Ayané ama tȩteróló kaae taru, aimó betaaire whi̧ tamokélé, ama mo taketitei tukóló beteró beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tétepa, kale mepaae yó matepa wosetere naase tamo whi̧rapené ai dere fo woseturaalu, u kale whi̧ró nomatamopaae fopaae yóló dei tuȩ́ mualepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Atétepa, Yesuné atimapaae toura̧le ape yóló duraalu, “Juda mei, kaae fake tȩteróló kaae tare topo whi̧rapené mo so whi̧ tȩteróló kaae tawóo, atimané sóró beteró betere whi̧rapenékélé mo so whi̧ tȩteróló kaae taru, i ala erae du beteretei diaao̧ ai kisipare ape. ");
INSERT INTO ppo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Atétere kaae, dia̧ tua̧mókélé ai ala momókó yao̧se. Aténi, dia̧ tua̧mótamo doasi topo whi̧ betaai kisipa mutepa, ti so whi̧ feané kutó diratere whi̧ beteró̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Whi̧ me de doasi doi mole whi̧ betaai kisipa mutepa, ti dia̧né wae sóró kutó diratere whi̧ kaae betae. ");
INSERT INTO ppo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kale Whi̧né Naalema waleteita, ama kutó diró̧póló mepaae whi̧rape sóró beteraai wéni, mo whi̧né kutótei ama diróo, so whi̧né betere bete aluyao̧sóró, ama betere bete ha̧le melóló, dupuróló tao sóo yaairaalu, walepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Atéró, Yesu a̧ ama yó matere whi̧rapetamo ai Jeriko be hulua taaróló fu betalemó, so whi̧ mo feané atima sya wou betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Atétepa, kale kele dilikire whi̧ tamo tu̧ dȩmó beteremó, Yesu fu beterapó dere fo wosóló, fo fakeyóló duraalu, “Depit-né Naalema Tale doa whi̧-ó, da̧mo ko̧lené sukuturaalu, tao sae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ai fo depa, so whi̧ feané kale whi̧tamopaae taalae yóló foné supatei, woseni nisiyóló, mo ti fo fakeyóló duraalu, “Depit-né Naalema doa Tale-ó, da̧mo ko̧lené sukuturaalu tao sae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Atétepa, Yesu a̧ aimó kei̧yóló daalu, kale whi̧ tamopaae ape yóló, atimaamopaae woseturaalu, “Ya̧lo diaamopaae noa alakó eró̧póló de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ai fo depa, atimaamoné duraalu, “Tale-ó, naao da̧moné kele wisiraasepóló dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tétepa, Yesuné mo ko̧lené sukuturaalu, atimaamoné kelemó olaa yalepó. Atéró olaa yaletamotóró atimaamoné kele wisitepa, Yesu sya felepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Atéró, atima Jerusalem be huluapaae felekemó sókó faai, kale Olip du sorokó molemó tȩne Betpas bemó sókó felepó. Aimó Yesuné ama yó matere whi̧tamo dotonaai duraalu, “Diaamo u be huluapaae fóló kelenalemó, beta̧ donki hupu ama maletamo halikané duló betaalo ai ape. Téyaalopa, ai hupu ama maletamo wusuró ȩ beterepaae taayóló sóró ape. ");
INSERT INTO ppo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Whi̧ menétamo diaamopaae, ai hupu neyaai taayóló só fute? depa, i fo yae. ‘Talené ama kutó doasi moletei, diyóló kemetepa, momó sóró waai, kapala asiri sera̧le fae yale tikimó sóró fulapó,’ yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Até yaleteita, take Kótóné ama ko̧ló whi̧né yóló muló betere fo motóró dokonóturaalu yalepó. Ai fo i ape. ");
INSERT INTO ppo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalem be hulua so whi̧-ó, diaao̧ doasi topo whi̧ ai walapa, kelae. A̧ta fopaae buni, mo naamei whi̧ teó utu̧ donki hupuné sisó tómó betóló ai walapa, kelere?” erapó. ");
INSERT INTO ppo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Atéró, Yesuné ama yó matere whi̧tamo fóló, atimaamopaae yae yale alatóró yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Téró, kale whi̧ tamoné donki hupu ama maletamo wusuró dapesó wóló, atima feané kuti sokóló, ai hupuné sisó tómó whamenóló, ai tómó Yesu beteralepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Atéró, so whi̧ feané kutirape sokóló tu̧ tómó whamenaté fóo, mepaae so whi̧né ti ni tetei̧rape tukóló whamenaté fóo du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Atétepa, mepaae so whi̧ ti a̧tamo folosóró fóo, mepaae so whi̧ nalo wóo du bitu, fo fakeyóló a̧ dukiróturaalu, “Hosana, Depit-né Naalema doa whi̧-ó, da̧ tao sae.” “Talené doimó wale whi̧ wisinaale Kótóné wisiró̧póló yae.” “Mo ó taoró betere Tale Kótóné doi hale sóró horae,” deté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Atéró, Yesu a̧ Jerusalem be huluapaae sókó felemó, so whi̧ feané fo tiki whaatamo a̧ busuró wou betepa, ai be huluamó betó mole so whi̧né woseturaalu, “Ai wale whi̧-a de yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ti fo depa, a̧ busuró wale so whi̧ feané atimapaae duraalu, “A̧ta, Kaleli haemó tȩne Nasaret be hulua whi̧kó Kótóné fo eratere ko̧ló whi̧ Yesupó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Atéró, Yesu a̧ momatere be dolopaae sókó holalemó, ai be dolomó whi̧rape o̧la o̧la dotonóló duputamo yóló su betepa, atima ho̧kóló taae faralepó. Téró, kae kae be hulua whi̧ atimané kae kae moni duputamo du betere whi̧rape bitua dere ni fakerapekélé, kale ba ho̧kósere dotonóló dupu du betere whi̧rape bitua dere fo̧loi ni fakerapekélé fea fesekeyó mepaae whi̧rape dóló hokó̧ faróló, fetée deralepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Atéró, ama atimapaae duraalu, “I fo asȩyóló muló beterapó. Ya̧lo i beta moma beta̧ yaairaalu tȩnapó. Tépatei, diaao̧ ai dere alané o̧lémi nokole whi̧rape betere be ao̧rótu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Téró, mepaae kele dilikire whi̧raperó hó momaare whi̧rapetamo, ai momatere be tua̧paae wua depa, Yesuné atima wisirótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Téyaletei, ama ai dere ala wisinaale kolóo, ai momatere be tua̧mó betó mole naale senaalené fo fakeyóló, “Hosana, Depit-né Naalema-ó,” yóló du betere fo kale mo so whi̧mó Talepaae momaratere topo whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamoné wosóo, yóló, atima dei tuȩ́ muturaalu fopaae bualepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tétepa, atimané a̧paae woseturaalu, “I naale senaalené du betere fo-a, naao wosere?” depa, Yesuné tokó̧ mótu duraalu, “Ȩ́pó. Kale asȩyóló muló betere fo diaao̧ dosa̧ayóló kisipa muni airapó. Ketei naale senaaleró tȩnemó teó belere naale senaaletamoné Kótóné doi hale sóró horó̧pólópó yóló, Talenétei tukóló muló beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Atéró, atima ai be huluamó betó mupa taaróló, a̧ u Betani be huluapaae fóló, diki beta̧ fiyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Atéró, a̧ mo hi̧kati u kale be huluapaae momó fesaae yóló fu betalemó, tu̧mó a̧ mo wotené sinalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Atépatei, a̧ fu betalemó, tu̧mó ni nose daapa, nose daale felekepaae fóló kelalemó, dukélé woleni, ha̧le sókumaaté epa kelalepó. Atépa, ai nipaae duraalu, “Du momó kaae woleyaalo mei ai ape,” yalepó. Ai fo yaletamotóró kale ni mo ti séliyó deyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Atéró ama yó matere whi̧rapené ai kale ni sélitere ala kolóló siraturaalu, i ni hapale tétitei séliyale-a, neyóló yalerópóló, atimané a̧paae wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ai fo depa, Yesuné atimapaae duraalu, “Ya̧lo dia̧paae mo i dere ape. Diaao̧ kisipa tiki tamo muni, mo ti tiró bitutamo, ya̧lo nipaae yale kaae, diaao̧kélé ai ulupaae ya̧ daale tiki taaróló, a wȩi kȩla tómó daane derepae depa, mo téyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Diaao̧ kisipa tikitamo Talepaae mo ti tiró bitu, moma duraalu, noa o̧lakó wosetepa, ti diaao̧ ai wosetere o̧la mo saalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Atéró, Yesu a̧ momatere be tipiné bopéró daaló beterepaae fóló, yó mótu betepa, mo so whi̧mó Talepaae momaratere whi̧raperó mepaae whi̧ disirapetamo wóló a̧paae woseturaalu, “Naao ai alarape du beteró̧póló, ya̧ né sóró beteraleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ti fo depa, Yesuné atimapaae tokó̧ mótu duraalu, “Ya̧lokélé dia̧paae beta̧ wosetere fo yaalopó. Ya̧lo wosetere fotamo diaao̧ ȩpaae tokó̧ matepa, ti ȩpaae ya̧ né sóró beteratepa de? yóló wosale fokélé ya̧lo dia̧paae tokó̧ melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Take Jon-né so whi̧ wȩi tópurale ala momó kaayóló waleé? Ó hepen bemó betere Talené yae depa yalepé, ha̧le mo whi̧né yae depa, yaleé?” yalepó. Ai fo depa, atimasisitei fo kȩlaaróló duraalu, “Da̧nétamo ó hepen bemó Talené yae depa yalepó enalemó, ti da̧paae diaao̧ ama dere fo wosóló, a̧paae kisipa tiki tiréni dere ala noatepa yale? fo yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ti mo whi̧né yae depa yalepó fo ua̧tei, Jon a̧ Kótóné ama fo eratere ko̧ló whi̧póló so whi̧ mo feané kisipareteiné, atima da̧ dao̧sóró wirapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Atétepa, atimané Yesupaae duraalu, “Da̧ kisipanipó,” yalepó. Ti fo depa, ama atimapaae duraalu, “Mené ȩpaae i alarape yae depa dapóló, ya̧lokélé dia̧paae yó melaalomeipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","29","Atéró atimapaae duraalu, “I dere fo wosóló, diaao̧ noa kisipa muaaloé? Whi̧ beta̧né ama naale tamo beterepó. Tépa, kale whi̧ a̧ ama me naale beterepaae fóló duraalu, ‘Ti naale-ó, ya̧ ya̧lo wain kutó dirane faasepólópó,’ yalepó. Téyaletei, kale naalené alimapaae naao kutó dirane fole a̧ hó̧rapó yaletei, nalomo ama kisipa feteyóló wisirapóló dirane felepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tétepa, kale whi̧ ama me naale beterepaae fóló, me naalepaae yale fo kaaetóró yalemó, ai naalené duraalu, ‘Aya-ó, wisirapó téyaalopó,’ yalepó. Téyaletei a̧ feni, hó̧yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","I kale naale tamokó mé naalené ama alimané kisipa mole ala eraleé?” depa, atimané tokó̧ mótu duraalu, “Folosóró yale naalenépó,” yalepó. Tétepa, Yesuné atimapaae duraalu, “Ya̧lo dia̧paae mo i dere ape. Kale takis moni siré kotere whi̧raperó nópu nokole sorapetamo Tale Kótóné tȩteróló kaae tare be tua̧paae sókó furaalu, folosóró atimapi faalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ti noatepae, kale wȩi tópuratere whi̧kó Jon waleteita, mo donoi alamaaté yó melaai waletei, dia̧né ama dere fo wosóló, kisipa tirénipó. Téyaletei, takis moni siré kotere whi̧raperó nópu nokole sorapetamoné ti ama dere fo wosóló, mo dapóló kisipa tiralepó. Atéró, atimané du betere alakélé diaao̧ kolólótei, mo dapóló dia̧né dowi ala taaróló, kisipa feteyóló, tirénipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Atéró, Yesuné duraalu, “Fo sale fo me kae i dapa wosae. Beta̧ whi̧né ama haemó wain kutó diyóló, tipiné bolaayóló atimané wain képi du do̧wóló wȩi tepeyaairaalu, kutu̧ diri duki̧yóo, kale kutópaae o̧lémi whi̧ wale kelaai kaae tawóló betaaire be fo̧lo mo sikipaae horóló tȩyóo yalepó. Atéró kale whi̧ a̧ mepaae uké faairaalu, mepaae kutó diratere whi̧rapepaae ama kutó kaae tawae yóló, atima sóró beteróló a̧ felepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Atéró, kale wain du teketere ali wapa, ama mepaae kutó diratere whi̧rape u kale kutó kaae tare whi̧rape beterepaae u̧lumétepa sóró muló betere o̧lakó senaale fae yóló, dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Téyalemó, ai kale kutó kaae tare whi̧rapené u kutó diratere whi̧rape me whi̧ ha̧le fokosói ala yóló susupuróo, me whi̧ mo ti dóló sukunóo, whi̧ me kapo duné siriyóló dóo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Até itikimó, momómo kale whi̧né ama mepaae kutó diratere whi̧rape dotonalemó, ai whi̧rapekélé take folosóró dotȩyale whi̧rapepaae erale ala kaaetóró ipakalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Atéró, nalo mo ti kemeróturaalu, kale whi̧né ama naale so whi̧né mo wisiyóló dape saalopóló kisipa muóló, dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Téyaletei, kale kutó kaae tare whi̧rapené kale whi̧né naalema wale kolóló, atimasisi fo kȩlaaróló duraalu, ‘Ai naalenéta, ama alima sinitepa, o̧la o̧la fea ama saai du beterapa, ai o̧la o̧la fea da̧né saai a̧kélé daalopa, siépe,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Atéró, atimané kale naale ai kutó alépaae tao sóró taae deróló mo ti dalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Atépa, ai kale wain kutó tale wouraalu ai kutó kaae tare whi̧rapepaae noa alakó eraaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ti fo depa, atimané a̧paae tokó̧ mótu duraalu, “Mo sonaalei dowi ala du betere whi̧rape atima mo ti sinó̧póló ama daalo ai ape. Atéró, ama kale wain du u̧lumétepa sóró wisiyóló bukóló atima sóo, kale kutó tale melóo, yó̧póló mepaae whi̧rapepaae kaae tawae yaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ai fo depa, Yesuné atimapaae duraalu, “Kótóné asȩmó yóló muló betere fo diaao̧ dosa̧ayóló kisipani airapó. ‘Kale doakale kane fake be tȩtere whi̧rapené dopa taae farale kapotei, be hulua deyaaire doasi eleké alée felepó. Ai kelaalo koko̧i ala, Talenétei eró betepa da̧né kilituraalu, sira du beterapó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Térapa, ya̧lo dia̧paae i dere ape. Kótóné ama tȩteróló kaae tare ala wisi dia̧ tua̧mó moletei, ama tokó̧ sóró du wisinaale woleraaire so whi̧paae melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Whi̧ me de ai kane fake tómó dé nukupa, ti ai whi̧né ama diri derakó̧ faalotei, whi̧ me detamo ai kane fake dorowouraalu tȩiyaratepa, ai whi̧ mo ti derakó̧ fóló muaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Atéró, mo so whi̧mó Talepaae momaratere topo whi̧raperó Farisi whi̧rapetamoné ai yale fo sale forape woseturaalu, Yesuné ai yale fota, atimapaaetóró yalepóló kisipa mualepó ");
INSERT INTO ppo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Atétepa, atimané a̧ daaire tu̧ kikitu betaletei, so whi̧ feané kisipané a̧ta ha̧le mo whi̧ mei, Kótóné ama fo eratere ko̧ló whi̧póló kisipareteiné, atima dao̧sóró witepa taaralepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Atéró, Yesuné atimapaae fo sale me kae yóló duraalu, “Kótóné ó hepen bemó tȩteróló kaae tare ao̧mó mole alata, beta̧ doasi topo whi̧né ama naalemané so dokotere be dȩmó o̧la deraairaalu, donoróló mulatere kaaepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kale whi̧né atéró detere o̧la naai ape yóló ali male so whi̧ dape sene fae yóló, ama kutó diratere whi̧rape dotonaletei, atima hó̧yóló waalomeipó yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tétepa, ama mepaae kutó diratere whi̧rapemo dotonótu duraalu, ‘I detere o̧la naai ape yóló ali male so whi̧paae i fo yae. Ya̧lo o̧lata taleyóló mulóló, bulmakau hupuró mepaae seraai huputamo dóló turukiyóló mulóo, mepaae o̧la o̧lakélé fea mo su̧mó taleyóló mulóo erapa, ya̧lo naalené so dokotere be dȩmó detere o̧la naai ape yae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Téyaletei, atima ai dere fo woseni nisiyóló, dapo dapo yóló, me whi̧ ama kutópaae fóo, me whi̧ ti ama yaai tuȩ́ mole alapaae fóo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mepaae feni ha̧le betere whi̧rapené ti ama kutó diratere whi̧rape fokosoi ala yóo, mepaae mo ti dóló sukunóo yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Atétepa, kale doasi topo whi̧ a̧ fopaae buóló ama diki tare whi̧rape u kale whi̧rape dale whi̧rape dóló kemeróo, atimané doasi be huluakélé si biliyóló, torokó̧ fa̧le fae depa atima fóló, si biliyóo yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","9","Téró, ama kutó diratere whi̧rapepaae duraalu, ‘Kale so dokoteremó detere o̧la su̧mó taleyóló muló betepatei, ai o̧la naai ape yale whi̧rape atima i detere o̧la naaire mo su̧nipa taaróló, dia̧ fóló, doasi bepaae fole tu̧ dȩmó ó sawatamo tu̧mó mepaae so whi̧kó keletepa, ti i detere o̧la naai faalopóló dape siré kwȩae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Atétepa, ama kutó diratere whi̧rape doasi be huluapaae fóló, tu̧tu so whi̧ keketé kwȩyóló, wisi so whi̧ró dowi so whi̧tamo ho̧ko dape siré kwȩyóló, tourale tikimó, be mo ti fa̧ae felepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Téyaletei, kale doasi topo whi̧ ai o̧la naai wóló betó mole so whi̧ kuapaae fóló kelalemó, whi̧ beta̧ kale so dokotere be dȩmó o̧la naairaalu, derótua dere kuti deró bitinipa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Atépa, kale doasi topo whi̧né a̧paae woseturaalu, ‘No-ó, ya̧ so dokotere be dȩmó detere o̧la naai derótua dere kuti derénire noatepa yaleé?’ yóló foné salemó, kale whi̧ haleturaalu, fokélé tekeni, hokomó sókó fi beterepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tétepa, kale doasi topo whi̧né ama kutó diratere whi̧paae duraalu, ‘Ai whi̧ belamó diliki dolomó wole du bitu ama serekenétei, a̧ turukóló nuku beteró̧pólópa, hó naase dokóló taae derae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ti noatepae, so whi̧ mo turó ape yaletei, tóróti sokósu yale so whi̧maaté wóló beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Téró, kale Farisi whi̧rape fóló, Yesuné ama dere fomó a̧ só deraai dapóló, fo dokóló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Atéró, atimané yó matere whi̧raperó Herot-né fo eratere whi̧rapetamo Yesu beterepaae dotonóló, atimané a̧paae duraalu, “Yó matere whi̧-ó, ya̧ beta̧ mo fomaaté yó mótu bituraalu, Kótóné ama kisipa mole ala ó yóló muló betere fo mo sya fóló erótu beteretei, da̧né kisiparapó. Ti noatepae, naao fo yó móturaalu doasi doi mole so whi̧ kolóló ya̧ wini, doasi doi mole so whi̧paaekélé, doi muni belei sókó deóló betere so whi̧paaekélé, mo beta̧ kaae alatóró erótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sisapaae takis moni matere ala wisirépé, dore? Ti naao noa kisipa mute?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ai fo yaletei, atima dowi kisipa muturaalu, Yesuné a̧ só deraai tu̧ kikitu betere ala kolóló, atimapaae duraalu, “Dorutei tó tikiné ha̧le siki̧li du betere whi̧rape-ó, noatepa diaao̧ ȩ só deraai tu̧ kikitu bitu de? ");
INSERT INTO ppo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","20","Térapa dia̧né takis melótua dere moni ya̧lo kelaalopa sóró ape,” yalepó. Tétepa, atimané a̧ beterepaae beta̧ denarias moni sóró wapa, ama atimapaae woseturaalu, “I asoró i mole doitamo-a, né?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ai fo depa, atimané a̧paae tokó̧ mótu duraalu, “Aita Sisanépó,” yalepó. Tétepa, ama atimapaae duraalu, “Sisané o̧lapa ti Sisapaaetóró melae. Kótóné o̧lapa, ti Kótópaaetóró melae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yesuné atéró dere fo woseturaalu, “Haió!” yóló sirayóló, atima a̧ taaróló felepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Atéyale be dȩtamotóróti mepaae Sadyusi whi̧rape Yesupaae beta̧ fo wosaai dapóló walepó. Ti ai Sadyusi whi̧rape atima kisipanéta, suka̧le so whi̧ momó kae kepaayaalo meipó dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Atétere whi̧rapené Yesupaae woseturaalu, “Yó matere whi̧-ó, Moses-né da̧paae etei fo yóló muló beterapó. ‘Whi̧ beta̧ naale senaale deni, ha̧le beteró sukutepa, ti so wulia nomané dokóló naalekó detepa, ti noma betale sirimó, ai naale beteró̧pólópó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Téró, wȩikeró nomarape da̧tamo betalepó. Téru, topo whi̧ a̧ beta̧ so dokaletei, naale senaale dini, ha̧le beteró kale whi̧ sinitepa, kale so wulia ama noma me whi̧némo dokalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Téyaletei, ai kale whi̧kélé naale senaale dini, noma yale kaaetóró ha̧le suka̧lepó. Atétepa, kale so wulia me whi̧némo dokalemó, ai whi̧nékélé naale senaale dini, ha̧le suka̧lepó. Mepaae dou̧ró nomarapekélé atérótóró sisiraae felepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nalo mo kemerótu, kale sokélé sinalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Téyalepa, mió kale sinale whi̧rape kepaayóló betaaire sukamó, kale wȩikeró nomarapekó mé whi̧né ai kale so dokaaloé? Ti noatepae, aita nomarape doko̧ feané dokoté wale sopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ti fo depa, Yesuné duraalu, “Diaao̧ ai mutu betere kisipata, kale asȩmó yóló muló betere foró Kótóné doasi bole fotoko̧tamo wisiyóló kisipani, ha̧sókó furaalu du beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kale sinale whi̧rape momó kepaayóló betaaire sukamó whi̧kélé so dokóo, sokélé whi̧tamo fóo ini, ó hepen bemó betere ensel-rape kaae betaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Kale sinale whi̧rape atéró kepaayóló betaalopóló, Kótóné dia̧paae asȩmó ere fo dosa̧ayóló kisipanié? Téró ama duraalu, ‘Ȩta, Abraham, Aisak, Jekop-sépi atimané Kótópó,’ yalepó. Ti ai suka̧le so whi̧ mo ti alu wua̧sóró ti i dosa̧ayale so whi̧rape tȩteróló kaae tare Kótópó fo wua̧meipó. Ti a̧ta, mió i betó mole so whi̧ró take sukó̧ló kepaayóló betó mole so whi̧tamo tȩteróló kaae tare Kótópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tétepa, so whi̧ feané ai dere fo woseturaalu, haió! yóló sirayalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Téró etéyalepó. Yesuné kale Sadyusi whi̧rapené wosetere fo mo donotóró tokó̧ matepa, kale Farisi whi̧rape, atima beta̧paae touróló atimasisi fo kȩlaaralepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Atéró, Moses-né asȩre fo yó matere kisipa tiki fosó fosóre whi̧ beta̧né a̧ ka̧ae kelaai su̧ sóró woseturaalu, “Yó matere whi̧-ó, kale yóló muló betere foné i ala yae ere doasi topo fo-a, mé foé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ai fo depa, Yesuné tokó̧ mótu duraalu, “Naao Talepaae yaala sókó fóló, hȩkesené sinitere alata, naao hosaa bete turónékélé, naao kepe bete turónékélé, naao kisipa tiki bete turónékélé, yaala sókó fu betae. ");
INSERT INTO ppo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ti ai alata, ama folosóró yae yóló muló betere mo doa topo ala ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ai ki̧lipaae me tamo dakoróló yae yóló muló betere mo doasi topo fo i ape. Naaotei ya̧ yaala sókó fóló hȩkesené sukutu dere kaae, naao be whi̧ so whi̧paaekélé atéró yaala sókó fu betae. ");
INSERT INTO ppo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kale yae yóló muló betere forape fearó Kótóné ama fo eratere ko̧ló whi̧rapetamoné ere fota, ti i doasi topo fo tamo tómó beleró beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Atéró, kale Farisi whi̧rape beta̧paae toura̧le wóló betó mupa, Yesuné atimapaae woseturaalu, “Kótóné so whi̧ tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Keriso-a, né naalemaé?” yóló wosetepa, atimané tokó̧ mótu duraalu, “Depit-né deté wale whi̧né deale naalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Ai fo depa, ama atimapaae duraalu, “Kale Dȩi Kepe Wisiné Depit fotoko̧ratepa, Depit-né a̧paae Tale-ó ere fo-a, me whi̧né ama deale naalené deté fele naalepaaetei Tale-ó fo dua de? Té dumitei, Dȩi Kepe Wisiné fotoko̧ratepa Depit-né a̧paae Tale-ó fo asȩyóló i muló betere ape. Ai fota i ape. ‘Talené ȩ tȩteróló kaae tare Talepaae duraalu, “Naao bóe whi̧rape atima ya̧lo teteirape aleróló, naao hó ao̧mó beteraalopa, ya̧ ya̧lo turu naase dȩmó bitu kaae tawae,” ’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ti Depit-né a̧paae Tale-ó fo du bitipa, momómo ama naale-ó, dere fomo neyóló yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ti fo depa, whi̧ beta̧nékélé Yesuné ai yale fo mené tokó̧kélé menénipó. Ai be dȩmó kaae sóró fóló, mepaae whi̧rapené wosetere fo me kae ini, taaróló felepó. ");
INSERT INTO ppo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","2","Téró, Yesuné aimó touróló betó mole so whi̧ró ama yó matere whi̧rapetamopaae duraalu, “Moses-né asȩre fo yó mótu betere whi̧raperó Farisi whi̧rapetamota, kale doasi whi̧ Moses betale sirimó bituraalu, ama yó matere ala yó tarapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Atimané yó matere fo diaao̧ wosóló, sya fóló erótua yae. Tépatei, atimané ai du betere ala momókó sya fóló yao̧se. Ti noatepae, atimané yó mótu betere fota wisiyóló yó mótu bitutei, sya fóló eratere alamo dumipó. ");
INSERT INTO ppo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Atimané doasi sekȩi o̧larape whi̧rapené beleyó̧póló, dokóló atimané hu̧lumó belerótua dapó. Téteretei, atimanémo ai kale sekȩi o̧la belere whi̧rape fasóló mo sawa tao sere alakélé dumipó. ");
INSERT INTO ppo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Atimané du betere ala feata, ti so whi̧né kolóló dukiró̧póló, dua dapó. Téturaalu, Kótóné fo atimané kutiri tua̧mó bulapóló, so whi̧né kolóló aunó̧póló, asȩyóló atimané kutirimó meleke kaae beleyóo, naasemó hó̧ kaae sóo, Kótópaae moma yaaikélé, atima mo ekȩlerapó yó̧póló, deratere fo̧loi kuti mo ti fo̧loróló kwiamó, mepaae auratere o̧la olerótua yóo dapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Téturaalu, o̧la detere be dȩmó mo doasi doi mole whi̧rape bitua dere tikimótóró betaai ekȩle yóo, moma dere bemó doasi topo whi̧rape bitua detere tikimó maaté betaai ekȩle yóo dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","So whi̧ fea touratere tikimó betó mole so whi̧né atimapaae doasi doi mole yó matere whi̧ wisi ko̧leó yóló, dukiratere koko̧mó dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Atétu dere kaae, mepaae whi̧rapené dia̧paae Rabai, yó matere whi̧-ó, yao̧sóró yae. Ti noatepae, dia̧ tua̧mó doasi topo whi̧ beta̧tóró betepa, dia̧ fea ti mo norapetóró ai betere ape. ");
INSERT INTO ppo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mepaae i haemó betó mole mo whi̧paaetei dia̧né aya-ó, du betao̧se. Ti noatepae, dia̧né Aya mo beta̧ ó hepen bemó beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mepaae whi̧né dia̧ kilituraalu, dia̧paae yó matere whi̧-ó, yao̧sóró yae. Ti noatepae, dia̧ yó matere whi̧ta, so whi̧ fea tȩteróló kaae tanó̧póló, Kótóné sóró beteró betere doasi whi̧ Keriso a̧ beta̧ beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","I haemó dia̧ tua̧mó doasi doi mole topo whi̧ betepa, ti ai whi̧ a̧ dia̧né kutó diratere whi̧ betaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ti noatepae, mepaae whi̧ dené ama doitei hale sóró horótu betepa, ti atétere whi̧né doi haepaae só deraalopó. Téretei, mepaae whi̧ dené amatei a̧ deróló dua betepa, ti atétere whi̧né ama doi doasi muaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Dia̧ Moses-né asȩre fo yó mótu betere whi̧raperó Farisi whi̧rapetamo-ó, tiki tua̧paae dorutei ha̧le siki̧li du betepa, Kótóné dia̧ dowi kwia melaalopa, mo doasi witu betae. So whi̧ fea Kótóné tȩteróló kaae tare bepaae sókó faai fu betepatei, fao̧sóró ai tu̧ diaao̧ dere alanétei seséyóló kinótu beterapó. Ti dia̧ta, ai tu̧mó sókó fumitei, aipaae sókó faai fole so whi̧ ai sesétu betere ape. ");
INSERT INTO ppo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Dia̧ Moses-né asȩre fo yó mótu betere whi̧raperó Farisi whi̧rapetamo-ó, tiki tua̧paae dorutei, tóné ha̧le siki̧li du betepa, Kótóné doasi dowi kwia melaairetei wió yae. Mepaae whi̧rape dia̧tamo touróló doasi fake firaai dapóló, wȩi tómókélé, hae tómókélé, kutu beterapó. Atéró, me whi̧kó diaao̧ dere fo wosóló dia̧ fake alene wapa, diaao̧ dere ala yó melóló, ai yó matere alanétei diaao̧ du betere dowi ala bosenóló, mo dowi si duku beterepaae faai betere whi̧rape kaae beterótua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Dia̧kélé kele dilikire whi̧rape bitutei, me whi̧paae tu̧ i mole ape yóló yó matere whi̧ kaae betepa, mo doa dowi kwia saalopa, wió yae. Ti noatepae, dia̧né etei fo dua dapó. Whi̧ me dené Tale Kótóné momatere be doi yóló mo dirii malo depa, ti me bete muni, Tale Kótóné momatere be tua̧mó mole kold kapa doi yóló, Kótópaae mo dirii malo yóló mulatere fo tikitepa, ti mo doasi kwia saalopó dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Dia̧ kele dilikiyóló tuȩ́kélé okokore whi̧rape-ó, doasi topo o̧la-a, noaé? Momatere beta, doasi topo o̧la ai ape. Ai kold kapanéta, ti momatere be wisiróló kae mulótumipó. Tétumitei, Momatere be tua̧mó Kótóné ala eratereteiné, ai be tua̧mó mole kold kapatei wisiróló, kae mulótua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Meta, diaao̧ i fokélé dua dapó. Me whi̧né ama dere fo diriróturaalu, Talepaae ha̧le matere o̧la belerótua dere kapo doi yóló, malo depa, ti ai bete munipó. Kale ai kapo tómó suku̧laa dalaai beleratere o̧la doi yóló, dirii malo depa, ti mo dirirapó dua dapó. Ai fotamo tikitepa, mo doasi dowi kwia saalopó du beterapó. Dia̧ kele dilikire whi̧rape-ó, mé o̧la doasi bete mule? Talepaae ha̧le matere o̧lapé ai o̧la beleratere tiki doasi bete mule? Ti ai ha̧le matere o̧la beleratere tikiné Talepaae ha̧le matere o̧la wisiróló, kae mulótua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Dia̧ kisipa tiki okoko yóló, kelekélé dilikire whi̧rape-ó, mé o̧la-a, doasi topo o̧laé? Kótópaae ha̧le matere o̧lapé, ai o̧la mulatere tikié? ");
INSERT INTO ppo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Térapa, whi̧ me dené ama fo diriróturaalu, hupu ó mepaae o̧la beleratere tiki doi yóló malo depata, ti kale suku̧laa dalaai beleratere o̧lakélé wusuró doi yóló malo ai dere ape. ");
INSERT INTO ppo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Whi̧ me dené Kótóné momatere be doi yóló dirii malo depa, ti ai momatere beró ai bemó betere sekȩ́tamo wusuróné doi yóló malo ai dere ape. ");
INSERT INTO ppo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Whi̧ me dené dirii malo duraalu, hepen be doi depa, ti kale doasiné tȩteróló kaae tare tikiró aimó betere sekȩ́tamoné doi yólókélé, du beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Moses-né asȩre fo yó mótu betere whi̧raperó Farisi whi̧rapetamo-ó, dia̧ tiki tua̧paae dorutei, ha̧le siki̧li du betereteiné, doasi dowi kwia saalopa, mo wió yae. Ti noatepae, diaao̧ kutómó ere o̧la naase tamo epa, beta̧ ti naao Kótópaae ha̧le matapó. Téretei, mo doasi bete mole ala diaao̧ kisipa muni, sisópaae eróló, mo keteró beterapó. Ai doasi bete mole ala i ape. Fo tokó̧tamo yóló mo donoyóló taletere alakélé, ko̧lené sinóló tao sere alakélé, Kótópaae kisipa tiki tiróló, ama ala ha̧le eró tareteikélé, fea diaao̧ kisipa keteró beterapó. Ti mepaae yóló muló betere doasi bete alarape fea wisiyóló eróturaalu, mepaae sawa alarapekélé kisipa keteréni, fea touróló erólua̧sóró mo wisi ua̧pó. ");
INSERT INTO ppo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Dia̧ kele dilikirutei, mepaae whi̧paae tu̧ i mole ape yóló yó mótu beterapó. Dia̧né o̧la nukuraalu, mo sawa doko̧letamo ho̧ko nao̧sóró, mepaae o̧la o̧la sorokóló nuku beterapó. Tétu bitutei, doasi kamel hupumo, ti dia̧né kiliniyóló o̧latamo touróló ho̧ko ai nuku betere ape. ");
INSERT INTO ppo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Moses-né yóló muló betere fo yó mótu betere whi̧raperó Farisi whi̧rapetamo-ó, dia̧ tiki tua̧paae doruraalutei, ha̧le siki̧li du betereteiné mo dowi kwia saalo ai ape. Dia̧né wȩi nokole wutiró nukutamo tómaaté fukuturaalu, tua̧paae fukutumipó. Ti ai tómó maaté fukutu betere so whi̧ta, o̧lémi nokole alakélé, ukusi yóló ekȩle dere alakélé mo fa̧anapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kele dilikire Farisi whi̧-ó, folosóró ti kale wȩi nokole wutiró o̧la nokole nukutamo tua̧paae hotowayóló fokae. Atétepa, ti tóta ama ha̧letei fokó faalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Moses-né asȩre fo yó mótu betere whi̧raperó Farisi whi̧rapetamo-ó, tiki tua̧paae doruraalutei tóné ha̧le siki̧li du betereteiné mo doasi dowi kwia saalo ai ape. Dia̧ta, kale whi̧ dou tómó kale dȩi ni fȩné aurale tikimó kelaalo mo koko̧re kaae erapó. Ti whi̧ dou tóta kelaalo koko̧retei, whi̧ mole dou tua̧ dolopaaeta, suka̧le whi̧né diriró kae kae kȩlaamilitamo fa̧anapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Dia̧kélé u tua̧paae atei kaae ala epatei, so whi̧ feané diaao̧ tó tiki maaté kilituraalu, mo donoi ala du betere whi̧rape nisi du beterapó. Diaao̧ tiki tua̧paaeta, whi̧ dilikitere alaró kae kae mo sonaalei dowi alatamoné ai fa̧ane ape. ");
INSERT INTO ppo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Moses-né asȩre fo yó matere whi̧raperó Farisi whi̧rapetamo-ó, dia̧ u tua̧paae dorutei, tómó ha̧le siki̧li du betepa, mo dowi kwia saaireteimó wió yae. Dia̧ta, Kótóné ama fo erale ko̧ló whi̧rape dourale tikiró, mo take donoi ala yóló sinale whi̧rape dourale tikitamo hotowa yóló be tȩnóló aurótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Atéturaalu, diaao̧ etei kaae fokélé du beterapó. Da̧tamo, noutererape betale alimó bitua̧sóró, ti Kótóné ama ko̧ló whi̧rape dóló samea sókó fatua wua̧ meipó dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","32","Dia̧ta kae whi̧rape meipó. Diaao̧ ai du betere fonétei dia̧ só deróturaalu, Tale Kótóné ama ko̧ló whi̧rape dilé wale whi̧rapené deté wale naalerapeta, dia̧tóró ai ape. Térapa, atimané deté wale dowi ala diaao̧kélé mo ti fakeróló du betae. ");
INSERT INTO ppo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Dia̧ whi̧ sinó̧póló tukó nokole mo dowi wulirape-ó, dia̧tamo fo tokó̧tamo yóló dowi si duku beterepaae só deraairetei noa yóló ha̧sókó faaloé? ");
INSERT INTO ppo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Térapa, ya̧lo dia̧ beterepaae Kótóné ama ko̧ló whi̧rapekélé, kisipa tiki fosó fosóre whi̧rapekélé, Kótóné yóló muló betere fo yó matere whi̧rapekélé, dotonótu beterapó. Tétu betepatei, mepaae whi̧rape ti diaao̧ dóo, mepaae whi̧rape filipaare ni tómó oleróló dóo, mepaae whi̧rape diaao̧ fo wosetere be tua̧mó fokosói ala yóo, mepaae whi̧rape atima me be huluapaae botokó fupa, diaao̧ daai sya kwȩyóo yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Atéyaleteiné, donoi ala du betale whi̧ Abel-né samea sókó feleteimó, kaae sóró dilé wóló, kale Barakayané naalema Sekaraiakélé momatere beró Talepaae ha̧le matere o̧la suku̧laa dalatere tikitamo tua̧mó dia̧né dalepó. Ai dilé wale whi̧rapené samea sókó feletei fea touróturaalu, dia̧ mió i alimó betó mole whi̧rapepaae doa kwia melaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ya̧lo mo i dere ape. Take atéró whi̧ dilé walemó dowi ala kwia fea touróturaalu, mió i betó mole so whi̧né saalopó. ");
INSERT INTO ppo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","38","Jerusalem be huluamó, betó mole so whi̧ naao teyae! Kótóné ama ko̧ló whi̧rape dia̧ beterepaae dotonótua depatei, kapo duné siróló dua yale so whi̧-ó, kale bané ama malerape baase ao̧paae buó su dere kaae, ya̧lo dia̧kélé atéró dape saalopóló dua yaletei, diaao̧tei hó̧yóló dowa̧ae fua yalepó. Téyaleteiné mo doasi ko̧leó, Talené dia̧ taalatepa, mió diaao̧ be hulua ai wópu mutapa, kelere? ");
INSERT INTO ppo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Térapa, ya̧lo dia̧paae mo i dere ape. Diaao̧ ȩ kilini bitiré fóló, ‘Talené doimó wale whi̧ Kótóné wisiratepa a̧ hai̧né sinóló beteró̧póló yae’ dere sukamó, ti diaao̧ ȩ momó kelaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Téró, Yesu momatere be taaróló fu betepa, ama yó matere whi̧rape a̧tamo hokolaane fóló duraalu, “Momatere be wisinaale ai tȩyóló muló beterapa, kelere?” deté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tétepa, Yesuné atimapaae duraalu, “Ai tȩ mole berape diaao̧ kelere? Ya̧lo dia̧paae mo i dere ape. Ai berape fea fisikó furaalu, kapo fake beta̧kókélé me kapotamo olokopa kelaalomeitei, mo fea kolokó fóló mupa kelaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Atéró, Yesu a̧ Olip du sorokó molepaae fóló betepa, ama yó matere whi̧rape a̧ beterepaae wóló atimasisi bitu a̧paae woseturaalu, “Da̧ moko̧leyaa yóló betepa, ya̧ walemó kilita sókó fao̧sórópa, folosóró noa alapi eratepa kolóló, da̧né tuȩ́ yaaloé? Keme yaaire be dȩró ya̧ waaire be dȩtamo, da̧né kisipa yó̧póló noa alapi eraaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ai fo depa, Yesuné atimapaae duraalu, “Me whi̧né dia̧ dilikó̧ló kó̧paae a̧lisóró falao̧sóró, mo hotowayóló kaae tawae. ");
INSERT INTO ppo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ti noatepae, whi̧rape mo feané dia̧ dilikituraalu ya̧lo doi yóló, ‘Ȩta, so whi̧ fea tȩteróló kaae tanó̧póló, Kótóné sóró beteró betere whi̧ Kerisopó,’ depa, so whi̧ feané mo nisi yóló sya faalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Me tikipaae bóe du beterapó dere fokélé wosóo, mo felekemó bóe du betere alakélé kolóo duraalu, dia̧ tuȩ́ sekȩyóló wiyao̧se. Ti noatepae, ai alarapeta mo yaalopóló tukóló muló betereteiné ha̧sókó feni, mo yaalotei, kemeyaaire be dȩ ti teórapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","“Me hae kwiamó betere be hulua whi̧ró me hae kwiamó betere be hulua whi̧tamo bóe doasi daalo ai ape. Me hae kwia tȩteróló kaae tare topo whi̧ró me hae kwia tȩteróló kaae tare topo whi̧tamokélé bóe daalo ai ape. Atéturaalu, doasi wote aliró doasi bao dere alatamo hae kwia feapaae wou betaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ai alarape feata, ti kale sorape naale saai sisó kaae sóró nuku dere kaae dapó. ");
INSERT INTO ppo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Téturaalu, dia̧ ȩ sya wóló, ya̧lo ala erótu beteremó, i hae kwia feamó betó mole so whi̧né dia̧ hó̧róló fokosoi ala yóló, mo ti sinó̧póló daalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Atétere sukamó, so whi̧ mo fea kisipa tiki tiró betere ala taaróló, me whi̧ hó̧róló atimasisitei bóe daairaalu, eleké deyóló u só dera̧ne, i só dera̧le, du betaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Atétu betepa, mepaae whi̧rape mo fea Kótóné ama mo ko̧ló whi̧ ao̧yóló wóló, so whi̧ dilikó̧ló kó̧paae faraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ti noatepa meipó. I hae kwia feamó betó mole so whi̧né dowi ala mo ti faketé furaalu, so whi̧ feané yaala sókó fóló hȩkesené sukutu betere ala siri buóló, mo ti haepaae derepaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tépatei, mepaae whi̧ de kisipa tiki tiró betere ala mo ti yó taté fóló, kemene fole sukamó sókó fupa, ti ai whi̧ aluni, Tale Kótóné ama mo tao saalopó. ");
INSERT INTO ppo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Atéturaalu, Kótóné tȩteróló kaae tare ao̧mó, mió wosetere kisi fo wisi i hae kwia feamó betó mole so whi̧paae yó maté koteremó, ita Talenétei eratapóló kisipa yaalopó. Ai ala yale ki̧lipaae, ti mo kemetere be dȩ sókó waalo ia ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Atétepa, Kótóné ama ko̧ló whi̧ Daniel-né mo taketi asȩmó yóló muló betere foné duraalu, be wópu mulaai, kelaalo mo sonaalei o̧la Talené ama kae tukóló muló betere tikimó daapa kilitu, ai asȩre fo dosa̧atere whi̧ dia̧né wisiyóló kisipa muae. Ai ala kilituraalu, Judia hae kwiamó betó mole so whi̧ du sorokó mole tikipaae botokó fó̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mo beta̧ whi̧kókélé siki be kemó biti até ao̧ró bemó mole o̧lakélé sene derepéni, muló̧póló taaróló, botokó fae. ");
INSERT INTO ppo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Whi̧ me kutómó daapatamo ai ala depa, ti momó fesaayóló ama bukaaire kuti sene feni, muló̧póló taaróló botokó fae. ");
INSERT INTO ppo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Atétere sukamó kale naale ere soraperó teó naale tare sorapetamo mo doa ko̧lerapó. ");
INSERT INTO ppo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dia̧ botokó faairetei doasi sosóli aliró sa̧a nóló beteró̧póló, tukóló muló betere be dȩtamo tua̧mó erao̧sóró, Talepaae momatu betae. ");
INSERT INTO ppo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ti noatepa meipó. Ai waaire doasi sekȩi alata, i hae keké nale alimó kaae sóró wóló, mió i betere alimókélé, take nalo betaaire alimókélé ai kaae sekȩi ala mo kelaalomeipó. ");
INSERT INTO ppo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Atétere be dȩmó, waaire sekȩi alarapetamo Kótóné ha̧lekeróló tukóló mulólua̧meisóró, ti mo beta̧ whi̧kókélé ha̧sókó fóló bitua̧meipó. Até yao̧sóró, Kótóné sorokó suyóló sóró beteró betere so whi̧mó kisipa mutu, ai be dȩrape ha̧lekeróló tukóló mulaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Atétere sukamó, mepaae whi̧né duraalu, Kótóné so whi̧ fea tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Keriso i wóló beterapa kelae depa, ó u wóló betere ape depa, mo dere nisiyóló wosóló kisipa tirao̧se. ");
INSERT INTO ppo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ti noatepae meipó. Mepaae dilikitere Kerisoró Kótóné ama ko̧ló whi̧póló, kapala fo yó matere whi̧rapetamo waalo ai ape. Atétu, kae kae ala yaairemó eratere doasi alaró kae kae kelemei alarapetamo eróturaalu, Kótóné sorokó suyóló beteró betere so whi̧kélé kó̧paae falaai, ka̧ae kolóló su̧ saalopó. ");
INSERT INTO ppo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ai alarape yaai teópatei ya̧lo dia̧paae ai yale ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Téyaalopa, mepaae whi̧né dia̧paae duraalu, ‘Kale sekȩ́ a̧ whi̧kélé bitinire tikimó wóló i betere ape,’ depa, wosóló mo dapóló kelaai fao̧se. Ó, ‘Be dolomó i betere ape,’ depa, mo dere nisiyóló kisipa tirao̧se. ");
INSERT INTO ppo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ti noatepa meipó. Suka hotereró dere epéenétei suka doropolepaaekélé dȩyó fu dere kaae, kale Whi̧né Naalema atéró mo ha̧keamó wapa so whi̧ feané kelaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Dia̧né ó sa̧paae kese honalemótamo, kale ba dukaarape sȩ́ kwȩyóló bopétu betepa kilitu, sinale na ó hupu mupa dapó kisipa muae. ");
INSERT INTO ppo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ai sekȩi alarape yale ki̧lipaaetóró ‘Suka kekélé dilikiróló, wéliékélé mo dȩ yaalomeipó. Ho̧rerapekélé torokó dorowóló, ó sa̧mó ere o̧la o̧lakélé fea wore yaalo ai ape,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Atétere sukamó, kale Whi̧né Naalema mo felekemó waai dapóló kisipa yó̧póló, ó sa̧mó doasi ala eratepa kelaalopó. Atéró ama doasi ere au wisinaaletamo ó sa̧komó ha̧keamó sókó wapa i hae kwiamó betóló fale so whi̧ feané kilitu, doasi moló-u yaalopó. Kale Whi̧né Naalema ó sa̧mó atéró wouraalu, ama bole doasi fotoko̧ró Kótóné ama kae ere ala wisinaaletamo ó sa̧ko dolomó sókó wapa, kelaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Atéturaalu, ama ensel-rapené ukulumó wuti mo doasi fakeyóló hale deté kuturaalu, hae kwia dȩ doko̧ feamó ama sorokó suyóló kae beteró betere so whi̧ dape siré kwȩyó̧póló dotonaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Térapa, mió kale ni nosené dere ala kolóló, wisiyóló kisipa muae. Sóku fóló momó hu̧lu depa kilituraalu, kale ba fo mo felekemó ai sókó wale ape fo dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Até dere kaae, ai bopeyale alarape dia̧ betere tua̧paae wapa kilituraalu, mióta a̧ mo felekemó waairaalu tu̧ sókó walemó daapa, ai dere ape kisipa muae. ");
INSERT INTO ppo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ya̧lo dia̧paae mo i dere ape. Mió i alimó betó mole so whi̧ fea sukuni ha̧le betó mupatei, ai alarape mo fea yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ó sa̧ró i haetamota, mo kemeyaalotei, ya̧lo fo beta̧ kemekélé ini, ha̧le muó tawaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Até yaaire be dȩró sukakeletamota, mo whi̧ beta̧nékélé, hepen bemó betó mole ensel-rapekélé, ama Naalemanékélé mo tuȩ́nitei, Alimané ama beta̧ tuȩ́rapó. ");
INSERT INTO ppo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kale whi̧ Noa betale alimó yale ala kisipa muae. Kale Whi̧né Naalema woukélé, mo ai ala kaaetóró yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ti noatepae, atéyale sukamó kale wȩi doasi a̧laai teópa, atima mo wisiyóló bitu, o̧laró wȩitamo nóló, whi̧ so dokotere alakélé, so whi̧tamo dokotere alakélé deté fu beteró, Noasépi nuku tua̧paae biti̧ holale sukamó sókó walepó. ");
INSERT INTO ppo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Atima betere tua̧paae ai ala sókó waairetei kisipani, ha̧le mo ko̧leaa yóló bitiré wóló, wȩi doasi anóló, so whi̧ fea aluralepó. Kale Whi̧né Naalema wale sukamókélé, atétu yale kaaetóró yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Whi̧ tamo kutómó daayaalotei, me whi̧ dapesó furaalu, me whi̧ daaló̧póló taaróló faalopó. ");
INSERT INTO ppo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","So tamo whit o derakó̧ló detu betaalotei, me so dapesó furaalu, me so betepa taaróló faalopó. ");
INSERT INTO ppo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ti noatepa meipó. Dia̧ tȩteróló kaae tare Tale waaire suka, dia̧ kisipanipa, mo hotowayóló kaae tawae. ");
INSERT INTO ppo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","I alarapeta mo yaalopa, i dere fo bete wisiyóló wosóló kisipa muae. Beta̧ be talené dilikitamo etei kaae sukakelemó o̧lémi nokole whi̧né ama be fulukene waalopóló, kisipa muóló bitua̧sóró, ti ama be fulukóló o̧la o̧la sóró fó̧póló, a̧ noke fió muni, siki siki yóló bitua̧pó. ");
INSERT INTO ppo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Térapa, dia̧kélé donoróló mo siki siki yóló betae. Ti noatepa meipó. Kale Whi̧né Naalema waalomei nisiyóló, kisipa keteróló betere sukamó, a̧ sókó waalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ti i dere fo wosóló, dia̧kó me whi̧ etei kaae kekemeyóló kutó diratere whi̧ beterémóló, diaao̧tei ka̧ae kelae. Beta̧ be tale a̧ mepaae uké faairaalu, ama dere fo sya fóló, mo eró tare fosó fosó yóló kekemere whi̧paae mepaae kutó diratere so whi̧ naao tȩteróló kaae taru, o̧lakélé mo wisiyóló melae yóló a̧ fulapó. ");
INSERT INTO ppo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ai kale kutó tale doasi topo whi̧ a̧ momó fesaae wouraalu kelera̧lemó, a̧ faai bituraalu diyae yale kutórape fea ama su̧mó dipa, ti ai kutó diratere whi̧ a̧ mo hai̧né sinaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ya̧lo dia̧paae mo i dere ape. Kale be talené ama o̧la o̧la mo fea ai sekȩ́paae naao mo hotowayóló kaae tawae yóló, ama naase tua̧mó mulaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","50","Tépatei, ai kutó diratere whi̧tamo dowi tuȩ́ mole whi̧ betepa, ti i ala dere kaaepó. Kale kutó diratere whi̧né kisipané ama doasi hapale waalomei nisiyóló, a̧tamo kutó ditere whi̧rapetei fokosói ala yóo, topo dotere wȩi nokole whi̧rapetamo fulumu yóló ho̧ko bitu, o̧laró wȩitamo mo dekéró nóo du betaalopó. Téturaalu, ama doasi waalomei nisiyóló moko̧leyaaró betere tua̧mó, kale whi̧ sókó wapa kilita sókó faalopó. ");
INSERT INTO ppo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Atéró, kale whi̧ ama doasiné fokosoi ala yóló, ama tiki mo turukée fi kale tó tikiné wisire nisiyóló siki̧li du betere whi̧rapetamo beta̧mó beteraalopó. Tétepa, aimó doasi susupu sóró kaketu bitu naao téyae yóló, atima sereke fisikó̧ sóró doasi wole du betaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Téró Yesuné duraalu, “Atéyaaire sukamó, ó hepen bemó Kótóné tȩteróló kaae tare ao̧mó mole alata, i ala kaae yaalopó. Kale naasetamo so seimalerape atimané lamp sa̧ dirirape sóró so dokotere be dȩmó detere o̧la naai kale so dokaaire whi̧tamo hokolaa yaai felepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Atéró mepaae aporó fele seimale senaalerapeta, ti kisipa fosó fosó yóo, mepaae aporó so seimale ti kisipa tiki fosó fosó ini yóo erepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kale kisipa tiki fosó fosó inire seimale sorape atimané lamp sa̧ dirimó wȩi belepa sóró feletei, kemetepa saaitapóló mepaae wel wȩi wutimó tepeóló sóró fenipó. ");
INSERT INTO ppo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Téyaleteiné, kale kisipa tiki fosó fosó yóló kekemere seimale sorape atimané lamp sa̧kélé wȩi belepa sóró fóo, kemetepa saaire wel wȩikélé wutimó tepeyóló sóró fóo yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Atéró, kale so dokaaire whi̧ hapale wéni, diki deté fu betepa, atima fea noke kȩletepa noke foposaa yó molepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Atima atéró noke fopesaapa, diliki su̧ tua̧tamo whi̧ beta̧né fo fakeyóló duraalu, ‘Kale so dokaaire whi̧ i walapa, a̧tamo hokolaayaai faalopa ape,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Atétepa, kale so seimalerape turukó holóló, atimané lamp sa̧ dirirape wisiyóló dó̧póló donoralepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Atéró, kale kisipa tiki fosó fosó inire so seimalerapené kale kisipa tiki fosó fosó yóló, kekemere so seimalerapepaae duraalu, ‘Da̧né lamp sa̧ dirirape wel wȩi kemeturaalu, felekemó sukó̧ faai dapa, dia̧né tare wel wȩikó da̧maletamo a̧lae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ti fo depa, atimané duraalu, ‘Meipó. Da̧né tare wel wȩi dia̧ melatepa, ti da̧né sa̧ dirimó tepeyaaire mei yao̧sórópa, mepaae wel wȩi dotonatere whi̧rapetamo dupune fae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ai fo depa, atima wel wȩi dupune fi tikimó, kale so dokaaire whi̧ sókó walepó. Atétepa, kale donoróló betere so seimalerape kale so dokaaire whi̧tamo so dokoteremó detere o̧la naairaalu, be dolopaae horóló tu̧ kinalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","12","Atéró beteremó, nalomo mepaae kale fele so seimalerape wóló, atimané fo fotoko̧ yóló duraalu, ‘Doa whi̧-ó, doa whi̧-ó, da̧ holaaitapa tu̧ tuki̧ae,’ depa, ama atimapaae duraalu, ‘Ya̧lo dia̧paae mo i dere ape, dia̧ ȩ kisipanipa dia̧ deé?’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Atérapa, diaao̧ doasi waaire be dȩró suka keletamo dia̧ kisipanipa, mo hotowaró kaae tawae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Fo me i ape. Talené tȩteróló kaae tare alata, whi̧ beta̧ a̧ me bepaae faairaalu, ama kutó diratere whi̧rape a̧ beterepaae ape yóló, ama o̧la o̧larape kaae tawó̧póló, sóró beteratere kaaepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Téró, ama kutó diratere whi̧rapepaae moni melaairaalu, folosóró me whi̧né dere ala ka̧ae kolóló, 5000 melóo, whi̧ mené ama dere alakélé ka̧ae kolóló, 2000 melóo, me whi̧né ama dere alakélé ka̧ae kolóló 1000 melóo, yóló duraalu, ‘Ya̧lo i moniné mepaae kutó dirótu betae,’ yóló, a̧ felepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Atétepa, kale 5000 moni sale whi̧né ai moniné mepaae kutó diyóló, ama kale sale 5000 tómó 5000 me beleróló salepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Atéró, me kale 2000 moni sale whi̧nékélé mepaae kutó dité fóló, 2000 me beleróló salepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Téyaletei, kale 1000 moni sale whi̧ a̧paae melale moniné me kutó dini sóró fóló, hae duki̧yóló kikiti hyó̧ mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Atéró, kale doasi a̧ hapale wéni, bitiré fóló me sukamó momó fesaae wóló, ama kutó diratere whi̧rapepaae kale melale moni taleyaalopa, ape yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Atétepa, kale 5000 moni melale whi̧ wóló duraalu, ‘Doa whi̧-ó, naao ȩpaae 5000 melaletei, kutó dité fóló, tómó beleróló saletei me 5000 i ape,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ti fo depa, ama doasiné a̧paae duraalu, ‘Ya̧lo kutó diratere whi̧ wisinaale-ó, naao fosó fosóre alané ya̧lo ya̧paae yae yale ala naao wisiyóló ereteiné, mepaae o̧la o̧lakélé fea naaotóró tȩteróló kaae tawaasepólópa, ya̧kélé naao doasitamo hȩkese dere ala tua̧mó betaalopa ape,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Atétepa, kale 2000 moni melale whi̧ wóló duraalu, ‘Doa whi̧-ó, naao ȩpaae 2000 melaletei, kutó dité fóló, tómó beleróló 2000 me saletei i ape,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ti fo depa, ama doasiné a̧paae duraalu, ‘Ya̧lo kutó diratere whi̧ wisinaale-ó, naao fosó fosóre alané ya̧lo ya̧paae yae yale ala naao mo wisiyóló ereteiné mepaae o̧la o̧lakélé fea naaotóró tȩteróló kaae tawaasepólópa, ya̧kélé naao doasitamo hȩkese dere ala tua̧mó betaalopa ape,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Téró, kale 1000 moni melale whi̧kélé wóló duraalu, ‘Doa whi̧-ó, naao dere alata, ya̧lo tuȩ́rapó. Ya̧ta mo deteraai whi̧ bituraalu, o̧la wae bilitere alakélé, o̧la wae ke terepetere alakélé dumitei, ha̧le ho̧ko tikimókélé naao o̧la wisi sua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Atérené ȩ wituraalu, naao ȩpaae melale moni ya̧lo hae duki̧yóló hyó̧ mulaletei, i tarapa sae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ti fo depa, ama doasiné a̧paae duraalu, ‘Ya̧ta, kutókélé diyaalo mo dekané sini, kutó diratere whi̧ dowi ai ape. Ti ya̧lo naasené o̧la wae bilini yóo, o̧la kekélé terepeni yóo, dere tikimótei o̧la sua dapó fota, naaotei ai yale ape. ");
INSERT INTO ppo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Atétere ala naao tuȩ́rutei, ya̧lo ya̧paae melale moni tómó beleróló só̧póló, moni kaae tare whi̧rapetamo muléliyólópó. Até ua̧sóró ti ȩ fesaae wouraalu, ya̧lo melale moni tómó mepaae beleróló sua̧pó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Térapa, ama ai tare 1000 moni tokó̧ sóró kale 10,000 moni tare whi̧paae melae. ");
INSERT INTO ppo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ti noatepae, mepaae whi̧ dené me o̧la tapa, ti Talené tómó beleróló móturaalu, ai whi̧né mo dekéró tawaalopó. Mepaae whi̧né mo sawa tapa, ti ai sawa tareteikélé ama fasó saalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Téró, ai kale deka kutó diratere whi̧ mo dilikire tikipaae taae deratepa aimó kaketu bituraalu, amatei yale alamópóló doasi wole du betaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Kale Whi̧né Naalema a̧ waaire sukamó, ama mo kae ere dȩ wisinaaletamo wouraalu, ama ensel-rapekélé, mo fea beta̧mó waalopó. Atéró wóló, ama tȩteróló kaae tare doasi topo whi̧ betere tikimó bituraalu, ó hepen bemó mo ama kae ere au wisitamo bitu, taleyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Atéró bituraalu, i hae kwiamó betó mole so whi̧ mo fea a̧ betere tikipaae toura̧le wóló betepa, kale sipsip hupuró meme huputamo kaae tare whi̧né taleyóló, sipsip hupurape kaepaae daalóo, meme hupu kaepaae daalóo, du dere kaae, so whi̧kélé atéró taleyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Atéró taleyóló, kale sipsip hupu ti ama turu naaseró beteróo, meme hupurape ti ama fȩ́ naaseró beteróo, yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Téró, kale doasi topo whi̧né kale turu naaseró betere so whi̧paae etei fo yaalopó. ‘Ya̧lo Ayané wisiró betepa hai̧né sukutu betere so whi̧-ó, Kótóné tȩteróló kaae tare ao̧mó mole ala take sa̧ró haetamo aleyaaipatei, dia̧mó melaai dapóló, taleróló muló betere o̧la saai ape. ");
INSERT INTO ppo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","36","Ti noatepae, ȩ wotené sinóló mupa, o̧la melóo, ȩ wȩi nokoletepa, wȩi nó̧póló melóo, ȩ uké whi̧ kaae betepa, diaao̧ bepaae wisiyóló dapesóo yalepó. Ȩ bukaaire kutikélé meipa, diaao̧ melóo, ȩ kisiné sukó̧ló mupa, diaao̧ mo hotowayóló kaae tawóo, ȩ dipula betepa, wisi kisipa muó̧póló dia̧né ȩ kȩle wua yóo yalepó.’ ");
INSERT INTO ppo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tétepa, kale mo donoi ala du betere so whi̧né a̧paae i fo yaalopó. ‘Tale-ó, ya̧ wotené sinóló mupa, ó wȩi nokole du betepa, da̧né ya̧mó metéli melaleé? ");
INSERT INTO ppo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tale-ó, ya̧ uké whi̧ kaae betepa, da̧né dape sóo, ya̧ bukaaire kuti meipa kuti melóo, yalepó dere-a, da̧né ya̧mó metéli melaleé? ");
INSERT INTO ppo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","40","Ya̧ kisiné sinóló mupa, ó dipula betepa kisipa tiki feléyó̧póló, da̧né ya̧ metéli kȩle waleé?’ depa, kale topo whi̧né i fo tokó̧ melaalopó. ‘Ya̧lo dia̧paae mo i dere ape. Diaao̧ mepaae wisi ala i doasi doi mole ya̧lo norapepaae eróturaalu, mo belei sokótei betere so whi̧paaekélé erélipa, ti ȩpaaetóró eró beterapó,’ yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Téró kale fȩ́ naaseró betere so whi̧paae i fo yaalopó. ‘Talené só deró betere so whi̧rape-ó, dia̧ ȩ betere tiki taaróló mo sukó̧kélé feni, ha̧le dó tare sipaae biti̧ fae. Ai sita, mo dowi Satan-ró ama kutó diró̧póló dotȩyale keperapetamo dó̧póló, tukóló muló betere sipó. ");
INSERT INTO ppo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","43","Ti noa betené meipó. Ȩ wote betepa, me o̧lakókélé meni yóo, wȩi nokole depa wȩikélé meni yóo, uké whi̧ kaae betepa, diaao̧ dape sini yóo, bukaaire kuti meitepa kutikó meni yóo, ȩ hepo daróló betepa, ó dipula betepa wisiyóló tao sini yóo yalepó,’ yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ti fo depa, atimané a̧paae etei fo yaalopó. ‘Ya̧ wotené sinóló betepa, ó ya̧ wȩi nokole depa, ó uké whi̧ kaae betepa, ó bukaaire kuti meitepa, ó ya̧ kisiné sukó̧ló mupa, ó ya̧ dipula betepa, da̧né ya̧ wisiyóló tao sinipó dere-a, metéli tao sinipóló de?’ yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ti fo depa, ama atimapaae i fo yaalopó. ‘Ya̧lo dia̧paae mo i dere ape. Diaao̧ mepaae wisi alakó i doi mole whi̧rapepaae erénituraalu, i betó mole belei sókóteipaaekélé erénipa, ti ȩpaaetei erénipó,’ yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ai ala du betale so whi̧ta kemekélé ini, mo ti sótóró tawaaire dupu saalopó. Téyaalotei, mo donoi ala du betale so whi̧ta, ti mo titóró betó tawaaire bete saalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Atéró, Yesuné ai forape yóló kemetepa, ama yó matere whi̧rapepaae duraalu, “Kale boseneyóló fele be dȩmó o̧la deyóló naaire be dȩ sókó waai be dȩ tamo beta̧ ha̧le moletei diaao̧ ai kisipare ape. Ai be dȩmó kale Whi̧né Naalema mepaae whi̧rapené filipaa ni tómó oleróló dó̧póló, atimané naase tua̧mó mulaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","4","Téró, kale so whi̧mó Talepaae momaratere topo whi̧raperó mepaae whi̧ disirapetamo, momaratere doasi topo whi̧ Kaiapas-né be wisinaalepaae toura̧le walepó. Atima atéró wóló touró bitu, Yesu a̧ tawóló daai kikiti fo dokalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Atima atéró fo dokóló mulótu duraalu, “I alata, kale o̧la detere sukamó yaalomeipó. Ti noatepae, so whi̧ feané keletómó ai ala depa doasi foya yao̧sóró, me be dȩmó yaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Téró etéyalepó. Yesu a̧ Betani be huluapaae fóló, kale dowi humu fuluné tiki dopa ama wisirale whi̧ Saimon-né bemó o̧la nuku betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Atéró beteremó, so beta̧né doasi moniné duputere felé kȩlaa wale wel wȩi alabasta kane fakené aleale wutimó belepa tawóló walepó. Téró, kale soné ai wel wȩi wisinaale wuti faayóló Yesu a̧ tiróló firu o̧la nuku betepa, ama topomó suniyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Atétere ala, ama yó matere whi̧rapené kolóló, dei kisipa muóló duraalu, “Ai wel wȩi wisinaale-a, ho̧ko noatepa besekéróló suniyaleé? ");
INSERT INTO ppo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","I felé kȩlaa wale wel wȩi wisinaale, mepaae whi̧tamo dotonóló doasi moni sóró, ha̧le yoleale yóló betó mole so whi̧mó mólua̧sóró mo wisiua̧pó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Atimasisi atéró du betere fo Yesuné tuȩ́yóló, atimapaae duraalu, “Ai soné ama ȩpaae mo koko̧i ala wisinaale eralepa, diaao̧ ama kisipa tiki dorakesé. ");
INSERT INTO ppo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kale ha̧le yoleale yóló betó mole so whi̧ta, ti betere doko̧ dia̧tamo betó tawaalotei, ȩta dia̧tamo betó tawaalomei ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ai soné kale felé kȩlaa wale wel wȩi ya̧lo tikimó suniyaleteita ha̧le meipó. Ȩ sukutepa douratere sukamó felé kȩlaa wó̧póló ai dilale ape. ");
INSERT INTO ppo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ya̧lo dia̧paae mo i dere ape. I hae kwiamó betó mole so whi̧paae kale mió i wosetere kisi fo wisi yó maté kuturaalu, i soné ama i yale alakélé yó melaalo ai ape. Téturaalu, i kale soné i ala yalepóló kisipatóró ha̧le yó tawaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Téró, kale yó matepa wosetere 12 whi̧rapekó beta̧ Iskariot be whi̧kó Judas so whi̧mó Talepaae momaratere topo whi̧rape beterepaae fóló woseturaalu, “Ya̧lo i sekȩ́ diaao̧ naase tua̧paae mulatepa, diaao̧ ȩmó noa o̧lakó melaaloé?” yalepó. Ai fo depa, atimané 30 silpa moni dosa̧ayóló a̧mó melalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ai sukamó kaae sóró, Judas-né Yesu a̧ mepaae whi̧né naase tua̧mó mulaaire tu̧ kikitu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Téró, yist buni fopei bred o deóló nukuatere be dȩ kaae suraalu i ala yalepó. Yesuné ama yó matere whi̧rape a̧ beterepaae wóló woseturaalu, “Kale boseneyóló fele be dȩmó deyóló naaire o̧la-a, mé bemó da̧né taleróló mularóé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ti fo depa, ama atimapaae duraalu, “Dia̧ u doasi be huluapaae fóló, ai bemó me whi̧kótamo betepa, a̧paae i fo yae. ‘Kale yó matere whi̧né duraalu, “A̧paae me ala eraai tukóló mulale be dȩ felekemó sókó waai depa, kale bosenóló fele be dȩmó, ya̧lo yó matere whi̧rapetamo naao bemó o̧la deyóló naai dapó,” ’ ene fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Atétepa, ama yó matere whi̧rape fóló, Yesuné atimapaae yae yale alatóróti yóló, kale boseneyóló fele be dȩmó deyóló naaire o̧larape taleróló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Atéróló, be dikiteretamo Yesu a̧ ama yó matepa wosetere 12 whi̧rapetamo o̧la nukuatere ni fake tómó tiróló firu o̧la nuku beterepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Atéró o̧la nuku bitu, ama atimapaae duraalu, “Ya̧lo dia̧paae mo i dere ape. Dia̧kó beta̧ whi̧né ȩ mepaae whi̧né dó̧póló eleké deyaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ai fo depa, atima kisipa tiki fomaake yóló, dekȩné sukutu duraalu, “Tale-ó, ai ala da̧né mo yaalopóló de?” yóló, atima feané beta̧ kaae fotóró deté felepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ti fo depa, Yesuné atimapaae duraalu, “Aita ȩtamo beta̧mó o̧la nuku betere whi̧nétei mepaae whi̧né ȩ dó̧póló eleké deyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ti noatepae, whi̧né Naalemata, kale asȩmó yóló muló betere fo motóróti dokonóturaalu sinaalopó. Téyaalotei, Whi̧né Naalema mepaae whi̧né dó̧póló eleké deyaaire whi̧ ya̧ beta̧ doasi kwia saaireteimó mo wió yae. Ai whi̧ a̧ hamané dewua̧meisóró, ti mo wisiua̧pó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tétepa, a̧ dó̧póló eleké deyaaire whi̧ Judas-né duraalu, “Yó matere whi̧-ó, ai ala ya̧lo yaalopóló de?” depa, Yesuné a̧paae duraalu, “Épó mo naaotóróti yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Atima atéró o̧la nuku bituraalu, Yesuné bred o bula tao sóró Tale Kótópaae mo kée yóló, terekée daalu yóló ama yó matere whi̧rape a̧lirótu duraalu, “Ita, ya̧lo tikipa dia̧ feané sóró nae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Téró, kale dere kaae wȩi belere wuti tao sóró Kótópaae mo kée yóló, atima melóló duraalu, “Dia̧ feané i wȩi nae. ");
INSERT INTO ppo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ti i wȩita, so whi̧ mo feané yale dowi ala kwia aluraai, Kótóné dia̧ tao saalopóló tukóló muló betere fo diriróturaalu, sókó farale ya̧lo sameapa dia̧ feané nae. ");
INSERT INTO ppo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ya̧lo dia̧paae mo i dere ape. I nokole képi du wȩi momó kae néni ha̧le bitiré fóló, ya̧lo Ayané tȩteróló kaae tare ao̧mó da̧ fea beta̧mó bitu, kisi wain wȩi naalopó. Ai be dȩ sókó waai teópa, ai wȩi me kaae néni ha̧le bitiré faalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Atéró, atima wole fo beta̧ yóló, Olip du sorokó mole tikipaae felepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Téró, Yesuné atimapaae duraalu, “Mo mió i dikitamotóró atimané ȩpaae eratere ala kilituraalu, dia̧ fea ȩ taaróló botokó faalopó. Ti noatepae, até yaaire alata, asȩmó i yóló muló betere fo mo dokonóturaalu yaalo ai ape. ‘Kale sipsip hupurape kaae tare whi̧ ya̧lo dupa, sipsip hupurape dapo dapo yó faalopó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Téyaalotei, ȩ momó kepaayóló u Kaleli haepaae ȩpi folosóró fimó dia̧ nalo waalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ai fo depa, Pitané a̧paae duraalu, “Ya̧paaetamo mené noa kaae ala eratepa, ti mepaae whi̧rape atima ya̧ taaróló fupa, ya̧lo beta̧ ya̧ mo taaróló faalomeipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ti fo depa, Yesuné a̧paae tokó̧ mótu duraalu, “Ya̧lo ya̧paae mo i dere ape. Mo mió i dikitamotóró wa̧ kakaruk bané hale yaaipatei, naao ȩ tuȩ́nipó fo sore félimó yaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ai fo yalemó, Pitané a̧paae duraalu, “Ȩ ya̧tamo beta̧mó sukutepa ti mo wisirapó. Ya̧lo ya̧ tuȩ́nipó fo mo yókélé yaalomeipó,” depa, mepaae ama yó matere whi̧rapenékélé ama dere fo kaaetóró yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Téró, Yesu a̧ ama yó matere whi̧rape fea kelaalo koko̧i tiki Ketsemanipaae fóló, ama atimapaae duraalu, “Ȩ upaae momane fulapa dia̧ imó betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Atima atéró beteróló, Pita kale Sebediné naalema tamo atima fu bitu, ama hosaa tua̧mó mo doasi dekȩné sukutere ala kaae sóró, sekȩi kisipa muté felepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Atéró ama atimapaae duraalu, “Ya̧lo hosaa tua̧mó dekȩné sukuturaalu, ȩ felekemó suka̧ai depa upaae momane fulapa, dia̧ imó ȩ kaae tawóló bitu noke fini, ȩtamo momatu betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Téró ama yó matere whi̧rape aimó betó mupa taaróló, a̧ sawa tupaae fóló, haemó deraapisa fóló fió mulu momatu duraalu, “Ya̧lo Aya-ó, i sekȩi ala ȩpaae wao̧sóró seséyaaire tu̧ mupa, ti naao sesé yae. Tépatei ya̧lo kisipa mole ala eréni, naao kisipa mole ala beta̧ eró̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Téró, a̧ ama yó matere whi̧rape beterepaae momó fesaae wóló kelalemó, atima fea noke foposaa yó molepó. Atépa, ama Pitapaae duraalu, “Sukakele beta̧mó ȩ kaae taruraalu, momatu bitinié? ");
INSERT INTO ppo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Dia̧ me dowi ala yó̧póló su̧ sere alané só derao̧sóró, hotowayóló kaae taru, momatere ala yó tawae. Kepe betenéta wisi ala eraai mo doasi ketekȩ bupatei, tó tiki fotoko̧ bunipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kale yale kaae, a̧ momó fesaae fóló momatu duraalu, “Ya̧lo Aya-ó, ȩpaae i eraaire sekȩi ala wao̧sóró seséyaaire tu̧ mupa, ti seséyae. Seséyaaire tu̧ munipa, ti naao kisipa mole alatóró ȩpaae eró̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Atéró, a̧ momó fesaae wouraalu kelalemó, atima fea kale dere kaae, noke foposaa yó molepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Atima atéró foposaapa taaróló, a̧ momó sore dakoróló fesaae fóló momaturaalu, kale yale moma kaaetóróti momó yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Téró, a̧ momayóló fesaae wóló, ama yó matere whi̧rapepaae duraalu, “Dia̧ sa̧a nóló bitu noke foposaa yó mole-a, mió da̧ ha̧le betaaire be dȩ dekéró mupa de? Kale Whi̧né Naalema dowi ala dere whi̧rapené dó̧póló eleké ai deyale ape. ");
INSERT INTO ppo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ȩ dó̧póló eleké deyale whi̧ ai walapa, dia̧ turukó horóló da̧ faalopa fiépe,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesuné ai fo du betepatei, ama yó matepa wosetere 12 whi̧rapekó Judas sókó walepó. A̧ta, kale momatere be tȩteróló kaae tare whi̧raperó so whi̧ tȩteróló kaae tare whi̧ disirapetamoné dotonale whi̧rapetamo walepó. Atima atéró wouraalu, nópuluró bóe dele sepaketamo tao diliki yóló walepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Téró, Yesu mepaae whi̧né dó̧póló eleké deyale whi̧né a̧tamo wale whi̧rapetamo fo dokóló duraalu, “Ya̧lotamo ko̧ló tukó nukupa, ti a̧tóró hi̧tipa, tawae,” ipakalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Atéró, kale Judas a̧ folosóró Yesu daalepaae sókówóló duraalu, “Yó matere whi̧, ko̧leó,” yóló, apuóló ko̧ló tukó nalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ti fo depa, Yesuné a̧paae duraalu, “No-ó, naao yaairaalu, wale ala téti yae,” yalepó. Tétepa, kale whi̧rape atima hapale sókó woutóró Yesu botokó̧ sóró tawalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Atétepa, Yesuné ama fulumu whi̧rapekó whi̧ beta̧né bóe dele sepake sókó sóró, so whi̧mó Talepaae momaratere doasi topo whi̧né kutó diratere whi̧né wosȩ́li sa̧ae deralepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tétepa, Yesuné a̧paae duraalu, “Naao ai sepake bulatere be dolomó momó bulae. Ti noatepae, mepaae whi̧ denétamo sepakené whi̧ dupa, ti ai sepakenétei a̧ mo ti dóló sukunaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Naao kisipané-a, ya̧lo Ayapaae 72,000 ensel-rapené ȩ tao sene wó̧póló dotonae depa, ama dotonaalomeipóló de? ");
INSERT INTO ppo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ya̧lotamo ai ala depa, ti kale asȩmó yaalopóló muló betere fo netéró dokonaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Atéyale sukamó, Yesuné ai so whi̧paae duraalu, “Diaao̧ kisipané ȩta, Gavman whi̧rapetamo bóe dóló atimané tȩteróló kaae tare ala fasó saai, whi̧rape fea a̧lisóró fole whi̧ beteparaalu, ȩ tawóló daai sepakeraperó nópulurapetamo tao diliki yóló wou de? Betere doko̧ fea dia̧né momatere be tipiné bopéró daaló betere tikimó ȩ fo yó mótu betepa, diaao̧ ȩ tanipó. ");
INSERT INTO ppo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ténitei ai yale alarape feata, ti Kótóné ama ko̧ló whi̧rapené asȩmó yóló muló betere fo motóró dokonóturaalu dapó,” yalepó. Atétepa, ama yó matere whi̧rapené a̧ taaróló, atima fea botokó felepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Atétepa, mo so whi̧mó Talepaae momaratere doasi topo whi̧ Kaiapas-né bemó touróló betó mupa, Yesu tawale whi̧rapené a̧ dapesó felepó. Aimó kale Moses-né asȩre fo yó matere whi̧raperó so whi̧ tȩteróló kaae tare whi̧ disirapetamo touróló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Téyaletei, Pita a̧ Yesu fi tikimó nalo taaeta deté furaalu, so whi̧mó Talepaae momaratere doasi topo whi̧né be bopéró betere tipi tua̧paae doropóló, aimó betó mole diki tare whi̧rapetamo bituraalu, Yesupaae noa alakó eratéró kelaai, kaae tawóló beterepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Atéró, so whi̧mó Talepaae momaratere whi̧raperó fo tokó̧tamo yóló taleratere whi̧rapetamoné kapala so whi̧ dilikó̧ló Yesu sukó̧póló, só deróló daaire bete kikitu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Atéró, atimané a̧ só deraai dapóló kapala fo yaletei, ai foné a̧ só deraaire su̧nipa, nalo whi̧ tamo wóló duraalu, “Ai sekȩ́néta, ‘Kótóné ai momatere be fisikóló sore be dȩmó ama momó tȩyaalopó,’ depa da̧moné wosalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tétepa, mo so whi̧mó Talepaae momaratere doasi topo whi̧ turukó holóló Yesupaae duraalu, “Ai whi̧rapené ya̧ só deratere fo dapa, naao atimapaae fo mekó tokó̧ menitere-a, noatepa de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Téyaletei, Yesu fo tekeni ha̧le daalepó. Atépa, kale momatere be kaae tare topo whi̧né a̧paae duraalu, “Mo titóró betó tare Kótóné keletómó ya̧lo ya̧paae mo dirii fo i dere ape. Ya̧ta mo so whi̧ fea tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Kótóné Naalema Kerisopata, ti mió da̧paaetóró yó a̧lae,” depa Yesuné duraalu, “Ȩ́pó. Naao mo dono ai dere ape. ");
INSERT INTO ppo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Téretei, ya̧lo dia̧ feapaae i dere ape. Take nalo waaire be dȩmó, kale Whi̧né Naalema mo doasi fotoko̧ bole Kótóné turu naasemó betepa kolóo, ó hepen be taaróló sa̧ko dolomó sókó wapa kolóo, yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ai fo depa, so whi̧mó Talepaae momaratere doasi topo whi̧né ama deró betere kuti bisa̧ayóló duraalu, “Kótó faleyóló doka doka ai du betere ape. Ti ama ha̧sókó fole ala depa kelalepó yaaire meipapakó keka̧aloé? Ti Kótó faleyóló doka doka dere fota, amatei depa dia̧ feané ai wosale ape. ");
INSERT INTO ppo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Térapa, diaao̧ noa kisipa mute?” depa, atimané duraalu, “A̧ sinaaitere fo amatei ai dapa sinó̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Téró, atimané ama kele dolomó fesa̧a apuróló, naase duné dóo, mepaae whi̧né a̧ okolope deké sóo yóló duraalu, “Kótóné so whi̧ tȩteróló kaae tare whi̧ Keriso-ó, ya̧ Kótóné ama ko̧ló whi̧pata, ti ya̧ dale whi̧ da̧paae yó a̧lae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Atéró Pita, ai be bopéró daaló betere tipi bolaa dolomó betepa, kale kutó diratere so seimale beta̧ a̧ beterepaae wóló duraalu, “Ya̧kélé u Kaleli whi̧kó Yesutamo beta̧mó kwȩale whi̧ ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ti fo depa, so whi̧ feané keletómó Pitané kale so seimalepaae duraalu, “Naao ai dere fota, noa fo yóló déró ȩ kisipanipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Atéró, kale whi̧ a̧ ai be bolaare dopóku tu̧ serekepaae sókó durupupa, me so seimalené a̧ kolóló ai betó mole so whi̧ feapaae duraalu, “I whi̧ a̧kélé, Nasaret whi̧kó Yesutamo beta̧mó kutu betale whi̧ ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ti fo depa, Pitané kale dere fo kaae Talené keletómó dirii malo yóló duraalu, “Naao ai bopetere whi̧ta ȩ tuȩ́nipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Atéró sawa betale ki̧lipaae, aimó daae mole mepaae whi̧rape Pita beterepaae wóló duraalu, “Ya̧ta atimatamo kutu betale whi̧ mo hi̧ti ai ape. Ti noatepae, naao dere fo nakomené ya̧ mo hi̧tipóló ha̧keamó yó matapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ai fo depa Pitané duraalu, “Ya̧lo dia̧paae mo i dere ape. Ai whi̧ ȩ mo tuȩ́nipó. Ya̧lo kapala fo depata, ti Talené ȩ mo doasi kwia meló̧pólópó,” yalepó. Ai fo deretamotóró wa̧ kakaruk bané hale yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tétepa, Pitané Yesuné a̧paae kale kakaruk bané hale yaaipatei, naao ȩ tuȩ́nipó fo sore félimó yaalopó yale fo kisipa muni walepó. Atétepa, Pita a̧ belapaae sókó doropóló bituraalu, mo doasi dekȩné sini wole du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Atéró, so whi̧mó Talepaae momaratere topo whi̧raperó so whi̧ tȩteróló kaae tare whi̧ disirapetamo, mo hi̧katitei Yesu sukó̧póló daairaalu, fo taleyóló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Atimané a̧ halika tikiné naase tamo dokóló, kale doasi Gavman topo whi̧ Pailat beterepaae dapesó fóló, ama naase tua̧mó mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Atéró, Yesu mepaae whi̧né dó̧póló eleké deale whi̧ Judas-né Yesutamo fo tokó̧tamo yóló só deratere ala kolóló, amatei yale alamó dapóló, mo dowi fomaake kisipa mualepó. Atéró duraalu, mo so whi̧mó Talepaae momaratere whi̧raperó so whi̧ tȩteróló kaae tare whi̧ disirapetamoné a̧ melale 30 silpa kapa moni u kale whi̧rapepaae momó melaai felepó. Atéró atimapaae duraalu, “Me ha̧sókó fele alakélé inipatei, a̧ dó̧póló ya̧lo ha̧letei eleké deale alané ȩ doasi dowi ala yalepó,” yalepó. Ai fo depa, atimané a̧paae duraalu, “Da̧paae noa yaró de? Ai alata, naaotei ai yale ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Atétepa, Judas-né ama sale moni ai kale momatere bepaae fesekée faróló, amatei a̧ képi wȩi nalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Atétepa, so whi̧mó Talepaae momaratere topo whi̧rapené kale whi̧né teraae farale moni sóró taru duraalu, “I monita, whi̧ daai dupuyaleteipa, Kótópaae matere monitamo tourao̧se yóló fo mulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Téró, atima fo taleyóló duraalu, i monita mepaae wale whi̧rape sukutepa douraaire tiki, kale doka haené wuti aletua dere whi̧rapené hae dupu yaai dapóló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ai hae tikita, whi̧ dó̧póló eleké deyalemó, melale moniné dupuyaleteiné ai haené doi whi̧né samea sókó fele haepó, miókélé ha̧le du beterapó. ");
INSERT INTO ppo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Atéyale ala Kótóné ko̧ló whi̧ Jeremaiapaae yó matepa, ama asȩyóló muló betere fo motóróti dokonóturaalu yalepó. “Talené ȩpaae i ala yae yóló muló betere fo sya furaalu, Israel so whi̧ atimané a̧ dupu yóló melale 30 silpa moniné doka haené wuti aletu betere whi̧rapené hae tiki atimanétei dupu yó̧póló yae,” fo erapó. ");
INSERT INTO ppo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ai ala ha̧le du betepa, atimané Yesukélé doasi Gavman whi̧né sóró beteró betere topo whi̧ Pailat-né keletómó daapa, a̧paae woseturaalu, “Ya̧ Juda so whi̧ tȩteróló kaae tare doasi topo whi̧é?” depa, Yesuné a̧paae duraalu, “Naaotóró mo dono ai dere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ai fo depa, so whi̧mó Talepaae momaratere topo whi̧raperó so whi̧ tȩteróló kaae tare whi̧ disirapetamoné kae kae só deratere fo a̧paae depatei, ama me fo tokó̧ menipó. ");
INSERT INTO ppo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tétepa Pailat-né a̧paae duraalu, “Atima kae kae forapené ya̧ só derótu betepatei, ya̧ fo tekeni dere-a noatepa de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ai fo depatei, Yesuné kale Pailat-né dere fo mo sawa tokó̧ matere alakélé inipó. Ai ala kale doasi Gavman topo whi̧né kilituraalu, i whi̧ta atimané dere fo tokó̧ matere alakélé mo dumipóló sira yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Téró, Gavman doasi topo whi̧né ba fo doko̧ fea atimané dua dere ala sya furaalu, o̧la detere sukamó so whi̧ touróló, atimané kisipa mole dipula beteró betere whi̧kó beta̧ ha̧le fó̧póló dotȩyae depa, ti ai whi̧tóró dotonótua dapó. ");
INSERT INTO ppo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Atéyale sukamó, dowi ala du betere doi mole whi̧ Barabas dipula beteró beterepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","So whi̧ fea atéró wóló touró betepa, Pailat-né atimapaae woseturaalu, “Diaao̧ kisipané-a, mé whi̧ dipula sokóló ha̧le fó̧póló kisipa mute? Barabas dotȩyarópé, so whi̧ feané Kerisopó du betere whi̧ Yesu dotȩyaró de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ti noatepa meipó. Kale Juda so whi̧ tȩteróló kaae tare whi̧rapené so whi̧ feané Yesuné doi hale sóró horóló, dukirateremó atima dowi kisipa muturaalu, atimané a̧ daai kale Pailat-né a̧ beterepaae dapesó weirapóló kisipa mualepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Atéró, kale Pailat a̧ so whi̧tamo fo tokó̧tamo yaai bituatere tikimó betepa, ama somané fo yó fótu duraalu, “Ya̧lo mió mo dowi noke yaleteiné ȩ doasi sekȩ yalepa, ai dowi ala mo beta̧kélé munire whi̧paae me ala momókó erao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Téyaletei, so whi̧mó Talepaae momaratere topo whi̧raperó whi̧ disirapetamoné so whi̧paae duraalu, “Barabas ipaae wó̧póló dotonóturaalu, Yesu sinó̧póló oleróló dae yae,” yóló, so whi̧ feapaae sesemeratere fo du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tétepa, kale Gavman whi̧né sóró beteró betere doasi topo whi̧né woseturaalu, “I whi̧ tamokó mé whi̧ dia̧ beterepaae wó̧póló sokóló dotonaróé?” depa, atimané duraalu, “Barabas wó̧póló dotonae!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tétepa, kale Pailat-né so whi̧paae woseturaalu, “So whi̧ feané Kerisopó du betere whi̧ Yesu neya̧roé?” yóló wosetepa, aimó daae mole so whi̧ feané duraalu, “A̧ta, filipaa ni tómó olorae!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ai fo depa, Pailat-né atimapaae duraalu, “Ai whi̧ta me dowi alakélé inipatei, ha̧le noatepa daró de?” depa, atimané fo mo ti fakeyóló duraalu, “A̧ filipaare ni tómó olorae!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tétepa, ai yó mole so whi̧ atimané kisipa mutere ala erao̧sóró, Pailat-né seséyalemókélé mo su̧ni, so whi̧né doasi foya yaaitere ala kolóló, so whi̧ feané keletómó wȩiné ama naase fukutu duraalu, “I whi̧ delemó Kótóné matere kwiata, ya̧lo saalomeitei, diaao̧tóró saalopó. Atéró sókó fatere samea ya̧lo naasemó yao̧sóró, i fokotapa kelere?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ai fo depa, so whi̧ feané duraalu, “Ai whi̧ dele kwiata, Kótóné da̧ró da̧né naale senaaletamopaae meló̧pólópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Téró, so whi̧ atimané Pailat-paae dotonae yale whi̧ Barabas ha̧le fó̧póló dotonóturaalu, mepaae diki tare whi̧rapené Yesu fokosói alapi yóló, nalo filipaa ni tómó oleróló daai dapesó fae yóló melalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Atéró, kale Gavman whi̧né sóró beteró betere topo whi̧né ama diki tare whi̧rape betere tiki wisinaale Pretorium-paae Yesu duwóló sóró felepó. Téyalemó, diki tare whi̧rape feané a̧ boperóló daane walepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","29","Téró, atimané ama deró betere kuti sokóló beta̧ sonaai kuti deralepó. Atéró, mu daai képinétei doasi topo whi̧né deratere topo taopóló bopeyóló, ama topomó deralepó. Téró, atimané beta̧ dotó tiki ama turu naasemó taróló, a̧ daalemó bukutiri tȩane doropóló duraalu, “Juda so whi̧né topo whi̧-ó!” yóló faleyóló doka doka du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Atéró atimané a̧ fesa̧a apuróló, kale dotó tiki momó fasó sóró, ama topomó momó du momó du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Atéró, atimané a̧ doka doka du beteró, sonaai kuti sókó sóró ama kuti momó deralepó. Téró, a̧ filipaa ni tómó oloraai dapesó felepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Atéró dapesó fu beteremó, Sairin be hulua whi̧kó Saimon a̧ tu̧mó hokolaa depa, a̧ fasóló ai filipaa ni a̧paae naaomo beleyae! yóló sȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Atéró, atima beta̧ hae doi Kolkotamó sókó walepó. Ai fo feteyóló whi̧né topo diri mole tikipó. ");
INSERT INTO ppo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aimó atimané Yesumó beta̧ hakesa̧ai wȩiró mo wain wȩitamo hosekéróló tepeyaletei melalemó néni hó̧yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Atéró atimané a̧ filipaa ni tómó oleróló, ki̧lipaae ama kuti saairaalu atimané ni kukwia teraae horóló mé whi̧né ni kukwia mo donotóró muni dorowapa, ti ai whi̧nétóró sua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Atéró, a̧ teó sukutu betepa, kale diki tare whi̧rape atima kaae tawóló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A̧ oleró betere ni topomó i betené dalepóló asȩyóló oleralepó. Ai asȩyóló olerale fo i ape. Juda so whi̧ tȩteróló kaae tare topo whi̧ Yesu i ape ");
INSERT INTO ppo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kale o̧lémi nuku betale whi̧ tamokélé a̧tamo beta̧mó, me whi̧ ama turu naase dȩró nimó oleróo, me whi̧ fȩ́ naase dȩró me nimó oleróo yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Mepaae ai tu̧mó fua wuatere so whi̧ atimané folópu kelepéyóló faleyóló doka doka duraalu, “Ya̧ta kale momatere be fisikóló, sore be dȩmó momó tȩyaalopó du betale whi̧pa, naaotei ya̧ tao sae. Ya̧tamo Kótóné Naalemapata, ti ai filipaa ni taaróló dere ape,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Atéró kale dere kaae, mo so whi̧mó Talepaae momaratere topo whi̧rapenékélé, Moses-né asȩre fo yó matere whi̧rapenékélé, mepaae whi̧ disirapenékélé, faleyóló doka doka duraalu, ");
INSERT INTO ppo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Mepaae whi̧rape sukao̧sóró ama tao sua yaletei, a̧ sinao̧sóró amatei tao sinitupó. Ti a̧ta, Israel fake so whi̧né doasi topo whi̧ ereteiné filipaa ni taaróló dorowapa, ti da̧ a̧paae kisipa tiki tiraalopó. ");
INSERT INTO ppo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ama duraalutamo, a̧ Kótóné Naalemapóló kisipa tiki tirateremó, Kótóné a̧ tao saai kisipa mutepa, ti tao só̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yesutamo kale beta̧mó olerale o̧lémi nuku betale whi̧ tamonékélé u whi̧rapené dere kaae, a̧ faleyóló doka doka dere forape dekéró du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Téró suka tua̧mó 12 kilok sukakelemó kaae sóró fóló, be kuluka derepaae 3-kilok-mó hae kwia mo fea dikiyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Atéró be kuluka 3-kilok seretamo, Yesuné doasi fo fakeyóló duraalu, “Eloi, Eloi, lama sabakatani,” ai fo feteyóló, “Ȩ tȩteróló kaae tare Kótó-ó, Ȩ tȩteróló kaae tare Kótó-ó, ȩ ya̧lo wotoró beteró̧póló noatepa taaróló feleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ti fo depa, mepaae aimó daae mole so whi̧rapené ama ai dere fo wosóló duraalu, “Ama Elaijapaae ape yóló ai dere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tétepa, atimakó whi̧ beta̧ mo hapale sururu yóló fóló, kale wépi kaae o̧la sóró séli kȩlaa kaae ere moi wain wȩi kale wépi kaae o̧lamó tópuró sóró, kapemó haka sóró Yesu nó̧póló melaai sóró felepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Téyaletei, mepaae whi̧rapené duraalu, “Ilaija wóló tao sene walémóló kelaalopa, atéró oleró̧póló taalae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Atéró, Yesuné ama kepe bete sókó furaalu, kale dere kaae doasi fo fake yóló a̧ sinalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Atéteretamotóró kale momatere be sata̧leróló oleró betere kuti óté kaae sóró tereketé doropóló, a salepaae sókó deralepó. Téturaalu, doasi bao yale tikimó kaporapekélé terekeyóló felepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Atéturaalu, whi̧ dourale tikikélé turukwȩ fóló, mo take Kótóné ama kae sóró beterale so whi̧ sukutepa douraletei, dou taaróló momó kepaayóló fua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesu atéró kepaayóló fi ki̧lipaae, ai kale kepaayale so whi̧rape mepaae so whi̧né koló̧póló, Kótóné ama kae tȩnó betere Jerusalem be huluapaae yó male felepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Atétepa, kale diki tare whi̧rapené topo whi̧ró Yesu me ala yao̧sóró, kaae tare diki tare whi̧rapetamoné doasi bao dere alaró mepaae kae kae dere alarapetamo kolóló, atima fea winé sukó̧ló diri furu furu yóló duraalu, “Haió! i whi̧ta, Kótóné Naalematóró mo hi̧tipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Téró, Yesu a̧ mepaae o̧la o̧la ya̧ya̧tepa tao sóró mótua yale sorape, Kaleli hae kwia taaróló wóló, Yesupaae eratere ala kelaai mo tumó daae mulu, kese faló beterepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Atima ai sorape kuamó Maktala be hulua sokó Mariakélé, Jems-ró Josis-tamoné hama Mariakélé, Sebediné naalema tamoné hamakélé, atima atéró daae molepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Be mo felekemó dikiyaai deretamo, beta̧ Arimatea be whi̧kó néli whi̧ Josep walepó. Ai whi̧ a̧kélé Yesuné yó matere whi̧ betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kale sekȩ́né Yesuné tiki saai dapóló, kale topo whi̧ Pailat-paae wosene felemó, Pailat-né ama diki tare whi̧rapepaae duraalu, “I sekȩ́né Yesuné tiki ama sóró faaipó dapa, sóró fó̧póló melae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Atéró matepa mo dȩ tekée fi linen kuti wisinaalené Yesuné tiki bopeyóló só fóló, mepaae suka̧le whi̧ dourénire kane dolomó Yesuné tiki mulalepó. Téró kale dou tu̧ kinaai aleyóló mulale kane fake biliraté fóló kinóló a̧ felepó. Ti ai kane dolota, kale whi̧ Josep a̧ sukutepa douró̧póló, aleyóló muló betere tikipó. ");
INSERT INTO ppo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Atétepa, kale Maktala be hulua sokó Mariaró ama yakoma Mariatamo ai kale whi̧ douró betere tiki kese faróló beterepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Atéyale sisópaae dótóró sa̧a nóló betaairaalu, o̧la o̧la taleyóló mulóló, be dȩtepa i ala yalepó. Kale moma dere be kaae tare topo whi̧raperó Farisi whi̧rapetamo Pailat beterepaae fóló duraalu, “Doa whi̧-ó, ai kale so whi̧ dilikité kutu betale whi̧ a̧ suka̧ai bitu be dȩ sore kemetepa, a̧ momó kepaayóló betaalopó depa, da̧né wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Atéró ai kale suka̧le whi̧né ama yó matere whi̧rapené ama tiki o̧lémi sóró fóló, mo whi̧paae a̧ momó kepaayóló beterapó deté kuturaalu, so whi̧ dilika̧alo ai ape. Atéró dilikitere alané ama take folosóró so whi̧ dilika̧letei teraae faalopó. Téyao̧sórópa, naao diki tare whi̧rapené ai kale whi̧ dourale tiki be dȩ soremó mo wisiyóló kaae tawó̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ai fo depa, Pailat-né so whi̧ tȩteróló kaae tare whi̧rapepaae duraalu, “Whi̧ douró betere tiki mo wisiyóló kaae tawó̧póló, mepaae diki tare whi̧rape dapesó fóló, etéró kaae tawae yóló yó melae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Atétepa atima fóló, kale whi̧ dou mené tuki̧yalemóló kelaai tu̧ kinale kane fakeró ha̧le daale kane kwiatamo meke eróló, tua̧mó siri mulóló diki tare whi̧rapepaae kaae tawae yóló sóró daalalepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Téró kale sa̧a naai tukóló mulale suka kemeyóló fula kaae sere be dȩmó mo hi̧katitei, Maktala be hulua so Mariaró yakoma Mariatamo kale whi̧ dou kelaai felepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Atéró, kale so tamo dou tópaae sókó faai teó fu betepatei, beta̧ ensel hepen bemó dorowóló, dou kinó betere kane fake tukwȩ faróló a̧ tómó beterepó. Ai kane fake tukwȩ falateremó, mo doakale bao yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ama tiki mo epée dȩ kaae iruraalu, ama deró betere kutikélé mo dȩ tekée fapa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ai dou kaae tawóló betó mole diki tare whi̧rapené a̧ kolóló, winé sukó̧ló diri furu furu duraalu, sukó̧ló mole whi̧rape ao̧yóló haemó deraapisa fóló molepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Téró kale so tamo sókó wapa, kale ensel-né atimaamopaae duraalu, “Diaamo wiyao̧se. Diaamota, filipaa nimó dale whi̧ Yesu kȩle waletei ya̧lo tuȩ́rapó. ");
INSERT INTO ppo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ti a̧ta imó muni, a̧ mulale tiki ha̧lerapa kelaai ape. Ti take ama yale fotóró dokonóló, a̧ kepaayóló falapó. ");
INSERT INTO ppo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Atérapa, diaamo hapale fóló, ama yó matere whi̧rapepaae i fo yae. A̧ mo ti suka̧letei kepaayóló, dia̧ nalo wó̧póló a̧pi Kaleli haepaae furaalu, a̧tamo aimó hokolaa yóló kelaalopa, ape yale fo ya̧lo diaamopaae i dere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Atétepa, kale so tamo wirutei mo hai̧tamo whi̧ dou taaróló, ama yó matere whi̧rapepaae yaai dapóló sururuyóló felepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Atéró fu betepa, Yesu hapale sókó wóló daalu ko̧leó yalepó. Atétepa, atimaamo a̧ daalepaae fóló, ama hómó apuó taru Tale-ó du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Atétu betepa, Yesuné atimaamopaae duraalu, “Wiyao̧se! Diaamo fóló, ya̧lo norapepaae diaao̧ ȩ u Kaleli haemó kelaasepóló ape yalepó, yaai fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Téró ai kale so tamo fu betepatei, kale mepaae dou kaae tawóló betale diki tare whi̧rape atima momatere be kaae tare topo whi̧rape beterepaae fóló, atimané kelale alarape fea yó melalepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ti fo depa, mo so whi̧mó Talepaae momatere topo whi̧raperó mepaae so whi̧ tȩteróló kaae tare whi̧ disirapetamo beta̧paae touróló bitu, i ala yaalopóló taleyóló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Atéró fo deyóló, kale diki tare whi̧rape atimané kelale ala mo so whi̧paae yao̧sóró fo mulótu duraalu, “Mené dia̧paae noa ala yaleé depa i fo yae, ‘Da̧ firepaae Yesuné ama yó matere whi̧rape wóló, ama tiki o̧lémi sóró falapó yae,’” yóló doasi moniné dupuyalepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Atéró duraalu, “Gavman topo whi̧né i dere fo wosetepa, dia̧tamo doasi fopaae buóló me ala erao̧sóró dia̧ seséturaalu, da̧nétei ama kisipa tiki feléraalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Téró, kale diki tare whi̧rape doasi moni sóró furaalu, atimapaae yae yale fotóróti deté kwȩyalepó. Atéró dere fo so whi̧ feané wosóló, fakerale fo mió i alimó betó mole Juda so whi̧nékélé wosóló mo kisiparapó. ");
INSERT INTO ppo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Téró Yesu a̧ suka̧ai bitu, ama yó matepa wosetere 11 whi̧rapepaae, a̧tamo Kaleli haemó daale hasi fosómó hokolaa yaalopó, yale fo tuȩ́ru atima felepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Atéró fóló, aimó atimané a̧ kolóló, hemée deyóló betó mulu Tale-ó du betalepó. Tétu betaletei, mepaae whi̧rapené Yesu a̧ hi̧ti yale moló̧póló, kisipa tamo mutu beterepó. ");
INSERT INTO ppo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","19","Tétepa, Yesu a̧ atima betere felekepaae fóló duraalu, “Ó hepen bemókélé i haemókélé ere ala fea ya̧lo tȩteróló kaae tanó̧póló, Kótóné ȩ sóró beteró beterapó. Térapa, dia̧ i hae kwiamó betóló fale so whi̧ beterepaae fóló, atimakélé ya̧lo yó matepa wosetere so whi̧ beteró̧póló, yó maté kwȩyae. Atéturaalu Alima, Naalema, Dȩi Kepe Wisi, da̧né beta̧ doimó wȩi tópurótua yae. ");
INSERT INTO ppo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tétu, ya̧lo dia̧paae yae yóló mulale ala fea, atimanékélé wosóló sya fó̧póló yó mótu betae. Ya̧lo dia̧ taaróló feni, da̧ fea beta̧mó bitiré fóló, kemene fole alimó sókó faalopóló i yóló mulatere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kótóné Naalema Yesu Kerisoné kisi fo wisi etéró kaae sirapó. ");
INSERT INTO ppo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mo take Kótóné ama fo eratere ko̧ló whi̧ Aisaiané asȩyóló muló betere fo i ape. “Ya̧lo fo era̧le fae yóló dotonatere whi̧ ya̧ waaire tu̧mó a̧pi folosóró fó̧póló, ya̧lo dotȩyaalo ai ape. Ai sekȩ́néta, ya̧ waaire tu̧ aleóló donoraalopó. ");
INSERT INTO ppo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","I whi̧ a̧ta, so whi̧kélé bitinire kópu ka̧ae fi tikimó sókó wóló daalu, fo fake yóló i fo yaalo ai ape. ‘Tale waaire tu̧ donoróló aleyae,’” erapó. ");
INSERT INTO ppo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Atéyale fo dokonóturaalu, beta̧ whi̧ Jon walepó. A̧ta so whi̧kélé bitini kópu ka̧ae fi tikimó sókó wóló duraalu, “Mepaae so whi̧ de atimané yale dowi ala taaróló, tuȩ́ tiki feteyóló walemó wȩi tópuratepa, ti Kótóné diaao̧ dowi ala kwia tokó̧ló aluraalopó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Atétere fo woseturaalu, Judia hae kwiamó betó mole so whi̧ró Jerusalem bemó betó mole so whi̧tamo a̧ beterepaae wóló, atimané yale dowi alarape fea ha̧keamó yó matepa, Jon-né atima Jordan wȩimó tópurótua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon-né ama bukutua yale kutita, ti kale kamel hupu nikiné dokóló moletei bukutua yóo, ama tokélé hupu sekaȩné aleyaletei sua yóo, yalepó. Ama nukua yale o̧la ti ero nusuró meke wȩitamopó. ");
INSERT INTO ppo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Atéró ama atimapaae duraalu, “Ȩta folosóró wale whi̧ i ape. Nalo ya̧lo ki̧lipaae, ti mo doa fotoko̧ bole sekȩ́ whi̧ waalo ai ape. Ai sekȩ́ a̧ta ȩ kaae mei, mo doasi sekȩ́ whi̧ betepa, ȩ a̧ ao̧mó beleka̧amale naale kaae beterapó. Téru, ama hó bené képi ya̧lo teraayaairetei mo su̧nipó. ");
INSERT INTO ppo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ya̧lota, dia̧ ha̧le wȩi maaté tópurótu beteretei, amata dia̧ Dȩi Kepe Wisitamo tópuraalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Atéyale sukamó, Yesu a̧ Kaleli hae kwiamó tȩne Nasaret be taaróló wapa, Jon-né a̧ Jordan wȩimó tópuralepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Téró, Yesu a̧ wȩi tópuróló hae taopaae hutu betepa, Jon-né ó sa̧paae kese horalemó hepen, be tu̧ kuti tekée fu dere kaae yóló, Dȩi Kepe Wisi ba ho̧kósere kaae Yesuné ama tikimó biti̧ dorowapa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Atéró betepa ó sa̧mó fo tekerótu duraalu, “Ya̧ta, ya̧lo mo yaala sókó fóló, hosaa mole Naalepó. Naao dere ala fea mo wisi alatóró dereteiné ȩ mo doasi hai̧né sukutapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Téyalemó mo ai fapotóróti, kale Dȩi Kepe Wisiné Yesu so whi̧kélé bitini, kópu ka̧ae fi tikipaae sȩyóló falalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesu a̧ atéró fóló betepa, be dȩ whi̧ siki tamo kemeyalepó. Atépa, Yesu a̧ dée nó̧póló Satan-né a̧paae kae kae su̧ sere alarape erótu betalepó. A̧ aimó syaae o̧latamo betepa, me ala yao̧sóró Kótóné ama ensel-rape dorowóló, Yesu tao salepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jon dipula beterale ki̧lipaae, Yesu a̧ Kaleli hae kwiapaae sókó wóló, Kótóné ama kisi fo wisi so whi̧ feapaae yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Atéró yó mótu duraalu, “Talené eraaire ala ama ko̧ló whi̧rapené deté wale fo mió i dokonatere ape. Téturaalu, Kótóné tȩteróló kaae tare alakélé mió sókó wóló i mole ape. Térapa diaao̧ du betere dowi ala taaróló, tuȩ́ tiki feteyóló kale kisi fo wisi wosóló, kisipa tiró betae,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Atéró, Yesu a̧ ai Kaleli wȩi fóku sesekȩ hutu bituraalu kelalemó, Saimon-ró noma Andrutamo ha̧leke wané ya su beterepó. Atimaamota, suka fea ya siré kotere whi̧ tamopó. ");
INSERT INTO ppo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Atétu betepa, Yesuné atimaamopaae duraalu, “Diaamo ai ya siré koteretei taaróló, ȩ sya ape. Ti noatepa mei diaamoné ai ya su dere kaae so whi̧kélé siré kwȩyaasepóló, ya̧lo diaamo sóró beteraalopa ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ama ai fo deretamotóró atimaamoné kale ya siré kotere ha̧leke wa taaróló, Yesu sya felepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Atéró a̧ sawa fóló, kale dere kaae Sebedi naalema Jems-ró noma Jon-tamo nukumó bituraalu, ha̧leke warape turukó feletei wisi wisiyóló nomotu betepa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Atétu betepa, mo ai fapotóróti Yesuné atimaamopaae duraalu, “Diaamo ȩ sya ape,” yalepó. Tétepa, atimaamoné alima Sebediró ama kutó diratere whi̧rapetamo nukumó betepatei taaróló, atimaamo Yesu sya felepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Atéró, atima fea touyóló Kapeneam bemó sókó fóló, ai bemó kale sa̧a nó̧póló tukóló muló betere sukamó atimané fo wosetere be dolopaae fóló, Yesuné fo yó melaai kaae salepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Téró, ai kale so whi̧né ama yó matere fo wosóló duraalu, “I sekȩ́né yó matere fota, doasi kisipare whi̧rapené dere fo kaae dapóló, siratu betalepó. Kale Moses-né asȩre fo yó matere whi̧rapené da̧paae atéró yó mótumipó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Atétu betalemó, mo ai fapotóróti kale ai fo wosetere be dolomó beta̧ dowi kepe tepeyóló betere whi̧né fo fakeyóló duraalu, “Nasaret be whi̧kó Yesu-ó, naao da̧mopaae noa alakó eraai waleé? Da̧mo noatepa dóló aluraai waleé? Ya̧ta, dowi ala mo beta̧kélé munire whi̧ wisinaale betepa, Kótóné sóró kae beteró beteretei, ya̧lo mo kisiparapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tétepa, Yesuné kale dowi kepe foné sóró duraalu, “Fo taaróló, whi̧ tua̧mó beteretei sókó fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ai fo deremó, kale dowi kepe sókó faairaalu, kale whi̧ tao sóró feseróló fo fakeyóló keterȩ́tamo sókó felepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Atéteremó, kale so whi̧ atimasisitei u wosene i wosene yóló duraalu, “Ita, noa ala yalerópó. Ama i yó matere kisi fota, mo doasi topo whi̧rapené dere fo kaae dapó. Dowi keperapenékélé, mo whi̧né dere kaae, a̧ ao̧mó sukó̧ló bituraalu, ama yae dere ala motóró dapóló,” siratu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Atétere ala so whi̧ mo feané kolóló, Yesuné i ala du beterapóló kulu kulu só kotepa, Kaleli hae kwiamó betó mole so whi̧ feané wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Atima fo wosetere be taaróló furaalu, Jems-ró Jon-tamokélé dape sóró Saimon-ró noma Andru-tamoné bepaae felepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Atéró fóló beteremó, kale Saimon somané hamasere tiki supu kisiné sukó̧ló mupa, Yesupaae yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tétepa, Yesu kale so kisi dalóló molepaae fóló, ama naasemó tao sóró turukó horalemó, kale soné tiki supu du betaletei tukóló, atimamó o̧la kaae sóró biliralepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Atéyale sukamó, suka doropóló be hoteretamo, mepaae kisi daae mole so whi̧ró dowi kepe tepeyóló betó mole so whi̧tamo, Yesu beterepaae dapesó wóló betera̧leta dua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ai be hulua feamó betó mole so whi̧ wóló, Yesu betere be tu̧ sókó walemó touróló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Atéró betó mupa, mepaae kae kae hepo daae mole so whi̧kélé wisirótua yóo, so whi̧ tua̧mó tepeyóló betere dowi keperapekélé ho̧konóló sókó fatua yóo, yalepó. Kale dowi keperapené Yesu a̧ atei kaae whi̧póló tuȩ́reteiné mo so whi̧paae fo yao̧sóró Yesuné ama seséyalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Téró, Yesu a̧ be dȩyaai du beteretamotei turukó holóló ai be taaróló, so whi̧kélé mei tikipaae fóló, momatu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Yesu atéró momatu betepa, Saimon-ró ama fulumu whi̧rapetamoné a̧ kikitu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Téró, atimané a̧ kekó̧ló keletepa a̧paae duraalu, “Tale-ó, so whi̧ feané ya̧ mopaae felerópóló kikitu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ai fo depa ama atimapaae tokó̧ mótu duraalu, “Da̧ i be taaróló, felekemó tȩ mole berapepaae kale fo wisi yó melaai faalopa fiépe. Ti noatepae, ȩta ai kutó diyaairaalu i wóló betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Téró, a̧ ai Kaleli hae kwia tua̧mó tȩ mole fo wosetere berapemó, kale fo wisi yó melaté kuturaalu dowi keperapekélé dóló ho̧konótua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Atéró dowi humu fuluné tiki dore whi̧ beta̧ Yesu beterepaae wóló, bukutiri tea̧ró bitu i fo yalepó. “Yesu-ó, naaotamo ȩ wisiraai kisipa mutepa, ti wisiraasepólópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ai fo depa Yesuné kale whi̧ kelalemó, ko̧lené sukutu ama tikimó naase mulóló duraalu, “Ya̧lo ya̧ wisiraai kisipa mutapa, wisi yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ai fapotóró kale whi̧ dowi humu fuluné tiki doretei mo ti wisiyalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Atéró, Yesuné kale whi̧ dotonaai mo dirii fo yóló duraalu, “Ya̧lo naao tiki wisiralepó fo mo so whi̧paae momókó deté kwȩyao̧se. Ya̧ fóló, Kótópaae momatere be kaae tare whi̧rapepaae maaté naao tiki wisiraletei yó melae. Téró, whi̧né tiki wisirateremó, mo take Moses-né melae yóló ere o̧la male fae. Ti noatepae, ai whi̧rapené naao tiki kilituraalu, ita Talené erapó yó̧póló, yó melaai fae,” yóló dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yesuné kale sekȩ́paae ai fo yaletei taaróló, ama tiki wisirale fo so whi̧ feapaae ha̧keamó yó melaté kwȩyalepó. Atéyale tikimó, Yesu a̧ so whi̧ betó mole kuamó konénipa, so whi̧ bitinire tikipaae biti̧ fua yalepó. Atétua yalemókélé, kae kae tikimó betó mole so whi̧ mo ha̧le o̧la kaae a̧ beterepaae wuatóró yó tarepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Téró nalo me sukamó, Yesu a̧ momó Kapeneam bepaae wóló beteremó, so whi̧ mo feané Yesu ama bemó wóló beterapó dere fo wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ai fo woseturaalu so whi̧ dekéró wale tikimó, be dolokélé, tu̧ sókó walekélé, so whi̧ daayaaire tȩ munipó. Atépa, atimapaae ama kale fo wisi ha̧keamó yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yesu a̧ atéró yó mótu betepa, mepaae dou̧ró whi̧rapené beta̧ tiki da̧amui whi̧ Yesu beterepaae beleyóló walepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Téyaletei, so whi̧ mo fa̧anuraalu kale whi̧rape atima whi̧ sóró faaire tȩ munipa, siki bepaae holóló, Yesu daale mo donotóróti kale siki be keya dolo sokóló tiki da̧amui whi̧ besekȩtamo turó deralepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Atétepa, Yesuné ai kale dou̧ró whi̧rapené kisipa tiki tiratere ala kolóló, kale tiki da̧amui whi̧paae duraalu, “Ti naale-ó, naao yale dowi ala kwia fea mió ya̧lo tokó̧ló aluratapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yesuné ai fo depa, kale Moses-né asȩre fo yó melatere whi̧rape atima tuȩ́ tekitu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“I whi̧ a̧ta, Kótó kaaepó du betere foné Kótó faletu beterapó. Ti dowi ala kwiata, Kótóné beta̧ su̧mó aluranérapó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Atima atéró mutu betere tuȩ́ tiki Yesuné kisipanétei mo hapale kolóló, atimapaae duraalu, “I kale yale fomó dia̧ noatepa atei kaae tuȩ́ mutu bitu de? ");
INSERT INTO ppo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ti dia̧sisitei taleyae. Mepaae whi̧né duraalu, naao dowi ala kwia ya̧lo aluratapó fo so whi̧ feané enérepé, ya̧ turukó holóló naao besekȩ sóró fae, fo enére? ");
INSERT INTO ppo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Téretei, i haemó betóló fale so whi̧né dere dowi ala tokó̧ló aluraaire fotoko̧ Whi̧né Naalemané su̧mó bulapóló, so whi̧ feané tuȩ́ yó̧póló i dapa, ya̧ turukó holóló naao besekȩ sóró bepaae fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mo ai fapotóróti, kale whi̧ atima feané keletómó turukó holóló, ama besekȩ sóró felepó. Atétere ala kolóló, so whi̧ feané sirayóló, atima Kótóné doi hale sóró horótu duraalu, “Mo take bitiré wale alimókélé, da̧né etei kaae ala mo kolókélé inipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Téró etéyalepó. Yesu a̧ momó wȩi fókumó fóló beteremó, so whi̧ mo dekéró a̧ beterepaae wóló betó molepó. Atépa, fo kaae sóró yó melalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Atétu beteró, tu̧mó furaalu kelalemó, Alpias-né naalema Lipai a̧ takis moni saairaalu kapala tȩne furu bemó betepa, a̧paae duraalu, “Ya̧ ȩ sya ape,” depa, kale whi̧ a̧ turukó holóló Yesu sya felepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Atéró Yesu a̧ Lipainé bemó o̧la naai fóló beteremó, mepaae takis moni sere whi̧rapekélé, dowi ala dere whi̧rapekélé, Yesuné ama yó matere whi̧rapekélé, ama dere fo wosóló a̧ sya fu betere so whi̧kélé, fea o̧la nuku betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Atépa, Farisi whi̧raperó mepaae Moses-né asȩre fo yó melatere whi̧rapetamoné Yesu a̧ dowi ala dere whi̧raperó takis moni sere whi̧rapetamo beta̧mó o̧la nuku betepa kelalepó. Atépa, Yesuné yó matere whi̧rapepaae woseturaalu, “A̧ takis moni siré kotere whi̧raperó dowi ala dere whi̧rapetamotei noatepa o̧la beta̧mó nuku bitu dérópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Atéró dere fo Yesuné wosóló atimapaae duraalu, “Hepo daani ha̧le sesȩre so whi̧ dokta beterepaae fumitei, hepo daale so whi̧ró tiki dore so whi̧tamo maaté fua dapó. Atétere kaae, ȩ wale alata wisi ala dere so whi̧paae ape yaai anitei, dowi ala dere so whi̧paae ape yaai walepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Téró, Jon-né yó matere whi̧raperó Farisi whi̧rapetamo atima ai sukamó o̧la weyóló ha̧le beterepó. Tépa, mepaae so whi̧ Yesu beterepaae wóló a̧paae woseturaalu, “Jon-né yó matere whi̧raperó Farisi whi̧né yó matere whi̧rapetamo o̧la weyóló bitu dere kaae, Naao yó matere whi̧rapekélé o̧la weóló bitini dere noatepa de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tétepa, Yesuné atimapaae tokó̧ mótu duraalu, “Kale nomarape atima so dokore whi̧tamo beta̧mó bituraalu, o̧la weyóló ha̧le betaaloé? So dokore whi̧kélé atima fea beta̧mó betereteiné o̧la weyóló ha̧le betenénipó. ");
INSERT INTO ppo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Téretei, me sukamó kale so dokore whi̧ atima beta̧mó betepatei, mené a̧ tawóló só fole sukamó, atima o̧la weyóló ha̧le betó muaalopó. ");
INSERT INTO ppo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mepaae whi̧né kisi kuti kwia sóró dera̧akele kuti dakoróló nomotumipó. Atétepa, ti kale kisi kuti fȩ sókó fóló kóputuraalu, dera̧akele kuti dotouyó sóró, mo ti bisa̧ae faalopó. ");
INSERT INTO ppo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Atétere kaae, mepaae whi̧rapené kale kȩlaa wale kisi wain wȩi hupu sekaȩné aleyale arói wutimó tepetumipó. Até enalemó, kale wȩi mómu sókó faai tóputuraalu, ai kale hupu sekaȩné aleyale arói wutikélé fulukó fóló, wȩikélé ha̧le besekéraalopó. Até yao̧sóró, atimané kisi wain wȩi tepeturaalu, ti hupu sekaȩné aleyale kisi wutimótóró tepetua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Téró etéyalepó. Sa̧a nó̧póló tukóló muló betere sukamó, a̧ ama yó matere whi̧rapetamo whit kutó tua̧mó kutu betalepó. Atéró kutu bituraalu, ama yó matere whi̧rapené ai kutómó ere whit bokóló nukulé fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Atétere ala Farisi whi̧rapené kolóló, a̧paae duraalu, “Sa̧a nokole sukamótei, naao yó matere whi̧rapené atei kaae ala noatepa yó̧póló kaae tare? Sa̧a nokole sukamó kutó ditepa, mo doasi fo mulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ai fo depa, ama atimapaae tokó̧ mótu duraalu, “Depit-ró ama fulumu whi̧rapetamo wotetepa yale ala asȩmó yóló muló beteretei, diaao̧ dosa̧ayóló tuȩ́ muni airapó. ");
INSERT INTO ppo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kótópaae momaratere be Abiatané tȩteróló kaae tawale sukamó, Depit a̧ Kótóné be dolopaae sókó fóló, Kótóné keletómó melaairaalu muló betere bred otei, a̧ wotetepa sóró nalepó. Téturaalu, ama fulumu whi̧rape atimakélé matepa nalepó. Ti ai o̧lata, mo ha̧le whi̧né nukupa, fo moleteiné kale momaratere be kaae tare whi̧rapené maaté nukua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Téró, Yesuné atimapaae duraalu, “Kótóné whi̧ aleyaleteita, sa̧a naai tukóló muló betere be dȩ doi sóró horó̧póló ini, whi̧ tao saai kisipa mutu, ai sa̧a nokole be dȩ tukóló muló beterapó. ");
INSERT INTO ppo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Atéreteiné Whi̧né Naalema a̧ta, ai sa̧a nó̧póló tukóló muló betere be dȩ tȩteróló kaae tare Talepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Téró me sukamó Yesu a̧ fo wosetere bepaae sókó walemó, naase dowi whi̧ beta̧ betepa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kale Sa̧a naai tukóló muló betere sukamótei, naase dowi whi̧ Yesuné wisiratémóló kelaai, mepaae whi̧rapené kele mulóló betó molepó. Aita ha̧le mei, kale tukóló muló betere be dȩmótei whi̧ wisiratepa, a̧ só deraai kisipa mutu yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tépatei, Yesuné naase dowi whi̧paae duraalu, “So whi̧ feané koló̧pólópa, ya̧ turukó holóló daayae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Atéró ama atimapaae woseturaalu, “Sa̧a nokole sukamó so whi̧ tao sere ala depa fo mulepé, dowi ala depa fo mule? Whi̧ sukao̧sóró tao sere ala depa fo mulepé, whi̧ dele ala depa fo mule?” yóló wosalemó, atimané a̧paae me fokélé tokó̧ menipó. ");
INSERT INTO ppo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ai whi̧rapené atei kaae dore whi̧paae ko̧letere ala ini, dowa̧ae fu betepa Yesu a̧ doasi sekȩi kisipa mutu, atimatamo fopaae buóló kale whi̧paae duraalu, “Naao naase teréȩ falae,” depa, ama naase teréȩ faralemó, kale dore naase mo wisiyó felepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Atéteremó, kale Farisi whi̧raperó Herot-né dere ala sya fu betere whi̧rapetamo belapaae tóȩ fóló daalu, Yesu netéró daaloé? yóló atimasisi kȩlaaróló, fo dokotu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Téró Yesuró ama yó matere whi̧rapetamo ai be taaróló, wȩi kȩla molepaae fóló beteremó, Kaleli haemó betó mole so whi̧ mo fea a̧ sya wou betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yesuné ai alarape du beterapó dere fo woseturaalu, mepaae Judia hae kwiamó betó mole so whi̧kélé, Jerusalem be hulua so whi̧kélé, Idomia hae kwiamó betó mole so whi̧kélé, Jordan wȩi fóku uté tȩró betó mole so whi̧kélé, Tair be huluaró Saidon be huluatamo felekemó betó mole so whi̧kélé, mo fea Yesu beterepaae wou betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","So whi̧ mo dekéró wóló touró betepa, ama yó matere whi̧rapepaae duraalu, “So whi̧ touró betereteiné a̧ daayaaire tȩ munipa, wȩi nuku beleka̧amalekó taleyóló mulae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ti noatepae, mepaae folosóró hepo dalóló betó mole so whi̧ wisirale ala kolóló, atima mepaae hepo daale so whi̧kélé wisiró̧póló kisipa mutu, Yesuné tikimó wolaa yaai dapóló, araletamo tȩté tȩté wou betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Téró, mepaae dowi keperapené Yesu keletere doko̧ a̧ daale ao̧mó deraapisa fóló fió mulu, fo fakeyóló duraalu, “Ya̧ta, Kótóné Naalemapó,” dua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ai fo depa, Yesuné kale dowi keperapepaae duraalu, “Ȩta, Kótóné Naalemapóló, mo so whi̧paae ha̧keamó momókó deté kwȩyao̧se,” yóló doasi fo mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Téró, Yesu a̧ du sorokó mole ao̧paae horóló bituraalu, ama tuȩ́ mole whi̧rape maaté dosa̧ayóló ape depa, atima a̧ beterepaae walepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Atéró wóló, a̧tamo fulumuyóló beta̧mó betóo, ama fo wisi yó melaté kwȩyóo, dowi keperape doló ho̧konóo yó̧póló, 12 aposel whi̧rape sóró beteralepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Atima atéró sóró beterale 12 whi̧rapené doi etérópó. Saimon-tei, me doi Yesuné Pita mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedi naalema tamo Jems-ró noma Jon-tamokélé, Yesuné kisi doi Boanersis mulalepó. Ai doi beteta, Be Sapalaané naalema tamopó. ");
INSERT INTO ppo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Filip, Batolomiu, Matyu, Tomas, Alpias naalema Jems, Tadeus, ka̧lo ka̧loi whi̧ Saimon, Iskariot whi̧kó Judas atima atéró whi̧ sóró beteralepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Kale Iskariot be whi̧kó Judas-ta, Yesu daai eleké deyale whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Téró, Yesu a̧ beta̧ be dolopaae wóló beteremó, so whi̧ mo fea momómo tourale tikimó, Yesuró ama yó matere whi̧rapetamo o̧la naaitere tȩkélé munipó. ");
INSERT INTO ppo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Atétu beterapó, dere fo Yesuné hamaró nomarapetamoné wosetu a̧ keyaa fole whi̧ kaae beterapóló, atima Yesu dape saai wóló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Atépa, mepaae Jerusalem be huluamó wale Moses-né asȩre fo yó matere whi̧rapené duraalu, “Dowi keperapené topo kepe Belsebul Yesu tua̧mó bitu a̧ fotoko̧ratepa, dowi keperape ho̧konótua du beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ai fo du betepa, Yesuné ai kale so whi̧paae a̧ beterepaae ape yóló atimapaae fo sale forape yóló duraalu, “Satan a̧tamo beta̧ kutó ditere hamoma netéró doló ho̧konaaloé? Ai kaae ala mo enénipó. ");
INSERT INTO ppo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Beta̧ doasi topo whi̧né tȩteró betere be hulua so whi̧ atimasisitei bóe dupa, atétere be huluarape fotoko̧ buóló betaaloé? Meipó. ");
INSERT INTO ppo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Beta̧ faketamotei bóe dupa, ti atétere fake fotoko̧ buóló betaaloé? Mo aténénipó. ");
INSERT INTO ppo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Atétere kaae, Satan-né ama fulumu whi̧rapetamotei bóe dupa, ti a̧tei tua̧mó teketapó. Atéturaalu, fotoko̧ buóló betaaire su̧ni, a̧tei kemeyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mepaae whi̧né doasi fotoko̧ bole whi̧ dokóló munéni, ha̧le betepatei ama be fulukóló, o̧la o̧la senénipó. Folosóró kale whi̧ a̧pi mo dirii képiné dokó mulóló, nalo ti ama be fulukóló o̧la o̧la fea su̧mó sóró fenérapó. ");
INSERT INTO ppo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ya̧lo dia̧paae mo i dere ape. Kae kae dowi alaró Kótó faletere fotamota, ti Kótóné mo su̧mó tokó̧ló aluraalopó. ");
INSERT INTO ppo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Téyaalotei, mepaae whi̧né kale Dȩi Kepe Wisi faletepa, atétere so whi̧né dowi ala kwia mo alukélé eraalomeipó. Ai dowi ala kwia, mo ha̧le muó tawaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ai fota Yesuné ha̧le inipó. Atimané duraalu, “Yesu a̧ tua̧mó dowi keperape tepeyóló bituraalu dapó,” depa, ai fo yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ai fo du betepa, Yesuné ama hamaró nomarapetamo wóló be belamó daae mulu, Yesupaae belapaae dere ape yae! yóló yó horalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tétepa, a̧ boperóló betó mole so whi̧né a̧paae duraalu, “Naao haeró nonaaorapetamoné ya̧ kȩle wóló belamó ó daae mole ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ai fo depa Yesuné atimapaae tokó̧ mótu duraalu, “Ti ya̧lo hae ó norape-a, de maaté?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ai fo yóló, a̧ boperóló betó mole so whi̧ kelené doko̧yóló duraalu, “Ya̧lo hae ó norapeta, ti dia̧tóróti i betere ape. ");
INSERT INTO ppo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ti noatepae, mepaae so whi̧ de Kótóné ama kisipa mole ala erótu betepa, ti ya̧lo no ó ne ó haetóróti ai betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Téró me sukamó a̧ wȩi fókupaae momó fóló bitu, kale fo wisi kaae sóró yó melótu betalepó. Atéró, yó melótu betepa so whi̧ mo dekéró waletikimó, a̧ betekȩtepa ai so whi̧ wȩi fókumó betó mupatei, a̧ wȩi nukupaae daane holalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ama atéró yó matere kae kae forape fea, fo salenétóró du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ama atéró yó mótu duraalu, “Ya̧lo i dere fo wosae. Whi̧ beta̧né ama kutópaae o̧la wae ke terepeyaairaalu sóró felepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Atéró só furaalu, mepaae ke tu̧ tua̧mó sókó deóló muó mupa barapené dósu yóló nukua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Téró, kale whi̧né kutómó terepeté kuturaalu, mepaae ke kapo tómó bole haemó terepée durupua yalepó. Até yaletei, ai hae mo apaae derepéni, kane tómó bole hae ereteiné kale o̧la wae mo hapale holalepó. Téyaletei, feleke hae tua̧paae doaló derepénipó. ");
INSERT INTO ppo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Atéró, kale o̧la wae holóta yaletei, mo doasi diri suka wouraalu, kale o̧la kapo supuné tukó sóró séli yaairaalu yalepó. Ti aita, kale o̧lané feleke haepaae diriyóló derepénireteinépó. ");
INSERT INTO ppo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mepaae keta, dowi mu daai ne dolomó terepée durupua yalepó. Atéyale o̧la wae holaletei, dowi nené bopée sóró muluraalu, du wisiyóló wolenipó. ");
INSERT INTO ppo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mepaae ke ti hae wisimó terepée durupua yalepó. Atéyale o̧lata mo wisiyóló holóló, du woleyalepó. Atéró, beta̧ yo sóró fóló biliyaletei u̧lumétepa suraalumo, 30-yorape ó mepaae 60-yorape ó 100-yorape fa̧anótua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ai fo sale kemetepa, ama atimapaae duraalu, “Dia̧ so whi̧ detamo wosȩ́li daapa, ti i dere fo sale bete mo wisiyóló wosóló tuȩ́ munérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ai fo du beteró, nalo so whi̧ mo fea fi tikimó, a̧ ama wotoró be dolopaae fóló betepa, ama yó matere 12 whi̧raperó mepaae a̧tamo fuluyóló betó mole whi̧rapetamoné a̧paae woseturaalu, “Naao ti yale fo sale da̧ ko̧ló ko̧lórapa noa betené yaleé?” yóló wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ai fo depa, Yesuné atimapaae tokó̧ mótu duraalu, “Tale Kótóné so whi̧ mo fea ama tȩteró kaae tare ala hiróló moletei, dia̧paae beta̧ ha̧kearóló i yó melatere ape. Téteretei, mepaae ha̧le mo so whi̧paaeta, ti fo sale foné maaté du beterapó. ");
INSERT INTO ppo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ti aita, i fo betené erapó. ‘Mió atimané kelené kilitu bitutei, ai o̧la mo diriyóló tuȩ́ mutumipó. Atimané wosȩ́liné wosetu bitutei, mo diriyóló wosóló, bete kisipa mutumipó. Ai alatamo ini, atimané dowi ala taaróló, kisipa feteyóló Kótó beterepaae wapa, ti atimané yale dowi ala kwia me o̧la meipóló, ha̧le kemeranérapó,’” erapó. ");
INSERT INTO ppo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Téró Yesuné atimapaae duraalu, “I fo sale bete dia̧ tuȩ́ni ko̧ló ko̧ló depa, ti mepaae fo sale forapekélé netérómo tuȩ́ yaaloé? ");
INSERT INTO ppo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kale o̧la ke terepeté kutu dere kaae, Kótóné ama fo wisi yó mótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kale o̧la wae ke tu̧mó sorokó doropole kaaeta, mepaae whi̧né Talené fo yó matepa so whi̧né wosóló, tuȩ́ tua̧mó mulateretei, Satan-né mo hapale tokó̧su beterapó. ");
INSERT INTO ppo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Téró, kale kapo tómó bole haemó terepée derepele o̧la wae kaaeta, kale fo wisi wosóló hȩkesetamo sua dapó. ");
INSERT INTO ppo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Téretei, o̧la wae feleke haepaae mo ti derepéniru ere kaae, kale fo wisi ha̧leke sukamó maaté wosóló taalatapó. Ai kale fo wisi woseteremó, mepaae sekȩi ala ó doasi delei ala eratepa, atima téti hapaletóró dée nukua dapó. ");
INSERT INTO ppo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kale dowi mu daai ne dolomó terepée derale o̧la wae kaaeta, kale fo wisi mo wisiyóló wosóló hȩkesené sukutere whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Téteretei, mió i haemó bitu doasi whaalia du betere alakélé, doasi néli whi̧ betenée yóló, mutere kisipané kó̧paae faróló dilikitu betere alakélé, mepaae wisi wisi o̧la senée yóló mutere tuȩ́kélé a̧ tua̧mó kaayóló sókó wouraalu, kale fo wisi botokó̧ sóró alurótu betereteiné du wisi oletimipó. ");
INSERT INTO ppo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hae wisimó terepée derepele o̧la wae kaaeta, ti kale fo wisi mo wisiyóló wosóló, ama tuȩ́ tiki tua̧mó sóró mulótua dapó. Atétere whi̧ta, o̧la wae yo beta̧ sóró fóló biliyaleteinétei, u̧lumétere alimó suraalu mepaae 30 yorape ó 60 yorape mepaae 100 yorape fa̧anótua dere kaae, mepaae so whi̧ tua̧mó Kótóné fo atéró du oletua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Téró ama atimapaae duraalu, “Sa̧ dȩróló nuku ao̧mó ó me ni fake ao̧mó kinóló mulótimipó. Téni, ai sa̧ dȩ so whi̧ feané koló̧póló, sa̧ daalatere ni fake tómó fopa ha̧keamó mulótua dapó. ");
INSERT INTO ppo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ti mió kikiti hiró betere o̧la feata, take nalo ha̧keamó mulatepa so whi̧né tuȩ́ yó̧póló erapó. Mió kinóló muló betere o̧la fea take nalo ha̧keamó mupa, so whi̧ feané koló̧póló erapó. ");
INSERT INTO ppo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dia̧ mepaae so whi̧ wosȩ́li daapa, ti i dere fo sale bete mo wisiyóló wosóló tuȩ́ yó̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Atéró, ama yale fo kaae atimapaae momómo duraalu, “Ya̧lo dia̧paae i dere fota mo wisiyóló wosóló tuȩ́ muae. Naao meteró o̧la atimamó matepa, ti Kótóné ya̧mókélé naao ai matere su̧tóróti móturaalu, mepaae tómó belerólókélé melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Whi̧ me dené ama tare o̧latamo tawóló betepa, ti atétere whi̧paae ama ai tare tómó, Kótóné me kae beleróló melaalopó. Whi̧ me denétamo me o̧lakó tanipa, ti ai sekȩ́né ama mo sawa tareteikélé, Kótóné momó tokó̧ saalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Téró ama kale yale fo kaae momó duraalu, “Kótóné tȩteróló kaae tare ao̧mó betere alata, ti beta̧ whi̧né kutómó o̧la wae ke bilitu dere kaaepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Atéró biliyale ki̧lipaae dȩtamo ó dilikitamo fipa, ó turukó horóló betepakélé, kale biliyale o̧la wae tu̧mu haemó noaró sokotérópóló, kale whi̧né ama tuȩ́ mutumipó. ");
INSERT INTO ppo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ere o̧la feata, haenétei fotoko̧róló sókó hotapó. Tu̧mupi sókó horóló, sóku woleyóló, nalo ti fua dua dapó. Atéró fua yóló, tua̧ dolomó ti whi̧né naaire ke butapó. ");
INSERT INTO ppo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ai kale o̧la u̧lumétere alimó, ti kale kutó tale a̧ sepaketamo fóló, u̧lumére o̧la siré kotapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Téró, atimapaae kale fo kaae momó duraalu, “Kótóné tȩteróló kaae tare ao̧mó mole ala diaao̧ kisipa yó̧póló, ya̧lo noa ala su̧róló yó melaaloé? Me noa fo salepaae dó faróló yaaloé? ");
INSERT INTO ppo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Kótóné tȩteróló kaae tare ao̧mó mole alata, mastard ni ke kaaepó. Ti mastard ni keta, mo sawa beleka̧amaletei, haemó bilitepa huturaalu, ti kutómó mepaae yó mole o̧la fea tȩteróló, tetei̧rape fo̧lo fua dapó. Atéru, doasi tȩi fale sirimó barape daaneta dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesuné so whi̧paae fo yó móturaalu, atei kaae fo salenétóró dekéró yó mótu betalepó. Téturaalu, atima so whi̧né wosóló kisipa yaaitere su̧tóró yó melaté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ama fo yó matere doko̧ ha̧le mo so whi̧paaeta, ti fo sale fonémaaté yó mótua yalepó. Téyaletei, ama yó matere whi̧rape atimasisi bituraalu, ti ama yó matere forape fea bete tokó̧ló yó mótua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Atétu beteró, be dikiteretamo ama yó matere whi̧rapepaae duraalu, “Da̧ nukutamo uté tȩ faalopa fiépe,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ai so whi̧ atima wȩi fókumó betó mupatei taaróló, Yesu a̧ nukumó ha̧le betepa, ama yó matere whi̧rape atima maaté felepó. Atéró fupa, mepaae nukurapekélé, atima fea beta̧mó felepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Téró ai wȩi tua̧mó fu betalemó, doakale besȩ́ tikiró wȩi asyatamo hapale sókó wouraalu, wȩi nuku dolopaae bosene dorowóló, kale nuku mo felekemó buó deyaai yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Até depatei, Yesu a̧ nuku sisóratere salemó toró mulóló noke fipa, ama yó matere whi̧rapené a̧ turukuróló duraalu, “Yó matere whi̧-ó, da̧ wȩiné mió mo felekemó sóró i aluratapa, naao da̧ ko̧lenié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Atétepa, Yesu a̧ turukó holóló, kale wȩi asyaró besȩ́ tikitamo foné sóró duraalu, “Ai whaau yóló hoteretei taaróló, béyóló dono fae,” yalepó. Téyalemó, kale wȩi asyaró besȩ́ tikitamo tukóló béyóló dono felepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ai fo yóló, ama yó matere whi̧rapepaae duraalu, “Dia̧ noatepa wiyóló diri furu furu dute? Dia̧ tuȩ́ tiki tiróló bitini airapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ai fo deremó, winé sukó̧ló atimasisitei duraalu, “Haió! a̧ noa whi̧né dérópó. Kale wȩi asyaró besȩ́ tikitamonékélé, ama dere fo wosóló, a̧ ao̧mó sukó̧ló bitupó,” yalepó ");
INSERT INTO ppo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Téró, atima ai wȩi kȩla tȩyóló Kadarin whi̧rapené hae kwiamó sókó felepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Atéró fóló, a̧ nuku taaróló hae taopaae taae felemó, beta̧ dowi keperape tepeyóló betere whi̧, whi̧ douratere tikimó biti Yesutamo hokolaayaai walepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ai whi̧ a̧ mo bemó bitini, whi̧ dou tómó bitua yalepó. Atére whi̧ mené mo képiné ó dirii sein képinékélé a̧ dokonénipó. ");
INSERT INTO ppo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Take suka fea sein képiné ama hóró naasetamo dokotua yalemó, ama fotoko̧nétei ha̧le turukó falatua yalepó. Atéreteiné whi̧nékélé a̧ tawóló dokóló béranénipó. ");
INSERT INTO ppo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ai whi̧ a̧ta, sukatamokélé, dikitamokélé, be dȩtere doko̧ fea whi̧ dou tómó bituraalukélé, du sorokó mole tikimó bituraalukélé, doasi keterȩ́ yóló, amatei ama tiki kapo fosóné tikitua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Atétu betere sekȩ́né Yesu mo umó daapa a̧ sururu yóló wóló kelalemó, Yesu doa whi̧pa kilituraalu, ama hó ao̧mó bukutiri teya̧ró biti̧ derepelepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Atéró bitu, fo fake yóló Yesupaae duraalu, “Ya̧ta, ó sa̧ taoró tȩteró betere Tale Kótóné Naalemapa, naao ȩpaae noa alakó eraai waleé? Naao ȩ dele seróló susupu eraalomeipóló, Kótóné doi yóló dirii malo dumié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ai fo depa, Yesuné kale whi̧paae duraalu, “Dowi kepe-ó, ya̧ ai whi̧ tua̧mó beteretei taaróló sókó fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ti fo fóló, Yesuné a̧paae woseturaalu, “Naao doi deé?” depa, ama tokó̧ mótu duraalu, “Ya̧lo doita Lisanipó. Da̧ mo ha̧le o̧la kaae i betó mole ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Atéró Yesupaae atima betere tiki taaróló fó̧póló ho̧konao̧se fo momó du, momó du, du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ai du sokore ao̧mó, hupurape mo ha̧le o̧la kaae kimimó daae molepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Atépa, kale dowi keperapené Yesupaae duraalu, “Da̧ ai hupurape tua̧paae biti̧ derepaai dapa, naao da̧ dotonaasepe,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ti fo deremó, Yesuné atimapaae téyae, depa atima kale whi̧ tua̧mó betaletei taaróló sorokó furaalu, hupurape tua̧paae biti̧ta yalepó. Atétepa, kale hupurape atima botokó feletikimó, kulamó doropóló wȩiné soroko̧ fóló, mo fea sisiraae felepó. Ai hupurape doko̧ sóró touróturaalu, 2000-rópó. ");
INSERT INTO ppo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Atétere ala kolóló, kale ai hupurape kaae tare whi̧rape atima botokó fóló, ipu bemó betó mole whi̧raperó doasi be huluamó betó mole whi̧rapetamopaae i ala yalepóló ene felepó. Tétepa, kale so whi̧ atima doasi be hulua tua̧mó noa alakó du bitu dérópóló, kelaai felepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Atéró, atima Yesu betere tikimó sókó wóló kelalemó, dowi keperape mo ha̧le o̧la kaae tepeyóló betale whi̧tei kuti wisi deróló mo kisipa wisi mole whi̧ kaae betepa kilitu, atima wiyalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Téró, ai ala depa kelale so whi̧né mepaae wale so whi̧paae i kale whi̧ tua̧mó betale dowi keperape ho̧konale alaró hupurapepaae erale alatamo fea yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Atei fo woseturaalu, so whi̧né Yesupaae, “Ya̧ atima betere hae kwia taaróló fae,” yóló, sȩtu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ai fo deremó, Yesu a̧ nukupaae biti̧ derepaai depa, kale dowi kepe tepeyóló betale whi̧né Yesupaae, “A̧kélé ya̧tamo fenére?” yóló wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tétepa, ai whi̧ a̧tamo faai wao̧sóró seséyóló duraalu, “Talené ko̧lené sukutu ya̧paae erale ala naao hae aya, no nerapepaae yó melaai fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ai fo depa, kale whi̧ a̧ atéyale tiki taaróló, Dekapolis be huluarapepaae fóló, Yesuné a̧paae erale ala so whi̧ feapaae yó melalepó. Téyalemó, kale so whi̧ mo feané ai dere fo woseturaalu, hai-ó! yóló siratu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Téró, Yesu a̧ nukumó kale wȩi momó ipaae tȩ wóló daapa, so whi̧ mo dekéró a̧ beterepaae bopera̧le wóló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yesu a̧ atéró beteremó, Kótóné fo wosetere be kaae tare topo whi̧ Jairus wóló Yesu kelalemó doasi whi̧pa kilitu, a̧ daale ao̧mó deraapisa fóló muluraalu, i fo yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Doa whi̧-ó, ya̧lo senaale felekemó suka̧ai depa ȩ ya̧ kȩle walepa, kisi bete wisi yó̧póló, ama tikimó naao naase mulaasepóló mo miótóró da̧mo wusuró faalopó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ai fo depa, Yesu a̧ kale whi̧tamo wusuró fupa, so whi̧ mo feané atimaamo busuró felepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Atima atéró fu betepa, 12 ba fo tua̧mó hepo daalu samea fu betere so beta̧ walepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dokta whi̧rape feané kale so wisiraai dapóló, fea ala fea yalemó wisini, atimané ai yale alané kale soné kisi betetei mo ti fake yalepó. Téturaalu, ama monikélé ha̧le kemeralepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yesuné mepaae so whi̧ wisiraté kutu beterapó dere fo kale soné wosóló, a̧ so whi̧ kuamó buté buté wóló, Yesuné kuti salemó wolaayó salepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ti noatepae, kale soné ama tuȩ́né Yesuné kutimó maaté wolaa depa, ama tiki tua̧mó daale kisi bete wisiyaalopó kisipa mutu wolaayalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Atéró, wolaa deretamotóró kale so a̧ samea fu betaletei tikituraalu tiki felétepa ama kisi bete mo ti kemeyalepó kisipa mualepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Até yale tikimó, Yesuné ama fotoko̧ sókó foletei kisiparu, a̧ so whi̧ kua dolomótei fetée fóló duraalu, “Ya̧lo kutimó né wolaa yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tétepa, ama yó matere whi̧rapené a̧paae tokó̧ mótu duraalu, “Mo turó so whi̧né ya̧ ai betekini betekini du beterapa, ȩ né wolaa yaleé? fo-a, noatepa de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tétepa, Yesuné a̧ wolaayale whi̧ kelaai kelené doko̧ du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Atétepa, kale soné a̧paae erale alamó tuȩ́ muturaalu, a̧ witamo diri furu furu du bitu Yesu daale ao̧mó deraapisa fóló mulu, ama mo yale alatóró fea Yesupaae ha̧kearóló yó melalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tétepa Yesuné kale sopaae duraalu, “Ti senaale-ó, naao tuȩ́ tiki tiró betale alané ya̧ dele su betale kisi bete ai wisiyalepa, naao hosaa muni deóló dua fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kale sotamo ai fo du betepatei, Kótóné fo wosetere be kaae tare whi̧ Jairus-né ama be whi̧rape wóló a̧paae duraalu, “Naao senaaleta mo ti suka̧lepa, ai yó matere whi̧paae naao me fo kae ini, ama teó̧póló taalae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ti fo depa Yesuné atimané ai dere fo sisópaae eróló, kale fo wosetere be kaae tare whi̧paae duraalu, “Ya̧ whaalia yóló dei tuȩ́ muni, tuȩ́ tiki beta̧ tirae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mepaae whi̧rape a̧tamo faaitapóló wao̧sóró seséyóló, Pita, Jems, ama noma Jon atima beta̧ a̧tamo faai dape salepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Atima atéró fóló, kale fo wosetere be kaae tare whi̧né bemó sókó felemó, so whi̧ mo ha̧le o̧la kaae kale senaale bopé tómó betó muluraalu, mo dekȩné suki̧ moló yóo, mepaae so whi̧ ti atima hosaa tua̧mó dekȩné sukuturaalu, wole kaape maaté dorowóo, mepaae so whi̧ ti ha̧le fo tiki whaa yóo, du betepa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Atéró, Yesu a̧ be tua̧paae fóló, aimó betó mole so whi̧paae duraalu, “Dia̧ fo tiki whaaró wole-utamo noatepa du bitute? Ai senaaleta mo ti sukuni, kapala noke ai fire ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ama ai fo deremó, kale so whi̧né a̧ do̧ nalalepó. Tétepa, Yesuné mo so whi̧ fea belapaae ho̧kó faróló, a̧tamo wale whi̧raperó kale senaalené hamaró alimatamo beta̧ kale senaale mole be dolopaae felepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Téró, Yesuné kale senaale naasemó tao sóró duraalu, “Talita kum” i fo feteyóló “Ti senaale-ó, ya̧lo ya̧paae dapa turukó holae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ai fo deretamotóró kale senaale turukó horóló kwȩyalepó. Ai senaale a̧ betale ba fota, 12-rópó. Ai be dolomó a̧tamo daae mole so whi̧né atétere ala kilituraalu, hai-ó! yóló siratu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Atéró, Yesuné atimapaae i ala yalepóló mepaae so whi̧paae momókó deté kwȩyao̧se yóló fo mulóló, kale senaalemó o̧lakó melae yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Téró Yesu a̧ atéyale be taaróló, ama yó matere whi̧rape atima ama turuku be huluapaae felepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Atima atéró fóló bituraalu, kale sa̧a nóló beteró̧póló tukóló muló betere sukamó a̧ fo wosetere be dolopaae fóló, fo kaae sóró yó melalepó. Atéró yó melalemó, so whi̧ feané ama yó matere fo wosóló sirayóló duraalu, “I whi̧né ama tuȩ́ tiki dotoróȩ fóló du betere doasi kelemei alarape-a, momó salerópó? ");
INSERT INTO ppo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ti a̧ta whi̧ me kae mei, kale Mariané naalema be tȩtere whi̧ meié? Ama nomarapeta, Jems, Joses, Saimon, Judas-sépi atima imó bitinié? Ama nemarapekélé, da̧tamo i betó mole ape,” yóló atimané a̧ ha̧le mo whi̧ nisiyóló dei tuȩ́ muturaalu faletu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ai fo depa Yesuné atimapaae duraalu, “Kótóné ama ko̧ló whi̧ kae be huluapaae fupa ti ai so whi̧né a̧ dukiróló, ama doi sóró horótu beteretei, ama kekelé so whi̧ró ama turuku be hulua so whi̧tamoné a̧ dukiróló, ama doi mulatere ala dumipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Atéró a̧ ai bemó bituraalu, mepaae kelemei alarape erénitei, beta̧ beta̧ hepo daae mole so whi̧ maaté ama naase mulóló, wisirótua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Atéró, so whi̧ feané a̧paae tuȩ́ tiki tirénitere noatepa dérópó kisipa mualepó. Téró, felekemó tȩté fale be hulua doko̧ Yesuné kale fo wisi yó melaté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ama sóró beteró betere 12 whi̧rape a̧ beterepaae ape yóló, so whi̧ tua̧mó betere dowi keperape doló ho̧konó̧póló, atima fotoko̧ bulóló sóró beteralepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Atéyale ki̧lipaae atima tamo tamo yóló dotonaairaalu, etei ma fo yalepó. “Dia̧ furaalu mepaae nokole o̧lakélé, monikélé to dolomó bulóló fao̧se. ");
INSERT INTO ppo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tétu, bukaaire kutikélé me dekaaporóló sóró feni, ho̧leke be beta̧ horóló, dotó tiki tawóló fae. ");
INSERT INTO ppo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Dia̧ me be huluamó sókó furaalu, beta̧ whi̧né bemó fitepa, ti ai bemótóró bitiré fóló, me bepaae furaalu, ai be taalae. ");
INSERT INTO ppo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kale dere kaae, dia̧ me be huluamó sókó fȩlalemó, dia̧ wisiyóló dape seni yóo, diaao̧ dere fokélé woseni yóo depa, dia̧ faairaalu i ala yae. Ai be hulua so whi̧ diaao̧ atimapaae wisi ala eraai yalemó, atimanétei hó̧tepa taaróló felepóló kisipa yó̧póló, diaao̧ ho̧leke bemó dakere hae terepée deróló fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Atima atéró fóló, kale fo wisi yó mótu duraalu, “Diaao̧ dowi ala taaróló tuȩ́ tiki feteyóló betenérapóló,” yó melaté kutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Atima atéró kuturaalu, mepaae so whi̧ tua̧mó betere dowi keperape doló ho̧konótua yóo, mepaae kisi dalóló mole so whi̧ wel wȩi dilóló wisirótua yóo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesuné erótu betere kelemei ala so whi̧ feané kolóló duraalu, “Aita, wȩi tópuratere whi̧kó Jon mo sukó̧póló daletei, momó kepaayóló beterapó. Atére fotoko̧né ama mepaae doasi kelemei alarape erótu beterapóló,” so whi̧né ama doi só kotere fo kale topo whi̧ Herot-né wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Atépa mepaae so whi̧né duraalu, “A̧ta Ilaija kepaayóló beterapó,” depa, mepaae so whi̧némo duraalu, “A̧ta, Kótóné ko̧ló whi̧kó du yalepó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Atéró kulu kulu só kotere fo topo whi̧ Herot-né wosóló duraalu, “Ai whi̧ta me kae mei, ya̧lo depa tukóló dale whi̧ Jon momó kepaatu yalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Ai alata ha̧le ini, Filip-né so Herodias noma Herot-né tokó̧ló dokalepó. Atéteremó, Jon-né kale topo whi̧ Herot-paae, “Naao noné sotei tokó̧ló dokotere ala fo mulapó,” yalemótei, Herot-né ama diki tare whi̧rapepaae Jon dapesó fóló, dirii képiné dokóló, “Dipula beterae,” yalepó. Atéteremó, kale so Herodias a̧ doasi fopaae buturaalu, Jon daaitere tu̧ kikitu betalepó. Téyaletei, Herot-né Jon a̧ mo donoi alamaaté yó tapa, Kótóné mo kae beteró betere whi̧ wisipóló kisipa mutu, ama somané yaai dere ala seséyalepó. Ti noatepae, Herot-né Jon-né du betere fo ekȩle yóló wosetu betaletei, ai foné bete ama kisipa seni, ko̧ló ko̧ló yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Téró, Herodias-né Jon daaire tu̧ keketé fóló, nalo ti etei kaae tu̧ kelalepó. Herot a̧ deale be dȩ wapa, ama sóró beteró betere doasi whi̧rapemókélé, ama diki tare whi̧rapené topo whi̧rapemókélé, Kaleli haemó betó mole doi mole whi̧ disirapemókélé, mo doasi o̧la deralepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Atima atéró o̧la deyóló nuku betalemó, kale so Herodias-né senaalema sókó wóló, ki̧liyaleteiné Herot-ró ama o̧la naai wóló betó mole so whi̧tamo doasi hȩkeserótu betalepó. Atéteremó a̧ hȩkeseturaalu, kale topo whi̧né kale so seimalepaae duraalu, “Ya̧ noa o̧lakó saai tuȩ́ mute? Naao saai tuȩ́ mutere o̧la ya̧lo melaalopa, ȩpaae yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Atéró, Herot-né kale so seimaletamo mo dirii fo yóló mulótu duraalu, “Ya̧lo tȩteróló kaae tare haekélé tua̧mó tekeyóló, ó mepaae o̧la o̧la kwiapaae ya̧ saai tuȩ́ mutepa, ya̧lo ya̧ melaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ai fo depa kale so seimale a̧ fóló, hamapaae woseturaalu, “Ȩmó noa o̧lakó meló̧póló a̧paae yaróe?” depa, hamané duraalu, “Kale wȩi tópuratere whi̧ Jon depa tukóló, ama topo du beta̧ a̧lae yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ti fo depa, kale senaale hamané dere fo wosóló, a̧ kale doasi topo whi̧ Herot beterepaae fóló duraalu, “Kale wȩi tópuratere whi̧ Jon-né topo mo miótóróti tukóló, nuku tómó beleróló a̧lae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kale senaalené ai fo deremó, Herot a̧ fomo duraalu, kutiri humula yalepó. Téyaletei, ama o̧la naai wóló bétó mole so whi̧ feané keletómó, ama yóló mulale dirii fo tikinépa, téyaalopó yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Atéró, Herot-né hapale tétitóró kale whi̧ du betere whi̧paae duraalu, “Ya̧ dipula bepaae fóló, Jon depa tukóló ama topo du sóró ape,” yóló dotȩyalepó. Tétepa kale whi̧ fóló, Jon depa tukóló topo nuku tómó beleróló sóró wóló, kale so seimalepaae melatepa, amamo hamapaae male felepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jon atéró depa tikalepó dere fo woseturaalu, ama yó matere whi̧rape wóló, ama tupuló tiki beta̧ sóró whi̧ bulatere kane dolomó douralepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Téró Yesuné dotȩyale, aposel whi̧rape atima a̧ beterepaae fesaae wóló Yesu boperóló daalu, atimané yó male foró yale alatamo a̧paae yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Atéró yó mótu betepa, so whi̧ mo fea fua wua du bituraalu atima o̧la naaire tȩkélé munipa, Yesuné atimapaae duraalu, “Da̧ i betere tiki taaróló, so whi̧ bitinire tikipaae sa̧a nóló biti̧ faalopa ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Atéró, atimasisi so whi̧ bitinire tikipaae betaai wȩi nukumó felepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Téyalemó so whi̧ feané atima foletei kolóló, atimatamo hokolaa yaairaalu, Yesusépi faai dere tikipaae hae tu̧mó so whi̧ atimapi hapale sókó fóló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Atéró, Yesusépi atima nuku taaróló, haepaae taae doropóló kelalemó, so whi̧ mo ha̧le o̧la kaae wóló betó molepó. Ai so whi̧ta kaae tare whi̧ meiyóló, atima ko̧leaané betó mole sipsip hupurape kaae betepa kilitu, Yesuné atima ko̧lené suka̧lepó. Téturaalu, Yesuné atimapaae bete mole forape fea yó melaai kaae salepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Atéró yó melaté fu betepatei, be mo ti dikiyalepó. Atétepa, ama yó matere whi̧rape a̧ daalepaae wóló duraalu, “Doai so whi̧-a, whi̧kélé bitinire tikimó betepatei, be ai diki yale ape. ");
INSERT INTO ppo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Térapa, ti felekemó tȩ mole beraperó ipu berapetamopaae o̧lakó atimanétei dupuyóló naleta yó̧póló, dotȩyaasepe,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ai fo depa ama atimapaae duraalu, “Atimané naaire o̧la diaao̧tei melae,” depa, atimané a̧paae duraalu, “Atima naaire o̧la 200 denarias moniné su̧mó dupunére?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ai fo depa ama atimapaae duraalu, “Ti wisirapa, bred o bulakó meteró muléró kȩle fae,” yalepó. Ai fo depa, atimané kȩle fóló a̧paae duraalu, “Bred o bula aporó yóo, ya tamo yóo yóló beta̧ mulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Atépa ama atimapaae duraalu, “Bukóló kae kae beterae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ai fo depa, ama yó matere whi̧rapené kale so whi̧rape dosa̧ayóló, 100 whi̧rape beta̧paae yóló kae beteróo, mepaae 50 whi̧rape beta̧paae yóló, kae beteróo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Atéró beteróló, kale bred o bula aporó yóo, ya tamo yóo yóló, taru hepen-paae kese horóló momaturaalu, Talepaae mo kée yóló kemetepa, kolokóraalu yóló, ama yó matere whi̧rapepaae melalepó. Tétepa atimanémo mo so whi̧mó a̧liralepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Atéró, ai o̧la atima mepaae so whi̧ ha̧sókó dini, mo fea su̧mó nalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Atéró nóló muni fele bred oró ya bukitamo ama yó matepa, wosetere whi̧rapené siré kwȩyóló, 12 yorape deyóló fa̧analepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Soraperó naale senaaletamo dosa̧ani, ai o̧la nale whi̧rape maaté dosa̧ayóló touróturaalu, 5000 whi̧rapepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Atétu beteró, mo ai fapotóróti Yesu a̧ ai touró betere so whi̧pi fó̧póló kaae taru, ama yó matere whi̧rape atimapi wȩi nuku sóró Betsaida bepaae fó̧póló, dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Atéró, nalo Yesu a̧ ama wotoró bituraalu, so whi̧paae ko̧le-ó yóló fó̧póló dotonóló, a̧ du sorokó mole ao̧paae moma yaairaalu felepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Atéró be dikité dorowaletamo, Yesuné ama yó matere whi̧rape atima nukutamo wȩi kulu tua̧mó fu betepa, a̧ ama wotoró wȩi fókumó beterepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Atéró bituraalu kelalemó, ama yó matere whi̧rape atima nuku bisiki fotoko̧yóló i̧tu betepa kelalepó. Ti noatepae, atima faai fole tikiró besȩ́ tiki wouraalu, fotoko̧né bisiki tȩtepa, mo fotoko̧yóló i̧tu betalepó. Atétu betepa, be mo dȩyaai du beteretamo Yesu a̧ atima dekeróló faai, wȩi tómó daaté walepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","A̧ wȩi tómó atéró daaté waletei atima feané kolóló, kepe wale nisiyóló wituraalu atima keterȩ́ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Até deretamo Yesu sókó wóló atimapaae duraalu, “Ita ȩpa, wiyao̧se. Diaao̧ hosaa diriyóló dua betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yesu atéró wȩi tómó daaté wóló, nuku tua̧paae taae holalemó, kale wou betale besȩ́ tiki tikalepó. Atétere ala kolóló, kale whi̧rape atima siratu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Atéró o̧la kolokó daalu yóló nale bete atima wisiyóló kisipa muni, atimané tuȩ́ tiki hapólu ipakalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Atéró, atima wȩi tȩ Kenesaret haeró fóló, kale nuku ai dulalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Atima atéró, nuku dulóló haepaae taae feletamotóró so whi̧ mo feané Yesu kilitu, a̧ Yesupóló kisipa yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Atéró, Yesu kelale so whi̧ mo hapale fóló, ai hae kwiamó tȩ mole be hulua feamó hepo daróló betó mole so whi̧ beleyóló, Yesuné wisiró̧póló, a̧ kotere tiki dokosó fua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Atéró Yesu a̧ sawa be huluarapepaaekélé, doasi be huluarapepaaekélé, ipu berapepaaekélé, kotopa so whi̧né ai ala deté kutu betalepó. Atéturaalu, mepaae ai be huluamó hepo dalóló betó mole so whi̧ o̧la dupuneta dere tikimó betera̧leta yalepó. Atéró betó mulu, Yesupaae woseturaalu, “Naao kuti salemó maaté da̧né wolaa yó su yaaitapóló,” dotopoi fo du betalepó. Atéró, Yesuné kuti salemó maaté wolaa yale so whi̧ fea wisitua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Atéró, kale mepaae Farisi whi̧raperó Moses-né yóló muló betere fo yó melatere whi̧rapekó mepaae whi̧rapetamo atima Jerusalem be taaróló, Yesu beterepaae wóló a̧ bopéróló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Atima atéró wóló betó mulu, Yesuné yó matere whi̧rape atima naase fokoni, o̧la nuku betepa kelalepó. Atétepa, kale whi̧rapené duraalu, “Da̧ o̧la naai naase fokutu dere kaae atimakélé fokotere noatepa dérópó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ti noatepae, kale Farisi whi̧raperó Judia whi̧rapetamo atima alimarapené mara mole ala sya furaalu, naase bólu epa, ó bólu inipatei naase fokonitepa, ti atima o̧la naalomeipó. ");
INSERT INTO ppo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Atéturaalu, atima o̧la dupuneta dere tikipaae fi wóló, atimané tiki bólu inipakélé wȩi tópunipa, ti atima o̧la nukua dumipó. Téturaalu, atimané alimarapené kae kae mara mole alarapekélé hotowa yóló sya fu dere kaae, atimané o̧la detere wutirape ó wȩi nokole wutirapekélé fea fokóló nukua dapó. ");
INSERT INTO ppo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Atéreteiné kale Farisi whi̧raperó Moses-né asȩre fo yó matepa whi̧rapetamoné Yesupaae duraalu, “Naao yó matere whi̧rapené da̧né ayarapené mara mole ala sya fóló, atimané naase fokonipatei o̧la nukua dere-a, noatepa de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ai fo depa Yesuné atimapaae tokó̧ mótu duraalu, “Kótóné ama ko̧ló whi̧ Aisaiané dia̧ tó tikiné siki̧lire whi̧rapemó tuȩ́ muturaalu, i fo mo donotóró asȩyóló muló beterapó. ‘I so whi̧ atimané hosaa tua̧mó ȩ sóró beterénirutei, ha̧le ko̧lóné maaté ya̧lo doi hale sóró horótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Atimané yó mótu betere fota, bete munipatei mo whi̧né kisipané kekeme nóló i ala yae ó yao̧se du beterapó. Atima ȩ ao̧mó bitinirutei, ha̧le foné maaté Tale-ó du beterapó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ti diaao̧ ayarapené mara mole alatóró ha̧le sya fu bituraalu, Kótóné yae yóló muló betere fo eréni, taaló ai betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Téró ama atimapaae duraalu, “Kótóné yae yóló muló betere fo sisópaae eróló, dia̧né ayarapené mara mole ala wisirapóló ai sya fu betere ape. ");
INSERT INTO ppo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ti noatepae, Moses-né i fo asȩyóló muló beterapó. ‘Naao ayaró haetamo ao̧mó sukó̧ló bituraalu, atimaamoné doi hale sóró horótu betae,’ erapó. Me fo i ape. ‘Mepaae whi̧né ama hamaró alimatamo tekeratere fo depa, atétere whi̧ mo ti sukó̧póló dae.’ fo asȩyóló muló beterapó. ");
INSERT INTO ppo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ai fo epatei, diaao̧ i fo du beterapó. ‘Mepaae whi̧né ama hamaró alimatamopaae duraalu, “Ya̧lo mole o̧la o̧la diaamo tao sóró mólua̧tei, Kótópaae melaleteiné dia̧amo werapó. Ya̧lo mole o̧la feata, Koropani, ai fo feteyóló Kótó melale o̧lapóló mo so whi̧né supa, ti fo mulapó,” ’ dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kale mepaae whi̧né ama hamaró alimatamo tao saairetei diaao̧ atétere alané sesétu beterapó. ");
INSERT INTO ppo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ti dia̧ta, diaao̧ ayarapené mo deté wale mara mole ala sya furaalu, Kótóné fo ha̧le o̧la kaae ao̧rótu beterapó. Take ai ala deté wale kaae, mió diaao̧kélé atei kaae alarape ho̧ko ai du betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Téró, Yesuné kale mo so whi̧ a̧ beterepaae momó ape yóló duraalu, “Dia̧ feané ya̧lo i dere fo mo diriyóló wosóló tuȩ́ muae. ");
INSERT INTO ppo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mo nokole o̧la whi̧né tiki tua̧paae durupuraalu whi̧ dorótimipó. Téni, whi̧né tiki tua̧mó kaayóló sókó wale alané beta̧ whi̧ doratapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Atéró, Yesu a̧ ai so whi̧ betepa taaróló, fóló bemó beteremó, ama yó matere whi̧rape a̧ beterepaae wóló, ama kale yale fo sale fo noa betené yalerópóló a̧paae wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ai fo depa ama atimapaae duraalu, “Dia̧kélé, diaao̧ kisipa tiki hapólu eruraalu, ya̧lo ai yale fo bete tuȩ́ni airapó. Mo nokole o̧la whi̧né tiki tua̧paae doropóló whi̧ doréni deretei, dia̧ kisipanié? ");
INSERT INTO ppo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ti mo nokole o̧lata, whi̧né hosaa tua̧paae sókó fumitei, depepaae doropóló, di alée fulapó,” yalepó. Yesuné ai fo ereteiné nokole o̧la fea naaitepa fo munipa, nae erapó. ");
INSERT INTO ppo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ai fo tómó olekeyóló atimapaae duraalu, “Whi̧né tiki tua̧mó kaayóló belapaae sókó wale alané beta̧ whi̧ doratapó. ");
INSERT INTO ppo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","23","Ti whi̧né hosaa tua̧mó kaayóló wale alarape i ape. Dei tuȩ́ mutere alakélé, ao̧ni kae kae ho̧ko nópu nokole alakélé, mené o̧la o̧lémi sere alakélé, whi̧ dele alakélé, nópu nokole alakélé, fea o̧lamó ekȩle dere alakélé, me whi̧tamo dei tuȩ́ mutere alakélé, kapala dilikitere alakélé, mo enénire dowi alakélé, mené o̧la senée yóló dei tuȩ́ mutere alakélé, me whi̧ eratere fokélé, sekȩ́ whi̧póló bopé faketere alakélé, wisi tuȩ́ muniru, sonaalei ho̧ko du betere dowi alakélé, ai dosa̧ayale alarape fea whi̧ tua̧mó kaayóló wouraalu, whi̧ dorótua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Téró Yesu a̧ ai be taaróló, doasi Tair be hulua bopéróló tȩ mole berapepaae felepó. Atéró, a̧ beta̧ whi̧né be dolomó fóló betepa, mepaae whi̧rapené a̧ kelao̧sóró bope yao̧se yaletei, a̧ kinóló betenénipó. ");
INSERT INTO ppo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","A̧ atéró beterapó dere fo beta̧ dowi kepe tepeyóló betere senaale hamané wosóló, a̧ Yesu beterepaae hapale sókó walepó. Atéró, a̧ Yesu daale ao̧mó deraapisa fóló fió mualepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A̧ta Juda fake mei, Krik so a̧ hamané Siria haemó tȩne be Fonisiamó dealepó. Ai so Yesu daale ao̧mó fió mulu duraalu, “Ya̧lo senaale tua̧mó betere dowi kepe naao ho̧konaasepé,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ai fo depa, Yesuné kale sopaae duraalu, “Folosóró naale senaalené nokole o̧la atimapi nó̧póló melae. Ti noatepae, atima su̧mó nénipatei, yuwirape nó̧póló matere ala dorapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ti fo depa, kale soné a̧paae tokó̧ mótu duraalu, “Tale-ó, aita mo deretei, kale keteirapené o̧la ni fake tómó beleróló nokole folope sorokóta deretei hao̧rapenékélé nukua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ai fo depa, Yesuné kale sopaae duraalu, “Naao ai dere foné naao senaale tua̧mó betere dowi kepe sókó felepa, dua fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ai fo depa, kale so a̧ ama bepaae sókó fóló senaalema kelalemó, ama tiki tua̧mó betere dowi kepe sókó fóló, besekȩ tómó a̧ feléyóló fió molepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Atéró Yesu a̧ ai Tair hae kwia taaróló, Saidon hae kwia tua̧mó tȩyóló fóló, Kaleli wȩi fókumó tȩ mole be Dekapolis hae kwiamó sókó felepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yesu atéró sókó fóló beteremó, beta̧ wosȩ́li ki̧yóló fokélé alure whi̧ Yesuné wolaa yó̧póló, atimané dapesó wóló beteralepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Atéró betepa, kale so whi̧ daae mole tiki taaróló, Yesuné dȩpaae dapesó fóló daalu, ama naase dou̧ tamo kale whi̧né wosȩ́li dolopaae kesekée faróló sókó salepó. Atéró, ama naase dou̧mó fesa̧a fȩ eróló, kale whi̧né hapemó wolaayalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Atéró, Yesu a̧ hepen-paae kese horóló fomo sókó faróló duraalu, “Epapeta” i fo feteyóló, “Ki̧netei tukwȩ fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ai fo deremó, kale whi̧né ki̧ne wosȩ́li tukwȩ fóo, ama ko̧lókélé tukwȩ fóo duraalu, fo du betere whi̧ kaae, fo kaae sóró yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Atéró, Yesuné atimapaae erale alarape mepaae whi̧paae, “Yao̧se,” yóló fo mulaletei, Yesuné yale ala so whi̧ feapaae deté kwȩyóló fakeralepó. ");
INSERT INTO ppo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","So whi̧ feané atétere fo wosetu, sirayóló duraalu, “I whi̧né du betere ala feata, mo koko̧i ala alamaaté erótua dapó. Wosȩ́li ki̧ne whi̧tei tukwȩ falóo, ko̧ló nomone whi̧kélé fo yóo, dapó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Atéró kale yale kaae, mepaae so whi̧ mo dekéró a̧ beterepaae toura̧le wóló betó molepó. Atéró betó mole so whi̧ atima naaire o̧la meipa, ama yó matere whi̧rapepaae ape yóló duraalu, “I so whi̧ sore sukamó ȩtamo bituraalu, o̧lakélé néni, ha̧le betaleteiné atima ȩ mo doasi ko̧lené sukutapó. ");
INSERT INTO ppo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ti atima mepaae so whi̧ta, saletómó waleteiné wote siri ha̧le fó̧póló dotonatepa, tu̧ tua̧mó wotené sisiraae fao̧sóró dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ti fo depa, ama yó matere whi̧rapené a̧paae duraalu, “Aita mo deretei, so whi̧kélé meitikimó atimané naaire o̧la-a, momó mupa melaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ai fo depa, Yesuné atimapaae woseturaalu, “Ti dia̧né bred o bulakó meteró mule?” depa, atimané a̧paae duraalu, “Wȩikeró o bularape beta̧ mulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tétepa, Yesuné ai betó mole so whi̧ fea hae tikimó betae yóló, kale bred o bularape ama sóró taru, Talepaae mo kée yóló, momayalepó. Atéró momayóló kemetepa, Yesuné kolokó daalu yóló, ama yó matere whi̧rapepaae melae depa, atimanémo, kale so whi̧mó a̧liróló melaté kwȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Téró, ama yó matere whi̧rape atimané toróti mole ya beleka̧atikikélé melatepa, Talepaae mo kée yóló, atimapaae duraalu, “I yarapekélé nó̧póló, melaté kwȩyae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Atéró, atima nóló su̧turaalu buki muni feletei, ama yó matere whi̧rapené daseté kwȩyóló, wȩikeró yorape fa̧analepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Atima ai o̧la nale whi̧rape doko̧ sóró touróturaalu, felekemó 4000-whi̧rapepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Atéró kemetepa, ai betó mole so whi̧ fó̧póló dotȩyóló, Yesu a̧ ama yó matere whi̧rape atima Dalmanuta hae kwiapaae nukutamo felepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Atima atéró fóló betepa, mepaae Farisi whi̧rape Yesu beterepaae wóló, a̧paae kae kae wosetere fo du betalepó. Aita, a̧ ka̧ae kolóló su̧ suraalu, naao hepen bemó mole kelemei alakó da̧maletamo kelaai dapa, eranénié? du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Atéteremó, Yesu a̧ fomo sókó faróló atimapaae duraalu, “Dia̧ mió i alimó betere so whi̧né me kelemei alakó kelaaipa erae du betere-a, noatepa de? Talené dia̧paae kelemei ala me kae eraalo meipóló ya̧lo dia̧paae mo i dere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ai fo du beteró kemetepa, kale so whi̧ betó mupatei taaróló, atima nukutamo wȩi fóku utéró momó tȩ felepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Atima atéró furaalu, mepaae o̧la uté tȩró mupatei kȩóró bred o bula beta̧ maaté atima nukumó mupa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Téró, Yesuné ama yó matere whi̧rape kisipa mulóló ma duraalu, “Kale Farisi whi̧raperó Herot-tamoné bred o tópuratere o̧la yist-ta mo doropa, wisiyóló kaae tawae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ai fo deremó, ama yó matere whi̧rape atimasisitei duraalu, “I dere fota, da̧né kale bred o bularape kȩyó yóló weimó ai dere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Atimasisitei atéró kȩlaarótu betere fo Yesuné ama tuȩ́ yóló atimapaae duraalu, “Bred o meipóló, dia̧sisitei noatepa fo tiki kȩlaarótu bitu de? Diaao̧ tuȩ́ tiki hapóluraalu, ai yale alarape dia̧né kilitu bitutei, diaao̧ tuȩ́ni airapó. ");
INSERT INTO ppo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Diaao̧ kelenékélé mo kolóo, wosȩ́linékélé mo wosóo yaletei, ya̧lo erale alarape diaao̧ kisipani, ai keterélirapó. ");
INSERT INTO ppo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ya̧lo aporó bred o bula kolokó daalu yóló 5000-whi̧rape atima nalemó su̧tepa, buki daseté kwȩyóló meteró yorape deyaleé?” depa, atimané duraalu, “12 yorape deyóló fa̧analepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ya̧lo me 4000 whi̧rapemó, wȩikeró bred o bularape kolokó daalu yóló melóló, atima nalemó su̧tepa, buki daseté kwȩyóló meteró yorape deyaleé?” depa, “Wȩikeró yorape fa̧analepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ai fo depa, Yesuné atimapaae duraalu, “Ti ai yale alarape fea diaao̧ kolólótei, bete diriyóló tuȩ́ muni airapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Atétu beteró, atima Betsaida bemó sókó walemó, mepaae whi̧rapené beta̧ kele dilikire whi̧ Yesupaae a̧ wolaa yae yaairaalu dapesó walepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Atéró wapa, ai be hulua taaróló, dȩpaae Yesuné kale kele dilikire whi̧ naasemó tawóló felepó. Atéró fóló, kale whi̧né kelemó fesa̧a apuróló, Yesuné ama tikimó naase mulóló duraalu, “Mió naao kelené me o̧lakó wisiyóló kelete?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ai fo depa, kale sekȩ́né ama kele fisa̧ae faróló duraalu, “Whi̧rape kotereteita, ni kaae tokó̧ló só kotapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ti fo depa, kale dere kaae momó Yesuné naasené kale whi̧né kelemó wolaayalemó, ama kele mo ti wisituraalu, o̧la o̧la diriyóló kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Atéró, Yesuné kale whi̧ a̧ ama bepaae fó̧póló dotonótu duraalu, “Ya̧ doasi be huluapaae feni, mo naao bepaaetóró fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Atéró, Yesu a̧ ama yó matere whi̧rapetamo ai be taaróló Sesaria-Filipai be hulua bopéróló tȩ mole be huluarape tua̧mó fu bitu atimapaae woseturaalu, “Mo so whi̧né ȩ-a, depó du bitute?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ai fo depa, atimané a̧paae tokó̧ mótu duraalu, “Mepaae so whi̧néta, ya̧ kale wȩi tópuratere whi̧ Jon-pó. Mepaae so whi̧né duraalu, ya̧ta Elaijapó, mepaae so whi̧né duraalu, ya̧ta, Kótóné ama ko̧ló whi̧pó du beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ai fo depa Yesuné duraalu, “Diaao̧ tuȩ́né-a, ȩ depó du bitu de?” depa, Pitané a̧paae tokó̧ mótu duraalu, “Ya̧ta, so whi̧ fea tȩteróló kaae tanó̧póló, Kótóné sóró beteró betere whi̧ Kerisopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ai fo depa, Yesuné atimapaae duraalu, “Ȩta, Kerisopóló, mepaae so whi̧paae momókó bope yao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ai fo yóló, Yesuné a̧paae eraaire ala atimapaae kaae sóró yó mótu duraalu, “Whi̧né Naalema kae kae sekȩi ala mo saalopó. Mepaae whi̧ disirapenékélé, kale mo so whi̧mó Talepaae momaratere doasi topo whi̧rapenékélé, Moses-né asȩre fo yó matere whi̧rapenékélé ȩta Whi̧né Naalema meipóló, mo ti só deraalopó. Atétepa, mepaae whi̧rapené a̧ mo ti daalotei, be dȩ sore kemetepa, ti a̧ momó kepaayóló betaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu a̧paae eraaire ala amatei ha̧kearóló depa, Pitané a̧ tu dȩpaae dapesó fóló, atei fo ekesé yóló, foné salepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ti fo depatei, Yesu a̧ ama yó matere whi̧rape beterepaae fetée anóló Pita foné sóró duraalu, “Satan-ó, ya̧ ya̧lo sisópaae fae. Naao ai mole tuȩ́ta, ti Kótóné yaaire alamó kisipa muni, mo whi̧né yaaire ala maaté kisipa mutu ai dere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Atéró, ama yó matere whi̧raperó ai betó mole so whi̧ featamopaae a̧ beterepaae ape yóló duraalu, “Dia̧ mepaae so whi̧tamo ȩ sya waai kisipa mutupa, ti naao yaaire ala taaróló, sisópaae mulóló, ya̧ suka̧aire filipaa ni naaotei beleyóló ȩ sya ape. ");
INSERT INTO ppo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Whi̧ me dené ama betere bete me ala yao̧sórópóló, amatei wisiyóló kaae tapa, ti atétere whi̧ a̧ ama betere betetamo turó aluyaalo ai ape. Téretei, whi̧ me de ya̧lo ala eróturaalu, i kale fo wisi erótu betere tua̧mó ama betere bete kemeratepa, ti ai whi̧né betere bete aluni, mo ti muó tawaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mepaae whi̧ de i haemó muó mole wisi wisi o̧la dekéró beta̧paae du betere tua̧mó, ama betere bete mo ti alutepa, ti ai wisirapóló kisipa mute? Mo meipó. ");
INSERT INTO ppo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ama betere bete alutepa, momó saairaalu, noa o̧latamo dupu yaaloé? ");
INSERT INTO ppo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mió i alimó dowi alaró nópu nokole alatamo du betere tua̧mó me whi̧né duraalu, ‘Ya̧ta, Yesu tuȩ́ru, ama ala erótu betere whi̧é?’ yóló wosetepa a̧ witu halemó, ai whi̧ró ama fotamo a̧ tuȩ́nipó depa, a̧paae i fo yaalo ai ape. Kale Whi̧né Naalema Alimané doasi doi mole dȩ wisinaaleró ama mo kae betere ensel-rapetamo wale sukamó folosóró halemó a̧ tuȩ́nipó yale whi̧paae, Whi̧né Naalemanékélé ai whi̧ a̧ tuȩ́nipó yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Téró, Yesuné atimapaae duraalu, “Ya̧lo dia̧paae mo i dere ape. Dia̧ mió i betó mole so whi̧ mepaae sukuni ha̧le betepatei, Kótóné ama tȩteróló betere ao̧mó mole ala mo doasi fotoko̧tamo wapa kelaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Atéró apomiró be dȩ kemetepa, Yesuné Pita, Jems, Jon-sépi atima dape sóró doasi sokore hasi fosópaae holalepó. Atéró horóló beteremó, atimané kele tómótei, Yesuné ama daale tiki taaróló, kae tiki daane walepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Atéturaalu, ama deró betere kutikélé, mo yako kaae dȩ tekée fi deró betepa kelalepó. I haemó betó mole so whi̧né deró betere kuti dȩ kaae aleraai fokotepakélé, ai kutiné dȩ kaae alée fenénipó. ");
INSERT INTO ppo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Téró aimó, atimané keletómó kale Moses-ró Elaijatamokélé mo betere whi̧né tiki kaae daayóló sókó wóló, Yesutamo fo du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Atétere ala kolóló, Pitané Yesupaae duraalu, “Yó matere whi̧-ó, da̧ fea etéró beta̧mó beteretei mo wisirapó. Térapa, me ya̧ betóo, me Moses betóo, me Ilaija betóo, yaaire furu be sore da̧né tȩnaalopa, wisire?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ai fota ha̧le ini, atima wituraalu, yaaire fo ketetepa, ho̧ko fotei erapó. ");
INSERT INTO ppo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Atéró daae molemó, kitikiné atima husura̧le dorowóló, ai kitiki dolomótei fo fakeyóló duraalu, “Ita, ya̧lo mo hosaa mole naalepa, ama dere fo mo wisiyóló wosae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ai fo deretamotóró atimané kele kele yalemó, kale whi̧ tamo daani, Yesu ama wotoró daapa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Atétu beteró, atima ai hasi fosó taaróló durupu bitu, Yesuné atimapaae duraalu, “I yale alarape mepaae so whi̧paae dia̧né mió folo hapale momókó yao̧se. Kale Whi̧né Naalema a̧ dóló mo ti sukunaletei, momó kepaayóló fi tikimó ti yaasepóló, mió hapale bope yao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ama ai yale fo wosóló, atimané mepaae whi̧paae ini, atimasisitei kȩlaaróló duraalu, “Mo ti doló sukunóló momó kepaayóló betaalopó dere fo-a, noa fo betené yalerópó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Atéró, atimané a̧paae woseturaalu, “Kale Moses-né asȩre fo yó matere whi̧rapené Tale waai teópatei, Elaijapi waalopó du betere-a, noa fo betené du bitute?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ai fo depa, Yesuné atimapaae tokó̧ mótu duraalu, “Ti mo dapó. Elaijapi wóló, o̧la o̧la fea ama momó donoróló mulaalopó. Téretei, Kótóné fo asȩre tua̧mó i fo erapó. Whi̧né Naalema, a̧ mo doasi dele su betepa, atimané a̧ faleyóló só deraalopó ere fo-a, metéli yaaireteimó ere? ");
INSERT INTO ppo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Téretei, ya̧lo dia̧paae mo i dere ape. Ilaija a̧ta, mo walepó. Tétepa mepaae so whi̧né kale yóló muló betere fo mo dokonóturaalu, atimané a̧paae mo eranée yale alarape fea motóróti ai erale ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Téró Yesu a̧tamo fele whi̧rape fesaae walemó, mepaae beteróló fele yó matere whi̧rape mo so whi̧né bopéróló daae mupa kelalepó. Aita ha̧le mei, ai whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamo foné u só derótu, i só derótu du betepa, kaae tawóló daae molepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Atétu beteremó, Yesu sókó wapa kilitu, so whi̧ feané doasi sirayóló, a̧tamo hokolaa yóló ko̧leó yaairaalu felepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Téró, Yesuné ama yó matere whi̧rapepaae woseturaalu, “Noa fo betemó dia̧ fo tokó̧tamo du bitu de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ai fo du betepa, ai wóló daae mole so whi̧ kuamó beta̧ whi̧né duraalu, “Yó matere whi̧-ó, ya̧lo naale dowi kepe bituraalu, ama ko̧ló nomunu fo initeretei naao wisiraasepóló, ya̧paae dapesó walepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ti noatepae, dowi kepené haepaae taae deróló haeratepa, ama sereke hatua yósóró ko̧lómó dako sókó wua dapó. Téturaalu, ama hó naase, tikikélé fea sosoro falótua depa, naao yó matere whi̧rapepaae ho̧konaasepé yalemó, atimané ho̧konaaitere su̧nipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ai fo depa Yesuné atimapaae duraalu, “Mió i alimó tuȩ́ tiki tiréni ho̧ko betó mole so whi̧rape-ó, dia̧ tuȩ́ tiki tiró̧póló meteró sukamó ȩ dia̧tamo betaaloé? Diaao̧ hapólure kisipa taaróló, wisi kisipa só̧póló ȩ dia̧tamo meteró sukamó betaaloé? Térapa, ai naale ȩpaae dapesó ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ai fo depa kale naale a̧ beterepaae dapesó walemó, dowi kepené Yesu kilituraalu, téti kale naale mo fotoko̧iné tao sóró feseróló haemó haeratepa biliraté feletikimó, ko̧lómó dako sókó walepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Atétere ala kolóló, Yesuné kale naalené alimapaae woseturaalu, “Naao naale ai ala du betepa, ba fo meteró kemeyaleé?” depa alimané duraalu, “Mo ketemó kaae sóró deté waletei, miókélé ha̧le ai yó tare ape. ");
INSERT INTO ppo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ya̧lo naale doló sukunaairaalu, ai dowi kepené sipaaekélé ó wȩipaaekélé, tao sóró taae falatua yalepó. Térapa, naao da̧mo ko̧leturaalu su̧mó tao senépa ti tao saasepólópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ai fo depa, Yesuné a̧paae duraalu, “Naao ȩpaae su̧mó tao saaloé? dere-a, mepaae whi̧ dené Talepaae tuȩ́ tiki tiratepa, ti ai whi̧paae fea ala fea Talené ama su̧mó eranérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ai fo depa kale naale alimané ama ere ala ha̧kearóló duraalu, “Ya̧lo tuȩ́ tiki tiró betepatei doa meipa, me kwiapaae ha̧lekeretei naao ȩ tao saasepé,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu a̧ ai ala du beterepaae so whi̧ fea sururu yóló wapa kolóló, dowi kepe foné sóró duraalu, “Whi̧né ko̧lóró wosȩ́litamo kinó betere dowi kepe-ó, ya̧ ai whi̧ tua̧mó beteretei, ya̧lo i ho̧konatapa, momó kae biti̧ weni, mo ti fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yesuné ai fo deremó, kale naalené tiki tao sóró feseróló kale dowi kepe keterȩ́tamo sókó felepó. Atépa, kale naalené tiki mo suki̧ whi̧ ao̧pa, kolóló so whi̧ feané duraalu, “A̧ mo ti ai suka̧le ape,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Atépa, Yesuné kale naale naasemó tao salemó turukó horóló daane holalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Atétu beteró, nalo Yesu a̧ be dolopaae doropóló betepa, ama yó matere whi̧rape atimanalemaaté bitu a̧paae duraalu, “I dowi keperape da̧né doló ho̧konatepa, sókó fenitere-a, noatepa dérópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ai fo depa, ama atimapaae duraalu, “Moma dere alané beta̧ atei kaae dowi keperape su̧mó ho̧konanérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Téró atima ai be taaróló, Kaleli hae tua̧mó tȩyóló felepó. Ti atéró feleteita, Yesuné ama yó matere whi̧rapepaae maaté kale fo wisi yó melaai kisipa mutu, mo so whi̧né atima betere tiki tuȩ́ yao̧sóró yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Atima atéró fóló bitu, ama atimapaae duraalu, “Ha̧le mo whi̧né kale Whi̧né Naalema dó̧póló, whi̧ mené eleké deyaalopó. Atéró, mo ti dóló sukunaalotei, sore be dȩ kemetepa, ti a̧ momó kepaayóló betaalo ai ape,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ama atéró yale fo bete atima tuȩ́nitepa, noa betené yalerópóló, wosaai yaletei, atima wituraalu, taaralepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Téró, atima Kapeneam bepaae fóló, atima fiyaaire bemó bitu, ama yó matere whi̧rapepaae woseturaalu, “Dia̧ tu̧ tua̧mó alale siré wou betale-a, noa fokó deté wou betaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yesuné ai fo depa tu̧mó wou bituraalu, topo whi̧-a de betere yóló atimasisi alale siré waleteiné haletu, Yesupaae tokó̧ matere fokélé inipó. ");
INSERT INTO ppo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Téró Yesu a̧ biti̧ deyóló ama yó matere 12 whi̧rape a̧ beterepaae ape yóló duraalu, “Whi̧ me detamo topo whi̧ betaai kisipa mutupa, ti belei ao̧yóló so whi̧ feané kutó diratere whi̧ betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Atéró, ama beta̧ naale beleka̧amale dape sóró atima tua̧mó daalóló, ama apuó taru duraalu, ");
INSERT INTO ppo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mepaae whi̧ denétamo ya̧lo doimó etei kaae naale mo wisiyóló dape supata, ti ȩtei mo wisiyóló dape sirapó. Atétere whi̧né ȩmaaté dape sumitei, ȩ dotȩyale sekȩ́kélé dape sirapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Téró, Jon-né Yesupaae duraalu, “Yó matere whi̧-ó, whi̧ beta̧né naao doimó dowi kepe ho̧kutu betepa, a̧ta da̧tamo beta̧mó kotere whi̧ meipóló, da̧né seséyalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ai fo depa Yesuné atimapaae duraalu, “Atei kaae whi̧né ama yaaire ala yó̧póló sesékese. Ti noatepae, mepaae whi̧né ya̧lo doimó mepaae kelemei ala erale ki̧lipaaemo, ya̧lo doi doróló faleyaalo meipó. ");
INSERT INTO ppo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mepaae da̧tamo bóe dini dere whi̧rapeta, ti da̧tamo mole whi̧ ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ya̧lo dia̧paae mo i dere ape. Dia̧ Keriso whi̧ bitu, ya̧lo ala erótu beteremó, mepaae whi̧né wȩi melatepa, atétere whi̧ dupu ha̧sókó feni, mo saalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mepaae whi̧ denétamo ȩpaae tuȩ́ tiki tiró betere doi muni, sókótei sókó dei so whi̧ dowi ala yó̧póló dée nalatepa, atétere whi̧ mo doasi dowi dupu saalo ai ape. Atei ala dere whi̧ ama depamó mené doasi kane fake dulóló wȩi kȩlapaae taae falua̧sóró wisi ua̧pó. ");
INSERT INTO ppo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Naao naasenétamo ya̧ dowi ala yó̧póló dée nalatepa, atétere naase tukóló taae falae. Ya̧ beta̧ naasetamo bituraalu, mo ti betaaire tikipaae sókó faasepólópó. Naase tamo daayóló betera̧letikimó, me naasené naao tiki turó doasi surukó̧kélé feni, ha̧le dó tare sipaae a̧lisóró fao̧sóró dapó. ");
INSERT INTO ppo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Naao hóné ya̧ dowi ala yó̧póló dée nalatepa, atétere hó tukóló taae falae. Ya̧ beta̧ hótamo bituraalu, mo ti betaaire tikipaae sókó faasepóló dapó. Ti noatepae, ya̧ hó tamo daayóló betera̧letikimó, me hóné naao tiki turó si duku beterepaae a̧lisóró fao̧sóró dapó. ");
INSERT INTO ppo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Naao kelené ya̧ dowi ala yó̧póló dée nalatepa, ti atétere kele sokóló taae falae. Beta̧ keletamo bituraalu, ya̧ mo ti betaaire tikipaae sókó faasepólópó. Ti noatepae, naao kele tamo wusuró buóló betepa, naao tiki turó ha̧le dó tare sipaae fao̧sóró dapó. Ti Kótóné tȩteróló kaae tare tikimó mole alata, beta̧ keletóró daayóló bituraalu, sene fupa mo wisirapó. ");
INSERT INTO ppo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ti dowi dele su betaaire tikimó kisipa mutu, asȩmó i fo erapó. Aimó betere whi̧rapeta, mokené turukóló nokoletei mo kemekélé ini yóo, sikélé surukó̧ feni ha̧le dótóró tawóo yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Na ó hupu mi kȩlaayao̧sóró kó terepetu dere kaae, so whi̧ fea tua̧mó mole dore alaró wisire alatamo sinétei biliyóló taleyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ti kóta, o̧la feléróló nokole o̧la wisipó. Téretei, kale kóné felé kemetepa, momó kae noayóló felé bulaaloé? Mo meipó. Térapa, ai kó wisinaale diaao̧ hosaa tua̧mó mulóló, so whi̧tamo hosaa muni deyóló wisi kisipatamo mo dua betó muae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Téró, Yesu a̧ ai be taaróló Judia hae kwia tua̧mó kutu beteró Jordan wȩi uté fakerókélé felepó. Aimó sókó felemó, so whi̧ mo fea kale duatere kaae toura̧le wóló betó mupa, ama dua dere alatóró yóló yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Atétu betepa, mepaae Farisi whi̧rape wóló, a̧ su̧sóró a̧paae woseturaalu, “Mepaae whi̧né ama soma tokó̧ fatepa fo mulepé meié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ai fo depa ama atimapaae tokó̧ mótu duraalu, “Diaao̧ dosa̧ayóló tuȩ́ yó̧póló, Moses-né dia̧paae noa ala yae yóló, asȩre?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ti fo depa atimané a̧paae tokó̧ mótu duraalu, “Mepaae whi̧né so tokó̧ falaai depa, ti soné asȩ sóró fó̧póló melae yóló Moses-né asȩrapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ai fo depa Yesuné atimapaae duraalu, “Ti aita, diaao̧ hosaa ta̧ruraalu dowa̧ae fu betepa, Moses-né ai fo asȩyóló muló beterapó. ");
INSERT INTO ppo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Téretei mo take kaarale alimó, ‘Kótóné whi̧ró sotamo alipakalepó.’ ");
INSERT INTO ppo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Atéyale betené whi̧né ama hamaró alimatamo taaróló, sotamo dokóló atimaamo mo beta̧ tikitóró daayaalopó.’ ");
INSERT INTO ppo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Atéreteiné atimaamo tamo mei, mo beta̧ tikitóróti ai daale ape. ");
INSERT INTO ppo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kótóné atimaamo atéró beta̧ tiki daaróló beteró betereteimó, mo so whi̧né tekeróló whi̧ kae beteróo, so kae beteróo, yao̧sóró yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ai fo yóló Yesu a̧ ama yó matere whi̧rape atima fea bemó betó mulu, Yesupaae woseturaalu, “Naao ti yale fo da̧kélé kisipa yaai dapa, bete mo ti ha̧kearóló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ai fo depa ama atimapaae duraalu, “Whi̧ me dené ama topo so tokó̧ daalóló so me dokotepa, ai whi̧né Kótóné fo tukóló topo sotamo betere ala mo ti doratapó. ");
INSERT INTO ppo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Atétere kaae sonékélé, oma whi̧ tokó̧ daalóló, whi̧ metamo dokotepa, atétere soné Kótóné fotei tukóló, ama omatamo betere ala mo ti doratapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Téró etéyalepó. So whi̧né kale keteirape Yesuné wolaa yó̧póló, a̧ beterepaae dapesó wua yalepó. Atétepa, ama yó matere whi̧rapené kale so whi̧ foné sóró sesétu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesuné atétere ala kolóló, ama yó matere whi̧rapetamo fopaae buóló duraalu, “Ai naale senaale ȩ beterepaae wó̧pólópa sesékese. Ti noatepae, atei naale senaale kaae betere so whi̧ta, ti Kótóné tȩteróló betere ao̧mó sókó fóló beterapó. ");
INSERT INTO ppo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","16","So whi̧ i naale senaale kaae ao̧yóló bitinitepa, ti Kótóné tȩteróló betere ao̧mó sókó fenénipó,” yalepó. Ai fo yóló, Yesuné kale naale senaale doko̧ apuósu yóló, naase mulóló atima wisiratere fo dua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Téró etéyalepó. Yesu a̧ ama kisipa mole tikipaae faai fu betalemó, whi̧ beta̧ sururu yóló wóló, Yesu daalemó bukutiri tea̧ró bitu, a̧paae duraalu, “Yó matere whi̧ wisi-ó, ȩ mo ti betó tawaairaalu, noa alakó yaaloé?” yóló wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ti fo depa, ama kale whi̧paae duraalu, “Naao ȩpaae noatepa whi̧ wisi-ó fo du de? Whi̧ beta̧kókélé wisi whi̧ bitini, Kótó a̧ beta̧ mo wisirapó. ");
INSERT INTO ppo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ti Kótóné yae yóló muló betere alarape i ape. ‘Whi̧ dao̧se, so nópu nao̧se, o̧lémi nao̧se, kapala fo yóló me whi̧ só derao̧se, me whi̧ dilikó̧ló o̧la o̧la o̧lémi sao̧se. Naao hae aya wisi doi muló̧póló, atimaamo ao̧mó bitu, wisi ala beta̧ erótu betae yóló, ere fo fea ti naao ai tuȩ́re ape,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ai fo depa kale whi̧né a̧paae duraalu, “Yó matere whi̧-ó, ai alarape feata, ȩ mo naale beleka̧amalemó bitutei deté wóló, miókélé ha̧le yó tarapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ai fo depa Yesuné kale whi̧ yaala sókó fóló kelené a̧ kaae taru duraalu, “Mo beta̧ ala beta̧ ya̧ mei ai ere ape. Térapa ya̧ fóló, naao mole o̧la o̧la fea dotonóló moni sae. Atéró sere moni ti o̧la o̧la meiyóló yolealere so whi̧mó a̧liróló melae. Atéró melóló ya̧ta, ti ó hepen bemó taleróló muló betere wisi wisi o̧la saasepóló da̧mo faalopa ȩ sya ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ai fo depa, kale sekȩ́ a̧ fea o̧la o̧la mole néli whi̧ ereteiné, ama kelepaa humula yóló fomoné sukuté felepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Téró Yesuné ama yó matere whi̧rape kaae taru duraalu, “Doasi néli whi̧rape Kótóné tȩteróló betere ao̧mó sókó faairetei mo doasi hapólurapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ama yó matere whi̧rapené ai dere fo woseturaalu, atima siratu betalepó. Tétepa, ama atimapaae momó duraalu, “Ti naalerape-ó, Kótóné tȩteróló betere tikimó sókó faairetei, béni mo doasi hapólurapó. ");
INSERT INTO ppo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Doasi kamel hupu kuti nomotere ketȩ́li dolomó sókó fenénipó. Atére kaae, fea o̧la o̧la tare néli whi̧ Kótóné tȩteróló betere ao̧mó sókó faairetei mo doasi hapólurapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesuné ai fo deremó, ama yó matere whi̧rape atimasisitei doasi sirayóló duraalu, “Atéró hapólupa, ti noa kaae so whi̧mo mo ti aluyao̧sóró tao saaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ti fo depa, Yesuné atima kaae taru duraalu, “Mo whi̧né atei kaae ala fea su̧mó enénipó. Mo whi̧ ere kaae Kótó a̧ aténi, fea ala fea ama mo su̧mó eranérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ai fo depa, Pitané a̧paae duraalu, “Da̧ ya̧tamo kwȩyaairaalu, da̧né o̧la o̧la fea mo ti taaróló i wale ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ai fo depa, Yesuné atimapaae duraalu, “Ya̧lo dia̧paae mo i dere ape. Whi̧ me detamo ya̧lo ala eróturaalu, kale fo wisi yó maté kwȩyaai, ama be ó no nemarape ó hama alima ó naalemarape ó hae tiki fea taaróló wapa, ti atétere whi̧mó i ala eraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ama beta̧ o̧la taaróló walemótei, nomarapekélé kutórape, nemarapekélé, hamarapekélé, alimarapekélé, naalemarapekélé, berapekélé 100 tómó beleróló saalo ai ape. Téturaalu, dowi susupui alakélé saalotei, nalo waaire alimó mo ti betó tawaaire bete saalopó. ");
INSERT INTO ppo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Téyaalotei, mió i alimó mepaae doasi doi mole whi̧rape take nalo doi munire whi̧ kaae betaalopó. Mió mepaae doasi doi muni, sókó deyóló betere so whi̧ta, take nalo mo doasi doi mole topo whi̧ kaae betaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Atéró, atima Jerusalem bepaae furaalu, Yesu a̧pi fi tikimó, ama yó matere whi̧rape nalo haió! yóló sira deté fu betalepó. Tétepa, mepaae atima sya wou betere so whi̧kélé wiyalepó. Atéró, Yesuné ama yó matere 12 whi̧rape tu̧ dȩpaae dapesó fóló daae mulu, a̧paae eraaire ala fea atimapaae momó yó melalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Atéró, atimapaae duraalu, “Mió da̧ Jerusalem bepaae i fole ape. Téteretei, kale Whi̧né Naalema me whi̧né eleké deyóló mo so whi̧mó Talepaae momaratere whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamoné naase tua̧mó mulaalopó. Téró fo tokó̧ló só deróló, Juda mei kae fakené a̧ dó̧póló, melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Atéró, atimané a̧ faletere alakélé, fesa̧a apuratere alakélé, halika tikiné fokosó sere alakélé, faleyóló haleratere alakélé erótu beteró, nalo atimané a̧ mo ti sukó̧póló daalopó. Téyaalotei, be dȩ soremó dou dolomó muóló a̧ momó kepaayóló betaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Téró, kale Sebedi naalema tamo Jems-ró Jon-tamo Yesu beterepaae wóló duraalu, “Yó matere whi̧-ó, da̧moné ya̧paae wosetere ala naao eraaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ai fo depa, Yesuné atimaamopaae duraalu, “Ya̧lo diaamomó noa alakó eraró de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tétepa, atimaamoné a̧paae duraalu, “Take naao mo kae ere dȩ wisinaale ha̧kearatere sukamó da̧mo me whi̧kó naao turu naase dȩmó beteróo, me whi̧ fȩ́ naase dȩmó beteróo, yaasepóló dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ti fo depa, Yesuné kale whi̧ tamopaae duraalu, “Diaamoné ȩpaae ai wosale fota, Talené tȩteróló kaae tare tikimó ere ala diaamo tuȩ́ni keteruraalu dapó. Dowi ala kwia tokó̧ló aluraai susupu sóró sinaaitere ala, diaamonékélé su̧mó senére? Ó ȩ wȩi tópuratere kaae, diaamokélé tópuró̧póló kisipa mute?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","40","Ai fo depa, atimaamoné duraalu, “Da̧mokélé ai ala su̧mó enérapó,” yalepó. Ai fo depa, Yesuné atimaamopaae duraalu, “Ya̧lo tikimó doasi susupu sóró sinaaire alaró ȩ wȩi tópuraaitere alatamo diaamopaaekélé su̧mó eraalotei, turu naase ó fȩ́ naase dȩmó beteraaire alata, ti ya̧lo tȩteróló kaae tanipó. Ai alata, ya̧lo Ayané ama tȩteróló kaae taru, aimó betaaire whi̧ tamokélé, ama mo taketitei tukóló beteró beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tétepa, mepaae ama yó matere naase tamo whi̧rapené ai fo woseturaalu, Jon-ró noma Jems-tamopaae doakale fopaae bualepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Atétepa, Yesuné atimapaae toura̧le ape yóló duraalu, “Juda mei kaae fake tȩteróló kaae tare topo whi̧rapené mo so whi̧ tȩteróló kaae tawóo, atimané sóró beteró betere whi̧rapenékélé mo so whi̧ tȩteróló kaae taru, i ala erae du beteretei diaao̧ ai kisipare ape. ");
INSERT INTO ppo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Atétere kaae, dia̧ tua̧mókélé ai ala momókó yao̧se. Dia̧ tua̧mótamo beta̧ whi̧kó doasi topo whi̧ betaai kisipa mutepa, ti so whi̧ feané kutó diratere whi̧ betenérapó. ");
INSERT INTO ppo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Whi̧ me de doasi doi mole topo whi̧ betaai depa, ti dia̧né wae sóró kutó diratere whi̧ kaae betae. ");
INSERT INTO ppo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ti noatepae, kale Whi̧né Naalema waleteita, a̧ topo whi̧ bitu mepaae whi̧rapepaae ama kutó dirae yaairaalu wéni, a̧ mo so whi̧né kutó diratere whi̧ bitu, atima aluyao̧sóró ama betere bete ha̧le melóló, dupuraai walepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Atéró atima Jeriko bepaae walepó. Atéró, nalo ama yó matere whi̧raperó mo so whi̧ featamo ai doasi be taaróló fu betalemó, beta̧ kele dilikere whi̧ Timeus naalema Batimeus tu̧ dȩmó bituraalu, monikó a̧lae yóló kematu du beterepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Atétua dere whi̧ a̧ tu̧ dȩmó beteremó, kale Nasaret whi̧kó Yesu walapó dere fo wosóló, fo fakeyóló duraalu, “Depit-né deté fele whi̧né Naalema Yesu-ó, ȩ ko̧lené sukuturaalu, tao sae,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ai fo du betepa, mepaae so whi̧né taalae yóló, foné salepó. Tétepatei, kale whi̧né woseni nisiyóló, fo mo ti fakeyóló duraalu, “Depit-né deté fele whi̧né Naalema Yesu-ó, naao ȩ ko̧lené sukuturaalu, tao sumié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ai fo deremó, Yesu a̧ kei̧yóló daalu, “A̧paae ape yae,” yalepó. Tétepa, kale whi̧rapené kale kele dilikire whi̧paae duraalu, “Mió ya̧paae ape dapa, whaaliani, hai̧tamo turukó horóló fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tétepa, kale whi̧né ama bukóló betere kuti da̧ae faróló, a̧ Yesu beterepaae hapale tu̧wó felepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Atéró daapa, Yesuné a̧paae duraalu, “Ya̧lo ya̧mó noa alakó eraró de?” yalepó. Ai fo depa, kale kele dilikire whi̧né duraalu, “Yó matere whi̧-ó, ya̧lo kelené o̧la o̧la kelenée du beterapa, naao wisiraasepé,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ti fo depa, Yesuné a̧paae duraalu, “Naao tuȩ́ tiki tiratere alané ya̧ wisiralepa dua fae,” yalepó. Ai fo deretamotóró kale whi̧né ama kele wisitepa, Yesu sya felepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Atéró atima Jerusalem be huluapaae felekemó sókó faairaalu, Olip du sorokó mole ao̧mó tȩne Betpas beró Betani betamomó sókó felepó. Aimó Yesuné ama yó matere whi̧rapekó tamo whi̧ dotonaai duraalu, ");
INSERT INTO ppo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Diaamo fole be huluamó sókó fenalemó, whi̧ betóló konire utu̧ donki hupu duló betepa kelaalo ai ape. Térapa, ai hupu taayóló ipaae dapesó ape. ");
INSERT INTO ppo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Atéró taanalemó me whi̧né duraalu, ‘Ai hupu neaai só fute?’ depa, a̧paae i fo yae. ‘Momó hapale sóró waaitei, Talené ama me kutó diyaai, kapala asiri sene fae yale tikimó sóró fulapó,’ yae,” yóló dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Atétepa atimaamo fóló kelalemó, be bela tu̧ dȩmó tȩne be tu̧ sókó walemó, kale bopeyale hupu duló beterepó. Atépa, kale hupu taatu betalemó mepaae aimó daae mole so whi̧né atimaamopaae duraalu, “Diaamoné ai hupu neyaai taatu de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ai fo depa Yesuné atimaamopaae yae yale fotóró yalemó, atimané “Wisirapa sóró fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Atéró, kale hupu dape sóró Yesu beteremó sókó felemó, ama yó matere whi̧rapené deró betere kuti sókósu yóló, ai kale donki hupuné sisó tómó whamenatepa Yesu a̧ biti̧ holalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Atéró betóló fupa, mo turó so whi̧né atima kuti sorokóló tu̧mó whamenaté fóo, mepaae so whi̧né sapo da̧a ó wolou da̧arape turukóló whamenaté fóo, deté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yesu a̧ tua̧mó fupa, mepaae so whi̧ folosóró fóo, mepaae so whi̧ nalo wóo du bitu fo fakeyóló duraalu, “Hosana! Talené doimó wale whi̧ wisinaale-ó! Talené ya̧ mo wisiró beterapó. ");
INSERT INTO ppo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mo take da̧né ayarape deté wale whi̧ Depit-né tȩteróló kaae tawale ala mió da̧ tua̧mókélé sókó walapó. Térapa, Talené ya̧ wisiró̧póló yae! Hosana, ama doi doasi ó sikipaae sóró horó̧póló, yae!” deté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Téró Yesu a̧ Jerusalem bepaae sókó fóló, momatere be dolopaae felepó. Atéró, ai be dolomó muó mole o̧la o̧la fea kelené doko̧ du betalepó. Atétu betalemó, be dikitepa ama yó matere 12 whi̧rape atima fea Betani bepaae felepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Atéró fiyóló be dȩtepa, hi̧ka ai Betani be taaróló fu betalemó, tu̧ tua̧mó Yesu a̧ wote yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Atétepa, a̧ tu̧mó fu bitu kese falalemó beta̧ nose mo umó daapa kelalepó. Atépa betepaae fóló, dukó olerémóló kelalemó, oleni ha̧le sókumaaté erepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Atépa kale nipaae duraalu, “Me sukamó wouraalu whi̧ beta̧nékélé naao du momó kae tokóló naalomeipó,” depa ama yó matere whi̧rapené wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Atéró, atima momó Jerusalem bepaae sókó wóló bituraalu, kale momatere be dolopaae fóló kelalemó, whi̧rape ai be dolomó o̧la o̧la dotonóló dupu du betepa ho̧kó faralepó. Atéró, be kaepaae wale whi̧rape atimané moni ai be talené monitamo duputamo du betere ni fakeraperó ba ho̧kósere beleróló dotonótu betere fo̧loi ni fakerapetamo fesekeyóló taae faralepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Téró, mepaae whi̧né momatere be tua̧ dolomótei dotonaaire o̧la o̧la beleyóló sóró fua wua du betepa, Yesuné ama seséyóló kaae sóró ho̧konalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Atéró ama atimapaae yó mótu duraalu, “I asȩyóló muló betere fo diaao̧ dosa̧ayóló tuȩ́ munié? ‘Ya̧lo beta, i hae kwia feamó betó mole kae kae tiki daae mole so whi̧né Talepaae beta̧ moma yó̧póló tȩnó betere bepó, erapó.’ Ai fo epatei, diaao̧ du betere alané o̧lémi nokole whi̧rape touróló betere be ao̧rótu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yesuné atéró yó mótu betere fo mo so whi̧né wosóló siratu betere ala, mo so whi̧mó Talepaae momaratere topo whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamoné wosóló atima dei kisipa muturaalu, Yesu daaire tu̧ kikitu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Atétu beteró be dikitepa, atima ai doasi be hulua taaróló felepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Atéró, atima mo hi̧kati tu̧mó fu bituraalu kelalemó, kale ni nose betekélé mo turó sélipa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Atépa, Yesuné take kale yale fo Pitané tuȩ́ muni wapa a̧paae duraalu, “Yó matere whi̧-ó, naao foné dorale ni nose ai sélirapa kelere!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ti fo depa Yesuné a̧paae duraalu, “Kótópaae tuȩ́ tiki tiróló betae. ");
INSERT INTO ppo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ya̧lo dia̧paae mo i dere ape. Mepaae whi̧ de kisipa tamo muni, Talepaae tuȩ́ tiki tiróló i ulupaae ya̧ ai daale tiki taaróló wȩi kȩla tómó daane derepae depa, mo téyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Térapa, ya̧lo dia̧paae i dere fo wosae. Dia̧né moma duraalu me noa o̧lakó wosetepa, ti ai wosetere o̧la naao mo serapóló tuȩ́ tiki tiratepa, ti diaao̧ mo saalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Dia̧né moma duraalu, hepen bemó betere Aya Kótóné diaao̧ yale dowi ala kwia ha̧le kemeró̧póló, mené dia̧paae me dowi ala erélipa, ti a̧paaemo kwia tokó̧ melaai dapóló tao tani, me o̧la meipóló kisipa keterae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Téró atima momó Jerusalem bepaae wóló bituraalu, a̧ momatere be tipiné bopéró daaló betere tua̧mó kutu betalemó, mo so whi̧mó Talepaae momaratere topo whi̧rapekélé, Moses-né asȩre fo yó matere whi̧rapekélé, mepaae whi̧ disirapekélé, fea a̧ beterepaae walepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Atéró wóló a̧paae woseturaalu, “Ai alarape du beteró̧póló ya̧ né sóró beteraleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ai fo depa Yesuné atimapaae tokó̧ mótu duraalu, “Ya̧lokélé dia̧paae beta̧ wosetere fo yaalopó. Ya̧lo wosetere fotamo diaao̧ ȩpaae tokó̧ matepa, ti diaao̧ wosetere fokélé ya̧lo tokó̧ melaalopó. ");
INSERT INTO ppo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ti take Jon-né so whi̧ wȩi tópurale ala, momó kaayóló waleé? Ó hepen bemó betere Talené yae depa yalepé, mo whi̧né yae depa yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ai fo depa, kale whi̧rape atimasisitei fo kȩlaaróló duraalu, “Da̧né hepen bemó Talené yae depa yalepó enalemó, ti da̧paae ama dere fo wosóló a̧paae tuȩ́ tiki tirénitere noatepae? yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Atéyao̧sóró, mo whi̧né yae depa yalepó fo ua̧tei, Jon a̧ Kótóné fo eratere ko̧ló whi̧póló so whi̧ feané kisipareteiné atima kapo duné da̧ siróló dao̧sóró ai fo yaalo meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Atétepa atimané Yesupaae duraalu, “Da̧ tuȩ́nipó,” yalepó. Ti fo depa ama atimapaae duraalu, “Mené ȩpaae i alarape yae depa dapóló, ya̧lokélé dia̧paae yó melaalomeipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Téró, Yesuné ama kale fo sale forape momó kaae sóró yó melótu duraalu, “Whi̧ beta̧né wain képi wae biliyaai kutó diyóló tipi bopé yalepó. Atéró, kale képi du u̧lumétepa tokóló fȩ dowa̧aire tiki kaponétei aleyóló mulalepó. Atéró kemetepa, kutó kaae tawóló betaaire be mo sikimó deróló tȩalepó. Téró ai kutó tale a̧ me bepaae faai kutó kaae tawó̧póló, mepaae whi̧rape sóró beteróló duraalu, o̧la u̧lumétepa sere sukamó da̧ bukaalopa, kutó wisiyóló kaae tawae yóló a̧ felepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Atéró fóló bitu, ama biliale képi du u̧lumétepa sere alimó bukóló, ama saaire su̧ ti ama kutó diratere whi̧ beta̧né sene fó̧póló, kale kutó kaae tare whi̧rape beterepaae dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Atéró dotonalemó, atimané a̧ tawóló fokosoi ala du beteró me o̧lakélé menéni, ha̧le fó̧póló dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tétepa, kale whi̧né ama me kutó diratere whi̧mo dotonalemó, ai whi̧kélé kale dere kaae topomó kapóró dóló haleróló faralepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Atétepa kale dere kaae, me whi̧mo dotonalemó ai whi̧kélé mo ti dalepó. Tétepa, mepaae whi̧rape mo dekéró dotonótua yalepó. Téyalemó, mepaae whi̧rape dóló ha̧le susupuróo, mepaae whi̧rape mo ti dóló sukunóo dua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Whi̧rape fea atétu beteró kemeróturaalu, ama hosaa mole naale beta̧ biti̧ felepó. Ai naale dotonaai duraalu, mió atima ya̧lo i naale ao̧mó bituraalu, a̧paae mo wisi ala beta̧ eraalopóló kisipa mutu dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Téyaletei, kale naale wale kilitu, kale kutó kaae tare whi̧rape atimasisi duraalu, ‘I kutó tale sukutepa a̧ betale sirimó betaaire whi̧ ai wale ape. Tétu ai kutó ama sao̧sóró da̧ saairaalu, a̧ daalopa siépe,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Atéró, atimané kale sekȩ́kélé mo ti dóló sukunóló, ai kutó tipi ao̧paae taae deralepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Atétepa, ai kutó talené ama noa ala yaaloé? Kale kutó tale a̧ wouraalu ai kutó kaae tare whi̧rape fea mo ti dóló aluraalopó. Atéró ai kutó kaae tawó̧póló, mepaae whi̧rape sóró beteraalopó. ");
INSERT INTO ppo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ti i asȩyóló muló betere fo diaao̧ dosa̧ayóló tuȩ́ munié? ‘Kale be tȩtere whi̧rapené dopa taae farale kapo faketei, doasi be hulua deyaaire eleké wisinaale alée felepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ai ere ala wisinaale da̧né kilituraalu, Talené eró beterapóló dukiróló siratu beterapó,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesuné ai yale fo sale beteta, Juda topo whi̧rape atima só deratapóló kisipa mutu, a̧ daaire tu̧ kikitu betalepó. Aimó a̧ tawaai yalemó, ai touró betere so whi̧né atimapaae me ala erao̧sóró witepa taaróló felepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Atéró, nalo mepaae Farisi whi̧raperó Herot-né ama kisipa mole ala erótu betere whi̧rapetamo Yesuné dere fo bete wosóló a̧ só deraairaalu, kaae tawóló beteró̧póló dotonale whi̧rape walepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Atima wóló Yesupaae duraalu, “Yó matere whi̧-ó, ya̧ta mo fomaaté dere whi̧ beteretei da̧né tuȩ́rapó. Téruraalu, doasi doi mole so whi̧ró wisi so whi̧tamo maaté tao sóró wisi ala eróturaalu, mepaae belei sókó deyóló betó mole so whi̧ taalatimipó. Téni, kale mo fo bete sya furaalu, Kótóné ama ere ala i ape yóló yó mótu beteretei da̧né kisiparapó. Térapa, da̧né topo whi̧ Sisapaae takis moni matere ala wisirépé dore? ");
INSERT INTO ppo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Naao kisipané melarópé melao̧seróe?” yalepó. Ti fo depa, Yesuné tiki tua̧paae dorutei tó tikiné wisire nisi du betere whi̧rapené kapala dilikitu betere ala bete ama tuȩ́patei duraalu, “Dia̧né ȩ dó̧póló só deraai noatepa dilikitu bitu de? Ti ai denarias moni ya̧lo kelaalopa ipaae sóró ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tétepa, atimané kale denarias moni koló̧póló sóró wóló matepa, atimapaae woseturaalu, “I ere asȩró mole asotamo-a, né?” yóló wosetepa, atimané a̧paae duraalu, “Aita Sisané asȩró asotamopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ai fo depa Yesuné atimapaae duraalu, “Sisané o̧lata, ti Sisapaae melae. Kótóné o̧la o̧la ti Kótópaae melae,” yalepó. Ama ai dere fo woseturaalu, atimané haió! yóló siratu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Atéyale ki̧lipaae etéyalepó. Sukutere so whi̧ momó kae kepaayaalomei, mo ti alutapó du betere Sadyusi whi̧rape Yesu beterepaae wóló i fo wosalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Yó matere whi̧-ó, Moses-né i fo asȩyóló muló beterapó. ‘Mepaae whi̧né so dokaletei naale dini ha̧le beteró sukutepa, ti nomanémo ai so wulia dokóló naale detepa, ti suka̧le whi̧ sirimó bituraalu, ama o̧la o̧la tȩteróló kaae tanó̧póló yae,’ fo erapó. ");
INSERT INTO ppo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Take wȩikeró nomarape beterepó. Atéró kale topo whi̧ so dokaletei, naale senaalekélé dini ha̧le suka̧lepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Atéró sukutepa, ai so wulia noma me whi̧némo dokalepó. Téyalemó, ai whi̧kélé naale dini ha̧le suka̧lepó. Atétepa, noma me whi̧némo dokalepó. Téyalemó, ai whi̧ a̧kélé ha̧le suka̧lepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Atétepa, kale so wulia wȩikeró nomarapené dokoté waletei, kale wȩikeró whi̧rape fea naale beta̧kélé dinipó. Téró nalo kemeróturaalu, kale sokélé suka̧lepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Atéyale so take kepaayóló wale sukamó, mé whi̧né a̧ dokaaloé? Ti noatepae, beta̧ sotei take nomarape feané dokoté waleteinépó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ai fo depa Yesuné atimapaae duraalu, “Kótóné asȩyóló muló betere foró ama fotoko̧tamo wisiyóló tuȩ́ munireteiné dia̧ fea kó̧paae falapó. ");
INSERT INTO ppo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ti suka̧le so whi̧ momó kepaayóló betere sukamó, so dokotere ala yaalomeipó. Sokélé, whi̧tamo dokotere ala mo yaalo meipó. Hepen bemó betere ensel-rape ere kaae, ha̧letóró betó tawaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Suka̧le whi̧ momó kepaayóló betaalopóló, Moses-né asȩyóló muló beteretei, diaao̧ dosa̧ayóló tuȩ́ muni airapó. Hasi fosómó ni sesaape dolomó Kótóné Moses-paae duraalu, ‘Ȩta Abraham, Aisak, Jekop-sépi, tȩteróló kaae tare Kótó i betere ape,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ti a̧ta, mo take sukó̧ló aluyale so whi̧ tȩteróló kaae tare Kótó mei, mió i alimó betó mole so whi̧kélé tȩteróló kaae tare Kótópó, erapó. Atépatei dia̧ tuȩ́niru, ho̧ko fo du beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Atéró, Sadyusi whi̧rapené Yesupaae wosetere fo fea ama wisiyóló tokó̧ mótu betepa, Moses-né asȩre fo yó matere whi̧rapekó beta̧né Yesupaae woseturaalu, “Kótóné yae yóló muló betere forape tua̧mó mo doasi bete mole fo-a, mée?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ti fo depa Yesuné duraalu, “Mo doasi bete mole topo fo i ape. ‘Israel fake so whi̧-ó, wosae! Da̧ tȩteróló kaae tare Tale Kótóta me kae bitini, mo beta̧tóró beterapó. ");
INSERT INTO ppo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Térapa, Tale Kótópaae yaala sókó fole alata, tuȩ́ tiki turónékélé, naao hosaa turónékélé, naao kepe bete turónékélé, naao fotoko̧ turónékélé yaala sókó fu betae.’ ");
INSERT INTO ppo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tamo dakoróló dere fo me i ape. ‘Naaotei ya̧ yaala sókó fu dere kaae, naao be whi̧ so whi̧paaekélé atéró yaala sókó fu betae.’ I fo tamoné mepaae yae yóló muló betere forape fea tȩteró beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ai fo depa kale whi̧né tokó̧ mótu duraalu, “Yó matere whi̧-ó, Kótó tekeyóló tamo bitini, mo beta̧tóró beterapó dere fota, naao mo dono ai dere ape. ");
INSERT INTO ppo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ti naao hosaa turónékélé, naao tuȩ́ tiki turónékélé, naao fotoko̧ turónékélé, Talepaae yaala sókó fu betae. Téturaalu, naaotei ya̧ yaala sókó fu dere kaae, naao be whi̧ so whi̧paaekélé atéró yaala sókó fu betae. Ai doasi bete mole fo tamota hupu dóló Talepaae simó suku̧laa dalatere alaró mepaae o̧la o̧la ha̧le matere alatamo mo tȩró beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Téró, Yesuné ama ai yale fo bete kale whi̧né mo wisiyóló tokó̧ matepa a̧paae duraalu, “Ya̧ta, Kótóné tȩteróló kaae tare tikipaae mo felekemó sókó faai dapó,” yalepó. Ai fo deremó, me whi̧nékélé a̧paae wosetere fo kae ini, atima witepa taaralepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Atéró, Yesu a̧ momatere be bolaare tua̧mó daalu so whi̧paae fo yó móturaalu, i fo wosalepó. “Kale Moses-né asȩre fo yó matere whi̧rapené duraalu, Kótóné sóró beteró betere whi̧ Kerisota Depit-né naalemapó du betere fo-a, noa betené du bitute? ");
INSERT INTO ppo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mo take Dȩi Kepe Wisiné Depit a̧ fotoko̧ratepa, ama ha̧kearóló i fo ipakalepó. ‘Talené ȩ tȩteróló kaae tare Talepaae duraalu, “Naao bóe whi̧rape ya̧ ao̧mó beteró̧póló, ya̧lo dóló tȩteraalopa, ya̧ ya̧lo turu naase dȩmótóró betó tawae,” ’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Depit-né ama deyale naalené deyaaire naalepaaetei, a̧ tȩteróló kaae tare Tale-ó du betale-a, neyóló yaleé?” yalepó. Ama atéró dere fo aimó touró betere mo so whi̧né hȩkesetamo wosetu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Téró, Yesuné so whi̧paae fo yó mótu duraalu, “Moses-né asȩre fo yó matere whi̧rapené dere alané dia̧ dorao̧sóró, mo hotowa yóló kaae tawae. Ti atimata, so whi̧ feané whi̧ wisipó yóló dukiratere koko̧mó, so whi̧ toura̧leta dere tikipaae faairaalu, fo̧loi kuti wisinaale maaté deróló fua dapó. ");
INSERT INTO ppo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Téró, Kótóné fo wosetere berapepaae furaalukélé, mo doasi topo whi̧rape bituatere tikimótóró betaai ekȩle yóo, kale o̧la detere sukamókélé, doasi doi mole topo whi̧rape bituatere tikimótóró ekȩle yóló betóo, dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Atéturaalu, kale wulia sorapekélé dilikó̧ló atimané muó mole o̧la o̧lakélé o̧lémi sóo, atima dukiró̧póló momatere alakélé mo fo̧lo si̧yóló yóo, dua dapó. Atétere whi̧rapeta take taletere sukamó, mo doakale dowi kwia saalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Atéró, me etéyalepó. Momatere bemó so whi̧ atimané tare moni su̧tóró Talepaae ha̧le dera̧leta duraalu mepaae néli so whi̧né ti doasi moni derótua yalepó. Atétu betepa, Yesu a̧ kaae tawóló daalepó. ");
INSERT INTO ppo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Téyaletei, beta̧ yolealere wulia soné ama sonaai moni ke tamo sóró wóló deralepó. Ai moni keta, kale sonaai moni ketamo su̧nipó. ");
INSERT INTO ppo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesuné ai kale wulia soné dera̧le wale moni ke kolóló, ama yó matere whi̧rapepaae ape yóló duraalu, “Ya̧lo dia̧paae mo i dere ape. I yolealere wulia soné dera̧le wale moni kené so whi̧ feané dera̧leta yale moni fea teraae falapó. ");
INSERT INTO ppo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ti noatepae, mepaae so whi̧néta doasi moni mupatei, tómó moletei maaté sóró wóló dera̧leta yalepó. Téyaletei, i wulia sonéta ama depe dolo sesé taretei mo ti kemeróló dera̧le walepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Téró, atima ai momatere be taaróló fu bitu, ama yó matere whi̧rapekó beta̧né a̧paae duraalu, “Yó matere whi̧-ó, doakale kapo fakené be wisinaale ai tȩnapa kelere?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ai fo depa Yesuné duraalu, “Ai tȩ mole doasi be wisinaalerape take fisikó furaalu, mió i ere kaae beta̧ kane fakekélé metamo olekepa kelaalomeipó. Mo featóró kolokó fóló muaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Atéró, Yesu ai momatere be ópaae tȩne fapa, Olip du sokoremó Pita, Jems, Jon, Andru atimasisi bitu a̧paae woseturaalu, “Naao mió ti bope yale alarape-a metéli yaaloé? Ai yale fo mo dokonaairaalu noa alapi depa, kolóló da̧né kisipa yaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ai fo depa Yesuné duraalu, “Mepaae whi̧né kapala fo yóló dia̧ dilikao̧sóró, mo wisiyóló kaae tawae. ");
INSERT INTO ppo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mepaae dilikitere whi̧rape wóló, ya̧lo doi yóló duraalu, ‘Ȩta dia̧né wó̧póló kaae tare whi̧ Keriso i ape,’ yóló, so whi̧ fea kó̧paae fó̧póló dilika̧alo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bóe mo du betepa kolóló dere foró, me bemó bóe du beterapóló deté kotere fotamo wosóló, diri furu furu duraalu wiyao̧se. Ti ai alarapeta, mo yaalotei kemeyaaire be dȩ sókó waai teórapó. ");
INSERT INTO ppo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Me hae kwiamó betere whi̧ró me hae kwiamó betere whi̧tamo bóe daalo ai ape. Me hae kwia tȩteróló kaae tare topo whi̧raperó me hae kwia tȩteróló kaae tare topo whi̧rapetamo bóe daalopó. Kae kae hae kwiapaae doakale baotere alaró, o̧la sóku alutere alitamo waalo ai ape. Ai alarapeta, sorapené naale saai sisó kaae sóró nukutere kaae dapó. Ai alarape yóló kemetepa, nalo mo doasi sekȩi ala waalopó. ");
INSERT INTO ppo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ai sekȩi alarapeta ha̧sókó feni, dia̧paae mo eraalopa siki sikiyóló betó muae. Ti noatepae, mepaae mo whi̧rapené dia̧ be kaae tare whi̧rapené fo tokó̧ló só deró̧póló, atima naase tua̧mó mulóo, mepaae whi̧rapené dia̧ fo wosetere bepaae dapesó fóló fokosói ala yóo, yaalopó. Dia̧ ya̧lo ala erateremó, tȩteróló kaae tare Gavman doasi topo whi̧raperó atimané sóró beteró betere topo whi̧rapetamoné keletómó sóró daalaalo ai ape. Atétere be dȩmó, Talené dia̧paae erale alarape atimané wosó̧póló, diaao yaaire tȩ amatei mulaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Atéró, kemeyaaire be dȩ sókó waai teópa, folosóró i hae kwia feamó betó mole so whi̧paae mió wosetere fo wisi yó maté kwȩyóló su̧raalopó. ");
INSERT INTO ppo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Atétepa, mepaae whi̧né dia̧tamo fo tokó̧tamo yaai dapesó fupa, noa fo yaalorópóló whaalia yao̧se. Dia̧né fo yaai kaae seretamo, diaao̧ yaaire fo Talené yó melaalo ai ape. Diaao̧ kisipané yaalomeitei, Kótóné ama Dȩi Kepe Wisiné yae dere fotóró yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Me whi̧né ama nomatei mené dó̧póló eleké deyóo, me whi̧né ama naaletei me whi̧né dó̧póló eleké deyóo, naale senaalenékélé hama alima ao̧mó betere hó̧róló, mepaae whi̧né dó̧póló eleké deyóo, yaalopó. ");
INSERT INTO ppo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Dia̧ ya̧lo ala erótu beteremó, so whi̧ mo feané dia̧tamo dei tuȩ́ muturaalu, dia̧ hó̧róló bóe daalo ai ape. Téyaalotei, mepaae so whi̧ de ȩpaae kisipa tiki tiróló, diriyóló bitiré fóló kemetere kwiamó sókó fupa, ti atétere so whi̧ aluyao̧sóró ya̧lo tao saalopó. ");
INSERT INTO ppo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Diaao̧ kelera̧lemó, Kótóné ama kae bemótei, mo kelaalo sonaalei dowi ala du betepa, Talené doi folokoleróló, be mo wópu mulaalopó. Ai ala enénire tikimótei epa kilitu, i asȩre fo dosa̧atere so whi̧ dia̧né mo wisiyóló kisipa muae. Ai ala depa, Judia hae kwiamó betó mole so whi̧ hasi fosópaae botokó fó̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Dia̧ siki be kemó betera̧lemó i sekȩi ala wapa kilitu, siki bemó beteretei taaróló, ao̧ró be kemó mole o̧la o̧la sene derepéni taaróló botokó fae. ");
INSERT INTO ppo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mepaae whi̧ kutómó daara̧lemó ai ala depa, ama da̧ae mulale bukutere kuti momó sene feni, muló̧póló taaróló botokó fae. ");
INSERT INTO ppo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Atétere sukamó, mepaae naale ere soraperó naale senaale tare sorapetamo botokó faaire su̧ni bipi ereteiné mo doa ko̧lerapó. ");
INSERT INTO ppo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Térapa, ai alarape sosóli alimó yao̧sórópa, moma beta̧ du betae. ");
INSERT INTO ppo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ti noatepae, Atétere alimó mo doakale dowi sekȩ waalo ai ape. Mo take Kótóné keké nale alimó kaae sóró bitiré wóló, mió i alimókélé atei kaae dowi sekȩi ala mo kolókélé inipó. Téró bitiré fóló, nalopaaekélé atei kaae dowi sekȩi ala momó kae kelaalomeipó. ");
INSERT INTO ppo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ai be dȩrape Talené ha̧lekeróló tukóló mulólua̧ meisóró, ti so whi̧ mo beta̧kókélé ha̧sókó fua̧ meipó. Talené ama sorokósu yóló kae beteró betere so whi̧mó kisipa mutu, be dȩrape ha̧lekeróló tukóló muló beterapó. ");
INSERT INTO ppo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ai sukamó whi̧ mené dia̧paae duraalu, ‘Kale sóró beteró betere whi̧ Keriso ai walapa kelae!’ Ó u wóló betere ape depa wosóló, mo dapóló momókó tuȩ́ tiki tirao̧se. ");
INSERT INTO ppo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ti noatepae, mepaae Keriso ao̧yóló dilikitu betere whi̧raperó Kótóné ko̧ló whi̧póló kapala fo yó matere whi̧rapetamo waalo ai ape. Atétu, kae kae ala yaairemó eratere doasi alaró kae kae kelemei alarapetamo eróturaalu, Kótóné sorokósu yóló kae beteró betere so whi̧kélé kó̧paae fenérémóló ka̧ae kolóló su̧ saalopó. ");
INSERT INTO ppo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Téyaalopa, dia̧ dilikó̧ló kó̧paae falao̧sóró, siki siki yóló bituraalu mo wisiyóló kaae tawae. Ai alarape fea yaai teópatei, ya̧lo dia̧paae i dere ape. ");
INSERT INTO ppo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Ai sekȩi alarape wale ki̧lipaae ti i asȩre fo dokonóturaalu, i alarapepi yaalo ai ape. ‘Suka ke aluróló dilikiróo, Wéliékélé dȩ iniyóo, ho̧rerapekélé i haepaae torokó dorowóo, yaalopó. Téturaalu, Kótóné ama bole fotoko̧nétei ó sa̧ woreróturaalu, sa̧mó ere o̧la o̧lakélé fea wore yaalo ai ape,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Atétere sukamó, kale Whi̧né Naalema a̧ ama fotoko̧ró mo kae ere dȩ wisinaaletamo sa̧ko tua̧mó sókó wapa, so whi̧ feané kelaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Atéró wóló daalu, ama sorokósu yóló kae beteró betere so whi̧ dape siré kwȩyó̧póló, ama ensel-rape dotonaalopó. Haeró sa̧ kwiatamo dene fale doko̧ feamó, betóló fale so whi̧ dape siré kwȩyó̧póló dotonaalopó. ");
INSERT INTO ppo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Téró fo me i ape. Ni nosepaae dó faróló dere fo diaao̧ wisiyóló tuȩ́ yaasepóló, i dapa wosae. Nose sóku fóló, totoko̧ momó beletepa kilituraalu, kale ba fo ali mió felekemó sókó walapó dua dapó. ");
INSERT INTO ppo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ya̧lo i bopeyale alarape eratepa kilituraalu, kale Whi̧né Naalema felekemó waai, tu̧ serekemó daapa dapóló tuȩ́ muae. ");
INSERT INTO ppo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ya̧lo dia̧paae mo i dere ape. Mió i alimó betó mole so whi̧ fea sukuni ha̧le betepatei, i alarape mo eratepa kelaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ó sa̧ró i haetamo kemeyaalotei, ya̧lo fo beta̧ mo kemekélé ini, ha̧le muótóró tawaalopó. ");
INSERT INTO ppo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mo whi̧ beta̧nékélé, hepen bemó betere ensel-rapekélé, Naalemanékélé, ai be dȩró suka keletamo tuȩ́nitei, i be dȩmó i alarape yaalopóló, Alimané beta̧ tuȩ́rapó. ");
INSERT INTO ppo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Térapa, a̧ waaire be dȩ dia̧ tuȩ́ inireteiné ali ali yao̧sóró, betere doko̧ siki siki du betae. ");
INSERT INTO ppo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kale Whi̧né Naalema waaireteita, i ala dere kaaepó. Beta̧ whi̧ metikipaae faairaalu, ama kutó diratere whi̧rapepaae kutó beta̧ beta̧ yóló doko̧ratapó. Atéró, be tu̧ sókó walemó daayaaire whi̧paaekélé, mo wisiyóló kaae tawae yóló a̧ fulapó. ");
INSERT INTO ppo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Ti be tale fesaae waaire suka dia̧ tuȩ́nipa, ai be dȩ kaae tawóló betae. Ti noatepae, suka doropolepaae ó dilikitamo ó be dȩyaai bané hale deretamo ó dia̧ noke firepaae ó suka sokoterepaae a̧ hapale sókó walemó, dia̧ ali ali erao̧sóró kele diriyóló betaasepóló dapó. ");
INSERT INTO ppo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ya̧lo i dere fota, dia̧paae maaté dumitei, so whi̧ feapaae a̧ mo waalopa, hotowayóló kaae tawae, yóló i dere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Atéró, kale boseneyóló fele be dȩró fopei bred o deyóló nokole be dȩtamo sókó waai, tamo be dȩ ha̧le mupa etéyalepó. Kale so whi̧mó momaratere whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamoné Yesu tawóló daaire tu̧ kikitu duraalu, “Da̧né a̧ neyóló tawóló daaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tétepa, mepaae whi̧né duraalu, “Itei kaae o̧la detere be dȩmó da̧né ai ala enalemó, ti so whi̧né ho̧le sóró doasi foya enérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Téró, Yesu a̧ Betani bemó dowi humu fuluné tiki dopa, take ama wisirale whi̧ Saimon-né bemó o̧la nuku beterepó. Atétepa, so beta̧né alabasta kanené aleale wutimó felé kȩlaa wale nadi wel wȩi maapa tawóló walepó. Ai wȩita, doasi moni-né duputeretei kale soné ai wuti topo dopó faróló, Yesuné topomó suniyalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Atétere ala mepaae whi̧rapené kilitu, ai sotamo dei tuȩ́ muóló atimasisitei duraalu, “Ai wȩi wisinaale noatepa ha̧le besekéróló suniyalerópó? ");
INSERT INTO ppo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","I wȩita, dotonóló 300 denarias moni sóró mepaae ha̧le yolealere so whi̧mó mólua̧sóró wisiua̧póló,” deteraayóló tamo foné su betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Atétu betepa, Yesuné atimapaae duraalu, “Ama ȩpaae mo koko̧i ala wisinaale eralepa, diaao̧ a̧ foné sere ala taalae. ");
INSERT INTO ppo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ai yolealere so whi̧ta, suka fea dia̧tamo bitu, diaao̧ tao saai kisipa mutere sukamó tao sua enérapó. Téyaalotei, ȩta suka fea dia̧tamo betó tawaalo meipó. ");
INSERT INTO ppo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Téyaaireteiné ai soné ama enére ala ai yale ape. Ama ai yale alata, ya̧lo tiki douratere sukamó felé kȩlaa wisi wó̧póló yaaire ala su̧ralepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ya̧lo dia̧paae mo i dere ape. Hae kwia feapaae kale fo wisi yó maté kuturaalu, i soné ȩpaae erale alakélé tuȩ́tóró ha̧le yó taru, yó melaté kwȩyaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Téró Yesuné ama yó matere 12 whi̧rapekó Iskariot be whi̧kó Judas a̧ Talepaae momaratere topo whi̧rape beterepaae Yesu daaire tu̧ aleyó̧póló eleké dene felepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Atéteremó, kale whi̧rape atima hȩkesené sukuturaalu, Judas-mó moni melaai taleyóló mulalepó. Tétepa Judas a̧ bituraalu, Yesu eleké deyaaire tu̧ kekitu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Téró, kale fopei bred o deyóló nokole fula kaae sere be dȩmó i ala yalepó. Atimané mara mole ala sya furaalu, kale boseneyóló fele be dȩmó o̧la deyaai sipsip hupu male dóló simó biliyóló nukua dapó. Ai ala yaai, Yesuné ama yó matere whi̧rapené a̧paae woseturaalu, “ Kale boseneyóló fele be dȩmó deyóló naaire o̧la da̧né mé bemó taleyóló mularóé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ai fo depa, ama yó matere whi̧rapekó tamo dotonaai duraalu, “Diaamo ai doasi be huluapaae fóló kelenalemó, tu̧ tua̧mó beta̧ whi̧ a̧ wȩi wuti beleyóló wou betepa hokolaayaalo ai ape. Téyaalopa, diaamokélé a̧tamo fae. ");
INSERT INTO ppo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Atéró, a̧ fole be dolopaae diaamokélé fóló, ai be talepaae i fo yae. ‘Yó matere whi̧ a̧ ama yó matere whi̧rapetamo, kale boseneyóló fele be dȩmó detere o̧la naairaalu wale whi̧rape betaaire be ke mé eré?’ yóló wosae. ");
INSERT INTO ppo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ténalemó, o̧la o̧la fea su̧mótóró sisóló muló betere siki be ke doasi ama diaamopaae yó melaalo ai ape. Ai be dolomó da̧né naaire o̧lakélé taleyóló mulale fae,” yóló dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tétepa, ama yó matere whi̧ tamo fóló kelalemó, Yesuné atimaamopaae epa kelaalo ai ape yale alatóróti, mo epa kelalepó. Atépa, ai be ke dolomó kale boseneyóló fele be dȩmó deyóló naaire o̧la taleyóló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Téró, be dikiteretamo Yesu a̧ ama yó matere 12 whi̧rapetamo sókó walepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Atéró, atima be dolomó o̧la nuku bitu, Yesuné ama yó matere whi̧rapepaae duraalu, “Ya̧lo dia̧paae mo i dere ape. Mió ȩtamo i o̧la nuku betere whi̧rapekó beta̧né ȩ dó̧póló me whi̧paae eleké deyaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ai fo deremó, atima tuȩ́ sekȩtepa a̧paae duraalu, “Ya̧ ya̧lo eleké deyaalopóló de?” yóló, atima feané beta̧ kaae fotóró deté felepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tétepa, Yesuné atimapaae duraalu, “Ai ala yaaire whi̧ta, dia̧ 12 whi̧rapekó mió i nuku dolomó bred o wȩimó tópuró su yóló nuku betere whi̧nétei ȩ dó̧póló eleké deyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Atéró, kale Whi̧né Naalemapaae eraaire alata, kale asȩmó ere fo mo dokonaalo ai ape. Téyaalotei, kale Whi̧né Naalema dó̧póló eleké deyaaire whi̧ a̧ beta̧ doasi dowi kwia saairemó wió yae! Ai whi̧ a̧ hamané dewua̧ meisóró, mo wisi wua̧pó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Atéró atima o̧la nuku bitu, Yesuné kale bred o bula beta̧ tao sóró taru, Talepaae mo kée yóló kolokó daalu yóló, ama yó matere whi̧rape doko̧róló mótu duraalu, “Ita ya̧lo tikipa, sóró nae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Téró kale dere kaae, wain wȩi wutikélé sóró taru Talepaae mo kée yóló, ama yó matere whi̧rapemó matepa, atima feané beta̧ wutimótei nukulé felepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Atéró melóló duraalu, “I wutimó maane wȩita, Kótóné ama so whi̧ fea aluyao̧sóró tao saalopóló, diriróturaalu sunée farale ya̧lo sameapó. ");
INSERT INTO ppo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ya̧lo dia̧paae mo i dere ape. Ȩ dia̧tamo etéró bitu, wain wȩi momó kae néli ha̧le bitiré fóló, Kótóné tȩteróló kaae tare ao̧mó bituraalu, kisi wain wȩi naalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Atéró, atima wole fo beta̧ yóló kemetepa, Olip du sorokó mole ao̧paae holaai felepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Atéró fóló, Yesuné atimapaae duraalu, “Mió dia̧ ȩtamo beta̧mó titiyóló beteretei, ȩ taaróló botokó dapo dapo yaalo ai ape. Ti asȩmó i fo erapó. ‘Kale sipsip hupu kaae tare whi̧ ya̧lo dupa, hupurape atima botokó dapo dapo yaalopó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Téyaalotei, ȩ momó kepaayóló Kaleli haepaae ȩpi fimó, dia̧ nalo waalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ai fo depa Pitané Yesupaae duraalu, “Mepaae whi̧rapené ya̧ taaróló fupa, ȩ beta̧ mo até yaalomeipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ai fo depa Yesuné a̧paae tokó̧ mótu duraalu, “Ya̧lo ya̧paae mo i dere ape. Mo mió dilikitamo wa̧ kakaruk bané hale tamo dakoróló yaaipatei, naao ȩ tuȩ́nipó fo sore félimó yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ti fo depa, Pitané fo diriné momó duraalu, “Atimané ȩkélé ya̧tamo wusuró dó̧póló, ya̧lo ya̧ tuȩ́nipó fo mo yaalomeipó,” yalepó. Mepaae yó matere whi̧rape feanékélé, ama ai dere fo kaaetóró yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Atéró, atima kelaalo koko̧i tiki Ketsemanimó sókó felepó. Aimó ama yó matere whi̧rapepaae duraalu, “Ȩta momane fulapa dia̧ imó betó muae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Atéró Pita, Jems, noma Jon, atima maaté Yesutamo felepó. Atéró, Yesuné ama hosaa tua̧mó mo doasi dele duraalu, sekȩné sukó̧ló dei fomaake kisipa kaae sóró muté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Atétepa, ama atimapaae duraalu, “Ya̧lo hosaa tua̧mó dekȩné sukutu ȩ mo felekemó suka̧ai dapa, dia̧ imó kaae tawóló betó muae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ai fo yóló, a̧ atima betere tiki sawa taaróló fóló, a̧paae waaire sekȩ ha̧sókó fó̧póló, haemó deraapisa fóló mulu momaturaalu, “Apa-ó, ȩpaae i eraaire sekȩi ala wao̧sóró seséyaaire tu̧ mupa, ti naao seséyae. Tépatei, ya̧lo kisipa mole ala sya fóló ini, naao kisipa mole ala beta̧ eró̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Téró a̧ ama yó matere whi̧rape beterepaae momó fesaae walemó, atima noke fopesaapa kelalepó. Atépa, Pita turukuróló duraalu, “Saimon-ó, suka kele beta̧mó ȩ kaae tawóló bitini, ya̧ noke ai firerapó. ");
INSERT INTO ppo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kae kae su̧ sere alané dia̧ me dowi ala yóló dée nalao̧sóró, mo hotowayóló kaae taruraalu momatu betae. Ti noatepae, kepe betenéta mo wisi alamaaté yaai ketekȩ bupatei, tó tikiné dowi ala yao̧sóró sesé yaaire fotoko̧ buni, bérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Atéró a̧ fesaae fóló, ama kale yale moma kaaetóró momó yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Atéró, a̧ kale dere kaae momó fesaae wou kelalemó, atima noke kȩle depa, fopesaapa yó molepó. Atima atéró noke mo fiyaleteiné, a̧paae noa fo yaalorópóló ko̧ló ko̧ló yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Atéró, a̧ sore dakeróló momane fi wouraalu kelalemó, noke fire alatóró yó tapa atimapaae duraalu, “Dia̧ sa̧a nóló noke fitere ala ha̧le ai yó tare? Su̧mó fiyalepa mióta, kale tukóló muló betere sukakele i sókó wale ape. Kelae! mió dowi ala dere whi̧rapené kale Whi̧né Naalema dó̧póló, mené eleké ai deyale ape. ");
INSERT INTO ppo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mió ȩ dó̧póló eleké deyaaire whi̧ ai walapa, turukó hóróló da̧ faalopa fiépe,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ai fo deretamotóró, ama yó matere 12 whi̧rapekó beta̧ Judas sókó walepó. Ama ki̧limó, whi̧rape mo fea sepakeró nópulutamo tao diliki yóló wó tarepó. Ai whi̧rapeta, mo so whi̧mó Talepaae momaratere topo whi̧rapekélé, Moses-né asȩre fo yó matere whi̧rapekélé, whi̧ disirapekélé, atima fea beta̧mó fo deyóló dotonatepa walepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Téró, Yesu dó̧póló eleké deyaaire whi̧né a̧ tawaaire whi̧rape atima ko̧ló ko̧ló duraalu, “Ho̧ko whi̧tei tawao̧sóró ȩ fóló, ya̧lotamo ko̧ló tukó nukupa, ti a̧tóró hi̧ti ai ape. Térapa, tawóló dokóló só furaalu, a̧ botokó fao̧sóró mo wisiyóló kaae tawae,” yóló mulélipakalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Téró, kale Judas a̧ Yesu daalepaae mo hapale sókó fóló duraalu, “Yó matere whi̧-ó,” yóló ko̧ló tukó nalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Atétepa, ai wóló daae mole whi̧rape sókó furaalu, Yesu naasemó etȩ́e sóró fotoko̧yóló tawalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Atétere ala kolóló, Yesutamo daale whi̧ beta̧né ama sepake sókó sóró, so whi̧mó Talepaae momaratere topo whi̧né kutó diratere whi̧né wosȩ́li sa̧ae deralepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tétepa, Yesuné atimapaae duraalu, “Ȩta, Gavman-tamo bóe dóló so whi̧ ya̧lo a̧lisóró fulapóló ȩ daai nópuluró sepaketamo tao dilikiyóló woute? ");
INSERT INTO ppo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ti ȩ suka fea momatere be belamó daalu dia̧paae fo yó mótu betepa, fo tokó̧tamo yaairaalu, dia̧né ȩ aimó tanipó. Tépatei, kale asȩmó yóló muló betere fo dokonaairaalu dapa, mo eró̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yesu atéró tateremó, ama yó matere whi̧rape atima wimó a̧ taaróló, botokó dapo dapo yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tétepa, beta̧ kokopei whi̧ kutikélé deréni, ama bukutere dȩi kuti maaté bukóló Yesu sya fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Atéró fu betalemó, atimané a̧kélé ama bukure kutitamo touróló tawalemó, ai kutitei atimapaae da̧ae melóló, a̧ tiki daapi ha̧le botokó felepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Téró, atimané Yesu a̧ Talepaae momaratere doasi topo whi̧ beterepaae dapesó walepó. Atéró betepa, ai doasi topo whi̧ ao̧mó betere momaratere whi̧rapekélé, Moses-né asȩre fo yó matere whi̧rapekélé, whi̧ disirapekélé, fea wóló touralepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Téró Yesu tawóló só fupa, Pita a̧ nalo dua tokó̧ su deté fu betalepó. Atéró fóló, momaratere whi̧rapené topo whi̧né be bopéró daaló betere dopóku tu̧ serekemó sókó felepó. Atéró a̧ ai be kaae tare diki tare whi̧rape betó mole kua dolomó, sosólitepa simó beterepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Atépa, kale momaratere topo whi̧raperó fo tokó̧ló taletere whi̧rapetamoné Yesu sukó̧póló daaire bete kikitu betaletei, bete mekélé kilinipó. ");
INSERT INTO ppo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Atimané a̧ dó̧póló kapala fo yóló só deraaitere fo whi̧ feané yaletei beta̧ fotóró ini, mené fo kae, mené fo kae, du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Atéró, a̧ só deraai mepaae whi̧ turukó holóló daalu i fo yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Mo whi̧né naasené tȩale be ama fisikóló, whi̧né tȩnénire momatere be ama sore sukamótóró momó tȩyaalopó depa, da̧né wosalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Téyaletei, atima feané beta̧ fotóró ini, mepaae whi̧né dere fo kae, mepaae whi̧né dere fo kae du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Atétu betepa, momaratere topo whi̧ kale fo tokó̧ló taleratere whi̧rapené keletómó turukó horóló daalu, Yesupaae woseturaalu, “Ya̧ só deratere whi̧rapené doa i dere fo-a, naao atimapaae tokó̧ menitere noatepa de? ” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ti fo depa, Yesuné atimapaae fo me tokó̧ menipó. Atétepa, kale momaratere topo whi̧né a̧paae momó woseturaalu, “Ya̧ta, wisi alamaaté erótu betere Talené naalema so whi̧ tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Kerisoé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ai fo depa, Yesuné duraalu, “Ai whi̧ta, ȩtóróti i ape. Whi̧né Naalema mo doasi fotoko̧ bole Talené turu naase dȩmó betóo, ó sa̧ko dolomó wóo depa, diaao̧ kelaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Kale momaratere topo whi̧né ama deró betere kuti bisa̧ayóló duraalu, “A̧ só deraaire bete kilinipakó, ama dere ala kelale whi̧ me kae keka̧aloé? Ti Kótó faletere fota, amatei deremó da̧né wosalepa, dia̧né noa kisipa mute?” depa, atimané duraalu, a̧ só deraaire fota amatei ai yalepa, a̧ sukó̧póló daalopó yóló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Atéró, mepaae whi̧rapené a̧ fesa̧a apuróo, mepaae whi̧rapené ti kuti kwiané ama kele husiróló dokóló, naase duné dóo yóló, a̧paae duraalu, “Ya̧tamo Kótóné ama whi̧pata, ti ya̧ dale whi̧ da̧paae yó a̧lae,” yalepó. Atéró, diki tare whi̧rapenékélé, a̧ tao taru du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Atétu betepa, Pita a̧ momaratere topo whi̧né be boperó betere dopóku ao̧mó kese horóló betepa, kale topo whi̧né kutó diratere so seimalerapekó beta̧ a̧ beterepaae walepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Atéró, Pita a̧ sosóli depa simó beteremó, kale so seimalené a̧ kelené kikéró kaae taru duraalu, “Ya̧kélé Nasaret be whi̧kó Yesutamo beta̧mó kutua yale whi̧pó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ti fo depa, Pitané kale senaalepaae duraalu, “Naao ai dere fo beteta ȩ tuȩ́ni, ko̧ló ko̧lórapóló,” a̧ witepa dopóku tu̧ sereke felekemó biti̧ felepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Atétepa, kale so seimalené Pita kolóló, aimó daae mole so whi̧paae momó duraalu, “I whi̧kélé Yesutamo beta̧mó kwȩale whi̧kópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tétepa, Pitané ama kale dere fo kaae momó duraalu, “Ȩ mo meipó,” yalepó. Atéró sawa betóló, kale dere kaae mepaae felekemó daae mole whi̧rapekó beta̧né a̧paae duraalu, “Ti ya̧ta, a̧tamo beta̧mó kwȩyale whi̧ mo hi̧ti ai ape. Ti noatepae, naao dere fota, Kaleli be fo nakome wosetapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ti fo depa, Pitané atimapaae duraalu, “Diaao̧ ai bopetere whi̧ta, ȩ tuȩ́nipó. Ya̧lotamo dia̧paae kapala fo depa, ti Talené ȩ dó̧póló yae,” yóló, mo dirii da̧le dere fo kaae yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ai fo deretamotóró, kale wa̧ kakaruk bané hale tamo dakoróló yalepó. Tétepa, take Yesuné Pita a̧paae du, wa̧ kakaruk bané hale tamo dakoróló yaaipatei, naao ȩ tuȩ́nipó fo sore félimó yaalopó yaletei, kisipa muni walepó. Atétepa, a̧ dekȩné sukuturaalu, doasi wole du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Atéró, mo hi̧kati so whi̧mó momaratere topo whi̧rapekélé, whi̧ disirapekélé, Moses-né asȩre fo yó matere whi̧rapekélé, fo tokó̧ló taleratere whi̧rapekélé, atima fea fo dokóló, mo beta̧ tuȩ́tóró muóló, Yesu naase tamo dokóló dapesó Pailat-né naase tua̧mó mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Atéró wóló daapa, Pailat-né a̧paae woseturaalu, “Ya̧ta, kale Juda fake so whi̧ tȩteróló kaae tare doasi topo whi̧é?” depa, Yesuné a̧paae tokó̧ mótu duraalu, “Ȩ́pó. Naao ai dere fota, mo dono dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ai fo deremó, Talepaae momaratere topo whi̧rapené dei tuȩ́ mutu, i sekȩ́né kae kae ho̧ko alarape yalepóló, só deratere fo du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Atétu betepa, Pailat-né a̧paae momó woseturaalu, “Atima kae kae forapené ya̧ só derótu betere fo fea naao woserutei, tokó̧ menitere-a, noatepa de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ai fo depatei, Yesuné kale topo whi̧ Pailat-paae me fo tokó̧ menitere ala kilitu, ama sirayalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Atimané o̧la detere alimó, mara mole ala ipó. Dipula beteró betere whi̧ beta̧kó ba fo doko̧mó so whi̧né sokae dere whi̧tóró Pailat-né sókó daalótua dapó. Atéró dotȩyaai so whi̧paae wosóló, atimané doi dere whi̧tóró dotonótua dapó. ");
INSERT INTO ppo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Gavman-tamo bóe dóló whi̧ dupa, dipula beteró betere whi̧rapetamo Barabas-kélé beterepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Atépa, so whi̧ mo fea Pailat beterepaae wóló woseturaalu, “Naao kale duatere kaae yaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ti fo depa, Pailat-né atimapaae woseturaalu, “Diaao̧ kisipané Juda so whi̧ tȩteróló kaae tare topo whi̧ dotonaró de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Fo yaleteita, momaratere topo whi̧rape Yesutamo dei tuȩ́ muturaalu, a̧ daai dapesó wale bete Pailat-né ama kisipa yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tétepa, kale momaratere topo whi̧rapené mo so whi̧paae Barabas sokó̧póló, yae yóló sesemeratere fo deté kotepa, atimané ai fo yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ti fo depa, Pailat-né atimapaae momó duraalu, “Juda so whi̧ tȩteróló kaae tare topo whi̧paae ya̧lo noa alakó eraró de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tétepa, kale so whi̧né fo fakeyóló duraalu, “Ai whi̧ filipaa ni tómó oleróló dae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ai fo depa Pailat-né atimapaae duraalu, “A̧ me dowi ala initepatei, ha̧le noatepa daró de?” yalepó. Tétepa, kale so whi̧ feané mo ti fo fakeyóló duraalu, “Filipaa ni tómó sukó̧póló olerae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Atétepa, ai so whi̧né Pailat a̧paae wisi tuȩ́ muó̧póló, Barabas atima beterepaae fó̧póló sokóló daalóló, Yesu mo dirii halika tikinépi fokosoi ala du beteró, filipaa ni tómó sukó̧póló olerae yóló, diki tare whi̧rapené naase tua̧mó mulalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Téró, kale diki tare whi̧rapené Yesu dape sóró kale topo whi̧ Pailat-né be bela wisinaalené doi Pretorium-paae dapesó felepó. Ai dopóku bolaa dolopaae mepaae diki tare whi̧rapekélé mo fea ape depa, atima touralepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Atéró daaló bitu, sonaai kuti deróo, mu daai képitei topo whi̧rapené deratere topotao su̧róló bopeyóló, ama topomó deróo yóló, a̧ faletu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Atéró, atimané duraalu, “Juda so whi̧ tȩteróló kaae tare doasi topo whi̧-ó,” yóló, fesa̧a apuróló dotó tikiné du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Atéró, dotó tikiné ama topomó momó du momó du yóló fesa̧a apurótu betalepó. Atéró atima Yesu ao̧mó bukutiri tea̧ró bitu, doa whi̧-ó yóló doi sóró horóló faletu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Atétu beteró, atimané a̧ derale sonaai kuti sókóló, ama kuti momó deralepó. Atéró a̧ filipaa ni tómó sukó̧póló, oleraairaalu dapesó felepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Atéró dapesó fu betepa, Sairin be whi̧kó Aleksandaró Rufus-tamoné alima Saimon a̧ ipu bemó biti, doasi be huluapaae faai wapa, kale diki tare whi̧rapené a̧paae Yesu dóló oleraaire filipaa ni a̧ fasóló naao belerae yóló sȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Atéró, atimané Yesu dapesó fóló, beta̧ hae Kolkotamó sókó felepó. Ai doiné beteta, topo diripó. ");
INSERT INTO ppo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Téró, aimó wain wȩiró kale mur ni fȩtamo hosekéróló tepeyóló nó̧póló melaletei, ama nénipó. ");
INSERT INTO ppo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Atéró, atimané a̧ filipaa ni tómó sinó̧póló oleralepó. Atéró oleróló, ama kuti atima saairaalu, beta̧ melaa yalepó. Kale diki tare whi̧rape atima beta̧ beta̧ yóló kapo fakemó siri eróló, sikipaae fesekée horótua yalemó, mé whi̧né siri moletei wisiyóló muni doro wapa, ti ai whi̧né ama kuti sua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Téró hi̧ka 9 kilok sukakelemó, Yesu dóló oleralepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","I betené dalepóló, a̧ wolerale ni topomó asȩyóló olerale fo i ape. Juda so whi̧ tȩteróló kaae tare topo whi̧ ");
INSERT INTO ppo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Atéró, o̧lémi nuku betale whi̧ tamo me whi̧ Yesuné fȩ́ naase dȩró oleróo, me whi̧ turu naase dȩró oleróo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Atéró oloró betepa, mepaae fua wua du betere whi̧rapené ki̧li fépo yóló duraalu, “Ya̧ta, momatere be fisikóló sore sukamótóró momó tȩyaalopó du betale whi̧pa, mió naaotei ya̧ tao sóró, ai filipaa ni taaróló dere ape,” dua yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kale yale fo kaae, momaratere topo whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamo atimasisitei duraalu, “Mepaae so whi̧ sukao̧sóró tao sua yale kaae, amatei a̧ tao sinitupó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“Ya̧tamo Israel fake so whi̧ tȩteróló kaae tare doasi topo whi̧ Kerisopata, ti da̧ tuȩ́ tiki tiraai dapa, ai filipaa ni taaróló dere ape,” du betalepó. Téró, a̧tamo oleró betere whi̧ tamonékélé, u whi̧rapené dere kaae, faletu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Atéró, suka tua̧mó 12 kilok kaae sóró be dikiraletei, kuluka 3 kilok-mó momó dȩralepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Atéró, ai sukakelemó, Yesuné fo fakeyóló duraalu, “Eloi, Eloi, lama sabakatani,” ai fo bete feteyóló “Ȩ tȩteróló kaae tare Kótóo, ȩ tȩteróló kaae tare Kótóo, ȩ wotoró beteró̧póló, noatepa taaróló feleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ama ai dere fo felekemó daae mole whi̧rapené wosóló duraalu, “Elaijapaae ape yóló, ai dere wosere?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tétepa, beta̧ whi̧ hapale fóló, wépi kaae o̧la kape sikimó haka sóró, séli kȩlaa kaae ere wain wȩi tópuróló melaai yalemó, mepaae whi̧né duraalu, “Ilaija wóló a̧ tokóló só fulémóló kelaalopa, kaayae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Atéró, Yesuné fo fakeyóló, a̧ mo ti suka̧lepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Atéteretamo, kale momatere be tua̧mó sata̧le yóló oleró betere kuti, ha̧letei ó kwiamó kaae sóró tua̧mó teketé doropóló, salepaae sókó deralepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Téró, kale 100 diki tare whi̧rape kaae tare doasi topo whi̧ a̧ Yesu oleró betere tiki felekemó daalemó, a̧ suka̧airaalu, dere fo fake wosóo, sukutere alakélé kolóo duraalu, “Haió! A̧ta, Kótóné Naalematei ai dirapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mepaae sorapekélé mo tumó kese anóló daae molepó. Ai sorape kuamó, Maktala sokó Mariakélé, Jems-ró Joses-tamoné hama Mariakélé, Salomekélé, atima atéró daalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ai sorapeta Yesu sya fóló, take Kalelimó a̧tamo kuturaalu, a̧ ya̧ ya̧tere o̧la melóló kaae tawale sorapepó. Mepaae a̧tamo Jerusalem bepaae wale sorapekélé fea atima daae molepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kale Juda whi̧rape atima sa̧a nóló betere be dȩ dótóróti sókó waaipa, miótóró kulukapaae o̧la o̧la sisóló mulatere be dȩmó ai ala yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Tétepa, kuluka deretamo Israel fake so whi̧né fo tokó̧ló taleratere whi̧rape tua̧mó doasi doi mole Arimatea be whi̧kó Josep walepó. Ai sekȩ́ta, Kótóné tȩteróló kaae tare ala wó̧póló kaae tare whi̧pó. Atéreteiné a̧ witere alakélé ini, halaainé Yesuné tiki melaaloé? yóló, Pailat-paae wosene felepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","45","Atéró, Yesu mo suka̧lepó dere fo kale Pailat-né wosóló, a̧ kilita sókó fu sira yalepó. Tétu, diki tare whi̧rapené doasi topo whi̧paae woseturaalu, “Yesu mo ti suka̧leé?” depa, kale sekȩ́né duraalu, “Ȩpó. A̧ mo ti suka̧lepó,” yalepó. Ti fo depa, kale Palaitiné Josep-paae wisirapa tokóló sóró fae yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tétepa, Josep-né ama beta̧ dȩi linen kuti wisinaale dupuyóló, Yesu tokóló haemó mulóló, ama tiki bopeyóló dokalepó. Atéró só fóló, mené aleyóló muló betere kane dolomó douralepó. Atéró, Josep-né ai dou tu̧ kinaaire kane fake biliraté fóló kinalepó. ");
INSERT INTO ppo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Atéró, Yesu dourótu betepa, Maktala sokó Mariaró Joses-né hama Mariatamo mo tumó daalu, kese faló beterepó. ");
INSERT INTO ppo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Téró, kale sa̧a nokole be dȩ kemene fupa, Maktala so Mariakélé, Jems-né hama Mariakélé Salomekélé, atima felé kȩlaa wale wisi wisi o̧la Yesuné tikimó dila̧le faai dupuyalepó. ");
INSERT INTO ppo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Atéró, fula kaae sere be dȩmó, hi̧ka suka hoteretamo kale sorape atima Yesu mole dou tópaae felepó. ");
INSERT INTO ppo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Atéró atimasisi fu bituraalu, “Kale dou dolo kinó betere doasi kane fake beta̧ né tukwȩyóló biliraté faalorópó?” deté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Atima atéró mo umó wou bitu kese faralemó, kale dou dolo kinó betere doasi kane fake biliraté fóló, dȩmó muló betepa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Atépa, atima dou dolopaae felemó, beta̧ kokopei whi̧ dȩi kuti wisinaale deróló, turu naase dȩró betepa kólóló, atima witu kilita sókó felepó. ");
INSERT INTO ppo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Atétepa kale whi̧né atimapaae duraalu, “Dia̧ wiyóló kilita sókó fao̧se. Dia̧ta, atimané filipaa ni tómó oleróló dale Nasaret whi̧ Yesu kekitu beterapó. A̧ta imó muni, kepaayóló ai fele ape. A̧ mulale tikikélé ha̧le ai erapa kelae. ");
INSERT INTO ppo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Térapa dia̧ fóló, ama yó matere whi̧ Pitaró mepaae yó matere whi̧rapetamopaae i fo ene fae. Take a̧ suka̧ai bituraalu, yale fo motóróti dokonóturaalu, dia̧ wó̧póló, folosóró a̧pi Kaleli haepaae ai fale ape. Térapa, dia̧ aipaae fupa, a̧ aimó kelaalopó, ” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ai fo deremó, kale sorape atima diri furu furu yóló kilita sókó furaalu, doutó taaróló botokó felepó. Atéró, kale sorape atima aso sókó feleteiné witepa, atimané kelale alarape me whi̧paae inipó. ");
INSERT INTO ppo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Fula kaae sere be dȩmó Yesu a̧ kepaayóló mo hi̧kati Maktala be sokó Maria daalemópi sókó walepó. A̧ta, take Yesuné wȩikeró dowi keperape betepa, ho̧konale sopó. ");
INSERT INTO ppo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Téró, Maria a̧ fóló, Yesutamo kwȩyale whi̧rape dekȩné sukuturaalu, molómó betó mupa, ama kelale ala fea atimapaae yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Téyalemó, atimané kale soné Yesu kepaayóló betepa kelalepóló ene wale fo wosóló, mopóló tuȩ́ tiki tirénipó. ");
INSERT INTO ppo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Téró nalomo, ama yó matere whi̧rapekó tamo whi̧, doasi be hulua taaróló, me tikipaae faai fu betalemó, Yesuné ama tiki mo kae daayóló, atimaamo fu betere tua̧mó sókó wóló, daapa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Atétepa, kelale whi̧ tamoné mepaae yó matere whi̧rapepaae a̧ mo kepaayóló beterapó fo ene walemókélé, mo dapóló atima tuȩ́ tiki tirénipó. ");
INSERT INTO ppo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Atéró, nalo Yesu a̧ ama yó matere 11 whi̧rape o̧la nuku beteremó sókó walepó. Atéró wóló, atimané a̧ mo kepaayóló beterapó dere fo wosóló, tuȩ́ tiki tiréni deremó, atima foné sóró duraalu, “Diaao̧ kutiri hapóluru dowa̧ae fóló, ȩ kepaayóló beterapóló ene wale fo wosóló, mopóló tuȩ́ tiki tirénitere noatepa de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Atéró, atimapaae duraalu, “Kótóné kaaróló beteró betere kae kae tiki daae mole so whi̧ feapaae i kale kisi fo wisi yó melaté kwȩyae. ");
INSERT INTO ppo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mepaae so whi̧ detamo tuȩ́ tiki tiróló bitu wȩi tóputepa, ti atétere so whi̧ aluyao̧sóró Kótóné tao saalotei, mepaae tuȩ́ tiki tirénire so whi̧ ti ama só deróló, dowi dupu melaalopó. ");
INSERT INTO ppo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Atéró, tuȩ́ tiki tiró betere so whi̧né etei kelemei alarape eraalo ai ape. So whi̧ tua̧mó betó mole dowi keperape ya̧lo doimó ho̧konótua yóo, kae kae be fo tuȩ́nirutei tuȩ́re whi̧né dere fo kaae yóo, whi̧ dele dowi wulirape naasené tatua yóo, hereikélé naalotei sukuni yóo, hepo daróló mole so whi̧né tikimó naase mulatepa wisi yóo, yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Atéró, Tale Yesuné atimapaae ai forape yóló kemetepa, Kótóné a̧ hepen-paae dapesó holóló, Talené ama turu naase dȩmó beteralepó. ");
INSERT INTO ppo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Atéró, ama yó matere whi̧rape atima hae kwia feapaae kale kisi fo wisi yó maté kwȩyaai felepó. Atima atéró yó maté kotere fo so whi̧né mo dapóló tuȩ́ muó̧póló, mepaae kelemei alarape eraaire fotoko̧ Talené atima tua̧paae mo su̧ralepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kótóné eraalopóló muló betere fo da̧ tua̧paae mo eró betepa, mepaae whi̧né kolóló asȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ai whi̧rape atima ko̧leaané asȩni, yale alarape mo kelale whi̧rapené deté wale fotóró yó maté wou betalepó. Ai whi̧rapeta, kale fo wisi kae fotamo hoseké erao̧sóró hotowayóló kaae taru, yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Mepaae whi̧rapené deté wale fo asȩyale kaae, mió ya̧lokélé ai fo wisiyóló taleyóló betemó kaae sóró, mo donotóró asȩyaai kisipa mutapó. Doa whi̧ Tiopilus-ó, take mepaae whi̧rapené ya̧paae yó melale fota, mo erapóló naao diriyóló tuȩ́ yaasepóló, ya̧lo i asȩtere ape. ");
INSERT INTO ppo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kale Judia hae kwia tȩteróló kaae tare topo whi̧ Herot betale alimó etéyalepó. So whi̧mó Talepaae momaratere whi̧ beta̧ beterepó. Ai whi̧ta, Lipai faketei, Abaijané deté wale whi̧ Sekaraiapó. Ama soma Elisabet-ta, momaratere topo whi̧ Eron-né deté wale sopó. ");
INSERT INTO ppo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kótóné keletómó atimaamo mo donoi soró whi̧tamo bitu, Kótóné yóló muló betere fo ao̧mó sukó̧ló, ama erae dere ala beta̧ eraté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Atéretei, kale so Elisabet atimaamo naale senaalekélé mei, ni daayóló betepa, sokélé sere yóo, whi̧kélé otere yóo yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Atéró betere tua̧mó Abaija fake whi̧rapené so whi̧mó momaró̧póló, tukóló muló betere be dȩmó Sekaraiaró ama fake whi̧tamoné momatere be kaae tarepó. Atéru, Sekaraia a̧ so whi̧mó momarótu betalemó etéyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","So whi̧mó momaratere whi̧rape atima mara mole ala sya furaalu, atimané doi mole ni fakerape fesekée deralemó, Sekaraiané doi mole ni fake dono fetée horóló muni dorowalepó. Atétepa, a̧ kale momatere be tua̧paae fóló, felé kȩlaa wale fetera kaae o̧la si keletómó biliyó̧póló, atimané a̧ sóró beteralepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Atéró, kale felé kȩlaa wale fetera kaae o̧la simó suku̧laa dalatere sukamó a̧ momatere be dolopaae fóló, simó terepetu betalepó. Atétu betepa, mepaae momayaai wale so whi̧ atima belamó kaae taru momatu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Até du betepa, Talené dotonale ensel wóló, kale felé kȩlaa wale o̧la bilitere tiki turu naase dȩró daapa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ai ensel sókó walemó, Sekaraia kilita sókó furaalu, mo winé sukutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tétepa, kale ensel-né a̧paae duraalu, “Sekaraia-ó, ya̧ wiyao̧se, naao du betale moma Talené wosalepó. Naao so Elisabet naale deyaalo ai ape. Téyaalopa, ama doi Jon mulae. ");
INSERT INTO ppo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ai naale detere kilituraalu, ya̧ doasi hai̧né sukó̧o, mo so whi̧kélé ai naale kilituraalu, hai̧né sukó̧o yóló Talepaae mo kée du betaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ti noatepae, Talené keletómó a̧ mo doasi whi̧ betaalopó. A̧ doayóló bitukélé, wain wȩiró topo doyóló keyaa fole wȩitamo naalomeipó. A̧ hamané depemó betepatei, kale Dȩi Kepe Wisi a̧ tua̧mó fa̧ayóló mo su̧ró betaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Atéru, take kó̧paae fu betere Israel fake so whi̧ atima tȩteróló kaae tare Kótó ao̧mó beteró̧póló, ai naalené momó dapesó waalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tale wó̧póló folosóró a̧pi wouraalu, ama yaaire alata, take betale whi̧ Ilaija a̧ keperó fotoko̧tamo fa̧anuraalu du betale ala kaae, ai sekȩ́ a̧ tua̧mókélé até yaalopó. Ai naale doayóló bitu, alimaraperó naale senaaletamopaae momó hosaa muó̧póló, atima tuȩ́ tiki feteraalo ai ape. Atéturaalu, mepaae Kótóné fo woseni dowa̧ae fu betere so whi̧ Kótóné donoi ala tua̧mó wisi kisipatamo beteró̧póló eraalopó. Atéturaalu, so whi̧ fea Tale beterepaae faaire ala amatei, donoróló beteraalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Atéró Sekaraiané ensel-paae duraalu, “Atei ala mo eraalopóló ya̧lo noayóló kisipa yaaloé? Ti ȩ otere yóo, ya̧lo sokélé sere yóo, erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tétepa, kale ensel-né a̧paae duraalu, “Ȩta Kótóné keletómó daalu i ala yae depa du betere ensel Kebriel-pó. Mió i dere fo wisi ya̧lo ya̧paae yó meló̧póló, ama ȩ ya̧ beterepaae dotonatepa wóló ya̧tamo fo i du betere ape. ");
INSERT INTO ppo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mió ya̧lo i dere fo wosóló kisipa tiki tiréni depa, ti naao fo aluyaalo ai ape. Ya̧ atépatei bitiré fóló, mió i dere fo dokonóló eratere sukamó ti naao fo momó yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Téró, Sekaraia momatere be dolopaae holóló betepa, belamó a̧ kaae tawóló betó mole so whi̧né duraalu, “A̧ mo taketi holaletei, diki du betere-a, noakó su bitu dérópó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Téró kale whi̧ a̧ belapaae dorowóló atimapaae fo yaairetei su̧ni, ama fo alureteiné naasené maaté du betepa, so whi̧né etei kisipa mualepó. Be tua̧mó Talené me alakó a̧paae nokené dere ala kaae eratepa kilitu yalepó du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Atéró, momatere be tua̧mó kutó diyó̧póló da̧le mulale be dȩ kemetepa, ama bepaae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ai alarape yale ki̧lipaae ama soma Elisabet naale yalepó. Atétepa, kale so a̧ kelao̧sóró ama bemó kinóló betepatei, wélié aporó kemeyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","A̧ atéró bitu duraalu “Take ȩ ni daapa so whi̧ feané faletu betaletei, mió i be dȩmó Talené ȩpaae erale wisi alané so whi̧ feané keletómó ya̧lo hale kemeralepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Téró, kale so a̧ naale yóló betepa, apomi wélié tua̧mó Kótóné ama ensel Kebriel, Kaleli haemó tȩne Nasaret be huluapaae dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Atéró, kale ensel Kebriel beta̧ so seimale Maria beterepaae felepó. Ai sota, Depit fake whi̧kó Josep-né dokaairaalu tukóló beteró beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Téró, kale ensel a̧ beterepaae fóló duraalu, “Talené hȩkesere so seimale-ó, Tale ya̧tamo ai betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Atei fo Mariané woseturaalu, etei kaae ko̧leó dere fo-a, noa betené dérópóló a̧ kisipa teketu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Até du betepa, kale ensel-né a̧paae duraalu, “Maria-ó, Kótóné ama ya̧ mo wisiyóló kolóló hosaa mutu, ya̧paae wisi ala eraai dapa, wiyao̧se. ");
INSERT INTO ppo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ya̧ta, naale yaalo ai ape. Ai naale detepa, ama doi Yesu mulae. ");
INSERT INTO ppo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A̧ doasi topo whi̧ betepa kilituraalu, so whi̧ feané mo ó taoró betere Kótóné Naalemapó du betaalo ai ape. Ai naaleta, take ama noumatere Depit bitu yale kaae, so whi̧ fea tȩteróló kaae tanó̧póló, Kótóné amatei a̧ doasi whi̧ sóró beteraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A̧ta topo whi̧ bituraalu, Jekop-né firale fakerape tȩteróló kaae tare ala kemekélé ini, ha̧le yótóró tawaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tétepa, Mariané ensel-paae duraalu, “Ȩta, whi̧tamokélé konipa, ai ala neyóló yaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ai fo depa, ensel-né a̧paae tokó̧ mótu duraalu, “Kale Dȩi Kepe Wisi ya̧ tua̧paae biti̧ waalopó. Téturaalu, mo ó taoró betere Kótóné fotoko̧né ya̧ tȩteróló husuró betaalo ai ape. Ai deyaaire naaleta, me dowi alakélé muni, mo kae naale detepa so whi̧ feané kilitu, ita Kótóné Naalemapó fo yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aita ya̧ maaté mei, naao kekelé so Elisabet-kélé seretei naale erapó. Upulé a̧ ni daapa mepaae so whi̧né atei serené naale deyaalomeipó dua yaletei, mió a̧ naale epa, apomiró wélié kemeyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ti fea ala fea Kótóné su̧mó enénipóló de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ai fo depa, Mariané a̧paae duraalu, “Ti ȩta Kótóné ama kutó diratere so beterapa, naao yale fotóró ama ȩpaae eró̧póló yae,” yalepó. Téró, kale ensel felepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Atéyale be dȩmótóró, Maria a̧ o̧la o̧la hapale sisóló ai be hulua taaróló, Judia du sorokó mole haemó tȩne be huluapaae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Atéró, kale so a̧ Sekaraiaró somatamo betere be dolopaae fóló, Elisabet-paae duraalu, “Fapa ko̧leó,” yóló apualepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mariané Elisabet-paae ai dere fo woseturaalu, Elisabet-né depemó betere naale toróyó̧ holalepó. Atéturaalu, Dȩi Kepe Wisi a̧ tua̧mó fa̧ayóló su̧ralepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Atéru Elisabet-né fo fakeyóló duraalu, “Sorape fea betó mupatei, ya̧ beta̧ Tale Kótóné mo wisiró beterapó. Atéturaalu, naao deyaaire naalekélé ama mo wisiró beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ȩ mé so wisi betepa, ȩ tȩteróló kaae tare Talené hama naao ȩ kȩle waleé? ");
INSERT INTO ppo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Naao ko̧leó dere fo woseturaalu, ya̧lo depemó betere naalekélé hȩkesené sukutu toróyó̧ holalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kótóné ya̧paae eraalopó yale fo wosóló, naao kisipa tiki tiralemó ya̧ wisiró beterapa, mióta ya̧ hȩkesené suka̧e,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Téró, Mariané duraalu, “Ya̧lo hosaa tua̧mó Talené doi hale sóró horatapó. ");
INSERT INTO ppo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ya̧lo hosaa turónékélé ȩ aluyao̧sóró tao sale Kótópaae mo kée yóló hai̧né sukutapó. ");
INSERT INTO ppo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ti ȩta, kutó diratere doi muni sókótei so betepatei, ama ȩ wisiyóló tao salepó. Mió i be dȩmó kaae sóró bitiré faaire so whi̧ feané ȩ kilituraalu, ita Kótóné wisiró betere sopó yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ti noatepae, mo doa fotoko̧ bole Tale Kótóné ȩmó mo doakale ala eralepó. Ama doi mo kae muluraalu, dowi ala mo beta̧kélé munire Talepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mepaae so whi̧ de Kótópaae winé sukó̧ló a̧ ao̧mó dua betepa, ama ko̧lené sukutere ala mió i alimó betere so whi̧paaekélé, take bitiré faaire so whi̧paaekélé, ha̧le yó tarapó. ");
INSERT INTO ppo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ama doasi bole fotoko̧né mepaae doasi alarape eralepó. Atéturaalu, mepaae whi̧ de atima kisipanétei duraalu, ‘Ȩta mo doasi sekȩ́ whi̧ beterapóló,’ bopé faketu betale whi̧rape dapo dapo yóló fó̧póló, ho̧kó faralepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mepaae tȩteróló kaae tare doasi topo whi̧rapené kaae tare alarape ama kemeróló, haepaae só deróo, mepaae naameyóló sókótei betere so whi̧ ama sikipaae horóo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mepaae wotené sukutere whi̧rape ama o̧la wisi melóló hairóo, mepaae o̧la o̧la dekéró mole néli so whi̧ ha̧le fó̧póló dotonóo, dua yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ama kutó diratere Israel fake whi̧rape kisipa keteréni, ko̧lené sukuturaalu, atima tao sere ala ha̧le yó tarapó. ");
INSERT INTO ppo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Talené Abraham-ró ama deté faaire naaletamopaae wisi ala eraalopó yóló mulale fo keteréni, da̧né ayarapepaaekélé eralepó. Atéyale kaae, mió i alimó da̧paaekélé ama ko̧lené sukutere ala ha̧le yó tarapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Téró, wélié soremó Maria a̧ Elisabet-tamo beteró, nalo ama bepaae fesaae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Téró etéyalepó. Kale so Elisabet a̧ naale saaitere be dȩmó ama naale dealepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tale Kótóné doasi ko̧lené sukuturaalu, a̧paae erale alamó Talepaae mo kée yóló doasi hȩkese yalepó. Atétepa, ama be whi̧ so whi̧ró kekelé so whi̧tamokélé ama dere hȩkese kaaetóró du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Atéró kale so naale sóró beteró, bokó wale be dȩmó ama tiki sekaȩ tukóló siriróo, kale naalené doikélé alima Sekaraiané doi yakoróo yaai, ama fake so whi̧ walepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Até yaaitepa, ama hama Elisabet-né duraalu, “Meipó. Ama doita, Jon mulaai dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ai fo depa, atimané a̧paae duraalu, “Ya̧ fake whi̧kó mo beta̧kélé atei doi munipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ti fo depa, atimané alimapaae naasené maaté yóló duraalu, “Naao kisipané a̧ de doi mulaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tétepa, ama atimapaae naasené maaté yóló duraalu, asȩtere sóku sóró ape depa, sóró walepó. Atéró, ai kale sóró wale o̧la tómó Jon doi asȩyalepó. Ai doi asȩtere kilituraalu, so whi̧ feané haió yóló, sirayalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Até yaletamotóró Sekaraia a̧ fo aluretei momó duraalu, Kótóné doi hale sóró horalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Atimaamoné be felekemó betó mole so whi̧né atétere ala kilitu, me ala kae dapóló winé sinalepó. Du sorokó mole Judia hae kwiamó betó mole so whi̧ feapaae i ala yalepóló deté kwȩyóló fakeralepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mepaae i fo wosale so whi̧né “I naaleta, Tale Kótóné mo doasi fotoko̧ bete a̧ tua̧mó mupa kilitu, take doayóló a̧ noa kaae whi̧ betaalorópó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","68","Kale naale Jon-né alima Sekaraia Dȩi Kepe Wisiné fotoko̧ratepa, Kótóné a̧paae yae depa mo so whi̧paae duraalu, “Da̧né Talené doi hale sóró horaalopó. Israel fake so whi̧ tȩteróló kaae tare Kótópaae mo kée du betae. Ti noatepae, da̧ ama so whi̧póló dupuró beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ama kutó diratere whi̧ Depit-né firale fake tua̧mó Kótóné whi̧ beta̧ sóró beteró beterapó. Ai sekȩ́né ama fotoko̧né da̧ i hae so whi̧ aluyao̧sóró tao saalopó. ");
INSERT INTO ppo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ti mo take Kótóné ama kae beteró betere ko̧ló whi̧rapené yale fo mo dokonóturaalu yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Da̧ bóe whi̧ kuamó betepa, ama tao saalopó. Téturaalu, mepaae whi̧né dowi kisipa muóló da̧tamo bóe dupa, ama fotoko̧né sesé yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Da̧né ayarape ama kisipa keteréni, ko̧lené sukuturaalu mió da̧ tao saaire whi̧ dotonaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ti aita ha̧le mei, Kótóné da̧né aya Abraham-paae i ala eraalopóló mo dirii fo yóló muló betereteinépó. ");
INSERT INTO ppo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Take ai yóló muló betere fo dokonóturaalu, bóe whi̧rapené da̧ dóló tȩterao̧sóró, tao sóró beteró beterapó. Atérené mió da̧ wikélé ini, halaainé Kótóné kutó beta̧ dirótu betenérapó. ");
INSERT INTO ppo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ti betere doko̧ fea da̧ ama keletómó ama kae ere alaró mo donoi alatamo tua̧mótóró betó tawaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ya̧ta, ya̧lo naalepó. Take nalopaae so whi̧ feané ya̧ kilituraalu, mo taoró betere Kótóné ama ko̧ló whi̧pó yaalopó. Ti Tale waaipa ya̧pi folosóró wouraalu, a̧ waaire tu̧ donorae yaaire whi̧ betaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Téturaalu, Kótóné ama so whi̧né dowi alamó melaaire kwia aluróló tao saaire ala naao atimapaae yó melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ti Kótóné ko̧le dere ala ama hosaa tua̧mó fa̧aneteiné ai ala eraalopó. Ti atéyaaire alata, hi̧ka teó sokotere suka da̧né tikimó felétu dere kaae, Kótóné ama hepen-mó ere dȩ da̧ betere tua̧paae eraalopó. ");
INSERT INTO ppo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ti aita, noa yaai mei, mepaae diliki tua̧mó betó mole so whi̧ró mo felekemó suka̧ai du betere so whi̧tamo Kótóné hosaa muni deyóló dua betere ala tua̧paae biti̧ fó̧póló, ai dȩné yó melaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Atéró, kale naale a̧ doaturaalu, ama kepe tua̧paaekélé doasi fotoko̧ bualepó. Atéru, a̧ Israel so whi̧ beterepaae ha̧kearóló sókó waairaalu, so whi̧ bitini ha̧le wópu tikimó bitiré felepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ai alarape du betale tua̧mó etéyalepó. Rom Gavman topo whi̧ Sisa Akastus-né i hae kwiamó betó mole so whi̧ doi siré kwȩyae yóló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Atéró so whi̧ doi saleteita, Siria hae kwia Kwirinius-né tȩteróló kaae tapa, folosóró kaae sutóró yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Atétepa, kale so whi̧ mo fea doi só̧póló, atimané turuku be séle sélepaae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Atétepa, Josep a̧ Depit-né deté wale whi̧ ereteiné Kaleli hae kwiamó tȩne Nasaret be taaróló, Judia haemó tȩne Depit-né be hulua Betelehem-paae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ama dokaai tukóló beteró betere so Maria naale epa, atimaamoné doikélé mulaai felepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Atéró fóló, atimaamo ai bemó betepa, kale so naale saaire be dȩ sókó walepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ai be dȩmó kale soné ama topo naale deyalepó. Atéró, kale naale kutiné bope yóló hupurape o̧la melótua dere ni fakené aleyale nuku tómó beleró beterepó. Ti noatepae, uké wale so whi̧né fitere be fa̧aneteiné yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Téró etéyalepó. Ai hae kwiamó mepaae sipsip hupu kaae tare whi̧rape ai be hulua taaróló, ne yó molepaae fóló, dikitamo atima hupurape kaae tawóló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Atéró beteremó, Talené ensel beta̧ atima betere tikimó sókó wouraalu, Talené ama ere doasi dȩné atima betere tikikélé dȩyó felepó. Atéteremó atima fea winé sukutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Atétepa, kale ensel-né atimapaae duraalu, “Dia̧ wiyao̧se, ȩta i hae kwia feamó betó mole so whi̧né wosóló doasi hai̧né suka̧aire fo wisinaale ene walepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dia̧ i haemó betó mole so whi̧ aluyao̧sóró, tao saaire whi̧ mió i be dȩmó Depit-né be huluamó ai deyale ape. A̧ta, Kótóné so whi̧ fea tȩteróló kaae tanó̧póló, sóró beteró betere Kerisopó. ");
INSERT INTO ppo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dia̧ fóló kelenalemó, miótóró deale naale kutiné bopeyóló hupurape o̧la melótua dere ni fakené aleale o̧la tómó beleró betepa kilituraalu, ita kale bope yale naale hi̧tipó yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Atéró, mo tétitóró kale ensel beta̧ daalepaae ó hepen bemó betó mole ensel-rape mo ha̧le o̧la kaae dorowóló daae mulu, Kótóné doi hale sóró horótu duraalu, “Mo taoró betere Kótóné doasi mole doi hale sóró horae. Kótóné ama tuȩ́né wisi ala eraaitere so whi̧paae hosaa muni deyóló mo dua betere ala eró̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kale sipsip hupu kaae tare whi̧rape betó mupatei taaróló, ensel-rape hepen-paae fesaae holalepó. Atétepa, kale whi̧rape atimasisi duraalu, “Talené da̧paae yó melale ala kelaai, Betelehem be huluapaae faalopa fiépe,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Atéró, atima hapale fóló Mariaró Josep-tamo betóo, kale naalekélé hupurape o̧la melótua dere o̧la tómó firóo, epa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Atimané kale naale kolóló ensel-rapené atimapaae yale fo so whi̧ feapaae deté kwȩyóló fakeralepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ai fo depa wosale so whi̧ feané ita, noa kaae fo yalerópóló, sirayóló tuȩ́ teketu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Até du betepatei, Mariané ai dere fo wosóló, ama hosaamó muló bitu kisipa ha̧le yó tarepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Téró, kale sipsip hupurape kaae tare whi̧rape atima bepaae fesaae furaalu, kale ensel-rapené atimapaae i ala epa kelaalo ai ape, yale ala motóró epa kelaleteiné Kótóné doi hale sóró horaté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Atéró kale naale sóró bitiré fóló, bokó wale be dȩmó ama tiki siriróló Yesu doi mulalepó. Aita kale so naale yaaipatei, ensel-né mulae yale doipó. ");
INSERT INTO ppo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moses-né asȩmó soné naale sale tiki Talené keletómó wisiyó̧póló, kaae tawae ere be dȩ kemetepa, Josep-ró Mariatamo kale naale Talepaae melaai dapóló, Jerusalem bepaae dapesó felepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Aita ha̧le meipó. Talené fo tua̧mó “Topo naale Talepaae melae,” ere fo sya furaalu yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Téró, me ere fo i ape. “Beta̧ soné naale senaale detepa, kale soné naale ditu yale ala Talené wisiró̧póló, ba ho̧kósere tamo ó sukusi tamo Talemó melae,” ere fo sya furaalu atéyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Até yale sukamó, Jerusalem bemó whi̧ beta̧né doi Simeon beterepó. A̧ta, mo donoyóló bituraalu, Kótóné ala beta̧ erótu betale whi̧pó. Atéró, kale Israel fake so whi̧ dowi sekȩi ala tua̧mó betepa, tao saaire whi̧ wó̧póló, kale Dȩi Kepe Wisi a̧tamo beta̧mó beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A̧paae kale Dȩi Kepe Wisiné etei fo yóló munélipakalepó. Ya̧ hapale sukuni, Talené sóró beteró betere whi̧ Keriso kolóló suka̧alo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Atéyale sukamó, Simeon otere Dȩi Kepe Wisiné fotoko̧ratepa, momatere be tua̧paae fóló beterepó. Atéró beteremó, kale yóló muló betere foné yae ere ala yaairaalu, hamaró alimatamoné Yesu apuóló momatere bepaae sókó walepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Atéró wapa, kale Simeon oterené kale naale tao sóró ama naase tómó beleróló, Kótóné doi hale sóró horótu duraalu, ");
INSERT INTO ppo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O̧la o̧la fea tȩteróló kaae tare Tale-ó, naao kale yóló mulale fo mió mo dokonatereteiné naao kutó diratere whi̧ sukutepa, hosaa muni deyóló dua fó̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Ti noatepae, naao so whi̧ aluyao̧sóró, tao saaire ala so whi̧ feané keletómó donoróló muló betepa mió ya̧lo i keletere ape. ");
INSERT INTO ppo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ai dȩné Juda mei, kae fake so whi̧ tua̧paae Kótóné ere ala ha̧kearatepa kolóló tuȩ́ yóo, Israel fake so whi̧kélé doasi doi sóo, yaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Téró, kale naale hamaró alimatamoné Simeon oterené yale fo wosóló, haió i yale fo-a, noa betené yalerópóló siratu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kale Simeon oterené atima wisiratere fo yóló, hama Mariapaae duraalu, “I naalenéta, Israel fake so whi̧ fea haepaae só deróo, mepaae so whi̧ tao sóró sikipaae horóo, yaalopó. Atétere ala kilituraalu, Kótóné hiróló mole ala so whi̧ feapaae ha̧kearóló yó matepa, mepaae so whi̧né ai dere fo wosaalomeipóló, a̧ só deraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Atétere alané mepaae so whi̧né hosaa tua̧mó mole tuȩ́ tiki ha̧keamó mulaalopó. Atéteremó, sepake kwia kaaené naao hosaamó deyaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Aimó Kótóné ama beta̧ ko̧ló so wulia Aser fakekó Fanuel-né senaalema Anakélé beterepó. Ama whi̧tamo dokóló betepa wȩikeró ba fo kemeyóló, oma sukutepa wulia bitu kemeyale ba fotamo touróturaalu 84 ba fo biti serepó. Atéró Kótópaae kisipa tiró bitu, momatere be taaréni, dikitamokélé, dȩtamokélé, moma dere ala ha̧le yó tarepó. Atéru, a̧ o̧la weyóló bitu, moma dere ala beta̧ dua yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Téró ai fapotóró kale so Ana atima beterepaae sókó wóló Kótópaae mo kée yóló, Jerusalem bemó betó mole so whi̧ aluyao̧sóró dupuróló tao saaire whi̧ wó̧póló kaae tare so whi̧paae kale naale i ape yóló yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Atéró, Josep-ró Mariatamoné Talené yae yóló muló betere alarape yóló kemetepa, Kaleli haemó tȩne atimané diri Nasaret be huluapaae momó fesaae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kale naale a̧ doaturaalu, mo doasi fotoko̧ buóo, tuȩ́ tiki dotoróȩ fóló fosó fosó yóo, Kótóné a̧paae hosaa muóló yaala sókó fóo erapó. ");
INSERT INTO ppo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Téró etéyalepó. Kale bosenée fele be dȩ sókó wapa o̧la deteremó, ama hamaró alimatamo ba fo doko̧ fea Jerusalem be huluapaae fua yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kale naale doayóló 12 ba fomó betepa, atima dua dere kaae, o̧la detere sukamó atimaamo Jerusalem be huluapaae holalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kale bosenée fele be dȩmó o̧la detere ali kemetepa, ama hamaró alimatamo bepaae fesaae furaalu, kale naale Yesu Jerusalem bemó betepatei, fole so whi̧tamo fele nisiyóló atimaamo felepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Téró kale soró whi̧tamoné kisipané so whi̧tamo fole nisiyóló atimaamokélé fu betepa, be dȩ beta̧ kemeyalepó. Atéró fóló kale naale atimaamoné fake so whi̧ró fulumu whi̧rapetamo betere tikimó keka̧lepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Até yalemó bitinipa, keka̧ai Jerusalem be huluapaae momó fesaae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Atéró kekitu betepa, be dȩ sore ha̧le kemeyóló nalo kale momatere be bopére tipi tua̧mó betepa kelalepó. Atéru, mepaae Juda yó matere whi̧rapené dere fo wosóo, mepaae wosetere forapekélé yóo du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kale naale atéró kisipa fosó fosóru atimané a̧paae wosetere fo mo donotóró tokó̧ matepa woseturaalu, whi̧rape feané siratu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Atétere ala hamaró alimatamoné kilitu, atimaamo kilita sókó fóló hamané a̧paae duraalu, “Ti naale-ó, ayanaao da̧mo ya̧ whaalia depa keka̧le supa, noatepa atei kaae ala yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ti fo depa, atimaamopaae duraalu, “Ya̧lo ayané ȩ beteró̧póló ere bemó fóló beteretei diaamo tuȩ́ iniru ȩ kekenapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ama ai yale fo bete atimaamoné diriyóló wosóló kisipa sinipó. ");
INSERT INTO ppo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Téró, kale naale ama hama alimatamo Nasaret be huluapaae fóló, atimaamoné dere fo beta̧ wosóló ao̧mó sukó̧ló beterepó. Téruraalu, Yesuné ama yale fo fea hamané kisipa keteréni, ama hosaamó muló beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Téró, Yesu a̧ teó doatutei kisipa tiki dotoróȩ fóló, fosó fosói naale wisi doatepa Kótónékélé, mo so whi̧nékélé, hȩsekeyóló a̧paae hosaa mualepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taiperius Sisa 15 ba fo tua̧mó a̧ topo whi̧ bituraalu, Rom hae kwia mo fea ama tȩteróló kaae tarepó. Atéyale sukamó, Pontias Pailat a̧kélé doasi Gavman topo whi̧ bitu, Judia hae kwia tȩteróló kaae tawóo, Herot a̧kélé doasi topo whi̧ bituraalu, Kaleli hae kwia tȩteróló kaae tawóo, ama noma Filip-né Ituraea hae kwiaró Trakonaitis hae kwiatamo tȩteróló kaae tawóo, Lisanias a̧ doasi topo whi̧ bitu, Abilene hae kwia tȩteróló kaae tawóo, erepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas-ró Kaiapas-tamo Kótópaae momaratere doasi topo whi̧ betere sukamó, Sekaraiané naalema Jon whi̧ bitini wópu mole tikimó betepa, Kótóné fo a̧ tua̧paae sókó walepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Atéró, Jon a̧ Jordan wȩi fole hae kwiamó tȩ mole be hulua doko̧paae fóló, fo yó mótu betalepó. Atéró, Kótóné fo yó mótu duraalu, “Diaao̧ du betere dowi ala taaróló, Kótópaae kisipa tiki feteyóló ape. Atétepa, ya̧lo dia̧ wȩi tópuraalo ai ape. Diaao̧ dowi alamó saaire kwia Kótóné me o̧la meipóló, ha̧le kemeraalo ai ape,” deté kutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mo take betale Kótóné ama ko̧ló whi̧ Aisaiané asȩyóló muló betere fo mo donotóróti yalepó. Ai fo i ape. “Whi̧ beta̧ ha̧le wópu mole tikimó bitu fo fakeyóló duraalu, ‘Tale waaire tu̧ aleyae, a̧ waaire tu̧ donorae. ");
INSERT INTO ppo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tukwȩ derepale tiki, hae mulóló wisirae. Doasi hasi uluró du sokoreteitamo duki̧yóló mulurae. Wȩ́ wȩ́re tu̧kélé, mo donoyóló aleyae. Kapo ó hapisa̧a muóló dore tu̧ duki̧yóló taae faróló wisirae. ");
INSERT INTO ppo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Até depa, ti Kótóné so whi̧ fea aluyao̧sóró tao saaire ala wisi so whi̧ mo feané kelaalo ai ape,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","So whi̧ mo fea Jon-né wȩi tópuró̧póló a̧ beterepaae wua depa, atimapaae duraalu, “Diaao̧ dere alata, wuliné tu̧ kotere kaae dapó. Kótóné dia̧tamo fopaae butu taleyao̧sóró, mopaae botokó faai de? ");
INSERT INTO ppo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Dia̧ dowi ala taaróló kisipa feteyóló tu̧ wisipaae fulapó du betere fo, ha̧keamó motóró du betae. Ti noatepae, Abraham-ta diaao̧ ayapó du betere fomó ya̧lo dia̧paae i dere ape. I muó mole kapo fakerape Kótóné whi̧ aleyóló, Abraham-né naale senaale beteranérapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Talené ka̧wei ni bete doko̧ taketi muló beterapó. Mepaae ninétamo du wisi olenitepa, ti ai nirape fea diyóló sipaae taae deraai Talené ama to̧ ai ni betemó bukó tarapó.” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ai fo depa so whi̧ feané a̧paae duraalu, “Ti da̧né noa alakó yaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ti fo depa Jon-né atimapaae duraalu, “Me whi̧ dené kuti tamo deró betepa, me kuti sokóló ya̧ya̧re whi̧ melae. Whi̧ me dené o̧la hu̧yóló mupa, ti aikélé beta̧ kaae alatóró yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mepaae takis moni siré kotere whi̧rape atimakélé wȩi tópuaai dapóló wóló a̧paae woseturaalu, “Yó matere whi̧-ó, da̧ noa alakó yaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tétepa, ama atimapaae duraalu, “Diaao̧ takis moni siré kutu, bosenóló sini, sae yale su̧tóró sae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ti fo depa, mepaae diki tare whi̧rape wóló a̧paae woseturaalu, “Da̧ noa ala yaaloé?” depa ama duraalu whi̧né moni saai, so whi̧ tȩteréli fo yóló ó dilikó̧ló sao̧se. Naao Gavman-né dia̧ matere moni-tóró tawóló betae. I su̧ meipóló, dokó dokó yao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","So whi̧ feané Jon kilituraalu, i sekȩ́ Kótóné sóró beteró betere whi̧ Keriso du yalepóló, tuȩ́ tekitu betalepó. Ti noatepae, atima Keriso mo kelaai kisipa mutu betaleteinépó. ");
INSERT INTO ppo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Até du betepa, Jon-né atimapaae tokó̧ mótu duraalu, “Ya̧lota, dia̧ wȩi maaté tópuratapó. Téteretei, mo doa sekȩ́ whi̧ beta̧ waalo ai ape. A̧ta ȩ kaae meipó. Ȩ a̧ ao̧mó naale beleka̧amale kaae betereteiné ya̧lo ama hó be dokore képi teraayaairetei mo su̧nipó. Amata, kale Dȩi Kepe Wisiró sitamoné dia̧ wȩi tópuraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ama naasené whit beta̧paae eróló kane fake kaae o̧la tómó mulóló, fumi besȩ́né só fó̧póló epeyóló horatere o̧la tarapó. Tétu, mo whit-ta beta̧paae eróló mulótu beterapó. Whit fumita, mo sukó̧kélé feni ha̧le dó tare sipaae taae deraalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Atéró, Jon-né kale mió wosetere kisi fo wisi so whi̧ feapaae yó melóturaalu, so whi̧né kisipa tiki feteraaire forapekélé, yó melótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tétu betaletei, kale doasi Gavman topo whi̧ Herot-né noma Filip-né sotei a̧ dokóo, mepaae kae kae dowi alarape yóo, du betalepó. Até du betepa, Jon-né Herot-paae atei alarape taalae yóló, foné salepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herot-né take yale alarape tómó, me i alakélé yalepó. Kale Jon dipula beteralepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Atéyale sukamó, Jon-né so whi̧ fea wȩi tópuróturaalu, Yesukélé wȩi tópuralepó. Atéró a̧ momatu beteremó, ó hepen be tu̧ tukwȩ fóló molepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Atépa, kale Dȩi Kepe Wisi ba ho̧kósere kaae Yesuné tikimó biti̧ dorowalepó. Até deretamo, hepen beró fo fakeyóló duraalu, “Ya̧ta, ya̧lo Naalepó. Naao dere ala wisi kilituraalu, ȩ mo doa hȩkesené sinitapó. Ti ya̧ta ya̧lo mo yaala sókó fóló mole Naalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Téró etéyalepó. Yesu a̧ kutó kaae saai betale sukamó, 30 ba fo beterepó. A̧ atéró betepa so whi̧né a̧ta, Josep-né naalema nisi yalepó. Josep-ta, Heli-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli-ta, Matata-né naalemapó. Matata-ta, Lipai-né naalemapó. Lipai-ta, Melki-né naalemapó. Melki-ta, Janai-né naalemapó. Janai-ta, Josep-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep-ta, Matatias-né naalemapó. Matatias-ta, Amos-né naalemapó. Amos-ta, Naham-né naalemapó. Naham-ta, Esli-né naalemapó. Esli-ta, Nakai-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai-ta, Mat-né naalemapó. Mat-ta, Matataias-né naalemapó. Matataias-ta, Semen-né naalemapó. Semen-ta, Josek-né naalemapó. Josek-ta, Joda-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda-ta, Joana-né naalemapó. Joana-ta, Resa-né naalemapó. Resa-ta, Serubabel-né naalemapó. Serubabel-ta, Sealtiel-né naalemapó. Sealtiel-ta, Neri-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri-ta, Melki-né naalemapó. Melki-ta, Adi-né naalemapó. Adi-ta, Kosam-né naalemapó. Kosam-ta, Elmadam-né naalemapó. Elmadam-ta, Er-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er-ta, Josua-né naalemapó. Josua-ta, Elieser-né naalemapó. Elieser-ta, Jorim-né naalemapó. Jorim-ta, Matata-né naalemapó. Matata-ta, Lipai-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lipai-ta, Simeon-né naalemapó. Simeon-ta, Juda-né naalemapó. Juda-ta, Josep-né naalemapó. Josep-ta, Jonam-né naalemapó. Jonam-ta, Eliakim-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim-ta, Melea-né naalemapó. Melea-ta, Mena-né naalemapó. Mena-ta, Matata-né naalemapó. Matata-ta, Natan-né naalemapó. Natan-ta, Depit-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Depit-ta, Jesi-né naalemapó. Jesi-ta, Obed-né naalemapó. Obed-ta, Boas-né naalemapó. Boas-ta, Salmon-né naalemapó. Salmon-ta, Nason-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason-ta, Aminadab-né naalemapó. Aminadab-ta, Atimin-né naalemapó. Atimin-ta, Arni-né naalemapó. Arni-ta, Hesron-né naalemapó. Hesron-ta, Peres-né naalemapó. Peres-ta, Juda-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda-ta, Jekop-né naalemapó. Jekop-ta, Aisak-né naalemapó. Aisak-ta, Abraham-né naalemapó. Abraham-ta, Tera-né naalemapó. Tera-ta, Nahor-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor-ta, Seruk-né naalemapó. Seruk-ta, Reu naalemapó. Reu-ta, Pelek-né naalemapó. Pelek-ta, Eber-né naalemapó. Eber-ta, Sela-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela-ta, Kainan-né naalemapó. Kainan-ta, Arpaksat-né naalemapó. Arpaksat-ta, Sem-né naalemapó. Sem-ta, Noa-né naalemapó. Noa-ta, Lamek-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek-ta, Metusela-né naalemapó. Metusela-ta, Enok-né naalemapó. Enok-ta, Jared-né naalemapó. Jared-ta, Mahalalel-né naalemapó. Mahalalel-ta, Kainan-né naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan-ta, Enos-né naalemapó. Enos-ta, Set-né naalemapó. Set-ta, Adam-né naalemapó. Adam-ta, ti Kótóné naalemapó. ");
INSERT INTO ppo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu a̧ Dȩi Kepe Wisi fa̧ayóló su̧ruraalu, Jordan wȩi taaróló wapa, Dȩi Kepe Wisiné a̧ whi̧ bitini, ha̧le wópu mole tikipaae a̧lisóró felepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A̧ aimó betepa, dowi Satan-né a̧ dée nó̧póló, su̧ sere alarape deté fu betepa 40 be dȩrape kemeyalepó. Atéyale be dȩmó a̧ o̧lakélé néni wote siri bitiré fóló, kemene folepaae a̧ wote yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Atéró betepa, dowi Satan-né a̧paae duraalu, “Ya̧tamo Kótóné Naalemapata, ti i kapopaae bred o alée fae yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ai fo depa Yesuné a̧paae duraalu, “Tale Kótóné asȩmó i fo erapó. ‘So whi̧ betereteita, mo o̧la maaté nukuraalu bitinipó erapó,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Atéró, kale dowi Satan-né a̧ mo ópaae hore dupaae dapesó holóló daalu, i hae kwia doko̧ tȩteróló kaae tare alarape fea a̧paae tétitóró hapale yó melalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Téró, a̧paae duraalu, “Ya̧lo ya̧mó doasi doi muaaire alaró i haemó muó mole wisi wisi alatamo naao tȩteróló kaae tawaasepóló melaalopó. Ti noatepae, take ȩpaae matepa taretei, mepaae ya̧lo kisipa mole whi̧rape melaai depa, ti su̧mó manérapó. ");
INSERT INTO ppo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ya̧lo i dere fotamo naao beta̧ wosóló ȩ ao̧mó bitu, doa Tale-ó depa, ti i o̧la o̧la fea naaotóró tȩteróló kaae tawaasepóló melaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ti fo depa, Yesuné a̧paae duraalu, “Kótóné asȩmó ere fo i ape. ‘Tale Kótó mo beta̧tóró beterapa, a̧ ao̧mó sinóló bitu, Aya doa Tale-ó, yóló ama ala beta̧ erótu betae erapó,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Téró, kale dowi Satan-né Jerusalem bemó tȩne momatere be hulua tómó dapesó holóló daaló bitu duraalu, “Ya̧tamo Kótóné Naalemapata, ti haepaae tu̧ó derepae. ");
INSERT INTO ppo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ti noatepae, asȩmó i fo erapó. ‘Kótóné ama ensel-rapepaae ya̧ me o̧lané doalé yao̧sóró, wisiyóló kaae tawae yaalopó.’ ");
INSERT INTO ppo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Me fo i ape. ‘Ya̧ atimané naase tómó muni durupuraalu, me o̧lané ya̧ kotóo sóró doalé yaalomeipó,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ai fo depa, Yesuné kale dowi Satan-paae duraalu, “Asȩmó i fokélé erapó. ‘Naao Tale Kótóné ya̧ tao sirémóló ka̧ae kolóló su̧ sao̧se,’ erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Atéró, kale dowi Satan-né Yesu dée nó̧póló su̧ sale ki̧lipaae me tȩ mutere sukamó momó su̧ saai dapóló taaróló felepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Atéró, Yesu kale Dȩi Kepe Wisiné fotoko̧ratepa, a̧ Kaleli hae kwiapaae momó fesaae felepó. A̧ atéró wóló beterapó dere fo ai hae kwiamó betó mole so whi̧ feapaae deté kwȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Atéró, a̧ ai hae kwiamó bituraalu, atimané fo wosetere be doko̧ fo yó maté kotopa, so whi̧ feané ama doi hale sóró horótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Take a̧ doayóló betale Nasaret be huluapaae fóló bituraalu, kale sa̧a nokole be dȩmó ama dua dere kaae, fo wosetere be dolopaae holalepó. Atéró, Kótóné asȩmó ere fo dosa̧ayaairaalu turukó holalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kótóné ama ko̧ló whi̧ Aisaiané asȩre buku bopeyóló moletei, ama dosa̧ayó̧póló, whi̧ mené a̧paae melalepó. Tétepa, ai buku sóró da̧ae faróló, ama tuȩ́ mole fo keka̧lemó keletepa dosa̧ayale fo ipó. ");
INSERT INTO ppo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Talené ama Dȩi Kepe Wisi ȩ tua̧mó beteró beterapó. Ti aita ha̧le mei, ama kale fo wisi so whi̧paae yó meló̧póló ȩ sóró beteralepó. Atéru, dipula kaae betere so whi̧ ha̧le fó̧póló dotonóo, kele dilikire so whi̧né kele fisa̧ae falóo, mepaae wae sóró sonaalei ala tua̧mó beteró betere so whi̧ sokóló ha̧le beteróo yó̧póló, ȩ dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Talené so whi̧ wisiyóló beteró̧póló, ama ko̧lené sukutu hamokoróló ha̧le tao sere ali i wale ape fo so whi̧paae yó̧póló, ȩ dotonalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Téró, Yesuné kale fo̧loi buku momó bopeyóló kaae tare whi̧paae melóló, a̧ biti̧ deyalepó. Atéró betepa, ai fo wosetere be dolomó betó mole so whi̧ feané a̧paaetóró kele fopolaa yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Téró, ama atimapaae momó duraalu, “Mió diaao̧ wosale asȩmó yóló muló betere fota, motóró dokonalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ama yó matere fo wosale so whi̧ feané i whi̧né ko̧lómó mo koko̧i fo wisinaale dapóló, siratu betalepó. Tétu atimasisitei duraalu, “Ita, Josep-né naalema meié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ai fo depa, Yesuné atimapaae duraalu, “I mara mole fo diaao̧ ȩpaae mo enérapó. ‘Dokta whi̧-ó, naaotei ya̧ tikimó daale kisi bete wisirótimié? Ti Kapeneam be huluamó du betere alarape da̧né wosalepa, umó erótu betale ala kaae naao i turuku bemókélé erótumié?’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Atéró ama atimapaae momó duraalu, “Ya̧lo dia̧paae mo i dere ape. Kótóné ko̧ló whi̧né ama be whi̧ so whi̧paae Kótóné fo i ape yóló yó matepa, atimané mo dapóló wosetimipó. ");
INSERT INTO ppo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ya̧lo dia̧paae mo i dapa wosae. Mo take Israel haemó Ilaija betale alimó mepaae sorape atimané whi̧ sukó̧ló wulia betó molepó. Ai sukamó ba fo sorené wélié apo mirómó hali kinó betepa, hae kwia feamó o̧la sóku aluyóló, wote ali walepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Téyaletei, Kótóné Ilaija dotonaleteita, mo beta̧ Israel fake sorapekó tao só̧póló dotonénipó. Ténitei, Saidon hae kwiamó tȩne Sarepat be huluamó betere beta̧ wulia so tao sene fó̧póló dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Téró, Kótóné ama ko̧ló whi̧ Elaisané Israel hae kwiamó dowi humu fuluné tiki doyóló betó mole so whi̧ mo beta̧kélé wisirénipó. Israel hae kwiamó atei kaae whi̧rape betó mupatei, mo beta̧kélé wisiréni, Siria hae kwiamó betere whi̧kó Naaman maaté wisiralepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ai kale fo wosetere be dolomó betó mole so whi̧ mo feané ama ai dere fo wosóló, atima doasi fopaae bualepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Atéró atima hapale turukó huturaalu, a̧ belapaae ho̧kó deralepó. Téró, ai be hulua felekemó ere kulapaae taae deraai dapóló dapesó felepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Téyaai depa, ai touró betere so whi̧ kua dolomótei sókótamo yóló, ama faai yale tikipaae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Téró, Yesu a̧ Kaleli hae kwiamó tȩne Kapeneam be huluapaae derepelepó. Aimó bituraalu, kale sa̧a naai tukóló muló betere be dȩmó so whi̧ feapaae ama fo momó kaae sóró yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ama ai yó matere fo so whi̧ feané woseturaalu, sóró beteró betere topo whi̧né fo kaae dapóló, siratu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ai fo wosetere be dolomó dowi keperape tepeyóló betere whi̧ beta̧ beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ai sekȩ́né fo fakeyóló duraalu, “He! Nasaret be hulua whi̧kó Yesu-ó, naao da̧paae noa alakó eraai waleé? Naao da̧ doraai waleé? Ya̧ta, me dowi alakélé muni, Kótóné mo kae beteró betere whi̧póló, ya̧lo kisiparapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ai fo depa, Yesuné kale dowi kepe foné sóró duraalu, “Fo taaróló ya̧ ai whi̧ tua̧mó beteretei, sókó ape,” yalepó. Ti fo depa, dowi kepe kale whi̧ tua̧mó betaletei, so whi̧ feané keletómó ama tiki haepaae taae deróló a̧ sókó felepó. Atéyaletei, kale whi̧ a̧ doalékélé inipó. ");
INSERT INTO ppo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Atétere ala so whi̧ feané kolóló, sirayóló atimasisitei duraalu, “I whi̧né yó mótu betere fota, mo kaepó. Ti ama fota, doasi fotoko̧tamo yó matepa, dowi keperapenékélé ama dere fo mo beta̧ wosóló, ai sókó fulapa, kelae!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesuné i ala du beterapó fo, ai hae kwiamó betó mole so whi̧ mo feapaae deté kwȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu a̧ ai fo wosetere be taaróló, Saimon-né bepaae felepó. Ai bemó kale Saimon-né auma sere tiki suputere kisiné sinóló mupa, atimané Yesupaae, “Naao wisiraaloé?” yóló wosalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Atétepa, a̧ kale so molepaae fóló hemene doropóló, kale soné tiki supu dere kisi bete foné salemó, kemeyalepó. Atéteretamotóró kale so a̧ turukó holóló, atimamó o̧la kaae sóró biliyóló melalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Be dikiyaairaalu, suka doropoletamo mepaae ha̧le betere whi̧rapené kae kae hepo daale so whi̧ Yesu beterepaae dapesó walepó. Atéró wóló betó mupa, so whi̧ doko̧ feané tikimó ama naase mulótua yalemó, atimané kisi beterape wisiyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","So whi̧ feané tiki tua̧mó tepeyóló betere dowi keperape fo fakeyóló sókó furaalu, ya̧ta Kótóné naalemapó dua yalepó. Ai fo depa, atimané a̧ta ha̧le whi̧ mei, Kótóné so whi̧ tȩteróló kaae tanó̧póló sóró beteró betere whi̧ Kerisopó yao̧sóró, kale dowi keperape foné sua yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mo hi̧kati Yesu ama wotoró so whi̧kélé bitinire tikipaae felepó. Atépa, kale so whi̧ feané keketé kwȩyóló, a̧ betere tikimó sókó walepó. Atéró wóló bituraalu a̧ metikipaae fao̧sóró, atimatamo betaai dapóló, sesé du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tétepatei, ama atimapaae duraalu, “Kótóné tȩteróló kaae tare ao̧mó mole fo wisi i ape yóló yó maté kwȩyó̧póló, Kótóné ȩ dotȩyalepó. Atéreteiné ȩ dia̧tamo betenéni, mepaae be huluapaae faai dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Téró, a̧ Judia hae kwiamó tȩ mole fo wosetere be doko̧ fea fo yó matétóró kutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Téró etéyalepó. Me be dȩmó Yesu a̧ Kenesaret wȩi fókumó daalepó. So whi̧ mo fea ha̧le o̧la kaae wóló tourale tikimó, hae tiki fa̧ae fóló mulu, Kótóné fo wosetu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Até du betepa, wȩi nuku tamo ai wȩi fókumó duló betepa kelalepó. Ai nuku tamota, ya siré kotere whi̧rapené nukupó. Atimané nuku aimó dupa teraae fóló, wȩi fókumó ha̧leke warape fukutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Atétu betepa, a̧ nukumó biti̧ holalepó. Ai nuku tale, Saimon-paae duraalu, “Naao nuku ai wȩi kulu tua̧paae sawa hi̧kili falae,” yalepó. Téró, a̧ nuku tómó bituraalu so whi̧ feapaae fo yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","A̧ fo yó melóló kemetepa, Saimon-paae duraalu, “Yakó detémóló kelaalopa, nuku wȩi kulu tua̧paae fóló, diaao̧ ha̧leke warape wȩi dolopaae derae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ai fo depa, Saimon-né a̧paae duraalu, “Doa whi̧-ó, mió dikitamo yakó saalo nisiyóló da̧ depe tukó wei ala yóló deraté kwȩyalemó, mo beta̧kókélé denipó. Téyaletei, naao derae depa ti ha̧leke warape da̧né deraalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Atéró, atimané ha̧leke warape deralemó mo doakale yarape deale tikimó, atimané ha̧leke warape tukó faairaalu yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Atéteremó, atimané fulumu whi̧rapepaae atima tao sene ape depa wóló, mepaae yarape nuku dolopaae bulóló fu betalemó, kale nuku tamo wusuró mo felekemó wȩi dolopaae buó deyaai yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Atétepa, Saimon-ró a̧tamo kutó ditere whi̧rapetamokélé, atima beta̧mó ya siré kotere Sebedi naalema tamo Jems-ró Jon-tamokélé, ya mo dekéró sóró muló betere kilituraalu, haió yóló siratu betalepó. Atétepa, Saimon Pita a̧ Yesuné hó ao̧mó bukutiri tea̧ró bitu duraalu, “Tale-ó, ȩta dowi ala du betere whi̧pa, taaróló ya̧ fumié?,” yalepó. Tétepa, Yesuné Saimon-paae duraalu, “Ya̧ wiyao̧se, naao ya su dere kaae, mió kaae sóró so whi̧ siré kwȩyaasepólópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Atétepa, atimané nukurape wȩi fókupaae tao sóró mulóló, atimané o̧la o̧lakélé mupatei taaróló a̧ sya felepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Téró etéyalepó. Yesu a̧ beta̧ be huluamó beteremó, dowi humu fuluné tiki dore whi̧ walepó. Atéró, Yesu betere felekemó ama kelepaa haepaae deróló bukutiri tea̧ró bitu a̧paae woseturaalu, “Tale-ó, ya̧lo tiki doretei naao kisipané wisiraai depa, ti wisiraasepólópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Atétepa, Yesuné ama naase teréȩ faróló kale whi̧né tikimó wolaayóló duraalu, “Naao tiki ya̧lo wisiraai kisipa mutapa wisiyae,” yalepó. Téyalemó, mo ai fapotóró kale whi̧né dore tiki mo ti wisiyó felepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Atéró, Yesuné kale whi̧ dotonaai a̧paae mo diri ma fo yóló duraalu, “Ya̧lo naao tiki wisiralepóló, mo whi̧paae momókó yao̧se. Ya̧ fóló, Kótópaae momaratere whi̧né naao tiki fope yó̧póló, yó male fae. Atéró fopeyóló naao tiki wisipa kilitu, Moses-né ere fo sya furaalu, Talepaae ha̧le melae ere o̧la melae. So whi̧ feané ai ala kilituraalu, ita Talené erapó kisipa muaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yesuné mo so whi̧paae yao̧se yaletei, i ala yalepóló deté kwȩyóló fakeratepa, so whi̧ feané woseturaalu, atimané kae kae kisi beterape wisiróo, ama dere fo wosóo yaairaalu, wua yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Atépatei, Yesu a̧ so whi̧tamo betere tiki taaróló so whi̧kélé bitinire tikipaae suka fea moma eneta dua yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Atéró, me sukamó etéyalepó. Ama fo yó mótu betepa, mepaae Farisi whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamo Kaleli haeró Judia haetamomó betó mole so whi̧kélé, Jerusalem be hulua so whi̧kélé, wóló betó molepó. Ai sukamó, so whi̧ feané kisi bete wisiraaire Talené fotoko̧ su̧mó bolepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Atépa, mepaae whi̧rapené beta̧ tiki momaare whi̧ besekȩné dokopatei, beleyóló wóló be tua̧paae holóló Yesu beterepaae sóró holaai kisipa mualepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Téró, kale whi̧ sóró faaire tu̧mó so whi̧ mo fea daayale tikimó fenénipa, siki bepaae sóró holóló kea sokóló, kale whi̧ dokopatei, besekȩtamo Yesu daale donotóró deralepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Atéró, atimané kisipa tiki tiratere ala Yesuné kolóló, kale tiki momaare whi̧paae duraalu, “Ti naale-ó, naao dowi alamó kwia melaai yaletei mió i kemeratere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yesuné ai fo depa, Farisi whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamo atimasisi fo yaai tuȩ́ teketu betalepó. “Ti whi̧né a̧ta, Kótó kaaepó du betere foné Kótó faletu beterapó. Mo whi̧ beta̧nékélé dowi alamó melaaire kwia kemeranénitei, Kótóné beta̧ su̧mó enérapó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Atéró mutere kisipa Yesuné kolóló, atimapaae duraalu, “Noatepa dia̧ atei tuȩ́ mutu bitu de? ");
INSERT INTO ppo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ti mé fo so whi̧ feané enére? Naao yale dowi alamó saaire kwia aluratapó enérépe, ya̧ turukó holóló naao besekȩ sóró fae fo enére? ");
INSERT INTO ppo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","I haemó betó mole so whi̧né dowi ala bete tokó̧ló aluraaire fotoko̧ Whi̧né Naalemané su̧mó bulapóló, kisipa yaasepóló i whi̧paae eratere ala kelae. Ya̧lo ya̧paae mo i dere ape, ya̧ turukó holóló naao besekȩ sóró bepaae fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ai fapotóró kale be whi̧ so whi̧ feané keletómó turukó horóló ama besekȩ sóró bepaae furaalu, Kótóné doi hale sóró horaté felepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Atéteremó, so whi̧ fea winé sukutu sirayóló duraalu, “Mo take etei kaae ala depa, da̧né kolókélé ini, mió kisi ala keletapóló,” Kótóné doi hale sóró horótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ai ala yóló kemetepa, Yesu a̧ beta̧ takis moni siré kotere whi̧kó ama doi Lipai moni su betepa kolóló, Yesuné a̧paae duraalu, “Ya̧ ȩ sya ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ti fo depa, a̧ turukó holóló ama o̧la o̧lakélé mupatei, taaróló a̧ sya felepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Téró, Lipainé Yesu ama bepaae dapesó fóló, a̧mó doasi o̧la deralepó. Taks moni siré kotere whi̧raperó mepaae so whi̧tamo fea touró bitu, o̧la nuku beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tétu betepa, mepaae Farisi whi̧raperó atima beta̧ kisipa mulu Moses-né asȩre fo yó matere whi̧rapetamoné Yesuné yó matere whi̧rapepaae duraalu, “Taks moni siré kotere whi̧raperó dowi ala du betere whi̧rapetamo wȩiró o̧latamo beta̧mó noatepa o̧la nuku bitu dérópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ti fo depa, Yesuné atimapaae duraalu, “Hepo daanire so whi̧ dokta whi̧ beterepaae fumi, hepo daale so whi̧ maaté fua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ȩ waleteita, donoi ala du betere whi̧paae ape yaai ani, dowi ala du betere so whi̧ atimané dowi ala taaróló ape yaairaalu walepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Atimané a̧paae duraalu, “Jon-né yó matere whi̧rapeta, Kótópaae kisipa muóló, me féli o̧la weyóló bitu, momatua dapó. Atétere kaae, Farisi whi̧rapené yó matere whi̧rapekélé atétua dapó. Tétepatei, naao yó matere whi̧rape ai ala ini, atima o̧laró wȩitamo nokole ala suka fea ha̧le yó tarapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tétepa, Yesuné atimapaae duraalu, “Beta̧ whi̧ a̧ so dokotere sukamó ama nomarape o̧la weyóló ha̧le bitua de? Meipó. ");
INSERT INTO ppo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Téyaalo meitei, me sukamó kale so dokaaire whi̧ atima beta̧mó bituraalu, o̧la nuku betera̧lemó, a̧ tawóló só fole sukamó atima o̧la weyóló ha̧le betaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ama atimapaae yale fo kisipa só̧póló, me fo sale etéró yalepó. “Mepaae whi̧né kisi kuti bisa̧ayóló dera̧akele kuti bisa̧ae faletei nomotua de? Atétepa, ti dera̧akele kutiné kisi kuti hu̧kulu yóló doróo, nomaleteikélé koko̧ ini yóo, yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Atétere kaae, mepaae whi̧rapené wain wȩi hupu sekaȩné aleyale dera̧akele wutimó tepetumipó. Até enalemó, kale wȩi fotoko̧né kale hupu sekaȩné aleyale dera̧akele wuti fulukó furaalu, wȩikélé sunée faalopó. ");
INSERT INTO ppo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Até yao̧sóró, atimané kisi wain wȩi tepeturaalu, ti hupu sekaȩné aleyale kisi wutimó tepetua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Folo moi wain wȩi nokole whi̧rape atima kisi wain wȩi naai hȩkese dumipó. Ti noatepae, folo moi wain wȩi nóló toureteiné mo wisirapó, du beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Téró, sa̧a naai tukóló muló betere be dȩmó, Yesu a̧ ama yó matere whi̧rapetamo whit kutó tua̧mó tȩyóló felepó. Atéró furaalu, ama yó matere whi̧rapené ai kutómó ere whit du ka̧ae sóró fumi hotokó̧ló nukulé fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mepaae Farisi whi̧rapené até dere ala kolóló, a̧paae duraalu, “Sa̧a nokole sukamó naao yó matere whi̧rapené atei ala yó̧póló, noatepa kaae tare?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ai fo depa, Yesuné atimapaae tokó̧ mótu duraalu, “Depit-ró ama fulumu whi̧rapetamo wotetepa yale ala asȩmó moletei, diaao̧ dosa̧ayóló kisipa muni airapó. ");
INSERT INTO ppo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Depit a̧ Kótóné be dolopaae holóló bituraalu, Kótópaae melale mo kae muló betere bred otei ama sóró nalepó. A̧ nóló, kwiapaae ama fulumu whi̧rapekélé matepa, atimané sóró nalepó. Ai ota, ha̧le mo whi̧né nukumi, Talepaae momaratere whi̧rapené maaté nukua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Téró, Yesuné atimapaae duraalu, “Sa̧a nó̧póló tukóló muló betere be dȩ tȩteróló kaae tare Taleta, ti kale whi̧né Naalemapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Téró, sa̧a nokole me be dȩmó, Yesu a̧ Kótóné fo wosetere be dolopaae fóló, fo yó mótu betalepó. Atéró yó mótu betalemó, beta̧ whi̧ ama turu naase sinóló dopa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Atétepa, mepaae Farisi whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamoné Yesu só deraaire bete kikitu, kale sa̧a nokole be dȩmó naase dowi whi̧ wisiratéró kelaairaalu, kaae tawóló beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Atimané atéró mutere kisipa ama kolóló, kale naase dowi whi̧paae duraalu, “Ya̧ so whi̧ kuamó turukó holóló, daayae,” yalepó. Atétepa, kale whi̧ a̧ so whi̧ feané keletómó daane holalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tétepa, Yesuné atimapaae duraalu, “Ya̧lo dia̧paae beta̧ fo wosetapó. Sa̧a nokole sukamó noa ala yao̧se yóló mule? Whi̧ tao sóró wisiratere alapé, dowi ala deretei? Ó whi̧ sukao̧sóró tao sere alapé ó whi̧ betere bete doratere alaé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ai so whi̧ beterepaae kele keleyóló kale whi̧paae duraalu, “Naao naase teréȩ falae,” depa, kale whi̧né naase teréȩ faralemó, wisiyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Atéteremó, doasi fopaae buóló atimasisitei fo kȩlaaróló duraalu, “Da̧né a̧paae noa alakó eraaloé,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Téró beta̧ sukamó Yesu a̧ moma yaairaalu, du sorokó mole ao̧paae felepó. Atéró, aimó Kótópaae moma deté fu betepatei, be dȩralepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","14","Atéró be dȩyó hotepa, hi̧ka ama yó matere whi̧rapepaae ape yóló, fea betó mupatei, 12 whi̧rape maaté sorokó sóró, aposel doi mulalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Saimon doi mupatei, ama me doi Pita mulalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ama noma Andru, Jems, Jon, Filip, Batolomiu, Matyu, Tomas, Alpias-né naalema Jems-kélé, ka̧lo ka̧lore whi̧ Saimon, Jems-né naalema Judas-kélé, Yesu dó̧póló eleké deyaaire whi̧ Judas Iskariot, atima atéró whi̧rape sóró beteralepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Atéró, Yesu a̧ kale du sorokó mole tiki taaróló, ai ao̧mó sawa mulure tikipaae ama sóró beterale whi̧rapetamo derepelepó. Kale mepaae yó matere whi̧rapekélé, Judia hae kwiamó wale so whi̧kélé, Jerusalem be huluamó wale so whi̧kélé, wȩi fóku felekemó tȩne Tair beró Saidon betamomó wale so whi̧kélé, mo ha̧le o̧la kaae wóló touró beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Atéró waleteita, ama dere fo wosóo, atimané kisi bete kemeróo, mepaae so whi̧kélé dowi kepe tepeyóló beteretei dóló ho̧konóo, yó̧póló walepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ama fotoko̧né aimó betó mole so whi̧ atimané kisi bete wisirótua yaleteiné, ama tikimó wolaayaai dapóló walepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Atétepa, Yesuné ama yó matere whi̧rape kaae taru duraalu, “Dia̧ yoleale betere whi̧rapeta, ti Kótóné tȩteró betere ala sereteiné dia̧ hai̧né sukutu beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Dia̧ mió wotené sukó̧ló mole so whi̧rapeta, take o̧la su̧mó naalopóló kisipa mutu, hai̧né ai sukutu betere ape. Mió dia̧ dekȩné sukó̧ló moló du betere so whi̧ta, take hai̧né sinóló betaaireteimó, Talené wisiró beterapa, wisi kisipa muóló betae. ");
INSERT INTO ppo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Atéró, dia̧ Whi̧né Naalema sya fu beteremó, mepaae whi̧rapené dia̧ hó̧róo, kae beteró̧póló ho̧kó falóo, dowi ala dere whi̧póló diaao̧ doi doróló fale yóo du betepa, ti Talené dia̧ wisiró beterapa, hai̧né sukutu betae. ");
INSERT INTO ppo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Atétere sukamó hȩkesené sukutu, tu̧wó holae. Ti noatepae, diaao̧ take saaire doasi dupu wisi hepen-mó muló beterapó. Ti take atima alimarapenékélé Kótóné ama ko̧ló whi̧rapepaae beta̧ kaae ala erótua yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Téretei, néli whi̧rape dia̧ mo doa wió yae! Ti noatepae, diaao̧ tiki feléyóló mo dua betaaire ala taketi sóró tareteiné, nalopaae atei wisi wisi o̧la momó kae saalomeipó. ");
INSERT INTO ppo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mió dia̧ mepaae whi̧ de o̧la su̧mó nóló betere so whi̧ dia̧ mo wió yae! Ti noatepae, take dia̧ wotené suka̧alo ai ape. Mió dia̧ mepaae whi̧ de do̧ nóló hȩkesetu betepa, take dia̧ dekȩné sukuturaalu doasi wole yaaireteiné mo doasi ko̧lerapó. ");
INSERT INTO ppo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","So whi̧ feané ya̧paae whi̧ wisi-ó, yóló dukiratere fo du betepa, ko̧lerapa mo doasi wió yae. Ti noatepae, mió dia̧ dukiratere so whi̧ atima alimarapenékélé take betale kapala ko̧ló whi̧rape atéró dukirótua erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Téretei, mepaae ya̧lo fo wosetere so whi̧ dia̧paae i dere ape. Dia̧ hó̧róló bóe duraalu, dowi ala erótu betere so whi̧paae yaala sókó fóló hȩkesené sukutu, wisi ala beta̧ erae. ");
INSERT INTO ppo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mepaae whi̧ dené dia̧ doróló sekȩratere fo depa, Kótóné atima wisiró̧póló, fo wisitei yae. Mepaae whi̧ dené dia̧paae sekȩi ala eratepa, Kótópaae atima wisirae yóló momarae. ");
INSERT INTO ppo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mepaae whi̧ dené naao faamumó deké supa, metikirókélé dó̧póló yó melae. Mepaae whi̧ dené naao tómó deró betere kuti sokotepa ti naao tua̧mó deró betere kutikélé seséni, sokó̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mepaae whi̧ dené ya̧paae me o̧lakó a̧lae depa, ama kematere o̧la melae. Mepaae whi̧ dené naao tare o̧la fasetepa, momó a̧lae fo yao̧se. ");
INSERT INTO ppo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mepaae so whi̧né ya̧paae eranée dere ala kaae, naao mepaae so whi̧paaekélé erótua yae. ");
INSERT INTO ppo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Dia̧paae yaala sókó fu betere whi̧paae maaté yaala sókó fu betere-a, ai doasi alaé? Mepaae dowi ala dere whi̧rapenékélé atimané fulumu whi̧rapepaae atéró yaala sókó fole ala du beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mepaae whi̧ dené dia̧paae wisi ala erótu betepa, diaao̧kélé atimapaae wisi ala eratepa, aita doasi ala meipó. Ti aita, dowi ala du betere so whi̧nékélé dere alapó. ");
INSERT INTO ppo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Diaao̧tamo mepaae whi̧né dia̧paae momó tokó̧ meló̧póló me o̧la melatepa, ai-a hapólure? Ti mepaae dowi ala dere whi̧rapenékélé momó tokó̧ló saai ai ala dua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tépatei diaao̧ta, bóe whi̧paae yaala sókó fóló wisi ala beta̧ erótua yae. Atéturaalu, naao me o̧la mótu, momó tokó̧ meló̧póló kisipa muóló meni, ha̧le meló beta̧ yae. Atétepa, ti dia̧ mo taoró betere Kótóné dupu wisi menóló, ama naalerape betaalo ai ape. Ti noatepae, ama ko̧lené sukutere alaró ha̧le tao sere alatamota, dowi ala du betere whi̧raperó a̧paae mo kée initere whi̧rapetamopaae erótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Diaao̧ Ayané mo so whi̧ feapaae ko̧lené sukutu dere kaaetóró diaao̧kélé me whi̧paae atéró ko̧lené sukutu betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Diaao̧ me whi̧ taleyóló só deratere ala yao̧se. Naaotamo me whi̧ só deratere ala initepa, ti mené dia̧kélé taleyóló só deraalomeipó. Dia̧né mepaae whi̧tamo foné só deréni depa, ti ya̧kélé mené só deraalo meipó. Mené ya̧paae erale dowi ala me o̧la meipóló ha̧le kemeratepa, ti diaao̧ yale dowi alakélé me o̧la meipóló ha̧le kemeraalopó. ");
INSERT INTO ppo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mepaae o̧la o̧la ya̧ya̧re so whi̧mó ha̧le matepa, menékélé dia̧mó ha̧le melaalo ai ape. Naao me o̧la melaai depa, ti deyóló mo ti fa̧anóló melae. Ti noatepae, naao mepaae whi̧mó mo dekéró mótu dere kaae, menékélé ya̧mó naao male su̧tóró melaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Atéró, ama i yale fo tómó atimapaae i fo sale yalepó. “Beta̧ kele dilikire whi̧né me kele dilikire whi̧paae tu̧ i mole ape yóló a̧lisóró fenére? Atétepa, ti a̧ dée nukuraalu, atimamo wusuró dée nóló dolopaae derepaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Beta̧ skul naalené a̧ yó matere whi̧ tȩteraalo meipó. Téyaalo meitei, kisipa siré fóló su̧tepa, ti a̧ yó melale whi̧ kaae betaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Naao kele dolomó doakale bole ni fake kilini, naao noné kelemó sawatamo bole mometei noatepa sokaai du betere? ");
INSERT INTO ppo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Naao nopaae duraalu, ‘No-ó, naao kele dolomó bole mome sawa sokotapa maé,’ dere noatepa de? Naao kele dolomó bole doasi ni fake sokóló naao kele feléruraalu, ti naao noné kelemó bole mome sokotepa mo wisirapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ni wisiné dowi du oletimipó. Dowi ninékélé wisi du ulutimipó. ");
INSERT INTO ppo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mo nirape fea du oletepa kolóló, ita du wisi oletere nipó, ita, kokola oletere nipó dua dapó. Whi̧rape feané nose du teketuraalu, mu daai képi tikimó ó ha̧le ho̧ko ni tikimó olepa teketumipó. Mo besa̧ae teketukélé ha̧le képimó olepa tekete? Meipó. ");
INSERT INTO ppo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Whi̧ wisiné hosaa tua̧mó wisi alatóró fa̧ayóló muluraalu, ama dere fokélé, wisi fotóró dua dapó. Dowi whi̧né ama hosaa tua̧mó fa̧ayóló mole alatóró dowi fo ha̧keamó depa wosetua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ya̧lo dia̧paae yae dere alamo diaao̧ iniyóló, ȩpaae doasi Tale-ó fo noatepa du betere? ");
INSERT INTO ppo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mepaae whi̧né ya̧lo dere fo wosóló, ya̧lo yae dere alakélé wisiyóló erótu betere so whi̧ ti etei kaae alané kelerapó. ");
INSERT INTO ppo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Whi̧ beta̧né ama be tȩyaairaalu, tó hae fea dukuté doropóló, hae dirimó kapo fake mulóló, ai tómó be tȩtua dapó. Atéró tȩne be doakale hali tikiró wȩi asyatamo waalotei, ai be mo wisiyóló tȩneteiné tokó̧ fenipó. ");
INSERT INTO ppo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Téyaalotei, whi̧ me dené ya̧lo fo wosetutei, ya̧lo erae dere ala erénitepa, ti etei ala kaaené kelerapó. Whi̧ beta̧né ama be tȩyaairaalu, tó hae ka̧ayóló taae faréni, ha̧le ho̧ko tȩnapó. Atépa, doakale hali tikiró wȩi ayatamo waletikimó, kale be tokó̧ taae faróló, mo ti doralepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Téró, Yesuné so whi̧paae fo yó melóló kemetepa, a̧ Kapeneam bepaae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ai bemó beta̧ topo diki tare whi̧né ama hosaa mole kutó diratere whi̧ beta̧ heponé mo felekemó suka̧ai du betalepó. Ai topo whi̧né 100 Rom diki tare whi̧rape tȩteróló kaae tarepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Atépa, kale topo whi̧né Yesu wóló beterapó dere fo woseturaalu, ama kutó diratere whi̧ Yesuné tao sene wó̧póló, mepaae Juda topo whi̧rapené a̧paae ene fó̧póló dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Atima Yesu beterepaae wóló a̧paae duraalu, “U whi̧ wisinaale mo felekemó sukutapa, naao a̧ wisiraasepóló ya̧ da̧ faalopó. ");
INSERT INTO ppo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ti noatepae, da̧ Juda fake so whi̧tamo hȩkesené sukó̧ló yaala sókó fole ala muluraalu, da̧né fo wosetere bekélé ama tȩnalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Atétepa, Yesu a̧ atimatamo fóló, kale whi̧né be felekepaae sókó waairaalu wou betepa, kale diki tare whi̧rapené doasi topo whi̧né ama fulumu whi̧rape Yesutamo tu̧mó hokolaatu, i fo yae yóló dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Atétepa, atima fóló, kale topo whi̧né Yesupaae yae yale fo yalepó. “Tale doa whi̧-ó, a̧ whi̧ wisi betepapakó ya̧ ama be tua̧paae ape yaalomeipa, ya̧ tika tumó daalu kisi bete wisi yae fo beta̧ yae. ");
INSERT INTO ppo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ti noatepae, ȩkélé ȩ tȩteróló kaae tare whi̧ ao̧mó beterapó. Ya̧lo diki tare whi̧rape atimakélé ȩ ao̧mó beterapó. Ai whi̧rapepaae ya̧lo ‘Fae,’ depa fóo, ‘Ya̧ ape,’ depa wóo, dua dapó. Ya̧lo kutó diratere whi̧paae i ala yae depa, ai alatóró ama dua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesuné i kale whi̧né ene wale fo wosóló sirayalepó. Téró, Yesu fetée fóló a̧ sya wou betere so whi̧paae duraalu, “Israel hae kwiamó etei kaae kisipa tiki tiró betere whi̧ mo beta̧kélé betepa kilinipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Téró, kale doasi topo whi̧né dotȩyale whi̧rape bepaae momó fesaae wóló kelalemó, kale kutó diratere whi̧né hepo bete wisiyóló, mo betepa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Atéró, Yesu a̧ Kapeneam be huluamó sawa beteró, ama yó matere whi̧rapekélé, mo so whi̧kélé, fea a̧tamo Nain be huluapaae sókó faai fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Atéró fu betalemó, ai be hulua tipiné bopéró daaló betere tikimó sókó felemó, beta̧ suka̧le whi̧ beleyóló walepó. Ai naalené hamata, oma sukó̧ló wulia bituraalu, ai naale beta̧tóró kaae tarepó. Ama tiki sini beleyóló fupa, ai be huluamó betó mole so whi̧kélé fea a̧tamo fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Atétepa, Talené kale so kelalemó, ko̧lené hosaamó supa, a̧ daalepaae fóló duraalu, “Ya̧ wole ekesé,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Téró, Yesu a̧ wóló kale suka̧le whi̧ dokore besekȩ olaatepa, beleyóló fu betere whi̧rape feni, kei̧yóló daayalepó. Atétepa ama duraalu, “Ti naale-ó, ya̧lo ya̧paae dapa turukó holae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tétepa, kale suka̧le whi̧tei turukó holóló bituraalu, fo kaae sóró yalepó. Téró, Yesuné kale suka̧le naalené hamapaae naao naale ai ape yóló melalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ai ala kolóló, so whi̧ fea winé sukutepa, Kótóné doi hale sóró holóló duraalu, “Kótóné mo doasi ko̧ló whi̧ beta̧ ama so whi̧ tao saai i wóló betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesuné ai ala du beterapó fo Judia hae kwiaró ai hae kwia tua̧mó betóló fale so whi̧tamo feapaae deté fóló fakeralepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Atéró, kale Jon-né ama yó matere whi̧rapené Yesuné i alarape du beterapóló, Jon-paae ene walepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jon-né ama yó matere whi̧ tamopaae ape yóló, Tale beterepaae fó̧póló dotȩyalepó. Atétepa, atimaamo fóló a̧paae woseturaalu, “Waalopóló bope du betale whi̧ ya̧pé? Whi̧ me kae wó̧póló kaae tawaróe?” fo ene fó̧póló dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Atéró, kale whi̧ tamo Yesu beterepaae wóló a̧paae duraalu, “Da̧mota, wȩi tópuratere whi̧kó Jon-né ya̧paae wosene fae depa walepa, ya̧ta kale waalopóló bopetu betale whi̧pé, whi̧ me kae wó̧póló kaae tawaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Atéyale sukamótóró Yesuné mepaae hepo daale so whi̧kélé, depe dolomó dowi kepe betere so whi̧kélé, kele dilikire so whi̧kélé, wisirótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Atéró, ama atimaamopaae duraalu, “Diaamo fesaae fóló diaamoné wosale foró kelale alatamo Jon-paae ene fae. Mepaae kele dilikiyóló betale so whi̧né kele fisa̧ae fóló o̧la o̧la kolóo, ho̧leke dore so whi̧ mo sesȩre whi̧ kaae kwȩyóo, dowi humu fuluné tiki dore whi̧rape sesȩ mo betere whi̧né tiki kaae daayóo, mepaae wosȩ́li kinu fokélé wosenire so whi̧ wosȩ́li tukwȩ falóo, mepaae sukutepa douraai yale so whi̧tei kepaaróo, mepaae yoleale betere whi̧rapepaaekélé, kale mió wosetere fo wisi yó matepa wosetu beterapó fo ene fae. ");
INSERT INTO ppo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mepaae so whi̧ de ya̧lo du betere alamó dée néni, suka fea eró tare so whi̧ta, hai̧né sukó̧póló yae fo a̧paae ene fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Atéró, kale Jon-né dotȩyale whi̧ tamo fimó, Yesuné Jon-mó kisipa mutu, ai betó mole so whi̧paae duraalu, “Upulé dia̧ so whi̧kélé bitini kópu ka̧ae fitikipaae fua yale-a, besȩ́né kape fépo eratere kelaai felepé, whi̧ kuti wisinaale deróló auretei kelaai feleé? Meipó. ");
INSERT INTO ppo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","26","Ti mepaae wisi wisi kuti maaté deratere whi̧ta, topo whi̧ betere be wisimótóró bitua dapó. A̧ta atei ala inipa, dia̧ noa o̧lakó kelaai feleé? Atépatei, dia̧tamo Kótóné ama ko̧ló whi̧ mo kelaai fitikimó, ti a̧ta ai kutó maaté mei, mepaae kutókélé diró̧póló sóró beteró beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Asȩmó yóló muló betere fota, i whi̧mó kisipa mutu erapó. ‘Whi̧ beta̧ a̧pi folosóró furaalu, ya̧ waaire tu̧ donorae fo ene fó̧póló ya̧lo dotȩyaalo ai ape.’ ");
INSERT INTO ppo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ya̧lo dia̧paae i dere ape. I haemó betó mole soné deale whi̧rapekélé fea betó moletei, kale wȩi tópuratere whi̧ Jon-né tȩteró beterapó. Tépatei, whi̧ me detamo Kótóné tȩteróló kaae tare ao̧mó, belei sókó deóló betepa, ti kale wȩi tópuratere whi̧ Jon bosenée falapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mo so whi̧ fearó takis moni siré kotere whi̧rapetamo Jon-né dere fo wosóló sya fupa, atima wȩi tópuraleteiné Yesuné yale fo wosóló, Kótó a̧ta, mo donotóró taletere Talepó du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Téyaletei, mepaae Farisi whi̧raperó Moses-né asȩre fo yó mótu betere whi̧rapetamo Kótóné tao sóró eraai yale wisi ala atimanétei hó̧ralepó. Ti noatepae, atima Jon beterepaae wȩi tópuaairaalu feni yaleteinépó. ");
INSERT INTO ppo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Téró, Yesuné duraalu, “Mió i alimó betere so whi̧rapené du betere ala ya̧lo noapaae dó faróló yaaloé? ");
INSERT INTO ppo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Atimata, so whi̧ mo fea touróló betere tikimó, kale keteirape atimasisitei melaa duraalu, etei kaae ala dere naale senaale kaaené kelerapó. ‘Dia̧ ki̧liyó̧póló da̧né fó wuti haleróló mepaae wole forape yaletei, dia̧ hȩkeseyóló sama ki̧linipó. Dia̧ dekȩ duraalu moló yó̧póló, mepaae wole forape yaletei, dia̧ wolekélé inipó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Atére kaae, kale wȩi tópuratere whi̧kó Jon o̧lakélé, wȩikélé, néni, weyóló ha̧le betepa, diaao̧ duraalu, ‘A̧ tua̧mó dowi kepe tepeyóló beterapó,’ dua yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kale whi̧né Naalema o̧laró wain wȩitamo nokole ala kolóló diaao̧ duraalu, ‘Kelere? i whi̧ta, o̧la mo dekéró nóo, takis moni siré kotere whi̧raperó dowi ala dere whi̧rapetamo fulumu yóo, du beterapó,’ fo diaao̧ ai dere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Atei fo diaao̧ du beteretei, mepaae so whi̧ de Kótóné mo fo wisi wosóló sya fupa, so whi̧ feané ha̧keamó kilitu, ita Kótóné mole fosó fosóre tuȩ́ sya feleteiné erapó, yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Téró etéyalepó. Farisi whi̧rapekó beta̧né Yesupaae a̧tamo o̧la naai faalopó depa, fóló beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","A̧ atéró wóló Farisi whi̧né bemó o̧la nuku beterapó dere fo ai be huluamó dowi ala du betere soné wosóló, alapasita kanené aleyale wutimó felé kȩlaa wale wel wȩi sóró walepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Atéró wóló, a̧ Yesuné sisópaae fóló, ama hó ao̧mó hemée deyóló bitu, wole du betalepó. Atéró du betale wole kaape Yesuné ho̧leke tópaae durupu beterepó. Tétepa, kale soné ama topo nikinétei, helekó̧ló kópurótu betalepó. Atéró, kale soné Yesuné ho̧leke tamo ko̧ló tukó nóló, kale felé kȩlaa wale wel wȩi ama hómó suniyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Atétere ala beta̧ Farisi whi̧né kolóló, ama kisipanétei duraalu, “I whi̧ta, Kótóné ko̧ló whi̧ ua̧sóró, ti ama hómó olaa deremó, dowi ala dere sonétei a̧ olaa dapó, kisipa mua̧pó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tétepa, Yesuné a̧paae duraalu, “Saimon-ó, ya̧lo ya̧paae yaaitere fo beta̧ mulapó,” yalepó. Ti fo depa, ama duraalu, “Yó matere whi̧-ó, naao ȩpaae yaaitere fo yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ti fo depa, Yesuné a̧paae duraalu, “Beta̧ whi̧né moni momó tokó̧ melaai dapóló, tamo whi̧né kwia mulóló me whi̧né 500 denarias moni sóo, me whi̧né 50 denarias moni sóo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kale whi̧ tamoné sale moni talepaae tokó̧ melaairetei su̧nipa, kale whi̧né me o̧la meipóló, taaralepó. Atéró taalatepa, atimaamokó mé whi̧né kale moni talepaae doasi hosaa muóló yaala sókó fole ala enére?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ti fo depa, Saimon-né a̧paae duraalu, “Ya̧lo kisipanéta, kale doasi moni sale whi̧ a̧ hȩkese yaalo ai ape,” Tétepa, Yesuné duraalu, “Naao dere fota, mo dono dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Téró, a̧ kale so daalepaae fetée fóló, Saimon-paae duraalu, “I so naao kelere? Ȩ naao bepaae waletei, ya̧lo ho̧leke fokó̧póló, naao wȩikó ȩ menipó. Ténitei, i soné beta̧ ama wole kaape fȩ ya̧lo hómó epa, ama topo nikinétei helekó̧ló kópuralepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ȩ naao bepaae wale sukamó, ya̧lo faamumó naao ko̧ló tukó néni, i soné beta̧ ya̧lo hó ko̧ló tukó nuku betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Naao ya̧lo topomó wel wȩi dilénitei, i soné beta̧ ya̧lo ho̧lekemó felé kȩlaa wale wel wȩi dilalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Atéyale kaae, ya̧lo ya̧paae i dere ape. I soné ama mo doasi du betale dowi alamó saai yale kwia ya̧lo ha̧le kemeraleteiné ama ȩpaae hosaa muóló doasi yaala sókó fu beterapó. Tépatei, whi̧ me dené ama dowi ala ha̧le tómó maaté kemeratepa, ti ama yaala sókó fóló hȩkesené sukutere alakélé ha̧le tómó erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Téró, Yesuné kale sopaae duraalu, “Naao yale dowi alamó saaire kwia ha̧le kemeró beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ai fo depa, a̧tamo beta̧mó o̧la nuku betere whi̧rape atimasisitei, fo kȩlaaróló duraalu, “I whi̧ta, Tale kaae bitu, dowi alamó saaire kwia ama ha̧le kemeraalopóló dérópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tétepa, Yesuné kale sopaae duraalu, “Naao kisipa tiki tiró betere alané ya̧ tao sóró wisiralepa, naao hosaa muni deyóló mo dua fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ai ala yóló kemetepa, Yesu a̧ doasi be huluaró sawa be huluatamopaae fóló kale fo wisi yó móturaalu, Kótóné tȩteróló kaae tare ao̧mó mole ala etérapóló yó maté kwȩyalepó. A̧ atéró kotere alata, ama yó matepa wosetere 12 whi̧rapekélé feapó. ");
INSERT INTO ppo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Téró, take depe tua̧mó dowi keperape betepa wisirale sorapekélé, mepaae hepo daapa wisirale sorapekélé, fea a̧tamo felepó. So whi̧né Maktala be hulua sokó Mariapó du betere so felepó. Ai sota, take wȩikeró dowi keperape tepeyóló betepa, dóló ho̧konale sopó. ");
INSERT INTO ppo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kale topo whi̧ Herot-né ama be ó o̧la o̧la fea kaae tanó̧póló, sóró beteró betere whi̧ Kusané soma Joanakélé, so me Susanakélé, mepaae sorapekélé, mo fea a̧tamo felepó. Ai sorape atima moninétei, Yesuró ama yó matere whi̧rapetamo tao sua yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Atéró so whi̧ fea beta̧paae tourótu betepa, mepaae kae kae doasi be huluamó betó mole so whi̧kélé wóló tourótu betalepó. Atépa, Yesuné ama i fo sale yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Whi̧ beta̧né o̧la wae ke ama kutómó terepeté kwȩyaairaalu, sóró felepó. Atéró furaalu, mepaae kerape tu̧mó sorokóta yóló mupa, so whi̧né ho̧lekené tȩiya tȩiya yalepó. Atépa, sikimó kotere barape dorowóló, kale kerape dósu yóló nalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Téró, kale whi̧né kutómó kerape terepeté kwȩyaletei, mepaae ti kane tómó dakere haemó taae doróló hapale holalepó. Téyaletei, kapo tómó dakere hae fȩ meiru, kale o̧la wae feleke doaló derepeniyóló, hapale séliyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mepaae ke ti dowi ne eremó taae derepelepó. Atéyaletei, dowi netamo beta̧mó holóló kale ke o̧la wae wisi dowi nené bopeyóló aluralepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mepaae hae wisimó terepée derepele o̧la wae wisiyóló holóló, du oleyalepó. Ai o̧la u̧lumétepa sóró, 100 yorape fa̧analepó,” yalepó. Ama i fo sale yóló kemetepa, fo fotoko̧iné duraalu, “Whi̧ de wosȩ́li daapata, i dere fo wisiyóló wosóló tuȩ́ muae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tétepa, ama yó matere whi̧rapené a̧paae woseturaalu, “Naao ti yale fo sale noa betené yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ai fo depa, ama atimapaae duraalu, “Tale Kótóné tȩteróló kaae tare ao̧mó kinóló mole ala diaao̧ tuȩ́ yó̧póló, mené dia̧ sóró beteró beterapó. Téretei, mepaae ha̧le mo so whi̧paaeta, ti fo salené maaté du beterapó. Ti noatepae, ‘Take atima kelené kelaalotei, mo diriyóló koló faalomeipó. Take atimané fo wosaalotei, bete mo diriyóló kisipa yaalomeipó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","I yale fo sale bete i ape. Kale o̧la wae keta, ti Kótóné fo wisipó. ");
INSERT INTO ppo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kale o̧la wae ke tu̧mó taae doropóló mupa, barape dorowóló dósu yóló nale kaaeta, mepaae whi̧ de Kótóné fo wisi wosóló, atimané hosaa tua̧mó mulatepatei, dowi Satan wóló, kale fo wisi tokó̧ sua du beterapó. Aita ha̧le mei, kale fo wisi wosóló kisipa tiratepa, Kótóné atima tao sao̧sóró du beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Téró, mepaae kane tómó dakere haemó taae derepele o̧la waeta, i ala dere kaaepó. Kótóné fo hȩkesetamo wisiyóló woseteretei, atimané tuȩ́ tua̧mó mulótimipó. Sawa sukamó kisipa tiki tiró bitu, woseté fu betaalotei, sekȩi ala wale be dȩmó hapale dée nukua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kale dowi ne dolomó taae doropóló o̧la wae botokó̧ sóró honiyale kaaeta, i ape. Mepaae whi̧ de Kótóné fo wosólótei, tu̧mó furaalu, atima betere alamó doasi whaalia dere alakélé, tó tikiné felé yaaire alakélé, atimané kisipa tiki tua̧mó muló bitu, kale fo wisi botokó̧ sóró aluróló, du wisi oletimipó. ");
INSERT INTO ppo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tépatei, hae wisimó taae derepele o̧la waeta, i ala dere kaaepó. Mepaae so whi̧né kale fo wisi kisipa wisitamo wosóló keteréni, atimané hosaa tua̧mó mulóló eró tareteiné, o̧la wae kaae holóló, kale fo wisi du oletua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“So whi̧né lamp sa̧ dȩróló haené aleale nuku ao̧mó ó fitere kea ao̧mó kinóló munéni, so whi̧ feané koló̧póló dȩróló ha̧keamó mulótua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ti so whi̧né kelao̧sóró mió hiróló muló betere ala fea take fopa ha̧keamó mulatepa, so whi̧ feané kelaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Téyaalopa, mió diaao̧ wosetere fo wisi mo wisiyóló sya fóló, erótóró tawae. Ti noatepae, mepaae so whi̧ dené Kótóné fo wisi mo bete mulapóló tao tapa, atétere so whi̧paae Talené tómó beleróló mo dekéró melaalopó. Mepaae so whi̧ dené wosale fo wisi ama kisipané tare nisi du betereteikélé Kótóné fasó saalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Téró etéyalepó. Yesuné ama hamaró nomarapetamo a̧ kelaai waletei, so whi̧ fea touraletikimó, a̧ daale felekepaae fenénipa, atima belamó kaae tawóló daae molepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Atépa, mepaae whi̧né a̧paae duraalu, “Naao haeró nonaaorapetamo ya̧ kelaai wóló belamó daae mulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ai fo depa, ama atimapaae duraalu, “Mepaae so whi̧ de Kótóné fo wosóló erótu betepa, ti ya̧lo haeró norapetamo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Téró me be dȩmó Yesuné ama yó matere whi̧rapepaae duraalu, “I wȩi kȩla uté tȩró faalopa fiépe,” yalepó. Atétepa, atima nuku tua̧paae biti̧ holóló, tȩ felepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Atéró, atima nukutamo wȩi tómó fu bituraalu, a̧ nuku salemó toró mulóló, noke firepó. Atéró wȩi tómó fu betalemó, doakale besȩ́ tikiró wȩi asyatamo wale tikimó, nuku dolopaae wȩi bó̧ dorowóló fa̧aturaalu, wȩiné atima mo felekemó aluratapó, du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tétepa, ama yó matere whi̧rape fóló, a̧ turukuróló duraalu, “Doa whi̧-ó, mió wȩiné da̧ mo felekemó i aluratere ape,” yalepó. Atétepa, a̧ turukó holóló kale besȩ́ tikiró wȩi asyatamopaae taalae yóló foné salemó, béyóló dono felepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Atéró, ama yó matere whi̧rapepaae duraalu, “Dia̧ kisipa tiki tiró bitini airapó,” yalepó. Ai fo deremó atima witepa, sirayóló atimasisitei duraalu, “I sekȩ́néta, noa whi̧rópó. Wȩi asyaró besȩ́ tikitamokélé, a̧ ao̧mó bitu, ama dere fo mo beta̧ wosetapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Atéró, atima ai Kaleli wȩi kȩla tȩyóló, Kadarin hae kwiamó sókó felepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Atéró, Yesu a̧ nuku taaróló hae tópaae taae felemó, ai be huluamó beta̧ dowi kepe tepeyóló betere whi̧ a̧tamo hokolaa yaai walepó. A̧ mo take bitiré woutei, kutikélé deréni, tiki ha̧le whi̧ dou tómótóró bitua yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Atéyale whi̧né Yesu daale kolóló, keterȩ́ yóló ama hó ao̧mó deraapisa fóló fió mulu fo fakeyóló duraalu, “Mo taoró betere Tale Kótóné Naalema-ó, ya̧lo ya̧paae dapa, naao ȩ momó kae susupurao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ti noatepae, Yesuné kale dowi kepepaae duraalu, ai whi̧ tua̧mó beteretei taaróló sókó fae dere fomó yalepó. Ti a̧ta, take mepaae whi̧né sein képiné dokóló mulótua yaletei, kale dowi kepené a̧ whi̧ bitinire tikipaae fó̧póló, ho̧kó fatua yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesuné a̧paae woseturaalu, “Naao doi deé?” depa ama duraalu, “Ya̧lo doita Lisanipó, ” yalepó. Ti noatepae, a̧ tua̧mó keperape mo ha̧le o̧la kaae woló, betó moleteinépó. ");
INSERT INTO ppo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Téró, kale dowi keperape atima betere tiki taaróló, mo apaae derepale dolopaae ho̧kó derao̧se yóló momó du, momó du, yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ai du sorokó mole ao̧mó hupurape kimimó daae mupa, dowi keperapené Yesupaae woseturaalu, “Da̧ ai hupurape tua̧paae biti̧ faai dapa, naao da̧paae fae yaaloé? depa, Yesuné wisirapa téyae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Atétepa, kale dowi keperape kale whi̧ tua̧mó betaletei taaróló, kale hupurape tua̧paae tepeyóló biti̧ felepó. Tétepa, kale hupurape botokó fele tikimó wȩiné sa̧ane kulamó doropóló, wȩiné soroko̧ fóló, fea sisiraae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Atétepa, kale hupu kaae tare whi̧rape wituraalu botokó fóló, doasi be huluaró ipu berapetamopaae fóló atimané kelale ala deté kwȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ai fo wosale so whi̧ feané noa ala yalerópóló kelaai felepó. Atéró, Yesu beteremó sókó felemó, dowi keperape tepeyóló betale whi̧tei tuȩ́ wisi muóló, mo whi̧ kaae kuti wisitamo betepa kilitu, atima wiyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Téró, mepaae ai ala depa, kelale so whi̧né ai wale so whi̧paae duraalu, “I whi̧ta, dowi keperape tepeyóló betale whi̧tei, mió a̧ wisiyóló mo sesȩre whi̧ kaae, ai beterapa kelae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Téró, ai kale Kadarin hae kwiamó betó mole so whi̧ doasi wituraalu, Yesupaae atima taaróló fae yóló, sȩtu betalepó. Atétepa, a̧ faairaalu, wȩi nukupaae biti̧ holalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tétepa, dowi keperape tepeyóló betale whi̧né Yesupaae a̧kélé ya̧tamo fȩnére? yóló wosalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Tétepa, Yesuné a̧ dotȩyaai duraalu, “Ya̧ ȩtamo faalomeipa, Kótóné ya̧paae erale ala yó melaai naao bepaae fesaae fae,” yalepó. Atétepa, kale whi̧ a̧ fóló, Yesuné a̧paae erale alarape ai be huluamó betó mole so whi̧ feapaae yó melaté kwȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Atéró, Yesu a̧ momó wȩi kȩla tȩyóló uté tȩró sókó fóló beteremó, a̧ wó̧póló kaae tawóló betó mole so whi̧ fea hȩkesetamo a̧ bopera̧le walepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yesu atéró betepa, Kótóné fo wosetere be kaae tare whi̧ Jairus wóló, Yesu kelalemó, mo doasi whi̧pa, ama hó ao̧mó deraapisa fóló fió mulu, a̧paae mo miótóró ama bepaae faalopóló, wosetu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Aita ha̧le mei, 12 ba fo kemere senaale mo beta̧tóró beteretei mo felekemó suka̧ai depa yalepó. Téró, Yesu tu̧mó fu betepa, so whi̧ feané beteki̧ beteki̧ deté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","A̧ atéró sókó felemó, fa̧ke fu betepa 12 ba fo kemere so beta̧ walepó. Tétu betepatei, mo whi̧ beta̧nékélé ama ai kisi bete wisiraaire mo su̧nipó. ");
INSERT INTO ppo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Atére so a̧ so whi̧ kuamó Yesuné sisóró kikiti sókó wóló, ama tómó deró betere kuti salemó olaa yaletamotóró, ama samea fu betaletei tikalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Atétepa Yesuné atimapaae duraalu, “Ȩ né olaa yaleé?” yalepó. Téyalemó, ai so whi̧ feané atima meipó depa Pitané duraalu, “Doa whi̧-ó, so whi̧ feané ya̧ tȩ alu yóló ai daae mole ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tétepa Yesuné duraalu, “Dia̧kó whi̧ beta̧né ȩ olaa yaletikimó, ya̧lo fotoko̧ sókó felepa, ȩ né olaa yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Téró, so whi̧né keletómó kale soné ama yale ala hiranénipa, a̧ Yesuné hó ao̧mó deraapisa fóló fió molepó. Atéru, ama kisi bete wisi yó̧póló kisipa mutu olaa yalemó, kisi bete mo hapale tétitóró wisiyalepo. ");
INSERT INTO ppo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Téró, kale sopaae duraalu, “Ti senaale-ó, naao kisipa tiki tiraleteiné ya̧ ai wisiyalepa, hosaa muni deyóló dua fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kale sotamo ai fo du betepatei, fo wosetere be kaae tare topo whi̧ Jairus-né ama be whi̧ wóló a̧paae duraalu, “Naao senaale mo ti ai suka̧le ape. Térapa, yó matere whi̧paae fo me kae ini taalae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ai dere fo wosóló, Yesuné kale whi̧ Jairus-paae duraalu, “Naao senaaleta wisiyaalopa, ya̧ fomoyóló whaaliani, kisipa tiki beta̧ tirae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Atéró etéyalepó. A̧ kale fo wosetere be kaae tare topo whi̧ Jairus-né bemó sókó fóló duraalu, “Mepaae whi̧rape ȩtamo faai dapóló wao̧se. Pita, Jon, Jems, kale senaalené alimaró hamatamo beta̧ wó̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Atéró, sókó fóló kelalemó, kale senaale sukó̧ló mupa molóró fo tiki whaatamo du betepa, Yesuné atimapaae duraalu, “Ai senaaleta, sukuni noke firapa, diaao̧ fo tiki whaaró moló-utamo taalae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ai fo depa, atima mo so whi̧né kisipané i senaaleta, mo ti sukunapóló, a̧ do̧ nanalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tetepa, kale senaalené naasemó tao sóró duraalu, “Ti senaale-ó, ya̧ turukó holae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Atétepa, ama kepe bete a̧ tua̧paae momó biti̧ wouraalu, mo hapale tétitóró turukó holóló daayalepó. Tétepa, Yesuné atimapaae duraalu, “Me o̧lakó nó̧póló melae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Atétere ala kolóló, kale senaalené ama alimaró hamatamo hokomó sókó furaalu, sirayalepó. Tétepa, Yesuné atimaamopaae fo mulótu duraalu, “I ala yalepóló, mepaae so whi̧paae momókó yao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Atéró etéyalepó. Yesuné ama dosa̧ayóló sóró beteró betere 12 whi̧rape beta̧paae toura̧le ape depa, walepó. Atéró wóló betó mupa, ama doasi fotoko̧ bulóo, so whi̧ tua̧mó dowi keperape beteretei, dóló ho̧konótua yóo, mepaae kae kae kisi daale so whi̧rape wisirótua yóo, yó̧póló sóró beteralepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Atéró atima dotȩyaai duraalu, “Dia̧ be hulua doko̧ feapaae fóló, Kótóné tȩteróló kaae tare ao̧mó mole ala yó melóo, mepaae hepo daale so whi̧kélé wisiróo yaasepóló fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Atéró ama atimapaae duraalu, “Dia̧ furaalu dotó tikikélé, waró yotamokélé, mo nokole o̧lakélé, monikélé, kutikélé me dekaaporóló momókó sóró fao̧se. ");
INSERT INTO ppo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Dia̧ me be huluamó sókó fȩnalemó, beta̧ whi̧né dia̧ dape supa, ti ai whi̧tamotóró fitua yóló, fole sukamó ai be taalae. ");
INSERT INTO ppo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mepaae so whi̧né dia̧tamo dape sini depa, ti atimané yale alamó dapóló kisipa muó̧pólópa, ai be hulua taaróló faairaalu, diaao̧ hómó dakere hae terepée deróló fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Atéró atima fóló, be hulua doko̧ feamó kale fo wisi yó maté kwȩyóo, atima kotere be huluamó kisi muó mole so whi̧kélé, fea wisiraté kwȩyóo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Atima ai ala deté kutu beterapó dere fo Kaleli hae kwia tȩteróló kaae tare whi̧ Herot-né wosalepó. Mepaae so whi̧né kale suka̧le whi̧ Jon momó kepaayóló beterapóló deté fele fo wosetu, Herot-né ama kisipa tiki ko̧ló ko̧ló du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Atétepa mepaae so whi̧né duraalu, “Mo take betale whi̧ Ilaija wóló biturapó. Tétepa, mepaae so whi̧né du, mo take betóló suka̧le Kótóné ama ko̧ló whi̧rapekó, momó kepaayóló wou yalepó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tétepa kale topo whi̧ Herot-né duraalu, “Jon-ta, ya̧lo diki tare whi̧rapené depa tikalepa, aita demó dérópóló,” ama kȩle faai kisipa mualepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Téró, ama dotȩyale whi̧rape atima momó fesaae wóló, atimané yale alarape Yesupaae yó melalepó. Téró, ama atima maaté dape sóró, Betsaida be huluapaae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Atima atéró felepó dere fo so whi̧ mo turóné woseturaalu, a̧ sya felepó. Atima atéró a̧ beterepaae wapa, wisirapóló dape sóró, Kótóné tȩteróló kaae tare ao̧mó mole ala atimapaae yó melóo, mepaae hepo daapa wale so whi̧kélé wisiróo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Atéró, suka doropoletamo ama yó matepa wosetere 12 whi̧rape a̧ beterepaae wóló duraalu, “Da̧ta o̧lakélé meire tikimó beterapa, i so whi̧ felekemó tȩ mole berapepaae fóló atimané naaire o̧laró fiyaaire betamo atimanétei keka̧ai fó̧pólópa, dotonae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ti fo depa, ama atimapaae duraalu, “Diaao̧tei, atima naaire o̧la melae,” depa atimané a̧paae duraalu, “Da̧néta, bred o bula aporó yóo, ya tamo yóo, yóló beta̧ i mole ape. Térapa, naao kisipané i betó mole so whi̧né naaire o̧lakó da̧nétei dupune fó̧póló kisipa mute?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Atéró, aimó betó muale soró naale senaaletamo dosa̧ani, whi̧ maaté dosa̧ayóló touróturaalu, 5,000-rópó. Tépatei, ama yó matere whi̧rapepaae duraalu, “Dosa̧ayóló 50 whi̧rape kae kae yóló beteraté kwȩyae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tétepa, ama yó matere whi̧rapené so whi̧ fea taleróló beteraté felepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Atépa, Yesuné bred o bula aporó yóo, ya tamo yóo yóló taruraalu, hepen-paae kese holóló Kótópaae mo kée yóló terekée daalu yalepó. Téró, ama yó matere whi̧rapepaae melatepa, atimanémo so whi̧ feamó a̧liraté kwȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Atéró, atima fea nalemó su̧tepa, buki muni feletei, ama yó matere whi̧rapené siré kwȩyóló, 12 yorape deyóló fa̧analepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Téró, me sukamó etéyalepó. Ama yó matere whi̧rape atimasisi maaté moma du bitu, ama atimapaae duraalu, “Ai so whi̧ feané ȩ-a, depó du bitu de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ti fo depa, atimané duraalu, “Mepaae so whi̧né ya̧ta, wȩi tópuratere whi̧ Jon-pó, mepaae so whi̧né ti Elaijapó, mepaae so whi̧né ti mo take betale Kótóné ko̧ló whi̧rapekó kepaayóló bituraalu, du beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ai fo depa, ama atimapaae duraalu, “Dia̧néta ȩ depóló kisipa mute?” yalepó. Atétepa Pitané duraalu, “Ya̧ta, Kótóné so whi̧ fea tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Kerisopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ti fo depa, Yesuné atimapaae fo fotoko̧iné duraalu, “Pitané ai yale fota, so whi̧paae momókó yao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Téró ama duraalu, “Kale Whi̧né Naalema kae kae sekȩi ala saalo ai ape. Doasi whi̧ disirapenékélé, mo so whi̧mó Talepaae momaratere topo whi̧rapenékélé, Moses-né asȩre fo yó matere whi̧rapenékélé, a̧ mené dó̧póló, só deraalo ai ape. Téyaalotei, a̧ momó kepaayóló betaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Téró ama yó matere whi̧rapepaae duraalu, “Whi̧ me de ȩ fole tu̧mó waai kisipa mutepa, ti naao yaaire ala tȩteróló ya̧ dóló oleraaire filipaa ni naaotei beleyóló, betere doko̧ ȩ sya ape. ");
INSERT INTO ppo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mepaae so whi̧ dené ama betere bete me ala yao̧sórópóló amatei hotowaró kaae tapa, atétere so whi̧né betere bete aluyaalo ai ape. Téyaalotei, whi̧ me dené ya̧lo ala eróturaalu, Talepaae naaopóló taalatepa, atétere whi̧né betere bete aluni, mo ti betó tawaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Beta̧ whi̧né i haemó muó mole wisi wisi o̧la dekéró sóró beta̧paae du betere tua̧mó ama betere bete alutepa, ti me noa dupu wisikó saaloé? ");
INSERT INTO ppo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mepaae whi̧ de witu halemó, ȩkélé, ya̧lo fokélé tuȩ́nipó depa, kale Whi̧né Naalemakélé, Alimakélé, mo kae betere ensel-rapekélé ama mo kae ere dȩtamo wale sukamó, Whi̧né Naalemanékélé ai whi̧ a̧ tuȩ́nipó, yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Téyaalopa, ya̧lo dia̧paae mo i dere ape. Dia̧ i daae mole so whi̧ mepaae suka̧aipatei, Kótóné tȩteróló kaae tare ala mo kelaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesuné i forape yóló bitiré fóló, bokó waleró be dȩ kemetepa, etéyalepó. Pita, Jon, Jems, atima Yesuné dape sóró du sorokó molepaae moma yaairaalu felepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Atéró holóló momatu betalemó, ama kelepaa kae daane wóo, ama deró betere kutikélé mo epée dȩ kaae yó fóó, yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Atére tua̧mó, whi̧ tamo Moses-ró Elaijatamo mo kae ere dȩtamo sókó wóló, Yesutamo fo du betepa kelalepó. Atima atéró du betale fota, Yesu a̧ i hae taaróló hepen-paae momó fesaae faaire ala dokonóló, Jerusalem bemó eraalopó du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitaró ama fulumu whi̧rapetamo noke fi turukó horóló kelalemó, kale whi̧ tamo mo doasi ere dȩ tua̧mó daalu, Yesutamo fo du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Atéró, kale whi̧ tamo Yesu taaróló faai depa Pitané duraalu, “Yó matere doa whi̧-ó, da̧ fea etéró betere ala mo wisirapó. Da̧né dia̧mó furu be sore tȩnaai kisipa mutapó. Me ya̧mó tȩnóo, me Moses-mó tȩnóo, me Elaijamó tȩnóo, yaalopó,” yalepó. Aita, Pita a̧ noa fo enénitepa, ko̧ló ko̧ló duraalu yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitané atéró fo du betepatei, sa̧ko dorowóló atima husuratepa, doasi winé sukutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ai sa̧ko dolomó i fo yalepó. “Ita, ya̧lo Naalepó. A̧ sókó sóró, ya̧lo kae beteró beterapa, ama dere fo wosae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ai fo yóló kemetepa kelalemó, Yesu a̧ beta̧ daapa kelalepó. Ama yó matere whi̧rape atimané ai kelale alarape mo so whi̧paae ini, hiróló bitiré felepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Atéró be dȩyó hotepa, atima ai du sorokó mole tiki taaróló dorowou betalemó, so whi̧ mo ha̧le o̧la kaae a̧tamo tu̧mó hokolaa yaai walepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ai so whi̧ betó mole kua dolomó beta̧ whi̧ turukó holóló daalu, fo tokoróló duraalu, “Yó matere whi̧-ó, ya̧lo mo beta̧ naale naao wisira̧le waaloé? ");
INSERT INTO ppo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Suka fea dowi kepené a̧ taneta depa, keterȩ́ yóló ama ko̧ló dako sókó wua dapó. Até duraalu, dowi kepené a̧ taaróló feni, fotoko̧né ama tiki feseróló, hó naasekélé sosoro faróló mo dorótua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Até du betepa, naao yó matere whi̧rapepaae ho̧konaaloé? yóló wosalemó, atima su̧nipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ai fo depa, Yesuné atimapaae duraalu, “Mió i alimó kisipa tiki tiréni, dowa̧ae fóló kó̧paae fu betere so whi̧-ó, dia̧ tu̧ wisipaae fó̧póló ȩ dia̧tamo betale supa, ai naale ipaae dapesó ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kale naale dapesó wou betepatei, dowi kepené haepaae taae deralepó. Atéró haemó mulu, feserótu betepa, Yesuné kale keperape foné sóró duraalu, ai naale tua̧mó beteretei ho̧kó faróló, alimapaae malepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","44","Kótóné doasi fotoko̧né eralepóló, so whi̧ feané kilituraalu, siratu betalepó. Yesuné atéró yale alamó so whi̧ feané haió, i-a noa ala yalerópóló, siratu betepa, ama yó matere whi̧rapepaae duraalu, “Ya̧lo dia̧paae i yaaitere fo mo wisiyóló wosóló kisipa muae. Kale Whi̧né Naalema mo whi̧rapené dó̧póló, mené eleké deyaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ama atéró yale fo kinóló moleteiné bete atima wisiyóló kisipa initepa wosaai yalemó, atima wituraalu taaralepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Téró, Yesuné ama yó matere whi̧rape atimasisitei de doasi topo whi̧ beteré yóló, u só derólu i só derólu dere ala kaae salepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Atimané atéró mutere kisipa Yesuné kolóló, naale beta̧ tao sóró turukó horóló a̧ daale dȩmó daalalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Téró, ama atimapaae duraalu, “Whi̧ me dené ya̧lo doimó etei kaae naale wisiyóló dape supa, ti ȩtei dape sirapó. Whi̧ me dené ȩ wisiyóló dape supa, ti ȩ dotȩyale sekȩ́tei dape sirapó. Whi̧ me de dia̧ tua̧mó naale beleka̧amale aleyóló belei betepa, ti a̧ doasi whi̧ ai betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ai fo depa wosóló, Jon-né duraalu, “Tale doa whi̧-ó, beta̧ whi̧né naao doi yóló dowi kepe ho̧konótu betepa, a̧ta da̧kó meipóló kisipa mutu, da̧né a̧paae atékese yóló, sesé du betalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ai fo depa, Yesuné a̧paae duraalu, “Diaao̧ a̧ sesé yao̧se. Ti noatepae, mepaae dia̧tamo bóe dinitere whi̧ta, ti dia̧tamo mole whi̧ ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Téró, Yesu i hae taaróló hepen-paae dapesó holaai feleke deremó, a̧ me tikipaae faai kisipa muni, Jerusalem be huluapaae maaté faai fotoko̧ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Téró, Yesu a̧ nalo faairaalu, mepaae whi̧rape beró naaire o̧latamo donoróló mulaai atimapi fó̧póló dotonatepa, atima Samaria hae tua̧mó tȩne bemó sókó felepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Téyaletei, ai be hulua so whi̧ feané a̧ Jerusalem bepaae faai wale kilitu, dape sinipó. ");
INSERT INTO ppo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Atétere ala kilitu, ama yó matere whi̧tamo Jems-ró Jon-tamoné a̧paae duraalu, “Tale-ó, i be huluamó betó mole so whi̧ fea hepen-mó mole si dorowó̧póló yaé yóló kisipa mute?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Ai fo depa, Yesu a̧ fetée fóló atimaamo foné sóró, atima me be huluapaae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Atéró atima fu betalemó, tu̧ tua̧mó whi̧ beta̧né a̧paae duraalu, “Ya̧ mopaae fupa, ti ȩkélé ya̧tóró sya waalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ai fo depa, Yesuné duraalu, “ Ha̧onarapeta, atima fitere tiki yóo, barapekélé fiyaaire dépi daayóo eretei, Whi̧né Naalema beta̧ toró mulóló fiyaaire tiki inipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Atéró, whi̧ mepaae duraalu, “Ya̧ ȩ sya ape,” yalepó. Ai fo depa, kale whi̧né duraalu, “Tale-ó, folosóró ȩ ya̧lo ayapi doura̧le fulapa, wisire?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ai fo depa, Yesuné a̧paae duraalu, “Sukune ao̧re whi̧né ti sukune whi̧ douró̧póló, ya̧ ti Kótóné tȩteróló kaae tare ao̧mó mole ala yó maté kwȩyae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Atéró, me whi̧nékélé duraalu, “Tale-ó, ȩ ya̧ sya waaitei, ya̧lo hae ayapaae ko̧leó fo ene faai kisipa mutapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ti fo depa, Yesuné a̧paae duraalu, “Whi̧ me de ama kutó ditu bitutei, dȩpaae kele mulatere whi̧né Kótóné tȩteróló kaae tare ao̧mó mole kutó diraaire su̧nipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Atéyale ki̧lipaae. Talené mepaae 72 whi̧rape sóró beteróló, a̧ faai dere be hulua doko̧paae atimapi fó̧póló, tamo tamoyóló dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Atéró dotȩyaai atimapaae duraalu, “Kutómó o̧la mo dekéró u̧lumépatei, ai o̧la saaire whi̧ beta̧ doaló meipó. Térapa, ai o̧la sere ala tȩteróló kaae tare Talené mepaae whi̧rapekó ai kutópaae dotonó̧póló, Talepaae kemayae. ");
INSERT INTO ppo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dia̧ bete ha̧orape betere tua̧paae sipsip hupu malerape kaae, ya̧lo i dotonatere ape. ");
INSERT INTO ppo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Dia̧ furaalu moni detere bekélé, mo yokélé, hó bekélé, sóró fao̧se. Tu̧mó furaalu, so whi̧paae ko̧leó fokélé ini, fó beta̧ yae. ");
INSERT INTO ppo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Dia̧ beta̧ whi̧né bemó sókó furaalu, Kótóné hosaa muni deyóló dua betere ala dia̧ tua̧mó muló̧póló yae, fo beta̧ yae. ");
INSERT INTO ppo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ai be tua̧mó hosaa muni deyóló dua betere whi̧tamo betepa, ti Kótóné hosaa muni deyóló dua betere ala ai whi̧ tua̧mó muaalopó. Meipa, ti ai ala dia̧tamo momó fesaae waalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ai fitere bemótóró bitu, atimané dia̧mó matere o̧laró wȩitamotóró nuku betae. Ti aita, diaao̧ diteremó kutómó dupu dono ai sere ape. Térapa, dia̧ be doko̧ ho̧ko fité kuni, fitere bemótóró fitua yae. ");
INSERT INTO ppo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Téró, dia̧ beta̧ be huluamó sókó fenalemó, ai be hulua so whi̧né dia̧ wisiyóló dape sóró o̧la matepa, ti ai o̧latóró nae. ");
INSERT INTO ppo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Atéró bitu, ai be huluamó kisi daae mole so whi̧ wisirótua yae. Diaao̧ atimapaae yó mótu, ‘Kótóné tȩteróló kaae tare alakélé dia̧ beterepaae mo felekemó wale ape,’ fo yae. ");
INSERT INTO ppo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Téyaalotei, dia̧ beta̧ be huluamó sókó fenalemó, atimané dia̧ wisiyóló dape sinitepa, ti ai be bela tua̧mó daalu, atimapaae i fo yae. ");
INSERT INTO ppo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Diaao̧ yale alamó, dia̧né be hae da̧né hómó dakeretei diaao̧ keletómó i helekȩtere ape,’ fo yae. Dia̧né dowa̧ae fu betepa, Kótóné tȩteróló kaae tare ao̧mó mole ala mo felekemó waalopa, dia̧ diriyóló kisipa muae yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Atéró, Yesuné ama yó matere whi̧rapepaae duraalu, “Ya̧lo dia̧paae mo i dere ape. Kótóné i haemó betó mole so whi̧ taletere sukamó, Sodom be huluamó betó mole so whi̧paae doasi sekȩi ala eraalotei, dia̧ wisiyóló dape sinitere be hulua so whi̧paae eraaire sekȩi alata, mo doasi bosenóló eraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Korasin beró Betsaida be huluatamomó betó mole so whi̧ dia̧ tua̧paae doasi sekȩi ala waalopa, dia̧ mo wió yae. Ti noatepae, i be hulua tamomó erale kelemei kaae, Tair-ró Saidon be huluatamomó erólua̧sóró, ti atima mo taketitei yei kuti bukóo, kili diyóo, yóló kisipa feteyóló bitua̧pó. ");
INSERT INTO ppo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Téyaalotei, Kótóné fo tokó̧ló tale dere sukamó Taia-ró Saidon be hulua so whi̧tamopaae sekȩi ala eraalotei, dia̧paaeta, ai bosenóló mo doasi sekȩi ala eraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Dia̧ Kapeneam be hulua so whi̧-ó, diaao̧ kisipané dia̧ Talené ó sa̧paae dapesó horaalopóló de? Meipa, doa ko̧leó. Whi̧ mo ti sukó̧ló aluyaaire dolopaaetei derepaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tétepa, Yesuné ama yó matere whi̧rapepaae duraalu, “Mepaae diaao̧ dere fo wosetere so whi̧né ti ya̧lo dere fokélé wosetapó. Mepaae so whi̧ dené dia̧ hó̧ratepa, ti ȩkélé hó̧ratapó. Téretei, mepaae whi̧ dené ya̧lo dere fo woseni nisiyóló hó̧ratepa, ti ȩ dotȩyale whi̧kélé hó̧ratapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Téró, kale dotȩyale 72 whi̧rape hȩkesetamo momó fesaae wóló duraalu, “Tale-ó, da̧né naao doi yóló dowi keperape doló ho̧konatepa, da̧né dere fo mo beta̧ wosóló fua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ti fo depa, ama atimapaae duraalu, “Hepen bemó dowi Satan epée dȩ kaae fita̧a deté i haepaae dorowapa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Dowi wuliró to̧rapetamo dia̧né tȩya depa, da̧né bóe whi̧ Satan-né bole fotoko̧né dia̧ doraalomeipó. ");
INSERT INTO ppo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ti ai alata motei, kale dowi keperape dia̧ ao̧mó sukó̧ló beteremó hȩkeseni, hepen bemó diaao̧ doi asȩyóló moleteimó beta̧ dia̧ hȩkesetu betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Atéyale sukamó, Yesu a̧ Dȩi Kepe Wisiné fotoko̧ratepa, doasi hai̧né sukutu duraalu, “Hepen beró haetamo aleóló muló betere Aya Tale-ó, skul yóló doasi kisipa sere whi̧raperó fea ala tuȩ́re whi̧rapetamoné kelao̧sóró kinóo, ketei ao̧re whi̧rapené koló̧póló, ha̧kearóo dere kilitu, ya̧lo ya̧paae mo kée yóló, naao doi sóró horatapó. Aya-ó, aita mo naao kisipa mole alatóró erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Téró, Yesuné atimapaae duraalu, “Ai ala feata, ya̧lo tȩteróló kaae tanó̧póló, Ayané ȩpaae meló beterapó. Whi̧ beta̧nékélé Naalema tuȩ́ni, Alimané beta̧ tuȩ́rapó. Atére kaae, Alimakélé whi̧ beta̧né tuȩ́ni, Naalemané beta̧ tuȩ́rapó. Atérené Naalemané ama Aya i ape yóló yó melaai tuȩ́ mole so whi̧paae yó matepa, ai so whi̧né maaté Alima tuȩ́nérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Téró, Yesu a̧ ama yó matere whi̧rape atimanale bitu, a̧ atima beterepaae fetée fóló duraalu, “Mió diaao̧ kelené i kilitu betere ala tuȩ́ sere so whi̧ Kótóné wisiró beterapóló, hai̧né sukutu beteró̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ti noatepae, ya̧lo dia̧paae mo i dere ape. Mió keletere ala take betale ko̧ló whi̧raperó topo whi̧rapetamoné kelenée deté waletei kilini yóo, diaao̧ wosetu betere fokélé wosenée deté waletei woseni yóo ipakalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Téró, Moses-né asȩre fo yó matere whi̧ beta̧ turukó holóló Yesu su̧sóró duraalu, “Yó matere whi̧-ó, ȩ mo ti betó tawaairaalu, noa alakó yaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ti fo depa ama duraalu, “Ai asȩmó noa fo ere? Ai yóló muló betere fo dosa̧atu, naao noa kisipa mute?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ai fo depa, kale whi̧né a̧paae tokó̧ mótu duraalu, “Tale Kótópaae hȩkesené sinóló yaala sókó fole alata, naao hosaa turónékélé, kepe turónékélé, fotoko̧ turónékélé, kisipa tiki turónékélé, du betae. Tétu, naaotei ya̧ hȩkesené sukutu dere kaae, naao be whi̧ so whi̧paaekélé, atéró hȩkesené sukó̧ló yaala sókó fu betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ti fo depa, Yesuné kale whi̧paae duraalu, “Aita, naao mo dono tokó̧ matapa, ya̧ mo ti betaasepóló, ai alatóró ha̧le yó tawae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Téró kale whi̧né ama yale fonétei a̧ só deranépa, a̧ donore whi̧ ao̧yóló Yesupaae woseturaalu, “Naao ȩpaae be whi̧pó dere fo-a, demó de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ai fo depa, Yesuné duraalu, “Whi̧ beta̧ i Jerusalem be taaróló, Jeriko bepaae durupu betalepó. Téyalemó, o̧lémi nokole whi̧rape tu̧ tua̧mó melaa muóló, ama kuti sorokóló taae faróló a̧ susupuróló felekemó suka̧ai du betepa atima felepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Atéró, Talepaae momaratere whi̧ beta̧ ai kale whi̧ derepele tu̧mó durupuraalu kelalemó, kale whi̧ tu̧mó mupa, dekeróló a̧ dȩmó derepelepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Atétepa, beta̧ Lipai fake whi̧ a̧kélé sókó walemó, kale whi̧ sinóló mupa kolóló, dekeróló a̧kélé dȩmó felepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Téyaletei, beta̧ Samaria whi̧ a̧kélé kale whi̧ mole tikimó sókó wouraalu kelalemó, ko̧lei ala epa kilitu, ama tao saai kisipa mualepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Atéturaalu, a̧ kale whi̧ mole felekepaae fóló, kale whi̧né doalére tikimó wel wȩiró wain wȩitamo dilóló dokalepó. Téró, kale whi̧ ama donki hupu tómó beteróló fóló, uké whi̧rape fitua dere bemó beteróló, kale whi̧ ama mo wisiyóló kaae tarepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Téró, be dȩtepa hi̧ka kale whi̧né ama silpa moni tamo sóró, kale uké whi̧rape fitere be kaae tare whi̧paae duraalu, ‘Ya̧lo i matere moniné a̧ kaae taté felalemó, ai moni tamo kemetepa, ti ȩ wóló naao moni ya̧lo tokó̧ melaalopa, a̧ mo wisiyóló kaae tawae,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Téró, Yesuné kale Moses-né asȩre fo yó matere whi̧paae duraalu, “Naao kisipané i whi̧rape sorekó mé whi̧ kale dale whi̧né ama be whi̧ kaae ao̧yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ti fo depa, kale whi̧né momó tokó̧ mótu duraalu, “Ko̧lené sukutu tao sale whi̧pó,” yalepó. Ai fo depa, Yesuné a̧paae duraalu, “Ama yale ala kaae, naaokélé yaai fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Téró, Yesu a̧ ama yó matere whi̧rapetamo tu̧mó fité woló, Mata betere be huluamó sókó wapa, Matané a̧tamo betaai dape salepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Matané kema Mariakélé Yesuné hó ao̧mó bituraalu, ama dere fo wosetu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Atétu betepatei, Marta a̧ atima naaire o̧lamó bipi du bituraalu, ama yó matere fo wisiyóló wosenipó. Atétepa, kale so Yesu beterepaae wóló a̧paae duraalu, “Tale-ó, ȩ ya̧lo wotoró depe tukó wei ala du beterapa, ama ȩ tao sene wó̧póló, naao a̧paae dumié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ti fo depa, Talené a̧paae duraalu, “Ti senaale Mata-ó, ya̧ta mepaae ala noa yaaloé yóló, doasi whaalia du betereteiné ya̧ ai só deró betere ape. ");
INSERT INTO ppo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Téretei, mo doasi topo o̧la beta̧ ya̧ seni, ya̧ya̧ ai ere ape. Mariané ama beta̧ mo doasi topo o̧lapóló kisipa muóló sóró taretei da̧né fasó saalomeipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Téró me sukamó. Yesu a̧ me tikimó bitu, moma du beterepó. Atéró, moma yóló kemetepa, ama yó matere whi̧ beta̧né a̧paae duraalu, “Tale-ó, Jon-né ama yó matere whi̧rapepaae Kótópaae momatere ala yó melale kaae, naao da̧kélé yó melaasepé,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ai fo depa, ama atimapaae duraalu, “Diaao̧ Talepaae moma dere ala etéró yae. ‘Aya-ó, ya̧ta dowi ala mo beta̧kélé munire Kótó betereteiné so whi̧ feané naao doi wisinaale doasi muló̧póló yae. Naao tȩteróló kaae tare ao̧mó mole ala wisi wó̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Be dȩ doko̧ beta̧ beta̧mó da̧né naaire o̧la naao su̧mó a̧lae. ");
INSERT INTO ppo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mepaae so whi̧né da̧paae erale dowi ala kwia tani, me o̧la meipóló ha̧le kemeratapa, da̧né dowi ala kwiakélé naao ha̧le kemerae. Téturaalu, su̧ sere alané da̧ deé nalao̧sóró, naao da̧ a̧lisóró fae.’” ");
INSERT INTO ppo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Téró, ama atimapaae duraalu, “Dia̧kó beta̧ whi̧né ama fulumu whi̧ saletómó wóló betepa, a̧ diliki su̧ tua̧tamo ama noma beterepaae fóló duraalu, ‘No-ó, ya̧lo fulumu whi̧ mióti sókó waleteteiné naaire o̧la meitepa, ya̧paae bred o bula sorekó a̧ maletamo melaasepé fo dekéró yó tapa, noa ala yaaloé?’ ");
INSERT INTO ppo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ai be dolomó betere whi̧né i fo yaalopó. ‘Be tu̧ kinóló ya̧lo naale senaaletamo fireteiné turukó holóló, naao kematere o̧la menanénipa, ȩpaae dotopoi fo ekesé,’ dua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ya̧lo dia̧paae i dere ape. Kale whi̧ a̧ halaainé kematóró ha̧le yó tapa, ama fulumu whi̧ turukó horóló kematere o̧la manénipatei, mo su̧mótóró melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Atérapa, ya̧lo dia̧paae i dere ape. Talepaae me o̧lakó kematepa, ai kematere o̧la melóo, keketepa ti ai o̧la mo kolóo, tu̧ tuki̧yae yóló tu̧ dupa, ti tuki̧ yóo yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ti noatepae, mepaae kematere so whi̧né ti mo sua dapó. Mepaae so whi̧né keketepa ti ai o̧la mo kilitua dapó. Mepaae so whi̧né tu̧ tuki̧yae yóló tu̧ dupa, atétere so whi̧ wó̧póló tu̧ tuki̧tua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Dia̧kó me whi̧né diaao̧ naale senaalené yakópóló kematepa, ya taaróló, dowi wuli male melaaloé? ");
INSERT INTO ppo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ó naao senaale naalené ba kekó ‘A̧lae’ depa, ai kematere o̧la taaróló, whi̧ tukó nokole to̧ melaaloé? Meipó. ");
INSERT INTO ppo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Dia̧ dowi ala du betere whi̧rape bitutei, diaao̧ naale senaalemó wisi wisi o̧la matere ala diaao̧ ai kisipare ape. Atére kaae, mepaae so whi̧ dené Dȩi Kepe Wisi kematepa, ó hepen-mó betere diaao̧ Aya Talené mo melaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Téró me sukamó etéyalepó. Dowi kepené whi̧ beta̧ ko̧ló nomonó betepa, Yesuné dóló ho̧konalepó. Atétepa, kale dowi kepe sókó furaalu, ama fo kaae sóró deremó, ai touró betere so whi̧ feané sirayalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Atétepa, mepaae so whi̧né duraalu, “Aita, dowi keperapené topo kepe Belsebul-né fotoko̧ratepa, dóló ho̧konótu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ai fo depa, mepaae whi̧rapené ama noa ala deró a̧ su̧ sóró ka̧ae kilituraalu, a̧paae hepen bemó mole beta̧ fareyópu eratapóló da̧né kisipa yaaipa, erae yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Atéró mutere tuȩ́ tiki Yesuné kisipa yóló atimapaae duraalu, “Mepaae doasi topo whi̧rape atimané tȩteróló kaae tare tua̧mó atimasisitei bóe dupa, ti tȩteróló kaae tare ala mo haepaae doropóló doyóo, beta̧ be huluamó betó mole so whi̧kélé atimasisitei bóe dupa, ti ai be haepaae doropóló mo doyóo yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satan ama fake atimasisitei bóe dupa, ti ama tȩteróló kaae tare ala netéró fotoko̧ buaaloé? Ya̧lo i dere fota, diaao̧ ȩpaae ya̧ dowi keperapené topo kepe Belsebul-né fotoko̧ratepa, ho̧konótu beterapó depa i dere ape. ");
INSERT INTO ppo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ti diaao̧ ȩpaae topo kepe Belsebul-né fotoko̧ratepa, dóló ho̧konalepó dere-a, dia̧ fakenékélé dóló ho̧konótu betere ala né fotoko̧ratepa de? Motamo Kótóné fotoko̧ bulatepa dapó depa, ti fo tokó̧ló taletere sukamó atimanétei dia̧ só deraalopó. ");
INSERT INTO ppo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Téretei, ya̧lotamo Kótóné fotoko̧né dowi keperape dóló ho̧konélipa, ti Tale Kótóné tȩteróló kaae tare ao̧mó mole ala dia̧ tua̧paae wóló i mole ape. ");
INSERT INTO ppo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Fotoko̧ bole whi̧né be ó o̧la o̧la mepaae whi̧né dorao̧sóró, sesé duraalu, kale whi̧né ama to̧ró dikitamo tawóló, siki siki yóló kaae tapa, whi̧ mené doraalomeipó. ");
INSERT INTO ppo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Téretei, mepaae doasi fotoko̧ bole whi̧né bóe sókó wouraalu, kale doasi fotoko̧ bole whi̧ dóló tȩteróló, bóe dele o̧la o̧lakélé fea fasóló, ama bemó muó mole wisi wisi o̧lakélé fea sóró ama be whi̧tamo a̧li yaai sóró fulapó. ");
INSERT INTO ppo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Whi̧ me de ȩtamo beta̧mó bitinipa, ti ȩtamo bóe dilapó. Whi̧ me de ȩtamo bitu, ȩ fasóló o̧la o̧la beta̧paaeróló munénitepa, ai whi̧né ya̧lo o̧la o̧la ho̧ko besekératapó. ");
INSERT INTO ppo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Atéró, kale dowi kepe whi̧né depe tua̧mó beteretei, sókó furaalu kópui hae tikipaae a̧ feléyóló betaaire tiki keka̧airaalu fua dapó. Atéró fóló, kelenalemó betaaire tiki kilinitepa, a̧ take betale be kelaai momó fesaae faai dapó dua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Atéró a̧ sókó wóló kelenalemó, kale be wisiyóló fuóló taae faróló, wisiró betepa keletapó. ");
INSERT INTO ppo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Téró, kale dowi kepe a̧ momó fóló, mepaae dowi ala mo turó fa̧ane wȩikeró keperape dape sóró, kale bepaae momó biti̧ walapó. Atétepa, kale whi̧ a̧ take bitu sawa doyaletei, mió mo ti doyó faalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Atéró Yesuné ai forape du betepa, so whi̧ fea betó mole kuamó so beta̧né fo fakeyóló duraalu, “Ya̧ deyóló awa̧ male so naao hae Tale Kótóné wisiró beterapa, a̧ hai̧né sinóló beteró̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ti fo depa, Yesuné atimapaae duraalu, “Ai dukiratere fota mepaae whi̧ de Kótóné fo wosóló, sya fóló erótu betere so whi̧ta, Tale Kótóné wisiró betereteiné hai̧né sukutu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Téró, so whi̧ fea wóló touró betepa Yesuné duraalu, “Mió i alimó betere so whi̧ dowi alané fa̧anutei, ȩpaae doasi sira yaaire me fareyópukó erae du beterapó. Tépatei, me kae eraalomeipa, mo take Jonapaae erale ala kaae beta̧ eratepa kelaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ti noatepae, Ninipa so whi̧né Jonapaae erale fareyópu kilituraalu, ita Kótóné dotonale whi̧póló kisipa moipakalepó. Atéyale kaae, mió i alimó betere so whi̧nékélé Whi̧né Naalemapaae eratere ala kilituraalu, ita Tale Kótóné dotonó betere whi̧pó kisipa muaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Beta̧ Saoti hae kwia tȩteróló betere doasi topo kwin soné mió i alimó betó mole so whi̧tamo fo tokó̧ló taletere be dȩmó, dia̧ só deraalo ai ape. Ti noatepae, ai sota hae kwia dene falepaae biti wóló, Solomon-né fosó fosói kisipa muóló yó matere fo wosaai walepó. Téyaletei, Solomon-né mole kisipa bosenóló whi̧ beta̧ i betere ape. ");
INSERT INTO ppo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Téretei, Ninipa be hulua so whi̧ró dia̧ mió i alimó betó mole so whi̧tamo só deraai fo tokó̧ló taletere be dȩmó atimanétei dia̧ só deraalopó. Ti noatepae, atima Jonané yó mótu betale fo wosóló, kisipa tiki feteyalepó. Tépatei, Jonakélé tȩteróló bosenée fale mo doasi sekȩ́ whi̧ beta̧ wóló i betere ape. ");
INSERT INTO ppo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mo whi̧ beta̧nékélé, lamp sa̧ dȩróló kinéli tikipaae ó nukuné husiróló mulótimipó. Dȩróló daalótua dere tikimótóró mulótua dapó. Mepaae so whi̧ be dolopaae wapa, ai dȩmó beteró̧póló, dȩró beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Naao keleta, ti tiki turó dȩró betere lamp sa̧ su̧ ai ape. Naao kele tamo wusuró wisipa, ti naao tikikélé turó dȩrapó. Téretei, naao kele tamo wusuró dilikipa, ti naao tikikélé turó dilikirapó. ");
INSERT INTO ppo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Naao tiki tua̧mó dó tare dȩ diliki yao̧sóró, mo hotowa yóló kaae tawae. ");
INSERT INTO ppo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Térapa, naao tiki turótamo dȩpa, ti tiki me kwiapaae sawa dilikikélé ini, tiki featóró dȩyó furaalu, belapaaekélé sókó faalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuné ai fo yóló kemetepa, Farisi whi̧ beta̧né a̧tamo o̧la naairaalu ama bepaae dapesó fóló, o̧la nukuatere ni fake tómó tiróló beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Atéru, Yesu o̧la naairaalu, atimané mara mole ala sya furaalu, folosóró ama naase fokunitepa, kale Farisi whi̧ a̧ hokomó sókó fu sirayalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Atétepa Talené a̧paae duraalu, “Aita motei, dia̧ Farisi whi̧né o̧la nokole nukuró wutitamo ha̧le tómó ere bólu maaté fukutua dapó. Téturaalu, diaao̧ tiki tua̧paaeta, ti fea o̧la senée yóló ekȩletere alaró ukusitere alatamoné ai fa̧ane ape. ");
INSERT INTO ppo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Dia̧ okokoi tuȩ́ mole whi̧rape-ó, Kótóné diaao̧ tó tikimó ere ala fea taleturaalu, u tua̧paaekélé tale dumipóló de? ");
INSERT INTO ppo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Diaao̧ nuku tua̧mó mole o̧la sóró yolealere so whi̧ tao sóró melae. Atétepa, ti diaao̧ tiki tua̧mó ere ala fea Kótóné kilitu, mo koko̧rapó fo yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Farisi whi̧rape-ó, dia̧né kutómó ere sawa o̧lakélé naase tamo supa, dekeyóló beta̧ Kótópaae ha̧le móturaalutei, mo donotóró taletere alaró Kótópaae yaala sókó fole alatamo sisópaae erótu beterapó. Atére alamó doasi sekȩi ala dia̧ tu̧paae waalopa, wiyó yae. Donoyóló taletere alaró Kótópaae yaala sókó fole alatamo touróló, Kótópaae ha̧le matere alakélé ua̧sóró mo wisi ua̧pó. ");
INSERT INTO ppo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farisi whi̧rape-ó, dia̧ fo wosetere bepaae furaalu, doasi doi mole whi̧rape bitua dere tikimótóró betaai ekȩle yóo, o̧la dotonatere tikimó daalukélé, so whi̧né doasi whi̧ wisi-ó yóo, yóló dukiratere koko̧mó ai ala dua dapó. Atétere alamó dia̧paae doasi sekȩi ala waalopa wiyó yae. ");
INSERT INTO ppo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Farisi whi̧rape-ó, dia̧ta u tu̧paae whi̧ dou epatei ha̧le tiki ao̧pa, ai tómó so whi̧ fua wua du beterapó. Ti dia̧ta, douró betere whi̧ kaae ao̧rapa, wiyó yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tétepa, Moses-né asȩre fo yó matere kisipa fosóre whi̧né a̧paae duraalu, “Yó matere whi̧-ó, naao ai dere forapené da̧ mo ti só deratapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ti fo depa Yesuné duraalu, “ Moses-né asȩre fo yó matere whi̧rape-ó, diaao̧ so whi̧paae i ala yae, i ala yao̧se, du betere alata, doa sekȩi o̧la so whi̧né hu̧lumó belerótu dere kaae du beterapó. Ai sekȩi o̧la diaao̧ belerótu bitutei, atima fasóló tao sere alamo dumipó. Atérapa, dia̧paae waaire sekȩi alamó wiyó yae. ");
INSERT INTO ppo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Take diaao̧ noutererapené dale Kótóné ko̧ló whi̧rape dourale tiki be wisiyóló tȩnótu beterapó. Mió atétu betere alané diaao̧ ayarapené whi̧ dale ala wisirapóló, ha̧keamó yó matapó. Atéteremó dia̧paae doasi sekȩi ala eraalopa, wiyó yae. ");
INSERT INTO ppo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Atéró betale alamó Kótóné ama fosó fosóre kisipa sya furaalu, i fo erapó. ‘Ya̧lo ko̧ló whi̧raperó aposel whi̧rapetamo atima beterepaae dotonaalotei, mepaae whi̧ mo ti dóo, mepaae ha̧le susupuróo yaalopó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Atérapa, mo take kaae sóró dilé wale ko̧ló whi̧rapené samearó mió diaao̧ du betere whi̧rapené sameatamomó kwia turó mió i alimó betere so whi̧ diaao̧ saalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ita, mo dapó. Atéyaaire alata, Abel-mó kaae sóró dilé wóló, kale momatere bemó Kótópaae simó suku̧laa dalatere tikiró kae tukóló muló betere be ke tua̧mó dale whi̧ Sekaraiamó da̧le yóló kwia feata, mió i alimó betó mole so whi̧né saalopó. ");
INSERT INTO ppo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Moses-né asȩre fo yó mótu betere whi̧rape-ó, Kótóné mo bete mole alapaae sókó faaire so whi̧ fao̧sóró tu̧ tuki̧tere ki diaao̧ fasó salepó. Ti dia̧ta, ai tu̧mó fumitei, atima faai du betere so whi̧ diaao̧ sesétu beterapó. Atétere alamó dia̧ doasi sekȩi ala saalopa, mo wiyó yae!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ai fo yóló kemetepa, Yesu a̧ felemó, kale Farisi whi̧raperó Moses-né ere fo yó matere whi̧rapetamoné a̧ só deraairaalu, deteraai fo du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Aita ha̧le mei, a̧ ha̧sókó fuléró kelaai kae kae wosetere fo du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Atéró, so whi̧ mo dekéró wale tikimó hae tiki fa̧apa, folosóró Yesuné ama yó matere whi̧rapepaae duraalu, “Farisi whi̧rape tua̧mó bole yist dia̧paae tekao̧sóró hotowaró kaae tawae. Atimata tiki tua̧paae dopatei, tó tikimó ha̧le wisire nisi du beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Mió kilini hiró betere ala fea, take ha̧kearatepa so whi̧ feané kolóló tuȩ́ yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Diaao̧ diliki tua̧mó du betere fo dȩmó depa wosóo, be dolomó dua kikiti dere fo be huluamó daalu fakeyóló depa so feané wosóo, yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Norape-ó, dia̧paae i dere fo wosae. Mepaae whi̧rapené diaao̧ tó tikita dóló sukunaalotei, take dia̧paae me ala eraalomeipa, ai alapaae wiyao̧se. ");
INSERT INTO ppo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Wiyaai depata, ti naao mo tikikélé, kepe betekélé, doróló mo ti dó tare sipaae deraaire fotoko̧ bole Kótó beterapa, a̧paae beta̧ mo doasi wiyae. ");
INSERT INTO ppo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Sonaai moni ke tamoné aporó ba beleka̧atiki dupunérapó. Atére barape beta̧kélé Kótóné kisipa keterótimipó. ");
INSERT INTO ppo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dia̧ta, ai ba beleka̧atikitamo su̧ni, Kótóné ama hosaa mole doasi o̧la ai ape. Diaao̧ topo nikikélé Kótóné ama su̧mó dosa̧ayóló kisipareteiné dia̧ wiyao̧se. ");
INSERT INTO ppo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ya̧lo dia̧paae mo i dere ape. So whi̧ feané kele tómó mepaae whi̧né duraalu, Yesuta ȩ tȩteróló kaae tare Talepó depa, Whi̧né Naalemanékélé Kótóné ensel-rapené keletómó a̧ ya̧lo fo eratere whi̧pó yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Téyaalotei, whi̧ me dené so whi̧ feané keletómó a̧ Keriso fake meipó depa, ti Whi̧né Naalemanékélé, Kótóné ensel-rapené keletómó ai whi̧ a̧ kisipanipó yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mepaae whi̧ dené Whi̧né Naalema eróló foné só deratepa, ai dowi ala kwia kemeróló aluranérapó. Tépatei, kale Dȩi Kepe Wisiné ditere kutó faleyóló só deratepa, ai kwia mo aluranénipó. ");
INSERT INTO ppo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","Bóe whi̧rapené fo wosetere bepaae ó so whi̧ tȩteróló kaae tare whi̧rapepaae ó Gavman-né sóró beteró betere topo whi̧ beterepaae fo teka̧ai dapesó fupa, dia̧ noa fo yaaloé yóló, whaalia yao̧se. Ti noatepae, atétere sukamó diaao̧ yaaitere fo fea Dȩi Kepe Wisiné yó melaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tétepa so whi̧ fea touró betere kuamó, whi̧ beta̧né Yesupaae duraalu, “Yó matere whi̧-ó, ya̧lo no da̧moné ayané mómu o̧la o̧la bukóló, ȩmale meló̧pólópa, naao ya̧lo nopaae yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ti fo depa Yesuné duraalu, “Ti whi̧-ó, diaamomó o̧la o̧la bukóló meló̧póló né ȩ sóró beteraleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Téró ama atimapaae duraalu, “Kae kae o̧la fea senée yóló au nokole alané dia̧ dorao̧sóró, mo hotowaró kaae tawae. Ti noatepae, o̧la o̧la mo dekéró sóró tare alané whi̧ beteró bitinipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Téró, ama atimapaae fo sale fo etéró yalepó. “Beta̧ néli whi̧né ama diyale ke kutómó o̧la dekéró salepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ai ala kilitu, ama etei kisipa mualepó. ‘Ama kutómó yó mole o̧la mulaaire tiki meipóló,’ a̧ fomo du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Téró ama duraalu, ‘Ya̧lo o̧la o̧la mulaai tȩale be fisikóló mo doakale be tȩyóló ya̧lo kutómó sere o̧laró mepaae wisi wisi o̧latamo mulaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Atéróló ya̧lotei etei fo enérapó. Ȩ o̧la o̧la mo su̧mó moleteiné mió me kutó dini doasi ba fomó sa̧a nóló ha̧le bitu, mole o̧laró wȩitamo maaté hai̧tamo nukulé fu betaalopó,’ ere fo kisipa muni airapó. ");
INSERT INTO ppo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tépatei Kótóné a̧paae duraalu, ‘Kisipa okokore whi̧-ó, naao betere bete mió dilikitamo ya̧lo tokó̧ sirapa, naao donoróló mulale o̧la né saaloé?’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Whi̧ me dené mepaae o̧la o̧la whi̧ tao sóró ha̧le móturaalu, ita Kótópaae matapóló kisipa muóló meni, a̧tóró néli whi̧ betaai dapóló fea o̧la ekȩleyóló beta̧paae du betepa, ti i ere fo ai whi̧paaetóró eraalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Téró, Yesuné ama yó matere whi̧rapepaae duraalu, “Ya̧lo dia̧paae i dere ape. Dia̧ naaire o̧la meitepa, noa naaloé yóló whaalia du betao̧se. Naao tikimó kisipa mutu, kutikélé noa saaloé yóló whaalia du betao̧se. ");
INSERT INTO ppo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nokole o̧lata, wisi o̧latei whi̧né betere beteta, mo doasi o̧lapó. Kutikélé wisi o̧latei, whi̧né tikita mo doasi o̧lapó. ");
INSERT INTO ppo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Barapené dere ala kolóló kisipa muae. Atimané naaire o̧la wae biliyóo, u̧lumé depa sóró bepaae mulatere alakélé yóo, dumipó. Tépatei, Kótóné atima kaae taru, betere doko̧ fea atimané naaire o̧la mótua dapó. Hepen bemó betere diaao̧ Ayané barape kolósu, dia̧ kolósu depa, dia̧ so whi̧paae ama hosaa mo turó mulapó. ");
INSERT INTO ppo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Dia̧kó beta̧ whi̧né ama betaaire alamó kisipa muóló whaalia duraalu, a̧ betaaire ba fo su̧mó fo̧loranére? ");
INSERT INTO ppo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ai sawatamo ala dia̧né enénipa, ti mepaae doasi alarapemó noatepa whaalia du betere? ");
INSERT INTO ppo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ha̧le yó mole nerape fuatere ala kolóló, kisipa muae. Ai ne fua kémi bisikó̧ló kuti nomotumitei, ama ere au wisi kelaalo mo koko̧rapó. Atére auné Solomon-né derótua yale koko̧i kutiné au bosene falapó. ");
INSERT INTO ppo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dia̧ kisipa tiki sawa tiró betere so whi̧rape-ó, haemó ha̧le yó mole nerapeta mió maaté yóló dó simó biliraaire o̧latei, Kótóné wisiyóló aurótua dapó. Ai nerapepaae erótu betere alakélé mo bosenóló, diaao̧ deraaire kuti Kótóné su̧mó melaalomeipóló de? ");
INSERT INTO ppo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Dia̧né naaire o̧la ó wȩimó hosaa turó muóló noa naaloé yóló doasi whaalia du betao̧se. ");
INSERT INTO ppo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ti noatepae, ha̧le ho̧ko betere so whi̧ feané ai o̧la saai dapóló ketekȩ buóló wóputu beterapó. Ti dia̧né ya̧ya̧tere o̧la hepen bemó betere diaao̧ Ayané ama mo tuȩ́rapó. ");
INSERT INTO ppo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Térapa, Kótóné tȩteróló kaae tare ao̧mó betaai dapóló, ketekȩ buóló kikitu betepa, ti ya̧ya̧ du betere o̧la o̧la ama su̧mó melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ya̧lo sipsip hupu malerape-ó, diaao̧ Ayané ama tȩteróló kaae tare ala a̧ wisi kisipa muóló hai̧tamo dia̧mó ha̧le melaalopa, whaalia yao̧se. ");
INSERT INTO ppo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Térapa, diaao̧ muó mole o̧la dotonóló moni sóró mepaae yolealere so whi̧mó ha̧le melae. Atétere alané ha̧le muó tawó̧póló, moni detere be wisi aletapó. Atétepa, ti wisi wisi o̧la hepen bemó ha̧le muó taru, kemekélé yaalomeipó. Aimó o̧lémi nokole whi̧kélé, hoséli ó ero sinékélé, turukóló doraalomeipó. ");
INSERT INTO ppo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mé tikimó naao wisi wisi o̧la mupa, ti naao hosaakélé aimótóró mulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Dia̧ kutó dine faairaalu kuti deróló bitu, sa̧rapekélé duku beteró̧póló, dȩróló mulae. ");
INSERT INTO ppo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ti atétere alata, mepaae kutó diratere whi̧rape atimané doasi whi̧ beta̧ so dokotere be dȩmó detere o̧la nale feletei fesaae wó̧póló, kaae tatu dere kaaepó. Atépa, kale whi̧ wouraalu be tu̧ dupa, a̧ be dolopaae holó̧póló, hapale atimané be tu̧ tuki̧yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Atéró, atima tȩteróló kaae tare whi̧ wouraalu kelera̧lemó, ama o̧la o̧la mo wisiyóló kaae tapa, a̧ hȩkeseturaalu atimapaae mo wisi ala eraalopó. Ya̧lo dia̧paae mo i dere ape. Kale topo whi̧ a̧ kuti wisi deróló, ama kutó diratere whi̧rape wó̧póló a̧pi fóló, o̧la nokole ni fake tómó kaae tawóló betaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kale doasi whi̧ a̧ be diliki tua̧mó ó be teó dȩterepaae sókó wouraalu ama kutó diratere whi̧rape kelera̧lemó, fea o̧la o̧la su̧mó donoró betepa, a̧ hȩkeseturaalu atimapaae mo wisi alatóró eraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tépatei, i dere fo mo diriyóló wosóló tuȩ́ muae. Beta̧ be talené ama be fulukóló o̧la o̧la o̧lémi saaire whi̧ i sukakelemó waalopóló kisipa ua̧sóró ti ama be fulukóló o̧la o̧la sóró fó̧póló kaae tawua̧ meipó. ");
INSERT INTO ppo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Térapa, dia̧kélé hotowaró donoróló betae. Ti noatepae, kale Whi̧né Naalema waalomei nisiyóló moko̧leyaa yóló betere tua̧mó waalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tétepa Pitané duraalu, “Tale-ó, naao ai fo salepaae dó faróló dere fo-a, da̧paae maaté dépé, so whi̧ feapaaekélé de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ai fo depa Talene duraalu, “Beta̧ fosó fosóre kutó diratere whi̧ ama doasiné dere fotóró wosóló eró tapa, mepaae kutó diratere so whi̧ a̧paae tȩteróló kaae tawae enérapó. Tétu, tukóló muló betere sukamótóró atimané naaire o̧la maté fó̧póló, ama naase tua̧mó mulóló a̧ fulapó. ");
INSERT INTO ppo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Téró kale doasi whi̧ a̧ momó fesaae wouraalu kelera̧lemó, ama diyae yóló fele kutó mo wisiyóló dipa kilitu, ai whi̧paae mo doa hȩkesené sinóló mo wisi ala eraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ya̧lo dia̧paae mo i dere ape. Kale topo whi̧né ama o̧la o̧la fea ai whi̧paae naao mo wisiyóló kaae tawae yóló ama naase tua̧mó mulaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tépatei, kale kutó diratere whi̧né ama etei kisipa munérapó. ‘Ya̧lo doasi a̧ foloti feletei hapale wómipó,’ dua dapó. Atéreteiné, a̧ bitu mepaae kutó diratere whi̧raperó sorapetamo fokosói ala yóló, du beteró a̧ o̧laró wȩitamo dekéró nóló topo doyóló keyaa faalopó. ");
INSERT INTO ppo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Atéru kale doasi whi̧ waalopóló kisipani, moko̧leyaa yóló betere tua̧mó a̧ sókó wouraalu, kale whi̧ diyóló turukópi sóró kisipa tirénire so whi̧tamo touyóló beteró̧póló, ho̧kó faraalopó. ");
INSERT INTO ppo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ai whi̧né ama doasiné mole ama kisipa tuȩ́ irutei, a̧ donoróló bitu doasiné dirae yale kutó diréniyalemó, fokosói ala yóló mo doasi susupuraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Téyaalotei, mepaae kutó diratere whi̧né atima doasiné mole kisipa bete wisiyóló sinipa, ti ai whi̧paae kwia mótukélé sawa tétitóró melóo, dele alakélé dekéró ini, tétitóró dóo yaalopó. Nalo kale doasi wóló, ama doasi alarape tȩteróló kaae tawae yale whi̧paae duraalu, ya̧lo ya̧paae melóló fele kutórape fea maé yóló wosaalopó. Mepaae so whi̧né me whi̧paae duraalu, ‘Da̧né o̧la o̧la kaae tawae,’ yóló hu̧yóló mélipa, ti atima momó fesaae wou ama male su̧róló maé yóló wosaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ȩta i haepaae waleteita si sóró walepó. Ai si i haemó mo hapale dó holó̧póló, mo taketi noke ua̧póló kisipa mutapó. ");
INSERT INTO ppo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tépa, ȩ mo kae wȩi tópuaaire ala beta̧ moletei kemeraai kaae taru, mo doasi sekȩné sukutu beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ȩ i haepaae waleteita, diaao̧ kisipané dia̧ i haemó betó mole so whi̧tamo hosaa muni deyóló dua betaaire ala sóró walepóló de? Meipó. Ya̧lo dia̧paae mo i dere ape. Ȩta, dia̧ fake tekeyóló beteró̧póló, tekenale walepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Atérené mió i betere alimó kaae sóró, beta̧ bemó aporó so whi̧ betepa, atimasisitei bóe dóló tekeyóló, sore whi̧ kae betóo, tamo whi̧ kae betóo, yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Atimasisi atéró fake tekeyóló kae bitu, alimané naaletamo bóe dóo, naalené alimatamo bóe dóo, hamané senaaletamo bóe dóo, senaalené hamatamo bóe dóo, whi̧né hama hyama sotamo bóe dóo, hyama soné ama whi̧ hama sotamo bóe dóo, yaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Téró, Yesuné aimó touró betere so whi̧paae duraalu, “Suka doropolepaae sa̧ko ho̧kolo depa kilitu, etei fo dua dapó. Mió hali waairaalu ai dere ape deretei, motóró wua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Besȩ́kélé Saut dȩpaae wapa kilitu, mió mo dirii suka yaai dapó deretei motóró dua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Dia̧ tó tikiné wisire nisi du betere so whi̧rape-ó, i haemó dere alaró sa̧mó dere alatamo ti diaao̧ mo diriyóló kisiparapó. Mió i alimó dia̧ tua̧mó erótu betere ala dia̧né kilitu beterapa nalo waaire alimó yaaire ala bete diriyóló tuȩ́ initere noatepa de? ");
INSERT INTO ppo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Dia̧né dere ala diaao̧tei taleyóló, ita mo dono ala dapóló kisipatere noatepa de? ");
INSERT INTO ppo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Whi̧ mené ya̧tamo fo tokó̧ló só deraai taletere whi̧ beterepaae dapesó fupa, diaamosisi tu̧mó furaalu donoratepa wisirapó. Ti noa yao̧sóró meipó. Ama ya̧ dapesó fóló, taletere whi̧né naase tua̧mó mulatepa, ai whi̧némo diki tare whi̧rapené topo whi̧né naase tua̧paae mulatepa, ya̧ dipula beterao̧sóró dapó. ");
INSERT INTO ppo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ya̧lo ya̧paae mo i dere ape. Naao meló̧póló da̧le mulale moni fea melaletei, kale sonaai moni ke mo ti kemeróló menitepa, ti ya̧ sókó feni, ha̧le bitiré faalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ai forape yóló kemeteretamo Pailat-né dale mepaae Kaleli whi̧rapené samea Kótópaae suku̧laa dalóló ha̧le matere o̧latamo touróló mótu beterapó fo mepaae whi̧rapené Yesupaae ene walepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ai fo depa Yesuné atimapaae duraalu, “Diaao̧ kisipané ai dale Kaleli whi̧rapeta, mepaae ha̧le betó mole Kaleli so whi̧né yale dowi ala bosenóló, atima mo doasi dowi ala ereteiné dalepóló kisipa mute? ");
INSERT INTO ppo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ténipa, ya̧lo dia̧paae i dere fo wosae. Diaao̧ dowi ala taaróló kisipa fetenitepa, ti dia̧kélé ai whi̧rape yale kaae yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ai fo kaae, me i ape. Sailoam be huluamó tȩne fo̧loi be kolokó dorowouraalu, mepaae 18 whi̧rape dalepó. Diaao̧ kisipané ai whi̧rapené yale dowi alané mepaae Jerusalem be huluamó betó mole so whi̧né dowi ala bosenée faleteiné erapóló kisipa mute? ");
INSERT INTO ppo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aténipa, ya̧lo dia̧paae i dere fo wosae. Dia̧kélé diaao̧ du betere dowi ala taaróló kisipa fetenitepa, ti atima yale kaae dia̧kélé fea dóló aluraalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Téró, ama atimapaae i fo sale yalepó. “Whi̧ beta̧né ama képi du kutómó beta̧ nose biliyaletei oloréró kȩle felemó, du beta̧kélé olenipa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Atépa, ai kutó talené ama kutó kaae tare whi̧paae duraalu, ‘Ai nose du oloréró ba fo sore tua̧mó kȩleta yaletei, du mo beta̧kélé olere kilinipa, diyó mulae. Ti ai dowi wa̧sa daale niné hae fȩ ha̧le kemeró̧póló, noatepa kaae tawaaloé?’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ai fo depa, kale whi̧né a̧paae duraalu, ‘Doa whi̧-ó, ba fo beta̧ tua̧mó ya̧lo mepaae kȩlaai o̧la o̧la sóró ai ni betemó munaalopa, daaló̧póló taalae. ");
INSERT INTO ppo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Waaire ba fo tua̧mó kaae tara̧lemó, olotepa ti wisirapó. Olenitepa ti diyó mulaalopó,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sa̧a nokole be dȩmó Yesu a̧ fo wosaai tȩ mole berapekó beta̧ bemó Talené ala etérópóló yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tétu beteremó, aimó dowi kepené sisó fulukuró betepatei, 18 ba fo kemere so beterepó. Atéruraalu, a̧ donoyóló betere alakélé ini, mo heméetóró tarepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Atépa Yesuné kolóló a̧paae ape yóló duraalu, “Ti so-ó, ya̧ dokóló muló betere kisi bete mió ai kemeratere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Atéró, kale soné tikimó naase mulaletamotóró, ama sisó fulukó taretei donone hotepa, Kótóné doi sóró holalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sa̧a nokole sukamótei Yesuné ai so wisiratere ala kilitu, ai fo wosetere be kaae tare topo whi̧ a̧ fopaae butu, aimó betó mole so whi̧paae duraalu, “Kutó diyaaire be dȩrapeta apo miró mulapó. Térapa, diaao̧ kisi bete wisiró̧póló depa ti Sa̧a nokole be dȩmó wéni, ha̧le be dȩrapemó wua yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ai fo depa, Talené a̧paae duraalu, “Dia̧ tó tikiné ha̧le wisire nisi du betere whi̧rape-ó, Sa̧a nokole sukamótei diaao̧ bulmakau ó donki hupurape duló beteretei wȩi nó̧póló dapesó fua dumié? ");
INSERT INTO ppo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Atére kaae, Abraham-né deté yale i betere so dowi Satan-né képiné dokóló muló betepa, 18 ba fo ha̧le kemeyalepó. Atépa a̧ fó̧póló, Sa̧a nokole be dȩmótei, ya̧lo teraayalepa ai ala dore?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ama ai fo deremó, a̧tamo dei kisipa muóló só deraaire whi̧rape atimatei hale duraalu, wiyalepó. Téyaletei, so whi̧ feané ama ai dere ala kilituraalu, koko̧i ala dapóló doasi hȩkesené sukutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Téró Yesuné duraalu, “Kótóné tȩteróló kaae tare ao̧mó mole ala etérapóló noa alapaae dó faróló yaaloé? ");
INSERT INTO ppo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ti aita, i ala kaaené kelerapó. Beta̧ whi̧né mastard ni ke sawatamo só fóló, kutómó biliyalepó. Atéró kale ni holóló, doasi ami daapa, tetei̧mó sikimó kotere barape sirimó daaneta dua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Atéró, ama kale yale kaae momó duraalu, “Kótóné tȩteróló kaae tare ao̧mó mole ala noatamo su̧róló enére? ");
INSERT INTO ppo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Aita, i ala dere kaaepó. Beta̧ soné flawa o bula duraalu, yist mo sawatamo bulatereteiné doasi o bula alerótua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ai alarape yóló kemetepa, Jerusalem-paae fole tu̧mó tȩ mole doasi be huluaró sawa be huluarapemó Yesu faai furaalu, Talené fo yó maté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Atéró, mepaae whi̧né Yesupaae duraalu, “Tale doasi-ó, beta̧ beta̧ so whi̧ maaté aluyao̧sóró tao saaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ai fo depa ama atimapaae duraalu, “Dia̧ mo sawa betekȩne tu̧mó sókó faairaalu, ketekȩ buóló fae. Ya̧lo dia̧paae mo i dere ape. So whi̧ fea ai sawa tu̧mó faai dapóló faalotei fenénipó. ");
INSERT INTO ppo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ai be talené ama be tu̧ kinó betepa dia̧ wóló belamó daalu tu̧mó haluróló fo fakeyóló duraalu, ‘Tale doa whi̧-ó, da̧ holaai dapa tu̧ tuki̧yae,’ yaalopó. Ai fo depa ama dia̧paae duraalu, ‘Dia̧ maae so whi̧rapeé?’ yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tétepa, diaao̧ i fo yaalopó. ‘Da̧ fea beta̧mó bitu, o̧laró wȩitamo nóo, ya̧ da̧né tu̧rapemó daalu yó matere fo wosóo, du betale so whi̧pó,’ yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ai fo yaalotei, ama atimapaae i fo yaalopó. ‘Dowi ala yó tare so whi̧rape-ó, dia̧ maae wale so whi̧ró ȩ kisipanipa, taae fae,’ yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Atétepa, diaao̧ Abraham, Aisak, Jekop, mepaae Kótóné whi̧rapekélé fea ama tȩteróló kaae tare be tua̧mó betó mupa kelaalopó. Téyaalotei, dia̧ ai be tua̧paae honi, belamó dele doasi sóró wole du bitu, diaao̧ serekenétei dia̧ tukóló nuku betaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Atétere be dȩmótóró suka hotereró wale so whi̧kélé, suka doropoleró wale so whi̧kélé, u dȩpaae wale so whi̧kélé, i dȩpaae wale so whi̧kélé, mo fea Kótóné tȩteróló kaae tare be tua̧mó detere o̧la naairaalu, atima betaaire tiki séle séle sóró betaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mió i alimó mepaae nalo wale so whi̧ folosene fóo, mepaae folosóró fole so whi̧rape nalone fóo yaalo ai ape. Ya̧lo i dere fota, ha̧sókó feni, mo yaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Atéyale sukamótóró, mepaae Farisi whi̧rape Yesu beterepaae wóló duraalu, “Herot-né ya̧ daai du beterapa, i be taaróló, metikipaae fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ai fo depa, atimapaae duraalu, “Dia̧ fóló, ai whi̧ dóló nokole dowi hao̧paae i fo yae. Mióró dótamota, ȩ mepaae kisi daae mole so whi̧ró dowi kepe tepeyóló betere so whi̧tamo wisiróló, sore be dȩné ti ya̧lo diyaai yale kutó fea kemeróló da̧lemó sókó fatapó yae. ");
INSERT INTO ppo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Téyaalotei, mió ó dó ó dua̧kélé, atimané ȩpaae me ala eratepa taaréni, ha̧le fó maaté yaalopó. Ti noatepae, Kótóné ko̧ló whi̧ kae tikimó sukutepa ao̧ni, Jerusalem bemótóró sukutepa ti mo donorapó. ");
INSERT INTO ppo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalem, bemó betó molȩ so whirape-o, Kótóné ama fo eratere ko̧ló whi̧rape dóo, mepaae ama dia̧ beterepaae dotȩyale whi̧rapekélé kapo duné siróló dóo, dua yalepó. Kale bané malerape ama baase ao̧paae buósu dere kaae, diaao̧ naale senaale ya̧lo atéró buó saalopóló dua yalemó, dia̧né hó̧ralepó. ");
INSERT INTO ppo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Térapa, mió diaao̧ be mo wópu maalo ai ape! Ya̧lo dia̧paae mo i dere ape. Ȩ diaao̧ kilini ha̧le bitiré fóló, Talené doimó wale whi̧-ó, Kótóné hamokoróló tao sere alané wisiró̧póló yae dere sukamó ti ȩ momó kelaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Téró, Sa̧a nokole sukamó Yesu a̧ Farisi whi̧rapekó doi mole whi̧né bemó o̧la naai fóló beterepó. Atépa, beta̧ hó naase tópure whi̧ Yesu betere felekemó betepa, me alakó déró kelaai kaae tawóló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Atépa, Yesuné Farisi whi̧raperó Moses-né asȩre fo kisipare whi̧rapetamopaae duraalu, “Sa̧a nokole sukamótei whi̧ wisiratepa fo mulepé, meié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ai fo depa, atimané me fokélé tokó̧ menipó. Atétepa, Yesuné kale whi̧ wisiyó̧póló tikimó tawóló, turukó hóróló fó̧póló dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Atéró, Yesuné atimapaae duraalu, “Dia̧kó whi̧ beta̧né ama naale ó bulmakau hupu sa̧a nokole be dȩmótei nóku dolopaae doropóló mupa, téti hapale tao saalo meié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ai fo depa, atimané a̧paae me fo tokó̧ menipó. ");
INSERT INTO ppo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Téró, atima o̧la naai wale so whi̧rape doasi doi mole whi̧ betere tikimó betaai dapóló fole ala kilitu, atimapaae etei fo sale yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Whi̧ mené ama so dokoturaalu detere o̧la naai ape depa furaalu, doasi doi mole whi̧rape bitua dere ni fake wisimó betaai ekȩle yao̧se. Ti noatepae, ya̧ tȩteró betere doasi doi mole whi̧rapepaae ape eretei, ya̧ kisipani ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Atéró wóló betepa, diaamopaae ape yale whi̧né duraalu, ya̧ betaai yale tikimó i sekȩ́ beteró̧póló, ya̧ ha̧le tikimó betae depa, ya̧ doasi hale saalopó. ");
INSERT INTO ppo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Atéyao̧sóró, ya̧paae o̧la naai ape depa furaalu, doasi doi mole whi̧rape betere ni fake ao̧mó ho̧ko betae. Atépa, ya̧paae o̧la naalopa ape yale whi̧né kilituraalu, ‘No-ó, ya̧ i wisi tikimó biti̧ holae yaalo ai ape.’ Atétepa, ya̧tamo beta̧mó o̧la nuku betere so whi̧né keletómó naao doi hale sóró horaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ti noatepae, mepaae whi̧ dené amatei a̧ doi sóró horatepa, atétere whi̧ ti Kótóné haepaae só deróo, whi̧ me de amatei deróló dua betepa, ti Kótóné a̧ sóró horóló doasi doi mulóo, yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Téró, Yesuné a̧paae o̧la naai ape yale whi̧paae duraalu, “Naao suka tua̧mó ó dikitamo o̧la naairaalu, naao fulumu whi̧rape ó naao norape ó fake so whi̧rape ó ya̧tamo felekemó betere néli so whi̧rapepaae maaté o̧la naai ape yóló dape sao̧se. Naaotamo ai ala depa, atimapaae erale ala kaae, ya̧paaekélé eraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Téni, ai detere o̧la naairaalu, ha̧le yolealere so whi̧ ó tiki dore so whi̧ ó hó dore so whi̧ ó kele dilikire so whi̧ fea ape yóló dape supa, ti Kótóné ya̧ wisiróló hale horaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ti atei kaae so whi̧rapené naao erale alamó ya̧paae momó tokó̧ menanénipó. Naao ai dere alamó saaire dupu wisita, take wisi ala yóló suka̧le so whi̧rape kepaayóló wale sukamó senérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Atéró, Yesuné ai dere fo wosóló, aimó o̧la nuku betere whi̧rapekó beta̧né a̧paae duraalu, “Kótóné tȩteróló kaae tare ao̧mó bitu, detere o̧la naalopóló kisipa mutu betere so whi̧ta ti Kótóné wisiró beterapa, doasi hai̧né sukutu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ai fo depa, Yesuné a̧paae tokó̧ mótu duraalu, “Whi̧ beta̧né ama doasi o̧la deyaairaalu, taleyóló mulóló so whi̧ feapaae naai ape yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Atéró kale whi̧né o̧la deyaaire be dȩ wapa, o̧la naai ape yale so whi̧ dapesene fó̧póló, ama kutó diratere whi̧ dotonalepó. Atétepa, a̧ fóló atimapaae duraalu, ‘Mió o̧la taleróló muló betepa faalopa ape,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Atéró deté kwȩyaletei, atima fole hó̧mó kutórapené bipi epa fenénipó dua yalepó. Folosóró whi̧ beta̧né duraalu, ‘No-ó, ya̧lo dóti dupuyóló diyaaire kutó kȩle faaireteiné, ȩ ya̧tamo faalomeipó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kale dere fo kaae whi̧ menékélé duraalu, ‘No-ó, ȩta ya̧lo dóti dupuyale naasetamo bulmakau hupurapené dere ala kȩle faaireteiné ya̧tamo fenénipó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Whi̧ menékélé kale dere fo kaaetóró yóló duraalu, ‘No-ó, ȩ so mo dótóró dokóló betereteiné ya̧tamo fenénipó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Atétepa, kale kutó diratere whi̧ momó fesaae wóló, whi̧rapené yale fo ama doasipaae yalepó. Tétepa, kale be tale a̧ fopaae buóló ama kutó diratere whi̧paae duraalu, ‘Ya̧ mo hapale fóló ai doasi be huluaró sawatamo be huluatamopaae fole tu̧mó yolealere so whi̧kélé, tiki momaare so whi̧kélé, kele dilikire so whi̧kélé, hó naase dore so whi̧kélé, fea wó̧póló dapesene fae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ti fo depa, ama yae yale alarape yóló ki̧lipaae kale kutó diratere whi̧né duraalu, ‘Doa whi̧-ó, naao ȩpaae yae yale alarape fea ya̧lo su̧mó yaletei, mepaae whi̧ beteraaire dȩ ha̧le ai mune fale ape,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tétepa kale doasi whi̧né a̧paae duraalu, ‘Ya̧ doasi tu̧rapemó fóló, tu̧ dȩmó betó mole so whi̧kélé fea dape siré kwȩyóló wapa, ti be kerape fea su̧nérapó. ");
INSERT INTO ppo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ya̧lo ya̧paae i dere ape. Mepaae whi̧ de o̧la naalopa ape yalemó wéni yale so whi̧rapeta, ya̧lo doasi detere o̧la mo sawakélé hoteyaalomeipó,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Téró, so whi̧ mo ha̧le o̧la kaae Yesutamo fu betepatei, Yesu fetée wóló i fo yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mepaae so whi̧ detamo ȩ beterepaae wouraalu, ti ama aya ó hae ó ama so, naale senaale ó ama noraperó nerapetamopaaekélé ó ama betere betekélé hó̧róló bóe dinitepa, ti a̧ ya̧lo dere fo wosóló yó matere whi̧ betenénipó. ");
INSERT INTO ppo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mepaae whi̧ dené a̧ oleraaire filipaa ni amatei beleyóló ȩ sya anitepa, ti atétere whi̧kélé, ya̧lo yó matere whi̧ betenénipó. ");
INSERT INTO ppo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Dia̧kó beta̧ whi̧ ama kisipanétamo, doasi fo̧loi be olekeyóló tȩyaairaalu, ama tare moniné su̧mó tȩnéréró kisipanépi talenérapó. ");
INSERT INTO ppo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Ti noatepae, be tȩyaai folosóró bete kaaturaalu, dirii eleké bilitapó. Téteretei, kale be kemerénipa kilitu, mepaae so whi̧né do̧ nanóló doka doka duraalu, i sekȩ́né mo folo tȩale betei kemerénipóló do̧ nanaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Fo sale me i ape. Me hae kwia tȩteróló kaae tare topo whi̧né me hae kwia tȩteróló kaae tare topo whi̧tamo bóe dȩle faairaalu, 10,000 diki tare whi̧raperó me topo whi̧né 20,000 diki tare whi̧rapetamo bóe dupa, 20,000 diki tare whi̧rape dóló kemeraalopé neté yaalorópóló kale topo whi̧ a̧ kisipapi tekenérapó. ");
INSERT INTO ppo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Atéró bóe whi̧rape mo umó wou betepatei, ama kisipanétamo atimatei beta̧paae dȩlépa, ti bóe dele ala taarópó. Mió da̧ bóe fiyóló dua betaalopó fo ene fae yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Atétere kaae, dia̧kó whi̧ me dené ama muó mole o̧la o̧la fea me o̧la meipóló taarénitepa, ti ya̧lo fo eratere whi̧ betenénipó. ");
INSERT INTO ppo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Kóta, mo feléi o̧la wisitei ama felé kemetepa, ti momó kae neyóló felé bulaaloé? ");
INSERT INTO ppo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Atéró felé initere kóta, o̧la betepaaekélé munéni, ha̧le tikipaae taae fatua dapó. Mepaae whi̧ detamo wosȩ́li dapa, ti i dere fo wisiyóló wosó̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Téró, mepaae takis moni sere whi̧raperó so whi̧né dowi ala dere whi̧rapepó du betere whi̧rapetamo Yesuné dere fo wosaai a̧ beterepaae toura̧le wóló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Atépa, mepaae Farisi whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamoné Yesu kikiti eratere fo yóló duraalu, “I whi̧néta dowi ala du betere whi̧rapetei, touróló o̧la beta̧mó nuku beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ti fo depa, Yesuné atimapaae etei fo sale yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Dia̧kó whi̧ beta̧né 100 sipsip hupurapekó beta̧ hupu alupa, 99 hupurape ha̧le tua̧ tikimó beteróló, alure hupu keketé kwȩyóló dape sumié? ");
INSERT INTO ppo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Atéró, dape supa, a̧ hȩkesené sukó̧ló bepaae dapesó wua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Atéró, bepaae só fóló, ama fulumu so whi̧ró be whi̧ so whi̧tamopaae toura̧le ape yóló duraalu, ‘Ya̧lo kale aluyale hupu kekitu beteró dape salepa, dia̧kélé fea ȩ dere kaae hȩkese yae,’ yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ya̧lo dia̧paae i dere ape. Atétere kaae, beta̧ dowi ala du betere whi̧ kisipa tiki feteyóló Kótó beterepaae wapa, ti hepen bemó mo doasi hȩkese dere alané i haemó dere hȩkese tȩteróló bosene falapó. Téretei, mepaae 99 so whi̧né duraalu, da̧ me dowi alakélé dumipa, kisipa tiki ha̧le neyóló feteyaaloé dere so whi̧paae hȩkese doaló dumipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ai ala kaae me i ape. “So beta̧né silpa kapané aleyale naasetamo moni kekó beta̧ alutepa, ama noa ala yaaloé? Keka̧airaalu sa̧ dȩyóló be tua̧mó muó mole mome wisiyóló fuóló kekó̧ló mupa sumié? ");
INSERT INTO ppo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Atéró su, ama fulumu so whi̧ró be whi̧ so whi̧tamopaae kale aluyale moni ke saleteiné da̧ hȩkese yaalopa, dia̧ fea beta̧paae toura̧le ape enérapó. ");
INSERT INTO ppo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ya̧lo dia̧paae i dere ape. Ai ala dere kaae, mepaae whi̧ de ama dowi ala taaróló, kisipa feteyóló Kótópaae wapa, ti ó hepen bemó betere ensel-rape mo doasi hȩkesené sinaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Atéró, Yesuné ama deté wou betere fo tómó me i fo yalepó. “Whi̧ beta̧né naale tamo beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Téru, me dekȩ naalené alimapaae duraalu, ‘Apa-ó, naao ya̧lo no da̧momó melaai muló betere o̧la o̧la bukóló ȩmaletamo a̧lae,’ depa, alimané naalema tamo tua̧mó bukuralepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Atéró kale dekȩ naale alimané melale o̧la o̧la fea sóró, mo saletó tikipaae felepó. Atéró bitu, mepaae kae kae ala ho̧ko deté fu beteró, ama kale sóró fele o̧la o̧la fea kemeralepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","15","Atéró beteremó, ai hae kwiamó doasi wote ali wóló a̧ naaitere o̧lakélé meitepa, a̧ fóló whi̧ beta̧paae duraalu, ‘Naao me kutókó mupa ya̧lo diraalopó yóló wosalepó.’ Ti fo depa, kale whi̧né ama hupurape kaae tawaaire kutó beta̧ mulapa dirane fae yóló dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Atéró fóló, kale hupurape kaae tapa mené a̧mó nokole o̧lakélé menipó. Tétepa, a̧ wotemó kale hupurape matere besa̧ae bolo naai kisipa mutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Atétu ama take muale kisipa feteyóló, momó wisi kisipa muóló duraalu, ‘Ya̧lo ayané ama kutó diratere whi̧rapeta, o̧la dekéró mupa nuku beteretei, ȩ imó wotené sukutapó. ");
INSERT INTO ppo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tétereteiné, mió ȩ momó ya̧lo aya beterepaae fesaae fóló i fo yaalopó. Apa-ó, ó hepen-mó betere Kótópaaekélé, ya̧paaekélé ya̧lo wisi ala eréni, mo doasi dowi ala eralepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Atéyaleteiné, mió ȩ naao naale ao̧réni, kutó diratere whi̧rape kaae beterae,’ yaairaalu faai kisipa mualepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Atéró tuȩ́ teketu beteró, kale naale a̧ betere tiki taaróló, alima beterepaae momó fesaae felepó. Atéró kale naale mo umó wou betepa alimané kolóló, ama hosaamó suraalu, a̧ mo hapale sururu yóló fóló, apuó taru ko̧ló tukó nalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Atétepa kale naalené alimapaae duraalu, ‘Aya-ó, naao kele tómókélé, hepen bemó betere Aya Kótóné kele tómókélé, mo doasi dowi ala yalepó. Téyalepa, mió ȩ naao naale ao̧rao̧se,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Téyaletei, kale naale alimané ama kutó diratere whi̧rapepaae duraalu, ‘Dia̧ mo hapale fóló, a̧mó deraaire kuti wisi sóo, naasemó bulaaire bi sóo, hómó horaaire ho̧leke be sóo, yóló derae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Atéró, ama kutó diratere whi̧rapepaae duraalu, ‘Da̧né a̧ hȩkeseróló o̧la deraalopa, beta̧ seraai bulmakau hupu male sene fae. ");
INSERT INTO ppo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ti noatepae, ya̧lo i naaleta suka̧letei momó kepaayóló biture kaae erapó. Mo ti aluyale whi̧tei momó dape sóró biture kaae epa, mió da̧né a̧mó o̧la deróló hȩkese yaairaalu i dere ape,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Até du betepa, kale whi̧né topo naale kutómó daai be bela felekemó sókó walemó, kitatamo wole fo yóló, ki̧litu betere fo wosalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Até du betepa, ama kutó diratere whi̧rapekó beta̧paae ape yóló duraalu, ‘Doa ai-a, noa alamaaté du bitu de?’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ti fo depa ama a̧paae duraalu, ‘Naao no me alakélé ini, mo wisiyóló sókó waleteiné, ayanaaoné seraai bulmakau hupu male dóló o̧la i derótu betere ape,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ai du betere ala kilitu, kale topo naalené alimatamo doasi fopaae buóló, bepaae hotere hó̧yóló belamó dalepó. Atépa, alima doropóló naalema be dolopaae holó̧póló, bératere fo yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Téyaletei, ama alimapaae duraalu, ‘Kelere! Ba fo doko̧ fea ȩ naao wae sóró kutó diratere whi̧ kaae bitu, hó̧kélé ini naao erae dere ala ya̧lo eró tawalepó. Téyaletei, ya̧lo fulumu whi̧rapetamo dóló nó̧póló, naao meme hupu male beta̧kókélé menipó. ");
INSERT INTO ppo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Até yaletei, naao ai naale ho̧ko nópumó kutu beteró naao melale wisi wisi o̧la fea aluróló wapatei, naao a̧mó seraai bulmakau hupu male dóló o̧la ai deratere ape,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ai fo depa alimané duraalu, ‘Ti naale-ó ya̧ta, suka fea ȩtamo betereteiné ya̧lo mole o̧la o̧la feata, ti naaotóró ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Téreteiné da̧ fea hȩkese duraalu, a̧mó o̧la deralepa, ya̧ depe sekȩni hȩkese yae. Ti noatepae, naao no a̧ mo ti suka̧le whi̧ momó kepaayóló wóló biture kaae epa o̧la deratere ala taaréni, mo enérapó. A̧ta, aluyale whi̧tei, momó sókó wapa dape sóró i betere ape,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Téró, Yesuné ama yó matere whi̧rapepaae i fo yalepó. “Whi̧ mené beta̧ néli whi̧paae duraalu, naao o̧la o̧la kaae tare whi̧né wisiyóló kaae tani, ho̧ko besekérótu beterapó depa wosalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Atei fo depa, ama sóró beterale whi̧paae ape yóló a̧paae woseturaalu, ‘Naao du betere ala mené ȩpaae ene walepa, naao ya̧lo o̧la o̧la netéró kaae tare? Mió naao ditu betere kutó kemeraai dapa, naao tȩteróló kaae taru deté wale ala fea ȩpaae yae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ai fo depa kale whi̧né ama kisipanétei duraalu, ‘Ya̧lo doasiné ȩ melale kutó kemeratepa, mió ȩ noa kutókó diyaaloé? Hae duki̧yaaire fotoko̧kélé buni yóo, me whi̧paae o̧la kema dere alakélé, hale yóo ereteiné, ȩ noa ala yaalorópó. ");
INSERT INTO ppo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tépatei, ȩ i kutó taaróló fupa, mepaae so whi̧né ȩ mo wisiyóló dape só̧póló, i ala beta̧ yaai kisipa mutapó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","6","Atétepa, kale whi̧né ama doasiné o̧la o̧la kwia mulóló sale whi̧rape beta̧ beta̧ ape depa, walepó. Atéró kale folosóró kwia mulóló sale whi̧paae woseturaalu, ‘Ya̧lo doasiné o̧la naao meteró saleé? depa, ama duraalu, da̧le 4000 lita olip wel wȩi salepó,’ depa, kale whi̧paae duraalu, ‘Ya̧ hapale fóló sawa beteró, naao sale 4000 lita wel wȩi da̧le helekó̧ló, 2000 lita asȩyae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Téró, kale dere kaae me whi̧paae woseturaalu, ‘Naao ya̧lo doasiné o̧la meteró saleé?’ depa, kale whi̧né duraalu, ‘Whiti yorape 1000 salepó,’ yalepó. Ti fo depa, kale whi̧né a̧paae duraalu, ‘Naao melaai sale kwia asȩretei helekó̧ló 800 asȩyae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Atéró, kale o̧la o̧la talené ama sóró beterale whi̧ wisipa meitei a̧ dukiróló duraalu, ‘I whi̧ta o̧lémi nuku bitutei, topo daalu fosó fosói ala maaté du beterapó. Ti i haemó betere so whi̧ atimasisi u tao su i tao su dere ala mepaae so whi̧né kilitu, mo fosó fosóre so whi̧póló dukiratere alané, kale dȩ tua̧mó betó mole so whi̧ tȩteróló ketei ao̧ratapó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ya̧lo dia̧paae i dere ape. I haemó bituraalu, naao sere moni mepaae ya̧ya̧re so whi̧ tao sóró ha̧le melae. Atéró fea melóló kemeratepa, atimané ya̧ mo ti tȩ tare bepaae holae yóló dape saalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mepaae whi̧ dené sawa kutó mo wisiyóló kaae taru dirótu betepa, so whi̧né kilitu i sekȩ́né kutó mo dono ditapóló kisipa tiratere whi̧néta ti doasi kutókélémo wisiyóló diranérapó. Mepaae so whi̧ denétamo sawa o̧la mekó o̧lémi supa, ti doasi o̧lakélé o̧lémi senérapó. ");
INSERT INTO ppo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Atétepa, i haemó muó mole o̧la o̧la diaao̧ wisiyóló kaae tawaaire su̧nipa, mo ti muó tare wisi wisi o̧la dia̧paae kaae tawae yóló né melaaloé? ");
INSERT INTO ppo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Me whi̧né dia̧paae kaae tawae dere o̧la o̧latamo diaao̧ mo wisiyóló kaae tanitepa, naao mo ti muó tawaaire o̧la ya̧mó né melaaloé? ");
INSERT INTO ppo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Beta̧ kutó diratere whi̧nétei, doasi topo whi̧ tamoné kutó diranénipó. Atétepa, ti me whi̧paae yaala sókó fóló mulu, ama kutó diróo, me whi̧ hó̧róló ama erae dere alakélé eréni yóo, yaalopó. Ai ala dere kaae, beta̧ whi̧nétei Kótóné kutóró mepaae moni saaitere kutótamo touróló diranénipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ai fo depa, mepaae monimó hosaa muóló ekȩlere Farisi whi̧rapené Yesuné ai dere fo woseturaalu, faleyóló doka doka du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ti fo depa, ama atimapaae duraalu, “Dia̧né ai du betere ala so whi̧né kilitu, mo wisirapó du betepatei, diaao̧ hosaa tua̧mó kinóló mole ala ti Kótóné kolóló mo kisiparapó,” yalepó. Atétepa, ama atimapaae duraalu, “Mo so whi̧néta, dia̧né mo doasi bete mole ala dapó du betepatei, Kótóné keletómó ti bete muni, mo sonaalérapó. ");
INSERT INTO ppo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kale Moses-né asȩre foró Kótóné ko̧ló whi̧rapetamoné yó maté waletei, Jon betale alimókélé taaréni, ha̧le yó matétóró fu beterepó. Atétu betepa, Kótóné tȩteróló kaae tare ao̧mó mole kisi fo wisi wosaai dapóló hai̧né sukuturaalu, so whi̧ fea aipaae alaletamo fu beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ti sa̧ró haetamota kemeyaalotei, Kótóné fo kwia mo sawakélé aluyaalomeipó. ");
INSERT INTO ppo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Whi̧ me dené ama topo so tokó̧ daaróló so me kae dokotepa, ti Kótóné fo tukóló nópu nukulapó. Whi̧ me dené me whi̧né tokó̧ daalale so dokotepa, ti aikélé yóló muló betere fo tukóló nópu nukulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Téró suka fea kelaalo mo koko̧i sonaai kuti maaté derótua yóo, mo feléi wisi o̧la maaté nóo du betere néli whi̧ beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ai néli whi̧né ama be tu̧ sókó walemó yoleale whi̧ humu fulu daayóló bitu, suka fea o̧la kematu betere whi̧né doi Lasarus beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Atéró bitu, a̧ wote depa kale néli whi̧ ni fake tómó o̧la nukuraalu, folope sorokóta deretei naai kisipa mutu betepa hao̧rapené ama humu a̧e nukua depakélé, dowa̧ae fóló beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ai ala du betere tua̧mó kale whi̧ Lasarus sukutepa, ensel-rapené a̧ beleyóló fóló, Abraham betere uté tȩró beteralepó. Atéró a̧ suka̧le ki̧lipaae kale néli whi̧kélé sukutepa douralepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Téró, kale néli whi̧ mo ti dó tare simó duku bituraalu kese falalemó, kale Lasarus Abraham-tamo daapa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A̧ atépa kolóló duraalu, ‘Aya Abraham-ó, naao ȩ ko̧le depata, ti kale Lasarus-né naase dou̧mó wȩi fȩ eróló ya̧lo hape siri bula̧le wó̧póló dotȩyae. Ti noatepae, ȩ siné dukuraalu doasi dele sereteiné dapó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ai fo depa Abraham-né duraalu, ‘Ti naale-ó, aita mo deretei, naao kisipa muae. Take ya̧ haemó betale sukamó wisi wisi o̧lamaaté su betalepó. Até du betepa, Lasarus a̧ dowi o̧la sua yaletei, mió a̧ imó hosaa muni deyóló hȩkesené sinitu betepa, ya̧ doasi dele ai su betere ape. ");
INSERT INTO ppo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Téretei, da̧ imó betere whi̧ aipaae wóo, atéró betere whi̧ ipaae wóo yao̧sóró, tua̧mó doasi fao muló betereteiné da̧ aipaae tȩ wonénipó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ai fo depa, kale whi̧né Abraham-paae duraalu, ‘Aya Abraham-ó, Lasarus ya̧lo ayané bepaae fóló norapepaae ene fó̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ti noatepae, ya̧lo norape aporó beterapa, ȩ doasi dele su betere tikipaae atimakélé wao̧sóró, ene fó̧póló dapó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ti fo depa Abraham-né duraalu, ‘Moses-ró Kótóné ko̧ló whi̧rapetamoné yó mótu betere fo wosóló, atima kisipa feteyóló tuȩ́ tiki tiratepa, ti té yó̧pólópó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ai fo depa, kale whi̧né Abraham-paae duraalu, ‘Aita mo deretei, suka̧le so whi̧ fólótamo depa, ti atimané du betere dowi ala taaróló, kisipa feteyóló waalopó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ti fo depa ama duraalu, ‘Moses-ró Kótóné ko̧ló whi̧rapetamoné yó mótu betere fo wosenitepa ti sinóló kepaayóló wale whi̧né dere fokélé wosóló kisipa tiki tiraalomeipó,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Téró, Yesuné ama yó matere whi̧rapepaae duraalu, “So whi̧ fea dowi ala yóló dée nó̧póló kae kae su̧sere alarape waalo ai ape. Té yaalotei, whi̧ me dené me whi̧ dowi ala yó̧póló dée nalatepa, ti atétere whi̧paae doasi sekȩi ala eraalopó. ");
INSERT INTO ppo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Dia̧kó mé whi̧né i betó mole naale senaale beleka̧atikikó dowi alamó dée nalatepa, ti atétere whi̧né depamó képi dulóló, doasi kapo fake oleróló wȩi kȩlapaae taae derólua̧sóró mo wisi ua̧pó. ");
INSERT INTO ppo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Atérapa, diaao̧ dere alarape dia̧nétei mo hotowa yóló kaae tawae. Naao notamo mepaae dowi ala depa, ti atékesé yóló a̧ foné sae. Ténalemótamo, naao dere fo wosóló a̧ kisipa feteyóló wapa, ti ama yale ala me o̧la meipóló ha̧le kemerae. ");
INSERT INTO ppo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Beta̧ be dȩmótei, naao noné wȩikeró félimó ya̧paae dowi ala eralepóló, ya̧ beterepaae fesaae wóló, ‘No-ó, ya̧lo ya̧paae wȩikeró félimó dowi ala eraleteiné doasi ko̧leó ene wapa,’ ti naaomo kwia tani, me o̧la meipóló ha̧le kemerae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Téró, Kótóné ama fo era̧le fó̧póló doteya̧le whi̧rapené duraalu, “Tale-ó, da̧né kisipa tiki doaló tiró bitinireteiné mo diriyóló tiraai dapa, naao da̧ yó a̧lae!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ti fo depa Yesuné atimapaae duraalu, “Dia̧ kisipa tiki tiró betere alatamo mo sawa mastard niné ke kaae bupa, ti i daale malberi nipaae naao feleke turó tokó̧ló, doasi wȩi kȩla tua̧mó daane derepae depa, naao dere fo wosóló mo téyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Dia̧kó beta̧ whi̧né ama kutó diratere whi̧ o̧la wae biliyaai hae duki̧yóló mulale fóló, ó sipsip hupu kaae tane fi teó waletamotei kale doasiné ama kutó diratere whi̧paae, ‘Ya̧ o̧la naasepóló hapale ape,’ fo dua de? Meipó. ");
INSERT INTO ppo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Doasi whi̧né atei fo yaalomeitei, etei fota ti enérapó. ‘Ya̧lo naaire o̧laró wȩitamopi donoróló, ȩ nuku betepa ti naao naaire o̧la donoraasepólópó dua dapó.’ ");
INSERT INTO ppo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kale kutó diratere whi̧né ama doasiné a̧paae dirae dere kutó fea diyóló kemeratepa, ama doasiné a̧paae mo kée fo dua de? Meipó. ");
INSERT INTO ppo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Atétere kaae, Kótóné dia̧paae dirae dere kutó diyóló kemetepa, diaao̧tei dia̧ bopé fake enére? ‘Da̧ta, whi̧ wisi meitei, da̧né ditere kutóró diyalepó fo enérapó,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ai fo yóló ki̧lipaae Yesu a̧ Jerusalem be huluapaae sókó faairaalu, Samariaró Kaleli haetamo da̧le tua̧mó fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Atéró a̧ beta̧ be huluamó sókó felemó, dowi humu fuluné tiki dore naase tamo whi̧rape a̧tamo hokolaa yaai wóló, mo tumó daae molepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Atéró daalu fo fake yóló duraalu, “Doa whi̧ Yesu-ó, naao da̧ ko̧lené sukutu tao sae!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ai fo depa, Yesuné atima kelalemó ko̧lené sukutepa duraalu, “Dia̧ fóló, so whi̧mó momaratere whi̧rapepaae diaao̧ tiki yó melale fae,” yalepó. Atétepa, atimané tiki yó melaai tu̧ tua̧mó fu betepatei, atimané dowi humu fulu torokó fóló wisiyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Atétepa, atimakó beta̧ whi̧né ama tiki fopeyalemó wisipa kilituraalu, momó fesaae fóló fo fakeyóló Kótóné doi sóró horaté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Até deté wóló, Yesu daale felekemó deraapisa fóló mulu, mo kée du betalepó. A̧ta, Samaria hae kwiamó wale whi̧kópó. ");
INSERT INTO ppo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Tétepa, Yesuné atimapaae woseturaalu, “Mepaae naase tamo whi̧rape ya̧lo wisirénié? Ita, kae fake whi̧tei Kótóné doi hale sóró horatapa, Naase aporó kemeyóló dou̧ró whi̧rape-a, neya̧leé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Téró ama a̧paae duraalu, “Naao kisipa tiki tiró betale alané ya̧ wisiralepa, turukó holóló mo dua fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Atéró, me sukamó Farisi whi̧rapené Yesupaae duraalu, “Kótóné tȩteróló kaae tare ala noa be dȩmó wapa so whi̧ feané kelaaloé?” yalepó. Ti fo depa Yesuné atimapaae duraalu, “Kótóné tȩteróló kaae tare alata, whi̧né kelené kolóló tuȩ́ yó̧póló me fareyópu kae yaalo meipó. ");
INSERT INTO ppo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","So whi̧ feané imó ó umó wóló beterapó fo enénipó. Ti noatepae, Kótóné tȩteróló kaae tare alata, mió dia̧ tua̧mó i wóló mole ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Téró, ama yó matere whi̧rapepaae duraalu, “Take waaire be dȩrapekó beta̧ tua̧mó kale Whi̧né Naalema kelenée du betaalotei mo kelaalo meipó. ");
INSERT INTO ppo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Atéró kekitu betepa, mepaae so whi̧né duraalu, ‘Kale Whi̧né Naalema umó wóló beterapó,’ ó ‘Imó wóló beterapó,’ depa, mo dere nisiyóló sya fao̧se. ");
INSERT INTO ppo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ti noatepae, kale Whi̧né Naalema a̧ wouta, epée duraalu hae kwia fea dȩyó fu dere kaae yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ai alarape fea yaaipatei, folosóró a̧pi kae kae susupui ala supa, ti mió i alimó betó mole so whi̧né ama fo woseni, a̧ hó̧raalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Take Noa betale alimó yale kaae, mió Whi̧né Naalema waaire alimókélé atétóró yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Take Noa betale alimó, so whi̧ fea o̧laró wȩitamo nokole alakélé, so whi̧tamo beteratere alakélé, whi̧ so dokotere alakélé, deté fu betepatei, Noasépi nuku tua̧paae biti̧ horalepó. Até deretamotóró, atima ai du betale ala kemene felepó. Atéturaalu, doasi wȩi dukulé horóló so whi̧ fea sisiraae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ai yale kaae, take Lot betale alimókélé, so whi̧ fea wisiyóló bitu o̧laró wȩitamo nokole alakélé, o̧la o̧la dotonóló duputere alakélé, o̧la wae bilitere alakélé, be tȩtere alakélé, fea deté fu bitipakalepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Atétu betepatei, Lot a̧ Sodom be hulua taaróló foletamotóró hepen bemó siró kapo whaa kaae ere sulpa sitamo hali kaae dorowóló, so whi̧ fea doralepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Atétu yale kaae, kale Whi̧né Naalema mió kinóló beteretei ha̧keamó wapa, so whi̧ feané kelaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Atétere sukamó, whi̧ me ama siki bemó biti hae bemó mole o̧la wisi saai dapóló derepao̧se. Kutómó daale whi̧ momó fesaae fóló, bemó mupa wale o̧la momókó sene fao̧se. ");
INSERT INTO ppo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ti noatepae, Lot-né soma yale ala kisipa muae. ");
INSERT INTO ppo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mepaae whi̧ de ya̧lo ala erótutei, ama betere bete me ala yao̧sórópóló, amatei hotowayóló kaae tapa, ti atétere whi̧né betere bete aluyaalopó. Tépatei, whi̧ me dené ama betere bete me o̧la meipóló taalatepa, ti ama betere bete aluni, mo ti muó tawaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ya̧lo dia̧paae i dere ape. Dilikitamo whi̧ tamo beta̧ besekȩmó fipatei, me whi̧ dapesó furaalu, me whi̧ fipa taaróló faalopó. ");
INSERT INTO ppo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","So tamo flawa o bula yaai dera̧ketu betepa, me so dapesó furaalu, me so taaróló faalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tétepa, kale yó matere whi̧rapené Yesupaae woseturaalu, “Tale-ó, ai alarape-a momó eratepa kelaaloé?” depa, ama duraalu, “Na ó hupu kȩlaai nokole barape sikimó sȩ́ kwȩyóló bopétu betepa, ti ama naaire o̧la kȩlaai mupa ai dere ape yóló kisipa yaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ai fo yóló kemetepa, Yesuné ama yó matere whi̧rapené Talepaae momatere ala ha̧le yó tanó̧póló, etei fo sale yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Ai doasi be huluamó fo tokó̧ló taletere whi̧ beta̧ beterepó. Ai whi̧ta, Kótó kolóló witere alakélé ini, dotoróȩ falepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ai be huluamó beta̧ wulia so beterepó. Ai so ama bóe whi̧né a̧tamo fo tokó̧ló só derao̧sóró a̧ tao só̧póló, suka fea fo taletere whi̧ beterepaae eneta du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Kale soné beta̧ fo maaté eneta du betepa, a̧ hó̧turaalu i fo yalepó. ‘Ȩta, Kótókélé mo so whi̧kélé, kolóló wi inire whi̧tei, i wulia soné a̧ tao sae yóló dotopoi fo maaté eneta yó taneteiné ȩ hó̧tepa a̧ tao saalopó,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Téró Talené duraalu, “Kale fo tokó̧ló taletere dowi whi̧né i sopaae yale fo wosóló kisipa muae. ");
INSERT INTO ppo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kótóné ama sorokó su yóló beteró betere so whi̧né dȩtamokélé, dikitamokélé, kematóró yó tapa, ai kematere o̧la ama melaalomeié? ");
INSERT INTO ppo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ya̧lo dia̧paae i dere ape. Kale fo tokó̧ló só deraaire whi̧né dia̧ só derao̧sóró, ama mo hapale tao saalo ai ape. Téyaalotei, kale Whi̧né Naalema i haepaae wale sukamó so whi̧ fea kisipa tiki tiró betepa kelaalorópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesuné i fo sale atimapaae yó mótu duraalu, mepaae whi̧ atimata mo donoi ala dapóló bopé faketuraalu, mepaae so whi̧ tȩteratere alamó Yesuné etei fo sale yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Taks moni sere whi̧ró Farisi whi̧tamo moma yaairaalu, momatere be dolopaae holalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Téró, kale Farisi whi̧ a̧ turukó holóló daalu amatei, a̧mó etei kaae moma yalepó. ‘Tale Kótó-ó, ȩta mepaae whi̧rape dere kaae o̧la o̧lémi nokole alakélé, nópu nokole alakélé, mepaae dere dowi alakélé, ó i daale takis moni sere whi̧ kaae bitinipó. Téru ya̧lo ya̧paae mo kée dapó. ");
INSERT INTO ppo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ȩta, beta̧ fulamótei be dȩ tamomó o̧la néni, weyóló ha̧le bitu, ya̧lo o̧la o̧la naase tamo moletei dekeyóló, beta̧ Talepaae mótua dapó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Téyaletei, kale takis moni sere whi̧ a̧ mo tumó daalu, hepen bepaae kese horéni haepaae hemée deyóló daalu, ‘Tale Kótó-ó, ȩta dowi ala dere whi̧pa naao ko̧lené sukutu, ya̧lo dowi ala kwia kemerae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ya̧lo dia̧paae i dere ape. Kale nalo momayale takis moni sere whi̧né ama dowi ala Talené kemeratepa, a̧ hai̧tamo bepaae feletei, me whi̧né ama dowi ala ha̧le mupatei felepó. Mepaae whi̧ de amatei a̧ deróló dua betepa, ti Kótóné a̧ sóró horaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Téró so whi̧ feané teó sóró betó mole naale senaale tikimó Yesuné naase muló̧póló, a̧ beterepaae dapesó wua dere ala kilitu, ama yó matere whi̧rapené dapesó wakesé yóló, atima foné salepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Téyaletei, Yesuné kale naale senaale a̧ beterepaae dapesó ape yóló duraalu, “Atei kaae naale beleka̧atiki ȩ beterepaae wó̧pólópa, sesékese. Ti noatepae, Kótóné tȩteróló kaae tare ao̧mó betaaire alata, atei naale senaale beleka̧atiki kaae fóló betenérapó. ");
INSERT INTO ppo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ya̧lo dia̧paae mo i dere ape. Mepaae so whi̧ detamo i betó mole naale senaale beleka̧atiki kaae betepa, ti Kótóné tȩteróló kaae tare ao̧mó sókó fóló betenérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Atéró, beta̧ Juda topo whi̧ wóló Yesupaae woseturaalu, “Yó matere whi̧ wisi-ó, mo ti betere bete saairaalu, ya̧lo noa alakó yaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ai fo depa, Yesuné a̧paae tokó̧ mótu duraalu, “Beta̧ whi̧kélé whi̧ wisi bitini, Kótó a̧ beta̧ wisirapa, naao ȩpaae noatepa whi̧ wisi-ó fo de? ");
INSERT INTO ppo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ti noatepae, kale tukóló muló betere fota, naao dosa̧ayóló ai kisipare ape. So nópu nao̧se, whi̧ dao̧se, o̧lémi nao̧se, me whi̧ dilikó̧ló kapala fo yao̧se, naao hae aya ao̧mó mo dua betae erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ai fo depa, kale whi̧né tokó̧ mótu duraalu, “Ai alarape feata take ȩ ketemó bitu deté waletei, miókélé ha̧le yótóró tarapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ai fo depa, Yesuné a̧paae duraalu, “Mo beta̧ ala beta̧ ya̧ ya̧ya̧rapó. Térapa, naao muó mole o̧la o̧la fea dotonóló, moni sóró mepaae yolealere so whi̧mó melae. Atéró ya̧ta, hepen-mó mole wisi wisi o̧la saasepóló ȩ sya ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kale hamoko whi̧né ai fo woseturaalu, a̧ doasi néli whi̧ mo beterapóló kisipa mutu, kutiri hu̧mula yóló fomotamo felepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Atéteremó, Yesuné a̧ kelené kikéyóló kaae taru duraalu, “O̧la o̧la fea tare whi̧ Kótóné tȩteróló kaae tare ao̧mó sókó fóló betaaire mo doasi dirirapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","“Ti noatepae, kamel hupu ketȩ́li dolomó sókó faaire hapóluni, su̧mó fenérapó. Tépatei, doasi o̧la o̧la mole néli whi̧rapeta, Kótóné tȩteróló kaae tare ao̧mó sókó faaire mo hapólurapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ai fo depa wosale so whi̧né Yesupaae woseturaalu, “Da̧ feata alunérapa, Kótóné demaaté tao saaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ai fo depa Yesuné duraalu, “Mo whi̧né enénire ala Kótóné mo su̧mó enérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tétepa Pitané duraalu, “Da̧né be ó o̧la o̧la fea mupa taaróló, ya̧ i sya wale ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ai fo depa Yesuné duraalu, “Ya̧lo dia̧paae mo i dere ape. Mepaae whi̧ dené ama be ó soma ó nomarape ó hama alima ó naale senaale taaróló, Kótóné tȩteróló kaae tare ao̧mó betaai dapóló fupata, ti mió i alimó bitukélé ama taaróló wale o̧la o̧la tómó beleróló, Kótóné mo dekéró matepa saalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ai o̧la maaté meitei, take waaire alimó mo ti betaaire betekélé saalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Atéró, Yesuné yó matere 12 whi̧rape dȩpaae dapesó fóló bitu duraalu, “Da̧ta Jerusalem be huluapaae holaai foletei, Kótóné ama ko̧ló whi̧rapené i ala yaalopóló asȩre fo mió mo dokonóló kale Whi̧né Naalemapaae eratepa kelaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","A̧ta, Juda meire fake whi̧rapené dó̧póló eleké deyóló, atima naase tua̧paae mulaalo ai ape. Atétepa, atimané a̧ doka doka yóo, haleróo, fesa̧a apuróo, képi tikiné fokosoi ala yóló, a̧ mo ti sukó̧póló dóo, yaalo ai ape yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Téyaalotei, sore be dȩmó a̧ mo ti suka̧letei momó kepaayóló betaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ama yó matere whi̧rapené ai yale fo wosóta yaletei, bete hiróló moleteiné diriyóló kisipa sini, ko̧ló ko̧ló du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Téró Yesu a̧ Jeriko be huluapaae felekemó sókó faai tu̧mó fu betalemó, beta̧ kele dilikire whi̧ tu̧ dȩmó bituraalu, fua wuatere so whi̧paae monikó a̧lae yóló, kema du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Atéró wosalemó, so whi̧ mo fea tu̧mó fua wua du betepa, ai so whi̧paae woseturaalu, “Doa ai-a, noa ala maaté du bitu de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ti fo depa, atimané a̧paae duraalu, “Nasaret be hulua whi̧kó Yesu i fole ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ai fo depa, ama fo fakeyóló duraalu, “Depit-né Naalema Yesu-ó, naao ȩ ko̧lené sukuturaalu tao sae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Atéró, mepaae folosóró fele so whi̧né kale whi̧paae momó yaai dée yóló foné salepó. Tétepatei, kale sekȩ́né fo faketóró dekéró yó taru duraalu, “Depit-né Naalema Yesu-ó, naao ȩ ko̧lené suka̧e,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Atétepa Yesu a̧ kei̧yóló daalu, kale whi̧rapepaae duraalu, “Ai whi̧ ȩ beterepaae dapesó ape,” yalepó. Atétepa, kale whi̧ dapesó wóló felekemó daapa, Yesuné a̧paae woseturaalu, “Ya̧lo ya̧mó noa alakó eró̧póló de?” depa, kale whi̧né duraalu, “Tale-ó, ya̧lo kelené o̧la o̧la kelenée yóló kisipa mutapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tétepa, Yesuné a̧paae duraalu, “Naao kisipa tiki tirale alané naao kele ai wisiyalepa, mió kelae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yesuné ai fo deretamotóró kale whi̧né ama kele wisitepa, Yesu sya furaalu, Kótóné doi hale sóró horaté felepó. Ai ala depa kelale so whi̧nékélé Kótóné doi hale sóró horalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Atéró, Yesu a̧ Jeriko be huluamó sókó fóló, ai be belamó fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Téyalemó, takis moni siré kotere whi̧rapené doasi topo whi̧ Sakius beterepó. A̧ta, fea o̧la o̧lané néli whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ama kisipané Yesu deró kelaai dapóló felemó, aimó mo ha̧le o̧la kaae so whi̧ touróló daae moleteiné, Sakius a̧ ha̧lekeruraalu Yesu wisiyóló kilinipó. ");
INSERT INTO ppo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Atépa, kale whi̧ a̧pi sururu yóló fóló, Yesu tu̧mó wale kelaai, beta̧ nose kaae ni siki doló holóló kaae tawóló beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Atépa, Yesu a̧ ni betemó sókó fóló ai ni sikipaae kele horalemó Sakius daapa kolóló duraalu, “Sakius-ó, mió ȩ ya̧tamo naao bemó betaai kisipa mutapa, ya̧ mo hapale dere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Atétepa, a̧ hapale téti dorowóló, hȩkesetamo Yesu dape sóró ama bepaae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Atétepa, ai daae mole so whi̧ feané Yesu Sakius-né bepaae fupa kolóló, atimasisi kikiti eróló duraalu, “A̧ta dowi ala du betere whi̧tamotei, betaai ai fele ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Téyaletei, kale Sakius a̧ turukó holóló Talepaae duraalu, “Tale-ó, mióta, ya̧lo i mole o̧la o̧larape bukóló, mepaae yolealere so whi̧mó melóo, ya̧lotamo so whi̧ dilikó̧ló mepaae monikó simó ti dou̧ró félimó tómó beleróló tokó̧ melóo, yaai dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ai fo depa Yesuné a̧paae duraalu, “Kótóné so whi̧ aluyao̧sóró tao sere ala mió i bepaae walepó. Ti noatepae, i whi̧ a̧kélé Abraham-né naaletóró beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ti Whi̧né Naalema a̧ waleteita, aluyale so whi̧ kekó̧ló tao saairaalu, walepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Atéró, ama ai du betere fo wosetu betepatei, a̧ Jerusalem be hulua felekepaae sókó waleteiné Kótóné tȩteróló kaae tare ao̧mó mole ala so whi̧né kisipané mo felekemó sókó waaitere nisi du betalepó. Atétepa ama du betere fotamo touróló, atimapaae i fo salekélé yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Atéró ama duraalu, “Hae kwia fea tȩteróló kaae tare topo whi̧rapené fake whi̧ beta̧ topo whi̧ sóró beteratepa momó fesaae wóló, hae kwia ama tȩteróló kaae tawaai dapóló, a̧ felepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A̧ atéró faairaalu, ama kutó diratere naasetamo whi̧rapepaae ape yóló duraalu, ‘Ya̧lo i matere moniné mepaae kutó diraté fóló, tómó beleróló sóró muló betepa, momó fesaae wou kelaalopóló,’ a̧ felepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Téyaletei, ama be whi̧ so whi̧né ai sekȩ́né atima tȩteróló kaae tawao̧sóró kisipa mutu, ‘Kale doasi topo whi̧paae ene fó̧póló, atimakó mepaae whi̧rape a̧ fi ki̧lipaae dotȩyalepó.’ ");
INSERT INTO ppo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Até yaletei, doasiné kale whi̧paae naaotóró tȩteróló kaae tawaasepóló, ya̧ sóró beteratapa fae depa, a̧ bepaae fesaae walepó. Téró, ama kutó diratere whi̧rapepaae melale moniné mepaae kutó diróló, tómó beleróló meteró saleró kelaaipa, dapesene fae yóló, whi̧rape dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Atétepa, ama moni melale whi̧rapekó beta̧ whi̧ folosóró wóló duraalu, ‘Doa whi̧-ó, take naao ȩpaae beta̧ melale moni bosenóló, mo dekéró sóró muló beterapó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ti fo depa, kale topo whi̧né duraalu, ‘Ya̧lo kutó diratere whi̧ wisi-ó, naao ai ere ala mo wisirapó. Ti noatepae, ya̧lo mo sawatamo melale o̧la naao mo wisiyóló kaae tawirapa, naasetamo be huluakélé naaotóró tȩteróló kaae tawaasepe,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kale dere kaae whi̧ me wóló duraalu, ‘Doa whi̧-ó, naaota ȩpaae moni beta̧ melaletei, ya̧lo mepaae kutó dité fóló, naao melale moni tómó beleróló aporó sóró muló beterapó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ti fo depa, ama topo whi̧né tokó̧ mótu duraalu, ‘Aporó be huluarape naao tȩteróló kaae tawaasepóló, ya̧lo ya̧ sóró beteratapó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Téró kale dere kaae, ama kutó dirale whi̧ me wóló duraalu, ‘Doa whi̧-ó, naao kale melale monita, ya̧lo me kutókélé dini, kuti kwiané bopeyóló mulaletei, i sóró wale ape. ");
INSERT INTO ppo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ti noatepae, ya̧ta mo kekepai whi̧ bitu, mené o̧latei naao sóo, me whi̧né biliyale o̧la naao bukóló, kwiapaae ya̧ sóo dua dapó. Atétere ala ya̧lo tuȩ́ruraalu, ȩ witepa naao yae yale ala inipó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ti fo depa ama topo whi̧né a̧paae duraalu, ‘Ya̧ta, kutó diratere whi̧ dowipó. Ya̧tamo fo tokó̧ló ya̧ só deraaitere ala ti naao dere fonétei ya̧ ai só deretere ape. ");
INSERT INTO ppo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ti naao atei kaae kisipa mulutei, ȩ fesaae wouraalu hu̧róló só̧póló moni mulatere tikipaae mulale fole noatepa yaleé?’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Téró, kale topo whi̧né aimó daae mole whi̧rapepaae duraalu, ‘Ama ai tare moni fasóló naase tamo moni tare whi̧paae melae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ai fo depa, atimané kale topo whi̧paae duraalu, ‘Doa whi̧-ó, ai whi̧ta naase tamo moni taketi sóró tarapó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ti fo depa ama duraalu, ‘Ya̧lo dia̧paae i dere ape. Mepaae o̧la o̧la hu̧róló mole whi̧paae ti mo dekéró beleróló melaalo ai ape. Téyaalotei, mepaae whi̧ de o̧la o̧la sawa téti mupa, ti ai o̧la fasó saalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Téyaalotei, mepaae ya̧lo tȩteróló kaae tare ao̧mó betere hó̧róló bóe dele whi̧rapeta, ipaae dapesó wóló, mo ti sinó̧póló dae,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Téró Yesuné i fo yóló kemetepa, atima Jerusalem be huluapaae furaalu, ama a̧lisó felepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Atéró, a̧ Betpas beró Betani betamopaae sókó faai fu betalepó. Ai be hulua tamo felekemó Olip dupó du betere tiki erapó. ");
INSERT INTO ppo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Aimó ama yó matere whi̧ tamo dotonaai atimaamopaae duraalu, “U bepaae diaamopi fae. Ai bemó sókó fóló kelenalemó, whi̧kélé betóló kunire teó donki hupu duló betaalopó. Téyaalopa, ai hupu taayóló ipaae dapesó ape. ");
INSERT INTO ppo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Atéró taanalemótamo, whi̧ mené diaamopaae woseturaalu, ‘Ai neyaai de?’ depa, ti i fo yae. ‘Momó dapesó waaitei, Talené ama diyaaire kutó mupa sóró ape yale tikimó sóró fulapó yae,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Atéró dotonatepa fóló kelalemó, atimaamopaae yale fotórómo epa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Atépa, atimaamo kale donki hupu halika teraatu betalemó, hupu talerape wóló atimaamopaae woseturaalu, “Ai hupu teraatu betere-a noayaai de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ti fo depa atimaamoné duraalu, “Ita Talené ama diyaaire kutó mupa, sera̧le fae yale tikimó sóró fulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Atéró, Yesu beterepaae dapesó wóló daaló bitu, atimaamoné deró betere fo̧loi kutirape sorokóló, Yesu a̧ hupuné sisó tómó beteró̧póló, whamenalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Atéró a̧ ai hupu tómó betóló wapa, so whi̧ folosóró furaalu, atimané deró betere kutirape sorokóló tu̧mó whamenaté felepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Atéró, a̧ Jerusalem be huluapaae felekemó sókó faairaalu, Olip du sokore ao̧paae doropole tu̧mó sókó derepelepó. Aimó, ama yó matere so whi̧ mo feané Kótóné kae kae kelemei alarape eratepa kelaleteiné atima hȩkesené sukuturaalu, fo fakeyóló Kótóné doi hale sóró horaai kaae salepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Mió Talené doimó wale doasi topo whi̧ wisi-ó, Kótóné ya̧ wisiró̧póló yae!” “Kótóné hepen be tua̧mó mole hosaa muni deyóló dua betere ala so whi̧ feapaae eró̧póló yae. Téturaalu, mo taoró betere Kótóné kae mole doasi doi hale sóró horae!” deté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tétepa, ai so whi̧ kuamó betó mole Farisi whi̧rapené Yesupaae duraalu, “Naao yó matere whi̧rapepaae taalae yóló, foné sae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ti fo depa ama atimapaae duraalu, “Ya̧lo dia̧paae mo i dere ape. Atimatamo fo ini dua betepa, ti tu̧mó ai daae mole kaporapenétei doasi fo fake yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Atéró, Yesu a̧ Jerusalem be huluapaae felekemó sókó faai fu bitu, ai doasi be hulua tua̧paae kese deralemó, mo ko̧lei ala epa, a̧ doasi wole yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Atéró woleyóló duraalu, “Hosaa muni deyóló dua betaaire ala mió i be dȩmótóró dia̧ beterepaae walapóló, kisipa ua̧sóró ti mo wisi ua̧pó. Téua̧tei, ai ala yaaire be dȩ kemeyaleteiné mió diaao̧ kelené kelao̧sóró, kinó beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Téretei, nalo me be dȩmó kale bóe whi̧rape atima naao bepaae dorowaairaalu, be bopéró betere tipimó hae ka̧ayóló mulaté holóló, naao be bopéró betaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Atére tómó atima daane holóló, dia̧kélé diaao̧ naale senaalekélé tao sóró haemó hairaalo ai ape. Kane fake me tómó beleretei, atéró muló̧póló taalaalomeipó. Ti noatepae, Tale Kótóné dia̧ tao saai wale be dȩ diaao̧ kisipani, hó̧raleteinépó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Téró, a̧ momatere be bolaare tipi tua̧paae sókó holalemó, whi̧rapené o̧la o̧la dotonóló dupu du betepa fó̧póló dóló ho̧konalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Atéró, ama atimapaae duraalu, “Ya̧lo beta, moma maaté yaai tȩnapóló asȩmó epatei, diaao̧ ai du betere alané o̧lémi whi̧ betere be ao̧rótu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Atéró momatere bemó, betere doko̧ fea ama fo yó maleta du betalepó. Tétu betepatei, so whi̧mó momaratere topo whi̧rapekélé, Moses-né asȩre fo yó matere whi̧rapekélé, so whi̧ kaae tare mepaae whi̧ disirapekélé, fea touyóló, Yesu daaire tu̧ kekitu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Téyaletei, atimané a̧ daaire tu̧ me kilinipó. Ti noatepae, yó matere fo so whi̧né wosóló, hosaamó su betaleteiné a̧ daaire tu̧kélé kilinipó. ");
INSERT INTO ppo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Téró, me sukamó Yesu a̧ momatere be tua̧mó Kótóné ala etérópóló so whi̧ feapaae yó matere alaró, kale mió wosetere fo wisitamo yó mótu betalepó. Tétu betepa, mo so whi̧mó momaratere whi̧rapekélé, Moses-né asȩre fo yó matere whi̧rapekélé, mepaae whi̧ disirapekélé, fea touyóló a̧ beterepaae walepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Atéró wóló a̧paae duraalu, “Naao ai alarape yó̧póló, ya̧ né sóró beteraleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ti fo depa, ama atimapaae duraalu, “Ya̧lokélé dia̧paae wosetere fo beta̧ i dapa, ȩpaae tokó̧ a̧lae. ");
INSERT INTO ppo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon-né wȩi tópuratere ala ó hepen bemó yae depa yalepé, mo whi̧né yae depa yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ai fo deremó, whi̧rape atimasisitei fo kȩlaaróló duraalu, “Da̧nétamo, hepen bemó yae depa yalepó depa, ti da̧paae ama dere fo wosóló kisipa tiki tiratere noatepa deé enérapó. ");
INSERT INTO ppo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tépatei da̧né duraalu, mo whi̧né yae depa yalepó depa, ti doai wóló betó mole so whi̧né kapo duné da̧ siróló daalopó. Ti noatepae, Jonta so whi̧paae yó matere Kótóné ko̧ló whi̧ betaletei feané kisiparapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Atétepa, atimané a̧paae duraalu, “Jon-né wȩi tópuratere ala a̧paae né yae depa yaleró, da̧ kisipanipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ai fo depa Yesuné duraalu, “Diaao̧ ya̧lo wosale fo tokó̧ menitepa, ti dia̧né ȩpaae wosale fokélé tokó̧ melaalo meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Téró Yesuné so whi̧paae ai fo deté fóló, me i fo salekélé yalepó. “Whi̧ beta̧né ama kutó diyóló wain képi wae biliyalepó. Atéró, ai kutó mepaae whi̧rapené kaae taru, u̧lumétere o̧la sóró dotonótu betae yóló, a̧ fo̧lo sukamó me be huluapaae biti̧ felepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kale o̧la u̧lumétepa sere alimó, kale kutó talené ama kutó diratere whi̧kó beta̧paae duraalu, ya̧ kutó kaae tare whi̧ beterepaae mepaae u̧lumére o̧lakó sera̧le fae yóló dotȩyalepó. Téyaletei, kutó kaae tare whi̧rapené a̧ du beteró, ha̧le fó̧póló dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Téró, kale dere kaae ama kutó diratere whi̧ me dotȩyalepó. Téyaletei, ai whi̧kélé atimané dóló susupuróló, haletamo ha̧le fó̧póló dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Atéró, kale dere kaae sore dakoróló whi̧ memo dotȩyalepó. Téyaletei, ai whi̧kélé atimané du beteró samea sókó faróló, belapaae sóró taae deralepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Téró, kale wain képi kutó talené duraalu, ‘Mió ya̧lo noa alakó yaaloé? Ya̧lo yaala sókó fóló hosaa turó mole naale beta̧ atima beterepaae dotonatepa, atimané a̧ mo wisiyóló dape sóró, ama dere fo wosaalopóló kisipatu, dotȩyalepó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Téyaletei, kale kutó diratere whi̧rapené a̧ wale kolóló, atimasisitei fo dokóló duraalu, ‘Aita, i kutó talené ama naalepó. Alima sinitepa, i kutóró mepaae mómu o̧la o̧latamo fea ama sao̧sóró, da̧ saaira̧alu, a̧ daalopa siépe,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Atéró, atimané a̧ kale wain képi kutó tua̧mó sóró belapaae taae deróló mo ti dalepó. Atétepa, kutó tale wóló atimapaae noa alakó eraaloé? ");
INSERT INTO ppo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kale kutó diratere whi̧rape mo ti dóló sukunóló, ai kutó mepaae whi̧rapené kaae tawó̧póló melaalopó,” yalepó. Tétepa, aimó betó mole mo so whi̧ feané ai dere fo wosóló duraalu, “Aita enénire alatei dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Téró, Yesuné kelené kiké yóló kaae taru atimapaae woseturaalu, “Kótóné fo tua̧mó, ‘Mepaae be tȩtere whi̧rapené taae farale kane faketei, sóró be hulua eleké wisinaale botokoróló deyaalo ai ape,’ yóló asȩmó ere fo-a, noa betené yaleé? ");
INSERT INTO ppo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Téyaalotei, mepaae so whi̧ de ai kapo fake tómó kotóo sóró dée nukupa, ti ama tiki turukó fóló doalé maaté yaalo ai ape. Téyaalotei, ai kale kapo dokó̧ dorowouraalu tȩiya dere so whi̧ta, mo ti derakó̧ fóló muaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tétepa, Moses-né asȩre fo yó matere whi̧raperó mo so whi̧mó momaratere topo whi̧rapetamoné ama ai yale fo saleta, atimapaaetóró dapóló aimótóró tawóló daai yaletei, ai touró betere so whi̧né atimapaae me ala erao̧sóró, witepa taaralepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Atétepa, atimané Yesuné me alakó ha̧sókó fóló déró kelaai, mepaae whi̧rape mo ala dere whi̧ ao̧yóló kikiti kaae tawóló beteró̧póló, mepaae whi̧rape dotȩyalepó. Aita ha̧le mei, a̧ ha̧sókó fóló, ama i fo mo depa wosalepóló, Rom Gavman topo whi̧né naase tua̧mó mulale faai kisipa mutu yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Atétepa, kale whi̧rapené a̧paae woseturaalu, “Yó matere whi̧-ó, naao dere foró so whi̧paae yó matere alatamota, mo dono dapó. Naao fake so whi̧ maaté taosuraalu, mo so whi̧ sisópaae erótumipó. Naaota, Kótóné tuȩ́ mole alatóró mo dono yó mótu beteretei da̧né kisiparapó. ");
INSERT INTO ppo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ti da̧né takis moni Sisapaae materetei-a, donorépe meié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Atimané a̧ só deraai dere ala ama kolóló, atimapaae duraalu, “Ai denarias moni ya̧lo kelaalopa ȩpaae yó a̧lae yóló matepa tao sóró duraalu, moni tómó i mole asoró doitamo-a né?,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ti fo depa, atimané duraalu, “Sisanépó,” yalepó. Tétepa ama duraalu, “ Sisané o̧lapa, ti Sisapaae melae. Kótóné o̧la ti Kótópaae melae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Atéró, Yesu so whi̧ feané keletómó me alakó ha̧sókó fuléró kelaai su̧ saletei, a̧ ha̧sókókélé feni, ama atimapaae fesaayóló dere fomó, atima hokomó sókó furaalu fokélé tekini, siratei du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mepaae suka̧le so whi̧ kepaayaalo meipó, du betere Sadyusi fakekó mepaae whi̧rapetamo Yesupaae wosetere fo yaai walepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Atéró duraalu, “Yó matere whi̧-ó, whi̧ beta̧ so dokaletei, naale senaalekélé deni ha̧le sinitepa, noma me whi̧né ai so wulia dokóló naale detepa, ti ai naale noma suka̧le whi̧ betale sirimó beteró̧póló yae fo Moses-né asȩmó da̧paae erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Take wȩikeró nomarape beterepó. Atéró bitu, topo whi̧ so dokaletei, ai sotamo naale deni, a̧ ha̧le sinalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Atéró sukutepa, kale so wulia noma me whi̧némo dokalemó, ai whi̧kélé naale deni, ha̧le suka̧lepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","32","Nomarape fea até deté fóló, nalo mo kemerótu noma awa̧ taalu whi̧né dokaletei, a̧kélé ha̧le suka̧lepó. Atéró mo ti kemeróturaalu, kale sokélé suka̧lepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Atéró, wȩikeró whi̧rapené dokale so take kepaayóló wale sukamó, mé whi̧né dokaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ti fo depa Yesuné atimapaae duraalu, “Mió i alimó bitu, whi̧ so dokóo, so whi̧tamo fóo, du beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tétu betepatei, suka̧le so whi̧ momó kepaayóló betaaire alimó atéró whi̧ so dokotere alakélé, so whi̧tamo beteratere alakélé, sinitere alakélé ini, hepen bemó betere ensel kaae betaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Téturaalu, atima kepaaró betere naale senaale ereteiné Kótóné ama naale senaaletóró betaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ni sesaapemó duku betere si mi dolomó yale fo Moses-né asȩrapó. A̧ta, Abraham, Aisak, Jekop-sépi fea tȩteróló kaae tare Kótó beterapó. Atére foné suka̧le so whi̧ aluni, kepaayóló beterapóló, ha̧keamó yó matapó. ");
INSERT INTO ppo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ti a̧ta, suka̧le so whi̧ maaté tȩteróló kaae tanitei, mo betere so whi̧kélé tȩteróló kaae tare Kótó beterapó. Ti noatepae, suka̧le so whi̧kélé, betere so whi̧kélé, fea amatóró beteró beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Moses-né asȩre fo yó matere whi̧rape mepaaené a̧paae tokó̧ mótu duraalu, “Yó matere whi̧-ó! naao dere fota, mo dono dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Téyaletei, ama ai yale foné atima haleturaalu, whi̧ beta̧nékélé a̧paae me wosetere fo inipó. ");
INSERT INTO ppo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Téró, Yesuné atimapaae duraalu, “Kótóné so whi̧ tȩteróló kaae tare whi̧ Kerisota, Depit-né naalepó du betere-a noa fo betené de? ");
INSERT INTO ppo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Ti ai fo bete Depit-né amatei, ha̧kearóló buk Sam-mó asȩyóló muló beterapó. ‘Talené ȩ tȩteróló kaae tare Talepaae duraalu, “Ya̧lo naao bóe whi̧rape tétei aleróló, naao hó ao̧mó beteraalopa, kaae tawóló ya̧lo turu naase dȩmó betae,” ’ erapó. ");
INSERT INTO ppo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ti Depit-né a̧ tȩteróló kaae tare Tale-ó du betaleteimo, ama naalepó, fo neteró yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Téró, aimó betó mole so whi̧ feané ama yó mótu betere fo wosetu betepatei, Yesu a̧ ama yó matere whi̧rape daalepaae fetée fóló duraalu, “Moses-né asȩre fo yó matere whi̧rapené dere alané dia̧ dorao̧sóró mo wisiyóló kaae tawae. ");
INSERT INTO ppo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Ti atimata, so whi̧ feané doasi whi̧-ó yóló, dukiratere koko̧mó so whi̧ fea toura̧leta dere tikipaae faairaalu, mo fo̧loi kuti wisimaaté deróló fua yóo, Kótóné fo wosetere be dolopaae fukélé, mo wisi tikimótóró betaai hȩkese dua yóo, o̧la detere sukamókélé, topo whi̧rape bitua betere tikimó, betaai ekȩle yóo, dua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Téturaalu, kale wulia sorapekélé dilikó̧ló atimané o̧la o̧la fea o̧lémi sóo, moma duraalukélé, so whi̧né dukiratere koko̧mó fo̧lo si̧yóló yóo, dua dapó. Take kemetere sukamó atétere whi̧rapené saaire kwiata, mepaae so whi̧né saaire sekȩ bosenóló, mo doasi saalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Téró Yesu a̧ momatere bemó bitu kaae taremó, mepaae néli whi̧né Kótópaae ha̧le matere moni deratere dolopaae dekéró dera̧leta du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Atétepa kelalemó, beta̧ yoleale wulia sonékélé sonaai moni ke beleka̧amale tamo dera̧le walepó. ");
INSERT INTO ppo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Atétepa ama duraalu, “Ya̧lo dia̧paae mo i dere ape. I yolealere wulia soné derale moni kené so whi̧ feané derale moni taaróló, mo bosene falapó. ");
INSERT INTO ppo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ti noatepae, so whi̧ feanéta doakale moni mupatei, téti maaté dera̧leta yalepó. Téyaletei i wulia sonéta, ama depe dolo sesé mole moni ketei, mo ti kemeróló dera̧le walepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Téró, mepaae ama yó matere whi̧rape atima furaalu, “Mepaae so whi̧né Kótópaae ha̧le matere o̧la o̧laró kapo fake wisitamoné momatere be wisinaale tȩyale tikimó koko̧né sininó beterapa kelae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Tétepa, Yesuné atimapaae duraalu, “Diaao̧ mió i keletere o̧la o̧la feata, take waaire sukamó me kapotamo atéró wolekepa kelaalomeitei, fea fisikó fóló, haemó kolokó doropóló mupa kelaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ti fo depa atimané a̧paae woseturaalu, “Yó matere whi̧-ó, ai alarape-a noa sukamó yaaloé? Noa kaae fareyópu eratepa, kolóló kisipa muaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ai fo depa Yesuné duraalu, “ Mepaae whi̧né kapala fo yóló dia̧ dilikao̧sóró, mo hotowa yóló kaae tawae. Ti noatepae, mepaae dilikitere whi̧rape wouraalu ya̧lo doi yóló, ‘Kale waalopó du betere whi̧ ȩtórótipó. Ali mió felekemó walapó,’ depa mo nisiyóló sya fao̧se. ");
INSERT INTO ppo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Doasi bóe dele alaró mepaae whi̧rape atimané hae tiki atimatei tȩteróló kaae tawaairaalu, Gavman whi̧tamo bóe du beterapó dere fo wosóló wiyao̧se. Ti noatepae, folosóró ai alarape mo yaalotei, kemeyaaire ali folo sókó waalomeipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Téró atimapaae duraalu, “Me hae kwiamó betó mole so whi̧ró me hae kwiamó betó mole so whi̧tamo bóe dóo, me hae kwia tȩteróló kaae tare topo whi̧raperó me hae kwia tȩteróló kaae tare topo whi̧rapetamo bóe dóo, yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Atéturaalu, hae kwia feamó doakale bao dere alakélé, doasi sekȩi alakélé, wotetere aliró hepo alitamokélé waalopó. Téturaalu, so whi̧ mo doa winé sinóló diri furu furu yaaire alaró me ala yaairemó dere fareyóputamo sa̧mó eratepa, diaao̧ kelaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ai alarape yaaitei folosóró, mepaae whi̧né dia̧ dóló susupuróló, fo wosetere berapepaae dapesó fóló, dipula beteraalo ai ape. Atéró, dia̧ doasi topo whi̧raperó Gavman whi̧rapetamo beterepaae dapesó faalopó. Dia̧ ya̧lo ala erótu beteremó bóe duraalu ai alarape yaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Atétere alané ya̧lo yó melale alarape atimané keletómó yó meló̧póló, dia̧ tȩ ai mulatere ape. ");
INSERT INTO ppo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Atimané dia̧ só deraairaalu, fotoko̧iné depa dia̧ noa fo yaaloé, yóló whaalia yao̧se. ");
INSERT INTO ppo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ti noatepae, ai ala deretamo ya̧lo dia̧paae kisipa tiki dotoróȩ fole alaró atimané dere fo tokó̧ melaaire fotamo yó melaalo ai ape. Dia̧né ai fo depa woseturaalu, dia̧ só deraaitere whi̧rape folópu kolokó fóló, mo beta̧ whi̧nékélé me tokó̧ matere alakélé yaalomeipó. ");
INSERT INTO ppo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Diaao̧ hae aya ó norape ó fake whi̧rape ó fulumu whi̧rapenékélé, dia̧ dó̧póló eleké deyaalo ai ape. Téturaalu, dia̧ mepaae whi̧rape atimané mo ti dóló sukunaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Atétu, so whi̧ mo feané dia̧tamo bóe dóló, dia̧ hó̧raalo ai ape. Ti atétere alata, atimané ȩ hó̧rótu dia̧kélé ai hó̧ratere ape. ");
INSERT INTO ppo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Téyaalotei, diaao̧ topo niki mo beta̧kókélé aluyaalo meipó. ");
INSERT INTO ppo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Dia̧ mo ti betaaire bete saairaalu, mo diriyóló betae. ");
INSERT INTO ppo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Diaao̧ kelera̧lemó, Jerusalem be hulua bóe whi̧rapené bopéró betepa kilituraalu, kale be hulua mió mo felekemó dóló wópu mulaai dapóló, kisipa muae. ");
INSERT INTO ppo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Atétere sukamó, Judia hae kwiamó betó mole so whi̧ dia̧ ti du sorokó molepaae botokó fóo, mepaae doasi be hulua tua̧mó betó mole so whi̧ dia̧ ai be hulua taaróló fóo, mepaae ai hae kwiamó betóló fale so whi̧kélé ai doasi be hulua tua̧paae fao̧sóró yae. ");
INSERT INTO ppo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ti atétere alimó yaaire alata ha̧le meipó. I haemó betóló fale so whi̧né yale alamó Kótóné kwia móturaalu, doasi sekȩi ala eraalopóló, asȩmó ere fo dokonóturaalu, mo eraalo ape. ");
INSERT INTO ppo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ti aita, Kótóné i hae kwia feamó betó mole so whi̧tamo doasi fopaae buturaalu, só ai deratere ape. Atétere be dȩmó mepaae naale ere soraperó, naale teó awa̧ nuku betere sorapetamo beta̧ ko̧leó, mo doasi sekȩi ala saalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Téturaalu, atima mepaae ti bóe dele sepakené dóló kemeróo, mepaae so whi̧ ti hae kwia feapaae dipula sóró dapo dapo yóo, yaalopó. Tétu, Jerusalem be mo ti doróló torokó̧ faróló, Juda meire fake atimané tȩteróló kaae taté fóló, Kótóné da̧le muló betere kwiamó sókó fupa, ti kemeyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Atéturaalu, sa̧mó daale sukanékélé, ho̧rerapenékélé, wéliénékélé, kae kae alarape depa kolóo, doasi wȩi kȩla whaau yóló holóo yaalopó. Atétere ala i hae kwia feamó betó mole so whi̧né kilitu, noa ala du derópóló hosaa wȩi wȩi yóló wiyaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","I hae kwia feamó betó mole so whi̧né ó sa̧ wore duraalu, ho̧rerape torokó dorowale kilitu, i haemó noa ala du derópóló, doasi winé suka̧alopó. Tétu, diri furu furu yóló be fesaaetamo du dere kaae yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ai alarape yóló kemetepa, kale Whi̧né Naalema ó sa̧ko dolomó doasi bole fotoko̧ró mo kae ere dȩ wisinaaletamo ha̧keamó wapa kelaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ai alarape kaae sóró depa kilitu, aluyao̧sóró Kótóné ama dupure so whi̧ mo felekemó dapesene walapóló kisipa mutu, hai̧tamo turukó holóló daae muae. ");
INSERT INTO ppo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Atéró, ama atimapaae i fo sale yalepó. Ti daale ni noseró mepaae nirapetamoné ere ala diaao̧ kolóló kisipa muae? ");
INSERT INTO ppo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nirape sóku fóló, toko̧ momó beletepa kilituraalu, kale ba fo ali mió mo felekemó ai sókó wale ape dua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Atei alarape kaae depa diaao̧ kilitu, Kótóné tȩteróló kaae tare ala mió mo felekemó walapóló kisipa muae. ");
INSERT INTO ppo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ya̧lo dia̧paae mo i dere ape. Mió i alimó betó mole so whi̧ sukuni ha̧le betepatei, i alarape folosóró yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sa̧ró i haetamo kemeyaalotei, ya̧lo fo beta̧ mo kemekélé ini, ha̧le muó tawaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Dia̧ wȩi nóló topo dotere alané diaao̧ tiki ó naao dere ala ha̧le o̧la kaae taae fatereteikélé, ó i haemó whaaliatu betere alakélé, dia̧né hosaa tua̧mó sekȩné sinitere alakélé du betepa, i be dȩ sókó wouraalu ya̧ hemó duku dere kaae yao̧sóró, mo hotowaró kaae tawae. ");
INSERT INTO ppo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ti noatepae, ai yaaire alarapeta, i hae kwiamó betó mole so whi̧ mo feapaae waalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kale Whi̧né Naalema betere tikimó dia̧kélé betaalopó. Téyaalopa, ai alarapené dia̧ só derao̧sóró, betere doko̧ fea hotowayóló kaae taru, momatere ala yó tawae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Atéró, Yesu a̧ suka fea ai momatere bemó Talené ala etérapóló yó melóló, be kuluka deretamo a̧ Olip du sorokó molepaae fini fi wuatu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Atei ala du betepa, so whi̧ fea mo hi̧katitei turukó holóló Yesuné momatere bemó yó mótu betere fo wosaai wua yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kale bosene fele be dȩ kisipa mutu, fopei bred o deyóló nokole be dȩ felekemó sókó waai depa etéyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","So whi̧mó momaratere topo whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamo so whi̧né kapo duné siróló dao̧sóró wituraalu, Yesu kikiti daaire tu̧ kekitu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Téró, atima 12 yó matere whi̧rapekó beta̧ whi̧né doi Judas Iskariot tua̧paae dowi Satan biti̧ walepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tétepa kale Judas a̧ fóló, mo so whi̧mó momaratere topo whi̧raperó momatere be kaae tare diki tare whi̧rapené topo whi̧rapetamo betó molepaae felepó. Téró Yesu dó̧póló netéró eleké deyaaloé? yóló, fo dokaai felepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Atéró, fo dokóló kemetepa, hȩkese duraalu moni-né a̧ dupuyaalopó, yóló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Atéró, Judas-né wisirapó depa, so whi̧ touróló bitinitere sukamó Yesu dó̧póló naase tua̧paae mulaaire tu̧ kekitu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kale bosene fele be dȩ kisipa mutu, fopei bred o deyóló nokole be dȩmó beta̧ sipsip hupu male dóló, Talepaae simó suku̧laa daróló melaaire be dȩ sókó walepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Téró, Yesuné Pitaro Jon-tamo dotonaai duraalu, “Diaamo fóló, kale bosene fele be dȩmó deyóló naaire o̧lakó taleyóló mulaai fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ti fo depa atimaamoné a̧paae woseturaalu, “Naao kisipané ai o̧la-a, da̧moné momó taleyóló muló̧póló de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ai fo depa ama duraalu, “Diaamo ai be hulua tua̧mó sókó fȩlalemó, whi̧ beta̧ wȩi wuti beleyóló tu̧mó diaamotamo hokolaa yaalo ai ape. Téyaalopa a̧ sya fóló, fole be dolopaae diaamokélé buó deyae. ");
INSERT INTO ppo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Téró, ai be talepaae etei fo yae. Yó matere whi̧né ya̧paae duraalu, ‘Ya̧lo yó matere whi̧rapetamo bosene fele be dȩmó, o̧la deyóló naaire be kekó momó donoróló muló betere?’ yóló, wosae yalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aténalemó, ama diaamopaae óté taoró doasi be ke yó melaalo ai ape. Ai be ke dolomó betaaire ni fake ó mepaae o̧la o̧lakélé fea su̧mó donoróló muló betepa kelaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Atétepa atimaamo fóló kelalemó, Yesuné yale fo motóró epa kelalepó. Atéró bituraalu, kale bosene fele be dȩmó atimané deyóló naaire o̧la aimó donoróló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Atéró, kale o̧la naaire suka kele sókó wapa, Yesuné yale fotóró mo epa kelalepó. Atéró aposel whi̧rapetamo o̧la nokole ni fake tómó boperó bitu o̧la nuku beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Atéru, ama atimapaae duraalu, “Ȩ doasi sekȩ saaire ala feleke depa, kale bosene fele be dȩmó detere o̧la da̧ beta̧mó nokoleteiné ȩ mo doasi hȩkese dapó. ");
INSERT INTO ppo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ti ya̧lo dia̧paae i dere ape. I bosene fele be dȩmó detere o̧la ȩ néli ha̧le bitiré fóló, Kótóné tȩteróló kaae tare ao̧mó mió i o̧la detere ala bete dokonatepa, ti momó naalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Atéró, Yesuné kap wuti sóró taru, Tale Kótópaae mo kée yalepó. Atéró mótu, Yesuné atimapaae duraalu, “I matere wȩi tao sóró, dia̧ fea nósu deté fóló, kemerae. ");
INSERT INTO ppo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ti ya̧lo dia̧paae mo i dere ape. Mió i nokole wain képi wȩi momó kaae néli ha̧le bitiré fóló, Tale Kótóné tȩteróló kaae tare ala sókó wale sukamó momó naalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Téró, ama bred o bula tao sóró Kótópaae mo kée yóló, terekée daalu yóló a̧nirótu duraalu, “Ita, ya̧lo tiki dia̧mó i matere ape. Térapa, dia̧né ȩ kisipa muóló nukulé fu betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Atéró, atima o̧la nóló kemetepa, kale yale kaae wȩi wuti tao sóró taru duraalu, “I wain wȩita, Kótóné ama so whi̧ tao saalopóló, kisi yóló mulale fo diriróturaalu, dia̧ tao saai sunée farale ya̧lo sameapó. ");
INSERT INTO ppo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Téretei, i ni fake tómó ȩtamo beta̧mó o̧la nuku betere whi̧nétei, ȩ dó̧póló eleké deyaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Téyaalotei, Whi̧né Naalema i ala yó̧pólópó yóló, Kótóné tukóló muló betere fo mo dokonóturaalu eraalo ai ape. Téyaalotei, Whi̧né Naalema dó̧póló eleké deyaaire whi̧ beta̧ mo doasi sekȩi ala saaireteiné ko̧lerapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ti fo depa, ai ala-a né yaai dée yóló, atimasisitei u wosene i wosene du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Atéró kale dere kaae, ama yó matere whi̧rape atimasisi doasi topo whi̧-a, de betaai dée yóló fonétei alale su betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tétepa Yesuné atimapaae duraalu, “Kale Juda meire fake tȩteróló kaae tare topo whi̧rapenémo so whi̧ tȩteróló kaae tanó̧póló, sóró beteró betere whi̧rapeta doasi néli whi̧ bitu, so whi̧ fea tao sóró wisi ala erótu betere whi̧rapepó dua dapó. ");
INSERT INTO ppo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tépatei, dia̧ atei kaae ala ini, dia̧ tua̧mótamo doasi topo whi̧ betepa, ti mo ketei kaae betóo, dia̧ tȩteróló kaae tare topo whi̧ ti kutó diratere whi̧ kaae betóo yae. ");
INSERT INTO ppo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ti noatepae, o̧la deyóló nokole sukamó doasi doi mole whi̧rapené noa ala dua de? Ti atima doasi whi̧rape ni fake tómó bitu, o̧la maaté nuku beterepé, kutó diratere whi̧ kaae bitu, o̧la biliyóló maleta dua de? Meipó. Ai doasi doi mole whi̧rape atima ai ala dumi, ni fake tómó bituraalu, o̧la maaté nukua dapó. Tépatei, ȩta dia̧ feané kutó diratere whi̧ kaae beterapó. ");
INSERT INTO ppo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Dia̧ta, ȩpaae sekȩi ala wou betepatei ȩ taaróló botokó feni, ȩtamo beta̧mó bitiré walepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","So whi̧ tȩteróló kaae tanó̧póló ya̧lo Ayané ȩ sóró beterótu yale kaae, ya̧lokélé dia̧ so whi̧ tȩteróló kaae tanó̧póló, sóró beteratapó. ");
INSERT INTO ppo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Até dapa, ya̧lo tȩteróló kaae tare ala tua̧mó ni fake tómó bitu, o̧la nóló, wȩi nóló du betaalopó. Atéturaalu, doasi topo whi̧ betere tikimó bitu, 12 Israel fakerapetamo diaao̧ fo tokó̧ló tale yaasepóló, sóró beteratapó. ");
INSERT INTO ppo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Saimon, Saimon-ó, ya̧lo ya̧paae i dere fo wosae. Mepaae so whi̧né whit ke buléró kelaai fumi sukutu dere kaae, ya̧ tua̧mó noa alakó muléró ka̧ae kelaairaalu, Satan-né ya̧paae wosene walepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Téyaletei Saimon-ó, naao kisipa tiki tiró betere ala taaróló haepaae derepao̧sóró, ya̧lo ya̧mó momaralepó. Naao kisipa tiki feteyóló, ya̧ ȩ beterepaae momó wapata, ti naao norape tao sóró fotoko̧ bulaasepé,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tétepa Pitané a̧paae duraalu, “Tale-ó, ya̧ dipula beteratepa ti ȩkélé wusuró beteróo, sukutepakélé ti wusurótóró sukó̧o enérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ai fo depa Yesuné duraalu, “Pita-ó, ya̧lo ya̧paae i dere ape. Mió i be dȩmó wa̧ kakaruk bané hale yaaipatei, naao ȩ kisipanipó fo sore félimó yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Téró, Yesuné atimapaae woseturaalu, “Ya̧lo dia̧ dotonale sukamó moni butere be ó ho̧leke be ó me o̧lakélé sóró fae ini, ha̧le fó̧póló dotȩyalepó. Téyaletei, dia̧ me o̧lakó mei yaleé?” depa atimané duraalu, “Meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ai fo depa, ama atimapaae duraalu, “Mió diaao̧ moni detere be mupa sóo, yokélé sóo yae. Bóe dele sepakekótamo munipa, ti diaao̧ tómó deró betere kuti sokóló, me whi̧tamo dotonóló sepake beta̧kó dupuyae. ");
INSERT INTO ppo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ti noatepae, i fo asȩyóló muló beterapó. Dowi ala dere whi̧rape dosa̧aturaalu, a̧kélé touróló dosa̧ayalepó. Ya̧lo dia̧paae i dere ape. Ai ere fo dokonóturaalu ȩpaae mo eraalopó. Mo dapó. Ȩmó kisipa muturaalu, Kótóné ko̧ló whi̧rapené asȩmó ere forape fea dokonóló ȩpaae motóró eraalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Téró, ama yó matere whi̧rapené a̧paae duraalu, “Tale-ó, da̧né bóe dele sepake tamo i tarapa kelere?” depa, ama duraalu, “Ai su̧pó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Atéró, Yesu a̧ belapaae sókó doropóló ama dua dere kaae, Olip du sokorepaae fupa, ama yó matere whi̧rapekélé, a̧ sya felepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Atéró, aimó sókó fóló, ama atimapaae duraalu, “Su̧ sere alané dia̧ dowi alamó dée nalao̧sórópa, Talepaae momatu betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Atéró, a̧ atima daale tiki sawa taaróló fóló, bukutiri teya̧ró bituraalu momayalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ama i moma yalepó. “Aya-ó, naao kisipané ȩpaae i waaire sekȩi ala wao̧sóró sesé yaai depa ti té yae. Ya̧lo kisipané enére ala yaalomeipa, naao yaai kisipa mole ala beta̧ erae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Atétepa, ó hepen bemó betere ensel beta̧ dorowóló a̧ tao sóró fotoko̧ bulalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Atéró, Yesuné ama hosaa tua̧mó mo doa sekȩné sinitepa, Alimapaae mo fotoko̧i moma yalepó. Atéturaalu, ama tikimó fosono doasi fa̧ke kaae dorowóló, haepaae fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Atéró momayóló kemetepa, a̧ turukó holóló ama yó matere whi̧rape beterepaae momó fesaae fóló kelalemó, atima dekȩné sukuturaalu fotoko̧kélé meiyóló, noke foposaa yó molepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Atépa ama atimapaae duraalu, “Dia̧ noatepa, noke foposaa yó mule? Su̧ sere alané dia̧ a̧lisóró fóló, dowi alapaae só derao̧sóró, turukó holóló Talepaae momatu betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ama fo kemeni ha̧le du betepatei, so whi̧ mo ha̧le o̧la kaae walepó. Kale yó matepa wosetere 12 whi̧rapekó beta̧ whi̧ Judas-né Yesu ko̧ló tukó naai, a̧ daale felekepaae walepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Téyaletei, Yesuné a̧paae duraalu, “Judas-ó, kale Whi̧né Naalema dó̧póló, eleké deyóló ko̧ló tukó naai wou de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Até yaaire ala, Yesuné ama yó matere whi̧rapené kolóló a̧paae duraalu, “Tale-ó, da̧né i tare sepakerapené deyaróe?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Téró, atimakó beta̧ whi̧né mo so whi̧mó momaratere doasi topo whi̧né kutó diratere whi̧né tururó wosȩ́li sa̧ae deralepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tétepa Yesuné duraalu, “Ai ala me momókó yao̧se!” yalepó. Atéró, Yesuné kale whi̧né wosȩ́li ama ere kaae eralepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Téró, Yesuné mo so whi̧mó momaratere doasi topo whi̧rapekélé, momatere be kaae tare whi̧rapené topo whi̧rapekélé, whi̧ disirapekélé fea woló, a̧ tawaai boperóló daae molepó. Atépa ama duraalu, “Diaao̧ ȩta, i hae kwia tȩteróló kaae tare doasi topo whi̧rapené kaae tare alarape fasó saai, bóe daai a̧lisóró fole whi̧póló, sepakeró nópulutamo tao diliki yóló, ȩ tawaai wou de? ");
INSERT INTO ppo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Take ȩ dia̧tamo momatere be tua̧mó bitua yaletei, diaao̧ ȩ daai tanipó. Ténitei, mióta, dilikire alané tȩteróló kaae tapa, diaao̧ yaaitere ala yó̧póló, tukóló muló betere sukakelemó dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Téró, atimané a̧ tawóló so whi̧mó momaratere topo whi̧né bepaae dapesó felepó. Atétepa, Pitakélé Yesu sya nalo taaeta deté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Téyaletei, ai momatere be bolaare dopóku tua̧ dolomó si noke yóló, atima fea simó boperóló betó mupa, Pitakélé atimatamo beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Atéró a̧ simó beteremó, kutó diratere so seimale beta̧né kolóló, mo ti kikéyóló kaae taru duraalu, “I sekȩ́ta, Yesutamo beta̧mó kwȩale whi̧kópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ai fo depa Pitané duraalu, “Ti senaale-ó, naao ai bope dere whi̧ta ȩ mo tuȩ́kélé inipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Atéró sawa beteró, whi̧ me kaené a̧ kolóló duraalu, “Ya̧kélé atimatamo kwȩale whi̧kóe?” depa, Pitané duraalu, “Ai whi̧ta ȩ meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Atéró, suka kele beta̧ kemetepa kale dere kaae, whi̧ menémo duraalu, “I sekȩta, Yesutamo beta̧mó kwȩale whi̧kó irurapó. Ti a̧kélé Kaleli whi̧tóró mo hi̧tipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ti fo depa, Pitané duraalu, “Diaao̧ ai bope dere whi̧ta, demó déró ȩ tuȩ́nipó,” yalepó. Ai fo deretamotóró wa̧ kakaruk bané hale deremó, ama du betale fo tukó felepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tétepa, Tale a̧ Pita daalepaae fetée wóló, kelené kikéyóló kaae tawalepó. Até deremó, take Talené Pita a̧paae kakaruk bané hale sore félimó yaaipatei, naao ȩ kisipanipó yaalopó yale fo kisipa muni walepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Atétepa, Pita a̧ belapaae sókó doropóló, mo doa dekȩné sini wole du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Atéró, Yesu botokó fao̧sóró, kaae tare whi̧rapené a̧ doka doka duraalu faletere forape yóló dȩleta du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Atéró, ama kelepaa atimané kutiné kinóló dokóló a̧paae woseturaalu, “Ya̧ né daleé? Ya̧ dale whi̧ da̧paae yó a̧lae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Atéró, atimané a̧ faleyóló kae kae dowi forape du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Atéró, be teó dȩteretamo fo tokó̧ló tale yó̧póló beteró betere whi̧ disirapekélé, mo so whi̧mó momaratere doasi topo whi̧rapekélé, Moses-né asȩre fo yó matere whi̧rapekélé, fea beta̧paae toura̧le walepó. Atéró touró bitu, Yesu fo tokó̧ló taleyó̧póló tale dere whi̧rape beterepaae dapesó felepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Atéró atimané duraalu, “Ya̧ta, Kótóné so whi̧ tȩteróló kaae tare whi̧ Kerisopata, ti da̧paae yó a̧lae,” yalepó. Ai fo depa, Yesuné duraalu, “Ya̧lo dia̧paae depa diaao̧ ȩpaae kisipa tiki tiraalomeipó. ");
INSERT INTO ppo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ya̧lo dia̧paae mepaae fo wosenalemókélé, diaao̧ tokó̧ melaalomeipó. ");
INSERT INTO ppo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Téretei, mo miótóró kaae sóró kale Whi̧né Naalema mo doasi fotoko̧ bole Kótóné turu naase tua̧mó betaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ai fo depa, atima mo feané a̧paae woseturaalu, “Ti ya̧ta, Kótóné Naalemaé?” depa ama duraalu, “Me kae mei, diaao̧ mo dono ai dere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ti fo depa, atimané duraalu, “Me kae noa fokómo depa, wosaai de? Fo feata, ama ko̧lómótóró sókó wapa da̧né ai wosale ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Téró, atima aimó betó mole whi̧ mo fea turukó horóló, Yesu Pailat beterepaae dapesó felepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Atéró, atimané a̧ faleyóló só derótu duraalu, “Ai whi̧néta, so whi̧ feané Sisapaae takis moni melao̧sóró sesé yóló, so whi̧ kó̧paae a̧lisóró fu beterapó. Tétu, amatei a̧ta so whi̧ tȩteróló kae tare topo whi̧ Kerisopó du betere alané da̧né tȩteróló kaae tare alarape fea dorótu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Atétepa, Pailat-né Yesupaae woseturaalu, “Ya̧ta, Juda fake so whi̧ tȩteróló kaae tare topo whi̧é?” depa, Yesuné duraalu, “Ȩ́pó. Naaotóró dono ai dere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Téró, Pailat-né Talepaae momaratere topo whi̧raperó so whi̧ featamopaae duraalu, “I whi̧ ya̧lo ka̧ae kelalemó, fo tokó̧ló a̧ só deraaire bete mekélé mupa kilinipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tétepa, atimané fo fakeyóló deteraainé duraalu, “Ai whi̧né Judia hae kwiamó betó mole so whi̧paae yó matere fo wosetu, fo tiki whaa deté fu betalepó. Ama Kaleli hae kwiamó kaae sóró yó maté wóló, mió ipaae ai sókó wale ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ai dere fo wosóló, Pailat-né atimapaae woseturaalu, “A̧ta, Kaleli whi̧é?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ai fo depa, atimané duraalu, “Ai whi̧ta, Herot-né tȩteróló kaae tare hae kwiamó beterapó,” yalepó. Atéyale sukamó Herot a̧kélé ai Jerusalem be huluamó betepa, Pailat-né Yesu Herot beterepaae dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Téró, Yesu atéró sókó wapa kilituraalu, a̧ mo hai̧né sinalepó. Ti noatepae, ama mepaae kelemei alarape erótu beterapó deté fole fo woseturaalu, Yesuné kelemei alakó eratepa kelenée yóló, kisipa mutu betaleteinépó. ");
INSERT INTO ppo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Atéró, kale Herot-né a̧paae kae kae forape woseté feletei, Yesuné fo beta̧kélé tokó̧ menipó. ");
INSERT INTO ppo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Atétepa, so whi̧mó momaratere doasi topo whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamoné a̧ faleyóló só deratere fo du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Téró, kale Herot-ró ama diki tare whi̧rapetamoné a̧ faleyóló duraalu, wisi wisi kuti deróló Pailat beterepaae momó fesaae fó̧póló dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Upuléta, kale Herot-ró Pailat-tamo bóe dóló betaletei, mió i ala yale sukamó fulumu whi̧ aleyóló beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Atéró, kale Pailat-né so whi̧mó momaratere topo whi̧rapepaaekélé, so whi̧ tȩteróló kaae tare topo whi̧rapepaaekélé, so whi̧ feapaaekélé ape yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Atéró touró betepa, ama atimapaae duraalu, “Diaao̧ i whi̧ta, take tȩteróló kaae tare doasi topo whi̧rapetamo bóe daai a̧lisóró fole whi̧póló, ȩ beterepaae dapesó wapa diaao̧ keletómó ya̧lo a̧ tua̧mó daaló bitu, me ha̧sókó fele alakó muléró keka̧lemó meipó. ");
INSERT INTO ppo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot-nékélé taleyalemó, dowi ala mekélé munipa, ama da̧paae ai dotonale ape. I whi̧ mo ti sukó̧póló dele alata, me noa ala itikimó daai de? ");
INSERT INTO ppo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Térapa, ya̧lo a̧ fokosó sóró ha̧le fó̧póló dotȩyaai dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Atimané mo beta̧ ko̧ló daae fóló fo fakeyóló duraalu, “Ai dipula betere whi̧ Barabas da̧ beterepaae wó̧póló dotonóturaalu, i sekȩ́ dóló alurae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ti noatepae, ai whi̧ Barabas-ta Gavman whi̧ betaai dapóló bóe dóló whi̧ dupa, a̧ dipula beteralepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat-né ama kisipanéta, Yesu ha̧le fó̧póló dotonaairaalu, so whi̧paae momó yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Téyaletei, atimané mo doa fo fakeyóló duraalu, “A̧ filipaa ni tómó dóló olerae, a̧ filipaa ni tómó olerae,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Téró, ama sore dakoróló atimapaae duraalu, “I whi̧né noa dowi ala yalemó daaloé? I whi̧ daaire bete me munipó. Téreteiné, ya̧lo a̧ dóló susupuróló, ha̧le fó̧póló dotonaai dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Téyaletei, atimané fo fake dekéró yó taru, doasi sȩyóló duraalu, “A̧ sukó̧póló filipaare ni tómó dóló olorae,” yóló, dere foné Pailat-né fokélé só deralepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Atétepa, Pailat-né kisipanétei taleyóló wisirapa téyae yóló, dotopoi fo du betere so whi̧paae melalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Atéró, ama whi̧ beta̧ dóo, tȩteróló kaae tare alamó topo whi̧rapetamo bóe dóo deremó, dipula beterale whi̧ ha̧le fó̧póló dotonae yalepó. Téró, Yesupaae atimané kisipa mole ala eró̧póló, doasi diki tare whi̧rapené naase tua̧paae melalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Atéró atimané Yesu duóló sóró fu betalemó, Sairin be hulua whi̧kó Saimon ipu bemó biti doasi be huluapaae derepaai wou betepa tu̧ tua̧mó hokolaa yalepó. Atéró a̧ tawóló Yesu oleraaire filipaa ni beleróló, Yesuné sisómó fó̧póló yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Atétepa, so whi̧ mo feané a̧ sya felepó. Atéró, sorape feané sya fu bitu ko̧lené sinituraalu, mo dekȩné suki̧ wole fo deté wou betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Até deté wou betepa, Yesu fetée anóló duraalu, “Jerusalem senaalerape-ó, diaao̧ ȩ wolekesé, dia̧sisitei wole yóló, diaao̧ naale senaalekélé wole yae. ");
INSERT INTO ppo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ti noatepae, take waaire sukamó diaao̧ etei fo yaalo ai ape. Mepaae sorape naale senaale deni, ha̧le ni daale sorapekélé, naale senaale meiyóló ha̧le betere sorapekélé, naale senaale awa̧ menitere sorapekélé, hai̧né sinóló ai betere ape. ");
INSERT INTO ppo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","‘Ai sekȩi ala wale sukamó atimané i fo yaalopó. “I daae mole ulupaae dukó dorowóló da̧ tȩirae,” yaalopó. Du sorokó mole hae durapepaaekélé, ka̧ae dorowóló da̧ husura̧le dere ape yaalopó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ti kisi daale nipaae atei ala depa, ti sélitere nipaae noa kaae sekȩi ala eraaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kale Rom Gavman-né yóló muló betere fo tukóló dowi ala yale whi̧ tamokélé a̧tamo beta̧mó dóló oleraai dapesó walepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Atéró, atima sókó wale tikiné doita, whi̧né topo diripó doi mulapó. A̧ sukó̧póló aimó atimané filipaa ni deyóló oleralepó. Atéró, me whi̧ ama turu naase dȩró oleróo, me whi̧ ama fȩ́ naase dȩró oleróo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Atéró Yesuné duraalu, “Aya-ó, ȩ dele whi̧rapené saaire dowi ala kwia naao ha̧le kemerae. Ti noatepae, atimané du betere alarape atima wisiyóló kisipanipó,” yalepó. Atéró, atimané ama kuti taleyóló saairaalu i ala yalepó. Ni fakerape tao sóró fesekée horótua yalemó, me whi̧né doi ó siri moletei sókó dorowapa, ai whi̧nétóró sua yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Atéró kale so whi̧ fea mo tumó kese a̧lu yóló daae molepó. Kale tȩteróló kaae tare topo whi̧rapené Yesu faletere fo yóló duraalu, “Mepaae whi̧ aluyao̧sóró ama mo wisiyóló tao sua yaletei, a̧tamo Kótóné sókó sóró, beteró betere whi̧ Kerisopata, ti amatei a̧ tao só̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Atéró, kale doasi diki tare whi̧rapekélé, a̧ oleró betere tikipaae wóló daae muluraalu, faletu betalepó. Atéró, atimané a̧mó beta̧ kȩlaa wale finika wain wȩi a̧ nae yóló melalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Atéró a̧paae duraalu, “Ya̧tamo Juda so whi̧né doasi topo whi̧pata, ti ya̧ sinao̧sóró naaotei tao sae,” eneta du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yesuné ama toporó beteremó oleró betere asȩmó i fo erapó. Ita, Juda fake so whi̧ tȩteróló kaae tare doasi topo whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Téró, kale dowi ala du betepa dóló olerale whi̧ tamokó beta̧né a̧ faleyóló duraalu, “Ya̧ Kerisopata, ti naaotei ya̧ taosu da̧mokélé tao sae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Téyaletei, me fakeró oleró betere whi̧né me whi̧ foné sóró duraalu, “Da̧mó sukutereteita, mo da̧moné yale dowi alamó kwia tokó̧ mótu dereteiné mo donorapó. Téretei i whi̧ta, me dowi alakélé meipatei, da̧ fea beta̧ ala yóló sinitapa, ya̧ Kótópaae winié? ");
INSERT INTO ppo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ti noatepae, da̧mota da̧moné yale alamó i sinitere ape. Téretei i whi̧ta, dowi ala mo beta̧kélé inipatei, ha̧le dóló oleró beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Téró ama duraalu, “Yesu-ó, ya̧ naao tȩteróló kaae tare be tua̧paae furaalu, ȩ kisipa keterao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ti fo depa, Yesuné a̧paae tokó̧ mótu duraalu, “Ya̧lo ya̧paae mo i dere ape. Miótitei, ya̧ ȩtamo mo koko̧né suki̧ be wisinaalemó fóló betaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Atéró suka tua̧mó daapatei, hae kwia fea diki yalepó. Atéró dikipatei bitiré fóló, 3 kilok suka tó daane folepaae kemeyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ti noatepae, sukané dȩ suka̧leteiné, diki yó tawalepó. Talepaae momaratere be sata̧leróló oleró betere kuti ama ha̧letei tua̧mótóró teketé doropóló, haepaae sókó deralepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Atétepa, Yesuné fo fakeyóló duraalu, “Aya-ó, ya̧lo kepe bete naao kaae tawasepóló, ya̧ tua̧paae i mulatere ape,” yalepó. Atéró ama ai fo yóló kemetepa, ama fomo sókó fóló a̧ suka̧lepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Atétepa, kale diki tare whi̧rapené topo whi̧né ai yale ala kolóló, Kótóné doi hale sóró horótu duraalu, “Mo dapó, ita mo whi̧ wisinaale ai suki̧rapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Atéró, beta̧paae touró betere so whi̧né kelale alarape atima bepaae momó fesaae furaalu, naao téyae yóló dekȩné sinité fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Téyaletei, mepaae a̧ kisipare whi̧raperó a̧tamo Kaleli haemó beta̧mó betóló wale sorapetamo atima mo tumó daae mulu, ai dere alarape kaae dilikiyóló yó molepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Atéró ai Judia hae tua̧mó tȩne Arimatea be whi̧kó Josep beterepó. A̧ta, mo whi̧ wisinaale naameyóló dua betepa, Judia hae kwiamó betó mole so whi̧ ha̧sókó fupa fo tokó̧ló taleyó̧póló sóró beteró betere whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ai sekȩ́néta, mo whi̧né dere alaró mo tikiné dere alatamomó ama mo wisirapó kisipa mutumipó. A̧ta, Judia hae kwiamó tȩne Arimatea be huluamó walepó. Téru, a̧ Kótóné tȩteróló kaae tare ao̧mó mole ala wó̧póló kaae tawóló beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Atéró, kale whi̧ a̧ Yesuné tiki saaitapóló Pailat-paae wosene felepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Téró, kale whi̧né Yesuné tiki tokóló muló bituraalu, mo dȩi kutiné bopeyóló whi̧ beta̧kélé munénire kapo dolomó mulalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Atima sa̧a naai tukóló muló betere be dȩ dótóró sókó waai depa, o̧la o̧la donoróló mulatere be dȩmó ai alarape yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Atéró, mepaae Kaleli hae kwiamó Yesutamo wale sorape Josep-né Yesuné tiki mulaai fupa, neyóló mulatéró kelaairaalu, atima Josep sya felepó. ");
INSERT INTO ppo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Téró, atimané bepaae fóló kale felé kȩlaa wale fetera kaae o̧laró felé kȩlaa wale wel wȩitamo taleyóló munalepó. Téyaletei, kale yóló muló betere fo tikinépa, Talepaae moma yaai dapóló tukóló munale sukamó sa̧a nóló betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Fula kaae sere be dȩmó, mo hi̧kati kale sorapené felé kȩlaa wale o̧larape sisóló whi̧ mulale dou tópaae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Atéró atima fóló kelalemó, whi̧ dou tu̧ kinale kane fake biliyó faló beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Atépa, atima kane dolopaae buó deóló kelalemó, Tale Yesuné tiki munipó. ");
INSERT INTO ppo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Atépa, neya̧lerópóló atima kisipa teketu beteremó, mo kasa kasai kuti deró betere whi̧ tamo atima daae mole uté dȩró sókó wóló daalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Até deremó, kale sorape atima winé sinitu, kelepaa haepaae hemée deyóló betó molepó. Tépa, kale whi̧ tamoné atimapaae duraalu, “Suka̧le whi̧ douró betere tikimó, betere whi̧né noatepa keketé kutu bitu de? ");
INSERT INTO ppo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ti noatepae, a̧ aimó muni kepaayóló falapó. Take dia̧ Kaleli haemó bitu ama dia̧paae yale fo diaao̧ kisipa munié? ");
INSERT INTO ppo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Whi̧né Naalema mepaae dowi ala dere whi̧rapené naase tua̧paae mulaalopó. Atétepa, atimané a̧ filipaa ni tómó oleróló sukutepa, sore be dȩmó ti a̧ momó kepaayóló betaalopó,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Téró, atimané ama yale fo mopóló kisipa yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Atéró, atima whi̧ dou tópaae fi fesaae wóló atimané kelale alarape kale 11-whi̧raperó mepaae whi̧rapetamopaae yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ai sorapeta, Maktala sokó Mariakélé, Joanakélé, Jems-né hama Mariakélé, mepaae sorapekélé, atima fea betó mulu, kelale alarape ama aposel whi̧rapepaae yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Téyaletei, kale sorapené yale fo mo dapóló kisipa tirénipó. Ti noatepae, atimané kapala fo detere nisi yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Téyaletei, Pita a̧ mo hapale sururu yóló fóló, whi̧ dou tómó sókó felepó. Atéró a̧ dou dolopaae fóló kelalemó, ama tiki bopeyóló mulale dȩi linen kuti maaté dȩmó mupa kelalepó. Atépa a̧ momó bepaae fesaae furaalu, i noa ala yalerópóló kisipa tekété fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Atéyale sukamótóró atimakó whi̧ tamo Emeas bepaae faai tu̧ tua̧mó fu betalepó. Ai Emeas be taaróló Jerusalem be huluapaae fole da̧leta, 11 kilomitapó. ");
INSERT INTO ppo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Atimaamo tu̧mó fu bituraalu, kale yale alarape fea su̧raté fu beterepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Atimaamo até deté fu betepa, Yesu tu̧ tua̧mó sókó wóló, atima fea beta̧mó fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Até yaletei, atimaamoné Yesupóló kisipa yao̧sóró, me o̧lané atimaamoné kele seraaralepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Atéró fu bitu, Yesuné atimaamopaae woseturaalu, “Diaamo ai-a noa fo deté fu bitu de?” yalepó. Ti fo depa, atimaamo fu betaletei, kelepaa hu̧mula yóló kei̧yóló daalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Atimaamo fu betere me whi̧ Kliopas-né a̧paae duraalu, “I be dȩmó yale alarape so whi̧ feané kisiparapa, ya̧ta Jerusalem be huluapaae wale whi̧é?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ai fo depa ama a̧paae woseturaalu, “Noa alamó de?” yalepó. Ti fo depa atimaamoné duraalu, “Nasaret be hulua whi̧kó Yesupaae erale alamó dapó. Ti noatepae, a̧ta Kótóné ko̧ló whi̧ bitu, ama dere foró dere alatamo Kótóné kele tómókélé, so whi̧ feané kele tómókélé, mo doasi fotoko̧tamo du betalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Atéró so whi̧mó momaratere topo whi̧raperó da̧ tȩteróló kaae tare whi̧rapetamoné a̧ sukó̧póló dae yóló, doasi Gavman whi̧rapené naase tua̧paae mulalepó. Atétepa, atimané a̧ filipaa ni tómó sinó̧póló oleralepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Téyaletei, Israel fake so whi̧ dupuróló tao saaire whi̧póló kisipa mualepó. Ai maaté mei, ai ala yóló betepa be dȩ tamo kemeyóló, soreratere be dȩ ti mió i ape. ");
INSERT INTO ppo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ai fotei me ipó. Da̧ beta̧mó kotere sorape sore mo hi̧kati kale whi̧ dou tópaae fóló, mepaae kelale alarape depa wosetu da̧ kilita yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kale sorape fóló kelalemó ama tiki munipa, ensel-rapené Yesu kepaayóló beterapóló atimapaae yale fo fea da̧paae ene walepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Téró, da̧né fulumu whi̧rape atimakélé fóló kelalemó, kale sorapené ene wale ala motóró epa kelalepó. Téyaletei, atimané a̧ beta̧ kilinipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ama atimapaae duraalu, “Diaamota, take Kótóné ama ko̧ló whi̧rapené deté wale fo wosóló kisipani, ketei kaae kisipa tiki okokoru kutiri hapólu ai ererapó. ");
INSERT INTO ppo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kótóné so whi̧ tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Keriso a̧ doasi doi muaaire ala tua̧paae sókó faairaalu, folosóró ai sekȩi alarape salepó. Ai alata ha̧sókó faalomei, mo yaalopó ere fo dokonóturaalu yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mo take Moses-né asȩre fomó kaae sóró wóló, Kótóné ko̧ló whi̧rape feanékélé asȩre fo beteta, ȩmótóró erapóló amatei ha̧kearóló yó malepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Atimaamo fole bepaae felekemó sókó faai, tu̧ aupalomó fu betalepó. Téyaletei Yesu a̧ta, ai be hulua boseneyóló saletópaae faai fole ao̧ yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Atéró a̧ fupatei, kale whi̧ tamoné a̧ kei̧róló duraalu, “Felekemó be diki yaai dapa, da̧ imó fiyaalopa siépe,” Depa atima fea fiyaai felepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Atéró, a̧ atimaamotamo o̧la naairaalu, o̧la nokole ni fake tómó beterepó. Atéró bitu, ama bred o bula beta̧ tao sóró Alima Kótópaae mo kée yóló terekeyóló nó̧póló sóró malepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Téró, atimaamoné kele seraaretei fisa̧ae furaalu, kale sekȩ́ airapóló diriyóló kisipa yalepó. Téyaletamo atimaamoné kele a̧linameróló a̧ aluyó deyalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tétepa, atimaamosisitei duraalu, “Da̧ tu̧mó wouraalu, asȩmó ere fo da̧mopaae yó matepa, wosóló hosaamó si kaae dukuraalu mo feléné suka̧lepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Atétepa, mo ai fapotóró atimaamo Jerusalem be huluapaae momó fesaae felepó. Téyalemó, mepaae 11- aposel whi̧raperó atimatamo betere so whi̧rapetamo fea beta̧paae touró betepa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Atéru, atimané kale whi̧ tamopaae duraalu, “Ai mo dapó. Tale kepaayóló furaalu, Saimon beterepaae wapa ama mo kelalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Téró, kale whi̧ tamo tu̧ tua̧mó wou bitu yale alaró bred o bula tekeyóló atimaamo matepa, a̧ kisipa yale alatamo atimapaae yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Atéró, ai fo du betepa Yesu atima betó mole tua̧mó sókó wóló atimapaae duraalu, “Hosaa muni deyóló mo dua betere ala dia̧ tua̧mó muló̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Atei fo deremó, atima kisipané kepené dere nisi yóló kilita sókó furaalu, winé sinalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Atétepa, ama atimapaae duraalu, “Dia̧ wituraalu kisipa tamo muóló, hosaa noatepa wȩitu bitu de? ");
INSERT INTO ppo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ȩtóró mo hi̧tipa, ya̧lo naaseró hótamo diaao̧ kelae. Ti noatepae, kepeta miró diritamo bunipa, ȩ ai ala erémóló olaa yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ama ai fo yóló kemetepa, atimapaae ama naaseró hótamo yó melalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Téyaletei, atétere ala kilituraalu, hȩkesetere alaró, siratere alatamo atima tua̧mó mualetei, a̧ta Yesupóló kisipa tirénipó. Atétepa atimapaae woseturaalu, “Dia̧ imó bitu, naaitere o̧lakó mule?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Tétepa, atimané simó biliyale ya kwia a̧ matepa tao sóró, atimané kaae tapa nalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Atéró ama atimapaae duraalu, “Moses-né asȩre fokélé, Kótóné ko̧ló whi̧rapené ere fokélé, Sam buk-mókélé, ȩmótóró kisipa mutu ere fo fea dokonóturaalu mo eraalopóló ȩ dia̧tamo beta̧mó bitu ai yale ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kótóné asȩmó ere fo fea kisipa yó̧póló, ama atima kisipa wisi mulalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Atéró ama atimapaae duraalu, “Kale asȩmó ere fo i ape. Kótóné ama so whi̧ fea tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Kerisota, doakale sekȩi alaró susupui alatamo sóró mo ti sinaalotei, tamo be dȩ kemeyóló sore be dȩmó a̧ momó kepaayaalopó. ");
INSERT INTO ppo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jerusalem be huluamó kaae sóró hae kwia feamó betó mole so whi̧paae ya̧lo doimó i fo yó maté kwȩyaalopó. Diaao̧ dere dowi ala taaróló kisipa feteyóló wapa, ti diaao̧ dowi ala kwia ya̧lo ha̧le kemeraalopó. ");
INSERT INTO ppo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","I alarape depa kelalepóló so whi̧paae yó melaaire whi̧rapeta, ti dia̧tóró ai ape. ");
INSERT INTO ppo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Take ya̧lo Ayané dia̧ melaalopóló mulale o̧la ya̧lo dia̧paae dotonaai kisipa mutapó. Téyaalopa, dia̧ ai be huluamó bitiré fóló, mo óté taoró mole doasi fotoko̧né dia̧ kuti kaae bukura̧le dorowó̧póló, kaae tawae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Téró atima wó̧póló, a̧pi folosóró Betani be huluapaae felepó. Téró, ama naase horóló fonétei atima wisiralepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Atéró, atima wisiratere fo du betepatei taaróló, Alimané a̧ hepen-paae dapesó holalepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Téró, atima bukutiri tea̧ró bitu, Doa Tale-ó, yóló ama doi sóró horaté hȩkesetamo Jerusalem be huluapaae momó fesaae felepó. ");
INSERT INTO ppo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Atéró, atima momatere bemó bitu, Kótóné doi hale sóró horatere ala suka fea deté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mo take o̧la o̧la fea keké nale alimó, kale fo ha̧le bitipakalepó. Ai fota, Kótó a̧tamo beta̧mó bitipakalepó. Ai fo mo Kótó a̧tórótipó. ");
INSERT INTO ppo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ai kale fota, mo take keké nale alimótei, Kótótamo beta̧mó bitipakalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Aleyóló muló betere o̧la o̧la mo fea Kótóné a̧paae naao aleyae depa, amatóró kaarélipakalepó. Ere ó mole o̧la o̧la fea ha̧le kaani, amatóró kaaró beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A̧ tua̧mó betere bete molepó. Ai betere betené so whi̧ fea dȩmó beteró̧póló, dȩrótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ai dȩné diliki tua̧paae dȩrótu beteretei, dilikiné sukó̧ faróló alurótimipó. ");
INSERT INTO ppo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kótóné beta̧ whi̧ dotonatepa walepó. Ai whi̧né ama doita, Jon-pó. ");
INSERT INTO ppo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jon a̧ waleteita, so whi̧ feané ai dȩtere kilituraalu a̧paae kisipa tiróló beteró̧póló, kale dȩtere bete i ape yóló ha̧kearóló yó melaai walepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ai dȩterené beteta Jon a̧ meitei, so whi̧ feapaae dȩtere bete ai ape yóló, yó melaai walepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","I haemó betó mole so whi̧ feapaae dȩrótu betere mo dȩ bete a̧ i haepaae sókó waairaalu, teó wou betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A̧ i haemó betóo, i haeró yó mole o̧la o̧latamo Kótóné a̧paae aleyae depa, amatóró kaaróo epatei i haemó betó mole so whi̧né kilitu, a̧ etei kaae Talepóló kisipanipó. ");
INSERT INTO ppo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Atéró, a̧ ama be whi̧ so whi̧ betere turuku bepaae waletei, atimané a̧ kale whi̧póló wisiyóló dape sere ala inipó. ");
INSERT INTO ppo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tépatei, mepaae so whi̧ dené Yesu dape sóo, a̧ etei kaae whi̧póló ama yó matere fo wosóló, a̧paae tuȩ́ tiki tiróo, yale so whi̧ta, Kótóné mo ama naale senaaletóró beteró̧póló, sóró beteralepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ai naale senaaleta, mo so whi̧né naale senaale detere kaae ó whi̧né tó tiki fotoko̧né ó so omané ama hȩkesere alanékélé mei, Kótónétóró atima deyóló beteró beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Téró, kale fo mo whi̧ alée fóló, da̧ tua̧mó kapala kuti be tȩyóló bitu dere kaae asiri betalepó. Atépa, a̧ tua̧mó ere ala wisinaale da̧né kelalepó. Ai ere ala wisinaaleta, Alima Kótóné dotonale mo beta̧ betere naale tua̧mó fa̧anapó. Ai sekȩ́ a̧ tua̧móta, ko̧letu hamokoróló ha̧le tao sere alaró mo fotamo turó bulapó. ");
INSERT INTO ppo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon-né ai sekȩ́mó kisipa mutu fo fakeyóló duraalu, “Take ya̧lo dia̧paae noa fo yaleé? ‘Nalo ya̧lo ki̧lipaae waaire whi̧ta ȩ kaae mei, ȩ ya̧lo haené deyaaipa, a̧ mo taketi betóo, ȩkélé tȩteróló bosene fóo, ere doa sekȩ́ whi̧ waalopóló bope du betaletei a̧tóró ai ape,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ama ko̧lené sukutu, hamokoróló ha̧le tao sere ala wisi a̧ tua̧mó fa̧anu, wȩi kaae feleyóló wapa da̧né mo dekéró su betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ti noatepae, Kótóné kale tukóló muló betere forapeta, Moses-paae matepa, amamo so whi̧paae meló beterapó. Téyaletei, ko̧lené sukutu hamokoróló ha̧le tao sere alaró mo alatamota, ti Kótóné Yesu Kerisopaae matepa, amamo da̧paae malepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Whi̧ mo beta̧né Kótó kolókélé initei, alimané hosaa tua̧mó betóló wale Naalené amatóró, Alima etei kaae ala ere Tale beterapóló, da̧paae ha̧kearóló yó malepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Atéró etéyalepó. Jerusalem bemó betó mole Juda topo whi̧rapené dotonale momaratere whi̧raperó Lipai fake whi̧rapetamo Jon beterepaae fóló a̧paae, “Ya̧ deé?” yóló wosalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Atétepa, Jon-né atimapaae tokó̧ melaaire fo hiréni, a̧ etei kaae whi̧póló ha̧kearóló i fo yalepó. “Kótóné so whi̧ fea tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Keriso ȩ meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ai fo depa atimané a̧paae woseturaalu, “Ti ya̧ Elaijapé deé?” depa, ama du meipó. Tétepa atimané du, “Ti ya̧ta, take asȩmó ere foné waalopóló bope du betale Kótóné ko̧ló whi̧é?” depa, ama duraalu, “Ai whi̧kélé ȩ meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tétepa, mo ti kemeróló atimané a̧paae duraalu, “Naao ya̧ depó dute? Da̧ dotȩyale whi̧rapepaae ene faaipa, ya̧ etei kaae whi̧póló da̧paae ha̧kearóló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ai fo depa, ama atimapaae tokó̧ matere alata, mo take betale Kótóné ko̧ló whi̧ Aisaiané asȩre fo yó mótu duraalu, “Whi̧kélé bitini, ha̧le kópu ka̧ae fi tikimó wóló daalu fo fakeyóló, ‘Tale waaire tu̧ donoyóló aleyae,’ fo maaté ene wale whi̧ta, ti ȩ i ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Atétepa, kale mepaae dotonatepa wale Farisi whi̧rapené a̧paae duraalu, “Ya̧ta, so whi̧ fea tȩteróló kaae tanó̧póló, Kótóné sóró beteró betere whi̧ Keriso ó Ilaija ó Kótóné ko̧ló whi̧ beta̧kélé meipa, ti so whi̧ naao noatepa wȩi tópurótu bitu de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tétepa, Jon-né atimapaae tokó̧ mótu duraalu, “Ya̧lota, dia̧ wȩi maaté tópurótu beteretei, whi̧ beta̧ dia̧ tua̧mó ai daaletei diaao̧ kisipanipó. ");
INSERT INTO ppo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ti ai sekȩ́ta, ȩ wale ki̧lipaae waalopóló bopetu betale whi̧pó. A̧ta, mo doa sekȩ́ whi̧ betepa, ȩ naale ketei kaae, a̧ ao̧mó betereteiné ama ho̧leke bené képi ya̧lo teraanénipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ai alarape du betaleteita, kale Jordan wȩi tȩ utéró tȩne Betani bemó du betalepó. Ai beta, Jon-né so whi̧ fea wȩi tópurótu betale tikimó tȩnapó. ");
INSERT INTO ppo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Be dȩyó hotopa, ai alarape yale ki̧lipaae etéyalepó. Yesu a̧ Jon beterepaae wou betepa kolóló, Jon-né atimapaae duraalu, “I hae kwia feamó betó mole so whi̧né dowi ala tokó̧ló aluraaire Kótóné ama Sipsip hupu male ai walapa kelae! ");
INSERT INTO ppo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ȩkélé deyaaipa, mo taketi betere doa sekȩ́ whi̧ ya̧lo ki̧lipaae waalopóló dia̧paae bopetu betale whi̧ta, a̧ ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ya̧lokélé a̧ wisiyóló tuȩ́nitei, ȩ wale beteta, ti Israel fake so whi̧né a̧ tuȩ́ yó̧póló ha̧kearóturaalu, ya̧lo wȩi tópuratere ala maaté yaai walepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Atéró, Jon-né ama mo kelale ala so whi̧paae ha̧kearóló yó mótu duraalu, “Kótóné ama Dȩi Kepe Wisi hepen be taaróló, dorowóló ba ho̧kósere kaae ama tikimó betepa ya̧lo kelené mo kelalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ya̧lokélé a̧ tuȩ́ wua̧ meitei, so whi̧ wȩi tópura̧le fae yóló ȩ dotȩyale sekȩ́né amatóró ȩpaae etei fo yalepó. ‘Dȩi Kepe Wisi biti̧ dorowale whi̧né amata, dia̧ fea Dȩi Kepe Wisitamo wȩi tópuraalo ai ape,’” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Atéró Jon-né duraalu, “Ya̧lo kelené mo kelale alatóró dia̧paae i dapa wosae. Kótóné Naalemata me kaae mei, a̧tóró ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Atéró, fiyóló be dȩtepa Jon a̧ ama yó matere whi̧rapekó tamo whi̧ atima fea a̧ daatua dere tikimó momó fóló daalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Atéró daalemó, Yesu a̧ metikipaae faai fupa kolóló Jon-né duraalu, “Kótóné ama kale Sipsip hupu male ai fulapa kelae!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jon-né ai fo depa wosóló, ama yó matere whi̧ tamo Yesu fimó, nalo sya felepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Atétepa, Yesu a̧ fetée daaróló kelalemó, whi̧ tamoné a̧ sya wou betepa, atimaamopaae woseturaalu, “Diaamo noa kekete?” depa atimaamoné duraalu, “Rabai,” ai fo feteyóló “yó matere whi̧-ó, ya̧ betere tiki momó ere?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Atéró, ama atimaamopaae duraalu, “Ape. Wapata, ti diaamoné kelaalopó,” yalepó. Tétepa atimaamo fóló, a̧ betere be kolóló, be dȩ beta̧ a̧tamo aimó betalepó. Até dere alata, ti dou̧ sukakelemó du betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Atéró, kale Jon-né dere fo wosóló, Yesu sya fele whi̧ tamo meta, Saimon Pitané noma Andrupó. ");
INSERT INTO ppo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andru a̧ metikipaae feni, noma Saimon-pi keka̧lemó keletepa duraalu, “Mesaia da̧né kelalepó,” yalepó. Ai fo bete feteyóló so whi̧ fea tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Kerisopó. ");
INSERT INTO ppo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Atéró, Andruné noma Saimon Yesu beterepaae dapesó wóló betepa, Yesuné Saimon kolóló a̧paae duraalu, “Ya̧ta, Jon-né naalema Saimon-pó. Mió naao kisi doita, Sipas mulatapó,” yalepó. (Sipas doi feteyóló Pitapó.) ");
INSERT INTO ppo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ai ala du beteró hi̧ka be dȩtepa, Yesu a̧ betere tiki taaróló, Kalelipaae faai kisipa mualepó. Atéró fóló, Filip betepa kolóló a̧paae duraalu, “Filip-ó, ya̧ ȩ sya ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipta, Andruró noma Pitatamo betere Betsaida be hulua whi̧kópó. ");
INSERT INTO ppo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Téró Filip-né Nataniel keka̧lemó, hokolaa depa a̧paae duraalu, “Mo take Moses-né asȩre Kótóné tukóló muló betere foró mepaae ko̧ló whi̧rapené asȩre fotamoné waalopóló bopetu betale whi̧ da̧né kelalepó. A̧ta, Nasaret be whi̧kó Josep-né naalema Yesupó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ai fo depa, Nataniel-né Filip-paae duraalu, “Ai Nasaret be huluamó noa o̧la wisikó sókó waalopóló de?” depa, Filip-né duraalu, “Wisirapa, naao kelaai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tétepa, kale whi̧ Nataniel Yesu a̧ beterepaae wou betepa kolóló, a̧paae duraalu, “Israel fake whi̧kó whi̧ wisinaale ai walapa kelae! A̧ tua̧móta, kapala ala mo sawakélé munipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ai fo depa, Nataniel-né a̧paae duraalu, “Naao ȩ netéró tuȩ́ yaleé?” depa, Yesuné duraalu, “Filip-né ya̧ ape yaaipatei, nose sirimó betepa ya̧ ya̧lo kelalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tétepa, Nataniel-né a̧paae ha̧kearóló duraalu, “Yó matere whi̧-ó, ya̧ta mo Kótóné Naalemapó. Israel fake so whi̧ tȩteróló kaae tare doasi topo whi̧ta, me kae mei, ya̧tóróti ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ti fo depa, Yesuné duraalu, “Mió naao ȩpaae kisipa tiki tiratere beteta, ya̧ nose soumó betepa ya̧lo kelalepó dere fo woseturaalu dapó. Aita wisiretei, take nalopaae ti mió i keletere alakélé fea bosenóló, mo doasi alarape eratepa kelaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ai fotamo touróló, ama me i fo yalepó. “Ya̧lo dia̧paae mo i dere ape. Hepen be tu̧ tukwȩ fóló mupa, Kótóné ama ensel-rape kale Whi̧né Naalemané tikimó daayóló, ópaae hutua ipaae durua du betepa, diaao̧ kelaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Atéró ai alarape yóló kemetepa, be dȩ tamo beteró, sore be dȩmó, Kaleli hae kwiamó tȩne Kana be huluamó whi̧ beta̧ so dokoturaalu detere o̧la naai ape depa, Yesu a̧kélé, hama Mariakélé, ama yó matere whi̧rapekélé, atima fea fóló so dokotere tua̧mó beterepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Atéró, ai o̧la detere sukamó naai donoróló mulale wain wȩi fea nóló kemetepa, hamané a̧paae duraalu, “Atimané wain wȩi fea kemeyalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ai fo depa, Yesuné duraalu, “Ti so wisi-ó, aita atimané yaaire alapa, naao ȩpaae atima tao sae dere noatepa de? Ya̧lo tukóló muló betere ala yaaire be dȩta teórapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ai fo depa, ama hamané kale o̧la detere ala kaae tare doasiné kutó diratere whi̧rapepaae duraalu, “Ama dia̧paae noa alakó yae depa, ti sya fóló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kale Juda fake atimané mara mole ala sya furaalu, naase fokotua yaai dapóló, kanené aleale apo miró wutirape wȩi maanipa, felekemó daalótua erepó. Ai wutirapemó wȩi maatere da̧leta, mepaae 75 lita-rape, mepaae wuti ti 115 lita-rape su̧pó. ");
INSERT INTO ppo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Atéró, Yesuné ai kale kutó diratere whi̧rapepaae duraalu, “Ai wutirape fea wȩi nóló fa̧anae,” depa, mo ti bokóta eralepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Atéró, ama atimapaae duraalu, “Ai belere wȩirapekó mepaae tepeyóló o̧la detere ala tȩteróló kaae tare doasipaae male fae,” depa male felepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tétepa, kale mo wȩinétei alée fele wain wȩi kale o̧la detere ala tȩteróló kaae tare whi̧né nalemó, mo wain felétóró yalepó. Ai sekȩ́né ai wain wȩi sale tiki a̧ tuȩ́nitei, kale kutó diratere whi̧rapené maaté mo wȩi sóró tepeyale ala kisipa ipakalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Téró, kale o̧la detere ala kaae tare doasiné so dokore whi̧paae ape yóló, tu dȩpaae dapesó fóló duraalu, “Whi̧rape feané i ala dua dapó. Folosóró wisi wain wȩipi nó̧póló melóo, nalo mo sawa felétere wain wȩi melóo, dua dapó. Tépatei, wisi wain wȩi mulóló, nalo noatepa sóró waleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesuné me ala yaairemó erale kelemei alata, Kaleli hae kwiamó tȩne Kana be huluamó folosóró kaae suraalu yalepó. Atéró yale alané ama ere ala wisinaale ha̧kearatepa, ama yó matere whi̧rapené kilituraalu, a̧paae tuȩ́ tiki tiralepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ai alarape fea kemetepa, Yesu a̧kélé, ama hamakélé, nomarapekélé, ama yó matere whi̧rapekélé, atima fea ai Kana be taaróló, Kapeneam be huluapaae derepelepó. Aimó atima mepaae be dȩrape betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Atéró, ai alarape yóló kemetepa, kale bosenóló fele be dȩ felekemó sókó waai deremó, Yesu a̧ Jerusalem be huluapaae holalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Atéró holóló bituraalu, a̧ moma dere be bopére tipi tua̧paae sókó holalemó, whi̧rape mo feané bulmakau hupurapekélé, sipsip hupurapekélé, ba sukusirapekélé, mepaae whi̧rape atima ni fake tómó betó mulu, kae kae fakené sóró wale moni-kélé duputamo yóló, u mótu i mótu du betepa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Até du betepa, kale bulmakau hupuró sipsip hupurapetamo belapaae fó̧póló, Yesuné aimó mole halika tikiné fokosó sóró ho̧konóo, ni fake fetée deróló fesekée falóo yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Até du beteró, kale ba sukusirape dotonóló moni su betere whi̧rapepaae duraalu, “Ya̧lo Ayapaae maaté moma yaai tȩne betei, diaao̧ noatepa o̧la o̧la dotonatere tiki ao̧rótu bitu de? Até dere alané ya̧lo Ayané be doratapa, diaao̧ ai o̧larape fea sóró fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ai ala ama yó matere whi̧rapené kilitu, kale asȩmó i ere fo tuȩ́ mualepó. “Kótóné ama be dorao̧sóró wisiyóló kaae tawaaire ketekȩta, ȩ tua̧mó si kaae daalopó,” erapó. ");
INSERT INTO ppo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Téró, kale Juda topo whi̧rapené a̧paae fo fotoko̧iné duraalu, “Naao atei kaae ala yó̧póló, ya̧ né sóró beteraleé? Ya̧ Talené sóró beteró betere whi̧póló kisipa yó̧póló, naao da̧paae noa kelemei alakó eraaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ai fo depa, Yesuné atimapaae tokó̧ mótu duraalu. “I momatere be diaao̧ fisikó mulae. Tétepa, ya̧lo sore be dȩmótóró momó tȩyóló kemeraalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ai fo depa, atimané a̧paae duraalu, “Take ai be tȩtu betepa, 46 ba forape kemeyalepó. Téyale betei, naao mió be dȩ soremó momó tȩyaalopó dere fota, netéró tȩyaai de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yesuné ai yale fota, mo moma dere bemó initei, ama tikimó kisipa muturaalu yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Take a̧ sukó̧ló momó kepaayóló betere ki̧lipaae ama yó matere whi̧rapené ama yale fo kisipa muni walepó. Yesuné i yale fokélé kale asȩmó ere fotóró mo dokonalepóló, atimané a̧paae tuȩ́ tiki tiralepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Téró, boseneyóló fele be dȩ sókó wapa o̧la detere fulamó, Yesu a̧ Jerusalem bemó beterepó. Aimó bituraalu, Kótóné eratapó kisipa yó̧póló kelemei alarape eratepa so whi̧ mo feané a̧paae kisipa tiralepó. ");
INSERT INTO ppo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Téyaletei, so whi̧ feané hosaa tua̧mó mole alarape ama kisiparuraalu, atimané du betere fo mo dapóló wosóló, ao̧mó bitinipó. ");
INSERT INTO ppo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ti noatepae, so whi̧ feané mole tuȩ́ tikiró dere alatamo kelaairetei ko̧ló ko̧lópakó, mené a̧ yó melaaié? ");
INSERT INTO ppo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Téró Farisi whi̧kó Nikodimas beterepó. A̧ta, Juda fake so whi̧ tȩteróló kaae tare topo whi̧rapetamo beta̧mó kutó ditere doasi doi mole whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ai whi̧ a̧ dilikitamo Yesu beterepaae wóló duraalu, “Yó matere whi̧-ó, ya̧ta Kótóné dotonatepa wale yó matere whi̧póló da̧né kisiparapó. Ti noatepae, Kótó ya̧tamo bitua̧meisóró, ti mepaae whi̧né enénire etei kaae doasi kelemei alarape erótu bitua̧meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ai fo depa, Yesuné a̧paae ha̧kearóló duraalu, “Ya̧lo ya̧paae mo i dere ape. Whi̧ mo beta̧kélé hamané a̧ detu yale kaae momó denitepa, ti Kótóné tȩteróló kaae tare ala mo kelenénipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Yesuné ai fo depa, Nikodimas-né a̧paae duraalu, “Disiyale whi̧ haené depe tua̧paae netéró biti̧ doropóló, momó deyaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tétepa Yesuné a̧paae duraalu, “Ya̧lo ya̧paae mo i dapa wosae. Mo beta̧ whi̧kélé wȩiró Kepe Wisitamoné deyóló muló bitinipa, ti Kótóné tȩteróló kaae tare ala tua̧mó sókó fóló betenénipó. ");
INSERT INTO ppo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mo whi̧né detereteita, ti whi̧ tiki daaitóró deyóo, Dȩi Kepené deteretei, ti mo Kepe tiki daaitóró deyóo, dua dapó. ");
INSERT INTO ppo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Take ya̧lo ya̧paae momó denérapó yale fomó ya̧ kilita sókó fao̧se. ");
INSERT INTO ppo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Besȩ́ a̧ faaire tikipaae furaalu, ha̧le hu dere maaté wosetua dapó. Téteretei, waleró foleteitamo diaao̧ kilitimipó. Kale Kepe Wisiné deyóló beterótu betere so whi̧ feata, ai ala kaae du beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ai fo depa, Nikodimas-né a̧paae duraalu, “Ai ala netéró yaalorópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tétepa Yesuné a̧paae duraalu, “Ya̧ta Israel fake so whi̧ yó matere doasi doi mole whi̧tei, i dere alarape diriyóló tuȩ́ni airapó. ");
INSERT INTO ppo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ya̧lo ya̧paae mo i dere ape. Da̧né du betere fota, mo tuȩ́re fotóró yóo, mo kelale alatóró yó melóo, du betepatei dia̧né mo dapóló wosóló, kisipa tirénitere noatepa de? ");
INSERT INTO ppo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ya̧lo dia̧paae i haemó du betere alarape bope yóló yaletei, dia̧né tuȩ́ tiki tirótimipó. Ya̧lotamo ó hepen bemó mole alarape bope yóló enalemó, ti dia̧ mo kisipa tiraalomeipó. ");
INSERT INTO ppo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Whi̧ mo beta̧kélé hepen bepaae fenitei, hepen be taaróló, i haepaae kapala asiri dorowale Whi̧né Naalemané ama beta̧ kisiparapó. ");
INSERT INTO ppo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mo take Moses-né ha̧le kópu ka̧ae fi tikimó kapa kwiané wuli aleyóló ni dée daaróló, sikipaae horóló oleralepó. Atéyale kaae, kale Whi̧né Naalemakélé, mepaae whi̧né atéró sikipaae só horóló oleraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ai fota ha̧le ini, a̧paae kisipa tiki tiratere so whi̧ fea mo ti betere bete saalopóló kisipa mutu yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ti noatepae, Kótóné i haemó betó mole so whi̧ ko̧lené sinóló yaala sókó furaalu, ama mo beta̧ betere Naaletei i haepaae wó̧póló dotonalepó. Mepaae so whi̧ dené ai dotonó betere Naalepaae kisipa tiró betepa, ti atétere so whi̧ aluni, mo ti betó tawaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ti noatepa meipó. Kótóné ama Naalema i haepaae wó̧póló dotȩyale beteta, i haemó betó mole so whi̧tamo fo tokó̧tamo yóló só deró̧póló initei, so whi̧ fea aluyao̧sóró, ama yale alané tao só̧póló yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mepaae so whi̧ detamo a̧paae kisipa tiró betepa, ti ai so whi̧tamo Kótóné fo tokó̧tamo yóló só deranénipó. Tépatei, Kótóné ama mo beta̧ betere Naale a̧tóró hi̧tipóló a̧paae kisipa tiki tirénire so whi̧ta, fo tokó̧tamo yóló só deró beterapó. Ti noatepae, ai so whi̧ atima Kótóné mo beta̧ betere Naalepaae kisipa tiki tiró bitinireteinépó. ");
INSERT INTO ppo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kótóné i haemó betó mole so whi̧tamo fo tokó̧ló só deratere bete i ape. Kale dȩtere i haepaae wóló betepatei, dilikipaae hȩkese duraalu, atima dowi ala ha̧le du betereteiné witepa, ai dȩtere hȩkeseyóló wómipó. ");
INSERT INTO ppo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mepaae so whi̧ detamo diliki tua̧mó bituraalu, dowi ala ha̧le yó tareteiné dȩ tua̧paae waalo hó̧róló bóe du beterapó. Ti noatepae, atimané dowi ala dȩné ha̧keamó mulatepa kelao̧sóró wituraalupó. ");
INSERT INTO ppo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tépatei, kale mo fo wosóló, donoi ala du betere so whi̧ta, ti dȩ tua̧paae wou beterapó. Ti noatepae, atimané du betere alarape Kótóné fotoko̧ratepa yalepóló so whi̧ feané ha̧keamó koló̧póló du beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Téró, atima ai fo yóló kemetepa, Yesu a̧ ama yó matere whi̧rapetamo ai Judia hae kwiamó tȩ mole beleka̧atiki berapemó mepaae be dȩrape bitu, so whi̧ wȩi tópurótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Téró, Jon-nékélé Salim be hulua felekemó ere Aenon haemó beterepó. Aimó wȩi dekéró fu betereteiné so whi̧ fea wȩi tópuró̧póló, a̧ beterepaae wou betepa, ama atima tópurótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ai alarapeta Herot-né Jon a̧ dipula beteraaipa, ha̧le bituraalu du betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Atéyale sukamó, Kótóné keletómó wisirapó yó̧póló, naase fokotere alamó Juda fake whi̧kó beta̧né mepaae Jon-né yó matere whi̧rapetamo foné u só dera̧le i só dera̧le du betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Atéró, Jon-né yó matere whi̧rape a̧ beterepaae wóló duraalu, “Yó matere whi̧-ó, Jordan wȩi uté tȩró ya̧tamo bitu, naao da̧paae kale whi̧ ai ape yóló, yó male whi̧né so whi̧ fea wȩi tópurótu betepa, mo turó so whi̧ a̧ beterepaae fu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ai fo depa ama atimapaae duraalu, “Me whi̧né me alakó yó̧póló ó hepen bemó betere Kótóné menitepa, ti ama ko̧leaané me ala yaai dapóló, mo enénipó. ");
INSERT INTO ppo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ȩta, so whi̧ tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Keriso mei, a̧ wó̧póló tu̧ alera̧le wale whi̧póló, take ya̧lo dia̧paae yale fo diaao̧tei enérapó. ");
INSERT INTO ppo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Me whi̧né beta̧ so hȩkeseyóló dokotepa, ti ai ama sopó. Ai so dokaaire sekȩ́ ama fulumu whi̧né a̧ wó̧póló kaae tawóló beterapó. Téra̧lemó, kale so dokaaire whi̧ sókó wouraalu dere fo nakome wosetepa, a̧ doasi hai̧né suka̧alopó. Atére hai̧ta, mió ȩ tua̧mó mo fa̧ayóló mulapó. ");
INSERT INTO ppo_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ai so dokaaire whi̧né ama doita, suka fea sóró horaté fu betaalotei, ya̧lo doi beta̧ haepaae dua sókó deté doropó̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Mo ó taoró dorowale whi̧né i haemó yó mole o̧la o̧laró so whi̧ featamota, amatóró tȩteróló bosene falapó. I haemó betere whi̧né ti i haemó mole o̧la o̧lamó kisipa mutu, ama dere fokélé i haemó mole fotóró dua dapó. Tépatei, ó hepen bemó dorowale whi̧néta, fea ala ama tȩteróló bosene falapó. ");
INSERT INTO ppo_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ama kelale alaró wosale fotamo so whi̧paae yó mótu beteretei, beta̧ whi̧nékélé ama yó matere fo wosóló, mo dapóló a̧paae tuȩ́ tiki tirótimipó. ");
INSERT INTO ppo_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tépatei, mepaae so whi̧ de Kótóné ama fo wosóló, mo dapóló kisipa tiratepa, ti ai so whi̧né Kótó a̧ mo foné bete Talepó du beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kótóné ama dotonó betere whi̧néta, a̧paae yae dere fotóró yó mótu beterapó. Ti noatepae, Kótóné Dȩi Kepe a̧ tua̧mó mo turó fa̧aneteinépó. ");
INSERT INTO ppo_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Alimané Naalemapaae yaala sókó fóló muluraalu, fea ala ama tȩteróló kaae tanó̧póló, a̧paae malepó. ");
INSERT INTO ppo_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mepaae so whi̧ de Naalemapaae tuȩ́ tiki tiró betepa, ti atére so whi̧ aluni, mo ti betó tawaalo ai ape. Tépatei, mepaae a̧ hó̧rótu betere so whi̧ta, mo ti betó tare bete kelaalo meipó. Ai so whi̧tamo Kótóné doasi fopaae butere ala mulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesuné ama yó matere so whi̧ beteraairaalu, wȩi tópurótua dere so whi̧né Jon-né wȩi tópurale so whi̧ bosene falapó dere fo mepaae Farisi whi̧rapené wosalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Atéró, so whi̧ wȩi tópuratere ala Yesuné initei, ama yó matere whi̧rapené tópurótua yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ai dere fo mepaae whi̧né Yesu a̧paae ene wapa woseturaalu, a̧ Judia hae kwia taaróló, Kalelipaae momó fesaae felepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Téró, a̧ ama yó matere whi̧rape atima fea Kaleli haepaae faairaalu, Samaria hae tua̧mó tȩyóló fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Atéró, a̧ ai Samaria hae kwiamó tȩne Saika be huluamó sókó felepó. Ai Saika be hulua felekemó, Jekop-né naalema Josep-mó tekée male hae mulapó. ");
INSERT INTO ppo_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ai haemó Jekop-né duki̧yale wȩi naleta dere tiki erapó. Yesu a̧ doasi tu̧mó walené bé depa, ai wȩi belere tikimó sa̧a nóló beterepó. Até dere alata, o̧la nokole topo suka kele 12 kilok-mó yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Yesu aimó beteremó, beta̧ Samaria so a̧ wȩi naairaalu wapa, a̧paae duraalu, “Naao ai wȩikó ȩ maletamo melaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ai alata, Yesuné ama yó matere whi̧rape ai felekemó tȩne be huluapaae atima naaire o̧la dupune fimó du betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Atéró, kale soné a̧paae duraalu, “Ya̧ta Juda fake whi̧pa, ȩ Samaria sopaae wȩi netéró kema du de?” yalepó. Ama ai yale fota, Samaria fakeró Juda faketamo o̧la beta̧mó nokole ala ó, fo dere alakélé dumipóló kisipa mutu yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ai fo depa Yesuné kale sopaae duraalu, “Kótóné ya̧paae ha̧le matere o̧la naao kisipa yóo, ya̧tamo i fo du betere whi̧kélé kisipa yóo irutamo, naao a̧paae ai wȩi wosua̧sóró ti ama ya̧mó mo ti betó tare wȩi mólua̧pó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ai fo depa kale soné Yesupaae duraalu, “Doa whi̧-ó, i wȩita hae dolopaae maane doropóo, ya̧ wȩi naaire wutikélé tawóo inipa, mo ti betó tawaaire wȩi melaalopó dere-a, momó wapa nóló melaai de? ");
INSERT INTO ppo_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Da̧né mió i nuku betere wȩita, mo take da̧né noutere Jekop-né duki̧yóló, amakélé nukulé wóló, naalemarapenékélé, ama sipsip hupuró bulmakau hupurapetamonékélé, nuku bitipakalepó. Téyaletei naao ai dere fota, take Jekop-né yale ala naao tȩteróló bosene falapóló de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ai fo deremó, Yesuné a̧paae duraalu, “I wȩi nokole so ó whi̧ feata, nokole depa momó nale waalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Tépatei, mepaae so whi̧ de ya̧lo matere wȩi nukupa, momó nokole dere ala mo yaalo meipó. Ita, mo dapó. I haemó mo wȩi sókó horótu dere kaae, ya̧lo i matere mo ti betó tawaaire wȩi nokole so ó whi̧né tiki tua̧mó mo ti betere bete mulu, ha̧le só tawaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tétepa, kale soné a̧paae duraalu, “Doa whi̧-ó, ȩ wȩi nokole depa dekéró naleta dere hó̧rapa, naao ai melaalopó dere wȩi mo miótóró a̧lae!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ai fo depa, Yesuné kale sopaae duraalu, “Ya̧ momó waasepóló, naao whi̧ dape sene fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Ai fo depa, kale soné a̧paae duraalu, “Ȩta whi̧né dokonipó,” yalepó. Tétepa, Yesuné duraalu, “Whi̧né ya̧ dokonipó dere fota, mo dono deretei, naao ere ala ya̧lo ya̧paae ha̧kearóló i dere ape. Take aporó whi̧rapené ya̧ dokorapó. Tépatei, mió ya̧tamo ai betere whi̧ta, naao whi̧ meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tétepa kale soné duraalu, “Doa whi̧-ó, mió ya̧lo ya̧ kilitu, Kótóné ama fo eratere ko̧ló whi̧póló kisipa mutapó. ");
INSERT INTO ppo_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Take da̧né ayarape atimata, i daale hasi fosómó moma eneta du bitipakalepó. Téyaletei, Juda fake dia̧né da̧paae ho̧ko tikimó moma ini, Jerusalem bemó touróló Tale ao̧mó sukó̧ló bitu, moma yae du beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ai fo depa Yesuné a̧paae duraalu, “Ti so-ó, ya̧lo i dere fo wisiyóló wosóló kisipa tirae. Take waaire alimó Aya ao̧mó sukó̧ló bitu, ama doi sóró horatere alata, i daale hasi fosómó ó Jerusalem bemó maaté yaalo meipó. ");
INSERT INTO ppo_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria so whi̧ dia̧ta, diaao̧ tuȩ́ inire o̧la ao̧mó sukó̧ló bitu Talené doi sóró horótu beterapó. Tépatei, Juda fake so whi̧ da̧ta, mo ti betere Kótó tuȩ́reteiné a̧ ao̧mó sukó̧ló bitu, mo kée du beterapó. Ti noatepae, so whi̧ fea aluyao̧sóró tao sere alata, Juda fake tua̧mó kaaró beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Take waalopóló bope du betale be dȩ mió sókó wóló i mole ape. Mepaae whi̧ dené mo alaró ama Kepe betetamo a̧ tua̧mó fa̧anuraalu, Alima ao̧mó sukó̧ló bitu, ama doi sóró horótu betaalopó. Atei ala du betere so whi̧paae Kótóné ama hȩkesetu beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ti Kótó a̧ta, mo whi̧né tiki kaae daani, kepetóró betereteiné ama doi sóró horatere so whi̧né ti mo alaró kepe bete turótamoné sóró horótu betenérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tétepa, kale soné a̧paae duraalu, “I haemó betó mole so whi̧ fea tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Mesaia, me doi Keriso waalopó fota, ya̧lo kisiparapó. Ai sekȩ́ a̧ wouraaluta, fea ala ama da̧paae ha̧keamó yó melaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tétepa, Yesuné kale sopaae ha̧kearóló duraalu, “Mió ya̧tamo i fo du betere whi̧ta me kae mei, ȩtóró hi̧ti i ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Atimaamo ai fo du betepa, ama yó matere whi̧rape o̧la dupune fi fesaae wouraalu kelalemó, Yesu Samaria sotamo fo du betepa, atima kilita sókó felepó. Atétepa, atimakó beta̧ whi̧nékélé a̧paae ai sotamo noa ala yaai, ó noa fokó du bitu de? yóló, wosetere alakélé inipó. ");
INSERT INTO ppo_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Téró, kale soné ama wȩi wuti aimó mupatei taaróló, a̧ u be huluapaae felepó. Atéró fóló, ai be huluamó betó mole so whi̧paae duraalu, “Take ya̧lo yale alarape fea ȩpaae ha̧kearóló yó matere whi̧ tumó daalapa kelaai ape. A̧ta, Kótóné so whi̧ tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Keriso du yalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","31","Tétepa, ai be hulua so whi̧ atima Yesu beterepaae felepó. Atima a̧ beterepaae sókó waai teó wou betepa, ama yó matere whi̧rapené a̧paae duraalu, “Yó matere whi̧-ó, o̧lakó ya̧maletamo nukumié?” yóló sȩtu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tétepa, Yesuné atimapaae duraalu, “Nokole o̧lata ya̧lo i taretei, diaao̧ kisipanipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ai fo depa, ama yó matere whi̧rape atimasisi duraalu, “Mepaae whi̧né o̧lakó a̧mó mótu yalepó,” kisipa mualepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Atétepa, Yesuné atimapaae duraalu, “Ȩ dotȩyale whi̧né ama kisipa mole ala sya furaalu, ama kutó ya̧lo diraté fóló kemeratepa, ti aita ya̧lo nokole o̧latórótipó. ");
INSERT INTO ppo_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Diaao̧ etei fo dua dapó. Kutómó ere o̧la fea u̧lumé depa saaire wélié dou̧ró beta̧ ha̧le mulapó du beterapó. Tépatei, ya̧lo dia̧paae mo i dere ape. Diaao̧ kele fisa̧ae horóló, kutópaae kele kele yae! Ténalemó o̧la u̧lumépa, ti saaire alimó ai betere ape. ");
INSERT INTO ppo_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mió u̧lumére o̧la su betere whi̧né ama diale kutómó dupu so-ó, mo ti betere bete saaire so whi̧kélé mió o̧la kaae u̧lumépa sóo, du beterapó. Ama ai du betere alata ha̧le mei, o̧la wae biliyale whi̧ró sere whi̧tamo wusuró hȩkese yaairaalu dapó. ");
INSERT INTO ppo_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Me whi̧né o̧la wae biliyóo, me whi̧né ti u̧lumétepa sóo dere ala, i dere foné mo ha̧kearatapó. ");
INSERT INTO ppo_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mené diyale kutómótei u̧lumére o̧la sene fó̧póló, ya̧lo dia̧ i dotonatere ape. Mepaae whi̧rape doasi depe tukówei ala yóló diyale kutómó dia̧ta, o̧la maaté sirapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Téró, kale soné ama take bitu yale alarape fea Yesuné ha̧kearóló yó malepó, dere fo woseturaalu, ai haemó tȩne be huluamó betere Samaria so whi̧ fea a̧paae kisipa tiki tiralepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Atéró, ai Samaria so whi̧ fea Yesu beterepaae wóló, ya̧ da̧tamo imó betaalopa sae yóló sȩtu betalepó. Atétepa, be dȩ tamo a̧ atimatamo aimó betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tépa, Yesuné ama yó matere fo woseturaalu, mepaae folosóró tuȩ́ tiki tirale so whi̧tamo touróló mo turó so whi̧kélé a̧paae kisipa tiralepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Atéró, atimané kale sopaae duraalu, “Da̧né a̧paae tuȩ́ tiki tirale alata, naao yale fo wosóló maaté mei, ama yó matere fo da̧nétóró wosóló a̧paae tuȩ́ tiki tiralepó. Ti noatepae, a̧ta i hae kwia feamó betó mole so whi̧ aluyao̧sóró, tao saaire whi̧póló da̧né mo diriyóló kisiparapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Atéró, Yesu a̧ be dȩ tamo ai Samaria so whi̧tamo betóló ki̧lipaae, a̧ Kaleli hae kwiapaae felepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Taketi Yesuné amatei a̧mó kisipa mutu etei fo erapó. “Kótóné fo eratere ko̧ló whi̧ ama turuku be hulua so whi̧né ama doi sóró horanénipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Téró, Yesu a̧ u Kaleli hae kwiamó sókó felemó, Kaleli so whi̧né a̧ hȩkesetamo mo wisiyóló dape salepó. Ti noatepae, take Jerusalem bemó kale bosenóló fele be dȩmó, o̧la deyóló naaire sukamó atimakélé fea bitu, ama mepaae alarape eratepa kelaleteinépó. ");
INSERT INTO ppo_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Atéró, take Yesuné mo wȩitei, wain wȩi aleale Kaleli hae kwiamó tȩne Kana be huluapaae a̧ momó felepó. Ai bemó beteremó, ai Kaleli hae kwia tȩteróló kaae tare topo whi̧né sóró beteró betere whi̧né naalema Kapeneam bemó kisiné sukó̧ló mulapó dere fo wosalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yesu a̧ Judia hae kwia taaróló, Kaleli hae kwiamó wóló beterapó dere fo kale whi̧né wosóló, a̧ Yesu beterepaae wóló, ama naale mo felekemó suka̧ai du beterapa, “Naao wisiraai faaloé?,” yóló wosetu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ai fo depa, Yesuné a̧paae duraalu, “Me ala yaairemó eratere kelemei alaró mepaae sira yaaire alatamo eratepa maaté kolóló kisipa tiraai de? Dia̧ ai eratere kelemei alarape kilini depa, ti dia̧ kisipa mo tiraalomeipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tétepa, kale sóró beteró betere doasi whi̧né duraalu, “Doa whi̧-ó, ya̧lo naale sukao̧sóró miótitei da̧mo wusuró faalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ai fo depa, Yesuné a̧paae duraalu, “Naao naale sinaalomei, beterapa fae,” yalepó. Tétepa, kale whi̧ Yesuné dere fo wosóló, wisirapóló a̧ felepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Atéró, fiyóló hi̧ka a̧ tu̧ tua̧mó fu betalemó, ama kutó diratere whi̧rape tu̧mó hokolaa yóló, a̧paae duraalu, “Naao naale kisi wisiyóló beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ai fo depa, kale whi̧né atimapaae woseturaalu, “Noa sukakelemó ama tiki supu tikaleé?” depa, atimané duraalu, “Mo dótóró 1 kilok sukakelemó tukóló mo beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ai fo depa, kale naale alimané wosetu, Yesuné a̧paae naao naale suka̧alomeipó, yale sukakelemótóró ai wisi irapóló kisipa mualepó. Ai ala kilituraalu, ama soma atimaamokélé, ama naale senaalekélé fea Yesupaae kisipa tiralepó. ");
INSERT INTO ppo_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu a̧ Judia hae kwia taaróló, Kaleli hae kwiapaae wóló bitu, ai kelemei alata, tamo dakoróló eralepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Atéró, mepaae be dȩ beteró ki̧lipaae Juda fakené tukóló muló betere be dȩmó o̧la detepa, Yesu a̧kélé Jerusalem be huluapaae holalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ai Jerusalem be hulua bopére tipi tu̧ sereketa, sipsip hupurape fua wua dere tu̧pó doi mulapó. Ai tu̧ sereke felekemó, beta̧ wȩi ke belerapó. Hibru whi̧rapené du betere foné ai wȩi ke doi Betesatapó. Ai wȩi fókumó biti̧ta dere so whi̧ supu yao̧sóró, be beleka̧atiki aporó tȩóló bopéró beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ai tȩ mole bemó, mepaae kele dilikire so whi̧kélé, tiki da̧amure so whi̧kélé, hó naase dore so whi̧kélé, mepaae kae kae kisi bete daale so whi̧kélé, mo fea ai wȩi ke bopéróló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ai hó naase dore so whi̧ betó mole kuamó, kisi ha̧le daapatei, 38 ba fo kemere whi̧ beta̧ fiyó molepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Atéró fiyó mupa kolóló, Yesuné duraalu, “I whi̧-a, ere alaé?” depa, whi̧ mené duraalu, “A̧ta, taketitei ama ere ala ai ape,” yalepó. Tétepa, Yesuné kale whi̧paae woseturaalu, “Ya̧ mo wisiyóló, betenée yóló kisipa mute?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ai fo depa, kale tiki da̧amui whi̧né duraalu, “Doa whi̧-ó, ai wȩi asya hotereteiné ȩ wisiró̧póló, né beleyóló ai wȩi felekemó betera̧le derepaaié? Ȩkélé dua fu betepatei, atima folosóró furaalu ȩ taaróló fua dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ai fo depa Yesuné duraalu, “Ya̧ turukó holóló, naao besekȩ sóró fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ai fo deretamotóró, kale whi̧né ama tiki da̧amuretei mo ti wisitepa, ama besekȩ tukóló sóró felepó. Atétere alata, atima sa̧a naai tukóló muló betere be dȩmó yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Atétepa, Juda topo whi̧rapené kale wisirale whi̧paae duraalu, “Sa̧a naai tukóló muló betere be dȩmó ai ala yao̧sóró fo mulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ai fo depa kale whi̧né duraalu, “Ȩ wisirale whi̧né ȩpaae naao besekȩ sóró fae yaleteiné sóró fulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ai fo depa atimané a̧paae woseturaalu, “Mé whi̧né ya̧paae besekȩ sóró fae yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Téyaletei, kale whi̧ wisiróló Yesu a̧ ai touró betere so whi̧ kuamó, buté buté feleteiné a̧ wisirale whi̧ kisipanipó. ");
INSERT INTO ppo_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Atéró, nalo me sukamó Yesuné ama wisirale whi̧ momatere bemó betepa kolóló, a̧paae duraalu, “Mió naao tiki ai wisire kelere? Ya̧ take sale sekȩ bosenóló, doasi sekȩné ya̧ só derao̧sóró, mió naao ai du betere dowi ala mo ti taalae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Téró, kale whi̧ a̧ ai moma dere be taaróló, kale Juda topo whi̧rapepaae Yesuné a̧ wisiralepóló ene felepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tétepa, kale sa̧a nokole sukamótei, Yesuné whi̧ wisiratere ala dapóló, Juda topo whi̧rapené a̧paae sekȩi ala eróló só deraai, doasi ketekȩ butu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Atétepa, Yesuné atimapaae duraalu, “Ya̧lo Aya a̧ ama kutó ditere ala taaréni, betere doko̧ ha̧le diyótóró tarapó. A̧ atére kaae, ȩkélé ha̧le bitini, ya̧lo kutótóró i ditu betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesuné ai alarape deremó, Juda topo whi̧rapené a̧ só deróló mo ti daairaalu, doasi ketekȩ butu betalepó. Até yaleteita, sa̧a nokole be dȩ tukóló whi̧ wisirateremó maaté meipó. Ai alatamo touróló Kótóta, ama Ayapó dere foné a̧ Kótótamo beta̧ ala erapó du betepa a̧ só deróló daai yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Téró, Yesuné atimapaae tokó̧ mótu duraalu, “Ya̧lo dia̧paae mo i dere ape. Naalemané ama kisipanétei, me ala yaai dapóló mo enénipó. Naalemané me kae kisi ala kaaróló dumi, Alimané du betere alatóró kolóló i du betere ape. Ti noatepae, Alimané du betere ala mo beta̧kélé taaréni, turó Naalemanékélé du beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ti noatepae, Alimané Naalemapaae yaala sókó furaalu, ama dere ala fea a̧paae yó mótu beterapó. Ita, mo fo dapó. Mió i dere ala bosenóló nalopaae mo doasi ala eratepa kilitu, diaao̧ sira yaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ti noatepae, Alimané suka̧le so whi̧ kepaaróló beterótu yale kaae, Naalemanékélé ama melaai tuȩ́ mutere so whi̧paae mo ti betere bete mótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ti ai ala maaté meipó. So whi̧tamo fo tokó̧ló taleyóló só deratere alakélé Alimané dumitei, Naalemané yó̧póló, ama naase tua̧mó muló beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ai ala ereteita, so whi̧ feané Alimané doi sóró horótu dere kaae, Naalemané doikélé sóró horó̧póló erapó. Mepaae so whi̧ dené Naalemané doi sóró horénitepa, ti a̧ dotȩyale sekȩ́ Alimané doikélé sóró horótimipó. ");
INSERT INTO ppo_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ya̧lo dia̧paae mo i dere ape. Mepaae so whi̧ dené ya̧lo du betere fo wosóo, ȩ dotȩyale sekȩ́paae kisipa tiki tiróo depa, atétere so whi̧ mo ti betere bete sóró tarapó. Atére so whi̧ta, fo tokó̧tamo yóló só deréni, sukutere ala tua̧mó beteretei, tokó̧ sóró mo ti betaaire ala tua̧mó beteró beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ya̧lo dia̧paae mo dapó. Suka̧le so whi̧nétei Kótó Naalemané dere fo wosaalopó. Mió ai fo wosetu betere so whi̧ta mo betaalopó. Take nalo ai ala yaaire be dȩ ha̧le muóo, miókélé ai be dȩ sókó wóló muóo i ere ape. ");
INSERT INTO ppo_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ti noatepae, mo ti betere bete Alima tua̧mó moletei, Naalema tua̧mó muló̧póló mo taketi meló beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ti a̧ta, Whi̧né Naalema betereteiné so whi̧tamo fo tokó̧ló tale dere ala yó̧póló, Alimané a̧ sóró beteró beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ya̧lo i yale fo wosóló, dia̧ kilita sókó furaalu sira yao̧se. Ti noatepae, suka̧le so whi̧ mo feané ama fo nakome woseturaalu, atima mole doumó turukó holaaire be dȩ sókó waalopó. ");
INSERT INTO ppo_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Atétere sukamó wisi ala yale so whi̧ turukó holóló mo betaalopó. Téyaalotei, dowi ala yale so whi̧ atima turukó holaalotei, taleyóló mo ti só deraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ya̧lo wotoró kisipané me ala yaai dapóló mo enénipó. Fo tokó̧ló taleyóló só deraaire alakélé, ya̧lo Ayané ama dere fo sya fóló, mo donotóró taletu beterapó. Ti noatepae, ya̧lo du betere alata ȩ maaté hȩkese yaai dumitei, ȩ dotȩyale sekȩ́ a̧ hȩkese yó̧póló, ama kisipa mole alatóró sya fu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ya̧loteitamo ȩ etei kaae whi̧pó depa, ti ya̧lo dere fo mo dapóló diaao̧ wosaalomeipó. ");
INSERT INTO ppo_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mené ya̧lo dere ala kilituraalu, a̧ etei kaae ala ere whi̧ wisipó du beterapó. Ama atéró dere fo wosetere whi̧né mo dapó enére ala ya̧lo mo kisiparapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Dia̧né ȩ deé yóló wosaai dapóló, mepaae whi̧rape Jon beterepaae dotonó beterapó. Atétepa Jon-né kale mo foné bete i ape yóló, dia̧paae yó meló beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ti mo whi̧né a̧ etei kaae whi̧pó dere fo mo dapóló, ya̧lo wosaai kisipa munipó. Atépatei, Jon-né yale ala ya̧lo dia̧paae i dere beteta, so whi̧ fea aluyao̧sóró, Kótóné tao só̧póló dapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon a̧ta, sa̧ dȩrótu dere kaae, so whi̧ tua̧mó dȩró beterepó. Ai sa̧ ha̧le dȩyó tapa, dia̧ ai dȩmó kapala asiri hai̧tamo bitiré fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jon-né ama yó melale fota, ti ȩ tua̧mó ere alatóró mo dono yó mótu betalepó. Téyaletei, ya̧lo i ditu betere kutóta, ȩ dotȩyale sekȩ́ ya̧lo Ayané ama ȩpaae diyóló kemerae yale kutó dirótu beterapó. Mió ya̧lo i du betere alarape kolósu, Jon-né ȩ bope yóló du betale fo kolósu depa, ya̧lo du betere alané ama du betale fo tȩteróló bosene falapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Ȩ dotȩyale sekȩ́ ya̧lo Ayanékélé, ȩ etei kaae whi̧póló ha̧kearóló yó mótu beterapó. Tétu betepatei, diaao̧ ȩpaae kisipa tirénire betené ama dere fo diaao̧ wosóo, ama tikikélé dia̧né kolóo, ama fokélé diaao̧ hosaa tua̧mó muóo inipó. ");
INSERT INTO ppo_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","Diaao̧ kisipanéta, kale asȩmó yóló muló betere fo dosa̧ayóló kisipa sóró, mo ti betere bete saalopó du beterapó. Ti asȩmó i ere fo feanéta, ȩ etei kaae whi̧póló yó matapó. Atépatei, dia̧ ȩ beterepaae mo ti betaaire bete sene wale hó̧rótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mo so whi̧né ha̧le foné maaté ya̧lo doi sóró horótu betepa, mo dapóló ya̧lo wosenénipó. ");
INSERT INTO ppo_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tépatei, ya̧lo dia̧ diriyóló tuȩ́rapó. Diaao̧ Kótópaae yaala sókó fóló, hȩkesené sukutere ala dia̧né hosaa tua̧mó muniretei, ya̧lo mo tuȩ́rapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ȩta, ya̧lo Aya Kótó a̧ etei sekȩ́ beterapóló dia̧né kisipa yó̧póló, yó melaai ama ȩ dotonatepa waletei, diaao̧ ȩ wisiyóló dape sinipó. Atépatei, mepaae whi̧ detamo ama ko̧leaané wóló bitu, a̧ etei kaae whi̧pó depa, ti dia̧né a̧ mo wisiyóló dape senérapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mo beta̧ betere Kótóné diaao̧ du betere ala kolóló, dukiratere fo wosaai ketekȩ buni yóo, diaao̧tei dia̧ dukiratere ala yóo, du betereteiné ȩpaae netéró tuȩ́ tiki tiraaloé? ");
INSERT INTO ppo_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ya̧lo Ayané keletómó dia̧né i dowi yalepóló ha̧kearóló só deratere alata, ya̧lo yaaitere nisi yao̧se. Dia̧ tao saalopó du betale whi̧ Moses-nétóró dia̧ só deraalopó. ");
INSERT INTO ppo_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Dia̧nétamo Moses-né asȩre fo wosóló, mopóló kisipa tirólua̧sóró, ti mió ya̧lo dere fokélé mo dapóló kisipa tirólua̧pó. Ti noatepae, ama ai asȩre fota, ȩmótóró kisipa muturaalu erapó. ");
INSERT INTO ppo_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tépatei, ama asȩre fo diaao̧ dosa̧ayóló mopóló tuȩ́ tiki tiréni depa, ti ya̧lo du betere fokélé netéró wosóló, kisipa tiraaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Atéró mepaae be dȩrape kemetepa, nalo Yesu a̧ Kaleli wȩi uté fókuró tȩ felepó. Ai wȩi kȩlané doi meta, Taiberius-pó. ");
INSERT INTO ppo_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yesu a̧ atéró fóló beteremó, mepaae kisi daae mole so whi̧ wisiratere kelemei alarape kelaleteiné so whi̧ mo feané a̧ sya wou betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Atéró, Yesu a̧ beta̧ du sokore ao̧paae hololó, ama yó matere whi̧rape atima fea beta̧mó beterepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Atéyale alata kale boseneyóló fele be dȩmó, Juda fake whi̧rapené o̧la detere ala felekemó sókó waai deremó yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Atéró, Yesuné ama kelalemó, so whi̧ mo ha̧le o̧la kaae, a̧ beterepaae wou betepa Filip-paae duraalu, “Doa i so whi̧ naaire bred okó momó dupu yaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesuné Filip-paae atéró wosale fota, ama yaaire ala tuȩ́rutei, Filip-né noa fokó déró a̧ ka̧ae kolóló su̧ suraalu yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ai fo depa, Filip-né Yesupaae duraalu, “200 silpa moni-né dupu dere bred o i betó mole so whi̧ fea su̧mó naalomei, sawa téti nenérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Tétepa, Yesuné ama yó matere whi̧kó ama doi Saimon Pitané noma Andruné Yesupaae duraalu, “I betere naalené beta̧ bali o bula aporó yóo, ya beleka̧amale tamo yóo, yóló i tare ape. Téreteiné doa i betó mole so whi̧ fea anéli o̧lané su̧nére?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Atétepa, Yesuné atimapaae duraalu, “Ai so whi̧ ne tómó beteró̧póló yae,” depa, atima betalepó. Ai tua̧mó betere naale senaaleró sorapetamo dosa̧ani, whi̧rape maaté dosa̧ayóló touróturaalu, 5000-rópó. ");
INSERT INTO ppo_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Atéró, Yesuné kale bali o bularape fea sóró taruraalu, Talepaae mo kée yóló terekée daalu yóló, so whi̧mó a̧liralepó. Ya tamokélé bred o yale kaaetóró yóló a̧liratepa, atima fea mo su̧mó nalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Atéró su̧tepa, ama yó matere whi̧rapepaae duraalu, “Muni fele buki o̧la ha̧le beseké yao̧sórópa, fea daseté kwȩyae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Atéró nale aporó bred o bulanétei, buki muni fupa daseté kwȩyóló, 12 yorape deyóló fa̧analepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ai betó mole so whi̧né Yesuné atei kaae kelemei ala eratepa kolóló duraalu, “I whi̧ta, i haepaae waalopóló take bopetu betale Kótóné ko̧ló whi̧ a̧tóró hi̧ti irurapó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Atéró, ai so whi̧né Yesupaae woseni, atima ko̧leaanétei a̧ doasi topo whi̧ sóró beteraai kisipa mualepó. Atima atéró mutere kisipa tiki bete Yesuné kilitu atima taaróló, a̧ ama wotoró beta̧ du sorokore tikipaae momó biti̧ holalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Téró, atéyale sukamó kuluka be dikité dorowaletamo Yesuné yó matere whi̧rape atima maaté Kaleli wȩi fókupaae derepelepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Atéró, aimó atima Yesu a̧ kaae tawóló daapatei be diki yalepó. Atétepa, kale whi̧rape atima wȩi nukupaae biti̧ holóló, Kapeneam be huluapaae faairaalu, ai wȩi kȩla tua̧mó tukóló fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Atéró fu betalemó, doakale besȩ́ tiki wouraalu, doasi wȩi asya walepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Até depatei, atima 5 ó 6 kilomita da̧lemó nuku i̧té fu bitu kelalemó, atima nukutamo wou betepa, Yesu a̧ hokolaa yaairaalu, wȩi tómó daaté wou betalepó. Atétepa kilitu, atima doasi winé suka̧lepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tétepa, Yesuné atimapaae duraalu, “Ita ȩpa, dia̧ wiyao̧se,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tétepa, kale whi̧rape atima witere ala taaróló, halaainé Yesu dape sóró, nuku tua̧paae beteraai kisipa mualepó. Atéró dape sóró, atima faaire wȩi fóku feleke inipatei, utéró hapale tétitóró sókó felepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Atéró, Yesuné ama yó matere whi̧rape atima fi tikimó, ai wȩi fókumó betó mupa fele so whi̧ atima fiyóló, hi̧ka turukó huturaalu etei kisipa mualepó. Imó mole beta̧ nukumóta Yesu bitini, ama yó matere whi̧rape maaté betóló felepó du betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Atéró, Taiberius beró wale whi̧rape mepaae atimané nukutamo, take Talené mo kée yóló, o̧la a̧liyóló nuku betale tikimó sókó walepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Atéró, ai sukamótóróti mepaae whi̧rapekélé, kale nukutamo wale whi̧rapetamoné Yesuró ama yó matere whi̧rapetamo keka̧lemó kilinitepa, Kapeneam be huluapaae keka̧ai dapóló, atima nukupaae biti̧ holóló felepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Atéró, kale so whi̧né Yesu kekitu beteró, wȩi fóku uté tȩró betepa kolóló a̧paae duraalu, “Yó matere whi̧-ó, ya̧ ipaae metéli waleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ai fo depa, Yesuné atimapaae duraalu, “Ya̧lo dia̧paae mo i dere ape. Diaao̧ ȩ kekitu betere beteta, sira yaaire kelemei alarape eraleteimó kisipa mutu, ȩ kekitu betere? Mo meipó. Kale bred o su̧mó naleteiné diaao̧ ȩ ai keketé kutu betere ape. ");
INSERT INTO ppo_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","I haemó nokole mo o̧lata, ti doyóló aluyaalopó. Atéyaaire o̧lamótei, dia̧ depe tukówei ala du betao̧se. Mo ti betaaire o̧lata, kale whi̧né Naalemané dia̧mó melaalopa, ai o̧la mo ketekȩ buóló hai̧tamo sae. Atei o̧la melaaire whi̧ta, Alima Kótóné fopeyóló a̧tóró wisirapóló siriróló, beteró beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ai fo depa, atimané a̧paae woseturaalu, “Kótóné ama da̧paae dirae dere kutó-a, noaé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tétepa, Yesuné duraalu, “Kótóné ama dirae dere kutóta i ape. Kótóné ama dotonó betere whi̧ beta̧paae kisipa tiki tiróló betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ai fo depa, atimané a̧paae duraalu, “Talené eratapóló da̧né kisipa tiró̧póló, naao noa kelemei alakó eraaloé? ");
INSERT INTO ppo_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mo take da̧né noutererape atima ha̧le kópu ka̧ae fi haemó kuturaalu, mana o beta̧ nó̧póló ó hepen bemó derótua ipakalepóló, asȩmó yóló muló beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tétepa, Yesuné atimapaae duraalu, “Dia̧paae ya̧lo mo i dere ape. Hepen bemó derótua yale bred ota Moses-né menitei, ya̧lo Ayané beta̧ ó hepen bemó deratere mo bete mole bred o dia̧mó mótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ti Kótóné ai mótu betere mo bete mole ota ó hepen be taaróló dorowóló, i haemó betó mole so whi̧mó mo ti betere bete matere whi̧ta, ȩtórótipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ai fo depa, atimané a̧paae duraalu, “Doa whi̧-ó, naao ai bope dere ota, mo miótóró kaae sóró da̧mó melaasepé,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ai fo depa, Yesuné atimapaae ha̧kearóló duraalu, “Mo ti betere bete mole ota ȩtórótipó. Mepaae so whi̧ de ȩ beterepaae wapa, ai so whi̧ wotekélé mo yaalomeipó. Mepaae so whi̧ de ȩpaae kisipa tiki tiratepa, ti ai so whi̧ wȩi nokole dere ala mo sawakélé yaalomeipó. ");
INSERT INTO ppo_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Take ya̧lo dia̧paae yale fo kaae, momó i dere ape. Ȩ wale ala diaao̧ kelaletei, ȩpaae kisipa tiki tiratere ala dumipó. ");
INSERT INTO ppo_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ya̧lo Ayané ȩpaae matere so whi̧ feata, ti ȩ beterepaae wou betaalopó. Mepaae so whi̧ detamo ȩ beterepaae wapa, ti ya̧lo atima fae yóló ho̧konatere alakélé mo yaalomeipó. ");
INSERT INTO ppo_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ti noatepae, ȩ ó hepen be taaróló i haepaae dorowaleteita, ya̧lo kisipa mole ala yaai dapóló anipó. Téni, ȩ dotȩyale whi̧né ama kisipa mole alatóró eraairaalu woló i betere ape. ");
INSERT INTO ppo_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ya̧lo Aya ȩ dotȩyale sekȩ́né ama kisipa mole alata ipó. Ama ȩpaae melale so whi̧ mo beta̧kélé ya̧lo aluréni, take kemetere sukamó atima fea kepaayóló mo ti beteró̧póló kisipa mutu ȩ dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ti ya̧lo Ayané ama kisipa mole alata ipó. So whi̧ de ama Naalemané dere ala kolóló a̧paae kisipa tiki tiratepa, ti atétere so whi̧ mo ti betótóró tawaalopó. Ai so whi̧ta, take kemetere sukamó ya̧lo kepaaróló beteraalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ai fo deremó kale Juda fake so whi̧né duraalu, “A̧ta, ó hepen be taaróló dorowale bred opó du betere fo-a, noa betené dérópóló,” atima dei tuȩ́ mutu, a̧ faletu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kale dere kaae atimasisitei duraalu, “I sekȩ́ta, kale Josep-né naalema Yesu hi̧ti meié? Ama hamaró alimatamota, da̧né tuȩ́rapó. Tépatei, a̧ ó hepen beró dorowalepó du betere fota, noa betené dérópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Atétepa, Yesuné atimapaae duraalu, “Dia̧sisitei dei tuȩ́ muóló kȩlaarótu betere fo taalae. ");
INSERT INTO ppo_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Whi̧ me de ȩ beterepaae ama ko̧leaané wonénipó. Ya̧lo Aya ȩ dotȩyale sekȩ́né amatei ȩ beterepaae a̧lisóró wapa, ti wonérapó. Ai so whi̧ta, take kemetere sukamó ya̧lo kepaaróló mo ti beteraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mo take betale Kótóné ko̧ló whi̧rapené asȩmó i fo erapó. ‘Kótóné ama so whi̧ yó mótu betepa, ti atima fea tuȩ́ yaalo ai ape.’ Ya̧lo Ayané dere fo wosóló, kisipa sere so whi̧ta, ti ȩ beterepaae wua du beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mo whi̧ beta̧nékélé Kótó kilinitei, kale Alimatamo betóló wale Naalené beta̧ ti Alima kolóló kisiparapó. ");
INSERT INTO ppo_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ya̧lo dia̧paae mo i dere ape. Whi̧ me detamo ȩpaae kisipa tiki tiró betepa, ti ai whi̧né mo ti betó tare bete sóró tarapó. ");
INSERT INTO ppo_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","49","Ti noatepae, mo ti betere bete bole ota ȩtórótipó. Mo take betale diaao̧ noutererape atima ha̧le kópu ka̧ae fi tikimó kuturaalu, Kótóné ó hepen bemó deratere mana o maaté nukua ipakalepó. Tétua yaletei, atima bitini sukutua erapó. ");
INSERT INTO ppo_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Atéyaletei, ó hepen bemó dorowale betere bete bole bred ota i mole ape. Ai o nokole so whi̧ sukó̧kélé mo yaalomeipó. ");
INSERT INTO ppo_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ó hepen bemó dorowale mo ti betere bred ota, ti ȩtórótipó. Whi̧ me de i o sóró nukupa, ai so whi̧ mo ti betó tawaalopó. I ota, haemó betó mole so whi̧ mo ti beteró̧póló, matere ya̧lo tiki mipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ai fo depa, kale Juda fake so whi̧ atimasisitei fo kȩlaaróló duraalu, “Haió, i whi̧né ama tikitei da̧paae naasepé dere fo-a, netéró nó̧póló melaai dérópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tétepa, Yesuné atimapaae duraalu, “Ya̧lo dia̧paae mo i dere ape. Kale Whi̧né Naalemané ama tiki miró fa̧ketamo nénitepa, ti atétere so whi̧ tua̧mó mo ti betere bete muni ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mepaae so whi̧ dené ya̧lo tiki miró fa̧ketamo nukupa, ti ai so whi̧né mo ti betó tare bete sóró tarapó. Ai so whi̧ta, take kemetere sukamó ya̧lo kepaaróló beteraalopó. ");
INSERT INTO ppo_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ti noatepae, ya̧lo tikita ti nokole mo bete mole o̧la yóo, ya̧lo fa̧kekélé nokole mo bete mole wȩi yóo erapó. ");
INSERT INTO ppo_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mepaae so whi̧ dené ya̧lo tiki miró fa̧ketamo nukupa, ti atétere so whi̧ ȩ tua̧mó betóo, ȩ ai so whi̧ tua̧mó betóo, erapó. ");
INSERT INTO ppo_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mo ti betere sekȩ́ ya̧lo Ayané ȩ dotonatepa walepó. Ȩ betere betekélé ti ya̧lo Aya a̧tórótipó. Atére kaae, mepaae so whi̧ dené ȩ nokole o̧lapóló nuku betepa, ti betere bete ȩ ereteiné ai so whi̧ atimakélé ha̧le betó tawaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ó hepen bemó dorowale bred ota, ti ȩ i ape. Mo take betale diaao̧ noutererape atimata, ó hepen bemó derótua yale mana o nukua yaletei, atima fea suka̧lepó. Tépatei, mepaae i o nokole so whi̧ta, mo ti betó tawaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","I fota, Yesuné u Kapeneam-mó tȩne fo wosetere be tua̧mó yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ama yó matere whi̧rape mepaaené ai yale fo wosóló, atimasisi kȩlaaróló duraalu, “Ama ai yó matere whi̧ fota felékélé inipa, né wosaaloé?,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesuné ai yó matere fo ama yó matere whi̧rapené wosaalo meipóló kȩlaarótu betepa, Yesuné ama kisipa yóló atimapaae duraalu, “Ya̧lo i yó matere fo diaao̧ wosóló felénipa, ȩtamo dei tuȩ́ mute? ");
INSERT INTO ppo_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kale Whi̧né Naalema a̧ take betale tikipaae momó fesaae hotepa kilitu, diaao̧ noa kisipa muaaloé? ");
INSERT INTO ppo_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Whi̧né mo tó tikita, doasi bete munitei, Dȩi Kepe Wisiné beta̧ mo ti betaaire bete mótu beterapó. Ya̧lo dia̧paae yó matere fota, Dȩi Kepe fa̧anuraalu, mo ti betere bete mótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tépatei, dia̧ mepaae kisipa tiki tirénire whi̧rapekélé ai betere ape,” yalepó. Yesuné atéró yale fota, a̧paae tuȩ́ tiki tirénire whi̧raperó a̧ dó̧póló eleké deyaaire whi̧tamo take kaae sale sukamótei, ama kisipa yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Téró, Yesuné ama yale fo kemeni, ha̧le yótóró taru duraalu, “Ya̧lo take dia̧paae yale fo i ape. Mepaae so whi̧ de atima ko̧leaanétei, ȩ beterepaae waai dapóló wonénipó. Ya̧lo Ayané ȩ beterepaae a̧lisóró wapa, ti wonérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ai sukamó kaae sóró, Yesuné yó matere whi̧rape mepaae a̧ sya fole ala taaralepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","68","Atétepa, ama yó matere 12 whi̧rapepaae duraalu, “Diaao̧kélé ȩ taaróló faai kisipa mute?” depa, Saimon Pitané a̧paae duraalu, “Tale-ó, da̧ me de beterepaaemo faaloé? Mo ti betaaire fota, ya̧ tua̧mó ai mole ape. ");
INSERT INTO ppo_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ya̧ta, Kótóné ama fopeyóló kae beteró betere whi̧ wisinaalepóló, da̧né ya̧paae tuȩ́ tiki tiró beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ai fo depa, Yesuné atimapaae tokó̧ mótu duraalu, “Dia̧ 12 whi̧rapeta, ya̧lotei sorokó sóró kae beteró beterapó. Tépatei, beta̧ whi̧ tua̧paae dowi kepe doropóló ai betere ape!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ama ai yale fota, Iskariot be whi̧kó Saimon naalema Judas-mó kisipa muturaalu yalepó. Ti Judas a̧kélé 12 whi̧rapekó ama yó matere whi̧tei, a̧ dó̧póló eléké deyaaire sekȩ́pó. ");
INSERT INTO ppo_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ai alarape yóló kemetepa, Yesu a̧ Judia hae kwiamó betó mole Juda fake whi̧rapené a̧ daai du betepa, Judia hae kwiapaae feni, Kaleli hae tua̧mótei kutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Tépatei, Juda fake whi̧rapené furu berapemó o̧la deyaai tukóló muló betere be dȩ felekemó sókó waai depa, Yesuné ama nomarapené a̧paae duraalu, “Ya̧ ai betere be hulua taaróló, naao yó matere whi̧rapené naao erótu betere kelemei alarape koló̧póló, ya̧ Judia hae kwiapaae fumié yóló sȩtu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ti noatepae, beta̧ doi mole whi̧ betaai depa, ti ama dere ala kikiti kinóló ini, so whi̧ feané koló̧póló ha̧keamó enérapó. Atépa, ti naao ai du betere alarape i haemó betó mole so whi̧ feané koló̧póló ha̧kearae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ti ama nomarapené ai yale fota, atimakélé a̧paae kisipa tiréni irutei yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ai fo depa, Yesuné atimapaae duraalu, “Diaao̧ yaaitere alata, ha̧le ho̧ko sukamó deté fenérapó. Tépatei, ȩ ai o̧la deterepaae faai tukóló muló betere mo dono be dȩ sókó waai teórapó. ");
INSERT INTO ppo_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","I haemó betó mole so whi̧ feané dia̧ hó̧róló bóe dele ala enénipó. Tépatei, ȩ hó̧róló bóe dele ala suka fea ha̧le yó tarapó. Ti noatepae, atimané du betere dowi ala bete ya̧lo ha̧kearóló yó materemó, ȩtamo dei tuȩ́ muturaalu dapó. ");
INSERT INTO ppo_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ȩta, ai o̧la deterepaae faalomeipa, dia̧ maaté holae. Ti noatepae, ȩ ya̧lo yaaire ala teóreteiné beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ama atimapaae ai fo yóló, a̧ Kaleli hae kwiamó sawa kaae tawóló beterepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Téyaletei, ama nomarape atima o̧la deterepaae fitikimó, nalo a̧kélé Jerusalem be huluapaae holaletei, so whi̧né a̧ kelao̧sóró ha̧keamó feni, kikiti sókó fóló beterepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Atéró, kale o̧la detere tikimó atima Juda topo whi̧rapené a̧ wóló beterémóló keka̧lemó bitinipa atimasisi duraalu, “Kale whi̧ momó beterérópó?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ai o̧la detere tikimó touró betere mepaae so whi̧ atimasisi kikiti deté furaalu, “A̧ta, mo whi̧ wisipó,” depa, mepaae so whi̧né duraalu, “Meipó. A̧ta, so whi̧ fea dilikó̧ló kapala ala yó mótu betere whi̧pó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Téyaletei, atima Juda topo whi̧rape kolóló wituraalu, mo whi̧ beta̧nékélé mepaae forape ha̧keamó inipó. ");
INSERT INTO ppo_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Atéró, kale o̧la detere be dȩ sókó waai mepaae be dȩ ha̧le mupa, Yesu a̧ momatere be tipi bolaa tua̧paae holóló, kale fo kaae sóró yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ama atéró yó matere fomó, kale Juda topo whi̧rape atima kilita sókó fu, sirayóló duraalu, “I whi̧né atei kaae fosó fosó yóló yó mótu betere fo-a, a̧ skul-paaekélé fenitei, momó kisipa sóró du bitu dérópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ai fo depa, Yesuné atimapaae duraalu, “Ya̧lo i yó matere fota, ya̧lotei kekeme nóló dumi, ȩ dotȩyale sekȩ́né yae yale fotóró du beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mepaae whi̧nétamo Kótóné kisipa mole ala sya fóló, ama ala eraai kisipa mutepa, ti ya̧lo i yó matere fo Kótóné ama kisipa mole ala sya fóló dépé, ya̧lotei kekeme nóló déró, ai whi̧né amatei ka̧ae kolóló talenérapó. ");
INSERT INTO ppo_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Me whi̧né ama tuȩ́nétei kekeme nóló yó mótu betepa, ti ama doi doasi muó̧póló du beterapó. Tépatei, me whi̧nétamo a̧ dotȩyale sekȩ́né doi doasi muó̧póló ama ala eratepa, ti atétere whi̧ tua̧mó mo alatóró mulu, kapala ala mo sawakélé munipó. ");
INSERT INTO ppo_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Take kale tukóló muló betere fo Moses-né dia̧paae menénié? Téyaletei, dia̧kó beta̧ whi̧nékélé ai tukóló muló betere fo sya feni, tikitua dapó. Atérapa, dia̧né ȩ noatepa daai du bitu de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ai touró betere so whi̧né a̧paae duraalu, “Ya̧ tua̧móta, dowi kepe tepeyóló ai fa̧anapa, ya̧ né daai du betepa de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ai fo depa Yesuné atimapaae duraalu, “Ya̧lo beta̧ kelemei ala eraleteimó diaao̧ ai siratu betere ape. ");
INSERT INTO ppo_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tétu beteretei, diaao̧ tiki sekaȩ tukóló sirirótu betere alata, Moses-né amatóró kaae sóró inipó. Ténitei, mo take diaao̧ noutererapené du betale ala sya furaalu, sa̧a naai tukóló mulale be dȩmótei, mió dia̧né naalerapekélé tiki sekaȩ ai tikitu betere ape. ");
INSERT INTO ppo_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tépatei, Moses-né yóló muló betere fo diaao̧ tikaalo meipóló kisipa mutu, sa̧a naai tukóló muló betere be dȩmótei, diaao̧ naalerape tiki sekaȩ ai tikitu betere ape. Térapa, ai sa̧a nokole be dȩmótóró, whi̧né tiki turó ya̧lo wisirateremó, dia̧né ȩtamo noatepa fopaae butu de? ");
INSERT INTO ppo_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Diaao̧ tómó mole ala kolóló ȩ só derótu betere fo mo taalae. Mo bete mole ala donotóró taleyae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ama ai fo depa wosóló, mepaae Jerusalem be huluamó betó mole so whi̧né duraalu, “Juda topo whi̧rapené daai du betere whi̧ a̧tóró hi̧ti meié? ");
INSERT INTO ppo_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mió a̧ so whi̧ feané keletómó daalu, ama fo ha̧keamó yó mótu betepatei, atimané a̧paae me fokélé dumipó. Ti Yesu a̧ta, so whi̧ fea tȩteróló kaae tanó̧póló, Kótóné sóró beteró betere whi̧ Kerisopóló, Juda topo whi̧rapené kisiparu démólópó? ");
INSERT INTO ppo_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Da̧néta, ai whi̧ wale turuku be kisiparapó. Atépatei, so whi̧ tȩteróló kaae tare whi̧ Keriso a̧ wale sukamó, mo beta̧ whi̧nékélé ama turuku be kisipa yaalo meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Atéró Yesu a̧ moma dere be belamó daalu, fo ha̧le yótóró mótu bitu fo fakeyóló duraalu, “Ȩ wale turuku bekélé ȩkélé, diaao̧ kolóló kisiparapó dere fota, mo ai dere ape. Tépatei ȩ i wóló beteretei ya̧lo ko̧leaané ani, Ayané ȩ dotonatepa walepó. A̧ta, mo alatóró yó tare sekȩ́ betepatei, dia̧né a̧ kolóló kisipanipó. ");
INSERT INTO ppo_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ténitei, ȩta a̧tamo beta̧mó betóló ama ȩ dotonatepa waleteiné ya̧lo a̧ mo kisiparapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ama ai fo deremó, atimané a̧ tawóló dipula beteraai yaletei, whi̧ beta̧nékélé a̧ tane fenipó. Ti noatepae, a̧paae ai ala eraaire be dȩ sókó waai teópa yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Aimó touró betere so whi̧ atima ai fo du betepatei, mepaae kisipa tiró betere so whi̧né duraalu, “So whi̧ fea tȩteróló kaae tanó̧póló, Kótóné dotonaalopó ere whi̧ wale sukamó Kótóné dapó yó̧póló, i sekȩ́né eratere kelemei alarape fea bosenóló, me noa kaae doasi ala eraaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aimó touró betere so whi̧né Yesuné du betere alamó, atimasisi kikiti du betepa, Farisi whi̧rapené wosalepó. Atétepa, so whi̧mó Talepaae momaratere topo whi̧raperó Farisi whi̧rapetamoné momatere be kaae tare diki tare whi̧rapené Yesu tawóló dipula beteró̧póló dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Atétepa, Yesuné atimapaae duraalu, “Ȩta fo̧lo sukamó bitini, mo sawa sukamó maaté dia̧tamo betóló, ȩ dotȩyale sekȩ́ ya̧lo Aya beterepaae momó fesaae faalopó. ");
INSERT INTO ppo_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ȩ diaao̧ keka̧alotei, kelaalo meipó. Ȩ fóló betere tikipaae dia̧ wókélé mo yaalo meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ama ai dere fo wosóló, kale Juda topo whi̧rape atimasisitei, fo kȩlaaróló duraalu, “Ai whi̧né a̧ kekó̧ta yaalotei kelaalo meipó, a̧ fole tikipaae dia̧ wókélé yaalo meipó, du betere fota, mopaae faai dérópó? Da̧ Juda fake whi̧rape Krik fo bole be huluapaae dapo dapo yóló betere so whi̧paae fo yó male faairaalu démólópó. ");
INSERT INTO ppo_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ama du, ‘Diaao̧ a̧ keka̧alotei kelaalo meipó, a̧ fóló betere tikipaae dia̧ wókélé yaalo meipó,’ du betere-a, noa fo betené dérópó?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","O̧la deté wóló kemerótu mo doasi o̧la deyale sukamó, Yesu a̧ turukó holóló fo fakeyóló duraalu, “Mepaae so whi̧ detamo wȩi nokole depa, ti ȩ beterepaae nale wó̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kale asȩre fo tua̧mó Kótóné i fo erapó. So whi̧ tua̧mó mo ti betó tare wȩi fa̧aturaalu, feleyóló faalo ai ape ere fo mo dokonóló, mepaae whi̧ detamo ȩpaae kisipa tiki tiratepa, ti ai so whi̧ tua̧paae mo eraalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesuné ama ai yale fo beteta, take a̧ hepen-paae furaalu, Dȩi Kepe Wisi a̧paae kisipa tiratere so whi̧mó matepa saalopóló kisipa mutu ai fo yalepó. Aita, ama doasi doi saaire be dȩ teópa kaae taruraalu, ai fo yale sukamó kale Dȩi Kepe hapale menipó. ");
INSERT INTO ppo_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ama ai dere fo wosóló mepaae so whi̧né duraalu, “Kótóné ko̧ló whi̧ waalopóló bopetu betaletei, me kae mei a̧tóró mo hi̧tipó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ai fo depa, mepaae so whi̧né duraalu, “A̧ta, so whi̧ fea tȩteróló kaae tanó̧póló, Kótóné sóró beteró betere whi̧ Keriso hi̧tipó,” Tétepa mepaae so whi̧né duraalu, “Meipó. Keriso a̧ Kaleli haemó netéró waalopóló de?” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","“So whi̧ tȩteróló kaae tare whi̧ Keriso a̧ta, Take Depit-né ama turuku be Betelehem-mó ama deté fele naale tua̧mó sókó waalopóló asȩmó inié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ai fo depa woseturaalu, Yesu a̧ derópóló ai so whi̧ atima fea beta̧ kisipa muni, kisipa kae kae mutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Téturaalu, mepaae whi̧né a̧ tawóló dipula beteraai kisipa mualetei, whi̧ beta̧nékélé a̧ tane fenipó. ");
INSERT INTO ppo_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ai alarape yóló kemeróturaalu, kale momatere be kaae tare diki tare whi̧rape atima Yesu tawóló dipula beteraai dapóló feletei, momó fesaae walepó. Atétepa, mo so whi̧mó Talepaae momaratere doasi topo whi̧raperó Farisi whi̧rapetamoné atimapaae duraalu, “Ai whi̧-a, dapesó wale noatepa taaróló waleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ai fo depa, kale diki tare whi̧rapené atimapaae teraae faróló duraalu, “Mo take betale alimó beta̧ whi̧nékélé, mió i whi̧né dere fo kaae depa mo wosenipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ai fo depa, kale Farisi whi̧rapené duraalu, “Aita, dia̧kélé dilikituraalu yalepa kelae! ");
INSERT INTO ppo_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Da̧kó i betó mole momaratere topo whi̧raperó Farisi whi̧rapetamo mo beta̧kélé a̧paae kisipa tiki tiró beterekó diaao̧ kelere? Mo meipó. ");
INSERT INTO ppo_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tépatei, i betó mole so whi̧ Moses-né asȩre fo dosa̧ayóló tuȩ́ni, ha̧le ho̧ko betó mupa, ti Kótóné atima doróló mokoraalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Ai fo depa, take Yesu beterepaae fele Farisi whi̧kó ama doi Nikodimas-né mepaae Farisi whi̧rapepaae duraalu, “Da̧né tukóló muló betere fo sya furaalu, me whi̧né ama i alarape yalepó dere fo wosenipatei, ha̧le ho̧ko só derótua de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Atétepa, atimané Nikodimas-paae duraalu, “Ya̧kélé Kaleli whi̧é? Kótóné ko̧ló whi̧ta, Kaleli hae kwiamó waalopó fo inipó. Ai fokó asȩmó muléró kelaasepóló dosa̧ayae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Atéró, ai tourale so whi̧ atimané be séle sélepaae dapo dapo yóló felepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","2","Atéró fi tikimó, Yesu a̧ Olip du sorokó molepaae fini holalepó. Atéró fiyóló, be dȩtepa mo hi̧kati a̧ momatere be tipi bolaa tua̧paae momó fóló daalemó, so whi̧ fea wóló a̧ bopéró betepa, biti̧ doropóló atimapaae fo yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Atéró yó mótu betalemó, kale tukóló muló betere fo yó matere whi̧raperó Farisi whi̧rapetamoné beta̧ so nópu nuku betepa kolóló dapesó wóló, ai touró betere so whi̧ tua̧mó daalalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Atéró daaló bitu Yesupaae duraalu, “Yó matere whi̧-ó, i sota nópu nuku betepa kolóló dapesó walepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Atei ala dere sorapeta, kapo duné siróló dae yóló Moses-né asȩmó erapó. Atérapa, naao me fokó enére?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Atimané a̧paae atéró wosale fota ha̧le inipó. A̧ só deraairaalu, atimasisi fo deyóló a̧ su̧ su ai fo yalepó. Tétepa, a̧ hemée deyóló bitu, naase dou̧né haemó asȩtu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","8","Atéró atimané a̧paae wosetere fo dekéró yó tapa, a̧ hemée taretei donone holóló duraalu, “Dia̧kó dowi ala mo beta̧kélé initere whi̧ betepata, ti ai whi̧népi a̧ kapo duné siróló dó̧póló yae,” yalepó. Ai fo yóló, a̧ momó hemée deyóló haemó asȩtu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ama ai dere fo wosetu, mepaae teó so whi̧ nalo wó̧póló, otererape atimapi be séle séle fu betalepó. Atima fea atéró fi tikimó, Yesu a̧ beta̧ bitu kelalemó, kale so a̧ daale tikimótóró ha̧le daalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Atépa Yesu hemée taretei donone holóló, kale sopaae duraalu, “Ti so-ó, ya̧ só deróló daai du betale whi̧rape-a, mopaae feleé? Me whi̧nékó ya̧ só deraleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ai fo depa kale soné duraalu, “Doa whi̧-ó, mo beta̧ whi̧kélé imó bitinipó,” yalepó. Tétepa Yesuné a̧paae teraae faróló duraalu, “Ya̧lo ya̧ só derótumipa dua fae. Téturaalu, naao deté wou betere dowi ala momó kae ini, mo ti taalae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Atéró Yesuné ama yale fo kaae, so whi̧paae momó duraalu, “I haemó dȩrótu betere dȩta ti mo ȩtórótipó. Mepaae ȩ sya wale so whi̧ta, diliki tua̧mó kuni, dȩ tua̧mótóró kwȩyóló, mo ti betere bete sóró betaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ai fo depa, kale Farisi whi̧rape atima dei tuȩ́ mutu Yesupaae duraalu, “Naaotei ya̧ etei kaae whi̧póló dere fo mo dapóló, da̧né wosaalomeipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ai fo depa, Yesuné atimapaae tokó̧ mótu duraalu, “Ya̧lotamo ȩ etei kaae whi̧pó depa, so whi̧né mo dapó enérapó. Ti noatepae, ȩ betóló wale tikiró faaire tikitamo ya̧lotóró tuȩ́rapó. Téretei, ȩ wale ala ó fole ala dia̧ tuȩ́nipó. ");
INSERT INTO ppo_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Dia̧né me whi̧ hamoma taleyóló só deratere alata, mo whi̧né dere ala sya fóló du beterapó. Tépatei, ya̧lo taleyóló me whi̧ só deratere ala mo dumipó. ");
INSERT INTO ppo_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ya̧lotamo ai ala depa, ti ȩ ya̧lo wotoró bitini, ȩ dotȩyale sekȩ́ ya̧lo Ayatamo beta̧ kisipa muóló, fea ala wusuró dereteiné mo donomó enérapó. ");
INSERT INTO ppo_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Téretei, diaao̧ sya fu betere asȩmó etei fo yóló muló beterapó. Whi̧ mené fo kae ini, atimaamo wusuróné beta̧ kaae fotóró depa, ti mo dapó du beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Atétu dere kaae, ya̧lotei ȩ etei kaae whi̧póló yó melóo, ȩ dotȩyale sekȩ́ ya̧lo Ayanékélé, ȩ tua̧mó ere alatóró fea ama mo dono yó melóo, du beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ai fo depa, atimané a̧paae woseturaalu, “Naao Aya momó betere?” depa, Yesuné duraalu, “Ȩkélé, ya̧lo Ayakélé diaao̧ mo kisipanipó. Ȩtamo dia̧né kisipa ua̧sóró, ti ya̧lo Ayakélé diaao̧ su̧mó kisipa ua̧pó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuné ama i forape du betaleteita, momatere be tipi bolaa tua̧mó Kótópaae moni ha̧le maleta dere tikimó daalu, yó mótu betalepó. Téyaletei, a̧paae me ala eraaire be dȩ teóreteiné beta̧ whi̧nékélé a̧ tane fenipó. ");
INSERT INTO ppo_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Atéró, Yesuné ama yale fo kaae, atimapaae momó duraalu, “Ȩta, dia̧ taaróló fulapó. Atéró fi tikimó dia̧né ȩ kekitu betaalotei, diaao̧ du betere dowi ala tua̧mó dia̧ suka̧alo ai ape. Ȩ fole tikipaae dia̧ mo wókélé yaalo meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ai fo depa, kale Juda topo whi̧rape atimasisi duraalu, “A̧ fole tikipaae dia̧ waalo meipóló yale fo beteta, amatei a̧ daalopóló du yalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tépatei, Yesuné atimapaae yótóró taru duraalu, “Dia̧ta, i haemó kaayóló beterapó. Ȩta, ó taoró biti dorowale whi̧pó. Dia̧ta hae whi̧ betereteiné haemó mole alatamo fulumu du beterapó. Tépatei, ȩta ó taoró dorowaleteiné i haemó mole alatamo fulumu dumipó. ");
INSERT INTO ppo_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Take ya̧lo dia̧paae diaao̧ du betere dowi ala tua̧mó sinaalo ai ape yale fota, ti i betené yalepó. Diaao̧ ya̧lo dere fo wosóló, ȩ etei kaae whi̧póló kisipa tikitamo tiréni depa, ti diaao̧ du betere dowi ala tua̧mó dia̧ sinaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ai fo depa, atimané a̧paae duraalu, “Ti ya̧ deé?” yóló wosetepa, Yesuné duraalu, “Mo take kaae sale sukamótei, etei kaae whi̧póló dia̧paae deté wou betaletei me kae mei ȩtóróti i ape. ");
INSERT INTO ppo_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Diaao̧ du betere alamó ya̧lo dia̧tamo fo tokó̧ló dia̧ só deraaire fo mo dekéró mulapó. Tépatei, ȩ dotȩyale sekȩ́ a̧ta, mo alaró mo fotamoné betepó. Ama depa ya̧lo wosale fotóró i haemó betó mole so whi̧ feapaae yó mótu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Atimané ama ai dere fo wosóló, ita Alima tua̧mó ere alatóró yó matapóló kisipa munipó. ");
INSERT INTO ppo_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Atétu betepa, Yesuné atimapaae duraalu, “Kale Whi̧né Naalema dia̧né sikipaae só horatere sukamó, ȩ etei kaae whi̧póló diaao̧ kisipa yaalopó. Mió dia̧paae i yó mótu betere fokélé, ya̧lo ko̧leaané kekeme nóló dumi, Aya ȩ dotȩyale sekȩ́né yó matere fotóró dapó. ");
INSERT INTO ppo_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ai ala yó̧póló, ȩ dotȩyale sekȩ́né ȩ wotoró beteró̧póló taaréni, a̧ ȩtamo beta̧mó beterapó. Ti noatepae, suka fea ya̧lo du betere alata, a̧ hȩkese yaaitere alatóró erótu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ama atéró yó mótu betale fo wosóló, mepaae so whi̧ a̧paae kisipa tiralepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Atéró, Yesuné a̧paae kisipa tiró betere mepaae Juda fake so whi̧paae duraalu, “Diaao̧tamo ya̧lo yó matere fo wosóló eró tapa, ti dia̧ mo ya̧lo yó matere so whi̧tóró beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Atéró, kale mo fo betekélé diaao̧ tuȩ́ duraalu, dia̧ dokóló moletei ai foné teraayóló ha̧le fó̧póló eraalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ai fo depa atimané a̧paae tokó̧ mótu duraalu, “Da̧ Abraham-né deale naalené deté wale whi̧rapeta, mo beta̧ whi̧né wae sóró kutó diratere whi̧kélé bitinipó. Tépatei, naao da̧paae dia̧ mené kutó diratere ala ini, ha̧le fó̧póló yaalopó dere fo-a, noa betené de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ai fo depa Yesuné duraalu, “Ya̧lo dia̧paae mo i dere ape. Mepaae so whi̧ detamo dowi ala ha̧le yó tapa, ti ai alané wae sóró kutó diratere so whi̧tóró beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ti ai so whi̧ta, beta̧ whi̧né deale naale senaale aleóló mo ti betenénipó. Tépatei, beta̧ whi̧né naalema a̧ beta̧ ai whi̧né amatóró deyaleteiné mo titóró betó tawaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Atérené kale Whi̧né Naalemanétamo dia̧ képiné kaae dokóló mole so whi̧ teraayóló ha̧le fó̧póló depa, ti dia̧ mo fótóró yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Dia̧ta, Abraham-né deale naalené deté wale whi̧rape betere ala ya̧lo tuȩ́rapó. Tépatei, ya̧lo fo dia̧ tua̧mó muniru, diaao̧ ȩ daai ai du betere ape. ");
INSERT INTO ppo_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ya̧lo i du betere fota, ya̧lo Ayatamo bitu kelale alatóró du beterapó. Atére kaae, dia̧né du betere alakélé, diaao̧ ayané dia̧paae yó matere alatóró ai du betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ai fo depa, atimané a̧paae duraalu, “Da̧né ayata Abraham-pó,” depa Yesuné duraalu, “Dia̧tamo Abraham-né naale senaale bitua̧sóró, ti ama yale alatóró sya fóló ua̧pó. ");
INSERT INTO ppo_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ya̧lo dia̧paae yó mótu betale fota, Kótóné ȩpaae depa wosale fotóró du betepatei, diaao̧ ȩ daai ketekȩ ai butu betere ape. Ti Abraham-néta, dia̧né ai dere ala kaae inipó. ");
INSERT INTO ppo_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Dia̧né ai du betere alarapeta, diaao̧ ayané yale alatóró sya fu beterapó,” yalepó. Téró atimané duraalu, “Da̧ta, o̧lémi nóló ho̧ko deyale naalerape meipó. Da̧né Ayata, Kótó a̧tóró beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tétepa, Yesuné atimapaae duraalu, “Kótó a̧ diaao̧ Ayatamo ua̧sóró, ti ȩpaae hȩkesené sinóló yaala sókó fole ala ua̧pó. Ti noatepae, mió ȩ i haepaae wóló dia̧tamo i betereteita, ya̧lo ko̧leaané ani, Kótóné ama ȩ dotonatepa walepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ya̧lo dere fo diaao̧ wosetutei, kisipa initere noa betené de? Ti aita ya̧lo fo wosóló, eraaire kisipa dia̧ tua̧mó muniru dapó. ");
INSERT INTO ppo_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Atérené dia̧ta, diaao̧ aya Satan-né ama fake so whi̧ bitu, ama kisipa mole ala eraai du beterapó. Ti a̧ta mo fo buniruraalu, mo take keké nale alimótei kaae sóró, whi̧ dilé wou betere sekȩ́pó. Atétu, ai kale fo wisi mo sawakélé a̧ tua̧mó munipó. A̧ta, kapala foné alima bitu, suka fea kapala fotóró dua dapó. Ti kapala fota, ama be fopó. ");
INSERT INTO ppo_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ya̧lo dia̧paae mo fo du betepatei, diaao̧ ya̧lo dere fo wosóló, mo dapóló kisipa tirótimipó. ");
INSERT INTO ppo_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ya̧lo etei kaae dowi ala yalepóló, dia̧kó beta̧ whi̧né ha̧kearóló enére? Ya̧lotamo dia̧paae mo fotóró yó mótu betepa, ti dia̧né ȩpaae kisipa tiki tiratere ala dumipó. ");
INSERT INTO ppo_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kótóné so whi̧néta, ti ama dere fo wosetu beterapó. Dia̧ta, Kótóné ama fake so whi̧ bitinireteiné ama fo wosetumipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tétepa, kale Juda whi̧rapené a̧paae duraalu, “Da̧né ya̧ta, Samaria whi̧kó dowi kepe tepeyóló beterapó dere kapala fo de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ai fo depa, Yesuné duraalu, “Ȩ tua̧mó dowi kepe tepeyóló bitinipó. Ȩta, ya̧lo Ayané doi beta̧ sóró horótu betepatei, diaao̧ ya̧lo doi haepaae só derótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ya̧lo du betere alata, ȩtei doasi doi muaai dapóló kisipa muóló dumipó. Ȩ doasi doi mulatere alata, mené eraai ketekȩ butu beterapó. Ti a̧ta, fo tokó̧ló taletere bete Talepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ya̧lo dia̧paae mo dapó. Mepaae so whi̧ detamo ya̧lo fo wosóló, sya fóló erótu betepa, ti ai so whi̧ sukó̧kélé mo yaalomeipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ai fo depa, atimané a̧paae duraalu, “Ya̧ tua̧mó dowi kepe fa̧ayóló mulu du betere alarape da̧né tuȩ́rapó. Ti noatepae, Abraham-kélé sukó̧o, mepaae take betale Kótóné ko̧ló whi̧rapekélé sukó̧o yalepó. Téyaletei, naao du, ya̧lo fo sya fóló eratere so whi̧ta, suka̧alo meipó ai dere ape. ");
INSERT INTO ppo_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ai fota, da̧né aya Abraham naao tȩteró beterapóló de? Ti Abraham a̧kélé sukó̧o, take betale Kótóné mepaae ko̧ló whi̧rapekélé sukó̧o, erapó. Térapa, naao kisipané ya̧ depóló de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ai fo depa, Yesuné tokó̧ mótu duraalu, “Ya̧lotamo ȩtei doasi doi muaaire ala depa, ti so whi̧né mo ala dapóló kisipa muaalomeipó. Tépatei, ya̧lo Aya dia̧ tȩteróló kaae tare Kótópó, du betere sekȩ́né ama beta̧ ya̧lo doi doasi mulatere ala du beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Diaao̧ta, ai sekȩ́ kisipanitei, ya̧lo beta̧ a̧ mo kisiparapó. Ya̧lotamo a̧ kisipanipó ua̧sóró, ti ȩ dia̧ kaae kapala fo dere whi̧ bitua̧pó. Téua̧tei, ya̧lo a̧ kisipa iruraalu, ama fokélé ya̧lo eró tarapó. ");
INSERT INTO ppo_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Diaao̧ aya Abraham-né ȩ waaire be dȩ sókó wó̧póló kaae taru, a̧ hȩkesené sukutu bitipakalepó. Téyaletei, ȩ wale ala ama kilitu, a̧ hai̧né sukó̧ló ama hosaa muni deyalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ai fo depa, atima Juda whi̧rapené a̧paae duraalu, “Ya̧ta, 50 ba fo kemenitei, Abraham naao ai kilirapó!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ai fo depa, Yesuné atimapaae duraalu, “Ya̧lo dia̧paae mo i dere ape. Abraham a̧kélé hamané deyaaipatei, ȩ mo taketi betere whi̧pó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Atétepa, atimané kapo durape sóró a̧ siróló daai yaletei, a̧ kelao̧sóró kikiti buté buté fóló, moma dere be bopére tipi taaróló, belapaae sókó doropóló felepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Atéró, Yesu a̧ tu̧mó fu betalemó, whi̧ beta̧ hamané depemótei kele dilikipa deale whi̧ betepa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Atépa, ama yó matere whi̧rapené a̧paae duraalu, “Yó matere whi̧-ó, i whi̧né kele dilikiretei, ama yale dowi alané erépé, hamaró alimatamoné yale dowi alané erémólópó?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ai fo depa, Yesuné duraalu, “I whi̧né ama kele dilikire alata, ama yale dowi alané ó hama alimané yale dowi alanékélé meipó. Aita, Kótóné fotoko̧né ama tiki tua̧mó ere ala wisiró betepa, nalo so whi̧ feané koló̧póló erapó. ");
INSERT INTO ppo_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Be dȩpatei ȩ dotȩyale whi̧né ama kutó da̧né ha̧le dirótu betenérapó. Mióta, be diki dere ala sókó waai ai dere ape. Atétere sukamó, whi̧ mo beta̧nékélé me kutó dinénipó. ");
INSERT INTO ppo_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ȩ i haemó ha̧le bituraalu, ti haemó betó mole so whi̧paae dȩrótu betere dȩta, ti ȩtórótipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ai fo yóló, Yesuné fesa̧a haepaae sókó deróló, hae ka̧ae sóró basa basa eróló, kale whi̧né kelemó dilalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Atéró a̧paae duraalu, “Naao dore kele u Sailoam wȩi kemó fokone fae,” yalepó. (Sailoam doiné bete feteyóló dotȩyalepó.) Ai fo depa, kale whi̧ a̧ fóló fokalemó, mo ti wisitepa, ama bepaae momó fesaae wouraalu, o̧la o̧la wisiyóló kelalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Atépa, ama be whi̧ so whi̧ró a̧ kele doyóló bitu, o̧la o̧la kema du betepa kelale so whi̧tamoné duraalu, “Ita, take kele doyóló bitu, o̧la o̧la kema du betale whi̧ hi̧ti irurapó?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tétepa mepaaené duraalu, “Me kae mei a̧tóró hi̧tipó depa mepaaené meipó, beta̧ kaae kelepaa daale whi̧ kae irurapó,” yalepó. Tétepa kale whi̧né amatei duraalu, “Take kele dilikiyóló bitu, o̧la o̧la kema du betale whi̧ta me kae mei, ȩtóró hi̧ti i ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ai fo depa atimané a̧paae duraalu, “Naao kele dilikiretei netéró wisiyaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tétepa ama duraalu, “Atimané Yesupó du betere whi̧né hae sóró basa basa eróló ya̧lo kelemó dilóló, Sailoam wȩimó fokone fae depa, fokale tikimó ya̧lo kele wisiyóló mió o̧la o̧la keletapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ai fo depa atimané a̧paae woseturaalu, “Ai whi̧ a̧ momó betere?” depa kale whi̧né duraalu, “A̧ momó beteréró ȩkélé kisipanipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Téró, atima mepaae whi̧rapené kale kele dilikiyóló betale whi̧ Farisi whi̧rape beterepaae dapesó walepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesuné kale kele dilikire whi̧ hae dilóló wisirale alata, sa̧a naai tukóló muló betere be dȩmó yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Atépa kale Farisi whi̧rapenékélé a̧paae woseturaalu, “Naao kele dilikiretei, netéró wisiyaleé?” depa, ama atimapaae duraalu, “Ya̧lo kelemó hae dilóló Sailoam wȩi kepaae fokone fae depa, ȩ fóló fokalemó ya̧lo kele wisiyóló, mió o̧la o̧la keletapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ai fo depa mepaae Farisi whi̧rapené duraalu, “I whi̧ta, Kótóné dotonale whi̧ meipó. Ti noatepae, sa̧a naai tukóló muló betere be dȩmótei, ama etei kaae kutó ditu beterapó,” yalepó. Ai fo depa, mepaae whi̧né duraalu, “Dowi ala du betere whi̧né etei kaae kelemei ala netéró eraaloé?” yóló atimasisi tekeyóló fo kae kae du betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Téró atima ai fo yóló kemetepa, kale kele dilikiyale whi̧ daalepaae fetée fóló duraalu, “Ai whi̧né naao kele wisiró beterapa, naao a̧ depóló kisipa mute?” depa, kale whi̧né duraalu, “A̧ta Kótóné ama ko̧ló whi̧kópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tétepa, ai kale Juda whi̧rapené a̧ take kele dilikiyóló betale whi̧tei, wisiró beterapóló kisipa tiréni, a̧ kae whi̧ nisiyóló ama hamaró alimatamo dapesene fó̧póló, mepaae whi̧rape dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Atéró, kale whi̧né hamaró alimatamo wóló betepa, Farisi whi̧rapené atimaamopaae woseturaalu, “Ita diaamoné kele dilikipatei deyalepó yale naale hi̧tié? Atéyaletei, mió ama kele wisiretei netéró yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ai fo depa, hamaró alimatamoné duraalu, “A̧ta da̧moné naalepó. Ama kele atéró dilikipa deyaletei da̧moné kisiparapó. ");
INSERT INTO ppo_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tépatei, ama kele wisirale whi̧ ó netéró wisiraleró da̧mokélé tuȩ́nipó. Ti a̧kélé disire whi̧pa, a̧ wisirale fo amatóró yó̧póló a̧paae wosae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kale whi̧né hamaró alimatamoné atéró yale fo ha̧le inipó. Yesu a̧ta, Kótóné so whi̧ tȩteróló kaae tanó̧póló, sóró beteró betere whi̧pó dere so whi̧ fo wosetere bepaae holao̧sóró, atima Juda whi̧rapené belapaae ho̧kó deraalopó ere fo atimaamoné wusuróraalu, witepa yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Atimaamoné a̧kélé disire whi̧pa, a̧paaetóró wosae yale fota ai betené yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Téró, Farisi whi̧rapené kale kele dilikiyale whi̧paae momó ape yóló duraalu, “Kótóné doi doasi muó̧póló yae. I sekȩ́ta, dowi ala du betere whi̧póló da̧né tuȩ́rapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ai fo depa kale whi̧kó duraalu, “A̧ta, dowi ala dere whi̧ ó initere whi̧ró ȩkélé kisipa inipó. Téretei, take ȩ kele dilikiyóló betaletei, mió ya̧lo kele wisiyóló keletere ala beta̧ ya̧lo kisiparapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Atétepa atimané a̧paae woseturaalu, “Naao kele wisiraai noa ala maaté yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ti fo depa ama atimapaae duraalu, “Take ya̧lo dia̧paae yaletei, diaao̧ woseni hó̧ralepó. Téyaletei, dia̧né momó noatepa wosaai de? Dia̧kélé ama yó matere whi̧rape betaai kisipa mute?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ai fo depa atimané a̧ faleyóló duraalu, “Ya̧ta, i sekȩ́né ama yó matere whi̧ airapó! Da̧ta, ti Moses-né yó matere whi̧rape beterapó! ");
INSERT INTO ppo_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Take Kótóné Moses-paae mo yalepóló da̧né kisiparapó. Tépatei, ai whi̧ wale tikikélé da̧ mo kisipanipa, a̧ deró kelae!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tétepa, kale whi̧né atimapaae tokó̧ mótu duraalu, “Ama ya̧lo kele wisirale alata, mo doasi alapó. Tépatei, a̧ wale tikikélé dia̧ tuȩ́nipó depa, ya̧lo doasi sira dapó. ");
INSERT INTO ppo_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ti noatepae, dowi ala du betere whi̧rapené dere fo Kótóné wosenitere ala da̧né kisiparapó. Téretei, ama tuȩ́ mole ala sya fóló, erótu betere so whi̧né dere fota, ti ama wosetua dapó. ");
INSERT INTO ppo_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mo take bitiré wale alimó, atéró kele dilikipatei detere whi̧ mené fisa̧ae faralepó dere fo mo wosókélé inipó. ");
INSERT INTO ppo_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kótóné i whi̧tamo dotonólua̧meisóró, ti ama beta̧ alakókélé erólua̧meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ai fo depa atimané a̧paae duraalu, “Ya̧ta, naao haeró ayatamoné dowi ala tua̧mó deyale whi̧nétei, ya̧ da̧ yó matere whi̧ betaai de?” yóló, a̧ foné sóró ho̧kó faralepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kale Farisi whi̧rapené kele wisirale whi̧ foné sóró ho̧kó faralepó, dere fo Yesuné wosóló, kale whi̧ keka̧lepó. Atéró kekó̧ló, keletepa a̧paae duraalu, “Ya̧ta, Whi̧né Naalemapaae kisipa tiró betere?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tétepa kale whi̧né a̧paae duraalu, “Doa whi̧-ó, ȩ a̧paae kisipa tiki tiraai dapa, ai whi̧ naao ȩpaae yó a̧lae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tétepa Yesuné a̧paae duraalu, “A̧ta, mió naao ai kelale ape. Mió ya̧tamo i fo du betere sekȩ́ ȩtóró i ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Téró kale whi̧né duraalu, “Tale-ó, mió ȩ ya̧paae kisipa tiróló i betere ape,” yóló a̧ Yesu daale ao̧mó bukutiri tea̧ró dua betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Téró Yesuné duraalu, “Ȩ i haepaae waleteita, mepaae kele dilikire so whi̧ wisiróo, wisire so whi̧né kele diliki yóo yó̧póló, taleyóló bukuraai walepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yesu a̧tamo felekemó daae mole Farisi whi̧rapené ama dere fo wosóló, a̧paae duraalu, “Naao ai dere fota, da̧kélé kele dilikirapóló de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tétepa Yesuné atimapaae duraalu, “Dia̧tamo dia̧ kele dilikirapó ua̧sóró, ti dia̧né du betale dowi alamó dia̧ só derólua̧meipó. Tépatei diaao̧ duraalu, dia̧né kele wisirapó dereteiné diaao̧ dowi ala ha̧le ai mole ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Téró Yesuné duraalu, “Ya̧lo dia̧paae mo i dapa wosae. Mepaae whi̧ de kale sipsip hupurape betere tipi tu̧mó sókó wéni, dȩmó fulukóló sókó hotepa, ti o̧lémi nokole whi̧ró hupu doraai wale whi̧tamo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Téretei, whi̧ me de kale sipsip hupurape betere tu̧mótóró sókó hotepa, ti hupu tale ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kale sipsip hupurape me ala yao̧sóró, tu̧ sereke kaae tare whi̧né ai sipsip hupu tale tipi tua̧paae wó̧póló tu̧ tuki̧tepa, ti ama fo nakome hupurapené wosetua dapó. Atéró, kale sipsip hupurape fea doi yósu enalemó, ama fo wosóló wapa, ti belapaae olosó fua dapó. ");
INSERT INTO ppo_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Atéró, kale hupu talené ama hupurape fea belapaae dapesó doropóló, ama ki̧limó woleyóló fua dapó. Ti noatepae, kale hupurapené ama fo nakome wosóló tuȩ́rapó. ");
INSERT INTO ppo_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tépatei, mo whi̧né fo nakome woseturaalu sya feni, atima botokótei faalopó. Ti noatepae, ai hupurapené a̧ kae whi̧póló tuȩ́rapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuné atimapaae ai dó faróló yale fo bete atima sini, ko̧ló ko̧ló du betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Atétepa Yesuné atimapaae ha̧kearóló duraalu, “Ya̧lo dia̧paae mo i dere ape. Sipsip hupu fua wua dere tu̧ sereketa, ti mo ȩtórótipó. ");
INSERT INTO ppo_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ȩ waaipatei, take wua yale whi̧rapeta, ti o̧lémi nokole whi̧ró o̧la o̧la fasóló sere whi̧rapetamo ai ape. Tépatei, kale sipsip hupurapené atima dere fo wosenipó. ");
INSERT INTO ppo_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kale hupurape fua wua dere tu̧ sereketa, ti mo ȩtórótipó. Mepaae whi̧ de ȩ tua̧mó sókó fupa, ti me o̧lané a̧ doratere ala ini, tao saalopó. Atétere whi̧ta, belapaae nerape nale fua, tipi tua̧paae hotua du betaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ti o̧lémi nokole whi̧rapeta, ha̧le wómipó. Kale sipsip hupurape o̧lémi dóló sóró fóo, hupurape dóló doróo, yaairaalu wua dapó. Téretei, ȩ waleteita atima sukutere ala tua̧mó beteretei taaróló, ti betere bete mo turó só̧póló kisipa mutu walepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Kale sipsip hupu kaae tawóló asare whi̧ wisinaaleta, ti mo ȩtórótipó. Hupurape me ala yao̧sóró, tao saai ya̧lo betere bete me o̧la meipóló ȩ sukunérapó. ");
INSERT INTO ppo_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Me dupu saai kisipa muóló hupu kaae tatere whi̧ta, sipsip hupu tale meipó. Atétere whi̧ta, hupu dóló nokole bete hao̧ wale kilitu, hupurape dóló nó̧póló taaróló a̧ botokó faalopó. Atétepa kale bete hao̧ wouraalu, sipsip hupurape dóló sesaape deremó, mepaae hupu botokó dapo dapo yaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ti noatepae, ai kaae tare whi̧ a̧ sipsip hupurape kisipa muni, dupu saai kisipa muóló kaae tareteiné hupurape taaróló, botokó fua dapó. ");
INSERT INTO ppo_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ȩta, sipsip hupurape kaae tawóló asare whi̧ ereteiné, hupurape ya̧lo kisipa yóo, hupurapenékélé ȩ kisipa yóo erapó. ");
INSERT INTO ppo_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Até irure kaae, Ayané ama ȩ kisipa yóo, ya̧lo Aya a̧ kisipa yóo, erapó. Ya̧lo betere bete me o̧la meipóló suka̧aireteita, sipsip hupurape kisipa mutu, tao saairaalu sukunérapó. ");
INSERT INTO ppo_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","I tipi tua̧mó betere hupurape maaté tao saai mei, ya̧lo hupurape mepaae kae betó mulapó. Ai hupurapekélé fea ya̧lo dape sóró, i betó mole hupurapetamo touróló beta̧mó beteraalopó. Tétepa, ai hupurapenékélé ya̧lo dere fo wosaalopó. Tétu, sipsip hupurapekélé mo beta̧tóró betóo, kaae tare whi̧kélé beta̧tóró betóo, yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ya̧lo betere bete tokó̧ sóró sukutepa, ȩ momó kepaayóló betaalopóló kisipa mutu, ya̧lo betere bete matereteiné ya̧lo Ayané ama ȩpaae yaala sókó fóló mulapó. ");
INSERT INTO ppo_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Whi̧ beta̧nékélé ya̧lo betere bete tokó̧ seni, ya̧lo ko̧leaanétei matapó. Ȩ sinitere alakélé, kepaayóló betaaire alakélé, naaotei tȩteróló kaae tawae yóló, ya̧lo Ayané ȩpaae maleteiné ya̧lo tȩteróló kaae tarapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kale Juda so whi̧né ai dere fo woseturaalu, atima fea beta̧ kisipa muni, mepaaené fo kae yóo, mepaaené fo yóo, du betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Atétu, mepaae turó so whi̧né duraalu, “Ai whi̧ tua̧mó dowi kepe fa̧anuraalu, topo doyóló du betere fo diaao̧ noatepa wosetu bitu de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ai fo depa mepaae so whi̧né duraalu, “Dowi kepe tepeyóló betere whi̧né etei kaae fo dumipó. Dowi kepe tepeyóló betere whi̧né kele dilikire so whi̧ su̧mó wisiranére?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Téró, Jerusalem be tua̧mó Juda fakené moma dere be mo take bóe whi̧né doraalotei, momó wisiróló o̧la deyaai tukóló muló betere be dȩ sókó walepó. Atéró o̧la detere alata, sosóli alimó yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Atéyale sukamó, moma dere be belamó tȩne Solomon-né doi mole be tokwȩimó Yesu a̧ kutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Atétepa, Juda so whi̧né Yesu bopera̧le wóló, a̧paae duraalu, “Naao da̧paae yó melaai yale fo yó melaalo nisiyóló kaae tawale supa, ya̧tamo so whi̧ tȩteróló kaae tanó̧póló Kótóné sóró beteró betere whi̧ Kerisopata, ti da̧paae ha̧kearóló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ai fo depa Yesuné atimapaae tokó̧ mótu duraalu, “Take ya̧lo dia̧paae yaletei, dia̧né tuȩ́ tiki tirénipó. Ȩ etei kaae whi̧póló diaao̧ kisipa tiró̧póló, Ayané doimó ya̧lo i kelemei alarape du beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Tépatei, dia̧ ya̧lo sipsip hupu bitinireteiné, ȩpaae kisipa tiró bitini ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ya̧lo sipsip hupurapené ya̧lo fo wosetua dapó. Ai hupurape atimakélé ya̧lo tuȩ́ yóo, atimakélé ȩ sya wóo, du beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ya̧lo atimapaae mo ti betere bete matereteiné atima sukó̧ló alukélé mo yaalo meipó. Ai so whi̧ atima ya̧lo naase tua̧mó betepa, me whi̧né fasó sere alakélé mo enénipó. ");
INSERT INTO ppo_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ai sipsip hupurape ya̧lo naase tua̧mó beterale sekȩ́ ya̧lo Aya a̧ta fotoko̧ bole Tale bitu, fea whi̧raperó kae kae keperapetamo ama tȩteró beterapó. Atéreteiné atima ya̧lo Ayané naase tua̧mó betepa, me whi̧nékélé mo fasó senénipó. ");
INSERT INTO ppo_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ya̧lo Ayané ama ere ala ó mole tuȩ́kélé kae mei, da̧mo wusuró mo beta̧ alatóró erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ai fo depa wosetu, kale Juda whi̧rapené momó kapo du sóró, a̧ siriyóló daai yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Atétepa, Yesuné atimapaae duraalu, “Ya̧lo Ayané ȩpaae erae depa, kae kae kelemei ala eralepó. Téyalepa, mé erale kelemei alarapemó, diaao̧ ȩ kapo duné siróló daai de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ti fo depa Juda whi̧rapené a̧paae tokó̧ mótu duraalu, “Naao ai eratere alamó ya̧ kapo duné siriyóló daai dumipó. Ya̧ta mo whi̧tei, Kótópó du betere foné Kótó faletu betepa, ya̧ daai dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tétepa, Yesuné atimapaae tokó̧ mótu duraalu, “Dia̧né tukóló muló betere foné dia̧ta, kótórapepóló take ya̧lo dia̧paae inié? ");
INSERT INTO ppo_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kótóné asȩmó ere fo tua̧mó tekeyóló mepaae wosóo, me kwiapaae woseni sisópaae eróo, dere ala mo enénipó. Ama fo wosale so whi̧paae dia̧ta, kótórapepó depa, ti i haepaae wó̧póló Alima Kótóné kae beteró betere naalepaae noa fo enére? ");
INSERT INTO ppo_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Atépa, ya̧lo Ayané ȩ ama naalepóló sóró kae beteróló, i haepaae dotonalepó. Atérené ya̧lo duraalu, ‘Ȩta Kótóné naalemapó’ dere fomó, Kótó faletapóló diaao̧ ȩ só deróló ha̧le o̧la kaae ao̧rótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ya̧lotamo, Ayané ama erae dere ala erénitepa, ti dia̧né ya̧lo dere fo wosóló, ȩpaae kisipa tirao̧se. ");
INSERT INTO ppo_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tépatei, ya̧lo Ayané erae dere ala erateremó, diaao̧ ȩpaae kisipa tiratere hó̧tepa, ti mepaae eratere kelemei alarape kisipa tirae. Atétepa, ti ya̧lo Aya a̧ ȩ tua̧mó betóo, ȩkélé a̧ tua̧mó betóo, ere ala bete diaao̧ wisiyóló kisipa yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ai fo depa, atimané take yale kaae Yesu tawóló dipula beteraai yalemó, a̧ ai tua̧mótei sókó deyóló felepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Atéró Yesu a̧ Jordan wȩi tȩyóló, ama yó mótu betere ala kaae sale tikipaae momó biti̧ felepó. Aita, take Jon-né so whi̧ fea wȩi tópurótu betale tikipó. ");
INSERT INTO ppo_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Atéró fóló beteremó, so whi̧ mo dékéró a̧ beterepaae wóló duraalu, “Jon-néta, kelemei ala mo beta̧kélé eratepa kilinipó. Ténitei, ama i whi̧ kisipa muóló yale fo fea motóró erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Atima ai betó mole tikimó, mepaae so whi̧ fea Yesupaae kisipa tiralepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Téró, Betani be whi̧kó ama doi Lasarus a̧ kisiné sukó̧ló molepó. Ai be huluata, Maria ama kema Martasépi atimané turuku bepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ai so Mariata, kale kisiné sukó̧ló mole whi̧ Lasarus-né nemapó. A̧ta, Talené ho̧leke tómó felé kȩlaa wale wel wȩi suniyóló, ama topo nikinétei helekó̧ló kópurale sopó. ");
INSERT INTO ppo_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kale whi̧né ama nema tamoné Yesupaae duraalu, “Tale-ó, naao hosaa mole fulumu whi̧ kisiné sukó̧ló mulapó,” fo yó faralepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ai fo Yesuné wosóló duraalu, “A̧ta, ai daale kisiné ama betere ala mo ti kemeraalo meipó. Ai kisita, Kótó Naalemané Alimané ere ala wisi ha̧kearatepa, so whi̧ feané koló̧póló erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Martakélé, ama kema Mariakélé, atimaamoné nema Lasarus-kélé, Yesuné ama hosaa mulu, yaala sókó fóló molepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Atépatei, ama noma Lasarus kisiné sukó̧ló mulapó dere fo wosóló, Yesu a̧ hapale feni, be dȩ tamo ha̧le beterepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Téró ama yó matere whi̧rapepaae duraalu, “Da̧ Judia hae kwiapaae momó fesaae faalopa fiépe,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ai fo depa, atimané a̧paae duraalu, “Yó matere whi̧-ó, dóti atima Juda whi̧rapené ya̧ kapo duné siróló daai yale tikipaaetei, momó fesaae faai de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tétepa Yesuné duraalu, “Beta̧ be dȩ tua̧mó kutó ditere 12-ró suka kele munié? Dȩ tua̧mó kotere whi̧ta, me o̧lané hó kotóo sóró déekélé naalomeipó. Ti noatepae, ai whi̧ a̧ta i haemó ere dȩtamo kutu beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Téretei, diliki tua̧mó kotere whi̧ta, kotóo sóró dée nukua dapó. Ti noatepae, a̧ dȩ tua̧mó konitereteinépó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesuné ai fo yale ki̧lipaae ama atimapaae duraalu, “Da̧né fulumu whi̧ Lasarus a̧ noke fipa turukuraai ȩ fulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ai fo depa, ama yó matere whi̧rapené duraalu, “Tale-ó, a̧tamo mo noke fipa, ti ama ha̧le wisiyaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesuné amata, kale whi̧ mo ti sukunapó yaletei, ama yó matere whi̧rapené ti mo noke fipa dere nisiyalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Atétepa, Yesuné atimapaae ha̧kearóló duraalu, “Lasarus-ta, mo ti sukunapó. ");
INSERT INTO ppo_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Atei alata, dia̧ kisipa tiró̧póló ȩ a̧tamo beta̧mó betepa iniyaleteiné ya̧lo mo kée dapó. Térapa, da̧ a̧ kelaai faalopa fiépe,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas-tei ama doi Didimas-pó du betere whi̧né mepaae yó matere whi̧rapepaae duraalu, “Da̧kélé a̧tamo beta̧mó suka̧ai faalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Téró, Yesu a̧ Betani bemó sókó fóló kelalemó, kale whi̧ Lasarus douró betepa, dou̧ró be dȩrape kemeipakalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ai Betani bemó kaae sóró, Jerusalem bepaae foleteita, saletó mei, 3 kilomita maatépó. ");
INSERT INTO ppo_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Atérené, Juda hae kwiamó betó mole so whi̧ mo turó Mataró Mariatamoné nema Lasarus suka̧leteiné atimaamo dekȩné sukao̧sóró, ko̧leó yóló moló bemó fea betaai walepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Atéró, Yesu a̧ tu̧mó wou beterapó dere fo Matané wosóló, a̧tamo hokolaa yaai fupatei, Maria a̧ bemó ha̧le beterepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Atéró fóló, tu̧mó hokolaa yóló, Martané Yesupaae duraalu, “Tale-ó, ya̧tamo imó bitua̧sóró, ti ya̧lo ne sukua̧meipó. ");
INSERT INTO ppo_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tépatei, naao noa alakó Kótópaae wosetepa, ti ama mo miótóró eraalopóló kisipa mutapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ai fo depa, Yesuné kale sopaae duraalu, “Naao neta momó kepaayóló betaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tétepa Martané duraalu, “Take kemetere sukamó so whi̧ fea kepaaturaalu, a̧kélé kepaayaalopóló ya̧lo kisiparapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ai fo depa, Yesuné kale sopaae duraalu, “Kepaayaaireteiró betere betetamota, ti mo ȩtórótipó. Whi̧ me de ȩpaae kisipa tiró betere tua̧mó a̧ sukutepa ti aluni, ha̧le betó tawaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mepaae so whi̧ de mo bitutei, ȩpaae kisipa tiratepa, ai so whi̧ sukó̧kélé mo yaalo meipó. Naao ya̧lo i dere fo wosóló, mo dapóló kisipa tiki tirate?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tétepa kale soné duraalu, “Tale-ó, ya̧ta so whi̧ fea tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ Kerisopó dere fo mo dapó. Ya̧ta i haepaae waalopóló bopetu betale whi̧ Kótóné Naalemapóló, kisipa tiratapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Matané ai fo yóló kemetepa, a̧ fesaae fóló kema Mariapaae ape yóló, dȩpaae dapesó fóló duraalu, “Hama-ó, kale yó matere whi̧ wóló daalu, ya̧-ó dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ai fo depa, Mariané a̧ hapale turukó holóló, Yesu daalepaae felepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Atéyaletei, Yesu ai be huluapaae hapale sókó feni, Mata atimaamo hokolaa yóló, fo du betale tikimótóróti ha̧le daalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Atéró, Mariapaae ko̧le-ó, yaai wale Juda fake so whi̧ fea a̧tamo be dolomó betó mualetei, a̧ turukó daalóló fupa, nema molóne fole nisiyóló atimakélé a̧ sya felepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Atéró, Maria a̧ Yesu daale tikimó sókó fóló a̧ kelalepó. Atéró, ama hó ao̧mó deraapisa fóló fiyó mulu duraalu, “Tale-ó, ya̧ imó bitua̧sóró, ya̧lo ne sukua̧meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Atéró, Yesuné Maria wole dere ala kolóo, a̧tamo wale Juda so whi̧kélé wole yóo, depa kilitu, ama hosaa tua̧mó doasi dekȩné sukutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","35","Atétepa, ama atimapaae woseturaalu, “Diaao̧ a̧ momó douraleé?” depa, atimané duraalu, “Tale-ó, kelaasepóló ape,” yalepó. Ai fo deremó, Yesu a̧kélé wole yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yesuné atéró wole depa kale Juda so whi̧né duraalu, “Ama hosaa mole whi̧ sukutepa wole ai dere kelere?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Téyaletei atima mepaae so whi̧né duraalu, “I whi̧né take kele dilikire whi̧ wisirótu yale kaae, i sukó̧ló mole whi̧ wisi erénitupó?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Atéró Yesu a̧ kale yale kaae, momó ama hosaa tua̧mó doasi dele duraalu, dou tópaae walepó. Téyalemó, a̧ dourale kane dolo tu̧ doakale kane fakené kinó betepa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Atépa, Yesu sókó wóló duraalu, “Ai kinó betere kane fake sókó sóró mulae,” yalepó. Ai fo depa, kale sukó̧ló mole whi̧né nema Matané duraalu, “Tale-ó, téyaalotei a̧ douró betepa, be dȩ dou̧ró kemeyaleteiné mió dowi kȩlaa sókó waalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ai fo depa Yesuné duraalu, “Naaotamo kisipa tiki tiratepa, ti Kótóné mo kae ere ala wisinaale kelaalo ai ape, fo ya̧lo ya̧paae inié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Atétepa, kale kinó betere kane fake atimané sókó sóró mulalepó. Téró, Yesu a̧ ó sa̧paae kese holóló duraalu, “Aya-ó, ya̧lo moma dere fo naao wosóló, eratereteiné ya̧paae mo kée dapó. ");
INSERT INTO ppo_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ti noatepae, betere doko̧ fea ya̧lo kematere fo naao wosóló, erótu betere ala ya̧lo tuȩ́rapó. Téretei, ya̧lo i dere fota, i daae mole so whi̧né etei ala kilituraalu, ȩ naao dotonó beterapóló atima tuȩ́ tiki tiró̧póló dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Atéró ai fo yóló kemetepa, ama fo fakeyóló duraalu, “Lasarus-ó, ya̧ ipaae tóȩ ape!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tétepa, kale sinale whi̧ belapaae tóȩ wouraalu, ama hó naasekélé, kelepaakélé, boperóló mulale dȩi linen kutiné bope yóo, ama kelepaakélé kutiné husuróo, epatei sókó walepó. Atétepa, Yesuné atimapaae duraalu, “A̧ kwȩyó̧pólópa, ama tikimó ai bopere kuti teraae falae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Atétepa, Mariapaae ko̧le-ó yóló, a̧tamo betaai wale Juda fake so whi̧ fea Yesuné ai yale ala kolóló, a̧paae kisipa tiki tiralepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Téyaletei, Mariapaae ko̧le-ó yaai wale whi̧rape atimakó mepaae Farisi whi̧rape beterepaae fóló, Yesuné yale alarape fea yó malepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Atéró, mo so whi̧mó momaratere topo whi̧raperó Farisi whi̧rapetamoné mepaae taleratere whi̧rapepaae ape yóló, touróló fo kȩlaaróló atimapaae duraalu, “I whi̧né ama du betere ala taaló̧póló depatei, ai whi̧né taalaaire mo su̧ni, Talené dapó yó̧póló, eratere kelemei alarape fea du beterapó. Térapa, da̧né noa alakó yaaloró, tuȩ́ tekeyaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Da̧nétamo ama i ala du beteró̧póló kaae tapa, ti so whi̧ feané a̧paae tuȩ́ tiki tiraalopó. Atéturaalu, Rom Gavman whi̧rape wóló, da̧ betere beró da̧né tȩteróló kaae tare hae kwiatamo fasó saalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Atéró, ai ba fomó atimakó whi̧ beta̧ ama doi Kaiapas, a̧ so whi̧mó Talepaae momaratere doasi topo whi̧ beterepó. Ai sekȩ́né atimapaae duraalu, “Diaao̧ ai dere fota, dia̧ tuȩ́ iniru whaalia depa ho̧ko fo dapó. ");
INSERT INTO ppo_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Da̧ Juda fake so whi̧ fea aluyao̧sóró, beta̧ whi̧ sukutepa wisirapó kisipa muni airapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ai fota, amatei kekeme nóló ini, ai ba fomó a̧ so whi̧mó Talepaae momaratere topo whi̧ bitu, Juda fake so whi̧ tao saairaalu, Yesu suka̧aire ala Kótóné ko̧ló whi̧né dere fo kaae ama tikati yóló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yesu a̧ suka̧aire alata, ai Juda fake so whi̧ maaté tao saai meitei, Kótóné ama naale senaale i hae kwiamó dapo dapo yóló, kae betó moletei, fea touróló mo beta̧ faketóró aleróló beteraalopó. ");
INSERT INTO ppo_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Atéyale be dȩmótóró kaae sóró, kale Juda topo whi̧rapené Yesu daairaalu, kikiti fo dokóló mulalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Atéreteiné Yesu ai Juda hae kwiamó momó kae ha̧keamó kuni, ai hae taaróló, so whi̧kélé bitinire ha̧le kópu ka̧ae fi hae kwia felekemó tȩne Epraim be huluamó, ama yó matere whi̧rapetamo fea beterepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Atéró, Juda fake so whi̧né kale boseneyóló fele be dȩmó o̧la detua dere be dȩ felekemó sókó waai depa, kae kae be huluamó betó mole so whi̧ fea atima betere tiki taaróló, Jerusalem bepaae holalepó. Aita ha̧le meipó. Talené keletómó atima wisirapó yó̧póló, momatere bemó kae kae fokotere ala yaai holalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Atéró fóló bitu kale so whi̧né Yesu momó beterérópóló kikitu betalepó. Atéró moma dere be belamó daae mulu atimasisi duraalu, “Diaao̧ kisipané a̧ i o̧la deterepaae waalopé meié?” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aita, ha̧le inipó. So whi̧mó momaratere topo whi̧raperó Farisi whi̧rapetamoné mepaae whi̧rapepaae duraalu, “Dia̧kó me whi̧nétamo a̧ keletepa, ti tawóló dipula beteraalopa, atimapaae ene ape yóló mulaleteiné,” ai fo yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Atéró, kale boseneyóló fele be dȩmó o̧la deyaairaalu, apo miró be dȩ ha̧le mupatei, Yesu a̧ ama kepaarale whi̧ Lasarus-né turuku be Betanipaae sókó walepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ai bemó atimané Yesu hȩkeseróturaalu, a̧mó o̧la deralepó. Ama nema Lasarus-kélé o̧la nokole ni fake tómó Yesutamo betepa, ai deyale o̧la Martané atimamó a̧liróló malepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Téró, Mariané doasi moniné duputere felé kȩlaa wale nard wel wȩi wuti fa̧apa sóró wóló, Yesuné hómó suniyalepó. Atéró ama topo nikinétei, kale wel wȩi fȩ heleka̧lepó. Atéyale tikimó, atima betere be dolokélé, felé kȩlaa feyó feyóró walepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Téyaletei, Yesuné ama yó matere whi̧rapekó Iskariot be whi̧kó Judas-né kale so foné sóró duraalu, “Ai o̧la ha̧le noatepa besekéraleé?” yalepó. Ti ai sekȩ́ta, take nalo Yesu dó̧póló eleké deyaaire whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Téró ama duraalu i felé kȩlaa wale wel wȩi wisinaaleta, dotonóló 300 silpa moni sóró, mepaae yolealere so whi̧mó meniyólópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ai fo yaleteita, yolealere so whi̧ mo tao saai kisipa muóló inipó. Ti noatepae, atimané beta̧paae touróló mulótu betere moni ama tȩteróló kaae taru, a̧tei o̧lémi sua yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ai fo depa, Yesuné duraalu, “Ai soné ama felé kȩlaa wale wel wȩita, Kótóné mo taketitei i ala yó̧pólópó yóló muló betepa, ama mo wisiyóló kaae taté wóló, mió ȩ douraaire suka felekemó ai ala dapa, seséni ama yó̧póló taalae. ");
INSERT INTO ppo_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ti noatepae, ai yolealere so whi̧ta, dia̧tamo suka fea betó tawaalopó. Téyaalotei, ȩta, dekéró be dȩmó dia̧tamo betaalo meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Atéró, kale Juda fake so whi̧né Yesu Betani bemó beterapó dere fo wosóló, a̧ kelaai dapóló touralepó. Atéró touraleteita, Yesu maaté kelaai mei, Lasarus mo ti suka̧letei, Yesuné kepaaralepó depa, kelaairaalu walepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Atétepa, mo so whi̧mó momaratere whi̧rapené Lasarus-kélé daai dapóló fo deyalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ti noatepae, Lasarus kepaarale ala atima Juda fake whi̧rapené kilituraalu, mo so whi̧mó momaratere whi̧rape taaróló, Yesupaae kisipa tiki tiraté fu betepapó. ");
INSERT INTO ppo_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Atéró, hi̧ka be dȩtepa Yesu Jerusalem bepaae wou beterapó dere fo ai o̧la naai touró betere so whi̧né wosalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","A fo wosetu, a̧tamo tu̧mó hokolaa yaai sapo da̧arape tao diliki yóló, i fo fakeyóló deté fu betalepó. “Hosana! Talené doimó wale whi̧ wisinaale Kótóné wisiró̧póló yae. Israel fake so whi̧ tȩteróló kaae tare doasi topo whi̧ Talené wisiró̧póló yae,” deté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Atéró Yesu a̧ faairaalu, beta̧ utu̧ donki hupu sóró ai hupuné sisó tómó betalepó. Ama ai yale alata, kale asȩmó i yóló muló betere fo motóró dokonalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saion be huluamó betó mole senaalerape-ó, mió dia̧ tȩteróló kaae tare doasi topo whi̧ utu̧ donki hupuné sisó tómó betóló ai walapa kelere?” erapó. ");
INSERT INTO ppo_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ai yale alarape fea ama yó matere whi̧rape atimanékélé kelaletei, bete hapale sóró kisipanipó. Ténitei, Yesu a̧ kepaayóló hepen-paae fóló, ama ere ala wisinaale ha̧kearale ki̧lipaae ti atimané a̧paae erale alarapeta, Kótóné asȩmó ere fo dokonó beterapóló kisipa mualepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Téró, kale Lasarus dou dolomó mupa, Yesuné kepaaratepa kelale so whi̧né ai yale ala fea deté fóló fakeralepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yesuné ai kelemei ala eralepó, depa wosale so whi̧ mo turó ai be hulua taaróló, a̧tamo hokolaa yaai dapóló felepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Atétepa, kale Farisi whi̧rape atimasisitei duraalu, “Da̧né du betere alarape fea mo ao̧kélé inipó. Ti ama dere alamó, i haemó betó mole so whi̧ mo feané a̧tóró ai sya fu betere kelere!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Atéró, o̧la deyaai tukóló muló betere be dȩ sókó wapa, Kótóné doi sóró holóló moma yaai Jerusalem be huluapaae hotere so whi̧tamo, mepaae Krik fo bole so whi̧ atimakélé fea touyóló holalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Téró, kale Krik fo bole so whi̧ atima Kaleli haemó tȩne Betsaida be whi̧kó Filip beterepaae fóló, a̧paae woseturaalu, “Doa whi̧-ó, da̧ta Yesu kelaai walepa, naao da̧ a̧ beterepaae dapesó faaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ai fo depa Filip a̧ wóló Andrupaae depa, Andru atimaamo wusuró fóló, Yesupaae yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ai fo depa Yesuné atimapaae duraalu, “Kale Whi̧né Naalemané ere ala wisi ha̧kearaaire suka mió mo felekemó sókó waai dapó. ");
INSERT INTO ppo_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ya̧lo dia̧paae mo dapó. Kale whit ke haepaae taae derepeletei kȩlaayóló alunitepa, ti ai ketóró ha̧le muó tawaalopó. Téni, ai ke kȩlaayóló alutepa, ti tu̧mu sokóló, du mo dekéró woleyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mepaae whi̧ de ama betere bete me ala yao̧sóró, amatei hotowaró kaae tapa, ti ai whi̧né betere bete aluyaalopó. Tépatei, mió i alimó mepaae whi̧ dené ama betere bete doratepakélé me o̧la meipó dere whi̧ta, mo ti betó tawaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mepaae ya̧lo ala erótu betere so whi̧ta, ti mo ȩtóró sya wonérapó. Atétere so whi̧ atimakélé ȩ betere tikimótóró beta̧mó betaalopó. Mepaae so whi̧ detamo ya̧lo kutó dirótu betepa, ti atétere so whi̧né doi ya̧lo Ayané sóró horóló, dukiraalopó. ");
INSERT INTO ppo_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Mió ya̧lo hosaa tua̧mó doasi sekȩné sukutapa, noa fokó yaaloé? Aya-ó, i be dȩmó ȩpaae eraaitere ala seséyóló ȩ tao sae fo enére? Mió ȩpaae eraaire ala mo eró̧póló, ȩ wóló i betere ape. Aya-ó, naao ere ala wisi so whi̧ feané koló̧póló ha̧kearae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Yesuné ai fo depa, hepen bemó fo fakeyóló duraalu, “Ya̧lo ere ala wisi ha̧kearó beteretei, mo turó kolóló tuȩ́ yó̧póló, ya̧lo momó ha̧kearaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ama atéró dere fo aimó touró betere so whi̧né wosóló, mepaaené duraalu, “Aita, be sapalaa dorowou yalepó,” depa, mepaae so whi̧né duraalu, “Meipó. Aita, ensel-né a̧paae fo du yalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ai fo depa Yesuné duraalu, “Aita, ȩ tao saai ini, dia̧ tao suraalu yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ti noatepae, i hae so whi̧tamo fo tokó̧ló dowi kwia melaaire be dȩ mió mo felekemó sókó waai dapó. I hae tȩteróló kaae taru, doasi topo whi̧ betaai dapóló wóputu betere sekȩ́ mo felekemó ho̧kó faraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Téyaalotei, ȩ ó sikipaae só horatere sukamó, ai so whi̧ fea ȩ beterepaae wó̧póló, a̧lisóró waaire ala eraalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ama ai yale fota, a̧ sukuturaalu yaaire ala ha̧kearalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Atei fo depa kale so whi̧né duraalu, “Kótóné asȩmó ere foné i so whi̧ fea tȩteróló kaae tanó̧póló, sóró beteró betere whi̧ mo ti betó tawaalopó erapó. Ai fo epatei, ‘Whi̧né Naalema sikipaae só horaalopó dere-a, netéró de?’ Whi̧né Naalemapó dere fo demó de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ai fo depa Yesuné atimapaae duraalu, “I dȩtereta, sawa sukamó maaté dia̧tamo betaalopó. Atéyaalopa dia̧ mepaae furaalu, tu̧ tua̧mó be dikiyao̧sóró dȩpatei fae. Mepaae so whi̧ de diliki tua̧mótamo kutu betepa, ti a̧ fole tikikélé ama wisiyóló kisipa yaalomeipó. ");
INSERT INTO ppo_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mió kale dȩ dia̧ tua̧mó etéró dȩró betere félitei dia̧ ai dȩterené naale senaale betaasepóló, a̧paae kisipa tirae,” yalepó. Ama ai fo yóló kemetepa, ai so whi̧né a̧ kelao̧sóró, atima betó mupatei taaróló, Yesu a̧ kikiti kinóló betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Téró, Kótóné dapó yó̧póló, Yesuné mepaae kelemei alarape eratepa so whi̧ feané kelaletei, atimané a̧paae kisipa tiki tirénipó. ");
INSERT INTO ppo_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Atéyale alata, Kótóné fo eratere ko̧ló whi̧ Aisaiané i asȩre fo dokonalepó. “Tale-ó, da̧né yó matere fo némaaté wosóló kisipa tiki tiraleé? Talené ama fotoko̧né yale ala depaae maaté ha̧kearóló yó malee?” erapó. ");
INSERT INTO ppo_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ti noatepae, Yesupaae atimané tuȩ́ tiki tirénire beteta, Aisaiané i asȩre fotóró dokonóturaalu erapó. ");
INSERT INTO ppo_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kótóné atima kele dilikiróo, hosaakélé ta̧róo yale beteta, atima yale ala kilitu, tuȩ́ tiki feteyóló wapa, ama wisirao̧sóró kisipa mutu yalepó,” erapó. ");
INSERT INTO ppo_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesuné ai ere ala wisinaale Aisaiané ama kelaleteiné ai fo asȩ ipakalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Atéró, kale Juda topo whi̧rape mepaae Yesupaae kisipa tiki tiralepó. Téyaletei, mepaae Farisi whi̧rape kolóló atima wituraalu, a̧paae kisipa tiki tirale ala ha̧kearóló yó menipó. Ti noatepae, fo wosetere be tua̧paae fenalemó, atima dóló ho̧konao̧sóró kisipa mutu yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ti noatepae, atimané dere wisi alamó, mo so whi̧né dukiratere fo wosaai ekȩle duraalu, Kótóné atima dukiratere fo wosaaire ekȩle ini, sisópaae erótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Téró, Yesuné fo fakeyóló duraalu, “Mepaae so whi̧ de ȩpaae kisipa tiki tiratepa, ti ȩpaae maaté tirótimitei, ȩ dotȩyale sekȩ́paaekélé, kisipa tiratapó. ");
INSERT INTO ppo_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mepaae so whi̧ dené ȩ keletepa, ti ȩ dotȩyale sekȩ́tóró ai keletere ape. ");
INSERT INTO ppo_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Até ereteiné ȩ i haepaae waleteita, ȩpaae kisipa tiki tiró betere so whi̧ diliki tua̧mó betere ala taaróló, dȩ tua̧mó beteró̧póló, i haemó dȩró betaai walepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ya̧lo fo wosóló erénitere so whi̧ta, ya̧lotei fo tokó̧ló só derótimipó. Ti ȩ waleteita, i haemó betó mole so whi̧ taleyóló só deraai wéni, atima aluyao̧sóró, tao saai walepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Whi̧ me de ya̧lo fo woseni, ȩ hó̧rótu betepa, ti ai whi̧tamo fo tokó̧tamo yóló só deraaire ala mulapó. Ȩ i haemó bitu, ya̧lo yó male fonétóró take kemetere sukamó so whi̧ só deraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ti noatepae, ya̧lo yale fota, ya̧lotei kekeme nóló ini, ya̧lo Aya ȩ dotȩyale sekȩ́né ȩpaae yae yale fotóró yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ya̧lo Ayané ama yae yóló muló betere fo ya̧lo sya fóló erótu betepa, ti so whi̧ fea mo ti betaaire bete saalopóló, ya̧lo kisiparapó. Ti ya̧lo i du betere fota, Ayané ȩpaae yae yale fotóró sya fóló du beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Téró, kale bosenée fele sukamó o̧la deyaaire be dȩ felekemó sókó waai depa etéyalepó. Yesu a̧ i hae taaróló Alima beterepaae faalopóló tukóló mulale ali walapóló kisipa mualepó. I haemó betó mole so whi̧paae yaala sókó fole ala deté wóló kemeróturaalu, atimapaae mió bete mo turó ha̧kearóló yó melaai dapó. ");
INSERT INTO ppo_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Be dikiteretamo, Yesu a̧ ama yó matere whi̧rapetamo o̧la naairaalu taletu betepa, Yesu eleké deyóló dó̧póló, Satan-né Iskariot be whi̧kó Saimon naalema Judas-né tuȩ́ tua̧mó sesemeróló tȩnélipakalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesuné fea ala ama tȩteróló kaae tanó̧póló, Alimané a̧ sóró beteró betere ala ama kisipa yóo, a̧ Kótó betereró wale alakélé, momó fesaae faaire alakélé, ama kisipa yóo, erapó. ");
INSERT INTO ppo_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","A̧ atérapóló kisipa mutu, o̧la nuku betaletei turukó holóló, ama tómó deró betere kuti sókó mulóló, beta̧ tawel sóró kakeralepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Atéró, beta̧ nuku dis dolopaae wȩi deróló, atimané ho̧leke kaae sóró fokalepó. Atéró, ama kakerale tawel-né atimané hó helekó̧ló kópuralepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Até deté wóló, a̧ Saimon Pita beteremó sókó wapa, ama a̧paae duraalu, “Tale-ó, naaotei ya̧lo hó fokaai de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ai fo depa Yesuné a̧paae duraalu, “Dia̧paae i erótu betere ala bete mió naao kisipanitei, take nalopaae ti kisipa yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Tétepa Pitané a̧paae duraalu, “Ya̧lo hó naao mo fokókélé yaalomeipó,” depa, Yesuné a̧paae tokó̧ mótu duraalu, “Naao hótamo ya̧lo fokoni depa, ti ya̧ ya̧lo fake aleyóló ȩtamo beta̧mó betenénipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ai fo depa, Saimon Pitané duraalu, “Tale-ó, ya̧lo hó maaté fokoni, ya̧lo naaseró topotamokélé fokotepa wisirapó!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ti fo depa, Yesuné a̧paae tokó̧ mótu duraalu, “Whi̧ me de ama tiki turó wȩi tópuóló betepa, ti hó maaté fokonérapó. Dia̧ feata, wȩi tópupatei, beta̧ whi̧ meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ti noatepae, take a̧ dó̧póló eleké deyaaire whi̧ ama kisipa iruraalu yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Atéró, atimané hó̧rape fokóló kemetepa, ama deró betere kuti momó deróló a̧ betale tikimó biti̧ felepó. Atéró bitu, ama atimapaae woseturaalu, “Ya̧lo dia̧paae erale ala dia̧ feané kisipare? ");
INSERT INTO ppo_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Diaao̧ ya̧lo doi yóló, yó matere whi̧ Tale-ó, du betere fota, ti ȩtóró ereteiné mo dono dapó. ");
INSERT INTO ppo_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mió ȩta, dia̧ tȩteróló kaae tare Talekélé, dia̧ yó matere whi̧kélé bitu, diaao̧ hórape ya̧lo fokalepó. Atéyale kaae, dia̧sisikélé hó u fokone i fokone du betae. ");
INSERT INTO ppo_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ya̧lo dia̧paae i yale alata, dia̧sisi bitukélé su̧róló deté fu betaasepóló, dia̧ kisipa mótu yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ya̧lo dia̧paae mo i dere ape. Kale kutó diratere whi̧né a̧ kaae tare topo whi̧ bosenóló, a̧ topo whi̧ betenénipó. Kutó dini fó̧póló dotȩyale whi̧nékélé a̧ dotȩyale whi̧ tȩteranénipó. ");
INSERT INTO ppo_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mió i dere alarape diaao̧ kisipayóló taaréni, sya fólótamo du betepa, ti Kótóné dia̧ wisiratapóló, hai̧né sukutu betaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ya̧lo i dere fota, dia̧ feapaae dumitei, ya̧lo dosa̧ayóló sóró beteró betere whi̧rapemó kisipa mutu dapó. Tépatei, kale asȩmó ere fo mo dokonóturaalu, ȩtamo beta̧mó o̧la nokole whi̧nétei ȩ dó̧póló, eleké deyaai du beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ai alarape depa diaao̧ kilituraalu, ȩta, Kótóné dotonó betere whi̧póló ȩpaae kisipa tiki tiró̧póló, ai alarape yaaipatei ya̧lo dia̧paae i dere ape. ");
INSERT INTO ppo_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mepaae whi̧ dené ya̧lo dotȩyale whi̧ wisiyóló dape supa, ti ȩtei dape sirapó. Até dere kaae, mepaae whi̧ dené ȩ mo wisiyóló dape supa, ti ȩ dotȩyale sekȩ́tei, dape sirapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuné ai fo yóló kemetepa, ama hosaa tua̧mó doasi sekȩné suka̧lepó. Atétepa ama duraalu, “Ya̧lo dia̧paae mo i dere ape. Dia̧kó whi̧ beta̧né ȩ dó̧póló, eleké deyaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ama yó matere whi̧rape atima ko̧ló ko̧ló duraalu, né yaaire alamó dérópóló, atimasisi u kolósu i kolósu du betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yesuné ama yó matere whi̧rapekó beta̧ Yesuné ama hosaa mole whi̧ a̧ betere felekemó titiyóló beterepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pitané u kale whi̧paae depané maaté yóló duraalu, “Ama ai yale fo-a, demó kisipa mutu yaleró, naao a̧paae wosetimié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ai fo depa, Yesutamo titiyóló betere whi̧ a̧ fetée fóló a̧paae woseturaalu, “Tale-ó, naao ai yale fo-a, demó yaleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tétepa, Yesuné a̧paae tokó̧ mótu duraalu, “Ya̧lo bred o kwia tao sóró, nukumó belere wȩimó tópuróló melatepa naao kilitu, a̧tóróti hi̧tipóló kisipa muaalopó,” yalepó. Téró, ama kale bred o kwia sóró wȩimó tópuróló, Iskariot be whi̧kó Saimon naalema Judas melalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Atéró Judas-né bred o tao seretamotóró, dowi Satan a̧ tua̧paae biti̧ walepó. Atétepa, Yesuné a̧paae duraalu, “Naao ai yaai dere ala mo hapaletei yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Atima ai o̧la nuku betere tikimó betere whi̧rape beta̧nékélé Yesuné ama ai yale fo wosóta yaletei, bete kisipa sinipó. ");
INSERT INTO ppo_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Mepaae ama yó matere whi̧rape atima kisipané Judas-ta, moni kaae tare whi̧reteiné o̧la detere sukamó naaire o̧lakó dupune fae, ó mepaae yolealere so whi̧mó melaaire o̧lakó dupura̧le fae dere nisi yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Téró, kale Judas a̧ bred o tao sóró, téti belapaae sókó derepelemó, be mo ti dikipa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Atéró, kale Judas fele sisópaae Yesuné duraalu, “Mió kale Whi̧né Naalema tua̧mó ere ala wisi ha̧kearatepa, so whi̧né kolóo, Kótó a̧ tua̧mó ere ala wisikélé Naalemapaae eratepa so whi̧ feané kolóo duraalu, Kótó tua̧mó ere ala wisinaale kisipa yaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ai alatamo mo depa, ti ama Naalema tua̧paae eratere ala wisinaale so whi̧ feané koló̧póló Kótóné kaae tani, mo miótitei ama ha̧kearaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ya̧lo naalerape-ó, mo sawa sukamó maaté ȩ dia̧tamo betaalopó. Take ya̧lo Juda topo whi̧rapepaae yale fo kaae, mió dia̧paaekélé i dere ape. Diaao̧ ȩ keka̧alotei, mo kelaalomeipó. Ȩ fole tikipaae dia̧ wókélé mo yaalo meipó. ");
INSERT INTO ppo_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mió ya̧lo dia̧paae yae yóló mulatere kisi fo i dapa wosae. Ya̧lo dia̧paae yaala sókó fu yale kaae, dia̧sisikélé atéró yaala sókó fu betae. ");
INSERT INTO ppo_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Dia̧sisitei, atéró yaala sókó fole ala so whi̧ feané kilituraalu, dia̧ ya̧lo yó matere whi̧rape beterapóló kisipa yaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ai fo depa, Saimon Pitané a̧paae woseturaalu, “Tale-ó, ya̧ mopaae faai de?” depa, Yesuné duraalu, “Ȩ fole tikipaae dia̧ mióti wonénitei, take nalota, wonérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Kale dere kaae, Pitané a̧paae woseturaalu, “Tale-ó, ya̧ fole tikipaae ȩ mióti wapa, noa yao̧sóró de? Ya̧ tao suraalu, ya̧lo betere betekélé melóló sukutepa wisirapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Téró, Yesuné a̧paae tokó̧ mótu duraalu, “Naao ȩpaae ya̧kélé sukutepa wisirapó fo du de? Ya̧lo ya̧paae mo i dere ape. Wa̧ kakaruk bané hale yaaipatei, naao ȩ tuȩ́nipó dere fo sore félimó yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Téró Yesuné duraalu, “Diaao̧ kisipa fomoyóló, hosaa tua̧mó doasi sekȩtu betao̧sóró yae. Kótópaae kisipa tiki tiróturaalu, ȩpaaekélé kisipa tiróló betae. ");
INSERT INTO ppo_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ti noatepae, ya̧lo Aya betere tikimó dia̧ betaaire be mo su̧rapó. Ai ala wua̧ meisóró, ti ya̧lo dia̧paae ha̧kearóló wua̧pó. Ȩta, dia̧ biti̧ waaire tiki donoróló mulótu betaai fulapó. ");
INSERT INTO ppo_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ȩ fólótamo dia̧ betaaire tiki donoróló kemetepa, ti momó fesaae wouraalu, dia̧kélé ȩ betere tikimótóró beta̧mó betaai dapesó faalopó. ");
INSERT INTO ppo_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ȩ i faaitu betere bepaae fole tu̧ta, ti diaao̧ ai kisipare ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tétepa Tomas-né a̧paae duraalu, “Tale-ó, ya̧ faaire tikita, da̧ ko̧ló ko̧lórapó. Atérapa, ya̧ ai faaitere tikipaae sókó fole tu̧ da̧né netéró kisipa yaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ai fo depa Yesuné duraalu, “Ai bepaae faaire tu̧kélé, mo foné betekélé, so whi̧ betere betekélé, ti mo ȩtórótipó. Whi̧ mo beta̧kélé ya̧lo Aya beterepaae faai depa, ti ȩ dekeróló feni, mo ȩ tua̧mótóró fenérapó. ");
INSERT INTO ppo_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Diaao̧tamo ȩ diriyóló tuȩ́pa, ti ya̧lo Ayakélé mo tuȩ́nérapó. Mió kaae suraalu, diaao̧ ya̧lo Aya kolóló, ai kisipare ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tétepa Filip-né duraalu, “Tale-ó, Aya naao da̧paae yó matepa, ti da̧né a̧ kolóló kisipanérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ai fo depa Yesuné duraalu, “Filip-ó, fo̧lo sukamó ȩ dia̧tamo bitiré waletei, diaao̧ ȩ kisipanié? Mepaae whi̧ dené ȩ kolóló kisipa epa, ti ya̧lo Ayakélé kisiparapó. Tépatei, diaao̧ ȩpaae Aya yó a̧lae dere-a, noa fo yóló de? ");
INSERT INTO ppo_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ȩ ya̧lo Aya tua̧mó betóo, ya̧lo Aya ȩ tua̧mó betóo, eretei diaao̧ kisipanié? Ya̧lo dia̧paae yó mótu betere fota, ya̧lo kekeme nóló dumipó. Ya̧lo Aya ȩ tua̧mó bitu, ama kisipa mole ala erótu beteretei, diaao̧ ai kelere ape. ");
INSERT INTO ppo_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ya̧lo Aya ȩ tua̧mó betóo, ȩ ya̧lo Aya tua̧mó betóo, erapó dere fo diaao̧ wosóló, mo dapóló kisipa tiki tirae. Ai alatamo ini depa, ti ya̧lo erale kelemei alarape kolóló, kisipa tiki tirae. ");
INSERT INTO ppo_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ya̧lo dia̧paae mo i dere ape. Whi̧ me detamo ȩpaae kisipa tiki tiratepa, ti ai whi̧né ya̧lo yale ala kaaetóró yaalopó. Ti noatepae, ȩ ya̧lo Aya beterepaae foleteiné take nalo diaao̧ ya̧lo du betere alarapekélé fea bosenóló, mo doasi ala yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Naalemané Alimané ere ala bete ha̧kearaairaalu, me noa o̧lakó ya̧lo doimó ȩpaae wosetepa, ti ai whi̧paae ya̧lo mo melaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Dia̧ feané ya̧lo doimó me noa o̧lakó kematepa, ti ai ala ya̧lo mo eraalo ai ape,” ");
INSERT INTO ppo_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Diaao̧tamo ȩpaae hȩkesené sukó̧ló yaala sókó fu betepa, ti ya̧lo yae yóló muló betere fokélé diaao̧ mo wisiyóló sya fóló, erótu betaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ȩ betale sirimó, suka fea dia̧tamo betó taru, dia̧ tao sóró fotoko̧ bulótu betaaire sekȩ́ mekó ya̧lo Ayapaae dotonae depa, ama dia̧ beterepaae mo dotonaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ti ai sekȩ́ta, mo ala maaté du betere Dȩi Kepe Wisipó. I hae so whi̧né ama dere fo wosóló, mopóló a̧ dape senénipó. Ti noatepae, atimané a̧ kolóló kisipakélé inireteinépó. Tépatei, mió a̧ dia̧tamo betóo, take nalokélé dia̧ tua̧mó betóo, yaairetei diaao̧ ai kisipare ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Dia̧ hae aya meiyóló, bokonaale naale senaale kaae beteró̧póló ya̧lo dia̧ taaróló fumitei, ȩ dia̧ beterepaae momó fesaae waalopó. ");
INSERT INTO ppo_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mo sawa sukamó bituraalu, i hae so whi̧né ȩ kelaalo meitei, dia̧néta ȩ kelaalopó. Ti noatepae, ȩ kepaayóló betereteiné, dia̧kélé mo betaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Atétere sukamóta, ȩ ya̧lo Aya tua̧mó betepa dia̧ ȩ tua̧mó betóo, ȩ dia̧ tua̧mó betóo, ere ala diaao̧ kisipa yaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mepaae whi̧ de ya̧lo yae yóló muló betere fo ao̧mó sukó̧ló bitu, sya fóló eró tapa, ti ai whi̧né ȩpaae yaala sókó fu beterapó. Mepaae whi̧ dené ȩpaae yaala sókó fu betepa, ti ya̧lo Ayanékélé ai whi̧paae yaala sókó fóo, ya̧lokélé a̧paae yaala sókó fóo du betaalopó. Téturaalu, ȩ tua̧mó ere ala fea ya̧lo a̧paae ha̧kearóló yó melaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tétepa, kale Iskariot be whi̧kó Judas-né ama yakoma Judas-né Yesupaae duraalu, “Tale-ó, i haemó betó mole so whi̧ feané ya̧ koló̧póló yó meni, da̧né maaté koló̧póló, yó melaalopó dere-a, noatepae?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ti fo depa Yesuné duraalu, “Mepaae whi̧ dené ȩpaae yaala sókó fu betepa, ti ya̧lo yó matere fo wisiyóló sóró erótu betaalo ai ape. Atétere whi̧paae ya̧lo Ayané yaala sókó furaalu, da̧mo wusuró a̧ beterepaae wóló a̧tamo beta̧mó mo ti betó tawaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mepaae whi̧ dené ȩpaae yaala sókó fenitepa, ti ya̧lo i yó mótu betere fokélé diaao̧ sya fóló eraalomeipó. I kale wosetu betere fota, ya̧lo kekeme nóló dumitei, ȩ dotȩyale sekȩ́ ya̧lo Ayané ama fotóró yó mótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","I fo feata, ȩ dia̧tamo beta̧mó bitutei yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tétu betaletei, dia̧tamo beta̧mó bitu, dia̧ tao saaire sekȩ́ kale Dȩi Kepe Wisi Ayané ya̧lo doimó dotonaalopó. Ai sekȩ́né amata, dia̧paae fea ala yó melaalo ai ape. Téturaalu, ya̧lo dia̧paae yó mótu betale forape keteni, kisipa yó tanó̧póló, ama dia̧ yó mótu betaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ȩ tua̧mó mole hosaa muni deyóló mo dua betere ala dia̧mó melóló ȩ i fole ape. Ya̧lo i matere hosaa muni deyóló dua betere alata, i haemó betó mole mo so whi̧né matere kaae meipó. Térapa, diaao̧ hosaa tua̧mó sekȩtere alaró witere alatamo muao̧sóró yae. ");
INSERT INTO ppo_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ȩta, dia̧ taaróló faalotei, dia̧ beterepaae momó fesaae waalopó yale fota, diaao̧ ai wosale ape. Diaao̧ ȩpaae yaala sókó fole ala mupata, ti ȩ ya̧lo Aya beterepaae fulapó dere fo woseturaalu, hai̧né sukua̧pó. Ti noatepae, ya̧lo Aya a̧ doasi fotoko̧ bole sekȩ́ bitu, ama ȩ tȩteró beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Take i alarape mo depa kilitu, mo irapóló diaao̧ kisipa tiki tiró̧póló, i alarape yaaipatei, folosóró ya̧lo dia̧paae ai yale ape. ");
INSERT INTO ppo_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ya̧lo dia̧paae fo me kae dekéró yaalomeipó. Ti noatepae, i hae tȩteróló kaae tare topo whi̧ Satan ipaae mo felekemó sókó waai dapó. Téyaalotei, ama ȩ só deraaire bete mekélé mo munipó. ");
INSERT INTO ppo_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tépatei, ya̧lo Ayapaae yaala sókó furaalu, ama erae dere alatóró ya̧lo erótu beteretei, i haemó betó mole so whi̧ feané kolóló taaréni, mo kisipa só̧póló dapó. Térapa, mió da̧ faalopa fiépe,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Mo wain képi beteta, ti ȩtórótipó. Ya̧lo Aya a̧ta, wain kutó Talepó. ");
INSERT INTO ppo_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mepaae du olenitere tetei̧rape ti ama tukóló taae falatu beterapó. Mepaae du oletere tetei̧rape mo dekéró oleyó̧póló, ya̧lo Ayané mepaae séli yó moletei turukóló taae falatu beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ya̧lo take dia̧paae yó mótu betale foné dia̧ fea fokóló mo ti wisiró beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Dia̧ ȩ tua̧mó betepa, ti ȩkélé dia̧ tua̧mó betaalo ai ape. Kale képi tetei̧rape tikimó olekenipa, ti du oleyaalomeipó. Dia̧ ȩ tikimó olekeyóló bitinipa, ti netéró du oleyaaloé? ");
INSERT INTO ppo_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mo wain képita, ti ȩtórótipó. Dia̧ta tetei̧rape ai ape. Mepaae whi̧tamo ȩ tua̧mó betóo, ȩkélé ai whi̧ tua̧mó betóo epa, ti du mo dekéró oleyaalopó. Téni, ȩtamo tekée fóló kae betepa, ti ai whi̧né ama me alakélé mo enénipó. ");
INSERT INTO ppo_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mepaae whi̧tamo ȩ tikimó olekeyóló bitinipa, ti ai whi̧ sélitepa tukóló taae falatere ni tetei̧ kaaepó. Ai taae falatere tetei̧rapeta, dasóló si bilirótua dapó. ");
INSERT INTO ppo_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Dia̧kó whi̧ me detamo ȩ tikimó olekeyóló betóo, ya̧lo fokélé naao hosaa tua̧mó muóo iruraalu, me o̧lakó ȩpaae kematepa, ti ai whi̧paae ya̧lo mo melaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Dia̧ tua̧mó du mo dekéró olepa, ti ya̧lo Ayané ama ere ala wisinaale so whi̧ feané koló̧póló ha̧kearatapó. Atére ala so whi̧né kilitu, dia̧ mo ya̧lo yó matere whi̧rapetóró beterapóló kisipa yaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ya̧lo Ayané ȩpaae yaala sókó fu yale kaae, ya̧lokélé dia̧paae yaala sókó fole ala du betalepó. Térapa, ya̧lo yaala sókó fóló mole tua̧mótóró ha̧le betó tawae. ");
INSERT INTO ppo_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ya̧lo Ayané ama erae yóló muló betere fo sya fóló eró taruraalu, ama yaala sókó fóló mole tua̧mó betó tarapó. Ȩ ai ala ere kaae, ya̧lo erae dere fo diaao̧ wosóló erótu betepa, ti dia̧ ya̧lo yaala sókó fole ala tua̧mó betó tawaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ya̧lo dia̧paae i yale fo feata, ȩ tua̧mó mole hai̧tere ala dia̧ tua̧mó fa̧aturaalu, diaao̧ hai̧tere ala mo ti su̧ró̧póló kisipa mutu yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ya̧lo dia̧paae yae dere fo ipó. Ya̧lo dia̧tamo yaala sókó fóló mulure kaae, naao ne no dia̧sisikélé ai ala du betae. ");
INSERT INTO ppo_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Whi̧ mené ama yaala sókó fole whi̧rape tao saai dapóló, ama betere bete ha̧le melóló sukutepa, ti atéró yaala sókó fole alané mepaae yaala sókó fole ala fea tȩteró beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Diaao̧ ya̧lo yae yóló muló betere fo erótu betepa, ti dia̧ ya̧lo fulumu whi̧rape ai betere ape. ");
INSERT INTO ppo_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Beta̧ kutó diratere whi̧né a̧ tȩteróló kaae tare whi̧né dere ala fea ama kisipa inipó. Atére betené take bitiré wouraalu, ya̧lo dia̧paae kutó diratere whi̧rape-ó yaletei, ai fo momó kaae ini, mió dia̧paae ya̧lo fulumu whi̧rape-ó, dapó. Ti noatepae, ya̧lo Ayané yó melale alarape fea diaao̧ kisipa yó̧póló, ya̧lo dia̧paae ha̧kearóló yó melalepó. ");
INSERT INTO ppo_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Diaao̧ ȩ sókó sóró kae beterénitei, ya̧lo dia̧ sókó sóró kae beteró beterapó. Ai alata ha̧le inipó. Dia̧ fóló, mo ti muó tawaaire du oleró̧póló kisipa mutu yalepó. Atéturaalu, ya̧lo doimó diaao̧ me noa o̧lakó Ayapaae kematepa, ti ai kematere o̧la ama dia̧mó mo melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ya̧lo dia̧paae yae yóló mulatere fo i ape. Dia̧sisitei yaala sókó fole ala du betae. ");
INSERT INTO ppo_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","I haemó betó mole so whi̧nétamo dia̧ hó̧róló bóe du betepa, ti folosóró atimané ȩ hó̧róló, bóe dale ala kisipa muae. ");
INSERT INTO ppo_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Dia̧tamo i hae tale betepa wua̧sóró, ti i hae so whi̧né faketóró beterapóló kisipa mutu, dia̧paae yaala sókó fole ala du bitua̧pó. I hae so whi̧tamo touyóló betepa, ya̧lotei dia̧ sókó su yóló kae beteralepó. Atére betené dia̧tamo bóe du beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ya̧lo dia̧paae yó melale forape kisipa muae. Kutó diratere whi̧né a̧ kaae tare whi̧ ama tȩteróló kaae tanénipó. Atimané ȩtamo bóe dóló susupui ala erótu yale kaae, dia̧paaekélé eraalo ai ape. Ya̧lo yó male fotamo atimané wisiyóló wosóló erótu betepa, ti diaao̧ yó matere fokélé atimané wisiyóló wosaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ti noatepae, ȩ dotȩyale seké, atima kisipa inireteiné dia̧ ya̧lo so whi̧ bitu, ya̧lo ala erótu beteremó, atimané dia̧paae kae kae susupui ala erótu betaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ȩ i haepaae wóló, ya̧lo fo atimapaae yó mólua̧sóró, ti dowi alamó atima só deraaire kwia mua̧meipó. Tépatei, atimané yale dowi alamó fo tokó̧tamo depa, meipóló hepée falaaire tu̧ mo munipó. ");
INSERT INTO ppo_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Whi̧ me dené ȩ hó̧róló bóe du betepa, ti ai whi̧né ya̧lo Ayakélé hó̧róló bóe dilapó. ");
INSERT INTO ppo_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Take mo beta̧ whi̧nékélé inire ala ya̧lo atima kuamó erólua̧meisóró, ti atimané yale dowi alamó só deraaire kwia mua̧meipó. Mió i yale kelemei alarape atimané kolólótei, ȩtamokélé ya̧lo Ayatamokélé, bóe dóló hó̧ralepó. ");
INSERT INTO ppo_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Atimané ai du betere alata, i asȩre fo dokonóturaalu yalepó, ‘Me bete munipatei, atimané ȩtamo ha̧le bóe dalepó.’ ");
INSERT INTO ppo_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Até du betaalotei, dia̧ tao sóró wisiraaire sekȩ́ beta̧ waalo ai ape. Ai sekȩ́ta, ȩ fóló ya̧lo Ayatamo bituraalu, dia̧ beterepaae dotonaalopó. A̧ta, mo alané bete ya̧lo Ayatamo beta̧mó biti wouraalu, ya̧lo ere ala fea etérapóló, dia̧ tao sóró fotoko̧ bulóló, yó melaaire Dȩi Kepe Wisipó. ");
INSERT INTO ppo_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mo take kaae sale alimótei, dia̧ ȩtamo bitiré waleteiné diaao̧kélé ȩ etei kaae whi̧póló ha̧kearóló yó mótu betenérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ya̧lo dia̧paae i yale fo feata, dia̧ ȩ sya fu betere ala taaróló, kó̧paae fao̧sóró yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Atimané dia̧ fo wosetere bepaae wao̧sóró dóló ho̧konaalo ai ape. Ai ala maaté mei, mepaae whi̧ atima Kótóné ala eratere nisiyóló, dia̧ mo ti sukó̧póló daalo ai ape. Ai ala yaaire be dȩ mió mo felekemó sókó waai dapó. ");
INSERT INTO ppo_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ȩró ya̧lo Ayatamo atima kisipa inire betené dia̧paae atei kaae alarape eraalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Atépatei, ya̧lo dia̧paae i deté wou betere fo dokonóturaalu mo eratere sukamó, noa ala dutérópóló dia̧ kilita yao̧sóró, ya̧lo i dere fo kisipa yaasepóló dapó. Ȩ dia̧tamo ha̧le betereteiné take ya̧lo dia̧paae etei fo inipó. ");
INSERT INTO ppo_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Téretei mióta, ȩ dotȩyale sekȩ́ beterepaae momó fesaae fulapó. Até yaai depa, dia̧kó beta̧ whi̧nékélé, ‘Ya̧ maae faai de?’ yóló, ȩpaae wosetere fokélé dumipó. ");
INSERT INTO ppo_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ya̧lo dia̧paae i forape yaleteiné mió diaao̧ hosaa tua̧mó dekȩ́né ai sukutu betere ape. ");
INSERT INTO ppo_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tépatei, ya̧lo dia̧paae mo dapó. Dia̧paae wisi ala eraaire tu̧ mulóturaalu, ȩ dia̧ taaróló fulapó. Ȩtamo fenitepa, ti dia̧ tao sóró fotoko̧ bulóló tu̧ yó melaaire sekȩ́ dia̧ beterepaae waalo meipó. Ȩtamo fupa, ti ya̧lo a̧ dia̧ beterepaae dotonaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ai Dȩi Kepe Wisi wouraaluta, i haemó betó mole so whi̧né du betere dowi alakélé, Kótóné donoi ala etérópóló yó mótu betere alakélé, taleyóló kwia matere alakélé, fea ai sekȩ́né ama ha̧kearateremó, ho̧ko ala du beterapóló dia̧ hosaamó saalopó. ");
INSERT INTO ppo_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ti noatepae, i haemó betó mole so whi̧né ȩpaae kisipa tirénitere beteta, dowi alapóló ai Dȩi Kepe Wisiné atima hosaamó seraalopó. ");
INSERT INTO ppo_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ȩ ya̧lo Aya beterepaae fesaae foletei, momó kae diaao̧ ȩ kelaalomeipó. Ȩ atéró foleteiné so whi̧ feané Talené donoi ala kisipa yó̧póló, ai sekȩ́né ha̧kearóló yó melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mió i haemó tȩteróló kaae tare sekȩ́ ama yale alamó, a̧ só deró beterapó. Tétu, i haemó betó mole so whi̧ tale dere alakélé ho̧ko yalepóló, hosaamó só̧póló, ai waaire Kepe Wisiné ha̧kearaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ya̧lo dia̧paae yaai dere fo dekéró mupatei, bete diaao̧ senénireteiné fea fo enénipó. ");
INSERT INTO ppo_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tépatei, kale mo fo maaté bole Kepe Wisi a̧ wólóta, mo fo bete turó diaao̧ tuȩ́ yó̧póló, ha̧kearóló yó mótu betaalopó. Aita, ama kekeme nóló yaalomeitei, mo ama wosale fotóró dia̧paae yó melaalopó. Téturaalu, nalo waaire be dȩmó yaaire alakélé yó melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ai Dȩi Kepe Wisiné ya̧lo mo bete mole fo diaao̧ kisipa yó̧póló, ama tao sóró dia̧paae yó melaalopó. Téturaalu, ya̧lo ere ala wisinaale so whi̧ feané koló̧póló, ama ha̧kearaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ya̧lo Ayané ama tȩteróló kaae tare ala fea, ya̧lokélé tȩteróló kaae tarapó. Atére betené ya̧lo fo diaao̧ kisipa yó̧póló, Dȩi Kepe Wisiné ama ha̧kearóló yó melaalopóló, ya̧lo dia̧paae yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Mo sawa sukamó diaao̧ ȩ kelaalomeitei, sawa beteró, diaao̧ ȩ momó kelaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ai fo depa, mepaae ama yó matere whi̧rape atimasisitei duraalu, “Sawa sukamó a̧ kelaalomeipó. Téyaalotei, sawa sukamó beteró a̧ momó kelaalopó, dere foró ama Alima beterepaae foleteinépó yale fotamo-a, noa betené yalerópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Atimasisitei duraalu, “Mo sawa sukamópó yale fota, noa betené yaleró da̧kélé kisipani, ko̧ló ko̧lórapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ama ai yale fomó, atimané a̧paae wosaai mutere kisipa ama kolóló, atimapaae duraalu, “Sawa sukamó diaao̧ ȩ kilini bitiré fóló, sawa sukamó momó kelaalopó yale fomó, dia̧sisitei noatepa kȩlaarótu bitu de? ");
INSERT INTO ppo_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ya̧lo dia̧paae mo i dere ape. Dia̧ta, diaao̧ hosaa tua̧mó dekȩné sukuturaalu, wole-u du betepa, i haemó betó mole so whi̧ atima hai̧né sukutu betaalopó. Diaao̧ hosaa tua̧mó sekȩné sukutu betaalotei, momó kisipa felé yóló, hai̧tu betaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sorapené naale saaire be dȩ sókó wapa sisó nukuraalu, ama tikimó doasi dele sua dapó. Téteretei, ama naale só mulóló, ki̧lipaae naalené tiki kolóló hȩkeseturaalu, a̧ doasi dele sale ala kisipa keterótua dapó. ");
INSERT INTO ppo_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Atétere kaae, mió dia̧ dekȩné ai sukutu betere ape. Tépatei, ȩ momó dia̧ beterepaae wale sukamó, diaao̧ ȩ kilitu dere hai̧ mené tokó̧ló aluranénipó. ");
INSERT INTO ppo_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Atétere sukamó, diaao̧ ȩpaae me wosetere fokélé mo yaalo meipó. Ya̧lo dia̧paae mo dapó. Diaao̧ ya̧lo doimó Ayapaae me o̧lakó kematepa, ti ai whi̧paae ama mo melaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Take bitiré woukélé, diaao̧ ya̧lo doimó me o̧la kematere alakélé mo inipó. Térapa, mió bitutamo me o̧lakó kematepa, ti ai o̧la suraalu, dia̧ tua̧mó hai̧tere ala mo turó fa̧ayaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Taketa, ya̧lo dia̧paae kinóló mole ala fo salepaae dó faróló deté waletei, nalo waaire sukamó yaaitere alata, fo salené ini, ya̧lo Ayané ama ere ala etérapóló, mo ha̧kearóló yaalopó. ");
INSERT INTO ppo_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ai be dȩmóta, diaao̧ ya̧lo doimó a̧paae kema yaalopó. Ya̧lo i du betere fota, dia̧mó ya̧lo Ayapaae woseraalopóló dumipó. ");
INSERT INTO ppo_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Téyaalo meipa, diaao̧tei a̧paaetóró wosae. Ti noatepae, diaao̧ ȩpaae yaala sókó fóo, ȩta Kótótamo betóló wale whi̧póló a̧paae kisipa tiki tiróo ereteiné, ya̧lo Ayané ama dia̧paae hosaa muóló yaala sókó fu beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Take ȩ ya̧lo Ayatamo beteró, i haepaae walepó. Mió ȩ i hae taaróló, momó ya̧lo Aya beterepaae fulapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ai fo depa, ama yó matere whi̧rapené a̧paae duraalu, “Mióta naao da̧paae fo salepaae dó faróló dumi, mo ha̧kearóló dapó. ");
INSERT INTO ppo_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mió da̧né kisipare ala beta̧ ipó. Fea ala naao kisiparu ha̧keamó yó mótu betereteiné, mené ya̧paae momó wosetere ala kae enénipó. Atérené ya̧ta, Kótótamo betóló wale whi̧póló da̧né kisipa tiratapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ai fo depa, Yesuné atimapaae duraalu, “Dia̧ tuȩ́ tiki tiró̧póló kaae taté waletei, mióti ȩpaae diaao̧ tuȩ́ tiki ai tiratere ape! ");
INSERT INTO ppo_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Téretei, diaao̧ be doko̧ dapo dapo yóló furaalu, ȩ wotoró betepa taaróló faaire be dȩ mió i sókó wale ape. Téyaalotei, ȩ wotoró bitini, ya̧lo Ayatamo wusuró beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ya̧lo dia̧paae i yale fota, dia̧ ȩ tua̧mó hosaa muni deyóló dua beteró̧póló yalepó. Dia̧ i haemó bituraalu, kae kae sekȩi ala siré fu betaalotei, i haemó mole alarape fea ya̧lo mo ti doróló tȩteró beterapó. Atérapa dia̧ furu furu ini, hosaa diriyóló dua betae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuné ai forape yale ki̧lipaae ó hepen-paae kese holóló momaturaalu, “Aya-ó, mió kale tukóló muló betere be dȩ i sókó walapa, naao Naalené ya̧ tua̧mó ere ala wisinaale so whi̧ feapaae ha̧kearó̧póló, naao ama ere ala wisi ha̧kearae. ");
INSERT INTO ppo_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ti noatepae, i haemó betó mole so whi̧ fea tȩteróló kaae tanó̧póló, naao ȩ sóró beteralepó. Naao ȩpaae ai melale so whi̧paae mo ti betaaire bete meló̧póló, naao fotoko̧ ȩ su̧mó melalepó. ");
INSERT INTO ppo_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mo ti betere bete i ape. So whi̧né ya̧ta, mo beta̧ betere Kótópóló tuȩ́ yóo, naao dotȩyale whi̧ Yesu Kerisokélé tuȩ́ yóo, dere alata, mo ti betere betepó. ");
INSERT INTO ppo_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Naao ȩpaae i haemó dirae yale kutó fea ya̧lo diyóló kemeraleteiné, naao ere ala wisinaale i haemó betere so whi̧né koló̧póló, ha̧kearalepó. ");
INSERT INTO ppo_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Aya-ó, i haekélé kaaraaipa da̧mo wusuró bitu, naao ere ala wisi ha̧kearótu yale kaae, mió ȩ i hae taaróló ya̧ beterepaae fesaae wóló betepakélé, ai ala momó eraasepóló dapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Aya-ó, i haemó betó mole so whi̧ kuamó, mepaae naao sóró ȩpaae melale so whi̧paae ti naao ere ala wisi ya̧lo ha̧keamó erótu betalepó. Atimata take naao so whi̧ betaletei, naao sóró ȩpaae melalepó. Atéyale so whi̧né naao fo mo beta̧ wosóló, erótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Naao ȩpaae melale alarape feata, ya̧ betemó kaayóló walepóló, mió atimané tuȩ́rapó. ");
INSERT INTO ppo_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ti noatepae, naao ȩpaae yó melale fo fea ya̧lomo atimapaae yó matepa, atimané mopóló wosalepó. Atéturaalu, ȩ ya̧tamo betóló naao ȩ dotonatepa wale whi̧póló, atimané ȩpaae kisipa tiralepó. ");
INSERT INTO ppo_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Naao atima tao só̧póló, ya̧lo momarótu beterapó. Ya̧lo i dere momata, i haemó ha̧le betó mole so whi̧mó dumitei, naao sóró ȩpaae melale so whi̧mó kisipa mutu i detere ape. Ti noatepae, atimata mo naao so whi̧tórótipó. ");
INSERT INTO ppo_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Naao so whi̧ta, ti ya̧lo so whi̧tórótipó. Ya̧lo so whi̧ fea ti naaotórótipó. Atimapaae erale ala so whi̧ feané kilitu, ya̧lo ere ala wisinaale ha̧kearalepó. ");
INSERT INTO ppo_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mió ȩ i haemó doa fo̧lo sukamó betaalomeitei, i whi̧rape atimata i haemó ha̧le betepa, ȩ ya̧ beterepaae walapó. Mo kae betere Aya-ó, i whi̧rape atima me ala yao̧sóró, naao ere ala tua̧mó beteró̧póló kaae tawae. So whi̧né naao ere ala wisinaale kisipa yó̧póló, naao doasi doi mole fotoko̧né ȩ tua̧paae eralepó. Térapa, da̧mo mo beta̧tóró biture kaae, atimakélé atérótóró beteró̧póló, naao ȩ male doiné tȩteróló kaae tawae. ");
INSERT INTO ppo_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ȩ atimatamo beta̧mó betale sukamó, naao ȩpaae melale doiné atima mo wisiyóló kaae tawalepó. Atéró, kaae tawale sukamó mo beta̧ whi̧kókélé alunipó. Kale asȩmó ere fo dokonóturaalu, aluyaai yale whi̧ a̧ beta̧ mo ti aluyalepó. ");
INSERT INTO ppo_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Mió ȩ ya̧ beterepaae waai, i haemó atimatamo betere féli, ȩ tua̧mó mole hai̧tere ala mo turó atima tua̧mókélé muló̧póló, i forape atimapaae du beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ȩ i hae tale bitiniru ere kaae, atimakélé i hae tale bitinipó. Naao ȩpaae erae yale fo ya̧lo atimapaae yó melalemó, i haemó betó mole so whi̧né atimatamo bóe dóló hó̧ralepó. ");
INSERT INTO ppo_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Aya-ó, ya̧lo i dere momata, atima i haemó beteretei tokó̧ sóró, naao kae tikipaae beterae yóló dumitei, dowi kepené atima dorao̧sóró, seséyae yóló dapó. ");
INSERT INTO ppo_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ȩ i hae tale bitinirure kaae, atimakélé i hae tale bitinipó. ");
INSERT INTO ppo_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Atima me alatamo hoseké yóló betao̧sóró, mo fonétei atima kae sóró beterae. Naao fota me kae mei, mo bete mole fopó. ");
INSERT INTO ppo_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ȩ i hae so whi̧tamo beteró̧póló, naao ȩ i haepaae dotonótu yale kaae, i whi̧rape atimakélé, i haemó betó mole so whi̧tamo beteró̧póló, ya̧lo dotonatapó. ");
INSERT INTO ppo_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Atimakélé me alatamo hosekéni, mo kae beteró̧póló, ȩ mo naao alatóró eraai kisipa mutu, ya̧lotei ȩ kae sóró beteratapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ya̧lo i dere momata, i whi̧rape atima maaté tao só̧póló dumitei, mepaae so whi̧ de atima yó matere fo wosóló, ȩpaae kisipa tiraaire so whi̧mókélé i dere ape. ");
INSERT INTO ppo_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Aya-ó, ya̧lo i dere momata, ȩ ya̧ tua̧mó betóo, ya̧ ȩ tua̧mó betóo iru, mo beta̧tóró biture kaae, atimakélé fea atérótóró beteró̧póló yae. I haemó betó mole so whi̧né ȩ naao dotȩyale whi̧póló kisipa tiró̧póló, atima da̧mo tua̧mó beteró̧póló yae. ");
INSERT INTO ppo_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Naao ere ala wisinaale ha̧kearóló ȩpaae melaletei, ya̧lomo atimapaae melalepó. Até yaleteita, da̧mo mo beta̧ kisipa muóló biture kaae, atimakélé atéró beteró̧póló yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Naao ȩ dotȩyóo, ȩpaae yaala sókó fóo, ere ala atimapaaekélé eró beterapóló, i haemó betó mole so whi̧né kisipa yó̧póló, atima fea mo beta̧ faketóró alerae. ");
INSERT INTO ppo_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Aya-ó, naao ȩpaae melale so whi̧ ȩ betere tikimótóró beta̧mó bitu, ȩ tua̧mó ere ala wisinaale atimané koló̧póló kisipa mutapó. Ti naao ai ere ala wisinaaleta, take sa̧ró haetamo kaaraaipatei, yaala sókó furaalu, ȩpaae melalepó. ");
INSERT INTO ppo_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mo donoi ala maaté yó tare Aya-ó, i haemó betó mole so whi̧né ya̧ tuȩ́nitei, ya̧lo ya̧ tuȩ́rapó. I whi̧rape atimanéta, naao ȩ dotȩyalepóló kisiparapó. ");
INSERT INTO ppo_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Naao ȩpaae yaala sókó fole ala atima tua̧mó muóo, ȩkélé atima tua̧mó betóo eró̧póló, ya̧lo ya̧ etei kaae Tale beterapóló, atimapaae ha̧kearóló yó maté wou betalepó. Ai ala taaréni, miókélé ha̧le detétóró fu betaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Atéró, Yesuné moma yóló kemetepa, ama yó matere whi̧rape atima betere tiki taaróló, Kidron ho tȩyóló felepó. Ai ho uté fakeró Olip nirape daae mulapó. Yesuró ama yó matere whi̧rapetamo ai ni daae mole tikimó sókó felepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ai hae tikita, Yesu dó̧póló eleké deyaaire whi̧ Judas-né ama mo tuȩ́rapó. Ti aita, Yesuné ama yó matere whi̧rapetamo suka fea toura̧leta du betale tikipó. ");
INSERT INTO ppo_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Atéró, kale Judas a̧ ai ni daae mole tikimó sókó walepó. A̧ atéró wale alata, ama wotoró mei, mepaae diki tare whi̧rapekélé, Farisi whi̧raperó so whi̧mó momaratere topo whi̧rapené sóró beteró betere whi̧rapetamokélé, dapesó walepó. Ai whi̧rape atima feané mo sa̧kélé, lamp sa̧kélé, bóe dele o̧la o̧larapekélé, fea tawóló walepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesuné a̧paae eraaire ala fea ama kisipa irutei, a̧ sókó fóló atimapaae duraalu, “Diaao̧ ai-a, de kekitu bitu de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ai fo depa atimané duraalu, “Da̧ta Nasaret be whi̧kó Yesu keketapó,” depa, ama duraalu, “Ai whi̧ta ȩtóróti i ape,” yalepó. Ai wale whi̧rapetamo Yesu dó̧póló, eleké deyaaire whi̧ Judas-kélé daalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesuné ai whi̧ta, ȩtóróti i ape dere fo woseturaalu, atima sisóné fele tikimó, dée nalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Atétepa, Yesuné atimapaae momó woseturaalu, “Diaao̧ ai kekitu betere whi̧-a, de?” depa, atimané duraalu, “Nasaret be whi̧kó Yesupó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesuné kale whi̧rapepaae duraalu, “Ai whi̧ta, ȩtóró i ape yóló ya̧lo taketi dia̧paae inié? Diaao̧tamo ȩ kikitu betepa, ti i whi̧rape atima ha̧le fó̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ti ai yale alata, take Yesuné “Naao ȩpaae melale whi̧rape mo beta̧kélé alunipó,” yale fo mo dokonóturaalu yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Téró, Saimon Pitané fo̧loi sepake be dolomó deró beteretei sókó sóró, so whi̧mó Talepaae momaratere topo whi̧né kutó diratere whi̧né tururó wosȩ́li sa̧ae deralepó. Ai whi̧né ama doita Malkus-pó. ");
INSERT INTO ppo_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesuné Pitapaae duraalu, “Naao ai sepake sóró momó be dolopaae bulae. Naao kisipané ya̧lo Ayané ȩ melale wȩi wutimó beleretei ya̧lo naalomeipóló de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Téró, diki tare whi̧raperó atimané topo whi̧tamo yóo, mepaae Juda topo whi̧rapekélé yóo yóló, Yesu tawóló halika tikiné dokalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Atéró, atimané a̧ folosóró Kaiapas-né nouma Anas beterepaae dapesó felepó. Kaiapas a̧ta, ai ba fo tua̧mó so whi̧mó Talepaae momaratere whi̧rapené topo whi̧ beterepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","I sekȩ́ Kaiapas-ta, take Juda so whi̧paae duraalu, “Da̧ Juda so whi̧ me ala yao̧sóró, beta̧ whi̧ sukutepa mo wisirapó,” yale whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Atéró, Yesu dapesó fupa, Saimon Pitaró ama yó matere whi̧ metamo Yesu sya fu betalepó. Kale mo so whi̧mó Talepaae momaratere topo whi̧né Yesuné yó matere me whi̧ ama wisiyóló tuȩ́reteiné ai bolaare tipi tua̧paae doropó̧póló yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Téyaletei, Pita a̧ ai tipi tu̧ serekemó daapa, kale me yó matere whi̧ momó fesaae wóló, tu̧ kaae tare senaalepaae Pitakélé ipaae wó̧póló yae, yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Atéró, kale tu̧ kaae tare senaalené Pitapaae woseturaalu, “Ya̧kélé ai whi̧né yó matere whi̧kóe?” depa, Pitané kale senaalepaae tokó̧ mótu duraalu, “Ȩta, ai whi̧né yó matere whi̧ meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Atéró, kale mepaae kutó diratere whi̧raperó mepaae doasi diki tare whi̧rapetamo atima sosóli depa, si nokeyóló simó boperóló daae molepó. Atéró daae mupa, Pita a̧kélé sosóli depa, atimatamo simó daalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Atima atéró simó betó mupa, mo so whi̧mó Talepaae momaratere topo whi̧né Yesupaae woseturaalu, “Naao yó matere whi̧rape-a, deé? atimapaae naao noa fo yó maleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ai fo depa Yesuné duraalu, “Ya̧lo fo mekó kinóló yó meni, so whi̧ feané wosó̧póló, ha̧keamótóró yó mótu betalepó. Ya̧lo yó male fota, Kale Juda fake so whi̧ fea toura̧leta dere fo wosetere beraperó, moma dere betamo tua̧mótóró yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Téyalepa, naao ȩpaae noatepa wosete? Ya̧lo yó matere fo wosale so whi̧né tuȩ́rapa, atimapaae wosae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesuné ai fo depa, Juda topo whi̧né sóró beteró betere whi̧ beta̧ a̧ daale felekemó daai sókó wóló, ama kelepaamó deké sóró duraalu, “So whi̧mó Talepaae momaratere topo whi̧paae atei kaae fo dua de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Atétepa Yesuné duraalu, “Ya̧lo me dowi alakótamo itikimó, ti i so whi̧ feané keletómó ya̧lo yale ala ha̧kearóló yae. Téni, ya̧lotamo a̧paae mo fo itikimó, ti naao ȩ ha̧le noatepa dile?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Atéró, Yesuné ama naase ha̧le dokopatei, kale whi̧ Anas-né a̧ Talepaae momaratere topo whi̧ Kaiapas beterepaae fó̧póló dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Atima ai ala du betepa, kale whi̧ Saimon Pita a̧ simótóró ha̧le daapa, mené a̧paae duraalu, “Ya̧kélé ai whi̧né ama yó male whi̧ meié?” depa, Pitané duraalu, “Ai whi̧ta ȩ meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tétepa, momaratere topo whi̧né kutó diratere whi̧ beta̧ beterepó. A̧ta, take Pitané wosȩ́li tikale sekȩ́né ama fake whi̧pó. Ai sekȩ́né Pitapaae woseturaalu, “Ya̧ta, u Olip ni daae mole tikimó daapa kelale whi̧-a, kaeé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ai fo depa Pitané momó meipó, deretamotóró wa̧ kakaruk bané hale yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Dilikitamo ai ala deté wóló, hi̧ka be dȩtamo Yesu a̧ kale topo whi̧ Kaiapas-tamo betepa, Juda topo whi̧rapené Rom Gavman topo whi̧né bepaae dapesó felepó. Téyaletei, atima kale boseneyóló fele be dȩmó detere o̧la naaireteiné ai be dolopaae feni, belamó daae molepó. Ti noatepae, atima Juda meire whi̧né bepaae fupa, ai detere o̧la naalomeipó, yao̧sóró yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Atéró, kale Pailat a̧ belapaae tóȩ doropóló, atimapaae duraalu, “I whi̧ta, noa dowi alakó itikimó fo tokó̧tamo yóló diaao̧ a̧ só deraai de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ai fo depa, atimané a̧paae duraalu, “Amatamo Gavman whi̧né yóló muló betere fo tikiua̧meisóró, ti da̧né ya̧paae dapesó ua̧meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tétepa Pailat-né atimapaae duraalu, “I whi̧tamo fo teka̧ai depa, ti diaao̧ yóló muló betere fo sya fóló, diaao̧tei taleyaasepóló dapesó fae,” yalepó. Ai fo depa, atimané a̧paae duraalu, “Me whi̧ dowi ala depa, taleyóló sukó̧póló dae fo Gavman whi̧né da̧paae inipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yesu ha̧le bitutei, a̧ itéró suka̧alopóló taketi yóló mulale fo dokonó̧póló yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Atéró, kale Pailat a̧ ama bepaae momó fesaae fóló, Yesu a̧ beterepaae dapesó ape, yóló woseturaalu, “Ya̧ta, Juda fake so whi̧ tȩteróló kaae tare topo whi̧é?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tétepa, Yesuné a̧paae duraalu, “Ȩpaae ai wosetere fota, naao kisipanétei dépé, mené ȩ etei kaae whi̧póló ya̧paae depa de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ti fo depa, Pailat-né a̧paae duraalu, “Naao kisipané ȩta, Juda whi̧kó betepa de? Naao so whi̧ró so whi̧mó Talepaae momaratere topo whi̧rapetamoné ya̧ só deraai, ȩ beterepaae dapesó walepó. Téyalepa, naao atimapaae noa dowi alakó eraleé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ai fo depa, Yesuné duraalu, “Ya̧lo tȩteróló kaae tare alata, i haemó diaao̧ tȩteróló kaae tare ala kaae mei, ya̧lo tȩteróló kaae tare alata, mo kaepó. Ȩtamo diaao̧ tȩteróló kaae tare ala tua̧mó bitua̧sóró, ti Juda whi̧rapené ȩ daai depa, ya̧lo kutó diratere whi̧rapené bóe dua̧pó. Tépatei, ya̧lo tȩteróló kaae tare alata, kae tikimó kaaróló walepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ai fo depa Pailat-né duraalu, “Tépata, ya̧ tȩteróló kaae tare topo whi̧ mo airapó!” depa, Yesuné a̧paae tokó̧ mótu duraalu, “Naao ȩpaae topo whi̧pó dere fota, mo dono dapó. Ȩ Talené so whi̧ tȩteróló kaae tare whi̧ topo whi̧ betaai, i haepaae woó, ȩ i haemó mo soné deyóo, yalepó. Atépa, mepaae mo ala tua̧mó betaai ketekȩ butu betere so whi̧néta, ya̧lo dere fo mo dapóló wosetu beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ai fo depa, Pailat-né faletere fo kaae yóló duraalu, “Mo fo betepó dere-a, noaé?” yalepó. Ai fo yóló, kale Pailat a̧ Juda so whi̧ daae mole tikipaae tóȩ doropóló, atimapaae duraalu, “A̧ só deraaire bete tale yalemó, me alakélé mupa kilinipó. ");
INSERT INTO ppo_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Téretei, diaao̧ mara mole ala sya furaalu, kale boseneyóló fele be dȩmó o̧la detere sukamó dipula betere whi̧rapekó beta̧ fó̧póló, sokotua dapó. Atétua dere kaae, diaao̧ kisipané mió i o̧la detere be dȩmó Juda so whi̧ tȩteróló kaae tare topo whi̧ sokaró de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ai fo depa, atimané a̧paae fo fakeyóló duraalu, “A̧ meipó. Da̧né kisipanéta, Barabas da̧ beterepaae wó̧pólópa, dotȩyae,” du betalepó. Ti Barabas a̧ta, Gavman-tamo alale sóró bóe du betale whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Téró Pailat-né Yesu dapésó fóló, ama diki tare whi̧rapepaae fokosói ala yae yóló malepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Atéró, diki tare whi̧rapené Yesu faleturaalu, mu daai képi topo whi̧né deratere topo tao su̧róló aleyalepó. Téró Yesuné topomó deróo, sonaai kutikélé deróo yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Atéró, atimané momó dȩle momó dȩle yóló duraalu, “Juda so whi̧ tȩteróló kaae tare topo whi̧-ó, da̧né naao doi i sóró horatere ape,” yóló faletu betalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ai alarape yóló kemetepa, Pailat a̧ momó Juda so whi̧ betó molepaae fóló duraalu, “Ya̧lo ama yale ala taleyalemó, a̧ só deraaitere bete mekélé munipa, i dapesó walapa kelae!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Atéró Yesu faleturaalu, a̧ topo whi̧póló derale mu daai topo taoró sonaai kutitamo deró betepatei, belapaae dapesó dorowalepó. Atéró daapa, Pailat-né atimapaae duraalu, “Mió kale whi̧ i daalapa kelere?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Atéró, kale so whi̧mó momaratere topo whi̧raperó atimané sóró beteró betere whi̧rapetamoné Yesu dapesó wale kilitu, fo fakeyóló duraalu, “Filipaa ni tómó olerae!” yóló eneta du betalepó. Ai fo depa, Pailat-né atimapaae duraalu, “Ya̧lota, a̧ só deraaire bete mekélé munipa, diaao̧tei a̧ filipaa ni tómó olerae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Atétepa, kale Juda fake so whi̧ feané a̧paae sȩyóló duraalu, “Amatei a̧ Kótóné naalemapó du betepa, da̧né yóló muló betere foné, etei kaae fo dere whi̧ sukó̧póló dae fo erapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat a̧ taketa sawa wiyaletei, atéró dere fo woseturaalu, mo doasi winé suka̧lepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Atéró, a̧ kale Gavman topo whi̧né bepaae momó fesaae fóló, Yesupaae woseturaalu, “Ya̧ mé be huluapaae wale whi̧é?” yóló wosetepa, Yesuné a̧paae me fokélé tokó̧ menipó. ");
INSERT INTO ppo_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Atétepa Pailat-né a̧paae duraalu, “Ya̧lo ya̧paae wosetere fo naao tokó̧ menitere-a, ya̧ fó̧póló dotȩyaaitere ala ó, filipaa ni tómó oleraaitere ala yó̧póló, ȩ sóró beteró betere ya̧ kisipa inié?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ai fo depa, Yesuné duraalu, “Óté taoró betere Kótóné tȩteróló kaae tare fotoko̧ ya̧paae mólua̧meisóró, ti naao ȩpaae me alakélé erólua̧meipó. Térapa, ȩ naao naase tua̧mó mulale whi̧né ama yale dowi alanéta, naao dowi ala mo teraae falapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Atéró, kale Pailat-né ai dere fotóró woseturaalu, a̧ fó̧póló sokaaire tu̧ kikitu betalepó. Tétu betepa, Juda fake so whi̧né fo faketóró ha̧le yó taru duraalu, “Naaotamo a̧ fó̧póló dotonatepa, ti ya̧ Sisatamo beta̧ kutó ditere whi̧ meipó. Whi̧ me de amatei, a̧ topo whi̧ betaai dapóló wóputu betepa, ti ai whi̧né Sisatamo bóe dilapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Atéró, Pailat-né ai dere forape wosetu, Yesu belapaae dapesó doropóló, Pailat a̧ fo tokó̧tamo yóló taletere tikimó betalepó. Ai belané doita, kapo fake whamene tikipó. Hibru foné ti Kapata doi mulapó. ");
INSERT INTO ppo_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ai alarape yaleteita, kale boseneyóló fele be dȩ o̧la detere fula-mó, o̧la dótóró deyaairaalu, o̧la o̧la taleyóló mulatere be dȩmó 12 kilok sukakelemó yalepó. Atéró, kale Pailat-né Juda so whi̧paae duraalu, “Dia̧ tȩteróló kaae tare topo whi̧ i daalapa, kelae!” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ai fo depa, atimané duraalu, “Da̧né a̧ keletere hó̧rapa filipaa ni tómó oleraai dapesó fae yóló, dotopoi fo du betalepó. Tétepa, Pailat-né duraalu, dia̧ tȩteróló kaae tare topo whi̧ a̧ filipaa ni tómó oleraróe?” yalepó. Ai fo depa, kale mo so whi̧mó momaratere topo whi̧né duraalu, “Da̧ tȩteróló kaae tare whi̧ta me kae mei, Sisa beta̧ beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ai alarape yóló kemene furaalu, Yesu filipaa ni tómó olerae yóló, Pailat-né atimané naase tua̧mó mulalepó. Atétepa, kale diki tare whi̧rapené a̧ dapesó felepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Atéró furaalu, a̧ oleraaire ni fake amatei beleyóló oleraaire tikimó sókó felepó. Ai hae tikiné doita, suka̧le whi̧né topo diripó. Hibru whi̧rapené du betere foné ti Kolkotapó doi mulapó. ");
INSERT INTO ppo_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Aimó atimané a̧ filipaa ni tómó oleralepó. Atéró whi̧ tamokélé, me whi̧ ité dȩró oleróo, whi̧ me uté dȩró oleróo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Atéyale ki̧lipaae Pailat-né kale filipaa ni topomó a̧ i betené dalepóló etei fo asȩyóló oleralepó. Ita, Nasaret be whi̧kó Juda so whi̧ tȩteróló kaae tare topo whi̧ Yesupó ");
INSERT INTO ppo_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesu dóló olerale tikita, ai be hulua felekemó ereteiné Juda fake so whi̧né ai asȩyóló oleró betere fo dosa̧atu beterepó. Ai asȩyale fota, Juda so whi̧ feané dosa̧ayó̧póló, Hibru whi̧rapené du betere fonékélé, Rom fonékélé, Krik fonékélé, erepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Atéró, mo so whi̧mó momaratere Juda topo whi̧rapené Pailat-paae duraalu, “Juda fake so whi̧ tȩteróló kaae tare topo whi̧póló, asȩyao̧se. I whi̧né amatei duraalu a̧ta, Juda fake so whi̧ tȩteróló kaae tare topo whi̧pó, yale fo maaté asȩyóló olerae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ai fo depa, Pailat-né duraalu, “Ya̧lo asȩyale fo momó kae fisikini, ai fotóró atéró muló̧pólópó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Atéró, mepaae diki tare whi̧rapené Yesu filipaa ni tómó olerale ki̧lipaae dou̧ró diki tare whi̧rapené ama kutirape atima beta̧ beta̧ yóló salepó. Atéyaletei, Yesuné deróló sókó fatere boló kuti beta̧ ha̧le muni felepó. Ai kutita, me kwiatamo dekaaporóló dokoni, mo beta̧nétóró dokorepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Atéró, kale diki tare whi̧rape atimasisitei duraalu, “I kutita, terekeyóló kukwia saalomeipó. Beta̧ whi̧né saairaalu, atima doko̧ fea ni kwia siri mulóló, melaa yóló saalopa siépe yae,” yalepó. Ai alarape yaleteita, i asȩre fo dokonó̧póló yalepó. Ai fo i ape. “Ya̧lo kutirape atima sóró, bolómó deró betere fo̧lo kuti beta̧ muni fupa, ni fakerape fesekée deróló salepó,” erapó. ");
INSERT INTO ppo_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Atéyale ki̧lipaae, Yesuné ama hama Mariakélé, hamané kemakélé, Klopas-ne soma Mariakélé, Maktala sokó Mariakélé, Yesu oleró betere felekemó daae molepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Aimó Yesuné hamaró ama hosaa mole yó matere whi̧tamo daapa kolóló, hamapaae duraalu, “Ya̧lo hosaa mole hae ti so-ó, ai daale whi̧ta, naao naale ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Téró, ama ai yó matere whi̧paae duraalu, “A̧ta naao hae ai ape,” yalepó. Ai sukamó kaae sóró, ama ai yó matere whi̧né Maria a̧tamo betaairaalu, dape salepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nalo kale yaalopó yóló mulale ala fea kemeyalepóló kisipa mutu, kale asȩyóló muló betere fo dokonó̧póló, Yesuné duraalu, “Ȩ wȩi nokolerapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Atéró, aimó beta̧ kȩlaai wain wȩi wuti fa̧anóló mupa tepeyóló, kȩlaai wain wȩi wépi kaae o̧lamó tópuró sóró kape siki kaae o̧lamó haka sóró, ama ko̧lómó hamunalepó. Ai kape siki kaae o̧lané doita, hisop-pó. ");
INSERT INTO ppo_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Atéró, Yesu ai wȩi nóló duraalu, “Kale eraai yale ala fea mió su̧mó eróló kemeralepó,” yalepó. Atéró, ama topo haepaae hemée deyóló ama kepe bete Talepaae melóló suka̧lepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Atéró kale filipaa ni tómó olerale whi̧rape ha̧le olepatei, o̧la deyaai da̧le muló betere be dȩ sókó wao̧sóró, i ala yalepó. Dótóró o̧la deyaaire be dȩ sókó waaipa, o̧la o̧la taleyóló mulatere be dȩmó, kale oleró betere whi̧rape hó diri kolokóló teketapóló, Juda topo whi̧rapené Pailat-paae wosene felepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ai fo depa, kale diki tare whi̧rape fóló, kale folosóró ité olerale whi̧né hó diri ka̧ayóo, uté olerale whi̧né hó dirikélé ka̧ayóo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Téyaletei, Yesu kelalemó, a̧ taketi suki̧tikimó atimané ama hó diri ka̧anipó. ");
INSERT INTO ppo_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Aténi, atimakó beta̧ diki tare whi̧né ama fisinimó wuti deyalepó. Atéyale tikimó, ama fa̧keró wȩitamo mo wȩi kaae suniyóló dorowalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ai alarape depa kelale whi̧né ama mo kelale alatóró ha̧kearóló yó male fota, mopó. Ama ai du betere fo diaao̧kélé mopóló kisipa tiró̧póló, ha̧keamó yó mótu beterapó. ");
INSERT INTO ppo_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ai yale alarape feata, kale asȩmó i ere fo dokonóturaalu, yalepó. Ai fo i ape. “Ama diri mo beta̧kélé ka̧ayaalomeipó,” erapó. ");
INSERT INTO ppo_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Me asȩre fo i ape. “Atimané ama tikimó wutiné deyale whi̧ kelené kikéyóló kaae tawaalopó,” erapó. ");
INSERT INTO ppo_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Atéró, ai ala kemetepa etéyalepó. Arimatea be whi̧kó Josep a̧kélé Yesuné yó matere whi̧tei, Juda topo whi̧rape kolóló wituraalu, ama tuȩ́ tiki tiró betere ala ha̧keamó yó menipó. A̧ Pailat beterepaae fóló, Yesuné tiki tekaai dapóló, wosalepó. Téyalemó, kale Pailat-né a̧paae téyae depa, ama tiki tokóló só felepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Mo take dilikitamo Yesu beterepaae fele whi̧ Nikodimas-ró Josep-tamo wusuróné Yesuné tiki tokóló só faai dere ala fea yalepó. Atéró, beta̧ ni fȩ mur-ró mepaae felé kȩlaa wale o̧larape aloes-tamo hosekéró beteretei, Nikodimas-né sóró felepó. Ai o̧lané sekȩ da̧leta, 34 kilogram-rópó. ");
INSERT INTO ppo_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Atéró, kale whi̧ tamoné Yesuné tiki sóró felepó. Atéró doumó mulaairaalu, linen kutimó mepaae felé kȩlaa wale o̧larape terepeté fóló, Yesuné tiki bopeyalepó. Aita, atima Juda whi̧rape douróturaalu dere ala sya fóló yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu olerale tiki felekemó, beta̧ kutó erapó. Ai kutó tua̧mó whi̧ mo beta̧kélé dou erénire, kisi dou wisinaale aleyóló muló beterepó. ");
INSERT INTO ppo_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ti dótóró kale Juda fake so whi̧ sa̧a nóló betaaire be dȩ ereteiné kale doukélé mo felekemó epa, o̧la o̧la taleyóló mulatere be dȩmó ama tiki aimó douralepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Atéró, fula kaae sere be dȩmó hi̧ka be teó dȩteretamo Maktala sokó Maria Yesu mulale dou tópaae felepó. Atéró kelalemó, a̧ mulóló fokonale kapo fake tukwȩ fóló, tumó mupa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Atépa, kale so a̧ Saimon Pitaró Yesuné ama hosaa mole yó matere whi̧ metamo beterepaae sururuyóló fóló duraalu, “Tale atimané mopaae sóró fóló mulaleró da̧ tuȩ́nipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tétepa, Pitaró kale me whi̧tamo atima betere tiki taaróló, sururu yóló whi̧ dou tópaae felepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Atimaamo wusuró sururuyóló feletei, Pita taaróló kale me whi̧ a̧pi fóló, kale dou tómó sókó felepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Atéró a̧pi fóló, hemée deyóló kelalemó, Yesu bopeyóló mulale dȩi linen kuti beta̧ mupa kelalepó. Téyaletei, a̧ dou dolopaae fenipó. ");
INSERT INTO ppo_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Atépa, nalo Saimon Pita sókó woló, kale dou dolopaae fóló kelalemó, mepaae dȩi kutirape beta̧ molepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Yesuné ama tiki bopeyóló mulale dȩi linen kuti kae mulóo, ama topo boperóló mulale kuti kolokóló kae mulóo epa kelalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kale folosóró dou tópaae a̧pi sókó fóló, daale whi̧ a̧kélé nalo dou dolopaae derepelepó. Dou dolomó ai ere ala kilitu, ama tuȩ́ tiki tiralepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yesu a̧ sukó̧ló momó kepaa yaalopóló, asȩmó ere fo mo doko̧nalérapóló, kisipa sinipó. ");
INSERT INTO ppo_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Téró, kale whi̧tamo momó bepaae fesaae felepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Téyaletei, kale Maria a̧ dou até belaró daalu, woletu betalepó. Atétu bitu hemée deyóló, kale whi̧ mulale kapo dolopaae kopeyalemó, enseltamo mo dȩi kuti deróló, Yesu mulale tikimó beterepó. Me sekȩ́ topo mulalepaae betóo, me sekȩ́ hó eralepaae betóo, erepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Atéru, atimaamoné kale sopaae woseturaalu, “Ti so-ó, ya̧ noatepa wole du bitu de?” depa, ama duraalu, “Atimané ȩ tȩteróló kaae tare Tale mopaae mulale feleró ȩ ko̧ló ko̧ló depa du bitupó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ai fo yóló, a̧ fetée furaalu kelalemó, Yesu aimó daapa kelaletei, kale soné aita, Yesupóló kisipanipó. ");
INSERT INTO ppo_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tépa Yesuné a̧paae duraalu, “Ti so-ó, ya̧ noatepa wole du bitu de? Ya̧ de keketé kutu bitu de?” yalepó. Ai fo depa, kale soné ama kisipané ai kutó kaae tare whi̧ nisiyóló a̧paae duraalu, “Doa whi̧-ó, naaotamo sóró fipata, ti a̧ sene faai dapa, mulale tiki beta̧ ȩpaae yó melaasepé,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tétepa, Yesuné a̧paae “Maria-ó,” depa, a̧ daalepaae fete fóló, Eremeiki foné fakeyóló duraalu, “Raboni-ó,” yalepó. Ai fo bete feteyóló yó matere whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ai fo depa, Yesuné a̧paae duraalu, “Ȩ ya̧lo Aya beterepaae fenipa, naao ȩ tatere ala taalae. Ya̧tei fóló, ȩ ya̧lo Aya beterepaaekélé, diaao̧ Aya beterepaaekélé, ȩ tȩteróló kaae tare Kótó beterepaaekélé, dia̧ tȩteróló kaae tare Kótó beterepaaekélé, momó fesaae fulapóló, ya̧lo norapepaae ene fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Atéró, ai kale Maktala be hulua sokó Maria a̧ fóló, ama yó matere whi̧rapepaae duraalu, “Tale ya̧lo mo kelalepó,” yóló ama a̧paae yae yale forapekélé fea atimapaae yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Téró, fula kaae sere be dȩmó be diki deretamo ama yó matere whi̧rape atima kale Juda topo whi̧rape kolóló wituraalu, atima touróló betó mole be tu̧rape kinóló diróló betó molepó. Atéró betó mupa, Yesu atima betó mole tua̧mó sókó wóló duraalu, “Hosaa muni deyóló dua betere ala dia̧ tua̧mó muló̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ai fo yóló kemetepa, ama naasemó ikoko daleteiró fisinimó wuti deyale siritamo atimapaae yó malepó. Atéró, Tale kilituraalu, atima hosaa tua̧mó doasi hai̧né sukutere ala mo fa̧ayalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Atéró, Yesuné atimapaae momó duraalu, “Diaao̧ hosaa muni deyóló mo dua betó muae. Ya̧lo Ayané ȩ i haepaae wó̧póló dotonótu yale kaae, ya̧lokélé dia̧ fó̧póló dotonatapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Atéró, ai fo yóló kemetepa, ama fomo atima tikipaae sókó faróló duraalu, “Dȩi Kepe Wisi sae. ");
INSERT INTO ppo_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Diaao̧tamo mepaae whi̧né dowi ala kwia me o̧la meipóló ha̧le kemeratepa, ti Kótónékélé atimané yale dowi ala kwia ha̧le kemeró beterapó. Diaao̧tamo mené yale dowi ala kwia me o̧la meipóló kemeréni ha̧le tapa, ti Kótónékélé atimané dowi ala kwia kemeró bitinipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesuné ama yó matere 12 whi̧rapekó beta̧ ama doi Tomas-tei, Didimas-pó, du betere whi̧ Yesu atima beterepaae sókó wale sukamó, mepaae yó matere whi̧rapetamo beta̧mó bitinipó. ");
INSERT INTO ppo_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Atéró, kale mepaae ama yó matere whi̧rapené a̧paae duraalu, “Tale da̧né mo kelalepó,” yalepó. Ai fo depa, Tomas-né duraalu, “Ya̧lotamo ama naasemó ikoko dale siri kolóo, ikoko dale doloró fisinimó wuti deyale dolotamomó ya̧lo naase kesekée falóo initepa, ti diaao̧ dere fo wosóló, mo dapóló ya̧lo tuȩ́ tiki tiraalomeipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Atéró, fula beta̧ kemeyale ki̧lipaae ama yó matere whi̧rape atima momó touróló betale sukamó, Tomas a̧kélé atimatamo beta̧mó beterepó. Atéró, atima tu̧ kinóló betó mupa, Yesu a̧ sókó wóló atimapaae duraalu, “Diaao̧ hosaa muni deyóló mo dua betó muae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Téró Tomas-paae duraalu, “Ya̧lo naase ipa, naao kolóló, naase kesekée falóo, ya̧lo fisinimókélé naao naase dou̧ kesekée falóo ene ape. Téró, mió naao kisipa tamo mutere ala taaróló, tuȩ́ tiki tirae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ai fo depa, Tomas-né a̧paae duraalu, “Ȩ tȩteróló kaae tare Tale Kótóo,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ai fo depa, Yesuné a̧paae duraalu, “Naao ȩ mo kelaleteiné naao tuȩ́ tiki tiratapó. Mepaae whi̧ de ȩ kilinirutei, kisipa tiki tiratepa, ti ai so whi̧ atima Kótóné wisiró beterapóló hai̧né sukutu betaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Atéró, Yesuné ama yó matere whi̧rapetamo bitu, Kótóné eratapóló kisipa yó̧póló, kelemei alarape mo dekéró eraletei, fea i buk-mó asȩnipó. ");
INSERT INTO ppo_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tépatei, Yesu so whi̧ tȩteróló kaae tare whi̧ Kerisota, Kótóné Naalemapóló tuȩ́ tiki tiró̧póló, i alarape fea asȩyalepó. Ti a̧ta, etei kaae Talepóló, ama doimó yó mótu betere fo fea dosa̧ayóló tuȩ́ tiki tiróturaalu, dia̧ mo ti betere bete só̧póló yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Atéró ai alarape kemetepa, Yesuné ama yó matere whi̧rape Taiberius wȩi fókumó betó mupa, a̧ momó koló̧póló, yó male walepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Aimó, Yesuné ama yó matere whi̧ Saimon Pitakélé, Tomas-tei me doi Didimas-kélé, Kaleli hae kwiamó tȩne Kana be hulua whi̧kó Nataniel-kélé, Sebedi naalema tamokélé, ama yó matere whi̧ me tamokélé, atima fea touróló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Atéró bitu, Saimon Pitané atimapaae duraalu, “Ȩta, ya sene fulapó,” depa, atimané duraalu, “Da̧kélé fea faalopó,” yalepó. Atéró, atima fea nukumó betóló felepó. Téyaletei, ai dilikitamo ya mo beta̧kókélé sinipó. ");
INSERT INTO ppo_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Atéró, Yesu a̧ mo hi̧kati wȩi fókumó daapa kelaletei, ama yó matere whi̧rapené Yesupóló kisipanipó. ");
INSERT INTO ppo_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tétepa, Yesuné atima fo tekeróló duraalu, “Ti naalerape-ó, yakó saleé?” depa, atimané duraalu, “Meipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tétepa, ama atimapaae duraalu, “Diaao̧ ha̧leke wa tao sóró, nuku mole turu naase fakeró derae. Até depa, ti mepaae ya saalo ai ape,” yalepó. Ama ai yae dere alatóró yalemó, ha̧leke wamó ya mo dekéró deyaletikimó sekȩné tukaaire mo su̧nipó. ");
INSERT INTO ppo_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Atéró, Yesuné ama hosaa mole yó matere whi̧né Pitapaae duraalu, “Aita Talepó,” dere fotóró wosóló, Saimon Pitané tómó deratere kuti take sokóló mulaletei kakeróló, wȩipaae tu̧wó derepelepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Atéró, Pita a̧ wȩimó a̧laaté fu betepa, mepaae yó matere whi̧rape atima nukutamo a̧ sya fu betalepó. Atéró, atimané derale ha̧leke wamó, ya fa̧ayóló mupatei, wȩi fókuró nuku fole tikitamo felekereteiné si̧yóló só fu betalepó. Ai wȩi fókuró nuku foletikitamo da̧leta, 90 mita su̧pó. ");
INSERT INTO ppo_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Atéró, atima i wȩi fókumó sókó walemó, aimó si duku betepa kelalepó. Ai duku betere si keletómó ya biliyó mupa kolóo, bred orapekélé mupa kolóo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Atépa, Yesuné atimapaae duraalu, “Diaao̧ mió sale yarape mepaaekó ipaae sóró ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Atéró, Saimon Pita a̧ nukupaae biti̧ holóló kale ha̧leke wa wȩi fókupaae si̧yóló sóró walepó. Aimó dere doakale yarape dosa̧ayalemó, 153-ró derepó. Ha̧leke wamó doa atei yarape deyaletei, ha̧leke wa mo sawa tukó fole alakélé inipó. ");
INSERT INTO ppo_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesuné atimapaae duraalu, “Dia̧ i o̧la naai ape,” yalepó. Téyaletei, ama yó matere whi̧rapené a̧ Talepóló kisipa irutei, atimakó whi̧ beta̧nékélé ya̧ deé? yóló halaainé wosaaitere kisipa munipó. ");
INSERT INTO ppo_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Atéró Yesu a̧ wóló, bred o bularape terekeyóló atimamó malepó. Yarapekélé atétóró yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Aita, Yesu a̧ sukó̧ló kepaayóló bituraalu, ama yó matere whi̧rapené a̧ koló̧póló, tamo dakoróló yó melóló, mió ita, sore dakoróló yó male walepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Atéró, atima o̧la nóló kemetepa, Yesuné Saimon Pitapaae duraalu, “Jon-né naalema Saimon-ó, naao ȩpaae yaala sókó fole alané i whi̧rapené yaala sókó fole ala bosene fale?” depa, ama duraalu, “Tale-ó, ȩ́pó. Ya̧lo ya̧paae yaala sókó fole alata, naao ai tuȩ́re ape,” yalepó. Ti fo depa, Yesuné a̧paae duraalu, “Tépa, ti ya̧lo sipsip hupu malerapemó, o̧la wisiyóló melae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesuné kale fo kaae momó duraalu, “Jon-né naalema Saimon-ó, naao ȩpaae mo yaala sókó fule?” depa, ama duraalu, “Tale-ó, ȩ́pó. Ya̧lo ya̧paae yaala sókó fole ala naao ai tuȩ́re ape,” yalepó. Tétepa, Yesuné a̧paae duraalu, “Ya̧lo sipsip hupurape naao mo wisiyóló kaae tawae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Atéró Yesuné ama kale dere fo kaae sore dakoróló duraalu, “Jon-né naalema Saimon-ó, naao ȩpaae mo yaala sókó fule?” fo sore dakoróló deremó, Pitané ama hosaa tua̧mó sekȩ depa duraalu, “Tale-ó, fea ala naao kisipareteiné ya̧lo ya̧ yaala sókó fole ala naao tuȩ́rapó,” Ai fo depa, Yesuné a̧paae duraalu, “Ya̧lo sipsip hupurapemó o̧la mo wisiyóló melae. ");
INSERT INTO ppo_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ya̧lo ya̧paae mo i dapa wosae. Take ya̧ kokopei betale sukamóta, kuti naaotei deróló, naao faai kisipa mutere tikipaae fua yalepó. Téyaletei, take nalopaae ya̧ otere yóló betere sukamó, ti naao naase teréȩ faló betepa, naao kuti me whi̧né deróló, ya̧ hó̧re tikipaaetei dapesó faalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesuné etei kaae fo yaleteita, Pita a̧ atéró sukuturaalu, Kótóné ere ala wisinaale koló̧póló, ha̧kearaalopóló kisipa mutu yalepó. Atéró Yesuné a̧paae duraalu, “Ya̧ ȩ sya ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Atéró Pita a̧ fetée fóló kelalemó, Yesuné ama yaala sókó fale yó matere whi̧ atimaamo sya wou betalepó. Ai whi̧ta, take atima o̧la nale sukamó, Yesu tikimó tiróló bituraalu, “Tale-ó, ya̧ dó̧póló eleké deyaaire whi̧-a, deé?” yóló wosale whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Atéró, Pitané ai wale whi̧ kolóló Yesupaae woseturaalu, “Tale-ó, i wale sekȩ́ a̧ neyaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tétepa Yesuné duraalu, “Ya̧lo kisipané ai whi̧ a̧tamo bitiré fóló, ȩ momó fesaae wale sukamó sókó fó̧póló depa, aita naao yaaire ala meipa, ya̧ ȩ sya wale ala beta̧ yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yesuné a̧paae atei fo yalemótei, mepaae Keriso no nerapené ai yó matere whi̧ a̧ suka̧alo meipó yalepóló, feapaae deté kwȩyóló fakeralepó. Téyaletei Yesuné ai whi̧ a̧ suka̧alo meipóló ini, ama kisipané a̧ ha̧le bitiré fóló a̧ momó fesaae wale sukamó sókó fó̧pólópó depa, aita Pitapaae naao yaaire ala meipóló yale fomótei yalepó. ");
INSERT INTO ppo_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","I yó matere whi̧ta me kae mei, i alarape depa kelalepóló so whi̧ feané tuȩ́ yó̧póló, ha̧kearóló asȩyale whi̧pó. Ai sekȩ́né ama kolóló ai yale fo feata, mo dapóló da̧né tuȩ́rapó. ");
INSERT INTO ppo_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuné kae kae ala mo dekéró yaletei, ai alarape fea imó asȩnipó. Mo featamo mené asȩ depa, ti i hae kwia tua̧mó, ai fo asȩre buk-rape mulaaire tiki su̧yaalomeipóló kisipa mutapó. ");
INSERT INTO ppo_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiopilus-ó, take ya̧lo folosóró asȩyale buk-móta, Yesuné yale alaró yó male fotamo fea kaae sóró yó maté fóló, a̧ hepen bepaae fele sukamó sókó fele fo asȩ yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Yesu a̧ hepen-paae faai ha̧le bitu, Dȩi Kepe Wisiné fotoko̧ratepa, ama dosa̧ae sóró beteró betere aposel whi̧rapepaae i alarape yae yóló yó maté felepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A̧ doasi dele sale ki̧lipaae, mo ti dóló sukunale whi̧tei kepaayóló mo whi̧tóró beterapóló kisipa yó̧póló, whi̧ siki tamo 40 be dȩmó kale whi̧rape beterepaae sókó wua du betalepó. Atéturaalu, Kótóné tȩteróló kaae tare ao̧mó mole ala etérópóló yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Atéró beta̧ sukamó a̧ ama yó matere whi̧rapetamo o̧la nuku bitu, etei dirii fo yóló duraalu, “Ya̧lo Ayané dia̧mó ha̧le hamokoróló melaalopó ere o̧lamó kisipa mutu, ya̧lo dia̧paae take yalepó. Ai o̧la saasepóló, Jerusalem be taaróló feni, kaae tawóló ha̧le betae. ");
INSERT INTO ppo_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ti noatepae, Jon-né dia̧ wȩi ha̧le maaté tópurótua yaletei, mió mo felekemó dia̧ Dȩi Kepe Wisitamo tópuraalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Téró, atima beta̧mó touróló bitu, atimané a̧paae woseturaalu, “Tale-ó, take da̧ Israel fake so whi̧né da̧né hae kwia tȩteróló kaae taru yale kaae, miókélé ai ala yó̧póló yaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ai fo depa, Yesuné atimapaae duraalu, “Ai ala yaaire be dȩró alitamota, dia̧né kisipa yaaire ala mei, ya̧lo Ayané ama tȩteróló kaae taru, noa kaae ala yaai depa, ti ai be dȩmótóró erótua dapó. ");
INSERT INTO ppo_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Téretei, ya̧lo ȩ etei kaae whi̧póló yó matepa diaao̧ wosale fo Jerusalem be huluapaaekélé, Judia hae kwia kwiapaaekélé, Samaria hae kwiapaaekélé, i hae kwia dene fale doko̧ feapaaekélé, yó maté kwȩyóló mo su̧ró̧póló, ya̧lo dia̧ sóró i beteratere ape.” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ai fo du beteró kemetepa, kale whi̧rapené kele tómótóró Kótóné a̧ hepen bepaae dapesó horalepó. Atéró atima kese horótu yóló daae mupa, atimané keletómó kitiki dolomó buó deyalepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Téró, atima ó sa̧paae kese horólu yóló ha̧le daae mupatei, dȩi kuti deréli whi̧ tamo sókó wóló atima daae mole dȩmó daane walepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Atéró kale whi̧rapepaae duraalu, “Kaleli whi̧rape-ó, dia̧ noatepa sa̧paae kese horótu yóló daae mulu de? Dia̧tamo betepa hepen-paae dapesó horale whi̧ Yesuta, momó fesaae wouraalukélé, atérótóró hepen be taaróló waalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ai fo yóló ki̧lipaae, kale whi̧rape atima Olip du sorokó mole tiki taaróló Jerusalem bepaae fesaayóló felepó. Olip du sorokó mole tikiró doasi be hulua Jerusalem betamota saletó mei, kapala asiri fua wua dere tiki kaaepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Atéró fóló, atima betere siki be kepaae holalepó. Ai be kemó Pita, Jon, Jems, Andru, Filip, Tomas, Batolomiu, Matyu, Alpias naalema Jems, ka̧lo ka̧loi whi̧ Saimon, Jems naalema Judas atima atéró beterepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Atimatamo Yesuné ama mo nomarapekélé, ama hama Mariakélé, mepaae sorapekélé, touyóló Kótópaae moma dere ala yó tarepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","Atéyale sukamó, 120 Talepaae kisipa tiki tiró betere so whi̧ touró betere tua̧mó, Pita turukó horóló daalu i fo yalepó. “Ya̧lo norape-ó, mo take Dȩi kepe Wisiné Depit-paae yó matepa ama ere fota, Yesu daai dere whi̧rapepaae eleké deyaaire whi̧ Judas-mó erapó. Atéró asȩmó ere fo mió mo ai dokonale ape. ");
INSERT INTO ppo_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas-ta, da̧ 12 whi̧rapekó da̧tamo kutó diyó̧póló, sóró beterale whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas-né dowi ala yóló sale moniné a̧ sinaaire hae dupuralepó. Atéró amatei yale alamó a̧ képi wȩi naale tikimó tukó furaalu, haepaae topo fesaayóló doropóló depe fulukó felepó. Até yale hae tiki mepaae whi̧rapené a̧ douraairaalu, ama dowi ala yóló sale moniné dupuralepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalem so whi̧né Judas atéró suka̧lepó dere fo wosóló, atimané be foné ai hae tiki doi Akeldama mulalepó. Ai fo feteyóló samea sókó fele hae tikipó. ");
INSERT INTO ppo_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Atépa Pitané duraalu, “Ai ala yaalopóló take Sam buk-mó asȩyóló muló betere fo i ape. ‘A̧tei mo ti aluyóló ama bekélé wópu muló̧póló yae.’ erapó. Me fokélé i ape. ‘Ama diyale kutó whi̧né diyó̧póló, whi̧ kae sóró beterae,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ti fo ereteiné ai sekȩ́ betale sirimó, whi̧ mekó sóró beteraalopa siépe. ");
INSERT INTO ppo_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Take Jon-né wȩi tópurale alimó kaae sóró wóló, Tale Yesutamo da̧ fea beta̧mó kutu beteró, a̧ hepen-paae dapesó fele be dȩmó sókó wale whi̧kó sóró beteranérapó. Atétepa, ti ai sekȩ́ da̧tamo touyóló Yesu kepaayóló fele fo wisi yó maté kwȩyaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Téró atimané tale yaairaalu, whi̧ tamo Josep ama me doi Barsabas me doi Jastus-ró Matias-tamo doi mulalepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Atéró beteró bitu, atima feané Kótópaae moma yóló duraalu, “Tale-ó, da̧ feané mole kisipa tiki naao mo kelerapa, i whi̧ tamokó mé whi̧né naao kutó diró̧póló depa, ti naao da̧paae sóró a̧lae. ");
INSERT INTO ppo_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judas a̧ ama yale alamó dupu saaire tikipaae felepó. Téturaalu ama taaróló fele kutó mé aposel whi̧né diranépa, ti a̧ betale sirimó bitu diró̧póló naao da̧paae yó a̧lae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Atéró moma yale ki̧lipaae, atimaamoné doi muló betere kapo fake wutimó deróló kelé keléróló tuki̧yalemó, Matias-né doi moletei sókó dorowalepó. Atétepa, a̧ 11 aposel whi̧rapetamo touróló sóró beteralepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Israel so whi̧né o̧la deyóló nukua dere Pentikos be dȩ wapa, atima fea beta̧paae toura̧le wóló betó molepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Atéró betó molemó, hapale tétitóró ó sa̧mó doasi besȩ́ tikiné hu kaae deté dorowóló atima betere tikimó hu̧yóló supa feané wosalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Atéyale alanétei, so whi̧ doko̧mó simi kaae da̧leta yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tétu, kale Dȩi Kepe Wisi atima tikipaae atéró biti̧ wouraalu, sȩratepa kae kae be fo yaairaalu kaae salepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Atéyale sukamó, mepaae kae kae hae kwiamó betó mole Kótó kolóló witu betere Juda fake whi̧rape kapala asiri wóló Jerusalem be huluamó betó molepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Atéró atima besȩ́ tikiné hu kaae woseturaalu, so whi̧ mo fea beta̧paae toura̧le wóló betó mulu, noa ala dutérópóló sirayalepó. Ti noatepae, atimané wosalemó, kisipa tiki tiró betere fakerapené kae kae be fo atima doko̧ feané mo donotóró depa wosalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Atéteremó doasi siratu duraalu, “I Kaleli whi̧rapetei, da̧né be fo netéró tuȩ́ yalerópó? ");
INSERT INTO ppo_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Atima da̧né be fo mo donotóró dere-a, netéró derópó? ");
INSERT INTO ppo_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Da̧ Partia whi̧rapekélé, Media whi̧rapekélé, Elam whi̧rapekélé, Mesopotemia whi̧rapekélé, Judia whi̧rapekélé, Kapadosia whi̧rapekélé, Pontus whi̧rapekélé, Esia whi̧rapekélé, i betere ape. ");
INSERT INTO ppo_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frisia-ró Pampilia whi̧rapetamokélé, Isip-ró Sairin be hulua felekemó tȩne be Libia whi̧rapetamokélé, Rom bemó wale uké whi̧rapekélé, fea i wóló betó mole ape. ");
INSERT INTO ppo_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ai wóló tourale so whi̧ mepaae mo Juda fake yóo, mepaae kae faketei, Juda fakené dere ala sya fóo, dua dapó. Ai fake tamokélé, Krit whi̧rapekélé, Arabia whi̧rapekélé, da̧né be foné atimapaae Kótóné kae kae hapólui alarape eralepóló yó mótu betepa, mió da̧né i wosetere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Atétere alamó, i dosa̧ayale be hulua so whi̧né sira yóló atimasisi duraalu, “I ala yóló ki̧lipaae noa alakó sókó waai derópó,” du betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Até du betepatei, mepaae whi̧rapené ai ala do̧ nalóló duraalu, “Aita wain wȩi mo dekéró naletikimó topo doturaalu, ai dere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Téró Pita a̧ mepaae 11 whi̧rapetamo so whi̧ betó mole kuamó turukó holóló fo fakeyóló duraalu, “Jerusalem be whi̧ró da̧ mepaae Juda whi̧rapetamo-ó, i yale alarape bete dia̧paae ha̧keróló yaai dapa, mo wisiyóló wosae. ");
INSERT INTO ppo_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Diaao̧ kisipané i whi̧rape atima wain wȩi nale tikimó topo doturaalu dapóló de? Diaao̧tamo atei kisipa mutepa, ti mió wain wȩi nokole suka kele mei, ita hi̧ka 9 kilok i ape. ");
INSERT INTO ppo_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","I whi̧rapeta, wain wȩi nóló dumi, atima ai du betere ala take Kótóné ama ko̧ló whi̧ Joel-né asȩre fo dokonatapó. ");
INSERT INTO ppo_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Kótóné duraalu, ‘Kemeyaai dere alimó, ya̧lo Dȩi Kepe Wisi so whi̧ fea tua̧paae wȩi kaae sunée deraalopó. Téturaalu, diaao̧ naale senaalenékélé, Kótóné ko̧ló so whi̧né dere fo kaae yaalopó. Mepaae teó whi̧rapenékélé, nokené kilitu dere kaae yaalopó. Dia̧ mepaae otere serenékélé, noke yaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Até dere sukamó, Dȩi Kepe Wisi ya̧lo kutó diratere so whi̧ fea tua̧paae wȩi kaae sunée deratepa atimanékélé, ya̧lo take eraai dere alaró mió dere alatamo ha̧kearóló yó melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Atétepa, ó sa̧mó so whi̧né kolóló sira yaaitere alarape ya̧lo eraalopó. Atéturaalu i haemókélé me ala yaairemó eratere ala eróo, i hae samea sókó faróló, siró sukulitamokélé anóo, yaalopó. ");
INSERT INTO ppo_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ai ala dereteita, Talené ama mo kae ere dȩ doasi tukóló muló betere be dȩ waai teópa, suka bete feteyóló dilikiróo, wéliékélé feteyóló samea alée falóo yaalopó. ");
INSERT INTO ppo_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","So whi̧ dené Talené doi yóló ȩ tao sae depa, atétere so whi̧ aluyao̧sóró mo tao saalopó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israel whi̧rape-ó, i dere fo wosae. Nasaret be whi̧kó Yesuta, mo ha̧le whi̧ nisiyao̧sóró, so whi̧ feané kolóló sira yaaire alaró kelemei alatamokélé, me ala yaairemó eratere alakélé, fea eró̧póló, Kótóné a̧ sóró beteró beterapó. Ai alarape feata, ama eratepa diaao̧ kolóló, ai kisipare ape. ");
INSERT INTO ppo_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Beta̧ whi̧né Yesu eleké deyóló dia̧né naase tua̧mó mulalepó. Atétepa mepaae Talené fo woseni, dowi ala dere whi̧rapené dia̧ tao sóró a̧ filipaare ni tómó sinó̧póló oleralepó. Atéyale alata, Kótóné ama yaai kisipa mole ala dokonóturaalu erapó. ");
INSERT INTO ppo_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Téyaletei, ama tiki dou dolomó kȩlaa yao̧sóró sukutere alané fotoko̧ Kótónétei aluróo, a̧ mo ti suka̧letei Kótóné momó kepaaróo, yalepó. Ti noatepae, sukutere alané a̧ si̧yóló tawaaire mo su̧nipó. ");
INSERT INTO ppo_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mo take ai sekȩ́mó kisipa mutu, Depit-né i fo asȩrapó. ‘Betere doko̧ fea Tale ya̧lo kelepaamó daapa kilitua dapó. A̧ ya̧lo turu naase eró betere tikimó betereteiné ȩ me whi̧né woreróló só deranénipó. ");
INSERT INTO ppo_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Téreteiné ya̧lo hosaa betemó hȩkesené sukuturaalu, ya̧lo ko̧lónékélé, wole fo yóló ama doi sóró horatapó. Ya̧lo tikikélé, take me ala ini, mo wisiyóló betaalopóló kisipa mutu, hai̧tamo kaae tawóló i betere ape. ");
INSERT INTO ppo_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ti noatepae, take waaire alimó ya̧lo tiki dou dolomó mupa kȩlaa yó̧póló naao taaraalo meipó. Téturaalu, naao mo kae beteró betere whi̧ wisinaalené tiki kȩlaa yó̧póló taaraalo meipó. ");
INSERT INTO ppo_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ȩ wisiyóló betaaire tikipaae fó̧póló, naao tu̧ wisi alerapó. Ȩ ya̧tamo beta̧mó betepa, naao hai̧ dere ala mo fa̧anótu beterapó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Norape-ó, ya̧lo dia̧paae mo i dere ape. Da̧né ayarape deté wale whi̧ Depit sukutepa dourale douta, mió i be dȩmókélé ha̧le epa kilitu beterapó. ");
INSERT INTO ppo_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Téretei Depit a̧ta, Kótóné ko̧ló whi̧ betepa a̧paae dirii fo yóló duraalu, ‘Naao deté faaire naalené detere naalekó beta̧ ya̧ betale sirimó tȩteróló kaae tanó̧póló ya̧lo sóró beteraalopó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Take waaire alimó yaaire ala Depit-né ama kolóló i fo asȩrapó. ‘Kótóné so whi̧ fea tȩteróló kaae tanó̧póló sóró beteraaire whi̧ Keriso doumó kȩlaa yó̧póló taaréni, kepaaró beterapó.’ erapó. ");
INSERT INTO ppo_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu a̧ mo ti suka̧letei, Kótóné momó kepaaró beterapó. Atépa da̧ta, ai alarape mo depa da̧né kelené kelalepóló ha̧keamó yó maté kotere whi̧rape i ape. ");
INSERT INTO ppo_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yesuné o̧la o̧la fea ama tȩteróló kaae tanó̧póló a̧ Alima Kótóné turu naase dȩmó beteralepó. Alimané yóló mulale o̧la Dȩi Kepe Wisi ama naase tua̧mó mulalepó. Até depa, amamo da̧paae erale ala mió dia̧né kolóo, wosókélé yóo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Depit a̧ta hepen-paae fenitei, take waaire alimó yaaire alamó kisipa mutu i fo yalepó. ‘Talené ya̧lo Talepaae duraalu, “Ya̧ ya̧lo turu naase dȩmó betae. ");
INSERT INTO ppo_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Naao bóe whi̧rape ya̧ ao̧mó bitu, atima belei ao̧raaire ala ya̧lotei eraalopa, ha̧le kaae tawóló betae,” ’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Térapa, Israel fake so whi̧-ó, dia̧ i dere fo mo wosae. Dia̧né ai filipaa ni tómó oleróló dale whi̧ Yesutóró Kótóné a̧ kepaaróló da̧ fea tȩteróló kaae tanó̧póló topo whi̧kélé, Talekélé, ai sóró beterale ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pitané atéró dere foné ai wóló touró betere so whi̧né hosaamó mo sepake kaaené tikalepó. Téturaalu, Pitaró mepaae aposel whi̧rapetamopaae woseturaalu, “Norape-ó, mió da̧né noa alakó yaaloé?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ti fo depa, Pitané atimapaae duraalu, “Dia̧ doko̧ feané dowi ala taaróló, tuȩ́ tiki feteyóló betepa, Yesu Kerisoné doimó wȩi tópuró̧póló yae. Atétepata, ti Tale Kótóné naao yale dowi kwia kemeróló, ama Dȩi Kepe Wisi dia̧ ha̧le melaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kótóné ama eraalopóló ere fo mo dokonóturaalu, ‘Dia̧kélé, dia̧né naalerapekélé, be saletómó wale so whi̧kélé, mepaae Kótóné a̧ beterepaae apé dere fo wosóló wale so whi̧kélé, fea ai o̧la mo saalopó,’” erapó. ");
INSERT INTO ppo_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pitané ai fotamo mepaae forape olekeyóló fotoko̧iné duraalu, “Mió i alimó betere so whi̧né du betere dowi alané dia̧ felekemó, ai doratapa mo wisiyóló kaae tawae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Atéyale sukamó Pitané yó matere fo wosóló 3000 so whi̧ dowi ala taaróló kisipa feteyóló wapa wȩi tópuralepó. Atima atéró wóló take betere Keriso faketamo toune walepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Téró, ai so whi̧ atima aposel whi̧rapené yó matere fo mo wisiyóló wosóo, atima hamomatamo mo beta̧ tuȩ́ muóló u tao su i tao su dere ala yóo, o̧lakélé beta̧mó nóo, Kótópaae moma dere alakélé beta̧mó yóo, du betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kale aposel whi̧rapené so whi̧né kolóló sira yó̧póló eratere alarapekélé, kelemei alarapekélé, me ala yaairemó eratere alarapekélé depa, so whi̧né kolóló duraalu, Ita, Kótónétei eratapóló, winé sukutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Talepaae tuȩ́ tiki tiró betere so whi̧rape fea touróló beta̧ kisipa mutu, atimané o̧la o̧la mepaae ya̧ya̧re so whi̧ tao saalopóló fo dokalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Atéró, atimané mepaae o̧la o̧laró haetamo dotonóló moni sóró mepaae ya̧ya̧re so whi̧ malepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tétu, be dȩtere doko̧ atima mo fea momatere be belamó toura̧letatóró yó tarepó. Atima hosaa tua̧mó hai̧né sukutere ala mulu, hȩkesetamo atima fea me féli mené bemó o̧la nuku, me féli mené bemó o̧la nuku dua yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Até duraalu, Talené doi sóró horaté fu betepa, mo so whi̧né kolóló, aita mo donoi ala dapóló dukirótu beterepó. Ai ala du betepa, so whi̧ aluyao̧sóró Talené tao sóró Keriso so whi̧tamo Kótónétei betere doko̧ touróló sóró beteraté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Beta̧ sukamó, Pitaró Jon-tamo Talepaae moma yaairaalu tukóló muló betere sukakelemó, kuluka 3 kilok moma dere bepaae fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Atéró felemó, take hamané depemótei hó naase dowi whi̧ ai be bopéró betere tipi tu̧ sókó walemó beteraai beleyóló fu betalepó. Ai sekȩ́ta, momatere bepaae fua wua dere so whi̧paae monikó kema yó̧póló, suka fea whi̧rapené beleyóló mulaleta du betalepó. Ai whi̧ betera̧leta du betale tikita, mo kelaalo Koko̧i tipi tu̧póló doi mulapó. ");
INSERT INTO ppo_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kale whi̧ atéró sóró fóló beteró beteremó, Pitaró Jon-tamo moma ene faai fupa, atimaamopaae moni kema yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Atétepa, kale whi̧ tamoné a̧ kelené kikéró kaae taru Pitané a̧paae duraalu, “Naao da̧mo kelae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ti fo depa, kale whi̧né a̧mó me o̧lakó melaaitere nisiyóló kelené atimaamo kaae tarepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Atépa, Pitané duraalu, “Naao ai kematere o̧la silpa moni ó kold moni ȩ tanitei, ya̧lo tare o̧la beta̧ ya̧ i matere ape. Nasaret whi̧kó Yesu Kerisoné doimó i dapa, ya̧ turukó holóló kwȩyae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ai fo yóló, Pitané kale whi̧né turu naasemó taosóró turukó horóló daaralepó. Até deretamotóró ama dore hóró hó kelepetamo fotoko̧ buóló wisiyalepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Atéró, ai sekȩ́ a̧ tu̧ó horóló kwȩyaai kaae sóró, Pitaró Jon-tamo atima fea moma dere be belamó kutu betalepó. Atéró aimó a̧ tu̧ó holóló taaeta deté kuturaalu, Talené doi hale sóró horaté kwȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Aimó touró betere so whi̧ feané kale whi̧né Kótóné doi sóró horaté kotere ala kelalepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Atétepa, i whi̧ta momatere be bopére tipi kelaalo koko̧re tu̧ sókó walemó bitu moni kema dua yaletei, netéró wisiyalerópóló siratu betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Téró, kale whi̧né Pitaró Jon-tamo apuó tapa kelaai so whi̧ mo fea, Solomon-né doi mole be belapaae toura̧le wóló daae muluraalu, siratu betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pitané ai ala kolóló, atimapaae duraalu, “Ti Israel so whi̧-ó, noatepa dia̧ i ere alamó siratu bitute? Diaao̧ tuȩ́né ita, da̧moné fotoko̧né ó Kótóné ala da̧moné eró tareteiné wisiralepóló de? ");
INSERT INTO ppo_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Aisak, Jekop atimané Kótóta me kae mei, da̧né ayarapené Kótókélé mo beta̧tórótipó. Ai Kótóné ama kutó diratere whi̧ Yesu tao sóró doi mo doasi mulalepó. Ai ala ere whi̧tei, dia̧né a̧ mo ti dóló sukunaaire whi̧rapené naasepaae muló̧póló Pailat-paae melale felepó. Tétepa, Pailat-né ai whi̧ me dowi ala munipó depatei diaao̧ a̧paae duraalu, fó̧póló dotȩyao̧se yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mo kae beteró betere donoi ala dere whi̧ wisinaaletei diaao̧ hó̧róo, whi̧ dupa dipula beteró betere whi̧ dia̧paae dotonae yóo, yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","A̧ta, mo ti betere bete kaarale whi̧tei, dia̧né dóló sukunalepó. Téyaletei, Kótóné momó kepaaró beterapó. Ai alarape feata, da̧né keletómó mo yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Hó naase dopa dia̧ feané kilitu betere whi̧ta, da̧mo Yesupaae tuȩ́ tiki tiró betere alané a̧ wisiralepó. Ai tuȩ́ tiki tiratere alata, Yesuné da̧mopaae matepa, ama doiné i whi̧ mo ti wisiró beteretei mió diaao̧ ai kelere ape. ");
INSERT INTO ppo_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Norape-ó, ya̧lo mo i dere ape. Dia̧nékélé, diaao̧ topo whi̧rapené yale kaae, Yesu Tale Kótóné sóró beteró betere whi̧póló tuȩ́ muni yale ala da̧né tuȩ́rapó. ");
INSERT INTO ppo_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tépatei ai yale alata, mo take Kótóné ama ko̧ló whi̧rape feané ama sóró beteró betere whi̧ Keriso doasi dele saalopó ere fo Kótóné mo ai dokonó betere ape. ");
INSERT INTO ppo_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Térapa, du betere dowi ala taaróló, kisipa feteyóló Kótópaae ape. Atetepa, ti Kótóné ama feléyóló betere ala wisi dia̧ tua̧paae eraalo. ");
INSERT INTO ppo_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kótóné ama so whi̧ fea tȩteróló kaae tanó̧póló sóró beteró betere whi̧ dia̧ beterepaae dotonaalopa, kaae tawae. Ti ai whi̧ta, mo taketitei dia̧ tao só̧póló sóró beteró betere whi̧ Yesu ai ape. ");
INSERT INTO ppo_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ai sekȩ́ta, Kótóné kae beteró betere ko̧ló whi̧rapepaae ere fo dokonóturaalu, Talené i haemó ere alarape momó wisiróló kisi aleraaire be dȩ sókó wó̧póló kaae tarapó. Ai be dȩ teópa, ti a̧ hepen-mó ha̧le kaae tawóló beterapó. ");
INSERT INTO ppo_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses-nékélé, i fo asȩrapó. ‘Tale Kótóné dia̧mó kisipa mutu, dia̧kótei ama fo eratere ko̧ló whi̧ sóró beteraalo ai ape. Téyaalopa, ai sekȩ́né ama dere fo fea wosóló sya fae. ");
INSERT INTO ppo_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kótóné sóró beteraaire ama ko̧ló whi̧né dere fo dia̧ mepaae whi̧né wosóló sya fenitepa, ti atétere whi̧ Talené ama so whi̧tamo touyóló betao̧sóró sókó sóró kae beteraalopó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel betale alimó kaae sóró bitiré wale ko̧ló whi̧rapené deté wale fota, mió i alimó du betere alarapemó kisipa mutu erapó. ");
INSERT INTO ppo_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kótóné ama ko̧ló whi̧rapené ere foró Talené ama i ala eraalopóló ere dirii fotamo dokonóturaalu, dia̧paaetóró mo eraalopó. Mo take Kótóné Abraham-paae i fo yalepó. ‘Naao deté faaire naalerapekó beta̧ whi̧paae ya̧lo eratere wisi alané i haemó betó mole so whi̧ mo fea wisiraalopó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ai ere fo mo dokonóturaalu, Kótóné ama kutó diratere whi̧ Yesu Keriso sóró beteralepó. Atéró, a̧ dia̧ Israel fake so whi̧pi tao sóró wisiraai kisipa mutu, dia̧ beterepaae dotonalepó. Dia̧ doko̧ feané du betere dowi ala taaróló tu̧ wisipaae fó̧póló, ai sekȩ́né amatei diaao̧ kisipa tiki feteraalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Téró, Pitaró Jon-tamo kale fo wisi so whi̧paae yó mótu betepa, mepaae momatere be kaae tare diki tare whi̧rapené topo whi̧kélé, Sadyusi whi̧rapekélé, so whi̧mó Talepaae momaratere whi̧rapekélé, fea atimaamo beterepaae walepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Atima atéró betó mupa, Pitaró Jon-tamoné fo yó mótu duraalu, Yesu mo ti suka̧letei momó kepaayóló beterapó. Térapa, Yesupaae tuȩ́ tiki tiratere so whi̧kélé kepaayóló betaalopóló yó mótu beterepó. Atéró yó mótu betepa, kale whi̧rape atima dei tuȩ́ muóló fopaae bualepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Atéturaalu, ai kale whi̧rapené atimaamo tawóló fo tokó̧ló só deraai yaletei be diki depa, hi̧ka yaairaalu dilikitamo atimaamo dipula sóró beteralepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Téyaletei, atimaamoné yó male fo wosóló so whi̧ fea Talepaae kisipa tiki tiralepó. Atéyale whi̧rape maaté dosa̧ayóló touróturaalu, 5000-rópó. ");
INSERT INTO ppo_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Téró hi̧ka be dȩtepa, topo whi̧raperó Moses-né asȩre fo yó matere whi̧rapetamokélé, Juda whi̧ disirapekélé, fea Jerusalem bepaae toura̧le walepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Atétepa, atimatamo so whi̧mó momaratere whi̧rapené topo whi̧ Anas-kélé, Kaiapas-kélé, Jon-kélé, Aleksandakélé, so whi̧mó momaratere mepaae whi̧rapekélé fea wóló touró beterepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Atéró, Pitaró Jon-tamo dape sóró ai whi̧rapené atimaamopaae woseturaalu. “Ai ala yó̧póló diaamo né sóró beteraleé? ó né doimó diaamoné ai ala du bitute?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Tétepa, Dȩi Kepe Pita tua̧mó fa̧ayóló sȩratepa atimapaae tokó̧ mótu duraalu, “Dia̧ so whi̧ tȩteróló kaae tare whi̧raperó whi̧ disirapetamo-ó, dia̧né da̧mopaae ai wosetere fota, kale hó dore whi̧ ko̧lené sukuturaalu wisirale alamó de? ");
INSERT INTO ppo_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tétamo depa, ti dia̧nékélé, Israel so whi̧ feanékélé, wosaasepóló ha̧kearóló i dere ape. Dia̧né Nasaret whi̧kó Yesu Keriso filipaare ni tómó oleróló mo ti dóló sukunaletei, Kótóné a̧ momó kepaaralepó. Atéyale sekȩ́né doimó, da̧moné wisi erale hó dore whi̧ i daale ape. ");
INSERT INTO ppo_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesuta, asȩmó ere foné duraalu, ‘Dia̧ be tȩtere whi̧rapené dopa taae falatere kapo faketei, be hulua eleké alée felepó,’ erapó. ");
INSERT INTO ppo_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Da̧ aluyao̧sóró tao saaire whi̧ me kae mo bitinipó. Yesuné doimó beta̧ da̧ so whi̧ fea mo wisiyóló betenérapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Atéró, kale whi̧rapené kelalemó, Pitaró Jon-tamo wikélé ini fo mo halaainé du beterepó. Atéró dere fo woseturaalu, i whi̧ tamota me skul-kélé iniretei, dere fo mo fosó fosó dapóló siratu betalepó. Tétu atimaamo Yesutamo kwȩyale whi̧ tamopóló kisipa yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Téyaletei, Pitaró Jon-tamoné hó dopa wisirale whi̧kélé atima touró betere tikimó daaleteiné u kale whi̧rape atimané me fo yaaire tu̧ mei depa taaralepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Atétepa, Pitaró Jon-tamo kapala asiri belapaae ho̧kó deróló, ai whi̧rape atima fo kȩlaaralepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Atéró, kȩlaaróló duraalu, “Atimaamopaae da̧né noa alakó eraaloé? Jerusalem bemó betó mole so whi̧ feané atimaamoné kelemei ala eraletei, kolóló mo tuȩ́rapó. Téreteiné da̧né ai ala hiróló kapala fo enénipó. ");
INSERT INTO ppo_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tépatei, i fo so whi̧paae deté fóló fakerao̧sóró atimaamopaae dirii fo yóló mulaalopó. Ai Yesuné doimó so whi̧paae fo yó melao̧se yaalopa, siépe,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Atimapi atéró fo dokoló, kale whi̧ tamo momó bepaae ape yóló duraalu, Yesuné doimó mepaae dere alaraperó ama fo yó maté kotere alatamo momó kae yao̧se yóló fo mulalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ti fo depa, Pitaró Jon-tamoné duraalu, “Dia̧né kisipané da̧mo diaao̧ dere fo wosóló sya furaalu, Kótóné fo sya foletei taalatepa, Kótóné keletómó wisiréró dia̧nétei tale yae. ");
INSERT INTO ppo_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ti da̧né kelené kelale alaró wosale fotamo yó materetei, mo taaranénipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tétepa, kale whi̧rapené Pitaró Jon-tamopaae mepaae wiratere fo take yale tómó beleróló yóló, atimaamo fó̧póló dotȩyalepó. Atimaamopaae mepaae sekȩi ala eraai yaletei, bete atima ko̧ló ko̧ló depa taaralepó. Ti noa betené mei, so whi̧ feané atimaamoné erale alamó Talené doi sóró horatere kilituraalu, atima wi depa fó̧póló dotȩyalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ti noatepae, i kelemei ala eróló wisirale whi̧ta, hó doyóló betepa ba fo whi̧ siki tamokélé bosenée falapó. ");
INSERT INTO ppo_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Atéró Pitaró Jon-tamo fó̧póló sókó daalatepa, atimaamo mepaae Keriso so whi̧ betere tikipaae felepó. Atéró fóló bitu, so whi̧mó momatere topo whi̧raperó whi̧ disirapetamoné atimaamopaae yale forape fea atimapaae du betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Atétepa, Keriso so whi̧né ai fo woseturaalu, atima fea touyóló fo fake yóló Kótópaae doa kée yóló moma yalepó. Atéró duraalu, “Kótó-ó, ya̧ta doasi Tale bitu, o̧la o̧la fea naaotóró kaaróló tȩteróló kaae tarapó. Tale-ó, i haekélé, ó sa̧kélé, wȩi kȩlakélé, ai sore o̧la tua̧mó betere o̧laró ere o̧latamokélé fea naaotóró alerapó. ");
INSERT INTO ppo_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Naao Dȩi Kepe Wisiné naao kutó diratere whi̧ da̧né aya Depit tua̧paae su̧ratepa, ama ko̧lómó ere fo i ape. ‘Hae kwia doko̧mó betó mole so whi̧ noatepa fopaae buóló dei kisipa mutu betere? Juda fake so whi̧kélé me bete munipatei noatepa atima kikiti fo dokotu beteré? ");
INSERT INTO ppo_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","I hae kwia tȩteróló kaae tare topo whi̧rape atima bóe daai siki siki yóo, mepaae Juda fake tȩteróló kaae tare topo whi̧rapekélé fea beta̧paae toura̧le wóló, Taletamo bóe dóo, so whi̧ tȩteróló kaae tanó̧póló, Talené sóró beteró betere whi̧tamokélé bóe daai donoróo, erapó,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ti ai ere fo mo dokonalepó. Kale Herot-ró Pontias Pailat-tamonékélé, Juda meire fake so whi̧nékélé, Israel so whi̧nékélé, naao kutó diró̧póló sóró beteró betere whi̧ wisinaale Yesutamo bóe dóló só deraai, doasi Jerusalem bepaae toura̧le walepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Atéyaleteita, atima tuȩ́né kaayóló dere nisiyalemó, ai yale alarape fea Tale naao fotoko̧né eraalopóló, take ere fo mo dokonóló ai yale ape. ");
INSERT INTO ppo_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Térapa Tale-ó, mió atimané naao kutó diratere whi̧rape susupui ala eraairaalu wiréli fo du beterapa, naao tuȩ́ muae. Atétu betere tua̧mó da̧ wikélé ini, mo halaainé daalu, naao fo beta̧ yó mótu beteró̧póló halaai ala da̧paae erae. ");
INSERT INTO ppo_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Naao mo kae beteró betere kutó diratere whi̧ Yesuné doimó kisi daae mole so whi̧ wisiróturaalu, kelemei alaraperó doasi sira yaaire alatamo eraaire fotoko̧ naao da̧paae erae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Atima ai moma yóló kemerateretamo, atima betó mole be tao sóró woreralepó. Atéturaalu, Dȩi Kepe Wisiné atima mo su̧ratepa, so whi̧paae Kótóné fo mo halaainé diriyóló yó mótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kale Keriso so whi̧ atima fea ne no ao̧yóló bitu, mo wisi kisipa beta̧tóró muóló beterepó. Atéru, atimané mole o̧la o̧la fea ekȩleyóló sini, ya̧ya̧re so whi̧kélé tao sua yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kale aposel whi̧rapené Tale Yesu mo ti suka̧letei, momó kepaayóló beterapóló yó matere fota, Kótóné ama fotoko̧tamo yó melaté kutu betalepó. Atima atétu betepa, Kótóné ko̧lené sukuturaalu, ha̧le tao sere ala atima feapaae eraleteiné mo hai̧tamo dua beterepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ai ala iru, atima tua̧mó me so ó whi̧kó o̧la o̧la ya̧ya̧ dere ala mo inipó. Atima tua̧mótei, hae tiki tare whi̧né ama hae dotonóló moni sóo, be tȩne whi̧né ama be dotonóló moni sóo, yóló ai moni kale aposel whi̧rapené naase tua̧mó mulótua yalepó. Ai monita, mepaae o̧la o̧la ya̧ya̧re so whi̧mó terekeyóló a̧liróló mótua yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Lipai fake whi̧kó Saiprus be whi̧ ama doi Josep beterepó. Ai sekȩ́ta, aposel whi̧rapené Banabas doi mulalepó. Ai doiné beteta, so whi̧né hosaa dirirótu ketekȩ bulóló fotoko̧ratere whi̧pó doi mulalepó. ");
INSERT INTO ppo_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ai whi̧ Banabas-nékélé, ama hae kwia dotonóló moni sóró, ai moni ti aposel whi̧rapené naase tua̧mó mulalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Téró me etéyalepó. Whi̧ beta̧né ama doi Ananias beterepó. Ai sekȩ́ró soma Sapairatamo atimaamoné hae kwia dotonóló moni salepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Atéró sale moni mepaae soma atimaamo saairaalu fo deyóló, bukó mulóló, mepaae ti kale aposel whi̧rapepaae male felepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Atétepa, Pitané a̧paae duraalu, “Ananias-ó, Satan ya̧ tua̧mó bitu, Dȩi Kepe Wisipaae kapala fo noatepa yaleé? Naao hae dupu yale moni mepaae ya̧ saairaalu bukó mulóló, i sóró waletei hi̧tipó deretei, kapala fo ai dere ape. ");
INSERT INTO ppo_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Hae kwia dotonaai ha̧le mupa, ti naao haetóró molepó. Dotonóló sale moni-kélé, ti naao moni-tórótipó. Tétu, moni mepaae diaamo saairaalu, dekée sóró mepaae maaté Talepaae male waleteikélé wisirapó. Tépatei, naao dowi kisipa sóró yale kapala fota, mo whi̧paae ini, Kótópaaetei ai ere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Atéró dere fo kale whi̧ Ananias-né woseturaalu, Pita daalemó haepaae muni doropóló, mo ti suka̧lepó. Mepaae so whi̧né até yalepó dere fo woseturaalu, atima wió du betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tétepa, mepaae kokopei whi̧rape wóló kale whi̧né tiki kutiné bopéyóló doura̧le felepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Atéró, sore sukakele kemeyóló ai ki̧lipaae soma Sapaira ama whi̧paae erale ala tuȩ́ni, moko̧leyaa yóló Pita beteremó sókó walepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Atéró daapa, Pitané kale sopaae woseturaalu, “Naao whi̧ diaamoné hae dupu yale moni i hi̧tié?” yalepó. Tétepa, kale soné duraalu, “Ȩ́pó. Saletei, aitóróti hi̧tipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ai fo depa, Pitané a̧paae duraalu, “Noatepa naao whi̧ diaamo fo dokóló, Talené Dȩi Kepe Wisipaae kapala fo yóló, ka̧ae kelaai dilika̧leé? Atei ala yalemó, naao whi̧ doura̧le fele whi̧rape wóló tu̧ sókó walemó ai daae mole ape. Atimané ya̧kélé, atéró sóró fóló doura̧le faalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Téyalemó, mo ai fapotóró kale so Pita daale tikimó haepaae muni doropóló suka̧lepó. Atétepa, kale whi̧rapené kelalemó mo ti sukupa sóró fóló, ama oma dourale tikimó a̧kélé titiróló bulalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Até yalepó dere fo, Keriso so whi̧ró ai fo wosale so whi̧tamo doasi winé sukutu betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Téró kale aposel whi̧rapené kae kae kelemei alaró so whi̧né kolóló sira yaaire alatamo, so whi̧ betó mole tua̧mó erótu betalepó. Talepaae tuȩ́ tiró betere so whi̧ Solomon-né aleyale be tokwȩimó touróló bitua yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mepaae so whi̧né Keriso so whi̧né dere ala kolóló, atima dere ala mo koko̧rapó yóló dukirótu betaletei, atima ai so whi̧tamo touyóló betaalo witu betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tépatei, sokélé, whi̧kélé, Talepaae tuȩ́ tiki tiróló take betere Keriso faketamo toura̧leta yaletikimó Keriso so whi̧ fakeraté felepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Atétere alamó, mepaae hepo daae mole so whi̧rape sepelewa yóló wóló, Pita a̧ fua wua dere tu̧mó besekȩ tómó mulótua yalepó. Ti aita, Pita fua wua duraalu, ama suka asoné mepaae whi̧ wisiró̧póló kisipa muturaalu, dua yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalem be bopéróló tȩe mole be huluarapemó betó mole so whi̧ fea Jerusalem bepaae toura̧le walepó. Atéró wouraalu, mepaae hepo daale so whi̧kélé, dowi keperapené doasi susupu mótu betere so whi̧kélé, mo fea beleyóló wapa wisirótua yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","So whi̧mó momaratere topo whi̧ró mepaae Sadyusi fakekó i sekȩ́né ama fulumu whi̧rapetamoné aposel whi̧rapené dere alamó atimatamo dei fopaae bualepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Atéturaalu, kale aposel whi̧rape dipula sóró beteralepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Téyalemó, dilikitamo Talené ama ensel wóló, ai dipula be tu̧ tuki̧yóló kale aposel whi̧rape belapaae dapesó derepelepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Atéró duraalu, “Dia̧ fóló momatere be belamó daalu, so whi̧paae mió wosetere kisi fo wisi etérópóló yó melaai fae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Téró hi̧ka be dȩtepa, ensel-né yale fo wosóló, momatere be belamó daalu, so whi̧paae Talené fo kaae sóró yó malepó. Atéyale ki̧lipaae so whi̧mó momaratere topo whi̧ró, ama fulumu whi̧rapetamoné kale fo tokó̧ló taletere whi̧rapepaae ape yó faralepó. Ai whi̧rapeta, Israel whi̧ disirape atimatórótipó. Ai fakerape fea wóló, mepaae diki tare whi̧rapepaae dipula bepaae fóló, kale aposel whi̧rape dape sene fae yóló dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tétepa, fóló kelalemó, kale aposel whi̧rape dipula bemó bitinipa kelalepó. Atépa yaai dapóló atima momó fesaae walepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Atéró atimapaae duraalu, “Dipula be tu̧ta, da̧né kinale alatóró epa kelalepó. Téró, tu̧ kaae tare diki tare whi̧rape atimakélé, kale tikimótóró daae molepó. Atépa, da̧ tu̧ tuki̧yóló kelalemó, atima bitinipó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dipula be kaae tare diki tare whi̧rapené topo whi̧ró so whi̧mó momaratere whi̧rapené topo whi̧tamoné ai dere fo woseturaalu, ai aposel whi̧rape-a, noa yalerópóló atima tuȩ́ teketu betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Atétu beteremó, whi̧ beta̧ wóló duraalu, “Wosae, dia̧né dipula beterale whi̧rapeta, u momatere be belamó daalu, so whi̧paae fo yó mótu betere ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ai fo depa, diki tare whi̧rapené topo whi̧ró ama diki tare whi̧rapetamo fóló, kale aposel whi̧rape tawóló sóró walepó. Atéró, dapesó wouraalu, ho̧ko si̧yóló só ani, naamei alané dapesó walepó. Ti noatepae, so whi̧né kapo duné atima siriyóló dao̧sóró wi yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Atéró kale whi̧rape dapesó fóló, fo tokó̧ló taletere whi̧rape betó mole tikimó daalalepó. Atéyaleteita, moma dere topo whi̧né wosetere fo yóló taleyó̧póló yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Téró, kale so whi̧mó momaratere topo whi̧né aposel whi̧rapepaae duraalu, “Da̧né dia̧paae ai whi̧ Yesuné doimó momó kae yó melao̧se yóló fo mulalepó. Téyaletei, dia̧né yó mótu betale fo i Jerusalem be hulua so whi̧ mo feané wosalepó. Diaao̧ ai dere alané Yesu sukó̧póló daleteimó, da̧paae kwia tokó̧ meló̧pólópó yóló kisipa mutu du bitu de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ti fo depa, Pitaró mepaae aposel whi̧rapetamoné tokó̧ melótu duraalu, “Mo whi̧né fo sya furaalu, Kótóné fo yó matere ala taarénipó. Kótóné ama yae dere ala beta̧ mo eranérapó. ");
INSERT INTO ppo_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Diaao̧ ni tómó oleróló dale whi̧ Yesu dou dolomó mupa, da̧né ayarapené Kótóné momó sóró ai kepaaró betere ape. ");
INSERT INTO ppo_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tale Kótóné a̧ kepaaróló ama turu naase dȩmó doasi Topo whi̧ beteróo, da̧ aluyao̧sóró tao saaire whi̧kélé sóró beteróo, erapó. Ti aita noa ala yó̧póló ini, Israel so whi̧ dowi ala taaróló tuȩ́ tiki feteyóló wó̧póló erapó. Ai ala depa, ti da̧né yale dowi alamó saaire kwia Kótóné tokó̧ló alu eranérapó. ");
INSERT INTO ppo_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ai yale alarape fea da̧né kelené kolóló mepaae so whi̧paae yó melótu beterapó. Ti atétere kaae Dȩi Kepe Wisinékélé, da̧né dere fo kwia tao sóró erótu beterapó. Mepaae so whi̧ Kótóné fo wosóló ao̧mó sukó̧ló betepa, atétere so whi̧paae ama Dȩi Kepe Wisi take meló beterapó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kale fo tokó̧ló taletere whi̧rapené i dere fo woseturaalu, atima mo doakale fopaae buóló kale aposel whi̧rape mo ti daai kisipa mualepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Até du betepatei, ai tua̧mó Farisi whi̧kó beta̧ ama doi Kamaliel beterepó. Ai sekȩ́ a̧ta, Moses-né asȩre fo diriyóló tuȩ́ru yó matepa, so whi̧ feané ama dere fo mo wisiyóló wosetua dapó. A̧ atére alamó ama doi doasi mulapó. Ai whi̧ kale fo taleratere whi̧rape betó mole kuamó turukó holóló duraalu, “Ai whi̧rape belapaae kapala asiri doropó̧póló yae,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Atéró, kale whi̧rapepaae duraalu, “Israel fake whi̧rape-ó, dia̧né ai whi̧rapepaae eraai kisipa mutu betere ala hapale kilitaróló ini, tuȩ́pi tekeyae. ");
INSERT INTO ppo_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ti noa betené dumitei, i ere alamó da̧ wisiyóló kisipa saalopó. Take bitiré wale alimó, whi̧ beta̧ Teudas-né duraalu, ȩta ha̧le whi̧ meipó. Tȩteróló kaae tanó̧póló sóró daaló betere whi̧pó depa, mepaae 400 whi̧rape a̧tamo toune walepó. Téyaletei, bóe dale sukamó atimané a̧tei dupa, ama bóe belera̧le fele whi̧rape dapo dapo yalepó. Téturaalu, ama yaai kisipa muale ala alu yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Atéyale ki̧lipaae Gavman whi̧rapené so whi̧ doi siré kwȩyale sukamó Kaleli whi̧kó Judas-né i ala yalepó. Mepaae whi̧rape hosaa diriróló hai̧raté kwȩyóló duraalu, ‘Da̧ Gavman-tamo bóe dȩle faalopó. Atéró atima dóló torokó̧ faróló, atima betale sirimó da̧né tȩteróló kaae tawaalopó,’ yalepó. Téyaletei, Gavman whi̧né kale sekȩ́ a̧tei delemó, atima whi̧rape botokó dapo dapo yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Atérapa, mió i du betere alamókélé ya̧lo kisipa mole fo beta̧ dia̧paae i dapa, wosae. I whi̧rapepaae me ala eréni, ha̧le fó̧póló dotȩyae. Atimané take nalopaae yaai dere alamó kisipa mutu, mió ai du betere alatamo mo whi̧né kisipa mole ala yaai depa, ti doyóló haepaae derepaalopó. ");
INSERT INTO ppo_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Téni, i dere alatamo Tale Kótó tua̧mó kaayóló wapa, ti diaao̧ atima dere ala sesé enénipó. Ai alatamo depa, ti Kótótamotei bóe du beterapóló dia̧nétei ka̧ae kolóló kisipa yaalopó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kale sekȩ́né dere fo mepaae whi̧rapené wosóló, téyaalopóló kisipa mualepó. Atima ai fo yóló ki̧lipaae kale aposel whi̧rape momó bepaae holae yóló, halika tikiné fokosoi ala yalepó. Atétu beteró, atimapaae fo mulóló duraalu, “Yesuné doimó dia̧né fo momó kae yó melao̧se,” yóló fó̧póló dotonalepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Téró, kale aposel whi̧rape atima ai whi̧rape betere tiki taaróló felepó. Atéró atimasisi duraalu, “Yesuné doimó da̧ halika tikiné fokosó sóró susupu eratere alakélé, hale seratere alakélé, eró̧póló Kótóné amatei, da̧ dosa̧ae sóró beteralepó. Ama ai ala eró betereteita, sekȩi alarape da̧né mo su̧mó belenépa erapóló,” atima hȩkesené sukuté felepó. ");
INSERT INTO ppo_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Atéró, atima betere doko̧ momatere be belamókélé, be doko̧ doko̧kélé, Yesu Keriso a̧ etei kaae whi̧póló so whi̧paae ha̧keamó kale fo wisi ha̧le yó maté fu betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Atéyale sukamó, Talepaae tuȩ́ tiratere whi̧rape mo dekéró faketé felepó. Até duraalu, aimó betó mole Krik fo bole Juda whi̧rapené Hibru fo bole Juda whi̧rapepaae o̧la taleturaalu, wisiyóló a̧li dumipóló alale su betalepó. Atéró duraalu, dia̧ Hibru fo bole wulia sorapemó betere doko̧ fea nokole o̧la su̧mó a̧liróló móturaalu, da̧ Krik be fo bole wulia sorapemó meni dere-a, noatepa de yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Atétepa, kale 12 aposel whi̧rapené mepaae Keriso so whi̧rape feapaae toura̧le ape yóló touró betepa duraalu, “Nokole o̧la tale yóló a̧liratere kutó diaai, Kótóné fo yó matere ala sisópaae erateretei wisinipó. ");
INSERT INTO ppo_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Térapa, norape-ó, dia̧ tua̧mó betó mole whi̧rapekó fopeyóló, Dȩi Kepe Wisi fa̧anu fosó fosói kisipa mole wȩikeró whi̧rapekó sóró beterae. Atétepata, ti ai kutó atimané tȩteróló kaae tawó̧póló atimané naase tua̧mó mulaalopó. ");
INSERT INTO ppo_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Atéróló da̧né diyaaire kutóta, ti so whi̧ tao suraalu moma dere ala yóo, Tale Kótóné fo yó melatere ala yóo, yaalo ai ape,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Atéró ai whi̧rapené dere fo so whi̧ feané wosóló mo wisirapóló kisipa mualepó. Atéró so whi̧ feané fopeyóló, Stipen sóró beteralepó. Ai sekȩ́ta, Dȩi Kepe Wisi fa̧anu tuȩ́ tiki tiró betere whi̧pó. Atéró sóró beterale whi̧rape ti etérópó. Filip, Prokorus, Nikanor, Timon, Parmenas, Antiok be whi̧kó Nikolas atima atéró sóró beteralepó. Nikolas a̧ta Juda whi̧ meitei, Juda whi̧rapené dere ala sya fu betere whi̧pó. ");
INSERT INTO ppo_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Téró, kale so whi̧né ai whi̧rape dapesó fóló aposel whi̧rapené naase tua̧mó mulalepó. Atétepa, ai whi̧rapené atima tikimó naase mulóló Talepaae moma eralepó. ");
INSERT INTO ppo_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ai ala yale tikimó, Kótóné fo hae kwia feapaae yó melaté fóló fakeralepó. Jerusalem be hulua tua̧mó Talepaae tuȩ́ tiki tiratere whi̧rape mo ti fake duraalu, so whi̧mó momaratere whi̧rape atimakélé, mo fea tuȩ́ feteyóló tiróturaalu, kale fo wisi wosóló Yesupaae kisipa tiratere ao̧mó betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Téró, kale sekȩ́ Stipen Kótóné ama ko̧lené sukutu ha̧le tao sere alaró Talené fotoko̧tamo a̧ tua̧mó fa̧anepó. Téturaalu, mo doasi kelemei alaró sira yaai dere alatamo so whi̧ fea kuamó erótu betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Atétu betepa, mepaae whi̧rape Stipen-tamo bóe dóló fopaae butu, a̧ só deratere fo yalepó. Ai whi̧rape atimané fo wosetere be doita, wae sóró kutó diratere whi̧ betere ala taaróló atima ko̧leaané ha̧le betó mole whi̧rapené fo wosetere bepó doi mulapó. Ai whi̧rape atima wale tikita, Sairin be hulua whi̧kélé, Aleksandria be hulua whi̧kélé, Silisia hae kwiamó betó mole whi̧rapekélé, Esia hae kwiamó betó mole whi̧rapekélé, atérópó. Ai fakerape atimané be huluata kae kaetei, Juda fakepó. ");
INSERT INTO ppo_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Atéyaletei, Stipen-ta Dȩi Kepe Wisi fa̧anu fosó fosó yóló du betere fomó, u whi̧rapené dowi kisipa mutu du betere foné atimané a̧ só deraairetei mo su̧nipó. ");
INSERT INTO ppo_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Atéteremó, Stipen só deraaire tu̧ kikituraalu, atimasisi kemei mepaae whi̧rapetamo fo dokóló etei kaae kapala fo yaalopa siépe yalepó. “Ai whi̧né Kótókélé, Moses-né ere fokélé, doka doka yóló bóe duraalu, faletere fo depa, da̧né wosalepó yae,” yóló, sȩ yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Atéró, so whi̧paaekélé, Moses-né asȩre fo yó matere whi̧rapepaaekélé, whi̧ disirapepaaekélé, Stipen-tamo fopaae buó̧póló, sesemeratere fo deté kwȩyalepó. Atéró, kale whi̧ Stipen tawóló só fóló fo tokó̧ló tale dere whi̧rapené naase tua̧mó mulalepó. ");
INSERT INTO ppo_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Atéró daaló bitu, kale kapala fo yóló só deraai kisipa mutu betere whi̧rapené duraalu, “I sekȩ́néta suka fea kale yóló muló betere fokélé faleyóo, Kótóné ama kae tȩnó betere moma dere bekélé doróló doka doka yóo, deté kotapó. ");
INSERT INTO ppo_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Téturaalu, etei kaae fokélé depa da̧né wosalepó. Nasaret whi̧kó Yesuné i be fisikóló doróo, Moses-né asȩre mara mole fo da̧paae matepa, da̧né sya fu betere alakélé doróo, yaalopó depa, da̧né wosalepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Téró, ai wóló betó mole fo tokó̧ló taletere whi̧rapené kale sekȩ́ Stipen kikéyóló kaae tawalemó, ama kelepaa ensel-rapené kelepaa kaae daalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Téró, so whi̧mó momaratere topo whi̧né Stipen-paae woseturaalu, “Atimané ya̧ só deraairaalu ai du betere fo-a mo de?” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ti fo depa, Stipen-né atimapaae tokó̧ mótu duraalu, “Noraperó ayarapetamo-ó, ai fo ya̧lo dia̧paae i dapa wosae. Mo take da̧né aya Abraham a̧ Haran hae kwiapaae faai Mesopotemia hae kwiamó ha̧le betepa, kae dȩ fa̧ane Kótó Abraham beteremó sókó weipakalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Atéró, Abraham-paae duraalu, ‘Ya̧ta, naao be whi̧ so whi̧ró naao turuku betamo taaróló, ya̧lo ya̧paae yó melaaire hae kwiapaae fae,’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ai fo depa, ama turuku be Kaldia whi̧rape betere hae taaróló, Haran be huluapaae torókó̧ felepó. Atéró fóló betepa, aimó kale whi̧ Abraham-né alima sinalepó. Atéyale ki̧lipaae Kótóné Abraham a̧ dapesó wóló mió dia̧ ai betó mole hae kwiamó beteralepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kótóné Abraham-mó i hae kwia melaalopó yóló mulaletei, ai alimó hae kwia mekó menipó. Kutó diyaaire su̧ mo sawakélé menipó. Atéyale alimó Abraham a̧ naalekélé bitinipatei Kótóné a̧paae duraalu, ya̧ró naao deté faaire naaletamoné i hae kwia saalopóló dirii fo yóló munélipakalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kótóné Abraham-paae duraalu, ‘Naao detere naalené deté fole naalerape atima fea kae fakené hae kwiamó wale whi̧ su̧ betaalo ai ape. Atéró betepa, ai hae talerapené atima wae sóró kutó diratere so whi̧ beteróló, doasi depe tukó wei alaró susupui alatamo deté fu betepa, 400 ba fo kemeyaalo ai ape. ");
INSERT INTO ppo_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Atépa, Israel fake wae sóró beterale be hulua whi̧né topo whi̧rape ya̧lo dowi kwia melóló ya̧lo i so whi̧ momó dapesó woló beteraalopó. Kótó a̧ta, da̧ tȩteróló kaae tare Talepóló ao̧mó dua sukó̧ló betaalopó. ");
INSERT INTO ppo_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Naao detere naalené detere naalerape tiki sekaȩ tukóló sirirae. Atétepa, ti ya̧lo dia̧mó eraaire ala ha̧sókó feni, mo eraalopóló dirii fo yóló mulótu eratere siripó,’ yalepó. Atéró, Abraham-né Aisak deyalepó. Aisak deyóló be dȩ 8-ró kemetepa, ama naalemané tiki sekaȩ tukóló siriralepó. Téró, Aisak-né Jekop deyalepó. Jekop-né ti da̧né ayarape deyóló fake firale 12 whi̧rape deyalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jekop naalemarapené noma dekȩ naale Josep-né dere alamó dei tuȩ́ muturaalu, atimané a̧ Isip whi̧rapené wae sóró kutó diratere whi̧ beteró̧póló dotonóló moni salepó. Téyaletei, Josep-paae wuatere sekȩi ala fea Kótóné tao sua du betalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Téró, Josep a̧ Isip hae kwia tȩteróló kaae tare topo whi̧ Fero beterepaae sókó fóló beterepó. Atéró betepa, Fero-né Josepené dere ala kilitu, a̧paae hȩkese yó̧póló, Kótóné mo donoi ala wisi erótu betalepó. Atépa kilituraalu, Fero-né Isip hae kwiaró doasi topo whi̧né wisi wisi berapetamo Josep-né tȩteróló kaae tanó̧póló, sóró beteralepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Atéyale alimó o̧la sóku aluyóló doakale wote ali walepó. Atéturaalu Isip hae kwiamókélé, Kanan hae kwiamókélé, da̧né ayarape atima naaire o̧la mo meipó. ");
INSERT INTO ppo_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Atéró betalemó, da̧né ayarape deyale whi̧ Jekop-né Isip bemó mepaae nokole o̧la muó mulapó dere fo wosóló, ama naalemarape dotonalepó. Ti aita, folosóró kaae suraalu felepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Atéró momó felemó ti Josep-né ama nomarapepaae a̧ i ape, yóló yó melalepó. Atétepa, kale tȩteróló kaae tare doasi topo whi̧ Fero-né Josep-né alimaró nomarapetamo tuȩ́ yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Téró, Josep-né ama alimapaae yó fótu duraalu, ‘Ya̧kélé naao fake so whi̧kélé, dia̧ fea ai hae kwia taaróló, ipaae torokó̧ló ape,’ yalepó. Tétepa, 75 so whi̧ ai be torokó̧ló walepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jekop atéró bitiré fóló, a̧ Isip bemó suka̧lepó. Téró, ama naalemarapekélé, mo fea aimótóró suka̧lepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Atétepa, atimané tiki beta̧ só fóló, Sekem hae kwiamó mole kapo dolomó doura̧leta, dua yalepó. Ai hae tikita take Abraham-né Hamor naalemarapetamo moniné dupuyale haepó,” yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Até deté wóló, take Kótóné Abraham-tamo yóló mulale fo dokonaaire be dȩ feleketepa, atimané deyale naale senaale Isip bemó mo ha̧le o̧la kaae fake yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Téró, take betale topo whi̧ Fero-ró Josep-tamo suka̧lepó. Atéyale ki̧lipaae ai sirimó betale topo whi̧ Fero-né Josep-né a̧ ai topo whi̧ beterale ala tuȩ́ iniruraalu kale Israel fake so whi̧ wisiyóló kaae tanipó. ");
INSERT INTO ppo_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Atéruraalu, ai topo whi̧né Israel fake so whi̧tamo doakale bóe duraalu, Israel sorapené naale detepa, sukó̧póló bela tómó wapelatamo mulaleta dua yaai, atima fo dokóló mulalepó.” ");
INSERT INTO ppo_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Atétu betere tua̧ dolomó, Moses deyalepó. Ai naaleta, Kótóné keletómó mo kae naale wisipó. Hamaró alimatamoné ai naale sóró betepa, wélié sore kemeyalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Téró, hamaró alimatamoné wapela turó só fóló mulalepó. Atéró mupa, kale topo whi̧ Fero senaalemané whaayaai salepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Téró mepaae doasi tuȩ́ mole Isip whi̧rapené Moses tuȩ́ tiki fosó fosó yó̧póló, mepaae alarape yó melaté felepó. Téró, ama dere fokélé, mo fosó fosó yóo, dere alakélé mo fotoko̧ buóló yóo, yaaire whi̧ doayalepó,” erapó. ");
INSERT INTO ppo_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses doayóló bitiré fóló, ba fo whi̧ siki tamo kemeyóló a̧ ama Israel so whi̧rape noa ala du beteréró kȩle felepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Atéró fóló kelalemó, kale Isip whi̧ beta̧né Israel whi̧ beta̧ doló susupurótu betepa, kelalepó. Atétu betepa, ama fake whi̧tamo até ekeséró seséturaalu, Isip whi̧ mo ti dalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses-né ama etei kisipa mualepó. Israel fake so whi̧ atimapaae doasi sekȩi ala erótu betepa, ama fake so whi̧ tao só̧póló Kótóné a̧ dotonélirapóló kisipa yaalo nisi yalemó, Israel so whi̧né atei kisipa sinipó. ");
INSERT INTO ppo_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Téró, kale dere kaae mo hi̧ka momómo fóló kelalemó, Israel whi̧ atimaamosisitei ho̧le su betepa, ama filiyóló duraalu, ‘Diaamo Israel faketamotei noatepa ho̧le su bitu de yalepó.’ ");
INSERT INTO ppo_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ti fo yalemó, doasi fotoko̧ buóló me whi̧ tȩterótu betere whi̧né Moses tȩ daalótu duraalu, ‘Ya̧ da̧tamo fo tokó̧ló taleratere alaró tȩteróló kaae tare alatamo yó̧póló né sóró beteraleé? ");
INSERT INTO ppo_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Naao dó kale Isip whi̧ du yale kaae, ȩkélé atéró daai waleé?’ yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ai fo woseturaalu, Moses a̧ ai Isip hae kwia taaróló, Midian haepaae botokó felepó. Téró, a̧ ai bemó wale whi̧ bitu, so dokóló naale tamo deyalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Atéró ba fo whi̧ siki tamo kemeyóló betepa, whi̧kélé bitire Sainai hasi fosó felekemó ensel a̧ beterepaae ni sesaapemó si mi sokóló ai dolomó sókó walepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Atétere ala kolóló, Moses a̧ noa ala dutérópóló kisipa teketu betalepó. Atéró, mo ti diriyóló kelaairaalu, kale ni sesaape ere felekepaae taae felemó, ai si mi dolomótei, Talené a̧paae i fo yalepó. ");
INSERT INTO ppo_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ȩta, dia̧né ayarape Abraham, Aisak, Jekop atima tȩteróló kaae tare Kótópó’ yalepó. Ti fo depa, ai fo dere tiki kelaai yaletei, diri furu fu