﻿USE sofia;
DROP TABLE IF EXISTS sofia.poy_vpl;
CREATE TABLE poy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES poy_vpl WRITE;
INSERT INTO poy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kristu kaweriti mwiwuka gwa Dawudi na mwiwuka gwa Aburahamu. Ayi ndo walanga ya ukowu wakuwi, ");
INSERT INTO poy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aburahamu kamwiwuliti Isaka na Isaka kamwiwuliti Yakobu na Yakobu kamwiwuliti Yuda na walongu wakuwi, ");
INSERT INTO poy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda kamwiwuliti Peresi na Zera mawu gwawu kaweriti Tamari na Peresi kamwiwuliti Hesironi na Hesironi kamwiwuliti Rami, ");
INSERT INTO poy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rami kamwiwuliti Aminadabu na Aminadabu kamwiwuliti Nashoni na Nashoni kamwiwuliti Salumoni ");
INSERT INTO poy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","na Salumoni kamwiwuliti Boazi mawu gwakuwi kaweriti Rahabu, Boazi na Rutu waweriti walera wa Obedi na Obedi kamwiwuliti Yese. ");
INSERT INTO poy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Na Yese kamwiwuliti Mfalumi Dawudi na Dawudi kamwiwuliti Selemani mawu gwakuwi kaweriti mdala gwa Uriya, ");
INSERT INTO poy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Selemani kamwiwuliti Rehobowamu na Rehobowamu kamwiwuliti Abiya na Abiya kamwiwuliti Asa. ");
INSERT INTO poy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa kamwiwuliti Yehoshafati na Yehoshafati kamwiwuliti Uziya ");
INSERT INTO poy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","na Uziya kamwiwuliti Yosamu na Yosamu kamwiwuliti Ahazi na Ahazi kamwiwuliti Hezekiya. ");
INSERT INTO poy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiya kamwiwuliti Manasi na Manasi kamwiwuliti Amoni na Amoni kamwiwuliti Yosiya ");
INSERT INTO poy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","na Yosiya kamwiwuliti Yekoniya na walongu wakuwi. Ashi shiweriti shipindi Wayawudi pawawajegiti kugenda muluhamiru Babiloni. ");
INSERT INTO poy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pa Wayawudi kuwatola kugenda muluhamiru Babiloni na Yekoniya kamwiwuliti Sheatiyeli na Sheatiyeli kamwiwuliti Zerubabeli, ");
INSERT INTO poy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabeli kamwiwuliti Abiyudi na Abiyudi kamwiwuliti Eliyakimu na Eliyakimu kamwiwuliti Azori. ");
INSERT INTO poy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azori kamwiwuliti Sadoki na Sadoki kamwiwuliti Akimu na Akimu kamwiwuliti Eliwudi. ");
INSERT INTO poy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliwudi kamwiwuliti Eleyazari na Eliyazari kamwiwuliti Matati na Matati kamwiwuliti Yakobu. ");
INSERT INTO poy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobu kamwiwuliti Yosefu, mpalu gwa Mariya mawu gwakuwi Yesu yawamshema Kristu. ");
INSERT INTO poy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Su kuweriti na nyiwuku lilongu na msheshi kwanjira Aburahamu mpaka Dawudi na nyiwuku lilongu na msheshi kwanjira Dawudi mpaka Wayawudi pawawalopoliti kugenda Babiloni na nyiwuku lilongu na msheshi kwanjira pawawatoliti lopola mpaka shipindi sha Kristu. ");
INSERT INTO poy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Hangu ndo Yesu Kristu ntambu yakiwukiti, Mariya mawu gwakuwi Yesu kaweriti kahetitwi na Yosefu. Kumbiti pamberi pa kulikala pamuhera gambira mpalu na mdala, kawonikaniti kana yinda kwa uwezu wa Rohu Mnanagala. ");
INSERT INTO poy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosefu mpalu gwakuwi kaweriti kamfiriziya Mlungu, kafiriti ndiri kumlanguziya kwa wantu kuwera kana vidoda, Hangu kafiriti kumleka kwa bada. ");
INSERT INTO poy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pakaweriti kankali kankulihola hangu, ntumintumi gwa kumpindi gwa Mtuwa kamulawira mukulota na kumgambira, “Yosefu mwana gwa Dawudi, nagutira kumtola Mariya kaweri mdala gwaku. Mana kana yinda kwa uwezu wa Rohu Mnanagala. ");
INSERT INTO poy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Hakamwiwuli mwana mpalu, nagwenga hagumshemi Yesu, toziya yomberi ndo hakawalopoziyi wantu kulawa muvidoda vyawu.” ");
INSERT INTO poy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Vinu, vyoseri avi vilawira su viweri nakaka visoweru vyakatakuliti Mtuwa kupitira mbuyi gwa Mlungu, ");
INSERT INTO poy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mwali hakaweri na yinda, hakamwiwuli mwana mpalu na womberi hawamshemi litawu lyakuwi Imanuweri.” Mana yakuwi, “Mlungu kapamuhera na twenga”. ");
INSERT INTO poy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Su, Yosefu pakimkiti mumpota katenditi gambira vyakamgambiriti ulii ntumintumi gwa kumpindi gwa Mtuwa, kamtola mdala gwakuwi ukaya. ");
INSERT INTO poy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kumbiti Yosefu waliwoniti ndiri na Mariya mpaka pakamwiwuliti mwana mpalu. Yosefu kamupananiti mwana litawu Yesu. ");
INSERT INTO poy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu kiwukiti mlushi lwa Betirehemu, muliboma lya Yudeya, shipindi Herodi pakaweriti mfalumi. Kamkamu hera pakiwukiti kala, wantu wana malifa ga ntondu wiziti kulawa kwagulawa mshenji kwa kutali wasokiti Yerusalemu, ");
INSERT INTO poy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","wakosiyiti, “Kakoshi mwana, Mfalumi gwa Wayawudi yakiwukiti? Tuyiwona ntondu yakuwi kulawa kwagulawa mshenji, na twiza kumguwira yomberi.” ");
INSERT INTO poy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mfalumi Herodi pakapikaniriti aga, kalisheriti, yomberi pamuhera na woseri yawalikala Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Su kawashemiti watambika wakulu woseri pamuhera na wafunda wa Malagaliru na kuwakosiya, “Kristu Mlopoziya hakiwuki koshi?” ");
INSERT INTO poy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Womberi wamwankula, “Hakiwuki mlushi lwa Betirehemu, muliboma lya Yudeya. Hangu ndo ntambu yawalembiti wambuyi wa Mlungu, ");
INSERT INTO poy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Gwee Betirehemu isi ya Yuda, Gwenga gwa mdidini ndiri mulushi lumanikana lwa Yudeya, Toziya kwa gwenga hakalawili mlongoziya njira, Yakawalongoziya wantu wangu Israeli.’ ” ");
INSERT INTO poy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Su Herodi kawashemiti mubada wahenga yawalawiti kwagulawa mshenji, kawakosiyiti shipindi sheni ntondu payiwalawiriti. ");
INSERT INTO poy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Shakapanu kawagambiriti wagendi Betirehemu pakalonga, “Mgendi mwakaloli weri visoweru vya mwana ayu, pamvimana kala munjegeli visoweru su naneni hang'endi kumguwira.” ");
INSERT INTO poy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pawampikaniriti kala mfalumi, wamana ntondu walii wagenditi. Su ntondu ilii yawayiwoniti kwagulawa mshenji iwalonguleliti hata igenda kugoloka pahala palii pakaweriti mwana. ");
INSERT INTO poy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pawayiwoniti ndondi ilii wanemeleriti nentu. ");
INSERT INTO poy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Su, wingiriti mnumba, wamwoniti mwana ulii pamuhera na Mariya mawu gwakuwi, wasuntama pasi na wamguwira. Shakapanu wavugula na kumupa mafupu gawu ga zahabu na ubani na manemane. ");
INSERT INTO poy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mlungu kawabeliziiyti mumpota nawamwuyira Herodi, su wawuyiti kuisi kwawu kwa njira yamonga. ");
INSERT INTO poy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pawawukiti kala wahenga walii, ntumintumi gwa kumpindi gwa Mtuwa Mlungu kamlawiriti Yosefu mukulota, kamgambiriti, “Gwimuki! Gumtoli mwana pamuhera na mawu gwakuwi, mtugili Misri. Mulikali kulii mpaka panukugambira, toziya Herodi kafira kumlaga mwana ayu.” ");
INSERT INTO poy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Su, Yosefu kimukiti, kamtola mwana pamuhera na mawu gwakuwi, kawukiti pashiru kugenda Misri. ");
INSERT INTO poy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kalikaliti kulii mpaka pakahowiti Herodi. Shitwatila ashi shitendikiti su shisoweru shakatakuliti Mtuwa kwa njira ya mbuyi gwa Mlungu shitendeki, “Numshemiti mwana gwangu kulawa Misri.” ");
INSERT INTO poy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Shakapanu Herodi pakavimaniti wahenga walii yawalawiti kwagulawa mshenji wamzyanga, kakalariti nentu. Kalagaliriti wanonu woseri wapalu mulushi lwa Betirehemu na mumpeku mwakuwi yawawera na umuli wa mivinja miwili na pasi pawu walagwi. Katenditi hangu kulawirana na shilii shakamaniti kulawa kwa wahenga walii wamana ntondu. ");
INSERT INTO poy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Hangu ndo ntambu ya vitimiyiti visoweru vya umbuyi wa Mlungu kwa njira ya mbuyi gwa Mlungu Yeremiya, ");
INSERT INTO poy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Liziwu lipikanika aku Rama, Shiwembu na kudaya kuvuwa. Raheri kankuwalilira wana wakuwi, Na kafira ndiri kunyamala, Toziya woseri wahowa.” ");
INSERT INTO poy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodi pakahowiti kala, ntumintumi gwa kumpindi gwa Mtuwa Mlungu kamlawiriti Yosefu mundotu kulii Misri, ");
INSERT INTO poy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","kamgambira, “Gwimuki! Gumtoli mwana pamuhera na mawu gwakuwi muwuyi muisi ya Israeli toziya woseri yawafiriti kumlaga mwana, wahowa kala.” ");
INSERT INTO poy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Su Yosefu kimuka, kamtola mwana pamuhera na mawu gwa mwana na wawuya Israeli. ");
INSERT INTO poy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kumbiti Yosefu pakapikaniriti handa Arikerawu, mwana gwa Herodi kaweriti mfalumi gwa Yudeya pahala pakakolitimlima Herodi tati gwakuwi, katiliti kugenda kulii. Nayomberi, pawambereziyiti mundotu, su kagenditi wega zya Galilaya ");
INSERT INTO poy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","na kalikaliti mlushi lwawalushema Nazareti. Hangu ndo ntambu yavitimiyiti visoweru vyakalongiti mbuyi gwa Mlungu, “Hawamshemi Mnazareti.” ");
INSERT INTO poy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Majuwa galii Yohani Mbatiza kalawiliti, kanjiti kubwera mushiwala sha Yudeya, ");
INSERT INTO poy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mleki vidoda vyamtenda, toziya Ufalumi wa kumpindi wapakwegera!” ");
INSERT INTO poy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohani ayu ndo ulii mweni Isaya mbuyi gwa Mlungu kamtakuliti pakalongiti, “Liziwu lya muntu lipikanika kushiwala, ‘Mumtandiri kala Mtuwa njira yakuwi, Mumnyosheri njira zyakuwi!’ ” ");
INSERT INTO poy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohani kavaliti nguwu yawasoniti kwa mibahira ya ngamiya na lugoyi lwa lukuli mushunu mwakuwi na shiboga shakuwi shiweriti wanjombi na lwashi lwa kuntundu. ");
INSERT INTO poy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Su wantu kulawa Yerusalemu na kulawa wega zoseri zya Kuyudeya na mbwega zoseri za mump'eku mwa kulushemba lya Yoridani. ");
INSERT INTO poy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Walonga vidoda vyawu na yomberi kawabatiziti mulushemba lwa Yoridani. ");
INSERT INTO poy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kumbiti pakawawoniti Mafalisayu wavuwa na Masadukayu wankumwizira su wabatizwi, kawagambiriti, “Mwenga wana wa njoka! Muntu gaa yakawagambireni muyitili maya ya Mlungu yayiza? ");
INSERT INTO poy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mlanguziyi kwa matendu handa mleka vidoda. ");
INSERT INTO poy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Namulihola na kulitakulila, ‘Tati gwetu ndo Aburahamu!’ Nukugambirani nakamu, Mlungu kaweza kugatenda mabuwi aga gaweri wana wa Aburahamu! ");
INSERT INTO poy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Su vinu liwagu litulwa kala kudumula mishigira ya mitera, na kila mtera gwagulera ndiri mabwajubwaju gaherepa hagudumulwi na kugwasila mumotu. ");
INSERT INTO poy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Neni nukuwabatiza kwa mashi kulanguziya kuwera mleka vidoda vyamtenditi. Kumbiti yakiza kumbeli kwangu kawera na makakala kuliku neni, neni nfaa ndiri ata kupapa vilwatu vyakuwi. Yomberi hakakubatizani kwa Rohu Mnanagala na kwa motu. ");
INSERT INTO poy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yomberi muliwoku lyakuwi kana luselu lwa kupepetera, hakayijojiniri nganu na kuitula muluhanja lwakuwi, kumbiti hakatoli miwawi na kuipambira pamotu gwagutenda ndiri tiya.” ");
INSERT INTO poy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Shipindi shilii Yesu kiziti kulawa Galilaya kasokiti palushemba lwa Yoridani, kamgenderiti Yohani su kambatizi. ");
INSERT INTO poy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kumbiti Yohani kajeriti kumbelera pakalonga, “Yani gwenga gwankwiza kwa neni? Neni ndo nfiruwa kubatizwa na gwenga.” ");
INSERT INTO poy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Su Yesu kamwankuliti, “Guleki hera iweri ntambu ira ayi vinu, hangu ndo ntambu iherepa kugatenda goseri gakafira Mlungu.” Palii Yohani kajimiriti. ");
INSERT INTO poy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kamkamu hera Yesu pawambatiziti kala, kalawiti mumashi, su kumpindi kwa Mlungu kuvuguka na kamwoniti Rohu gwa Mlungu pakiza pasi gambira ng'unda na kumkangira mulibega. ");
INSERT INTO poy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Liziwu kulawa kumpindi kwa Mlungu lilongiti, “Ayu ndo Mwana gwangu yanumfira nentu, nherepeziwa nayomberi.” ");
INSERT INTO poy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Shakapanu Rohu Mnanagala kamlonguziyiti Yesu kushiwala su kajerwi na Shetani. ");
INSERT INTO poy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kaliyiti ndiri kwa malongu msheshi pashiru na paliwala, shakapanu Yesu kaweriti na njala. ");
INSERT INTO poy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Su Shetani kamwiziriti, kamgambira, “Handa gwenga nakaka gwa Mwana gwa Mlungu, gugagalambuziyi mabuwi aga gaweri mabumunda.” ");
INSERT INTO poy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu kamwankuliti, “Malembu galonga, ‘Muntu hapeni kalikali kwa kuliya shiboga hera, kumbiti kwa kila shisoweru shakatakula Mlungu.’ ” ");
INSERT INTO poy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Shakapanu Shetani kamtoliti mpaka Yerusalemu, Lushi Lunanagala na kamtuliti pashinara sha Numba nkulu ya Mlungu, ");
INSERT INTO poy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","kamgambiriti, “Handa gwenga nakaka gwa Mwana gwa Mlungu, gulyasi pasi, toziya malembu galonga, ‘Mlungu hakawagambiri wantumintumi wa kumpindi wakuwi kuusu gwenga, Hawakutoli mumawoku mwawu, Nagulikwala mumabuwi’ ” ");
INSERT INTO poy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu kamgambiriti, “Kumbiti Malembu galonga viraa, ‘Nagumjera Mtuwa, Mlungu gwaku.’ ” ");
INSERT INTO poy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Shakapanu Shetani kamtoliti mpaka pampindi nentu palugongu na kamlanguziyiti falumi zoseri zya pasipanu na ulunda wakuwi. ");
INSERT INTO poy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kamgambiriti, “Hanukupi gwenga goseri aga, handa pagusuntama pasi na kunguwira neni.” ");
INSERT INTO poy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Palii Yesu kamgambiriti, “Gugendi zyaku Shetani! Malembu galonga, ‘Hagumguwiri Mtuwa Mlungu gwaku na kumtendera gweka yakuwi!’ ” ");
INSERT INTO poy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Shakapanu, Shetani kamleka Yesu na wantumintumi wa kumpindi wa Mlungu wiziti kumtanga. ");
INSERT INTO poy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu pakapikaniriti handa Yohani wamtula mushibetubetu, kagenditi Kugalilaya. ");
INSERT INTO poy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kawukiti Nazareti, kagenditi Kafarinaumu, lushi lwaluweliti mump'eku mwa bahali ya genisareti, mumbaka mwa Zebuluni na Nafutari kalikala aku. ");
INSERT INTO poy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hangu ndo ntambu yashitimiyiti shisoweru sha Mlungu shakatakuliti kwa njira ya Isaya mbuyi gwa Mlungu, ");
INSERT INTO poy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Isi ya Zebuluni na isi ya Nafutari, Kuyigendera bahali, kumwambu kwa lushemba Yoridani, Galilaya, isi ya wantu Wayawudi ndiri! ");
INSERT INTO poy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wantu yawakaliti muntiti Wawona kulangala kukulu. Na woseri yawalikaliti muisi ya ntiti na shivinyiru sha kuhowa Kulangala Kuwalangalira.” ");
INSERT INTO poy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kwanjira shipindi shilii Yesu kanjiti kubwera pakalonga, “Mleki vidoda, toziya Ufalumi wa kumpindi wapakwegera!” ");
INSERT INTO poy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu pakaweriti kankugendagenda kumbeku kulitanda lya Galilaya, kawawoniti walongu wawili yawaweriti walowa wa wasomba, Simoni yawamshema Peteru na mlongu gwakuwi Andereya, waweriti wankulowa wasomba mulitanda kwa wavu. ");
INSERT INTO poy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu kawagambiriti, “Munfati, naneni hanuwatendi mwenga muweri walowa wa wantu.” ");
INSERT INTO poy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kamukamu hera wazilekiti nyavu zyawu, wamfatiti. ");
INSERT INTO poy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pakagenditi kulongolu kidogu, kawawoniti walongu wamonga wawili, Yakobu na Yohani, wana wa Zebedayu. Waweriti wa mumtumbwi pamuhera na tati gwawu Zebedayu wankuzinyawa nyavu zawu. Yesu kawashemiti, ");
INSERT INTO poy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","palaa palii waguleka mtumbwi pamuhera na tati gwawu na wamfatiti. ");
INSERT INTO poy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu kagenditi Mugalilaya yoseri, kafunditi mnumba za Mlungu na kabweriti Shisoweru Shiwagira sha Ufalumi, na Kaponiziyiti wantu yawawera na malweli ga ntambu zoseri. ");
INSERT INTO poy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Visoweru kuusu Yesu vyeniyiti muisi yoseri ya Siriya, su wantu woseri yawawera na malweli na yawalwala malweli ga ntambu zoseri na ndabiku, wantu yawawera na washamshera na wantu yawawera na visirika na wantu yawaweriti wahushu, wawajegiti kwa Yesu na kawaponiziyiti woseri. ");
INSERT INTO poy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Lipinga likulu lya wantu limfatiti kulawa Galilaya na lushi lilongu na Yerusalemu na Yudeya na kumwambu kwa lushemba Yoridani wamfatiti. ");
INSERT INTO poy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu pakagawoniti mapinga ga wantu, kakweniti kulugongu, kalivagiti pasi. Wafundwa wakuwi walivagiti pawamzyengeta, ");
INSERT INTO poy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","na Yomberi kanjiti kuwafunda. ");
INSERT INTO poy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mbaka ya woseri yawawera wahushu wa shirohu, Toziya Ufalumi wa mpindi ndo wawu! ");
INSERT INTO poy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mbaka kwa woseri yawawera na hinginiku, Toziya Mlungu hakawazyangizyangi! ");
INSERT INTO poy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mbaka kwa woseri yawawera wapoli, Toziya hawayihali isi. ");
INSERT INTO poy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mbaka kwa woseri yawawera na njala na yimiluwa ya kutenda gakafira Mlungu, Mlungu hakawayukutiziyi! ");
INSERT INTO poy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mbaka kwa woseri yawawera na lusungu kwa wamonga, Mlungu hakawawoneri lusungu womberi! ");
INSERT INTO poy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mbaka kwa woseri yawamfira Mlungu kwa myoyu yawu yoseri, Womberi hawamwoni Mlungu! ");
INSERT INTO poy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mbaka kwa woseri yawajega ponga, Mlungu hakawashemi wana wakuwi! ");
INSERT INTO poy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Mbaka kwa woseri yawatabika toziya yakutenda gakafira Mlungu, Ufalumi wa kumpindi ndo gwawu! ");
INSERT INTO poy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mbaka mwenga wantu pawawigilanga na kuwazulumu na kuwatendera madoda ga ntambu zoseri toziya mwenga munjimila neni. ");
INSERT INTO poy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mwenga mnemeli na kusekelera toziya mafupu genu ndo makulu kumpindi kwa Mlungu. Hangu ndo ntambu yawalikaliti wambuyi wa makashu wa Mlungu pamberi pa mwenga. ");
INSERT INTO poy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mwenga mulifana gambira munu gwa pasipanu. Kumbiti munu pagwasa unoga wakuwi, kwahera njira yingi yakugutenda gunogi kayi. Hapeni gufayi, su hawagwasi kunja na wantu hawagutimbangi. ");
INSERT INTO poy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mwenga ndo langala ya pasipanu! Lushi lwa walunyawiti mulugongu hapeni lulififi. ");
INSERT INTO poy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","“Kwahera wantu yawawasha shikoloboyi na kushigubikira na shiwiga, badala yakuwi hakashituli pampindi pa shintambi, su kulangala kwakuwi kulangali kwa kila muntu mnumba. ");
INSERT INTO poy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ntambu ira ayi, langala ya mwenga ilangali mpaka kulongolu kwa wantu, su wagaloli matendu genu gaherepa, wamkwisi Tati gwenu yakawera kumpindi. ");
INSERT INTO poy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Namulihola handa niza kuwusiya Lilagaliru lya Musa na mafundu ga wambuyi wa Mlungu. Niza ndiri kugawusiya Malagaliru, kumbiti kutenda mafundu gawu gatendeki. ");
INSERT INTO poy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nukugambirani nakaka, kumpindi na pasipanu pazipelera, kumbiti hapeni ata shisoweru shididini ama seemu ndidini yavilembitwi Mumalagaliru yiwusiwi, su mpaka mafundu goseri gatendeki. ");
INSERT INTO poy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Su yoseri yakamegi ata lilagaliru limu lididini na kuwafunda wamonga watendi viraa, ayu hakaweri mdidini muufalumi wa kumpindi kwa Mlungu. Kumbiti ulii yakabatira malagaliru na kuwafunda wamonga kutenda viraa, muntu ayu hakaweri mkulu muufalumi wa kumpindi kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Toziya nukugambirani, handa kumfiriziya Mlungu kwamwenga pakakanka ndiri ulii wa Mafalisayu na wafunda wa Malagaliru, hapeni mwingiri nakamu muufalumi wa kumpindi kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mpikaniriti ntambu ya wantu wagona wawagambiriti, ‘Nagulaga! Na yoseri yakalaga hawamtozi.’ ");
INSERT INTO poy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kumbiti vinu neni nukugambirani, yoseri yakawera na maya kwa mlongu gwakuwi hawamtozi, yakamzarawu mlongu gwakuwi hawamjegi mumahakama. Na yakamshema mlongu gwakuwi, ‘Mzigizigi’ hakaweri muhatari ya kwingira mumotu gwa Jehanamu. ");
INSERT INTO poy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Su pagulaviya mafupu gaku pashitalawanda sha kutambikira na gulihola gwana ungondu na mlongu gwaku, ");
INSERT INTO poy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","guleki mafupu gaku pashitalawanda sha kutambikira, guwuyi huti gwakatendi ponga na mlongu gwaku, su gwizi na gulaviyi mafupu gaku kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Gupatani na mstaki gwaku kanongola pamuwera mwankali munjira kugenda kumahakama. Pagutenda ndiri hangu, mstaki gwaku hakakujegi kwa mtoza, nayomberi hakakujegi kwa wanjagila wakutatili mushibetubetu. ");
INSERT INTO poy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nakaka nukugambira, hapeni gulawi mulii mpaka gulipi ligwala lya kumalalira. ");
INSERT INTO poy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mpikanira handa wantu wawagambiriti, ‘Nagutenda uhumba!’ ");
INSERT INTO poy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Su vinu neni nukugambirani, yoseri yakamlola mdala kwa kufira kutenda nayu undiyandiya, muntu ayu katenda kala uhumba mumoyu mwakuwi. ");
INSERT INTO poy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Su, lisu lyaku lya kumliwu palitenda gutendi vidoda, gulikolopoli na kuliyasa kutali! Mbaka nentu kwasa shiwungu shimu sha nshimba yaku, kuliku nshimba yaku yoseri wayasi mumotu gwa Jehanamu. ");
INSERT INTO poy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Handa liwoku lyaku lya kumliwu litenda gutendi vidoda, gulidumuli na kulyasa kutali! Mbaka nentu gwenga kwasa shiwungu shimu munshimba yaku, kuliku nshimba yaku yoseri kwingira mumotu gwa Jehanamu. ");
INSERT INTO poy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Itakulitwi kala viraa, ‘Yakamleka mdala gwakuwi ifiruwa kampanani malembu ga kumleka.’ ");
INSERT INTO poy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kumbiti neni nukugambirani, yakamupanana mdala gwakuwi malembu ga kumleka, tembera ndiri kwa shitwatira, kamtenda kaweri mndiyandiya, na muntu pakamyuga mdala yawampananiti malembu ga kumleka, katenda uhumba.” ");
INSERT INTO poy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kayi mpikanira handa wantu wagona wawagambiriti, ‘Naguleka kulirapa kwaku, kumbiti gutendi ntambu yagulirapa kwa Mtuwa.’ ");
INSERT INTO poy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kumbiti neni nukugambirani, nagulirapira kwa ntambu yoseri ilii. Nagulirapira kwa kumpindi, toziya ndo shibanta sha ufalumi sha Mlungu, ");
INSERT INTO poy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ama mupasipanu, mana ndo shiti shakuwi sha kutulila magulu, ama kwa Yerusalemu toziya ndo lushi lwa Mfalumi mkulu. ");
INSERT INTO poy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nagulirapira ata kwa mtuwi gwaku, toziya hapeni guwezi kutenda ata vilii yimu iweri neru ama ntiti. ");
INSERT INTO poy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pagutakula ‘Yina’ su iweri ‘Yina’, pagutakula ‘Ndala’ su iweri ‘Ndala’. Shoseri shilii shagutakula kunja na ashi shilawa kwa ulii Shetani. ");
INSERT INTO poy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mpikaniriti ntambu yawatakulaga, ‘Lisu kwa lisu na linu kwa linu.’ ");
INSERT INTO poy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kumbiti neni nukugambirani, namumwuzilira muntu mdoda. Muntu pakakukoma lisaya lya kumliwu gumleki kakukomi viraa na lya kumshigi. ");
INSERT INTO poy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Muntu pakakujegera kumahakama kafira kalitoli lishati lyaku, gumlekeri viraa na likoti lyaku. ");
INSERT INTO poy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Na muntu pakakulazimisha kupapa shisanka shakuwi kilumita yimu, gushipapi kilumita mbili. ");
INSERT INTO poy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Muntu yakakuluwa gumpanani, nagumpanana shisogu muntu yakafira kukuwanda shintu. ");
INSERT INTO poy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mpikanira ntambu yawatakuliti, ‘Guwafiri waganja waku na guwakalaliri wang'ondu waku.’ ");
INSERT INTO poy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kumbiti neni nukugambirani, muwafiri wang'ondu wenu na muwaluwili kwa Mlungu walii yawakuzulumani, ");
INSERT INTO poy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","su hamuweri wana wa Tati gwenu kakumpindi. Yomberi kawawalira mshenji wantu wadoda na wantu waheri na kawatowera viraa wantu woseri yawamfiriziya Mlungu na wantu yawamfiriziya ndiri Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hashi, Mlungu hakakupanani mafupu ga ntambu gaa pamuwafira hera walii yawawafira mwenga? Ata watola kodi watenda viraa! ");
INSERT INTO poy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Handa pamuwalamusiya hera walongu wenu, hashi, mtenda shitwatira sha hera hangu ndiri? Ata wantu yawamumana ndiri Mlungu watenda viraa! ");
INSERT INTO poy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Muweri waheri ntambu yakawera muheri Tati gwenu kakumpindi! ");
INSERT INTO poy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mulikali weri namwiza kutenda matendu genu gagamfiriziya Mlungu kulongolu kwa wantu su mfira wakuloleni. Handa pamtenda hangu, Tati gwenu kakumpindi hapeni kawapanani mafupu. ");
INSERT INTO poy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Su, pagumpanana vintu muhushu nagulibwera, nagutenda gambira wafyangu ntambu yawatenda mnumba za Mlungu na munjira wantenda hangu su wantu wawakwisi. Nukugambirani nakaka, wantu awa wapata kala mafupu gawu goseri. ");
INSERT INTO poy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kumbiti gwenga pagumpanana vintu muhushu, gutendi ntambu ayi ata ganja gwaku nakavimana shagutenda. ");
INSERT INTO poy_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Shilii shagutenditi hashiweri muubada. Tati gwaku yakawona muubada, hakakupi lifupu. ");
INSERT INTO poy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Pamluwa Mlungu namtenda gambira wafyangu! Womberi wafira kugoloka na kumluwa Mlungu pakati pa numba za Mlungu na pakati pa mbwega za njira su wantu wawaloli. Nukugambirani nakaka, womberi wapata kala mafupu gawu goseri. ");
INSERT INTO poy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kumbiti gwenga pagumluwa Mlungu, gwingiri mushumba shaku, gutati mlyangu, shakapanu gumluwi Tati gwaku yakawoneka ndiri. Na Tati gwaku yakawona vintu vya muubada, hakakupanani lifupu. ");
INSERT INTO poy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Pamumluwa Mlungu, nambotanga gambira wantu yawamumana ndiri Mlungu. Womberi walihola kuwera milungu yawu hayiwapikaniri toziya ya visoweru vyawu vivuwa. ");
INSERT INTO poy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Namuwera gambira womberi. Tati gwenu kavimana kala galii gamfira pamberi pa kumluwa. ");
INSERT INTO poy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Su, hangu ndo ntambu yamfiruwa kumluwa Mlungu, ‘Tati gwetu gwa kumpindi, Litawu lyaku likwiswi. ");
INSERT INTO poy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ufalumi waku wizi, Shagufira shitendeki pasipanu gambira kumpindi. ");
INSERT INTO poy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gutupanani leru shiboga shetu sha kila lishaka. ");
INSERT INTO poy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gutulekiziyi vidoda vya twenga, ntambu yatuwalekeziyiti yawatutendiriti vidoda. ");
INSERT INTO poy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nagutwingiziya mukujerwa, Kumbiti gutulopoziyi kulawa kwa Mkondola ulii’. ");
INSERT INTO poy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Toziya pamuwalekeziya wantu vidoda vyawu, Tati gwenu gwa kumpindi hakawalekiziyani mwenga. ");
INSERT INTO poy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kumbiti pamuwalekeziya ndiri wantu vidoda vyawu, Tati gwenu hapeni kawalekiziyi mwenga vidoda vyenu. ");
INSERT INTO poy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pamleka kuliya, namhinginika kusheni ntambu yawatenda wafyangu. Womberi wahinginika kusheni kwawu, su kila muntu kamloli handa woya kuliya. Nuwagambirani nakaka, womberi wapata kala mafupu gawu. ");
INSERT INTO poy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kumbiti gwenga pagoya kuliya, guliswagi mtuwi gwaku lipaki na gunawi sheni shaku, ");
INSERT INTO poy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Su, muntu yoseri nakavimana handa gwoya kuliya, Su gumanikani hera Tati gwaku yakawonekana ndiri. Na Tati gwaku yakawona shagutenda muubada, hakakupanani lifupu. ");
INSERT INTO poy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Namlitulira luhanja pasipanu, wameyi na kutu vihalibisiya na vimpegu wabomolanga na kwiwa. ");
INSERT INTO poy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mlituliri luhanja lwenu kumpindi, kweni wamehi na kutu hapeni waluharibisii na vimpegu hapeni wabomolangi na kwiwa. ");
INSERT INTO poy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Toziya palii paluwera luhanja lwaku, ndo haguweri moyu gwaku. ");
INSERT INTO poy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Lisu ndo limuliku lya nshimba. Handa lisu lyaku ndo likomu, nshimba yaku yoseri hayiweri mugulangala. ");
INSERT INTO poy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Handa lisu lyaku palilwala, nshimba yaku yoseri hayiweri muntiti. Su, gulangala waguwera mngati mwaku ndo ntiti, su ayi ndo ntiti ya kulyogisiya nentu! ");
INSERT INTO poy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kwahera muntu yakaweza kuwatendera watuwa wawili, toziya hakamkalaliri yumu na kumfira yumonga, ama hakamjimiri yumu na kumbeza yumonga. Hapeni mumtenderi Mlungu na mpiya. ");
INSERT INTO poy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ndo mana nuwagambirani, namtira kuusu shiboga na shilandwa vyamfira su mulikali, ama hamvali shishi. Hashi, makaliru ndo shiboga hera ama nentu? Na nshimba hashi handa nentu ndiri ya nguwu? ");
INSERT INTO poy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Muwaloli wampongu wa muntundu, wayala ndiri mbeyu na wabena ndiri, wala wahera luwanja loseri. Ata hangu, Tati gwenu gwa kumpindi kawaliyiziya! Hashi, mwenga mwamana ndiri kuliku wampongu awa? ");
INSERT INTO poy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ndo gaa muwamu mwenu yakawera na lyoga kaweza kwongera shipindi sha kulikala pasipanu? ");
INSERT INTO poy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ntambu gaa mulihola kuusu nguwu? Mloli uluwa wa muntundu ntambu yawukula, utenda ndiri lihengu pota na kupota. ");
INSERT INTO poy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kumbiti nuwagambirani, ata Mfalumi Selemani mweni na ulunda wakuwi woseri wamvalisiya ndiri nguwu ziherepa gambira uluwa awu. ");
INSERT INTO poy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Payiwera, Mlungu kaluvalusiya luhamba lwa mlushi hangu lweni leru lwa palaa na shirawu lwaswa mumotu. Hashi, hakawatenderi mwenga nentu? Mwenga wantu mwana moyu mdidini! ");
INSERT INTO poy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Su, namwera na lyoga, ‘Shiboga shangu hashilawi koshi? Ama hatulandi shishi? Ama hatuvali shishi?’ ");
INSERT INTO poy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vyoseri avi, wantu yawamumana ndiri Mlungu wavisakula. Tati gwenu gwa kumpindi kavimana kuwera mfira vintu vyoseri avi. ");
INSERT INTO poy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Su, mtendiwuti Ufalumi wa Mlungu na galii gakafira Mlungu na aga goseri hakakupanani nyongeru. ");
INSERT INTO poy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Su, namwana lyoga kuusu shirawu, shirawu hailiholi yeni. Magaziwu ga lishaka limu gankuwatosha kwa lishaka ali. ");
INSERT INTO poy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Namuwalunda wamonga, su namwiza na mwenga kulundwa na Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mlungu hakawatozi mwenga ntambu yamuwatoza wamonga, na shipimu shiraa shilii shamuwapimira wamonga, Mlungu hakakupimirani mwenga. ");
INSERT INTO poy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Iwera hashi gushiwona shibandu mlisu mwa mlongu gwaku na palaa panu guwona ndiri shipingiri shashiwera mlisu lyaku? ");
INSERT INTO poy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ama guweza hashi kumgambira mlongu gwaku, ‘Mlongu, guleki nukuwusiyi shibandu mlisu mwaku,’ na gumweni gwenga gwanashi shipingiri mlisu mwaku? ");
INSERT INTO poy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Gwamfyangu gwenga! Guwusii wuti shipingiri shashiwera mlisu mwaku, shakapanu haguwezi kushiwona weri na kushiwusiya shibandu shashiweriti mulisu lya mlongu gwaku. ");
INSERT INTO poy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Namwapanani wang'ang'a vintu vinanagala, hawizi kuwagalambukira na kuwakwalambula. Namwawasangira wamtumbi lulu zyenu hawizi kuzitimbanga. ");
INSERT INTO poy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mluwi na mwenga hampati, msakuli na mwenga hamwoni na mtendi hodi, namwenga hamvugulirwi. ");
INSERT INTO poy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Toziya, yoseri yakaluwa hakapati na yoseri yakasakula hakawoni na mlyangu guvugulwa kwa kila muntu yakatenda hodi. ");
INSERT INTO poy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hashi, kwana muntu yoseri mwana pakamluwa tati gwakuwi libumunda, hakampanani libuwi? ");
INSERT INTO poy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ama pakamluwa somba, hakampanani njoka? ");
INSERT INTO poy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Handa mwenga yamuwera wadoda, muvimana kuwapanana vintu viherepa wana wenu. Nakaka Tati gwenu gwa kumpindi hakatendi nentu, hakawapanani viheri kwa walii yawamluwa! ");
INSERT INTO poy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Muwatenderi wantu ntambu yamfira kutenderwa, aga ndo mafundu ga Malagaliru ga Musa na mafundu ga wambuyi wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mwingiri kwa kupitira mlyangu mbabanika, toziya mlyangu gwagulonguziya muwuharabisiya ndo mupana na njira yailonguziya kulaa aku ndo yalaisi na kwana wantu wavuwa yawaigendera njira ayi. ");
INSERT INTO poy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kumbiti mlyangu gwa ukomu ndo mbabanika na njira ya kugendera aku ndo ikamala na kwana wantu wadidini yawayiwona njira ayi. ");
INSERT INTO poy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mlikali weri na wambuyi wa mpayu, womberi wiza kwa mwenga pawawoneka gambira kondolu kwa kunja, kumbiti mngati nakaka walifana na wang'ang'a wakalipa wa muntundu. ");
INSERT INTO poy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Hamuwamani womberi ntambu yawatenda. Mbigiri hapeni ileri mapera na miyembi hapeni ileri zyabibu. ");
INSERT INTO poy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Su, mtera guherepa gulera mabwajubwaju maherepa na mtera gudoda gulera mabwajubwaju gadoda. ");
INSERT INTO poy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mtera guherepa hapeni guleri mabwajubwaju gadoda, wala mtera gudoda hapeni guleri mabwajubwaju maherepa. ");
INSERT INTO poy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na mtera gwoseri yagulera ndiri mabwajubwaju maherepa hawagudumuli na kugupambira pamotu. ");
INSERT INTO poy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Su hamuwamani wambuyi wa mpayu, ntambu yawatenda.” ");
INSERT INTO poy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kila muntu ndiri yakanshema ‘Mtuwa, Mtuwa,’ hakingiri Muufalumi wa kumbindi, kumbiti woseri hera yawatenda ntambu yakafira Tati gwangu gwa kumpindi. ");
INSERT INTO poy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lishaka lya kutozwa palisoka, wantu wavuwa hawang'ambiri, ‘Mtuwa, Mtuwa! Kwa litawu lyaku tubweriti ujumbi wa Mlungu, kwa litawu lyaku tuwusiyiti washamshera wavuwa na kutenda mauzauza gavuwa!’ ");
INSERT INTO poy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Shakapanu hanuwagambiri womberi, ‘Nuwamana ndiri mwenga. Muwuki kwaneni, mwenga ndo wantu wamtenda vidoda!’ ");
INSERT INTO poy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Su, kila muntu yakapikanira visoweru vyangu na kuvitenda, kalifana na muntu kana luhala yakanyawa numba yakuwi pampindi pa litalawu. ");
INSERT INTO poy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Viraa itowa, nshemba zimema ng'enang'ena na liyega livuma kwa makakala liikoma numba ilii. Kumbiti iguwa ndiri toziya inyawitwi pampindi pa litalawu. ");
INSERT INTO poy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Kumbiti muntu yoseri yakapikanira visoweru vyangu avi pota na kuvijimira kalifana na muntu yakanyawa numba yakuwi pamuhanga. ");
INSERT INTO poy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Vula itowa, nshemba zimema ng'enang'ena, lyega livuma kwa makakala na liikoma numba ilii na iguwa. Na kuguwa kwakuwi kuweriti kukulu!” ");
INSERT INTO poy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu pakamaliriti kutakula vitwatira avi, lipinga likulu lya wantu walikangashiti ntambu yakafunditi. ");
INSERT INTO poy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kaweriti ndiri gambira Mfunda gwa Malagaliru, kumbiti kafunditi kwa uwezu. ");
INSERT INTO poy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu pakaseleriti kulawa kuligongu, lipinga likulu lya wantu limfatiti. ");
INSERT INTO poy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Su, kiziti muntu yumu kana ungumbula, kamsuntamira Yesu na kutakula, “Mtuwa, pagufira, guweza kumpunga neni!” ");
INSERT INTO poy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu kanyosha liwoku lyakuwi na kamshinkula na kumgambira, “Nfira! Gupungwi.” Palaa palii muntu ulii kawera mkomu. ");
INSERT INTO poy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Shakapanu Yesu kamgambira yomberi, “Gupikaniri! Nagumgambira muntu yoseri, kumbiti gugendi gwakalilanguziyi kwa mtambika gwa numba ya Mlungu, gulaviyi tambiku ntambu yakalagiliriti Musa su kila muntu kavimani handa gupona.” ");
INSERT INTO poy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu pakaweriti kankwingira lushi lwa Kafarinaumu, afisa gwa Rumi kaliwoniti na yomberi na kaluwa utanga pakalonga, ");
INSERT INTO poy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Mtuwa, ntumini gwangu kagonja kalwala, ulweri wa kuleweleka na kalwala nentu.” ");
INSERT INTO poy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu kamgambira, “Hanizi kumponiziya.” ");
INSERT INTO poy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ofisa ulii kamwankula, “Ndala Mtuwa, gufiruwa ndiri gwingiri mnumba mwangu. Kumbiti gutakuli hera shisoweru na ntumini gwangu hakaponi. ");
INSERT INTO poy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Toziya ata neni namuntu gwa pasi pa uwezu wa wamonga, nanawu wanjagila yanuwalagalira kutenda. Numulagalira yumu, ‘Gugenda!’ Na yomberi kagenda na panumlagalira yumonga, ‘Gwizi!’ Na yomberi kizaga na numulagalira ntumintumi gwangu, ‘Gutendi ashi!’ Na yomberi katendaga.” ");
INSERT INTO poy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu pakapikaniriti aga, kalikangashiti na kawagambira wantu wawamfatiti, “Nakaka nuwagambirani, numwoniti ndiri muntu yoseri mu Israeli yakawera na njimiru gambira muntu ayu. ");
INSERT INTO poy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nukugambirani handa wantu wavua hawizi kulawa kwagulawa mushenji na kwaguzyeta mushenji na hawalivagi pamuwera na Aburahamu na Isaka na Yakobu pamsambu Muufalumi wa kumpindi. ");
INSERT INTO poy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kumbiti walii yawafiruwitwi kuwera Muufalumi hawawasi muntiti, aku hawalili na kugayagaya menu.” ");
INSERT INTO poy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Shakapanu Yesu kamgambira ofisa ulii, “Gugendi ukaya na ntambu yagujimira haitendeki kwaku.” Na ntumini gwa afisa ulii kaponiti shipindi shilaa shilii. ");
INSERT INTO poy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu kafikiti ukaya kwa Peteru, kamwona mawu mganafu gwa Peteru kagonja mshitanda, kapyupa nentu. ");
INSERT INTO poy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Su, Yesu kamshinkula liwoku lyakuwi na kupyupa kumleka, kagoloka na kanjiti kumtendera. ");
INSERT INTO poy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Payiweriti pamihi, wamjegeriti wantu wavuwa yawaweriti wabegiziwa na washamshera. Yesu kawawinga washamshera kwa kulonga shisoweru na kawaponiziya woseri yawaweriti wankulwala. ");
INSERT INTO poy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Katenditi hangu su galii gakatakuliti Isaya mbuyi gwa Mlungu gaweri nakaka, “Yomberi kawutola utepeku wetu, Kagatola malweri getu.” ");
INSERT INTO poy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu pakawoniti shipinga sha wantu shimzyengeta, kawagambiriti wafundwa wakuwi waloki kumwambu kulitanda. ");
INSERT INTO poy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mfunda gwa Malagaliru kamgendera, kamgambira, “Mfunda, neni nakala kugenda na gwenga koseri kwagugenda.” ");
INSERT INTO poy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu kamwankula, “Vibweta wana mpanga na wampongu wawera na vitukulu, kumbiti Mwana gwa Muntu kahera pahala pa kugonja na kwoyera.” ");
INSERT INTO poy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Muntu yumonga yakaweriti mfundwa kamgambira, “Mtuwa, gundeki uti, ng'endi nukamsiri tati gwangu.” ");
INSERT INTO poy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu kamwankula, “Gunfati, guwaleki yawahowiti shirohu wawasiri yawahowiti shirohu wawu.” ");
INSERT INTO poy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu kakweniti mumtumbwi na wafundwa wakuwi wagenditi pamuhera nayomberi. ");
INSERT INTO poy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Pala palii lihega lyana likakala lilawira mulitanda na makupala ganja kugubikira mtumbwi. Yesu mweni kaweriti kankugonja mpota. ");
INSERT INTO poy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wafundwa wamgendera na wamwimusiya pawatakula, “Mtuwa, gutulopoziyi twankuhowa!” ");
INSERT INTO poy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu kawagambira, “Iwera hashi mwana lyoga? Hee mwawantu mwenga mwana moyu gwamini ndiri!” Su, kagoloka na kalikalapira lyega na makupala ga litanda ganyamala na kuweriti na kunyamalira kukulu. ");
INSERT INTO poy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kila muntu kalikangasha. Womberi walonga “Ata lyega na makupala ga mashi gamjimira!” ");
INSERT INTO poy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu pakasokiti lushi lwa Gadara, kumwambu kulitanda, kaliwoniti na wantu wawili yawalawiti mumapumba ga mpanga. Wantu awa waweriti na washamshera na waweriti wankutilwa na wantu na kwahera muntu yakaweza kugenda munjira ilii. ");
INSERT INTO poy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Su womberi wabotanga, “Hashi, Gufira shishi kwa twenga, gwenga Mwana gwa Mlungu? Hashi, gwiza kutubeziya pamberi pa shipindi shetu?” ");
INSERT INTO poy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pakwegera na pahala palii, kuweriti na lipinga likulu lya wamtumbi wankulolelwa. ");
INSERT INTO poy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Su, washamshera wamluwa Yesu, “Handa pagutulaviya, su gutujimiliri twingiri wamtumbi walii.” ");
INSERT INTO poy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu kawagambira, “Mgendi!” Su wawalawa wantu awa na wawingira wamtumbi. Lipinga lyoseri lya wamtumbi liseleriti paluseleru lukalipa na lilidiba mumashi. ");
INSERT INTO poy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Walolera wa wamtumbi watugiti na wagenditi mlushi, kulii watakuliti vitwatira vyoseri na ntambu yavirawiriti kwa wantu yawaweriti na washamshera. ");
INSERT INTO poy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Su, wantu woseri walawiti mlushi lulii na wagenditi kuliwona na Yesu na pawamwoniti Yesu, waluwa kawuki muisi yawu. ");
INSERT INTO poy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu kakweniti mumtumbwi na kalokiti litanda na kuwuya mlushi lwakuwi. ");
INSERT INTO poy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wantu wamu wamjegiti muntu yakalewelekiti nshimba, wamgonjeka mumkeka. Yesu pakawoniti njimiru yawu, kamgambira muntu yakalewelekiti, “Naguwera na lyoga mwana gwangu! Gulegiziwa vidoda vyagutenditi.” ");
INSERT INTO poy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wafunda wamu wa Malagaliru wanja kulitakulira weni, “Muntu ayu kankumwigilanga Mlungu!” ");
INSERT INTO poy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu kagamaniti maholu gawu, su kawagambira, “Iwera hashi mwankulihola vitwatira vidoda? ");
INSERT INTO poy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Hashi, shizotopa ng'anji shii, ‘Kutakula vidoda vyagutenditi vilekiziwa,’ ama kutakula, ‘Gugoloki na gugendigendi’? ");
INSERT INTO poy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Hanuwalanguziyi kuwera Mwana gwa Muntu kana uwezu pasipanu wa kuwalekeziya wantu vidoda vyawatenda.” Su kamgambira muntu yakalewelekiti, “Gugoloki, gutoli mkeka gwaku na gugendi ukaya kwaku.” ");
INSERT INTO poy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Muntu yakalewelekiti kagoloka na kagenda ukaya kwakuwi. ");
INSERT INTO poy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lipinga lya wantu pawawoniti vitwatira vyavilawiliti, walikangashiti na wamkwisiti Mlungu yakawayupiti wantu uwezu wa ntambu ayi. ");
INSERT INTO poy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu kawukiti pahala paliya, na pakaweriti kankugendagenda, kamwoniti mtola kodi yawamshema Matayu, kalivaga palihengu lyakuwi. Yesu kamgambira, “Gunfati.” Matayu kagoloka na kamfata. ");
INSERT INTO poy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu pakaweriti ukaya kwa Matayu kankuliya shiboga, watola kodi wavuwa na watenda vidoda wiziti kuliya shiboga pamuhera na Yesu na wafundwa wakuwi. ");
INSERT INTO poy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafalisayu wamu pawawoniti aga, wawakosiya wafundwa wakuwi, “Iwera hashi mfunda gwenu kankuliya shiboga pamuhera na watola kodi na yawatenda vidoda?” ");
INSERT INTO poy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu kawapikaniriti na kawankula, “Wantu wakomu wamfira ndiri mganga, kumbiti walweli hera ndo wamfira mganga. ");
INSERT INTO poy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mlungu kalonga, Mgendi mwakalifundi Lilembu ali linanagala lyana mana gaa, ‘Neni ntakula nfira lusungu, nfira ndiri tambiku.’ Niza ndiri kuwashema wantu yawalihola wankumfiriziya Mlungu, kumbiti yawatenda vidoda.” ");
INSERT INTO poy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Shakapanu wantumini wa Yohani Mbatiza wamgenderiti Yesu, wamkosiya, “Iwera hashi, twenga pamuhera na Mafalisayu tuleka kuliya, kumbiti wafundwa waku waleka ndiri kuliya shiboga?” ");
INSERT INTO poy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu kawankula, “Hashi, mulihola kuwera wahenga pawawera mumsambu gwa ndowa wahinginika pawawera na mpalu gwa ndowa? Nakaka hapeni wahinginiki! Kumbiti lishaka lyankwiza pawamuwusiya mpalu gwa ndowa, ndo womberi hawaleki kuliya. ");
INSERT INTO poy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kwahera muntu yakasona shiraka sha nguwu ya syayi munguwu ngona toziya shiraka ashi hashidegi nguwu ngona na padegekiti palii hapongereki. ");
INSERT INTO poy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ama kwahera muntu yoseri yakaweza kulekera divayi ya syayi mumihaku ya lukuli lugona, pakatenda hangu mihaku igona haipantiki na divayi hayitiki. Kumbiti divayi ya syayi ilekerwa mumihaku ya lukuli ya syayi na vyoseri havitulwi weri.” ");
INSERT INTO poy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu pakaweriti kankutakula aga, afisa gwa Shiyawudi kamwiziriti, kamsuntamalira na kamgambira, “Muhinga gwangu kahowa vinuvinu, kumbiti shondi shondi, gwizi gumtuliri liwoku lyaku nayomberi hakaweri mkomu.” ");
INSERT INTO poy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu kawuka pamuhera na wafundwa wakuwi, wamfatiti afisa. ");
INSERT INTO poy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mdala yakaweriti mlweri gwa kusuma mwazi kwa mivinja lilongu na mbili, kamwiziriti Yesu kumbeli na kuyishinkula nguwu yakuwi. ");
INSERT INTO poy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kalihola mumoyu mwakuwi, “Handa panshinkula nguwu, haweri mkomu.” ");
INSERT INTO poy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Su, Yesu kagalambuka kamwona, kamgambira, “Mhinga gwangu, nagwana lyoga! Njimiru yaku ikuponiziya.” Pala palii mdala ulii kapona kusuma mwazi. ");
INSERT INTO poy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Shakapanu Yesu kingira mnumba mwa afisa ulii. Pakawawoniti wagomba luperembi lwa kudaya na wantu wavua wankudaya, ");
INSERT INTO poy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","kalonga, “Kila muntu kalawi kunja! Muhinga ayu kahowa ndiri, kumbiti kagonja hera!” Womberi wamseka Yesu. ");
INSERT INTO poy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Su, pawawawusiyiti wantu kulawa kunja, Yesu kingiriti mnumba kwa muhinga yakahowiti na kamkola liwoku lyakuwi na yomberi kagoloka. ");
INSERT INTO poy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Vitwatila avi vieniyiti pa isi yoseri ilii. ");
INSERT INTO poy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu kawukiti pahala paliya na pakaweriti kankugendagenda, wanalwisi awili wanjiti kumfata. Womberi wabotanga, “Gutuwoneri lusungu Mwana gwa Dawudi!” ");
INSERT INTO poy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu pakingiriti mnumba, wanalwisi wawili wamgendera, nayomberi kawakosiya, “Hashi, mjimira handa neni nana uwezu wa kuwaponiziya?” Womberi wamwankula, “Yina mtuwa!” ");
INSERT INTO poy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Shakapanu Yesu kagashinkula masu gawu, kalonga, “Na iweri kwa mwenga ntambu yamjimira!” ");
INSERT INTO poy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na masu gawu gawera makomu. Su Yesu kawalagalira, “Namumgambira muntu yoseri shitwatila ashi!” ");
INSERT INTO poy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kumbiti womberi wawuka na wabwera visoweru vya Yesu pa isi ilii yoseri. ");
INSERT INTO poy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wantu pawaweriti wankugenda zawu, wantu wamonga wamjegera Yesu muntu yakaweriti bubu toziya kaweriti na washamshera. ");
INSERT INTO poy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Katepu hera shamshera pawamlaviyiti, muntu ulii kanja kutakula. Wantu woseri walikangashiti nentu pawalonga, “Hatweni woni shitwatila gambira ashi mu Israeli!” ");
INSERT INTO poy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kumbiti Mafalisayu walonga, “Mkulu gwa washamshera ndo yakamupiti Yesu likakala lya kuwalaviya washamshera.” ");
INSERT INTO poy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu katyangiriti lushi zoseri na vijiji vyoseri. Kafunditi munumba za Mlungu, na kabweriti Shisoweru Shiwagira sha Ufalumi wa Mlungu, na kuwaponiziya wantu malweri ga ntambu zoseri. ");
INSERT INTO poy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Su, pakawawoniti vipinga vipinga vya wantu, moyu gwakuwi gumemiti lusungu, toziya waweriti watoka na wanalyoga gambira kondolu wahera mlolera. ");
INSERT INTO poy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Su kawagambira wafundwa wakuwi, “Mabenu gavuwa, kumbiti watenda lihengu lya kubena wavua ndiri. ");
INSERT INTO poy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Su, mumluwi yakana mabenu hakajegi watenda lihengu wabeni viboga vyakuwi.” ");
INSERT INTO poy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu kawashemiti wafundwa wakuwi lilongu na wawili, kawapanana uwezu wa kuwalaviya washamshera na kuwaponiziya wantu malweri na kila ulweri. ");
INSERT INTO poy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aga ndo matawu gawu wantumintumi lilongu na wawili. Gwa kwanja ndo Simoni yawamshemiti Peteru na mlongu gwakuwi Andereya, Yakobu na mlongu gwakuwi Yohani wana wa Zebedayu, ");
INSERT INTO poy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipu na Baritulumayu, Tomasi na Matayu yakaweriti mtola kodi, Yakobu mwana gwa Alifayu na Tadeyi, ");
INSERT INTO poy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni Mkanani na Yuda Isikariyoti, ndo mweni yakamgalambukiti Yesu. ");
INSERT INTO poy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu kawatumiti awa lilongu na wawili na kawapananiti malagaliru aga, “Namgenda kwa wantu wa isi zimonga, ama namwingira pakati pa lushi lwa Wasamariya. ");
INSERT INTO poy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kumbiti mgendi kwa wantu wa Israeli yawagamiliti gambira kondolu. ");
INSERT INTO poy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mgendi na mbweri, ‘Ufalumi wa kumpindi wapakwegera.’ ");
INSERT INTO poy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mponiziyi walweli, muwazyukisiyi yawahowiti, muwapungi woseri yawalwala ugumbula na muwawusiyi washamshera. Wawapanana hera, su mwenga mtendi pota kuluwa shibena mgongu. ");
INSERT INTO poy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Namtola zahabu, ama mpiya, ama magwala ga shaba mumihaku mwenu, ");
INSERT INTO poy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","namtola muhaku gwa kuluwira munjira, ama likoti lyamonga, ama vilwatu, ama luhonga. Toziya watendalihengu wafiruwa wapati vyawafira. ");
INSERT INTO poy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pamwingira pakati pa lushi loseri ama shijiji, msakuli amu muntu yoseri yakafira kuwashemera na mlikali pamuhera nayomberi mpaka pamwuka pahala palii. ");
INSERT INTO poy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pamwingira mnumba mtakuli, ‘Ponga iweri na mwenga.’ ");
INSERT INTO poy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Handa wenikaya wa numba ilii wawashemerani, su ponga ya kulamsiya kwa mwenga haikali, kumbiti wafira ndiri kuwashemera, kulamsiya kwenu kwa ponga hakukuwuyirani maweni. ");
INSERT INTO poy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Handa numba yoseri ama lushi loseri halulemi kuwashemera mwenga ama kuwapikinira mwenga, su muwuki pahala paliya na mupunti lidiku mumagulu mwenu. ");
INSERT INTO poy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nuwagambirani nakaka handa lishaka lya kutozwa, Mlungu hakawawoneri lusungu wantu wa Sodoma na Gomora kuliku wantu wa lushi alu!” ");
INSERT INTO poy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mpikaniri! Neni nuwalagalira mwenga gambira kondolu kugenda pakati pa wamaminyi. Muweri na luhala gambira njoka na mwawananaga gambira ng'unda. ");
INSERT INTO poy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mlikali weri, toziya wantu hawawawingani mwenga na hawawajegeni mushizyungu na hawawasyatangi ntomondu munumba za Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Toziya ya neni hamjegwi palongolu pa wakolamlima na wafalumi, mpati kuwagambira Visoweru Viwagira na kuwagambira wantu wa isi zimonga. ");
INSERT INTO poy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Su, pawawajegani mwenga pashizyungu, namuwera na lyoga handa hamtakuli shishi ama hamlongi hashi, shipindi pashisoka, hampati sha kuyowera. ");
INSERT INTO poy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Toziya visoweru vyamgenda kuyowera vya mwenga ndiri, kumbiti havizi kulawa kwa Rohu gwa Tati gwenu yakatakula kupitila mwenga. ");
INSERT INTO poy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mlongu hakamgalambuki mlongu gwakuwi kalagwi na tati hakamgalambuki mwana gwakuwi na wana hawawatenduwi walera wawu na kuwalaga. ");
INSERT INTO poy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wantu woseri hawawakalalireni mwenga toziya ya litawu lyaneni. Kumbiti ulii yakahepelera mpaka upeleru, ndo hakalopoziwi ");
INSERT INTO poy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wantu pawawapunja pakati pa lushi lumu, mtugili lushi lumonga. Nuwagambirani nakaka, hapeni mumalili lihengu lyenu mulushi zoseri za israeli pamberi pa kwiza Mwana gwa Muntu. ");
INSERT INTO poy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kwahera mfundwa yakawera mkulu kuliku mfunda gwakuwi, ama ntumintumi kuwera mkulu kuliku mtuwa gwakuwi. ");
INSERT INTO poy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Itosha kwa mfundwa kuwera gambira mfunda gwakuwi na ntumintumi kuwera gambira mtuwa gwakuwi. Payiwera mtuwa gwa kaya wamshema Belizebuli, su wenikaya hawashemwi ata matawu gadoda nentu!” ");
INSERT INTO poy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Su, namuwatira wantu. Shoseri shashigubikitwi hashigubutulwi, na shashiwera muubada, hashimaniki. ");
INSERT INTO poy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Shanuwagambirani mwenga muluwindu, mpaka mushitakuli muulangala, na shilii shampikinira muubada mfiruwa gushibwera pampindi pa shitwiku. ");
INSERT INTO poy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Namuwatira woseri yawalaga nshimba, kumbiti waweza ndiri kuilaga rohu, mbaka nentu mumtiri Mlungu yakaweza kulaga vyoseri nshimba pamuhera na rohu mumotu gwa Jehanamu. ");
INSERT INTO poy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Wampongu wawili wawawuza kwa ligwala limu, kumbiti ata yumu gwawu hapeni katuluki pasi pota na kufira Tati gwenu. ");
INSERT INTO poy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kumbiti kwa mwenga, ata viri zya mumituwi yenu zoseri ziwalangwa kala. ");
INSERT INTO poy_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Su namtira, mwenga mwana mana nentu kuliku wampongu wavua!” ");
INSERT INTO poy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Wantu woseri yawanjimira paweru handa waneni, hantendi viraa avi kulongolu kwa Tati ka kumpindi. ");
INSERT INTO poy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kumbiti yoseri yakanema neni palongolu pa wantu, naneni hanumlemi kulongolu kwa Tati gwangu gwa kumpindi. ");
INSERT INTO poy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Namulihola kuwera niza kujega ponga pasipanu. Ndala, niza ndiri kujega ponga, kumbiti upanga. ");
INSERT INTO poy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Niziti kuwatenda wana wawagalambuki watati wawu, wahinga wawagalambuki wamawu wawu, wanahonga wawagalambuki wamawu nahonga wawu, ");
INSERT INTO poy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","na wangondu wa muntu ndo wantu wa kaya yaku mweni. ");
INSERT INTO poy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Walii wawamfira tati gwawu ama mawu gwawu kuliku neni, hapeni waweri wafundwa waneni, walii yawawafira wantemba wawu ama wahinga wawu kuliku neni hapeni waweri wafundwa wangu. ");
INSERT INTO poy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Muntu yakatola ndiri lupingika lwakuwi na kunfata neni, hapeni kaweri mfundwa gwangu. ");
INSERT INTO poy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Woseri yawagabatilira makaliru gawu, hakawahowiziyi, kumbiti woseri yawagahoziya makaliru gawu toziya yaneni, hawagalopoziyi. ");
INSERT INTO poy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Yoseri yakawashemerani, kashemera neni na yakanshemera neni, kamshemera ulii yakamtumiti. ");
INSERT INTO poy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yakamshemera mbuyi gwa Mlungu toziya ndo mbuyi gwa Mlungu, hakanki lifupu lya mbuyi gwa Mlungu. Na yakamshemera muntu muheri toziya ndo muntu muheri, hakanki lifupu lya muntu muheri. ");
INSERT INTO poy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nuwagambirani nakaka, yoseri yakamupa yumu gwawu gwa wadidika awa yawanfata neni shikombi sha mashi gazizimira toziya ndo mfundwa gwa neni, nakaka hakapati lifupu lyakuwi.” ");
INSERT INTO poy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu pakamalaliti kuwalagalira wafundwa lilongu na wawili, kawukiti pahala paliya na kagenditi kufunda na kubwera lushi zya pakwegera palii. ");
INSERT INTO poy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohani Mbatiza pakapikaniriti vitwatira vya Kristu vyakatenda, yomberi kawatumiti wafundwa wakuwi kwa Yesu. ");
INSERT INTO poy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Womberi wamkosiya Yesu, “Hashi, gutugambiri gwenga gwa yumu yakatakulitwi na Yohani, ama tumuheperi gwingi?” ");
INSERT INTO poy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu kawankula, “Mgendi mwakamgambiri Yohani vitwatira vyampikinira na kuviwona, ");
INSERT INTO poy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","wanalwisi wawona na wavibyeketu wagendagenda, woseri yawalwala ungumbula wapungwa na wanamajogu wapikinira na wahowiti wankuzyukisiwa na Visoweru Viwagira vibwelwa kwa wahushu. ");
INSERT INTO poy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mbaka kwa wantu woseri yawawera ndiri na lyoga na neni!” ");
INSERT INTO poy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wafundwa wa Yohani pawawukiti, Yesu kanjiti kuwagambira lipinga lya wantu, “Hashi, pamgenditi kumlola Yohani kushiwala, mgenditi kulola shishi? Visoweru vya Yohani, mgenditi kulola shishi? Hashi mgenditi kulola lyega lyankutikisiya luhamba? ");
INSERT INTO poy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Su, mgenditi kulola shishi? Mgenditi kumlola muntu yakavaliti nguwu iherepa? Wantu yawavala nguwu ziherepa walikala munumba zya wafalumi! ");
INSERT INTO poy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mung'ambiri, mgenditi kulola shishi? Mgenditi kumlola mbuyi gwa Mlungu? Yina nakaka, kumbiti mwona vitwatira vivuwa kuliku mbuyi gwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yohani ndo yumu yawamlembiti Mumalembu mananagala, ‘Mlungu kalonga, hanumtumi mjumbi gwangu hakakulonguleri na kukunyawira njira.’ ");
INSERT INTO poy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nukugambirani nakaka handa Yohani Mbatiza ndo mkulu kuliku muntu yoseri yakalikala. Kumbiti muntu yakawera mdidini Muufalumi wa kumpindi ndo mkulu kuliku Yohani. ");
INSERT INTO poy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kwanjira shipindi Yohani Mbatiza pakabweriti ujumbi wakuwi mpaka leru, ufalumi wa kumpindi wantu wankwingira kwa makakala na wantu wana makakala ndo hawawingiri. ");
INSERT INTO poy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mpaka shipindi sha Yohani, wambuyi woseri wa Mlungu na Malagaliru ga Musa galembwa kuusu Ufalumi. ");
INSERT INTO poy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Handa pamuweza kujimira ujumbi wawu, Yohani ndo Eliya mekizi. ");
INSERT INTO poy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yakana makutu su kapikaniri! ");
INSERT INTO poy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Su, nuwafananiziyi na shishi wantu wa mashaka aga? Walifana gambira wana yawalikala pahala pa soku. Wawera pawaligambiziyana na shipinga shimonga. ");
INSERT INTO poy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Twawagombirani msambu gwa ndowa, kumbiti mviniti ndiri! Twimba lwimbu lwa kudaya, kumbiti mlira ndiri. ");
INSERT INTO poy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohani pakiziti, koya kuliya na kalanda ndiri divayi na kila muntu kalonga, ‘Yomberi kana shamshera!’ ");
INSERT INTO poy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana gwa Muntu pakiziti, kaliya na kalanditi divayi na kila muntu katakuliti, ‘Mumloli muntu ayu! Kana lwaliya na mlowera na ndo ganja gwa watola kodi na yawawera na vidoda!’ Luhala lwa Mlungu lwankulanguziya kuwera iherepa kulawirana na gakatendaga.” ");
INSERT INTO poy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Shakapanu Yesu kanjiti kuzilawumu lushi zakatenditi mauzauza guvuwa, wantu wakuwi wafira ndiri kugalambuka kulawa muvidoda vyawatenda. ");
INSERT INTO poy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Shondi Kolazini! Shondi Betisayida! Handa mauzauza aga yagatendikiti kwaku megatendikiti Tiru na Sidoni, wantu wakuwi mewavali kala malobota na kulipakaziya livu, kulilanguziya kuwera waleka vidoda vyawatenda. ");
INSERT INTO poy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nukugambirani nakaka kuwera mulishaka lya Mlungu lya kutozwa, hakawawoneri lusungu nentu wantu wa lushi lwa Tiru na Sidoni kuliku mwenga. ");
INSERT INTO poy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nagwenga Kafarinaumu! Hashi, gufira kulikweniziya gamweni kumpindi kwa Mlungu? Hawakusulusiyi mpaka mulirindi lyalihera upeleru! Handa mauzauza yagatendikiti kwa gwenga, megatendeki ku Sodoma, lushi alu meluweri mpaka leru! ");
INSERT INTO poy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nukugambirani kuwera mulishaka lya kutozwa Mlungu hakawawoneri lusungu nentu wantu wa Sodoma kuliku mwenga!” ");
INSERT INTO poy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Shipindi shilii Yesu katakuliti, “Tati, Mtuwa gwa kumpindi na pasi panu! Mayagashii toziya guwalanguziya wadidika vitwatira vyaguwafifiti yawawera na luhala na yawawera na mahala. ");
INSERT INTO poy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yina Tati, hangu ndo ntambu yagufiriti vilawiri. ");
INSERT INTO poy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tati gwangu kanupa vintu vyoseri. Kwahera yakammana Mwana ira Tati na kwahera yakammana Tati ira Mwana na goseri galii gakafira kumgambira Mwana, su kamgambira. ");
INSERT INTO poy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mwizi kwaneni woseri mwenga yamtokiti kupapa visanka vizotopa na neni hanuwatendi moyeri. ");
INSERT INTO poy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mjimili vilii vyanuwapanani mwenga na mulifundi kulawa kwaneni, toziya neni namupoli na mnanagala mu rohu na mwenga hamwoyeri. ");
INSERT INTO poy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Toziya shilii shanuwalagaliriti ndo shiherepa kwa mwenga na shanuwapanani mpapi ndo shizotopa ndiri.” ");
INSERT INTO poy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Shipindi shilii Yesu kaweriti kankugendagenda kupitira mumalambu ga nganu lishaka lya Kwoyera. Wafundwa wakuwi waweriti na njala, su wanjiti kubenanga mikunguwi ya nganu na waliya mpunji. ");
INSERT INTO poy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafalisayu pawawoniti hangu, wamgambira Yesu, “Guloli, wafundwa waku watenda shitwatira ashi shashibeliritwi kushitenda mulishaka lya Kwoyera.” ");
INSERT INTO poy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu kawankula, “Hashi, mwenibetuli ntambu yakatenditi Dawudi pamuhera na wayaguwi pawaweriti na njala? ");
INSERT INTO poy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yomberi kingiriti Mnumba ya Mlungu pamuhera na wayaguwi waliya mabumunda gawamtambikiriti Mlungu, ata hangu ileweleritwi mu Lilagaliru kwa womberi kuliya mabumunda galii, ira watambika wa Numba ya Mlungu gweka yawu wafiruwa kugaliya. ");
INSERT INTO poy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ama mwenibetuli Mumalagaliru ga Musa kuwera kila lishaka lya kwoyera, wakulu wa Mnumba nkulu ya Mlungu watenda ndiri malagaliru ga kwoyera, kumbiti walihola ndiri kuwera watenda kosa? ");
INSERT INTO poy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nukugambirani mwenga kuwera panu kwana mkulu kuliku Numba nkulu ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Malembu mananagala galembwa, ‘Nfira lusungu na nfira ndiri tambiku.’ Handa muvimana nakaka kuwera mana ya visoweru avi, mekawatozi ndiri wantu yawahera likosa, ");
INSERT INTO poy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","su Mwana gwa Muntu ndo Mtuwa gwa lishaka lya kwoyera” ");
INSERT INTO poy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu kawukiti palii na kagenditi kwingira munumba ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kuweriti na muntu yakaweriti na liwoku lyalilewelekiti. Su wantu wamkosiyiti Yesu, “Hashi, iherepa kumponiziya muntu mulishaka lya Kwoyera?” Womberi wamkosiyiti hangu su wapati kumsitaki. ");
INSERT INTO poy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu kawankula, “Handa kwana yumu gwenu kana kondolu na kaguwiriti mulirindi mulishaka lya Kwoyera? Hashi, hakamkoli ndiri na kumlaviya?” ");
INSERT INTO poy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na muntu kana mana nentu kuliku kondolu! Su Lilagaliru lyetu litulekeziya kutenda gaherepa mulishaka lya kwoyera. ");
INSERT INTO poy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Shakapanu Yesu kamgambira muntu ulii yakalewelekiti liwoku, “Gutalipisiyi liwoku lyaku.” Yomberi katalipisiya liwoku na liwera likomu gambira liwoku limonga. ");
INSERT INTO poy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Su Mafalisayu walawa kunja na waligambiziyana ntambu ya kumlaga Yesu. ");
INSERT INTO poy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu pakapikaniriti shitwatira shilii, kawuka pahala paliya na lipinga likulu lya wantu limgenderiti. Kawaponiziya woseri yawaweriti walweli, ");
INSERT INTO poy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","na kawalewelera nawamgambira muntu yoseri kuusu mweni. ");
INSERT INTO poy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Katenditi aga su katendi galii gakatakuliti Isaya mbuyi gwa Mlungu gaweri ganakaka, ");
INSERT INTO poy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ayu ndo ntumini gwangu, yanumsyaguriti, Yumu yanumfira na kupitira mweni ndo nherepeziwa. Hanumjegi Rohu gwangu kwakuwi, Na hambweri kutoza kwangu kwa isi zimonga. ");
INSERT INTO poy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hapeni kaweri na ukakatala, ama kubotanga, Ama liziwu lyakuwi kupikana mu mitaa. ");
INSERT INTO poy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Hapeni kalumegi ludenki, Ama lutambi lutuma lyosi hapeni kaluzimi. Mpaka kavitendi vilii vyavimfiriziya Mlungu vitendi lihengu, ");
INSERT INTO poy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na kupitira yomberi wantu woseri hawaweri na litumbiru.” ");
INSERT INTO poy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Shakapanu wantu wamu wamjegiriti Yesu muntu yakaweriti kana lwisi viraa bubu toziya kaweriti na shamshera. Yesu kamuponiziyiti muntu ulii, su kaweziti kutakula na kuwona. ");
INSERT INTO poy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lipinga lya wantu lilikangasha ntambu yakatenditi Yesu. Womberi wakosiya, “Hashi, iwezekana ayu kuwera Mwana gwa Dawudi?” ");
INSERT INTO poy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mafalisayu pawapikaniriti aga, wawankula, “Yomberi kawawinga washamshera hera toziya mkulu gwa washamshera Belizebuli kamupiti makakala kutenda hangu.” ");
INSERT INTO poy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu kavimaniti galii gawalihola, su kawagambira, “Ufalumi woseri waupalanganikiti muvipinga vipinga na kulikomanga weni, hapeni ulikali shipindi shitali. Na lushi lwoseri ama kaya yayipalanganika muvipinga vipinga na kulikomanga yeni haiguwi. ");
INSERT INTO poy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Handa shipinga shimu pashilikomanga na shipinga shimonga muufalumi wa Shetani, toziya vipalanganika kala muvipinga na ufalumi awu hauguwi! ");
INSERT INTO poy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mwenga mlonga handa nuwawinga washamshera toziya Belizebuli kanupiti makakala ga kutenda hangu. Hashi, ndo gaa yakawapanani wafata wenu makakala ga kuwawinga washamshera? Su wafata wenu hawaweri watoza wenu! ");
INSERT INTO poy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kumbiti paiwera nankuwawinga washamshera kwa likakala lya Rohu gwa Mlungu, muvimana handa Ufalumi wa Mlungu usoka kala kwa mwenga. ");
INSERT INTO poy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kwahera muntu yakaweza kwingira mnumba ya muntu kana likakala na kumpoka ulunda wakuwi, mpaka kamtawi huti muntu yakawera na likakala, shakapanu hakawezi kumpoka ulunda wakuwi. ");
INSERT INTO poy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Yoseri yakawera pamuhera ndiri na neni, kalekanira na neni na yoseri yakantyanga ndiri kujojinira ndo nakaka kankupalasiya. ");
INSERT INTO poy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Na nuwagambirani kuwera wantu wankulekiziwa vidoda na vintu vidoda vyawatakula, kumbiti muntu yoseri yakamwigilanga Rohu Mnanagala hapeni kalekiziwi. ");
INSERT INTO poy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Muntu yoseri yakamwigilanga Mwana gwa Muntu hakalekiziwi, kumbiti muntu yoseri yakamwigilanga Rohu Mnanagala hapeni kalekiziwi mashaka goseri.” ");
INSERT INTO poy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mgutendi mtera guweri guherepa na mabwajubwaju gakuwi hagaherepi ama mgutendi mtera guweri gudoda na mabwajubwaju gakuwi hagaweri madoda toziya mtera gumanikana kulawirana na mabwajubwaju gakuwi. ");
INSERT INTO poy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwenga ndo mleru gwa njoka! Muweza hashi kutakula vitwatira viheri shipindi mwenga mwawadoda? Muntu katakula galii gamemiti mumoyu mwakuwi. ");
INSERT INTO poy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Muntu muheri kalaviya vitwatira viheri kulawa mumoyu mwakuwi, kumbiti muntu mdoda kalaviya vitwatira vidoda mumoyu mwakuwi. ");
INSERT INTO poy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Su mwana unakaka kuwera mulishaka lya kutoza kila muntu hakawankuli kila shisoweru shakatakuliti. ");
INSERT INTO poy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Visoweru vyaku havikutozi kuwera gumfiriziya Mlungu ama gwamuntu mdoda.” ");
INSERT INTO poy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wafunda wamu wa Malagaliru na Mafalisayu wamu wamgambira Yesu, “mfunda tufira gutulanguziyi mauzauza kulawa kumpindi kwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu kawankula, “Shiyiwuku shikondola na shashihera uwaminika kulongolu kwa Mlungu! Mfira mauzauza, kumbiti hapeni mpananwi liuzauza lyoseri lilii ira hampananwi liuzauza lya Yona mbuyi gwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ntambu ira ayi Yona kalikaliti mashaka matatu paliwala na pashiru mumtima gwa somba, su Mwana gwa Muntu hakalikali vira mashaka matatu paliwala na pashiru mngati pasi pa isi. ");
INSERT INTO poy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mulishaka lya kutoza, wantu wa Ninawi hawagoloki pamuhera na shiyiwuku ashi na womberi hawashitozi. Toziya wantu wa Ninawi walekiti vidoda vyawatenditi pawampikaniriti Yona pakabwera, kumbiti panu kwana shitwatila shikulu kuliku Yona. ");
INSERT INTO poy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Malikiya gwa kusika hakalawili shipindi shiyiwuku ashi pashitozwa na yomberi hakashitozi. Toziya mweni kagenditi mwanja kulawa kutali, kiziti kuvipikinira visoweru vya luhala lwa mfalumi Selemani, kumbiti panu kwana mkulu kuliku Selemani!” ");
INSERT INTO poy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Shamshera pakamlawa muntu, kagenda kuyerayera kushiwala pakasakula pahala pa kwoyera. Handa pakapata ndiri, ");
INSERT INTO poy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","hakalitakuziyi mweni, ‘Hambuyi mnumba mwangu mwandawiti.’ Su pakawuya na kwona numba yahera shintu na wayifyagira na kuherepeziwa. ");
INSERT INTO poy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Shakapanu kagenda na kuwatola washamshera wamonga saba wadoda kuliku mweni bnb na woseri wiza kumwingira muntu ayu. Su ntambu ya muntu ayu iwera idoda kuliku payiweriti kwanja. Ntambu ayi hayiwalawili wantu wa mashaka aga yawatenda vidoda.” ");
INSERT INTO poy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu pakaweriti kankali kankuyowera na wantu, mawu na walongu wakuwi wasokiti. Wagolokiti kunja na waluwa kuyowera na yomberi. ");
INSERT INTO poy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Su muntu yumu palii kamgambira Yesu, “Guloli, mawu gwaku na walongu waku wakunja wafira wayoweri na gwenga.” ");
INSERT INTO poy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu kawankula, “Hashi, mawu gwangu ndo gaa? Hashi, walongu wangu washina gaa?” ");
INSERT INTO poy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Shakapanu kawalanguziya kwa liwoku lyakuwi wafundwa wakuwi na kulonga, “Mloli! Awa ndo mawu gwangu na walongu waneni! ");
INSERT INTO poy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Muntu yoseri yakatenda vilii vyakafira Tati gwangu gwa kumpindi, ayu ndo mlongu gwangu na dada gwangu na mawu gwangu.” ");
INSERT INTO poy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lishaka liraa lilii Yesu kalawiti mnumba ilii na kugenda kumpeku kulitanda, su kalivaga kanja kufunda. ");
INSERT INTO poy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Lipinga likulu lya wantu limzingiti, su Yesu kakwena mumtumbwi na kalivaga na wantu waweriti wagolokiti pampeku pa litanda. ");
INSERT INTO poy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu katakuliti kwa mifanu kuwagambira vitwatira vivuwa. “Kuweriti na muntu yakagenditi kukweta mbeyu. ");
INSERT INTO poy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pakaweriti kankukweta mbeyu mulirambu, mbeyu zimonga zitulukiriti munjira na wampongu wiziti na waziliya. ");
INSERT INTO poy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Zimonga zitulukiti palitalawu lyana litapaka lididini. Zimera kanongola toziya litapaka ligenditi pasi ndiri. ");
INSERT INTO poy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kumbiti mshenji paguwaliti gulunguziya vimeru vyavimeriti toziya mishigira yakuwi igenditi ndiri pasi, su vimeru viyuma. ");
INSERT INTO poy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeyu zimonga zitulukiriti pa misontu, pazimera na kukula misontu izibabanika. ");
INSERT INTO poy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kumbiti mbeyu zimonga zitulukiriti mulitapaka liherepa zimera na zikula na kulera mbeyu zivuwa zya zilii zawaziyaliti, zimonga mala miya na zimonga malongu sita na zimonga malongu matatu.” ");
INSERT INTO poy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na Yesu kamalalira kwa kulonga, “Yakana makutu kapikaniri!” ");
INSERT INTO poy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Shakapanu wafundwa wamgenderiti Yesu na wamkosiya, “Iwera hashi gutakula kwa mifanu kwa wantu?” ");
INSERT INTO poy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu kawankula, “Mwenga mtelekerwa kuvimana vintu vya bada ya ufalumi wa kumpindi kumbiti womberi wavimana ndiri. ");
INSERT INTO poy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kwa muntu yoseri yakawera na shintu hawamwongeri, kumbiti muntu yakahera shintu ata shilii shididini shakawera nashi hawampoki. ");
INSERT INTO poy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Toziya ntakula nawomberi kwa mifanu ndo toziya waloli kumbiti hapeni wawoni na wapikiniri kumbiti hapeni werewi ama kuvimana. ");
INSERT INTO poy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Su gatimii galii gakatungiti Isaya mbuyi gwa Mlungu gatendeki, ‘Wantu awa hawapikiniri na kupikinira, kumbiti hapeni welewi, Womberi hawaloli na kulola, kumbiti hapeni wawoni, ");
INSERT INTO poy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Toziya mahala ga wantu awa gazizitika, Waleka kupikinira mumakutu mwawu Wagonyiziya masu gawu. Handa masu gawu megaloli, Makutu gawu megapikiniri, Mahala gawu megavimani, Na womberi wangambuyiri neni, kalonga Mlungu, Na neni meniwaponiziyi.’” ");
INSERT INTO poy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesu katakula kayi, “Mbaka mwenga toziya masu genu gawona na makutu genu gapikanira. ");
INSERT INTO poy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nuwagambirani kuwera wambuyi wavuwa wa Mlungu na wantu wavuwa waheri wafiriti nentu kuwona vilii vyamuviwona, kumbiti wasinda na kupikinira shilii shampikinira, kumbiti wasinda.” ");
INSERT INTO poy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Su mwenga mpikaniri mana ya mfanu agu gwa mkweta. ");
INSERT INTO poy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wantu woseri yawapikanira ujumbi kuusu Ufalumi kumbiti werewa ndiri, walifana gambira mbeyu zyazitulukiriti panjira. Shetani kiza na kuwusiya shilii shawashikwetiti mumoyu mwawu. ");
INSERT INTO poy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbeyu zyazitulukiriti mumabuwi ndo wantu woseri yawauwanka ujumbi kwa nemeru pawalipikanira. ");
INSERT INTO poy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kumbiti limwingira ndiri na kuwera na mshigira mngati mwakuwi na wendereya ndiri patali. Su ntabika na tabu paviza toziya ya ujumbi, womberi waleka palaa palii. ");
INSERT INTO poy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbeyu zyazitulukiriti mumitera ya misontu ndo wantu woseri yawaupikanira ujumbi, kumbiti lyoga kuusu makaliru gakuwi na zisitarehi za ulunda ubabanika ujumbi, na womberi hapeni waleri mabwajubwaju. ");
INSERT INTO poy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na mbeyu zawazikwetiti mulitapaka lyana mbotu ndo wantu woseri yawaupikanira ujumbi na kwelewa, na ujumbi ulera zivuwa za zilii yawaziyaliti, wamonga walera miya na wamonga malongu sita na wamonga malongu matatu.” ");
INSERT INTO poy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu kawagambira wantu mfanu gwingi, Ufalumi wa kumpindi ulifana ntambu ayi. Muntu yumu kakwetiti mbeyu ziherepa mulirambu lyakuwi. ");
INSERT INTO poy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pashiru pamu wantu pawagonjiti, mngondu gwakuwi kiziti na kukweta magugu pakati pa nganu na kagenda zakuwi. ");
INSERT INTO poy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Shipindi mbeyu za nganu pazimeriti na kwanja kupunda na magugu ganja kuwoneka. ");
INSERT INTO poy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ntumintumi ulii yakawera na lirambu kamgendera na kumgambira, “Mtuwa gwenga gukwetiti mbeyu ziherepa mulirambu lyaku, hashi, vinu magugu aga galawa koshi?” ");
INSERT INTO poy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yakana lirambu kawankula, “Mngondu ndo yakatenditi hangu. Wantumintumi wamkosiya, ‘Hashi, gufira tugendi twakagatupuli magugu?’ ");
INSERT INTO poy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yomberi kawankula, ‘Ndala, toziya pamjonjonira magugu hamtupuli na nganu. ");
INSERT INTO poy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mleki magugu na nganu gakuli pamuhera mpaka shipindi sha kubenanga. Shakapanu hanuwagambiri watenda lihengu watupuli kwanja magugu na kugatawa mumatita na kugalunguziya. Kumbiti nganu muijojiniri na muituli muluhanja lwangu.’ ” ");
INSERT INTO poy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu kawagambira wantu mfanu gwingi, “Ufalumi wa kumpindi ulifana hangu. Muntu yumu katoliti mbeyu ndidini nentu na kagenditi kukweta mulirambu lyakuwi. ");
INSERT INTO poy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mbeyu yeni iweriti ndidini nentu kuliku mbeyu zoseri, kumbiti payimeriti na kukula iwera mtera mkulu kuliku vyoseri vyavimeriti mulirambu mpaka wampongu wiza na kunyawa vitukulu vyawu mumitambi yakuwi.” ");
INSERT INTO poy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu kawagambira mfanu gwingi, “Ufalumi wa kumpindi ulifana hangu. Mdala yumu katoliti simika na kuhanganyiya pamuhera na vipimu vitatu vya ubumu, su ubumu woseri ututumuka.” ");
INSERT INTO poy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu kawagambiriti wantu goseri aga kwa mifanu. Kawagambira ndiri shintu shoseri pota kutakula mifanu, ");
INSERT INTO poy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","katenditi hangu su vyavitakulitwi na mbuyi gwa Mlungu vitendeki, “Hantakuli kwa mfanu panyowera na womberi, Hanuwagambiri vitwatira vyavimanika ndiri kwanjira kunyawa pasi panu.” ");
INSERT INTO poy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu pakalilekiti lipinga lya wantu, kingira mnumba na wafundwa wakuwi wamgendera na wamkosiya, “Hashi, mfanu agu gutakula shishi?” ");
INSERT INTO poy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu kawankula, “Muntu yakakwetiti mbeyu ndo Mwana gwa Muntu, ");
INSERT INTO poy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","na lirambu ndo pasipanu. Na mbeyu iherepa ndo wantu wa Ufalumi wa Mlungu. Magugu ndo wantu yawatenda vitwatira vya Shetani. ");
INSERT INTO poy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mngondu yakakwetiti magugu ndo Shetani. Na shipindi sha kubenanga ndo upeleru wa pasipanu na watenda lihengu ndo wantumintumi wa kumpindi wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Magugu ntambu yawagajojinira na kugalunguziya pamotu, ndo ntambu hayilawiri kupelera kwa pasipanu. ");
INSERT INTO poy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana gwa Muntu hakawatumi wantumintumi wa kumpindi wakuwi kulawa Muufalumi wakuwi, woseri walii yawatenda wantu watendi vidoda na wantu woseri yawatenda vitwatira vidoda, ");
INSERT INTO poy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","hawawawasili mumotu gwa Jehanamu na aku hawalili na kugaya menu. ");
INSERT INTO poy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Shapanu wantu yawamfiriziya Mlungu hawang'eleng'eti gambira mshenji Muufalumi wa Tati gwawu. Handa muwera na makutu, mpikaniri! ");
INSERT INTO poy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ufalumi wa kumpindi ulifana ntambu ayi. Muntu yumu kawoniti ulunda yaulififiti mulirambu. Su yomberi kanemeleriti nentu, kawufifiti kayi na kagenditi kuwuza vyoseri vyakawera navi na kawuyiti kuhemera lirambu lilii.” ");
INSERT INTO poy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Viraa, Ufalumi wa kumpindi ulifana hangu. Muntu yumu kaweriti kankusakula lulu iherepa, ");
INSERT INTO poy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","na pakayiwoniti lulu yimu inamana nentu nkulu, kagenditi kuwuza vyoseri vyakaweriti navi na kuhemera lulu ilii.” ");
INSERT INTO poy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Viraa Ufalumi wa kumpindi ulifana hangu. Walowa wasomba wamu watandira wavu wawu mulitanda na walowa wasomba wa ntambu zoseri. ");
INSERT INTO poy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wavu pauweriti na wasomba nduu, wawunika pampeku pa litanda na kulivaga pasi kuwasyagula wasomba, wasomba waherepa wawatula mumajamanda gawu na wasomba wadoda wawasa. ");
INSERT INTO poy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ntambu ayi hayiweri lishaka lya upeleru, shipindi ashi wantumintumi wa kumpindi wa Mlungu hawawalaviyi wantu yawatenda vidoda kulawa kwa wantu waheri ");
INSERT INTO poy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na hawawasili mumotu gwa Jehanamu, su womberi hawalili na kugayagaya menu gawu.” ");
INSERT INTO poy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu kawakosiya, “Hashi, mwerewa vitwatira avi?” Wamwankula, “Yina.” ");
INSERT INTO poy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Su yomberi kawagambira, “Kila mfunda gwa Malagaliru yakawera mfundwa Muufalumi wa kumpindi kalifana gambira muntu yakana numba yakatoliti vintu vya makashu na vya syayi muluwanja lya kutulila vintu.” ");
INSERT INTO poy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu pakamalaliti kuwagambira mifanu ayi, kawukiti pahala palii ");
INSERT INTO poy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","na kagenditi kushijiji kwakuwi. Aku kafunditi wantu mnumba ya Mlungu na woseri yawampikaniriti walikangashiti. Womberi wakosiya, “Hashi, kapatiti koshi luhala alu? Hashi kapata koshi mauzauza aga? ");
INSERT INTO poy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Hashi, ayu mwana ndiri gwa msongola vintu na mawu gwakuwi wamshema Mariya na walongu wakuwi ashina Yakobu na Yosefu na Simoni na Yuda? ");
INSERT INTO poy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na wadada wakuwi walikala ndiri panu? Hashi, kagapata koshi goseri aga?” ");
INSERT INTO poy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Su womberi wamlema Yesu. Yesu kawagambira, “Mbuyi gwa Mlungu hapeni kamjimiri mlushi mwakuwi na ukaya kwakuwi, kumbiti lushi zimonga wamjimira.” ");
INSERT INTO poy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Toziya womberi wahera moyu, su hapeni katendi mauzauza gavuwa palii. ");
INSERT INTO poy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Shipindi shilii mkulu gwa Galilaya Herodi kapikaniriti visoweru vya Yesu. ");
INSERT INTO poy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nakaka ndo Yohani Mbatiza, ayu kazyuka kulawa kwa wahowiti, “kawagambira maafisa, ayi ndo toziya kana likakala lwa kutenda mauzauza.” ");
INSERT INTO poy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodi ndo yakalagaliriti kuwera Yohani wamkamuli, wamtawi pingu na kumtula mushibetubetu. Katenditi hangu toziya ya Herodiya mdala gwa Filipi mlongu gwakuwi. ");
INSERT INTO poy_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Toziya Yohani Mbatiza kaweriti kankumgambira Herodi, “Iherepa ndiri gwenga kumyuga Herodiya!” ");
INSERT INTO poy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodi kafiriti kumlaga Yohani Mbatiza, kumbiti katiliti wantu wa Shiyawudi toziya Yohani Mbatiza womberi wamwoniti kuwera mbuyi gwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mumsambu gwa kulihola kwiwuka kwa Herodi, muhinga gwa Herodiya, kaviniti kulongolu kwa wahenga woseri. Herodi kanemeleriti nentu ");
INSERT INTO poy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","su kamgambiriti, “Nulirapi, hanukupi shoseri shagunduwa!” ");
INSERT INTO poy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mawu gwa muhinga ulii kamhimiziyiti muhinga gwakuwi kamgambiri tati gwakuwi kulonga, “Gunupi palaa panu muluseru mtuwi gwa Yohani Mbatiza!” ");
INSERT INTO poy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ata hangu mfalumi kahinginikiti, kumbiti toziya ya kulirapilira kwakuwi kulongolu kwa wahenga, kalagaliriti wamupi mtuwi muhinga ulii. ");
INSERT INTO poy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Su kalagalira Yohani kadumulwi mtuwi mushibetubetu. ");
INSERT INTO poy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mtuwi gwa Yohani wagujega muluseru na kumupa muhinga ulii, nayomberi kagujega kwa mawu gwakuwi. ");
INSERT INTO poy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wafundwa wa Yohani wiza, wayitoliti nshimba ya Yohani na kuyisira, shakapanu wagenditi kwa Yesu na kumgambira. ");
INSERT INTO poy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu pakapikaniriti shisoweru kuusu Yohani, kawukiti pahala palii mumtumbwi na kagenditi pahala pa gweka. Wantu wapikiniriti aga, wamgendera Yesu kulawa lushi zyawu na wamfata kwa magulu. ");
INSERT INTO poy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu pakasulukiti kulawa mumtumbwi na pakaliwoniti lipinga likulu lya wantu, Kawawoneriti lusungu na kawaponiziyiti woseri yawaweriti walwala. ");
INSERT INTO poy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pamihi, wafundwa wakuwi wamgendereti Yesu na walonga, “Saa zigenda kala na pahala panu pagweka. Guwalekeziyi wantu wagendi zawu naguwaleki wagendi muvijiji wakahemeri viboga.” ");
INSERT INTO poy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu kawagambira, “Hapeni wawuki, mwenga muwayupi vintu vya kuliya!” ");
INSERT INTO poy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Womberi wamwankula, “Twana mabumunda muhanu na wasomba wawili hera.” ");
INSERT INTO poy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu kalonga, “Su munjegeli panu.” ");
INSERT INTO poy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kawagambira wantu walivagi pasi mumihamba, shakapanu katola mabumunda muhanu na wasomba wawili, kalola kumpindi kwa Mlungu, kalonga mayagashii Mlungu. Kagamega mabumunda na kawapanana wafundwa wakuwi na wafundwa wawapanani wantu. ");
INSERT INTO poy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kila muntu kaliya na kwikuta. Shakapanu wafundwa wajojinira majamanda lilongu na mbili ga vyavisigaliti. ");
INSERT INTO poy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kwa wantu woseri yawaliyiti, wapalu hera waweriti elufu muhanu pota kuwawalanga wadala na wana. ");
INSERT INTO poy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pala palii Yesu kawagambira wafundwa wakuwi wakweni mumtumbwi na wamlongoleri kuloka kumwambu kulitanda, shipindi yomberi kankuwaaga wantu. ");
INSERT INTO poy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pakawaagiti kala, mweni kakweniti kulugongu kugenda kumluwa Mlungu. Payisokiti pamihi, Yesu kaweriti gweka yakuwi kulii, ");
INSERT INTO poy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","na shipindi ashi mtumbwi guweriti kala patali pa litanda, guweriti gugenda usegausega toziya lihega liweriti lyankuguyumbisiya. ");
INSERT INTO poy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Payiweriti luhunjuhunju Yesu kawagendiriti wafundwa wakuwi, pakagendagenda pampindi pamashi. ");
INSERT INTO poy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wafundwa wakuwi pawamwoniti pakagendagenda pampindi pamashi, watiliti nentu. Womberi washowangana pawalonga, “Shihoka ayu!” ");
INSERT INTO poy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pala palii Yesu kawagambira womberi, “Namtira, ndo neni!” ");
INSERT INTO poy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Shakapanu Peteru katakula, “Mtuwa, handa nakaka ndo gwenga gung'ambiri neni nizi kwa gwenga pamashi.” ");
INSERT INTO poy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu kamgambira, “Gwizi!” Su Peteru kasuluka kulawa mumtumbwi na kamgendera Yesu pakagendagenda pampindi pamashi. ");
INSERT INTO poy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kumbiti pakawoniti liyega, kaweriti na lyoga su kanjiti kudidimila mumashi. Shakapanu kalila pakalonga, “Mtuwa! Gumponiziyi.” ");
INSERT INTO poy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Palaa palii Yesu kalitalipisiya liwoku lyakuwi kamkola na kumgambira, “Ntambu yaguhera njimiru! Iwera hashi gwana lyoga?” ");
INSERT INTO poy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Woseri wakwena mumtumbwi, na liyega linyamalira. ");
INSERT INTO poy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Shakapanu wafundwa mumtumbwi wamguwira Yesu pawalonga, “Nakaka gwenga gwa Mwana gwa Mlungu!” ");
INSERT INTO poy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Waloka litanda na kusoka lushi lwa Genezareti, ");
INSERT INTO poy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","pahala wantu woseri wamumaniti Yesu. Su wawajega wantu yawalwala kulawa lushi zoseri za pakwegera na wamjegera Yesu. ");
INSERT INTO poy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wamluwa kawajimiri woseri yawalwaliti wapati kushinkula luwiniku lwa nguwu yakuwi na woseri yawashinkuliti waweriti wakomu. ");
INSERT INTO poy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Shakapanu Mafalisayu wamu na wafunda wa Malagaliru wamwiziriti Yesu kulawa Yerusalemu na wamkosiya, ");
INSERT INTO poy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Iwera hashi, wafundwa waku wagajimira ndiri mafundu gawafunditi wazewi wetu? Wagulula ndiri weri mawoku gawu pakwanja kuliya!” ");
INSERT INTO poy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu kawankula, “Iwera hashi mwenga mjimira ndiri malagaliru ga Mlungu na kufata mafundu genu? ");
INSERT INTO poy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mlungu kalonga, ‘Guwapanani ligoya tati gwaku na mawu gwaku,’ na ‘Yoseri yakamwigiranga tati gwakuwi ama mawu gwakuwi, kafiruwa kalagwi.’ ");
INSERT INTO poy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kumbiti mwenga mfunda handa muntu kana shintu sha kumupa tati gwakuwi ama mawu gwakuwi kumbiti kalonga, ‘Shintu ashi numulavilira Mlungu,’ ");
INSERT INTO poy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","su kafiruwa ndiri kumpanana ligoya tati gwakuwi ama mawu gwakuwi. Kwa ntambu ayi mwenga mushibeziya shisoweru sha Mlungu kwa kugajimira mafundu genu. ");
INSERT INTO poy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mwawafyangu mwenga! Vyakatungiti Isaya mbuyi gwa Mlungu viwera nakaka kwa mwenga! ");
INSERT INTO poy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Mlungu kalonga, wantu awa wanupa ligoya neni kwa visoweru vyawu hera, Kumbiti myoyu yawu nakaka iwera patali na neni. ");
INSERT INTO poy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kunguwira kwawu kufaa ndiri, Toziya wafunda malagaliru ga wantu gambira ndo malagaliru ga neni!’ ” ");
INSERT INTO poy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Shakapanu Yesu kalishemiti lipinga lya wantu na kawagambira, “Mpikaniri na mwerewi! ");
INSERT INTO poy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Shintu shashimwingira muntu munshimba hapeni shimtendi muntu kaweri muhumba, kumbiti shilii shashimlawiti ndo shimtenda muntu kaweri muhumba.” ");
INSERT INTO poy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Shakapanu wafundwa wakuwi wamgendera na wamgambira, “Hashi, guvimana kuwera Mafalisayu wakukalalira pawapikiniriti visoweru vyagutakula?” ");
INSERT INTO poy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu kawankula, “Kila mtera gweni Tati gwangu kakumpindi kaguyaliti ndiri, hawagutupuli. ");
INSERT INTO poy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Namtira kuusu womberi! Womberi ndo walongoziya wanalwisi na kana lwisi yumu pakamlonguziya kana lwisi muyaguwi, woseri hawapokeri mulirindi.” ");
INSERT INTO poy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peteru katakula, “Gutakuliri gagutakula kwa twenga.” ");
INSERT INTO poy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu kawagambira, “Hashi, ata mwenga mwerewa ndiri kuliku wamonga? ");
INSERT INTO poy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Shintu shoseri shashiyingira mumlomu mwa muntu, shigenda mumtima mwakuwi shakapanu shimlawa na shigenda mshowu. ");
INSERT INTO poy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kumbiti vitwatira vyavimlawa muntu mumlomu vilawa mumoyu na vitwatira avi ndo vyavimtenda muntu kaweri muhumba. ");
INSERT INTO poy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Toziya mumoyu mlawa maholu gadoda ga ulagaji na uhumba na shimbegu na upitawu wa mpayu na mayigilangu. ");
INSERT INTO poy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Vitwatila avi ndo vyavimtenda muntu kaweri muhumba. Kumbiti kuliya shiboga pota na kunaviya mawoku ntambu yamlonga, hapeni kumtendi muntu kaweri muhumba.” ");
INSERT INTO poy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu kawukiti pahala paliya na kagenditi pakwegera na lushi lwa Tiru na Sidoni. ");
INSERT INTO poy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mdala yumu yakalikariti mlushi lwa Kanaani kamwiziriti Yesu pakabotanga, “Mtuwa, Mwana gwa Dawudi, gumoneri lusungu! Muhinga gwangu kana shamshera yakamgaziya nentu.” ");
INSERT INTO poy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kumbiti Yesu kalonga ndiri shisoweru kwa yomberi. Wafundwa wakuwi wamgendera na wamgambira Yesu, “Gumgambiri mdala ayu kagendi zakuwi! Toziya kankutufatafata na kutenda umatu!” ");
INSERT INTO poy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Shakapanu Yesu kawankula, “Wantuma hera kwa wantu wa Israeli yawagamiliti gambira kondolu.” ");
INSERT INTO poy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Paliya mdala ulii kiza na kamsuntamalira palongolu pa magulu gakuwi pakalonga, “Mtuwa guntangi!” ");
INSERT INTO poy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu kamwankula, “Ifaa ndiri kutola shiboga sha wana na kuwawasila wang'ang'a.” ");
INSERT INTO poy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yomberi kamwankula, “Ayi ndo nakaka, Mtuwa kumbiti ata wang'ang'a waliyaga vyavisigaliti na kutulukira pasi kwa meza ya Mtuwa gwawu.” ");
INSERT INTO poy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Su Yesu kamwankula, “Gwenga mdala gwana njimiru nkulu! Shilii shagufira hashitendeki kwaku.” Na pala palii muhinga gwakuwi kawera mkomu. ");
INSERT INTO poy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu kawukiti palii na kagenda pampeku pa litanda lya Galilaya. Kakwena kulugongu na kalivaga pasi. ");
INSERT INTO poy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Lipinga likulu lya wantu limwizira pawamjegera wavibyeketu na wanalwisi na bubu na wantu wamonga wavuwa yawaweriti walweli, su wawatula palongolu pa magulu ga Yesu na yomberi kawaponiziya. ");
INSERT INTO poy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lipinga lya wantu lilikangashiti nentu pawawoniti bubu katakula na wavibyeketu wagendagenda na yawalewelekiti wawera wakomu na wanalwisi wawona na wamkwisiti Mlungu gwa Israeli. ");
INSERT INTO poy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu kawashema wafundwa wakuwi na kalonga, “Nuwawonera lusungu wantu awa, toziya wawera na neni mashaka matatu na vinu wahera shintu shakuliya. Nfira ndiri kuwaleka wagendi zawu pota na kuliya shiboga, nawalembuka munjira.” ");
INSERT INTO poy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wafundwa wakuwi wamkosiya, “Hashi, hatupati koshi shiboga shitosha sha kulikutuziya lipinga lya wantu awa kushiwala agawu?” ");
INSERT INTO poy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu kawakosiya, “Hashi, mwanaga mabumunda maninga?” Womberi wamwankula, “Mabumunda saba na wasomba wadidini wadikawadika.” ");
INSERT INTO poy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu kalagalira lipinga lya wantu lilivagi pasi muvipinga vipinga. ");
INSERT INTO poy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Shakapanu katola mabumunda saba galii na wasomba walii, kalonga mayagashii Mlungu, kamega mabumunda na kawapanani wafundwa wakuwi na wafundwa wakuwi wawapanani wantu. ");
INSERT INTO poy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wantu woseri waliyiti na kwikuta. Shakapanu wafundwa wajojinira vyavisigaliti wamemeziya majamanda saba. ");
INSERT INTO poy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wantu woseri yawaliyiti, wapalu gweka yawu waweriti elufu msheshi pota kuwawalanga wadala na wana. ");
INSERT INTO poy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Shakapanu Yesu kawaaga wantu, kakwena mumtumbwi na kagenda pahala kwingi wakushema Magadani. ");
INSERT INTO poy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafalisayu wamu na Masadukayu yawamgendiriti Yesu wafiriti kumuyambira, su wamgambiriti kawatenderi liuzauza kulanguziya kuwera Mlungu kapamuhera na yomberi. ");
INSERT INTO poy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kumbiti Yesu kawankula, “Mshenji paguzyeta mwenga mtakula, ‘Twankugenda kuwera na shipindi shiherepa toziya kumpindi kuwera kusheri.’ ");
INSERT INTO poy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na pamandawira putiputi mtakula, ‘Leru vula haitowi, toziya kumpindi kusheri na ntiti.’ Mwenga mushimana shipindi kwa kulola kumpindi, kumbiti muvimana ndiri kuyimana ntambu ya vipindi avi! ");
INSERT INTO poy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Shiyiwuku shikondola na shashihera uwaminika kulongolu kwa Mlungu! Mfira mauzauza, kumbiti hapeni mpananwi liuzauza lyoseri lilii ira hampananwi liuzauza lya Yona.” Su kawaleka na kagenda zakuwi. ");
INSERT INTO poy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wafundwa wakuwi pawalokiti kala kumwambu kulitanda, waliyaluwa kutola mabumunda. ");
INSERT INTO poy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu kawagambira, “Muweri masu, na mlikali weri na simika ya Mafalisayu na Masadukayu.” ");
INSERT INTO poy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wantumintumi wanjiti kulitakuziyana weni kwa weni, “Katakuliti hangu toziya tutoliti ndiri libumunda lyoseri.” ");
INSERT INTO poy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu kavimaniti shawatakula, su kawakosiya, “Mwana njimiru shiyasi gaa! Hashi, shamuyowera pakati penu kuusu kwahera libumunda lyoseri? ");
INSERT INTO poy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hashi, mpaka vinu muvimana ndiri? Hashi, mulihola ndiri panugamegiti mabumunda muhanu toziya ya wantu elufu muhanu? Hashi, mjojiriti majamanda maninga ga mabumunda yagasigaliti? ");
INSERT INTO poy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ama mabumunda saba gamuwagawiriti wantu elufu msheshi? Hashi, mjojiniriti majamanda maninga ga mabumunda yagasigariti? ");
INSERT INTO poy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Iwezekana hashi, muvimana ndiri kuwera ntakuliti ndiri kuusu mabumunda? Mulikali weri na simika ya Mafalisayu na Masadukayu!” ");
INSERT INTO poy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Shakapanu wafundwa wavimana handa kankuwagambira ndiri walikali weri na simika ya mabumunda kumbiti kulikala weri na mafundu ga Mafalisayu na Masadukayu. ");
INSERT INTO poy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu kagenditi pakwegera na lushi lwa Kaisariya Filipi, kawakosiyiti wafundwa wakuwi, “Hashi, wantu wankutakula mwana gwa muntu ndo gaa?” ");
INSERT INTO poy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Womberi wamwankula, “Wamonga watakula Yohani Mbatiza na wamonga watakula Eliya na wamonga watakula Yeremiya na wamonga walonga mbuyi gwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu kawakosiya, “Hashi, mwenga mlonga neni nagaa?” ");
INSERT INTO poy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Peteru kawankula, “Gwenga gwa Kristu, mwana gwa Mlungu yakawera mkomu.” ");
INSERT INTO poy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu kalonga, “Mbaka gwenga Simoni mwana gwa Yohani! Toziya unakaka awu kwahera muntu yakakugubutulira gwenga, kumbiti Tati gwangu gwa kumpindi ndo yakakugubutulira. ");
INSERT INTO poy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na neni nukugambira gwenga Peteru, gwenga gwa libuwi na pampindi palibuwi ali hanyawi shipinga shangu sha wantu yawanjimira neni, ata makakala ga mulirindi lyalihera upeleru hapeni gakukanki. ");
INSERT INTO poy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Hanukupi funguwu za Ufalumi wa kumpindi kwa Mlungu, kila shagutata pasipanu shitatitwi kala kumpindi kwa Mlungu na kila shaguvugula pasipanu shivugulitwi kala kumpindi kwa Mlungu”. ");
INSERT INTO poy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Shakapanu Yesu kawalagalira wafundwa wakuwi nawamgambira muntu yoseri handa yomberi ndo Kristu. ");
INSERT INTO poy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kwanjira shipindi shili Yesu kanjiti kuwagambira pota na kufifa kwa wafundwa wakuwi, “Hang'endi Yerusalemu na aku hantabiki nentu kulawa kwa wazewi na watambika wakulu na wafunda wa Malagaliru. Hawanagi kumbiti lishaka lya tatu kwanjira panhowiti, hanzyuki.” ");
INSERT INTO poy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peteru kamtola Yesu kugenda kumpeku na kanjiti kumkalipira. “Nayiwera hangu Mtuwa! Shitwatila ashi hapeni shikupati.” ");
INSERT INTO poy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu kagalambuka na kamgambira Peteru, “Guwuki kulongolu kwa neni, Shetani! Gwenga gwa shidiwiru munjira yaneni, toziya maholu gaku aga galawa ndiri kwa Mlungu kumbiti galawa mumaholu ga muntu.” ");
INSERT INTO poy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Shakapanu Yesu kawagambira wafundwa wakuwi, “Handa muntu yoseri yakafira kuwera ntumintumi gwangu, kalilemi mweni na kalutoli lupingika lwakuwi kanfati. ");
INSERT INTO poy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Toziya muntu yakafira kugalopoziya makaliru gakuwi mweni hakagahovii, kumbiti muntu yoseri yakagahoviya makaliru gakuwi toziya ya neni hakagalopoziyi. ");
INSERT INTO poy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hashi, muntu hakapati shishi pakawupata ulunda wa pasipanu poseri shakapanu pakagahoviya makaliru gakuwi? Ndala! Kwahera shintu, muntu shakaweza kulaviya su kapati ukomu. ");
INSERT INTO poy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Toziya Mwana gwa Muntu hakizi muukwisa wa Tati gwakuwi pamuhera na wantumintumi wa kumpindi wa Mlungu na hakampanani mafupu kila muntu ntambu yakatenditi. ");
INSERT INTO poy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Nakaka nukugambirani kwana wamonga mlaamu hapeni wahowi pamberi pa kumwona Mwana gwa Muntu pakiza Muufalumi wakuwi.” ");
INSERT INTO poy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pagapititi mashaka sita Yesu kamtoliti Peteru na Yakobu na Yohani mlongu gakuwi kagenda nawa gweka yawu kulugongu lutalipa. ");
INSERT INTO poy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aku pawaweriti wakumlola Yesu kagalambuka sheni, sheni shakuwi shiweriti ndaa gambira mshenji na nguwu zyakuwi ziwera neru mbuu. ");
INSERT INTO poy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Shakapanu wafundwa watatu walii wawawoniti Musa na Eliya pawayowera na Yesu. ");
INSERT INTO poy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Su Peteru kamgambira Yesu, “Mtuwa, iherepa nentu twenga twapanu, pagufira hanyawi visasa vitatu, shimu shaku na shamonga sha Musa na shamonga sha Eliya.” ");
INSERT INTO poy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pakaweriti kankali kankutakula hangu, liwundu lifufu limgubikira na liziwu lipikanika kulawa muliwundi ali palilonga, “Ayu ndo mwana gwangu yanumfira nentu nherepeziwa nayomberi, mumpikaniri.” ");
INSERT INTO poy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wafundwa pawapikaniriti aga watiliti nentu, su wasuntama makukama. ");
INSERT INTO poy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu kawagendera kawashinkula pakalonga, “Namtira, mgoloki!” ");
INSERT INTO poy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pawaloliti wawona ndiri muntu gwingi kumbiti Yesu gweka yakuwi. ");
INSERT INTO poy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pawaweriti wankusuluka kulugongu Yesu kawaberiziya nawamgambira muntu vitwatira yawaviwoniti mpaka Mwana gwa Muntu pawamzyukisiya kulawa kwa wahowiti. ");
INSERT INTO poy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Shakapanu wafundwa wakuwi wamkosiya, “Iwera hashi wafunda wa Malagaliru wankutakula eti mpaka Eliya kizi huti?” ");
INSERT INTO poy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu kawankula, “Nakaka, Eliya hakizi kunyawa vitwatira yoseri. ");
INSERT INTO poy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nukugambirani kuwera Eliya kiza kala na wantu wammana ndiri, kumbiti wamtendera vyawafiriti weni. Mwana gwa Muntu hawambeziyi ntambu ira ayi mumawoku gawu.” ");
INSERT INTO poy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Peni panu wafundwa wavimana kuwera yomberi kaweriti kankuwagambira weni kuusu Yohani Mbatiza. ");
INSERT INTO poy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pawawuyiti mulipinga lya wantu, muntu yumu kamgendera Yesu na kamsuntamalira, ");
INSERT INTO poy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na kalonga, “Mtuwa, gumwoneri lusungu mwana gwana! Yomberi kana shisirika, kayi mwana gwangu katabika nentu mala zitangala kaguwira mumotu ama mumashi. ");
INSERT INTO poy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Numjega kwa wafundwa waku, kumbiti waweza ndiri kumponiziya.” ");
INSERT INTO poy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu kawankula, “Shiyiwuku ashi shahera moyu na shipotoka! Hanulikali na mwenga mpaka ndii? Munjegeri panu mwana ayu!” ");
INSERT INTO poy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu kamkalipira shamshera ulii, na shamshera kamlawa na mwana ulii kawera mkomu palaa palii. ");
INSERT INTO poy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Shakapanu wafundwa wakuwi wamgendera Yesu pahala pagweka wamkosiya, “Iwera hashi twenga tusinda kumwusiya shamshera ulii.” ");
INSERT INTO poy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu kawankula, “Toziya mwahera njimiru, nuwagambira nakaka pamuwera na njimiru gambira mbeyu ndidini nentu, hamuwezi kulugambira lugongu alu, ‘Guwuki panu gugendi palii!’ Na lugongu alu halugendi. Haguwezi kutenda shitwatila shoseri!” ");
INSERT INTO poy_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kumbiti kwa kuluwa na kufunga mweza kuwalaviya washamshera awa, kwahera shintu shingi shiweza. ");
INSERT INTO poy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wafundwa pawaliwoniti pamuhera Galilaya, Yesu kawagambira, “Mwana gwa Muntu hawamupanani kwa wantu ");
INSERT INTO poy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","na hawamlagi, kumbiti lishaka lya tatu kwanjira kuhowa kwakuwi hakazyuki.” Wafundwa waweriti na ushiwa nentu. ");
INSERT INTO poy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu pamuhera na wafundwa wakuwi pawasokiti Kafarinaumu, watola mpiya za zaka za Numba nkulu ya Mlungu wamgenderiti Peteru na wamkosiya, “Hashi mfunda gwenu kalipa mpiya za zaka za Numba nkulu ya Mlungu?” ");
INSERT INTO poy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peteru kawankula, “Yina!” Su Peteru pakayingiriti mnumba, pamberi kanetakuli shisoweru shoseri, Yesu kamkosiya, “Simoni gwengapa guwona ashi, wafalumi wa pasipanu watola ushuru ama kodi kwa ashina gaa? Kulawa kwa wenikaya ama kwa wahenga?” ");
INSERT INTO poy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peteru kawankula, “Kulawa kwa wahenga.” Yesu kamgambira, “Iherepa!, Su wenikaya wawusika ndiri kulipa. ");
INSERT INTO poy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kumbiti wantu awa nawatuwona twenga twawadoda. Su mgendi kulitanda mwakalopoli somba. Somba gwa kwanja kumlopola, gugubuturi mlomu gwakuwi na haguwoni mpiya zazitosha kulipira zaka yangu na mwenga. Guzitoli na gulipi kodi zyetu.” ");
INSERT INTO poy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Shipindi shilii wafundwa wamgenderiti Yesu kumkosiya, “Hashi, ndo gaa hakaweri mkulu Muufalumi wa kumpindi kwa Mlungu?” ");
INSERT INTO poy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Su Yesu kamshema mwana yumu, kamgolosiya pakati pawu, ");
INSERT INTO poy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na kalonga, “Nukugambirani nakaka pamuwera ndiri gambira wana awa hapeni mwingiri nakamu Muufalumi wa kumpindi kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yakawera mkulu Muufalumi wa kumpindi kwa Mlungu ndo ulii yakalisulusiya mweni na kuwera gambira mwana ayu. ");
INSERT INTO poy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na yoseri yakamshemera mwana gambira ayu, kanshemera neni. ");
INSERT INTO poy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Yoseri yakamtenda yumu gwa wana wadidini awa katendi vidoda, iweri mbaka kwa muntu ulii kumtawalira musingu mwakuwi lwala na kumwasira mubahari. ");
INSERT INTO poy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Shondi pasipanu toziya ya vintu vyavimtenda muntu katendi vidoda! Vintu avi mpaka vilawiri, kumbiti shondi kwa ulii yakayijega kwawomberi! ");
INSERT INTO poy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Handa liwoku lyaku ama ligulu lyaku palikutenda gutendi vidoda, gulidumuli na gulyasi kutali! Iherepa nentu kwingira muukomu pota na liwoku ama ligulu kuliku kuwera na mawoku goseri na magulu goseri na wakwasili mumotu yagutiya ndiri mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Handa lisu lyaku palikutenda gutendi vidoda, guliwusiyi! Iherepa nentu muntu kwingira muukomu wa mashaka goseri paguwera na lisu limu kuliku kuwera na masu goseri na wakwasili mumotu gwa Jehanamu. ");
INSERT INTO poy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mulikali weri namumbeziya yumu gwa wadidini awa. Nukugambirani, wantumintumi wawu wa kumpindi kwa Mlungu, shipindi shoseri wapalongolu pa Tati gwangu kakumpindi. ");
INSERT INTO poy_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mwana gwa Muntu kiziti kulopoziya shilii shashiyagamiriti. ");
INSERT INTO poy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mulihola hashi muntu pakawera na wakondolu miya na yumu pakayagamira hakatendi hashashi? Hakawaleki walii lilongu tisa na tisa palugongu na kugenda kumsakula ulii yakagamiriti. ");
INSERT INTO poy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pakamwona, nukugambirani nakaka hakamnemeleri ulii kondolu yumu yakagamiriti kuliku mlilongu tisa na tisa yawagamiliti ndiri. ");
INSERT INTO poy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ntambu ira ayi Tati gwenu gwa kumpindi kafira ndiri ata yumu gwa wadidini kagamiri. ");
INSERT INTO poy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Handa mlongu gwaku pakakukoseya, gumgenderi gwakamberiziyi. Gutendi hangu pamuwera gweka yenu. Pakakupikanira hagumpati mlongu gwaku. ");
INSERT INTO poy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kumbiti pakakupikanira ndiri, gumtoli muntu yumu ama wawili pamuhera na gwenga, su muyoweri kwa wapitawu wawili ama watatu, Malembu Mananagala ntambu yagalembitwi. ");
INSERT INTO poy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na pakashipikanira ndiri ashi, gutakuli kila shintu mushipinga sha wantu yawamjimira Yesu. Upeleru pakashipikanira ndiri shipinga ashi, gumloli gambira muntu yakamumana ndiri Mlungu ama mtola kodi. ");
INSERT INTO poy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Su nukugambirani woseri, shamlewelera pasipanu shileweleritwi kala kumpindi kwa Mlungu na shamulekeziya pasipanu shilekeziwitwi kala kumpindi kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nukugambirani kayi, wawili wenu pasipanu pawajimilirana kumluwa Mlungu shoseri, Tati gwangu gwa kumpindi hakawatenderi shitwatila ashi. ");
INSERT INTO poy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Wantu wawili ama watatu pawaliwona pamuhera kumluwa Mlungu mulitawu lyaneni, hanweri pamuhera na womberi.” ");
INSERT INTO poy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Shakapanu Peteru kamgenderiti Yesu na kumkosiya, “Mtuwa, hashi mlongu gwangu pakankoseya numulekiziyi mala ninga? Hashi, mala saba?” ");
INSERT INTO poy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu kamwankula, “Ndala, mala saba ndiri kumbiti miya msheshi na lilongu tisa, ");
INSERT INTO poy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","toziya Ufalumi wa kumpindi ulifana na ntambu ayi. Kuweriti na mfalumi yumu yakafiriti kulola mawalanga ga wantumintumi wakuwi. ");
INSERT INTO poy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pakanjiti kutenda hangu, wamjegera muntu yumu yakaweriti wankumshonga mpiya elufu lilongu. ");
INSERT INTO poy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ntumintumi ulii kaweriti ndiri na mpiya zitosha zya kulipa uwanda wakuwi, su mfalumi kalagaliriti kuwera yomberi wamuwuzi gambira ntumintumi pamuhera na mdala gwakuwi na wana wakuwi na vyoseri vyakawera navi su kalipi uwanda. ");
INSERT INTO poy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ntumintumi ulii kasuntamala palongolu pa mfalumi na kamluwiti, ‘Gunheperi huti, hanukulipi kila shintu!’ ");
INSERT INTO poy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mtuwa gwa ntumintumi ulii kamwoneriti lusungu, su kamlekeziya uwanda ulii na kamleka kagendi zakuwi. ");
INSERT INTO poy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ntumintumi ulii pakawukiti, kaliwoniti na yumu gwa wantumintumi wayaguwi yakaweriti kankumshonga mpiya miya yimu. Su kamkamula yomberi na kanjiti kumkaba singu pakamgambira, ‘Gunipi shilii shagunkopiti!’ ");
INSERT INTO poy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ntumintumi myaguwi kamsuntamalira na kamluwa pakalonga, ‘Gunheperi wuti, hanukulipi uwanda waku woseri!’ ");
INSERT INTO poy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kumbiti yomberi kajimiriti ndiri, su kamtatira mushibetubetu mpaka pakalipa lideni lilii. ");
INSERT INTO poy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wantumintumi wayaguwi pawawoniti vitwatira vyavilawiliti, wahinginikiti nentu na wagenditi kumgambira Mfalumi kila shintu. ");
INSERT INTO poy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mfalumi kamshema ntumintumi ulii na kamgambira, ‘Gwenga gwa ntumintumi gufaa ndiri! Neni nukulegeziya toziya gunduwiti nukulegiziyi. ");
INSERT INTO poy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Gufiruwitwi gwenga gumwoneri lusungu ntumintumi muyagu ntambu yanukuwoniriti lusungu gwenga.’ ");
INSERT INTO poy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mfalumi kakalariti nentu, kamlaviya ntumintumi ayu wamwazibu na kumtatira mushibetubetu mpaka pakalipiti uwanda woseri.” ");
INSERT INTO poy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Na Yesu kamaliriti kwa kulonga, “Ndo Tati gwangu gwa kumpindi hakawatenderani ntambu ira ayi kila muntu pakati penu pakamlegeziya ndiri mlongu gwakuwi kulawa mumoyu mwakuwi.” ");
INSERT INTO poy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu pakamaliliti kutakula visoweru avi, kawuka Galilaya kagenda mumkowa gwa Yudeya, kumwambu kulushemba Yoridani. ");
INSERT INTO poy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wantu wavuwa wamgenderiti aku, na yomberi kawaponiziyiti walelwi. ");
INSERT INTO poy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafalisayu wamu wamwizira, wafiriti kumgomiziya pawamkosiya, “Hashi, Malagaliru getu gatulekeziya muntu kumleka mdala gwakuwi kwa likosa lyoseri?” ");
INSERT INTO poy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu kawawankula, “Hashi, hamwebetuli Mumalembu Mananagala handa Mlungu pakanjiti kumuumba muntu mpalu na mdala? ");
INSERT INTO poy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Su Mlungu kalonga, ‘Toziya ayi hakamleki mawu na tati gwakuwi, hakagendi na mdala gwakuwi, woseri awili hawaweri yumu.’ ");
INSERT INTO poy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Su womberi hawaweri ndiri awili, kumbiti hawaweri yumu. Shakalemetiziyiti Mlungu, muntu nakashitula gweka.” ");
INSERT INTO poy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kumbiti Mafalisayu wamkosiya, “Iwera hashi, Musa katupanani Lilagaliru kwa muntu kumleka mdala gwakuwi kwa kumpanani malembu ga kumleka?” ");
INSERT INTO poy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu kawankula, “Musa kalagaliriti kuwaleka wadala wenu toziya mwelewa ndiri pawawafundisha. Kumbiti iwera ndiri ntambu ayi mushipindi Mlungu pakaumbiti. ");
INSERT INTO poy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nukugambirani kuwera muntu yoseri yakamleka mdala gwakuwi kwantambu yoseri ilii kuliku kujimira kwakuwi, su katenda uhumba pakayuga mdala gwingi.” ");
INSERT INTO poy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wafundwa wakuwi wamgambira, “Paviwera vitwatira vya mpalu na mdala vya ntambu ayi, mbaka kulikala pota kuyuga.” ");
INSERT INTO poy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu kawankula, “Vitwatila avi viwawusu ndiri woseri yawaweza kuvijimira, kumbiti hera kwa woseri Mlungu yakawapanani wavimani. ");
INSERT INTO poy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Toziya kwana vintu vimonga vyavimtenda muntu kayugi ndiri, wamonga wayiwukiti ntambu ira ayi, na wamonga watendwa na wantu hapeni wayugi na wamonga walema kuyuga toziya ya Ufalumi wa kumpindi. Yoseri yakajimira mafundu aga, su kagajimili.” ");
INSERT INTO poy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wantu wamu wamjegeriti Yesu wana wadidini su kawakisikiri na kuwaluwira kwa Mlungu, kumbiti wafundwa wawakalipira. ");
INSERT INTO poy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu katakula, “Muwaleki wana wizi kwa neni, namuwalewelera toziya Ufalumi wa kumpindi ndo wa wantu gambira wana awa.” ");
INSERT INTO poy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kawakisikira womberi, shakapanu kawuka palii. ");
INSERT INTO poy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Muntu yumu kamgendera Yesu kamkosiya, “mfunda, ntendi shintu gaa shiherepa su mpati ukomu wa mashaka goseri?” ");
INSERT INTO poy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu kamwankula, “Iwera hashi gunkosiya kuusu shitwatila shiheri? Kwana yumu hera yakawera muheri. Pagufira kwingira muukomu wa mashaka goseri gugajimili malagaliru ga Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yomberi kakosiya, “Malagaliru goshi?” Yesu kamwankula, “Nagulaga, nagutenda uhumba, nagwiwa, nagutakula upitawu wa mpayu kwa muntu yoseri, ");
INSERT INTO poy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","guwapanani ligoya tati gwaku na mawu gwaku, na guwafiri wantu wamonga ntambu yagulifira gumweni.” ");
INSERT INTO poy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Muntemba ulii kamgambira, “Malagaliru goseri nugajimira, ntendi shishi shimonga?” ");
INSERT INTO poy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu kamgambira yomberi, “Handa pagufira guweri muheri nakaka, gugendi gwakawuzi vintu vyaku vyoseri na guwapanani mpiya wahushu na gwenga haguweri mlunda kumpindi kwa Mlungu, shakapanu gwizi gunfati.” ");
INSERT INTO poy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Muntemba ulii pakapikaniriti aga, kagenda zakuwi pakakalala toziya kaweriti kalunda nentu. ");
INSERT INTO poy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Shakapanu Yesu kawagambira wafundwa wakuwi, “Nakaka nukugambirani mwenga, hayiweri vikamala nentu kwa mlunda kwingira Muufalumi wa kumpindi. ");
INSERT INTO poy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nakaka nuwagambirani, hayiweri vikamala kwa mlunda kwingira Muufalumi wa Mlungu kuliku shigongolu shawashishema ntembu kwingira mushitoboli sha sindanu.” ");
INSERT INTO poy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wafundwa pawapikaniriti aga, walikangasha nentu. Su wamkosiya, “Hashi, ndo gaa yakaweza kulopoziwa?” ");
INSERT INTO poy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu kawalola na kawankula, “Ashi shikamala nentu kwa wantu, kumbiti kwa Mlungu shila shintu shikamala ndiri.” ");
INSERT INTO poy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Shakapanu Peteru kalonga, “Guloli, twenga tuleka shila shintu na tukufata gwenga. Hashi, hatupati shishi?” ");
INSERT INTO poy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu kawagambira, “Hamuweri na unakaka kuwera Mwana gwa Muntu pakalikala mushibanta sha shifalumi shikwisa muisi yasyayi, mwenga yamunfata neni, hamulivagi muvibanta vikwisa, kugakolamlima makabila lilongu na mbili ga Israeli. ");
INSERT INTO poy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na yoseri yakalekiti numba ama mlongu ama mhasha ama tati ama mawu ama wana ama malambu toziya yaneni, hakapati mala miya nentu ya vilii yakavilekiti na hakalikali muukomu wa mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kumbiti wantu wavuwa yawawera wa kwanja vinu hawaweri wa kupelera, na woseri yawawera wakupelera vinu hawaweri wa kwanja. ");
INSERT INTO poy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ufalumi wa kumpindi ulifana hangu. Kuweriti na muntu yakalilawa mandawira putiputi kugenda kuwatula wantu watendi lihengu mulirambu lyakuwi lya mizyabibu. ");
INSERT INTO poy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kapataniti nawomberi shibenamgongu sha lishaka limu, na kawajega wantu wamu mulirambu lyakuwi lya mizyabibu. ");
INSERT INTO poy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kalawa saa tatu mandawira kagenda pahala pa soku kawawona wantu wamonga wagoloka paliya wahera lihengu. ");
INSERT INTO poy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Su kawagambira, ‘Mwenga mgendi mwakatendi lihengu mulirambu lya mizyabibu, neni hanuwapanani shibenamgongu.’ ");
INSERT INTO poy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Su womberi wagenda. Mweni kana lirambu kawuka kayi saa sita na saa tisa palwala, katenditi ntambu iraa. ");
INSERT INTO poy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Payiweriti pakwegera na mshenji kuzyeta pakagenditi pahala pa soku, kawawoniti wantu wamonga wankali wankugoloka paliya. Yomberi kawakosiya, ‘Iwera hashi mgoloka panu paliwala poseri pota kutenda lihengu?’ ");
INSERT INTO poy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Womberi wamwankula, ‘Kwahera muntu yakatupa lihengu twenga.’ Na yomberi kawagambira, ‘Mwenga mgendi na kutenda lihengu mulirambu lyaneni lya mizyabibu.’ ");
INSERT INTO poy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Mshenji paguzyetiti yakana lirambu kiziti na kamgambiriti mtula mpiya gwakuwi, ‘Guwashemi watenda lihengu na guwapanani vibenamgongu vyawu, gwanjiti kuwapanana yanuwajegiti muupeleru na gumaliri kwa kuwapanana walii yanuwajegiti kwanja.’ ");
INSERT INTO poy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wantu yawanjiti kutenda lihengu mshenji kuzyeta, gumpanani kila muntu shibenamgongu sha lishaka limu. ");
INSERT INTO poy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Su wantu waliya yawaweriti wakwanja kwiza kutenda lihengu wiziti kutola mpiya zyawu, womberi waliholiti kuwera hawapati mpiya nentu kuliku womberi, kumbiti wapatiti vibenamgongu vyawu kila muntu. ");
INSERT INTO poy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Womberi watoliti mpiya zyawu na wanjiti kumuhinginiziya mtuwa yakawajegiti kutenda lihengu. ");
INSERT INTO poy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Watakula, ‘Wantu awa yaguwajegiti kutenda lihengu muupeleru, watenda lihengu lisaa limu hera, twenga tutenda lihengu kwanjira mandawira mpaka mshenji kuzyeta, tuvumiliya mshenji gukalipa, su gwenga gutulipa twenga ntambu yaguwalipa womberi!’ ");
INSERT INTO poy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mtuwa ulii kamwankula yumu gwawu, ‘Gupikaniri ganja, nukupunja ndiri shintu! Toziya gujimilirana na neni nukulipi shibenamgongu. ");
INSERT INTO poy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Vinu gutoli malipu gaku na gugendi ukaya. Nfira kumupa muntu ayu yanumjegiti muupeleru kutenda lihengu, shibenamgongu ntambu yanukupanana gwenga. ");
INSERT INTO poy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Hashi, neni nekeziwa ndiri kutenda ntambu yanfira kutendera mpiya zangu? Ama gumonera weya toziya neni ntanga wantu?’ ” ");
INSERT INTO poy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu kamalira kwa kutakula, “Su wantu woseri yawawoneka wakuupeleru vinu, hawaweri wakwanja na wantu woseri yawawoneka wakwanja vinu, hawaweri wakuupeleru.” ");
INSERT INTO poy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu pakaweriti kankugenda Yerusalemu, kawatoliti wafundwa wakuwi lilongu na wawili pambwega na kuwagambira gweka yawu pawaweriti wankugendagenda. ");
INSERT INTO poy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Kawagambira, “Mpikaniri, twankugenda Yerusalemu, aku Mwana gwa Muntu hawambati na kumjega kwa Watambika wakulu na wafunda wa Malagaliru. Womberi hawamtozi kumlaga ");
INSERT INTO poy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","na hawawapanani wantu wa isi zimonga, womberi hawamtenderi lidufiya na hawamkomi na hawamlagi kwa kumkong'ondera mulupingika na lishaka lya tatu kwanjira pakahowiti hakazyuki.” ");
INSERT INTO poy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Shakapanu mdala gwa Zebedayu kiziti kwa Yesu pamuhera na wana wakuwi wawili, kamsuntamalira na kumluwa shintu. ");
INSERT INTO poy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu kamkosiya, “Gufira shishi?” Mawu uliya kamwankula, “Gunahidi neni kuwera wana waneni awa wawili hawalivagi yumu uwega waku wa kumliwu na yumonga uwega waku wa kumshigi, shipindi paguwera Mfalumi.” ");
INSERT INTO poy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu kawankula wana walii, “Muvimana ndiri shamluwa. Hashi, muweza kulandira lutekeru lwa ndabibiku lwanfira kulandira neni?” Womberi wamwankula, “Tuweza.” ");
INSERT INTO poy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu kawagambira, “Nakaka hamlandiri lutekeru lwangu. Kumbiti neni hapeni ntakuli yoshi hakalivagi kumliwu ama kumshigi kwaneni. Shitwatira ashi ndo sha woseri yawatulilwa kala na Tati gwangu.” ");
INSERT INTO poy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wafundwa wamonga walii pawapikaniriti aga, wawakalaliti walongu wawili walii. ");
INSERT INTO poy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Su Yesu kawashema woseri pamuhera na kawagambira, “Muvimana kuwera wakolamlima wa isi zimonga wankuwakola wantu wawu kwa makakala na walongoziya wawu wanauwezu nentu. ");
INSERT INTO poy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kumbiti kwa mwenga naiwera gambira womberi pakati penu. Handa pakati penu kwana muntu yakafira kuwera mkulu, kaweri ntumintumi gwa wantu woseri. ");
INSERT INTO poy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Handa pakati penu kwana muntu yakafira kuwera gwa kwanja, kaweri ntumintumi gwenu. ");
INSERT INTO poy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Na neni Mwana gwa Muntu niziti ndiri wantenderi, kumbiti niziti kutenda na kuwulaviya ukomu wangu, su nuwalopoziyi wantu wavuwa.” ");
INSERT INTO poy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu pamuhera na wantumintumi wakuwi pakaweriti wankuwuka lushi lwa Yeriku, lipinga likulu lya wantu limfatiti. ");
INSERT INTO poy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Su kuweriti na wanalwisi wawili walivaga pampeku pa njira, wapikiniriti kuwera Yesu kankupita peni paliya, su wanjiti kubotanga, “Mtuwa, Mwana gwa Dawudi! Gutuwoneri lusungu!” ");
INSERT INTO poy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lipinga lya wantu liwakalipira na kuwagambira wanyamali. Kumbiti womberi wongera kubotanga, “Mtuwa, Mwana gwa Dawudi! Gutuwoneri lusungu!” ");
INSERT INTO poy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu kagoloka kawashema womberi. Su kawakosiya, “Mfira nuwatenderi shishi?” ");
INSERT INTO poy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Womberi wamwankula, “Mtuwa, tuluwa kuwona!” ");
INSERT INTO poy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Su Yesu kawawonera lusungu, kawashinkula masu gawu, na palaa paliya waweziti kuwona na wamfatiti. ");
INSERT INTO poy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na wafundwa wakuwi pawaweriti pakwegera na Yerusalemu na kusoka Betifagi kulugongu lwa Mizeyituni, kawatumiti wantumintumi wakuwi wawili, ");
INSERT INTO poy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","pakawagambira, “Mgendi mpaka kushijiji sha palongolu penu na hamumwoni punda na mwana gwakuwi wawatawa. Muwayopoli na munjegeri. ");
INSERT INTO poy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Handa muntu yoseri pakatakula shoseri, mumgambiri, ‘Mtuwa kawafira kawatenderi na shakapanu hawawalekeri.’ ” ");
INSERT INTO poy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Shitwatira ashi shitendikiti su galii gagatakulitwi na mbuyi gwa Mlungu gatendeki, ");
INSERT INTO poy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mlugambiri lushi lwa Sayuni, Guloli, Mfalumi gwaku kankwiza kwa gwenga! Ndo mpoli na kakwena panani pa punda, Na ndama, mwana gwa punda.” ");
INSERT INTO poy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Su wafundwa wakuwi wagenda na watenda ntambu Yesu yakawalagaliriti, ");
INSERT INTO poy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","wamjega punda ulii na ndama gwakuwi, wayazilira nguwu zyawu panani pa punda na Yesu kakwena kalivaga pampindi pakuwi. ");
INSERT INTO poy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lipinga lya wantu wayarika nguwu zawu munjira, na wantu wamonga wadumula maputira ga mitera na waiyalika panjira. ");
INSERT INTO poy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lipinga lya wantu wamlongoleriti Yesu na wamonga wamfatiti kumbeli pawabotanga, “Kakwiswi Mwana gwa Dawudi! Mlungu kamtekeleri yakiza mulitawu lya Mtuwa! Kakwiswi Mlungu!” ");
INSERT INTO poy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu pakaweriti kankwingira Yerusalemu, lushi loseri luweriti na shelekusheleku. Wantu wakosiyiti, “Hashi, ayu ndo gaa?” ");
INSERT INTO poy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lipinga lya wantu liwankula, “Ayu ndo Yesu mbuyi gwa Mlungu, kalawa Nazareti isi ya Galilaya.” ");
INSERT INTO poy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu kagenda kwingira Mnumba nkulu ya Mlungu, kawawinga kunja wantu woseri yawaweriti wankuwuza na kuhemera vintu palii. Kazigalambuziya meza zawaweriti wankuvunjira mpiya na vigoda vya wantu yawaweriti wankuwuza wang'unda, ");
INSERT INTO poy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","na kawagambira, “Galembwa Mumalembu Mananagala kuwera Mlungu kalonga, ‘Numba nkulu yaneni hayishemwi numba ya sala.’ Kumbiti mwenga muyitenda mpanga ya wapoka!” ");
INSERT INTO poy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wanalwisi na yawalewelekiti wamgendiriti Yesu Kunumba nkulu ya Mlungu na yomberi kawaponiziya. ");
INSERT INTO poy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Su, watambika wakulu na wafunda wa Malagaliru wakalaliti pawawoniti vitwatira vya kulikangasha vyakatenditi na wana pawaweriti wankubotanga Mnumba nkulu ya Mlungu pawalonga, “Kakwiswi Mwana gwa Dawudi!” ");
INSERT INTO poy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Su womberi wamkosiya Yesu, “Hashi, gupikinira ntambu yawalonga?” Yesu kawankula, “Yina mpikanira. Hashi, hamwebetuli Malembu aga? ‘Guwafunditi wana na wana wanonu ntambu ya kukukwisa.’ ” ");
INSERT INTO poy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Su, Yesu kawaleka na kagenda kunja kwa lushi na kagenda Betaniya na kalikaliti kulaa pashiru poseri. ");
INSERT INTO poy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesu pakaweriti kankuwuya mlushi mandawira putiputi, kaweriti na njala. ");
INSERT INTO poy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kaguwona mkuyu pampeku pa njira na kagugendera, kumbiti guweriti gwahera bwajubwaju loseri ira gwana mihamba hera. Su kagugambira mtera, “Hapeni guleri kayi mabwajubwaju!” Palaa palii mkuyu gulii guyuma. ");
INSERT INTO poy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wafundwa pawaguwoniti na walikangasha, pawalonga, “Iwera hashi mkuyu agu guyuma kanongola?” ");
INSERT INTO poy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu kawankula, “Nakaka nuwagambirani, handa pamuwera na njimiru pota na lyoga, hamuwezi kutenda ntambu yantenditi kwa mkuyu agu na kwa hangu ndiri hera kumbiti ata hamuwezi kulugambira lugongu, ‘Gutupuki gukalidibiziyi gumweni mulitanda,’ na hayitendeki. ");
INSERT INTO poy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Handa pamwajimira, hampananwi shoseri shamluwa kwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu kingiriti Mnumba nkulu ya Mlungu na kaweriti kankufunda. Watambika wakulu na wazewi wamwiziriti Yesu na kumkosiya, “Hashi, gutenda vitwatira avi kwa uwezu wa gaa? Hashi, ndo gaa yakakupanana uwezu awu?” ");
INSERT INTO poy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu kawankula, “Naneni hanuwakosiyi likosiwu limu na pamunankula, su naneni hanuwagambirani ntenda vitwatira avi kwa uwezu wa gaa. ");
INSERT INTO poy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nuwakosiya, ‘Hashi, uwezu wa Yohani Mbatiza ulawiti kwagaa? Hashi, ulawiti kumpindi ama kwa wantu?’ ” Kumbiti wanjiti kulitakuziyana weni, “Hatulongi ashi? Handa patutakula, ‘Ulawiti kwa Mlungu,’ yomberi hakatukosiyi, ‘Su, iwera hashi mumjimiriti ndiri Yohani?’ ");
INSERT INTO poy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kumbiti patulonga, ‘Ulawiti kwa wantu,’ tutira lipinga lya wantu toziya wantu woseri wavimana kuwera Yohani kaweriti mbuyi gwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Su, wamwankula Yesu, “Tuvimana ndiri.” Yesu kawagambira, “Naneni viraa hapeni nuwagambiri ntenda vitwatira avi kwa uwezu wa gaa. ");
INSERT INTO poy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Vinu mwenga mulihola ashashi kwa shitwatira ashi? Kuweriti muntu yumu yakaweriti na wana wakuwi wawili. Yomberi kamgendiriti mkulu yumu na kulonga, ‘Mwana gwangu, leru gugendi gwakatendi lihengu mulirambu lya mizyabibu.’ ");
INSERT INTO poy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yomberi kamwankula, ‘Hapeni ng'endi,’ kumbiti shakapanu kagenda kutenda lihengu. ");
INSERT INTO poy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Shakapanu tati ulii kamgendera mwana gwakuwi yumonga kamgambiriti ntambu ilii. Yomberi kamwankula, ‘Yina tati hang'endi,’ kumbiti kagenditi ndiri. ");
INSERT INTO poy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hashi, pa wawili awa gaa yakatenditi gakafiriti tati gwakuwi?” Womberi wamwankula, “Uliya mwana gwa kwanja.” Su, Yesu kawagambira, “Nuwagambirani nakaka, watola kodi na wandiyandiya hawawalonguleri kugenda kwingira Muufalumi wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Toziya Yohani Mbatiza kiziti kwa mwenga kawalanguziya njira ya kulikala ya kumfiriziya Mlungu na mwenga mumjimira ndiri, kumbiti watola kodi na wandiyandiya wamjimiriti. Ata pamwoniti goseri aga, mwenga mlekiti ndiri vidoda vyamtenda na kumjimira yomberi.” ");
INSERT INTO poy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu kalonga, “Mpikaniri mfanu gumonga. Kuweriti na muntu yakaweriti na lirambu, ndo mweni yakalimiti mizyabibu, katindiziya lipamanda na kabawa linegu lya kukamira zyabibu na kanyawiti liringu lya kulolelera. Shakapanu lirambu lya mizyabibu lilii kaliyazimira kwa walimaji, mweni kagenda mwanja gwa kutali. ");
INSERT INTO poy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Shipindi sha kubenanga pashisokiti, kawatumiti wantumintumi wakuwi kwa walimaji walii, su watoli semu yakuwi yawabeniti. ");
INSERT INTO poy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Walimaji walii wawakamula wantumintumi wakuwi, yumu wamkomanga, yumonga wamlaga na yumonga wamlaga kwa kumgumanga mabuwi. ");
INSERT INTO poy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Muntu ulii kawatuma kayi wantumintumi wamonga wavuwa, kuliku wa kwanja, walimaji walii watenda ntambu ira ilii. ");
INSERT INTO poy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Upeleru kamtuma mwana gwakuwi kugenda kwa womberi pakalihola, ‘Nakaka hawampikiniri mwana gwangu.’ ");
INSERT INTO poy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kumbiti walimaji walii pawamwoniti mwana gwakuwi, walitakuziyana weni kwa weni, ‘Ayu ndo muhala gwakuwi. Mwizi tumlagi na uhala wakuwi hauweri watwenga!’ ");
INSERT INTO poy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Su, wambata na wamlaviya kunja kulirambu lilii lya mizyabibu na wamlaga.” ");
INSERT INTO poy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu kawakosiya, “Vinu, mweni kana lirambu lya mizyabibu pakiza, hakawatendi hashi walimaji walii?” ");
INSERT INTO poy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Womberi wamwakula, “Hakawalagi woseri yawatenditi vidoda na lirambu lilii hakawapanani walimaji wamonga, ndo weni hawamupanani semu yakuwi yawavibena kwa shipindi sha kubenanga.” ");
INSERT INTO poy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu kawagambira, “Hashi, hamwebetuli shawalembiti Mumalembu Managala? ‘Libuwi lyawalilemiti wanyawa numba, vinu liwera libuwi lyaliwera na mana nentu kuliku mabuwi goseri. Mtuwa ndo yakatenditi shitwatira ashi, shitwatira sha kulikangasha nentu kwa twenga!’ ” ");
INSERT INTO poy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu kongera kutakula, “Su nuwagambirani, Ufalumi wa Mlungu hawawawusiyi kwa mwenga na kuwapanani wantu yawalera mabwajubwaju gaherepa. ");
INSERT INTO poy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yoseri yakaguwa pa libuwi ali hakamegeki vipandi vipandi na libuwi palimguwira muntu yoseri, halimupekesi.” ");
INSERT INTO poy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Watambika wakulu na Mafalisayu pawapikaniriti mifanu ya Yesu na wavimaniti kuwera yomberi kaweriti kankuwalonga weni. ");
INSERT INTO poy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Su wajeriti kusakula ntambu ya kumkamula Yesu. Kumbiti womberi watiriti lipinga lya wantu lyawamaniti kuwera Yesu ndo mbuyi gwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu katakuliti nawomberi kayi kwa mfanu. ");
INSERT INTO poy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ufalumi wa kumpindi ulifana ntambu ayi. Kuweriti na mfalumi yakamtandiriti mwana gwakuwi mpalu msambu gwa ndowa. ");
INSERT INTO poy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Su, kawatumiti wantumintumi wakuwi wakawashemi walii yawashemiritwi wizi kumsambu, kumbiti walii yawashemiritwi walemiti kwiza. ");
INSERT INTO poy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kawatuma kayi wantumintumi wamonga, pakatakula, ‘Muwagambiri yawawashemiriti kuwera msambu gwangu vinu gwa kala, wang'ombi wangu na wandama waherepa wawalikitula kala. Shila shintu shiwera kala, su mwizi mumsambu gwa ndowa!’ ");
INSERT INTO poy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kumbiti wahenga yawashemiritwi walishera ndiri, su wendereyiti na vitwatira vyawu, yumu kagenditi kulirambu kwakuwi na yumonga kagenditi kutenda biyashala yakuwi, ");
INSERT INTO poy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","na wamonga wawakamula wantumintumi walii, wawakomanga na kuwalaga. ");
INSERT INTO poy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mfalumi ulii kakalariti nentu, su kawatuma wanjagila wakuwi wakawalagi woseri yawatenditi hangu na kapambira motu lushi zyawu. ");
INSERT INTO poy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Shakapanu kawagambira wantumintumi wakuwi, ‘Msambu gwa ndowa gwa kala, kumbiti yawashemiritwi walema kwiza. ");
INSERT INTO poy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Vinu mgendi munjira pamwawona wantu woseri mwashemi wizi mumsambu gwa ndowa.’ ");
INSERT INTO poy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Su wantumintumi walii wawuka na wagenda munjira, wawashemera wantu woseri yawawoniti, wadoda na waheri, numba yoseri ya msambu ivuwiti wahenga. ");
INSERT INTO poy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Mfalumi pakayingiriti kuwalola wahenga, kamwona muntu kavala ndiri nguwu ya ndowa. ");
INSERT INTO poy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mfalumi kamkosiya, ‘Ganja, gwingira hashi panu pota kuvala nguwu ya ndowa?’ Kumbiti yomberi kawankula ndiri. ");
INSERT INTO poy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Palaa palii mfalumi kawagambira wantumintumi, ‘Mumtawi magulu na mawoku, mwakamwasi kunja muntiti. Aku hakalili na kugayagaya menu gakuwi.’ ” ");
INSERT INTO poy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Na Yesu kamalira kwa kutakula, “Yawashemiritwi wavuwa, kumbiti yawasyagulitwi ndo wadidini.” ");
INSERT INTO poy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Shakapanu Mafalisayu wagenda zawu na wapangiti ntambu ya kumgomiziya Yesu kwa visoweru vyakuwi. ");
INSERT INTO poy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Su, womberi wawatuma wafundwa wawu pamuhera na wantumini wa shipinga sha Herodi kugenda kwa Yesu. Womberi walonga, “mfunda, tuvimana handa gwenga gutakula nakaka. Gwenga gufunda nakaka kuusu mafiliru ga Mlungu kwa wantu, gutira ndiri shawalihola wamonga, toziya gulishera ndiri ukulu wa muntu. ");
INSERT INTO poy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Su, gutugambiri, gwenga gulihola shishi? Lagaliru ama lagaliru ndiri kulipa kodi kwa Kaisari?” ");
INSERT INTO poy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kumbiti Yesu kavimana ukondola wawu yawalihola, su kawagambira, “Mwawafyangu mwenga! Iwera hashi mwankujera kungomiziya? ");
INSERT INTO poy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Munanguziyi mpiya zya kulipira kodi!” Womberi wamlavilira ligwala lya mpiya, ");
INSERT INTO poy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","na Yesu kawakosiya, “Sheni na malembu aga mumpiya ga gaa?” ");
INSERT INTO poy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Womberi wamwankula, “Ga mfalumi gwa Rumi.” Su Yesu kawagambira, “Mumpanani Kaisari vyaviwera vya Kaisari na mumpanani Mlungu vyaviwera vya Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pawapikaniriti hangu, walikangasha na wamleka wagenditi zawu. ");
INSERT INTO poy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lishaka liraa lilii, Masadukayu wamu ndo yawatakulaga wantu yawahowiti hapeni wazyuki, wamgenderiti Yesu. ");
INSERT INTO poy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Su wamgambira, “mfunda, Musa katakuriti kuwera muntu yakayugiti pakahowa pota kuleka mwana, ndo mlongu gwakuwi kamyugi mdala mkenja uliya, su kamleleri wana mlongu gwakuwi yakahowiti. ");
INSERT INTO poy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Vinu petu panu, paweriti na walongu saba. Mlongu mkulu kayugiti mdala na kahowiti pota kupata mwana, su mlongu gwakuwi kamuhala mkenja ulii. ");
INSERT INTO poy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Iwera ntambu ira kwa mlongu gwa pili na gwa tatu mpaka kwa woseri saba. ");
INSERT INTO poy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Lupeleru na mdala uliya kahowiti viraa. ");
INSERT INTO poy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Vinu, mulishaka lya kuzyuka kwa yawahowiti, hashi, mdala ayu hakaweri mdala gwa gaa? Toziya mkenja ayu kaweriti mdala wa walongu woseri saba.” ");
INSERT INTO poy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu kawankula, “Mwenga mwagamila nakaka! Mwagamila toziya mgamana ndiri Malembu Mananagala ama makakala ga Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Toziya yawahowiti pawazyuka, hawalifani gambira wantumintumi wa kumpindi kwa Mlungu na wantu hapeni wayugi ama kuyugwa. ");
INSERT INTO poy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kumbiti kuusu kuzyuka kwa yawahowiti, hashi, hamwenibetuli galaa Mlungu gakawagambiriti? Mlungu kawagambiriti, ");
INSERT INTO poy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Neni ndo Mlungu gwa Aburahamu, ndo Mlungu gwa Isaka, ndo Mlungu gwa Yakobu!’ Yomberi Mlungu gwa wahowiti ndiri, ira Mlungu gwa wakomu.” ");
INSERT INTO poy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lipinga lya wantu palipikaniriti hangu walikangasha mafundu gakuwi. ");
INSERT INTO poy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafalisayu pawapikaniriti handa Yesu kawawankula Masadukayu mpaka wasinditi kumkosiya kayi, su womberi waliwoniti pamuhera. ");
INSERT INTO poy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yumu gwawu, mfunda gwa Malagaliru, kamkosiya Yesu kwa kufira kumgomiziya, ");
INSERT INTO poy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“mfunda, lilagaliru lyoshi ndo likulu Mumalagaliru?” ");
INSERT INTO poy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu kamwankula, “Gumfiri Mtuwa Mlungu gwaku kwa moyu gwaku gwoseri, kwa rohu yaku yoseri na kwa mahala gaku goseri.” ");
INSERT INTO poy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ali ndo lilagaliru likulu lya kwanja. ");
INSERT INTO poy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na lya pili lilifana na ali, “Gumfiri gwapakwegera gwaku ntambu yagulifira gumweni.” ");
INSERT INTO poy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Malagaliru goseri ga Musa na malembu ga wambuyi wa Mlungu gankulitumbira malagaliru mawili aga. ");
INSERT INTO poy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mafalisayu pawaweriti pamuhera, Yesu kawakosiiti, ");
INSERT INTO poy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mwenga mulihola hashi kuusu Kristu Mlopoziya? Hashi, yomberi ndo gwa shiyiwuku shagaa?” Wamwankula, “Shiyiwuku sha Dawudi.” ");
INSERT INTO poy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu kawagambira, “Su, iwezekana hashi kwa likakala lya Rohu Mnanagala Dawudi kamshemi yomberi ‘Mtuwa’? Dawudi katakuliti, ");
INSERT INTO poy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Mtuwa kamgambiriti Mtuwa gwangu, Gulivagi uwega waneni wa kumliwu, Mpaka nuwatuli wangondu waku pasi pa magulu gaku.’ ");
INSERT INTO poy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Payiwera Dawudi kamshemiti yomberi ‘Mtuwa,’ su iwezakana hashi kuwera Kristu ndo gwa shiyiwuku sha Dawudi?” ");
INSERT INTO poy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kwahera muntu yoseri yakaweziti kumwankula Yesu na kwanjira lishaka lilii kwahera yakajeriti kayi kukosiya shoseri. ");
INSERT INTO poy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Shakapanu Yesu kaligambira lipinga lya wantu pamuhera na wafundwa wakuwi, ");
INSERT INTO poy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Wafunda wa Malagaliru na Mafalisayu wanauwezu wa kutakulira Malagaliru ga Musa. ");
INSERT INTO poy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Su mfiruwa kujimila na kutenda shoseri shawawagambireni, kumbiti namtenda vyawawatenda weni, toziya watenda ndiri vilii vyawafunda. ");
INSERT INTO poy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Watawa visanka vitopa na kuwatwika wantu, kumbiti weni wasinda ata kutalipisiya shala wapati kupapa. ");
INSERT INTO poy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Womberi wankutenda matendu gawu goseri su wantu wagawoni, wankuvala tepi zilembwa malagaliru kusheni kwawu na mumawoku na wongera mishirashira mumahabiti gawu. ");
INSERT INTO poy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wafira kulikala pahala paligoya mumsambu na kulikala viti vya ligoya munumba ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Wafira wawalamsiyi kwa ligoya pahala pa soku na wafira wantu wawashemi, ‘Mfunda.’ ");
INSERT INTO poy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kumbiti mwenga namshemwa ‘mfunda,’ toziya mfunda gwenu yumu hera, na woseri mwenga mwawalongu. ");
INSERT INTO poy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ama namumshema muntu yoseri ‘Tati’ pasipanu, toziya mwana Tati yumu hera kumpindi. ");
INSERT INTO poy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Namshemwa ‘Walonguziya,’ toziya mwana mlonguziya yumu hera ndo Kristu Mlopoziya. ");
INSERT INTO poy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yakawera mkulu pakati penu mpaka kaweri ntumintumi gwenu. ");
INSERT INTO poy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yakalikwisa hawamsulusiyi na yakalisulusiya mweni, hakakwiswi.” ");
INSERT INTO poy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Shondi wafunda wa Malagaliru na Mafalisayu, mwawafyangu mwenga! Mwankutata mlyangu gwa Ufalumi wa kumpindi palaa wantu pawafiriti kwingira, kumbiti maweni mwenga mwingira ndiri na muwajimira ndiri wantu yawajera kwingira. ");
INSERT INTO poy_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Shondi wafunda wa Malagaliru na Mafalisayu, mwawafyangu mwenga! Mwankuwayonga wakenja nakuwapoka numba zawu na mwankulilanguziya kusali sala ntali! Toziya ya hangu hampati azabu nkulu nentu!” Malembu gamonga gahera musitari agu. ");
INSERT INTO poy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Shondi wafunda wa Malagaliru na Mafalisayu, mwawafyangu mwenga! Mwankugenda mwanja mulitanda na paisi su mpati muntu yumu yakajimira ntambu yamjimira. Pamumpata, mumtenda mala mbili kaweri muntu gwa kugenda mumotu gwa jehanamu kuliku maweni mwenga.” ");
INSERT INTO poy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Shondi walongoziya mwana lwisi! Mwenga mfunda muntu pakalilapira kwa Numba nkulu ya Mlungu, kulilapira aku shintu ndiri, kumbiti pakalirapa kwa zahabu Mnumba nkulu ya Mlungu, kulirapira aku kumkola. ");
INSERT INTO poy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwenga mwanalwisi wazigizigi! Shoshi shana mana nentu, zahabu ama Numba nkulu ya Mlungu yayitenda zahabu iweri nanagala? ");
INSERT INTO poy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kayi mfunda, muntu pakalirapira pashitalawanda sha kutambikira, shintu ndiri, kumbiti pakalirapira kwa lifupu lyawalituliti pashitalawanda sha kutambikira, kulirapa aku hakumkoli. ");
INSERT INTO poy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mwenga mwawa lwisi! Shoshi sha mana nentu, lifupu lilii, ama pashitalawanda sha kutambikira peni patendaga lifupu liweri linanagala? ");
INSERT INTO poy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Muntu yakalilapira kwa pashitalawanda sha kutambikira kalirapa kwa pahala pa kutambikira na mafupu goseri gawatuliti pahala pa kutambikira. ");
INSERT INTO poy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na yakalirapira kwa Numba nkulu ya Mlungu, kalilapira kwa Numba nkulu ya Mlungu na Mlungu yakalikala amu, ");
INSERT INTO poy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","na yoseri yakalirapira kumpindi kwa Mlungu, su kalilapira kwa shibanta sha shifalumi sha Mlungu na kwa Mlungu yakalivagira. ");
INSERT INTO poy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Shondi wafunda wa Malagaliru na Mafalisayu, mwawafyangu mwenga! Mwankuwatoza wantu shintu shimu muvintu lilongu, ata kuusu viungu vya likolu gambira mahamba ganunkira weri na binzari na jira na kumbiti mleka kujimira mafundu ga mana ga Malagaliru, gambira vitendu viheri na lusungu na njimiru. Vitwatila avi vya mana ndo mfiruwa kuvitenda pota na kulyaluwa vyamonga. ");
INSERT INTO poy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mwenga walongoziya mwana lwisi! Mwankulaviya wavingozi mu vyakulanda, kumbiti mwankumira shingongolu yawamshema ntembu! ");
INSERT INTO poy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Shondi wafunda wa Malagaliru na Mafalisayu, mwawafyangu mwenga! Mwankugulula shikombi na bakuli kwa kunja, kumbiti mngati kumema vintu vyampatiti kwa wakwepula na malema. ");
INSERT INTO poy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mfalisayu lwisi! Gugulula uhakata huti yawuwera mushikombi na kunja hakuweri kuherepa viraa. ");
INSERT INTO poy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Shondi wafunda wa Malagaliru na Mafalisayu, wafyangu mwenga! Muwera gambira mapumba gawatyelemekiti shokaa ndo yeni kwa kunja gawonikana gaherepa, kumbiti mngati imema mifupa ya mawuti na kila ntambu ya kudoda. ");
INSERT INTO poy_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Viraa virii kwa kunja mwenga muwoneka mwawaheri, kumbiti mumyoyu mwenu kumema ufyangu na udoda. ");
INSERT INTO poy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Shondi wafunda wa Malagaliru na Mafalisayu, mwawafyangu mwenga! Mwankunyawira mapumba ga wambuyi wa Mlungu na kugalembera mapumba ga wantu waheri, ");
INSERT INTO poy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","na mlonga, ‘Handa twenga metulikali shipindi sha wagogolu wetu metulitangiti ndiri nawomberi kuwalaga wambuyi wa Mlungu!’ ");
INSERT INTO poy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Su mpitaulira kuwera maweni mwenga ndo wiwuka wawu woseri yawawalagiti wambuyi wa Mlungu! ");
INSERT INTO poy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Su, mumalili shilii shawanjiti wagogolu wenu! ");
INSERT INTO poy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mwenga wanjoka na wana wa wanjoka! Mwenga namulihola kuwera muweza kukwepa kutozwa kwingira mumotu gwa Jehanamu. ");
INSERT INTO poy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Su neni nuwagambirani kuwera hanuwajegeri mwenga wambuyi wa Mlungu. Na wantu wana luhala na wafunda wa Malagaliru ga Musa, hamuwalagi wamu wawu na kuwapingika wamonga na kuwasyatanga ntomondu wamonga munumba za Mlungu na kuwawinga kulawa lushi na lushi. ");
INSERT INTO poy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Vilawilu vya kutoza kwa kuwalaga wantu woseri waheri haiweri kwa mwenga, kwanjira kulagwa kwa Abeli muntu muheri mpaka kulagwa kwa Zakariya mwana gwa Barakiya, Zakariya ndo mweni yamumlagiti pakati pa Numba nkulu ya Mlungu na pashitalawanda sha kutambikira. ");
INSERT INTO poy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nakaka nuwagambireni, kutozwa kwa wantu woseri yawawalaga wayawu hakuweri kwa shiyiwuku sha mashaka aga! ");
INSERT INTO poy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yerusalemu! Shondi shondi Yerusalemu bamu! Guwalaga wambuyi wa Mlungu, guwagumanga kwa mabuwi walii yawatumitwi kwakuwi! Vipindi vivuwa nfira kuwatula wana waku mumawoku mwangu gambira nkuku pakavigupika vyana vyakuwi kwa mbapatiru zyakuwi, kumbiti gwenga gunema! ");
INSERT INTO poy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Su, Numba nkulu ya Mlungu yaku hailekwi ushiwa. ");
INSERT INTO poy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nukugambirani kwanjira vinu, hapeni gumoni kayi mpaka pagutakula, ‘Mlungu gumtekeleri yomberi yakiza mulitawu lya Mtuwa.’ ” ");
INSERT INTO poy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu kalawiti Mnumba nkulu ya Mlungu, pakaweriti kankugenda zakuwi, wafundwa wakuwi wamgenderiti wamlanguziya majengu ga Numba nkulu ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu kawagambira, “Yina, muweza kugalola goseri aga! Nakaka nuwagambirani, kwahera hata libuwi limu halisigali panu pampindi pa libuwi limonga, kila libuwi haliwusiwi.” ");
INSERT INTO poy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu pakalivagiti palugongu lwa Mizeyituni, wafundwa wakuwi wamgenderiti kwa bada, su wamkosiya, “Gutugambiri, hashi vitwatira avi havilawili ndii? Na hashilawiri shishi kulanguziya ndo shipindi sha kwiza kwaku na shipindi sha upeleru pasipanu.” ");
INSERT INTO poy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu kawankula, “Mulikali weri, muntu nakiza kuwapayirani. ");
INSERT INTO poy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wantu wavuwa hawalawili na kulonga kila yumu, ndo Kristu Mlopoziya na hawawazyangi wantu wavuwa. ");
INSERT INTO poy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hampikaniri kuusu ngondu pakwegera na visoweru vya ngondu, kumbiti namulihola. Toziya vitwatira mpaka vilawiri, kumbiti upeleru weni wankali kwiza. ");
INSERT INTO poy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Isi yimu hailikomangi na isi yimonga na ufalumi wumu hawulikomangi na ufalumi umonga. Panu na palii hapaweri na njala na malendemeru ga isi kila pahala. ");
INSERT INTO poy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Vitwatila vyoseri avi vilifana gambira kutama pakwanja pakulera mwana. ");
INSERT INTO poy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Shakapanu hawawalaviyani su wawatabisiyi na kuwalaga. Isi zoseri haziwakalaliri toziya ya litawu lyaneni. ");
INSERT INTO poy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mushipindi ashi wantu wavuwa hawaleki myoyu yawu, hawagambulikani weni kwa weni na kukalalirana weni kwa weni. ");
INSERT INTO poy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Hawalawili wambuyi wa upayira, pawapotuziya wantu wavuwa. ");
INSERT INTO poy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Su vitwatira vifaa ndiri havyongereki, mafiliru ga wantu wavuwa hauweri tisutisu. ");
INSERT INTO poy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kumbiti muntu yakahepelera mpaka lupeleru hakalopoziwi. ");
INSERT INTO poy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na Shisoweru Shiwagira sha Ufalumi wa Mlungu hashibwerwi pasipanu poseri muwukapitawu kwa wantu wa makabila goseri na upeleru hawizi. ");
INSERT INTO poy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Su, hamuwoni ‘Shintu shidoda shashihalabisiya’ shakatakuliti Danieli mbuyi gwa Mlungu, shigoloka pahala pananagala.” Yakabetula kavimani mana yakuwi! ");
INSERT INTO poy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Panu, yawawera Yudeya su watugili muvigongu. ");
INSERT INTO poy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yakawera pashitwiku sha numba nakasuluka kutola shintu mnumba mwakuwi. ");
INSERT INTO poy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yakaweriti kulirambu nakawuya kumbeli kutola nguwu yakuwi. ");
INSERT INTO poy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Shondi shondi wamawu yawawera na yinda na walii yawanoniziya mumashaka galii! ");
INSERT INTO poy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mumluwi Mlungu, su kutuga kwa mwenga nakuwera mashaka ga mpepu ama lishaka lya Kwoyera! ");
INSERT INTO poy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Toziya mushipindi ashi hakuweri na uhushu mkulu ndoweni wankali kulawira, kwanjira kunyawa kwa pasipanu mpaka leru, wala hapeni ilawiri kayi. ");
INSERT INTO poy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kumbiti Mlungu kagapunguriti kala shiyasi sha mashaka aga, mekatendi ndiri, kwahera muntu yoseri mekalikali. Toziya ya wantu yawasyagulitwi, Mlungu hakagapunguli mashaka aga. ");
INSERT INTO poy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Su, muntu yoseri pakawagambirani, ‘Guloli Kristu Mlopoziya kapanu’ ama ‘Kapalii!’ Namjimira. ");
INSERT INTO poy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Hawalawili ashina Kristu wa upayira na wambuyi wa upayira, hawatendi mauzauza makulu na gakulikangasha su wawazyangi payiwezekana ata yawasyagulitwi na Mlungu. ");
INSERT INTO poy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mpikanili! Nuwagambirani pamberi pa shipindi kwiza. ");
INSERT INTO poy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ama, pawawagambirani, ‘Mloli, ka kushiwala!’ Namgenda aku, ama pawalonga, ‘Mloli, kalififa panu!’ Namjimira. ");
INSERT INTO poy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mwana gwa Muntu hakizi gambira gulangala gambira lumeta kulyera kulawa kwagulawa mshenji mpaka kwaguzyeta mshenji. ");
INSERT INTO poy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Palii paweriti na shashifuwiti, ndo pawajojinika wandapu.” ");
INSERT INTO poy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Palaa palii, pa mashaka ga kutabisiya, mshenji haguweri ntiti, na lyezi haliweri ndiri na gulangala na ntondu hazituluki kulawa kulyera na likakala lya kumpindi halilibegizii. ");
INSERT INTO poy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Shakapanu, lilangaliru lya Mwana gwa Muntu halilawiri kulyera na wantu woseri wa pasipanu hawalili pawamwona Mwana gwa Muntu pakiza mumawundi ga kumpindi pamuhera na makakala makulu. ");
INSERT INTO poy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mliru mkulu gwa mbalapi hagupikaniki na yomberi hakawatumi wantumintumi wa kumpindi wakuwi muwega za msheshi za pasipanu na hawawajojiniri wantu kulawa lupeleru lumu lwa pasipanu mpaka lupeleru lumonga lwa pasipanu. ");
INSERT INTO poy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mleki mtera gwa mkuyu guwafundi. Mitambi ya mitera payiyanja kutomola mahamba, muvimani kuwera shipindi sha kutowa vula shapakwegera. ");
INSERT INTO poy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ntambu ira ayi mwenga pamwona vitwatira vyoseri avi, muvimani handa shipindi shapakwegera nentu. ");
INSERT INTO poy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Muliholi kuwera vitwatira vyoseri avi havilawili pamberi pa kuhowa wantu yawalikala vinu. ");
INSERT INTO poy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kumpindi kwa Mlungu na pasipanu hazipiti, kumbiti visoweru vyaneni hapeni vipiti. ");
INSERT INTO poy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kwahera muntu yoseri yakavimana lishaka ama lisaa paviza, ama wantumintumi wa kumpindi kwa Mlungu ama Mwana. Tati gweka yakuwi ndo yakavimana. ");
INSERT INTO poy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kwiza kwa Mwana gwa Muntu hakuweri gambira shilii shashilawiriti mushipindi sha Nuhu. ");
INSERT INTO poy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mumashaka galii pamberi pa wantu kuhowa mumafuriku waweriti wankuliya na kulanda, wantu waweriti wankuwayuga na kuyugwa mpaka Nuhu pakingiriti mumtumbwi, ");
INSERT INTO poy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","wavimaniti ndiri hashilawiri shishi mpaka mafuliku pagiziti na kuwajola woseri. Ntambu ayi hayiweri pakiza Mwana gwa Muntu. ");
INSERT INTO poy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Shipindi ashi wantu wawili hawaweri mulirambu, yumu hakatolwi na yumonga hakalekwi. ");
INSERT INTO poy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wadala wawili hawaweri wankusyaga usaka palwala, yumu hakatolwi na yumonga hakalekwi. ");
INSERT INTO poy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Su gulikali weri, toziya guvimana ndiri lishaka lya kwiza Mtuwa gwenu. ");
INSERT INTO poy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Handa yakana numba mekavimani shipindi sha kwiza kwa mpoka, mekalikali masu na mekaleki ndiri mpoka kabomolangi numba yakuwi. ");
INSERT INTO poy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Su na mwenga viraa muweri kala, toziya Mwana gwa Muntu hakizi mulisaa lyagulimana ndiri.” ");
INSERT INTO poy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Yesu kendeleyiti kutakula, Ndo gaa ntumintumi yakaaminika na kana luhala, ndo mtuwa gwakuwi hakamtuli pampindi pa wantu wakuwi, kawapanani shiboga kwa shipindi shakuwi? ");
INSERT INTO poy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mbaka ntumintumi uliya mweni mtuwa gwakuwi pakiza hakamwoni kankutenda hangu. ");
INSERT INTO poy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nukugambirani nakaka, katamtula ntumini ayu kagolokeri ulunda wakuwi woseri. ");
INSERT INTO poy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kumbiti handa ndo ntumintumi kadoda, hakaligambiziyi mweni kuwera mtuwa gwakuwi hakashelewi kuwuya, ");
INSERT INTO poy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na hakanji kuwakomanga wantumintumi wayaguwi na kanja kuliya na kulanda pamuhera na waloweru. ");
INSERT INTO poy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Shakapanu mtuwa gwakuwi ntumintumi ulii pakizaku lishaka lyankali kulimana na shipindi shakashimana ndiri. ");
INSERT INTO poy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mtuwa hakamwazibu nentu na kumtula shipinga shimu na wafyangu. Aku hakalili na kugayagaya menu gakuwi.” ");
INSERT INTO poy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Shipindi ashi Ufalumi wa kumpindi ulifana hangu. Kuweriti na walii lilongu yawatoliti koloboyi zawu na wagenditi kumwanka mpalu gwa ndowa. ");
INSERT INTO poy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Wamuhanu wamu waweriti na mahala na wamuhanu wamonga waweriti wazigizigi. ");
INSERT INTO poy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Wazigizigi walii watoliti koloboyi zyawu pota kutola mafuta ga motu ga shigubukiru. ");
INSERT INTO poy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kumbiti wanaluhala walii watoliti mafuta ga motu gatosha msupa zyawu. ");
INSERT INTO poy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mpalu gwa ndowa kakawiti kwiza, su walii woseri wanjiti kusizira na wagonjiti. ");
INSERT INTO poy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Paiweriti kala lugonu kuweriti mashowanganu, ‘Aya aya mpalu gwa ndowa! Mgendi mwakamwanki!’ ");
INSERT INTO poy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Walii lilongu walii wimuka na wazitandira koloboyi zyawu. ");
INSERT INTO poy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Shakapanu wazigizigi walii wawagambira wanaluhala walii, ‘Mtupungulili mafuta ga motu, toziya koloboyi zya twenga zankugenda kutenda tiya.’ ");
INSERT INTO poy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Wanaluhala walii wawankula, ‘Ndala, toziya mafuta ga motu gatutosha ndiri twenga pamuhera na mwenga. Mgendi kuvikolija mwakahemeri maweni.’ ");
INSERT INTO poy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Su walii wazigizigi walii pawagenditi kuhemera mafuta ga motu, mpalu gwa ndowa kasoka. Na walii wamuhanu walii yawaweriti kala wingiriti pamuhera na mpalu gwa ndowa mnumba ya msambu na shakapanu mlyangu gutatwa. ");
INSERT INTO poy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Shakapanu walii wamonga walii wawuya. Su womberi wabotanga, ‘Mtuwa, mtuwa! Gutuvuguliri mlyangu!’ ");
INSERT INTO poy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nayomberi hakawankuli, ‘Ndala, nuwamana ndiri mwenga!’ ” ");
INSERT INTO poy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Na Yesu kamalaliriti kwa kutakula, “Mlikali weri, toziya muvimana ndiri lishaka ama lisaa.” ");
INSERT INTO poy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Shipindi shilii Ufalumi wa Mlungu haulifani hangu. Kweniti muntu yumu yakafiriti kugenda mwanja, kawashema wantumintumi wakuwi na kawatula waloleri ulunda wakuwi. ");
INSERT INTO poy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kamupiti kila muntu kulawirana na uwezu wakuwi, yumu kamupiti mihaku muhanu ya mpiya na yumonga kamupiti mihaku miwili ya mpiya na yumonga kamupiti muhaku gumu gwa mpiya. Su kawuka kagenda mwanja. ");
INSERT INTO poy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ntumintumi yakawankiti mihaku muhanu ya mpiya kazitendera lihengu mpiya zilii kapata mota mihaku muhanu imonga. ");
INSERT INTO poy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ntambu iraa ayi ntumintumi yakawankiti mihaku miwili ya mpiya kapatiti mota mihaku imonga miwili ya mpiya. ");
INSERT INTO poy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kumbiti ntumini yakawankiti muhaku gumu gwa mpiya kagutula, kagenda kabawa lirindi mulitapaka, kazififa mpiya zya Mtuwa gwakuwi. ");
INSERT INTO poy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pashipindi shivuwa mtuwa gwa wantumintumi woseri kawuyiti na kutenda mawalanga pamuhera nawomberi. ");
INSERT INTO poy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ntumintumi yakatoliti mihaku muhanu ya mpiya kiza kajega mihaku imonga ya mpiya. Kalonga, ‘Mtuwa guloli!’ Gunupiti mihaku muhanu ya mpiya, panu kwana mihaku muhanu imonga yaiyongelekiti. ");
INSERT INTO poy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mtuwa kalonga, ‘Gutenda weri, gwenga gwamuheri na ntumintumi gwaminika! Guwera mwaminika mushitwatira shididiki, su hanikutuli guloleri vitwatira vikulu. Gwizi tunemeleli pamuhera!’ ");
INSERT INTO poy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Shakapanu ntumini yakawankiti mihaku miwili ya mpiya kiziti na kulonga, ‘Mtuwa, gunupiti mihaku miwili ya mpiya. Guloli! Panu pana mihaku miwili imonga yaiyongelekiti.’ ");
INSERT INTO poy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mtuwa gwakuwi kalonga, ‘Gutenda weri, gwenga gwamuheri na ntumintumi mwaminika!’ Gwenga gwaminika mushitwatila shididiki, hanukutuli guloleri vitwatira vikulu. Gwizi panu tunemeleli pamuhera! ");
INSERT INTO poy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Shakapanu ntumintumi yakawankiti muhaku gumu gwa mpiya kiza na kulonga, ‘Mtuwa, nuvimana kuwera gwenga gwa muntu gukalipa, gubena shilii shaguyala ndiri na gujonjonira vyagukwetiti ndiri. ");
INSERT INTO poy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ntiriti, su ng'enditi na nugufifa muhaku gwa mpiya zyaku.’ ");
INSERT INTO poy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mtuwa gwakuwi kamgambira, ‘Gwenga gwa ntumintumi mdoda na mleri! Guvimana handa neni mbena pota na kuyala na njojinira pota na kukweta. ");
INSERT INTO poy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Sawa, ifiruwitwi gutuli mpiya ya neni mubenki na neni mentoliti mpiya zyangu pamuhera na mbotu yakuwi! ");
INSERT INTO poy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vinu, mumpoki mpiya azi mumpanani ulii yakana mihaku lilongu ya mpiya. ");
INSERT INTO poy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Toziya muntu yoseri yakawera na shintu hawamupanani na kumwongera, kumbiti ulii yakahera shintu, ata shididini shilii shakaweriti nashu hawampoki. ");
INSERT INTO poy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na kuusu ntumintumi ulii yakahera mana, mumwasi kunja muntiti, aku hakalili na kuyagaya menu gakuwi.’” ");
INSERT INTO poy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mwana gwa Muntu ndomweni Mfalumi pakiza muukwisa wakuwi pamuhera na wantumintumi wa kumpindi wakuwi wananagala, hakalivagi mushibanta shakuwi sha shifalumi muukwisa wakuwi. ");
INSERT INTO poy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Wantu wa isi zoseri hawajojiniki kulongolu kwakuwi. Na yomberi hakawatuli muvipinga viwili, gambira mlolera mifugu ntambu yakawatulaga gweka wakondolu kulawa mushipinga sha wambuzi. ");
INSERT INTO poy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hakawatuli wantu yawatenda ntambu yakafiriti Mlungu uwega wakuwi wa kumliwu na yawatenditi vidoda uwega wakuwi wa kumshigi. ");
INSERT INTO poy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Shakapanu Mfalumi hakawagambiri wantu walii wa uwega wakuwi wa kumliwu, Mwizi, mwenga mtekeleritwi na Tati gwangu! Mwizi na muwuwanki ufalumi yawakutandirani kwanjira pakunyawa pasipanu. ");
INSERT INTO poy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pahweriti na njala mwenga munupiti shiboga, panyumuluwiti mwenga mnupiti mashi, nweriti muhenga mwenga mshemera ukaya kwenu, ");
INSERT INTO poy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nweriti shivula hera munvalasiya, nweriti ndwala mwenga munwaziya, nweriti wantatira mushibetubetu mwenga mwiza kutyangira.” ");
INSERT INTO poy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Shakapanu wantu yawamfiriziya Mlungu hamwankuli, ‘Mtuwa, tukuwona koshi gwana njala na twenga tukupiti shiboga, ama guweriti guyumuluwa na twenga tukulandasiya mashi? ");
INSERT INTO poy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ndii tukuwoniti gwamuhenga na twenga tukushemera ukaya, ama gwashivula na twenga tukuvalasiya? ");
INSERT INTO poy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tukuwoniti ndii gulwala ama gwamushibetubetu na twenga twiza kukulola?’ ");
INSERT INTO poy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mfalumi hakawankuli, ‘Nukugambirani nakaka, kila shintu shammutendiriti yumu gwa wapusu wangu awa muntendera neni!’ ");
INSERT INTO poy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Shakapanu hakawagambiri walii yawaweriti uwega wa kumshigi, ‘Muwuki kulongolu kwa neni, mwenga mpangirwiti na Mlungu! Mgendi mumotu gwa gutenda tiya ndiri gwawamtandiriti Shetani na wantumintumi wakuwi! ");
INSERT INTO poy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nweriti na njala, mwenga mnupa ndiri shiboga, nweriti nyumluwa, mwenga mnupa ndiri mashi. ");
INSERT INTO poy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nweriti namuhenga, mwenga munshemiriti ndiri ukaya kwenu, nweriti shivula hera, mwenga munvalasiya ndiri, nweriti ndwaliti na wantatira mushibetubetu, mwenga mwiza ndiri kuntyangira.’ ");
INSERT INTO poy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Shakapanu wamwankula, ‘Ndii, Mtuwa, tukuwoniti gwana njala ama guyumluwa, na gwamuhenga ama gwashivula ama gulwala ama gwamushibetubetu, na twenga twiza ndiri kukutanga?’ ");
INSERT INTO poy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mfalumi hakawankuli, ‘Nuwagambirani, kila pamlemiti kumtanga yumu gwa wapusu awa, mlemiti kuntanga neni.’ ");
INSERT INTO poy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Shakapanu womberi, hawagendi muntabiku ya mashaka goseri, kumbuti wantu yawamfiriziya Mlungu hawagendi muukomu wa mashaka goseri.” ");
INSERT INTO poy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Shipindi Yesu pakamalariti kufunda vitwatira vyoseri avi, kawagambiriti wafundwa wakuwi, ");
INSERT INTO poy_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Pamashaka mawili muvimana, hapaweri na msambu gwa Pasaka, na Mwana gwa Muntu hawamkamuli su wampingiki mulupingika.” Msambu gwa Pasaka guweriti gwa kulihola ntambu Waisraeli pawawalopoziya kulawa muufalumi wa Farawu. ");
INSERT INTO poy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Shakapanu watambika wakulu pamuhera na wazewi waliwoniti pamuhera muukumbi wa Kayafa, Mkulu gwa Watambika. ");
INSERT INTO poy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Wasakuliti ntambu ya kumkamula Yesu kwa bada su wamlagi. ");
INSERT INTO poy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Womberi watakuliti, “Shitwatira ashi nashitendeka shipindi sha msambu gwa Pasaka toziya wantu hawatendi ndewu.” ");
INSERT INTO poy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu kaweriti Betaniya, ukaya kwa Simoni, muntu yakalwaliti ungumbula. ");
INSERT INTO poy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesu pakaweriti kankuliya shiboga, mdala yumu kamgenderiti pakaweriti na supa ya alabasta yayimemiti utuli wa mpiya zivuwa, kammiminira mumtuwi mwakuwi. ");
INSERT INTO poy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wafundwa wakuwi pawawoniti hangu, wakalala na wamkosiya, “Iwera ashi kwananga goseri aga?” ");
INSERT INTO poy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Utuli awu meuwuzwi kwa mpiya zivuwa na kuwapanani wahushu!” ");
INSERT INTO poy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu kavimati shawashiyowera su kawagambira, “Iwera ashi mwankumgaziya mdala ayu? Shakantendiriti ndo shiherepa kwaneni. ");
INSERT INTO poy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wantu wahushu mwanawu mashaka goseri, kumbuti neni hapeni hweri na mwenga mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Shakatenditi mdala ayu kumiminira utuli awu munshimba mwangu su katandira kusilwa kwaneni. ");
INSERT INTO poy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Vinu nuwagambirani nakaka, poseri pawabwera Shisoweru Shiwagira pasi panu, shitwatira shakatenditi mdala ayu hashitakulwi, na wantu hawamuholi.” ");
INSERT INTO poy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Shakapanu yumu gwa wantumintumi lilongu na wawili, litawu lyakuwi Yuda Isikariyoti su kagenda kwa watambika wakulu ");
INSERT INTO poy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na kawakosiyiti, “Hamnupi shishi handa panumgalambuki Yesu kwa mwenga?” Womberi wamuwalangiriti magwala ga shaba malongu matatu na kumupa. ");
INSERT INTO poy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Na kwanjira shipindi shilii Yuda kaweriti kankusakula lupenyu luherepa lwa kumgalambuka Yesu kwa womberi. ");
INSERT INTO poy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lishaka lya kwanja pamberi pa msambu gwa mabumunda galekerwa ndiri simika, wafundwa wamgenderiti Yesu na kumkosiya, “Gufira twakakutandiri koshi shiboga sha Pasaka?” ");
INSERT INTO poy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu kawagambira, “Mgendi mlushi kwa muntu yumu ayu mwakamgambiri, ‘Mfunda kalonga, Shipindi shangu shisoka, handiyi shiboga sha Pasaka pamuhera na wafundwa wangu, ukaya kwaku.’ ” ");
INSERT INTO poy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wafundwa watenda handa Yesu ntambu yakawagambiriti watandiri shiboga sha Pasaka. ");
INSERT INTO poy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Shipindi payiweriti pamihi, Yesu na wantumini wakuwi lilongu na wawili walivaga kuliya shiboga. ");
INSERT INTO poy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pawaweriti wankuliya Yesu kalonga, “Nuwagambirani yumu gwenu hakang'alambuki.” ");
INSERT INTO poy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wantumini wahinginika nentu wanja kulikosiya yumu yumu, “Mtuwa hashi ndo neni?” ");
INSERT INTO poy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu kawankula, “Yakashwika ndolonji mubakuli pamuhera na neni ndo hakang'alambuki. ");
INSERT INTO poy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana gwa Muntu hakahowi gambira Malembu Mananagala ntambu yagatakula, kumbuti oli wakuwi muntu ayu yakamgalambuka Mwana gwa Muntu! Iweri mbaka kwa muntu ayu handa mekayiwuki ndiri!” ");
INSERT INTO poy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda mgalambuka kamkosiya, “mfunda ndo neni?” Yesu kamwankula, “Yina, gwenga ndo gutakula.” ");
INSERT INTO poy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pawaweriti wankuliya, Yesu katoliti libumunda, kalonga mayagashii Mlungu, kalimega na kawapanana wafundwa wakuwi, pakalonga, “Mtoli mlii, ayi ndo nshimba ya neni.” ");
INSERT INTO poy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Shakapanu katola shikombi na kalonga mayagashii Mlungu, kawapanani pakalonga, “Mlandi woseri mwenga, ");
INSERT INTO poy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","agu ndo mwazi gwangu, gwagulanguziya lipatanu lya Mlungu kwa wantu wakuwi, mwazi gwaguyitika kwajili ya wantu wavuwa kuwalekiziya vidoda. ");
INSERT INTO poy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nuwagambirani, hanandi kayi ndiri divayi ya mzyabibu mpaka lishaka lilii pananda divayi yasyayi pamuhera na mwenga Muufalumi wa Tati gwangu.” ");
INSERT INTO poy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Shakapanu womberi wimbiti lwimbu na wawuka wagenditi kulugongu lwa Mizeyituni. ");
INSERT INTO poy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Shakapanu Yesu kawagambira, “Leru pashiru panu mawoseri mwenga hamtugi na kundeka neni, ntambu ya Malembu Mananagala galonga, ‘Mlungu kalonga, hakamlagi mlolera mifugu na wakondolu wa shipinga hawapalanganyiki.’ ");
INSERT INTO poy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kumbiti panzyukaku, hanuwalongoleri kugenda ku Galilaya.” ");
INSERT INTO poy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peteru kamgambira Yesu, “Neni hapeni nukuleki gwenga ata woseri pawakulema!” ");
INSERT INTO poy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu kamgambira Peteru, “Nukugambira, pashiru pamberi njogolu hakeniwiki, hagunemi mala ntatu kuwera gumana ndiri neni.” ");
INSERT INTO poy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peteru kamwankula, “Ata panfiruwa kuhowa pamuhera na gwenga, hapeni nukulemi nakamu!” Na wafundwa wamonga woseri watakula ntambu iraa ayi. ");
INSERT INTO poy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Shakapanu Yesu kagenditi pamuhera na wafundwa wakuwi pahala pawapashemapu Getisemani na kawagambira, “Mulivagi panu neni ng'enda palongolu palii na kuluwa.” ");
INSERT INTO poy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kawatola Peteru na wana wawili wa Zebedayu, kanja kuhinginika na kushashatika, ");
INSERT INTO poy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","na kawagambira womberi, “Moyu guntama nentu sambira nfuwi. Mulivagi panu na mwikali masu pamuhera naneni.” ");
INSERT INTO poy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Su kagenda kulongolu kidogu, kasuntama makukama na kuluwa, “Tati gwangu, handa payiwezekana, guwusiyi nkata ayi ya ndabiri kwaneni! Ntambu yanfira ndiri neni, kumbiti gutendi ntambu yagufira gumweni.” ");
INSERT INTO poy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Shakapanu kawawuyira wafundwa watatu walii na kawawona wagonja mpota na kamgambira Peteru, “Muweza ndiri kulikala masu pamuhera na neni ata lisaa limu? ");
INSERT INTO poy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mlikali masu na mluwi namwingira mumajerwa. Moyu gwa muntu gufira gutenda gakafira Mlungu, kumbiti makakala ga muntu gatosha ndiri.” ");
INSERT INTO poy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu kagenditi kayi na kaluwa, “Tati gwangu, handa payiwezekana ndiri shikombi sha ndabiri shiwuki pota neni kushilanda, su nushirandi, su vyagufiriti guvitendi.” ");
INSERT INTO poy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kawuyiti kayi na kuwawona wantumini wagonja mpota, masu gawu gaweriti gana mbota nentu. ");
INSERT INTO poy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu kawaleka kayi, kagenda zyakuwi na kuluwa mala ya tatu, pakaluwa ntambu iraa ilii. ");
INSERT INTO poy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Shakapanu kawawuyira wafundwa na kuwagambira, “Hashi mwankali mwakugonja mpota na kwoyera? Mloli! Lisaa lyeni lisoka lya Mwana gwa Muntu kukamulwa kwa makakala mumawoku ga wantu yawana vidoda. ");
INSERT INTO poy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mwimuki, tugendeni zyetu. Mloli, panu kwana muntu ulii yakafira kung'alambuka!” ");
INSERT INTO poy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu kaweriti kankali kankutakula shipindi Yuda yumu gwa wantumini lilongu na wawili, pakasokiti. Liziti lipinga likulu lya wantu wavuwa yawawera na mapanga pamuhera na vindonga, womberi watumitwi na watambika wakulu pamuhera na wazewi. ");
INSERT INTO poy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuda kawapiti lipinga lya wantu lilangaliru pakatakula, “Muntu yanumnona ndo yamumfira, su mumkamuli!” ");
INSERT INTO poy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuda kamgendera Yesu na kamlamsiya, “Mfunda, ponga iweri na gwenga, su kamnona.” ");
INSERT INTO poy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu kamgambira, “Ganja gutendi kanongola shagwiziriti!” Wantu walii su wiziti na wamkamula Yesu na wamtawa. ");
INSERT INTO poy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yumu gwa wantumintumi wa Yesu kasomola upanga wakuwi na kamdumula likutu lya ntumintumi gwa Mtambika mkulu. ");
INSERT INTO poy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu kamgambira, “Guwuziyi upanga waku mumuhaku, toziya yoseri yakautendera upanga, hakahowi kwa upanga. ");
INSERT INTO poy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Muvimana ndiri kuwera neni menumluwi Tati gwangu kantangi, nayomberi mekanjegeri majeshi makulu malongu na mawili ga wantumintumi wa kumpindi kuntanga? ");
INSERT INTO poy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kumbiti hagaweri hashi, nakaka Malembu Mananagala gagalembitwi kuwera gafiruwa kulawira?” ");
INSERT INTO poy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Shakapanu Yesu kaligambira lipinga lya wantu, “Iwera hashi munizira na mapanga na vindonga kunkamula gambira neni mkwapula? Kila lishaka nweriti Mnumba nkulu ya Mlungu panfunda na munkamula ndiri. ");
INSERT INTO poy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kumbiti goseri aga galawira su Malembu Mananagala ga wambuyi wa Mlungu gatendeki.” Shakapanu wafundwa woseri wamleka su watuga. ");
INSERT INTO poy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wantu awa yawamkamuliti Yesu wamjegeriti kunumba kwa Kayafa, Mtambika mkulu, wamjojinikira wafunda wa Malagaliru na wazewi. ");
INSERT INTO poy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peteru kamfwatiti kwa kutali mpaka kuluwaga lwa Mtambika mkulu na kingiriti kuzyetu pakutozera kalivaga pamuhera na walolera mlyangu, su kapati kulola vitwatira ntambu yaviwera. ");
INSERT INTO poy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Watambika wakulu na shiyotera motu shoseri sha Wayawudi, shisakuliti upitawu wa kupaya kuusu Yesu wapati kumlaga, ");
INSERT INTO poy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kumbiti wantu wavuwa watakuliti ukapitawu wa upayira kuusu yomberi. Pamuhera na hangu wapata ndiri shintu shoseri. Lupeleru wiziti wantu wawili ");
INSERT INTO poy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na walonga, “Muntu ayu katakuriti, ‘Weza kubomolanga Numba nkulu ya Mlungu na hanyawi kwa mashaka matatu.’ ” ");
INSERT INTO poy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mtambika mkulu kagoloka na kamgambira Yesu, “Hashi, guwawankula ndiri wantu awa wakutakulira shishi gwenga?” ");
INSERT INTO poy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kumbiti Yesu kanyamala jii. Mtambika mkulu kamgambira kayi, “Nukulapira kwa Mlungu mkomu, gutugambiri handa gwenga ndo gwa Kristu Mlopoziya, Mwana gwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu kamwankula, “Yina, gwenga gutakula. Kumbiti nuwagambirani mwawoseri mwenga, kwanjira shipindi ashi hamumwoni Mwana gwa Muntu kalivaga uwega wa kumliwu wa Mlungu yakawera na makakala goseri na pakiza mumawundi ga kumpindi!” ");
INSERT INTO poy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Panu Mtambika mkulu kapapula nguwu yakuwi na katakula, “Kamuhigilanga Mlungu! Tufira ndiri ukapitawu umonga! Vinu mpikanira mayigiranga gakuwi! ");
INSERT INTO poy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mwenga mulihola hashi?” Womberi wamwankula, “Kana makosa su kafiruwa kahowi.” ");
INSERT INTO poy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Shakapanu wamtemera mata kusheni na wamkoma na womberi wamuwakula. ");
INSERT INTO poy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Na walonga, “Kristu gututungiri! Ndo gaa yakakuwakuliti!” ");
INSERT INTO poy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peteru kaweriti kalivagiti kunja kuzyetu ntumini mdala pakamgenderiti na kulonga “Gwenga guweriti pamuhera na Yesu gwa Galilaya.” ");
INSERT INTO poy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kumbiti Peteru kabera palongolu pa woseri. Kalonga, “Nuvimana ndiri vintu vyagutakula.” ");
INSERT INTO poy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pakaweriti kankulawa pamlyangu gwa kuzyetu, ntumini mdala yumonga kamwona Peteru na kawagambira wantu yawaweriti paliya, “Muntu ayu kaweriti pamuhera na Yesu gwa Nazareti.” ");
INSERT INTO poy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peteru kabera kayi na kuwankula, “Nulirapa kuwera nummana ndiri muntu ayu!” ");
INSERT INTO poy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Katepu hera wantu yawaweriti wagoloka paliya wamgenderiti Peteru na watakula, “Nakaka ntambu yagutakula ilanguziya gwenga gwa muntu wa Galilaya!” ");
INSERT INTO poy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Shakapanu Peteru kalonga, “Nulirapa kuwera nuwagambirani nakaka! Mlungu gwangu kanazibu handa neni panuwapayira! Nummana ndiri muntu ayu!” Katepu njogolu kaweka, ");
INSERT INTO poy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","na Peteru kaliholiti visoweru vyakagambiritwi na Yesu, “Pamberi pa njogolu keniwiki, hagunemi mala ntatu kuwera gumana ndiri neni.” Kalawa kunja na kagenda kulila nentu. ");
INSERT INTO poy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mandawira putiputi watambika wakulu woseri na wazewi waliwoniti pamuhera watenditi mpangu gwa kumlaga Yesu. ");
INSERT INTO poy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Womberi wamtawa pingu na wamjega kwa Pilatu mkulu gwa mkowa yakasyagulitwi na mlongoziya gwa sirikali ya Rumi. ");
INSERT INTO poy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yuda mgalambuka, pakawoniti kuwera Yesu wamtoza kala, yomberi moyu gumtamiti nentu na kawawuzilira watambika wakulu pamuhera na wazewi magwala malongu matatu galii ga mpiya. ");
INSERT INTO poy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kalonga, “Neni ntenda vidoda kwa kumgalambuka muntu yakahera likosa, wamlagi!” Womberi wamwankula, “Gatuwusu shishi twenga? Aga ndo gaku gumweni!” ");
INSERT INTO poy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuda kaziyasa mpiya zilii Mnumba nkulu ya Mlungu, kalawa kunja kagenda kulilaga mulugoyi. ");
INSERT INTO poy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Watambika wakulu wazitola mpiya zilii na walonga, “Azi ndo mpiya zya mwazi na ifaa ndiri kuzitula mluhanja lwa Numba nkulu ya Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pawajimilirana kala kuusu mpiya azi, womberi wazitumiya kuhemera lirambu lya ukaka, liweri pahala pa kusilira wahenga. ");
INSERT INTO poy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ndo mana mpaka leru lirambu ali walishema, “Lirambu lya Mwazi.” ");
INSERT INTO poy_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Su visoweru vyakatakuliti Yeremiya mbuyi gwa Mlungu vitendeki, “Watoliti magwala malongu matatu ga mpiya, shyasi sha wantu wa Israeli wapangiti kumlipira yomberi, ");
INSERT INTO poy_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na wahemelera lirambu la ukaka, Mtuwa ntambu yakanagaliriti.” ");
INSERT INTO poy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu wamgolosiyiti palongolu pa mkulu gwa mkowa, ndomweni yakamkosiyiti. Su Pilatu kamkosiya, “Hashi, gwenga ndo mfalumi gwa Wayawudi?” Yesu kamwankula, “Gwenga gulonga.” ");
INSERT INTO poy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kumbiti Yesu kankula ndiri shintu, watambika wakulu na wazewi pawaweriti wankumsitaki. ");
INSERT INTO poy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Su Pilatu kamkosiya, “Hashi, gupikinira ndiri masitaka goseri aga gawalaviya kwa gwenga?” ");
INSERT INTO poy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kumbiti Yesu kawankula ndiri ata shisoweru shimu, ata mkulu gwa mkowa ayu kalikangasha nentu. ");
INSERT INTO poy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Iweriti shitiba shawu mushipindi sha msambu gwa Pasaka mkulu gwa mkowa kumvugulira mtatirwa yumu yawamfiriti. ");
INSERT INTO poy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Shipindi ashi kuweriti na muntu yumu yakamanikaniti nentu yawamtatiriti mushibetubetu litawu lyakuwi Baraba. ");
INSERT INTO poy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Su wantu pawaliwoniti pamuhera, Pilatu kawakosiya, “Mfira numulaviyi yoshi pakati pa awili awa, Baraba ama Yesu yawamshema Kristu Mlopoziya?” ");
INSERT INTO poy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yomberi kavimaniti weri kuwera walongoziya wa Shiyawudi wamjegiti Yesu kwakuwi kwajili ya weya. ");
INSERT INTO poy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatu pakaweriti kalivaga pashigoda sha kutoza, mdala gwakuwi kamjegeriti ujumbi, “Naguliyingiziya mulisitaka lya muntu ayu muheri, toziya leru ntabika nentu mukulota kuusu yomberi.” ");
INSERT INTO poy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Watambika wakulu na wazewi waligambiriti lipinga lya wantu wamluwi Baraba wamvuguliri na Yesu wamlagi. ");
INSERT INTO poy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kumbiti Pilatu kalikosiya lipinga lya wantu, “Hashi, yoshi pakati pa wawili awa yamfira nukuvugulirani?” Womberi wamwankula, “Baraba!” ");
INSERT INTO poy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatu kawakosiya, “Vinu ntendi ashashi kuusu Yesu yawamshema Kristu Mlopoziya?” Woseri wamwankula, “Gumpingiki mulupingika!” ");
INSERT INTO poy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kumbiti Pilatu kakosiya, “Hashi, yomberi katenda likosa gaa?” Shakapanu womberi wanjiti kushowangana, “Wampingiki mlupingika!” ");
INSERT INTO poy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatu pakawoniti kuwera kafanikiwa ndiri shoseri na kwana vidoda viweriti vyankwanja katoliti mashi na kaganaviya mawoku gakuwi palongolu pa lipinga lya wantu na kalonga, “Neni nahera lawama kuhowa kwa muntu ayu. Na shitwatila ashi mtendi maweni.” ");
INSERT INTO poy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Lipinga lyoseri lya wantu limwankula, “Mwazi gwakuwi guweri kwa twenga na kwa wananguta wetu.” ");
INSERT INTO poy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Shakapanu Pilatu kamvugulira Baraba kulawa mushibetubetu, kumbiti Yesu pawamsyatanga kala ntomondu, kamlaviyiti wampingiki mulupingika. ");
INSERT INTO poy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Shakapanu wanjagila wa Pilatu wamtola Yesu wamwingiziya mumakawu makulu ga numba zya wanjagila wa Shirumi na wamjojinikira shipinga shoseri. ");
INSERT INTO poy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wamvula nguwu zyakuwi na wamvalisiya lihabiti lya langi nsheri. ");
INSERT INTO poy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Su wapota lijenjeri lya misontu na wamvalisiya mumtuwi mwakuwi na wamtulira ludenki muliwoku lyakuwi lya kumliwu na wasuntama palongolu pakuwi na wamtendera lijonga. Womberi wamlamsiya, “Mwika Mfalumi gwa Wayawudi.” ");
INSERT INTO poy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wamtemera mata na walutola ludenki lulii na wamkoma nalu mumtuwi. ");
INSERT INTO poy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pawamaliriti kala kumtendera lijonga, wamvula lihabiti lilii na wamvalisiya nguwu zakuwi. Su wamjega yomberi kumpinjika mulupingika. ");
INSERT INTO poy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pawaweriti wankugenda wamwona muntu yumu litawu lyakuwi Simoni yakalawiriti lushi lwa Kureni na wanjagila wamlazimisha kulutola lupingika lwa Yesu. ");
INSERT INTO poy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pawasokiti pahala pawapashema Goligota, mana yakuwi, “Pahala pa vipalakasa vya mtuwi.” ");
INSERT INTO poy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wamupa muhanganu gwa Divayi na mtera gukaripa, kumbuti Yesu pakailawaliriti kalema kulanda. ");
INSERT INTO poy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wampingika mulupingika, shakapanu waligawirana nguwu zyakuwi kwa kugalambula simbi. ");
INSERT INTO poy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pa aga walivaga panu waweriti wankumlolera. ");
INSERT INTO poy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pampindi pa mtuwi gwakuwi mulupingika watula lisitaka limwusu yomberi lyawalembiti, “Ayu ndo Yesu, Mfalumi gwa Wayawudi.” ");
INSERT INTO poy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Shakapanu wawapingika wakwepula wawili pamuhera na Yesu, yumu uwega wa kumshigi kwakuwi na yumonga uwega wa kumliwu kwakuwi. ");
INSERT INTO poy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wantu yawaweriti wankupita pahala paliya wamwigilanga Yesu na kutikisiya mituwi yawu pawalonga, ");
INSERT INTO poy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Gwenga gulitumbiti kuyibomolanga Numba nkulu ya Mlungu na kuinyawa kwa mashaka matatu! Vinu gulilopoziyi gumweni handa gwenga gwa Mwana gwa Mlungu, su gusuluki palupingika!” ");
INSERT INTO poy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ntambu iraa ayi watambika wakulu na wafunda wa Malagaliru na wazewi wamtendiriti lijonga, ");
INSERT INTO poy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Kawalopoziyiti wamonga, kumbuti kasinda kulipoziya mweni! Hashi, yomberi mfalumi ndiri gwa Israeli? Vinu kasuluki palupingika na twenga hatumjimiri. ");
INSERT INTO poy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kamtumbiliti Mlungu na kutakula eti yomberi ndo Mwana gwa Mlungu. Su tuleki tumloli Mlungu kamlopoziyi handa kamfira nakaka!” ");
INSERT INTO poy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ntambu iraa ayi na wakwepula walii yawawapingikiti pamuhera na Yesu wamuhigiranga viraa. ");
INSERT INTO poy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kwanjira saa sita mpaka saa tisa paliwala, pasipanu poseri paweriti na ntiti masaa matatu. ");
INSERT INTO poy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Payiweriti saa tisa Yesu kalira kwa liziwu likulu, “Eloyi, Eloyi lama sabakitani?” Mana yakuwi, “Mlungu gwangu, Mlungu gwangu iwera ashi gundeka?” ");
INSERT INTO poy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wantu wamu yawagolokiti palii pawapikaniriti hangu, walonga, “Kankumshema Eliya!” ");
INSERT INTO poy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yumu gwawu katuga katola lidodoki, kalijwika mudivayi isheshema, kayitula mulupeleru lwa ludenki na wajera kumupa yomberi kalandi. ");
INSERT INTO poy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kumbiti wamonga walonga, “Guheperi, tuloli handa Eliya kankwiza kumlopoziya!” ");
INSERT INTO poy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu kalira kayi kwa liziwu likulu, su kahowa. ");
INSERT INTO poy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Shakapanu lipaziya lya Numba nkulu ya Mlungu lyalilekaniziya pahala pananagala nentu, lidegeka vipandi viwili kulawa kunani mpaka pasi. Pasipanu pabegiziwa na matalawu gapantika, ");
INSERT INTO poy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","na mapumba gagubutuka na wantu wa Mlungu wavuwa yawahowiti wawazyukusiwa. ");
INSERT INTO poy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Womberi walawa mumapumba na Yesu pakazyukiti kala kulawa kwa wahowiti, womberi wagenditi Yerusalemu lushi lunanagala, wawonikaniti na wantu wavuwa. ");
INSERT INTO poy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mkulu gwa wawanjagila na wanjagila yawaweriti wankumlolera Yesu, wawoniti kubegiziwa pasipanu na vitwatira vyoseri vyavilawiriti, watiriti nentu na walonga, “Nakaka muntu ayu kaweriti Mwana gwa Mlungu!” ");
INSERT INTO poy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kuweriti na wadala wavuwa palii, pawalola kwa kutali. Wadala awa ndo walii yawamfatiti Yesu kulawa Galilaya na wamtangiti. ");
INSERT INTO poy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pakati pawu paweriti Mariya Magidalena na Mariya mawu gwa Yakobu na mlongu gwakuwi yawamshema Yosefu, pamuhera na mdala gwa Zebedayu. ");
INSERT INTO poy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Payiweriti pamihi, kiziti muntu yumu kalunda mwenikaya gwa Arimatayu litawu lyakuwi Yosefu na yomberi kaweriti mfundwa gwa Yesu. ");
INSERT INTO poy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kamgenderiti Pilatu na kaluwa mawuti ga Yesu. Pilatu kalagalira wamupi Yosefu mawuti galii. ");
INSERT INTO poy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Su Yosefu katola mawuti galii, kagatindiziya sanda iherepa, ");
INSERT INTO poy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","na Kagatula mulipumba lya mpanga lyakuwi, lyakalisongoliti palitalawu. Su kalibiringa litalawu likulu pamlyangu gwa lipumba na kagenda zyakuwi. ");
INSERT INTO poy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariya Magidalena na Mariya gwingi ulii yawaweriti walivaga palii pawalola lipumba. ");
INSERT INTO poy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Shirawu yakuwi, lishaka lya Kwoyera, watambika wakulu na Mafalisayu wamgendiriti Pilatu, ");
INSERT INTO poy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","na walonga, “Mtuwa, tulihola kuwera mpayu ulii katakuliti pamberi pa kuhowa kwakuwi kalongiti, ‘Pa mashaka matatu hanzyuki.’ ");
INSERT INTO poy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Su gulagaliri lipumba lyakuwi waliloleri weri mpaka lishaka lya tatu, su wafundwa wakuwi hapeni wawezi kwiza kugatola mauti gakuwi na kuwagambira wantu kuwera kazyuka. Kupayira aku hakuweri kudoda kuliku kupayira kwa kwanja.” ");
INSERT INTO poy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatu kawagambira, “Muwatoli walolera, mgendi na kulolera lipumba ntambu yamuweza.” ");
INSERT INTO poy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Su wagenda na kulolera lipumba walimatira litalawu na kuwaleka wanjagila waloleri. ");
INSERT INTO poy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Palipititi lishaka lya Kwoyera, mandawira putiputi lishaka lya jumapili, Mariya Magidalena na Mariya yumonga ulii, wagenditi kulilola lipumba. ");
INSERT INTO poy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Palaa palii kulawira kutikinyika kukulu kwa isi, ntumintumi gwa kupindi gwa Mtuwa kiziti kulawa kumpindi, kalibiringisiya libuwi lilii na kalivagira. ");
INSERT INTO poy_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kawonikaniti gambira umemi na nguwu zyakuwi ziweriti neru mbuu. ");
INSERT INTO poy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Walolera lipumba waweriti na lyoga likulu ata wawera gambira wantu yawahowa. ");
INSERT INTO poy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ntumintumi gwa kumpindi kawagambira wadala walii, “Namtira mwenga! Nuvimana kuwera mwankumsakula Yesu yawampingikiti. ");
INSERT INTO poy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kwahera panu, toziya Kazyuka ntambu yakalongiti. Mwizi mloli pahala pawamtuliti. ");
INSERT INTO poy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Su mgendi kanongola vinu na mwakawagambiri wafundwa wakuwi, ‘Kazyuka kulawa kwawahowiti na kankuwalongolera kugenda ku Galilaya, aku hamumuwoni yomberi!’ Muliholi shanuwagambirani.” ");
INSERT INTO poy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wadala awa walawiti kanongola mulipumba, watuga kugenda kuwagambira wafundwa wakuwi, pawawera na lyoga na nemeleru nkulu. ");
INSERT INTO poy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Vumu Yesu kaliwona nawomberi na kuwagambira, “Mwakashina?” Womberi wamwizira na kumsuntamalira pamagulu gakuwi na wamguwira. ");
INSERT INTO poy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu kawagambira “Namtira! Mgendi mwakawagambiri walongu wangu wagendi Galilaya, aku hawamoni.” ");
INSERT INTO poy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wadala walii pawaweriti wankugenda zawu, walolera wamu wa lipumba wagenditi mlushi kuwagambira watambika wakulu wa numba ya Mlungu kuusu vitwatira vyoseri vyavilawiliti. ");
INSERT INTO poy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Su waliwona pamuhera na wazewi watenda mpangu, wawapanani wanjagila walii mpiya zivuwa nentu ");
INSERT INTO poy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na wawagambira, “Mwenga mtakuli kuwera wafundwa wakuwi wiziti pashiru wawiwa mawuti gakuwi twenga patugonjiti. ");
INSERT INTO poy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na mkulu gwa mkowa pakavimana visoweru avi, twenga hatuyoweri nayu na mwenga hapeni mpati matatizu. ");
INSERT INTO poy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Walolera lipumba walii wazitola mpiya na watenda shilii shawawagambira watendi. Shisoweru ashi sheneyiti kwa wayawudi mpaka leru. ");
INSERT INTO poy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","“Wafundwa lilongu na yumu wagenditi Galilaya pahala Yesu pakawagambiriti wagendi. ");
INSERT INTO poy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Womberi pawamwoniti Yesu wamguwira, tembera wamonga waweriti na lyoga.” ");
INSERT INTO poy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu kiziti pakwegera na kawagambira, “Wanupa uwezu woseri kumpindi na pasipanu. ");
INSERT INTO poy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Su mgendi kwa wantu wa makabila goseri kila pahala na muwatendi waweri wafundwa wangu, muwabatizi mulitawu lya Tati na Mwana na Rohu Mnanagala, ");
INSERT INTO poy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","na muwafundi womberi kujimila kila shintu shanuwalagalira mwenga. Na neni hanweri na mwenga mashaka goseri mpaka kupelera kwa pasipanu.”");
INSERT INTO poy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Shisoweru Shiwagira ashi sha Yesu Kristu, Mwana gwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yankuyanja gambira Isaya mbuyi gwa Mlungu ntambu yakalembiti, “Mlungu kalongiti, ‘Guloli numtuma ntumintumi gwangu hakakulonguleri Hakakunywawili njira yaku.’ ");
INSERT INTO poy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Liziwu lya muntu lipikanika kushiwala, ‘Mumtenderi kala Mtuwa njira yakuwi, mumnyawili weri njira zyakuwi!’ ” ");
INSERT INTO poy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohani kalawiriti kushiwala, kawabwelera wantu na kuwabatiza, pakawagambira, “Mleki vidoda vyenu na mbatizwi na Mlungu hakawalekiziyi vidoda vyenu.” ");
INSERT INTO poy_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wantu wavuwa wamgenderiti Yohani, wantu yawalawiti Yerusalemu na Yudeya, walekiti vidoda vyawatenditi na yomberi kawabatiziti mulushemba lwa Yoridani. ");
INSERT INTO poy_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohani kavaliti nguwu yayinyawitwi kwa mibaira ya nkanyama ngamiya, mushunu kalitawiti lugoyi lwa lukuli na shiboga shakuwi shiweriti lwashi na wanjombi. ");
INSERT INTO poy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohani kabweriti pakalonga, “Pa neni kankwiza muntu mkulu kuliku neni. Neni nfaa ndiri ata kuyopola lugoyi lwa vilwatu vyakuwi. ");
INSERT INTO poy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Neni nukubatizani kwa mashi, kumbiti yomberi hakawabatizani kwa Rohu Mnanagala.” ");
INSERT INTO poy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mashaka galii Yesu kiziti kulawa Nazareti lushi lwa Galilaya na kabatiziwitwi na Yohani mulushemba lwa Yoridani. ");
INSERT INTO poy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pala palii Yesu pakalawiti mumashi, kawona kumpindi kwa Mlungu kuvuguka na Rohu Mnanagala kamkangalira gambira ng'unda. ");
INSERT INTO poy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na liziwu lilawira kumpindi kwa Mlungu, lilonga, “Gwenga gwa Mwana gwangu yanukufira, gunfiriziya.” ");
INSERT INTO poy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pala palii Rohu Mnanagala kamlonguziyiti Yesu kushiwala. ");
INSERT INTO poy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Su kaweriti kushiwala aku mashaka malongu msheshi, pakajeresiwa na Shetani. Kalikaliti aku pamuhera na wankanyama wa kuntundu na wantumintumi wa kumpindi wamtenderiti. ");
INSERT INTO poy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohani pawamtatiriti kala mushibetubetu, Yesu kagenditi lushi lwa Galilaya, kulii kanjiti kubwera Shisoweru Shiwagira sha Mlungu, ");
INSERT INTO poy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","pakalonga, “Shipindi shiza! Ufalumi wa Mlungu wapakwegera. Mleki vidoda vyamtenda na mushijimiri Shisoweru Shiwagira!” ");
INSERT INTO poy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu kaweriti kankupita mumpeku mwa litanda lya Galilaya, kamwona Simoni na Andereya mlongu gwakuwi, womberi waweriti wankulowa wasomba. ");
INSERT INTO poy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu kawagambira, “Munfati neni, hanuwafundi mwenga muweri walowa wantu.” ");
INSERT INTO poy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pala palii wazileka nyavu zyawu na wamfata. ");
INSERT INTO poy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu pakagenditi palongolu padidini, kawawoniti Yakobu na Yohani wana wa Zebedayu walivagiti mumtumbwi wankunyawa nyavu zyawu. ");
INSERT INTO poy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pala palii Yesu kawashema wamfati, womberi wamleka Zebedayu tati gwawu pamuhera na wantumintumi wakuwi mumtumbwi. ");
INSERT INTO poy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na wantumintumi wakuwi wagenditi lushi lwa Kafarinaumu, palifikiti Lishaka lya Kwoyera Yesu kagenditi munumba ya Mlungu na kanja kufunda. ");
INSERT INTO poy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wantu yawampikaniriti Yesu walikangashiti nentu ntambu yakafunditi, toziya kafunditi ndiri gambira wafunda wawu wa Malagaliru ga Musa, kumbiti kafunditi gambira muntu yakawera na uwezu. ");
INSERT INTO poy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Shipindi shilaa shilii kuweriti na muntu yakaweriti na washamshera Munumba ya Mlungu, yomberi kabotanga, ");
INSERT INTO poy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu gwa Nazareti, gwana shishi na twenga? Shagwizira gutwagamiziyi? Neni nukumana kala kuwera gwenga gwa gaa, gwenga gwa Mnanagala gwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu kamkalipira shamshera ulii, “Umatu, gumwuki muntu ayu.” ");
INSERT INTO poy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Shamshera kambegeziya nentu muntu ulii pakabotanga, shakapanu kamlekeziya. ");
INSERT INTO poy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wantu woseri walikangashiti nentu na wanjiti kulikosiya, “Shishi ashi? Aga mafundu ga syayi yagawera na uwezu! Muntu ayu kawera na makakala ga kuwawinga washamshera na womberi wamjimira!” ");
INSERT INTO poy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Su visoweru vyakatenditi Yesu vipikinirika kanongola koseri mumkowa gwa Galilaya. ");
INSERT INTO poy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Palaa palii pawalawiti Munumba ya Mlungu, womberi wagenditi pamuhera na Yakobu na Yohani mpaka ukaya kwa Simoni na Andereya. ");
INSERT INTO poy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pawasokiti palii, womberi wamgambiriti Yesu kuwera mikamwana gwa Simoni kapyupa kagonja mushitanda. ");
INSERT INTO poy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Su Yesu kamgendera mlweri, kamkola liwoku na kumgolosiya, mawu ulii kawera mkomu na kanja kuwatelekera. ");
INSERT INTO poy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pamihi mshenji paguzyetiti, wantu wamjegera Yesu walweli woseri na walii yawaweriti na washamshera. ");
INSERT INTO poy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wantu woseri wa lushi lulii wajojinikiti paluwaga lwa numba. ");
INSERT INTO poy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu kawaponiziyiti wantu wavuwa yawaweriti na malweri ga kila ntambu. Viraa kawawingiti washamshera, kafiriti ndiri washamshera watakuli shintu shoseri toziya waweriti wankumumana. ");
INSERT INTO poy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Shilawu yakuwi ligonugonu, Yesu kalawa kunja kwa lushi na kagenditi pahala pa gweka kumluwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kumbiti Simoni na wayaguwi wagenditi kumsakula. ");
INSERT INTO poy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Na pawamwoniti kala wamgambira, “Kila muntu kankukusakula!” ");
INSERT INTO poy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kumbiti Yesu kawankula, “Tugendeni pahala pamonga pa lushi zyaziwera pakwegera, su neni nwezi kubwera aku viraa toziya ashi ndo shashinjegiti kushitenda.” ");
INSERT INTO poy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Su yomberi kagenda Mugalilaya kwoseri pakabwera mnumba za Mlungu na kuwawinga washamshera. ");
INSERT INTO poy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mungumbula yumu kamgenderiti Yesu kasuntumala na kamluwa, “Pagufira gumweni gumpungi neni.” ");
INSERT INTO poy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu kamwonera lusungu nentu, kamkola liwoku kalonga, “Neni nfira, gupungwi.” ");
INSERT INTO poy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Palaa palii Muntu ungumbula umlekeziya. ");
INSERT INTO poy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Shakapanu Yesu kambereziya muntu ulii, kamlekeziya kagendi zyakuwi ");
INSERT INTO poy_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","pakamgambira, “Nagumgambira muntu yoseri visoweru avi, kumbiti gugendi gwakaliranguziyi kwa mtambika gwa Numba ya Mlungu na gulaviyi malaviwu kwajili ya kupungwa kwaku gambira Musa ntambu yakalagaliriti kuwera ukapitawu kwa woseri kuwera guponiziwa.” ");
INSERT INTO poy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kumbiti muntu ulii kagenda kanja kubwera visoweru vya kuponiziwa kwakuwi kwa kila yakamwona. Su Yesu kasinda kuliyonisiya mulushi lulii, yomberi kalikaliti pahala pa gweka. Pamuhera na hangu wantu waweriti wankumgendera yomberi kulawa wega zoseri. ");
INSERT INTO poy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pa mashaka gavuwa ndiri, Yesu kawuyiti Kafarinaumu, wantu wapikinira handa kawuya ukaya. ");
INSERT INTO poy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wantu wavuwa wajojinikiti palii mpaka paweriti kwahera lupenu mnumba, ata kunja pamlyangu. Nayomberi kaweriti kankuwabwerera shisoweru sha Mlungu. ");
INSERT INTO poy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Su wantu wamu wiziti pawamjega muntu yakalewelekiti, yomberi kapapitwi na wantu wamsheshi. ");
INSERT INTO poy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Toziya wantu waweriti wavuwa, wasinditi kumjega pakwegera na Yesu. Su wabomoliti pashitwiku pahala pakaweriti Yesu. Shapakanu wamsulusiya muntu ulii yakalewelekiti pakawera mumkeka. ");
INSERT INTO poy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu pakawoniti njimiru yawu, kamgambiriti muntu ulii yakalewelekiti, “Mwana gwangu, vidoda vyakuwi vilekiziwa.” ");
INSERT INTO poy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wafunda wamu wa Malagaliru ga Musa waweriti walivaga kweni aku, walihola mumyoyu mwawu, ");
INSERT INTO poy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Iwera ashi muntu ayu kankutakula ntambu ayi? Ayu kankumwigiranga Mlungu! Gani kawezi kulekiziya vidoda? Mlungu gweka yakuwi ndiri?” ");
INSERT INTO poy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pala palii Yesu kashimana shilii shawaliholiti mumyoyu mwawu. Yomberi kawakosiya, “Ashashi mwankulihola hangu mumyoyu mwenu? ");
INSERT INTO poy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Shizotopa ng'anji shii, kumgambira muntu yakalewelekiti, ‘Vidoda vyaku vilekiziwa’ ama kumgambira, ‘Gwimuki, gutoli mkeka gwaku gugendi?’ ");
INSERT INTO poy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Su nfira muvimani kuwera Mwana gwa Muntu kana uwezu gwa kulekiziya vidoda pasipanu.” Shapakanu kamgambira muntu ulii yakalewelekiti, ");
INSERT INTO poy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nukugambira, gugoloki, gutoli mkeka gwaku, gugendi ukaya kwaku!” ");
INSERT INTO poy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yomberi kagoloka, palaa palii kanyasula mkeka gwakuwi kagendagenda pakalolwa na wantu woseri. Woseri walikangasha, wamkwisa Mlungu pawalonga, “Hatweniwoni shintu gambira ashi nakamu!” ");
INSERT INTO poy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu kagenda kayi kumpeku kulitanda lya Galilaya. Lipinga likulu lya wantu limgendera, nayomberi kanja kuwafunda. ");
INSERT INTO poy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pakaweriti kankupita, kamwona Lawi mwana gwa Alifayu, kalivaga mnumba mwa kulipira kodi. Yesu kamgambira, “Gunfati.” Lawi kagoloka, kanfata. ");
INSERT INTO poy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Shakapanu, Yesu kaweriti kankuliya shiboga ukaya kwa Lawi. Watola kodi wavuwa na walii yawawashema wawera na vidoda waweriti wankuliya pamuhera na Yesu na wafundwa wakuwi, toziya kuweriti na wantu wavuwa yawaweriti wankumfata. ");
INSERT INTO poy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wafunda wamu wa Malagaliru ga Musa waweriti shipinga washishema Mafalisayu pawamuwoniti Yesu kankuliya pamuhera na “walii yawawashema wawera na vidoda” na watola kodi, womberi wawakosiya wafundwa wakuwi, “Iwera ashi Yesu kankuliya pamuhera na watola kodi na yawawera na vidoda?” ");
INSERT INTO poy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu pakagapikaniriti aga kawagambira, “Wantu washinashina wamfira ndiri bwana mganga, kumbiti walweli wamfira. Niza ndiri kuwashema wantu yawalihola wankumfiriziya Mlungu, kumbiti niza kuwashema yawawera na vidoda.” ");
INSERT INTO poy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wafundwa wa Yohani Mbatiza na wafundwa wa Mafalisayu waweriti wankufunga kuliya. Wantu wamu wamgendera Yesu na kumkosiya, “Iwera hashi wafundwa wa Yohani Mbatiza na wafundwa wa Mafalisayu wankufunga kuliya, kumbiti wafundwa waku wafunga ndiri kuliya?” ");
INSERT INTO poy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu kawankula, “Wantu pawawera mumsambu gwa ndowa waweza hashi kufunga kuliya shipindi mpalu gwa ndowa kapamuhera nawomberi? Nakaka mpalu gwa ndowa pakawera na womberi hapeni wafungi kuliya. ");
INSERT INTO poy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kumbiti shipindi shankwiza, mpalu gwa ndowa hakawusiwi kwawu, na panu ndo hawafungi kuliya. ");
INSERT INTO poy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Kwahera muntu yakasona shiraka sha nguwu ya syayi mu nguwu ngona. Pakatenda hangu, shiraka sha syayi hashidegi nguwu ngona, na palii papadegekiti pongereka. ");
INSERT INTO poy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na kwahera muntu yakaweza kutula divayi ya syayi muviwiga vigona. Pakatenda hangu, divayi ya syayi hayivipantangi viwiga avi, divayi hayitiki, na viwiga havipantangiki. Kumbiti divayi ya syayi itulwa muviwiga vya syayi.” ");
INSERT INTO poy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lishaka limu lya kwoyera, Yesu pamuhera na wafundwa wakuwi waweriti wankupita mumalambu ga nsaka. Pawaweriti wankupita, wafundwa wakuwi wanjiti kubenanga mikunguwi ya nsaka. ");
INSERT INTO poy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Su Mafalisayu wamgambira Yesu, “Guloli! Iwera ashi wafundwa waku wankutenda shintu shashileweritwi mulishaka lya kwoyera?” ");
INSERT INTO poy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu kawankula, “Hamwebetuli ntambu Dawudi yakatenditi pamuhera na wayaguwi palii pawaweriti na njala na wahera shintu? ");
INSERT INTO poy_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dawudi kingiriti Mnumba ya Mlungu mumashaka galii ga mtambika mkulu Abiyatali. Kaliya mabumunda yagalaviyitwi kwa Mlungu, mabumunda gagalekeziwa ndiri kugaliya kumbiti watambika gweka yawu ndo yawalekeziwitwi kugaliya, Dawudi kagaliyiti na kuwapanana wayaguwi.” ");
INSERT INTO poy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Shapakanu Yesu kawagambira, “Lishaka lya kwoyera walitula kwajili ya wantu, na wantu ndiri kwajili ya lishaka lya kwoyera! ");
INSERT INTO poy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Su Mwana gwa Muntu ndo Mtuwa ata gwa lishaka lya kwoyera.” ");
INSERT INTO poy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Shapakanu Yesu kingira kayi munumba ya Mlungu. Mlii paweriti na muntu yakawera na liwoku lyalilewelekiti. ");
INSERT INTO poy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wantu wamu waweriti wankumlola su wawoni handa hakamponiziyi muntu ulii mulishaka lya kwoyera su wapati toziya ya kumsitaki. ");
INSERT INTO poy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu kamgambira muntu ulii yakaweriti na liwoku lyalilewelekiti, “Gwizi panu.” ");
INSERT INTO poy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Shapakanu Yesu kawakosiya wantu, “Hashi, lyoshi lyaliherepa mulishaka lya kwoyera, kutenda gaherepa ama gadoda? Kumponiziya muntu ama kulaga?” Kumbiti womberi wanyamalira jii. ");
INSERT INTO poy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu kawalola wantu woseri walii kwa maya, kahinginikiti nentu toziya ya ukamala wa myoyu mwawu. Shapakanu kamgambira muntu ulii, “Gunyoshi liwoku lyaku.” Yomberi kanyosha, pala palii liwoku lyakuwi lipona nakamu! ");
INSERT INTO poy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pala palii Mafalisayu walawiti kunja, wanja kusakula ntambu ya kumlaga Yesu, womberi pawawera na shipinga sha wantu wa Herodi. ");
INSERT INTO poy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu pamuhera na wafundwa wakuwi uganu na wagenditi kulitanda lya Galilaya, na lipinga lya wantu limfatiti kulawa Galilaya mkowa gwa Yudeya. ");
INSERT INTO poy_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Viraa virii Yerusalemu na mumikowa ya Idumeya na kumwambu kwa lushemba Yoridani na lushi lwa Tiru na Sidoni. Lipinga lya wantu awa wavuwa wamgenderiti Yesu toziya wavipikiniriti vitwatira vivuwa vyakatenditi. ");
INSERT INTO poy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Toziya lipinga lya wantu lyaliweriti likulu, Yesu kawagambira wafundwa wakuwi wamtuliri mtumbwi, su wantu nawambabanika. ");
INSERT INTO poy_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kawaponiziyiti walweli wavuwa, walii yawawera na malweli waweriti wankumbabanika su wapati kumshinkula. ");
INSERT INTO poy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kila mala washamshera pawamwoniti Yesu, waguwiti pasi kulongolu kwakuwi na wagutanga pawalonga, “Gwenga gwa Mwana gwa Mlungu!” ");
INSERT INTO poy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kumbiti Yesu kawakaripiriti nentu washamshera walii nawalonga kuwera mweni ndo gaa. ");
INSERT INTO poy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Shapakanu Yesu kakweniti kulugongu, kawashema walii yakawafiriti mweni, nawomberi wamgendera. ");
INSERT INTO poy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kawasyagula wantu lilongu na awili viraa kawashema wantumintumi, su wapati kuwera pamuhera na yomberi na su kapati kuwatuma wagendi kuwabwelera wantu ");
INSERT INTO poy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na waweri na uwezu wa kuwalaviya washamshera. ");
INSERT INTO poy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Awa ndo wantu lilongu na awili yakawasyaguliti, Simoni, Yesu kamupananiti litawu Peteru na ");
INSERT INTO poy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobu na Yohani mlongu gwakuwi, woseri wana wa Zebedayu, Yesu kawashema Bowanerigi, mana yakuwi “Wana wa Kuguguma” viraa vilii ");
INSERT INTO poy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andereya na Filipu na Batolumayu na Matayu na Tomasi na Yakobu mwana gwa Alifayu na Tadeyi na Simoni Mkanani ");
INSERT INTO poy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuda Isikariyoti, ayu ndo yakamgalambukiti Yesu. ");
INSERT INTO poy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Shapakanu Yesu kawuyiti ukaya. Lipinga likulu lya wantu wajojinikiti kayi mpaka Yesu na wantumintumi wakuwi wasinditi kuliya shiboga. ");
INSERT INTO poy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Walongu wakuwi pawapikaniriti gawatakuliti wantu, wagenda kumtola, toziya wantu watakuliti, “Kana lukwali.” ");
INSERT INTO poy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wafunda wa Malagaliru ga Musa yawalawiti Yerusalemu walongiti, “Ayu kana Belizebuli! Mkulu gwa washamshera ndo yakamupanana makakala ga kuwalaviya washamshera.” ");
INSERT INTO poy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu kawashema, kawagambira kwa mifanu, “Kwa ntambu ashi Shetani kamlaviyi Shetani myaguwi? ");
INSERT INTO poy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ufalumi pawupalangika, ufalumi hapeni ugoloki. ");
INSERT INTO poy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Viraa kaya payipalangika, kaya ayi hayiyagamili. ");
INSERT INTO poy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Handa Shetani pakalilema mweni pakawera kapalangika, hapeni kagoloki kumbiti upereru wakuwi usoka. ");
INSERT INTO poy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kwahera muntu yakaweza kwingira mnumba mwa muntu yakawera na makakala, kumbiti huti kamtawi muntu ulii. Shapakanu hakawezi kuvitola vintu vyoseri. ");
INSERT INTO poy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nukugambirani nakaka, wantu hawalekiziwi vidoda vyawu vyoseri na mayigilangu gawu goseri. ");
INSERT INTO poy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kumbiti muntu yoseri yakamwigilanga Rohu Mnanagala hapeni kalekiziwi nakamu, toziya vidoda avi vyankulikala mashaka goseri.” ");
INSERT INTO poy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu katakuriti hangu toziya wantu wankulonga, “Kana washamshera.” ");
INSERT INTO poy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Shapakanu mawu na walongu wa Yesu wasoka. Wagoloka kunja, wamtuma muntu kingiri mnumba wakamshemi. ");
INSERT INTO poy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lipinga likulu lya wantu liweriti limzinga Yesu. Womberi wamgambira, “Mawu gwaku na walongu waku wa kunja wankukusakula.” ");
INSERT INTO poy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu kawankula, “Mawu gwangu na walongu waneni washina gaa?” ");
INSERT INTO poy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Shapakanu kawalola wantu yawamzingiti na kutakula, “Mloli! Awa ndo mawu gwangu na walongu wangu! ");
INSERT INTO poy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Muntu yoseri yakatenda ntambu ya kafira Mlungu, ayu ndo mlongu gwangu na dada gwangu na mawu gwangu.” ");
INSERT INTO poy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu kanja kayi kufunda mumpeku mulitanda lya Galilaya. Lipinga lya wantu limzingikiti liweriti likulu mpaka kakweniti mumashuwa iweriti mmashi na kulivaga amu. Wantu woseri walivaga kumpeku kulitanda. ");
INSERT INTO poy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kawafunda vitwatira vivuwa kwa mifanu. Mumafundu gakuwi kawagambiriti, ");
INSERT INTO poy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mpikaniri! Paweriti myala mbeyu kagenditi kukweta mbeyu. ");
INSERT INTO poy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pakaweriti kankuyala mbeyu, zimonga zitulukira munjira, wampongu wiza na kuziliya. ");
INSERT INTO poy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Zimonga zitulukira mulitalawu lyahera litapaka livuwa. Mbeyu azi zimeriti kanongola toziya litapaka lididini. ");
INSERT INTO poy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kumbiti pagulawiti mshenji, gulunguziya mbeyu zimeriti toziya mishigira yakuwi igenda ndiri pasi. ");
INSERT INTO poy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Zimonga zitulukira pa misontu, zikula na misontu izibabanika mbeyu zimeriti, ndo zilera ndiri. ");
INSERT INTO poy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Zimonga zitulukira mulitapaka liherepa zimera, zikula na kulera, yimu malongu matatu na zimonga malongu sita na zimonga miya yimu” ");
INSERT INTO poy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Shapakanu Yesu kawagambira, “Mweni makutu ga kupikinira na kapikiniri!” ");
INSERT INTO poy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu pakaweriti gweka yakuwi, walii wawaweriti pamuhera na wandwa wakuwi lilongu na wawili, wamkosiya kuusu mifanu yakuwi. ");
INSERT INTO poy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu kawagambira, “Mwenga mpananwa kuvimana bada ya Ufalumi wa Mlungu, kumbiti kwa walii yawawera kunja, kila shintu utakula kwawu kwa mifanu. ");
INSERT INTO poy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Su, ‘Pawalola, kumbiti wavimani ndiri, Pawapikanira, kumbiti wavimani ndiri, Nawiza kugalambuka, Pawatubu na kulekiziya vidoda vyawu.’ ” ");
INSERT INTO poy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Shapakanu Yesu kawakosiya, “Su muvimana ndiri mana ya mfanu agu? Su muvimana hashi mifanu yimonga? ");
INSERT INTO poy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ulii mpazi uyala shisoweru. ");
INSERT INTO poy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wantu wamonga walifana gambira yagalawiriti mumbeyu zazitulukiriti munjira. Pawapikanira visoweru vya Mlungu, palaa palii Shetani kiza na kutola visoweru shawayariti mumyoyu mwawu. ");
INSERT INTO poy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wantu wamonga walifana gambira yagalawiriti mumbeyu zazitulukiriti mumabuwi. Pala paliya pawapikanira visoweru, washitola kwa kunemelera. ");
INSERT INTO poy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Toziya wahera mishigira, wakwendereya katepu. Ndabiri na tabu paviyiza kwajili ya visoweru, su palaa palii wavileka kujimilira. ");
INSERT INTO poy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wantu wamonga walifana gambira yagalawiriti mumbeyu zazitulukiriti pa misontu. Wankuvipikanira visoweru, ");
INSERT INTO poy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ira lushera lwa makaliru aga, kufira ulunda shuma, na kufira vintu vya ntambu zoseri, vyawayingiraga na kulibabanika visoweru, su visoweru vilera ndiri kwa wantu walii. ");
INSERT INTO poy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kumbiti wantu wamonga walifana gambira yagalawiriti mumbeyu zyazitulukiriti palitapaka liherepa. Awa wankuvipikanira visoweru, walijimilira na visoweru shilera zivuwa za zilii zawaziyaliti, wamonga mala malongu matatu, wamonga mala malongu sita na wamonga mala miya” ");
INSERT INTO poy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu kendereyiti kuwagambira, “Hashi tulongi muntu kingiziya shikoluboyi mnumba na kushigubikira na shiwiga ama kushitula kulivungu? Hashi kashitula ndiri panani pa shintambi? ");
INSERT INTO poy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Toziya shiraa shintu shawafifa ashiweri paweru. Shoseri shawagubika ashigubutuliki. ");
INSERT INTO poy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Muntu yakawera na makutu ga kupikinira, kapikaniri!” ");
INSERT INTO poy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Viraa vilii Yesu kawagambira, “Mpikaniri weri galiya gampikanira! Malagaliru galii mwagatumiyaga kuwahiga wamonga, Mlungu hakagatumii kuwahiga mwenga, kayi hawongeli. ");
INSERT INTO poy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Toziya muntu kana shintu hawamuwongeleri, na muntu kahera shintu, ata shintu shididini shakaweriti nashi, hawampoki.” ");
INSERT INTO poy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu kendereya kutakula, “Ufalumi wa Mlungu ulifana hangu. Muntu kankuyala mbeyu mulirambu. ");
INSERT INTO poy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pashiru kankugonja mpota, paliwala ka masu na mbeyu zilii zankumera na zikula. Mweni kamana ndiri ntambu yazimera. ");
INSERT INTO poy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Litapaka lyeni litenda vimeriti vikula na kulera, vyanja vitomolera mihamba, kayi mikunguwi, shapakanu ipunta. ");
INSERT INTO poy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kumbiti usaka paukamala, palaa palii muntu ayu kanja kuwuhenga kwa hengu yakuwi, toziya shipindi sha kubenanga shizakala.” ");
INSERT INTO poy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu katakula kayi, “Ufalumi wa Mlungu ulifana na shintu gaa? Tuwulongeri kwa mifanu gaa? ");
INSERT INTO poy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ulifana na mbeyu ndidini, mbeyu ndidini nentu kuliku zoseri zawayala mulirambu. ");
INSERT INTO poy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kumbiti pawaiyara, yankukula na kuwera mtera mkulu kuliku mitera yoseri ya mumalambu. Kayi guwera na mitambi mikulu mpaka wampongu weza kunyawa vitukulu vyawu mumitambi ayi.” ");
INSERT INTO poy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu kawabweliriti wantu visoweru vyakuwi kwa mifanu imonga ivuwa ya ntambu ayi. Kayoweriti nawomberi ntambu yawaweziti kuvimana. ");
INSERT INTO poy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kayoweriti ndiri nawomberi shintu shoseri pota kutenda mfanu. Kumbiti pakaweriti na wafundwa wakuwi gweka yawu, kawagambiriti kila shintu. ");
INSERT INTO poy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pashimihi lishaka liralilii, Yesu kawagambira wafundwa wakuwi, “Tulokeni tugendi kumwambu kulitanda.” ");
INSERT INTO poy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Su walileka lipinga lya wantu. Wafundwa wingira mumtubwi mwakikaliti Yesu. Viraa vilii peniti na mtumbwi gumonga gumfatiti. ");
INSERT INTO poy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pala palii, liziti liyega na mashi giza kwa likakala ganja kuwukoma mtumbwi, mpaka mashi ganja kumema mumtumbwi ulii. ");
INSERT INTO poy_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu kaweriti kuzyetu mumtumbwi, kagonja mumtumbwi. Wafundwa wamwimusiya, wamgambira, “mfunda, gulishera ndiri ntambu yatwankusokera?” ");
INSERT INTO poy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu kimuka, kalikalipira liyega lilii, na kugagambira mashi galii, “Gunyamali jii!” Liyega linyamala, na kuwera kuzizimira jii. ");
INSERT INTO poy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Shapakanu Yesu kawagambira, “Mtira shishi mwenga? Mwakali mwahera njimiru?” ");
INSERT INTO poy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nawomberi watira nentu na walikosiya weni kwa weni, “Ayu muntu gwa ntambu gaa? Ata liyega na mashi gana makakala vyoseri vimjimilira!” ");
INSERT INTO poy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu pamuhera na wantumintumi wakuwi wasoka kumwambu kulitanda lya Galilaya, muisi ya Gerasi. ");
INSERT INTO poy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu pakalawiti mumtumbwi, palaa palii muntu yakawera na washamshera kalawiti mumpanga gagaweriti wankusira wantu. ");
INSERT INTO poy_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Muntu ayu kaweriti kankulikala mumpanga gakaweriti wankusira wantu na kwahera muntu yakaweza kumtawa kayi ata kwa minyololu, ");
INSERT INTO poy_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","toziya mala zivuwa kaweriti kankutawalilwa ngoyi mumawoku na minyololu mumagulu, kumbiti kaweriti pakadumula vyoseri na kuyidumula minyololu yayiweriti mumagulu mwakuwi. Na kwahera muntu yakaweriti na makakala ga kumbata. ");
INSERT INTO poy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mashaka goseri kaweriti kankuyerayera mumpanga na muvigongu, pakabotanga na kulikeshulanga kwa mabuwi. ");
INSERT INTO poy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pakamwoniti Yesu kwa kutali, kamtugiriti na kumsuntamilira ");
INSERT INTO poy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","na kalila kwa kubota pakalonga, “Yesu, Mwana gwa Mlungu yakawera kumpindi nentu! Gufira shishi kwaneni? Nukuhiga kwa litawu lya Mlungu, naguntabisiya!” ");
INSERT INTO poy_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Katakuriti ntambu ayi toziya Yesu kamgambiriti, “Gwenga shamshera, gumlawi muntu ayu!” ");
INSERT INTO poy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Shapakanu Yesu kamkosiya, “Litawu lyaku gaa?” Yomberi kamwankula, “Litawu lyangu Lipinga, mana yakuwi tuvuwa!” ");
INSERT INTO poy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Shapakanu kendereya kumuhiga Yesu kuwera nakawawinga washamshera kunja muisi ilii. ");
INSERT INTO poy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kuweriti na lipinga likulu lya wamtumbi waweriti wankuliya pakwegera pa lugongu. ");
INSERT INTO poy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Su washamshera walii wamuhiga Yesu pawalonga, “Gutulagaliri tugendi kwa wamtumbi, na gutuleki twingiri mwawu.” ");
INSERT INTO poy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu kawalekiziya na washamshera walii wamlawa muntu ulii na wawayingira wamtumbi. Lipinga lyoseri lya wamtumbi elufu mbili watugira kulitanda na walidiba mumashi. ");
INSERT INTO poy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wantu yawaweriti wankulolera wamtumbi walii watuga na kuwagambira wantu shisoweru shilii mulushi na mumalambu. Wantu wagenda kulola shilii shashilawiriti. ");
INSERT INTO poy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pawasokiti kwa Yesu, wamwona muntu ulii yakaweriti na lipinga lya washamshera, kalivagiti pasi, kavala nguwu zyakuwi, viraa mahala gakuwi gamwuyira. Su wantu walii watira. ");
INSERT INTO poy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na walii yawawoniti shitwatira ashi, wawagambira wantu wamonga shitwatira shashimlawiriti muntu ulii yakaweriti na washamshera, pamuhera na shashilawiriti kwa wamtumbi walii. ");
INSERT INTO poy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Su wantu wanjiti kumluwa Yesu kawuki muisi yawu. ");
INSERT INTO poy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu pakaweriti kankukwena mumtumbwi, muntu ulii yakaweriti na washamshera kamluwa wawuki woseri. ");
INSERT INTO poy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kumbiti Yesu kambelera. Kamgambira, “Gugendi ukaya kwa walongu waku na guwagambiri vitwatira vyoseri Mtuwa vyakakutendiriti, na ntambu yakakuwoniriti lusungu.” ");
INSERT INTO poy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Su muntu ulii kugenda zyakuwi mumkowa wagushema lushi lilongu pakawagambira wantu shilii Yesu shakamtendiriti. Na wantu woseri wapikiniriti na walikangasha. ");
INSERT INTO poy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu pakalokiti kala na kusoka kumwambu mulitanda na pakawera pampeku palitanda, lipinga likulu lya wantu lijojinikiti pakwegera na yomberi. ");
INSERT INTO poy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Shapakanu kiza yumu gwa walongoziya wa Numba ya Mlungu, litawu lyakuwi Yairu. Pakamwoniti Yesu, kamsuntamilira pa magulu gakuwi, ");
INSERT INTO poy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kamuhiga pakalonga, “Muhinga gwangu kalwala tashitashi. Shondi, shondi, gwizi gumtuliri liwoku lyaku su kaweri mkomu na kalikali.” ");
INSERT INTO poy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Su Yesu kagenda pamuhera na yomberi. Wantu wavuwa wamfatiti na kumbabanika babanika. ");
INSERT INTO poy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Panu paweriti na mdala yumu kawera na ulweri wa kusuma mwazi kwa mivinja lilongu na mbili. ");
INSERT INTO poy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mdala ulii katabikiti nentu kwa kuwagendera waganga wavuwa na kamaliriti kila shintu shakaweriti nashi, yomberi kapona ndiri, kumbiti kendereyiti kulwala. ");
INSERT INTO poy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yomberi pakapikaniriti visoweru kuusu Yesu, kiza kumbeli kulibabanika mulipinga lya wantu, kayishinkula nguwu ya Yesu, ");
INSERT INTO poy_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","toziya kaligambiriti mweni, “Panuishinkula hera nguwu ya Yesu, hamponi.” ");
INSERT INTO poy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pakayishinkuriti nguwu ya Yesu, palaa palii kusuma mwazi kwoya na yomberi kalipikanira munshimba mwakuwi kuwera ulweli wakuwi upona. ");
INSERT INTO poy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pala palii Yesu kavimana kuwera likakala limwukiti. Su kaligalambukira lipinga lya wantu na kukosiya, “Gaa yakashinkuriti nguwu yangu?” ");
INSERT INTO poy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wafundwa wakuwi wamwankula, “Guwona wantu ntambu yawakubabanika babanika, gwenga gukosiya, ‘Gaa yakakushinkuliti?’ ” ");
INSERT INTO poy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kumbiti Yesu kaloliti wega zoseri su kamwoni muntu yakamshinkuliti. ");
INSERT INTO poy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na mdala ulii kashimana shintu shashimlawiriti, su kamgendera pakalendema kwa lyoga. Kasuntamilira pa magulu pa Yesu, shapakanu kamgambira unakaka woseri. ");
INSERT INTO poy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu kamgambira, “Mwana gwangu, njimiru yaku yikuponiziya. Gugendi kwa ponga na guweri mkomu.” ");
INSERT INTO poy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu pakaweriti kankali kankutakula ntambu ayi, wiza wantu kulawa ukaya kwa Yairu, ulii mkulu gwa Numba ya Mlungu, wamgambira Yairu, “Muhinga gwaku kahowa kala. Iwera ashi gwankwendereya kumgaziya Mfunda?” ");
INSERT INTO poy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kumbiti Yesu pakapikaniriti shawatakuliti, kalishera ndiri, kamgambira ulii mlongoziya gwa Numba ya Mlungu, “Nagutira, gujimiri hera.” ");
INSERT INTO poy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu kafira ndiri muntu yoseri kamfati kumbiti Peteru na Yakobu na Yohani na Yakobu mlongu gwakuwi. ");
INSERT INTO poy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pawafikiti ukaya kwa Yairu, Yesu kawona wankushowangana na kawapikanira wantu wankulira na kudaya. ");
INSERT INTO poy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Su Yesu kingira mnumba kawagambira, “Ashashi mwankushowangana na kulila? Mwana hakenihowi, kagonja hera!” ");
INSERT INTO poy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kumbiti womberi wamseka. Su kawalaviya woseri kunja, kawatola tati na mawu gwa mwana ulii pamuhera na wantumintumi wakuwi watatu yakaweriti nawu na wingira mpaka pakaweriti mwana ulii. ");
INSERT INTO poy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu kamkola liwoku mwana ulii, kamgambira, “Talita kumu!” Mana yakuwi, “Muhinga, nukugambira gwimuki!” ");
INSERT INTO poy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pala palii muhinga ulii kimuka na kanja kugenda genda. Muhinga ayu kaweriti na mivinja lilongu na miwili. Pagalawiriti aga, wantu walikangashiti nentu. ");
INSERT INTO poy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kumbiti Yesu kawalagalira nentu nawamgambira muntu yoseri shitwatira ashi shashilawiriti. Shapakanu kawagambira, “Mumpanani muhinga ayu shiboga kalii.” ");
INSERT INTO poy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu kawuka peni palii, kagenda mlushi mwakuwi na wafundwa wakuwi wamfatiti. ");
INSERT INTO poy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Palisokiti lishaka lya kwoyera, kanja kufunda mnumba ya Mlungu. Wantu wavuwa yawampikaniriti walikangasha, watakula, “Kagapata koshi goseri aga? Luhala gaa alu lwakampiti? Kankuweza hashi kutenda mauzauza aga? ");
INSERT INTO poy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ayu ndo ulii msongola ndiri vintu? Mwana gwa Mariya na walongu wakuwi washina Yakobu na Yosefu na Yuda na Simoni? Hashi dada wakuwi wikala pala panu ndiri?” Su wamlema kumjimira. ");
INSERT INTO poy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu kawagambira, “Mbuyi gwa Mlungu kankujimilwa pahala poseri, ira kankujimilwa ndiri mlushi lwakuwi na kwa walongu wakuwi na ukaya kwakuwi mweni.” ");
INSERT INTO poy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu kaweziti ndiri kutenda mauzauza goseri palii, ira kawatulira mawoku walweli wavuwa ndiri, kawaponiziya. ");
INSERT INTO poy_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kalikangasha nentu toziya wantu wahera moyu. Shapakanu Yesu kavityangira vijiji vya pakwegera, pakawafundiza wantu. ");
INSERT INTO poy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kawashemiti walii wantumintumi lilongu na wawili, kanja kuwatuma wawili wawili. Kawayupa makakala ga kuwawinga washamshera. ");
INSERT INTO poy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Shapakanu kawagambira, “Namtola shintu shoseri kwajili ya mwanja, ira lukongoshu gweka hera. Namtola libumunda, wala muhaku, wala mpiya mshunu. ");
INSERT INTO poy_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mvali vilwatu, kumbiti namtola nguwu yingi Kayi. ");
INSERT INTO poy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Numba yoseri pawawashemereni, mlikali palaapa mpaka pamwuka lushi alu. ");
INSERT INTO poy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na pahala poseri wantu pawawashemerani ndiri pota kuwapikinira, mwuki na kupunda lidika mmagulu mwenu. Ayi hayiweri litakulilu kwawomberi.” ");
INSERT INTO poy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Su wagenda na kuwabwelela wantu wavileki vidoda vyawu. ");
INSERT INTO poy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wawalaviya washamshera wavuwa na kuwaswaga lipaki walweli wavuwa na kuwaponiziya. ");
INSERT INTO poy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mtuwa Herodi kapikanira visoweru avi, toziya litawu lya Yesu lipikanikiti pahala poseri. Wantu wamonga walonga, “Yohani yakabatiza kazyuka! Ndo mana kana likakala lya kutenda mauzauza aga.” ");
INSERT INTO poy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kumbiti wamonga walongiti, “Ayu ndo Eliya.” Na wamonga walongiti, “Ayu ndo mbuyi gwa Mlungu, handa walii wambuyi wa Mlungu wa makashu.” ");
INSERT INTO poy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodi pakapikaniriti visoweru avi, kalongiti, “Ayu ndo Yohani Mbatiza yanumudumuliti mtuwi kazyuka!” ");
INSERT INTO poy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Makashu Herodi mweni kalagaliriti Yohani kabatwi na katatilwi mushibetubetu. Katenditi hangu toziya ya Herodiya yakamuyugiti pamuhera kavimaniti kaweriti mdala gwa mlongu gwakuwi Filipi. ");
INSERT INTO poy_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohani kaweriti kamgambira Herodi, “Lilagaliru lilema gwenga kumuyuga mdala gwa mlongu gwaku!” ");
INSERT INTO poy_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Su Herodiya kamkalalira nentu Yohani, kafira kumlaga kumbiti kaweza ndiri kwajili ya Herodi. ");
INSERT INTO poy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodi kamtiriti Yohani toziya kavimaniti Yohani kaweriti muntu muheri na mnanagala, su kaweriti kankumlolera. Kafiriti kumpikinira Yohani, tembera pakampikaniriti kala moyu gumtama nentu. ");
INSERT INTO poy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lishaka limu Herodiya kapatiti lupenyu mumsambu gwa lishaka lya kwiwukwa kwa Herodi. Herodi kawatendiriti msambu wakolamlima wa sirikali, wakulu wa wanjagila na watuwa wa isi ya Galilaya. ");
INSERT INTO poy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Muhinga gwa Herodiya pakingiriti kuvina, kamherepeziya Herodi na wahenga wakuwi. Su mtuwa kamgambira muhinga ulii, “Gunduwi shintu shoseri shagufira na neni hanukupanani.” ");
INSERT INTO poy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kalirapa kayi, “Hanukupanani shoseri shagufira, ata nusu ya ufalumi wangu!” ");
INSERT INTO poy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pala palii mhinja uliya kagenda kumkosiya mawu gwakuwi, “Ntuwi shishi?” Nayomberi kamwankula, “Guluwi mtuwi gwa Yohani Mbatiza.” ");
INSERT INTO poy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mhinja ulii katuga mpaka kwa mtuwa na kumluwa, “Nfira gumpanani vinu vinu mtuwi gwa Yohani Mbatiza muluseru!” ");
INSERT INTO poy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mtuwa moyu gumtama nentu, kumbiti kaweziti ndiri kulema, toziya kalirapiliti palongolu pa wahenga wakuwi. ");
INSERT INTO poy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Su mtuwa kamlagilira mjagira palaa palii hakajegi mtuwi gwa Yohani. Mjagira kagenda mushibetubetu na kumdumula Yohani mtuwi. ");
INSERT INTO poy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Shapakanu kawujega mtuwi gulii muluseru na kumpanana nafunda ulii. Nayomberi kampanana mawu gwakuwi. ");
INSERT INTO poy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wafundwa wa Yohani pawapikaniriti hangu, wagenda kuyitola nshimba yakuwi na kuyisira. ");
INSERT INTO poy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wantumintumi wawuyiti na kuliwona na Yesu, wamgambira goseri galii gawatenditi na kufunda. ");
INSERT INTO poy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yesu kawagambira, “Tugendeni gweka yetu pahala pahera muntu, mwakwoyeri katepu.” Katakuliti ntambu ayi toziya kuweriti na wantu wavuwa waweriti wankwiza na kuwuka, mpaka wapata ndiri lupenyu lwa kuliya shiboga. ");
INSERT INTO poy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Su wawuka gweka yawu kwa mtumbwi, wagenda pahala pahera wantu. ");
INSERT INTO poy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kumbiti wantu wawawoniti pawaweriti wankuwuka, wawamaniti. Su watuga kulawa lushi zoseri na wawalongolera kusoka. ");
INSERT INTO poy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu pakasulukiti kulawa mumtumbwi na pakaliwoniti na lipinga likulu lya wantu. Kawawoneriti lusungu toziya waweriti gambira wakondolu yawahera mlolera. Su kanja kuwafunda vintu vivuwa. ");
INSERT INTO poy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pamihi payifikiti, wafundwa wa Yesu wamgendera na kumgambira, “Pahala panu pashiwala na mshenji guzyeta. ");
INSERT INTO poy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Guwalekeziyi wantu wagendi mumalambu na muvijiji vya pakwegera wahemeri shiboga.” ");
INSERT INTO poy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kumbiti Yesu kawankula, “Mwenga muwapanani shiboga waliyi.” Wamkosiya, “Hashi tugendi twakahemeri mabumunda ya mpiya zyaziweziti kumpanana mtenda lihengu kwa myezi minani tuwapanani waliyi?” ");
INSERT INTO poy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kawakosiya, “Mnaga mabumunda maninga? Mgendi mkaloli.” Pawaloliti kala, wamgambira, “Kwana mabumunda muhanu na wasomba awili.” ");
INSERT INTO poy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Shapakanu Yesu kawagambira wantumintumi wakuwi wawagambiri wantu woseri waligawi muvipinga vipinga, walivagi pasi mumihamba. ");
INSERT INTO poy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Su wantu walivaga mushipinga sha wantu miya na sha wantu malongu muhanu muhanu. ");
INSERT INTO poy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Shapakanu Yesu kagatola mabumunda muhanu galii na wasomba awili. Kalola kumpindi, kalonga mayagashii Mlungu na kagamega mabumunda galii. Shapakanu kawapanana wafundwa wakuwi wawapanani wantu. Viraa virii kawagawira wantu woseri wasomba awili walii. ");
INSERT INTO poy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wantu woseri waliya na kwikuta. ");
INSERT INTO poy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wafundwa wa Yesu wasola vyavisigaliti vya mabumunda na wasomba na kumemeziya mumajamanda lilongu na mawili. ");
INSERT INTO poy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wapalu waliyiti waweriti elufu mhanu. ");
INSERT INTO poy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Palaa palii Yesu kawagambira wafundwa wakuwi wingiri mumtumbwi, wamlongoleri kugenda Betisayida. Yomberi kaweriti kankuwaaga wantu. ");
INSERT INTO poy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pamberi pakamaliriti kulonga kwahere wantu, kagenda kulugongu kumluwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pamihi papasokiti, mtumbwi guweriti pakati pa litanda, kumbiti Yesu kaweriti gweka yakuwi kuisi iyuma. ");
INSERT INTO poy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kawawona wafundwa wakuwi wankuyerayera na kushima mutumbwi kwa ngafu, toziya lipuga liweriti lyankuwapingira. Payiweriti pakwegera na kushiya, Yesu kawagendera pakatyanga pampindi pamashi. Pakwegera kawapiti, ");
INSERT INTO poy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","kumbiti pawamuwoniti kankutyanga pampindi pamashi, walihola kaweriti lihoka. Wanjiti kushowangana, ");
INSERT INTO poy_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","toziya woseri pawamuwoniti watiriti nentu. Palaa palii Yesu kawagambira, “Namtira, ndo neni!” ");
INSERT INTO poy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Shapakanu kingira mumtumbwi pamuhera nawomberi na liyega linyamalira. Wantumintumi wakuwi walikangasha nentu, ");
INSERT INTO poy_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","toziya waweriti wavimana ndiri mana ya kuwapanana wantu mabumunda galii, myoyu yawu iweriti ikamala. ");
INSERT INTO poy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Waloka litanda, wasoka muisi ya Genezareti, panu wagugolosiya mtumbwi gwawu. ");
INSERT INTO poy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pawalawiti mumtumbwi, wantu wammaniti ndo Yesu. ");
INSERT INTO poy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Su watugiriti mulushi zoseri na wawatola walweli mumashera na kuwajega pahala poseri pawapikaniriti Yesu pakaweriti. ");
INSERT INTO poy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pahala poseri Yesu pakagenditi, muvijiji, mulushi, ama mumalambu, wantu wawatuliti walweli paviwanja. Wamluwa kawaleki wamshinguli muluwiniku lwa nguwu yakuwi na woseri wawamshinguliti waponiti. ");
INSERT INTO poy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafalisayu wamu na wafunda wa Malagaliru wawaweriti wankulawa Yerusalemu walivaga pawamzyengeta Yesu. ");
INSERT INTO poy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wawona wafundwa wamu wa Yesu wankuliya shiboga kwa mawoku mahumba, yani wagulula ndiri mawoku gawu ntambu ya ifiruwiti. ");
INSERT INTO poy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Toziya Mafalisayu na Wayawudi woseri waliya ndiri shiboga mpaka wagululi mawoku gawu ntambu ya wamaniti, wakoliti shitiba sha wazewi wau. ");
INSERT INTO poy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pawalawa mumasoku waliya ndiri shintu shoseri mpaka washigululi huti ntambu ya wavimani. Vira vilii wakoliti vitiba vimonga, gambira vilii kugulula lutekeru, viwiga na vyombu vya shaba. ");
INSERT INTO poy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Su Mafalisayu na wafunda wa Malagaliru wamkosiya Yesu, “Ntambu gaa wafundwa waku wakola ndiri vitiba vya wambuyi wawu, ira womberi waliya kwa mawoku mahumbu?” ");
INSERT INTO poy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu kawankula, “Isaya katungiti weri, mwenga mwawafyangu, gambira ntambu yakalembiti, ‘Wantu awa, wanjimira kwa visoweru hera, kumbiti mumyoyu mwau, wapatali na neni. ");
INSERT INTO poy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kuntambikira kwawu kunfaa ndiri mana wafunda vitiba vya wantu hera gambira malagaliru ga Mlungu.’ ” ");
INSERT INTO poy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Mwenga mugaleka malagaliru ga Mlungu na kukola vitiba vyenu.” ");
INSERT INTO poy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu kendeleyiti kutakula, “Mwenga mulihola muherepa, kumbiti mugalema malagaliru ga Mlungu su muvikoli vitiba vyenu. ");
INSERT INTO poy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mana Musa kamuiti, ‘Guwapanani ligoya tati gwaku na mawu gwaku.’ Kayi katakuliti ‘muntu yoseri yanakahigiranga tati ama mawu, muntu ayu hawamlagi.’ ");
INSERT INTO poy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kumbiti mwenga mfunda, gambira muntu kana shintu sha kuwatanga tati ama mawu gwakuwi, kumbiti katakula shintu ashi ‘Kolibani’ yani mafupu kwa Mlungu, ");
INSERT INTO poy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","su mutakula kalazimika ndiri kuwatanga tati gwakuwi ama mawu gwakuwi. ");
INSERT INTO poy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Su, kwa ntambu ayi mbeziya shisoweru sha Mlungu kwajili ya mafundu gamwankana. Kayi mtenda vitwatira vivuwa vya ntambu ayi.” ");
INSERT INTO poy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu kalishema kayi lipinga lilii lya wantu. Kawagambira, “Mpikiniri woseri, muvimani. ");
INSERT INTO poy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kwahera shintu shashimwingira muntu shashiweza kumtenda kaweri muhumba. Kumbiti shashimlawa muntu ashi ndo shashimtenda muntu kaweri muhumba. ");
INSERT INTO poy_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Muntu pakana makutu, kapikaniri.” ");
INSERT INTO poy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pakalilekiti lipinga lya wantu na kwingira mnumba, wafundwa wakuwi wamkosiya mana ya mfanu wakatakuliti. ");
INSERT INTO poy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu kawagambira, “Hashi, ata mwenga mwelewa ndiri? Hashi muvimana ndiri handa shintu shashimwingira muntu kulawa kunja, shimtenda ndiri muntu kaweri muhumba, ");
INSERT INTO poy_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Toziya shimwingira ndiri mumoyu, kumbiti shingira mumtima, shakapanu shilawa kunja munshimba?” Kwa kutakula hangu, Yesu kavipungiti viboga vyoseri. ");
INSERT INTO poy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kendereyiti kulonga, “Shashilawa munshimba mwamuntu ndo shimtenda kaweri muhumba. ");
INSERT INTO poy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Toziya mumoyu mwa muntu mulawa maholu madoda na kumbinta na shimpegu na ulagaji shakapanu ");
INSERT INTO poy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","uhumba na lwaliya na vidoda na upyotu na utindira na weya na mayigilangu na shinika na lipungasesi. ");
INSERT INTO poy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Madoda aga goseri galawa munshimba mwa muntu, ndo hagamtendi muntu kaweri muhumba.” ");
INSERT INTO poy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu kawuka paliya, kagenda mulushi lwa Tiru. Aku kingira mnumba na kafiriti ndiri muntu yoseri kavimani, kumbiti kaweziti ndiri kulififa. ");
INSERT INTO poy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Paniti mdala yumu mweni muhinga gwakuwi kaweriti na shamshera, kapikaniriti visoweru vya Yesu. Palaa paliya kiza kamsuntamalira pamagulu pakuwi. ");
INSERT INTO poy_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mdala ayu kaweriti Mgiriki, mwenikaya gwa Silofainiki. Su kamluwa Yesu kamlavii muhinga gwakuwi shamshera kadoda. ");
INSERT INTO poy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu kamgambira, “Guleki huti wana wikuti. Kwa mana iherepa ndiri kutola shiboga sha wana na kuwasila wang'ang'a.” ");
INSERT INTO poy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kumbiti mdala uliya kamwankula, “Nyina Mtuwa, kumbiti ata wang'ang'a wapasi pameza waliya shiboga shawalekiti wana!” ");
INSERT INTO poy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu kamgambira, “Toziya ya shisoweru ashi shagulongiti, gugendi ukaya, haguwoni shamshera kamlawa muhinga gwaku!” ");
INSERT INTO poy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Su kagenda ukaya kwakuwi, kamwona mwana kagonja mshitanda na shamshera kamlawiti kala. ");
INSERT INTO poy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Shakapanu Yesu kawuka mulushi lwa Tiru, kapitira Sidoni, kasoka litanda Galilaya kwa kupitira mukowa lushi lilongu. ");
INSERT INTO poy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Su wamjegera muntu kana majogu viraa ka bubu, wamluwa kamtulili mawoku. ");
INSERT INTO poy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu kamtura kutali na wantu. Katula vyala vyakuwi mmakutu mwa muntu uliya. Katema mata na kumshinkula lulimi. ");
INSERT INTO poy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Shakapanu kalola kumpindi kwa Mlungu, kapumula na kumgambira, “Efata,” mana yakuwi, “Guvuguki!” ");
INSERT INTO poy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mala makutu gakuwi gavuguka na lulimi lwakuwi luyoposoka, kanja kutakula nweri. ");
INSERT INTO poy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu kawabeliziya nawamgambiziya muntu yoseri vitwatira avi. Kumbiti ntambu yakawabeleriti, ndo ntambu yawendereyiti kubwera shisoweru ashi. ");
INSERT INTO poy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wantu walikangasha nentu. Watakula, “Katenda vyoseri viheri, kawatenda wanamajogu kupikinira na bubu kutakula!” ");
INSERT INTO poy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lishaka limu, lipinga limonga lya wantu waliwona kayi, waweriti wahera shiboga. Su Yesu kawashema wafundwa wakuwi, kawagambira, ");
INSERT INTO poy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nuwawonera lusungu wantu awa toziya wapamuhera na neni kwa mashaka matatu na vinu wahera shiboga. ");
INSERT INTO poy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Handa panawalekisiya wagendi ukaya kwawu na njala hawalembuki mnjira, toziya wamonga walawa kutali.” ");
INSERT INTO poy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wafundwa wakuwi wamkosiya, “Peni panu pantundu hagapatikani koshi mabumunda ga kuwawikutiziya wantu woseri awa?” ");
INSERT INTO poy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu kawakosiya, “Mwaga mabumunda maninga?” Nawomberi wamwankula, “Twana mabumunda saba.” ");
INSERT INTO poy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu kawagambira wantu walivagi pasi. Katola mabumunda saba, kamgambira Mlungu mayagashii. Shakapanu kagamega mabumunda galiya, kawayupi wafundwa wakuwi wawayupi wantu, nawomberi wawagawira. ");
INSERT INTO poy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kayi waweriti na wasomba vidika vididini. Yesu kavitekelera, kawahimiziya wawapanani wantu ntambu iraa. ");
INSERT INTO poy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wantu waliya wikuta, wafundwa wakuwi wasola visigariti wamemeziya majamanda saba. ");
INSERT INTO poy_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wantu waliyiti waweriti elufu msheshi. Su Yesu kawagambira ne mbuka. ");
INSERT INTO poy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pakamaliliti kuwagambira ne mbuka kakwena mumashuwa pamuhera na wafundwa wakuwi kagenda lushi lwa Dalumanita. ");
INSERT INTO poy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafalisayu wamu wiziti kwa Yesu, wanja kulishowerana nayomberi. Wafiriti kumjera kawatenderi lirangaliru lya liuzauza kulawa kumpindi. ");
INSERT INTO poy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu kawawonera lusungu kumoyu, kalonga, “Iwera hashi shiyiwuku ashi shifira liuzauza? Nakaka nukugambirani, shiyiwuku ashi hapeni shipati lilangaliru lyoseri.” ");
INSERT INTO poy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Su kawaleka, kakwena kayi mumashuwa, kagenda kumwambu kulitanda. ");
INSERT INTO poy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Wantumintumi waliyaluwiti kutola mabumunda, waweriti na libumunda limu hera mumashuwa. ");
INSERT INTO poy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu kawaberiziya, “Mukali weri na vidodera vya Mafalisayu na vya Herodi.” ");
INSERT INTO poy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wantumintumi wanja kulitakuziyana weni kwa weni, “Kankutakula hangu toziya twahera mabumunda.” ");
INSERT INTO poy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu kavimaniti gawatakuliti, kawakosiiti, “Mbona mwankulitakuziya kuusu kuwera ndiri na mabumunda? Mwenivimani wala kupikinira? Yakali ikamala myoyu yenu? ");
INSERT INTO poy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mwana masu, hashi mwona ndiri? Mwanaga makutu, hashi mpikinira ndiri? Mlihola ndiri? ");
INSERT INTO poy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pamegiti mabumunda mhanu su na kuwayupa wantu elufu mhanu, mjojiniriti majamanda maninga ga yagasigariti?” Wamwankula, “Gaweriti majamanda lilongu na mawili.” ");
INSERT INTO poy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Pakagamegiti mabumunda saba na kawayupa wantu elufu msheshi, mjojiniriti majamanda maninga yagasigariti?” Wamwankula, “Gaweriti majamanda saba.” ");
INSERT INTO poy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Su Yesu kawagambira, “Na vinu muvimana ndiri?” ");
INSERT INTO poy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu kasokiti Betisayida pamuhera na wantumintumi wakuwi. Aku wantu wamjega kanalwisi yumu, wamluwa Yesu kamkoli. ");
INSERT INTO poy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu kamkola liwoku kanalwisi uliya, kamjega kunja kushijiji. Kamtemera mata mmasu kamtulila mawoku, kamkosiya, “Guweza kuwona shintu shoseri?” ");
INSERT INTO poy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kanalwisi uliya kalola, katakula, “Nawawona wantu wawonekana gambira mitera yankugendagenda.” ");
INSERT INTO poy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Su Yesu kamtulila kayi mawoku mmasu, yomberi katumula masu. Uwezu wakuwi wa kulola umwuyira, kalola kila shintu weri. ");
INSERT INTO poy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu kamgambira gugendi zaku ukaya na kumuhimiziya, naguwuya kushijiji shilii. ");
INSERT INTO poy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Shakapanu Yesu na wafundwa wakuwi wagenditi muvijiji vya Kaisariya Filipi. Pawaweriti munjira, Yesu kawakosiiti, “Wantu watakula neni na gaa?” ");
INSERT INTO poy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wamwankula, “Wamonga watakula gwenga gwa Yohani mbatiza na wamonga Eliya na wamonga watakula gwenga guwera yumu gwa wambuyi wa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nayomberi kawakosiya, “Hashi, mwenga mlonga neni nagaa?” Peteru kamwankula, “Gwenga gwa Kristu!” ");
INSERT INTO poy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Shakapanu Yesu kawaberiziya pakawagambira, “Namumgambira muntu yoseri visoweru avi.” Litawu Kristu kwa Shigiriki mana yakuwi ndo Mlungu kamsyagula kuwera Mtuwa. Kwa Shiebulaniya litawu ali walishema Masiya. ");
INSERT INTO poy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Shakapanu Yesu kanjiti kuwafundiza wantumintumi wakuwi. Kawagambira, “Mwana gwa muntu mpaka katabiki nentu na kulemwa na wazewi na watambika wakulu wa numba ya Mlungu na wafunda wa malagaliru. Hawamlagi, kumbiti pamashaka matatu pagapita hakazyuki.” ");
INSERT INTO poy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu kawagambiriti vitwatira avi pota kufifa. Su, Peteru kamtola kumbwega, kanja kumkalipira. ");
INSERT INTO poy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kumbiti Yesu kagalambuka, kawalola wafundwa wakuwi, kamkalipira Peteru pakalonga, “Guwuki kulongolu kwaneni, Shetani! Maholu gaku galawa ndiri kwa Mlungu ira ga muntu!” ");
INSERT INTO poy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Su kalishema lipinga lya wantu na wafundwa wakuwi, kawagambira, “Handa muntu yoseri pakafira kunfata, kalilemi mweni na kalutoli lupingika lwakuwi kanfati. Luka 14.27. ");
INSERT INTO poy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Handa muntu yakafira kugalopoziya makaliru gakuwi mweni hakaagamiziyi, kumbiti muntu yakagamiziya ukomu wakuwi kwajili ya neni na kwajili ya Shisoweru Shiwagira hakalopoziyi. ");
INSERT INTO poy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Hashi, kwana mota gaa muntu kuyipata isi yoseri shakapanu hakaagamiziyi makaliru gakuwi? Hakapati ndiri shintu. ");
INSERT INTO poy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ama muntu katendi hashi kupata kayi makaliru gakuwi? ");
INSERT INTO poy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Muntu yoseri mushiyiwuku ashi shidoda na shashimtira ndiri Mlungu, yakamonera soni neni na mafundu gangu, neni Mwana gwa muntu hanumwoneri soni muntu uliya paniza muwukwisa wa Tati gwangu pamuhera na wantumintumi wa kumpindi wananagala wa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu kongera kuwagambira, nukugambirani nakaka, wamonga wapalaapa hapeni wahowi pota kuuwona Ufalumi wa Mlungu pawiza na makakala. ");
INSERT INTO poy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pagapititi mashaka sita, Yesu kawatola Peteru na Yakobu na Yohani kagenda nawa kumpindi kulugongu lutalipa gweka yawu. Pawaweriti wankulola, Yesu kagalambusiwa nshimba kulongolu kwawu, ");
INSERT INTO poy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","nguwu zakuwi zimelemeta, ziwera za neru mbuu kwahera muntu yakaweza kuputa ntambu ilii. ");
INSERT INTO poy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Wantumintumi watatu walii wawawona Eliya na Musa wankuyowera na Yesu. ");
INSERT INTO poy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peteru kamgambira Yesu, “Mfunda iherepa nentu twa panu. Su mbaka tunyawi visasa vitatu, shimu shaku na shimu sha Musa na shimu sha Eliya.” ");
INSERT INTO poy_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ashina Peteru watira nentu, Peteru kavimana ndiri shakutakula. ");
INSERT INTO poy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Shakapanu shilawira shivinyiru sha liwundi shiwagubikira na liziwu lipikanirika kulawa muliwundi, “Ayu ndo mwana gwangu shintama, mumpikiniri.” ");
INSERT INTO poy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Palapaliya wantumintumi awa walolalola, kumbiti wamwona ndiri muntu yumonga, ira Yesu gweka yakuwi. ");
INSERT INTO poy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pawaweriti wankusuluka mlugongu, Yesu kawagambiriti, namumgambira muntu yoseri vitwatira vyamuwoniti, mpaka neni Mwana gwa muntu panzyukaku kulawa kwa wahowa. ");
INSERT INTO poy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Su, wakola malagaliru aga, kumbiti waweriti wankulitakuziyana mana ya kuzyuka kulawa kwa wahowiti. ");
INSERT INTO poy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wamkosiya Yesu, “Iwera hashi wafunda wa Malagaliru watakula Eliya mpaka kizi huti?” ");
INSERT INTO poy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nayomberi kawankula, “Yina, Eliya kankwiza huti kuwanyawira vyoseri. Kumbiti kwa shishi su walemba mumalembu mananagala handa Mwana gwa muntu hakatabiki nentu na kulemwa? ");
INSERT INTO poy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kumbuti nukugambirani, Eliya kizakala, nawomberi wamtendera ntambu yawafiriti gambira malembu ntambu yagatakuliti hawamtenderi.” ");
INSERT INTO poy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu pamuhera na wafundwa watatu pawawuyiti kwa wantumintumi wamonga, wawoniti lipinga likulu lya wantu na wafunda wamu wa Malagaliru waweriti wankulitakuziyana nayomberi. ");
INSERT INTO poy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Palapalii wantu pawamwoniti Yesu, woseri walikangasha nentu, wamtugira wamlamusiyi. ");
INSERT INTO poy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu kawakosiya wantumintumi wakuwi, “Mwangulitakuziyana shishi nawa?” ");
INSERT INTO poy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Su muntu yumu mulipinga lya wantu kankula, “Mfunda numjega mwana gwangu kwaku, toziya kana shamshera yakamtenda kalanduli ndiri. ");
INSERT INTO poy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kila mala pakamwizila, kamgusiya pasi na kumtenda kalawi ufulufulu mumlomu, pakagayagaya menu na nshimba yoseri iyuma. Nuwaluwiti wafundwa waku wamlaviyi shamshera uliya kumbiti wasinda.” ");
INSERT INTO poy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu kawagambira, “Mwenga, shiyiwuku shankali moyu! Hashi hankali na mwenga mpaka ndii? Hashi hanuwahepeleri mpaka ndii? Mumjegi panu.” ");
INSERT INTO poy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wamjega mwana uliya yakaweriti na washamshera, shamshera ulii pakamwoniti Yesu, pala palii kamgusiya pasi na kumlekela shisirika, nayomberi, kagalagata na kulawa lufulufulu mumulomu. ");
INSERT INTO poy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu kamkosiya tati gwa mwana ulii, “Vitwatira avi vimpata kwanjira ndii?” Yomberi kankula, “Kwanjira uwana wakuwi.” ");
INSERT INTO poy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mala zitangala shamshera ulii kamgusiyiti mumotu na mmashi su kamlagi. Payiwera guweza Gutuwoneri lusungu na gututangi! ");
INSERT INTO poy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu kamgambira, “Iwera hashi gutakula handa guweza?” Nukugambira vitwatira vyoseri viwezekana kwa muntu yakawera na njimiru. ");
INSERT INTO poy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Su Palaa palii tati gwa mwana ulii kabotanga pakalonga, “Njimira! Guntangi neni weri na njimiru itosha.” ");
INSERT INTO poy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu pakaliwoniti lipinga lya wantu lyankuwongereka kamukamu, kamkalipiriti shamshera ulii pakamgambira, “Shamshera yagumtenda mwana ayu kaweri bubu na majogu, nukugambira gumlawi mwana ayu nagumwingira kayi!” ");
INSERT INTO poy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Shamshera ulii kagutanga na kamgusiya pasi mwana ulii, kamlawa. Mwana ulii kawonekaniti handa kahowa, su wantu wavuwa walongiti, “Kahowa!” ");
INSERT INTO poy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kumbiti Yesu kamkola liwoku kamnyasula na yomberi kagoloka. ");
INSERT INTO poy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu pakingiriti mnumba, wafundwa wakuwi wamkosiyiti pawawera gweka yawu, “Iwera hashi twenga tusinda kumlaviya shamshera ulii?” ");
INSERT INTO poy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu kawagambira, “Shamshera gwa ntambu ayi hapeni kalawi kumbiti kalawa kwa kumluwa Mlungu hera.” ");
INSERT INTO poy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu pamuhera na wafundwa wakuwi wawukiti palii, wendereyiti na mwanja kupitira mukowa gwa Galilaya. Yesu kafiriti ndiri muntu yoseri kavimani pawawera, ");
INSERT INTO poy_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","toziya kaweriti kankuwafunda wafundwa wakuwi. Kawagambiriti, “Mwana gwa muntu hawamlaviyi kwa wantu wamlagi. Kumbiti pagapita mashaka matatu hakazyuki.” ");
INSERT INTO poy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wafundwa wavimaniti ndiri vitwatira avi kumbiti watira kumkosiya. ");
INSERT INTO poy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Su wasokiti Kafarinaumu, na pakaweriti mnumba, Yesu kawakosiyiti wafundwa wakuwi, “Mweriti mwankulitakuziya shishi munjira?” ");
INSERT INTO poy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kumbiti womberi wanyamalira, mana mnjira waweriti wankulitakuziana, “Gani mkulu pakati petu?” ");
INSERT INTO poy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu kalivaga pasi, kawashema walii wantumintumi lilongu na awili kawagambira, “muntu pakafira kaweri gwa kwanja hakaweri gwa kupelera na ntumintumi gwa woseri.” ");
INSERT INTO poy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Shakapanu kamtola mwana mdidini, kamgolosiya pakati pawomberi. Kamkisikira, shakapanu kawagambira, ");
INSERT INTO poy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yakamwanka yumu gwa mwana gambira ayu kwa litawu lyangu, kananka neni na yakananka neni kananka hera ndiri neni, su kamwanka yakantumiti neni.” ");
INSERT INTO poy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohani kamgambira, “mfunda tumwona muntu yumu kankuwusiya washamshera kwa litawu lyaku, twenga tujera kumberiziya toziya yomberi ka yumu gwetu ndiri.” ");
INSERT INTO poy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kumbiti Yesu kawagambira, “Mleki kumberiziya, toziya kwahera muntu yakatenda mauzauza kwa litawu lyangu na palaa panu shakapanu katakuli vidoda kwaneni. ");
INSERT INTO poy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Toziya muntu yakatulema ndiri twenga, muyetu. ");
INSERT INTO poy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nuwagambira nakaka, muntu yoseri yakakupananeni mashi gakulanda toziya mwenga mwa wantu wa Kristu, nakamu hapeni kakosi kulipata lifupu lyakuwi. ");
INSERT INTO poy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Muntu yoseri yakamtenda yumu gwa wadidini wawanjimira katendi vidoda, iweri mbaka kwa muntu uliya kumtawalira musingu mwakuwi lwala na kumwasira mulitanda. ");
INSERT INTO poy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Liwoku lyaku palikutenda gutendi vidoda, gulidumuli! Iherepa nentu kwingira muukomu wa mashaka goseri pota liwoku limu kuliku kuwera na mawoku mawili na kugenda mumotu gwa Jehanamu, motu gwakuwi gutenda tiya ndiri. ");
INSERT INTO poy_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kweni watekenya wakuwi wafuwa ndiri, wala motu gutenda tiya ndiri. ");
INSERT INTO poy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na Ligulu lyaku palikutenda gutendi vidoda, gulidumuli! Iherepa nentu kwingira muukomu wa mashaka goseri pota ligulu limu, kuliku kuwera na magulu goseri mawili na kukwasira mumotu gwa Jehanamu motu gutenda tiya ndiri. ");
INSERT INTO poy_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kweni watekenya wawaluma wafuwa ndiri na motu gutenda tiya ndiri. ");
INSERT INTO poy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na lisu lyaku palikutenda gutendi vidoda, gulitupuli! Iherepa nentu kwingira Muufalumi wa Mlungu paguwera na lisu limu hera. Kuliku kuwera na masu gaku goseri mawili na kukwasira mumotu gwa Jehanamu gutenda tiya ndiri. ");
INSERT INTO poy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Amu watekenya wakuwi wawaluma wafuwa ndiri, na motu gutenda tiya ndiri. ");
INSERT INTO poy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Toziya kila yumu hawamlekeri munyu kwa motu gambira. ");
INSERT INTO poy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Munu guherepa, kumbiti pagulawa kunoga kwakuwi, hagukoleri na shishi? “Muweri na munyu mngati mwenu na mulikali weri na wayenu.” ");
INSERT INTO poy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu kawukiti paliya kagenda kumkoa gwa Yudeya na kalokiti kumwambu kulushemba Yoridani. Lipinga lya wantu limgendera kayi, yomberi kawafunda handa ntambu ya katendaga. ");
INSERT INTO poy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Su Mafalisayu wamgendera na wamkosiya kwa kumjera, “Hashi, lilagaliru lyetu limlekeziya muntu kumleka mdala gwakuwi?” ");
INSERT INTO poy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu kawakosiya, “Musa kawalagalira malagaliru gaa?” ");
INSERT INTO poy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nawombeli watakula, “Musa kalagaliriti mpalu kumupi mdala gwakuwi lilembu lya talaka na kuleka.” ");
INSERT INTO poy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu kawagambira, “Musa kawalembiriti lilagaliru ali toziya ya kukamala kwa myoyu yenu. ");
INSERT INTO poy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kwa njira kwanja Mlungu pakayiwumbiti Isi, kawawumbiti mwana mpalu na mdala. Gambira malembu ntambu yagatakuliti, ");
INSERT INTO poy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Su, mpalu hakawaleki tati gwakuwi na mawu gwakuwi, hawaweri pamuhera na mdala gwakuwi, ");
INSERT INTO poy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","woseri wawili hawaweri yumu. Kwa hangu womberi hawaweri kayi ndiri wawili ira yumu. ");
INSERT INTO poy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Su shakalemetiziyiti Mlungu, muntu nakashilekeniziya.” ");
INSERT INTO poy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pawingiriti kayi mnumba, wafundwa wakuwi wamkosiyiti shitwatira ashi. ");
INSERT INTO poy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yomberi kawagambira, “Muntu yakamleka mdala gwakuwi na kumyuga gwingi, kankuhumba. ");
INSERT INTO poy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Viraa mdala yakamleka mpalu gwakuwi na kuyugwa na gwingi, kankuhumba.” ");
INSERT INTO poy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wantu wamjegiriti Yesu wana wadidini kawatulili mawoku, kumbiti wafundwa wawakalipira wantu. ");
INSERT INTO poy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu pakawoniti hangu, kakalaliti kawagambira wantumintumi wakuwi, “Mwawaleki wana awa wizi kwa neni, namwalewalera, toziya Ufalumi wa Mlungu wa wantu gambira wana awa. ");
INSERT INTO poy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nukugambirani nakaka, muntu yoseri yakanka ndiri Ufalumi wa Mlungu gambira mwana mdidini hapeni kingiri amu.” ");
INSERT INTO poy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Shakapanu kawanka wana awa, kawakisikira na kawatekelera. ");
INSERT INTO poy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu pakanjiti kayi mwanja gwakuwi, muntu yumu kamtugiriti na kamsuntamilira na kamkosiya, “Mfunda mheri, ntendi hashi mpati ukomu wa mashaka goseri?” ");
INSERT INTO poy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu kamwankula, “Mbona gushema mheri? Kwahera yakiwiti mheri ira Mlungu gweka yakuwi. ");
INSERT INTO poy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gulimana lilagaliru, ‘Pota kuhumba, pota kulaga, pota kwiwa, pota kutakula kwa kupaya, poti kupaya, gumupi ligoya tati na mawu gwaku.’” ");
INSERT INTO poy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yomberi kamwankula, “Mfunda goseri aga nugakoliti kwanjira untemba wangu.” ");
INSERT INTO poy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu kamloliti na kamfira, kamgambira, “Gupungukiwa na shintu shimu, gugendi gukawuzi vintu vyaguweriti navi na mpiya guwayupi wahushu na gwenga hagutuli shigubakiru kumpindi, shakapanu gwizi gunfati.” ");
INSERT INTO poy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pakapikaniriti aga, kahinginikiti, moyu gumtama kagenda zakuwi toziya kaweriti kalunda. ");
INSERT INTO poy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu kagalambuka aku na aku, kawagambira wafundwa wakuwi, “Ntambu gaa hayiwi ikamala kwa walunda kwingira Muufalumi wa Mlungu!” ");
INSERT INTO poy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wafundwa walikangasha nentu kwa visoweru vyakuwi. Yesu kawagambira kayi, “Wana wangu, vikamala nentu kwingira Muufalumi wa Mlungu! ");
INSERT INTO poy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Vikamala nentu mlunda kwingira Muufalumi wa Mlungu kuliku nkanyama ngamiya kupena mushitoboli sha sindanu.” ");
INSERT INTO poy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wantumintumi wakuwi walikangasha nentu walikosiya, “Su gaa yakaweza kuponeka?” ");
INSERT INTO poy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu kawalola kawagambira, “Kwa muntu iwezekana ndiri, kumbiti kwa Mlungu vitwatira vyoseri viwezikana.” ");
INSERT INTO poy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Su Peteru kamgambira, “Na twenga hashi? Tuleka vyoseri, nakukufata!” ");
INSERT INTO poy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu kawagambira, “Nakaka nukugambirani, kila muntu yakalekiti numba ama walongu ama dada ama mawu ama tati ama wana ama malambu kwajili ya neni na kwajili ya Shisoweru Shiwagira, ");
INSERT INTO poy_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","hakanki nentu Shipindi ashi ama Hakanki mala miya numba na walongu na wafunda na wamawu na wana na malambu pamuhera na kutabika. Shipindi shiza hamuwanki ukomu wa mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kumbiti wavuwa wawaweriti wa kwanja hawaweri wa upeleru, na walii wawupeleru hawaweri wakwanja.” ");
INSERT INTO poy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Su, Yesu pamuhera na wantumintumi wakuwi waweriti mnjira kugenda Yerusalemu na Yesu kaweriti kankuwalongolera. Wafundwa wakuwi waweriti na lyoga na wantu wawalilongoziyiti nawomberi watira. Yesu kawatola kayi kumbwega walii lilongu na awili, kanja kuwagambira galii hagampati. ");
INSERT INTO poy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Mpikaniri! Twankugenda Yerusalemu na aku neni Mwana gwa muntu hawantuli kwa watambika wakulu na wafunda wa Malagaliru, womberi hawatozi kuhowa na hawanaviyi kwa wantu wayawudi ndiri. ");
INSERT INTO poy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Womberi hawamtenderi lidufiya na hawantemeri mata na hawazyatangi ndomontu na kunaga. Kumbiti pagasoka mashaka matatu hazyuki.” ");
INSERT INTO poy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Su Yakobu na Yohani wana gwa Zebedayu wamgendera Yesu wamgambira, “Mfunda tufira gututenderi shintu shatufira kukuluwa.” ");
INSERT INTO poy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu kawakosiya, “Mfira nuwatenderi shishi?” ");
INSERT INTO poy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wamwankula, “Gutujimiri kukala yumu uwega waku wa kumliwu na yumonga uwega waku wakumshigi pagulivaga mushiti sha ukwisa waku.” ");
INSERT INTO poy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu kawagambira, “Muvimana ndiri shamluwa! Hashi, mweza kulandira lutekeru lwanandira lwa kutabika, awu mweza kubatizwa ntambu ya ubatizu wa neni?” ");
INSERT INTO poy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wamwankula, “Yina tuweza.” Yesu kawagambira, “Lutekeru lwanandira hamlandiri nakaka na hawamubatiziani ntambu yanfira Kubatiziwa, ");
INSERT INTO poy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kumbiti vyaneni ndiri kusyagula ayu hakalikali kumliwu ama kumshigi kwaneni, avi vya mweni Mlungu hakawatuli wantu yakawatandiriti mpenyu zilii.” ");
INSERT INTO poy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wafundwa wamonga walii lilongu, pawapikaniriti aga, wawakalaliliti Yakobu na Yohani. ");
INSERT INTO poy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu kawashema, kawagambira, “Muvimana handa walii wawaholiriti wiwi wakola mlima wa isi zimonga wawagolokera wantu wawu kwa makakala na wakulu awa wawagolokera wantu wawu. ");
INSERT INTO poy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kumbiti kwamwenga nayiwera hangu, ira yakafira kaweri mkulu, hakaweri ntumintumi gwenu. ");
INSERT INTO poy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na muntu pakati penu yakafira kaweri mkulu, hakaweri ntumintumi gwa woseri. ");
INSERT INTO poy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Toziya Mwana gwa muntu kiza ndiri wamtenderi, ira kuwatendera na kulavia ukomu wakuwi uweri shilipira sha wantu wavuwa.” ");
INSERT INTO poy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Su wasoka Yeriku, Yesu na wafundwa wakuwi pamuhera na lipinga likulu lya wantu, pakaweriti kankulawa mulushi alu, kwaniti kana lwisi mluwa yawamshema Baritulumayu mwana gwa Timayu kaweriti kalivaga mbwega mwa njira. ");
INSERT INTO poy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Baritulumayu pakapikaniriti handa Yesu gwa Nazareti kankupita pahala palii, kabotanga, “Yesu, Mwana gwa Dawudi gumoneli lusungu!” ");
INSERT INTO poy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wantu wavua wamkalapira, “Gunyamali.” Su kanyamali. Kumbiti yomberi kongera kushema, “Mwana gwa Dawudi gumoneri lusungu!” ");
INSERT INTO poy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu kagolokiti, katakula, “Mumshemi.” Su wamshema kana lwisi ulii, wamgambira, “Gulikakamaziyi! Gugoloki, kakushema.” ");
INSERT INTO poy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yomberi kasa lihabiti lyakuwi, kakopoka, kamgendera Yesu. ");
INSERT INTO poy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu kamkosiya, “Gufira nukutenderi shishi?” Kanalwisi ulii kamgambira, “Mfunda nduwa mpati kulola.” ");
INSERT INTO poy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu kamgambira, “Gugendi, njimiru yaku ikuponiziya.” Pala palii kana lwisi ulii kaweza kulola na kamfata Yesu mnjira. ");
INSERT INTO poy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pawaweriti wapakwegera na Yerusalemu wasokiti Betifagi na Betaniya, pakwegera na Lugongu lwa Mizeyituni, palii kawatuma wawili wa wafundwa wakuwi wawalongoleri, ");
INSERT INTO poy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kawagambira, “Mgendi mushijiji sha kulongolu kwenu. Payiwera mwakwingira amu, hamwoni mwana gwa punda wamtawa, mweni kenitenderwi na muntu. Mumyopoli mumjegi. ");
INSERT INTO poy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Handa muntu pakawakosiya, ‘Mbona mtenda hangu?’ Mumgambiri, ‘Mtuwa kamfira na hakamwuziyi panu ulavinu.’ ” ");
INSERT INTO poy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Su wagenda, wamwona mwana gwa punda mumbwega munjira wamtawa mumlyangu. Pawaweriti wankumyopola, ");
INSERT INTO poy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","wantu wamu waweriti wagoloka palii wawakosiya, “Mwankumyopola punda ayu gwa shishi?” ");
INSERT INTO poy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wafundwa wawankula ntambu Yesu yakawagambiriti, nawomberi wawaleka wagendi zawu. ");
INSERT INTO poy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wamjegiriti Yesu mwana punda ayu. Wayazalira nguwu zawu pampindi pa mwana punda ulii na Yesu kakwena kalivaga pampindi pakuwi. ");
INSERT INTO poy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wantu wavuwa wayazalira nguwu zawu munjira, wamonga wayazalira miputira ya mitera yawayidumuliti mumalambu. ");
INSERT INTO poy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wantu woseri yawalongoleriti na wafatiti, wanjiti kubotanga, “Kazyumwi Mlungu! Katekelerwi uliya yakiza kwa litawu lya Mtuwa! ");
INSERT INTO poy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Utekelerwi ufalumi wiza wa tati gwetu Dawudi. Kazyumwi Mlungu gwa kumpindi nentu!” ");
INSERT INTO poy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu kingiriti lushi lwa Yerusalemu, kagenda Mnumba nkulu ya Mlungu, Kalola kila shintu weri. Kumbiti toziya iweriti kala pashimii, kagenda Betaniya pamuhera na wafundwa wakuwi lilongu na wawili. ");
INSERT INTO poy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Shirawu yakuwi, pawaweriti wankulawa Betaniya, Yesu kaniti njala. ");
INSERT INTO poy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Su kwa kutali kaguwona mkuyu gwana mihamba ivuwa. Kagugendera kawoni handa guweriti na libwajubwaju loseri. Pakasokiti, kaguwoniti gwahera libwajubwaju lyoseri ira mihamba hera, toziya iweriti ndiri shipindi sha mabwajubwaju. ");
INSERT INTO poy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Panu Yesu kagugambira mkuyu, “Kwanjira leru ata mashaka gangalikupera muntu yoseri nakaliya mabwajubwaju kwaku!” Na wafundwa wakuwi wapikiniriti visoweru avi. ");
INSERT INTO poy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Su wasokiti Yerusalemu. Yesu kingira Mnumba nkulu ya Mlungu kanja kuwawinga kunja wantu waweriti wankuwuza na kuhemera vintu. Kazigalambuziya meza zawaweriti wankuvunjira mpiya na vigoda vya walii yawaweriti wankuwuza wang'unda. ");
INSERT INTO poy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kamlekeziyiti ndiri muntu yoseri kupitira pamlangu gwa Numba nkulu ya Mlungu pakatola shintu. ");
INSERT INTO poy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Shakapanu kawafunda, “Ilembwa Mumalembu Mananagala, ‘Mlungu kalonga Numba yangu hawayishemi Numba ya kumuluwa Mlungu kwa maisi goseri!’ Kumbiti muyitenda kuwera mpanga ya wakwepula!” ");
INSERT INTO poy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Watambika wakulu na wafunda wa Malagaliru pawapikaniriti aga, wanjiti kusakula njira ya kumlaga. Kumbiti wamtiriti toziya lipinga lya wantu lilikangashiti na mafundu gakuwi. ");
INSERT INTO poy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Paiweriti pashimii, Yesu na wafundwa wakuwi wawukiti mlushi. ");
INSERT INTO poy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Shirawu yakuwi mandawira pee, pawaweriti wankupita, waguwoniti mkuyu guliya gunyala goseri, kwanjira kumishigira mpaka kumihamba ");
INSERT INTO poy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peteru kalihola visoweru vyakatakuliti Yesu, kamgambira, “Mfunda gulori! Mkuyu gulii gwagugulapiriti, gunyala!” ");
INSERT INTO poy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu kawagambira, “Mumjimiri Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Nukugambirani nakaka, muntu pakalugambira lugongu alu, ‘Gutupuki gukalyasi mulitanda,’ pota na lyoga mumoyu mwakuwi, kumbiti kajimira kuwera vitwatira vyoseri vyakatakula vinyawiki, havimnyawikili. ");
INSERT INTO poy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hangu nukugambirani, pamumluwa Mlungu shintu shoseri, mjimiri handa mshiyanka kala, namwenga hamshiyanki shintu shoseri shamuluwiti. ");
INSERT INTO poy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pamgoloka kumluwa Mlungu, gumlekiziyi kila muntu yakakutenderani vidoda, su Tati gwenu kakumpindi hakawalekiziyi mwenga vidoda vyenu.” ");
INSERT INTO poy_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kumbiti handa mwenga mulekiziya ndiri, ama Tati gwenu gwa kumpindi hapeni kawalekizii mwenga vidoda vyenu. ");
INSERT INTO poy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Su wasoka kayi Yerusalemu. Yesu pakaweriti kankugendagenda Mnumba nkulu ya Mlungu, watambika wakulu na wafunda wa malagaliru na wazewi wamgendiriti, ");
INSERT INTO poy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","wamkosiya, “Gwankutenda vitwatira avi kwa ukulu gaa? Gani yakakupiti ukulu wa kutenda vitwatira avi?” ");
INSERT INTO poy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kumbiti Yesu kawagambira, “Hanuwakosiyani shintu shimu, pamnankula, naneni vira hanuwagambirani kwa ukulu gaa nankutenda vitwatira avi. ");
INSERT INTO poy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Hashi, uwezu wa Yohani wa kubatiza ulawa kumpindi kwa Mlungu ama ulawa kwa wantu? Munankuli.” ");
INSERT INTO poy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wanja kulitakuziya, “Patutakula, ‘Ulawiti kumpindi kwa Mlungu,’ hakatukosiyi, su mbona munjimira ndiri?” ");
INSERT INTO poy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Hapeni tutakuli ulawa kwa wantu, patutakula hangu tutira lipinga lya wantu toziya woseri wajimiriti handa Yohani kaweriti mbuyi gwa Mlungu nakaka.” ");
INSERT INTO poy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Su, wamwankula Yesu, “Twenga tuvimana ndiri.” Yesu kawagambira, “Naneni vira hapeni nuwagambiri ntenda vitwatira avi kwa uwezu wa gaa.” ");
INSERT INTO poy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu kanjiti kutakula nawu kwa mifanu, “Muntu yumu kalimiti lirambu lya mizabibu. Katindiliziya shibambaza na pakati pa lirambu kabawa lirindi lya kuyonera zabibu, kanyawa lilingu lya kulolelera. Kawazimila lirambu ali kwa walimaji, mweni kagenda mpaka lushi lwa kutali. ");
INSERT INTO poy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Shipindi sha kubenanga, kamtumiti ntumintumi gwakuwi kwa walimaji walii, kamjegeri seemu ya viboga vya lirambu lyakuwi. ");
INSERT INTO poy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Walimaji walii wambata, wamkoma, wamwuziya mawoku hera. ");
INSERT INTO poy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kamtuma kayi ntumintumi yumonga, ayu viraa walimaji wamkomanga mumtuwi na kumtendera vidoda. ");
INSERT INTO poy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mweni kana lirambu ulii kamtuma kayi ndundami yumonga, walimaji awa wamlagiti. Watenditi hangu kwa wamonga wavuwa yakawatumiti, wamonga wawakomiti, na wamonga wawalaga. ");
INSERT INTO poy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kasigaliwiti na muntu yumu, yani mwana gwakuwi yakamfira. Upeleru kamtuma ayu pakalihola, ‘Hawamupanani ligoya mwana gwangu.’ ");
INSERT INTO poy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kumbiti walimaji awa waligambirana, ‘Ayu ndo Mweni mhala, tumlagi su uhala wakuwi uweri wa twenga!’ ");
INSERT INTO poy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Su, wambata, wamlaga na kumyasa kunja kulirambu lilii. ");
INSERT INTO poy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Hashi, mweni kana lirambu hakatendi shishi? Hakizi kuwalaga walimaji woseri na kuliyazimilira lirambu lya mizabibu kwa wantu wamonga. ");
INSERT INTO poy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hashi, hamwenibetuli Malembu Mananagala, ‘Libuwi lyawaliremiti wanyawa numba Vinu liwera libuwi lyaliwera na mana nentu kuliku mabuwi goseri. ");
INSERT INTO poy_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mtuwa ndo mweni yakatenditi shintu ashi, Nasheni ndo shakulikangasha kwa twenga’?” ");
INSERT INTO poy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Watambika wa numba ya Mlungu na wafunda wa malagaliru na wazewi wavimaniti handa mfanu agu guweriti kawalonga womberi. Hangu wajeriti kumbata, kumbiti watiriti lipinga lya wantu. Su wamleka kagendi zakuwi. ");
INSERT INTO poy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Su Mafalisayu wamu na wantu wa shipinga sha mfalumi Herodi wawatumiti su wamgomiziyi Yesu kwa visoweru vyakuwi. ");
INSERT INTO poy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wamgendera, wamgambira, “mfunda tuvimana handa gwenga ndo muntu yagwaminika, gutakula nakaka hera, wala gumshera ndiri muntu yoseri shakaliholiti. Gulishera ndiri ukulu wa muntu, toziya gufunda unakaka hera wa Mlungu kwa wantu. Su, gutugambiri vya halali kumupa Kaisari kodi ama ndala?” ");
INSERT INTO poy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kumbiti Yesu kavimaniti Ufyangu wawu, kawagambira, “Mbona mnjera? Mnanguziyi mpiya ligwala.” ");
INSERT INTO poy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wamlanguziya. Yomberi kawakosiya, “Sheni na shilanguliru ashi sha gaa?” Wamwankula, “Shilanguliru ashi sha Kaisari.” ");
INSERT INTO poy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Su Yesu kawagambira, “Vya Kaisari mmupanani Kaisari na vya Mlungu mmupanani Mlungu.” Walikangashira nentu. ");
INSERT INTO poy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wantu wawalawiti mushipinga sha Masadukayu, walii watakulaga kwahera muntu yakaweza kuzyuka, su wamgenderiti Yesu wamkosiya, ");
INSERT INTO poy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mfunda Musa katulagaliriti hangu, ‘Muntu pakahowa na kumleka mdala pota mwana, mlongu gwakuwi mpaka kamtoli mkenja ulii na kamyiwuliri wana mlongu gwakuwi yakahowiti.’ ");
INSERT INTO poy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Su kuweriti na walongu saba. Gwa kwanja kamyugiti, kahowa pota kumleka mwana. ");
INSERT INTO poy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mlongu gwa pili kamyuga mkenja ayu na yomberi kahowa pota kuleka mwana. Ilawiriti ntambu iraayi kwa mlongu gwa tatu. ");
INSERT INTO poy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Woseri saba wahowa pota kuleka wana. Pawupeleru mdala ulii kahowa. ");
INSERT INTO poy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Vinu wantu pawazyuka mulishaka lya kuzyuka, mawu ayu hakaweri mdala gwa gaa? Toziya woseri saba wamyugiti.” ");
INSERT INTO poy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu kawankula, “Mwenga mwagamira toziya mgamana ndiri Malembu Mananagala ama likakala lya Mlungu. ");
INSERT INTO poy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Toziya wawahowiti pawazyuka, hapeni wayugi wala kuyugwa, hawaweri handa wantumintumi wa kumpindi. ");
INSERT INTO poy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kumbiti kwa shisoweru sha kuzyukisiwa kwa wantu wawahowiti, hashi, mwenesomi mushindola sha Musa shisoweru shilii sha shitogolu shashiyakiti motu, Mlungu ntambu yakamgambiriti Musa, ‘Neni na Mlungu gwa Aburahamu na Mlungu gwa Isaka na Mlungu gwa Yakobu.’ ");
INSERT INTO poy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yomberi Mlungu ndiri gwa wawahowiti, ira Mlungu gwa wakomu. Su, mwenga mwagamira nentu!” ");
INSERT INTO poy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yumu gwa wafunda wa malagaliru kasokiti, kawapikanira Masadukayu wankulitakuziyana na Yesu. Pawawoniti Yesu kawankuliti weri, kamkosiya, “Mumalagaliru goseri, lilagaliru lyoshi likulu kuliku goseri?” ");
INSERT INTO poy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu kamwankula, “Lilagaliru likulu ndo ali, ‘Gupikiniri Israeli! Mlungu Mtuwa gwetu, ndo mweni Mtuwa gweka yakuwi. ");
INSERT INTO poy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Gumfiri Mlungu Mtuwa gwaku kwa moyu gwaku goseri na kwa rohu yaku yoseri na kwa mahala gaku goseri na kwa makakala gaku goseri.’ ");
INSERT INTO poy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na lilagaliru lya pili kwa ukulu ndo ali, ‘Guwafiri wamonga ntambu yagulifira gumweni.’ Kwahera lilagaliru limonga likulu nentu kuliku ali.” ");
INSERT INTO poy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Su ulii mfunda gwa malagaliru kamgambira, “Iherepa Mfunda! Gutakula nakaka kulonga Mlungu yumu hera na kwahera yumonga ira yomberi. ");
INSERT INTO poy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na gumfiri Mlungu Mtuwa gwaku kwa moyu gwaku goseri na kwa mahala gaku goseri na kwa makakala gaku goseri na guwafiri wamonga ntambu yagulifira gamweni. Shitwatira ashi shana mana nentu kuliku matambiku goseri gakulunguziya torosu kwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu pakawoniti handa muntu ayu kamwankula kwa luhala, kamgambira, “Gwenga gwakutali ndiri na Ufalumi wa Mlungu.” Palongolu pa aga, kwahera muntu yakajeriti kayi kumkosiya shintu. ");
INSERT INTO poy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Shipindi Yesu pakaweriti kankufunda Mnumba nkulu ya Mlungu, kakosiiti, “Mbona wafunda wa malagaliru watakula handa Kristu mwana gwa Dawudi? ");
INSERT INTO poy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawudi pakalongoziwitwi na Rohu Mnanagala katakuliti, ‘Mtuwa kamgambiriti Mtuwa gwangu, Gukali uwega wa neni wa kumliwu, Mpaka panuwatula wankondu waku pasi pa magulu gaku.’ ” ");
INSERT INTO poy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Dawudi mweni kamshema Kristu Mtuwa. Su Kristu hakaweri hashi mwana gwakuwi?” Lipinga lya wantu waweriti wankumpikinira, Lipinga lya wantu liweriti lyakumpikanira Yesu kwa kunemelera. ");
INSERT INTO poy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu pakaweriti kankufunda, katakuliti, “Mkali weri na wafunda wa malagaliru weni wafiraga kulipitiziya pitiziya walikwindira lihabiti ritali na wafira wantu wawalamsiyi kwa ligoya kusoku. ");
INSERT INTO poy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Wafiraga kulivaga muviti vya kulongolu munumba ya Mlungu, na kutola mpenyu ziherepa pamsambu ");
INSERT INTO poy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wawayonga wakenja aku wankulipayira kumluwa Mlungu kwa shipindi shitali! Lishaka lya kutoza hawatabiki nentu!” ");
INSERT INTO poy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu kaweriti kalivaga pakwegera na lisanduku lya luhanja. Kaweriti kankulola wantu wavuwa ntambu yawaweriti wankulavia mpiya na kuzitula muluhanja lwa Numba ngulu ya Mlungu. Walunda wavuwa walaviyiti mpiya zivuwa. ");
INSERT INTO poy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kiza mkenja mhushu kalaviya senti ndidika mbili zya mpiya. ");
INSERT INTO poy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Panu Yesu kawashema wafundwa wakuwi, kawagambira, “Nukugambirani nakaka, mkenja muhushu ayu kalaviya zivuwa kuliku wamonga woseri yawatuliti mpiya mulisanduku lya luhanja. ");
INSERT INTO poy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mana woseri walaviya kulawilirana na shuma shashiyogizikiti, kumbiti mawu ayu, tembera mhushu, kalaviya vyoseri vyakaweriti navi, kalaviya kila shintu shakafiriti kwa kulikala.” ");
INSERT INTO poy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu pakaweriti kankulawa Mnumba nkulu ya Mlungu, mfundwa yumu kamgambiriti, “Mfunda Guloli mabuwi aga na numba azi ntambu yaziwera za kulikangashira!” ");
INSERT INTO poy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu kamgambira, “Hashi, guziwona numba azi ngulu? Kwahera ata libuwi limu halisigali panani pa limonga, kila shintu hashibomolwi.” ");
INSERT INTO poy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu pakaweriti kalivaga kulugongu lwa Mizeyituni kulolana na Numba nkulu ya Mlungu, su Peteru na Yakobu na Yohani na Andereya wamkosiya pambwega gweka yawu. ");
INSERT INTO poy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Gutugambiri vitwatira avi havilawili ndii? Lilanguliru gaa halilanguziyi handa vitwatira avi vyapakwegera kulawira?” ");
INSERT INTO poy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu kanja kuwagambira, “Mlikali weri muntu nakiza kukuzyangani. ");
INSERT INTO poy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wantu wavuwa hawizi pawalitumiya litawu lyaneni, pawalishema, ‘Neni na Kristu!’ Womberi hawawapotuziyi wantu wavuwa. ");
INSERT INTO poy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pampikinira ngondu na tetesutetesu zya ngondu, namuwera na lyoga. Vitwatira avi mpaka vilawiri, kumbiti upeleru weni wankali. ");
INSERT INTO poy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Isi yimu hailikomi na isi imonga, ufalumi wumu haulikomi na ufalumi umonga, pahala pavuwa hapaweri na malendemeru na njala. Vitwatira avi gambira pakwanja kutama kwa kulera nonu. ");
INSERT INTO poy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mwenga mlikali weri! Mana wantu hawawajegeni kumahakama, na kuwakomanga munumba ya Mlungu, Hawawajegi palongolu pa utuwa na wafalumi toziya munjimiriti neni, su mpati kuwagambira visoweru viwagila. ");
INSERT INTO poy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mpaka huti shisoweru shiwagira shibwerwi kwa Maisi goseri. ");
INSERT INTO poy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nawomberi pawakubateni na kuwajega kumahakama, namlihola kwa galiya gamfira kutakula, shipindi shilii pashiyiza, mtakuli shoseri shakakupananeni, mana mwenga ndiri mwamfira kutakula, ira Rohu Mnanagala. ");
INSERT INTO poy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mlongu hakamgalambuki mlongu gwakuwi kalagwi na tati hakamgalambuki mwana gwakuwi na wana hawawatenduwi walera wawu na kuwalaga. ");
INSERT INTO poy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wantu woseri hawawakalalireni mwenga toziya ya litawu lyaneni. Kumbiti ulii yakahepelera mpaka upeleru ndo hakalopoziwi. ");
INSERT INTO poy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pamwona ‘Likalaliru lihalibisiya’ ligoloka pahala pakuwi ndiri, muntu yakabetula kavimani mana yakuwi, panu wantu wawawera Yudeya watugili mumigongu. ");
INSERT INTO poy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Muntu yakaweriti pampindi pashitwiku sha numba nakasuluka kwingira mnumba mwakuwi kutola shintu. ");
INSERT INTO poy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yakawera mlirambu nakawuya ukaya kutola lihabiti lyakuwi. ");
INSERT INTO poy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Shondi shondi wamawu yawawera na yinda na walii yawanoniziya mumashaka galii! ");
INSERT INTO poy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mmuluwi Mlungu vitwatira avi navilawira mashaka ga mbepu. ");
INSERT INTO poy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mana kupeluwa kwa shipindi ashi hakongeleki nentu kweni lawiri kwanjira Mlungu pakanyawiti isi mpaka leru, hapeni ilawiri kayi. ");
INSERT INTO poy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Handa Mtuwa mekapunguli ndiri mashaka aga kwahera muntu hakalopolwi. Kumbiti su kwajili ya wasyagulwa wakuwi, Mtuwa kapungula mashaka aga. ");
INSERT INTO poy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Su muntu pakawagambirani, ‘Guloli, Kristu kapanu!’ Ama ‘Ka palii!’ Namjimira. ");
INSERT INTO poy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mana hawalawili ashina Kristu wa upayira na mambuyi wa upayira, hawatendi malangaliru na mauzauza, su kuwapotuziya wasyagulwa wa Mlungu handa payiwezikana. ");
INSERT INTO poy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Su mwenga mlikali weri. Neni nukugambirani vitwatira vyoseri pamberi vyenilawiri. ");
INSERT INTO poy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Mashaka aga, pagapera kala, mshenji hagutulwi luwindu na lyezi hapeni lilangali. ");
INSERT INTO poy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ntondu hazituluki kulawa kumpindi na makakala ga kumpindi hagazitikiziyi. ");
INSERT INTO poy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Panu hawamwoni Mwana gwa muntu pakiza mumawundi na likakala likulu pamuhera na ukwisa. ");
INSERT INTO poy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Shakapanu hakawatumi wantumintumi wa kumpindi wawajojiniri wasyagulwa wakuwi kulawa wega zoseri zya musheshi za pasipanu, kulawa upeleru wa pasipanu mpaka upeleru wa mpindi. ");
INSERT INTO poy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mleki mtera gwa mkuyu guwafundi. Mitambi ya mitera payanja kunama na kutomola mahamba, muvimani kuwera shipindi sha kutowa vula shapakwegera. ");
INSERT INTO poy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ntambu iraa ayi mwenga pamwona vitwatira avi vyankulawira, muvimani handa shipindi shapakwegera nentu. ");
INSERT INTO poy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nakaka nukugambirani, shiyiwuku ashi shankupita ndiri pamberi pa vitwatira vyoseri avi kulawira. ");
INSERT INTO poy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mpindi na isi hapeni zipiti, kumbiti visoweru vyangu su hapeni vipiti. ");
INSERT INTO poy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kumbiti kwahera muntu yakavimana lishaka wala shipindi, ama ntumintumi gwa kumpindi, ama Mwana, ira Tati gweka yakuwi ndo mweni yakavimana. ");
INSERT INTO poy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mloli weri na mshenjeri, mana muvimana ndiri shipindi hashi hashisoki ndii. ");
INSERT INTO poy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Hayiweri handa muntu yakawuka ukaya kugenda mwanja pakawalekera wantumintumi wakuwi, kila yumu na lihengu lyakuwi. Shakapanu kamgambira mlolera mlyangu kaweri masu. ");
INSERT INTO poy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Su mulikali masu, toziya muvimana ndiri mweni kaya hakawuyi ndii, pamonga pamii ama pashiru ama mandawira putiputi. ");
INSERT INTO poy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Handa pakiza lindimu nakawawona mgonja. ");
INSERT INTO poy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ganawagambirani mwenga, nuwagambira wantu woseri, ‘Mshenjeri!’ ” ");
INSERT INTO poy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gasigariti mashaka mawili pamberi pa kusoka mumsambu gwa Pasaka na mabumunda gawalekera ndiri simika. Watambika wakulu wa numba ya Mlungu na wafunda wa malagaliru waweriti wankusakula njira ya kumbata Yesu wamlagi. ");
INSERT INTO poy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Su watakula, “Tuleki kumbata mumsambu gwa Pasaka, toziya wantu hawatendi ndewu.” ");
INSERT INTO poy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu kaweriti Betaniya mnumba mwa Simoni mngumbula. Pawaweriti mmeza wankuliya shiboga, mawu yumu yakaweriti na supa ya lipaki lya kununkira lya beyi nkulu kiza. Kaimega supa ayi na kamumiminira Yesu lipaki mumtuwi. ");
INSERT INTO poy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wantu wamu waweriti panu wakalaliti, walitakuliziana, “Kwa shishi kwananga lipaki linunkira ali? ");
INSERT INTO poy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gangaweziti kuwuza kwa mpiya za shibena mgongu sha shinja shimu, na kuwayupa wahushu!” Wamkalipira mawu ayu. ");
INSERT INTO poy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kumbiti Yesu kawagambira, “Mumleki, kwa shishi kumgaziya? Kantendera shintu shiherepa. ");
INSERT INTO poy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hamuweri na wahushu mashaka goseri, hamuwezi kuwatanga shipindi shoseri shamfira. Kumbiti neni hapeni nweri na mwenga mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yomberi katenda ntambu yakaweziti, kayitilira nshimba yangu lipaki linunkira kuyitandira kwa kusira. ");
INSERT INTO poy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nukugambirani nakaka, poseri muisi shisoweru shiwagira pashibwerwa, shitwatira ashi shakatenditi hashikandwi ntambu ya kulihola.” ");
INSERT INTO poy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Shakapanu Yuda Isikariyoti, yumu gwa walii lilongu na wawili, kagenditi kwa watambika wakulu su kamgalambuki Yesu. ");
INSERT INTO poy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Watambika wa numba ya Mlungu pawapikaniriti shisoweru ashi, wasekelera, wamlagiliti kumpanana mpiya. Su, Yuda kanja kusakula lupenyu lwa kamgalambukira kwa Watambika wakulu. ");
INSERT INTO poy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lishaka lya kwanja lya Msambu gwa Mabumunda gawalekera ndiri simika, shipindi sheni mwana kondolu gwa pasaka pakalikitulwa, wafundwa wakuwi wamkosiyiti, “Gufira tukutandiri koshi shiboga sha Pasaka?” ");
INSERT INTO poy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Su Yesu kawalagalira wawili wa wafundwa wakuwi pakawagambira, “Mgendi mlushi, na amu hamliwoni na mpalu yumu yakalitwika vulu ya mashi. Mmufati ");
INSERT INTO poy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mpaka mnumba yanakingiri, mkamgambiri mweni kaya, ‘Mfunda kalonga sha koshi shumba sheni handiyi Pasaka pamuhera na wafundwa wangu?’ ");
INSERT INTO poy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yomberi hakawalonguzii shumba shikulu mligolofa amu vyoseri wavitandira kala, mtutandiri amu.” ");
INSERT INTO poy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wafundwa wawuka, wagenda mlushi, wawona kila shintu weri ntambu yakawagambiriti Yesu. Su watandira shiboga sha pasaka. ");
INSERT INTO poy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Payiweriti pamii, Yesu kiziti pamuhera na wafundwa wakuwi lilongu na wawili. ");
INSERT INTO poy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pawaweriti pameza wankuliya, Yesu katakuliti, “Nakaka nukugambirani, yumu gwenu yakaliya pamuhera naneni, Hakang'alambuki.” ");
INSERT INTO poy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Panu wafundwa wakuwi wanja kulihola, yumu yumu wamkosiyiti, “Hashi, neni?” ");
INSERT INTO poy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu kawagambira, “Yumu gwenu mwenga lilongu na wawili, yakatota libumunda pamuhera naneni mubakuli. ");
INSERT INTO poy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nakaka Mwana gwa muntu hakahowi handa malembu Mananagala ntambu yagatakuliti kwakuwi, kumbiti shondi kwakuwi muntu ulii yakamgalambuka Mwana gwa muntu! Hayiweri kwa muntu ulii handa mekayiwuki ndiri!” ");
INSERT INTO poy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pawaweriti wankuliya, Yesu katoliti libumunda, kalonga mayagashii Mlungu, kalimega na kawapanana wafundwa wakuwi pakalonga, “Mtoli mlii, ayi ndo nshimba ya neni.” ");
INSERT INTO poy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Shakapanu katola lutekeru lwa divayi, kalonga mayagashii Mlungu, kawayupa, woseri walanda mulutekeru alu. ");
INSERT INTO poy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kawagambira, “Agu ndo mwazi gwangu gwagulawa kwajili ya wantu wavuwa. Mwazi gwangu gwagulanguziya lipatanu lya Mlungu na wantu. ");
INSERT INTO poy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nakaka nukugambirani, hapeni nandi kayi divayi mpaka lishaka lilii panfira kuyilanda divayi yasyayi Muufalumi wa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Shakapanu wimba lwimbu, wawuka, wagenda kulugongu lwa Mizeyituni. ");
INSERT INTO poy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu kankuwagambira wafundwa wakuwi, “Mwawoseri hamtugi na kundeka, toziya Malembu Mananagala galonga, ‘Mlungu hakamlagi mlolera gwa kondolu, Na wakondolu hawalimwagi.’ ");
INSERT INTO poy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kumbiti panzyuka kala, hanuwalongolerani Galilaya kulii!” ");
INSERT INTO poy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peteru kamgambira, “Handa woseri hawakuleki, neni hanukulemi ndiri!” ");
INSERT INTO poy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu kamgambira Peteru, “Nakaka nukugambira, pashiru panu, pamberi njogolu keniwiki mala mbili, hagunemi mala ntatu.” ");
INSERT INTO poy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kumbiti Peteru kalilapira, “Ata payiwera nfuwi pamuhera na gwenga, hanukulemi ndiri.” Wafundwa woseri viraa watakula ntambu ira ayi. ");
INSERT INTO poy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Su, wasoka mushiwunga shawashishemiti Getisemani. Yesu kawagambira wafundwa wakuwi, “Mlivagi panu Shipindi neni nankumluwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Shakapanu kawatola Peteru na Yakobu na Yohani, kanja kulishera nentu na kushashatika. ");
INSERT INTO poy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kawagambira, “Nhinginika nentu, ata sambira howa. Mkali panu na mweri masu.” ");
INSERT INTO poy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kagenda kulongolu shididini, kasuntumala makukama, kamluwa Mlungu, handa payiwezekana, shimpiti shipindi ashi sha ndabiku. ");
INSERT INTO poy_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kalonga, “Tati!, Tati gwaneni, kwa gwenga vitwatira yoseri viwezikana. Gumpusiliri lutekeru lwa ndabiku alu, kumbiti hayiweri handa ntambu yanfira neni, ira ntambu yagufira gwenga.” ");
INSERT INTO poy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Shakapanu kawuya kwa Wafundwa walii watatu, kawoniti wagonja. Su kamkosiya Peteru, “Simoni, hashi gugonja? Guwezandiri kulikala masu ata lisaa limu?” ");
INSERT INTO poy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Shakapanu kawagambira, “Mkali masu na mumluwi Mlungu su namwingira mukujerwa. Rohu ifira, kumbiti nshimba yahera likakala.” ");
INSERT INTO poy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kagenda kumuluwa Mlungu kayi pakawuyira visoweru viraa vilii. ");
INSERT INTO poy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Shakapanu kawuya kayi kwa wafundwa walii kawawoniti wagonja. Masu gawu gaweriti gana mbota. Wavimana ndiri sha kumwankula. ");
INSERT INTO poy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pakawiziriti mala ya tatu kawagambiriti, “Mwankali mwankugonja na kwoyera? Vinu itosha! Saa isoka! Muloli, Mwana gwa muntu wankumupa kwa wantu wana vidoda. ");
INSERT INTO poy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mwimuki, tugendeni zetu. Mloli, ulii yakafira kung'alambuka kapakwegera.” ");
INSERT INTO poy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu Pakaweriti kankali kankutakula, Yuda, yumu gwa wafundwa lilongu na wawili, kiza pamuhera na lipinga lya wantu wana mapanga na vindonga. Wantu awa waweriti walagalilwiti na watambika wakulu na wafunda wa Malagaliru na wazewi. ");
INSERT INTO poy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda mgalambuka kaweriti kawalanguziya lilanguliru, “ulii hanumnoneri ndo mweni, mumbati na kumjega wakamloleri.” ");
INSERT INTO poy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda pakasokiti, kamgenderiti Yesu, kamgambira, “Mfunda.” Shakapanu kamnonera. ");
INSERT INTO poy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wantu walii wambata Yesu, na kumtawa. ");
INSERT INTO poy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yumu gwa walia wawaweriti wagoloka pamuhera na Yesu, kasolomola upanga wakuwi, kamdumula likutu ntumintumi gwa Mtambika mkulu. ");
INSERT INTO poy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu kawagambira, “Vimwiza na mapanga na vindonga kumbata gambira neni na shimpegu? ");
INSERT INTO poy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kila lishaka nweriti pamuhera na mwenga panfunda Mnumba nkulu ya Mlungu, wala mumbata ndiri. Kumbiti vinu Malembu Mananagala ga kala.” ");
INSERT INTO poy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Panu wantumintumi woseri wamleka, watira. ");
INSERT INTO poy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kweniti na muntemba yumu yakaweriti kavala lishuka kaweriti kankumfata Yesu. Nawomberi wajeriti kumbata, ");
INSERT INTO poy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kumbiti yomberi kayirekiziya shuka yakuwi, katuga shivula hera. ");
INSERT INTO poy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Su wamjega Yesu kwa mtambika mkulu peni Watambika wakulu woseri na wazewi na wafunda wa malagaliru waweriti waliwona. ");
INSERT INTO poy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peteru kamfatiti Yesu kwa kutali, kingira muluwaga lwa numba ya mtambika mkulu, kalivaga pamuhera na walolera milyangu pakotera motu. ");
INSERT INTO poy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Watambika wakulu wa shiyotera motu sha Wayawudi woseri wasakula upitawu wa kumsitaki Yesu wapati kumlaga, kumbiti wapata ndiri. ");
INSERT INTO poy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wantu wavuwa walaviyiti upitawu wa kupaya kwa Yesu, kumbiti upitawu wawu ujimilirana ndiri. ");
INSERT INTO poy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Shakapanu wamonga wagolokiti, walaviya upitawu wa kupaya pawatakula, ");
INSERT INTO poy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tumpikiniriti muntu ayu pakatakula hanhalibisiyi numba nkulu ya Mlungu yawanyawiti kwa mawoku, na kwa mashaka matatu hanuinyawi imonga yawainyawa ndiri kwa mawoku.” ");
INSERT INTO poy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kumbiti ata hangu, upitawu wawu ujumilirana ndiri. ");
INSERT INTO poy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Su, mtambika mkulu kagoloka pakati pawu, kamkosiya Yesu, “Hashi, gwankula ndiri shisoweru? Wantu awa gawawoniti kwa gwenga?” ");
INSERT INTO poy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kumbiti yomberi kalikala jii katakula ndiri ata shisoweru shimu. Mtambika mkulu gwa numba ya Mlungu kamkosiya kayi, “Hashi, gwenga ndo Kristu, Mwana gwa Mlungu yawamkwisa?” ");
INSERT INTO poy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu kankula, “Neni ndo mweni. Kayi hamumoni neni Mwana gwa muntu pakalivaga uwega wa kumliwu wa Mtuwa yakawera na makakala, pakiza mumawundi ga kumpindi.” ");
INSERT INTO poy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Panu Mtambika mkulu kapapula lihabiti lyakuwi, kalonga, “Tufira ndiri kayi wakapitawu wamonga? ");
INSERT INTO poy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mpikanira kankumwigilanga Mlungu! Mwenga mwona hashi?” Woseri wamtoza, kafiruwa kuhowa. ");
INSERT INTO poy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Su, wamu wawu wanja kumtemera mata, wamgibikira sheni, wamkoma na kumgambira. “Gutungi gaa yakakukomiti!” Walolera mlyangu wamtola, wamwakula. ");
INSERT INTO poy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peteru pakaweriti kankali paluwaga, mdala yumu gwa vinyakalika gwa Mtambika Mkulu kiziti. ");
INSERT INTO poy_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pakamwoniti Peteru kankuyotera motu, kamloliti, kamgambira. “Viraa gwenga guweriti pamuhera na Yesu Mnazareti.” ");
INSERT INTO poy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peteru kalema, “Nummana ndiri, wala nuvimana ndiri gagutakula!” Shakapanu Peteru kawuka, kagenda kunja kuwuwa. Panu njogolu kawika. ");
INSERT INTO poy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Shinyankalika mdala ulii pakamwoniti kayi Peteru, kanja kayi kuwagambira wantu wawaweriti wagoloka palii, “muntu ayu yumu gwawu.” ");
INSERT INTO poy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Peteru kalema kayi. Shakapanu katepu, wantu waweriti wagoloka palii wamgambira Peteru. “Nakaka gwenga gwa yumu gwawu, mana gwenga gwa Mgalilaya.” ");
INSERT INTO poy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kumbiti Peteru kanja kulirapa, pakatakula, “Neni nummana ndiri muntu ulii yamtakula visoweru vyakuwi.” ");
INSERT INTO poy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Palaa palii njogolu kawika mala ya pili. Su Peteru kalihola ntambu Yesu pakaweriti pakamgambira, “pamberi pa njogolu keniwiki mala ya pili, hagunemi mala ntatu.” Peteru kalira. ");
INSERT INTO poy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pawushiiti, watambika wakulu wa numba ya Mlungu watenditi lishawuli pamuhera na wazewi na wafunda wa malagaliru na wantu wa shiyotera motu woseri, wamtawa Yesu pingu wamjega pashiyotera motu pa Pilatu. ");
INSERT INTO poy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatu kamkosiya Yesu, “Hashi, gwenga gwa Mfalumi gwa Wayawudi?” Yesu kamwankula, “Yina, gwenga gutakula.” ");
INSERT INTO poy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Watambika wakulu wampayiliti Yesu vitwatira vivuwa. ");
INSERT INTO poy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatu kamkosiya kayi Yesu, “Hashi gwankula ndiri shisoweru? Guloli ntambu yawalaviya masitaka gavuwa kwaku.” ");
INSERT INTO poy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kumbiti Yesu kankula ndiri shisoweru, ata Pilatu kalikangasha. ");
INSERT INTO poy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kila Shipindi sha msambu gwa Pasaka, Pilatu kaweriti na shitiba sha kuwavugulira mtatilwa yumu yawamfira. ");
INSERT INTO poy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Su, kuweriti na muntu yumu yawamshema Baraba, yakaweriti wamtatira pamuhera na wamonga wawalagiti wantu pawaweriti wakusonguziya. ");
INSERT INTO poy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wantu wavuwa wamgendera Pilatu wamluwa kawatenderi handa shitiba shakuwi. ");
INSERT INTO poy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatu kawakosiya, “Hashi, mfira nuwavuguliri Mfalumi gwa Wayawudi?” ");
INSERT INTO poy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Katakula hangu toziya kavimaniti kala handa watambika wakulu wamjegeriti Yesu toziya ya weya. ");
INSERT INTO poy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kumbiti Watambika wakulu wawasonguziyiti wantu wamluwi Pilatu kamvuguliri Baraba. ");
INSERT INTO poy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatu kawakosiya kayi, “Su, mfira ntendi hashi na muntu ayu yamumshema Mfalumi gwa Wayawudi?” ");
INSERT INTO poy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wantu woseri washowangana kayi pawatakula, “Gumkong'onderi palupingika!” ");
INSERT INTO poy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kumbiti Pilatu kawakosiya, “gwa shishi! Katenda shidoda gaa?” Kumbiti womberi wongera kushowangana, “Gumkong'onderi misumali mulupingika!” ");
INSERT INTO poy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatu kafiriti kulifiliziya lipinga lya wantu awa, su, kamlekeziya Baraba kulawa mushibetubetu. Kawagambira wanjagila wamkomi ntomondu Yesu na wamkong'onderi misumali mulupingika! ");
INSERT INTO poy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Shakapanu wanjagila wamjegiti Yesu muluwaga muliboma lya Pilati mkulu gwa isi, wawajojinira shipinga shakuwi shoseri. ");
INSERT INTO poy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wamvalisiya nguwu ya zambalawu, wapota lijenjeri lya misontu wamvalisiya mumtuwi. ");
INSERT INTO poy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wanja kumlamsiya, “Mwika Mfalumi gwa Wayawudi!” ");
INSERT INTO poy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wamkoma mumtuwi kwa ludengi, wamtemera mata, wamsuntamalira na kumng'ong'onelera. ");
INSERT INTO poy_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pawamshinigira kala wamvuliti lihabiti lilii, wamvalisiya nguwu zakuwi, shakapanu wamjega kumpingika. ");
INSERT INTO poy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pawaweriti munjira, waliwoniti na muntu yumu yawamshema Simoni, muntu gwa lushi lwa Kureni. Yomberi kaweriti tati gwa Alekizanda na Rufu na Shipindi ashi kaweriti kankulawa kulirambu. Su, wamgambira katoli lupingika lwa Yesu. ");
INSERT INTO poy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Shakapanu wamjega Yesu mpaka pahali pawapashema Goligota, mana yakuwi, “Pahala pa Shipalakasa sha mtuwi.” ");
INSERT INTO poy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wamupa divayi wahanganyikiti na mtera wagushema manimani, kumbiti yomberi kalemiti kulanda. ");
INSERT INTO poy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Su wampingika, wagawana nguwu yakuwi kwa kuzigalambuziya simbi wamuwi gaa hakapati shipandi sha nguwu. ");
INSERT INTO poy_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Iweriti saa tatu mandawira pawampingikiti. ");
INSERT INTO poy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na masitaka gakuwi gaweriti galembwa, “Mfalumi gwa Mayawudi.” ");
INSERT INTO poy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pamuhera nayomberi wapingikitwi wakwapula wawili, yumu uwega wa kumshigi na yumonga uwega wakuwi wa kumliwu. ");
INSERT INTO poy_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Su lilembu litimii lyalitakula, “Wamwalangiti pamuhera na watenda vidoda.” ");
INSERT INTO poy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wantu waweriti wankupita pahala panu wamwigilangiti, pawatikiziya mituwi yawu na kutakula, “Aha! Gwenga gutakuliti gumweni guweza kubomola Numba nkulu ya Mlungu na kunyawa kwa mashaka matatu! ");
INSERT INTO poy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Vinu, gusuluki mlupingika gulilopozii gumweni!” ");
INSERT INTO poy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nawomberi watambika wakulu pamuhera na wafunda wa malagaliru wamshinigiriti pawalitakuziana, “Kawalopoziya wamonga, kumbiti kulilopola mweni kasinda! ");
INSERT INTO poy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Eti yomberi ndo Kristu, Mtuwa gwa Israeli! Kasuluki kulawa mlupingika su tuwoni na kujimira.” Ata wantu walii wawapingikitwi pamuhera nayomberi wamlongiti. ");
INSERT INTO poy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kwanjira saa sita pamusi mpaka saa tisa kuweriti liwindu isi yoseri. ");
INSERT INTO poy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saa tisa pamii Yesu kalila kwa liziwu likulu, pakalonga, “Eloyi, Eloyi, lema sabakitani?” Mana yakuwi, “Mlungu gwangu, Mlungu gwangu mbona gundeka?” ");
INSERT INTO poy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wantu wamonga wawagolokiti paliya pawapikaniriti hangu, watakuliti, “Gupikiniri! Kankumshema Eliya.” ");
INSERT INTO poy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Muntu yumu katuga, katola lidodoki kalitawa mulupeleru lwa ludenki katota mudivayi isheshema, kamupa kalandi pakatakula, “Ebu tuloli handa Eliya hakizi kumsulusiya palupingika!” ");
INSERT INTO poy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu kabota, shakapanu kahowa. ");
INSERT INTO poy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Su, lipaziya lya Numba nkulu ya Mlungu lidegeka vipandi viwili kulawa kumpindi mpaka pasi. ");
INSERT INTO poy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mkulu yumu gwa wanjagila yakaweriti kagoloka kulongolu kwa lupingika kawoniti Yesu ntambu yakahowiti, kalonga, “Nakaka muntu ayu kaweriti Mwana gwa Mlungu!” ");
INSERT INTO poy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wadala wamu waloliti kwa kutali, muwamu mwawu kaweriti Maliya Magidalena na Salomi na Mariya mawu gwa ashina Yakobu mpusu na Yosefu. ");
INSERT INTO poy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Awa ndo wawamfatiti Yesu pakaweriti Galilaya na kumtendera. Kuweriti na wadala wamonga wavuwa wiziti Yerusalemu pamuhera na yomberi. ");
INSERT INTO poy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Shipindi sha pamii shisokiti kala. Ali liweriti Lishaka lya Matandiru, yani lishaka lyalilonguleriti Lishaka lya Kwoyera. ");
INSERT INTO poy_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Panu kiza Yosefu mwenikaya gwa Arimatayu, mjagira gwa Shiyotera motu mkulu, yawampananiti ligoya nentu. Yomberi viraa kaweriti kankulolera kwiza kwa Ufalumi wa Mlungu. Su, kamgenderiti Pilatu pota na lyoga, kaluwa wamupi nshimba ya Yesu. ");
INSERT INTO poy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatu kalikangasha kupikinira handa Yesu kahowiti kala. Su, kamshema Mkulu gwa wanjagila, kamkosiya handa Yesu kaweriti kahowa shipindi shivuwa. ");
INSERT INTO poy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilatu pawamgambiriti kala, kamgambiriti Yosefu katoli nshimba ya Yesu. ");
INSERT INTO poy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Panu Yosefu kuhemera sanda ya shitani, kasulusiya pasi mauti galiya, kaviliga sanda. Kagatula mulipumba lyaliweriti walisongola mulitalawu, shakapanu kabilingisiya libuwi likulu kumlyangu. ");
INSERT INTO poy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nawomberi Mariya Magidalena na Mariya mawu gwakuwi Yosefu wapawoniti pawagonjikiti nshimba ya Yesu. ");
INSERT INTO poy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Palipititi Lishaka lya kwoyera, Maliya Magidalena na Salomi na Mariya mawu gwakuwi Yakobu wahemeriti lipaki lya utuli wagendi kuyiswaga nshimba ya Yesu. ");
INSERT INTO poy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Su, mandawira putiputi lishaka lya Jumapili. Kwa Shigiriki jumapili walishema lishaka lya kwanja la juma, mshenji pagwanjiti kulawa wiziti Mlipumba. ");
INSERT INTO poy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nawomberi waweriti wankuligambiziyana, “Gani hakatuwusiliri libuwi lilii pamlyangu gwa lipumba?” ");
INSERT INTO poy_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kumbiti pawaloliti, wawona libuwi waliwusiya kala. Nalyeni liweriti likulu nentu. ");
INSERT INTO poy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pawayingiriti Mulipumba, wamwoniti muntemba yumu yakavaliti nguwu neru mbuu, kalivaga uwega wa kumliwu, walikangasha nentu. ");
INSERT INTO poy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kumbiti muntemba ulii kawagambira, “Namulikangasha. Mwankumsakula Yesu gwa Nazareti yawampingikiti. Kazyuka, kwahera panu. Mloli pahali pawamgonjekiti. ");
INSERT INTO poy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mgendi mkawagambiri wafundwa wakuwi pamuhera na Peteru. ‘Handa Yesu kankuwalongolera Galilaya kulii. Aku hamumwoni ntambu yakawagambireni.’ ” ");
INSERT INTO poy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Su, walawa mulipumba mlii na watuga pawashashatika kwa lyoga na kulikangasha. Wamgambira ndiri muntu yoseri shintu, toziya watira nentu ");
INSERT INTO poy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu pakazyukiti Jumapili mandawira putiputi, kalilanguziya kwanja kwa Mariya Magidalena, yomberi Yesu kaweriti kamlaviyiti washamshera saba. ");
INSERT INTO poy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariya Magidalena kagenda, kawagambira walii wawaweriti pamuhera na Yesu. Waweriti wankulira na kudaya. ");
INSERT INTO poy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kumbiti pawapikiniriti handa Yesu mkomu na Maliya Magidalena kamwona, womberi wajimira ndiri. ");
INSERT INTO poy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Shapakanu Yesu kawalawiriti wafundwa awili pakawera na sheni shingi. Wafundwa awa waweriti wankugenda kuvijiji. ");
INSERT INTO poy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nawomberi viraa wawuya na kuwagambira wayawu. Pamuhera na hangu wajimira ndiri. ");
INSERT INTO poy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Upeleru Yesu kawalawiriti wafundwa lilongu na yumu pawaweriti pamuhera pameza. Kawakalipira nentu toziya ya kujimira ndiri kwawu na mtiti gwawu, mana wawajimira ndiri walii wawaweriti wamwona pakazyukiti kala. ");
INSERT INTO poy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Su, kawagambira, “Mgendi muisi zoseri mkabweri Shisoweru shiwagira kwa wantu woseri. ");
INSERT INTO poy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yakajimira na kubatizwa hakalopoziwi. Yoseri yakajimira ndiri hakatozwi. ");
INSERT INTO poy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Walii wawajimira hawaweri na uwezu wakutenda mauzauza. Kwa litawu lyangu hawawusiyi washamshera na hawatakuli kwa likabira lyasyayi. ");
INSERT INTO poy_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pawakola njoka ama pawalanda shintu shoseri shana usungu, hapeni wayambuki. Hawawatuliri walweli mawoku, nawomberi hawaweri wakomu.” ");
INSERT INTO poy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Su, Mtuwa Yesu pakatakuliti kala nawomberi, kanyasulitwi kugenda kumpindi kwa Mlungu, kalivaga uwega wa kumliwu wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wafunda wagenda pahala poseri pawabwera. Mtuwa katenda lihengu pamuhera nawomberi na kukamaziya shawabwera kuwera sha nakaka na mauzauza gaweriti pamuhera nawomberi.");
INSERT INTO poy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mtuwa Teufili. Wantu wavua wajeriti kulemba vitwatira vyavitendikiti pakati pa twenga. ");
INSERT INTO poy_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Walembiti ntambu yawatugambiriti vilii vyawaviwoniti kwa masu gawu kwanjira pavyanjiti, na walii yawabweriti Shisoweru Shiwagira. ");
INSERT INTO poy_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Su mkulu Teufili, toziya nuvigendiriti weri vitwatira vyoseri avi kwanjira pavyanjiti, mona ifaa na neni nukulemberi weri ntambu yayirawiriti. ");
INSERT INTO poy_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ntenda hangu, su na gwenga gupati kuvimana nakaka toziya ya vitwatira avi vyanukufunditi. ");
INSERT INTO poy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Shipindi sha Herodi mfalumi gwa Yudeya, kuweriti na mkulu gwa numba ya Mlungu litawu lyakuwi wamshema Zakariya, yakaweriti gwa shipinga sha watambika sha Abiya. Mdala gwakuwi litawu lyakuwi wamshema Elizabeti nayomberi kaweriti gwa shiyiwuku sha mtambika Aruni. ");
INSERT INTO poy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Na woseri wawili waweriti wantu wa matendu gaherepa kulongolu kwa Mlungu, walikala pawagajimira malagaliru goseri ga Mtuwa. ");
INSERT INTO poy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kumbiti weriti wahera nonu, toziya Elizabeti kaweriti mpendi, vinu woseri wawili waweriti wagogolu. ");
INSERT INTO poy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lishaka limu Zakariya kaweriti kankutenda lihengu lyakuwi lya utambika Mnumba nkulu ya Mlungu, toziya shiweriti shipindi shakuwi sha kutambika. ");
INSERT INTO poy_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kulawirana na vitiba vya watambika, Zakariya kasyagulitwi kwa kugalambuziya simbi kwingira Mnumba nkulu ya Mlungu su katumiziyi ubani. ");
INSERT INTO poy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Shipindi Zakariya pakaweriti kankutumiziya ubani, lipinga lya wantu waweriti walivaga pamuhera kunja wankumluwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ntumintumi gwa kumpindi gwa Mtuwa kamlawiriti Zakariya, kagolokiti uwega wa kumliwu pashitalawanda sha kutambikira ubani. ");
INSERT INTO poy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakariya pakamwoniti, kalilimuka, kaweriti na lyoga. ");
INSERT INTO poy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kumbiti ntumintumi gwa kumpindi kamgambiriti, “Nagutira Zakariya! Mlungu kapikanira kala kuluwa kwaku. Mdala gwaku Elizabeti hakakuleleri mwana mpalu. Na mwana ayu litawu lyakuwi gumshemi Yohani. ");
INSERT INTO poy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yomberi hakaweri nemeru na nemeleru kwaku, wantu wavuwa hawaweri na nemeleru kwa kwiwuka kwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yomberi hakaweri mkulu pamasu pa Mtuwa, hakalandi ndiri divayi ama ujimbi, yomberi hakamemi Rohu Mnanagala kwanjira mumtima mwa mawu gwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hakawatendi wantu wavuwa wa Israeli wamuwuyiri Mtuwa Mlungu gwawu. ");
INSERT INTO poy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yomberi hakamlongoleri Mtuwa, hakaweri na makakala pamuhera na uwezu ntambu yakaweriti Eliya mbuyi gwa Mlungu. Hakawajegi kayi pamuhera wana na watati, hakawawuziyi wantu yawamjimira ndiri Mlungu kuwera na maholu ga wantu yawamfiriziya Mlungu na kumtandira Mtuwa wantu yawasyagulitwi.” ");
INSERT INTO poy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariya kamkosiya ntumintumi gwa kumpindi, “Hanuvimani hashi shisoweru ashi? Toziya neni pamuhera na mdala gwangu twawagogolu.” ");
INSERT INTO poy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ntumintumi gwa kumpindi kamwankula, “Neni Gaburieli yangoloka kulongolu kwa Mlungu, ndo kantuma ntakuli na gwenga na kukugambira shisoweru ashi shiwagira. ");
INSERT INTO poy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Vinu guloli! Toziya gujimira ndiri shisoweru shangu, ashi hashitendeki kwa shipindi shakuwi, vinu haguweri bubu, haguwezi ndiri kutakula mpaka lishaka lilii pashilawira shisoweru ashi.” ");
INSERT INTO poy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lipinga lya wantu liweriti lyankumuhepera Zakariya na walikangasha kwa kukawa kwakuwi mulii Mnumba nkulu ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pakalawiti kasinditi kutakula nawomberi, nayomberi kendereyiti kuwalanguziya kwa mawoku hera, nawomberi wavimaniti kuwera kawoniti shintu Mnumba nkulu ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pashiperiti kala shipindi shakuwi sha kutenda lihengu Mnumba nkulu ya Mlungu, kagenditi ukaya kwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pa mashaka galii mdala gwakuwi Elizabeti kawera na yinda, kalikaliti mnumba kwa myezi muhanu, ");
INSERT INTO poy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","kalitakuliti, “Vinu Mtuwa kamonera lusungu kwa kumusilira soni zyangu kulongolu kwa wantu.” ");
INSERT INTO poy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Yinda ya Elizabeti pasokiti myezi sita, Mlungu kamtumiti Gaburieli ntumintumi gwa kumpindi kagendi mpaka Galilaya, lushi lwa Nazareti. ");
INSERT INTO poy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kaweriti na shisoweru kwa muhinga bikira yakahetitwi na muntu yawamshema Yosefu, gwa shiyiwuku sha Dawudi, litawu lyakuwi ayu bikira ndo Mariya. ");
INSERT INTO poy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ntumintumi gwa kumpindi kamwiziriti Mariya na kumulamusiya, “Gwakashina? Ponga iweri pamuhera na gwenga! Mtuwa kapamuhera na gwenga, kakupanana upendelewu.” ");
INSERT INTO poy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariya kalisheliti nentu, toziya ya shisoweru sha ntumintumi gwa kumpindi, kaliholiti mumoyu pakalikosiya, “Kulamusiya aku kwana mana gaa?” ");
INSERT INTO poy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ntumintumi gwa kumpindi kamgambiriti Mariya, “Nagutira Mariya, Mlungu kakupapanana manemu. ");
INSERT INTO poy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Guloli, haguweri na yinda na kwiwula mwana mpalu na litawu lyakuwi hagumshemi Yesu. ");
INSERT INTO poy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ayu hakaweri mkulu, hawamshemi mwana gwa Mlungu na Mtuwa Mlungu hakampanani shibanta sha ufalumi sha Dawudi mbuyi gwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Hakakolimlima lukolu lwa Yakobu mashaka goseri na ufalumi wakuwi hapeni uweri na upeleru.” ");
INSERT INTO poy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariya kamgambiriti ntumintumi gwa kumpindi, “Neni haneliwoni na mpalu! Hashiweri ashi shisoweru ashi?” ");
INSERT INTO poy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ntumintumi gwa kumpindi kamuwankula, “Rohu Mnanagala hakizi kwaku na makakala ga Mlungu hagakwizili. Toziya ayi mwana hakiwukili hakaweri mnanagala, hakashemwi Mwana gwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Gumuholi mlongu gwaku Elizabeti, yomberi yawamshemiti mpendi kumbiti hakaleri mwana mpalu muugogolu wakuwi na mwezi agu ndo mwezi gwa sita kwa yinda yakuwi. ");
INSERT INTO poy_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Toziya kwahera shintu shashikamala kwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariya katakula, “Neni na ntumintumi gwa Mtuwa! Iweri kwa neni ntambu ya gulongiti.” Ntumintumi gwa kumpindi kawukiti na kugenda zakuwi. ");
INSERT INTO poy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mashaka galii Mariya kawukiti kagenditi mpaka isi ya mulugongu lwa Yudeya. ");
INSERT INTO poy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aku kingiriti mnumba mwa Zakariya na kamlamsiyiti Elizabeti. ");
INSERT INTO poy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeti pakapikaniriti ntambu Mariya yakamlamsiyiti, nonu kadunkula mumtima mwakuwi. Elizabeti kamemiti Rohu Mnanagala, ");
INSERT INTO poy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elizabeti kalonga, “Gutekelerwa gwenga pakati pa wadala woseri na katekelerwi mwana hakiwukili mumtima mwaku. ");
INSERT INTO poy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Neni na gaa ata mawu gwa Mtuwa gwangu kanizili neni? ");
INSERT INTO poy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nakugambira, palaa pampikaniriti ntambu yagunamusiyiti, nonu kadunkula kwa kunemelera mumtima mwangu. ");
INSERT INTO poy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mbaka gwenga toziya gujimira kuwera havitendeki vitwatira vyakakugambiriti Mtuwa.” ");
INSERT INTO poy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariya kalonga, “Moyu gwangu gumkwisa Mtuwa, ");
INSERT INTO poy_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Na rohu yangu yankunemelera, Toziya Mlungu ndo Mlopoziya gwangu. ");
INSERT INTO poy_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Toziya kamonera lusungu neni ntumintumi gwakuwi. Kwanjira vinu wantu woseri hawalongi Mlungu kantekelera, ");
INSERT INTO poy_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Toziya ya shintu shikulu shakantendera Mlungu. Litawu lyakuwi linanagala. ");
INSERT INTO poy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kawalanguziya lusungu lwakuwi Kwa walii yawampanana ligoya kwa shiyiwuku na shiyiwuku. ");
INSERT INTO poy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Katenda vitwatira vikulu kwa liwoku lyakuwi, Kawapalasiya yawawera na msindu pamuhera na mipangu ya myoyu yawu. ");
INSERT INTO poy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kawasulusiya yawawera na likakala mu ukolamlima wawu, Na kawakweniziya wananagala. ");
INSERT INTO poy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yawawera na njala kawayikutiziya vintu viherepa, Na walunda kawawusiya mawoku hera. ");
INSERT INTO poy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Katenda shakatakuliti kwa wambuyi wetu wagona, Kiza kumtanga Israeli ntumintumi gwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ntambu vyakawagambiriti wambuyi wetu, Aburahamu na wiwuka wakuwi mashaka goseri!” ");
INSERT INTO poy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariya kalikaliti pamuhera na Elizabeti kwa shipindi sha myezi mitatu, shakapanu kawuyiti ukaya kwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Shipindi sha Elizabeti kwiwura shisokiti, kiwuliti mwana mpalu. ");
INSERT INTO poy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wantu wapakwegera wakuwi na walongu wakuwi pawapikaniriti visoweru viherepa vya kulikangasha Mtuwa vyakavitenditi kwa Elizabeti, womberi wanemeleriti pamuhera na yomberi. ");
INSERT INTO poy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Palipititi lijuwa limu, womberi wiziti kumwingiziya jandu mwana, wafira kumpanana litawu lya tati gwakuwi, Zakariya. ");
INSERT INTO poy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kumbiti mawu gwakuwi kalonga, “Hangu ndiri! Litawu lyakuwi hawamshemi Yohani.” ");
INSERT INTO poy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wamgambira, “Kwehera muntu muwalongu waku yawamshema litawu ali!” ");
INSERT INTO poy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Wamlanguziyiti langaliru tati gwakuwi, wavimana ntambu hakamshemi. ");
INSERT INTO poy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakariya kaluwiti shibawu na kalemba hangu, “Litawu lyakuwi ndo Yohani.” Kila muntu kalikangasha. ");
INSERT INTO poy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pala palii Zakariya kanjiti kayi kutakula, kanjiti kumkwisa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Lyoga lyayingiriti woseri yawalikaliti pakwegera nayomberi na visoweru avi vyoseri vyeniyiti muisi yoseri ya mulugongu mwa Yudeya. ");
INSERT INTO poy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Woseri yawapikaniriti vitwatira avi, waliholiti mumyoyu mwawu pawalonga, “Mwana ayu hakaweri gwa ntambu gaa?.” Toziya nakaka makakala ga Mtuwa hagaweri pamuhera nayomberi. ");
INSERT INTO poy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakariya, tati gwa Yohani kamemiziwiti Rohu Mnanagala, katungiti shisoweru shiwagira sha Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Tumkwisi Mtuwa, Mlungu gwa Israeli! Kiza kuwatanga wantu wakuwi na kuwakombola. ");
INSERT INTO poy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Katupanana mlopoziya mkulu Mushiyiwuku sha Dawudi ntumintumi gwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Gambira ntambu yakawagambiriti wambuyi wa Mlungu wananagala kwanjira kwanja. ");
INSERT INTO poy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Hakatulopoziyi kulawa mumawoku mwa wangondu wetu na kutulaviya kulawa mumakakala mwa woseri yawatufira ndiri. ");
INSERT INTO poy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kalongiti hakawawoneri lusungu wambuyi wetu, na kulihola lipatanu lyakuwi linanagala. ");
INSERT INTO poy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kulirapa kwakamlapiriti Aburahamu mbuyi gwetu, ");
INSERT INTO poy_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kuwera hakatutangi twenga tulopoziwi kulawa kwa wangondu wetu. Katugambira tumtenderi Mlungu pota na lyoga, ");
INSERT INTO poy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tuweri wananagala yatumfiriziya Mlungu mashaka goseri ga makaliru getu. ");
INSERT INTO poy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Na gwenga mwana gwangu, hawakushemi mbuyi gwa Mlungu kakumpindi nentu. Toziya hagumlongoleri Mtuwa kumnyawila njira yakuwi, ");
INSERT INTO poy_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","haguwagambiri wantu wakuwi kuwera hawalopoziwi kwa kuwawusilira vidoda vyawu. ");
INSERT INTO poy_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mlungu gwetu mnanagala na yakawera na lusungu. Hakatulavilili gulangala gwa ulopoziya kulawa kumpindi, ");
INSERT INTO poy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na kawalangazira woseri yawalikala muluwindu lwa kuhowa, na kuwalonguziya magulu getu munjira ya ponga.” ");
INSERT INTO poy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwana kendereyiti kukula nshimba na kuwera na makakala murohu. Kalikaliti kushiwala mpaka lishaka lya kuliranguziya mweni kwa wantu wa Israeli. ");
INSERT INTO poy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Majuwa galii, Kaisari Agustinu mfalumi gwa Rumi kabweriti kulagalira, wantu woseri wa Iushi loseri la Rumi wawalangwi. ");
INSERT INTO poy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kuwawalanga aku ndo kuweriti kwa kwanja shipindi Kureniu pakaweriti mkulu gwa mukowa gwa Siriya. ");
INSERT INTO poy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Su kila muntu kagenditi kulembwa litawu lyakuwi muisi mwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Viraa Yosefu kaweriti na mwanja gwa kulawa Nazareti mumkowa gwa Galilaya, kagenditi muisi ya Betirehemu mumkowa gwa Yudeya pakayiwukiti Dawudi. Yosefu kagenditi kulii toziya kalawiti mushiyuwuku sha Dawudi. ");
INSERT INTO poy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kagenditi kulii wakalembwi pamuhera na Mariya muheta gwakuwi, yakaweriti na yinda. ");
INSERT INTO poy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pawaweriti kulii Betirehemu, shipindi sha Mariya sha kwiwura mwana shisokiti. ");
INSERT INTO poy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kamwiwula mwana gwakuwi gwa kwanja mpalu, kamgubikila nguwu na wamgonjeka muliboma lya wang'ombi, toziya womberi wapatiti ndiri pakugonja kunumba ya wahenga. ");
INSERT INTO poy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kuweriti na walolera wa mifugu, yawaweriti kuntundu pashiru wankulolera mifugu yawu. ");
INSERT INTO poy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ntumintumi gwa kumpindi gwa Mtuwa kawalawariti walolera wa mifugu na ukwisa wa Mtuwa guwalangaziya. Womberi watiliti nentu, ");
INSERT INTO poy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","kumbiti ntumintumi gwa kumpindi kawagambira, “Namtira! Neni nuwajegerani shisoweru shiwagira, shisoweru ashi hashiwajegeli wantu woseri wanemeleri nentu. ");
INSERT INTO poy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Leru muisi ya Mfalumi Dawudi kiwuka Mlopoziya gwenu. Mweni ayu ndo Kristu Mtuwa! ");
INSERT INTO poy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ayi haliweri lilangaliru kwa mwenga, pamusoka kala palii hamumwoni nonu wamgubikira vinguwu vya shiwana wamgonjeka muliboma la wang'ombi.” ");
INSERT INTO poy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Palaa palii wantumintumi wamonga wa kumpindi wavuwa nentu, waliwoniti pamuhera wamkwisiti Mlungu, pawalonga, ");
INSERT INTO poy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ukwisa uweri kwa Mlungu kumpindi nentu, na ponga iweri pasipanu kwa wantu yawamfira Mlungu!” ");
INSERT INTO poy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wantumintumi wa kumpindi pawawukiti kala kuwuya kumpindi kwa Mlungu, walolera wa mifugu wanja kuligambira weni, “Vinu su tugendeni Betirehemu na kulola shintu shashitendikiti, shakatugambiriti Mtuwa.” ");
INSERT INTO poy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Su wawuka wagenda kanongola, pawasokiti palii wawawona Mariya na Yosefu na nonu ulii wamgonjeka muliboma la wang'ombi. ");
INSERT INTO poy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Walolera wa mifugu pawamwoniti kala nonu ulii, su wanja kutakula ntambu yawapikaniriti kulawa kwa ntumintumi gwa kumpindi kuusu nonu ayu. ");
INSERT INTO poy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Muntu yoseri yakapikaniriti hangu kashyeniti visoweru vyawatakuliti walolera wa mifugu. ");
INSERT INTO poy_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariya kavituliti vintu vyoseri avi mumoyu mwakuwi na kavihola mana yakuwi. ");
INSERT INTO poy_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Walolera wa mifugu wawuyiti pawayimba kwa kumkwisa Mlungu ntambu yawapikaniriti na yawawoniti, iwera ntambu iraa ilii yawapikaniriti kulawa kwa ntumintumi gwa kumpindi. ");
INSERT INTO poy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Palisokiti lishaka lya nani, shipindi sha kumwingiziya mwana jandu, wampananiti litawu Yesu, litawu lyeni ali ntumintumi gwa kumpindi kamupananiti kala Mariya pakaweriti ndiri na yinda. ");
INSERT INTO poy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Pashisokiti shipindi sha msambu gwa kupungwa kwawu Mariya na Yosefu hangu ndo ifiriwitwi mumalagaliru ga Musa, wamtola mwana wagenda nayu Yerusalemu wamtulili Mtuwa, ");
INSERT INTO poy_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ntambu yayilembitwi mumalagaliru ga Mtuwa, “Kila mwana gwa kwanja mpalu kafiruwa kutulwa kaweri mnanagala kwa Mtuwa.” ");
INSERT INTO poy_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Viraa virii wagenditi su walaviyi tambiku ya wankunda wawili ama wana wawili wa teteli, ntambu yayifiruwitwi mulilagaliru ga Mtuwa. ");
INSERT INTO poy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Shipindi shiraa shilii kuweriti na muntu yumu yawamshema Simoni yakalikaliti Yerusalemu. Kaweriti muntu kaherepa, muntu yakamfiriziya Mlungu na kaweriti kankulolera kulopoziwa kwa wantu wa Israeli. Rohu Mnanagala kaweriti pamuhera na yomberi, ");
INSERT INTO poy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","na Rohu Mnanagala kamgambiriti kala Simiyoni kulonga hapeni kahowi mpaka kamwoni Kristu yakasyagulitwi na Mtuwa. ");
INSERT INTO poy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Su Rohu Mnangala kamlonguziyiti Simiyoni kwingira Mnumba nkulu ya Mlungu. Na palii mawu na tati gwa Yesu wamjegiti Yesu Mnumba nkulu ya Mlungu wamtenderi ntambu yayifiruwitwi mulilagaliru, ");
INSERT INTO poy_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyoni kamwanka mwana mumawoku mwakuwi na kamkwisa Mlungu pakalonga, ");
INSERT INTO poy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Vinu Mtuwa guweza kumlekeziya ntumintumi gwaku kagendi kwa ponga, toziya gugatimiza galii gagulagaliriti. ");
INSERT INTO poy_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Masu gangu gawona ulopoziya waku, ");
INSERT INTO poy_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wawutandiritwi palongolu pa wantu woseri. ");
INSERT INTO poy_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ulangala hawuwalangaziyi njira wantu wawawera ndiri Wayawudi na hawujegi ukwisa kwa wantu waku Israeli.” ");
INSERT INTO poy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tati na mawu gwa mwana walikangashiti nentu ntambu yakatakuliti Simiyoni kuusu mwana gwawu. ");
INSERT INTO poy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simoni kawatekelera, kamgambira Mariya mawu gwa Yesu, “Mwana ayu kasyagulitwi na Mlungu toziya ya kwagamira na kulopoziwa kwa wantu wavuwa Muisraeli. Nayomberi hakaweri lilangaliru kulawa kwa Mlungu kumbiti wantu wavuwa hawamtakuli vidoda, ");
INSERT INTO poy_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","na virii vyawalihola wantu mumyoyu mwawu ndo havimaniki. Na gwenga Mariya utama hawuweri gambira mgoha gwagusongoka, haguwusomi moyu gwaku.” ");
INSERT INTO poy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Palii kuweriti na mdala mbuyi gwa Mlungu, litawu lyakuwi Ana, mwana gwa Fanueli gwa likabila la Asheri. ");
INSERT INTO poy_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Shakapanu kasigaliti mkenja mpaka shipindi pakiwiti mgogolu gwa vinja malongu matatu na msheshi. Shipindi shoseri ashi kalikaliti Munumba nkulu ya Mlungu pakaleka kuliya na pakamluwa Mlungu pashiru na paliwala. ");
INSERT INTO poy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Shipindi shila shilii, Ana kiziti na kulonga mayagashii Mlungu na katakuliti visoweru vya mwana kwa wantu woseri wawaweriti wankumuhepera Mlungu kwa kukombolwa kwa Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Maliya na Yosefu pawatenditi kala vyoseri ntambu yanfiruwitwi mulilagaliru ga Mtuwa, su wawuyiti ukaya kwawu Nazareti muisi ya Galilaya. ");
INSERT INTO poy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana kakula kawera na makakala, su kawera na luhala na Mlungu kamtekelera. ");
INSERT INTO poy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kila mvinja mawu na tati gwa Yesu wagendaga Yerusalemu mumsambu gwa Pasaka. ");
INSERT INTO poy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu pakaweriti na vinja lilongu na miwili, wagenditi nayu mumsambu ntambu yayiweriti shitiba. ");
INSERT INTO poy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Paguperiti kala msambu gwa Pasaka, wanjiti mwanja gwa kuwuya ukaya, kumbiti Yesu kasigaliti kulaa Kuyerusalemu pota mawu na tati gwakuwi kuvimana. ");
INSERT INTO poy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Womberi wavimana Yesu kapamuhera na wantu wa mwanja, wagendagenda lishaka lyoseri, shakapanu wanja kumsakula mwa walongu na waganja wawu. ");
INSERT INTO poy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wamwona ndiri, su wawuyiti Yerusalemu pawamsakula. ");
INSERT INTO poy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Lishaka lya tatu wamwoniti Mnumba nkulu ya Mlungu, kalikaliti pamuhera na wafunda wa Mayawudi, kaweriti pakawapikinira na kuwakosiya. ");
INSERT INTO poy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Woseri pawampikaniriti vyakatakula, waweriti wankulikangasha ntambu yakeniti mahala na ntambu yakankuliti kwa luhala. ");
INSERT INTO poy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mawu na tati gwakuwi pawamwoniti washeniti. Maliya, mawu gwakuwi, kamkosiya, “Mwana gwenga, ashi gututenda ntambu ayi? Neni na tati gwaku tuweriti twankulishera patukusakula.” ");
INSERT INTO poy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu kawankula, “Ntambu gaa mwankunsakula? Muvimana ndiri handa nfiruwa nulikali mnumba mwa Tati gwangu?” ");
INSERT INTO poy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kumbiti tati na mawu gwakuwi wavimana ndiri vyakawankuliti. ");
INSERT INTO poy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesu pakawuyiti pamuhera na mawu na tati gwakuwi Kunazareti, kendereyiti kuwajimira. Mawu gwakuwi kendeleyiti kulihola mmoyu mwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu kendereyiti kukula munshimba pamuhera na luhala na kumfiliziya Mlungu pamuhera na wantu. ");
INSERT INTO poy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mushinja sha lilongu na muhanu wa ukolamlima wa Kaisari Tiberiwu, Pontiwu Pilatu kaweriti mkolamlima gwa Yudeya, Herodi kaweriti mkolamlima gwa mkowa gwa Galilaya na Filipi mlongu gwakuwi kaweriti mkolamlima gwa mikowa ya Itureya na Trakuniti. Lusaniya kaweriti mkolamlima gwa Abileni, ");
INSERT INTO poy_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","na Anasi na Kayafa waweriti watambika wakulu, shipindi ashi shisoweru sha Mlungu shimwizira Yohani mwana gwa Zakariya kushiwala kulii. ");
INSERT INTO poy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Su Yohana kagenda pahala poseri papaweriti na lushemba Yoridani kaweriti kankubwera pakalonga, “Mleki vidoda vyamtenditi na mkabatizwi, su Mlungu hakawalekiziyi vidoda vyamtenditi.” ");
INSERT INTO poy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ayi ndo yawalembiti mushintola sha mbuyi gwa Mlungu Isaya, “Liziwu lya muntu lipikanika kushiwala, ‘Mumtenderi kala Mtuwa njira yakuwi, mumnyawili weri njira zyakuwi!’” ");
INSERT INTO poy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“ ‘Kila shibokela hawashifintili, Kila lugongu na shigongu hashipalaswi, Paweriti padusunka hapanyoshwi, Zinjira za vuluvulu hazinyawi. ");
INSERT INTO poy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wantu woseri hawawuwoni ulopoziwu wa Mlungu!’ ” ");
INSERT INTO poy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Lipinga lya wantu liziti kwa Yohani su wabatizwi. Yomberi kawagambira, “Mwenga mwashiyiwuku sha wanjoka, kakugambirani gaa mtugi maya ga Mlungu gagiza? ");
INSERT INTO poy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mulanguziyi nakaka ntambu yamutenda handa mleka vidoda vyamtenditi. Namwanja kulonga, ‘Twenga Aburahamu ndo mbuyi gwetu!’ Nukugambirani nakaka, Mlungu tembera katendi ata mabuwi aga gaweri wana wa Aburahamu! ");
INSERT INTO poy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Su vinu liwagu litulwa kala kudumula mishigira ya mitera, na kila mtera gwagulera ndiri mabwajubwaju gaherepa, hagudumulwi na kugwasila mumotu.” ");
INSERT INTO poy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Wantu wamkosiyiti Yohana Mbatiza, “Su twenga tutendi hashi?” ");
INSERT INTO poy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yomberi kawankula, “Yakana nguwu mbili kamupi kahera nguwu na yakana shiboga na yomberi katendi ntambu iraayi.” ");
INSERT INTO poy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Watola kodi wiziti wabatizwi, wamkosiya, “Mfunda na twenga tutendi hashi?” ");
INSERT INTO poy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kawagambira, “Namtola kodi nentu ya shiyasi shawatuliti.” ");
INSERT INTO poy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na wamanjagila wamkosiya, “Na twenga tutendi ashi?” Su yomberi kawankula, “Mwenga mleki kuwapoka wantu vintu vyawu, ama kuwasitaka wantu pamuwapayira hera. Mjimili shibena mgongu shampata.” ");
INSERT INTO poy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wantu woseri waweriti wankulolera kwiza kwa Mlopoziya, waweriti wankulikosiya mumyoyu mwawu Yohani, ndo Kristu? ");
INSERT INTO poy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Paliya Yohani kuwagambira woseri, “Neni nankubatiza kwa mashi, kumbiti kwana muntu kiza kana uwezu kuliku neni. Neni weza ndiri kuyopola lugoyi lwa kutawira shiyatu shakuwi. Mweni ayu hakakubatizani kwa Rohu Mnanagala na kwa motu. ");
INSERT INTO poy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yomberi mumawoku mwakuwi kana luselu lwa kupetera, hakayijojiniri nganu na kuitula muluhanja lyakuwi, kumbiti hakatoli miwawi na kuipambira pamotu gwagutenda ndiri tiya.” ");
INSERT INTO poy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kwa visoweru vivuwa Yohani kaweriti kankuwabwelera wantu visoweru viheri, kankuwagambira wantu waleki vidoda vyawatenda. ");
INSERT INTO poy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yohani kamkalipiriti Herodi yakaweriti mkola mlima gwa mukowa, toziya kaweriti kamupoka Herodiya yakaweriti mdala gwa mlongu gwakuwi na katenditi vintu vivuwa vidoda nentu. ");
INSERT INTO poy_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Su Herodi katenditi shidoda nentu kwa kamtatira Yohani mushibetubetu. ");
INSERT INTO poy_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wantu woseri pawawabatiziti kala, Yesu wambatiziti vilavi. Pakaweriti kankuluwa, kumpindi kuvuguka, ");
INSERT INTO poy_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Rohu Mnanagala kamsulukira kaweriti gambira mpongu mfanu gwa ngunda, liziwu lipikanika kulawa kumpindi palilonga, “Gwenga gwa mwana gwangu yanukufira. Gunhelepera” ");
INSERT INTO poy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu pakanjiti lihengu lyakuwi kaweriti na mivinja milongu mitatu. Su wantu wamaniti hangu, Yesu kaweriti mwana gwa Yosefu na Yosefu kaweriti mwana gwa Heli. ");
INSERT INTO poy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli kaweriti mwana gwa Matati na Matati yakaweriti mwana gwa Lawi, shakapanu kayi Lawi mwana gwa Maliki na Maliki kaweriti mwana gwa Yanayi kaweriti mwana gwa Yosefu. ");
INSERT INTO poy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosefu kaweriti mwana gwa Matatiya na Matatiya kaweriti mwana gwa Amosi Amosi kaweriti mwana gwa Nahumu na Nahumu kaweriti mwana gwa Hesli na Hesli kaweriti mwana gwa Nagayi. ");
INSERT INTO poy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi kaweriti mwana gwa Maati na Maati kaweriti mwana gwa Matatiya na Matatiya kaweriti mwana gwa Shemeni na Shemeni kaweriti mwana gwa Yoseki na Yoseki kaweriti mwana gwa Yuda. ");
INSERT INTO poy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yuda kaweriti mwana gwa Yohanani na Yohanani kaweriti mwana gwa Resa na Resa kaweriti mwana gwa Zerubabeli na Zerubabeli kaweriti mwana gwa Sheatiyeli na Sheatiyeli mwana gwa Neri. ");
INSERT INTO poy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri kaweriti mwana gwa Maliki na Maliki mwana gwa Adi na Adi kaweriti mwana gwa Kosamu na Kosamu kaweriti mwana gwa Elimadamu na Elimadamu kaweriti mwana gwa Eri. ");
INSERT INTO poy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri mwana gwa Yoshuwa na Yoshuwa kaweriti mwana gwa Eliazeri Eliazeri kaweriti mwana gwa Yorimi na Yorimi kaweriti mwana gwa Matati na Matati kaweriti mwana gwa Lawi. ");
INSERT INTO poy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi kaweriti mwana gwa Simiyoni na Simoni kaweriti mwana gwa Yuda na Yuda kaweriti mwana gwa Yosefu na Yosefu kaweriti mwana gwa Yonamu na Yonamu kaweriti mwana gwa Eliyakimu. ");
INSERT INTO poy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakumu kaweriti mwana gwa Melea na Melea kaweriti mwana gwa Mena na Mena kaweriti mwana gwa Matati na Mataha kaweriti mwana gwa Natani na Natani kaweriti mwana gwa Dawudi. ");
INSERT INTO poy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawudi kaweriti mwana gwa Yese na Yese kaweriti mwana gwa Obedi na Obedi kaweriti mwana gwa Boazi na Boazi kaweriti mwana gwa Salimoni na Salmoni kaweriti mwana gwa Nashoni. ");
INSERT INTO poy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashoni kaweriti mwana gwa Aminadabu na Aminadabu kaweriti mwana gwa Adimini na Adimini kaweriti mwana gwa Arini na Arini kaweriti mwana gwa Hesironi na Hesroni kaweriti mwana gwa Peresi na Peresi kaweriti mwana gwa Yuda. ");
INSERT INTO poy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda kaweriti mwana gwa Yakobu na Yakobu kaweriti mwana gwa Isaka na Isaka kaweriti mwana gwa Aburahamu na Aburahamu kaweriti mwana gwa Tera na Tera kaweriti mwana gwa Nahori. ");
INSERT INTO poy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahori kaweriti mwana gwa Serugi na Serugi kaweriti mwana gwa Reu na Reu kaweriti mwana gwa Pelegi na Pelegi kaweriti mwana gwa Eberi na Eberi kaweriti mwana gwa Sala. ");
INSERT INTO poy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala kaweriti mwana gwa Kaini na Kaini kaweriti mwana gwa Arifakisadi na Arifakisadi kaweriti mwana gwa Shemu na Shemu kaweriti mwana gwa Nuhu na Nuhu kaweriti mwana gwa Lameki. ");
INSERT INTO poy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameki kaweriti mwana gwa Matusala na Matusala kaweriti mwana gwa Henoki na Henoki kaweriti mwana gwa Yaredi na Yaredi kaweriti mwana gwa Mahalaleli na Mahalaleli kaweriti mwana gwa Kenani. ");
INSERT INTO poy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenani kaweriti mwana gwa Enosi na Enosi kaweriti mwana gwa Seti na Seti kaweriti mwana gwa Adamu na Adamu kaweriti mwana gwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu kalawiriti mulishemba mwa Yoridani, pakamema makakala ga Rohu Mnanagala na Rohu Mnanagala kamlonguziyiti Yesu kugenda kushiwala. ");
INSERT INTO poy_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kushiwala kulii, Shetani kamjeriti Yesu mashaka malongu msheshi. Shipindi shoseri ashi Yesu hakeniliyi shintu, pagapititi kala mashaka aga Yesu kaweriti na njala. ");
INSERT INTO poy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Shetani kamgambiriti Yesu, “Handa gwenga gwa Mwana gwa Mlungu, guligambiziyi libuwi ali liweri libumunda.” ");
INSERT INTO poy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kumbiti Yesu kamwankula, “Galembwa, ‘Muntu hapeni kalikali kwa libumunda hera.’ ” ");
INSERT INTO poy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Palaa paliya Shetani kamlonguziyiti Yesu na kumkweniziya pahala pampindi na kumlanguziya ufalumi wa pasipanu poseri. ");
INSERT INTO poy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Shetani kamgambiriti Yesu, “Hanukupi uwezu wa falumi zoseri na lunda zyakuwi mana wanupa neni vyoseri, panfira kumupa muntu yoseri, weza. ");
INSERT INTO poy_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Vyoseri avi haviweri lunda zyaku gwenga handa pagung'uwira neni.” ");
INSERT INTO poy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu kamuwankula, “Galembwa, ‘Gumguwiri Mtuwa Mlungu gwaku na kumtendera yomberi gweka yakuwi.’ ” ");
INSERT INTO poy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Shetani kamjega Yesu mpaka Yerusalemu, kamkweniziya Pashitwiku pa Numba nkulu ya Mlungu, kamgambira, “Handa gwenga gwa Mwana gwa Mlungu, guliyasi pasi. ");
INSERT INTO poy_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Toziya galembwa, ‘Mungu hakawagambiri wantumintumi wakuwi wa kumpindi wakuloleli weri. ");
INSERT INTO poy_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kayi galembwa hawakutoli mumawoku mwawu pota na kulikwala ligulu lyaku mulibuwi.’ ” ");
INSERT INTO poy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kumbiti Yesu kamwankula, “Galonga, ‘Nagumjera Mtuwa Mlungu gwaku.’ ” ");
INSERT INTO poy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Shetani pakamjeriti kala Yesu kwa kila njira kasinda, kamleka kwa shipindi na kagenda zakuwi. ");
INSERT INTO poy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu pakawuyiti Galilaya, keweriti kamema likakala lya Rohu Mnanagala. Shisoweru shakuwi shieneyiti pahala poseri pakwegera. ");
INSERT INTO poy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nayomberi kawera pakawafunda wantu mnumba zawu za Mlungu, woseri wamkwisa. ");
INSERT INTO poy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Su Yesu kagenditi Nazareti, pahala pakaleleritwi na lishaka lya kwoyera kingira munumba ya Mlungu ntambu yayiweriti shitiba shakuwi. Kagoloka kabetuli malembu mananagala kwa liziwu. ");
INSERT INTO poy_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kawanka shindola sha Mbuyi gwa Mlungu Isaya, kashivugula na kuwona pahala pawalembiti, ");
INSERT INTO poy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Rohu gwa Mtuwa kapamuhera na neni, Toziya kansyagula neni nuwajegeli shisoweru shiwagira kwa wahushu. Kantuma nuwagambiziyi watatirwa kuvugulirwa kwawu Na wanalwisi wapati kuwona, Wantuma nuwalopoziyi woseri wonewa, ");
INSERT INTO poy_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na kushibwelera shipindi shilii shankwiza, Mtuwa hakawalopoziyi wantu wakuwi.” ");
INSERT INTO poy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu pakabetuliti kala, kashigubika shindola na kamupa ntumintumi, mweni kalivaga. Wantu woseri munumba ya Mlungu, wamjodolera masu, ");
INSERT INTO poy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","su kanja kuwagambira, “Leru Lilembu Linanagala ali liwera nakaka pampikaniriti lyankubetulwa.” ");
INSERT INTO poy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Woseri wafiliziwa nentu nayomberi, walikangashira visoweru viwagira vyakatakuliti. Walonga, “Hashi ayu mwana ndiri gwa Yosefu?” ");
INSERT INTO poy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yomberi kawagambira, “Nakaka hamung'ambiri visoweru avi, ‘Mganga guliponiziyi gamweni.’ Viraa hamtakuli, ‘Goseri gatupikiniriti gugatenditi Kafarinaumu, gugatendi panu pa pashijiji shaku.’ ” ");
INSERT INTO poy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kendereya kutakula, “Nankuwagambirani nakaka, mbuyi gwa Mlungu kamanikana ndiri mushijiji mwawu. ");
INSERT INTO poy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Munpikiniri weri, Nakaka kweniti na wadala wakenja wavuwa pa isi ya Israeli shipindi sha Eliya, vula ileka kutowa kwa mivinja mitatu na nusu, kweniti njala nkulu pa isi yoseri. ");
INSERT INTO poy_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ata hangu, Eliya wamtumiti ndiri kwa muntu yoseri Muisiraeri, ira kwa mdala mkenja yakalikaliti Sarepati pa Sidoni. ");
INSERT INTO poy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mushipindi sha Elisha mbuyi gwa Mlungu, kweniti wantu wavuwa muisi ya Israeli yawaweriti walwala ungumbula kumbiti kwahera muntu yoseri yakapungitwi kumbiti Naamani yakaweriti gwa isi ya Siriya.” ");
INSERT INTO poy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wantu woseri wawaweriti munumba ya Mlungu pawapikaniriti aga, wakalaliti nentu. ");
INSERT INTO poy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wagoloka, wamlaviya Yesu kunja kushijiji shawanyawiti kulugongu. Wamkweniziya mpaka mlupeleru lwa lugongu su wamwasi pasi. ");
INSERT INTO poy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kumbiti Yesu kapena pakati pawu kagenda zyakuwi. ");
INSERT INTO poy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu kagenditi mpaka Kafarinaumu Iushi lwa Galilaya, kaweriti kankuwafunda wantu mulishaka lya kwoyera. ");
INSERT INTO poy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Walikangashiti mafundu gakafunditi, toziya katakuliti kwa uwezu. ");
INSERT INTO poy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mlaa munumba ya Mlungu kweniti na muntu kana shamshera, su kabotanga, ");
INSERT INTO poy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Wuyi! Gwanashishi na twenga, Yesu gwa Nazareti? Gwapanu, gwiza kutulaga? Nukumana gwenga gwa gaa, gwenga gwa Mjumbi yumu Mnanagala gwa Mlungu!” ");
INSERT INTO poy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu kamkalipira shamshera ulii pakalonga, “Gunyamali na gumlawi muntu ayu!” Su shamshera ulii kumgusiya pasi muntu ulii kulongolu kwawu na kamlawa pota na kumtenda shintu. ");
INSERT INTO poy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wantu woseri walikangasha na walitakuziyana weni kwa weni, “Ashi shitwatila gaa? Mana kwa uwezu na makakala kawagambira washamshera walawi nawomberi walawa!” ");
INSERT INTO poy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Visoweru vya Yesu viyeniyiti pahala poseri mumkowa guliya. ");
INSERT INTO poy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu kalawiti munumba ya Mlungu na kagenditi ukaya kwa Simoni. Nahonga gwa Simoni kaweriti na nshimba ipyupa nentu, wamluwiti Yesu kamuponiziyi. ");
INSERT INTO poy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu kagenda na kagoloka pakwegera na yomberi, kakukalipira kupyupa kulii na kupyupa kumleka. Palaa mawu uliya kimuka kawatendera. ");
INSERT INTO poy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mushenji paguweriti gwankuzyeta, wantu woseri wawaweriti na walweli wawu wawajega kwa Yesu, nayomberi katula mawoku gakuwi kwa kila muntu na kuwaponiziya woseri. ");
INSERT INTO poy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Washamshera wawalawa wantu wavuwa, wabotanga pawalonga, “Gwenga gwa Mwana gwa Mlungu!” Kumbiti Yesu kawakaripira, kawalewelera nawatakula, mana wavimana kuwera mweni ndo Kristu. ");
INSERT INTO poy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pamandawira shirawu yakuwi, Yesu kawukiti kagenda pahala pagweka. Wantu waweriti wankumsakula na pawamwoniti kala, wajeriti kumzyengeta nakawuka. ");
INSERT INTO poy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kumbiti yomberi kawagambira, “Nfiruwa kubwera visoweru viwagila vya Ufalumi wa Mlungu mulushi zimonga viraa, toziya ntenda shilii shakantumiti Mlungu.” ");
INSERT INTO poy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Su kawera kankubwera munumba za Mlungu Muyudeya. ");
INSERT INTO poy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lishaka limu Yesu kagolokiti pampenku pa litanda lya Genezareti, aku wantu waweriti wankulibabanika wapikiniri visoweru vya Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kawoniti mitumbwi miwili mumpenku mwa litanda, walowa wa wasomba waweriti wawuka, wagenditi kuzigulula wavu zawu. ");
INSERT INTO poy_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu kagenda kwingira mumtumbwi mwa Simoni na kamgambiriti kagusegeziyi mtumbwi gulii palongolu padidini mulitanda. Yesu kalivagiti mumtumbwi na kanjiti kulifunda lipinga lya wantu. ");
INSERT INTO poy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pakamaliriti kala kutakula, kamgambira Simoni, “Gushimi mtumbwi kugenda kumashi gagenda, gwenga na wayagu mwakazidibisiyi zinyavu zyeni mlowi wasomba.” ");
INSERT INTO poy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni kamwankula, “Mtuwa, twenga pashiru poseri tutenditi lihengu liraa ali kumbiti tupata ndiri wasomba. Toziya gwenga gutakula hangu, neni hanuzidibisiyi zinyavu.” ");
INSERT INTO poy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pawadibisiyiti kala zinyavu wamemiti wasomba wavuwa mpaka zinyavu zyanja kudegeka. ");
INSERT INTO poy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wawashemiti wayawu yawaweriti mumtumbwi gumonga wizi wawatangi. Womberi wiza na wamemisiya wasomba mitumbwi yoseri miwili mpaka yanja kulidiba. ");
INSERT INTO poy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Peteru pakawoniti yagalawiriti, kasuntamalira palongolu pa Yesu pakalonga, “Guwuki palongolu pangu, Mtuwa! Toziya neni muntu yanwera na vidoda!” ");
INSERT INTO poy_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni na wayaguwi woseri walikangashiti pawawoniti ntambu yawapatiti wasomba wavuwa. ");
INSERT INTO poy_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Wayaguwi na Simon, ashina Yakobu na Yohani, wana wa Zebedayu nawomberi walikangasha. Yesu kamgambira Simoni, “Nagutila, kwanjira vinu haguweri mlowa wantu.” ");
INSERT INTO poy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wasegeziyiti mitumbwi yawu pampenku palitanda, waleka kila shintu, wamfata Yesu. ");
INSERT INTO poy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Su Yesu pakaweriti mulushi, kuweriti na muntu yakana ugumbula. Pakamwoniti Yesu, kasuntama makukama kulongolu kwa Yesu kamluwa pakalonga, “Mtuwa pagufira gumweni, guweza gumpungi neni.” ");
INSERT INTO poy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu kanyosha liwoku lyakuwi na kumshinkula pakalonga, “Neni nfira hangu, gupungwi!” Pala palii ugumbula umlekeziya. ");
INSERT INTO poy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu kamsinga pakalonga, “Nagumgambira muntu yoseri, su gugendi gwakaliranguziyi kwa Mtambika mkulu, gulaviyi tambiku ntambu yakalagaliriti Musa kwa kupungwa kwaku su muntu yoseri kavimani kuwera gupona.” ");
INSERT INTO poy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Visoweru vya Yesu vyeniyiti nentu. Lipinga lya wantu limgendiriti kumpikinira na wamonga wafiliti waponiziwi malweli gawu. ");
INSERT INTO poy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Su Yesu kawukiti na kagenda pahala pagweka, kaweriti kankumluwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lishaka limu Yesu kaweriti kankufunda, Mafalisayu wamu pamuhera na wafunda wa Malagaliru yawalivagiti palii weni walawiti mukila Iushi lwa Galilaya na Yudeya na kulawa Yerusalemu. Likakala lya Mtuwa liweriti kwa Yesu kwajili ya kuponiziya walweli. ");
INSERT INTO poy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wantu wamu wiziti pawampapa mushitanda muntu yakalewelekiti, wajeriti kumwingiziya mnumba su wamtuli palongolu pa Yesu. ");
INSERT INTO poy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Toziya ya lipinga lya wantu, wasinditi kwingira nayomberi mnumba. Su wamkweniziya mlweri ulii pashitwiku, wadonola pampindi palitala, shakapanu wamseleziya mlweri ulii mushitanda mwakuwi mpaka pakati kulongolu kwa Yesu. Wantu wamsheshi wankumsulusiya mlweri kupitira palitala. ");
INSERT INTO poy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu pakawoniti njimiru yawu nkulu, kamgambiriti mlweri ulii, “Ganja gwangu, vidoda vyaku vilekiziwa.” ");
INSERT INTO poy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wafunda wa Malagaliru na Mafalisayu su wanja kulikosiya pawalonga, “Ayu muntu gaa, kamwigilanga Mlungu! Mlungu gweka yakuwi ndo kaweza kulekiziya vidoda.” ");
INSERT INTO poy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu kavimaniti kala vyawaliholiti su kawakosiya, “Hashi, mulihola hangu mumyoyu mwenu? ");
INSERT INTO poy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Shoshi shikamala ndiri, ‘Kulonga vidoda vyaku vilekiziwa,’ ama kutakula, ‘Gugoloki na gugendigendi?’ ");
INSERT INTO poy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nfira muvimani, Mwana gwa Muntu kana uwezu pasipanu wa kulekiziya vidoda.” Su kamgambiriti muntu yakalewelekiti, “Nunkugambira, gugoloki na gutoli mkeka gwaku na gugendi ukaya kwaku!” ");
INSERT INTO poy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pala palii muntu ulii yakalewelekiti kagoloka kulongolu kwawu woseri, katola mkeka gwakuwi na kugendagenda na kagenditi ukaya pakamkwisa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Woseri walikangasha nentu! Waweriti na lyoga, wamkwisiti Mlungu pawalonga, “Tulola mauzauza leru!” ");
INSERT INTO poy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Shakapanu, Yesu kalawa kunja, kamwoniti yakatola kodi litawu lyakuwi Lawi, kalivaga muofisi mwakuwi. Yesu kamgambira, “Gunfati.” ");
INSERT INTO poy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi kagoloka, kaleka kila shintu, kamfatiti yomberi. ");
INSERT INTO poy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lawi kamtenderiti Yesu msambu mkulu nentu pakaya pakuwi, mngati mwa wahenga, waweriti watola kodi wavuwa pamuhera na wantu wamonga. ");
INSERT INTO poy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mafalisayu wamu na wafunda wa Malagaliru, winginikiti kwa wafundwa wa Yesu pawalonga, “Iwera hashi mwega mliya shiboga na kulanda pamuhera na watola kodi na wantu yawawera na vidoda?” ");
INSERT INTO poy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu kawankula, “Wantu wakomu walandaga ndiri mtera, kumbiti woseri yawalwala ndo walandaga mtera. ");
INSERT INTO poy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Niza ndiri kuwashema wantu waheri, kumbiti niza kuwashema wantu yawawera na vidoda waleki vidoda vyawatenda.” ");
INSERT INTO poy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wantu wamonga wamgambiriti Yesu, “Wafundwa wa Yohani Mbatiza, woyiti kuliya mala zivuwa na kumluwa Mlungu na wafundwa wa Mafalisayu watendaga hera hangu, kumbiti wafundwa waku wankuliya na kulanda.” ");
INSERT INTO poy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu kawankula, “Hashi muweza kuwatenda wahenga wa mpalu gwa ndowa wafungi pawawera na mpalu gwa ndowa? Hapeni watendi hangu! ");
INSERT INTO poy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Su lishaka halizi pawamtola mpalu gwa ndowa, womberi ndo hawoyi kuliya.” ");
INSERT INTO poy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu viraa kawagambira kwa mfanu, “Kwahera muntu hakatoli shiraka sha nguwu yasyayi na kusonera munguwu ngona. Pakatenda hangu, su nguwu yasyayi hawayidegi, kayi shiraka sheni hapeni shilinganiri na nguwu ngona. ");
INSERT INTO poy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kwahera muntu yakalekera divayi yasyayi mumihaku ya lukuli migona, toziya divayi ya syayi hayipanti mihaku ya lukuli na divayi yeni hayitiki na mihaku ya lukuli hayidegeki. ");
INSERT INTO poy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mala zoseri, divayi yasyayi ilekerwa mumihaku ya lukuli yasyayi! ");
INSERT INTO poy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kwahera muntu yakafira kulanda divayi yasyayi pakalanditi kala divayi ngona, su katakula, ‘Divayi ngona ndo iherepa nentu.’ ” ");
INSERT INTO poy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lishaka limu lya kwoyera Yesu kaweriti kankupita mumigunda ya nganu. Wafundwa wakuwi waweriti wankubena mikunguwi ya nganu, pawayisyoga mumawoku mwawu na kuziliya mbunji zya nganu. ");
INSERT INTO poy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mafalisayu wamu wamkosiya, “Iwera hashi mtenda shintu sheni Lilagaliru lilewelera kutenda mulishaka lya kwoyera?” ");
INSERT INTO poy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu kawankula, “Mwenga hamwenibetuli ntambu yakatenditi Dawudi na wayaguwi shipindi pawaweriti na njala? ");
INSERT INTO poy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yomberi kingiriti Mnumba ya Mlungu, katola mabumunda gawatuliti Mnumba ya Mlungu, kaliyiti na gamonga kawapananiti wayaguwi. Kwahera muntu yoseri yakaliyaga kumbiti watambika hera ndo waliyaga.” ");
INSERT INTO poy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu kamaliriti kwa kuwagambira, “Mwana gwa Muntu ndo Mtuwa gwa lishaka lya kwoyera.” ");
INSERT INTO poy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lishaka lyamonga lya kwoyera Yesu kingiriti mnumba ya Mlungu kufunda. Kuweriti na muntu mlaa yakaweriti na liwoku lya kumliwu lyalilewelekiti. ");
INSERT INTO poy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wafunda wamu wa Malagaliru na Mafalisayu wamu wasakuliti shisoweru sha kumsitaki Yesu, su waweriti wankumuhepelera waloli handa kamuponiziyi muntu mulishaka lya kwoyera. ");
INSERT INTO poy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kumbiti Yesu kavimaniti kala shawaliholiti, su kamgambiriti muntu yakeniti na liwoku lyalilewelekiti, “Gugoloki, gwizi panu palongolu.” Muntu ulii kimuka na kugoloka palii. ");
INSERT INTO poy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Su Yesu kawagambira, “Nukukosiyani, Lilagaliru litujimira twenga kutenda shishi mulishaka lya kwoyera? Kuponiziya ama kulaga? Kugalopoziya makaliru ga muntu ama kugalaga?” ");
INSERT INTO poy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kawaloliti wega zoseri, shakapanu Kamgambira muntu yakeniti na liwoku lyalilewelekiti, “Gunyoshi liwoku lyaku.” Yomberi kanyosha liwoku lyakuwi na liwera kayi likomu. ");
INSERT INTO poy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Womberi wakalala, su wanja kulihola ntambu ya kumtenda Yesu vidoda. ");
INSERT INTO poy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Shipindi shilii Yesu kagenda kulugongu kumluwa Mlungu, kalivagiti kulaa aku pashiru poseri pakamluwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Shilawu yakuwi kawashema wantumintumi wakuwi, pakati pawu kawasyagula lilongu na wawili kawashema wantumintumi. ");
INSERT INTO poy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Awa ndo Simoni yawamupiti litawu lya Peteru na Andereya mlongu gwakuwi na Yakobu na Yohani na Filipu na Batolumayu, ");
INSERT INTO poy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayu na Tomasi na Yakobu mwana gwa Alifayu na Simoni yawamshemiti Zeloti, ");
INSERT INTO poy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwana gwa Yakobu na Yuda Isikariyoti yakamgalambukiti Yesu. ");
INSERT INTO poy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pakasulukiti kulugongu pamuhera na wafundwa wakuwi, Yesu kagolokiti palushi, pakaweriti na wafundwa wakuwi wavuwa. Lipinga likulu lya wantu wawalivagiti palii, walawiti Muyudeya yoseri na Yerusalemu na mbwega ya Tiru na Sidoni, ");
INSERT INTO poy_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","wiziti kumpikinira na kuponiziwa malweli gawu. Woseri yawagaziwitwi na washamshera viraa wiziti na waponiziwitwi. ");
INSERT INTO poy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wantu woseri wafiriti kumshinkula Yesu, makakala gamlawiti na kawaponiziya woseri. ");
INSERT INTO poy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu kawagalambukira wafundwa wakuwi na kulonga, “Mnemeleri mwenga mwawahushu, Toziya Ufalumi wa Mlungu hawuweri wenu! ");
INSERT INTO poy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mnemeleri mwenga yamuwera na njala vinu, Toziya hamyukutiziwi! Mnemeleri mwenga yamlira vinu, Toziya hamsekeleri!” ");
INSERT INTO poy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mnemeleri mwenga wantu pawawakalirani na kuwalema, kuwahigilanga na kuwapayirani madoda, goseri aga toziya ya Mwana gwa Muntu! ");
INSERT INTO poy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Shipindi pagalawila aga, mnemeleli pa mvina, toziya ya lijenjeri likulu lyawawatulirani kala kumpindi kwa Mlungu. Hangu ndo wambuyi wawu wawatenditi wambuyi wa Mlungu ntambu iraayi.” ");
INSERT INTO poy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Kumbiti shondi shondi mwenga mwawalunda vinu, Toziya nemeleru yenu vinu ipera! ");
INSERT INTO poy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Shondi shondi mwenga yamwikuta vinu, Hamuweri na njala! Shondi shondi mwenga yamseka vinu, Hamlili na kudaya! ");
INSERT INTO poy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Shondi shondi wantu woseri wankukuzyumani, hera hangu wagogolu wawu watakuliti ntambu iraayi kwa wambuyi wa mpayu. ");
INSERT INTO poy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Kumbiti nankuwagambirani mwenga mwamunpikanira. Muwafiri wangondu wenu, muwatekeleri woseri wakukalalirani. ");
INSERT INTO poy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Muwatekeleri woseri wawakupangilirani na muwaluwili kwa Mlungu woseri yawakutenderani madoda. ");
INSERT INTO poy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Muntu pakakukoma lisaya limu, gumleki kakomi na lisaya lyamonga, handa muntu pakakupoka likoti lyaku, gumlekeri na lishati lyaku. ");
INSERT INTO poy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Muntu yoseri pakakuluwa gumpanani na muntu pakakupoka ulunda waku, nagumgambira kawuziyi. ");
INSERT INTO poy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Muwatenderi wamonga ntambu yamfira kutenderwa. ");
INSERT INTO poy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Handa pamuwafira walii yawawafira mwenga, hampati lifupu gaa? Ata yawawera na vidoda wawafira wantu yawawafira womberi. ");
INSERT INTO poy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kayi pamuwatendera viheri walii yawakutenderani mwenga viheri, hampati lifupu gaa? Ata yawawera na vidoda watendaga hera hangu! ");
INSERT INTO poy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na pamuwakopesha walii yamuwahola kuwera hawakuwuzireni hampati lifupu gaa? Ata yawawera na vidoda wawakopeshaga yawawera na vidoda, pawalihola wawawuziliri shawawakopeshiti. ");
INSERT INTO poy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kumbiti mwenga muwafiri wangondu wenu na muwatenderi viheri, mkopeshi namliholera kuwuzilirwa. Lifupu lyenu haliweri likulu na hamuweri wana wa Mlungu gwa kumpindi. Toziya yomberi ndo muheri kwa wantu yawahera mayagashii na yawatenda vidoda. ");
INSERT INTO poy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Muweri na lusungu gambira Tati gwenu ntambu yakawera na lusungu. ");
INSERT INTO poy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Namuwatoza wamonga, su Mlungu hakawatozi ndiri mwenga, namuwapangira wamonga, su Mlungu hapeni kawapangili mwenga, muwalekeziyi wamonga, su Mlungu hakawalekiziyi mwenga. ");
INSERT INTO poy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Muwapanani wamonga, su Mlungu hakawapanani mwenga. Hamuwanki shipimu shakumemeziya, sha kutikisiya na kuyonera na kwitika mumawoku mwenu, vyoseri avi haviweri vya mwenga. Shipimu shamuwapimiliti wamonga, Mlungu ndo hakakupimirani mwenga.” ");
INSERT INTO poy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu kawagambira mfanu agu, “Muntu kana lwisi kaweza ndiri kumlongoziya kana lwisi muyaguwi, pakatenda hangu, woseri hawapokeri mulirindi. ");
INSERT INTO poy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kwahera mfundwa kaweza kumsinda mfunda gwakuwi, su kila mfundwa pakamalila kala mafundu hakaweri gambira mfunda gwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Guweza hashi kushiwona shibandu shididini nentu mulisu lya mlongu gwaku, pota kuwona lipingiri lya mulisu lyaku? ");
INSERT INTO poy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hashi guweza kutakula kwa mlongu gwaku, ‘Guleki nukuwusiyi shibandu shididini nentu mulisu lyaku,’ na gwenga gusinda kuliwona lipingiri lya mulisu lyaku? Gwa mfyangu gwenga! Kwanja guwusiyi huti lipingiri lya ligogu mulisu lyaku, ndo haguwezi kushiwusiya weri shibandu mulisu lya mlongu gwaku. ");
INSERT INTO poy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kwahera mtera guherepa gwagulera mabwajubwaju gadoda, viraa mtera gudoda guweza ndiri kulera mabwajubwaju gaherepa. ");
INSERT INTO poy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kila mtera gumanika kulawirana na mabwajubwaju gakuwi galeriti, guweza ndiri kwapa embi mumishongoma ama zabibu mumbigiri. ");
INSERT INTO poy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Muntu muheri katendaga viheri kulawa muviheri vivuwa mumoyu mwakuwi, na muntu kana vidoda katendaga vidoda kulawa muvidoda vivuwa mumoyu mwakuwi. Toziya mlomu gutakula galii gaweriti mumoyu. ");
INSERT INTO poy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Iwera ashi munshema, ‘Mtuwa, Mtuwa,’ Uganu mtenda ndiri vyanuwagambirani? ");
INSERT INTO poy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Hanuwalanguziyi ntambu yakalifana muntu yoseri pakiza kwa neni na kupikinira visoweru vyaneni na kuvijimira. ");
INSERT INTO poy_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kalifana na muntu yakanyawa numba yakuwi, kabawa pasi nentu na kunyawa liyanjiru mulitalawu. Mafuriku gamashi pagarawiriti gayiputa numba ilii kumbiti itikinyika ndiri, toziya wayinyawiti weri numba. ");
INSERT INTO poy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Su yoseri ulii yakapikanira visoweru vyangu na kuvijimira ndiri, ayu kalifana na muntu yakanyawiti numba yakuwi pota na kunyawa lyanjiru, mafuriku pagiziti gayiputa numba ilii na kuguwa puu na kubomokanga nakamu!” ");
INSERT INTO poy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu pakamaliriti kutakula vyoseri kwa wantu, kagenditi Kafarinaumu. ");
INSERT INTO poy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mkulu gwa wanjagila miya yimu kaweriti na ntumini yakamfiriti nentu. Ntumintumi kaweriti kalwala tashitashi. ");
INSERT INTO poy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mkulu ulii pakapikaniriti visoweru vya Yesu, kawatumiti wazewi wa Shiyawudi kumluwa kizi kamuponiziyi ntumintumi gwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wagenditi kwa Yesu na kumuhiga nentu pawalonga, “Muntu ayu kafiruwa gumtenderi shitwatila ashi. ");
INSERT INTO poy_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kawafira wantu wetu na mweni katunyawira numba ya Mlungu.” ");
INSERT INTO poy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Su Yesu kagenda pamuhera na womberi. Pakaweriti pakwegera na ukaya kwa mkulu ulii, mkulu ulii kawatumiti waganja wakuwi wamgambiri Yesu, “Mtuwa naguligaziya hera. Gwenga gufiruwa ndiri kwingira mnumba mwangu, ");
INSERT INTO poy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","na neni mona nfaa ndiri ata kwiza kwa gwenga. Kumbiti gutakuli hera, ntumini gwangu hakaweri mkomu. ");
INSERT INTO poy_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mana neni viraa namuntu gwa pasi pa ukulu, nanawa wamanjagila yanuwalongoziyiti. Panumgambira yumu, ‘Gugendi!’ Yomberi kagenda na panumgambira yumonga, ‘Gwizi!’ Yomberi kiza na panumgambira ntumintumi gwangu, ‘Gutendi shintu ashi!’ Nayomberi katenda.” ");
INSERT INTO poy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu pakapikaniriti hangu kalikangasha, su kaligalambukiriti lipinga lya wantu lyalimfatiti pakalonga, “Nankuwagambirani, mpata ndiri kuwona muntu kana njimiru gambira ayu Muisraeli!” ");
INSERT INTO poy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wantu walii pawasokiti ukaya kwa Mkulu wamwoniti ntumintumi ulii kawera mkomu nakamu. ");
INSERT INTO poy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Shakapanu, Yesu kagenditi lushi lwawalushema Naini, wafundwa wakuwi pamuhera na lipinga likulu lya wantu wagenda nayomberi. ");
INSERT INTO poy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Su pakaweriti pakwegera na mlyangu mkulu gwa Iushi, wantu wampapiti yakahowiti waweriti wankulawa kunja kwa Iushi. Yakahowiti kaweriti mwana gwagweka gwa mdala yakaweriti mkenja, na lipinga likulu lya wantu waweriti pamuhera nayomberi. ");
INSERT INTO poy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mtuwa pakamwoniti mkenja ulii, kamwonera lusungu mdala ulii, kamgambiriti, “Nagulira.” ");
INSERT INTO poy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Shakapanu kalisegelera lijeneza lya yakahowiti na kulishinkula, wantu wawalipapiti wagoloka. Yesu kalonga, “Muntemba! Nukugambira gwimuki!” ");
INSERT INTO poy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Muntu ulii yakahowiti kalivaga, su kanja kuyowera. Yesu kamupa mawu gwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wantu woseri weniti lyoga wamkwisiti Mlungu pawalonga, “Mbuyi mkulu kalawira pakati petu. Mlungu kiza kuwalopoziya wantu wakuwi!” ");
INSERT INTO poy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Visoweru avi vya Yesu viyeniyiti mulushi loseri lwa Yudeya na lushi zya pakwegera. ");
INSERT INTO poy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wafundwa wa Yohani wamgambiriti Yohani vitwatira avi vyoseri, nayomberi pakawashemiti kala awili wamu wa wafundwa wakuwi ");
INSERT INTO poy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","kawatumiti kwa Mtuwa wakamkosiyi, “Hashi, gwenga ndo gwamweni yatumuhepera, ama tumuheperi gwingi?” ");
INSERT INTO poy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wafundwa walii wamgendiriti Yesu na kumgambira, “Yohani Mbatiza katutuma kwaku tukukosiyi handa gwenga ndo uliya yakatakuliti gwankwiza ama tumuheperi gwingi?” ");
INSERT INTO poy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Shipindi shiraa shilii Yesu kaweriti kankuwaponiziya wantu wavuwa weniti na malweri na wamonga waniti na washamshera wadoda na kuwapanana wanalwisi wavuwa kulola. ");
INSERT INTO poy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Su Yesu kawankula wantumintumi wa Yohani pakalonga, “Mgendi mwakamgambiri Yohani vyoseri vyamuviwoniti na kuvipikinira, wanalwisi wawona, wavibyeketu wagendagenda, woseri walii yawawera na ungumbula wapungwa, yawawera na majogu vinu wapikinira, wahowiti su wazyuka na Shisoweru Shiwagira shibwerwa kwa wahushu. ");
INSERT INTO poy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mbaka woseri walii wahera lyoga na neni.” ");
INSERT INTO poy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Su wajumbi wa Yohani pawawukiti kala, Yesu kanja kuligambira lipinga kwajili ya Yohani, “Pamgenditi kumlola Yohani kushiwala mfira kulola shintu gaa? Mfiriti kuwona gambira mateti ntambu yagatikinyika na lihega? Ndala! ");
INSERT INTO poy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Su mgenditi kumlola muntu gwa ntambu gaa? Hashi mliholiti Mgenditi kumlola muntu kavaliti nguwu ziherepa? Ndala, wantu yawavala nguwu ziherepa na kubojola vinoga noga vyaviwera muukulu! ");
INSERT INTO poy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Su mung'ambiri, mgenditi kumlola muntu gwa ntambu gaa? Mgenditi kumlola mbuyi gwa Mlungu? Yina nakaka, tuwona gavuwa nentu kuliku mbuyi. ");
INSERT INTO poy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yohani ayu ndo yumu yawamtakula mukulemba, kulonga, ‘Mlungu kalonga, hanumtumi mjumbi gwangu hakakulonguleri kukunyawira njira kwajili yaku.’ ” ");
INSERT INTO poy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu kamaliriti kwa kulonga, “Nukugambirani, Yohani ndo mkulu kuliku woseri yawalikaliti pasipanu. Kumbiti yakaweriti mdidini Muwufalumi wa Mlungu ndo mkulu kuliku Yohani.” ");
INSERT INTO poy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wantu woseri wampikaniriti. Wantu wavuwa asa watola kodi ndo wagajimiriti Malagaliru Mananagala ga Mlungu, awa ndo walii Yohani yakawabatiziti. ");
INSERT INTO poy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kumbiti Mafalisayu pamuhera na wafunda wa Malagaliru wagulemiti mpangu gwa Mlungu na wamlemiti Yohani kawabatizi. ");
INSERT INTO poy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu kongera kulonga, “Vinu wantu wa mashaka aga walifana na shintu gaa? ");
INSERT INTO poy_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Walifana gambira wana yawalivaga pahala pa guliwu. Shipinga shimu shishigambizisiya shamonga, ‘Tuviniti msambu gwa ndowa kumbiti mwenga mvina ndiri! Twimba lwimbu lwa kudaya kumbiti mlila ndiri!’ ");
INSERT INTO poy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohani Mbatiza pakiziti, koyiti kuliya na kalanda ndiri divayi, kumbiti mwenga mlongiti, ‘Kana washamshera!’ ");
INSERT INTO poy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kiziti Mwana gwa Muntu, kaliyiti shiboga na kulanda, kumbiti mwenga mtakula, ‘Mumloli muntu ayu, Kana lwaliya na mkologeru, ganja gwa watola kodi na wanavidoda!’ ");
INSERT INTO poy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kumbiti luhala lwa Mlungu luwonekana kuwera lwa nakaka kwa wantu woseri yawalijimira.” ");
INSERT INTO poy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfalisayu yumu kamshemera Yesu walii shiboga sha pamihi pamuhera nayomberi na Yesu kingiriti mnumba mwa Mfarisayu na kulivaga pasi kuliya shiboga. ");
INSERT INTO poy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Su palushi palii peniti na mdala yakaweriti na makaliru ga vidoda. Kapikaniriti handa Yesu kankuliya shiboga mnumba ya Falisayu, katoliti supa ya alabasta yayiweriti na utuli. ");
INSERT INTO poy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kagenda kagoloka pakwegera pamagulu pa Yesu pakalila na masozi gakuwi gamtulukiriti Yesu pamagulu. Kapukuta magulu ga Yesu kwa vilii zyakuwi na kunonera magulu, kagaswaga utuli. ");
INSERT INTO poy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mfalisayu pakawoniti hangu, kalitakuliti pakalihola mumoyu mwakuwi, “Handa muntu ayu nakaka ndo mbuyi gwa Mlungu, hakavimani handa mdala yakakushinkula ka gaa, hakavimani makaliru ga vidoda ntambu yakawera nagu!” ");
INSERT INTO poy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu kamgambira Mfarisayu uliya, “Simoni, nana shintu shakukugambira.” Simoni kamwankula, “Yina mfunda gung'ambiri.” ");
INSERT INTO poy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu kamgambira, “Kuweriti na wantu awili yawamkopiti muntu yakakopesha mpiya. Yumu kakopiti senti zivuwa na yumonga senti zivuwa ndiri. ");
INSERT INTO poy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pawasinditi kulipa uwanda wawu, muntu uliya kawalekiziya woseri awili. Vinu pakati pa wantu awili walii, yoshi hakamfiri nentu muntu ayu yakawalekiziyiti?” ");
INSERT INTO poy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni kamwankula, “Nuvimana kuwera, ulii yawamlekiziyiti uwanda mkulu nentu” Yesu kamgambira, “Gutakula nweri.” ");
INSERT INTO poy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kamgalambukira mdala uliya na kumgambira Simoni, “Gumwona mdala ayu? Niziti pakaya paku, gunupa ndiri mashi gakunaviya magulu gangu, kumbiti mdala ayu kaganaviya magulu gangu kwa masozi gakuwi na kumpukuta kwa vilii zyakuwi. ");
INSERT INTO poy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gwenga gunamsiya ndiri kwa kunonera, kumbiti mdala ayu kwanjira paningiliti kaweriti pakanonera magulu gangu. ");
INSERT INTO poy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gwenga gunswagaziya ndiri lipaki mumtuwi mwangu, kumbiti mdala ayu kagapakaziya magulu gangu kwa utuli. ");
INSERT INTO poy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Su nukugambira, kwa kufira kwakuwi kukulu kulanguziyiti nakaka kuwera vidoda vivuwa vyakaweriti navyi vilekiziwa. Kumbiti ulii yakalekiziwa padidini kalanguziya kufira padidini hera.” ");
INSERT INTO poy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Su Yesu kamgambira mdala uliya, “Gulekiziwa vidoda vyaku.” ");
INSERT INTO poy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wantu wamonga yawaweriti walivaga pameza wanjiti kulitakuliziyana weni pawalonga, “Ayu gaa yakaweza kulekiziya vidoda?” ");
INSERT INTO poy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kumbiti Yesu kamgambira mdala uliya, “Kujimira kwaku kukulopoziya, gugendi kwa ponga.” ");
INSERT INTO poy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Shipindi shimonga Yesu kagenditi mwanja kupitila mlushi na muvijiji pakabwera Visoweru viwagila vya Ufalumi wa Mlungu. Wantumini lilongu na wawili wagenditi pamuhera nayomberi ");
INSERT INTO poy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","na kuweriti na wadala wamu yawaponiziyitwi washamshera na malweli, Mariya yawamshemiti Magidalena, yawamuusiyiti washamshera saba, ");
INSERT INTO poy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana mweni mpalu gwakuwi Kuza yakaweriti mtenda lihengu mkulu gwa Herodi, viraa vilii kuweriti na Susana na wadala wamonga wavua watumiiti vyawaweriti navi kumtanga Yesu na wantumini wakuwi. ");
INSERT INTO poy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wantu waweriti wankumwizira Yesu kulawa kila Iushi na pawaliwoniti pamuhera waweriti lipinga likulu, su yomberi kawagambiriti mfanu agu, ");
INSERT INTO poy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mkweta mbeyu kagenditi kukweta mbeyu. Pakaweriti kankukweta mbeyu, mbeyu zimonga zitulukiti munjira na wagendagenda munjira wazitimbanga na wampongu waziliya. ");
INSERT INTO poy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Zimonga zitulukira mumabuwi ga mulitapaka na pazimeriti kala ziyanja kunyala toziya litapaka liweriti lya mashi ndiri. ");
INSERT INTO poy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Zimonga zitulukiriti mumisontu, pazimeriti, misontu ilii izibabanika na zisinda kukula. ");
INSERT INTO poy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na mbeyu zimonga zitulukiriti mulitapaka liherepa, zimera na kulera viboga vivuwa.” Yesu kamaliriti kwa kutakula, “Yakana makutu kapikaniri!” ");
INSERT INTO poy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wafundwa wakuwi wamkosiyiti Yesu mana ya mfanu agu, ");
INSERT INTO poy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","nayomberi kawankula, “Mwenga mpananwa kuumana ubada wa Ufalumi wa Mlungu, kumbiti wamonga wavimana ndiri mpaka nuwagambiri kwa mifanu, su pawalola hapeni wawoni na pawapikanira hapeni wavimani. ");
INSERT INTO poy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Mfanu agu ndo gutakula hangu, mbeyu ndo shisoweru sha Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbeyu zilii zyazitulukiriti munjira mana yakuwi, woseri yawapikanira shisoweru sha Mlungu, kumbiti Shetani kiza na kushiwusiya shisoweru shilii mumyoyu mwawu, su hapeni wajimili na kulopoziwa. ");
INSERT INTO poy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mbeyu zyazitulukiriti mulibuwi mana yakuwi woseri yawapikanira ujumbi na kuuwanka kwa nemeru. Kumbiti wahera mishigira mitali, wajimira kwa shipindi shididini hera na shipindi sha kujerwa pashiza, waleka shawapikaniriti. ");
INSERT INTO poy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mbeyu zilii zyaziturukiriti mumisontu mana yakuwi, woseri yawapikaniriti shisoweru sha Mlungu, su lyoga na ulunda na vinoganoga vyawabojola hapeni waleri mabwajubwaju yagakamala. ");
INSERT INTO poy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na mbeyu zilii zyazitulukiriti mulitapaka liherepa mana yakuwi, woseri yawashipikanira shisoweru sha Mlungu, pawashijimila kwa moyu gwoseri na gwa kujimira. Awa ndo wagangamala mpaka pawalera mabwajubwaju.” ");
INSERT INTO poy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Wantu hapeni wawashi limuliku na kuligubikira mulidebi ama walituli mulivungu mwa shitanda. Kumbiti hawalituli pampindi pashintambi su wantu pawingira mnumba wawoni kulangala ndaa. ");
INSERT INTO poy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Shoseri shawatenditi kwa kufifwa hashiwoneki na shoseri shawatenditi muluwindu hashimaniki na woseri. ");
INSERT INTO poy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Mlikali weri, ntambu yampikanira, toziya yakawera na shintu hawamwongeri, kumbiti ulii yakahera shintu ata shilii shakawera nashi hawampoki.” ");
INSERT INTO poy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mawu gwa Yesu na walongu wakuwi wamgenderiti, kumbiti wasinda kumsegelera pakwegera toziya ya lipinga lya wantu. ");
INSERT INTO poy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Muntu yumu kamgambiriti Yesu, “Mawu na walongu waku wakunja, wafira wakuwoni.” ");
INSERT INTO poy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu kawagambiriti woseri, “Mawu na walongu wangu ndo woseri yawashipikanira shisoweru sha Mlungu na kushijimira.” ");
INSERT INTO poy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lishaka limu Yesu pamuhera na wafundwa wakuwi wakweniti mumtumbwi na kawagambira, “Tuloki litanda, tugendi kumwambu.” Su wanja mwanja. ");
INSERT INTO poy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pawaweriti wankuloka, Yesu kaweriti na mpota su kagonja. Lyega likulu lyanja kuvuma, mashi ganja kwingira mumtumbwi, su wawera mukutenduwa, kubidukira mumashi. ");
INSERT INTO poy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wantumini wamgendera Yesu na kumwimusiya, walonga, “Mtuwa, Mtuwa! Twankusokera!” Yesu kimuka, kalikalipira lyega pamuhera na mawimbi ga mashi, su vyoseri vyoya na kuweriti kuzindawala jiii. ");
INSERT INTO poy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kawagambira wantumini wakuwi, “Yakoshi njimiru yenu?” Kumbiti womberi walikangasha na kuwera na lyoga, waligambiziyana weni, “Ayu muntu gwa ntambu gaa? Kalikalipiriti lyega na mawimbi ga mashi na vyoseri vimjimira!” ");
INSERT INTO poy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu na wantumintumi wakuwi wendereyiti na mwanja, wasoka kumpwani kwa isi ya Gerasi yapakwegera na Galilaya, kumwambu kulitanda. ");
INSERT INTO poy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu pakasulukiti kumpenku, kaliwoniti na muntu yakeniti washamshera, kamwizira kulawa mulushi. Kwa shipindi shivuwa muntu ayu kaweriti kagendagenda shivula na kalikala ndiri ukaya, kumbiti kalikaliti kumapumba. ");
INSERT INTO poy_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pakamwoniti Yesu, kabotanga, kasuntama pamagulu ga Yesu pakalonga kwa liziwu likulu, “Yesu Mwana gwa Mlungu gwa Kumpindi nentu! Gufira kutenda ashi kwa neni? Shondi shondi nukuluwa naguntenda!” ");
INSERT INTO poy_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kalongiti hangu toziya Yesu kamgambiriti shamshera kamlawi. Shipindi shivuwa shamshera ulii kamwigilanga muntu ayu, tembera wantu wamtuliti mushibetubetu, mawoku na magulu gakuwi wagatawiti kwa minyololu kumbiti yomberi kayidumuliti na shamshera kamtugiziyiti kushiwala. ");
INSERT INTO poy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu kamkosiya muntu uliya, “Litawa lyaku gwagani?” Yomberi kamwankula, “Litawu lyangu ‘Tuvuwa.’ ” Katakuriti hangu toziya kaweriti na washamshera wavuwa. ");
INSERT INTO poy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Washamshera wamluwiti Yesu nakawawinga kugenda mulirindi likulu. ");
INSERT INTO poy_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Palii pawaweriti na lipinga likulu lya wamtumbi lya pakwegera, waweriti wakuliya mumpeku mwa mulugongu. Su washamshera wamluwiti Yesu kawajimiri wawayingiri wamtumbi, nayomberi kawajimira. ");
INSERT INTO poy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Washamshera wamlawiti muntu uliya na kugenda kuwayingira wamtumbi. Wamtumbi woseri watugiti pawaserera na kutulukira mumashi na wafuwiti woseri. ");
INSERT INTO poy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Walolera wa mifugu walii pawawoniti galii yagalawiriti, watugiriti mulushi na muvijiji pawalonga shashilawiriti ");
INSERT INTO poy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wantu wiza kulola shashilawiriti na pawaweriti wankumwizira Yesu, wamuwoniti muntu uliya yakeniti na washamshera kalikaliti pakwegera pamagulu ga Yesu, kaweriti kavaliti nguwu na kana mahala, su woseri waweriti na lyoga. ");
INSERT INTO poy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Woseri yawaviwoniti vilii vyavilawiriti wawagambiriti wantu ntambu yakaponiti muntu ulii. ");
INSERT INTO poy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wantu woseri wenikaya wa lushi lwa Gerasi wamgambiriti Yesu kawuki, toziya waweriti na lyoga nentu. Su Yesu kakwena mumtumbwi na kuwuka. ");
INSERT INTO poy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Muntu yawamuusiyiti washamshera kamluwa Yesu pakamgambira, “Nfira kugenda na gwenga.” Kumbiti Yesu kamjimira ndiri wagendi pamuhera, su kamgambiriti, ");
INSERT INTO poy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Guwuyi ukaya na katakuli shilii ntambu Mlungu shakakutendiriti.” Su muntu uliya kagenditi kulushi na kutakula ntambu Yesu shakamtendiriti. ");
INSERT INTO poy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu pakawuyiti uwega umonga wa litanda, wantu wamshemiriti toziya waweriti wankumuhepelera. ");
INSERT INTO poy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pala kiza muntu yawamshema Yairu, kaweriti mkulu gwa numba ya Mlungu. Kasuntama palongolu pa magulu ga Yesu na kumhiga pakamgambira wagendi ukaya kwakuwi, ");
INSERT INTO poy_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","toziya kaweriti na nafunda yumu hera, yakaweriti na mivinja lilongu na miwili su kaweriti kankulwala tashitashi. Yesu pakaweriti kankugendagenda, wantu wambabanika wega zoseri, ");
INSERT INTO poy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","mngati mwawu kuweriti na mdala yakalwaliti kusuma mwazi mivinja lilongu na miwili, tembera katumiyiti ulunda wakuwi woseri kwa waganga kumbiti wamponiziya ndiri. ");
INSERT INTO poy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mdala ayu kamfwatiti Yesu kumbeli mulipinga lilii na kashinkuriti lusepi lwa nguwu ya Yesu, su palaa palii kusuma mwazi kwoya. ");
INSERT INTO poy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu kakosiya, “Gaa kanshinkuliti?” Kila muntu kalemiti na Peteru katakuliti, “Mtuwa, lipinga lya wantu likutindiriti na kukubabanika.” ");
INSERT INTO poy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kumbiti Yesu kalonga, “Nuvimana kwana muntu kanshinkula, mana nuvimana makakala ga kuponiziya gantawa.” ");
INSERT INTO poy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mdala ulii pakawoniti kaweza ndiri kulififa, su kiza kwa kutetema na kusuntama palongolu pa magulu ga Yesu. Kaweriti kulongolu kwa kila muntu, kamgambiriti ntambu yakamshikuliti na ntambu yakaponiti kamkam hera. ");
INSERT INTO poy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu kamgambira mdala ulii, “Nafunda gwangu, njimiru yaku ikuponiziya. Gugendi kwa ponga.” ");
INSERT INTO poy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu pakaweriti kankali kankuyowera hangu, mjumbi kiza kulawa kunumba ya Yairu. Kamgambiriti Yairu, “Nafunda gwaku kahowa, nagumgaziya hera Mfunda.” ");
INSERT INTO poy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kumbiti Yesu pakapikaniriti aga, kamgambira Yairu, “Nagwana lyoga, gujimiri hera hakaponi.” ");
INSERT INTO poy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pakasokiti pakaya, kabera muntu yoseri kwingira mnumba, ira Peteru na Yohani na Yakobu na tati na mawu gwa mwana yakahowiti. ");
INSERT INTO poy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kila muntu kaweriti kankulira na kudaya toziya ya nafunda ulii. Yesu kawagambira, “Namlira! Mwana kahowa ndiri ira kagonja hera.” ");
INSERT INTO poy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wantu woseri wamseka, toziya wavimaniti mwana kahowiti. ");
INSERT INTO poy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kumbiti Yesu kambata liwoku na kumshema, “Mwana gwangu gwimuki!” ");
INSERT INTO poy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ukomu wakuwi umuwuyira, palaa palii kimuka, su Yesu kawagambiriti mawu na tati gwakuwi wamupi shintu shakuliya. ");
INSERT INTO poy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mawu na tati gwakuwi walikangashiti, kumbiti Yesu kawagambira nawamgambira muntu galii gagatendikiti. ");
INSERT INTO poy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu kawashemiti wantumini lilongu na awili pamuhera na kuwayupa makakala na uwezu wa kuwalaviya washamshera woseri na kuponiziya malweri. ");
INSERT INTO poy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Shakapanu kawatumiti wegendi wakabweri visoweru vya Ufalumi wa Mlungu na kuwaponiziya walweli, ");
INSERT INTO poy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","kayi kawagambira, “Munjira mwamgenda namtola shintu shoseri, namtola lukongoshu ama muhaku, namtola shiboga ama mpiya, ama lishati lya shigibakiru. ");
INSERT INTO poy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Poseri pawawashemerani, mwikali mnumba ilii mpaka pamuwuka muisi ilii, ");
INSERT INTO poy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","viraa vilii wantu pawalema kuwashemerani mwenga, mwuki mlushi alu na mpukuti lidika lya litapaka mumagulu mwenu haiweri likalipiru kwawomberi.” ");
INSERT INTO poy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Su wantumintumi wanja mwanja kugenda muvijiji vyoseri, pawabwera visoweru viwagila na kuwaponiziya wantu kila pahala. ");
INSERT INTO poy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mtuwa Herodi mkolamlima gwa Galilaya, kapikaniriti goseri aga gagalawiriti, su gamupunganikiti nentu toziya wantu wamonga watakuliti kuwera Yohani Mbatiza kazyuka. ");
INSERT INTO poy_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wamonga watakuliti kuwera Eliya kalawira na wamonga walonga kuwera yumu gwa wambuyi wa makashu wa Mlungu kazyuka. ");
INSERT INTO poy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodi kalonga, “Yohani numdumuliti mtuwi, muntu ayu yampikanira ndo gaa?” Su kendereyiti kumsakula Yesu. ");
INSERT INTO poy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wantumintumi walii pawawuyiti, wamgambiriti Yesu vyoseri vyawatenditi. Yesu kawatola, wagenda gwekayawu lushi lwawalushema Betisayida. ");
INSERT INTO poy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kumbiti lipinga lya wantu pawavimaniti kala aga, wamgenderiti. Yesu kawashemera na kayoweriti nawa visoweru viwagila vya Ufalumi wa Mlungu na kuwaponiziya woseri wawafiriti kuponiziwa. ");
INSERT INTO poy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mshenji paguweriti gwankuzyeta, wantumini lilongu na awili wamgenderiti na kulonga, “Guwagambiri wantu wagendi, kuvijiji na mumalambu ga pakwegera wakasakuli shiboga pamuwera na pahala pakugonja, toziya pahala panu patuwera pantundu.” ");
INSERT INTO poy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kumbiti Yesu kawagambira, “Mwenga muwapanani shintu sha kuliya.” Womberi walonga, “Twana mabumunda mhanu na wasomba awili hera. Gufira twenga tugendi twakawahemeleri shiboga lipinga lya wantu woseri awa?” ");
INSERT INTO poy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wapalu hera yawaweriti palii, waweriti gambira elufu muhanu hangu. Yesu kawagambira wafundwa wakuwi, “Muwagambiri walivagi vipinga vipinga vya malongu muhanu.” ");
INSERT INTO poy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Su wafundwa pawatenditi kala ntambu yakawagambiriti, ");
INSERT INTO poy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu katola mabumunda muhanu galii na wasomba awili, kaloliti kumpindi na kalonga mayagashii Mlungu, kagamega kawapanana wafundwa wakuwi wawagawili wantu. ");
INSERT INTO poy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wantu waliya mpaka wikuta na wantumintumi wasola majamanda lilongu na mawili ga vilii vyavisigaliti. ");
INSERT INTO poy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lishaka limu Yesu kaweriti kankuluwa Mlungu gweka yakuwi, wafundwa wakuwi wamwizira. Su Yesu kawakosiya, “Wantu walonga neni nagaa?” ");
INSERT INTO poy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Womberi wamwankula, “Wamonga walonga gwenga gwa Yohani Mbatiza na wamonga walonga gwenga gwa Eliya na wamonga walonga gwenga gwa mbuyi gwa Mlungu gwa makashu yakahowiti vinu kazyuka.” ");
INSERT INTO poy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Su nayomberi kawakosiya, “Hashi, mwenga mlonga neni nagaa?” Peteru kamwankula, “Gwenga gwa Kristu Mlopoziya yagulagaliritwi na Mlungu.” ");
INSERT INTO poy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Shakapanu Yesu kawalagalira pakalonga nawamgambira muntu yoseri shisoweru ashi. ");
INSERT INTO poy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu kawagambira, “Mwana gwa Muntu mpaka katabiki na kulemwa na wazewi na watambika wakulu wa numba ya Mlungu na wafunda wa Malagaliru. Hawamlagi, kumbiti lishaka lya tatu kwanjira pakahowiti hakazyuki.” ");
INSERT INTO poy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na kawagambira woseri, “Muntu yoseri pakafira kaweri na neni, mpaka kalilemi mweni, katoli lupingika lwakuwi mashaka goseri na kanfati. ");
INSERT INTO poy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Muntu yoseri yakafira kugaponiziya makaliru gakuwi hakagamili na yoseri yakagamiziya ukomu wakuwi kwa kunfata neni hakagalopoziyi. ");
INSERT INTO poy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Hashi, kwana mbotu gaa muntu pakapata vintu vyoseri vya pasipanu, kumbiti mweni pakagamila? Yina ndiri! ");
INSERT INTO poy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Muntu pakamonera soni neni pamuhera na mafundu gangu, Mwana gwa Muntu hakamwoneri soni muntu ayu shipindi pakiza muukwisa wakuwi na ukwisa wa Tati na ukwisa wa wantumintumi wananagala wa kumpindi. ");
INSERT INTO poy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nukugambirani nakaka, kwana wamonga palaa panu hapeni wahowi mpaka wauwoni Ufalumi wa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Palipititi lijuwa kwanjira pakalongiti galiya, Yesu kawatoliti Peteru, na Yohani na Yakobu, kagenditi nawomberi mpaka kulugongu kuluwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pakaweriti kankumluwa Mlungu, nshimba yakuwi igalambuka na nguwu zyakuwi ziwera neru mbuu. ");
INSERT INTO poy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Palaa paliya wantu awili waweriti paliya wankuyowera nayomberi. Wantu walii waweriti Musa na Eliya, ");
INSERT INTO poy_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","yawalawiriti muukwisa wa kumpindi kwa Mlungu, waweriti wankuyowera na Yesu ntambu yakugumalilira mpangu gwa Mlungu gwa kuhowa kwakuwi kulii Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peteru na wayaguwi waweriti wankugonja, kumbiti wimukiti na kuwona ukwisa wa Yesu na wantu awili wagolokiti pamuhera nayomberi. ");
INSERT INTO poy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Su wantu awili walii paweriti wankuwuka, Peteru kamgambira Yesu, “Mtuwa, iherepa twenga kulikala panu! Su hatunyawi visasa vitatu, shimu shaku na shamonga sha Musa na shamonga sha Eliya.” Nakaka kavimaniti ndiri shakatakula. ");
INSERT INTO poy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Peteru pakatakuliti hangu, palaa paliya lilawira liwundi lizotopa liwagubika na liwundi ali paliwawiziriti wantumini walii weniti lyoga nentu. ");
INSERT INTO poy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Wapikinira liziwu kulawa muliwundi lilonga, “Ayu ndo mwana gwangu yanumsyaguliti, mumpikaniri.” ");
INSERT INTO poy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Liziwu lyawalipikiniriti palinyamaliti kala, wamwona kayi Yesu kagweka yakuwi. Wantumintumi pawaoniti hangu wanyamalira jii na shipindi shilii wamgambira ndiri muntu vilii vyawawoniti. ");
INSERT INTO poy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Shirawu yakuwi Yesu pamuhera na wantumintumi watatu pawaweriti wankulawa kulugongu, lipinga likulu lya wantu waliwoniti na Yesu. ");
INSERT INTO poy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Muntu yumu mulipinga lilii kabota pakalonga, “Mfunda! Nukuhiga gwakamloli mwana gwangu, mwana gwangu gwa gweka! ");
INSERT INTO poy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Shamshera kamgaziyaga, pamonga kamtenda katendi umatu na pamonga kamtenda kaweri na shisirika na lifulufulu limlawa mumlomu. Kendereyiti kumgaziya nentu pota nakumlekeziya kanongola. ");
INSERT INTO poy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nuwaluwiti wafundwa wakuwi wamwusiyi shamshera kumbiti wasinda.” ");
INSERT INTO poy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu kawankula, “Mwenga shiyiwuku shahera moyu na shana vidoda! Hashi hankali na mwenga na panuwahepelera mpaka ndii?” Shakapanu kamgambira muntu uliya, “Gumjegi mwana gwaku panu.” ");
INSERT INTO poy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mndemba ulii pakaweriti kankumgendera Yesu, shamshera uliya kamgusiya pasi, kumtenda shisirika. Kumbiti Yesu kamkalipira shamshera ulii, kamuponiziya mndemba, su kamupa tati gwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wantu woseri walikangashiti kwa uwezu mkulu wa Mlungu. Wantu pawaweriti wankali wankulikangasha kila shintu shakatenditi Yesu, yomberi kawagambiriti wafundwa wakuwi, ");
INSERT INTO poy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Namlyaluwa shanuwagambiriti! Mwana gwa Muntu hawambati mumawoku ga wantu.” ");
INSERT INTO poy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kumbiti wafundwa werewiti ndiri ntambu yakatakuliti. Shitwatira ashi shiweriti shififwa kwawomberi nawavimani, womberi watira kumkosiya ntambu yakatakuliti. ");
INSERT INTO poy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Palawiriti magambiziyanu pakati pawu wantumintumi walii, gaa yakaweriti mkulu nentu. ");
INSERT INTO poy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu kavimaniti shawaliholiti, su kamtola mwana mdidini, kamgolosiya pakwegera na mweni, ");
INSERT INTO poy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","na kawagambira, “Muntu yoseri ulii yakamshemera mwana mdidini ayu kwa litawu lyangu, kanshemera neni na yoseri yakanshemera neni, viraa kamshemera yumu ulii yakantumiti. Yoseri yakaweriti mdidini pakati penu ndo mkulu kuliku woseri.” ");
INSERT INTO poy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohani kankula, “Mtuwa, tumwoniti muntu pakawusiya washamshera kwa litawu lyaku na twenga tumubera, toziya kaweriti ndiri mushipinga shetu.” ");
INSERT INTO poy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu kamgambira, “Namuwabera, toziya yoseri yakamlema ndiri yumu pakati penu, kawuwega wa twenga gwenu.” ");
INSERT INTO poy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Shipindi pashiweriti pakwegera sha Yesu mewamtoli kugenda kumpindi, yomberi kagonjera mwanja gwa Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kawatumiti wajumbi wamlongoleri na womberi wagenda mpaka mushijiji shimu sha Wasamariya, wamnyawili kila shintu. ");
INSERT INTO poy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kumbiti wenikaya walema kumshemera toziya yomberi kaweriti kankugenda Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Su wafundwa wakuwi, ashina Yohani na Yakobu, pawawoniti hangu walonga, “Mtuwa, gufira tugushemi motu kulawa kumpindi guwagamiziyi?” ");
INSERT INTO poy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu kawagalambukira na kawakalipira. ");
INSERT INTO poy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Shakapanu Yesu na wafundwa wakuwi wagenditi mushijiji shimonga. ");
INSERT INTO poy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pawaweriti munjira wankugenda, muntu yumu kamgambira Yesu, “Hanukufati koseri kwagugenda.” ");
INSERT INTO poy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu kamgambira, “Vibweta wawera na mpanga na wampongu wawera na vitukulu kumbiti Mwana gwa Muntu kahera pahala pa kwoyera.” ");
INSERT INTO poy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kamgambira muntu gwingi, “Gunfati.” Kumbiti muntu ulii kalonga, “Mtuwa, gundeki huti nakamsiri tati gwangu.” ");
INSERT INTO poy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu kamwankula, “Guwaleki wahowiti wawasiri wayawu wawahowiti. Gwenga gugendi gwakawubweri ufalumi wa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kuweriti na muntu gwingi yakamgambira Yesu, “Hanukufati Mtuwa, kumbiti gundeki huti ng'endi kuwaaga wantu wa ukaya kwangu.” ");
INSERT INTO poy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu kamgambira, “Muntu yoseri pakanja kulima, pakagalambuka na kulola kumbeli kafaa ndiri kutenda lihengu Muufalumi wa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Shakapanu Mtuwa kawasyagula wamonga malongu saba na awili. Kawatuma wamlongoleri awili awili wagendi muvijiji vyoseri vyakafira kugenda yomberi. ");
INSERT INTO poy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kawagambira, “Viboga vya kubena vivuwa, kumbiti wantu wakubena wadidini. Su mumluwi mweni kana lirambu kajegi wantu wakubena mulirambu lyakuwi. ");
INSERT INTO poy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Vinu su mgendi, muvimani handa nankuwatuma mwenga gambira mwawakondolu wawagenda pakati pa wamaminyi. ");
INSERT INTO poy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Namtola muhaku gwakutulila mpiya, ama libegi, ama vilwatu, namumlamsiya muntu yoseri munjira. ");
INSERT INTO poy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pamwingira mnumba yoseri, kwanja mtakuli hangu, ‘Ponga iweri mnumba amu!’ ");
INSERT INTO poy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Handa pakaweriti yakafira ponga, ponga yamwenga hayikali nayomberi, handa ndiri, ponga yamwenga hayiwawuyili mwaweni. ");
INSERT INTO poy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mwikali mnumba ayi pamliya na kulanda vyawakupanani, toziya yakatenda lihengu kafiruwa shibenamgongu shakuwi. Namgenda mala numba ayi ama yimonga. ");
INSERT INTO poy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Handa pamsoka muisi na wantu pawawashemerani, mlii vyawakupani, ");
INSERT INTO poy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","muwaponiziyi walweli muisi ilii na muwagambiri wantu, ‘Ufalumi wa Mlungu wapakwegera kwa mwenga.’ ");
INSERT INTO poy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kumbiti pamwingila muisi yoseri, wantu pawawalema kuwashemerani, muwuki na mlongi, ");
INSERT INTO poy_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ata lidika lyalitulemeteriti mumagulu mwetu tulipunda na haliweri likalipiru. Kumbiti muvimani kuwera Ufalumi wa Mlungu wapakwegera.’ ");
INSERT INTO poy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nakaka nukugambirani, lishaka lilii Isi ayi hayipati azabu nkulu kuliku ilii ya wantu wa Sodoma. ");
INSERT INTO poy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Shondi gwenga Kolazini! Shondi gwenga Betisayida! Handa mauzauza galawiriti kwa mwenga, megalawiri Tiru na Sidoni, wantu wakuwi mewavali nguwu zya maguniya shipindi shivuwa na kulivaga mulivu kuleka vidoda vyawatenda. ");
INSERT INTO poy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mlungu hakawapanani azabu nkulu nentu mulishaka lya kutoza kuliku Tiru na Sidoni. ");
INSERT INTO poy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na gwenga Kafarinaumu, hagulikwisi mweni mpaka kumpindi kwa Mlungu? Hawakusulusiyi mpaka mulirindi lyalihera upeleru.” ");
INSERT INTO poy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu kawagambira wantumintumi wakuwi, “Yakawapikanira mwenga kankumpikinira neni na yakawalema mwenga kanema neni, yakanema neni, ndo kamlema ulii yakantumiti.” ");
INSERT INTO poy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wantumini malongu saba na awili wawuyiti kwa manemu walonga, “Mtuwa, ata washamshera watujimila patuwakalipira kwa litawu lyaku!” ");
INSERT INTO poy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu kawankula, “Numwoniti Shetani pakaguwiti gambira lupanda kulawa kumpindi kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mpikaniri! Nukupani uwezu wa kutimbanga wanjoka na vipinini na uwezu mkulu kwajili ya makakala goseri ga Shetani, kwahera shintu shakuwatenduwa. ");
INSERT INTO poy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kumbiti namnemelera toziya washamshera wawajimila, ira mnemeleri toziya matawu genu wagalemba kumpindi.” ");
INSERT INTO poy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Shipindi shiraa shilii Yesu kanemeleriti kwa uwezu wa Rohu Mnanagala, kalonga, “Tati, Mtuwa gwa kumpindi na gwa paisi panu! Nonga mayagashii kwaku toziya guwalanguziya walii wahera mahala na guwafifa walii wanaluhala na wanamahala. Yina Tati, ntambu yagufiriti gumweni aga galawili. ");
INSERT INTO poy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tati gwangu kanupiti neni vintu vyoseri. Kwahera muntu yakammana Mwana ira Tati na kwahera yoseri yakammana Tati ira Mwana na yoseri yagagubutulitwi na Mwana.” ");
INSERT INTO poy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Shakapanu Yesu kawagalambukira wafundwa wakuwi na kuwagambira, “Mbaka waviwona vilii vyamuviwona mwenga. ");
INSERT INTO poy_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nukugambirani mwenga kuwera wambuyi wa Mlungu na wafalumi wafiriti kugawona galii gamugawoniti mwenga, kumbiti wagawona ndiri na kupikinira ntambu yampikaniriti mwenga kumbiti wapikinira ndiri.” ");
INSERT INTO poy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mfunda gwa Malagaliru kiziti na kufira kumjera Yesu. Su kamkosiya, “Mfunda, ntendi ashi mpati ukomu wa mashaka goseri?” ");
INSERT INTO poy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu kamwankula, “Walemba shishi Mumalagaliru Mlungu gakampananiti Musa? Kupikanira ntambu yampikaniriti mwenga kumbiti wapikanira ndiri. Gwenga gugamana hashi?” ");
INSERT INTO poy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Muntu ulii kawankula, “Gumfiri Mtuwa Mlungu gwaku kwa moyu gwaku goseri na kwa rohu yaku yoseri na kwa makakala gaku goseri na kwa mahala gaku goseri na gumfiri muyagu ntambu yagulifira gumweni.” ");
INSERT INTO poy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu kamgambira, “Guwankula weri, gutendi ntambu iraayi hagupati ukomu wa mashaka goseri.” ");
INSERT INTO poy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kumbiti mfunda gwa Malagaliru kafiriti kuliranguziya handa kahera vidoda, su kamkosiyiti Yesu, “Gwapakwegera gwangu ndo gaa?” ");
INSERT INTO poy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu kamwankula, “Kweniti na muntu yumu yakaweriti kankusuluka kulawa Yerusalemu, kaweriti kankugenda Yeriku. Pakaweriti munjira, wamvamiya wamajambazi wamkoma na kumpoka vintu vyakuwi wamleka kankugalagata nusula kahowi. ");
INSERT INTO poy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Shintu shashilawiti paliya, kweniti na mkulu gwa numba ya Mlungu kaweriti kankupita njira ilailii, kumbiti pakamwoniti muntu yawamkomiti ulii, kapititi patali uwega wingi kagenda. ");
INSERT INTO poy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ntambu ilailii Mlawi kapititi njira ilailii, kumbiti pakamwonit muntu yawamkomiti ulii kapititi patali, uwega wingi su kagenda. ");
INSERT INTO poy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kumbiti Msamariya yakaweriti kankugenda mwanja kasokiti paliya pakaweriti muntu ulii na pakamwoniti muntu ulii, kamwonera lusungu. ");
INSERT INTO poy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kamgendera, kampakaziya lipaki pamuhera na divayi muvironda vyakuwi na kumtawa, shakapanu kamkweniziya mupunda gwakuwi, kagenda nayu mpaka mnumba ya kugonja wahenga kamlwaziya. ");
INSERT INTO poy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Shirawu yakuwi kalaviya mpiya mbili kumpanani kananumba ya kufikira wahenga na kamgambira, ‘Gumloleli weri muntu ayu na pampuya hanukulipi shoseri shagutumiyiti kwa muntu ayu.’ ” ");
INSERT INTO poy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu kamaliliti kulonga kwa kukosiya, “Ntambu yamlihola, pakati pa wantu watatu awa, ndo gaa kaweri kapakwegera gwa muntu yakakomitwi na majambazi?” ");
INSERT INTO poy_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mfunda gwa Malagaliru kamwankula, “Uliya yakamwoniriti lusungu.” Yesu kamgambira, “Gugendi gwakatendi ntambu iraayi.” ");
INSERT INTO poy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu pamuhera na wantumintumi wakuwi pawaweriti mumwanja, wingira mushijiji shimu waliwona na mdala yumu yawamshema Marita kamshemera ukaya kwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marita kaweriti na muhasha gwakuwi yawamshema Mariya, yakalivagiti pakwegera pamagulu ga Yesu pakapikanira mafundu gakuwi. ");
INSERT INTO poy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marita kaweriti kankunyoganyoga na vimonga, su kamgenderiti Yesu na kumgambira, “Mtuwa, iwera hashi gumleka muhasha gwangu kandekeri neni nyoginyogi gweka yangu? Gumgambiri kizi, kantangi!” ");
INSERT INTO poy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mtuwa kamwankula, “Marita, Marita! Gwankunyoganyoga na kuligaziya na vintu vivuwa, ");
INSERT INTO poy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kumbiti shintu shimu hera shifiruwa. Mariya kasyangula shintu shiherepa nentu na kwahera muntu hakampoki.” ");
INSERT INTO poy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lishaka limu Yesu kaweriti pahala tunga pakaluwa Mlungu. Pakamaliriti kuluwa Mlungu, yumu gwa wafundwa wakuwi kamgambira, “Mtuwa, gutufundi kuluwa Mlungu gambira Yohani Mbatiza ntambu yakawafunditi wafundwa wakuwi.” ");
INSERT INTO poy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu kawagambira, “Pamluwa Mlungu mlongi hangu, ‘Tati, Litawu lyaku likwiswi, Ufalumi waku wizi. ");
INSERT INTO poy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gutupanani shiboga shetu sha kila lishaka ");
INSERT INTO poy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gutulekiziyi vidoda vyetu, Mana twenga tuwalekeziya woseri yawatutenditi upyota. Pota nagututula mukujerwa.’ ” ");
INSERT INTO poy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na Yesu kawagambira wantumintumi wakuwi, “Payiwera yumu gwenu pakagenda ukaya kwa ganja gwakuwi pashiru na kumgambira, ‘Ganja, shondi shondi nyagu gunkopeshi mabumunda mitatu. ");
INSERT INTO poy_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ganja gwangu yakaweriti mumwanja, kapitira pakaya pangu na neni nahera shiboga shakumupa.’ ");
INSERT INTO poy_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na payiwera ganja gwaku kankuwankula kulawa mnumba, ‘Nagung'aziya! Mlyangu gutatwa kala, neni pamuhera na wana wangu tugonja kala. Na hapeni numuki kukupanani shintu shoseri.’ ");
INSERT INTO poy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nakaka nankuwagambirani, ata pakalema kwimuka na kukupanani mabumunda toziya gwenga gwa ganja gwakuwi, kumbiti pagwendereya kumgaziya kwa kumluwa hakimuki na kukupanana shoseri shagufira. ");
INSERT INTO poy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Su nankuwagambira, guluwi na hampananwi, gusakuli na haguwoni, gutendi hodi na hamvugulirwi. ");
INSERT INTO poy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mana woseri yawaluwa hawapananwi na woseri yawasakula, hawawoni na mlyangu haguvugulwi kwa kila muntu yakatenda hodi. ");
INSERT INTO poy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mwana pakamluwa tati gwakuwi somba, hashi hakampanani njoka badala ya somba? ");
INSERT INTO poy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na pakamluwa ligi, hakampanani shipinini? ");
INSERT INTO poy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Su payiwera mwenga yamuwera na vidoda, muvimana kuwapanana viherepa vyawaluwa wana wenu. Nakaka Tati gwenu gwakumpindi hakatendi kupita mwenga, hakawapanani Rohu Mnanagala walii yawamluwa!” ");
INSERT INTO poy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu kaweriti kankumwinga shamshera yakamtenditi muntu yumu kaweri bubu. Su shamshera ulii pakamlawiti, muntu ulii kaweziti kutakula. Lipinga lya wantu lilikangashiti, ");
INSERT INTO poy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","kumbiti wantu wamu mulipinga lilii walonga, “Belizebuli, mkulu gwa washamshera ndo yakampananiti makakala ga kuwalaviya washamshera.” ");
INSERT INTO poy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wamonga wafiriti kumjera Yesu, su wamgambira kawalanguziyi mauzauza kulonga nakaka Mlungu ndo yakamtumiti. ");
INSERT INTO poy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kumbiti Yesu kavimaniti kala shawalihola, su kawagambira, “Ufalumi woseri waubagulika weni vipinga vipinga vyavisingana vyeni hapeni vilikali, kaya payibagulika yeni mpaka iyagamili. ");
INSERT INTO poy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Su handa ufalumi wa Shetani pawuwera muvipinga na pawalikoma weni, hawuendereyi hashi? Mlonga kuwera ndaviya washamshera toziya Belizebuli kanupiti makakala ga kutenda aga, ");
INSERT INTO poy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","handa neni nankuwawusiya washamshera kwa likakala lya belizebuli, hashi wafata wenu wawawusiya kwa uwezu gaa? Wafata wenu hawaweri watoza wenu! ");
INSERT INTO poy_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kumbiti payiwera nankuwinga washamshera kwa makakala ga Mlungu, su muvimani kuwera Ufalumi wa Mlungu usoka kala kwa mwenga. ");
INSERT INTO poy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Muntu kana makakala pakawera na silaha zoseri, pakalolera numba yakuwi mweni, vyoseri vyakaweriti navi haviweri salama. ");
INSERT INTO poy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kumbiti pakiza muntu kana makakala kuliku yomberi pakamkoma na kumsinda, hakatoli silaha zoseri zakalitumbiriti muntu ulii na kugawana ulunda wakuwi. ");
INSERT INTO poy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Yoseri yakawera ndiri uwega wa neni ndo nakaka kanema neni na yoseri yakajojinira ndiri pamuhera na neni, ayu ndo kapalasiya. ");
INSERT INTO poy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Shamshera pakawingwa kulawa kwa muntu, kayerayera mlaa mushiwala pakasakula pakwoyera. Pakapata ndiri pakwoyera, kalitakuziya mweni, ‘Hambuyi kunumba kwangu kwandawiti.’ ");
INSERT INTO poy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pakawuya na kwona numba ilii wayifyagira na kuyiherepiziya. ");
INSERT INTO poy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Su kagenda kuwatola washamshera wayaguwi wamonga saba wadoda kuliku yomberi, woseri wagenda kumwingira muntu ayu. Su ntambu ya muntu ayu hayiweri idoda kuliku ntambu yayiweriti kwanja.” ");
INSERT INTO poy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu pakaweriti kankutakula hangu, mdala yumu kulawa mulipinga lya wantu kamgambira, “Mbaka mdala yakakuleriti na kukunoniziya!” ");
INSERT INTO poy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kumbiti Yesu kamwankula, “Mbaka nentu kwa walii yawapikanira shisoweru sha Mlungu na kushijimira” ");
INSERT INTO poy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lipinga lya wantu palimzingiti Yesu, kendereyiti kutakula, “Shiyiwuku shikondola na shashihera uwaminika kulongolu kwa Mlungu! Mfira mauzauza, kumbiti hapeni mpananwi liuzauza lyoseri lilii ira hampananwi liwuzawuza lya Yona.” ");
INSERT INTO poy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ntambu ira ilii Yona mbuyi gwa Mlungu pakaweriti lilangaliru kwa wantu wa Ninawi, su Mwana gwa Muntu hakaweri lilangaliru kwa wantu wa mashaka aga. ");
INSERT INTO poy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Malikiya gwa kusika hakalawili shipindi shiyiwuku ashi pashitozwa na yomberi hakawatozi. Toziya mweni kagenditi mwanja kulawa kutali, kiziti kuvipikinira visoweru vya luhala lwa mfalumi Selemani, kumbiti panu kwana mkulu kuliku Selemani! ");
INSERT INTO poy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mulishaka lya kutoza, wantu wa Ninawi hawagoloki pamuhera na shiyiwuku ashi na womberi hawashitozi. Toziya wantu wa Ninawi walekiti vidoda vyawatenditi pawamupikaniriti Yona pakabwera, kumbiti panu kwana shitwatila shikulu kuliku Yona. ");
INSERT INTO poy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kwahera muntu yakawasha shikoroboyi na kushigubikira na mufiniku, ira hakashituli pashintambi, su wantu pawingira mnumba wapati kuwona kulangala. ");
INSERT INTO poy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Masu gaku ga gambira shikoloboyi sha nshimba. Masu gaku pagawera makomu, nshimba yaku yoseri hayiweri ilangala, kumbiti masu gaku pagawera gaherepa ndiri, nshimba yaku yoseri hayiweri muluwindu. ");
INSERT INTO poy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Su gwikali weri, gulangala gwaguweriti mngati mwaku naguwera luwindu. ");
INSERT INTO poy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Handa nshimba yaku yoseri paiwera ilangala, pota kuwera pahala poseri pa luwindu, nshimba ayi hayilangali nakaka gambira shikoloboyi ntambu yashikulangalira kwa gulangala wakuwi.” ");
INSERT INTO poy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu pakamaliriti kulonga, Mfalisayu yumu kamshemeriti ukaya kwakuwi waliyi shiboga pamuhera, su Yesu kagenditi na kulivaga kuliya shiboga. ");
INSERT INTO poy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mafalisayu walikangasha pawamwoniti kankuliya shiboga pota kugulula huti mawoku. ");
INSERT INTO poy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Su Mtuwa kamgambira, “Mwenga Mafalisayu mgulula vikombi na sahani kwa kunja kumbiti mngati mmema lwamata na vidoda. ");
INSERT INTO poy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mwawazyigizyigi mwenga! Mlungu ndo yakanyawiti kunja, kayi kanyawiti mngati. ");
INSERT INTO poy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kumbiti muwayupi wahushu shilii shashiweriti muvikombi na musahani na kila shintu hashiweri shiherepa kwa mwenga. ");
INSERT INTO poy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Shondi mwenga Mafalisayu! Mwankumupa Mlungu zaka zya binzari na mshisha na mihamba yamonga na uganu pamlema yagamfiriziya Mlungu na ufiru wa Mlungu. Vitwatila avi mfiruwa muviloli weri pota na kulyaluwa vyamonga. ");
INSERT INTO poy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Shondi mwenga Mafalisayu! Mfira kulivaga palongolu pawapapanana ligoya munumba za Mlungu na kukulamsiyani kwa ligoya pahala pa soku. ");
INSERT INTO poy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Shondi mwenga! Toziya mulifana na mapumba yagalififa, wantu pawagendagenda kunani kwakuwi pota na kuvimana.” ");
INSERT INTO poy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yumu gwa Wafunda wa Malagaliru kamgambira, “Mfunda, pagutakuliti hangu, gutuhigilanga na twenga vilavi.” ");
INSERT INTO poy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu kamwankula, “Shondi mwenga wafunda wa Malagaliru! Muwatwika wantu visanka vipapika ndiri, kumbiti mwaweni mwenga muweza ndiri ata kwa shala kuwatanga. ");
INSERT INTO poy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Shondi mwenga! Mganyawa mapumba gaherepa ga wambuyi wa Mlungu, weni wazewi wenu wawalagiti. ");
INSERT INTO poy_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Su mgapitawulira na kugajimira galii gawatenditi wazewi wenu, wawalagiti wambuyi wa Mlungu, na mwenga mugajengera mapumba gawu. ");
INSERT INTO poy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Toziya ayi Luhala lya Mlungu lutakuliti hangu, ‘Hanuwajegeri wambuyi wa Mlungu na wantumintumi, kumbiti hawawalagi wambuyi wa Mlungu wamu na kuwatabisiya wamonga.’ ");
INSERT INTO poy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Su wantu wa shipindi ashi hawatozwi kwa kuwalaga wambuyi wa Mlungu kwanjira pawanyawiti pasipanu, ");
INSERT INTO poy_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kwanjira pawamlagiti Abeli mpaka Zakariya ulii yawamlagiti pakati pashitalawanda sha kutambikira, pahala Pananagala. Yina, nakuwagambira, wantu wa shipindi ashi hawatozwi kwa matendu gawu. ");
INSERT INTO poy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Shondi mwenga wafunda wa Malagaliru! Muufifa ufunguu ulii wa mlyangu gwa mahala na mwaweni mwenga hapeni mwingiri na muwalewelera woseri yawafira kwingira nawingira.” ");
INSERT INTO poy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pakaweriti kankuwuka palii, wafunda wa Malagaliru pamuhera na Mafalisayu wanjiti kumgambira pawambeziya nentu na kumkosiya kwajili ya vintu vivuwa, ");
INSERT INTO poy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","pawajera kumgomiziya pakatakula shintu shipayira su wapati pakumbatira. ");
INSERT INTO poy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Maelufu ga wantu pawaliwoniti pamuhera, ata waweriti wankulitimbanga, Yesu kawagambiriti huti wafundwa wakuwi, “Mliloleri weri na simika ya Mafalisayu, nana mana ufyangu. ");
INSERT INTO poy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kila shintu shawashigubikiti hashiweri paweru na kila bada hayimaniki. ");
INSERT INTO poy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Su vyoseri vyamtakuliti muluwindu havipikaniki paluwala, ata vilii vyamulipwepwera shipindi pamtatiti milyangu havibwerwi panani pa numba. ");
INSERT INTO poy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nukugambirani waganja wangu, namuwatira woseri yawalaga nshimba kumbiti wasinda kutenda shintu shimonga nentu. ");
INSERT INTO poy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Hanuwalanguziyani gwa kumtira, mumtiri Mlungu, ayu pakawalaga kala kana uwezu wa kumwasira muntu mumotu gwa Jehanamu. Munjimiri, ayu ndo yumu gwa kumtira! ");
INSERT INTO poy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Iwera ndiri washomolu wamuhanu wawawuza kwa senti ndikandika mbili? Kumbiti Mlungu hapeni kamuwaluwi shomolu ata yumu. ");
INSERT INTO poy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ata vilii zya mumtuwi mwenu waziwalangiti kala. Su namtira, mwenga wa mana nentu kuliku washomolu wavuwa! ");
INSERT INTO poy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nankuwagambira nakaka, kila muntu yakatakula kulongolu kwa wantu kulonga ndo gwaneni, Mwana gwa Muntu hakatakuli kulongolu kwa wantumintumi wa kumpindi wa Mlungu kuwera muntu ayu ndo gwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kumbiti woseri yawanema kulongolu kwa wantu, Mwana gwa muntu viraa hakawalemi kulongolu kwa wantumintumi wa kumpindi wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Na yoseri Yakamtakulira visoweru vidoda mwana gwa Muntu hakalekiziwi, kumbiti yoseri yakamwigilanga Rohu Mnanagala hapeni kalekeziwi. ");
INSERT INTO poy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pawawabata na kuwajega munumba za Mlungu, ama kwa wakulu na wakolamlima, namulihola hola ntambu yakutakula ama ntambu ya kujiteteya. ");
INSERT INTO poy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Toziya Rohu Mnanagala shipindi shiraa shilii hakawafundi ntambu yakutakula.” ");
INSERT INTO poy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Muntu yumu mulipinga lya wantu kamgambiriti Yesu, “Mfunda, gumgambiri mlongu gwangu tugawani uhala yakatulekeleriti tati gwetu.” ");
INSERT INTO poy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu kamwankula, “Ganja gwangu, gaa yakantyeka neni weri mtoza gwenu?” ");
INSERT INTO poy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Su kawagambira woseri, “Muweri masu na muliloli weri na ntambu zoseri za matamata, toziya makaliru ganakaka ga muntu galitumbira ndiri vintu vivuwa vyakawera navi.” ");
INSERT INTO poy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesu kawagambira mfanu agu, “Kuweriti na mlunda yumu yakaweriti na lirambu lyakuwi lyalileriti viboga nentu. ");
INSERT INTO poy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kanjiti kulihola mumoyu mwakuwi pakalonga, ‘Nahera pahala pa kutula viboga vyangu vyoseri. Su hantendi hashi?’ ");
INSERT INTO poy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kaligambiriti mweni, ‘Hantendi hangu, hambomoli hanja zyangu zoseri na kunyawa nkulu nentu, su hantuli viboga vyangu na lunda zyangu zimonga. ");
INSERT INTO poy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Shakapanu hanuligambiri mweni, Muntu yakana bahati! Gwana vintu vivuwa viherepa vya kuliya vinja ivuwa. Guvibojoli, vinu su gulii, gulandi na gulinemiziyi gumweni!’ ");
INSERT INTO poy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kumbiti Mlungu kamgambira, ‘mzyigizyigi gwenga! Leru pashiru rohu yaku hayitolwi. Vinu gaa hakatoli vintu vyoseri vyaguvituliti kwajili yaku gumweni?’ ” ");
INSERT INTO poy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Na Yesu kamaliriti pakatakula, “Ayi ndo ntambu hayiweri kwa muntu ulii yakalitulira ulunda kwajili yakuwi mweni kumbiti hapeni kaweri mlunda kwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu kawagambira wafundwa, “Nankuwagambira mleki kulihola hola makaliru genu ama nguwu zya kuvala. ");
INSERT INTO poy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ukomu wa mana nentu kuliku shiboga na nshimba yana mana nentu kuliku nguwu. ");
INSERT INTO poy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mloli wampongu, wayala ndiri ama wabenanga ndiri, kayi wahera ata luhanja lwa kutulila viboga, kumbiti Mlungu kawapanana shiboga! Mwenga muwera na mana nentu kuliku wampongu! ");
INSERT INTO poy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kwana muntu yoseri pakati penu yakaweza kwongera mweni makaliru gakuwi ata kwa saa yimu? ");
INSERT INTO poy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Handa pamuweza ndiri ata kutenda shintu shididini, iwera hashi mulihola hola vintu vimonga? ");
INSERT INTO poy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Muloli mawuwa ga kuntundu ntambu yagakula, gatenda ndiri lihengu ama galinyawa ndiri geni. Kumbiti nukugambirani kuwera Mfalumi Selemani pamuhera na ulunda wakuwi woseri kapatiti ndiri kuvalisiwa gambira mawuwa aga. ");
INSERT INTO poy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Payiwera Mlungu kaluvalusiya luhamba lya kuisi, lweni leru luwera na shirawu walwasila pamotu, ashi ndiri hakawatenderi nentu mwenga? Mwenga yamuwera na njimiru ndidini! ");
INSERT INTO poy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Su namuligaziya kwa kusaluka shintu sha kuliya ama shintu sha kulanda. ");
INSERT INTO poy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Toziya wantu yawamumana ndiri Mlungu pasipanu wavisakula nentu vintu vyoseri avi. Tati gwenu kavimana mfira vintu avi. ");
INSERT INTO poy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kumbiti msakuli huti Ufalumi wa Mlungu na hakawapanani vintu avi. ");
INSERT INTO poy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mwenga shipinga shididini namtira, toziya Tati gwenu kafira kuwapanana Ufalumi. ");
INSERT INTO poy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Muwuzi vyoseri vyamuwera navi na muwapanani mpiya wahushu. Mulinyawili mihaku yayidegeka ndiri na mtuli ulunda wenu kumpindi kwa Mlungu, kweni aku hapeni ipungulwi toziya kwahera mpoka yakaweza kwiwa, ama wameyi yawaweza kuhalibisiya. ");
INSERT INTO poy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ulunda waku pawuwera, ndo na moyu gwaku haguweri. ");
INSERT INTO poy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Muweri kala kwa kila shintu shashiza na muviwashi vikoloboyi vyenu, ");
INSERT INTO poy_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","gambira wantumintumi yawamuhepera mtuwa gwawu yakiza kulawa mumsambu gwa ndowa. Pakawera kankwiza na kutenda hodi, su hawamvugulili mlyangu kamukamu. ");
INSERT INTO poy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mbaka kwa walii wantumintumi, mtuwa gwawu pakiza hakawawoni wankali masu! Nukugambirani nakaka, hakavuli nguwu yakuwi, nakuwagambira walivagi pasi na kuwatendera. ");
INSERT INTO poy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hawaweri na manemu ga ntambu gaa handa pakawawona wankali masu, ata pakiza pashiru ama pamandawira! ");
INSERT INTO poy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Muvimani nakaka kuwera handa mweni kana numba pakavimaniti shipindi shakwiza mpoka, hapeni kamleki mpoka kubomolanga numba yakuwi. ");
INSERT INTO poy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na mwenga viraa, muweri kala, toziya Mwana gwa Muntu hakizi shipindi shamumana ndiri.” ");
INSERT INTO poy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peteru kamgambira, “Mtuwa, mfanu agu ndo kwajili ya twenga, ama kwajili ya kila muntu?” ");
INSERT INTO poy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mtuwa kawankula, “Ndo gaa yakawera ntumintumi kaaminika na yakana mahala? Ndo ulii mtuwa gwakuwi yakamtula kaweri mlolera gwa numba na kuwapanana wantumintumi wamonga wa mtuwa gwakuwi kwa shipindi shifaa. ");
INSERT INTO poy_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mbaka yakuwi ntumintumi ulii, mtuwa gwakuwi pakawuya hakamwoni pakatenda hangu. ");
INSERT INTO poy_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nakaka nukugambirani, mtuwa hakampanani ukulu gwa vintu vyakuwi vyoseri. ");
INSERT INTO poy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kumbiti handa ntumintumi pakalitakulila mweni mumoyu, kuwera mtuwa gwakuwi kakawa shipindi shivuwa nentu kwiza, su kanja kuwakomanga wantumintumi wamonga, woseri wapalu pamuhera na wadala, su kalanda na kuliya shiboga pamuhera na kulanda ujimbi, ");
INSERT INTO poy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","shakapanu mtuwa gwakuwi ntumintumi ulii hakizi lishaka na shipindi shakashimana ndiri. Mtuwa hakamdumuli vipandi vipandi na kumwasira kunja na kumtula mushipinga shimuhera na yawajimira ndiri. ");
INSERT INTO poy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ntumintumi yakavimana shakafira mtuwa gwakuwi kutenda, kumbiti kawera ndiri kala kutenda, hawamkomi nentu. ");
INSERT INTO poy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kumbiti ntumintumi yakavimana ndiri shilii shakafira mtuwa gwakuwi, na viraa katenda shilii shimtenda wamkomi, hawamkomi padidika. Yawampananiti vivuwa hawamdayi vivuwa, kumbiti yawampananiti vivuwa nentu hawamdayi vintu vivuwa nentu. ");
INSERT INTO poy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Niza kukoziya motu pasipanu, hera hangu meguweri gwakiti kala! ");
INSERT INTO poy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nana ubatizu weni nfiruwa nuwanki na ntabika nentu mpaka ukamiliki. ");
INSERT INTO poy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mulihola niza kujega ponga pasipanu? Ndala, kumbiti niza kupalanganyiya. ");
INSERT INTO poy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kwanjira vinu na kwendeleya kaya ya wantu wamuhanu hawapalanganyiki na wantu watatu hawalisingani kwa wantu wawili na wantu wawili hawalisingani kwa wantu watatu. ");
INSERT INTO poy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Watati hawalisingani na wana wawu na wana hawalisingani na watati na wamawu hawawalemi wahinga wawu na wahinga hawawalemi wamawu na wanahonga hawawalemi wamika mwana na wamika mwana hawawalemi wanahonga wawu.” ");
INSERT INTO poy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu viraa kawagambiriti wantu, “Pamuwona liwundi lilawira kushana, mala mlonga hakatowi na nakaka vula itowa. ");
INSERT INTO poy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pamuwona lihemuhemu lya kusika lyankuvuma, mlonga hakuweri na mshenji na nakaka iwera. ");
INSERT INTO poy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mwawafyangu mwenga! Muvimana kutunga lishaka ntambu yaliwera kwa kulola isi na liyera, kumbiti kwa ntambu gaa muvimana ndiri mana ya shipindi ashi?” ");
INSERT INTO poy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ntambu gaa msinda kuamuwa maweni kutenda shitwatira shiheri? ");
INSERT INTO poy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Handa mstaki gwaku kankukujega pashizyungu, iherepa nentu mulikoli mawoku pamuwera mwankali munjira. Pamutenda ndiri hangu, nakakujega kwa mtoza mweni hakakujegi kwa wamanjagila na womberi hawakutuli mushibetubetu. ");
INSERT INTO poy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nakaka nukugambira hapeni gulawi mulii mpaka gulipi ata ligwala lya kumalalira.” ");
INSERT INTO poy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Shipindi shilii wantu wamu yawaweriti palii wamgambiriti Yesu kwajili wantu wa Galilaya weni Pilatu kawalagiti pawaweriti wankulaviya tambiku kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu kawakosiya, “Toziya wantu wa Galilaya wawalagiti kwa njira ilii, mlihola kuwera waweriti na vidoda kuliku wantu wa Galilaya wamonga? ");
INSERT INTO poy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Neni nonga, ndala! Nukugambirani kuwera handa pamlema kuleka vidoda vyamtenda, hamhowi ntambu yawahowiti womberi. ");
INSERT INTO poy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ntambu gaa kwajili ya wantu lilongu na wanani wa Silowamu yawahowiti shipindi mnara paguwatulukiriti? Mlihola kuwera womberi waweriti wanavidoda kuliku wantu wamonga wawalikala Yerusalemu? ");
INSERT INTO poy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ndala! Nukugambirani mwenga, handa pamlema kuleka vidoda vyamtenda, hamhowi ntambu yawahowiti womberi.” ");
INSERT INTO poy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Su Yesu kawagambiriti mfanu agu, “Kuweriti na muntu yumu, keniti na mtera gwa tini mulirambu lyakuwi. Kagenditi kwapa tini mumtera kumbiti kapata ndiri. ");
INSERT INTO poy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Su kamgambiriti ntumintumi gwa lirambu, ‘Guloli, kwa mivinja mitatu paniza kwapa mabwajubwaju mumtera gwa tini, kumbiti nugawona ndiri. Gugudumuli! Toziya gumalira hera litapaka.’ ");
INSERT INTO poy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kumbiti ntumintumi kamgambira, ‘Mtuwa, guguleki huti kwa shinja shimu hera, hanugulimili na kugulekera mbotu. ");
INSERT INTO poy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pagulera mabwajubwaju shinja shankwiza, hayiherepi nentu, kumbiti pagulera ndiri su guweza kugudumula.’ ” ");
INSERT INTO poy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesu kaweriti munumba ya Mlungu mulishaka lya kwoyera pakafunda. ");
INSERT INTO poy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Palii peniti na mdala yakeniti na shamshera yakamtenda kalwali mivinja lilongu na nane, kaweriti na shibyongu ata kasinditi kugoloka. ");
INSERT INTO poy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu pakamwoniti kamshema, “Mawu, su guponiziwa ulweli waku!” ");
INSERT INTO poy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kamtulila mawoku gakuwi, na palaa palii shibyongu shihuka na kawera safi, su kamkwisiti Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mkulu gwa numba ya Mlungu kaweriti kakalala Yesu pakamponiziyiti mulishaka lya kwoyera, su kawagambiriti wantu, “Kwana mashaka sita gamuweza kutenda lihengu, mwizi mumashaka aga muponiziwi malweli genu, namwiza Mulishaka lya kwoyera!” ");
INSERT INTO poy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mtuwa kamwankula, “Gwamfyangu gwenga! Ndo gaa pakati penu mekamvuguli ng'ombi ama punda gwakuwi kulawa mulizizi na kumtenda kalandi mashi ata payiwera lishaka lya kwoyera? ");
INSERT INTO poy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Vinu su peni panu kwana muhinga gwa Aburahamu ndomweni Shetani kamtenda shibyongu kwa mivinja lilongu na nane, su iherepa ndiri kumponiziya mulishaka lya kwoyera?” ");
INSERT INTO poy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kuwankula kwakuwi kuwatenditi wadoda wawoni soni weni, kumbiti wantu wamonga wanemeleriti toziya ya vitwatira vyakatenditi. ");
INSERT INTO poy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu kakosiyiti, “Ufalumi wa Mlungu ulifana na shishi? Nuufaniziyi na shintu gaa? ");
INSERT INTO poy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ulifana hangu. Muntu katola mbeyu ndidini nentu ya haradali na kuyala mulirambu. Mbeyu imera na kuwera mtera, na wampongu wiza na kunyawa vitukulu vyawu mumitambi.” ");
INSERT INTO poy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kayi Yesu kakosiya, “Hanuufaniziyi Ufalumi wa Mlungu na shintu gaa? ");
INSERT INTO poy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ulifana na simika yakatoliti mawu yumu na kuyihanganyiya pamuhera na ubumu vipimu vitatu, su ubumu woseri ututumuka.” ");
INSERT INTO poy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu kendereyiti na mwanja gwakuwi kugenda muisi na muvijiji, pakafunda wantu na pakanyawa njira yakuwi kugenda Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Muntu yumu su kamkosiya, “Mtuwa, wantu hawawalopoziyi ndo wadidini hera?” Yesu kawagambiriti, ");
INSERT INTO poy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mkamaliri nentu kwingira mumlyangu mdidini, toziya wantu wavuwa hawajeli nakaka kwingira kumbiti hapeni wingiri. ");
INSERT INTO poy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mkulu gwa numba hakimuki na kutata mlyangu, mwenga hamgoloki kunja na kwanja kukota mlyangu na kulonga, ‘Mtuwa, mtuwa! Gutuvuguliri mlyangu!’ Nayomberi hakawankuli, ‘Nuwamana ndiri mwenga na pamlawa!’ ");
INSERT INTO poy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Su mwenga hamwankuli, ‘Tuliya na kulanda pamuwera na gwenga, na gwenga gutufunditi muisi yetu!’ ");
INSERT INTO poy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kumbiti yomberi kayi hakalongi, ‘Nupamana ndiri pamlawa. Muwuki kulawa kwaneni mwoseri mtenda vidoda!’ ");
INSERT INTO poy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Su panu hamulili na kugayagaya menu genu pawakwasirani kunja na hamuwaloli Aburahamu na Isaka na Yakobu na wambuyi wa Mlungu Muufalumi wa Mlungu! ");
INSERT INTO poy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wantu hawizi kulawa kwagulawa mushenji na kwaguzyeta mushenji, kulawa kushana na kusika, su hawaweri mumsambu Muufalumi wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Su woseri yawawera wa upeleru hawaweri wa kwanja, na woseri yawawera vinu wa kwanja hawaweri wa upeleru.” ");
INSERT INTO poy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Shipindi shilaa shiliya Wamafalisayu wamu wamwiziriti Yesu na kumgambira, “Gufiruwa guwuki panu na gugendi pahala pingi, toziya Herodi kafira kakulagi gwenga!” ");
INSERT INTO poy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu kawankula, “Mgendi mwakamgambiri shibweta ulii hangu, ‘Nankuwalaviya washamshera na kuwaponiziya walweli leru na shilawu, na lishaka lya tatu hamalili lihengu lyangu.’ ");
INSERT INTO poy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Vila vilii mpaka nweri mumwanja leru, na shilawu, na lishaka limonga, toziya iherepa ndiri kwa mbuyi gwa Mlungu wamlagi kunja kwa Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yerusalemu! Shondi shondi Yerusalemu bamu! Guwalaga wambuyi wa Mlungu, guwagumanga kwa mabuwi walii yawatumitwi kwaku! Vipindi vivuwa nfira kuwatula wana waku mumawoku mwangu gambira nkuku pakavigupika vyana vyakuwi kwa mbapatiru zyakuwi, kumbiti gwenga gunema! ");
INSERT INTO poy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Su hawakulekeli gumweni numba yaku. Nukugambira nakaka gwenga hapeni muwoni mpaka shipindi shiza pamtakula, ‘Mlungu gumtekeleri ulii yakiza mulitawu lya Mtuwa.’ ” ");
INSERT INTO poy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lishaka limu lya kwoyera, Yesu kagenditi kuliya shiboga kwa yumu gwa walongoziya wa Mafalisayu, na wantu wawaweriti palii waweriti wankumlola handa hakatendi shishi. ");
INSERT INTO poy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Muntu mweni magulu na mawoku gakuwi gatutuma, kamwiziliti Yesu, ");
INSERT INTO poy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","na Yesu kawakosiyiti wafunda wa Malagaliru na Mafalisayu, “Hashi, Lilagaliru lya twenga lituruusu kuponiziya mulishaka lya kwoyera?” ");
INSERT INTO poy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kumbiti womberi watakula ndiri shintu. Yesu kamshinkula muntu ulii na kumponiziya na kamleka kagendi zyakuwi. ");
INSERT INTO poy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Su kawagambira, “Kwana muntu yoseri pakati penu yakawera na mwana ama ng'ombi yakapatukiliti mulirindi mulishaka lya kwoyera su hapeni kamlaviyi toziya ya lishaka lya kwoyera?” ");
INSERT INTO poy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Woseri wasinda shakutakula, su wanyamalira jii. ");
INSERT INTO poy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu kaloliti wahenga wamu ntambu yawasyagula pahala paherepa nentu, su kawagambira woseri mfanu agu, ");
INSERT INTO poy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Muntu yoseri pakakushemerani mumsambu gwa arusi, namlivaga pahala paherepa nentu. Mana pamonga kwana muntu yakawera mkulu kuliku gwenga wamshemera, ");
INSERT INTO poy_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na ulii mwenikaya kakugambili, ‘Gumlekeli shiti ayu.’ Su palii haguwoni soni na hagugendi kulivaga pahala pa upeleru. ");
INSERT INTO poy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ira pagushemelwa, gugendi na kulivaga pahala pa upeleru, su mweni kaya gwaku hakizi kwaku na kukugambira, ‘Ganja gwangu, gwizi uganu, pahala paherepa ng'anji.’ Palii hagupananwi ligoya palongolu pa wahenga wamonga woseri. ");
INSERT INTO poy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kwa woseri yawalikweniziya hawawasulusiyi, na woseri yawalisulusiya weni hawawakweniziyi.” ");
INSERT INTO poy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Shakapanu Yesu kumgambira na ulii yakamshemera, “Handa pagutenda msambu paliwala ama pashiru naguwashemera waganja waku ama walongu waku ama wapakwegera waku, toziya hawakushemeri na gwenga vira, na kwanjira ayi hagupati shilii shagutenditi kwawu. ");
INSERT INTO poy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Gwenga pagutenda msambu, guwashemeli wahushu, na wavibyeketu, na wana lwisi, ");
INSERT INTO poy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","na hagutekelelwi, toziya hapeni wakulipi shilii shagutenditi kwawu. Mlungu hakakulipi gwenga mulishaka lya wantu waheri pawazyuka.” ");
INSERT INTO poy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yumu gwa wantu yawalivagiti kulongolu kwa meza kapikaniriti aga, kamgambiriti Yesu, “Mbaka woseri hawawalivagi mumsambu Muufalumi wa Mlungu!” ");
INSERT INTO poy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu kamgambira, “Kwana muntu yumu yakatenditi msambu mkulu na kawashemiriti wantu wavuwa. ");
INSERT INTO poy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Payiweriti shipindi sha msambu, kawatumiti wantumintumi wakuwi wagendi wakawagambiri walii yawashemiritwi, ‘Wizi, toziya kila shintu shiwera kala!’ ");
INSERT INTO poy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kumbiti wantu woseri, yumu pa yumonga wanjiti kulonga toziya ya kuleka kwiza. Muntu gwa kwanja kamgambiriti ntumintumi, ‘Hemeriti lirambu su nfiruwa ng'endi nukaliloli, su nduwa hapeni nizi.’ ");
INSERT INTO poy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Muntu gwingi katakula, ‘Hemeriti wang'ombi lilongu limu na nankugolokera kugenda kuwajera mulirambu, su nduwa hapeni nizi!’ ");
INSERT INTO poy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na yumonga katakula, ‘Neni nyuga mdala, su hapeni nizi.’ ");
INSERT INTO poy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Su ntumintumi kawuya na kumgambira goseri mtuwa gwakuwi. Mtuwa ulii kakalaliti nentu na kumgambira ntumintumi gwakuwi, ‘kanongola gugendi munjira na muvipenyu vya muisi, gwakawajegi wahushu, na wavibyeketu na wanalwisi wavibyeketu wamonga.’ ");
INSERT INTO poy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pamberi ntumintumi kalonga, ‘Mtuwa, vitwatira vitendeka ntambu yagutakuliti, kumbiti mwana fasi mnumba.’ ");
INSERT INTO poy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Su mtuwa kamgambiriti ntumintumi, ‘Gugendi munjira na muvipenyu, guwagambiri wantu mpaka wizi, su numba yangu hayimemi. ");
INSERT INTO poy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nukugambira nakaka kwahera muntu ata yumu pakati pa walii yawawashemeriti hakalambiti ata tyee shiboga shaneni!’ ” ");
INSERT INTO poy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Palii lipinga likulu paliweriti lyankugenda pamuwera na Yesu, yomberi kagalambuka na kuwagambira, ");
INSERT INTO poy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Woseri yawiza kwa neni uganu wawafira tati na mawu wawu, wadala na wana, walongu na wadada wawu, ama womberi, hapeni waweri wafundwa waneni. ");
INSERT INTO poy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Woseri yawatola ndiri lupingika lwawu weni na kunfata hapeni waweri wafundwa wangu.” ");
INSERT INTO poy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Handa yumu pakati pa mwenga yakafira kunyawa mnara, kwanja kalivaga huti pasi na kulihola galama zakuwi, pakalola handa kana mpiya zitosha za kumalira lihengu. ");
INSERT INTO poy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Handa gwahera mpiya, pagunyawiti liyanjiru hapeni guwezi kumalira kunyawa mnara, na woseri pawalola galii gagalawiriti hawakuseki. ");
INSERT INTO poy_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Womberi hawalongi, ‘Muntu ayu yakanjiti kunyawa mnara kasinda kumalira lihengu!’ ");
INSERT INTO poy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Mfalumi yakawera na wantu elufu lilongu limu pakagenda kumkoma mfalumi yumonga yakawera na wantu elufu malongu mawili, mpaka huti yomberi kalivagi kulihola handa kana makakala ga kuukoma ufalumi umonga. ");
INSERT INTO poy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Handa pakahera makakala, hakawatumi wajumbi waliwoni na mfalumi yumonga, kumkosiya mashaliti ga ponga uganu yomberi kankali ka kutali.” ");
INSERT INTO poy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesu kamaliriti kwa kutakula, “Ntambu ira ayi kwahera ata yumu pakati penu hakaweri mfundwa wangu mpaka huti guleki kila shintu shakaweriti nashi. ");
INSERT INTO poy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Munu guherepa, kumbiti munu pagukola ndiri kwahera njira ya kugutenda gukoli kayi. ");
INSERT INTO poy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Su gufaa ndiri ata pawitira mulitapaka ama kuwera mbotu, hawagwasi kutali. Yakana makutu kapikaniri!” ");
INSERT INTO poy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lishaka limu watoza kodi wavua pamuwera na wanavidoda wiziti kumpikinira Yesu, ");
INSERT INTO poy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Wamafalisayu na wafunda wa Malagaliru wanjiti kung'ong'a, mumoyu mwawu, walonga, “Muntu ayu kuwashemera wanavidoda na ata kuliya pamuwera na womberi!” ");
INSERT INTO poy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Su Yesu kawagambira mfanu agu, ");
INSERT INTO poy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Yumu pakati penu pakawera na wakondolu miya na pagwerewa yumu kagamila, hagutendi ashi? Haguwaleki walii wakondolu malongu tisa na tisa kuntundu na kugenda kumsakula kondolu ulii yakagamiliti mpaka gumwoni. ");
INSERT INTO poy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pagumwona hagunemeleli nentu na hagumpapi mumakombi mwaku ");
INSERT INTO poy_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na kuuya nayu ukaya. Shakapanu pagusoka ukaya, haguwashemi waganja waku na wapakwegera pamuwera na kuwagambira, ‘Nana shereku shereku nentu toziya numwona kondolu gwangu yakagamiliti. Su tunemeleli pamuwera!’ ");
INSERT INTO poy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ndo ntambu ira ayi, nukugambirani haiweri nemeru nentu kumpindi kwa yakatenda vidoda yumu pakaleka vidoda vyakatenditi kuliku wantu malongu tisa na tisa yawamfiriziya Mlungu, ndoweni yawalihola wahera vidoda vyakuleka. ");
INSERT INTO poy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ama payiwera mdala yumu yakawera na magwala lilongu limu na ligwala limu paliyagamila, su hakatendi ashi? Hakawashi shikoloboyi, hakafyagili numba yakuwi na kusakula weri kila pahala mpaka kaliwoni. ");
INSERT INTO poy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Handa pakayiwona kala, ndo hakawashemi waganja wakuwi na wapakwegera pamuwera na kuwagambira, ‘Nana nemeli nentu toziya mona mpiya yaiyagamiliti. Su tunemeleli pamuwera!’ ");
INSERT INTO poy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nankuwagambira nakaka ndo hera hangu, wantumintumi wa kumpindi kwa Mlungu hawanemeleri toziya ya muntu yumu yakatenda vidoda pakaleka vidoda vyakatenditi.” ");
INSERT INTO poy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu kendereyiti kulonga, “Kwanaga muntu yumu yakaweriti na wana wawili wapalu. ");
INSERT INTO poy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Muhasha kamgambiriti tati gwakuwi, ‘Tati gunupi vinu uhala wangu.’ Su muntu ulii kawagawira sawa wana wakuwi awili. ");
INSERT INTO poy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Gapita ndiri mashaka gavuwa muhasha ulii kawuza uhala wakuwi woseri, shakapanu kawuka ukaya kagenda zakuwi na mpiya zakapatiti. Kagenditi isi ya kutali kweni aku su katumiyiti mpiya zilii vuluvulu. ");
INSERT INTO poy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kamaliriti kila shintu shakaweriti nashi. Su ilawira njala na kueneya muisi yoseri, na yomberi kaweriti kahera shintu. ");
INSERT INTO poy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Su kagenditi kutenda lihengu kwa muntu yumu gwa isi ilii, mweni kamtuliti mulirambu lyakuwi kuwalolera wamtumbi. ");
INSERT INTO poy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kafiriti kuliya viboga vyawalekiti wamtumbi, toziya kwahera muntu yakamupiti shintu shakuliya. ");
INSERT INTO poy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Upeleru kanjiti kulihola mumoyu na kutakula, ‘Wantumintumi wa tati gwangu waliya viboga mpaka waleka, pahala panu neni nankufuwa njala! ");
INSERT INTO poy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Hambuyi kwa tati gwangu na kulonga, Tati, ntenda vitendu vifaa ndiri kwa Mlungu na kwaku viraa. ");
INSERT INTO poy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Neni nfaa ndiri kushemwa mwana gwaku, guntendi neni gambira yumu gwa wantumintumi waku.’ ");
INSERT INTO poy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Su kanjiti mwanja kuwuya ukaya kwa tati gwakuwi.” “Pakaweriti kankali kakutali kulawa ukaya, kumbiti tati gwakuwi kamwoniti kala, su moyu gwakuwi gumwoniliti lusungu, su kumtugira na kamkisikira mwana gwakuwi na kumnonera. ");
INSERT INTO poy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwana ulii kamgambira tati gwakuwi, ‘Tati, neni numkosera Mlungu na gwenga viraa. Nfaa ndiri kunshema namwana gwaku.’ ");
INSERT INTO poy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kumbiti tati gwakuwi kawashemiti wantumintumi wakuwi na kawagambira, ‘Kanongola! Mtoli nguwu ziherepa nentu mumvalisiyi na pete mvalisiyi mushyala na mumvalisiyi vilwatu mumagulu. ");
INSERT INTO poy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Shakapanu mgendi mkamlikatuli ndama kaherepa tuliyi, na tunemeleli mumsambu! ");
INSERT INTO poy_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Toziya mwana gwangu kahowiti, kumbiti vinu kazyuka, kaweriti kagamila, kumbiti leru kawoneka.’ Su wanjiti kuvina msambu. ");
INSERT INTO poy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Shipindi shilii mkulu gwakuwi kaweriti kankali keniwuyi kulirambu. Pakaweriti munjira pakwegera na ukaya kwakuwi kankuwuya, kapikaniriti zilaa shereku na ng'oma. ");
INSERT INTO poy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Su kamshemiti yumu gwa wantumitumi na kamkosiya, ‘Kwana shishi pakaya panu?’ ");
INSERT INTO poy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ntumintumi ulii kamwankula, ‘Mlongu gwaku kawuya pakaya panu, su tati gwaku kamshinjira lindama likulukulu, toziya kamwona kankali mkomu.’ ");
INSERT INTO poy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Su muntemba mkulu ulii kakalariti nentu, kalemiti kwingira mnumba, su tati gwakuwi kalawiti kunja na kamgambira kingiri. ");
INSERT INTO poy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kumbiti yomberi kamwankula tati gwakuwi, ‘Guloli, mivinja yoseri ayi nukutendera lihengu gambira ntumintumi, na ng'enda ndiri shinyumi na lilagaliru lyaku. Gunupa shishi neni? Pota na kunupa mbuzi ntendi msambu pamuwera na waganja wangu! ");
INSERT INTO poy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kumbiti leru kiza mwana gwaku ayu yakatumiyiti ulunda waku woseri pamuwera na wandiyandiya, na pakawuyiti pakaya panu, gwenga gumshinjira ula ndama likulukulu!’ ");
INSERT INTO poy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tati gwakuwi kamwankula, ‘Mwana gwangu, gwenga gulikala pahala panu na neni mashaka goseri, vinu vintu vyoseri vyanwera navyi ndo vya gwenga. ");
INSERT INTO poy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kumbiti tufiruwa tuvini msambu na kunemelera, toziya mlongu gwaku kahowiti, kumbiti vinu kazyuka, kaweriti kagamila, kumbiti vinu kawoneka.’ ” ");
INSERT INTO poy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu kawagambiriti wafundwa wakuwi, “Kwanaga na mlundamali ayu yakaweriti na mfundwa yakalolera ulunda wakuwi. Mlunda mali ulii wamgambiriti kuwera yakalolera ulunda wakuwi kaweriti kankuyananga mpiya. ");
INSERT INTO poy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Su mlundamali ulii kamshema na kumgambira, ‘Avi ndo vitwatira gaa vyampikinira kwaku, gung'ambiri ntambu yagutumiyiti mpiya zyangu, toziya hapeni guweri mlolera ulunda gwangu kayi.’ ");
INSERT INTO poy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mlolera ulunda kaligambira mweni, ‘Mtuwa gwangu hakanwingi mlihengu lyangu. Hantendi ashi? Neni nahera makakala ga kulima, viraa nana soni kuluwaluwa. ");
INSERT INTO poy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Vinu nuvimana hantendi ashi! Su pakanwinga lihengu, hanweri na waganja weni hawanshemeli ukaya kwawu.’ ");
INSERT INTO poy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Su kawashemiti wantu woseri weni mtuwa gwakuwi kaweriti kankuwadayi. Kamkosiyiti gwa kwanja, ‘Gwenga mtuwa gwangu kakushonga mpiya ninga?’ ");
INSERT INTO poy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yomberi kamwankula, ‘Mapipa miya ga lipaki lya zeyituni.’ Mlolera ulunda kamgambira, ‘Aga ndo mawalangu gaku, gulivagi pasi, gulembi lilongu mhanu.’ ");
INSERT INTO poy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Shakapanu kamkosiya kayi yumonga, ‘Na gwenga wakushonga mpiya ninga?’ Yomberi kamwankula, ‘Mihaku elufu ya nganu.’ Mlolera ulunda kamgambira, ‘Aga ndo mawalangu gaku, gulembi miya nane.’ ");
INSERT INTO poy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Su mtuwa ulii kamzyumiti nentu mlolera ulunda yakaweriti kana pyera katumiyiti luhala, toziya wantu wa pasipanu wana luhala ng'anji muvitwatira vyawu kuliku wantu wa muweru.” ");
INSERT INTO poy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu kendereyiti kulonga, “Su nukugambirani mwenga, Mtendi uganja kwa kutumiya vintu vya pasipanu, su paviwapelerani hawawashemeri mnumba ya mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Muntu yoseri pakajimira mushintu shididini, hakaweri mjimira muvintu vikulu viraa, na muntu pakajimira ndiri mushintu shididini hapeni kajimiri mushintu shikulu. ");
INSERT INTO poy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Handa mwenga pamujimirika ndiri kwa vintu vya pasipanu, ndo gaa hakawapanani vintu viwagira vya nakaka? ");
INSERT INTO poy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na handa mwenga pamuwera waminika ndiri kwa vintu vya wantu wamonga, ndo gaa hakakupani vintu vyenu maweni? ");
INSERT INTO poy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kwahera ntumintumi yakaweza kuwatendera lihengu watuwa wawili, toziya Ntumintumi hakamlemi ayu na kumfira yumonga, ama hakaweri na yumu na kumleka yumonga. Hapeni mwezi kumtendera Mlungu na shipindi shila shilii guyitendera mpiya.” ");
INSERT INTO poy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mafalisayu pawapikaniriti goseri aga, wamkaliriti Yesu toziya womberi wafiraga mpiya. ");
INSERT INTO poy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu kawagambira, “Mwenga mlilanguziya waheri kulongolu kwa wantu, kumbiti Mlungu kayimana myoyu yenu. Kwa shintu shilii shashiwoneka shana mana nkulu kulongolu kwa wantu, Mlungu kashiwona kuwera shinyankalika. ");
INSERT INTO poy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Lilagaliru lya Musa na malembu ga wambuyi wa Mlungu gaweriti mpaka shipindi sha Yohani Mbatiza, kwanjira palii Visoweru viwagila vya Ufalumi wa Mlungu wankubwerwa, su kila muntu kankwingira kwa makakala. ");
INSERT INTO poy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kumbiti ndo ikamala ndiri kumpindi na pasi panu kwagamira kuliku lilembu lididini lya Lilagaliru kuliwusiya. ");
INSERT INTO poy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Muntu yoseri pakamleka mdala gwakuwi na kuyuga mdala gwingi katenda uhumba, na muntu pakamuyuga mdala yawamlekiti viraa katenda uhumba. ");
INSERT INTO poy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Paweriti na muntu yumu yakaweriti mlundamali, yakavaliti nguwu zya beyi nkulu nentu na kaweriti kankubojola mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Vilaa vilii kuweriti muntu muhushu yawamshema Lazaru, yakaweriti na vironda nshimba yoseri, mweni kalikaliti pamlyagu gwa mlundamali. ");
INSERT INTO poy_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Pakafira kuliya masigalu ga viboga vyavitulukiriti pasi pameza pa mlundamali. Ata wang'ang'a wiziti na kulambita vironda vyakuwi! ");
INSERT INTO poy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Muhushu pakahowiti kala, wantumintumi wa kupindi wamtoliti na kumtula pakwegera na Aburahamu mumsambu kulaa kumpindi. Na mlundamali kahowiti viraa na wamsira, ");
INSERT INTO poy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","na kagenda pahala yapaweriti kwana ntabiku nentu mulirindi lyalihera upeleru, na pakaloliti kamwoniti Aburahamu kwa kutali pamuhera na Lazaru kapakwegera. ");
INSERT INTO poy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Su kanjiti kushema, ‘Tati Aburahamu! Nyagu gumoneri lusungu bamu. Gumtumi Lazaru kajobi shala shakuwi mumashi, kizi kaluzizimisiyi lulimi lwangu, toziya nulikala mundabiku nentu mumotu amu!’ ");
INSERT INTO poy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Kumbiti Aburahamu kamgambira, ‘Guliholi mwana gwangu paguweriti gwamkomu gupatiti vintu vyoseri viherepa, kumbiti Lazaru kapatiti vintu vidoda vyoseri. Kumbiti vinu kankunemelera panu, na gwenga gwankutabika. ");
INSERT INTO poy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pamuwera na goseri aga, pakati petu panu kwana lirindi likulu nentu, su kwa woseri yawafira kwiza kwa twenga hapeni wawezi, ama kwahera muntu yakaweza kulawa kwenu kwiza uganu ama kwa twenga kwiza kwa mwenga.’ ");
INSERT INTO poy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mlundamali kalonga, ‘Nyagu nukuluwa tati Aburahamu, gumtumi Lazaru kagendi ukaya kwa tati gwangu, ");
INSERT INTO poy_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kwana walongu wangu wamuhanu. Kagendi kawaberiziyi nawiza uganu panu pahala pa ndabiku.’ ");
INSERT INTO poy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Aburahamu kamuwankula, ‘Kwa walongu waku kwana malembu ga Musa na malembu ga wambuyi wa Mlungu hagawaberiziyi, walongu waku wafiruwa wagapikaniri ntambu yagawagambira.’ ");
INSERT INTO poy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mlundamali kamwankula, ‘Tati Aburahamu, itosha ndiri! Kumbiti pakazyuka muntu kwawu kulawa kwa wahowiti na kuwagendera, hawampikiniri na kuleka vidoda vyawatenda.’ ");
INSERT INTO poy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kumbiti Aburahamu kamgambira, ‘Pawagapikanira ndiri malembu ga Musa na malembu ga wambuyi wa Mlungu, hapeni wajimili ata muntu pakazyuka.’ ” ");
INSERT INTO poy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu kawagambira wafundwa wakuwi, “Vintu vyavimtenda muntu katendi vidoda mpaka vilawili, kumbiti shondi kwa ulii yakavijega! ");
INSERT INTO poy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ayiweri mbaka kwa muntu yakavijega vikomu kumtawa musingu libuwi likulu lya kusagila na kumwasira mubahali, kuliku kumkalaziya yumu gwa wadidini awa watendi vidoda. ");
INSERT INTO poy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Muliloleli weri ntambu yamtenda! “Handa mlongu gwaku pakatenda vidoda, gumkalipiri na pakaleka gumlekizii. ");
INSERT INTO poy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Handa pakakukoseya mala saba kwa lishaka limu, na kila shipindi pakakuwuyira na kutakula, ‘Vyantenditi gunekiziyi,’ su gufiruwa gumlekizii.” ");
INSERT INTO poy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Wantumintumi wamgambiriti Mtuwa, “Gutongeleri njimiru.” ");
INSERT INTO poy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mtuwa kawankula, “Handa njimiru yenu payiwera nkulu gambira mbeyu ya ndidini nentu, hamuwezi kugugambira mtera gwa mkuyu, ‘Gutupuki gukaliyoshikeri mubahali!’ Ndo meguwajimili. ");
INSERT INTO poy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Yumu pakati penu pakawera na ntumintumi yakalima lirambu ama kankulolera wakondolu. Pakawuya kulawa kulirambu, hakamgambiri ntumintumi ulii kamkamu, gwizi gulii shiboga? ");
INSERT INTO poy_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ndala! Hakamgambiri, ‘Gunyawili huti shiboga, shakapanu guvali na guweri kala kuntendera mpaka mmalili kuliya na kulanda, shakapanu gwenga hagulii.’ ");
INSERT INTO poy_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Hashi, hagulongi mayagashii kwa ntumintumi toziya katenda vyakamgambiriti? ");
INSERT INTO poy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ntambu iraa ayi kwa mwenga, pamtenda kala vyoseri vyawawagambiriti mtendi, mlongi, ‘Twenga twawantumintumi hera weni twahera mota, tutenda hera lihengu lyetu.’ ” ");
INSERT INTO poy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu pakaweriti mumwanja kugenda Yerusalemu, kapitiliti mumipaka mwa Samariya na Galilaya. ");
INSERT INTO poy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pakaweriti kankwingira pashijiji, kaliwoniti na wantu lilongu limu yawaweriti na ungumbula. Wagolokiti kwa kutali ");
INSERT INTO poy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","na wabotanga pawalonga, “Yesu! Mtuwa! Gutuwoneri lusungu!” ");
INSERT INTO poy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu kawawoniti na kawagambira, “Mgendi mwakaliwonisiyi kwa mkulu gwa ludewa.” Pawaweriti munjira wankugenda su wapungikiti. ");
INSERT INTO poy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yumu pakati pawu pakawoniti handa kapona, kawuyiti pakamkwisa Mlungu kwa liziwu likulu. ");
INSERT INTO poy_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kasuntama makukama pa magulu ga Yesu nakulonga mayagashii kwa Yesu. Muntu ulii kaweriti Msamariya. ");
INSERT INTO poy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu kalonga, “Kuweriti na wantu lilongu yawapungitwi, wakoshi walii wamonga tisa? ");
INSERT INTO poy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Iwera ashi muhenga ayu gweka yakuwi ndo kiza kumkwisa Mlungu?” ");
INSERT INTO poy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Na Yesu kamgambira, “Gugoloki na gugendi, njimiru yaku ikuponiziya.” ");
INSERT INTO poy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mafalisayu wamu wamkosiyiti Yesu, “Ufalumi wa Mlungu wankwiza ndi?” Yomberi kawankula, “Ufalumi wa Mlungu wankwiza ndiri ntambu ya kuwoneka. ");
INSERT INTO poy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kwahera muntu hakawezi kutakula, ‘Guloli’ wapalaa! Ama ‘Wa palii!’ Toziya Ufalumi wa Mlungu wamngati mwenu.” ");
INSERT INTO poy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Shakapanu kawagambira wafundwa wakuwi, “Shipindi hakizi pamfira kulilola lishaka limu mumashaka ga Mwana gwa Muntu, kumbiti hapeni muliwoni. ");
INSERT INTO poy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wantu woseri hawakugambirani, ‘Mloli, ka palii!’ Ama, ‘Mloli ka panu!’ Kumbiti mwenga namlawa pota namuwafata, ");
INSERT INTO poy_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","toziya Mwana gwa Adamu mumashaka gakuwi, hakaweri gambira lumeta lwa lupanda ntambu yalulangala kulyera kwanjira uwega umu mpaka uwega umonga. ");
INSERT INTO poy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kumbiti kwanja kafiruwa katabiki muvitwatira vivuwa na kulemwa na wantu wa shiyiwuku ashi. ");
INSERT INTO poy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ntambu yayiweriti mumashaka ga Nuhu, ndo hayiweri mumashaka ga Mwana gwa Muntu. ");
INSERT INTO poy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Wantu wendereyiti kuliya na kulanda, na wapalu hawayugi na wadala kuyugwa mpaka shipindi shilii Nuhu pakayingiliti musafina. Mafuliku galawiti na kuwalaga woseri. ");
INSERT INTO poy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Hayiweri gambira shipindi sha Lutu. Wantu wendereyiti kuliya na kulanda, kuhemera na kuuza, kuyala na kunyawa. ");
INSERT INTO poy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lishaka lilii Lutu pakawukiti Sodoma, motu na mabuhi ga motu gatowiti gambira mvula kulawa kumpindi na kuwalaga woseri. ");
INSERT INTO poy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ntambu ayi hayiweri mulijuwa lilii Mwana gwa Muntu pakawoneka.” ");
INSERT INTO poy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Lijuwa lilii muntu yakawera pampindi pashitwiku pa numba yakuwi nakasuluka pasi kutola ulunda wakuwi, Ntambu iraa ayi muntu yoseri pakawera kuisi na kawuya ukaya. ");
INSERT INTO poy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mmuholi mdala gwa Lutu! ");
INSERT INTO poy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yoseri yakafira kugaponiziya makaliru gakuwi, hakagamiziyi na yoseri yakagamiziya makaliru gakuwi hakagalopoziyi. ");
INSERT INTO poy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nukugambirani, pashiru palii wantu wawili hawaweri wankugonja mushitanda shimuwera, yumu hawamtoli na yumonga hawamleki. ");
INSERT INTO poy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wadala wawili hawaweri wankusaga usaka pamuwera, yumu hawamtoli na yumonga hawamleki.” ");
INSERT INTO poy_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wantu wawili hawaweri wankutenda lihengu mulirambu, yumu hawamtoli na yumonga hawamleki ");
INSERT INTO poy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","wantumini wamkosiyiti Yesu, “Koshi Mtuwa?” Yesu kawankula, “Papawera na lintumbi, kunguru ndo hawaliwoni pamuwera.” ");
INSERT INTO poy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu kawagambiliti wantumintumi wakuwi mfanu, kawafunda wafiruwa kuluwa Mlungu mashaka goseri pota na koya. ");
INSERT INTO poy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yesu kalonga, “Mlushi lumu kuweriti na mtoza yakamtira ndiri Mlungu, ama kumjali muntu. ");
INSERT INTO poy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na kuweriti na mkenja mulushi lulii yakamgenderiti hakimu pakaluwa haki yakuwi pakatakula, ‘Guntangi mpati shanfuruwa kupata kulawa kwa mngondu gwangu.’ ");
INSERT INTO poy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa shipindi shivuwa hakimu kafiriti ndiri kumtanga, kumbiti upeleru wakuwi kaligambira mweni, ‘Tembera neni namtira ndiri Mlungu pota kulishera wantu, ");
INSERT INTO poy_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","toziya mkenja ayu kangaziyaga nentu, hanumwamuliri shauri lyakuwi. Pantenda ndiri hakendereyi kwiza panu na upeleru hakang'aziyi nentu!’ ” ");
INSERT INTO poy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mtuwa kendereyiti kutakula, “Mpikaniri ntambu yakatakuliti mtoza ayu mdoda. ");
INSERT INTO poy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Vinu, hashi Mlungu hapeni kawamuliri wantu wakuwi yawamlilira pashiru na paliwala? Hashi, hakakawi kuwatanga? ");
INSERT INTO poy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nukugambirani, hakawamuliri kanongola. Kumbiti Mwana gwa Muntu pakiza hakuweri na njimiru pasipanu?” ");
INSERT INTO poy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu kawagambiriti viraa mfanu gwagufata gwa walii yawalilola kuwera waherepa na kuwazarawu wantu wamonga. ");
INSERT INTO poy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kalonga, “Kuweriti na wantu wawili wakweniti kugenda Kunumba nkulu ya Mlungu kuluwa. Yumu kaweriti Mfalisayu na yumonga mtola kodi.” ");
INSERT INTO poy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mfalisayu kagolokiti gweka yakuwi na kuluwa shimoyumoyu pakalonga, “ ‘Mlungu mayagashii, neni nanalwaliya ndiri, nampayu ndiri ama mndiyandiya gambira wantu wamonga. Nonga mayagashii kwaku toziya neni nulifana ndiri gambira mtola kodi ayu. ");
INSERT INTO poy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nfunga mala mbili mulijuma, ndaviya fungu lilongu lya vintu vyampatiti.’ ” ");
INSERT INTO poy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kumbiti mtola kodi kagolokiti kwa kutali, kanyasula ndiri sheni shakuwi kumpindi, su kahinginika mumoyu mwakuwi pakalonga, “Mlungu, gumoneri lusungu neni yantenda vidoda!” ");
INSERT INTO poy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu kalonga, “Nukugambirani, mtola kodi kawuyiti ukaya pawamlekeziyiti vidoda vyakatenditi, kumbiti Mfarisayu ulii wamlekeziyiti ndiri vidoda vyakatenda. Toziya woseri yawafira kulikweniziya hawawasulusiyi, na woseri yawalisulusiya weni hawawakweniziyi.” ");
INSERT INTO poy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wantu wamu wamjegiriti Yesu wana wadidini su kawatulili mawoku gakuwi. Wafundwa pawawoniti, wawalewelera ntambu yawatenda, ");
INSERT INTO poy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","kumbiti Yesu kawashema wana wizi kwakuwi pakalonga, “Muwaleki wana wadidini wizi kwaneni, namuwalewelera toziya Ufalumi wa Mlungu ndo wa wantu gambira awa. ");
INSERT INTO poy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nukugambirani nakaka! Muntu yoseri yakanka ndiri Ufalumi wa Mlungu gambira mwana mdidini hapeni kingiri amu.” ");
INSERT INTO poy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mkulu gwa Wayawudi kamkosiyiti Yesu, “mfunda muheri, ntendi shishi nwezi kupata ukomu wa mashaka goseri?” ");
INSERT INTO poy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu kamkosiya, “Iwera ashi gunshema muheri? Kwahera muntu yakawera muheri kumbiti Mlungu gweka yakuwi. ");
INSERT INTO poy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gugamana malagaliru, ‘Naguwera muhumba, nagulaga, nagwiwa, nagumtakulila mpayu muntu yoseri, guwapanani ligoya tati na mawu gwaku.’ ” ");
INSERT INTO poy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yomberi kawankula, “Kwanjira panweriti mdidini, nugajimira malagaliru goseri aga.” ");
INSERT INTO poy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu pakapikaniriti aga kamgambira, “Guleka shintu shimu shagufiruwa kutenda. Guwuzi kila shintu shaguwera nashu na guwagawiri wahushu mpiya azi, na gwenga haguweri mlundamali kumpindi, su gwizi na gunfati.” ");
INSERT INTO poy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kumbiti muntu ulii pakapikaniriti aga, kahinginikiti nentu toziya kaweriti mlunda nentu. ");
INSERT INTO poy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu kawoniti ntambu yakahinginikiti na katakula, “Ntambu ayi hayiweri vikamala kwa wantu walunda kwingira mu Ufalumi wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Hayiweri ikamala kwa walunda mali kwingira mu Ufalumi wa Mlungu kuliku shigongolu shawamshema Ngamiya kupena mushitoboli sha sindanu.” ");
INSERT INTO poy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wantu walii pawapikaniriti aga wakosiya, “Su gaa hakalopoziwi?” ");
INSERT INTO poy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu kawankula, “Gawezekana ndiri kwa wantu, kumbiti kwa Mlungu gawezekana.” ");
INSERT INTO poy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peteru kamgambira, “Guloli! Twenga tuleka kaya zetu na kukufata gwenga.” ");
INSERT INTO poy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu kawagambira, “Yina! Nukugambirani nakaka muntu yoseri yakalekiti numba, ama mdala, ama walongu, ama mawu na watati wakuwi, ama wana toziya ya Ufalumi wa Mlungu ");
INSERT INTO poy_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hakawanki gavuwa nentu mushipindi ashi na mushipindi shashiza hakawanki ukomu wa mashaka goseri.” ");
INSERT INTO poy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu kawatoliti wantumintumi walii lilongu na wawili na kuwagambira, “Mpikaniri! Twankugenda Yerusalemu kulii kila shintu wambuyi wa Mlungu walembiti, kuusu Mwana gwa Muntu hagalawiri. ");
INSERT INTO poy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Hawamupanani kwa wantu yawaweriti ndiri Wayawudi, na womberi hawamtenderi lidufiya na hawamwigilangi na hawamtemeri mata. ");
INSERT INTO poy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hawamsyatangi ndomontu na hawamlagi, kumbiti lishaka lya tatu kwanjira pakahowiti hakazyuki.” ");
INSERT INTO poy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kumbiti wantumintumi wavimaniti ndiri vintu vyoseri avi, mana ya visoweru viweriti vififwa kwawomberi, na wavimaniti ndiri shakatakuliti Yesu. ");
INSERT INTO poy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu pakaweriti kapakwegera na Yeriku, kuweriti na muntu yakana lwisi yakalivagiti panjira pakaluwa. ");
INSERT INTO poy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pakapikaniriti lipinga lya wantu lyankupita kakosiya, “Kwana shishi?” ");
INSERT INTO poy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Womberi wamgambira, “Yesu gwa Nazareti kankupita.” ");
INSERT INTO poy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nayomberi kalila kwa liziwu likulu, “Yesu! Mwana gwa Dawudi! Gumoneri lusungu!” ");
INSERT INTO poy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wantu wawalongoleriti wamkalipira pawamgambira kanyamalili. Kumbiti yomberi kendereyiti kubotanga, “Mwana gwa Dawudi! Gumoneri lusungu!” ");
INSERT INTO poy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu kagolokiti, na kawagambira wamjegeri muntu kana lwisi ulii. Muntu kana lwisi pakasokiti pakwegela, Yesu kamkosiya, ");
INSERT INTO poy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Gufira nukutenderi shishi?” Nayomberi kawankula, “Mtuwa nduwa mpati kuwona kayi.” ");
INSERT INTO poy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu kamgambira, “Guwoni! Kwakunjimira kwaku, ndo gupona.” ");
INSERT INTO poy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Pala palii, kaweza kuwona, na kamgendera Yesu, kalonga mayagashii kwa Mlungu. Lipinga lya wantu pawawoniti hangu, wamkwisiti Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu kingiriti Yeriku, kaweriti kankupita munjira za lushi alu. ");
INSERT INTO poy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kuweriti na mkulu gwa watola kodi yawamshema Zakayu, mweni kaweriti mlundamali. ");
INSERT INTO poy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kafiriti kumwona Yesu kaweriti gwa ntambu gaa, kumbiti toziya ya lipinga lya wantu na toziya kaweriti mfupi, na kasinditi kumwona Yesu. ");
INSERT INTO poy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Su kalongolera mbiru, kakwena pampindi pa mkuyu su kawezi kumwona Yesu kaweriti kankupita njira ayi. ");
INSERT INTO poy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu pakaweriti kankwiza pahala palii, kaloliti kumtera na kumgambira Zakayu, “Kanongola gusuluki, toziya nfiruwa kulikala mnumba mwaku leru.” ");
INSERT INTO poy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakayu kasuluka kanongola, kumshemera kwa kunemelera. ");
INSERT INTO poy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wantu woseri pawawoniti hangu, wanjiti kuhinginika pawalonga, “Muntu ayu kagenda kuwera muhenga yakanaligoya ukaya kwa yakana vidoda!” ");
INSERT INTO poy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakayu kagoloka, kumgambira Mtuwa, “Gupikaniri, Mtuwa! Hanuwapanani wahushu nusu ya ulunda wangu, na handa panumupokiti muntu yoseri kwa kumupayira hanumuwuzilili mala msheshi.” ");
INSERT INTO poy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu kamgambira, “Ulopoziwu usoka mnumba amu leru, toziya muntu ayu vira ndo kamushiyiwuku sha Aburahamu. ");
INSERT INTO poy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mwana gwa Muntu kiziti kusakula na kuwalopoziya yawagamiliti.” ");
INSERT INTO poy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wantu pawaweriti wankupikanira aga, Yesu kendereyiti kuwagambira mfanu. Pakaweriti pakwegera kusoka Yerusalemu na wantu walii waliholiti kuwera Ufalumi wa Mlungu sambira usoka. ");
INSERT INTO poy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Su kawagambira, “Kuweriti na muntu yumu yakaweriti mkulu yakagenda muisi ya kutali kaweri mfalumi, shakapanu kawuyi ukaya. ");
INSERT INTO poy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pamberi pa kuwuka, kawashemiti wantumintumi wakuwi lilongu na kuwapanani mpiya kila yumu na kuwagambira, ‘Guloli ntambu yamuweza kutenda pambuka.’ ");
INSERT INTO poy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Vinu wantu wakuwi wamgalambukiti, pakawukiti kala, wawatumiti wajumbi walongi, ‘Tumfira ndiri muntu ayu kaweri mfalumi gwetu.’ ");
INSERT INTO poy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Muntu ulii pawamtyeka kala kuwera mfalumi kawuyiti ukaya. Palii kawashemiti wantumintumi wakuwi kafira kavimani ntambu ya kila muntu kapata mpiya zininga kuliku ntambu yakawayupiti. ");
INSERT INTO poy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ntumintumi gwa kwanja kiza na kulonga, ‘Mtuwa, mpata mpiya lilongu nentu ya mpiya yimu yagunupiti.’ ");
INSERT INTO poy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nayomberi kamgambira, ‘Gutenda weri, gwenga gwa ntumintumi guherepa! Toziya guwera gwa mwaminika kwa shintu shididini, hanukutuli guweri mkulu kwa lushi zya milongu.’ ");
INSERT INTO poy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ntumintumi gwa pili kiza na katakula, ‘Mtuwa, mpata mpiya zyamuhanu nentu ya mpiya yimu yagunupiti.’ ");
INSERT INTO poy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kwa yumu ayu kamgambira, ‘Haguweri mkulu gwa lushi zya muhanu.’ ");
INSERT INTO poy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ntumintumi gwingi kiza na kutakula, ‘Mtuwa, mpiya yaku ayi, ntawiti mushitambala. ");
INSERT INTO poy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nukutuliriti gwenga toziya gwenga gwa muntu gukalipa. Gwenga gutolaga shilii shaku ndiri na kubena shilii shaguyala ndiri.’ ");
INSERT INTO poy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nayomberi kamgambira, ‘Gwenga gwa ntumintumi gufaa ndiri! Nukutoza kulawirana na visoweru vyaku! Guvimana neni muntu nkalipa, ntola shilii shashiwera ndiri shaneni na mbenanga vilii vyanyala ndiri.’ ");
INSERT INTO poy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Su iwera hashi gutuliti ndiri mpiya zyangu muluhanja? Pambuyiti hampati mpiya yangu pamuhera na mota yakuwi.” ");
INSERT INTO poy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Shakapanu kawagambira woseri yawaweriti wagoloka palii, ‘Mmupoki mpiya ayi na mumupi ntumintumi ulii yakongeriti mpiya lilongu.’ ");
INSERT INTO poy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kumbiti womberi wamgambira, ‘Mtuwa, ayu kana mpiya kala mala lilongu!’ ");
INSERT INTO poy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nayomberi kawankula, ‘Nukugambirani woseri yawawera na shintu, hawongelerwi, kumbiti woseri yawahera na shintu, ata shilii shididini shawawera nashi hawawapoki. ");
INSERT INTO poy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Vinu woseri walii yawaweriti wangondu wangu yawanfira ndiri neni nweri mfalumi gwawu, muwajegi panu na kuwalaga palongolu pa masu gangu!’ ” ");
INSERT INTO poy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu pakatakuliti kala aga, su kawalonguleriti kugenda Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pakaweriti pakwegera kusoka Betifagi na Betaniya, mulugongu lwa Mizeyituni, kawatumiti wafundwa wawili ");
INSERT INTO poy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kawagambira, “Mgendi mushijiji sha palongolu penu, pamwingira hamwoni punda wamtawa mweni hakenitumiki na muntu. Mumyopoli na mumjegi panu. ");
INSERT INTO poy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Muntu yoseri pakawakosiya, iwera hashi mwankumyopola, mumgambiri Mtuwa kamfira.” ");
INSERT INTO poy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wagenditi munjira yawu, wawona kila shintu Yesu ntambu yakawagambiriti. ");
INSERT INTO poy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pawaweriti wankumyopola punda ulii, weni yawawera na punda wawakosiya, “Iwera hashi mwankumyopola punda ayu?” ");
INSERT INTO poy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nawomberi wamwankula, “Mtuwa kamfira,” ");
INSERT INTO poy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","su wamjega punda ulii kwa Yesu. Shakapanu wamyalikira nguwu zyawu pampindi pa punda na wamtanga Yesu kumkweniziya pampindi pakuwi. ");
INSERT INTO poy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu kendereya na mwanja, na wantu wayalika nguwu zyawu munjira. ");
INSERT INTO poy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pakasokiti pakwegera na Yerusalemu, panjira panda ya lugongu lwa Mizeyituni, lipinga likulu lya wafundwa wanjiti kutenda lusheka na nemeleru walonga mayagashii Mlungu na kumkwisa yomberi kwa liziwu likulu pawatakula mauzauza makulu wagawoniti, ");
INSERT INTO poy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Mlungu gumtekeleri mfalumi yakiza mulitawu lya Mtuwa! Ponga iweri kumpindi nentu kwa Mlungu na ukwisa uweri kwa Mlungu!” ");
INSERT INTO poy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Shakapanu Wamafalisayu wamu mulipinga lilii lya wantu wamgambira Yesu, “mfunda, guwanyamaziyi wafundwa waku.” ");
INSERT INTO poy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu kawankula, “Nukugambirani, handa pawanyamalila, mabuhi aga haganji kubotanga.” ");
INSERT INTO poy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pawasokiti pakwegera na lushi lwa Yerusalemu, na pakaluwona kanjiti kululilira, ");
INSERT INTO poy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","kalonga, “Meguvimani! Leru ayi vitwtatira vijega ponga. Kumbiti vinu galififa pamasu paku. ");
INSERT INTO poy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Shipindi shankwiza ndo sheni wangondu waku hawakuzyengeti kwa maboma, hawakupingili na kukubabanika wega zoseri. ");
INSERT INTO poy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Hawakwagamiziyi gwenga na wantu yawalikala mngati, hapeni wakulekeli ata libuwi limu panani pa limonga, toziya gushimana ndiri shipindi sha Mlungu pakakwiziriti kukulopoziya.” ");
INSERT INTO poy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Shakapanu Yesu kingiriti Mnumba nkulu ya Mlungu na kanja kuwawinga walii yawawuza vintu palii, ");
INSERT INTO poy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kawagambira, “Walembiti mumalembu, Mlungu pakalonga, ‘Numba nkulu ya neni hayiweri numba ya kusalira.’ Kumbiti mwenga muyitenda mpanga ya wapoka.” ");
INSERT INTO poy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kila lishaka Yesu kaweriti kankufunda Mnumba nkulu ya Mlungu. Watambika wakulu na wafunda wa Malagaliru, na wakulu wa wantu wafiriti kumlaga, ");
INSERT INTO poy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kumbiti wasinditi ntambu yakutenda aga, toziya wantu woseri waweriti wankumpikinira weri kila shisoweru shakatakuliti, na wafiriti ndiri kukosa shisoweru ata shimu. ");
INSERT INTO poy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lishaka limu Yesu kaweriti kankuwafunda wantu Mnumba nkulu ya Mlungu na kuvibwera visoweru viwagira, watambika wakulu na wafunda wa Malagaliru, pamuhera na wazewi, wiziti ");
INSERT INTO poy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","na wamgambira, “Gutugambiri, gutenda vintu vyoseri avi kwa uwezu wa gaa? Ndo gaa yakakupiti uwezu wa kutenda aga?” ");
INSERT INTO poy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu kawankula, “Vinu naneni hanuwakosiyi. Mung'ambiri, ");
INSERT INTO poy_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","uwezu wa kubatiza wa Yohani Mbatiza ulawiti kumpindi ama ulawiti kwa wantu?” ");
INSERT INTO poy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Womberi wanjiti kuligambirana weni, “Hatulongi hashi? Patulonga, ‘Ulawiti kumpindi,’ yomberi hakatakuli, ‘Iwera hashi munjimira ndiri?’ ");
INSERT INTO poy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kumbiti patulonga, ‘Ulawa kwa wantu,’ lipinga lyoseri lya wantu panu hawatugumi mabuhi, toziya woseri wavimaniti kuwera Yohani kaweriti mbuyi gwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Su wamwankula, “Tuvimana ndiri uwezu wakuwi ulawiti koshi.” ");
INSERT INTO poy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu kawagambira, “Vira neni hapeni nuwagambirani ntenda vitwatira avi kwa uwezu wa gaa.” ");
INSERT INTO poy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu kawagambiriti wantu mfanu agu, “Kweniti na muntu yakayaliti mizyabibu mulirambu, kawazimila wakulima na mweni kagenditi mwanja, kalikaliti kulii shipindi shivuwa. ");
INSERT INTO poy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Shipindi sha kubenanga zyabibu shisokiti, kamtumiti mmanda kagendi kwa wakulima, kakatoli seemu ya mabenangu ga lirambu lya mizyabibu. Kumbiti wakulima wamkomanga ntumintumi ulii na wamuwuziya ukaya mawoku hera. ");
INSERT INTO poy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Su kamtumiti ntumintumi gwingi, kumbiti wakulima walii wamkoma kayi na kumtendera vidoda, na wamwuziya ukaya mawoku hera. ");
INSERT INTO poy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kamtumiti ntumintumi gwa tatu, wakulima wamkoma mpaka kawera na vironda, shakapanu wamuwingawinga. ");
INSERT INTO poy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mweni kana lirambu kalikosiya, ‘Hantendi hashi? Hanumtumi mwana gwangu yanumfira, neni wera na unakaka hawamupanani ligoya!’ ");
INSERT INTO poy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kumbiti wakulima walii pawamwoniti, wanja kuligambira, ‘Ayu ndo mhala gwakuwi. Tumlagi, uhala wakuwi hawuweri wa twenga!’ ");
INSERT INTO poy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Su wamlaviya kunja kulirambu, wamlaga.” Yesu kawakosiya, “Yakana lirambu ulii hakawatendi hashi wakulima walii? ");
INSERT INTO poy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Hakizi kuwalaga wakulima woseri, na hakawapanani wakulima wamonga lirambu lilii lya mizyabibu.” Wantu pawapikaniriti, watakula, “Iwezekana ndiri!” ");
INSERT INTO poy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu kawaloliti na kukosiya, “Su Malembu aga Mananagala gana mana gaa? ‘Libuwi lyawalilemiti wanyawa wa numba, vinu ligalambuka na liwera libuwi lyaliwera na mana nentu kuliku goseri.’ ");
INSERT INTO poy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Muntu yoseri pakaguwa pampindi pa libuwi hakamegeki vipandi vipandi, na libuwi palimtulukira muntu yoseri, halimtendi.” ");
INSERT INTO poy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wafunda wa Malagaliru na watambika wakulu wafiriti kumbata, toziya wavimaniti mfanu agu guweriti kankuwatakula womberi, kumbiti palii wawatiriti wantu. ");
INSERT INTO poy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Su waweriti wankusakula shipindi shifaa. Wawapanani wantu wamu mpiya walitendi waheri, su wawatuma wagendi kumjera Yesu kwa kumkosiya, su wawezi kumbata na kumjega kwa wakulu wa serikali ya Rumi. ");
INSERT INTO poy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Walolalo walii wamgambira Yesu, “mfunda, tuvimana ntambu yagutakula na kufunda vitwatira vya nakaka. Tuvimana gwenga gwahera ubagula kwa muntu yoseri ulii, kumbiti gwenga gufunda unakaka wa vintu vyakafira Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gutugambiri, handa vya halali ama vyahalali ndiri kulipa kodi kwa Kaisari!” ");
INSERT INTO poy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kumbiti Yesu kavimaniti shawafira na kawagambira, ");
INSERT INTO poy_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mnanguziyi mpiya. Sheni sha mumpiya sha gaa na malembu yagalembwa mumpiya?” Wamwankula, “vya Kaisari.” ");
INSERT INTO poy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Su Yesu kawagambira, “Su vya Kaisari mpanani Kaisari na vya Mlungu mpanani Mlungu.” ");
INSERT INTO poy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Waweza ndiri kumbata kwa shisoweru shoseri palii palongolu pa wantu, su wanyamaliti, pawalikangasha ntambu yakawankuliti. ");
INSERT INTO poy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Shakapanu Masadukayu wamu, yawalongaga wantu yawahowa hapeni wazyuki, wamwiziriti Yesu na kulonga, ");
INSERT INTO poy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“mfunda, Musa katulembiriti Lilagaliru ali, ‘Muntu pakahowa na kumleka mdala yakahera mwana, mpaka mlongu gwakuwi kamtoli mkenja ulii su kamleleri wana mlongu gwakuwi yakahowiti.’ ");
INSERT INTO poy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Vinu kuweriti na walongu saba. Mkulu yakalongoleriti kumyuga kahowa pakaleka ndiri mwana. ");
INSERT INTO poy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mlongu gwa pili kamuyuga mdala mkenja ulii, ");
INSERT INTO poy_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","na mlongu gwa tatu ntambu ira, vitwatira viweriti vira virii kwa woseri saba, wahowiti pawaleka ndiri wana. ");
INSERT INTO poy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Upeleru wakuwi na mdala mkenja ulii kahowiti vira. ");
INSERT INTO poy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Vinu mulishaka lya wahowiti kuzyuka, mdala ulii hakaweri gwa gaa? Toziya woseri saba wamuyugiti.” ");
INSERT INTO poy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu kawankula, “Mushipindi ashi wapalu wayuga wadala, ");
INSERT INTO poy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kumbiti wapalu na wadala weni Mlungu hakawatangi kuwera mushipindi sha kuzyuka, hapeni wapalu wayugi wala wadala kuyugwa. ");
INSERT INTO poy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Hawaweri gambira wantumintumi wa kumpindi na hapeni wahowi. Womberi ndo wana wa Mlungu, toziya wazyuka kulawa kwa wahowiti. ");
INSERT INTO poy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kumbiti Musa kalanguziyiti weri kuwera yawahowiti hawazyuki. Mumalembu Mananagala galembitwi shakatakuliti Mtuwa ndo Mlungu gwa Aburahamu, na Mlungu gwa Isaka, na Mlungu gwa Yakobu. ");
INSERT INTO poy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mlungu ndo gwa yawawera wakomu, na Mlungu ndiri gwa wahowiti, kwakuwi woseri walikala.” ");
INSERT INTO poy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wafunda wamu wa Malagaliru watakula, “mfunda guwankula weri!” ");
INSERT INTO poy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Watakuliti hangu toziya wasinditi kumkosiya kayi makosiwu gamonga. ");
INSERT INTO poy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu kawakosiya, “Watakula hashi kulonga Kristu kawera mwana gwa Dawudi? ");
INSERT INTO poy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mweni Dawudi kalemba kala mushintola sha Zaburi, ‘Mtuwa kamgambiriti Mtuwa gwangu, Gwikali kumliwu kwaneni ");
INSERT INTO poy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Mpaka nuwatuli wangondu waku kuwera shiti sha kutulila magulu gaku.’ ");
INSERT INTO poy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawudi kamshemiti yomberi, ‘Mtuwa.’ Hayiweri hashi Mesiya kaweri mwana gwa Dawudi?” ");
INSERT INTO poy_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesu kawagambira wafundwa wakuwi kulongolu kwa wantu woseri, ");
INSERT INTO poy_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Muliloleri weri kuusu wafunda wa Malagaliru, weni wafira kugendagenda pawavalira lihabiti na wafira kulamsiwa kwa ligoya pahala pa masoku, weni wasyagula kulivaga pahala pa ligoya munumba zya Mlungu, na pahala paherepa mumsambu, ");
INSERT INTO poy_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wawagambira wakenja mpayu na kuwapoka numba zyawu na pawaluwa Mlungu luwi ntali! Azabu yawu hayiweri nkulu nentu!” ");
INSERT INTO poy_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu kalola wega zoseri, kawawona wantu walunda pawatula mafupu gawu mulisanduku lya luhanja Mnumba nkulu ya Mlungu, ");
INSERT INTO poy_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","vira virii kamwoniti mkenja muhushu nentu pakatula senti ndidika mbili zya mpiya. ");
INSERT INTO poy_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kawagambira, “Nukugambirani kuwera nakaka mkenja muhushu ayu kalaviya zivuwa kuliku woseri wamonga. ");
INSERT INTO poy_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Wamonga walaviyiti mafupu gawu galii gagaziditi muulunda wawu, kumbiti muhushu ayu kwa uhushu wakuwi kalaviya vyoseri vyakalitumbiriti.” ");
INSERT INTO poy_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wantumini wamu waweriti wankutakula kuusu Numba nkulu ya Mlungu, ntambu yawaherepeziya kwa mabuhi gaherepa na mafupu wagalaviyiti kwa Mlungu. Yesu kawagambira, ");
INSERT INTO poy_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Goseri aga gamgalola, shipindi shankwiza peni hapeni lisigali libuwi limu pahala pakuwi, kila shintu hashiharibiwi.” ");
INSERT INTO poy_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Womberi wamkosiyiti, “mfunda, visoweru avi havilawili ndii? Hashilawiri shishi kutulanguziya kuwera shipindi ashi shankwiza?” ");
INSERT INTO poy_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu kawankula, “Mliloli weri, nawawazyangani. Wantu wavuwa hawizi pawatakula shisoweru shangu, hawizi na kulonga, ‘Neni ndo mweni!’ Na ‘Shipindi hashizi!’ Kumbiti namuwafata. ");
INSERT INTO poy_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Namtira pampikanira ngondu na ndewu, vintu vyoseri avi mpaka vilawiri kwanja, kumbiti upeleru wa vitwatira avi wankali.” ");
INSERT INTO poy_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu kendereya kutakula, “Isi yimu hailikomangi na isi yimonga, na ufalumi umu haulikomi na ufalumi umonga. ");
INSERT INTO poy_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hakuweri na malendemeru makulu ga isi na hakuweri na njala na ulweri wa tawuni pahala poseri, hakuweri na vitwatira vya kutiliziya na lilangaliru likulu kulawa kuliyera. ");
INSERT INTO poy_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pamberi pagalawira goseri aga, hawawabati na kuwatabisiya na hawawajegeni munumba za Mlungu na kuwatula muvibetubetu, hawawajegeni kulongolu kwa wafalumi na wakulu toziya munamini neni. ");
INSERT INTO poy_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ayi hayiweri lupenyu lwenu kuvibwera visoweru viwagira. ");
INSERT INTO poy_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kumbiti muvimani mumyoyu mwenu, namlihola ntambu ya kujiteteya, ");
INSERT INTO poy_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","toziya Namweni neni hanuwapanani mwenga lulimi na luhala vyeni wangondu wenu woseri hapeni wawezi kusindana naga na kugalema gamtakula. ");
INSERT INTO poy_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hagugalambukwi na mawu na tati gwaku, na walongu waku, na waganja waku, na wamonga pakati penu hawawalagi. ");
INSERT INTO poy_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Wantu woseri hawawakalalirani mwenga toziya ya litawu lyaneni. ");
INSERT INTO poy_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kumbiti hapeni luagamili ata luvili lumu mumituwi mwenu. ");
INSERT INTO poy_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Muweri pamgangamala mumoyu, hamliponiziyi weni. ");
INSERT INTO poy_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pamwona Yerusalemu guzyengetwa na wangondu, su hamvimani kuwera shipindi shisoka peni isi ayi hayiharabisiwi. ");
INSERT INTO poy_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Woseri yawalikala Muyudeya watugili mulugongu, woseri yawawera mulushi wawuki, na woseri yawawera mumalambu nawawuya mulushi. ");
INSERT INTO poy_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Toziya mashaka aga hagaweri ‘Mashaka ga kutoza,’ kulanguziya koseri kwakulembitwi mumalembu Mananagala gatimii. ");
INSERT INTO poy_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Shondi shondi wamawu yawawera na yinda na walii yawanoniziya mumashaka galii! Toziya hakuweri na malweri gavuwa muisi, na utoza wa Mlungu hawuwayizili wantu awa. ");
INSERT INTO poy_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wamonga hawawalagi kwa upanga, na wamonga hawawatuli muvibetubetu muisi zoseri, na hawawatoli lopola mumaisi goseri na Yerusalemu hayitimbwi na wantu yawamumana ndiri Mlungu mpaka shipindi shawu pashimalilika. ");
INSERT INTO poy_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Hakuweri na lilangaliru mumshenji, na mulyezi, na muntondu. Pasipanu wantu woseri yawaweriti muisi zoseri hawaweri na uhushu, lyoga lya kulishera kwa mtukuliru gwa makupala ga bahari na mihenyuhenyu yakuwi. ");
INSERT INTO poy_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wantu pawafuwa myoyu kwa lyoga, pawalola vitwatira vyeni havilawili pasipanu, makakala ga kumpindi hagatikinyiki. ");
INSERT INTO poy_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Shipindi shilii Mwana gwa Muntu hakalawili, pakiza mumawingu pakawera na makakala pamuwera na ukwisa mkulu. ");
INSERT INTO poy_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Vintu avi pavyanja kulawira, mkalamuki na mnyasuli mituwi yenu kumpindi toziya ulopoziwu wenu wapakwegera.” ");
INSERT INTO poy_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu kawagambiriti mfanu agu, “Mguloli mtera gwa mkuyu na mitera yamonga yoseri. ");
INSERT INTO poy_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pamuwoniti mihamba yankwanja kumera, muvimana kuwera shipindi sha kutowa vula shapakwegera. ");
INSERT INTO poy_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ntambu ira ayi, pamwona vitwatira avi vyankulawira, muvimani handa Ufalumi wa Mlungu wapakwegera. ");
INSERT INTO poy_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Mliholi kuwera vintu vyoseri havilawili huti pamberi pa wantu woseri yawalikala vinu kuhowa. ");
INSERT INTO poy_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kumpindi na pasi panu hazipiti, kumbiti visoweru vyangu hapeni vipiti. ");
INSERT INTO poy_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mliloleri weri! Namuwera vyambojola bojola, na lukologelu na lyaliya, ama pamlilola weri ndiri lishaka lilii halikwizireni vumu hera, ");
INSERT INTO poy_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","gambira mgomiziwu. Toziya haguwayizili kwa wantu woseri yawalikala pahala poseri pasi panu. ");
INSERT INTO poy_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mwenga mulikali masu na mumluwi Mlungu mashaka goseri su mpati makakala ga kugenda weri muvitwatira vyoseri vyeni ndo havilawili na kugoloka kulongolu kwa Mwana gwa Muntu.” ");
INSERT INTO poy_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mashaka goseri paliwala, Yesu kaweriti kankufunda Mnumba nkulu ya Mlungu, na pamihi kaweriti kankugenda kulikala mulugongu lwa Mizeyituni. ");
INSERT INTO poy_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kila pamandawila wantu woseri wagenditi Kunumba nkulu ya Mlungu kumpikinira. ");
INSERT INTO poy_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Msambu gwa mabumunda gachechema ndiri, yagushemwa Pasaka guweri sambira gusoka. ");
INSERT INTO poy_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Watambika wakulu na wafunda wa Malagaliru waweriti wankusakula njira ya kumlaga Yesu kwa bada, toziya wawatiriti wantu. ");
INSERT INTO poy_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Shetani kamwingiriti Yuda, yawamshema Isikariyoti, yumu gwa wantumini walii lilongu na wawili. ");
INSERT INTO poy_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Su Yuda kagenditi na kuyowera na Watambika wakulu na walolera wa numba nkulu ya Mlungu ntambu ya kumgalambuka Yesu kwawomberi. ");
INSERT INTO poy_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Womberi weniti manemu na wayoweriti na yomberi wamlipi mpiya. ");
INSERT INTO poy_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda kajimiliti, na kaweriti kankusakula lupenyu luherepa lwa kumlaviya Yesu kwawomberi pota na lipinga lya wantu kuvimana. ");
INSERT INTO poy_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lishaka lisokiti lya msambu gwa mabumunda gachechema ndiri, wakondolu wa shiboga sha Pasaka pawawadumuliti. ");
INSERT INTO poy_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu kawatumiti Peteru na Yohani, kawagambira, “Mgendi mwakatunyawili shiboga sha Pasaka tupati kuliya.” ");
INSERT INTO poy_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Womberi wamkosiyiti, “Gufira twakanyawi koshi?” ");
INSERT INTO poy_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu kawankula, “Pamgenda mulushi, hamliwoni na mpalu yakalitwika shiwiga sha mashi. Mmufati mpaka mnumba pakayingira, ");
INSERT INTO poy_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mumgambiri mweni kana numba, ‘mfunda kankukosiya, shakoshi shumbakati mweni handiyi Pasaka pamuhera na wafundwa wangu?’ ");
INSERT INTO poy_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yomberi hakawalanguziyi numbakati nkulu mugorofa wayiherepeziya, munyawi amu.” ");
INSERT INTO poy_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wagenditi na woniti kila shintu sawa ntambu Yesu yakawagambiriti, wanyawa shiboga sha Pasaka. ");
INSERT INTO poy_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Shipindi pashisokiti, Yesu kalikaliti kuliya shiboga pamuhera na wantumintumi wakuwi. ");
INSERT INTO poy_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kawagambira, “Nfira nentu kuliya Pasaka ayi pamuhera na mwenga pamberi pa kundabisiya! ");
INSERT INTO poy_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nukugambirani ayi ndo Pasaka ya upeleru kuliya na mwenga mpaka palii payiwera kala mu Ufalumi wa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Shakapanu Yesu katola shikombi, kalonga mayagashii Mlungu, kalonga, “Muwanki shikombi ashi na mlandiri woseri. ");
INSERT INTO poy_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nukugambirani, kwanjira vinu hanandi kayi ndiri divayi ayi mpaka Ufalumi wa Mlungu pawiza.” ");
INSERT INTO poy_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Shakapanu katoliti libumunda, kalonga mayagashii Mlungu, kalimega na kawapanana womberi pakalonga, “Ayi ndo nshimba ya neni yailaviwa kwajili ya mwenga. Mtendi hangu kwa kunhola neni.” ");
INSERT INTO poy_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Viraa avi, kawapanana shikombi sha divayi pawaliyiti kala shiboga, pakalonga, “Lutekeru alu ndo lipatanu lya syayi lyalilaviyitwi kwa mwazi gwangu wagwitika toziya ya mwenga ");
INSERT INTO poy_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Mloli! Ulii yakang'alambuka ka palaa kankuliya pamuhera naneni. ");
INSERT INTO poy_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mwana gwa Muntu hakahowi ntambu yakafiriti Mlungu, kumbiti shodi kwa muntu yakamgalambuka!” ");
INSERT INTO poy_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Palaa wanjiti kulikosiya weni, su gaa pakati petu hakatendi shitwatila ashi. ");
INSERT INTO poy_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kulawiriti likakatala pakati pa wantumintumi walii gaa ndo hakawezi kuwera mkulu pakati pawu. ");
INSERT INTO poy_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu kawagambira, “Wafalumi wa maisi yawawera ndiri Wayawudi yawakolamlima wantu wawu kwa makakala, nawomberi pawawashema ‘Waganja wa wantu.’ ");
INSERT INTO poy_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kumbiti nayiwera hangu pakati penu, kumbiti ulii yakaweriti mkulu pakati penu ndo kalazima kaweri mdidiki gwa woseri, na yakawera mlongoziya ndo kaweri ndundami. ");
INSERT INTO poy_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Gaa yakaweriti mkulu, ulii yakalikala pasi kuliya shiboga, ama ulii yakatumika? Imanikana ulii yakalikala pameza kuliya shiboga! Kumbiti neni ndo nandundami pakati penu. ");
INSERT INTO poy_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Mwenga mlikala pamuwera na neni shipindi shoseri sha kujerwa kwangu, ");
INSERT INTO poy_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","gambira Tati gwangu ntambu yakanupiti ukolamlima, su naneni hanuwapanani ntambu ira ayi. ");
INSERT INTO poy_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Hamlii na kulanda pameza pangu mu Utuwa wangu na hamulikali muvibanta vya ufalumi kugatoza makabila lilongu na mawili ga Israeli. ");
INSERT INTO poy_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simoni, Simoni! Gupikaniri! Shetani kapatiti ruusa ya kuwajera mwenga mawoseri, kuvilaviya viherepa kulawa muvidoda, gambira mkulima pakapeta nganu kulawa mumakapi. ");
INSERT INTO poy_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kumbiti neni nankuluwira kwa Mlungu, Simoni njimiru yaku nayidodomera. Nagwenga pagumbuyira, guwatangi wayagu.” ");
INSERT INTO poy_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peteru kamwankula, “Mtuwa, neni ng'enda kala pamuhera na gwenga mushibetubetu, na ata kuhowa pamuhera na gwenga.” ");
INSERT INTO poy_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu kamuwankula, “Nukugambira gwenga Peteru, pamberi njogolu hakeniwiki leru hagunemi mala ndatu.” ");
INSERT INTO poy_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Shakapanu Yesu kawakosiyiti wantumintumi wakuwi, “Shipindi shanuwatumiti pota na mpiya, na muhaku ama vilwatu, mpungukiwitwi shintu shoseri?” Wamwankula, “Ndala.” ");
INSERT INTO poy_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu kawagambira, “kumbiti vinu, ulii yakawera na muhaku gwa mpiya kagutoli, yakahera na upanga, kawuzi nguwu yakuwi na kahemeri upanga umu.” ");
INSERT INTO poy_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","“Toziya nukugambirani, Malembu Mananagala galembwa, ‘Wamtuliti shipinga shimuwera pamuhera na wavidoda,’ ndo mpaka gatimii kwa neni, toziya shawalemba kuusu neni shankwiza kuwera nakaka.” ");
INSERT INTO poy_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wantumintumi walonga, “Guloli Mtuwa! Panu kwana mapanga mawili!” Yesu kalonga, “Ayi itosha!” ");
INSERT INTO poy_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu kalawa mulushi na kugenda, ntambu yaiweriti ntambu yakuwi, kagenda mpaka kulugongu lwa mizeyituni, wafundwa wakuwi wamfata. ");
INSERT INTO poy_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pakasokiti kuliya kawagambiriti, “Mluwi Mlungu namwingira mukujerwa.” ");
INSERT INTO poy_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Shakapanu kawaleka kagenda utali wa muntu kuweza kuguma libuwi, kasuntama na kumluwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kalonga, “Tati pagufira, guyiwusiyi nkata ayi ya ndabiku kwa neni. Ata hangu, mafiliru gaku gafiliziwi, pota ganeni ndiri, ira gutendi ntambu yagufira gumweni.” ");
INSERT INTO poy_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Palaa wamahoka wa Mlungu kulawa kumpindi wamlawira, su wamtanga. ");
INSERT INTO poy_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pakaweriti mu kutama nentu, kamluwiti Mlungu na livuki limlawiti gambira matoni ga mwazi, gaturukiti pasi. ");
INSERT INTO poy_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pakaluwiti kala, kawawuyiriti wafundwa wakuwi, kawawoniti wagonja mpota, womberi waweriti na hinginiku. ");
INSERT INTO poy_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kawagambira, “Iwera ashi mgonja? Mwimuki na mluwi, namwingira mukujerwa.” ");
INSERT INTO poy_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu pakaweriti kankali kankuyowera, lipinga lya wantu liza palilongoziwa na Yuda, yumu gwa walii wafundwa lilongu na wawili. Yuda kamgenderiti Yesu na kumnonera. ");
INSERT INTO poy_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesu kamgambira, “Yuda! Hashi gwankumgalambuka Mwana gwa Muntu kwa kumnona?” ");
INSERT INTO poy_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wantumini yawaweriti pamuhera na Yesu pawagawoniti galii gagalawira, womberi wakosiya, “Mtuwa tutumii mapanga getu?” ");
INSERT INTO poy_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na yumu gwawu kamkomiti upanga ntumintumi gwa Mtambika Mkulu na kamdumula likutu lyakuwi lya kumliwu. ");
INSERT INTO poy_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Palaa, Yesu kalonga, “Ayi itosha!” Kalishinkula likutu lya muntu ayu, kamuponiziya. ");
INSERT INTO poy_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Shakapanu Yesu kawagambira watambika wakulu, na wakulu wawalolera wa Numba nkulu ya Mlungu na wazewi wawiziti kumubata, “Hashi, mwiza na mapanga na vindonga kumbata gambira neni na mpoka? ");
INSERT INTO poy_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kila lishaka panweriti pamuhera na mwenga Mnumba nkulu ya Mlungu mumbata ndiri. Kumbiti ashi ndo shipindi shenu asa, ndo shipindi sha ukolamlima wa luwindu.” ");
INSERT INTO poy_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Wamubatiti Yesu na kugenda nayu ukaya kwa Mtambika Mkulu, na Peteru kaweriti kankumfata kwa kutali. ");
INSERT INTO poy_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Motu waguwashiti pakati pa uwa, na Peteru kaweriti pamuhera na woseri weni waweriti walikala pamuhera pawayoterata motu. ");
INSERT INTO poy_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ntumintumi yumu mdala pakamwoniti Peteru kalivaga pakwegera na motu, kamjodoleriti masu na kalonga, “Muntu ayu kaweriti vira pamuhera na Yesu!” ");
INSERT INTO poy_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kumbiti Peteru kaberiti pakalonga, “Ndala gwenga, neni nummana ndiri!” ");
INSERT INTO poy_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Shakapanu hera, muntu yumonga kamwona Peteru na kalonga, “Gwenga gwa yumu gwawu!” Kumbiti Peteru kawankula, “Mtuwa gwenga, neni ndiri!” ");
INSERT INTO poy_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Na lisaa limu pamberi, muntu yumonga kamsisitiza pakatakula, “Nakaka ayu kaweriti pamuhera na Yesu, toziya ayu ndo Mgalilaya vira!” ");
INSERT INTO poy_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Peteru kamwankula, “Mtuwa gwenga, nuvimana ndiri ntambu yagutakula!” Palaa palii, pakaweriti kankali kankuyowera, njogolu kawika. ");
INSERT INTO poy_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mtuwa kagalambuka na kumlola Peteru, na Peteru kalihola galii Mtuwa gakamgambiriti, “Leru pamberi njogolu keniwika hagunemi mala ntatu.” ");
INSERT INTO poy_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Peteru kawukiti kugenda kunja, na kalila nentu. ");
INSERT INTO poy_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Wantu walii waweriti wankumlolera Yesu, wamkomiti na kumhigira. ");
INSERT INTO poy_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Wamtawiti shitambala kusheni, na wankumkosiya, “Gutungi! Gani yakakukomiti?” ");
INSERT INTO poy_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wamlavilira visoweru vivuwa vya kumwigilanga. ");
INSERT INTO poy_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Lishaka lyalifatiti Yesu wamjegiti mushizyungu. Pashizyungu kuweriti na wazewi na watambika wakulu na wafunda wa malagaliru, womberi waliwoniti pamuhera na Yesu wamjegiti kulongolu kwawu. ");
INSERT INTO poy_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nawomberi wamgambira, “Gutugambiri! Hashi, gwenga gwa Kristu?” Su Yesu kawagambira, “Ata panuwagambira, hapeni mnjimiri, ");
INSERT INTO poy_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","handa panuwakosiya hapeni mnankuli. ");
INSERT INTO poy_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kwanjira vinu, Mwana gwa Muntu hakalivagi uwega wa kumliwu wa Mlungu kana makakala goseri.” ");
INSERT INTO poy_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Woseri walonga, “Ndo kulonga gwenga gwa Mwana gwa Mlungu?” Nayomberi kawankula, “Mwenga mtakula handa ndo Neni.” ");
INSERT INTO poy_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nawomberi walonga, “Tufira ndiri kayi ukapitawu umonga? Twaweni tupikanira shilii shakatakuliti.” ");
INSERT INTO poy_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Shikundi shoseri wagolokiti, wamjega Yesu kulongolu kwa Pilatu, ");
INSERT INTO poy_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wanja kumsitaki, pawalonga, “Tumwoniti muntu ayu kankuwasongiziya wantu wetu, na kuwaberiziya wantu kumupanana kodi Kaisari, pakawagambira Kristu mweni ndo, mfalumi.” ");
INSERT INTO poy_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatu kamkosiyiti yomberi, “Hashi, gwenga ndo Mfalme gwa wayawudi?” Yesu kamuwankula, “Gwenga gulonga.” ");
INSERT INTO poy_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatu kawagambira watambika wakulu wa numba ya Mlungu na lipinga lya wantu, “Mona likosa ndiri lyoseri kwa muntu ayu.” ");
INSERT INTO poy_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kumbiti womberi wanjiti kulonga kankuwazongiziya, “Kwa mafundu gakuwi kanjiti kutenda ndewu pakati pa wantu woseri mu Yudeya. Kanjiti mu Galilaya na vinu kiza panu.” ");
INSERT INTO poy_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatu pakapakiniriti aga, kakosiya, “Hashi, muntu ayu ka mwenikaya gwa Galilaya?” ");
INSERT INTO poy_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pakavimaniti handa Yesu kalawiti lushi lwalukolitwimlima na Herodi, su kamjegiti kwa Herodi, ndo mweni yakaweriti mu Yerusalemu shipindi shilii. ");
INSERT INTO poy_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodi kanemeleriti nentu pakamwoniti Yesu, toziya kapikaniriti kala visoweru vyakuwi, su kaweriti kankuhepera kumwona yomberi kwa shipindi shivuwa. Kaweriti kankutumbira kawoni Yesu pakatenda mauzauza. ");
INSERT INTO poy_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Su Herodi kamkosiyiti Yesu makosiwu gavuwa, kumbiti Yesu kamwankula ndiri. ");
INSERT INTO poy_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mtambika mkulu gwa numba ya Mlungu na wafunda wa Malagaliru walawiriti pawulongoru, walaviyiti masitaka gawu kwa makakala nentu. ");
INSERT INTO poy_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodi pamuhera na wanjagila wakuwi, wamwayibishiti Yesu na kumtendera lidufiya, shakapanu wamvalisiya nguwu ya shifalumi, na wamuwuziya kwa Pilatu. ");
INSERT INTO poy_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kwanjira lishaka lilii, Herodi na Pilatu wawera maganja, pamberi pa shipindi shilii waweriti wangondu. ");
INSERT INTO poy_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Su Pilatu kawashemiti pamuhera, watambika wakulu wa numba ya Mlungu, na walongoziya na wantu ");
INSERT INTO poy_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kawagambira, “Mumjega muntu ayu kwaneni pamlonga kaweriti kawasongiziya wantu wawulemi ufalumi wa Rumi. Vinu mpikiniri! Pandoliti kala weri shitwatila ashi pawulongolu penu, mona ndiri likosa lyoseri kwa masitaka genu kwakuwi. ");
INSERT INTO poy_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wala Herodi kawoniti ndiri likosa, su kamuwuziyiti kwa twenga. Kwahera likosa lya kumtenda muntu ayu kahowi. ");
INSERT INTO poy_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Su hanuwalongeri wamsyatangi viboku, hanumleki kagendi zakuwi.” ");
INSERT INTO poy_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kila Mumsambu gwa Pasaka Pilatu kamlekiziyaga mtatilwa yumu pakati pawu. ");
INSERT INTO poy_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Lipinga lyoseri wabotanga pawalonga, “Gumlagi ayu! Gutuvuguliri Baraba!” ");
INSERT INTO poy_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba wamtuliti mushibetubetu toziya ya kutenda ngondu mlushi lulii, viraa kalagiti wantu. ");
INSERT INTO poy_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatu kafiriti kumlekeziya Yesu, su katakula kayi nawomberi. ");
INSERT INTO poy_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kumbiti womberi watenditi umatu, “Gumkong'onderi misumali mulupingika! Gumkong'onderi misumali mulupingika!” ");
INSERT INTO poy_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatu kawagambira mala ya tatu, “Ashi katenda shidoda gaa? Mona ndiri likosa kwakuwi limtendi yomberi wamlagi, su hanumsyatangi viboku, su hanumlekeziyi.” ");
INSERT INTO poy_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kumbiti womberi wakazaniti kutenda umatu kwa kubotanga kuwera Yesu mpaka kakong'onderwi misumali mulupingika, na upeleru wawu wa kutenda umatu ukanga. ");
INSERT INTO poy_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Su Pilatu kaamuwiti ntambu yawafira womberi gatendeki. ");
INSERT INTO poy_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kamvugulira kulawa mushibetubetu muntu ulii yawamfiriti, ndomweni yawamtuliti mushibetubetu toziya ya ngondu yakuwi na kulaga wantu, su kamlaviyiti Yesu kwa womberi wamtenderi ntambu yawafira. ");
INSERT INTO poy_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pawaweriti wankumjega, waliwoniti na muntu yumu yawamshema Simoni gwa Kureni, kaweriti kankulawa muisi na kwingira mlushi. Su wambata, wamtwika lupingika lulii kalutoli kumbeli kwa Yesu. ");
INSERT INTO poy_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lipinga likulu lya wantu limfatiti, mngati mwawu waweriti wadala wankudaya na kumlilira. ");
INSERT INTO poy_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu kawagalambukira, kuwagambira, “Mwenga washina mawu wa Yerusalemu! Namundilira neni, kumbiti mlililiri maweni na wana wenu. ");
INSERT INTO poy_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Toziya mashaka gankwiza, wantu hawalongi, ‘Mbaka kwa walii wagumba, yawaleriti ndiri ama kunonisiya wana!’ ");
INSERT INTO poy_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hashiweri shipindi wantu pawayigambira migongu, ‘Gutuguwiri!’ Na kuvigambira vigongu, ‘Gutugubiki!’ ");
INSERT INTO poy_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kwa mana, handa wantu wankugutendera mtera gwankali kuyuma ntambu hayi, hayiweri hashi kwa mtera guyuma?” ");
INSERT INTO poy_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wawatoliti viraa wantu wamonga wawili, wadoda wawalagi pamuhera na Yesu. ");
INSERT INTO poy_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pawasokiti kala pahala pawapashema, “Shipalakasa sha mtuhi,” Yesu ndo wamkong'onderiti misumali mulupingika pamuhera na walii wadoda wawili, yumu uwega wakuwi wa kumliwu na yumu uwega gwakuwi gwa kumshigi. ");
INSERT INTO poy_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu kalonga, “Tati guwalekeziyi toziya wavimana ndiri vyawatenda.” Shakapanu wagawana nguwu zyakuwi kwa kugalambula simbi. ");
INSERT INTO poy_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wantu wawagolokiti palii pawamlola. Na walongoziya wamtendera lidufiya pawalonga, “Kawalopoziya wamonga, vinu kalilopoziyi mweni, handa mweni ndo Kristu, msyagula gwa Mlungu!” ");
INSERT INTO poy_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wanjagira wamtenderiti vira lidufiya, wamgenderiti wamupa icheshema ");
INSERT INTO poy_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","pawalonga, “Handa nakaka gwenga ndo Mfalumi gwa Wayawudi, gulilopoziyi gumweni.” ");
INSERT INTO poy_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Vira vilii malembu aga wagatula kumpindi kwakuwi, “Ayu ndo Mfalumi gwa Wayawudi.” ");
INSERT INTO poy_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yumu gwa walii wadoda yawakong'onderitwi misumali palupinjika, kamwigilanga Yesu pakalonga, “Hashi, yanakaka ndiri gwenga ndo Kristu? Su gulilopoziyi gumweni, gutulopoziyi na twenga vira.” ");
INSERT INTO poy_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kumbiti mdoda gwingi ulii kamkalipira muyaguwi pakalonga, “Gwenga gumtira ndiri Mlungu ata padidini? Gwenga gupata azabu iraa ayi. ");
INSERT INTO poy_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Gwenga na neni tustahili, mana aga ndo malipu ya galii gatutenditi. Kumbiti muntu ayu katenda ndiri shidoda shoseri.” ");
INSERT INTO poy_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Shakapanu kalonga, “Gwenga Yesu! Gunholi shipindi pagwingira muufalumi waku.” ");
INSERT INTO poy_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu kamwankula, Nukugambira nakaka, lelu haguweri pamuhera na neni muparadisu. ");
INSERT INTO poy_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Iweriti yapata saa sita paliwala, mshenji guleka kuwala, luwindu lugubikiti muisi yoseri mpaka saa tisa, ");
INSERT INTO poy_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","lipaziya lya numba nkulu ya Mlungu lipantika vipandi viwili. ");
INSERT INTO poy_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu kalila kwa liziwu likulu, Tati, mumawoku gaku nuyitula rohu yangu. Pakalongiti hangu kahowa. ");
INSERT INTO poy_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Paliya, mkulu gwa wanjagila pakawoniti kala galii gatendikiti kamkwisa Mlungu pakalonga, “Nakaka ayu kaweriti muntu muheri.” ");
INSERT INTO poy_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wantu woseri walii waweriti wajojinika toziya ya shitwatila ashi, pawawoniti galiya gatendikiti, wawuyiti ukaya kwawu pawahinginitiki. ");
INSERT INTO poy_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Waganja wakuwi pamuhera na wadala walii wamfatiti kulawa Galilaya, wagolokiti kwa kutali kulola shitwatila shiliya. ");
INSERT INTO poy_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kuweriti na muntu yumu litawu lyakuwi Yosefu, mwenikaya gwa shijiji shimu sha Wayawudi shawashishema Arimatayu. Kaweriti muntu muheri yakapananwa ligoya. ");
INSERT INTO poy_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Kaweriti muntu yakashemitwi Yosefu kulawa Arimatayu mlushi lwa Yudeya. Kaweriti muntu mheri na yakapananwa ligoya, kaweriti kankuhepera kwiza kwa ufalumi wa Mlungu. Tembera kaweriti Mjumbi gwa shyoteramotu shikulu sha Wayawudi, kajimiliti ndiri nawomberi majimiranu na matendu gawu. ");
INSERT INTO poy_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yomberi kagenditi kwa Pilatu, kaluwa kamupi nshimba ya Yesu. ");
INSERT INTO poy_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Su kasulusiya nshimba ilii kulawa mulupingika, kayizyengititi sanda ya shitani, kayitula mulipumba lyaliweriti walisongola mulitalawu, lyeni alyenitenderwi. ");
INSERT INTO poy_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lishaka lilii liweriti Ijumaa, na matandiru ga lishaka lya kwoyera liweriti lyankuyanja. ");
INSERT INTO poy_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wadala walii waweriti wafatana na Yesu kulawa Galilaya wamfatiti Yosefu, waliwona lipumba lilii ntambu yawatula nshimba yakuwi. ");
INSERT INTO poy_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Shakapanu wawuyiti ukaya, watanditi uturi na malashi ga kuswaga nshimba ya Yesu. Lishaka lya kwoyera woyeriti gambira malagaliru gaamuwiti. ");
INSERT INTO poy_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jumapili mandawira ndaa, wadala walii wagenditi kulipumba pawatola na utuli ulii wawaunyawiti. ");
INSERT INTO poy_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Wawoniti libuwi lilii libilingisiwa pampenku pa lipumba. ");
INSERT INTO poy_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pawingiriti mngati, wawoniti ndiri nshimba ya Mtuwa Yesu. ");
INSERT INTO poy_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Wagolokiti palii na waweriti wankulishera kwajili shisoweru shilii, kamukamu hera wantu wawili wazivaliti nguwu zimeremeta mbuu wagolokiti pakwegera na womberi. ");
INSERT INTO poy_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wadala walii wingiritwi na lyoga, wasuntama. Su wantu walii wawagambira, “Iwera ashi mwankumsakula mkomu pakati pa wahowiti? ");
INSERT INTO poy_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ka panu ndiri, kazyuka kala! Mliholi galii gakawagambirani pakaweriti kulii Galilaya, ");
INSERT INTO poy_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mwana gwa Muntu mpaka wamlaviyi kwa wantu wanavidoda, nayomberi hawamkong'onderi misumali mulupingika na lishaka lya tatu hakazyuki kwanjira pakahowiti’ ” ");
INSERT INTO poy_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Wadala walii waliholiti vyakatakuliti Yesu, ");
INSERT INTO poy_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","walawiti mulipumba, na watakuliti vintu avi vyoseri kwa wantumintumi walii lilongu na yumu na wamonga wawaweriti paliya. ");
INSERT INTO poy_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hashina Mariya Magidalena na Yoana na Maliya mawu gwa Yakobu, pamuhera na wadala wamonga wawagenditi nawomberi ndo watakuliti vintu vilii kwa wantumintumi. ");
INSERT INTO poy_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kumbiti wantumintumi pawapikaniriti ntambu yawatakuliti wadala walii wahera mana, su wawajimilira ndiri. ");
INSERT INTO poy_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Su Peteru kalawiti na kagenda pakatuga mpaka kulipumba, kasuntama na kawoniti sanda hera. Kawuyiti ukaya pakawera kankulihola kwajili ya galiya yagalawiriti. ");
INSERT INTO poy_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lishaka lilalirii, wantu wawili mngati mwa wantu wawamfata Yesu waweriti wankugenda mushijiji shawashishemiti Emawu, utali wa kilumita lilongu na yimu kulawa Yerusalemu, ");
INSERT INTO poy_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","na waweriti wankuyowera kwajili ya goseri galii yagalawiriti. ");
INSERT INTO poy_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pawaweriti wankuyowera na kuligambiziyana, Yesu mweni kalawira na kugenda pamuwera nawomberi. ");
INSERT INTO poy_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Wamwoniti kwa masu, kumbiti wamumana ndiri. ");
INSERT INTO poy_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu kawakosiya, “Mwankuyowera shishi pamgendagenda?” Womberi wagoloka jii, sheni zyawu zihinginikiti. ");
INSERT INTO poy_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Muntu yumu pakati pawu, yawamshema Kileopa, kamkosiya, “Hashi gwenga gwa muhenga gweka yaku Kuyerusalemu yaguvimana ndiri vitwatira yavirawiriti kulii mashaka aga?” ");
INSERT INTO poy_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu kawakosiya, “Vitwatila gaa?” Womberi wamwankula, “Vitwatira vyavimpatiti Yesu gwa Nazareti. Muntu ayu kaweriti mbuyi gwa Mlungu kana uwezu kulongolu kwa Mlungu na kulongolu kwa wantu, mukila shintu shakatakuliti na kutenda. ");
INSERT INTO poy_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Watambika wakulu na wakolamlima wetu wamlaviya wamtozi kuhowa, na wamkong'ondera misumali palupinjika. ");
INSERT INTO poy_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na twenga tulitumbira handa mweni ndo kaweri yumu yakagenda kuikombola Israeli! Gamonga ga aga goseri, leru ndo lishaka lya tatu kwanjira vitwatira avi pavirawiriti. ");
INSERT INTO poy_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Wadala wamu mushipinga shetu watusintuziya, pawagenditi kulipumba mandawira putiputi, ");
INSERT INTO poy_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","su wayiwoniti ndiri nshimba yakuwi. Wawuyiti pawalonga handa walawiritwi na wantumintumi wa kumpindi, pawawagambiriti handa kaweriti mkomu. ");
INSERT INTO poy_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wamonga mushipinga mwetu wagenditi kulipumba, wawona galii gawatakuliti wadala walii, su mweni wamwona ndiri.” ");
INSERT INTO poy_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Shakapanu Yesu kawagambira, “Iwera hashi mwa wazigizigi shiyasi ashi na myoyu yenu ikamala nentu kugajimira goseri galii gatakulitwi na wambuyi wa Mlungu! ");
INSERT INTO poy_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Hashi, ifiruwa ndiri Kristu kukong'onderwa misumali mulupingika, shakapanu kingiri muukwisa wakuwi?” ");
INSERT INTO poy_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Na Yesu Kawagambira vitwatira vyoseri vya vimuwusu mweni Mumalembu Mananagala mushintola sha Musa na shawalembiti wambuyi woseri wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pawaweriti pakwegera na shijiji shawashigenderiti, Yesu katenda gambira kankwendereya na mwanja, ");
INSERT INTO poy_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","kumbiti womberi wamluwiti pawalonga, “Gwikali pamuwera na twenga, mana kwinala, na pashiru pankwingira.” Su kingira na kulikala pamuwera nawomberi. ");
INSERT INTO poy_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pakalivagiti kuliya shiboga pamuwera na womberi, katola libumunda na kulitekelera, shakapanu kalimega na kuwapanana. ");
INSERT INTO poy_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Masu gawu gavugukiti na wammana, kumbiti kawukiti pamasu pawu. ");
INSERT INTO poy_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Su waligambirana weni, “Hashi myoyu yetu iweriti iyaka ndiri shipindi pakaweriti kankututakulira Malembu Mananagala munjira kulii?” ");
INSERT INTO poy_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wawuka shipindi shilaa shilii na wawuyiti Yerusalemu, wawoniti wantumintumi walii lilongu na yumu na walii wamonga waweriti pamuwera pawalijojinira ");
INSERT INTO poy_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","na walonga, “Nakaka Mtuwa kazyuka! Kamlawira Simoni!” ");
INSERT INTO poy_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Su wantumini wawili wawagambira ntambu yagawapatiti munjira, na ntambu yawammaniti pakamega libumunda. ");
INSERT INTO poy_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wantu awili pawaweriti wankuwagambira aga, palaa paliya Yesu mweni kagoloka pakati pawu na kawagambira, “Ponga iweri na mwenga.” ");
INSERT INTO poy_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Walilimuka na waweriti na lyoga pawavimana wawona shihoka. ");
INSERT INTO poy_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Su Yesu kawagambira, “Iwera ashi mwana lyoga? Iwera ashi myoyu yenu itira? ");
INSERT INTO poy_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mloli mawoku gangu na magulu gangu na mloli neni ndo mweni. Mumbati mundoli na hamvimani, mana shihoka shahera nshimba na mafupa ntambu yamndola.” ");
INSERT INTO poy_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Katakuliti aga na kawalanguziyiti mawoku na magulu gakuwi. ");
INSERT INTO poy_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Waweriti wankali pawagajimira ndiri, toziya ya manemu gawu na wankali wankulishera, Yesu kawakosiyiti, “Mwanashu shiboga shoseri panu shakuliya?” ");
INSERT INTO poy_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wamupa shipandi sha somba wa kubanika, ");
INSERT INTO poy_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","kashitoliti na kushiiliya, woseri pawamlola. ");
INSERT INTO poy_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Shakapanu kawagambira, “Ayi ndo mana ga visoweru vyanuwagambiriti pamweriti pamuhera na mwenga, kila shintu shawalembiti kwajili ya neni Mulilagaliru lya Musa, na mukulemba gawalembiti wambuyi wa Mlungu, na mushintola sha Zaburi gawera nakaka.” ");
INSERT INTO poy_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Shakapanu kagavugula mahala gawu kugamana Malembu Mananagala, ");
INSERT INTO poy_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","na kawagambira, “Ashi ndo shawalembiti, Kristu mpaka katabiki na mpaka kazyuki kulawa kwa wahowiti lishaka lya tatu kwanjira pakahowiti, ");
INSERT INTO poy_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","nalitawu lyakuwi muujumbi kwajili ya kuleka vidoda vyawatenda mpaka wawubweri kwa isi zoseri, kwanjira Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mwenga mwa wakapitawu wa vitwatira avi. ");
INSERT INTO poy_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na neni mweni hanuwajegerani ulii mweni Tati yakalagiliti kumjega, su muheperi muisi uganu mpaka pawakupanani makakala galawiti kumpindi kwakuwi.” ");
INSERT INTO poy_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Su Kawalonguziyiti kunja kuisi mpaka Betaniya, kanyasula mawoku gakuwi kumpindi, na kawatekelera. ");
INSERT INTO poy_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pakaweriti kankuwatekelera, kawaleka, kanyasulitwi kugenda kumpindi kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Womberi wamguwira, na wawuyiti kugenda Yerusalemu, pawawera na nemeli nkulu, ");
INSERT INTO poy_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","na walikaliti shipindi shoseri Mnumba nkulu ya Mlungu pawamkwisa Mlungu.");
INSERT INTO poy_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Panjiti lipaga kuweriti na Shisoweru, Shisoweru kaweriti pamuhera na Mlungu, nayomberi kaweriti Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kwanjira kwanja Shisoweru kaweriti pamuhera na Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kupitila shisoweru, Mlungu kawumbiti vintu vyoseri, kwahera ata shintu shimu shawashiwumbitwi pota nayomberi. ");
INSERT INTO poy_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Shisoweru ndo shanzu sha makaliru na makaliru aga gajegiti weru kwa wantu. ");
INSERT INTO poy_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Uweru awu ulangala muntiti na ntiti hapeni izimiziyi uweru awu. ");
INSERT INTO poy_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mlungu kamtumiti mjumbi gwakuwi litawu lyakuwi Yohani, ");
INSERT INTO poy_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yakiziti kuwapitawulira wantu kuusu uweru awu, su woseri wapikiniriti ujumbi na wamijimiri. ");
INSERT INTO poy_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohani kaweriti ndiri uweru, ira kiziti hera kuwagambira wantu kuusu uweru awu. ");
INSERT INTO poy_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Awu ndo weru wanakaka, weru wankwiza pasipanu, kuwawalira wantu woseri. ");
INSERT INTO poy_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Shisoweru kaweriti pasipanu. Mlungu kanyawiti pasipanu kupitira Shisoweru, kumbiti wantu wa pasipanu wamumana ndiri. ");
INSERT INTO poy_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kiziti muisi yakuwi mweni, kumbiti wantu wakuwi mweni wamuwanka ndiri. ");
INSERT INTO poy_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kumbiti wamonga yawamuwankiti na kumjimira, awa kawayupiti uwezu wa kuwera wana wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Womberi waweriti ndiri wana wa Mlungu kwa uwezu wa wantu ama kwa makakala ga nshimba ama kwa kufira kwa muntu, ira Mlungu mweni kawatenditi waweri wana wakuwi. ");
INSERT INTO poy_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Shisoweru kaweriti muntu, kalikaliti na twenga, kaweriti upendelewu nentu pamuhera na unakaka. Tuwoniti ukwisa wakuwi, ukwisa yakauwankiti, wa Mwana gwa gweka gwa Tati. ");
INSERT INTO poy_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohani kawagambira wantu kuusu Shisoweru. Kabotanga, “Ayu ndo ulii yanumtakuliti shipindi pantakuliti, ‘Paneni kankwiza muntu yumu, yomberi ndo mkulu kuliku neni, toziya kaweriti kala neni naniyiwuki.’ ” ");
INSERT INTO poy_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kulawira na upendelewu uvuwa wakuwi, katutekeleriti woseri, katupiti utekeleru na utekeleru. ");
INSERT INTO poy_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mlungu katupiti Lilagaliru kupitira Musa, kumbiti upendelewu na unakaka viziti kupitira Yesu Kristu. ");
INSERT INTO poy_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kwahera muntu yakamwoniti Mlungu. Kumbiti Mwana gwa gweka yakaweriti Mlungu na yakaweriti uwega wa Tati gwakuwi, ndo yakatenditi kamanikani. ");
INSERT INTO poy_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Awu ndo upitawu wa Yohani kwa wakulu wa Wayawudi Yerusalemu kulii pawawatumiti watambika wamu na wantu wa ukowu wa Lawi wa numba ya Mlungu wagendi kwa Yohani wamkosiyi, “Gwenga gwa gaa?” ");
INSERT INTO poy_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohani kalemiti ndiri kuwankula, ira katakuliti pota na kufifa, kalongiti, “Neni na Kristu ndiri yakasyagulitwi na Mlungu kuwalopoziya wantu.” ");
INSERT INTO poy_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Womberi wamkosiya, “Su, gwenga gwa gaa? Gwenga gwa Eliya?” Yohani kawankula, “Ndala, neni ndiri.” Wamkosiya kayi, “Gwenga ndo ulii Mbuyi gwa Mlungu yawamtakuliti?” Yohani Kawankula, “Ndala!” ");
INSERT INTO poy_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nawomberi wamgambira, “Su, gutugambiri gwenga gwa gaa? Su gutakula hashi kuusu gumweni? Hatugendi kutakula ntambu yagutuwankula kwa walii yawatutumiti.” ");
INSERT INTO poy_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohani kawankula ntambu yakalembiti Isaya mbuyi gwa Mlungu, “Neni ndo liziwu lya muntu yakabotanga mushiwala, ‘Mnyawi njira yakupitira Mtuwa!’ ” ");
INSERT INTO poy_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Wajumbi yawatumitwi na Mafalisayu, ");
INSERT INTO poy_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","wamkosiyiti Yohani, “Paguwera ndiri Kristu, ama Eliya, ama ulii Mbuyi gwa Mlungu, iwera hashi gubatiza?” ");
INSERT INTO poy_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohani kawankula, “Neni mbatiza kwa mashi, kumbiti kwana yumu pakati penu yamummana ndiri. ");
INSERT INTO poy_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Paneni kankwiza, neni herepa ndiri ata kuyopola lugoyi zya vilyatu vyakuwi.” ");
INSERT INTO poy_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Vitwatila vyoseri vyavilawiriti Betaniya kusika mwa lushemba lwa Yoridani, pahala Yohani pakawera kankubatiza. ");
INSERT INTO poy_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Shirawu yakuwi, Yohani kamwoniti Yesu kankumwizira. Yohani katakula, “Ayu ndo Mwana Kondolu gwa Mlungu, yakawusiya vidoda vya wantu wa pasipanu! ");
INSERT INTO poy_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ayu ndo ulii yanumtakuliti, pantakuliti, ‘Paneni kamkwiza muntu yumu mkulu kuliku neni, toziya kaweriti kala neni haneniyiwuki.’ ");
INSERT INTO poy_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Namweni numumaniti ndiri, kumbiti niziti kubatiza kwa mashi su yomberi kamanikana kwa wantu wa Israeli.” ");
INSERT INTO poy_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Na awu ndo upitawu Yohani yakautakuliti, “Moniti Rohu Mnanagala kankusuluka gambira nkunda pakiza kulawa kumpindi kwa Mlungu na kumkangalira. ");
INSERT INTO poy_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Neni numumana ndiri kuwera yomberi ndo uliya yanumtakuliti, su Mlungu yakantumiti neni kubatiza kwa mashi, kang'ambiriti, ‘Hagumwoni Rohu pakamsulukira muntu kulawa kumpindi, ndo ulii yakabatiza kwa Rohu Mnanagala.’ ");
INSERT INTO poy_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yohani katakuliti, Neni moniti, nuwagambirani nakaka kuwera ayu ndo Mwana gwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Shirawu yakuwi, Yohani kaweriti kayi paliya pamuhera na wafundwa wakuwi wawili, ");
INSERT INTO poy_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","pakamwoniti Yesu kankupita katakula, “Ayu ndo Mwana Kondolu gwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wafundwa wawili pawapikaniriti aga, su wagenditi pamuhera na Yesu. ");
INSERT INTO poy_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu kagalambukiti, kawawoniti wankumfata, su kawakosiya, “Mwankusakula shishi?” Womberi wamwankula, “Rabi” mana yakuwi “mfunda” gulikala koshi? ");
INSERT INTO poy_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu kawagambira, “Mwizi na mloli.” Iweriti handa saa lilongu pamihi. Su wagenditi pamuhera na yomberi na wapawoniti pahala pakalikaliti. Walikaliti pamuhera na Yesu lishaka lyoseri. ");
INSERT INTO poy_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andereya, mlongu gwa Simoni Peteru, yakampikiniriti Yohani pakalonga na mweni kamfatiti Yesu. ");
INSERT INTO poy_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andereya kamwoniti kwanja mlongu gwakuwi Simoni, kamgambira, “Tumwoniti ulii Mlopoziya yakasyaguritwi na Mlungu” Ayu ndo Kristu Mlopoziya. ");
INSERT INTO poy_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Su wamjegiti Simoni kwa Yesu. Yesu kamlola Simoni na kalonga, “Litawu lyaku ndo Simoni mwana gwa Yohani, Kumbiti hagushemwi Kefa.” Kwa Shigiriki ndo Peteru, mana yakuwi “Litalawu.” ");
INSERT INTO poy_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Shirawu yakuwi Yesu kaamuwiti kugenda Galilaya. Su kamwoniti Filipu, kamgambira, “Gunfati!” ");
INSERT INTO poy_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipu kaweriti mwenikaya gwa Betisayida, lushi lyawalikaliti ashina Andereya na Peteru. ");
INSERT INTO poy_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipu kamwoniti Nataniyeri na kamgambira, “Tumwona ulii mweni Musa kamlembiti mushitabu sha Malagaliru na wambuyi wa Mlungu walembiti kuusu mweni. Mweni ndo Yesu mwana gwa Yosefu, kulawa Nazareti.” ");
INSERT INTO poy_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyeri kamkosiya Filipu, “Kwana shintu shoseri shiherepa shiza kulawa Nazareti?” Filipu kamwankula, “Gwizi guloli.” ");
INSERT INTO poy_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu pakamwoniti Nataniyeri kankumwizira, katakuliti kuusu yomberi, “Mloli! Ayu ndo Mwisraeli nakaka, kwahera shinika kwakuwi.” ");
INSERT INTO poy_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyeri kamkosiya “Gumana ashi neni?” Yesu kamwankula, “Pamberi pa Filipu kukushema, nukuwoniti pagulivagiti pasi pa mtera gwa mkuyu.” ");
INSERT INTO poy_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniyeri kamwankula, “mfunda, Gwenga ndo Mwana gwa Mlungu! Gwenga gwa Mfalumi gwa Israeli!” ");
INSERT INTO poy_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu kamgambira, “Hashi, gujimira toziya nukugambiriti kuwera nukuwoniti pasi pa mtera gwa mkuyu? Haguwoni vikulu nentu vivuwa kuliku avi!” ");
INSERT INTO poy_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Na Yesu kawagambiriti womberi, “Nankuwagambirani mwenga nakaka, hamuwoni kumpindi kwa Mlungu kuvuguka na wantumintumi wa kumpindi pawakwena na kumsulukira Mwana gwa Muntu.” ");
INSERT INTO poy_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Lishaka lya tatu kuweriti ndowa mulushi lwa Kana, kumkowa Galilaya. Mawu gwakuwi Yesu kaweriti palaa, ");
INSERT INTO poy_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu pamuhera na wafundwa wakuwi nawomberi wawashemiriti ku ndowa. ");
INSERT INTO poy_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Divayi payiperiti, mawu gwa Yesu kamgambira, “Kwahera divayi.” ");
INSERT INTO poy_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu kamwankula, “Mawu, nagung'ambira shakutenda. Saa yaneni yankali.” ");
INSERT INTO poy_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mawu gwa Yesu kawagambira wantumintumi, “Mtendi shoseri shakawagambireni.” ");
INSERT INTO poy_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Palii paweriti na vulu sita zya mabuwi na kila lumu luweziti kutulwa mashi shyasi sha madebi mawili ama matatu. Iweriti wayitula paliii toziya ya shitiba sha Shiyawudi sha kunawira. ");
INSERT INTO poy_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu kawagambira wantumini, “Mumemiziyi viwiga avi mashi.” Nawomberi wavimemiziya mashi nduu, ");
INSERT INTO poy_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","shakapanu kawagambira, “Vinu mteki mashi aga mwakamjegeri mkulu gwa msambu.” Womberi watola mashi na kumjegera yomberi, ");
INSERT INTO poy_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","su vinu mashi gagalambusiwa gawera divayi na kagalawalira. Mkulu gwa msambu kavimana ndiri kwayilawiriti divayi, su wantumintumi pawatekiti mashi wavimaniti, mkulu gwa msambu kamshemiti mpalu gwa ndowa ");
INSERT INTO poy_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kamgambira, “Kila muntu kaitandaga divayi iherepa huti ata pawikuta kala, kaitandaga ilii ifaa ndiri. Kumbiti gwenga guitula divayi iherepa mpaka vinu!” ");
INSERT INTO poy_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu katenda liuzauza ali lya kwanja haku Kana mu Galilaya, kaulanguziya ukwisa wakuwi na wafundwa wakuwi wamjimira. ");
INSERT INTO poy_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pagalawiriti kala aga, Yesu pamuhera na mawu gwakuwi na walongu wakuwi na wafundwa wagenditi Kafarinaumu na walikaliti kuliya mashaka gavuwa ndiri. ");
INSERT INTO poy_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Msambu gwa Pasaka gwa Wayawudi guweriti gwa pakwegera, su Yesu kagenditi Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mnumba nkulu ya Mlungu kawawoniti wantu wankuwuza wang'ombi na wakondolu na wangunda na viraa wantu wamonga wankuvunjira mpiya pawalivaga pameza zawu. 14 ");
INSERT INTO poy_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kanyawiti ntomondu ya lugoyi na kawawinga wavigongolu woseri walawi kunja kwa Numba nkulu ya Mlungu, pamuhera na wakondolu na wang'ombi, kazigalambuziya meza zawatendiriti kuvunjira mpiya na kuzipalasiya mpiya zawu, ");
INSERT INTO poy_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","na kawagambira walii woseri yawaweriti wankuwuza wangunda, “Muusii vintu avi panu! Muleki kutenda numba ya Tati gwangu iweri pahala pa soku!” ");
INSERT INTO poy_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wafundwa wakuwi waliholiti Malembu ntambu yagalembitwi, “Mlungu, kulilaviya kwaneni munumba mwaku kuyaka mumoyu mwangu gambira motu.” ");
INSERT INTO poy_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Wakulu wa Shiyawudi wamu wamkosiya Yesu, “Hagutendi liuzauza gaa kutulanguziya twenga handa gwana uwezu kutenda vitwatira avi?” ");
INSERT INTO poy_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu kawankula, “Hambomoli Numba nkulu ya Mlungu ayi, neni hanuyijengi kayi kwa mashaka matatu.” ");
INSERT INTO poy_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Wayawudi wamkosiya, “Numba nkulu ya Mlungu ayi waijengiti kwa mivinja milongu msheshi na sita! Hashi, gwenga hagujengi kwa mashaka matatu?” ");
INSERT INTO poy_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kumbiti numba nkulu ya Mlungu Yesu yakayitakuliti ndo nshimba yakuwi. ");
INSERT INTO poy_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Su pakazyukisiwitwi kulawa kwa wahowiti, wafundwa wakuwi waliholiti handa katakuliti aga na wagaaminiti Malembu Mananagala na shilii shakatakuliti Yesu. ");
INSERT INTO poy_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu pakaweriti Yerusalemu shipindi sha msambu gwa Pasaka, wantu wavuwa wamjimiriti pawawoniti mauzauza gakatenditi. ");
INSERT INTO poy_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesu kalilaviya ndiri kwa womberi, toziya kayimaniti myoyu yawu woseri. ");
INSERT INTO poy_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kafira ndiri wamgambiri shoseri kuusu wantu, toziya kavimaniti weri vitwatira vyoseri yaviweriti mumyoyu mwawu. ");
INSERT INTO poy_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kuweriti na mkulu gwa Shiyawudi yawamshema Nikodemu, kaweriti gwa shipinga sha Mafalisayu. ");
INSERT INTO poy_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Lishaka limu kamgendera Yesu pashiru na kamgambira, “Mfunda, tuvimana handa gwenga gwa mfunda yagutumitwi na Mlungu. Kwahera muntu yakaweziti kutenda mauzauza gagutenda mpaka Mlungu kapamuhera na yomberi.” ");
INSERT INTO poy_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu kamwankula, “Nakugambira nakaka, Kwahera muntu yakaweza kuwona Ufalumi wa Mlungu, pakayiwuka kayi ndiri.” ");
INSERT INTO poy_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemu kamkosiya, “Muntu mkulu kaweza hashi kwiwuka kayi? Hashi, kaweza kwingira mumtima mwa mawu gwakuwi na kwiwuka mala ya pili?” ");
INSERT INTO poy_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu kamwankula, “Nakaka nukugambira, muntu yoseri pakiwuka ndiri kwa mashi na Rohu Mnanagala, hapeni kingiri Muufalumi wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Muntu kiwuka shinshimba kwa tati na mawu, kumbiti yakiwuka shirohu kwa Rohu Mnanagala. ");
INSERT INTO poy_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nagulikangasha toziya nukugambira mpaka gwiwuki kayi. ");
INSERT INTO poy_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Liyega ligendaga palifira kugenda, gulipikanira kuvuma kwakuwi, kumbiti guvimana ndiri kwalilawiti ama kwaligenda. Ntambu iraayi, iwera hangu kwa muntu yakiwuka kwa Rohu.” ");
INSERT INTO poy_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemu kamkosiya, “Hashi, shitwatila ashi, shiwezikani?” ");
INSERT INTO poy_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu kamwankula, “Hashi, gwenga guwera mfunda gwa Israeli na guvimana ndiri vitwatira avi? ");
INSERT INTO poy_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nukugambira nakaka, tutakula galii tugamaniti na tuwera wakapitawu wa galii tugawoniti, su mwenga mjimira ndiri ujumbi wetu. ");
INSERT INTO poy_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mjimira ndiri paniwagambireni vitwatira vya isi ayi, hashi hamjimiri panuwagambireni vitwatira vya kumpindi? ");
INSERT INTO poy_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kwahera muntu yakapatiti kugenda kumpindi kwa Mlungu, ira Mwana gwa Muntu ndo mweni yakalawiti kumpindi kwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Gambira Musa ntambu yakamtuliti njoka gwa shaba palusiki kushiwala kulii, ntambu iraayi Mwana gwa Muntu hakanyasulwi kumpindi, ");
INSERT INTO poy_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","su kila yakamjimira kawera na ukomu wa mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mana Mlungu kawafiriti nentu wantu wa pasipanu, su kamlaviyiti Mwana gwakuwi gwa gweka, su kila yakamjimira hapeni kahowi, kumbiti kaweri na ukomu wa mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mlungu kamjegiti ndiri Mwana gwakuwi pasipanu kupatoza, kumbiti kapalopoziyi. ");
INSERT INTO poy_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Woseri yawamjimira Mwana hapeni katozwi, kumbiti woseri yawamjimira ndiri watozwa kala, toziya wamjimira ndiri Mwana gwa gweka gwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na toza yeni ndo ayi, gulangala gwiza pasipanu, kumbiti wantu wafiriti ntiti kuliku gulangala, toziya vitendu vyawu vidoda. ");
INSERT INTO poy_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Woseri walii yawatenda vidoda wagukalalira gulangala, hapeni wizi muulangala, toziya wafira ndiri vitendu vyawu vimaniki. ");
INSERT INTO poy_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kumbiti woseri yawatenda unakaka wiza mu mulangala, su gulangala guvilangaliri vitendu vyawu vyawavitenda vyakumjimilira Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Shakapanu, Yesu pamuhera na wafundwa wakuwi wagenditi kumkowa gwa Yudeya, kalikaliti kuliya pamuhera nawomberi kwa shipindi pakabatiza wantu. ");
INSERT INTO poy_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Viraa Yohani kaweriti kankubatiza wantu kulii Ainoni, pakwegera na Salemu, toziya kulii kuweriti na mashi gamema. Wantu wamgendiriti, nayomberi kaweriti kankuwabatiza. ");
INSERT INTO poy_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Shipindi ashi Yohani wenimtuli mushibetubetu. ");
INSERT INTO poy_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Likakatala lilawiriti pakati pa wafundwa wa Yohani na Myawudi yumu kuusu shitiba sha kunawa ntambu yayifiriwitwi. ");
INSERT INTO poy_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Su wamgenderiti Yohani na kumgambira, “mfunda, gumuhola muntu uliya yakaweriti pamuhera nagwenga kusika kumwambu kwa Yoridani, ulii gwenga yagumtakuliti? Vinu yomberi kankubatiza na kila muntu kamgendera!” ");
INSERT INTO poy_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohani kawankula, “Kwahera muntu yakawera na shintu shoseri, mpaka kapananwi kulawa kumpindi. ");
INSERT INTO poy_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Maweni mwenga muweza kutakula galii gantakuliti, ‘Neni na Kristu ndiri, kumbiti wantumiti su numulongoleri.’ ” ");
INSERT INTO poy_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mpalu gwa ndowa ndo mweni gwa mdala gwa ndowa, su wagolokera ndowa yawagolokiti na kupikinira, wanemelera nentu pawapikanira liziwu lya mpalu gwa ndowa. Hangu ndo ntambu ya nemeleriti nentu. ");
INSERT INTO poy_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mweni ndo kendereyi kamanikana ira neni nendereyi kumanikana ndiri. ");
INSERT INTO poy_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yakiza kulawa kumpindi kwa Mlungu ndo mkulu kuliku woseri. Yakalawila pasipanu ndo gwa pasipanu na katakulaga vitwatira vya pasi panu, kumbiti yakiza kulawa kumpindi kwa Mlungu ndo mkulu kuliku woseri. ");
INSERT INTO poy_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yomberi kapitawulira galii kagawoniti na kugapikanira, kumbiti kwahera muntu yakaujimilira ujumbi wakuwi. ");
INSERT INTO poy_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Su muntu yoseri yakajimira ukapitawu wakuwi, katakula weri handa Mlungu ndo gwa nakaka. ");
INSERT INTO poy_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Uliya yakatumitwi na Mlungu kutakula visoweru vya Mlungu, toziya Mlungu kumpanana muntu ayu Rohu Mnanagala pota na shipimu. ");
INSERT INTO poy_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tati kamfira Mwana gwakuwi na kavitula vintu vyoseri mumawoku mwakuwi. ");
INSERT INTO poy_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yakamwamini Mwana kana ukomu wa mashaka goseri, yakamjimira ndiri Mwana hakaweri ndiri na ukomu, su maya ga Mlungu hagaweri kwakuwi. ");
INSERT INTO poy_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafalisayu wapikiniriti handa Yesu kaweriti kankubatiza na kankuwapata wafundwa wavuwa kuliku Yohani. ");
INSERT INTO poy_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kumbiti nakaka Yesu kawera ndiri kankubatiza ira wafundwa wakuwi ndo waweriti wankubatiza. ");
INSERT INTO poy_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu pakapikaniriti aga, kalawa Yudeya kagenda Galilaya, ");
INSERT INTO poy_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","pamwanja gwakuwi kalazimika kupitila Samariya. ");
INSERT INTO poy_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Su kafikiti Sikari, lushi lumu lwa Samariya, pakwegera na lirambu lilii Yakobu lyakamupiti mwana gwakuwi Yosefu. ");
INSERT INTO poy_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na panu paweriti na linegu lya Yakobu. Yesu kaweriti katoka toziya ya mwanja, su kalivagiti pasi pampenku pa linegu. Iweriti ipata saa sita paliwala. ");
INSERT INTO poy_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mdala Msamariya kiziti kuteka mashi na Yesu kamgambira, “Gunupi mashi nandi.” ");
INSERT INTO poy_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Wafundwa wakuwi wagenditi mulushi kuhemera shiboga. ");
INSERT INTO poy_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mdala uliya kamgambira, “Gwenga gwa Muyawudi, neni na Msamariya! Su guwezahashi kunduwa mashi ga kulanda?” Wayawudi hapeni watumii vikombi na vibakuli vyavihanganyikiti na vya wantu wa Samariya. ");
INSERT INTO poy_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu kamwankula, “Handa meguvimaniti mafupu ga Mlungu na gaa yakakuluwa mashi ga kulanda, megumluwi na yomberi mekakupi mashi ga ukomu.” ");
INSERT INTO poy_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mdala uliya kalonga, “Mtuwa, gwenga gwahera shintu sha kutekera mashi na linegu ndo litalipa. Su, hagupati koshi mashi gana ukomu? ");
INSERT INTO poy_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mbuyi gwetu Yakobu ndo yakatupiti linegu ali, yomberi na wana wakuwi pamuhera na mifugu yakuwi yoseri walanditi mashi aga. Ashi gwenga gulitumba kuwera mkulu kuliku Yakobu?” ");
INSERT INTO poy_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu kamwankula, “Woseri walanda mashi aga hawaweri na kwimiluwa kayi. ");
INSERT INTO poy_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kumbiti yoseri yakalanda mashi ganumupa neni, hapeni kaweri na kwimiluwa kayi. Mashi ganumupa hagaweri mngati mwakuwi mbwiru ya mashi ga ukomu na kumupa ukomu wa mashaka goseri.” ");
INSERT INTO poy_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mdala uliya kamgambira, “Mtuwa, gunupi mashi aga! Shakapanu hapeni numuluwi kayi na hapeni nizi kayi panu kuteka mashi.” ");
INSERT INTO poy_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu kamgambira, “Gugendi gwakamshemi mpalu gwaku gwizi nayomberi.” ");
INSERT INTO poy_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mdala uliya kamwankula, “Neni nahera mpalu,” Yesu kamgambira, “Gutakula weri pagutakuliti gwahera mpalu. ");
INSERT INTO poy_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Guyugwa na wapalu wamuhanu, yomberi yagulikala nayu vinu, mpalu gwaku ndiri. Gung'ambira nakaka.” ");
INSERT INTO poy_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mdala uliya kamgambira, “Mtuwa, mona gwenga gwa mbuyi gwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wambuyi wangu wa Samariya wamguwiriti Mlungu mulugongu alu, su mwenga Wayawudi mlonga kuwera Yerusalemu ndo pahala pa kumwabudu Mlungu.” ");
INSERT INTO poy_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu kamgambira, “Mdala, gunjimira, shipindi shankwiza ndo sheni wantu hapeni wamguwira Tati mulugongu alu ama ku Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mwenga Wasamaliya muvimana ndiri nakaka yawamguwira, kumbiti twenga Wayawudi tumumana yatumguwira, toziya ulopoziya wiza kulawa kwa Wayawudi. ");
INSERT INTO poy_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kumbiti shipindi shankwiza na kayi shisoka kala, peni wawamguwira nakaka, hawamguwili Tati kwa likakala lya Rohu, wantu wamguwira hangu ndo Tati yakawafira. ");
INSERT INTO poy_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mlungu ndo Rohu, na wantu hawawezi hera kumwabudu nakaka kwa likakala lya Rowu gwakuwi.” ");
INSERT INTO poy_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mdala ulii kamgambira, “Nuvimana kuwera Kristu Mlopoziya yakasyagulitwi hakizi na pakiza hakatugambiri twenga kila shintu.” ");
INSERT INTO poy_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu kamgambira, “Neni, ndo yantakula na gwenga.” ");
INSERT INTO poy_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Shipindi shila shilii wafundwa wa Yesu wawuyiti na waweriti na likangasha likulu pawamwona Yesu pakatakula na mdala. Kwehera yumu pakati pawu yakamgambiriti mdala ulii, “Gufira shishi?” Ama kumkosiya Yesu, “Iwera hashi gwankutakula na mdala ayu?” ");
INSERT INTO poy_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Su, mdala uliya kaileka vulu yakuwi, kagenda mulushi na kuwagambira wantu, ");
INSERT INTO poy_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mwizi mloli muntu yakang'ambiriti vitwatira vyoseri vyantenditi. Hashi, iwezikana yomberi kawera Kristu yakasyagulitwi na Mlungu?” ");
INSERT INTO poy_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wantu walawa mulushi, wamgendera Yesu. ");
INSERT INTO poy_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Shipindi shila shiriya wafundwa waweriti wankumuhiga Yesu, “mfunda, gulii shiboga!” ");
INSERT INTO poy_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Su Yesu kawankula, “Neni nana shiboga shamshimana ndiri.” ");
INSERT INTO poy_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Wafundwa wakuwi walitakuziyana weni, “Hashi, kwana muntu yoseri yakamjegiriti shiboga?” ");
INSERT INTO poy_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu kawagambira, “Shiboga shaneni ndo kugajimira gakafira ulii yakantumiti neni na kumalira lihengu lyakanupiti kutenda. ");
INSERT INTO poy_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mwenga mtakula, ‘Kunkali myezi ya msheshi hera, shipindi sha kubenanga hashisoki.’ Su nukugambirani, mloli marambu, viboga vinu vipiya kala na viwera kala kubenanga! ");
INSERT INTO poy_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yakabena viboga kankupata shibenamgongu na kankujojinira viboga kwa mashaka goseri, su yumonga yakayala na ulii yakabena hawanemeleri pamuhera. ");
INSERT INTO poy_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kutakula aku kwa nakaka, ‘Yumu kayalaga na yumonga kabenaga.’ ");
INSERT INTO poy_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Neni nuwatumiti mwenga mwakabeni viboga mulirambu mtenda ndiri lihengu, wamonga watenditi lihengu kulii na mwenga muna mota kulawirana na lihengu lyawatenditi.” ");
INSERT INTO poy_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wasamariya wavuwa mulushi lulii wamjimiriti Yesu toziya mdala uliya katakuliti, “Kang'ambiriti neni shintu shoseri shantenditi.” ");
INSERT INTO poy_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Su Wasamariya pawamgendiriti Yesu, wamuluwiti yomberi kalikali pamuhera na womberi na Yesu kalikaliti kulii mashaka mawili. ");
INSERT INTO poy_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Wantu wavuwa wamjimiriti toziya ya ujumbi wakuwi, ");
INSERT INTO poy_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","na womberi wamgambira mdala uliya, “Vinu twenga tujimira, toziya ndiri ya shilii shagutakuliti, ira toziya twenga tumpikanira twaweni na tuvimana kuwera nakaka ndo Mlopoziya gwa pasipanu.” ");
INSERT INTO poy_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pagapititi mashaka mawili, Yesu kawukiti paliya na kugenda Galilaya. ");
INSERT INTO poy_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mana Yesu mweni katakuliti, “Mbuyi gwa Mlungu hapeni kapananwi ligoya muisi yakuwi.” ");
INSERT INTO poy_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pakafikiti Galilaya, wantu wa paliya wamshemiriti, toziya pawaweriti mumsambu gwa Pasaka kulii Yerusalemu wawonaga vitwatira vyoseri vyakatenditi Yesu shipindi sha msambu. ");
INSERT INTO poy_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Su Yesu kawuyiti kayi Kana mumkowa gwa Galilaya, pahala pakagalambuziti mashi kuwera divayi. Afisa gwa sirikali kaweriti paliya mwana gwakuwi kaweriti kalwala ku Kafarinaumu. ");
INSERT INTO poy_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pakapikaniriti handa Yesu kankwiza Galilaya pakalawila Yudeya, kamgendiriti yomberi na kumgambira kagendi Kaferinawumu na kamuponiziyi mwana gwakuwi, yakaweriti sambira kahowa. ");
INSERT INTO poy_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu kamgambira, “Pamwona ndiri malangaliru na mauzauza, hapeni mjimiri!” ");
INSERT INTO poy_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Afisa ulii kamwankula, “Mtuwa, tugendi pamuhera vinu, mwana keni howi.” ");
INSERT INTO poy_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu kamgambira, “Gugendi, mwana gwaku hakaweri mkomu!” Muntu uliya kavimaniti visoweru vya Yesu, su kagenda zakuwi. ");
INSERT INTO poy_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Pakaweriti kankali kamunjira kuwuya ukaya kaliwoniti na wantumintumi wakuwi pawamjegera visoweru, “Mndemba gwakuwi kawera mkomu!” ");
INSERT INTO poy_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kawakosiya shipindi gaa mwana gwakuwi pakaweriti mkomu na womberi wamwankula, “Iweriti saa saba paliwala lishu nshimba kupyupa paimlekeziyiti.” ");
INSERT INTO poy_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tati uliya kaliholiti kuwera shipindi shiliya ndo Yesu pakamgambiriti, “Mwana gwaku hakaweri mkomu.” Su mweni pamuhera na kaya yakuwi yoseri wamjimira Yesu. ");
INSERT INTO poy_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Liuzauza ali ndo lya pili lyakatenditi Yesu pakaweriti kankulawa Yudeya na kugenda Galilaya. ");
INSERT INTO poy_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Shakapanu, Yesu kagenditi Yerusalemu kumsambu gwa Wayawudi. ");
INSERT INTO poy_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kulaa Yerusalemu, pakwegera na mlyangu gwawagushemiti Mlyangu gwa kondolu, kweniti na litanda lyawalishemiti kwa Shiebraniya Betizata, liweriti na seemu midamu muhanu. ");
INSERT INTO poy_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Lipinga likulu lya walweli walivagiti seemu azi, wanalwisi na wavibyeketu na walewelekiti. Su waweriti wankuhepera mashi gatimbuki, ");
INSERT INTO poy_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","toziya lihoka lya Mlungu kulawa kwa Mtuwa kila mala pakiza na kugatimbula mashi. Mlweri gwa kwanja kwingira mumashi pagatimbuka kaponiziwa. ");
INSERT INTO poy_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Paliya paweriti na muntu yumu yakalwaliti kwa shipindi sha mivinja milongu mitatu na nane. ");
INSERT INTO poy_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu pakamwoniti muntu uliya kagonja paliya na kavimaniti kuwera kalwariti kwa shipindi shivuwa, su kamkosiyiti, “Hashi, gufira guponi?” ");
INSERT INTO poy_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Muntu yakalwala kankula, “Mtuwa, kwahera muntu panu gwankuntula mumashi shipindi mashi pagatimbuka. Panjeriti kwingira kumbiti kila mala, muntu yumonga kanongulera.” ");
INSERT INTO poy_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu kamgambira, “Gugoloki, gutoli mkeka gwaku gugendigendi.” ");
INSERT INTO poy_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Palaa paliya muntu uliya kapona. Kagutoliti mkeka gwakuwi na kanja kugendagenda. Shitwatila ashi shitendikiti Mulishaka lya kwoyera. ");
INSERT INTO poy_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Wakulu wa Wayawudi pawawoniti muntu ulii yakaponiziwitwi, womberi wamgambira, “Leru ndo lishaka lya kwoyera! Kwahera ulekeziwu kwa gwenga kupapa mkeka gwaku.” ");
INSERT INTO poy_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kumbiti Yomberi kawagambira, “Muntu yakamponiziyiti kang'ambiriti ntoli mukeka, ng'ending'endi.” ");
INSERT INTO poy_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nawomberi wamkosiyiti, “Ndo gaa yakakugambiriti gutoli mukeka gwaku na gugendigendi?” ");
INSERT INTO poy_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kumbiti yomberi kamumana ndiri muntu yakamuponiziiti, mana Yesu kaweriti kalihanganiya mulipinga lya wantu. ");
INSERT INTO poy_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Shapakanu Yesu kaliwoniti na muntu yakamponiziyiti Mnumba nkulu ya Mlungu, su kamgambira, “Gupikani vinu gwamkomu, guleki kutenda vidoda ama vitwatira vidoda virawili kwaku.” ");
INSERT INTO poy_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Shakapanu muntu uliya kagenda, kawagambira wakolamlima wa Shiyawudi kuwera Yesu ndo yakamuponiziiti. ");
INSERT INTO poy_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Su Wayawudi wanjiti kumgaziya Yesu, toziya yomberi katenditi shitwatila ashi sha kuponiziya mulishaka lya Kwoyera. ");
INSERT INTO poy_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu kawagambira womberi, “Tati gwangu kankutenda lihengu mashaka goseri, naneni viraa ntenda lihengu.” ");
INSERT INTO poy_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Visoweru avi viwatenda wakulu wa Shiyawudi wendereyi kusakula ntambu ya kumlaga Yesu, toziya kalitenda ndiri weri lilagaliru lya lishaka lya Kwoyera na katakuliti kuwera Mlungu ndo Tati gwakuwi na viraa vilii pakalitenda kuwera gambira Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu kawagambiriti womberi, “Nukugambirani nakaka, Mwana kaweza ndiri kutenda shoseri gweka yakuwi, katenda shilii shakawoniti Tati gwakuwi pakatenda. Vilii vyakatendaga Tati, viraa vilii ndo vyakatenda Mwana. ");
INSERT INTO poy_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Toziya Tati kamfira Mwana na kamlangalira yomberi vyoseri vyakatenditi mweni, viraa vilii hakamlanguzii vitwatira vikulu kuliku avi, mwenga hamlikangashi. ");
INSERT INTO poy_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Handa virii Tati pakawazyukisiyiti wahowiti na kuwapanani ukomu, ntambu iraayi Mwana kawapanani ukomu yawafira walii. ");
INSERT INTO poy_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tati hapeni katozi muntu yoseri, kumbiti lihengu lyoseri lya kutoza kamupa Mwana, ");
INSERT INTO poy_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","su wantu woseri wamgohilili Mwana ntambu yawamgohelera Tati. Yakamgohelira ndiri Mwana, kamgohalila ndiri Tati. Tati ndo mweni yakamtumiti Mwana. ");
INSERT INTO poy_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nakugambirani nakaka, woseri yawapikanira visoweru vyangu na kumjimira ulii yakantumiti, hakaweri na ukomu wa mashaka goseri. Hapeni katozwi, ira kapita kala kulawa mukuhowa na kwingira muukomu. ");
INSERT INTO poy_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nukugambirani nakaka, shipindi shankwiza, kayi shisoka kala, ndo sheni wahowiti hawapikiniri liziwu lya Mwana gwa Mlungu na woseri yawapikanira hawalikali. ");
INSERT INTO poy_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Gambira Tati ntambu yakawera shanzu sha ukomu, hera hangu viraa ntambu yakamtenda Mwana gwakuwi kuwera shanzu sha ukomu. ");
INSERT INTO poy_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na kamupiti Mwana uwezu wa kutoza, toziya yomberi ndo Mwana gwa Muntu. ");
INSERT INTO poy_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Namulikangasha shitwatila ashi, shipindi shankwiza wawahowiti woseri hawapikiniri liziwu lyakuwi ");
INSERT INTO poy_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nawomberi hawalawi mumapumba mwawu, woseri walii yawatenditi viherepa hawazyuki na kulikala, na woseri yawatenditi vidoda, hawazyuki na kutozwa.” ");
INSERT INTO poy_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Neni weza ndiri kutenda shoseri kwa uwezu waneni. Neni ntenda hera ntambu ya Mlungu pakang'ambira, su kutoza kwaneni ndo teratera, toziya njeriti ndiri kutenda shirii shanfira, kumbiti ntenda shirii shakafira ulii yakantumiti. ");
INSERT INTO poy_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Handa panulitakulila namweni, upitawu wa neni hapeni ujimilwi kuwera wa nakaka. ");
INSERT INTO poy_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kumbiti kwana yumonga ndo mweni katakulaga upitawu kuusu neni, naneni nuvimana kuwera vyoseri vyakatakula kuusu neni ndo vyanakaka. ");
INSERT INTO poy_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mwenga mtumiti ujumbi kwa Yohani, nayomberi kawutakuliti nakaka. ");
INSERT INTO poy_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Neni nuwutumbira ndiri upitawu wa wantu, kumbiti ntakula vitwatira avi mpati kulopoziwa. ");
INSERT INTO poy_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohani kaweriti gambira lumuliku lwaluweriti lwakuyaka na kulangala na mwenga musekereriti kulangala kwa shipindi shididiki hera. ");
INSERT INTO poy_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Neni nanawu upitawu kuusu namweni ndo weni mkulu mnu kuliku ulii wa Yohani. Shantenda ndo sheni shakung'ambira kuwera Tati ndo yakantumiti. ");
INSERT INTO poy_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tati ndo yakantumiti, viraa kananguziya. Mwenga hapeni mpikaniri liziwu lyakuwi ama mwoni sheni shakuwi, ");
INSERT INTO poy_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","na visoweru vyakuwi hapeni vikali mumyoyu mwenu, toziya mumjimira ndiri ulii yakamtumiti. ");
INSERT INTO poy_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Mwenga mgalola weri Malembu Mananagala, toziya mulihola kuwera mngati mwakuwi hampati ukomu wa mashaka goseri, kumbiti Malembu galaa galiya gantakula! ");
INSERT INTO poy_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pamuhera na hangu, mwenga mlema kwiza kwaneni mpati ukomu. ");
INSERT INTO poy_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ndolera ndiri ukwisa kulawa kwa wantu. ");
INSERT INTO poy_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kumbiti nuwamana mwenga, nuvimana kuwera ufiru wa Mlungu kwahera mumyoyu mwenu. ");
INSERT INTO poy_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Neni niza kwa uwezu wa Tati gwangu, su munshemera ndiri, Kumbiti mwenga muwashemeraga wantu pawiza muuwezu wawu. ");
INSERT INTO poy_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mfira kuwanka uzyumi kwa wantu, kumbiti mfira ndiri kujera kutenda vitwatira kwa ulii yakawera Mlungu gweka yakuwi, hashi mweza kunjimira neni? ");
INSERT INTO poy_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Namlihola handa neni hanuwasitaki mwenga kwa Tati gwangu. Musa ndo mweni, mwenga mumtumbiriti mweni ndo hakawasitaki. ");
INSERT INTO poy_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Handa nakaka mwenga memjimiri Musa, viraa memnjimiri naneni, toziya Musa kalembiti kuusu neni. ");
INSERT INTO poy_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kumbiti mugajimiri ndiri galii gakalembiti Musa, hamuwezi hashi kuvijimira visoweru vyangu?” ");
INSERT INTO poy_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Shakapanu, Yesu kalokiti litanda lya Galilaya ama litanda lya Tiberiya ");
INSERT INTO poy_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Lipinga likulu lya wantu limfatiti toziya wantu awa waweriti wawona mauzauza gakuwi ga kuwaponiziya walweli ");
INSERT INTO poy_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu kakweniti mulugongu, kalivaga pamuhera na wafundwa wakuwi. ");
INSERT INTO poy_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Msambu gwa Wayawudi gwa Pasaka guweriti gwapakwegera. ");
INSERT INTO poy_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Su, Yesu kalola wega zoseri na kuwona lipinga likulu lya wantu lyankumwizira, kamkosiya Filipu, “Tuhemeri koshi mabumunda su wantu awa wapati kuliya?” ");
INSERT INTO poy_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Katakuliti aga kumjera Filipu, kavimaniti kala mweni hakavinyawi. ");
INSERT INTO poy_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipu kamwankula, “Mabumunda ga mpiya sha shibenamgongu sha myezi sita hashiwatoshi ndiri wantu awa.” ");
INSERT INTO poy_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yumu gwa Wafundwa wakuwi yawamshema Andereya, mlongu gwakuwi Simoni Peteru kamgambira, ");
INSERT INTO poy_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Panu pana muntemba yumu kawera na mabumunda muhanu na wasomba wawili. Kumbiti avi vitosha ndiri kwa wantu wavuwa handa awa?” ");
INSERT INTO poy_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu katakula, “muwagambirani wantu walivagi pasi.” Paweriti na mahamba pahala palii. Wantu walivagiti. Paweriti wapalu elufu muhanu. ");
INSERT INTO poy_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu katola mabumunda galii, kalonga mayagashii Mlungu, kawapanana wantu yawalivagiti pasi. Katenda hangu na wasomba walii. ");
INSERT INTO poy_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wantu pawikutiti Yesu kawagambira Wafundwa wakuwi, wajojaniri vipandi vyavisigaliti, namwasa shintu. ");
INSERT INTO poy_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Su, wavitula pamuhera vipandi vyavisigaliti vya mabumunda wavimemiziya mumajamanda lilongu na mawili kulawa kwa mabumunda muhanu galii. ");
INSERT INTO poy_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Wantu pawaliwoniti liuzauza ali Yesu lyakalitenditi, watakula, “Nakaka ayu ndo mweni mbuyi gwa Mlungu yakiziti pasipanu.” ");
INSERT INTO poy_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu kavimana handa wantu wafiriti kumtola kwa makakala wamtendi mfalumi, kawukiti kayi kagenditi palugongu gweka yakuwi. ");
INSERT INTO poy_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Payisokiti pamihi, Wafundwa wakuwi wasokiti kulitanda, ");
INSERT INTO poy_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Wakwena mumtumbwi, su waloki kugenda Kafarinaumu. Ntiti iweriti yankwingira na Yesu kaweriti kankali kuwayizira. ");
INSERT INTO poy_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Liyega liweriti lyankuvuma na mawimbi ga mashi gaweriti gakutindira. ");
INSERT INTO poy_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wafundwa pawaweriti wankugenda kutali kwa kilumita muhanu ama sita, wamwoniti Yesu kankugendagenda pamashi, kaweriti pakwegera na mtumbwi, womberi watiriti nentu. ");
INSERT INTO poy_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu kawagambira, “Namtira, ndo neni!” ");
INSERT INTO poy_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Su womberi wafiriti kumtola Yesu mumtumbwi na palaa palii mtumbwi gusokiti muisi pahala pawaweriti wankugenda. ");
INSERT INTO poy_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Shirawu yakuwi wantu wavuwa wasigaliti uwega gwa pili wa litanda, wavimaniti handa kuweriti na mtumbwi gumu hera palii. Womberi wavimaniti kuwera Yesu hapeni kagendi na wafundwa wakuwi, kumbiti wafundwa wakuwi wagenditi pawamleka Yesu. ");
INSERT INTO poy_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mitumbwi imonga ilawa Tiberiya isoka pahala lipinga lya wantu pawaliyiti mabumunda, shipindi Mtuwa pakalongiti mayagashii Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Su, wantu awa pawavimaniti handa Yesu na wafundwa wakuwi waweriti ndiri pahala paliya, wakwena mtumbwi gumonga wagenda Kafarinaumu pawamsakula. ");
INSERT INTO poy_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wantu walii pawamwoniti Yesu kumwambu kulitanda wamkosiya, “Mfunda, gwiza ndiri panu?” ");
INSERT INTO poy_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu kankula, “Nakaka nuwagambirani, mwankunsakula ndiri toziya mumaniti weri liuzauza lilii, kumbiti toziya muliyiti mabumunda galii mwikuta. ");
INSERT INTO poy_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Namushitendera lihengu shiboga shashyalibika, kumbiti mushitenderi lihengu shiboga sha ukomu wa mashaka goseri. Ashi ndo shiboga Mwana gwa muntu hakakupanani, toziya Tati Mlungu kamjimira kutenda hangu.” ");
INSERT INTO poy_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Womberi wamkosiya, “Tutendi shishi su tutendi vilii vyakafira Mlungu twenga tutendi?” ");
INSERT INTO poy_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu kawankula, “Vintu vyakafira Mlungu ndo mwenga kumjimira ulii yakantumiti.” ");
INSERT INTO poy_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wamgambira, “Hagutendi liuzauza gaa su tuloli tupati kukujimira? Hagutendi shintu gaa? ");
INSERT INTO poy_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wazewi wetu waliyiti shiboga shawashishema Mana kushiwala kulii, gambira Malembu galembwa, Kawayupiti libumunda kulawa kumpindi kwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu kawagambira, “Nakaka nuwagambirani, Musa kawayupiti ndiri libumunda kulawa kumpindi kwa Mlungu, Tati gwangu ndo mweni kawapanani mwenga libumunda lya nakaka kulawa kumpindi. ");
INSERT INTO poy_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Toziya mabumunda ga Mlungu ndo ula ulii kasuluka kulawa kumpindi na kutupanana ukomu wa pasipanu.” ");
INSERT INTO poy_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Su, wamgambira, “Mtuwa, gutupi kila lishaka libumunda ali.” ");
INSERT INTO poy_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu kawagambira “Neni ndo libumunda lya ukomu. Walii yawiza kwaneni hawawoni ndiri njala, yakanjimira neni hawawoni ndiri kwimiluwa. ");
INSERT INTO poy_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nuwagambirani weri kulonga mumona, kumbiti munjimira ndiri. ");
INSERT INTO poy_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Woseri ndo weni yakanupa Tati hawizi kwaneni, naneni hapeni numwingi yoseri yakiza kwaneni, ");
INSERT INTO poy_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","toziya niza kulawa kumpindi kwa Mlungu ira ntendi ndiri vilii vyanfira. Niza kutenda vilii vyakafira ulii yakantumiti. ");
INSERT INTO poy_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Uliya yakantumiti kafira aga, nanimwamizili yumu pakati pa walii yakanupiti, ira hanuwazyukusiyi woseri lishaka lya kupelera. ");
INSERT INTO poy_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mana shakafira Tati gwangu ndo ashi, kila yakamwona Mwana na kumjimira kawera na ukomu wa mashaka goseri. Neni hanuwazyukusiyi lishaka lya kupelera.” ");
INSERT INTO poy_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Su Wayawudi wanjiti kuhinginika kuusu yomberi toziya Yesu katakuliti, “Neni ndo libumunda lilawiti kupindi.” ");
INSERT INTO poy_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Su womberi watakula, “Hashi, ayu Yesu ndiri mwana gwa Yosefu? Tumumana tati gwakuwi na mawu gwakuwi! Su, kaweza hashi kutakula kalawa kumpindi kwa Mlungu?” ");
INSERT INTO poy_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu kawagambira, “Mleki kuhinginika mwenga kwa mwenga. ");
INSERT INTO poy_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kwahera muntu kawezi kwiza kwaneni mpaka Tati yakantumiti pakamjega kwaneni, naneni hanumzyukisiyi muntu ayu ku ukomu lishaka lya kupelera. ");
INSERT INTO poy_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wambuyi wa Mlungu walembiti, ‘Wantu woseri hawafundwi na Mlungu.’ Kila muntu yakampikanira Tati na kulifunda kwa yomberi kizi kwaneni. ");
INSERT INTO poy_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Ayi yahera mana handa kamlamu muntu yakamwoniti Tati, payiweri ndiri uliya yakalawiti kwa Mlungu, uliya ndo yomberi yakamwoniti Tati. ");
INSERT INTO poy_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nunkugambirani nakaka, yakanjimira kana ukomu wa mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Neni nalibumunda lya ukomu. ");
INSERT INTO poy_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wambuyi wenu waliyiti mana kushiwala kulii, kumbiti wahowiti. ");
INSERT INTO poy_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kumbiti libumunda lyalilawa kumpindi kwa Mlungu su muntu yoseri yakaliya hapeni kahowi. ");
INSERT INTO poy_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Neni nalibumunda likomu lyalisulukiti kulawa kumpindi kwa Mlungu. Muntu yoseri yakaliya libumunda ali hakalikali mashaka goseri. Na libumunda lyanumupa yomberi ndo nshimba yaneni, yanuilaviya su wantu wa pasi panu waweri na ukomu.” ");
INSERT INTO poy_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Shapakanu Wayawudi wanjiti kulitakuliziyana nentu pakati pawu, “Kaweza hashi muntu ayu kutupanana nshimba yakuwi, tuliyi?” ");
INSERT INTO poy_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu kawagambira, “Nankuwagambirani nakaka, pamuliya ndiri nshimba ya Mwana gwa Muntu na kulanda ndiri mwazi gwakuwi, hapeni muweri na ukomu. ");
INSERT INTO poy_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yakaliya nshimba yaneni na kulanda mwazi gwangu kanawu ukomu wa mashaka goseri, naneni hanumzyukusiyi lishaka lya kupelera. ");
INSERT INTO poy_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Toziya nshimba yaneni ndo shiboga sha nakaka na mwazi gwangu ndo gwakulanda nakaka. ");
INSERT INTO poy_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yakaliya nshimba yaneni na kulanda mwazi gwangu, kenilikali mngati mwangu, naneni nulikali mngati mwakuwi. ");
INSERT INTO poy_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Tati yakawera mkomu yakantumiti neni, toziya naneni nulikali viraa. Ntambu iraayi yoseri yakandiya neni hakalikali toziya yaneni. ");
INSERT INTO poy_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Su, ali ndo libumunda lisulukiti kulawa kumpindi kwa Mlungu, handa ndiri libumunda lyawaliyiti wambuyi wenu. Pawaliyiti kala wahowiti, kumbiti wantu woseri wawaliya libumunda ali hawaweri na ukomu wa mashaka goseri.” ");
INSERT INTO poy_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu katakuliti aga pakaweriti kankufunda munumba ya Mlungu kulii Kafarinaumu. ");
INSERT INTO poy_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Su wantu wavuwa wafundwa wakuwi pawapikaniriti aga watakula, “Aga ndo mafundu gakamala! Gani kaweza kugapikanira?” ");
INSERT INTO poy_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu kavimaniti pota nakugambirwa na muntu, kulonga wafundwa wakuwi waweriti wankuhiginika kuusu shitwatila ashi, su kawakosiiti, “Hashi, shitwatila ashi shiwatenda muweri ndiri na nakaka? ");
INSERT INTO poy_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Haiweri hashi pamumwona Mwana gwa Muntu pakakwena kugenda pahala palii pakaweriti pakwanjira? ");
INSERT INTO poy_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Rohu gwa Mlungu ndo yakajega ukomu, nshimba ya muntu hapeni iwezi. Visoweru vyanuwagambirani ndo vya Rohu yakajega ukomu. ");
INSERT INTO poy_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ata hangu wamonga wenu wajimira ndiri.” Yesu kavimaniti kwanjira pakwanjira walii yawajimira ndiri, viraa ndo gaa hakamgalambuki. ");
INSERT INTO poy_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesu kongeriti katakula kayi, “Ayi ndo toziya nuwagambiriti kulonga kwahera muntu yakaweza kwiza kwaneni pakawezeshwa ndiri na Tati gwangu.” ");
INSERT INTO poy_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Toziya ya aga, wamonga wavuwa wafundwa wa Yesu wawuyiti na waleka kumfata kayi. ");
INSERT INTO poy_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Su, Yesu kawakosiiti wantumintumi walii lilongu na wawili, “Hashi, mwenga, mfira kuwuya kwenu?” ");
INSERT INTO poy_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Peteru kamwankula, “Mtuwa, tugendi kwa gaa? Gwenga gwana visoweru vya ukomu wa mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Twenga tujimira vinu na tuvimana gwenga gwa Mnanagala yakiza kulawa kwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu kawankula, “Hashi nuwasyagula ndiri mwenga lilongu na wawili? Ata hangu, yumu gwenu ndo Shetani!” ");
INSERT INTO poy_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu katakuliti aga kuusu Yuda, mwana gwa Simoni Isikariyoti, Yuda kaweriti yumu gwa wafundwa wakuwi kumbuti ndo hakamgalambuki Yesu. ");
INSERT INTO poy_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pa aga, Yesu kaweriti kankugendagenda kulaa ku Galilaya. Kafiriti ndiri kugendagenda kumkowa wa Yudeya toziya wakulu wa Wayawudi waweriti wankufira kumlaga. ");
INSERT INTO poy_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Shipindi sha msambu gwa Wayawudi gwa visasa guweriti gwapakwegera. ");
INSERT INTO poy_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Su, walongu wakuwi wamgambira, “Guwuki panu gugendi Yudeya, su wafundwa waku wawoni vitwatira vyagutenda. ");
INSERT INTO poy_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Muntu katenda ndiri vitwatira kwa kubada pakafira kamanikani kwa wantu. Toziya gutenda vitwatira avi, guleki wantu wa pasipanu poseri wavimani kuusu gwenga.” ");
INSERT INTO poy_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ata walongu wakuwi wamjimira ndiri. ");
INSERT INTO poy_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu kawagambira, “Shipindi shangu shashifaa shankali kusoka. Mwenga kila shipindi shifaa. ");
INSERT INTO poy_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wantu wa pasipanu hapeni wizi kuwakalalira mwenga, neni wankalalira toziya neni ntakula kwawu kuwera matendu gakuwi gadoda. ");
INSERT INTO poy_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mwenga mgendi kumsambu. Neni hapeni ng'endi ku msambu aku vinu, toziya saa yaneni yaifaa yankali kusoka.” ");
INSERT INTO poy_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Katakuliti aga, shakapanu kendereyiti kulikala Galilaya. ");
INSERT INTO poy_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Walongu wakuwi pawagenditi kala kumsambu, Yesu kagenditi viraa, kumbiti kagenditi ndiri pawamlola ira kagenditi kwa kulififa. ");
INSERT INTO poy_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Wakulu wa Wayawudi waweriti wankumsakula ku msambu aku. Womberi wakosiya, “Ka koshi?” ");
INSERT INTO poy_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kuweriti mapwepweziyu nentu kuusu Yesu mulipinga lya wantu. Wamonga watakuliti, “Yesu ndo muntu muheri.” Na wamonga watakuliti, “Ndala! Kankuwapayira wantu.” ");
INSERT INTO poy_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kumbiti kwahera muntu yakatakuliti kuusu Yesu paweru, toziya waweriti wankuwatira wakulu wa Shiyawudi. ");
INSERT INTO poy_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Msambu agu pagusokiti pakati na kumalirika, Yesu pakagenditi ku Numba nkulu ya Mlungu, kanjiti kufunda. ");
INSERT INTO poy_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wakulu wa Shiyawudi walikangashiti nentu, walongiti, “Iwera hashi muntu ayu kerewa nentu, nayomberi kagenditi ndiri kushuli?” ");
INSERT INTO poy_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu kawankula, “Shilii shanfunda shilawa kwaneni ndiri, ira shilawa kwa Mlungu, ndo mweni yakantumiti. ");
INSERT INTO poy_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Muntu yakafira kutenda galii gagafira Mlungu, haguvimani handa mafundu gangu galawa kwa Mlungu, ama neni nfunda kwa uwezu wangu namweni. ");
INSERT INTO poy_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Muntu yakatakula kwa uwezu wakuwi mweni, kankusakula uzyumi wakuwi mweni. Kumbiti ulii yakasakula uzyumi wa ulii yakantumiti, ayu ndo mwaminika na mngati mwakuwi kwahera ufyangu woseri. ");
INSERT INTO poy_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Hashi, Musa kakupanana ndiri Lilagaliru? Ata hangu, kwahera ata yumu gwenu yakalijimila Lilagaliru. Hashi, mfira mndagi?” ");
INSERT INTO poy_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Lipinga lya wantu limwankula, “Gwenga gwana shamshera! Gani kafira kukulaga?” ");
INSERT INTO poy_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu kawankula, “Kwana liuzauza limu lyantenditi, namwenga mlikangashiti. ");
INSERT INTO poy_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa kawalagaliriti mwenga muwayingiziyi jandu wana wenu, shitiba ashi sha Musa ndiri ira wambuyi wenu ndo wanjiti kushitenda shitiba ashi na mumwingiziya jandu mwana mulishaka lya Kwoyera. ");
INSERT INTO poy_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Handa pamumwingiziya mwana jandu mulishaka lya Kwoyera su mleka ndiri Lilagaliru lya Musa, iwera hashi munkalalira neni toziya numponiziya muntu mulishaka lya Kwoyera? ");
INSERT INTO poy_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mleki kutoza kwa kunja hera, mtozi kwa shipimu sha teratera.” ");
INSERT INTO poy_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Wantu wamu wa Yerusalemu watakuliti, “Ndo ayu ndiri, muntu yawamsakula wamlagi? ");
INSERT INTO poy_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mloli! Kawagambira pota na kufifa, womberi watakula ndiri shintu shoseri kuusu yomberi! Hashi, iwezekana kuwera wakulu wavimana nakaka kuwera muntu ayu ndo Kristu? ");
INSERT INTO poy_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kumbiti Kristu pakaweriti kankwiza, kwahera muntu yoseri yakavimaniti kuwera Kristu hakalawili koshi, kumbiti tuvimana kuwera muntu ayu kwakalawira!” ");
INSERT INTO poy_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu pakaweriti kankufunda Mnumba nkulu ya Mlungu, yomberi katakuliti kwa liziwu, “Mumana neni na muvimana kwanawa? Niza ndiri kwa uwezu wangu mweni. Ulii yakantumiti ndo mwaminika nentu, mwenga mumana ndiri, ");
INSERT INTO poy_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kumbiti neni numumana, toziya ndawa kwakuwi, ndo mweni yakantumiti.” ");
INSERT INTO poy_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Womberi wafiliti kumkamula Yesu, kumbiti kwahera muntu yakaweza kumbata yomberi toziya saa yakuwi yankali kusoka. ");
INSERT INTO poy_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wantu wavuwa mulipinga wamjimiriti na walonga, “Kristu pakiza hakatendi mauzauza nentu kuliku aga gakatenditi muntu ayu?” ");
INSERT INTO poy_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafalisayu wapikiniriti wantu pawapwepa visoweru avi kuusu Yesu. Su womberi pamuhera na watambika wakulu wa Numba ya Mlungu wawatumiti wanjagila wambati Yesu. ");
INSERT INTO poy_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu katakula, “Nankali namwenga kwa shipindi shididini, su hanumugenderi ulii yakantumiti. ");
INSERT INTO poy_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hamunsakuli kumbiti hapeni mumoni, toziya hapeni mwizi pahala palii panwera.” ");
INSERT INTO poy_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wakulu wa Shiyawudi walitakuziana weni, “Muntu ayu hakagendi koshi ndo peni hapeni tumpati? Hakagendi kwa lushi zya Wagiriki ndo peni wantu wetu Wayawudi pawalikala na hakawafundi Wagiriki? ");
INSERT INTO poy_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kamanisha shishi pakatakula, ‘Hatumsakuli kumbiti hapeni tumwoni na palii pahala pakawera hapeni tuwezi kusoka?’ ” ");
INSERT INTO poy_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lishaka lya kupelera lya msambu agu liweriti lishaka likulu. Yesu kagolokiti na kutakula kwa liziwu likulu, “Yakayumuluwa, kizi kwaneni, ");
INSERT INTO poy_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","na yoseri yakanjimira neni kalandi. Gambira Malembu Mananagala ntambu yagalembwa, ‘Yakanjimira neni lushemba lwa mashi ga ukomu haganyiririki kulawa mumoyu mwakuwi.’” ");
INSERT INTO poy_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu katakuliti aga kuusu Rohu, ndo mweni yawamjimira yomberi hawamuwanki. Shipindi shilii, Rohu Mnanagala kaweriti kankali kusoka toziya Yesu kaweriti kankali kukwiswa. ");
INSERT INTO poy_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wantu wamu pakati pa lipinga lilii wapikiniriti visoweru avi, watakula, “Nakaka muntu ayu ndo ulii mbuyi gwa Mlungu!” ");
INSERT INTO poy_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wamonga watakula, “Ayu ndo Kristu!” Kumbiti wamonga watakuliti, “Kristu hapeni kizi kulawa ku Galilaya! ");
INSERT INTO poy_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Malembu Mananagala galembwiti hangu kuwera Kristu hakaweri mushiyiwuku sha Mfalumi Dawudi na hakayiwuki ku Betirehemu, lushi lyakalikaliti Dawudi.” ");
INSERT INTO poy_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Su, kulawiriti malekaniru kuusu yomberi pakati palipinga lilii lya wantu. ");
INSERT INTO poy_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Wantu wamu wafiriti kumbata Yesu, kumbuti kwahera yakajeriti kumbata. ");
INSERT INTO poy_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wanjagila pawawuyiti kwa Watambika wakulu na Mafalisayu, womberi wawakosiya, “Iwera hashi mumjega ndiri Yesu?” ");
INSERT INTO poy_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wanjagila wawankula, “Kwahera muntu yakapatiti nakamu kutakula gambira muntu ayu ntambu yakatakuliti!” ");
INSERT INTO poy_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mafalisayu wawakosiya, “Hashi na mwenga wakuzyangani viraa? ");
INSERT INTO poy_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Hashi, muwoniti kala yumu gwa wakulu wa wantu, ama yumu gwa Mafalisayu yakamjimiriti? ");
INSERT INTO poy_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lipinga ali lya wantu livimana ndiri Lilagaliru lya Musa, lipangirwa!” ");
INSERT INTO poy_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Yumu gwa Mafalisayu kaweriti Nikodemu ndo mweni pakwanjira paliya kamgenderiti Yesu. Su, kawagambiriti womberi, ");
INSERT INTO poy_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Lilagaliru lyetu liweza ndiri kumtoza muntu pamberi pa kumpikinira kwanja na kuvimana shakatenda” ");
INSERT INTO poy_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Womberi wamwankula, “Hashi, gwenga viraa gulawira Galilaya? Su kagabetuli Malembu Mananagala, nagwenga haguwoni kuwera Galilaya hapeni kalawiri mbuyi gwa Mlungu!” ");
INSERT INTO poy_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kila muntu kagenditi ukaya. ");
INSERT INTO poy_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu kagenditi kulugongu lwa Mzeituni. ");
INSERT INTO poy_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Shirawu yakuwi mandawira putiputi kagenditi kayi Kunumba nkulu ya Mlungu. Wantu woseri wamgendera, nayomberi kalivaga kanja kankufunda. ");
INSERT INTO poy_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wafunda gwa malagaliru na Mafalisayu wamjegera mdala yumu yawambatiti ugoni pakahumba. Wamgolusiya pakati pawu. ");
INSERT INTO poy_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Wamkosia, “mfunda! Mdala ayu yawambatiti ugoni kaweriti kankuhumba. ");
INSERT INTO poy_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Malagaliru ga Musa katulagalira mdala handa ayu wamgumi mabuhi. Su, gwenga gutakula hashi?” ");
INSERT INTO poy_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Watakuliti hangu kwa kumjera Yesu, wapati shanzu sha kumsitaki. Yesu kasuntama, kalemba mlitapaka kwa shyala. ");
INSERT INTO poy_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pawawongiriti kumkosiya, Yesu kagolokiti, kawagambira “Muntu yakeniweri na vidoda pakati penu kiwi gwa kwanja kumguma libuwi.” ");
INSERT INTO poy_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Shakapanu kasuntamala kayi, kaweriti kankulemba mlitapaka. ");
INSERT INTO poy_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pawapikaniriti avi, wanja kuwuka yumuyumu, pawalongolera wazewi. Yesu kasigala gweka yakuwi na mdala ulii kagoloka palaa palii. ");
INSERT INTO poy_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu kaligolosiya kamkosiyiti mdala ayu, “Wakoshi wantu walii? Hashi kwahera hata yumu yakakutoziti?” ");
INSERT INTO poy_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Kwahera hata yumu!” Mtuwa, kamwankula. Yesu kamgambira, “Iherepa, wala neni nukutozi ndiri. Gugendi zyaku na kwanjira vinu hapeni gutendi vidoda kayi.” ");
INSERT INTO poy_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu pakayowiriti kayi na Mafalisayu, kawagambira, “Neni ndo Uweru wa pasi panu, yakanizira neni hapeni kagendigendi muntiti nakamu, su hakaweri na Uweru wa ukomu.” ");
INSERT INTO poy_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Su, Mafalisayu wamgambira, “Gwenga gulilanguziya gamweni, hangu upitawu waku ufaa ndiri.” ");
INSERT INTO poy_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu kawankula, “Hangu ndiri, ata handa nulilanguziya namweni, upitawu wa neni ndo wa nakaka toziya neni nuvimana kwandawiti na kwang'enda. Kumbiti mwenga muvimana ndiri kwandawiti wala kwang'enda. ");
INSERT INTO poy_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mwenga muntoza kwa maholu ga wantu, kumbiti neni ntoza ndiri muntu. ");
INSERT INTO poy_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ata pantoza, kutoza kwaneni ndo kwa nakaka toziya neni nagweka yangu ndiri Tati yakantumiti neni ndo kapamuhera na neni. ");
INSERT INTO poy_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ilembitwi Mumalagaliru genu kwa upitawu wa wantu wawili, shintu shoseri shatutakuliti ndo nakaka. ");
INSERT INTO poy_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Neni nankulilanguziya namweni na Tati yakantumiti, kankunanguziya neni viraa.” ");
INSERT INTO poy_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wamkosiya, “Tati gwaku ka koshi?” Yesu kawankula, “Mwenga mumana ndiri neni wala mummana ndiri Tati. Handa memumaniti neni, memumaniti Tati gwangu viraa.” ");
INSERT INTO poy_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu katakuliti visoweru vyoseri avi kaweriti kankufunda Mnumba nkulu ya Mlungu pakwegera na lisanduku lya luhanja palitulitwi, Kwahera muntu yakambatiti, toziya saa yakuwi iweriti hayenisoki. ");
INSERT INTO poy_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu kawagambira kayi, “Hang'endi zyangu, mwenga hamnsakuli, kumbiti hamhowi muvidoda vyenu. Kwang'enda neni, mwenga hapeni mwezi kusoka.” ");
INSERT INTO poy_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Su, Watuwa Washiyawudi watakula, “Hashi, ina mana hakalilagi mweni? Mbona katakula, Kwang'enda neni mwenga hapeni msoki?” ");
INSERT INTO poy_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu kawagambira, “Mwenga mlawa palaa pasipanu, neni ndawa kumpindi, mwenga ndo mwa wa pasipanu, neni hapeni weri gwa pasipanu. ");
INSERT INTO poy_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ayi ndo mana nuwagambireni hamhowi muvidoda vyenu. Na hamhowi muvidoda vyenu handa pamjimira ndiri ‘Neni ndo mweni’.” ");
INSERT INTO poy_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nawomberi wamkosiya, “Gwenga gwa gaa?” Yesu kawankula, “Neni ndo handa vilii nuwagambireni kwanjira mwanzu! ");
INSERT INTO poy_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nana gavuwa ga kutakula kwa mwenga na vya kuwatoza. Kumbiti uliya yakantumiti ndo nakaka, naneni nuwagambira wantu wa pasipanu shitwatira shampikiniriti kulawa kwakuwi.” ");
INSERT INTO poy_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wavimana ndiri handa Yesu kaweriti pakatakula nawomberi kumhusu Tati. ");
INSERT INTO poy_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Su, Yesu kawagambira, “pammalira kala kumubikula Mwana gwa Muntu, panu ndo pamfira kumana handa ‘Neni Ndo mweni’, na handa ndenda ndiri shoseri namweni neni, ira ntakula hera galii Tati gakafunditi. ");
INSERT INTO poy_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yakantumiti kapamuhera naneni, yomberi kandeka ndiri gweka yangu, kwani mashaka goseri ntenditi galii yagamfiriziya.” ");
INSERT INTO poy_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wantu wavuwa wampikiniriti Yesu vyakatakuliti wamjimiriti. ");
INSERT INTO poy_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu kawagambira Wayawudi walii yawamjimiriti, “Handa pamgajimila mafundu gangu hamuweri wafundwa wangu nakaka, ");
INSERT INTO poy_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","hamuumani unakaka na unakaka hawuwapanani ulekeziwu.” ");
INSERT INTO poy_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nawomberi wamwankula, “Twenga ndo walelwa wa Aburahamu, na hatwenipati ng'o kuwera wamanda wa muntu yoseri. Gwana mana gaa kutakula, ‘Hamuweri walekiziwa?’ ” ");
INSERT INTO poy_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu kawankula, “Nakaka nuwagambireni, kila muntu yakatenda vidoda ndo mmanda gwa vidoda. ");
INSERT INTO poy_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mmanda hapeni kalikali ukaya kwa mtuwa gwakuwi pamashaka goseri, kumbiti mwana kalikala ukaya mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mwana pakawapanana ulekeziwu, hamuweri walekiziwa nakaka. ");
INSERT INTO poy_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nuvimana handa mwenga ndo walelwa wa Aburahamu. Ata hangu, mfira kundaga kwa toziya hamjimili ndiri mafundu gangu. ");
INSERT INTO poy_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Neni ntakula galii yakananguziyiti Tati, kumbiti mwenga mtenda galii yakawagambireni Tati gwenu.” ");
INSERT INTO poy_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Womberi wamwankula, “Twenga ndo twawana gwa Aburahamu!” Yesu kawagambira, “Handa mwenga mwawana wa Aburahamu, memulitendi lihengu lyakatenditi Aburahamu, ");
INSERT INTO poy_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","vyoseri avi vyantenditi nuwagambireni unakaka mpikaniriti kulawa kwa Mlungu, ata hangu, mwenga mfira kundaga. Aburahamu katenda hangu ndiri! ");
INSERT INTO poy_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mwenga mtenda shitwatira shiraa shilii shakatenditi Tati gwenu.” Womberi wamgambira, “Mlungu mweni ndo Tati gwetu, twenga twawana ndiri wa kunja.” ");
INSERT INTO poy_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu kawagambira, handa Mlungu kangaweriti Tati gwenu, munganfiriti neni, toziya neni ndawiti kwa Mlungu na vinu napanu. Niza ndiri kwa uwezu wangu namweni, ira yomberi kantumiti. ");
INSERT INTO poy_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hashi mwerewa ndiri gantakula aga? Ayi ndo toziya mweza ndiri kuwupikanira ujumbi waneni. ");
INSERT INTO poy_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mwenga ndo mwawana wa tati gwenu, Shetani na mufira hera kutenda lumatamata lwa Tati gwenu. Yomberi kaweriti mlaga kwanjira mwanzu, kahera msimamu gwa nakaka, tembera nakaka kwahera mngati mwakuwi. Kila mpayu, zitakulwa kulawirirana na ntambu yakuwi ya munshimba, yomberi ndo mpayu na tati gwa mpayu. ");
INSERT INTO poy_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kumbiti neni nukugambirani nakaka, toziya ayi hashi munjimira ndiri neni. ");
INSERT INTO poy_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Gani pakati penu yakaweza kulanguziya weri neni nana vidoda? Handa panuwagambira nakaka, kwa shishi munjimira ndiri? ");
INSERT INTO poy_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yakalawa kwa Mlungu kapikaniraga visoweru vya Mlungu. Mwenga, mlawa ndiri kwa Mlungu, na ayi ndo toziya ya mwenga kupikinira ndiri. ");
INSERT INTO poy_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wayawudi wamkosiya Yesu, “Hashi, hapeni tutakuli nakaka handa gwenga ndo Msamariya na kayi gwana shamshera?” ");
INSERT INTO poy_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu kankula, “Neni nahera shamshera, neni numgohilili Tati gwangu, kumbiti mwenga mgohalira ndiri. ");
INSERT INTO poy_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Neni nsakula ndiri ligoya lyangu namweni, kumbiti kwana yumu mweni kankusakula ligoya ali, nayomberi ndo mtoza. ");
INSERT INTO poy_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nakaka nuwagambireni, yakagakola mafundu gangu hapeni kahowi mashaka goseri!” ");
INSERT INTO poy_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Su, Wayawudi wamgambira, “Vinu tuvimana nakaka handa gwenga gwana washamshera! Aburahamu kahowiti na wambuyi wa Mlungu viraa wahowiti, nagwenga gutakula eti, ‘Yakajimira ujumbi waku hakalikali mashaka goseri!’ ");
INSERT INTO poy_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tati gwetu Aburahamu kahowa, hashi gulitenda gwamkulu kuliku tati gwetu Aburahamu, ndo gwenga? Ata wambuyi wa Mlungu wahowiti. Hashi gwenga gulitenda gwa gaa?” ");
INSERT INTO poy_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu kawankula, “Panilikwisa namweni, uweru wangu shintu ndiri. Yumu yakankwisa ndo Tati gwangu, kila muntu katakula Mlungu gwetu. ");
INSERT INTO poy_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mwenga hapeni mpati kummana, kumbiti neni nummana. Na, pantankula nummana ndiri, hanuwi mpayu gambira mwenga. Kumbiti neni nummana na njimira shisoweru shakuwi. ");
INSERT INTO poy_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tati gwetu Aburahamu, kanemeleriti pakaliwoni lishaka lyangu na yomberi kaliwoniti, kanemelera.” ");
INSERT INTO poy_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Su, Wayawudi wamgambira, “Gwenga gwankali kusoka vinja lilongu muhanu, nagwenga gumwona Aburahamu?” ");
INSERT INTO poy_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu kawagambira, “Nakaka nuwagambirani, pamberi Aburahamu kangali kwiwuka, ndo Neni.” ");
INSERT INTO poy_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Panu wasola mabuwi wamgumangi yomberi, kumbiti Yesu kalififa, kalawa Mnumba nkulu ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu pakaweriti kankupita, kamwoniti muntu yumu kana lwisi kwanjira kwiwuka. ");
INSERT INTO poy_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wafundwa wakuwi wamkosiya, “mfunda! Hashi, gaa ndo yakatenda vidoda vyavimtenda muntu ayu kayiwuki pakawera lwisi? Hashi, vidoda vyakuwi mweni ama vidoda vya walera wakuwi?” ");
INSERT INTO poy_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu kankula, “Shitwatila ashi shilawira ndiri toziya ya vidoda vyakuwi yomberi, ama vidoda vya walelwa wakuwi, ira kiwuka lwisi su makakala ga Mlungu gawonikani gatenda lihengu mwakuwi. ");
INSERT INTO poy_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kuweri kwankali paliwala tufiruwa kwendeleya kutenda lihengu lya uliya yakantumiti, mana pashiru peni pakwiza muntu hapeni kawezi kutenda lihengu. ");
INSERT INTO poy_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Shipindi nankali pasipanu, neni ndo gulangala gwa pasi panu.” ");
INSERT INTO poy_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pakatakuliti kala aga, katema mata pasi, kalitenda linkandiga, kamswagaziya mumasu ulii yakawera na lwisi, ");
INSERT INTO poy_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","kamgambira, “Gugendi na gukalifyankuli palitanda lya Silowamu.” Mana ya litawu ali ndo “Yawamtumiti”. Muntu kana lwisi uliya kagenda na kulifyankula kulitanda lya Siloam, shakapanu kawuya pakawera kankuwona. ");
INSERT INTO poy_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Su, wapakwegera wakuwi na walii yawaweriti wavimana handa kaweriti muhushu mluwa, walonga, “Hashi, ayu ndiri uliya muhushu yakaweriti pakalivaga na kuluwa luwa?” ");
INSERT INTO poy_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wamonga pawatakula, “Ndomweni.” Wantu wamu watakula, “ndala! Ira kalifana nayomberi.” Uliya yakaweriti lwisi katakula, “Ndo neni!” ");
INSERT INTO poy_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wamkosiya, “Vinu, masu gakuwi gapata hashi kutumula?” ");
INSERT INTO poy_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nayomberi kawankula, “Muntu uliya yawamshema Yesu katenditi linkandiga, kaswagaziya mumasu na kung'ambira, ‘Gugendi gwakalifyankuli palitanda lya Silowamu,’ su neni ng'enda, nulifyankula sheni shangu, mpata kwona.” ");
INSERT INTO poy_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wamkosia, “Yomberi ka koshi?” Nayomberi kawankula, “Neni nuvimana ndiri!” ");
INSERT INTO poy_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Shakapanu wamjega muntu uliya yakaweriti kana lwisi kwa Mafalisayu. ");
INSERT INTO poy_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Lishaka ali Yesu pakatenditi linkandiga na kumtumuziya masu muntu ayu, iweriti Lishaka lya kwoyera. ");
INSERT INTO poy_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mafalisayu wamkosiya kayi muntu ayu, “Gupata hashi kwona?” Nayomberi kawagambira, “Kantyeremeka linkandiga mumasu, naneni nulifyankula sheni shangu, vinu weza kwona.” ");
INSERT INTO poy_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mafalisayu wamu walonga, “Muntu kantenditi hangu hapeni kalawi kwa Mlungu, toziya kajimira ndiri malagaliru ga Lishaka lya kwoyera.” Kumbiti wamonga walonga, “Muntu kana vidoda kaweza hashi kutenda liuzauza lya ntambu ayi?” Kuwera na malekaniru pakati pawu. ");
INSERT INTO poy_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mafalisayu wamkosiya kayi muntu ayu, “Yomberi kagagubutula masu, gutakula shishi kwa yomberi?” Muntu uliya kawagambira, “Yomberi ndo mbuyi gwa Mlungu!” ");
INSERT INTO poy_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Wakulu wa Shiyawudi wajimira ndiri handa muntu ayu kaweriti lwisi na vinu kankuwona mpaka pawawashemiti walera wakuwi ");
INSERT INTO poy_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","na wawakosiya walera awa, “Hashi, ayu mwana gwenu ndo mwenga mlonga kiwukiti lwisi? Hashi vinu kapata kwona?” ");
INSERT INTO poy_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Walera wakuwi wankula, “Tuvimana handa ayu ndo mwana gwetu na kiwukiti lwisi. ");
INSERT INTO poy_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kumbiti kapata hashi kwona, hapeni tuvimani na wala tuvimana ndiri uliya yakamtumuziyiti masu. Mumkosiyi mweni, yomberi ndo muntu mkulu, kaweza kulitakulira mweni.” ");
INSERT INTO poy_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Walera wakuwi walongiti hangu toziya wawatiriti wakolamlima wa Shiyawudi, kwani wakolamlima awa waweriti waliragilirana handa muntu yoseri yakamini handa Yesu ndo Kristu kalivagi kunja kwa numba ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Walelwa wakuwi walongiti, “Yomberi ndo muntu mkulu, Mumkosiyi.” ");
INSERT INTO poy_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Su, wamshema kayi muntu ulii yakiwukiti lwisi na wamgambira, “Gumpanani ukwisa Mlungu! Twenga tuvimana kuwera muntu ayu ndo kana vidoda.” ");
INSERT INTO poy_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yomberi kankula, “Handa ndo nana vidoda neni nuvimana ndiri. Kumbiti shintu shimu nushimana, neriti na lwisi na vinu mona.” ");
INSERT INTO poy_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wamkosiya, “Kakutenderiti shishi? Hashi kakutumuliziya masu gaku?” ");
INSERT INTO poy_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Muntu ayu kawankula, “Nuwagambireni mbera kala, namwenga mpikanira ndiri, mfira shishi kupikinira kayi? Hashi mwenga viraa mfira muweri wafundwa wakuwi?” ");
INSERT INTO poy_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kumbiti womberi wamwigira pawatakula, “Gwenga ndo mfundwa gwakuwi, twenga wafundwa wa Musa. ");
INSERT INTO poy_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Twega tuvimana handa Mlungu katakuliti na Musa, kumbiti muntu ayu tumumana ndiri kalawira koshi!” ");
INSERT INTO poy_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Muntu ulii kawankula, “Ashi ndo shitwatira sha kulikangasha! Mwenga muvimana ndiri kalawira koshi, kumbiti kantumuliziya masu gangu! ");
INSERT INTO poy_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tuvimana handa Mlungu hapeni kawapikiniri wantu wana vidoda, ira kumpikinira yoseri yakamjimira na kutenda vyakafiriti. ");
INSERT INTO poy_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kwanjira lupaga pasipanu ipikanirika ndiri handa muntu kagatumuziya masu ga muntu yakayiwukiti lwisi. ");
INSERT INTO poy_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Payiwera ndiri muntu ayu kalawa kwa Mlungu, mekaweziti ndiri kutenda shintu shoseri!” ");
INSERT INTO poy_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Womberi wamwankula, “Gwenga gwiwuka na kulelwa pavidoda, na hashi guweza kutufunda twenga?” Wamwinga kulawa Mnumba ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu kapikiniriti yagalawiliti, kamwoniti muntu uliya kamkosiya, “Hashi, gwenga gumjimira Mwana gwa Muntu?” ");
INSERT INTO poy_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Muntu ayu kankula, “Mtuwa, gung'ambiri yomberi ndo gaa, su mpati kumjimira!” ");
INSERT INTO poy_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu kamgambira, “Gumwona kala na yomberi ndo yakatakula nagwenga vinu.” ");
INSERT INTO poy_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Muntu ayu katakula, “Nukujimira, Mtuwa!” Na kamsuntamilira Yesu. ");
INSERT INTO poy_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu katakula, “Neni niza pasipanu kutoza wantu, wanalwisi wapati kuwona na woseri yawalola waweri lwisi.” ");
INSERT INTO poy_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mafalisayu wamu waweriti pamuhera na yomberi wampikinira pakatakuriti aga na wamkosiya, “Gumaanisha natwenga twanalwisi viraa?” ");
INSERT INTO poy_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu kawankula, “Mwangaweriti mwana lwisi, mwangaweriti ndiri na vidoda, kumbiti mwenga vinu mtakula, twenga tuwona, ayi ilanguziya kuwera mwana vidoda.” ");
INSERT INTO poy_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Yesu kawagambira, yoseri yakingira ndiri mulizizi lya kondolu kwa kupitira mlyangu, ira mulupenu na kwingira kwa njira yimonga, ayu ndo mwivi na mkwepula. ");
INSERT INTO poy_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Muntu yakingira kwa kupitira pamulyangu, ayu ndo mweni mlolera gwa kondolu. ");
INSERT INTO poy_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mlolera mlyangu kamvugulira yomberi, kondolu wapikinira liziwu lyakuwi, nayomberi kawashema kondolu wakuwi kila yumu litawu lyakuwi na kuwalonguziya kunja. ");
INSERT INTO poy_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pakawalavia kunja kawalongulera palongolu, nawomberi kondolu wamfata, kwani walimana liziwu lyakuwi. ");
INSERT INTO poy_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kondolu awa hapeni wawezi kumfata muntu gwingi, ira watuga toziya walimana ndiri liziwu lyakuwi.” ");
INSERT INTO poy_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu kawagambiriti mfanu agu, kumbiti womberi wavimana ndiri shakafiriti kuwagambira. ");
INSERT INTO poy_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Su, Yesu katakula kayi, “Nakaka nuwagambireni, neni ndo mlyangu gwa kondolu. ");
INSERT INTO poy_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wamonga woseri walii wiziti pamberi pa neni ndo wivi na wakwepula, kumbiti kondolu wawapikinira ndiri. ");
INSERT INTO poy_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Neni ndo mlyangu. Yakingira kupitira neni hakalopoziwi, hakingiri na kulawa na hakapati maliziwu. ");
INSERT INTO poy_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mwivi kizaga su kiwi na kalagi na kahalabisiyi. Neni niza mpati kuwera na ukomu, ukomu ukamilika. ");
INSERT INTO poy_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Neni ndo mlolera muheri. Mlolera muheri kalaviyaga ukomu wakuwi kwa kondolu wakuwi. ");
INSERT INTO poy_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Muntu gwa shibenamgongu, yomberi mlolera ndiri na wala kondolu wakuwi ndiri, pakamuwona liminyi kankwiza, kaleka kondolu na kutuga, liminyi kawabata wakondolu na kuwapalasiyanga. ");
INSERT INTO poy_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Muntu gwa shibenamgongu katuga toziya yomberi gwa shibenamgongu hera, hapeni kawaloleri wakondolu. ");
INSERT INTO poy_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Neni ndo mlolera muheri. Nuwamana wakondolu wangu nawomberi wamana neni, ");
INSERT INTO poy_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","gambira Tati ntambu yakamana neni, naneni ntambu yanummana Tati. Neni ndaviya ukomu wangu kwajili ya womberi. ");
INSERT INTO poy_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nana wakondolu wamonga yawaweriti ndiri mulizizi ali. Inazimu kuwajega viraa, womberi hawalipikiniri liziwu lya neni, na hakuweri shipinga shimu na mlolera yumu. ");
INSERT INTO poy_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tati kanfira neni toziya ndaviya ukomu wangu, su mpati kuwuwanka kayi. ");
INSERT INTO poy_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kwahera muntu yakampoka ukomu wangu, neni nuwulaviya mweni. Nana uwezu wa kuwulaviya na kuwutola kayi. Hangu ndo Tati kandagaliriti ntendi.” ");
INSERT INTO poy_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kuwera kayi na malekaniru pakati pa Wayawudi toziya ya visoweru avi. ");
INSERT INTO poy_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wantu wavuwa watakuliti, “Kana shamshera, kayi kanalukwali! Gwa shishi kumpikinira?” ");
INSERT INTO poy_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wamonga walonga, “Shisoweru ashi sha muntu kana shamshera ndiri. Hashi, shamshera kaweza ashi kuponiziya muntu kana lwisi?” ");
INSERT INTO poy_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Aku Yerusalemu kuweriti na msambu gwa kumlavilira Mlungu Numba nkulu ya Mlungu, shipindi ashi shiweriti sha mpepu. ");
INSERT INTO poy_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu kaweriti kankugendagenda Mnumba nkulu ya Mlungu pahala wapashemiti Mdamu gwa Selemani. ");
INSERT INTO poy_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Su, Wayawudi wamzyengeta Yesu, wamkosiya, “Hagutuleki pota na nakaka mpaka ndii? Gutugambiri nakaka pota kufifa, Hashi, gwenga ndo Kristu?” ");
INSERT INTO poy_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu kawankula, “Nuwagambireni kala, kumbiti mnjimira ndiri. Lihengu lyantenda neni kwa uwezu wa Tati gwangu wakuntakuziya. ");
INSERT INTO poy_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kumbiti mwenga mnjimira ndiri toziya mwenga mwa kondolu wa neni ndiri. ");
INSERT INTO poy_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Wakondolu wangu wapikinira liziwu lyangu, neni nuwamana, nawomberi wanfati. ");
INSERT INTO poy_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Neni nuwayupa ukomu wa mashaka goseri, nawomberi hapeni wahowi. Kwahera muntu yakaweza kuwawusiya mmawoku mwangu ");
INSERT INTO poy_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tati gwangu ndo mweni yakanupiti hawa nayomberi ndo mkulu kuliku woseri. Kwahera yakaweza kuwawusiya mmawoku mwakuwi. ");
INSERT INTO poy_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Neni na Tati, twayumu.” ");
INSERT INTO poy_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Su, Wayawudi watola mabuwi wamgumi. ");
INSERT INTO poy_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu kawagambira, “Nuwalanguziyeni mahengu gavuwa kulawa kwa Tati. Nuwatendera shishi shamfira kung'uma na mabuwi?” ");
INSERT INTO poy_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wayawudi wamwankula, “Hapeni tukugumi kwajili ya matendu maheri, kumbiti kwa kumwigilanga Mlungu! Gwenga ndo muntu hera kumbiti mweni gwenga gulitenda kuwera Mlungu.” ");
INSERT INTO poy_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu kawankula, “Walembiti Mumalagaliru genu, Neni nonga, ‘mwenga ndo milungu?’ ");
INSERT INTO poy_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mlungu kawashemiti milungu walii wawapanana ujumbi wakuwi, natwenga tuvimana handa Malembu Mananagala gatakula nakaka mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kumbiti neni, Tati ndo kansyaguliti na kantumiti pasipanu. Iwera ashi mung'ambira neni nigilanga toziya ntakuliti ‘Neni Namwana gwa Mlungu?’ ");
INSERT INTO poy_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Namunjimira neni, pamwona ntenda ndiri vitwatira vya Tati gwangu. ");
INSERT INTO poy_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kumbiti pantenda vitwatira avi, ata pamunjimira ndiri neni, muvijimiri ata vitwatira vyantenda, su mpati kuvimana nakaka kulonga Tati ka mngati mwangu na neni namngati mwa Tati.” ");
INSERT INTO poy_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wajeriti kayi kumbata Yesu kumbiti kawukiti pakati pawu. ");
INSERT INTO poy_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu kagenda kayi kumwambu ku lushemba Yoridani, pahala Yohani pakaweriti kankubatiza, kalikaliti aku. ");
INSERT INTO poy_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Wantu wavuwa wamgenderiti pawalonga, “Yohani katenda ndiri liuzauza lyoseri, ira goseri Yohani gakatakuliti kuusu muntu ayu ndo nakaka.” ");
INSERT INTO poy_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na wantu wavuwa pahala palii wamjimira. ");
INSERT INTO poy_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Muntu yumu yawamshema Lazaru, kalikaliti Betaniya, kaweriti mlweri. Betaniya lushi lwawalikaliti Mariya na Marita muhasha gwakuwi. ");
INSERT INTO poy_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariya ndo uliya yakamswagiti uturi Mtuwa na kumpukuta kwa viri zyakuwi. Ayu ndo Lazaru kaka gwakuwi yakaweriti mlweri. ");
INSERT INTO poy_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Wahasha watuma ujumbi kwa Yesu, “Mtuwa, ganja gwaku yagumfira, mlweri!” ");
INSERT INTO poy_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu pakapikaniriti aga, katakula, “Ulweri awu hapeni hujegi kuhowa kwa Lazaru, ira ndo kwajili ya kumkwisa Mlungu na kwa mana ayi Mwana gwa Mlungu kakwiswi.” ");
INSERT INTO poy_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu kamfiriti Marita na muhasha gwakuwi pamuhera na Lazaru. ");
INSERT INTO poy_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pakapatiti shisoweru handa Lazaru mlweri, kulikala pahala panu kwa mashaka mawili nentu. ");
INSERT INTO poy_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Shakapanu kawagambira wafundwa wakuwi, “Tuwuyi kayi Yudeya!” ");
INSERT INTO poy_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wafundwa wamgambira, “Mfunda! Shipindi shifupi hera shipita Wayawudi wafira kukuguma mabuwi, na gwenga gufira kugenda kayi aku?” ");
INSERT INTO poy_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu kankula, “Lishaka lyana saa lilongu na mawili ndiri, ndo hangu? Pakagendagenda paliwala hapeni kawezi kulikwala, kawona kulangala kwa pasipanu. ");
INSERT INTO poy_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kumbiti muntu pakagendagenda pashiru katalikwala, Toziya kulangala kwahera.” ");
INSERT INTO poy_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu katakuliti hangu na pakamaliriti, kawagambira, “Ganja gwetu Lazaru kagonja, kumbiti neni nankugenda na kumyumusiya.” ");
INSERT INTO poy_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wafundwa wakuwi wamgambira, “Mtuwa, handa yomberi kagonja su hakaponiziwi.” ");
INSERT INTO poy_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kumbiti Yesu kaweriti kankutakula kuusu kuhowa kwakuwi, womberi waliholiti kuwera kankutakula kuusu kugonja mbota. ");
INSERT INTO poy_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yesu kawagambira pota kufifa, “Lazaru kahowa, ");
INSERT INTO poy_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","kumbiti nemelera kwa ajili ya mwenga handa mweri ndiri aku, su mpati kujimira. Haya tugendeni kwakuwi.” ");
INSERT INTO poy_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi yawamshema mawira kawagambira wantumini wamonga, “Tugendeni woseri pamuhera na mfunda tukahowi!” ");
INSERT INTO poy_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu pakafikiti aku, kamwoniti Lazaru wamtula kala mlipumba kwa mashaka msheshi. ");
INSERT INTO poy_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Shijiji sha Betaniya shiweriti pakwegera na Yerusalemu utali wa kilumita ntatu, ");
INSERT INTO poy_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","na Wayawudi wavuwa wiziti kumlola Marita na Mariya kuwapanani ushiwa kwa kuhowa kaka gwawu. ");
INSERT INTO poy_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Shipindi Marita pakapikaniriti handa Yesu kaweriti kamkwiza, kagenda kumwanka, kumbiti Mariya kasigaliti ukaya. ");
INSERT INTO poy_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marita kamgambira Yesu, “Mtuwa handa gwangaweriti panu, kaka gwangu mekahowiti ndiri! ");
INSERT INTO poy_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kumbiti nuvimana handa ata vinu shoseri shagufira kumluwa Mlungu, hakakupi.” ");
INSERT INTO poy_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu kamgambira, “Kaka gwaku hakawuyi mkomu kayi.” ");
INSERT INTO poy_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marita kamwankula, “Nuvimana handa hawazyuki shipindi sha uzyukisiwu, mulishaka lya kupelera.” ");
INSERT INTO poy_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu kamgambira, “Neni ndo uzyukisiya na ukomu. Yakanjimira neni ata tembera hakahowi, hakalikali. ");
INSERT INTO poy_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na kila yakalikala na kunjimira, hapeni kahowi. Hashi, gujimira aga?” ");
INSERT INTO poy_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marita kamwankula, “Yina, Mtuwa! Neni njimira handa gwenga ndo Kristu, Mwana gwa Mlungu, uliya yakiza pasipanu.” ");
INSERT INTO poy_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marita pakatakuliti aga, kagenditi na kumshema Mariya mlongu gwakuwi, kamgambira pagweka, “mfunda kapanu na kafira kukuwona.” ");
INSERT INTO poy_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nayomberi pakapikaniriti aga, kamukamu kagoloka, kamgendera Yesu. ");
INSERT INTO poy_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu kaweriti keniyingiri mushijiji, kumbiti kaweriti palaa palii Marita pakamwankiti. ");
INSERT INTO poy_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Su, Wayawudi yawaweriti ukaya pamuhera na Mariya pawamnyamaziya muushiwa, pawamwoniti kagoloka na kulawa kunja vumu, wamwiziriti. Wavimaniti kaweriti kankugenda mulipumba kudaya. ");
INSERT INTO poy_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariya pakasokiti pahala palii Yesu pakaweriti na kumwona, kasuntamala, kamgambira, “Mtuwa, handa gwangaweriti panu, kaka gwangu kangahowiti ndiri!” ");
INSERT INTO poy_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu pakamwoniti kankulira na Wayawudi walii wawiziti pamuhera nayomberi wankulira viraa, kamemiti na maholu na kuhinginika mumoyu. ");
INSERT INTO poy_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Shakapanu kawakosiya, “Lipumba lya koshi?” Wamgambira, “Mtuwa, gwizi na gulori.” ");
INSERT INTO poy_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu kalira. ");
INSERT INTO poy_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Su, Wayawudi watakula, “Mlori ntambu yakamfiriti!” ");
INSERT INTO poy_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kumbiti wamonga wawu watakula, “Hashi, ayu yakamtenditi katumuli masu lwisi uliya, kaweza ndiri kumtenda Lazaru nakahowi?” ");
INSERT INTO poy_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Su, Yesu kahinginika kayi mmoyu, kiziti mlipumba. Lipumba lyeni liweriti mpanga na liweriti ludiwirwa kwa libuwi. ");
INSERT INTO poy_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu kalagaliriti, “Mliwusiyi libuwi ali!” Marita mlongu gwakuwi ayu yakahowiti kamgambira, “Mtuwa kanja kala kununka, kalikala mulipumba mashaka msheshi!” ");
INSERT INTO poy_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu kamgambira, “Hashi, nukugambira ndiri handa pagujimira haguwoni ukwisa wa Mlungu?” ");
INSERT INTO poy_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Su waliwusiya libuwi lilii, Yesu kalola kumpindi, katakula, “Mayagashii Tati toziya gwenga gumpikanira. ");
INSERT INTO poy_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nuvimana handa gumpikanira neni. Kumbiti ntakula aga toziya ya wantu awa wapala panu su wapati kujimira handa gwenga ndo yaguntumiti.” ");
INSERT INTO poy_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pakamaliriti kutakula aga, kashema kwa liziwu likulu, “Lazaru! Gulawi kunja!” ");
INSERT INTO poy_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Uliya yakaweriti kahowa kalawiti kunja, aku wamyopa sanda mmagulu na mmawoku na sheni shakuwi shigubikirwa. Yesu kawagambira, “Mumyopoli, mkamleki kagendi zyakuwi.” ");
INSERT INTO poy_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Su, Wayawudi wavuwa waweriti wamtyangira Mariya pawawoniti Yesu shintu gaa shakatenditi, na kumjimira. ");
INSERT INTO poy_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kumbiti wamonga wawu wagenditi kwa Mafalisayu na wawagambira shitwatira ashi shakatenditi Yesu. ");
INSERT INTO poy_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mafalisayu na watambika wakulu waliwoniti Mwashizungu na watakula, “Tutendi shishi? Muntu ayu kankutenda mauzauza nentu. ");
INSERT INTO poy_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Patumleka hera wantu woseri hawamjimiri, womberi Warumi hawizi kuwalibisiya Numba nkulu ya Mlungu gwetu na isi yetu!” ");
INSERT INTO poy_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Panu yumu gwawu, yawamchema Kayafa, ndo kiwiti mtambika mkulu wa shinja ashi, kawagambira, “Mwenga muvimana ndiri shintu! ");
INSERT INTO poy_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Hashi, mwona ndiri handa ndo mbaka kwamwenga muntu yumu kahowi kwa ajili ya wantu, kuliku isi yoseri ipalanganyika?” ");
INSERT INTO poy_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yomberi katakula ndiri hangu ntambu yakafiriti mweni, ira kaweriti mtambika mkulu shinja ashi su katungiti handa Yesu hakahowi toziya ya wantu wa Isi ya Shiyawudi, ");
INSERT INTO poy_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","na toziya ndiri gweka yawu hera, kumbiti kapati kuwajega pamuhera munshimba yimu yaipalanganyikiti kwa wantu wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Su, kwanjira lishaka ali watuwa wa Shiyawudi watenda mipangu gwa kumlaga Yesu. ");
INSERT INTO poy_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Su, Yesu hapeni kagendigendi kayi paweru muisi ya Wayawudi, kumbiti kawukiti panu kagenditi pahala pagwekera na kushiwala, mlushi lwa walushema Efrayimu. Kalikaliti aku pamuhera na wafundwa wakuwi. ");
INSERT INTO poy_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Shipindi sha msambu sha Wayawudi sha Pasaka shiweriti pakwegera na wantu wavuwa walawa muisi wagenditi Yerusalemu su walipungi pa msambu agu. ");
INSERT INTO poy_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Su, waweriti wankumsakula Yesu. Na womberi pawaliwoniti Mnumba nkulu ya Mlungu, walikosiyana, “Mulihola hashi? Nakaka hakizi ndiri ku msambu agu, awu ndiri?” ");
INSERT INTO poy_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Watambika wakulu na Mafalisayu walagalira kuwera, handa muntu yoseri pakavimaniti pahala pakaweriti Yesu, kalazimika kutakula su wapati kumbata. ");
INSERT INTO poy_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pamberi pa mashaka sita ga msambu gwa Pasaka, Yesu kafikiti Betaniya pakaya pa Lazaru, muntu yakamzyusiyiti kulawa kwawahowiti. ");
INSERT INTO poy_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Aku wamtuliriti shiboga sha pamihi na Marita kaweriti kamtendera. Lazaru kaweriti yumu gwa walii wawaweriti wankuliya pamuhera na Yesu. ");
INSERT INTO poy_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mariya katoliti supa ya uturi yawayishema naridu iherepa ya mpiya zivuwa, kamswaga Yesu mumagulu na kugapukuta kwa viri zyakuwi numba yoseri inunkira uturi. ");
INSERT INTO poy_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yumu gwa wafundwa wa Yesu, Yuda Isikariyoti yakafiriti kumgalambuka Yesu, katakula, ");
INSERT INTO poy_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Uturi awu waweza kuwuza kwa mpiya zya shibena mgongu sha myezi tisa na mpiya azi wawayupi wahushu?” ");
INSERT INTO poy_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Katakuliti hangu, kwakuwawonera ndiri wahushu lusungu, toziya kaweriti mwivi na yomberi ndo yakakoliti muhaku gwa mpiya na kavitoliti vyawatuliti amu. ");
INSERT INTO poy_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu katakula, “Mumleki mdala ayu! Kavituriti vyoseri vyakaweriti navi kwa lishaka lya kusilwa kwa neni. ");
INSERT INTO poy_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wahushu mwanawu mashaka goseri, kumbiti hamuweri ndiri na neni mashaka goseri.” ");
INSERT INTO poy_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wayawudi wavuwa wapikiniriti handa Yesu Kabetaniya. Su womberi wagenditi aku, wapati kumwona Yesu, kayi wafiriti kumwona Lazaru ulii yakamzyusiyiti na Yesu kulawa kwa wahowiti. ");
INSERT INTO poy_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Watambika wakulu wasakuliti ntambu ya kumlaga Lazaru, ");
INSERT INTO poy_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","toziya Wayawudi wavuwa wawalemiti wayawu na wamjimira Yesu. ");
INSERT INTO poy_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Shirawu yakuwi, lipinga likulu lya wantu wiziti kumsambu wapikiniriti Yesu kaweriti mnjira kwiza Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Watola maputira ga mitendi, walawa kugenda kumwanka, wabota pawatakula, “Gwenga mlopoziya gwetu! Katekelerwi ayu yakiza mulitawu lya Mtuwa. Katekelerwi Mfalumi gwa Israeli.” ");
INSERT INTO poy_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu kakwena mwana punda, kalivaga pampindi pakuwi gambira ntambu yagatakuliti Malembu, ");
INSERT INTO poy_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kotu kutira gwe lushi lwa Sayuni, Mfalumi gwaku kamkwiza, Kalivaga pampindi pa mwana punda.” ");
INSERT INTO poy_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Shipindi ashi wafundwa wakuwi wavimaniti ndiri shitwatira ashi shoseri, kumbiti Yesu pawamkwiswiti kala, womberi wagaholiti Malembu Mananagala gatakuliti kuusu yomberi na wagatenditi aga kwa yomberi. ");
INSERT INTO poy_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lipinga lya wantu walii wawaweriti pamuhera nayomberi shipindi pakamshemiti Lazaru kulawa mlipumba, kamzyusiya kulawa kwawahowiti, watakuliti yagalawiriti. ");
INSERT INTO poy_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Toziya ya aga, lipinga likulu lya wantu awa wamgenderiti Yesu, mana woseri wapikiniriti handa Yesu katenditi liuzauza ali. ");
INSERT INTO poy_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mafalisayu waligambiziyana, “Mwona? Hapeni tuwezi kutenda shoseri! Mlori, wantu wa pasipanu woseri wankumfata.” ");
INSERT INTO poy_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kuweriti na Wagiriki wamu mu wantu yawaweriti wiza Yerusalemu kumkwisa Mlungu mushipindi sha msambu. ");
INSERT INTO poy_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Womberi wamgenderiti Filipu, yakalawiriti Betisayida mu Galilaya na watakula, “Mtuwa, tufira kumwona Yesu.” ");
INSERT INTO poy_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipu kagenda na kamgambira Andereya na wawili wagenda na kumgambira Yesu. ");
INSERT INTO poy_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu kawawankula, Saa isoka kala kwa Mwana gwa Muntu kukwiswa! ");
INSERT INTO poy_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nukugambirani nakaka, mbunji ya nganu isigala mbunji hera payiyalwa ndiri mulitapaka na kuwola. Handa payiwola, su ilera mbeyu zivuwa. ");
INSERT INTO poy_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Woseri yawafira ukomu wawu hawawuhoviyi, yakagahoviya makaliru gakuwi pasipanu, hakagaponiziyi kwa makaliru ga mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yakafira kuntendera ndo mpaka kanfati, pawera neni na ntumintumi gwangu hakaweri, kayi muntu pakantendera Tati hakampanani ligoya. ");
INSERT INTO poy_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Vinu rohu yaneni intama, ntakuli shishi? Ntakuli, ‘Tati, gunopoziyi shipindi ashi pashisoka?’ Kumbiti ayi ndo toziya ya kwiza. Su shimpiti shipindi ashi sha ntabiku. ");
INSERT INTO poy_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tati, Kakwiswi litawu lyakuwi.” Panu liziwu litakula kulawa kumpindi kwa Mlungu. “Nulikwisa na hanulikwisi kayi.” ");
INSERT INTO poy_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lipinga lya wantu lyaligolokiti palii lipikaniriti liziwu ali na wamu wawu watakuliti, “Ntumintumi gwa kumpindi kankuyowera nayomberi!” ");
INSERT INTO poy_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kumbiti Yesu kawagambira, “Liziwu ali lirandula ndiri kwajili yaneni, ira kwajili ya mwenga. ");
INSERT INTO poy_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vinu ndo shipindi sha pasipanu kutozwa, vinu mtuwa gwa pasipanu hawamwusiyi. ");
INSERT INTO poy_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Neni panu panyasulwa kumpindi kwa Mlungu hanumkwezeniziyi kila muntu.” ");
INSERT INTO poy_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kakutakula hangu kalanguziya ntambu gaa hakahowi. ");
INSERT INTO poy_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Lipinga ali limwankula. Twenga watugambira Malagaliru getu handa Kristu hakalikali mashaka goseri. Su, guweza hashi kutakula eti mwana gwa Muntu imbidi kanyasulwi? Mwana gwa Muntu ndo gaa? ");
INSERT INTO poy_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu kawagambira, “Gulangala haguweri pakati penu katepu hera. Mgendi toziya mnawu gulangala agu, ntiti hapeni iwapati, toziya yakagendagenda muntiti kavimana ndiri kwakagenda. ");
INSERT INTO poy_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Shipindi shamuwera na gulangala agu, mugujimiri, su mpati kuwera wantu wa gulangala.” Pakalongiti kala visoweru avi, Yesu kagenditi zakuwi na kulififa kutali na womberi. ");
INSERT INTO poy_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tembera Yesu katenditi mauzauza goseri aga palongolu pawu, womberi wamjimira ndiri. ");
INSERT INTO poy_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Su visoweru vyakatakuliti Isaya mbuyi gwa Mlungu vitimiya. “Mtuwa, gaa yakajimiriti ujumbi watutakuliti? Na uwezu wa Mtuwa ulilanguziya kwa gaa?” ");
INSERT INTO poy_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Na hangu womberi waweza ndiri kujimira, toziya Isaya katakula viraa, ");
INSERT INTO poy_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Mlungu kagatula lwisi masu gawu Na kagazezetiya mahala gawu, Wawoni ndiri kwa masu gawu, Wavimani ndiri kwa mahala gawu, Na wanizira ndiri neni, Mlungu katakula, Su mpati kuwaponiziya.” ");
INSERT INTO poy_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya katakuriti visoweru avi toziya kawoniti ukwisa wa Yesu, pakatakula visoweru vyakuwi. ");
INSERT INTO poy_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ata hangu, kuvuwa kwa watuwa wa wakulu wa Shiyawudi wamjimiriti Yesu. Kumbiti toziya ya mafalisayu, wamjimiriti ndiri paweru kwa kutira handa wawatuli gweka mnumba ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Wafiriti kuzyumwa na wantu kuliku kuzyumwa na Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Shakapanu Yesu katakula kwa liziwu likulu, “Muntu yakanjimira, kanjimira ndiri neni hera, ira kamjimira viraa uliya yakantumiti. ");
INSERT INTO poy_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yakamona neni kankumwona viraa ulii yakantumiti. ");
INSERT INTO poy_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Neni na Gulangala, niza pasipanu su woseri wawanjimira waweri ndiri muntiti. ");
INSERT INTO poy_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yakapikanira shisoweru shangu uganu kagakola ndiri, neni hapeni numtozi, hanumtozi ndiri. Niza ndiri kuwatoza wantu wa pasipanu ira kuwalopoziya. ");
INSERT INTO poy_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Woseri yawanema neni na kuujimira ndiri ujumbi waneni, kwana yumu yakiza kuwatoza. Visoweru vyantakula haviweri vyakuwatoza mulishaka lya kupelera. ");
INSERT INTO poy_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ayi ndo nakaka, toziya neni ntakula ndiri kwa uwezu wangu namweni, kumbiti Tati yakantumiti ndomweni yakantumiti ntakuli shishi na nyoweri shishi. ");
INSERT INTO poy_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Naneni nuvimana weri lilagaliru lyakuwi lijega ukomu wa mashaka goseri. Su, neni ntakula hera galii Tati yakanagaliriti nugatakuli.” ");
INSERT INTO poy_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Iweriti lishaka lya pamberi pa msambu gwa Pasaka. Yesu kavimaniti handa saa yakuwi isoka ya kuwuka pasipanu na kugenda kwa Tati. Shipindi shoseri yomberi kawafiriti nentu wantu wa pasipanu yawaweriti wakuwi, na kawafiriti mpaka lupeleru! ");
INSERT INTO poy_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu pamuhera na wantumini wakuwi waweriti walivaga kuliya shiboga sha pamihi. Shetani kingiriti kala mumoyu mwa Yuda, mwana gwa Simoni Isikariyoti, maholu ga kumgalambuka Yesu. ");
INSERT INTO poy_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu kavimaniti handa Tati kaweriti kamupa makakala, kavimaniti kuwera kalawa kwa Mlungu na kaweriti kankugenda kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Su, kawukiti pameza, kayikusa nguwu yakuwi, katola shitambala na kulitawa mushyunu mwakuwi. ");
INSERT INTO poy_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Shakapanu katula mashi mubakuli, kanja kuwagulula magulu wafundwa wakuwi kugapukuta kwa shitambala shilii shakashitawiti mushinu mwakuwi. ");
INSERT INTO poy_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pakiziti kwa Simoni Peteru, nayomberi katakula, “Mtuwa, hashi gwenga gwiza kugagulula magulu ganeni?” ");
INSERT INTO poy_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu kamwankula, “Gwenga hapeni gwerewi vinu shantenda ashi, kumbiti hagwelewi shakapanu.” ");
INSERT INTO poy_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peteru kamgambira, “Gwenga hapeni gungululi magulu gangu nakamu!” Yesu kamwankula, “Pangulula ndiri magulu gaku, hapeni guweri ntumintumi gwangu kayi.” ");
INSERT INTO poy_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Peteru kamwankula, “Mtuwa, nagungululi magulu hera! Gugagululi mawoku gangu na mtuwi viraa.” ");
INSERT INTO poy_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu kamgambira, “Yawakoga kala wawera waherepa na wafiruwa ndiri kunawa ira magulu gawu. Mwenga muherepa, kumbiti mwawoseri ndiri.” ");
INSERT INTO poy_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu kamumaniti kala ulii yakagenda kumgalambuka, ndo mana kalongiti, “Mwenga muherepa, kumbiti yumu kaherepa ndiri.” ");
INSERT INTO poy_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pakamaliriti kuwagulula magulu gawu, kavulumula nguwu yakuwi, na kalivagiti pahala pakuwi pakwegera na meza, su yomberi kawakosiya, “Hashi, mwerewa shanuwatenderani mwenga?” ");
INSERT INTO poy_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Mwenga munshema mfunda na Mtuwa, mwenga mtakula weri toziya ndo neni. ");
INSERT INTO poy_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Paiwera neni Mtuwa gwenu na mfunda gwenu, nuwanaviya magulu mwenga, mwenga viraa mfiruwa kulinawiviyana magulu. ");
INSERT INTO poy_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nukupanani kala mfanu, su mwenga mtendi viraa ntambu yanuwatenderani. ");
INSERT INTO poy_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nuwagambirani nakaka, wantumintumi wakulu ndiri kuliku mtuwa gwawu na ntumintumi hapeni kaweri mkulu kuliku ulii yakantumiti. ");
INSERT INTO poy_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Vinu muumana unakaka awu, hamuweri na sekuseku pamgatenda. ");
INSERT INTO poy_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Aga gantakula gawawusu ndiri mwenga mawoseri. Neni nuwamana walii yanuwasyaguliti. Kumbiti mpaka gatimii Malembu Mananagala gaweri nakaka ntambu yagalembwa, ‘Muntu yakaliyiti pamuhera naneni shiboga shangu hakang'alambuki’. ");
INSERT INTO poy_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Neni nuwagambireni vitwatira avi vinu pamberi kulawira. Su pagalawila mpati kujimira kuwera ‘Neni ndo Mweni’. ");
INSERT INTO poy_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nuwagambireni nakaka, yakamshemera yoseri ulii yanumtumiti, kanshemera neni viraa na yakanshemera neni ndo kamshemera ulii yakantumiti.” ");
INSERT INTO poy_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu pakatakuliti kala aga, kahinginikiti nentu mumoyu, katakula pota kufifa, “Nakaka nuwagambireni, yumu gwenu hakamgalambuki!” ");
INSERT INTO poy_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Wafundwa walilola weni, su waweriti wavimana ndiri handa gaa hakamgalambuki. ");
INSERT INTO poy_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yumu gwa wafundwa, mweni Yesu ndo yakamfiriti nentu, kaweriti kalivaga pakwegera na Yesu. ");
INSERT INTO poy_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Peteru kamlanguziya kwa mawoku, kamgambira “Gumkosiyi katakula kuusu gaa.” ");
INSERT INTO poy_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Su ntumintumi ulii kasegelera nentu uwega wa Yesu, kamkosiya, “Mtuwa, ndo gaa?” ");
INSERT INTO poy_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu kamwankula, “Ulii yanumupa shipandi sha libumunda shantotiti musahani, ndo mweni.” Su, kashitola shipandi sha libumunda, kashitota musahani, kamupa Yuda, mwana gwa Simoni Isikariyoti. ");
INSERT INTO poy_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda pakayankiti kala shipandi sha libumunda, Shetani kamwingiriti yomberi. Su, Yesu kamgambiriti Yuda, “Gutendi kanongola shilii shagufira kutenda!” ");
INSERT INTO poy_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Woseri yawalivagiti kuliya shiboga wavimaniti ndiri kwantambu gaa Yesu katakuriti aga kwa yomberi. ");
INSERT INTO poy_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yuda kaweriti mkola mpiya pakati pawu, wavimaniti kuwera Yesu kamgambiriti hakahemeri vilii vyawafiruwa mumsambu, ama kamgambiriti kakalaviyi shoseri kwa wahushu. ");
INSERT INTO poy_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Su Yuda pakayankiti kala shipandi shilii sha libumunda, palaa paliya kalawa kunja. Na iweriti Pashiru. ");
INSERT INTO poy_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda pakawukiti kala, Yesu kalonga, “Vinu ukwisa wa Mwana gwa Muntu ugubutulwa, vinu ukwisa wa Mlungu ugubutulwa kupitira yomberi. ");
INSERT INTO poy_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Handa ukwisa wa Mlungu paugubutulwa kupitira yomberi, su Mlungu hakaulanguziyi ukwisa wa Mwana gwa Muntu mngati mwakuwi, kamukamu hakatendi hangu. ");
INSERT INTO poy_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wana wangu, nankali na mwenga katepu hera. Hamunsakuli, kumbiti vinu nukugambirani galii ganuwagambiriti kala wakulu wa Wayawudi, ‘Pang'endaku, mwenga hapeni mgendi.’ ");
INSERT INTO poy_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Vinu nukupanani lilagaliru lya syayi, mulifiri weni. Handa yanukufirani mwenga, viraa vilii mulifiri weni. ");
INSERT INTO poy_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Handa pamulifira weni, wantu woseri hawavimani kuwera mwenga ndo wafundwa waneni”. ");
INSERT INTO poy_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Peteru kamkosiya Yesu, “Mtuwa gwankugenda koshi?” Yesu kamwankula, “Hapeni guwezi kunfata vinu kwang'endaku, kumbiti shakapanu hamunfati.” ");
INSERT INTO poy_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peteru kamkosiya, “Mtuwa, kwantambu gaa nsindi kukufata vinu? Nakali kuhowa kwajili ya gwenga!” ");
INSERT INTO poy_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu kamwankula, “Hashi, ndo wakala nakaka kuhowa kwajili ya neni? Nukugambira nakaka, pamberi njogolu keniwiki, hagunemi mala tatu kuwera gumana ndiri neni.” ");
INSERT INTO poy_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu kawagambira, “Namuligaziya mumyoyu mwenu. Mumjimiri Mlungu na munjimiri neni viraa. ");
INSERT INTO poy_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ukaya mwa Tati gwangu kwana mbakati zivuwa, nuwagambiriti kala na vinu nankugenda kuwanyawirani pahali penu. ");
INSERT INTO poy_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na pang'enda na kuwanyawilireni pahala penu, hambuyi na kuwatola, su mwenga hamuweri pamuhera naneni. ");
INSERT INTO poy_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Muyimana njira ya kugenda aku kwang'enda.” ");
INSERT INTO poy_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi kamkosiya, “Mtuwa, tuvimana ndiri kwagugenda, su twankuyimana hashi njira ayi?” ");
INSERT INTO poy_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu kamwankula, “Neni ndo njira na unakaka na ukomu. Kwahera yakaweza kugenda kwa Tati ira kwa kupitira kwaneni. ");
INSERT INTO poy_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kawagambira, vinu mumana neni, mumana na Tati gwangu viraa. Na kwanjira vinu mumana na mumwona kala.” ");
INSERT INTO poy_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipu kamgambira, “Mtuwa, tumlanguziyi Tati, natwenga hatwikuti.” ");
INSERT INTO poy_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu kamwankula, “Filipu, nulikala namwenga kwa shipindi shoseri, nagwenga gumana ndiri? Yakamoniti kala neni kamwona Tati. Guweza hashi kutakula, Tumlanguziyi Tati? ");
INSERT INTO poy_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Hashi, mjimira ndiri handa neni namngati mwa Tati, nayomberi Tati ka mngati mwaneni? Visoweru nyanuwagambirani ntakula ndiri kwa utuwa waneni, Tati yakawera mngati mwaneni kankutenda lihengu lyakuwi. ");
INSERT INTO poy_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Munjimiri neni pantakula handa neni namngati mwa Tati naTati ka mngati mwaneni. Handa hangu ndiri, mjimiri toziya ya vintu vyantenda. ");
INSERT INTO poy_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nakaka nuwagambirani, yakanjimira neni hakatendi vitwatira vyantenda neni, yina, hakatendi vintu vikulu nentu, toziya nankugenda kwa Tati. ");
INSERT INTO poy_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na shoseri shamluwa mulitawu lyaneni hantendi, su Tati kakwiswi mnumba ya mwana. ");
INSERT INTO poy_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pamunduwa shoseri mulitawu lyangu, hanuwatendereni. ");
INSERT INTO poy_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Pamunfira neni, hamulijimili lilagaliru lyaneni. ");
INSERT INTO poy_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Naneni hanumluwi Tati nayomberi hakawapanani mtanga yumonga, hakalikali namwenga kwa mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yomberi ndo Rohu yakalanguziya unakaka kuusu Mlungu. Wantu wa pasipanu waweza ndiri kumuwanka toziya waweza ndiri kumwona wala kummana. Kumbiti mwenga mumana toziya kalikala namwenga na ka mngati mwenu. ");
INSERT INTO poy_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Pang'enda hanuwaleki ndiri mwawashiwa, hanizi kayi kwamwenga. ");
INSERT INTO poy_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Katepu hera wantu wa pasipanu hawamoni kayi ndiri, kumbiti mwenga hamumoni. Toziya nana ukomu, viraa mwenga hamuweri na ukomu. ");
INSERT INTO poy_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lishaka lilii palisokiti hamuvimani handa neni na mngati mwa Tati, naneni mngati mwamwenga. ");
INSERT INTO poy_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Yakagayanka malagaliru ganeni na kugajimira, ndoweni walii yawanfira neni. Tati gwangu hakawafiri woseri yawanfira neni, naneni vulaa hanuwafiri womberi na hanulilanguziyi kwawomberi.” ");
INSERT INTO poy_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda, Yuda Isikariyoti ndiri, kamgambira, “Mtuwa, hashi iwezekana gwenga kulilanguziya kwatwenga na gulilanguziya ndiri kwa wantu wa pasipanu?” ");
INSERT INTO poy_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu kamwankula, “Muntu pakanfira neni hakagajimili mafundu gangu na Tati gwangu hakamfiri, neni pamuhera na Tati gwangu hatwizi kulikala nayomberi. ");
INSERT INTO poy_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yakanfira ndiri hapeni kagajimili mafundu gangu. Na mafundu gampikaniriti gangu ndiri, galawa kwa Tati yakantumiti. ");
INSERT INTO poy_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nuwagambiriti vitwatira avi pamweriti nakali na mwenga. ");
INSERT INTO poy_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kumbiti mtanga, Rohu Mnanagala, ndomweni Tati hakamtumi mulitawu lyaneni, hakawafundeni kila shintu na kuwakumbusiyani goseri ganuwagambirani. ");
INSERT INTO poy_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nuwalekera ponga, nuwapanani ponga yangu. Nuwapanani ndiri mwenga gambira wantu wa pasipanu ntambu yawatenda. Namuwera na lyoga ama namuhinginyika. ");
INSERT INTO poy_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mpikaniriti kala panuwagambira, Nankugenda zyangu, shakapanu hambuyi kayi kwamwenga. Handa munganfiriti, munganemeli toziya nankugenda kwa Tati, yomberi ndo mkulu nentu kuliku neni. ");
INSERT INTO poy_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nuwagambireni aga vinu pamberi ganalawira, su pagalawila mpati kujimira. ");
INSERT INTO poy_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ntakula ndiri namwenga kayi vitwatira avi vivuwa, mana mtuwa gwa pasipanu kankwiza. Hapeni kawezi shintu kwaneni, ");
INSERT INTO poy_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kumbiti wantu wa pasi panu mpaka wavimani handa numufira Tati, ndo mana ntenda kila shintu gambira Tati ntambu yakanamuwiti. “Mgoloki, tuwuki panu!” ");
INSERT INTO poy_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Neni ndo mzabibu gwa nakaka, Tati gwangu ndo mkulima. ");
INSERT INTO poy_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yomberi kawusiyaga kila lutambi lwalulera ndiri mabwajubwaju mnumba mwangu na kila lutambi lwalulera nulugulula lupati kulera nentu. ");
INSERT INTO poy_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mwenga muwera kala muherepa toziya ya mafundu ganuwafunditi. ");
INSERT INTO poy_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mwikali mngati mwangu, naneni nulikali mngati mwenu. Lutambi hapeni luleri mabwajubwaju gweka yakuwi, haluleri paluwera mumtera gwa zabibu. Ntambu iraayi hapeni mleri mabwajubwaju mpaka muweri mngati mwangu.” ");
INSERT INTO poy_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Neni namzyabibu, mwenga ndo mitambi. Woseri yawawera mngati mwangu, naneni mngati mwawu, hawaleli mabwajubwaju gavuwa, pamuhera ndiri naneni hapeni mtendi shintu shoseri. ");
INSERT INTO poy_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Muntu yoseri pakalikala ndiri mngati mwangu kaswa kunja gambira lutambi lawalwasa kunja mpaka linyali, mitambi yeni ijojinirwa na kwasirwa pamotu, yeni ndo ilunguziwa. ");
INSERT INTO poy_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pamulikala mngati mwaneni na visoweru vyaneni paviwera mngati mwenu, hamluwi shoseri shamfira na hampati. ");
INSERT INTO poy_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ukwisa wa Tati gwangu hawuwoneki pamulera mabwajubwaju na kwa njira ayi hamuweri wafundwa waneni. ");
INSERT INTO poy_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nukufireni mwenga gambira Tati ntambu yakanfira neni, mulikali muwundama wa neni. ");
INSERT INTO poy_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Handa pamjimila malagaliru gangu, hamulikali mu muwundama waneni, gambira neni ntambu yanjimiriti malagaliru ga Tati gwangu na nulikali muwufiru wakuwi. ");
INSERT INTO poy_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nukugambirani vitwatira avi su nemeleru yangu iweri mngati mwenu na nemeleru ya mwenga ikamiliki. ");
INSERT INTO poy_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lilagaliru lyangu ndo ali, mulifiri weni, ntambu yanuwafira mwenga. ");
INSERT INTO poy_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mafiliru makulu nentu kwa muntu kuulanguziya kwa waganja wakuwi ndo kuulaviya ukomu wakuwi kwa womberi. ");
INSERT INTO poy_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mwenga ndo waganja waneni handa pamtenda shilii shanuwalagaliriti. ");
INSERT INTO poy_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mwenga hapeni nuwashemi kayi wamanda, toziya wamanda hapeni wavimani vyawatenda watuwa wawu. Kumbiti nuwashema mwenga waganja, toziya nuwagambiriti vitwatira vyoseri vyanpikaniriti kwa Tati gwangu. ");
INSERT INTO poy_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mwenga munsyagula ndiri neni, kumbiti neni ndo yanuwasyaguliti mwenga na kuwatuma mgendi mwakaleri mabwajubwaju nentu, mabwajubwaju yagalikala. Su Tati hakakupanani shoseri shamluwa mu litawu lyangu. ");
INSERT INTO poy_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Su, lilagaliru lyangu kwa mwenga ndo ali, mulifiri weni kwa weni. ");
INSERT INTO poy_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Handa wantu wa pasipanu pawakukalalirani, mliholi kuwera wankalalira neni kwanja pamberi pa kuwakalalira mwenga. ");
INSERT INTO poy_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Handa memuweriti wamu wa wantu wa pasipanu, wantu wa pasipanu wangawafiriti gambira wantu wawu weni. Kumbiti nuwasyagula mwenga kulawa pasipanu, toziya wantu wa pasipanu wawakalalira mwenga. ");
INSERT INTO poy_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Muliholi shilii shanuwagambiriti, ‘Wamanda hapeni waweri wakulu kuliku watuwa wawu.’ Handa wantu pawamberiti neni, hawawaberi mwenga viraa, handa wagajimiriti mafundu ganeni, hawagajimili mafundu genu viraa. ");
INSERT INTO poy_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kumbiti womberi hawatendi vyoseri avi kwa mwenga toziya mwenga waneni, kwani wamumana ndiri ulii yakantumiti. ");
INSERT INTO poy_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Handa nganiziti ndiri na kutakula na womberi wangaweriti ndiri na vidoda, kumbiti vinu hapeni wawezi kutakula wahera vidoda. ");
INSERT INTO poy_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yakankalalira neni, kamkalalira Tati gwangu viraa. ");
INSERT INTO poy_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Handa nangantenda ndiri kwawomberi vitwatira vyeni kwahera muntu yumonga yakavitenditi kala mwangaweriti ndiri na vidoda, kumbiti vinu waviwoniti vyantenditi wankalalira neni pamuhera na Tati gwangu. ");
INSERT INTO poy_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ndo toziya galii gagalembitwi mu Malagaliru gawu ganakaka, ‘Wankalalira hera!’ ");
INSERT INTO poy_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Mtanga yakiza ndo Rohu, hakagubutuli unakaka kuusu Mlungu, ndo mweni kiza kulawa kwa Tati. Hanumtumi kwa mwenga kulawa kwa Tati na hakatakuli kuusu neni. ");
INSERT INTO poy_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mwenga viraa, hamtakuli kuusu neni, toziya muweriti pamuhera na neni kwanjira kwanja.” ");
INSERT INTO poy_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nuwagambiriti aga, su namleka moyu gwenu. ");
INSERT INTO poy_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wantu hawawawingi mwenga kulawa Mnumba zya Mlungu zyenu na shipindi hashizi yoseri pakakulageni hakavimani kamtendera Mlungu lihengu. ");
INSERT INTO poy_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wantu hawawatenderani vitwatira avi toziya womberi wamumana ndiri Tati ama neni. ");
INSERT INTO poy_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kumbiti nukugambirani aga, su shipindi pashizaku kwa womberi kutenda vitwatira avi, hamuliholi kuwera nuwagambiriti kala. “Nuwagambiriti ndiri vitwatira avi kwanjira kwanja, toziya nweriti pamuhera namwenga. ");
INSERT INTO poy_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Su vinu nankugenda kwa ulii yakantumiti, kwahera ata yumu gwenu yakankosiya neni pang'endaku. ");
INSERT INTO poy_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Vinu nuwagambirani vitwatira avi, myoyu yenu ihinginika. ");
INSERT INTO poy_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kumbiti, nankuwagambirani nakaka, Iherepa kwa mwenga neni ng'endi zangu, toziya pang'enda ndiri, Mtanga hapeni kizi kwa mwenga. Kumbiti pang'enda zyangu, hanumtumi yomberi kizi kwa mwenga. ");
INSERT INTO poy_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nayomberi pakizaku, hakawalunguziyi unakaka wantu wa pasipanu kuwera watenda upyota kuusu vidoda na vintu vyavimfiriziya Mlungu na utoza wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Watenditi upyota kuusu vidoda toziya wanjimira ndiri neni, ");
INSERT INTO poy_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","na kuusu vyavimfiriziya Mlungu, toziya nankugenda kwa Tati, hapeni mumoni kayi, ");
INSERT INTO poy_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","nawomberi wapayira kuusu kutoza, toziya mkolamlima gwa pasipanu katozwa kala. ");
INSERT INTO poy_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nanaga gavuwa gakuwagambireni, kumbiti vinu hapeni muwezi kugahepelera. ");
INSERT INTO poy_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kumbiti pakizaku Rohu ayu, hakagubutuli unakaka kuusu Mlungu, hakawalongoziyi mu unakaka woseri. Hakatakuli ndiri kwa uwezu wakuwi mweni, kumbiti hakatakuli shilii shakapikinira na hakawagambiri vintu vyaviyiza. ");
INSERT INTO poy_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yomberi hakanupi neni ukwisa, toziya hakawagambiri shilii shantakula na shilii shanumgambira kawagambiri. ");
INSERT INTO poy_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Vyoseri vyakawera navi Tati vyaneni, ndo mana nuwagambirani kuwera Rohu Mnanagala hakawapanani vilii vyakapatiti kulawa kwaneni. ");
INSERT INTO poy_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Shakali shipindi shididi hapeni mumoni kayi na shipindi shididi shakapanu hamumoni.” ");
INSERT INTO poy_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wafundwa wakuwi wamu walikosiyana, “Kamaanisha shishi? Katugambira kwa shipindi shididini hapeni tumwoni, kayi shipindi shididini hatumwoni, viraa katakuriti kayi, ‘Toziya nankugenda kwa Tati.’ ");
INSERT INTO poy_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Su, waweriti wankulikosiyana, kamaanisha shishi pakatakula, ‘shakali shipindi shididini?’ Tuvimana ndiri shakayowera!” ");
INSERT INTO poy_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu kavimaniti handa wafiriti kumkosiya, su kawagambira, “Hashi mlikosiyana ntambu yanongiti, ‘Shakali shipindi shididini hapeni mumoni kayi na shipindi shididi shakapanu hamumoni?’ ");
INSERT INTO poy_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nankuwagambirani nakaka, hamulili na kudaya, kumbiti wantu wa pasi panu hawanemeleri, hamuhinginiki, kumbiti kuhinginika kwamwenga hakugalambuki kuwera nemeleru. ");
INSERT INTO poy_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Shipindi mdala pakalera, kawera na hinginika toziya shipindi sha kuwera mundabiri shankwiza, kumbiti mwana pakiwuka, yomberi kalyaluwa, toziya kawera na nemeleru kwiwuka kwa mwana pasipanu. ");
INSERT INTO poy_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mwenga viraa mwanguhinginika vinu vinu, kumbiti hanuwawuyili kayi, mwenga hamuweri na nemeli mumyoyu mwenu na nemeli ayi kwahera muntu yakaweza kuyiwusiya kwamwenga.” ");
INSERT INTO poy_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Lishaka ali lyankwiza, hapeni munuwi shoseri. Nukugambirani nakaka, Tati hakawapanani shoseri shamumluwa kupitira litawu lyaneni. ");
INSERT INTO poy_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mpaka vinu munuwiti ndiri shoseri kwa litawu lyangu. Munduwi shoseri, namwenga hampati su nemeli yamwenga ipera.” ");
INSERT INTO poy_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nuwagambirani vitwatira avi kwa mafumbu. Kumbiti shipindi hashizi hapeni ntumiyi mafumbu kuwagambira, su hantakuli pota kufifa kuusu Tati. ");
INSERT INTO poy_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lishaka ali palizaku, mwenga hamuluwi kwa litawu lyaneni, ");
INSERT INTO poy_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","toziya Tati mweni kawafira mwenga. Yomberi kawafira mwenga toziya munfira neni na kujimira kuwera niziti kulawa kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Niziti kulawa kwa Tati na niziti pasipanu, vinu nankuwuka pasipanu, nankugenda kwa Tati.” ");
INSERT INTO poy_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Su, wafundwa wakuwi wamgambira, “Vinu gwankutakula pota kufifa, gutakula ndiri kwa mafumbu. ");
INSERT INTO poy_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vinu tuvimana kuwera gwenga guvimana kila shintu, gufira ndiri muntu yoseri kakukosiyi. Ayi itutenda tujimiri kuwera gwenga gulawa kwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu kawankula, “Hashi, vinu mjimira? ");
INSERT INTO poy_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Shipindi shankwiza, na shapalaa kala, pawawapalasiya mwoseri mwenga, kila yumu pakawuya ukaya kwakuwi, hamundeki gweka yangu. Kumbiti nagweka yangu ndiri, toziya Tati kapamuhera na neni. ");
INSERT INTO poy_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nuwagambiriti aga, su hamuweri na ponga kwa kuwera pamuhera na neni. Wantu wa pasipanu hawawatendi ntabiki. Kumbiti muweri wagangamala! Neni nuwakanga kala wantu wa pasipanu!” ");
INSERT INTO poy_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu pakamaliriti kutakula aga, kalola kumpindi, kalonga. “Tati, shipindi shisoka! Gumkwisi mwana gwaku su Mwana kapati kukukwisa gwenga. ");
INSERT INTO poy_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gumupiti uwezu kwa wantu woseri, su guwayupi ukomu wa mashaka goseri woseri awa wagunupiti. ");
INSERT INTO poy_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na ukomu wa mashaka goseri ndo awu, kukumana gwenga yaguwera gweka yaku Mlungu gwa nakaka na kumana Yesu Kristu, yagumtumiti. ");
INSERT INTO poy_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Neni nuulanguziya ukwisa waku pasipanu, ntenda kala lihengu lyagunupiti ntendi. ");
INSERT INTO poy_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tati! Gunkwisi pawulongolu paku vinu, ukwisa ulii yatuweriti nawu pamuhera pamberi pa kunyawa pasipanu. ");
INSERT INTO poy_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nukutenda gumanikani kwa wantu walii wagunupiti kulawa pasi panu. Waweriti wantu wakuwi. Na gwenga gunupiti waweri waneni. Womberi washipikanira shisoweru shakuwi, ");
INSERT INTO poy_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","na vinu wavimana handa kila shagunupiti shilawa kwagwenga. ");
INSERT INTO poy_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nuwapanani ujumbi ulii wagunupiti na womberi wawuwanka, wavimana nakaka ndawiti kwagwenga na wajimira handa gwenga guntumiti. ");
INSERT INTO poy_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nuwaluwira awa. Nuwaluwira ndiri wantu woseri wa pasipanu kumbiti nuwaluwira wagunupiti, mana ndo waku. ");
INSERT INTO poy_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Vyoseri vyawera navi ndo vyaku na vyaku ndo vyaneni na ukwisa waneni uwonikana pakati pa wantu wagunupiti. ");
INSERT INTO poy_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na vinu niza kwakuwi, namulamu ndiri kayi pasipanu, kumbiti womberi wamulamu pasipanu. Tati Mnanagala! Kwa likakala lya litawu lyaku lyagunupiti, shondi shondi guwatuli weri su waweri yumu gambira twenga ntambu yatuwera yumu. ");
INSERT INTO poy_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Pamuweriti nawomberi, neni nuwalolera weri kwa likakala lya litawu lyaku lyagunupiti. Neni nuwalolera, kwahera ata yumu gwawu yakagamiriti, kumbiti ulii yumu yakagamiriti, su Malembu Mananagala gapati kutimirika. ");
INSERT INTO poy_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na, vinu niza kwagwenga na ntakula vitwatira avi pasipanu, su waweri na nemeleru ikamilika mumyoyu mwawu. ");
INSERT INTO poy_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nuwayupiti ujumbi waku na wantu wa pasipanu wawakalalira toziya womberi wa pasipanu ndiri, gambira neni gwa pasipanu ndiri. ");
INSERT INTO poy_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nduwa ndiri guwawusiyi pasipanu, kumbiti nduwa guwaloleri na mkondola uliya. ");
INSERT INTO poy_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Womberi wa pasi panu ndiri, handa viraa ntambu yanwera ndiri gwa pasipanu. ");
INSERT INTO poy_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Guwapungi waweri wagwenga munakaka, shisoweru shaku ndo shanakaka. ");
INSERT INTO poy_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ntakula viraa ntambu yaguntumiti pasipanu, naneni viraa nuwatuma womberi pasipanu, ");
INSERT INTO poy_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","na kwajili yawu, namweni neni nulitula kwa gwenga su nawomberi viraa wapungwi muunakaka. ");
INSERT INTO poy_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nuwaluwira awa ndiri hera, kumbiti nuwaluwira viraa woseri yawajimira toziya ya ujumbi awu. ");
INSERT INTO poy_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nduwa su woseri waweri yumu. Tati! Nduwa waweri mngati mwa twenga gambira viraa gwenga ntambu yaguwera mngati mwaneni, naneni mngati mwaku. Nduwa waweri yumu su pasipanu papati kujimira handa gwenga guntumiti. ");
INSERT INTO poy_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Neni nuwapanani ukwisa ulaa uliya wagunupiti neni, su waweri shintu shimu gambira twenga ntambu yatuwera yumu, ");
INSERT INTO poy_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","neni, namngati mwawu nagwenga mngati mwangu, nduwa wakamiliki na waweri yumu, su wantu wa pasipanu wapati kumana gwenga guntumiti na guwafiri womberi ntambu yagunfira neni. ");
INSERT INTO poy_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tati! Nfira awa wagunupiti waweri pamuhera naneni palaa panu, su wawoni ukwisa waneni wagunupiti, toziya gunfiriti neni pamberi pa kunyawa pasipanu. ");
INSERT INTO poy_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tati Muheri! Wantu wa pasipanu wakumana ndiri, kumbiti neni nukumana. Awa wavimana handa gwenga guntumiti. ");
INSERT INTO poy_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nukutenda gumanikani, na haendereyi kutenda hangu, su ufiru yaguwera nawu kwaneni uweri mngati mwawu, naneni hanweri mngati mwawu.” ");
INSERT INTO poy_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu pakamaliliti kuluwa, kagenditi kumwambu kulushemba Kedironi, pamuhera na wafundwa wakuwi. Pahala panu paweriti na shiwunga sha mitera, Yesu kingira amu pamuhera na wafundwa wakuwi. ");
INSERT INTO poy_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda, kamgalambukiti Yesu, pakamaniti pahala panu kwani mala zivuwa Yesu kaliwoniti na wafundwa wakuwi pahala palii. ");
INSERT INTO poy_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yuda katoriti shipinga sha wanjagila kulawa kwa watambika wakulu wa Numba ya Mlungu na Mafalisayu, su kiza nawu mushiwunga womberi waweriti na limbamba lya motu na vimagi. ");
INSERT INTO poy_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu, kavimana goseri gagafira kumpata, kalawira, kawakosiya, “Mwankumsakula gaa?” ");
INSERT INTO poy_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nawomberi wankula, “Yesu gwa Nazareti!” Yesu kawagambira, “Neni ndo mweni.” Yuda yakaweriti kamgalambukiti kagoloka pamuhera nawomberi. ");
INSERT INTO poy_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu pakawagambiriti, “Neni ndo mweni,” Wawuya kumbeli, waguwa pasi. ");
INSERT INTO poy_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu kawakosiya kayi, “Mwankumsakula gaa?” Wamwankula, “Yesu gwa Nazareti!” ");
INSERT INTO poy_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu kawagambira, “Nuwagambireni kala neni ndo mweni. Su, payiwera mwankunsakula neni, muwaleki awa wagendi zyawu.” ");
INSERT INTO poy_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Katakula aga su gapati kutimiya galii ganakaka gagatakulitwi, “Walii yagunupiti Tati, numwasa ndiri ata yumu.” ");
INSERT INTO poy_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Peteru kaweriti na upanga, su, kuwulaviya kalidumura likutu lya kumliwu lya ntumintumi gwa Mtambika Mkulu. Ntumintumi ayu wamshema Malikusi. ");
INSERT INTO poy_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Su, Yesu kamgambira Peteru, “Guwuzii upanga waku mumuhaku. Hashi, gulihola handa nandi ndiri shikombi sha ndabiri shakanupiti Tati gwangu?” ");
INSERT INTO poy_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Shikundi sha wanjagila wa Rumi na Mnjagira mkulu na walolera wa Wayawudi wamkamuliti Yesu, wamtawa, ");
INSERT INTO poy_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","na kumjega kwanja kwa Anasi. Anasi kaweriti mganafu gwa Kayafa ndo mweni kaweriti Mtambika mkulu gwa shinja shilii. ");
INSERT INTO poy_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa ayu ndo ulii yakaweriti kawagambiriti Wayawudi, membaka muntu yumu kahowi kwajili ya wantu wavuwa. ");
INSERT INTO poy_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Peteru pamuhera na mfundwa gwingi wamfatiti Yesu. Toziya mfundwa yumonga ayu kaweriti kamanikana nentu kwa Mtambika Mkulu, hangu kagenda pamuhera na Yesu pakati pamdamu pa Mtambika Mkulu ");
INSERT INTO poy_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peteru pakaweriti kagoloka pamlyangu. Su, mfundwa gwingi yakamanikaniti na Mtambika mkulu kalawiti kunja, katakula na mdala yakaweriti pamlyangu na kumjega Peteru mungati. ");
INSERT INTO poy_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mnjagira mhinja ayu gwapamlyangu kamkosiya Peteru, “Hashi nagwenga viraa yumu gwa wafundwa wa muntu ayu?” Peteru kamgambira, “Ndala, neni ndiri!” ");
INSERT INTO poy_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wantumintumi na wawanjagila waweriti wakoziya motu toziya kuweriti na mpepu, waweriti wanguyotera motu. Peteru kaweriti kagoloka pamuhera nawomberi kakwotera motu. ");
INSERT INTO poy_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mtambika Mkulu kamkosiya Yesu kuusu wafundwa wakuwi na mafundu gakuwi. ");
INSERT INTO poy_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu kamwankula, “Ntakula na kila muntu mashaka goseri pawonikaniti. Kila mala nfunda munumba za Mlungu na Mnumba nkulu ya Mlungu, pahala pawalyonaga Wayawudi woseri na wala ntakula ndiri shoseri kwa kufifa. ");
INSERT INTO poy_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Hashi gunkosiya neni? Guwakosiyi wantu yawampikinira neni. Womberi wavimana vyanuwagambiriti, wavimana shintu shantakuliti.” ");
INSERT INTO poy_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pakamaliliti kutakula aga yumu gwa wanjagila kamkomiti Yesu likofi pakalonga, “Gumwankula ntambu ayi Mtambika Mkulu?” ");
INSERT INTO poy_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu kankula, “Handa ntakula weri ndiri, gumugambiri kila muntu ka panu iweriti hashi, kumbiti handa ntakula weri, iwera hashi gunkoma?” ");
INSERT INTO poy_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Su, Anasi kamjega Yesu kwa Mtambika Mkulu Kayafa pawamtawa. ");
INSERT INTO poy_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simoni Peteru kaweriti panu kanguyotera motu. Su, wamkosiya, “Hashi, nagwenga viraa yumu gwa wafundwa wakuwi muntu ayu?” Yomberi kaberiti na kutakula, “Neni ndiri”. ");
INSERT INTO poy_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yumu gwa wantumintumi wa Mtambika Mkulu, nayomberi kaweriti mlongu gwa ulii yakadumulitwi likutu na Peteru katakula nukuwoniti pamuhera na Yesu mushiwunga sha mitera. ");
INSERT INTO poy_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peteru kamlema kayi, palaa paliya njogolu kawika. ");
INSERT INTO poy_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mandawila putiputi Yesu wamtola kwa Kayafa, wamjega mpaka kwa Liwali, wakulu awa wa Shiyawudi wingira ndiri amu, wafiriti ndiri kuwera wahumba, toziya wafiriti wawezi kuliya shiboga sha Pasaka. ");
INSERT INTO poy_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Su Pilatu kawagendiriti kulaa kunja, kawakosiya, “Muntu ayu katenda vintu gaa vidoda?” ");
INSERT INTO poy_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wamwankuliti, “Handa ayu kangaweriti muntu yakatenda gaherepa twangamjegiti ndiri kwagwenga.” ");
INSERT INTO poy_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatu kawagambira, “Mumutoli maweni muntu ayu, mumutozi kulawirana na malagaliru genu maweni.” Wayawudi wamwankula, “Twenga twahera uwezu wa kumtoza muntu yoseri kahowi.” ");
INSERT INTO poy_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Vilawiriti avi su viweri nakaka visoweru vyakatakuliti Yesu kulanguziya kuhowa na ntambu hakahowi. ");
INSERT INTO poy_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatu kawuya kayi mu liboma na kamshema Yesu, kamkosiya, “Eti, gwenga gwa mfalumi gwa Wayawudi?” ");
INSERT INTO poy_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu kamwankula, “Hashi, gunkosiya hangu gumweni gwenga ama kwana wamonga wakugambira visoweru vyaneni?” ");
INSERT INTO poy_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatu kamwankula, “Hashi, gulihola Namyawudi neni? Wantu waku na watambika wakulu wakujega kwaneni. Gutenda shishi?” ");
INSERT INTO poy_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu katakula, “Utuwa waneni wa pasipanu ndiri, handa Utuwa waneni megaweri wa pasipanu, wantumintumi wa neni mewankomi ndiri, naniza kubatwa na Wayawudi, kumbiti Ufalumi wa neni wa pasipanu ndiri!” ");
INSERT INTO poy_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatu kamkosiya, “Gwenga gwa mtuwa?” Yesu kankula, “Gwenga gutakula neni na mtuwa. Neni nyiwukiti na kwiza pasipanu kwa shintu shimu, gutakula nakaka. Kwa ntambu ayi niza na unakaka. Kila yakawera na unakaka awu hakampikiniri.” ");
INSERT INTO poy_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatu kamkosiya, “Unakaka ndo shintu gaa?” Pilatu kawagendiriti kayi Wayawudi kunja na kawagambira, “Neni mona ndiri shidoda shoseri kwakuwi shakumtozera. ");
INSERT INTO poy_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kumbiti, kwa mwenga kwana shitiba sha neni kumvugulira muntu yumu mushibetubetu shipindi sha Pasaka, mfira numulekeziyani mfalumi gwa Wayawudi?” ");
INSERT INTO poy_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wamwankula pawabota, “Ndala, ayu ndiri, tumfira Baraba!” Baraba yakaweriti mpokaji kwa wantu. ");
INSERT INTO poy_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Su, Pilatu katakuriti Yesu wamtoli, wamsyatangi ntomondu. ");
INSERT INTO poy_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wanjagira wapota lijenjeri lya misontu na wamtula mumutuwi, wamvarisiya na lihabiti lya shifalumi. ");
INSERT INTO poy_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wamwizira na kutakula, “Mwika, Mtuwa gwa Wayawudi!” Wamgendera na kumwakula makofi. ");
INSERT INTO poy_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatu kalawa kayi kunja, kawagambira, “Mlori, numjega kunja kwamwenga, mpati kuvimana handa neni mona ndiri shidoda shoseri kwakuwi.” ");
INSERT INTO poy_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Su, Yesu kalawa kunja pakavala lijenjeri lya misontu na lihabiti lya shifalumi. Pilatu kawagambira, “Mlori! Muntu mweni ndo ayu.” ");
INSERT INTO poy_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Watambika Wakulu na wanjagila pawamwoniti wabota, “Gumpingiki! Gumpingiki!” Pilatu kawagambira, “Su mumutoli maweni mkampingiki, toziya neni mona ndiri vidoda vyoseri kwakuwi.” ");
INSERT INTO poy_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wayawudi wamwankula, “Twenga twanaga malagaliru na kulawirana na malagaliru aga, ndo mpaka kahowi, toziya kalitakuziya mweni ka Mwana gwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatu pakapikaniriti visoweru avi katiriti nentu. ");
INSERT INTO poy_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kingira kayi mngati mwa ikulu, kamkosiya Yesu, “Gulawa koshi gwenga?” Kumbiti Yesu kamwankula ndiri shintu. ");
INSERT INTO poy_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatu kamgambira, “Gutakula ndiri naneni? Guliholi, guvimana ndiri handa nanawu uwezu wa kukuvugulira na uwezu wa kukupingika?” ");
INSERT INTO poy_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu kamwankula, “Meguweri na uwezu woseri kwa neni hera toziya yakakupanani ndo Mlungu. Su muntu yakanjegiti kwa gwenga kana vidoda vikulu nentu.” ");
INSERT INTO poy_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatu pakapikiniriti aga, kaweriti kakusakula ntambu ya kumlekiziya Yesu, kumbiti lipinga lya Wayawudi liwuyiriti kushowangana, “Pagumlekeziya muntu ayu, gwenga gwa ganja ndiri gwakuwi Kaisari Mfalumi mkulu wa Warumi, kila muntu yakalitenda kuwera Mfalumi kamlema Kaisari Mfalumi mkulu wa Warumi!” ");
INSERT INTO poy_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Su, Pilatu pakapikaniriti visoweru avi kamjega Yesu kunja, kalivaga pashiti sha kutoza, pahala wapashema, “Sakafu ya libuwi.” Kwa Shiebraniya, “Gabata.” ");
INSERT INTO poy_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Iweriti ipata saa sita paliwala, lishaka lya kutandira Pasaka. Pilatu kawagambira Wayawudi, “Mlori, mfalumi gwenu!” ");
INSERT INTO poy_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Womberi washowangana, “Gumlagi! Gumlagi! Mulupingika!” Pilatu kawakosiya, “Hashi, numupingiki mfalumi gwenu?” Watambika wakulu wamwankula, “Twenga twahera Mfalumi ira Kaisari Mfalumi mkulu gwa Warumi!” ");
INSERT INTO poy_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Su, panu Pilatu kamlekiziya Yesu mumawoku mwawu su wampingiki. Su, wamtola Yesu. ");
INSERT INTO poy_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nayomberi kalawa kiwiti kalitola lupingika lwakuwi kugenda pahala pawashemapu “Shipalakasa sha Mtuwi.” Kwa Shiebraniya Goligota. ");
INSERT INTO poy_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Wampingika aku na wantu wawili wamonga wawapingika, yumu uwega wakuwi wa kumliwu na mmonga uwega wakuwi wa kumshigi. ");
INSERT INTO poy_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatu kalembiti malembu kagatula pampindi pa lupingika. Iweriti ilembwa hangu, “Yesu gwa Nazareti, Mfalumi gwa Wayawudi.” ");
INSERT INTO poy_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wayawudi wavuwa wagasomiti malembu aga, mana pahala panu pawampingikiti Yesu paweriti pakwegera na lushi. Kayi malembu aga gaweriti galembwa kwa Shiebraniya na Shilatini na Shigiriki. ");
INSERT INTO poy_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Watambika Wakulu wa Shiyawudi wamgambira Pilatu, “Nagulemba, ‘Mfalumi gwa Wayawudi,’ Kumbiti gulembi yomberi katakuliti, Neni ndo Mfalumi gwa Wayawudi.” ");
INSERT INTO poy_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatu kankula, “Ganembiti, nemba!” ");
INSERT INTO poy_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wanjagira pawamaliriti kumpinjika Yesu, wazitoliti nguwu zakuwi, wagawana vifungu msheshi, shifungu shimu kwa kila mjagira. Watoliti viraa na rihabiti lyakuwi, rihabiti ali liweriti rifumwa kwa shipandi shimu hera, pota na mshonu. ");
INSERT INTO poy_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wanjagira awa waligambiziyana, “Hapeni kuyikashula, ira wazigalambuziya simbi ziweri zya gaa?” Shitwatila ashi shitendikiti su gatimiyi Malembu Mananagala yagatakula, “Wagawaniti nguwu womberi kwa womberi, Na nguwu zaneni wazigalambuziya simbi.” Su, ntambu yawatenditi wanjagila walii. ");
INSERT INTO poy_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pakwegera na lupingika lwa Yesu, paweriti wagoloka mawu gwakuwi na mlongu gwa mawu gwakuwi, Mariya Mdala gwa Kileopa na Mariya Magidalena. ");
INSERT INTO poy_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu pakamwoniti mawu gwakuwi na pakwegera nayomberi kagoloka uliya mfundwa yakamfiriti, kamgambira mawu gwakuwi, “Mawu! Gulori, ayu ndo mwanagwaku.” ");
INSERT INTO poy_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Shakapanu kamgambira mfundwa ulii, gulori, “Ayu ndomweni mawu gwaku.” Na kwanjira shipindi shilii mfundwa ayu kamtoliti katami ukaya kwakuwi. ");
INSERT INTO poy_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu kavimaniti handa goseri gaweriti gatimia na su Malembu Mananagala gapati kutimiya, katakula, “Mona kuyumuluwa.” ");
INSERT INTO poy_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Panu paweriti na libakuli limema siki. Su, watota sifongu pakati pa siki ayi, wayitula pampindi pa ufitu wa hisopu wamlandisiya. ");
INSERT INTO poy_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu pakalanditi siki, katakula “Gapera!” Shakapanu kango'ng'onala mtuwi gwakuwi, kahowa. ");
INSERT INTO poy_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Shakapanu Wakulu wa Wayawudi wamkosiya Pilatu wamegi magulu gawu wawapingikiti na kusulusiya nshimba kulawa mlupingika, wakosiyiti hangu toziya iweriti Ijumaa lishaka lya matandiru ga Pasaka na wafiriti ndiri nshimba kusigala mlupingika lishaka lya Kwoyera, paliyanja lishaka lya kwoyera toziya ya lishaka likulu. ");
INSERT INTO poy_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Su, wanjagila wagenditi, wagamega magulu ga uliya gwa kwanja na uliya gwa pili ndomweni kaweriti kapingikwa pamuhera na Yesu. ");
INSERT INTO poy_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kumbiti pawamwiziriti Yesu, wawoniti kuwera kahowiti kala na hangu wammega ndiri magulu. ");
INSERT INTO poy_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kumbiti mjagira yumu kamtobuliti Mluwavu kwa mgoha na palaa paliya mwazi na mashi galawa. ");
INSERT INTO poy_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nayomberi yakawoniti shitwatira ashi kalaviya visoweru vyakuwi su mwenga mpati kujimira. Na aga yagapitawulitwi ndo nakaka, kayi yomberi kavimana handa kankutakula nakaka. ");
INSERT INTO poy_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Shitwatila ashi shashitenditwi su Malembu Mananagala gatimiyi, “Kwahera ata shifupa shakuwi shimu hashimegwi.” ");
INSERT INTO poy_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ilembwa kayi Mumalembu Mananagala gatakula, “Hawamloli uliya yawamtobuliti.” ");
INSERT INTO poy_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pa aga, Yosefu, mwenikaya gwa Arimatayu, kamluwa Pilatu kayitoli nshimba ya Yesu. Yosefu kaweriti mfundwa gwa Yesu, kumbiti kwa kubada, toziya kawatiriti wakulu wa Wayawudi. Su, Pilatu kajimira. Hangu Yosefu kagenditi, kayitola nshimba ya Yesu. ");
INSERT INTO poy_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemu yomberi kaweriti kamgendera Yesu pashiru, wagenditi pamuhera na Yosefu kiza pakajega muhanganyiku gwa manimani na ubani wa kilu milongu mitatu. ");
INSERT INTO poy_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Su, watola nshimba ya Yesu. Waitawa sanda pamuhera na uturi kulinganira na shitiba sha Wayawudi shakusira. ");
INSERT INTO poy_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pahala panu pawampingikiti Yesu paweriti na shiwunga na pakati pashiwunga ashi paweriti na lipumba lyampanga lyaliweriti lyasyayi, wamsira ndiri muntu yoseri mnumba mwakuwi. ");
INSERT INTO poy_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Toziya ya lihengu lya Wayawudi lya matandiru ga Lishaka lya Kwoyera, toziya lipumba lya mpanga ali liweriti pakwegera, wagatula mauti ga Yesu mlaa. ");
INSERT INTO poy_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Naluwunjuwunju jumapili, kuweriti kwangali ntiti, Mariya Magidalena kagenditi kulipumba lya mpanga na kaliwona libuwi lilii liwusiwa pamlyangu gwa lipumba. ");
INSERT INTO poy_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Su kagenda mbiru mpaka kwa Simoni Peteru na ulii mfundwa yumonga ndomweni Yesu kamfiriti, kawagambira, “Wamwusiya Mtuwa Mulipumba lya mpanga na tuvimana ndiri pawamtuliti.” ");
INSERT INTO poy_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peteru na mfundwa yumonga ulii wagenda kulipumba. ");
INSERT INTO poy_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Woseri wawili watugiti, Kumbiti mfundwa yumonga ulii katugiti mbiru kuliku Peteru na kalongolera kusoka kulipumba. ");
INSERT INTO poy_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pakasunguliliti na kawoniti sanda, kumbiti kingira ndiri mlipumba. ");
INSERT INTO poy_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoni Peteru kamfata na kingira mlipumba, amu kayiwona sanda, ");
INSERT INTO poy_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na shitambala shawamtawiti Yesu Mutuwi. Shitambala ashi washitula ndiri pamuhera na sanda ayi, kumbiti shiweriti shibiringiziwa na shitulwa pahali pa gweka hera. ");
INSERT INTO poy_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mfundwa yumonga yakasokiti kulipumba lya mpanga, kingira viraa mulipumba lya mpanga, kawona na kajimira. ");
INSERT INTO poy_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Waweriti wankali kugamana Malembu Mananagala yagatakuliti kuwera mpaka kazyuki. ");
INSERT INTO poy_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Su, wafundwa awa wawuya ukaya. ");
INSERT INTO poy_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariya kaweriti kagoloka kunja ku lipumba lya mpanga, kankulira. Pakiwiti kankali kankulira, kang'ong'onariti na kusungulira mulipumba lya mpanga, ");
INSERT INTO poy_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","na kawawona wantumintumi wa kumpindi wawili yawavaliti nguwu neru mbuu, walivagiti palii nshimba ya Yesu payiweriti yigonjekwa, yumu kumtuwi na mmonga kumagulu. ");
INSERT INTO poy_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wamahoka awa wamkosiya, “Mdala, shagulira shishi?” Yomberi kawagambira, “Wamwusiya Mtuwa gwangu na nukumana ndiri kwawamtuliti!” ");
INSERT INTO poy_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pakatakuliti aga, kagalambuka kumbeli, kamwona Yesu kagoloka paliya, kumbiti kammana ndiri kuwera ndo Yesu. ");
INSERT INTO poy_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu kamkosiya, “Mdala, shagulira shishi?” Gwankumsakula Gani? Mariya, kaliholiti kuwera ayu ndo mlolera shiwunga, kamgambira, “Mtuwa, handa ndo gwenga gumwusiya, gung'ambiri pagumturiti, naneni hang'endi na kumtola.” ");
INSERT INTO poy_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu kamgambira, “Mariya!” Yomberi kagalambuka, kamgambira kwa Shiebraniya, “Raboni” Yani “mfunda.” ");
INSERT INTO poy_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu kamgambira, “Nangunkola, toziya nankali kugenda kumpindi kwa Tati. Kumbiti gugendi kwa walongu wangu guwagambiri, Nankugenda kumpindi kwa Tati gwangu na Tati gwenu, Mlungu gwangu na Mlungu gwenu.” ");
INSERT INTO poy_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mariya Magidalena kagenda na kawagambira weri visoweru vilii wafundwa kuwera kamwona Mtuwa na kuwagambira gawamgambira. ");
INSERT INTO poy_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Iweriti pamihi pa lishaka lya jumapili. Wafundwa waweriti waliwona pamuhera mnumba na milyangu iweriti itatwa toziya wawatiriti watuwa wa Shiyawudi. Su, Yesu kiza, kagoloka pakati pawu, kawagambira, “Ponga kwamwenga!” ");
INSERT INTO poy_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pakamaliriti kutakula aga, kawalanguziya mawoku gakuwi na lubavu lyakuwi. Su, wafundwa awa wasekelera nentu kumwona Mtuwa. ");
INSERT INTO poy_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu kawagambira kayi, “Ponga kwamwenga! Handa viraa Tati ntambu yakantumiti neni, naneni nankuwatuma mwenga.” ");
INSERT INTO poy_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pakamaliriti kutakula aga, kawatekelera na kuwagambira, “Mumwanki Rohu Mnanagala. ");
INSERT INTO poy_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Pamuwalegeziya wantu vidoda vyawu, hawalegeziwi, pamuwalegeziya ndiri, hapeni walekiziwi.” ");
INSERT INTO poy_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomasi, yumu gwa walii lilongu na wawili yawamshema mawira kaweriti ndiri pamuhera nawomberi shipindi Yesu pakiziti. ");
INSERT INTO poy_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Su, wafundwa wamonga walii wamgambira yomberi, “Tumwoniti Mtuwa.” Tomasi kawagambira, “Pamona ndiri mumawoku mwakuwi shilanguliru zya misumali na kuyingiziya shyala shangu pakati palikovu ali na kuyingiziya liwoku lyangu mluwavu lwakuwi, hapeni njimiri.” ");
INSERT INTO poy_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pa mashaka manane wafundwa waweriti kayi pamuhera mnumba mulii na Tomasi kaweriti pamuhera nawomberi. Milyangu iweriti itatwa, kumbiti Yesu kiza, kagoloka pakati pawu, pakatakula, “Ponga iweri pamuhera na mwenga!” ");
INSERT INTO poy_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Shakapanu kamgambira Tomasi, “Gutuli shyala shaku panu na guloli mawoku gangu, shakapanu gunyoshi liwoku lyaku na gunkoli lubavu lwangu. Guleki kwamini ndiri kwaku, gwenga gwamini!” ");
INSERT INTO poy_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi kamwankula, “Mtuwa gwangu na Mlungu gwangu!” ");
INSERT INTO poy_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu kamgambira, “Hashi, gujimira toziya gumona? Mbaka woseri yawanjimira pamberi pa kumona neni!” ");
INSERT INTO poy_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu katenditi pawulongolu pa wafundwa wakuwi malangaliru gamonga mavuwa galembitwi ndiri munkati mushintola ashi. ");
INSERT INTO poy_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kumbiti aga wagalembiti su mpati kwamini handa Yesu ndo Kristu, Mwana gwa Mlungu na kwa kumjimira mpati kuwera na ukomu. ");
INSERT INTO poy_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pa aga, Yesu kawalawiriti kayi wafundwa wakuwi kumbwega ku litanda lya Tiberiya. Ilawiriti hangu. ");
INSERT INTO poy_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Peteru, Tomasi yawamshema wamawira na Nataniyeri mwenikaya gwa kana mu Galilaya wana wawili wa Zebedayu na wafundwa wakuwi wamonga wawili, waweriti woseri pamuhera. ");
INSERT INTO poy_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Peteru kawagambira wamonga, “Nankugenda kulowa wasomba.” Womberi wamgambira, “Hatugendi na gwenga.” Su wawuka na wakweniti mtumbwi, kumbiti pashiru poseri wapatiti ndiri shintu. ");
INSERT INTO poy_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Payanjiti kushiya, Yesu kagolokiti pampeku pa litanda, kumbiti wafundwa wavimaniti ndiri kuwera yomberi ndo Yesu. ");
INSERT INTO poy_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Su, Yesu kawakosiya, “Wantemba, mlowa ndiri shintu shoseri?” Womberi wamwankula, “Tupata ndiri shintu.” ");
INSERT INTO poy_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu kawagambira, “Mwasi zinyavu zyenu uwega wa kumliwu mwa mtumbwi, hamlowi wasomba.” Su waziyasa zinyavu na waweziti ndiri kuzinika, toziya zinyavu ziweriti na wasomba yawamemiti nduu. ");
INSERT INTO poy_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mfundwa yakafiritwi na Yesu kamgambiriti Peteru, “Ayu Mtuwa” Simoni Peteru pakapikaniriti kuwera ayu ndo Mtuwa, kavala weri nguwu yakuwi toziya kaweriti kavala upati, su kingiriti mumashi. ");
INSERT INTO poy_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Su wafundwa wamonga wiziti kumbwega ku litanda pawawera mumtumbwi, wanikiti zinyavu zyaziweriti zimema wasomba. Waweriti ndiri patali na kuisi, iweriti handa utali wa mita malongu lilongu kulawa kumpeku. ");
INSERT INTO poy_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pawasokiti muisi wawoniti motu gwa makala gukoziwa na kuweriti na somba pamuhera na libumunda. ");
INSERT INTO poy_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Shakapanu Yesu kawagambira, “Mjegi panu wasomba wamu wamuwalowiti.” ");
INSERT INTO poy_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni Peteru kakwena mumtumbwi, kazinika zinyavu zilii kuisi zaziweriti zimema wasomba wakulu miya na malongu muhanu na tatu, tembera wasomba waweriti wavuwa zinyavu zidegeka ndiri. ");
INSERT INTO poy_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu kawagambira womberi, “Mwizi mlii.” Kwahera mfundwa ata yumu gwawu yakajeriti kumkosiya, “Gwenga gwa gaa?” Toziya womberi wavimaniti kaweriti Mtuwa. ");
INSERT INTO poy_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Su Yesu kiza, katola libumunda, kawapananiti, katenda hera hangu kwa wasomba walii. ");
INSERT INTO poy_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ayi iweriti mala ya tatu Yesu pakawalawiriti wafundwa pakazyukiti kala. ");
INSERT INTO poy_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pawamaliriti kuliya, Yesu kamkosiyiti Simoni Peteru, “Simoni, mwana gwa Yohani! Hashi, gunfira neni kuliku womberi awa?” Peteru kamwankula, “Yina Mtuwa, guvimana kuwera neni nukufira.” Yesu kamgambira, “Guloleri wakondolu waneni.” ");
INSERT INTO poy_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu kamkosiya mala ya pili, “Simoni mwana gwa Yohani! Hashi, gunfira neni?” Peteru kamwankula, “Yina Mtuwa guvimana kuwera nukufira.” Yesu kamgambira, “Guloleri wakondolu waneni.” ");
INSERT INTO poy_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mala ya tatu Yesu kamkosiya Peteru, “Simoni mwana gwa Yohani! Hashi, gunfira?” Palii Peteru kahinginikiti toziya kamkosiya mala ya tatu, “Gunfira?” Yomberi kamwankula, “Mtuwa, gwenga guvimana vyoseri, gwenga guvimana kuwera neni nukufira.” Yesu kamgambira, “Guloleri wakondolu wa neni! ");
INSERT INTO poy_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nakaka nukugambira, paguweriti muntemba guweriti gwankali kugenda koseri kwagufira kugenda, kumbiti paguwera mgogolu, hagukolwi liwoku na muntu gwingi pakakujega paala pagufira ndiri kugenda.” ");
INSERT INTO poy_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kwa kutakula hangu, kulanguziyiti ntambu Peteru pakahowa na kumkwisa Mlungu. Shakapanu Yesu kamgambiriti yomberi, “Gunfati neni!” ");
INSERT INTO poy_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peteru kagalambuka, kamwoniti ntumintumi ulii yakafiritwi na Yesu, kankumfata. Mfundwa ayu ndo mweni ulii shipindi sha kuliya shiboga sha pamihi, kalivagiti pakwegera nentu na Yesu pakamkosiya Yesu, “Mtuwa ndo gaa hakakugalambuki?” ");
INSERT INTO poy_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peteru pakamwoniti ayu kamkosiya Yesu, “Mtuwa! Na ayu hashi?” ");
INSERT INTO poy_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu kamwankula, “Handa panfira kalikali mpaka panizaku, shikuusu shishi gwenga? Gwenga gunfati neni!” ");
INSERT INTO poy_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Shisoweru shili shyeniyiti pakati pa walongu kuwera wafundwa ulii hapeni kahowi. Kumbiti Yesu kamgambiriti ndiri kuwera wafundwa ulii hapeni kahowi, ira katakuriti, “Handa panfira kalikali mpaka panizaku shi kuusu shishi gwenga?” ");
INSERT INTO poy_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ayu ndo mfundwa ulii yakapitawuliti vitwatira avi na kuvilemba. Natwenga tuvimana kuwera gakatakuliti ndo ganakaka. ");
INSERT INTO poy_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kwana vitwatira vyamonga vivuwa vyakatenditi Yesu, handa vyangalembwiti vyoseri, shimu kwa shimonga, meiweri pasipanu kwahera pahala pa kutula vintola vyavilembitwi.");
INSERT INTO poy_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mlongu Teufili, mushintola sha kwanja nembiti kuusu vitwatira vyoseri Yesu vyakatenditi na kufunda kwanjira kwanja. ");
INSERT INTO poy_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Mpaka lishaka lilii pakanyasulitwi kugenda kumpindi kwa Mlungu. Pamberi pa kunyasulwa kugenda kumpindi, kawapananiti malagaliru kupitira Rohu Mnanagala wantumintumi walii yakawasyaguliti. ");
INSERT INTO poy_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pakuhowa kwakuwi, yomberi kalilanguziyiti mweni kwa womberi na kulilanguziya nakaka kuwera mweni ka mkomu. Yomberi kawalawiriti kwa shipindi sha mashaka malongu msheshi na yomberi kayoweriti nawu kuusu Ufalumi wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Shipindi shimu yomberi pakaweriti nawu, kawapananiti lagaliru ali, “Namlawa amu Yerusalemu, su muliheperi lagilu lya Tati, lilii lyampikaniriti neni nonga kuusu visoweru vyakuwi. ");
INSERT INTO poy_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Toziya Yohani kawabatiziti kwa mashi, kumbiti pa mashaka gavuwa ndiri mwenga hamubatizwi kwa Rohu Mnanagala.” ");
INSERT INTO poy_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Su wantumintumi pawaliwoniti pamuhera na Yesu, womberi wamkosiyiti, “Mtuwa, shipindi ashi haguwuziyi ufalumi kwa Israeli?” ");
INSERT INTO poy_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu kawagambira, “Vyamwenga ndiri kuvimana vipindi ama zitarehi Tati gwangu kavitula muukolamlima wakuwi. ");
INSERT INTO poy_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kumbiti hamwanki likakala Rohu Mnanagala pakawayizireni mwenga, na hamuweri wapitawu waneni Muyerusalemu na Muyudeya yoseri na Samariya na ata upeleru wa pasipanu.” ");
INSERT INTO poy_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pakatakuliti kala aga, pawaweriti wankulola yomberi kanyasulitwi kugenda kumpindi kwa Mlungu, liwundu limfifa nawamwona kayi. ");
INSERT INTO poy_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pawaweriti wankali wankulola kumpindi yomberi kwakagenditi, palaa paliya wantu wawili yawavaliti nguwu nvufu wagolokiti pakwegela nawomberi, ");
INSERT INTO poy_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","na walonga, “Mwenga wantu wa Galilaya! Iwera hashi mgoloka panu pamlola kumpindi? Yesu ayu, yakanyasulitwi kulawa kwa mwenga kugenda kumpindi, hakizi kayi kwa njira iraa ayi ntambu yamumwoniti pakagenda kumpindi kwa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Shakapanu wantumintumi wawuyiti Yerusalemu kulawa kulugongu lwa Mizeyituni, kuweriti kilumita yimu kulawa mlushi. ");
INSERT INTO poy_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pawasokiti mlushi, wayingiriti mshumba shawalikaliti, nawomberi waweriti Peteru na Yohani na Yakobu na Andereya na Filipu na Tomasi na Batolumayu na Matayu, Yakobu mwana gwa Alifayu na Simoni Zeloti na Yuda mwana gwa Yakobu. ");
INSERT INTO poy_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Womberi woseri waliwoniti shipinga pamuhera kumluwa Mlungu, pamuhera na wadala na Mariya mawu gwa Yesu na walongu wakuwi Yesu. ");
INSERT INTO poy_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mumashaka galii Peteru kagolokiti pakati pa wantu yawamjimira Kristu, weni walanga yawu waweriti miya yimu na malongu mawili, su yomberi kalongiti. ");
INSERT INTO poy_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mwawalongu wangu, Malembu Mananagala gatimiya, geni Rohu Mnanagala katungiti kupitira Dawudi kuusu Yuda yakawalongoziyiti walii yawamkamuliti Yesu. ");
INSERT INTO poy_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda kaweriti yumu gwa shipinga shetu, toziya mweni kasyagulitwi kaweri mtenda lihengu muyetu.” ");
INSERT INTO poy_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Su Yuda kahemeliti lirambu kwa mpiya zilii za ukondola zyakazipatiti, pakaweriti kulirambu yomberi kaguwiti na kahowa, kapantika na utumbu wakuwi witika kunja. ");
INSERT INTO poy_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kila muntu yakalikaliti Muyerusalemu kapikaniriti visoweru vya vitwatira avi, na kwa likabira lyawu lirambu ali walishema Akelidama, mana yakuwi “Lirambu lya Mwazi.” ");
INSERT INTO poy_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Peteru kalongiti, “Ilembwa mushintora sha Zaburi, ‘Numba yakuwi isigali hera, muntu yoseri nakalikala amu.’ Kayi ilembwa, ‘Muntu yumonga katoli lihengu lyakuwi.’ ");
INSERT INTO poy_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Su ifiruwa tumsyaguli muntu yumonga pakati pa walii yawaweriti pamuhera na twenga shipindi shoseri mtuwa Yesu pakingiriti na kulawa pakati penu. ");
INSERT INTO poy_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Kwanjira kwa shipindi sha ubatizu wa Yohani mpaka lishaka lilii Yesu pakanyasulitwi kulawa kwatwenga kugenda kumpindi. Ifiruwa yumu gwawu kaweri kapitawu gwa kuzyuka kwakuwi pamhera natwenga.” ");
INSERT INTO poy_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Su wakanda matawu ga wantu wawili, Yosefu yawamshema Barisaba viraa yomberi kamanikana kwa litawu lya Yustu, na Matiya. ");
INSERT INTO poy_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Shakapanu wamluwa Mlungu, “Mtuwa, gwenga guyimana myoyu ya wantu woseri. Su gutulanguziyi pakati pa wawili awa ulii yagumsyaguliti, ");
INSERT INTO poy_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","katoli lihengu lya utenderu wa untumintumi wa Yuda yakaulekiti su kagendi pahala pakuwi mweni.” ");
INSERT INTO poy_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Shakapanu wagalambuziya simbi na kugalambuziya simbi aku kumtulukiriti Matiya, nayomberi kayongerwa mushipinga sha wantumintumi lilongu na yumu. ");
INSERT INTO poy_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lishaka lya Pentekosti palisokiti, woseri waweriti wajojinikiti pahala pamuhera. ");
INSERT INTO poy_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Vumu liziwu gambira lyega lipikinika kulawa kuliyera na limemiziyiti numba yoseri yawalikaliti. ");
INSERT INTO poy_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Womberi wawoniti vintu gambira mimbamba ya motu yaibagulikiti na kamkangalira kila muntu. ");
INSERT INTO poy_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Woseri wamemiziyitwi Rohu Mnanagala na wanjiti kutakula kwa luga zya makabira gamonga, Rohu ntambu yakawatenditi watakuli. ");
INSERT INTO poy_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Vinu palii Yerusalemu kuweriti na Wayawudi, wantu yawamguwira Mlungu, wantu yawalawiti kila isi pasi pa mpindi. ");
INSERT INTO poy_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Womberi pawapikaniriti liziwu ali, lipinga likulu lya wantu lijojinikiti pamuhera walikangasha, toziya kila yumu gwawu kawapikaniriti womberi wankutakula kwa luga ya likabila lyakuwi mweni. ");
INSERT INTO poy_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Womberi wasintuka na kulikangasha pawalikosiya, “Hashi, wantu awa ntambu yawatakula Wagalilaya ndiri? ");
INSERT INTO poy_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Iwera hashi, kila yumu gwetu kankuwapikinira pawatakula kwa luga yakuwi mweni? ");
INSERT INTO poy_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wamu wetu ndo Wapariti na Wamediya na Waelami, wamonga walawa Misopotamiya na Yudeya na Kapadokiya na Pontu na Asiya, ");
INSERT INTO poy_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","na Firigiya na Pamfiliya na Misri na kumikowa ya Libya pakwegera na Kureni. Wamonga wahenga kulawa Rumi, ");
INSERT INTO poy_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Wayawudi na wantu wawagalambukiriti dini ya Shiyawudi na wamonga walawa Kureti na Arabiya. Twawoseri twenga tupikanira pawatakula kwa luga zya makabila getu twaweni kuusu vitwatira vikulu Mlungu vyakatenditi!” ");
INSERT INTO poy_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Walikangasha na kuhinginika, wankulikosiyana weni gweka, “Mana yakuwi shii?” ");
INSERT INTO poy_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kumbiti wamonga watenda lidufiya pawalonga, “Wantu awa walowera ujimbi!” ");
INSERT INTO poy_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Shakapanu Peteru kagolokiti pamuhera na wantumintumi walii lilongu na yumu, kanja kulibwelera lipinga lilii lya wantu, “Walongu Wayawudi na woseri mwenga yamulikala Yerusalemu, mpikaniri weri shilii shanonga. ");
INSERT INTO poy_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wantu awa walowera ndiri ujimbi ntambu yamulihola, toziya ayi ndo saa tatu hera mandawira! ");
INSERT INTO poy_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Unakaka ndo awu shitwatira ashi ndo shirii shakatakuliti mbuyi gwa Mlungu Yoweli, ");
INSERT INTO poy_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Hantendi mumashaka ga kupelera, Mlungu kalonga, Hanuwamiminiri wantu woseri Rohu gwangu. Wananguta wenu wapalu na wadala, waubweri ujumbi, Wandemba hawawoni mawonu, Na wazewi wenu hawaloti. ");
INSERT INTO poy_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yina, ata wantumintumi wangu, wapalu na wadala, Hanuwamiminiri Rohu gwangu mulishaka, Na womberi hawaubweri ujumbi waneni. ");
INSERT INTO poy_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Handendi mauzauza kumpindi kuliyera, Na lilangaliru pasi panu, Hakuweri na mwazi, motu na lyosi lizotopa, ");
INSERT INTO poy_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mshenji gutulwa nditi, Na lyezi haliweri lisheri handa mwazi, Pamberi pa lishaka likulu na weru wa Mtuwa kwiza. ");
INSERT INTO poy_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Panu, yoseri yakafira kuluwa kwa litawu lya Mtuwa, hakalopoziwi’ ");
INSERT INTO poy_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Wana isi wa Israeli, mpikaniri shisoweru ashi! Yesu gwa Nazareti kaweriti muntu na ukulu wakuwi wa Umlungu ulanguziwa kwa mwenga kwa mauzauza, makangashu na langaliru Mlungu lyakatenditi pakati penu kwa njira yakuwi, handa ntambu yamumana. ");
INSERT INTO poy_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kugenderana na mpangu gwakuwi mweni Mlungu kaamuwiti kala handa Yesu mewamubati, mwenga mumlaga kwa kuwalekera wantu wadoda wampingiki. ");
INSERT INTO poy_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kumbiti Mlungu kamzyukisiya kulawa kwawahowiti, kamlopoziya mukutama kwa kuhowa kwa mana iwezekana ndiri nakamu kuhowa kumtatiri ");
INSERT INTO poy_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mana Dawudi katakuliti kuusu yomberi hangu, Numwoniti Mtuwa kuulongolu kwa neni mashaka goseri, ka pamu na neni uwega wangu wa kumliwu, ata hapeni ndikinyiki. ");
INSERT INTO poy_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hangu, moyu gwangu gwasekuseku, kayi ntenditi lusheka lya nemeleru. Nshimba ya neni hayilikali mlitumbiru, ");
INSERT INTO poy_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Toziya hapeni guyileki rohu yaneni kulirindi lyalihera upeleru, pota kumleka mnanagala gwaku kawoli. ");
INSERT INTO poy_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gunanguziyi njira za ukomu, kuweri kwakuwi gumemiziya sekuseku! ");
INSERT INTO poy_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mwalongu wangu, nfira kuwagambirani shinagaubaga kuusu vitwatira vyavimpatiti Dawudi, mbuyi gwetu. Yomberi kahowiti, wamsira, kayi lipumba lyakuwi lyapalapanu pa twenga mpaka lelu. ");
INSERT INTO poy_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kumbiti yomberi kaweriti mbuyi gwa Mlungu na kavimaniti kuwera Mlungu kamlagiliti kwa shirapu kuwera hakampanani yumu gwa mwiwuku gwakuwi ukolamlima ntambu yakaweriti Dawudi. ");
INSERT INTO poy_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawudi kaviwoniti pamberi vitwatira Mlungu vyakagenda kuvitenda, su yomberi kayoweriti kuusu uzyukisiya wa Kristu pakatakuliti, ‘Kalekitwi ndiri mulirindi lyalihera upeleru, ama nshimba yakuwi iwoliti ndiri.’ ");
INSERT INTO poy_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Su, Mlungu kamzyukisiyiti Yesu ayu na twawoseri twenga ndo wakapitawu wa lilawiru ali. ");
INSERT INTO poy_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yesu wamnyasuliti kumpindi mpaka uwega wa kumliwu wa Mlungu, yomberi kawanka lagilu lya Rohu Mnanagala kulawa kwa Tati na kashimiminira shilii shamushiwona vinu na kushipikinira. ");
INSERT INTO poy_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Mana Dawudi mweni, kakwena haa mpaka kumpindi, ila yomberi kalongiti, Mtuwa kamgambiriti Mtuwa gwangu, Gulikali uwega wangu wa kumliwu, ");
INSERT INTO poy_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Mpaka nuwatendi wankondu waku waweri shiti sha magulu gaku. ");
INSERT INTO poy_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Wantu woseri wa Israeli wafiruwa kuvimana kwa nakaka handa Yesu ayu yampingikiti, ndomweni Mlungu kamtenda kuwera mtuwa na Kristu.” ");
INSERT INTO poy_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Su, wantu pawapikaniriti aga, walunguziwitwi moyu, wawakosiyiti Peteru na wantumintumi wayaguwi, “Walongu wetu, tutendi shishi?” ");
INSERT INTO poy_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peteru kankula, “Mtubu na kila yumu gwenu kabatizwi kwa litawu lya Yesu Kristu su mpati kuwusiya vidoda vyenu na kwanga kwayidi kwa Rohu Mnanagala. ");
INSERT INTO poy_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","“Toziya lagilu alii ndo kwajili ya mwenga na wana wenu na kwa wantu woseri yawawera kutali, kwa ntambu ya woseri yawalikala patali, na kwa wantu woseri Mtuwa Mlungu gwetu hakawashemi kwakuwi.” ");
INSERT INTO poy_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kwa shisoweru shingi kayi shitangala, Peteru kasisitiziti na kuwahimiziya wantu pakalonga, “Mlilopoziyi mushiyiwuku ashi shikondola.” ");
INSERT INTO poy_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Wavuwa wavijimiriti visoweru vyakuwi, wabatizwa. Wantu elufu tatu wongerekiti mushipinga shili lishaka ali. ");
INSERT INTO poy_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Woseri awa wendereyiti kulifunda kulawa kwa wantumintumi, kulikala pamuhera shilongu, kumega libumunda na kumluwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mauzauza na makangashu gavuwa gatendikiti kupitira wantumintumi ata kila muntu kawera na lyoga. ");
INSERT INTO poy_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Woseri yawajimira wendereyiti weri shintu shimu na lunda zawu wagawaniti pamuhera. ");
INSERT INTO poy_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Waweriti wankuwuza lunda na vintu vyawu shakapanu wagawana mpiya shiyasi ya nfiru ya kila yumu. ");
INSERT INTO poy_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Wendereyiti kuliwona pamuhera kila lishaka Munumba nkulu ya Mlungu. Kumbiti shipindi sha kumega libumunda, waliwoniti mnumba zyawu na waliya pamuhela shiboga ashi kwa sekuseku na moyu guherepa. ");
INSERT INTO poy_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Wamkwisiti Mlungu, wafiruwa na wantu woseri. Kila lishaka Mtuwa kawayongeleriti walanga ya wantu yawaweriti wankulopoziwa. ");
INSERT INTO poy_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lishaka limu Peteru na Yohani wagenditi Mnumba nkulu ya Mlungu shipindi sha saa tisa paliwala, shipindi sha kusala. ");
INSERT INTO poy_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Paweriti na Mlyangu guherepa, muntu yumu shibyeketu kwanjira kwiwuka. Wantu hawa waweriti wankumpapa muntu ayu kila lishaka kumjega kumlyangu kuluwa mpiya kwa wantu yawingira kunumba nkulu ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pakawawoniti Peteru na Yohani wankwingira Mnumba nkulu ya Mlungu, shibyeketu ulii kawaluwiti wampanani shintu. ");
INSERT INTO poy_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peteru pamuhera na Yohani wamjodolera masu, na Peteru kamgambira, “Gutuloli!” ");
INSERT INTO poy_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Su kawagalambukira, pakalolelera kupananwa shintu kulawa kwawomberi. ");
INSERT INTO poy_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kumbiti Peteru kamgambira, “Nahera mpiya, kumbiti shirii shamweri nashu hanukupanani, kwa litawu lya Yesu Kristu gwa Nazareti nukugambira gugoloki na gugendigendi!” ");
INSERT INTO poy_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Shakapanu kamkola liwoku lya kumliwu na kamgolosiya. Palaa palii magulu na manung'unu gakuwi gapata likakala. ");
INSERT INTO poy_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kakopoka, kagoloka na kwanja kugendagenda. Shakapanu kingira pamuhera nawomberi Mnumba nkulu ya Mlungu, pakagendagenda na kukopokakopoka na pakamkwisa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wantu woseri yawamwoniti kankugendagenda na kumkwisa Mlungu, ");
INSERT INTO poy_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","na pawavimaniti weri ndo ulii yakaweriti kankuluwaluwa pakwegera na Mlyangu Guherepa gulii gwa Numba nkulu ya Mlungu, woseri walikangasha nentu, su waweziti ndiri kuvimana vyavimpatiti. ");
INSERT INTO poy_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Muntu yakaponiziwitwi na Peteru na Yohani pamdamu gwa Selemani, Wantu woseri, waweriti wankulikangasha, wanja kumtugira. ");
INSERT INTO poy_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Shipindi Peteru pakawawoniti wantu awa kawagambira, “Wana lushi lwa Israeli, ntambu gaa mkangashwa na shitwatira ashi? Mbona mwankutujodolera masu gambira kwa likakala lyetu ama unanagala wetu twaweni tumtenda muntu ayu kawezi kugendagenda? ");
INSERT INTO poy_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mlungu gwa Aburahamu na Isaka na Yakobu, Mlungu gwa wambuyi wetu kamkwisa ntumintumi gwakuwi Yesu. Kumbiti ndomweni ula ulii yakakamlitwi na wakulu na kumlema kuulongolu kwa Pilatu, ata pa Pilatu kuamuwa kumlekeziya. ");
INSERT INTO poy_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kaweriti mnanagala na yakamfiriziya Mlungu, kumbiti mwenga mulemiti, na mmufira muntu gwingi kayi yakaweriti kalaga kumlekiziya. ");
INSERT INTO poy_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Su, mumlagiti ulii yomberi ndo shanjiru sha ukomu. Kumbiti Mlungu kamzyukisiyiti kulawa kwa wahowiti na twenga ndo wakapitawu wa shitwatira ashi. ");
INSERT INTO poy_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Litawu lya Yesu na moyu mulitawu ali ndo vyavimupiti likakala muntu ayu yamumwona na kumana. Njimiru kwa Yesu ndo imuponiziyiti nakamu muntu ayu ntambu yamuviwona mwawoseri.” ");
INSERT INTO poy_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Vinu mwalongu wangu Izraeli, nuvimana handa mwenga na wakulu wenu mtenditi aga kwa Yesu toziya ya kuvimanandiri kwenu. ");
INSERT INTO poy_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kumbiti avi Mlungu gakatimiziti galaa gakabweriti makashu kwa njira ya wambuyi woseri, handa iweriti mpaka Kristu gwakuwi katabiki. ");
INSERT INTO poy_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Su, mleki, mmuwuyiri Mlungu gwenu su yomberi kafuti vidoda vyenu. ");
INSERT INTO poy_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mtendaga hangu su Mtuwa kawayupi shipindi sha sekuseku mrohu na kuwajegera ula Kristu yakamsyaguliti yomberi ndo Yesu. ");
INSERT INTO poy_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ifiruwa yomberi kasigali aku kumpindi mpaka pashisoka shipindi kulekibishwa vintu vyoseri, handa Mlungu ntambu yakatakuliti kwa njira ya wambuyi wakuwi wananagala kwanjira makashu. ");
INSERT INTO poy_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Toziya Musa katakuliti, Mtuwa Mlungu gwenu hakawajegerani mbuyi handa neni kulawa pakati penu maweni. ");
INSERT INTO poy_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yoseri ulii hapeni kamupikiniri mbuyi gwa Mlungu ayu hakatulwi kutali na wantu wa Mlungu na kuagamiziwa. ");
INSERT INTO poy_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wambuyi woseri wa Mlungu, kwanjira Samweli na walii wamfatiti, wabweriti visoweru vya vitwatira avi vyeni viweriti vyankutendeka mashaka aga. ");
INSERT INTO poy_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Malagiru galii Mlungu kagalaviyiti kwa njira ya Wambuyi ndo kwajili ya mwenga, na mtenda pamwera lipatanu Mlungu lyakatenditi na mbuyi gwetu, handa ntambu yakamgambiriti Aburahamu.Kwa njira ya wiwuka waku, wantu woseri wa pasi panu hawatekelerwi. ");
INSERT INTO poy_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Su, Mlungu kamzyukisiyiti ntumintumi gwakuwi kwa mota yenu kwanja, kamtuma kawajegeri matekeleru kwa kumtenda kila yumu gwenu kalekani nakamu na vidoda vyakuwi.” ");
INSERT INTO poy_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peteru na Yohani pawaweriti wankali wankuwabwelera wantu, watambika na wakulu wa walolera wa numba nkulu ya Mlungu pamwera na Masadukayu wiziti. ");
INSERT INTO poy_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wakalaliti nentu, toziya wantumintumi awa waweriti wankuwabwelera wantu kuwera Yesu kazyukiti, shitwatira sheni shilanguziya pota kufifa handa wahowiti hawazyuki. ");
INSERT INTO poy_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Su, wawaturiti mlikakala na toziya pashiru paweriti pakwegera, wawaturiti mkulolerwa mpaka shirawu yakuwi. ");
INSERT INTO poy_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kumbiti wavuwa pakati pa walii yawapikaniriti ujumbi wawu wajimiriti na walanga ya wawajimira iwera yongereka wapalu elufu mhanu. ");
INSERT INTO poy_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Shirawu yakuwi, watuwa wa Wayawudi, wazewi na wafunda wa malagaliru wajojinika pamwera aku Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Waliwoniti pamuhera na Anasi mtambika mkulu, Kayafa na Yohani na Alekizanda na wamonga yawaweriti wa lukolu lwa mtambika mkulu. ");
INSERT INTO poy_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pawawagolisiyiti wantumintumi kuulongolu kwawu, wawakosiyiti, “Mwenga mtenda shitwatira ashi kwa likakala lyoshi na kwa litawu lya gaa?” ");
INSERT INTO poy_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Panu, Peteru, pakawera kamemiziwa na Rohu Mnanagala, kawagambira, “Walongoziya na wazewi wa wantu! ");
INSERT INTO poy_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Handa pamtukosiya leru kuusu shilii shitendu shiheri shakatenderitwi ulii muntu yakaweriti shibyeketu na ntambu yakaponiziwitwi, ");
INSERT INTO poy_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Su, mwenga na wantu woseri wa Israeli mfiruwa kuvimana kuusu muntu ayu kagoloka kulongolu kwamwenga leru, mkomu nakamu, kwa likakala lya litawu lyakuwi Yesu Kristu gwa Nazareti yomberi mwenga mmupingika, kumbiti Mlungu kamzyukisiya kulawa kwa wahowiti. ");
INSERT INTO poy_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ayu ndomweni Malembu Mananagala gatakula, Libuwi lyamuliremiti mwenga wanyawa numba, vinu liwera Libuwi likulu lya liyanjiru ");
INSERT INTO poy_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ulopoziya upatikana ndiri kwa muntu gwingi yoseri, toziya kwahera litawu limonga pasi pa mpindi, wantu wawapanana ndiri litawu lya muntu gwingi mweni twenga tuweza kulopuziwa na yomberi.” ");
INSERT INTO poy_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Awa wazewi Pashizyungu, waweriti wavimana handa Peteru na Yohani waweriti wantu wahera shisomu pota elimu yoseri, walikangasha ntambu yawatakuliti kwa ugangamala. Wavimana handa waweriti wapamwera na Yesu. ");
INSERT INTO poy_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kumbiti pawamwoniti muntu ulii yawamponiziyiti kagoloka pamwera nawomberi, waweza ndiri kutakula shintu. ");
INSERT INTO poy_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hangu, wawagambiriti walawi kunja kumdamu, na womberi wasigala mnumba pawatakula kwa kupwepa. ");
INSERT INTO poy_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Walikosiana, “Tutendi shishi na wantu awa? Kila muntu yakalikala Yerusalemu kavimana handa mauzauza aga gakulikangasha gatendeka, natwenga tuwezandiri kulema shitwatira ashi. ");
INSERT INTO poy_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kumbiti su tupati kubera shitwatira ashi nashiendereya nentu pakati pa wantu, tuwakalipiri nawayowera na muntu yoseri kwa litawu lya Yesu.” ");
INSERT INTO poy_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Hangu wawashema kayi mngati, wawaberiziya nawayowera kayi paweru, na kufunda kwa litawu lya Yesu. ");
INSERT INTO poy_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kumbiti Peteru na Yohani wawankula, “Mwamuwi mwenga handa ndo teratera kuulongolu kwa Mlungu kuwajimira mwenga kuliku kumjimira Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Toziya tuwezandiri kuleka kutakula kuusu vitwatira vilii vyatuviwoniti na kuvipikinira.” ");
INSERT INTO poy_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Su, awa wazewi wa shyotera motu waberiziya kwa kukaripa nentu, shakapanu wawalekeziyiti. Waweza ndiri kuwapanana azabu toziya wantu woseri waweriti wankumkwisa Mlungu toziya ya shitwatira ashi. ");
INSERT INTO poy_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Muntu ayu yawamponiziyiti kaweriti na umli wa vinja nentu ya malongu msheshi ");
INSERT INTO poy_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pawawalekeziyiti hera, Peteru na Yohani wawuyiti kwa wayawu, wawagambira galii gawagambiritwi na watambika wakulu wa Shikundi sha wantu yawamjimira Yesu na wazewi. ");
INSERT INTO poy_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nawomberi pawapikaniriti shisoweru ashi waweriti pamwera mukumluwa Mlungu wankutakula, “Mtuwa, gwenga ndo mnyawa gwa mpindi na pasi panu, ibahali na vyoseri vyamlamu! ");
INSERT INTO poy_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Gwenga gumtenditi ntumintumi gwaku, tati gwetu Dawudi, katakuli kwa likakala lya Rohu Mnanagala, Kwa shishi maisi ganamaya? Iwera hashi wantu watenda mipangu ya hera? ");
INSERT INTO poy_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wafalumi wa pasipanu walituliti kala, na watuwa waliwoniti pamwera, watenda ntambu imonga kwa Mtuwa na watenda ntambu imonga kwa Kristu gwakuwi.” ");
INSERT INTO poy_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Mana, nakaka, ndo Herodi, Pontiwu Pilatu, wantu wa Israeli na wantu wa maisi pawariwoniti palaa panu mlushi, kumkoma Yesu ntumintumi gwakuwi Mnanagala mweni kamsyaguliti. ");
INSERT INTO poy_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Waliwoniti su watendi vitwatira vilii vyagufiriti na kupanga kwanjira kwanja kwa uwezu waku na mafiliru gaku ");
INSERT INTO poy_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kumbiti vinu, gwee Mtuwa, gulori vitiriziwu vyawu. Gutuwezeshi twenga wantumintumi waku kushibwera shisoweru shaku kwa ugangamala. ");
INSERT INTO poy_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Gunyoshi liwoku lyaku su guponiziyi wantu. Gutendi lilangaliru na mauzauza kwa litawu lya Yesu ntumintumi gwaku Mnanagala.” ");
INSERT INTO poy_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pawamaliriti kumluwa Mlungu pahala palii pawaliwoniti, nawomberi woseri wamemiziyitwi Rohu Mnanagala. Woseri wanja kubwera shisoweru sha Mlungu pota lyoga. Walikaliti gambira mlongu yumu ");
INSERT INTO poy_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Shipinga shoseri shawamjimiriti Yesu waweriti na moyu gumu na Rohu yimu. Kwahera ata yumu yakaweriti na shintu shoseri kashitula shiweri lunda yakuwi mweni, ila wagawaniti vyoseri vyawaweriti navyu. ");
INSERT INTO poy_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Wantumintumi watakuliti kwa likakala livuwa kuzyuka kwa Mtuwa Yesu, na yomberi Mlungu kawapanana tekelera zivuwa. ");
INSERT INTO poy_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kwahera muntu yoseri yakapungukiwitwi shintu, mana waweriti na malambu ama numba waweriti wankuviwuza ");
INSERT INTO poy_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","na kuwapanana ntumintumi mpiya azi, wawayupa kila yumu shiyasi shakafira ");
INSERT INTO poy_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","kuweriti na Mlawi yumu, mwiwuka gwa Kupiru, litawu lyakuwi Yosefu, ulaa wantumintumi wamshemiti Barinaba mana yakuwi, “Muntu yakapanana moyu”. ");
INSERT INTO poy_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yomberi viraa kaweriti na lirambu lyakuwi, kawuziti, katola mpiya zilii kawapanana wantumintumi. ");
INSERT INTO poy_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Muntu yumu yawamshema Ananiya na mdala gwakuwi Safira wawuziti lirambu lyawu viravi. ");
INSERT INTO poy_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Kumbiti, mdala gwakuwi pakawera kavimana, Ananiya kalitulila seemu ya mpiya zyakazipatiti na seemu imonga ilii kawayupiti wantumintumi. ");
INSERT INTO poy_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Su, Peteru kamkosiyiti, “Ananiya, mbona shetani kingira mmoyu mwaku na kukutenda gumzyangi Rohu Mnanagala kwa kulitulira seemu ya mpiya zagupatiti kulawilirana na lilambu lilii? ");
INSERT INTO poy_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pamberi pa kuliwuza liweriti lyaku na paguliwuziti kala, isigala mpiya azi ziweriti zaku guzitumii ntambu yagufira. Toziya gaa, gwamuwiti mmoyu mwaku kutenda shitwatira sha ntambu ayi? Gumzyanga ndiri muntu, Gumzyanga Mlungu!” ");
INSERT INTO poy_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiya, pakapikaniriti aga kaguwa pasi, kahowa.Wantu woseri wapikiniriti shisoweru sha lilawiru ali watiriti nentu. ");
INSERT INTO poy_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wandemba wasoka, wayigibikira njimba yakuwi, wamlaviya kunja, wamsira. ");
INSERT INTO poy_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pa shipindi sha masaa matatu hangu, mdala gwakuwi, pota kuvimana shitwatira shilawiriti, kingira mngati amu. ");
INSERT INTO poy_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peteru kamgambira, “Gung'ambiri! Hashi, shiyasi ashi sha mpiya ndo shampatiti kwa kuwuza lirambu lilii?” Yomberi kankula, “Yina, ndo sheni ashi” ");
INSERT INTO poy_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yomberi Peteru kamgambira, “Mbona mtenda mpangu kumjera Rohu gwa Mtuwa? Gupikiniri! Walii wantu wagenditi kumusira mpalu gwaku, vinu wapanu pamlyangu na wankukutola gwenga viraa.” ");
INSERT INTO poy_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Vumu Safila kaguwa kulongolu kwa magulu ga Peteru, kahowa. Wandemba walii pawingiriti, wamwoniti kahowa kala, hangu wamlaviya kunja, wamsira pakwegera na mpalu gwakuwi. ");
INSERT INTO poy_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Shipinga shoseri sha wantu yawamjimira Yesu pamuhera na woseri yawapikaniriti shisoweru sha vitwatira avi, watiriti nentu. ");
INSERT INTO poy_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Wantumintumi watenditi mauzauza na makangashu gavuwa pakati pa wantu. Wawumini waweriti wankuliwona pamwera muukumbi wa Selemani. ");
INSERT INTO poy_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Muntu yoseri gwingi yakaweriti ndiri muumini kajeriti ndiri kuwera pamhera na womberi. Ata hangu, wantu wamonga yawawera ndiri na njimiru ayi wawazyuma. ");
INSERT INTO poy_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Walanga ya wantu yawamjimiriti Mtuwa, wapalu na wadala, iyongerekiti. ");
INSERT INTO poy_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Toziya ayi, wantu waweriti wankuwajega walweli mnjira na kuwagonjeka pampindi pa shitanda na mikeka su Peteru pakapita, tembera shivuni shakuwi shiwashinkuli wamu wawu. ");
INSERT INTO poy_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wantu wavuwa wasokiti kulawa mulushi za kumbekumbeku za Yerusalemu, wankuwajega walweli wawu na walii yawawera na shamshera wadoda na womberi woseri waponiziwa. ");
INSERT INTO poy_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Shakapanu mtambika mkulu na wayaguwi yawaweriti pamuhera na shipinga sha Masadukayu, wawera na weya. ");
INSERT INTO poy_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Su, wawatawa ntumintumi, na kuwajega mngati mnumba nkulu ya shibetubetu. ");
INSERT INTO poy_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kumbiti pashiru ntumintumi gwa kumpindi gwa Mtuwa kayivuguliti milyangu ya shibetubetu, kawalaviya kunja, kawagambira, ");
INSERT INTO poy_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mgendi mkagoloki Mnumba nkulu ya Mlungu na kuwagambira wantu kila shintu kuusu makaliru aga gasyayi.” ");
INSERT INTO poy_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Wantumintumi wajimiriti, wingira Mnumba nkulu ya Mlungu mandawira putiputi, wanja kufunda. Mtambika mkulu na wayaguwi pawasokiti, washemiti mkutanu gwa shizyungu shikulu, ndo shipinga sha wazewi wa Wayawudi, shakapanu wawatuma wantu mushibetubetu wawajegi wantumintumi walii. ");
INSERT INTO poy_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kumbiti wakulu awa pawasokiti aku wawawona ndiri mshibetubetu mlii. Hangu wawuyiti, wawagambira mumkutanu, ");
INSERT INTO poy_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Pawatakula, “Tuwoniti shibetubetu shitatwa kila uwega na walolera wankulolera milyangu. Kumbiti patuvuguliti tumwona ndiri muntu yoseri mngati.” ");
INSERT INTO poy_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mkulu gwa walolera wa numba nkulu ya Mlungu na watambika wakulu pawapikaniriti shisoweru ashi wawera na lyoga, wavimana ndiri gawawapatiti. ");
INSERT INTO poy_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kiza muntu yumu, kawagambira, “wantu walii yamuwatatiriti mshibetubetu, vinu wamunumba nkulu ya Mlungu, wankufunda wantu.” ");
INSERT INTO poy_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Panu mkulu gwa walolera wa numba nkulu ya Mlungu pamwera na wantu wakuwi wagenditi mnumba nkulu ya Mlungu, kawajega. Kumbiti wawakamula ndiri kwa likakala, toziya watiriti handa wantu mewawagumi mabuwi. ");
INSERT INTO poy_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Su wawajega, wawagolisiya kulongolu kushizyungu, Mtambika Mkulu kawagambira, ");
INSERT INTO poy_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tuwaberiti paweru kufunda kwa litawu lya muntu ayu, vinu mweneza mafunda genu poseri Muyerusalemu na mupanga kututulira lawama ya kuhowa kwa muntu ayu.” ");
INSERT INTO poy_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Panu Peteru, kiwiti pamwera na walii ntumintumi wamonga, kankula, “Mpaka tumjimiri Mlungu, muntu ndiri. ");
INSERT INTO poy_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mlungu gwa mbuyi gwetu kamzyukisiyiti Yesu pa mwenga kumlaga kwa kumpingika mlupingika. ");
INSERT INTO poy_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ayu ndomweni ulii yakakwisitwi na Mlungu mpaka uwega wakuwi wa mliwu, kawera mlongoziya na Mlopoziya su katendi wantu wa Israeli waleki vidoda, wapati kulekiziwa vidoda vyawu. ");
INSERT INTO poy_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Twenga ndo wakapitawu wa lilawiru ali, yomberi Rohu Mnanagala ndo yomberi Mlungu kawayupa walii wawamjimira, wankupitaulira vira lilawiru ali.” ");
INSERT INTO poy_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wajumbi woseri wa shizyunga shilii pawapikaniriti aga, waweriti na maya, ata waamuwa kuwalaga. ");
INSERT INTO poy_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kumbiti Mfalisayu yumu yawamshema Gamalieli mweni kaweriti mfunda gwa Malagaliru na yakapananitwi ligoya nentu kulongolu kwa wantu woseri, kagolokiti kulongolu kushizyungu kulii, kafiriti ntumintumi walii walaviwi kunja katepu. ");
INSERT INTO poy_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Shakapanu kawagambira wajumbi walii wa shizyungu, “Walushi lwa Israeli, shondi pamberi pa kutenda ashi shamfira kuwatenda wantu awa! ");
INSERT INTO poy_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Makashu shididini, kulawiriti muntu yumu litawu lyakuwi Teuda, kalitakulira kuwera muntu gwa mana na wantu pakwegera na miya mhanu walijegiti pamhera na yomberi, kumbiti wamlagiti, shakapanu wandundami wakuwi woseri wapalanganika na shipinga shakuwi shifuwa. ");
INSERT INTO poy_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kayi, shakapanu, shipindi shilii sha kuwalangwa wantu, kalawiriti Yuda gwa Galilaya. Ayu na yomberi kwawakwegiti wantu wamfata, Kumbiti na yomberi wamlagiti, na wandundami wakuwi wapalanganikiti. ");
INSERT INTO poy_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na vinu viraa neni nuwagambira kotukuwatendera shintu shoseri wantu awa, muwalekiziyi! Toziya, payiwera shitendu ashi shawu shanjishwa na muntu, hashiwuki sheni. ");
INSERT INTO poy_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kumbiti handa shanjishwa na Mlungu, hera ndiri handa hapeni muwezi kuwakanga, su hamliwoni mmulema Mlungu.” ");
INSERT INTO poy_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Su wawashema ntumintumi walii, waamuwa wasyatagwi viboku na kuwaberiziya nawafunda kayi kwa litawu lya Yesu, shakapanu wawaleka wagendi zawu. ");
INSERT INTO poy_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Su, ntumintumi walawa kunja kushizyungu pawamema nemeru, toziya wafiruwiti kusoniziwa kwajili ya litawu lya Yesu. ");
INSERT INTO poy_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mnumba nkulu ya Mlungu na ukaya kwa wantu, womberi wendereyiti kila lishaka kufunda na kubwera Shisoweru Shiwagira sha Yesu kuwera ndo Kristu. ");
INSERT INTO poy_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pamberi, walanga ya wafundwa paweriti iyongerekiti, kulawiriti magugumiru pakati pa walongu yawayoweriti Shigiriki na walii yawayoweriti Shiebraniya. Walii yawayoweriti Shigiriki wagugumiliti handa wakenja wawu waweriti wankuwalyaluwa pakati ubagulira wa mafiru ga kila lishaka. ");
INSERT INTO poy_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Hangu, wafundwa lilongu na wawili washemiti shipinga shoseri sha wafundwa, walonga, “iherepa ndiri twenga tuleki kushibwera shisoweru sha Mlungu su tugolokeri ubagulira wa nfiru. ");
INSERT INTO poy_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hangu, walongu wetu, msyaguli muwamu wenu wantu saba wana zyuma iherepa, wamemitwi na Rohu na wana luhala, na twenga hatuwapanani lihengu ali. ");
INSERT INTO poy_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Twenga, kumbiti, hatushuguliki na sala na lihengu lya kubwera shisoweru sha Mlungu.” ");
INSERT INTO poy_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Shitwatira ashi shiherepa kwa shipinga shoseri. Wawasagula stefanu, muntu yakawera na njimiru nkulu na kumema Rohu Mnanagala, Filipi na Prokoru na Nikanori na Timoni na Parimena na Nikolayi muntu gwa Antiokiya yomberi kwanja kaweriti mudini ya Shiyawudi. ");
INSERT INTO poy_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wawatula kulongolu kwa ntumintumi, nawomberi wawaluwira na kuwatulira mawoku. ");
INSERT INTO poy_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Shisoweru sha Mlungu shiziditi kweneya na walanga ya wafundwa aku Yerusalemu iyongerekiti nentu, na shipinga shikulu sha watambika wa numba ya Mlungu waiyanka njimiru. ");
INSERT INTO poy_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Mlungu kamupananiti Stefanu manemu gavuwa, kampanana likakala livuwa ata kawera kankutenda mauzauza na makangashu pakati pa wantu. ");
INSERT INTO poy_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kumbiti wantu tunga walawira su walikakatali na Stefanu. Wantu wamu awa waweriti wa numba ya Mlungu yimu yaishemwa “Numba ya Mlungu ya wantu lekeru.” Nawomberi walawira Kureni na Alekizandiriya, wamonga walawira Kilikiya na Asiya. ");
INSERT INTO poy_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kumbiti wasinditi kumkanga toziya ya luhala lwakuwi na toziya ya ulii Rohu yakamlongoziyiti shipindi pakatakuliti. ");
INSERT INTO poy_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Hangu wawahongiti wantu wamu watakuli, “tumpikinira Stefani pakatakula shisoweru sha kumwigira Musa na kumwigira Mlungu.” ");
INSERT INTO poy_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ntambu ayi, wasonguziyiti wantu, wazewi na wafunda wa malagaliru. Su, wamwizira Stefani, wambata na kumjega kulongolu Kushizyungu shikulu. ");
INSERT INTO poy_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Wajegiti Pashizyungu wakapitawu wa mpaya weni watakuliti, “Muntu ayu kaleka ndiri kupayigira pahala panu pananagala na malagaliru ga Musa. ");
INSERT INTO poy_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Toziya tumpikiniriti kala pakatakula eti Yesu ayu gwa Nazareti hakapahalibisii nakamu pahala panu na kuwusilira kutali ntambu zilii zyatwangiti kulawa kwa Musa.” ");
INSERT INTO poy_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Woseri yawaweriti mushikawu sha Shizyungu wamloliti dii Stefani, washiwona sheni shakuwi handa ntumintumi gwa kumpindi. ");
INSERT INTO poy_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Su Mtambika Mkulu kamkosiya, “Hashi, shitwatira ashi shanakaka?” ");
INSERT INTO poy_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yomberi Stefani katakula, “Mwalongu wangu na ashina tati, mpikanireni! Mlungu gwa ukwisa kamlawiriti tati gwetu Aburahamu pakaweriti kulii Misopotamiya pamberi kenigendi kulikala kulii Harani. ");
INSERT INTO poy_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Mlungu kamgambiriti, ‘Guwuki paisi yaku, guwaleki wantu wa lukolu lwaku, Gugendi paisi hanukulanguziyi!’ ");
INSERT INTO poy_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hangu, Aburahamu kahamiti isi ya Kalidayu, kagenda kulikala Harani. Pakahowiti kala tati gwakuwi, Mlungu kamwusiyiti kayi Halani kiza kulikala paisi ayi yamlikala vinu. ");
INSERT INTO poy_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mlungu kamupiti ndiri ata seemu yimu ya isi ayi iweri yakuwi, ata hangu, kamlagiliti kumpanana isi ayi iweri yakuwi na ya walelwa wakuwi, tembera shipindi ashi kaweriti ndiri na mwananguta. ");
INSERT INTO poy_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mlungu kamgambiriti hangu, ‘Walelwa waku hawajegwi paisi yayikolwa mlima na wantu wamonga, na aku hawatendwi wamanda na kutenderwa vidoda kwa shipindi sha vinja miya msheshi. ");
INSERT INTO poy_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kumbiti neni hanuwatozi wantu yawagenda kuwatenda kuwera wamanda. Mlungu kalonga, shakapanu hanuwalaviyi muisi ayi su wizi kunguwira pahala panu.’ ");
INSERT INTO poy_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Shakapanu Mlungu kayitenda jandu iweri langaliru lya lipatanu. Hangu, Aburahamu kamyingiziyiti jandu mwana gwakuwi Isaka lishaka lya nane pakayiwukiti kala. Na Isaka, ntambu irayi, kamyingiziyiti jandu Yakobu. Yomberi Yakobu kawatendiriti walii wambuyi ligumba na wawiri ntambu irayi.” ");
INSERT INTO poy_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Wambuyi walii wamwoniriti weya Yosefu, wamwuza muumanda Misri. Kumbiti Mlungu kaweriti pamwera nayomberi. ");
INSERT INTO poy_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Kamuwusiya mutabu zakuwi zoseri. Mlungu kampanana ntambu na luhala kulongolu kwa Farawu, mfalumi gwa Misri, ata Falawu kumtula kaweri mkulu gwa isi ilii na numba ya shifalumi. ");
INSERT INTO poy_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Shakapanu, kwaniti njala ngulu paisi yoseri ya Misri na Kanaani, isababisha kuperuwa kukulu. Wambuyi wetu wapata ndiri shiboga shoseri ");
INSERT INTO poy_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Su, Yakobu pakapatiti visoweru handa aku Misri kuweriti na viboga, kawatumiti wana wakuwi, yani wambuyi wetu, wagendi aku Misri mala ya kwanja ");
INSERT INTO poy_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pamwanja gwawu gwa pili, Yosefu kalimaniziyiti kwa walongu wakuwi, na Farawu kaimaniti kaya ya Yosefu. ");
INSERT INTO poy_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosefu katumiti ujumbi kwa tati gwakuwi Yakobu na walongu woseri, wantu sabini na wamuhanu, wayizi Misri. ");
INSERT INTO poy_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Hangu, Yakobu kagenditi Misri kweni yomberi na wambuyi wetu wamonga wahowiti. ");
INSERT INTO poy_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Njimba zyawu wazijegiti mpaka Shekemu, yankusirwa palipumba Aburahamu lyakahemiriti kulawa kwa likabira lya Hamoli kwa shiasi tunga sha mpiya. ");
INSERT INTO poy_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Shipindi pashitimiyiti Mlungu kalitenda lagilu lyakampananiti Aburahamu, walanga ya wantu kulii Misri iyongerekiti kala na iweriti nkulu nentu. ");
INSERT INTO poy_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","“Upeleru, mfalumi yumu yomberi kammana ndiri Yosefu kanjiti kukolamlima aku Misri. ");
INSERT INTO poy_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kawatabisiyiti wantu wetu na kawatenderiti udoda wambuyi wetu pakawalagalira wawayasili kunja wananguta wawu wadidini su wahowi. ");
INSERT INTO poy_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Musa kayiwukiti shipindi ashi na kaweriti mwana kaherepa nentu. Yomberi kaleritwi mukaya ya tati gwakuwi kwa shipindi sha myezi mitatu, ");
INSERT INTO poy_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","na pawamlaviyiti kunja, binti gwa Farawu kamtoliti, kamlera gambira mwana gwakuwi. ");
INSERT INTO poy_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa kafundwa vitwatira vyoseri vya luhala lwa Wamisri kamanika kwa visoweru na manyawiru. ");
INSERT INTO poy_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Pakaweriti na umli wa vinja malongu msheshi kaamuwiti kugenda kuwawona walongu wakuwi Waisraeli.” ");
INSERT INTO poy_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","“Aku kamwoniti yumu gwawu kankumtendera vidoda, kagenda kumlopola na kwa kuwuzilira, kamlaga Mmisri ulii. ");
INSERT INTO poy_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kalisheriti handa Waisraeli wayaguwi mewavimani handa Mlungu kamtumiti yomberi kuwalopola, kumbiti kavimana ndiri hangu. ");
INSERT INTO poy_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Shilawu yakuwi, kawoniti Waisraeli wawili wankulikoma, kajeriti kuwakolaniziya mawoku pakalonga, Mwenga ndo mwawalongu, iwera hashi mwankulitenderana vidoda maweni kwa maweni ");
INSERT INTO poy_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ulii yakaweriti kankumkoma myaguwi kamkankiti Musa kumpeku kalonga, ndo gaa yakakutuliti gwenga guweri mtuwa na mkolaniziya mawoku gwetu? ");
INSERT INTO poy_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Hashi, gufira kunaga handa ntambu yagumlagiti Mmisri ulii lishu? ");
INSERT INTO poy_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pa kupikinira aga, Musa katugiti, kagenda kulivaga paisi ya Midiyani na aku kapata wana wawili. ");
INSERT INTO poy_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Vinja malongu msheshi pavitimiyiti, ntumintumi gwa kumpindi gwa Mtuwa kamlawiriti Musa pashitogolu shiweriti shankuyaka motu kushiwala kulii pakwegera na lugongu Sinayi. ");
INSERT INTO poy_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa kalikangasha nentu kuwona shitwatira ashi ata kasegelera pakwera su kasunguliri, kumbiti kapikiniriti liziwu lya Mtuwa, ");
INSERT INTO poy_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Neni ndo Mlungu gwa mbuyi gwaku, Mlungu gwa Aburahamu, Isaka na Yakobu! Musa kalendemera kwa lyoga na pota kujera kulola nentu. ");
INSERT INTO poy_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mtuwa kamgambira, Guyopoli vilwatu vyaku mana panu pagugoloka ndo pahala pananagala. ");
INSERT INTO poy_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nugawona madoda gawawatendera wantu wangu kulii Misri. Mpikanira shiwembu shawu, naneni niza kuwalopola. Su vinu, hanukutumi Misri.” ");
INSERT INTO poy_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Musa ayu ndo ulii wantu wa Israeli yawamlemiti pawatakuliti, Ndo gaa yakakutuliti gwenga guweri mkolamlima na mwamuliru gwetu? Ndomweni yakajegitwi na Mlungu kaweri mkulu na mlopoziya, kwa liwoku lya ulii ntumintumi gwa kumpindi yakamlawiriti mushiputira shashiweriti shankuyaka motu. ");
INSERT INTO poy_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ndo yakawalongoziyiti wantu walii walawi Misri kwa kutenda mauzauza na makangashu paisi ya Misri, pabahali ya Shamu na kushiwala kwa katepu ya vinja malongu msheshi. ");
INSERT INTO poy_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa ndo yakawagambiriti wantu wa Israeli, Mlungu hakawasyagulirani mbuyi handa neni kulawa pawalongu wenu mwenga maweni. ");
INSERT INTO poy_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ayu ndo ulii yakaweriti mulijojiniru aku kushiwara pamuhera na watati wetu na ntumintumi gwa kumpindi ulii yakatakuliti na yomberi pamuhera na watati wetu mulugongu lwa Sinayi, na yomberi kawankiti visoweru vyaviwera na ukomu su katupanani twenga. ");
INSERT INTO poy_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Kumbiti yomberi ndo mbuyi gwetu yakalemiti kumpikinira, wamkangiti kumpeku, wana lwamatamata lwa kuwuya Misri. ");
INSERT INTO poy_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Wamgambiriti Aruni, gutunyawiri milungu yayitulongoziya munjira, toziya tuvimana ndiri yagampatiti Musa yakatulongoziyiti kulawa Misri! ");
INSERT INTO poy_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Su shiweriti shipindi womberi wanyawiti shinyagu sha mwana gwa ng'ombi. Womberi washilaviliriti tambiku na waviniti msambu kwa kuvipanana ligoya kwa vilii vyawavinyawiti kwa mawoku gawu. ");
INSERT INTO poy_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kumbiti Mlungu kawukiti pakati pawu, kawaleka waviguwiri vintu vya kumpindi kwa Mlungu, ntambu yailembitwi mushintola sha wambuyi wa Mlungu, ‘Mwenga wantu wa Israeli! Hashi, neni ndiri yamundaviliriti tambiku na malaviwu kwa shipindi sha vinja malongu msheshi kulii kushiwala? ");
INSERT INTO poy_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mwenga mshinyasuliti shisasa sha mlungu Moleki, na shinyagu sha ndondu mlungu gwenu Refani. Shinyagu shamshinyawiti ndo shamshiguwiriti. Toziya ayi hanuwajegi lopola kutali kupitira Babiloni!’” ");
INSERT INTO poy_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kushiwala kulii wambuyi wetu waweriti na lihema liii lilipitawuliti kuwera kwa Mlungu. Lyalinyawitwi handa Mlungu ntambu yakamgambiriti Musa kalinyawi, nakala kamili ya shiraa shakalanguziyitwi. ");
INSERT INTO poy_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Shakapanu wambuyi wetu waliyangiti womberi kwa womberi mpaka shipindi sha Yoshuwa, pawainyasuliti isi ilii kulawa kwa maisi geni Mlungu kagawingiti kuulongolu kwawu. Panu lilikaliti mpaka shipindi sha Dawudi. ");
INSERT INTO poy_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawudi kawupatiti upendelewu kwa Mlungu, kamluwa Mlungu kamlekeziyi su kamnyawiri pahala pa kulikala, ulii yakaweriti Mlungu gwa Yakobu. ");
INSERT INTO poy_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kumbiti Selemani ndo yakamnyawiriti numba Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ata hangu, Mlungu mkulu hakatami ndiri munumba zijegitwi na muntu, mbuyi ntambu yakatakula, ");
INSERT INTO poy_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Mtuwa kalonga, kumpindi ndo shibanta shangu sha ufalumi na pasipanu ndo pahala pangu pa kutulira magulu. Mtuwa kalonga, “Hashi mwenga hamunyawili numba ya ntambu gaa?” Ama pahala paneni pakwoyera hapaweri koshi? ");
INSERT INTO poy_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Hashi, mawoku gangu ndiri yaganyawiti vintu vyoseri avi?’ ");
INSERT INTO poy_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Mwenga makaidi wakulu! Myoyu na makutu genu ndo handa ga wantu wa maisi. Mwenga handa wambuyi wetu. Mashaka goseri mwankumlema Rohu Mnanagala. ");
INSERT INTO poy_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Hashi, kwana mbuyi yoseri gwa Mlungu, wambuyi wenu wawatabisiya ndiri? Wawalagiti walii yawatungiti kwiza kwakuwi yakamfiriziya Mlungu. Na vinu, mwenga mumgalambuka na mumlaga. ");
INSERT INTO poy_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mwenga muliyangiti lilagaliru ilii lijegitwi kwamwenga na wantumintumi wa kumpindi, kumbiti mnjimira ndiri.” ");
INSERT INTO poy_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wazewi walii wa shizyungu pawapikiniriti aga, wakalaliti nentu, wamsagira menu kwa maya. ");
INSERT INTO poy_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kumbiti Stefani kaweriti kamemitwi na Rohu Mnanagala, kalola kumpindi kwa Mlungu, kawona ukwisa wa Mlungu na Yesu kalivaga uwega wa kumliwu wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Katakula, “Mloleni! Mona kumpindi kuyoposolekwa na Mwana gwa muntu kagoloka uwega wa kumliwu wa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Panu, wantu woseri mushikawu shiraa sha shizyungu wabotanga umatu na kuziba makutu gawu kwa mawoku gawu. Shakapanu wamkopokela woseri pamwera, ");
INSERT INTO poy_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","wamlaviya kunja kulushi, wamguma mabuwi. Walii wakapitawu wagatula mahabiti gawu pasi pa ulolera wa mntemba yumu litawu lyakuwi Sauli. ");
INSERT INTO poy_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Wendereyiti kumguma kwa mabuwi Stefanu aku pakawera kankumluwa Mlungu, “Mtuwa Yesu, guwanki rohu yangu!” ");
INSERT INTO poy_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kasuntama, kalira kwa liziwu likulu, “Mtuwa, nagushihola shidoda ashi kwawomberi.” Pakatakuliti hangu, kahowa. Sauli nayomberi kashiwoniti shitendu ashi sha kumlaga. ");
INSERT INTO poy_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sauli kashiwoniti shitendu ashi sha kumlaga Stefanu kuwera shiherepa. Lishaka ali shipinga sha wantu yawamjimira Yesu aku Yerusalemu lyanjiti kutabisiwa nakamu. Wantu woseri yawamjimira Kristu, paiwera ndiri hera wantumintumi walii, walazimikiti kugenda aku na aku na kweneya museemu zya malambu ga Yudeya na Samariya. ");
INSERT INTO poy_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Wantu watahoziwa wamsiri Stefanu, wamtenderi makiwa makulu. ");
INSERT INTO poy_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kumbiti Sauli kashiharabisiya shipinga sha wantu yawamjimira Yesu. Kingira kila numba na kuwakamula wapalu na wadala na kuwatula mushibetubetu. ");
INSERT INTO poy_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Walii wapalanganikiti wagenda aku na aku wankulibwelera shisoweru. ");
INSERT INTO poy_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipi kasuluka kingira lushi lwa Samariya, kawabwelera kuusu Kristu. ");
INSERT INTO poy_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na makutanu kwa nfiru yimu wapikinira visoweru vira vyakatakuliti na Filipi pawapikaniriti na kulola mauzauza gakagatenditi. ");
INSERT INTO poy_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Washamshera wadoda wawalawa wantu wavuwa pawagutanga, wantu wavuwa yawalewelekiti na vibyeketu, woseri waponiziwitwi. ");
INSERT INTO poy_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Iweri sekuseku ngulu pakati palushi lulii ");
INSERT INTO poy_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Muntu yumu, litawu lyakuwi Simoni, panu kwanja kaweriti pakanyawa uhawi pakati palushi palii, pakawakangasha wantu wa maisi ga Wasamariya, pakatakula paweri yomberi ndo muntu mkulu. ");
INSERT INTO poy_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Woseri wampikanira kwanjira mdidini ata mkulu, pawatakula, Muntu ayu ndo likakala lya Mlungu yakashemwa, likakala likulu. ");
INSERT INTO poy_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Wampikanira toziya kawakangashira kwa uhawi wakuwi kwa shipindi shitali. ");
INSERT INTO poy_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kumbiti pawamjimiriti Filipi, pakabwera visoweru viwagira vya ufalumi wa Mlungu, na litawu lyakuwi Yesu Kristu, wabatiziwa, wapalu na wadala. ");
INSERT INTO poy_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na yomberi Simoni mweni kajimiriti kubatizwa, walikola na Filipi, kalikangasha pakagawoniti makangashu na mauzauza makulu gagatendikiti. ");
INSERT INTO poy_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Wantumintumi yawaweriti Yerusalemu, pawapikaniriti kuwera Samariya washijimira Shisoweru sha Mlungu, womberi wawatumiti Peteru na Yohani, ");
INSERT INTO poy_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Womberi pawasokiti, wawaluwira wamwanki Rohu Mnanagala. ");
INSERT INTO poy_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kwa mana badu hakeniwasulukiri ata yumu gwawu, ila wabatiziwa hera kwa litawu lyakuwi Mtuwa Yesu. ");
INSERT INTO poy_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Watula mawoku gawu panani pawu, nawomberi wamyanga Rohu Mnanagala ");
INSERT INTO poy_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni pakawoniti kuwera wantu wankupananwa Rohu Mnanagala kwa kutulilwa mawoku ga wantumintumi, yomberi kafiruwiti kuwapanana mpiya pakalonga, ");
INSERT INTO poy_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Mmpanani neni uwezu awu, su kila muntu yanfira kumtulira mawoku gangu, kawanki Rohu Mnanagala. ");
INSERT INTO poy_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kumbiti Peteru kamwankula, gwagamiri kutali na mpiya zyaku toziya gulihola handa guweza kuhemera lifupu lya Mlungu kwa mpiya. ");
INSERT INTO poy_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Gwahera shifungu wala gwahera seemu pakati pashitwatira ashi, Toziya moyu gwaku guherepa ndiri kulongolu kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Su, guleki madoda gaku aga, gukamluwi Mtuwa, na yomberi kaweza kukulekeziya maholu gaku aga. ");
INSERT INTO poy_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kwa mana nukuwona handa gumema weya nentu na gwa mtatilwa gwa vidoda. ");
INSERT INTO poy_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni kankula, pakatakula, munduwili mwenga kwa Mtuwa, nashiza kumpata shoseri pakati pa aga gamtakuliti. ");
INSERT INTO poy_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Peteru na Yohani pawabweriti kala kuusu Mtuwa, wawuya Yerusalemu. Wabweriti shisoweru shiwagira pakati pavijiji vya Samariya. ");
INSERT INTO poy_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ntumintumi gwa kumpindi gwa Mtuwa katakula na Filipi, kamgambira, Guwuki ugendi ouwega wa kusika ata njira ilii yailawa Yerusalemu kugenda Gaza, njira ayi ipita kushiwala. ");
INSERT INTO poy_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nayomberi kawuka, kagenda, shipindi shirashi kuweriti na Mwisiopiya yumu, towashi, mweni kaweriti kamumwanja kugenda ukaya. Muntu ayu kaweriti mkolamlima kamanika gwa luhanja lwa Kandaki, malikiya gwa Esiyopiya. Kaweriti kagenda aku Yerusalemu kuguwira na shipindi ashi kaweriti kankuwuya pakawera kakwena mbutuka ya kunika. ");
INSERT INTO poy_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Pakaweriti kammwanja, kaweriti kankushibetula shintola sha mbuyi gwa Mlungu Isaya. ");
INSERT INTO poy_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Rohu kamgambira Filipi, Gusegeleri pakwegera na mbutuka ayi, gulikoliri nayi. ");
INSERT INTO poy_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Su Filipu kagenda mbiru, kampikanira kankubetula mushintora sha Isaya mbuyi gwa Mlungu. Filipi kamkosiyiti, “Hashi, gugamana aga gagubetula?” ");
INSERT INTO poy_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Yomberi kamwankuliti, “Hanwezi hashi kugamana pota muntu gwa kuntakulira?” Shakapanu yomberi kamluwiti Filipi kakweni na kulivaga pamuhera na yomberi mumbutuka. ");
INSERT INTO poy_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na shifungu sha Malembu Mananagala gakaweriti kankugabetula ndo aga, “Kalongolerwa kugenda kwawahanjanga handa kondolu, Na handa vila mwana kondolu kajii paulongolu pakuwi yakamdumula mbapatiru, Ndambu irayi yomberi kagubutula ndiri mlomu gwakuwi. ");
INSERT INTO poy_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Wamsoniziyiti na kunyima shakafiruwa. Kwahera yakaweza kuyowera kuusu shiyiwuku shakuwi. Kwa mana ukomu wakuwi uwusiwa pasipanu.” ");
INSERT INTO poy_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Afisa ulii kamwankula Filipi, katakula, nukuluwa, mbuyi ayu, katakula visoweru avi kwa visoweru vya gaa, ndo visoweru vyakuwi mweni ama vya muntu mmonga ");
INSERT INTO poy_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipi kanjiti kutakula, kanjiti kwa Malembu Mananagala galaa aga, kamgambiriti yomberi Shisoweru Shiwagira sha Yesu. ");
INSERT INTO poy_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pawaweriti wankali wakwendereya na mwanja, wasokiti pahala pana mashi, na afisa ulii katakula, “pahala panu pana mashi, kwana shoseri sha kunewelera nambatizwa?” ");
INSERT INTO poy_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipu katakula, Pagujimira kwa moyu gwaku goseri, iwezikana. Kankula, kalonga, njimira handa Yesu Kristu ndo Mwana gwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kaamuli mbutuka ilii igoloki, wasuluka woseri wawili mmashi, Filipi na towashi ulii, nayomberi kambatiza. ");
INSERT INTO poy_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Shakapanu, pawakweniti kulawa mmashi, Rohu gwa Mtuwa kamnyasula Filipi, towashi ulii hapani kamwoni kayi, su kagenditi zakuwi kasekuseku. ");
INSERT INTO poy_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Kumbiti Filipi kawonikana pakati pa Azotu, na pakaweriti pakapita pakabwera shisoweru shiwagira pakati palushi yoseri, ata kingira Kaisariya. ");
INSERT INTO poy_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kumbiti Sauli, kazidi kutisha na kulihola kuwahowiziya wafundwa wa Mtuwa, kamgendera Mtambika Mkulu gwa Numba Ngulu ya Mlungu, ");
INSERT INTO poy_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","na mawankulu ga luhamba lwa kumaniziya kugenda kwa numba ya Mlungu kulii Dameski, su pakawona wantu wa njira ayi, wapalu kwa wadala, kawatawi na kuwajega Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kumbiti pakaweriti mnjira pakwegera kusoka Dameski, vumu gulangala koseri kulawa kuliyera. ");
INSERT INTO poy_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kaguwa pasi, na kapikanira liziwu lyakumgambira, “Sauli, Sauli! Iwera hashi guntabisiya?” ");
INSERT INTO poy_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Yomberi Sauli kakosiya, “Ndo gaa gwenga Mtuwa?” Nayomberi kamwankula, “Neni Yesu, mweni gwenga gumbeziyiti,” Liziwu lilonga. ");
INSERT INTO poy_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Kumbiti gugoloki na gugendi gwingiri mlushi na aku hagugambilwi shagufiruwa kutenda.” ");
INSERT INTO poy_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wantu walii yawaweriti wamwanja pamuhera na Sauli wagolokiti palii, waweriti wahera lya kutakula, wapikiniriti lilii liziwu kumbiti wamwona ndiri muntu. ");
INSERT INTO poy_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli kagolokiti, na pakatumuliti masu gakuwi, kumbiti hakeniwoni shintu shoseri, wantu walii wamlongolera kwa kumkola liwoku mpaka lushi lwa Dameski. ");
INSERT INTO poy_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sauli kalivagiti mashaka matatu pota kulola, na shipindi ashi kaliyiti ndiri ama kulanda shoseri. ");
INSERT INTO poy_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Su, aku Dameski kuweriti na mfundwa yumu yawamshema Ananiya. Mtuwa kamgambira mawonu, “Ananiya!” Yomberi kamwankula, “Na panu, Mtuwa”. ");
INSERT INTO poy_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mtuwa kamgambira, Gugoloki, gugendi kwana njira yayishemwa longulongu, munumba ya Yuda gumkosiyi muntu kulawa Tarisu yawamshema Sauli, vinu kankuluwa, ");
INSERT INTO poy_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","na mumawonu kawona muntu wamshema Ananiya kingira munumba na kumtulira mawoku su kapati kulola kayi. ");
INSERT INTO poy_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiya kankula, “Mtuwa, mpikanira shisoweru sha muntu ayu kulawa kwa wantu wavuwa, mpikanira kuusu madoda gakawatendiriti wantu waku aku Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na kiza panu kaweri na utuwa kulawa kwa Watambika Wakulu kuwatula mlikakala woseri yawalishemera litawu lyakuwi.” ");
INSERT INTO poy_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kumbiti mtuwa kamgambira Ananiya, “Gugendi hera, toziya numsyagula kaweri shombu shaneni, kalibweri litawu lyangu kwa maisi na wafalumi wawu kwa wantu wa Israeli.” ");
INSERT INTO poy_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","“Neni namweni hanumlagiziyi gavuwa kwa ntambu ya litawu lyangu.” ");
INSERT INTO poy_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Su, Ananiya kagenda kingira mnumba. Shakapanu katula mawoku gakuwi pampindi pa Sauli, katakula, “Mlongu Sauli, Mtuwa Yesu, yakakulawiriti paweriti mnjira kankwiza panu, kanduma neni su gupati kulola kayi na kumemiziwa Rohu Mnanagala.” ");
INSERT INTO poy_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mala, vintu gambira mabaku gatuluka kulawa mmasu mwa Sauli, na kaweza kulola kayi. Kagolokiti na kubatizwa, ");
INSERT INTO poy_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","na pa kuliya shiboga, likakala lyakuwi limwuyira. Sauli katamiti mashaka madidini pamuhera na wafundwa aku Dameski. ");
INSERT INTO poy_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Mala kanjiti kubwera pakati pa numba ya Mlungu handa Yesu ndo Mwana gwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Wantu woseri wampikiniriti walikangasha, watakula, “Hashi, muntu ayu ndo ulaulii yakawahoziyiti walii waweriti wankuluwa kwa litawu ali kulii Yerusalemu? Kayi kiziti panu kaweriti na nfiru ya kuwatula mlikakala wantu hawa na kuwajega kwa Watambika Wakulu!” ");
INSERT INTO poy_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ata vinu Sauli kazidi kupata makakala, na kwa ntambu handa Yesu ndomweni Kristu, Wayawudi wa aku Dameski wapalanganikiti nakamu. ");
INSERT INTO poy_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pa mashaka gavuwa gapititi. Wayawudi wajojinikiti na kutenda mpangu gwa kumlaga Sauli. ");
INSERT INTO poy_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kumbiti Sauli kapatiti shisoweru sha mpangu hagu. Paliwala na pashiru waloliriti milyangu gwa kwingira mlushi lulii wapati kumlaga. ");
INSERT INTO poy_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kumbiti shipindi sha pashiru wafundwa wakuwi wamtoliti, wamsulusiya pasi mnumba kwa lijamanda likulu kwa kupitira lupenyu lwaluweriti mshibambaza. ");
INSERT INTO poy_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli pakasokiti Yerusalemu kajeriti kuliwunga na walii wafundwa. Kumbiti woseri wamtiriti, waweziti ndiri kujimira handa yomberi kaweriti ntumintumi. ");
INSERT INTO poy_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kumbiti Barinaba kiziti kumtola Sauli, kamjega kwa wantumintumi na kawagambira ntambu Sauli pakamwoniti Mtuwa munjira, na ntambu Mtuwa pakayoweriti nayomberi. Kawagambiriti viraa ntambu Sauli pakaweriti kankubwera kwa litawu lya Yesu pota lyoga Dameski kulii. ");
INSERT INTO poy_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Su, Sauli kalivaga pamuhera na womberi katyangira Yerusalemu yoseri kankubwera shisoweru sha Mtuwa pota lyoga. ");
INSERT INTO poy_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Vilaa kayowiriti na kukakatala na Wayawudi wawatakula Shigiriki, kumbiti womberi wajeriti kumlaga. ");
INSERT INTO poy_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Walongu walii pawayambuliti shitwatira ashi, wamtoliti Sauli, wamjega Kaisariya, wamleka kagendi zakuwi Tarisu. ");
INSERT INTO poy_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Shakapanu shipinga sha wantu yawamjimira Yesu, shiweriti na ponga poseri Muyudeya na Galilaya na Samariya. Shitulitwi makakala na shyendereyiti kulikala mukumguwira Mtuwa na kupananwa moyu na Rohu Mnanagala, mawalangu ga shipinga ashi shyongerikiti. ");
INSERT INTO poy_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peteru pakaweriti mwanja kila pahala kasokiti viraa kwa wantu wa Mlungu yawaweriti walivaga Lida. ");
INSERT INTO poy_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Haku kamwoniti muntu yumu yawamshema Aineya ndomweni kwa shipindi sha vinja vinane kaweriti kagonja mshitanda toziya kaweriti kuleweleka. ");
INSERT INTO poy_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peteru kamgambira, Aineya, “Yesu Kristu kakuponiziya, Guyumuki gutandiki shitanda shaku.” Su Aineya kayumuka. ");
INSERT INTO poy_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wenikaya woseri wa Lida na Sharoni wamwoniti Aineya, na woseri wamwuyira Mtuwa. ");
INSERT INTO poy_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kuweriti na mfundwa yumu mdala, mlushi lwa Yopa, wamshema Tabita kwa Shigiriki ndo Dorikasi mana yakuwi, mbawala. Mdala ayu kaweriti kankutenda viheri na kuwatanga wahushu. ");
INSERT INTO poy_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Shipindi ashi payiwera handa kalwala, na kuhowa. Wantu wayigulula nshimba yakuwi, wayigonjeka mushumba mgolofa. ");
INSERT INTO poy_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa patali ndiri na Lida, wafundwa pawapikaniriti handa Peteru kaweriti Lida, watuma wantu wawiri kwakuwi na ujumbi, “Gwizi kwatwenga kanongola.” ");
INSERT INTO poy_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Su, Peteru kagenda pamuhera nawomberi. Pakasokiti kajegitwi mgolofa ilii mushumba. Aku wakenja wavuwa wamtindira Peteru wankulira na kumlanguziya makoti na nguwu ndozyeni Dorikasi kaweriti kankuzinyawa shipindi pakaweriti mkomu. ");
INSERT INTO poy_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peteru kawalaviyiti kunja woseri, kasuntama, kamluwa Mlungu. Shakapanu kayigalambukira ira nshimba ya ulii yakahowiti, kalonga, “Tabita, Gyumuki.” Nayomberi katumula masu gakuwi, ");
INSERT INTO poy_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peteru kamtanga kugoloka, shakapanu kawashema wantu walii wa Mlungu na walii wakenja, kawayupa pakawera mkomu. ");
INSERT INTO poy_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Shisoweru sha shitwatira ashi shivuwiti kila pahala aku Yopa, na wantu wavuwa wamjimira Mtuwa. ");
INSERT INTO poy_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peteru kalivagiti mashaka gamu aku Yopa, katama kwa muntu yumu mnyawa gwa lukuli yawamshema Simoni. ");
INSERT INTO poy_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kuweriti na muntu yumu aku Kaisariya wamshema Korineliwu, jemidali gwa shikosi shimu shawashishema, “Shikosi sha Italiya.” ");
INSERT INTO poy_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kaweriti muntu muheri, yomberi pamuhera na kaya yakuwi yoseri yawamfatiti Mlungu, kaweriti kankutenda gavuwa kuwatanga wahushu wa Shiyawudi na kaweriti kankumluwa Mlungu nentu. ");
INSERT INTO poy_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Paweriti saa tisa paliwala, kawoniti nakaka ntumintumi gwa kumpindi gwa Mlungu kingira mngati na kumgambira, “Korineliwu!” ");
INSERT INTO poy_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","“Kamkwenjulira masu lahoka ayu kwa lyoga, kamgambira, Kwana shishi, mtuwa?” Lihoka ayu kamgambira, “Mlungu kaziyanga sala na vijungu vyaku kwa wahushu wala hapeni kaliwaluwi. ");
INSERT INTO poy_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Vinu guwatumi wantu Yopa wakamshemi muntu yumu wamshema Simoni, kwa litawu lyamonga Peteru. ");
INSERT INTO poy_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yomberi muhenga munumba mwa mnyawa gwa lukuli wamshema Simoni, yakalikala pakwegera na litanda.” ");
INSERT INTO poy_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pakatakuliti aga, ntumintumi gwa kumpindi ulii kawuka, Korineliwu kawashemiti wandundami wawili wa numba na yumu gwa wanjagila wakuwi kaweriti kamguwira Mlungu, ");
INSERT INTO poy_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","kamgambiziya goseri yagalawiriti, na kawatuma Yopa. ");
INSERT INTO poy_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Shirawu yakuwi, wantu watatu pawaweriti wankali mumwanja na pakwegera kwingira Yopa, Peteru kakweniti pampindi pa shitwiku sha numba iweriti saa sita paliwala su kamluwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kiwiti na njala nentu na kafiriti kuliya shiboga, shiboga pashiweriti shankutandilwa, kalota. ");
INSERT INTO poy_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kawoniti mpindi zivungulwa na shintu handa lishuka likulu lisulusiwa pasi liweriti likolelwa wega zyakuwi msheshi. ");
INSERT INTO poy_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kuweriti na kila ntambu zya vigongolu, njoka na wambongu. ");
INSERT INTO poy_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kapikanira liziwu limgambira, “Peteru, gwimuki gulikituli, guliyi!” ");
INSERT INTO poy_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kumbiti Peteru kankula, “ndala, Mtuwa, neni ndawalira ndiri shoseri shana uhumba na shifa ndiri kuliya” ");
INSERT INTO poy_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Liziwu lilii lipikanika kayi limgambira, “Naguvishema vihumba viboga, Mlungu kavipunga!” ");
INSERT INTO poy_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Shitwatira ashi shitendikiti mala ntatu shakapanu lishuka lilii liwuziwa kunani kumpindi. ");
INSERT INTO poy_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peteru pakaweriti kankulikangasha kuusu mana ya maonu aga yagaweriti kagawona, wantu walii wawatumitwi na Korineliwu, pawayambuliti kala njira ya kugenda kunumba ya Simoni, wasokiti pamlyangu gwa libambaza, ");
INSERT INTO poy_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Na wakosiya, “handa kwana mhenga amu yawamshema Simoni Peteru.” ");
INSERT INTO poy_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peteru kaweriti kankali kankulihola kuvimana kuusu maonu, na panu Rohu kamgambira, “kwana wantu wankukusakula ");
INSERT INTO poy_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gusuluki kanongola na pota naguwera na lyoga kugenda pamuhera nawomberi kwa mana ndo neni yanuwatumiti.” ");
INSERT INTO poy_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Su, Peteru kasuluka pasi, kawagambira wantu walii, “Neni ndo yamnsakula. Mwizira shishi?” ");
INSERT INTO poy_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Womberi wamwankula, “Mnjagira Korineliwu mweni ndo muntu mheri, mguwira Mlungu na kagohereka pawulongolu pa Wayawudi woseri, katutuma. Kagambirwa na ntumintumi gwa kumpindi mnanagala kakushemera ukaya kwakuwi su kapikaniri shisoweru shaguweri nashu sha kutakula.” ");
INSERT INTO poy_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Peteru kawashemera mnumba, kawapanana pakugonja pashiru palii. Shirawu yakuwi, Peteru kanja mwanja pamuhera nawomberi, na wamonga wa walongu wa Yopa aku walikoliti nayomberi. ");
INSERT INTO poy_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lishaka lyalifatiti wayingiriti Kaisariya na aku Korineliwu kaweriti kankuwahepera pamuhera na walongu na waganja yakaweriti kawashemera. ");
INSERT INTO poy_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peteru pakaweriti kankuyingira, Korineliwu kalawiti kunja kumwanka, kasuntamala makukama pawulongolu pakuwi. ");
INSERT INTO poy_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kumbiti Peteru kamgolosiya, kamgabira, “Gugoloki, kwa mana neni ndo muntu hera.” ");
INSERT INTO poy_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Peteru kingira mnumba, pawaweriti kala wankuyowera na Korineliwu, wantu wavuwa waliwoniti amu. ");
INSERT INTO poy_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Peteru kawagambira, “Mwenga muvimana handa Myawudi yoseri kabelwa na malagaliru gakuwi ga dini kuwera pamuhera na wantu wa maisi gamonga. Kumbiti Mlungu kang'ambira hapeni numholeri muntu yoseri kiwa mhumba awu kadoda. ");
INSERT INTO poy_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Na shipindi pagumtumiti kwa neni, niziti pota kulema, nuwakosiyani, su kwa shishi gumtuma kwa neni.” ");
INSERT INTO poy_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korineliwu kalonga, “Mashaka matatu gapititi saa gambira ayi, saa tisa paliwala, neni panweriti nankumluwa Mlungu mnumba mwangu. Vumu, muntu yakaweriti kavala nguwu zing'ereng'eta kagolokiti kulongolu kwa neni, ");
INSERT INTO poy_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Katakula, ‘Korineliwu! Mlungu kapikanira kuluwa kwaku na tambuku yaku kwa wahushu. ");
INSERT INTO poy_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Gumtumi muntu Yopa kakamshemi muntu yawamshema Simoni Peteru, kwa litawu lyamonga Peteru, kawukaya kwa Simoni mnyawa gwa lukuli, yakalikala pakwegera na litanda.’ ");
INSERT INTO poy_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hangu nukutumiriti ujumbi pota kushelewa, nagwenga gutenda viheri kwiza. Vinu, twenga twapawulongolu pa Mlungu, kupikinira kila shintu Mtuwa kankutugambira.” ");
INSERT INTO poy_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Panu Peteru kanja kutakula, “Vinu nuvimana handa nakaka Mlungu kahera upendelewu. ");
INSERT INTO poy_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Muntu yoseri yakamguwira Mlungu na kutenda yagamfiriziya Mlungu hakaweri gwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Awu ndo ujumbi ulii Mlungu yakawujegiti kwa wantu wa Israeli, pakabwera Shisoweru Shiwagira shashijega ponga kwa njira ya Yesu Kristu, yomberi ndo Mtuwa gwa woseri. ");
INSERT INTO poy_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mwenga muvimana shitwatira shashilawiriti muisi yoseri ya Yudeya kwanjira Galilaya pa ubatizu ulii yakawubweriti Yohani. ");
INSERT INTO poy_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Muvimana Yesu gwa Nazareti na ntambu yakamsyaguliti kwa kummiminira Rohu Mnanagala na likakala. Mlungu kaweriti pamuhera nayomberi, yomberi kagenditi aku na aku pakatenda maheri na kuwaponiziya woseri yawaweriti wayingilwa na Mkondola, toziya Mlungu kaweriti na yomberi. ");
INSERT INTO poy_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Twenga ndo wapitawu wa vitwatira vyoseri vyakatenditi muisi ya Wayawudi na Muyerusalemu. Wamlagiti mlupingika. ");
INSERT INTO poy_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kumbiti Mlungu kamzyukisiyiti lishaka lya tatu, kamtenda kawoniki, ");
INSERT INTO poy_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","wamwoniti wantu woseri ndiri, ira kwa walii Mlungu yakawasyaguliti kala waweri makapitawu wakuwi, yani twenga yatuliyiti na kulanda pamuhera nayomberi pakazyuka kala kulawa kwawahowiti. ");
INSERT INTO poy_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Katugambiriti tubweri Visoweru viwagira kwa wantu woseri na kuwona handa yomberi ndo yakasyaguritwi na Mlungu kaweri Mtoza gwa yawawera wakomu na wahowiti. ");
INSERT INTO poy_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Wambuyi woseri wayoweriti kuusu yomberi handa kila muntu yakamjimira hakamlekiziyi vidoda vyakuwi vyoseri kwa litawu lyakuwi.” ");
INSERT INTO poy_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Shipindi Peteru pakaweriti kangali kankutakula visoweru avi, Rohu Mnanagala kawasulukiriti woseri wawaweriti wankupikanira ujumbi awu. ");
INSERT INTO poy_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wayawudi walii yawasokiti pamuhera na Peteru, walikangashiti kuwona Mlungu ntambu yakawamiminiriti shirupa sha Rohu Mnanagala wantu yawaweriti ndiri wayawudi, ");
INSERT INTO poy_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","mana yawapikaniriti pawayowera kwa likabira lihenga na pawamkwisa Mlungu. Peteru kalonga, ");
INSERT INTO poy_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Wantu awa wawamyanga Rohu Mnanagala gambira twenga ntambu yatumyangiti. Hashi, kwana yoseri yakaweza kuwalewelera kubatizwa kwa mashi?” ");
INSERT INTO poy_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Su, kawagambira wabatizwi kwa litawu lya Yesu Kristu. Shakapanu wamluwa kalikali nawomberi kwa mashaka madidini. ");
INSERT INTO poy_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Wantumintumi na walongu yawalikaliti Yudeya kulii wapikiniriti kuwera wantu yawawera ndiri Wayawudi viraa washiwankiti shisoweru sha Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Shipindi Peteru pakawuyiti Yerusalemu, walii wawayingiriti jandu, walikakatala na yomberi, ");
INSERT INTO poy_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Gwenga gugenda kulikala na wantu wangali kwingiziwa jandu na ata guliya pamuhera nawomberi! ");
INSERT INTO poy_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Panu Peteru kawagambira shinaga ubaga kuusu galii gagatendikiti tangu kwanjira.” ");
INSERT INTO poy_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Lishaka limu nweriti nankuluwa Mlungu mlushi Lwa Yopa, moniti mawonu, moniti shintu gambira lishuka likulu lyankusuluka pasi kulawa kumpindi liweriti likolwa pembi zyakuwi msheshi, litulwa pambwega pangu. ");
INSERT INTO poy_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nzunguliriti mngati nweri mona vigongolu wana magulu msheshi, wavigongolu wa mushitogolu, wag'ongolu wawakwawa na wambongu wa kuliyera. ");
INSERT INTO poy_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Shakapanu mbikanira liziwu lyangung'ambira, ‘Peteru gwimuki, gulagi na guliyi!’ ");
INSERT INTO poy_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kumbiti neni pandakula, ‘ndala, Mtuwa! Mana shoseri shashiwera shihumba ama shidoda asheni yingiri mumlomu mwaneni.’ ");
INSERT INTO poy_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Liziwu lipikanika kayi kulawa kumpindi, ‘naguvishema vihumba vintu Mlungu vyakavipungiti.’ ");
INSERT INTO poy_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Shitwatira ashi shitendikiti mala ndatu, na upeleru wakuwi viwusiwa kugenda kumpindi. ");
INSERT INTO poy_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Katepu hera, wantu watatu wawaweriti wawalagalira kwaneni kulawa Kaisariya wayingiriti kunumba kwanweriti nankulikala, wankulikala. ");
INSERT INTO poy_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Rohu kang'ambiriti ng'endi pamuhera nawomberi pota kutira. Walongu sita awa walikoliti pamuhera naneni, twingira mnumba ya muntu ulii. ");
INSERT INTO poy_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yomberi katugambiriti ntambu yakaweriti kamwona ntumintumi gwa kumpindi kagoloka ukaya kwakuwi na kumgambira, ‘Gumtumi muntu Yopa kakamshemi muntu yumu yawamshema Simoni Peteru. ");
INSERT INTO poy_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yomberi hakakugambiri ujumbi weni haukulopoziyi gwenga na kaya yaku yoseri.’ ");
INSERT INTO poy_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na pakanyanjiti kuyowera hera, Rohu Mnanagala kawasulukiriti gambira ntambu yakatusulukiriti twenga palii pakwanjira. ");
INSERT INTO poy_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Panu nuliholiti visoweru vilii Mtuwa ntambu yakatakuriti, ‘Yohani kabatiziti kwa mashi, kumbiti mwenga hamubatizwi kwa Rohu Mnanagala.’ ");
INSERT INTO poy_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Su, handa Mlungu kawapanana viraa wantu wa maisi gamonga shirupa shirashilii shakatupiti twenga patumjimiriti Mtuwa Yesu Kristu, hashi, neni ndo gaa ata panjera kumubera Mlungu!” ");
INSERT INTO poy_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pawapikaniriti aga, walekiti likakatala, wamkwisa Mlungu pawalonga, “Mlungu kawapanana wantu yawawera ndiri Wayawudi lupenyu lwa kuleka vidoda wapati ukomu!” ");
INSERT INTO poy_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kulawilirana na ndabiku yairawiliti shipindi Stefanu pawamlagiti, wawumini wapalasiwitwi. Wamonga wagenditi mpaka Foiniki, Kupiru na Antiokiya pawabwera ujumbi ulii kwa Wayawudi hera. ");
INSERT INTO poy_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kumbiti wamonga wa wantu yawamjimiriti Yesu yawalawiti Kupiru na Kureni, wagenditi Antiokiya pawawubwera ujumbi kwa wantu yawawera ndiri Wayawudi, pawashibwera Shisoweru Shiwagira kuusu Mtuwa Yesu. ");
INSERT INTO poy_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mtuwa kawatangiti na wantu wavuwa wajimiriti na kumgalambukira Mtuwa. ");
INSERT INTO poy_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Shisoweru sha shitwatira ashi shipikanirika kwa shipinga sha wantu yawamjimira Yesu aku Yerusalemu. Hangu wamtuma Barinaba kagendi Antiokiya. ");
INSERT INTO poy_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pakasokiti aku na kuwona Mlungu ntambu yakawatekeleriti wantu, kanemeleriti na kawahimiziya woseri walikali muwuwaminika wawu kwa Mtuwa kwa Moyu gwawu goseri. ");
INSERT INTO poy_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barinaba kaweriti muntu muheri na kamemiti Rohu Mnanagala na njimiru, likundi likulu lya wantu likwegitwi kwa Mtuwa. ");
INSERT INTO poy_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Shakapanu, Barinaba kagenditi Tarisu kumsakula Sauli. ");
INSERT INTO poy_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pakamwoniti, kamjega Antiokiya. Nawomberi woseri wawili walikala mushipinga sha wantu yawamjimira Yesu kwa shinja shoseri pawafunda shipinga shikulu sha wantu. Antiokiya aku, ndo kwa mala ya kwanja, wafundwa washemitwi wantu yawamjimira Kristu. ");
INSERT INTO poy_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Shipindi shiraa shirii, wambuyi wa Mlungu wiziti Antiokiya kulawa Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yumu gwawu wamshema Agabu kagolokiti, na kwa makakala ga Rohu katungiti handa hakuweri na njala ngulu muisi yoseri. Njala ayi ilawiriti shipindi sha ukola mlima wa Klawudi. ");
INSERT INTO poy_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Wafundwa walii waamuwiti kila yumu kwa ntambu ya uwezu wakuwi kajegi shoseri su kuwatangitira walongu walii wawaweriti wankulikala Yudeya. ");
INSERT INTO poy_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Watenda hangu, shakapanu, na kuwapanana mpiya wazewi wa Ludewa lwa Barinaba na Sauli. ");
INSERT INTO poy_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Pakwegera shipindi shiraa shilii, mfalumi Herodi kanjiti kuwatabisiya wantu wamu yawamjimira Kristu. ");
INSERT INTO poy_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kamlagiti kwa upanga Yakobu, mlongu gwakuwi Yohani. ");
INSERT INTO poy_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Pakawoniti handa shiweri shitendu ashi shiwafiriziyiti Wayawudi, kendeleyiti, kamubata Peteru. Ashi shitendikiti shipindi sha msambu gwa libumunda lyangali kutulwa simika. ");
INSERT INTO poy_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pamberi pakumkamla, Peteru katatilwa mshibetubetu, katulwa pasi pa mlolera gwa vipinga vyamsheshi vya wanjagila wamsheshi wamsheshi. Herodi kafiriti kumtula paweru pagupititi msambu gwa Pasaka. ");
INSERT INTO poy_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Su, Peteru pakaweriti mushibetubetu, kumbiti wantu wa shipinga sha wantu yawamjimira Yesu waweriti wankumluwira kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pashiru pamberi pa lishaka lilii lyeni Herodi hakamlaviyi Peteru paweru, Peteru kaweriti kagonja pakati pa wanjagila wawili wawili. Kaweriti kayopwa minyololu miwili, na walolera waweriti wankulolera mlyangu gwa shibetubetu. ");
INSERT INTO poy_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Vumu, ntumintumi gwa kumpindi gwa Mtuwa kagoloka pakwegera nayomberi na uweru ulangala mshumba mshibetubetu. Ntumintumi gwa kumpindi kamshinkula Peteru mluwavu kamyumusiya pakatakula, “Guwuki kanongola!” Kamukamu minyololu ilii yayitawitwi mmawoku idumuka na ituluka pasi. ");
INSERT INTO poy_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Shakapanu ntumintumi gwa kumpindi kamgambira, “Gulitawi mshipi gwaku, guvali vilwatu vyaku.” Peteru Katenda hangu. Shakapanu Ntumintumi gwa kumpindi ayu kamgambira, “Guvali likoti lyaku, gunfati.” ");
INSERT INTO poy_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peteru kamfata kunja kumbiti kavimana ndiri handa aga gagatenditwi na ntumintumi gwa kumpindi ayu gaweriti ga nakaka, kalihola kaweriti kankulota mumbota. ");
INSERT INTO poy_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wapititi shituwu sha kwanja sha kulolilera na sha pili, shakapanu wasoka kumlyangu gwa kwingilira mlushi. Hangu mlyangu guwavugukira, nawomberi walawa kunja. Waweriti wankugendagenda munjira yimu su ntumintumi gwa kumpindi ulii kamleka Peteru. ");
INSERT INTO poy_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Panu Peteru ndo kavimaniti yagalawiriti, katakula, “Vinu nuvimana nakaka handa Mtuwa kamtuma ntumintumi gwakuwi gwa kumpindi kanopoziyi mumawoku mwa Herodi na kulawa muvitwatira vilii vyoseri Wayawudi watumbiriti galawili.” ");
INSERT INTO poy_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pakavimaniti hangu kagenditi kanongola mpaka ukaya kwa Mariya mawu gwakuwi Yohani Mariku, Amu wantu wavuwa waweriti wajojinika pawaluwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peteru kapiga hodi kumlyangu gwa kunja, na ntundami yumu litawu lyakuwi Roda kagenda kumlyangu kwitikira. ");
INSERT INTO poy_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mhinja kalimaniti liziwu lya Peteru kanemelera nentu, Mhinja ulii kawuya utuga bila kuvugula Mlyangu na kuwagambira handa Peteru kaweriti kagoloka kunja kumlyangu. ");
INSERT INTO poy_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wamgambira mhinja ulii, “Gwana lukwali!” Kumbiti yomberi kakazaniyiti handa iweriti nakaka. Nawomberi wamgambira, “Ayu ndo ntumintumi gwa kumpindi gwakuwi.” ");
INSERT INTO poy_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Shipindi ashi Peteru kaweriti kendeleyiti kupiga hodi. Upeleru wavugula mlyangu, wamwona, walikangasha. ");
INSERT INTO poy_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peteru kawapungira liwoku walikali jiii, na kawagambira Mtuwa ntambu yakamlaviyiti mshibetubetu. Kawagambira walaviyi shisoweru sha shitwatira ashi kwa Yakobu na walii walongu wamonga, shakapanu kalawa kagenda pahala pingikayi. ");
INSERT INTO poy_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pawushiyiti, lilawiriti lyoga likulu pakati pa wanjagila walii kuusu yagaweriti gamlawiriti Peteru. ");
INSERT INTO poy_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodi kaamuwiti wagutendi msaku kumbiti waweza ndiri kumpata. Hangu kaamuwiti wanjagila walii wawakosiyi, kalagalira wawalagi. Shakapanu kalawa aku Yudeya, kagenda Kaisariya kalikaliti kweni aku. ");
INSERT INTO poy_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodi kakalaziwitwi nentu na wantu wa Tiru na Sidoni. Kumbiti womberi wamjegiriti ujumbi. Nawomberi wafawulu kwanja kumpata Bilastu kaweri uwega wawomberi. Bilastu kaweriti mgolokera mkulu gwa ikulu ya mfalumi. Shakapanu, kamgendera Herodi wamluwa kuweri na ponga, kwa mana isi yawu ilitumbiriti isi ya mfalumi kwa shiboga. ");
INSERT INTO poy_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Lishaka limu lyalisyagulitwi, Herodi kaweriti kavala nguwu lasimi na kulivaga mushiti sha mfalumi, na kawabweliriti wantu. ");
INSERT INTO poy_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","“Ali ndo liziwu lya Mlungu, lya muntu ndiri.” ");
INSERT INTO poy_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pala panu ntumintumi gwa kumpindi gwa Mtuwa kamgusiya Herodi pasi toziya kampanana ndiri Mlungu nzyumi azi. Wamliya wasangu, kahowa. ");
INSERT INTO poy_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Shisoweru sha Mlungu shizidi kweneya na kukula. ");
INSERT INTO poy_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Pa Barinaba na Sauli kujimira utenderu wawu, walawiti kayi Yerusalemu, wamtola Yohani yawamshema viraa Mariku. ");
INSERT INTO poy_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mushipinga sha wantu yawamjimira Yesu aku Antiokiya kuweriti na wantu wamonga yawaweriti wambuyi wa Mlungu na wafunda, muwamu kaweriti Barinaba, na Simoni yawamshema viraa Nigeri, na Lukiu gwa Kureni, Sauli na Manaeni ndo yomberi kaleritwi pamuhera na mfalumi Herodi. ");
INSERT INTO poy_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pawaweriti wankutenda ibada yawu kwa Mtuwa na koya kuliya, Rohu Mnanagala katakula, “Gunzyaguliri Barinaba na Sauli toziya ya lihengu lyanuwashemiriti.” ");
INSERT INTO poy_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Su, pawaluwiti Mlungu kala na koya kuliya, wawatulira mawoku, wawaleka wagendi zawu. ");
INSERT INTO poy_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barinaba na Sauli pawatumitwi kala na Rohu Mnanagala, wasulukiti mpaka Selewukiya, na kulawa aku wakweniti mtubwi mpaka shisiwa sha Kupiru. ");
INSERT INTO poy_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pawasokiti Salami wabweriti shisoweru sha Mlungu munumba za Wayawudi za kuluwira Mlungu, kwaniti Yohani Mariku pamuhera na womberi kutanga lihengu. ");
INSERT INTO poy_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wagendigenditi kulawa uwega wumu wa shisiwa mpaka Pafu, uwega wa pili, na aku wamwoniti mhawi yumu mbuyi gwa mpayu Myawudi yawamshema Baliyesu ndo kalipayiriti kawera mbuyi gwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kaweriti ganja gwa mkolamlima gwa shisiwa Serigiu Paulu, ndo yomberi kaweriti muntu mheri nentu. Serigiwu Paulu kawashemiti Barinaba na Sauli su kapikaniri shisoweru sha Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kumbiti ayu muhawi Elima, handa ntambu yakaweriti kashemwa kwa Shigiriki, kajeriti kuwaberibeziya su kumlewelera mkulu gwa shisiwa nakiza kugalambukira njimiru ya shikristu. ");
INSERT INTO poy_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Su, Sauli kamanikana kwa litawu lwa Paulu, pakawera kamema Rohu Mnanagala, kamkwenjulira masu mhawi ayu, ");
INSERT INTO poy_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Na kalonga, “Gwenga! Gwenga mwana gwa Mkondola! Gwenga gwa mngondu gwa shoseri shilii shashimfiriziya Mlungu, goya ndiri ata mala yimu kujera kuzipotiziya njira za Mtuwa zyazinyoshikiti. ");
INSERT INTO poy_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Vinu, liwoku lwa Mtuwa halikukomi, haguweri na lwisi na hapeni guwezi kuwona uweru wa mshenji kwa shipindi.” Katepu Elima masu gakuwi gadunuka kanja kugenda aku na aku pakasakula muntu gwa kumkola liwoku kamlonguziyi. ");
INSERT INTO poy_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mkola mlima ulii pakawoniti yagalawiriti, kajimiriti, kalikangashiti nentu mafundu gakapikiniriti kuusu Mtuwa. ");
INSERT INTO poy_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kulawa Pafu, Paulu na wayaguwi wagenda nyanyi mpaka Periga Mupamfiliya, kumbiti Yohani Mariku kawalekiti, kawuya Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Wanja kulawa Periga wasoka Antiokiya na Pisidiya, na Lishaka lya kwoyera wingiriti munumba ya Mlungu, walivaga. ");
INSERT INTO poy_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pawasomiti kala mushintola sha malagaliru ga Musa na mmalembu ga wambuyi, wakulu wa numba ya Mlungu wawajegiriti ujumbi awu, Walongu handa, mwanashi shitwatira sha kuwagambira wantu su waweri na moyu muwagambiri. ");
INSERT INTO poy_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Su, Paulu kagolokiti, kawapungira liwoku, kanja kulonga, “Wanalushi wa Israeli na Wayawudi ndiri yamwamuguwira Mlungu, mpikinilireni! ");
INSERT INTO poy_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mlungu gwa wantu wa Israeli kawasyaguliti wambuyi wetu na kuwatenda waweri lushi lukulu pawaweriti wahenga Misri kulii. Mlungu kawalaviyiti aku kwa likakala likulu. ");
INSERT INTO poy_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kawahepeleriti kwa shipindi sha vinja malongu msheshi kushiwala. ");
INSERT INTO poy_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kagaharibisiyiti maisi saba ga isi ya Kanaani kawayupa wantu wakuwi awa isi iweri yawu. ");
INSERT INTO poy_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Vinja mia msheshi na magumba muhanu gapititi, shakapanu kawapananiti watoza wawalongoziyi mpaka shipindi sha mbuyi gwa Mlungu Samweli. ");
INSERT INTO poy_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Panu wafiriti waweri na mfalumi na Mlungu kawayupa Sauli, mwananguta gwa Kishi gwa likabila lya Benjamini, kaweriti mfalumi gwawu kwa shipindi sha vinja malongu mhanu. ");
INSERT INTO poy_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pawamwusiyiti kala Sauli, Mlungu kumsaguliti Dawudi kaweri Mtuwa gwawu. Mlungu kalaviyiti shibali shakuwi kwakuwi pakalonga, ‘Numwoniti Dawudi mwananguta gwa Yese, muntu gwanumfira neni, muntu mweni hakatendi goseri galii nganfira kugatenda.’ ");
INSERT INTO poy_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kulawa mushiyiwuku sha muntu ayu, Mlungu kawajegera Waisraeli Mlopoziya mweni ndo Yesu ntambu yakalagiliti. ");
INSERT INTO poy_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pamberi pa Yesu kwanja lihengu lyakuwi, Yohani kawabweliriti wantu woseri wa Israeli handa mpaka waleki vidoda na wabatizwi. ");
INSERT INTO poy_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohani pakaweriti kankumalira ujumbi wakuwi kawagambiriti wantu, ‘Mlihola neni na gaa? Neni ndiri ulii yamumlolera. Mpikiniri! Ayu kamkwiza pa neni na neni nfiruwa ndiri ata kuziyopola ngoyi za vilwatu vyakuwi.’ ");
INSERT INTO poy_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Walongu, mwenga wamwera wananguta wa lukolu lwa Aburahamu, na woseri wawawera Wayawudi ndiri wamwamguwira Mlungu! Ujumbi awu wa ulopoziya ujegwa kwa twenga. ");
INSERT INTO poy_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Toziya wenikaya wa Yerusalemu na wakulu wawu wammana ndiri weri mlopoziya, wala wavimana ndiri visoweru vya wambuyi wa Mlungu vyawabetula kila lishaka lya kwoyera. Ata hangu, wavitenditi visoweru vya wambuyi vitimii kwa kumtoza Yesu kuhowa. ");
INSERT INTO poy_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Toziya wampatandiri na likosa lifiruwa wamlagi, wamluwiti Pilatu kamtozi wamlagi. ");
INSERT INTO poy_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pawatenditi kala goseri gawalembiriti kuusu yomberi, wamsusiyiti kulawa mlupingika, wamtula mlipumba. ");
INSERT INTO poy_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kumbiti Mlungu kamzyukisiyiti kulawa kwahowiti. ");
INSERT INTO poy_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Na kwa mashaka gavuwa kawalawiriti walii wawagenditi pamwera nayomberi kulawa Galilaya mpaka Yerusalemu. Awa ndo walii vinu makapitawu wakuwi kwa wantu wa Izraeli. ");
INSERT INTO poy_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na vinu Barinaba na neni twa panu kuwajegera mwenga Visoweru Viwagira. Lagilu la Mlungu kwa wambuyi wa twenga liwera nakaka mushipindi shetu, ");
INSERT INTO poy_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","kashitimiza vinu kwajili yatwenga wazukulu wawu kwa kumzyukisiya Yesu kulawa kwawahowiti. Handa ntambu yawalembiti muzaburi ya pili, ‘Gwenga gwa mwana gwangu, Neni lelu nwera tati gwaku.’ ");
INSERT INTO poy_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Na kwa kumzyukisiya kulawa kwawahowiti, hakenipati kayi kuwuya aku na kuwola, Mlungu katakuliti hangu, ‘Hanukutekeleri tekeleru nanagala na yanakaka Yanumwaiditi Dawudi.’ ");
INSERT INTO poy_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Yina, na Muzaburi zimonga kalonga, ‘Hapeni numuleki Mnanagala gwaku kawoli.’ ");
INSERT INTO poy_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Dawudi mweni katimiziti mafiliru ga Mlungu shipindi shakuwi, na shakapanu kahowa na kusilwa pakwegera na wazewi wakuwi, na nshimba yakuwi iwola. ");
INSERT INTO poy_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kumbiti ulii ndo Mlungu kamzyukisiyiti kulawa kwawahowiti hakenipati kuwola. ");
INSERT INTO poy_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Su muvimani walongu wangu, kuwera kupitira Yesu Ujumbi wa kulekiziya vidoda ubweritwi kwa mwenga, ");
INSERT INTO poy_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","na kila yumu yakamjimira Yesu wamlekeziya vidoda vyoseri, shitwatira sheni hapeni shiwezikani kwa njira ya malagaliru ga Musa. ");
INSERT INTO poy_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mlilolireni su, namwiza kupatwa na galii yagatakulitwi na wambuyi, ");
INSERT INTO poy_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Mloreni, mwenga mwanazarawu, Mlikangashi muhowi! Ndo shintu sheni hapeni mjimiri, Ata handa muntu pakawagambirani hapeni mjimiri.’ ” ");
INSERT INTO poy_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulu na Barinaba pawaweriti wankulawa mnumba ya Mlungu, wantu walii wawashemiti kayi lishaka lya kwoyera lyalifatiti, wayoweri nentu kuusu shitwatira ashi. ");
INSERT INTO poy_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kuliwona aku pakumalilikiti, Wayawudi wavuwa na wantu Wayawudi ndiri waweriti wingira dini ya Shiyawudi wawagendiriti Paulu na Barinaba. Wantumini awa wayoweriti nawa, wawatula moyu wendereyi kulikala walitumbiri manemu ga Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lishaka lya kwoyera paliweriti pakwegera, kila muntu mulushi lulii kiziti kupikinira shisoweru sha Mtuwa. ");
INSERT INTO poy_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Shipindi Wayawudi pawaliwoniti lipinga wantu wamemiti weya, walema shakaweriti katakula Paulu na kumwigilanga. ");
INSERT INTO poy_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kumbiti, Paulu na Barinaba wayoweriti kwa ugangamala nentu, watakula, “iweriti ndo mpaka shisoweru sha Mlungu shiwayiziri mwenga huti, kumbiti mushirema na kuwona mfiruwa ndiri ukomu wa mashaka goseri, su, tuwalekani na kuwagendera wantu wawawera Wayawudi ndiri. ");
INSERT INTO poy_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Toziya mtuwa katulagalira hangu, ‘Nukutula gwenga guweri gulangala kwa wantu wawawera Wayawudi ndiri Su guwajegeri wantu ulopoziwu pasipanu paseri.’ ” ");
INSERT INTO poy_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Wantu yawawera ndiri Wayawudi pawapikaniriti vitwatira avi wanemeleriti, waukwisa ujumbi wa Mtuwa, na walii yawasyagulitwi kupata ukomu wa mashaka goseri, wawera wantu yawamjimira Yesu. ");
INSERT INTO poy_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Shisoweru sha mtuwa shyeneya pahala poseri mumkowa gulii. ");
INSERT INTO poy_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kumbiti Wayawudi wawasongizira wadala wa shiwangu shikulu yawawera Wayawudi ndiri weni waweriti wamguwira Mlungu, na wapalu wamanikana wa lushi alu. Wayanja kuwabeza Paulu na Barinaba, wawawinga kulawa pahala pawu. ");
INSERT INTO poy_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Su, wafundwa wapunda lidiku liweriti mumagulu gawu kuwera likalipiru, shakapanu wagenda ikoniu. ");
INSERT INTO poy_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Wafundwa Muantiokiya waweriti wamema nemeleru na rohu munanagala. ");
INSERT INTO poy_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kulii Ikoniu, vitwatira viweriti handa vyaviweriti kulii Antiokiya, Paulu na Barinaba wagenditi munumba ya Mlungu gwa Shiyawudi wayowera kwa ugangamala ata Wayawudi wavuwa na Wagiriki wawera wajimira. ");
INSERT INTO poy_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kumbiti Wayawudi wamonga yawalemiti kuwera wawumini wasonguziya na kutula weya mmoyu mwa wantu yawawera wayawudi ndiri su wawakomi walongu awa. ");
INSERT INTO poy_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulu na Barinaba wendereyiti kulikala aku kwa shipindi shitali. Wayoweriti kwa ugangamala wa Mtuwa, na Mtuwa kalanguziya unakaka wa ujumbi yawaulaviyiti kwa manemu gakuwi, kwa kuwatenda watendi mauzauza na makangashu. ");
INSERT INTO poy_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Wantu wa lushi walekanikiti, wamonga wawajimiriti Wayawudi na wamonga waweriti uwega wa wantumintumi. ");
INSERT INTO poy_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Upeleru, wantu wamu yawawera ndiri Wayawudi, pamwera na wakulu wawu, wajumilirana kuwatendera vidoda ntumintumi awa na kuwagumanga mabuwi. ");
INSERT INTO poy_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ntumintumi pawayambuliti shitwatira ashi, watugiriti Listira na Deribi, mlushi lya lukaoniya, na museemu za pakwegera, ");
INSERT INTO poy_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","wawera wankubwera visoweru viwangira aku. ");
INSERT INTO poy_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kwaniti muntu yumu aku Listira mweni kaweriti shibyeketu gwa magulu kwanjira kwiwuka, na kaweriti hakenipati kugendagenda. ");
INSERT INTO poy_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Muntu ayu kaweriti kankumpikinira Paulu pakaweriti kankubwera. Paulu kamloliti dii, na pakawoniti keniti njimiru ya kuweza kuponiziwa. ");
INSERT INTO poy_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kalonga kwa liziwu likulu, “Gugoloki gugendigendi kwa magulu gaku!” Muntu ulii kagoloka, kanja kukopokakopoka na kugendagenda pahala palii. ");
INSERT INTO poy_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lipinga lya wantu pawawoniti shakatenditi Paulu, wanjiti kubotanga kwa likabira lya Likaoniya, “Milungu watwizira gambira muntu na watwizira pasi panu!” ");
INSERT INTO poy_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barinaba wamupa litawu zewu, na Paulu wamshema Herimesi, toziya yomberi ndo yakaweriti kankuyowera. ");
INSERT INTO poy_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na Mtambika gwa numba ya Zewu yayiweriti kunja kulushi kajega pongu na majenjeri ga mauwa kulongolu kumlyangu mkulu gwa lushi, yomberi pamwera na lipinga lya wantu wafiriti kuwatambikira wantumintumi. ");
INSERT INTO poy_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Barinaba na Paulu pawapatiti visoweru avi wapapuliti nguwu zawu na kutugira mulipinga lya wantu pawabota. ");
INSERT INTO poy_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Walongu, kwa shishi mtenda vitwatira vya ntambu ayi? Twenga viraa twa wantu gambira mwenga. Na twa panu kuwabwelera Shisoweru Shiwagira, mpati kuvileka vinyagu avi, mumgalambukiri Mlungu yakawera mkomu Mlungu yakanyawiti kumpindi na pasipanu, lbahali na vyoseri vyaviweramu. ");
INSERT INTO poy_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Makashu Mlungu kajimiriti kila Isi itendi ntambuyaifiriti. ");
INSERT INTO poy_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Kumbiti, Mlungu hakenileki kulilanguziya kwa vitwatira viheri vyakawatendera, kawatowera vula irawa kuliyera, kawayupa vimeru kwa shipindi shakuwi, kawayupa viboga na kuimemiziya myoyu yawu nemeru. ");
INSERT INTO poy_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Tembera watakula ntambu ayi Iweriti mbaka ndiri kuwalewelera wantu walii kotukuwatambikira. ");
INSERT INTO poy_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Wayawudi wamu wiziti kulawa Antiokiya na Ikoniu wawajega wantu pamwera nawomberi, wamgumi mabuwi Paulu na kumkwega mpaka kunja kulushi walongiti kahowa kala. ");
INSERT INTO poy_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kumbiti wafundwa pawajojinikiti na kumzyengeta kayumkiti kawuya mlushi. Shirawu yakuwi yomberi pamuhera na Barinaba wagenditi Deribi. ");
INSERT INTO poy_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pa Paulu na Barinaba kubwera visoweru viwagira aku Deribi na kuwapata wafundwa wavuwa, shakapanu wawuyiti Listira mpaka Ikoniu na Antiokiya Mupisidia. ");
INSERT INTO poy_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Wawayongiliriti likakala wafundwa na kuwapanana moyu wasigali munjimiru, wawagambira, “Ndo mpaka twawoseri twenga kupitira mutabu zivuwa su twingiri Muufalumi wa Mlungu, wafunditi.” ");
INSERT INTO poy_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Wawasyaguliti wazewi mukila shipinga sha wantu yawamjimira Yesu, na kwa kuluwa na kwoya kuliya wawatula pasi pa ulolera wa Mtuwa yawamjimiriti kwa maluwa na kwoya kuliya. ");
INSERT INTO poy_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pawapititi kala muisi ya Pisidiya, wasokiti Pamfiliya. ");
INSERT INTO poy_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Aku wabweriti ujumbi Muperiga. Na shakapanu wagenditi Ataliya, ");
INSERT INTO poy_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Na kulawa aku wawuyiti salama Antiokiya, kweni shipindi shipititi waweriti pasi pa ulolera wa manemu ga Mlungu kwa ajili ya lihengu lyeni vinu waweriti walimalira. ");
INSERT INTO poy_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pawasokiti Antiokiya, waliwoniti pamuwera na shipinga sha wantu yawamjimira Yesu na kuwagambira visoweru vya vitwatira vyoseri Mlungu vyakatenditi pamuhera na womberi, na ntambu yakawavuguliriti njira ya njimiru kwa wantu yawawera Wayawudi ndiri. ");
INSERT INTO poy_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Walikaliti pamuhera na wafundwa walii kwa shipindi shitali. ");
INSERT INTO poy_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Su, wantu wamu wasokiti Antiokiya kulawa Yudeya wanjiti kuwafunda walongu walii pawatakula, “Handa pamwingiziwa ndiri jandu kulawirana na Malagaliru Mlungu gakamupananiti Musa, hapeni mlopoziwi.” ");
INSERT INTO poy_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Shitwatira ashi shijegiti ukakatala mkulu, pa Paulu na Barinaba kulitakuziyana nawomberi, su womberi waamuwiti kuwera Paulu na Barinaba pamuhera na walongu wamu mushipinga sha wantu yawamjimira Yesu aku Antiokiya, wagendi Yerusalemu kuwawona wantumintumi na wazewi kuusu shitwatira ashi. ");
INSERT INTO poy_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Shipinga sha wantu yawamjimira Yesu shilongiti kwahere, nawomberi pawaweriti wankupitira Foiniki na Samariya wawagambiriti wantu yawawera Wayawudi ndiri ntambu yawamgalambukiriti Mlungu. Shisoweru ashi shiwaherepeziya nentu walongu woseri awa. ");
INSERT INTO poy_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pawasokiti Yerusalemu wawankwa na shipinga sha wantu yawamjimira Yesu pamuhera na wantumintumi na wazewi yawatakuliti kila shintu Mlungu shakatenditi pamuhera nawomberi. ");
INSERT INTO poy_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kumbiti wajimira wamonga wawaweriti wa shipinga sha mafalisayu wagolokiti, pawatakula, “Ndo mpaka wantu wa maisi gamonga wayigiziwi jandu na kufundwa kugafata malagaliru ga Musa.” ");
INSERT INTO poy_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Su wantumintumi na wazewi waliwoniti pamuhera kushilola weri shitwatira ashi. ");
INSERT INTO poy_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pawalitakuziyiti kwa shipindi shitali, Peteru kagolokiti kalonga, “Mwalongu wangu, mwenga muvimana handa tangu kwanja Mlungu kafiriti kuzyagula neni muwamu mwamwenga nuwabweleri Shisoweru Shiwagira, wantu yawawera ndiri Wayawudi wapati kupikinira na kujimira. ");
INSERT INTO poy_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na Mlungu yakavimana moyu gwa wantu, kalanguziya handa kawajimira kwa kuwayupa nawomberi Rohu Mnanagala handa yakatuyupiti twenga. ");
INSERT INTO poy_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Katubaguliti ndiri pakati petu na womberi, kayipungiti myoyu kwa njimiru. ");
INSERT INTO poy_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Vinu su, kwa shishi kumjera Mlungu kwa kuwapapiziya wafundwa awa visanka vyeni pota wambuyi wetu, pota twenga tuweza ndiri kulitwika? ");
INSERT INTO poy_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ndala! Tujimiriti na tulopoziwitwi kwa njira ya manemu ga Mtuwa Yesu.” Twengapa handa womberi. ");
INSERT INTO poy_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Shikundi shoseri shitamiti jii pawampikinira Barinaba na Paulu wankutakulira mauzauza na makangashu geni Mlungu kagatenditi pakati pawu wantu wawawera ndiri Wayawudi. ");
INSERT INTO poy_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pawamaliriti kuyowera, Yakobu kanjiti kulonga, “Mwalongu wangu, mumpikaniri! ");
INSERT INTO poy_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni katakuliriti Mlungu kwanjira kwanja ntambu yakalitendiriti na wantu yawawera ndiri Wayawudi, kasyagula wamonga wawu waweri wantu wakuwi. ");
INSERT INTO poy_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Visoweru vya Wambuyi wa Mlungu vyateratera nakamu handa Malembu Mananagala ntambu yagalonga, ");
INSERT INTO poy_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Mtuwa katakula, ‘Pa aga hambuyi Na kuuwuziya Ufalumi wa Dawudi Hanyawi pahala pakuwi Na kupagangamaziya kayi. ");
INSERT INTO poy_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Na wantu woseri, wantu yawawera ndiri Wayawudi nuwashemiti waweri waneni hawizi kwaneni. ");
INSERT INTO poy_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ndo ntambu yakatakula Mtuwa, yakatenditi shitwatira ashi kamanika kwanjira makashu.’ ");
INSERT INTO poy_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Hangu neni amuwa ntambu ayi, aga nuwalagalirani kotukuyumbisiya wantu wawawera ndiri Wayawudi wawamgalambukira Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Su tuwajegerani luhamba kuwagambira nawaliya viboga vyawayingiziyiti mnumba kwa kutambikira vinyagu vya wamlungu, walituli gweka na uhumba, nawaliya shigongolu yoseri yawammindula sungu, nawalanda mwazi. ");
INSERT INTO poy_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Malagaliru ga Musa gaweriti gabetulwa shipindi shitali munumba ya Mlungu kila lishaka lya kwoyera, na visoweru vyakuwi wavibwera mukila lushi.” ");
INSERT INTO poy_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Shakapanu wantumintumi na Wazewi, pamuhera na shipinga shoseri sha wantu yawamjimira Yesu, waamuwiti kuwasyagula wantu wamu pakati pawu na kuwatuma wagendi Antiokiya pamuhera na Paulu na Barisaba. Wawasyaguliti Yuda yawamshemiti viraa Barinaba na yumonga yakashemitwi Sila, wantu wawili yawaweriti walongoziya pakati pa walongu. ");
INSERT INTO poy_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Wawapananiti luhamba alu, “Twenga wantumintumi na wazewi, walongu wenu, twankuwalamsiya mwenga wantu wa maisi gamonga wa aku Antiokiya na Siriya na Kilikiya. ");
INSERT INTO poy_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tupikanira kuwera wantu wamonga kulawa aku wawagaziya kwa visoweru vyawu, wayitula myoyu ya mwenga mulyoga. Kumbiti watenda hangu pota ya luusa yoseri kulawa kwatwenga. ");
INSERT INTO poy_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Hangu, tuamuwa kuliwona pamwera kuwasyagula wantu wamu na kuwatuma kwamwenga pamwera na waganja wetu Barinaba na Paulu, ");
INSERT INTO poy_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","weni wafiriti wagamizii ukomu wawu kwa ntambu ya lihengu lya Mtuwa gwetu Yesu Kristu. ");
INSERT INTO poy_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Shakapanu tuwatuma Yuda na Sila kwamwenga, awa hawawagambirani weni aga gatugalembiti, ");
INSERT INTO poy_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Rohu munanagala na twenga tujimira kotukuwatwika visanka nentu ya vitwatira avi vya mana. ");
INSERT INTO poy_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Namliya viboga vyawatambikiriti shinyagu, namlanda mwazi, namliya vinofu vya shigongolu yawamuminduliti na mlikali weri na uhumba. Muwera mtenda viheri handa pamshapira kutenda vitwatira avi. Mwakashina.” ");
INSERT INTO poy_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Wajumbi awa wawatumiti wasoka Antiokiya kweni wawashemiti wawumini waliwoni, wawayupa luhamba alu. ");
INSERT INTO poy_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pawasomiti Luhamba alu, visoweru vyakuwi viwayupiti moyu, wanemeleriti nentu. ");
INSERT INTO poy_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila weni nawomberi waweriti wambuyi, wayoweriti na walongu awa kwa shipindi shitali wankuwayupa moyu na kuwagagamaziya. ");
INSERT INTO poy_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pawatamiti aku kwa shipindi tunga, walongu wa Antiokiya walonga kwaheri na kuwafilira ponga, shakapanu wawuya kwa wawatumiti walii. Malembu gamu gana shipandi ashi ");
INSERT INTO poy_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","kumbiti Sila kaamuwiti kusigala. ");
INSERT INTO poy_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulu na Barinaba wasigala Antiokiya kwa katepu, pawafunda na kubwera visoweru vya Mtuwa, pamwera na wantu wamonga watangala. ");
INSERT INTO poy_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pa mashaka gamu, Paulu kamgambiriti Barinaba, “Tuwuyi tukawatyangiri walongu walii mukila lushi patubweriti visoweru vya Mtuwa, tukaloli ntambu yawendereyiti.” ");
INSERT INTO poy_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barinaba kafiriti wamtoli viraa Yohani yawamshema Mariku. ");
INSERT INTO poy_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kumbiti Paulu kafiriti ndiri kumtola mariku, mweni pamberi kawalekiti Pamfiliya kulii na kulema kuwera pamwera mulihengu lyawu. ");
INSERT INTO poy_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Su, kulawira likakatala likulu pakati pawu, na walekana Barinaba kamtola Mariku, wakwena meli kugenda kupiru. ");
INSERT INTO poy_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nayomberi Paulu kamsyagula Sila, na pa walongu wa pahala panu kumtula pasi pa ulolera wa maheri ga Mtuwa. ");
INSERT INTO poy_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mumwanja agu kapitiriti Siriya na Kilikiya, pakavigangamaziya vipinga vya wantu yawamjimira Kristu, ");
INSERT INTO poy_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulu kaziti Deribi na Listira, kweni katamiti mfundwa yumu yawamshema Timotewu. Mawu gwakuwi mweni vira kaweriti ntundami, kaweriti Myawudi, kumbiti tati gwakuwi kaweriti mgiriki. ");
INSERT INTO poy_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timotewu kaweriti na nzyumi ngulu pakati pa walii walongu wa Listira na Ikoniu. ");
INSERT INTO poy_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulu kafiriti Timotewu kalikoli na yomberi mumwanja, hangu kamyingiziyiti jandu. Katenditi hangu toziya Wayawudi woseri watamiti seemu ayi wavimaniti handa tati gwakuwi Timotewu kaweriti Mgiriki. ");
INSERT INTO poy_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pawaweriti wankuwuya mlushi zilii wawapananiti wantu malagaliru galii gagalaviyitwi na wantumintumi na wazewi kulii Yerusalemu, wawagambira wantu wagajimiri. ");
INSERT INTO poy_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Su shipinga sha wantu yawamjimira Yesu shiziditi kugangamala munjimiru na shiyongerekiti nentu kila lishaka. ");
INSERT INTO poy_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Wawuyiriti Seemu za Firigiya na Galatiya toziya Rohu Mnanagala kawaluusu ndiri kubwera ujumbi awu kumkoa gwa Asiya. ");
INSERT INTO poy_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pawayiziti mumbaka zya Misiya, wajeriti kwingira kumkoa Bituniya, kumbiti Rohu gwa Yesu kawaluusu ndiri. ");
INSERT INTO poy_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Su, wapitiriti Misiya, wagenda longulongu mpaka Trowa. ");
INSERT INTO poy_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pashiru panu. Paulu kawoniti maonu geni kamwoniti muntu yumu gwa Makedoniya kagoloka palii na kumluwa, “Guloki, gwizi Makedoniya gwakatutangatiri.” ");
INSERT INTO poy_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Katepu pa Paulu kuwona maonu aga, tulitanditi kugenda Makedoniya pota kusherewa, tuwera na nakaka handa Mlungu katushema tuwabweleri shisoweru shiwagira. ");
INSERT INTO poy_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kulawa Trowa, twamwanja longulongu mpaka Samotiraki na Shirawu yakuwi tusulusiya nanga Neopoli. ");
INSERT INTO poy_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kulawa aku, tugenditi mpaka Filipi, Lushi lya Wilaya ya kwanja ya Makedoniya, na weni viraa ndo Koloni lya Warumi. Tutamiti mulushi alu mashaka gamu. ");
INSERT INTO poy_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Lishaka lya kwoyera tulawiti kunja ku Lushi, tugenda mmbeku ya lushemba lweni tulihola kuwera ndo pahala pa kuluwa Mlungu. Tulikaliti, tuyowera na wadala wajojinikiti pahala panu. ");
INSERT INTO poy_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Muwamu wa walii yawatupikiniriti kaweriti mdala yumu mguwira Mlungu yawamshema Lidiya mwenikaya gwa Tuatira, mweni kaweriti kankuwuza nguwu za shitani za langi ya zambalawu. Mtuwa kavuguliti moyu gwakuwi ata kaviyanga visoweru vilii Paulu vyakaweriti katakula. ");
INSERT INTO poy_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Shakapanu yomberi pamuhera na wantu wa numba yakuwi wabatizwa. Na yomberi katuluwa pakatakula, “Payiwera mjimira nakaka handa numjimira Mtuwa, mwizi ukaya kwaneni mlikali.” Katuhimiziya tugendi. ");
INSERT INTO poy_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lishaka limu, patuweriti twankugenda pahali pa kuluwa Mlungu, mhinja yumu yakaweriti na wamshera wana likakala lwa kutunga kaliwoniti na twenga Mhinja ayu kaweriti kankuwapanana watuwa wakuwi mpiya zitangala kwa kutunga gwakuwi. ");
INSERT INTO poy_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Su, muhinga ayu kamwiziriti Paulu na twenga, kabotanga na kutakula, “Wantu awa ndo wantumintumi wa Mlungu Mkulu. Wankuwabwelera njira ya ulopoziya.” ");
INSERT INTO poy_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kaweri kankutenda hangu kwa mashaka gatangala ata lishaka limu Paulu kakalariti, kamgalambukira na kumgambira shamshera ayu, “Nukugambira kwa litawu lya Yesu Kristu, gumlawi ayu!” Palaa palii shamshera kamlawa. ");
INSERT INTO poy_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Su watuwa wa muhinga ulii pawawoniti kuwera litumbiru lwawu lya kupata mpiya lipera, wawakamuliti Paulu na Sila, wawakwega mpaka paweru, kuulongolu kwa wakulu. ");
INSERT INTO poy_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Wasitaki kwa watoza pawatakula, “wantu awa ndo Wayawudi na watenda fuju mulushi lwetu. ");
INSERT INTO poy_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wankufunda shitiba sheni twenga wenikaya wa Rumi tuluusiwa ndiri kushijimira pota kushifuta.” ");
INSERT INTO poy_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Shipinga sha wantu shingiriti na womberi, shiwakomanga. Na watoza walii wawavula nguwa zawu kwa likakala, wahimiziya wasyatangwi viboku. ");
INSERT INTO poy_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pakukomwa nentu watatirwa mnumba, na njagira gwa shibetubetu kahimiziwa kuwatula pasi pa ulolera mkulu. ");
INSERT INTO poy_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kulawirana na malagaliru aga, mnjagira ayu kawatuliti mushumba kati nakamu sha shibetubetu na kugatawa magulu gawu mushibawu. ");
INSERT INTO poy_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pakakwegera na pashiru ligonu Paulu na Sila waweriti wankumluwa Mlungu na kuyimba nyimbu za kumzyuma Mlungu, aku watatirwa wamonga wawera wankupikanira. ");
INSERT INTO poy_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Vumu, kulawiriti lilendemeru likulu lya litapaka libegiziya liyanjiru lya shibetubetu. Su, milyangu yoseri ivuguka na minyololu yayiwatawiti watatirwa awa ilekana. ");
INSERT INTO poy_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mlolera gwa shibetubetu pakayumukiti na kuyiwona milyangu ya shibetubetu ivugulwa, kaliholiti handa watatirwa woseri waweriti watoloka, na hangu kausomola upanga wakuwi, kafiriti kulilaga. ");
INSERT INTO poy_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kumbiti Paulu kashema kwa liziwu likulu, “Kotukulitenda gwamweni toziya twenga twawoseri twa panu.” ");
INSERT INTO poy_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Pakamshemiti kala muntu kajegi limuliku, mnjagira gwa shibetubetu katugiriti mnumba, kaliyasa paulongolu pa magulu ga Paulu na Sila agawu kankulendemera kwa lyoga. ");
INSERT INTO poy_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Shakapanu kawalonguziya kunja, kawakosiya, “Mwatuwa, ndendi shishi mbati kulopoziwa?” ");
INSERT INTO poy_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Womberi wamwankula, “Gumjimiri Mtuwa Yesu na gwenga hagulopoziwi pamuhera na kaya yaku yoseri.” ");
INSERT INTO poy_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Su, wamubweleriti shisoweru sha Mtuwa yomberi pamhera na walongu wakuwi. ");
INSERT INTO poy_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mnjagira ulii kawatoliti saa iraa ilii ya pashiru kawagulula vironda vyawu, shakapanu yomberi na walongu wakuwi woseri kawabatiza pala palii. ");
INSERT INTO poy_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Shakapanu kawatola Paula na Sila ukaya kwakuwi, kawayupa shiboga. Yomberi na walongu wakuwi woseri watenda shereku toziya vinu waweriti wamjimira Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Shirawu yakuwi mandawira, watoza wawatumiti maafisa wawu pawalonga, “muwavuguliri wantu walii.” ");
INSERT INTO poy_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mjagira ulii gwa shibetubetu kamupananiti shisoweru Paulu, “Watoza watumiti ujumbi su mvugulilwi. Vinu muweza kulawa na kugenda zenu kwa ponga.” ");
INSERT INTO poy_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kumbiti Paulu kamwakuliti. “Eti shishi? Tembera tuweriti ndiri na likosa, watusyatangiti viboku paweru twenga ndo wana lushi wa Rumi. Kayi, watuyingiziyiti mnumba na vinu wafira kutuvugulira kwa bada! Ata padidini! Ndo mpaka weni wayizi panu watuvuguliri.” ");
INSERT INTO poy_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Maafisa awa wawagambiriti visoweru watoza kuusu shitwatira ashi, naomberi pawapikaniriti handa Paulu na Sila waweriti weni kaya wa Rumi, watiriti. ");
INSERT INTO poy_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Hangu, wagenditi kuwaluwa na pawawalaviiti kala mnumba wawaluwiti wawuki mulushi lulii. ");
INSERT INTO poy_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulu na Sila walawiti mushibetubetu, wagenditi ukaya kwa Lidiya. Aku waliwoniti na shipinga sha waumini na pawawagambiriti kala visoweru vya kuwayupa moyu wawuka. ");
INSERT INTO poy_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kwa kupitira Amfipoli na Apoloniya wagenditi mpaka Tesaloniki kweni kuweriti na numba ya Mlungu ya Wayawudi. ");
INSERT INTO poy_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulu kingiriti nawomberi mnumba ya Mlungu ntambu yaiweriti shitiba shakuwi, kwa mashaka matatu ga kwoyera kalitakuziyana nawomberi kwa Malembu Mananagala. ");
INSERT INTO poy_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pakayoweriti na kulagiziya handa imubidi Kristu kutabika na kuzyuka kulawa kwawahowiti kawagambira, “Yesu mweni neni numubwera kwamwenga ndo Kristu.” ");
INSERT INTO poy_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wamu wawu wajimiliti wayingira na Paulu na Sila. Viravi, walanga ngulu ya Wagiriki wawamguwiriti Mlungu pamwera na wadala wavuwa wa ntambu ya kunani, wayingiriti naomberi. ");
INSERT INTO poy_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kumbiti Wayawudi wawona weya, wawatola wafizuli kusoku, watenda shipinga na kujega fuju kumjini koseri. Wayingira numba ya Yasoni watumbiriti kumpata amu Paulu na Sila su wawajegi paweru. ");
INSERT INTO poy_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kumbiti wawapata ndili na hangu wamkwegiti Yasoni pamwera na walongu wamonga mpaka kwa wakulu wa lushi, washowangana, “Wantu awa wawera wankupavuluga pasipanu poseri na vinu wa panu kumjini. ");
INSERT INTO poy_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasoni kawashemera ukaya kwakuwi. Woseri wankutenda shigalambuku sha lagaliru lya Kaisari pawatakula eti, kwana mfalumi yumonga yawamshema Yesu.” ");
INSERT INTO poy_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kwa visoweru avi wawatuliti lyoga wakulu wa kumjini na shipinga sha wantu. ");
INSERT INTO poy_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Yawatenda Yasoni na wayaguwi walaviyi zamana, shakapanu wawaleka wagendi zawu. ");
INSERT INTO poy_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Pashiru, walongu walii wawahimiziya Paulu na Sila wagendi Bereya. Katepu hera pawayingiriti aku, wagenditi mnumba ya Mlungu ya Wayawudi. ");
INSERT INTO poy_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Wantu wa aku waweriti wapikinira nentu kuliku wantu walii wa Tesaloniki. Wauwankiti ujumbi ulii kwa lwamata lukulu, wawera wankugalolalola Malembu Mananagala kila lishaka, su kulola handa galii gawatakuliti Paulu na Sila gaweriti nakaka. ");
INSERT INTO poy_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Wavuwa wawu wajimiriti na viraa wadala wa Shigiriki wa ntambu ya kunani na wapalu viraa. ");
INSERT INTO poy_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kumbiti, Wayawudi wa Tesaloniki pawavimaniti handa Paulu kaweriti kankubwera shisoweru sha Mlungu aku Bereya, wagenditi aku. Wanja kutenda fuju na kusonguziya shipinga sha wantu. ");
INSERT INTO poy_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Walongu walii wawapelekiti Paulu kanongola kagendi kumbwani kumbiti Sila na Timotewu wasigaliti Beroya. ");
INSERT INTO poy_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Walongu walii wawapelekiti Paulu wagenditi pamwera nayomberi mpaka Aseni. Shakapanu, wawuya pamuhera na malagaliru kulawa kwa Paulu handa Sila na Timotewu wamfati kanongola ntambu yaiwezekana. ");
INSERT INTO poy_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulu pakaweriti kankuwahepa Sila na Timotewu aku Aseni, moyu gwakuwi gukalala nentu pakawoniti ntambu lushi alu paluweriti lumema shinyagu sha wamlungu. ");
INSERT INTO poy_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kalitakuziana na Wayawudi na wantu wamonga yawamluwa Mlungu munumba ya Mlungu, na kila lishaka kaweriti na matakuzianu mahali paweru pamwera na woseri walii wawalawiriti. ");
INSERT INTO poy_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Wamonga wawafatiti falisafa ya Epikuru na Staiku walikakatala na yomberi. Wamonga watakuliti, “Kafira kutakula shishi ayu mtuwa visoweru?” Toziya Paulu kaweriti kankubwera kuusu Yesu na kuusu uzyuka, wamonga watakuliti, “lwonikana handa kankubwera kuusu milungu wa shihenja.” ");
INSERT INTO poy_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Hangu wamtoliti Paulu, wamjegiti Aleopagu, Watakula, “Tufira kuvimana shitwatira ashi shasyayi shaguweriti gwanguyowelera. ");
INSERT INTO poy_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Vintu vimonga tuvipikaniriti kwa makutu getu viwonikana weri viloja kwatwenga. Tufira kuvimana vitwatira avi nvina mana gaa.” ");
INSERT INTO poy_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Wantu wa Aseni na wenikaya wamonga wa aku waweriti wankutumiya shipindi shawu shoseri kuligambiziyana na kupikinira visoweru vyasyayi. ");
INSERT INTO poy_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Su, Paulu kagolokiti kuulongolu kumdamu kwa Aleopagu, katakula, “Wenikaya wa Aseni! Mona kuwera mwenga, kwa vyoseri, ndo wantu wa dini nentu. ");
INSERT INTO poy_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mana panweriti nangupita aku na aku panola vinyagu vyenu vya kuguwira moniti pahala pa kutambikira pamu palembitwi ‘Kwa Mlungu yakamanika ndiri!’ Su, ayu yamjimira pota kuvimana, ndomweni yanumubwera kwamwenga. ");
INSERT INTO poy_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Mlungu yakanyawiti pasipanu na vyoseri yaviweraamu, ndo Mtuwa gwa kumpindi na isi, yomberi kalivaga ndiri mnumba nkulu za kuluwa Mlungu yazinyawitwi na wantu. ");
INSERT INTO poy_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ama katendiritwi ndiri kwa mawoku ga wantu kuwera kafira shoseri, toziya mweni ndo yakawapanana woseri ukomu, yakawatenda wantu wapumuli na kuwapanana kila shintu. ");
INSERT INTO poy_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kulawirana na muntu yumu kanyawiti maisi goseri na kugatenda galikali pasipanu poseri. Kaamuiti na kupanga pamberi nakamu ndii na koshi maisi aga megalikali. ");
INSERT INTO poy_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Katenditi hangu, su maisi aga gapati kumfata, na handa vila kwa kupapasiya papaya, gapati kumfikira. Ata hangu kumbiti, Mlungu kapatali ndiri na kila yumu gwenu. ");
INSERT INTO poy_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Handa yakatakuliti muntu yumu, ‘Mngati mwakuwi yomberi twenga tulikala, twankugenda na twankupumula!’ Ndo gambira washaili wenu wamonga ntambu yawatakuliti, ‘Twenga twawana wakuwi.’ ");
INSERT INTO poy_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Paiwera twenga twawana wa Mlungu, tufiruwa ndiri kumuhola Mlungu gambira zahabu ama mpiya ama ata libuwi lyalisongolitwi na wantu kwa kutulwa mng'ereng'etu. ");
INSERT INTO poy_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mlungu katenda gambira kawona ndiri vipindi vilii wantu pawaweriti wangalimahala. Kumbiti vinu, kahimiziya wantu woseri kila pahali waleki vidoda vyawatenda. ");
INSERT INTO poy_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Toziya katula lishaka lyeni hakapatozi pasipanu kwa kutenda galii yagafiriziya Mlungu kwajili ya muntu yumu yakamsyaguliti. Mlungu kawalanguziya woseri shitwatira ashi kwa kumzyukisiya muntu ayu kulawa kwawahowiti!” ");
INSERT INTO poy_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pawampikiniriti Paulu kankutakula kuusu vitwatira vya kuzyuka kwa wahowiti, wamonga wawu waguwiti kwa kusekelera, kumbiti wamonga walongiti, “Tufira kupikinira kayi kuusu shitwatira ashi” ");
INSERT INTO poy_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Hangu, Paulu kawalekiti, kalawiti pamdamu. ");
INSERT INTO poy_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kumbiti wantu wavuwa ndiri wagenditi pamuhera na yomberi, wawera wajimira. Muwamu mwawu waweriti Dionisiwu gwa Aleopagu na mdala yumu yawamshema Damari na wamonga wawu. ");
INSERT INTO poy_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pa aga, Paulu kawukiti Aseni, kagenda Korintu. ");
INSERT INTO poy_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Aku Korintu, kamwoniti Myawudi yumu wamshema Akula, muntu gwa Pontu. Akula pamuhera na Mdala gwakuwi yawamshema Prisila, wawuyiti kulawa Italiya mashaka galaa aga toziya Kayisari Klawudi kaweriti kalagaliriti Wayawudi woseri wawuki Rumi. Paulu kagenditi kuwalola, ");
INSERT INTO poy_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na toziya womberi waweriti wanyawa wa kusona mahema handa yomberi, Paulu katamiti na womberi katenda lihengu. ");
INSERT INTO poy_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kila lishaka lya kwoyera katenditi magambiziyanu mnumba ya Mlungu pakajeriti kukwega Wayawudi na Wagiriki. ");
INSERT INTO poy_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Pa Sila na Timotewu kusoka kulawa Makedoniya, Paulu kanjiti kutumiya shipindi shakuwi shoseri kwajili ya kubwera, kawalanguziya Wayawudi handa Yesu ndo Kristu. ");
INSERT INTO poy_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pawamkomiti Paulu na kwanja kumwigilanga, yomberi kapunda nguwu zakuwi kulongolu kwawu pakalonga, “Pamwagamira ulamaweni, neni nahera likosa lyoseri kulawirana na shitwatira ashi. Na kwanjira vinu hanuwagenderi wantu yawawera ndiri Wayawudi.” ");
INSERT INTO poy_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Su, kalawa panu kagenda kutama ukaya kwa muntu yumu mguwira Mlungu yawamshema Titu Yustu, mweni kaya yakuwi iweriti pakwegera na numba ya Mlungu ilii. ");
INSERT INTO poy_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispu, mkulu gwa numba ya Mlungu ilii, kamjimiriti Mtuwa yomberi pamuhera na walongu wakuwi woseri. Wakorintu wavuwa waupikiniriti ujumbi awu, wajimira na kubatiziwa. ");
INSERT INTO poy_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Lishaka limu pashiru, Mtuwa kamgambiriti Paulu mmaonu, “Nagutira, gwendereyi kubwera pota kuwuya kumbeli, ");
INSERT INTO poy_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Mana neni napanu pamwera nagwenga. Kwa hera mundu yakajera kukutenda toziya panu palushi pana wantu wavua wauwega waneni.” ");
INSERT INTO poy_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Su, Paulu katamiti aku pakafunda shisoweru sha Mlungu pakati pawu kwa shipindi sha shinja shimu na nusu. ");
INSERT INTO poy_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kumbiti shipindi Galiu pakaweriti mkulu gwa mkowa gwa Akaya, Wayawudi wambatiti Paulu kwa pamwera na kumjega kumahakama. ");
INSERT INTO poy_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Watakula, “Tumsitaki muntu ayu toziya ya kuwasongiziya wantu wamjimiri Mlungu kwa ntambu yawasingana na malagaliru.” ");
INSERT INTO poy_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pamberi hera Paulu keniyanji kutakula, Galiu kawagambiriti Wayawudi, “Mpikinireni mwenga Wayawudi! Handa nakaka shitwatira ashi meshiweri likosa ama ukondola neni menweri kala kuwapikinira. ");
INSERT INTO poy_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kumbiti handa lishawuli lya ukakatala kuusu visoweru na matawu na malagaliru genu, mwamuwi maweni. Neni nfira ndiri kuwera mtoza gwa vitwatira avi!” ");
INSERT INTO poy_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Su, kawawinga kulawa kumahakama. ");
INSERT INTO poy_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Na womberi woseri wambata Sosteni mweni kaweriti mlongoziya gwa numba ya Mlungu, womberi wamkoma palaa palii palongoru pa shizyungu. Kumbiti Galiu kalishera ndiri shitwatira ashi ata padidini. ");
INSERT INTO poy_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulu kendereyiti kulikala aku Korintu kwa mashaka gatangala. Shakapanu kawagambiriti kwahere, kakwena mtumbwi kagenda Siriya pakawera na Prisila na Akula. Aku Kenkireya, kamogiti viri zakuwi toziya ya kulapa kwakalilapiti. ");
INSERT INTO poy_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Wagenditi Efesu na panu Paulu kawalekiti Prisikila na Akula, pakagenda mnumba ya Mlungu, kankulitakuziyana na Wayawudi. ");
INSERT INTO poy_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Wamluwiti katami nawomberi shipindi shitali nentu, kumbiti kafiriti ndiri. ");
INSERT INTO poy_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Su pakaweriti kankuwuka, katakuliti, “Mlungu pakafira hanizi kwamwenga kayi.” Kawuka Efesu kwa meli. ");
INSERT INTO poy_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Yomberi pakasokiti mlushi lwa Kaisariya, yomberi kagenditi Yerusalemu kushilamusiya shipinga sha wantu yawamjimira Yesu, shakapanu kagenditi Antiokiya. ");
INSERT INTO poy_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Katama aku katepu hera, shakapanu kendereyiti na mwanja kwa kupitira seemu za Firigiya na Galatiya kankuwatula moyu wafundwa woseri. ");
INSERT INTO poy_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Myawudi yumu yawamshema Apolu, mwiwuka gwa Alekizandiriya, kiziti Efesu. Kaweriti muntu kana luhala lwa kuyowera na yakawera na marifa makulu ga Malembu Mananagala. ");
INSERT INTO poy_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kaweriti kafundwa kuusu njira ayi ya Mtuwa na pakawera motumotu, kabweriti na kufunda kwa unakaka showeru sha Yesu tembera kaweriti kapata ubatizu wa Yohani hera. ");
INSERT INTO poy_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Prisila na Akula pawampikaniriti kankuyowera kwa ugangamala mnumba ya Mlungu, wamtoliti kwawu wamfunda njira ayi ya Mlungu kwa unakaka nentu. ");
INSERT INTO poy_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolu pakaamuiti kugenda Akaya, walongu walii wampananiti moyu kwa kuwalembera wafundwa kulii Akaya wamyangi. Pakiziti aku, kaweziti kwa utanga wa manemu ga Mlungu, kuwatangitira nentu walongu walii wawapatiti kuwera wajimira, ");
INSERT INTO poy_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Toziya kendereyiti kuwakanka Wayawudi paweru pakawalanguziya kwa visoweru vya Malembu Mananagala kuwera Yesu ndo Kristu. ");
INSERT INTO poy_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Shipindi Apolu pakaweriti Korintu, Paulu kagenditi mwanja seemu za bala, kaziti Efesu kweni kawoniti wafundwa wamu. ");
INSERT INTO poy_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Kakosiiti, “hashi, pampatiti kuwera wajimira myangiti Rohu. Mnanagala?” Nawomberi wamwankula, “Ndala! Hatweni pikanira handa kwana Rohu Mnanagala.” ");
INSERT INTO poy_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Nayomberi katakula, “Vinu mpatiti ubatizu wa ntambu gaa?” Wamwankula, “ubatizu wa Yohani.” ");
INSERT INTO poy_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Nayomberi Paulu katakula, “ubatizu wa Yohani uweriti wa kulanguziya handa wantu waleka vidoda. Yohani kawagambiriti wantu wamjimiri ulii yomberi yakaweriti kakwiza pa yomberi, yaani Yesu.” ");
INSERT INTO poy_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pa kupikinira aga, wabatiziti kwa litawu lya Mtuwa Yesu. ");
INSERT INTO poy_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Su, Paulu kawatulira mawoku, na Rohu Mnanagala kawasulukira. Wanja kutakula likabila luhenga na kubwera ujumbi wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Woseri waweriti wantu lilongu na wawili. ");
INSERT INTO poy_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kwa shipindi sha myezi mitatu Paulu kaweriti kankugenda munumba za Mlungu, kawera na matakuliranu ga kukwegiziya nentu kuusu ufalumi wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kumbiti wamonga waweriti wakakatala, walema kujimira, wanja kuyowera vidoda kuusu njira ayi ya Mtuwa mulijojiniku lya wantu. Panu Paulu kaulekiti uganja nawomberi, kawatola pambwega wafundwa wakuwi walii, kaweriti kankuyowera nawomberi kila lishaka panumba ya masomu ga Tiranu. ");
INSERT INTO poy_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Kendereyiti kutenda hangu kwa shipindi sha vinja viwili ata wanalushi woseri wa Asiya, Wayawudi na wantu wa maisi gamonga, waweza kupikinira shisoweru sha Mtuwa. ");
INSERT INTO poy_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Mlungu katenditi mauzauza ga kulikangasha kwa mawoku ga Paulu. ");
INSERT INTO poy_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Wantu waweriti wankutola shitambala na nguwu zimonga zya lihengu zyeni Paulu kaweriti kankuvala, wazijegiti kwa walweli, nawomberi waponiziwa malweri gawu na walii wawaweriti na washamshera wadoda walawa. ");
INSERT INTO poy_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wayawudi wamu yawawusiya wamshera wadoda. Wagenditi mwanja aku na aku wankujera kulitumiya litawu lya Mtuwa Yesu mweni Paulu kankumbwera. ");
INSERT INTO poy_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Wana saba wa Sikewa na Mtambika Mkulu wa Shiyawudi, woseri watenditi hangu. ");
INSERT INTO poy_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kumbiti shamshera kadoda kawankula, “Nummana Yesu, nummana viraa Paulu, kumbiti mwenga mwa gaa?” ");
INSERT INTO poy_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Shakapanu muntu ulii yakalendemeriti kawakopokera woseri kwa likakala, kawakanka likakala. Na wana awa wa Skewa watuga kulawa mnumba mlii pawawera shivula na kuwera na vironda. ");
INSERT INTO poy_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kila muntu Efesu aku, Myawudi na muntu yakawera ndiri Myawudi, kapikaniriti kuusu shitwatira ashi. Woseri waweriti na lyoga, walikwisa litawu lya Mtuwa Yesu. ");
INSERT INTO poy_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Wawumini watangala walawiriti wajimira paweru vitwatira avi vyawaweriti watenda. ");
INSERT INTO poy_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Wamonga waweriti wankutenda vitwatira vya uhawi shipindi shipititi, wajojiniriti vintola vyawu, wavilunguziya paulongolu pa woseri. Wakisiyiti galama ya vintola avi, wawona ifikira vipandi vya shuma malongu mhanu elufu. ");
INSERT INTO poy_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Toziya ayi, shisoweru sha Mtuwa shendereya kweneya na shiwera na likakala nentu. ");
INSERT INTO poy_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pa vitwatira avi, Paulu kaamuiti kugenda Yerusalemu kwa kupitila Makedoniya na Akaya katakuliti, “Pa kusoka aku, infiruwa kuiwona Rumi viraa.” ");
INSERT INTO poy_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Avi, kawatumiti wawili wa ntumintumi wakuwi, Timotewu na Erastu walonguleri genda Makedoniya, yomberi kalikaliti kwa katepu aku Asiya. ");
INSERT INTO poy_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Shipindi ashi ndo pailawiriti ndewu nkulu aku Efesu toziya ya njira ayi ya Mtuwa. ");
INSERT INTO poy_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kuweriti na munyawa shuma yumu wamshema Demetiriu, yomberi kaweriti na lihengu lya kunyawa vinyagu vya numba ya mlungu gwa shidala yawamshema Aritemi. Lihengu ali liwayupiti wanyawa wakuwi mota ngulu. ");
INSERT INTO poy_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetiriu kawajojiniriti pamwera watenda lihengu awa pamwera na wamonga wawaweriti na lihengu handa ali, kawagambira, “Wanalushi, muvimana handa shipatu shangu shilawirana na biyashala ayi. ");
INSERT INTO poy_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Vinu, muweza kupikinira na kuliwonera maweni vitwatira avi Paulu kankuvitenda, panu Efesu hera ndiri, ira viraa koseri Muasiya. Yomberi kawashawishi na kuwagalambula wantu wajumiri handa wamilungu walii yawanyawitwi na wantu milungu ndiri ata shididini. ");
INSERT INTO poy_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Su iwezekana kuwera biyashara yetu iweri na litawu lidoda. Hangu hera ndiri, kumbiti shitwatira ashi shiweza kuitenda numba ya mlungu Aritemi iweri shintu ndiri sha mana. Shakapanu nzyumi zakuwi ayu Asiya na pasipanu poseri ntambu yawamguwira, Hayiperi.” ");
INSERT INTO poy_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pawapikiniriti aga, waweriti na maya, wayanja kubotanga umatu, “Mkulu ndo Aritemi gwa Efesu!” ");
INSERT INTO poy_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kaya yoseri imema fuju. Wawavamiya Gayu na Alisitariku, wenikaya wa Makedoniya, weni waweriti wanamwanja wayaguwi Paulu, watuga nawomberi mpaka kumdamu gwa madingu. ");
INSERT INTO poy_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulu mweni kafiriti kushigendera shipinga sha wantu awa, kumbiti waumini walii wamleweleriti. ");
INSERT INTO poy_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Wakulu wa sirikali wamonga wa aku kumkoa wa Asiya, wawaweriti maganja wakuwi, wamjegiriti Paulu ujumbi wankumluwa nakalitula muatali kwa kugenda kweni kumdamu gwa madingu. ");
INSERT INTO poy_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Shipindi shilii, wantu wamu waweriti pawabota hangu na wamonga vilii. Wantu wavuwa wavimaniti ndiri iwera ashi wawera aku. ");
INSERT INTO poy_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Toziya Wayawudi wamtenda Alekizanda kalawiri kulongolu, wamu wa wantu mushipinga shilii walisheriti kuwera ndo mweni. Su, Alekizanda kawapungiriti wantu kwa liwoku pakafira kujiteteya paulongolu pa shipinga sha wantu walii. ");
INSERT INTO poy_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kumbiti pawavimaniti weri yomberi ndo Myawudi, woseri kwa liziwu limu washowangana, “Mkulu ndo Aritemi gwa Efesu!” Wendereya kushowangana showangana hangu kwa shipindi sha masaa mawili. ");
INSERT INTO poy_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Upeleru kalani gwa lushi kafawuliti kuwanyamaziya, kawagambira, “Wanalushi wa Efesu, kila muntu kavimana handa kaya ayi ya Efesu ndo mlolera gwa numba ya mlungu gwa shidala Aritemi na mlolera gwa shinyagu shilii shashiguwiti kulawa kumpindi. ");
INSERT INTO poy_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kwahera yakaweza kulema shitwatira ashi. Hangu su, munyamali, namtenda shoseri pota hepera. ");
INSERT INTO poy_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Muwashema wantu awa panu tembera wayigilanga ndiri numba ya mlungu ama kumwigilanga mlungu gwetu gwa shidala. ");
INSERT INTO poy_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Handa, Demetiriu na watenda lihengu wayaguwi wawera na masitaka gawu kuusu wantu awa, pana mahakama na wakulu wa mikoni, waweza kusitakiana aku. ");
INSERT INTO poy_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Handa pamuwera na visoweru vyamonga, vyaviwagaziya, muvijegi pashiyotera motu yapafiruwa. ");
INSERT INTO poy_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Toziya tuweza kusitakiwa kwa kujega ndewu kulawirana na vituku vya lelu. Ndewu ayi kwahera toziya ya nakaka na metusindi kulaviya toziya za nyanyi za ndewu ayi.” ");
INSERT INTO poy_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Pakatakuliti aga, kakumaliriti kuliwona. ");
INSERT INTO poy_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Payiperiti ndewu ilii Paulu kawashemiti pamwera waumini walii, kawagambira visoweru vya kawayupa moyu. Shakapanu kawagambira kwahere, kagenda Makedoniya. ");
INSERT INTO poy_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kapitiriti Seemu zya isi zilii kankuwayupa wantu moyu kwa visoweru vitangala. Shakapanu kasokiti Akaya. ");
INSERT INTO poy_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Kweni katamiti kwa myezi mitatu. Pakaweriti kankulitanda kugenda Siriya, kayambuliti handa Wayawudi waweriti wankumtendera mpangu mdoda, hangu kaamuwiti kuwuya kwa kupitira Makedoniya ");
INSERT INTO poy_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopata, mwana gwa Piru, kulawa Beroya, wagenditi pamwera nayomberi, viraa Alisitariku na Sekundi kulawa Tesaloniki, Gayu kulawa Deribi, Timotewu, Tukiku na Tirofimu, kulawa mkowa gwa Asiya, na Timotewu ");
INSERT INTO poy_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Awa watulonguliti na kutuhepera Trowa kulii. ");
INSERT INTO poy_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Tukweniti meli kulawa Filipi payipititi sikukuwi ya Mabumunda gankali kulekera simika, na pa mashaka mhanu shakapanu tuliwoniti pamwera Trowa kulii. Aku tulikaliti kwa shipindi sha lijuma limu. ");
INSERT INTO poy_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Jumamosi pashimii tuliwoniti tumegi libumunda. Toziya Paulu kafiriti kuwuka shirawu yakuwi, kawabweliriti wantu na kwendeleya kuyowera nawomberi mpaka pashiru pa ligonu. ");
INSERT INTO poy_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Vikoloboyi vivuwa viweriti viyaka mmpindi mushindambi Mshumba pawaweriti wankuliwona. ");
INSERT INTO poy_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mndemba yumu litawu lyakuwi Eutuku kaweriti kalivaga palidilisha shipindi Paulu pakaweriti kankwendereya kubwera, Eutuku kanjiti kusizira shididini shididini mpaka mbota zimpata, kapatuka pasi kulawa mgolofa ya tatu. Wamlopoziya kahowiti kala. ");
INSERT INTO poy_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Kumbiti Paulu kasulukiti pasi, kasuntamala, kamkisikira na kulonga “Namwina lyoga mana kwana ukomu wankali mngati mwakuwi.” ");
INSERT INTO poy_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Shakapanu kakwena kayi mligolofa, kalimega libumunda, kaliya. Kendeleyiti kubwera kwa shipindi shivuwa mpaka mandawira putiputi, shakapanu kawuka. ");
INSERT INTO poy_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wantu walii wamtoliti mndemba ulii ukaya pakiwa mkomu nakamu. Wapata shinyamaliru shikulu. ");
INSERT INTO poy_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Twenga tukweniti meli tulonguliriti kugenda Asu kweni twangamtoliti Paulu. Katugambiriti tutendi ntambu ayi, mana kafiriti kwiza aku kwa kupitira isi iyuma. ");
INSERT INTO poy_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Shipindi pakatuwoniti Asu kulii, tumkweniziya mmeli, tugenda Mituleni. ");
INSERT INTO poy_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kulawa aku tugenditi tusoka kiu shirawu yakuwi. Lishaka lya pili, tusulusiyiti nanga Samu na shirawu yakuwi tusokiti Miletu. ");
INSERT INTO poy_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulu kaweriti kafira kwendeleya na mwanja kwa meli pota kuwuyira Efesu su nakakawalira nentu aku Asiya. Kaweriti na kanongola ya kusoka Yerusalemu kwa sikukuwi ya Pentekosti handa iwezikana. ");
INSERT INTO poy_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kulawa Miletu Paulu katumiti ujumbi Efesu, kwa wazewi wa shipinga sha yawamjimira Yesu waliwoni nayomberi. ");
INSERT INTO poy_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pawawuyiti kwakuwi, kawagambiriti, “Muvimana ntambu yandamiti na mwenga pashiru poseri kwanjira mulishaka lilii lya kwanja pansokiti Asiya. ");
INSERT INTO poy_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Muvimana ntambu yanumtenderiti Mtuwa kwa unanaga woseri, kwa masozi na maholu gambatiti kulawirana na mipangu ya ufyangu ya Wayawudi. ");
INSERT INTO poy_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Muvimana handa hapeni nzindi ata shididini kuwabwelera paweru na mkaya mwamwennga na kuwafundeni shoseri shakuwatangitileni. ");
INSERT INTO poy_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nuwaberiziya mwawoseri Wayawudi, viraa na wantu yawawera ndiri Wayawudi wamgalambukiri Mlungu na kuwera na njimiru mu Mtuwa gwetu Yesu. ");
INSERT INTO poy_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Na vinu, mumpikinireni! Neni, payiwera nankumjimira Rohu, nunkugenda Yerusalemu pota kuvimana yagafira kumpata aku. ");
INSERT INTO poy_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Shanushimana hera ndo handa Rohu Mnanagala kankunanguziya pakati pa kila lushi handa shifungu na ntabiku ndo vyanguhepera. ");
INSERT INTO poy_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kumbiti, nankuukwisa ukomu wangu kuwera shintu nentu kwaneni mladi hera malili untumintumi wangu na lihengu lilii lyakanupiti Mtuwa Yesu nulitendi, yani nankuziyi Shisoweru Shiwagira sha manemu ga Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Mbita muwamu mweni woseri pabwera ufalumi wa Mlungu.Na vinu, nuvimana kwahera ata yumu gwenu hakamoni kayi. ");
INSERT INTO poy_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Hangu, leru ayi nankuwalanguziya nakamu handa payilawira kahowa yumu gwenu, neni nahera lawama yoseri. ");
INSERT INTO poy_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Toziya hapeni nzindi ata padidini kuwabwelerani nfiru yoseri ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mulikali weri maweni, mshiloleri shipinga shilii sheni Rohu Mnanagala kawatula mwenga muweri walelwa wakuwi. Mushiloli shipinga sha wantu yawamjimira Yesu, Mlungu yakashihemeriti kwa mwazi gwa mwana gwakuwi. ");
INSERT INTO poy_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nuvimana handa pambuka kala neni wamaminyi wakalipa hawawingilirani, na hapeni waweri na lusungu kwa shipinga ashi. ");
INSERT INTO poy_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ata kulawa muwamu mwenu hawalawili wantu weni hantakuli vitwatira vya kupyota su kuwahowiziya wantu na kuwatenda wawafati womberi hera. ");
INSERT INTO poy_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Hangu muweri masu pamlihola handa kwa shipindi sha vinja vitatu, pashiru na paliwala ndoka ndiri kumubera kila yumu gwenu kwa masozi. ");
INSERT INTO poy_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Vinu nankuwatula mumawoku ga Mlungu, kwa shisoweru sha manemu gakuwi, ndosheni shiweza kuwanyawa mwenga na kuwapanana uhala pamuhera nawomberi woseri yawapungitwi. ");
INSERT INTO poy_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Neni nfirandiri ata mala yimu shuma, wala zaabu, wala nguwu za muntu yoseri. ");
INSERT INTO poy_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Muvimana maweni handa ntenda lihengu kwa mawoku gangu namweni su mbati shakuwatanga na sha namweni. ");
INSERT INTO poy_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Namweri nankuwayupani mashaka goseri mfanu handa kwa kutenda lihengu shiasi ashi tufiruwa kuwatanga walii wahera likakala patulihola visoweru vya Mtuwa Yesu mweni, ‘Mbaka nentu kulavia kuliku kuyanga.’ ” ");
INSERT INTO poy_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pa katakuliti kala aga, Paulu kasuntamaliti pamuhera nawomberi woseri, kamluwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Woseri waweriti wankulira, na kumgambira Paulu kwahere kwa kumkisikira na kumunonera. ");
INSERT INTO poy_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Shawaweriti na maholu nashu nentu shiweriti showeru shakashitakuliti handa hapeni wamoni kayi. Su, wampeleka mpaka kumeli. ");
INSERT INTO poy_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Patumaliliti kumgambira kwaheri, tukweniti meli tugenda mpaka kosi. Shirawu yakuwi tusokiti Rodi, na kulawa aku tugenditi patara. ");
INSERT INTO poy_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Aku, tuwoniti meli yaiweriti yankugenda Foiniki, hangu tukweniti, tugenda mwanja. ");
INSERT INTO poy_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Patusokiti kala pahala peni tuweziti kuwona kupiru, tupitiriti uwega wakuwi wa kushana tugenda Siriya. Tupumliriti mulushi lwa Tiru peni meli ilii iweriti wankusulusiya visanka vyakuwi. ");
INSERT INTO poy_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tuwoniti waumini wamu aku, na tulivaga pamwera nawomberi kwa lijuma limu. Kwa likakala lya Rohu, wamgambira Paulu kotukugenda Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kumbiti shipindi shetu pashiperiti tuwukiti woseri pamuhera na wadala na wana wawu watupelekiti mpaka kunja ya lushi. Patusokiti kumbwani, twawoseri tusundamaliti na tumluwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Shakapanu patulongiti kwaheri, twenga tukwena meli, nawomberi wawuya ukaya kwawu. ");
INSERT INTO poy_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Twenga twendereyiti na mwanja gwetu kulawa Tiru tusoka Tolemaisi kweni tuwalamsiya wawumini, tulikaliti nawomberi lishaka limu. ");
INSERT INTO poy_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Shirawu yakuwi tuwukiti na tusoka Kaisariya. Aku tulikaliti ukaya kwa Mwinjilisti Filipi yomberi kaweriti yumu gwa walii saba wawasyaguliti kutanga Yerusalemu kulii. ");
INSERT INTO poy_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Kaweriti na wahinga wamsheshi weni waweriti na shipaji sha kutakulira ujumbi wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Pawalikaliti aku mashaka ng'o, mbuyi yumu wamshema Agabu kiziti kulawa Yudeya. ");
INSERT INTO poy_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Katuyiziriti, katola Mkanda gwa Paulu, kalitawa mumawoku na mumagulu Kalonga, “Rohu Mnanagala katakula hangu, ‘Wayawudi Yerusalemu wamtawi ntambu ayi muntu kana mkanda agu na wantu wa maisi wamkamli.’ ” ");
INSERT INTO poy_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Patupikiniriti aga, twenga na wantu wamonga walii wawaweriti panu tumluwiti Paulu kotukugenda Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Kumbiti Paulu kankuliti, “Mfira kutenda shishi? Mfira kugumega moyu gwangu kwa masozi? Neni nwera kala hera ndiri kutatilwa mnumba kulii Yerusalemu, ila ata kuhowa kwajili ya Mtuwa Yesu.” ");
INSERT INTO poy_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Patusinditi kumuzyangazyanga tunyamala, tulonga hera, “Shakafira Mtuwa shitendeki!” ");
INSERT INTO poy_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Pawatamiti palii kwa katepu, tuyopiti visanka vyetu, twendereyiti na mwanja kugenda Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wamu wa wafundwa walii wa Kaisariya wagenditi pamuhera natwenga, watujega ukaya kwa Mnasoni yomberi tuweriti twankugenda kulikala nayomberi kwa katepu. Mnasoni kaweriti mwenikaya gwa kupiru na kaweriti muwumini gwa mashaka gavuwa. ");
INSERT INTO poy_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Patuyingiriti Yerusalemu, walongu wawumini watuyangiti weri nentu. ");
INSERT INTO poy_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Shirawu yakuwi Paulu kagenditi pamwera natwenga kumlamusiya Yakobu, na wazewi na shipinga sha wantu wawamjimira Yesu Kristu waweriti viraa. ");
INSERT INTO poy_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pawamlamsiyiti kala, Paulu kawayupiti shisoweru kamili kuusu goseri Mlungu gakaweriti kagatenda pakati pa wantu wa maisi kwa njira ya lihengu lyakuwi. ");
INSERT INTO poy_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pawapikiniriti aga, wamkwisa Mlungu. Shakapanu kamgambira Paulu, “Mlongu, guweza kuwona handa kwana Wayawudi maelufu weni vinu wawera wajimira na woseri awa wagatenda weri malagaliru. ");
INSERT INTO poy_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Wapata visoweru vyakuwi handa guweriti gwanguwafunda Wayawudi yawalikala muwamu mwa wantu wa maisi gamonga nawagashera ndiri malagaliru ga Musa, kotukuwayigiziya jandu wananguta wawu na kotukuzifata mila za Wayawudi. ");
INSERT INTO poy_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nakaka wapikinira handa kasoka kala panu. Tutendi hashi, shakapanu? ");
INSERT INTO poy_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Su, gutendi handa ntambu yatukugambiziyiti. Twa panu wantu msheshi weni watula nazili. ");
INSERT INTO poy_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Gwingiri pamuhera na womberi, gulipungi pamuhera na womberi na gulipi na shyasi shashiwusika kwa womberi shakapanu wamogi viri zawu. Su kila muntu hakavimani kuwera visoweru vyoseri vilii vyawagambiritwi kuusu gwenga vyahera mana, kumbiti gwenga gumweni gwendereya weri na kugajimira malagiliru ga Musa. ");
INSERT INTO poy_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kuusu wantu walii wa maisi gamonga wantu yawamjimira Yesu, tuwajegera kala luhamba twankuwagambira vitwatira vyatuamuwiti, waleki kuliya shoseri shawatambikiriti kwa milungu, nawalanda mwazi ama nawaliya vinofu vya shigongolu yawaminduwitwi na waleki uhumba.” ");
INSERT INTO poy_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Su lishaka lyalifatiti Paulu kawatoliti wantu walii na kalipunga pamuhera nawu. Shakapanu kingira Mnumba nkulu ya Mlungu, pakabwera visoweru vya upeleru wa mashaka ga kulipunga na tambiku meitendwi kwa kila muntu. ");
INSERT INTO poy_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Shipindi mashaka saba aga pagiziti kupera, Wayawudi waweriti walawa pamkoa gwa Asiya wamwoniti Paulu Mnumba nkulu ya kumluwa Mlungu. Su, wasonguziya maya mushipinga shoseri sha wantu, wamkamula Paulu. ");
INSERT INTO poy_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“Wanaisi wa Israeli, wabotanga Mtutangi! Ayu ndomweni ulii muntu yakawafunditi wantu kila pahala shitwatira shawashilema wantu wa Israeli, yagalema Malagaliru ga Musa na pahala panu pananagala. Ata vinu kawayingiziya wantu wa maisi gamonga Mnumba nkulu ya Mlungu na kupatula uhumba pahala panu pananagala.” ");
INSERT INTO poy_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Toziya ya kutakula hangu ndo kuwera waweriti wamwona Tirofimu, mwenikaya gwa Efesu, kaweriti pamuhera na Paulu mlushi, womberi walisheriti kuwera Paulu kaweriti kamwingiziya Mnumba nkulu ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Lushi loseri lwingira ndewu, wantu wiza kulawa wega zoseri, wamlaviyiti Paulu kunja Kunumba nkulu ya Mlungu, na palaa panu milyangu itatwa ya Numba nkulu ya Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Waweriti kala kumlaga kumbiti visoweru vimwizira mkulu gwa wanjagila wa shiroma kuwera Yerusalemu yoseri iweriti imema ndewu. ");
INSERT INTO poy_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kamu kamu mkulu gwa njagira kawatola wanjagila na mkulu gwa wanjagila, kashigendera shipinga sha wantu. Nawomberi pawamwoniti mkulu gwa njagira na wanjagila, waleka kumkoma Paulu. ");
INSERT INTO poy_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mkulu gwa jeshi kamgenderiti Paulu, kambata na kuamuwa wamtawi minyololu mushimba. Shakapanu kawakosiiti, “Ndo muntu gaa ayu, na katenda shishi?” ");
INSERT INTO poy_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wamonga mshipinga sha wantu shilii waweriti wankubwera shintu ashi na wamonga shintu shilii. Toziya ya ndewu ayi. Mkulu gwa wanjagila kapofola kulimana shawuli kamili. Hangu, kaamuwiti wantu wakuwi wamjegi Paulu kuliboma. ");
INSERT INTO poy_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paulu pakasokiti palukweneru, wanjagila wampapiti toziya ya ndewu ya wantu. ");
INSERT INTO poy_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Toziya wantu mushipinga shikulu wamfatiti pawabotanga, “gumlagiri patali!” ");
INSERT INTO poy_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pawaweriti wankumwingiziya muboma, Paulu kamluwiti mkulu gwa wajengeni kalonga, “Weza kutakula shintu?” Mkulu gwa njagira ulii kamwankula, “Hashi, gushimana shigiriki?” ");
INSERT INTO poy_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Kwani gwenga ndo ulii Mmisri ulii mashana hera kayanjishiti ungondu na kawalonguziya majahili elufu msheshi mpaka kushiwala?” ");
INSERT INTO poy_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulu kankula, “Neni ndo Myawudi, mwiwuka gwa Tarisu pa Kilikiya, neni ndo mwiwuka gwa lushi lwalumanikana. Shondi nukuluwa, gunekeziyi ntakuli na wantu.” ");
INSERT INTO poy_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mkulu ulii gwa wanjagila kamjimira. Hangu Paulu kagolokiti panani pa lukweneru, kawapungira mawoku wantu walii, na pawalikaliti jiii, kanja kuyowera nawomberi kwa Shiebraniya. ");
INSERT INTO poy_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Mwawalongu wangu na ashina tati, mpikinira vinu panalitakulura paulongolu penu!” ");
INSERT INTO poy_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pawapikiniriti pakayowera nawomberi kwa Shiebraniya wongera kutama jii kuliku shipindi shipititi na Paweru kendereya kulonga. ");
INSERT INTO poy_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Neni ndo Myawudi, mwiwuka gwa Tarisu Mukilikiya. Kumbiti neleritwi palaa panu palushi lya Yerusalemu pasi ya ukufunzi Gamalieli. Mfunditwi kufata kwa ugangamala malagaliru ga wazewi wetu. Nuliraviyiti kwa moyu goseri kwa Mlungu kuwera mwenga ntambu ya muwera leru. ");
INSERT INTO poy_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nuwatesiti ata kuwalaga wantu walii wawafatiti njira ayi. Nuwakamliti wapalu kwa wadala na kuwatatira mshibetubetu. ");
INSERT INTO poy_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mtambika Mkulu na shipinga shoseri sha wazewi waweza kushilanguziya shitwatira ashi. Kulawa kwawu mwankiti luhamba yawalembiti walongu walii Wayawudi yawaweriti aku Dameski. Ng'enditi Dameski su nuwakamuli wantu awa na kuwajega watatirwa mpaka Yerusalemu su wapananwi azabu. ");
INSERT INTO poy_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Su, panweriti mnjira pakwegera kuyingira Dameski, ipata saa sita paliwala, uweru ukulu ulawa kumpindi ulawira vumu uwalira wega zoseri. ");
INSERT INTO poy_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Panu nguwiti pasi, mbikanira liziwu ling'ambira, ‘Sauli, Sauli! Kwa shishi gundesa?’ ");
INSERT INTO poy_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Neni ngosiiti, ‘Gani gwenga, Mtuwa?’ Nayomberi kang'ambira. ‘Neni na Yesu gwa Nazareti ndo yomberi yaguntesa.’ ");
INSERT INTO poy_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wayangu walii wawoniti uweru ulii kumbiti wapikinira ndiri liziwu lya ulii yakayoweriti naneni. ");
INSERT INTO poy_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ngosiya, ‘Ndendi shishi Mtuwa?’ Na Mtuwa kanangula, ‘Gugoloki, gugendi Dameski na aku hawakugambiri vyoseri vyeni Mlungu wakupangira kutenda.’ ");
INSERT INTO poy_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kulawirana na uweru ukalipa mwezandiri kuwona na hangu iwabidi wayangu walii kunongoziya kwa kung'ola liwoku mpaka nsoka Dameski ");
INSERT INTO poy_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Aku kuweriti na muntu yumu yawamshema Ananiya, muntu mguwira Mlungu, mweni kujimira malagaliru getu na yawamupanana ligoya nentu kulongolu kwa Wayawudi yawaweriti walikala Dameski. ");
INSERT INTO poy_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Yomberi kiziti kunola, kagoloka pakwegera naneni, kalonga, ‘Mlongu Sauli! Guwoni kayi.’ Palaa palii kawona kayi, numulola. ");
INSERT INTO poy_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Shakapanu Ananiya kalonga, ‘Mlungu gwa wambuyi wetu kakusyagula gwenga gupati kuvimana mafiliru gakuwi na kumlola ntumintumi gwakuwi muheri na kumpikinira mweni pakayowera. ");
INSERT INTO poy_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kwa mana hauweri upitawu kwa wantu woseri pawawagambira galii gwagagawoniti na kugapikanira. ");
INSERT INTO poy_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Vinu su, ga shishi kushelewa nentu? Gugoloki, gubatizwi na kuwusilirwa vidoda vyaku kwa kuluwa litawu lyakuwi.’ ");
INSERT INTO poy_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Su, muyiti Yerusalemu na panweriti nankumluwa Mlungu munumba nkulu moniti mawonu. ");
INSERT INTO poy_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Numwoniti Mtuwa pakang'ambira, ‘Guwuki Yerusalemu kanongola kwa mana wantu wa panu hapeni wawujimiri upitawu waku kuusu neni.’ ");
INSERT INTO poy_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","‘Mtuwa’ neni numwankula, ‘wavimana pota kufifa handa neni ndo ulii yakaweriti kankupitapita munumba za Mlungu na kuwabata na kuwakoma walii yawaweriti wankujimira. ");
INSERT INTO poy_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na handa shipindi pitawu gwaku Stefanu pawamlagiti, namweni neni nweriti palii panjimilianiti na shitwatira ashi na kugalolera makoti ga walii yawaweriti wankumlaga.’ ");
INSERT INTO poy_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Mtuwa kang'ambira, ‘Gugendi, nukutumi patali kwa isi za Wayawudi ndiri.’ ” ");
INSERT INTO poy_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Mpaka panu, wantu walii waweriti wankumpikinira, kumbiti pandakuliti visoweru avi, wayanjiti kutakula kwa liziwu likulu, “Guwusiyi Pasi panu muntu gwa ntambu ayi katakiwa ndiri kulikala.” ");
INSERT INTO poy_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Wandereiti kubwerabwera aku na wankutikinyia makoti gawu na kusulusiya lidiku kumpindi. ");
INSERT INTO poy_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mkulu gwa majangira kawagambiriti wantu wakuwi wamjegi Paulu mnumba ya liboma, kawagambira wawasyatangi mboku su wapati kuvimana shanzu sha Wayawudi kumtendera umatu. ");
INSERT INTO poy_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kumbiti pawaweriti wankumtawa su wasyatangwi mboku, Paulu kamkosiyiti mkulu gwa majagira yumu yakagolokiti panu, “Hashi, ndo yapafiruwa kwamwenga kumsyatanga mboku mwanalushi gwa Rumi pambeli hakenitozwi?” ");
INSERT INTO poy_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Mkulu gwa njagira ulii pakapikaniriti aga, kamyupiti shisoweru mkulu gwa njagira kalonga, “Gufira gutendi shishi? Muntu ayu ndo mwanalushi gwa Rumi!” ");
INSERT INTO poy_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Mkulu gwa njagira kamgendiriti Paulu kamgambira, “Gung'ambiri, hashi gwenga ndo mwanalushi gwa Rumi?” Paulu kamwankula “nyina,” ");
INSERT INTO poy_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mkulu gwa njagira kalonga, “Naneni nwera mwanalushi gwa Rumi kwa kulipira shiyasi shikulu.” Paulu kalonga, “Kumbiti neni na mwanalushi gwa Rumi kwa kwiwuka.” ");
INSERT INTO poy_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Wantu walii weni waweriti kala kumlolera Paulu wawukiti saa iraa ilii. Ata mkulu gwa njagira ulii katiriti pakavimaniti handa Paulu ndo mwanalushi gwa Rumi na handa kaweriti kamtawalira kala minyololu. ");
INSERT INTO poy_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Shirawu yakuwi, mkulu gwa njagira kafiriti kuvimana masitaka geni Wayawudi waweriti wamsitaki Paulu. Hangu, kamyopoliti Paulu minyololu, kaamuwa watambika wakulu, na shizyungu shoseri waliwoni. Shakapanu kamjegiti Paulu, kamgolosiya paulongolu pa shizyungu. ");
INSERT INTO poy_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulu kawalola ndii wanashizyungu walii, shakapanu kanja kutakula, “Mwalongu wangu, mpaka leru nweriti nankulikala na nfiru iherepa paulongolu pa Mlungu.” ");
INSERT INTO poy_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Panu Mtambika Mkulu Ananiya kawahimiziya walii yawaweriti wagoloka pakwegera na Paulu wamwakuli mumlomu. ");
INSERT INTO poy_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Su, Paulu kamgambira, “Mlungu mweni hakakuwakuli mbalawandi gwenga handa shibambaza shawapakaziiti shokaa! Guwera hashi, kulikala panu su guntozi shikamalagaliru na aku gumweni gwenga gugamega malagaliru kwa kuhimiziya wang'omi!” ");
INSERT INTO poy_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Wantu wawaweriti wagoloka palii wamgambira Paulu, “Gumwigira mtambika mkulu gwa numba ya Mlungu!” ");
INSERT INTO poy_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulu kankula, “Walonga wangu, nuvimana ndiri handa yomberi ndo Mtambika Mkulu. Mana Malembu mananagala galonga, ‘Nagumtakulira vidoda mkolamlima gwa wantu waku.’ ” ");
INSERT INTO poy_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Shipindi ashi Paulu kalimaniti kala handa seemu yimu ya wanashizyungu walii iweriti ndo Masadukayu na yimonga Mafalisayu. Su, katakula kwa liziwu likulu paulongolu pa shizyungu, “Walongu wangu, neni ndo Mfalisayu, mwana gwa Mfarisayu. Neni wanjega kushizyungu toziya nulitumbira handa wahowiti hawazyuki.” ");
INSERT INTO poy_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pakatakuliti kala aga, ndewu ikalipa ilawiriti pakati pa Mafalisayu na Masadukayu na shipinga shipalanganika. ");
INSERT INTO poy_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Shanziru sheni Shiweriti ashi, Masadukayu wakolera handa wahowiti wazyuki ndiri, kwahera wantumintumi wa kumpindi, na rohu zyeni kwahera. Kumbiti Mafalisayu wajimira goseri aga matatu. ");
INSERT INTO poy_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Umatu uyongerekiti na wamonga wa wafunda wa Malagaliru ga shipinga sha Mafalisayu wagolokiti na kulavia malalamiku gawu kwa likakala, “Hatweniwoni shoseri shilii shikondola pakati pa muntu ayu, pamonga iwera handa rohu ama ntumintumi gwa kumpindi kuyowera na yomberi.” ");
INSERT INTO poy_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ndewu iweriti nkulu ata mkulu gwa wanjagila katira handa Paulu mewampapulangi vipandivipandi. Hangu, kawahimiziyiti wanjagila wakuwi kwingira pakati paa shipinga shilii, wamlaviyi Paulu na kumwuziya mngati mliboma. ");
INSERT INTO poy_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Pashiru pafatiti, Mtuwa kagolokiti pakwegera na Paulu, kamgambira, “Guliyupi moyu! Gumbitawulira panu Yerusalemu, hagutendi ntambu irayi ayi mlushi lwa Rumi.” ");
INSERT INTO poy_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Pawushiiti, Wayawudi watenditi waliwoni kwa bada. Waliyupa shiapu, “Hapeni tuliyi wala kulanda mpaka patuweri kala tumlagi Paulu.” ");
INSERT INTO poy_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Wantu nentu ya malongu msheshi ndo yawatenditi mpangu gwa kutenda hangu. ");
INSERT INTO poy_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Su wagenditi kwa Mtambika Mkulu na wazewi, walonga, “Twenga tulilapira handa hapeni tuliyi shoseri kwa milomu yetu mpaka patumlaga Paulu. ");
INSERT INTO poy_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Vinu su, mwenga pamwera na shizyungu guwatumi wajumbi kwa mkulu gwa majengeni su wamjegi Paulu kwamwenga pamlipayira handa mfira kuwayupa shisoweru shiherepa nentu kuusu yomberi. Tuweriti ndiri kala kumlaga ata pamberi pa kusoka panu.” ");
INSERT INTO poy_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kumbiti mwana gwa mlongu gwakuwi Paulu kapikiniriti kuusu mpangu agu, hangu kagenda mngati mwa boma kamgambira Paulu kuusu mpangu agu. ");
INSERT INTO poy_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Panu Paulu kamshema yumu gwa wanjagila, kamgambira, “Gumtoli mndemba ayu kwa mkulu gwa wanjagila, kwana shintu sha kukugambira.” ");
INSERT INTO poy_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mnjagira kamtola mndemba ayu, kumlonguziya mpaka kwa mkulu gwa wanjagila, kalonga, “Mtatilwa ulii Paulu kanshema kanduwa numjegi mntemba ayu kwaku toziya kana shitwatira sha kukugambira.” ");
INSERT INTO poy_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mkulu gwa wanjagila kamkoliti liwoku mndemba ayu kamjega pahala pagweka, kamkosiya, “Gwana shishi sha kung'ambira?” ");
INSERT INTO poy_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Yemberi kalonga, “Wayawudi waligambirana wakuluwi numjegi Paulu Pashizyungu wankulipayira handa shizyungu shifira kupata visoweru avi kamili nentu kuusu yomberi. ");
INSERT INTO poy_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kumbiti gwenga nagujimira, toziya wantu wavuwa nentu ya malongu msheshi walitanda kala kumkamula, walitatira weni mushirapu kuwera hapeni waliyi ama kulanda mpaka wamlagi huti Paulu. Vinu wakala pawahepera lagilu lyaku” ");
INSERT INTO poy_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mkulu gwa wanjagila kalonga, gugendi zaku kotukumgambira muntu yoseri handa gunjegera visoweru avi. ");
INSERT INTO poy_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Su, mkulu gwa jeshi kawashemiti wanjagila wawili kawagambira, “Muwatandi kala wanjagila miya mbili, wakwena falasi malongu saba na wanjagila miya mbili yawawera na migoha, wagendi Kaisariya, muweri kala kuwuka pamberi pa saa tatu pashiru. ");
INSERT INTO poy_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mtandi falasi wamu kwajili ya Paulu, wamjegiti Salama kwa Felisi, mkulu gwa mkowa.” ");
INSERT INTO poy_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Shakapanu mkulu ayu gwa shenta kalembiti hangu luhamba, ");
INSERT INTO poy_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Neni Klawudi Lusiya nunkukulembera gwenga mtuwa Felisi, mkulu gwa mkowa. Nukulamsiya! ");
INSERT INTO poy_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","‘Wayawudi wamkamuliti muntu ayu na sambira wamlagi mewang’ambiriti ndiri handa yomberi ndo mwanalushi gwa Rumi na hangu ng'enda pamuhera na wanjagila numlopoziya. ");
INSERT INTO poy_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Numjegiti panlogolu pa shizyungu shawu shikulu nfira kuvimana shanziru sha masitaka gawu. ");
INSERT INTO poy_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nyambuliti handa masitaka geni gahusu lukakatala lwa seemu zimu zya malagaliru gawu na hangu monandiri handa katenda shoseri shifiruwa wamlagi ama wamtatiri mshibetubetu. ");
INSERT INTO poy_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Pawang'ambiriti handa Wayawudi waweriti watenda mpangu gwa kumlaga, amuwiti kumjega kwaku, nuwagambira wasitaki wakuwi wajegi mashitaka gawu kulongolu kwaku.” ");
INSERT INTO poy_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Su, wanjagila awa wamtoliti Paulu handa ntambu yawawalagaliriti, wamjega pashiru palii mpaka Antipatiri. ");
INSERT INTO poy_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Shirawu yakuwi wanjagila wa magulu wawuyiti kuliboma, wawaleka wanjagila walii wawakwena falasi wandereyiti na mwanja pamwera na Paulu. ");
INSERT INTO poy_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Pawasokiti Kaisariya wamupiti mkulu gwa mkowa su luhamba na kumtula Paulu pasi pa ukolamlima wakuwi. ");
INSERT INTO poy_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Felisi pakabetuliti luhamba alu kawakosiiti Paulu kalawa kumkoa gaa. Pawamgambiriti handa kaweriti kalawa kumkoa gwa Kilikiya. ");
INSERT INTO poy_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Kalonga, “hampikiniri lisitaka lyaku pawasoka kala wasitaki waku.” Shakapanu kaamuwa Paulu wamloleri pamdamu gwa Herodi. ");
INSERT INTO poy_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pa mashaka mhanu, mtambika mkulu gwa numba ya Mlungu Ananiya kingiriti Kaisariya pamwera na wazewi wamu na wakili yumu gwa malagaliru yawamshema Teritulu. Wamgendiriti mkulu wa mkowa ulii wamgambira mashitaka gawu kuusu Paulu. ");
INSERT INTO poy_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Paulu wamshemiti, na Teritulu kamlavilira mashitaka hangu, “Mtuwa Felisi, ulonguziya waku uherepa ujega ponga nkulu na kwa ulolera waku vitwatira vivuwa vitulwa weri toziya ya isi yetu. ");
INSERT INTO poy_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Shipindi shoseri na pahala poseri, kwa ntambu zoseri, mtuwa Felisi, tuvyanka vitwatira vyoseri avi kwa mayagashii gavuwa. ");
INSERT INTO poy_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kumbiti, bila kuhowiziya shipindi shaku nentu, tukuluwa kwa viheri vyaku, guyipikiniri isi yetu. ");
INSERT INTO poy_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tuyambula handa muntu ayu ndo mbaya nentu. Yomberi katenda ndewu pakati pa Wayawudi kila pahala pasi panu na viraa ndo mlongoziya gwa shama shilii sha Wanazareti. ");
INSERT INTO poy_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kayi kajeriti kuyihalibisiya numba nkulu ya kumluwira Mlungu, natwenga tumkamliti. Tufiriti kumtoza kugenderana na malagaliru getu twaweni. ");
INSERT INTO poy_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Kumbiti Lusiya, mkulu gwa majengeni, kingiriti pakati, kamtoliti kwa likakala kulawa mmawoku getu. ");
INSERT INTO poy_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Handa pagumgambira msitaki gwakuwi kiza kulongolu kwaku, Handa pagumkosiya gumweni guweza kuvimana vitwatira vyoseri avi vyatumsitakiti kwa vyeni.” ");
INSERT INTO poy_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Na Wayawudi wajimira shisoweru sha masitaka aga pawatakula handa goseri aga gaweriti nakaka. ");
INSERT INTO poy_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Su, mkulu gwa mkowa kamlekiziiti Paulu katakuli. Nayomberi Paulu kalonga, “Nemelera kujiteteya paulongolu paku panuvimana handa guwera mtoza gwa maisi aga kwa vinja vivuwa. ");
INSERT INTO poy_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Guweza kujiakishiya handa nentu ndiri ya mashaka ligumba na mawili hera gapita kwanjira pang'enditi kuguwira Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Wayawudi wamona ndiri panalitakuziyana na muntu yoseri wamona ndiri panuwasongiziya wantu mnumba nkulu ya Mlungu, pota munumba zya Milungu yawu. Pota pahala pingi kayi poseri mlushi alu. ");
INSERT INTO poy_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Pota waweza ndili kulanguziya mashitaka wagalaviyiti kuusu neni. ");
INSERT INTO poy_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Shanjimira paulongolu paku ndo hashi. Neni numjimira Mlungu gwa wazewi wetu pandama kugenderana na njira ilii yeni womberi wayishema shama sha ufyangu. Njimira vitwatira vyoseri vyawalembiti muvintola vya malagaliru ga Musa na muvintola vya wambuyi. ");
INSERT INTO poy_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Neni nulitumbira Mlungu, na womberi walitumbira ula vira, handa wantu yawamfiriziya Mlungu na wantu yawamfiriziya ndiri Mlungu, hawazyuki. ");
INSERT INTO poy_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Hangu hangangamali mashaka goseri kuwera na nfiru heri paulongolu pa Mlungu na palongolu pa wantu. ");
INSERT INTO poy_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Pantamiti kutali kwa vinja vyamaha, mbuyiti Yerusalemu su kuwajegera wantu wa lushi lwangu utanga na kulaviya tambiku. ");
INSERT INTO poy_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Shipindi neni paweriti nankutenda aga su womberi wamoniti neni Mnumba nkulu ya Mlungu, nweriti ntenditi kala vitwatira vya kulipunga. Panweriti ndiri na lipinga lya wantu ama ndewu yoseri. ");
INSERT INTO poy_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Kumbiti kuweriti na Wayawudi wamonga kulawa kumkoa gwa Asiya, hawa watakiwa kuwera panu paulongolu pakuwi na kulavia masitaka gawu handa wana shoseri sha kunsitakira. ");
INSERT INTO poy_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ama, guwaleki awa wawawera panu watakuli likosa lyawaliwoniti kwaneni shipindi pang'olukiti paulongolu pashizyungu shawu shikulu, ");
INSERT INTO poy_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","payiweri hera visoweru avi vyantakuliti pang'olukiti paulongulu pawu, ‘Mlungu kantozi ulaleru toziya ya kukolera handa wahowiti hawazyukisiwi.’ ” ");
INSERT INTO poy_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Panu, Felisi, yomberi mweni kaweriti kayimana njira ayi weri, kahayilishiti kesi ayi. Kawagambira, “Navinu hantozi kesi ayi shipindi Lusiya, mkulu gwa wanjagila, pakiza panu.” ");
INSERT INTO poy_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Shakapanu kamwimiziya mkulu gwa wanjagila kamtuli Paulu mshibetubetu, kumbiti kaweri na ulekiziwu shiyasi na waganja wakuwi kotukuwabera pawamupanana shakafira. ");
INSERT INTO poy_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pa mashaka madidini, Felisi kiziti pamwera na mdala gwakuwi Drusila yomberi kiweriti Myawudi. Kaamuiti Paulu wamjegi, kampikanira pakayowera kuusu kumjimira Yesu Kristu. ");
INSERT INTO poy_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kumbiti shipindi Paulu pakanjiti kuyowera kuusu shashimfiriziya Mlungu, kuusu kulikolamlima na kuusu lishaka ya kutoza lyaliyiza. Felisi katiriti na kulonga, “Vinu guweza kugenda, hanukushemi kayi pampata lupenyu.” ");
INSERT INTO poy_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Shipindi shirashi kaweriti kankulitumba handa Paulu kangamupiti shuma. Toziya ayi kamshemiti Paulu mala kwa mala na kuyowera nayu. ");
INSERT INTO poy_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Pa vinja miwili avi, Porikiu Festu katoliti lupenyu lwa Felisi, kaweri mkulu gwa mkowa. Toziya kafiriti kulijegelera kwa Wayawudi, Felisi kamlekiti Paulu mshibetubetu. ");
INSERT INTO poy_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pa mashaka matatu kwingira kumkoa, Festu kalawiti kaisariya kagenda Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Watambika wakulu pamwera na walongoziya wa Shiyawudi wampiti shisoweru kuusu mashitaka gakaweriti naga Paulu. Wamluwiti Festu. ");
INSERT INTO poy_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Kawatenderi shitwatira shiheri kwa kumjega Paulu Yerusalemu. Waweriti watenda mpangu wamlagi pakawera mnjira. ");
INSERT INTO poy_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Kumbiti Festu kankula “Paulu hakasigali mshibetubetu kulii Kaisariya na neni hang'endi aku ulavinu. ");
INSERT INTO poy_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Muwaleki walongu wenu wagendi haku pamwera naneni wagalavii mashitaka gawu kuusu yomberi handa katenda shoseri shidoda.” ");
INSERT INTO poy_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festu katamiti nawu kwa shipindi sha mashaka msheshi ama ligumba, shakapanu kawuya Kaisariya. Shirawu yakuwi kalikala pa kutozera, kaamuwa Paulu wamjegi pashizyungu. ");
INSERT INTO poy_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Shipindi Paulu pakiziti, Wayawudi waweriti walawa Yerusalemu wamzyengikiti wanjiti kulaviya masitaka gavuwa geni waweziti ndiri kugalanguziya. ");
INSERT INTO poy_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Kwa kujiteteya, Paulu katakuliti, “Neni ndenda ndiri likosa lyoseri kuusu Malagaliru ga Wayawudi, pota kuusu numba nkulu ya kumluwa Mlungu, pota kumhusu Kaisari.” ");
INSERT INTO poy_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festu kafiriti kulijegelera kwa Wayawudi na hangu kamkosiya Paulu, “Hashi, gufira ng'endi Yerusalemu na aku wakakutozi kulongolu kwaneni kuusu masitaka aga?” ");
INSERT INTO poy_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulu kankula, “Nankugoloka palongolu pa shizyungu sha Kaisari, na palaa panu ndo nfiruwa kutozwa. Handa ntambu yaguvimana mweni, nuwatendera ndiri Wayawudi vidoda vyoseri. ");
INSERT INTO poy_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Su, payiwera neni wera na likosa lyanfiruwa azabu ya kuhowa, nduwa ndiri mundekiziyi azabu ayi. Kumbiti handa kwahera unakaka pakati pamasitaka gawalaviyiti wantu awa, kwahera yakaweza kuntula neni kwa womberi. Ng'enda kulongolu kwa Kaisari!” ");
INSERT INTO poy_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Su, pa Festu kuyowera na washawuli wakuwi, kamgambira Paulu, “Gufira kugenda kwa Kaisari, su, gugendi kwa Kaisari.” ");
INSERT INTO poy_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Pamberi pa mashaka gavuwa ndiri, Mtuwa Agiripa na Beriniki wasokiti Kaisariya su kulaviya ligoya lyawu kwa Festu. ");
INSERT INTO poy_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Waweriti aku mashaka ng'o, Festu kamgambira mfalumi masitaka ga Paulu, “Kwana muntu yumu panu mweni Felisi kamtatiriti. ");
INSERT INTO poy_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Pangenditi Yerusalemu watambika wakulu wa numba ya Mlungu na wazewi wa Shiyawudi wamsitakiti na kunduwa numtozi. ");
INSERT INTO poy_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kumbiti neni ntakuliti handa shitiba shetu ndiri Warumi kumlaviya muntu kaazibiwi pamberi pa msitakiwa hakeniliwoni na wasitaki wakuwi shinaga ubaga na kumupa lupenu lwa kujiteteya kuusu masitaka aga. ");
INSERT INTO poy_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Su, pawasokiti panu, ngawalira ndiri, su tuliwoniti pashizyungu shirawu yakuwi, himiziya muntu ayu wamjegi. ");
INSERT INTO poy_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Wasitaki wakuwi wagolokiti kumbiti walaviya ndiri masitaka madoda handa ntambu yanweriti nankulolera. ");
INSERT INTO poy_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ira hera nweriti na likakatala nentu pamwera nayomberi kuusu dini yawu na kuusu muntu yumu yawamshema Yesu yomberi kahowiti, kumbiti Paulu kankukololera handa kamkomu. ");
INSERT INTO poy_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Neni maniti ndiri shakutenda kuusu shauli ali. Su, numkosiyiti Paulu handa kafira ng'endi kushizyungu Yerusalemu kulii kwaajili ya masitaka aga. ");
INSERT INTO poy_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kumbiti Paulu kendereyiti kulongolu, kaluwa walekiziyi mshibetubetu mpaka uwamuzi wa shitwatira ashi utendwi na Kaisari hangu amuwiti katami mshibetubetu mpaka paweza kumjega kwa Kaisari.” ");
INSERT INTO poy_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Su, Agiripa kamgambira Festu, “Nfira kumpikinira muntu ayu neni namweni, “Hagumpikiniri shirawu.” Festu kamgambira ");
INSERT INTO poy_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Hangu, shirawu yakuwi, Agiripa na Beriniki wiziti kwa nemeleru pakati pamdamu gwa kuliwona waweriti walikola na wakulu wa wanjagila na walongoziya wa lushi. Festu kaamuwiti Paulu wamjegi mnumba. ");
INSERT INTO poy_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festu kalongiti, “Mfalumi Agiripa na woseri wawaweriti panu pamwera na twenga! Panu paulongolu penu kwana muntu yomberi shipinga shoseri sha Wayawudi panu na Yerusalemu kulii wanalamikiriti pawatenda umatu handa kafiruwa kayi ndiri kuwera ukomu. ");
INSERT INTO poy_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kumbiti neni mona handa kaweriti katenda ndiri shoseri shidoda ata kafiruwa wamupi azabu ya kumlaga. Kumbiti Paulu mweni kendeleyiti kulongolu kwa Kaisari, amuwiti wamjegi. ");
INSERT INTO poy_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kwa uwega waneni nahera visoweru kamili vyeni weza kumlembera Kaisari kuusu yomberi. Ina mana numjega panu palongolu penu na palongolu paku mfalumi Agiripa, su pawamshunguziti kala, nwezi kuwera na shakulemba. ");
INSERT INTO poy_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwa mana iwezekana ndiri kumjega mtatilwa pota kukanda likosa shinaga ubaga.” ");
INSERT INTO poy_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Su, Agiripa kamgambira Paulu, “Guluusiwa kujiteteya.” Panu Paulu kanyoshiti liwoku lyakuwi kujiteteya hangu. ");
INSERT INTO poy_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Mtuwa Agiripa, nuliwona nana bahati lelu kujiteteya panlongulu paku kuusu mashitaka goseri aga geni Wayawudi waweriti watakula kuusu neni. ");
INSERT INTO poy_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Asa toziya gumweni gwenga ndo mwana malifa gwa ntambu za Wayawudi na migogolu yawu, nukuluwa su gumpikiniri kwa uhepelera. ");
INSERT INTO poy_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Wayawudi wavimana shisoweru sha makaliru gangu kwanjira uwananguta, mtambu yandamiti kwanjira kwanja pakati pa isi yangu aku Yerusalemu. ");
INSERT INTO poy_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Wavimana kwa shipindi shitali, na waweza kupitawulira, handa pawafira, handa kwanjira mwanzu ndamiti handa yumu gwa shipinga shana siyasa ikalipa nentu mudini yetu, yani shipinga sha Mafalisayu. ");
INSERT INTO poy_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na vinu na panu ntozwi toziya nulitumbira kwayidi kulii kweni Mlungu kawalagiliti wambuyi wetu. ");
INSERT INTO poy_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Lagilu ali ndo liraa lilii lyalitumbirwa na makabila lilongu na mbili lya maisi getu, wankumtendera Mlungu kwa nakaka paliwala na pashiru. Mtuwa mfalumi, Wayawudi wankunzitaki toziya ya litumbiru ali! ");
INSERT INTO poy_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kwa shishi mwenga mwona tabu nentu kujimira handa Mlungu kawazyukisiyaga yawahowiti? ");
INSERT INTO poy_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Nakaka neni namweni njimiriti handa ndo lihengu lyangu kutenda vitwatira vivuwa kulirema litawu lya Yesu gwa Nazareti. ");
INSERT INTO poy_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Shitwatira ashi ndo shantenditi aku Yerusalemu. Neni namweni mpatiti uwezu kulawa kwa Watambika wakulu, mpatiti kuwatula mushibetubetu wavua wa wantu wa Mlungu. Nawomberi pawatozitwi kuwahowiziya, ngalambuziiti simbi za kujimira. ");
INSERT INTO poy_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ntambu yimonga neni ng'enditi munumba za Mlungu panagalira womberi wazibiwi, naneni panjera kwa makakala wayigilangi njimiru yawu. Maya gangu gaweriti makulu nentu kwawomberi ata ng'enditi kuwatabisiya mlushi za patali. ");
INSERT INTO poy_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Kwa nfiru iraa ayi, ng'enditi Dameski shipindi shimu, neni nweriti na utuwa na malagiliru kulawa kwa Watambika Wakulu. ");
INSERT INTO poy_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mheshimiwa, shipindi panweriti mnjira, saa sita paliwala, moniti uweru mkulu kuliku wa mshenji pawuyaka kulawa kumpindi, uzyengeta neni na walii waweriti wanamwanja wayangu. ");
INSERT INTO poy_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Twawoseri twenga tuguwiti pasi, naneni mpikanira liziwu ling'ambira kwa Shiebraniya, ‘Sauli, Sauli! Kwa shishi gundenda? Gulitenda hera handa ng’ombi yakaguma liteki fimbu ya mtuwa gwakuwi.” ");
INSERT INTO poy_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Neni nkosiyiti, “ ‘Gwee gwa gaa Mtuwa?’ Mtuwa kankula, ‘Neni ndo Yesu mweni gwenga gwaguntabisiya. ");
INSERT INTO poy_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Gwimuki vinu, gugoloki. Nukulawira su nukutuli nakamu guweri ntumintumi gwangu. Guwalanguziyi wantu wamonga vitwatira vyaguviwoniti lelu na vilii vyeni vyankali hanukulanguziyi. ");
INSERT INTO poy_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Hanukulopoziyi na wantu wa Israeli na wantu wa Israeli na wantu wa maisi gamonga geni neni nukulagiliri kwawomberi. ");
INSERT INTO poy_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Hagugatumuliziyi masu gawu na kuwatenda womberi walawi muluwindu na kwingira muwulangala, walawi mumakakala ga Shetani na wamgalambukiri Mlungu su wapati ulekiziwu wa vidoda vyawatenditi na wapati uhala pakati pawu kwa walii yawapungitwi kwa njimiru yaiwera kwaneni.’ ” ");
INSERT INTO poy_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Hangu, Mtuwa Agiripa weza ndiri kuweri mkaidi kwa mawonu aga ga kumpindi. ");
INSERT INTO poy_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ila nyanjiti kubwera kwanja kwa wantu wa Dameski, shakapanu kwa walii wa Yerusalemu na isi yoseri ya Yudeya, na viraa kwa wantu wa maisi gamonga. Nuwahimiziyiti wamgalambukiri Mlungu na kulangalira kwa vitendu handa waleka vidoda vyawu vyawatenditi. ");
INSERT INTO poy_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Toziya ayi, Wayawudi wankamuliti paweriti Mnumba nkulu ya Mlungu, wajeriti kunaga. ");
INSERT INTO poy_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Kumbiti Mlungu kandangiti, na avi mpaka mashaka ga lelu ngoloka ugangamala panavia lulangaliru kwa woseri, wakulu na wadidini. Gatakula ndo galii geni wambuyi na Musa watakuliti hagalawiri. ");
INSERT INTO poy_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Yani kafiruwa Kristu katabiki na kaweri gwa kwanja kuzyuka kulawa kwa wahowiti, su wabweri handa uweru wa ulopoziya uwalangalira vinu wantu woseri, Wayawudi na viraa wantu wawawera ndiri wayawudi.” ");
INSERT INTO poy_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulu pakayiziti panu mukujiteteya kwakuwi, Festu katakuliti kwa liziwu likulu, “Paulu! Gwana lukwali! Kubetula kwaku kuvuwa kukujegera lukwali!” ");
INSERT INTO poy_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Kumbiti Paulu katakula, “Nahera lukwali mtuwa Festu. Shantakula ndo nakaka hera. ");
INSERT INTO poy_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Gwenga Mfalumi guvimana vitwatira avi, hangu weza kuyowera pota lyoga palongolu paku. Nahera shashatika handa malawiru aga gamanika kwakuwi toziya shitwatira ashi shitendeka ndiri kwakulififa. ");
INSERT INTO poy_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mfalumi Agiripa, hashi, gwana njimiru na wambuyi? Nuvimana handa gujimira.” ");
INSERT INTO poy_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agiripa kamwankula Paulu, “Mushipindi shididini hera, hashi gulihola haguntendi nweri Mkristu?” ");
INSERT INTO poy_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulu kamwankula, “Nankumluwa Mlungu handa, kwa katepu ama shipindi shitali, gwenga ndiri hera ila woseri yawampikinira leru wapati kuwera ntambu yanwera neni, kumbiti pota minyololu ayi.” ");
INSERT INTO poy_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Panu Mfalumi Agiripa, mkulu wa mkowa, Beriniki na woseri walii wawaweriti pamwera nawomberi, wagolokiti. ");
INSERT INTO poy_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Pawawukiti kala, waligambiziyana, “Muntu ayu katenda ndiri shoseri shashifiruwa azabu ya kumlaga ama kutatirwa.” ");
INSERT INTO poy_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Yomberi Agiripa kamgambira Festu, “muntu ayu kaweza kuyopolwa handa mekaweriti ndiri kakata lufaa kwa Kaisari.” ");
INSERT INTO poy_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Pawaamuwiti kala twendereyiti na mwanja mpaka Italiya, wamtuliti Paulu pamwera na watatirwa wanonga pasi pa ulolera wa Yuliu yakaweriti mkulu gwa mashonta pakati shipinga yawashishema “shipinga sha Augustu.” ");
INSERT INTO poy_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tukweniti meli ya Adiramitu iweriti yangugenda na kupitira bandali zimu za mkowa gwa Asiya, tuyanja mwanja. Alisitariku, mwenikaya gwa Makedoniya kulawa Tesaloniki, kaweriti pamwera natwenga. ");
INSERT INTO poy_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Shirawu yakuwi tusulusiyi nanga pakati pa bandali ya sidoni. Yuliu kamtendiriti Paulu viheri kwa kumluusu kawawoni waganja wakuwi na kumpanana nfiru zyakuwi. ");
INSERT INTO poy_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kulawa aku twendereyiti na mwanja, kumbiti kuweriti na lihega liweriti lyankuvuma kwa kanongola nentu kutuyizira kwa ulongolu, tupitiliti uwega wa shisiwa sha kupiru kweni lihega liweriti livuwa ndiri. ");
INSERT INTO poy_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Shakapanu tulokiti bahali ya kilikiya na Pamfiliya, tusulusiiti nanga Mura, lushi lya Lukiya. ");
INSERT INTO poy_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Panu afisa ulii kawoniti meli yimu ya Alekizandiriya yaiweriti yankugenda Italiya, na hangu katukweniziya twingira mngati mwakuwi. ");
INSERT INTO poy_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tugenditi mpolimpoli kwa mashaka gavuwa na kwa ntabiku tusokiti pakwegera na Kenidu. Toziya lihega liweriti lyankali lyankutukoma, tupitira uwega wa kushana kushisiwa sha Kireti, kugenda Salumoni. ");
INSERT INTO poy_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tupititi pambeku yakuwi mpolimpoli kwa ntabika tuyingiriti pahali pawapashema “Bandali nyanyi,” pakwegera na lushi lwa Laseya. ");
INSERT INTO poy_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Shipindi shivuwa shipititi, na hata mashaka ga kulikala pota kuliya gaweriti gaperiti kala. Vinu iweriti atali nentu kugenda na meli. Su, Paulu kawayupiti moyu, ");
INSERT INTO poy_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Watuwa, nulihola handa mwanja agu haguweri gwa ntabiku na kwa asala ivuwa kwa memiziwu ya meli hera, ila viraa kwa makaliru getu.” ");
INSERT INTO poy_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kumbiti afisa ulii kakwegitwi nentu na maholu ga nahoza na ga mweni kana meli kuliku galii gakatakuliti Paulu. ");
INSERT INTO poy_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Toziya bandali ayi iweriti ndiri pahala paherepa pa kulivaga shipindi sha mbepu, wavuwa wafiriti kwendeleya na mwanja, payiwezekana mpaka Foiniki. Foiniki ndo bandali ya Kireti yaigenda kushana na kwaguzyeta mshenji na kusika na kwaguzyeta mshenji, na aku mewawezi kulivaga shipindi sha mbepu. ");
INSERT INTO poy_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Su, lihega lyanyanyi lya kusi lyanjiti kuvuma, nawomberi washeriti wapata lengu lyawu. Hangu wawusiya nanga, wendesha meli pakwegera nentu na mpeku ya Kireti. ");
INSERT INTO poy_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kumbiti katepu hera, lihega likalipa lishemwa “Lihega lya kusika” liyanja kuvuma kulawa kushisiwa. ");
INSERT INTO poy_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Lihega liikomiti meli ilii, na toziya tusinditi kulidiwira, tuyileka ijegwijegwi na lihega ali. ");
INSERT INTO poy_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Litanda limu lyalishemwa Kauda litupingira shididini kwa liyega lilii, na patupititi kusika mwakuwi tufauliti, iweriti kwa tabu, kusalimisha mtumbwi gwa meli. ");
INSERT INTO poy_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Wanamashi walii wagunikiti mtumbwi mngati, shakapanu wayizyengetiziya meli ngoyi na kuitawa kwa likakala. Watiriti kuwera mewawezi kugomuluwa pambeku pa Siriti. Hangu wasulusiyiti matanga na kuyileka meli ijegwijegwi na lihega. ");
INSERT INTO poy_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Lipuga lyendereyiti kuvuma na shirawu yakuwi wayanja kuyasa kunja shehena ya meli. ");
INSERT INTO poy_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Lishaka lya tatu, wayanja viraa kuyasa mmashi vintu vya meli kwa mawoku gawu weni. ");
INSERT INTO poy_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kwa shipindi sha mashaka gatangala tuweza ndiri kuwona mshenji ama ntondi, lipuga lyendereyiti kuvuma nentu, ata litumbiru lyoseri lya kuponeka litupera. ");
INSERT INTO poy_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Pa kulivaga shipindi shitali pota kuliya shiboga, Paulu kagolokiti pakati pawu, katakula, “Waheshimiwa, meyiweriti mbaka handa mungampikiniriti na kuleka mwanja kulawa Kireti handa mngatenditi hangu metushapili tabu ayi na asala zoseri azi. ");
INSERT INTO poy_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Kumbiti vinu nankuwaluweni muweri na moyu, kwahera hata yumu gwenu mekahowiziyi ukomu wakuwi, meli hera ndo haiyagamili. ");
INSERT INTO poy_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Toziya lishu ntumintumi gwa kumpindi gwa ulii Mlungu mweni neni ndo gwakuwi na yomberi neni numguwira kandawiliti, ");
INSERT INTO poy_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","kang'ambira, ‘Paulu, kotukutira! Mpaka hagugoloki pawulongolu pa Kaisari, na Mlungu, kwa lusungu lyakuwi kakutangi kwa kuwalopoziya woseri wawagenda mwanja na gwenga.’ ");
INSERT INTO poy_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Hangu, wahishimiwa, mulipanani moyu! Toziya numjimira Mlungu kuweri hayiweri teratera ntambu yawang'ambiriti. ");
INSERT INTO poy_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Kumbiti ndo mpaka hatuyaswi kumpeku kushisiwa tunga.” ");
INSERT INTO poy_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Pashiru pa lishaka lya lilongu na msheshi tuweriti twankukwegwa aku na aku mubahali ya Adria. Pakwegera na pashiru nentu, washima mitumbwi waliholiti kuwera wapakwegera na isi iyuma. ");
INSERT INTO poy_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Hangu wasakuliti utali wa bahari kwa kusulusiya lugoyi lwawatawiti shintu shitopa, wapata utali wa mita malongu msheshi. Shakapanu wapima kayi wapata mita malongu matatu. ");
INSERT INTO poy_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Toziya ya kutila kugomuluwa mumatalawu, wasulusiyiti nanga msheshi kumpeli kumeli, waluwa kushii kanongola. ");
INSERT INTO poy_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Wanamashi wafiriti kushapira, na wasulusiyiti kala mtumbwi mmashi, walipayira handa wagenda kusulusiya nanga uwega wa kulongolu kwa meli. ");
INSERT INTO poy_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Kumbiti Paulu kamgambiriti mkulu gwa jeshi ulii na wanjagila wakuwi, “Handa wanamashi awa hapeni wasigali mngati mwa mtumbwi, hapeni mlopoziwi.” ");
INSERT INTO poy_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Panu wanjagila walii wazidumuliti ngoyi zyaziweriti zikolera mtumbwi, waguleka gutolwi na mashi. ");
INSERT INTO poy_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Pakwegera na mandawira, Paulu kawahimiziyiti woseri walii shiboga “Kwa mashaka lilongu na msheshi vinu muwera mumashashatiku na pota kuliya, hamweni lii shintu shoseri. ");
INSERT INTO poy_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Su, nuwaluwa mlii shiboga toziya mshifira su muwezi kwendeleya kulikala. Toziya ata viri yimu mumituwi yenu hapeni yagamiri” ");
INSERT INTO poy_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pakatakulita kala hangu, Paulu katoliti libumunda, kalonga maya ga shi Mlungu pamberi pa woseri, kaumega, kanja kuliya. ");
INSERT INTO poy_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Panu woseri wapata moyu, na womberi vila waliya shiboga. ");
INSERT INTO poy_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Woseri waweriti wantu mia mbili na malongu saba na sita mumeli. ");
INSERT INTO poy_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Pa kila yumu kuliya shiboga sha kwikuta, wapunguliti kutopa kwa meli kwa kuyasa viboga mubahari. ");
INSERT INTO poy_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Pawushiiti, wanamashi wawezandiri kuyimana isi ilii. Ira wawoniti guba yimu yana mpeku, Waamuwa kusulusiya nanga aku handa payiwezikana. ");
INSERT INTO poy_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Hangu wazidumuliti nanga na kuzileka mubahari, na shipindi shiraa ashi waziyopola ngoyi zaziweriti ziguyopa msukanu, shakapanu wagolosiya tanga yimu palongolu kukola lihega, wagenditi kumpeku. ");
INSERT INTO poy_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kumbiti wasokiti pahali pena mikondu miwili ya bahari iliwona, na meli igomuluwa. Seemu ya palongolu iweriti imiruwa mumhanga pota kutikinyika. Seemu ya kumbeli ya meli iyanjiti kumegeka vipandi vipandi kwa makomangu ga likakala lya makupala. ");
INSERT INTO poy_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Wanjagira wafiriti kuwalaga watatirwa woseri kwa kutira handa wankusuga mpaka kumbeku na kutoloka. ");
INSERT INTO poy_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kumbiti toziya afisa jeshi ulii kafiriti kumlopoziya Paulu, kawaberiti nawatenda hangu. Kaamuliti walii yawamana kusuga wakopoki kulawa mumeli na kusuga mpaka kumpeku. ");
INSERT INTO poy_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Na wamonga wayizi pawalikolilera mumbawu ama muvipandi vya meli vyavimegikiti. Ndo twenga ntambu yatusokiti nyanyi kumpeku. ");
INSERT INTO poy_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Patusokiti kala nyanyi muisi iyuma, tuvimaniti kuwera shisiwa shilii shishemitwi Malita. ");
INSERT INTO poy_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Wenikaya wa palii watutendiriti gaherepa nentu. Vula iweriti yankwanja kutowa na kuweriti na mbepu, su wakoziyiti motu na watushemeriti woseri twenga. ");
INSERT INTO poy_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulu kasoliti shisanka shididini sha mbawu na pakashituliti mumotu, toziya ya livuki lya motu, njoka yakawera na usungu kalawiti mushisanka shilii na kumnyengelera muliwoku lyakuwi. ");
INSERT INTO poy_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Wenikaya wa palii pawamuwoniti njoka ulii kalinyengelera muliwoku lya Paulu, su waligambiziyana, “Muntu ayu kalagaga tembera kalopoziwa kulawa mubahali, kuhowa hapeni kumleki kalikali!” ");
INSERT INTO poy_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Kumbiti Paulu kampuntiriti njoka ulii mumotu na mweni katenduwitwi ndiri ata padidini. ");
INSERT INTO poy_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Wantu waweriti wankulolera mekatutumuki ama mekaguwi na kuhowa. Kumbiti pakwoyera kwa shipindi shitangala na kwona kwahera shoseri shashimlawiriti, womberi wagalamburiti maholu gawu na kwanja kulonga kuwera yomberi ndo mlungu. ");
INSERT INTO poy_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Pakwegera na pahala palii paweriti na malambu ga mkulu gwa shisiwa shilii yakashemitwi Publiu. Yomberi katuwankiti na kututendera kwa moyu guherepa kwa shipindi sha mashaka matatu. ");
INSERT INTO poy_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tati gwakuwi Publiu kagonjiti mushitanda, yomberi kaweriti kapyupa na kupweka mwazi. Paulu kingiriti mnumba su kamwoni na pakaluwa Mlungu, katula mawoku pamlweri na kumponiziya. ");
INSERT INTO poy_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Kulawirana na shitwatira ashi, wantu woseri yawalikaliti mushisiwa shilii, walii yawaweriti walweli su wiziti na waponiziwitwi. ");
INSERT INTO poy_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Womberi watupananiti ligoya nentu, na twenga patuweriti kala mumwanja kupitira mubahali, womberi watuliti mumtumbwi vintu vivuwa vyatuvifiriti. ");
INSERT INTO poy_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Pa miyezi mitatu twanjiti mwanja kayi kwa meli yaigolokiti pashisiwa shilii toziya ya shipindi sha mpepu. Meli ayi iweriti ya Alekizandiriya iweriti na alama ya milungu mawira yawashemwa Kasita na Polukisi. ");
INSERT INTO poy_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Patusokiti mlushi lwa Sirakusi, tulikaliti aku kwa mashaka matatu. ");
INSERT INTO poy_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kulawa kulii tugenditi pampeku pa bahari na tusokiti mlushi lwa Regiu. Lishaka lyalifatiti lyega lyalihera makakala lyanjiti kuvuma kulawa kusika, na kwa mwanja gwa mashaka mawili tusokiti mlushi lwa Potioli. ");
INSERT INTO poy_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Aku tuwawoniti walongu yawatushemiriti tulikali pamuhera nawomberi kwa lijuwa limu. Su twendereyiti na mwanja mpaka tusokiti Rumi. ");
INSERT INTO poy_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Walongu wa aku Rumi pawapatiti visoweru vyetu, womberi wiziti kulisoku lya Apiu na pahala papashemwa “mikahawa mitatu” kutwanka. Paulu pakawawoniti, yomberi kalongiti mayagashii Mlungu, su shitwatira ashi shimtenditi kaweriti na moyu. ");
INSERT INTO poy_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Patusokiti Rumi, Paulu wamlekeziyiti kulikala gweka yakuwi pakawera na mnjagira yumu gwa kumlolera. ");
INSERT INTO poy_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Pa mashaka matatu, Paulu kawashemiti pamuhera wakulu wa Shiyawudi. Pawajojinikiti kala, yomberi kawagambiriti, “Walongu wangu, tembera neni nuwatenda ndiri shitwatira shoseri wantu wetu ama vitiba vya watati wetu kumbiti nkamulitwi aku Yerusalemu na kutulwa mumawoku mwa Warumi. ");
INSERT INTO poy_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Pawankosiyiti kala na kuwona nahera shidoda shoseri, womberi wafiriti kulekeziya. ");
INSERT INTO poy_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Kumbiti Wayawudi wamonga walemiti shitwatira ashi, neni nazimika kukata lufaa kwa Kaisari tembera neni nweriti ndiri na shoseri sha kuwasitaki wantu wa lushi lwangu. ");
INSERT INTO poy_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Toziya ayi nduwa kuliwona na kuyowera na mwenga, mana ndawalirwa minyololu ayi toziya ya litumbiru lilii lya Israeli.” ");
INSERT INTO poy_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Womberi wamwankula, “Twenga tuwanka ndiri luhamba lwoseri kulawa Yudeya kuusu gwenga, ama kwahera mlongu yoseri yakiziti panu na kulaviya shisoweru ama kutakula shoseri shidoda kuusu gwenga. ");
INSERT INTO poy_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kumbiti metufiri kupikinira kulawa kwaku shilii shaguhola toziya tuvimana kuwera kila pahala wantu wankutakulira madoda kuusu womberi.” ");
INSERT INTO poy_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Su pawapangiti lishaka lya kuliwona na womberi, wantu wavuwa wiziti kwanjira mandawira mpaka pamihi Paulu kawagambiriti vitwatira vivuwa na kulaviya ukapitawu kuusu Ufalumi wa Mlungu. Yomberi kajeriti kuwatenda wajimiri shisoweru kuusu Yesu kulawa Mumalagaliru ga Musa na malembu ga wambuyi wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Wamonga wawu wajimiriti shisoweru shakuwi kumbiti wamonga wajimira ndiri. ");
INSERT INTO poy_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Su womberi wajimilirana ndiri, na pawayanjiti kuwuka, Paulu katakuliti shitwatira shimu, “Rohu Mnanagala katakuliti nakaka na watati wenu palii kupitira Isaya mbuyi gwa Mlungu, ");
INSERT INTO poy_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Pakalongiti, ‘Gugendi kwa wantu awa na gukawagambiri, kupikinira hampikiniri, kumbiti hapeni mwerewi, kulola hamloli, kumbiti hapeni mwoni. ");
INSERT INTO poy_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Toziya myoyu ya wantu awa iwera ikamala, na makutu gawu gadiwa womberi wawona ndiri. Pamonga womberi mewaloli kwa masu gawu na mewapikaniri kwa makutu gawu, mewavimani kwa myoyu yawu na mewang'alambukiri, na neni meniwaponiziyi.’ ” ");
INSERT INTO poy_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Su neni nfira mwenga muvimani kuwera ulopoziya wa Mlungu ujegwa kwa wantu yawawera ndiri Wayawudi na womberi hawapikiniri!” ");
INSERT INTO poy_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Na yomberi pakatakuliti kala visoweru avi, Wayawudi wawuka pawawera na visoweru mumyoyu mwawu. ");
INSERT INTO poy_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Kwa shipindi sha vinja viwili vyoseri Paulu kalikaliti kulaa pakaya pakapangiti mweni, kaweriti kankuwashemera woseri yawasokiti kumulamsiya. ");
INSERT INTO poy_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Kwa ugangamala na pota na lyoga yomberi kaweriti kankuwubwera Ufalumi wa Mlungu na kufunda kuusu Mtuwa Yesu Kristu.");
INSERT INTO poy_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Neni Paulu mmanda gwa Kristu Yesu, Mlungu kansyaguliti neni weri ntumintumi na yakanshemiti mbweri Shisoweru shakuwi Shiwagira. ");
INSERT INTO poy_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Shisoweru Shiwagira ashi ndo shilii Mlungu shakawalagiliti kala wantu wakuwi kupitira wambuyi wakuwi Mumalembu Mananagala. ");
INSERT INTO poy_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Shisoweru Shiwagira ashi shimuyowelera Mwana gwakuwi, Mtuwa gwetu Yesu Kristu, munshimba kayiwukiti muwukowu wa Dawudi. ");
INSERT INTO poy_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Kumbiti Rohu Mnanagala kamlanguziyiti Yesu Kristu Mtuwa gwetu kawonikaniti kuwera Mwana gwa Mlungu kana makakala pakamzyukisiyiti. ");
INSERT INTO poy_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kupitira mweni, Mlungu kamupananiti neni manemu ga kuwera ntumintumi gwa Kristu, su nuwalongoziyi wantu wa isi zoseri wajimili kulawirana na njimiru. ");
INSERT INTO poy_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Na mwenga viraa yamuwera Rumi, mwenga Mlungu yakawashemiti muweri wantu wakuwi Yesu Kristu. ");
INSERT INTO poy_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Su nuwalembilera mwawoseri mwenga yamulikala Rumi, ndoweni Mlungu yakawafira na yakawashemiti muweri wantu wakuwi. Manemu na ponga ga Tati gwetu Mlungu na Mtuwa gwetu Yesu Kristu gaweri pamuhera na mwenga. ");
INSERT INTO poy_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Pamberi pa goseri, neni nonga mayagashii kwa Mlungu gwangu kupitira Yesu Kristu kwa mwawoseri mwenga, toziya wantu wa pasipanu poseri wapikinira kuusu njimiru yenu. ");
INSERT INTO poy_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Mlungu yanumtendera kwa moyu gwangu gwoseri kwa kushibwera Shisoweru Shiwagira sha Mwana gwakuwi, ndo mkapitawu gwangu kwa shilii shantakula kuwera sha nakaka. Mlungu kavimana kuwera nuwahola mwenga ");
INSERT INTO poy_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","mashaka goseri nsali. Numuluwa Mlungu pakafira mweni kampanani lupenyu lwa kuwatyangira mwenga vinu. ");
INSERT INTO poy_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Toziya nfira nentu kuwawona su mpati kuwapanana mafupu yagalawa kwa Rohu Mnanagala, gagatenda muweri mgangamala. ");
INSERT INTO poy_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Shantakula ndo ashi, yanamana kuwera twoseri hatutangani, njimiru yenu hayinkamaziyi neni na njimiru yaneni hayiwakamaziyi mwenga. ");
INSERT INTO poy_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Waganja wangu, nfira muvimani kuwera mala zivuwa nfiriti kuwatyangirani mwenga, kumbiti kuweriti na shintu shashineweleriti kutenda hangu. Nfira mpati mota nkulu neni weri pakati pa mwenga ntambu yampatiti pakati pa wantu wamonga yawawera Wayawudi ndiri. ");
INSERT INTO poy_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nana uwanda wa kutenda kwa wantu woseri yawawera Wayawudi na wantu yawawera ndiri Wayawudi, viraa kwa wantu yawawera na luhala pamuhera na wantu yawahera luhala. ");
INSERT INTO poy_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Toziya ayi, nfira nentu kubwera Shisoweru Shiwagira kwa mwenga viraa yamulikala Rumi. ");
INSERT INTO poy_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mona ndiri soni kubwera Shisoweru Shiwagira, toziya geni ndo makakala ga Mlungu kuwalopoziya wantu woseri yawawera na njimiru, kwanja Wayawudi shakapanu viraa kwa wantu yawawera Wayawudi ndiri. ");
INSERT INTO poy_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Toziya Shisoweru Shiwagira shimlanguziya Mlungu ntambu yakawajimira wantu waweri waheri kulongolu kwakuwi. Shitwatira ashi shitendeka kwa njimiru kwanjira lishaka lya kwanja mpaka upeleru. Ntambu Malembu Mananagala galembitwi, “Muntu yakamfiriziya Mlungu, hakalikali kwa njimiru.” ");
INSERT INTO poy_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Maya ga Mlungu gagubutulwa kulawa kumpindi kuusu vidoda na ukondola wa wantu ndoweni kwa njira zyawu zidoda zilema unakaka naumanikana. ");
INSERT INTO poy_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Mlungu hakawakomangi womberi, toziya goseri yagaweza kumanikana kwa Mlungu ga paweru, Mlungu mweni kagatenda gaweri paweru kwa womberi. ");
INSERT INTO poy_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kwanjira Mlungu pakawumbiti pasipanu, zyumi zyakuwi na uwezu wakuwi wa mashaka goseri na umlungu wakuwi, tembera viwoneka ndiri kwa masu, womberi wavimaniti vintu vyakavinyawiti Mlungu. Su wantu hapeni waweri na shipayiru. ");
INSERT INTO poy_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Womberi wammana Mlungu, kumbiti wampananiti ndiri ligoya lyalifiruwa ama kulonga mayagashii, kumbiti maholu gawu gawera gapotoka na mahala gawu gamema luwindu. ");
INSERT INTO poy_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Womberi walonga wawera na luhala kumbiti ndo wazyigizyigi. ");
INSERT INTO poy_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Wagalambuziyiti ukwisa wa Mlungu yakalikala mashaka goseri na womberi wafatiti ukwisa wa vinyagu vyavinyawa mfanu gwa muntu yakahowa ama wampongu ama wankanyama ama vigongolu yavikwawakwawa. ");
INSERT INTO poy_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Su Mlungu kawaleka womberi watendi vitwatira vidoda vya lumata lya myoyu yawu na kulitenderana vitwatira vya soni munshimba zyawu. ");
INSERT INTO poy_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Womberi wawugalambula unakaka kuusu Mlungu kwa upayira, su waviguwira na kuvitendera vilii Mlungu vyakaviwumbiti pa mweni yakaumba, ndomweni kafiruwa kukwiswa mashaka goseri! Yina haa. ");
INSERT INTO poy_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Toziya womberi watenda hangu, Mlungu kawaleka watendi vitwatira vya soni. Ata wadala waleka kuliwona na wapalu na waligonjeka weni kwa weni. ");
INSERT INTO poy_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ntambu iraayi na wapalu, waleka kuliwona na wadala, waligonjeka weni kwa weni na walitenderana vitwatira vya soni, su malawiranu gakuwi walijegera weni azabu yayilawirana kwa vitendu vyawu vidoda vyawavitenda. ");
INSERT INTO poy_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Toziya wantu awa mumaholu gawu walemiti kummana Mlungu, Mlungu kawaleka mumaholu gawu gapotoka, watenda galii ndogeni gafiruwa ndiri kutendwa. ");
INSERT INTO poy_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Wamema ntambu zyoseri zya udoda na zuluma na lwaliya na ufisadi na weya na ulagaji na ndewu na upayira na nfiru idoda. Womberi wasengenya ");
INSERT INTO poy_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","na kulitakulirana udoda weni kwa weni, womberi ndo wantu yawamkalaziya Mlungu na womberi ndo wafizuli na yawawera na shibuli na kuliona na kutenda madoda na yawajimira ndiri walera wawu. ");
INSERT INTO poy_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Womberi wahera nfiru, watenda ndiri vilii vyawalagiliti na wahera uheri ama lusungu kwa wamonga. ");
INSERT INTO poy_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Wavimana kuwera Malagaliru ga Mlungu galonga kuwera wantu yawalikala ntambu ayi, wafiruwa kuhowa. Hera ndiri kwa womberi kwendeleya kutenda vitwatira avi, kumbiti wajimilirana na wamonga yawatenda vitwatira avi. ");
INSERT INTO poy_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ganja gwangu, hashi gwenga gwankuwatoza wamonga? Gwenga nakamu hapeni gujiteteyi, ata handa gwenga gwagaa, toziya paguwatoza wamonga, shakapanu gwenga gutenda vitwatira viraa vilii vyawatenda womberi, su gulitoza gumweni. ");
INSERT INTO poy_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tuvimana kuwera utoza wa Mlungu kwa wantu yawatenda vitwatira gambira avi, ndo ugoloka panakaka. ");
INSERT INTO poy_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Kumbiti gwenga ganja gwangu yaguwatoza wantu yawatenda vitwatira gambira yaguvitenda gwenga, hashi, gwenga gulihola kuwera hapeni gupati utoza wa Mlungu? ");
INSERT INTO poy_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ama guzarawu lusungu lwakuwi lukulu, ustaimilivu wakuwi na uhepera wakuwi? Nakaka guvimana kuwera Mlungu ndo muheri, toziya yomberi kankujera kukulongoziya guleki vidoda vyagutenda. ");
INSERT INTO poy_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kumbiti gwenga gwana ukamala na ukayidi wa moyu, su gwankulinyawira azabu gumweni kwa lishaka lilii lya maya ga Mlungu na utoza wa uheri wakuwi haugubutulwi. ");
INSERT INTO poy_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Lishaka ali Mlungu hakamlipi kila muntu kugenderana na matendu gakuwi. ");
INSERT INTO poy_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Wantu walii yawatenda gaherepa na kusakula ukwisa na ligoya lya Mlungu na kotu kuhowa, Mlungu hakawapanani ukomu wa mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Kumbiti wantu wamonga yawawera wabinafsi, yawalema vitwatira viheri na kutenda vitwatira vidoda, Mlungu hakawamiminiri maya gakuwi. ");
INSERT INTO poy_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Hakuweri na ntabika pamuhera na utama kwa wantu woseri yawatenda vidoda. Haviwapati Wayawudi huti na shakapanu kwa wantu yawawera ndiri Wayawudi viraa. ");
INSERT INTO poy_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Kumbiti Mlungu hakawapanani ukwisa na ligoya na ponga kwa wantu woseri yawatenda maheri, kwa Wayawudi kwanja na viraa kwa wantu yawawera ndiri Wayawudi. ");
INSERT INTO poy_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Toziya Mlungu hakamtozi kila muntu teratera pota na kubagula. ");
INSERT INTO poy_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Wantu yawawera Wayawudi ndiri, walii yawahera Malagaliru ga Musa, womberi watenda vidoda na hawagamili pota na Lilagaliru. Wayawudi wawera na Lilagaliru, womberi watenda vidoda, su hawatozwi kwa Lilagaliru. ");
INSERT INTO poy_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Toziya ndiri yawapikanira Malagaliru kuwera ndo wamfiriziya Mlungu, kumbiti woseri yawagajimira Malagaliru ndo wamfiriziya Mlungu. ");
INSERT INTO poy_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Wantu yawawera Wayawudi ndiri wahera Malagaliru ga Musa, kumbiti womberi pawatenda vilii vyavilagalirwa Mumalagaliru ga Musa, su womberi wawera malagaliru gawu weni, ata womberi pawahera Malagaliru ga Musa. ");
INSERT INTO poy_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Mgenderanu gwawu gulanguziya kuwera Malagaliru galembwa mumyoyu mwawu. Myoyu yawu viraa ilanguziya kuwera shitwatila ashi ndo shanakaka, toziya maholu gawu mala zivuwa gawatoza na mala zimonga gawalolera. ");
INSERT INTO poy_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Su kulawirana na Shisoweru Shiwagira shanushibwera, ndo ntambu hayiweri mulishaka Mlungu pakatoza vitwatira vya ubada vya wantu kupitira Yesu Kristu. ");
INSERT INTO poy_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ntambu gaa kuusu gwenga? Gumweni gulishema Myawudi, gulitumbira Lilagaliru lya Musa na gulitumbira kuwera gwa Mlungu, ");
INSERT INTO poy_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","gushimana shakafira Mlungu gutendi na gulifunditi Mulilagaliru kusyagula shitwatira shiheri. ");
INSERT INTO poy_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Gwenga gwana unakaka kuwera gwa mlonguziya gwa lwisi na guwera ulangala kwa wantu woseri yawawera muluwindu, ");
INSERT INTO poy_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","guwera mfunda gwa wazyigizyigi na yawahera mahala. Gwana unakaka kuwera Mulilagaliru lya Musa gwana mfanu gwa mahala gakamilika. ");
INSERT INTO poy_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Su gwenga guwafunda wamonga, iwera hashi gulifunda ndiri gumweni? Guwabwelera wamonga nawiwa, kumbiti gumweni gwiwa. ");
INSERT INTO poy_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Gulonga, “Namtenda uhumba,” kumbiti gumweni gwankutenda uhumba. Guvikalalira vinyagu, kumbiti gwenga gulitulira ulunda kwa kwiwa mnumba zya vinyagu. ");
INSERT INTO poy_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Gwenga gulitumbira gwana Lilagaliru lya Mlungu, kumbiti gumzarawu Mlungu kwa kugalema Malagaliru gakuwi. ");
INSERT INTO poy_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Malembu Mananagala galembwa, “Toziya ya mwenga Wayawudi, wantu yawawera Wayawudi ndiri waligilanga litawu lya Mlungu.” ");
INSERT INTO poy_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Handa pamulijimila Lilagaliru lya Musa, kwingiziwa jandu kwamwenga hakuweri na mana, kumbiti pamjimila ndiri Lilagaliru lya Musa mbaka memleki kwingira jandu. ");
INSERT INTO poy_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Handa muntu yakawera ndiri Myawudi, ndomweni kashemitwi kayingiziwitwi ndiri jandu, pakalijimira lyalifiruwa Mulilagaliru lya Musa, Mlungu hakamuholi kuwera kayingiziwa jandu. ");
INSERT INTO poy_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Wantu yawawera Wayawudi ndiri, hawakutozi gwenga Myawudi toziya gulilema Lilagaliru lya Musa, ata paguwera na malembu ga Lilagaliru lya Musa na gwingiziwa jandu, kumbiti womberi walijimira Lilagaliru lya Musa, ata pawawayingiziwitwi ndiri jandu. ");
INSERT INTO poy_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Huti ndiri kila muntu yakawoneka kwa masu kuwera Muyawudi ndo Muyawudi gwanakaka, ama muntu hapeni kaweri Muyawudi gwanakaka toziya kingiziwa jandu. ");
INSERT INTO poy_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Myawudi gwanakaka ndo ulii yakaweriti Myawudi mngati, ndomweni yakayingiziwa jandu mumoyu na ali ndo lihengu lya Rohu gwa Mlungu, ndo shitwatila ndiri sha malembu ga Lilagaliru. Muntu gwa ntambu ayi kapananitwi uzyumi, kulawa ndiri kwa wantu kumbiti kulawa kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Su Myawudi kana shishi shongeleka kuliku wamonga? Ama kwingira jandu kwana mota gaa? ");
INSERT INTO poy_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Yina, kwana mota zivuwa! Mlungu kawapananiti huti Wayawudi ujumbi wakuwi. ");
INSERT INTO poy_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Kumbiti hashiweri ashi handa wamu wawu waweriti ndiri wajimirika, hashi, shitwatira ashi hashiwusiyi ujimirika wa Mlungu? ");
INSERT INTO poy_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ndala! Mlungu hakasigali gwa nakaka mashaka goseri, tembera wantu woseri wawera wapaya. Malembu Mananagala galembwa, “Kila paguyowera, visoweru vyaku vyavimfiriziya Mlungu, hagukanki masitaka gaku mushizyungu.” ");
INSERT INTO poy_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Kumbiti payiwera vidoda vyetu vilanguziya kuwera Mlungu kankutenda kwa uheri, su hatulongi kuwera Mlungu kapata ndiri uheri pakatwazibu? Neni nankutakula shimuntu. ");
INSERT INTO poy_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ndala! Meyiweri hangu, hashi Mlungu mekawezi kutoza pasipanu? ");
INSERT INTO poy_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Pamonga hagulongi, payiwera neni namwaminika ndiri, wankumlanguziya Mlungu kuwera mwaminika nentu na kumpanana ukwisa, su mentakiwiti ndiri kutozwa kuwera gambira muntu yakana vidoda! ");
INSERT INTO poy_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Sawa na kulonga, “Tutendi vidoda su tupati viheri!” Wantu wamonga watuhigilanga kwa kutupayira handa tufunda ntambu ayi. Womberi hawatozwi ntambu yawafiruwa. ");
INSERT INTO poy_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","“Hashi, tulongi kuwera Wayawudi ndo waheri kuliku wantu yawawera ndiri Wayawudi? Ndala! Nanguziya kala kuwera Wayawudi pamuhera na wantu yawawera ndiri Wayawudi, woseri walongoziwa na vidoda.” ");
INSERT INTO poy_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ntambu Malembu Mananagala galembwa, “Kwahera ata muntu yumu yakawera muheri kulongolu kwa Mlungu, ");
INSERT INTO poy_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Kwahera muntu yakavimana ama ndomweni yakamsakula Mlungu. ");
INSERT INTO poy_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Woseri wapotoka, woseri wakosa, kwahera yakatenda viheri, kwahera ata muntu yumu. ");
INSERT INTO poy_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Makulamiru gawu gawera gambira lipumba lyalupalahera, milimi yawu yimema upayira, na mumilomu mwawu mlawa visoweru vyavilifana gambira usungu wa njoka. ");
INSERT INTO poy_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Visoweru vyawu vimema virapu vikalipa. ");
INSERT INTO poy_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Magulu gawu gakanongola kulaga, ");
INSERT INTO poy_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Poseri pawagenda, womberi waleka ntabika na uharibisiya. ");
INSERT INTO poy_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Womberi wayimana ndiri njira ya ponga, ");
INSERT INTO poy_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Wamtira ndiri Mlungu.” ");
INSERT INTO poy_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Vinu tuvimana kuwera kila shintu Mulilagaliru lya Musa, shiwawusu wantu woseri yawawera pasi pa Lilagaliru lya Musa, su kuwanyamaziya wantu woseri na kutenda pasipanu poseri paweri pa utoza wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Toziya kwahera muntu yoseri yakajimirwa kuwera muheri kulongolu kwa Mlungu kwa kutenda shashilagalirwa Mumalagaliru ga Musa. Lihengu lya Lilagaliru lya Musa ndo kutulanguziya hera twenga handa twana vidoda. ");
INSERT INTO poy_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Kumbiti vinu, Mlungu yakatutenda twenga tuweri waheri kulongolu kwakuwi pota lilagaliru lya Musa. Lilagaliru lya Musa na malembu ga wambuyi wa Mlungu galaviya ukapitawu mushitwatira ashi. ");
INSERT INTO poy_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Mlungu kawajimira wantu kuwera waheri kulongolu kwakuwi kupitira njimiru yawu kwa Yesu Kristu. Mlungu katendaga hangu kwa woseri yawamjimira Kristu, toziya kwahera ubagula woseri. ");
INSERT INTO poy_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Wantu woseri watenda vidoda na wapatali na ukwisa wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Kumbiti kwa lifupu lya manemu ga Mlungu, wantu woseri wamfiriziya Mlungu kwa njira ya Yesu Kristu yakawakombola. ");
INSERT INTO poy_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Mlungu kamlaviyiti Yesu, su kwa mwazi gwakuwi kaweri njira ya kuwalekiziya wantu vidoda vyawu kwa njimiru yawu kwakuwi. Mlungu katenditi hangu su kapati kulanguziya kuwera mweni ndo muheri. Pamakashu Mlungu kaweriti muhepelera pota na kulishera vidoda vya wantu. ");
INSERT INTO poy_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Kwa njira ayi Mlungu kalanguziya kuwera mweni ndo muheri vinu na kamtenda muntu yoseri yakamjimira Yesu, kaweri muheri kulongolu kwakuwi. ");
INSERT INTO poy_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Hashi, tuweza kulitumbira kwantambu gaa? Ndala! Hashi, tulitumbira shishi? Hashi, tuweza kulitumbira mahengu getu? Ndala! Twenga tulopoziwa kwa njimiru. ");
INSERT INTO poy_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Toziya Mlungu kamtenda muntu kuwera muheri kulongolu kwakuwi kwa njimiru. Mlungu kawatenditi ndiri hangu toziya wankutenda shilii shashilagalirwa Mumalagaliru. ");
INSERT INTO poy_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Hashi, Mlungu ndo Mlungu gwa Wayawudi hera, ama viraa gwa wantu yawawera ndiri Wayawudi? Yina, Mlungu ndo gwa wantu yawawera ndiri Wayawudi viraa. ");
INSERT INTO poy_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Mlungu ndo yumu na yomberi hakawatendi Wayawudi kuwera waheri kulongolu kwakuwi kwa njimiru yawu na hakawatendi wantu yawawera ndiri Wayawudi kuwera waheri kulongolu kwakuwi kwa njimiru yawu viraa. ");
INSERT INTO poy_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Hashi, twankuitendera njimiru kugaleka Malagaliru? Ndala, kumbiti twankugajimira malagaliru gaweri na makakala nentu. ");
INSERT INTO poy_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Su twenga tutakuli hashi kuusu Aburahamu mbuyi gwetu? ");
INSERT INTO poy_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Handa Aburahamu katenditwi kamfiriziyi Mlungu kulawirana na vitwatira vyakatenditi, su yomberi kana shintu sha kulitumbira, kumbiti kulongolu ndiri kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Toziya Mumalembu Mananagala galembwa, “Aburahamu kamjimiriti Mlungu, Mlungu kumtenda muheri kulongolu kwakuwi toziya ya njimiru yakuwi.” ");
INSERT INTO poy_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Muntu yakatenda lihengu wamupa shibenamgongu, shibenamgongu shakuwi lifupu ndiri, kumbiti ndo shintu shakafiruwa kupananwa. ");
INSERT INTO poy_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Wantu woseri yawalitumbira munjimiru, walitumbira ndiri matendu, kumbiti wamjimiri Mlungu yakawalekiziya vidoda, su Mlungu kawona njimiru ya wantu awa na kuwatenda waweri waheri kulongolu kwakuwi. ");
INSERT INTO poy_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Na Dawudi katakuliti hangu kuusu nemeleru ya muntu ulii, Mlungu kamtenda kuwera muheri kulongolu kwakuwi pota kugashera matendu gakuwi. ");
INSERT INTO poy_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Mbaka walii yawalegiziwitwi vidoda vyawu, walii vidoda vyawu viwusilirwa! ");
INSERT INTO poy_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Mbaka muntu ulii, Mtuwa hapeni kawalangi vidoda vyakuwi.” ");
INSERT INTO poy_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Hashi, matekeleru gakalongiti Dawudi kuusu wantu yawayingiziyitwi jandu hera? Ndala! Shitwatira ashi shiwawusu viraa wantu woseri yawayingiziyitwi ndiri jandu. Kwatwenga tusomiti mumalembu Mananagala, “Aburahamu kamjimiriti Mlungu na toziya ya njimiru yakuwi, Mlungu kamtenda kaweri muheri kulongolu kwakuwi.” ");
INSERT INTO poy_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Hashi, Aburahamu kajimiritwi pamberi pa kwingiziwa jandu, ama pakingiziwitwi kala jandu? Yomberi kajimiritwi pamberi pa kwingiziwa jandu. ");
INSERT INTO poy_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Aburahamu kingizitwi jandu shakapanu, na kwingiziwa jandu aku kuweriti lilangaliru lya kulanguziya Mlungu kamtenditi kuwera muheri kulongolu kwakuwi toziya ya njimiru yakuwi yakaweriti nayu pamberi pa kwingiziwa jandu. Su Aburahamu kawera tati gwa shirohu kwa wantu woseri yawamjimira Mlungu na yawatenditwi na Mlungu kuwera waheri kulongolu kwakuwi ata weni pawayingiziwitwi ndiri jandu. ");
INSERT INTO poy_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Vilaa yomberi ndo tati gwa wantu woseri yawayingiziwitwi jandu, ndoweni walii yawayingiziwitwi ndiri jandu hera, kumbiti walii yawafata njimiru ilii yakaweriti nayu tati gwetu gwa shirohu Aburahamu pamberi pa kwingiziwa jandu. ");
INSERT INTO poy_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Mlungu pakamlagiliti Aburahamu na shileri shakuwi kuwera pasipanu meiweri pawu, su mweni katenditi, toziya ndiri ya Aburahamu kujimira Lilagaliru kumbiti toziya yomberi kajimiriti na katenditwi na Mlungu kuwera muheri kulongolu kwakuwi kwa njimiru. ");
INSERT INTO poy_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Handa shilii shakalagiliti Mlungu shiwera sha wantu walii yawajimira Lilagaliru, su njimiru hapeni iweri shintu na kwakalagiliti Mlungu hakuweri kwahera mana. ");
INSERT INTO poy_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Malagaliru gajega maya ga Mlungu, kumbiti handa kwahera malagaliru, hapeni kuweri na vidoda. ");
INSERT INTO poy_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Su lagilu lilawirana na njimiru, viraa lilawirana na manemu ga Mlungu kwa mbereka zyoseri zya Aburahamu, kwa wantu ndiri walii yawajimira lilagaliru kumbiti viraa kwa wantu walii yawajimira ntambu pakatenditi Aburahamu, toziya Aburahamu ndo tati gwa twoseri twenga. ");
INSERT INTO poy_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Malembu Mananagala ntambu yagalonga, “Nukutenda guweri tati gwa isi zivuwa.” Yomberi ndo tati gwetu kulongolu kwa Mlungu, ndomweni Aburahamu yakamjimira Mlungu yakawapananiti ukomu walii yawahowiti na amuli zyakuwi muvitwatira vyaviweriti ndiri, su viwera. ");
INSERT INTO poy_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Aburahamu kajimiriti na kulitumbira, ata pakuweriti kwahera toziya ya kulitumbira, su kawera “Tati gwa isi zivuwa,” ntambu Malembu Mananagala galembwa, “Mbereka yaku hayiweri shivuwa gambira ntondu.” ");
INSERT INTO poy_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Yomberi kaweriti mgogolu gwa umuli gwa vinja miya hangu, kumbiti njimiru yakuwi izotopa ndiri, tembera kavimani kuwera hapeni kapati mwana, viraa vilii mdala gwakuwi Sara kaweriti mpendi. ");
INSERT INTO poy_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Aburahamu kalekiti ndiri kujimira lagilu ya Mlungu, njimiru yakuwi imemiti makakala na kamupananiti ukwisa Mlungu. ");
INSERT INTO poy_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Kavimaniti nakaka kuwera Mlungu kaweza kutenda shilii shakalagiliti. ");
INSERT INTO poy_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ndo mana Aburahamu, kupitira njimiru, “katenditwi na Mlungu kuwera muheri kulongolu kwakuwi.” ");
INSERT INTO poy_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Payitakulwa, “Yomberi katenditwi kuwera muheri kulongolu kwa Mlungu.” Itakulwa ndiri kwa gweka yakuwi. ");
INSERT INTO poy_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Womberi watulembiliriti na twenga viraa yatutenditwi kuwera waheri, tumjimira Mlungu yakamzyukusiyiti Mtuwa gwetu Yesu. ");
INSERT INTO poy_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Toziya ya vidoda vyatwenga, kalaviriyitwi kahowi na kazyukisiyitwi, su katutendi tuweri waheri kulongolu kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Su vinu tutendwa kuwera waheri kulongolu kwa Mlungu kupitira njimiru, su twanayi ponga pamuhera na Mlungu kupitira Mtuwa gwetu Yesu Kristu. ");
INSERT INTO poy_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Yomberi katujega twenga kupitira njimiru muntambu ayi ya manemu ga Mlungu, ndo twenga vinu tulikala. Su twenga tunemelera litumbiru lyatutenda pamuhera ukwisa wa Mlungu. ");
INSERT INTO poy_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Viraa twenga tunemelera ntabika zya twenga, toziya twenga tuvimana kuwera ntabika ijega uhepelera, ");
INSERT INTO poy_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","na uhepelera ujega unakaka kwa Mlungu na unakaka ujega litumbiru. ");
INSERT INTO poy_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Litumbiru ali liweza ndiri kutuzyanga, toziya Mlungu katupananiti kala mafiliru gakuwi mumyoyu mwa twenga kwa njira ya Rohu Mnanagala, ndo yakawera lifupu lya Mlungu kwa twenga. ");
INSERT INTO poy_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Patuweriti twahera muntu gwakututanga kulawa muvidoda, shipindi shilii Kristu kahowiti kwa wantu yawatenditi vidoda. ");
INSERT INTO poy_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Shitwatira shikamala kwa muntu yoseri kuhowa kwa muntu muheri. Pamonga muntu kaweza kujera kuhowa kwa muntu kaherepa. ");
INSERT INTO poy_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Kumbiti Mlungu katulanguziya twenga ntambu yakatufira nentu, toziya shipindi patuweriti twankali twana vidoda, Kristu kahowiti kwajili ya twenga! ");
INSERT INTO poy_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kwa mwazi gwakuwi twenga watutenda tumfiriziyi Mlungu, ganakaka nentu kuwera hakatulopoziyi twenga kupitira yomberi kulawa mumaya ga Mlungu! ");
INSERT INTO poy_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Patuweriti wangondu wa Mlungu, kumbiti yomberi katukolaniziya mawoku kupitira kuhowa kwa Mwana gwakuwi. Vinu tukolaniziwa mawoku na Mlungu, ganakaka nentu kuwera hatulopoziwi kupitira makaliru ga Kristu! ");
INSERT INTO poy_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Kumbiti aga ndiri hera, twenga tunemelera toziya ya shilii shakatenditi Mlungu kupitira Mtuwa gwetu Yesu Kristu, ndomweni vinu katukolaniziya mawoku na Mlungu. ");
INSERT INTO poy_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Vidoda viziti pasipanu kupitira muntu yumu Adamu na vidoda vyakuwi vitenditi wantu wahowi. Malawiranu gakuwi, kuhowa kueneyiti kwa wantu woseri toziya woseri watenditi vidoda. ");
INSERT INTO poy_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Kuweriti na vidoda pasipanu pamberi pa Malagaliru kuwera, kumbiti vidoda vitulitwi ndiri mumaholu pota malagaliru. ");
INSERT INTO poy_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Kumbiti kwanjira shipindi sha Adamu mpaka shipindi sha Musa, kuhowa kuwakolitimlima wantu woseri yawalikala, ata kwa wantu woseri yawatenditi ndiri vidoda gambira vilii vyakatenditi Adamu pakalemiti kujimilira malagaliru ga Mlungu. Adamu kaweriti lilangaliru lya Kristu yakiziti pamberi. ");
INSERT INTO poy_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Kumbiti awa wawili walifana ndiri, toziya lifupu lya Mlungu lilifana ndiri na vidoda vya Adamu. Shitwatira ashi sha nakaka kuwera wantu wavuwa wahowiti toziya ya vidoda vya muntu yumu. Kumbiti manemu ga Mlungu ndo makulu nentu, su lifupu lyakuwi liwera kwa wantu wavuwa kupitira manemu ga muntu yumu, Yesu Kristu. ");
INSERT INTO poy_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Lifupu lya Mlungu liwera ndiri teratera na vidoda vya muntu yumu Adamu. Pa likosa lya muntu yumu Adamu, Mlungu katoziti, kumbiti pa makosa ga wantu wavuwa, Mlungu kawalekiziyiti. ");
INSERT INTO poy_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ndo nakaka kwa vidoda vya muntu yumu, kuhowa kwanjiti kukolamlima toziya ya muntu yumu. Kumbiti shakashitenditi muntu yumu Yesu Kristu ndo malawiranu gakuwi makulu nentu. Woseri wankiti manemu na lifupu ali lya kutendwa kuwera waheri kulongolu kwa Mlungu, hawakolimlima muwukomu kwa njira ya muntu ayu yumu, Yesu Kristu. ");
INSERT INTO poy_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Su likosa lya muntu yumu ntambu lyalijegiti kutoza kwa wantu woseri. Ntambu iraayi shitendu shimu shashimfiriziya Mlungu shiwatenda wantu woseri wamjimiri na Mlungu na kupananwa ukomu wa mashaka goseri. ");
INSERT INTO poy_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Handa kwa kujimira ndiri kwa muntu yumu, wantu woseri watenditwi kuwera na vidoda na ntambu iraayi kujimira kwa muntu yumu hakuwatendi wantu wavuwa wajimirwi waweri waheri kulongolu kwa Mlungu. ");
INSERT INTO poy_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Malagaliru galawiriti na gatenditi kwongereka vidoda, kumbiti vidoda pavyongerikiti, manemu ga Mlungu gwongerekiti nentu. ");
INSERT INTO poy_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Handa vidoda ntambu yavikolitimlima mukuhowa, viraa manemu ga Mlungu gakolamlima muuheri kulongolu kwa Mlungu na gutulongoziya twenga muwukomu wa mashaka goseri kwa njira ya Mtuwa gwetu Yesu Kristu. ");
INSERT INTO poy_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Su hatutakuli shishi? Hashi twendereyi kulikala muvidoda, su manemu ga Mlungu gongereki? ");
INSERT INTO poy_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ndala! Twenga tulikala gweka na vidoda, su hatwendereyi hashi kulikala kayi muvidoda? ");
INSERT INTO poy_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Nakaka muvimana kuwera twenga patubatizitwi tuwera pamuhera na Kristu Yesu, watubatiziti na tuwera pamuhera na mukuhowa kwakuwi. ");
INSERT INTO poy_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Su, patubatizitwi mumashi iweriti handa tusilwa pamuhera na Yesu, su Kristu ntambu yakazyukiti kwa makakala ga ukwisa wa Tati, kayi twenga tuwezi kulikala makaliru gasyayi. ");
INSERT INTO poy_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Toziya handa twenga tuwera pamuhera nayomberi mukuhowa, viraa vilii twenga hatuweri yumu pamuhera na yomberi mukuzyukisiya. ");
INSERT INTO poy_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Twenga tuvimana kuwera makaliru getu ga makashu gapinjikitwi pamuhera na Kristu palupinjika lwakuwi, su makakala ga vidoda gaagamiziwi, natuwera kayi wamanda wa vidoda. ");
INSERT INTO poy_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Shipindi wantu tuhowiti pamuhera na Kristu, tulekiziwa kulawa mumakakala ga vidoda. ");
INSERT INTO poy_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Kwanjira patuhowiti pamuhera na Kristu, twenga tujimira kuwera hatulikali kayi pamuhera na yomberi. ");
INSERT INTO poy_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Twenga tuvimana handa Kristu kazyukisiwitwi kala na