﻿USE sofia;
DROP TABLE IF EXISTS sofia.portft_vpl;
CREATE TABLE portft_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES portft_vpl WRITE;
INSERT INTO portft_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Esta é a história dos antepassados de Jesus Cristo/o Messias, descendente do Rei  Davi e de Abraão, de quem todos nós judeus somos descendentes. ");
INSERT INTO portft_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraão foi pai de Isaque. Isaque foi pai de Jacó. Jacó foi pai de Judá e dos irmãos mais velhos e mais novos de Judá. ");
INSERT INTO portft_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá foi pai de Peres e de Zerá, e a mãe deles foi Tamar. Peres foi pai de Esrom. ");
INSERT INTO portft_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Esrom foi pai de Arão. Arão foi pai de Aminadabe. Aminadabe foi pai de Nasom. Nasom foi pai de Salmom. ");
INSERT INTO portft_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmom e sua esposa Raabe, uma mulher gentia, foram os pais de Boaz. Boaz foi pai de Obede e a mãe de Obede foi Rute, outra mulher gentia. Obede foi pai de Jessé. ");
INSERT INTO portft_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jessé foi pai do Rei Davi. Davi foi pai de Salomão, e a mãe de Salomão antes estava casada com Urias. ");
INSERT INTO portft_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomão foi pai de Roboão. Roboão foi pai de Abias. Abias foi pai de Asa. ");
INSERT INTO portft_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa foi pai de Josafá. Josafá foi pai de Jorão. Jorão foi pai de Uzias. ");
INSERT INTO portft_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzias foi pai de Jotão. Jotão foi pai de Acaz. Acaz foi pai de Ezequias. ");
INSERT INTO portft_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequias foi pai de Manassés. Manassés foi pai de Amom. Amom foi pai de Josias. ");
INSERT INTO portft_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josias foi pai de Jeconias e dos irmãos de Jeconias. Eles viviam na época em que os babilônios levaram os israelitas para a Babilônia. ");
INSERT INTO portft_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Depois que os babilônios levaram os israelitas à Babilônia, Jeconias foi pai de Salatiel. Salatiel foi pai de Zorobabel. ");
INSERT INTO portft_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel foi pai de Abiúde. Abiúde foi pai de Eliaquim. ");
INSERT INTO portft_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eliaquim foi pai de Azor. Azor foi pai de Sadoque. Sadoque foi pai de Aquim. ");
INSERT INTO portft_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aquim foi pai de Eliúde. Eliúde foi pai de Eleazar. Eleazar foi pai de Matã. Matã foi pai de Jacó. ");
INSERT INTO portft_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacó foi pai de José. José foi esposo de Maria, e Maria foi mãe de Jesus. Jesus é aquele que se chama {que nós chamamos} o Messias. ");
INSERT INTO portft_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Como se pode calcular, tenho agrupado os antepassados de Jesus assim: houve uma sucessão de catorze deles desde o tempo em que Abraão viveu até o tempo quando o Rei Davi viveu. Houve uma sucessão de catorze deles do tempo de Davi até a época quando os babilônios levaram os israelitas para a Babilônia. Há uma sucessão de catorze deles desde a época quando os babilônios levaram os israelitas embora para a Babilônia até a época quando o Messias nasceu. ");
INSERT INTO portft_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","É esta a história do que aconteceu logo antes de Jesus Cristo nascer. Maria, sua mãe, era noiva de José {tinha prometido publicamente a José que ela se casaria com ele}. Antes de eles começarem a viver juntos, EUP Maria soube que estava grávida. Porém, foi o poder do Espírito Santo que fez com que ela ficasse grávida. EUP ");
INSERT INTO portft_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, que as pessoas consideravam ser esposo dela, era homem que obedecia aos mandamentos de Deus. Um desses mandamentos era que os homens deviam se divorciar das mulheres que tinham agido imoralmente. Como resultado, quando José soube que Maria estava grávida, ele imaginou que ela estivesse grávida porque tivesse agido imoralmente. Portanto, ele resolveu ––divorciar-se dela/desfazer o noivado. Mas porque ele não queria envergonhá-la publicamente, resolveu divorciar-se dela secretamente. ");
INSERT INTO portft_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Enquanto considerava isso seriamente, foi surpreendido com um sonho no qual viu um anjo enviado por Deus. O anjo disse: “José, descendente do Rei Davi, não se preocupe pensando que estaria fazendo errado se casasse-se com Maria. Pelo contrário, comece a tratá-la como sua esposa, já que o Espírito Santo, e não um homem, fez com que ela esteja grávida. ");
INSERT INTO portft_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ela dará à luz um filho. Já que é Ele que fará com que o povo dele não seja castigado como resultado de ter pecado, chame Ele de Jesus, que significa ‘o Senhor salva as pessoas ’”. ");
INSERT INTO portft_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tudo isso aconteceu como resultado daquilo que o Senhor fez um profeta escrever há muito tempo atrás. É isso que o profeta escreveu: ");
INSERT INTO portft_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Escutem, a virgem ficará grávida e dará à luz um filho. Chamarão a Ele de Emanuel”. Emanuel significa “Deus está conosco”. ");
INSERT INTO portft_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Quando José se levantou do sono, ele fez o que o anjo que Deus tinha enviado mandou. Ele começou a viver com Maria como esposa dele. ");
INSERT INTO portft_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mas ele não teve relações sexuais com ela EUP até que ela deu à luz um filho. E José deu a Ele o nome de Jesus. ");
INSERT INTO portft_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus nasceu na cidade de Belém, no distrito da Judeia, na época MTY em que o Grande Rei Herodes governava ali. Algum tempo depois que Jesus nasceu, alguns homens que estudavam as estrelas e que viviam em um país a leste da Judeia foram à cidade de Jerusalém. ");
INSERT INTO portft_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Perguntaram às pessoas ali: “Onde está aquele que nasceu para poder ser o rei de vocês, judeus? Cremos que um rei já nasceu, porque enquanto estávamos em um país que fica a leste daqui, vimos a estrela que achamos ser o indicador de que Ele já nasceu. Por isso, nós chegamos para louvá-lo”. ");
INSERT INTO portft_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Quando o Rei Herodes ouviu o que as pessoas estavam perguntando, ficou preocupado pensando que as pessoas talvez proclamassem outro rei dos judeus no lugar dele. Muitos dos habitantes da cidade de Jerusalém MTY, HYP também ficaram preocupados porque tinham medo do que o Rei Herodes faria. ");
INSERT INTO portft_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Então, ele reuniu todos os sacerdotes que governavam e os homens que ensinavam as leis judaicas ao povo e perguntou a eles onde os profetas tinham indicado que o Messias nasceria. ");
INSERT INTO portft_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Disseram a ele: “Ele nascerá na cidade de Belém, na província da Judeia, porque foi escrito por um profeta {um profeta escreveu} há muito tempo atrás o que Deus disse: ");
INSERT INTO portft_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Vocês que moram em Belém APO, no país chamado Judá, sua cidade certamente é muito importante LIT, porque um homem de sua cidade se tornará um governante. Ele guiará meu povo que mora em Israel’”. ");
INSERT INTO portft_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ao ouvir isso o Rei Herodes chamou secretamente aqueles homens que estudavam as estrelas e perguntou a eles exatamente quando a estrela apareceu pela primeira vez. Depois deles dizerem a ele, foi possível ele saber a idade da criança. ");
INSERT INTO portft_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Então ele disse mentindo a eles: “Vão à cidade de Belém e investiguem com cuidado onde o infante está. Quando acharem Ele, digam- me para que eu mesmo também possa ir até lá para adorá-lo”. ");
INSERT INTO portft_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Depois que eles ouviram o que o rei disse, saíram rumo a Belém. Muito para a surpresa deles, a estrela que tinham visto enquanto estavam naquele país no oriente foi de novo na frente deles até parar acima da casa onde a criança estava. ");
INSERT INTO portft_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Alegraram-se muito quando viram a estrela e a seguiram. ");
INSERT INTO portft_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Entraram naquela casa e viram a criança e Maria, a mãe dela. Ajoelharam-se e O adoraram. Então eles abriram suas caixas de tesouros MTY e deram ouro, incenso caro, e mirra a Ele. ");
INSERT INTO portft_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Já que Deus sabia que o Rei Herodes pretendia matar Jesus, em um sonho os homens que estudavam as estrelas foram aconselhados {Ele aconselhou os homens que estudavam as estrelas} que eles não deviam voltar ao Rei Herodes. Por isso voltaram ao país deles, mas em vez de viajar pela mesma estrada, foram pelo outro caminho. ");
INSERT INTO portft_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Depois que os homens que estudavam as estrelas saíram de Belém, um anjo do Senhor apareceu a José em um sonho. Ele disse: “Levante–se, leve a criança e sua mãe, e fujam para o país do Egito. Fiquem ali até que eu diga a você que devem sair, porque o Rei Herodes mandará soldados para procurar a criança para que eles possam matá-la”. ");
INSERT INTO portft_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Então José se levantou da cama, levou a criança com sua mãe naquela mesma noite e eles fugiram para o Egito. ");
INSERT INTO portft_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ficaram ali até o Rei Herodes morrer e depois saíram do Egito. Ao fazerem isso, foi cumprido/eles cumpriram o que o profeta Oseias escreveu, que foi dito pelo Senhor {que o Senhor disse}: “Já disse a meu filho para sair do Egito”. ");
INSERT INTO portft_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Enquanto o Rei Herodes ainda estava vivo, ficou furioso porque se deu conta de que tinha sido enganado pelos homens que estudavam as estrelas {os homens que estudavam as estrelas o tinham enganado}. Então, imaginando que Jesus ainda estivesse em Belém ou naquela região, Herodes mandou soldados para lá para matar todos os meninos de dois anos para baixo. Herodes calculou a idade do nenê segundo o que os homens que estudavam as estrelas lhe disseram sobre quando a estrela apareceu inicialmente. ");
INSERT INTO portft_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Já que Belém e Ramá ficavam na área onde viveram os descendentes de Raquel, esposa de Jacó, ao fazer assim foi cumprido {eles cumpriram} o que o profeta Jeremias escreveu: ");
INSERT INTO portft_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“As mulheres de Ramá estavam chorando e lamentando em voz alta. As mulheres que eram descendentes de Raquel SYN estavam em angústia pelo que aconteceu aos seus filhos. Mesmo que as pessoas falassem palavras de consolo para elas, elas não se consolaram {não deixavam de lamentar} porque seus filhos estavam mortos EUP”. ");
INSERT INTO portft_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Depois que Herodes morreu e antes de José e sua família saírem do Egito, ");
INSERT INTO portft_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","um anjo que o Senhor mandou apareceu a José no Egito em um sonho e disse: “Pegue a criança e a mãe dele e volte ao país de Israel para morar lá, porque aqueles que estavam procurando o menino EUP para matá-lo já morreram”. ");
INSERT INTO portft_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Então ele levou o menino e sua mãe, e eles voltaram para o país de Israel. ");
INSERT INTO portft_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Quando José soube que Arquelau agora governava no distrito da Judeia no lugar do seu pai, Rei Herodes o Grande, ele teve medo de ir lá. Pois foi aconselhado {Deus aconselhou José} em um sonho que ainda era perigoso eles morarem na Judeia, ");
INSERT INTO portft_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ele, Maria e Jesus foram para o distrito da Galileia na cidade chamada Nazaré para morar lá. Como resultado disso, o que foi dito pelos profetas há muito tempo atrás {o que os profetas antigos disseram} sobre o Messias, que Ele seria chamado homem de Nazaré, cumpriu-se {realizou-se}. ");
INSERT INTO portft_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Quando Jesus ainda estava em Nazaré, João, que as pessoas chamavam de o Batizador, foi a um lugar desolado/vazio no distrito da Judeia. ");
INSERT INTO portft_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ele pregava nesse lugar às pessoas que chegavam ali. Ele sempre dizia: “Vocês precisam deixar as suas más ações, porque Deus MET logo começará a governar sobre as pessoas, e Ele rejeitará vocês se vocês não deixarem a sua vida de pecado”. ");
INSERT INTO portft_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","João foi quem cumpriu o que foi dito pelo profeta Isaías {o que o profeta Isaías predisse/profetizou quando disse}: “Em um lugar desolado/deserto as pessoas ouvirão alguém gritar: ‘Preparem-se para receber o Senhor quando Ele vier, assim como as pessoas preparam a estrada MET para um oficial importante. Assim como as pessoas endireitam os caminhos para um oficial importante, preparem-se para que estejam prontos quando Ele vier MET, DOU!’” ");
INSERT INTO portft_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","João usava roupa feita de pelo áspero de camelo. Assim como o profeta Elias tinha feito há muito tempo, ele usava um cinto de couro na sua cintura. Sua comida era somente gafanhotos e mel que ele achava no lugar desolado. ");
INSERT INTO portft_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pessoas que moravam na cidade de Jerusalém MTY, muitos HYP que moravam em outros lugares no distrito da Judeia MTY e muitas HYP pessoas que moravam na região perto do Rio Jordão MTY foram a ele para ouvi-lo pregar. ");
INSERT INTO portft_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Depois que o ouviram dizer a eles para deixarem as suas ações más, eles confessaram abertamente os seus pecados e como resultado foram batizados por João {João os batizou} no Rio Jordão. ");
INSERT INTO portft_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Depois de João observar que muitos homens do grupo religioso dos fariseus e do grupo religioso dos saduceus estavam chegando a ele para que ele os batizasse, ele disse a eles: “Vocês são ruins como cobras venenosas são ruins. MET! Aviso vocês que Deus algum dia castigará MTY todos aqueles que pecam. Mas não pensem/será que alguém disse a vocês RHQ que podem escapar do castigo dele MTY se não deixarem de suas más ações! ");
INSERT INTO portft_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Portanto, façam o que é correto MET para aqueles que já desistiram de suas más ações antes de virem para mim para que eu os batize. ");
INSERT INTO portft_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Deus prometeu dar a Abraão muitos descendentes. Deus não precisa de vocês para cumprir aquela promessa! Ele pode transformar estas pedras para fazer delas descendentes de Abraão. Portanto, não comecem a dizer uns aos outros: ‘Já que nós somos descendentes de nosso antepassado Abraão, Deus não nos castigará mesmo que pequemos’. ");
INSERT INTO portft_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Deus está pronto para castigá-los se vocês não deixarem das suas más ações, assim como um homem põe seu machado na raiz de uma fruteira para derrubá-la e jogá-la no fogo se não produzir fruta MET”. ");
INSERT INTO portft_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Quanto a mim, eu não sou muito importante já que batizo vocês somente com água. Batizo vocês porque vocês se sentem tristes por causa dos seus pecados. Mas logo outro virá que é muito grande/importante; Ele fará coisas poderosas (OU, agirá poderosamente). Já que Ele é mais importante do que eu, não sou digno nem de fazer uma coisa simples para Ele, tal como carregar as suas sandálias. Ele fará com que o Espírito Santo capacite alguns de vocês a mudarem a sua maneira de viver MET, mas julgará o resto de vocês e vai castigá-los no fogo do inferno. ");
INSERT INTO portft_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ele é como um homem que quer recolher o trigo que fica no chão onde os outros o têm separado. Esse homem usa uma pá enorme para jogar o trigo no ar e separá-lo da palha MET. De modo semelhante, Deus separará as pessoas justas das pessoas más, assim como um homem recolhe o trigo no depósito. Depois, Ele queimará as pessoas que são como a palha, com fogo que nunca se apaga MET”. ");
INSERT INTO portft_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Naquela época, Jesus foi do distrito da Galileia para o Rio Jordão onde João estava, para ser batizado por João {para pedir que João O batizasse}. ");
INSERT INTO portft_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jesus pediu que João O batizasse, mas João não quis, dizendo: “Eu preciso ser batizado por você {preciso que você me batize} porque você é mais importante do que eu. Já que você não é pecador, ––você não deve/por que você–– RHQ vir/vem a mim para ser batizado por mim {para pedir que eu batize você}!” ");
INSERT INTO portft_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mas Jesus disse a ele: “Batize-me agora, porque desta forma nós dois faremos o que Deus requer”. Desse modo, João consentiu em batizá-lo. ");
INSERT INTO portft_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Depois dele ser batizado {Depois que João batizou Jesus}, Jesus logo subiu da água. Naquele momento, era como se o céu se abrisse {partisse}. Então, Jesus viu o Espírito de Deus descer sobre Ele. O Espírito veio em forma de uma pomba. ");
INSERT INTO portft_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Depois, Deus SYN falou do céu: “Este é o meu filho. Eu O amo e Ele me agrada muito”. ");
INSERT INTO portft_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Então Jesus foi guiado pelo Espírito {o Espírito de Deus guiou Jesus} para um lugar deserto para ser tentado pelo diabo {para que o diabo o tentasse}. ");
INSERT INTO portft_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Depois dele não comer nada de dia nem de noite por quarenta dias, ficou com fome. ");
INSERT INTO portft_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Satanás, o tentador, chegou a Ele e disse: “Já que você diz que tem relacionamento com Deus assim como o filho tem com seu pai, MET, prove isso mandando que estas pedras virem pão para que você possa comê-las!” ");
INSERT INTO portft_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mas Jesus disse a ele: “Não! Não transformarei as pedras em pão, porque é escrito {nas Escrituras Moisés escreveu}: ‘Comer comida sustenta as pessoas fisicamente, mas não as sustenta espiritualmente SYN. Pelo contrário, prestar atenção em tudo quanto Deus fala para elas é que sustenta as pessoas espiritualmente SYN’”. ");
INSERT INTO portft_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Aí o diabo O levou a Jerusalém, a cidade dedicada a Deus. Ele colocou Jesus na parte mais alta do templo ");
INSERT INTO portft_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","e disse a Ele: “Já que você diz que tem relacionamento com Deus assim como o filho tem com seu pai, prove isso pulando daqui para o chão. Isso não fará mal a você, pois está escrito nas Escrituras {que o salmista escreveu}: ‘Deus mandará seus anjos protegerem você; eles o levantarão nas mãos deles quando estiver caindo, para que você não se machuque. Você nem baterá o seu pé em uma pedra’”. ");
INSERT INTO portft_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mas Jesus disse: “Não! Não pularei daqui, porque em outro lugar nas Escrituras escreve-se {tem estas palavras que Moisés escreveu}: ‘Não ponha à prova o Senhor seu Deus para ver se Ele impedirá que algo mal aconteça a você quando você faz algo tolo!’” ");
INSERT INTO portft_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Depois, o diabo O levou para o cúmulo de um monte bem alto. Ali ele O mostrou todas as nações do mundo onde governam os reis e as coisas maravilhosas nessas nações. ");
INSERT INTO portft_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Então disse a Jesus: “Eu permitirei que você governe todas estas nações e lhe darei todas as coisas maravilhosas que há nelas se você se prostrar/ajoelhar e me adorar”. ");
INSERT INTO portft_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Então Jesus disse a ele: “Não, eu não adorarei você. Vá embora, Satanás! Escreve-se {Nas Escrituras que Moisés escreveu} o que ele disse às pessoas que adoram Deus: ‘É o Senhor seu Deus que vocês devem adorar e devem servir somente a Ele!’” ");
INSERT INTO portft_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Então o diabo O deixou e eis que alguns anjos chegaram e ministraram a Ele. ");
INSERT INTO portft_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Enquanto Jesus estava na Judeia, os discípulos de João disseram a Jesus que João, o Batizador, tinha sido colocado na prisão e guardado ali {que Herodes Antipas tinha colocado João, o Batizador, na prisão guardando-o ali}. Por isso Jesus voltou ao distrito da Galileia. Enquanto estava na Galileia, foi primeiro à cidade de Nazaré. ");
INSERT INTO portft_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Depois saiu da cidade de Nazaré e foi à cidade de Cafarnaum para morar ali. A cidade de Cafarnaum fica ao lado do lago da Galileia na região que antes era o território das tribos de Zebulom e de Naftali. ");
INSERT INTO portft_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ele foi para lá também para que o que foi escrito pelo profeta Isaías {o que o profeta Isaías escreveu} se cumprisse {acontecesse}: ");
INSERT INTO portft_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“A região de Zebulom e a região de Naftali ficam na estrada que passa perto do lago da Galileia, no lado leste do Rio Jordão. São as regiões no distrito da Galileia onde muitos gentios moram. ");
INSERT INTO portft_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Já que o povo que mora ali está pecando, eles serão como pessoas sentadas em um lugar escuro. MET De repente eles perceberão claramente o que Deus ensina, como pessoas que veem uma grande luz brilhando sobre elas MET percebem claramente até mesmo na escuridão. Serão como pessoas que estão em uma região onde é escuro e perigoso. MET De repente perceberão claramente o que Deus ensina, como pessoas sobre quem a luz brilha entendem claramente MET, DOU”. ");
INSERT INTO portft_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Quando Jesus estava na cidade de Cafarnaum, começou a pregar o seguinte às pessoas: “Vocês precisam sentir tristeza por pecarem e precisam deixar de pecar para se tornarem membros do grupo de pessoas que Deus governa e para que Deus não castigue vocês, porque logo Ele começará a governar e julgará vocês quando governar”. ");
INSERT INTO portft_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Certo dia quando Jesus estava andando ao lado do lago da Galileia, ele viu dois homens, Simão, que mais tarde se chamou Pedro, e André, o irmão mais novo dele. Estes homens estavam jogando suas redes de pescar no lago porque ganhavam a vida pescando e vendendo o peixe. ");
INSERT INTO portft_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ele disse a eles: “Da mesma forma que vocês colhem peixe, venham comigo, e eu ensinarei vocês a como colher pessoas para elas se tornarem meus discípulos” MET. ");
INSERT INTO portft_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Eles deixaram imediatamente o trabalho que estavam fazendo com as redes de pescar e foram com Ele. ");
INSERT INTO portft_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Enquanto Jesus, Simão e André caminharam dali, Jesus viu dois outros homens, Tiago e o irmão mais novo dele, João. Estes dois estavam no barco deles com seu pai, Zebedeu, consertando suas redes de pescar. Ele disse a eles que deviam deixar seu trabalho e deviam ir com Ele. ");
INSERT INTO portft_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Imediatamente eles deixaram seu barco de pescar e seu pai e foram com Jesus. ");
INSERT INTO portft_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus foi com eles por todo o distrito da Galileia. Ele ensinava as pessoas nos edifícios onde nós judeus adoramos a Deus e pregava a boa mensagem que diz como chegar a ser membro do grupo de pessoas que Deus governa. Ele estava curando todos os galileus que tinham enfermidades ou que estavam doentes. ");
INSERT INTO portft_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Quando pessoas que moravam em outras partes do distrito da Síria ouviram sobre o que Ele estava fazendo, trouxeram a Ele aqueles que sofriam com muitos tipos de doenças, aqueles que sofriam dores terríveis, pessoas controladas por demônios, epiléticos e paralíticos, e Ele curou todos. ");
INSERT INTO portft_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Muitas pessoas começaram a andar com Ele. Elas eram do distrito da Galileia, da área de Decápolis/das Dez Cidades, da cidade de Jerusalém, de outras partes do distrito da Judeia, das áreas perto do Rio Jordão. ");
INSERT INTO portft_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Quando Jesus viu as multidões, ele subiu em um monte. Sentou-se para ensinar seus discípulos. Eles foram a Ele para ouvi-lo. ");
INSERT INTO portft_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Aí Ele começou a ensiná-los dizendo: ");
INSERT INTO portft_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Deus se agrada com/gosta de pessoas que reconhecem que têm necessidade espiritual; Ele permitirá que sejam as pessoas cujas vidas Ele governa. ");
INSERT INTO portft_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Deus estima/respeita as pessoas que choram porque pecam; Eles serão encorajados {Ele vai encorajá-los}. ");
INSERT INTO portft_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Deus tem prazer nas pessoas que são mansas/humildes; Elas herdarão a terra que Deus recriará. ");
INSERT INTO portft_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Deus tem prazer naqueles que desejam sinceramente viver justamente da mesma forma que desejam comer e beber MET; Eles serão capacitados {Ele vai capacitá-los a fazer tudo quanto Ele deseja} MET. ");
INSERT INTO portft_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Deus estima aqueles que agem com misericórdia; Ele terá misericórdia deles. ");
INSERT INTO portft_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Deus estima aqueles que pensam somente naquilo que agrada a Ele; Algum dia eles estarão onde Deus está e O verão. ");
INSERT INTO portft_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Deus estima aqueles que ajudam os outros a viverem em paz; eles serão considerados {Deus considerará que são} seus filhos MET. ");
INSERT INTO portft_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Deus estima aqueles a quem são feitos coisas más {para quem outras pessoas fazem coisas más} porque agiram de maneira justa; Ele permitirá que estejam onde Ele governa sobre as pessoas. ");
INSERT INTO portft_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Deus estima vocês quando outros os insultam, quando outros fazem coisas ruins a vocês e quando outros dizem falsamente que vocês são maus porque creem em mim. ");
INSERT INTO portft_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Quando isso acontecer, alegrem-se e fiquem felizes DOU, porque Deus dará a vocês um grande galardão no céu. Deus pensará muito bem de vocês assim como Ele pensava bem dos profetas que seus antepassados perseguiram muito há tempo atrás. ");
INSERT INTO portft_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Vocês podem influenciar as pessoas que vivem na terra e melhorar a maneira em que vivem para que eles não se tornem piores, da mesma forma que sal pode melhorar o sabor da comida e preservá-la MET. O sal que não tem mais o seu sabor, não pode ganhar aquele sabor de novo RHQ. Como resultado, esse sal se torna inútil. É rejeitado pelas pessoas, jogado no chão, e pisado {As pessoas o rejeitam, jogam no chão e pisam nele} MET. Da mesma forma, se a maneira de vocês viverem não influencia mais as pessoas a viverem como Deus quer, Deus rejeitará vocês. ");
INSERT INTO portft_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Vocês ajudam as pessoas que vivem no mundo MTY a perceberem a verdade de Deus assim como a luz ajuda as pessoas a saberem o que está ao seu redor. Assim como todos podem ver uma cidade situada em um monte onde há luzes que brilham à noite MET, os outros podem ver o que vocês fazem. ");
INSERT INTO portft_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Depois das pessoas acenderem uma lamparina, nunca a colocam debaixo de um cesto. Por outro lado, colocam no lugar próprio dentro da casa para que brilhe sobre todos que estão ali. ");
INSERT INTO portft_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Semelhantemente, façam o que é certo MET de tal modo que ajudem os outros a ver as boas ações de vocês e, como resultado, eles louvarão o Pai de vocês que está no céu. ");
INSERT INTO portft_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Não vim à terra para anular as leis que Moisés escreveu nem o que os profetas escreveram. Pelo contrário, vim para fazer acontecer aquilo que os autores desses livros disseram que aconteceria. Portanto, não pensem mais que vim à terra para que pudesse anular o que eles escreveram. ");
INSERT INTO portft_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tenham em mente o seguinte: cada detalhe dessas leis, inclusive os detalhes que parecem de menor importância MTY, certamente estarão em efeito HYP, LIT até que desapareçam os céus e a terra e até acontecer tudo que Deus disse a esses autores para escreverem. ");
INSERT INTO portft_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Já que todas as leis de Deus são importantes, se alguém desobedecer qualquer uma delas, mesmo que seja um dos mandamentos menos importantes e se essa pessoa ensinar outros a desobedecerem qualquer uma dessas leis, será dito {Deus dirá} que essa pessoa é a menos importante que vive no lugar onde Deus governa. Se alguém obedecer a esses mandamentos e se ele ensinar outros a obedecerem, será dito {Deus dirá} que essa pessoa é muito importante entre aquelas que Deus governa. ");
INSERT INTO portft_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Lembrem-se disso: vocês acham que os fariseus e os homens que ensinam as leis judaicas às pessoas obedecem fielmente ao que Deus manda, mas eles não obedecem. Portanto, se vocês não obedecerem a essas leis melhor do que eles, vocês não entrarão de jeito nenhum no lugar onde Deus governa. ");
INSERT INTO portft_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Vocês já ouviram seus professores religiosos dizer que foi dito {que Deus/Moisés disse} aos seus antepassados: ‘Não assassine outras pessoas’. A implicação disso foi que se uma pessoa assassinar outra, o juiz condenará essa pessoa e dirá que alguém deve executá-la. ");
INSERT INTO portft_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mas isto é o que eu digo a vocês: se uma pessoa estiver zangada com outra, Deus julgará essa pessoa também. Se uma pessoa disser a outra: ‘Você não vale nada’, o Concílio dos judeus julgará essa pessoa. Se uma pessoa disser a outra: ‘Você é idiota,’ Deus vai jogá-la para o fogo do inferno. ");
INSERT INTO portft_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Portanto, quando você levar sua oferta para Deus ao altar, se você lembrar que ofendeu alguém, ");
INSERT INTO portft_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","deixe sua oferta ao lado do altar, e vá primeiro à pessoa que você ofendeu. Diga a essa pessoa que você se arrepende daquilo que fez e peça que a pessoa perdoe você. Depois volte e dê sua oferta a Deus. ");
INSERT INTO portft_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Também, quando um compatriota o leva ao tribunal para acusá-lo, entre em acordo/faça as pazes com essa pessoa logo, enquanto ainda estão caminhando juntos no caminho. Faça assim enquanto ainda houver tempo para que ele não leve você ao juiz para acusá-lo, porque se o juiz favorecer aquele que acusa você, ele declarará que você é culpado, vai mandá-lo aos guardas da prisão e você será jogado {os guardas da prisão vão jogá-lo} na prisão. ");
INSERT INTO portft_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Guarde na mente o seguinte: Se você entrar na prisão, não sairá dessa prisão porque não poderá pagar tudo quanto o juiz disser que você deve MET. Você também deve entrar em acordo com Deus antes de morrer. ");
INSERT INTO portft_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Já ouviram seus professores dizerem que foi dito: {Deus/Moisés disse:} ‘Não cometa adultério’. ");
INSERT INTO portft_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mas o que eu digo a vocês é, se um homem olhar para uma mulher com desejo de pecar sexualmente com ela, na opinião de Deus esse homem já pecou ao fazer isso porque ele já está pensando em pecar sexualmente MET. ");
INSERT INTO portft_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Se for tentado a pecar por causa do que vê MTY, deixe de olhar para essas coisas! Mesmo que você tenha que arrancar um olho e jogá-lo fora HYP para não pecar, faça isso! É bom que você não peque e como resultado que vá para o céu, embora lhe falte uma parte do corpo, até mesmo seu olho. Mas não é bom você pecar e, como resultado, Deus pôr seu corpo inteiro no inferno. ");
INSERT INTO portft_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Se você for tentado a usar uma de suas mãos para pecar MTY, deixe de usar essa mão. Mesmo que tenha que cortar uma das mãos e jogá-la fora para HYP não pecar, faça isso! É bom que você não peque e que vá para o céu, embora lhe falte uma parte do corpo, mesmo que seja sua mão direita (OU mesmo que não tenha uma ou as duas mãos). Mas não é bom você pecar e como resultado, Deus jogar seu corpo inteiro no inferno. ");
INSERT INTO portft_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Está escrito {Moisés escreveu}: ‘Se um homem se divorciar de sua esposa, ele deve escrever um documento no qual afirma que está se divorciando dela’. ");
INSERT INTO portft_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Porém agora ouçam o que eu digo para vocês: um homem só pode se divorciar de sua esposa se ela tiver cometido adultério, e não por qualquer outra razão. Se um homem se divorciar de sua esposa por qualquer outra razão e se ele tiver relações sexuais com outra mulher, ele faz com que sua esposa se torne alguém contra quem ele cometeu adultério, porque à vista/aos olhos de Deus ela ainda é esposa dele. Também, se um homem se casar com uma mulher divorciada {cujo esposo se divorciou dela}, Deus considera que ele está cometendo adultério. ");
INSERT INTO portft_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Vocês também já ouviram seus professores religiosos dizerem que foi escrito {que Moisés escreveu} para seus antepassados: ‘Não deixe de dar ao Senhor o que você prometeu dar a Ele. Faça o que você prometeu ao Senhor que faria’. ");
INSERT INTO portft_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mas agora ouçam o que eu digo a vocês: Nunca prometa fazer algo e depois peça a um ser superior que afirme que o que você diz acontecerá. Por exemplo, não prometa que você dará algo e depois peça aos seres espirituais no céu MTY que afirmem que isso acontecerá, já que o céu é onde Deus senta no trono dele MTY para governar as pessoas. ");
INSERT INTO portft_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Também, não prometa que dará algo e depois peça aos seres espirituais na terra MTY que afirmem que isso acontecerá, já que a terra é onde as pessoas sobre quem Deus governa moram MET. E mais, não prometa que fará algo e depois peça às autoridades religiosas em Jerusalém que afirmem que isso acontecerá, porque Jerusalém é a cidade onde Deus, o grande rei, governa. ");
INSERT INTO portft_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Também, não prometa fazer algo e depois prometa dar sua cabeça para assegurar que isso acontecerá, já que não é você, mas Deus quem determina o que acontecerá. Por exemplo, você nem pode mudar a cor do seu cabelo fazendo um pedaço de cabelo preto se tornar branco ou um pedaço de cabelo branco se tornar preto. ");
INSERT INTO portft_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Se falar em fazer alguma coisa, diga apenas ‘Sim, eu farei,’ ou ‘Não, eu não farei’. Se disser algo além disso, é de Satanás, o Maligno. ");
INSERT INTO portft_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Vocês já ouviram que seus professores religiosos dizem que está escrito {Moisés escreveu}: ‘Vingue-se deste modo: Se alguém fizer mal a um dos seus olhos, alguém deve fazer mal a apenas um dos olhos dele. Se alguém fizer mal a um dente seu, alguém deve fazer mal a apenas um dos dentes dele’. ");
INSERT INTO portft_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mas agora ouçam o que eu digo a vocês: não se vinguem pelas coisas más que outras pessoas fazem a vocês. Pelo contrário, se alguém insultá-lo batendo-lhe em uma das faces, vire o outro lado para ele para que possa bater também. ");
INSERT INTO portft_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Se alguém quiser processá-lo e tomar a sua túnica/camisa, dê a ele também a sua capa/casaco. ");
INSERT INTO portft_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Se um oficial militar forçá-lo a ir com ele uma milha e carregar seu equipamento, caminhe com ele duas milhas e carregue o equipamento dele. ");
INSERT INTO portft_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Também, se alguém pedir algo de você, dê a ele o que pede. Se alguém pedir que você empreste algo a ele, não deixe de emprestar. ");
INSERT INTO portft_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Vocês já ouviram seus professores religiosos dizerem que está escrito {que Moisés escreveu}: ‘Amem aqueles de seu próprio país e odeiem seus inimigos’. ");
INSERT INTO portft_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Agora, porém, ouçam o que eu digo a vocês: Amem seus inimigos bem como seus amigos e orem por aqueles que fazem com que vocês sofram, ");
INSERT INTO portft_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","para que ajam como Deus, o pai de vocês que está no céu, deseja que vocês ajam MET. Façam assim porque Deus, o seu pai, mostra graça para todas as pessoas. Por exemplo, Ele faz com que o sol brilhe igualmente sobre as pessoas ruins e as pessoas boas e faz com que a chuva caia igualmente nas pessoas justas e nas pessoas injustas. ");
INSERT INTO portft_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Amem seus inimigos. Pois se amarem somente aqueles que amam vocês, não esperem que Deus recompense/será que Deus recompensará RHQ vocês no céu./? A razão disso é que todos, até mesmo os cobradores de impostos, que vocês consideram ser grandes pecadores, amam aqueles que amam a eles. Se vocês agirem como eles, vocês não são nada/de que forma vocês são RHQ diferentes dos cobradores de impostos!/? ");
INSERT INTO portft_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mostrem amor aos não judeus/estrangeiros desejando a bênção de Deus sobre as pessoas que vocês saúdam. Pois se vocês desejarem que Deus abençoe somente seus amigos, vocês não são/será que são RHQ melhores do que outras pessoas./? Até mesmo os não judeus, que vocês acham que pecam muito (OU, que vocês consideram-nos inaceitáveis a Deus), querem que Deus abençoe os amigos deles RHQ, mas Deus não os recompensa. ");
INSERT INTO portft_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Fazendo estas e também outras coisas, tornem-se perfeitos como Deus, seu Pai que está no céu, é perfeito. ");
INSERT INTO portft_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Quando vocês fizerem suas boas ações, tenham o cuidado de não fazer quando outras pessoas estiverem olhando, somente para que elas lhes vejam e pensem bem de vocês. Se fizerem boas ações somente para que outras pessoas pensem bem de vocês, Deus, seu Pai quem está no céu, não lhes dará nenhuma recompensa. ");
INSERT INTO portft_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Portanto, sempre que derem algo aos pobres, não anunciem isso assim como as pessoas anunciam algo que querem que outros saibam, tocando uma trombeta MET. É isso que os hipócritas fazem nas sinagogas e nas estradas principais para que as pessoas os observem e eles sejam elogiados pelas pessoas {para que as pessoas os elogiem}. Tenham isso em mente: as pessoas elogiem esses hipócritas, mas essa é a única recompensa que eles receberão. ");
INSERT INTO portft_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Em vez de fazer como eles fazem, quando vocês derem algo aos pobres, não deixem que outros saibam que vocês estão fazendo isso MET. ");
INSERT INTO portft_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dessa forma, vocês estarão dando aos pobres em segredo. Como resultado Deus, seu Pai que observa vocês quando ninguém mais os observa, recompensará vocês. ");
INSERT INTO portft_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Também quando vocês orarem, não façam o que fazem os hipócritas. Eles gostam de ficar em pé nos lugares de reuniões dos judeus e nas esquinas das ruas principais para orarem, para que outras pessoas os observem e pensem bem deles. Tenham isso em mente: as pessoas os louvam, mas esta é a única recompensa que eles receberão. ");
INSERT INTO portft_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mas quanto a vocês, quando orarem, entrem no seu quarto particular e fechem a porta para orar a Deus, o pai de vocês, a quem ninguém vê. Ele observa vocês onde ninguém mais os observa e Ele lhes recompensará. ");
INSERT INTO portft_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Quando orarem, não repitam palavras muitas vezes como fazem as pessoas que não conhecem Deus quando elas oram. Essas pessoas repetem palavras sem sentido porque acham que se usarem muitas palavras elas serão ouvidas e será lhes dado {os deuses delas vão ouvi-las e dar-lhes} o que pedem. ");
INSERT INTO portft_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Não repitam palavras como elas fazem, porque Deus, o pai de vocês, sabe o que precisam antes de vocês pedirem a Ele. ");
INSERT INTO portft_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Portanto, orem sobre estas coisas assim: Pai, o Senhor que está no céu, nós (excl) queremos que seja honrado/reverenciado {que as pessoas honrem/reverenciem o senhor}. ");
INSERT INTO portft_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Queremos (excl) que as pessoas permitam que o senhor governe sobre as suas vidas. Queremos (excl) que as pessoas que vivem na terra façam o que o senhor deseja, assim como os que vivem no céu fazem o que o senhor deseja que façam. ");
INSERT INTO portft_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dê para nós (excl) cada dia a comida SYN de que precisamos (excl) para comer nesse dia. ");
INSERT INTO portft_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Perdoe os nossos (excl) pecados assim como nós (excl) perdoamos as pessoas que pecam contra nós (excl). ");
INSERT INTO portft_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Não nos deixe fazer coisas erradas quando alguém ou algo nos tenta, e livra-nos (excl) quando Satanás o maligno procura fazer com que façamos coisas más. ");
INSERT INTO portft_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Perdoem aqueles que pecam contra vocês, porque, se perdoarem os outros, Deus, o Pai de vocês que está no céu, perdoará os pecados de vocês. ");
INSERT INTO portft_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mas se vocês não perdoarem os outros, Ele também não perdoará os pecados de vocês. ");
INSERT INTO portft_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Quando vocês ––jejuarem/deixarem de comer para agradarem a Deus––, não deem a aparência de estarem tristes como fazem os hipócritas. Eles andam com cara triste para que as pessoas vejam que estão jejuando e pensem bem deles. Tenham em mente o seguinte: as pessoas pensarão bem deles por isso, mas esta é a única recompensa que eles receberão. ");
INSERT INTO portft_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mas cada um de vocês, quando jejuar/deixar de comer, penteie o cabelo e lave o rosto como sempre ");
INSERT INTO portft_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","para que, com sua aparência normal, outras pessoas não percebam que está jejuando. Pelo contrário, Deus, seu Pai, que ninguém pode ver, notará que vocês estão jejuando. Como resultado, seu Pai que vê vocês, embora ninguém mais veja vocês, recompensará vocês. ");
INSERT INTO portft_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Não sejam egoístas acumulando grandes quantidades de dinheiro e bens materiais para si mesmos aqui na terra, porque a terra é o lugar onde tudo acaba/perece. Por exemplo, na terra as traças/o cupim estragam as coisas, as coisas ficam enferrujadas e os ladrões entram nos edifícios para roubarem as coisas. ");
INSERT INTO portft_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pelo contrário, façam coisas que agradarão a Deus, o que é semelhante a guardar tesouros no céu MET. É no céu onde nada acaba/perece. Lá, nenhuma/nenhum traça/cupim estraga as coisas, nada fica enferrujado e os ladrões não entram nos edifícios para roubarem. ");
INSERT INTO portft_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Lembrem-se de que as coisas que cada um de vocês consideram ser de mais valor são as coisas em que sempre estarão pensando/preocupados MET. ");
INSERT INTO portft_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Dentro de cada um de vocês, seus olhos são como uma lâmpada MET que faz com que vejam as coisas. Portanto, se seus olhos são sadios, é como uma sala com uma lamparina que faz com que vejam tudo muito bem MET. De modo semelhante, se forem generosos, vocês poderão saber muito do que Deus quer que saibam MET. ");
INSERT INTO portft_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Porém, se seus olhos são maus, vocês não veem bem as coisas. Portanto, serácomo se vocês estivessem na escuridão total MET. De modo semelhante, se continuarem no egoísmo/na cobiça, estarão na escuridão espiritual. Se tudo quanto seus olhos puderem ver e suas mentes puderem pensar tem a ver/está relacionado com seu desejo excessivo de bens materiais, tudo que fizerem será mau MET. ");
INSERT INTO portft_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ninguém pode servir dois donos de forma igual. Se tentasse fazer isso, ele odiaria um deles e amaria o outro, ou iria devotar-se a um deles e desprezaria o outro DOU. Da mesma forma, vocês não podem dedicar a vida ao louvor a Deus e ao louvor ao dinheiro e aos bens materiais ao mesmo tempo. ");
INSERT INTO portft_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Por isso, digo-lhes que não devem se preocupar pelas coisas que precisam para viver. Não se preocupem se têm ou não têm comida suficiente, líquido suficiente para beber ou roupa para usar para poder viver. É importante que tenham comida, bebida e roupa suficientes, mas a sua maneira de viver é ainda mais importante. ");
INSERT INTO portft_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Olhem os pássaros. Mesmo que não plantem sementes, nem colham as plantações e nem as guardem em depósitos para ter o que comer no futuro, há comida para eles, porque Deus, o Pai de vocês que está no céu, provê comida para eles. Mas ––vocês são/será que vocês não são –– RHQ sem dúvida, muito valiosos, enquanto que os passarinhos valem pouco./? Portanto, Deus certamente proverá o que vocês precisam! ");
INSERT INTO portft_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nenhum de vocês pode/Será que qualquer um de vocês pode–– RHQ com a preocupação acrescentar tempo à sua vida./? Vocês não podem acrescentar nem um minuto às suas vidas! Por isso não devem preocupar-se com essas coisas! ");
INSERT INTO portft_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Vocês também não devem preocupar-se com ter ou não ter roupa suficiente RHQ. Considerem como as flores crescem nos campos. Elas ficam bonitas mesmo que não trabalhem e nem fiem para fazer roupas para si mesmas. ");
INSERT INTO portft_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Vejam que embora o Rei Salomão, que viveu há muito tempo atrás, usasse roupas muito bonitas, as roupas dele não eram tão bonitas quanto uma destas flores. ");
INSERT INTO portft_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Deus faz as ervas do mato muito bonitas. Mas elas crescem no campo por pouco tempo. Um dia crescem e no dia seguinte são jogadas no forno {alguém as corta e joga em um forno} para queimá-las para fazer pão. Mas vocês são mais importantes para Deus do que as ervas do mato. Por isso ––Deus/será que Deus não –– RHQ certamente dará roupa suficiente a vocês, que vivem por muito tempo, mas que confiam tão pouco nele!/? ");
INSERT INTO portft_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Por causa disso, não se preocupem dizendo: ‘Será que teremos alguma coisa para comermos?’ Ou ‘Será que teremos algo para bebermos?’ Ou ‘Será que teremos roupa para usarmos RHQ se não nos empenharmos em achar estas coisas?’ ");
INSERT INTO portft_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Aqueles que não conhecem Deus sempre se preocupam com estas coisas. Mas Deus, o Pai de vocês que está no céu, sabe que vocês precisam de todas essas coisas, então vocês não devem se preocupar com elas. ");
INSERT INTO portft_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pelo contrário, preocupem-se primeiro com deixar que Ele dirija completamente sua vida, e procurem agir de maneira justa. Como resultado, todas as coisas que precisam serão dadas a vocês {Deus lhes dará todas as coisas que precisam}. ");
INSERT INTO portft_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Portanto, não se preocupem no dia presente com o que acontecerá com vocês no dia seguinte, pois durante esse dia seguinte vocês se preocuparão com as coisas que acontecem nele. Vocês terão o bastante com que se preocupar no decorrer de cada dia; por isso não se preocupem antecipadamente. ");
INSERT INTO portft_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Não digam o quanto os outros pecam para que não seja dito {Deus não diga} o quanto vocês pecam ");
INSERT INTO portft_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Se vocês julgarem os outros, vocês serão julgados {Deus julgará vocês}. Com a mesma medida que vocês julgarem os outros, vocês serão julgados {Deus julgará vocês}. ");
INSERT INTO portft_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nenhum de vocês deve/Por que qualquer um de vocês deve –– RHQ preocupar-se com as falhas pequenas de outra pessoa MET./? Isso é igual a observar uma manchinha no olho dele. Mas você deve se preocupar com as suas próprias falhas grandes. Elas são como MET traves no seu próprio olho, que você mesmo nem observa/percebe. ");
INSERT INTO portft_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nenhum de vocês deve dizer/Por que vocês comentam com –– RHQ a outra pessoa sobre suas falhas pequenas./? Não diga: ‘Deixe-me tirar o cisco dos seus olhos!’ se você ainda tem uma trave grande no seu próprio olho MET. ");
INSERT INTO portft_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hipócrita, deixe você mesmo de cometer pecados! Isso será como retirar a trave do seu próprio olho MET. Depois, como resultado, você poderá perceber/entender bem as coisas espiritualmente para então ajudar a outra pessoa a livrar-se das falhas dela MET que são como ciscos no olho dela. ");
INSERT INTO portft_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Vocês não dão coisas santas a cachorros que nem prestam atenção nelas e que lhes atacarão. Vocês não jogam pérolas na frente dos porcos, porque eles iriam apenas ignorá-las e pisar nelas. Da mesma forma, não deem a valiosa verdade espiritual para pessoas quando vocês sabem que elas não valorizarão e que apenas farão coisas ruins a vocês. ");
INSERT INTO portft_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Continuem pedindo a Deus pelas coisas que precisam. Se fizerem assim, será dado {Deus dará} a vocês. Esperem com confiança que Deus dará a vocês as coisas que precisam, e Ele dará a vocês. Isso será como MET procurar e achar as coisas que precisam. Continuem a orar com diligência. Então Deus lhes responderá. Será como MET alguém que bate na porta para entrar em uma sala e o caminho será aberto {Deus abrirá o caminho} para vocês conseguirem aquilo pelo qual orarem. ");
INSERT INTO portft_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Lembrem-se que Deus dará as coisas a todos que continuarem a pedir a Ele. Deus dará coisas a qualquer pessoa que continue a pedir confiantemente a Ele por aquilo que falta. O caminho será aberto {Deus abrirá o caminho} para as pessoas receberem as coisas que elas continuam a pedir urgentemente. ");
INSERT INTO portft_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nenhum homem/Será que uma pessoa –– RHQ daria uma pedra ao filho dele se o filho pedisse pão./? ");
INSERT INTO portft_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Da mesma forma –– nenhum homem daria/será que alguém daria –– RHQ uma cobra venenosa ao filho dele se o filho pedisse peixe. ");
INSERT INTO portft_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Vocês, que são maus, sabem dar coisas boas aos seus filhos. Portanto, Deus, o Pai de vocês que está no céu e que é bom, certamente dará coisas boas às pessoas que pedirem a Ele. ");
INSERT INTO portft_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Portanto, o modo que vocês querem que os outros ajam com vocês é o mesmo que vocês também devem agir com eles, pois isso resume o que Moisés escreveu nas leis que Deus deu a ele e também o que os profetas escreveram há muito tempo atrás. ");
INSERT INTO portft_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","É difícil o caminho que as pessoas podem tomar que leva aonde se pode viver eternamente com Deus no céu. Ir por aquele caminho é como ir por uma estrada estreita PRS, MET que leva a uma porta estreita. Não são muitos que encontram esse caminho. O caminho que a maioria das pessoas toma é fácil, mas o resultado é que Deus as castiga no inferno. Esse caminho é como uma estrada larga onde as pessoas andam PRS, MET até chegarem a uma porta larga, mas essa estrada e essa porta levam aonde Deus vai destruí-las. Muitas pessoas entram por aquela porta. Portanto, deixem a estrada larga e entrem pela porta estreita no céu. ");
INSERT INTO portft_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tenham cuidado com as pessoas que chegam a vocês dizendo que estão lhes falando o que Deus já falou, mas estão mentindo. Elas parecem inofensivas, mas na verdade são muito ofensivas. São como lobos que se cobrem com peles de ovelha para fazer com que os outros creiam que são ovelhas MET, mas na verdade são lobos que atacam os outros MET. ");
INSERT INTO portft_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ao verem o que as plantas produzem, vocês saberão que tipo de plantas são MET. Por exemplo, já que os espinheiros não podem produzir uvas, –– ninguém pode/será que alguém pode –– RHQ colher uvas dos espinheiros./? E já que os espinheiros não podem produzir figos, –– ninguém pode/será que alguém –– RHQ tirar figos dos espinheiros./? ");
INSERT INTO portft_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","E há mais outro exemplo: toda boa árvore que produz fruta produz frutas boas, mas toda árvore podre produz fruta inútil. ");
INSERT INTO portft_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Semelhantemente, nenhuma árvore boa pode produzir fruta inútil e nenhuma árvore ruim pode produzir fruta boa. ");
INSERT INTO portft_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Como resultado, toda árvore que não produz fruta boa é derrubada e queimada no fogo {as pessoas derrubam essas árvores e queimam-na no fogo} para se livrarem delas. Da mesma maneira, Deus colocará aqueles que são falsos profetas no inferno onde há fogo. ");
INSERT INTO portft_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Portanto, ao ver o que as plantas produzem, vocês saberão que tipo de plantas são. De modo semelhante, quando vocês virem o que essas pessoas fazem, vocês saberão que são falsos profetas. ");
INSERT INTO portft_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mesmo que muitas pessoas costumem me chamar ‘Senhor’, fingindo que eu governo sobre elas, algumas dessas pessoas não irão para o céu onde Deus governa, porque não fazem o que Ele deseja. Somente as pessoas que fazem o que meu Pai que está no céu deseja vão para lá. ");
INSERT INTO portft_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Naquele dia quando Deus julgar todas as pessoas, muitas pessoas, tentarão me dizer por que merecem ir para o céu, elas me dirão: ‘Senhor, nós, como representantes do Senhor, falamos a mensagem de Deus RHQ! Como representantes do Senhor nós (excl) expulsamos demônios das pessoas RHQ! E como representantes do Senhor muitas vezes Deus nos (excl) ajudou a fazermos –– milagres/o que somente Ele pode fazer –– RHQ!’ ");
INSERT INTO portft_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Então eu lhes direi: ‘Eu nunca disse que vocês são meus amigos. Saiam de minha presença, vocês que fazem o que é mal!’ ");
INSERT INTO portft_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Portanto, qualquer pessoa que ouvir o que eu digo e fizer o que mando, será como homem sábio que constrói a casa dele na rocha. ");
INSERT INTO portft_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Então, mesmo que as chuvas caiam, o rio suba e o vento sopre e bata contra a casa, ela não cairá, porque foi construída {ele a construiu} em um alicerce firme de rocha. ");
INSERT INTO portft_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Por outro lado, aquele que ouvir o que digo e não me obedecer será como um homem tolo que constrói a casa dele na areia. ");
INSERT INTO portft_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Aí quando a chuva cair, o rio subir, o vento soprar e bater na casa, ela cairá e será completamente destruída, porque o homem a construiu na areia. Portanto, obedeçam ao que eu ensino a vocês”. ");
INSERT INTO portft_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Quando Jesus terminou de dizer essas coisas, a multidão de pessoas que ouviram-no ficou admirada com o novo ensinamento que Ele lhe deu, ");
INSERT INTO portft_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","porque Jesus estava ensinando as pessoas como alguém que tem sua própria autoridade. Ele não ensinava as pessoas assim como os homens que ensinavam as leis judaicas, que apenas repetiam o que outros já tinham ensinado. ");
INSERT INTO portft_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Quando Jesus desceu daquele monte, grandes multidões o seguiram. ");
INSERT INTO portft_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Depois que Ele deixou as multidões, um homem leproso/que tinha a doença de pele chamada lepra de repente chegou e ajoelhou-se diante dele. Ele disse a Jesus: “Senhor, por favor, cure-me, pois sei que o senhor pode me curar se quiser”. ");
INSERT INTO portft_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Então Jesus, desrespeitando a lei religiosa que proibia que as pessoas se aproximassem daqueles que tivessem essa doença, estendeu a mão e tocou nele para curá-lo. Jesus disse a ele: “Já que estou disposto a curá-lo, seja curado {eu curo você} agora!” Logo ele foi curado da lepra {ele não era mais um leproso}. ");
INSERT INTO portft_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Depois, Jesus disse-lhe: “Agora, tenha o cuidado de não falar com ninguém sobre como eu o curei, a não ser com o sacerdote. Mas vá ao templo em Jerusalém e mostre-se ao sacerdote para que ele examine você e verifique que você não é mais leproso. Dê a ele a oferta que Moisés mandou que as pessoas curadas de lepra oferecessem como sacrifício a Deus. Depois dele falar com o povo local, eles saberão que você está curado e você poderá associar-se com/andar em companhia de outras pessoas novamente.” ");
INSERT INTO portft_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Quando Jesus foi à cidade de Cafarnaum, um oficial romano que comandava cem soldados chegou a ele e pediu a Jesus que o ajudasse. ");
INSERT INTO portft_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ele disse a Jesus: “Senhor, meu servo está em casa deitado na cama. Ele está paralisado e está com muita dor”. ");
INSERT INTO portft_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus disse a ele,: “Vou à sua casa e vou curá-lo”. ");
INSERT INTO portft_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","O oficial disse a Ele: “Senhor, não se preocupe em ir. Pois não sou judeu e não mereço que o senhor, um judeu, entre na minha casa e associe-se comigo. Em vez disso, daqui mesmo diga que o senhor vai curá-lo. Como resultado, meu servo será curado {ficará bom}. ");
INSERT INTO portft_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Creio que isso acontecerá, porque quanto a mim, também sou um homem que outros governam e também eu tenho soldados debaixo da minha autoridade. Quando digo a um deles: ‘Vá’, ele vai. Quando digo a outro: ‘Venha’, ele vem. Quando digo a meu servo: ‘Faça isso’, ele faz. Eu creio que o senhor fala com autoridade semelhante”. ");
INSERT INTO portft_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Quando Jesus ouviu isso, ficou admirado. Ele disse à multidão que estava seguindo-o: “Ouçam isto: Eu nunca vi antes nenhum judeu, vivendo em Israel, e que deveria crer firmemente em mim, que cresse MTY tão firmemente em mim quanto crê este não judeu. ");
INSERT INTO portft_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Digo verdadeiramente a vocês que muitos outros não judeus que crerão em mim assim como este oficial romano crê virão de países distantes, inclusive aqueles bem para o oriente e bem para o ocidente, SYN e comerão alegremente com MTY Abraão, Isaque e Jacó no céu onde Deus governa. ");
INSERT INTO portft_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mas os judeus IDM que deviam ter permitido que Deus governasse sobre eles serão colocados {Deus vai colocá-los} no inferno, onde há escuridão total. Como resultado, eles chorarão porque estarão sofrendo e rangerão os dentes porque terão muita dor MTY”. ");
INSERT INTO portft_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Então Jesus disse ao oficial: “Vá para casa. O que você creu que aconteceria, ou seja, que eu curaria seu servo de longe, acontecerá”. Então o oficial foi para casa e descobriu que seu servo foi curado {ficou curado} na hora exata quando Jesus estava dizendo que ele seria curado. ");
INSERT INTO portft_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Quando Jesus e alguns dos discípulos dele foram à casa de Pedro, Jesus viu a sogra de Pedro. Ela estava deitada em uma cama porque tinha febre. ");
INSERT INTO portft_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ele tocou na mão dela e, como resultado, ela logo não teve mais febre PRS. Então ela se levantou e serviu comida para eles. ");
INSERT INTO portft_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aquela noite quando as restrições a respeito de viajar no Sábado/dia de descanso dos judeus não estavam em efeito, os que viviam naquela região trouxeram a Jesus muitas pessoas que os demônios controlavam e pessoas que estavam doentes. Só falando com os demônios Ele fez com que saíssem e Ele curou todas as pessoas que estavam doentes. ");
INSERT INTO portft_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ao fazer isso, Ele cumpriu as palavras que foram proferidas pelo profeta Isaías {que o profeta Isaías disse} sobre o Messias: “Ele curou as pessoas que tinham doenças e as curou das enfermidades delas DOU.” ");
INSERT INTO portft_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Quando Jesus viu a multidão ao seu redor, Ele mandou que seus discípulos O levassem de barco ao outro lado do lago., porque precisava descansar. ");
INSERT INTO portft_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Enquanto caminhavam para o barco, um homem que ensinava as leis judaicas às pessoas chegou a Ele e disse: “Professor, eu irei com o senhor onde quer que o senhor vá”. ");
INSERT INTO portft_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Para que o homem soubesse o que esperar se fosse com Ele, Jesus disse a ele: “as raposas têm covas onde moram e os pássaros têm ninhos, mas mesmo que eu seja aquele que vim do céu, não tenho casa onde eu possa dormir MTY”. ");
INSERT INTO portft_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Outro homem que era um dos discípulos de Jesus disse a Ele: “Senhor, permita-me primeiro ir para casa. Depois que meu pai morrer vou enterrá-lo e então vou com o senhor”. ");
INSERT INTO portft_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aí Jesus disse a ele: “Venha comigo agora. Aqueles que não têm a vida eterna estão mortos MET aos olhos de Deus. Deixe essas pessoas fazerem o trabalho de enterrar as pessoas que morrem”. ");
INSERT INTO portft_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Então Jesus entrou no barco e os discípulos também entraram. Eles velejaram no lago da Galileia. ");
INSERT INTO portft_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","De repente um vento forte começou a soprar no lago, e ondas altas estavam batendo no barco e enchendo-o. Mas Jesus estava deitado no barco dormindo. ");
INSERT INTO portft_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Os discípulos dele foram até Ele e O acordaram. Então eles disseram-lhe: “Senhor, livre-nos (inc) porque nós (inc) estamos para nos afogarmos!” ");
INSERT INTO portft_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ele disse a eles: “Vocês não devem estar/Por que estão  RHQ aterrorizados!/? Estou desapontado porque vocês não creem totalmente que eu possa resgatá-los, apesar de tudo quanto vocês me veem fazer!” Então Ele se levantou e disse ao vento para deixar de soprar e as ondas para se acalmarem. O vento deixou de soprar e o lago ficou calmo. ");
INSERT INTO portft_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Como resultado, maravilharam-se, dizendo uns aos outros: “Este homem certamente é uma pessoa extraordinária RHQ! Ele domina tudo! Até os ventos e as ondas o obedecem PRS!” ");
INSERT INTO portft_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Quando chegaram ao lado leste do Lago da Galileia, chegaram à região onde moravam os gadarenos. Jesus saiu do barco e começou a andar na estrada. Então dois homens que os demônios dominavam saíram dos túmulos onde moravam e se encontraram com Ele. Já que eram muito violentos e atacavam as pessoas, ninguém podia viajar na estrada perto de onde moravam. ");
INSERT INTO portft_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Inesperadamente, eles gritaram para Jesus: “O senhor é o Filho de Deus! Já que não tem nada em comum conosco IDM, RHQ, deixe-nos em paz! O senhor chegou para nos torturar antes do tempo que Deus já marcou para nos castigar?” ");
INSERT INTO portft_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tinha uma manada grande de porcos pastando/comendo não muito longe dali. ");
INSERT INTO portft_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Então os demônios pediram a Ele dizendo: “Já que o senhor nos expulsará, mande-nos para os porcos!” ");
INSERT INTO portft_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesus disse a eles: “Se é isso que querem, vão para essa manada de porcos!” Aí os demônios deixaram os homens e entraram nos porcos. De repente, todos os porcos precipitaram-se/atiraram-se morro abaixo para a água e se afogaram. ");
INSERT INTO portft_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aqueles que guardavam os porcos ficaram com medo e correram para a cidade. Ali eles relataram tudo que tinha acontecido; inclusive o que tinha acontecido com os dois homens que os demônios dominavam. ");
INSERT INTO portft_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Então parecia que todas as pessoas HYP que moravam naquela cidade MTY saíram para ver Jesus. Quando viram Jesus e o homem que os demônios antes controlavam, pediram com insistência que Jesus saísse da região deles porque pensavam que Ele destruiria mais de sua propriedade (OU, porque perceberam que Ele devia ser muito poderoso). ");
INSERT INTO portft_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesus e seus discípulos entraram no barco. Eles navegaram pelo lago e Ele entrou em Cafarnaum, a cidade onde estava morando. ");
INSERT INTO portft_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Alguns homens trouxeram para Ele um homem que estava paralisado e que estava deitado em uma esteira. Quando Jesus percebeu que eles creram que Ele podia curar esse homem, Ele disse ao homem paralítico: “Jovem, fique animado, seus pecados são perdoados por mim {porque Eu perdoo os seus pecados}”. ");
INSERT INTO portft_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Alguns dos homens que ensinavam as leis judaicas disseram entre si: “Ao dizer que pode perdoar pecados este homem afirma que é igual a Deus!” ");
INSERT INTO portft_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus sabia o que estavam pensando. Por isso Ele disse: “Vocês não devem/por que é que vocês— RHQ pensar/pensam coisas ruins, acusando-me porque digo que sou Deus./? ");
INSERT INTO portft_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Qualquer um pode RHQ dizer: ‘seus pecados são perdoados {eu perdoo os seus pecados}’, porque ninguém pode provar se isso aconteceu. Mas —ninguém/será que qualquer um— RHQ diria a ele: ‘Estou curando você, levante-se e ande’, se ele não tiver o poder para curar, porque as pessoas podem ver facilmente se acontece ou não. ");
INSERT INTO portft_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mesmo assim, eu farei algo para que vocês saibam que Deus autorizou-me, como aquele que veio do céu, para perdoar os pecados das pessoas enquanto estou na terra, bem como a curar as pessoas. Então Ele disse ao homem paralisado: “Levante-se, pegue a sua esteira e vá para casa”. ");
INSERT INTO portft_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Logo ele se levantou, pegou a sua esteira e foi para casa! ");
INSERT INTO portft_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Quando as multidões viram isso, ficaram muito admiradas. Elas louvaram a Deus que deu autoridade aos seres humanos para fazer coisas tais como curar os outros. ");
INSERT INTO portft_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Enquanto Jesus estava saindo dali, viu-me, um homem chamado Mateus. Eu estava sentado a uma mesa, onde recolhia os impostos para o governo romano. Então ele me disse: “Venha comigo e seja meu discípulo!” Aí eu me levantei e fui com Ele. ");
INSERT INTO portft_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Depois, convidei Jesus e os outros discípulos para irem a minha casa para comerem, e eles foram. Enquanto estavam sentados comendo em minha casa, inesperadamente, muitos cobradores de impostos e outras pessoas que os fariseus consideravam pecadores também chegaram ali e ficaram sentados, comendo conosco. ");
INSERT INTO portft_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mais tarde, depois dos fariseus verem isso, chegaram a nós, os discípulos, e nos disseram: “É nocivo/por que é que— RHQ uma pessoa justa, inclusive o mestre de vocês, coma e se associe com os cobradores de impostos e outros pecadores!/?” ");
INSERT INTO portft_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesus ouviu isso e, por isso, contou esta parábola aos fariseus: “As pessoas sadias não precisam de médico. Pelo contrário, são as pessoas que estão doentes que precisam de médico MET”. Ele disse isso para indicar que as pessoas que sabiam que eram pecadores eram as que estavam indo a Ele para que Ele pudesse ajudá-las espiritualmente. ");
INSERT INTO portft_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","“Vocês precisam aprender o que significam estas palavras que Deus falou: ‘Desejo que vocês ajam com misericórdia; não quero que só ofereçam sacrifícios ‘. Lembrem que não vim do céu para dizer àqueles que pensam IRO que são justos que eles devem desistir de suas vidas de pecado e virem a mim. Pelo contrário, vim para dizer a pecadores que eles devem fazer isso”. ");
INSERT INTO portft_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mais tarde os discípulos de João, o Batizador, chegaram a Jesus e perguntaram a Ele: “Nós (excl) e os fariseus frequentemente deixamos de comer para mostrarmos que queremos agradar a Deus, mas os discípulos do senhor não deixam de comer. O que o senhor diz a esse respeito?” ");
INSERT INTO portft_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus queria mostrar a eles e aos fariseus que não era apropriado os discípulos dele deixarem de comer e ficarem tristes enquanto Ele estivesse com eles. Por isso Ele deu a eles esta ilustração: “Quando o noivo está com os amigos dele durante seu casamento, — os amigos do noivo certamente não/será que os amigos do noivo— RHQ chorarão./? Não chorarão porque nessa hora eles não estão tristes. Quando o noivo for tirado {—alguém tirar/os inimigos dele tirarem — o noivo} deles, eles deixarão de comer porque estarão tristes”. ");
INSERT INTO portft_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesus queria mostrar a eles que qualquer um que quisesse viver obedecendo à nova mensagem dele não devia tentar obedecer a esses rituais tais como deixar de comer MET. Por isso Ele disse a eles: “Ninguém usa um retalho de pano que ainda não foi encolhido para consertar um buraco em uma roupa velha. Se fizer assim, quando lavar, o retalho encolherá e rasgará a roupa velha, como resultado, o buraco ficará ainda maior. ");
INSERT INTO portft_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","E ninguém põe vinho que acaba de ser feito em odres de couro velhos para guardá-lo. Se fizer assim, esses odres velhos rasgarão porque não podem esticar-se quando o vinho fermentar e se expandir. Os odres ficariam estragados e o vinho seria derramado {iria derramar-se} no chão. Pelo contrário, as pessoas põem vinho novo em odres novos e os odres vão esticar-se quando o vinho fermentar. Como resultado, tanto o vinho quanto os odres se conservam {as pessoas podem guardar tanto o vinho quanto os odres}”. ");
INSERT INTO portft_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Enquanto Ele falava com eles, um chefe dos cultos de adoração a Deus dos judeus aproximou-se dele e ajoelhou-se diante dele para mostrar respeito. Então ele disse: “Minha filha acaba de morrer! Mas se o senhor for e colocar as mãos nela, ela viverá de novo!” ");
INSERT INTO portft_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Então Jesus levantou-se e Ele e nós, discípulos, fomos com esse chefe religioso. ");
INSERT INTO portft_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Então, uma mulher que tinha uma hemorragia vaginal EUP fazia doze anos, aproximou-se dele. Ela dizia para si mesma: “Quero que Ele me cure sem ninguém descobrir que eu tenho esta doença. Se eu tocar nele ou se eu apenas tocar na roupa dele, eu serei curada”. Então ela chegou por trás dele e tocou na barra de sua roupa. ");
INSERT INTO portft_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Em seguida, Jesus voltou-se para ver quem tinha tocado nele. Quando Ele viu a mulher, disse a ela: “Querida, anime-se. Porque você creu PRS que eu podia curá-la e eu a curei”. A mulher ficou curada naquele mesmo momento. ");
INSERT INTO portft_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Depois Jesus e alguns de nós, discípulos, chegamos à casa do chefe religioso. Ali Jesus ouviu os tocadores de flautas tocando música fúnebre e a multidão que tinha se reunido chorava em voz alta porque a menina tinha morrido. ");
INSERT INTO portft_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Sabendo que Ele faria com que ela vivesse de novo, Ele disse a multidão: “Saiam daqui e deixem da música fúnebre e do choro, porque a menina não está morta! Pelo contrário, ela está apenas dormindo MET”. Já que as pessoas que tinham se reunido ali sabiam que ela tinha morrido, criticaram Jesus por dizer que ela estava apenas dormindo. ");
INSERT INTO portft_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mas a essas pessoas fora dito por Jesus para saírem da casa. Então Ele entrou no lugar onde a menina estava deitada. Apertou a mão da menina e ela tornou a viver de novo e se levantou. ");
INSERT INTO portft_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Depois disso, as pessoas por toda aquela região ouviram disso. ");
INSERT INTO portft_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Enquanto Jesus estava saindo dali, dois homens cegos O seguiram e gritaram, Senhor que é o Messias, o Descendente do Rei Davi, tenha misericórdia de nós e nos cure!” ");
INSERT INTO portft_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus entrou na casa dele e depois eles entraram também. Jesus disse a eles: “Vocês creem que eu possa curá-los?” Os dois disseram a Ele: “Cremos sim, Senhor!” ");
INSERT INTO portft_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Então Ele tocou nos olhos deles e disse-lhes: “Porque vocês creem que eu posso curá-los, estou curando vocês neste momento!” ");
INSERT INTO portft_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Logo eles podiam ver IDM! Então Jesus disse firmemente a eles: “Tenham o cuidado de não dizerem a ninguém o que fiz para vocês!” ");
INSERT INTO portft_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mas eles saíram e contaram por toda aquela região o que Ele tinha feito para eles. ");
INSERT INTO portft_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Quando Jesus e nós, discípulos, saímos da casa dele, algumas pessoas trouxeram a Jesus um homem que não podia falar porque um demônio o dominava. ");
INSERT INTO portft_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Depois de Jesus expulsar o demônio, o homem que não podia falar começou a falar! A multidão que viu isso ficou admirada e disse: “Nunca antes vimos uma coisa tão maravilhosa quanto essa acontecer em Israel!” ");
INSERT INTO portft_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mas os fariseus disseram: “É Satanás, que domina os demônios, que faz com que este homem possa expulsar demônios das pessoas”.” ");
INSERT INTO portft_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Então Jesus passou conosco por muitas HYP das cidades e povoados no distrito da Galileia. Ele ensinava nos edifícios onde nós judeus louvamos a Deus e pregava a boa mensagem de como Deus governa sobre as vidas das pessoas. Ele também curava aqueles que tinham vários tipos de doenças e enfermidades. ");
INSERT INTO portft_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Quando Ele viu a multidão, teve pena das pessoas porque eram perturbadas e abatidas. Eram como ovelhas que não têm pastor SIM. ");
INSERT INTO portft_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Então Jesus deu esta ilustração a nós, discípulos: As pessoas que estão prontas para receber a mensagem de vocês são como uma plantação MET que está pronta para as pessoas colherem-na. Mas vocês que estão ensinando minha mensagem a eles são poucos. ");
INSERT INTO portft_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Portanto, orem e peçam a Deus que Ele envie mais trabalhadores que colherão as pessoas e vão ensiná-las a minha mensagem, assim como o proprietário envia trabalhadores para a roça dele para fazerem a colheita MET”. ");
INSERT INTO portft_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ele disse para nós, os doze discípulos, que fôssemos a Ele. Então Ele nos deu poder para expulsar os espíritos maus que dominavam as pessoas. Ele também nos capacitou para curar todas as pessoas que tinham enfermidades ou que estavam doentes. ");
INSERT INTO portft_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","São estes os doze discípulos que também se chamam apóstolos, que significa mensageiros/pessoas enviadas. Nossos nomes são: Simão a quem Ele deu o novo nome de Pedro e que é o mais importante entre nós; André, irmão mais novo dele; Tiago, filho de Zebedeu; João, irmão mais novo dele; ");
INSERT INTO portft_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipe; Bartolomeu; Tomé; eu, Mateus, o cobrador de impostos; Tiago, filho de Alfeu; Tadeu; ");
INSERT INTO portft_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simão, membro do partido que queria derrubar o governo romano; e Judas Iscariotes. Foi ele que mais tarde fez com que os inimigos de Jesus O pegassem. ");
INSERT INTO portft_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Quando Jesus estava para enviar a nós os doze apóstolos para falar a mensagem dele em vários lugares, Ele nos deu estas instruções: “Não vão aonde os não judeus vivem MTY nem às cidades onde os samaritanos que odeiam vocês moram. ");
INSERT INTO portft_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pelo contrário, vão às pessoas de Israel SYN que têm se afastado de Deus, assim como ovelhas que já se perderam MET têm se afastado do pastor delas. ");
INSERT INTO portft_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Quando forem a esses lugares, proclamem que Deus começará a governar sobre as pessoas daqui a pouco. ");
INSERT INTO portft_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Curem os doentes, façam com que os mortos tornem a viver, curem os leprosos e façam com que os demônios saiam das pessoas. Não cobrem dinheiro quando ajudarem as pessoas, porque Deus não cobrou vocês quando Ele os ajudou. ");
INSERT INTO portft_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Não levem dinheiro consigo MTY, nem mochila. Não levem uma camisa a mais nem sapatos além daqueles que estiverem usando, nem uma bengala. Todo trabalhador merece receber salário daqueles para quem trabalha, portanto vocês merecem receber comida e um lugar onde ficar das pessoas para quem vão. ");
INSERT INTO portft_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","12","No povoado ou na cidade em que entrarem, descubram quem é digno de receber vocês em sua casa. Quando entrarem naquela casa, peçam que Deus abençoe as pessoas que moram ali MTY. Fiquem nessa casa até saírem daquela cidade ou daquele povoado. ");
INSERT INTO portft_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Se as pessoas que morarem naquela casa estiverem dignas de Deus as abençoar, Deus vai abençoá-las. Se as pessoas que morarem naquela casa não estiverem dignas da bênção de Deus, Deus abençoará vocês e não as pessoas que moram naquela casa. ");
INSERT INTO portft_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Se as pessoas que morarem em qualquer casa ou cidade não receberem vocês na casa ou cidade delas, nem ouvirem a mensagem de vocês, saiam daquela casa ou cidade. Quando saírem, limpem o pó dos seus pés. Fazendo assim, vocês advertirão a eles que Deus vai castigá-los por rejeitarem a mensagem de vocês. ");
INSERT INTO portft_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Notem isso com cuidado: Quando Deus julgar todas as pessoas, Ele castigará aqueles que moravam em Sodoma e Gomorra MTY, as antigas cidades que Deus destruiu porque os habitantes delas eram muito maus. Porém, Deus castigará severamente as pessoas naquela cidade MTY que recusaram ouvir a mensagem de vocês”. ");
INSERT INTO portft_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Saibam que depois de eu enviar vocês, estarão tão indefesos quanto ovelhas MET no meio de pessoas tão maldosas quanto lobos. Vocês, da sua parte, devem ficar longe de tais homens, assim como vocês se afastam de cobras venenosas SIM. Devem ser tão inofensivos quanto são as pombas SIM. ");
INSERT INTO portft_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Também, não confiem muito nos seus líderes religiosos. Eles prenderão vocês e levarão vocês aos membros dos concílios religiosos para que possam julgá-los e castigá-los por serem meus discípulos. Os líderes locais chicotearão vocês com cordas nos lugares de reuniões de vocês. ");
INSERT INTO portft_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","E porque vocês ensinam sobre mim, vocês serão levados {os chefes religiosos levarão vocês} aos governadores e reis para que estes também possam julgá-los e castigá-los. Como resultado, vocês darão testemunho a esses governantes e a outros não judeus sobre o que eu tenho feito. ");
INSERT INTO portft_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Quando os líderes religiosos levarem vocês presos, não se preocupem com o que dirão a eles, porque naquele momento as palavras que devem dizer serão ditas a vocês pelo Espírito Santo {o Espírito Santo dará a vocês as palavras que devem dizer a eles}. ");
INSERT INTO portft_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Não é vocês que decidirão o que dizer. Pelo contrário vocês falarão o que o Espírito do seu Pai celeste disser para vocês falarem. ");
INSERT INTO portft_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Pessoas que não creem em mim levarão vocês às autoridades para que estas matem vocês porque vocês creem em mim. Por exemplo, as pessoas farão isso aos seus próprios irmãos, e os pais farão isso aos filhos deles. Os filhos se rebelarão contra seus próprios pais e farão com que outras pessoas os matem. ");
INSERT INTO portft_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Vocês serão odiados por muitos HYP {muitas HYP pessoas odiarão vocês} porque vocês creem em mim. Mesmo assim, muitas pessoas continuarão a crer em mim até que morram EUP. São essas as pessoas que Deus levará para viverem com Ele. ");
INSERT INTO portft_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Quando o povo de uma cidade fizer com que vocês sofram, fujam para outra cidade e falem com outras pessoas a meu respeito. Lembrem-se disto: vocês precisam falar a outros sobre mim agora porque eu, aquele que desci do céu, certamente adiarei a minha volta à terra até que vocês terminem de ir de uma cidade a outra cidade por todo Israel falando às pessoas sobre mim. ");
INSERT INTO portft_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","O discípulo não deve esperar ser melhor do que seu professor, e os servos não são superiores ao seu dono. Da mesma forma, já que sou seu professor e chefe, vocês podem saber que as pessoas vão maltratá-los, porque eles me maltratam. ");
INSERT INTO portft_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Não podem esperar que as pessoas tratarão o discípulo melhor do que tratam o professor dele, ou que tratarão o servo melhor do que tratam o dono dele. Só podem esperar que as pessoas tratarão vocês assim como me tratam. Sou como o chefe de uma casa MET. Mas as pessoas me insultaram chamando-me de Belzebu, o chefe dos demônios. Portanto elas certamente insultarão muito vocês, que são apenas os membros da minha casa MET! ");
INSERT INTO portft_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Não tenham medo daqueles que insultam vocês e fazem coisas ruins a vocês. Deus quer que tudo quanto não se saiba agora seja revelado {Deus quer que vocês revelem tudo que agora é desconhecido}. Ele não quer que sua verdade fique escondida MET e guardada em segredo DOU. ");
INSERT INTO portft_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Portanto, em vez de ter medo, o que digo a vocês em segredo como as pessoas fazem à noite MTY, falem publicamente como as pessoas fazem durante o dia MTY. O que eu digo a vocês em particular como as pessoas fazem quando lhes falam em voz muito baixa MTY, proclamem publicamente MTY, DOU. ");
INSERT INTO portft_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Não tenham medo das pessoas que podem matar o corpo SYN e não podem destruir a sua alma. Pelo contrário, temam a Deus, porque Ele pode destruir tanto o corpo da pessoa quanto a alma da pessoa no inferno. ");
INSERT INTO portft_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mesmo que dois pardais/passarinhos sejam vendidos {alguém possa comprar dois pardais} por apenas uma moedinha pequena RHQ, quando um pardal cai no chão e morre LIT, Deus, seu Pai no céu, sabe, pois sabe tudo. ");
INSERT INTO portft_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ele também sabe tudo a respeito de vocês. É até sabido {Ele até sabe} quantos cabelos você tem na sua cabeça! ");
INSERT INTO portft_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Deus valoriza os pardais um pouco, mas Ele valoriza vocês muito. LIT Portanto, não tenham medo das pessoas que ameaçam matar vocês! ");
INSERT INTO portft_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Sendo esta a verdade, eu direi a meu Pai que está no céu que conheço todos aqueles que dizem aos outros que me conhecem. ");
INSERT INTO portft_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Eu direi a meu Pai que está no céu que eu não conheço aqueles que dizem aos outros que eles não me conhecem. ");
INSERT INTO portft_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Não pensem que minha vinda à terra foi para fazer com que as pessoas vivessem em harmonia. O resultado da minha vinda é que as pessoas matarão aqueles que me seguem MTY. ");
INSERT INTO portft_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Porque eu vim à terra, aqueles que não creem em mim se oporão àqueles que creem em mim. Por exemplo, alguns filhos serão contrários aos pais deles, algumas filhas se oporão às mães delas e algumas noras se oporão às suas sogras. ");
INSERT INTO portft_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Isso mostra que às vezes os inimigos da pessoa são os membros de sua própria casa. ");
INSERT INTO portft_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Qualquer um que ama seu pai ou sua mãe mais do que me ama não é digno de que eu tenha relacionamento com ele. Também, qualquer um que ame seu filho ou sua filha mais do que me ama, não é digno de pertencer a mim. ");
INSERT INTO portft_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","As pessoas que estão se preparando para matar um preso o fazem carregar uma cruz ao lugar onde outros vão pregá-lo nela. MET Qualquer pessoa que não estiver MTY disposta a permitir que outros a machuquem e a desgracem assim porque é meu discípulo, não é digno de pertencer a mim. ");
INSERT INTO portft_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Qualquer pessoa que nega que crê em mim para que outros não a matem não viverá com Deus eternamente MET, mas qualquer pessoa que confessar que crê em mim e como resultado outros a matarem, viverá com Deus eternamente MET. ");
INSERT INTO portft_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Deus considerará que todos aqueles que receberem vocês, me recebem SIM e Ele considerará que todos os que me receberem recebem a Deus, aquele que me enviou SIM. ");
INSERT INTO portft_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Todos os que recebem alguém porque sabem que essa pessoa é profeta receberão o mesmo galardão que os profetas recebem de Deus. Da mesma forma, todo aquele que receber uma pessoa porque sabe que essa pessoa é justa receberá o galardão que os justos recebem de Deus. ");
INSERT INTO portft_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Notem isto: digamos que você dá algo frio MTY para beber para um dos meus discípulos quando este está com sede, porque você sabe que ele é meu discípulo. Você pode considerar que isso é insignificante e pode considerar esse discípulo insignificante, mas você certamente receberá um galardão de Deus por fazer isso. LIT ");
INSERT INTO portft_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Quando Jesus terminou de dizer a nós, os doze discípulos, o que fazer, Ele nos enviou a essas cidades de Israel. Então Ele foi ensinar e pregar em outras cidades vizinhas onde moram os israelitas. ");
INSERT INTO portft_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Enquanto João, o Batizador, estava na prisão, ele soube do que o homem que ele pensava ser o Messias estava fazendo. ");
INSERT INTO portft_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Por isso enviou alguns dos seus discípulos a Ele para perguntar-lhe: “O senhor é o Messias que os profetas disseram que viria ou é outro que devemos esperar vir?” ");
INSERT INTO portft_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Depois que eles fizeram esta pergunta a Jesus, Ele lhes respondeu: “Voltem e contem a João o que me ouvem dizer às pessoas e o que veem que estou fazendo. ");
INSERT INTO portft_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Faço os cegos verem e os coxos andarem. Curo as pessoas leprosas. Também estou fazendo com que os surdos ouçam e os mortos tornem a viver. Estou contando aos pobres a minha boa mensagem. ");
INSERT INTO portft_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Deus se agrada de cada pessoa que não deixa de crer em mim, porque o que faço não é o que essa pessoa esperou que o Messias fizesse”. ");
INSERT INTO portft_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Quando os discípulos de João foram embora, Jesus começou a dizer o seguinte às pessoas sobre João: “Pensem sobre que tipo de pessoa vocês foram ver naquela área deserta, quando foram ver João.—Vocês não/Será que vocês— RHQ foram lá para ouvir um homem cuja mensagem muda continuamente como ervas longas movidas {que o vento sopra} para cá e para lá pelo vento MET./? ");
INSERT INTO portft_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Então, que tipo de pessoa vocês foram ver lá? RHQ —Vocês não/Será que vocês— RHQ foram lá para ver um homem que estava vestido com roupas caras./? Vocês sabem bem que as pessoas que vestem roupas bonitas vivem nos palácios dos reis e não em lugares desertos. ");
INSERT INTO portft_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Então, que tipo de pessoa vocês foram ver? RHQ. Vocês foram lá RHQ para ver João, porque ele é um profeta/alguém que fala o que Deus diz a ele para falar? Sim, mas eu digo-lhes que João era mais importante do que um profeta comum. ");
INSERT INTO portft_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","João é aquele sobre quem foi escrito {sobre quem o profeta Malaquias escreveu} na Escritura onde Deus disse ao Messias: ‘Escute! Eu mandarei meu mensageiro para ir antes do senhor, SYN para preparar as pessoas MET para a sua vinda.’ ");
INSERT INTO portft_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Notem isto: de todas as pessoas que viveram até agora, nenhuma é maior à vista/aos olhos de Deus do que João, o Batizador. Porém, Deus considera maiores do que João cada um que deixa que Ele governe a sua vida, inclusive aquelas pessoas que os outros consideram insignificantes. ");
INSERT INTO portft_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Desde o tempo quando João, o Batizador, pregava até agora, outras pessoas atacam com violência aqueles que deixam Deus governar sobre suas vidas e eles sofrem (OU, as pessoas que pedem com insistência que Deus domine suas vidas, OU, os israelitas que pensam sobre eu me tornar o rei deles e estão muito ansiosos de serem incluídos no meu reino). Homens violentos estão se esforçando demais para tentar dominar as pessoas sobre quem Deus domina. ");
INSERT INTO portft_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Essas palavras sobre João são confirmadas pelo fato de que todos os homens que escreveram as Escrituras MTY, SYN profetizaram sobre o domínio de Deus sobre as vidas das pessoas, até que chegou João, o Batizador. ");
INSERT INTO portft_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ainda que a maioria de vocês não esteja disposta a crer nestas palavras, eu direi esta verdade a qualquer um que estiver disposto a crer: João é o homem que é como Elias. MET É ele que um dos profetas disse que viria para preparar as pessoas para receberem o Messias. ");
INSERT INTO portft_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Se quiserem entender isso, pensarão com cuidado MTY sobre o que acabo de dizer MTY”. ");
INSERT INTO portft_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Deixem-me ilustrar/Vocês sabem— RHQ como vocês que ouviram João e eu ensinarmos são./? Vocês são como crianças brincando em uma área aberta. Algumas delas estão chamando as outras, dizendo: ");
INSERT INTO portft_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nós tocamos músicas alegres na flauta para vocês, mas vocês não dançaram! Então, nós cantamos canções tristes de lamento pelos os mortos para vocês, mas vocês não choraram MET!’ ");
INSERT INTO portft_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","De modo semelhante, vocês estão descontentes tanto com João como comigo! Quando João, o Batizador, veio e pregou para vocês, ele não comeu comida boa e não bebeu vinho como faz a maioria das pessoas. Mas vocês o rejeitaram, dizendo: ‘Um demônio o domina.’ ");
INSERT INTO portft_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Depois, em contraste, eu, aquele que vim do céu, como a mesma comida e bebo vinho assim como os outros fazem. Mas vocês me rejeitam, dizendo: ‘Olhem, esse homem come demais e bebe vinho demais. Além disso, ele se associa com/anda em companhia de cobradores de impostos e outros pecadores!’ Mas será percebido por aqueles que consideram minhas ações e as de João {Aqueles que consideram minhas ações e as de João perceberão} que o que nós fazemos é realmente sábio MET, PRS”. ");
INSERT INTO portft_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","As pessoas que moravam nas cidades MTY daquela área viram Jesus fazer muitos milagres. Mas não ficaram tristes por pecarem e não deixaram de pecar. Então Jesus começou a repreendê-los, dizendo a eles: ");
INSERT INTO portft_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Vocês que moram na cidade de Corazim MTY e vocês que moram na cidade de Betsaida MTY sofrerão terrivelmente no inferno! Eu fiz milagres nas suas cidades, mas vocês não desistiram de suas más ações. Se alguém tivesse feito na cidade antiga de Tiro e na cidade antiga de Sidom os milagres que eu fiz nas cidades de vocês, as pessoas muito más que viviam lá teriam se sentado nas cinzas vestidas de pano grosseiro para mostrarem que estavam tristes por pecarem. ");
INSERT INTO portft_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Portanto notem isto: Deus castigará as pessoas más que viviam na cidade de Tiro MTY e na cidade de Sidom MTY, mas Ele castigará vocês com muita severidade no dia final quando Ele julgar todas as pessoas. ");
INSERT INTO portft_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Também tenho algo a dizer a vocês que moram na cidade de Cafarnaum MTY. Não pensem/será que vocês pensam— RHQ que serão honrados {que Deus vai honrá-los} no céu!/? Não! Pelo contrário, depois que vocês morrerem, serão mandados {Deus mandará vocês} para o lugar embaixo, onde Ele castigará as pessoas más para sempre! Deus destruiu a cidade antiga de Sodoma porque o povo que morava naquela cidade era muito mau. Se eu tivesse feito em Sodoma os milagres que fiz na cidade de vocês, essas pessoas teriam desistido de suas más ações e a cidade delas MET existiria ainda agora. MTY Mas vocês não desistiram de suas más ações, embora eu tenha feito milagres na cidade de vocês. ");
INSERT INTO portft_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Portanto observem isto: Deus castigará as pessoas que viviam na cidade de Sodoma MTY severamente, mas, em contraste, Deus castigará vocês muito severamente no dia final quando Ele julgar todas as pessoas.” ");
INSERT INTO portft_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Naquele momento Jesus disse a Deus: “Pai, o senhor governa sobre todo ser vivo no céu e na terra. Dou graças ao senhor por não deixar que as pessoas que se consideram sábias IRO porque são bem educadas entendam estas coisas. Pelo contrário, o senhor está revelando estas coisas às pessoas que aceitam logo a verdade do senhor, assim como fazem as crianças MET pequenas. ");
INSERT INTO portft_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Sim, Pai, o senhor tem feito isso porque lhe parecia bom fazer assim.” ");
INSERT INTO portft_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Então Ele disse às pessoas ali que queriam que Ele as ensinasse: “Deus, meu Pai, revelou-me toda a verdade/todas as coisas que preciso saber para meu trabalho. Somente o meu Pai sabe quem eu realmente sou. Além disso, somente eu e as pessoas a quem quero revelá-lo sabem como é Deus, meu Pai. ");
INSERT INTO portft_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Venham a mim, todos vocês que estão cansados de tentarem obedecer ao grande número de leis que seus líderes religiosos dizem para vocês obedecerem. MET Eu farei com que vocês possam deixar de tentar obedecer todas essas leis. ");
INSERT INTO portft_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Deixem- me ajudar vocês a levar essas cargas, assim como dois bois ajudam um ao outro a puxar uma carga pesada quando eles têm o jugo nos pescoços. MET DOU Já que sou manso/bondoso e humilde, DOU aceitem o que eu ensino sobre o que Deus quer que vocês façam. Como resultado, vocês deixarão de se preocupar em obedecer a todas as leis religiosas e seus espíritos estarão em paz.” ");
INSERT INTO portft_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Durante aquele tempo, em certo sábado/dia de descanso dos judeus, Jesus e nós, discípulos, estávamos andando por uma roça. Como estávamos com fome, começamos a pegar algumas espigas de trigo e comê-las. A lei de Moisés permitia que as pessoas fizessem isso se estivessem com fome. ");
INSERT INTO portft_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Alguns fariseus nos viram fazer o que eles consideravam trabalho. Então disseram a Jesus, acusando-o: “Olhe! Os seus discípulos estão fazendo um trabalho que nossas leis PRS não nos permitem fazer no nosso dia de descanso”. ");
INSERT INTO portft_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesus queria mostrar a eles que as Escrituras indicavam que Deus permitia às pessoas desobedecerem às leis religiosas quando precisavam de comida. Por isso Ele disse-lhes: “Escreveram nas Escrituras RHQ o que fez nosso estimado antepassado o Rei Davi quando ele e os homens que estavam com ele estavam com fome. Vocês já leram sobre isso, —mas vocês não/então por que vocês não— RHQ pensam sobre aquilo que isso implica! ");
INSERT INTO portft_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Davi entrou no quintal do tabernáculo/da casa de Deus e pediu comida. O sumo sacerdote deu a ele o pão que ele tinha apresentado a Deus. Depois disso, Davi e os homens que estavam com ele o comeram. Na lei de Moisés, só era permitido que os sacerdotes comessem esse pão, mas Deus não considerou que o que Davi fez fosse errado! ");
INSERT INTO portft_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Também, pensem na lei que Moisés escreveu RHQ. Ele disse que embora os sacerdotes, ao trabalharem no templo no dia de descanso dos judeus, não obedeçam às leis do dia de descanso dos judeus, eles não são culpados. Vocês com certeza já leram isso, mas não entendem o significado do que leram. ");
INSERT INTO portft_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Notem isto: Deus certamente permite o trabalho no templo no nosso dia de descanso porque esse trabalho é obrigatório. Mas além disso, digo a vocês que tenho mais autoridade do que a autoridade do templo. Por isso, é mais importante vocês obedecerem aos meus ensinamentos do que obedecerem às tradições do nosso dia de descanso. ");
INSERT INTO portft_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","O que alguém escreveu nas Escrituras mostra que isso é a verdade. Deus disse: ‘Desejo que vocês ajam com misericórdia e não que apenas ofereçam sacrifícios.’ Se vocês entendessem o significado disso, não acusariam meus discípulos que não fizeram nada errado. ");
INSERT INTO portft_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Quero que vocês saibam que eu, aquele que vim do céu para a terra, tenho a autoridade de Deus para dizer às pessoas o que é certo fazer no nosso dia de descanso. ");
INSERT INTO portft_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Depois que Jesus saiu de lá naquele dia, entrou em um edifício onde nós judeus adoramos Deus. ");
INSERT INTO portft_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ali Ele viu um homem com a mão aleijada. Já que os fariseus consideravam que Jesus estaria desobedecendo à tradição de não trabalhar no dia de descanso se Ele fosse curar o homem, um deles perguntou-lhe: “Deus permite que as pessoas curem outras pessoas no nosso dia de descanso?” Fizeram essa pergunta para que pudessem acusá-lo se Ele curasse alguém no sábado/dia de descanso dos judeus. ");
INSERT INTO portft_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ele disse-lhes: “Será que qualquer um de vocês que tiver apenas uma ovelha que cai em um buraco no sábado/dia de descanso dos judeus vai simplesmente deixá-la ali RHQ? Absolutamente não! Você vai pegá-la e tirá-la imediatamente, o que seria um trabalho aceitável para nosso dia de descanso, também! ");
INSERT INTO portft_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Já que as ovelhas são valiosas, os donos delas podem trabalhar no dia de descanso dos judeus para resgatá-las. Portanto, desde que as pessoas são de ainda mais valor do que as ovelhas, certamente é justo que alguém faça algo bom curando outra pessoa em qualquer dia, inclusive no nosso dia de descanso!” ");
INSERT INTO portft_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Então Ele disse ao homem: “Estenda a sua mão aleijada!” Então ele a estendeu e ela ficou normal como a outra mão! ");
INSERT INTO portft_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Os fariseus saíram da casa de reuniões. Eles tinham medo de que as pessoas rejeitassem seus costumes/tradições e em vez de segui-los, aceitassem o ensinamento de Jesus. Por isso eles se reuniram para planejarem como matá-lo. ");
INSERT INTO portft_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Como Jesus sabia que os fariseus planejariam matá-lo, foi-se embora dali. Multidões, incluindo muitas pessoas doentes, O seguiram para que Ele as curasse e Ele curou todas elas. ");
INSERT INTO portft_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Porém, disse firmemente a elas que ainda não deviam dizer aos outros quem Ele era. ");
INSERT INTO portft_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ele agia assim com humildade para que o que foi dito pelo profeta Isaías {o que o profeta Isaías disse} há muito tempo atrás sobre o Messias, se cumprisse {acontecesse}. Isaías escreveu: ");
INSERT INTO portft_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Observem meu servo que escolhi, aquele que amo e em quem tenho prazer. Eu colocarei o meu Espírito nele, e Ele proclamará que Deus julgará os não judeus com justiça. ");
INSERT INTO portft_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ele não brigará com os outros, nem gritará. Não ensinará em voz bem alta nas ruas principais. ");
INSERT INTO portft_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Até que Ele julgue corretamente as pessoas que confiam nele e as declare não culpadas, Ele não destruirá ninguém que é fraco como um galho quebrado, MET nem mandará ficar quieto ninguém que está sem qualquer amparo, como uma luz que está quase apagada MET, DOU. ");
INSERT INTO portft_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Como resultado, os não judeus sempre esperarão que Ele faça grandes coisas para eles”. ");
INSERT INTO portft_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Alguns homens levaram para Jesus um homem que era cego e não podia falar por causa de um demônio que o dominava. Jesus o curou expulsando o demônio. Como resultado o homem começou a falar e a ver. ");
INSERT INTO portft_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Toda a multidão que viu isso ficou admirada. Perguntavam uns aos outros: “Será que este homem é o Messias que esperamos, o descendente do Rei Davi?” ");
INSERT INTO portft_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Quando os fariseus e os homens que ensinavam as leis judaicas ouviram que o povo pensava que Jesus era o Messias, porque Ele expulsou o demônio, eles disseram: “Não é Deus, mas Satanás que tem autoridade sobre os demônios, que faz com que este homem possa expulsar demônios das pessoas!” ");
INSERT INTO portft_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mas Jesus sabia o que os fariseus estavam pensando e dizendo. Por isso, para mostrar a eles que o que disseram não fazia sentido, disse-lhes: “Quando aqueles sobre quem um rei governa brigam uns com os outros, deixarão de ser um só grupo sobre quem Ele governa. Se as pessoas que moram na mesma casa brigam entre si, certamente não permanecerão como uma família. ");
INSERT INTO portft_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","De modo semelhante, se Satanás expulsasse seus próprios demônios, seria como se lutasse contra si mesmo. Seu reino não/Como é que seu reino RHQ poderia continuar./? ");
INSERT INTO portft_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","E mais, se é verdade que Satanás faz com que eu expulse demônios das pessoas, também é verdade que os discípulos de vocês que expulsam demônios fazem isso da mesma maneira RHQ? Não! Portanto, eles julgarão que vocês não estão pensando de forma lógica. ");
INSERT INTO portft_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mas já que é o Espírito de Deus que me dá o poder para expulsar demônios, isso prova que o poder de Deus para dirigir as vidas das pessoas já veio para vocês. ");
INSERT INTO portft_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Dar-lhes-ei outro exemplo que ilustra como posso expulsar demônios das pessoas. Uma pessoa não pode/Como é que uma pessoa pode RHQ entrar na casa de um homem forte MET como a de Satanás e levar embora seus bens, se não amarrar primeiro o homem forte./? Apenas depois ele poderá roubar as coisas na casa do homem. ");
INSERT INTO portft_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ninguém pode permanecer neutro. Aqueles que não reconhecem que o Espírito Santo me dá o poder para fazer com que os demônios saiam das pessoas, se opõem a mim. Aqueles que não ajuntam as pessoas para que elas possam vir a mim, estão fazendo com que elas me rejeitem. DOU ");
INSERT INTO portft_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Para mostrar a vocês o resultado do que estão dizendo sobre o Espírito Santo quando não o reconhecem como aquele que me dá o poder para expulsar demônios, eu direi o seguinte: se alguém ofende e blasfema outras pessoas, se ele se arrepende e pede a Deus para perdoá-lo, ele será perdoado {Deus vai perdoá-lo}. Mas aqueles que não reconhecem o que o Espírito Santo faz não serão perdoados {Deus não perdoará aqueles que não reconhecem o que o Espírito Santo faz}. ");
INSERT INTO portft_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aqueles que criticam a mim, que desci do céu, podem ser perdoados {Deus está disposto a perdoar aqueles que criticam a mim, que desci do céu}. Mas aqueles que falam mal do que o Espírito Santo faz não serão perdoados {Deus não perdoará as pessoas que criticam o Espírito Santo}. Não serão perdoados {Ele não vai perdoá-los} agora e nunca serão perdoados {Ele nunca vai perdoá-los}”. ");
INSERT INTO portft_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Decidam se uma pessoa e o que ela diz é bom, assim como decidem se uma árvore MET e a fruta que produz MET são boas. Ou decidam se uma pessoa e as palavras que ela diz são más, da mesma forma que decidem se uma árvore MET e a fruta dela MET são podres/ruins. Assim como se sabe {as pessoas sabem} o tipo de árvore, vendo a fruta que ela produz, as pessoas podem saber como vocês fariseus realmente são, ouvindo as suas acusações contra mim. ");
INSERT INTO portft_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","O que vocês dizem fere as pessoas assim como as cobras venenosas ferem. MET Vocês não podem falar palavras boas porque vocês são maus. RHQ Pessoas más SYN como vocês, falam as palavras que procedem de tudo que pensam. ");
INSERT INTO portft_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Semelhantemente, as pessoas boas falam palavras boas. É como tirar coisas boas dos depósitos onde guardamos coisas boas. Mas as pessoas más falam coisas más. É como tirar coisas más dos depósitos onde guardamos coisas más. MET ");
INSERT INTO portft_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Digo a vocês que no dia do juízo, Deus fará com que as pessoas prestem contas de cada palavra inútil que falaram e vai julgá-las conforme essas palavras. ");
INSERT INTO portft_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Deus dirá que são justos com base no que falam ou serão condenados {Deus condenará vocês} com base no que vocês dizem”. ");
INSERT INTO portft_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Então alguns dos fariseus e homens que ensinavam as leis judaicas às pessoas responderam ao que Jesus estava ensinando dizendo a ele: “Mestre, queremos que o senhor faça um milagre que possamos ver e que nos prova que Deus enviou o Senhor”. ");
INSERT INTO portft_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Então Jesus disse- lhes: “Vocês que já me viram fazer milagres são maus e não adoram a Deus MET! Vocês querem que eu faça um milagre que prove que Deus me enviou, mas Deus fará com que possam ver apenas um milagre. Será como aquele que aconteceu ao profeta Jonas MET. ");
INSERT INTO portft_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","O profeta Jonas ficou na barriga de um peixe enorme por três dias e noites antes de Deus fazer com que vivesse de novo. Semelhantemente, eu, que desci do céu, estarei em um lugar onde as pessoas mortas ficam por três dias e noites antes que Deus me faça viver novamente. ");
INSERT INTO portft_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Quando Deus julgar todas as pessoas, as pessoas que vivem em Nínive se levantarão diante de Deus com vocês que me veem fazer milagres. Essas pessoas deixaram seus maus caminhos como resultado de ouvirem o que Jonas pregou. Jonas era importante, mas eu, que sou mais importante do que Jonas, estou aqui e prego que vocês devem abandonar seus maus caminhos. Mas vocês não fazem isso. Portanto, quando Deus julgar todas as pessoas, Ele condenará vocês. ");
INSERT INTO portft_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","A Rainha de Sabá, ao sul de Israel, que viveu há muito tempo atrás veio de uma região distante para ouvir o Rei Salomão ensinar muitas coisas sábias. Mas eu, que sou maior e muito mais sábio do que Salomão, estou aqui. Porém vocês não me ouvem. Portanto, quando Deus julgar todas as pessoas, a Rainha de Sabá se levantará diante de Deus com vocês e condenará vocês”. ");
INSERT INTO portft_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Às vezes quando um Espírito mal sai de uma pessoa, ele anda por lugares desertos e procura uma outra pessoa em quem possa descansar. Se não achar ninguém, ");
INSERT INTO portft_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","diz a si mesmo: ‘Eu voltarei para aquela pessoa MET em quem eu antes morava ‘. Aí ele volta ao lugar onde vivia antigamente. Então ele vê que o Espírito de Deus não está no controle da vida dessa pessoa. Essa pessoa é como uma casa que foi varrida {que alguém já varreu} MET limpa e com tudo em ordem {e colocou tudo em ordem}, mas como uma casa vazia. ");
INSERT INTO portft_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Então esse Espírito mal vai e encontra sete outros espíritos que são muito ruins e vai com eles para essa pessoa em quem vivia antes e todos eles passam a viver ali. Portanto, embora a condição dessa pessoa antes fosse ruim, tornou-se ainda pior. É isso que vocês malvados, que me ouvem ensinar, experimentarão”. ");
INSERT INTO portft_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Enquanto Jesus ainda falava com as multidões, a mãe e os irmãos dele chegaram, porque queriam falar com Ele. Ficaram fora da casa. ");
INSERT INTO portft_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aí alguém disse a Ele: “Sua mãe e irmãos mais novos estão fora da casa, porque querem falar com o senhor”. ");
INSERT INTO portft_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Então Jesus disse à pessoa que lhe contou isso: “Eu lhe direi algo sobre/Você sabe quem eu considero RHQ minha mãe e meus irmãos MET”./? ");
INSERT INTO portft_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Então Ele apontou para nós, discípulos, e disse: “São estes que amo tanto quanto minha mãe e meus irmãos. MET ");
INSERT INTO portft_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Qualquer pessoa que fizer o que Deus meu Pai que está no céu quer que ele faça, é tão importante para mim MET quanto meu irmão, minha irmã ou minha mãe”. ");
INSERT INTO portft_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Naquele mesmo dia, depois de Jesus sair conosco da casa onde estava ensinando, Ele foi para o lago da Galileia. ");
INSERT INTO portft_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Uma grande multidão juntou-se ao redor dele para ouvi-lo ensinar. Então, para que as pessoas não O apertassem (OU, para falar melhor com as pessoas) Ele entrou em um barco e sentou-se para ensiná-las. A multidão ficou em pé na praia e estava ouvindo. ");
INSERT INTO portft_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ele estava contando muitas parábolas a eles. Uma das parábolas que Ele ensinou foi esta: “Escutem! Um homem foi para sua roça e começou a semear/plantar sementes. ");
INSERT INTO portft_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Enquanto ele espalhava as sementes, algumas delas caíram no caminho. Aí uns pássaros chegaram e comeram essas sementes. ");
INSERT INTO portft_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Outras sementes caíram em terra rochosa/onde havia muitas pedras com pouca terra em cima das pedras. Essas sementes brotaram logo, porque o sol esquentou rapidamente a pouca terra que tinha. ");
INSERT INTO portft_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mas quando o sol brilhou nessas plantinhas novas, elas murcharam. Já que as raízes não tinham terra funda, elas secaram. ");
INSERT INTO portft_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Outras sementes caíram em terra onde havia raízes de espinhos. Os espinheiros cresceram junto com o trigo e o sufocaram. ");
INSERT INTO portft_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mas outras sementes caíram em terra produtiva e as plantas produziram muito trigo. Algumas das plantas produziram cem vezes mais sementes do que foram plantadas. Outras plantas produziram sessenta vezes mais sementes do que foram plantadas. Outras plantas produziram trinta vezes mais sementes do que foram plantadas. ");
INSERT INTO portft_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Se quiserem entender isso MTY, pensem com cuidado sobre o que acabo de dizer”. ");
INSERT INTO portft_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nós, discípulos, chegamos perto de Jesus e perguntamos a ele: “Por que é que o senhor fala com a multidão em parábolas?” ");
INSERT INTO portft_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ele nos respondeu, dizendo: “Está sendo revelado a vocês por Deus {Deus está revelando a vocês} o que Ele pretende fazer enquanto governa sobre as vidas das pessoas, coisa que Ele não revelou antes. Mas isso não está sendo revelado {Deus não está revelando isso} aos outros. ");
INSERT INTO portft_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Quando uma pessoa pensar no que eu digo e entender, ela poderá {Deus fará com que possa} entender mais. Mas quando uma pessoa não pensar com cuidado sobre o que eu digo, ela se esquecerá até mesmo do que sabe. ");
INSERT INTO portft_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Como resultado, falo aos outros em parábolas, porque embora vejam o que faço, não percebem o que significa, e embora ouçam o que digo, não entendem o que significa. ");
INSERT INTO portft_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","O que essas pessoas fazem cumpre totalmente o que Deus mandou o profeta Isaías dizer há muito tempo atrás àqueles que não tentaram entender o que Ele dizia: ‘Vocês ouvirão o que digo, mas com certeza não entenderão. Vocês continuarão a ver o que faço, mas certamente não entenderão o que significa.’ DOU ");
INSERT INTO portft_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Então Deus disse a Isaías: ‘Estas pessoas não respondem mais MTY àquilo que me veem fazer e me ouvem dizer a elas. Elas escutam sem querer MTY àquilo que digo a elas e não observam MTY o que faço. Se não fosse assim, perceberiam MTY o que estou fazendo, entenderiam MTY o que digo a elas, se voltariam a mim, deixariam suas vidas de pecado e eu iria salvá-las de serem punidas por seus pecados MET.’ ");
INSERT INTO portft_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mas quanto a vocês, Deus tem prazer em vocês, porque SNY vocês veem o que eu faço e SYN entendem o que eu digo. ");
INSERT INTO portft_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Notem isto: muitos profetas e pessoas justas que viveram há muito tempo atrás desejavam ver o que vocês me veem fazer, mas não viram milagres como os que estou fazendo. Eles desejavam ouvir as coisas que vocês estão me ouvindo dizer, mas não ouviram o que vocês me ouvem dizer”. DOU ");
INSERT INTO portft_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Já que Deus quer que vocês entendam as parábolas que conto, ouçam-me explicar a parábola do homem que espalha as sementes nos vários tipos de solo. ");
INSERT INTO portft_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Aqueles que ouvem de como Deus governa sobre as vidas das pessoas e não entendem o que estão ouvindo são como o caminho onde as sementes foram semeadas {onde o agricultor espalhou as sementes}. Satanás, o Maligno, chega e faz com que eles se esqueçam MET do que ouviram MET. ");
INSERT INTO portft_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Outros que ouvem o que digo e logo aceitam e ficam alegres, são como a terra que não é funda em cima das pedras. As plantas que brotam nesta terra pedregosa não criam raízes fundas e, por isso, vivem por pouco tempo. De modo semelhante, quando alguém trata mal aqueles que aceitam o que digo e os faz sofrer, eles logo desistem de crer na mensagem de Deus. ");
INSERT INTO portft_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Outros que ouvem o que digo são como a terra que contêm raízes de espinhos. Eles se preocupam demais sobre como podem prosperar/melhorar a vida. Pensam erradamente que ficarão felizes ganhando muito dinheiro. PRS Eles deixam de escutar o que digo. MET Como resultado, não fazem o que Deus quer que façam. ");
INSERT INTO portft_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mas certas pessoas são como a terra boa onde as sementes foram plantadas {onde o agricultor plantou as sementes}. Assim como as plantas que brotaram nesta terra produziram muito trigo, certas dessas pessoas farão muitas coisas que agradam a Deus, outras farão ainda mais coisas que agradam a Deus e algumas farão muitíssimas coisas que agradam a Deus”. ");
INSERT INTO portft_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus também contou à multidão esta parábola para explicar que, embora Deus seja rei, Ele não julgará e castigará todas as pessoas más imediatamente. Ele disse: “Deus é como um proprietário/dono de terra cujos servos semearam semente boa de trigo em uma roça. ");
INSERT INTO portft_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Quando esses servos estavam dormindo e não estavam guardando a roça, um inimigo do proprietário chegou e semeou sementes de joio/erva ruim no meio das sementes de trigo. Aí ele saiu. ");
INSERT INTO portft_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Depois que as sementes brotaram e as plantas verdes cresceram, as espigas de trigo começaram a formar. Porém, o joio/a erva ruim também cresceu. ");
INSERT INTO portft_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Então os servos do proprietário chegaram e disseram a ele: ‘Senhor, certamente o senhor RHQ nos deu semente boa e, sem dúvida, RHQ plantamos sementes boas na sua roça. Então, de onde veio o joio?’ ");
INSERT INTO portft_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","O proprietário disse a eles: ‘Meu inimigo fez isso.’ Os servos lhe perguntaram: ‘O senhor quer que arranquemos o joio e juntemos?’ ");
INSERT INTO portft_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Então ele lhes respondeu: ‘Não, não arranquem e juntem o joio. Se fizerem isso, vocês talvez arranquem o trigo também. ");
INSERT INTO portft_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Deixem o trigo e o joio crescerem juntos até que colham o trigo. Naquela hora eu direi aos trabalhadores que farão a colheita: ‘Primeiro juntem o joio e amarrem-no em feixes, pois mais tarde vou queimá-lo. Depois colham o trigo e ponha-o nos meus depósitos.’” ");
INSERT INTO portft_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus também contou para nós, discípulos, esta parábola: “O número de (OU, a influência de Deus nas vidas das) pessoas cujas vidas Deus governa, continuará a crescer. Isso é muito semelhante a sementes de mostarda que um homem planta na sua roça e que crescem muito. ");
INSERT INTO portft_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Embora as sementes de mostarda aqui em Israel sejam das menores de todas as sementes que se plantem, quando as plantas de mostarda crescem, são maiores do que as outras plantas da roça. São tão grandes que os pássaros podem fazer ninhos nos seus ramos.” ");
INSERT INTO portft_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesus também nos contou esta parábola: “A maneira em que as pessoas que deixam Deus governar suas vidas MET podem influenciar o mundo é assim como o fermento que uma mulher mistura com três medidas de farinha de trigo. Essa pequena quantia de fermento faz a massa toda crescer”. ");
INSERT INTO portft_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus contou parábolas à multidão para ensinar muitas coisas. Ele sempre falava HYP às pessoas usando ilustrações. ");
INSERT INTO portft_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ao falar assim em parábolas, Jesus cumpriu o que foi dito a um dos profetas {o que Deus disse a um dos profetas} para escrever há muito tempo atrás: Eu falarei MTY em parábolas; contarei parábolas para ensinar o que é guardado/eu guardo em segredo desde que criei o mundo”. ");
INSERT INTO portft_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Depois que Jesus mandou embora a multidão, Ele entrou na casa. Então nós, discípulos, chegamos perto dele e dissemos: “Explique-nos a parábola do joio que cresceu no campo do trigo”. ");
INSERT INTO portft_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Então Jesus respondeu: Aquele que semeia a semente boa sou eu, que desci do céu. ");
INSERT INTO portft_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","O campo representa o mundo, MTY onde vivem as pessoas. As sementes que cresceram bem representam as pessoas que deixam que Deus governe as suas vidas. O joio representa as pessoas que fazem o que o diabo, o Maligno, diz a eles para fazerem. ");
INSERT INTO portft_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","O inimigo que semeou o joio representa o diabo. O tempo quando o trigo será colhido representa a época quando o mundo acabará. Os que colhem representam os anjos. ");
INSERT INTO portft_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","O joio é juntado. Depois é queimado. {Os trabalhadores que fazem a colheita juntam o joio. Depois eles o queimam.} Isso representa o julgamento das pessoas, que Deus realizará quando o mundo acabar. Será assim: ");
INSERT INTO portft_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Eu, aquele que desci do céu, mandarei meus anjos e eles colherão de todas as partes todas as pessoas que fazem com que outras pessoas deixem de crer em mim e todas que desobedecem o que Deus manda. ");
INSERT INTO portft_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Eles jogarão essas pessoas no fogo do inferno. Ali essas pessoas chorarão e rangerão os dentes, porque estarão com muita dor. ");
INSERT INTO portft_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","As pessoas que obedecem ao que Deus manda brilharão como brilha o sol no lugar onde Deus, o Pai delas, governa sobre elas. Se vocês forem realmente sábios, pensarão com cuidado sobre o que acabo de dizer”. ");
INSERT INTO portft_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","O que as pessoas fazem quando começam a deixar Deus governar as suas vidas é como aquilo que o homem faz para conseguir um tesouro. Um tesouro foi escondido por alguém em um campo {Alguém escondeu um tesouro em um campo} e nunca o desenterrou. Quando outro homem o achou, ele o escondeu, enterrando-o de novo para que nenhum outro o achasse. Este homem estava muito feliz por ter achado algo de grande valor. Ele foi vender todos os seus bens para que pudesse conseguir dinheiro suficiente para comprar o campo onde o tesouro estava e comprou aquele campo para que pudesse ter o tesouro. ");
INSERT INTO portft_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","O que as pessoas que deixam Deus governar suas vidas fazem é semelhante àquilo que o comerciante faz quando procura pérolas de boa qualidade que possa comprar. ");
INSERT INTO portft_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Quando acha uma pérola muito cara à venda, ele vende todos os seus bens para obter o dinheiro para comprar aquela pérola. Depois ele a compra. ");
INSERT INTO portft_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","O que Deus fará às pessoas que dizem falsamente que Ele governa sobre as vidas delas é semelhante àquilo que fazem os pescadores que jogam uma grande rede de pescar no lago. Eles pegam todo tipo de peixe, tanto útil quanto inútil, naquela rede. ");
INSERT INTO portft_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Quando a rede está cheia, os pescadores arrastam para a praia. Eles se sentam ali e colocam os peixes úteis em cestos, mas jogam fora os que não prestam. ");
INSERT INTO portft_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","A separação dos peixes é como o julgamento das pessoas que Deus realizará quando o mundo acabar. Isso acontecerá assim: Os anjos chegarão ao lugar onde Deus está julgando as pessoas e separarão as pessoas ruins das pessoas justas. ");
INSERT INTO portft_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Então eles jogarão as pessoas más no fogo do inferno. Estas pessoas chorarão e rangerão os dentes por estarem com muita dor. ");
INSERT INTO portft_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Então Jesus nos perguntou: “Vocês entendem todas as parábolas que eu conto para vocês?” Dissemos a Ele: “Entendemos sim, entendemos essas parábolas”. ");
INSERT INTO portft_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Então Ele nos disse: “Já que vocês entendem todas estas parábolas, também entenderão a seguinte parábola: Vocês e todos os outros que ensinam às pessoas o que Deus disse sobre como Ele governa as vidas das pessoas e que acrescentam isso às coisas que já tinham aprendido, são como o dono de uma casa que tira coisas novas e coisas antigas de seu depósito”. ");
INSERT INTO portft_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Quando Jesus terminou de contar estas parábolas, saiu conosco daquela casa. ");
INSERT INTO portft_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Fomos a Nazaré, sua cidade natal. No sábado/dia de descanso dos judeus, Ele começou a ensinar as pessoas na casa de louvor dos judeus. O resultado foi que as pessoas ali ficaram maravilhadas. Mas alguns disseram: “Sendo Ele um homem comum como nós, —não entendemos como/como é que— RHQ Jesus sabe tanto e entende tão bem!/? E—nós não entendemos como/como é que RHQ Ele pode fazer milagres!/? ");
INSERT INTO portft_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ele é/Não é ele RHQ apenas o filho do carpinteiro!/? A mãe dele se chama Maria e os irmãos mais novos dele se chamam Tiago, José, Simão e Judas RHQ! ");
INSERT INTO portft_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","As irmãs dele também vivem aqui na nossa cidade, não vivem RHQ? Então como é que Ele pode fazer todos estes milagres?” ");
INSERT INTO portft_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Como resultado, o povo ficou ofendido com a ideia de que Ele era o Messias. Por isso, Jesus disse-lhes: “As pessoas honram a mim e a outros profetas em outros lugares, mas as pessoas nas nossas cidades natais e até as nossas famílias não nos honram”. ");
INSERT INTO portft_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jesus não fez muitos milagres ali porque as pessoas dali não creram que Ele fosse o Messias. ");
INSERT INTO portft_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Por aquele tempo Herodes Antipas, o chefe, ouviu relatos de como Jesus fazia milagres. ");
INSERT INTO portft_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Por esta razão ele disse aos seus servos: “É João, o Batizador. Ele pode fazer milagres porque ressuscitou dos mortos”. ");
INSERT INTO portft_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","A razão por que Herodes pensou assim foi esta: Herodes casou-se com Herodias, a esposa de Filipe, o irmão dele, enquanto Filipe ainda estava vivo. Então João lhe disse: “A lei de Deus não permite que você se case com a mulher do seu irmão enquanto este ainda está vivo!” Por isso dizer isso, Herodes mandou que seus soldados colocassem João na cadeia. Eles o amarraram e o colocaram na prisão. ");
INSERT INTO portft_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mesmo que Herodes quisesse matar João, tinha medo que as pessoas que João tinha ensinado se rebelassem contra ele se ele fizesse isso. Pois todos pensavam que João era um profeta. ");
INSERT INTO portft_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mas quando Herodes deu uma festa para celebrar o seu aniversário, a filha de Herodias dançou no meio dos convidados dele. Isso agradou Herodes. ");
INSERT INTO portft_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Então ele prometeu dar a ela o que ela quisesse e pediu que Deus o castigasse se não cumprisse a promessa. ");
INSERT INTO portft_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A filha de Herodias perguntou à mãe dela o que devia pedir de Herodes. Foi dito a ela pela sua mãe {Sua mãe disse a ela} para pedir a cabeça de João, o Batizador. Como resultado, a filha dela disse a Herodes: “Corte a cabeça de João, o Batizador, e traga para cá em um prato para que minha mãe saiba que ele está morto!” ");
INSERT INTO portft_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","O rei ficou perturbado, porque sabia que cometeria um grande crime. Mas porque jurou diante dos seus convidados quando fez essa promessa e não queria que os convidados pensassem que ele não cumpriria sua promessa, ele mandou que dessem a ela {que os soldados dessem a ela} o que ela queria. ");
INSERT INTO portft_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ele enviou um soldado à prisão para que cortasse a cabeça de João. ");
INSERT INTO portft_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","O soldado fez isso e a cabeça de João foi levada em um prato e dada {levou a cabeça de João em um prato e deu} à moça. Então ela a levou e mostrou à mãe dela. ");
INSERT INTO portft_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Os discípulos de João foram à prisão, pegaram o corpo dele e o enterraram. Depois eles relataram a Jesus o que tinha acontecido. ");
INSERT INTO portft_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Depois que Jesus soube que Herodes matou João, ele viajou só conosco de barco pelo lago da Galileia a um lugar remoto. ");
INSERT INTO portft_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Quando chegou à praia Ele viu uma grande multidão de pessoas que se reuniu ali, à espera de/esperando Jesus. Ele teve pena das pessoas e curou os doentes entre elas. ");
INSERT INTO portft_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Quando a noite já se aproximava, nós, discípulos, chegamos a Ele e dissemos: Este é um lugar onde não mora ninguém e está muito tarde. Mande as pessoas embora para que possam ir às cidades perto daqui, para poderem comprar comida para si mesmas. ");
INSERT INTO portft_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mas Jesus nos disse: “Não precisam sair para acharem comida. Em vez disso, vocês mesmos deem algo para comer a elas aqui!” ");
INSERT INTO portft_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Dissemos a Ele: “Temos somente cinco pães e dois peixes cozidos aqui!” ");
INSERT INTO portft_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ele nos disse: “Tragam para mim!” ");
INSERT INTO portft_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Disse às pessoas reunidas ali para se sentarem no gramado. Aí Ele pegou os cinco pães e os dois peixes. Enquanto olhava para o céu Ele agradeceu a Deus pelos pães e peixes e os separou em pedaços. Então Ele deu os pedaços para nós, discípulos, e nós distribuímos à multidão. ");
INSERT INTO portft_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Todos na multidão comeram até sentirem que tinham comido o suficiente. Então nós, discípulos, recolhemos os pedaços que sobraram e enchemos doze cestos. ");
INSERT INTO portft_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Os que comeram eram mais ou menos 5. ");
INSERT INTO portft_vpl VALUES ("MT14_000","070_14_000","MAT","14","000","000","homens. Nem contamos as mulheres e as crianças. ");
INSERT INTO portft_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Logo depois disso acontecer, Jesus mandou que nós, discípulos, entrássemos no barco e fossemos diante dele a outro lugar, enquanto Ele mandava embora as multidões. ");
INSERT INTO portft_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Depois dele despedir-se das multidões, subiu nos montes só para orar. Quando já era noite, Ele ainda estava lá sozinho. ");
INSERT INTO portft_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nessa hora o barco já estava há centenas de metros da praia. Ele era jogado muito pelas ondas {As ondas estavam jogando-o muito} porque o vento soprava contra ele. ");
INSERT INTO portft_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Então Jesus desceu do monte para o lago. Em algum momento entre três e seis da manhã, Ele andou em cima da água em direção ao nosso barco. ");
INSERT INTO portft_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Quando nós, discípulos, o vimos andando em cima da água, pensamos que fosse um fantasma. Ficamos apavorados e gritamos porque estávamos com medo. ");
INSERT INTO portft_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Logo Jesus nos disse: “Animem-se! Sou eu. Não tenham medo!” ");
INSERT INTO portft_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedro disse-lhe: “Senhor, se for o senhor, diga-me para andar na água até o senhor!” ");
INSERT INTO portft_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesus disse: “Venha!” Então Pedro saiu do barco. Ele andou na água em direção a Jesus. ");
INSERT INTO portft_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mas quando Pedro viu as ondas fortes causadas pelo vento, ficou com medo. Ele começou a afundar e gritou, “Senhor, salve-me!” ");
INSERT INTO portft_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Imediatamente Jesus estendeu a mão e o pegou. Ele disse a Pedro: “Você confia só um pouco no meu poder! Você não devia ter duvidado/Por que você duvidou RHQ que eu pudesse protegê-lo de afundar./?” ");
INSERT INTO portft_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Então Jesus e Pedro entraram no barco. O vento deixou de soprar. ");
INSERT INTO portft_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nós, discípulos, que estávamos no barco com Ele O louvamos e dissemos: “Verdadeiramente o senhor é o Filho de Deus!” ");
INSERT INTO portft_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Quando tínhamos atravessado ainda mais do lago em um barco, chegamos à cidade de Genesaré. ");
INSERT INTO portft_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Os homens daquela área reconheceram Jesus. Como resultado, mandaram algumas pessoas para informar o povo que vivia por toda aquela região MTY de que Jesus estava na área deles. Então o povo que vivia naquela região trouxe a Jesus todas as pessoas doentes que moravam ali. ");
INSERT INTO portft_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Os doentes pediam que Ele os deixasse tocar nele ou tocar só na barra da roupa dele para que Jesus pudesse curá-los. E todos os que tocaram nele ou na roupa dele foram curados {Ele curou todos aqueles que tocaram nele ou na roupa dele}. ");
INSERT INTO portft_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Então alguns fariseus e homens que ensinavam as leis judaicas ao povo chegaram da cidade de Jerusalém para falar com Jesus. Eles disseram: ");
INSERT INTO portft_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“É lamentável que/Por que RHQ os discípulos do senhor desobedeçam/desobedecem o que nossos antepassados escreveram e nossos anciãos nos ensinaram!/? Antes que os discípulos do senhor comam, eles não lavam as mãos de uma maneira que faça com que Deus não os rejeite”. ");
INSERT INTO portft_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus respondeu-lhes: “Por outro lado é lamentável que/Por que é que RHQ vocês não obedeçam/obedecem ao que Deus mandou que as pessoas façam!/? Apenas para que vocês possam sustentar as tradições que receberam dos seus antepassados! ");
INSERT INTO portft_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Deus deu estes dois mandamentos: ‘Honrem seu pai e sua mãe’ e ‘As autoridades devem matar qualquer pessoa que fale mal do seu pai ou da sua mãe’. ");
INSERT INTO portft_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mas vocês dizem: ‘Se alguém disser a seu pai ou a sua mãe: ‘O que eu daria para o senhor para ajudá-lo, eu já prometi dar a Deus’, ");
INSERT INTO portft_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ele não deve dar esse sustento a seu pai e a sua mãe.’’ Dessa forma, vocês desrespeitam o que Deus mandou as pessoas fazerem, dizendo a elas para obedecerem o que os antepassados de vocês ensinaram. ");
INSERT INTO portft_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Vocês somente fingem serem bons! Isaías profetizou corretamente a respeito de vocês quando citou o que Deus disse dos antepassados de vocês. Deus disse: ");
INSERT INTO portft_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Estas pessoas falam como se me honrassem MTY, mas não pensam em me honrar nem um pouco MET. ");
INSERT INTO portft_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","É inútil eles me louvarem, pois ensinam o que originou-se com as pessoas, como se eu mesmo tivesse mandado’”. ");
INSERT INTO portft_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesus outra vez chamou a multidão para se aproximar mais dele. Então Ele disse a ela: “Escutem o que estou para dizer a vocês e procurem entender. ");
INSERT INTO portft_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nada que a pessoa coloca na boca e come faz com que Deus a considere inaceitável a Ele. Pelo contrário, são as palavras que saem da boca SYN da pessoa que fazem com que Deus a rejeite”. ");
INSERT INTO portft_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mais tarde nós, discípulos, fomos a Jesus e dissemos a Ele: “O senhor sabe que os fariseus ouviram o que o senhor disse e, como resultado, sentiram-se ofendidos RHQ?” ");
INSERT INTO portft_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Então para nos ensinar o que Deus faria aos fariseus, Jesus contou esta parábola para nós: “Meu Pai, no céu, destruirá todas as pessoas que ensinam coisas que são contrárias ao que Ele diz, da mesma forma que o agricultor destrói as plantas que ele não plantou, arrancando-as junto com as raízes delas. MET ");
INSERT INTO portft_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Não mexam com os fariseus. Eles não ajudam as pessoas que não conhecem a verdade de Deus a entendê-la, assim como os guias cegos não ajudam outros cegos a perceberem onde devem ir MET. Se um cego tenta guiar outro cego, os dois cairão em um buraco. MET Semelhantemente, os fariseus e os discípulos deles acabarão no inferno”. ");
INSERT INTO portft_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro disse-lhe: “Explique para nós a parábola sobre o que a pessoa come”. ");
INSERT INTO portft_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ele lhes disse: “Estou desapontado, porque/Por que é que RHQ até vocês que devem entender o que ensino, ainda não entendem!/? ");
INSERT INTO portft_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Vocês devem/Será que não podem RHQ entender que toda comida que as pessoas comem entra nas barrigas delas e mais tarde o que resta passa para a latrina./? Já que a comida não muda o que pensamos e desejamos, ela não faz com que Deus nos considere inaceitáveis a Ele. ");
INSERT INTO portft_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Saibam que o que sai das bocas das pessoas, ou seja, tudo quanto dizem, SYN origina-se nas mentes delas, e muitas dessas coisas que elas dizem fazem com que Deus as considere inaceitáveis a Ele. ");
INSERT INTO portft_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","É o ser interior das pessoas que as faz pensar coisas más, matar outras pessoas, cometer adultério, cometer outros pecados sexuais, roubar coisas, dar falso testemunho e maldizer outras pessoas. ");
INSERT INTO portft_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","São estas ações que fazem com que Deus considere as pessoas inaceitáveis a Ele. Comer com mãos não lavadas não faz com que Deus considere as pessoas inaceitáveis a Ele”. ");
INSERT INTO portft_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Depois que Jesus saiu conosco do distrito da Galileia, fomos à região onde ficam as cidades de Tiro e Sidom. ");
INSERT INTO portft_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Certa mulher do grupo de pessoas/povo chamado Cananeia que moram naquela região chegou ao lugar onde Jesus estava hospedado. Ela gritou para Ele: “Senhor, o senhor é descendente do Rei Davi, o senhor é o Messias! Tenha misericórdia de mim e de minha filha! Ela está sofrendo muito porque um demônio a domina”. ");
INSERT INTO portft_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mas Ele não disse nada a ela. Nós, discípulos, chegamos a Jesus e, sabendo que ela não era judia, dissemos a Ele: “Diga a ela que saia porque ela persiste em nos aborrecer gritando por trás de nós!” ");
INSERT INTO portft_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mas Jesus disse a ela: “Eu fui enviado {Deus me enviou} para ajudar somente os israelitas agora. SYN Eles são como ovelhas que se perderam, MET porque não conhecem o caminho para o céu”. ");
INSERT INTO portft_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mas ela chegou mais perto de Jesus e ajoelhou-se na frente dele para adorá-lo. Ela pediu com insistência: “Senhor, ajude–me!” ");
INSERT INTO portft_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Então para sugerir que Ele precisava ajudar os judeus primeiro, e não os não judeus que eles chamavam de cachorros, Ele disse a ela: “Não é bom alguém pegar a comida que a mãe preparou para as crianças e dar essa comida aos cachorrinhos”. ");
INSERT INTO portft_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mas para mostrar que ela cria que os não judeus também podiam receber ajuda de Deus, a mulher disse a Jesus: “Senhor, o que o senhor diz está certo. Mas até os cachorrinhos de casa comem as migalhas que caem no chão, quando os donos deles se sentam à mesa para comer!” ");
INSERT INTO portft_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Então Jesus disse a ela: “Ó mulher, porque você crê firmemente em mim, eu curarei a sua filha assim como você deseja!” Naquele momento o demônio deixou a filha dela e ela foi curada {ficou boa}. ");
INSERT INTO portft_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Depois de Jesus sair daquela área conosco, voltamos ao lago da Galileia e andamos ao lado dele. Então Ele subiu um monte perto dali e sentou-se para ensinar as pessoas. ");
INSERT INTO portft_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","As multidões levaram a Ele os coxos, aleijados, cegos, pessoas que não podiam falar e muitas outras pessoas que tinham uma variedade de doenças. Elas deitaram essas pessoas na frente de Jesus para que Ele as curasse. SYN Então Ele as curou. ");
INSERT INTO portft_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Porque a multidão viu-o fazer com que as pessoas que não podiam falar, falassem, curar os aleijados, fazer os coxos andarem, e os cegos enxergarem, ficou admirada. Todos disseram: “Louvado seja Deus que governa sobre nós que moramos em Israel!” ");
INSERT INTO portft_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Então Jesus chamou a nós, discípulos, que estávamos reunidos ali. Ele nos disse: “Esta multidão está comigo faz três dias e está me ouvindo. Eles não têm nada para comer, por isso tenho pena deles. Não quero mandá-los embora enquanto ainda estão com fome, porque se fizesse isso, eles poderiam desmaiar no caminho para casa”. ");
INSERT INTO portft_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nós, discípulos, dissemos a Ele: “Neste lugar onde não mora ninguém, não podemos de nenhuma maneira/como é que nós podemos RHQ conseguir bastante comida para alimentar uma multidão tão grande!/?” ");
INSERT INTO portft_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus perguntou para nós: “Quantos pães vocês têm?” Respondemos-lhe: “Temos sete pães e uns poucos peixes secos/cozidos”. ");
INSERT INTO portft_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ele disse às pessoas para se sentarem no chão. ");
INSERT INTO portft_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aí Ele pegou os sete pãezinhos e os peixes. Depois de agradecer a Deus por eles, Ele partiu os pães e os peixes em pedaços e, em seguida, deu-os a nós. Então distribuíamos os pedaços de pão e de peixe à multidão. ");
INSERT INTO portft_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Já que Jesus fez a comida aumentar milagrosamente, todas as pessoas comeram e tiveram o suficiente para comerem. Aqueles que comeram o que Jesus providenciou eram quatro mil homens, que alguém contou. Entretanto, ninguém contou as mulheres e crianças que também comeram com eles. Após isso, nós recolhemos os pedaços de comida que restavam e enchemos sete cestos grandes com eles. ");
INSERT INTO portft_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Depois que Jesus despediu-se da multidão, entrou no barco conosco. Então fomos de barco à área chamada Magadã. ");
INSERT INTO portft_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Alguns fariseus e saduceus foram a Jesus e pediram que Ele fizesse um milagre que provasse que Deus EUP o tinha enviado. ");
INSERT INTO portft_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ele lhes respondeu: “Neste país, quando é noite, vocês dizem: ‘Fará um tempo bonito amanhã, porque o céu está vermelho ‘. ");
INSERT INTO portft_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Cedo de manhã vocês dizem: ‘Será chuvoso hoje porque o céu está vermelho e as nuvens já se formaram ‘. Vocês entendem como discernir o tempo quando olham para o céu, mas não entendem o que Deus está fazendo agora. ");
INSERT INTO portft_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Vocês, malvados que me veem fazer milagres e que não adoram Deus, MET querem me ver fazer um milagre que prove que Deus me enviou. Mas Deus fará com que vejam somente um milagre. Será como o que aconteceu MET a Jonas, o profeta, que ficou dentro de um peixe enorme por três dias e depois saiu do peixe para viver de novo”. Então Jesus os deixou e saiu de barco conosco. ");
INSERT INTO portft_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Esquecemos de levar pão quando nós e Jesus saímos de barco para uma outra praia do lago da Galileia. ");
INSERT INTO portft_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Então Jesus nos disse: “Tenham cuidado de não aceitar o fermento MET que os fariseus e os saduceus distribuem”. ");
INSERT INTO portft_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Então, sem saber que Ele estava falando de modo figurativo, dissemos uns aos outros: “Deve ser que Ele disse isso porque nos esquecemos de trazer pão!” ");
INSERT INTO portft_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Porque Jesus sabia o que estávamos dizendo, Ele nos disse: “Estou desapontado que vocês/Por que é que vocês RHQ estão dizendo que foi porque não trouxeram pão que eu falei sobre o fermento dos fariseus e dos saduceus./? Vocês creem só um pouco no que eu posso fazer para vocês. ");
INSERT INTO portft_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Vocês devem entender/Vocês não entendem RHQ que posso fazer milagres para provar isso para vocês. Não se lembram que cinco mil pessoas comeram quando multipliquei apenas cinco pães e dois peixes? E depois de todos terem o suficiente para comerem, vocês recolheram doze cestos dos pedaços que sobraram! RHQ ");
INSERT INTO portft_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Não se lembram RHQ de que quatro mil pessoas comeram quando multipliquei apenas sete pães e uns poucos peixes? E depois que todos comeram o suficiente, vocês recolheram sete cestos grandes de pedaços que sobraram! ");
INSERT INTO portft_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Vocês deviam ter entendido/Por que vocês não entenderam RHQ que eu não estava falando do pão verdadeiro que contém fermento. Mas eu estava dizendo que vocês não devem aceitar o que os fariseus e saduceus lhes dizem que os afeta assim como o fermento MET afeta amassa em que se encontra”. ");
INSERT INTO portft_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Então entendemos que Ele não estava falando do fermento que se encontra no pão. Pelo contrário, Ele falava do ensinamento errado dos fariseus e dos saduceus. ");
INSERT INTO portft_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Quando Jesus foi conosco para a região perto da cidade de Cesareia de Filipe, Ele nos perguntou: “Quem é que as pessoas dizem que eu? Sou aquele que veio do céu?” ");
INSERT INTO portft_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Então lhe respondemos: “Alguns dizem que o senhor é João, o Batizador, que está vivo novamente. Outros dizem que o senhor é o profeta Elias, que voltou do céu como Deus prometeu. Outros dizem que o senhor é o profeta Jeremias ou um dos outros profetas que viveu há muito tempo atrás e que voltou a viver”. ");
INSERT INTO portft_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesus nos perguntou: “E vocês? Quem vocês dizem que eu sou?” ");
INSERT INTO portft_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simão Pedro lhe respondeu: “O senhor é o Messias, o Filho do Homem que também é Deus, aquele que é todo poderoso”. ");
INSERT INTO portft_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Então Jesus disse a ele: “Simão, filho de Jonas, Deus tem prazer em você. Não foram pessoas SYN que revelaram isto a você. Pelo contrário, foi meu Pai que vive no céu que revelou isto a você. ");
INSERT INTO portft_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Também eu digo-lhe o seguinte: você é Pedro, que significa pedra/rocha. Por causa do que você, que é como uma pedra, e os apóstolos que são seus colegas ensinam (OU, por causa do que você faz), eu reunirei grupos de pessoas que creem em mim. Os demônios PRS que vivem onde os mortos maus estão não poderão impedir MET isso. ");
INSERT INTO portft_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Eu farei com que vocês tenham autoridade sobre os grupos de pessoas cujas vidas Deus domina. O que vocês proibirem com relação as pessoas sobre quem Ele governa, já terá sido proibido por Deus MTY {Deus MTY já terá proibido}. O que vocês permitirem MET com relação ao grupo de pessoas sobre quem Deus domina, já terá sido permitido por Deus MTY {Deus MTY terá permitido}”. ");
INSERT INTO portft_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Então Jesus nos aconselhou firmemente que naquele momento não contássemos a ninguém que Ele era o Messias. ");
INSERT INTO portft_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Daquele tempo em diante Jesus começou a ensinar a nós, discípulos, que era necessário que Ele fosse à cidade de Jerusalém, que ali os anciãos líderes, os principais sacerdotes e os homens que ensinavam as leis judaicas iam fazê-lo sofrer e ser morto {morrer} e que no terceiro dia depois disso, {Deus faria} com que vivesse novamente. ");
INSERT INTO portft_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Já que Pedro pensava que o Messias não sofreria e morreria, ele levou Jesus à parte e começou a repreendê-lo por falar sobre sofrer e morrer. Ele disse: “Senhor, que Deus nunca permita que isso aconteça ao senhor! Certamente isso não deve acontecer!” ");
INSERT INTO portft_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Então Jesus virou, olhou para Pedro e disse-lhe: “Deixe de falar comigo assim MTY! Deixe de dizer o que Satanás MET diria! Deixe de tentar impedir o que Deus planejou! Você é um empecilho para mim, porque não está pensando aquilo que Deus pensa. Pelo contrário, você está pensando o que as pessoas pensam!” ");
INSERT INTO portft_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Então Jesus nos disse: “Se qualquer um de vocês quiser ser meu discípulo, não deve fazer somente o que deseja. Especificamente, devem estar dispostos a deixar que outras pessoas os machuquem e desgracem. É isso que fazem à pessoa quando fazem com que ela carregue uma cruz MET ao lugar onde vão pregá-la nessa cruz. É dessa forma que se tornam meus discípulos. ");
INSERT INTO portft_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Façam assim, porque aquele que tentar salvar sua própria vida negando que pertence a mim quando as pessoas querem matá-lo nunca viverá eternamente, mas aquele que os outros matarem por ser meu discípulo viverá com Deus eternamente. ");
INSERT INTO portft_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","As pessoas talvez consigam tudo quanto querem no mundo, mas na realidade não estariam ganhando nada/o que ganhariam RHQ se não se tornassem meus discípulos e desta forma não ganhassem a vida eterna!/? Não há absolutamente nada que uma pessoa possa/O que uma pessoa pode RHQ dar a Deus para ajudá-la a ganhar a vida eterna./? ");
INSERT INTO portft_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ouçam com cuidado: Eu que vim do céu para a terra deixarei esta terra, mas logo voltarei para a terra e os anjos me acompanharão. Naquela época eu serei radiante assim como Deus, meu Pai, é radiante. Naquela época recompensarei todos conforme o que cada um fez quando vivia na terra. ");
INSERT INTO portft_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Lembrem disto: antes que alguns que estão me ouvindo aqui hoje morram, verão a mim, aquele que veio do céu, quando eu voltar para dominar as vidas das pessoas”. ");
INSERT INTO portft_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis dias depois de Jesus dizer isso, Ele levou Pedro, Tiago e João, o irmão mais novo de Tiago, para um monte alto onde estavam separados das outras pessoas. ");
INSERT INTO portft_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Enquanto estavam ali, os discípulos viram que a aparência de Jesus foi transformada. Seu rosto brilhou como o sol e sua roupa ficou tão brilhante quanto a luz. ");
INSERT INTO portft_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","De repente Moisés e Elias, que eram profetas importantes há muitos anos antes, apareceram e começaram a falar com Ele. ");
INSERT INTO portft_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro os viu e disse a Jesus: “Senhor, é bom que nós (inc) estejamos aqui! Se o senhor desejar, farei três barracas temporárias em que os três possam ficar. Uma seria para o senhor, uma seria para Moisés e uma seria para Elias”. ");
INSERT INTO portft_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Enquanto ainda falava, uma nuvem brilhante cobriu todos eles. Então ouviram Deus falar sobre Jesus de dentro da nuvem. Ele disse-lhes: “Este é meu Filho. Eu o amo. Ele me agrada muito. Ouçam-no!” ");
INSERT INTO portft_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Porque esses discípulos ouviram Deus falar, ficaram com muito medo. Como resultado, caíram no chão e seus rostos tocaram no chão. ");
INSERT INTO portft_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Então Jesus foi a eles e os tocou para que não tivessem mais medo. Ele disse-lhes: “Fiquem em pé! Não tenham mais medo!” ");
INSERT INTO portft_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Então os discípulos olharam para cima MTY e viram que Jesus era o único que ainda estava ali. ");
INSERT INTO portft_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Quando desceram do monte, Jesus os mandou: “Não digam a ninguém o que viram em cima do monte até que eu, aquele que veio para a terra do céu, ressuscite outra vez depois de morrer {até que Deus tenha feito com que eu, que desci à terra do céu, torne a viver depois de morrer}”. ");
INSERT INTO portft_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Como os discípulos viram Elias e ele não fez nada para preparar as pessoas para a vinda do Messias, os três discípulos perguntaram a Jesus: “Já que isso é a verdade, por que é que os homens que ensinam as leis judaicas dizem que é necessário Elias voltar antes que o Messias venha?” ");
INSERT INTO portft_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus lhes respondeu, “É verdade que Deus prometeu enviar Elias para preparar o povo para a vinda do Messias. ");
INSERT INTO portft_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mas notem isto: o representante de Elias já veio e nossos líderes o viram, mas não o reconheceram como aquele que viria antes do Messias. Pelo contrário, eles o trataram mal assim como desejavam. Esses mesmos líderes logo me tratarão mal, eu, que desci à terra do céu, da mesma maneira”. ");
INSERT INTO portft_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Naquele momento esses discípulos entenderam que Ele se referia a João, o Batizador, quando estava falando de Elias. ");
INSERT INTO portft_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Quando Jesus e aqueles três discípulos voltaram a nós, outros discípulos, e à multidão que se reuniu ali, um homem aproximou-se de Jesus e se ajoelhou diante dele. ");
INSERT INTO portft_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","O homem disse a Ele: “Senhor, tenha misericórdia do meu filho! Cure-o, porque ele tem epilepsia e sofre muito. Por causa dessa doença, ele caiu no fogo ou na água muitas vezes. ");
INSERT INTO portft_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Eu o trouxe aos seus discípulos para que eles o curassem, mas não puderam curá-lo”. ");
INSERT INTO portft_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus respondeu dizendo a todos os que tinham se reunido ali: “Vocês que veem como eu ajudo as pessoas, e não creem que possam fazer nada! As mentes de vocês estão distorcidas. Quanto tempo tenho que ficar com vocês antes que possam fazer o que eu faço? RHQ Quanto tempo tenho que aguentar sua falta de fé? RHQ Traga-o aqui para mim!” ");
INSERT INTO portft_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Então levaram o rapaz a Jesus. Jesus repreendeu o demônio que estava causando a epilepsia do rapaz. Como consequência, o demônio saiu do rapaz, e ele ficou curado daquele momento em diante. ");
INSERT INTO portft_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mais tarde alguns de nós, discípulos, fomos a Jesus e perguntamos a Ele em particular: “Por que é que nós (excl) não pudemos expulsar o demônio?” ");
INSERT INTO portft_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ele nos respondeu: “É porque vocês não creram no poder de Deus. Guardem em mente o seguinte: as sementes de mostarda são muito pequenas, mas nesta região elas podem produzir uma planta bem grande MET. ");
INSERT INTO portft_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Semelhantemente, se vocês realmente cressem que Deus daria a vocês o que pedem em oração, vocês fariam qualquer coisa LIT! Vocês poderiam até dizer a este monte: ‘Saia daqui para lá!, e ele iria aonde vocês lhe dissessem para ir”. ");
INSERT INTO portft_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Quando nós, discípulos, tínhamos nos reunido na Galileia, Jesus nos disse: “Eu, aquele que vim do céu para a terra, daqui a pouco serei entregue {Alguns homens logo me entregarão} às autoridades. SYN ");
INSERT INTO portft_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","As autoridades me matarão. Mas Deus fará com que eu viva de novo no terceiro dia depois disso”. Porque Jesus disse isso, nós ficamos muito tristes. ");
INSERT INTO portft_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Quando chegamos à cidade de Cafarnaum, os homens que recolhiam os impostos do templo chegaram perto de Pedro e perguntaram: “O mestre paga o imposto do templo, não paga?” ");
INSERT INTO portft_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ele respondeu a eles: “Paga, sim”. Quando entramos na casa dele, antes de Pedro começar a falar sobre pagar o imposto, Jesus disse-lhe: “Simão, de quem você acha que os governantes recolhem dinheiro ou impostos? Recolhem impostos dos cidadãos do seu país ou dos cidadãos dos países que conquistaram?” ");
INSERT INTO portft_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro respondeu-lhe: “Dos cidadãos de outros países”. Logo Jesus disse-lhe: “Então os cidadãos do próprio país não precisam pagar impostos. ");
INSERT INTO portft_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Porém, mesmo que o templo seja meu, pague o imposto para nós para que nós (inc) não ofendamos os cobradores do imposto. Portanto, para conseguir o dinheiro para pagar o imposto, vá ao lago. Jogue sua corda com o anzol e tire o primeiro peixe que pegar. Quando você abrir a boca dele, encontrará uma moeda de prata de bastante valor para pagar a sua taxa e a minha. Leve essa moeda e dê a eles”. ");
INSERT INTO portft_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Por aquele tempo nós, discípulos, chegamos perto de Jesus e dissemos: “Então quem entre nós será o mais importante quando Deus fizer com que o senhor seja rei?” ");
INSERT INTO portft_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Então Jesus chamou uma criança para se aproximar dele e colocou a criança no nosso meio. ");
INSERT INTO portft_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ele disse: “Tenham isso em mente: se vocês não mudarem a sua maneira de pensar e não se tornarem humildes assim como são as crianças pequenas, vocês certamente não chegarão a fazer parte do grupo de pessoas que Deus domina. ");
INSERT INTO portft_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Portanto, aqueles que se tornarem humildes assim como esta ou qualquer outra criança é humilde, serão os mais importantes entre aqueles sobre quem Deus governa. ");
INSERT INTO portft_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Também, quando alguém recebe apenas uma destas crianças porque essa criança crê em mim, Deus considera que essa pessoa está me recebendo”. ");
INSERT INTO portft_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Se alguém fizer pecar uma pessoa que crê em mim, Deus vai castigá-lo severamente, mesmo que essa pessoa não seja socialmente importante, assim como esta criança pequena. Se alguém prendesse uma pedra pesada no pescoço dessa pessoa e a jogasse no mar, vocês considerariam que isso fosse um castigo severo por aquilo que ela fez. Mas Deus castigará essa pessoa ainda mais severamente se ela fizer outra pessoa pecar. ");
INSERT INTO portft_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Será horrível para qualquer um que fizer com que outras pessoas deixem de crer em mim, porque Deus vai castigá-lo eternamente. É inevitável que haja pessoas que façam com que outras pessoas deixem de crer em mim. Mas será horrível para cada pessoa que fizer com que outra pessoa deixe de crer em mim. ");
INSERT INTO portft_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Se você quiser usar uma das suas mãos ou um dos seus pés para pecar, deixe de usar essa mão ou esse pé! Mesmo que tenha que tirar essa mão ou esse pé do corpo cortando-o para não pecar, faça isso. MET É bom você não pecar e ir aonde você viverá com Deus para sempre, mesmo que esteja aleijado ou coxo e não tenha uma mão ou um pé enquanto ainda estiver aqui na terra. Mas não é bom você continuar com as duas mãos ou os dois pés, fazer MTY o que deseja de modo errado fazer e, como resultado, ser colocado {Deus colocar você} no inferno onde haverá fogo eterno. ");
INSERT INTO portft_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Se quiser usar um dos olhos para pecar, deixe de usar esse olho! Mesmo que tenha que cortar esse olho e jogá-lo fora para não pecar, faça isso HYP! É bom você não pecar e ir para onde viverá com Deus eternamente, mesmo que tenha somente um olho enquanto ainda estiver aqui na terra. Mas não é bom você continuar a ter os dois olhos, fazer MTY o que deseja erradamente fazer e, como resultado, ser colocado no {ir para o} inferno onde há fogo eterno. ");
INSERT INTO portft_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Façam um esforço para não desprezarem nem uma destas crianças. ");
INSERT INTO portft_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Digo a vocês verdadeiramente que já que os anjos que vivem no céu onde Deus está os veem, eles dirão a Deus se vocês as maltratarem. * ");
INSERT INTO portft_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","O que vocês acham que uma pessoa faria na seguinte situação? Se uma pessoa tivesse cem ovelhas e se uma delas ficasse perdida, certamente essa pessoa não/essa pessoa não RHQ deixaria as noventa e nove ovelhas que estão no monte e procuraria a perdida./? ");
INSERT INTO portft_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Se a achasse, afirmo a vocês que essa pessoa ficaria muito alegre. Ela ficaria alegre que noventa e nove ovelhas não se perderam, mas estaria ainda mais alegre por ter achado a ovelha que tinha se perdido. ");
INSERT INTO portft_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Assim como o pastor não quer que nenhuma das ovelhas se perca, também Deus, seu Pai que está no céu, não quer que nenhuma destas crianças pereça eternamente/vá para o inferno”. ");
INSERT INTO portft_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Se um irmão crente pecar contra você, vá a ele e quando você e ele estiverem sós, repreenda-o por pecar contra você. Se ele ouvir você e sentir tristeza por ter pecado contra você, você o terá restaurado aos membros do grupo daqueles que louvam a Deus. ");
INSERT INTO portft_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Se ele não ouvir você e nem sentir tristeza por ter pecado contra você, busque uma ou duas outras pessoas que creem em mim e que sabem o que ele fez. Vá com essas pessoas àquele que pecou contra você para que o que Deus requer e o que está nas Escrituras possa acontecer. Alguém escreveu o seguinte: ‘Quando uma pessoa acusar outra pessoa em algum assunto, deve ser confirmado por pelo menos duas ou três pessoas {pelo menos duas ou três pessoas devem confirmar} que a acusação é verdadeira, antes que a pessoa seja declarada {antes que declarem a pessoa} culpada. ");
INSERT INTO portft_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Se a pessoa em questão não os ouvir e nem sentir tristeza por ter pecado contra você, diga isso ao grupo de crentes para que eles o repreendam. Se esse irmão não ouvir o grupo de crentes e se não sentir tristeza por ter pecado contra você, não o deixe ser membro do seu grupo de crentes assim como excluiria os não judeus, os cobradores de impostos ou outras pessoas que não creem em Deus e que pecam muito. ");
INSERT INTO portft_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tenham em mente isto: o que vocês decidirem na terra sobre castigar ou não castigar um membro da congregação é o que também terá sido decidido por Deus no céu {o que Deus no céu já terá decidido}. ");
INSERT INTO portft_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Notem isto também: se pelo menos dois de vocês que vivem na terra concordarem juntos naquilo que pedirem a Deus, DOU Deus, meu Pai que está no céu, dará o que vocês pedirem. ");
INSERT INTO portft_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Isso 18.19 é a verdade porque onde pelo menos dois ou três de vocês se reunirem porque creem em mim, eu estou presente espiritualmente com vocês. Eu ouvirei o que pedirem e pedirei a Deus para dar aquilo para vocês”. ");
INSERT INTO portft_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Então Pedro chegou perto de Jesus e perguntou-lhe: “Quantas vezes eu devo perdoar um irmão crente que continua a pecar contra mim? Se ele persiste em pedir que eu o perdoe, devo perdoá-lo até sete vezes?” ");
INSERT INTO portft_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus respondeu-lhe: “Digo-lhe que o número das vezes que você deve perdoar alguém não é só sete, mas você precisa perdoá-lo — 77 vezes/sempre. ");
INSERT INTO portft_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Já que você precisa agir assim, para ilustrar isso eu contarei a você uma história na qual Deus, que se preocupa com as pessoas cujas vidas Ele governa, é comparado {comparo Deus, que se preocupa com as pessoas cujas vidas Ele domina,} com um rei e os oficiais dele. ");
INSERT INTO portft_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aquele rei disse a alguns dos servos dele que queria que seus oficiais pagassem o que deviam a ele. Por isso, esses oficiais foram levados a ele {aqueles servos levaram a ele os oficiais} para que estes pudessem acertar as contas. Enquanto os oficiais eram levados {Enquanto os servos levavam os oficiais} para o rei, houve um oficial {eles levaram um oficial} que devia milhões de dólares. ");
INSERT INTO portft_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mas já que não tinha o dinheiro para pagar ao rei o que ele devia, o rei mandou que ele, a esposa dele, os filhos dele e tudo quanto ele possuía fosse vendido {que os servos dele (do rei) o vendessem, bem como sua esposa, seus filhos e tudo quanto possuía} a outra pessoa, e que o rei fosse pago com {recebesse} o dinheiro que pagaram pelo homem, sua família e seus bens. ");
INSERT INTO portft_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Então esse oficial, sabendo que não podia repagar toda essa tremenda/imensa dívida, caiu de joelhos e implorou ao rei, dizendo: ‘Seja paciente comigo, eu pagarei tudo ao senhor mais tarde.’ ");
INSERT INTO portft_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","O rei, sabendo que esse oficial nunca poderia pagar toda essa dívida enorme, teve pena dele. Por isso ele cancelou a dívida que esse homem devia-lhe. ");
INSERT INTO portft_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Então esse oficial foi a outro oficial do rei que devia a ele quase o salário de um ano/centenas de dólares. Ele agarrou o homem pela garganta, começou a sufocá-lo e disse-lhe: ‘Pague-me o que me deve!’ ");
INSERT INTO portft_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Esse oficial caiu de joelhos e implorou-lhe, dizendo: ‘Tenha paciência comigo e eu pagarei a você todo o dinheiro mais tarde.’ ");
INSERT INTO portft_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mas este oficial não quis cancelar essa dívida pequena que o homem devia a ele. Pelo contrário, fez com que esse oficial fosse colocado na prisão e ficasse ali até que pudesse pagar todo o dinheiro que lhe devia. ");
INSERT INTO portft_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Depois que outros oficiais do rei souberam que isso tinha acontecido, sentiram-se muito frustrados/angustiados. Por isso foram ao rei e relataram em detalhe tudo que tinha acontecido. ");
INSERT INTO portft_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Então o rei convocou aquele oficial que tinha devido a ele milhões de dólares para ir até ele e disse-lhe: ‘Servo mau! Eu cancelei toda aquela dívida enorme que você me devia porque você pediu que eu fizesse isso! ");
INSERT INTO portft_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Você devia ter mostrado misericórdia e cancelado a dívida que esse homem devia a você, assim como eu mostrei misericórdia a você e cancelei a dívida que você me devia!’ RHQ ");
INSERT INTO portft_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Então o rei ficou furioso e entregou este oficial a alguns guardas que iam torturá-lo severamente até que ele pagasse toda a dívida que devia”. ");
INSERT INTO portft_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Então Jesus continuou, dizendo: “É assim que meu Pai no céu fará a você, se você não tiver misericórdia e perdoar um irmão crente que peca contra você”. ");
INSERT INTO portft_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Depois que Jesus disse isso, ele saiu do distrito da Galileia junto conosco e foi à região do distrito da Judeia que fica no lado leste do rio Jordão. ");
INSERT INTO portft_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Grandes multidões o seguiram, e Ele curou os doentes entre essas multidões. ");
INSERT INTO portft_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Então alguns fariseus chegaram perto dele e perguntaram-lhe: “A nossa lei judaica permite que um homem se divorcie da sua esposa por qualquer razão?” Perguntaram isso para criticá-lo se ele respondesse “sim” ou “não”. ");
INSERT INTO portft_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus respondeu-lhes: “Como vocês já leram as Escrituras, vocês devem saber que Moisés escreveu que quando Deus no início criou as pessoas, ele fez um homem e uma mulher para ser esposa daquele homem. ");
INSERT INTO portft_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Já que Deus os fez assim, Ele também disse: ‘Quando um homem e uma mulher se casam, não devem viver mais com seus pais e suas mães. Pelo contrário, devem viver juntos e se tornarão muito unidos como se fossem uma só pessoa.’ MET ");
INSERT INTO portft_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Por consequência, embora antes funcionassem como duas pessoas separadas, chegam a ser como uma só pessoa.MET Sendo esta a verdade, nenhum homem deve separar-se da esposa dele que Deus uniu a ele, porque Deus deseja que permaneçam juntos”. ");
INSERT INTO portft_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Então os fariseus perguntaram-lhe: “Se isso é verdade, por que Moisés mandou que um homem que quisesse divorciar-se de sua esposa desse a ela um papel afirmando a razão dele divorciar-se dela e a mandasse embora?” ");
INSERT INTO portft_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ele respondeu-lhes: “Foi porque esses homens rebeldes queriam os próprios caminhos deles que Moisés deixou os homens se divorciarem de suas esposas, e vocês não são diferentes. Em contraste, quando Deus primeiro criou um homem e uma mulher, Ele não quis que se separassem. ");
INSERT INTO portft_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Estou lhes dizendo enfaticamente que já que Deus considera que o casamento dura até o esposo ou a esposa morrer, Ele também considera que qualquer marido que se divorcie de sua mulher não adúltera/que não cometeu adultério e depois se case com outra mulher está cometendo adultério”. ");
INSERT INTO portft_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nós, discípulos, dissemos-lhe: “Se é assim que os homens devem agir com as mulheres, é melhor que os homens nunca se casem!” ");
INSERT INTO portft_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Então Ele nos disse: “Nem todos os homens podem aceitar este ensinamento, somente aqueles que são ajudados {que Deus ajuda} a aceitá-lo são capazes de agir assim. ");
INSERT INTO portft_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Há homens que não são casados porque não podem ter relações sexuais por serem defeituosos sexualmente desde que nasceram. Há outros homens que não são casados porque não podem ter relações sexuais pois foram feitos assim por outros homens {pois outros homens os fizeram assim}. Há outros homens que não se casam MET para que possam dizer mais facilmente aos outros como é que Deus quer dominar/governar as vidas das pessoas. Vocês que podem entender o que eu acabo de dizer sobre o casamento devem aceitar e obedecer isso”. ");
INSERT INTO portft_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Então algumas crianças foram levadas {algumas pessoas levaram suas crianças} a Jesus para que Ele pudesse impor as mãos nelas e orar por elas. Mas nós, discípulos, repreendemos essas pessoas por levarem suas crianças a Jesus, porque pensamos que Jesus não se preocupava com elas. ");
INSERT INTO portft_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Reagindo de forma negativa a isso, quando Jesus nos viu repreendê-las, ele nos disse: “Deixem as criancinhas virem a mim e não as impeçam! Pois aqueles que são humildes e que confiam como elas, experimentam o cuidado de Deus nas suas vidas”. ");
INSERT INTO portft_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesus impôs as mãos sobre essas crianças e pediu que Deus as abençoasse. Depois Ele saiu desse lugar. ");
INSERT INTO portft_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Enquanto Jesus caminhava, um homem jovem chegou perto dele e perguntou-lhe: “Mestre, quais as boas ações que eu devo fazer para poder viver com Deus eternamente?” ");
INSERT INTO portft_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus respondeu-lhe: “– Considere/você sabe – RHQ o que você está implicando sobre quem eu sou, quando me pergunta a respeito daquilo que é bom./? Somente um ser é bom e sabe sobre o bom. Esse ser é Deus. Mas para responder à sua pergunta sobre desejar viver com Deus eternamente, eu direi a você: guarde os mandamentos que Deus deu a Moisés”. ");
INSERT INTO portft_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Então o homem perguntou a Jesus: “Quais mandamentos eu devo guardar?” Jesus lhe respondeu: “Não mate ninguém, não cometa adultério, não roube, não dê falso testemunho, ");
INSERT INTO portft_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","honre seu pai e sua mãe e ame as pessoas com quem tem contato tanto quanto ama a si mesmo”. ");
INSERT INTO portft_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sabendo que ele não podia viver com Deus eternamente mesmo que guardasse esses mandamentos, o jovem disse a Jesus: “Sempre obedeço a todos esses mandamentos. O que mais eu devo fazer para viver com Deus eternamente?” ");
INSERT INTO portft_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Então Jesus disse-lhe: “Se quiser ser tudo quanto Deus quer que você seja, vá para casa, venda o que possui e dê o dinheiro aos pobres. O resultado será que você será rico espiritualmente no céu. Depois venha e seja meu discípulo!” ");
INSERT INTO portft_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Quando o jovem ouviu isso, foi embora sentindo-se muito triste, porque ele era muito rico e não queria dar tudo para outros. ");
INSERT INTO portft_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Então Jesus disse para nós, discípulos: “Guardem em mente o seguinte: é muito difícil os ricos decidirem deixar que Deus domine as vidas deles. ");
INSERT INTO portft_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Notem isto: É impossível que um camelo passe pelo fundo de uma agulha. É quase tão difícil HYP uma pessoa rica decidir deixar que Deus domine sua vida”. ");
INSERT INTO portft_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Quando nós, discípulos, ouvimos isso, ficamos grandemente admirados, pois pensávamos que eram os ricos que Deus abençoava. Então dissemos-lhe: “Se for assim, parece improvável que qualquer um possa ser salvo/quem pode ser salvo {quem é que Deus salvará}!/?” ");
INSERT INTO portft_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Quando Jesus nos ouviu dizer isso, Ele olhou intensamente para nós e nos disse: “Sim, é impossível que as pessoas se salvem. Mas Deus pode salvá-las, porque Deus pode fazer tudo!” ");
INSERT INTO portft_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Então Pedro disse-lhe: “Nós (excl) deixamos tudo e tornamo-nos discípulos do senhor. Portanto, que benefício Deus nos dará por fazer isso?” ");
INSERT INTO portft_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus responde-lhe: “Guardem isto na mente: Deus dará a vocês muitos benefícios. Quando Deus fizer a nova terra e quando eu, que desci para a terra, sentar-me no meu trono magnífico, aqueles entre vocês que me acompanharam sentarão em doze tronos e julgarão as pessoas das doze tribos de Israel. ");
INSERT INTO portft_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Também a cada pessoa que deixar casa ou terra, irmãos, irmãs, pai, mãe, filhos ou qualquer outro membro de família por ser meu discípulo, Deus dará cem vezes mais benefícios do que essa pessoa desistiu e ela viverá com Deus eternamente. ");
INSERT INTO portft_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mas muitas pessoas que se consideram importantes agora não serão importantes naquele tempo futuro, e muitas pessoas que se consideram de pouca importância agora, serão importantes naquele tempo futuro”. ");
INSERT INTO portft_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Para ilustrar como é que Deus recompensa as pessoas, compararei Deus que domina seu povo com o dono de terras. Cedo de manhã esse homem foi até onde os trabalhadores se reuniam no mercado, para que pudesse empregar trabalhadores para trabalhar na sua plantação de uvas. ");
INSERT INTO portft_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ele prometeu a cada homem que daria a ele o salário de costume se ele trabalhasse um dia. Então ele os mandou para suas plantações. ");
INSERT INTO portft_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ele voltou ao mercado às nove horas daquela mesma manhã. Lá ele viu mais homens que não estavam trabalhando. ");
INSERT INTO portft_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ele disse a esses homens: “Vão à minha plantação, assim como outros homens foram, e trabalhem lá. Eu pagarei a vocês o que for um salário justo. ");
INSERT INTO portft_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Então esses homens foram à plantação dele e começaram a trabalhar. Ele foi novamente ao mercado às doze horas e às três horas e prometeu pagar a outros trabalhadores esse salário de costume se fossem trabalhar um dia. ");
INSERT INTO portft_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ele foi ao mercado outra vez às cinco horas. Viu outros homens de pé ali que não estavam trabalhando. Então perguntou-lhes: “Por que vocês estão em pé aqui o dia todo sem trabalhar?” ");
INSERT INTO portft_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Eles responderam-lhe: “Não estamos trabalhando porque ninguém nos empregou.” Ele disse-lhes: “Vão à minha plantação de uvas, assim como outros homens fizeram, e trabalhem lá. Então aqueles homens fizeram isso. ");
INSERT INTO portft_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Quando chegou a tardinha, o dono daquela plantação disse ao seu administrador: “Diga aos homens para virem. Depois dê a eles os seus salários. Pague primeiro aos homens que começaram a trabalhar por último e depois pague aos homens que começaram a trabalhar primeiro”. ");
INSERT INTO portft_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","O administrador pagou a cada um dos homens que começou a trabalhar às cinco horas o salário de costume. ");
INSERT INTO portft_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Quando os homens que começaram a trabalhar antes dos outros começarem foram pegar seus salários, eles pensaram que receberiam mais do que o salário de costume. Mas eles também receberam somente o salário de costume. ");
INSERT INTO portft_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Quando eles receberam seu salário, reclamaram ao dono da plantação porque consideraram que o salário era injusto. ");
INSERT INTO portft_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Disseram-lhe: “Isso não é justo! Porque os homens que começaram a trabalhar depois de nós termos começado só trabalharam por uma hora! Mas o senhor pagou a eles o mesmo salário que deu a nós! No entanto, nós trabalhamos duro o dia todo, IDM inclusive quando estava muito quente!” ");
INSERT INTO portft_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","O dono da plantação disse a um daqueles que reclamou: “Amigo, não tratei você de maneira injusta. Você concordou em trabalhar o dia todo pelo salário de costume. RHQ ");
INSERT INTO portft_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Deixe de reclamar para mim! Pegue seu salário e vá! Quero dar o mesmo salário que dei a você aos homens que começaram a trabalhar depois que todos vocês tinham começado. ");
INSERT INTO portft_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tenho com certeza o direito de gastar meu dinheiro conforme eu desejo RHQ, inclusive o direito de pagar a esses trabalhadores o que desejo pagar a eles. –Você não deve ficar frustrado/você está frustrado– MET, RHQ porque sou generoso!/?” ");
INSERT INTO portft_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Então Jesus nos disse: “Da mesma maneira, não busquem galardões de Deus, porque Deus com justiça recompensará bem certas pessoas que parecem menos importantes, mas não recompensará certas outras pessoas que parecem mais importantes agora”. ");
INSERT INTO portft_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Quando Jesus e nós doze discípulos estávamos caminhando na estrada para Jerusalém, Jesus nos guiou a um lugar à parte para que pudesse falar conosco em particular. Então ele nos disse: ");
INSERT INTO portft_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ouçam com cuidado! Agora estamos subindo para Jerusalém. Lá eu, aquele que desceu do céu, serei entregue nas mãos {alguém me entregará, aquele que desceu do céu, nas mãos} dos sacerdotes que governam e dos homens que ensinam a lei judaica, para que eles me julguem. Esses judeus me condenarão e dirão que as autoridades devem me matar. ");
INSERT INTO portft_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Então eles vão colocar–me nas mãos daqueles que não são judeus, para que possam zombar de mim, bater em mim e matar–me, pregando–me em uma cruz. Mas no terceiro dia depois disso, eu serei {Deus fará com que eu seja} ressuscitado/viva novamente”. ");
INSERT INTO portft_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Então a mãe de Tiago e João levou-os a Jesus. Ela se ajoelhou/curvou diante de Jesus e pediu que Ele fizesse algo para ela. ");
INSERT INTO portft_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesus perguntou-lhe: “O que é que você quer?” Ela respondeu-lhe: “Permita que estes dois filhos meus se sentem – perto do senhor/no lado direito do senhor e no lado esquerdo do senhor – e que governem com o senhor quando o senhor se tornar rei”. IDM ");
INSERT INTO portft_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus respondeu a ela e aos seus filhos: “Vocês não entendem o significado do que estão pedindo. Vocês podem sofrer assim como eu sofrerei?” Tiago e João lhe responderam: “Sim, podemos fazer isso”. ");
INSERT INTO portft_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Então Jesus disse-lhes: “Sim, vocês sofrerão assim como eu sofrerei. IDM Mas não sou eu que escolho aqueles que se sentarão perto de mim e que governarão comigo. Deus, meu Pai, é quem escolhe aqueles que se sentarão nesses lugares. MTY ");
INSERT INTO portft_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Quando nós, os outros dez discípulos, ouvimos disso, ficamos zangados com Tiago e João, porque nós também queríamos governar com Jesus nas posições mais altas. ");
INSERT INTO portft_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Por causa disso, Jesus chamou a todos nós e nos disse: “Vocês sabem que aqueles que governam sobre os não judeus gostam de mostrar que são poderosos. Os chefes principais que governam aqueles que não são judeus gostam de mandar nos outros. ");
INSERT INTO portft_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Vocês não devem ser como eles. Pelo contrário, aquele entre vocês que quer que Deus o considere grande, deve agir como servo a vocês outros. ");
INSERT INTO portft_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","E aquele entre vocês que quer que Deus o considere importante, deve agir como escravo de vocês outros. ");
INSERT INTO portft_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Vocês devem me imitar. Mesmo eu sendo aquele que veio do céu, eu não vim para ser servido {para que os outros me servissem}. Pelo contrário, vim para servir os outros e para morrer, IDM para que minha morte pelas pessoas fosse como pagamento para resgatar muitas pessoas de serem castigadas pelos pecados delas”. MTY ");
INSERT INTO portft_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Enquanto estávamos saindo da cidade de Jericó, uma grande multidão de pessoas nos seguiu. ");
INSERT INTO portft_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Enquanto caminhávamos vimos que havia dois homens cegos sentados ao lado da estrada. Quando ouviram que Jesus estava chegando perto deles, gritaram para Ele: “Senhor, Descendente do rei Davi, o senhor é o Messias! Tenha pena de nós e cure-nos!” ");
INSERT INTO portft_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Porque estavam gritando, as pessoas na multidão os repreenderam, dizendo que deviam calar-se. Mas os cegos gritaram ainda mais para Jesus: “Senhor, Descendente do Rei Davi, o senhor é o Messias! Tenha pena de nós e cure-nos!” ");
INSERT INTO portft_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Então Jesus parou perto deles e os chamou para irem a Ele. Depois Eles perguntou-lhes: “O que querem que eu faça para vocês?” ");
INSERT INTO portft_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Disseram-lhe: “Senhor, queremos que nossos olhos sejam curados {Queremos que o senhor cure nossos olhos}!” IDM ");
INSERT INTO portft_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Porque Jesus estava com pena deles, Ele tocou nos seus olhos e os curou. Logo eles começaram a ver e andaram com Ele. ");
INSERT INTO portft_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Quando nós chegamos perto da cidade de Jerusalém, nós chegamos próximo ao povoado de Betfagé, perto do monte das oliveiras. Jesus mandou dois dos seus discípulos na sua frente para um povoado perto ");
INSERT INTO portft_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","dizendo a eles o seguinte: “Entrem no povoado na sua frente. Quando entrarem, vocês verão uma jumenta e seu jumentinho que estão amarrados. Desamarrem e tragam-nos para cá para mim. ");
INSERT INTO portft_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Se alguém disser qualquer coisa a respeito de vocês fazerem isso, digam que o mestre de vocês precisa deles. Ele vai deixará que vocês os levem embora imediatamente”. ");
INSERT INTO portft_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Isto aconteceu para que o que foi escrito por um profeta {o que um profeta escreveu} fosse cumprido {acontecesse}. Esse profeta escreveu:, ");
INSERT INTO portft_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Diga às pessoas que moram na cidade de Jerusalém: SYN “Olhem, seu rei está chegando para vocês! Ele virá humildemente. Ele mostrará que é humilde andando montado em um jumentinho, filho de uma jumenta.’” ");
INSERT INTO portft_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Então os dois discípulos foram e fizeram o que Jesus lhes disse para fazer. ");
INSERT INTO portft_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Levaram a jumenta e seu jumentinho para Jesus. Colocaram suas capas neles/nos animais para formar algo para Ele se sentar. Então Jesus montou no jumentinho e sentou-se em cima das capas/roupas. ");
INSERT INTO portft_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Então uma grande multidão colocou suas capas na estrada, e outras pessoas cortaram ramos de palmeiras e os espalharam no caminho. Fizeram essas coisas para enfeitar a estrada para honrar Jesus. ");
INSERT INTO portft_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","As multidões que andaram na frente dele e atrás dele gritaram: “Louvado seja o Messias, o descendente do Rei Davi! Que Deus abençoe este que vem como representante de Deus/com a autoridade de Deus MTY. Louvado seja Deus, que está no céu altíssimo!” ");
INSERT INTO portft_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Enquanto Jesus entrou em Jerusalém, muitas pessoas de todas as partes da cidade ficaram agitadas e diziam: “Por que é que estão honrando este homem assim?” ");
INSERT INTO portft_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","A multidão que já estava seguindo Jesus disse: “Este é Jesus, o profeta de Nazaré na Galileia!” ");
INSERT INTO portft_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Então Jesus entrou no pátio do Templo e jogou expulsou dali todos os homens que estavam comprando e vendendo coisas. Ele virou as mesas dos homens que cambiavam as moedas romanas pelo dinheiro do imposto do templo e as cadeiras dos homens que vendiam pombas para (serem usadas como) ofertas. ");
INSERT INTO portft_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Então ele lhes disse: “Está escrito {—– Jeremias/Um profeta— escreveu} nas Escrituras o que Deus disse: ‘Quero que meu templo seja chamado de um lugar onde as pessoas oram ‘. Mas vocês o transformaram em um lugar onde bandidos podem esconder-se!” MET ");
INSERT INTO portft_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Depois disso, muitos cegos e coxos foram a Jesus no templo para que Ele os curasse, e Ele os curou. ");
INSERT INTO portft_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Quando os sumo sacerdotes e os homens que ensinavam as leis judaicas às pessoas viram as coisas maravilhosas que Jesus fazia e viram e ouviram as crianças gritando no templo: “Louvamos o Messias, o descendente do Rei Davi,” ficaram indignados, porque não criam que Jesus fosse o Messias. ");
INSERT INTO portft_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Como resultado, pensando que Jesus devia rejeitar isso, perguntaram-lhe: “Como é que o senhor tolera RHQ o que estas crianças estão gritando?” Então Jesus respondeu-lhes: “Se vocês recordassem o que está nas Escrituras sobre as crianças me louvarem, saberiam que Deus tem prazer nisso RHQ. O salmista escreveu,. falando para Deus: ‘O senhor ensinou os infantes e outras crianças a louvarem o senhor perfeitamente.’”. ");
INSERT INTO portft_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Então Jesus os deixou. Nós, discípulos, fomos com Ele ao povoado de Betânia e dormimos ali. ");
INSERT INTO portft_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cedo na manhã seguinte, quando estávamos voltando à cidade, Jesus ficou com fome. ");
INSERT INTO portft_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ele viu a figueira perto da estrada. Então chegou perto dela para pegar os figos e comê-los. Mas quando chegou perto, viu que não havia figos na figueira. Só havia folhas. Mas para ilustrar como Deus castigaria a nação de Israel, ele disse à figueira: “Que você nunca mais produza figos!” Como resultado, a figueira secou naquela mesma noite. ");
INSERT INTO portft_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","No dia seguinte quando nós, discípulos, vimos o que aconteceu com aquela árvore, ficamos admirados e dissemos a Jesus: “ -É maravilhoso/como é RHQ que a figueira secou tão rápido!/?” ");
INSERT INTO portft_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus nos disse: “guardem Tenham em mente isto: Se vocês crerem que Deus tem o poder para fazer o que pedirem a Ele e se não duvidarem, vocês poderão fazer o que eu fiz à figueira. Além disso, vão poder/poderão fazer coisas maravilhosas, tais como dizer ao monte que fica perto: ‘Seja arrancado e jogado {Arranque–-se e jogue–-se} no mar” e isso acontecerá! ");
INSERT INTO portft_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","E mais, quando pedirem algo a Deus ao orarem a ele, se crerem que Ele dará isso a vocês, Deus dará para vocês. ");
INSERT INTO portft_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Depois disso, Jesus entrou no pátio do templo. Enquanto estava ensinando as pessoas, os chefes dos sacerdotes e os anciãos do Concílio dos judeus chegaram perto dele e perguntaram: “Com que autoridade o senhor está fazendo estas coisas? Quem o autorizou para fazer o que fez aqui ontem?” DOU ");
INSERT INTO portft_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus respondeu-lhes: “Eu também farei uma pergunta a vocês. Se me responderem, eu direi a vocês quem me autorizou para fazer estas coisas. ");
INSERT INTO portft_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Foi Deus ou foram pessoas que deram a João, o Batizador, a autoridade de batizar as pessoas?” Os chefes dos sacerdotes e os anciãos discutiram entre si como deviam responder. Disseram uns aos outros: “Se dissermos: ‘Foi Deus quem o autorizou’, ele dirá para nós: ‘Então vocês deviam crer/por que vocês não creram– RHQ na mensagem dele./?’ ");
INSERT INTO portft_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Se dissermos: ‘Foram pessoas que o autorizaram’, temos medo que a multidão reaja com violência, porque o povo todo crê que João, o Batizador, foi um profeta que Deus mandou”. ");
INSERT INTO portft_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Por isso esses homens responderam a Jesus: “Não sabemos quem deu autoridade a João para batizar”. Então Ele disse-lhes: “Já que vocês não responderam o que eu perguntei, não vou dizer–-lhes quem me autorizou a fazer o que fiz aqui ontem”. ");
INSERT INTO portft_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Então Jesus disse aos chefes dos sacerdotes e anciãos: “Digam–-me RHQ o que pensam sobre o que eu direi a vocês. Havia um homem que tinha dois filhos. Foi ao filho mais velho e disse: ‘Meu filho, vá trabalhar na minha plantação de uvas hoje!’ ");
INSERT INTO portft_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","O filho disse ao pai: ‘Não quero ir trabalhar na plantação hoje!’ Porém, mais tarde ele mudou de ideia e foi trabalhar na plantação de uvas. ");
INSERT INTO portft_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Então o homem foi ao filho mais jovem e disse a ele o que tinha dito ao filho mais velho. Esse filho disse: “Senhor, eu trabalharei na plantação de uvas hoje.’ Mas ele não foi. ");
INSERT INTO portft_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Então qual dos dois filhos desse pai fez o que o pai queria?” Os homens responderam: “O irmão mais velho fez o que o pai queria”. Jesus explicou para eles o significado da parábola, dizendo: “Guardem isto na mente: outras pessoas, inclusive os cobradores de impostos e as prostitutas que vocês acham tão ruins, entrarão onde Deus governa sobre as pessoas, antes que vocês líderes judaicos entrem. ");
INSERT INTO portft_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Digo isto para vocês porque embora João, o Batizador, tenha explicado a vocês como viver de maneira justa, vocês não creram na mensagem dele. Mas os cobradores de impostos e as prostitutas creram na mensagem dele e ficaram tristes por terem pecado. Em contraste, quanto a vocês, mesmo que saibam isso, vocês não ficam tristeza tristes por pecarem e não creem na mensagem dele. ");
INSERT INTO portft_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ouçam outra parábola que eu lhes contarei. Havia um proprietário/dono de terra que fez uma plantação de uvas. Ele construiu uma cerca ao redor dela, cavou um buraco no chão dentro da cerca e instalou um tanque de pedra para recolher o suco que iam tirariam das uvas. Ele também construiu uma torre dentro daquela cerca onde alguém ficaria  para guardar a plantação. Então ele arrendou a plantação a uns lavradores para cuidarem dela e devolverem a ele parte da fruta. Depois ele foi a outro país. ");
INSERT INTO portft_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Quando chegou a época da fruta estar madura, o dono mandou alguns dos seus servos a esses lavradores para que eles entregassem aos servos a sua parte da fruta que a plantação produziu. ");
INSERT INTO portft_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mas os que arrendaram agarraram os servos. Bateram em um deles, mataram outro e mataram ainda outro, atirando pedras nele. ");
INSERT INTO portft_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Então o dono enviou ainda Formatted mais servos do que tinha mandado na primeira vez. Os lavradores trataram esses servos assim como trataram os outros servos ");
INSERT INTO portft_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mais tarde, sabendo disso, ele mandou seu filho aos lavradores para que entregassem a ele a fruta da plantação. Quando enviou o filho, ele disse a si mesmo: ‘Eles respeitarão o meu filho e darão a ele uma parte da fruta.’ ");
INSERT INTO portft_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mas quando os lavradores viram que o filho dele tinha entrou na plantação, disseram uns aos outros: “Esse é o homem que herdará a plantação! Para que ele não a herde, vamos nos reunir, matá-lo e dividir a herança entre nós.’ ");
INSERT INTO portft_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Então eles o agarraram, jogaram-no para fora da plantação e mataram-no. ");
INSERT INTO portft_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Portanto, quando o dono voltar para sua plantação de uvas, o que ele fará com esses lavradores?” ");
INSERT INTO portft_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Os chefes dos sacerdotes e os anciãos responderam-lhe: “Ele destruirá por completo esses lavradores ruins! Depois ele arrendará sua plantação a outros lavradores. Eles darão a ele a sua parte da fruta quando ela ficar madura”. ");
INSERT INTO portft_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus disse-lhes: “Isso é a verdade, por isso pensem com cuidado sobre quem estas Escrituras que vocês leem RHQ fazem referência: Os construtores rejeitaram certa pedra. Mas outros colocaram essa mesma pedra no seu lugar certo e ela tornou-se a pedra mais importante do edifício. MET O Senhor fez isso, e nos admiramos ao olharmos o que Ele fez. ");
INSERT INTO portft_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Portanto, já que vocês me rejeitam, vou dizer-lhes isto: Deus fará com que vocês judeus não sejam mais o povo sobre quem Ele governa. Pelo contrário, Ele fará com que os não judeus sejam o povo sobre quem Ele governa, e eles farão o que Ele pede que façam. ");
INSERT INTO portft_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Essa pedra angular representa a mim, o Messias, e as pessoas que me rejeitam são como pessoas que caem nesta pedra angular e sobre quem esta pedra cai. Qualquer um que cair nesta pedra será quebrado em pedaços {Esta pedra quebrará em pedaços qualquer um que cair em cima dela}, e ela esmagará qualquer um sobre quem cair”. ");
INSERT INTO portft_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Quando os chefes dos sacerdotes e os anciãos que eram fariseus ouviram esta parábola, ... 22 Formatted entenderam que Ele os acusou por não crerem que Ele era o Messias. ");
INSERT INTO portft_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Como resultado, embora ... 42 eles tentasse prendê-lo, não fizeram isso porque tinham medo do que as multidões fariam se o prendessem, pois as multidões consideravam que Jesus era um profeta. ");
INSERT INTO portft_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Então Jesus contou outras parábolas aos líderes dos judeus para ilustrar o que acontece Formatted com as pessoas que não O aceitam como o rei que Deus prometeu mandar. Segue/Esta é uma delas: ");
INSERT INTO portft_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Deus é como um rei que disse aos seus servos para fazerem uma festa de casamento para o filho dele. ");
INSERT INTO portft_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Então este rei mandou seus servos dizerem às pessoas que tinham sido convidadas {que ele tinha convidado} que deviam vir à festa de casamento. Esses servos fizeram isso. Porém as pessoas não quiseram vir a essa festa. ");
INSERT INTO portft_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Então ele enviou outros servos dizerem novamente às pessoas que ele tinha convidou que deviam vir à festa. Ele disse a esses servos: ‘Digam às pessoas que foram convidadas {que eu convidei} para virem à festa: ‘É assim que o rei diz para vocês: ‘Estou dizendo a vocês que eu preparei o banquete, os bois e os bezerros gordos foram mortos/abatidos {eu matei/abati e cozinhei (assei) os bois e os bezerros gordos}. Tudo está pronto para a festa começar. Venham à festa de casamento agora!’’ ");
INSERT INTO portft_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Quando os servos disseram isso a eles, esses convidados não se importaram com o que os servos disseram. Em vez de se importarem com aquilo que ouviram, alguns deles foram aos seus próprios campos. Outros foram aos seus lugares de negócios/suas empresas. ");
INSERT INTO portft_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Os outros agarraram os servos, trataram-nos mal e mataram-nos. ");
INSERT INTO portft_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Quando o rei ouviu o que tinha acontecido, ele ficou furioso. Como resultado ele mandou que seus soldados fossem e matassem esses assassinos e queimassem as cidades deles. ");
INSERT INTO portft_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Depois que os soldados dele fizeram isso, ele disse aos seus outros servos: ‘Eu preparei a festa de casamento, mas as pessoas que foram convidadas {que eu convidei} não merecem vir a ela, porque ––rejeitaram meu convite/não pensaram que eu as honrei ao convidá-las. ");
INSERT INTO portft_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Por isso, vão às praças das ruas principais e digam a qualquer um que encontrarem que eles devem vir à festa de casamento. ");
INSERT INTO portft_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Então esses servos foram ali e reuniram todos os que viram que queriam ir a essa festa. Reuniram tanto aqueles que os outros consideravam maus como aqueles que os outros consideravam bons no salão onde a festa de casamento se realiza. O salão ficou cheio {Essas pessoas encheram o salão}. ");
INSERT INTO portft_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mas quando o rei entrou no salão para ver os convidados que estavam ali, viu um que Formatted não usou a roupa que os servos dele deram aos convidados para usarem na festa de casamento. ");
INSERT INTO portft_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","O rei disse-lhe: ‘Amigo, ––você jamais devia ter entrado/como foi que você entrou? -ou–– RHQ neste salão, já que não está usando a roupa que damos aos convidados para usarem em uma festa de casamento!/?’ Esse homem não disse nada, pois não sabia o que dizer. ");
INSERT INTO portft_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Então o rei disse aos seus empregados: ‘Amarrem os pés e as mãos desse convidado e joguem-no fora, onde há escuridão total. As pessoas que estão lá choram, porque sofrem e rangem os dentes porque estão com muita dor”. ");
INSERT INTO portft_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Então Jesus disse: “O ponto desta história é que Deus convidou muitos para virem a Ele, mas são poucos os que Ele escolheu para estarem ali.”. ");
INSERT INTO portft_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Depois de Jesus dizer isso, os fariseus se reuniram para planejar como iam fazê-lo dizer algo que faria com que eles pudessem colocá-lo na prisão. ");
INSERT INTO portft_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mandaram a Ele alguns dos seus próprios discípulos que pensavam que os israelitas deviam pagar somente o imposto que as autoridades dos judeus requeriam que as pessoas pagassem. Também enviaram alguns membros do partido que apoiava Herodes que pensava que os israelitas só deviam pagar o imposto que o governo romano requeria das pessoas. Eles disseram-lhe: “Mestre, sabemos que o senhor é honesto e que ensina verdadeiramente a palavra de Deus. Também sabemos que não se importa com o que qualquer outra pessoa diz a respeito do senhor, mesmo que seja uma pessoa importante que não goste do que diz. IDM ");
INSERT INTO portft_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Portanto, diga-nos o que pensa RHQ ser a resposta para esta pergunta: É certo ou não nós pagarmos impostos ao governo romano?” ");
INSERT INTO portft_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mas Jesus sabia que na verdade eles eram maliciosos, querendo que Ele dissesse algo que faria ou os judeus ou as autoridades romanas acusá-lo. Por isso Ele respondeu-lhes: “Vocês –– são hipócritas/estão fingindo fazer uma pergunta legítima––, mas somente querem RHQ que eu diga algo pelo qual possam me prender. ");
INSERT INTO portft_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mostrem-me a moeda romana com a qual as pessoas pagam o imposto”. Aí eles mostraram a Ele a moeda chamada denário. ");
INSERT INTO portft_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Então Ele disse a eles: “De quem é a figura nela? E de quem é o nome gravado nela?” ");
INSERT INTO portft_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Responderam: “Tem o retrato e o nome de César, o chefe do governo romano”. Aí Ele disse a eles: “Pois paguem ao governo o que requer e deem a Deus o que Deus requer”. ");
INSERT INTO portft_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Quando esses homens ouviram Jesus dizer isso, ficaram admirados que a resposta dele não fizesse com que qualquer um pudesse acusá-lo. Então deixaram Jesus e foram para outro lugar. ");
INSERT INTO portft_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Havia uma seita dos judeus chamada dos saduceus. Eles creem que os mortos não vivem novamente depois de morrerem. Naquele mesmo dia, alguns deles foram a Ele e fizeram- lhe uma pergunta. ");
INSERT INTO portft_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Para desacreditar a ideia de que os mortos fossem viver de novo, disseram a Ele: “Mestre, Moisés escreveu nas Escrituras: ‘Se um homem que é casado e que não tem filhos morrer, o irmão dele deve casar-se com a viúva do morto para que os dois possam produzir uma criança. Então aquela criança será considerada descendente do homem que morreu e este continuará a ter descendentes’. ");
INSERT INTO portft_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pois, havia sete irmãos em uma família que vivia perto de nós. O irmão mais velho casou-se com alguém. Ele e sua mulher não tiveram filhos e ele morreu. Então o irmão mais velho do homem morto casou-se com aquela mulher. Mas ele também morreu sem ter filho. ");
INSERT INTO portft_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","A mesma coisa aconteceu com o segundo (etc.), até que os sete irmãos, um em seguida do outro, casaram-se com a mesma mulher. ");
INSERT INTO portft_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Por último, a viúva também morreu. ");
INSERT INTO portft_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Portanto, já que todos esses homens tinham sido casados com ela e somente um deles serão esposo dela no lugar onde os mortos vão, quando as pessoas tornarem a viver, de quem o senhor acha que ela será esposa?” ");
INSERT INTO portft_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus respondeu-lhes: “Vocês certamente estão errados, porque não sabem o que eles escreveram nas Escrituras. Vocês também não conhecem o poder de Deus para fazer com que as pessoas vivam de novo. ");
INSERT INTO portft_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","A verdade é que ela não será esposa de nenhum deles, pois quando Deus fizer todos os mortos viverem de novo, ninguém será casado com ninguém. Pelo contrário, as pessoas serão como os anjos no céu. Eles não se casam. ");
INSERT INTO portft_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mas quanto às pessoas viverem de novo depois de morrerem, Deus disse algo para vocês. Com certeza vocês/Será que vocês não RHQ leram o Ele que disse. Muito tempo depois que Abraão, Isaque e Jacó morreram, Deus disse a Moisés: ");
INSERT INTO portft_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Sou o Deus que Abraão adora e que Isaque adora e que Jacó adora’. Abraão, Isaque e Jacó morreram muito tempo antes disso, porém Deus diz que eles ainda o louvam, e por isso sabemos que seus espíritos ainda vivem! Deus certamente não é alguém que os mortos adoram! Ele é o Deus que os vivos adoram, porque Ele mantém vivos os espíritos deles depois deles terem morrido/da morte deles!” ");
INSERT INTO portft_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Quando as multidões de pessoas ouviram Jesus ensinar isso, ficaram maravilhadas. ");
INSERT INTO portft_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Quando os fariseus ouviram que Jesus respondeu aos saduceus de tal maneira que os saduceus não podiam pensar em qualquer coisa que pudessem dizer para responder a Ele, os fariseus se reuniram para planejar o que diriam a Ele. Então foram a Jesus. ");
INSERT INTO portft_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Um deles que estudou bem as leis que Deus deu a Moisés quis saber se Jesus poderia responder bem à pergunta dele ou se diria algo errado. Então perguntou-lhe: ");
INSERT INTO portft_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mestre, qual dos mandamentos na lei que Deus deu a Moisés é o mais importante?” ");
INSERT INTO portft_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus citou as Escrituras quando respondeu: “Devem amar o Senhor seu Deus em toda a sua maneira de viver. Demonstrem este amor em tudo que quiserem e sentirem e em tudo que pensarem. IDM ");
INSERT INTO portft_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","É este o mandamento mais importante na lei que Deus deu a Moisés. ");
INSERT INTO portft_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","O segundo mandamento em importância que com certeza todos devem obedecer é: ‘Ame as pessoas com quem têm contato tanto quanto você ama a si mesmo’. ");
INSERT INTO portft_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Este ensinamento resume todas as leis que Moisés escreveu nas Escrituras e tudo quanto os profetas escreveram nelas”. ");
INSERT INTO portft_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Enquanto os fariseus ainda estavam juntos perto de Jesus, Ele perguntou a eles: ");
INSERT INTO portft_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“O que vocês pensam sobre quem é o Messias? Ele é descendente de quem?” Responderam-lhe: “Ele é descendente do Rei Davi”. ");
INSERT INTO portft_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesus disse-lhes: “Se o Messias for descendente do Rei Davi, então Davi não devia ter chamado/como é possível que Davi tenha chamado–– RHQ chamou o Messias ‘Senhor’ quando Davi estava dizendo o que o Espírito Santo o levou a dizer./? ");
INSERT INTO portft_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Davi escreveu isto na Escritura sobre o Messias: ‘Deus disse a meu Senhor: ‘Sente-se a meu lado direito onde eu vou honrá-lo grandemente, enquanto derroto completamente seus inimigos MTY.’ ");
INSERT INTO portft_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Portanto, já que Davi chamou o Messias de ‘Senhor’, ––Ele não pode/como é que Ele pode–– RHQ ser somente o descendente do Rei Davi!/? Ele tem que ser muito maior do que Davi!” ");
INSERT INTO portft_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ninguém que ouviu o que Jesus disse podia pensar em qualquer palavra para dizer a Ele. Depois disso, ninguém mais se atreveu a fazer qualquer outra pergunta a Ele para tentar prendê-lo. ");
INSERT INTO portft_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Então Jesus disse à multidão e a nós seus discípulos: ");
INSERT INTO portft_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Moisés foi o mestre venerado que ensinou ao povo as leis que Deus deu a ele. Agora os fariseus e os homens que ensinam as leis judaicas fazem de si mesmos os que interpretam essas leis. IDM ");
INSERT INTO portft_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Por isso, vocês devem fazer o que eles lhes dizem para fazer. Porém, não façam como eles fazem, porque eles mesmos não fazem o que dizem a vocês para fazerem. ");
INSERT INTO portft_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Eles fazem vocês obedecerem muitas leis que eles acham que devem obedecer, que é semelhante a amarrar fardos difíceis de carregar e colocá-los nos ombros de vocês MET para que vocês os carreguem. Mas eles mesmos não querem ajudar ninguém a obedecer esses leis. Eles são como alguém que não quer carregar nem o menor fardo que só um dedo levantaria. MET ");
INSERT INTO portft_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Sempre quando eles obedecem uma lei que Moisés escreveu, fazem onde serão vistos por outras pessoas {onde outras pessoas vão vê-los fazer}. Por exemplo, eles alargam as pequenas caixas nos seus braços que contêm porções das Escrituras. Fazem maiores os pingentes nas suas capas, para que os outros pensem que são justos/piedosos. ");
INSERT INTO portft_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Querem que os outros honrem a eles. Por exemplo, nos banquetes eles querem os lugares onde as pessoas importantes se sentam. Nos cultos de louvor dos judeus eles querem sentar-se nos lugares onde as pessoas justas/piedosas se sentam. ");
INSERT INTO portft_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Eles também querem que os outros os saúdem respeitosamente nos mercados e querem a honra de serem chamados de ‘mestres’ pelos outros {que os outros os honrem chamando-os de ‘mestres ‘}. ");
INSERT INTO portft_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Em contraste, vocês que são meus discípulos não devem deixar que os outros os saúdem com honra como ‘Rabi’, que significa ‘mestre ’, porque a verdade é que vocês têm somente um mestre. Portanto, todos vocês são iguais, como irmãos e irmãs, e nenhum de vocês deve agir de forma superior aos outros como fazem os fariseus. ");
INSERT INTO portft_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Não deem honra a ninguém aqui na terra saudando-–o como ‘Pai’, já que Deus, o Pai de vocês no céu, é o único Pai espiritual de todos vocês. ");
INSERT INTO portft_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Não deixem as pessoas chamarem Formatted vocês de ‘Mestres’, pois a verdade é que eu, o Messias, sou o único mestre que ensina todos vocês. ");
INSERT INTO portft_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Em contraste, todos entre vocês que querem ser importantes à vista/aos olhos de Deus precisam servir os outros como fazem os servos. ");
INSERT INTO portft_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aquele que se engrandecer a si mesmo será humilhado {Deus humilhará aquele que se engrandece}. E aquele que se humilha será engrandecido {Deus engrandecerá aquele que se humilhar}”. ");
INSERT INTO portft_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Então Jesus disse aos líderes religiosos: “Será horrível para vocês que ensinam a lei judaica às pessoas e para vocês fariseus! Vocês são hipócritas porque ao ensinarem o que é falso vocês impedem os outros MTY que estão pensando em deixar Deus dominar suas vidas de fazerem isso. O que vocês fazem é como fechar uma porta MET para que as pessoas que estão começando a entrar em uma cidade não possam entrar nela. Quanto a vocês, não deixam Deus governar as suas vidas e nem permitem que os outros deixem Deus governar as vidas deles. O que vocês fazem é como não entrar em uma casa e também não deixar os outros entrarem naquela casa”. MET ");
INSERT INTO portft_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Vocês homens que ensinam as leis judaicas e vocês fariseus sofrerão terrivelmente no inferno! Vocês são hipócritas porque se esforçam muito para fazer com que mesmo uma só pessoa creia no que ensinam. Atravessam, por exemplo, mar e terra para lugares distantes para fazer isso. Como resultado de ensinarem a essa pessoa o que é falso, quando uma pessoa crê no que ensinam, vocês a fazem mais merecedora do inferno do que vocês mesmos. ");
INSERT INTO portft_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Vocês líderes dos judeus sofrerão terrivelmente no inferno. Vocês são como pessoas cegas que procuram guiar os outros. Vocês dizem: ‘Se alguém prometer que fará certa coisa e depois pedir que o templo afirme o que ele prometeu, não importa se ele cumpre ou não o que prometeu. Mas se ele pedir que o ouro do templo afirme o que prometeu, ele deve cumprir o que prometeu.’ ");
INSERT INTO portft_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Vocês são tolos e são como cegos! MET O ouro que faz parte do templo é importante, mas o templo mesmo é ainda mais importante, RHQ porque é o templo do qual o ouro faz parte que o separa de outro ouro para um uso especial para Deus. ");
INSERT INTO portft_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Também, vocês dizem: ‘Se alguém prometer que fará certa coisa e depois pedir que o altar afirme o que prometeu, não importa se deixa de fazer o que prometeu. Mas se ele pedir que a oferta que ele ... 107 colocou no altar afirme o que prometeu, ele precisa fazer o que prometeu’. ");
INSERT INTO portft_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Vocês são como cegos. MET A oferta que é oferecida no altar é importante, mas o altar é ainda mais importante, RHQ porque é o altar no qual é oferecido a oferta que a separa de outras ofertas para um uso especial para Deus. ");
INSERT INTO portft_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Portanto, qualquer um que prometer fazer algo e depois pedir que o altar afirme o que prometeu, está pedindo que tudo quanto estiver no altar afirme o que prometeu. ");
INSERT INTO portft_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Quem prometer fazer algo e depois pedir que o templo afirme o que prometeu está pedindo que Deus, que vive no templo, afirme o que ele prometeu. ");
INSERT INTO portft_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Quem prometer fazer algo e depois pedir que o céu afirme o que prometeu está pedindo que o trono de Deus e que Deus, que senta naquele trono, afirme o que ele prometeu. ");
INSERT INTO portft_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Vocês homens que ensinam as leis judaicas às pessoas e vocês fariseus sofrerão terrivelmente no inferno! Vocês são hipócritas porque mesmo que deem a Deus a décima parte das ervas, tais como a hortelã, a erva doce e o cominho que produzem, não obedecem as leis de Deus que são mais importantes. Por exemplo, não agem justamente com os outros, não tratam os outros com misericórdia e não são pessoas de confiança. Vocês devem dar o dízimo das ervas, mas, com certeza, também devem obedecer estas outras leis importantes. ");
INSERT INTO portft_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Vocês líderes são como cegos que estão procurando guiar os outros. Segundo as suas leis, vocês pensam que tocar nos mosquitos e nos camelos os faz inaceitáveis a Deus. Mas o que vocês fazem é como coar um mosquito de uma jarra de água para que não se tornem inaceitáveis a Deus ao engolirem e não coar um camelo desta água, mas engolir o camelo com a água MET! ");
INSERT INTO portft_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Será terrível para vocês homens que ensinam as leis judaicas e vocês fariseus! Vocês são hipócritas porque são gananciosos e egoístas. Vocês se disfarçam de santos. Vocês são como xícaras e pratos que foram lavados por fora, mas dentro deles está muito sujo. ");
INSERT INTO portft_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Vocês fariseus cegos! Primeiro deixem de ser gananciosos e egoístas. Depois façam verdadeiramente o que é justo. Isso será como lavar o interior da xícara antes de lavar o exterior. ");
INSERT INTO portft_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Será terrível para vocês homens que ensinam as leis judaicas às pessoas e vocês fariseus. Vocês são hipócritas! São semelhantes a túmulos lavados (até ficarem) brancos para que as pessoas possam vê-los e evitar tocar neles. Por fora os túmulos são bonitos, mas dentro estão cheios de ossos de pessoas mortas e de sujeira. ");
INSERT INTO portft_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Vocês são como esses túmulos. Quando as pessoas veem vocês, pensam que vocês são justos, mas no seu ser interior vocês são hipócritas e desobedecem ao que Deus manda. ");
INSERT INTO portft_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Será horrível para vocês homens que ensinam as leis judaicas para as pessoas e para vocês fariseus que são hipócritas. Vocês edificam novamente os túmulos dos profetas que outros mataram há muito tempo atrás. Vocês enfeitam os monumentos que comemoram pessoas justas. ");
INSERT INTO portft_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Vocês dizem: ‘Se tivéssemos vivido quando nossos antepassados MET viviam, não teríamos ajudado MET aqueles que mataram os profetas’. ");
INSERT INTO portft_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Dessa forma vocês reconhecem que deviam honrar aqueles homens, mas desrespeitam a palavra de Deus que outros homens que Deus enviou ensinam. Assim testificam contra si mesmos que são descendentes e discípulos MET das pessoas que mataram os profetas. ");
INSERT INTO portft_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Vocês estão tão dispostos a matar os outros quanto MET seus antepassados. ");
INSERT INTO portft_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Como vocês são ruins! São tão perigosos quanto cobras venenosas DOU MET! Pensam/Será que pensam–– RHQ erradamente que escaparão quando Deus castigar as pessoas más no inferno! ");
INSERT INTO portft_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Notem que é por isso que mandarei profetas, sábios e outros homens que ensinarão a minha mensagem a vocês. Alguns deles vocês mandarão que outros matem, colocando-os em cruzes ou fazendo outras coisas. Alguns deles vocês chicotearão nos lugares onde adoram a Deus e correrão atrás deles de uma cidade para outra. ");
INSERT INTO portft_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Como resultado, Deus castigará vocês por matarem SYN todas as pessoas justas, inclusive SNY Abel, o filho de Adão, que era justo, SYN Zacarias, o filho de Baraquias, que vocês são culpados de matar no lugar santo entre o templo e o altar e por matarem todos os profetas que viviam nas épocas entre as vidas desses dois homens. ");
INSERT INTO portft_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Notem isto: são vocês que observam o meu ministério que Deus castigará por matar todos esses profetas! ");
INSERT INTO portft_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Vocês que vivem em Jerusalém MTY, vocês mataram os profetas que viveram há muito tempo atrás e outros que foram mandados {que Deus mandou} a vocês, vocês mataram jogando pedras neles! DOU Muitas vezes eu quis juntar vocês para protegê-los. Eu teria sido como uma galinha que junta seus pintinhos debaixo de suas asas. MET Mas vocês não quiseram que eu fizesse isso. ");
INSERT INTO portft_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Então ouçam isto: a cidade onde moram SYN será um lugar não habitado. ");
INSERT INTO portft_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Guardem na mente o seguinte: vocês me verão novamente apenas quando eu vier de novo e vocês disserem sobre mim: ‘Deus realmente tem prazer neste homem que vem com a autoridade de Deus MTY’”. ");
INSERT INTO portft_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus saiu do pátio do templo. Enquanto caminhava, nós os discípulos dele fomos a Ele para pedir que Ele observasse como eram lindos os edifícios do templo. ");
INSERT INTO portft_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Então Ele disse: “Estes edifícios que vocês estão olhando RHQ são maravilhosos, mas quero dizer-hes algo a respeito deles. Quando invasores estrangeiros destruírem este lugar, todas as pedras neste templo serão derrubadas {derrubarão todas as pedras neste templo}. Nenhuma pedra será deixada {Eles não deixarão nem uma pedra} em cima de outra pedra”. ");
INSERT INTO portft_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mais tarde, enquanto Jesus estava sentado só no lado do monte das oliveiras, nós, discípulos, fomos a Ele e lhe perguntamos: “Quando é que isso acontecerá ao templo? Também, o que acontecerá para indicar que o senhor está para vir de novo e para indicar que este mundo está acabando?” ");
INSERT INTO portft_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus respondeu: “Só direi isto: tenham cuidado para que ninguém engane vocês a respeito do que acontecerá. ");
INSERT INTO portft_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Muitas pessoas virão e dirão ––que eu as enviei/que elas têm a minha autoridade–– MTY. Elas dirão: ‘Eu sou o Messias’ e enganarão muitas pessoas. ");
INSERT INTO portft_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Sempre que os outros falarem com vocês sobre guerras que estão perto ou guerras que estão longe, tenham o cuidado de não ficarem preocupados. Deus já disse que essas coisas devem acontecer. Mas quando acontecerem, o mundo não acabará logo! ");
INSERT INTO portft_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pessoas que moram em MTY vários países brigarão umas com outras e vários governos brigarão entre si. Haverá fomes e terremotos em vários lugares. ");
INSERT INTO portft_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Essas coisas acontecerão primeiro. Então outras coisas precederão a minha volta. O que acontecerá será tão doloroso quanto dores de parto. MET ");
INSERT INTO portft_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Naquele tempo aqueles que se opõem a vocês levarão vocês às autoridades que maltratarão e matarão vocês. Vocês serão odiados por pessoas que vivem em todas as nações PRS {Pessoas que vivem em todas as nações PRS odiarão vocês} porque vocês creem em mim. ");
INSERT INTO portft_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Também, muitas pessoas deixarão de crer em mim porque sofrerão. Trairão uns aos outros e odiarão uns aos outros. ");
INSERT INTO portft_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Muitos virão dizendo que são profetas, mas estarão mentindo e enganando muitas pessoas. ");
INSERT INTO portft_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Porque cada vez mais pessoas desobedecerão as leis de Deus, PRS muitas pessoas não mais MET amarão seus irmãos crentes. PRS ");
INSERT INTO portft_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mesmo assim, muitos continuarão a crer em mim até que morram. EUP São estas as pessoas que serão salvas {que Deus ––salvará/fará com que vivam com Ele}. ");
INSERT INTO portft_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Além disso, a boa mensagem do meu domínio sobre as vidas das pessoas será pregada em todas as regiões do mundo {as pessoas pregarão em todas as partes do mundo a boa mensagem do meu domínio sobre as vidas das pessoas}, para que todos os povos possam ouvi-la. Depois virá o fim do mundo”. ");
INSERT INTO portft_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","A pessoa repulsiva que profanará o santo templo e fará com que as pessoas o abandonem ficará no templo. Isto foi relatado pelo profeta Daniel {Daniel o profeta falou e escreveu disso} há muito tempo atrás. Que todos os que leiam isto prestem atenção nesta advertência de Jesus! ");
INSERT INTO portft_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Portanto quando virem isso acontecer, aqueles entre vocês que estiverem Formatted no distrito da Judeia devem fugir para os montes mais altos! ");
INSERT INTO portft_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Os que estiverem fora de suas casas não devem entrar nas suas casas para buscarem coisas antes de fugirem. ");
INSERT INTO portft_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Os que estiverem trabalhando nos campos não devem voltar para buscar a sua roupa exterior antes de fugirem. ");
INSERT INTO portft_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sinto muito pelas mulheres que estarão grávidas e as que estarão amamentando seus nenês naqueles dias porque será muito difícil elas fugirem! ");
INSERT INTO portft_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Orem para que não tenham que fugir no –– inverno/na época da chuva–– quando será difícil de viajar–. Aqueles que acham que Deus nunca permite ninguém fazer qualquer trabalho naquele dia não ajudarão vocês, portanto orem também que não tenham que fugir no dia de descanso dos judeus, ");
INSERT INTO portft_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","porque as pessoas sofrerão terrivelmente naquele tempo. As pessoas nunca sofreram tanto desde que Deus criou o mundo até agora, e ninguém sofrerá assim de novo. ");
INSERT INTO portft_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Se Deus não tivesse decidido diminuir aquele tempo quando as pessoas sofrerão tanto, todos MET morreriam. Mas aquele tempo será diminuído por Ele {Ele resolveu diminuir aquele tempo} porque se preocupa com aqueles que Ele escolheu. ");
INSERT INTO portft_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Naquele tempo se alguém disser a vocês: ‘Olhem, aqui está o Messias!’ ou se alguém disser: ‘Ali está o Messias!’ não acreditem! ");
INSERT INTO portft_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Devem lembrar-se disto disso porque aparecerão pessoas que dirão falsamente que são o Messias ou que são profetas. Elas farão muitos tipos de –– milagres/coisas que pessoas comuns não podem fazer–– para enganar os outros. Elas até mesmo tentarão enganar vocês que Deus escolheu, mas isso não será possível. ");
INSERT INTO portft_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Observem que eu estou advertindo vocês sobre o que acontecerá antes que aconteça. ");
INSERT INTO portft_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Portanto se alguém disser a vocês: ... 161 ‘Olhem, o Messias está no deserto!’ não vão até lá. Da mesma forma, se alguém disser a vocês: ‘Olhem, Ele está em uma sala secreta!’ não acreditem nessa pessoa, ");
INSERT INTO portft_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","porque assim como o relâmpago brilha do leste para o oeste e as pessoas por toda parte podem ver, SIM quando eu, aquele que vim do céu, voltar de novo, todos me verão. ");
INSERT INTO portft_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Minha volta será tão óbvia para todos quanto o fato de que onde quer que se juntem os urubus, há o corpo de um animal. (OU, Assim como os urubus se congregam onde tem o corpo de um animal, SIM desta mesma forma Deus castigará as pessoas em todos os lugares.) ");
INSERT INTO portft_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Logo depois que muitas pessoas sofrerem naqueles dias, o universo ficará escuro, o sol será escurecido {ficará escuro}, a lua não brilhará, as estrelas cairão do céu e os ––objetos poderosos/seres espirituais no espaço–– serão abalados {Deus abalará os ––objetos poderosos/seres espirituais no espaço}. ");
INSERT INTO portft_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Depois disso, as pessoas observarão no céu algo que indica que Eu, aquele que veio do céu, voltarei à terra. Aí as pessoas não crentes de todos os grupos étnicos da terra chorarão porque terão medo de Deus castigá-las. Elas verão a mim, aquele que veio do céu, mostrando meu poder e grande glória nas nuvens enquanto eu voltar à terra. ");
INSERT INTO portft_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Eu mandarei os meus anjos à terra de todas as partes dos céus. Eles estarão tocando trombetas muito alto. Então juntarão as pessoas que Deus escolheu de todas as partes do mundo. DOU ");
INSERT INTO portft_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Agora, aprendam algo desta parábola sobre como crescem as figueiras: Nesta área, quando seus ramos ficam macios e as folhas começam a brotar, todos sabem que o verão está perto. ");
INSERT INTO portft_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Da mesma maneira, quando vocês virem acontecer todas essas coisas que acabo de lhes falar, vocês saberão que o tempo da minha volta está muito perto MET. ");
INSERT INTO portft_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Guardem em mente isto: todos estes eventos acontecerão antes que todas as pessoas que observam as coisas que eu tenho feito morram. ");
INSERT INTO portft_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Vocês podem ter certeza de que estas coisas que predigo acontecerão. Podem ter mais certeza disso do que têm de que a terra e o céu ficarão no seu lugar. LIT ");
INSERT INTO portft_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nem eu, nem qualquer outra pessoa, nem qualquer anjo no céu, sabe o dia ou a hora quando o que eu profetizei acontecerá. Somente Deus, meu Pai, sabe. ");
INSERT INTO portft_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","As pessoas que viviam na época quando Noé vivia não sabiam nada do que aconteceria a elas até que o dilúvio chegou. Antes das águas do dilúvio cobrirem a terra, as pessoas comiam e bebiam como sempre. Homens se casavam com mulheres e pais davam suas filhas a homens para elas se casarem com eles, até o dia quando Noé e sua família entraram no barco. Mas então o dilúvio chegou e afogou todos aqueles que não entraram no barco. De modo semelhante, quando eu, aquele que veio do céu, voltar à terra, os não crentes não saberão quando voltarei e não estarão me esperando. ");
INSERT INTO portft_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Quando eu voltar, eu não levarei todas as pessoas para o céu. Levarei somente aqueles que confiam em mim. Por exemplo, duas pessoas estarão nos campos. Uma delas será levada {eu levarei uma delas} para o céu e a outra pessoa será deixada para trás e mais tarde será punida {eu deixarei a outra pessoa aqui e mais tarde vou puni-la/castigá-la}. ");
INSERT INTO portft_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","De modo semelhante, duas pessoas estarão no moinho. Uma delas será levada {eu levarei uma delas} para o céu e a outra pessoa será deixada para trás {e eu deixarei a outra pessoa}. ");
INSERT INTO portft_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Portanto, porque não sabem em que dia eu, seu Senhor, voltarei para a terra, continuem a esperar que eu vá voltar a qualquer momento. ");
INSERT INTO portft_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Vocês sabem que se os donos de uma casa soubessem a que hora os ladrões fossem chegar, estariam acordados naquela hora e não deixariam os ladrões entrarem na casa deles. Da mesma maneira, virei tão inesperadamente quanto um ladrão. ");
INSERT INTO portft_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Portanto, vocês precisam estar prontos para minha volta, porque eu, aquele que veio do céu, voltarei à terra em uma hora quando não esperam que eu volte. ");
INSERT INTO portft_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Pensem em como são todos os servos fiéis e sábios RHQ. O dono da casa o encarrega de tomar conta dos servos que trabalham para ele para dar comida a eles no tempo certo e depois saiem uma longa viagem. ");
INSERT INTO portft_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Se o servo estiver fazendo este trabalho quando o dono vier e observar o que ele está fazendo, o dono dele ficará muito contente com ele. ");
INSERT INTO portft_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Lembrem-se disto: esse dono de casa vai nomeá-lo para tomar conta de todos os bens dele permanentemente. ");
INSERT INTO portft_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mas um servo mau pode dizer para si mesmo: ‘Faz muito tempo que meu dono está fora, então provavelmente não voltará logo e descobrirá o que estou fazendo ‘. ");
INSERT INTO portft_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Aí esse servo começará a bater nos outros servos e a comer e beber com bêbados. ");
INSERT INTO portft_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Então seu dono voltará em uma hora quando o servo não o espera DOU. ");
INSERT INTO portft_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","O dono vai ––cortá-lo em dois pedaços/chicoteá-lo severamente–– HYP e vai colocá-lo onde estão os hipócritas. Naquele lugar as pessoas choram e rangem os dentes porque sofrem muito”. ");
INSERT INTO portft_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesus continuou, dizendo: “Eu direi outra coisa a vocês sobre o tempo quando eu voltar do céu como rei. O que acontecerá com as pessoas que dizem que me conhecem será como o que aconteceu com dez virgens que levaram suas lamparinas/lanternas e foram para onde iam encontrar-se com o noivo e ir à festa do casamento dele. ");
INSERT INTO portft_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco delas eram sem juízo e cinco eram sábias. ");
INSERT INTO portft_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aquelas virgens sem juízo levaram suas lamparinas, mas não levaram azeite extra para as lamparinas. ");
INSERT INTO portft_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mas as virgens sábias levaram azeite nas suas vasilhas bem como nas lamparinas. ");
INSERT INTO portft_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Quando a noite avançou, o noivo demorou. Portanto, todas aquelas virgens ficaram com sono e adormeceram. ");
INSERT INTO portft_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","No meio da noite alguém gritou: ‘Gente! O noivo está chegando! Saiam para encontrar-se com ele!’ ");
INSERT INTO portft_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aí todas aquelas virgens acordaram e acenderam suas lamparinas para que ardessem como deviam. ");
INSERT INTO portft_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","As virgens sem juízo disseram às outras virgens: ‘Deem para nós um pouco do seu azeite, porque nossas lamparinas estão quase para apagar/apagando-se!’ ");
INSERT INTO portft_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","As virgens sábias disseram às outras virgens: ‘Não, porque talvez o nosso azeite não seja suficiente para nossas lamparinas e para as de vocês. Em vez disso, vão àqueles que vendem azeite e comprem um pouco para si mesmas’. ");
INSERT INTO portft_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mas enquanto aquelas virgens sem juízo foram comprar azeite, o noivo chegou. Então as virgens sábias, que estavam preparadas, foram com ele ao salão do casamento onde a noiva estava esperando. Depois, a porta foi fechada {alguém fechou a porta do salão}. ");
INSERT INTO portft_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mais tarde, as outras virgens chegaram ao salão e pediram para o noivo: ‘Senhor, abra a porta para nós!’ ");
INSERT INTO portft_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mas ele disse-lhes: ‘O que eu direi a vocês é a verdade: não abrirei a porta para vocês porque não conheço vocês!’” ");
INSERT INTO portft_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Então Jesus continuou dizendo: “Portanto, para que isso não aconteça a vocês, continuem a esperar que eu vá voltar/pela minha volta porque não sabem quando voltarei”. ");
INSERT INTO portft_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Quando eu voltar do céu como rei, a minha maneira de lidar com aqueles que dizem que me servem é como um homem que estava para sair em uma longa viagem. Ele chamou seus servos e deu a cada um deles uma parte de seu dinheiro/seus bens para investi-los e ganhar mais dinheiro para ele. ");
INSERT INTO portft_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Deu-lhes dinheiro para cuidar conforme a habilidade deles. Por exemplo, deu cinco mil dólares $5000 a um deles, deu dois mil dólares $2000 a outro, e deu mil dólares $1000 a outro. Então ele saiu de viagem. ");
INSERT INTO portft_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","O homem que tinha recebido os cinco mil dólares logo foi e usou esse dinheiro para ganhar mais cinco mil. ");
INSERT INTO portft_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","De modo semelhante, o homem que tinha recebido dois mil dólares ganhou mais dois mil. ");
INSERT INTO portft_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mas o homem que tinha recebido mil dólares cavou um buraco no chão e escondeu o dinheiro do patrão dele no chão. ");
INSERT INTO portft_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Depois de muito tempo o patrão dos servos voltou. Ele os chamou para saber o que tinham feito com o dinheiro dele. ");
INSERT INTO portft_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","O homem que tinha recebido cinco mil dólares trouxe dois sacos, cada um com cinco mil dólares. Ele disse: ‘Patrão, o senhor me encarregou de cinco mil dólares. Olhe, ganhei mais cinco mil!’ ");
INSERT INTO portft_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","O patrão dele respondeu: ‘Você é um servo muito bom e fiel! Você fez muito bem! Você usou fielmente uma pequena quantia de dinheiro, então vou encarregá-lo de muitas coisas. Venha e fique alegre comigo!’ ");
INSERT INTO portft_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","O homem que tinha recebido dois mil dólares também foi ao seu patrão e disse: ‘Patrão, o senhor me entregou dois mil dólares para cuidar. Veja, ganhei mais dois mil!’ ");
INSERT INTO portft_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","O patrão dele respondeu, ‘Você é um servo muito bom e fiel! Fez muito bem! Você usou bem uma pequena quantia de dinheiro, então vou encarregá-lo de muitas coisas. Venha e fique feliz comigo!’ ");
INSERT INTO portft_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Aí o homem que tinha recebido mil dólares chegou e disse: ‘Patrão, tive medo do senhor. Eu sabia que o senhor é um homem que não faz coisas tolas com seu dinheiro. O senhor até tira dos outros o dinheiro que na verdade não pertence ao senhor, como o agricultor que colhe trigo da roça de outro homem onde ele nem plantou as sementes. ");
INSERT INTO portft_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Então, porque tive medo do que o senhor faria comigo se não ganhasse nada do meu negócio, fui e escondi os mil dólares do senhor na terra. Aqui está, o dinheiro que pertence ao senhor!’ ");
INSERT INTO portft_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","O patrão dele respondeu-lhe: ‘Que servo mau e preguiçoso você é! Você sabia –– RHQ que tiro dos outros dinheiro que realmente não me pertence, como o agricultor que colhe o trigo da roça de outro homem onde nem plantei as sementes! ");
INSERT INTO portft_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Portanto, você devia ter colocado meu dinheiro em um banco, para que quando eu voltasse pudesse tê-lo de novo com os juros que teria ganho!’ ");
INSERT INTO portft_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Então ele disse aos seus outros servos: ‘Tirem os mil dólares dele e deem ao homem que tem os dez mil dólares! ");
INSERT INTO portft_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Para aqueles que usam bem o que recebem, muito mais será dado {Eu darei muito mais}, para que tenham muito. Mas para aqueles que não usam bem o que recebem, até o que já têm será tirado {eu tirarei até mesmo o que eles já têm}. ");
INSERT INTO portft_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Além disso, joguem fora aquele servo inútil, na escuridão, onde estará com aqueles que estão chorando e rangendo os dentes porque estão com muita dor. ");
INSERT INTO portft_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Quando eu, aquele que veio do céu, vier de novo com todo meu esplendor/brilho, eu trarei todos os meus anjos comigo. Então vou sentar-me como rei no meu trono maravilhoso para julgar as pessoas. ");
INSERT INTO portft_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","As pessoas de todas as nações estarão reunidos na minha frente {Os anjos reunirão na minha frente as pessoas de todas as nações}. Então eu separarei as pessoas umas das outras, assim como o pastor separa as ovelhas das cabras dele. ");
INSERT INTO portft_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Eu colocarei os justos à minha direita e os não justos à minha esquerda, assim como o pastor coloca as ovelhas de um lado e as cabras do outro lado. ");
INSERT INTO portft_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Então eu direi àqueles no meu direito: ‘Vocês que foram abençoados por meu Pai {que meu Pai abençoou} venham! Desde que Ele criou o mundo, Ele está preparando para deixar vocês receberem as bênçãos que quer dar a todos aqueles que o deixam governar as vidas deles. Já chegou o tempo de vocês receberem essas bênçãos! ");
INSERT INTO portft_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Elas pertencem a vocês, porque (OU, é como se) vocês me deram algo para comer quando eu estava com fome. Vocês me deram algo para beber quando eu estava com sede. Quando eu era um desconhecido na cidade de vocês, convidaram-me para ficar nas suas casas. ");
INSERT INTO portft_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Quando precisava de roupas, vocês me deram. Quando estava doente, vocês cuidaram de mim. Quando estava na prisão, vocês foram me visitar’. ");
INSERT INTO portft_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Então os justos no meu lado direito perguntarão: ‘Senhor, quando foi que estava com fome e nós vimos e demos comida ao senhor? Quando foi que o senhor estava com sede e lhe demos algo para beber? ");
INSERT INTO portft_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Quando foi que o senhor era desconhecido/estrangeiro em nossa cidade e convidamos o senhor para ficar em nossas casas? Quando foi que o senhor precisava de roupa e nós lhe demos? ");
INSERT INTO portft_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Quando foi que o senhor estava doente ou na prisão e fomos visitar o senhor?’ ");
INSERT INTO portft_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Então eu responderei: ‘Na verdade, o que fizeram para qualquer um dos seus irmãos crentes, mesmo que fosse alguém de pouca importância, foi como se fizessem isso para mim’. ");
INSERT INTO portft_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Depois eu direi àqueles à minha esquerda: ‘Vocês que foram amaldiçoados por Deus {que Deus amaldiçoou} deixem-me! Vão para o fogo eterno que foi preparado {que Deus preparou} para ––o diabo/Satanás–– e os anjos dele! ");
INSERT INTO portft_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","É justo para vocês, porque vocês não me deram nada para comer quando eu estava com fome. Não me deram nada para beber quando estava com sede. ");
INSERT INTO portft_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Vocês não me convidaram para suas casas quando eu era um desconhecido na sua cidade. Não me deram roupa quando precisava dela. Não cuidaram de mim quando eu estava doente ou na prisão’. ");
INSERT INTO portft_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Então eles responderão: ‘Senhor, quando o senhor estava com fome ou com sede ou era um desconhecido ou precisava de roupa ou doente ou na prisão, e nós não ajudamos o senhor?’ ");
INSERT INTO portft_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Eu responderei: ‘A verdade é que sempre que não faziam nada para ajudar qualquer um destes que são do meu povo, mesmo que não fossem importantes, era como se não fizessem nada para me ajudar’. ");
INSERT INTO portft_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Então essas pessoas à minha esquerda vão embora para onde Deus vai puni-las eternamente, mas os justos vão para onde viverão para sempre ––comigo/com Deus”. ");
INSERT INTO portft_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Quando Jesus terminou de dizer todas essas coisas, disse para nós, seus discípulos: ");
INSERT INTO portft_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Vocês sabem que daqui a dois dias nós celebraremos a festa da Páscoa. Naquele tempo eu, aquele que veio do céu, serei entregue {me entregarão, aquele que veio do céu,} nas mãos daqueles que vão pregar-me em uma cruz”. ");
INSERT INTO portft_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nessa mesma hora os principais sacerdotes e os anciãos dos judeus se reuniram na casa do sumo sacerdote, que se chamava Caifás. ");
INSERT INTO portft_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ali eles planejaram como podiam prender Jesus de uma maneira enganosa/desonesta e depois matá-lo. ");
INSERT INTO portft_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mas disseram: “Não podemos fazê-lo durante a Festa da Páscoa, porque se fizermos naquele dia, o povo é capaz de criar uma rebelião”. ");
INSERT INTO portft_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Quando Jesus estava conosco, os discípulos, no povoado de Betânia, na casa de Simão, que Jesus tinha curado de lepra, ");
INSERT INTO portft_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","uma mulher chegou perto dele. Ela trazia um jarro de pedra que continha perfume muito caro. Para mostrar o quanto ela valorizava Jesus, derramou o perfume na cabeça dele enquanto Ele comia. ");
INSERT INTO portft_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Quando vimos isso, alguns de nós ficamos zangados. Um de nós disse: “––É terrível/Por que é–– RHQ que este perfume – seja/está sendo desperdiçado!/? ");
INSERT INTO portft_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Podia ter sido vendido e muito dinheiro ganho {Podíamos ter vendido e ganho muito dinheiro} por ele! Depois o dinheiro podia ter sido dado {podíamos ter dado o dinheiro} para os pobres”. ");
INSERT INTO portft_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mas Jesus sabia o que estávamos dizendo. Por isso Ele nos disse: “––Vocês não deviam estar/Por que vocês estão–– RHQ perturbando esta mulher!/? Ela fez uma coisa linda para mim. ");
INSERT INTO portft_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Lembrem-se de que sempre haverá pessoas pobres entre vocês e podem ajudá-las sempre que quiserem. Porém eu não estarei sempre com vocês, por isso é bom ela mostrar agora que me valoriza! ");
INSERT INTO portft_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Quando ela derramou este perfume no meu corpo, era como se soubesse que eu morreria daqui a pouco e ela tem ungido meu corpo para as pessoas enterrá-lo. ");
INSERT INTO portft_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Direi isto para vocês: onde quer que seja pregada esta boa mensagem a meu respeito {as pessoas preguem esta boa mensagem a meu respeito} pelo mundo inteiro, o que esta mulher fez também será relatado {também relatarão aos outros o que esta mulher fez}, e como resultado as pessoas vão lembrar-se disso”. ");
INSERT INTO portft_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Então Judas Iscariotes, embora fosse um de nós, discípulos, foi aos sumo sacerdotes. ");
INSERT INTO portft_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Perguntou-lhes: “Se eu fizer com que vocês possam prender Jesus, quanto dinheiro vocês estão dispostos a me dar?” Eles concordaram em dar-lhe trinta moedas de prata. Então eles contaram as moedas e deram a ele. ");
INSERT INTO portft_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Daquele momento em diante Judas procurou uma oportunidade de ajudá-los a prender Jesus. ");
INSERT INTO portft_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","No primeiro dia da festa que dura uma semana quando nós judeus comemos pão que não contém fermento, nós, discípulos, fomos a Jesus e perguntamos: “Onde é que o senhor quer que preparemos a refeição para a celebração da Páscoa para nós comermos com o senhor?” ");
INSERT INTO portft_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ele deu instruções a dois dos seus discípulos sobre onde deviam ir. Disse a eles: “Vão à cidade de Jerusalém a um homem com quem já arranjei isto anteriormente. Digam-lhe: ‘O mestre diz: ‘a hora de que já falei com você está perto. Eu celebrarei a refeição da Páscoa com meus discípulos na sua casas e eu estou enviando estes dois discípulos para preparar a refeição’’. ");
INSERT INTO portft_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Em seguida, esses dois discípulos fizeram como Jesus lhes disse e prepararam a refeição da Páscoa naquela casa. ");
INSERT INTO portft_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Quando chegou a noite, Jesus estava jantando com seus doze discípulos. ");
INSERT INTO portft_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Enquanto estávamos comendo, Ele nos disse: “Ouçam com cuidado: um de vocês fará com que meus inimigos me peguem. ");
INSERT INTO portft_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ficamos muito tristes e começamos a dizer para Ele, um após outro: “Senhor, ––certamente não sou/será que sou– RHQ eu!/? RHQ” ");
INSERT INTO portft_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ele respondeu: “Aquele que fará com que meus inimigos me peguem é um de vocês que está mergulhando seu pão no molho junto comigo. ");
INSERT INTO portft_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","É certo que eu, aquele que veio do céu, morrerei, porque é isso que foi escrito {os profetas escreveram} sobre mim. Mas será horrível para aquele por quem eu serei traído {que ––me trairá/ajudará meus inimigos a me pegar}! Seria melhor para esse homem se ele não tivesse nascido”!! ");
INSERT INTO portft_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Então Judas, aquele que ia traí-lo, disse: “Rabi/Mestre, ––certamente não sou/será que sou–– RHQ eu!/?” Jesus respondeu:“Sim, é você”. ");
INSERT INTO portft_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Enquanto estávamos comendo, Jesus pegou um pão pequeno e deu graças a Deus por ele. Depois Ele o rasgou em pedaços e deu a nós, discípulos, dizendo: “Peguem este pão e comam. Ele representa meu corpo”. ");
INSERT INTO portft_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mais tarde Ele pegou uma xícara de vinho e deu graças a Deus por ele. Então Ele deu a nós, dizendo: “Tomem um pouco do vinho deste copo, todos vocês. ");
INSERT INTO portft_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","O vinho neste copo representa meu sangue que está para ser derramado {que em pouco tempo eu derramarei}. Este sangue porá em prática o novo acordo que Deus está fazendo com muitas pessoas para perdoar os pecados delas. ");
INSERT INTO portft_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Notem isto com cuidado: eu não beberei mais nenhum vinho como este até o dia quando beberei com vocês com um novo significado, quando meu Pai fizer com que eu possa começar a governar”. ");
INSERT INTO portft_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Depois que cantamos um hino, saímos para o Monte das Oliveiras. ");
INSERT INTO portft_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Então Jesus nos disse: “Hoje à noite todos vocês me abandonarão por causa do que acontecerá comigo. Isso acontecerá porque ––um profeta/Zacarias–– escreveu estas palavras que Deus disse: ‘Eu fazerei com que as pessoas matem o pastor, e depois todas as ovelhas serão espalhadas {se espalharão}.’” ");
INSERT INTO portft_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mas depois que eu tiver morrido e tornado a viver outra vez, vou diante de vocês para o distrito da Galileia”. ");
INSERT INTO portft_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro respondeu: “Talvez todos os outros discípulos abandonem o senhor quando virem o que acontecerá ao senhor, mas, com certeza, eu nunca vou abandoná-lo”! ");
INSERT INTO portft_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus respondeu: “Ouça com cuidado: esta mesma noite, antes do galo cantar, você dirá três vezes que não me conhece”! ");
INSERT INTO portft_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro disse-lhe: “Mesmo que eles me matem enquanto eu defender o senhor, eu nunca direi que não conheço o senhor!” Todos nós, discípulos, também dissemos a mesma coisa. ");
INSERT INTO portft_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Então Jesus foi conosco ao um lugar chamado {que as pessoas chamam} Getsêmani. Ali ele disse a quase todos nós: “Fiquem aqui enquanto eu for ali para orar”. ");
INSERT INTO portft_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ele levou Pedro, Tiago e João consigo. Ele ficou extremamente angustiado/aflito. ");
INSERT INTO portft_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Então Ele disse-lhes: “Estou muito triste! É como se eu estivesse quase para morrer! Fiquem aqui e permaneçam acordados comigo!” ");
INSERT INTO portft_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Depois de caminhar um curta distância, Ele se prostrou para que seu rosto tocasse no chão e orou: “Pai, se for possível, não me deixe sofrer. Porém, não faça assim como eu quero. Pelo contrário, faça o que o senhor quer!” ");
INSERT INTO portft_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Então Ele voltou aos três discípulos e viu que estavam dormindo. Ele acordou Pedro e disse-lhe: “––Estou desapontado por vocês não ficarem acordados comigo por/Por que é que–– RHQ vocês não podiam ficar acordados comigo por – -apenas um tempo curto/uma hora./? ");
INSERT INTO portft_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Vocês devem ficar atentos e orar, para resistir quando algo tenta vocês. Vocês querem fazer o que digo, mas não têm força suficiente para realmente fazerem o que eu digo”. ");
INSERT INTO portft_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ele foi embora uma segunda vez e orou: “Meu Pai, se for necessário eu sofrer LIT, que aconteça assim como o senhor quer!” ");
INSERT INTO portft_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Quando voltou aos três discípulos, viu que estavam dormindo de novo. Não podiam manter os olhos abertos. ");
INSERT INTO portft_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Então Ele os deixou e foi embora de novo. Ele orou pela terceira vez, dizendo a mesma coisa que tinha orado antes. ");
INSERT INTO portft_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Depois Ele voltou para todos os discípulos. Ele os acordou e disse-lhes: “Estou desapontado que vocês estão/Por que é que vocês estão –– RHQ dormindo e descansando! Vejam! Alguém logo fará com que homens maus me prendam, aquele que veio do céu! ");
INSERT INTO portft_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Levantem-se! Vamos ao encontro deles! Aí vem aquele que está –– ajudando meus inimigos a me prenderem/traindo-me!” ");
INSERT INTO portft_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Enquanto Ele ainda estava falando, Judas chegou para ajudar seus inimigos a prendê-lo, mesmo que Judas fosse um de nós doze discípulos. Uma multidão de pessoas que carregavam espadas e porretes estava com ele. Os principais sacerdotes e os anciãos dos judeus a tinha mandado. ");
INSERT INTO portft_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas antes tinha combinado de dar-lhes um sinal. Ele disse: “O homem que eu beijar é o que querem. Peguem–no!” ");
INSERT INTO portft_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Logo ele foi a Jesus e disse: “Saudações, Rabi/mestre!” Então ele beijou Jesus no pescoço/na face. ");
INSERT INTO portft_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus respondeu: “Amigo, é para me beijar que você está aqui?” (OU: “Faça que veio fazer!”) Então os homens que chegaram com Judas avançaram e prenderam Jesus. ");
INSERT INTO portft_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Inesperadamente, um dos homens que estava com Jesus tirou sua espada da sua porta-espada. Ele bateu no servo do sumo sacerdote com ela para matá-lo, mas só cortou a orelha dele. ");
INSERT INTO portft_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesus disse a Pedro: “Coloque sua espada de novo no seu porta-espada! Alguém matará com espada todos os que tentam matar os outros com espada! ");
INSERT INTO portft_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Você acha que RHQ se eu pedisse a meu Pai, Ele não enviaria logo mais de doze exércitos de/Setenta e dois mil  anjos para me ajudar? ");
INSERT INTO portft_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mas se eu fizesse isso, o que os profetas escreveram nas Escrituras sobre o que aconteceria com o Messias não seria cumprido {ocorreria} RHQ”. ");
INSERT INTO portft_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Naquela hora Jesus disse à multidão que estava prendendo-o: “É ridículo que vocês venham/será que vocês vêm–– RHQ aqui para me pegarem com espadas e tacapes, como se eu fosse um bandido!/? Dia trás dia eu sentei no pátio do templo, ensinando o povo. Por que vocês não me prenderam naquele tempo? ");
INSERT INTO portft_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mas tudo isso está acontecendo para que seja cumprido {para cumprir} o que os profetas escreveram nas Escrituras a meu respeito”. Então todos nós, discípulos, o abandonamos e fugimos. ");
INSERT INTO portft_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Os homens que tinham prendido Jesus o levaram à casa de Caifás, o sumo sacerdote. Os homens que ensinavam as leis judaicas e os anciãos dos judeus já estavam reunidos ali. ");
INSERT INTO portft_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro seguiu Jesus a uma distância. Ele entrou no pátio do sumo sacerdote e sentou-se com os guardas para ver o que aconteceria. ");
INSERT INTO portft_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Os sumo sacerdotes e os outros do Concílio dos judeus estavam tentando achar pessoas que fossem mentir sobre Jesus para que pudessem convencer as autoridades romanas a matá-lo. ");
INSERT INTO portft_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mas mesmo que muitas pessoas falassem mentiras a respeito dele, não acharam ninguém que dissesse qualquer coisa útil. Porém, mais tarde dois homens se levantaram ");
INSERT INTO portft_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","e disseram: “Este homem disse: ‘Posso destruir o templo de Deus e também posso reconstruí-lo dentro de três dias’”. ");
INSERT INTO portft_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Então o sumo sacerdote se levantou e perguntou a Ele: “O senhor não responderá? O que o senhor diz a respeito destas coisas que estão dizendo para acusá-lo?” ");
INSERT INTO portft_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mas Jesus ficou calado. Então o sumo sacerdote disse a Ele: “Ordeno que o senhor nos diga a verdade, sabendo que o Deus Todo–-poderoso está ouvindo o senhor: O senhor é o Messias, ––o Filho de Deus/o homem que também é Deus?” ");
INSERT INTO portft_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus respondeu: “Sou, sim. Mas também direi isto a todos vocês: um dia vocês me verão, aquele que veio do céu, sentado ao lado de Deus, o Altíssimo, e governando. Vocês também me verão descendo do céu pelas nuvens!” ");
INSERT INTO portft_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Então o sumo sacerdote rasgou sua roupa exterior. Este era o costume deles para mostrar que ele estava horrorizado ao ouvir Jesus dizer que era igual a Deus. Ele disse: “Ele diz ser igual a Deus! Nós certamente não precisamos/Por que devíamos procurar–– RHQ mais pessoas que testifiquem contra este homem!/? Escutem o que Ele acaba de dizer agora contra Deus! ");
INSERT INTO portft_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Qual é a decisão de vocês?” Responderam: “Segundo as nossas leis, Ele é culpado e merece que nós o matemos!” ");
INSERT INTO portft_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Então alguns deles cuspiram na cara dele. Outros bateram nele com seus punhos. Outros, depois de terem tampado os olhos dele, deram-lhe tapas ");
INSERT INTO portft_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","e disseram: “Já que você diz que é o Messias, revele para nós quem foi que bateu em você!” ");
INSERT INTO portft_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro estava sentado no pátio. Uma serva aproximou-se dele e olhou para ele. Ela disse: “Você também estava com Jesus, aquele homem do distrito da Galileia!” ");
INSERT INTO portft_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mas enquanto todos estavam ouvindo, ele negou esse fato. Ele disse: “Não sei de que você está falando!” ");
INSERT INTO portft_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Então Pedro saiu para o portão do pátio. Outra serva o viu e disse às pessoas que estavam ali, “Este homem estava com Jesus, o homem de Nazaré”. ");
INSERT INTO portft_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mas outra vez Pedro negou, dizendo: “Que Deus me castigue se estou mentindo! Eu não conheço esse homem!” ");
INSERT INTO portft_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pouco tempo depois, as pessoas que estavam em pé ali aproximaram-se de Pedro e disseram a ele: “Certamente você é um daqueles que acompanhavam esse homem, pois a sua maneira de falar nos indica que você é da Galileia”. ");
INSERT INTO portft_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Então Pedro começou a proclamar em voz bem alta que Deus devia amaldiçoá-lo se ele estivesse mentindo. Ele pediu para que Deus no céu testemunhasse que ele estava dizendo a verdade e disse: “Não conheço esse homem!” Logo um galo cantou. ");
INSERT INTO portft_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aí Pedro se lembrou das palavras que Jesus tinha dito a ele: “Antes do galo cantar, você dirá três vezes que não me conhece”. Então Pedro saiu e chorou bem alto. ");
INSERT INTO portft_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bem cedo na manhã seguinte todos os principais sacerdotes e os anciãos dos judeus resolveram como eles fariam para que os romanos matassem Jesus. ");
INSERT INTO portft_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Amarraram as mãos dele e o levaram embora. Levaram-no a Pilatos, o governador romano. ");
INSERT INTO portft_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Quando Judas, aquele que ––traiu/ajudou os inimigos de Jesus a capturá-lo––, percebeu que tinha sido decidido mandar matar Jesus, {eles tinham decidido matar Jesus}, ficou com muito remorso por causa do que tinha feito. Ele devolveu as trinta moedas aos chefes dos sacerdotes e anciãos. ");
INSERT INTO portft_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ele disse: “Eu pequei; eu traí um homem que ––é inocente/não fez nada errado”. Eles responderam: ––“Isso não significa nada/Que significa isso–– RHQ para nós? Esse problema é seu!” ");
INSERT INTO portft_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Então Judas tomou o dinheiro e jogou-o para dentro do templo. Depois ele saiu e se enforcou. ");
INSERT INTO portft_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mais tarde os chefes dos sacerdotes acharam as moedas. Pegaram-nas e disseram: “Já que este é dinheiro que pagamos a ele por derramar sangue e matar outro homem, nossa lei não nos permite colocá-lo na caixa das ofertas do templo”. ");
INSERT INTO portft_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Por isso resolveram usar esse dinheiro para comprar o campo onde os homens cavavam na terra para fazer jarros. Fizeram desse campo um lugar onde enterravam não judeus que morriam em Jerusalém. ");
INSERT INTO portft_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","É por isso que esse campo ainda se chama {por que eles ainda chamam esse lugar} ‘O campo de sangue’. ");
INSERT INTO portft_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ao comprar esse campo, eles cumpriram estas palavras escritas pelo profeta Jeremias {que o profeta Jeremias escreveu} há muito tempo atrás: Pegaram as trinta moedas de prata; Foi (esse preço) que os líderes dos judeus resolveram que Ele valia; ");
INSERT INTO portft_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","e com elas compraram o campo de onde as pessoas tiravam barro para os oleiros. Fizeram isso assim como o Senhor me dirigiu. ");
INSERT INTO portft_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus estava em pé diante do governador. Então o governador perguntou a Ele: “Você diz que quer ser o rei dos judeus?” Jesus respondeu: “É o senhor mesmo que disse assim”. ");
INSERT INTO portft_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Quando Ele foi acusado pelos chefes dos sacerdotes e anciãos {Quando os chefes dos sacerdotes e os anciãos o acusaram de várias coisas}, Ele não respondeu. ");
INSERT INTO portft_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Então Pilatos disse a Ele: “Você ouve todas as coisas de que o acusam; não tem resposta?” ");
INSERT INTO portft_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Embora Jesus não fosse culpado, Ele não disse nada. Ele não respondeu a nenhuma das coisas de que eles o acusavam. Como resultado, o governador ficou admirado. ");
INSERT INTO portft_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Era costume do governador cada ano durante a celebração da Páscoa soltar uma pessoa que estava na prisão. Soltava o preso que o povo escolhesse. ");
INSERT INTO portft_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Naquela época havia em Jerusalém um preso bem conhecido chamado Barrabás. ");
INSERT INTO portft_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Então quando a multidão se reuniu, Pilatos perguntou: “Qual dos presos gostariam que eu soltasse para vocês: Barrabás ou Jesus, de quem se diz que {que alguns de vocês dizem} ser o Messias?” ");
INSERT INTO portft_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ele perguntou isso porque sabia o que os chefes dos sacerdotes queriam fazer. Entregaram Jesus nas suas mãos somente porque tinham inveja dele. Portanto, Ele pensava que a multidão preferisse que ele soltasse Jesus. ");
INSERT INTO portft_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Enquanto Pilatos estava sentado na plataforma de onde tomava decisões, a esposa dele lhe enviou este recado: “Hoje de manhã cedo tive um sonho ruim por causa deste homem. Portanto, não condene este homem justo!” ");
INSERT INTO portft_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mas os chefes dos sacerdotes e os anciãos convenceram a multidão a pedir que Pilatos soltasse Barrabás e mandar seus soldados executarem Jesus. ");
INSERT INTO portft_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Então o governador perguntou a ela: “Qual dos dois homens vocês querem que eu solte para vocês?” A multidão respondeu: “Barrabás!” ");
INSERT INTO portft_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aí o governador perguntou admirado: “Então o que devo fazer com Jesus de quem se diz que é {que alguns de vocês dizem} ser o Messias?” Todos responderam: “Mande que seja crucificado {seus soldados ––o crucifiquem/o preguem em uma cruz}!” ");
INSERT INTO portft_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatos perguntou: “Por que? Que mal Ele fez?” Mas eles só continuaram a gritar: “Mande que Ele seja crucificado {seus soldados o crucifiquem}!” ");
INSERT INTO portft_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatos percebeu que não podia fazer nada. Viu que, pelo contrário, o povo estava começando a se revoltar. Por isso ele pegou uma bacia de água e lavou as mãos enquanto a multidão observava e disse: “Ao lavar as mãos estou mostrando a vocês que se este homem morrer, a culpa é de vocês, não é minha!” ");
INSERT INTO portft_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","O povo todo respondeu: “A culpa de fazer Ele morrer estará sobre nós e estará sobre nossos filhos, também!” ");
INSERT INTO portft_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Então ele mandou os soldados soltarem Barrabás para eles. Mas mandou que seus soldados chicoteassem Jesus. Então entregou Jesus nas mãos dos seus soldados para que Jesus fosse pregado {eles pregassem Jesus} em uma cruz. ");
INSERT INTO portft_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Então os soldados do governador levaram Jesus para a sede do governo. Toda a tropa/o grupo de soldados reuniu-se em volta de Jesus. ");
INSERT INTO portft_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Eles tiraram a roupa dele e colocaram nele uma capa roxa, fingindo que fosse um rei. ");
INSERT INTO portft_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pegaram alguns espinho, teceram para fazer uma coroa e colocaram-na na cabeça dele. Colocaram na mão direita dele um caniço parecido com um bastão que um rei seguraria. Então ajoelharam-se na frente dele e caçoaram dele, dizendo: “Eis o rei dos judeus!” ");
INSERT INTO portft_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Continuaram cuspindo nele. Pegaram o bastão e continuaram batendo na cabeça dele. ");
INSERT INTO portft_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Quando terminaram de zombar– dele, tiraram a capa e puseram nele a sua própria roupa. Então levaram-no embora até onde iriam pregá-lo em uma cruz. ");
INSERT INTO portft_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Depois de Jesus levar a sua cruz por pouca distância, viram um homem chamado Simão, da cidade de Cirene. Obrigaram Simão a carregar a cruz para Jesus. ");
INSERT INTO portft_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Chegaram a um lugar chamado Gólgota. Esse nome significa: ‘lugar parecido com caveira’. ");
INSERT INTO portft_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ali, algo que tinha sabor muito amargo foi misturado com vinho {misturaram com vinho alguma coisa com sabor muito amargo}. Deram isso a Jesus para beber para Ele não sentir tanta dor quando o pregassem na cruz. Mas depois dele prová-lo, não quis beber. Alguns soldados levaram as roupas dele. ");
INSERT INTO portft_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Então eles O pregaram em uma cruz. Depois, dividiram as roupas dele entre si tirando a sorte com algo semelhante a dados para determinar que peça de roupa cada um receberia. ");
INSERT INTO portft_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Então os soldados se sentaram ali para guardá-lo, para que ninguém tentasse resgatá-lo. ");
INSERT INTO portft_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Prenderam à cruz acima da cabeça de Jesus um cartaz no qual tinha sido {eles tinham} escrito por que estavam pregando-o na cruz. O que escreveram foi: “Este é Jesus, o rei dos judeus’. ");
INSERT INTO portft_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Dois bandidos também foram pregados {Também pregaram dois bandidos} em cruzes. Um foi pregado em uma cruz {Pregaram um} no lado direito de Jesus e um em uma cruz no lado esquerdo. ");
INSERT INTO portft_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","As pessoas que estavam passando por ali o insultaram balançando as cabeças ––como se Ele fosse um homem mau/caçoando dele ");
INSERT INTO portft_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","e disseram: “Você disse que destruiria o templo e que depois o construiria novamente dentro de três dias! Pois se puder fazer isso, salve-se! Se você é –– o Filho de Deus/aquele que também é Deus––, desça da cruz!” ");
INSERT INTO portft_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Da mesma maneira, os chefes dos sacerdotes, aqueles que ensinavam as leis judaicas, e os anciãos caçoaram dele. Disseram: ");
INSERT INTO portft_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ele diz que salvou os outros das doenças deles, mas não pode ajudar–se a si mesmo! Ele diz que Ele é o rei de Israel. Então deve descer da cruz. Depois disso nós creremos nele! ");
INSERT INTO portft_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ele confia em Deus e diz: ––Sou o Filho de Deus/aquele que também é Deus. Se Deus tivesse prazer nele, Deus deveria resgatá-lo agora!” ");
INSERT INTO portft_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Da mesma forma, os dois bandidos que foram crucificados com Ele também O insultaram. ");
INSERT INTO portft_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ao meio dia escureceu-se por toda a terra e ficou escuro até às três horas. ");
INSERT INTO portft_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mais ou menos às três horas Jesus gritou em voz bem alta: “Eli, Eli, lemá sabactani?” Isso quer dizer: ‘Meu Deus, meu Deus, por que me abandonou?’ ");
INSERT INTO portft_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Quando alguns que estavam em pé ali ouviram a palavra ‘Eli,’ não entendendo isso, disseram: “Ele está chamando o profeta Elias!” ");
INSERT INTO portft_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Imediatamente um deles correu e pegou uma esponja, encheu-a com vinho azedo, colocou a esponja na ponta de um bastão e estendeu para que Jesus pudesse tomar o vinho dela. ");
INSERT INTO portft_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mas os outros que estavam ali disseram: “Espere! Vamos ver se Elias vem salvá-lo!” ");
INSERT INTO portft_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Então depois de Jesus gritar bem alto outra vez, Ele morreu. ");
INSERT INTO portft_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Naquele momento a cortina bem grossa que separava o lugar mais santo do resto do templo foi rasgada {rasgou-se} em dois pedaços de cima para baixo. Isso mostrou que as pessoas comuns agora podiam entrar na presença de Deus. A terra foi sacudida {tremeu} e algumas rochas grandes foram partidas {partiram}. ");
INSERT INTO portft_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Alguns túmulos foram abertos {abriram-se} e os corpos de muitas pessoas santas que tinham morrido tornaram a viver. ");
INSERT INTO portft_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Essas pessoas saíram dos túmulos e depois que Jesus ressuscitou de novo foram a Jerusalém e apareceram a muitos lá. ");
INSERT INTO portft_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Quando o oficial encarregado dos soldados que pregaram Jesus à cruz e seus soldados sentiram o terremoto e viram todas as outras coisas que aconteceram, ficaram com muito medo. Exclamaram: “Com certeza Ele era o ––Filho de Deus/homem que também era Deus!” ");
INSERT INTO portft_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Muitas mulheres estavam ali, observando a uma distância. Estas eram mulheres que acompanharam Jesus do distrito da Galileia para providenciar as coisas de que precisava. ");
INSERT INTO portft_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Entre elas estava Maria da cidade de Madalena, outra Maria que era mãe de Tiago e José e a mãe de Tiago e João. ");
INSERT INTO portft_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Quando a noite estava perto, um homem rico chamado José chegou ali. Ele era da cidade de Arimateia. Ele também era discípulo/seguidor de Jesus. ");
INSERT INTO portft_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Então ele foi a Pilatos e pediu que Pilatos o deixasse levar o corpo de Jesus e enterrá-lo. Pilatos mandou que fosse permitido a José {seus soldados deixassem José} levar o corpo. ");
INSERT INTO portft_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Então José e alguns outros levaram o corpo e enrolaram em um pano limpo e branco. ");
INSERT INTO portft_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Depois eles o puseram no próprio túmulo de José, que ele tinha cortado na rocha. Rolaram uma enorme pedra redonda e plana para a entrada do túmulo. Então foram embora. ");
INSERT INTO portft_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria da cidade de Madalena e a outra Maria estavam sentadas na frente do túmulo, observando. ");
INSERT INTO portft_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","O próximo dia foi sábado, o dia de descanso dos judeus. Os chefes dos sacerdotes e alguns dos fariseus foram a Pilatos. ");
INSERT INTO portft_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Disseram: “Senhor, nós nos lembramos que enquanto esse enganador estava vivo, Ele disse: ‘Três dias depois que eu morrer, eu viverei de novo’. ");
INSERT INTO portft_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Por isso pedimos que o senhor mande que o túmulo seja guardado {que os soldados guardem o túmulo} por três dias. Se o senhor não fizer isso, os seguidores dele podem roubar o corpo e dizer às pessoas que Ele ressuscitou dos mortos. Se enganarem as pessoas dizendo isso, será pior do que Ele mesmo enganar as pessoas antes dizendo que Ele era o Messias”. ");
INSERT INTO portft_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatos respondeu: “Podem levar alguns soldados. Vão ao túmulo e façam-no tão seguro quanto puderem”. ");
INSERT INTO portft_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Então foram e tornaram o túmulo seguro amarrando uma corda na pedra para prendê-la nos dois lados da rocha e selando-o. Também disseram aos soldados para guardarem o túmulo. ");
INSERT INTO portft_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Depois que terminou o sábado/dia de descanso dos judeus, ao amanhecer do domingo, Maria do povoado da Madalena e a outra Maria foram olhar o túmulo. ");
INSERT INTO portft_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","De repente houve um forte terremoto. Ao mesmo tempo um anjo que o Senhor/Deus mandou desceu do céu. Ele foi ao túmulo e tirou a pedra da entrada para que todos pudessem ver que o túmulo estava vazio. Então ele se sentou na pedra. ");
INSERT INTO portft_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A aparência dele era tão brilhante como um relâmpago e suas roupas eram brancas como a neve. ");
INSERT INTO portft_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Os guardas tremeram porque estavam com medo. Depois ficaram totalmente quietos, como se fossem mortos. ");
INSERT INTO portft_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","O anjo disse às duas mulheres: “Não tenham medo! Sei que vocês estão procurando Jesus, que foi pregado {que eles pregaram} em uma cruz. ");
INSERT INTO portft_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","O corpo dele não está aqui! Ele foi feito {Deus fez com que Ele esteja vivo} outra vez ressuscitando-o dos mortos, assim como Jesus lhes disse que aconteceria. Venham ver o lugar onde o corpo dele antes estava deitado! ");
INSERT INTO portft_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Em seguida, vão rápido e digam aos discípulos dele: ‘Ele viveu de novo dentre aqueles que estão mortos! Ele vai diante de vocês para o distrito da Galileia. Vocês vão vê-lo lá. Prestem atenção no que eu estou dizendo a vocês!” ");
INSERT INTO portft_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Então as mulheres saíram rápido do túmulo. Elas estavam com medo, mas também estavam muito alegres. Correram para dizer a nós, discípulos, o que tinha acontecido. ");
INSERT INTO portft_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","De repente, enquanto estavam correndo, Jesus apareceu a elas. Ele disse: “Saudações!” As mulheres chegaram perto dele. Ajoelharam-se, abraçaram os pés dele e O adoraram. ");
INSERT INTO portft_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Então Jesus disse a elas: “Não tenham medo! Vão e digam a todos ––meus discípulos/aqueles que são mais queridos por mim do que meus irmãos ––que eles devem ir à Galileia. Vão ver-me lá”. ");
INSERT INTO portft_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Enquanto as mulheres iam, alguns dos soldados que tinham guardado o túmulo foram à cidade. Eles disseram aos chefes dos sacerdotes tudo que tinha acontecido. ");
INSERT INTO portft_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Então os chefes dos sacerdotes e os anciãos dos judeus se reuniram. Fizeram um plano para explicar por que o túmulo estava vazio. Deram muito dinheiro aos soldados como propina. ");
INSERT INTO portft_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Disseram: “Digam às pessoas: ‘Os discípulos dele chegaram de noite e roubaram o corpo dele enquanto estávamos dormindo’.” ");
INSERT INTO portft_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Se isso for ouvido pelo governador {Se o governador ouvir sobre isso}, nós mesmos asseguraremos que ele não fique zangado e castigue vocês. Portanto vocês não têm que se preocupar”. ");
INSERT INTO portft_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Então os soldados aceitaram o dinheiro e fizeram como lhes foi dito {assim como os chefes dos sacerdotes e os anciãos lhes disseram}. Esta história tem sido divulgada {As pessoas têm divulgado esta história} entre os judeus até este mesmo dia em que estou escrevendo isto. ");
INSERT INTO portft_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mais tarde nós onze discípulos fomos ao distrito da Galileia. Fomos ao monte onde Jesus nos tinha dito para ir. ");
INSERT INTO portft_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nós O vimos ali e O adoramos, mas alguns de nós duvidamos que fosse realmente Jesus que tinha tornado a viver. ");
INSERT INTO portft_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Então Jesus chegou perto de nós e disse: “Toda autoridade sobre todas as coisas e todas as pessoas no céu e na terra foi dada a mim {Meu Pai me deu toda autoridade sobre tudo e todos no céu e na terra}. ");
INSERT INTO portft_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Portanto vão e, usando essa autoridade, ensinem a minha mensagem às pessoas de todas as etnias/grupos étnicos para que possam ser meus discípulos. Batizem elas para estarem debaixo da autoridade do meu Pai, de mim, o Filho dele, e do Espírito Santo. ");
INSERT INTO portft_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ensinem-nas a obedecerem a tudo quanto estou mandando vocês. Lembrem-se de que estarei com vocês para sempre, até o final desta era”. ");
INSERT INTO portft_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","As boas notícias sobre Jesus Cristo, o Filho de Deus, começam exatamente como o profeta Isaías profetizou, quando ele escreveu aquilo que Deus disse a seu Filho. Ele escreveu assim, “Escutem, vou mandar meu mensageiro adiante de você; e, bem como as pessoas preparam o caminho para uma pessoa importante, ele vai preparar as pessoas para que estejam prontas receber você. ");
INSERT INTO portft_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ele vai chamar às pessoas que vão aonde ele está no deserto, ‘Como as pessoas preparam o caminho para um oficial importante, preparem-se para receber o Senhor, e como as pessoas endireitam as veredas para um oficial importante, aprontem-se para a chegada Dele’”.  ");
INSERT INTO portft_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","João, que as pessoas chamavam o Batizador, aquele mensageiro vaticinado/dito anteriormente por Isaías, saiu para o deserto e pregava que, para Deus perdoar os pecados delas, as pessoas precisavam se arrepender antes de serem batizadas. ");
INSERT INTO portft_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Um bom número de pessoas que moravam na cidade de Jerusalém e em outras partes do distrito da Judeia foram ao deserto, onde João estava. Ali essas pessoas confessavam as coisas ruins que tinham feito, e João as batizava no Rio Jordão. ");
INSERT INTO portft_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Bem como o profeta Elias tinha feito, João vestia roupas rudes feitas de pelo de camelo; usava cinto de couro e se alimentava de gafanhotos e mel. ");
INSERT INTO portft_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ele pregava: - Daqui a pouco vai vir um homem muito importante; comparado com ele, eu não sou nada. Nem mereço ser escravo dele, ajoelhando-me para descalçar as sandálias dele. ");
INSERT INTO portft_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Eu passo água em vocês quando batizo, mas Ele vai pôr seu Espírito Santo dentro de vocês. ");
INSERT INTO portft_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Durante aquele tempo, quando João estava pregando, Jesus veio da vila de Nazaré, no distrito da Galileia. Ele foi aonde João estava pregando e foi batizado por João no Rio Jordão. ");
INSERT INTO portft_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Imediatamente depois que Jesus saiu da água, ele viu que Deus tinha aberto o céu e que o Espírito de Deus vinha sobre ele em forma de pomba. ");
INSERT INTO portft_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","E Deus falou com ele do céu, dizendo: - Você é meu Filho que muito amo; estou bem contente com você. ");
INSERT INTO portft_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","E imediatamente o Espírito de Deus mandou Jesus ao deserto. ");
INSERT INTO portft_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ali ele foi tentado por Satanás durante quarenta dias e morava entre os animais selvagens. Mas os anjos cuidavam dele. ");
INSERT INTO portft_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Depois que os soldados prenderam o João porque ele tinha ralhado com o Rei Herodes por causa do pecado deste, Jesus foi ao distrito da Galileia. Então ele pregava as boas notícias que vieram de Deus. ");
INSERT INTO portft_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ele dizia: - Já que o momento escolhido por Deus acaba de chegar, e está chegando o momento quando Deus vai reinar supremo, arrependam-se e creiam nas boas notícias para não serem rejeitados por Deus! ");
INSERT INTO portft_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ao caminhar Jesus pelo Lago Galileia, viu dois homens, Simão e seu irmão menor André. Eles estavam jogando suas redes de pescar no lago, pois eles ganhavam dinheiro pela pesca e a venda de peixes. ");
INSERT INTO portft_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Então Jesus disse a eles: - Bem como vocês costumavam pegar peixes, venham comigo e eu farei vocês pregadores para que essas pessoas também possam ser meus discípulos. ");
INSERT INTO portft_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Imediatamente, eles largaram o trabalho com as redes e acompanharam Jesus. ");
INSERT INTO portft_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Depois de andarem um pouco mais, Jesus viu outros homens; dois deles eram Tiago e seu irmão menor João, os quais eram filhos de Zebedeu. Eles estavam num barco, consertando suas redes. ");
INSERT INTO portft_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","E imediatamente, ele chamou os dois para irem com ele. Eles deixavam seu pai Zebedeu, que ficou no barco com os empregados, e se foram com Jesus. ");
INSERT INTO portft_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus e os discípulos chegaram na vila de Cafarnaum. No próximo sábado, após entrar na sinagoga, Jesus começou a ensinar as pessoas ali reunidas. ");
INSERT INTO portft_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Elas se admiravam do ensino dele, pois ensinava com autoridade; especificamente, ele não ensinava somente o que os outros ensinavam, como os professores da lei que Deus tinha dado a Moisés. ");
INSERT INTO portft_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","De repente, enquanto ele ensinava, apareceu na sinagoga um homem dominado por um espírito mau. O homem gritou: ");
INSERT INTO portft_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","– Jesus, que vem da vila de Nazaré, nós não temos nada em comum. Portanto, não mexa conosco, os espíritos maus! Não nos destrua ainda! Sei quem é você. Sei que você é o Santo que vem de Deus. ");
INSERT INTO portft_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus repreendeu o espírito mau, dizendo: - Fique calado! Saia desse homem! ");
INSERT INTO portft_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","O espírito mau sacudiu o homem; gritou em voz alta, e depois saiu do homem e do local. ");
INSERT INTO portft_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Todas as pessoas ali reunidas ficaram espantadas, e passaram a falar entre si, dizendo: - É incrível! Ele ensina de uma maneira nova e com autoridade; não somente faz coisas milagrosas como também manda nos espíritos maus e eles lhe obedecem! ");
INSERT INTO portft_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","As pessoas contaram imediatamente a muitos outros, por todo o distrito da Galileia, o que Jesus tinha feito. ");
INSERT INTO portft_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Depois de saírem da sinagoga, Jesus, Simão e André, em companhia de Tiago e João, foram logo para casa de Simão e André. ");
INSERT INTO portft_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A sogra de Simão estava de cama porque tinha febre. Alguém informou Jesus da doença dela. ");
INSERT INTO portft_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ele foi ter com ela e a levantou pela mão. Ela ficou boa da febre na hora, e passou a servir uma refeição a eles. ");
INSERT INTO portft_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","À tardinha, depois do pôr-do-sol, algumas pessoas levaram a Jesus muitos doentes e outros que tinham espíritos maus. ");
INSERT INTO portft_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Parecia que todos os habitantes da vila estavam reunidos à porta da casa. ");
INSERT INTO portft_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","E Jesus curou muitos doentes de todo tipo de doenças e expulsou muitos espíritos maus das pessoas; ele não deixava os espíritos maus falarem sobre ele, porque eles sabiam que ele tinha vindo de Deus. ");
INSERT INTO portft_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jesus se levantou bem cedo no dia seguinte, enquanto ainda estava escuro. Ele saiu da casa e da vila, e foi para um lugar onde não havia gente; lá ele começou a orar. ");
INSERT INTO portft_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simão e seus companheiros foram procurar Jesus e lá o encontraram. Logo eles disseram a ele: ");
INSERT INTO portft_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","– Já que muitas pessoas de Cafarnaum estão procurando você, volte conosco para ajudá-las. ");
INSERT INTO portft_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ele disse a eles: – Não, vamos às vilas que ficam perto daqui para eu pregar lá também, pois foi para pregar a muitas pessoas que vim ao mundo. ");
INSERT INTO portft_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ele andava por todo o distrito da Galileia, pregando nas sinagogas e expulsando espíritos maus das pessoas. ");
INSERT INTO portft_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Um dia um leproso veio a Jesus. Ele se ajoelhou diante de Jesus e fez o seguinte pedido a ele: - Se você quiser me curar, faça por favor, pois sei que é capaz de fazer. ");
INSERT INTO portft_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Por ter pena dele, Jesus deixou de lado os tabus contra contatos com leprosos, estendeu a mão e tocou no leproso; depois disse a ele: - Já que estou disposto a curar você, seja curado! ");
INSERT INTO portft_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Imediatamente o homem deixou de ser leproso e foi curado. ");
INSERT INTO portft_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Para ele fazer as coisas necessárias para garantir contatos com as demais pessoas, Jesus falou severamente com ele antes de o mandar embora. ");
INSERT INTO portft_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Jesus disse: - Não conte a ninguém o que aconteceu. Ao invés disso, vá ao sacerdote em Jerusalém e peça para ele fazer um exame em você para verificar a sua cura. Leve para ele aquilo que Moisés mandou que os curados oferecessem, como sacrifício a Deus e também para que os moradores, depois de ouvirem o que o sacerdote diz, possam saber que você foi curado. ");
INSERT INTO portft_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Porém, depois que o homem se foi e consultou o sacerdote, ele começou a contar a muitas pessoas como Jesus o tinha curado. Como resultado, Jesus já não podia entrar abertamente em nenhuma vila por causa das multidões que o cercavam. Ao invés disso, ele ficava fora das vilas, em lugares onde não havia gente. E as pessoas vinham a ele de toda aquela região. ");
INSERT INTO portft_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Uns poucos dias depois, quando Jesus e seus discípulos já estavam de volta na vila de Cafarnaum, muitas pessoas se congregaram lá pois ouviram dizer que ele estava em casa. Por isso não havia mais espaço para a gente ficar, nem à porta, pois a casa estava cheia. Jesus pregou a mensagem de Deus. ");
INSERT INTO portft_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Algumas pessoas trouxeram a Jesus um paralítico. Quatro homens carregavam o doente numa maca. ");
INSERT INTO portft_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Eles não puderam apresentar o homem a Jesus por causa da multidão de pessoas em volta dele. Por isso subiram ao telhado (que é tipo uma laje) e tiraram uma parte dele bem por cima de onde Jesus estava. Então, depois de fazer um buraco no teto, eles desceram o doente na maca segurada de cordas, bem na frente de Jesus. ");
INSERT INTO portft_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Quando Jesus viu que os homens acreditavam que ele tinha poder para curar esse homem, ele disse ao paralítico: - Amigo, perdoo os seus pecados. ");
INSERT INTO portft_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Havia no grupo alguns professores da lei que Deus tinha dado a Moisés, que começaram a pensar assim: ");
INSERT INTO portft_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","– Este homem fala erradamente. Parece que ele está insultando Deus, pois nenhuma pessoa pode perdoar pecados; só Deus pode perdoar pecados. ");
INSERT INTO portft_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sabendo Jesus que eles assim pensavam, disse a eles: - Vocês questionam erradamente entre si se tenho o direito de perdoar os pecados deste homem. ");
INSERT INTO portft_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Não é perigoso alguém dizer a um paralítico, “Perdoo os seus pecados”, pois ninguém pode provar que tal coisa aconteceu. Mas é bem perigoso alguém dizer a ele, “Levante-se, pegue a sua maca e vá embora”, porque as pessoas bem podem observar se ele conseguiu curar o paralítico ou não. ");
INSERT INTO portft_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Portanto, vou fazer alguma coisa para mostrar a vocês que eu, o homem que veio do céu, tenho autoridade de Deus para perdoar pecados na terra e também curar as pessoas. Então ele disse ao paralítico: ");
INSERT INTO portft_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","– Digo a você, “Levante-se! Pegue sua maca! Volte para casa!” ");
INSERT INTO portft_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","O homem se levantou imediatamente, pegou a sua maca e foi embora, enquanto todas as pessoas ficavam olhando. Todo o mundo ficou espantado; todos louvaram a Deus, dizendo: - Nunca vimos nada como aquilo que acaba de acontecer. ");
INSERT INTO portft_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus deixou novamente a vila de Cafarnaum e foi andando à beira do lago da Galileia. Muita gente se reuniu em volta dele. Então ele passou a ensinar o grupo. ");
INSERT INTO portft_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mais adiante, ele viu um homem chamado Levi, filho de Alfeu. Levi estava sentado no seu lugar de trabalho, pois ele era cobrador de impostos para os governantes da terra de Roma. Jesus disse a ele: - Venha comigo e seja meu discípulo. Por isso Levi se levantou e acompanhou Jesus. ");
INSERT INTO portft_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mais tarde, Jesus estava fazendo uma refeição em casa de Levi. Muitos cobradores de impostos para os governantes da terra de Roma e outros, chamadas de pecadores comuns, comiam com Jesus e os seus discípulos. Isso não era de surpreender, pois muita gente desse tipo costumava acompanhar Jesus. ");
INSERT INTO portft_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Os professores da lei que Deus tinha dado a Moisés que estavam lá, membros da seita dos fariseus, viram que Jesus fazia sua refeição com os cobradores de impostos e outros de má fama; eles disseram aos discípulos dele: – É uma pena que ele coma com os cobradores de impostos e outras pessoas que pecam constantemente. ");
INSERT INTO portft_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Quando Jesus ouviu o que eles diziam, ele disse aos professores da lei que Deus tinha dado a Moisés: - As pessoas que se acham sadias não procuram médico; pelo contrário, são os doentes que procuram médico. Ele disse isso para indicar que eram as pessoas que se achavam pecadoras que vinham pedir a ajuda dele. E ele disse: - Não vim convidar as pessoas que se consideram boas para serem perdoadas. Pelo contrário, vim convidar as pessoas que sabem dos seus próprios pecados para que possam vir a mim e ser perdoadas. ");
INSERT INTO portft_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Os discípulos de João o batizador e alguns fariseus estavam jejuando naquele tempo. As pessoas vieram a Jesus e depois fizeram a ele esta pergunta em tom de crítica: - Por que os discípulos de João e os fariseus jejuam, mas os seus discípulos não jejuam? ");
INSERT INTO portft_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Para mostrar que não estava bom os discípulos dele mostrarem dor ou mágoa enquanto ele estava com eles, Jesus disse: - Os amigos do noivo que vai casar não vão jejuar enquanto o noivo está com eles, certo? Claro que não vão fazer assim. Durante os dias que o noivo está com eles, eles não jejuam porque estão bem contentes. ");
INSERT INTO portft_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mas vai chegar um dia quando o noivo vai ser tirado deles pelos inimigos dele. Naqueles dias, eles vão jejuar porque vão sentir muita mágoa/tristeza. ");
INSERT INTO portft_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","E ele disse: - Ninguém costura um retalho de pano novo, que não encolheu ainda, numa roupa velha para remendar esta roupa; se assim fizesse, depois da lavagem o retalho novo vai encolher e rasgar a roupa velha, aumentando o buraco. ");
INSERT INTO portft_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ninguém despeja vinho novo em couros velhos porque, se assim fizesse, ia rebentar os couros velhos quando o vinho novo fermentasse e expandisse. E como resultado, tanto o vinho quanto os couros ficariam estragados. Pelo contrário, a gente deve despejar vinho novo em couros novos. Ele disse estas parábolas para mostrar que, se eles quisessem viver de acordo com a mensagem de Deus, que ele pregava a eles, não poderiam ao mesmo tempo mandar que as pessoas guardassem suas antigas tradições, como o jejum. ");
INSERT INTO portft_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Um sábado, Jesus com seus discípulos atravessavam uma plantação de cereais. Enquanto os discípulos andavam pelo caminho no meio da plantação, eles colhiam e comiam grãos de trigo. A lei de Moisés permitia que as pessoas assim fizessem se estavam realmente com fome. ");
INSERT INTO portft_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Alguns dos fariseus disseram a ele: - Olhe! Eles não devem trabalhar no dia de sábado, pois nossa lei proíbe isso. ");
INSERT INTO portft_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Para mostrar a eles, com base nas Escrituras, que não deviam condenar os discípulos, Jesus disse a eles: - Vocês leram as Escrituras, mas não entenderam direito o que nosso antepassado, o Rei Davi, fez quando ele precisava de comida e tanto ele quanto os seus companheiros tinham fome. ");
INSERT INTO portft_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Naquela ocasião, depois de entrar na casa de Deus durante os dias do grande sacerdote Abiatar e receber da mão dele, Davi comeu dos pães oferecidos a Deus, que a lei de Moisés manda somente aos sacerdotes comerem. Depois, ele também deu daquele pão especial aos seus companheiros. ");
INSERT INTO portft_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","E Jesus também disse a eles: - O dia de sábado foi estabelecido por mim/Deus para ajudar as pessoas; as pessoas não foram criadas para servir o dia de sábado. ");
INSERT INTO portft_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Portanto eu, o homem que veio do céu, posso determinar aquilo que meu povo pode fazer no dia de sábado. ");
INSERT INTO portft_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesus entrou de novo na sinagoga. Lá havia um homem cuja mão estava aleijada. ");
INSERT INTO portft_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Alguns fariseus observavam com cuidado para ver se ele ia curar esse homem no dia de sábado. Eles fizeram assim para depois dizer que ele tinha desobedecido a lei dos judeus por trabalhar no sábado. ");
INSERT INTO portft_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus disse ao homem cuja mão estava aleijada: - Levante-se diante de todo o mundo. E o homem se levantou. ");
INSERT INTO portft_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Então Jesus disse aos fariseus: - A lei que Deus deu a Moisés permite que as pessoas façam boas coisas no dia de sábado, ou que façam coisas ruins? Especificamente, a lei nos permite curar uma pessoa no dia de sábado, ou nos permite ferir alguém? Mas eles não responderam. ");
INSERT INTO portft_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ele olhou para eles com raiva, e por estar realmente magoado pela insensibilidade deles para com o homem necessitado, disse ao homem: - Estenda a mão! Quando o homem estendeu a mão, ela foi curada na hora. ");
INSERT INTO portft_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Depois de sair da sinagoga, os fariseus se reuniram com alguns dos judeus que apoiavam o Rei Herodes Antipas, que governava o distrito da Galileia; eles começaram a planejar a morte de Jesus. ");
INSERT INTO portft_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus e os seus discípulos deixaram aquela região e foram para mais perto do Lago Galileia para evitar as multidões. Mas uma grande multidão de pessoas o acompanhavam; elas vinham do distrito da Galileia ");
INSERT INTO portft_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","e da cidade de Jerusalém, bem como de outras cidadezinhas do distrito da Judeia, do distrito de Idumeia, da região a leste do Rio Jordão e da vizinhança das cidadezinhas de Tiro e Sidom. Esta grande multidão veio ter com ele porque tinha ouvido sobre aquilo que ele fazia. ");
INSERT INTO portft_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Por isso, mandou os discípulos aprontarem um barquinho para ele entrar e dali ensinar, evitando assim ser esmagado pela multidão. ");
INSERT INTO portft_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ele tinha curado muitas pessoas, e por isso as pessoas que sofriam diversas doenças se adiantavam para, tocando nele, serem curadas. ");
INSERT INTO portft_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sempre que os espíritos maus viam Jesus, eles faziam as pessoas que habitavam caírem diante de Jesus, mostrando seu respeito por ele e exclamando: - Você é o Filho de Deus! ");
INSERT INTO portft_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ele mandou severamente aos espíritos maus que não revelassem que ele era o Filho de Deus. ");
INSERT INTO portft_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus subiu um monte. Depois, ele chamou os homens que ele queria e eles vieram a ele. ");
INSERT INTO portft_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ele escolheu doze homens, que chamou apóstolos, para o acompanharem e serem enviados para pregar; ");
INSERT INTO portft_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ele deu a eles poder para expulsar espíritos maus das pessoas. ");
INSERT INTO portft_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Especificamente, ele escolheu estes doze homens: Simão, a quem acrescentou o novo nome de Pedro; ");
INSERT INTO portft_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tiago, o filho de Zebedeu, e João, o irmão menor dele, aos quais acrescentou o novo nome de Boanerges, que significa homens que atuam violentamente como trovão; ");
INSERT INTO portft_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","André; Filipe; Bartolomeu; Mateus; Tomé; Tiago, o filho de Alfeu; Tadeu; outro Simão, que era membro do partido nacionalista que pregava a rebelião contra o governo romano; ");
INSERT INTO portft_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","e Judas, que era da vila de Cariote, que depois traiu Jesus em mãos dos seus inimigos. ");
INSERT INTO portft_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesus se foi para casa com seus discípulos. Mais uma vez, uma multidão se reuniu lá onde ele estava, e muitas pessoas se apinhavam em volta dele; por isso ele e seus discípulos não tinham tempo para comer ou fazer qualquer outra coisa. ");
INSERT INTO portft_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Depois que seus parentes souberam disso, eles foram buscar Jesus porque as pessoas diziam que ele estava louco. ");
INSERT INTO portft_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Enquanto eles iam em busca de Jesus, os professores da lei que Deus tinha dado a Moisés que vieram da cidade de Jerusalém ouviram que Jesus estava expulsando demônios. Eles começaram a dizer às pessoas: - Jesus está dominado por Satanás. É pelo poder recebido daquele que governa os espíritos maus que ele expulsa todos os espíritos maus das pessoas. ");
INSERT INTO portft_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesus chamou os professores da lei que Deus tinha dado a Moisés, e eles se congregaram em volta dele; depois ele falou com eles, usando comparações. Para convencê-los de que Satanás não ia se opor aos seus próprios espíritos maus e que, expulsando esses espíritos, ele mesmo Jesus era muito mais poderoso que Satanás, Jesus disse: – É absurda a sugestão de vocês de que Satanás fosse expulsar seus próprios espíritos maus. ");
INSERT INTO portft_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Se as pessoas que moram no mesmo país lutam umas contra as outras, elas não podem mais ser governadas por uma autoridade central. ");
INSERT INTO portft_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","E se as pessoas que moram na mesma casa brigam umas com as outras, a sua família não pode mais continuar juntas. ");
INSERT INTO portft_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Da mesma forma, se Satanás e seus espíritos maus fossem brigar um contra o outro, ao invés de ficar forte, ele ia se tornar fraco. ");
INSERT INTO portft_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Em contraste com as suas alegações, ninguém que arromba a casa de um forte como Satanás pode roubar as posses do homem forte se não amarra primeiro aquele forte. Mas, depois de amarrá-lo, ele pode roubar as posses do mais forte. ");
INSERT INTO portft_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Jesus disse também: - Pensem bem nisso. As pessoas podem pecar de muitas maneiras; podem falar mal de Deus, e Deus pode perdoar esse pecado. ");
INSERT INTO portft_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mas, se alguém falar contra o Espírito Santo, Deus nunca vai perdoar esse pecado. Tal pessoa é culpada eternamente do pecado. ");
INSERT INTO portft_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesus disse isso porque os professores da lei que Deus tinha dado a Moisés diziam: – Já que ele expulsa os espíritos maus, um espírito mau está controlando ele mesmo, ao invés de confessarem que ele assim fazia pelo poder do Espírito Santo. ");
INSERT INTO portft_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Chegaram a mãe e os irmãos de Jesus. Enquanto permaneciam do lado de fora da casa, mandaram alguém chamar Jesus para vir falar com eles. ");
INSERT INTO portft_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Uma multidão estava sentada em volta dele. Uma das pessoas lhe disse: - Escute, sua mãe e seus irmãos e irmãs estão lá fora e estão procurando você. ");
INSERT INTO portft_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesus respondeu a eles: - Escutem o que tenho para dizer sobre minha mãe e meus irmãos. ");
INSERT INTO portft_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Depois de olhar para os discípulos que estavam sentados em volta dele num círculo, ele disse: - Olhem! Estes são tão importantes para mim quanto minha mãe e meus irmãos, ");
INSERT INTO portft_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","pois qualquer pessoa que costuma fazer o que Deus deseja é, espiritualmente, tão achegado a mim quanto meu irmão, minha irmã ou minha mãe. ");
INSERT INTO portft_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus desceu de novo ao Lago da Galileia e começou a ensinar as pessoas. Enquanto fazia isso, uma grande multidão se congregou em volta dele. Por isso ele entrou num barco no lago, e lá se sentou para poder ensinar a multidão desde o próprio barco. Ao mesmo tempo, a multidão ficava na praia, perto do lago. ");
INSERT INTO portft_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Então ele ensinou muitas coisas às pessoas por meio de comparações e exemplos. Durante o ensino, ele lhes contou este exemplo: ");
INSERT INTO portft_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","– Pensem sobre o significado da seguinte parábola: Um fazendeiro saiu ao campo dele para semear. ");
INSERT INTO portft_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ao semear, uma parte da semente caiu na pista e ficou exposta. Então vieram alguns pássaros e comeram aquela semente. ");
INSERT INTO portft_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Outra parte da semente caiu nas pedras, onde faltava solo. Logo as sementes brotaram porque o sol esquentava rapidamente o solo pouco profundo. ");
INSERT INTO portft_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Depois, quando o sol subiu alto, as plantinhas se queimaram e murcharam por falta de raízes profundas. ");
INSERT INTO portft_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Enquanto esse homem semeava, outra parte da semente caiu num solo contendo muitas raízes de espinhos. Os espinhos cresceram e sufocaram as plantinhas, após a semente germinar. Portanto, a(s) semente/plantinhas não produziram grãos. ");
INSERT INTO portft_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","E enquanto ele semeava, outra parte da semente caiu numa terra bem boa. Como resultado, ela brotou, cresceu, e chegou a produzir muitíssimo fruto. Especificamente, algumas das plantas deram 30 grãos, outras deram 60 grãos e algumas deram 100 grãos. ");
INSERT INTO portft_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Então Jesus disse: - Se vocês quiserem entender isto, devem considerar com cuidado aquilo que acabam de ouvir. ");
INSERT INTO portft_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Depois disso, quando Jesus estava sozinho, os doze discípulos e outras pessoas que acompanhavam Jesus lhe perguntaram sobre o significado da parábola. ");
INSERT INTO portft_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ele disse a eles: - A vocês faço entender como Deus reina soberano, algo que antigamente não se entendia. Mas digo isto somente em figuras àqueles que ainda não se submeteram às regras de Deus. ");
INSERT INTO portft_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Como resultado, é bem como o profeta escreveu: “Embora eles vejam o que faço, e ouvem o que falo, não entendem o significado; por isso não se arrependem dos seus pecados para que Deus possa perdoar”. ");
INSERT INTO portft_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Também disse a eles: - Fico decepcionado por vocês não entenderem este exemplo, pois se não entendem isto com certeza não vão entender nenhuma das minhas outras parábolas. Portanto, vou explicar a vocês. ");
INSERT INTO portft_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","No exemplo que contei, o fazendeiro que semeia os grãos representa uma pessoa que declara a mensagem de Deus. ");
INSERT INTO portft_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Acontece com algumas pessoas que ouvem a mensagem de Deus exatamente aquilo que aconteceu à semente que caiu na pista. Especificamente, ao ouvirem a mensagem, vem logo Satanás e faz com que se esqueçam daquilo que ouviram. ");
INSERT INTO portft_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Acontece com outras pessoas exatamente aquilo que aconteceu quando a semente caiu na terra cheia de pedras, sem muito solo. Especificamente, embora recebam com alegria a mensagem de Deus, ");
INSERT INTO portft_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","creem apenas superficialmente na mensagem dele; portanto, como as plantas que precisam de boas raízes, eles creem na mensagem de Deus por pouco tempo. O que acontece é que, quando outras pessoas causam sofrimento para estas pessoas, ou quando são perseguidas por outros, elas logo deixam de crer na mensagem de Deus. ");
INSERT INTO portft_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Acontece com outras pessoas exatamente o que aconteceu à semente que caiu na terra contendo raízes de espinhos. Especificamente, embora tais pessoas ouçam a mensagem de Deus, ");
INSERT INTO portft_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","elas se preocupam somente sobre aquilo que pertence a este mundo porque desejam ser ricas, possuindo muitas outras coisas; o resultado é que elas se esquecem da mensagem de Deus e deixam de fazer as coisas que agradam a Deus durante as suas vidas. ");
INSERT INTO portft_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Finalmente, acontece com outras pessoas exatamente o que aconteceu quando a semente caiu na terra boa. Especificamente, por ouvirem a mensagem de Deus, aceitando e acreditando aquilo que ouviram, elas fazem as coisas que agradam a Deus durante as suas vidas, como as boas plantas que produziram 30, 60 ou 100 grãos. ");
INSERT INTO portft_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ele também disse a eles em figuras: - As pessoas não acendem uma lamparina para depois trazer para casa e colocar debaixo de um cesto ou de uma cama. Ao invés disso, elas acendem a lamparina para colocar num lugar onde possa iluminar a casa. ");
INSERT INTO portft_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","De igual forma, Deus deseja que tudo que as demais pessoas ainda não sabem sobre a mensagem dele, mas que vocês já sabem, seja divulgado a elas mais tarde; quer dizer, que tudo aquilo que ainda é segredo para elas agora possa ser bem conhecido depois. ");
INSERT INTO portft_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Se vocês quiserem entender isto, devem considerar com cuidado aquilo que acabam de ouvir. ");
INSERT INTO portft_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Então ele disse a eles: - Pensem bem naquilo que digo a vocês, pois Deus vai deixar que vocês entendam na medida em que prestam atenção naquilo que digo, e Deus vai fazer com que vocês entendam ainda mais. ");
INSERT INTO portft_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Quando alguém presta atenção naquilo que digo e entende bem, Deus vai capacitá-lo para entender mais; mas, quando uma pessoa não presta atenção naquilo que digo, vai esquecer até aquilo que já sabe. ");
INSERT INTO portft_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus disse também: – Vou ilustrar como vai crescer aos poucos o número de pessoas sobre quem Deus governa soberanamente, até o dia quando Deus vai julgar as pessoas. Um homem planta sementes no solo. ");
INSERT INTO portft_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Depois ele dorme todas as noites e se levanta todos os dias sem se preocupar. Ao mesmo tempo, as sementes brotam, crescem e produzem frutos, não sabendo ele como isso aconteceu. ");
INSERT INTO portft_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Especificamente, os talos aparecem, depois as espigas e, por último, o grão cheio na espiga. ");
INSERT INTO portft_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Quando os grãos estão maduros, ele manda ceifeiros pois está na hora de ceifar os grãos. ");
INSERT INTO portft_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Depois Jesus falou com um exemplo: – Vou falar com vocês usando outro exemplo para mostrar como o número de pessoas governadas por Deus de forma soberana vai aumentar; espero que este exemplo possa mostrar isso a vocês. ");
INSERT INTO portft_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","O número de pessoas aumenta como cresce uma sementinha de mostarda. ");
INSERT INTO portft_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mesmo sendo uma das menores sementes da terra, ela se torna uma planta imensa quando crescida. Especificamente, é plantada, logo brota e fica sendo a maior das plantas anuais. Ela bota grandes ramos, tão grandes que os pássaros podem fazer ninhos à sombra dela. ");
INSERT INTO portft_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Com muitos exemplos como estes, Jesus falou de Deus às pessoas. Ele lhes contou tudo quanto eram capazes de entender. ");
INSERT INTO portft_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ele falava com as pessoas somente através de exemplos, mas explicava todas as comparações aos seus próprios discípulos em particular. ");
INSERT INTO portft_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Naquele mesmo dia, ao anoitecer, Jesus disse aos seus discípulos: - Vamos no barquinho ao outro lado do Lago da Galileia. ");
INSERT INTO portft_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Eles deixaram a multidão e entraram no barco, onde Jesus se encontrava, sem outros preparativos; logo depois saíram. Outras pessoas iam com eles em outros barcos. ");
INSERT INTO portft_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Começou a soprar um vento forte, e as ondas estavam entrando no barco; assim, o barco logo ficou quase cheio de água. ");
INSERT INTO portft_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus ficava na popa do barco, dormindo, com a cabeça numa almofada. Por isso eles o acordaram e disseram: - Mestre, você deve estar preocupado, pois logo vamos morrer! ");
INSERT INTO portft_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus se levantou e ordenou ao vento e às ondas: - Calma! Fiquem quietos! O vento parou, e o lago ficou bem calmo. ");
INSERT INTO portft_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ele disse aos discípulos: - Estou decepcionado por causa do medo de vocês, pois nem acreditam que posso salvá-los. ");
INSERT INTO portft_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Eles ficaram espantados e disseram uns aos outros: - Que homem maravilhoso! Não somente os demônios, como também o vento e as ondas, obedecem a ele! ");
INSERT INTO portft_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesus e seus discípulos chegaram ao lado leste do Lago da Galileia, à região de Gerasa, e lá desembarcaram. ");
INSERT INTO portft_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Havia um homem naquela região que saiu de uma das cavernas onde se enterram os mortos; ele estava dominado por um espírito mau. ");
INSERT INTO portft_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Esse homem costumava morar nas cavernas, e por ser ele violento todo o mundo tinha medo dele; as pessoas o tinham amarrado com correntes. Quando ele ficou ainda mais violento, ninguém pôde mais com ele, nem com correntes, ");
INSERT INTO portft_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","pois ele costumava rebentar todas elas e esmagar os grilhões de ferro que tinha nos pés. ");
INSERT INTO portft_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Noite e dia, ele gritava entre as cavernas e ladeiras e se feria com pedras. ");
INSERT INTO portft_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Quando Jesus saiu do barco, esse homem o viu de longe e foi correndo até ele. Então ele se ajoelhou diante de Jesus para reverenciar. ");
INSERT INTO portft_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Jesus disse ao espírito mau: - Espírito mau, saia desse homem! ");
INSERT INTO portft_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","O espírito mau gritou em voz alta: - Jesus, Filho do grande Deus, me deixe em paz. Peço para você prometer não me punir/Faça assim, dizendo, “Que Deus me puna se eu punir você”. ");
INSERT INTO portft_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Já que o demônio não saiu logo do homem, para lidar melhor com ele Jesus perguntou: - Como é seu nome? Ele respondeu: - Meu nome é Multidão, pois somos muitos Espírito maus neste homem. ");
INSERT INTO portft_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Os espíritos maus rogaram a Jesus que não os mandasse para fora da região. ");
INSERT INTO portft_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ao mesmo tempo, uma grande manada de porcos pastava ali perto na ladeira. ");
INSERT INTO portft_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Os espíritos maus pediram a Jesus: - Mande-nos aos porcos para entrarmos neles! ");
INSERT INTO portft_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ele os deixar fazer assim. Por isso os espíritos maus saíram do homem e entraram nos porcos. A manada, de uns 2.000 porcos, correu ladeira abaixo, para dentro do lago, e lá todos eles se afogaram. ");
INSERT INTO portft_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Os homens que cuidavam dos porcos fugiram e contaram na vila e nas pequenas aldeias o que tinha acontecido. Muitas pessoas saíram para ver o que tinha ocorrido; ");
INSERT INTO portft_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","elas chegaram ao lugar onde Jesus estava, e lá viram o homem que antes estava dominado por muitos espíritos maus. Ele estava sentado ali, vestido e no seu perfeito juízo. Como resultado disso, aquelas pessoas se assustaram, pois se deram conta do grande poder de Jesus. ");
INSERT INTO portft_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Depois, as pessoas que tinham visto o que havia ocorrido descreveram tudo aquilo ao homem antes dominado pelos espíritos maus; também descreveram o que tinha acontecido com os porcos. ");
INSERT INTO portft_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aquelas pessoas imploraram para Jesus sair da sua região. ");
INSERT INTO portft_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ao entrar Jesus no barco para sair, o homem antes dominado pelos espíritos maus pediu para Jesus o deixar acompanhá-lo. ");
INSERT INTO portft_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mas Jesus não o deixou sair com ele. Pelo contrário, Jesus disse a ele: - Volte para casa, para sua família, e conte o que o Senhor fez por você e como foi bom para com você. ");
INSERT INTO portft_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","O homem saiu e foi proclamar nas Dez Cidades o que Jesus tinha feito por ele. Todas as pessoas que ouviram as palavras do homem ficaram admiradas. ");
INSERT INTO portft_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Depois de Jesus sair novamente num barco, dirigindo-se ao outro lado do Lago da Galileia com seus discípulos, uma grande multidão se congregou em volta dele à beira do lago. ");
INSERT INTO portft_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Uma das pessoas, um chefe de sinagoga cujo nome era Jairo, chegou e quando viu Jesus se prostrou aos pés dele. ");
INSERT INTO portft_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Logo começou a clamar a Jesus: - Já que minha filha está doente e quase morta, venha por favor até a minha casa e coloque as suas mãos nela para que ela possa ser curada por você e não morra. ");
INSERT INTO portft_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Por isso Jesus e os discípulos se foram com Jairo. Uma multidão seguiu a Jesus e o apertava. ");
INSERT INTO portft_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Havia uma mulher no grupo que tinha sangrado muito de um problema menstrual durante doze anos ");
INSERT INTO portft_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","e que tinha sofrido muito por causa dos tratamentos médicos; mesmo gastando todo seu dinheiro para pagar os médicos, não recebeu nenhuma ajuda deles. ");
INSERT INTO portft_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Quando ela ouviu que Jesus curava as pessoas, ela se chegou por trás dele; ");
INSERT INTO portft_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","logo ela pensou: - Se eu tocar no corpo ou na roupa dele, ele vai me curar. Por isso ela tocou na roupa de Jesus. ");
INSERT INTO portft_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Logo ela parou de sangrar e, ao mesmo tempo, ela sentiu dentro de si que algo ou alguém tinha curado a sua doença. ");
INSERT INTO portft_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Logo Jesus sentiu dentro de si que tinha saído dele poder de cura. Por isso ele se virou no meio da multidão e perguntou: - Quem tocou minha roupa? ");
INSERT INTO portft_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Um dos discípulos respondeu: - Você está vendo que muita gente está apertando você, por isso nos surpreende que pergunte, “Quem me tocou?” porque provavelmente muitas pessoas tocaram em você. ");
INSERT INTO portft_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesus continuava olhando em volta para descobrir quem tinha feito isso. ");
INSERT INTO portft_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A mulher estava medrosa e tremia, mas por saber o que lhe tinha ocorrido ela se aproximou de Jesus e se prostrou diante dele; então ela lhe disse toda a verdade sobre tudo que ela tinha feito. ");
INSERT INTO portft_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ele disse a ela: - Dona, por causa da sua fé em mim, curei você. Vá em paz e seja curada, pois eu lhe prometo que não vai ficar mais doente assim. ");
INSERT INTO portft_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Enquanto Jesus ainda falava com essa mulher, chegaram algumas pessoas da casa de Jairo, o chefe da sinagoga. Disseram a Jairo: - Sua filha acaba de morrer; portanto, não adianta incomodar mais o mestre, pedindo que ele vá até a sua casa. ");
INSERT INTO portft_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mas quando Jesus ouviu o que esses homens disseram, disse a Jairo: - Não tenha medo! Creia somente que ela vai ficar boa. ");
INSERT INTO portft_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ele deixou somente três pessoas acompanhá-lo até a casa de Jairo: Pedro, Tiago e João, o irmão menor de Tiago. ");
INSERT INTO portft_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Quando eles chegaram na casa, Jesus viu que as pessoas ali reunidas estavam em confusão e chorando em voz alta. ");
INSERT INTO portft_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ele entrou na casa e disse ao grupo, metaforicamente e sabendo que ele ia dar vida à moça: - Não fiquem nessa confusão! Parem de chorar! A moça não está morta; ela está só dormindo. ");
INSERT INTO portft_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","As pessoas se riam dele, pois sabiam que ela estava morta. Depois de mandar todas as demais pessoas para fora da casa, ele chamou o pai e a mãe da moça e os seus três discípulos e eles entraram no quarto onde a moça estava deitada. ");
INSERT INTO portft_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ele pegou da mão dela e lhe disse na língua aramaica: - Talitá cumi! (que significa, “Menina, levante-se!”) ");
INSERT INTO portft_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","A moça, que tinha doze anos, levantou-se logo e começou a andar. Quando isto aconteceu, todos os presentes ficaram admirados. ");
INSERT INTO portft_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesus ordenou claramente que eles não contassem a ninguém o que ele tinha feito. Depois mandou que trouxessem comida para a moça. ");
INSERT INTO portft_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus saiu daquela região da cidade de Cafarnaum e foi à sua vila natal de Nazaré. E seus discípulos foram com ele. ");
INSERT INTO portft_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","No dia de sábado, ele entrou na sinagoga e ensinou o povo. Muitas das pessoas que o ouviram ficaram admiradas. Especificamente, alguns dos ouvintes diziam, -Dificilmente vamos acreditar que este homem possa nos ensinar sobre estas coisas, que Deus o tenha feito muito sábio e que ele esteja praticando tais milagres; ");
INSERT INTO portft_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","este homem não passa de uma pessoa comum, como nós. Quer dizer, ele é somente um carpinteiro comum. Ele é o filho da Maria e o irmão maior de Tiago, José, Judas e Simão; suas irmãs menores moram aqui entre nós. Assim, eles ficaram ofendidos com ele. ");
INSERT INTO portft_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesus disse a eles: -Os profetas são honrados em muitos lugares; mas as pessoas que moram nas vilas natais deles – seus parentes e vizinhos nas suas próprias casas – não os honram. Está acontecendo assim comigo. ");
INSERT INTO portft_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mesmo curando uns poucos doentes naquele lugar, tocando-os, ele não pôde fazer muitos milagres ali porque as pessoas não acreditavam nele. ");
INSERT INTO portft_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","E ele ficou admirado da falta de fé dessas pessoas. ");
INSERT INTO portft_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Enquanto ele assim fazia, chamou os doze discípulos e começou a mandá-los dois a dois a diversas vilas. Especificamente, antes de mandá-los, ele os capacitou para expulsar espíritos maus das pessoas. ");
INSERT INTO portft_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Também os mandou levar consigo somente uma bengala para a viagem. Deu ordens para não levarem comida, nem sacola de bagagem nem dinheiro, pois as pessoas a quem eles iam ministrar deviam fornecer o necessário para eles. ");
INSERT INTO portft_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ele permitiu que calçassem sandálias, mas mandou que não levassem mais roupas. ");
INSERT INTO portft_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Também disse a eles: -Depois de entrarem numa vila e receberem convite para se hospedar na casa de alguém, fiquem naquela casa até saírem do povoado, para não ofenderem o dono da casa. ");
INSERT INTO portft_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nos lugares onde as pessoas não derem as boas-vindas para vocês ou não ouvirem a sua mensagem, sacudam o pó das suas sandálias na hora da saída, para mostrar às pessoas que elas ficam com a culpa como ficam com a poeira. ");
INSERT INTO portft_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Depois de saírem os discípulos para todos esses povoados, eles iam pregando que as pessoas deviam se arrepender; ");
INSERT INTO portft_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","expulsavam muitos espíritos maus das pessoas, e curavam muitos doentes, pondo azeite na cabeça deles. ");
INSERT INTO portft_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","O Rei Herodes ouviu todas estas coisas, pois muitas pessoas falavam sobre aquilo que Jesus fazia e ensinava. Especificamente, algumas pessoas diziam sobre Jesus: -João, o batizador, foi ressuscitado milagrosamente dos mortos por Deus. Por isso, ele consegue fazer esses milagres. ");
INSERT INTO portft_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","E outros diziam sobre Jesus: -Ele é o antigo profeta Elias, que Deus prometeu mandar novamente. Outros diziam sobre Jesus: -Não, ele é um profeta diferente, como um dos profetas de antigamente. ");
INSERT INTO portft_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Depois que o Rei Herodes ouviu o que as diversas pessoas diziam, ele afirmava: -Quem faz esses milagres é João, cuja cabeça mandei cortar e que acaba de ressuscitar. ");
INSERT INTO portft_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","O motivo do Rei Herodes tirar esta conclusão foi o seguinte: Algum tempo antes, ele tinha casado com Herodias, a esposa de Filipe, irmão menor dele. ");
INSERT INTO portft_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","João dizia sempre a Herodes: -A lei de Deus não permite você se casar com a esposa do seu irmão enquanto ele estiver vivo. Já que Herodias instigava Herodes a colocar João na cadeia, Herodes mesmo mandou homens prenderem o João e botarem no cárcere. Herodias desejava matar o João, mas não conseguiu fazer isso. ");
INSERT INTO portft_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Por querer se vingar dele, Herodias desejava que outra pessoa o matasse. Mas ela não conseguiu nada porque o Rei Herodes protegia o João na prisão. ");
INSERT INTO portft_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes fazia assim porque ele respeitava e tinha medo do João, por saber que João era um homem justo e santo. Mesmo ficando perplexo por causa das coisas que João pregava, Herodes gostava de ouvi-lo. ");
INSERT INTO portft_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mas certo dia Herodias conseguiu alguém para matar o João. Foi o aniversário de Herodes e ele convidou os principais oficiais do governo, os principais líderes militares e os grandes cidadãos do distrito de Galileia para um banquete festivo em casa dele. ");
INSERT INTO portft_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Enquanto eles todos estavam jantando, a filha de Herodias chegou na sala e, pela dança que ela executava, agradava o Rei Herodes e seus convidados. O rei disse a ela: -Peça qualquer coisa que você quiser e eu dou para você. ");
INSERT INTO portft_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ele também disse a ela: -Dou tudo que você desejar. Vou dar até metade de tudo aquilo que tenho e governo, se você assim quiser. Que Deus me castigue se não cumprir com esta promessa. ");
INSERT INTO portft_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A moça saiu da sala, foi ter com sua mãe e lhe contou aquilo que Herodes tinha dito; então perguntou: -O que você quer que eu peça a ele? Para obrigar Herodes a matar o João, Herodias respondeu: -Peça ao Rei Herodes a cabeça de João o batizador. ");
INSERT INTO portft_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","A moça voltou depressa para a sala de banquetes, foi ter com o rei e pediu assim: -Quero que você corte a cabeça de João o batizador. ");
INSERT INTO portft_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mesmo ficando muito triste ao ouvir o pedido dela, o rei não podia recusar, pois ele tinha prometido em presença de todos os convidados dar a ela tudo que ela pedisse. ");
INSERT INTO portft_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Por isso o rei mandou logo ao executor (o homem que executa os presos) que cortasse a cabeça de João e trouxesse a ele. Aquele oficial foi à cadeia e cortou a cabeça de João. ");
INSERT INTO portft_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Trouxe a cabeça, colocou num prato e entregou à moça. Ela o levou à sua mãe. ");
INSERT INTO portft_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Depois que os discípulos do João souberam disso, vieram levar o corpo de João para enterrar. ");
INSERT INTO portft_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Os apóstolos voltaram a Jesus desde os diversos lugares aonde tinham se espalhado. Eles contaram a ele aquilo que tinham feito e o que tinham ensinado ao povo. ");
INSERT INTO portft_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ele disse a eles: -Venham comigo a um lugar onde não há gente, para podermos ficar sozinhos e descansar um pouquinho. Ele disse isso porque havia tantas pessoas chegando e saindo que Jesus e os discípulos nem tinham tempo para comer ou fazer outras coisas. ");
INSERT INTO portft_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Então eles se foram sozinhos num barco até um lugar onde não morava ninguém. ");
INSERT INTO portft_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Muitas pessoas viram quando eles saíram e conseguiram identificar Jesus e os discípulos. As pessoas correram adiante deles por terra, de todos os povoados vizinhos, e chegaram lá antes de Jesus e os discípulos. ");
INSERT INTO portft_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Quando Jesus e os seus discípulos saíram do barco, Jesus viu essa grande multidão. Ele teve pena das pessoas porque andavam confusas, como ovelhas sem pastor. Por isso, ele passou algum tempo com elas e ensinava muitas coisas a elas. ");
INSERT INTO portft_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Quando já estava caindo a tarde, os discípulos vieram a ele e disseram: -Este é um lugar onde não mora ninguém, e está ficando tarde. ");
INSERT INTO portft_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Portanto, mande essa gente embora para ir aos lugares da vizinhança e às aldeias comprar comida. ");
INSERT INTO portft_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Porém Jesus respondeu a eles: -Deem comida para eles! Eles responderam: -É absurdo pensar que possamos conseguir dinheiro suficiente – o ordenado de 200 dias de trabalho – para comprar pão para tantas pessoas e dar a elas, pois não temos dinheiro para isso e, mesmo assim, não seria suficiente. ");
INSERT INTO portft_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Porém, ele respondeu a eles: -Quantos pães vocês têm aí? Vão lá ver. Eles foram contar e depois contaram a ele: -Temos somente cinco pães e dois peixes cozidos. ");
INSERT INTO portft_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ele mandou os discípulos fazerem todas as pessoas sentarem em grupos na grama. ");
INSERT INTO portft_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Todas se sentaram em grupos de 50-100 pessoas. ");
INSERT INTO portft_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesus pegou os cinco pães e os dois peixes; olhou para o céu; deu graças a Deus pela comida; partiu os pães em pedacinhos; e depois deu para os discípulos distribuírem ao povo. Depois, partiu da mesma forma os peixes para dar a todos eles. ");
INSERT INTO portft_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Todos comeram até ficar satisfeitos. ");
INSERT INTO portft_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Os discípulos recolheram doze cestos cheios de pedaços de pão e peixe que sobravam. ");
INSERT INTO portft_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Uns 5.000 homens comeram do pão e do peixe, sem contar as mulheres e as crianças. ");
INSERT INTO portft_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Logo Jesus mandou seus discípulos entrarem num barco e irem adiante dele até a vila de Betsaida, mais adiante, beirando o Lago da Galileia. Ele ia ficar para despedir a multidão que lá estava. ");
INSERT INTO portft_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mais tarde, depois da saída dos discípulos e da despedida da multidão, ele subiu no monte para orar. ");
INSERT INTO portft_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Quando já era noite, o barco dos discípulos se encontrava no meio do lago, enquanto Jesus estava sozinho em terra. ");
INSERT INTO portft_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ele viu que, ao remarem, eles estavam tendo problemas, pois o vento soprava contra eles. Ele se aproximou deles de madrugada, andando em cima da água. Ele quis passar adiante deles. ");
INSERT INTO portft_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Quando eles viram algo que andava em cima da água, achavam que eram um fantasma. Por isso começaram a gritar, ");
INSERT INTO portft_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","pois todos viram Jesus e ficaram apavorados. Mas ele falou com eles; especificamente, disse a eles, -Calma! Não tenham medo, pois sou eu. ");
INSERT INTO portft_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ele entrou no barco onde eles estavam, e o vento deixou de soprar. Eles ficaram admirados por causa do tipo de pessoa que ele era; ");
INSERT INTO portft_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","mesmo tendo observado como Jesus multiplicou os pães e os peixes, eles não entenderam o poder dele, pois não conseguiram pensar claramente sobre isso. ");
INSERT INTO portft_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Depois de atravessarem o Lago da Galileia num barco, eles chegaram a terra perto da vila de Genesaré, onde amarraram o barco na praia. ");
INSERT INTO portft_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Logo que saíram do barco, as pessoas de lá reconheceram Jesus. ");
INSERT INTO portft_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Elas foram correndo pelo distrito inteiro, contando a outros que Jesus estava lá; logo acomodaram os doentes em macas e os levaram aonde ouviram dizer que Jesus estava. ");
INSERT INTO portft_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Em qualquer aldeia, vila ou lugar onde ele entrava, os moradores levavam os doentes para as praças públicas. Então os doentes rogavam que Jesus os deixasse tocar nele, mesmo na barra da sua roupa, para ficarem curados por ele. Todos aqueles que tocavam nele ou nas suas vestes ficavam curados. ");
INSERT INTO portft_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Alguns fariseus e professores da lei que Deus tinha dado a Moisés que tinham vindo à cidade de Jerusalém se reuniram em volta de Jesus. ");
INSERT INTO portft_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Eles notaram que os discípulos dele estavam comendo com mãos que, na opinião deles, Deus considerava impuras porque não foram lavadas conforme as tradições religiosas. ");
INSERT INTO portft_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Os fariseus e todos os demais judeus que observavam estritamente tais tradições comem somente depois de lavarem as mãos com muito cuidado conforme as tradições ensinadas pelos antepassados. ");
INSERT INTO portft_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Depois de voltarem da compra de comida no mercado, comem somente depois de lavar bem a comida, para não ficarem inaceitáveis a Deus, caso alguma pessoa ou coisa inaceitável a Deus tenha tocado naquela comida. Há muitas outras tradições que eles aceitam e procuram obedecer. Especificamente, eles lavam de forma especial suas xícaras, potes, chaleiras, vasilhas e camas para que o uso de tais objetos não os torne inaceitáveis a Deus. ");
INSERT INTO portft_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aqueles fariseus e professores da lei que Deus tinha dado a Moisés questionaram Jesus, dizendo: -Achamos errado que você permita que seus discípulos desobedeçam as tradições de nossos antepassados. Você não deve deixá-los comer com mãos que, na nossa opinião, Deus considera inaceitáveis. Como você defende essa prática? ");
INSERT INTO portft_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus disse a eles: -Isaías descreveu muito bem vocês, que se fazem de bonzinhos, quando ele comunicou as palavras de Deus, “Esta gente fala como se me honrasse, mas o que realmente pensa não me honra de jeito nenhum. ");
INSERT INTO portft_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Em vão eles me adoram, pois ensinam o que outras pessoas mandaram como se Deus mesmo o tivesse mandado.” ");
INSERT INTO portft_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Vocês se recusam a fazer aquilo que Deus mandou, e ao invés disso seguem somente as tradições que as pessoas ensinam. ");
INSERT INTO portft_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesus também disse a eles: - Vocês conseguiram recusar fazer o que Deus mandou para obedecerem suas próprias tradições. ");
INSERT INTO portft_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Por exemplo, nosso antepassado Moisés mandou, “Respeite o seu pai e a sua mãe.” Ele também mandou, “Se alguém falar mal do seu pai ou sua mãe, deve ser morto.” ");
INSERT INTO portft_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mas vocês ensinam que, se alguém disser aos seus pais, “Não posso mais ajudar vocês, pois aquilo que poderia ter dado para vocês, já prometi a Deus,” ");
INSERT INTO portft_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","vocês os permitem deixar de dar coisas para seus pais que seria de ajuda para eles. ");
INSERT INTO portft_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Fazendo assim, estão mostrando que de fato não dão valor ao mandamento de Deus, de que sejam respeitados os pais e mães; só obedecem suas próprias tradições, que também ensinam a outros. Vocês atuam com frequência desta mesma forma. ");
INSERT INTO portft_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesus chamou a multidão e, quando todos se achavam perto dele, falou com eles em figuras: -Escutem-me todos! Procurem entender o que digo a vocês agora. ");
INSERT INTO portft_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nada que entra de fora numa pessoa torna essa pessoa inaceitável a Deus. Pelo contrário, é aquilo que vem de dentro da pessoa que a torna inaceitável a Deus. ");
INSERT INTO portft_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Escutem bem o que estou dizendo. ");
INSERT INTO portft_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Depois que Jesus deixou a multidão e entrou numa casa com seus discípulos, eles perguntaram sobre aquilo que ele tinha dito em figuras sobre o que torna as pessoas impuras. ");
INSERT INTO portft_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ele respondeu: -Fico decepcionado com vocês, pois não entendem o significado. Vocês devem entender que nada que entra de fora numa pessoa pode fazer com que Deus considere essa pessoa inaceitável. ");
INSERT INTO portft_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ao invés de entrar na sua mente, vai para o estômago e depois sai do corpo. Dizendo isso, Jesus declarou que nenhuma comida faz com que Deus considere as pessoas impuras. ");
INSERT INTO portft_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ele também disse: -É aquilo que vem de dentro das pessoas que as torna inaceitáveis a Deus. ");
INSERT INTO portft_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Especificamente, aquilo que vem de dentro das pessoas as faz pensar coisas ruins, atuar de forma imoral, furtar coisas, matar pessoas, ");
INSERT INTO portft_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","cometer adultério, ser ambiciosas/cobiçosas, atuar de forma maliciosa, enganar outras pessoas, fazer coisas indecentes, invejar as demais pessoas, falar coisas ruins contra Deus, ter orgulho e atuar de forma insensata. ");
INSERT INTO portft_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Todas as más ações, como essas, vêm de dentro das pessoas; são elas que fazem com que Deus considere uma pessoa inaceitável. ");
INSERT INTO portft_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Depois que Jesus e seus discípulos deixaram o distrito da Galileia, foram à região perto da cidade de Tiro. Enquanto ele ficava numa determinada casa, preferia que ninguém soubesse que estava ali, mas não conseguiu impedir que o povo o descobrisse. ");
INSERT INTO portft_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Depois que uma certa mulher, cuja filha era dominada por um espírito mau, ouviu falar de Jesus, ela foi ter com ele e se prostrou aos pés dele. ");
INSERT INTO portft_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Esta mulher, cujos antepassados vieram do país da Grécia, nasceu na região da cidade de Fenícia, no distrito da Síria, e não era judia. Foi ela que pediu para Jesus expulsar o espírito mau da sua filha. ");
INSERT INTO portft_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ele falou com ela em figuras para mostrar que ele devia ajudar primeiro os judeus, e para testar a reação dela, dizendo: -Primeiro deixe que os filhos comam tudo que quiserem, pois não fica bom alguém tirar a comida destinada aos filhos e jogar para os cachorrinhos. ");
INSERT INTO portft_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mas ela respondeu em figuras também, para mostrar que ela acreditava que, mesmo não sendo judia, poderia receber ajuda dele/Deus, dizendo: -Senhor, até os cachorros debaixo da mesa comem das migalhas que os filhos deixam cair. ");
INSERT INTO portft_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesus disse a ela: -Por causa daquilo que você disse, que mostra que você realmente crê em mim, não precisa pedir mais a minha ajuda. Volte para casa, pois o espírito mau acaba de sair da sua filha. ");
INSERT INTO portft_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A mulher voltou para casa e lá viu que a sua filha estava deitada, bem calma, na cama e que o espírito mau a tinha deixado. ");
INSERT INTO portft_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesus e os seus discípulos deixaram a região da vila de Tiro, e ele passou pela vila de Sidom e pelo distrito das Dez Cidades até o Lago da Galileia. ");
INSERT INTO portft_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","As pessoas lhe trouxeram um homem surdo que mal falava, pedindo a Jesus para tocar nele para curá-lo. ");
INSERT INTO portft_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus tirou o homem da multidão para ficar a sós com ele. Então pôs um dedo em cada ouvido do homem. Depois de cuspir nos dedos, tocou também a língua do homem. ");
INSERT INTO portft_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Depois, olhou para o céu, suspirou para expressar sua compaixão pelo homem, e disse ao homem em língua aramaica: -Efatá! (que quer dizer “Abra-se!” ) ");
INSERT INTO portft_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Imediatamente o homem passou a ouvir claramente, e sendo removido o impedimento para a fala, começou a falar com clareza. ");
INSERT INTO portft_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus mandou para as pessoas não contarem o caso para ninguém. Mas apesar do pedido dele, todo o mundo passou a comentar o caso. ");
INSERT INTO portft_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","As pessoas que souberam do ocorrido ficaram admiradas, dizendo com entusiasmo: -Tudo que ele fez é maravilhoso! Além de fazer outras coisas espantosas, ele faz os surdos ouvirem e os mudos falarem! ");
INSERT INTO portft_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Naquele tempo uma grande multidão se reuniu, e as pessoas ficaram sem comida. Jesus chamou os discípulos e disse a eles: ");
INSERT INTO portft_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","–Tenho pena destas pessoas, pois me acompanham durante três dias e não têm mais nada para comer; ");
INSERT INTO portft_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","se eu os mandar para casa tão famintas, algumas vão desmaiar pelo caminho pois vieram de longe. ");
INSERT INTO portft_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Um dos discípulos respondeu: - Para nós aqui onde ninguém mora, é impossível arrumar comida para satisfazer esta multidão. ");
INSERT INTO portft_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus lhes perguntou: - Quantos pães vocês têm? Responderam: - Temos sete pães. ");
INSERT INTO portft_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesus mandou a multidão: - Sentem-se todos na grama! Depois que se sentaram, ele pegou os sete pães, deu graças a Deus por eles, e partiu os pães; logo deu aos discípulos para eles distribuírem aos demais. Eles distribuíram a comida à multidão. ");
INSERT INTO portft_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Havia também uns poucos peixes. Portanto, após dar graças a Deus pelo peixe, disse aos discípulos: - Distribuam estes também. Depois que eles distribuíram o peixe à multidão, ");
INSERT INTO portft_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","todos comeram e ficaram satisfeitos. Os discípulos recolheram as sobras, enchendo sete cestos de pedaços de comida. ");
INSERT INTO portft_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Eles calcularam que umas 4.000 pessoas foram alimentadas aquele dia. ");
INSERT INTO portft_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jesus mandou as pessoas de volta para casa. Imediatamente depois disso, ele entrou no barco com os discípulos, e eles deram a volta ao Lago da Galileia até o distrito de Dalmanuta. ");
INSERT INTO portft_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Alguns dos fariseus vieram a Jesus e começaram a argumentar com ele, pois esperavam que após pedirem dele um milagre que fosse mostrar que Deus o tinha realmente enviado, Jesus ia dizer ou fazer algo que eles pudessem criticar para desacreditá-lo. ");
INSERT INTO portft_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Depois de suspirar profundamente, Jesus disse: - Me dá nojo que, mesmo após observarem como eu ministro às pessoas, vocês insistam em pedir mais milagres de mim. Digo a vocês que não vou lhes mostrar nenhum milagre. ");
INSERT INTO portft_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ele se afastou deles, entrou novamente no barco com os discípulos e seguiu a margem do Lago da Galileia. ");
INSERT INTO portft_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Os discípulos tinham se esquecido de levar pão consigo, pois no barco só havia um pão. ");
INSERT INTO portft_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Durante a viagem, Jesus os advertiu sobre como os fariseus e o Rei Herodes influenciavam as pessoas de forma negativa. Ele fez isso pelo uso de comparações: - Cuidado! Cuidado com o fermento dos fariseus e o fermento do Rei Herodes! ");
INSERT INTO portft_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Já que os discípulos entenderam mal o que ele disse, comentavam uns aos outros: - Ele deve ter dito isso por saber que não trouxemos pão. ");
INSERT INTO portft_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sabendo o que eles estavam dizendo entre si, Jesus disse a eles: - Fico decepcionado por essa conversa sobre a falta de pão, pois é óbvio que vocês não percebem nem entendem que posso providenciar pão de forma milagrosa se vocês estiverem precisando de comida; vocês não estão pensando claramente sobre o assunto. ");
INSERT INTO portft_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mesmo tendo olhos, vocês não entendem o que estão vendo. E ele perguntou: - Vocês não se lembram de ");
INSERT INTO portft_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","quando parti os cinco pães para alimentar as 5.000 pessoas. Quantos cestos de pedaços de pão sobravam que vocês recolheram após todo o mundo ficar repleto? Eles responderam: - Recolhemos doze cestos de pedaços. ");
INSERT INTO portft_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Então ele perguntou: - Quando parti os sete pães para alimentar as 4.000 pessoas, quantos cestos de pedaços de pão sobravam que vocês recolheram após todo o mundo ficar repleto? E eles responderam: - Recolhemos sete cestos. ");
INSERT INTO portft_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Então ele disse a eles: - Fico decepcionado pelo fato de vocês não entenderem que não devem se preocupar por uma possível falta de comida. ");
INSERT INTO portft_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Eles chegaram de barco na vila de Betsaida. As pessoas apresentaram um cego a Jesus, pedindo que ele o tocasse para curá-lo. ");
INSERT INTO portft_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus pegou a mão do cego, guiou o homem para fora da vila, cuspiu um pouco de saliva nos olhos dele, pôs as mãos no homem e perguntou: - Está vendo alguma coisa agora? ");
INSERT INTO portft_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","O homem olhou para cima e disse: - Sim, vejo pessoas andando, mas não vejo bem; quer dizer, elas parecem árvores. ");
INSERT INTO portft_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesus tocou novamente os olhos do cego. O homem olhou com força e conseguiu ver; quer dizer, ele viu tudo bem claro. ");
INSERT INTO portft_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesus mandou o homem de volta para casa, após dizer a ele: - Não entre no povoado nem fale primeiro às pessoas ali sobre este caso! ");
INSERT INTO portft_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesus e seus discípulos saíram da vila de Betsaida e foram às aldeias perto da cidade de Cesareia de Filipe. Pelo caminho, ele perguntou assim aos discípulos: - Quem o povo diz que eu sou? ");
INSERT INTO portft_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Eles responderam: - Alguns dizem que você é João o batizador, que ressuscitou. Outros dizem que você é Elias, o profeta que Deus prometeu mandar de volta. E outros dizem que você é um dos outros profetas de antigamente. ");
INSERT INTO portft_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ele perguntou: - E quem vocês mesmos dizem que eu sou? Pedro respondeu: - Você é o Messias. ");
INSERT INTO portft_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Então Jesus mandou que não contassem a ninguém este fato sobre ele. ");
INSERT INTO portft_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Então Jesus começou a ensinar aos discípulos: - É preciso que eu, o homem vindo do céu, sofra e seja rejeitado pelos anciãos, pelos chefes dos sacerdotes e pelos professores da lei que Deus tinha dado a Moisés, e que eles me matem e que três dias depois eu me torne vivo novamente. ");
INSERT INTO portft_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ele disse isto claramente. Pedro levou Jesus para um lado e começou a censurá-lo. ");
INSERT INTO portft_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesus voltou, olhou para seus discípulos e censurou o Pedro; especificamente, ele disse: - É você quem está pensando como Satanás. Saia da minha frente! Ao invés de pensar o que Deus está pensando, você está pensando como as demais pessoas. ");
INSERT INTO portft_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Depois de chamar a multidão, junto com os discípulos, ele lhes disse: - Se algum de vocês quiser ser meu discípulo, não deve fazer somente o que ele mesmo quer fazer, senão deve estar disposto a deixar que as outras pessoas o façam sofrer e ficar desgraçado como aqueles que carregam a sua cruz e são mortos; é assim que você deve ser meu discípulo. ");
INSERT INTO portft_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aquele que quiser salvar a sua vida, recusando ser meu discípulo, vai perdê-la, mas aquele que são mortos por ser meu discípulo, contando as boas notícias às demais pessoas, vai viver para sempre comigo. ");
INSERT INTO portft_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Realmente, ninguém lucra nada se ganhar tudo que se pode ganhar neste mundo mas perder a vida eterna por não ser meu discípulo. ");
INSERT INTO portft_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Não há absolutamente nada que uma pessoa possa dar para ganhar a vida eterna depois de perdê-la. ");
INSERT INTO portft_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","E se alguém hesitar em falar bem de mim e daquilo que digo nestes dias quando muitas pessoas são pecadoras e infiéis a Deus, eu (o homem vindo do céu) também vou hesitar em falar bem desse indivíduo quando eu voltar com os santos anjos e me mostrar glorioso como meu pai. ");
INSERT INTO portft_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ele disse também aos discípulos: - Afirmo a vocês que antes de morrer, alguns de vocês que estão aqui neste momento vão ver Deus governando muitas pessoas com muito poder. ");
INSERT INTO portft_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis dias depois, Jesus levou Pedro, Tiago e João (o irmão de Tiago) até um monte alto, onde ficaram sozinhos. Enquanto estavam lá, perto dele, ele lhes apareceu de um forma bem diferente; ");
INSERT INTO portft_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","as roupas dele ficaram muito brancas e brilhantes, mais do que nenhuma lavadeira da terra seria capaz de embranquecer. ");
INSERT INTO portft_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Dois antigos profetas, Moisés e Elias, apareceram a ele; eles dois conversavam com Jesus. ");
INSERT INTO portft_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro interrompeu a conversa, dizendo: -Mestre, é maravilhoso ficarmos aqui. Portanto, deixe a gente construir três barracas, especificamente, uma para você, uma para Moisés e uma para Elias. ");
INSERT INTO portft_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ele disse isso porque não sabia o que dizer, pois ele e os outros dois discípulos estavam apavorados. ");
INSERT INTO portft_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Logo apareceu uma nuvem, que cobriu todos eles com sua sombra. Deus falou com eles da nuvem: -Este é meu Filho amado. Portanto, escutem o que ele diz! ");
INSERT INTO portft_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Quando os três discípulos olharam em volta, viram que de repente Jesus estava só com eles, pois não tinha mais ninguém lá. ");
INSERT INTO portft_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Enquanto eles desciam do monte, Jesus lhes mandou: -Não contem para ninguém o que vocês viram no monte até eu, o homem que veio do céu, morrer e me tornar vivo de novo. ");
INSERT INTO portft_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Eles obedeceram fielmente o que Jesus lhes mandou fazer, mas conversaram entre si sobre o significado de ele tornar-se vivo de novo. ");
INSERT INTO portft_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Os três discípulos tinham visto Elias no monte, mas eles sabiam que ele não tinha feito nada para preparar o caminho para Jesus; por isso, perguntaram: -Por que os professores da lei que Deus tinha dado a Moisés dizem que Elias deve voltar à terra antes da vinda do Messias? ");
INSERT INTO portft_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ele respondeu, referindo-se a João o batizador: -Está escrito nas Escrituras que Elias deve vir primeiro para mandar as pessoas consertarem as suas vidas para ficarem prontas para a chegada do Messias. Mas, quanto ao Messias, também quero que vocês pensem naquilo que os profetas falaram sobre mim, o homem que era para vir do céu, quer dizer, que eu ia sofrer muito e que as pessoas iam me rejeitar. ");
INSERT INTO portft_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Porém, digo a vocês que aquele que era parecido com Elias já veio, e foi muito maltratado pelas pessoas, bem como os profetas tinham vaticinado muitos anos antes. ");
INSERT INTO portft_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesus e os três discípulos voltaram aonde estavam os demais discípulos, e lá viram uma grande multidão em volta deles, junto com alguns professores da lei que Deus tinha dado a Moisés que argumentavam com eles. ");
INSERT INTO portft_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Logo que a multidão viu Jesus, todos ficaram bem admirados e correram para cumprimentá-lo. ");
INSERT INTO portft_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesus perguntou aos discípulos: -O que vocês estão discutindo com os professores da lei que Deus tinha dado a Moisés? ");
INSERT INTO portft_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Uma pessoa da multidão respondeu: -Mestre, eu trouxe meu filho para você curar. Tem um espírito mau nele, que o impossibilita de falar. ");
INSERT INTO portft_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sempre que o Espírito o ataca, joga para o chão; ele bota espuma pela boca, range os dentes e fica tenso. Pedi que os seus discípulos expulsassem o Espírito, pois você não estava aqui, mas eles não conseguiram. ");
INSERT INTO portft_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus respondeu, dizendo aos discípulos: -Fico perturbado pelo fato de vocês, mesmo depois de observarem como eu ministro às pessoas, não acreditarem que Deus tem poder para fazer estas coisas. Até quando preciso ficar com vocês para vocês terem fé? Tragam o menino para mim. ");
INSERT INTO portft_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Logo eles trouxeram o menino a Jesus. Quando o espírito mau viu Jesus, sacudiu o menino e ele caiu no chão, rolando e espumando pela boca. ");
INSERT INTO portft_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus perguntou ao pai dele: -Ele está assim há quanto tempo? O pai respondeu: -Começou quando ele era criança. ");
INSERT INTO portft_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","O Espírito não somente faz isto como também o jogo muitas vezes no fogo ou na água, para matá-lo. Tenha pena de nós e nos ajude, se puder. ");
INSERT INTO portft_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus exclamou: -Não diga, “Se puder”, pois tudo é possível para as pessoas que creem em Deus/creem que Deus possa fazer isso! ");
INSERT INTO portft_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Imediatamente o pai do menino gritou: -Creio que Deus pode me ajudar, mas não tenho ainda fé suficiente. Ajude-me a crer mais! ");
INSERT INTO portft_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Já que Jesus queria curar o menino antes a multidão ficar ainda maior, ele ordenou ao Espírito: -espírito mau, que torna as pessoas surdas e mudas, mando você sair dele e nunca mais voltar! ");
INSERT INTO portft_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","O Espírito gritou, sacudiu o menino com força, e saiu dele. O menino ficou como morto, e muitos achavam que já tinha morrido. ");
INSERT INTO portft_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Porém, Jesus o pegou pela mão e o ajudou a levantar-se; o menino ficou em pé, curado. ");
INSERT INTO portft_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Quando Jesus entrou na casa com seus discípulos, um deles perguntou em particular: -Por que não conseguimos expulsar o espírito mau? ");
INSERT INTO portft_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ele disse: -Este tipo de espírito mau pode ser expulso somente através da oração prévia. Não há outra maneira de expulsar tais espíritos. ");
INSERT INTO portft_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Depois de sair daquele distrito, viajaram pelo distrito da Galileia. Jesus não queria que ninguém soubesse que ele estava lá, ");
INSERT INTO portft_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","por causa daquilo que ele estava ensinando aos discípulo. Ele dizia a eles: -Alguém vai me entregar – eu, o homem que veio do céu – em mãos de outros homens. Eles vão me matar. Três dias depois de morrer, vou ficar vivo de novo. ");
INSERT INTO portft_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mas os discípulos não entenderam o que ele queria dizer com tudo aquilo. E ao mesmo tempo, eles tinham medo de perguntar. ");
INSERT INTO portft_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Eles voltaram à vila de Cafarnaum. Após entrar numa casa, Jesus perguntou a eles: -O que vocês conversavam pelo caminho? ");
INSERT INTO portft_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mas eles não responderam porque tinham vergonha, pois enquanto viajavam eles estavam discutindo uns com os outros sobre qual deles seria o mais importante. ");
INSERT INTO portft_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesus se sentou, chamou os doze discípulos, e disse a eles: -Se alguém quiser que Deus o considere o mais importante de todos, deve se considerar o menos importante de todos, sendo servo dos demais. ");
INSERT INTO portft_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ele pegou uma criança pela mão, colocando-a no meio deles. Tomando-a nos seus braços disse a eles, ");
INSERT INTO portft_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","–Aquele que cuidar de uma criança como esta por amor de mim, faz como se estivesse cuidando de mim; portanto, ele faz como se estivesse cuidando também do meu pai que me enviou. ");
INSERT INTO portft_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","João disse a Jesus: -Mestre, vimos alguém expulsando espíritos maus, alegando que você o capacitou de assim fazer. Por isso, mandamos que ele parasse, pois não era um de nós discípulos. ");
INSERT INTO portft_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesus disse: -Não proíbam a ele praticar coisas boas. Ninguém vai falar mal de mim logo depois de praticar um milagre que, segundo ele, eu lhe capacitei de fazer. ");
INSERT INTO portft_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","E se alguém não é contra nós, ele nos ajuda. ");
INSERT INTO portft_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Digo a vocês, se alguém lhe ajudar de qualquer maneira como, por exemplo, lhes der um copinho de água para beber por serem seguidores de mim, o Messias, ele certamente vai receber uma recompensa de Deus. ");
INSERT INTO portft_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesus continuou: -Mas se alguém fizer pecar uma pessoa que crê em mim, Deus vai castigá-lo severamente, mesmo que a pessoa tenha pouca importância social, como esta criança. O castigo que Deus vai dar seria ainda mais pesado do que ser jogado no mar, com uma grande pedra amarrada ao pescoço. ");
INSERT INTO portft_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Portanto, se você for tentado a usar suas mãos para fazer algo que desagrada a Deus, livre-se daqueles pensamentos, pois seria bom evitar tal pecado para viver eternamente e não ir para o inferno, onde o fogo nunca se apaga; da mesma forma, seria bom você cortar a mão para salvar a sua vida, ao invés de ficar com as duas mãos e morrer. ");
INSERT INTO portft_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Se você for tentado a usar seus pés para andar a algum lugar que desagrada a Deus, livre-se completamente desses pensamentos, pois seria bom evitar tal pecado para não ir ao inferno, da mesma forma como seria bom você cortar seu pé para salvar a vida, ao invés de ficar com ambos os pés e morrer. ");
INSERT INTO portft_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Se você for tentado a usar os olhos para olhar algo que desagrada a Deus, livre-se completamente daqueles pensamentos; pois seria bom evitar tal pecado, bem como seria bom você arrancar o olho para salvar a vida, ");
INSERT INTO portft_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ao invés de ficar com ambos os olhos inteiros e ir para o inferno; lá as pessoas sofrem para sempre e o fogo nunca se apaga. ");
INSERT INTO portft_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jesus continuou: -Vocês devem se tornar aceitáveis a Deus, sofrendo provações, bem como o fogo purifica todas as coisas, e como as pessoas oferecem sacrifícios aceitáveis a Deus, salgando-os. ");
INSERT INTO portft_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","O sal é útil para as comidas; mas se perde o gosto, não pode recuperá-lo. Da mesma forma, vocês devem continuar sendo úteis para Deus, pois ninguém pode tornar a fazê-los úteis a Deus se perderem a utilidade. E também devem viver em paz uns com os outros. ");
INSERT INTO portft_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus saiu daquele lugar com seus discípulos, and logo se foi ao distrito da Judeia e ao outro lado do Rio Jordão. Mais tarde, após se reunir em volta dele uma grande multidão, ele começou a ensinar novamente, conforme o costume dele. ");
INSERT INTO portft_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Enquanto ele ensinava, vieram alguns fariseus e lhe perguntaram: -Nossa lei judaica permite um homem divorciar sua esposa? Eles disseram isto para poder criticar Jesus se ele respondesse “sim” ou “não”.  ");
INSERT INTO portft_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ele respondeu: -O que foi que Moisés ordenou aos seus antepassados sobre isso? ");
INSERT INTO portft_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Um deles respondeu: -A lei de Moisés permite um homem escrever num papel o motivo do divórcio e depois entregar o papel à sua esposa e mandá-la embora. ");
INSERT INTO portft_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus disse a eles: -Foi porque vocês não prestavam atenção a nada que Deus tentou ensinar ao povo de Israel que Moisés fez essa lei para vocês. ");
INSERT INTO portft_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mas ele também escreveu que, quando Deus criou as pessoas, ele fez delas um só casal. ");
INSERT INTO portft_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Portanto, como dizem as Escrituras, um homem não deve ficar mais com seus pais depois de casar; ");
INSERT INTO portft_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ele deve passar a morar com sua esposa, e eles dois se tornam tão íntimos como se fosse uma só pessoa. Portanto, mesmo sendo antes duas pessoas, Deus as considera agora uma só pessoa. ");
INSERT INTO portft_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Por isso, o homem não deve se separar da esposa a que Deus o uniu. ");
INSERT INTO portft_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Quando Jesus e seus discípulos ficaram sozinhos em casa, eles lhe perguntaram novamente sobre esse ponto. ");
INSERT INTO portft_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ele disse a eles: -Deus acha que um homem comete adultério ao se divorciar da sua esposa e se casar com outra mulher; ");
INSERT INTO portft_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","e Deus acha que uma mulher comete adultério ao se divorciar do seu marido e se casar com outro homem. ");
INSERT INTO portft_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Um dia, as pessoas traziam crianças a Jesus para ele as tocar e abençoar. Mas os discípulos censuraram essas pessoas. ");
INSERT INTO portft_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Quando Jesus viu isso, ele se indignou e disse aos discípulos: -Deixem as crianças virem a mim; não as proíbam. São pessoas como elas que experimentam a direção e o cuidado do Deus. ");
INSERT INTO portft_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Se alguém não confiar, deixando Deus guiar e cuidar dela como uma criança, essa pessoa não vai experimentar a direção e cuidado de Deus. ");
INSERT INTO portft_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","E ele abraçou as crianças, pôs suas mãos nelas e pediu que Deus as abençoasse. ");
INSERT INTO portft_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Enquanto Jesus iniciava outra viagem com seus discípulos, um homem veio correndo, ajoelhou-se na frente dele e perguntou: -Bom mestre, o que devo fazer para viver eternamente? ");
INSERT INTO portft_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus disse a ele: -Você deve considerar com cuidado o que implica chamar-me de bom, pois só Deus é bom; nenhuma outra pessoa é boa. ");
INSERT INTO portft_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Você conhece os mandamentos de Moisés, que fazem você viver eternamente se obedecer perfeitamente; especificamente, não mate ninguém, não cometa adultério, não furte, não diga mentiras, não iluda os outros, e respeite os seus pais. ");
INSERT INTO portft_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","O homem disse a ele: -Mestre, obedeci todos esses mandamentos desde minha infância. Mas deve haver outra coisa que não fiz ainda. ");
INSERT INTO portft_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus olhou para ele com amor e disse: -Há ainda uma coisa que você não fez ainda. Especificamente, vá vender tudo o que tem, e dê o dinheiro aos pobres. Como resultado disso, você vai ser rico espiritualmente no céu. Depois de fazer isso, venha ser meu discípulo. ");
INSERT INTO portft_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","O homem ficou desiludido ao ouvir isso e se foi triste, pois era muito rico e não queria distribuir os seus bens. ");
INSERT INTO portft_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus olhou em volta ao povo e depois exclamou aos seus discípulos: -Para os ricos é bem difícil deixar que Deus seja seu chefe. ");
INSERT INTO portft_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Os discípulos ficaram admirados ao ouvir isso, pois achavam que Deus favorecia os ricos e, portanto, se Deus não salvasse os ricos, não iria salvar ninguém. Por isso Jesus respondeu assim a eles: -Meus amigos, é muito difícil alguém deixar que Deus governe a sua vida. ");
INSERT INTO portft_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Para ilustrar, É difícil para um camelo passar pelo fundo de uma agulha. Da mesma forma, é difícil um rico deixar que Deus seja o seu chefe. ");
INSERT INTO portft_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Os discípulos ficaram admirados e disseram uns aos outros: -Se assim for, dificilmente Deus vai salvar alguém. ");
INSERT INTO portft_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus olhou para eles e disse: -É impossível que as pessoas se salvem, mas para Deus não é impossível salvá-las porque Deus pode fazer qualquer coisa. ");
INSERT INTO portft_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro exclamou: -Já que nós deixamos tudo para nos tornar seus discípulos, Deus vai nos premiar? ");
INSERT INTO portft_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus respondeu: -Vou lhes dizer a verdade: Se alguém deixar sua casa, ou irmãos, ou irmãs ou seu pai ou sua mãe, ou filhos ou terra para ser meu discípulo e proclamar as boas notícias, ");
INSERT INTO portft_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","enquanto ele estiver vivo aqui na terra, vai receber cem vezes mais casas e amigos tão queridos como se fossem irmãos, irmãs, mães, filhos e terras. E embora seja perseguido, vai viver para sempre no futuro. ");
INSERT INTO portft_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","E muitas pessoas que agora são consideradas importantes vão ser de pouca importância, e muitas pessoas que agora são consideradas de pouca importância vão ser consideradas importantes. ");
INSERT INTO portft_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Enquanto eles viajavam, Jesus e os discípulos andavam pelo caminho que vai à cidade de Jerusalém. Já que Jesus caminhava na frente, os discípulos ficaram admirados e as pessoas que os acompanhavam tinham medo daquilo que ia acontecer a eles ao entrarem na cidade de Jerusalém. Ele levou os doze discípulos para o lado e começou a falar mais com eles sobre as coisas que iam acontecer a ele, dizendo, ");
INSERT INTO portft_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","–Escutem bem. Vamos até a cidade de Jerusalém. Lá eu, o homem que veio do céu, vou ser levado à força por algumas pessoas até os principais sacerdotes e professores da lei que Deus tinha dado a Moisés; eles vão decretar a minha morte. Então eles vão me levar às pessoas que não são judias. ");
INSERT INTO portft_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Estas pessoas vão zombar de mim, cuspir e bater em mim e depois matar-me. Mesmo assim, três dias depois vou me tornar vivo de novo. ");
INSERT INTO portft_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tiago e João, os filhos de Zebedeu, vieram ter com Jesus e disseram a ele: -Mestre, queremos pedir um favor. ");
INSERT INTO portft_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ele disse a eles: -O que vocês querem que eu faça? ");
INSERT INTO portft_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Eles disseram a ele, -Quando você passar a reinar em glória, deixe um de nós se sentar à sua direita e o outro à sua esquerda, nos lugares reservados para as pessoas de maior honra. ");
INSERT INTO portft_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mas Jesus disse a eles: -Vocês não entendem o que devem fazer para eu ordenar o que vocês estão pedindo. E então ele lhes perguntou: -Vocês podem aguentar as provações e sofrimentos que eu vou sofrer para que Deus honre vocês dessa maneira? ");
INSERT INTO portft_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Eles disseram a ele: -Sim, podemos. Então Jesus disse a eles: -É verdade que vocês vão aguentar provações e sofrimentos como os meus. ");
INSERT INTO portft_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mas não sou eu quem permite que vocês se sentem nos lugares daqueles que Deus mais honra; aqueles lugares são para as pessoas para as quais Deus já os preparou. ");
INSERT INTO portft_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Os outros dez discípulos ouviram o que Tiago e João tinham pedido, e como resultado eles se indignaram com eles. ");
INSERT INTO portft_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Então, depois de chamá-los, Jesus disse a eles: -Mesmo que vocês saibam que os não judeus que governam os outros adoram mostrar como são poderosos, e que aqueles que são considerados os maiores entre essas pessoas adoram mandar nos outros, ");
INSERT INTO portft_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","vocês não devem se comportar como eles. Pelo contrário, se algum de vocês quer que Deus o considere grande, deve servir os demais; ");
INSERT INTO portft_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","e se algum de vocês quer que Deus o considere de maior importância, deve ser como escravo para os demais. ");
INSERT INTO portft_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Vocês devem fazer assim porque, apesar de ser eu aquele que veio do céu, não vim somente para ser servido dos outros; vim para servir os outros e deixar que eles me matassem, para que Deus possa livrar muitas pessoas ao invés de condená-las por causa dos seus pecados. ");
INSERT INTO portft_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus e os discípulos chegaram à vila de Jericó. Depois, ao saírem da vila em companhia de uma grande multidão, um cego chamado Bartimeu, filho de Timeu, que costumava pedir esmola, estava sentado na beira do caminho. ");
INSERT INTO portft_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Quando ele ouviu dizer que Jesus, o homem da vila de Nazaré, estava passando, gritou: -Jesus, aquele que Deus prometeu como Messias descendente do Rei Davi, tenha pena de mim! ");
INSERT INTO portft_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Muitas pessoas o censuraram, mandando ficar calado. Mas ele gritava ainda mais: -Você que Deus prometeu como descendente do Rei Davi, tenha pena de mim. ");
INSERT INTO portft_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus parou e disse: -Chamem aquele homem para vir até aqui. Eles chamaram o cego, dizendo: -Coragem! Levante-se, pois ele está chamando você. ");
INSERT INTO portft_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ele jogou a capa, ficou em pé e se aproximou de Jesus. ");
INSERT INTO portft_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus perguntou: -O que você quer que eu faça? O cego disse a ele: -Mestre, quero que você me faça ver. ");
INSERT INTO portft_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus disse a ele: -Deus cura você porque você teve fé em mim. Pode voltar para casa. Ele começou logo a enxergar e acompanhou Jesus pelo caminho. ");
INSERT INTO portft_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Aproximando-se da cidade de Jerusalém, eles chegaram às vilas de Betfagé e Betânia, perto do Monte das Oliveiras. Então Jesus mandou dois dos seus discípulos até Betfagé  ");
INSERT INTO portft_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","com as seguintes instruções: - Vão até Betfagé, ali em frente; logo depois de entrarem, vocês vão encontrar um jumento amarrado, que ninguém jamais montou. Soltem o jumentinho e traga para mim. ");
INSERT INTO portft_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Se alguém perguntar: “Por que vocês estão fazendo isso?” digam o seguinte, “O Senhor precisa dele e vai devolver logo depois, em companhia de alguém”. ");
INSERT INTO portft_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Assim, os dois discípulos foram e lá encontraram um jumentinho, amarrado perto da porta de uma casa ao lado da rua; eles soltaram logo o jumentinho. ");
INSERT INTO portft_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Algumas pessoas de lá disseram a eles: - Por que vocês estão desamarrando o jumentinho? ");
INSERT INTO portft_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Eles disseram a elas o que Jesus tinha falado. Por isso as pessoas os deixaram levar o jumentinho. ");
INSERT INTO portft_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Eles levaram o jumento a Jesus. Os discípulos jogaram suas capas em cima dele para acomodar Jesus sentado. ");
INSERT INTO portft_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Muitas pessoas estendiam suas capas no caminho em homenagem a ele. Outros, para o honrar como rei, espalharam pelo chão frondes de palmeiras que tinham cortado nos campos ao lado do caminho. ");
INSERT INTO portft_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","As pessoas que iam adiante dele e aquelas que caminhavam atrás dele gritavam, -Bem-vindo! ");
INSERT INTO portft_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Deus abençoou você, que representa o Senhor. Que Deus abençoe seu futuro reino, que vai ser como o reino do nosso antepassado o Rei Davi! Louvado seja Deus no céu! ");
INSERT INTO portft_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ele entrou em companhia deles na cidade de Jerusalém, e entrou no pátio do templo. Após olhar tudo em volta, saiu da cidade, pois já era tarde. Ele voltou à vila de Betânia com os doze discípulos e dormiu lá. ");
INSERT INTO portft_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","No dia seguinte, quando Jesus e os discípulos iam saindo da vila de Betânia, Jesus teve fome. ");
INSERT INTO portft_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Vendo à distância uma figueira coberta de folhas, foi até lá para ver se tinha figos. Mas ao chegar perto da figueira, ele encontrou somente folhas, pois ainda não era a época própria para figos maduros. ");
INSERT INTO portft_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Respondendo à situação, Jesus disse à figueira: - Ninguém vai comer mais nada de você, pois já não vai produzir figos. Os discípulos ouviram o que ele disse. ");
INSERT INTO portft_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jesus e os seus discípulos voltaram à cidade de Jerusalém. Jesus entrou no pátio do templo e lá viu o que várias pessoas estavam fazendo. Ele expulsou do templo as pessoas que vendiam coisas e aqueles que compravam coisas no templo; derrubou as mesas daqueles que faziam câmbio da moeda romana pela moeda própria para as funções do templo. Derrubou também as cadeiras dos vendedores de pombos para o sacrifício,  ");
INSERT INTO portft_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","e não deixava ninguém atravessar o pátio do Templo carregando coisas. ");
INSERT INTO portft_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Então ele ensinou o povo; especificamente, disse: - Vocês sabem que foi escrito nas Escrituras por um dos profetas, que Deus disse:  “Minha casa será chamada de casa onde pessoas de todas as nações podem orar”, mas vocês fizeram dela algo como caverna onde se escondem ladrões”. ");
INSERT INTO portft_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Os principais sacerdotes e professores da lei que Deus tinha dado a Moisés ouviram depois o que ele tinha feito. Por isso, eles procuravam uma maneira de matá-lo, pois se deram conta de que a multidão andava maravilhada pelo que ele ensinava e eles tinham medo que as pessoas fossem logo acreditar que Jesus tinha mais autoridade no templo do que eles mesmos.  ");
INSERT INTO portft_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ao anoitecer, Jesus e seus discípulos saíram da cidade e foram dormir em Betânia. ");
INSERT INTO portft_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Enquanto eles andavam pelo caminho em direção a Jerusalém na manhã seguinte, viram que a figueira que ele tinha amaldiçoado estava completamente seca. ");
INSERT INTO portft_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro se lembrou daquilo que Jesus tinha dito à figueira e exclamou: - Mestre, olhe só! A figueira que você amaldiçoou já secou! ");
INSERT INTO portft_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus respondeu: - Vocês não devem se surpreender por causa disto. Vocês devem ter fé que Deus vai fazer aquilo que vocês pedirem a ele.  ");
INSERT INTO portft_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Digo realmente que se alguém disser a este monte, “Levante-se e jogue-se no lago!”, não duvidando que aquilo que ele pede vai acontecer – quer dizer, se acreditar firmemente que aquilo que ele pede vai acontecer, Deus vai fazer isso para ele. ");
INSERT INTO portft_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Portanto, digo a vocês que sempre que pedirem alguma coisa em oração, devem crer que vão recebê-lo e assim Deus vai fazer isso para vocês. ");
INSERT INTO portft_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","E mais, quando estiverem orando, se tiverem queixa de alguém por algum prejuízo ou ofensa, perdoem essa pessoa, para que seu Pai no céu possa perdoar os pecados de vocês. ");
INSERT INTO portft_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesus e os seus discípulos chegaram novamente à cidade de Jerusalém. Enquanto Jesus andava no pátio do templo, alguns dos principais sacerdotes, professores da lei que Deus tinha dado a Moisés e anciãos vieram a ele, dizendo, ");
INSERT INTO portft_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","–Como foi que você ganhou a autoridade para fazer as coisas que fez ontem neste lugar? Quem autorizou você a atuar assim? ");
INSERT INTO portft_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus disse a eles: - Vou perguntar algo a vocês e, se me responderem, vou lhes dizer quem foi que me autorizou a fazer estas coisas. ");
INSERT INTO portft_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Foi Deus ou foi o povo que deu autoridade a João para batizar as pessoas? Respondam. ");
INSERT INTO portft_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Eles conversaram entre si, e concluíram: - Se dissermos que foi Deus que o autorizou, ele vai dizer, “Vocês deviam ter acreditado aquilo que João disse”. ");
INSERT INTO portft_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Por outro lado, se dissermos que foi o povo que deu autoridade a João, as pessoas vão se zangar conosco”. Eles disseram isso porque tinham medo do povo e daquilo que o povo poderia fazer, pois todos acreditavam que João era realmente um profeta mandado por Deus. ");
INSERT INTO portft_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Por isso eles responderam a Jesus: - Não sabemos quem foi que deu autoridade a João. E Jesus lhes disse: - Já que vocês não me responderam, não vou dizer a vocês quem foi que me autorizou a fazer estas coisas. ");
INSERT INTO portft_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesus falou com eles através de comparações para mostrar o que Deus ia fazer aos judeus que rejeitaram os antigos profetas e a ele mesmo, dizendo: - Certo homem plantou um vinhedo, construiu um muro de pedras em volta para protegê-lo; fez um tanque de pedra para recolher o suco que ele ia esmagar das uvas, e construiu uma torre para que alguém vigiasse o vinhedo. Depois de alugar o vinhedo a alguns lavradores que deviam tomar conta e dar a ele uma parte do fruto, ele viajou a um lugar longe dali.  ");
INSERT INTO portft_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Quando chegou o tempo da colheita, ele mandou um servo aos homens que cuidavam do vinhedo, para receber deles uma parte do fruto. ");
INSERT INTO portft_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mas quando o servo chegou, eles o agarraram e bateram nele, não dando a ele nenhum fruto do vinhedo. Depois o mandaram embora. ");
INSERT INTO portft_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mais tarde, o dono do vinhedo mandou a eles outro servo, mas eles bateram na cabeça dele e o insultaram. ");
INSERT INTO portft_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mais tarde, ele mandou outro servo; este eles mataram. Maltrataram muitos outros servos que ele mandou; alguns eles bateram e outros mataram. ");
INSERT INTO portft_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","O dono do vinhedo tinha consigo mais uma pessoa: seu filho muito amado. Finalmente, ele mandou a eles o seu filho, pensando que iriam respeitá-lo. ");
INSERT INTO portft_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mas os lavradores disseram uns aos outros, depois da chegada do filho: - Este é o futuro dono do vinhedo, por ocasião da morte do pai. Portanto, vamos matar o filho para tomarmos posse do vinhedo. ");
INSERT INTO portft_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Eles agarraram o filho, mataram, e jogaram o corpo dele para fora do vinhedo. ");
INSERT INTO portft_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Agora vou lhes dizer o que o dono do vinhedo vai fazer. Ele vai chegar e destruir esses maus lavradores; depois vai dar o vinhedo a outras pessoas. ");
INSERT INTO portft_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Quero que vocês se lembrem deste versículo das Escrituras que já leram: “A pedra que os construtores rejeitaram chegou a ser a mais importante, pois é a pedra fundamental da casa. ");
INSERT INTO portft_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Isto foi feito pelo Senhor, e é maravilhoso ver”. ");
INSERT INTO portft_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Então os líderes judaicos procuraram prender Jesus, pois se deram conta de que ele se referia a eles na comparação que tinha feito dos maus lavradores. Mas, por terem medo das ações da multidão, eles deixaram Jesus e foram embora. ");
INSERT INTO portft_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Os líderes judaicos mandaram a Jesus alguns fariseus e outros que seguiram o Rei Herodes, para obrigá-lo a dizer algo considerado errado, pelo qual poderia ficar preso. ");
INSERT INTO portft_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ao chegar, disseram a ele, -Mestre, sabemos que você fala a verdade e que não se importa com o que as pessoas dizem sobre você. Especificamente, não se deixa influenciar por uma pessoa só por ela ter autoridade, senão fala a verdade sobre aquilo que Deus quer que façamos. Agora, pois, diga-nos honestamente, está certo pagarmos impostos aos governantes do país de Roma? Ou não está certo? Devemos pagar os impostos ou não? ");
INSERT INTO portft_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesus bem sabia que eles não queriam realmente saber o que deviam fazer, mas só queriam obrigá-lo a dizer algo considerado errado. Por isso, ele disse a eles: - Sei que vocês estão tentando me obrigar a dizer algo errado, pelo qual podem me prender. Tragam uma moeda para eu ver. ");
INSERT INTO portft_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Eles deram uma moeda a ele, e ele perguntou: - De quem são a cara e o nome gravados nesta moeda? Responderam: - São a cara e o nome de César, o chefe do governo romano. ");
INSERT INTO portft_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesus disse a eles: - Deem ao governo o que ele pede, e deem a Deus o que ele pede. Eles ficaram admirados com o que ele disse, pois não deu nenhuma oportunidade para eles o acusarem. ");
INSERT INTO portft_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Alguns saduceus, que negam que as pessoas possam tornar a viver após a morte, vieram a Jesus e, pensando zombar-se da ideia de pessoas tornarem a viver, perguntaram, ");
INSERT INTO portft_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","–Mestre, Moisés escreveu para nós judeus que, se morrer sem filhos um homem casado, o irmão dele deve se casar com a viúva; se eles tiverem filhos, serão considerados os verdadeiros filhos do defunto, para não findar a linhagem dele. ");
INSERT INTO portft_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ora, tinha sete irmãos. Embora o mais velho deles fosse casado, ele morreu sem deixar filhos. ");
INSERT INTO portft_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","O segundo irmão obedeceu a lei e se casou com a viúva do primeiro; ele também morreu sem deixar filhos. O terceiro irmão fez igual. ");
INSERT INTO portft_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Todos sete irmãos se casaram, um por um, com aquela viúva, mas todos morreram sem deixar filhos. Depois a viúva também morreu. ");
INSERT INTO portft_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Portanto, se for verdade o que algumas pessoas dizem, que os defuntos tornam a viver, de quem aquela mulher vai ser esposa quando as pessoas ressuscitarem? Vai ser impossível resolver esta questão porque ela já foi esposa de todos sete irmãos. ");
INSERT INTO portft_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus respondeu: - Vocês estão errados, pois não sabem o que está escrito nas Escrituras sobre este particular, e também não entendem o poder de Deus de reavivar as pessoas de tal maneira que se relacionem entre si de maneira diferente. ");
INSERT INTO portft_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Quando as pessoas tornarem a viver, ao invés de homens e mulheres se casarem uns com os outros, vão ser como os anjos no céu, que não se casam. ");
INSERT INTO portft_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mas quanto à ressurreição, na lei que Deus deu a Moisés, ele se referiu aos defuntos. Quando Moisés estava perto do arbusto que se queimava, Deus disse, “Sou o Deus que Abraão adorava, e o Deus que Isaque adorava, e o Deus que Jacó adorava e continuo sendo.” ");
INSERT INTO portft_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Portanto, por não ser Deus alguém que os mortos adoram, ele é com certeza o Deus que os vivos adoram; os espíritos de Abraão, Isaque e Jacó devem estar vivos ainda, mesmo estando eles mesmos mortos muito antes do nascimento de Moisés. Por isso sabemos que algum dia Deus vai dar a eles novos corpos para combinarem com seus espíritos. Portanto, sua negação da ressurreição dos defuntos está totalmente errada. ");
INSERT INTO portft_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Veio um professor da lei que Deus tinha dado a Moisés; ouvindo o debate, entendeu que Jesus tinha respondido muito bem a pergunta. Por isso, ele perguntou a Jesus: - Qual dos mandamentos é o mais importante? ");
INSERT INTO portft_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus respondeu: - O mais importante dos mandamentos é: “Escute, povo de Israel! O Senhor, nosso Deus, é o único Senhor. Amem o Senhor, seu Deus. ");
INSERT INTO portft_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mostrem seu amor em tudo que são, tudo que desejam e sentem, tudo que pensam e tudo que fazem.” ");
INSERT INTO portft_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","O segundo mais importante dos mandamentos é: “Vocês devem amar seus semelhantes como amam a si mesmos.” Nenhum outro mandamento é mais importante que estes dois. ");
INSERT INTO portft_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","O professor da lei que Deus tinha dado a Moisés disse a Jesus: - Mestre, você respondeu muito bem. Disse a verdade, que ele é o único Deus e que não existe outro Deus; ");
INSERT INTO portft_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","e disse corretamente que é mais importante amar a Deus do que ofertar animais ou queimar sacrifícios para agradar a ele. E que a gente deve mostrar o seu amor por ele em tudo o que é, e tudo o que pensa, e tudo o que faz. É isso que realmente agrada a Deus. ");
INSERT INTO portft_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Quando Jesus se deu conta de que o professor da lei que Deus tinha dado a Moisés tinha respondido sabiamente, disse a ele: - Você está quase disposto a deixar Deus governar a sua vida. Muitas pessoas tinham tentado pegar Jesus numa cilada, levando-o a dizer algo que elas achavam errado. Agora não ficava mais ninguém que pensava que ia conseguir pegá-lo dizendo algo errado, por isso eles não fizeram mais perguntas a ele. ");
INSERT INTO portft_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Em resposta a isso, enquanto estava ensinando no pátio do templo, Jesus disse ao povo: - Os professores da lei que Deus tinha dado a Moisés devem estar errados ao afirmarem que o Messias é somente um descendente do Rei Davi. ");
INSERT INTO portft_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davi mesmo declarou, pelo Espírito Santo que lhe revelou a verdade: - Deus disse a meu Senhor, “Sente-se do meu lado direito onde sentam as pessoa quem quero honrar, até que chegue o tempo em que eu ponha os seus inimigos debaixo dos seus pés”. ");
INSERT INTO portft_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Portanto, já que Davi mesmo chama o Messias de “meu Senhor”, o Messias não pode ser apenas um descendente dele. Deve ser também o Senhor dele. Muitas pessoas escutavam com prazer o que Jesus dizia. ");
INSERT INTO portft_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Enquanto ele ensinava o povo, Jesus disse: - Cuidado com os professores da lei que Deus tinha dado a Moisés. Eles gostam de vestir roupas compridas e andar em público para mostrar que são bem formados e agradam a Deus; e eles gostam de ser cumprimentados com respeito pelas pessoas nas praças públicas. ");
INSERT INTO portft_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","No dia de sábado, eles gostam de ocupar os melhores lugares nas sinagogas. Nos banquetes, gostam de se sentar nos lugares de maior honra. ");
INSERT INTO portft_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Eles tiram pela fraude as casas e propriedades das viúvas, e fingem de bonzinhos, fazendo longas orações públicas. São pessoas que Deus vai castigar severamente. ");
INSERT INTO portft_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Enquanto Jesus estava sentado no pátio do templo, frente às caixas onde as pessoas depositavam dinheiro ofertado a Deus, ele observava a multidão que colocava dinheiro na caixa. Muitos ricos depositavam grandes quantias, ");
INSERT INTO portft_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","mas chegou uma pobre viúva que colocou duas moedinhas de pouco valor. ");
INSERT INTO portft_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ele chamou os discípulos e disse a eles: - Digo de verdade que Deus estima mais o dinheiro oferecido por esta pobre viúva que todas as ofertas das demais pessoas; ");
INSERT INTO portft_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","os ricos deram somente uma parte daquilo que possuem, mas ela, sendo tão pobre, deu todo o dinheiro que tinha para viver. ");
INSERT INTO portft_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Enquanto Jesus estava saindo do pátio do templo, um dos discípulos disse a ele: -Mestre, veja estas magníficas pedras, e como são maravilhosos estes prédios! ");
INSERT INTO portft_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus disse a ele: -Quero dizer algo a vocês sobre estes grandes edifícios que estão vendo. Outras pessoas vão destruí-los completamente, e não vai ficar aqui nem uma pedra em cima de outra. ");
INSERT INTO portft_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Depois que eles chegaram no Monte das Oliveiras, ao outro lado do vale do local do templo, Jesus se sentou. Quando já se encontravam a sós, Pedro, Tiago, João e André disseram a ele, ");
INSERT INTO portft_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","–Diga-nos, quando vai acontecer aquilo que você acaba de falar? Diga-nos o que vai acontecer para mostrar que todos os planos de Deus acabam de ser realizados. ");
INSERT INTO portft_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus respondeu a eles: -Cuidado, para que não sejam enganados por ninguém acerca daquilo que vai acontecer, ");
INSERT INTO portft_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","pois vão aparecer muitas pessoas que dirão que foram mandadas por Deus. Especificamente, elas vão dizer, “Eu sou o Messias.” Fazendo assim, vão enganar muitas pessoas. ");
INSERT INTO portft_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","E sempre que as pessoas falarem de guerras aqui ou ali, não tenham medo. Deus já decretou que isto tem que acontecer. Mas quando acontecer, não é sinal de que tudo o que Deus planejou já foi completado. ");
INSERT INTO portft_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Quer dizer, as pessoas que moram em diversos países, e vários governos, vão lutar uns contra outros; vai haver terremotos em muitos lugares, e vai haver fome e carência. Mesmo assim, quando estas coisas acontecerem, é somente o início dos sofrimentos das pessoas; vai haver ainda mais. Vai ser como as primeiras dores do parto que uma mulher sofre quando chega a hora de dar à luz. ");
INSERT INTO portft_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Cuidado com as ações das pessoas naqueles dias, pois elas vão prender vocês e levá-los para o tribunal para serem acusados pelos conselhos religiosos. Nos lugares onde vocês se congregam para adorar a Deus, serão surrados pelos outros. O povo vai acusar vocês na presença de governantes e reis por causa da sua fé em mim. Deus vai permitir que eles assim façam para que vocês possam pregar as boas notícias a eles. ");
INSERT INTO portft_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Vocês devem proclamar as boas notícias a todos os grupos étnicos antes de se completar tudo o que Deus planejou. ");
INSERT INTO portft_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","E quando proclamarem as boas notícias, as pessoas vão prender vocês para persegui-los por causa da sua fé em mim. Não se preocupem antes da hora, mas digam o que Deus lhes indicar no momento; não serão vocês que falam, senão o Espírito Santo que fala por meio de vocês. ");
INSERT INTO portft_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","E vão acontecer outras coisas ruins: os homens vão trair os seus irmãos para que sejam mortos por outros. E os pais vão trair seus filhos, e os filhos os seus pais, fazendo com que outros os matem. ");
INSERT INTO portft_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Em geral, vocês vão ser odiados por quase todas as pessoas por causa da sua fé em mim. Mas Deus vai salvar todas as pessoas que continuarem firmes no meu caminho até o fim da sua vida. ");
INSERT INTO portft_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Vai haver um tempo quando vocês verão algo asqueroso que vai poluir o templo e levar as pessoas a abandoná-lo, ficando onde não deve estar. Que todos os leitores prestem bem atenção a isto! Naquele tempo as pessoas que estiverem no distrito da Judeia devem fugir para os montes mais altos. ");
INSERT INTO portft_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","As pessoas que estiverem fora das suas casa, não devem entrar para pegar os seus pertences antes de fugir. ");
INSERT INTO portft_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","E aquelas pessoas que estiverem trabalhando no campo não devem voltar para as suas casas para buscar mais roupas antes de fugir. ");
INSERT INTO portft_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Sinto pena das mulheres grávidas e das que estiverem amamentando naqueles dias! ");
INSERT INTO portft_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Orem também que isto não aconteça no inverno, quando é difícil viajar por causa do tempo,  ");
INSERT INTO portft_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","pois naqueles dias as pessoas vão sofrer de uma maneira nunca conhecida desde que Deus criou o mundo até agora. ");
INSERT INTO portft_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Se o Senhor não tivesse resolvido abreviar aquele tempo de sofrimento humano, ninguém iria sobreviver; mas ele resolveu abreviar o tempo porque tem cuidado das pessoas escolhidas por ele. ");
INSERT INTO portft_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Naquele tempo, se alguém disser a você, “Olhe, aqui está o Messias!”, ou se alguém disser, “Olhe, lá está ele!”, não acredite, ");
INSERT INTO portft_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","pois vão aparecer falsos Messias e falsos profetas; eles vão praticar milagres que as pessoas comuns não conseguem fazer, para enganar até as pessoas escolhidas por Deus, se fosse possível. Mas eles não poderão enganá-las. ");
INSERT INTO portft_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Por isso, fiquem atentos, pois eu já lhes adverti sobre tudo isso antes que aconteça. ");
INSERT INTO portft_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Depois do tempo daquele sofrimento das pessoas, o sol vai escurecer e a lua vai deixar de brilhar; ");
INSERT INTO portft_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","as estrelas vão cair do céu e Deus vai sacudir todas as coisas no céu. ");
INSERT INTO portft_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Então as pessoas vão ver-me, o homem que veio do céu, chegando através das nuvens com poder e glória. ");
INSERT INTO portft_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Depois, vou mandar anjos para chamarem as pessoas que escolhi de todos os lugares, incluindo os lugares mais remotos da terra. ");
INSERT INTO portft_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Aprendam agora algo das figueiras. Quando os ramos delas ficam verdes e as folhas começam a brotar, vocês sabem que o verão está perto. ");
INSERT INTO portft_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Da mesma forma, quando vocês virem acontecer tudo aquilo que acabo de dizer, vão saber que está bem perto a hora da minha volta. ");
INSERT INTO portft_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Especificamente, digo a vocês que tudo isto vai acontecer antes da morte das pessoas que observaram as coisas que fiz e falei. ");
INSERT INTO portft_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mesmo que estejam firmes a terra e as coisas do céu, todas elas vão desaparecer; mas aquilo que eu vaticinei vai com certeza acontecer. ");
INSERT INTO portft_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mas ninguém sabe a hora exata daquilo que acabo de descrever. Os anjos do céu também não sabem. Eu mesmo, o filho de Deus, não sei com certeza; somente meu Pai sabe. ");
INSERT INTO portft_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Portanto, fiquem atentos, pois não sabem quando será a hora de tudo isto acontecer. ");
INSERT INTO portft_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ao sair de casa um homem que ia viajar a um lugar distante, mandou seus servos tomarem conta da casa, explicando a cada um deles seu dever particular; depois, mandou o porteiro ficar alerta. ");
INSERT INTO portft_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Da mesma forma, vocês devem ficar vigilantes, pois não sabem quando eu, como o dono daquela casa, vou voltar. Pode ser à noite, ou à meia-noite, ou quando o galo cantar, ou de manhã. ");
INSERT INTO portft_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Não será bom se eu, na minha volta, encontrar vocês dormindo. ");
INSERT INTO portft_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","O que digo a vocês discípulos, digo a todos aqueles que creem em mim: Fiquem vigiando! ");
INSERT INTO portft_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Faltavam apenas dois dias antes da celebração da festa chamada Páscoa, quando se comia pão sem fermento. As pessoas celebravam esta festa durante uma semana inteira. Os principais sacerdotes e professores da lei que Deus tinha dado a Moisés planejavam uma maneira de prender Jesus secretamente para que as autoridades o matassem. ");
INSERT INTO portft_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mas eles diziam uns aos outros: -Não vamos fazer isto durante a festa chamada Páscoa, pois se assim fizermos, as pessoas que apoiam Jesus vão ficar zangadas e talvez fazer um motim. ");
INSERT INTO portft_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Quando Jesus estava na vila de Betânia, na casa de Simão, um homem que Jesus tinha curado de lepra, entrou uma mulher durante o jantar. Ela trazia um frasco feito de alabastro, cheio de um perfume caro e cheiroso chamado nardo. Ela abriu o frasco e derramou o perfume na cabeça de Jesus. ");
INSERT INTO portft_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Alguns dos presentes se zangaram e disseram uns aos outros: -Que desperdício de perfume! ");
INSERT INTO portft_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Poderia ser vendido por mais dinheiro do que se ganha num ano inteiro, e então ele poderia dar o dinheiro aos pobres. Assim eles criticavam a mulher. ");
INSERT INTO portft_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mas Jesus disse: -Não perturbem essa mulher! Não quero que a incomodem, pois ele fez algo gostoso para mim. ");
INSERT INTO portft_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Vai ter sempre pobres entre vocês, por isso vocês podem ajudá-los quando quiserem; porém, eu nem sempre vou estar aqui entre vocês. Por isso é bom as pessoas mostrarem o seu amor por mim enquanto estou aqui na terra.  ");
INSERT INTO portft_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Portanto, é apropriado ela fazer o que pôde. Especificamente, é como se ela soubesse que eu ia morrer, por isso veio ungir meu corpo antes da morte para me preparar para o enterro. ");
INSERT INTO portft_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Digo de verdade que por todo o mundo, onde as boas notícias forem pregadas, as pessoas vão contar o que ela fez, e como resultado todo o mundo vai se lembrar dela. ");
INSERT INTO portft_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Então Judas, que era da vila de Cariote, um dos doze discípulos, foi falar com os principais sacerdotes sobre o plano de entregar Jesus em mãos deles. ");
INSERT INTO portft_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Quando eles ouviram as palavras dele, ficaram bem contentes e prometeram dar dinheiro a ele por ter feito isso. Como resultado, ele começou a tramar uma maneira conveniente de trair Jesus. ");
INSERT INTO portft_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Já era o primeiro dia da festa chamada Páscoa, quando as pessoas costumavam comer pão sem fermento e matar carneirinhos, como Deus mandou seus antepassados fazerem quando os salvou dos egípcios. Os discípulos de Jesus disseram a ele: -Onde você quer que preparemos o jantar da Páscoa para nós? ");
INSERT INTO portft_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Então ele mandou dois dos discípulos fazer este serviço, dizendo primeiro a eles: -Vão até a cidade de Jerusalém. Lá um homem carregando uma jarra de água vai se encontrar com vocês. Sigam após ele. ");
INSERT INTO portft_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Quando ele entrar numa casa, digam ao dono da casa, “O mestre quer saber onde fica a sala que ele reservou em que ele deve comemorar o jantar da Páscoa com seus discípulos.” ");
INSERT INTO portft_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ele vai lhes mostrar uma sala bem grande no andar de cima da casa, já mobiliada e pronta para nosso jantar. Preparem ali a comida para nós. ");
INSERT INTO portft_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Os dois discípulos saíram. Eles foram até a cidade, e encontraram tudo como Jesus tinha falado. Então prepararam o jantar da Páscoa. ");
INSERT INTO portft_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Quando já era de noite, Jesus chegou com os doze discípulos nessa casa. ");
INSERT INTO portft_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Enquanto eles estavam sentados, jantando, Jesus disse: -Digo de verdade que um de vocês vai me entregar em mãos dos meus inimigos. Especificamente, é um de vocês que estão jantando comigo. ");
INSERT INTO portft_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Os discípulos ficaram muito tristes e disseram a ele, um por um: -Com certeza não sou eu!. ");
INSERT INTO portft_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Então ele disse a eles: -É um de vocês doze discípulos, aquele que molha o pão no prato comigo. ");
INSERT INTO portft_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","É verdade que eu, o homem do céu, vou morrer para cumprir o que foi dito sobre mim nas Escrituras, mas ai daquele homem que vai entregar o homem do céu em mãos dos inimigos. De fato, para ele era melhor nunca ter nascido. ");
INSERT INTO portft_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Enquanto eles estavam comendo, Jesus pegou um pão; deu graças a Deus pelo pão, partiu em pedaços, deu a todos eles e disse: -Peguem esse pão, que representa meu corpo. ");
INSERT INTO portft_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Depois, pegou o cálice de vinho; deu graças a Deus pelo vinho, passou para eles, e todos beberam do cálice. ");
INSERT INTO portft_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ele disse a eles: -Este vinho representa meu sangue, que em breve vou derramar por muitas pessoas, para confirmar a aliança que Deus fez para salvar as pessoas.  ");
INSERT INTO portft_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Digo de verdade que não vou beber mais vinho até o momento de beber com um novo significado quando Deus estiver reinando. ");
INSERT INTO portft_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Depois de cantarem um hino, eles saíram em direção ao Monte das Oliveiras. ");
INSERT INTO portft_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Enquanto estavam caminhando, Jesus disse a eles: -Todos vocês vão me abandonar e fugir, pois vai se cumprir aquilo que os profetas escreveram nas Escrituras, que Deus disse sobre mim, “Vou matar o pastor, e as ovelhas dele vão ficar espalhadas.” ");
INSERT INTO portft_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mas, depois de Deus me fazer viver de novo, vou adiante de vocês e encontrar- me com vocês no distrito da Galileia. ");
INSERT INTO portft_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Então Pedro disse a ele: -Se todos os demais discípulos abandonarem você, você vai achar que eu também vou lhe abandonar; mas eu não vou abandonar você. ");
INSERT INTO portft_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Então Jesus disse a ele: -Digo de verdade que, nesta mesma noite, antes do galo cantar a segunda vez, você mesmo vai negar três vezes que me conhece! ");
INSERT INTO portft_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mas Pedro respondeu com força: -Mesmo que seja preciso eu morrer com você, não vou negar conhecê-lo. E todos os demais discípulos disseram o mesmo. ");
INSERT INTO portft_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesus e os discípulos foram a um lugar chamado Getsêmani. Então ele disse a alguns dos discípulos: -Sentem-se aqui, enquanto eu vou orar. ");
INSERT INTO portft_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Então ele levou consigo Pedro, Tiago e João. Ficou perturbado e angustiado, e disse a eles, ");
INSERT INTO portft_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","–Sinto tanta tristeza que parece que vou morrer. Fiquem aqui, bem acordados. ");
INSERT INTO portft_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ele se afastou um pouco; prostrou-se no chão e orou que, se fosse possível, pudesse evitar aquilo que ia acontecer a ele nas próximas horas. ");
INSERT INTO portft_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jesus disse: -Aba, meu Pai! Já que você é capaz de fazer qualquer coisa, afasta de mim isto que devo sofrer agora. Mas não faça aquilo que eu quero, senão aquilo que você quer. ");
INSERT INTO portft_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Então ele voltou e encontrou os discípulos dormindo. Ele os acordou e disse a Pedro: -Simão! Fico decepcionado com você, que está dormindo e nem pôde ficar acordado durante tão pouco tempo. ");
INSERT INTO portft_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","E ele disse a todos eles: -Fiquem acordados, orando, para poderem resistir a tentação de Satanás, pois vocês querem fazer o que digo, mas não têm bastante força para realmente conseguir. ");
INSERT INTO portft_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Então ele se afastou novamente e começou a orar, dizendo as mesmas palavras. ");
INSERT INTO portft_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Quando ele voltou, encontrou os discípulos dormindo de novo porque tinham muito sonho. E eles nem sabiam o que dizer a Jesus quando ele os acordou. ");
INSERT INTO portft_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Então ele foi orar mais uma vez; voltou pela terceira vez e os encontrou dormindo de novo. Ele disse a eles: -Fico desapontado com vocês, pois ainda estão dormindo e descansando. Já dormiram o suficiente. Chegou a hora que Deus designou para eu sofrer. Escutem bem! Vem alguém trair o homem do céu, e ele vai me entregar em mãos dos pecadores para eles fazerem o que quiserem comigo. ");
INSERT INTO portft_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Portanto, levantem-se! Vamos! Olhem! Acaba de chegar o homem que quer me entregar em mãos dos meus inimigos. ");
INSERT INTO portft_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Enquanto ele ainda estava falando, chegou Judas, um dos doze discípulos. Com ele veio uma multidão levando espadas e cacetes, mandada pelos principais sacerdotes, professores da lei que Deus tinha dado a Moisés e anciãos. ");
INSERT INTO portft_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Antes disso, para saberem qual dos homens deveriam prender, Judas (que ia entregar Jesus nas mãos dos seus inimigos) tinha dito a eles: -O homem que eu beijar é aquele que vocês querem prender. Portanto, peguem-no e guardem com cuidado. ");
INSERT INTO portft_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Por isso, ao chegar, Judas foi imediatamente até Jesus e disse: -Meu mestre! E beijou Jesus. ");
INSERT INTO portft_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Então a multidão pegou Jesus e guardou bem seguro. ");
INSERT INTO portft_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Um dos discípulos que estava por perto puxou da espada e bateu no servo do grande sacerdote, cortando a orelha dele. ");
INSERT INTO portft_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus respondeu, dizendo a eles: -É ridículo vocês virem aqui para me prender com espadas e cacetes, como se eu fosse um bandido. ");
INSERT INTO portft_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Dia após dia eu estava com vocês no templo, ensinando o povo, e vocês não me prenderam. Mas isto está acontecendo para cumprir aquilo que foi escrito sobre mim nas Escrituras. ");
INSERT INTO portft_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Todos os discípulos abandonaram Jesus e fugiram. ");
INSERT INTO portft_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Naquele tempo eu, um jovem, estava seguindo Jesus; vestia somente um pano de linho em volta do meu corpo. A multidão me prendeu, ");
INSERT INTO portft_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","e eu fugi nu, deixando nas mãos do povo o pano que vestia. ");
INSERT INTO portft_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","As pessoas que prenderam Jesus o levaram para a casa onde morava o grande sacerdote. Todos os principais sacerdotes, anciãos e professores da lei que Deus tinha dado a Moisés estavam reunidos lá. ");
INSERT INTO portft_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro seguiu atrás de Jesus, bem longe; ele entrou no pátio da casa onde morava o grande sacerdote, e ficou lá. Ele estava sentado com os homens que guardavam a casa do grande sacerdote, esquentando-se perto do fogo. ");
INSERT INTO portft_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Os principais sacerdotes e o conselho judaico procuravam pessoas que pudessem testemunhar contra Jesus para matá-lo. Mas não conseguiram encontrar ninguém ");
INSERT INTO portft_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","pois, embora muitas pessoas falassem com mentiras contra ele, elas se contradiziam umas às outras. ");
INSERT INTO portft_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Especificamente, algumas pessoas ficaram de pé e mentiam assim, ");
INSERT INTO portft_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","–Ouvimos Jesus dizer, “Vou destruir este templo construído pelos homens, e dentro de três dias vou construir outro templo não edificado pelos homens.”– ");
INSERT INTO portft_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mas as palavras de alguns destes homens contrariaram as palavras de outros. ");
INSERT INTO portft_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","O grande sacerdote se levantou na frente deles e disse a Jesus: -Fico surpreso de você não responder nada. O que você tem a dizer sobre aquilo que eles estão dizendo, acusando você? ");
INSERT INTO portft_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mas embora fosse inocente das acusações, Jesus ficava calado e não respondeu nada. O grande sacerdote tornou a perguntar, dizendo a ele: -Você é o Messias, o Filho de Deus? ");
INSERT INTO portft_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus disse: -Sou. E você vai me ver, o homem do céu, sentado onde se senta a pessoa mais honrada, ao lado de Deus todo-poderoso, e também vai me ver descendo através das nuvens. ");
INSERT INTO portft_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","O grande sacerdote rasgou as roupas, conforme o costume deles, para mostrar que estava horrorizado com a afirmação de Jesus de que era igual a Deus; depois disse: -Não precisamos de mais testemunhas contra ele, ");
INSERT INTO portft_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","pois vocês todos ouviram o que ele disse contra Deus, alegando ser igual a Deus. Portanto, qual é a sua decisão? Eles todos disseram que Jesus era culpado e devia morrer. ");
INSERT INTO portft_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Alguns deles começaram a cuspir em Jesus. Puseram um pano para tapar os olhos dele e começaram a bater nele, dizendo: -Se você for profeta, diga quem foi que lhe bateu! Aqueles que guardavam a casa onde morava o grande sacerdote deram bofetadas em Jesus. ");
INSERT INTO portft_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Enquanto Pedro ficava no pátio, fora da casa, uma das empregadas do grande sacerdote se aproximou dele. ");
INSERT INTO portft_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Quando viu Pedro aquecendo- se perto do fogo, olhou bem na cara dele e depois disse: -Você também esteve com Jesus, aquele homem da vila de Nazaré. ");
INSERT INTO portft_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mas ele o negou, dizendo: -Não o conheço e não entendo de que você está falando. E ele se retirou dali para o portão do pátio. ");
INSERT INTO portft_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","A empregada o viu lá e disse novamente às pessoas reunidas perto dali: -Este homem foi um daqueles que estavam com Jesus. ");
INSERT INTO portft_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mas ele negou de novo. Pouco depois, as pessoas ali reunidas disseram novamente a Pedro: -Está claro que você esteve com Jesus, pois a maneira como você fala mostra que você também é do distrito da Galileia. ");
INSERT INTO portft_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mas ele começou a exclamar: -Não conheço o homem de que vocês estão falando! Já que Deus sabe que digo a verdade, que ele me castigue se não é como eu digo! ");
INSERT INTO portft_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Imediatamente o galo cantou pela segunda vez. Pedro se lembrou o que Jesus tinha dito a ele: -Antes do galo cantar duas vezes, você vai negar três vezes que me conhece. Quando Pedro se deu conta do que tinha feito, começou a chorar. ");
INSERT INTO portft_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","De manhã cedo, os principais sacerdotes se reuniram com os anciãos, os professores da lei que Deus tinha dado a Moisés e demais membros do conselho judaico, para tirarem a sorte de Jesus. Os guardas amarraram Jesus e levaram embora; depois entregaram Jesus a Pilatos, o romano que governava a Judeia.  ");
INSERT INTO portft_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatos perguntou a Jesus: -Você é o rei que governa os judeus? Jesus respondeu: -Você mesmo afirmou isso. ");
INSERT INTO portft_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Então os principais sacerdotes alegaram que Jesus tinha feito muita coisa ruim. ");
INSERT INTO portft_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatos perguntou novamente: -Você não tem nada a dizer? Escute todas as acusações que fazem contra você! ");
INSERT INTO portft_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mas Jesus não disse mais nada; Pilatos, portanto, ficou bem admirado. ");
INSERT INTO portft_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Todos os anos, durante a celebração da festa judaica chamada Páscoa, Pilatos costumava soltar um preso. Especificamente, costumava soltar um preso indicado pelo povo. ");
INSERT INTO portft_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bom, naquela altura havia um homem chamado Barrabás, que foi preso com outros elementos. Eles tinham assassinado algumas pessoas durante uma revolta contra os romanos, que governavam o país. ");
INSERT INTO portft_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Uma multidão se aproximou de Pilatos, pedindo para ele soltar alguém, como sempre fazia durante os dias da festa judaica da Páscoa. ");
INSERT INTO portft_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatos respondeu: -Vocês querem que eu lhes solte o homem que o povo chama o rei que governa os judeus? ");
INSERT INTO portft_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ele perguntou isso porque sabia que os principais sacerdotes tinham entregado Jesus a ele por causa da inveja que tinham dele, pois muitas pessoas estavam se tornando discípulos de Jesus.  ");
INSERT INTO portft_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mas os principais sacerdotes instigaram a multidão a pedir que Pilatos soltasse Barrabás, ao invés de Jesus. ");
INSERT INTO portft_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatos disse novamente a eles: -Se eu soltar Barrabás, o que vocês querem que eu faça com o homem que vocês chamam o rei que governa os judeus? ");
INSERT INTO portft_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Então eles gritaram de novo: -Mande os soldados crucificarem Jesus! ");
INSERT INTO portft_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Então Pilatos disse a eles: -Por que? Ele cometeu algum crime? Mas eles gritaram ainda mais alto: -Mande os soldados crucificá-lo! ");
INSERT INTO portft_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Por isso, já que Pilatos queria agradar a multidão, ele lhes soltou Barrabás. Ele mandou que os soldados surrassem Jesus com chicotes contendo pedacinhos metálicos, e depois de eles surrarem Jesus, Pilatos mandou os soldados levá-lo embora para ser crucificado. ");
INSERT INTO portft_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Então os soldados levaram Jesus até o pátio da casa onde morava Pilatos, chamada de Pretório, e chamaram o grupo inteiro de soldados. ");
INSERT INTO portft_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Depois que os soldados se reuniram, vestiram Jesus com uma capa roxa, do tipo usado pelos reis; colocaram na cabeça dele uma coroa feita de ramos cheios de espinhos. Fizeram isso para zombar dele, fazendo de conta que ele era rei.  ");
INSERT INTO portft_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Então saudaram Jesus como rei, zombando dele e dizendo: -Viva, Rei dos judeus! ");
INSERT INTO portft_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Batiam repetidas vezes na cabeça dele com uma vara; cuspiam nele e, ajoelhando-se, fingiam homenageá-lo. ");
INSERT INTO portft_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Depois de zombarem dele, tiraram dele a capa roxa e lhe vestiram suas próprias roupas. Então o levaram para fora da cidade para crucificá-lo. ");
INSERT INTO portft_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pelo caminho, os soldados obrigaram um homem chamado Simão a carregar a cruz para Jesus. Ele era da cidade de Cirene e era pai de Alexandre e Rufo; ele passava por lá ao voltar do campo para a cidade. ");
INSERT INTO portft_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Eles os levaram a um lugar chamado em língua aramaica de Gólgota, que significa “um lugar parecido com uma caveira”. ");
INSERT INTO portft_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Então, embora tentassem dar a Jesus vinho misturado com um medicamento chamado mirra para que a crucificação não lhe doesse tanto, ele não quis beber. ");
INSERT INTO portft_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Alguns soldados tiraram a roupa dele e depois o crucificaram. Depois, dividiram suas roupas entre si, jogando algo semelhante aos dados para determinar qual peça de roupa receberia a cada um deles. ");
INSERT INTO portft_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Eram nove horas da manhã quando eles crucificaram Jesus. ");
INSERT INTO portft_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pregaram na cruz por cima da cabeça de Jesus, uma tabuleta, na qual alguém tinha escrito a acusação contra ele. Estava escrito o seguinte, “O rei que governa os judeus”. ");
INSERT INTO portft_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Eles também crucificaram lá dois homens que tinham roubado à força objetos que pertenciam a outras pessoas. Especificamente, eles crucificaram um deles à direita de Jesus e um à esquerda dele. ");
INSERT INTO portft_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","As pessoas que por ali passavam insultavam Jesus, balançando a cabeça como se ele fosse um homem vil, e dizendo: -Ah! Você disse, “Vou destruir o templo e construí-lo novamente dentro de três dias”. ");
INSERT INTO portft_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Se você era capaz de fazer assim, então salve-se agora, descendo da cruz! ");
INSERT INTO portft_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Os principais sacerdotes, junto com os professores da lei que Deus tinha dado a Moisés, comentavam entre si em tom de zombaria: -Eles alega ter ajudado outras pessoas, mas não pode ajudar-se a si mesmo! ");
INSERT INTO portft_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Já que ele disse: “Sou o Messias, o rei que governa o povo de Israel”, então ele deve descer agora da cruz, para que nós vejamos e acreditemos que o que ele diz é verdade. E aqueles dois homens que estavam sendo crucificados ao lado dele o insultaram também. ");
INSERT INTO portft_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ao meio-dia, a terra inteira ficou escura durante três horas. ");
INSERT INTO portft_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Às três horas da tarde, Jesus gritou em voz alta numa mistura das línguas hebraica e aramaica: -Eloí, eloí, lemá sabactani? que quer dizer: -Meu Deus, meu Deus, por que você me abandonou? ");
INSERT INTO portft_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Quando algumas pessoas que ali ficavam ouviram isso, disseram: -Escutem! Ele está chamando o profeta Elias. ");
INSERT INTO portft_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Uma delas correu para molhar uma esponja em vinho azedo, que colocou na ponta de uma vara e estendeu para Jesus beber o vinho. Enquanto estava fazendo isso, alguém disse: -Esperem! Vamos ver se Elias vem tirá-lo da cruz. ");
INSERT INTO portft_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Então, após um grito forte, Jesus morreu. ");
INSERT INTO portft_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nesse momento a cortina do templo que impediu as pessoas comuns de entrarem na presença de Deus, na parte mais santa do templo, rasgou em dois pedaços, de cima para baixo. ");
INSERT INTO portft_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","E, quando o homem que supervisava os soldados que crucificavam Jesus, e que ficava em frente de Jesus, viu como ele morreu, exclamou: -De fato, esse homem era o filho de Deus! ");
INSERT INTO portft_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Havia também algumas mulheres, que observavam à distância. ");
INSERT INTO portft_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Especificamente, havia Maria da vila de Magdala; outra Maria, mãe de Tiago o mais moço e de José; e Salomé – aquelas que, quando Jesus ainda estava no distrito da Galileia, costumavam acompanhá-lo e providenciar o que ele precisava; e muitas outras mulheres que tinham vindo com ele até a cidade de Jerusalém. ");
INSERT INTO portft_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ao anoitecer, sendo uma sexta-feira, dia da preparação judaica para o sábado, chegou José da vila de Arimateia. Ele era membro do conselho judaico, respeitado de todos. Era um daqueles que esperavam ansiosamente o momento de Deus enviar seu rei. Ele sabia que a lei judaica exigia que, após a execução de alguém, o corpo do defunto fosse enterrado antes do pôr-do-sol daquele mesmo dia. Por isso, para que o corpo de Jesus não ficasse na cruz, violando o sábado, e com o dia quase no fim, ele criou coragem e se dirigiu a Pilatos, pedindo autorização para tirar o corpo de Jesus da cruz. ");
INSERT INTO portft_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatos ficou admirado ao ouvir que Jesus já estava morto. Por isso ele chamou o supervisor dos soldados que tinham crucificado Jesus, perguntando se efetivamente Jesus tinha morrido. ");
INSERT INTO portft_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Quando o supervisor dos soldados afirmou que Jesus já estava morto, Pilatos autorizou José a tirar o corpo dele. ");
INSERT INTO portft_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Depois de comprar um lençol de linho, ele e outros tiraram o corpo de Jesus da cruz; envolveram o corpo no lençol de linho e deitaram num túmulo, uma gruta cavada numa rocha. Então fizeram rodar uma grande pedra sobre a entrada do túmulo. ");
INSERT INTO portft_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria da vila de Magdala e Maria a mãe de Jesus ficavam observando o lugar onde colocaram o corpo de Jesus. ");
INSERT INTO portft_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sábado à noite, ao findar o sábado judaico, Maria da vila de Magdala e Maria a mãe de Tiago, o mais moço, junto com Salomé, compraram unguento perfumado. Era costume judaico ungir os corpos antes de enterrar, e as mulheres desejavam seguir esse costume. ");
INSERT INTO portft_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Por isso, bem cedo de manhã no domingo elas levaram o unguento perfumado até o túmulo logo após o sol nascer. ");
INSERT INTO portft_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Enquanto iam caminhando, diziam umas às outras: -Quem vai tirar para nós a pedra que fecha a entrada do túmulo? ");
INSERT INTO portft_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ao chegarem, olharam e notaram que alguém já tinha tirado a pedra. Ficaram perplexas, pois era uma pedra bem grande. ");
INSERT INTO portft_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Elas entraram no túmulo e viram um jovem, sentado à direita e vestido de roupa branca; vendo isso, ficaram pasmadas. ");
INSERT INTO portft_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","O jovem disse a elas: -Não se espantem; sei que vocês estão procurando Jesus, o homem da vila de Nazaré, aquele que crucificaram. ");
INSERT INTO portft_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mas ele se tornou vivo de novo. Não está mais aqui. Olhem! Este é o lugar onde colocaram o corpo dele. Mas, ao invés de ficarem aqui, vão já! Digam aos discípulos dele, especialmente o Pedro, que Jesus está indo adiante deles até o distrito da Galileia, e que lá vão vê-lo, bem como ele já falou para eles. ");
INSERT INTO portft_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","As mulheres saíram e fugiram do túmulo, pois estavam pasmadas e tremendo de medo. E não disseram nada para ninguém pelo caminho, pois estavam com medo. ");
INSERT INTO portft_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Quando Jesus ressuscitou da morte bem cedo no domingo, o primeiro dia da semana, ele apareceu primeiro a Maria da vila de Magdala, da qual ele tinha expulsado sete espíritos maus. ");
INSERT INTO portft_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ela foi logo contar o que tinha acontecido aos que choravam e lamentavam. ");
INSERT INTO portft_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mas, quando eles ouviram que Jesus estava vivo de novo, e que ela o tinha visto, não acreditaram. ");
INSERT INTO portft_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Depois disso, Jesus, agora de aspecto bem diferente, apareceu a dois homens que antes o tinham acompanhado, enquanto os dois caminhavam da cidade de Jerusalém ao campo na vizinhança. ");
INSERT INTO portft_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Eles voltaram a Jerusalém e contaram o que tinha acontecido, tinham estado com ele, mas eles também não acreditaram. ");
INSERT INTO portft_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mais tarde, Jesus mesmo apareceu aos onze discípulos durante o jantar. Ele lhes censurou o fato de não acreditarem que ele estava vivo de novo, pois eles teimaram em não dar crédito aos relatórios daqueles que tinham visto Jesus depois da sua ressurreição. ");
INSERT INTO portft_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ele disse a eles: -Vão pelo mundo inteiro, pregando as boas notícias a todas as pessoas. ");
INSERT INTO portft_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Deus vai salvar todos aqueles que crerem e forem batizados; mas Deus vai condenar todos aqueles que não crerem. ");
INSERT INTO portft_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Os que acreditarem nas boas notícias vão praticar milagres. Especificamente, sendo capacitados por mim, eles vão expulsar espíritos maus. Eles vão falar línguas que nunca aprenderam. ");
INSERT INTO portft_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Se por acaso pegarem em cobras, ou beberem algo venenoso sem saber, não vão sofrer nenhum mal. E se puserem as mãos sobre os doentes para Deus curar, aqueles doentes vão ficar sarados. ");
INSERT INTO portft_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Depois do Senhor Jesus dizer tudo isto aos discípulos, ele foi levado por Deus até o céu, onde se sentou no seu trono ao lado de Deus, no lugar de maior honra. ");
INSERT INTO portft_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Depois de saírem os discípulos da cidade de Jerusalém, pregaram por toda parte, e o Senhor os fazia praticar milagres em todos os lugares. Como resultado, o povo acreditou ser verdadeira a mensagem de Deus. ");
INSERT INTO portft_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Meu estimado amigo Teófilo, muitas pessoas viram as coisas que Jesus fez enquanto estava conosco, desde o tempo quando começou a servir a Deus. Elas serviram a Deus ao ensinar aos outros a mensagem de Deus. Muitos daqueles que ouviram o que estas pessoas ensinaram escreveram para nós relatos das coisas que Jesus fez. ");
INSERT INTO portft_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Eu mesmo tenho estudado com cuidado estes assuntos, que começaram antes dele nascer. Então resolvi que seria bom que eu também escrevesse para você um relato destes assuntos. ");
INSERT INTO portft_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Quero que você saiba a verdade daquilo que outros ensinaram a você. ");
INSERT INTO portft_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Quando o grande Rei Herodes governava o distrito da Judeia, havia um sacerdote judaico chamado Zacarias. Ele pertencia ao grupo de sacerdotes chamado o Grupo de Abias. Ele e sua esposa Isabel eram descendentes do primeiro sacerdote de Israel, Arão. ");
INSERT INTO portft_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Deus considerava/achava que os dois eram justos, porque sempre obedeciam sem falha tudo que Deus tinha mandado. ");
INSERT INTO portft_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mas eles não tinham filhos, porque Isabel não podia ter filhos. Além disso, ela e seu esposo eram muito idosos. ");
INSERT INTO portft_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Certo Dia o grupo de Zacarias estava fazendo seu trabalho no templo em Jerusalém, e ele estava servindo como sacerdote na presença de Deus. ");
INSERT INTO portft_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Seguindo o seu costume, os outros sacerdotes o escolheram por sorteio para entrar no templo do Senhor e queimar incenso. ");
INSERT INTO portft_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Enquanto ele queimava o incenso, muitos estavam no pátio, orando. ");
INSERT INTO portft_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aí um anjo que o Senhor Deus tinha mandado apareceu a ele. O anjo estava em pé no lado direito do lugar onde os sacerdotes queimavam incenso. ");
INSERT INTO portft_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarias estava assustado quando viu o anjo, e ficou com muito medo. ");
INSERT INTO portft_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mas o anjo lhe disse, “Zacarias, não tenha medo! Quando você orou pedindo a Deus um filho (ou, que Deus mandasse o Messias), Deus ouviu o que você disse. Por isso sua esposa Isabel vai dar um filho para você. Você deve dar a ele o nome de João. ");
INSERT INTO portft_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ele vai fazer com que você esteja muito feliz, e muitos outros também vão estar muito felizes porque ele nasceu. ");
INSERT INTO portft_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Deus vai considerá-lo muito importante. Ele nunca deve beber vinho nem outra bebida alcoólica, para que seja dedicado totalmente a Deus. O Espírito Santo vai controlá-lo desde o dia quando ele nascer. ");
INSERT INTO portft_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ele vai convencer muitas pessoas em Israel a deixarem os seus pecados e a agradarem o Senhor seu Deus. ");
INSERT INTO portft_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Já que o Espírito de Deus vai ajudá-lo a pregar com poder assim como o profeta Elias, ele vai preceder o Messias. Ele vai fazer com que os pais ajam de maneira pacífica com seus filhos novamente. Ele vai fazer com que muitos que não obedecem Deus ouçam e façam as coisas certas que as pessoas justas dizem a eles. Ele vai fazer isso para preparar as pessoas para quando o Messias vier.” ");
INSERT INTO portft_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aí Zacarias disse ao anjo, “Sou muito velho, portanto não posso ter filho. Minha esposa também é tão velha que não pode ter filho. Portanto, não posso/como é que posso crer que o que o senhor diz vai acontecer!” ");
INSERT INTO portft_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Então o anjo disse a ele, “Sou Gabriel, o anjo mais importante de Deus. Faço o que Deus me diz, porque fico constantemente na presença de Deus. Ele me mandou para dizer a você esta boa mensagem sobre o que vai acontecer a você. ");
INSERT INTO portft_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mas mesmo que o que eu lhe disse vá acontecer na hora que Deus tenha determinado, você não acreditou que minhas palavras sejam a verdade. Então Deus vai fazer com que você não possa falar até o dia quando isso acontecer/seu filho nascer.” ");
INSERT INTO portft_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Enquanto estavam falando, as pessoas no pátio estavam esperando Zacarias sair. Eles pensavam, “Por que ele está ficando tanto tempo no templo?” ");
INSERT INTO portft_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Quando ele saiu, não podia falar com eles. Porque ele não podia falar, fez gestos com as mãos para tentar explicar a eles o que tinha acontecido. Por isso/aí perceberam que ele tinha tido uma visão de Deus/algo que Deus lhe mostrou enquanto estava no templo. ");
INSERT INTO portft_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Quando o tempo de Zacarias servir de sacerdote no templo chegou ao fim, ele saiu de Jerusalém e voltou para casa. ");
INSERT INTO portft_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Algum tempo depois, sua esposa Isabel ficou grávida. Ela não saiu de sua casa durante cinco meses, porque sabia que as pessoas iam rir-se dela durante esse tempo/depois desse tempo as pessoas já não fariam pouco dela se ela lhes dissesse que estava grávida. ");
INSERT INTO portft_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Mas ela disse para si mesma, “Deus me ajudou a ficar grávida. Agora ele tem tido pena de mim e tem feito com que eu já não esteja com vergonha porque não tenha filhos!” ");
INSERT INTO portft_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Quando já fazia quase seis meses que Isabel estava grávida, Deus de novo mandou o anjo Gabriel. ");
INSERT INTO portft_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Desta vez ele foi à cidade de Nazaré no distrito da Galileia, a uma virgem que se chamava Maria. Os pais dela tinham prometido que ela ia casar-se com um homem chamado José, que era descendente do Rei Davi. ");
INSERT INTO portft_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","O anjo disse a ela, “Saudações! O Senhor Deus está com você e já resolveu abençoar você grandemente.” ");
INSERT INTO portft_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Porém Maria estava muito confundida quando ouviu isso. Ela perguntava a si mesma o que o anjo queria dizer com estas palavras. ");
INSERT INTO portft_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aí o anjo disse a ela, “Maria, Deus está muito contente com você, então não tenha medo. ");
INSERT INTO portft_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Você vai ficar grávida e vai ter um filho, e deve dar a ele o nome de Jesus. ");
INSERT INTO portft_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ele vai se tornar muito grande. As pessoas vão dizer que ele é o Filho de Deus/o homem que também é Deus. Deus, o Senhor, vai fazer com que ele seja rei assim como foi seu antepassado o Rei Davi. ");
INSERT INTO portft_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ele vai ser o rei dos judeus, os descendentes do seu antepassado Jacó, para sempre. Ele vai reinar/governar como rei para sempre!” ");
INSERT INTO portft_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Aí Maria disse ao anjo, “Já que sou virgem, como posso ter um filho?” ");
INSERT INTO portft_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Então o Anjo disse a ela, “O Espírito Santo virá a você e o poder de Deus MTY/EUP estará sobre você para ajudá-la a ficar grávida. Por isso o filho que você terá vai ser totalmente dedicado aos propósitos de Deus, e as pessoas dirão que ele é o Filho de Deus/homem que também é Deus. ");
INSERT INTO portft_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Também preciso dizer outra coisa a você. Sua prima Isabel é muito idosa, e as pessoas diziam que ela não podia ter filhos. Mas faz quase seis meses que ela está grávida, e vai dar à luz um filho! ");
INSERT INTO portft_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mas você não deve se maravilhar disso, porque Deus pode fazer tudo!” ");
INSERT INTO portft_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aí Maria disse, “Está bem, quero servir o Senhor/Deus, então deixe acontecer o que o senhor disse.” Depois o anjo a deixou. ");
INSERT INTO portft_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Logo depois disso, Maria se preparou e foi rápido a uma cidade nos montes do distrito da Judeia. ");
INSERT INTO portft_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ela entrou na casa de Zacarias e saudou a sua esposa Isabel. ");
INSERT INTO portft_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Logo que Maria ouviu a Isabel saudá-la, o nenê pulou no ventre da Isabel. O Espírito Santo dominou a Isabel por completo. ");
INSERT INTO portft_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ela disse a Maria em voz bem alta, “Deus tem abençoado você mais do que abençoou qualquer outra mulher, e tem abençoado o filho que vai ter! ");
INSERT INTO portft_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Não sou/por que sou digno de Deus permitir que você me visite! Você vai ser mãe do meu Senhor! ");
INSERT INTO portft_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Percebi isso porque logo que ouvi você me saudar, o nenê dentro do meu ventre pulou porque estava tão contente de você ter vindo! ");
INSERT INTO portft_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Deus a abençoou porque você acreditou que o que o Senhor Deus lhe disse ia acontecer. ");
INSERT INTO portft_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Então Maria louvou a Deus dizendo/cantando, “Ó, como eu louvo o Senhor/Deus! ");
INSERT INTO portft_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Alegro-me no meu ser interior porque Deus é quem me salva. ");
INSERT INTO portft_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Eu era apenas a sua serva humilde, mas ele não se esqueceu de mim. Pois de agora em diante, as pessoas de todas as épocas/do futuro vão dizer que Deus se agradava/gostava de mim, ");
INSERT INTO portft_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","porque vão ouvir das coisas que Deus, o Altíssimo, fez para mim. Ele é maravilhoso! ");
INSERT INTO portft_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ele mostra misericórdia àqueles que o respeitam de geração a geração. ");
INSERT INTO portft_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ele mostra às pessoas que ele é poderoso. Ele faz com que aqueles que pensam de maneira orgulhosa no seu ser interior se dispersem. ");
INSERT INTO portft_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ele manda embora os reis poderosos e não deixa que continuem a governar, mas honra aqueles que são humildes/oprimidos. ");
INSERT INTO portft_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ele dá coisas boas de comer aos famintos, mas manda embora os ricos sem dar nada a eles. ");
INSERT INTO portft_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ele prometeu a Abraão e a todos os nossos outros antepasssados que descenderam dele que teria misericórdia deles. Ele tem se lembrado do que prometeu. Por isso ele me ajudou e ajudou a todos os outros do povo de Israel que o servem. ");
INSERT INTO portft_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ficou com Isabel por mais ou menos três meses. Depois ela voltou para casa. ");
INSERT INTO portft_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Quando chegou a hora de Isabel dar à luz, ela teve um filho. ");
INSERT INTO portft_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Seus vizinhos e parentes ouviram como Deus a tinha abençoado imensamente, e por isso estavam contentes assim como Isabel. ");
INSERT INTO portft_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sete dias depois eles se reuniram para a cerimônia de circuncidar o nenê para mostrar que ele pertencia a Deus. Já que o nome do pai era Zacarias, queriam dar ao filho o mesmo nome. ");
INSERT INTO portft_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mas a mãe disse, “Não, seu nome vai ser João.” ");
INSERT INTO portft_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Então eles disseram a ela, “João não é o nome de nenhum dos seus (dual) parentes, por isso você (dual) não deve dar esse nome a ele. ");
INSERT INTO portft_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Então fizeram gestos com as mãos para o pai para ele indicar qual o nome que queria dar ao seu filho. ");
INSERT INTO portft_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aí ele deu sinal para eles darem a ele uma tabuinha em que escrever. Quando deram a ele, ele escreveu no tablete ”Seu nome é João.” Todos os que estavam ali ficaram maravilhados! ");
INSERT INTO portft_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zacarias logo podia falar novamente, e louvou a Deus. ");
INSERT INTO portft_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Todos os vizinhos deles ficaram maravilhados/pasmados! Contaram aos outros que moravam em toda a região dos montes do distrito da Judeia essa coisa que tinha acontecido. ");
INSERT INTO portft_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Todos que ouviram da coisa pensavam nela. Eles diziam 'Que trabalho será que este menino fará para Deus quando ele crescer? Pensavam assim porque como resultado do que tinha acontecido eles tinham certeza de que Deus estaria ajudando-o de modo poderoso. ");
INSERT INTO portft_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Depois que o filho de Zacarias nasceu, o Espírito de Deus dirigiu Zacarias totalmente enquanto ele falou estas palavras que vinham de Deus. ");
INSERT INTO portft_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Vamos louvar o Senhor, o Deus que nós (inc) o povo de Israel adoramos,  porque ele já chegou para livrar a nós, o povo de Israel, dos nossos inimigos. ");
INSERT INTO portft_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ele está nos mandando/enviando alguém que vai nos salvar de maneira poderosa, alguém que é descendente do Rei Davi, que o serviu bem. ");
INSERT INTO portft_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Muito tempo atrás Deus fez com que seus profetas dissessem que ele faria isso. ");
INSERT INTO portft_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ele vai nos resgatar dos nossos inimigos, e ele vai nos salvar do poder daqueles que nos odeiam. ");
INSERT INTO portft_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ele vai fazer isso porque não se esqueceu do que prometeu aos nossos antepassados; ele prometeu que teria misericórdia de nós, os descendentes deles. ");
INSERT INTO portft_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Foi isso que ele prometeu firmemente ao nosso antepassado Abraão. Deus lhe disse que ele nos ia resgatar do poder dos nossos inimigos, ");
INSERT INTO portft_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","que nos ajudaria a servi-lo sem medo, ");
INSERT INTO portft_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","que faria com que nós fôssemos dedicados totalmente a ele, e nos ajudaria a viver corretamente/de maneira justa durante toda a nossa vida.” ");
INSERT INTO portft_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Então Zacarias disse isto ao seu filho pequeno: “Meu filho, as pessoas dirão que você é um profeta que Deus MTY/EUP mandou, porque você vai começar seu trabalho antes de chegar o Senhor Messias para preparar as pessoas para que estejam prontas para ele. ");
INSERT INTO portft_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Você vai dizer ao povo de Deus como é que ele vai guardá-los de serem punidos/castigados pelos seus pecados ao perdoá-los. ");
INSERT INTO portft_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nosso Deus vai fazer isso porque ele é muito bondoso para conosco. Assim como um novo dia começa quando o sol se levanta, Deus vai fazer esta coisa nova para nós quando o Messias nos vem dos céus/de Deus. ");
INSERT INTO portft_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Aqueles que não conhecem Deus são como pessoas que estão na escuridão. Têm medo de que logo vão morrer. Mas quando o Messias nos diz a mensagem de Deus, vai ser como se alguém fizesse com que essas pessoas vissem uma luz brilhante. Ele vai nos guiar para que vivamos em paz.” ");
INSERT INTO portft_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mais tarde, o filho de Zacarias cresceu e ficou forte espiritualmente. Aí ele viveu na região seca até começar a pregar ao povo de Israel. ");
INSERT INTO portft_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Por aquele tempo, o Imperador Augusto mandou que seus oficiais escrevessem os nomes de todos aqueles que vivessem em países controlados pelo governo romano para que o governo pudesse recolher impostos deles. ");
INSERT INTO portft_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Esta foi a primeira vez que escreveram os nomes daqueles que viviam na província da Síria, que incluía o distrito da Judeia. Fizeram isso enquanto Quirino era governador da província. ");
INSERT INTO portft_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Cada pessoa tinha que ir à cidade onde viviam seus antepassados, para que os oficiais pudessem escrever os seus nomes. ");
INSERT INTO portft_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Portanto, já que José era antepasssado do Rei Davi, ele subiu de Nazaré, a cidade no distrito da Galileia onde vivia, para a cidade de Belém no distrito da Judeia. Esta era a cidade onde o Rei Davi vivia antes. ");
INSERT INTO portft_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José foi com Maria, que as pessoas consideravam ser a sua esposa, que já era grávida. Foram para que pudessem colocar o nome dele e o da Maria no livro de registro. ");
INSERT INTO portft_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Quando chegaram em Belém, não tinha lugar para eles ficarem/se hospedarem na casa onde ficam/se hospedam os viajantes. Por isso eles ficaram no estábulo. Quando chegou a hora de Maria dar à luz, ela deu à luz o seu primeiro filho ali. Ela o embrulhou em faixas de pano e o deitou em uma manjedoura onde as pessoas colocavam comida para os animais. ");
INSERT INTO portft_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Aquela noite, havia uns pastores cuidando, como sempre, das suas ovelhas no campo perto de Belém. ");
INSERT INTO portft_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Um anjo que o Senhor/Deus tinha mandado apareceu a eles. Uma grande luz do céu/de Deus brilhou ao seu redor. Por isso ficaram com muito medo. ");
INSERT INTO portft_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mas o anjo disse a eles, “Não tenham medo! Cheguei para dizer a vocês boas notícias, que farão vocês muito felizes. Esta mensagem é para todos ouvirem! ");
INSERT INTO portft_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","A mensagem é que hoje nasceu um nenê em Belém, a cidade onde vivia o Rei Davi. Este nenê um dia vai salvar vocês da culpa dos seus pecados. Ele vai ser o Messias, seu Senhor. ");
INSERT INTO portft_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Vou dizer a vocês como é que vão reconhecê-lo (ou, como vão saber que o que eu digo é a verdade): Em Belém vocês vão achar um nenê cuja mãe o tem enfaixado em faixas de pano e o tem colocado no lugar onde as pessoas colocam comida para os animais.” ");
INSERT INTO portft_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","De repente um grupo grande de anjos do céu apareceu e juntou-se com o outro anjo. Todos eles louvaram a Deus, cantando: ");
INSERT INTO portft_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Que todos os anjos no céu mais alto louvem a Deus! E na terra que as pessoas a quem Deus tem mostrado seu favor conheçam paz com ele!” ");
INSERT INTO portft_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Depois que os anjos deixaram eles e voltaram para o céu, os pastores disseram uns aos outros, “Vamos a Belém para ver esta coisa maravilhosa que já aconteceu e que o Senhor/Deus já nos contou!” ");
INSERT INTO portft_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Então foram rápido. Acharam o lugar onde Maria e José estavam hospedados, e viram o nenê deitado no lugar onde põem comida para os animais. ");
INSERT INTO portft_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Aí eles contaram a Maria e José e a outros o que o anjo tinha dito a eles a respeito desta criança. ");
INSERT INTO portft_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Todos os que ouviram o que os pastores disseram a eles ficaram maravilhados. ");
INSERT INTO portft_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mas Maria não falou com outros a respeito do que o anjo disse; ela apenas continuou a pensar muito naquilo. ");
INSERT INTO portft_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Os pastores voltaram às suas ovelhas. Continuaram a louvar muito a Deus por aquilo que tinham ouvido e visto, pois tudo aconteceu exatamente como os anjos disseram a eles. ");
INSERT INTO portft_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sete dias depois, quando os sacerdotes circuncidaram o nenê, os pais dele o chamaram Jesus. Foi esse o nome que o anjo disse a eles para darem a ele antes de Maria ficar grávida. ");
INSERT INTO portft_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Moisés tinha escrito muito tempo atrás em uma lei que Deus deu a ele, que quando uma mulher deu/tinha dado à luz o seu primeiro filho, os pais tinham que levá-lo ao templo em Jerusalém para que pudessem dedicá-lo ao Senhor/Deus. Então quando chegou o tempo deles fazerem estes rituais para que Deus os considerasse puros outra vez, Maria e José levaram Jesus para lá. ");
INSERT INTO portft_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","O Senhor/Deus tinha mandado na sua lei que se a primeira criança de um casal fosse menino, os seus pais deviam oferecer em sacrifício a Deus duas pombas ou dois pardais novos. Por isso, José e Maria deram ao sacerdote dois pássaros para que ele pudesse oferecê-los. ");
INSERT INTO portft_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Naquela época havia um homem idoso em Jerusalém cujo nome era Simeão. Ele fazia o que agradava a Deus e obedecia as leis de Deus. Ele estava esperando que Deus animasse o povo de Israel mandando aquele que o salvaria/o Messias. ");
INSERT INTO portft_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","O Espírito Santo revelou para ele anteriormente que ele veria o Messias prometido de Deus antes de morrer. ");
INSERT INTO portft_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Quando José e Maria levaram seu nenê Jesus ao templo para fazer esses rituais, o Espírito dirigiu Simeão a entrar no pátio do templo e revelou a ele que Jesus era o Messias. ");
INSERT INTO portft_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Então ele tomou Jesus nos braços e louvou Deus dizendo, ");
INSERT INTO portft_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","Senhor, o Senhor me prometeu que eu veria aquele que faria com que o senhor pudesse salvar pessoas de todos os povos da culpa dos seus pecados. Ele será como uma luz que revelará a sua verdade aos não judeus, e ele vai fazer com que as pessoas pensem bem do seu povo, o povo de Israel. Já que eu tenho visto este que o senhor prometeu mandar, agora deixe-me morrer em paz.” ");
INSERT INTO portft_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Os pais dele ficaram maravilhados daquilo que Simeão disse sobre Jesus. Então Simeão os abençoou, e disse a Maria, ");
INSERT INTO portft_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Observe o que eu digo: Deus já determinou que por causa desta criança, muitos do povo de Israel vão abandonar Deus, e muitos outros vão voltar a Deus. Mesmo que ele seja como um sinal para advertir as pessoas, muitos vão ser contra ele/se opor a ele. ");
INSERT INTO portft_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Como resultado, ele vai esclarecer os maus pensamentos de muitos. Além disso, as coisas cruéis que eles farão a ele serão como uma espada que vai cortar sua alma/seu ser interior. ");
INSERT INTO portft_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Também havia na área do templo uma senhora muito idosa chamada Ana. Ela era profetisa. Seu pai Fanuel era membro da tribo de Aser. Quando fazia sete anos que ela estava casada, morreu o seu marido. ");
INSERT INTO portft_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Depois disso ela viveu até ter 84 anos, e ainda era viúva. Ela ficava na área do templo o tempo todo, dia e noite, louvando a Deus. Frequentemente ela jejuava/deixava de comer enquanto orava. ");
INSERT INTO portft_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Enquanto José e Maria e o nenê ainda estavam no templo, ela chegou a eles. Ela agradeceu a Deus pelo nenê. Então ela falou de Jesus a muitos que esperavam que Deus mandasse o Messias para livrar o povo de Jerusalém. ");
INSERT INTO portft_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Depois que José e Maria tinham completado os rituais que o Senhor/Deus requeria dos pais quando nascesse seu primeiro filho, voltaram à sua própria cidade, Nazaré, no distrito da Galileia. ");
INSERT INTO portft_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Quando o menino cresceu, ficou forte e muito sábio, e Deus se agradava dele/o abençoava. ");
INSERT INTO portft_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Todos os anos os pais de Jesus iam a Jerusalém para festejar a Páscoa. ");
INSERT INTO portft_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Então quando Jesus tinha doze anos, foram a Jerusalém como sempre. ");
INSERT INTO portft_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Quando terminou a festa da Páscoa, os pais de Jesus começaram a voltar para casa, mas Jesus ficou em Jerusalém. Os pais dele não perceberam que Jesus tinha ficado ali. ");
INSERT INTO portft_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Eles pensavam que ele estava com os outros que estavam viajando com eles. Andaram o dia todo. Então começaram a procurá-lo entre seus parentes e amigos. ");
INSERT INTO portft_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Eles não o acharam, por isso voltaram a Jerusalém para procurá-lo. ");
INSERT INTO portft_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dois dias depois, eles o acharam. Ele estava na área do templo, sentado com os professores religiosos dos judeus. Estava ouvindo o que eles diziam, e fazendo perguntas a eles. ");
INSERT INTO portft_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Todos os que ouviram o que ele disse ficaram maravilhados com o que ele entendia e com as boas respostas que ele dava às perguntas que os professores faziam. ");
INSERT INTO portft_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Quando os pais dele o viram, ficaram muito maravilhados/pasmados. A mãe dele lhe disse, “Meu filho, por que é que você fez isso conosco? Seu pai e eu temos estado muito preocupados ao procurarmos (excl) você?” ");
INSERT INTO portft_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ele disse a eles, falando do templo como a casa de Deus o pai dele, “Maravilho-me de que vocês (dual) não sabiam onde me achar. Vocês (dual) deviam saber/vocês não sabiam que era necessário que eu estivesse na casa do meu pai!” ");
INSERT INTO portft_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mas eles não entendiam o significado do que ele lhes disse. ");
INSERT INTO portft_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Então ele voltou com eles a Nazaré. Ele sempre os obedecia. Mas a mãe dele continuava a pensar em todas essas coisas. ");
INSERT INTO portft_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Com o passar dos anos, Jesus continuou a ficar mais sábio e mais alto. Deus e as pessoas continuaram a aprovar-se dele cada vez mais. ");
INSERT INTO portft_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Quando o imperador Tibério governava o império romano fazia quinze anos, e enquanto Pôncio Pilatos era governador do distrito da Judeia, e Herodes Antipas governava o distrito da Galileia, e seu irmão Filipe governava os distritos de Itureia e Traconites, e Lisânias governava O distrito de Abilene, ");
INSERT INTO portft_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","e enquanto Anás e Caifás eram os sumos sacerdotes em Jerusalém, Deus deu mensagens ao filho de Zacarias, João, enquanto ele vivia na região seca/no sertão. ");
INSERT INTO portft_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Então João andava por toda a área perto do rio Jordão. Ele sempre dizia às pessoas, “Se quiserem que Deus os perdoe por terem pecado, precisam arrepender-se dos seus pecados/deixar seu mal comportamento antes de pedirem que eu os batize!” ");
INSERT INTO portft_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Foi João que cumpriu essas palavras que o profeta Isaías tinha escrito em um livro muito tempo antes: Alguém estará gritando na região seca às pessoas que passarem, assim como as pessoas preparam o caminho para um oficial importante, preparem-se para receberem o Senhor! Assim como as pessoas arrumam os caminhos METR para um oficial importante, aprontem-se para que estejam preparados quando ele vier! ");
INSERT INTO portft_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Assim como as pessoas nivelam/aterram todos os lugares onde a terra sobe e enchem todos os vales e endireitam as partes tortas das estradas e consertam os buracos na estrada quando fazem uma boa estrada para um rei/chefe, retirem/removam todos os obstáculos que impedem que Deus os abençoe! ");
INSERT INTO portft_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Então a gente em todos os lugares vai entender como é que Deus salva as pessoas de serem castigadas pela culpa dos seus pecados. ");
INSERT INTO portft_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Embora grupos grandes de pessoas fossem a João para que ele os batizasse, já que ele sabia que muitos deles não eram sinceros, ele sempre dizia a eles, “Vocês são maus como cobras venenosas! Eu advirto/digo às pessoas que Deus um dia vai castigar todos os que pecam. Mas não pensem/será que alguém lhes disse RHQ que podem se escapar de serem castigados por ele se não abandonarem os seus pecados! ");
INSERT INTO portft_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Façam as coisas que são certas para aqueles que realmente abandonaram os seus pecados! Deus prometeu a Abraão que lhe daria tantos descendentes que as pessoas nem poderiam contá-los. Deus não precisa de vocês para poder cumprir esta promessa! Ele pode transformar estas pedras para fazê-las descendentes de Abraão. Então não digam para si mesmos, Já que nós (excl) somos descendentes de Abraão, Deus não vai nos castigar! Deus está pronto para castigar vocês! ");
INSERT INTO portft_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ele é como um homem que tem o seu machado pronto para cortar as raízes das árvores que não dão fruto. Pois ele vai cortar toda árvore que não dá bom fruto e jogá-la no fogo. ");
INSERT INTO portft_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Então vários na multidão perguntaram a ele, “O que é que nós (excl) devemos fazer para evitar que Deus nos castigue?” ");
INSERT INTO portft_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ele respondeu a eles, “Se alguém entre vocês tiver duas camisas, deve dar/dê uma delas a alguém que não tenha nenhuma camisa. Se alguém tiver bem bastante comida, deve dar um pouco para uma pessoa que não tem comida. ");
INSERT INTO portft_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Alguns homens que recolhiam impostos foram e pediram que ele os batizasse. Eles perguntaram a ele, “Professor, o que nós (excl) devemos fazer para agradar a Deus?” ");
INSERT INTO portft_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ele lhes disse, “Não tirem do povo mais dinheiro do que o governo romano diz para vocês tirarem.” ");
INSERT INTO portft_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Alguns soldados perguntaram, “E nós? O que é que nós (excl) devemos fazer para agradar a Deus? Ele lhes disse, “Não digam para ninguém, se você não me der dinheiro,vou fazer mal a você, ou vou levá-lo à justiça e dizer que fez algo errado! E estejam contentes com o seu salário.” ");
INSERT INTO portft_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","As pessoas esperavam que o Messias fosse chegar logo. Por isso muitos ponderavam sobre João. Alguns perguntaram a ele se ele era o Messias. ");
INSERT INTO portft_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Então, João respondeu a todos eles, “Não, não sou. Eu usei somente água quando batizei vocês porque vocês disseram que queriam mudar as suas vidas. Mas o Messias virá logo! Ele é muito maior/mais importante do que eu. Ele é tão importante que eu não sou digno de ser como o seu escravo e fazer coisas para ele assim como um escravo faria. Ele vai pôr o seu Espírito Santo dentro de vocês para realmente transformar as suas vidas! Mas ele vai queimar em um fogo todos aqueles que não creem nele. ");
INSERT INTO portft_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ele vai ser como um homem que quer guardar/recolher o trigo que está no chão onde eles o têm separado da palha. Esse homem usa uma pá para jogar o trigo para o ar e separá-lo da palha. De maneira semelhante, Deus vai separar as pessoas boas das pessoas más assim como um homem que guarda o trigo no depósito, e depois ele vai queimar aqueles que são como a palha com um fogo que nunca se apagará.” ");
INSERT INTO portft_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","João continuava a dizer muitas coisas a eles para estimulá-los a voltarem para Deus, enquanto dava a eles a boa mensagem de Deus. ");
INSERT INTO portft_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ele também repreendeu o chefe Herodes Antipas por casar-se com Herodias, a mulher do seu irmão, enquanto seu irmão ainda era vivo, e por fazer muitas outras coisas ruins. ");
INSERT INTO portft_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Mas Herodes mandou que seus soldados colocassem João na prisão. Essa foi outra coisa má que ele fez. ");
INSERT INTO portft_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mas antes deles colocarem João na prisão, quando ele estava batizando muitas pessoas, depois que ele batizou Jesus e Jesus estava orando, o céu se abriu. ");
INSERT INTO portft_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Aí o Espírito Santo, em forma de uma pomba, desceu sobre Jesus. Então Deus SUN/EUP falou com Jesus do céu dizendo, “Você é meu filho/aquele que eu amo. Eu tenho muito prazer em você/estou muito contente com você!” ");
INSERT INTO portft_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Quando Jesus começou o seu trabalho para Deus, tinha mais ou menos 30 anos. As pessoas pensavam que ele era filho de José. José era filho de Eli. ");
INSERT INTO portft_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli era filho de Matate. Matate era filho de Levi. Levi era filho de Melqui. Melqui era filho de Janai. Janai era filho de José. ");
INSERT INTO portft_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José era filho de Matatias. Matatias era filho de Amós. Amós era filho de Naum. Naum era filho de Esli. Esli era filho de Nagai. ");
INSERT INTO portft_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai era filho de Maate. Maate era filho de Matatias. Matatias era filho de Semei. Semei era filho de José. José era filho de Jodá. ");
INSERT INTO portft_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jodá era filho de Joanã. Joanã era filho de Resa. Resa era filho de Zorobabel. Zorobabel era filho de Salatiel. Salatiel era filho de Neri. ");
INSERT INTO portft_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri era filho de Melqui. Melqui era filho de Adi. Adi era filho de Cosã. Cosã era filho de Elmadã. Elmadã era filho de Er. ");
INSERT INTO portft_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er era filho de Josué. Josué era filho de Eliézer. Eliézer era filho de Jorim. Jorim era filho de Matate. Matate era filho de Levi. ");
INSERT INTO portft_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi era filho de Simeão. Simeão era filho de Judá. Judá era filho de José. José era filho de Jonã. Jonã era filho de Eliaquim. ");
INSERT INTO portft_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim era filho de Meleá. Meleá era filho de Mená. Mená era filho de Matatá. Matatá era filho de Natã. Natã era filho de Davi. ");
INSERT INTO portft_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davi era filho de Jessé. Jessé era filho de Obede. Obede era filho de Boaz. Boaz era filho de Salá. Salá era filho de Naassom. ");
INSERT INTO portft_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naassom era filho de Aminadabe. Aminadabe era filho de Admim. Admim era filho de Arni. Arni era filho de Esrom. Esrom era filho de Perez. Perez era filho de Judá. ");
INSERT INTO portft_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá era filho de Jacó. Jacó era filho de Isaque. Isaque era filho de Abraão. Abraão era filho de Tera. Tera era filho de Naor. ");
INSERT INTO portft_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naor era filho de Serugue. Serugue era filho de Ragaú. Ragaú era filho de Faleque. Faleque era filho de Éber. Éber era filho de Salá. ");
INSERT INTO portft_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salá era filho de Cainã. Cainã era filho de Arfaxade. Arfaxade era filho de Sem. Sem era filho de Noé. Noé era filho de Lameque. ");
INSERT INTO portft_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameque era filho de Metusalém. Metusalém era filho de Enoque. Enoque era filho de Jarede. Jarede era filho de Maalalel. Maalalel era filho de Cainã. ");
INSERT INTO portft_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainã era filho de Enos. Enos era filho de Sete. Sete era filho de Adão. Adão era o homem que Deus criou. ");
INSERT INTO portft_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Quando o Espírito Santo dominou Jesus totalmente, ele saiu do vale do Rio Jordão. ");
INSERT INTO portft_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Durante quarenta dias o Espírito o guiava pela área seca. Durante esse tempo o Diabo estava tentando-o e Jesus não comia nada. Quando esse tempo chegou ao fim, ele estava com muita fome. ");
INSERT INTO portft_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Então o Diabo disse a Jesus, “Já que você diz que é o Filho de Deus/homem que também é Deus, diga a esta pedra para se tornar pão para que você possa comê-lo!”  ");
INSERT INTO portft_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus respondeu, “Não, porque Moisés escreveu nas Escrituras que só a comida comum não é suficiente para sustentar as pessoas. Elas também precisam de comida para seus espíritos.” ");
INSERT INTO portft_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Aí o Diabo o levou para um monte alto e lhe mostrou em um instante todas as áreas no mundo onde os reis/chefes governam. ");
INSERT INTO portft_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Então ele disse a Jesus, “Eu darei a você a autoridade de governar sobre todas essas áreas e o farei famoso. Posso fazer isso porque Deus tem permitido que eu controle essas áreas, e posso deixar que governe sobre elas quem eu quiser. ");
INSERT INTO portft_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Portanto, se você me adorar, vou deixar que você governe sobre todas elas!” ");
INSERT INTO portft_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mas Jesus respondeu, “Não, eu não vou adorar você, porque o salmista escreveu nas Escrituras: Vocês devem adorar o Senhor, seu Deus. Devem servir somente a ele! ");
INSERT INTO portft_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Então o Diabo levou Jesus à cidade de Jerusalém. Ele o colocou no ponto mais alto do templo e disse a ele, “Já que você diz que é o filho de Deus/homem que também é Deus, atire-se daqui. ");
INSERT INTO portft_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Se fizer isso, não vai se machucar, porque o salmista escreveu nas escrituras, Deus vai mandar que os anjos dele protejam você. ");
INSERT INTO portft_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","E ele também escreveu, Quando você cair, eles vão segurar você nas mãos, para que uma pedra não fira/machuque o seu pé. ");
INSERT INTO portft_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mas Jesus respondeu, “Não, eu não vou fazer isso, porque Moisés escreveu nas Escrituras, Ninguém deve tentar ver se o Senhor seu Deus o resgatará depois dele fazer algo tolo/estúpido. ");
INSERT INTO portft_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Então, depois do Diabo terminar de tentá-lo de muitas maneiras, ele deixou Jesus. Ele queria procurar tentá-lo mais tarde em um momento propício. ");
INSERT INTO portft_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Enquanto o Espírito deu a ele poder, Jesus voltou ao distrito da Galileia. As pessoas por toda aquela região souberam do que ele estava fazendo. ");
INSERT INTO portft_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ele ensinava as pessoas nas sinagogas/salas de reuniões deles. Como resultado, todos o louvaram. ");
INSERT INTO portft_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Então Jesus foi a Nazaré, a cidade onde ele foi criado. No sábado ele foi à sinagoga, assim como sempre fazia. Ele levantou-se para indicar que queria ler a Escritura para eles. ");
INSERT INTO portft_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Alguém deu a ele um rolo que continha as palavras que o profeta Isaías tinha escrito. Ele abriu o papel e achou o lugar que queria ler. Ele leu estas palavras. ");
INSERT INTO portft_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","O Espírito do Senhor/Deus está sobre mim. Ele me tem escolhido para declarar as boas notícias de Deus aos pobres. Ele me tem mandado para cá para proclamar que Deus vai livrar aqueles que Satanás capturou, e ele vai me ajudar a fazer com que os cegos vejam outra vez. Ele vai me ajudar a livrar aqueles que outros têm oprimido. ");
INSERT INTO portft_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ele me mandou para declarar que agora nesta época Deus vai mostrar favor às pessoas. ");
INSERT INTO portft_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Aí ele fechou o livro e deu ao assistente/ajudante, e sentou-se para ensinar as pessoas. Todos na sinagoga estavam olhando fixamente para ele. ");
INSERT INTO portft_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ele disse para eles, “Hoje ao me ouvirem falar, estou começando a cumprir esta passagem de escritura.” ");
INSERT INTO portft_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","No início todos ali falaram bem dele, e se maravilharam das palavras bonitas/atraentes que ele falou. Mas aí alguns deles disseram, “Ele é/não é ele apenas o filho de José, portanto é inútil para nós/por que nós (excl) devíamos ouvir o que ele diz?” ");
INSERT INTO portft_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ele disse a eles, “Certamente alguns de vocês vão dizer a mim o provérbio que diz, Médico, cure-se a si mesmo. O que vocês vão querer dizer com isso é, As pessoas nos disseram que você fez milagres na cidade de Cafarnaum, mas nós (excl) não sabemos se isso é verdade. Então faça milagres também aqui na sua própria cidade natal! ");
INSERT INTO portft_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Depois ele disse, Certamente é verdade que as pessoas não aceitam a mensagem de um profeta que fala na sua cidade natal, assim como vocês não aceitam a minha mensagem agora. ");
INSERT INTO portft_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mas pensem nisso: Havia muitas viúvas em Israel na época em que vivia o profeta Elias. Naquele tempo, porque não tinha chuva durante três anos e seis meses, havia uma grande fome por todo o país. ");
INSERT INTO portft_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mas Deus não mandou Elias para ajudar nenhuma daquelas viúvas judaicas. Deus o mandou à vila de Sarepta perto da cidade de Sidom, para ajudar uma viúva não judaica. ");
INSERT INTO portft_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Também havia muitos leprosos em Israel na época quando vivia o profeta Eliseu. Mas Eliseu não curou nenhum deles. Ele só curou Naamã, um não judeu da Síria.” ");
INSERT INTO portft_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Quando todos na sinagoga ouviram isso, ficaram muito zangados, porque perceberam que ele estava sugerindo que, de maneira semelhante,ele iria ajudar os não judeus em vez dos judeus. ");
INSERT INTO portft_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aí todos eles se levantaram e o jogaram da cidade. Eles o levaram para o cúmulo do monte fora de sua cidade para jogarem ele de lá e matá-lo. ");
INSERT INTO portft_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mas ele só passou por meio do grupo e foi embora. ");
INSERT INTO portft_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Certo dia ele desceu com seus discípulos a Cafarnaum, uma cidade no distrito da Galileia. No sábado (OU, cada sábado) ele ensinou as pessoas na sinagoga. ");
INSERT INTO portft_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Eles estavam sempre maravilhados com o que ele ensinava, pois ele falava como falam as pessoas quando têm o direito de dizer aos outros o que fazerem. ");
INSERT INTO portft_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na sinagoga aquele dia/um daqueles sábados tinha um homem que era controlado por um Espírito maligno. Aquele homem gritou em voz bem alta, ");
INSERT INTO portft_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oh! Jesus, da cidade de Nazaré! Já que nós (excl) não temos nada em comum, não mexa com/por que devia mexer conosco, os maus espíritos, agora! Não nos destrua/já veio para nos destruir agora. Eu sei quem você é. Você é o santo que vem de Deus!” ");
INSERT INTO portft_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesus repreendeu o Espírito maligno, dizendo, “Fique quieto! E saia daquele homem! O demônio fez com que o homem caísse no chão no meio do povo. Mas sem fazer mal ao homem, o demônio o deixou. ");
INSERT INTO portft_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Todas as pessoas ficaram maravilhadas. Disseram uns aos outros, “Seu ensino tem grande poder/que tipo de ensino é este! Ele fala aos espíritos malignos como falam aqueles que têm o direito de dizer aos outros o que fazerem, e como resultado eles deixam as pessoas! ");
INSERT INTO portft_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Então as pessoas contaram em todas as vilas naquela região o que Jesus tinha feito. ");
INSERT INTO portft_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesus e seus discípulos saíram da sinagoga e entraram na casa de Simão. A sogra de Simão estava doente e tinha febre alta. Então outros da família de Simão/os discípulos pediram que ele a curasse. ");
INSERT INTO portft_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aí ele ajoelhou-se perto dela e repreendeu a febre. Logo ela ficou curada! Ela levantou-se e serviu comida a eles. ");
INSERT INTO portft_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Quando o sol se punha aquele dia, e a restrição/lei que diz que não se deve viajar no sábado terminou, muitos cujos amigos ou parentes estavam doentes ou que tinham várias doenças, os levaram a Jesus. Ele pôs as mãos sobre eles e curou todos eles. ");
INSERT INTO portft_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ele também estava expulsando demônios de muitas pessoas. Quando os demônios deixaram aquelas pessoas eles gritaram a Jesus, “Você é o Filho de Deus/o homem que também é Deus!” Mas ele repreendeu aqueles demônios e não deixou que eles falassem a respeito dele às pessoas, porque eles sabiam que ele era o Messias e por várias razões ele ainda não queria que todos soubessem isso. ");
INSERT INTO portft_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bem cedo na manhã seguinte, Jesus saiu daquela casa e foi a um lugar não habitado/vazio para orar. Muitas pessoas o procuraram, e quando o acharam eles lhe pediam encarecidamente que não os deixasse. ");
INSERT INTO portft_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mas ele disse a eles, “Preciso dizer também às pessoas em outras cidades a boa mensagem sobre como Deus quer governar as vidas deles, porque é isso que Deus me mandou para fazer.” ");
INSERT INTO portft_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Então ele continuou a pregar nas sinagogas em várias cidades da província da Judeia. ");
INSERT INTO portft_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Certo dia quando muitos estavam apertando-o para ouvirem a mensagem de Deus, Jesus estava em pé à beira do lago Genesaré, que também se chama o lago da Galileia. ");
INSERT INTO portft_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ele viu dois barcos de pescar à beira do lago. Os pescadores tinham saído dos barcos e estavam lavando suas redes de pescar à beira. Um dos barcos pertencia a Simão. ");
INSERT INTO portft_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesus entrou no barco e pediu para Simão afastar o barco um pouco da beira para que ele pudesse falar com a multidão mais facilmente. Jesus ficou sentado naquele barco e ensinou as pessoas que estavam perto do lago. ");
INSERT INTO portft_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Depois dele terminar de falar com eles, ele disse a Simão, “Leve o barco para onde a água é funda. Então solte suas redes na água para pegar uns peixes!” ");
INSERT INTO portft_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aí Simão respondeu, “Mestre, nós (excl) trabalhamos a noite toda mas não pegamos nenhum peixe. Mas já que o senhor me pede para fazer isso, vou baixar as redes. ");
INSERT INTO portft_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Quando Pedro e os homens com ele tinham feito isso, pegaram tantos peixes nas redes que as redes deles estavam rasgando/quebrando. ");
INSERT INTO portft_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Fizeram gestos para seus colegas no outro barco para que eles viessem ajudá-los. Aí eles vieram e encheram os dois barcos com o peixe da rede. O resultado foi que os barcos estavam tão cheios que começaram a afundar-se. ");
INSERT INTO portft_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Simão e todos os homens que estavam com ele ficaram maravilhados com o número/a quantia de peixes que tinham pegado. Tiago e João, os dois filhos de Zebedeu, que eram sócios de Simão, estavam entre aqueles que ficaram maravilhados. Quando Simão, cujo outro nome era Pedro, viu o peixe, sentindo vergonha de estar na presença de alguém que certamente tinha o poder de Deus, prostrou-se diante de Jesus e disse, “Senhor, o senhor não deve associar-se comigo porque sou homem pecador!” ");
INSERT INTO portft_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mas Jesus disse a Simão, “Não tenha medo! Antes você juntava peixe, mas de agora em diante você vai juntar pessoas para se tornarem meus discípulos.”  ");
INSERT INTO portft_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Então depois deles levarem seus barcos à beira, deixaram seu negócio nas mãos de outros, e foram com Jesus para se tornarem discípulos dele. ");
INSERT INTO portft_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Quando Jesus estava em uma das cidades do distrito da Galileia, havia ali um homem coberto de lepra. Quando ele viu Jesus, prostrou-se diante dele e, querendo que Jesus o curasse, rogou a ele, “Senhor, eu sei que o senhor pode me curar se quiser!” ");
INSERT INTO portft_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ignorando as regras religiosas que não permitem aproximar-se dos leprosos, Jesus estendeu a mão e tocou no homem. Ele disse, “Quero curar você; seja curado!” Logo o homem ficou curado. Ele já não era mais um leproso PRS! ");
INSERT INTO portft_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aí, para que o homem fizesse as coisas necessárias para os outros se associarem com ele de novo, Jesus disse a ele, “Vá a Jerusalém e mostre-se ao sacerdote para que ele possa examinar você e verificar que você está curado. Não diga isso a mais ninguém ainda! Leve para ele o que Moisés mandou que uma pessoa curada de lepra deve levar, para que ele oferece em sacrifício a Deus. Então, depois do sacerdote dizer às pessoas locais, elas vão saber que você está curado.” ");
INSERT INTO portft_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mas muitos ouviram a história do homem sobre o que Jesus tinha feito. O resultado foi que grandes multidões se reuniram onde Jesus estava para ouvir a mensagem dele e para que ele curasse as doenças delas. ");
INSERT INTO portft_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mas muitas vezes ele se afastava deles e ia aos lugares desertos para orar. ");
INSERT INTO portft_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Certo dia quando Jesus estava ensinando, havia ali alguns homens da seita dos fariseus. Alguns deles eram homens que ensinavam as leis judaicas. Tinham chegado de muitas vilas no distrito da Galileia e também de Jerusalém e de outras vilas no distrito da Judeia. Deus estava dando a Jesus o poder para curar as pessoas. ");
INSERT INTO portft_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Naquele tempo alguns homens trouxeram em uma esteira/maca um homem que era paralítico. Queriam levá-lo para dentro da casa e deitá-lo na frente de Jesus. ");
INSERT INTO portft_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mas não havia meio de fazer isso por causa da grande multidão de pessoas, e por isso esses homens subiram as escadas para o telhado. Depois de tirarem algumas das telhas eles baixaram o homem na esteira pela abertura para o meio da multidão na frente de Jesus. ");
INSERT INTO portft_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Quando Jesus percebeu que eles creram que ele poderia curar o homem, ele disse a ele, “Meu amigo, eu perdoo você pelas coisas más que tem feito!” ");
INSERT INTO portft_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Os homens que ensinavam as leis judaicas e os outros fariseus começaram a perguntar dentro de si mesmos, “Quem é que este homem pensa que é, dizendo isso? Ele está insultando Deus! Nenhuma/Que pessoa pode perdoar pecados! Somente Deus pode fazer isso!” ");
INSERT INTO portft_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Quando Jesus percebeu o que eles estavam pensando, ele disse a eles, “Vocês perguntam erradamente/Por que é que perguntam dentro de si mesmos sobre o que eu disse. Mas considerem isto: ");
INSERT INTO portft_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Qualquer um pode dizer, Perdoo você pelas coisas más que tem feito, porque ninguém pode provar que tem acontecido. Mas ninguém vai/será que alguém vai dizer a um paralítico, Levante-se e ande! A não ser que ele tenha o poder de curar, porque as pessoas podem ver facilmente se acontece ou não. ");
INSERT INTO portft_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Então eu vou fazer algo para que vocês saibam Que Deus tem autorizado a mim, aquele que veio do céu para a terra, tanto para perdoar pecados como para curar as pessoas.” Então ele disse ao homem que era paralítico, “Levante-se, pegue sua esteira, e vá para casa!” ");
INSERT INTO portft_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","O homem logo foi curado! Ele levantou-se na frente deles. Pegou a esteira em que estava deitado e foi para casa, louvando a Deus. ");
INSERT INTO portft_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Todas as pessoas ali ficaram maravilhadas! Louvaram a Deus e ficaram totalmente admiradas. Diziam continuamente, “Nós (inc) temos visto coisas maravilhosas hoje! ");
INSERT INTO portft_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Aí Jesus saiu da cidade e viu um homem que recolhia impostos para o governo romano. Seu nome era Levi. Ele estava sentado na barraca onde recolhia os impostos. Jesus disse a ele, “Venha comigo e seja meu discípulo!” ");
INSERT INTO portft_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aí Levi deixou o seu trabalho e foi com Jesus. ");
INSERT INTO portft_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Depois Levi preparou em sua própria casa um grande banquete para Jesus e seus discípulos. Tinha um grupo grande de homens que recolhiam impostos e (também) outros que comiam junto com eles. ");
INSERT INTO portft_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Os homens que estavam ali e que ensinavam as leis judaicas, aqueles que pertenciam à seita dos fariseus, queixavam-se para os discípulos de Jesus dizendo, “É horrendo que vocês estão/Se vocês são pessoas boas, por que é que estão comendo com pessoas que recolhem impostos e com outros que nós (excl) consideramos pecadores? ");
INSERT INTO portft_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Então, para indicar que iam a ele para ajuda aqueles que sabiam que tinham pecado, Jesus disse a eles, “Os que estão bem não precisam de médico. Pelo contrário, são os doentes que precisam de médico! ");
INSERT INTO portft_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","De modo semelhante, eu não vim para convidar para vir a mim aqueles que pensam que são justos. Pelo contrário, vim convidar aqueles que sabem que são pecadores para virem a mim e deixarem de suas vidas de pecado. ");
INSERT INTO portft_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Esses líderes judaicos disseram a Jesus, “Os discípulos de João o batizador frequentemente não comem/jejuam para mostrar que se arrependem dos seus pecados, e oram durante esse tempo, e os discípulos dos fariseus também fazem isso. Mas os discípulos do senhor sempre comem e bebem. O que é que o senhor diz a respeito disso?” ");
INSERT INTO portft_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Para mostrar a eles que não era apropriado os discípulos dele estarem tristes e deixar de comer/jejuar enquanto ele ainda estivesse com eles, Jesus disse a eles: “Quando um homem se casa, vocês não devem/será que devem fazer os amigos dele jejuarem enquanto ele ainda estiver com eles. ");
INSERT INTO portft_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Não, porém um dia os inimigos dele vão tirá-lo deles. Aí, naquela época, os amigos dele vão jejuar, porque vão estar tristes. ");
INSERT INTO portft_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Então Jesus contou a eles duas parábolas para mostrar-lhes que se alguém quisesse viver segundo a nova mensagem de Deus, os outros não deviam forçá-los a obedecerem as velhas tradições tais como o jejum, e que aqueles que entendem somente as velhas tradições religiosas não têm grande desejo de aceitar as novas. Ele disse, “Ninguém tira um pedaço de uma roupa nova e usa para consertar uma roupa velha. Pois se fizer isso, ele não está somente estragando a roupa nova ao rasgá-la, mas o novo pedaço de material não vai acompanhar bem a roupa velha. ");
INSERT INTO portft_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","De modo semelhante, ninguém coloca vinho novo em odres/vasilhas velhas. Se fizer isso, o vinho novo vai crescer ao fermentar. Aí ele vai quebrar as vasilhas e estragá-las, e o vinho também será derramado. ");
INSERT INTO portft_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pelo contrário, as pessoas devem colocar o vinho novo em vasilhas novas. ");
INSERT INTO portft_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Além disso, se a pessoa tem bebido só vinho velho, ela está contente com isso. Ela não quer beber vinho novo porque diz, O vinho velho é bom. ");
INSERT INTO portft_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Certo dia de sábado, quando Jesus estava andando por uma plantação de trigo com seus discípulos, eles pegaram algumas espigas de trigo. Esfregaram nas mãos para separar os grãos da casca, e comeram o trigo. ");
INSERT INTO portft_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Alguns fariseus que estavam observando disseram, “Nossa lei não permite que se trabalhe no sábado, então os discípulos do senhor não devem estar fazendo/por que é que estão fazendo trabalho ao separar o trigo?” ");
INSERT INTO portft_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Então para mostrar a eles como o sumo sacerdote permitiu que o Rei Davi ignorasse a lei de Moisés, e por isso ele tinha o direito de ignorar as tradições deles quando havia necessidade, ele respondeu, “Escreveram nas Escrituras o que o Rei Davi fez quando ele e os homens que estavam com ele estavam com fome. Vocês já leram sobre isso, mas não pensam/por que é que não pensam sobre as implicações disso. ");
INSERT INTO portft_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Depois de Davi entrar no tabernáculo de Deus, o sumo sacerdote deu a ele o pão que ele tinha apresentado a Deus. Permitia-se na lei de Moisés que somente os sacerdotes pudessem comer aquele pão. Mas Davi comeu um pouco, e deu aos homens que estavam com ele. Deus não considerou que isso fosse errado! ");
INSERT INTO portft_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesus também disse a eles, “Já que eu sou aquele que veio do céu, tenho o direito de determinar o que os meus discípulos fazem no dia do sábado!” ");
INSERT INTO portft_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Outro dia de sábado, Jesus entrou em uma sinagoga e ensinou as pessoas. Havia ali um homem cuja mão direita estava aleijada. ");
INSERT INTO portft_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Os homens que ensinavam as leis judaicas e os fariseus que estavam ali observaram Jesus, para ver se ele ia curar o homem no sábado. Se ele curasse o homem, eles iam acusá-lo de desobedecer as leis porque tinha trabalhado no sábado. ");
INSERT INTO portft_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mas Jesus sabia o que eles estavam pensando. Então ele disse ao homem que tinha a mão paralizada, “Venha e fique aqui na frente de todos.”Aí o homem fez isso. ");
INSERT INTO portft_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Então Jesus disse a eles, “Pergunto a vocês: as nossas leis judaicas permitem que nós façamos o que é bom no sábado ou que façamos mal às pessoas. Elas nos permitem salvar a vida de uma pessoa ou deixar que ela morra ao recusarmos ajudá-la? ");
INSERT INTO portft_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Eles recusaram responder a ele. Então depois de olhar para todos, ele disse ao homem, “Estenda a mão!” O homem fez assim e sua mão ficou boa outra vez. ");
INSERT INTO portft_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mas eles estavam muito zangados, e discutiram entre si o que podiam fazer para acabar com Jesus. ");
INSERT INTO portft_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Por aquela época Jesus subiu aos montes para orar. Ele orou a Deus a noite toda. ");
INSERT INTO portft_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","No dia seguinte ele chamou todos os seus discípulos para virem a ele. Deles ele escolheu doze homens, que ele chamou de apóstolos. ");
INSERT INTO portft_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Eram Simão, a quem ele deu um novo nome de Pedro, seu irmão mais novo André, Tiago e seu irmão mais novo, João, Filipe, Bartolomeu, ");
INSERT INTO portft_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateus, Tomé, um outro Tiago, filho de Alfeu, Simão que pertencia ao partido que estimulava as pessoas a se rebelarem contra o governo romano; ");
INSERT INTO portft_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, o filho de outro Tiago, e outro Judas, que era da cidade de * Cariote. Foi ele que mais tarde traiu/ajudou os inimigos de Jesus a prendê-lo. ");
INSERT INTO portft_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesus desceu do monte com seus discípulos e ficou em uma área plana. Havia ali uma grande multidão dos discípulos dele. Também havia um grupo grande de pessoas que tinham chegado de Jerusalém e de muitos outros lugares no distrito da Judeia, e da área do litoral perto das cidades de Sidom e Tiro. Chegaram para ouvir Jesus falar com eles e para ele curá-los das doenças deles. ");
INSERT INTO portft_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ele também curou aqueles que eram perturbados com espíritos maus. ");
INSERT INTO portft_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Todos na multidão tentaram tocar nele, porque ele estava curando todos por meio do poder do Deus dele. ");
INSERT INTO portft_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ele olhou para seus discípulos e disse, Deus se agrada de vocês que sabem que faltam o que Deus quer que tenham; Deus vai abençoar vocês ao governar sobre suas vidas. ");
INSERT INTO portft_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Deus se agrada de vocês que desejam receber o que ele quer que tenham; ele vai dar a vocês o que precisam, até que estejam satisfeitos. Deus se agrada de vocês que estão tristes agora por causa de pecado; mais tarde vão estar alegres. ");
INSERT INTO portft_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Deus se agrada de vocês quando as pessoas os odeiam, quando eles não permitem que vocês se juntem a elas, quando elas os insultam, quando dizem que vocês MTY são maus porque creem em mim, aquele que veio do céu. ");
INSERT INTO portft_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Quando isto acontecer, alegrem-se! Pulem de alegria! Deus vai dar a vocês um grande galardão/prêmio no céu! Quando fizerem essas coisas a vocês, isso vai provar que vocês são os servos de Deus. (OU, As pessoas sempre têm tratado os servos de Deus assim.) Não se esqueçam de que os antepassados deles fizeram as mesmas coisas aos profetas que serviram a Deus fielmente! ");
INSERT INTO portft_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mas ai das coisas terríveis que vão acontecer a vocês que são ricos! A alegria que têm recebido de suas riquezas é a única que vão receber. ");
INSERT INTO portft_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ai de vocês que pensam que têm tudo quanto precisam de Deus agora: Vocês vão descobrir que faltam muito do que Deus quer. Ai de vocês que estão alegres agora: Mais tarde vocês estarão muito tristes. ");
INSERT INTO portft_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Quando a maioria fala bem de vocês, ai de vocês: Isso vai provar que vocês não são servos de Deus, porque os antepassados deles antes falavam bem daqueles que diziam erradamente que eram profetas. ");
INSERT INTO portft_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mas digo isto a vocês que estão ouvindo o que digo: amem seus inimigos! Façam coisas boas àqueles que odeiam vocês! ");
INSERT INTO portft_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Peçam que Deus abençoe aqueles que amaldiçoam vocês. Orem por aqueles que maltratam vocês! ");
INSERT INTO portft_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Se alguém insultar um de vocês batendo em uma face, vire o rosto para que ele possa bater no outro lado também. Se um bandido quiser tirar seu casaco, deixe-o levar a sua camisa também. ");
INSERT INTO portft_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dê algo a todos os que pedem algo de você. Se alguém tirar coisas que pertencem a você, não peça para ele devolver. ");
INSERT INTO portft_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","As coisas que vocês querem que os outros façam para vocês, são essas as coisas que devem fazer para eles. ");
INSERT INTO portft_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Se vocês só amarem aqueles que amam vocês, não esperem que Deus lhes dê um galardão/será que Deus lhes dará um prêmio por fazer isso, pois até os pecadores amam aqueles que amam a eles. ");
INSERT INTO portft_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Se fizerem coisas boas somente para aqueles que fazem coisas boas para vocês, não esperem que Deus lhes dê um galardão por fazerem isso, pois até mesmo os pecadores agem assim. ");
INSERT INTO portft_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Se vocês emprestarem coisas ou dinheiro somente para aqueles de quem vocês acham que vão receber algo de volta, não esperem que Deus lhes dê um prêmio/será que Deus vai lhes dar um prêmio por fazerem isso! Até mesmo os pecadores emprestam para outros pecadores, porque esperam que eles vão devolver tudo. ");
INSERT INTO portft_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pelo contrário, amem os seus inimigos! Façam coisas boas para eles. Emprestem para eles, e não esperem que eles paguem nada de volta! Se fizerem assim, Deus vai dar a vocês um grande prêmio. E vão estar agindo assim como devem agir os filhos dele. Lembrem-se de que Deus mostra bondade também àqueles que são ingratos e àqueles que são maus, e ele espera que vocês sejam assim também. ");
INSERT INTO portft_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mostrem misericórdia aos outros, assim como seu pai no céu mostra misericórdia. ");
INSERT INTO portft_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Não digam como os outros têm agido em pecado, e então Deus não vai dizer como vocês têm agido em pecado. Não digam que Deus deve castigar os outros, e então Ele não vai dizer que deve castigar vocês. Perdoem os outros pelas coisas más que têm feito a vocês, e então Deus vai perdoar vocês. ");
INSERT INTO portft_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Deem coisas aos outros, e então Deus dará coisas a vocês. Vai ser como se ele estivesse colocando coisas em um cesto para vocês: ele vai dar a vocês uma quantia grande, que enche bem o cesto, que ele vai sacudir para que possa colocar ainda mais, e vai transbordar pelos lados! Lembrem-se de que a maneira em que vocês agem com os outros vai ser a maneira em que Deus age com vocês!” ");
INSERT INTO portft_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ele também contou aos seus discípulos esta parábola, para mostrar a eles que deviam ser como ele, e não como os líderes religiosos dos judeus: “Certamente vocês não/será que vocês iam esperar que um homem cego guiasse outro cego./? Pois se ele tentasse fazer isso, os dois/não é que os dois provavelmente cairiam em um buraco. Eu sou seu professor, e vocês discípulos devem ser como eu. ");
INSERT INTO portft_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Um discípulo não deve esperar ser maior do que seu professor. Mas se alguém treina bem um aluno, o aluno pode se tornar como seu professor. Portanto vocês devem estar contentes de serem como eu. ");
INSERT INTO portft_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Você não deve/por que é que você observa as pequenas falhas de outro, que são como pequenas manchas no olho dele, sem observar suas próprias falhas grandes, que são que nem pedaços grandes de madeira aos seus próprios olhos. ");
INSERT INTO portft_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Você não deve dizer/por que é que você diz, Amigo, deixe-me tirar aquela manchinha do seu olho, quando você nem observa o pedação de madeira no seu próprio olho! Se você fizer assim, você é hipócrita! Você primeiro deve se livrar de suas próprias falhas, que são como pedações de madeira no seu próprio olho, e então você vai poder entender bem as coisas espiritualmente para que possa ajudar outro a se livrar das falhas que são como manchinhas no olho dele. ");
INSERT INTO portft_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","As pessoas são como árvores. As árvores sadias não dão mau fruto (OU, dão somente bom fruto), e as árvores não sadias não dão bom fruto. ");
INSERT INTO portft_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Assim como você pode saber se uma árvore é boa ou má ao olhar o seu fruto, você pode saber se uma pessoa é boa ou má ao olhar como é que vive. As pessoas não tiram figos de espinheiros, e não tiram uvas dos abrolhos. ");
INSERT INTO portft_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Da mesma maneira, as boas pessoas vão viver de maneira boa porque têm muitos bons pensamentos dentro de si mesmos, e as pessoas ruins vão viver de maneira ruim porque têm dentro de si muitos maus pensamentos. As pessoas falam e agem conforme todos os pensamentos nas suas mentes. ");
INSERT INTO portft_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Já que as pessoas devem obedecer ao que lhes dizem seus chefes, é vergonhoso que/por que é que vocês dizem que eu sou seu chefe mas não fazem o que eu digo a vocês. ");
INSERT INTO portft_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Vou lhes dizer como são todos os que vêm a mim e ouvem as minhas mensagens e as obedecem. ");
INSERT INTO portft_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","São como um homem que cavou bem fundo na terra para preparar para construir a sua casa. Ele cuidou de pôr os alicerces na rocha/terra firme. Aí quando houve um enchente, a água tentou acabar com os alicerces. Mas o rio não pôde sacudir a casa, porque foi construída sobre alicerces firmes. ");
INSERT INTO portft_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Porém qualquer um que ouve as minhas mensagens mas não as obedece, é como um homem que construiu a sua casa em cima da terra sem cavar para pôr os alicerces. Quando o rio transbordou, a casa logo desabou e estava totalmente estragada. ");
INSERT INTO portft_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Depois de Jesus terminar de dizer essas coisas ao povo, ele foi com seus discípulos à cidade de Cafarnaum. ");
INSERT INTO portft_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Havia ali um oficial do exército romano que tinha um escravo de quem gostava muito. Este escravo estava tão doente que estava para morrer. ");
INSERT INTO portft_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Quando o oficial ouviu de Jesus, ele chamou alguns anciãos dos judeus. Ele pediu que eles fossem a Jesus e pedissem para ele vir curar o escravo dele. ");
INSERT INTO portft_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","quando chegaram aonde Jesus estava, pediram honestamente que Jesus voltasse com eles. Eles disseram, “Este oficial merece que você faça isso para ele, ");
INSERT INTO portft_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","porque ele ama nosso povo judaico e pagou o dinheiro para construir uma sinagoga para nós. ");
INSERT INTO portft_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aí Jesus foi com eles. Quando eles estavam perto da casa do oficial, o oficial decidiu que Jesus não precisava ir à casa dele. Então ele chamou alguns amigos. Ele disse para eles irem a Jesus e dizerem o seguinte a ele: “Senhor, não venha. Desde que eu sou um não judeu, não sou digno de você entrar em minha casa. ");
INSERT INTO portft_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Por isso eu também não me senti digno de vir a você. Porém, mande que meu servo seja curado, e ele vai ser curado! ");
INSERT INTO portft_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Eu creio que isso vai acontecer, porque há pessoas que têm autoridade sobre mim e obedeço a elas. Também tenho soldados debaixo da minha autoridade. Quando digo a um deles, Vá! Ele vai. Quando digo a outro, Venha, ele vem. Quando digo a meu escravo, Faça isso! ele o faz. E creio que o senhor fala com uma autoridade semelhante.” ");
INSERT INTO portft_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Quando eles chegaram e disseram isso a Jesus, ele admirou-se do que o oficial tinha dito. Então ele virou-se e disse à multidão que estava andando com ele, “Digo a vocês, nunca vi ninguém que confie em mim assim como este homem confia. Ninguém em Israel, onde eu ia esperar que as pessoas confiassem em mim, tem confiado em mim assim como ele!” ");
INSERT INTO portft_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Quando aqueles homens voltaram à casa do oficial, souberam que o escravo estava bem. ");
INSERT INTO portft_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pouco depois disso Jesus foi a uma cidade chamada Naim. Seus discípulos e um grupo grande de outras pessoas foram com ele. ");
INSERT INTO portft_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Quando eles se aproximaram do portão da cidade, algumas pessoas estavam saindo com o corpo de um jovem em uma esteira que acabara de morrer. A mãe dele era viúva, e este era seu único filho. Muitas pessoas da cidade estavam acompanhando-os. ");
INSERT INTO portft_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Quando o Senhor a viu, tinha pena dela. Ele disse a ela, “Não chore!” ");
INSERT INTO portft_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aí, ignorando as regras judaicas que proibem que se aproxime de um morto, ele chegou perto e tocou na esteira em que o homem estava deitado. Os homens que a carregavam pararam. Ele disse, “Jovem, digo a você, levante-se!” ");
INSERT INTO portft_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","O jovem sentou-se e começou a falar. Jesus o devolveu à sua mãe para ele cuidar dela.  ");
INSERT INTO portft_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Então todos ali ficaram com muito temor. Louvaram a Deus, dizendo, “Um grande profeta tem chegado entre nós!” Eles também disseram, “Deus já veio para ajudar o seu povo!” ");
INSERT INTO portft_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","As pessoas falaram do que Jesus tinha feito por todo o distrito da Judeia e em outras áreas vizinhas. ");
INSERT INTO portft_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Os discípulos de João o batizador foram à prisão onde João estava e contou essas coisas a ele. ");
INSERT INTO portft_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Então certo dia João chamou dois dos seus discípulos e lhes disse para ir ao Senhor e perguntar a ele se ele era o Messias que Deus prometeu mandar, ou se deviam procurar outro. ");
INSERT INTO portft_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Quando esses dois homens chegaram a Jesus eles disseram, “João o batizador nos mandou para perguntar isto ao Senhor: O senhor é o Messias que Deus prometeu mandar, ou nós (excl) devemos procurar outro? ");
INSERT INTO portft_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Naquele mesmo tempo Jesus estava curando muitas pessoas de suas doenças e de outros problemas, estava expulsando muitos espíritos maus, e estava fazendo com que muitos cegos pudessem enxergar de novo. ");
INSERT INTO portft_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Então ele respondeu a esses dois homens, “Voltem a João e digam-lhe o que vocês me têm visto fazer e o que me têm ouvido falar às pessoas. Estou fazendo com que os cegos veem. Estou fazendo com que os coxos andem. Estou curando leprosos. Estou fazendo com que os surdos ouçam. Estou fazendo com que os mortos vivam de novo, e estou falando a boa mensagem de Deus aos pobres. ");
INSERT INTO portft_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Então Deus se agrada de qualquer um que não deixe de crer em mim porque faço as coisas de modo diferente do que ele pensava que o Messias fizesse. ");
INSERT INTO portft_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Quando os homens que João tinha mandado saíram, Jesus disse à multidão a respeito de João, “Quando vocês saíram para o deserto/sertão para ver João, que fez com que vocês quisessem escutar a mensagem dele? Ele deixava que outros o influenciassem para que ele sempre mudasse a natureza de sua mensagem, assim como o vento faz um caniço mexer-se para cá e para lá? Não, ele não era assim. ");
INSERT INTO portft_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pois que tipo de homem vocês foram ver? Ele era um homem que usava roupas caras? Não, não era! Os que usam roupas bonitas e vivem em luxo/elegância estão nos palácios dos reis, não no deserto/sertão. ");
INSERT INTO portft_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pois que tipo de pessoa vocês foram ver? Vocês foram ver João porque ele era profeta? Sim, mas vou dizer-lhes que João era mais importante do que um profeta comum. ");
INSERT INTO portft_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","João foi aquele de quem um profeta escreveu estas palavras na escritura que Deus disse ao Messias: Escutem! Vou mandar o meu mensageiro diante de você. Ele vai preparar as pessoas para a vinda/chegada de você. ");
INSERT INTO portft_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Digo a vocês que de todos aqueles que já nasceram, ninguém é maior à vista de Deus do que João. Mas cada um que se junta àqueles que receberam Deus como o chefe de sua vida, mesmo que seja uma pessoa insignificante, é maior do que João. ");
INSERT INTO portft_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Quando ouviram o que Jesus disse, (ou, o que João pregou), todas as pessoas, inclusive os que recolhiam impostos, que todos desprezavam/odiavam, concordaram que o caminho de Deus era certo. Ao deixar que João os batizasse, concordaram/aceitaram que o que Deus requeria que as pessoas fizessem para ele salvá-las era certo. ");
INSERT INTO portft_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mas os fariseus e os homens que ensinavam as leis judaicas não deixaram que João os batizasse porque rejeitaram o que Deus queria que eles fizessem. ");
INSERT INTO portft_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Então Jesus disse, “Deixe-me ilustrar/será que vocês sabem como são muitos de vocês que têm ouvido o que João e eu temos ensinado. Deixe-me dizer a vocês como vocês são. ");
INSERT INTO portft_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Vocês são como crianças jogando em uma área aberta. Algumas delas estão chamando para as outras, dizendo, Nós (excl) tocamos melodias alegres para vocês, mas vocês não dançaram. Então cantamos canções tristes de enterro para vocês, mas vocês não choraram!” ");
INSERT INTO portft_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","O que quero dizer é isto: Ninguém que vem com uma mensagem de Deus pode agradar vocês. Quando João o batizador pregou para vocês, ele não comeu a comida comum nem bebeu vinho, assim como faz a maioria das pessoas. Mas vocês o rejeitaram dizendo, Um demônio está controlando-o! ");
INSERT INTO portft_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Então em contraste com isso, eu, que vim do céu, como a mesma comida e bebo vinho assim como fazem os outros. Mas vocês me rejeitam dizendo, Olhem! Ele come demais e bebe vinho demais, e é amigo daqueles que recolhem impostos e de outros pecadores! ");
INSERT INTO portft_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mas aqueles que verdadeiramente são filhos de Deus aceitam que o que Deus faz é realmente sábio. ");
INSERT INTO portft_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Certo dia um dos fariseus chamado Simão convidou Jesus para comer com ele. Então Jesus foi à casa do homem e sentou-se para comer a comida. ");
INSERT INTO portft_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tinha uma mulher naquela cidade que muitos sabiam ter sido prostituta. Ela ouviu dizer que Jesus estava comendo na casa do fariseu. Aí ela levou para lá uma vasilha/jarra de pedra que continha óleo bem cheiroso. ");
INSERT INTO portft_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ela ficou em pé atrás dos pés de Jesus. Enquanto chorava porque estava triste por seus pecados, suas lágrimas caíram nos pés de Jesus. Então ela enxugou os pés dele com o seu cabelo, e beijou os pés dele, e ungiu-os com o óleo perfumado. ");
INSERT INTO portft_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Quando o fariseu que tinha convidado Jesus viu isso, ele pensou dentro de si, “Já que os profetas sabem das vidas dos outros, se Jesus fosse profeta, ele teria sabido quem é esta mulher que está tocando nele e que tipo de pessoa ela é. Ele teria sabido que ela é prostituta. ");
INSERT INTO portft_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus disse a ele, “Simão, tem algo que quero dizer a você. Simão respondeu, “Mestre, o que é?” ");
INSERT INTO portft_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesus respondeu, “Dois homens deviam dinheiro a um homem que ganhava seu dinheiro emprestando-o a outros. Um deles devia a ele quinhentos moedas de prata, e ou outro lhe devia cinquenta moedas de prata. ");
INSERT INTO portft_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Eles não podiam devolver o que deviam, e por isso o homem disse que eles não tinham que devolver nada. Portanto, qual destes dois homens vai amar mais a esse homem?” ");
INSERT INTO portft_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simão respondeu, “Suponho que o homem que devia mais dinheiro a ele vai amá-lo mais.” Jesus lhe disse, “Está certo.” ");
INSERT INTO portft_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Então ele voltou-se para a mulher e disse a Simão, “Pense em que/você vê o que tem feito esta mulher! Quando entrei em sua casa, você não seguiu o nosso costume de dar as boas vindas aos seus hóspedes ao dar-me água para lavar os meus pés, mas esta mulher tem molhado meus pés com suas lágrimas e depois os tem enxugado com seu cabelo. ");
INSERT INTO portft_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Você não seguiu o nosso costume de saudar beijando-me, mas desde que entrei ela não tem deixado de beijar os meus pés! ");
INSERT INTO portft_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Você não seguiu o nosso costume de dar as boas vindas aos seus hóspedes ungindo a minha cabeça com azeite, mas ela ungiu os meus pés com óleo perfumado. ");
INSERT INTO portft_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Por isso vou dizer a você que mesmo que ela tenha pecado muito, eu já a perdoei. Pelo que tem feito ela mostra que me ama muito. Mas uma pessoa que eu já perdoei que pecou só um pouco vai me amar só um pouco.” ");
INSERT INTO portft_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aí ele disse à mulher, “Já perdoei você pelas coisas más que tem feito.” ");
INSERT INTO portft_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Então aqueles que estavam comendo com ele disseram entre si, Este homem deve pensar que é Deus/Quem este homem pensa que é?, dizendo que pode perdoar as pessoas pelos seus pecados! ");
INSERT INTO portft_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mas Jesus disse à mulher, “Porque você confiou em mim, Deus salvou você da culpa dos seus pecados. Que Deus dê a você paz interior enquanto você andar!” ");
INSERT INTO portft_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pouco depois disso, Jesus passou com seus doze discípulos por várias cidades e aldeias. Enquanto andaram, ele estava dizendo às pessoas a boa mensagem sobre como Deus quer controlar/governar totalmente as vidas delas. ");
INSERT INTO portft_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Algumas mulheres de quem ele tinha expulsado espíritos maus e quem ele tinha curado de doenças também foram com ele. Entre elas eram Maria, da aldeia de Magdala, de quem ele tinha expulsado sete demônios, ");
INSERT INTO portft_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, a mulher de Cuza, que era um dos oficiais do Rei Herodes Antipas, Susana e muitas outras. Elas estavam providenciando alguns dos seus próprios fundos para ajudar Jesus e seus discípulos. ");
INSERT INTO portft_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Uma grande multidão de pessoas chegaram a Jesus de muitas cidades. Então ele contou a eles esta parábola: ");
INSERT INTO portft_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Um homem saíu para semear/plantar semente. Enquanto ele fez isso, uma parte da semente caiu no caminho. Aí as pessoas andavam nela e os pássaros a comeram. ");
INSERT INTO portft_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Outra parte da semente caiu em pedra sobre a qual havia uma camada fina de solo. Logo quando a semente cresceu, as plantas secaram porque não tinham água. ");
INSERT INTO portft_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Uma parte da semente caiu em terra onde havia raízes de espinheiros enterradas na terra. A semente cresceu, mas os espinhos também cresceram e sufocaram/abafaram as plantas. ");
INSERT INTO portft_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mas parte da semente caiu em solo bom e cresceu bem. Mais tarde cada semente produziu sem sementes/grãos. Então Jesus gritou para eles, Se quiserem entender, pensem com cuidado em minhas palavras! ");
INSERT INTO portft_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mais tarde os discípulos de Jesus perguntaram a ele o significado da parábola que ele acabara de contar. ");
INSERT INTO portft_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ele disse, “Deus está permitindo que vocês saibam a verdade de como ele quer governar sobre as vidas das pessoas. Essas são coisas que ele não revelou antes. Mas estou dizendo essas coisas aos outros somente por meio de parábolas. O resultado vai ser assim como um profeta predisse muito tempo atrás: Eles verão o que estou fazendo, mas não vão realmente entender o que significa. Eles ouvirão o que digo, mas não vão entender. ");
INSERT INTO portft_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Então é este o significado da parábola: a semente representa a mensagem de Deus. ");
INSERT INTO portft_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Algumas pessoas são como o caminho em que essa semente caiu. Elas têm ouvido a mensagem de Deus, mas aí vem o diabo e faz com que deixem de pensar nela. Como resultado elas não creem na mensagem e Deus não vai salvá-las. ");
INSERT INTO portft_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Certas pessoas são como o solo que tem pedra embaixo. Essas são pessoas que recebem a mensagem de Deus com alegria quando a ouvem. Mas a mensagem não penetra/entra bem nas mentes delas. Então creem nela por pouco tempo, mas quando coisas difíceis acontecem a elas, não creem mais. ");
INSERT INTO portft_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Algumas pessoas são como o solo que tem raízes de espinheiros lá dentro. São pessoas que aceitam a mensagem de Deus, mas mais tarde elas se preocupam com várias coisas e procuram ficar ricos e gostam das coisas que lhes dão muito prazer. Por isso nunca se tornam pessoas espiritualmente maduras. ");
INSERT INTO portft_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mas algumas pessoas são como o solo bom. Ouvem a mensagem de Deus e a guardam. Tornam-se pessoas boas e honestas, e persistem em fazer as coisas que agradam a Deus. ");
INSERT INTO portft_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Depois de alguém acender uma lâmpada, ele não a cobre com um cesto nem a coloca debaixo da cama. Pelo contrário, ele a coloca em um lugar alto, para que os que entram na casa possam ver as coisas na sua luz. De modo semelhante, vocês devem dizer a verdade de Deus aos outros para que eles saibam o que posso fazer para eles. ");
INSERT INTO portft_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Deus quer esclarecer toda a verdade dele que antes não ficou clara. Ele quer que o povo dele diga aos outros abertamente toda a verdade dele que ele não tinha revelado antes. ");
INSERT INTO portft_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Então ouçam com cuidado o que eu digo a vocês, porque Deus vai ajudar aqueles que aceitam a minha verdade a entenderem ainda mais. Mas Deus vai fazer com que os que não aceitam a minha verdade não entendam até mesmo o pouco que pensam ter entendido. ");
INSERT INTO portft_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Certo dia a mãe e os irmãos mais novos de Jesus foram vê-lo, mas não podiam chegar perto dele porque tinha um grupo bem grande de pessoas ao redor dele naquela casa. ");
INSERT INTO portft_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Alguém disse a ele, “Sua mãe e seus irmãos mais novos estão em pé lá fora, querendo ver o senhor.” ");
INSERT INTO portft_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ele disse, “Aqueles que ouvem a mensagem de Deus e a obedecem são tão caros/preciosos para mim quanto minha mãe e meus irmãos mais novos.” ");
INSERT INTO portft_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Certo dia Jesus entrou num barco com seus discípulos. Ele disse a eles, “Vamos passar para o outro lado do lago. Então eles começaram a ir. ");
INSERT INTO portft_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Enquanto iam, ele adormeceu. Uma tempestade com muito vento desceu sobre o lago. Logo o barco estava se enchendo de água e eles estavam em perigo. ");
INSERT INTO portft_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eles o acordaram e disseram, “Mestre! Mestre! Nós (inc) vamos nos afogar!” Ele se levantou e mandou que o vento e as ondas se acalmassem. O vento parou e as ondas acabaram, e a água ficou calma. ");
INSERT INTO portft_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ele disse a eles, “Estou triste que/por que é que vocês não confiaram que eu fosse ajudá-los.” Eles estavam com medo. Eles também estavam admirados. Disseram uns aos outros, “Que tipo de homem é este/este homem é maravilhoso! Ele não só manda nas pessoas, mas quando ele manda no vento e na água, eles também o obedecem!” ");
INSERT INTO portft_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesus e seus discípulos chegaram na área perto da cidade de Gerasa, no outro lado do lago frente ao distrito da Galileia. ");
INSERT INTO portft_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Naquela área havia um homem daquela cidade em quem os demônios viviam/que os demônios controlavam. Por muito tempo ele não tinha usado roupas. Ele não morava em uma casa. Em vez disso ele morava nas cavernas usadas para enterrar pessoas. ");
INSERT INTO portft_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Muitas vezes os demônios o atacavam. As pessoas tentavam guardá-lo para que ele não fizesse mal aos outros. Prenderam suas mãos e seus pés com correntes, mas ele quebrava os correntes. Então os demônios iam mandá-lo para o deserto/lugar vazio. Quando Jesus saíu do barco e pisou na praia, esse homem o viu. Ele correu para Jesus e se prostrou diante dele. Então Jesus mandou, “Você espírito mau, saia desse homem!” Mas ele não saiu logo. Pelo contrário ele fez o homem gritar em voz bem alta, “Jesus, Filho do grande Deus no céu, já que nós não temos nada em comum, saia/por que é que o senhor está me perturbando! Peço ao senhor, não me torture agora/ainda! ");
INSERT INTO portft_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Para expulsar o demônio mais facilmente, Jesus perguntou ao demônio, “Como é o seu nome? Ele respondeu, “Meu nome é legião/multidão.” Ele disse isso porque muitos demônios tinham entrado naquele homem. ");
INSERT INTO portft_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Os demônios continuaram a pedir a Jesus que ele não os mandasse ir ao lugar onde Deus castiga demônios. ");
INSERT INTO portft_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Havia uma grande manada de porcos buscando sua comida no lado do monte. Os demônios pediram a Jesus para deixar que eles entrassem nos porcos. Então ele os permitiu fazer isso. ");
INSERT INTO portft_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Os demônios saíram do homem e entraram nos porcos. Então a manada de porcos correu para baixo para o lago e se afogaram. ");
INSERT INTO portft_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Quando os homens que cuidavam dos porcos viram o que aconteceu, eles correram. Contaram às pessoas dentro e fora da cidade o que tinha acontecido. Aí as pessoas saíram para ver o que tinha acontecido. ");
INSERT INTO portft_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Quando chegaram aonde Jesus estava, viram que o homem de quem Jesus tinha expulsado os demônios estava sentado aos pés de Jesus ouvindo-o. Ele usava roupas, e sua mente estava normal outra vez. Aí essas pessoas, percebendo quanto poder Jesus tinha, ficaram com medo. ");
INSERT INTO portft_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","As pessoas ali que tinham visto o que aconteceu disseram àqueles que acabaram de chegar como Jesus tinha curado o homem que antes estava com demônios. ");
INSERT INTO portft_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Aí essas pessoas e muitas outras da área da cidade de Gerasa pediram que Jesus saísse da sua área. Eles temiam o que Jesus faria mais a eles. Então Jesus e seus discípulos entraram no barco para irem de volta ao outro lado do lago. ");
INSERT INTO portft_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","O homem de quem ele tinha expulsado os demônios pediu a ele dizendo, “Por favor, deixe-me ir com o senhor!” Mas Jesus recusou. Pelo contrário ele lhe disse, ");
INSERT INTO portft_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Vá para casa e diga às pessoas quanto Deus já fez para você!” Aí ele o mandou embora. Então ele foi e disse às pessoas na cidade quanto Jesus fez para ele. ");
INSERT INTO portft_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Quando Jesus e os discípulos voltaram a Cafarnaum, um grupo grande de pessoas que estavam esperando por ele o recebeu. ");
INSERT INTO portft_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Um homem chamado Jairo, que era um dos líderes da sinagoga ali, aproximou-se e prostrou-se aos pés de Jesus. Ele pediu a Jesus, “Por favor, venha à minha casa!” ");
INSERT INTO portft_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Porque sua única filha, que tinha doze anos, estava morrendo. Enquanto Jesus ia com ele, muitas pessoas o apertavam/ficavam bem perto de Jesus. ");
INSERT INTO portft_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Aí uma mulher se aproximou. Fazia doze anos que ela estava sangrando na vagina, mas ninguém podia curá-la. ");
INSERT INTO portft_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ela chegou por trás de Jesus e tocou nas suas roupas para ser curada. Logo ela deixou de sangrar. ");
INSERT INTO portft_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesus disse, “Quem tocou em mim?” Quando todos disseram que não tinham tocado nele, Pedro disse, “Senhor, tem um grupo grande de pessoas perto do senhor e apertando-o, então qualquer um deles podia ter tocado no senhor!” ");
INSERT INTO portft_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mas Jesus disse, “Não, alguém me tocou de propósito. Sei que meu poder tem curado alguém que tocou em mim.” ");
INSERT INTO portft_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Quando a mulher percebeu que não podia impedir que Jesus/as pessoas soubessem que ela estava curada, seu corpo começou a tremer. Ela tinha medo de que, por quebrar/violar a lei que uma mulher com uma doença desse tipo não devia tocar em outros, Jesus talvez a repreendesse por fazer isso. Ela prostrou-se diante dele. Enquanto os outros ouviam, ela disse porque tinha tocado nele e como ela ficou curada imediatamente. ");
INSERT INTO portft_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesus disse a ela, “Senhora, a senhora está curada porque creu que eu podia fazer isso. Saia daqui e que a paz de Deus esteja dentro da senhora.” ");
INSERT INTO portft_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Enquanto ele ainda estava falando, um homem da casa de Jairo chegou e disse a ele, “Sua filha já morreu. Então não perturbe mais o mestre!” ");
INSERT INTO portft_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mas quando Jesus ouviu isso, ele disse a Jairo, “Não pense que a situação seja desesperada. Somente creia que eu possa ajudá-la. Se fizer isso, ela vai viver de novo. ");
INSERT INTO portft_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Quando chegaram perto da casa, ele só permitiu que Tiago, João, Pedro, e a mãe e o pai da menina entrassem na casa com ele. ");
INSERT INTO portft_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Todas as pessoas na casa estavam chorando e batendo no peito para mostrar que estavam tristes. Mas sabendo que ele ia fazer a moça viver de novo, assim como se acorda alguém que dorme, ele disse, “Deixem de chorar! Ela não está morta! Ela está apenas dormindo!” ");
INSERT INTO portft_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","As pessoas ali riram dele, porque sabiam que a menina estava morta. ");
INSERT INTO portft_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mas Jesus pegou na mão dela e chamou para ela dizendo, “Menina, levante-se!” ");
INSERT INTO portft_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Logo o Espírito dela voltou ao seu corpo de novo e ela se levantou. Jesus mandou que eles dessem a ela algo para comer. ");
INSERT INTO portft_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Os pais dela estavam maravilhados, mas Jesus lhes disse para não dizerem nada a ninguém ainda sobre o que tinha acontecido. Aí ele os levou e eles foram sós de barco a uma cidade chamada Betsaida. ");
INSERT INTO portft_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Certo dia Jesus chamou os seus doze apóstolos e deu a eles poder para expulsar todo tipo de demônio e para curar pessoas com doenças. Ele lhes deu autoridade de fazer isso. ");
INSERT INTO portft_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Antes dele enviá-los para curar as pessoas e dizer a elas o que significava deixar que Deus governasse/controlasse por completo as vidas delas, ele disse a eles, ");
INSERT INTO portft_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Não levem coisas para sua viagem. Não levem uma bengala nem uma sacola de viajante nem pão/comida, nem dinheiro. Não levem uma camisa extra/roupas extras. ");
INSERT INTO portft_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sempre quando entram em uma casa para se hospedar ali, fiquem naquela casa até saírem daquela cidade. ");
INSERT INTO portft_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nas cidades onde não recebem vocês bem, saiam daquelas cidades. Quando saírem, sacudam o pó dos seus pés para dizer a eles que Deus vai castigá-los.” ");
INSERT INTO portft_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Então eles saíram e viajaram por muitas aldeias. Em todos os lugares onde foram, falaram a boa mensagem de Deus às pessoas e curaram os doentes. ");
INSERT INTO portft_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes Antipas, o governador/chefe do distrito da Galileia,ouviu/soube das coisas que Jesus e os discípulos dele estavam fazendo. Ele antes tinha mandado que seus soldados executassem/matassem João o batizador, e por isso agora ele estava perplexo, porque alguns diziam que João estava vivo outra vez e estava fazendo esses milagres.  ");
INSERT INTO portft_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Outros diziam que o profeta Elias tinha aparecido outra vez e estava fazendo-os. Outros diziam que um dos outros profetas antigos tinha ficado vivo de novo e estava fazendo esses milagres. ");
INSERT INTO portft_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Porém Herodes disse, “Não pode ser João que está fazendo essas coisas, porque mandei os meus soldados cortarem a sua cabeça. Então quem é que está fazendo esses milagres de que estou ouvindo?” Por isso ele queria ver Jesus. ");
INSERT INTO portft_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Quando os apóstolos voltaram de sua viagem a várias cidades, contaram a Jesus as coisas que tinham feito. Aí ele os levou e foram sozinhos de barco a uma cidade chamada Betsaida. ");
INSERT INTO portft_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Quando as multidões de pessoas que tinham estado com Jesus souberam disso, eles o seguiram por terra. Quando chegaram aonde ele estava, ele os recebeu bem. Ele os ensinou sobre como Deus um dia vai governar como rei/ter autoridade completa sobre as vidas das pessoas. Ele também curou as pessoas doentes. ");
INSERT INTO portft_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","À tardinha, os doze apóstolos foram a Jesus e disseram, “Não há nada neste lugar, portanto mande as pessoas embora para que possam ir às aldeias e outros lugares por aqui e acharem comida e lugares para se hospedarem.” ");
INSERT INTO portft_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mas ele disse a eles, “Não, vocês mesmos deem algo para eles comerem!” Eles responderam, “Nós (excl) temos apenas cinco pãezinhos e dois peixes cozidos. Será que o senhor vai nos dar bastante dinheiro para ir a algum lugar e comprar comida para todas estas pessoas?? ");
INSERT INTO portft_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Havia ali mais ou menos cinco mil pessoas. Ele respondeu aos discípulos, “Não, diga às pessoas para se sentarem. Diga para eles se sentarem em grupos, com mais ou menos 50 pessoas em cada grupo.” ");
INSERT INTO portft_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Depois que disseram isso às pessoas, todas elas se sentaram. ");
INSERT INTO portft_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Aí ele pegou os cinco pães e os dois peixes. Olhou para o céu e deu graças a Deus por eles. Aí ele os quebrou em pedaços e deu aos discípulos para que eles os distribuíssem às pessoas. ");
INSERT INTO portft_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Depois que eles fizeram isso, as pessoas comeram até ficarem satisfeitas. Então os discípulos recolheram doze cestos dos pedaços quebrados que sobraram. ");
INSERT INTO portft_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Certo dia Jesus estava orando em um lugar onde somente os discípulos estavam com ele. Ele perguntou a eles, “As multidões de pessoas, quem é que dizem que eu realmente sou/o que é que dizem sobre a minha identidade?” ");
INSERT INTO portft_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Eles responderam, “Alguns dizem que o senhor é João o batizador que tem vivido de novo. Outros dizem que o senhor é o profeta Elias que tem voltado. Outros dizem que o senhor é um dos outros profetas que vivia muito tempo atrás e que está vivo outra vez.” ");
INSERT INTO portft_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ele perguntou a eles, “E vocês? Quem vocês dizem que eu sou?” Pedro respondeu, “O senhor é o Messias que tem vindo de Deus.” ");
INSERT INTO portft_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Então Jesus disse a eles com firmeza que não dissessem isso para ninguém ainda. ");
INSERT INTO portft_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Então ele disse, “Mesmo que eu seja aquele que vim do céu, é necessário que eu sofra muito, e que os anciãos judaicos e os sacerdotes principais e os homens que ensinam as leis judaicas me rejeitem. É necessário que as pessoas me matem, e que eu torne a viver no terceiro dia depois disso.” ");
INSERT INTO portft_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Então ele disse a todos eles, “Se alguém quiser ser o meu discípulo, ele precisa fazer não só o que ele mesmo quer fazer. Ele tem que estar disposto todos os dias a deixar que outros o façam mal E o envergonhem. É isso que os outros fazem aos piedosos quando fazem com que carreguem uma cruz e depois os matam em cima dela. É o que precisa fazer qualquer um que quiser ser o meu discípulo. ");
INSERT INTO portft_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Aquele que tenta salvar a sua vida negando que é meu quando as pessoas querem matá-lo porque pertence a mim nunca vai viver eternamente, mas aquele que eles matarem por ser meu discípulo vai viver para sempre comigo. ");
INSERT INTO portft_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","As pessoas podem ganhar tudo quanto querem neste mundo, mas realmente não estão ganhando nada/será que estão realmente ganhando algo se não ganharem a vida eterna por se tornarem meus discípulos. ");
INSERT INTO portft_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Se alguém rejeitar a minha mensagem e recusar dizer que pertence a mim, eu, aquele que vim do céu, também vou deixar de dizer que ele pertence a mim quando eu voltar com os santos anjos e tiver o esplendor glorioso que tem o meu Pai. ");
INSERT INTO portft_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mas ouçam com cuidado! Alguns de vocês que estão aqui agora vão ver Deus governar de muitas maneiras poderosas antes que morram. ");
INSERT INTO portft_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mais ou menos uma semana depois de Jesus dizer estas coisas, ele levou Pedro e Tiago e João, o irmão de Tiago, e os guiou para um monte para que ele pudesse orar ali. ");
INSERT INTO portft_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Enquanto ele orava, o rosto dele parecia muito diferente para eles. Sua roupa ficou brilhante como um relâmpago. ");
INSERT INTO portft_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","De repente dois homens apareceram que tinham o brilho do céu ao seu redor. Eles eram profetas que tinham vivido muito tempo atrás, Moisés e Elias. ");
INSERT INTO portft_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Começaram a falar com Jesus sobre como ele ia realizar o que Deus tinha planejado quando morresse pouco tempo depois em Jerusalém. ");
INSERT INTO portft_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro e os outros discípulos que estavam com ele estavam dormindo profundamente. Quando acordaram, viram o brilho de Jesus. Eles também viram os dois homens em pé com ele. ");
INSERT INTO portft_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Quando Moisés e Elias estavam começando a deixar Jesus, Pedro disse a ele, “Senhor, é maravilhoso nós estarmos aqui! Por isso deixe-nos construir três barracas. Uma vai ser para o senhor, uma vai ser para Moisés, e uma vai ser para Elias!” Mas na verdade ele não sabia o que estava dizendo. ");
INSERT INTO portft_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Enquanto ele dizia isso, uma nuvem brilhante apareceu e os cobriu. Os discípulos ficaram com medo quando a nuvem os envolveu. ");
INSERT INTO portft_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Deus MTY/EUP falou com eles da nuvem, dizendo, “Este é meu Filho/amado. É ele quem tenho escolhido para fazer uma grande obra para mim. Portanto, ouçam-no!” ");
INSERT INTO portft_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Depois de Deus MTY/EUP terminar de dizer isso, Os três discípulos viram que somente Jesus estava ali. Eles não disseram para ninguém o que tinham visto até muito mais tarde. ");
INSERT INTO portft_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","No dia seguinte, depois deles descerem do monte, um grupo grande de pessoas foram encontrar-se com Jesus. ");
INSERT INTO portft_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Então um homem da multidão exclamou, “Mestre, peço que o Senhor faça algo para ajudar o meu filho! Ele é meu único filho! ");
INSERT INTO portft_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Às vezes de surpresa um Espírito mal agarra nele e o faz gritar. O Espírito mal o sacode violentamente e faz ele babar. O Espírito não sai até o meu filho ficar completamente exausto. ");
INSERT INTO portft_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Pedi aos seus discípulos que estavam aqui que eles expulsassem o demônio, mas não podiam fazer isso.” ");
INSERT INTO portft_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus respondeu, “Estou muito triste que, mesmo que vocês tenham observado como eu ajudo as pessoas, vocês não creem que Deus possa dar a vocês a capacidade de ajudar as pessoas! Seu modo de pensar está errado! Quanto tempo eu tenho que estar com vocês antes que vocês possam fazer o que eu faço? Traga o seu filho para mim! ");
INSERT INTO portft_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Enquanto eles levavam o menino a Jesus, o demônio atacou o menino, jogou-o no chão, e o sacudiu. Mas Jesus repreendeu o espírito mau e curou o rapaz. Então ele o devolveu aos cuidados do pai dele. ");
INSERT INTO portft_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Todos ali estavam maravilhados do grande poder de Deus. ");
INSERT INTO portft_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Pensem com cuidado sobre o que vou dizer a vocês: mesmo que eu seja aquele que vim do céu, alguém está para me entregar a homens que vão me levar preso. ");
INSERT INTO portft_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mas eles não entenderam o que ele estava dizendo; Deus impediu que eles entendessem, para que eles ainda não soubessem o que ele queria dizer. Eles também tinham medo de perguntar a ele sobre o que ele tinha dito. ");
INSERT INTO portft_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Os discípulos começaram a discutir entre si sobre qual deles seria o maior quando Jesus se tornasse rei. ");
INSERT INTO portft_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mas Jesus percebeu o que eles estavam pensando. Então ele levou uma criança pequena para o lado dele. ");
INSERT INTO portft_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ele disse a eles, “Qualquer um, sendo meu discípulo/fazendo o que eu faria que recebe uma criança pequena como esta assim como eu faria, Deus considera que ele está me recebendo. E quem me receber, Deus considera que essa pessoa está recebendo a ele, aquele que me enviou. Lembrem-se de que a pessoa entre vocês que pensa em si mesma como sendo sem importância, vai ser a pessoa que Deus considera grande. ");
INSERT INTO portft_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","João disse a Jesus, “Mestre, nós (excl) vimos um homem que estava expulsando demônios, afirmando que o senhor deu a ele o poder de fazer isso. Dissemos a ele para não fazer isso, porque ele não viaja conosco. ");
INSERT INTO portft_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mas Jesus disse a ele e aos outros discípulos, “Não diga a ele para não fazer isso. Lembrem-se de que aqueles que não se opõem a vocês estão tentando alcançar os mesmos alvos de vocês. ");
INSERT INTO portft_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Quando estava quase na hora de Deus levá-lo para o céu, Jesus tomou uma firme decisão de ir a Jerusalém. Mandou alguns mensageiros para irem diante dele. ");
INSERT INTO portft_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Entraram em uma aldeia no distrito da Samaria para preparar para ele ir até ali. ");
INSERT INTO portft_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mas os samaritanos não gostavam dos judeus por causa da insistência deles de que se adorasse a Deus somente em Jerusalém. Então já que Jesus tinha resolvido firmemente ir a Jerusalém, eles não permitiram que ele entrasse na cidade deles. ");
INSERT INTO portft_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Quando dois dos seus discípulos, Tiago e João, souberam disso, eles disseram, “Senhor, o senhor quer que oremos que Deus mande fogo descer do céu para destruir essas pessoas?” ");
INSERT INTO portft_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mas Jesus voltou-se e os repreendeu por dizerem isso. ");
INSERT INTO portft_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Então eles foram a outra aldeia. ");
INSERT INTO portft_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Enquanto Jesus e seus discípulos andavam pelo caminho, certo homem disse a ele, “Senhor, eu irei com o senhor onde quer que o senhor for.” ");
INSERT INTO portft_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Para mostrar a ele o que ele poderia esperar se fizesse isso, Jesus lhe disse, “As raposas têm buracos no chão onde moram, e os pássaros têm ninhos, mas mesmo que eu seja aquele que vim do céu, não tenho casa onde dormir. ");
INSERT INTO portft_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesus disse a outro homem, “Venha comigo!” Mas o homem disse, “Senhor, deixe-me ir para casa primeiro. Depois do meu pai morrer, vou enterrá-lo e então irei com o senhor.” ");
INSERT INTO portft_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mas Jesus disse a ele, “Aqueles que não têm a vida eterna são mortos à vista de Deus. Deixe essas pessoas fazerem o trabalho de enterrar as pessoas que morrem. Quanto a você, vá e diga às pessoas como Deus quer governar/controlar por completo as vidas delas.” ");
INSERT INTO portft_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Outra pessoa disse, “Senhor, venho com o senhor para ser o seu discípulo, mas deixe-me ir primeiro para casa para me despedir dos meus parentes.” ");
INSERT INTO portft_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus disse a ele, “Aquele que está arando sua roça não deve olhar para trás para ver o que tem feito. Ele precisa olhar para frente. Da mesma forma, qualquer um que continue a se preocupar com a família e com outras coisas que já deixou para trás não está digno de me servir dizendo aos outros como Deus quer governar as vidas delas. ");
INSERT INTO portft_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Depois disso, o Senhor Jesus designou outros 72 pessoas. Ele preparou para enviá-los, de dois em dois, a cada cidade e aldeia onde ele mesmo pretendia ir. ");
INSERT INTO portft_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ele disse a eles, “As pessoas que estão prontas para receberem a mensagem de vocês são como uma plantação que está pronta para as pessoas colherem. Mas não há muitos para trazê-los para Deus. Por isso, orem e peçam a Deus para enviar mais pessoas para fazer a obra de trazê-los a Deus. ");
INSERT INTO portft_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Comecem a ir, mas lembrem-se de que estou mandando vocês para dizer a minha mensagem a pessoas que vão tentar acabar com vocês. Vocês serão como cordeiros entre os lobos. ");
INSERT INTO portft_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Não levem dinheiro em uma bolsa. Não levem mala de viajante. Não levem sandálias extras. Não passem muito tempo saudando pessoas pelo caminho. ");
INSERT INTO portft_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Sempre que entrarem em uma casa para se hospedarem ali, primeiro digam a essas pessoas, “Que Deus dê a paz interior a vocês em esta casa! ");
INSERT INTO portft_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Se as pessoas que moram ali desejarem a paz de Deus, vão experimentar a paz interior que vocês lhes oferecem. Se as pessoas que moram ali não desejarem ter a paz de Deus, vocês vão experimentar a paz interior de Deus mas eles não. ");
INSERT INTO portft_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Se eles receberem vocês bem, fiquem naquela mesma casa até saírem daquela aldeia. Comam e bebam as coisas que eles providenciam para vocês. Um obreiro merece receber pagamento daqueles para quem trabalha, então vocês merecem receber comida e um lugar de hospedagem das pessoas a quem vão. ");
INSERT INTO portft_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Sempre que entrarem em uma aldeia e as pessoas ali receberem vocês, comam o que oferecerem a vocês. ");
INSERT INTO portft_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Curem as pessoas ali que estão doentes. Digam a elas, Está quase na hora de Deus mandar o seu rei para controlar as suas vidas. ");
INSERT INTO portft_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mas se entrarem em uma aldeia cujo povo não os recebe bem, vão para suas ruas principais e digam, ");
INSERT INTO portft_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Já que vocês recusam ouvir a nossa mensagem, nós (excl) não somente vamos sair, mas vamos sacudir o pó de sua cidade que se acha nas nossas sandálias, para dizer a vocês que Deus vai rejeitar/castigar vocês. Mas queremos que vocês saibam que está quase na hora de Deus começar a governar!' ");
INSERT INTO portft_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Vou dizer-lhes isto: quando Deus castigar as pessoas, ele vai castigar as pessoas más que viviam em Sodoma muito tempo atrás, mas ele vai castigar ainda mais severamente as pessoas daquela cidade que recusar ouvir a sua mensagem! ");
INSERT INTO portft_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ai de/será terrível para vocês das cidades de Corazim e Betsaida! Fiz grandes milagres entre vocês para mostrar o poder de Deus, mas vocês não deixaram as suas vidas de pecado. Se alguém tivesse feito nas cidades de Tiro e Sidom os milagres que eu fiz entre vocês, as pessoas ali teriam se arrependido de suas vidas de pecado muito tempo atrás. Teriam mostrado que lamentavam ter pecado ao sentar-se no chão vestidos de pano grosseiro e ao colocar cinza em suas cabeças. ");
INSERT INTO portft_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mas eles não fizeram isso, por isso quando Deus castigar as pessoas, ele vai castigar as pessoas más que viviam em Tiro e em Sodoma, mas ele vai castigar vocês ainda mais severamente porque não ligaram para minha mensagem! ");
INSERT INTO portft_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Vocês da cidade de Cafarnaum, não pensem/será que pensam que Deus vai honrar vocês no céu! Não, pelo contrário, depois de vocês morrerem, Deus vai jogá-los para baixo para o lugar onde ele vai castigar as pessoas que pecam para sempre! ");
INSERT INTO portft_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesus também disse aos discípulos, “Deus vai considerar que aqueles que ouvirem a sua mensagem estão me ouvindo, e que aqueles que rejeitarem a sua mensagem estão me rejeitando. E ele vai considerar que aqueles que me rejeitarem estão rejeitando a ele, aquele que me mandou/enviou. ");
INSERT INTO portft_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","As 72 pessoas que Jesus designou foram e fizeram assim como ele mandou. Quando voltaram, estavam muito felizes. Eles disseram, “Senhor, as pessoas fizeram o que nós (excl) mandamos. Mas os demônios também nos obedeceram quando pela autoridade do senhor nós os mandamos que saíssem das pessoas!” ");
INSERT INTO portft_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ele respondeu, “Quando esses demônios estavam obedecendo vocês, porque Deus tinha ajudado vocês a derrotá-los, foi como se eu visse Satanás cair do céu tão de repente e tão rápido quanto cai um relâmpago. ");
INSERT INTO portft_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ouçam! Já dei autoridade para vocês para que se pisarem por acaso em cobras venenosas ou em escorpiões, estes não farão mal a vocês. Já dei a vocês autoridade para derrotar nosso inimigo, Satanás. Nada vai fazer mal a vocês. ");
INSERT INTO portft_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mas mesmo que vocês possam alegrar-se porque os espíritos malignos obedecem vocês, devem alegrar-se ainda mais que Deus tenha escrito seus nomes no céu, porque estarão ali para sempre com ele.” ");
INSERT INTO portft_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Naquele tempo o Espírito Santo fez com que Jesus estivesse muito feliz. Ele disse, “Pai, o senhor é o Senhor que controla tudo no céu e na terra. Agradeço o senhor por impedir aqueles que se consideram sábios por serem bem educados de saberem estas coisas. Pelo contrário o senhor as tem revelado àqueles que aceitam logo a sua verdade assim como fazem as crianças pequenas. Sim, Pai, é isso que o senhor na sua misericórdia resolveu fazer.” ");
INSERT INTO portft_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ele também disse aos 72 discípulos, ”Meu Pai me tem revelado todas as coisas que preciso saber para meu trabalho. Meu Pai sabe quem eu realmente sou, e eu sei quem meu Pai realmente é. Aqueles a quem eu escolho revelar quem é o meu Pai também vão conhecê-lo. Ninguém mais vai conhecê-lo muito bem.” ");
INSERT INTO portft_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Então quando seus discípulos estavam sós com ele, ele voltou-se para eles e disse, “Deus se agrada de vocês que têm visto as coisas que tenho feito!  ");
INSERT INTO portft_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Quero que saibam que muitos profetas e reis que viviam muito tempo atrás desejavam ver os milagres que vocês estão vendo, mas não viram milagres como estes. Desejavam ouvir as coisas que vocês estão me ouvindo dizer, mas eles não ouviram/eu não disse a eles estas coisas. ");
INSERT INTO portft_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Um dia quando Jesus estava ensinando as pessoas, um homem que estudava as Escrituras com cuidado estava ali. Ele queria fazer uma pergunta difícil para Jesus. Então ele se pôs de pé e perguntou, “Mestre, o que devo fazer para viver para sempre com Deus?” ");
INSERT INTO portft_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus respondeu, Você já leu o que Moisés escreveu a esse respeito na lei que Deus deu a ele. O que Moisés escreveu sobre isso?” ");
INSERT INTO portft_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","O homem respondeu, “Ele escreveu que nós (inc) precisamos amar o Senhor nosso Deus dentro de nossos seres interiores/corações. Devemos mostrar isso pelo que sentimos, e pelo que fazemos e pelo que pensamos. Ele também escreveu que devemos amar as pessoas com quem temos contato da mesma maneira em que amamos a nós mesmos.” ");
INSERT INTO portft_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus respondeu, “Você já respondeu à sua pergunta. Se fizer tudo isso continuamente, você vai viver com Deus para sempre. ");
INSERT INTO portft_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mas o homem queria defender a sua maneira de tratar as pessoas com quem tinha contato (OU, defender a razão por que ele tinha feito uma pergunta que Jesus respondeu de maneira tão simples). Por isso ele disse a Jesus, “Quais as pessoas com quem tenho contato que devo amar?” ");
INSERT INTO portft_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus respondeu contando a ele esta ilustração: Um homem judeu estava andando pela estrada que vai de Jerusalém a Jericó. Uns bandidos o atacaram. Eles levaram quase todas as roupas do homem bem como as outras coisas que tinha, e bateram nele até ele estar quase morto. Então eles o deixaram. ");
INSERT INTO portft_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Aconteceu que um sacerdote judaico estava passando por aquela estrada. Quando ele viu o homem, em vez de ajudá-lo ele passou pelo outro lado da estrada. ");
INSERT INTO portft_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Da mesma maneira, um homem que trabalhava no templo em Jerusalém chegou àquele lugar e viu o homem. Mas ele também passou pelo outro lado da estrada. ");
INSERT INTO portft_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Depois um homem da província da Samaria passou por aquela estrada até onde o homem estava deitado. As pessoas da Samaria desprezam os judeus. Mas quando ele viu esse homem, ele teve pena dele. ");
INSERT INTO portft_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ele aproximou-se do homem e pôs azeite de oliva e vinho nas feridas para ajudar a curá-las. Ele enfaixou as feridas em faixas de pano. Ele colocou o homem no próprio animal/burro dele e o levou a uma pensão e cuidou dele. ");
INSERT INTO portft_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na manhã seguinte ele deu duas moedas de prata ao dono da pensão e disse, Cuide deste homem. Se você gastar mais do que esta quantia para cuidar dele, vou devolver a você quando eu voltar. ");
INSERT INTO portft_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Três homens viram o homem que foi atacado pelos bandidos. Qual deles agiu com amor para com a pessoa que ele viu?” ");
INSERT INTO portft_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aquele que estudava a lei respondeu, “Aquele que mostrou misericórdia a ele.” Jesus disse a ele, “Vá e aja assim para com todos que puder ajudar.” ");
INSERT INTO portft_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ao continuarem a viajar, Jesus e seus discípulos entraram em uma aldeia. Uma mulher cujo nome era Marta os convidou para irem à casa dela. ");
INSERT INTO portft_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A irmã mais nova dela, que se chamava Maria, estava sentada perto de Jesus. Ela estava ouvindo o que ele estava ensinando. ");
INSERT INTO portft_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mas Marta estava muito preocupada com a preparação do jantar/da refeição. Ela foi a ele e disse, “Senhor, o senhor não se importa/não parece importar-se de que minha irmã me deixou para preparar tudo sozinha! Diga a ela que me ajude!” ");
INSERT INTO portft_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mas o Senhor respondeu, “Marta, Marta, você se preocupa com muitas coisas. ");
INSERT INTO portft_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mas só uma coisa é necessária, isto é, ouvir o que estou ensinando. Maria já resolveu fazer isso, e é melhor assim. Ninguém vai tirar dela a bênção que ela está recebendo ao fazer isso. ");
INSERT INTO portft_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Certo dia Jesus estava orando. Quando ele terminou de orar, um dos discípulos dele disse a ele, “Senhor, ensine-nos o que dizer quando nós (excl) oramos, assim como João o Batizador ensinou os discípulos dele.” ");
INSERT INTO portft_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ele disse a eles, “Quando orarem, digam coisas como estas: Pai, ajuda-nos a honrar-te. Que o senhor verdadeiramente se torne o rei que vai governar as nossas vidas. ");
INSERT INTO portft_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dá-nos cada dia a comida de que precisamos. ");
INSERT INTO portft_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Perdoa-nos pelas coisas erradas que temos feito, porque nós perdoamos as pessoas pelas coisas más que fazem a nós. Não nos deixe fazer coisas erradas quando algo ou alguém nos tenta.” ");
INSERT INTO portft_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aí ele disse a eles, “Vamos dizer que um de vocês vai à casa de um amigo à meia-noite. Vamos dizer que você fica de fora e chama para ele, Meu amigo, por favor, empreste-me três pãezinhos. ");
INSERT INTO portft_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Outro amigo meu que está viajando acaba de chegar em minha casa, mas não tenho comida pronta para dar a ele. ");
INSERT INTO portft_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Vamos dizer que ele responde a você de dentro da casa, Não me perturbe. Pois nós (excl) já trancamos a porta e toda a minha família está na cama. Por isso não posso levantar-me para dar nada a você. ");
INSERT INTO portft_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Vou dizer a vocês que se ele não se levantar para dar comida a você, para evitar sentir vergonha por não ajudá-lo porque você é amigo dele, (OU, se sem ter vergonha você continuar a pedir a ele para fazer isso), ele com certeza vai levantar-se para dar a você o que você precisar. ");
INSERT INTO portft_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Então digo isto a vocês: continuem a pedir de Deus o que vocês precisarem, e ele vai dar a vocês. Continuem a esperar com confiança que Deus vá dar a vocês o que precisam, e ele vai dar a vocês. Continuem a orar urgentemente a Deus assim como um homem que bate à porta, e Deus vai abrir o caminho para vocês receberem aquilo pelo qual oram. ");
INSERT INTO portft_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Lembrem-se de que Deus vai dar coisas a todos os que continuam a pedir a ele por elas. Deus vai dar coisas àquele que continuar a pedir a ele com confiança o que lhe falta. Deus vai abrir o caminho para as pessoas conseguirem as coisas pelas quais continuam a pedir com urgência. ");
INSERT INTO portft_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Se qualquer um de vocês tivesse um filho que lhe pedisse um peixe para comer, você certamente não daria a ele uma cobra/não substituiria com uma cobra! ");
INSERT INTO portft_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Se ele pedisse a você um ovo, você certamente não/será que você lhe daria um escorpião. ");
INSERT INTO portft_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mesmo que vocês sejam maus, sabem dar coisas boas aos seus filhos. Então seu Pai no céu certamente vai dar coisas boas àqueles que pedirem a ele, inclusive o Espírito Santo, que é o melhor presente. ");
INSERT INTO portft_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Um dia havia um homem em quem vivia um demônio que o fez incapaz de falar. Depois que Jesus expulsou o demônio, o homem começou a falar. A maioria das pessoas ali ficou maravilhada. ");
INSERT INTO portft_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mas alguns deles disseram, “É pelo poder de Belzebu, o chefe dos demônios, que Jesus expulsa os demônios!” ");
INSERT INTO portft_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Outras pessoas ali pediram que ele fizesse um milagre para provar que ele tinha vindo do céu/Deus MTY/EUP. Eles queriam pegá-lo em uma situação em que não poderia fazer um milagre ou em que faria algo ridículo. ");
INSERT INTO portft_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mas ele sabia o que eles estavam pensando. Então ele disse a eles, “Se um povo que um rei governa se divide uma parte contra outra, eles vão destruir as sua nação. Se as pessoas de uma casa forem divididas, vão deixar de ser uma só família. ");
INSERT INTO portft_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","De modo semelhante, se Satanás e seus demônios estivessem brigando entre si, seu domínio sobre eles certamente não/como é que seu domínio sobre eles continuaria. Digo isto porque vocês estão dizendo que expulso os demônios pelo poder do chefe desses mesmos demônios! ");
INSERT INTO portft_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Além disso, as pessoas que vocês ensinam também expulsam demônios. Mas elas não diriam/será que diriam que era pelo poder de Satanás que eles estavam expulsando demônios! Então eles vão mostrar a vocês que o que vocês estão dizendo a meu respeito está errado. ");
INSERT INTO portft_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mas já que é pelo poder de Deus que estou expulsando demônios, isso prova que o poder de Deus para governar/controlar as vidas das pessoas já chegou a vocês.” ");
INSERT INTO portft_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Então, para mostrar que ao expulsar demônios ele estava demonstrando que era muito mais poderoso do que Satanás, Jesus disse, “Quando um homem forte que tem muitas armas guarda sua própria casa, ninguém pode roubar as coisas de sua casa. ");
INSERT INTO portft_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mas quando outro que é mais forte o ataca e o domina, ele pode tirar as armas em que confiava, e ele pode tirar da casa desse homem o que quiser tirar. ");
INSERT INTO portft_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Estas pessoas que estão me acusando não estão me ajudando, e considero que qualquer um que não me ajuda se opõe a mim, e que aquele que não está reunindo pessoas para serem meus discípulos está fazendo com que me deixem/abandonem o meu ensinamento. ");
INSERT INTO portft_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Então Jesus disse isto: “Às vezes quando um Espírito maligno sai de alguém, anda à toa por uma área vazia procurando uma pessoa em quem pode descansar. Se ele não achar ninguém, diz para si mesmo, Vou voltar à pessoa de quem saí! ");
INSERT INTO portft_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Então ele volta à pessoa e vê que o Espírito de Deus não controla a vida dela. A vida dela é como uma casa que alguém tem varrido e arrumado, mas como uma casa vazia. ");
INSERT INTO portft_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aí ele vai e pega mais sete espíritos malignos que são ainda piores do que ele. Todos eles entram naquela pessoa e vivem ali. Portanto, embora a situação daquela pessoa antes fosse má, ficou ainda pior.” ");
INSERT INTO portft_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Quando Jesus disse isso, uma mulher que estava ouvindo gritou para ele, “Deus se agrada da mulher que deu à luz o senhor e que deu o peito a você.” ");
INSERT INTO portft_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mas ele respondeu, “Deus se agrada ainda mais daqueles que ouvem a sua mensagem e a obedecem!” ");
INSERT INTO portft_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Quando o grupo das pessoas em redor de Jesus ficou maior, ele disse, “Muitos de vocês que têm observado o meu ministério são maus. Vocês me pedem para fazer um milagre que prova que vim de Deus, mas o único milagre que vou fazer para vocês é um do tipo que aconteceu a Jonas. ");
INSERT INTO portft_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Depois de Jonas estar dentro de um peixe enorme por três dias, Deus fez um milagre para fazê-lo viver de novo. Ele deu testemunho a respeito disso para que o povo da cidade de Nínive cresse na sua mensagem. Deus vai fazer um milagre semelhante para mim para que vocês que têm visto o que eu, aquele que vim do céu, tenho feito, creiam na minha mensagem.  ");
INSERT INTO portft_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Muito tempo atrás a rainha de Sabá, ao sul de Israel, viajou grande distância para ouvir Salomão dizer muitas coisas sábias. Porém eu tenho chegado aqui, e sou maior do que Salomão, mas vocês não têm ligado para o que eu digo a vocês. Por isso no tempo quando Deus julgar todas as pessoas, a rainha de Sebá vai estar ali com vocês e vai condenar vocês. ");
INSERT INTO portft_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","As pessoas que moravam na cidade de Nínive abandonaram as suas vidas de pecado quando Jonas pregou para elas. Mas agora eu tenho chegado aqui e pregado a vocês, e sou maior do que Jonas, mas vocês não abandonaram as suas vidas de pecado. Por isso, naquele tempo quando Deus julgar todas as pessoas, as pessoas que viviam em Nínive vão estar ali com vocês e vão condenar vocês.” ");
INSERT INTO portft_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Então, para mostrar a eles que eles não precisavam de mais milagres, eles só precisavam entender melhor o que ele já tinha dito a eles, ele disse a eles: Ninguém depois de acender uma lâmpada a coloca em um lugar onde está sempre escuro ou debaixo de um cesto. Pelo contrário, ele a coloca em um velador para que aqueles que entram na casa vejam a sua luz. ");
INSERT INTO portft_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","De modo semelhante, eu não tenho escondido a verdade de Deus. Eu a tenho revelado a vocês. Dentro de cada um de vocês, os seus olhos são como uma lâmpada que permite que você veja/enxergue as coisas. Se os olhos de você são bons, é como uma sala com uma lâmpada que o ajuda a ver tudo muito bem. De modo semelhante, se você aceita meu ensinamento, você vai poder saber tudo que Deus quer que saiba. Mas se os olhos de você são maus, você não pode ver nada. É como se você estivesse na escuridão. De modo semelhante se vocês não aceitarem meu ensinamento, não vão poder saber tudo que Deus quer que saibam. ");
INSERT INTO portft_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Portanto, vocês não precisam ver mais milagres. Vocês precisam pensar com cuidado naquilo que eu já disse a vocês, para que as coisas que têm ouvido dos outros não os façam ficar na escuridão. ");
INSERT INTO portft_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Se vocês viverem totalmente segundo a verdade de Deus, vocês vão poder saber tudo que Deus quer que saibam. Vai ser como estar em uma sala com uma boa luz, fazendo com que vocês vejam tudo claramente.” ");
INSERT INTO portft_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Enquanto Jesus dizia estas coisas, um fariseu o convidou para jantar em sua casa. Então Jesus foi à casa dele e comeu com ele. ");
INSERT INTO portft_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","O fariseu ficou admirado porque viu que Jesus não lavou as mãos antes de comer. Os fariseus pensavam que se alguém não seguisse aquele ritual, Deus talvez o rejeitasse por ele possivelmente ter tocado em algo inaceitável a Deus. ");
INSERT INTO portft_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","O Senhor Jesus disse a ele, “Vocês fariseus se preocupam com as coisas que estão fora de seus corpos, não com o que está nos seus seres interiores/corações. Vocês lavam o exterior dos pratos e dos copos antes de comerem porque acham que isso os fará aceitáveis a Deus, mas dentro de si mesmos vocês são muito maus e cobiçosos. ");
INSERT INTO portft_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Vocês tolos/seus tolos! Deus se preocupa com as coisas fora de nossos corpos, mas ele certamente está/será que ele não está preocupado também com os nossos seres interiores! ");
INSERT INTO portft_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Deem dinheiro aos pobres. Deem conforme o que vocês sabem nos seus seres interiores/corações que devem dar. Então ficarão maravilhados ao descobrirem que vão ser aceitáveis a Deus sem terem que observar todos aqueles rituais sobre lavagem. ");
INSERT INTO portft_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mas ai de/será terrível para vocês fariseus! Vocês dão a Deus dez por cento de tudo quanto produzem, até mesmo das ervas que criam, mas não se lembram de que precisam agir com justiça para com os outros e amar a Deus! É bom dar dez por cento da sua renda a Deus, mas deviam fazer essas outras coisas também! ");
INSERT INTO portft_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ai de vocês fariseus, porque gostam de sentar-se nos melhores lugares nas sinagogas para que as pessoas pensem bem de vocês, e gostam que as pessoas os saúdem com respeito nos mercados. ");
INSERT INTO portft_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ai de vocês, porque são como terreno onde não há nenhum marcador para indicar que há um túmulo lá embaixo. As pessoas andam ali mas não podem ver o que está podre lá embaixo! Semelhantemente, as pessoas que os veem não percebem como vocês são poluídos dentro de si mesmos.” ");
INSERT INTO portft_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Um daqueles que ensinava as leis judaicas respondeu, “Mestre, ao dizer isso o senhor está nos criticando também!” ");
INSERT INTO portft_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus disse, “Ai também de vocês que ensinam as leis judaicas! Vocês mandam que as pessoas obedeçam muitas regras que são difíceis de obedecer. Isso é como fazê-los carregar fardos pesados nas suas costas. Mas vocês mesmos não obedecem as leis que requerem que os outros obedeçam. (OU, Vocês não fazem nada para ajudar os outros a obedecerem as leis.) ");
INSERT INTO portft_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ai de vocês! Vocês enfeitam os túmulos dos profetas que seus antepassados mataram, mas não vivem conforme o que os profetas ensinavam. ");
INSERT INTO portft_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pois vocês estão declarando que aprovam daquilo que seus antepassados fizeram. Eles mataram os profetas, e vocês não estão honrando-os! Vocês apenas enfeitam os túmulos deles! ");
INSERT INTO portft_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Por isso Deus, que é muito sábio, disse, Vou mandar aos judeus profetas e apóstolos. Os judeus vão matar alguns deles e vão perseguir alguns deles. ");
INSERT INTO portft_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Como resultado, vou considerar que muitos de vocês que têm observado o ministério do meu filho sejam culpados de matar todos os profetas, desde quando criei o mundo, ");
INSERT INTO portft_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","começando com Caim, filho de Adão, que matou seu irmão Abel e continuando até que mataram Zacarias entre o altar e o lugar santo no templo.” Sim, o que digo é a verdade. Deus vai castigar vocês que têm observado meu ministério((vocês que)) ele considera culpados de matarem todas essas pessoas! ");
INSERT INTO portft_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ai de vocês homens que ensinam as leis judaicas, porque vocês não têm deixado as pessoas conhecerem a verdade de Deus. É como se vocês estivessem tirando a chave de uma casa. Vocês mesmos não estão entrando na casa, e não estão deixando que outros entrem nela. ");
INSERT INTO portft_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Depois de Jesus terminar de dizer estas coisas, ele saíu dali. Aí os homens que ensinavam as leis judaicas e os fariseus começaram a mostrar muita hostilidade para com Jesus. Eles tentaram fazê-lo dizer o que pensava sobre vários assuntos. ");
INSERT INTO portft_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Eles estavam esperando que ele dissesse algo errado pelo qual podiam acusá-lo. ");
INSERT INTO portft_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Enquanto eles faziam isso, milhares de pessoas se reuniram em redor de Jesus. Havia tantos que eles estavam pisando uns em outros. Então ele disse aos seus discípulos, “Tenham cuidado de não se tornarem hipócritas como os fariseus. Pois a sua má influência se estende para os outros assim como o fermento espalha sua influência pela massa. ");
INSERT INTO portft_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","As coisas que eles ou outras pessoas tentam esconder agora não vão permanecer escondidos. Deus um dia vai fazer com que todos saibam as coisas que eles escondem agora. ");
INSERT INTO portft_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Todas as coisas que vocês dizem secretamente na escuridão, um dia as pessoas ouvirão na luz do dia. As coisas que vocês disseram a alguém em voz bem baixa em uma sala onde não tem mais ninguém, as pessoas vão proclamá-las publicamente. ");
INSERT INTO portft_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Meus amigos, ouçam com cuidado! Não tenham medo das pessoas que podem matar vocês, porém depois de matar vocês, não tem mais nada que possam fazer para feri-los. ");
INSERT INTO portft_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mas eu vou dizer a vocês de quem é que realmente devem ter medo. Vocês devem ter medo de Deus, porque ele não só tem poder para matar as pessoas, ele tem poder para jogá-las no inferno depois! Sim, vocês realmente devem ter medo dele! ");
INSERT INTO portft_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Pensem nos pardais. Eles têm tão pouco valor que pode-se comprar cinco deles por apenas duas moedas pequenas. Mas Deus não se esquece de nenhum deles! ");
INSERT INTO portft_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Vocês são de mais valor para Deus do que muitos pardais. Portanto, não tenham medo do que as pessoas podem fazer a vocês! Ele sabe até quantos cabelos há na cabeça de cada um de vocês, então se você perde um, ele já sabe disso. Portanto, nada mau pode acontecer a vocês sem ele saber. ");
INSERT INTO portft_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Eu também quero dizer a vocês que se alguém sem ter medo diz a outros que ele é meu discípulo, eu, aquele que vim do céu, vou dizer a Deus que ele é meu discípulo, enquanto os anjos de Deus escutam. ");
INSERT INTO portft_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","mas se ele tem medo e diz na presença de outros que não é meu discípulo, eu vou dizer que ele não é meu discípulo, enquanto os anjos de Deus ouvirem. ");
INSERT INTO portft_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Eu também vou dizer a vocês que Deus pode perdoar aqueles que dizem coisas ruins a respeito de mim, aquele que vim do céu, mas Deus não vai perdoar ninguém que diz coisas más a respeito do Espírito Santo. ");
INSERT INTO portft_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Então quando eles perguntam a vocês nas casas judaicas de adoração e na presença dos governadores e de outras autoridades a respeito da sua confiança em mim, não se preocupem sobre como vão responder a eles quando eles acusarem vocês, nem se preocupem com o que vão dizer, ");
INSERT INTO portft_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","porque o Espírito Santo vai dizer a vocês naquela mesma hora o que é que devem dizer. ");
INSERT INTO portft_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Aí uma das pessoas na multidão disse a Jesus, “Mestre, diga a meu irmão mais velho para dividir a propriedade do meu pai e me dar a parte que me pertence!” ");
INSERT INTO portft_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mas Jesus respondeu a ele, “Homem, ninguém me designou/será que alguém me designou para eu julgar esses assuntos quando as pessoas disputam propriedade! ");
INSERT INTO portft_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Então ele disse a toda a multidão, “Tenham muito cuidado, para não desejarem de nenhuma maneira as coisas dos outros! Ninguém pode fazer a sua vida mais segura obtendo mais bens.” ");
INSERT INTO portft_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Então ele contou a eles esta ilustração: havia certo homem rico que tinha roças onde cresciam muitas coisas em abundância. ");
INSERT INTO portft_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Aí ele disse para si mesmo, Eu não sei o que fazer, porque não tenho lugar suficientemente grande para guardar toda a minha colheita! ");
INSERT INTO portft_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Depois ele disse a si mesmo, Já sei o que farei. Vou derrubar meus depósitos de cereais e depois vou construir outros maiores. Então vou guardar todo meu trigo e meus outros bens nos grandes celeiros/armazéns novos. ");
INSERT INTO portft_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Depois vou dizer para mim mesmo, Agora tenho muitas coisas guardadas. Tudo isso vai durar por muitos anos. Então agora vou descansar. Vou beber e comer quanto quiser, e ficar feliz por muito tempo! ");
INSERT INTO portft_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mas Deus disse a ele, “Que homem estúpido! Hoje à noite você vai morrer! Então todos os bens que você guardou para si mesmo vão ser de outro, e não de você! Você acha que vai aproveitar de tudo aquilo que já guardou? ");
INSERT INTO portft_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","então Jesus terminou esta ilustração dizendo, ”É isso que vai acontecer àquele que guarda coisas somente para si mesmo mas que não tem coisas que Deus considera valiosas. ");
INSERT INTO portft_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Então Jesus disse aos seus discípulos, “Então quero dizer isso a vocês: não se preocupem com as coisas de que precisam para viver. Não se preocupem com isso de ter bastante comida para comer. Não cuidem de ter roupas suficientes para usar. ");
INSERT INTO portft_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Porque o viver significa mais do que só ter comida, e os seus corpos são mais importante do que as roupas que usam. ");
INSERT INTO portft_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pensem nos pássaros: eles não plantam semente nem colhem trigo. Eles não têm salas nem armazéns onde guardam as colheitas. Mas Deus providencia comida para eles. À vista de Deus, vocês são muito mais importantes do que os pássaros. Então ele certamente vai providenciar o que vocês precisam! ");
INSERT INTO portft_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Não há ninguém/será que alguém pode acrescentar um pouco à vida dele preocupando-se com isso! ");
INSERT INTO portft_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Esta é coisa pequena para fazer. Então já que não podem fazer isso, certamente vocês não devem/por que é que se preocupam com outras coisas que precisam para viver!  ");
INSERT INTO portft_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pensem em como as flores crescem nos campos. Elas não trabalham para ganhar dinheiro, e não fazem as suas próprias roupas. Mas digo a vocês que mesmo que o Rei Salomão, que vivia muito tempo atrás, vestisse roupas muito lindas, suas roupas não eram tão lindas quanto as flores nos campos. ");
INSERT INTO portft_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Deus faz aquelas flores belas. Mas elas crescem nos campos por pouco tempo. Então alguém as corta quando corta a outra relva/o resto do capim, e as joga no forno para queimá-las para assar pão. Deus vai cuidar de vocês muito mais do que cuida do capim ao cobri-lo de flores bonitas. Então certamente ele vai providenciar roupa para vocês, mesmo que vocês sejam pessoas que não tenham certeza de que ele vá fazer isso! ");
INSERT INTO portft_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Não pensem sempre no que vão ter para comer e no que vão ter para beber, e não se preocupem com estas coisas. ");
INSERT INTO portft_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","As pessoas que não confiam em Deus sempre se preocupam com estas coisas. Mas o seu Pai no céu sabe que vocês precisam destas coisas, por isso vocês não devem se preocupar com elas. ");
INSERT INTO portft_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Em vez disso, cuidem de deixar que ele controle as suas vidas totalmente. Então ele dará a vocês suficiente dessas coisas também. ");
INSERT INTO portft_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Vocês que são meus discípulos são como um rebanho pequeno de ovelhas, e eu sou como seu pastor. Portanto vocês não devem ter medo. O seu Pai no céu deseja permitir que vocês governem com ele no céu. ");
INSERT INTO portft_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Então vendam as coisas que vocês têm/possuem. Deem o dinheiro que recebem dessas coisas para os pobres. Se fizerem isso, vai ser como se providenciassem para si mesmos bolsas que nunca acabam, e Deus vai dar a vocês um tesouro no céu que nunca diminui. Lá nenhum ladrão pode se aproximar para roubá-lo, e nenhum bicho/inseto pode destruí-lo. ");
INSERT INTO portft_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Lembrem-se de que as coisas que vocês consideram mais valiosas para si mesmos serão as coisas em que vocês sempre estarão pensando. ");
INSERT INTO portft_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Sempre estejam preparados para fazerem a obra de Deus, como pessoas que colocam suas roupas de trabalho prontos para servir, com suas lâmpadas acesas a noite toda. ");
INSERT INTO portft_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Estejam prontos para a minha volta, como servos que estão esperando o seu chefe voltar de uma festa de casamento que dura vários dias. Eles estão prontos para abrirem a porta para ele e começarem a trabalhar para ele de novo logo que ele chega e bate à porta. ");
INSERT INTO portft_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Se esses servos estiverem acordados quando ele chegar, ele vai estar muito contente com eles. Vou dizer o seguinte a vocês: ele vai vestir as roupas que os servos usam e dizer a eles para se sentarem para um jantar, e vai servir um jantar para eles. ");
INSERT INTO portft_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mesmo que ele volte entre a meia-noite e o levantar do sol, se ele descobrir que os servos estão acordados e preparados para ele, ele vai estar muito contente com esses servos. ");
INSERT INTO portft_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mas vocês também devem lembrar-se disso: se o dono da casa tivesse sabido a que hora o ladrão ia chegar, ele teria ficado acordado e não teria deixado que o ladrão entrasse na casa e roubasse seus bens. ");
INSERT INTO portft_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Da mesma maneira, vocês também devem estar prontos para a minha volta, porque eu, aquele que vim do céu, vou chegar em uma hora quando vocês não vão estar me esperando.” ");
INSERT INTO portft_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro disse, “Senhor, o senhor está dando esta ilustração para nós ou também para todos os demais. ");
INSERT INTO portft_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","O Senhor respondeu, “Estou dizendo isso para vocês ou para qualquer outro que seja como um gerente sábio e fiel na casa do seu chefe. O chefe dele o escolhe para dirigir os assuntos de sua casa e para dar comida a todos os servos dele na hora certa. Então ele sai em uma longa viagem. ");
INSERT INTO portft_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Se o servo estiver fazendo essas coisas quando o chefe dele voltar, seu chefe vai estar muito contente com ele. ");
INSERT INTO portft_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Vou dizer isto a vocês: o chefe dele vai designá-lo para dirigir todos os negócios dele permanentemente. ");
INSERT INTO portft_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mas aquele servo talvez diga para si mesmo, Meu chefe está fora faz muito tempo, então ele provavelmente não vai voltar logo. Então ele talvez comece a bater nos servos e nas servas. E talvez ele também comece a comer muito e a ficar bêbado. ");
INSERT INTO portft_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Se ele fizer assim, e se o chefe dele voltar em um dia quando ele não o estiver esperando, então o chefe dele vai bater muito nele e vai colocá-lo no lugar onde ele coloca todos aqueles que não o servem fielmente. ");
INSERT INTO portft_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","O chefe vai bater severamente em cada servo que sabe o que seu chefe quer que faça mas que não se apronta e não faz o que o chefe dele deseja. ");
INSERT INTO portft_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mas o chefe vai bater pouco em cada servo que não sabia o que seu chefe queria que fizesse e que fez coisas pelas quais merecia que seu chefe batesse nele. Deus vai tratar o povo dele da mesma forma, porque ele espera muito daqueles a quem ele tem permitido entender muito. As pessoas que dão muitas coisas aos outros para estes cuidarem delas esperam que cuidem bem dessas coisas. Semelhantemente, Deus espera muito daqueles a quem ele tem permitido entender muito. Além disso, ele espera mais daqueles a quem ele tem dado muita habilidade. ");
INSERT INTO portft_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Vim à terra para causar dificuldades MET que vão purificar vocês assim como o fogo purifica metal (OU causar divisões). E como eu queria que o tempo quando Deus vai purificar vocês (OU, causar divisões entre vocês) já tivesse começado. ");
INSERT INTO portft_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Daqui a pouco eu preciso sofrer muito. Estou sentindo grande ansiedade, que vai continuar até o meu sofrimento acabar. ");
INSERT INTO portft_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Vocês acham que porque eu vim à terra as pessoas vão agir pacificamente umas com as outras? Não! Devo dizer a vocês que não é isso que vai acontecer! Pelo contrário, as pessoas vão ser divididas. ");
INSERT INTO portft_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Já que algumas das pessoas em uma casa vão crer em mim e outras não, elas serão divididas. Três pessoas em uma dada casa que creem em mim vão se opor a duas que não creem, ou duas que creem em mim vão se opor a três que não creem. ");
INSERT INTO portft_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Desta forma um homem vai se opor ao seu próprio filho, ou um filho vai se opor ao seu pai. Uma mulher vai se opor à sua filha ou uma mulher vai se opor à sua mãe. Uma mulher vai se opor à sua nora ou uma mulher vai se opor à sua sogra. ");
INSERT INTO portft_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ele também disse à multidão, “Neste país, quando vocês veem formar uma nuvem escura no oeste, vocês dizem imediatamente, Vai chover, e é isso que acontece. ");
INSERT INTO portft_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nesta região quando o vento sopra do sul, vocês dizem, Vai ser um dia muito quente! E é justamente isso que acontece. ");
INSERT INTO portft_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Vocês hipócritas! Vocês podem discernir como o tempo vai mudar/se vai chover ou não, prestando atenção às nuvens e ao vento. Por que é que vocês não/é frustrante que não podem discernir o que Deus está fazendo no tempo presente/atual! ");
INSERT INTO portft_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Cada um de vocês deve/por que não pode determinar qual a coisa certa para você fazer agora quando ainda tem tempo para fazer! ");
INSERT INTO portft_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Se não fizer isso, Deus vai castigar você. Vai ser como aquilo que acontece quando alguém leva um de vocês à justiça dizendo que tem feito algo muito mau. Você deve tentar entrar em um acordo/fazer as pazes com ele quando ainda está no caminho para a justiça. Pois se ele forçar você a ir à justiça, o juiz vai resolver que você está culpado e vai colocá-lo nas mãos do oficial da corte. Aí o oficial vai colocar você na prisão. ");
INSERT INTO portft_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Digo a vocês que se isso acontecer, certamente você nunca vai deixar a prisão porque nunca vai poder pagar tudo quanto o juiz diz que deve. ");
INSERT INTO portft_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Certas pessoas que estavam ouvindo Jesus naquele momento falaram a ele sobre algumas pessoas do distrito da Galileia. Pilatos, o governador romano, tinha mandado os soldados matá-los enquanto eles estavam oferecendo sacrifícios no templo em Jerusalém.  ");
INSERT INTO portft_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus respondeu a eles, “Vocês acham que isso aconteceu a essas pessoas da Galileia porque elas pecavam mais do que quaisquer outras pessoas da Galileia? ");
INSERT INTO portft_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Digo certamente a vocês que não foi assim! Mas ao invés de estarem preocupados com eles, vocês precisam lembrar- se de que de modo semelhante Deus vai castigar vocês eternamente se vocês não deixarem os seus pecados. ");
INSERT INTO portft_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ou, considerem as dezoito pessoas que morreram quando a torre de Siloé fora de Jerusalém caiu sobre eles. Vocês acham que isso aconteceu com eles porque pecavam mais do que quaisquer outros que moravam em Jerusalém? ");
INSERT INTO portft_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Digo certamente a vocês, não foi assim! Mas ao invés disso, vocês precisam saber que de modo semelhante Deus vai castigar vocês eternamente se vocês não abandonarem suas vidas de pecado. ");
INSERT INTO portft_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Então Jesus deu a eles esta ilustração para mostrar como Deus ia tratar os judeus/aqueles que ele abençoava continuamente mas que não faziam coisas que agradavam a ele: “Um homem plantou uma figueira/fruteira na sua vinha/roça. Cada ano/muitas vezes, ele chegou a ela procurando figos, mas não havia figos. ");
INSERT INTO portft_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Então ele disse ao homem que cuidava das videiras, Olhe! Faz três anos que procuro figos nesta figueira, mas não tem figos. Derrube-a! Ela apenas está usando/por que é que deve usar os nutrientes no solo sem produzir nada. ");
INSERT INTO portft_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mas o homem disse ao dono, Senhor, deixe-a mais um ano. Vou cavar ao redor dela e colocar estrume. ");
INSERT INTO portft_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Se der fruto no ano que vem, vamos (inc) deixá-la. Se não der fruto no ano que vem, o senhor pode derrubá-la.” ");
INSERT INTO portft_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Certo dia de sábado, Jesus estava ensinando as pessoas em uma das sinagogas. ");
INSERT INTO portft_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Havia ali uma mulher que um Espírito maligno tinha molestado fazia dezoito anos. Ela andava sempre encurvada; não podia ficar reta. ");
INSERT INTO portft_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Quando Jesus a viu, ele a chamou para si. Ele disse a ela, “Senhora, estou livrando-a da sua doença!” ");
INSERT INTO portft_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ele pôs as mãos nela. Logo ela levantou-se e ficou reta, e ela louvou a Deus. ");
INSERT INTO portft_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mas o líder da sinagoga estava zangado porque Jesus a tinha curado no dia do sábado. Ele considerava que curar significava fazer trabalho. Por isso ele disse às pessoas, “Há seis dias na semana em que as nossas leis judaicas permitem que as pessoas trabalhem. Se estão doentes, são estes os dias para vir à sinagoga e pedir para alguém curá-los. Não venham no dia do sábado!” ");
INSERT INTO portft_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aí o Senhor disse a ele, “Seus hipócritas! No dia do sábado, como em todos os outros dias, cada um de vocês desamarra/vocês não desamarram seu jumento ou seu boi, e então o guia da estrebaria/do lugar onde come até onde pode beber água. Isso também é trabalho! ");
INSERT INTO portft_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Esta mulher é mais importante do que um animal, é judia, descendente de Abraão! Mas Satanás a tem prendido na doença por dezoito anos, como se ele a tivesse amarrado para não deixá-la escapar. Então é justo que/não é justo que eu a liberte, mesmo que seja este o sábado!” ");
INSERT INTO portft_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Depois dele dizer isso, todas as pessoas ali que eram contrárias a ele ficaram com vergonha. Mas todas as outras pessoas ali estavam alegres com todas as coisas maravilhosas que ele estava fazendo. ");
INSERT INTO portft_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Então ele disse a eles, “Deixe-me dizer a vocês/vocês sabem como é que vai aumentar o número das pessoas que permitem que Deus domine suas vidas. Vou dizer a vocês uma comparação a esse respeito. ");
INSERT INTO portft_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","É como uma semente pequena/um grão de mostarda que um homem plantou na sua horta. Cresceu até ficar grande, como uma árvore. Era tão grande que os pássaros fizeram ninhos nos seus galhos. ");
INSERT INTO portft_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Aí ele disse, “Vou dizer a vocês outra coisa para ilustrar como é que as pessoas que deixam Deus governar as suas vidas podem influenciar a sociedade delas cada vez mais. ");
INSERT INTO portft_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","É como um pouquinho de fermento que uma mulher pegou e misturou com mais ou menos 25 quilos de farinha de trigo. Esse pouquinho de fermento fez toda a massa crescer/tufar. Lucas 13.22-30 (Mat. 7.13-14, 21-23) ");
INSERT INTO portft_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus continuou a viajar com os discípulos por várias cidades e aldeias, em caminho para Jerusalém. Ao caminharem, ele ensinava as pessoas. ");
INSERT INTO portft_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Alguém perguntou a ele, “Senhor, serão poucos os que Deus vai salvar?” Ele respondeu a eles, “Não serão muitos, porque o caminho para o céu é como uma porta estreita. ");
INSERT INTO portft_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Portanto, esforcem-se muito para entrarem por aquela porta estreita, porque vou dizer a vocês que muitos vão tentar entrar no céu por algum outro caminho, mas não vão poder fazer isso. ");
INSERT INTO portft_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Deus é como o dono de uma casa. À noitinha ele vai trancar a porta. Aí alguns de vocês vão começar a ficar do lado de fora da porta e bater. Vocês vão dizer, Senhor, abra a porta para nós! Mas ele vai responder, Não, porque não conheço vocês nem sei de onde são. ");
INSERT INTO portft_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Aí vocês vão dizer, O Senhor deve ter esquecido/será que o senhor já se esqueceu! Nós (excl) comemos com o senhor, e o senhor ensinou as pessoas nas ruas de nossas cidades! ");
INSERT INTO portft_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mas ele vai dizer, Vou dizer a vocês outra vez, não os conheço nem sei de onde são. Vocês são pessoas más! Saiam daqui! ");
INSERT INTO portft_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Do lugar aonde vou mandar vocês, vocês vão ver na distância Abraão, Isaque e Jacó. Todos os profetas que viviam muito tempo atrás também vão estar ali, no lugar onde Deus governa. Mas vocês estarão fora, chorando e rangendo os dentes por causa da dor!  ");
INSERT INTO portft_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Além disso, muitos não judeus vão estar ali. Serão pessoas que terão chegado das terras ao norte, a leste, ao sul e a oeste. Vão estar festejando no lugar onde Deus governa. ");
INSERT INTO portft_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Notem isto: alguns que as pessoas não consideram importantes agora, Deus naquela época vai considerar muito importantes, e algumas pessoas que os outros consideram muito importantes agora, naquela época Deus vai considerar de pouca importância. ");
INSERT INTO portft_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Naquele mesmo tempo alguns fariseus chegaram e disseram a Jesus, “Saia desta área, porque o chefe Herodes Antipas quer matar o senhor.” ");
INSERT INTO portft_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus respondeu a eles, “Herodes é tão esperto/cruel mas tão insignificante quanto uma raposa. Por isso eu não me preocupo com ele. Mas para mostrar a ele que ninguém me pode fazer mal até o tempo e o lugar determinados,vão dizer o seguinte a ele: Ouça, estou expulsando demônios e fazendo milagres hoje e vou continuar a fazer isso por mais um pouco. Depois disso, vou terminar meu trabalho. ");
INSERT INTO portft_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mas preciso continuar a minha viagem a Jerusalém nos dias seguintes, porque nenhum outro lugar é apropriado para eles me matarem assim como mataram os outros profetas.” ");
INSERT INTO portft_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Então Jesus disse, “Oh, povo de Jerusalém! São pessoas de sua cidade que mataram os profetas que viviam muito tempo atrás! Outros que Deus mandou a vocês, vocês mataram jogando pedras neles! Muitas vezes eu queria juntar vocês para protegê-los, assim como uma galinha junta os pintinhos dela debaixo de suas asas. Mas vocês não me deixaram fazer isso. ");
INSERT INTO portft_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Portanto ouçam isso: Deus vai abandonar/já não vai proteger mais a sua cidade (OU, seu templo). Também vou dizer isto a vocês: vou entrar na sua cidade só mais uma vez. Depois disso, vocês não vão me ver mais até o tempo quando eu voltar e vocês disserem de mim, Deus realmente tem abençoado este homem que vem com a autoridade de Deus! ");
INSERT INTO portft_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Certo dia de sábado, Jesus foi comer na casa de um fariseu importante. Os homens que estudavam as leis judaicas e outros fariseus que estavam ali estavam observando-o para ver se ele faria algo de que eles pudessem acusá-lo. ");
INSERT INTO portft_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Inesperadamente, apareceu um homem na frente de Jesus cujos braços e pernas estavam inchados. ");
INSERT INTO portft_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesus disse a eles, “Permite-se ou não na nossa (inc) lei judaica que se cure alguém no dia de sábado?” ");
INSERT INTO portft_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Eles sabiam que a lei deles permitia isso, mas pensavam que curar era trabalho, que consideravam errado fazer no sábado (OU, mas não queriam admitir isso). Por isso eles não responderam. Então Jesus pôs as mãos no homem e o curou. Depois ele lhe disse para ir para casa. ");
INSERT INTO portft_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Então ele disse aos outros, “Se vocês tivessem um boi ou um filho que caísse no poço no dia de sábado, vocês logo fariam o trabalho de tirá-lo, ou você o deixaria ficar ali até o dia seguinte?” ");
INSERT INTO portft_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Eles não podiam discordar desse argumento, então não disseram nada. ");
INSERT INTO portft_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesus observou que as pessoas que o fariseu tinha convidado ao jantar optaram por sentar nos lugares onde as pessoas mais importantes se sentam. Aí ele deu a eles este conselho: ");
INSERT INTO portft_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Quando alguém convidar um de vocês a uma festa de casamento, não se sente em um lugar onde as pessoas importantes se sentam. Talvez aquele que está dando a festa tem convidado um homem mais importante do que você. ");
INSERT INTO portft_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Quando aquele homem chegar, aquele que convidou vocês dois virá a você e dirá a você, Deixe esse homem tomar este lugar. Aí você vai ter que sentar em um lugar que é o menos desejável, e você vai sentir vergonha. ");
INSERT INTO portft_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pelo contrário, quando alguém convidar um de vocês a uma festa, vá sentar-se no pior lugar. Então quando aquele que convidou a todos vier, ele vai dizer a você, Amigo, sente-se em um lugar melhor! Então todos os que estiverem jantando com você vão ver que ele está honrando você. ");
INSERT INTO portft_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Lembrem- se também disso: Deus vai humilhar a cada pessoa que se exalta a si mesmo. E ele vai levantar cada um que se humilha. ");
INSERT INTO portft_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesus também disse ao fariseu que o tinha convidado ao jantar, “Quando o senhor convidar pessoas para o almoço ou para o jantar, não convide seus amigos nem sua família nem outros parentes nem seus vizinhos ricos. Pois eles mais tarde podem convidar você para um jantar. Desta forma eles vão repagar/devolver a você. ");
INSERT INTO portft_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pelo contrário, quando você der uma festa, convide as pessoas pobres, os coxos, os aleijados ou as pessoas cegas. Então Deus vai abençoar você, porque  ");
INSERT INTO portft_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","eles não vão poder devolver nada a você. Deus vai repagar/recompensar você naquele tempo quando ele fizer com que os justos vivam de novo. ");
INSERT INTO portft_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Um daqueles que estava comendo com ele o ouviu dizer isso. Ele disse a Jesus, “Deus realmente tem abençoado a nós judeus que vamos comer com o Messias quando ele começar a governar! ");
INSERT INTO portft_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mas para mostrar que muitos dos judeus que Deus tinha convidado não iam aceitar o convite de Deus, Jesus respondeu a ele, “Uma vez certo homem estava para dar um grande banquete. Ele convidou muitas pessoas a comparecerem/irem. ");
INSERT INTO portft_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Quando chegou o dia do banquete, ele mandou o seu servo para dizer àqueles que ele tinha convidado, Venham agora porque tudo está pronto! ");
INSERT INTO portft_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mas quando o servo fez isso, todos aqueles que ele tinha convidado começaram a dizer as razões por que eles não podiam ir. O primeiro homem a quem o servo foi disse, Eu acabo de comprar um campo. Preciso ir até lá para vê-lo. Faça o favor de pedir ao seu chefe que ele me perdoe por não comparecer. ");
INSERT INTO portft_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Outra pessoa disse, Eu acabo de comprar cinco pares de bois. Preciso ir examiná-los. Faça o favor de pedir ao seu chefe que ele me perdoe por não ir. ");
INSERT INTO portft_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Outra pessoa disse, acabo de me casar. Por isso não posso ir. ");
INSERT INTO portft_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Então o servo voltou ao seu chefe e relatou a ele o que cada um tinha dito. O dono da casa estava zangado porque as razões que eles deram por não irem eram ridículas. Ele disse ao seu servo, Vá rápido às ruas e becos/passagens da cidade e procure pessoas pobres e coxas e cegas e aleijadas, e traga-as para minha casa! ");
INSERT INTO portft_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Depois do servo ir fazer isso, ele voltou e disse, Senhor, já fiz o que o senhor me mandou, mas ainda há espaço para mais pessoas. ");
INSERT INTO portft_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Aí o chefe dele lhe disse, Então saia da cidade. Procure pessoas ao lado das estradas, e procure nas estradas estreitas com mato pelos lados onde pode haver pessoas que não têm casas. Insista muito com as pessoas nesses lugares para que venham à minha casa. Quero que ela esteja cheia de pessoas!” ");
INSERT INTO portft_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Então Jesus disse, Digo isto para vocês: poucos dos judeus, que primeiro convidei, para comer o banquete comigo quando eu me tornar rei, vão estar ali para provar/gostar dele.” ");
INSERT INTO portft_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Grupos grandes de pessoas estavam viajando com Jesus. Ele voltou-se e disse a eles, ");
INSERT INTO portft_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Se alguém que vem a mim amar seu pai e sua mãe e sua esposa e seus filhos e seus irmãos e suas irmãs mas do que me amar, ele não pode ser meu discípulo. Sim, ele precisa amar mais a mim do que ama sua própria vida! ");
INSERT INTO portft_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aqueles que estão prontos para executar presos os fazem carregar sua cruz e depois os matam em cima dela. Aquele que não está disposto a deixar que os outros o façam mal e o causem vergonha assim e que não está disposto a obedecer meus ensinamentos, não pode ser meu discípulo. ");
INSERT INTO portft_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Vou ilustrar. Se um de vocês desejasse construir uma torre/casa grande, ele certamente se sentaria primeiro para calcular quanto custaria! Depois ele ia resolver se tinha ou não o dinheiro suficiente para terminá-la. ");
INSERT INTO portft_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Se ele não fizesse isso, se construísse os alicerces mas não pudesse terminar o resto da torre, todos os que vissem isso iriam zombar-se dele. ");
INSERT INTO portft_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Eles iam dizer, Este homem começou a construir uma torre mas não pôde completá-la! ");
INSERT INTO portft_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ou, se um rei resolvesse mandar seu exército em guerra contra outro rei, certamente ele primeiro se sentaria com seus conselheiros/aqueles que lhe davam conselho. Eles iriam determinar se o exército dele, que tinha somente dez mil soldados, seria capaz de derrotar o outro exército, que tinha vinte mil soldados, e estava pronto para atacar o exército dele. ");
INSERT INTO portft_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Se ele resolvesse que não era capaz de derrotar aquele exército, quando ainda estava bem longe, ele ia enviar mensageiros para perguntar ao outro rei quais as coisas que ele precisava fazer para ter paz. ");
INSERT INTO portft_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Portanto, da mesma forma, se qualquer um de vocês não resolver primeiro que está disposto a  ceder tudo quanto tem, você não pode ser meu discípulo. ");
INSERT INTO portft_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Vocês são como sal, que é útil para colocar na comida. Mas certamente não é possível/será que é possível fazer com que ele ganhe de novo seu sabor se ele já perdeu seu sabor! ");
INSERT INTO portft_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Se isso acontece, ele não é bom nem para o solo nem para o estrume. As pessoas jogam fora. A mesma coisa vai acontecer a vocês se vocês se tornarem inúteis para Deus. Se quiserem entender bem o que acabo de dizer, considerem com cuidado o que têm ouvido! ");
INSERT INTO portft_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Os cobradores de impostos e outros que as pessoas achavam ser sempre pecadores continuavam a ir a ele para ouvir seus ensinamentos. ");
INSERT INTO portft_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Os fariseus e os homens ali que ensinavam as leis judaicas começaram a queixar-se, dizendo, “Este homem recebe pecadores e ele também se suja ao comer com eles. ");
INSERT INTO portft_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Por isso ele disse a eles esta parábola: ");
INSERT INTO portft_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Vamos supôr que um de vocês tem cem ovelhas. Se uma delas estivesse perdida, você certamente deixaria os noventa e nove no pasto, e iria procurar aquela ovelha perdida até achá-la. ");
INSERT INTO portft_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Quando você a achasse, você a colocaria nos ombros e ficaria feliz. ");
INSERT INTO portft_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Quando você a levasse para casa, você iria reunir seus amigos e vizinhos e diria a eles, Estejam contentes comigo, porque eu achei a minha ovelha que estava perdida! ");
INSERT INTO portft_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Da mesma forma, digo a vocês que Deus se alegrará muito com um pecador que deixa de fazer o mal. Ele não precisa estar feliz por causa de noventa e nove pessoas que pensam que são justas e pensam que não precisam deixar de fazer o mal. ");
INSERT INTO portft_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ou, vamos imaginar que uma mulher tem dez moedas de prata muito valiosas. Se ela perder uma delas, certamente ela vai acender uma lâmpada e varrer o chão e procurar com cuidado até achá-la. ");
INSERT INTO portft_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Quando ela a achar, ela vai chamar seus amigos e vizinhos e dizer a eles, Estejam contentes comigo, porque já achei a moeda que perdi! ");
INSERT INTO portft_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Da mesma maneira, digo a vocês que os anjos vão estar muito alegres por um só pecador que deixa de fazer o mal.” ");
INSERT INTO portft_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Então ele contou a eles esta parábola para comparar o que os fariseus e os professores da lei judaica pensavam daqueles que pecam com o que Deus pensava de tais pessoas. Ele disse, “Certo homem tinha dois filhos. ");
INSERT INTO portft_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Um dia o filho mais jovem disse ao seu pai, Pai, não quero esperar até o senhor morrer. Dê-me agora a parte de sua propriedade que me pertence! ");
INSERT INTO portft_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Poucos dias depois, o filho menor vendeu a sua parte. Juntou o seu dinheiro e as suas outras coisas e saiu para um país bem distante. Lá ele gastou todo seu dinheiro à toa vivendo de modo incorreto. ");
INSERT INTO portft_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Depois dele ter gasto todo seu dinheiro, houve uma fome por todo aquele país. E ele começou a estar sem comida. ");
INSERT INTO portft_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Então ele foi a um dos proprietários naquela região e pediu trabalho. O homem o mandou trabalhar cuidando dos porcos no seu campo. ");
INSERT INTO portft_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Porque ele estava com muita fome/não tinha mais nada para comer, queria comer as cascas de feijão que os porcos comiam. Mas ninguém dava nada a ele. ");
INSERT INTO portft_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Em fim ele pensou com clareza no que tinha feito. Ele disse para si mesmo, Todos os servos do meu pai que ele emprega têm bastante comida. Eles têm mais do que podem comer, mas aqui eu estou morrendo de fome! ");
INSERT INTO portft_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Então vou sair daqui e voltar para meu pai. Vou dizer a ele, Pai, tenho pecado contra Deus MTY/EUP e contra o senhor. ");
INSERT INTO portft_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Já não sou mais digno do senhor me chamar de seu filho. Empregue-me assim como um dos servos que o senhor emprega. ");
INSERT INTO portft_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aí ele saiu de lá e voltou à casa do seu pai. Mas quando ele ainda estava bem distante da casa, o pai dele o viu. Ele tinha pena dele. Ele correu para seu filho e o abraçou e o beijou na face. ");
INSERT INTO portft_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Seu filho disse a ele, Pai, tenho pecado contra Deus MTY/EUP e contra o senhor. Já não sou mais digno do senhor me chamar do seu filho. ");
INSERT INTO portft_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mas o pai dele disse aos seus servos, Vão rápido e me tragam a melhor roupa na casa! Então coloca-a no meu filho. Ponham um anel no dedo dele para mostrar que estou honrando-o outra vez como meu filho. Ponham sandálias nos seus pés para mostrar que não o considero como escravo! ");
INSERT INTO portft_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Então tragam o bezerro gordo e matem-no e assem-no! Nós (inc) devemos comer e estar alegres/festejar, ");
INSERT INTO portft_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","porque este é o meu filho! É como se estivesse morto e já está vivo outra vez. É como se estivesse perdido e agora alguém o achou! Então fizeram isso, e todos começaram a festejar. ");
INSERT INTO portft_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Enquanto isso estava acontecendo, o filho mais velho estava fora trabalhando na roça. Quando ele chegou perto da casa, ele ouviu pessoas tocando música e dançando. ");
INSERT INTO portft_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ele chamou um dos servos e perguntou o que estava acontecendo. ");
INSERT INTO portft_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","O servo disse a ele, Seu irmão mais novo já voltou para casa! O pai de você nos disse para matar o bezerro gordo para festejar, porque ele voltou são e salvo. ");
INSERT INTO portft_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mas o irmão mais velho estava zangado. Ele recusou entrar na casa. Então o pai saiu e insistiu com ele para que entrasse. ");
INSERT INTO portft_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","mas ele respondeu ao seu pai, Ouça! Faz muitos anos que trabalho para o senhor como um escravo. Eu sempre obedeci tudo que o senhor me mandou fazer. Mas o senhor nunca me deu nem um cabrito, para que eu pudesse matar e cozinhar e festejar com meus amigos. ");
INSERT INTO portft_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mas esse filho seu gastou todo o dinheiro que recebeu daquilo que o senhor deu a ele. Ele o gastou para pagar por dormir com prostitutas! Agora ele já voltou para casa, mas não é justo que os servos do senhor tenham matado o bezerro gordo e o tenham cozinhado para ele! ");
INSERT INTO portft_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mas o pai dele lhe disse, Meu filho, você sempre tem estado comigo, e toda a minha propriedade que eu não dei ao irmão de você é seu/de você. ");
INSERT INTO portft_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","mas é como se seu irmão estivesse morto e é vivo de novo! É como se ele estivesse perdido e alguém já o achou! Portanto, é apropriado que nós estejamos felizes e festejemos! ");
INSERT INTO portft_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus também disse aos discípulos dele, “Havia um homem rico que tinha um administrador de casa. Certo dia alguém disse a ele que o administrador estava manejando mal o dinheiro do homem rico. ");
INSERT INTO portft_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Então ele chamou o administrador e disse a ele, É terrível/é a verdade o que eles dizem a respeito do senhor! Dê para mim um relato dos fundos que o senhor está dirigindo, porque o senhor não pode ser mais o administrador da minha casa. ");
INSERT INTO portft_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","aí o administrador disse para si mesmo, Meu senhor está para me despedir, então não sei o que/o que é que vou fazer. Pois não sou bastante forte para trabalhar cavando valas e tenho vergonha demais para pedir dinheiro. ");
INSERT INTO portft_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","De repente ele teve uma ideia. Já sei o que farei, para que as pessoas me recebam nas suas casas e providenciem para mim depois do meu chefe me despedir! ");
INSERT INTO portft_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Então um por um ele chamou as pessoas que deviam dinheiro ao seu chefe. Ele perguntou ao primeiro, Quanto é que deve para meu chefe? ");
INSERT INTO portft_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","O homem respondeu, 800 barris de azeite de oliva. O administrador disse a ele, Tome as sua conta e sente-se e mude logo para 400 barris! ");
INSERT INTO portft_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ele disse a outro homem, Quanto é que o senhor deve? O homem respondeu, mil medidas de trigo. O administrador disse a ele, Tome a sua conta e mude esta figura para oitocentas medidas! Ele fez coisas semelhantes aos outros que deviam dinheiro ao seu chefe.  ");
INSERT INTO portft_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Quando o chefe soube do que o administrador dele tinha feito, ele admirava o administrador desonesto pela coisa esperta que tinha feito. A verdade é/isso mostrou que as pessoas que não seguem a Deus neste mundo agem com mais esperteza para com os outros do que as pessoas que seguem a Deus. ");
INSERT INTO portft_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Então digo isto a vocês: usem o dinheiro que têm para ajudar aos outros para que eles se tornem seus amigos. Então quando morrerem e não puderem levar nenhum dinheiro consigo, seus amigos vão receber vocês em uma morada no céu que dura para sempre. ");
INSERT INTO portft_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Aqueles que manejam fielmente as coisas pequenas vão manejar fielmente as coisas/os assuntos importantes. Aqueles que são desonestos na sua maneira de manejar os assuntos pequenos vão ser desonestos na sua maneira de tratar de assuntos importantes. ");
INSERT INTO portft_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Então se vocês não tiverem manejado fielmente o dinheiro que Deus lhes tem dado aqui na terra, ele certamente não vai/como é que ele vai deixar vocês possuírem as verdadeiras riquezas espirituais no céu! ");
INSERT INTO portft_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","E se não tiverem manejado fielmente as coisas que são de outras pessoas, Deus certamente não vai/como é que Deus vai deixar vocês receberem tesouros no céu que vão pertencer a vocês! ");
INSERT INTO portft_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nenhum servo pode servir igualmente a dois chefes. Pois se tentasse fazer isso, ele iria desprezar e odiar um deles e amar e ser devotado ao outro. Da mesma maneira, não se pode devotar a sua vida à veneração a Deus e à veneração ao dinheiro ao mesmo tempo.” ");
INSERT INTO portft_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Havia ali alguns fariseus. Eles adoravam amassar dinheiro. Quando ouviram Jesus dizer isso, eles se zombaram dele. ");
INSERT INTO portft_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mas ele disse a eles, “Vocês tentam fazer com que os outros pensem que são justos, mas Deus conhece seus seres interiores/corações. Portanto ele vai rejeitar vocês. Guardem em mente que muitas coisas que as pessoas acham boas/estimam muito, Deus acha que são detestáveis. ");
INSERT INTO portft_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","As leis que Deus deu a Moisés e aquilo que escreveram os profetas governavam até que chegou João o batizador. Desde então eu tenho pregado como Deus quer governar as vidas das pessoas de maneira nova, e muitas pessoas estão aceitando essa mensagem e estão pedindo com grande desejo que Deus tome o controle das suas vidas. Mas isso não quer dizer que Deus tenha colocado de lado as leis que ele antes estabeleceu. ");
INSERT INTO portft_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Todas as leis de Deus, até mesmo aqueles que parecem insignificantes, são mais permanentes do que a terra e o céu. ");
INSERT INTO portft_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Por exemplo, já que Deus considera que o casamento dura/é válido até que morra ou o esposo ou a esposa, ele considera que qualquer um que se divorcie de sua esposa e se case com outra mulher esteja cometendo adultério, e que qualquer um que se case com uma mulher cujo esposo tenha se divorciado dela também esteja cometendo adultério.” ");
INSERT INTO portft_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesus também disse, “havia um homem rico que vestia roupas caras de linho, cor de roxo. Ele comia luxuosamente todos os dias. ");
INSERT INTO portft_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Também todos os dias algumas pessoas deitaram um homem pobre chamado Lázaro no portão da casa do rico. O corpo de Lázaro estava coberto de feridas. ");
INSERT INTO portft_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ele tinha tanta fome que desejava comer os restos de comida que caíam da mesa onde comia o homem rico. Além disso, o que era ainda pior, os cachorros chegavam e lambiam as feridas do pobre. ");
INSERT INTO portft_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Finalmente o pobre morreu. Então os anjos o levaram para começar a festejar perto de Abraão, seu grande antepassado. O rico também morreu, e umas pessoas enterraram o corpo dele. ");
INSERT INTO portft_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","No lugar onde as pessoas mortas esperam até Deus julgá-las, ele estava sofrendo muita dor. Ele olhou para cima e viu Abraão à distância, e viu Lázaro sentado perto de Abraão. ");
INSERT INTO portft_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Então ele gritou, Pai Abraão, estou sofrendo muito nestas chamas! Portanto, por favor tenha pena de mim, e envie Lázaro para cá para que ele possa meter o seu dedo em água e tocar na minha língua para refrescá-la! ");
INSERT INTO portft_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mas Abraão respondeu, Filho, lembre-se de que quando você ainda estava vivo na terra, você gozava muitas coisas boas. Mas Lázaro estava na miséria. Agora é justo que ele esteja feliz aqui, e que você sofra. ");
INSERT INTO portft_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Além disso, há um grande vale entre você e nós. Como resultado, aqueles que querem ir daqui até onde você está, não podem. Além disso, ninguém pode cruzar de onde você está até onde nós (excl) estamos. ");
INSERT INTO portft_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Então o rico disse, Neste caso, pai Abraão, peço que o senhor mande Lázaro até a casa do meu pai. ");
INSERT INTO portft_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tenho cinco irmãos que vivem ali. Diga a ele para aconselhá-los que abandonem seus maus caminhos para que eles também não venham a este lugar, onde as pessoas sofrem muitíssima dor! ");
INSERT INTO portft_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mas Abraão respondeu, Não, seus irmãos podem ir às sinagogas onde os sacerdotes leem o que Moisés e os profetas escreveram. Deixe-os ligar para o que disseram Moisés e os profetas! ");
INSERT INTO portft_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mas o rico respondeu, Não, pai Abraão, isso não vai ser suficiente! Mas se alguém daqueles que já morreram voltar e falar com eles, eles vão abandonar as suas vidas de pecado. ");
INSERT INTO portft_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraão disse a ele, Não! Se eles não ouvirem/escutarem as palavras que Moisés e os profetas escreveram, mesmo que alguém fosse ressuscitar dos mortos e fosse adverti-los, ele não poderia convencê-los de abandonarem suas vidas de pecado. ");
INSERT INTO portft_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Certo dia Jesus disse aos seus discípulos, “Coisas que tentam as pessoas a pecarem certamente vão acontecer, mas ai de/será terrível para qualquer um que faça essas coisas acontecerem! ");
INSERT INTO portft_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vamos imaginar que alguém faz pecar um desses que não crê em mim com muita firmeza. Se prendessem uma pedra enorme no pescoço de tal pessoa e a jogasse no mar, esse seria um castigo severo, mas Deus vai castigar essa pessoa ainda mais severamente. ");
INSERT INTO portft_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tenham cuidado de como agem. Se um de vocês tiver um irmão crente que pecar, você deve repreendê-lo. Se ele disser que se arrepende de ter pecado e se pedir para você perdoá-lo, perdoe-o. ");
INSERT INTO portft_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mesmo que ele peque contra você sete vezes em um dia, se ele for a você cada vez e disser, Arrependo-me do que fiz, você precisa continuar a perdoá-lo. ");
INSERT INTO portft_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Um dia os apóstolos disseram ao Senhor, “Ajude-nos a confiar no senhor/em Deus com mais firmeza! ");
INSERT INTO portft_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","O Senhor respondeu, “Uma semente de mostarda é pequena, mas é capaz de produzir uma planta bem grande. De modo semelhante, se vocês realmente crerem que Deus vai fazer o que pedirem, vocês podem realizar grandes coisas. Por exemplo, vocês poderiam dizer a esta figueira brava, Arranque-se pelas raízes e plante-se no mar!, e ela os obedeceria. ");
INSERT INTO portft_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesus também disse, “Vamos imaginar que um de vocês tem um servo que trabalha na sua lavoura ou que cuida de suas ovelhas. Quando ele entra na casa depois de estar na roça, você não vai dizer/será que você diria, Sente-se logo e coma! ");
INSERT INTO portft_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Em vez disso, você diria a ele, Ponha seu avental e prepare uma refeição para mim! Então sirva para mim para que eu possa comer e beber. Depois, você pode comer e beber. ");
INSERT INTO portft_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Você não vai agradecer/será que você vai agradecer o seu servo/empregado por ter feito o trabalho que você lhe pediu para fazer! ");
INSERT INTO portft_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","De modo semelhante, quando vocês tiverem feito tudo que Deus pede a vocês que façam, vocês devem dizer, nós (inc) Não somos dignos de Deus nos agradecer. Somos apenas os servos/empregados dele. Temos feito somente as coisas que ele nos disse para fazermos. ");
INSERT INTO portft_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Enquanto Jesus e seus discípulos estavam andando pelo caminho para Jerusalém, passavam pela região entre os distritos de Samaria e Galileia. ");
INSERT INTO portft_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Quando entravam em uma aldeia/um povoado, dez leprosos chegaram perto da estrada. Porque os leprosos não podiam aproximar-se das pessoas, ficaram a uma distância ");
INSERT INTO portft_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","e disseram, “Jesus, mestre, tenha pena de nós e nos cure!” ");
INSERT INTO portft_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Quando ele os viu, disse a eles, “Vão mostrar-se aos sacerdotes para que eles possam ver se estão curados.” Enquanto iam para os sacerdotes, foram curados. ");
INSERT INTO portft_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aí um deles, quando viu que estava curado, voltou-se para trás, louvando a Deus em voz bem alta. ");
INSERT INTO portft_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ele foi a Jesus, prostrou-se/ajoelhou-se aos pés de Jesus, e o agradeceu. Este homem era samaritano, não judeu. ");
INSERT INTO portft_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Então Jesus disse, “Eu curei dez leprosos! Estou triste/desapontado que os outros nove não tenham voltado/onde estão os outros nove? ");
INSERT INTO portft_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Estou triste/por que será que este homem não judaico é o único que voltou para agradecer a Deus; nenhum dos outros voltou para mim!” ");
INSERT INTO portft_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Então ele disse ao homem, “Levante-se e continue na sua viagem. Deus salvou e curou você porque você confiou em mim. ");
INSERT INTO portft_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Certo dia alguns fariseus perguntaram a Jesus, “Quando é que Deus vai governar como Rei?” Ele respondeu, “A maneira de Deus governar não é algo que as pessoas vão poder ver com seus olhos. ");
INSERT INTO portft_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","E as pessoas não vão poder dizer, Olhem!Ele está governando aqui! Ou, Ele está governando ali! Porque, em vez de ser como vocês pensam, o governo/domínio de Deus está nos seres interiores das pessoas (OU, já está acontecendo entre vocês).” ");
INSERT INTO portft_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesus disse aos seus discípulos, Vai chegar o tempo quando vocês vão querer ver a mim, que cheguei do céu, governando poderosamente. Mas não vão ver isso. ");
INSERT INTO portft_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Algumas pessoas vão dizer a vocês, Olhem, o Messias está ali! Ou vão dizer, Olhem, está aqui! Quando disserem isso, não creiam nelas! Não as sigam para irem ver o Messias. ");
INSERT INTO portft_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Porque quando brilha um relâmpago e ilumina o céu de uma ponta para a outra, todos podem ver. Da mesma forma, quando eu, que vim do céu, voltar de novo, todos vão poder me ver. ");
INSERT INTO portft_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mas antes disso acontecer, preciso sofrer de muitas maneiras (OU, muito). E as pessoas vão me rejeitar, mesmo que tenham observado meu ministério. ");
INSERT INTO portft_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mas quando eu, que vim do céu, vier de novo, a vida vai ser conforme era quando vivia Noé. ");
INSERT INTO portft_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Naquela época as pessoas comiam e bebiam como sempre, casavam-se como sempre, até o dia quando Noé e sua família entraram no barco grande. Então chegou o dilúvio e destruiu todos aqueles que não entraram no barco. ");
INSERT INTO portft_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Da mesma forma, quando Ló vivia em Sodoma, as pessoas ali comiam e bebiam como de costume. Compravam coisas e vendiam coisas. Plantavam roças e construíam casas como sempre. ");
INSERT INTO portft_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mas no dia quando Ló e sua família saíram de Sodoma, fogo e enxofre ardente desceu do céu e destruiu todos que ficaram na cidade. ");
INSERT INTO portft_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Vai ser igual quando eu, que vim do céu, voltar. ");
INSERT INTO portft_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Naquele dia, se alguém estiver fora da sua casa e todas as coisas que pertencerem a ele estiverem dentro da casa, não deve entrar na casa para tirá-las porque não haverá tempo suficiente para fazer isso. De modo semelhante, quem estiver trabalhando na roça não deve voltar para sua casa para buscar nada; ele precisa fugir rápido. ");
INSERT INTO portft_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lembrem-se da mulher de Ló! Ela voltou para trás querendo tirar algumas das suas coisas de Sodoma, e morreu logo virou um pilar de sal. ");
INSERT INTO portft_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aquele que deseja segurar sua vida e seus bens não vai viver eternamente. Mas aquele que está disposto a morrer por minha causa vai viver eternamente. ");
INSERT INTO portft_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Digo isto a vocês: naquela noite em que eu voltar, vai haver duas pessoas dormindo em uma cama. Deus vai levar aquele que crê em mim para o céu e vai deixar o outro para trás para castigá-lo. ");
INSERT INTO portft_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Duas mulheres estarão moendo trigo juntas; Deus vai levar uma delas e deixar a outra para trás. ");
INSERT INTO portft_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Seus discípulos disseram a ele, “Senhor, onde isso vai acontecer? Ele respondeu a eles, “Onde tiver um corpo morto, os urubus se juntarão para comê- lo. De modo semelhante, onde houver pessoas que estão mortas espiritualmente/que não creem em mim, Deus logo vai castigá-las.” ");
INSERT INTO portft_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesus contou uma parábola aos seus discípulos para ensiná-los que sempre deviam orar com confiança e não deviam ficar desanimados se Deus não fizesse imediatamente o que eles pediam. ");
INSERT INTO portft_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ele disse, “Em certa cidade havia um juiz que não temia a Deus e não se importava com as pessoas. ");
INSERT INTO portft_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Havia uma viúva naquela cidade que sempre ia a ele e dizia, Resolva, por favor, o que é justo na disputa entre mim e o homem que se opõe a mim na justiça! ");
INSERT INTO portft_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Durante muito tempo o juiz recusava ajudá-la. Porém mais tarde ele disse para si mesmo, Não temo a Deus e não me importo com as pessoas, ");
INSERT INTO portft_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mas esta viúva não deixa de me perturbar! Por isso vou decidir o caso dela e mostrar que ela está no seu direito. Pois se eu não fizer isso, ela vai me cansar vindo a mim continuamente. ");
INSERT INTO portft_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Então o Senhor Jesus disse, Mesmo que o juiz nem fosse um homem justo, prestem atenção no que disse! ");
INSERT INTO portft_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Da mesma forma, Deus certamente/será que Deus não vai mostrar que o que vocês têm feito está certo. Ele vai fazer isso para vocês que ele escolheu. Ele vai fazer isso para vocês que oram honestamente para ele dia e noite pela sua ajuda/pedindo a ajuda dele. Ele pode demorar em ajudar vocês. ");
INSERT INTO portft_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","mas digo a vocês, um dia ele vai mostrar que o que vocês fizeram foi certo, e vai fazer isso logo. Mas quando eu, que vim do céu, voltar para a terra, talvez não tenha/será que vai ter muitas pessoas que ainda estarão confiando que eu vá vindicá-las (OU, que ainda estarão confiando em mim). ");
INSERT INTO portft_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus também contou uma parábola para aconselhar algumas pessoas que pensavam erradamente que eram aceitáveis a Deus por causa das coisas que faziam. Além disso, elas também desprezavam os outros. ");
INSERT INTO portft_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ele disse assim: “Dois homens subiram ao templo em Jerusalém para orar. Um deles era fariseu. O outro era cobrador de impostos. ");
INSERT INTO portft_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","O fariseu ficou em pé e orou dentro de si mesmo silenciosamente, Deus, dou graças ao Senhor que não sou como outros homens. Alguns tiram o dinheiro dos outros, alguns agem de forma injusta para com os outros, alguns são homens que cometem adultério. Eu não faço tais coisas. E eu certamente não sou como este cobrador de impostos que engana as pessoas! ");
INSERT INTO portft_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Embora a nossa lei diga que nós (excl) devamos jejuar/deixar de comer uma vez por semana, eu faço duas vezes por semana. Dou para o senhor dez por cento de tudo que ganho. ");
INSERT INTO portft_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mas o cobrador de impostos ficou longe das outras pessoas na área do templo porque ele se sentia muito indigno. Ele nem olhou para o céu. Pelo contrário, batia no peito para mostrar que estava arrependido do seu pecado. Ele disse, Deus, sou pecador; tenha misericórdia de mim e perdoe-me!” ");
INSERT INTO portft_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Então Jesus disse, Digo a vocês que quando o cobrador de impostos foi para casa, Deus apagou os seus pecados. Lembrem-se disso: Deus vai humilhar cada um que se exalta a si mesmo, mas ele vai exaltar todos os que se humilham. ");
INSERT INTO portft_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Certo dia quando muitas pessoas iam a Jesus, estavam também levando crianças pequenas. Queriam que ele colocasse suas mãos nas crianças e as abençoasse. Quando os discípulos viram isso, eles repreenderam aqueles que traziam as crianças. ");
INSERT INTO portft_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mas Jesus chamou as crianças para irem a ele. Ele disse, “Não impeçam as crianças; deixem elas virem a mim! Os que confiam assim como elas são os que vão experimentar o controle/cuidado de Deus nas suas vidas. ");
INSERT INTO portft_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Quero que vocês saibam que os que não deixam confiantemente que Deus dirija as suas vidas assim como fazem as crianças, não vão gozar a bênção de ter Deus como seu rei/chefe. ");
INSERT INTO portft_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Um líder judaico perguntou a Jesus, “Bom mestre, o que é que devo fazer para viver eternamente com Deus?” ");
INSERT INTO portft_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus disse a ele, “Você deve considerar com cuidado/você entende que ao dizer que sou bom você está implicando que sou Deus, pois somente Deus é bom. Nenhum outro é bom! ");
INSERT INTO portft_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mas para responder à sua pergunta, você sabe os mandamentos que Deus deu a Moisés. Ele mandou coisas tais como, Não cometa adultério! Não mate ninguém! Não roube! Não minta! Honre a seu pai e a sua mãe!” ");
INSERT INTO portft_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","O homem disse, “Já que obedeci todos estes mandamentos desde jovem, deve haver outra coisa que não tenho feito/isso é o suficiente?”  ");
INSERT INTO portft_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Quando Jesus o ouviu dizer isso, respondeu a ele, “Tem uma coisa que você ainda não fez. Venda tudo quanto possui. Então dê o dinheiro aos pobres. Como resultado você vai ser rico espiritualmente no céu. Depois de fazer o que acabo de dizer a você, venha comigo e seja meu discípulo!” ");
INSERT INTO portft_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","O homem saiu triste quando ouviu isso, porque ele era muito rico e não queria dar tudo. ");
INSERT INTO portft_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus olhou para ele enquanto saía e disse, “É muito difícil aqueles que são ricos resolverem deixar que Deus controle suas vidas. ");
INSERT INTO portft_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Vocês diriam que é impossível um camelo passar pelo fundo de uma agulha. É quase tão difícil quanto isso um homem rico resolver deixar que Deus controle sua vida. ");
INSERT INTO portft_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Os judeus pensavam que Deus favorecia os ricos, e por isso eles pensavam que se Deus não salvasse os ricos, ele também não iria salvar os outros. Então um dos discípulos que o ouviu dizer isso respondeu, “Se for assim, parece que Deus não vai salvar ninguém!” ");
INSERT INTO portft_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mas ele disse, “Sim, é impossível que as pessoas salvam a si mesmas. Mas Deus pode salvar qualquer um!” ");
INSERT INTO portft_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Então Pedro disse, “E nós? Nós (excl) deixamos tudo que possuímos e temos ido com o senhor. ");
INSERT INTO portft_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ele disse a eles, “Quero que vocês saibam que todos aqueles que deixam suas casas ou suas mulheres ou crianças, ou seus irmãos ou seus pais, para dizer aos outros como Deus quer controlar as vidas deles, ");
INSERT INTO portft_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","vão receber nesta vida muitas vezes mais do que deixaram. E na época futura estarão vivendo eternamente com Deus. ");
INSERT INTO portft_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus levou seus discípulos à parte e disse a eles, “Ouçam com cuidado! Nós (inc) estamos para subir a Jerusalém. Lá tudo que os profetas escreveram sobre mim, aquele que vim do céu, vai acontecer. ");
INSERT INTO portft_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","As pessoas/meus inimigos vão me entregar às mãos dos não judeus. Eles vão zombar de mim, e maltratar-me e cuspir em mim. ");
INSERT INTO portft_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Eles vão bater em mim e depois vão me matar. Mas no terceiro dia depois disso vou tornar a viver.” ");
INSERT INTO portft_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mas os discípulos não entenderam nada daquilo que ele disse. Algo/Deus impediu que eles entendessem o significado do que ele estava dizendo a eles. ");
INSERT INTO portft_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Quando Jesus e seus discípulos chegaram perto da cidade de Jericó, um homem cego estava sentado ao lado da estrada. Ele estava pedindo dinheiro. ");
INSERT INTO portft_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Quando ele ouviu a multidão de pessoas passar, perguntou a alguém, “O que está acontecendo?” ");
INSERT INTO portft_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Eles disseram a ele, “Jesus, o homem da cidade de Nazaré, está passando.” ");
INSERT INTO portft_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ele gritou, “Jesus, o Messias descendente do Rei Davi, tenha pena de mim!” ");
INSERT INTO portft_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aqueles que andavam na frente da multidão o repreenderam. Disseram a ele para ficar quieto. Mas ele gritou ainda mais alto, “Messias descendente do Rei Davi, tenha pena de mim!” ");
INSERT INTO portft_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesus parou e pediu que eles trouxessem o homem a ele. Quando o homem cego se aproximou, Jesus perguntou a ele, ");
INSERT INTO portft_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“O que é que você quer que eu faça para você?” Ele respondeu, “Senhor, faça com que eu veja outra vez!” ");
INSERT INTO portft_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesus disse a ele, “Pois veja! Porque você confia em mim, já curei você!” ");
INSERT INTO portft_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Logo ele podia ver. Ele foi com Jesus, louvando a Deus. Quando todos os que andavam com ele viram isso, eles louvaram a Deus. ");
INSERT INTO portft_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Eles entraram em Jericó e estavam atravessando a cidade. ");
INSERT INTO portft_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Havia ali um homem chamado Zaqueu. Ele era chefe dos cobradores de impostos, e era rico. ");
INSERT INTO portft_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ele tentou ver Jesus, mas ele era baixo e tinha uma grande multidão de pessoas perto de Jesus. Por isso ele não podia vê-lo. ");
INSERT INTO portft_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Então ele correu diante de Jesus na mesma estrada onde Jesus estava andando. Ele subiu em uma figueira para ver Jesus. ");
INSERT INTO portft_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Quando Jesus chegou ali, ele olhou para cima e disse a ele, “Zaqueu, desça rápido, porque Deus quer que eu vá com você para sua casa para ficar ali hoje à noite!” ");
INSERT INTO portft_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aí ele desceu logo. Ele levou Jesus à sua casa e o recebeu com alegria. ");
INSERT INTO portft_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Aqueles que viram Jesus ir até ali se queixaram dizendo, “Ele já entrou em uma casa para ser hóspede de um homem que é pecador!” ");
INSERT INTO portft_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Então Zaqueu levantou-se/pôs-se em pé enquanto eles estavam comendo e disse ao Senhor Jesus, “Senhor, quero que o senhor saiba que vou dar a metade dos meus bens aos pobres. Também, quanto às pessoas que tenho enganado, vou devolver a elas quatro vezes mais a quantia que recebi delas ao enganá-las. ");
INSERT INTO portft_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus disse a ele, “Hoje Deus tem salvado/perdoado você e todos os demais em esta casa, porque você também tem mostrado que confia em Deus assim como fez o seu antepassado Abraão. ");
INSERT INTO portft_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Lembre-se disso: eu, que desci do céu, vim para procurar e salvar pessoas como você que tem se desviado de Deus, assim como um pastor procura as ovelhas perdidas. ");
INSERT INTO portft_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Eles estavam se aproximando de Jerusalém, e aqueles que andavam com Jesus e que o ouviram dizer essas coisas pensavam que quando ele chegasse a Jerusalém ele ia se tornar o rei deles. ");
INSERT INTO portft_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Então ele contou a eles esta parábola: “Um príncipe se aprontou para ir a um país distante para que o imperador o fizesse rei. Ele pretendia voltar mais tarde. ");
INSERT INTO portft_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Antes de sair, ele chamou dez dos seus servos. Ele deu a cada um deles uma moeda que valia três meses de salário. Ele disse a eles, Façam comércio com estas até que eu volte! Então ele saiu. ");
INSERT INTO portft_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mas muitos dos seus compatriotas o odiavam. Por isso eles enviaram uns mensageiros atrás dele para dizer ao imperador, Nós não queremos que este homem seja nosso rei! ");
INSERT INTO portft_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mas o imperador o fez rei. Mais tarde o novo rei voltou. Aí ele deu uma ordem que alguém chamasse os servos a quem ele tinha dado as moedas. Ele queria saber quanto eles tinham ganhado ao negociar com suas moedas. ");
INSERT INTO portft_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","O primeiro homem veio a ele e disse, Senhor, com sua moeda eu ganhei mais dez moedas! ");
INSERT INTO portft_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ele disse a esse homem, Você é um bom servo! Você tem feito muito bem! Porque você manejou fielmente uma quantia pequena de dinheiro, vou lhe dar a autoridade para governar dez cidades. ");
INSERT INTO portft_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Aí o segundo servo veio a ele e disse, Senhor, com sua moeda eu tenho ganhado mais cinco moedas! ");
INSERT INTO portft_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ele disse àquele servo, Vou dar a você a autoridade para governar cinco cidades. ");
INSERT INTO portft_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Então chegou outro servo. Ele disse, Senhor, aqui está a sua moeda. Eu a embrulhei em um pano e guardei, para que nada acontecesse a ela. ");
INSERT INTO portft_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Fiz isso porque estava com medo do que o senhor faria comigo se o negócio falhasse. Eu sabia que o senhor era um homem que não faz coisas tolas com seu dinheiro. O senhor até tira dos outros dinheiro que realmente não pertence ao senhor, assim como um lavrador que colhe trigo da roça de outro. ");
INSERT INTO portft_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ele disse àquele servo, Que servo mau! Vou condená-lo pelas mesmas palavras que acaba de falar! Pois você sabia/será que você não sabia que eu não faço coisas tolas/estúpidas com meu dinheiro. Você disse que eu até tiro dos outros dinheiro que realmente não me pertence, como um fazendeiro que colhe trigo da roça de outro. ");
INSERT INTO portft_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Então, você devia pelo menos ter dado/por que foi que você não deu meu dinheiro ao banco? Então ao voltar poderia ter recolhido aquela quantia mais os juros! ");
INSERT INTO portft_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Então o rei disse àqueles que estavam ali perto, Tirem a moeda dele e dê ao servo que tem dez moedas! ");
INSERT INTO portft_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Eles protestaram, Senhor, ele já tem dez moedas! ");
INSERT INTO portft_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mas o rei disse, Digo isto a vocês: a todos os que usam bem o que já receberam, eu vou dar mais. Mas daqueles que não usam bem o que já receberam, vou tirar até mesmo o que ainda têm. ");
INSERT INTO portft_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ora, quanto a esses inimigos meus que não queriam que eu governasse sobre eles, tragam eles para cá e executem/matem enquanto estou olhando! ");
INSERT INTO portft_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Depois de Jesus dizer essas coisas, continuou na estrada para Jerusalém, indo diante dos seus discípulos. ");
INSERT INTO portft_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Quando chegaram perto das aldeias de Betfagé e Betânia, perto do monte que se chama o monte das oliveiras, ");
INSERT INTO portft_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ele disse a dois dos seus discípulos, “Vão à aldeia na nossa frente. Quando vocês dois entrarem na aldeia, vão ver um animal novo que ninguém ainda montou. Desamarrem-no e tragam-no para mim. ");
INSERT INTO portft_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Se alguém perguntar a vocês, Por que vocês o estão desamarrando?, digam a ele, O Senhor precisa dele. ");
INSERT INTO portft_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Então os dois que ele mandou foram à aldeia e acharam o animal assim como ele lhes tinha dito. ");
INSERT INTO portft_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Enquanto eles o desamarravam, os donos do animal disseram aos dois, “Por que é que vocês estão desamarrando esse animal novo?” ");
INSERT INTO portft_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Eles responderam, “O Senhor precisa dele.” Aí os donos disseram que eles podiam levá-lo. ");
INSERT INTO portft_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Os dois discípulos levaram o animal a Jesus. Colocaram suas capas em cima do animal como sela e ajudaram Jesus a montar nele. ");
INSERT INTO portft_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Aí enquanto ele andava montado, outras pessoas espalharam suas capas na estrada para honrá-lo. ");
INSERT INTO portft_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Quando chegaram perto de Jerusalém, na estrada que desce do monte das oliveiras, toda a multidão dos discípulos começou a alegrar-se e louvar a Deus em voz bem alta por todos os milagres que eles tinham visto Jesus fazer. ");
INSERT INTO portft_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Eles estavam dizendo, “Deus tem abençoado o nosso rei que vem para representar MTY o Senhor! Que haja paz entre Deus no céu e nós o povo dele! Que todos louvem a Deus!” ");
INSERT INTO portft_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Alguns dos fariseus que faziam parte da multidão disseram a ele, “Mestre, repreenda seus discípulos por dizerem coisas deste tipo!” ");
INSERT INTO portft_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mas Jesus respondeu, “Digo isto a vocês: se estas pessoas ficassem caladas, até as pedras iriam gritar para me louvar!” ");
INSERT INTO portft_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Quando Jesus chegou perto de Jerusalém e viu a cidade, ele chorou sobre o povo dela. ");
INSERT INTO portft_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ele disse, “Meus discípulos sabem o que precisam fazer para ter paz com Deus; como eu queria que hoje mesmo o resto de vocês entendessem isso. Mas agora vocês são incapazes de entender. ");
INSERT INTO portft_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Quero que vocês saibam isto: logo seus inimigos chegarão e montarão uma rampa de ataque ao redor da sua cidade. Vão rodear a cidade e apertá-la de todos os lados. ");
INSERT INTO portft_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Vão quebrar os muros e destruir tudo. Vão esmagar vocês e seu povo/seus filhos. Quando terminarem de destruir tudo, não vai haver nem uma pedra em cima de outra. Tudo isso vai acontecer porque vocês não reconheceram o tempo quando Deus mandou o Messias dele para salvar vocês. ");
INSERT INTO portft_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesus entrou em Jerusalém e foi à área do templo e começou a expulsar as pessoas que estavam vendendo coisas ali. ");
INSERT INTO portft_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ele disse a eles, “Um profeta escreveu nas Escrituras que Deus disse, Meu templo vai ser um lugar onde as pessoas oram; mas vocês a tornaram em algo semelhante a uma cova onde se escondem os ladrões!” ");
INSERT INTO portft_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Todos os dias daquela semana, Jesus estava ensinando as pessoas na área do templo. Os principais sacerdotes, os homens que ensinavam as leis judaicas, e outros líderes dos judeus tentaram achar um meio de matá-lo. ");
INSERT INTO portft_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mas não acharam nenhum meio de fazer isso, porque todas as pessoas ali o ouviram com grande interesse e os teriam resistido se eles tivessem tentado fazer qualquer coisa para ferir Jesus. ");
INSERT INTO portft_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Certo dia durante aquela semana Jesus estava ensinando as pessoas na área do templo e contando a elas a boa mensagem de Deus. Enquanto ele fazia isso, os principais sacerdotes, os homens que ensinavam as leis judaicas, e outros anciãos judaicos chegaram a ele. ");
INSERT INTO portft_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Eles disseram a ele, “Digam-nos, por qual autoridade o senhor expulsou os vendedores daqui ontem? Quem o autorizou a agir assim?” ");
INSERT INTO portft_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ele respondeu, “Vou fazer também a vocês uma pergunta. Digam-me, ");
INSERT INTO portft_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","foi Deus MTY/EUP que autorizou que João batizasse as pessoas ou foram outras pessoas que o autorizaram?” ");
INSERT INTO portft_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Eles discutiram isso entre si. Eles concluíram, “Se nós (inc) dissermos que foi Deus MTY/EUP que o autorizou, ele vai nos dizer, Então vocês deviam ter crido o que João disse. ");
INSERT INTO portft_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mas se dissermos que foram somente pessoas que autorizaram João, o povo vai nos matar jogando pedras em nós, porque todos creem que João foi um profeta que Deus tinha mandado. ");
INSERT INTO portft_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Por isso responderam, “Nós (excl) não sabemos quem foi que autorizou João. ");
INSERT INTO portft_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aí Jesus disse a eles, “Já que vocês não me responderam, não vou dizer a vocês quem foi que me autorizou para fazer estas coisas.” ");
INSERT INTO portft_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Então Jesus contou às pessoas ali esta parábola para ilustrar o que Deus faria aos judeus que rejeitaram aos profetas antigos e a ele: “Um homem plantou uvas. Ele arrendou a plantação de uvas a uns homens para eles cuidarem dela e dar a ele uma parte do fruto como pagamento/em troca. Depois ele foi a outro país e ficou ali por muitos anos. ");
INSERT INTO portft_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Quando chegou o tempo de colher o fruto, ele enviou um servo aos homens que estavam cuidando da plantação. Ele esperava que eles dessem a ele uma parte do fruto. Mas depois do servo chegar, eles bateram nele e não deram a ele nada do fruto. Então eles o mandaram embora. ");
INSERT INTO portft_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mais tarde o dono mandou outro servo. Mas eles também bateram nele e o maltrataram. Mandaram-no embora sem dar a ele nada do fruto. ");
INSERT INTO portft_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mais tarde o dono mandou outro servo. Eles feriram esse e o jogaram fora. ");
INSERT INTO portft_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aí o dono disse para si mesmo, Não sei o que fazer/o que é que devo fazer! Aí ele teve uma ideia. Ele disse para si mesmo, Vou mandar o meu filho, que amo muito. Talvez eles o respeitem e deem a ele a minha parte do fruto.  ");
INSERT INTO portft_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Aí ele o mandou, mas quando os homens que cuidavam da plantação o viram chegar, eles disseram entre si, Aqui vem o homem que um dia vai ser o dono da terra do seu pai! Vamos matá-lo para que a plantação de uvas dele seja nossa! ");
INSERT INTO portft_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Então eles o arrastaram para fora da plantação e o mataram. Pois vocês sabem o que o dono vai fazer com eles? ");
INSERT INTO portft_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Vou dizer a vocês o que ele vai fazer: ele vai chegar e matar esses homens que estavam cuidando da plantação de uvas. Aí ele vai arranjar outras pessoas para cuidarem dela.” Quando eles ouviram isso, disseram, “Que isso nunca aconteça! ");
INSERT INTO portft_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mas Jesus olhou diretamente a eles e disse, “Se vocês disseram isso, pensem no significado destas palavras que um profeta escreveu: Os homens que estavam construindo uma casa rejeitaram uma certa pedra. Mas outros colocaram aquela mesma pedra no lugar próprio dela, e ela tem se tornado a mais importante do alicerce. ");
INSERT INTO portft_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aquela pedra representa a mim, o Messias. Cada um que rejeita os meus ensinamentos é como um homem que tropeça naquela pedra e se fere severamente, ou como alguém em que a pedra cai e o esmaga. Deus vai destruir essas pessoas totalmente.” ");
INSERT INTO portft_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Os principais sacerdotes e os homens que ensinavam as leis judaicas perceberam que Jesus estava acusando-os quando contou a história sobre o que fizeram esses homens maus. Por isso eles tentaram levá-lo preso logo, mas não fizeram isso, porque tinham medo do que os outros ali fariam se fizessem isso. ");
INSERT INTO portft_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Então eles o observaram com cuidado. Eles também pagaram espiões que fingiram ser sinceros. Porém eles realmente queriam fazê-lo dizer algo pelo qual eles pudessem acusá-lo. Eles queriam poder entregá-lo à autoridade do governador da província. Eles também sabiam que os judeus estavam aborrecidos por terem que pagar impostos ao governo.  ");
INSERT INTO portft_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Esses espiões perguntaram a ele, “Professor, nós (excl) sabemos que o senhor fala e ensina o que é certo. O senhor diz a verdade mesmo que saiba que as pessoas importantes não vão gostar. O senhor ensina a verdade sobre o que Deus quer que façamos. ");
INSERT INTO portft_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Então diga-nos o que pensa sobre isso: nós (excl) pagamos impostos ao governo romano. Segundo a lei que Moisés escreveu, é certo nós fazermos isso ou não? ");
INSERT INTO portft_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mas eles sabia que eles estavam procurando enganá-lo para que ele entrasse em dificuldades ou com os judeus, que odiavam pagar esses impostos, ou com o governo romano. Por isso ele disse a eles, ");
INSERT INTO portft_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mostre para mim uma moeda. Então me digam de quem é a foto/figura que eles têm estampado nela. E digam-me de quem é o nome nela.” ");
INSERT INTO portft_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eles mostraram uma moeda a ele e disseram, “Tem o nome e a figura de César, o chefe principal do governo romano.” Jesus disse a eles, “neste caso, deem ao governo o que ele requer, e deem a Deus o que ele/Deus requer.” ");
INSERT INTO portft_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Enquanto as pessoas estavam ali, os espiões não podiam achar nada errado no que ele disse. Ficaram admirados com a resposta dele. Por isso não disseram nada. ");
INSERT INTO portft_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Alguns homens da seita chamada Saduceus foram a Jesus. Estes são homens que negam que as pessoas vão viver de novo depois de morrerem. ");
INSERT INTO portft_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Para desacreditar a ideia de que as pessoas vão viver de novo, eles perguntaram a ele, “Mestre, Moisés escreveu para nós judeus que se um homem que tem esposa mas não tem filhos morrer, se a esposa dele ainda estiver viva, e se ele tiver irmão, este seu irmão deve casar-se com a viúva do morto. Então se esses dois tiverem filhos, as pessoas vão considerar que os filhos pertencem ao homem que morreu, para que ele continue a ter descendentes. ");
INSERT INTO portft_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pois bem, havia sete irmãos. O irmão mais velho casou-se com uma mulher, mas os dois não tiveram filhos. Mas tarde ele morreu. ");
INSERT INTO portft_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","O segundo irmão seguiu esta lei, mas a mesma coisa aconteceu. ");
INSERT INTO portft_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Aí o terceiro irmão casou-se com ela, mas a mesma coisa aconteceu outra vez. Todos os sete irmãos casaram-se com aquela mulher um por um, mas não tiveram filhos e um por um eles morreram. ");
INSERT INTO portft_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Depois a mulher também morreu. ");
INSERT INTO portft_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Portanto, se fosse verdade, como alguns dizem, que as pessoas tornam a viver, na sua opinião, de quem é que essa mulher vai ser esposa quando as pessoas viverem de novo? Lembre-se de que vai ser impossível resolver, porque ela era casada com todos os sete irmãos!” ");
INSERT INTO portft_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus respondeu a eles, “Os homens que vivem aqui neste mundo tomam esposas, ou os pais dão esposas aos homens. ");
INSERT INTO portft_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mas os homens que Deus considera dignos de estarem no céu depois de viverem de novo não vão casar-se. ");
INSERT INTO portft_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Vocês também precisam saber que eles não podem morrer mais, porque serão imortais como os anjos. O de Deus fazer com que vivam de novo vai mostrar que eles são filhos de Deus. ");
INSERT INTO portft_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mas quanto ao assunto das pessoas viverem de novo depois de morrerem, Moisés escreveu algo. No lugar onde ele escreveu sobre a sarça que ardia/espinheiro que queimava, ele fala no Senhor como sendo o Deus que Abraão adora e o Deus que Isaque adora e o Deus que Jacó adora. Abraão, Isaque e Jacó morreram muito antes disso. Mas Deus disse que eles ainda estavam adorando-o! Portanto nós (inc) sabemos que os espíritos deles ainda estavam vivos! ");
INSERT INTO portft_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ele é o Deus que os vivos adoram, não o Deus que os mortos adoram! Todas as pessoas que vivem de novo depois de morrerem continuam a viver para honrar a ele!” ");
INSERT INTO portft_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Alguns dos homens que ensinavam as leis judaicas responderam, “Mestre, o senhor deu uma boa resposta! ");
INSERT INTO portft_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Depois disso, eles não se atreviam a fazer mais perguntas deste tipo a ele. ");
INSERT INTO portft_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mais tarde ele disse a eles, “As pessoas devem ser erradas que/por que é que as pessoas dizem que o Messias é apenas descendente do Rei Davi. ");
INSERT INTO portft_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Porque Davi mesmo escreveu no livro dos Salmos, Deus disse a meu Senhor/Líder, Sente-se aqui do meu lado no lugar onde vou honrá-lo muito. ");
INSERT INTO portft_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Sente-se aqui enquanto eu derrotar por completo os inimigos do senhor. ");
INSERT INTO portft_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davi chama o Messias, “Meu Senhor/Líder.” Portanto, o Messias não pode ser/como é que o Messias pode ser apenas um descendente do Rei Davi! Ele deve ser muito maior do que Davi. Não é assim mesmo?” ");
INSERT INTO portft_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Enquanto todas as outras pessoas estavam ouvindo, Jesus disse aos seus discípulos, ");
INSERT INTO portft_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tenham o cuidado de não se comportarem como aqueles que ensinam as leis judaicas. Eles gostam de vestir capas compridas e andar para fazer as pessoas pensarem que eles são muito importantes. Eles gostam que os outros os cumprimentem com respeito nos mercados. Eles gostam de sentar-se nos lugares mais importantes nas sinagogas e nos lugares de honra nos banquetes. ");
INSERT INTO portft_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Eles exploram/roubam as casas e os bens das viúvas. Então eles fingem que são bons ao fazer longas orações em público. Deus certamente vai castigá-los bem severamente. ");
INSERT INTO portft_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus olhou de onde estava sentado e viu pessoas ricas colocando suas doações na caixa das ofertas no pátio do templo. ");
INSERT INTO portft_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ele também viu uma viúva pobre colocando duas moedas pequenas de cobre. ");
INSERT INTO portft_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Ele disse aos seus discípulos, “Observem o que estou dizendo: estes outros têm muito dinheiro, mas deram só um pouquinho dele. Mas esta mulher, que é muito pobre, tem colocado tudo que tinha, o dinheiro para pagar pelas coisas que precisa! Por isso Deus considera que esta viúva pobre tem colocado mais do que todos os outros! ");
INSERT INTO portft_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Alguns dos discípulos de Jesus falavam do templo. Eles comentaram sobre as pedras bonitas com que os homens tinham construído o templo e os outros enfeites que pessoas tinham dado, enfeites que estavam nos muros. Mas ele disse, ");
INSERT INTO portft_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Quero dizer algo a vocês a respeito destas coisas que estão olhando. Invasores estrangeiros vão destruir estes edifícios por completo. Quando isso acontecer, nenhuma pedra no pátio deste templo estará deixado em cima de outra.” ");
INSERT INTO portft_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mais tarde eles perguntaram a ele, “Mestre, quando é que isso vai acontecer? O que é que vai acontecer para nos mostrar que as coisas que o senhor acaba de nos dizer estão para ocorrer?” ");
INSERT INTO portft_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ele disse, “Muitas pessoas virão e dirão que têm a minha autoridade. Eles vão dizer, Eu sou o Messias! Eles também dirão, “Já chegou a hora de Deus governar! Portanto tenham cuidado para que eles não enganem vocês. Não os sigam para se tornarem discípulos deles! ");
INSERT INTO portft_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Também, quando ouvirem de guerras e de pessoas que estão fazendo confusão, não fiquem aterrorizados! Lembrem-se de que Deus já disse que estas coisas vão acontecer. Mas não vai ser este o tempo quando o mundo vai terminar.” ");
INSERT INTO portft_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Então ele disse a eles, “As pessoas que vivem em vários países vão brigar umas contra as outras, e vários governos vão brigar uns contra outros. ");
INSERT INTO portft_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Vai haver grandes terremotos, e em várias áreas vai ter fomes e pragas. As pessoas vão ver coisas que as assustarão muito. Também vai haver coisas estranhas/anormais acontecendo no céu. ");
INSERT INTO portft_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mas antes de todas estas coisas acontecerem, eles vão perseguir vocês e levar vocês presos. Eles vão julgar alguns de vocês nas casas de adoração dos judeus e vão pôr vocês nas prisões. Vão levar vocês a reis e a governadores porque são meus discípulos. ");
INSERT INTO portft_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Esta será a hora de vocês falarem a eles sobre mim. ");
INSERT INTO portft_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Por isso resolvam dentro de si mesmos não estarem pensando antes disso acontecer sobre o que vão dizer para se defender, ");
INSERT INTO portft_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Porque eu vou dar a vocês as palavras sábias para dizer. Como resultado, nenhum daqueles que se opõem a vocês vai poder contrariar o que dizem nem contradizer vocês. ");
INSERT INTO portft_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Até mesmo seus pais e irmãos e outros parentes e amigos que não creem em mim vão trair vocês/ajudar os seus inimigos a prenderem vocês. Vão matar alguns de vocês. ");
INSERT INTO portft_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Vai parecer que todos odeiam vocês porque vocês creem em mim. ");
INSERT INTO portft_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mas as suas almas estarão totalmente seguras. ");
INSERT INTO portft_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ao aguentarem todas estas coisas que as pessoas vão fazer a vocês, vocês vão preservar a sua vida eterna.” ");
INSERT INTO portft_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mas quando vocês virem/observarem que os exércitos dos seus inimigos têm rodeado Jerusalém, vão saber que é o tempo deles destruirem esta cidade por completo. ");
INSERT INTO portft_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Naquela época os que estão no distrito da Judeia devem fugir para montes mais altos. Aqueles que estão nesta cidade precisam sair rápido. Aqueles que estão no campo perto da cidade não devem voltar à cidade para pegar os seus bens antes de fugirem. ");
INSERT INTO portft_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Vocês precisam obedecer o que eu digo a vocês porque, para cumprir o que os profetas escreveram, Deus vai castigar bem severamente as pessoas que ficam nesta cidade. ");
INSERT INTO portft_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sinto muito pelas mulheres que estarão grávidas e mulheres que estarão amamentando seus nenês naqueles dias, porque vai ser bem difícil elas fugirem! Sinto muito porque as pessoas deste país estarão sofrendo muito quando Deus as castigar. ");
INSERT INTO portft_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Os inimigos delas vão matar muitos delas com a espada. Vão capturar outras e levá-las a muitos outros países. Os não judeus vão pisar/conquistar Jerusalém até chegar o fim do tempo determinado por Deus deles governarem a cidade. ");
INSERT INTO portft_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Também haverá coisas estranhas que vão acontecer ao sol, à lua e às estrelas. Em muitas nações na terra as pessoas estarão com muito medo e ficarão ansiosas quando ouvirem o mar rugir e virem as grandes ondas. ");
INSERT INTO portft_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","As pessoas vão desmaiar porque vão ter tanto medo ao esperarem o que vai acontecer no mundo. Vão estar com medo porque Deus vai fazer com que todas as estrelas no céu tremam. ");
INSERT INTO portft_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Depois vão ver a mim, aquele que vim do céu, voltando pelas nuvens poderosamente e com grande brilho. ");
INSERT INTO portft_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Então quando estas coisas que acabo de descrever começarem a acontecer, fiquem retos em pé e sejam corajosos, porque vai estar próximo o tempo quando Deus salvará vocês de todo sofrimento. ");
INSERT INTO portft_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aí ele contou a eles esta parábola: “Pensem na figueira, e em todas as outras árvores. ");
INSERT INTO portft_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Logo que suas folhas começam a brotar, vocês sabem que o verão está perto. ");
INSERT INTO portft_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Da mesma forma, quando vocês virem ocorrer estas coisas que acabo de descrever, vocês mesmos vão saber que está quase na época de Deus realmente governar como rei/chefe. ");
INSERT INTO portft_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Quero que vocês saibam que todas estas coisas que acabo de dizer-lhes vão acontecer enquanto vocês que têm observado as coisas que faço ainda estão vivos. ");
INSERT INTO portft_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Vocês podem ter absoluta certeza de que estas coisas de que tenho falado vão acontecer! Vocês podem ter até mais certeza disso do que têm do fato da terra e do céu ficar nos seus lugares! ");
INSERT INTO portft_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Mas tenham cuidado/sejam vigilantes! Não fiquem bêbados/não participem das bebedeiras nem deixem as preocupações da vida distraírem vocês. Se fizerem assim, sou capaz de voltar de repente, como uma armadilha de repente pega um animal. ");
INSERT INTO portft_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Guardem em mente que a minha volta vai surpreender todos pelo mundo inteiro. ");
INSERT INTO portft_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Então estejam sempre prontos. Orem para que tenham forças para aguentarem sem estarem com medo de todas essas coisas difíceis que vão acontecer, para que assim possam estar confiantes diante de mim, aquele que vim do céu.” ");
INSERT INTO portft_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Todos os dias durante aquela semana, Jesus ensinou as pessoas na área do templo em Jerusalém. Mas à noite ele e seus discípulos saíram da cidade e ficaram no Monte das Oliveiras. ");
INSERT INTO portft_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bem cedo cada manhã muitas pessoas foram ao pátio do templo para ouvi-lo. ");
INSERT INTO portft_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Já estava quase no tempo de celebrar a festa dos pães sem fermento. Esta festa também se chama a Páscoa. ");
INSERT INTO portft_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Os principais sacerdotes e os homens que ensinavam as leis judaicas estavam procurando um meio de matar Jesus. Mas queriam fazer isso secretamente, porque temiam que se não fizessem secretamente, as outras pessoas iam resistir. ");
INSERT INTO portft_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Aí Satanás entrou em Judas, que se chamava o homem da aldeia de *Cariote, mesmo que ele fosse um dos doze discípulos. ");
INSERT INTO portft_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ele foi ter com os principais sacerdotes e os oficiais dos guardas do templo. Eles discutiram como ele poderia ajudá-los a prender Jesus. ");
INSERT INTO portft_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Eles estavam contentes que ele quisesse fazer isso. Eles ofereceram dar dinheiro a ele por fazer isso. ");
INSERT INTO portft_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Então ele concordou e levou o dinheiro. Depois ele tentou achar uma oportunidade de trair/ajudá-los a prender Jesus quando ninguém estivesse perto. ");
INSERT INTO portft_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Então chegou o dia na festa dos pães sem fermento quando as pessoas sacrificavam carneirinhos para lembrarem do tempo quando Deus salvou os seus antepassados. ");
INSERT INTO portft_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Por isso Jesus disse a Pedro e João, “Vão preparar o jantar da Páscoa para nós comermos.” ");
INSERT INTO portft_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Eles responderam a ele, “Onde é que o senhor quer que nós o preparemos?” ");
INSERT INTO portft_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ele disse a dois deles, “Ouçam com cuidado. Quando vocês dois entrarem na cidade, vão ver um homem carregando um pote grande de água. Sigam-no. 11 Quando ele entrar em uma casa, ");
INSERT INTO portft_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","digam ao dono, Nosso mestre diz que nós (excl) devemos perguntar ao senhor, Onde fica a sala para hóspedes, que eu arranjei para comer o jantar da Páscoa com meus discípulos?” ");
INSERT INTO portft_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ele vai mostrar a vocês um salão grande que fica no andar superior da casa. Estará mobiliado/preparado. Preparem o jantar para nós ali.” ");
INSERT INTO portft_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aí os dois discípulos entraram na cidade. Acharam tudo exatamente como Jesus tinha dito. Prepararam o jantar da Páscoa ali. ");
INSERT INTO portft_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Quando chegou a hora de comer o jantar, Jesus sentou-se com os doze apóstolos. ");
INSERT INTO portft_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ele disse a eles, “Tenho desejado muito comer este jantar de Páscoa com vocês antes de eu sofrer e morrer. ");
INSERT INTO portft_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Quero que vocês saibam que não vou comer a Páscoa de novo até que todos os que Deus governa realmente percebam o que ela representa.” ");
INSERT INTO portft_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Então ele pegou um copo de vinho. Deu graças a Deus por ele. Depois ele disse, “Tomem isto e bebam todos um pouco dele. ");
INSERT INTO portft_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Quero que vocês saibam que de agora em diante não vou beber vinho até que Deus me faça rei/chefe.” ");
INSERT INTO portft_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Então ele pegou pão. Deu graças a Deus pelo pão. Depois ele o quebrou em pedaços e deu a eles para comerem. Ele disse, “Este pão representa o meu corpo, que estou para sacrificar por vocês. Continuem a comer pão desta maneira para lembrarem-se do que tenho feito por vocês.” ");
INSERT INTO portft_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","De modo semelhante, depois deles jantarem, ele pegou outro copo de vinho. Ele disse, “O vinho neste copo representa meu sangue que vou derramar quando morrer. Este sangue vai confirmar/selar a nova aliança que Deus está fazendo com vocês. ");
INSERT INTO portft_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mas observem que aquele que vai ajudar meus inimigos a me prender está comendo aqui comigo. ");
INSERT INTO portft_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Quero que saibam que embora eu seja aquele que vim do céu, vou morrer como Deus planejou. Mas ai daquele homem que vai me trair/ajudar os meus inimigos a me prenderem!” ");
INSERT INTO portft_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aí eles começaram a perguntar uns aos outros, “Quem entre nós faria tal coisa?” ");
INSERT INTO portft_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Os apóstolos começaram a discutir entre si, “Qual de nós vai ser o maior quando Jesus se tornar rei?” ");
INSERT INTO portft_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Então Jesus disse a eles, “Os reis dos não judeus gostam de mostrar que são poderosos. Mesmo assim eles dão a si mesmos o título, Aqueles que ajudam o povo. ");
INSERT INTO portft_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mas vocês não devem ser como eles! Pelo contrário, aquele que quer que Deus o considere o maior deve agir como se fosse o menor/mais novo, porque o costume é que os mais novos servem os mais idosos. O líder deve ser quem serve aos outros. ");
INSERT INTO portft_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Guardem em mente quem é/Quem é o mais importante. Certamente é aquele que somente se senta à mesa, não aqueles que servem a refeição. Mas eu, o seu líder, tenho servido de exemplo para vocês, ao estar entre vocês como aquele que serve vocês. ");
INSERT INTO portft_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Vocês são os que têm ficado comigo durante todas as minhas dificuldades. ");
INSERT INTO portft_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Agora pois, assim como meu Pai me tem escolhido para governar como rei/chefe, estou escolhendo vocês ");
INSERT INTO portft_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","para que possam sentar-se e comer e governar comigo quando eu me tornar rei. Vocês vão se sentar em tronos para julgar as doze tribos de Israel conforme a sua aceitação ou rejeição de mim como o Messias (OU, para governar sobre eles). ");
INSERT INTO portft_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simão, Simão, escute! Satanás tem pedido a Deus, e Deus o tem permitido separar aqueles entre vocês que vão continuar a crer em mim daqueles que não vão continuar a crer em mim, assim como um homem peneira o trigo para separar o trigo da palha. ");
INSERT INTO portft_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mas tenho orado por você, Simão, para que você não deixe totalmente de crer em mim. Portanto quando você restaurar o seu relacionamento comigo, ajude seus irmãos apóstolos a confiarem mais em mim!” ");
INSERT INTO portft_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro disse a ele, “Senhor, estou pronto para ir com o senhor se eles colocarem o senhor na prisão, ou até mesmo para morrer com o senhor!” ");
INSERT INTO portft_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus respondeu, “Pedro, quero que você saiba que esta mesma noite, antes do galo cantar, você vai negar três vezes que me conhece!” ");
INSERT INTO portft_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Então Jesus perguntou a todos eles, “Depois que mandei vocês a outras aldeias, e vocês foram sem levar dinheiro nem sacola nem sandálias extras, faltavam-lhes qualquer coisa?” Eles responderam, “Não, nós (excl) não carecemos de nada.” ");
INSERT INTO portft_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aí, para mostrar a eles que agora muitos iam se opor a eles/eles precisavam estar preparados para se cuidarem de si mesmos, ele disse a eles, “Agora, as coisas vão ser diferentes. Portanto, aquele entre vocês que tem dinheiro deve levá-lo consigo. Da mesma forma, ele deve levar uma sacola de viajante. Aquele que não tem espada deve vender seu casaco e comprar uma espada. ");
INSERT INTO portft_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Porque, digo a vocês agora, algo precisa acontecer comigo para cumprir as palavras que um profeta escreveu: Eles o trataram como se fosse um criminoso. Lembrem-se de que tudo que eles têm escrito de mim nas Escrituras precisa ser cumprido.” ");
INSERT INTO portft_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Os discípulos disseram, “Senhor, olhe! Nós (excl) temos duas espadas!” Percebendo que eles não entenderam o significado do que ele tinha dito, ele respondeu a eles, “Basta de falar em espadas!” ");
INSERT INTO portft_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Quando Jesus saíu da cidade, foi, como era seu costume, ao monte das oliveiras. Seus discípulos foram com ele. ");
INSERT INTO portft_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Quando chegou ao lugar onde costumava ir/passar a noite, ele disse a eles, “Orem que Deus os ajude quando algo tenta vocês a não crerem mais em mim. ");
INSERT INTO portft_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Aí ele se afastou deles a uma distância de mais ou menos 30 metros/a distância que alguém pode jogar uma pedra. Ele se ajoelhou e orou, ");
INSERT INTO portft_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Meu Pai, se o senhor estiver disposto, permita que eu não tenha que passar por este tempo de sofrimento. Porém não faça o que eu desejo; faça o que o senhor deseja.” ");
INSERT INTO portft_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Então um anjo do céu apareceu a ele e o fez ficar mais forte. ");
INSERT INTO portft_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ele estava muito angustiado. Então orou ainda mais honestamente. Seu suor caiu no chão como se fosse grandes gotas de sangue. ");
INSERT INTO portft_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Quando se levantou de orar, ele voltou aos seus discípulos. Ele viu que estavam dormindo. Eles estavam exaustos porque estavam tão tristes. ");
INSERT INTO portft_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ele os acordou e disse a eles, “Estou desapontado/triste que vocês estejam/por que é que estão dormindo! Levantem-se! Orem para que Deus ajude vocês quando algo tentar vocês!” ");
INSERT INTO portft_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Enquanto Jesus ainda falava, uma multidão chegou a ele. Judas, mesmo que fosse um dos doze discípulos, estava guiando-os. Ele chegou perto de Jesus e o beijou para mostrar àqueles que estavam com ele qual deles era Jesus. ");
INSERT INTO portft_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesus disse a ele, “Judas, estou triste que é/é por meio de me beijar como se você me amasse que você está ajudando meus inimigos a me prender/capturar, aquele que vim do céu!” ");
INSERT INTO portft_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Quando os discípulos que estavam perto de Jesus deram conta do que ia acontecer, eles disseram, “Senhor, devemos (excl) bater neles com as espadas?” ");
INSERT INTO portft_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Um deles bateu no escravo do sumo sacerdote com uma espada para matá-lo, mas somente cortou sua orelha direita. ");
INSERT INTO portft_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mas Jesus disse, “Não faça mais disso!” Ele tocou na orelha do escravo e o curou. ");
INSERT INTO portft_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Então Jesus disse aos principais sacerdotes, os oficiais da guarda do templo e os anciãos dos judeus que tinham chegado para prendê-lo, “Dia trás dia eu estava com vocês no templo, mas vocês não me prenderam! ");
INSERT INTO portft_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Portanto é ridículo que vocês/então por que é que vocês vieram aqui com tacapes e espadas para me prender, como se eu fosse bandido! Mas esta é a hora quando Deus está permitindo que vocês façam o que querem. Também é a época de Satanás, que reina/governa na escuridão, fazer o que ele quer. ");
INSERT INTO portft_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Eles prenderam Jesus e o levaram embora. Eles o levaram à casa do sumo sacerdote. Pedro os seguiram à distância. ");
INSERT INTO portft_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Acenderam um fogo no meio do pátio e se sentaram juntos. Pedro sentou-se entre eles. ");
INSERT INTO portft_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Enquanto a luz da fogueira brilhava no rosto dele, uma empregada o viu e olhou fixamente para ele. Ela disse, “Este homem também estava com o homem que eles prenderam!” ");
INSERT INTO portft_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mas ele negou isso dizendo, “Senhora, eu não o conheço!” ");
INSERT INTO portft_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pouco depois outra pessoa viu pedro e disse, “Você também era um daqueles que estava com o homem que eles prenderam!” Mas Pedro disse, “homem, eu não sou um deles!” ");
INSERT INTO portft_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mais ou menos uma hora depois outra pessoa disse enfaticamente de pedro, “O modo deste homem falar mostra que ele é do distrito da Galileia. Certamente este homem estava com o homem que eles prenderam!” ");
INSERT INTO portft_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mas Pedro disse, “Homem, não sei de que você está falando!” Imediatamente, enquanto ele ainda falava, um galo cantou. ");
INSERT INTO portft_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","O Senhor Jesus voltou-se e olhou diretamente para Pedro. Pedro lembrou-se do que o Senhor tinha dito a ele antes, “Hoje à noite, antes do galo cantar, você vai negar três vezes que me conhece.” ");
INSERT INTO portft_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ele saiu do pátio e chorou com grande tristeza. ");
INSERT INTO portft_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Os homens que estavam guardando Jesus bateram nele e zombaram dele. ");
INSERT INTO portft_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Eles cobriram os olhos dele e bateram nele de novo. Então eles disseram a ele, “Já que você diz que é profeta, prove isso dizendo para nós quem foi que bateu em você!” ");
INSERT INTO portft_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Disseram muitas outras coisas ruins a respeito dele, insultando-o. ");
INSERT INTO portft_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Quando a manhã seguinte amanheceu, muitos dos líderes judaicos se juntaram. O grupo incluía os principais sacerdotes e os homens que ensinavam as leis judaicas. Eles o levaram à assembleia dos judeus. Ali disseram a ele, ");
INSERT INTO portft_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Se você é o Messias, diga-nos!” Mas ele respondeu, “Se eu disser isso a vocês, vocês não vão me acreditar. ");
INSERT INTO portft_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Se eu perguntar a vocês o que pensam do Messias, vocês não vão me responder. ");
INSERT INTO portft_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mas um dia vocês vão ver a mim, que vim do céu, sentado ao lado do Deus Altíssimo e reinando!” ");
INSERT INTO portft_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Então eles disseram, “Se for assim, então você está dizendo que é o Filho de Deus/homem que também é Deus?” Ele disse a eles, “É justamente assim como vocês dizem.” ");
INSERT INTO portft_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aí eles disseram uns aos outros, “Nós (inc) certamente não precisamos/por que é que devíamos pedir para mais pessoas darem testemunho contra ele! Nós mesmos O temos ouvido dizer que ele é igual a Deus!” ");
INSERT INTO portft_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aí o grupo inteiro se levantou e o levou a Pilatos, o governador. ");
INSERT INTO portft_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Eles começaram a acusá-lo dizendo, “Nós (excl) temos achado que este sujeito tem causado problemas políticos no nosso país. Ele tem dito às pessoas que não devem pagar impostos ao governo romano. Também, ele diz que é o Messias, um rei. ");
INSERT INTO portft_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatos perguntou a ele, “O senhor diz que quer ser o rei que governa sobre os judeus?” Ele respondeu, “É o senhor que diz (OU, é como o senhor diz).” ");
INSERT INTO portft_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatos disse aos principais sacerdotes e ao resto do grupo, “Não concluo que este homem seja culpado de nenhum crime pelo qual eu deva castigá-lo.” ");
INSERT INTO portft_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mas eles continuaram a insistir, dizendo, “Ele está incitando as pessoas a se rebelarem! Ele anda ensinando as suas ideias por todo o distrito da Judeia. Ele começou a fazer isso no distrito da Galileia e agora ele está fazendo aqui. ");
INSERT INTO portft_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Quando Pilatos ouviu isso, ele perguntou, “Este homem é do distrito da Galileia?” ");
INSERT INTO portft_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Quando eles disseram a ele que Jesus era da Galileia, que era o distrito governado por Herodes Antipas, ele disse para eles levarem Jesus a Herodes, porque Herodes estava em Jerusalém naquele tempo. ");
INSERT INTO portft_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Então fizeram isso. Quando Herodes viu Jesus, ele estava muito contente. Ele tinha ouvido falar de Jesus, e fazia muito que esperava ver Jesus fazer algum milagre. ");
INSERT INTO portft_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Então ele fez muitas perguntas a Jesus, mas Jesus não respondeu a nenhuma das perguntas. ");
INSERT INTO portft_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Os principais sacerdotes e os homens que ensinavam as leis judaicas ficaram em pé perto dele, acusando-o muito/veemente. ");
INSERT INTO portft_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Aí Herodes e seus soldados zombaram de Jesus. Colocaram roupas bonitas/elegantes nele para fazerem pouco dele como rei. Depois Herodes o mandou de volta para Herodes. ");
INSERT INTO portft_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Até aquele tempo Herodes e Pilatos eram inimigos, mas naquele mesmo dia eles se tornaram amigos. ");
INSERT INTO portft_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Então Pilatos reuniu os principais sacerdotes e outros líderes dos judeus e a multidão que ainda estava por ali. ");
INSERT INTO portft_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ele disse a eles, “Vocês me trouxeram este homem dizendo que ele tinha causado problemas entre o povo. Mas quero que vocês saibam que depois de examiná-lo enquanto vocês estavam ouvindo, eu não concluo que ele seja culpado de nenhuma das coisas de que vocês o acusam. ");
INSERT INTO portft_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Sei que Herodes também não concluiu isso, porque ele o mandou de volta para mim sem castigá-lo. Está claro que este homem não tem feito nada pelo qual nós (inc) devemos matá-lo. ");
INSERT INTO portft_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Portanto, vou mandar os meus soldados bater nele e depois soltá-lo.  ");
INSERT INTO portft_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Todos os anos na festa da Páscoa Pilatos tinha que soltar um prisioneiro para o povo. ");
INSERT INTO portft_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mas a multidão toda gritou, “Execute/mate este homem! Solte Barrabás para nós/como nós (excl) temos pedido!” ");
INSERT INTO portft_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás era um homem que tinha tentado incitar as pessoas na cidade a se rebelarem contra o governo romano. Enquanto fazia isso ele tinha matado alguém. Por isso eles o tinham colocado na prisão, onde ele estava esperando até que eles o executassem. ");
INSERT INTO portft_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Porque Pilatos queria soltar Jesus, ele tentou outra vez convencer a multidão. ");
INSERT INTO portft_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mas eles continuaram a gritar, “mande seus soldados matá-lo colocando-o em uma cruz! ");
INSERT INTO portft_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Uma terceira vez ele perguntou a eles, “Por que? O que ele tem feito de errado? Eu tenho determinado que ele não tem feito nada errado pelo qual merece morrer. Por isso vou mandar meus soldados bater nele e soltá-lo.” ");
INSERT INTO portft_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mas eles continuaram a insistir. Gritaram em voz bem alta que ele devia mandar seus soldados pregar Jesus em uma cruz. Em fim, seus gritos ganharam.  ");
INSERT INTO portft_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Então Pilatos resolveu fazer o que eles pediram. ");
INSERT INTO portft_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","O homem que eles tinham colocado na prisão por ele ter se rebelado contra o governo e matado alguém, ele soltou! Foi este o homem que a multidão tinha pedido para ele soltar. Ele entregou Jesus às mãos dos soldados, para fazerem o que a multidão quis. ");
INSERT INTO portft_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Enquanto os soldados estavam levando Jesus, Agarraram em um homem chamado Simão, que era da cidade de Cirene, na África. Ele estava voltando do campo para a cidade. Eles tiraram de Jesus a cruz que tinha estado carregando. Então eles a colocaram nos ombros de Simão, e disseram a ele para levá-la atrás de Jesus. ");
INSERT INTO portft_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Uma grande multidão seguiu Jesus. A multidão incluía muitas mulheres, que estavam batendo nos seios para mostrar como estavam tristes, e chorando por ele. ");
INSERT INTO portft_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mas Jesus virou-se para elas e disse, “Vocês mulheres de Jerusalém, não chorem por mim! Pelo contrário, chorem por aquilo que vai acontecer com vocês e com seus filhos! ");
INSERT INTO portft_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Quero que vocês saibam que em breve haverá um tempo quando as pessoas vão dizer, As mulheres que nunca tiveram filhos nem amamentaram nenês são felizes! ");
INSERT INTO portft_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Então, para que elas não tenham que aguentar o sofrimento quando seus inimigos destruirem esta cidade, elas vão dizer às montanhas, Caiam sobre nós! E as pessoas vão dizer aos montes, Cubram-nos! ");
INSERT INTO portft_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Eu sou inocente. Sou como uma árvore viva que as pessoas não deviam tentar queimar. Mas o povo de Jerusalém merece que seus inimigos o castiguem. Eles são como a madeira seca que está pronta para queimar. Então se eles me pregarem na cruz, os inimigos deles/Deus certamente vão/vai fazer coisas bem piores/o que é que seus inimigos/Deus vão/vai fazer com eles!” ");
INSERT INTO portft_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Os soldados também levaram embora dois outros homens que eram criminosos. Eles iam executá-los com Jesus. ");
INSERT INTO portft_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Quando chegaram ao lugar que as pessoas chamam “A Caveira” depois de tirar as roupas de Jesus, eles o pregaram em uma cruz. Fizeram o mesmo com os dois criminosos. Colocaram um no lado direito de Jesus e um no lado esquerdo. ");
INSERT INTO portft_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesus disse, “Meu Pai, perdoe-os, porque não entendem a quem estão fazendo isso. Então os soldados tiraram a sorte com dados para repartirem a sua roupa. ");
INSERT INTO portft_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Muitas pessoas ficaram por ali, observando estes acontecimentos. Os líderes judaicos zombaram de Jesus, dizendo, “Ele disse que salvava outras pessoas! Se ele for o Messias, aquele que Deus escolheu, deve salvar-se a si mesmo!” ");
INSERT INTO portft_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Os soldados também zombaram do fato dele dizer-se rei. Chegaram até ele e ofereceram a ele somente um pouco de vinho azedo. ");
INSERT INTO portft_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Disseram a ele, “Se você é rei dos judeus, salve-se!” ");
INSERT INTO portft_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Eles também prenderam na cruz acima de sua cabeça um sinal que indicava por que estavam pregando-o em uma cruz. O que escreveram no cartaz foi, Este é o rei dos judeus. ");
INSERT INTO portft_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Um dos criminosos que estava pendurado em uma cruz começou a insultá-lo dizendo, “Já que você disse que era o Messias, você deve ter poder! Portanto, salve-se a si mesmo, e salve-nos também!” ");
INSERT INTO portft_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mas o outro criminoso o repreendeu, dizendo, “Você deve ter/você não tem medo de Deus castigar você! Eles estão castigando a ele e a nós da mesma forma. ");
INSERT INTO portft_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Eles decidiram com razão que nós (inc) dois devemos morrer. Estão nos castigando assim como merecemos pelas coisas más que fizemos. Mas este homem não tem feito nada de errado!” ");
INSERT INTO portft_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Então ele disse, “Jesus, por favor, lembre-se de mim e cuide de mim quando se tornar rei!” ");
INSERT INTO portft_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus respondeu, “Quero que você saiba que hoje você vai estar comigo no paraíso/no lugar onde todos estão felizes!” ");
INSERT INTO portft_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Já era mais ou menos meio-dia. Ficou escuro por toda aquela região até três horas da tarde. ");
INSERT INTO portft_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Não havia luz do sol/o sol não brilhava. Então a cortina grossa e pesada que ficava pendurada no templo na frente do lugar santíssimo rasgou- se em dois. Isso significava que agora as pessoas comuns podiam entrar na presença de Deus no lugar santíssimo do templo.  ");
INSERT INTO portft_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Enquanto isso aconteceu, Jesus gritou em voz bem alta, “Pai, eu me ponho/ponho meu Espírito nas suas mãos!” Depois de dizer isso, ele deixou de respirar e morreu. ");
INSERT INTO portft_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Quando o oficial do exército que comandava os soldados que estavam executando Jesus viu o que aconteceu, ele louvou a Deus. Ele disse, “Estou certo de que este homem não tinha feito nada de errado!” ");
INSERT INTO portft_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Quando a multidão de pessoas que tinha se juntado para ver esses eventos viu o que aconteceu, todos voltaram para casa, batendo nos peitos para mostrar a sua tristeza. ");
INSERT INTO portft_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Todos os amigos de Jesus, inclusive as mulheres que tinham vindo com ele do distrito da Galileia, estavam em pé à uma distância, e viram tudo que aconteceu. ");
INSERT INTO portft_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Havia um homem chamado José que era da cidade de Arimateia na Judeia. Ele era homem justo e correto. Era membro do Conselho dos judeus. ");
INSERT INTO portft_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mas ele não tinha concordado com os outros membros do Conselho quando resolveram matar Jesus e quando planejaram como fazer isso. Ele esperava com grande expectativa que o rei ((que era de)) Deus começasse a governar. ");
INSERT INTO portft_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ele foi a Pilatos e pediu que Pilatos lhe permitisse levar o corpo de Jesus e enterrá-lo. Depois de Pilatos permitir que ele fizesse isso,  ");
INSERT INTO portft_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ele e alguns outros tiraram o corpo de Jesus da cruz. Eles o embrulharam em um lençol de linho. Então eles colocaram o corpo dele em um túmulo que ele/outros tinha/tinham cavado em uma rocha alta. Ninguém tinha colocado um corpo ali antes. ");
INSERT INTO portft_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tinham que fazer isso rápido, porque foi sexta-feira, o dia quando prepararam tudo para o sábado. O sábado ia começar ao pôr-do-sol, e têm que terminar todo o trabalho antes do pôr-do-sol.  ");
INSERT INTO portft_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","As mulheres que tinham vindo com Jesus do distrito da Galileia seguiram José e os homens que estavam com ele. Eles viram o túmulo, e viram como os homens deitaram o corpo dele ali dentro. ");
INSERT INTO portft_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Então as mulheres voltaram para suas casas. Na noite seguinte elas prepararam perfumes e óleos para passar no corpo de Jesus, mas no sábado elas descansaram, conforme o que Moisés tinha mandado. ");
INSERT INTO portft_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Antes do amanhecer no domingo, as mulheres foram ao túmulo. Levaram consigo os perfumes que tinham preparado para passar no corpo de Jesus. ");
INSERT INTO portft_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Elas descobriram que alguém tinha retirado a pedra da entrada do túmulo. ");
INSERT INTO portft_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Entraram no túmulo, mas o corpo de Jesus não estava ali! ");
INSERT INTO portft_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Elas não sabiam o que pensar disso. Aí de repente dois homens ficaram em pé perto delas, vestidos de roupas bem brilhantes! ");
INSERT INTO portft_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","As mulheres estavam com medo. Quando elas se prostraram/ajoelharam no chão, os dois homens disseram a elas, “Vocês não deviam/por que é que estão procurando em um lugar onde enterram pessoas mortas alguém que está vivo! ");
INSERT INTO portft_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ele não está aqui, ele já tornou a viver! Lembrem-se que quando ele ainda estava com vocês no distrito da Galileia ele disse a vocês, ");
INSERT INTO portft_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mesmo que eu seja aquele que vim do céu, alguém vai ajudar homens pecadores/maus a me prenderem. Eles vão me matar colocando-me em uma cruz. Mas dois/três dias depois eu vou viver de novo. ");
INSERT INTO portft_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","As mulheres se lembraram dessas palavras. ");
INSERT INTO portft_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Então elas saíram do túmulo e foram aos onze apóstolos e os outros discípulos dele e disseram essas coisas a eles. ");
INSERT INTO portft_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","As que diziam essas coisas aos apóstolos eram Maria da aldeia da Magdala, Joana, Maria a mãe de Tiago, e as outras mulheres que estavam com elas. ");
INSERT INTO portft_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mas eles pensavam que o que as mulheres diziam era bobagem. Eles não acreditaram o que diziam as mulheres. ");
INSERT INTO portft_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mas Pedro se levantou e correu ao túmulo. Ele se abaixou e olhou dentro do túmulo. Ele viu os lençóis de linho em que tinham enrolado o corpo de Jesus. Os lençóis estavam sós (OU, ele não viu outra coisa). Então ele foi para casa, querendo saber o que tinha acontecido. ");
INSERT INTO portft_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Aquele mesmo dia dois dos discípulos de Jesus estavam caminhando para uma aldeia chamada Emaús. Ficava a mais ou menos onze quilômetros de Jerusalém. ");
INSERT INTO portft_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Eles estavam falando entre si sobre todas as coisas que tinham acontecido a Jesus. ");
INSERT INTO portft_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Enquanto falavam e discutiam essas coisas, Jesus mesmo aproximou-se e começou a falar com eles. ");
INSERT INTO portft_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mas Deus/algo os impediu de reconhecê-lo. ");
INSERT INTO portft_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesus disse a eles, “O que é que vocês dois estão discutindo enquanto caminham?” Eles pararam, e seus rostos pareciam muito tristes. ");
INSERT INTO portft_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Um deles, que se chamava Cleopas, disse, “O senhor deve ser/será que o senhor é o único que está visitando Jerusalém para a festa da Páscoa e que não sabe dos eventos que têm acontecido ali por estes dias!” ");
INSERT INTO portft_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ele disse a eles, “Que eventos?” Eles responderam, “As coisas que aconteceram a Jesus, o homem de Nazaré, que era profeta. Muitas pessoas o viram fazer grandes milagres, e Deus o ajudou a ensinar mensagens maravilhosas! ");
INSERT INTO portft_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mas nossos principais sacerdotes e líderes o entregaram às autoridades romanas. As autoridades o condenaram à morte, e o mataram pregando-o em uma cruz. ");
INSERT INTO portft_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nós (excl) esperávamos que ele fosse quem libertaria a nós, o povo de Israel, dos nossos inimigos. Mas agora isso não parece possível, porque já passaram três dias desde que estas coisas aconteceram. ");
INSERT INTO portft_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Por outro lado, algumas mulheres do nosso grupo nos surpreenderam. Hoje cedo de manhã elas foram ao túmulo, ");
INSERT INTO portft_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","mas o corpo de Jesus não estava ali! Elas voltaram e disseram que tinham visto uns anjos em uma visão. Os anjos disseram que ele estava vivo! ");
INSERT INTO portft_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aí alguns daqueles que estavam conosco foram ao túmulo. Eles viram que as coisas estavam assim como as mulheres tinham dito. Mas eles não viram Jesus.” ");
INSERT INTO portft_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ele disse a eles, “Vocês dois são homens tolos! Vocês demoram tanto para crer tudo que os profetas têm escrito sobre o Messias. ");
INSERT INTO portft_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Vocês certamente deviam saber/Não foi necessário que o Messias sofresse todas essas coisas e morresse, e depois entrasse no seu lar glorioso no céu!/?” ");
INSERT INTO portft_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Então ele explicou a eles todas as coisas que os profetas tinham escrito nas Escrituras sobre ele. Ele começou com o que Moisés escreveu e depois disse a eles o que todos os outros profetas escreveram. ");
INSERT INTO portft_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Chegaram perto da aldeia onde os dois homens iam. Ele indicou que ia mais além, ");
INSERT INTO portft_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","mas eles insistiram com ele para que não fizesse isso. Eles disseram, “Fique conosco hoje à noite, porque é tarde e logo vai ficar escuro. Então ele entrou na casa para ficar com eles. ");
INSERT INTO portft_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Quando eles se sentaram para comer, ele pegou pão. Deu graças a Deus por ele e pediu que Deus o abençoasse. Ele partiu e deu alguns pedaços a eles. ");
INSERT INTO portft_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Então Deus fez com que eles o reconhecessem. Mas logo ele desapareceu! ");
INSERT INTO portft_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Eles disseram entre si, “Quando ele nos ajudou a entender as Escrituras ao falar conosco enquanto nós (excl) andávamos pelo caminho, nós ficamos tão agitados que era como se um fogo ardesse/queimasse dentro de nós! Não devemos ficar aqui; devemos ir contar aos outros o que aconteceu!”  ");
INSERT INTO portft_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Saíram logo e voltaram a Jerusalém. Acharam ali os onze apóstolos e outros que tinham se reunido com eles. ");
INSERT INTO portft_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Eles disseram a esses dois homens, “É verdade que o Senhor já tornou a viver, e ele apareceu a Simão/Pedro!” ");
INSERT INTO portft_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Então esses dois homens disseram aos outros o que tinha acontecido enquanto estavam andando pelo caminho. Também falaram a eles como os dois o tinham reconhecido quando ele partiu um pouco de pão para eles. ");
INSERT INTO portft_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Enquanto falavam isso, Jesus mesmo de repente apareceu entre eles. Ele disse a eles, “Que Deus dê a vocês paz interior!” ");
INSERT INTO portft_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Eles ficaram assustados e com medo, porque pensavam que estavam vendo um fantasma! ");
INSERT INTO portft_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ele disse a eles, “Vocês não devem estar/por que é que estão assustados! E vocês não devem duvidar/por que é que duvidam que eu seja vivo! ");
INSERT INTO portft_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Olhem as feridas nas minhas mãos e nos meus pés! Vocês podem tocar em mim e ver o meu corpo. Então podem ver que sou eu mesmo. Podem saber que sou realmente vivo, pois os fantasmas não têm corpos, como vocês veem que eu tenho!” ");
INSERT INTO portft_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Depois dele dizer isso, ele mostrou a eles as feridas nas suas mãos e nos seus pés. ");
INSERT INTO portft_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Eles estavam alegres e admirados, mas ainda não creram que ele realmente era vivo/o que eles estavam vendo. Então ele disse a eles, “Vocês têm aqui alguma coisa para comer?” ");
INSERT INTO portft_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aí eles deram a ele um pedaço de peixe cozido. ");
INSERT INTO portft_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Enquanto eles olhavam, ele o pegou e comeu. ");
INSERT INTO portft_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Então ele disse a eles, “Vou repetir o que eu disse a vocês quando ainda estava com vocês: Tudo que Moisés escreveu de mim e que os profetas escreveram de mim e que escreveram a meu respeito nos salmos precisa acontecer/ser cumprido!” ");
INSERT INTO portft_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Então ele os ajudou a entender as coisas que aqueles que escreveram as Escrituras tinham escrito a respeito dele. ");
INSERT INTO portft_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ele disse a eles, “É isso que escreveram: que o Messias ia sofrer e morrer, mas no terceiro dia depois disso ele ia viver de novo. ");
INSERT INTO portft_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Eles também escreveram que os seguidores dele precisam pregar a mensagem de que as pessoas devem abandonar seus pecados, e que Deus ia perdoar os pecados deles se eles fizessem isso. Escreveram que os seguidores dele precisam pregar essa mensagem, na autoridade dele. Escreveram que eles devem começar em Jerusalém, e depois ir pregar a todos os grupos étnicos. ");
INSERT INTO portft_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Vocês apóstolos devem dizer às pessoas que sabem que essas coisas que aconteceram comigo são a verdade. ");
INSERT INTO portft_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Quero que saibam que vou mandar o Espírito Santo a vocês, assim como meu Pai prometeu que faria. Mas vocês precisam ficar nesta cidade até que Deus os encha do poder do Espírito dele.” ");
INSERT INTO portft_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Então Jesus os guiou para fora da cidade até que chegaram perto da aldeia da Betânia. Ali ele levantou as mãos e os abençoou. ");
INSERT INTO portft_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Enquanto fazia isso, ele os deixou e subiu para o céu. ");
INSERT INTO portft_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Eles o adoraram. Então voltaram para Jerusalém com muita alegria. ");
INSERT INTO portft_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Todos os dias eles foram ao pátio do templo, e passaram muito tempo louvando a Deus. ");
INSERT INTO portft_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aquele que expressa —MET o caráter de Deus/como é Deus— tem existido sempre —desde o começo MTY de tudo/antes que tudo começasse. Ele existia sempre com Deus e possuía a natureza de Deus. ");
INSERT INTO portft_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ele existia sempre com Deus antes de começar MTY a criar qualquer coisa. ");
INSERT INTO portft_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Foi Ele por quem Deus fez com que tudo existisse. Foi Ele que criou absolutamente tudo. ");
INSERT INTO portft_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","É Ele que fez com que tudo vivesse. Ele, que fez com que existíssemos nós, os seres humanos, revelou-nos a verdade sobre Deus, como uma luz MET revela o que existe na escuridão.  ");
INSERT INTO portft_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","As pessoas não querem que Ele revele que elas estão praticando o mal MET, como é má a escuridão. Mas bem como a escuridão não pode apagar a luz MET, as pessoas ruins nunca conseguem impedir que aquele que era como uma luz revele a verdade de Deus. (OU, as pessoas malignas nunca conseguem entender aquele que era como uma luz). ");
INSERT INTO portft_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Um homem chamado João foi enviado por Deus {Deus mandou um homem chamado João}. ");
INSERT INTO portft_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ele veio falar às pessoas daquele que era como MET uma luz. Ele veio mostrar que era verdade tudo que dizia aquele que era como uma luz MET, para poder capacitar todos os seres humanos a crerem naquele que era como uma luz.  ");
INSERT INTO portft_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","João mesmo não era aquele que era como uma luz MET. Mas ele veio falar aos outros sobre aquele que era como uma luz. ");
INSERT INTO portft_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Enquanto João fazia isso, aquele que era realmente como uma luz estava para vir ao mundo. Foi Ele que capacita todas as pessoas a saberem de Deus, como uma luz MET capacita as pessoas a saberem o que existe na escuridão. ");
INSERT INTO portft_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Embora aquele que era como uma luz estivesse aqui na terra, e embora fosse Ele a quem Deus fez criar tudo, a maioria das pessoas nem se deu conta —que era Ele/que Ele tinha vindo de Deus— (OU, não O aceitou). ");
INSERT INTO portft_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mesmo que Ele tivesse vindo ao seu próprio mundo/àquilo que lhe pertencia por Ele tê-lo criado, a maioria dos membros do seu próprio povo, os judeus, O rejeitou (OU, não O aceitou). ");
INSERT INTO portft_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mas a nós que O acolhemos, Deus nos autorizou a ter com Ele, Deus MET, o tipo de relacionamento que as crianças têm com seu pai. Fomos pessoas que acreditávamos que era verdade aquilo que Ele dizia acerca de si mesmo MTY. ");
INSERT INTO portft_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nós nos tornamos como filhos de Deus, não por pertencerem nossos antepassados a Deus, ou como consequência do desejo sexual, nem porque algum homem quisesse ter filhos parecidos com Ele. Pelo contrário, Deus fez com que {nos tornássemos} como filhos dele. ");
INSERT INTO portft_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Aquele que expressa MET —o caráter de Deus/como é Deus— se tornou um ser humano, e viveu por algum tempo entre nós. Como resultado disso, vemos como Ele é maravilhoso. Não há outra pessoa maravilhosa, vinda de Deus seu pai. Ele foi maravilhoso porque sempre —agiu bondosamente para conosco/de uma forma que não merecíamos— e sempre nos falava com verdade acerca de Deus. ");
INSERT INTO portft_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Certo dia, quando João falava dele às pessoas, ele viu Jesus. Então ele gritou a eles, “Eu lhes disse antes que viria mais tarde uma pessoa mais importante que eu, por ter existindo muito antes de mim. É este o homem de quem lhes falei”!  ");
INSERT INTO portft_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Todos nós temos recebido grandes benefícios daquilo que Ele tem feito. Repetidas vezes Ele tem agido — bondosamente para conosco/de uma forma que não merecíamos. ");
INSERT INTO portft_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Deus fez com que suas leis fossem proclamadas por Moisés {fez com que Moisés proclamasse as leis dele} a nossos antepassados. Mas aquilo que Jesus Cristo fez por nós foi muito melhor. Deus fez com que Ele agisse —bondosamente para conosco/de uma forma que não merecíamos— e nos contasse a verdade acerda de Deus.  ");
INSERT INTO portft_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ninguém nunca viu Deus. Mas o único filho dele, Jesus, quem tem tido sempre um relacionamento muito íntimo com Deus, tem nos falado sobre Deus. ");
INSERT INTO portft_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Os líderes judaicos SYN na cidade de Jerusalém mandaram alguns sacerdotes e —levitas/homens que trabalhavam no templo— para lá para fazerem perguntas ao João. Eles disseram a ele, “O que você afirma sobre si mesmo?” ");
INSERT INTO portft_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Por isso João lhes disse a verdade, e falou claramente DOU. Ele disse, “Não sou —o Messias/rei escolhido de Deus”! ");
INSERT INTO portft_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Então eles lhe perguntaram, “Então o que você afirma sobre si mesmo? Você é por acaso o profeta Elias que —alguém/um profeta— vaticinou que voltaria antes do Messias?” Ele respondeu, “Não, não sou”. Então eles lhe perguntaram, “Você é o profeta parecido com Moisés que —estamos esperando/Deus prometeu mandar?” Ele respondeu, “Não”. ");
INSERT INTO portft_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Portanto eles lhe perguntaram, “E quem você diz que é, então? Diga-nos, para que possamos voltar e explicar àqueles que nos mandaram. O que você afirma sobre si mesmo?” ");
INSERT INTO portft_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","João respondeu, “Sou aquele que o profeta Isaías vaticinou, que iria proclamar esta mensagem em voz alta aos transeuntes nesta região deserta: ‘Preparem-se para receber o Senhor quando Ele vier, MET como as pessoas preparam o caminho para um importante oficial’”.  ");
INSERT INTO portft_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Alguns daqueles que interrogavam ao João tinham sido mandados pelo grupo religioso dos fariseus {que o grupo religioso dos fariseus tinha mandado}. ");
INSERT INTO portft_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Eles perguntaram ao João, “Já que você diz que não é o Messias, nem o profeta Elias, nem o profeta parecido com Moisés, que autoridade você tem para batizar os judeus, tratando-os como se fossem gentios?” ");
INSERT INTO portft_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","João respondeu, “Estou apenas batizando as pessoas nas águas para prepará-las para acolher o Messias. Mas agora mesmo há aqui entre vocês alguém que vocês nem conhecem. ");
INSERT INTO portft_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ele vai pregar a vocês após minha saída. Ele é tão importante que eu nem mereço servi-lo como um escravo MET que solta as sandálias dele”. ");
INSERT INTO portft_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Essas coisas aconteceram num lugar chamada Betânia, na margem oriental do Rio Jordão, onde João batizava as pessoas. ");
INSERT INTO portft_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","No dia seguinte, João viu Jesus se aproximando. Ele disse ao povo, “Olhem! Aqui vem o homem quem Deus nomeou para ser um sacrifício MET, como os cordeiros que o povo de Israel sacrifica! Sacrificando-se a si mesmo, Ele vai capacitar todas as pessoas do mundo a ficarem livres da culpa de terem pecado. ");
INSERT INTO portft_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","É Ele de quem eu disse antes, “Virá mais tarde uma pessoa mais importante que eu, por ter existido muito antes de mim”. ");
INSERT INTO portft_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Eu mesmo nem reconheci anteriormente que era Ele o Messias. Mas agora sei quem Ele é, e batizei as pessoas nas águas para que vocês, o povo de Israel, pudessem {que eu pudesse capacitar vocês israelitas a} reconhecer quem Ele é”. ");
INSERT INTO portft_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","João falou claramente sobre aquilo que Deus lhe tinha mostrado acerca de Jesus. Ele disse, “Vi o Espírito de Deus que descia do céu em forma de pomba. O Espírito pousava sobre Ele. ");
INSERT INTO portft_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Eu mesmo não sabia antes que era Ele o Messias. Porém, Deus, que me enviou a batizar as pessoas nas águas por afirmarem que desejavam abandonar seus maus caminhos, me disse, “O homem sobre quem você vir descer e pousar meu Espírito é aquele que vai infundir-lhes o Espírito Santo para realmente transformar suas vidas”. ");
INSERT INTO portft_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Vi o Espírito descer sobre Ele, e agora lhes digo que Ele é —o Filho de Deus/o homem que é também Deus”. ");
INSERT INTO portft_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","No dia seguinte, João estava novamente no mesmo lugar com dois de nós/seus discípulos. ");
INSERT INTO portft_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ao ver Jesus passar, ele disse, “Olhem! Lá vai o homem que Deus nomeou para ser um sacrifício, como os cordeiros MET que os israelitas sacrificam”!  ");
INSERT INTO portft_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ao ouvirmos/ouvirem João dizer isso, nós/os dois discípulos fomos/foram ter com Jesus. ");
INSERT INTO portft_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus voltou e (n)os viu. Então Ele perguntou, “O que vocês desejam?” Nós/Eles respondemos/responderam, “Mestre, diga-nos onde o Senhor está hospedado, pois desejamos falar consigo”.  ");
INSERT INTO portft_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ele respondeu, “Venham comigo, e verão onde estou hospedado”! Por isso fomos/foram com Ele e vimos/viram onde Ele estava hospedado. Nós/Eles ficaram com Ele até às 16h00 (OU, desde as 16h00 até o dia seguinte). ");
INSERT INTO portft_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Um de nós/dos dois homens que ouvimos/ouviram o que João tinha dito, e acompanhamos/acompanharam Jesus, foi André, irmão menor de Simão Pedro. ");
INSERT INTO portft_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Depois que André saiu de onde estava Jesus, foi ter imediatamente com seu irmão mais velho, Simão, dizendo-lhe, “Acabamos de encontrar o Messias”! ");
INSERT INTO portft_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Então ele levou Simão para Jesus. Jesus olhou fixamente para ele. Então disse, “Você é Simão. Seu pai se chama João. Você receberá {Eu vou lhe dar} o nome ‘Pedro’, que significa ‘rocha/pedra firme’”. ");
INSERT INTO portft_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","No dia seguinte, Jesus resolveu deixar o vale do Rio Jordão. Dirigiu-se ao distrito da Galileia e lá encontrou um homem chamado Filipe. Jesus lhe disse, “Venha comigo”! ");
INSERT INTO portft_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipe e André e Pedro eram todos da cidadezinha de Betsaida. ");
INSERT INTO portft_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Então Filipe foi ter com Natanael e lhe disse, “Encontramos aquele que foi prometido por Moisés nas Escrituras, aquele que Deus iria mandar! Os profetas também vaticinaram que Ele viria. É Jesus, da cidadezinha de Nazaré. O pai dele se chama José”. ");
INSERT INTO portft_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael respondeu, “Nazaré? —Nada de bom pode vir/Pode vir algo de bom— RHQ de um lugar tão sem importância!?” Respondeu Filipe, “Venha ver”! ");
INSERT INTO portft_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Quando Jesus viu Natanael, que se aproximava dele, comentou sobre ele, “Aqui se vê um exemplo de um bom israelita! Ele nunca engana as pessoas”! ");
INSERT INTO portft_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael lhe perguntou, “Como é que o Senhor sabe como sou eu?” Jesus respondeu, “Vi você antes de Filipe o chamar, quando você estava sentado, meditando sozinho, debaixo da figueira”. ");
INSERT INTO portft_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Então Natanael declarou, “Mestre, o Senhor deve ser o —Filho de Deus/homem que é também Deus! O Senhor é o Rei de Israel que aguardamos”! ");
INSERT INTO portft_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus lhe respondeu, “Você/Será que você— RHQ acredita isso sobre mim porque eu lhe disse que o tinha visto quando ainda estava debaixo da figueira, mesmo que estivesse lá sozinho. Mas você vai ver-me fazer coisas ainda mais surpreendentes que isso”! ");
INSERT INTO portft_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Então Jesus disse a ele, “Escute o seguinte: Bem como aquilo que seu antepassado Jacó viu há muito tempo numa visão, vocês vão ver abrir-se o céu, e verão os anjos de Deus subindo de mim e descendo sobre mim, aquele que veio do céu”. ");
INSERT INTO portft_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dois dias depois, houve um(a) banquete/festa de casamento na cidadezinha de Caná, no distrito da Galileia. Estava presente a mãe de Jesus. ");
INSERT INTO portft_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Também comparecemos Jesus e nós os discípulos dele, pois tínhamos sido convidados {alguém nos tinha convidado} também. ");
INSERT INTO portft_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bebido todo o vinho pelos convidados, a mãe de Jesus lhe disse, “Agora não há mais vinho; Você pode remediar a situação?” ");
INSERT INTO portft_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus lhe disse, “Mãe/Senhora, não me diga/por que a Senhora RHQ me diz o que devo fazer. Deixe- me cuidar da situação. Ainda não chegou a hora MTY de eu mostrar que sou o Messias pela operação de milagres”. ");
INSERT INTO portft_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Então a mãe de Jesus disse aos servos, “Façam tudo o que Ele mandar”! ");
INSERT INTO portft_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Havia ali perto seis potes de pedra. Os judeus despejavam água neles para a lavagem de objetos para os tornar aceitáveis a Deus. Cada pote continha de 80 a 120 litros. ");
INSERT INTO portft_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus disse aos servos, “Encham os potes de água”! E eles encheram os potes até a borda. ");
INSERT INTO portft_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Então Jesus disse a eles, “Agora, tirem um pouco da água e levem ao dirigente/garçom/chefe da festa”. E os servos assim fizeram. ");
INSERT INTO portft_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","O dirigente/garçom/chefe da festa provou da água, que acabara de se transformar em vinho. Ele não sabia da origem desse vinho, mas os servos que o tinham tirado do pote sabiam. O vinho foi uma delícia! Por isso ele chamou o noivo ");
INSERT INTO portft_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","e lhe disse, “Todos costumam servir primeiro o melhor vinho. Então, quando os convidados tiverem bebidos o suficiente para não saberem diferenciar o bom do ruim, eles servem o vinho inferior. Mas você não procedeu como os outros. Você guardou o melhor vinho até agora”! ");
INSERT INTO portft_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Foi esse o primeiro milagre operado por Jesus. Ele fez esse milagre na cidadezinha de Caná, no distrito da Galileia. Assim, Ele mostrou seu grande poder, e como resultado nós seus discípulos chegamos a crer que Ele era realmente o Messias. ");
INSERT INTO portft_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jesus desceu à cidade de Cafarnaum em companhia da sua mãe, seus irmãos mais jovens e nós seus discípulos. Ficamos ali vários dias. ");
INSERT INTO portft_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mais tarde, quase nas vésperas da Páscoa Judaica, Jesus e nós seus discípulos subimos a Jerusalém. ");
INSERT INTO portft_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","No pátio do templo Ele viu alguns homens que vendiam gado, ovelhas e pombas para os sacrifícios. Viu também uns homens sentados às mesas, tirando grande lucro pelo troco das moedas romanas por moedas especiais para o pagamento do imposto do templo.  ");
INSERT INTO portft_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Então Jesus fez um chicote de cordas e passou a usá-lo para afugentar as ovelhas e o gado do pátio do templo. Ao virar as mesas dos cambistas, Ele espalhou as moedas deles. ");
INSERT INTO portft_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Disse àqueles que vendiam pombas, “Tirem essas pombas daqui! Não poluam mais o templo do meu Pai, fazendo dele um mercado”! ");
INSERT INTO portft_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Então nós discípulos nos lembramos que foram escritas as seguintes palavras {que alguém/Davi tinha escrito estas palavras} nas Escrituras, vaticinando o que o Messias iria dizer: “Outros PRS vão opor-se fortemente a mim porque desejo de todo coração que as pessoas respeitem seu templo”. ");
INSERT INTO portft_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Por isso os líderes judaicos SYN lhe responderam, “Que milagre você vai praticar para nos mostrar que Deus O autorizou a fazer estas coisas?” ");
INSERT INTO portft_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus lhes respondeu, “Se/Quando vocês destruírem este templo, vou reconstruí-lo novamente em três dias”. ");
INSERT INTO portft_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Por isso os líderes judaicos SYN disseram, “Faz 46 anos que este templo está em construção {que estamos construindo este templo}, e ainda não está completo! Portanto não há jeito de você/como você pretendeRHQ construi-lo em três dias”! ");
INSERT INTO portft_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mas quando Jesus se referia ao templo, Ele falava realmente do seu próprio corpo. ");
INSERT INTO portft_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Portanto vários anos depois, após Jesus morrer e tornar-se vivo novamente, nós seus discípulos nos lembramos das palavras que Ele tinha dito. Como consequência, demos fé àquilo que as Escrituras tinham vaticinado sobre o Messias ressuscitar, e cremos que aquilo que Jesus dizia era verdade. ");
INSERT INTO portft_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Enquanto Jesus estava em Jerusalém na festa da Páscoa, muitas pessoas passaram a crer que era Ele o Messias por presenciarem os milagres que Ele praticava. ");
INSERT INTO portft_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mas Ele não deixava que elas lhe ditassem o que, como Messias, Ele deveria fazer, pois Ele sabia no seu íntimo o que todas aquelas pessoas estavam pensando. ");
INSERT INTO portft_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ele não precisava de ninguém para lhe explicar o que os outros estavam pensando, pois Ele já sabia o que eles pensavam e desejavam. ");
INSERT INTO portft_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Havia um homem chamado Nicodemos, que era membro do conselho religioso judaico. Ele pertencia à seita religiosa dos fariseus. ");
INSERT INTO portft_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nicodemos foi consultar Jesus de noite, para conversar com Ele sobre o reino de Deus. Ele disse a Jesus, “Mestre, cremos que você é um mestre vindo de Deus. Cremos isso porque sabemos que só uma pessoa que esteja recebendo a ajuda de Deus pode fazer os milagres que você faz”. ");
INSERT INTO portft_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus lhe respondeu, “Escute o seguinte: A menos que as pessoas nasçam de novo e tenham uma nova vida recebida de Deus, não podem experimentar o governo de Deus MET nas suas vidas”.  ");
INSERT INTO portft_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Então Nicodemos lhe disse, “Ninguém pode/Como se pode— RHQ nascer, estando já velho! —Não há jeito de se/Ele não pode— RHQ voltar para o ventre da mãe e nascer novamente”! ");
INSERT INTO portft_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus respondeu, “Escute o seguinte: Não basta nascer fisicamente. As pessoas precisam também nascer espiritualmente pelo Espírito de Deus. Se isso não acontecer, elas não podem experimentar o governo de Deus MET nas suas vidas.  ");
INSERT INTO portft_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Se alguém nasce como resultado daquilo que os seres humanos fazem, ele se torna um ser humano. Mas se uma pessoa nasce de novo como resultado daquilo que o Espírito de Deus faz, essa pessoa recebe uma nova natureza espiritual. ");
INSERT INTO portft_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Não fique admirado por eu lhe dizer que deve nascer de novo e ter uma nova vida recebida de Deus.  ");
INSERT INTO portft_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Deixe-me dar- lhe um exemplo. O vento sopra onde quiser soprar. Você ouve o som do vento, mas não sabe de onde ele vem nem para onde vai. De forma semelhante, não podemos controlar/vaticinar como as pessoas vão nascer de novo como resultado daquilo que o Espírito de Deus faz”.  ");
INSERT INTO portft_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemos respondeu a Ele, “Como é que isso pode acontecer?” ");
INSERT INTO portft_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus lhe respondeu, “Você é um mestre bem conhecido entre nós israelitas, portanto — surpreende-me/como pode ser— RHQ que você não entenda estas coisas!? ");
INSERT INTO portft_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Escute bem agora: —Meus discípulos e eu/Eu— explicamos/explico a vocês as coisas que temos visto e sabemos ser verdade, mas vocês não reconhecem que aquilo que dizemos é verdade. ");
INSERT INTO portft_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Já lhes falei das coisas verdadeiras que acontecem aqui na terra, mas vocês não confiam em mim. Portanto, se eu lhe falar das coisas que acontecem no céu, —com certeza você não/como é que você vai— RHQ acreditar o que digo! ");
INSERT INTO portft_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Sou o único que subiu ao céu. Ninguém mais subiu até lá. Sou também aquele que desceu do céu, e por isso sei o que acontece lá.  ");
INSERT INTO portft_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Há muito tempo, quando o povo de Israel se rebelou contra Deus no deserto, Deus mandou cobras venenosas para picá-los. Mas quando a imagem duma cobra venenosa foi levantada em uma estaca por Moisés {quando Moisés levantou em uma estaca a imagem duma cobra venenosa}, todos aqueles que olharam fixamente naquela imagem foram curados. Semelhantemente, mesmo que eu seja aquele que veio do céu, algum dia as pessoas vão levantar-me, colocando-me em uma cruz para me matar.  ");
INSERT INTO portft_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Como resultado, todos os que crerem/confiarem em mim vão viver eternamente”. ");
INSERT INTO portft_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Deus nos amou tanto a nós, os habitantes do mundo, que deu seu único Filho como sacrifício por nós, para que todos os que crerem/confiarem nele possam não ficar separados de Deus para sempre. Pelo contrário, eles vão viver para sempre. ");
INSERT INTO portft_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Quando Deus mandou seu Filho ao mundo, não foi para castigar os habitantes MTY do mundo por seus pecados. Pelo contrário, Ele O mandou para que eles pudessem ser salvos por Ele {Ele pudesse salvá-los} de serem culpados/punidos por seus pecados.  ");
INSERT INTO portft_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","A todos os que confiarem no seu Filho, Deus diz que não serão castigados {Ele não vai castigá-los}. Mas Deus já disse que todos os que não confiarem no seu Filho serão punidos {que Ele vai punir todos os que não confiarem no seu Filho}, pois eles não confiam naquilo que o único Filho dele fez por eles.  ");
INSERT INTO portft_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","É esta a razão porque Deus vai julgar as pessoas e dizer que deve puni-las: Aquele que era como uma luz MET para revelar-nos a verdade de Deus já veio ao mundo. Mas as pessoas amavam aquilo que era mau como é má a escuridão MET, ao invés de amarem aquele que é como uma luz, pois eram iníquas as práticas delas. ");
INSERT INTO portft_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Todos os que praticam o mal odeiam aquele que é como uma luz, e não se achegarão àquele que é como uma luz, pois seria revelado {aquele que é como uma luz iria revelar}que são iníquas as práticas deles, e os repreenderia..  ");
INSERT INTO portft_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mas aqueles que vivem de acordo com a verdade de Deus se achegam àquele que é como uma luz, para que seja visto {as pessoas possam ver} claramente que as práticas deles foram realizadas {que eles realizaram suas práticas} por dependerem de Deus. ");
INSERT INTO portft_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Algum tempo depois, Jesus e nós discípulos nos dirigimos ao distrito da Judeia. Ele ficou conosco ali e nos orientava enquanto batizávamos as pessoas. ");
INSERT INTO portft_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","João o Batizador também estava batizando as pessoas. Ele batizava na aldeia Enom, perto da cidadezinha de Salim no distrito de Samaria, por haver ali muitas fontes de água. Muitas pessoas iam ter com João e eram batizadas {ele as batizava}. ");
INSERT INTO portft_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Isso aconteceu antes que João fosse preso {eles colocassem João no cárcere}. ");
INSERT INTO portft_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Então alguns dos discípulos de João e um certo judeu passaram a argumentar sobre os rituais de lavagem dos objetos para torná-los aceitáveis a Deus.  ");
INSERT INTO portft_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Então aqueles discípulos se dirigiram a João e lhe disseram, “Mestre, você se lembra do homem que estava consigo quando batizava as pessoas lá do outro lado do Rio Jordão? É Ele de quem você nos falava. Pois bem, agora Ele está batizando pessoas, e muitos estão seguindo a Ele em vez de nos acompanharem”! ");
INSERT INTO portft_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","João respondeu, “A gente pode ficar importante só se lhe for permitido por Deus MTY {se Deus MTY assim permitir}. Portanto, vocês não devem ter ciúmes de Jesus por Ele ser popular!  ");
INSERT INTO portft_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Vocês mesmos podem verificar aquilo que eu disse. Eu lhes expliquei que não sou —o Messias/rei prometido por Deus. Pelo contrário, eu lhes disse que fui enviado {que Deus me enviou} para ir adiante dele. ");
INSERT INTO portft_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Deixem-me dar um exemplo: MET Ele é como um —noivo/homem que vai casar—, e eu sou como o amigo do noivo. O amigo do noivo fica do lado de fora da casa, esperando a chegada dele. Ele fica muito contente ao ouvir a voz do noivo que vem chegando. Da mesma forma, fico bem contente ao ouvir aquilo que vocês acabam de me dizer.  ");
INSERT INTO portft_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","É preciso que Ele fique cada vez mais importante, ganhando mais discípulos do que eu, e que eu fique cada vez menos importante”. ");
INSERT INTO portft_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jesus veio do céu. Ele é mais importante do que qualquer outro. Aqueles que nascem de pais humanos aqui na terra MTY são apenas humanos, e eles falam das coisas que acontecem aqui na terra. Mas, tendo sua origem no céu, —Ele/as palavras dele— é/são mais importante(s) que qualquer/quaisquer outro/outras. ");
INSERT INTO portft_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ele comunica às pessoas aquilo que Ele viu e ouviu no céu, mas bem poucas pessoas HYP escutam o que Ele diz. ");
INSERT INTO portft_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Aqueles que aceitam o que Ele diz, verificam que aquilo que Deus disse é realmente verdade. ");
INSERT INTO portft_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Sabemos que é verdade porque Jesus, aquilo que Deus mandou, comunica a mensagem de Deus. É também verdade porque Deus faz com que o Espírito dele habite em Jesus para orientar plenamente tudo que Ele diz.  ");
INSERT INTO portft_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Deus ama seu Filho, e faz com que Ele tenha controle/poder sobre tudo. ");
INSERT INTO portft_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Aqueles que confiam no Filho de Deus já começaram a viver eternamente. Mas aqueles que rejeitam o Filho de Deus nunca irão experimentar a vida eterna. Pelo contrário, Deus está zangado com eles e com certeza vai castigá-los. ");
INSERT INTO portft_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Naquela altura, muitas pessoas pediam que Jesus as batizasse. Ele não quis fazê-lo, mas nós os discípulos dele batizamos muitas pessoas. Mas alguns do grupo religioso dos fariseus ouviram as pessoas dizerem que Jesus tinha conseguido mais discípulos que João o Batizador e os batizava, portanto eles ficaram bem ciumentos.  ");
INSERT INTO portft_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Quando o Senhor Jesus ouviu isso, saiu do distrito da Judeia e voltou conosco, seus discípulos, ao distrito da Galileia, para evitar possíveis problemas causados pelos fariseus. ");
INSERT INTO portft_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ele resolveu que lhe seria preciso viajar pelo distrito da Samaria. ");
INSERT INTO portft_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Por isso chegamos numa cidadezinha chamada Sicar, no distrito da Samaria. Ficava perto do terreno que nosso antepassado Jacó tinha dado há muito tempo ao seu filho José.  ");
INSERT INTO portft_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","O poço que pertencia antigamente a Jacó ficava naquele terreno. Jesus estava cansado de andar. Portanto, enquanto nós discípulos entramos na cidadezinha para comprar comida, Ele ficava sentado perto do poço. Por volta do meio-dia, uma mulher que morava ali na Samaria veio buscar água do poço. Jesus lhe disse, “Quer me dar um pouco de água do poço para beber?” Os judeus não gostam de tocar coisas que pertencem aos/se aproximam dos samaritanos, ");
INSERT INTO portft_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","portanto a mulher da Samaria disse a Ele, “O Senhor é judeu, e eu sou da Samaria, e mais, sou mulher. Por isso surpreende-me/como é possível RHQ que o Senhor me peça um gole de água!/?” ");
INSERT INTO portft_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus respondeu a ela, “Se você soubesse o que Deus quer lhe dar, e se soubesse quem sou Eu, aquele que lhe pede um gole de água, você teria pedido a mim, e eu lhe teria dado da água que sustenta a vida”. ");
INSERT INTO portft_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ela pensou que Ele estivesse falando da água da correnteza. Por isso ela lhe disse, “O Senhor não tem balde nem corda, e o poço é bem fundo. De onde, pois, vai tirar a água que sustenta a vida? ");
INSERT INTO portft_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nosso antepassado Jacó nos deixou este poço. Ele bebeu água dele, e havia ali tanta água boa que seus filhos e rebanhos de ovelhas também beberam dela. O Senhor se acha mais importante que Jacó, para poder nos dar água que sustenta a vida?” ");
INSERT INTO portft_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus lhe respondeu, “Todos os que bebem água deste poço voltarão a ter sede mais tarde. ");
INSERT INTO portft_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mas aqueles que beberem da água que eu lhes dou nunca mais terão sede. Pelo contrário, a água que eu lhes dou será no interior deles como uma fonte de água que os capacita a viver eternamente”. ");
INSERT INTO portft_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","A mulher não entendeu que Jesus se referia, de forma figurada, a algo que a sustentaria espiritualmente. Portanto ela disse a Ele, “Senhor, dê-me desse tipo de água, para eu não ter mais sede nem precisar voltar sempre para cá buscar água”! ");
INSERT INTO portft_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus sabia que ela não entendeu, mas quis mostrar-lhe, pelo seu conhecimento da sua vida íntima, que–por ser Ele o Messias—podia suprir suas necessidades espirituais. Por isso Ele lhe disse, “Senhora, vá chamar seu marido e trazê-lo para cá”! ");
INSERT INTO portft_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ela respondeu, “Não tenho marido”! Jesus lhe disse, “Você disse que não tem marido, e é verdade. ");
INSERT INTO portft_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Também é verdade que já teve cinco maridos, um após outro. E o homem com quem vive atualmente não é seu marido! Realmente, você disse a pura verdade”. ");
INSERT INTO portft_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","A mulher lhe disse, “Senhor, entendo que o Senhor deve ser profeta, pois consegue descobrir os segredos das pessoas. ");
INSERT INTO portft_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mas deixe-me fazer-lhe outra pergunta: Nossos antepassados adoravam a Deus aqui no monte Gerazim, mas vocês judeus afirmam que Jerusalém é o lugar onde devemos adorar a Deus. Então, qual dos grupos tem razão?” ");
INSERT INTO portft_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus lhe disse, “Senhora, pode me crer quando afirmo que virá um dia quando não terá importância que se adore a Deus o Pai neste monte, ou em Jerusalém ou em outro local.  ");
INSERT INTO portft_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Vocês samaritanos não conhecem aquele que adoram. Mas nós (excl) judeus sabemos a quem adoramos, pois é de nós judeus que Deus mandou aquele que vai salvar as pessoas da culpa dos seus pecados.  ");
INSERT INTO portft_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Contudo, virá um dia quando aqueles que realmente adoram a Deus vão adorá-lo como o Espírito dele mandar e de acordo com a verdade dele/minha verdade. De fato, aquela hora já chegou. São esses os adoradores que meu Pai busca. ");
INSERT INTO portft_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Deus é um ser espiritual. Portanto, é preciso que aqueles que O adorarem O adorem como mandar o Espírito dele e conforme a verdade de Deus/minha verdade”. ");
INSERT INTO portft_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A mulher lhe disse, “Sei que virá o Messias. (Os dois termos ‘Messias’ e ‘Cristo’ significam ‘o rei prometido por Deus’.) Quando Ele vier, vai dizer-nos tudo que precisamos saber”. ");
INSERT INTO portft_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus lhe disse, “Eu, que estou falando com você, sou o Messias”! ");
INSERT INTO portft_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nesse instante, nós discípulos voltamos da cidadezinha. Sendo contrário ao nosso costume os mestres religiosos judaicos conversarem com mulheres, ficamos surpresos ao ver Jesus falando com uma mulher. Porém, nenhum de nós perguntou à mulher, “O que você deseja?”, nem perguntou a Jesus, “Por que o Senhor está falando com ela?” ");
INSERT INTO portft_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Então a mulher deixou ali o pote de água que tinha, e voltou para a cidade. Ela disse às pessoas que moravam ali, ");
INSERT INTO portft_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Venham ver um homem que pôde me dizer tudo da minha vida passada HYP, mesmo que eu nunca o tivesse conhecido antes! Será Ele o Messias?” ");
INSERT INTO portft_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Por isso muitas pessoas saíram da cidadezinha e se foram para onde estava Jesus. ");
INSERT INTO portft_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Entretanto, nós discípulos o instávamos, “Mestre, coma um pouco desta comida que lhe trouxemos”!  ");
INSERT INTO portft_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mas Ele nos disse, “Tenho para comer uma comida que vocês nem conhecem”! ");
INSERT INTO portft_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Por isso começamos a perguntar-nos uns aos outros, “Com certeza, ninguém/Será que alguém RHQ lhe trouxe comida durante nossa ausência!?” ");
INSERT INTO portft_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus nos disse, “Fazer o que meu pai, que me enviou, deseja que eu faça, e completar a obra que Ele me confiou, é o que me sustenta/como minha comida. ");
INSERT INTO portft_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nesta época do ano, vocês estão dizendo (OU, seus antepassados costumavam dizer), “Ficam ainda quatro meses até a colheita”. Mas eu lhes digo, olhem cuidadosamente os não judeus que andam por aqui. Deus diz, “Eles estão prontos para aceitar minha mensagem MET, como as plantas na roça que estão prontas para serem ceifadas. ");
INSERT INTO portft_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Se vocês os capacitarem a aceitar minha mensagem, vou premiar vocês MET, como o dono de um campo recompensa aqueles que fazem a colheita. Por causa do labor de vocês, as pessoas vão viver eternamente”. Eu tenho anunciado a mensagem de Deus às pessoas. Será como MET fazer a colheita. Quando isso acontecer, vocês e eu vamos regozijar-nos juntos. ");
INSERT INTO portft_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Como resultado, vai se tornar verdade o seguinte provérbio: Uma pessoa planta a semente, mas outros fazem a colheita. ");
INSERT INTO portft_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mando vocês para capacitar as pessoas a aceitarem minha mensagem, mas vocês não serão os primeiros a contar-lhes a mensagem de Deus. Outros já trabalharam arduamente para contar a mensagem de Deus às pessoas, e agora vocês vão colher os frutos do trabalho deles”. ");
INSERT INTO portft_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Muitos dos habitantes do distrito da Samaria que moravam naquela cidadezinha passaram a crer que Jesus era o Messias por terem ouvido o que aquela mulher tinha dito sobre Jesus, “Aquele homem conseguiu me falar de toda minha vida passada HYP”! ");
INSERT INTO portft_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Por isso, quando aqueles samaritanos vieram ter com Ele, insistiram em que Ele ficasse com eles. Portanto ficamos lá um par de dias. ");
INSERT INTO portft_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Muitos mais deles creram em Jesus/que era Ele o Messias por causa da mensagem dele. ");
INSERT INTO portft_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Eles disseram àquela mulher, “Cremos agora em Jesus, mas não somente por causa daquilo que você nos disse. Agora nós mesmos temos ouvido a mensagem dele. Como resultado, sabemos que este homem realmente é aquele que pode salvar todas as pessoas do mundo da culpa dos seus pecados”. ");
INSERT INTO portft_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Jesus tinha dito antes que as pessoas não honravam os profetas como Ele quando estes tentavam ensinar as pessoas na sua própria vizinhança. Portanto, dois dias depois disso Jesus e nós discípulos deixamos aquela região e nos dirigimos à região dele, no distrito da Galileia, pois Ele sabia que os habitantes dali não teriam dele uma opinião tão alta que fosse provocar os ciúmes dos líderes judaicos.  ");
INSERT INTO portft_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Contudo, ao chegarmos no distrito da Galileia, muitos dos habitantes o acolheram, pois estiveram em Jerusalém durante a festa da Páscoa, e tinham visto todas as coisas que Ele fazia lá. ");
INSERT INTO portft_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesus se dirigiu novamente à cidadezinha de Caná no distrito da Galileia. Foi ali que, anteriormente, Ele tinha transformado a água em vinho. Lá estava um dos oficiais do rei, que morava na cidade de Cafarnaum e cujo filho estava muito doente. ");
INSERT INTO portft_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Quando aquele oficial ouviu outros dizerem que Jesus tinha voltado do distrito da Judeia ao distrito da Galileia. ele foi ter com Jesus em Caná e lhe rogou, “Venha comigo a Cafarnaum, por favor, e cure meu filho, que está às portas da morte”! ");
INSERT INTO portft_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus disse a ele, “Se vocês não me virem fazer diversos milagres, nunca vão acreditar minha mensagem”!  ");
INSERT INTO portft_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mas o oficial lhe disse, “Senhor, eu creio em você/que você veio de Deus. Por isso, é favor descer à minha casa antes de meu filho morrer”! ");
INSERT INTO portft_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus lhe disse, “Então você pode voltar para casa. Seu filho vai viver/não vai morrer”! O homem acreditou o que Jesus tinha dito, e saíu. ");
INSERT INTO portft_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","No dia seguinte, enquanto ele caminhava para casa, seus servos foram ao seu encontro. Eles lhe disseram, “Seu filho está recuperando”! ");
INSERT INTO portft_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ele lhes perguntou, “A que horas meu filho começou a melhorar?” Eles lhe disseram, “A febre começou a baixar ontem pela tarde, por volta das 13h00 ”. ");
INSERT INTO portft_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Então o pai do jovem se deu conta de que foi essa a mesma hora em que Jesus lhe tinha dito, “Seu filho vai viver/não morrer”. Por isso, ele e todas as pessoas que moravam em sua casa passaram a crer que Jesus era o Messias. ");
INSERT INTO portft_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Foi esse o segundo milagre que Jesus fez no distrito da Galileia, após voltar do distrito da Judeia. ");
INSERT INTO portft_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Algum tempo depois, Jesus subiu a Jerusalém, onde os judeus celebravam outra festa. ");
INSERT INTO portft_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Em um dos portões da cidade, chamado Portão das Ovelhas, havia um tanque. Na língua falada pelos judeus, esse tanque se chamava “Betezata”. Ao redor do tanque havia cinco áreas abertas, cobertas de teto. ");
INSERT INTO portft_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Muitas pessoas costumavam ficar deitadas lá. Havia pessoas cegas, coxas e paralíticas. ");
INSERT INTO portft_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Um daqueles que estava lá deitado era paralítico fazia trinta e oito anos. ");
INSERT INTO portft_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Quando Jesus o viu deitado lá, alguém lhe avisou de que o homem estava assim havia muito tempo. Ele disse ao homem, “Você quer ficar curado?” ");
INSERT INTO portft_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","O paralítico lhe respondeu, “Sim, Senhor, quero ficar bom, mas não há ninguém para me ajudar a descer no tanque quando a água se mexe. Quando tento entrar no tanque, outra pessoa sempre se adianta e entra primeiro”. ");
INSERT INTO portft_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus disse a ele, “Levante- se! Pegue a sua esteira e ande”! ");
INSERT INTO portft_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","O homem foi curado nesse instante. Ele pegou a sua esteira e começou a andar! O dia da semana em que isto aconteceu foi sábado. Mais tarde, algumas pessoas que achavam errado carregar objetos no sábado viram esse homem. Portanto o levaram aos líderes judaicos.  ");
INSERT INTO portft_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Os líderes judaicos disseram ao homem que tinha sido curado, “Hoje é sábado, e na nossa lei judaica está escrito que as pessoas não devem carregar objetos no sábado, portanto você não deve estar carregando a sua esteira”! ");
INSERT INTO portft_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","O homem lhes respondeu, “O homem que me curou, esse homem mesmo me disse, ‘Pegue a sua esteira e ande!’ ");
INSERT INTO portft_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Eles lhe perguntaram, “Quem é o homem que lhe disse, ‘Pegue-a e ande!’?” ");
INSERT INTO portft_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mas o homem não sabia quem foi que o tinha curado, pois Jesus tinha desaparecido na multidão sem dizer-lhe como se chamava. ");
INSERT INTO portft_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mais tarde, Jesus viu o homem quando estavam no pátio do templo. Ele disse seu nome ao homem, e também lhe disse, “Escute! Você é curado! Portanto, deixe de pecar! Se não deixar de pecar, vai lhe acontecer algo pior que a doença que antes tinha”!  ");
INSERT INTO portft_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","O homem se foi, e avisou os líderes SYN judaicos de que era Jesus a pessoa que o tinha curado. ");
INSERT INTO portft_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Por isso os líderes SYN judaicos começaram a perseguir Jesus, pois Ele fazia estas coisas no sábado. ");
INSERT INTO portft_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Então Jesus lhes respondeu, “Até agora meu Pai tem trabalhado constantemente todos os dias da semana, inclusive no sábado. Eu estou fazendo a mesma coisa”! ");
INSERT INTO portft_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Por isso os líderes SYN judaicos procuravam mais assiduamente uma maneira de matá-lo. Eles desejavam matá-lo por considerar que Ele desobedecia os regulamentos deles no tocante ao dia de sábado. Outrossim, afirmando que Deus era seu Pai, Ele se fazia igual a Deus, e eles achavam que deviam matar qualquer indivíduo que dissesse tais coisas. ");
INSERT INTO portft_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesus lhes respondeu, dizendo o seguinte: “Prestem bem atenção ao que digo: Não posso fazer nada por meu/minha próprio/própria poder/autoridade. Faço apenas os tipos de coisas que vejo meu Pai fazer. As coisas que meu Pai estiver fazendo, eu também as faço. ");
INSERT INTO portft_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Meu Pai me ama, e Ele me mostra tudo o que faz. Ele vai me mostrar coisas milagrosas que Ele quer que eu faça, coisas que serão ainda maiores que estas que vocês já me viram fazer, de tal forma que vocês vão ficar pasmados. ");
INSERT INTO portft_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Por exemplo, assim como meu Pai faz os defuntos ressuscitarem, ficando novamente vivos, eu vou dar a vida eterna a todos aqueles que eu quiser. ");
INSERT INTO portft_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","E mais, meu Pai não é aquele que julga as pessoas de acordo com seus pecados. Pelo contrário, Ele me incumbiu de julgar os seres humanos, ");
INSERT INTO portft_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","para que todas as pessoas possam me honrar justamente como honram meu Pai. Deus acha que aqueles que não me honrarem tampouco honram meu Pai, aquele que me enviou. ");
INSERT INTO portft_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Escutem agora o seguinte: Aqueles que ouvirem minha mensagem e crerem que foi Deus quem me enviou, têm a vida eterna. Deus não vai condená-los/dizer que vai castigá-los por seus pecados. Eles já não ficarão separados de Deus. Pelo contrário, eles já começaram a viver eternamente. ");
INSERT INTO portft_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Prestem bem atenção ao seguinte: Virá um dia quando aqueles que estiverem espiritualmente mortos/separados de Deus ouvirão minha voz, a voz do Filho de Deus/homem que é também Deus. De fato, já chegou esse dia. Aqueles que ouvirem e estiverem atentos à minha mensagem vão viver eternamente. ");
INSERT INTO portft_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Meu Pai tem poder para fazer as coisas viverem. Da mesma forma, Ele me concedeu o poder de capacitar as pessoas a viverem eternamente.  ");
INSERT INTO portft_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Sendo eu aquele que veio do céu, Ele também me deu autoridade para julgar as pessoas de acordo com seus pecados.  ");
INSERT INTO portft_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Não fiquem surpresos por isso, pois virá um dia quando todos os mortos ouvirão a minha voz. ");
INSERT INTO portft_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Eles vão se levantar. Aqueles que tiverem vivido boas vidas se levantarão e viverão para sempre. Mas aqueles que tiverem vivido vidas más se levantarão e vou condená-los/declarar que vou castigá-los por seus pecados. ");
INSERT INTO portft_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Não faço nada assim por minha própria autoridade. Julgo as pessoas apenas de acordo com aquilo que ouço meu Pai me dizer. Vou julgar as pessoas retamente, pois não quero apenas agradar a mim mesmo. Pelo contrário, desejo agradar meu Pai, que me enviou. ");
INSERT INTO portft_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Se eu fosse o único a falar de mim mesmo, as pessoas poderiam dizer com razão que aquilo que digo não é verdade. ");
INSERT INTO portft_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mas há mais alguém que fala de mim às pessoas. E sei que aquilo que Ele lhes diz sobre mim é verdade. ");
INSERT INTO portft_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Quanto a vocês, quando enviaram certas pessoas a João o Batizador para indagar sobre mim, ele disse a verdade sobre mim.  ");
INSERT INTO portft_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Não preciso que as pessoas falem aos outros sobre mim. Pelo contrário, estou lembrando vocês daquilo que João disse sobre mim às pessoas, para que possam ser salvas {Deus possa salvá-las} por crerem nele.  ");
INSERT INTO portft_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","A mensagem de João sobre mim {OU, João} MET foi como uma lamparina que brilha bem forte. Por um breve período, vocês estavam dispostos a ficar contentes por causa daquela mensagem {deixar que aquela mensagem os tornasse felizes}. ");
INSERT INTO portft_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mas há outra coisa que lhes fala de mim. Deve provar quem sou ainda melhor que aquilo que João disse acerca de mim. Os milagres PRS que meu Pai me mandou fazer, os milagres que estou fazendo, provam às pessoas que meu Pai me mandou. ");
INSERT INTO portft_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Além disso, meu Pai, que me enviou, fala de mim às pessoas. Vocês nunca ouviram a voz dele nem O viram. ");
INSERT INTO portft_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Além disto, vocês não acreditaram em mim, aquele que Ele enviou. Portanto, vocês não acreditaram a mensagem dele no seu interior. ");
INSERT INTO portft_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Vocês estudam cuidadosamente as Escrituras, pois acham que, pela leitura delas, vocês vão descobrir o caminho para a vida eterna. Mas aquelas Escrituras falam de mim às pessoas! ");
INSERT INTO portft_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mas vocês recusam vir a mim/crer minha mensagem para que possam ter a vida eterna. ");
INSERT INTO portft_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Não me importa se as pessoas me louvam. ");
INSERT INTO portft_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mas com vocês é bem diferente. Sei que, no seu interior, vocês não amam a Deus. ");
INSERT INTO portft_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mesmo que eu tenha vindo à terra com autoridade do meu Pai MTY, vocês não me aceitam. Mas se outra pessoa vem com sua própria autoridade MTY, vocês aceitam essa pessoa! ");
INSERT INTO portft_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Vocês aceitam o louvor mútuo, mas não procuram fazer as coisas que resultarão no louvor que Deus mesmo lhes dá. Por isso não há jeito de vocês acreditarem/como vocês poderão acreditar RHQ em mim/minha mensagem!? ");
INSERT INTO portft_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mas não pensem que seja eu quem vai acusar vocês, enquanto meu Pai ficar escutando. Não, quem vai acusá-los é Moisés. Vocês achavam que ele iria defendê-los.  ");
INSERT INTO portft_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Já que ele escreveu sobre mim, se vocês tivessem acreditado aquilo que Moisés escreveu, teriam acreditado aquilo que eu disse.  ");
INSERT INTO portft_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mas, já que não acreditaram aquilo que ele escreveu sobre mim, não há jeito de vocês acreditarem/como vocês vão acreditar RHQ aquilo que digo!?” ");
INSERT INTO portft_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Algum tempo depois, na altura da festa da Páscoa judaica, Jesus foi de barco conosco, seus discípulos, atravessando até a margem oposta/oriental do Lago da Galileia. Esse lago também é chamado de Tiberíades. ");
INSERT INTO portft_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Uma grande multidão de pessoas seguia atrás dele por terra porque as pessoas tinham visto os milagres que Ele fazia, curando os doentes. ");
INSERT INTO portft_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus subiu um monte e se sentou conosco, seus discípulos, para nos ensinar.  ");
INSERT INTO portft_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Então Ele olhou em volta e viu aproximar-se uma grande multidão de pessoas. ");
INSERT INTO portft_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ele disse a Filipe, “Onde podemos comprar comida para todas essas pessoas comerem?” ");
INSERT INTO portft_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ele fez essa pergunta para descobrir se Filipe acreditava no que Jesus poderia fazer, pois Ele já sabia o que Ele iria fazer. ");
INSERT INTO portft_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipe lhe respondeu, “Mesmo que tivéssemos a quantia de dinheiro que um homem ganha em oito meses, não seria suficiente para comprar o pão necessário para dar um pedacinho a cada uma essas pessoas”! ");
INSERT INTO portft_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Outro membro de nosso grupo de discípulos André, o irmão menor de Pedro disse a Ele, ");
INSERT INTO portft_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Há um menino aqui que tem cinco pãezinhos de cevada e dois peixinhos assados. Mas isso é pouco/o que é isso RHQ para tanta gente!?” ");
INSERT INTO portft_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus disse, “Mandem as pessoas se sentarem”! Havia lá bastante grama, por isso todas as pessoas se sentaram. Havia entre aqueles que se sentaram uns 5.000 homens. ");
INSERT INTO portft_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Então Jesus tomou os pãezinhos e os peixes e deu graças a Deus por eles. Então Ele os entregou a nós, e nós distribuímos os pãezinhos e os peixes a todas as pessoas sentadas no chão. Como Deus fez com que a comida se multiplicasse, todos os presentes comeram quanto quiseram. ");
INSERT INTO portft_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Quando todos tinham consumido toda a comida que desejavam, Ele disse a nós discípulos, “Recolham as sobras dos cinco pãezinhos. Que não se perca nada”! ");
INSERT INTO portft_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Portanto recolhemos as sobras dos cinco pãezinhos de cevada deixadas por aqueles que tinham se alimentado. Com aquelas sobras enchemos doze cestos! ");
INSERT INTO portft_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Depois que as pessoas tinham visto aquele milagre realizado por Jesus, muitas passaram a dizer, “Com certeza é este o profeta parecido com Moisés que Deus prometeu enviar ao mundo”! ");
INSERT INTO portft_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Vendo Jesus que eles estavam para levá-lo à força para o fazerem o rei deles, Ele saiu de novo e subiu sozinho ao monte. ");
INSERT INTO portft_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","De tardinha, nós discípulos descemos ao Lago da Galileia.  ");
INSERT INTO portft_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Quando já estava escuro, e Jesus ainda não tinha chegado até nós, embarcamos e atravessamos o lago em direção à cidade de Cafarnaum. ");
INSERT INTO portft_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Começou a soprar um vento forte, fazendo a água ficar bem agitada criando ondas grandes. ");
INSERT INTO portft_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Após remarmos uns cinco a seis quilômetros vimos Jesus aproximando-se do barco. Ele estava andando em cima da água! Por isso ficamos apavorados! ");
INSERT INTO portft_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mas Ele nos disse, “Não tenham medo! Sou eu”! ");
INSERT INTO portft_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Com muita alegria o acolhemos no barco. No momento de assim fazermos, o barco chegou à praia para onde nós dirigíamos. ");
INSERT INTO portft_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","No dia seguinte, a multidão que tinha ficado na margem oposta do lago ficou perplexa, tentando decifrar como Jesus poderia ter deixado aquela região. As pessoas sabiam que no dia anterior havia lá apenas um barco. Sabiam que os discípulos tinham embarcado sozinhos nele, e que Jesus não os tinha acompanhado. ");
INSERT INTO portft_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Então chegaram de barco alguns homens da cidade de Tiberíades. Eles esperavam levar consigo, de volta a Tiberíades, alguns da multidão. Chegaram perto do lugar onde as pessoas tinham se alimentado da comida milagrosa após Jesus dar graças e fazê-la multiplicar-se.  ");
INSERT INTO portft_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Quando a multidão se deu conta de que Jesus não estava lá, nem nós os discípulos tampouco, alguns do grupo embarcaram naqueles barcos e saíram para Cafarnaum a fim de procurar Jesus. ");
INSERT INTO portft_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ao encontrá-lo em Cafarnaum, mais distante um pouco, eles lhe perguntaram, “Mestre, já que o Senhor não veio de barco, quando e como chegou até aqui?” ");
INSERT INTO portft_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus respondeu a eles, “Escutem com cuidado o seguinte: não é por me virem fazer milagres, e daí se darem conta de quem sou, que vocês me procuram. Pelo contrário, vocês me procuram só porque tiveram muitos pãezinhos para comer por eu tê-los suprido por meio de um milagre.  ");
INSERT INTO portft_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Deixem de cobiçar a comida que logo se estraga! Pelo contrário, desejem a comida espiritual que dura para sempre! Anseiem a vida eterna! É isso que eu, aquele que veio do céu, vou lhes dar. Deus meu Pai já mostrou que Ele aprova de eu assim proceder”. ");
INSERT INTO portft_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Então as pessoas lhe perguntaram, “Que coisas devemos fazer para agradar a Deus?” ");
INSERT INTO portft_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus respondeu, “Deus quer que vocês façam o seguinte: Ele quer que acreditem que sou eu aquele que Ele enviou”. ");
INSERT INTO portft_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Portanto eles lhe disseram, “Então faça mais um milagre para que nós possamos vê-lo e acreditar que o Senhor veio de Deus. Que milagre o Senhor pretende fazer? ");
INSERT INTO portft_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nossos antepassados comeram do maná, que Deus lhes forneceu milagrosamente no deserto. Está escrito {O salmista escreveu o seguinte} acerca daquilo que Moisés fez acontecer: “Ele lhes deu comida do céu para comerem”. O Senhor pode fazer um milagre como esse?” ");
INSERT INTO portft_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus lhes disse, “A verdade é que não foi Moisés quem deu aos seus antepassados aquela comida do céu. Pelo contrário, foi meu Pai que a deu a eles. E é Ele quem dá a vocês a verdadeira comida do céu. ");
INSERT INTO portft_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","O verdadeiro pão de Deus desceu do céu, e é Ele que vai dar a vida eterna aos habitantes do mundo”. ");
INSERT INTO portft_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sem entender o que Ele quis dizer, eles lhe disseram, “Senhor, dê-nos sempre daquele tipo de pão”! ");
INSERT INTO portft_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus lhes disse, “Assim como a/o comida/pão MET capacita o corpo humano a permanecer vivo, sou eu que capacito vocês a terem a vida espiritual/eterna. Aqueles que comem da comida e bebida comum passam depois a ter fome e sede. Mas os que vêm a mim, a fim de receber aquela vida, nunca mais vão carecer espiritualmente de nada.  ");
INSERT INTO portft_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Já lhes disse antes que vocês veem meus milagres, mas em vez de entenderem por meio deles quem sou eu, vocês não creem em mim. ");
INSERT INTO portft_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Todas as pessoas que meu Pai me designar virão a mim, e eu com certeza acolho/não mando embora LIT aquele que vier a mim. ");
INSERT INTO portft_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Quando desci do céu, não foi para fazer a minha vontade. Pelo contrário, vim fazer o que desejava Deus/meu Pai, que me enviou. ");
INSERT INTO portft_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aquele que me enviou desejava que eu guardasse para sempre/não perdesse LIT todos os que/nenhum dos que Ele me designou. Ele queria que eu fizesse que todos eles se tornassem vivos novamente no último dia/dia MTY quando eu julgar todos os seres humanos.  ");
INSERT INTO portft_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Quando aqueles que estavam no deserto, que as cobras picaram há muito tempo, contemplavam a imagem em bronze duma cobra, ficavam sarados MET. Meu Pai deseja que, da mesma forma, todos os que contemplarem o que tenho feito, e crerem em mim, tenham a vida eterna. Vou fazer com que eles vivam novamente no último dia/dia MTY quando eu julgar todos os seres humanos”. ");
INSERT INTO portft_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Os líderes SYN judaicos começaram a queixar-se dele porque Ele tinha dito, “Sou aquele que é como pão verdadeiro que desceu do céu”. ");
INSERT INTO portft_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Eles disseram, “Este homem/Não é verdade que este homem RHQ é Jesus, filho de José!? Sabemos os nomes do seu pai e sua mãe. Com certeza Ele não veio do céu, portanto Ele está mentindo ao dizer/por que agora Ele diz RHQ. “Vim do céu”“! ");
INSERT INTO portft_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus lhes respondeu, “Deixem de queixar-se entre si daquilo que acabo de dizer!  ");
INSERT INTO portft_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Meu Pai, que me enviou, faz com que as pessoas desejem vir a mim. Essas pessoas são as únicas que vão crer em mim. Nenhum outro virá a mim para receber a vida eterna. Vou fazer com que elas fiquem vivas novamente no dia final/dia do juízo.  ");
INSERT INTO portft_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Foi escrito por um dos profetas/o profeta Isaías {Um dos profetas/o profeta Isaías escreveu} sobre todos aqueles que vão confiar em mim, “Deus vai ensinar todos eles”. Todos os que escutam o que diz meu Pai, e aprendem dele, vão vir a/crer em mim. ");
INSERT INTO portft_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Vim de Deus. Sou o único que já viu meu Pai. Ninguém mais O tem visto. ");
INSERT INTO portft_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Escutem bem o seguinte: Todos os que creem minha mensagem/em mim têm a vida eterna. ");
INSERT INTO portft_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Justamente como a/o comida/pão MET faz com que seus corpos permaneçam sadios, sou eu aquele que capacita vocês a terem a vida eterna/espiritual.  ");
INSERT INTO portft_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mesmo que seus antepassados comessem o maná do céu no deserto, eles acabaram morrendo de qualquer jeito. ");
INSERT INTO portft_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mas o pão de que falo é algo que desceu do céu. Se as pessoas comerem desse pão,elas/o Espírito delas não morrerão/morrerá. ");
INSERT INTO portft_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Sou eu aquele que desceu do céu para capacitar as pessoas a terem a vida espiritual. Se as pessoas aceitarem aquilo que eu lhes dou, vão viver para sempre. Aquilo que lhes dou é minha carne, que vou dar a todas as pessoas do MTY mundo para que possam ter vida nova”. ");
INSERT INTO portft_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Então os líderes judaicos SYN começaram a discutir entre si, dizendo, “Não é possível/Como pode ser que este homem RHQ nos dê para comer a carne dele!? ");
INSERT INTO portft_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Portanto, falando de maneira figurada da necessidade de eles aceitarem individualmente os benefícios do seu auto-sacrifício e derramamento de sangue para expiar os pecados deles MET, Jesus lhes disse, “Escutem bem o seguinte: Embora seja eu aquele que veio do céu, se vocês não comerem da minha carne e beberem do meu sangue, não vão viver eternamente. ");
INSERT INTO portft_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aqueles que comem da minha carne e bebem do meu sangue têm a vida eterna, e vou fazer com que fiquem novamente vivos no dia final/dia do juízo. ");
INSERT INTO portft_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pois são minha carne e meu sangue que dão realmente a comida/vida espiritual/eterna. ");
INSERT INTO portft_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aqueles que comerem da minha carne e beberem do meu sangue vão ter um íntimo relacionamento comigo, e eu com eles. ");
INSERT INTO portft_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Meu Pai, que é a fonte de tudo que vive, enviou-me, e vivo porque meu Pai me permitiu viver. De forma semelhante, aqueles que comerem da minha carne vão viver eternamente por causa daquilo que faço em benefício deles.  ");
INSERT INTO portft_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Estou falando do pão que desceu do céu. Embora nossos antepassados comessem do maná, eles morreram mais tarde, de qualquer jeito. Mas aqueles que comem deste pão vão viver para sempre”. ");
INSERT INTO portft_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ele disso isso enquanto ensinava as pessoas na sinagoga/sala de reuniões dos judeus em Cafarnaum. ");
INSERT INTO portft_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Depois de ouvirem essas palavras dele, muitos dos discípulos de Jesus disseram, “Aquilo que Ele está ensinando é bem difícil de entender; é muito difícil/como se pode aceitar!? RHQ” ");
INSERT INTO portft_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesus estava ciente de que seus discípulos se queixavam disso, portanto disse a eles, “Sinto/Será que RHQ isto esteja ofendendo vocês!? ");
INSERT INTO portft_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Será que/Talvez vocês RHQ vão crer minha mensagem (OU, O que vocês vão pensar) se me virem, eu, que vim do céu, subir para lá, para onde antes estava! ");
INSERT INTO portft_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","É o Espírito de Deus que dá a vida eterna às pessoas. Não valem os esforços humanos para dar a vida eterna. A mensagem que eu lhes comuniquei dá a vida eterna (OU, vem do Espírito de Deus e dá vida eterna.) ");
INSERT INTO portft_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mas alguns de vocês não creem minha mensagem”. Jesus disse isso porque sabia, desde o início MTY do seu ministério, quais deles não iriam crer a mensagem dele. Ele também sabia quem iria traí-lo/fazer com que os inimigos dele o prendessem. ");
INSERT INTO portft_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Então Ele continuou dizendo, “É por isso que lhes disse que só aqueles que forem capacitados por meu pai {a quem meu pai tiver capacitado} a crerem em mim virão a mim e receberão a vida eterna”. ");
INSERT INTO portft_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Daí em diante, muitos dos discípulos dele O abandonaram e não O acompanhavam mais. ");
INSERT INTO portft_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Por isso Ele disse a nós os doze apóstolos, “Vocês também querem me abandonar?” ");
INSERT INTO portft_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simão Pedro lhe respondeu, “Não, Senhor, pois se abandonarmos o Senhor, não há mais ninguém a quem possamos ir! É o Senhor que tem a mensagem da vida eterna! ");
INSERT INTO portft_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Viemos a crer com certeza que o Senhor é o homem santo que veio de Deus”. ");
INSERT INTO portft_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Então Jesus nos respondeu, “Vocês estão falando como se todos os doze apóstolos que escolhi acreditassem isso. Mas um de vocês está sob controle de Satanás”! ");
INSERT INTO portft_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ele se referia a Judas, o filho de Simão, da cidadezinha de Queriote. Mesmo sendo um de nós doze apóstolos, Judas estava para trair Jesus/ajudar os inimigos de Jesus a prendê-lo. ");
INSERT INTO portft_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Depois de acontecerem essas coisas, Jesus viajou pela província da Galileia. Ele não queria viajar na província da Judeia, pois sabia que os líderes judaicos dessa área desejavam matá-lo. ");
INSERT INTO portft_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mas quando se aproximavam os dias do festival judaico chamado ‘Festival de Morar em Barracas’, ");
INSERT INTO portft_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","os irmãos menores de Jesus lhe disseram, “Visto que muitas pessoas daqui já O abandonaram, você deve sair desta região e ir à província da Judeia para fazer lá alguns milagres, para que os seus discípulos possam vê-los! ");
INSERT INTO portft_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pois ninguém que deseja ficar famoso faz as coisas em segredo. Você afirma que está realizando os tais milagres, portanto faça alguns milagres lá para todo o mundo MTY ver”! ");
INSERT INTO portft_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Eles disseram isso em tom de crítica, pois apesar de serem irmãos menores dele, eles não acreditavam que Ele tivesse vindo de Deus.  ");
INSERT INTO portft_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Por isso Jesus disse a eles, “Ainda não chegou a hora de eu MTY assistir o festival. Para vocês, serve qualquer hora para assistirem o festival. ");
INSERT INTO portft_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","As pessoas do mundo MTY que não creem em mim/não pertencem a Deus não podem odiar vocês, mas elas me odeiam porque lhes digo que aquilo que estão fazendo é errado/mau. ");
INSERT INTO portft_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Vão vocês ao festival. Não vou subir ainda a Jerusalém para o festival, pois não é o momento apropriado para eu ir lá”. ");
INSERT INTO portft_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Depois de dizer isso, Jesus ficou mais um pouco na Galileia. ");
INSERT INTO portft_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Contudo, uns poucos dias após a saída dos seus irmãos para o festival, Ele também foi lá. Viajou acompanhado por nós discípulos, mas ninguém mais nos acompanhou. ");
INSERT INTO portft_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","No festival, os líderes judaicos o procuravam. Eles indagavam às pessoas, “Onde está aquele homem?” ");
INSERT INTO portft_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","No meio da multidão, muitas pessoas cochichavam sobre Jesus. Algumas delas diziam, “Ele é um bom homem”! Mas outros diziam o contrário, “Não, Ele está enganando o povo”! ");
INSERT INTO portft_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mas ninguém falava tão alto que os outros pudessem ouvir, pois tinham medo dos líderes judaicos SYN. ");
INSERT INTO portft_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","No meio dos dias do festival, Jesus se dirigiu ao pátio do templo e começou a ensinar o povo. ");
INSERT INTO portft_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Os anciãos judaicos se maravilharam daquilo que Ele dizia. Eles disseram, “Este homem nunca estudou em uma das nossas escolas religiosas! Portanto, como é que Ele pode ter aprendido/Custa-nos acreditar que Ele tenha aprendido RHQ tanta coisa sobre as Escrituras?”! ");
INSERT INTO portft_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus lhes respondeu, “Aquilo que ensino não vem de mim mesmo. Vem de Deus, que me enviou. ");
INSERT INTO portft_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Aqueles que resolverem fazer o que Deus quer vão descobrir se aquilo que ensino vem de Deus ou se falo apenas com minha própria autoridade.  ");
INSERT INTO portft_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aqueles que falam apenas com sua própria autoridade agem dessa forma para que os outros os reverenciem. Mas meu propósito, ao agir, é que os outros reverenciem aquele que me enviou, e sou uma pessoa que diz a verdade. Nunca minto. ");
INSERT INTO portft_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Pensem nas leis que Moisés lhes deu RHQ. Nenhum de vocês obedece integralmente aquelas leis. Por isso, por que estão tentando matar-me, alegando que não obedeço as leis referentes ao sábado/dia de descanso judaico?” ");
INSERT INTO portft_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Alguns membros da multidão responderam, “Falando assim, você dá provas de que é maluco (OU, um demônio está controlando você)! Com certeza, ninguém está tentando matá-lo”! ");
INSERT INTO portft_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus lhes respondeu, “Por eu ter feito um milagre, curando alguém no sábado/dia de descanso judaico, vocês todos ficaram chocados. ");
INSERT INTO portft_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Vocês dizem que Moisés lhes deu uma lei que manda circuncidar os filhos machos, e que tal circuncisão deve ser praticada exatamente sete dias após o nascimento das crianças. Realmente, seus antepassados Abraão, Isaque e Jacó iniciaram aquele costume. Mas por causa daquela lei, vocês circuncidam os filhos às vezes no sábado/dia de descanso judaico, e isso equivale trabalhar nesse dia. ");
INSERT INTO portft_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Já que vocês circuncidam os meninos às vezes no sábado/dia de descanso judaico para não desobedecerem a lei de Moisés {para que a lei de Moisés não seja desacatada}, é absurdo que estejam/por que vocês estão RHQ zangados comigo, alegando que trabalho no sábado/dia de descanso judaico ao curar um homem doente! Adianta muito mais curar alguém que circuncidar alguém!  ");
INSERT INTO portft_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Deixem de pontificar sobre se algo está certo ou errado apenas com base naquilo que vocês estão vendo! Pelo contrário, tomem as decisões de acordo com aquilo que é realmente certo! ");
INSERT INTO portft_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Então alguns dos habitantes de Jerusalém começaram a dizer, “É este/Não é por acaso este RHQ o homem que estão tentando matar?! ");
INSERT INTO portft_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ele está dizendo estas coisas em público/na presença de muitas pessoas, mas nossos governantes judaicos não dizem nada em oposição a Ele. Será porque eles determinaram que Ele é realmente o Messias/o rei escolhido por Deus? ");
INSERT INTO portft_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mas Ele não pode ser o Messias, pois sabemos de onde vem este homem. Mas quando Messias realmente vier, ninguém vai saber de onde Ele vem”. ");
INSERT INTO portft_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Eles disseram isso porque pensavam que Jesus tivesse nascido em Nazaré. Portanto, enquanto Jesus ensinava o povo no pátio do templo, Ele gritou, “Sim, vocês me conhecem, e acham que sabem IRO de onde sou. Mas não vim para cá por eu mesmo ter-me nomeado/com minha própria autoridade. Pelo contrário, é Deus quem me enviou. Vocês não O conhecem. ");
INSERT INTO portft_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mas eu O conheço, pois vim dele. É Ele quem me enviou”! ");
INSERT INTO portft_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Então eles tentaram prendê-lo por Ele ter dito que tinha vindo de Deus. Mas ninguém pôs mão nele para assim fazer, pois ainda não era chegada a hora MTY para as pessoas O matarem/para Ele morrer.  ");
INSERT INTO portft_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mas muitos na multidão acreditaram que Ele tinha vindo de Deus. Eles disseram, “Quando vier o Messias, com certeza Ele não vai/será que Ele vai RHQ praticar mais milagres que este homem!?” ");
INSERT INTO portft_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Os fariseus ouviram os cochichos da multidão sobre Ele. Portanto eles e os principais sacerdotes mandaram alguns guardas do templo prendê-lo. ");
INSERT INTO portft_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Então Jesus disse, “Estarei pouco tempo com vocês. Depois, vou voltar àquele que me enviou. ");
INSERT INTO portft_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Então vocês vão me procurar, mas não vão me achar. E não poderão chegar até o lugar onde eu estou”. ");
INSERT INTO portft_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Por isso os líderes judaicos SYN disseram entre si, “Para onde este homem vai, que não o poderemos achar? Alguns judeus ficaram dispersos e moram entre os gregos. Será que Ele irá morar entre eles e ensiná-los? ");
INSERT INTO portft_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Quando Ele disse, “Vocês vão me procurar mas não poderão me achar,” e quando disse, “Vocês não poderão chegar até onde eu estou,” o que Ele quis dizer?” ");
INSERT INTO portft_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Em cada um dos sete dias do festival, o sumo sacerdote derramava água no altar no templo para relembrar como Deus havia providenciado água para o povo no deserto tanto tempo antes. Mas a água que ele derramava não aliviava a sede de ninguém. Portanto no último dia do festival, o dia mais importante, Jesus ficou de pé no pátio do Templo e gritou em voz alta, “Quem tiver sede, venha a mim para beber aquilo que vou lhes dar.  ");
INSERT INTO portft_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Bem como escreveram nas Escrituras sobre aqueles que crerem em mim, fluirão do interior deles correntes de água que fará com que as pessoas vivam eternamente”. ");
INSERT INTO portft_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ao dizer isso, Jesus se referia ao Espírito de Deus, que receberiam mais tarde aqueles que criam nele. Até esse momento, Deus não tinha mandado o Espírito para viver no interior dos cristãos, pois Jesus ainda não tinha morrido e voltado ao seu glorioso lar no céu, de onde iria mandar o Espírito. ");
INSERT INTO portft_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Quando alguns na multidão ouviram essas palavras, disseram, “Este homem é com certeza o profeta parecido com Moisés, que Deus prometeu enviar”!  ");
INSERT INTO portft_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Outros disseram, “Ele é o Messias”! Mas outros, pensando que Jesus tivesse nascido na Galileia, disseram, “O Messias não/Será que o Messias RHQ pode vir da província da Galileia?! ");
INSERT INTO portft_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Um profeta escreveu/Não foi um profeta que escreveu RHQ nas Escrituras que o Messias viria da família do Rei Davi, nascendo em Belém, onde morava o Rei Davi?”! ");
INSERT INTO portft_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Portanto a opinião das pessoas estava dividida com relação a Jesus. ");
INSERT INTO portft_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Algumas pessoas queriam prendê-lo, mas ninguém pôs mão nele para assim fazer. ");
INSERT INTO portft_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Por isso os guardas do templo voltaram aos principais sacerdotes e fariseus, os mesmos que os tinham mandado prender Jesus. Estes disseram aos guardas, “Por que vocês não o prenderam e trouxeram para cá ?” ");
INSERT INTO portft_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Eles responderam, “Ninguém jamais proferiu coisas tão maravilhosas como esse homem”! ");
INSERT INTO portft_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Então os fariseus responderam, “Será que vocês foram enganados {Ele enganou vocês} também? ");
INSERT INTO portft_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nenhum de nós/Será que algum de nós RHQ líderes dos Judeus ou nós fariseus acreditamos que Ele é o Messias/Ele veio de Deus!? ");
INSERT INTO portft_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nenhum! Mas, pelo contrário, alguns desta multidão creram nele. Eles não sabem nada da lei de Moisés! Deus vai amaldiçoá-los/Eles irão para o inferno por terem escutado Jesus”! ");
INSERT INTO portft_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Então falou Nicodemos. Foi ele que antes tinha visitado Jesus à noite. Era também membro do Conselho Judaico. Ele lhes perguntou, ");
INSERT INTO portft_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Não ouvimos ainda o que Ele diz para descobrir o que Ele está fazendo. Nossa lei judaica PRS permite/É permitido na nossa lei judaica PRS RHQ que afirmemos, antes de assim proceder, que devemos punir um homem?” ");
INSERT INTO portft_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Eles responderam a Ele, “Será que você é/Você está falando como RHQ mais um nojento galileu?! Leia o que eles escreveram nas Escrituras! Vai descobrir que não vem nenhum profeta da província da Galileia, como Ele!  ");
INSERT INTO portft_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Então todos eles saíram e se foram para seus próprios lares. ");
INSERT INTO portft_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mas Jesus foi conosco, seus discípulos, até o Monte das Oliveiras, onde passamos a noite.  ");
INSERT INTO portft_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","De madrugada, no dia seguinte, voltamos ao pátio do templo. Muitas pessoas se congregaram ao redor dele, por isso Ele se sentou para ensiná-las. ");
INSERT INTO portft_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Então alguns homens que ensinavam as leis judaicas e alguns membros SYN do grupo religioso dos fariseus trouxeram uma mulher a Ele. Ela tinha sido apanhada {Eles tinham tramado para apanhá-la} enquanto ela estava deitada com um homem que não era seu marido. Eles obrigaram a mulher a ficar em pé na frente do grupo que escutava Jesus. ");
INSERT INTO portft_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Então disseram a Jesus, “Mestre, esta mulher foi apanhada {apanhamos esta mulher} enquanto ela estava tendo relações sexuais com um homem que não é seu marido. ");
INSERT INTO portft_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés nos mandou na lei que ele nos deu que jogássemos pedras em tais mulheres até matá-las. Pois bem, o que o Senhor acha que devemos fazer?” ");
INSERT INTO portft_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Eles fizeram essa pergunta a modo de armadilha, para poderem acusá-lo. Se Ele dissesse que não deveriam matá-lo, seria um gesto de desobediência à lei de Moisés. Se Ele dissesse que deveriam matá-la, seria um gesto de desobediência às leis romanas. Mas Jesus se ajoelhou e escreveu algo no chão com o dedo. ");
INSERT INTO portft_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Enquanto eles continuavam interrogando-o, Ele ficou de pé e lhes disse, “Se algum de vocês nunca pecou, ele pode ser a primeira a jogar pedras nela”. ");
INSERT INTO portft_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Então Ele se ajoelhou de novo e escreveu mais coisas no chão. ");
INSERT INTO portft_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Após ouvirem o que Ele tinha dito, os que o interrogavam foram embora, um por um, sabendo que eram todos pecadores. Os mais velhos tomaram a dianteira, e depois foram os mais jovens. Finalmente, ficou apenas Jesus, mais a mulher ainda em pé. ");
INSERT INTO portft_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesus se levantou e lhe perguntou, “Mulher, onde estão eles? Ninguém disse que você deve morrer por seu pecado?” ");
INSERT INTO portft_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ela respondeu, “Não, Senhor, não há ninguém”. Então Jesus disse, “Eu tampouco digo que você deve morrer. Volte agora para casa, e não siga mais essa vida pecaminosa”! ");
INSERT INTO portft_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus falou novamente ao povo, dizendo, “Sou como uma luz MET para todas as pessoas do MTY mundo. Assim como uma luz revela às pessoas o que há na escuridão MET, assim eu lhes revelo a verdade de Deus. Aqueles que se tornarem meus discípulos nunca ficarão inconscientes da verdade de Deus MET como aqueles que andam na escuridão ignoram o que existe em volta deles. Pelo contrário, eles terão minha luz, que lhes mostra como obter a vida eterna”. ");
INSERT INTO portft_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Por isso os fariseus disseram a Ele, “Você só fala de si mesmo! Visto não haver mais ninguém para verificar estas coisas que você afirma no tocante a si mesmo, não precisamos aceitar como verdade aquilo que diz”. ");
INSERT INTO portft_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus respondeu, “Mesmo que eu fosse o único a dizer estas coisas sobre mim mesmo, aquilo que digo é verdade, pois sei que vim do céu, e sei que vou voltar ao céu. Mas vocês não sabem de onde vim, nem para onde vou. ");
INSERT INTO portft_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Vocês julgam as pessoas segundo critérios humanos. O motivo de eu estar aqui não é para condenar as pessoas/dizer que vou punir as pessoas por seus pecados. ");
INSERT INTO portft_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mas se eu julgar as pessoas, minha sentença será correta, pois não sou o único que vai determinar essas coisas. Tanto eu como aquele que me enviou vamos determinar as coisas. ");
INSERT INTO portft_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Está escrito {Moisés escreveu} na sua lei que se pelo menos duas pessoas testemunharem/declararem que algo é verdade, as pessoas devem aceitar como verdade aquilo que elas afirmam. ");
INSERT INTO portft_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Estou falando com vocês sobre mim mesmo, e o outro que lhes fala de mim é meu Pai que me enviou. Por isso vocês devem aceitar como verdade aquilo que afirmamos”. ");
INSERT INTO portft_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Então eles lhe perguntaram “Se você tem um pai a quem podemos interrogar acerca de você, onde está ele?” Respondeu Jesus, “Vocês não sabem quem eu sou de verdade. Se soubessem quem eu sou de verdade, também saberiam quem é meu Pai”. ");
INSERT INTO portft_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ele disse estas coisas enquanto estava no pátio do templo, perto do lugar onde as pessoas depositavam suas ofertas. Ficava bem perto do lugar onde se congregava o conselho judaico, mas ninguém o prendeu para o levar preso, pois ainda não era chegada a hora MTY para Ele sofrer e morrer. ");
INSERT INTO portft_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus lhes disse novamente, “Daqui a pouco, vou embora. Então, no final da vida, vocês vão me buscar, mas vão morrer sem Deus ter perdoado seus pecados. Aonde eu for, vocês não poderão ir”. ");
INSERT INTO portft_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Por isso os líderes judaicos disseram entre si, “Será que Ele vai se matar? É por isso que disse, ‘Aonde eu for, vocês não poderão ir?’” ");
INSERT INTO portft_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mas Jesus continuava, dizendo-lhes, “Vocês nasceram aqui neste mundo, mas eu vim do céu. Vocês pertencem àqueles que se opõem a Deus. Não pertenço a esse grupo. ");
INSERT INTO portft_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Já lhes disse que vocês vão morrer sem Deus ter perdoado seus pecados. Se não crerem que sou quem digo que sou, vão morrer sem Deus ter perdoado seus pecados”. ");
INSERT INTO portft_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Por isso eles lhe disseram, “Você, quem acha que é?” Jesus lhes disse, “Desde que comecei a ensinar vocês, tenho lhes dito continuamente quem sou eu! ");
INSERT INTO portft_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Eu bem poderia julgar vocês, dizendo que são culpados de muitas coisas. Mas em vez disso vou dizer somente aquilo que aquele que me enviou me mandar dizer. Aquilo que Ele diz é verdade, e comunico às pessoas do mundo aquilo que tenho ouvido dele”. ");
INSERT INTO portft_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Eles não entenderam que Ele se referia ao seu Pai no céu.  ");
INSERT INTO portft_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Por isso Jesus disse, “Sou eu que desci do céu, mas quando vocês me levantarem em uma cruz para me matar, vão saber quem sou. Também vão saber que não faço nada com minha própria autoridade. Pelo contrário, digo somente aquilo que meu Pai me ensinou. ");
INSERT INTO portft_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","É Ele que me enviou, e Ele me ajuda. Já que faço sempre as coisas que são do agrado dele, Ele nunca me abandonou”. ");
INSERT INTO portft_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Enquanto Ele dizia estas coisas, muitas pessoas passaram a crer que Ele vinha/era de Deus/o Messias. ");
INSERT INTO portft_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Então Jesus disse aos judeus que acreditavam nele, “Se vocês continuarem firmes em/vivendo de acordo com minha mensagem, serão com certeza meus discípulos. ");
INSERT INTO portft_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Então vão conhecer a verdade de Deus, e como resultado de crerem a verdade de Deus, Ele vai livrá-los de serem controlados por aquele que os torna escravos dele”.  ");
INSERT INTO portft_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Eles responderam a Ele, “Somos descendentes de Abraão. Nunca fomos escravos de ninguém. Portanto, por que você diz que Deus vai nos livrar de sermos escravos de alguém?” ");
INSERT INTO portft_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus respondeu, “Escutem bem o que vou lhes dizer. Todos os que continuam pecando são obrigados a obedecer aos seus desejos pecaminosos MET, como um escravo que é obrigado a obedecer seu patrão.  ");
INSERT INTO portft_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","O escravo não é membro permanente da família. Mas um filho é membro da família para sempre. Semelhantemente, vocês dizem que são membros da família de Deus por serem descendentes de Abraão, mas realmente, por serem como escravos dos seus desejos pecaminosos, já não são membros permanentes, como eu, da família de Deus.  ");
INSERT INTO portft_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Portanto, se me permitirem livrá-los, serão realmente livres. ");
INSERT INTO portft_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Sei que vocês são descendentes de Abraão. Mas estão tentando matar-me porque não permitem que minha mensagem continue transformando seu ser interior. ");
INSERT INTO portft_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Eu lhes digo aquilo que vi quando ainda estava com meu Pai. Mas vocês fazem as coisas que ouviram do seu pai”. ");
INSERT INTO portft_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Eles lhe responderam, “Abraão é nosso antepassado”. Jesus lhes disse, “Se vocês fossem descendentes de Abraão, seu caráter seria parecido com o caráter de Abraão, e vocês fariam coisas boas, como fez Abraão. ");
INSERT INTO portft_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Sou um homem que lhes diz sempre a verdade que ouviu de Deus, mas vocês procuram matar-me. Abraão não fez tais coisas. ");
INSERT INTO portft_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Não, vocês estão fazendo as coisas que faz seu verdadeiro pai”. Eles lhe disseram “Não sabemos nada de você, mas quanto ao nosso nascimento, não somos filhos ilegítimos. E, em termos espirituais, temos apenas um pai, quem é Deus”. ");
INSERT INTO portft_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus lhes disse, “Se Deus fosse seu pai, vocês me amariam, pois vim dele e agora cheguei aqui neste mundo. Minha vinda não foi consequência de eu ter me nomeado/minha própria autoridade. Pelo contrário, Ele me enviou. ");
INSERT INTO portft_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Vou lhes dizer/Vocês sabem RHQ por que não entendem o que digo!? É porque não querem aceitar minha mensagem. ");
INSERT INTO portft_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Vocês pertencem ao seu pai, o diabo/Satanás, e desejam fazer o que ele quer. Ele tem feito com que as pessoas se tornem assassinos, desde o momento quando Deus criou os seres humanos. Ele abandonou a verdade de Deus por ser por natureza mentiroso. Sempre que ele mente, está falando de acordo com sua verdadeira natureza, pois ele é mentiroso e fonte MET de todas as mentiras. ");
INSERT INTO portft_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mas por eu lhes dizer a verdade, vocês não me acreditam! ");
INSERT INTO portft_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Já que nunca pequei, nenhum de vocês/será que algum de vocês RHQ pode provar que pequei!? Portanto, já que lhes digo a verdade, não há motivo para/por que RHQ vocês não me acreditarem/acreditam!? ");
INSERT INTO portft_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Aqueles que pertencem a Deus costumam obedecer a mensagem de Deus. Vocês não pertencem a Deus; por isso não obedecem a mensagem dele”. ");
INSERT INTO portft_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Os líderes judaicos SYN lhe responderam, “Com certeza temos/Não temos por acaso RHQ razão ao dizer que você acredita mentiras, como fazem os samaritanos! E um demônio/Espírito maligno controla você”! ");
INSERT INTO portft_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus respondeu, “Um demônio não me controla! Pelo contrário, honro meu Pai, e vocês não me honram. ");
INSERT INTO portft_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Não estou tentando me honrar. Há mais alguém que deseja me honrar, e é Ele que vai determinar se sou eu que digo a verdade ou se são vocês que dizem a verdade.  ");
INSERT INTO portft_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mas escutem bem o seguinte: aqueles que obedecem aquilo que digo nunca vão morrer”! ");
INSERT INTO portft_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Então os líderes judaicos SYN, pensando que Ele se referisse à morte comum e não à morte espiritual, disseram a Ele, “Agora temos certeza de que um demônio controla você! Abraão e os profetas morreram há muito tempo! Mas você diz que aqueles que obedecerem aquilo que você ensina nunca vão morrer!  ");
INSERT INTO portft_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Com certeza você não é/Você acha que é RHQ maior que Abraão!? Morreu ele, e morreram todos os profetas, portanto quem você se acha, alegando algo assim?” ");
INSERT INTO portft_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus respondeu, “Se eu honrasse a mim mesmo, seria embalde. Meu Pai é aquele que vocês chamam seu Deus. É Ele quem me honra. ");
INSERT INTO portft_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Embora vocês não o conheçam, eu O conheço e tenho uma íntima relação com Ele. Se eu dissesse que não O conhecia, seria mentiroso como vocês. Mas eu O conheço, e obedeço aquilo que Ele diz. ");
INSERT INTO portft_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraão, o antepassado de vocês, ficava feliz ao pensar naquilo que eu iria fazer durante minha vida MTY. Era como se ele tivesse visto aquilo, e ficasse contente”. ");
INSERT INTO portft_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Então os líderes judaicos SYN disseram a Ele, “Você não tem ainda 50 anos de idade! Portanto você com certeza não viu/como é que você poderia ter visto RHQ Abraão!? Ele morreu há muito tempo”!  ");
INSERT INTO portft_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus lhes disse, “A verdade há que eu já existi antes de Abraão nascer”! ");
INSERT INTO portft_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Portanto, por ficarem tão zangados por Jesus afirmar que tinha existido eternamente/era igual a Deus, eles pegaram pedras para jogar nele com o intuito de matá-lo. Mas foram impedidos de vê-lo {Jesus fez com que} não O pudessem ver, e Ele saiu do pátio do templo. ");
INSERT INTO portft_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Enquanto Jesus andava conosco, Ele viu um homem cego de nascença. ");
INSERT INTO portft_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nós discípulos lhe perguntamos, “Senhor, esse homem é cego de nascença porque seus pais pecaram, ou porque ele mesmo pecou?” ");
INSERT INTO portft_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus respondeu, “O fato de ele ser cego não é resultado do pecado dos pais dele, nem dele mesmo. Pelo contrário, ele é cego para que possa ser visto o poder/potencial de Deus {as pessoas possam ver o poder/potencial de Deus} como resultado daquilo que acontece a ele. ");
INSERT INTO portft_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Enquanto ainda houver tempo, preciso fazer o trabalho que aquele que me enviou quer que eu faça. Assim como o dia é seguido da noite, quando as pessoas não trabalham, no final da nossa vida MET já é tarde demais para fazermos aquilo que Deus quer.  ");
INSERT INTO portft_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Enquanto eu ainda estiver neste mundo, sou eu que capacito as pessoas a saberem de Deus, como MET uma luz capacita os habitantes deste mundo a enxergarem o que há na escuridão”. ");
INSERT INTO portft_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Depois de Ele falar desse jeito, cuspiu no chão. Fez um pouco de lama com a saliva, e a passou nos olhos do homem. ");
INSERT INTO portft_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Então lhe disse, “Vá se lavar no tanque de Siloé”! (Este nome significa ‘enviado’; assim como as pessoas canalizam a água para o tanque, Deus enviou Jesus). Por isso, o homem foi e se lavou no tanque, e ao voltar para casa já pôde enxergar! ");
INSERT INTO portft_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Os vizinhos dele, e outros que o tinham visto anteriormente quando ele ainda mendigava, disseram, “É esse o homem que antes se sentava aqui mendigando, não é?” ");
INSERT INTO portft_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Alguns disseram, “É, sim”. Outros disseram, “Não, não é. É apenas um homem parecido com ele”. Mas o homem mesmo disse, “Sou ele, sim”! ");
INSERT INTO portft_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Então lhe disseram, “Como é que você {De que forma você} conseguiu enxergar?” ");
INSERT INTO portft_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ele respondeu, “O homem chamado Jesus fez lama e a passou nos meus olhos. Então Ele me mandou ir me lavar no tanque de Siloé. Então fui lá e me lavei, e logo pude enxergar”. ");
INSERT INTO portft_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Eles lhe disseram “Onde está esse homem agora?” Ele disse, “Não sei”. ");
INSERT INTO portft_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Eles levaram o homem que antes era cego aos fariseus. ");
INSERT INTO portft_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesus tinha feito a lama, capacitando o homem a voltar a enxergar, em um dia de sábado. Eles/Os fariseus achavam que curar alguém equivalia trabalhar, e os regulamentos deles proibiam qualquer tipo de trabalho no dia de sábado.  ");
INSERT INTO portft_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Por isso, os fariseus também lhe perguntaram, “De que maneira você conseguiu recuperar a visão?” Ele lhes explicou, “O homem passou lama nos meus olhos. Então fui me lavar, e agora posso ver”. ");
INSERT INTO portft_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Por isso alguns dos fariseus disseram, “Sendo que aquele homem desobedece nossos regulamentos no tocante ao trabalho no sábado/dia de descanso judaico, Ele não vem de Deus”. Mas outros disseram, “Se Ele fosse pecador, com certeza não poderia/de que forma poderia Ele RHQ fazer tais milagres!?” Por isso a opinião deles estava dividida. ");
INSERT INTO portft_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Disseram portanto ao cego, “Você é o homem que Ele capacitou a enxergar. Qual é sua opinião desse homem?” O homem disse, “Acho que Ele é profeta”! Então eles o mandaram sair. ");
INSERT INTO portft_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Os líderes judaicos SYN ainda não acreditavam que o homem fosse realmente cego de nascença, ou que tivesse recuperado a visão. Por isso eles mandaram trazer os pais do homem. ");
INSERT INTO portft_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ao chegarem estes, os líderes judaicos lhes perguntaram, “Esse homem é seu filho? Vocês afirmam que ele era cego de nascença? Se isso for verdade, como é que ele consegue enxergar agora?” ");
INSERT INTO portft_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Os pais dele responderam, “Sabemos que ele é nosso filho. Sabemos que ele nasceu cego. ");
INSERT INTO portft_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mas não sabemos como é que ele consegue enxergar agora. Também não sabemos quem o capacitou a enxergar. Perguntem ao nosso filho! Ele é maior de idade e pode responder as perguntas das autoridades, como os senhores! Ele pode falar por sua própria conta”! ");
INSERT INTO portft_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Os líderes judaicos SYN tinham declarado anteriormente que iriam excluir dos cultos nas sinagogas deles qualquer pessoa que afirmasse que Jesus era o Messias. Os pais do homem curado sabiam disso, portanto tinham medo dos líderes judaicos SYN. ");
INSERT INTO portft_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","É por isso que disseram, “Ele é maior de idade e pode responder as perguntas por si mesmo, portanto perguntem a ele”! ");
INSERT INTO portft_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Por isso mandaram alguém trazer a eles o homem que nascera cego. Ao chegar ele, eles lhe disseram, “Sabendo que Deus nos escuta IDM, diga a verdade! Sabemos que o homem que curou você é pecador”. ");
INSERT INTO portft_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ele respondeu, “Não sei se Ele é pecador ou não. Mas de uma coisa eu sei muito bem, e é que antes eu era cego e agora vejo”! ");
INSERT INTO portft_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Por isso eles lhe disseram, “Mas o que Ele lhe fez? Como capacitou você a enxergar novamente?” ");
INSERT INTO portft_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ele respondeu, “Já lhes disse tudo isso, mas os senhores/será que os senhores RHQ não prestaram atenção!? Por que os senhores querem ouvir a minha história de novo? Será que querem/Os senhores falam como se quisessem RHQ tornar-se discípulos dele IRO?”! ");
INSERT INTO portft_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Então eles passaram a insultá-lo, cheios de cólera, dizendo, “Você é discípulo desse homem, mas nós somos discípulos de Moisés! ");
INSERT INTO portft_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sabemos que Deus falou com Moisés, mas quanto a esse homem, não sabemos de onde Ele tira qualquer autoridade”! ");
INSERT INTO portft_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","O homem respondeu, “Que maravilha! Os senhores dizem que não sabem de onde Ele tira qualquer autoridade. Mas Ele me capacitou a enxergar! ");
INSERT INTO portft_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Sabemos que Deus não ajuda os pecadores que oram, pedindo que Deus os ajude. Pelo contrário, Ele escuta e ajuda as pessoas devotas que oram. Ele escuta aqueles que fazem o que Deus deseja. ");
INSERT INTO portft_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ninguém jamais capacitou a enxergar um homem que fosse cego de nascença, como eu. Tal coisa nunca aconteceu até agora! ");
INSERT INTO portft_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Portanto, se esse homem não tivesse vindo de Deus, Ele não poderia fazer nada desse tipo”!  ");
INSERT INTO portft_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Eles lhe responderam, “Você nasceu bastardo/fruto do pecado dos seus pais EUP! Você se considera/Você não é RHQ qualificado a ensinar-nos a nós?”! Então eles o expulsaram da sinagoga. ");
INSERT INTO portft_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus ouviu dizer que eles tinham expulsado aquele homem. Ele localizou o homem e lhe disse, “Você acredita que aquele que veio do céu é o Messias?” ");
INSERT INTO portft_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","O homem respondeu, “Senhor, quem é Ele? Diga-me, por favor, para que eu possa crer nele”. ");
INSERT INTO portft_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus lhe disse, “Você já O viu. De fato, sou eu, que falo com você”. ");
INSERT INTO portft_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","O homem disse, “Senhor, creio que o Senhor é o Messias”! Então ele se ajoelhou diante de Jesus, adorando-O. ");
INSERT INTO portft_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus disse, “Vim a este mundo para julgar os habitantes do mundo. O resultado será que aqueles que se derem conta de que não conhecem a verdade de Deus vão percebê-la. É como MET capacitar os cegos a enxergarem. Mas o resultado também será que as pessoas que pensarem erradamente IRO que entendem a verdade de Deus nunca vão entendê-la. É como MET cegos que permanecem sempre cegos”. ");
INSERT INTO portft_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Alguns dos fariseus que estavam com Ele lhe disseram, “Será que você está querendo dizer que somos como cegos?” ");
INSERT INTO portft_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus lhes disse, “Se vocês se dessem conta de que ainda não conhecem a verdade de Deus, mas que desejam conhecê-la, então seriam como cegos que desejam enxergar. Deus poderia perdoar seus pecados. Mas vocês alegam erradamente que já conhecem a verdade de Deus, portanto são como cegos que afirmam que podem ver. Por isso Deus não pode perdoar seus pecados”. ");
INSERT INTO portft_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesus continuava dizendo aos fariseus, e sobre eles MET, “Escutem bem o que digo. Quem não quiser entrar no curral das ovelhas pela porta, se ele pular o muro e entrar por outra maneira, é ladrão ou bandido. ");
INSERT INTO portft_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","O homem que entra no curral pela porta é o pastor das ovelhas. ");
INSERT INTO portft_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","O homem que vigia a porta de noite abre a porta para ele. As ovelhas reconhecem a voz dele. Ele chama suas próprias ovelhas, chamando os nomes que ele lhes deu. Então ele as guia para fora do curral. ");
INSERT INTO portft_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Após fazer saírem todas as ovelhas dele, ele vai na frente delas. As ovelhas dele o seguem porque reconhecem e obedecem a voz dele. ");
INSERT INTO portft_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mas elas nunca seguem um estranho. Pelo contrário, vão fugir dele, pois não reconhecem a voz do estranho”. ");
INSERT INTO portft_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus disse isso para ilustrar a diferença entre si mesmo e os fariseus, que enganavam o povo. Mas eles não entendiam o que Ele lhes dizia. ");
INSERT INTO portft_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Por isso Jesus falou de novo com eles, dizendo, “Escutem bem o que digo. Estou dizendo que sou como MET uma porta para as ovelhas entrarem no curral por ser eu aquele que permite que as pessoas entrem na presença de Deus.  ");
INSERT INTO portft_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Todos os seus líderes religiosos que vinham antes, sem minha autoridade, são como MET ladrões e bandidos porque agem de uma forma violenta e desonesta em benefício deles mesmos. Mas, assim como as ovelhas não prestam atenção aos estranhos, o povo de Deus não lhes dá ouvidos. ");
INSERT INTO portft_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Sou como uma porta. Todos aqueles serão salvos {Deus vai salvar todos} que vierem a Ele, confiando em mim. Assim como as ovelhas entram e saem em segurança pela porta para encontrar pasto MET, vou providenciar tudo para elas e protegê-las.  ");
INSERT INTO portft_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Os ladrões entram no curral das ovelhas só para roubar ou matar ou destruir as ovelhas MET. Da mesma forma, seus líderes religiosos prejudicam espiritualmente o povo de Deus. Mas eu vim para que as pessoas possam ter a vida eterna/espiritual, e que possam ter abundantemente tudo que precisam para sustentá-las espiritualmente. ");
INSERT INTO portft_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Sou como um bom pastor. Um bom pastor está disposto a morrer para salvar as ovelhas MET. Semelhantemente, estou disposto a me sacrificar para salvar aqueles que me pertencem.  ");
INSERT INTO portft_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Um empregado contratado para cuidar das ovelhas não é o pastor, o dono das ovelhas. Portanto, quando ele vê um lobo se aproximar, ele abandona as ovelhas e foge. Então o lobo ataca o rebanho de ovelhas, pega uma das ovelhas e faz as outras se espalharem. ");
INSERT INTO portft_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","O empregado foge porque é apenas um homem contratado. Ele não se preocupa sobre o que acontece às ovelhas MET. Semelhantemente, seus líderes religiosos não se preocupam sobre o que acontece ao povo de Deus.  ");
INSERT INTO portft_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Sou como um bom pastor. Assim como um pastor conhece suas ovelhas MET, conheço aqueles que me pertencem, e eles me conhecem, ");
INSERT INTO portft_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","bem como meu Pai me conhece e eu conheço meu Pai. Além disso, estou disposto a me sacrificar em benefício daqueles que me pertencem.  ");
INSERT INTO portft_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","E tenho outros que vão me pertencer algum dia, e que não são judeus. Eles serão como MET ovelhas de outro curral. Devo trazê-los para Deus/para mim também. Eles vão prestar atenção àquilo que digo, e eventualmente todos aqueles que me pertencem serão como um rebanho, e serei como MET seu único pastor. ");
INSERT INTO portft_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Meu pai me ama porque vou sacrificar minha vida. Mas depois de fazer isso, vou voltar a viver. ");
INSERT INTO portft_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ninguém me faz morrer. Pelo contrário, eu mesmo me sacrifico. Tenho autoridade para me sacrificar e autoridade para tornar a viver novamente. É isso que meu Pai me mandou fazer”. ");
INSERT INTO portft_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Após ouvir estas palavras ditas por Jesus, os judeus ficaram novamente divididos. ");
INSERT INTO portft_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Muitos deles disseram “Um demônio O controla, fazendo com que fique louco. É inútil/Por que devemos— RHQ escutá-lo!?” ");
INSERT INTO portft_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mas outros disseram, “O que Ele está dizendo não é coisa que diria um homem controlado por um demônio. Nenhum demônio/Como é que um demônio— RHQ poderia fazer um cego ver como Ele fez!?” ");
INSERT INTO portft_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tinha chegado o dia do festival dedicado à lembrança da época quando os antepassados dedicaram novamente o templo em Jerusalém. Era inverno. ");
INSERT INTO portft_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus estava no pátio do templo, andando pelo lugar que as pessoas chamavam o Alpendre do Rei Salomão. ");
INSERT INTO portft_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Os líderes judaicos SYN se reuniram ao redor dele, dizendo, “Até quando você vai nos deixar —na dúvida/sem saber na certa— se é o Messias ou não? Se você é o Messias, diga-nos claramente”! ");
INSERT INTO portft_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus lhes respondeu, “Já lhes disse que sou o Messias, mas vocês não me acreditam! Vocês devem saber quem sou eu por causa dos milagres que faço com autoridade do meu Pai MTY. ");
INSERT INTO portft_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mas em vez disso, pois vocês não me pertencem como MET ovelhas que pertencem ao seu pastor, vocês não creem em mim. ");
INSERT INTO portft_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Assim como as ovelhas obedecem a voz do seu pastor MET, meu povo me obedece. Conheço os de meu povo, e eles se tornaram meus discípulos. ");
INSERT INTO portft_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Vou dar-lhes a vida eterna. Ninguém jamais vai separá-los de mim para sempre. Ninguém vai arrancá-los de mim. ");
INSERT INTO portft_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","O grupo que meu Pai me deu é mais caro/precioso que qualquer outra coisa (OU, Meu Pai, que os deu a mim, é maior que qualquer força oposta a eles). Portanto, ninguém pode arrancá-los de mim MTY. ");
INSERT INTO portft_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Meu pai e eu somos iguais”. ");
INSERT INTO portft_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Os líderes judaicos SYN voltaram a pegar pedras com intenção de apedrejá-lo e matá-lo, pois estavam zangados por Ele haver dito que era igual a Deus. ");
INSERT INTO portft_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mas Jesus lhes disse, “Vocês me viram fazer muitos milagres que meu Pai me mandou fazer. Vocês devem se dar conta, ao verem tais coisas, que sou igual a Deus. Então, por qual desse milagres IRO vocês querem matar-me, apedrejando-me?” ");
INSERT INTO portft_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Os líderes judaicos SYN responderam, “Queremos apedrejá-lo, não porque tenha feito um grande milagre. Em vez disso, estamos querendo fazê-lo porque você não passa de um simples homem, mas alega que é Deus”! ");
INSERT INTO portft_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus lhes respondeu, “Nas Escrituras está escrito {—alguém/o salmista— escreveu} RHQ o que Deus disse aos governantes que Ele tinha nomeado, ‘Eu já disse que vocês são como deuses.’ ");
INSERT INTO portft_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Deus disso isso àqueles líderes quando Ele os nomeou. Ninguém se opôs a isso. E nenhuma afirmação das Escrituras pode ser anulada {ninguém pode anular algo que consta nas Escrituras}. Mas sou eu que meu Pai consagrou para lhe pertencer integralmente. Ele me mandou para cá, a este mundo. ");
INSERT INTO portft_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Por isso, —vocês não devem/por que vocês— RHQ queixar-se/se queixam por eu afirmar que sou Deus? Por que vocês estão/Vocês não devem estar— RHQ zangados comigo por eu haver dito que sou igual a Deus quando digo que sou o Filho de Deus/o homem que é também Deus. ");
INSERT INTO portft_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Se não fossem os milagres que meu Pai me mandou fazer, eu não esperaria que vocês me acreditassem. ");
INSERT INTO portft_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mas, já que faço estes milagres, acreditem aquilo que estes milagres esclarecem sobre mim, mesmo que não acreditem o que digo. Se assim fizerem, saberão e entenderão que meu Pai tem verdadeira intimidade comigo e eu com meu Pai”. ");
INSERT INTO portft_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Após ouvirem isso, eles tentaram pegá-lo novamente, mas Ele se livrou deles. ");
INSERT INTO portft_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Então Jesus voltou conosco para o lado leste do Rio Jordão. Fomos até o lugar onde João antigamente batizava as pessoas. Ele ficou lá por —algum tempo/umas semanas.  ");
INSERT INTO portft_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Muitas pessoas foram ter com Ele. Elas diziam, “João nunca fez nenhum milagre, mas este homem já fez muitos milagres! Tudo que João disse acerca deste homem é verdade”! ");
INSERT INTO portft_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Muitas pessoas que lá foram passaram a crer —que era Ele o Messias/que Ele realmente tinha vindo de Deus. ");
INSERT INTO portft_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Certa vez houve um homem chamado Lázaro, que estava doente. Ele morava na cidadezinha de Betânia, onde moravam também suas irmãs mais velhas, Maria e Marta. ");
INSERT INTO portft_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria foi a mulher que, mais tarde, derramava perfume nos pés do Senhor Jesus e depois enxugou os pés com os cabelos dela. ");
INSERT INTO portft_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Pois as duas irmãs mandaram a Jesus um recado sobre Lázaro, dizendo, “Senhor, aquele que o Senhor ama muito está bem doente.” ");
INSERT INTO portft_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Elas esperavam que Jesus viesse, mas ao ouvir a mensagem delas, Jesus disse, “A razão de ele estar doente não é que vá morrer. Pelo contrário, o propósito é que as pessoas possam se dar conta da grandeza de Deus, e que eu, filho de Deus, possa ser honrado {que as pessoas possam honrar-me, filho de Deus}, por causa do que faço/acontece”. ");
INSERT INTO portft_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus amava Marta, sua irmã Maria, e Lázaro. ");
INSERT INTO portft_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mas ao ouvir que Lázaro estava doente, Ele ficou mais dois dias no lugar onde estava. ");
INSERT INTO portft_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Dois dias depois, Ele disse a nós seus discípulos, “Voltemos para a Judeia”. ");
INSERT INTO portft_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Dissemos, “Mestre, há pouco os líderes judaicos SYN tentaram matar o Senhor, apedrejando-o. Por isso não achamos boa ideia o Senhor/o Senhor tem certeza que realmente quer RHQ voltar para lá novamente!?” ");
INSERT INTO portft_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Para nos mostrar que nada de mal poderia acontecer-lhe até a hora determinada por Deus MET, Jesus respondeu, “Há RHQ doze horas de luz no dia, o qual dá bastante tempo para a gente fazer o que devemos fazer. As pessoas que andam durante o dia não vão tropeçar em coisas que não enxergam, pois elas veem as coisas à luz do sol. ");
INSERT INTO portft_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","É quando andam de noite que as pessoas tropeçam nas coisas, pois carecem de luz”. ");
INSERT INTO portft_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Depois de dizer isso, Ele nos avisou, “Nosso amigo Lázaro acaba de adormecer. Mas vou lá acordá-lo”. ");
INSERT INTO portft_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Por isso dissemos a Ele, “Senhor, se ele está dormindo, vai sarar da sua doença. Por isso o Senhor não precisa arriscar a vida, indo lá”.  ");
INSERT INTO portft_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesus falava em linguagem figurada sobre a morte de Lázaro, mas nós achávamos que Ele se referisse ao sono do amigo. ");
INSERT INTO portft_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Por isso Ele nos disse claramente, “Lázaro está morto. ");
INSERT INTO portft_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mas, por amor de vocês, estou contente de não ter estado presente quando ele morreu, pois quero que vocês acreditem ainda mais firmemente que eu sou o Messias/vim de Deus. Por isso, ao invés de ficarmos aqui, vamos ter com ele”. ");
INSERT INTO portft_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Então Tomé, que se chama {a quem chamavam} ‘o gêmeo’, disse a nós, os demais discípulos, “Vamos todos acompanhá-lo, para morrermos com Ele quando seus inimigos o matarem. ” ");
INSERT INTO portft_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ao chegarmos perto de Betânia, alguém avisou Jesus de que Lázaro tinha morrido e que tinha sido enterrado, estando seu corpo no túmulo durante quatro dias. ");
INSERT INTO portft_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betânia fica a uma distância de menos de três quilômetros. de Jerusalém, ");
INSERT INTO portft_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Muitos judeus tinham chegado de lá para consolar Marta e Maria por ocasião da morte do seu irmão menor. ");
INSERT INTO portft_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Quando Marta ouviu alguém dizer que Jesus estava chegando, ela foi pela estrada para recebê-lo. Mas Maria ficou em casa. ");
INSERT INTO portft_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ao chegar Marta aonde estava Jesus, ela lhe disse, “Senhor, se o Senhor tivesse estado aqui, meu irmão não teria morrido, pois o Senhor o teria curado! ");
INSERT INTO portft_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mas sei que, mesmo agora, Deus lhe dará tudo que pedir acerca do meu irmão”.  ");
INSERT INTO portft_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus disse a ela, “Seu irmão vai voltar a viver”! ");
INSERT INTO portft_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta lhe disse, “Sei que ele voltará a viver quando todos os seres humanos voltarem à vida no dia do Juízo” ");
INSERT INTO portft_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus lhe disse, “Sou eu que capacito as pessoas a voltarem a viver, e quem faz com que elas vivam para sempre. Os que creem em mim, mesmo que morram, voltarão a viver. ");
INSERT INTO portft_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","E mais, para aqueles que creem em mim enquanto estão vivos, o Espírito/alma deles não vai morrer eternamente. Você acredita nisso?” ");
INSERT INTO portft_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ela disse a Ele, “Sim, Senhor! Acredito que o Senhor é o Messias, o Filho de Deus/homem que é também Deus. O Senhor é realmente aquele que Deus prometeu mandar ao mundo”! ");
INSERT INTO portft_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Após dizer isso, ela voltou para casa e, chamando à parte sua irmã Maria, disse a ela, “O Mestre está chegando perto da nossa cidadezinha e quer falar com você”. ");
INSERT INTO portft_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Quando Maria ouviu isso, ela se levantou com pressa e foi ter com Ele. ");
INSERT INTO portft_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus não tinha entrado ainda na cidadezinha, ficando no mesmo lugar onde Marta o tinha encontrado. ");
INSERT INTO portft_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Os judeus que acompanhavam Maria em casa, consolando-a, viram quando Maria se levantou com pressa e saiu correndo. Por isso, eles foram atrás dela, pensando que ela fosse visitar o túmulo onde eles tinham enterrado Lázaro, para chorar sozinha lá. ");
INSERT INTO portft_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ao chegar Maria até o lugar onde estava Jesus, vendo-o ali, ela se prostrou aos pés dele e disse, “Senhor, se o Senhor tivesse estado aqui, meu irmão menor não teria morrido”! ");
INSERT INTO portft_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Quando Jesus a viu chorar, e percebeu que os judeus que tinham vindo com ela também choravam, Ele se zangou (OU, ficou muito perturbado) no seu interior/Espírito por Satanás haver feito o Lázaro morrer.  ");
INSERT INTO portft_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ele disse, “Onde vocês o enterraram/enterraram o corpo dele?” Marta e Maria lhe disseram, “Venha ver, Senhor”. ");
INSERT INTO portft_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus desatou a chorar. ");
INSERT INTO portft_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Então os judeus ali presentes disseram, “Vejam o quanto Ele amava Lázaro”! ");
INSERT INTO portft_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mas alguns deles disseram, “Ele fez um cego enxergar. Portanto também deveria ter podido/por que Ele não pôde RHQ curar este homem para ele não morrer!? ");
INSERT INTO portft_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Dentro de si, Jesus ficou novamente zangado (OU, muito perturbado) por Lázaro ter morrido. Ele foi até o túmulo, que era uma gruta. Eles tinham tapado a entrada com uma imensa pedra. ");
INSERT INTO portft_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus mandou, “Tirem a pedra”! Marta não quis que assim procedessem, pois era ela irmã do falecido. Ela disse, “Senhor, o corpo dele está no túmulo há quatro dias já, portanto agora há um cheiro ruim”! ");
INSERT INTO portft_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus disse a ela, “Eu já lhe disse/Você já se esqueceu de que lhe disse que RHQ se você cresse em mim/aquilo que posso fazer, veria quão grande é Deus!?” ");
INSERT INTO portft_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Por isso eles tiraram a pedra. Então Jesus olhou para o céu e disse, “Meu Pai, eu lhe agradeço por ter-me ouvido quando orei sobre isto.  ");
INSERT INTO portft_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Sei que o Senhor sempre me ouve quando oro. Mas em vez de orar em silêncio, eu disse isso por causa das pessoas que aqui estão a meu redor. Quero que elas creiam que o Senhor me mandou”. ");
INSERT INTO portft_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Após dizer isso, Ele gritou, “Saia, Lázaro”! ");
INSERT INTO portft_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","O homem que estivera morto saiu do túmulo! As tiras de pano de linho envolviam ainda os pés e mãos dele, e um pano ainda estava enrolado em volta do rosto dele, mas ele saiu! Jesus disse a eles, “Tirem os panos para ele andar com facilidade”! E assim fizeram. ");
INSERT INTO portft_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Como consequência disso, muitos dos judeus que tinham vindo ver Maria, e que tinham observado o que Jesus tinha feito, passaram a crer que Ele era o Messias/tinha vindo de Deus. ");
INSERT INTO portft_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mas alguns deles foram avisar os fariseus do que Jesus tinha feito. ");
INSERT INTO portft_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Por isso os principais sacerdotes e fariseus convocaram todos os membros do Conselho Judaico. Eles diziam uns aos outros, “O que vamos fazer com Jesus? Ele está fazendo muitos milagres! ");
INSERT INTO portft_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Se deixarmos que Ele continue assim, todo o mundo vai crer nele/que Ele é o Messias, e o povo vai fazê-lo rei. Então o exército romano virá destruir nosso templo e toda nossa nação de Israel”! ");
INSERT INTO portft_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Um dos membros do Conselho foi Caifás. Ele era o sumo sacerdote judaico aquele ano. Dando o palpite de que eles deveriam acabar com Jesus, ele lhes disse, “Vocês estão falando como se não soubessem nada HYP! ");
INSERT INTO portft_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Vocês nem se dão conta de que seria melhor para nós se um homem morresse em benefício do povo, ao invés de os romanos matarem todos os da nossa nação judaica”!  ");
INSERT INTO portft_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ele falou assim, não por ele mesmo ter inventado a ideia, senão que, por ser naquele ano o sumo sacerdote, estava vaticinando que Jesus iria morrer por toda a nação judaica. ");
INSERT INTO portft_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mas ele também vaticinava que Ele iria morrer, não somente pelos judeus, mas por todos aqueles habitantes em outras terras que fossem pertencer a Deus, para unir todos eles como um só grupo. ");
INSERT INTO portft_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Portanto, daquele dia em diante, os líderes judaicos começaram a planejar a morte de Jesus. ");
INSERT INTO portft_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Por isso Jesus já não viajava publicamente/acompanhado. Em vez disso, Ele saiu de Jerusalém conosco, os discípulos e se dirigiu a uma cidadezinha chamada Efraim, numa região perto do deserto. Ali ficamos por algum tempo. ");
INSERT INTO portft_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Quando já estava quase na altura do festival judaico da Páscoa, muitos judeus subiram a Jerusalém de outras regiões do país. Eles iam praticar os ritos que os tornavam aceitos a Deus antes do início da comemoração da Páscoa. ");
INSERT INTO portft_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Os principais sacerdotes e fariseus judaicos publicaram uma ordem mandando que, se alguém soubesse onde estava Jesus, fosse avisar-lhes, para que pudessem prendê-lo. Por isso eles não sabiam se Jesus se atreveria a assistir o festival. Eles continuavam procurando Jesus. Enquanto ficavam no pátio do templo, eles se diziam, “Que lhes parece? Será que Ele virá assistir o festival?” ");
INSERT INTO portft_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seis dias antes do início do festival da Páscoa, Jesus chegou conosco à cidadezinha de Betânia. Foi ali onde morava Lázaro, o homem que anteriormente Jesus tinha feito voltar a viver, após a morte dele. ");
INSERT INTO portft_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Eles prepararam ali um jantar em homenagem a Jesus. Marta servia a comida, e seu irmão Lázaro se encontrava entre os convidados que jantavam com ele. ");
INSERT INTO portft_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Então Maria pegou um frasco de perfume de nardo, que era muito caro, e derramou o perfume nos pés de Jesus para honrá-lo. Depois, ela enxugou os pés dele com os cabelos. A casa inteira se enchia do delicioso aroma do perfume. ");
INSERT INTO portft_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mas um dos discípulos de Jesus se opôs ao gesto dela. Foi Judas Iscariotes/da cidadezinha de Cariote. Foi ele que, dias depois, possibilitou que os inimigos de Jesus o prendessem. ");
INSERT INTO portft_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ele disse, “Esse perfume devia ter sido/Por que esse perfume não foi RHQ vendido e o dinheiro da venda doado {Deveríamos ter vendido/Por que não vendemos RHQ esse perfume e doamos o valor dele} aos pobres!? Poderíamos ter lucrado por ele o equivalente do ordenado de 300 dias”! ");
INSERT INTO portft_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ele falou assim, não porque se importasse com os pobres, mas porque era ladrão. Ele costumava guardar a bolsa de dinheiro contribuído pelas pessoas para ajudar Jesus e nós seus discípulos, e tirava regularmente uma parte do dinheiro depositado nela {que as pessoas}depositavam nela. ");
INSERT INTO portft_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Então Jesus disse “Não a incomodem! Ela comprou esse perfume para guardá-lo até o dia de me enterrarem após minha morte. ");
INSERT INTO portft_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Haverá sempre pobres entre vocês, portanto vocês poderão ajudá-los quando quiserem. Mas eu não vou estar para sempre/por mais tempo com vocês, portanto foi bom ela ter demonstrado agora mesmo o quanto me estimava”. ");
INSERT INTO portft_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Uma grande multidão de judeus ouviu dizer que Jesus estava ali em Betânia. Muitos deles chegaram, não somente para ver Jesus, mas também para ver Lázaro, o homem que Ele tinha ressuscitado após a morte dele. ");
INSERT INTO portft_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Por isso os principais sacerdotes resolveram matar Lázaro também,  ");
INSERT INTO portft_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","pois muitos dos judeus os desertavam e se filiavam a Jesus, acreditando nele por causa do que tinha acontecido a Lázaro/fato de Jesus ter feito Lázaro voltar a viver novamente. ");
INSERT INTO portft_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","No dia seguinte a grande multidão de pessoas que tinham vindo a Jerusalém para o festival ouviu dizer que Jesus estava se aproximando de Jerusalém. ");
INSERT INTO portft_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Eles cortaram ramos de algumas palmeiras e os carregavam para fora da cidade para agitar no ar ao se encontrarem com Ele. Eles gritavam, “Viva/Louvado seja Deus! Que seja bendito {Que Deus abençoe aquele } que vem com a autoridade de Deus MTY! Bendito seja {Que Deus abençoe} o rei de Israel! ");
INSERT INTO portft_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ao chegar Jesus perto de Jerusalém, conseguiu um jumentinho e montou nele, entrando na cidade assim sentado. Ao fazer isso, ele cumpriu aquilo que tinha sido escrito {que um profeta tinha escrito} nas Escrituras, ");
INSERT INTO portft_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Vocês habitantes de Jerusalém, Não tenham medo! Olhem! Seu rei está chegando! Ele vem montado num jumentinho! ");
INSERT INTO portft_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Inicialmente, nós discípulos não entendemos essas coisas. Porém, após Jesus voltar ao céu, nós nos demos conta de que essas coisas tinham sido escritas {que um profeta tinha escrito essas coisas} sobre Ele, e que, fazendo-lhe tais coisas, eles tinham cumprido aquilo que o profeta tinha vaticinado. ");
INSERT INTO portft_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","A multidão que o acompanhava continuava relatando às demais pessoas como Ele tinha chamado Lázaro para sair do túmulo, e como Lázaro tinha voltado à vida após morrer. ");
INSERT INTO portft_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Por isso muitas pessoas, ao ouvir os relatórios desse milagre, foram ter com Ele. ");
INSERT INTO portft_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Portanto os fariseus se diziam, “Obviamente não estamos tendo nenhum êxito na nossa tentativa de impedi-lo! Parece que HYP todos MTY estão se tornando discípulos dele”! ");
INSERT INTO portft_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Entre aqueles que subiram a Jerusalém para adorar a Deus durante o festival havia alguns gregos. ");
INSERT INTO portft_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Eles foram ter com Filipe, que era da cidadezinha de Betsaida na província da Galileia. Desejavam que Ele fizesse algo para eles. Disseram, “Senhor, desejamos falar com Jesus”. ");
INSERT INTO portft_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Por isso Filipe foi avisar o André, e ambos foram avisar Jesus. ");
INSERT INTO portft_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Então, para lhes mostrar que Ele deveria morrer para dar vida eterna aos não judeus, como aqueles gregos, Jesus lhes respondeu, “Chegou a hora de eu, que vim do céu, ser honrado {para Deus me honrar, sendo eu aquele que veio do céu}. Isso vai acontecer quando eu morrer.  ");
INSERT INTO portft_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Escutem bem o seguinte: Minha vida é como uma semente MET. Se ninguém plantar um grão de cereal na terra, esse grão não vai se transformar; permanece uma só semente. Mas se ela mudar dentro da terra, vai crescer e produzir muitas sementes. ");
INSERT INTO portft_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Quem desejar fortemente continuar vivendo aqui na terra vai com certeza morrer para sempre. Mas quem estiver disposto a morrer HYP por minha causa vai com certeza ganhar a vida eterna. ");
INSERT INTO portft_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Se algum desses gregos, ou outra pessoa qualquer, quiser me servir, deve tornar-se meu discípulo. Então, após morrer, estará onde eu estou, no céu. Meu Pai vai honrar todos aqueles que me servem. ");
INSERT INTO portft_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Agora sinto-me perturbado no meu interior. Não sei que/Que devo RHQ dizer!? Devo dizer, “Meu Pai, livre-me desta hora em que vou sofrer e morrer!?” Não, não devo dizer isso, pois o motivo de eu vir a este mundo/do céu foi que sofresse agora. ");
INSERT INTO portft_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Meu Pai, mostre a sua grandeza”! Então Deus falou EUP do céu, dizendo, “Já mostrei quão grande sou, e vou fazê-lo de novo”! ");
INSERT INTO portft_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A multidão que lá estava ouviu a voz. Alguns achavam que era trovão. Outros diziam que um anjo tinha falado a Ele. ");
INSERT INTO portft_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus lhes respondeu, “A voz que vocês ouviram veio de Deus, mas não foi por minha causa. Pelo contrário, foi por causa de vocês. ");
INSERT INTO portft_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Agora é hora de Deus julgar os habitantes do MTY mundo. Agora é hora de ser destruído {de eu/Deus destruir o poder de Satanás, aquele que governa este mundo}. ");
INSERT INTO portft_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mas quanto a mim, quando eu for levantado {quando os homens me levantarem} da terra em uma cruz, vou fazer com que todas as pessoas sejam atraídas a mim”. ");
INSERT INTO portft_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ele falou assim para nos mostrar a maneira em que iria morrer. ");
INSERT INTO portft_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Alguém na multidão lhe respondeu, “Entendemos das Escrituras que o Messias vai viver para sempre. Portanto, por que o Senhor diz RHQ que aquele que veio do céu, que é o Messias, vai ser levantado {que os homens vão levantar aquele que veio do céu, que é o Messias} em uma cruz? De que tipo de homem que veio do céu o Senhor está falando? (OU, Não é esse o tipo de Messias que nós estamos aguardando!)” ");
INSERT INTO portft_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Então Jesus lhes disse, “Minha mensagem é como MET uma luz para vocês. Vou estar pouco tempo com vocês. Vivam e comportem-se como devem enquanto ainda estou com vocês, antes de não terem mais oportunidade de ouvir minha mensagem, como MET alguém ao redor do qual escurece de repente, de maneira que ele não possa enxergar mais aonde vai.  ");
INSERT INTO portft_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Creiam em minha mensagem enquanto ainda têm a oportunidade de assim fazer, para que possam se tornar pessoas que possuem minha verdade MET dentro de si”! ");
INSERT INTO portft_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Embora Ele tivesse feito muitos milagres diante das pessoas, a maioria delas recusou acreditar que Ele fosse o Messias/de Deus.  ");
INSERT INTO portft_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Assim foi cumprido {Isso} cumpriu o que o profeta Isaías tinha escrito há muito tempo antes: Senhor, quase ninguém/quem RHQ acreditou nossa mensagem!? Eles recusaram aceitá-la, mesmo que seu poder MTY lhes foi demonstrado {O Senhor lhes mostrou seu poder}MTY RHQ! ");
INSERT INTO portft_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Essa foi a razão porque eles recusaram crer. Foi como escreveu Isaías, em outro trecho, que Deus tinha dito: ");
INSERT INTO portft_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Eles recusaram entender, como pessoas que MET cegaram seus próprios olhos, E se tornaram insensíveis. Como resultado, eles não perceberam MET minha verdade. Não a entenderam no seu interior. Não abandonaram a vida pecaminosa,  Portanto não posso ajudá-los. ");
INSERT INTO portft_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías escreveu isso porque era como se ele percebesse antecipadamente quão grande seria Jesus, e por isso vaticinasse tais coisas acerca dele. ");
INSERT INTO portft_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Embora a maioria dos líderes judaicos SYN não acreditasse que Jesus fosse o Messias/de Deus, alguns deles passaram a crer nele. Mas não deixavam ninguém saber que acreditavam nele, pois tinham medo de ser impedidos pelos fariseus de adorarem nas sinagogas, se assim falassem.  ");
INSERT INTO portft_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Eles desejavam mais ser elogiados pelas outras pessoas do que ser elogiados por Deus. ");
INSERT INTO portft_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Então Jesus gritou, “Aqueles que crerem em mim, não creem somente em mim. Pelo contrário, é como se também cressem naquele que me enviou. ");
INSERT INTO portft_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Quando me veem, e observam o que estou fazendo, é como se estivessem vendo aquele que me enviou. ");
INSERT INTO portft_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Vim ao mundo para mostrar a verdade de Deus às pessoas, como uma luz mostra às pessoas o que está ao redor delas. Vim para que as pessoas que creem em mim não permaneçam ignorantes da verdade de Deus MET, como aqueles que estão na escuridão ignoram o que está ao redor deles. ");
INSERT INTO portft_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Quanto àqueles que ouvem minha mensagem mas não prestam atenção a ela, não sou eu quem os julga. A principal razão da minha vinda ao mundo/do céu não foi eu julgar os habitantes do MTY mundo. Pelo contrário, vim salvá-los de serem castigados por seus pecados.  ");
INSERT INTO portft_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aqueles que me rejeitarem e não aceitarem minha mensagem serão julgados. No dia do juízo, Deus vai dizer que eles devem ser castigados por terem rejeitado a mensagem que eu lhes comuniquei. ");
INSERT INTO portft_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Pois eu não tenho dito nada com minha própria autoridade. Pelo contrário, meu Pai, aquele que me enviou, me mandou o que dizer e como dizê-lo. ");
INSERT INTO portft_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Sei que obedecer aquilo que Ele nos manda nos conduz à vida eterna. Por isso, tudo aquilo que eu disser é somente aquilo que meu Pai me mandou dizer”. ");
INSERT INTO portft_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Quando já era tarde na véspera do festival da Páscoa, Jesus sabia que tinha chegado a hora de Ele deixar este mundo para voltar ao seu Pai no céu. Ele nos amava, a nós seus discípulos. Ele sabia que nós iríamos continuar vivendo aqui neste mundo, portanto nos mostrou agora o quanto nos amava. ");
INSERT INTO portft_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Estávamos comemorando o jantar da Páscoa. O diabo/Satanás já tinha sugerido a Judas Iscariotes/da aldeia de Cariote, filho de Simão, que ele fosse trair Jesus/possibilitar que os inimigos de Jesus o prendessem. ");
INSERT INTO portft_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Mas Jesus sabia que seu Pai lhe tinha dado total autoridade para controlar a situação, Ele sabia que tinha vindo de Deus e logo iria voltar para Deus. ");
INSERT INTO portft_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mas antes de assim fazer, Ele desejava mostrar-nos como devíamos amar-nos uns aos outros. Por isso Ele se levantou do lugar onde estava jantando. Tirou a capa exterior. Amarrou à cintura, a modo de escravo, uma longa toalha. ");
INSERT INTO portft_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Então derramou água em uma bacia. Começou a lavar-nos os pés, e depois os enxugava com a toalha que tinha amarrado em volta de si. ");
INSERT INTO portft_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ao chegar Ele a Simão Pedro, este lhe disse, “Senhor, O Senhor está para/não está certo O Senhor RHQ humilhar-se assim, lavando meus pés!?” ");
INSERT INTO portft_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus lhe respondeu, “Você não entende agora o significado daquilo que estou fazendo, mas depois vai entender”. ");
INSERT INTO portft_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro disse, “Nunca, mas nunca, vou permitir que O Senhor lave meus pés”! Jesus lhe respondeu, “Se eu não lavar você, você não pode continuar sendo meu discípulo/pertencendo-me”.  ");
INSERT INTO portft_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Por isso Simão Pedro lhe disse, “Senhor, nesse caso, não lave apenas meus pés. Lave também minhas mãos e minha cabeça”! ");
INSERT INTO portft_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Então, para lhe mostrar que aqueles que Ele/Deus tinha lavado da culpa dos pecados só precisavam, depois dessa lavagem, que Deus perdoasse seus pecados cotidianos MET, Jesus lhe disse, “Quem tiver tomado banho, pouco depois precisa apenas lavar os pés, pois eles se sujam facilmente nos caminhos poeirentos. O resto do corpo dele está limpo. De igual forma, eu tornei vocês, meus discípulos --livres/limpos da culpa dos seus pecados, mesmo que nem todos vocês estejam isentos de culpa”. ");
INSERT INTO portft_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ele sabia qual de nós iria traí-lo. Foi por isso que disse, “Nem todos vocês estão isentos de culpa”. ");
INSERT INTO portft_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Depois de lavar nossos pés, Ele vestiu a capa novamente. Então se sentou e nos disse, “Vocês querem/Quero que vocês RHQ entender/entendam o que lhes fiz?! ");
INSERT INTO portft_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Vocês me mostram o seu respeito, chamando-me de ‘Mestre’ e ‘Senhor’. E têm razão ao dizer isso, pois sou seu mestre e seu senhor. ");
INSERT INTO portft_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mas se eu, seu mestre e senhor, lavei os pés de vocês, vocês devem servir-se uns aos outros mediante gestos como lavar-se mutuamente os pés. ");
INSERT INTO portft_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Eu me tornei exemplo para vocês, para que possam servir-se humildemente uns aos outros como eu lhes servi. ");
INSERT INTO portft_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Escutem bem o seguinte: Um servo não costuma ser mais importante que seu senhor. Um mensageiro não é mais importante que aquele que o enviou com a mensagem. Portanto, já que vocês não são mais importantes que eu, não devem ser orgulhosos nem recusar servir-se uns aos outros.  ");
INSERT INTO portft_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Já que agora sabem estas coisas, Deus vai --abençoar/ficar contente com vocês se as praticarem”. ");
INSERT INTO portft_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Não estou dizendo que Deus vai abençoar todos vocês. Eu sabia como eram todos vocês quando os escolhi. Mas também escolhi aquele que vai me trair, para que se cumpra aquilo que está escrito nas Escrituras {para cumprir o que alguém/o salmista escreveu nas Escrituras}: ‘Aquele que se comporta como meu amigo, jantando comigo, tornou-se meu inimigo IDM.’ ");
INSERT INTO portft_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Estou falando-lhes de alguém que vai me trair, antes mesmo de acontecer essa traição, para que, quando acontecer, vocês possam continuar acreditando que eu sou o Messias/aquele que afirmo que sou.  ");
INSERT INTO portft_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Escutem bem o seguinte: quem aceitar qualquer um de vocês que envio, Deus vai achar que esse está me aceitando pessoalmente. E quem me aceitar, Deus vai achar que esse está aceitando meu Pai que me enviou”. ");
INSERT INTO portft_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Após Jesus dizer isto, Ele ficou bem perturbado no seu interior. Declarou solenemente, “Escutem bem o seguinte: um de vocês vai possibilitar que meus inimigos me prendam”. ");
INSERT INTO portft_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nós olhamos uns para os outros. Não tínhamos a mínima ideia de quem Ele falava. ");
INSERT INTO portft_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Eu, que as pessoas chamam ‘aquele que Jesus amava’, estava sentado pertinho de Jesus. ");
INSERT INTO portft_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simão Pedro fez um sinal para mim, indicando que eu deveria perguntar-lhe de quem falava. ");
INSERT INTO portft_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Por isso me encostei mais perto de Jesus e lhe perguntei, “Senhor quem é?” ");
INSERT INTO portft_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus respondeu, “É aquele a quem vou dar este pedacinho de pão após molhá-lo no molho no pires”. Então, para mostrar que Ele sabia quem iria traí-lo, após molhar o pão no molho, Ele o entregou a Judas Iscariotes/da aldeia de Cariote. ");
INSERT INTO portft_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Logo depois de Judas comer o pão, Satanás se apoderou dele. Então Jesus lhe disse, “Aquilo que você vai fazer, faça logo”. ");
INSERT INTO portft_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mas nenhum dos outros que estavam sentados ali conosco sabia por que Jesus falou assim a Judas. ");
INSERT INTO portft_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Já que Judas cuidava do dinheiro que as pessoas contribuíam para nos ajudar, alguns achavam que Jesus lhe mandava ir comprar algumas necessidades para o festival. Alguns achavam que Ele lhe mandava dar algum dinheiro aos pobres. ");
INSERT INTO portft_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Logo que Judas tinha comido o pão, ele saiu. Estava escuro lá fora, e também estava escuro MET na alma dele. ");
INSERT INTO portft_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Depois de Judas ter saído, Jesus disse, “Agora sei que vai ser mostrado {meu Pai vai mostrar} quão grande/maravilhoso sou eu, aquele que veio do céu. E será visto {as pessoas vão ver} quão grande é Deus, por meio daquilo que faço.  ");
INSERT INTO portft_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Já que será visto {as pessoas vão ver quão grande é Deus}, por meio daquilo que faço, Deus mesmo vai mostrar às pessoas quão grande sou eu. E Ele vai fazer isso em breve”. ");
INSERT INTO portft_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Vocês que eu amo como se fossem meus filhos, vou estar pouco tempo com vocês. Depois, vocês vão me procurar, mas não estarei mais aqui. Bem como disse aos líderes judaicos SYN, estou lhes dizendo agora, que vocês ainda não poderão chegar aonde eu vou. ");
INSERT INTO portft_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Agora eu lhes dou um novo mandamento: vocês devem amar uns aos outros. Vocês devem amar uns aos outros como eu amei vocês. ");
INSERT INTO portft_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Se continuarem amando-se mutuamente, todos os que são cientes disso HYP vão saber que são meus discípulos”. ");
INSERT INTO portft_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simão Pedro disse a Ele, “Senhor, para onde O Senhor vai?” Jesus respondeu, “Vocês não podem acompanhar-me agora ao lugar para onde vou, mas depois vocês vão chegar lá”. ");
INSERT INTO portft_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro disse, “Senhor, por que não posso acompanhá-lo agora? Estou pronto para morrer pelo Senhor”! ");
INSERT INTO portft_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus respondeu, “Você está dizendo/Será que você está dizendo RHQ que está pronto para morrer por mim!? Mas a verdade é que, antes que o galo cante amanhã de madrugada, você vai dizer três vezes que nem me conhece”! ");
INSERT INTO portft_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesus continuou dizendo-nos, “Deixem de ficar ansiosos/preocupados. Continuem confiando em Deus (OU, Vocês estão confiando em Deus); continuem confiando também em mim. ");
INSERT INTO portft_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","No lugar onde está meu Pai no céu, há muito espaço! Se isso não fosse verdade, eu lhes teria dito. Estou para ir lá preparar um lugar para vocês. ");
INSERT INTO portft_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Já que vou lá para preparar um lugar para vocês, também voltarei para levar vocês para que possam ficar lá comigo. Vou fazer isso para que vocês possam estar onde eu estou. ");
INSERT INTO portft_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Vocês já conhecem o caminho para o lugar aonde eu vou”. ");
INSERT INTO portft_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomé lhe disse, “Senhor, não sabemos para onde o Senhor vai. Portanto, como podemos conhecer o caminho?” ");
INSERT INTO portft_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus disse a ele, “Sou o caminho MET para onde meu Pai está. Sou aquele que revela MET a verdade sobre Deus e que dá a vida eterna às pessoas. Sou o único que pode capacitar as pessoas a chegarem até meu Pai. Não há outro jeito ou caminho. ");
INSERT INTO portft_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Já que vocês me conhecem e sabem quem realmente sou (OU, Se vocês realmente soubessem quem eu sou), vão conhecer (OU, teriam conhecido) meu Pai também. Daqui em diante, vocês o conhecem, e é como se o tivessem visto”. ");
INSERT INTO portft_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipe disse a Ele, “Senhor, mostre-nos seu Pai e isso nos basta”! ");
INSERT INTO portft_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus lhe disse, “Filipe, estou com vocês há muito tempo já. Portanto com certeza devem/por que vocês não saber/sabem RHQ quem eu realmente sou!? Para aqueles que me viram, é como se tivessem visto meu Pai. Por isso vocês não devem/por que vocês RHQ dizer/dizem, ‘Mostre-nos seu Pai’!? ");
INSERT INTO portft_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Vocês devem/Será que vocês não RHQ crer/creem que desfruto intimidade com meu Pai, e que meu Pai tem uma íntima relação comigo!? A mensagem que comunico a vocês não vem somente de mim. Meu Pai, que tem uma íntima relação comigo, capacita-me a ensinar e fazer os milagres que Ele deseja que eu realize.  ");
INSERT INTO portft_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Creiam que desfruto intimidade com meu Pai, e que meu Pai tem uma íntima relação comigo. Se não crerem isso por causa de minhas palavras, creiam-no por causa dos próprios milagres que tenho feito.  ");
INSERT INTO portft_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Escutem bem o seguinte: Qualquer de vocês que confiar em mim vai fazer os tipos de milagres que eu tenho feito. Por causa -- daquilo que vou fazer por vocês/de eu mandar a vocês o Espírito de Deus depois de voltar a meu Pai, vocês poderão fazer milagres ainda maiores que aqueles que eu tenho feito.  ");
INSERT INTO portft_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","E tudo que vocês me pedirem para fazer por me pertencerem/com minha autoridade MTY, isso vou fazer, para mostrar a vocês quão grande é meu Pai. ");
INSERT INTO portft_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tudo que pedirem para meu Pai fazer por me pertencerem/com minha autoridade MTY, isso vou fazer. ");
INSERT INTO portft_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Se vocês me amam, vão fazer o que eu lhes mandei fazer. ");
INSERT INTO portft_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Então eu mesmo vou pedir a meu Pai, e Ele lhes mandará mais alguém que vai encorajá-los/ser como conselheiro legal para vocês. ");
INSERT INTO portft_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Refiro-me ao Espírito quem vai ensinar-lhes a verdade de Deus. Ele vai estar para sempre com vocês. Aqueles que se opõem a Deus MTY não podem recebê-lo, pois não conseguem entender o que Ele faz, nem quem é Ele. Mas vocês sabem quem é Ele, pois Ele está com vocês e vai estar dentro de vocês. ");
INSERT INTO portft_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Quando eu partir, não vou deixar vocês sozinhos/desamparados MET. Quando eu mandar o Espírito, será como se eu voltasse para vocês. ");
INSERT INTO portft_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Daqui a pouco, aqueles que não pertencem a Deus não me verão mais. Mas quando o Espírito vier a vocês, será como se vocês me vissem de novo (OU, Mas, após eu voltar à vida, vocês vão me ver de novo.) Já que estarei vivo novamente, vocês também vão ter a vida eterna.  ");
INSERT INTO portft_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Naquela hora vocês vão saber que tenho uma íntima relação com meu Pai, e vocês vão desfrutar intimidade comigo, e eu com vocês. ");
INSERT INTO portft_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Aqueles que tiverem aceitado meus mandamentos, obedecendo-os, são os que me amam. Aqueles que me amam serão amados por meu Pai. {Meu Pai vai amar aqueles que me amam}. Também vou amá-los, e lhes revelarei como sou, realmente”. ");
INSERT INTO portft_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Então Judas lhe falou. Não foi Judas Iscariotes, senão um homem também chamado Tadeu/cujo pai se chamava Tiago. Ele disse, “Senhor, o que aconteceu, para o Senhor poder nos revelar como é realmente, e não revelar a mesma informação àqueles que não pertencem a Deus?” ");
INSERT INTO portft_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus lhe respondeu, “Aqueles que me amam vão obedecer aquilo que eu lhes disse. Meu Pai também vai amá-los. São aquelas pessoas com quem vamos poder vir morar/ter uma íntima relação. ");
INSERT INTO portft_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mas aqueles que não me amam não vão obedecer aquilo que eu lhes disse. Por isso não posso revelar a eles como sou realmente. Estas palavras que lhes digo não se originam comigo. Elas vieram do meu Pai, aquele que me enviou. ");
INSERT INTO portft_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Já lhes tenho dito todas estas coisas enquanto ainda estou aqui com vocês. ");
INSERT INTO portft_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mas meu Pai vai mandar o Espírito Santo. É Ele quem vai encorajá-los/ser como conselheiro legal para vocês. Ele virá com minha autoridade MTY. Ele vai ensinar-lhes toda a verdade de Deus que devem saber. Ele também vai fazer com que vocês se lembrem de todas as coisas que lhes tenho dito. ");
INSERT INTO portft_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ao deixar vocês, dou-lhes paz no seu interior. Esta paz interna vem de mim. Não faço com que vocês tenham algo que lhes pudessem dar aqueles que não pertencem a Deus MTY. Portanto, deixem de ficar ansiosos/preocupados, e não tenham medo. ");
INSERT INTO portft_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Vocês me ouviram dizer, ‘Vou partir, mas depois voltarei a vocês’. Se vocês me amassem, ficariam contentes com minha volta para o Pai, pois meu Pai é maior que eu, e lá Ele vai me honrar e vai mandar-lhes o Espírito.  ");
INSERT INTO portft_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Já lhes tenho dito estas coisas agora, antes que aconteçam, para que, quando acontecerem, vocês possam crer que é verdade aquilo que eu disse.  ");
INSERT INTO portft_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Não vou poder falar mais tempo com vocês, pois aquilo que me acontece será como se Satanás, o governante deste mundo, viesse me atacar. Ele não tem controle sobre aquilo que me acontece. ");
INSERT INTO portft_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pelo contrário, as pessoas que não pertencem a Deus MTY devem aprender, daquilo que me acontecer, que amo meu Pai e faço as coisas que Ele me mandou fazer. Então, levantemo-nos e vamos embora daqui”. ");
INSERT INTO portft_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesus nos falava enquanto íamos caminhando. Falando de uma forma figurada da necessidade de vivermos de uma maneira agradável a Deus, Ele disse, “Sou como MET uma videira verdadeira, não como aqueles israelitas que não ensinam a verdade. Meu Pai é como MET um homem que cuida do vinhedo. ");
INSERT INTO portft_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Assim como um agricultor corta os ramos que não produzem uvas MET, Deus acaba com aqueles que afirmam que pertencem a Ele, mas que não lhe agradam. Os ramos que produzem fruto são podados pelo agricultor para que possam produzir mais uvas ainda. Da mesma forma, meu Pai disciplina/corrige aqueles que vivem de uma forma agradável a Ele.  ");
INSERT INTO portft_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Vocês já são como os ramos que o agricultor poda, pois já creem a mensagem que eu lhes comuniquei. ");
INSERT INTO portft_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Permaneçam numa íntima relação comigo. Se assim fizerem, vou permanecer numa íntima relação com vocês. Um ramo de videira não pode produzir fruto sozinho. Para produzir fruto, ele tem que permanecer unido à videira. Semelhantemente, vocês não podem viver da forma que Deus quer que vivam se não permanecerem unidos comigo. MET ");
INSERT INTO portft_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Sou como MET uma videira. Vocês são como MET os ramos. Todos os que permanecerem numa íntima relação comigo, e eu com eles, farão muitas coisas agradáveis a Deus, como MET uma videira que produz muito fruto. Lembrem-se de que, sem minha ajuda, não poderão fazer nada HYP que realmente seja do agrado de Deus.  ");
INSERT INTO portft_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mas serão rejeitados {Deus vai rejeitar} todos aqueles que não permanecerem numa íntima relação comigo, como um agricultor corta e joga fora os ramos inúteis. Então, após eles ficarem murchos, alguém os apanha e joga numa fogueira, onde são queimados {e os queima}. SIM ");
INSERT INTO portft_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Se vocês permanecerem numa íntima relação comigo e seguirem vivendo de acordo com minha mensagem, poderão pedir que Deus lhes dê qualquer coisa, e Ele vai dar a vocês. ");
INSERT INTO portft_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Meu Pai é honrado pelo fato de vocês {A maneira de vocês honrarem meu Pai é por} fazerem muitas coisas que sejam do agrado dele MET, e ao procederem assim vocês vão provar que são meus discípulos. ");
INSERT INTO portft_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tenho amado vocês da mesma forma como meu Pai me tem amado. Ora, continuem vivendo de uma forma apropriada para aqueles que eu amo. ");
INSERT INTO portft_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Se obedecerem ao que lhes mandei, vocês estarão vivendo de uma forma apropriada para aqueles que amo, bem como eu tenho obedecido aquilo que meu Pai me mandou, vivendo de uma forma apropriada para os que Ele ama. ");
INSERT INTO portft_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Tenho dito estas coisas a vocês para que possam ter a mesma alegria que eu tenho, ficando cheios de alegria. ");
INSERT INTO portft_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Aquilo que lhes mando é o seguinte: amem uns aos outros como eu os amo. ");
INSERT INTO portft_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","A melhor maneira de mostrar o amor é morrer pela pessoa que ama. Não há maneira de amar de uma forma superior a essa. ");
INSERT INTO portft_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Vocês mostram que são meus amigos ao continuarem fazendo aquilo que lhes mandei fazer. ");
INSERT INTO portft_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Já não os chamo meus servos, pois os servos não entendem por que seu patrão quer que façam determinadas coisas. Pelo contrário, eu já os chamei de amigos meus, pois tudo que meu Pai me disse tenho revelado a vocês, como faz um amigo.  ");
INSERT INTO portft_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Vocês não resolveram tornar-se meus discípulos. Pelo contrário, fui eu que escolhi vocês, para que pudessem fazer muitas coisas agradáveis a Ele MET. O resultado das suas ações vai durar para sempre. Também escolhi vocês para que meu Pai faça por vocês tudo que vocês pedirem para Ele fazer pois vocês me pertencem/na minha autoridade MTY. ");
INSERT INTO portft_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Repito agora aquilo que já lhes mandei: amem uns aos outros. ");
INSERT INTO portft_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Quando os que se opõem a Deus MTY odiarem vocês, lembrem-se de que eles me odiavam primeiro. ");
INSERT INTO portft_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Se vocês pertencessem ao grupo daqueles que se opõem a Deus MTY, eles amariam vocês como amam os que lhes pertencem. Mas vocês não pertencem ao grupo daqueles quem se opõem a Deus MTY. Pelo contrário, escolhi vocês para que pudessem afastar-se daqueles quem não pertencem/se opõem a Deus MTY. É por isso que aqueles quem se opõem a Deus MTY odeiam vocês. ");
INSERT INTO portft_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Lembrem-se destas palavras que lhes disse: ‘Não há servo superior a seu patrão’. Isto significa que vocês, meus servos, não podem esperar que as pessoas os tratem de uma forma superior à forma em que me tratam. Portanto, já que eles me perseguem, vão perseguir vocês também. Se eles tivessem prestado atenção às coisas que lhes ensinei, também teriam prestado atenção às coisas que vocês lhes ensinam. ");
INSERT INTO portft_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Eles vão tratar vocês dessa forma porque vocês me pertencem MTY, pois eles não conhecem aquele quem me enviou. ");
INSERT INTO portft_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Se eu não tivesse vindo comunicar-lhes a verdade de Deus, eles não seriam culpados de rejeitar a mim e a minha mensagem. Mas agora eu já vim e lhes comuniquei a mensagem de Deus, portanto eles não terão desculpa quando Deus os julgar pelos seus pecados. ");
INSERT INTO portft_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Todos os que me odeiam, é como se odiassem também meu Pai. ");
INSERT INTO portft_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Se eu não tivesse feito entre eles os milagres que ninguém mais fez, eles não seriam culpados do pecado de me rejeitarem. Mas agora, embora tenham visto esses milagres, eles odeiam a mim e a meu Pai. ");
INSERT INTO portft_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mas isto acontece para que se cumpra o que foi escrito nas Escrituras deles {para cumprir o que alguém/o salmista escreveu nas Escrituras deles}: ‘Eles me odeiam sem motivo’. ");
INSERT INTO portft_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Vou lhes mandar mais tarde, da parte do meu Pai, aquele que vai animar/ser como conselheiro legal para vocês. Ele é o Espírito que vai ensinar-lhes a verdade de Deus. Ele virá de meu Pai e vai falar de mim às pessoas. ");
INSERT INTO portft_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mas vocês discípulos também devem falar às pessoas sobre mim, pois vocês vêm me acompanhando desde o dia em que iniciei meu ministério”. ");
INSERT INTO portft_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesus continuava dizendo-nos, “Tenho dito estas coisas a vocês para que não deixem de confiar em mim quando as pessoas os perseguirem.  ");
INSERT INTO portft_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Eles não vão deixar que vocês adorem nas sinagogas. Pelo contrário, virá um dia quando aquele que matar vocês vai achar que, por assim proceder, está prestando um serviço a Deus. ");
INSERT INTO portft_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Eles vão fazer tais coisas porque nunca entenderam quem sou eu, nem quem é meu Pai. ");
INSERT INTO portft_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tenho explicado estas coisas a vocês para que, quando eles começarem a persegui-los, vocês possam se lembrar de que já lhes adverti disso. Eu não lhes disse estas coisas quando começaram a acompanhar-me no início do meu ministério MTY, pois eu ainda estava com vocês, e naquela altura eles estavam criando problemas para mim, não para vocês. ");
INSERT INTO portft_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Agora estou para voltar para aquele que me enviou. Mas me causa desapontamento o fato de nenhum de vocês ter-me perguntado, ‘Para onde vai?’ ");
INSERT INTO portft_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pelo contrário, por eu ter-lhes contado estas coisas, vocês estão profundamente entristecidos. ");
INSERT INTO portft_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mas a verdade é que minha partida é vantagem para vocês, pois se eu não for, não virá a vocês o Espírito que vai animá-los/ser como conselheiro legal para vocês. Mas quando eu for, vou mandá-lo a vocês. ");
INSERT INTO portft_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Quando Ele vier, vai comprovar que os que não pertencem a Deus estão errados sobre o que é pecaminoso e quem é que é reto, e sobre quem é que Deus vai julgar pelos seus pecados. b ");
INSERT INTO portft_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ele vai explicar às pessoas que seu maior pecado é de não crerem em mim. ");
INSERT INTO portft_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ele vai dizer às pessoas que por eu voltar para meu Pai, onde vocês já não me verão, vocês vão saber que sou eu que era realmente reto. ");
INSERT INTO portft_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ele vai explicar às pessoas que o fato de já ter sido determinado que Satanás, aquele que governa este mundo, será punido {que Deus já determinou punir Satanás, aquele que governa este mundo}, é prova de que algum dia Deus vai castigá-lastambém. ");
INSERT INTO portft_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Tenho ainda muitas coisas que gostaria de explicar-lhes, mas vocês não estão em condições de aceitá-las. ");
INSERT INTO portft_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mas o Espírito de Deus vai ensinar-lhes a verdade de Deus. Quando Ele vier, vai orientá-los para que possam entender toda a verdade espiritual. Ele não vai falar com sua própria autoridade. Pelo contrário, são as coisas que Ele ouve meu Pai dizer que vai comunicar a vocês. Ele também vai falar-lhes das coisas que irão acontecer mais tarde. ");
INSERT INTO portft_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ele vai me honrar, recebendo minha verdade e revelando-a a vocês. ");
INSERT INTO portft_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tudo o que meu Pai tem é meu. É por isso que eu disse que o Espírito pode receber minha verdade e revelá-la a vocês. ");
INSERT INTO portft_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Daqui a pouco vou deixar vocês, e não me verão mais. Então, pouco depois, vocês vão me ver novamente”. ");
INSERT INTO portft_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Por isso alguns de nós dissemos uns aos outros, “O que Ele quer dizer com essas palavras, ‘Daqui a pouco não me verão mais’ e ‘Pouco tempo depois, vão me ver novamente’? E, o que significa ‘Porque vou voltar para meu Pai’”? ");
INSERT INTO portft_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Continuávamos perguntando uns aos outros, “O que Ele quer dizer com as palavras ‘Daqui a pouco’? Não entendemos o que Ele está dizendo”. ");
INSERT INTO portft_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus se deu conta de que queríamos perguntar-lhe sobre esse detalhe, e por isso nos disse, “Vocês estão perguntando/Será que vocês estão perguntando RHQ uns aos outros o que eu queria dizer ao afirmar, ‘Daqui a pouco não me verão mais, e pouco depois vão me ver novamente.’? ");
INSERT INTO portft_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Escutem bem o seguinte: Após eu deixar vocês/morrer, os que se opõem a Deus ficarão contentes, mas vocês estarão abatidos. Mas posteriormente vocês deixarão a tristeza e vão ficar cheios de alegria. ");
INSERT INTO portft_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Uma mulher que está para dar à luz um filho sente dores por causa do que está acontecendo nesse momento. Mas depois do nascimento da criança, ela se esquece da dor, pois está cheia de alegria por causa do nascimento do filho. ");
INSERT INTO portft_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Assim vai ser com vocês. Agora vou morrer e vocês sentirão tristeza. Mas depois disso, vou vê-los novamente. Então vocês estarão cheios de alegria, e ninguém vai poder estragar essa sua alegria. ");
INSERT INTO portft_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Quando isso acontecer, vocês não me farão mais perguntas sobre nada. Escutem bem o seguinte: Depois que isso acontecer, meu Pai vai dar-lhes tudo que pedirem, por causa da íntima relação que Ele tem comigo MTY. ");
INSERT INTO portft_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Até este momento vocês não pediram nada a Deus, com base na relação dele comigo MTY. Agora, continuem pedindo-lhe coisas. Se assim fizerem, vocês vão recebê-las, portanto estarão cheios de alegria completa. ");
INSERT INTO portft_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Embora eu tenha falado em termos figurados, virá logo um dia quando já não vou empregar esse tipo de linguagem. Pelo contrário, vou falar-lhes claramente sobre meu Pai/o que meu Pai deseja. ");
INSERT INTO portft_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nesse momento, vocês irão pedir-lhe coisas por pertencerem a mim/com minha autoridade MTY. Não será mais preciso que eu peça para meu Pai fizer o que vocês estiverem pedindo. ");
INSERT INTO portft_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Meu Pai mesmo ama vocês porque vocês me amam e porque creem que vim de Deus, portanto Ele quer que vocês façam seus pedidos a Ele (OU, portanto Ele não precisa que ninguém o persuada a ajudar vocês). ");
INSERT INTO portft_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Vim do meu Pai e entrei neste mundo. Agora vou deixar este mundo e voltar para meu Pai”. ");
INSERT INTO portft_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Então nós, os discípulos dele, dissemos, “Agora O Senhor está falando claramente, sem figuras. ");
INSERT INTO portft_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Agora entendemos que O Senhor sabe todas as coisas. O Senhor não precisa que ninguém lhe pergunte nada, pois já sabe o que queremos perguntar antes mesmo de fazermos a pergunta. Isso também nos leva a crer que O Senhor veio de Deus”. ");
INSERT INTO portft_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus nos respondeu, “Agora vocês/será que vocês RHQ dizem que creem que vim de Deus.? ");
INSERT INTO portft_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mas escutem! Virá logo um dia, e esse dia já chegou, quando vocês todos vão fugir! Cada um de vocês vai fugir para sua própria casa. Vocês vão me abandonar, e ficarei sozinho. Mas nesse dia não estarei realmente só, pois meu Pai sempre me acompanha. ");
INSERT INTO portft_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tenho dito estas coisas a vocês para que possam ter paz no seu interior por causa do seu relacionamento comigo. Neste mundo, vocês vão ter problemas. Mas fiquem/sejam animados/corajosos! Por eu ter derrotado aqueles que se opõem a mim MTY, vocês também podem derrotá-los”. ");
INSERT INTO portft_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Após dizer essas coisas, Jesus olhou para o céu e orou, “Meu Pai, já chegou a hora MTY de eu sofrer e morrer. Honre-me enquanto eu assim fizer, para que eu possa honrar O Senhor. ");
INSERT INTO portft_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","O Senhor me deu autoridade sobre todos os seres humanos, para que eu pudesse capacitar todos aqueles que O Senhor escolheu a virem a mim e viverem eternamente. ");
INSERT INTO portft_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A maneira de as pessoas viverem eternamente é saberem que O Senhor é o único verdadeiro Deus, e que eu, Jesus, sou o Messias que O Senhor enviou. ");
INSERT INTO portft_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tenho honrado O Senhor aqui nesta terra, completando todo o trabalho que me incumbiu de fazer. ");
INSERT INTO portft_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Agora, meu Pai, peço que me honre quando eu estiver novamente consigo, atribuindo-me a grandeza que eu tinha anteriormente, quando estava com O Senhor antes da existência do mundo. ");
INSERT INTO portft_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Tenho revelado como é O Senhor às pessoas que me trouxe dentre os que não lhe pertencem MTY. Aqueles que vieram a mim lhe pertenciam, e O Senhor os conduziu a mim. Agora eles têm obedecido a sua mensagem. ");
INSERT INTO portft_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Agora eles sabem que tudo o que O Senhor me deu, sua mensagem e sua obra, vem do Senhor mesmo. ");
INSERT INTO portft_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Eu lhes comuniquei a mensagem que O Senhor me deu, e eles a aceitaram. Eles já sabem na certa que vim do Senhor. Eles já creem que O Senhor me enviou. ");
INSERT INTO portft_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Estou orando por eles/que O Senhor os ajude. Não estou orando em favor daqueles que estão no mundo e que não pertencem ao Senhor MTY. Pelo contrário, estou orando em favor daqueles que O Senhor conduziu para mim, pois eles lhe pertencem. ");
INSERT INTO portft_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Todos os discípulos que tenho pertencem ao Senhor, e todos aqueles que lhe pertencem, também me pertencem. Já foi demonstrado por eles {Eles já demonstraram} quão grande sou eu. ");
INSERT INTO portft_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Não vou ficar mais tempo no mundo. Já estou voltando para O Senhor. Eles, contudo, vão ficar aqui no mundo entre aqueles que se opõem ao Senhor. Meu Santo Pai, proteja-os pelo seu poder MTY, o poder que me concedeu, para que eles possam ficar unidos como nós estamos. ");
INSERT INTO portft_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Enquanto eu estava com eles, eu protegia-os totalmente pelo seu poder MTY. Como consequência, somente um deles ficará separado do Senhor eternamente. É ele quem, com certeza, ia ficar eternamente separado do Senhor. Isso está acontecendo para que seja cumprido {para cumprir} aquilo que um profeta escreveu nas Escrituras, afirmando que iria acontecer. ");
INSERT INTO portft_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Agora estou para voltar ao Senhor. Eu tenho dito estas coisas enquanto ainda estou aqui no mundo, para que meus discípulos possam experimentar total alegria, como a alegria que sinto. ");
INSERT INTO portft_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tenho comunicado a eles a sua mensagem. Como consequência, aqueles quem se opõem ao Senhor MTY os odeiam, pois eles não pertencem àqueles quem se opõem ao Senhor MTY, bem como eu não pertenço àqueles quem são seus inimigos MTY. ");
INSERT INTO portft_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Eu não lhe peço que os tire deste mundo, senão que os proteja de Satanás, o maligno. ");
INSERT INTO portft_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Eles não pertencem àqueles quem se opõem ao Senhor MTY, bem como eu não lhes pertenço. ");
INSERT INTO portft_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Consagre-os para que possam pertencer/servir integralmente ao Senhor, capacitando-os a obedecer/viver de acordo com aquilo que é verdade. É verdade a sua mensagem. ");
INSERT INTO portft_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Da mesma forma como O Senhor me enviou para cá, para este mundo, eu agora vou mandá-los a outros lugares MTY do mundo. ");
INSERT INTO portft_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Eu me consagro para pertencer integralmente ao Senhor, para que eles também possam ser consagrados {consagrar-se} integralmente ao Senhor. ");
INSERT INTO portft_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Não estou orando apenas em favor destes onze discípulos. Estou orando também por todos aqueles que vão crer em mim como consequência de ouvirem a mensagem deles. ");
INSERT INTO portft_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Meu Pai, quero que todos eles estejam unidos, como eu estou unido ao Senhor como consequência do meu relacionamento com O Senhor, e O Senhor comigo por causa da sua relação comigo. Quero que isso aconteça para que os que não conhecem O Senhor MTY possam saber que O Senhor me enviou. ");
INSERT INTO portft_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Eu os tenho honrado como O Senhor me honrou, para que eles possam ficar unidos como nós. Quero que eles estejam unidos uns aos outros como estão unidos comigo e O Senhor está unido comigo. ");
INSERT INTO portft_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Que possam ficar totalmente unidos, para que os que não pertencem ao Senhor MTY possam saber que O Senhor me enviou, e que O Senhor os ama da mesma forma como me ama. ");
INSERT INTO portft_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Meu Pai, quero que os discípulos que me trouxe possam ficar algum dia comigo no céu, onde eu vou ficar. Quero que eles vejam minha grandeza. Quero que eles vejam a grandeza que O Senhor me concedeu porque me ama. O Senhor me deu aquela grandeza antes de criar o mundo. ");
INSERT INTO portft_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Meu santo Pai, embora as pessoas que não lhe pertencem MTY não saibam como é O Senhor, eu sei como é, e meus discípulos sabem que O Senhor me enviou. ");
INSERT INTO portft_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Tenho revelado a eles como é O Senhor, e vou continuar revelando-lhes como é O Senhor. Vou proceder assim para que eles possam amar os outros como O Senhor me ama, e para que eu possa viver neles por meio do meu Espírito”. ");
INSERT INTO portft_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Depois de completar sua oração, Jesus atravessou o riacho de Cedrom conosco, seus discípulos. Havia do outro lado do riacho um olival, e foi para lá que nos dirigimos. ");
INSERT INTO portft_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, que estava para capacitar seus inimigos a prendê-lo, sabia que Jesus provavelmente estaria lá. Ele sabia isso porque Jesus costumava reunir-se ali conosco. ");
INSERT INTO portft_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Por isso Judas se dirigiu àquele olival. Ele guiava uma tropa de soldados romanos e alguns guardas do templo, mandados pelos fariseus e os principais sacerdotes. Eles levavam tochas, lâmpadas e armas. ");
INSERT INTO portft_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus sabia de tudo que iria acontecer a Ele. Por isso Ele se adiantou e lhes perguntou, “Quem é que vocês estão procurando?” ");
INSERT INTO portft_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Eles responderam a Ele, “Jesus, o homem de Nazaré”. Ele respondeu, “Sou Jesus”. Acompanhava-os Judas, aquele que capacitava seus inimigos a prendê-lo. ");
INSERT INTO portft_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Quando Jesus lhes disse, “Sou eu que vocês estão procurando”, eles recuaram e caíram no chão por causa do poder dele.  ");
INSERT INTO portft_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ele lhes perguntou de novo, “Quem é que vocês estão procurando?” Eles disseram, “Jesus, o homem de Nazaré”. ");
INSERT INTO portft_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Respondeu Jesus, “Já lhes disse que sou Jesus. Já que sou eu que vocês estão procurando, deixem que estes —outros homens/discípulos meus— vão embora. ");
INSERT INTO portft_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Isto aconteceu para que, ao fazerem o que Ele pediu para eles fazerem, fosse cumprido o que {cumprisse as palavras que} Ele tinha orado, “Nunca vou perder nenhum daqueles que Deus me concedeu/trouxe”. ");
INSERT INTO portft_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simão Pedro tinha uma espada. Por isso ele a tirou e tentou matar o servo do sumo sacerdote, mas só conseguiu cortar a orelha direita do homem. O servo se chamava Malco. ");
INSERT INTO portft_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus disse a Pedro, “Coloque a espada na bainha! —Preciso/Você não acha que devo— RHQ suportar o que meu Pai quer que eu padeça MET!?” ");
INSERT INTO portft_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Então os soldados da tropa, acompanhados por seu comandante e os guardas do templo judaico, prenderam Jesus. Amarraram as mãos dele atrás das costas.  ");
INSERT INTO portft_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Logo em seguida o levaram a Anás, o sumo sacerdote anterior. Ele era sogro de Caifás, o sumo sacerdote judaico aquele ano. ");
INSERT INTO portft_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Foi ele que anteriormente tinha avisado o Conselho Judaico de que seria preferível que um homem morresse em benefício do povo, em vez de morrerem todos os membros da nação judaica. ");
INSERT INTO portft_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simão Pedro e eu fomos seguindo Jesus. Já que o sumo sacerdote me conhecia pessoalmente, ele me deixou entrar no seu pátio. ");
INSERT INTO portft_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mas Simão Pedro foi obrigado a aguardar do lado de fora do portão. Mas, sendo eu conhecido do sumo sacerdote, eu voltei para a porta e falei com a moça que guardava a entrada. Então ela deixou Pedro entrar. ");
INSERT INTO portft_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","A serva que guardava a entrada disse a Pedro, “Com certeza você não é também discípulo daquele homem que eles prenderam, certo?” Ele disse, “Não sou”. ");
INSERT INTO portft_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Fazia frio, e por isso os escravos do sumo sacerdote e os guardas do templo tinham preparado uma fogueira de carvão e se aqueciam de pé, reunidos em volta dela. Pedro também se instalou lá, para se aquecer. ");
INSERT INTO portft_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Enquanto ele assim fazia, o sumo sacerdote interrogava Jesus acerca dos seus discípulos e sobre aquilo que Ele ensinava ao povo. ");
INSERT INTO portft_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus respondeu, “Tenho falado claramente a todos. Sempre os tenho ensinado nas sinagogas e no templo, e em lugares onde se reuniam todos os judeus. Eu não disse nada em segredo. ");
INSERT INTO portft_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Por isso —por que o senhor está/o senhor não deve estar— RHQ interrogando-me assim, ilegalmente! Pergunte às pessoas que ouviram o que eu ensinava! Elas com certeza sabem o que foi que eu dizia”! ");
INSERT INTO portft_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Depois de Jesus dizer isso, um dos guardas do templo, que ficava perto dele, deu-lhe uma bofetada na cara, dizendo , —“Não é assim/Será assim— RHQ que se responde ao sumo sacerdote!?” ");
INSERT INTO portft_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus lhe respondeu, “Se eu tivesse dito algo contrário às suas leis, você poderia ter-me dito o que foi exatamente que eu disse que estava errado. Mas, já que eu ensinava apenas coisas certas, —por que você está/você não deve estar— RHQ me batendo?”! ");
INSERT INTO portft_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Então, após amarrarem {amarradas} as mãos de Jesus novamente, Anás o mandou a Caifás, o sumo sacerdote. ");
INSERT INTO portft_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Enquanto Simão Pedro ficava perto da fogueira, aquecendo-se, alguém lhe disse, “Será você por acaso é um dos discípulos daquele homem?” Ele o negou, dizendo, “Não sou”. ");
INSERT INTO portft_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mais tarde, um dos servos do sumo sacerdote, parente do homem cuja orelha Pedro antes tinha cortado, disse a ele, “Vi você com aquele homem no olival, não vi?” ");
INSERT INTO portft_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro o negou novamente. Imediatamente um galo cantou, como Jesus tinha vaticinado. ");
INSERT INTO portft_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Então os líderes SYN judaicos conduziram Jesus da casa de Caifás para o palácio de Pilatos, o governador romano. Era de madrugada, antes do levantar do sol. Pilatos era gentio/não-judeu, e eles pensavam que, se entrassem no palácio dele, seriam rejeitados por Deus {Deus iria rejeitá-los}, e que nesse caso não poderiam comer nada durante a festa da Páscoa. Por isso não quiseram entrar no Palácio. ");
INSERT INTO portft_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Portanto Pilatos saiu para conversar com eles. Ele disse, “Na opinião de vocês, que lei este homem desobedeceu?” ");
INSERT INTO portft_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Eles sabiam que Jesus não tinha desobedecido nenhuma lei romana, por isso não quiseram responder a pergunta dele. Em vez disso, disseram, “Se este homem não fosse criminoso, nós não o teríamos trazido aqui diante do senhor”! ");
INSERT INTO portft_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Então Pilatos lhes disse, “Levem-no, e julguem-no de acordo com a sua própria lei”! Então os líderes SYN judaicos disseram, “Não, queremos que vocês romanos o matem, pois nós judeus não temos direito de matar ninguém”! ");
INSERT INTO portft_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Os romanos matavam as pessoas, pregando-as numa cruz. Por isso os líderes judaicos falaram assim, para que fosse cumprido {os romanos cumprissem} aquilo que Jesus tinha dito anteriormente sobre a maneira em que Ele iria morrer. ");
INSERT INTO portft_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Logo depois, Pilatos voltou para dentro do palácio. Ele convocou Jesus. Já que os líderes judaicos tinham dito que Jesus se dizia rei, ele lhe disse com desdém, “O Senhor é rei dos judeus?” ");
INSERT INTO portft_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus respondeu, “O senhor pergunta isso por realmente querer saber se me considero rei, ou por —outra pessoa/Caifás— ter dito que alego ser rei deles?” ");
INSERT INTO portft_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatos respondeu, “Eu não sou judeu, portanto —não posso/como poderia e-- RHQ entender estes assuntos!? Foram seus correligionários judeus e os principais sacerdotes que o trouxeram para mim! O que O Senhor fez para levá-los a querer matá- lo?”  ");
INSERT INTO portft_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus respondeu, “Não são as pessoas deste mundo que me fazem rei. Se fossem os habitantes deste mundo que me faziam rei, meus discípulos/seguidores teriam lutado para que os líderes SYN judaicos fossem impedidos {para impedir os líderes SYN judaicos} de prender-me. Mas não é ninguém aqui deste mundo que me torna rei”. ");
INSERT INTO portft_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Então Pilatos lhe disse, “Então O Senhor está dando a entender que é realmente rei?” Jesus respondeu, “Sim, é certo o que o senhor acaba de dizer, que sou rei. Nasci para ser rei, e vim a este mundo para comunicar às pessoas a verdade sobre Deus. Todos os que apoiam a verdade prestam atenção ao que digo”. ");
INSERT INTO portft_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatos disse, “Como se pode saber o que é a verdade”? Após dizer isso, ele saiu e conversou novamente com os líderes SYN judaicos. Ele lhes disse, “Não acho que Ele tenha feito nada pelo qual devo puni-lo. ");
INSERT INTO portft_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mas vocês judeus têm o costume de que, todos os anos durante a festa da Páscoa, eu lhes solte algum preso. Por isso, vocês preferem que eu lhes solte o homem que vocês judeus alegam ser seu rei?” ");
INSERT INTO portft_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Eles gritaram de novo, “Não, não solte esse homem! Em vez dele, solte Barrabás”! Mas Barrabás estava preso por ser revolucionário/terrorista! ");
INSERT INTO portft_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Então Pilatos levou Jesus para dentro do palácio, onde estavam alguns soldados, e mandou que eles chicoteassem Jesus/batessem em Jesus com um chicote contendo pedacinhos de metal ou osso na ponta. ");
INSERT INTO portft_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Os soldados também trançaram, em forma de coroa, alguns ramos cheios de espinhos. Então puseram a coroa na cabeça dele. Colocaram nele uma capa de púrpora. Fizeram estas coisas para zombar dele, fazendo de conta que Ele era rei.  ");
INSERT INTO portft_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Então se achegavam repetidas vezes a Ele, dizendo, “Viva o Rei dos Judeus”! IRO Depois batiam no rosto dele. ");
INSERT INTO portft_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Uma vez mais Pilatos saiu do palácio e disse à multidão, “Olhem! Vou trazê-lo para vocês verem, para que saibam que não acho nele nenhum motivo que justifique mais castigos”. ");
INSERT INTO portft_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Quando Jesus saiu, vestido na capa de púrpora e a coroa de espinhos, Pilatos lhes disse, “Olhem agora este coitadinho”! ");
INSERT INTO portft_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Quando os principais sacerdotes e guardas do templo o viram, gritaram, “Mande que seus soldados o matem, pregando-o em uma cruz! Crucifique-o”! Pilatos, sabendo que eles mesmos não poderiam fazê-lo legalmente, disse a eles, “Levem-no vocês mesmos e crucifiquem-no! Quanto a mim, não acho que Ele tenha feito nada que justifique castigo”. ");
INSERT INTO portft_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Os líderes SYN judaicos responderam, “Em uma de nossas leis está escrito que devemos matar qualquer pessoa que se chame de Deus. Este homem se diz o Filho de/homem que é também Deus, portanto o senhor deve mandar matá-lo”.  ");
INSERT INTO portft_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ao ouvir isso, Pilatos tinha mais medo daquilo que pudesse acontecer a ele se mandasse os soldados matarem Jesus. ");
INSERT INTO portft_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Por isso ele levou Jesus de volta para dentro do palácio, e disse a Jesus, “De onde O Senhor realmente vem?” Mas Jesus não lhe respondeu. ");
INSERT INTO portft_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Por isso Pilatos lhe disse, “O Senhor não quer responder-me? Não sabe que tenho autoridade de soltá-lo, e também tenho autoridade de mandar que os soldados o preguem em uma cruz?” ");
INSERT INTO portft_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus respondeu, “A única autoridade que O Senhor tem é aquela que lhe foi dada por Deus MTY {que Deus MTY lhe deu}. O sumo sacerdote me entregou em suas mãos. Ele fez comigo o que quis fazer, mas o senhor não fez tal coisa. Por isso, ele é culpado de cometer um pecado bem grave, e O Senhor não tem culpa”. ");
INSERT INTO portft_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Por causa disso, Pilatos continuava tentando soltar Jesus. Mas os líderes SYN judaicos ameaçavam relatar ao Imperador que Pilatos não estava disposto a punir um homem que se dizia rei; eles continuavam gritando, “Quem alegar ser ele mesmo rei se opõe ao Imperador! Por isso vamos conseguir que o Imperador não considere o senhor mais seu amigo”! ");
INSERT INTO portft_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ao ouvir isso, Pilatos levou Jesus novamente para fora do palácio. Ele se sentou no tribunal/trono onde costumava tomar as decisões relativas ao castigo das pessoas. Chamava-se {As pessoas o chamavam} Calçada de Pedra. Na língua aramaica se chamava Gabatá. ");
INSERT INTO portft_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Era quase meio-dia, no dia dos preparativos para a festa da Páscoa (OU, o dia antes do sábado durante a festa da Páscoa). Pilatos disse aos líderes SYN judaicos, em tom de zombaria, “Olhem seu rei”! ");
INSERT INTO portft_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Eles gritaram, “Levem-no embora daqui! Fora! Crucifique-o”! Pilatos lhes disse, “Ele é rei de vocês! Devo mandar meus soldados pregá-lo em uma cruz?” Os principais sacerdotes responderam, “Nosso rei é o Imperador! Não temos outro rei”! ");
INSERT INTO portft_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Então, finalmente, Pilatos concordou em fazer o que eles desejavam, e avisou os soldados de que Jesus deveria ser justiçado {justiçarem Jesus} pela crucificação. Então os soldados levaram Jesus embora. ");
INSERT INTO portft_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ao saírem, Ele mesmo carregava a cruz na qual iriam pregá-lo. Eles se dirigiram a um lugar chamado o lugar de uma caveira. Na língua aramaica é chamado {as pessoas o chamam} Gólgota. ");
INSERT INTO portft_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chegados lá, após tirarem as roupas dele, os soldados o pregaram na cruz. Crucificaram também outros dois criminosos. Havia um deles de cada lado dele, ficando Jesus no meio. ");
INSERT INTO portft_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatos mandou também que escrevessem em uma tábua o aviso do motivo do suplício dele, pregando-a também na cruz. Foi escrito {Eles escreveram} o seguinte: “Jesus de Nazaré, o Rei dos Judeus”. ");
INSERT INTO portft_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Muitos judeus conseguiram ler esse aviso, pois o lugar onde Jesus estava sendo crucificado {onde o estavam crucificando} ficava bem perto da cidade de Jerusalém, onde estavam congregadas muitas pessoas para comemorarem a festa, e estava escrito {eles o tinham escrito} em três línguas: hebraico, latim e grego. ");
INSERT INTO portft_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Os principais sacerdotes judaicos protestaram, dizendo a Pilatos, “Não escreva ‘O Rei dos Judeus’! Em vez disso, escreva, ‘Este homem se dizia o Rei dos Judeus’”! ");
INSERT INTO portft_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatos respondeu, “Eles escreveram o que mandei que escrevessem, e não vou modificar nada”. ");
INSERT INTO portft_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Depois de os soldados pregarem Jesus na cruz, eles pegaram as roupas dele e as dividiram em quatro partes, uma para cada soldado. Mas puseram à parte a capa dele. Alguém tinha tecido essa capa, de cima para baixo, de uma só peça. ");
INSERT INTO portft_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Por isso eles se diziam, “Não vamos rasgá-la. Em vez disso, vamos tirar a sorte/deitar sortes para determinar quem vai ganhá-la”. Assim, foi isso que os soldados fizeram. Como resultado, foram cumpridas estas palavras {eles cumpriram estas palavras} que o salmista tinha escrito nas Escrituras: ‘Eles repartiram entre si a maioria das minhas roupas. Eles fizeram sorteio da minha capa’. ");
INSERT INTO portft_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Perto da cruz onde eles tinham pregado Jesus, estavam sua mãe, a irmã dela, Maria (a esposa de Clopas) e outra Maria, a mulher da aldeia da Magdala. ");
INSERT INTO portft_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesus viu sua mãe em pé, e também me viu perto dela. Então ele disse à sua mãe, “Esse homem vai ser agora como seu filho”. ");
INSERT INTO portft_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","E me disse, “Cuide dessa mulher como MET sua mãe”. Portanto, dali em diante eu a levei para minha casa e cuidava dela. ");
INSERT INTO portft_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mais tarde, Jesus sabia que já estava completo tudo que Deus o tinha mandado fazer {que tinha realizado tudo que Deus o tinha mandado fazer}, mas sabia que algo mais que eles tinham escrito nas Escrituras ficava ainda por completar {que Ele precisava ainda cumprir algo que tinham escrito nas Escrituras}. Por isso Ele disse, “Tenho sede”. ");
INSERT INTO portft_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Havia ali uma vasilha de vinho azedo {vinagre}. Por isso alguém molhou nele uma esponja. Então pregou a esponja no caniço de uma planta chamada hissopo e a ergueu até os lábios de Jesus. ");
INSERT INTO portft_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ao provar o vinho azedo, Jesus gritou, “Tudo o que vim fazer já está completo {Já terminei tudo que vim fazer}”! Então Ele baixou a cabeça e morreu/entregou seu Espírito a Deus. ");
INSERT INTO portft_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Foi o dia em que preparavam tudo para o sábado. O dia seguinte seria um sábado especial, pois era o sábado do festival da Páscoa. Os líderes SYN judaicos não quiseram que os cadáveres dos três homens permanecessem na cruz durante o sábado, pois seria contrário às suas leis judaicas deixar corpos mortos expostos até o dia seguinte. Portanto, foram ter com Pilatos e pediram que ele mandasse quebrar as pernas dos três homens crucificados {que os soldados quebrassem as pernas dos três homens nas cruzes}, para eles morrerem mais rapidamente. Então poderiam ser tirados e enterrados os cadáveres {alguém poderia tirar e enterrar os cadáveres deles}. ");
INSERT INTO portft_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Por isso, após obterem licença de Pilatos, os soldados foram quebrar as pernas do primeiro homem {que eles tinham} pregado em uma cruz perto de Jesus. Quebraram depois as pernas do outro homem. ");
INSERT INTO portft_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mas ao chegarem a Jesus, perceberam que já estava morto. Por isso não quebraram as pernas dele. ");
INSERT INTO portft_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Em vez disso, um dos soldados furou o lado de Jesus com uma lança para se certificar de que Jesus estava morto. No mesmo instante, saíram coágulos de sangue e mais líquido, provando que Jesus estava realmente morto.  ");
INSERT INTO portft_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Eu mesmo vi isso, e o que escrevo é a verdade. Sei que estou dizendo a verdade, e digo isto para que vocês possam crer em/no meu testemunho de Jesus. ");
INSERT INTO portft_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Estas coisas aconteceram para que fossem cumpridas {para cumprir} estas palavras que alguém tinha escrito nas Escrituras: ‘Nenhum dos seus ossos será quebrado {Ninguém vai quebrar um osso dele}’. ");
INSERT INTO portft_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","E eles cumpriram outro trecho das Escrituras contendo as seguintes palavras: ‘Eles contemplarão aquele que atravessaram com a lança’. ");
INSERT INTO portft_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mais tarde, José (da cidadezinha de Arimateia) foi ter com Pilatos e lhe pediu licença para tirar o corpo de Jesus da cruz. José era discípulo de Jesus, mas não contava esse fato para ninguém porque tinha medo dos outros líderes SYN judaicos. Pilatos lhe concedeu licença, por isso ele foi, acompanhado de outros, e retirou o corpo de Jesus. ");
INSERT INTO portft_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemos o acompanhou; era ele o homem que anteriormente tinha ido visitar Jesus de noite. Nicodemos comprou uma mistura bem cara de mirra e aloés para passar no corpo. Essa mistura pesava uns 35 quilos. ");
INSERT INTO portft_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Eles levaram embora o corpo de Jesus, e espalharam nele a mistura de especiarias, enrolando o cadáver em faixas de linho. Procederam assim de acordo com os costumes mortuários judaicos. ");
INSERT INTO portft_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Próximo ao lugar onde Jesus foi pregado {onde pregaram Jesus} na cruz, havia um arvoredo, e à beira daquele arvoredo uma nova cova/caverna. Ninguém tinha sido enterrado ainda naquela cova. ");
INSERT INTO portft_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","O sábado judaico ia começar na hora do pôr-do-sol, e eles precisavam completar o enterro antes daquela hora. Por isso, ficando bem perto aquela cova, eles deitaram lá o corpo de Jesus e colocaram, para tapar a entrada da cova, uma pedra bem grande. ");
INSERT INTO portft_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo bem cedo, quando ainda estava escuro, Maria (a mulher da aldeia da Magdala) e outras mulheres se dirigiram à caverna. Maria viu que a pedra tinha sido retirada {que alguém tinha retirado a pedra} da entrada. ");
INSERT INTO portft_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Por isso, ela foi correndo até o lugar onde Simão Pedro e eu estávamos alojados. Ela nos disse, “Eles tiraram o corpo do Senhor da cova, e não sabemos onde o colocaram”! ");
INSERT INTO portft_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Por isso Pedro e eu partimos em direção à caverna. ");
INSERT INTO portft_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nós dois fomos correndo, mas consegui ultrapassar o Pedro e cheguei primeiro. ");
INSERT INTO portft_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Baixei-me e espiei para dentro da cova. Lá vi as faixas de linho, mas não entrei. ");
INSERT INTO portft_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Então chegou Simão Pedro, que vinha correndo atrás de mim. Ele entrou logo na caverna, onde também viu as faixas de linho. ");
INSERT INTO portft_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Viu também o pano com que tinham coberto a cabeça de Jesus. O pano tinha sido dobrado e colocado {Alguém tinha dobrado e colocado o pano} ao lado, separado das faixas de linho. ");
INSERT INTO portft_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Então eu também entrei. Vi estas coisas e acreditei que Jesus realmente tinha voltado à vida.  ");
INSERT INTO portft_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Antes de acontecer isso, não entendemos, com base naquilo que tinham escrito nas Escrituras, que Ele deveria tornar-se novamente vivo após a morte. ");
INSERT INTO portft_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Então nós discípulos voltamos para o lugar onde estávamos alojados. Entretanto, Maria voltou à caverna.  ");
INSERT INTO portft_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Enquanto ela ficava do lado de fora, chorando, baixou-se para olhar para dentro da cova. ");
INSERT INTO portft_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Lá ela viu dois anjos, vestidos de roupas bem brancas e sentados no lugar onde antes estivera o corpo de Jesus. Um deles estava no lugar da cabeça dele, e o outro no lugar dos pés dele. ");
INSERT INTO portft_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Eles lhe disseram, “Senhora, por que está chorando?” Ela lhes respondeu, “Eles levaram embora o corpo do meu Senhor, e não sei onde o colocaram”! ");
INSERT INTO portft_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Após dizer isso, ela se voltou e viu Jesus em pé ali, mas não sabia que era Jesus. ");
INSERT INTO portft_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ele disse a ela, “Senhora, por que está chorando? A quem está procurando?” Pensando que era ele o jardineiro, ela lhe disse, “Senhor, se o senhor levou embora o corpo dele, diga-me onde o colocou. Então posso ir lá buscá-lo e enterrá-lo da forma apropriada”.  ");
INSERT INTO portft_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus lhe disse, “Maria”! Ela se voltou para Ele e O reconheceu. Então ela exclamou na língua aramaica, “Rabôni”! que significa ‘Mestre’. ");
INSERT INTO portft_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus lhe disse, “Não fique me segurando assim, pois não voltei ainda para meu Pai. Vá avisar os meus discípulos/aqueles que me pertencem do seguinte, ‘Estou para voltar a meu Pai e seu Pai, àquele que é meu Deus e seu Deus’”. ");
INSERT INTO portft_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Por isso Maria se dirigiu ao lugar onde estávamos nós discípulos e nos disse que tinha visto o Senhor ressuscitado. Ela também nos relatou o que Jesus tinha mandado que ela nos dissesse. ");
INSERT INTO portft_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Naquele domingo, ao cair da tarde, nós discípulos nos reunimos. As portas estavam trancadas {Trancamos as portas} porque nós tínhamos medo de que os líderes SYN judaicos nos prendessem. De repente Jesus apareceu milagrosamente entre nós! Ele disse, “Que Deus lhes conceda paz no seu interior”! ");
INSERT INTO portft_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Após dizer isso, Ele nos mostrou as feridas nas suas mãos e nos seus pés. Ficamos bem contentes ao ver o Senhor! ");
INSERT INTO portft_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesus nos disse novamente, “Que Deus os abençoe/lhes dê paz! Assim como meu Pai me enviou, mando vocês agora para proclamarem minha mensagem”.  ");
INSERT INTO portft_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Após dizer isso, Ele soprou sobre nós e disse, “Recebam o Espírito Santo! ");
INSERT INTO portft_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Se vocês perdoarem as pessoas por haverem pecado, elas já terão sido perdoadas {Deus já as terá perdoado}. Se não as perdoarem, não terão sido perdoadas {Deus não as terá perdoado}”. ");
INSERT INTO portft_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Um de nós discípulos, Tomé, que se chama {a quem chamávamos} ‘O gêmeo’, não estava presente conosco quando Jesus nos apareceu. ");
INSERT INTO portft_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Quando nós outros lhe dissemos que tínhamos visto o Senhor, ele nos disse, “Se eu não vir o sinal dos pregos nas mãos dele e tocar no ponto de entrada deles, e se não puser a mão no lado dele, onde o soldado o furou com uma lança, com certeza não vou acreditar que fosse Ele que vocês viram”! ");
INSERT INTO portft_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Uma semana depois estávamos novamente na casa. Dessa vez Tomé estava conosco. Embora as portas estivessem trancadas {tivéssemos trancado as portas}, Jesus apareceu milagrosamente pela segunda vez entre nós. Ele nos disse, “Que Deus os abençoe/lhes dê paz”! ");
INSERT INTO portft_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Então mostrou as mãos ao Tomé e lhe disse, “Ponha o dedo aqui! Olhe as feridas nas minhas mãos! Estenda a mão e toque a ferida aqui no meu lado! Deixe de duvidar! LIT/DOU Em vez disso, creia que estou novamente vivo”!  ");
INSERT INTO portft_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomé lhe respondeu, “O Senhor é realmente meu Senhor e meu Deus”! ");
INSERT INTO portft_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus lhe disse, “Você crê isso sobre mim porque me vê. Mas Deus se contenta com aqueles que creem isso sobre mim, mesmo que não me tenham visto”! ");
INSERT INTO portft_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Nós discípulos vimos Jesus realizar muitos outros milagres, mas estes não foram narrados {eu não escrevi sobre eles} neste volume. ");
INSERT INTO portft_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mas aqueles sobre os quais escrevi, foram narrados {eu escrevi sobre eles} para que vocês possam crer que Jesus é o Messias, o filho de Deus/homem que é também Deus, e para que possam viver para sempre por crerem nele/naquilo que Ele tem feito por vocês MTY. ");
INSERT INTO portft_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Depois disso, Jesus se manifestou a nós  discípulos quando estávamos no lago de Tiberíades,outro nome do lago da Galileia. Aconteceu assim: ");
INSERT INTO portft_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Estávamos juntos Simão Pedro, Tomé que é chamado {a quemchamávamos } o Gêmeo, Natanael da cidade de Caná  da Galileia, meu irmão maior e eu. ");
INSERT INTO portft_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simão Pedro nos disse, “Eu  vou tentar  pescar”. Respondemos, “Nós vamos acompanhar você”. Então descemos ao lago  e entramos no barco. Mas aquela noite não conseguimos pescar nada. ");
INSERT INTO portft_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","De manhã cedo, Jesus ficou na praia, mas não sabíamos que era Jesus. ");
INSERT INTO portft_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ele nos chamou, “Amigos, parece que vocês não conseguiram pescar  nada, certo?” Respondemos, “Tem razão, não pegamos nada ”. ");
INSERT INTO portft_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ele nos disse, “Lancem a rede do lado direito do barco! Assim vão encontrar peixes!” Fizemos assim, e pegamos tantos peixes na rede que mal conseguimos puxar a rede para o barco. ");
INSERT INTO portft_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mas eu bem sabia que era Jesus, portanto  disse a Pedro, “É o Senhor!” Pedro tinha tirado a capa enquanto trabalhava, mas logo que me ouviu dizer  “É o Senhor!”, ele vestiu a capa, pulou na água e nadou até a praia . ");
INSERT INTO portft_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nós, os demais discípulos, fomos no barco para a praia , puxando a rede cheia de peixes. Ficávamos perto da praia, apenas uns cem metros. ");
INSERT INTO portft_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Quando chegamos na praia, vimos que havia lá uma fogueira, com um peixe enorme  sobre as brasas, e alguns pãezinhos. ");
INSERT INTO portft_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus nos disse, “Tragam alguns dos peixes que acabaram de pescar!” ");
INSERT INTO portft_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simão Pedro entrou no barco  e puxou a rede para a praia. Estava cheia de peixes bem grandes. Havia 153 deles ao todo! Mas, apesar de haver tantos peixes, a rede não se rompeu. ");
INSERT INTO portft_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus nos disse, “Venham comer!” Nenhum de nós tinha coragem de lhe perguntar, “Quem é você?” porque bem sabíamos que era o Senhor. ");
INSERT INTO portft_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus tomou os pãezinhos e os deu a nós, fazendo o mesmo com o peixe. ");
INSERT INTO portft_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Foi esta a terceira vez que Jesus apareceu a nós discípulos depois que Deus  o ressuscitou dos mortos. ");
INSERT INTO portft_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Depois de comermos, Jesus disse a Simão Pedro, “Simão, filho de João , você me ama mais do que estes outros discípulos ?” Pedro respondeu, “Sim, Senhor, você sabe que me é muito querido (OU, que eu o amo)”. Jesus disse, “Dê para aqueles que me pertencem aquilo de que precisam espiritualmente, como MET um pastor supre  alimento para os seus cordeiros”. ");
INSERT INTO portft_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesus disse a ele novamente, “Simão, filhode João , você me ama?” Ele respondeu, “Sim, Senhor, você sabe que me é muito caro (OU, que eu o amo)”. Jesus lhe disse, “Cuida daqueles que me  pertencem, como  MET um pastor cuida de suas  ovelhas”. ");
INSERT INTO portft_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesus lhe disse/perguntou pela terceira vez, “Simão, filho de João, sou realmente caro para você (OU, você realmente me ama)?” Pedro ficou magoado por Jesus lhe ter perguntado a mesma coisa três vezes, e porque da terceira vez tinha mudado a pergunta . Ele disse, “Senhor, você sabe tudo; sabe que me é muito querido (OU, que eu o amo)”. Jesus disse, “Dê àqueles que me  pertencem aquilo de que precisam espiritualmente, como  MET um pastor supre alimento para suas ovelhas. ");
INSERT INTO portft_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Escute agora o seguinte: Quando você era jovem, vestia-se e ia para onde queria. Mas quando for velho, vai estender as mãos, e alguém vai amarrá-las com uma corda  e vai levar você para um lugar para onde você não deseja ir”. ");
INSERT INTO portft_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesus disse isto para indicar como Pedro iria morrer ◄violentamente/numa cruz► para glorificar a Deus. Então Jesus disse a ele, “Continue sendo meu fiel discípulo até a morte”. ");
INSERT INTO portft_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro se voltou e viu que eu andava atrás deles. Fui eu que estava ao lado de Jesus durante a ceia da Páscoa e tinha perguntado, “Senhor, quem vai facilitar a sua captura pelos inimigos?” ");
INSERT INTO portft_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Quando Pedro me viu, ele perguntou, “Senhor, o que vai acontecer  a ele?” ");
INSERT INTO portft_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus lhe respondeu, “Se eu quiser que ele permaneçavivo  até que eu volte, ◄não é da sua conta!/o que lhe importa?► RHQ Seja meu fiel  discípulo!” ");
INSERT INTO portft_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Alguns dos outros crentes ouviram daquilo  que Jesus tinha dito sobre mim, eachavam que ele/Jesus queria dar a entender  que eu nunca iria morrer. Mas Jesus não tinha dito que eu não iria morrer. Só tinha dito, “Se eu quiser que ele permaneça vivo até eu voltar, ◄não é da sua conta!/o que lhe importa?► RHQ” ");
INSERT INTO portft_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Eu, João, sou o discípulo que viu todas estas coisas, e as tenho registrado por escrito. Nós os anciãos da congregação em Éfeso sabemos que é verdade aquilo que João escreveu. ");
INSERT INTO portft_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesus fez muitas outras coisas. Se fossem escritas todas  elas {Se alguém escrevesse todas elas}detalhadamente , acho que o mundo inteiro não teria bastante espaço HYP para conter todos os livros escritos {que escrevesse} sobre aquilo que ele tinha feito . ");
INSERT INTO portft_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Caro/Prezado Teófilo, no primeiro/outro livro que lhe compus, escrevi sobre muitas das coisas que Jesus fez e ensinou ");
INSERT INTO portft_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","até o dia em que Ele foi arrebatado {Deus O levou} para o céu. Antes de ir para o céu, sendo orientado pelo Espírito Santo, Ele explicou aos apóstolos que tinha escolhido as coisas que queria que eles soubessem.  ");
INSERT INTO portft_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Após sofrer e morrer na cruz, Ele se tornou vivo novamente. Os apóstolos O viram muitas vezes, pois Ele lhes apareceu com frequência durante os próximos quarenta dias. Ele conversou com eles sobre como Deus governaria MET as vidas das pessoas que O aceitassem como rei. ");
INSERT INTO portft_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Certa vez, quando Ele ainda estava com eles, Ele lhes disse: “Não saiam ainda/imediatamente de Jerusalém. Fiquem aqui esperando, até que meu Pai lhes mande seu Espírito MTY, como já prometeu fazer. Vocês me ouviram lhes falar sobre isso. ");
INSERT INTO portft_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","João usou água para batizar as pessoas quando elas afirmaram que desejavam mudar a sua maneira de viver, mas daqui há poucos dias LIT o Espírito Santo será posto {Deus porá o Espírito Santo} dentro de vocês para realmente transformar suas vidas”. ");
INSERT INTO portft_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Um dia, ao se reunirem os apóstolos com Jesus, eles lhe perguntaram: “Senhor, o Senhor se tornará rei MET sobre nós israelitas, à semelhança do Rei Davi que governava há muito tempo?” (OU, “Senhor, o Senhor derrotará os romanos agora e restaurará o reino para nós israelitas?”) Ele lhes respondeu: “Vocês não precisam saber as épocas e dias quando isso acontecerá.  ");
INSERT INTO portft_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Meu Pai, e mais ninguém, já resolveu quando é que Ele me fará rei.  ");
INSERT INTO portft_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Em vez disso, vocês precisam saber que o Espírito Santo os fortalecerá espiritualmente quando Ele vier sobre/dentro de vocês. Então, como resultado disso, vocês falarão poderosamente de mim aos habitantes de Jerusalém e a todos os demais lugares do distrito de Judeia, no distrito de Samaria e em lugares bem distantes do mundo inteiro IDM”. ");
INSERT INTO portft_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Após dizer isso, Ele foi arrebatado {Deus o levou} para o céu, enquanto eles ficavam olhando. Ele subiu numa nuvem PRS, o que impediu que eles o vissem mais. ");
INSERT INTO portft_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Enquanto os apóstolos estavam ainda olhando Jesus subir para o céu, dois indivíduos vestindo roupas brancas ficaram de repente ao lado deles. Eram anjos.  ");
INSERT INTO portft_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Então eles dois disseram: “Vocês, homens do distrito de Galileia, não precisam/por que RHQ ficam aqui ainda, olhando para o céu! Algum dia o mesmo Jesus, que foi arrebatado {que Deus levou} de vocês para o céu, voltará para a terra. Ele voltará da mesma forma como vocês acabam de vê-lo subir ao céu, mas Ele não voltará logo”. ");
INSERT INTO portft_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Depois dos dois anjos partirem, os apóstolos voltaram para a cidade de Jerusalém, deixando o Monte das Oliveiras, que ficava há um quilômetro de distância MTY de Jerusalém. ");
INSERT INTO portft_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ao entrarem na cidade, eles subiram para o aposento da casa onde estavam hospedados. Entre os presentes constavam Pedro e João, Tiago e André, Filipe e Tomé, Bartolomeu e Mateus, o outro Tiago filho de Alfeu, Simão que pertencia ao grupo que desejava expulsar os romanos, e Judas filho de outro homem chamado Tiago.  ");
INSERT INTO portft_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Todos esses apóstolos eram unânimes a respeito das coisas sobre as quais oravam continuamente juntos. Outras pessoas que os acompanhavam na oração eram as mulheres quem ajudaram/acompanharam Jesus; Maria, a mãe de Jesus; e os irmãos menores dele. ");
INSERT INTO portft_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Durante aqueles dias, Pedro se pôs de pé entre seus irmãos cristãos. Havia naquele momento um grupo de uns 120 seguidores de Jesus, todos reunidos no aposento. ");
INSERT INTO portft_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Então ele disse, “Meus irmãos cristãos, existem palavras que o Rei Davi escreveu MTY nas Escrituras há muito tempo, que precisam ainda ser cumpridas {acontecer como ele previu/vaticinou}. O Espírito Santo, que sabia ser Judas a pessoa que cumpriria aquelas palavras, ditou as palavras a Davi, o qual as escreveu. ");
INSERT INTO portft_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Embora Judas fosse escolhido {Jesus tivesse escolhido Judas}, junto conosco (excl), para servir/trabalhar como apóstolo, foi Judas quem orientou as pessoas que prenderam Jesus”. ");
INSERT INTO portft_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Os líderes judaicos deram dinheiro a Judas quando este prometeu trair Jesus de forma malévola/desleal. Mais tarde, Judas lhes devolveu aquele dinheiro. Quando Judas se enforcou, o corpo dele caiu para o chão. A barriga dele rebentou e todas as tripas se espalharam. Os líderes judaicos empregaram aquele dinheiro na compra de um terreno. ");
INSERT INTO portft_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Todos os habitantes de Jerusalém ouviram sobre isso. Portanto, aquele terreno passou a ser chamado {eles chamaram aquele campo}, de acordo com a própria língua judaica deles, de “Aceldama”, que significa ‘campo de sangue’, pois foi ali que alguém sangrou e morreu. ");
INSERT INTO portft_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pedro disse mais, “Isso precisava acontecer pois entendo que estas palavras escritas {que Davi escreveu} há muito tempo no livro dos Salmos se referem a Judas: ‘Que a propriedade/casa dele fique deserta, sem ninguém para morar nela.’ (OU, ‘Julgue- o, Senhor, par que nem ele nem ninguém mais possa morar na casa dele!’) E estas outras palavras escritas por Davi também se referem a Judas: ‘Que outrem tome posse do seu trabalho de líder’. ");
INSERT INTO portft_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","É preciso, portanto, que nós apóstolos escolhamos um homem para substituir o Judas. Deve ser alguém que nos acompanhou MTY o tempo todo, durante o período em que o Senhor Jesus estava conosco. ");
INSERT INTO portft_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ou seja, desde o dia quando João Batista batizou Jesus até o dia em que Jesus foi levado {quando Deus levou Jesus} do nosso meio para o céu. Deve ser alguém que viu Jesus vivo após a morte dele”. ");
INSERT INTO portft_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Por isso os apóstolos e outros cristãos sugeriram os nomes de dois homens qualificados. Um dos homens foi José que era chamado {a quem as pessoas } chamavam de Barsabás (OU, José Barsabás), que era chamado também pelo nome romano de Justo. O outro homem foi Matias. ");
INSERT INTO portft_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Então eles oraram. Disse um deles, “Senhor Jesus, Judas deixou de ser apóstolo. Por isso ele morreu e foi ao lugar merecido EUP. Nós (excl) precisamos escolher alguém para substituir o Judas para que possa servir-te, tornando-se apóstolo. Tu bem conheces cada um de nós. Portanto, é favor mostrar-nos qual destes dois homens o Senhor escolheste”. ");
INSERT INTO portft_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Então eles deitaram sortes para escolher entre os dois homens, e o nome sorteado foi o de Matias. (OU, Então um dos apóstolos sacudiu numa pequena vasilha pequenos objetos/pedras marcados para determinar qual dos homens Deus tinha escolhido. E o pequeno objeto/pedra devidamente marcado com o nome de Matias caiu da vasilha). Por isso Matias foi considerado {eles consideram Matias} apóstolo, em companhia dos outros onze apóstolos. ");
INSERT INTO portft_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","No dia em que se comemorava o festival de Pentecostes {quando os judeus comemoravam o festival de Pentecostes}, os cristãos estavam todos reunidos no mesmo lugar em Jerusalém. ");
INSERT INTO portft_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ouviram de repente um barulho vindo do céu, que parecia o sopro de um vento bem forte. O barulho ecoava pela casa inteira onde eles estavam sentados. ");
INSERT INTO portft_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Então eles viram algo que parecia chamas de fogo. Essas chamas se separavam umas das outras, pousando uma delas na cabeça de cada um dos cristãos. ");
INSERT INTO portft_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Então todos os cristãos ficaram completamente controlados/habilitados pelo Espírito Santo {o Espírito Santo controlou/habilitou completamente todos os cristãos}, capacitando-os a falar outras línguas MTY que não tinham aprendido. ");
INSERT INTO portft_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Naquela altura, havia em Jerusalém muitos judeus, que foram comemorar o Pentecostes. Eles eram pessoas que tentavam sempre obedecer às leis judaicas. Haviam chegado de muitos e diversos HYP países. ");
INSERT INTO portft_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ao ouvir aquele barulho forte, parecido com o vento, reuniu-se uma multidão no local onde se encontravam os cristãos. Aquelas pessoas não sabiam o que pensar, pois todas elas ouviam os cristãos falarem na língua de cada uma delas (OU, Elas ficaram maravilhadas, pois cada uma ouvia um dos cristãos falar na língua própria dela). ");
INSERT INTO portft_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ficaram maravilhadas e diziam umas às outras: “Todos esses homens que estão falando, têm/não têm RHQ residido sempre no distrito de Galileia, não podendo portanto saber nossas línguas?” ");
INSERT INTO portft_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nós (incl) não entendemos como esses homens conseguem/Como é que esses homens podem RHQ falar nossas próprias línguas?! Mas cada um de nós os ouve fazer justamente isso! ");
INSERT INTO portft_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Alguns de nós somos das regiões da Pártia, da Média e do Elão, e outros residem na Mesopotâmia, na Judeia, na Capadócia, no Ponto e na Ásia. ");
INSERT INTO portft_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Há pessoas da Frígia e da Panfília, do Egito e das regiões da Líbia que ficam perto da cidade de Cirene. Outros de nós vieram de Roma para visitar Jerusalém. ");
INSERT INTO portft_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Entre estes há judeus natos, bem como não judeus que aceitaram a doutrina dos judeus. Outrossim, alguns de nós somos oriundos da ilha de Creta e da região de Arábia. Contudo, enquanto estas pessoas falam nossas línguas MTY nós (incl) as ouvimos relatando as coisas grandes/poderosas que Deus tem feito!” ");
INSERT INTO portft_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Todas essas pessoas ficaram maravilhadas e não sabiam o que pensar daquilo que estava acontecendo. Portanto, elas se perguntavam umas às outras: “O que significa isso”? ");
INSERT INTO portft_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mas alguns outros zombavam daqueles que criam em Jesus, dizendo: “Esses caras/essas pessoas estão falando assim porque beberam demais do vinho novo!” ");
INSERT INTO portft_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Então, levantando-se Pedro em companhia dos outros onze apóstolos, ele falou em voz alta à multidão de pessoas, dizendo: “Meus irmãos judeus e vocês outros que estão visitando Jerusalém, escutem-me e eu lhes explicarei o que está acontecendo. ");
INSERT INTO portft_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Alguns de vocês acham que nós (excl) estamos bêbados, mas não estamos. São apenas nove horas da manhã, e nós nunca ficamos bêbados a esta hora do dia! ");
INSERT INTO portft_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pelo contrário, isto que nos acontece é a coisa milagrosa descrita há muito tempo pelo profeta Joel {que o profeta Joel descreveu há muito tempo}. Joel escreveu: “Deus diz: ");
INSERT INTO portft_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Durante os últimos dias, antes de eu julgar todos os seres humanos, darei meu Espírito abundantemente/generosamente às pessoas SYN por toda a parte. Consequentemente, seus filhos e filhas contarão às pessoas mensagens recebidas de mim. Os jovens entre vocês contemplarão visões mandadas por mim, e os velhos entre vocês terão sonhos que eu lhes mandarei.  ");
INSERT INTO portft_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Durante aqueles dias eu darei abundantemente/generosamente do meu Espírito, inclusive aos cristãos de ambos os sexos que são escravos/servos de outros, portanto eles contarão às pessoas mensagens recebidas de mim. ");
INSERT INTO portft_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Eu farei acontecerem coisas espantosas no céu e farei milagres na terra, os quais mostrarão que eu sou poderoso. Na terra CHI provocarei guerras, então as pessoas derramarão seu sangue e morrerão. Haverá fogo e fumaça bem espessa/escura. ");
INSERT INTO portft_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","No céu, o sol aparecerá escuro às pessoas, e a lua lhes parecerá vermelha. Essas coisas acontecerão antes do dia importante e esplêndido/espantoso MTY quando eu, o Senhor Deus, aparecerei e julgarei todo o mundo.  ");
INSERT INTO portft_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Antes daquele tempo, todos os que me pedirem MTY para salvá-los da culpa do pecado serão salvos {Eu o Senhor salvarei todos os que me pedirem MTY para salvá-los da culpa dos pecados.}’” ");
INSERT INTO portft_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pedro continuou: “Meus conterrâneos de Israel, escutem-me! Quando Jesus, da cidadezinha de Nazaré, viveu entre vocês, foi-lhes comprovado por Deus {Deus comprovou a vocês} que Ele o tinha mandado/o enviou, capacitando Jesus a praticar muitos milagres estupendos que comprovaram/mostraram que Ele tinha vindo/veio de Deus. Vocês mesmos sabem que isso é verdade.  ");
INSERT INTO portft_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mas mesmo sabendo isso, vocês deixaram alguém entregar o homem Jesus nas mãos dos seus inimigos. Contudo, isso já tinha sido programado por Deus {Deus já tinha providenciado isso} e Ele sabia tudo que aconteceria. Então vocês instigaram certos homens SYN que não obedecem a lei de Deus a matá-lo. Eles assim fizeram, pregando-o numa cruz. ");
INSERT INTO portft_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Jesus sofreu terrivelmente ao morrer, mas Deus não O deixou morto, pois era impossível que Ele PRS permanecesse morto. Deus fez com que Ele ficasse vivo novamente. ");
INSERT INTO portft_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Há muito tempo, o Rei Davi escreveu aquilo que o Messias disse: ‘Eu via continuamente que o Senhor Deus está perto de mim. Ele está a meu lado/comigo MTY, portanto, não terei medo das pessoas que desejam fazer-me mal.  ");
INSERT INTO portft_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Por causa disso, eu SYN te louvo, ó Deus, com alegria. Também tenho plena confiança de que tu vais fazer meu corpo ficar vivo de novo.  ");
INSERT INTO portft_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tu não vais permitir que meu Espírito permaneça no lugar onde habitam os mortos. Tu nem vais deixar meu corpo apodrecer, pois estou consagrado a ti e sempre te obedeço. ");
INSERT INTO portft_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tu me disseste que vais fazer-me viver novamente após ter morrido. Tu vais fazer-me muito feliz, pois estarás comigo para sempre’”. ");
INSERT INTO portft_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pedro falou com ousadia: “Meus irmãos judeus, posso dizer-lhes com confiança/desembaraço que nosso antepassado real, Davi, morreu, sendo enterrado o corpo dele {que as pessoas enterraram o corpo dele}. E o lugar onde as pessoas enterraram seu corpo ainda fica, até hoje, aqui perto. ");
INSERT INTO portft_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Portanto nós (incl) sabemos que Davi, com estas palavras, não se referia a si mesmo. Mas, por ser profeta, ele proferiu as palavras do Messias. Davi sabia que Deus lhe tinha prometido fortemente que faria com que um dos descendentes dele se tornasse rei MTY, à semelhança do próprio Davi. (OU, fosse o Messias que governaria o povo de Deus, como Davi o tinha governado.) ");
INSERT INTO portft_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Deus capacitou Davi para saber de antemão o que Ele faria, portanto ele pôde dizer que Deus faria o Messias viver de novo após ter morrido. Ele disse que Deus não deixaria que Ele/o Messias permanecesse morto, nem que o corpo dele apodrecesse”. ");
INSERT INTO portft_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Depois de morrer este homem, Jesus, Deus fez com que Ele ficasse vivo novamente e Ele viverá eternamente. Todos nós, seus seguidores, vimos e sabemos que Jesus se tornou vivo novamente. ");
INSERT INTO portft_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jesus tem sido honrado grandemente por Deus {Deus honrou Jesus grandemente}, o qual O fez governar ao lado dele, MTY no céu. Jesus recebeu o Espírito Santo de Deus seu Pai, bem como Deus tinha prometido. Por isso Jesus nos deu generosamente/abundantemente o Espírito Santo, e Ele revela isso pelo que vocês estão vendo e ouvindo. ");
INSERT INTO portft_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Nós (incl) sabemos que Davi não falava de si mesmo, pois Davi não subiu ao céu à semelhança de Jesus. Além disso, Davi mesmo disse o seguinte sobre o Messias: ‘O Senhor Deus disse a meu Senhor o Messias: “Reine aqui a meu lado, ");
INSERT INTO portft_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","enquanto derroto totalmente MTY seus inimigos’”. ");
INSERT INTO portft_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Pedro concluiu: “Quero, portanto, que vocês e todos os demais israelitas/judeus MTY saibam isto com certeza: Deus fez com que este Jesus fosse nosso Senhor/Governante e o Messias. Mas Deus considera que foram vocês que pregaram Jesus numa cruz”. ");
INSERT INTO portft_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Quando as pessoas ouviram as palavras de Pedro, sentiram-se bem culpados. IDM Portanto perguntaram a ele e aos demais apóstolos: “Conterrâneos/Amigos, o que nós (excl) devemos fazer para que Deus nos perdoe”? ");
INSERT INTO portft_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro lhes respondeu: “Cada um de vocês deve voltar-se a Deus, abandonando seu comportamento pecaminoso. Então será batizado {nós (excl) vamos batizá-lo}, se crê agora em Jesus Cristo. Então Deus lhe dará o Espírito Santo. ");
INSERT INTO portft_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Deus prometeu fazer isso MTY para vocês e seus descendentes, como também para todos os outros que crerem nele, inclusive aqueles que moram longe daqui. O Senhor nosso Deus dará seu Espírito a todos os que Ele convidar a pertencer ao povo dele”. ");
INSERT INTO portft_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro falou muito mais, dirigindo- se com força/confiança a eles. Ele lhes rogou: “Peçam a Deus que Ele os salve {para salvá-los}, para que Ele não os castigue quando vier castigar estas pessoas iníquas/perversas que rejeitaram Jesus”! ");
INSERT INTO portft_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Por isso as pessoas que acreditaram na mensagem de Pedro foram batizadas {os discípulos batizaram as pessoas que acreditaram na mensagem de Pedro}. Houve um grupo de uns três mil daqueles SYN que se uniram aos cristãos naquele dia. ");
INSERT INTO portft_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eles obedeciam continuamente aquilo que os apóstolos ensinavam, e também se reuniam continuamente com os demais cristãos. Outrossim, eles costumavam tomar juntos as refeições, celebrando a Ceia do Senhor, e oravam juntos continuamente. ");
INSERT INTO portft_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Todos os habitantes SYN de Jerusalém reverenciavam grandemente a Deus, pois os apóstolos praticavam com frequência muitos tipos de atos milagrosos. ");
INSERT INTO portft_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Todos os que criam em Jesus estavam unidos e se congregavam/se encontravam regularmente. Também compartilhavam tudo que possuíam uns com os outros. ");
INSERT INTO portft_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","De vez em quando alguns deles vendiam uma parte das suas terras e outras coisas que possuíam, e davam uma parte do dinheiro da venda aos outros irmãos do grupo, segundo suas necessidades. ");
INSERT INTO portft_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Diariamente eles continuavam congregando-se/encontrando-se no pátio do templo. Diariamente compartilhavam a comida SYN uns com os outros com alegria e generosidade, ao tomarem juntos as refeições, e celebravam a Ceia do Senhor nos lares. ");
INSERT INTO portft_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Comportando-se dessa forma, louvavam a Deus, e todos os demais habitantes de Jerusalém tinham uma opinião favorável sobre eles. Enquanto essas coisas aconteciam, o Senhor Jesus aumentava diariamente o número de pessoas salvas {que Ele salvava} da culpa dos seus pecados. ");
INSERT INTO portft_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Um dia Pedro e João se dirigiam ao pátio do templo. Eram três horas da tarde, a hora em que as pessoas oravam ali em público.  ");
INSERT INTO portft_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Havia lá um homem sentado que era coxo de nascimento. Ele estava sentado ao lado do portão do pátio do templo, que era chamado {que se chamava} ‘Portão Formoso’. Ele era colocado {As pessoas o colocavam} ali todos os dias, para que pudesse pedir dinheiro às pessoas que entravam no pátio do templo ou saíam dele. ");
INSERT INTO portft_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ao entrarem Pedro e João no pátio do templo, ele (o coxo) os viu, e pediu repetidas vezes que lhe dessem algum dinheiro (OU, ele lhes disse repetidas vezes: “Deem-me dinheiro, por favor!”) ");
INSERT INTO portft_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Olhando fixamente Pedro e João para ele, Pedro lhe disse, “Olhe para nós!” ");
INSERT INTO portft_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Daí ele olhou para eles, esperando receber algum dinheiro deles. ");
INSERT INTO portft_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Então Pedro lhe disse: “Não tenho nenhum dinheiro MTY, mas aquilo que posso fazer, fazerei agora para você. Jesus Cristo, da cidadezinha de Nazaré, me autorizou MTY a curá-lo! Portanto levante-se e ande!” ");
INSERT INTO portft_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Então Pedro pegou na mão direita do homem e o ajudou a ficar de pé. Imediatemente os pés e tornozelos do homem se fortaleceram {ficaram fortes}. ");
INSERT INTO portft_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ele se levantou de um pulo e começou a andar! Então entrou com eles no pátio do templo, enquanto andava, pulava e dava louvores a Deus! ");
INSERT INTO portft_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Todas as pessoas ali reunidas viram o homem andando e louvando a Deus. ");
INSERT INTO portft_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Elas sabiam ser ele o mesmo homem que costumava ficar sentado ao lado do Portão Formoso, no pátio do templo, pedindo dinheiro às pessoas que passavam! Portanto todas as pessoas ali se maravilharam grandemente por causa daquilo que lhe tinha acontecido. ");
INSERT INTO portft_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Enquanto o homem segurava Pedro e João, todas as pessoas ali ficaram tão surpresas que não sabiam o que pensar! Por isso o grupo inteiro correu até onde eles estavam, no setor do páti