﻿USE sofia;
DROP TABLE IF EXISTS sofia.poronbv_vpl;
CREATE TABLE poronbv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES poronbv_vpl WRITE;
INSERT INTO poronbv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","No princípio Deus criou os céus e a terra. ");
INSERT INTO poronbv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","A terra era vazia e sem forma definida, e o Espírito de Deus se movia por sobre as águas. ");
INSERT INTO poronbv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Deus disse: “Haja luz”, e houve luz. ");
INSERT INTO poronbv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Deus ficou satisfeito, e separou a luz da escuridão. ");
INSERT INTO poronbv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Deus chamou a luz de “dia”, e a escuridão de “noite”. O dia e a noite juntos formaram o primeiro dia. ");
INSERT INTO poronbv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","E Deus disse: “Que as águas se separem, entre a expansão do céu em cima e os oceanos em baixo”. ");
INSERT INTO poronbv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Desse modo, Deus formou o firmamento, separando as águas que ficaram acima do firmamento das que ficaram abaixo. E assim foi. ");
INSERT INTO poronbv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Deus chamou o firmamento de céu. E houve tarde e manhã. Tudo isso aconteceu no segundo dia. ");
INSERT INTO poronbv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","E Deus disse: “Que as águas que estão debaixo do céu se juntem, formando mares e oceanos, de modo que apareça a parte seca”. E assim foi. ");
INSERT INTO poronbv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Deus chamou a parte seca de terra, e as águas de mares. E Deus ficou satisfeito. ");
INSERT INTO poronbv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Então ele disse: “Que a terra produza toda espécie de vegetação: plantas que deem sementes, árvores que produzam frutos, que por sua vez produzam sementes de acordo com a sua espécie”. E assim foi. ");
INSERT INTO poronbv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","A terra, pois, fez brotar a vegetação: plantas que dão sementes e árvores que produzem frutos, que por sua vez produzem sementes de acordo com a sua espécie. E Deus ficou satisfeito. ");
INSERT INTO poronbv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Houve tarde e manhã. Tudo isso aconteceu no terceiro dia. ");
INSERT INTO poronbv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Deus ainda disse: “Que no firmamento do céu haja luzes que iluminem a terra para separar o dia da noite. Essas luzes servirão como sinais para estabelecer as estações, os dias e os anos. ");
INSERT INTO poronbv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Elas brilharão no firmamento do céu para iluminar a terra”. E assim foi. ");
INSERT INTO poronbv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Deus fez duas grandes luzes: a maior, o sol, para dirigir o dia, e a menor, a lua, para dirigir a noite. Ele também fez as estrelas. ");
INSERT INTO poronbv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Foi assim que Deus colocou essas luzes no firmamento para iluminarem a terra, ");
INSERT INTO poronbv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","para determinarem os dias e as noites e fazerem separação entre a luz e a escuridão. E Deus ficou satisfeito. ");
INSERT INTO poronbv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Houve tarde e manhã. Tudo isso aconteceu no quarto dia. ");
INSERT INTO poronbv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Depois Deus disse: “Que as águas se encham de peixes e de outras espécies de vida; e voem as aves sobre a terra, sob o firmamento dos céus”. ");
INSERT INTO poronbv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","E Deus criou os grandes animais marinhos, e todo tipo de vida aquática, além das aves, de acordo com as suas espécies. E Deus ficou satisfeito. ");
INSERT INTO poronbv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Então Deus abençoou suas criaturas, dizendo: “Multipliquem-se e encham as águas dos mares”. E às aves falou: “Sejam cada vez mais numerosas. Encham a terra!” ");
INSERT INTO poronbv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Houve tarde e manhã. Tudo isso aconteceu no quinto dia. ");
INSERT INTO poronbv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","E Deus disse: “Que a terra produza seres viventes de acordo com as suas espécies: animais domésticos e animais selvagens, segundo as suas espécies”. E assim foi. ");
INSERT INTO poronbv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Deus fez os animais selvagens, os animais domésticos e os demais seres vivos da terra, de acordo com as suas espécies. E Deus ficou satisfeito. ");
INSERT INTO poronbv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Depois Deus disse: “Façamos o ser humano à nossa imagem e semelhança. Que ele domine sobre os animais marinhos, sobre as aves do céu, sobre os animais domésticos da terra e sobre os répteis que se movem pelo chão”. ");
INSERT INTO poronbv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Assim Deus criou o ser humano semelhante à sua imagem, à imagem de Deus o criou; homem e mulher o criou. ");
INSERT INTO poronbv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Deus os abençoou e disse-lhes: Multipliquem-se, encham a terra e dominem-na. Tenham poder sobre os peixes, sobre as aves dos céus e sobre os animais que rastejam pela terra. ");
INSERT INTO poronbv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","E disse mais: “Eu dou a vocês todas as plantas que nascem na superfície de toda a terra e dão sementes, e todas as árvores frutíferas que dão sementes. ");
INSERT INTO poronbv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","A todos os animais em que há fôlego de vida, ou seja, a todos os animais selvagens, a todas as aves do céu e aos animais que rastejam pelo chão dou todos os vegetais como alimento”. E assim foi. ");
INSERT INTO poronbv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","E Deus viu tudo o que havia feito, e eis que havia ficado muito bom. Houve tarde e manhã. Tudo isso aconteceu no sexto dia. ");
INSERT INTO poronbv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Dessa forma foi concluída a criação dos céus e da terra, com tudo que neles existe. ");
INSERT INTO poronbv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","E no sétimo dia, tendo Deus terminado a sua obra, ele descansou. ");
INSERT INTO poronbv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Deus abençoou o sétimo dia e o declarou santo, pois nele descansou de toda a obra da criação. ");
INSERT INTO poronbv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Esta é a história da origem dos céus e da terra criados por Deus. ");
INSERT INTO poronbv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Ainda não havia vegetação, nem semente que houvesse brotado da terra, porque o Senhor Deus ainda não havia feito chover sobre a terra, e também não havia seres humanos para cultivar a terra. ");
INSERT INTO poronbv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mas um vapor de água subia da terra e irrigava toda a superfície do solo. ");
INSERT INTO poronbv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Então o Senhor Deus formou o corpo humano do pó da terra e soprou em suas narinas o fôlego da vida, e ele tornou-se um ser vivo. ");
INSERT INTO poronbv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Plantou também o Senhor Deus um jardim, no Éden, para os lados do oriente; e nesse jardim colocou o homem que havia criado. ");
INSERT INTO poronbv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Então o Senhor Deus fez brotar toda espécie de lindas árvores que produziam frutas boas como alimento. No centro do jardim estava a árvore da vida e a árvore do conhecimento do bem e do mal. ");
INSERT INTO poronbv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Nascia no Éden um rio que atravessava o jardim para o irrigar, dividindo-se depois em quatro braços. ");
INSERT INTO poronbv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Um destes braços era o rio Pisom, que atravessava toda a terra de Havilá. Nessa região existe ouro. ");
INSERT INTO poronbv_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Esse ouro era de fina qualidade; lá também existem pedras preciosas, como o bdélio e a pedra de ônix. ");
INSERT INTO poronbv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","O segundo braço do rio chama-se Giom, e percorre toda a terra de Cuxe. ");
INSERT INTO poronbv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","O terceiro braço é o rio Tigre, que corre pelo lado leste da Assíria. E o quarto braço é o rio Eufrates. ");
INSERT INTO poronbv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","O Senhor Deus colocou o homem no jardim do Éden para cuidar dele e o cultivar. ");
INSERT INTO poronbv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","E deu-lhe a seguinte ordem: “Você pode comer de toda árvore que está no jardim, ");
INSERT INTO poronbv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","mas não coma da árvore do conhecimento do bem e do mal, porque no dia em que comer dessa fruta, certamente você morrerá”. ");
INSERT INTO poronbv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Depois disse o Senhor Deus: “Não é bom que o homem fique sozinho. Vou fazer para ele uma companheira, uma auxiliadora que lhe corresponda”. ");
INSERT INTO poronbv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Depois de ter formado da terra toda espécie de animais e aves, o Senhor Deus os trouxe ao homem para ver que nome daria a eles. ");
INSERT INTO poronbv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Assim o homem deu nomes a todos os animais domésticos, às aves do céu e aos animais selvagens. No entanto, o homem não encontrou uma companheira que lhe correspondesse. ");
INSERT INTO poronbv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Então o Senhor Deus fez o homem cair em um sono profundo. Enquanto este dormia, tirou uma das costelas dele e fechou o lugar em que ficava a costela. ");
INSERT INTO poronbv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Dessa costela o Senhor Deus fez uma mulher e a levou ao homem. ");
INSERT INTO poronbv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Então o homem disse: “Esta, sim, é parte dos meus ossos e da minha carne. Ela será chamada mulher, porque foi tirada do homem”. ");
INSERT INTO poronbv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Esta é a razão pela qual o homem deixa o seu pai e a sua mãe e se une à sua mulher, e os dois se tornam um só ser. ");
INSERT INTO poronbv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ambos, o homem e a mulher, estavam nus, mas não sentiam vergonha. ");
INSERT INTO poronbv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","A serpente era a mais astuta de todas as criaturas que o Senhor Deus tinha feito. Ela aproximou-se e perguntou à mulher: “É verdade que Deus disse que não deviam comer do fruto de nenhuma das árvores do jardim?” ");
INSERT INTO poronbv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","A mulher respondeu à serpente: “Nós podemos comer do fruto de todas as árvores do jardim, exceto da árvore que está no meio do jardim. ");
INSERT INTO poronbv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Deus disse que não podemos comer da fruta daquela árvore, nem sequer tocá-la, senão morreremos”. ");
INSERT INTO poronbv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","“Certamente vocês não morrerão!”, retrucou a serpente. ");
INSERT INTO poronbv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","“Deus sabe muito bem que no instante em que comerem dessa fruta, seus olhos serão abertos, e vocês, como Deus, serão capazes de distinguir o bem do mal!” ");
INSERT INTO poronbv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","A mulher ficou convencida. Reparando na beleza daquela árvore e que a sua fruta era agradável ao paladar e atraente aos olhos, além de lhe dar entendimento, tomou a fruta e comeu-a. Depois ofereceu a seu marido, e ele também comeu. ");
INSERT INTO poronbv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Os olhos de ambos foram abertos, e perceberam que estavam nus. Foram então juntar folhas de figueira para cobrir-se. ");
INSERT INTO poronbv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ao cair da tarde daquele dia ouviram a voz e os passos do Senhor Deus que passeava pelo jardim, e esconderam-se entre as árvores. ");
INSERT INTO poronbv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","O Senhor Deus chamou o homem: “Onde você está?” ");
INSERT INTO poronbv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ele respondeu: “Percebi que o Senhor estava se aproximando e fiquei com medo, porque estava nu. Por isso me escondi”. ");
INSERT INTO poronbv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","“Quem disse que você estava nu?”, perguntou o Senhor Deus. “Você comeu da fruta da árvore da qual eu o proibi de comer?” ");
INSERT INTO poronbv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","O homem respondeu: “Foi a mulher que me deste por companheira que me ofereceu a fruta da árvore, e eu comi”. ");
INSERT INTO poronbv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Então o Senhor Deus perguntou à mulher: “Por que você fez isso?” Respondeu a mulher: “A serpente me enganou, e eu comi”. ");
INSERT INTO poronbv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Então o Senhor Deus dirigiu-se à serpente: “Este é o seu castigo: Você será a única a ser amaldiçoada entre todos os animais domésticos e entre todos os animais selvagens. Você terá de rastejar sobre o seu ventre, e comerá pó todos os dias da sua vida. ");
INSERT INTO poronbv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","“De agora em diante, você e a mulher serão inimigas. O mesmo ocorrerá entre a sua descendência e a descendência dela. O descendente da mulher esmagará a sua cabeça, e você ferirá o calcanhar dele”. ");
INSERT INTO poronbv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","E o Senhor Deus disse à mulher: “Você terá muitas dores durante a gravidez; com sofrimento você dará à luz filhos. Apesar disso, seu desejo será para o seu marido, e ele a dominará”. ");
INSERT INTO poronbv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ao homem ele disse: “Visto que você deu ouvidos à sua mulher e comeu aquela fruta que eu disse para não comer, o solo da terra será maldito por sua causa. Você precisará lutar todos os dias da sua vida para tirar da terra o seu sustento. ");
INSERT INTO poronbv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ela também produzirá espinhos e ervas daninhas, e você precisará alimentar-se das ervas do campo. ");
INSERT INTO poronbv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Você precisará suar para que a terra produza o seu alimento, até que volte para a terra, da qual você foi formado. Pois você foi feito da terra e à terra voltará”. ");
INSERT INTO poronbv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adão deu à sua mulher o nome Eva pois ela se tornaria a mãe de toda a humanidade. ");
INSERT INTO poronbv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","O Senhor Deus fez roupas de pele de animais e vestiu Adão e sua mulher. ");
INSERT INTO poronbv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Então disse o Senhor Deus: “Agora que o homem se tornou como um de nós, conhecendo o bem e o mal, é necessário que ele não coma da fruta da árvore da vida para que não viva eternamente”. ");
INSERT INTO poronbv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Por isso o Senhor Deus o expulsou do jardim do Éden, e o mandou cultivar a terra da qual tinha sido formado. ");
INSERT INTO poronbv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Depois de ter expulsado o homem, colocou querubins a leste do jardim do Éden, os quais, com uma espada flamejante que se movia, guardavam o caminho de acesso à árvore da vida. ");
INSERT INTO poronbv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Então Adão teve relações com Eva, e ela engravidou e deu à luz um filho, a quem chamou de Caim. Disse ela: “Com a ajuda do Senhor consegui um filho homem!” ");
INSERT INTO poronbv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Depois voltou a dar à luz, e nasceu o irmão dele, Abel. Abel tornou-se pastor de ovelhas, enquanto Caim era agricultor. ");
INSERT INTO poronbv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Quando chegou o tempo da colheita, Caim trouxe ao Senhor uma oferta dos produtos da terra. ");
INSERT INTO poronbv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel fez o mesmo, mas com as primeiras crias do seu rebanho. E o Senhor agradou-se de Abel e da sua oferta, ");
INSERT INTO poronbv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","mas não de Caim nem da sua oferta. Por isso, Caim ficou enfurecido e o seu rosto mostrava seu ódio. ");
INSERT INTO poronbv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","O Senhor perguntou a Caim: “Por que você está furioso e por que o seu rosto mostra ódio? ");
INSERT INTO poronbv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Se você fizer o que é certo, não será aceito? Mas se você agir mal e não obedecer, saiba que o pecado está à sua espera; ele deseja destruí-lo, mas está na sua mão o poder de dominá-lo”. ");
INSERT INTO poronbv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Então Caim convidou a Abel, seu irmão: “Vamos para o campo”. Enquanto caminhavam juntos, Caim atacou o seu irmão Abel e o matou. ");
INSERT INTO poronbv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Depois o Senhor perguntou a Caim: “Onde está o seu irmão Abel?” Respondeu Caim: “Não sei. Será que sou o responsável pelo meu irmão?” ");
INSERT INTO poronbv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Então Deus disse: “O que foi que você fez? O sangue do seu irmão clama por mim, da terra em que foi derramado. ");
INSERT INTO poronbv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Por isso você será amaldiçoado nessa terra manchada pelo sangue dele. ");
INSERT INTO poronbv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Quando você cultivar a terra, ela não dará mais o fruto resultante do seu trabalho. Você passará a vida como um fugitivo errante pela terra”. ");
INSERT INTO poronbv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Caim então disse ao Senhor: “Esse castigo é pesado demais para mim. ");
INSERT INTO poronbv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Hoje me expulsas desta terra que tenho cultivado, e terei de me esconder da tua face. Serei um fugitivo errante pela terra, e qualquer pessoa que me encontrar vai querer me matar!” ");
INSERT INTO poronbv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mas o Senhor lhe respondeu: “Isso não ocorrerá. Se alguém matar você, será castigado sete vezes mais”. E o Senhor colocou em Caim um sinal de identificação, para impedir que fosse morto por alguém que o encontrasse. ");
INSERT INTO poronbv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Assim Caim afastou-se da presença do Senhor e foi estabelecer-se na terra de Node, a leste do Éden. ");
INSERT INTO poronbv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caim teve relações com a sua mulher, e ela engravidou e deu à luz um filho, que recebeu o nome de Enoque. Caim então construiu uma cidade à qual deu o nome do seu filho Enoque. ");
INSERT INTO poronbv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoque foi o pai de Irade. Irade foi o pai de Meujael. Meujael foi o pai de Metusael. Metusael foi o pai de Lameque. ");
INSERT INTO poronbv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameque teve duas mulheres: Ada e Zilá. ");
INSERT INTO poronbv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada teve um filho chamado Jabal. Ele foi o pai de todos os criadores de rebanhos e de todos que vivem em tendas. ");
INSERT INTO poronbv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","O seu irmão chamava-se Jubal, o pai de todos os que tocam harpa e flauta. ");
INSERT INTO poronbv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zilá também deu à luz um filho chamado Tubalcaim, o primeiro a trabalhar com metal fundido, fazendo ferramentas de bronze e de ferro. Este teve uma irmã chamada Naamá. ");
INSERT INTO poronbv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Um dia Lameque disse às suas mulheres: “Ada e Zilá, ouçam-me com atenção: Eu matei um homem porque me feriu, e um jovem, porque me machucou. ");
INSERT INTO poronbv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Se aquele que matar Caim será vingado sete vezes, então eu serei vingado setenta e sete”. ");
INSERT INTO poronbv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Novamente, Adão teve relações com Eva, e ela deu à luz outro filho, a quem chamou Sete, dizendo: “Deus me concedeu outro filho para ocupar o lugar de Abel, a quem Caim matou”. ");
INSERT INTO poronbv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sete foi pai de Enos. Depois do nascimento de Enos, começaram a invocar o nome do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Esta é a lista dos descendentes de Adão. Deus criou o ser humano à sua semelhança; ");
INSERT INTO poronbv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","homem e mulher os criou e os abençoou. Desde o dia em que foram criados, Deus os chamou de humanos. ");
INSERT INTO poronbv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adão tinha 130 anos quando seu filho Sete nasceu, um filho que era conforme à sua imagem e semelhança. ");
INSERT INTO poronbv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Depois do nascimento de Sete, Adão viveu mais 800 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Viveu ao todo 930 anos e morreu. ");
INSERT INTO poronbv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sete tinha 105 anos quando nasceu seu filho Enos. ");
INSERT INTO poronbv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Depois disso, Sete viveu mais 807 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ele morreu com a idade de 912 anos. ");
INSERT INTO poronbv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos tinha 90 anos quando nasceu seu filho Cainã. ");
INSERT INTO poronbv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Depois disso, Enos viveu mais 815 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ele morreu com a idade de 905 anos. ");
INSERT INTO poronbv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cainá tinha 70 anos quando nasceu seu filho Maalaleel, ");
INSERT INTO poronbv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Depois disso, Cainã viveu mais 840 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ele morreu com a idade de 910 anos. ");
INSERT INTO poronbv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maalaleel tinha 65 anos quando nasceu seu filho Jarede. ");
INSERT INTO poronbv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Depois disso, Maalaleel viveu mais 830 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ele morreu com a idade de 895 anos. ");
INSERT INTO poronbv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jarede tinha 162 anos quando nasceu seu filho Enoque. ");
INSERT INTO poronbv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Depois disso, Jarede viveu mais 800 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ele morreu com a idade de 962 anos. ");
INSERT INTO poronbv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoque tinha 65 anos quando nasceu seu filho Matusalém. ");
INSERT INTO poronbv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Depois disso, Enoque viveu mais 300 anos, e andou em comunhão com Deus e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ele viveu ao todo 365 anos. ");
INSERT INTO poronbv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoque sempre andou com Deus e um dia desapareceu, porque Deus o levou. ");
INSERT INTO poronbv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusalém tinha 187 anos quando nasceu seu filho Lameque. ");
INSERT INTO poronbv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Depois disso, Matusalém viveu mais 782 anos e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ele morreu com a idade de 969 anos. ");
INSERT INTO poronbv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameque tinha 182 anos quando lhe nasceu um filho. ");
INSERT INTO poronbv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ele o chamou de Noé e disse: “Este há de trazer-nos descanso para o duro trabalho da terra que o Senhor amaldiçoou”. ");
INSERT INTO poronbv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Depois do nascimento de Noé, Lameque viveu mais 595 anos, e teve outros filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ele morreu com a idade de 777 anos. ");
INSERT INTO poronbv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Quando Noé estava com 500 anos, tinha três filhos: Sem, Cam e Jafé. ");
INSERT INTO poronbv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Quando as pessoas começaram a multiplicar-se na terra e lhes nasceram filhas, ");
INSERT INTO poronbv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","os filhos de Deus repararam na beleza das filhas dos homens, e tomaram para si aquelas que lhes agradaram. ");
INSERT INTO poronbv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","E o Senhor disse: “O meu Espírito não continuará com o homem, visto que ele é todo mau. Ele só viverá 120 anos”. ");
INSERT INTO poronbv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Naqueles dias havia gigantes, e mesmo depois, quando os filhos de Deus tiveram relações com as filhas dos homens, os filhos que lhes nasceram foram heróis de grande fama, conforme nos falam os relatos da antiguidade. ");
INSERT INTO poronbv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","O Senhor viu que a maldade humana foi ficando cada vez pior, e que a imaginação e os pensamentos dos seres humanos os levavam unicamente para o mal. ");
INSERT INTO poronbv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Então o Senhor se arrependeu de ter criado o ser humano sobre a terra, e isso cortou o seu coração! ");
INSERT INTO poronbv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Disse o Senhor: “Farei desaparecer da face da terra tudo o que tem vida: as pessoas, os animais, os répteis e as aves do céu. Estou triste porque os criei”. ");
INSERT INTO poronbv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Noé, porém, agradava ao Senhor com a sua vida. ");
INSERT INTO poronbv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Esta é a história da vida de Noé: Ele era a única pessoa justa e íntegra na terra daquele tempo. Ele conduzia a sua vida de acordo com a vontade de Deus. ");
INSERT INTO poronbv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noé tinha três filhos: Sem, Cam e Jafé. ");
INSERT INTO poronbv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","A violência dominava a terra. Aos olhos de Deus, a terra estava completamente corrompida. ");
INSERT INTO poronbv_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ao ver essa corrupção e como toda a raça humana tinha se deixado arrastar para a depravação e o vício, ");
INSERT INTO poronbv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Deus disse a Noé: “Decidi acabar com todos os seres humanos, porque a terra está cheia de crime e de perversão por causa deles. Eu os destruirei juntamente com a terra. ");
INSERT INTO poronbv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Faça uma embarcação com madeira de cipreste, com vários compartimentos no seu interior e revista-a de piche por dentro e por fora. ");
INSERT INTO poronbv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Estas são as medidas da embarcação que você vai construir: 150 metros de comprimento, 25 metros de largura e 15 metros de altura. ");
INSERT INTO poronbv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Faça-lhe um teto com uma abertura de meio metro entre o teto e o corpo da arca. No interior haverá três andares e uma porta lateral. ");
INSERT INTO poronbv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Faça isso, porque vou cobrir toda a terra com água por meio de um dilúvio, para destruir toda criatura viva debaixo dos céus. Tudo o que houver na terra morrerá. ");
INSERT INTO poronbv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mas prometo fazer uma aliança com você, e você entrará nessa embarcação com sua mulher, seus filhos e suas respectivas mulheres. ");
INSERT INTO poronbv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","De todos os animais existentes faça entrar um casal, macho e fêmea, na embarcação, para que sobrevivam com você. ");
INSERT INTO poronbv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","De cada espécie de aves, de quadrúpedes e até do menor animal que rasteja pelo solo virá um casal a você, para que sejam conservados vivos. ");
INSERT INTO poronbv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Armazene também toda espécie de comida, para seu sustento e o sustento dos animais”. ");
INSERT INTO poronbv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noé fez tudo conforme Deus lhe tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Finalmente chegou o dia em que o Senhor disse a Noé: “Entra na embarcação com toda a sua família, porque, de toda a humanidade, você é o único justo que encontrei. ");
INSERT INTO poronbv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Leve para dentro da embarcação sete casais de cada espécie de animal puro, macho e fêmea, e um casal de cada espécie de animal impuro, macho e fêmea. ");
INSERT INTO poronbv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Leve também sete casais de aves de cada espécie. Assim se poderá manter viva cada espécie após o dilúvio. ");
INSERT INTO poronbv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Daqui a uma semana vou fazer chover sobre a terra durante quarenta dias e quarenta noites, e tudo quanto criei com vida morrerá”. ");
INSERT INTO poronbv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noé fez tudo conforme o Senhor lhe tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noé tinha 600 anos de idade quando as águas do dilúvio vieram sobre a terra. ");
INSERT INTO poronbv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ele, seus filhos, sua mulher e as noras entraram na embarcação, para escaparem das águas do dilúvio. ");
INSERT INTO poronbv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Com eles entraram toda espécie de vida animal, puros e impuros, os que rastejavam pelo chão e as aves. ");
INSERT INTO poronbv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Entraram com Noé na embarcação em pares, macho e fêmea, tal como Deus havia ordenado. ");
INSERT INTO poronbv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Passados sete dias, as águas do dilúvio inundaram a terra. ");
INSERT INTO poronbv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Quando Noé tinha precisamente 600 anos, um mês e dezessete dias de idade, romperam-se todas as fontes do abismo, e as comportas do céu se abriram. ");
INSERT INTO poronbv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Desabou forte chuva sobre a terra durante quarenta dias e quarenta noites. ");
INSERT INTO poronbv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","No dia em que as chuvas começaram a cair, Noé e seus filhos, Sem, Cam e Jafé, com sua mulher e com suas noras, entraram na embarcação. ");
INSERT INTO poronbv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Entraram também todos os animais de acordo com as suas espécies: animais domésticos, animais selvagens, todos os demais seres vivos que rastejam pelo chão, e todas as criaturas com asas: todas as aves e os outros animais que voam. ");
INSERT INTO poronbv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Pares de todas as espécies vivas vieram a Noé e entraram na embarcação. ");
INSERT INTO poronbv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Os animais que entraram eram um macho e uma fêmea de cada ser vivo, tudo como Deus tinha ordenado a Noé. Depois, o Senhor fechou a porta. ");
INSERT INTO poronbv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","O dilúvio durou quarenta dias, e as águas aumentaram e levantaram a embarcação acima da terra. ");
INSERT INTO poronbv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","O nível das águas foi subindo cada vez mais, cobrindo a terra. E a embarcação flutuava na superfície das águas. ");
INSERT INTO poronbv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","As águas aumentaram tanto que cobriram até as montanhas mais altas existentes debaixo do céu, ");
INSERT INTO poronbv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","chegando a quase sete metros acima dos picos. ");
INSERT INTO poronbv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Todos os seres vivos existentes na terra morreram: as aves, os animais domésticos, os animais selvagens, todas as pequenas criaturas que povoam a terra e todo ser humano. ");
INSERT INTO poronbv_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Tudo o que havia na terra seca e que respirava, morreu. ");
INSERT INTO poronbv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Assim foram destruídos todos os seres vivos que existiam na terra; tanto os seres humanos quanto os animais grandes e os animais pequenos que rastejam pelo chão e as aves do céu foram extintos da terra. Apenas Noé e os que estavam com ele na embarcação sobreviveram. ");
INSERT INTO poronbv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","E as águas cobriram a terra por cento e cinquenta dias. ");
INSERT INTO poronbv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Então Deus atentou para Noé e todos os animais selvagens e domésticos que estavam com ele na embarcação. Fez soprar um forte vento sobre a terra, e as águas começaram a baixar. ");
INSERT INTO poronbv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","As fontes do abismo e as comportas do céu se fecharam, e a chuva torrencial parou. ");
INSERT INTO poronbv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","As águas começaram a baixar gradualmente sobre a terra. Passados cento e cinquenta dias, as águas tinham diminuído, ");
INSERT INTO poronbv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","e no décimo sétimo dia do sétimo mês, a embarcação tocou no alto das montanhas de Ararate. ");
INSERT INTO poronbv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","As águas continuaram baixando, até que no primeiro dia do décimo mês apareceram os cumes das montanhas. ");
INSERT INTO poronbv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ao fim de mais quarenta dias, Noé abriu a janela que tinha feito na embarcação, ");
INSERT INTO poronbv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","e soltou um corvo que ficava voando de um lado para o outro. ");
INSERT INTO poronbv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Depois soltou uma pomba para ver se já havia alguma parte seca. ");
INSERT INTO poronbv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mas a pomba não encontrou um lugar onde pousar e voltou para a embarcação porque as águas ainda cobriam toda a terra. Noé estendeu a mão e tomou-a de volta para dentro da embarcação. ");
INSERT INTO poronbv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noé esperou sete dias e soltou novamente a pomba. ");
INSERT INTO poronbv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ao cair da tarde, quando a pomba voltou, ela trouxe no bico uma folha nova de oliveira. Noé concluiu então que as águas tinham diminuído sobre a terra. ");
INSERT INTO poronbv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ele deixou passar mais sete dias e soltou novamente a pomba, mas desta vez ela não voltou. ");
INSERT INTO poronbv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Passaram-se ainda vinte e nove dias depois disso, e quando Noé completou 601 anos de idade, secaram-se as águas na terra. Noé então levantou a cobertura da embarcação e verificou que as águas tinham descido totalmente. ");
INSERT INTO poronbv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ao fim de mais oito semanas, no dia 27 do segundo mês do ano 601 de Noé, a terra estava completamente seca. ");
INSERT INTO poronbv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Então Deus disse a Noé: ");
INSERT INTO poronbv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Saia da embarcação, você e sua mulher, seus filhos e as suas noras. ");
INSERT INTO poronbv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Deixe sair igualmente todos os animais que estão com você: as aves, os animais grandes e os pequenos que rastejam sobre o chão. Faça-os sair, de modo que se espalhem por toda a terra, se reproduzam e se multipliquem”. ");
INSERT INTO poronbv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Então Noé, seus filhos, sua mulher e suas noras saíram da embarcação. ");
INSERT INTO poronbv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Saíram também todos os animais grandes e os pequenos que rastejam sobre o chão e todas as aves. Todos os seres vivos que estavam na embarcação saíram em grupos, segundo as diferentes espécies. ");
INSERT INTO poronbv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noé construiu um altar, tomou alguns animais e aves aceitáveis a Deus e ofereceu-os como sacrifício, queimando-os sobre o altar. ");
INSERT INTO poronbv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","O Senhor ficou satisfeito com esse sacrifício e disse a si mesmo: “Nunca mais voltarei a amaldiçoar a terra por causa dos seres humanos, ainda que a inclinação dos seus corações seja sempre para o mal desde a infância. E nunca mais destruirei todos os seres viventes como fiz. ");
INSERT INTO poronbv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Enquanto durar a terra, sempre haverá semeadura e colheitas, frio e calor, inverno e verão, dia e noite”. ");
INSERT INTO poronbv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Deus abençoou Noé e seus filhos, e disse-lhes: “Tenham muitos filhos e povoem novamente a terra. ");
INSERT INTO poronbv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Todos os animais da terra terão medo de vocês: os animais selvagens, as aves do céu, os animais que rastejam pelo chão e os peixes do mar. Todos eles serão dominados por vocês. ");
INSERT INTO poronbv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Tudo o que vive e se move lhes servirá de alimento, além dos vegetais. ");
INSERT INTO poronbv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Mas nunca comam a carne com a sua vida, isto é, com o sangue. ");
INSERT INTO poronbv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Pedirei contas de cada ser humano e de cada animal que derramar o sangue de alguém. ");
INSERT INTO poronbv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Quem derramar o sangue de um ser humano, pelo ser humano seu sangue será derramado, pois ele foi criado à imagem de Deus. ");
INSERT INTO poronbv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Multipliquem-se, povoem novamente a terra e exerçam domínio sobre ela”. ");
INSERT INTO poronbv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Deus disse mais a Noé e aos seus filhos: ");
INSERT INTO poronbv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Estabeleço a minha aliança com vocês, com todos os seus descendentes ");
INSERT INTO poronbv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","e com todo ser vivo que está com vocês: as aves, os animais domésticos e os animais selvagens, todos os animais que saíram da embarcação com vocês e com todos os animais da terra. ");
INSERT INTO poronbv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Estabeleço uma aliança com vocês: Nunca mais os seres vivos da terra serão destruídos pelas águas. Nunca mais haverá um dilúvio para destruir a terra”. ");
INSERT INTO poronbv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","E Deus disse: “E como sinal desta aliança que estou fazendo entre mim e vocês e com todos os seres vivos que estão com vocês, para todas as gerações, ");
INSERT INTO poronbv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","aparecerá um arco-íris nas nuvens. Este será o sinal da aliança entre mim e a terra. ");
INSERT INTO poronbv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Quando o céu se acumular de nuvens e nelas aparecer esse arco, ");
INSERT INTO poronbv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","então me lembrarei da minha aliança com vocês e com todos os seres vivos. Nunca mais destruirei a vida por meio de um dilúvio semelhante. ");
INSERT INTO poronbv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Verei o arco-íris e atentarei para a aliança eterna que eu, como Deus, fiz com os seres vivos de todas as espécies que existem na terra”. ");
INSERT INTO poronbv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Deus disse a Noé: “Esse é o sinal da aliança que estabeleci entre mim e todos os seres vivos que existem na terra”. ");
INSERT INTO poronbv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Os três filhos de Noé que saíram da embarcação foram Sem, Cam e Jafé. (Cam é aquele de quem descendem todos os cananeus). ");
INSERT INTO poronbv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Esses são os três filhos de Noé. Destes descendem todos os povos da terra. ");
INSERT INTO poronbv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noé tornou-se agricultor e plantou vinhas. ");
INSERT INTO poronbv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Um dia embriagou-se e despiu-se completamente dentro da sua tenda. ");
INSERT INTO poronbv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Cam, pai de Canaã, viu o pai despido, saiu e foi chamar os outros dois irmãos. ");
INSERT INTO poronbv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Então Sem e Jafé pegaram uma capa, chegaram-se de costas com a capa suspensa nos ombros, aproximaram-se do pai no meio da tenda, e o cobriram, sem terem visto a nudez do pai. ");
INSERT INTO poronbv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Quando Noé se refez da sua embriaguez e soube o que tinha acontecido e a forma como o seu filho mais novo tinha agido, ");
INSERT INTO poronbv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","disse: “Maldito seja Canaã. Que se torne escravo dos descendentes de seus irmãos”. ");
INSERT INTO poronbv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","E acrescentou: “Bendito seja o Senhor, Deus de Sem. Que os cananeus sirvam a ele. ");
INSERT INTO poronbv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Que Deus abençoe Jafé e que partilhe da prosperidade de Sem, e que os cananeus também sirvam a ele”. ");
INSERT INTO poronbv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noé viveu ainda 350 anos depois do dilúvio. ");
INSERT INTO poronbv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ele morreu com 950 anos de idade. ");
INSERT INTO poronbv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Os descendentes de Noé são os seguintes: Sem, Cam e Jafé. Eles tiveram filhos depois do dilúvio. ");
INSERT INTO poronbv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Os filhos de Jafé foram: Gômer, Magogue, Madai, Javã, Tubal, Meseque e Tirás. ");
INSERT INTO poronbv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Os filhos de Gômer foram: Asquenaz, Rifate e Togarma. ");
INSERT INTO poronbv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Os filhos de Javã foram: Elisá, Társis, Quitim e Dodanim. ");
INSERT INTO poronbv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Os seus descendentes tornaram-se povos marítimos, conquistando terras e formando nações, cada uma de acordo com a sua língua. ");
INSERT INTO poronbv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Os filhos de Cam foram: Cuxe, Mizraim, Pute e Canaã. ");
INSERT INTO poronbv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Os filhos de Cuxe foram: Sebá, Havilá, Sabtá, Raamá e Sabtecá. Os filhos de Raamá foram: Sabá e Dedã. ");
INSERT INTO poronbv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Um dos descendentes de Cuxe foi Ninrode, que foi o primeiro homem poderoso da terra. ");
INSERT INTO poronbv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ele foi um caçador valente. Daí o provérbio: “Que Deus te faça um caçador valente como Ninrode”. ");
INSERT INTO poronbv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","No início, o seu reino era composto pelas cidades e territórios de Babel, Ereque, Acade e Calné, na terra de Sinear. ");
INSERT INTO poronbv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Dali, ele estendeu o território do seu reino até a Assíria, onde edificou Nínive, Reobote-Ir, Calá ");
INSERT INTO poronbv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","e Resém, que fica entre Nínive e Calá, que era a maior cidade daquele império. ");
INSERT INTO poronbv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim foi o pai dos luditas, anamitas, leabitas, naftuítas, ");
INSERT INTO poronbv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","patrusitas, casluítas (de quem descendem os filisteus) e caftoritas. ");
INSERT INTO poronbv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","O primeiro filho de Canaã foi Sidom, e o segundo, Hete. ");
INSERT INTO poronbv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Também estes povos são descendentes de Canaã: os jebuseus, os amorreus, os girgaseus, ");
INSERT INTO poronbv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","os heveus, os arqueus, os sineus, ");
INSERT INTO poronbv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","os arvadeus, os zemareus e os hamateus. Os cananeus se espalharam por diferentes partes. ");
INSERT INTO poronbv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","As fronteiras dos cananeus estenderam-se desde Sidom, indo em direção a Gerar, até Gaza, continuando até Sodoma, Gomorra, Admá e Zeboim, chegando até Lasa. ");
INSERT INTO poronbv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Esses são os descendentes de Cam que se espalharam em muitas nações, com suas línguas diferentes. ");
INSERT INTO poronbv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Héber, que deu origem a um numeroso povo, era descendente de Sem, irmão mais velho de Jafé. ");
INSERT INTO poronbv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Os filhos de Sem foram: Elão, Assur, Arfaxade, Lude e Arã. ");
INSERT INTO poronbv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Os filhos de Arã foram: Uz, Hul, Géter e Meseque. ");
INSERT INTO poronbv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Salá foi filho de Arfaxade. Héber foi filho de Salá. ");
INSERT INTO poronbv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Héber teve dois filhos: Pelegue e Joctã. Pelegue recebeu esse nome porque em sua época foi feita a divisão da terra entre as nações. ");
INSERT INTO poronbv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Os filhos de Joctã foram: Almodá, Salefe, Hazarmavé, Jerá, ");
INSERT INTO poronbv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adorão, Uzal, Dicla, ");
INSERT INTO poronbv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sabá, ");
INSERT INTO poronbv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havilá e Jobabe. Todos esses foram filhos de Joctã. ");
INSERT INTO poronbv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Eles habitaram a região que vai desde Messa até Sefar, uma região montanhosa que ficava a leste. ");
INSERT INTO poronbv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","São esses os descendentes de Sem, conforme os povos e nações, com suas diferentes línguas e localizações geográficas. ");
INSERT INTO poronbv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","São essas as famílias dos filhos de Noé, das quais se formaram os diferentes povos e nações. Todas essas nações se dispersaram pela terra depois do dilúvio. ");
INSERT INTO poronbv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Naquele tempo, toda a humanidade falava apenas uma língua. ");
INSERT INTO poronbv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","As pessoas avançaram em direção ao leste, descobriram uma planície em Sinear, na terra da Babilônia, e se fixaram ali. ");
INSERT INTO poronbv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","E disseram uns aos outros: “Vamos fazer tijolos de terra bem cozida”. Eles usavam tijolos em vez de pedras, e piche em lugar de argamassa. ");
INSERT INTO poronbv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Então disseram: “Vamos construir uma grande cidade, com uma torre que chegue até os céus. Assim nos tornaremos famosos e não seremos espalhados pela terra toda”. ");
INSERT INTO poronbv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","O Senhor desceu para ver a cidade e a torre que os seres humanos estavam construindo, ");
INSERT INTO poronbv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","e disse: “Eles formam um só povo e falam a mesma língua e eis o que são capazes de fazer. Logo não haverá obstáculo para tudo o que planejarem. ");
INSERT INTO poronbv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Venham, desçamos e confundamos a língua deles, para que não entendam mais uns aos outros”. ");
INSERT INTO poronbv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","E foi dessa forma que o Senhor os espalhou por toda a terra, e eles pararam de construir a cidade. ");
INSERT INTO poronbv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Por isso aquele lugar recebeu o nome de Babel, porque ali o Senhor confundiu a língua das pessoas, e espalhou-as por toda a terra. ");
INSERT INTO poronbv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","São estes os descendentes de Sem: Quando ele tinha 100 anos de idade, nasceu seu filho Arfaxade. Isso aconteceu dois anos após o dilúvio. ");
INSERT INTO poronbv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Depois do nascimento de Arfaxade, Sem viveu mais 500 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaxade tinha 35 anos quando nasceu seu filho Salá. ");
INSERT INTO poronbv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Depois disso, Arfaxade viveu mais 430 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Salá tinha 35 anos quando nasceu seu filho Héber. ");
INSERT INTO poronbv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Depois disso, Salá viveu mais 403 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Héber tinha 34 anos quando nasceu seu filho Pelegue. ");
INSERT INTO poronbv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Depois disso, Héber viveu mais 430 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegue tinha 30 anos quando nasceu seu filho Reú. ");
INSERT INTO poronbv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Depois disso, Pelegue viveu mais 209 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reú tinha 32 anos quando nasceu seu filho Serugue. ");
INSERT INTO poronbv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Depois disso, Reú viveu mais 207 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugue tinha 30 anos quando nasceu seu filho Naor. ");
INSERT INTO poronbv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Depois disso, Serugue viveu mais 200 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naor tinha 29 anos quando nasceu seu filho Terá. ");
INSERT INTO poronbv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Depois disso, Naor viveu mais 119 anos, e teve filhos e filhas. ");
INSERT INTO poronbv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Aos 70 anos, Terá era pai de três filhos: Abrão, Naor e Harã. ");
INSERT INTO poronbv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Esta é a história de Terá: Terá foi o pai de Abrão, Naor e Harã. Harã tinha um filho chamado Ló. ");
INSERT INTO poronbv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Mas Harã morreu ainda novo, em Ur dos caldeus, na terra em que tinha nascido. Terá, seu pai, ainda vivia quando ele morreu. ");
INSERT INTO poronbv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Nesse meio tempo, Abrão e Naor casaram. Abrão casou-se com Sarai. Naor casou-se com Milca, filha de Harã e irmã de Iscá. ");
INSERT INTO poronbv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai era estéril; não tinha filhos. ");
INSERT INTO poronbv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Então Terá levou seu filho Abrão, seu neto Ló, filho de Harã, e sua nora Sarai, mulher de seu filho Abrão, e juntos saíram de Ur dos caldeus, para a terra de Canaã, mas pararam em Harã e estabeleceram-se ali. ");
INSERT INTO poronbv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terá viveu 205 anos e morreu em Harã. ");
INSERT INTO poronbv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Então o Senhor disse a Abrão: “Deixa a sua terra, os seus parentes e a casa de seu pai, e vá para a terra que eu lhe mostrar. ");
INSERT INTO poronbv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Farei de você o pai de uma grande nação. Abençoarei você e tornarei o seu nome famoso. E você será uma bênção para muitos. ");
INSERT INTO poronbv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Abençoarei aqueles que abençoarem você. Amaldiçoarei aqueles que amaldiçoarem você. E por seu intermédio serão abençoados todos os povos da terra”. ");
INSERT INTO poronbv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Então Abrão partiu, como o Senhor lhe havia ordenado. E Ló também foi com ele. Abrão tinha 75 anos quando partiu de Harã. ");
INSERT INTO poronbv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abrão levou sua mulher Sarai, seu sobrinho Ló, e todos os bens e escravos que tinha acumulado em Harã. Partiram para Canaã e lá chegaram. ");
INSERT INTO poronbv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abrão percorreu a terra de Canaã e chegou perto de Siquém, onde acampou junto de um carvalho em Moré. Naquela época os cananeus habitavam aquela terra. ");
INSERT INTO poronbv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Então o Senhor apareceu a Abrão e disse: “Vou dar esta terra aos seus descendentes”. E Abrão construiu ali um altar para lembrar o aparecimento do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Depois saiu daquele lugar e prosseguiu em direção à região montanhosa a leste de Betel e ali montou seu acampamento, ficando Betel a oeste e Ai a leste. Ali edificou um altar ao Senhor e orou a ele. ");
INSERT INTO poronbv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Mais tarde saiu dali e seguiu viagem, indo sempre em direção ao Neguebe. ");
INSERT INTO poronbv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Naquela época houve uma fome terrível em toda a região, e Abrão desceu ao Egito, ficando algum tempo ali, pois a fome era grande. ");
INSERT INTO poronbv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Quando estava chegando ao Egito, Abrão disse a Sarai, sua mulher: “Você é muito bonita. ");
INSERT INTO poronbv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Quando os egípcios virem você, vão dizer: ‘Esta é a mulher dele. Vamos matar o marido e ficar com ela’. ");
INSERT INTO poronbv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Por isso, diga que é a minha irmã, para que me tratem bem por sua causa e a minha vida seja poupada”. ");
INSERT INTO poronbv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Mal chegaram ao Egito, os egípcios repararam na grande beleza de Sarai. ");
INSERT INTO poronbv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Os homens da corte do faraó viram Sarai e lhe falaram da beleza dela, e ela foi levada ao seu palácio. ");
INSERT INTO poronbv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","O Faraó tratou bem a Abrão por causa dela, dando-lhe ovelhas e bois, jumentos, servos e servas, e camelos. ");
INSERT INTO poronbv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","No entanto, o Senhor puniu o faraó e a sua casa com pragas terríveis, por causa de Sarai, mulher de Abrão. ");
INSERT INTO poronbv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Por isso o faraó mandou chamar Abrão e perguntou: “O que você fez comigo? Por que não disse que ela era a sua mulher? ");
INSERT INTO poronbv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Por que disse que era a sua irmã? Foi por isso que tomei Sarai como esposa. Aqui está a sua mulher. Leve-a embora com você!” ");
INSERT INTO poronbv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Em seguida o faraó deu ordens para que providenciassem a partida de Abrão. Assim saíram Abrão e sua mulher com tudo o que possuíam. ");
INSERT INTO poronbv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Saiu, pois, Abrão do Egito e dirigiu-se para o Neguebe, com sua mulher e com tudo o que possuía. E Ló foi junto. ");
INSERT INTO poronbv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abrão tinha-se tornado muito rico, tanto em gado quanto em prata e ouro. ");
INSERT INTO poronbv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Eles continuaram indo para o norte em direção a Betel, indo de um lugar para outro, até o lugar em que tinham acampado anteriormente, entre Betel e Ai. ");
INSERT INTO poronbv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Chegaram ao lugar onde Abrão tinha construído um altar. Ali prestou novamente culto ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ló também enriquecera muito na companhia de Abrão, possuindo muitas ovelhas, muito gado e muita gente a serviço dele. ");
INSERT INTO poronbv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Mas a região acabou tornando-se pequena para os dois porque tinham tantos bens que não havia sustento para ambos. ");
INSERT INTO poronbv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Por isso havia brigas entre os pastores de Abrão e os de Ló. Nessa época os cananeus e os ferezeus habitavam aquelas terras. ");
INSERT INTO poronbv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Então Abrão disse a Ló: “Não deve haver brigas entre mim e você, ou entre os seus pastores e os meus. Afinal, somos parentes próximos! ");
INSERT INTO poronbv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Não está diante de você toda a terra? Vamos separar-nos. Se você escolher as terras do lado esquerdo, eu ficarei com as terras do lado direito; se escolher as terras do lado direito, ficarei com as terras do lado esquerdo”. ");
INSERT INTO poronbv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ló então observou com atenção a bela planície do Jordão, toda ela irrigada, antes de o Senhor ter destruído Sodoma e Gomorra. Toda aquela região parecia o próprio jardim do Senhor. Era comparável à terra do Egito, como quem vai até Zoar. ");
INSERT INTO poronbv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Então Ló escolheu toda a planície do Jordão e partiu em direção ao leste. E eles se separaram um do outro. ");
INSERT INTO poronbv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abrão continuou na terra de Canaã, e Ló armou suas tendas entre as cidades da planície, estabelecendo-se perto de Sodoma. ");
INSERT INTO poronbv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Os homens de Sodoma eram extremamente maus e pecadores contra o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Disse o Senhor a Abrão, depois que Ló separou-se dele: “Olhe até onde a sua vista alcançar. Olhe para o norte, para o sul, para o leste e para o oeste. ");
INSERT INTO poronbv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Toda esta terra que você está vendo vou dar a você e aos seus descendentes para sempre! ");
INSERT INTO poronbv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Farei a sua descendência tão numerosa como o pó da terra. Será impossível contá-la. Se for possível contar o pó da terra, então será possível contar a sua descendência. ");
INSERT INTO poronbv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Comece a percorrer toda a terra, de norte a sul e de leste a oeste, porque eu darei esta terra a você”. ");
INSERT INTO poronbv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Então Abrão mudou seu acampamento para perto dos carvalhos de Manre, próximo de Hebrom. Ali Abrão construiu um altar ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Nessa época Anrafel, rei de Sinear, Arioque rei de Elasar, Quedorlaomer, rei de Elão e Tidal, rei de Goim, ");
INSERT INTO poronbv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","estavam em guerra contra Bera, rei de Sodoma, contra Birsa, rei de Gomorra, contra Sinabe, rei de Admá, contra Semeber, rei de Zeboim, e contra o rei de Belá, depois conhecido pelo nome de Zoar. ");
INSERT INTO poronbv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Estes últimos cinco reis mobilizaram os seus exércitos no vale de Sidim, onde fica o mar Salgado. ");
INSERT INTO poronbv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Por doze anos tinham sido dominados pelo rei Quedorlaomer, mas no décimo terceiro ano se rebelaram. ");
INSERT INTO poronbv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","No décimo quarto ano Quedorlaomer e os reis aliados derrotaram os refains em Asterote-Carnaim, os zuzins em Hã, os emins em Savé-Quiriataim, ");
INSERT INTO poronbv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","e os horeus nos montes de Seir até El-Parã, perto do deserto. ");
INSERT INTO poronbv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Na volta, passaram por En-Mispate — mais tarde chamada de Cades — e conquistaram os territórios dos amalequitas e dos amorreus que viviam em Hazazom-Tamar. ");
INSERT INTO poronbv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Nisso os reis de Sodoma, de Gomorra, de Admá, de Zeboim e de Belá, que é Zoar, se prepararam para a batalha, no vale de Sidim, ");
INSERT INTO poronbv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","contra as forças de Quedorlaomer, rei de Elão, contra Tidal, rei de Golim, contra Anrafel, rei de Sinear, e contra Arioque, rei de Elasar. Eram quatro reis contra cinco. ");
INSERT INTO poronbv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ocorreu que o vale de Sidim estava cheio de poços de piche. Quando os reis de Sodoma e Gomorra fugiram, alguns dos seus homens caíram nos poços de piche e o restante conseguiu escapar para as montanhas. ");
INSERT INTO poronbv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Então os vencedores saquearam as cidades de Sodoma e Gomorra, levando consigo todas as riquezas e todo seu mantimento, e deixaram a região. ");
INSERT INTO poronbv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ló, sobrinho de Abrão, que morava em Sodoma, também foi levado, junto com os seus bens. ");
INSERT INTO poronbv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Um dos homens que conseguiu escapar veio relatar tudo o que havia ocorrido a Abrão, o hebreu. Abrão morava próximo aos carvalhos de Manre, o amorreu. Manre e seus irmãos Escol e Aner eram aliados de Abrão. ");
INSERT INTO poronbv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Quando Abrão soube que seu sobrinho Ló tinha sido capturado, juntou os 318 homens treinados, nascidos na sua casa, e perseguiu os inimigos até Dã. ");
INSERT INTO poronbv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abrão dividiu os seus homens em grupos e atacou-os durante a noite, e os derrotou, perseguindo-os até Hobá, ao norte de Damasco, ");
INSERT INTO poronbv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","recuperando todos os bens que tinham sido saqueados. Ele trouxe também de volta seu sobrinho Ló, os bens dele, as suas mulheres e os demais prisioneiros. ");
INSERT INTO poronbv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abrão voltou vitorioso da luta contra Quedorlaomer e os reis aliados. No vale de Savé, isto é, o vale do Rei, veio encontrar-se com ele o rei de Sodoma. ");
INSERT INTO poronbv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melquisedeque, rei de Salém (isto é, Jerusalém) e sacerdote do Deus Altíssimo, ofereceu-lhe pão e vinho ");
INSERT INTO poronbv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","e abençoou Abrão, dizendo: “Que a bênção do Deus Altíssimo, criador dos céus e da terra, seja sobre você, ");
INSERT INTO poronbv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","e bendito seja o Deus Altíssimo, que entregou os seus inimigos em suas mãos”. Então Abrão deu a Melquisedeque o dízimo de tudo o que tinha. ");
INSERT INTO poronbv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","O rei de Sodoma disse a Abrão: “Dê-me as pessoas que você libertou e fique com os bens”. ");
INSERT INTO poronbv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Mas Abrão respondeu: “De mãos levantadas diante do Senhor, o Deus Altíssimo, criador dos céus e da terra, ");
INSERT INTO poronbv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","juro que não ficarei com coisa alguma do que é seu, nem um fio sequer ou uma simples correia de sandália. Para que você jamais venha a dizer: ‘Eu enriqueci a Abrão’. ");
INSERT INTO poronbv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nada quero para mim, a não ser o que os meus servos comeram e ainda a parte que pertence aos meus aliados Aner, Escol e Manre, que combateram comigo. Eles poderão receber a parte deles”. ");
INSERT INTO poronbv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Depois desses acontecimentos, o Senhor falou a Abrão por meio de uma visão: “Abrão, não tenha medo! Eu sou o seu escudo. A sua recompensa será enorme!” ");
INSERT INTO poronbv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Mas Abrão perguntou: “Ó Soberano Senhor, que me darás, se continuo sem filhos e o meu herdeiro é Eliezer, de Damasco?” ");
INSERT INTO poronbv_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","E Abrão acrescentou: “Tu não me deste descendentes. Um servo da minha casa será o meu herdeiro”. ");
INSERT INTO poronbv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Disse, porém, o Senhor: “Não. Seu herdeiro não será Eliezer. O seu herdeiro será um filho gerado por você mesmo”. ");
INSERT INTO poronbv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Então o Senhor levou-o para fora da tenda e disse-lhe: “Olhe para o céu e conte as estrelas, se puder”. E prosseguiu: “Assim será a sua descendência”. ");
INSERT INTO poronbv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abrão creu no Senhor. E Deus considerou Abrão justo, por causa da sua fé. ");
INSERT INTO poronbv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Deus continuou falando com Abrão: “Eu sou o Senhor que tirei você de Ur dos caldeus, para dar a você esta terra como herança”. ");
INSERT INTO poronbv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abrão perguntou-lhe: “Ó Soberano Senhor, como posso ter certeza de que esta terra será minha?” ");
INSERT INTO poronbv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Respondeu-lhe o Senhor: “Traga aqui uma novilha, uma cabra e um cordeiro. Cada animal deverá ter três anos. Traga também uma rolinha e um pombinho”. ");
INSERT INTO poronbv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abrão obedeceu. Ele trouxe todos esses animais, cortou-os ao meio e colocou uma metade em frente a outra; as aves, porém, ele não cortou. ");
INSERT INTO poronbv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Quando as aves de rapina desciam sobre os animais, Abrão as espantava. ");
INSERT INTO poronbv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Naquela tarde, enquanto o sol se punha, Abrão caiu num sono profundo, e ele se viu no meio de uma escuridão densa e pavorosa! ");
INSERT INTO poronbv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Então o Senhor disse a Abrão: “Fique sabendo que os seus descendentes viverão numa terra estrangeira e serão oprimidos e explorados como escravos por 400 anos. ");
INSERT INTO poronbv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mas eu castigarei a nação que vai escravizá-los e, por fim, os seus descendentes sairão de lá com muita riqueza. ");
INSERT INTO poronbv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Quanto a você, sossegue! Você acabará sua vida em paz numa feliz velhice. ");
INSERT INTO poronbv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Depois de quatro gerações, os seus descendentes voltarão para esta terra, porque a maldade do povo amorreu que vive aqui ainda não atingiu a medida plena, exigindo o castigo”. ");
INSERT INTO poronbv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Depois que o sol se pôs e a escuridão da noite chegou, eis que um fogareiro lançava fumaça, e uma tocha de fogo passou entre os pedaços de carne dos animais que tinham sido partidos ao meio. ");
INSERT INTO poronbv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Naquele mesmo dia, o Senhor fez a seguinte aliança com Abrão: “Dei esta terra aos seus descendentes, desde o rio do Egito até o grande rio Eufrates, ");
INSERT INTO poronbv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","incluindo os seguintes povos: os queneus, os quenezeus, os cadmoneus, ");
INSERT INTO poronbv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","os heteus, os ferezeus, os refains, ");
INSERT INTO poronbv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","os amorreus, os cananeus, os girgaseus e os jebuseus”. ");
INSERT INTO poronbv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, mulher de Abrão, não tinha filhos. Sarai tinha uma criada egípcia chamada Hagar. ");
INSERT INTO poronbv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai disse a Abrão: “Já que o Senhor não me deu filhos, tenha relações com a minha criada. Se ela tiver filhos, serão meus”. Abrão concordou com a proposta de Sarai. ");
INSERT INTO poronbv_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Então Sarai, mulher de Abrão, deu a sua criada egípcia Hagar por mulher a Abrão, seu marido. Isso ocorreu depois de Abrão ter habitado por dez anos na terra de Canaã. ");
INSERT INTO poronbv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ele concordou, teve relações com Hagar e ela engravidou. Quando Hagar viu que estava grávida, ficou arrogante e começou a tratar a sua senhora com desprezo. ");
INSERT INTO poronbv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Então Sarai falou com Abrão: “Você deveria sentir a vergonha que estou passando! Entreguei a minha serva a você. Dei a ela o privilégio de ser a sua mulher, e agora que sabe que está grávida, me despreza!” ");
INSERT INTO poronbv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Respondeu-lhe Abrão: “Sua serva é propriedade sua. Faça com ela o que você achar melhor”. Então Sarai maltratou-a de tal forma que Hagar precisou fugir. ");
INSERT INTO poronbv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","O Anjo do Senhor encontrou Hagar perto de uma fonte no deserto, ao lado da estrada de Sur, ");
INSERT INTO poronbv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","e disse a ela: “Hagar, serva de Sarai, de onde você vem e para onde está indo?” Respondeu Hagar: “Estou fugindo da minha senhora, Sarai”. ");
INSERT INTO poronbv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Então o Anjo do Senhor lhe disse: “Volte para a sua senhora e humilhe-se”. ");
INSERT INTO poronbv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","E o Anjo do Senhor continuou: “Faça o que digo, pois vou fazer de você uma grande nação. Ela se tornará tão numerosa que ninguém poderá contá-la”. ");
INSERT INTO poronbv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Disse-lhe ainda o Anjo do Senhor: “Você está grávida e vai ter um filho. Dê a ele o nome de Ismael, porque o Senhor deu ouvidos ao seu sofrimento e queixa. ");
INSERT INTO poronbv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","O seu filho se tornará um homem livre e indomável como um jumento selvagem! Ele será contra todos, e todos serão contra ele. Ele viverá perto de todos os descendentes do seu pai”. ");
INSERT INTO poronbv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Este foi o nome que Hagar deu ao Senhor: “O Deus que me vê”. Ela perguntou: “Será que eu vi aquele que me vê?” ");
INSERT INTO poronbv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Por isso aquela fonte que fica entre Cades e Berede passou a ser chamada de Beer-Laai-Roi. ");
INSERT INTO poronbv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Assim Hagar deu um filho a Abrão. Abrão deu ao menino o nome de Ismael. ");
INSERT INTO poronbv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abrão tinha 86 anos quando Ismael nasceu. ");
INSERT INTO poronbv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Quando Abrão estava com 99 anos de idade, o Senhor apareceu a ele, e disse: “Eu sou o Deus todo-poderoso. Faça a minha vontade e seja íntegro. ");
INSERT INTO poronbv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Farei uma aliança com você e multiplicarei grandemente os seus descendentes”. ");
INSERT INTO poronbv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Vendo que Deus estava falando, Abrão prostrou-se, com o rosto no chão, e Deus lhe disse: ");
INSERT INTO poronbv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Esta é a minha aliança com você: ‘Você será o pai de muitas nações. ");
INSERT INTO poronbv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Por isso mudo o seu nome de Abrão para Abraão, porque farei de você pai de numerosas nações. ");
INSERT INTO poronbv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Farei com que seus descendentes sejam muito numerosos e formem muitas nações. Entre os seus descendentes haverá reis. ");
INSERT INTO poronbv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Esta aliança que estabeleço será entre mim e você e os seus descendentes, de geração em geração. Eu serei o seu Deus e o Deus dos seus descendentes. ");
INSERT INTO poronbv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","E darei a eles toda a terra de Canaã, onde você está morando como estrangeiro. Ela será para sempre dos seus descendentes, e eu serei o Deus deles’. ");
INSERT INTO poronbv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","“Agora veja a sua parte neste pacto”, disse Deus a Abraão. “Guarde a minha aliança, você e seus descendentes. ");
INSERT INTO poronbv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Esta é a minha aliança que você e os seus descendentes devem guardar: todos do sexo masculino devem ser circuncidados. ");
INSERT INTO poronbv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Esta circuncisão será o sinal da aliança entre mim e você. É a prova de que você e seus descendentes aceitam a minha aliança. ");
INSERT INTO poronbv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Todos os que forem do sexo masculino serão circuncidados no oitavo dia, tanto os nascidos em sua casa quanto os que forem comprados de estrangeiros. ");
INSERT INTO poronbv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Tanto os nascidos em casa quanto os comprados terão de ser circuncidados. Esta marca no corpo de vocês será um sinal permanente da minha aliança eterna. ");
INSERT INTO poronbv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Todo aquele do sexo masculino que não for circuncidado será cortado do seu povo. Ele quebrou a minha aliança”. ");
INSERT INTO poronbv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Deus continuou falando: “Sarai também vai mudar de nome. De agora em diante sua mulher se chamará Sara. ");
INSERT INTO poronbv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Abençoarei Sara e darei a você um filho por meio dela. Sim, eu abençoarei Sara e farei que ela seja mãe de nações!” ");
INSERT INTO poronbv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Então Abraão prostrou-se, com o rosto no chão, ficou perplexo e disse a si mesmo: “Será que um homem de cem anos de idade pode gerar um filho? Será que Sara pode dar à luz aos noventa anos?” ");
INSERT INTO poronbv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","E Abraão disse a Deus: “Que Ismael possa ser abençoado pelo Senhor!” ");
INSERT INTO poronbv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Deus respondeu: “Na verdade Sara, sua mulher, dará um filho a você, e você deverá dar a ele o nome de Isaque. Firmarei a minha aliança com ele e com os seus descendentes para sempre. ");
INSERT INTO poronbv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Quanto a Ismael, levarei em conta o seu pedido. Eu abençoarei Ismael e tornarei muito numerosa a sua descendência. Doze príncipes estarão entre os seus descendentes. Ismael será o pai de um grande povo. ");
INSERT INTO poronbv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mas a minha aliança será com Isaque, filho que Sara lhe dará daqui a um ano”. ");
INSERT INTO poronbv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Depois de terminar de falar com Abraão, Deus subiu e se retirou. ");
INSERT INTO poronbv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Naquele mesmo dia, Abraão pegou seu filho Ismael e a todos os escravos nascidos em sua casa e os que foram comprados, do sexo masculino, e os circuncidou, como Deus lhe tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraão tinha 99 anos quando foi circuncidado, ");
INSERT INTO poronbv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","e seu filho Ismael tinha treze. ");
INSERT INTO poronbv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraão e seu filho Ismael foram circuncidados no mesmo dia. ");
INSERT INTO poronbv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","E com Abraão foram circuncidados todos os meninos e homens da casa de Abraão, incluindo os escravos, tanto os da sua casa quanto os comprados. ");
INSERT INTO poronbv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abraão morava perto dos carvalhos de Manre. Um dia o Senhor apareceu a ele. Na hora mais quente do dia, Abraão estava sentado junto à entrada de sua tenda. ");
INSERT INTO poronbv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","De repente Abraão viu três homens em pé, perto dele. Quando os viu, correu ao encontro deles e prostrou-se. ");
INSERT INTO poronbv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“Meu Senhor”, disse Abraão, “se sou digno, tenha a bondade de ficar aqui e descansar um pouco. ");
INSERT INTO poronbv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mandarei trazer água para lavarem os seus pés e assim poderão descansar debaixo desta árvore. ");
INSERT INTO poronbv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Vou preparar uma refeição, para que ganhem novas forças e prossigam a viagem”. “Está bem”, disseram eles, “faça como você disse”. ");
INSERT INTO poronbv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraão correu à tenda e disse a Sara: “Depressa, pegue três medidas da nossa melhor farinha, amasse-a e faça uns pães”. ");
INSERT INTO poronbv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Depois ele mesmo correu ao pasto, escolheu um belo novilho e mandou um servo preparar a carne. ");
INSERT INTO poronbv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Colocou diante deles então a coalhada, o leite e o novilho que tinha mandado preparar. Ele permaneceu ali debaixo da árvore, fazendo companhia a eles enquanto comiam. ");
INSERT INTO poronbv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","“Onde está Sara, sua mulher?”, perguntaram eles. “Ela está ali na tenda”, respondeu Abraão. ");
INSERT INTO poronbv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Um deles disse: “Daqui a um ano voltarei a visitar vocês, e Sara, sua mulher, terá um filho”. Sara estava na entrada da tenda, atrás dele, e escutou o que disse. ");
INSERT INTO poronbv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraão e Sara eram muito velhos, de idade bem avançada, e as condições físicas de Sara já não permitiam que ela tivesse filhos. ");
INSERT INTO poronbv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Por isso, Sara riu por dentro, pensando: “Depois de velha e o meu senhor também velho, ainda terei esse prazer?” ");
INSERT INTO poronbv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Mas o Senhor disse a Abraão: “Por que Sara riu e disse consigo mesma: ‘Será que é verdade que poderei dar à luz, sendo velha?’ ");
INSERT INTO poronbv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Por acaso existe alguma coisa difícil demais para o Senhor?” E disse mais: “No ano que vem voltarei a você, e Sara terá um filho”. ");
INSERT INTO poronbv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ao ouvir isso, Sara ficou com medo. Ela mentiu, dizendo: “Eu não estava rindo”. Mas o Senhor disse a ela: “Não diga isso. Você bem sabe que riu”. ");
INSERT INTO poronbv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Em seguida levantaram-se e tomaram a direção de Sodoma. Abraão foi com eles até certa distância. ");
INSERT INTO poronbv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","“Será que vou esconder o meu plano de Abraão?”, perguntou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","“Abraão será o pai de uma grande nação. Além disso, ele vai ser instrumento de bênção para todas as nações da terra! ");
INSERT INTO poronbv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Pois eu o escolhi para que ordene a seus filhos e descendentes que o sigam, a fim de guardar o caminho do Senhor, fazendo o que é justo e bom, para que eu faça por Abraão tudo o que lhe prometi”. ");
INSERT INTO poronbv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Disse mais o Senhor: “Chegaram até mim as acusações contra Sodoma e Gomorra. A queixa contra o pecado daquelas cidades é tão grave, ");
INSERT INTO poronbv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","que descerei até lá para ver se as acusações são de fato verdadeiras ou não”. ");
INSERT INTO poronbv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Dois daqueles homens foram para Sodoma, mas o Senhor ficou mais um pouco com Abraão. ");
INSERT INTO poronbv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraão aproximou-se dele, e disse: “O Senhor seria capaz de matar os bons juntamente com os maus? ");
INSERT INTO poronbv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Se houver na cidade, digamos, cinquenta pessoas justas, o Senhor destruiria a cidade? Não pouparia o povo por amor daqueles cinquenta cidadãos bons? ");
INSERT INTO poronbv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Não seria justo! Certamente o Senhor não fará uma coisa dessas: matar os que o amam junto com os que o desprezam. Fazendo assim, estaria igualando os justos com os injustos, os bons com os maus! Claro que não faria isto! Não é justo o Juiz de toda a terra?” ");
INSERT INTO poronbv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","O Senhor respondeu: “Se eu achar cinquenta justos em Sodoma, não destruirei a cidade, por amor a eles”. ");
INSERT INTO poronbv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraão voltou a falar: “Sei que sou pó e cinza. ");
INSERT INTO poronbv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Mas comecei a falar ao Senhor e devo continuar. E na hipótese de faltarem cinco para completarem os cinquenta justos? Por causa desses cinco que faltaram, o Senhor destruiria a cidade?” Deus disse: “Não destruirei a cidade, se achar nela quarenta e cinco justos”. ");
INSERT INTO poronbv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraão falou de novo: “E se achar ali quarenta justos?” O Senhor respondeu: “A cidade não será destruída, por causa dos quarenta”. ");
INSERT INTO poronbv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraão insistiu: “Peço que tenha paciência, Senhor. Se forem trinta os justos?” O Senhor respondeu: “Se encontrar trinta, não a destruirei”. ");
INSERT INTO poronbv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraão prosseguiu: “Sei que estou sendo ousado, mas, por favor: E se apenas vinte justos forem encontrados ali?” O Senhor respondeu: “Não destruirei a cidade, por amor aos vinte”. ");
INSERT INTO poronbv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Disse, por fim, Abraão: “Não fique irado, Senhor, se lhe falar só mais uma vez. E se forem encontrados apenas dez justos?” O Senhor respondeu: “Não destruirei a cidade por amor aos dez”. ");
INSERT INTO poronbv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Quando acabou de falar com Abraão, o Senhor se retirou. E Abraão foi para casa. ");
INSERT INTO poronbv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ao anoitecer daquele mesmo dia, os dois anjos chegaram à entrada da cidade de Sodoma. Ló estava sentado à entrada quando os avistou. Ele se levantou, correu para recebê-los, prostrou-se com o rosto no chão ");
INSERT INTO poronbv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","e disse: “Senhores, venham à minha casa. Lá vocês poderão lavar os pés e passar a noite. Amanhã cedo poderão seguir viagem”. Eles, porém, responderam: “Não. Passaremos a noite na praça pública”. ");
INSERT INTO poronbv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mas Ló insistiu muito e eles acabaram aceitando o convite. Ló ofereceu a eles um banquete. Mandou preparar pães sem fermento. E eles comeram. ");
INSERT INTO poronbv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Quando estavam se preparando para dormir, vieram todos os homens de Sodoma, tanto jovens como velhos, e cercaram a casa. ");
INSERT INTO poronbv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Eles gritaram a Ló: “Traga para fora os homens que estão aí. Queremos ter relações com eles”. ");
INSERT INTO poronbv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ló saiu da casa depressa, fechou a porta atrás de si ");
INSERT INTO poronbv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","e disse aos homens: “Por favor, meus irmãos, não façam essa maldade! ");
INSERT INTO poronbv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Escutem, tenho duas filhas virgens; eu as entrego a vocês para que façam com elas o que quiserem. Mas deixem meus hóspedes em paz, porque eles contam com a minha proteção”. ");
INSERT INTO poronbv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","“Saia da frente!”, gritaram os sodomitas. “Quem você pensa que é? Ora, deixamos este sujeito morar em nossa cidade como estrangeiro e agora quer ser nosso juiz! Pois vamos fazer com você coisa pior do que a eles”. E avançaram contra Ló, dispostos a arrombar a porta. ");
INSERT INTO poronbv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mas os hóspedes puxaram-no depressa para dentro da casa e fecharam a porta. ");
INSERT INTO poronbv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Depois deixaram cegos os homens que estavam fora, desde o mais jovem até o mais velho, de modo que não conseguiram encontrar a porta. ");
INSERT INTO poronbv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Então os hóspedes perguntaram a Ló: “Você tem mais parentes nesta cidade — genros, filhos, filhas, ou outro parente? Leve-os todos embora daqui. ");
INSERT INTO poronbv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Pois vamos destruir a cidade completamente. As acusações contra ela aumentaram muito e chegaram ao céu. Por isso o Senhor nos enviou para destruir a cidade”. ");
INSERT INTO poronbv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Então Ló foi correndo falar com os futuros genros das suas filhas e disse-lhes: “Tratem de sair imediatamente da cidade. Ela vai ser destruída pelo Senhor”. Mas os moços acharam que ele estava brincando, e não deram ouvidos. ");
INSERT INTO poronbv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","No dia seguinte, bem cedo, os anjos insistiram com Ló, dizendo: “Arrume-se depressa. Pegue a sua mulher e suas duas filhas que estão aqui, e saiam enquanto podem! Vocês estão correndo risco de morrer com a destruição da cidade”. ");
INSERT INTO poronbv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mas Ló não se apressou. Então os anjos tomaram-no pelas mãos, bem como sua mulher e as duas filhas, e os tiraram dali à força, deixando-os fora da cidade, porque o Senhor teve misericórdia deles. ");
INSERT INTO poronbv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Quando já estavam fora da cidade, um dos anjos disse: “Fujam! Corram sem parar e sem olhar para trás e não parem no vale. Vão para as montanhas e só parem quando chegarem lá, senão arriscamse a morrer!” ");
INSERT INTO poronbv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ló, porém, lhes disse: “Assim não, meu senhor! ");
INSERT INTO poronbv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Vocês foram bondosos comigo, salvaram a minha vida e mostraram piedade. Não posso fugir para as montanhas, pois receio que esta calamidade caia sobre mim e eu morra. ");
INSERT INTO poronbv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Deixem que eu vá para aquela cidade pequena. Ela fica bem próxima, e eu poderia fugir para lá e ficar a salvo”. ");
INSERT INTO poronbv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","“Está bem”, disse o anjo. “Aceito mais esse seu pedido e não destruirei aquela cidade. ");
INSERT INTO poronbv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Mas vá depressa, porque não posso fazer nada enquanto você não chegar lá”. Desde então aquela vila foi chamada Zoar. ");
INSERT INTO poronbv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","O sol já estava aparecendo no horizonte quando Ló chegou a Zoar. ");
INSERT INTO poronbv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Então o Senhor fez chover fogo e enxofre sobre Sodoma e Gomorra. ");
INSERT INTO poronbv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ele destruiu completamente aquelas cidades, as demais cidades da planície, os habitantes e o que nascia da terra. ");
INSERT INTO poronbv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mas a mulher de Ló olhou para trás e foi transformada numa estátua de sal. ");
INSERT INTO poronbv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Naquela manhã, Abraão levantou-se de madrugada e foi até o lugar onde tinha estado diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Dali olhou para Sodoma e Gomorra e para a campina e viu fumaça subindo da terra, como de uma grande fornalha. ");
INSERT INTO poronbv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Quando Deus destruiu as cidades da planície, lembrou-se de Abraão e tirou Ló daquela região. ");
INSERT INTO poronbv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ló partiu de Zoar com suas duas filhas e passou a viver nas montanhas, porque ficou com medo de permanecer em Zoar. Ele e suas duas filhas ficaram morando numa caverna. ");
INSERT INTO poronbv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Foi quando a mais velha disse à irmã: “Em toda essa região não existe homem que possa casar conosco, conforme o costume da terra. Nosso pai já está velho e logo não poderá ter filhos. ");
INSERT INTO poronbv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Vamos dar vinho a ele e cada uma de nós se deitará com ele. Assim teremos descendentes e a nossa linhagem não desaparecerá”. ");
INSERT INTO poronbv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Naquela mesma noite, deram vinho ao pai, e a filha mais velha se deitou com ele. Ele estava tão embriagado que não percebeu quando ela se deitou nem quando se levantou. ");
INSERT INTO poronbv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","No dia seguinte, a filha mais velha contou à irmã: “Ontem à noite deitei-me com meu pai. Vamos fazer a mesma coisa hoje. Daremos vinho ao nosso pai, e depois você se deita com ele, para que preservemos a descendência de nosso pai”. ");
INSERT INTO poronbv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Naquela noite novamente deram vinho ao pai. A filha mais nova se deitou com ele. Novamente ele não percebeu quando ela se deitou nem quando se levantou. ");
INSERT INTO poronbv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Desse modo, as duas irmãs ficaram grávidas do próprio pai. ");
INSERT INTO poronbv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","A filha mais velha deu à luz um filho e chamou-o de Moabe, que é o pai dos moabitas de hoje. ");
INSERT INTO poronbv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","A filha mais nova também deu à luz um filho e chamou-o de Ben-Ami, que é o pai dos amonitas de hoje. ");
INSERT INTO poronbv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Nesse meio-tempo, Abraão mudou-se para a região do Neguebe, ao sul, e ocupou as terras entre Cades e Sur. Morou também em Gerar. ");
INSERT INTO poronbv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraão dizia que Sara, sua mulher, era a sua irmã. Por isso, Abimeleque, rei de Gerar, mandou buscar Sara e tomou-a para si. ");
INSERT INTO poronbv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Naquela mesma noite, Deus apareceu a Abimeleque em sonho e disse: “Você será castigado com a morte, porque a mulher que você tomou é casada”. ");
INSERT INTO poronbv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mas Abimeleque não tinha tocado em Sara. Por isso disse: “Senhor, matarias até uma nação inocente? ");
INSERT INTO poronbv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Não foi Abraão que me disse: ‘Ela é minha irmã?’ E ela confirmou, dizendo: ‘Ele é meu irmão?’ Em tudo isso estou sendo sincero de coração e na minha inocência fiz o que fiz”. ");
INSERT INTO poronbv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ainda em sonhos, disse Deus: “Sim, eu sei que você fez isso com sinceridade de coração. Por isso não deixei você tocar nela, e impedi você de pecar contra mim. ");
INSERT INTO poronbv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Agora, devolva Sara ao seu marido. Ele é profeta e orará em seu favor, para que você viva. Mas se você não devolver a mulher de Abraão, você e todos os seus morrerão”. ");
INSERT INTO poronbv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ainda estava escuro quando Abimeleque se levantou e reuniu todo o pessoal em serviço no palácio. Ouvindo dele o que acontecera, tiveram muito medo. ");
INSERT INTO poronbv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Depois o rei mandou chamar Abraão e disse: “Por que você fez isso conosco? O que eu fiz contra você, para me levar a tamanho pecado? Esse pecado seria uma desgraça para mim e para o meu reino. Você agiu mal”. ");
INSERT INTO poronbv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Então perguntou Abimeleque a Abraão: “O que levou você a fazer isso?” ");
INSERT INTO poronbv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraão respondeu: “Eu disse a mim mesmo: Certamente ninguém teme a Deus neste lugar, e vão me matar por causa da minha mulher. ");
INSERT INTO poronbv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Além disso, ela é de fato a minha irmã, por parte de pai, mas não por parte de mãe. E nos casamos. ");
INSERT INTO poronbv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Quando Deus me mandou sair de casa para terras estrangeiras, eu disse a Sara: ‘Em todo lugar onde formos, faça o favor de dizer que é a minha irmã’ ”. ");
INSERT INTO poronbv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Então o rei Abimeleque pegou ovelhas e bois, servos e servas e deu-os de presente a Abraão, e devolveu-lhe Sara, sua mulher. ");
INSERT INTO poronbv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","E disse Abimeleque: “A minha terra está à sua disposição. Escolha o lugar que quiser para viver”. ");
INSERT INTO poronbv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Depois disse a Sara: “Lamento a vergonha pela qual você passou. Estou dando a seu irmão mil moedas de prata, para reparar a ofensa feita a você. Esta minha atitude significa que você é declarada sem culpa diante de todos”. ");
INSERT INTO poronbv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraão orou então a Deus. E Deus curou Abimeleque, sua mulher e suas servas, para que pudessem ter filhos. ");
INSERT INTO poronbv_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Porque o Senhor tinha tornado estéreis todas as mulheres da casa de Abimeleque por causa de Sara, mulher de Abraão. ");
INSERT INTO poronbv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","O Senhor visitou Sara, como lhe dissera, e cumpriu o que havia prometido. ");
INSERT INTO poronbv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara engravidou e deu um filho a Abraão em plena velhice, no prazo indicado por Deus. ");
INSERT INTO poronbv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraão deu o nome de Isaque ao filho que Sara lhe deu. ");
INSERT INTO poronbv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abraão circuncidou Isaque no oitavo dia depois do seu nascimento, conforme a ordem recebida de Deus. ");
INSERT INTO poronbv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraão tinha cem anos de idade quando nasceu seu filho Isaque. ");
INSERT INTO poronbv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara disse na ocasião: “Deus me fez rir, e todos os que souberem disso vão rir comigo”. ");
INSERT INTO poronbv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","E acrescentou: “Quem teria dito a Abraão que Sara amamentaria um filho? E a verdade é que dei um filho a Abraão, já em plena velhice!” ");
INSERT INTO poronbv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Passou o tempo, e o menino cresceu. Quando foi desmamado, Abraão fez uma grande festa. ");
INSERT INTO poronbv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Mas Sara viu que o filho de Hagar, a egípcia, caçoava de Isaque, ");
INSERT INTO poronbv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","e pediu a Abraão: “Mande embora de casa essa escrava e o filho dela, porque o filho dessa escrava não será herdeiro junto com meu filho Isaque!” ");
INSERT INTO poronbv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraão ficou muito perturbado, porque, afinal, Ismael era seu filho. ");
INSERT INTO poronbv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mas Deus disse a Abraão: “Não se preocupe com o menino, nem com a escrava. Atenda ao que Sara diz, pois por meio de Isaque cumprirei as promessas que fiz a você. ");
INSERT INTO poronbv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mas farei uma grande nação do filho da escrava, pois ele também é seu descendente”. ");
INSERT INTO poronbv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","No dia seguinte, Abraão levantou-se bem cedo, pegou alguns pães e uma vasilha cheia de água e os colocou sobre os ombros de Hagar, e despediu-a com o menino. Ela saiu andando e ficou vagando pelo deserto de Berseba. ");
INSERT INTO poronbv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Quando acabou a água da vasilha, Hagar colocou o menino debaixo de um arbusto ");
INSERT INTO poronbv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","e foi sentar-se perto dali, à distância de um tiro de flecha, porque pensou: “Não quero assistir à morte do menino”. E ali ficou sentada, chorando amargamente. ");
INSERT INTO poronbv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mas Deus ouviu a voz do menino e, do céu, o anjo de Deus chamou Hagar e lhe disse: “O que aconteceu, Hagar? Não tenha medo! Deus ouviu a voz do menino, de onde ele está. ");
INSERT INTO poronbv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Vamos! Levante o menino e segure-o pela mão, porque vou fazer dele um grande povo”. ");
INSERT INTO poronbv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Deus abriu os olhos de Hagar, e ela viu um poço de água. Foi lá, encheu a vasilha e deu água ao menino. ");
INSERT INTO poronbv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Deus abençoou o menino. Ele cresceu e viveu no deserto, e tornou-se um flecheiro. ");
INSERT INTO poronbv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ele habitou no deserto de Parã, e sua mãe arranjou um casamento para ele com uma mulher da terra do Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Nessa época, o rei Abimeleque e Ficol, comandante do seu exército, vieram a Abraão e disseram: “Vemos claramente que Deus está com você em tudo que faz. ");
INSERT INTO poronbv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Jure então, diante de Deus, que não enganará nem a mim, nem aos meus filhos, nem aos meus descendentes. Trate a minha terra com a mesma bondade com que tratei você”. ");
INSERT INTO poronbv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraão respondeu: “Eu juro!” ");
INSERT INTO poronbv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mas Abraão apresentou uma reclamação a Abimeleque a respeito de um poço que os servos de Abimeleque lhe tinham tomado à força. ");
INSERT INTO poronbv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Respondeu-lhe Abimeleque: “Não sei quem fez isso. Você nunca me disse nada a esse respeito. Só fiquei sabendo disso hoje”. ");
INSERT INTO poronbv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Diante disso, Abraão deu ovelhas e bois a Abimeleque para selar o acordo entre eles. ");
INSERT INTO poronbv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Quando Abraão separou sete ovelhas do rebanho, ");
INSERT INTO poronbv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleque lhe perguntou: “Por que você separou estas sete ovelhas?” ");
INSERT INTO poronbv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraão respondeu: “Dou estas sete ovelhas a você, como testemunho de que eu cavei este poço”. ");
INSERT INTO poronbv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Por isso aquele lugar foi chamado de Berseba, porque ali os dois fizeram um juramento. ");
INSERT INTO poronbv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Depois que foi firmado o acordo em Berseba, Abimeleque e Ficol, comandante do seu exército, voltaram para a terra dos filisteus. ");
INSERT INTO poronbv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","E Abraão plantou uma tamargueira em Berseba e ali orou ao Senhor, invocando a presença do Deus Eterno. ");
INSERT INTO poronbv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraão morou na terra dos filisteus por muito tempo. ");
INSERT INTO poronbv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Depois de algum tempo, Deus pôs Abraão à prova. “Abraão!”, chamou Deus. “Aqui estou!”, respondeu Abraão. ");
INSERT INTO poronbv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Então Deus disse: “Tome o seu filho, seu único filho, Isaque, a quem você tanto ama, e vá para a terra de Moriá. Lá, ofereça o seu filho Isaque em sacrifício, como oferta queimada, num dos montes que eu lhe mostrar”. ");
INSERT INTO poronbv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Na madrugada seguinte, levantou-se Abraão e preparou o seu jumento. Levou consigo dois de seus servos e Isaque, seu filho. Rachou lenha para o sacrifício e foi com eles para o lugar que Deus lhe tinha indicado. ");
INSERT INTO poronbv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Depois de três dias de caminhada, Abraão viu o lugar de longe. ");
INSERT INTO poronbv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Então disse a seus servos: “Esperem aqui com o jumento. Eu e o rapaz vamos até lá, e, depois de adorarmos, voltaremos”. ");
INSERT INTO poronbv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraão colocou a lenha do sacrifício nos ombros do seu filho Isaque, e ele levou uma tocha de fogo, e a faca. E assim os dois caminhavam juntos. ");
INSERT INTO poronbv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaque disse a Abraão, seu pai: “Meu pai!” “Que é, meu filho?”, respondeu Abraão. Perguntou-lhe Isaque: “Temos lenha e fogo, mas onde está o cordeiro para o sacrifício?” ");
INSERT INTO poronbv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Respondeu Abraão: “Deus vai prover o cordeiro para o sacrifício, meu filho”. E continuaram andando juntos. ");
INSERT INTO poronbv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Quando chegaram ao lugar que Deus tinha indicado, Abraão construiu um altar, arrumou a lenha sobre ele, amarrou seu filho Isaque e o colocou no altar, em cima da lenha. ");
INSERT INTO poronbv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Depois pegou a faca para sacrificar seu filho. ");
INSERT INTO poronbv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Nesse momento o Anjo do Senhor gritou do céu: “Abraão! Abraão!” “Aqui estou!”, respondeu ele. ");
INSERT INTO poronbv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Então o Anjo disse: “Não toque no rapaz, não lhe faça nada. Agora sei que você teme a Deus, porque não me negou nem mesmo o seu amado filho, seu único filho!” ");
INSERT INTO poronbv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Nisso Abraão viu um carneiro preso pelos chifres num arbusto. Tomou Abraão o carneiro e o ofereceu como oferta queimada ao Senhor, em lugar de Isaque. ");
INSERT INTO poronbv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraão chamou aquele lugar de “O Senhor Proverá”. Por esse nome é conhecido até hoje. ");
INSERT INTO poronbv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Então, pela segunda vez, o Anjo do Senhor gritou do céu a Abraão ");
INSERT INTO poronbv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","e disse: “Juro pelo meu próprio nome”, diz o Senhor, “como você me obedeceu e não me negou o seu único filho, ");
INSERT INTO poronbv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","certamente abençoarei você e farei seus descendentes tão numerosos como as estrelas do céu e como a areia na praia do mar. Os seus descendentes conquistarão as cidades dos seus inimigos, ");
INSERT INTO poronbv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","e por meio dos seus descendentes todas as nações da terra serão abençoadas, porque você me obedeceu”. ");
INSERT INTO poronbv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Assim, voltou Abraão aos seus servos, e, juntos, partiram para Berseba, onde passaram a morar. ");
INSERT INTO poronbv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Depois desses acontecimentos, chegou a informação de que Milca, mulher de Naor, irmão de Abraão, tinha gerado estes oito filhos: ");
INSERT INTO poronbv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz, o mais velho, Buz, seu irmão, Quemuel, pai de Arã, ");
INSERT INTO poronbv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Quésede, Hazo, Pildas, Jidlafe e Betuel, ");
INSERT INTO poronbv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","pai de Rebeca. Estes foram os oito filhos que Milca deu a Naor, irmão de Abraão. ");
INSERT INTO poronbv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Reumá, a concubina de Naor, lhe deu os seguintes filhos: Tebá, Gaã, Taás e Maaca. ");
INSERT INTO poronbv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Quando Sara estava com 127 anos de idade, ");
INSERT INTO poronbv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","morreu em Quiriate-Arba, que é Hebrom, na terra de Canaã. E Abraão lamentou a morte de Sara e chorou por ela. ");
INSERT INTO poronbv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Depois Abraão levantou-se, deixou o lugar onde estava o corpo de sua mulher e foi falar com os heteus: ");
INSERT INTO poronbv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Sou um estrangeiro que moro na mesma terra em que vocês moram. Vendam-me, por favor, um pedaço de terra para que eu possa enterrar a minha mulher”. ");
INSERT INTO poronbv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Responderam os heteus a Abraão: ");
INSERT INTO poronbv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ouça-nos: O senhor é um príncipe de Deus entre nós. Enterre a sua mulher numa das nossas melhores sepulturas; nenhum de nós negará a sua sepultura para que o senhor enterre a sua mulher”. ");
INSERT INTO poronbv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraão levantou-se e curvou-se perante os heteus, povo daquela terra, ");
INSERT INTO poronbv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","e falou a eles: “Como estão sendo tão amáveis, permitindo que eu sepulte a minha esposa, peço que intercedam por mim perante Efrom, filho de Zoar. ");
INSERT INTO poronbv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Peçam a ele que me venda por um preço justo a caverna de Macpela, que se encontra na divisa das suas terras. Ela servirá como sepultura para minha família”. ");
INSERT INTO poronbv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efrom, o heteu, estava sentado no meio do seu povo e respondeu a Abraão na presença de todos os heteus, que tinham vindo à porta de entrada da cidade: ");
INSERT INTO poronbv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“De modo algum, meu senhor. Ouça-me: Eu dou ao senhor o campo e a caverna que nele está. Eu a dou na presença do meu povo. Sepulte a sua mulher”. ");
INSERT INTO poronbv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraão inclinou-se de novo diante do povo daquela terra ");
INSERT INTO poronbv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","e disse a Efrom, na presença dos heteus reunidos: “Se você concorda, por favor, ouça-me: ‘Eu desejo pagar o preço do campo. Depois de pagar, farei o enterro da minha mulher’ ”. ");
INSERT INTO poronbv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Respondeu Efrom a Abraão: ");
INSERT INTO poronbv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ouça-me, meu senhor; o terreno vale 400 moedas de prata, mas o que significa isso entre mim e você? Vá e sepulte a sua mulher”. ");
INSERT INTO poronbv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Tendo ouvido isso de Efrom, Abraão concordou com o preço e pesou 400 moedas de prata diante dos heteus, moeda corrente entre os mercadores. ");
INSERT INTO poronbv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Assim, o campo de Efrom em Macpela, perto de Manre, incluindo a caverna e o arvoredo dentro das divisas do campo, ");
INSERT INTO poronbv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","foram transferidos a Abraão como sua propriedade. Esse acordo foi realizado diante de todos os heteus que tinham vindo à porta de entrada da cidade. ");
INSERT INTO poronbv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Assim, Abraão sepultou a sua mulher Sara na caverna do campo de Macpela, perto de Manre, lugar também conhecido por Hebrom, que fica na terra de Canaã. ");
INSERT INTO poronbv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Assim, o terreno e a caverna foram cedidos pelos heteus a Abraão para serem usados como lugar de sepultamento. ");
INSERT INTO poronbv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraão já era um homem muito idoso. E o Senhor o tinha abençoado em tudo. ");
INSERT INTO poronbv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Um dia Abraão falou ao servo mais antigo de sua casa, que tomava conta de tudo: “Coloque a mão debaixo da minha coxa ");
INSERT INTO poronbv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","e jure pelo Senhor, o Deus do céu e da terra, que não deixará o meu filho casar com uma moça dos cananeus, entre os quais vivemos. ");
INSERT INTO poronbv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Prometa que irá à minha terra natal, escolher uma mulher para Isaque entre os meus parentes de lá”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","“Mas e se a moça que eu escolher não quiser vir comigo para esta terra?” perguntou-lhe o servo. “Devo então levar o seu filho de volta à terra de onde o senhor veio?” ");
INSERT INTO poronbv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","“Cuidado!”, disse Abraão. “Não permita que meu filho volte para lá”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","“O Senhor, o Deus do céu, que me mandou sair da casa do meu pai e da minha terra natal, e jurou dar esta terra aos meus descendentes, enviará o seu anjo adiante de você. Ele providenciará que você encontre ali uma jovem para ser a mulher do meu filho. ");
INSERT INTO poronbv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Se a mulher não quiser vir, você estará livre do seu juramento. Mas não leve o meu filho para lá”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Então o servo pôs a mão debaixo da coxa de Abraão, seu senhor, e jurou cumprir as ordens de Abraão. ");
INSERT INTO poronbv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","O servo escolheu dez camelos de Abraão, levando consigo do que o seu senhor tinha de melhor e viajou para a Mesopotâmia, para a cidade de Naor. ");
INSERT INTO poronbv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ao cair da tarde, quando as moças saem para tirar água, fez os camelos se ajoelharem próximo de um poço de água. ");
INSERT INTO poronbv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","E orou em silêncio: “Ó Senhor, Deus do meu senhor Abraão, dá-me bom êxito neste dia e mostre bondade para com o meu senhor Abraão! ");
INSERT INTO poronbv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","O Senhor vê que estou perto desta fonte. As moças desta cidade estão vindo tirar água. ");
INSERT INTO poronbv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Vou pedir a uma delas: ‘Por favor, incline o seu cântaro para que eu beba água’, e, se ela responder: ‘Beba. Também darei água aos seus camelos’, que seja essa a moça que o Senhor escolheu para o seu servo Isaque. Assim saberei que o Senhor foi bondoso para com o meu senhor”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Antes de terminar a oração, chegou Rebeca, filha de Betuel, filho de Milca, mulher de Naor, irmão de Abraão, levando um cântaro no ombro. ");
INSERT INTO poronbv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","A moça era muito bonita e virgem, isto é, nenhum homem tinha tido relações com ela. Ela desceu à fonte, encheu o cântaro de água e subiu. ");
INSERT INTO poronbv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","O servo de Abraão foi ao encontro dela e disse: “Dê-me um pouco da água do seu cântaro para beber”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“Pois não, senhor”, disse ela, e tirou imediatamente o cântaro do ombro e lhe deu de beber. ");
INSERT INTO poronbv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Depois de lhe dar de beber, disse: “Vou tirar água para os seus camelos também, até ficarem satisfeitos”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ela prontamente despejou a água do cântaro no bebedouro e correu de volta ao poço para tirar mais água. E repetiu isso até que todos os camelos tivessem saciado sua sede. ");
INSERT INTO poronbv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Enquanto isso o homem observava em silêncio, atentamente, para saber se o Senhor já tinha coroado de êxito a sua missão ou não. ");
INSERT INTO poronbv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Quando os camelos acabaram de beber, o homem lhe deu uma argola de ouro de seis gramas e duas pulseiras de ouro pesando cerca de cento e vinte gramas, ");
INSERT INTO poronbv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","e perguntou: “Quem é o seu pai? Será que há lugar na casa de seu pai para receber a mim e aos que me acompanham?” ");
INSERT INTO poronbv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ela respondeu: “Sou filha de Betuel, filho que Milca deu a Naor”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","E acrescentou: “Temos palha e muito pasto para os animais, e lugar para os hóspedes passarem a noite”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Então o homem se curvou e adorou ao Senhor, ");
INSERT INTO poronbv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","dizendo: “Bendito seja o Senhor, o Deus do meu senhor Abraão, pois não negou a sua bondade e a sua fidelidade ao meu senhor. Quanto a mim, o Senhor guiou-me à casa dos parentes do meu senhor”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","A jovem correu para casa e contou à família da sua mãe tudo o que tinha acontecido. ");
INSERT INTO poronbv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeca tinha um irmão chamado Labão. Ele saiu apressado à fonte onde estava o homem, ");
INSERT INTO poronbv_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","pois tinha visto a argola e as pulseiras nos braços de sua irmã, e tinha ouvido de Rebeca o que o homem lhe tinha contado. Labão foi encontrá-lo em pé, junto à fonte, ao lado dos camelos. ");
INSERT INTO poronbv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Disse Labão: “Venha comigo, abençoado do Senhor! Por que ficar aí fora? Temos alojamento para você e seus homens, e um lugar para os camelos”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Então o homem foi com ele para casa. Lá descarregaram os camelos e lhes deram forragem e pasto, e água ao homem e aos ajudantes dele, para lavarem os pés. ");
INSERT INTO poronbv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Quando serviram a comida, o homem disse: “Não posso comer, enquanto não disser o propósito da minha vinda”. Disse Labão: “Está certo. Conte o motivo da sua viagem”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Então ele disse: “Sou servo de Abraão. ");
INSERT INTO poronbv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","O Senhor tem abençoado muito ao meu senhor, e ele se tornou um grande homem; Deus deu a ele ovelhas e bois, prata e ouro, servos e servas, camelos e jumentos. ");
INSERT INTO poronbv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, a mulher do meu senhor, era muito idosa quando deu um filho a ele, que é o herdeiro de tudo que ele possui. ");
INSERT INTO poronbv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","E meu senhor me fez jurar, dizendo: ‘Jure pelo Senhor, o Deus do céu e da terra, que não deixará o meu filho casar com uma moça dos cananeus, entre os quais vivemos, ");
INSERT INTO poronbv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","mas você irá à casa de meu pai, e da minha família, procurar uma esposa para o meu filho’. ");
INSERT INTO poronbv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Então perguntei ao meu senhor: ‘E se a moça não quiser vir comigo?’ ");
INSERT INTO poronbv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Ele respondeu: ‘O Senhor, em cuja presença tenho andado, enviará um anjo com você e você terá sucesso na sua missão, para que você encontre uma esposa para Isaque entre os meus parentes, da família do meu pai. ");
INSERT INTO poronbv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Quando chegar até a minha família, você estará livre do juramento se eles se negarem a entregá-la a você’. ");
INSERT INTO poronbv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Hoje, quando cheguei à fonte, orei ao Senhor: ‘Ó Senhor Deus do meu senhor Abraão, dê-me bom êxito nesta missão. ");
INSERT INTO poronbv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Aqui estou perto desta fonte; se uma jovem vier tirar água e eu lhe disser: “por favor, dê-me um pouco da água do seu cântaro”, ");
INSERT INTO poronbv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","e, se ela me responder: “Beba. Também darei água aos seus camelos”, seja essa a moça que o Senhor escolheu para o filho do meu senhor’. ");
INSERT INTO poronbv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Enquanto eu estava orando no meu íntimo, chegou Rebeca com seu cântaro no ombro. Ela desceu à fonte e tirou água, e eu lhe disse: ‘Por favor, dê-me um pouco de água para beber’. ");
INSERT INTO poronbv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Ela imediatamente tirou o cântaro do seu ombro e disse: ‘Beba. Também darei água aos seus camelos’. Eu bebi, e ela deu água de beber aos meus camelos. ");
INSERT INTO poronbv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Então perguntei a ela: ‘Quem é o seu pai?’ “Ela me respondeu: ‘Sou filha de Betuel, filho de Naor e de Milca’. “Então coloquei a argola em seu nariz e as pulseiras em seus braços, ");
INSERT INTO poronbv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","e me inclinei; adorei e bendisse ao Senhor, o Deus do meu senhor Abraão, que me guiou na direção certa para levar para o filho do meu senhor uma parenta do seu irmão. ");
INSERT INTO poronbv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Agora, digam-me se mostrarão fidelidade e bondade ao meu senhor; e, se não, digam-me também, para que eu saiba o que fazer e para onde ir”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Então, responderam Labão e Betuel: “Sem dúvida foi o Senhor que conduziu você até aqui. Sendo assim, nada podemos dizer, nem a favor nem contra. ");
INSERT INTO poronbv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Aqui está Rebeca; pode levá-la. Que ela se torne a esposa do filho do seu senhor, conforme disse o Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ouvindo essas palavras, o servo de Abraão prostrou-se no chão diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Depois deu joias de ouro e de prata e vestidos a Rebeca; deu também ricos presentes ao seu irmão e à sua mãe. ");
INSERT INTO poronbv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Então ele e os seus ajudantes comeram e beberam, e passaram a noite ali. Ao se levantarem bem cedo na manhã seguinte, o servo de Abraão disse: “Deixem-me voltar ao meu senhor”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mas o irmão e a mãe da moça disseram: “Queremos que ela fique mais uns dez dias conosco; depois ela irá com você”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Mas o homem insistiu: “Não me detenham, por favor! O Senhor permitiu que eu tivesse sucesso na minha missão. Deixem que eu volte ao meu senhor”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Então lhe disseram: “Vamos chamar a moça e ver o que ela tem a dizer”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Chamaram Rebeca e perguntaram a ela: “Você deseja ir com este homem?” Ela respondeu: “Sim, eu vou com ele”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Despediram-se, então, de sua irmã Rebeca, de sua ama, do servo de Abraão e dos seus ajudantes. ");
INSERT INTO poronbv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Abençoaram a Rebeca, dizendo: “Que você, nossa irmã, seja a mãe de milhões! E que os seus descendentes conquistem as cidades dos seus inimigos”. ");
INSERT INTO poronbv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Então Rebeca e suas servas se aprontaram, montaram nos camelos e foram embora com o servo de Abraão. ");
INSERT INTO poronbv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaque estava voltando pelo caminho de Beer-Laai-Roi, pois morava no Neguebe. ");
INSERT INTO poronbv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ele tinha saído para meditar no campo ao cair da tarde, quando viu que se aproximavam camelos. ");
INSERT INTO poronbv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeca também viu Isaque, desceu do camelo ");
INSERT INTO poronbv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","e perguntou ao servo: “Quem é aquele homem que vem pelo campo ao nosso encontro?” “É o meu senhor”, respondeu o servo. Então ela tomou o véu e cobriu-se. ");
INSERT INTO poronbv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Depois o servo contou a Isaque tudo o que tinha feito. ");
INSERT INTO poronbv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaque levou a moça para a tenda de sua mãe Sara, e Rebeca tornou-se a sua mulher, e ele a amou; assim Isaque foi consolado após a morte de sua mãe. ");
INSERT INTO poronbv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraão casou-se com outra mulher, chamada Quetura. ");
INSERT INTO poronbv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ela deu à luz os seguintes filhos: Zinrã, Jocsã, Medã, Midiã, Isbaque e Suá. ");
INSERT INTO poronbv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Os dois filhos de Jocsã foram Sabá e Dedã. Os filhos de Dedã foram Assurim, Letusim e Leumim. ");
INSERT INTO poronbv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Os filhos de Midiã foram Efá, Éfer, Enoque, Abida e Elda. ");
INSERT INTO poronbv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraão deu tudo o que tinha para Isaque. ");
INSERT INTO poronbv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Mas deu presentes aos filhos que teve com suas concubinas e, ainda em vida, separou-os de Isaque, enviando-os para a terra do oriente. ");
INSERT INTO poronbv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraão viveu 175 anos. ");
INSERT INTO poronbv_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Morreu depois de ter tido uma velhice avançada e feliz, e foi reunido aos seus antepassados. ");
INSERT INTO poronbv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Seus filhos, Isaque e Ismael, enterraram o pai na caverna de Macpela, perto de Manre, no campo de Efrom, filho de Zoar, o heteu, ");
INSERT INTO poronbv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","campo que Abraão tinha comprado dos heteus. Foi ali que Abraão e Sara, sua mulher, foram enterrados. ");
INSERT INTO poronbv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Depois que Abraão morreu, Deus abençoou Isaque, seu filho; Isaque morava agora próximo a Beer-Laai-Roi. ");
INSERT INTO poronbv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","São estes os descendentes de Ismael, filho de Abraão com a egípcia Hagar, serva de Sara. ");
INSERT INTO poronbv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","A relação dos nomes dos filhos de Ismael está por ordem de nascimento: Nebaiote, o filho mais velho de Ismael, Quedar, Adbeel, Mibsão; ");
INSERT INTO poronbv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Dumá, Massá, ");
INSERT INTO poronbv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadade, Temá, Jetur, Nafis e Quedemá. ");
INSERT INTO poronbv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Estes doze filhos de Ismael vieram a ser os fundadores das doze tribos que receberam os seus nomes. ");
INSERT INTO poronbv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael viveu 137 anos de idade. Morreu e foi reunido aos seus antepassados. ");
INSERT INTO poronbv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Seus descendentes se espalharam por toda a região desde Havilá até Sur, que fica próximo à fronteira com o Egito, na direção de quem vai para a Assíria. Eles viviam separados dos outros descendentes de Abraão. ");
INSERT INTO poronbv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","São estas as gerações de Isaque, filho de Abraão: Abraão gerou Isaque. ");
INSERT INTO poronbv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaque tinha quarenta anos quando se casou com Rebeca. Ela era filha de Betuel, o arameu de Padã-Arã, e irmã do arameu Labão. ");
INSERT INTO poronbv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaque orou ao Senhor em favor de sua mulher, pois ela não podia ter filhos. O Senhor atendeu às orações de Isaque, e sua mulher Rebeca ficou grávida. ");
INSERT INTO poronbv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Os filhos lutavam no ventre dela, pelo que disse: “Por que isso está acontecendo comigo?” E foi consultar o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","O Senhor respondeu: “Os filhos que estão no seu ventre formarão duas nações rivais. Uma será mais forte do que a outra, e o mais velho servirá ao mais novo”. ");
INSERT INTO poronbv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","E quando se cumpriu o tempo, ela deu à luz gêmeos. ");
INSERT INTO poronbv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","O primeiro a sair veio todo coberto de pelos e cabelos ruivos; por isso deram a ele o nome de Esaú. ");
INSERT INTO poronbv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Em seguida veio o irmão, segurando o calcanhar de Esaú. Por isso deram a ele o nome de Jacó. Isaque tinha sessenta anos de idade quando Rebeca deu à luz. ");
INSERT INTO poronbv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Os meninos cresceram. Esaú tornou-se um caçador habilidoso, e vivia pelos campos. Jacó, no entanto, era do tipo tranquilo e ficava nas tendas. ");
INSERT INTO poronbv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","O filho favorito de Isaque era Esaú, por causa das saborosas caças; o filho favorito de Rebeca era Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Um dia, Jacó estava preparando um ensopado de lentilhas, quando Esaú chegou em casa. Ele estava exausto ");
INSERT INTO poronbv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","e pediu a Jacó: “Por favor, dê-me um pouco desse ensopado vermelho. Estou faminto!” Por isso Esaú também foi chamado de Edom. ");
INSERT INTO poronbv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacó respondeu: “Venda-me primeiro o seu direito de filho mais velho”. ");
INSERT INTO poronbv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esaú disse: “Se estou morrendo de fome, que me adianta esses direitos?” ");
INSERT INTO poronbv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Então Jacó disse: “Jure primeiro”. Esaú fez um juramento, vendendo os seus direitos de filho mais velho a Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Então Jacó deu a Esaú pão e o ensopado de lentilhas. Ele comeu, bebeu e foi embora. Assim Esaú desprezou o seu direito de filho mais velho. ");
INSERT INTO poronbv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nessa época veio fome sobre aquela região, o mesmo que havia ocorrido durante a vida de Abraão. Por causa disso, Isaque foi para Gerar, encontrar-se com Abimeleque, rei dos filisteus. ");
INSERT INTO poronbv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","O Senhor apareceu a Isaque e disse: “Não desça ao Egito. Fique na terra que eu lhe indicar. ");
INSERT INTO poronbv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Habite nela, e eu estarei com você e o abençoarei. Darei a você e a seus descendentes todas estas terras e confirmarei o juramento que fiz a seu pai, Abraão. ");
INSERT INTO poronbv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Farei com que os seus descendentes sejam numerosos como as estrelas do céu e lhes darei todas estas terras; por meio dos seus descendentes todas as nações da terra serão abençoadas. ");
INSERT INTO poronbv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Farei isso porque Abraão obedeceu à minha palavra e guardou os meus mandamentos, os meus decretos e as minhas leis”. ");
INSERT INTO poronbv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Assim, Isaque ficou em Gerar. ");
INSERT INTO poronbv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Quando os homens daquele lugar perguntaram a respeito de sua mulher, ele disse: “Ela é minha irmã”. Ele teve medo de dizer que era sua mulher, pois pensava: “Os homens daqui podem matar-me por causa de Rebeca, porque é muito bonita”. ");
INSERT INTO poronbv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaque já morava ali havia muito tempo, quando Abimeleque, rei dos filisteus, viu da janela que Isaque acariciava Rebeca, sua mulher. ");
INSERT INTO poronbv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Então Abimeleque mandou chamar Isaque e disse: “É claro que ela é sua esposa! Por que você disse que ela era sua irmã?” Isaque respondeu: “Porque fiquei com medo. Achei que alguém poderia me matar para ficar com ela”. ");
INSERT INTO poronbv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Disse Abimeleque: “Como você pôde fazer uma coisa dessas conosco? Um de nós poderia facilmente ter-se deitado com sua mulher e você teria trazido culpa sobre nós”. ");
INSERT INTO poronbv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","E o rei deu a seguinte ordem ao povo: “Qualquer um que tocar neste homem ou em sua mulher certamente morrerá!” ");
INSERT INTO poronbv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaque semeou naquela terra e, no mesmo ano, colheu a cem por um, porque o Senhor o abençoava. ");
INSERT INTO poronbv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ele enriqueceu, prosperou, até ficar muito rico. ");
INSERT INTO poronbv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Possuía ovelhas e bois e um grande número de servos, a tal ponto que os filisteus o invejavam. ");
INSERT INTO poronbv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Por isso, tapavam todos os poços que os servos de Abraão, seu pai, tinham cavado nos seus dias, enchendo-os de terra. ");
INSERT INTO poronbv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Então Abimeleque disse a Isaque: “Vá para outro lugar, pois você ficou mais rico e mais poderoso do que nós”. ");
INSERT INTO poronbv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Então, Isaque saiu de lá, acampou-se no vale de Gerar, e ficou morando ali. ");
INSERT INTO poronbv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ele voltou a abrir os poços cavados no tempo do seu pai Abraão. Os filisteus tinham enchido de terra aqueles poços, depois da morte de Abraão. E Isaque deu aos poços os mesmos nomes que seu pai tinha dado. ");
INSERT INTO poronbv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Os servos de Isaque cavaram um novo poço no vale e viram brotar ali uma fonte de águas subterrâneas. ");
INSERT INTO poronbv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Mas os pastores de Gerar brigaram com os pastores de Isaque, dizendo: “Esta água é nossa!” Por isso, Isaque chamou o poço de Eseque, porque discutiram por causa dele. ");
INSERT INTO poronbv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Então os homens de Isaque abriram outro poço, e novamente houve briga por causa dele. Por isso, recebeu o nome de Sitna. ");
INSERT INTO poronbv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Saindo dali, Isaque mandou cavar outro poço, e como ninguém brigou por causa dele, chamou-o de Reobote e disse: “Agora o Senhor nos deu um lugar e prosperaremos na terra”. ");
INSERT INTO poronbv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Dali Isaque foi até Berseba. ");
INSERT INTO poronbv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Na mesma noite, o Senhor lhe apareceu e disse: “Eu sou o Deus do seu pai Abraão. Não tenha medo, porque estou com você; eu o abençoarei e multiplicarei os seus descendentes, por amor ao meu servo Abraão”. ");
INSERT INTO poronbv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaque construiu um altar e ofereceu culto ao Senhor. Ele armou ali as suas tendas, e os seus servos cavaram outro poço. ");
INSERT INTO poronbv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Certo dia, Isaque recebeu visita de Gerar. Eram o rei Abimeleque, o conselheiro real Auzate e Ficol, o comandante do seu exército. ");
INSERT INTO poronbv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaque perguntou: “Por que vieram a mim, visto que foram hostis comigo e me mandaram embora?” ");
INSERT INTO poronbv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Eles responderam: “Vimos claramente que o Senhor está com você; por isso dissemos: ");
INSERT INTO poronbv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","‘Façamos um juramento entre nós e façamos uma aliança. Você não nos prejudicará, assim como nós não prejudicaremos você. Na verdade, nós tratamos bem você e o despedimos em paz. Vemos que o Senhor tem abençoado você’ ”. ");
INSERT INTO poronbv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Então Isaque ofereceu um banquete para eles, e comeram e beberam. ");
INSERT INTO poronbv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","De manhã bem cedo, os dois fizeram um juramento. Isaque os despediu, e eles partiram em paz. ");
INSERT INTO poronbv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Naquele mesmo dia, os servos de Isaque vieram contar-lhe a respeito de um poço que tinham cavado, e disseram: “Achamos água!” ");
INSERT INTO poronbv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isaque deu ao poço o nome de Seba e, por isso, aquela cidade é conhecida como Berseba. ");
INSERT INTO poronbv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaú tinha quarenta anos quando casou com Judite, filha do heteu Beeri. Casou também com Basemate, filha do heteu Elom. ");
INSERT INTO poronbv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ambas amarguraram a vida de Isaque e de Rebeca. ");
INSERT INTO poronbv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaque envelheceu, e seus olhos ficaram tão fracos que quase não podia enxergar. Certo dia, chamou Esaú, o seu filho mais velho, e lhe disse: “Meu filho!” Esaú respondeu: “Sim pai, aqui estou”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Disse-lhe o pai: “Já estou velho e não sei quando vou morrer. ");
INSERT INTO poronbv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Agora, pois, pegue o seu arco e as suas flechas e vá ao campo caçar algo para mim ");
INSERT INTO poronbv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","e prepare-me uma comida do meu gosto, bem saborosa, e traga-a para que eu coma e o abençoe antes que eu morra”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeca ouviu a conversa de Isaque com seu filho Esaú. Quando Esaú foi ao campo para buscar a caça e trazê-la, ");
INSERT INTO poronbv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeca disse ao seu filho Jacó: “Ouvi o seu pai falar com o seu irmão Esaú, dizendo: ");
INSERT INTO poronbv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Traga-me uma caça e prepare-me uma comida saborosa, para que eu a coma e o abençoe diante do Senhor antes de morrer’. ");
INSERT INTO poronbv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Agora, pois, meu filho, obedeça às palavras da sua mãe: ");
INSERT INTO poronbv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Vá ao rebanho e traga-me dois dos melhores cabritos. Vou fazer uma comida saborosa para o seu pai, como ele gosta. ");
INSERT INTO poronbv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Você a levará ao seu pai, para que ele coma e o abençoe, antes de morrer”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacó disse a sua mãe Rebeca: “Meu irmão Esaú é peludo, e eu tenho a pele lisa. ");
INSERT INTO poronbv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Pode ser que meu pai me toque e perceba que eu o estou tentando enganar e vou ser considerado um tolo. Assim, em vez de bênção, trarei maldição sobre mim”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","A mãe lhe respondeu: “Que venha sobre mim essa maldição, meu filho! Apenas faça o que eu digo a você. Vá e traga-me os cabritos”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jacó foi e trouxe os cabritos para a sua mãe, que preparou uma comida saborosa, ao gosto do seu pai. ");
INSERT INTO poronbv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Em seguida, pegou a melhor roupa do seu filho mais velho Esaú, que tinha em casa, e vestiu seu filho mais novo, Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Com a pele dos cabritos cobriu as mãos e a parte lisa do pescoço. ");
INSERT INTO poronbv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Depois entregou a seu filho Jacó a comida saborosa e o pão que ela tinha preparado. ");
INSERT INTO poronbv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jacó foi ao encontro do seu pai e disse: “Pai!” Isaque respondeu: “Sim, filho. Quem é você?” ");
INSERT INTO poronbv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacó respondeu a seu pai: “Sou seu filho mais velho Esaú. Fiz o que o senhor mandou. Venha sentar-se e comer da minha caça para me abençoar”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaque perguntou a seu filho: “Como foi que você achou a caça tão depressa, meu filho?” Ele respondeu: “É que o Senhor, o seu Deus, colocou a caça no meu caminho”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Então Isaque disse a Jacó: “Chegue mais perto, meu filho, para que o possa tocar, e ver se você é mesmo o meu filho Esaú”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacó aproximou-se de seu pai Isaque, que o tocou e disse: “A voz é de Jacó, mas as mãos são de Esaú”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","E não o reconheceu, porque as mãos, de fato, estavam peludas como as do seu irmão Esaú; e o abençoou. ");
INSERT INTO poronbv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","E Isaque perguntou-lhe novamente: “Você é mesmo o meu filho Esaú?” Jacó respondeu: “Sou sim!” ");
INSERT INTO poronbv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Então Isaque disse: “Então traga a caça aqui para que eu coma e depois o abençoe”. Jacó trouxe a comida a seu pai, e ele comeu. Também lhe trouxe o vinho, e ele bebeu. ");
INSERT INTO poronbv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Depois seu pai Isaque disse: “Aproxime-se, meu filho, e beije-me”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jacó se aproximou e beijou seu pai. Isaque sentiu o cheiro da roupa dele e o abençoou, dizendo: “O cheiro do meu filho é como o cheiro do campo, que o Senhor abençoou. ");
INSERT INTO poronbv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Que Deus dê a você o orvalho do céu, e que a terra lhe dê fartura de trigo e vinho. ");
INSERT INTO poronbv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Que os povos o sirvam, e que você seja respeitado pelos povos. Seja senhor dos seus irmãos, e que os filhos da sua mãe se inclinem diante de você. Seja maldito aquele que amaldiçoar você, e abençoado aquele que abençoar você”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Assim que Isaque terminou de abençoar a Jacó e depois que ele saiu da presença do seu pai Isaque, chegou seu irmão Esaú, da sua caçada. ");
INSERT INTO poronbv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ele também preparou o prato preferido do pai e levou a comida para ele, dizendo: “Pai, venha sentar-se e comer a caça que preparei, para que o senhor me abençoe”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Seu pai Isaque perguntou-lhe: “Quem é você?” Esaú respondeu: “Sou Esaú, o seu filho mais velho”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isso foi um choque para Isaque. Ele ficou muito abalado e disse: “Então quem foi aquele que me trouxe a caça? Acabei de comer de tudo, antes que você viesse, e abençoei a ele, e essa bênção ninguém pode tirar”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ouvindo essas palavras de seu pai, Esaú protestou em alta voz e com profunda amargura lhe disse: “Ó pai, abençoe a mim também!” ");
INSERT INTO poronbv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","O pai respondeu-lhe: “Seu irmão veio com astúcia e levou a bênção que estava designada para você”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esaú disse: “Não me admira que ele se chame Jacó. Ele já me enganou duas vezes. Ele tirou o meu direito de filho mais velho, e agora tira a minha bênção!” Então perguntou: “O senhor não tem também uma bênção para mim?” ");
INSERT INTO poronbv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaque respondeu a Esaú: “Fiz dele o seu senhor, e todos os seus parentes serão os servos dele; a ele garanti fartura de cereais e vinho. O que eu posso fazer por você, meu filho?” ");
INSERT INTO poronbv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaú disse a seu pai: “Será que o senhor não tem uma única bênção para mim, meu pai? Ó meu pai, abençoe também a mim”. E Esaú chorou amargamente. ");
INSERT INTO poronbv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Então seu pai Isaque respondeu-lhe: “Longe dos lugares das terras férteis será a sua morada, sem o orvalho que cai do alto. ");
INSERT INTO poronbv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Você ganhará a vida com a sua espada, e servirá a seu irmão. Mas chegará o dia em que você conseguirá escapar desse jugo e ficar livre”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esaú passou a odiar a Jacó por causa da bênção que seu pai lhe tinha dado. Esaú disse a si mesmo: “Os dias de luto do meu pai se aproximam. Depois matarei o meu irmão Jacó”. ");
INSERT INTO poronbv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","De algum modo Rebeca ficou sabendo das palavras do seu filho mais velho Esaú. Ela, então, mandou chamar o seu filho mais novo, e lhe disse: “O seu irmão Esaú acha que só poderá descansar depois de matar você. ");
INSERT INTO poronbv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Agora, meu filho, ouça o que vou lhe dizer: Fuja para Harã e fique na casa do seu tio Labão. ");
INSERT INTO poronbv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Fique com ele por algum tempo, até que passe a fúria do seu irmão ");
INSERT INTO poronbv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","e termine o seu rancor contra você. Com o tempo Esaú esquecerá o que você fez a ele. Depois eu mandarei buscar você. Por que eu perderia os meus dois filhos no mesmo dia?” ");
INSERT INTO poronbv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Disse, pois, Rebeca a Isaque: “Estou aborrecida por causa das duas noras que os heteus nos deram. Se Jacó escolher uma esposa entre as mulheres daqui, como estas, de que me adianta continuar vivendo?” ");
INSERT INTO poronbv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaque mandou chamar Jacó e, dando-lhe a sua bênção, disse: “Não se case com uma mulher do povo cananeu. ");
INSERT INTO poronbv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Em vez disso, vá para a casa do seu avô Betuel, pai de sua mãe, em Padã-Arã, e escolha uma esposa para você das filhas de Labão, irmão da sua mãe. ");
INSERT INTO poronbv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Que o Deus Todo-poderoso abençoe você, lhe dê muitos filhos e multiplique os seus descendentes e que formem muitos povos. ");
INSERT INTO poronbv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Que ele dê a você e aos seus descendentes as bênçãos que prometeu a Abraão. Assim você e os seus descendentes serão os donos desta terra, na qual vivemos como estrangeiros, a terra dada por Deus a Abraão”. ");
INSERT INTO poronbv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Assim Jacó se despediu de Isaque e foi para Padã-Arã. Ele foi à casa do seu tio Labão, filho de Betuel, o arameu, irmão de Rebeca, mãe de Jacó e de Esaú. ");
INSERT INTO poronbv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaú ficou sabendo que Isaque tinha abençoado a Jacó e o tinha mandado para Padã-Arã, para encontrar ali uma esposa para si; e ao abençoá-lo, ordenou a ele que não se casasse com uma mulher cananeia. ");
INSERT INTO poronbv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ele ficou sabendo que Jacó tinha obedecido ao seu pai e à sua mãe e tinha ido para Padã-Arã. ");
INSERT INTO poronbv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Então Esaú percebeu que seu pai Isaque não via com bons olhos as mulheres cananeias; ");
INSERT INTO poronbv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","por isso, foi à casa de Ismael e casou-se com a filha dele. Assim, além das duas mulheres cananeias que já tinha, Esaú casou com Maalate, irmã de Nebaiote, filha de Ismael, filho de Abraão. ");
INSERT INTO poronbv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacó partiu de Berseba e foi até Harã. ");
INSERT INTO poronbv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ele chegou num certo lugar, onde passou a noite, porque o sol já se tinha posto. Jacó procurou uma pedra que lhe servisse de travesseiro para descansar a cabeça, e adormeceu. ");
INSERT INTO poronbv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ele sonhou que havia uma escada que ia da terra até o céu, e os anjos de Deus subiam e desciam pela escada. ");
INSERT INTO poronbv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","O Senhor estava próximo dele e lhe disse: “Eu sou o Senhor, Deus de Abraão e de seu pai, Isaque. Darei a você e aos seus descendentes a terra na qual você está deitado. ");
INSERT INTO poronbv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Os seus descendentes serão como o pó da terra. Eles se espalharão para o ocidente e para o oriente, para o norte e para o sul. Todas as nações da terra serão abençoadas por meio de você e dos seus descendentes. ");
INSERT INTO poronbv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Eu estarei com você e o guardarei em todos os lugares para onde você for; e esteja certo de que o trarei de volta a esta terra. Não vou desamparar você até que se cumpra tudo o que lhe prometi”. ");
INSERT INTO poronbv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Então Jacó acordou e exclamou: “Certamente o Senhor está neste lugar e eu não sabia!” ");
INSERT INTO poronbv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ele ficou com medo e disse: “Que lugar tremendo! Esta é a casa de Deus, a porta dos céus”. ");
INSERT INTO poronbv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Logo que amanheceu, Jacó colocou a pedra que tinha usado como travesseiro em pé, como uma coluna. Depois derramou óleo sobre ela. ");
INSERT INTO poronbv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","E chamou aquele lugar de Betel, cidade que antes se chamava Luz. ");
INSERT INTO poronbv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Então Jacó fez a seguinte promessa a Deus: “Se Deus estiver comigo, proteger-me nesta viagem e me der alimento e roupa, ");
INSERT INTO poronbv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","e levar-me de volta em paz à casa de meu pai, então, o Senhor será o meu Deus. ");
INSERT INTO poronbv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","E esta pedra que coloquei como coluna será a Casa de Deus, um lugar de adoração; e, certamente, devolverei a décima parte de tudo que me der”. ");
INSERT INTO poronbv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacó continuou a sua viagem e chegou à terra do Oriente. ");
INSERT INTO poronbv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Quando ia chegando, viu ao longe três rebanhos de ovelhas deitados próximos a um poço no campo, pois esses rebanhos bebiam daquele poço, que era coberto por uma grande pedra. ");
INSERT INTO poronbv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Quando todos os rebanhos se ajuntavam, os pastores removiam a pedra da boca do poço e davam de beber às ovelhas. Depois tapavam outra vez o poço com a pedra. ");
INSERT INTO poronbv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacó chegou até onde os pastores estavam, e perguntou-lhes: “Meus amigos, de onde vocês são?” “De Harã”, responderam. ");
INSERT INTO poronbv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Jacó perguntou-lhes: “Vocês conhecem Labão, filho de Naor?” Eles responderam: “Certamente!” ");
INSERT INTO poronbv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jacó indagou novamente: “Ele está bem?” “Sim, ele está bem!”, disseram eles. “Olhe, ali vem vindo Raquel, a filha dele, com as ovelhas”. ");
INSERT INTO poronbv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Então ele disse: “Ainda é dia, e é muito cedo para recolherem os rebanhos. Deem de beber às ovelhas e as levem ao campo novamente”. ");
INSERT INTO poronbv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","“Não podemos”, responderam eles. “Enquanto não se ajuntarem todos os rebanhos e não for removida a pedra da boca do poço, não daremos de beber às ovelhas”. ");
INSERT INTO poronbv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","No meio da conversa, chegou Raquel com as ovelhas de seu pai, porque era pastora. ");
INSERT INTO poronbv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Quando Jacó viu Raquel, filha de Labão, irmão de sua mãe, e as ovelhas de Labão, aproximou-se, removeu a pedra da boca do poço e deu água ao rebanho de seu tio Labão. ");
INSERT INTO poronbv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Depois disso, Jacó beijou Raquel e se emocionou profundamente. ");
INSERT INTO poronbv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacó então contou a Raquel que era seu primo, por parte do pai dela. Disse que era filho de Rebeca, tia de Raquel. Então ela correu e contou tudo a seu pai. ");
INSERT INTO poronbv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Assim que Labão ouviu as notícias a respeito de Jacó, filho de sua irmã, correu ao seu encontro, abraçou-o e o beijou. Em seguida, levou-o para sua casa, e Jacó contou tudo o que tinha acontecido durante a sua viagem. ");
INSERT INTO poronbv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Então Labão lhe disse: “Você é realmente da minha própria carne e do meu sangue!” Jacó já estava um mês na casa de Labão, ");
INSERT INTO poronbv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","quando este lhe disse: “Não é porque você é meu parente, que vai ficar trabalhando de graça para mim. Diga-me, quanto você quer receber de salário?” ");
INSERT INTO poronbv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labão tinha duas filhas; o nome da mais velha era Lia, e o da mais nova, Raquel. ");
INSERT INTO poronbv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lia tinha aparência singela, mas Raquel era uma mulher muito bonita. ");
INSERT INTO poronbv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacó gostou de Raquel e disse: “Trabalharei sete anos para você para poder casar-me com Raquel, sua filha mais nova”. ");
INSERT INTO poronbv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labão respondeu: “Prefiro dá-la a você a entregá-la a algum homem estranho. Fique aqui comigo”. ");
INSERT INTO poronbv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Assim, Jacó trabalhou sete anos para Labão para poder casar-se com Raquel. Ele a amava tanto que os sete anos pareceram poucos dias. ");
INSERT INTO poronbv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Quando passaram os sete anos, disse Jacó a Labão: “Dê-me a minha mulher, pois já venceu o prazo, para que eu me case com ela”. ");
INSERT INTO poronbv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Labão convidou todo o povo daquele lugar e fez uma grande festa. ");
INSERT INTO poronbv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","À noite, Labão entregou sua filha Lia a Jacó, e Jacó deitou-se com ela. ");
INSERT INTO poronbv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Labão deu sua serva Zilpa a Lia para ser serva dela.) ");
INSERT INTO poronbv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Quando amanheceu, Jacó viu que havia dormido com Lia (e não com Raquel). Por isso Jacó disse a Labão: “Por que o senhor fez isso comigo? Eu não trabalhei por amor a Raquel? Por que você me enganou?” ");
INSERT INTO poronbv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labão respondeu: “Aqui não é o costume casar a filha mais nova antes da mais velha. ");
INSERT INTO poronbv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Espere terminar esta semana de núpcias e lhe daremos a mais nova, em troca de mais sete anos de trabalho para mim”. ");
INSERT INTO poronbv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacó concordou. Quando passou aquela semana da festa de casamento, Labão lhe deu sua filha Raquel por mulher. ");
INSERT INTO poronbv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Labão deu sua serva Bila para ser serva de Raquel.) ");
INSERT INTO poronbv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacó deitou-se com Raquel. Ele a amava mais do que a Lia, e trabalhou mais sete anos para Labão. ");
INSERT INTO poronbv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Quando o Senhor viu que Lia era desprezada por Jacó, fez com que ela tivesse filhos; Raquel, porém, não podia ter filhos. ");
INSERT INTO poronbv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lia ficou grávida e deu à luz um filho, e deu-lhe o nome de Rúben, pois disse: “O Senhor viu a minha aflição. Agora o meu marido me amará”. ");
INSERT INTO poronbv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lia engravidou novamente, e quando deu à luz disse: “O Senhor ouviu que eu era desprezada e me deu este filho”. Por isso, chamou-o de Simeão. ");
INSERT INTO poronbv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lia engravidou outra vez e, quando deu à luz o terceiro filho, disse: “Desta vez, meu marido se unirá a mim, porque lhe dei três filhos”. Por isso chamou-o de Levi. ");
INSERT INTO poronbv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lia engravidou mais uma vez e, quando deu à luz um filho, disse: “Desta vez louvarei o Senhor”. Por isso deu-lhe o nome de Judá. Então parou de ter filhos. ");
INSERT INTO poronbv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Quando Raquel viu que não podia dar filhos a Jacó, ficou com inveja de sua irmã e disse a Jacó: “Dê-me filhos, senão morrerei!” ");
INSERT INTO poronbv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Então Jacó ficou indignado e disse: “Por acaso estou no lugar de Deus, que não a deixou ter filhos?” ");
INSERT INTO poronbv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Raquel respondeu: “Aqui está minha serva Bila. Deite-se com ela e tenha filhos com ela. Eu os criarei como se fossem meus filhos”. ");
INSERT INTO poronbv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Assim Raquel deu sua serva Bila a Jacó por mulher; Jacó deitou-se com ela, ");
INSERT INTO poronbv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bila ficou grávida e deu um filho a Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Então Raquel disse: “Deus me julgou, ouviu a minha queixa e deu-me um filho”. Ela o chamou de Dã. ");
INSERT INTO poronbv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bila, serva de Raquel, ficou grávida outra vez e deu um segundo filho a Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","“É grande a minha luta com a minha irmã”, disse Raquel, “mas venci”. Por isso, chamou-o de Naftali. ");
INSERT INTO poronbv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Quando Lia viu que a serva de Raquel cessara de ter filhos, deu sua serva Zilpa a Jacó, para ser sua mulher. ");
INSERT INTO poronbv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa, serva de Lia, deu um filho a Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","E Lia exclamou: “A minha sorte voltou!” E chamou-o de Gade. ");
INSERT INTO poronbv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa, serva de Lia, teve outro filho com Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Então exclamou: “Como sou feliz! As outras mulheres vão achar que eu sou mesmo feliz!” E chamou o menino de Aser. ");
INSERT INTO poronbv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Era tempo da colheita de trigo. Rúben achou mandrágoras no campo, e trouxe-as à sua mãe Lia. Então disse Raquel a Lia: “Dê-me algumas mandrágoras do seu filho”. ");
INSERT INTO poronbv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ela respondeu: “Além de ficar com o meu marido, também vai querer ficar com as mandrágoras do meu filho?” Então Raquel disse: “Deixarei que Jacó se deite com você nesta noite, em troca das mandrágoras do seu filho”. ");
INSERT INTO poronbv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Quando Jacó veio do campo naquela tarde, Lia foi ao seu encontro e disse: “Essa noite dormiremos juntos, pois eu obtive esse direito por meio das mandrágoras que meu filho achou”. E Jacó deitou com ela naquela noite. ");
INSERT INTO poronbv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Deus ouviu a Lia, e ela deu à luz o quinto filho. ");
INSERT INTO poronbv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Então disse Lia: “Deus me recompensou, porque dei minha serva ao meu marido”. Por isso chamou o menino de Issacar. ");
INSERT INTO poronbv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lia voltou a engravidar e deu o sexto filho a Jacó, ");
INSERT INTO poronbv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","e disse: “Deus me deu belos presentes. Desta vez meu marido me honrará e ficará comigo, porque lhe dei seis filhos”. Por isso chamou-o de Zebulom. ");
INSERT INTO poronbv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Depois Lia teve uma filha, que recebeu o nome de Diná. ");
INSERT INTO poronbv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Então Deus lembrou-se de Raquel. Ele ouviu o seu clamor e fez com que ela pudesse ter filhos. ");
INSERT INTO poronbv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ela engravidou, e deu à luz um filho e disse: “Deus tirou a minha vergonha” ");
INSERT INTO poronbv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","e o chamou de José, dizendo: “Que o Senhor me dê ainda outro filho”. ");
INSERT INTO poronbv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Depois que Raquel deu à luz José, disse Jacó a Labão: “Permita-me voltar à minha terra natal. ");
INSERT INTO poronbv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Deixe que eu vá e leve comigo meus filhos e minhas mulheres, pelas quais o servi. Você sabe muito bem o quanto trabalhei para você”. ");
INSERT INTO poronbv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labão, porém, lhe respondeu: “Peço que não vá embora. Tenho percebido que o Senhor me tem abençoado por sua causa”. ");
INSERT INTO poronbv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","E acrescentou: “É só dizer o quanto quer receber de salário, e eu pagarei”. ");
INSERT INTO poronbv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacó respondeu: “Você bem sabe como trabalhei para você e como cuidei do seu gado. ");
INSERT INTO poronbv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Basta lembrar como eram pequenos os seus rebanhos antes da minha chegada, e como aumentaram agora. Pois o Senhor abençoou você por meio do meu trabalho. Agora, quando vou poder trabalhar em favor da minha própria família?” ");
INSERT INTO poronbv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Então Labão perguntou: “O que você quer ganhar?” Jacó respondeu: “Não quero salário. Voltarei a cuidar dos seus rebanhos; basta que faça uma coisa. ");
INSERT INTO poronbv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Hoje passarei por todos os seus rebanhos e separarei para mim todas as ovelhas listradas e malhadas, e todos os cordeiros pretos. Este será o meu salário. ");
INSERT INTO poronbv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Assim será fácil verificar a minha honestidade no futuro, sempre que resolver verificar o meu salário. Se você encontrar entre as minhas cabras alguma que não for listrada e malhada, e algum cordeiro que não for preto, poderá dizer que roubei de você”. ");
INSERT INTO poronbv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labão concordou: “Está certo! Está feito o trato”. ");
INSERT INTO poronbv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Naquele mesmo dia, Labão separou os bodes listrados e malhados e todas as cabras salpicadas e malhadas, e todos os cordeiros pretos e os deu aos seus filhos, ");
INSERT INTO poronbv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","e os afastou a uma jornada de três dias de distância. E Jacó ficou tomando conta dos rebanhos restantes de Labão. ");
INSERT INTO poronbv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Então Jacó pegou varas verdes de estoraque, amendoeira e plátano. De cada vara removeu parcialmente a casca, deixando aparecer a parte branca interna das varas. ");
INSERT INTO poronbv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Depois Jacó pôs as varas perto dos canais de água e dos bebedouros, onde os rebanhos costumavam beber água. Na época do cruzamento, os animais vinham beber e ");
INSERT INTO poronbv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","se acasalavam diante das varas. E geravam filhotes listrados, salpicados e malhados. ");
INSERT INTO poronbv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Então Jacó foi separando os animais listrados e pretos de Labão. E separou o seu rebanho do rebanho de Labão. ");
INSERT INTO poronbv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Todas as vezes que as fêmeas mais fortes concebiam, Jacó colocava as varas nos bebedouros, diante do rebanho, para que se acasalassem perto das varas. ");
INSERT INTO poronbv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Porém, quando vinham as fêmeas fracas, não as colocava ali. Desse modo, as fracas ficavam com Labão e as mais fortes com Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","E Jacó se tornou muito rico, tornando-se dono de muitos rebanhos, além de servos e servas, camelos e jumentos. ");
INSERT INTO poronbv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacó soube que os filhos de Labão andavam murmurando contra ele, dizendo: “Jacó se apossou de tudo que era de nosso pai. Toda riqueza dele foi ajuntada à custa do nosso pai”. ");
INSERT INTO poronbv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacó notou que a atitude de Labão tinha mudado para com ele. ");
INSERT INTO poronbv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","E o Senhor disse a Jacó: “Volte para a casa dos seus pais e dos seus parentes, e eu estarei com você”. ");
INSERT INTO poronbv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Então, Jacó mandou chamar Raquel e Lia para virem ao campo, onde estavam os seus rebanhos, ");
INSERT INTO poronbv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","e disse-lhes: “Noto que a atitude do seu pai para comigo já não é a mesma; porém, o Deus de meu pai tem estado comigo. ");
INSERT INTO poronbv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Vocês bem sabem como trabalhei com afinco para o seu pai, ");
INSERT INTO poronbv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","mas o pai de vocês tem me enganado e por dez vezes tem mudado o meu salário. Mas Deus não deixou que ele me causasse prejuízo. ");
INSERT INTO poronbv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Se ele dizia: ‘Os salpicados serão o seu salário’, então os rebanhos geravam animais salpicados; e se ele dizia: ‘Os listrados serão o seu salário’, então os rebanhos geravam animais listrados. ");
INSERT INTO poronbv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Dessa forma, Deus tirou os rebanhos de seu pai e os deu para mim”. ");
INSERT INTO poronbv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","E Jacó continuou: “Quando chegava o tempo do acasalamento, vi em sonhos que os machos que cobriam as fêmeas eram listrados, salpicados e malhados. ");
INSERT INTO poronbv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","E o Anjo de Deus me disse em sonho: ‘Jacó!’ Eu respondi: ‘Aqui estou!’ ");
INSERT INTO poronbv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Então ele disse: ‘Veja que todos os machos que cobrem o rebanho são listrados, salpicados e malhados, porque tenho visto tudo o que Labão tem feito a você. ");
INSERT INTO poronbv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Sou o Deus de Betel, onde você ungiu uma coluna e fez um voto. Levante-se e saia agora desta terra e volte para a terra dos seus parentes’ ”. ");
INSERT INTO poronbv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Raquel e Lia responderam a Jacó: “Que podemos esperar do nosso pai? ");
INSERT INTO poronbv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Pois ele nos tratou como se fôssemos estrangeiras! Além de nos vender, acabou com os nossos bens que eram nossos por direito. ");
INSERT INTO poronbv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Toda essa riqueza que Deus tirou de nosso pai é nossa e de nossos filhos. Portanto, faça tudo o que Deus mandou”. ");
INSERT INTO poronbv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Então Jacó levantou-se, montou seus filhos e suas mulheres nos camelos, ");
INSERT INTO poronbv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","e conduziu todos os seus rebanhos e todas as riquezas que tinha conseguido ajuntar em Padã-Arã. E foi em direção à terra de Canaã, para a casa do seu pai Isaque. ");
INSERT INTO poronbv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Enquanto Labão tosquiava as ovelhas, Raquel roubou os ídolos da casa que pertenciam ao seu pai. ");
INSERT INTO poronbv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","E Jacó enganou o arameu Labão, fugindo às escondidas. ");
INSERT INTO poronbv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ele fugiu com tudo o que tinha. Atravessou o rio Eufrates e foi em direção à montanha de Gileade. ");
INSERT INTO poronbv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Só três dias depois Labão ficou sabendo que Jacó tinha fugido. ");
INSERT INTO poronbv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Reuniu vários homens de sua família e saiu em perseguição a Jacó. Depois de sete dias de viagem, alcançou Jacó na montanha de Gileade. ");
INSERT INTO poronbv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","De noite, porém, Deus falou com o arameu Labão por meio de um sonho e lhe disse: “Cuidado com o que você vai fazer! Não fale a Jacó nem bem nem mal”. ");
INSERT INTO poronbv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Finalmente Labão alcançou Jacó, que tinha armado sua tenda na montanha de Gileade. Labão, com os seus homens, armou a sua tenda na mesma montanha. ");
INSERT INTO poronbv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","E disse Labão a Jacó: “O que você fez? Além de me enganar, ainda levou minhas filhas como se fossem prisioneiras de guerra. ");
INSERT INTO poronbv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Por que você me enganou e saiu às escondidas? Por que não me contou o seu plano para que eu pudesse celebrar a sua partida com uma grande festa, com canções, com tamborins e com harpa? ");
INSERT INTO poronbv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Você nem me deu a oportunidade de beijar meus netos e minhas filhas. Nisso você agiu com insensatez. ");
INSERT INTO poronbv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Tenho poder para fazer mal a vocês, mas o Deus do seu pai Isaque me apareceu ontem à noite, e disse: ‘Cuidado com o que você vai fazer! Não fale a Jacó nem bem nem mal’. ");
INSERT INTO poronbv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Você partiu porque tinha saudade da casa de seu pai, mas por que você roubou os meus deuses?” ");
INSERT INTO poronbv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacó respondeu-lhe: “Eu fugi assim porque fiquei com medo, pois pensei que você tiraria as suas filhas à força de mim. ");
INSERT INTO poronbv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mas quanto aos seus deuses, não ficará vivo aquele que estiver com eles. Verifique na presença dos nossos parentes o que pertence a você. Se encontrar alguma coisa, leve-a de volta”. Jacó não sabia que Raquel tinha roubado os deuses. ");
INSERT INTO poronbv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Então Labão entrou na tenda de Jacó, na de Lia e de suas servas, mas nada achou. Depois de sair da tenda de Lia, entrou na tenda de Raquel. ");
INSERT INTO poronbv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Acontece que Raquel tinha colocado os ídolos na sela do seu camelo e estava sentada em cima deles. Labão procurou por toda a tenda, mas nada encontrou. ");
INSERT INTO poronbv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Então ela disse ao seu pai: “Peço desculpas, meu senhor, por não poder me levantar na sua presença, pois estou no período mensal das mulheres”. Ele vasculhou toda a tenda mas não encontrou os ídolos do lar. ");
INSERT INTO poronbv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacó ficou zangado e queixou-se a Labão: “Qual foi a minha transgressão? Que pecado cometi, para me perseguir de maneira tão furiosa? ");
INSERT INTO poronbv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Você já vasculhou todos os meus bens. Por acaso encontrou alguma coisa da sua casa? Coloque o que encontrou aqui, na frente dos meus parentes e dos seus. Eles vão julgar qual de nós está errado. ");
INSERT INTO poronbv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Estive com você vinte anos. Suas ovelhas e cabras nunca perderam as suas crias, e jamais me servi dos carneiros do seu rebanho para alimento. ");
INSERT INTO poronbv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Eu nunca levei a você os animais despedaçados pelas feras; eu mesmo assumia o prejuízo. Você descontava tudo do meu salário, incluindo todo animal roubado de dia ou de noite. ");
INSERT INTO poronbv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Trabalhei para você nas horas quentes do dia, bem como nas noites frias, ficando muitas noites sem dormir. ");
INSERT INTO poronbv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Permaneci na sua casa vinte anos! Trabalhei quatorze anos para casar com as suas duas filhas, e seis anos para formar o meu rebanho. Dez vezes você mudou o meu salário. ");
INSERT INTO poronbv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Se não fosse o Deus de meu pai, o Deus de Abraão, e o Temor de Isaque, certamente você me mandaria embora de mãos vazias. Mas Deus viu o meu sofrimento e o trabalho das minhas mãos e, ontem à noite, ele preveniu você”. ");
INSERT INTO poronbv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Então Labão respondeu a Jacó: “Estas mulheres são minhas filhas, estes filhos são meus. O mesmo posso dizer dos rebanhos e de tudo o que você tem. Tudo é meu. O que posso fazer por essas minhas filhas e pelos filhos que delas nasceram? ");
INSERT INTO poronbv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Venha! Façamos um acordo, eu e você, que sirva de testemunho entre nós dois”. ");
INSERT INTO poronbv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Então Jacó pegou uma pedra e fez dela uma coluna. ");
INSERT INTO poronbv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","E disse aos seus parentes: “Ajuntem pedras”. Eles buscaram pedras e fizeram uma pilha com elas. ");
INSERT INTO poronbv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labão chamou aquele lugar de Jegar-Saaduta. Jacó, no entanto, o chamou de Galeede. ");
INSERT INTO poronbv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labão disse: Que hoje esta pilha de pedras sirva de testemunho entre mim e você; por isso foi chamado de Galeede. ");
INSERT INTO poronbv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Foi também chamado de Mispá porque Labão disse: “Que o Senhor fique nos vigiando cada um de nós, quando estivermos separados, em relação a esse acordo. ");
INSERT INTO poronbv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Se você maltratar as minhas filhas ou tomar outras mulheres além delas, eu estarei longe, mas Deus é testemunha entre mim e você”. ");
INSERT INTO poronbv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labão continuou: “Aqui está a pilha de pedras e esta coluna que ergui entre mim e você. ");
INSERT INTO poronbv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Que sirvam de testemunhas do nosso compromisso de que não cruzaremos a linha para prejudicar um ao outro. ");
INSERT INTO poronbv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Que o Deus de Abraão, de Naor, o Deus do pai deles, julgue entre nós”. Assim Jacó fez um juramento em nome do temível Deus de seu pai Isaque. ");
INSERT INTO poronbv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Então Jacó, ali no topo da montanha, ofereceu um sacrifício e chamou os parentes que lá estavam para comerem pão e passarem a noite juntos na montanha. ");
INSERT INTO poronbv_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Na manhã seguinte, Labão levantou cedo, beijou e abençoou as filhas e os netos, e foi para casa. ");
INSERT INTO poronbv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacó também continuou a viagem. Pouco depois, anjos de Deus vieram ao encontro dele. ");
INSERT INTO poronbv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Quando Jacó viu os anjos, disse: “Deus está acampado aqui!” Por isso deu ao lugar o nome Maanaim. ");
INSERT INTO poronbv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Depois Jacó mandou mensageiros adiante dele, ao encontro do seu irmão Esaú. Eles foram para a terra de Seir, território de Edom ");
INSERT INTO poronbv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","e levaram esta mensagem: “Jacó, seu servo, manda dizer o seguinte: ‘Morei como peregrino com Labão, e na companhia dele fiquei até agora. ");
INSERT INTO poronbv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Estou voltando de lá com bois, jumentos, ovelhas e cabras, servos e servas. Envio estes mensageiros para avisar ao meu senhor, para que me receba de forma amigável’ ”. ");
INSERT INTO poronbv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Os mensageiros voltaram a Jacó, dizendo: “Fomos até o seu irmão Esaú, e ele está vindo ao seu encontro com quatrocentos homens”. ");
INSERT INTO poronbv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jacó teve medo e perturbou-se. Ele dividiu em dois grupos as pessoas que estavam com ele, bem como as ovelhas e cabras, os bois e os camelos, ");
INSERT INTO poronbv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","pois pensou: “Se Esaú atacar um dos grupos, talvez o outro consiga escapar”. ");
INSERT INTO poronbv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","E Jacó fez esta oração: “Ó Deus de meu pai Abraão e Deus de meu pai Isaque! Ó Senhor que me disse: ‘Volte para a sua terra e seus parentes, e eu farei com que tudo corra bem’. ");
INSERT INTO poronbv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Não mereço nenhuma das suas bondades para comigo. Não sou digno da maneira fiel como o Senhor tem cumprido a sua palavra com o seu servo. Pois saí de casa e atravessei o rio Jordão trazendo apenas o meu cajado, e agora volto com duas caravanas completas! ");
INSERT INTO poronbv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Não permita que eu seja destruído pelo meu irmão Esaú. Estou com medo de que ele venha matar tanto a mim quanto as mulheres e as crianças”. ");
INSERT INTO poronbv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Mas o Senhor prometeu: “Esteja certo de que eu farei bem a você e farei com que os seus descendentes sejam tão numerosos como a areia do mar, que de tão numerosa, não se pode contar”. ");
INSERT INTO poronbv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jacó passou ali aquela noite, e preparou entre os seus rebanhos um presente para dar ao seu irmão Esaú: ");
INSERT INTO poronbv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","duzentas cabras e vinte bodes, duzentas ovelhas e vinte carneiros, ");
INSERT INTO poronbv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","trinta fêmeas de camelo com seus filhotes, quarenta vacas e dez touros, vinte jumentas e dez jumentos. ");
INSERT INTO poronbv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ele confiou os rebanhos do presente aos seus servos e disse-lhes: “Vão à minha frente mas deixem um bom espaço entre um rebanho e outro”. ");
INSERT INTO poronbv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Jacó instruiu ao primeiro servo, dizendo: “Quando meu irmão Esaú encontrar você e perguntar: ‘Para quem você trabalha? Para onde vai? Quem é o dono deste rebanho à sua frente?’ ");
INSERT INTO poronbv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","você responderá: ‘É do seu servo Jacó. É um presente para o meu senhor Esaú. Ele está vindo logo atrás de nós’ ”. ");
INSERT INTO poronbv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Jacó deu a mesma instrução ao segundo, ao terceiro e a cada um dos guias dos rebanhos: “Digam a mesma coisa a Esaú quando o encontrarem, ");
INSERT INTO poronbv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","e acrescentem: O seu servo Jacó está vindo atrás de nós”. Ele pensava: “Vou acalmar os ânimos de Esaú com esses presentes que estou enviando na minha frente, e quando nos encontrarmos, talvez ele me receba amigavelmente”. ");
INSERT INTO poronbv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Assim enviou os presentes na frente; ele, no entanto, passou aquela noite no acampamento. ");
INSERT INTO poronbv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Naquela noite levantou-se, levou as suas duas mulheres, suas duas servas e seus onze filhos e atravessou o rio Jordão, na passagem chamada Jaboque. ");
INSERT INTO poronbv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Depois de fazê-los atravessar o ribeiro, fez atravessar também tudo o que lhe pertencia. ");
INSERT INTO poronbv_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jacó ficou sozinho. Então veio um homem para lutar com ele até o amanhecer. ");
INSERT INTO poronbv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Quando o homem percebeu que não podia vencer a luta, tocou na articulação da coxa de Jacó, de modo que deslocou a coxa de Jacó, enquanto lutavam. ");
INSERT INTO poronbv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Então o homem disse: “Deixe-me ir embora, pois já está amanhecendo”. Mas Jacó respondeu: “Não deixarei que vá embora, enquanto não me abençoar”. ");
INSERT INTO poronbv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","“Qual é o seu nome?”, perguntou o homem. “Jacó”, foi a resposta. ");
INSERT INTO poronbv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Então o homem disse: “Você não mais se chamará Jacó, mas sim Israel, porque você lutou com Deus e com os homens, e venceu”. ");
INSERT INTO poronbv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","“Por favor, diga-me, qual é o seu nome?”, perguntou Jacó. “Por que você pergunta pelo meu nome?”, disse o homem. E o abençoou ali. ");
INSERT INTO poronbv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacó chamou àquele lugar Peniel, e disse: “Vi Deus face a face, e continuo vivo!” ");
INSERT INTO poronbv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Quando o sol estava nascendo, Jacó atravessou Peniel, e mancava por causa da coxa deslocada. ");
INSERT INTO poronbv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Por isso até hoje os israelitas não comem o músculo ligado à articulação da coxa, porque foi ali que o homem feriu a Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","De longe Jacó viu que Esaú estava vindo ao seu encontro, e com ele vinham quatrocentos homens. Então ele dividiu os filhos entre Lia, Raquel e as duas servas. ");
INSERT INTO poronbv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ele colocou as servas e seus filhos à frente, em seguida Lia e seus filhos, e por último Raquel com José. ");
INSERT INTO poronbv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Depois, ele mesmo passou à frente e, à medida que se aproximava do seu irmão, Jacó inclinou-se sete vezes. ");
INSERT INTO poronbv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Mas Esaú correu ao seu encontro e o abraçou. Ele colocou seus braços ao redor do pescoço de Jacó e o beijou. E os dois choraram. ");
INSERT INTO poronbv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Então Esaú viu as mulheres e as crianças e perguntou: “Quem são esses que estão com você?” “São os filhos que Deus bondosamente concedeu ao seu servo”, respondeu-lhe Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Nesse meio-tempo, se aproximaram as servas e seus filhos e se inclinaram diante de Esaú. ");
INSERT INTO poronbv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Aproximaram-se também Lia e seus filhos e se inclinaram. Finalmente, aproximaram-se Raquel e José e se inclinaram. ");
INSERT INTO poronbv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esaú então perguntou: “Com que intenção você mandou todos esses rebanhos que encontrei?” Jacó respondeu: “Para ser bem recebido diante do meu senhor”. ");
INSERT INTO poronbv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esaú, porém, disse: “Eu já tenho muitas riquezas, meu irmão. Guarde o que é seu”. ");
INSERT INTO poronbv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","“Não recuse!”, insistiu Jacó. “Se existe aprovação da sua parte, por favor aceite o meu presente, porque ver a sua face é como contemplar a face de Deus; além disso, o senhor me recebeu tão bem. ");
INSERT INTO poronbv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Aceite, pois, o presente que eu lhe trouxe. Deus tem sido muito generoso comigo. O que tenho é mais do que suficiente para mim”. E insistiu tanto que Esaú acabou aceitando. ");
INSERT INTO poronbv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esaú disse: “Vamos seguir em frente. Eu seguirei com você”. ");
INSERT INTO poronbv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacó, porém, lhe disse: “Meu senhor sabe que as crianças que trago são frágeis. Além disso, tenho comigo ovelhas e vacas de leite, que amamentam suas crias. Se forçá-las demais num só dia, morrerão todos os rebanhos. ");
INSERT INTO poronbv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Portanto, é melhor que meu senhor vá à frente de seu servo. Nós iremos mais devagar, acompanhando o passo dos rebanhos e das crianças, até me encontrar com o meu senhor em Seir”. ");
INSERT INTO poronbv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esaú respondeu: “Então, pelo menos permita-me deixar alguns homens com você”. “Para quê?”, perguntou Jacó. “O fato de ser bem recebido pelo meu senhor já é o bastante para mim”. ");
INSERT INTO poronbv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Assim Esaú começou a viagem de volta para Seir. ");
INSERT INTO poronbv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Enquanto isso, Jacó foi para Sucote. Ali Jacó construiu uma casa para si e abrigos para os animais. Por isso, aquele lugar recebeu o nome de Sucote. ");
INSERT INTO poronbv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Completando a viagem de volta de Padã-Arã, Jacó chegou são e salvo à cidade de Siquém, em Canaã, e acampou próximo da cidade. ");
INSERT INTO poronbv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ele comprou a parte do campo onde tinha montado o acampamento dos filhos de Hamor, pai de Siquém, por cem peças de prata. ");
INSERT INTO poronbv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ali Jacó construiu um altar, ao qual deu o nome de El Elohe Israel. ");
INSERT INTO poronbv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Um dia, a filha de Lia, Diná, saiu para conhecer as mulheres daquela terra. ");
INSERT INTO poronbv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Quando Siquém, filho do rei heveu Hamor, viu Diná, agarrou-a e forçou-a a ter relações com ele. ");
INSERT INTO poronbv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","E ele apaixonou-se pela filha de Jacó, Diná, e procurou conquistar o amor dela. ");
INSERT INTO poronbv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Então Siquém disse ao seu pai Hamor: “Peça aquela moça em casamento para mim”. ");
INSERT INTO poronbv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Quando Jacó ficou sabendo que sua filha Diná tinha sido desonrada por Siquém, seus filhos estavam cuidando do gado no campo. Jacó ficou quieto a respeito do assunto, até a volta dos filhos. ");
INSERT INTO poronbv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Enquanto isso, o pai de Siquém, Hamor, foi falar com Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Quando os filhos de Jacó voltaram, ouviram o que havia acontecido e ficaram profundamente indignados e furiosos por Siquém ter praticado um ato tão vergonhoso para eles, desonrando a filha de Jacó. Isso era uma coisa que não se devia fazer. ");
INSERT INTO poronbv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Mas Hamor disse-lhes: “Meu filho Siquém apaixonou-se pela filha de vocês. Peço a vocês que a entreguem para que seja esposa dele. ");
INSERT INTO poronbv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tornem-se nossos parentes. As suas filhas poderão se casar com os nossos filhos e as filhas do meu povo poderão se casar com os seus filhos. ");
INSERT INTO poronbv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Vocês poderão se estabelecer aqui. A terra está à disposição de vocês. Habitem nela, façam negócios e comprem propriedades”. ");
INSERT INTO poronbv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","O próprio Siquém falou ao pai e aos irmãos de Diná: “Peço que sejam bondosos comigo, e eu lhes darei o que me pedirem. ");
INSERT INTO poronbv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Peçam o quanto quiserem pelo dote do casamento e o presente pela moça. Darei o que me pedirem. Só peço que me deem a moça por esposa”. ");
INSERT INTO poronbv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Então, os filhos de Jacó responderam com falsidade a Siquém e ao seu pai Hamor, por ter Siquém desonrado sua irmã Diná. Eles disseram: ");
INSERT INTO poronbv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Não podemos dar a nossa irmã a um homem que não foi circuncidado. Isso seria uma vergonha para nós. ");
INSERT INTO poronbv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Só aceitaremos o seu pedido com uma condição: que vocês se tornem como nós, circuncidando todos os homens do seu povo. ");
INSERT INTO poronbv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Só assim daremos a vocês as nossas filhas e poderemos casar-nos com as suas. Habitaremos com vocês e seremos um só povo. ");
INSERT INTO poronbv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Se, porém, não concordarem e não aceitarem a circuncisão, levaremos nossa irmã Diná e iremos embora daqui”. ");
INSERT INTO poronbv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Essas palavras agradaram a Hamor e a seu filho Siquém. ");
INSERT INTO poronbv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sem demora o jovem colocou em prática o que lhe tinham pedido, porque estava muito apaixonado pela filha de Jacó. Ele era o mais respeitado de todos os da casa de seu pai. ");
INSERT INTO poronbv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Assim Hamor e seu filho Siquém convocaram todos os cidadãos para uma assembleia à porta da sua cidade e disseram: ");
INSERT INTO poronbv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Esses homens são pacíficos. Vamos permitir que eles morem em nossa terra e façam negócios aqui. A terra é bastante espaçosa, e eles não terão problema com seu sustento. As filhas deles poderão casar com os nossos filhos, e as nossas filhas com os filhos deles. ");
INSERT INTO poronbv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Porém, para habitarem conosco, tornando-nos um só povo, eles impõem uma condição, ou seja, que todos os nossos homens sejam circuncidados, como eles. ");
INSERT INTO poronbv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","E será que não ficaremos com todo o seu gado, os seus bens e todos os outros animais? Vamos aceitar, pois, a condição para que morem entre nós”. ");
INSERT INTO poronbv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","E todos os cidadãos que estavam à porta da cidade concordaram com Hamor e seu filho Siquém, e todos os homens da cidade foram circuncidados. ");
INSERT INTO poronbv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Mas três dias depois, quando os homens sentiam mais fortemente as dores do corte, dois filhos de Jacó, Simeão e Levi, irmãos de Diná, tomaram suas espadas, entraram inesperadamente na cidade e mataram todos os homens. ");
INSERT INTO poronbv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamor e seu filho Siquém também foram mortos. Os dois irmãos tiraram Diná da casa de Siquém e foram embora. ");
INSERT INTO poronbv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Depois os filhos de Jacó entraram e saquearam a cidade, porque a sua irmã tinha sido desonrada. ");
INSERT INTO poronbv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Levaram os seus rebanhos, os bois, os jumentos e tudo o que havia na cidade e no campo. ");
INSERT INTO poronbv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Levaram todos os seus bens, além das crianças e mulheres como prisioneiras, e saquearam tudo o que havia nas casas. ");
INSERT INTO poronbv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Então Jacó disse a Simeão e a Levi: “Quanta aflição vocês me causaram! Agora serei odiado pelos moradores desta terra, entre os cananeus e os ferezeus. Somos poucos. Se eles se juntarem contra mim, eu e a minha casa seremos destruídos”. ");
INSERT INTO poronbv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Mas eles responderam: “É justo deixar que ele tratasse a nossa irmã como se fosse uma prostituta?” ");
INSERT INTO poronbv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Deus disse a Jacó: “Apronte-se, suba para Betel e estabeleça-se ali. Chegando lá, construa um altar ao Deus que lhe apareceu quando você estava fugindo do seu irmão Esaú”. ");
INSERT INTO poronbv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Então Jacó disse à sua família e a todos que estavam com ele: “Joguem fora todas as imagens dos deuses estrangeiros que estão com vocês. Purifiquem-se e vistam roupas limpas. ");
INSERT INTO poronbv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Aprontem-se e subamos para Betel. Lá eu vou construir um altar ao Deus que me ouviu no dia da minha angústia e tem me acompanhado por onde tenho andado”. ");
INSERT INTO poronbv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Então deram a Jacó todas as imagens dos deuses estrangeiros e os brincos que usavam nas orelhas. E Jacó os enterrou debaixo do carvalho próximo de Siquém. ");
INSERT INTO poronbv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Quando partiram, o terror de Deus dominou de tal forma as cidades próximas que ninguém perseguiu os filhos de Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacó e todos que estavam com ele chegaram a Luz, cidade também conhecida por Betel, na terra de Canaã. ");
INSERT INTO poronbv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Jacó construiu ali um altar e chamou o lugar de El-Betel. Porque foi em Betel que Deus apareceu a Jacó, quando estava fugindo de seu irmão Esaú. ");
INSERT INTO poronbv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Débora, a ama de Rebeca, morreu e foi enterrada ao pé do carvalho. Essa árvore foi chamada de Alom-Bacute. ");
INSERT INTO poronbv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Tendo voltado de Padã-Arã, Deus lhe apareceu de novo e o abençoou. ");
INSERT INTO poronbv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Deus disse-lhe: “Seu nome é Jacó, mas você já não se chamará mais Jacó. O seu nome será Israel”. ");
INSERT INTO poronbv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","E Deus ainda lhe disse: “Eu sou o Deus Todo-poderoso. Farei que você tenha muitos descendentes que vão se multiplicar muito, formando uma grande nação. Multidões de nações e reis estarão entre os seus descendentes. ");
INSERT INTO poronbv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","E passarei a você e aos seus futuros descendentes a terra que dei a Abraão e a Isaque”. ");
INSERT INTO poronbv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Em seguida Deus elevou-se do lugar em que tinha falado com Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Então Jacó levantou uma coluna de pedra no lugar em que Deus tinha falado com ele. Depois derramou vinho sobre ela e ungiu-a com óleo de oliveira. ");
INSERT INTO poronbv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacó chamou de Betel o lugar em que Deus tinha falado com ele. ");
INSERT INTO poronbv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Eles saíram de Betel e foram a Efrata. Já próximos da cidade, Raquel deu à luz um filho. Ela sofreu muito durante o nascimento dele. ");
INSERT INTO poronbv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","A parteira procurou animar Raquel, em meio às dores do parto, dizendo: “Não tenha medo! Você vai ter outro filho”. ");
INSERT INTO poronbv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Raquel estava morrendo, mas ainda conseguiu dar-lhe o nome de Benoni. Porém, o seu pai deu-lhe o nome de Benjamim. ");
INSERT INTO poronbv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Assim morreu Raquel. Ela foi enterrada junto ao caminho de Efrata, que é Belém. ");
INSERT INTO poronbv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Sobre a sepultura de Raquel, Jacó ergueu uma coluna, que está lá até hoje. ");
INSERT INTO poronbv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Em seguida, Israel continuou viagem e armou a sua tenda além da torre de Éder. ");
INSERT INTO poronbv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Enquanto moravam naquela terra, Rúben se deitou com Bila, concubina de seu pai. E Israel ficou sabendo disso. ");
INSERT INTO poronbv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Estes foram os filhos que teve com Lia: Rúben, o filho mais velho de Jacó, Simeão, Levi, Judá, Issacar e Zebulom. ");
INSERT INTO poronbv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Estes foram os filhos que teve com Raquel: José e Benjamim. ");
INSERT INTO poronbv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Estes foram os filhos que teve com Bila, serva de Raquel: Dã e Naftali. ");
INSERT INTO poronbv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Estes foram os filhos que teve com Zilpa, serva de Lia: Gade e Aser. ");
INSERT INTO poronbv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Finalmente, Jacó chegou à casa do seu pai Isaque em Manre, em Quiriate-Arba, que é Hebrom, onde Abraão e Isaque tinham morado. ");
INSERT INTO poronbv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaque viveu cento e oitenta anos. ");
INSERT INTO poronbv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Morreu em idade avançada, e foi reunido aos seus antepassados. E seus filhos Esaú e Jacó o enterraram. ");
INSERT INTO poronbv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esta é a lista dos descendentes de Esaú, também chamado de Edom. ");
INSERT INTO poronbv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaú casou-se com três mulheres de Canaã: Ada, filha do heteu Elom, Oolibama, filha de Aná e neta do heveu Zibeão, ");
INSERT INTO poronbv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","e também Basemate, sua prima, filha de Ismael, irmã de Nebaiote. ");
INSERT INTO poronbv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esaú e Ada tiveram um filho chamado Elifaz. Esaú e Basemate tiveram um filho chamado Reuel. ");
INSERT INTO poronbv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Esaú e Oolibama tiveram filhos chamados Jeús, Jalão e Corá. Todos estes filhos de Esaú nasceram em Canaã. ");
INSERT INTO poronbv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaú reuniu suas mulheres, seus filhos e filhas, e todas as pessoas da sua casa, os seus rebanhos, todo o seu gado e todos os seus bens que tinha adquirido na terra de Canaã, e mudou-se para outra região, afastando-se do seu irmão Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Os seus bens eram tantos que já não podiam morar juntos. A terra onde tinham morado juntos já não podia sustentá-los, por causa do seu gado. ");
INSERT INTO poronbv_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Por isso, Esaú, que é Edom, foi morar no monte Seir. ");
INSERT INTO poronbv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Estes são os descendentes de Esaú, pai dos edomitas, no monte Seir. ");
INSERT INTO poronbv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","São estes os filhos de Esaú: Elifaz, filho de Ada, mulher de Esaú; Reuel, filho de Basemate, mulher de Esaú. ");
INSERT INTO poronbv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Estes foram os filhos de Elifaz: Temã, Omar, Zefô, Gaetã e Quenaz. ");
INSERT INTO poronbv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaz, filho de Esaú, tinha uma concubina chamada Timna, que lhe deu um filho chamado Amaleque. São estes os filhos de Ada, mulher de Esaú. ");
INSERT INTO poronbv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Estes foram os filhos de Reuel: Naate, Zerá, Samá e Mizá; estes foram os filhos de Basemate, mulher de Esaú. ");
INSERT INTO poronbv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Estes foram os filhos de Oolibama, mulher de Esaú, filha de Aná, filho (neto) de Zibeão: Jeús, Jalão e Corá. ");
INSERT INTO poronbv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","São estes os chefes dentre os filhos de Esaú: dos filhos de Elifaz, o filho mais velho de Esaú, descendem os seguintes chefes de grupos de famílias: os chefes Temã, Omar, Zefô, Quenaz, ");
INSERT INTO poronbv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Corá, Gaetã e Amaleque. São esses os chefes que são descendentes de Elifaz, o filho mais velho de Esaú e de Ada, em Edom. ");
INSERT INTO poronbv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","De Reuel, filho de Esaú (e de Basemate), descendem os seguintes grupos de famílias: os chefes Naate, Zaerá, Samá e Mizá. Esses foram os chefes dos grupos de famílias, descendentes de Reuel em Edom; netos de Basemate, mulher de Esaú. ");
INSERT INTO poronbv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Foram estes os filhos de Oolibama, mulher de Esaú: os chefes Jeús, Jalão e Corá. Foram esses os chefes descendentes de Oolibama, mulher de Esaú, filha de Aná. ");
INSERT INTO poronbv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Aí estão, pois, os filhos e netos de Esaú, chefes de grupos de famílias. Esaú também é conhecido como Edom. ");
INSERT INTO poronbv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Estes foram os filhos de Seir, o horeu, moradores daquela região: Lotã, Sobal, Zibeão e Aná, ");
INSERT INTO poronbv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disom, Ézer e Disã. Esses filhos de Seir foram chefes dos horeus na terra de Edom. ");
INSERT INTO poronbv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Os filhos de Lotã são Hori e Hemã. A irmã de Lotã era Timna. ");
INSERT INTO poronbv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","São estes os filhos de Sobal: Alvã, Manaate, Ebal, Sefô e Onã. ");
INSERT INTO poronbv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","São estes os filhos de Zibeão: Aiá e Aná. Foi Aná que descobriu as fontes de águas quentes no deserto, quando pastoreava os jumentos do seu pai Zibeão. ");
INSERT INTO poronbv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","São estes os filhos de Aná: Disom e Oolibama, a filha de Aná. ");
INSERT INTO poronbv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","São estes os filhos de Disom: Hendã, Esbã, Itrã e Querã. ");
INSERT INTO poronbv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","São estes os filhos de Ézer: Bilã, Zaavã e Acã. ");
INSERT INTO poronbv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","São estes os filhos de Disã: Uz e Arã. ");
INSERT INTO poronbv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","São estes os chefes dos horeus: Lotã, Sobal, Zibeão, Aná, ");
INSERT INTO poronbv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disom, Ézer e Disã. ");
INSERT INTO poronbv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","São estes os reis que reinaram na terra de Edom, antes de haver rei sobre os israelitas. ");
INSERT INTO poronbv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Belá, filho de Beor, reinou em Edom, na cidade de Dinabá. ");
INSERT INTO poronbv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Quando Belá morreu, reinou em seu lugar, Jobabe filho de Zerá, de Bozra. ");
INSERT INTO poronbv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Quando Jobabe morreu, reinou em seu lugar Husã, da terra dos temanitas. ");
INSERT INTO poronbv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Quando Husã morreu, reinou em seu lugar Hadade, filho de Bedade, da cidade de Avite. Hadade comandou as forças que derrotaram os midianitas, quando invadiram o território de Moabe. ");
INSERT INTO poronbv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Quando Hadade morreu, reinou em seu lugar Samlá de Masreca. ");
INSERT INTO poronbv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Quando Samlá morreu, reinou em seu lugar Saul, de Reobote, próxima ao rio Eufrates. ");
INSERT INTO poronbv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Quando Saul morreu, reinou em seu lugar Baal-Hanã, filho de Acbor. ");
INSERT INTO poronbv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Quando Baal-Hanã, filho de Acbor morreu, reinou em seu lugar Hadar, da cidade de Paú. A mulher de Hadar era Meetabel, filha de Matrede e neta de Mezaabe. ");
INSERT INTO poronbv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","São estes os chefes, descendentes de Esaú, conforme as suas famílias, seus lugares e seus nomes: Timna, Alva, Jetete, ");
INSERT INTO poronbv_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oolibama, Elá, Pinom, ");
INSERT INTO poronbv_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Quenaz, Temã, Mibzar, ");
INSERT INTO poronbv_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel e Irã. Esses são os chefes de Edom; cada um fixou-se numa região da terra que ocupavam. Os edomitas são descendentes de Esaú. ");
INSERT INTO poronbv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacó voltou a habitar na terra de Canaã, onde seu pai tinha morado como estrangeiro. ");
INSERT INTO poronbv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","A história da família de Jacó é a seguinte: Quando José tinha dezessete anos, o trabalho dele era pastorear os rebanhos com os seus irmãos. Como era ainda muito jovem, ele acompanhava os filhos de Bila e de Zilpa, mulheres de seu pai. Quando voltava do campo, José contava ao pai as más notícias a respeito dos seus irmãos. ");
INSERT INTO poronbv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Na verdade, José era o filho preferido de Israel, porque nasceu quando o pai já era muito idoso. Certo dia José ganhou uma túnica longa de diversas cores. ");
INSERT INTO poronbv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Quando os irmãos viram que o pai o amava mais do que a todos os outros filhos, odiaram-no e já não conseguiam falar amigavelmente com ele. ");
INSERT INTO poronbv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Certa noite José teve um sonho e, quando contou esse sonho a seus irmãos, eles ficaram com ainda mais ódio dele. ");
INSERT INTO poronbv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","“Peço que ouçam o sonho que tive”, disse-lhes. ");
INSERT INTO poronbv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","“Vejam só! Sonhei que estávamos amarrando os feixes de trigo no campo, quando o meu feixe se levantou e ficou em pé, e os seus feixes o rodearam e se inclinaram diante dele!” ");
INSERT INTO poronbv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Seus irmãos disseram: “Você está querendo dizer que vai reinar sobre nós, ou que vai nos governar?” Por causa dos seus sonhos e das suas palavras, o ódio deles aumentava cada vez mais. ");
INSERT INTO poronbv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","José teve outro sonho e o contou aos seus irmãos: “Sonhei que o sol, a lua e onze estrelas se inclinavam diante de mim”. ");
INSERT INTO poronbv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Quando contou o sonho ao pai e a seus irmãos, o pai o repreendeu, dizendo: “Que sonho é esse? Então você acha que eu, a sua mãe e os seus irmãos vamos ter de nos inclinar até o chão diante de você?” ");
INSERT INTO poronbv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Os irmãos ficaram com inveja de José. O pai, no entanto, meditava sobre o que ouvia. ");
INSERT INTO poronbv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Certo dia os irmãos de José levaram os rebanhos de seu pai para perto de Siquém, ");
INSERT INTO poronbv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","e Israel disse a José: “Os seus irmãos não estão cuidando do rebanho em Siquém? Quero que você vá até lá”. “Sim, senhor” respondeu-lhe. ");
INSERT INTO poronbv_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Israel lhe disse: “Vá lá ver como estão seus irmãos e os rebanhos, e traga-me notícias deles”. José obedeceu e partiu do vale de Hebrom para Siquém. ");
INSERT INTO poronbv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Um homem o encontrou perdido pelos campos e perguntou a ele: “Que é que você está procurando?” ");
INSERT INTO poronbv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","José respondeu: “Estou procurando os meus irmãos. O senhor pode me dizer onde eles estão cuidando dos rebanhos?” ");
INSERT INTO poronbv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","O homem disse: “Já não estão aqui. Ouvi quando falavam: ‘Vamos a Dotã’ ”. Então José foi em busca dos seus irmãos e os encontrou próximo de Dotã. ");
INSERT INTO poronbv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Mas eles o viram de longe e, antes que se aproximasse, tramaram uma forma de matá-lo. ");
INSERT INTO poronbv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","E diziam uns aos outros: “Lá vem o sonhador! ");
INSERT INTO poronbv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Vamos matá-lo e jogar o corpo dele num destes poços. Depois diremos que ele foi morto por um animal selvagem. Então veremos em que vão dar os seus sonhos!” ");
INSERT INTO poronbv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Quando Rúben ouviu o plano dos irmãos, quis livrá-lo, dizendo: “Não vamos matar o nosso irmão!” ");
INSERT INTO poronbv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","E acrescentou: “Não derramem sangue. Joguem-no neste poço no deserto, mas não coloquem as mãos nele”. Rúben disse isso com a intenção de libertá-lo mais tarde e devolvê-lo ao pai. ");
INSERT INTO poronbv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Então, quando José chegou, seus irmãos arrancaram a sua túnica longa e colorida, ");
INSERT INTO poronbv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","agarraram-no e o jogaram no poço vazio, sem água. ");
INSERT INTO poronbv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Mais tarde, quando estavam sentados, comendo pão, viram que uma caravana de ismaelitas vinha de Gileade. Os camelos estavam carregados de perfumes, bálsamo e mirra, que estavam levando para o Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Judá disse aos seus irmãos: “Que vantagem teremos em matar o nosso irmão, esconder a sua morte e ficar com esse peso na consciência? ");
INSERT INTO poronbv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Vamos vendê-lo aos ismaelitas. Afinal, ele é nosso irmão, é do nosso sangue”. E seus irmãos concordaram. ");
INSERT INTO poronbv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Assim, quando os mercadores ismaelitas passaram por ali, os irmãos de José o tiraram do poço e o venderam aos ismaelitas por vinte moedas de prata, que o levaram para o Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Quando Rúben voltou ao poço, viu que José não estava nele. Então, rasgou as suas roupas, cheio de aflição. ");
INSERT INTO poronbv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","E, voltando-se para os seus irmãos, disse: “O menino não está lá! Para onde irei agora?” ");
INSERT INTO poronbv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Então eles pegaram a túnica de José, mataram um bode e mergulharam a túnica no sangue do animal. ");
INSERT INTO poronbv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Depois mandaram a túnica longa e colorida, cheia de sangue, ao pai, com este recado: “Achamos isto no campo. Será que é a túnica de seu filho?” ");
INSERT INTO poronbv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jacó a reconheceu e disse: “É a túnica de meu filho! Provavelmente um animal selvagem o devorou! Certamente José foi despedaçado!” ");
INSERT INTO poronbv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Então Jacó rasgou as suas roupas e se vestiu com pano de saco e chorou muitos dias pela morte de seu filho. ");
INSERT INTO poronbv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Todos os seus filhos e filhas procuraram consolar Jacó. Ele, porém, recusou ser consolado, dizendo: “Vou chorar a morte do meu filho até morrer”. E continuou a chorar. ");
INSERT INTO poronbv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Enquanto isso, os mercadores de Midiã venderam José a Potifar no Egito, oficial do faraó, comandante da guarda. ");
INSERT INTO poronbv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nessa época, Judá saiu de casa e passou a viver na casa de um homem de Adulão, chamado Hira. ");
INSERT INTO poronbv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ali Judá conheceu a filha do cananeu Sua, casou-se e teve relações com ela. ");
INSERT INTO poronbv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ela engravidou e deu à luz um filho, e o pai o chamou de Er. ");
INSERT INTO poronbv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Engravidou de novo e deu à luz um filho, e deu-lhe o nome de Onã. ");
INSERT INTO poronbv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ela deu à luz ainda um terceiro filho e chamou-o de Selá, quando morava em Quezibe. ");
INSERT INTO poronbv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Quando Er, o filho mais velho, cresceu, Judá arranjou um casamento para ele com uma mulher chamada Tamar. ");
INSERT INTO poronbv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er, o filho mais velho de Judá, porém, levava uma vida perversa aos olhos do Senhor, e o Senhor mesmo o fez morrer. ");
INSERT INTO poronbv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Então Judá disse a Onã, irmão de Er: “Case-se com a mulher do seu irmão e cumpra as suas obrigações de cunhado, para que o seu irmão tenha descendentes por seu intermédio”. ");
INSERT INTO poronbv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onã, porém, não queria ter filhos que não tivessem o seu nome. Por isso, todas as vezes que se deitava com Tamar, deixava cair o líquido seminal no chão. Ele fazia isso para evitar que seu irmão tivesse descendentes. ");
INSERT INTO poronbv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","O Senhor reprovou essa atitude e por isso também o fez morrer. ");
INSERT INTO poronbv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Então disse Judá a Tamar, sua nora: “Vá para a casa de seus pais e permaneça viúva até que Selá, meu filho, cresça”. A intenção de Judá era evitar que acontecesse com o filho mais moço o mesmo que havia ocorrido com os dois irmãos dele. Então Tamar voltou para a casa dos pais dela. ");
INSERT INTO poronbv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Passou o tempo, e a filha de Sua, mulher de Judá, morreu. Depois que terminou o tempo costumeiro de luto, Judá foi ver os tosquiadores do seu rebanho em Timna, com o seu amigo Hira, o adulamita. ");
INSERT INTO poronbv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Alguém contou a Tamar: “O seu sogro está indo a Timna, para tosquiar as ovelhas”. ");
INSERT INTO poronbv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Então, ela trocou as roupas de sua viuvez, cobriu-se com um véu, se disfarçou e ficou sentada à beira da estrada de Timna, próximo da entrada da cidade de Enaim. Tamar fez isso porque viu que Selá já era homem, e nem ele nem seu pai falavam em casamento. ");
INSERT INTO poronbv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Quando Judá a viu, pensou que fosse uma prostituta, porque ela estava com o rosto coberto pelo véu. ");
INSERT INTO poronbv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Então Judá se dirigiu a ela, e lhe disse: “Vem, deita comigo”. Ele não sabia que era a sua nora. Ela perguntou: “Quanto você me pagará para deitar-me com você?” ");
INSERT INTO poronbv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ele respondeu: “Mandarei a você um cabrito do meu rebanho”. E ela perguntou: “Que garantia me dá de que mandará o pagamento?” ");
INSERT INTO poronbv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Judá disse: “Bem, o que você quer como garantia?” “Quero o seu selo de identificação com o cordão e o cajado que você está segurando”, respondeu ela. Ele deu a ela essas coisas, e teve relações com ela. E Tamar ficou grávida. ");
INSERT INTO poronbv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Depois disso, Tamar tirou o véu e voltou a vestir as roupas de viúva. ");
INSERT INTO poronbv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judá encarregou seu amigo adulamita de entregar o cabrito prometido àquela mulher, a fim de reaver as coisas que tinha deixado com ela como garantia. Mas ele não a encontrou. ");
INSERT INTO poronbv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Então perguntou aos homens daquele lugar: “Onde posso encontrar aquela prostituta que costumava ficar à beira do caminho de Enaim?” Eles responderam: “Nunca vimos nenhuma prostituta ali”. ");
INSERT INTO poronbv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Voltando para Timna, Hira disse a Judá: “Não a encontrei. Além do mais, os homens daquele lugar disseram que nunca viram uma prostituta ali”. ");
INSERT INTO poronbv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judá respondeu: “Que ela fique com as minha coisas. Dessa forma ninguém vai zombar de nós. Afinal, mandei a ela este cabritinho, mas você não a encontrou”. ");
INSERT INTO poronbv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Cerca de três meses mais tarde, disseram a Judá: “Tamar, sua nora, agiu como prostituta, pois está grávida”. Judá disse: “Tragam-na para fora para que seja queimada!” ");
INSERT INTO poronbv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Quando a tiraram, ela mandou dizer ao sogro: “Estou grávida do homem que é dono destas coisas”. E acrescentou: “Veja se o senhor reconhece de quem é este selo, este cordão e este cajado”. ");
INSERT INTO poronbv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judá reconheceu-os e disse: “Ela é mais correta do que eu, pois eu não a dei ao meu filho Selá”. E nunca mais voltou a ter relações com ela. ");
INSERT INTO poronbv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Quando chegou a época de dar à luz, havia gêmeos em seu ventre. ");
INSERT INTO poronbv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Enquanto ela dava à luz, um pôs a mão para fora; então a parteira amarrou um fio vermelho no pulso do menino, dizendo: “Este saiu primeiro”. ");
INSERT INTO poronbv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mas quando ele recolheu a mão, saiu seu irmão, e ela disse: “Como foi que você conseguiu encontrar uma brecha para sair?” Por esse motivo deram a ele o nome de Perez. ");
INSERT INTO poronbv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Logo depois saiu seu irmão, que estava com o fio no pulso. Deram a ele o nome de Zerá. ");
INSERT INTO poronbv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Quando José foi levado para o Egito, foi vendido pelos ismaelitas que o tinham levado para lá ao egípcio Potifar, oficial do faraó e comandante da guarda. ");
INSERT INTO poronbv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","O Senhor estava com José e o abençoava em tudo o que fazia, e ele passou a morar na casa do seu senhor egípcio. ");
INSERT INTO poronbv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Quando Potifar percebeu que o Senhor estava com José e que o abençoava em tudo o que fazia, José ");
INSERT INTO poronbv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ganhou a simpatia do seu senhor, que o colocou como administrador de sua casa e confiou a ele tudo o que possuía. ");
INSERT INTO poronbv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Desde o momento em que José foi nomeado administrador de sua casa e de todos os seus bens, o Senhor abençoou a casa do egípcio por causa de José. A bênção do Senhor estava sobre tudo o que ele tinha, tanto nos negócios da casa como no campo. ");
INSERT INTO poronbv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Assim, Potifar deixou tudo o que tinha aos cuidados de José, a tal ponto que não se preocupava com nada. A única coisa que Potifar resolvia pessoalmente era em relação à sua própria comida. José era formoso e atraente. ");
INSERT INTO poronbv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Certo dia, a mulher do seu senhor começou a cobiçar José e o convidou: “Venha para a cama comigo!” ");
INSERT INTO poronbv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mas ele se recusou e disse a ela: “O meu senhor confiou a mim tudo o que é dele. Ele nem sabe o que existe na casa, porque deixou tudo sob a minha responsabilidade. ");
INSERT INTO poronbv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ninguém nesta casa está acima de mim. Ele não me privou de coisa alguma, a não ser da senhora, porque é a sua mulher. Como poderia eu, então, cometer tamanha maldade e pecar contra Deus?” ");
INSERT INTO poronbv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","A mulher não desistiu. Ela insistia dia após dia com José, mas ele se recusava a deitar-se com ela e procurava não ficar perto dela. ");
INSERT INTO poronbv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Um dia José foi até a casa para cuidar dos negócios, e nenhum empregado se achava presente. ");
INSERT INTO poronbv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Então ela o agarrou pela capa e voltou a convidá-lo: “Venha para a cama comigo!” Mas José fugiu para fora da casa, deixando a capa nas mãos dela. ");
INSERT INTO poronbv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Quando a mulher viu que ele tinha fugido, e que estava com a capa dele, ");
INSERT INTO poronbv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","chamou os empregados da casa e lhes disse: “Vejam só! Esse hebreu que foi trazido pelo meu marido para me insultar entrou aqui e quis me forçar a ir para a cama com ele. Mas eu gritei o mais alto que pude. ");
INSERT INTO poronbv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Quando ele ouviu que eu gritava bem alto, fugiu, esquecendo a capa dele aqui ao meu lado”. ");
INSERT INTO poronbv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ela guardou a capa de José até que o seu senhor chegasse em casa. ");
INSERT INTO poronbv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Então, contou ao marido a mesma história. Disse ela: “Esse escravo hebreu que você trouxe se aproximou de mim para me insultar. ");
INSERT INTO poronbv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mas quando gritei por ajuda, ele largou sua capa ao meu lado e fugiu”. ");
INSERT INTO poronbv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Quando o seu senhor ouviu o que sua mulher lhe disse: “Foi assim que o seu escravo agiu comigo”, ficou irado. ");
INSERT INTO poronbv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","E o senhor de José mandou buscá-lo e o lançou na prisão, no lugar onde ficavam os presos do rei. E ele ficou na prisão. ");
INSERT INTO poronbv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mas o Senhor estava com José e derramou a sua bondade sobre ele, de maneira que ele conquistou a simpatia do carcereiro. ");
INSERT INTO poronbv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Assim, o carcereiro encarregou José de cuidar dos presos que estavam naquela prisão; e ele fazia tudo o que era necessário fazer ali. ");
INSERT INTO poronbv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","O carcereiro deixou de se preocupar com o que acontecia na cadeia, porque José cuidava de tudo. E o Senhor estava com José e o abençoava em tudo que fazia. ");
INSERT INTO poronbv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Algum tempo depois, o chefe dos copeiros e o padeiro real ofenderam o seu senhor, o rei do Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","O Faraó ficou indignado com seus dois oficiais, o chefe dos copeiros e o chefe dos padeiros, ");
INSERT INTO poronbv_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","e mandou prendê-los na casa do comandante da guarda, na mesma prisão em que José estava. ");
INSERT INTO poronbv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","O comandante da guarda encarregou José de cuidar deles. Ficaram lá presos por algum tempo. ");
INSERT INTO poronbv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Certa noite, os dois tiveram um sonho. O chefe dos copeiros e o chefe dos padeiros perceberam que cada sonho tinha seu próprio significado. ");
INSERT INTO poronbv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Na manhã seguinte, José notou que ambos estavam abatidos. ");
INSERT INTO poronbv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Então perguntou aos oficiais do faraó, que também estavam presos na casa do seu senhor: “O que aconteceu? Por que vocês estão tão tristes?” ");
INSERT INTO poronbv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Eles responderam: “Cada um de nós teve um sonho esta noite, mas ninguém aqui é capaz de interpretá-los”. Disse-lhes José: “Não pertence a Deus a interpretação de sonhos? Contem-me os sonhos”. ");
INSERT INTO poronbv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Então o chefe dos copeiros contou o seu sonho a José. Ele disse: “Em meu sonho havia uma videira na minha frente, ");
INSERT INTO poronbv_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","com três ramos. Ela brotou, depois produziu flores, que por sua vez deram cachos de uvas maduras. ");
INSERT INTO poronbv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","A taça do faraó estava na minha mão. Peguei as uvas e as espremi na taça do faraó, e a entreguei pessoalmente em sua mão”. ");
INSERT INTO poronbv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Então José lhe disse: “Esta é a interpretação: Os três ramos são três dias. ");
INSERT INTO poronbv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dentro de três dias, o faraó vai mandar soltar você e restaurá-lo ao seu cargo como chefe dos copeiros, e você servirá a taça pessoalmente a ele, como costumava fazer quando você era o copeiro. ");
INSERT INTO poronbv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Agora, ouça. Quando tudo estiver bem com você, lembre-se de mim. Peço que seja bondoso comigo e fale de mim ao faraó para me tirar desta prisão, ");
INSERT INTO poronbv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","porque me tiraram da terra dos hebreus à força; e não fiz nada para merecer estar neste lugar”. ");
INSERT INTO poronbv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","O chefe dos padeiros ficou entusiasmado ao ouvir a boa interpretação, e também contou o seu sonho a José. “No meu sonho”, disse ele, “vi três cestas de pão branco empilhadas sobre a minha cabeça. ");
INSERT INTO poronbv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Na cesta de cima havia todo tipo de comidas gostosas que o faraó costumava comer. Mas as aves vieram e comeram da cesta que eu trazia na cabeça”. ");
INSERT INTO poronbv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","E José lhe disse: “A interpretação é esta: As três cestas significam três dias. ");
INSERT INTO poronbv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dentro de três dias, o faraó vai mandar cortar a sua cabeça e pendurar você num poste. E as aves vão comer a sua carne!” ");
INSERT INTO poronbv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Três dias depois, era o aniversário do faraó. Ele deu um grande banquete a todos os oficiais e a todo o pessoal de serviço do palácio. No meio da festa, ele mandou soltar o chefe dos copeiros e o chefe dos padeiros e mandou que viessem ao banquete. ");
INSERT INTO poronbv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ele reintegrou o chefe dos copeiros, que voltou a servir pessoalmente ao faraó. ");
INSERT INTO poronbv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mas o chefe dos padeiros teve seu corpo pendurado numa estaca, como José tinha anunciado. ");
INSERT INTO poronbv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Entretanto, o chefe dos copeiros não se lembrou de José. Não pensou mais nele. ");
INSERT INTO poronbv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Depois de dois anos completos, o faraó teve um sonho. Nesse sonho ele estava em pé, na margem do rio Nilo. ");
INSERT INTO poronbv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ele viu sair das águas sete vacas belas e gordas que ficaram pastando no capinzal. ");
INSERT INTO poronbv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Depois viu sair do rio sete vacas feias e magras. Elas pararam ao lado das gordas, na beira do rio. ");
INSERT INTO poronbv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Então as vacas feias e magras comeram as belas e gordas. Aí o faraó acordou. ");
INSERT INTO poronbv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Depois dormiu de novo e teve outro sonho. Ele sonhou que num só talo nasciam sete espigas cheias e boas. ");
INSERT INTO poronbv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Em seguida brotaram mais sete espigas do mesmo talo, porém miúdas e ressequidas pelo vento leste. ");
INSERT INTO poronbv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","E as espigas miúdas devoraram as sete espigas cheias e boas. Nisso o faraó acordou e percebeu que era um sonho. ");
INSERT INTO poronbv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","De manhã, ficou muito preocupado com os sonhos que teve e mandou chamar todos os magos e todos os sábios do Egito, e contou-lhes os sonhos; mas ninguém foi capaz de interpretá-los. ");
INSERT INTO poronbv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Só então o chefe dos copeiros lembrou-se de José e disse ao faraó: “Hoje preciso confessar o meu erro! ");
INSERT INTO poronbv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Certa vez, Vossa Majestade ficou indignado com os seus servos e mandou prender-me junto com o chefe dos padeiros, na casa do comandante da guarda. ");
INSERT INTO poronbv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Na mesma noite, nós dois tivemos um sonho. Cada sonho tinha uma interpretação diferente. ");
INSERT INTO poronbv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Estava conosco um jovem hebreu, servo do comandante da guarda. Contamos a ele os nossos sonhos, e ele interpretou cada um dos sonhos. ");
INSERT INTO poronbv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","E aconteceu exatamente conforme a sua interpretação: eu voltei para o meu cargo, e o outro foi pendurado num poste”. ");
INSERT INTO poronbv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Então o faraó mandou buscar José, que foi tirado às pressas do calabouço. José fez a barba, trocou de roupa, e se apresentou ao faraó. ");
INSERT INTO poronbv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","O faraó disse a José: “Tive um sonho, e ninguém consegue interpretá-lo. Ouvi dizer que quando você ouve um sonho, é capaz de interpretá-lo”. ");
INSERT INTO poronbv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","José lhe respondeu: “Eu mesmo não posso fazê-lo, mas Deus vai dar uma resposta favorável ao faraó”. ");
INSERT INTO poronbv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Então o faraó contou o sonho a José: “Sonhei que estava em pé, na beira do rio Nilo. ");
INSERT INTO poronbv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","De repente vi que sete vacas belas e gordas saíram do rio e ficaram pastando no capinzal. ");
INSERT INTO poronbv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Logo depois saíram outras vacas feias e magras. Nunca vi vacas tão feias em toda a terra do Egito! ");
INSERT INTO poronbv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","E as vacas magras e feias comeram as primeiras sete vacas gordas. ");
INSERT INTO poronbv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","E, para meu espanto, notei que essas vacas continuavam muito magras, mesmo depois de terem comido as outras! Então acordei. ");
INSERT INTO poronbv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Dormi de novo e tive outro sonho. Sonhei que de um só talo saíam sete espigas cheias e boas. ");
INSERT INTO poronbv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Depois nasceram no mesmo talo sete espigas miúdas e murchas, ressequidas pelo vento leste. ");
INSERT INTO poronbv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","E as espigas magras engoliram as sete espigas boas. Contei os sonhos aos magos, mas ninguém foi capaz de dizer o sentido deles”. ");
INSERT INTO poronbv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Então, José lhe respondeu: “Os dois sonhos, na verdade, são um só. Deus revelou ao faraó o que ele vai fazer”. ");
INSERT INTO poronbv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","As sete vacas boas simbolizam sete anos; a mesma coisa ocorre com as espigas, porque se trata de um único sonho. ");
INSERT INTO poronbv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","As sete vacas magras e feias que apareceram depois das vacas gordas, bem como as sete espigas miúdas, ressequidas pelo vento leste, simbolizam sete anos de fome. ");
INSERT INTO poronbv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Exatamente o que Deus revelou ao faraó é o que ele vai fazer. ");
INSERT INTO poronbv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Virão sete anos de muita fartura em toda a terra do Egito, ");
INSERT INTO poronbv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","mas depois vamos ter sete anos de fome. A miséria será tanta que ninguém na terra do Egito se lembrará da fartura anterior, pois a fome arruinará a terra. ");
INSERT INTO poronbv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","A fome que virá depois será tão terrível que o tempo de fartura não mais será lembrado na terra. ");
INSERT INTO poronbv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","O sonho do faraó foi duplo, para mostrar que essas coisas foram determinadas por Deus, e que ele se apressa em realizá-las. ");
INSERT INTO poronbv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Agora dou a seguinte sugestão ao faraó: O faraó deve escolher um homem criterioso e sábio para comandar a terra do Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","O faraó também deve nomear administradores sobre a terra, para recolher a quinta parte de toda a colheita da terra do Egito durante os sete anos de fartura. ");
INSERT INTO poronbv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Esses administradores deverão recolher toda a colheita de trigo dos anos bons que virão, o qual será estocado em armazéns, sob o controle do faraó, para mantimento nas cidades. ");
INSERT INTO poronbv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Esse mantimento servirá como reserva para os sete anos de fome que haverá no Egito, para que a nação sobreviva à crise”. ");
INSERT INTO poronbv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","O faraó e os seus oficiais gostaram do conselho de José. ");
INSERT INTO poronbv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","O faraó disse aos seus oficiais: “Será que encontraríamos alguém como este homem, em quem está o Espírito de Deus?” ");
INSERT INTO poronbv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Em seguida o faraó disse a José: “Visto que Deus lhe fez saber todas estas coisas, não há ninguém tão criterioso e sábio como você. ");
INSERT INTO poronbv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Por isso, você será o administrador da minha casa, e todo o meu povo obedecerá às suas ordens. Somente em relação ao trono real serei maior do que você”. ");
INSERT INTO poronbv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","E acrescentou: “Dou autoridade a você sobre toda a terra do Egito”. ");
INSERT INTO poronbv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Em seguida, o faraó tirou do seu dedo o seu anel com o selo real, e o colocou no dedo de José. Mandou vestir nele roupas de linho fino e colocou um colar de ouro ao redor do seu pescoço (como era costume entre os homens poderosos daquela época). ");
INSERT INTO poronbv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Também o fez subir em sua segunda carruagem e mandou que os homens fossem na frente, gritando a todos: “Prestem homenagem a José! Inclinem-se diante dele”. Dessa forma, o faraó nomeou José como a maior autoridade sobre toda a terra do Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","O faraó também disse a José: “Eu sou o faraó, mas sem a sua ordem ninguém poderá mover a mão ou o pé em toda a terra do Egito”. ");
INSERT INTO poronbv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","O faraó chamou José de Zafenate-Paneia e lhe deu por mulher Azenate, filha de Potífera, sacerdote de Om. Depois José foi inspecionar a terra do Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","José tinha trinta anos quando se apresentou ao faraó, rei do Egito. Ele viajou por todo o Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Nos sete anos de fartura a terra produziu em abundância. ");
INSERT INTO poronbv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","José recolheu todos os cereais da terra do Egito nos sete anos de fartura e os armazenou nas cidades. Em cada cidade ele armazenava os cereais colhidos nos campos que ficavam próximos dela. ");
INSERT INTO poronbv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Assim, a quantidade de cereais que José conseguiu armazenar foi enorme, como a areia do mar. O mantimento era tanto que ele parou de anotar, porque ia além das medidas conhecidas. ");
INSERT INTO poronbv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Antes de chegar o período de fome, Azenate, filha de Potífera, sacerdote de Om, deu dois filhos a José. ");
INSERT INTO poronbv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ao primeiro, José deu o nome de Manassés, dizendo: “Deus me fez esquecer de todos os meus sofrimentos e de toda a casa de meu pai”. ");
INSERT INTO poronbv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ao segundo filho José deu o nome de Efraim. Disse José na ocasião: “Deus me fez prosperar na terra onde tenho sofrido”. ");
INSERT INTO poronbv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Depois de sete anos de fartura na terra do Egito, ");
INSERT INTO poronbv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","começaram os sete anos de fome, como José havia predito. E houve fome em todas as terras, mas no Egito o povo tinha com que se alimentar. ");
INSERT INTO poronbv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Quando o povo do Egito começou a sentir fome, clamou ao faraó por pão. O faraó respondeu a todos os egípcios: “Dirijam-se a José e façam o que ele disser”. ");
INSERT INTO poronbv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Quando a fome se estendeu por toda a terra, José mandou abrir os armazéns e começou a vender cereais aos egípcios. ");
INSERT INTO poronbv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Além disso, vinha gente de muitos lugares ao Egito para comprar de José, porque a fome atingiu uma enorme região. ");
INSERT INTO poronbv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jacó ficou sabendo que no Egito havia mantimento. Então disse aos seus filhos: “Vocês acham que adianta ficar olhando uns para os outros?” ");
INSERT INTO poronbv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","E acrescentou: “Ouvi dizer que há trigo no Egito. Desçam até lá e comprem mantimento para que continuemos vivos e não morramos”. ");
INSERT INTO poronbv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Então desceram dez irmãos de José para comprar cereal no Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Jacó não permitiu que Benjamim, irmão de José, fosse com eles, dizendo: “É melhor que ele fique, pois poderia acontecer algum mal a ele”. ");
INSERT INTO poronbv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Os filhos de Israel foram comprar mantimentos junto com outras pessoas, porque havia fome na terra de Canaã. ");
INSERT INTO poronbv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","José era governador do Egito. Era ele quem vendia a todos os que precisavam. Os irmãos de José foram à sua presença e se inclinaram, com o rosto no chão, diante dele. ");
INSERT INTO poronbv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","José logo reconheceu seus irmãos, porém fez de conta que não os conhecia, e lhes perguntou de forma áspera: “De onde vocês vêm?” Eles responderam: “Da terra de Canaã. Viemos comprar mantimentos”. ");
INSERT INTO poronbv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","José reconheceu os seus irmãos, mas eles não o reconheceram. ");
INSERT INTO poronbv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Então, José lembrou-se dos sonhos que tinha tido a respeito deles e lhes disse: “Vocês são espiões e estão querendo descobrir os pontos fracos do Egito”. ");
INSERT INTO poronbv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","“Não, senhor!”, responderam eles. “Estes seus servos vieram aqui comprar mantimentos. ");
INSERT INTO poronbv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Somos todos filhos do mesmo pai. Somos homens honestos. Os seus servos não são espiões”. ");
INSERT INTO poronbv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","José insistiu: “Nada disso! Vocês vieram conhecer os pontos fracos do país”. ");
INSERT INTO poronbv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Eles disseram: “Seus servos eram doze irmãos, todos filhos de um homem que mora em Canaã. O mais novo ficou em casa com o pai, e o outro já não existe mais”. ");
INSERT INTO poronbv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","José voltou a falar: “É como já lhes disse: Vocês são espiões!” ");
INSERT INTO poronbv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ele prosseguiu: “Há um jeito de provar o que dizem. Juro pela vida do faraó que vocês não sairão daqui enquanto não apresentarem aqui o seu irmão mais novo. ");
INSERT INTO poronbv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Um de vocês deve trazê-lo e os demais ficarão detidos. Assim ficará provado se vocês disseram a verdade. Se não, juro pela vida do faraó que ficará provado que vocês são espiões”. ");
INSERT INTO poronbv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Em seguida os colocou numa prisão por três dias. ");
INSERT INTO poronbv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Três dias depois José voltou a falar com eles: “Vou dar uma oportunidade a vocês para salvarem a vida, pois temo a Deus. ");
INSERT INTO poronbv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Se vocês são homens honestos, deixem um dos seus irmãos aqui na prisão, enquanto os outros vão levar os mantimentos para matar a fome dos seus familiares. ");
INSERT INTO poronbv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Depois, tragam-me o irmão mais novo de vocês. Assim vocês provarão que estão dizendo a verdade e não serão mortos”. Eles concordaram. ");
INSERT INTO poronbv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Então disseram uns aos outros: “Na verdade, somos culpados e estamos sofrendo por aquilo que fizemos a nosso irmão. Vimos a sua aflição, quando suplicava para que tivéssemos pena dele, mas não lhe demos ouvidos. Por isso estamos passando por esta angústia”. ");
INSERT INTO poronbv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rúben respondeu: “Eu não lhes disse que não maltratassem o menino? Mas vocês não quiseram me ouvir. Pois agora teremos de prestar contas do sangue dele”. ");
INSERT INTO poronbv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Eles, porém, não desconfiavam que José podia compreendê-los, porque ele falava por meio de um intérprete. ");
INSERT INTO poronbv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","José se retirou e começou a chorar; depois voltou para falar de novo com eles, e algemou Simeão diante deles. ");
INSERT INTO poronbv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","José deu ordens para que enchessem de cereal os sacos e mandou devolver o pagamento de cada um deles, colocando o dinheiro dentro dos sacos. Além disso, mandou preparar mantimentos para a viagem deles. E assim foi feito. ");
INSERT INTO poronbv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Eles puseram os sacos de cereal sobre os lombos dos jumentos e partiram. ");
INSERT INTO poronbv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Quando estavam alojados num lugar para pernoitar, um deles foi dar de comer ao seu jumento. Ao abrir o saco, viu o dinheiro. ");
INSERT INTO poronbv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Então disse aos irmãos: “Devolveram o meu dinheiro! Encontrei-o na boca do saco”. Todos ficaram assustados e, cheios de medo, disseram uns aos outros: “O que Deus fez conosco?” ");
INSERT INTO poronbv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Quando chegaram à casa de seu pai Jacó, na terra de Canaã, contaram ao pai tudo o que tinha acontecido, dizendo: ");
INSERT INTO poronbv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“O governador do Egito falou de forma áspera conosco e nos tratou como se fôssemos espiões. ");
INSERT INTO poronbv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Mas nós dissemos: ‘Somos homens honestos, e não espiões. ");
INSERT INTO poronbv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Somos doze irmãos por parte de pai. Um não existe mais, e o mais novo está com nosso pai na terra de Canaã’. ");
INSERT INTO poronbv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Mas aquele homem que governa aquela terra respondeu: ‘Só há um modo de vocês provarem que são honestos. Um dos irmãos ficará detido aqui. Os outros podem voltar para casa, levando o mantimento para matar a fome das famílias de vocês. ");
INSERT INTO poronbv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Depois, tragam-me o seu irmão mais novo, para que fique provado que vocês não são espiões, mas sim homens honestos. Então soltarei o seu irmão, e vocês poderão negociar nesta terra’ ”. ");
INSERT INTO poronbv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ao esvaziarem os sacos de cereais, perceberam que em cada saco estava o dinheiro, amarrado em saquinhos. Quando eles e o pai viram os saquinhos com o dinheiro, ficaram com muito medo. ");
INSERT INTO poronbv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Então disse-lhes seu pai Jacó: “Vocês estão tirando os filhos de mim. José já não existe mais, e Simeão não está aqui. E agora querem levar Benjamim! Quanto sofrimento!” ");
INSERT INTO poronbv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Então Rúben disse ao pai: “Pode matar os meus dois filhos se eu não o trouxer de volta. Deixe Benjamim aos meus cuidados, e eu o trarei de volta”. ");
INSERT INTO poronbv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ele, porém, respondeu: “Meu filho não descerá com vocês. O seu irmão morreu, e ele é o único que me resta. Se acontecer algum mal na viagem, vocês me matariam de tristeza”. ");
INSERT INTO poronbv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","A fome persistia e se tornava cada vez pior na terra. ");
INSERT INTO poronbv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Quando acabou o cereal que os filhos de Israel tinham trazido do Egito, disse-lhes seu pai: “Voltem e comprem um pouco mais de mantimento”. ");
INSERT INTO poronbv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Mas Judá lhe respondeu: “O homem nos advertiu seriamente: ‘Não me verão se o irmão de vocês não vier com vocês’. ");
INSERT INTO poronbv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Se o senhor enviar o nosso irmão conosco, desceremos e compraremos mantimento. ");
INSERT INTO poronbv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mas se não o enviar, não desceremos, porque o homem nos disse: ‘Não me verão se o irmão de vocês não vier com vocês’ ”. ");
INSERT INTO poronbv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel perguntou: “Por que me causaram esse mal contando àquele homem que tinham outro irmão?” ");
INSERT INTO poronbv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Eles responderam: “O homem nos perguntou a respeito de nós e de nossa família. Ele perguntou: ‘O pai de vocês ainda está vivo? Vocês têm outro irmão?’ Nós apenas respondemos às perguntas dele. Como poderíamos imaginar que ele faria esta exigência: ‘Tragam o seu irmão?’ ” ");
INSERT INTO poronbv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judá voltou a falar com o seu pai Israel: “Deixe o jovem aos meus cuidados e partiremos, para que vivamos e não morramos, nem nós, nem o senhor, nem as nossas crianças. ");
INSERT INTO poronbv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Eu serei responsável por ele. O senhor me fará prestar contas. Se eu não o trouxer de volta e não o colocar diante da sua presença, serei culpado para sempre diante do senhor. ");
INSERT INTO poronbv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Mas não nos faça demorar mais. Se tivéssemos ido, já estaríamos de volta a estas horas!” ");
INSERT INTO poronbv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Então seu pai Israel respondeu: “Parece que não tenho escolha. Se tem de ser assim, assim será. Mas tratem de levar os produtos mais preciosos desta terra, coloquem nos sacos e levem-nos para aquele homem. Levem um pouco de bálsamo e um pouco de mel, perfumes finos e mirra, nozes de pistache e amêndoas. ");
INSERT INTO poronbv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Levem dinheiro em dobro, e devolvam o pagamento da primeira compra que foi colocado na boca dos sacos de vocês. Pode ser que o dinheiro foi colocado nos sacos por engano. ");
INSERT INTO poronbv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Levem também o irmão de vocês e voltem àquele homem. ");
INSERT INTO poronbv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Que o Todo-poderoso Deus lhes conceda misericórdia diante daquele homem, para que ele libere o seu outro irmão e deixe Benjamim voltar com vocês. Quanto a mim, se eu perder meus filhos, ficarei desolado!” ");
INSERT INTO poronbv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Então os homens pegaram os presentes, o dinheiro em dobro e a Benjamim, desceram para o Egito e se apresentaram a José. ");
INSERT INTO poronbv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Quando José viu que Benjamim estava com eles, disse ao administrador de sua casa: “Leve estes homens para casa, mate umas cabeças de gado e prepare tudo, porque estes homens almoçarão comigo ao meio-dia”. ");
INSERT INTO poronbv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ele fez como José lhe havia ordenado e levou os homens para a casa de José. ");
INSERT INTO poronbv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Os filhos de Israel ficaram com medo, quando viram que foram levados à casa de José, e diziam: “Estamos aqui por causa do dinheiro que voltou conosco nos sacos de mantimentos. Ele quer nos acusar, tornar-nos escravos e tomar os nossos jumentos”. ");
INSERT INTO poronbv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Resolveram falar com o administrador da casa de José ");
INSERT INTO poronbv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","e disseram: “Por favor, senhor! Já estivemos aqui uma vez para comprar mantimento; ");
INSERT INTO poronbv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","quando paramos numa hospedaria, abrimos os sacos de mantimento e encontramos todo o dinheiro na boca de cada saco. Agora estamos aqui de novo e trouxemos de volta aquele dinheiro. ");
INSERT INTO poronbv_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Além disso trouxemos mais dinheiro conosco, para comprar mantimento. Não sabemos quem colocou o dinheiro nos sacos”. ");
INSERT INTO poronbv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mas o administrador disse: “Paz esteja com vocês. Não tenham medo! O seu Deus, o Deus de seu pai, foi quem deu o precioso presente que vocês acharam nos sacos de cereais. O dinheiro de vocês chegou às minhas mãos”. Então soltou Simeão e o levou até onde eles estavam. ");
INSERT INTO poronbv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Depois os levou à casa de José. Ofereceu água para lavarem os pés e deu ração aos seus jumentos. ");
INSERT INTO poronbv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Então eles prepararam o presente para a chegada de José ao meio-dia, porque ficaram sabendo que iriam almoçar ali. ");
INSERT INTO poronbv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Quando José chegou, eles lhe deram o presente e inclinaram-se diante dele, com os rostos no chão. ");
INSERT INTO poronbv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ele queria saber como eles estavam, e em seguida perguntou: “Vocês me falaram do seu pai idoso. Come ele vai? Ainda vive?” ");
INSERT INTO poronbv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Eles responderam: “O seu servo, nosso pai, vai bem e ainda vive”. E novamente baixaram a cabeça e se inclinaram. ");
INSERT INTO poronbv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","José dirigiu sua atenção para seu irmão Benjamim, filho de sua mãe, e disse: “É este o irmão mais novo de quem me falaram?” E acrescentou: “Deus conceda graça a você, meu filho”. ");
INSERT INTO poronbv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","A essa altura, não suportou mais a emoção em ver o seu irmão e saiu depressa, procurando um lugar para chorar. Ele entrou no seu quarto e ali chorou. ");
INSERT INTO poronbv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Depois lavou o rosto e saiu. Conseguiu conter suas emoções e disse: “Sirvam a refeição”. ");
INSERT INTO poronbv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Serviram a ele em separado dos irmãos e dos egípcios que estavam com ele, porque os egípcios não podiam comer com os hebreus. Isso seria um sacrilégio para eles. ");
INSERT INTO poronbv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","José determinou que seus irmãos fossem colocados à mesa, diante dele por ordem de idade, do mais velho ao mais novo. Isto causou certo espanto entre eles. ");
INSERT INTO poronbv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Então, lhes serviram a comida. A porção dada a Benjamim era cinco vezes maior do que a dos outros. E eles beberam e se alegraram com ele. ");
INSERT INTO poronbv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","José deu a seguinte ordem ao administrador de sua casa: “Dê a esses homens o máximo de mantimento que eles puderem levar e ponha o dinheiro de cada um na boca do saco de mantimento. ");
INSERT INTO poronbv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Coloque a minha taça de prata na boca do saco de mantimento do filho mais novo”. E ele obedeceu a todas as ordens de José. ");
INSERT INTO poronbv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Logo de manhã os irmãos saíram para casa, levando consigo os jumentos. ");
INSERT INTO poronbv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ainda não estavam muito longe da cidade, quando José disse ao administrador: “Vá atrás daqueles homens. Quando os alcançar, diga: ‘Por que vocês pagaram o bem com o mal? ");
INSERT INTO poronbv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Por que roubaram a taça de prata que o senhor usa para beber e que usa para fazer previsões? Vocês procederam muito mal’ ”. ");
INSERT INTO poronbv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","O administrador foi e os alcançou e disse a eles as palavras de José. ");
INSERT INTO poronbv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Mas eles lhe responderam: “Por que nosso senhor diz estas palavras? Longe de nós, seus servos, praticar algo assim! ");
INSERT INTO poronbv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nós trouxemos de volta o dinheiro, da terra de Canaã, que achamos na boca dos sacos de mantimento. Então, por que iríamos roubar prata e ouro do seu senhor? ");
INSERT INTO poronbv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Pois bem, aquele dos seus servos com quem for encontrada a taça morrerá; e o restante de nós será escravo do seu senhor!” ");
INSERT INTO poronbv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Então lhes respondeu: “Concordo com a proposta de vocês. Somente aquele com quem for encontrada a taça ficará como escravo. Os outros estarão livres”. ");
INSERT INTO poronbv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Trataram de cada um descarregar rapidamente o seu saco e abri-lo. ");
INSERT INTO poronbv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","O administrador examinou os sacos, começando com a carga do mais velho até o mais novo. E a taça foi encontrada no saco de mantimento de Benjamim! ");
INSERT INTO poronbv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Então rasgaram as suas roupas, carregaram de novo os jumentos e voltaram para a cidade. ");
INSERT INTO poronbv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","José ainda estava em casa quando chegaram Judá e seus irmãos e se lançaram ao chão, diante dele. ");
INSERT INTO poronbv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","José lhes perguntou: “O que é que vocês fizeram? Vocês não sabiam que um homem como eu sou capaz de perceber o que acontece?” ");
INSERT INTO poronbv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Então Judá disse: “O que responderemos ao nosso senhor? O que falaremos? Como poderíamos provar a nossa inocência? Deus trouxe à luz a culpa dos pecados dos seus servos. A partir de agora somos seus escravos, tanto nós como aquele que estava com a taça de prata”. ");
INSERT INTO poronbv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Mas ele disse: “Longe de mim fazer tal coisa! O homem que roubou a taça será o meu escravo. Vocês, no entanto, poderão voltar em paz para a casa do seu pai”. ");
INSERT INTO poronbv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Então Judá se aproximou de José e disse: “Ah, meu senhor! Permita-me dizer uma palavra ao meu senhor, e não fique aborrecido com o seu servo, pois o senhor é como o próprio faraó. ");
INSERT INTO poronbv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Meu senhor perguntou a seus servos: ‘Vocês têm pai e algum outro irmão?’ ");
INSERT INTO poronbv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","E nós respondemos ao senhor: ‘Nosso pai já é bem idoso e com ele ficou um filho da sua velhice, o mais novo, cujo irmão já morreu. Ele é o único filho da mesma mãe, e o pai o ama muito!’ ");
INSERT INTO poronbv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Mas o senhor disse aos seus servos: ‘Tragam o filho mais novo, para que eu o veja’. ");
INSERT INTO poronbv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Respondemos ao meu senhor: ‘O jovem não pode deixar o pai, senão o pai morre!’ ");
INSERT INTO poronbv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Mas o senhor disse aos seus servos: ‘Se o irmão mais novo de vocês não descer com vocês, não os receberei’. ");
INSERT INTO poronbv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Assim, voltamos para a casa do seu servo, meu pai, e repetimos a ele as palavras de meu senhor. ");
INSERT INTO poronbv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Então nosso pai disse: ‘Voltem e comprem um pouco de mantimento’. ");
INSERT INTO poronbv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nós respondemos: ‘Não podemos descer sem o nosso irmão mais novo. Só iremos se ele for também, porque o governador afirmou que não nos receberia se fôssemos sem o menino’. ");
INSERT INTO poronbv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Então nos disse o seu servo, nosso pai: ‘Vocês sabem que a minha mulher me deu dois filhos; ");
INSERT INTO poronbv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","um deles desapareceu. Certamente foi despedaçado por algum animal selvagem, e nunca mais o vi. ");
INSERT INTO poronbv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Se agora também levarem este outro embora, e lhe acontecer algum mal, a tristeza fará com que eu desça à sepultura’. ");
INSERT INTO poronbv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Agora, pois, se eu voltar a seu servo, o meu pai, sem levar o jovem comigo, visto que está muito apegado a ele, ");
INSERT INTO poronbv_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","quando ele perceber que o jovem não está conosco, morrerá. Os seus servos seriam culpados de matar de tristeza o nosso pai. ");
INSERT INTO poronbv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“Senhor, o seu servo garantiu que seria responsável pelo jovem. Eu disse assim: ‘Se eu não trouxer o jovem de volta, serei culpado para sempre diante do meu pai’. ");
INSERT INTO poronbv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Agora, peço ao senhor, que eu fique como escravo no lugar do mais jovem, e ele volte com os seus irmãos. ");
INSERT INTO poronbv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Como poderei voltar e me encontrar com o meu pai, se o jovem não for comigo? Eu não suportaria ver o sofrimento de meu pai!” ");
INSERT INTO poronbv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Então José não conseguiu mais se conter diante de todos os que estavam com ele e gritou: “Saiam todos daqui!” E ninguém ficou com ele quando José se revelou a seus irmãos. ");
INSERT INTO poronbv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","E ele chorou tão alto que o choro podia ser ouvido pelos egípcios, bem como do palácio do faraó. ");
INSERT INTO poronbv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Então ele disse a seus irmãos: “Eu sou José. Meu pai ainda está vivo?” Mas os seus irmãos não puderam responder, porque ficaram assustados diante dele. ");
INSERT INTO poronbv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Então José disse a seus irmãos: “Cheguem mais perto”. Quando eles se aproximaram, José continuou: “Eu sou José, o irmão que vocês venderam ao Egito! ");
INSERT INTO poronbv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Agora, nada de tristeza! E não se recriminem por terem me vendido para cá, porque foi para a conservação da vida que Deus me enviou adiante de vocês. ");
INSERT INTO poronbv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Porque a terra já passou por dois anos de fome, e ainda restam cinco anos em que não haverá cultivo nem colheita. ");
INSERT INTO poronbv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Mas Deus me enviou adiante de vocês para preservar a sua descendência na terra e para manter a vida de vocês por meio de um grande livramento. ");
INSERT INTO poronbv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Assim, não foram vocês que me mandaram para cá, mas sim Deus. Ele me fez ministro do faraó, senhor de toda a sua casa e governador de toda a terra do Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Agora, não percam tempo! Voltem depressa a meu pai e digam-lhe: ‘Assim manda dizer o seu filho José: Deus fez de mim senhor de toda a terra do Egito. Venha para cá o quanto antes. ");
INSERT INTO poronbv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","O senhor habitará na terra de Gósen. Assim o senhor estará sempre perto de mim. Não só o senhor, mas também os seus filhos, os seus netos, os seus rebanhos, o seu gado, enfim, tudo o que o senhor tem. ");
INSERT INTO poronbv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Eu providenciarei o seu sustento, porque ainda haverá cinco anos de fome. Faça o que estou dizendo, para que não caia a pobreza sobre o senhor, a sua família e tudo o que é seu’. ");
INSERT INTO poronbv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Vocês estão vendo com os próprios olhos, bem como meu irmão Benjamim, que sou eu mesmo que estou falando com vocês. ");
INSERT INTO poronbv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Anunciem a meu pai toda a honra que tenho recebido no Egito e tudo o que vocês mesmos têm visto. Apressem-se em buscar o meu pai!” ");
INSERT INTO poronbv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","E José abraçou o seu irmão Benjamim e chorou; e, abraçado com ele, Benjamim também chorou. ");
INSERT INTO poronbv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Em seguida, José beijou cada um dos seus irmãos e chorou com eles. Só então seus irmãos puderam falar com ele. ");
INSERT INTO poronbv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ouviu-se a seguinte notícia no palácio do faraó: “Estão aqui os irmãos de José”. Isto agradou ao faraó e seus oficiais. ");
INSERT INTO poronbv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Então o faraó disse a José: “Diga a seus irmãos: ‘Carreguem os seus animais e voltem para a terra de Canaã. ");
INSERT INTO poronbv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Chamem o seu pai e as suas famílias, e retornem para cá. Eu darei a vocês as melhores terras que há no Egito. E vocês poderão comer da fartura desta terra. ");
INSERT INTO poronbv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“ ‘Levem também carruagens da terra do Egito para trazer os seus filhos e suas mulheres, bem como o seu pai. ");
INSERT INTO poronbv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Não se preocupem com os seus bens, porque o que há de melhor no Egito será de vocês’ ”. ");
INSERT INTO poronbv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Os filhos de Israel seguiram as instruções que receberam. José lhes deu carruagens, conforme o faraó havia ordenado. Também lhes deu provisão para a viagem. ");
INSERT INTO poronbv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Além disso, deu a cada irmão trajes de festa. Mas a Benjamim deu trezentas moedas de prata e cinco trajes de festa. ");
INSERT INTO poronbv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","E José enviou a seu pai dez jumentos carregados dos melhores produtos do Egito e dez jumentos carregados de cereais e pães e outras provisões para a viagem. ");
INSERT INTO poronbv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","E despediu os seus irmãos. Quando estavam de partida, disse-lhes: “Não briguem durante a viagem!” ");
INSERT INTO poronbv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Então saíram do Egito e voltaram para a terra de Canaã, à casa do seu pai Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Lá chegando, lhe disseram: “José ainda vive! Ele é governador de toda a terra do Egito!” O coração de Jacó quase parou. Ele não conseguia acreditar no que estava ouvindo. ");
INSERT INTO poronbv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Porém, quando lhe contaram tudo o que José lhes tinha dito, e ao ver as carruagens que José tinha mandado para levá-lo, o espírito dele ganhou nova vida. ");
INSERT INTO poronbv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","E Israel disse: “Não precisam falar mais nada! Meu filho José ainda vive. Quero vê-lo antes que eu morra”. ");
INSERT INTO poronbv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israel partiu com tudo o que possuía. Ele parou em Berseba e ofereceu sacrifícios ao Deus de seu pai Isaque. ");
INSERT INTO poronbv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ainda em Berseba, Deus falou de noite com Israel por meio de visões. Deus disse: “Jacó! Jacó!” Ele respondeu: “Eis-me aqui!” ");
INSERT INTO poronbv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“Eu sou Deus, o Deus do seu pai”, disse ele. “Não tema em descer para o Egito, porque lá eu farei de você uma grande nação. ");
INSERT INTO poronbv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Estarei com você na viagem para o Egito e certamente o trarei de volta. E a mão de José fechará os seus olhos”. ");
INSERT INTO poronbv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Então Jacó deixou Berseba. E os filhos de Israel levaram o seu pai, seus filhos e suas mulheres nas carruagens mandadas pelo faraó. ");
INSERT INTO poronbv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Levaram os seus rebanhos e os bens que tinham conseguido em Canaã, e Jacó e toda a sua família foram para o Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Levou para aquela terra seus filhos, seus netos, suas filhas e suas netas, ou seja, toda a sua descendência. ");
INSERT INTO poronbv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Estes são os nomes dos israelitas, Jacó e os seus filhos, que foram para o Egito: Rúben, o filho mais velho de Jacó. ");
INSERT INTO poronbv_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Os filhos de Rúben: Enoque, Palu, Hezrom e Carmi. ");
INSERT INTO poronbv_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeão e seus filhos Jemueel, Jamim, Oade, Jaquim, Zoar e Saul, que era filho de uma cananeia. ");
INSERT INTO poronbv_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi e seus filhos Gérson, Coate e Merari. ");
INSERT INTO poronbv_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judá e seus filhos Er, Onã, Selá, Perez e Zerá. Er e Onã morreram na terra de Canaã. Perez e seus filhos Hezrom e Hamul. ");
INSERT INTO poronbv_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issacar e seus filhos Tolá, Puva, Jó e Sinrom. ");
INSERT INTO poronbv_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulom e seus filhos Serede, Elom e Jaleel. ");
INSERT INTO poronbv_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Foram esses os filhos de Jacó e de Lia nascidos em Padã-Arã. Diná também era filha dela. No total, entre filhos e filhas, netos e netas, eram trinta e três pessoas. ");
INSERT INTO poronbv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gade e seus filhos: Zifiom, Hagi, Suni, Esbom, Eri, Arodi e Areli. ");
INSERT INTO poronbv_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser e seus filhos: Imna, Isvá, Isvi, Berias e a irmã deles, Sera. Os filhos de Berias foram Héber e Malquiel. ");
INSERT INTO poronbv_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Foram esses os filhos que Jacó teve com Zilpa, serva que Labão deu a sua filha Lia. Ao todo, os filhos e filhas, netos e netas de Zilpa eram dezesseis pessoas. ");
INSERT INTO poronbv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Os filhos de Raquel, a mulher de Jacó, José e Benjamim. ");
INSERT INTO poronbv_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","No Egito nasceram estes filhos de José e de Azenate, filha de Potífera, sacerdote de Om: Manassés e Efraim. ");
INSERT INTO poronbv_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Os filhos de Benjamim: Bela, Bequer, Asbel, Gera, Naamã, Eí, Rôs, Mupim, Hupim e Arde. ");
INSERT INTO poronbv_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Foram esses os filhos de Jacó e de Raquel. Ao todo, eram catorze pessoas. ");
INSERT INTO poronbv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dã e seu filho Husim. ");
INSERT INTO poronbv_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali e seus filhos Jazeel, Guni, Jezer e Silém. ");
INSERT INTO poronbv_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Foram esses os filhos de Bila, que Labão deu à sua filha Raquel. Bila deu à luz sete filhos. ");
INSERT INTO poronbv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Todos os que foram com Jacó para o Egito, todos os seus descendentes, sem contar as mulheres e seus filhos, somavam sessenta e seis pessoas. ");
INSERT INTO poronbv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Com mais os dois filhos que nasceram de José no Egito, somando os membros da família de Jacó que foram para o Egito, eram setenta pessoas. ");
INSERT INTO poronbv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacó mandou Judá à frente até José, para saber o caminho para Gósen. Quando eles chegaram, ");
INSERT INTO poronbv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","José mandou preparar uma carruagem, e foi encontrar-se com seu pai em Gósen. Ao vê-lo, José o abraçou e chorou. E ficou muito tempo abraçado ao pai, chorando. ");
INSERT INTO poronbv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel disse a José: “Agora já posso morrer, pois já vi o seu rosto. Encontrei o meu filho vivo!” ");
INSERT INTO poronbv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","E José disse aos irmãos e a toda a família de seu pai: “Vou falar com o faraó e lhe direi: ‘Meus irmãos e toda a família de meu pai, que estavam na terra de Canaã, vieram para cá. ");
INSERT INTO poronbv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Os homens são pastores e criadores de gado. Eles trouxeram consigo os rebanhos, o seu gado e tudo o que têm’. ");
INSERT INTO poronbv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Quando, pois, o faraó perguntar qual é a profissão de vocês, ");
INSERT INTO poronbv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","respondam assim: ‘Estes seus servos criam rebanhos desde pequenos. Esse também era o trabalho dos nossos antepassados’. Assim, vocês poderão ficar morando na terra de Gósen, porque os pastores são desprezados pelos egípcios”. ");
INSERT INTO poronbv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Então José foi falar com o faraó: “Meu pai e meus irmãos chegaram de Canaã com seus rebanhos, o seu gado e com tudo o que têm. Eles estão na região de Gósen”. ");
INSERT INTO poronbv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Depois de dizer isso, José fez entrar cinco de seus irmãos e os apresentou ao faraó. ");
INSERT INTO poronbv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","“Em que vocês trabalham?”, perguntou o faraó. Eles responderam: “Estes seus servos são pastores. Os nossos antepassados trabalhavam nisso, e nós continuamos na mesma profissão”. ");
INSERT INTO poronbv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Disseram-lhe ainda: “Viemos morar nesta terra, porque não há pastagem para os rebanhos de seus servos, pois a fome é terrível na terra de Canaã. Agora, pedimos respeitosamente que permita que seus servos habitem na terra de Gósen”. ");
INSERT INTO poronbv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Então o faraó disse a José: “Seu pai e seus irmãos vieram ao seu encontro. ");
INSERT INTO poronbv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","A terra do Egito está à sua disposição. Escolha a melhor parte da terra. Que habitem na terra de Gósen. E se você encontrar entre eles homens competentes, coloque-os como responsáveis para cuidarem do meu gado”. ");
INSERT INTO poronbv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","José levou seu pai Jacó, e o apresentou ao faraó. Depois Jacó abençoou o faraó. ");
INSERT INTO poronbv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","O faraó perguntou a Jacó: “Qual é a sua idade?” ");
INSERT INTO poronbv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacó respondeu: “Tenho 130 anos de peregrinação. Minha vida de peregrinação foi curta e difícil, e não tenho vivido tanto quanto os meus antepassados”. ");
INSERT INTO poronbv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Então Jacó abençoou o faraó e saiu. ");
INSERT INTO poronbv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","José deu todo o apoio ao pai e a seus irmãos para se estabelecerem no Egito e deu-lhes como propriedade a melhor parte das terras do Egito, na região de Ramessés, conforme a ordem do faraó. ");
INSERT INTO poronbv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","E José providenciou o sustento para seu pai, seus irmãos e toda a sua família, segundo o número de seus filhos e netos. ");
INSERT INTO poronbv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Não havia mantimento em toda a terra, e a fome era severa. Tanto o povo do Egito quanto o povo de Canaã desfaleciam por causa da fome. ");
INSERT INTO poronbv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","José arrecadou todo o dinheiro que se achava na terra do Egito e de Canaã, vendendo cereais para o povo, e recolheu-o na casa do faraó. ");
INSERT INTO poronbv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Quando acabou o dinheiro dos egípcios e dos cananeus, todos os egípcios foram a José e suplicaram: “Por favor, dános mantimento. Não nos deixe morrer de fome, porque o nosso dinheiro acabou”. ");
INSERT INTO poronbv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","José respondeu: “Se o dinheiro acabou, tragam então os seus rebanhos, e em troca lhes darei mantimento”. ");
INSERT INTO poronbv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Então trouxeram os rebanhos a José, e ele deu-lhes mantimento em troca de cavalos, rebanhos, bois e jumentos. Durante aquele ano ele os sustentou em troca dos seus rebanhos. ");
INSERT INTO poronbv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","No começo do ano seguinte, foram novamente falar com José, dizendo: “Não vamos esconder do senhor que o nosso dinheiro acabou e os nossos rebanhos já lhe pertencem. Já não nos resta coisa alguma para oferecer. Só nos restam nossos corpos e nossas terras. ");
INSERT INTO poronbv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Não permita que morramos e que as nossas terras pereçam diante dos seus olhos. Compre-nos, e compre as nossas terras em troca de mantimento, e nós e as nossas terras seremos escravos do faraó. Dê-nos sementes para que vivamos e não morramos, a fim de que a terra não fique deserta”. ");
INSERT INTO poronbv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Assim, José comprou as terras do Egito para o faraó. Os egípcios venderam os seus campos, pois a fome era terrível; e o faraó tornou-se proprietário da terra. ");
INSERT INTO poronbv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Quanto ao povo, tornou-os escravos, de uma extremidade do Egito à outra. ");
INSERT INTO poronbv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Somente as terras dos sacerdotes não foram compradas, porque eles tinham o direito de receber sustento regular do faraó. Por isso não precisaram vender as suas terras. ");
INSERT INTO poronbv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Então José disse ao povo: “Comprei vocês e suas terras para o faraó. Em troca, dou estas sementes para cultivarem a terra. ");
INSERT INTO poronbv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Do que colherem, terão de dar a quinta parte ao faraó. Usem as outras quatro partes para semear e para alimentar vocês, seus filhos e as pessoas que moram com vocês”. ");
INSERT INTO poronbv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Eles responderam: “O senhor salvou-nos a vida e tem sido bom para nós. Seremos escravos do faraó”. ");
INSERT INTO poronbv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","José estabeleceu o seguinte decreto que vale até hoje na terra do Egito. A quinta parte das colheitas pertence ao faraó. Esse decreto não se aplica aos sacerdotes, porque eles não precisaram vender suas propriedades ao faraó. ");
INSERT INTO poronbv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Em meio a essa situação, Israel morou no Egito, na região de Gósen, onde compraram terras, e os seus descendentes tornaram-se muito numerosos. ");
INSERT INTO poronbv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Depois de chegar ao Egito, Jacó viveu mais dezessete anos, e chegou a ter 147 anos de idade. ");
INSERT INTO poronbv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Aproximando-se a hora de sua morte, Israel chamou seu filho José e lhe disse: “Se deseja ser bondoso comigo, ponha a sua mão direita debaixo da minha coxa e prometa que será bondoso e leal comigo, e faça o que peço: Não me enterre no Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Quando eu morrer, quero que me enterre no mesmo lugar em que os meus pais foram enterrados”. José respondeu: “Vou fazer o que o senhor me pede”. ");
INSERT INTO poronbv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Então Jacó lhe disse: “Jure-me!” E ele jurou. Então Israel inclinou-se sobre a cabeceira da cama. ");
INSERT INTO poronbv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Algum tempo depois, disseram a José: “Seu pai está doente”. Então José tomou seus dois filhos, Manassés e Efraim, e foi vê-lo. ");
INSERT INTO poronbv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","E anunciaram a Jacó: “O seu filho José está aí e quer vê-lo”. Com muito esforço, Israel assentou-se na cama. ");
INSERT INTO poronbv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Então Jacó disse a José: “O Deus Todo-poderoso me apareceu na cidade de Luz, na terra de Canaã. Ele me abençoou ");
INSERT INTO poronbv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","e disse: ‘Farei com que tenha muitos filhos e que os seus descendentes se multipliquem e formem muitas nações. Além disso, darei esta terra aos seus descendentes por propriedade para sempre’. ");
INSERT INTO poronbv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Agora, ouça bem, José. Os seus dois filhos, que nasceram na terra do Egito antes que eu viesse ao Egito, são meus. Efraim e Manassés serão meus, tanto quanto Rúben e Simeão. ");
INSERT INTO poronbv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mas os outros filhos que você tiver serão seus. Eles serão chamados para receber sua herança, segundo o nome de um de seus irmãos. ");
INSERT INTO poronbv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Quando eu voltava de Padã, sofri muito com a morte de Raquel na terra de Canaã, no caminho, perto de Efrata. Eu a sepultei ali mesmo, à beira da estrada para Efrata, que é Belém”. ");
INSERT INTO poronbv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Quando Israel viu os filhos de José, perguntou: “Quem são eles?” ");
INSERT INTO poronbv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","“São os filhos que Deus me deu aqui (no Egito)”, respondeu José. Então Israel disse: “Coloque-os aqui para que eu os abençoe”. ");
INSERT INTO poronbv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Os olhos de Israel já estavam enfraquecidos por causa da velhice, de modo que enxergava muito mal. José trouxe os seus filhos para bem perto do avô deles, e ele os beijou e os abraçou. ");
INSERT INTO poronbv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Então Israel disse a José: “Eu não tinha mais esperança em vê-lo novamente, e agora Deus me permitiu ver também os seus filhos!” ");
INSERT INTO poronbv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Depois José tirou-os de perto de seu pai e inclinou-se diante de seu pai, com o rosto no chão. ");
INSERT INTO poronbv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Em seguida, deu a mão direita a Efraim, à esquerda de Israel, e a mão esquerda a Manassés, à direita de Israel. Os três se aproximaram de Israel. ");
INSERT INTO poronbv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mas Israel estendeu a mão direita e a pôs sobre a cabeça de Efraim, e a mão esquerda sobre a cabeça de Manassés, cruzando os braços. Assim deu a Efraim, o mais novo, a bênção que normalmente caberia a Manassés, que era o filho mais velho. ");
INSERT INTO poronbv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","E abençoou a José, dizendo: “O Deus a quem meus pais Abraão e Isaque serviram, o Deus que me sustentou durante toda a vida até o dia de hoje, ");
INSERT INTO poronbv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","o Anjo que me tem livrado de todo mal, abençoe estes meninos. Que eles sejam chamados pelo meu nome e pelo nome de meus pais Abraão e Isaque, e que os descendentes deles venham a ser uma multidão na terra”. ");
INSERT INTO poronbv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","José não gostou ao ver o pai colocar a mão direita sobre a cabeça de Efraim. Por isso pegou a mão do pai, a fim de tirá-la da cabeça de Efraim e colocá-la sobre a cabeça de Manassés. ");
INSERT INTO poronbv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","E disse José a seu pai: “Assim não, meu pai, pois o filho mais velho é este. Ponha a mão direita sobre a cabeça dele”. ");
INSERT INTO poronbv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mas seu pai recusou-se e disse: “Eu sei, meu filho, eu sei. Os descendentes de Manassés também formarão um grande povo. Mas o seu irmão mais novo será maior do que ele, e os seus descendentes formarão muitas nações”. ");
INSERT INTO poronbv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Assim Jacó os abençoou naquele dia, dizendo: “Vocês servirão como exemplo para a bênção que darei a outros. O povo de Israel usará os seus nomes para abençoar uns aos outros. Eles vão dizer assim: “Que Deus faça a você o que fez a Efraim e a Manassés!” Desta forma colocou o nome de Efraim à frente de Manassés. ");
INSERT INTO poronbv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Em seguida, Israel disse a José: “Vou morrer logo, mas Deus estará com vocês e os levará de volta à terra de seus pais. ");
INSERT INTO poronbv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Dou a você mais que a seus irmãos. Você receberá a região montanhosa, a qual tomei dos amorreus com a minha espada e com o meu arco”. ");
INSERT INTO poronbv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Depois Jacó mandou chamar seus filhos e disse: “Fiquem todos juntos, e eu direi a vocês o que há de acontecer no futuro. ");
INSERT INTO poronbv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Reúnam-se para ouvir, filhos de Jacó. Ouçam as palavras de seu pai Israel: ");
INSERT INTO poronbv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rúben, você é o meu filho mais velho. Você é a expressão da minha força, o primeiro fruto da minha vitalidade. Você é superior em nobreza, superior em poder. ");
INSERT INTO poronbv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Você é arrojado como as águas. Entretanto, não será o mais importante, porque pecou na cama de seu pai. Você desonrou o leito de seu pai. ");
INSERT INTO poronbv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeão e Levi são irmãos; usam a espada para a violência. ");
INSERT INTO poronbv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Não estarei presente nos seus planos, nem participarei das suas reuniões, porque não controlaram a sua fúria, e saíram matando homens e mutilaram touros. ");
INSERT INTO poronbv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maldita seja a sua fúria, pois era violenta, e a sua ira, pois era cruel! Eu os dividirei na terra de Jacó e os dispersarei em Israel. ");
INSERT INTO poronbv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judá, os seus irmãos o louvarão. A sua mão destruirá os seus inimigos! Os filhos de seu pai se inclinarão diante de você. ");
INSERT INTO poronbv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judá é um leãozinho. Meu filho, você pegou sua presa e depois subiu vitorioso. Inclina-se e deita-se como o leão e como a leoa. Será que alguém tem coragem de despertá-lo? ");
INSERT INTO poronbv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ninguém tirará o cetro dele, até que venha aquele a quem ele pertence, e os povos lhe obedecerão. ");
INSERT INTO poronbv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ele amarrará o seu jumentinho a uma videira, na melhor videira que encontrar; lavará as suas roupas no vinho e a sua capa no sangue das uvas. ");
INSERT INTO poronbv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Seus olhos serão mais escuros que o vinho; seus dentes, branqueados pelo leite. ");
INSERT INTO poronbv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulom vai morar nas praias do mar e servirá como porto para os navios. Suas fronteiras se estenderão até Sidom. ");
INSERT INTO poronbv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issacar é como um jumento de ossos fortes, deitado entre os rebanhos de ovelhas. ");
INSERT INTO poronbv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Viu que era bom ficar descansando e desfrutando das delícias de sua terra. Aceitou curvar seus ombros para que colocassem o fardo nos seus ombros, e concordou em trabalhar como escravo. ");
INSERT INTO poronbv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dã será juiz do seu povo, como se fosse uma só tribo. ");
INSERT INTO poronbv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dã será uma serpente à beira da estrada, uma serpente venenosa à beira do caminho, que morde o calcanhar do cavalo, que empina e faz cair para trás o cavaleiro. ");
INSERT INTO poronbv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ó Senhor, espero a sua salvação! ");
INSERT INTO poronbv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gade será atacado por um bando de guerrilheiros, mas ele os atacará pela retaguarda. ");
INSERT INTO poronbv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser, a sua mesa será farta, e produzirá alimentos dignos de um rei. ");
INSERT INTO poronbv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali é uma gazela solta, que profere palavras formosas. ");
INSERT INTO poronbv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","José é um ramo frutífero, um ramo frutífero próximo à fonte, cujos galhos se estendem sobre o muro. ");
INSERT INTO poronbv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Os arqueiros lhe deram amargura, atirando flechas que o aborreciam. ");
INSERT INTO poronbv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mas o seu arco permanece firme, e os seus braços são fortes pelas mãos do Poderoso de Jacó, sim, pelo nome do Pastor, a Rocha de Israel, ");
INSERT INTO poronbv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","pelo Deus de seu pai, que o ajudará, e pelo Todo-poderoso, que o abençoará com bênçãos dos altos céus, com bênçãos das profundezas, com bênçãos da fertilidade e da maternidade. ");
INSERT INTO poronbv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","As bênçãos de seu pai serão maiores do que as bênçãos de meus antepassados, até os limites dos montes eternos. Que essas bênçãos estejam sobre a cabeça de José, sobre o alto da cabeça daquele que foi separado entre seus irmãos. ");
INSERT INTO poronbv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamim é um lobo feroz. De manhã devora a presa e de tarde reparte o que sobrou”. ");
INSERT INTO poronbv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","São essas as doze tribos de Israel, e foi isso que seu pai falou quando os abençoou, dando a cada um a bênção devida. ");
INSERT INTO poronbv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Depois lhes deu as seguintes ordens: “Vou morrer logo e me reunir ao meu povo. Enterrem-me com os meus pais, na caverna do campo do heteu Efrom, ");
INSERT INTO poronbv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","na caverna do campo de Macpela, próximo a Manre, na terra de Canaã, o campo que Abraão comprou de Efrom, como propriedade para sepultura da família. ");
INSERT INTO poronbv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ali foram enterrados Abraão e sua mulher Sara, Isaque e sua mulher Rebeca, e ali enterrei Lia. ");
INSERT INTO poronbv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","“O campo e a caverna que nele está foram comprados dos heteus”. ");
INSERT INTO poronbv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Tendo acabado de dar essas ordens a seus filhos, Jacó recolheu seus pés na cama e morreu, e foi reunido aos seus antepassados. ");
INSERT INTO poronbv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","José atirou-se sobre seu pai, chorou sobre ele e o beijou. ");
INSERT INTO poronbv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ele deu ordens a seus servos, aos que eram médicos, para embalsamarem seu pai; e os médicos embalsamaram o corpo de Israel. ");
INSERT INTO poronbv_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","O processo de embalsamamento levou quarenta dias, que era o prazo normal para isso. Os egípcios choraram a sua morte por setenta dias. ");
INSERT INTO poronbv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Depois que terminou o período de luto, José falou com a alta corte do faraó: “Peço a bondade de vocês de falarem com o faraó a meu favor, dizendo: ");
INSERT INTO poronbv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Meu pai me fez jurar o seguinte: Estou perto da morte. Enterre-me na terra de Canaã, no túmulo que preparei para mim. Por favor, deixe-me subir e enterrar meu pai; depois eu voltarei’ ”. ");
INSERT INTO poronbv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","E o faraó respondeu: “Vá e enterre o seu pai como ele o fez jurar”. ");
INSERT INTO poronbv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Então José subiu para enterrar o seu pai. Foram com ele todos os oficiais do faraó, os membros mais importantes da sua família e todas as autoridades da terra do Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Além deles, foi toda a família de José, seus irmãos e os demais membros da família de seu pai. Somente as crianças, os rebanhos e o gado foram deixados na terra de Gósen. ");
INSERT INTO poronbv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Também foram com eles homens a cavalo e carruagens. Assim, o cortejo foi muito grande. ");
INSERT INTO poronbv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Chegando ao campo de beneficiamento de grãos de Atade, a oeste do rio Jordão, choraram muito; e José chorou a morte do pai por sete dias. ");
INSERT INTO poronbv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Quando os cananeus, moradores daquela terra, viram o luto em Atade, disseram: “É impressionante o choro desses egípcios!” Por isso, aquele lugar, que fica além do rio Jordão, se chamou Abel-Mizraim. ");
INSERT INTO poronbv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Assim, os filhos de Israel fizeram o que ele lhes tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Levaram-no à terra de Canaã e o enterraram na caverna do campo de Macpela, próximo a Manre. Abraão tinha comprado essa caverna com o campo do heteu Efrom. Ele recebeu a escritura de posse para que fosse usada como cemitério da família. ");
INSERT INTO poronbv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Depois disso, José, seus irmãos e todos os que foram com ele para o enterro de seu pai voltaram para o Egito. ");
INSERT INTO poronbv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Vendo os irmãos de José que seu pai estava morto, disseram: “Agora é possível que José nos persiga e se vingue do mal que fizemos a ele”. ");
INSERT INTO poronbv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Por isso mandaram este recado a José: “Antes de morrer, o seu pai deixou uma mensagem a você. ");
INSERT INTO poronbv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","A mensagem é esta: ‘Perdoe a maldade de seus irmãos e o pecado que cometeram, com o mal que fizeram a você’. Agora lhe pedimos que perdoe a maldade dos servos do Deus de seu pai”. Enquanto falavam, José chorou. ");
INSERT INTO poronbv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Depois os irmãos foram falar pessoalmente com ele. Ficaram inclinados diante de José e disseram: “Aqui estamos, dispostos a servi-lo como seus escravos”. ");
INSERT INTO poronbv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","José, porém, lhes disse: “Não tenham medo. Por acaso estou no lugar de Deus? ");
INSERT INTO poronbv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","É bem verdade que vocês planejaram o mal contra mim, mas Deus tornou o mal em bem para que hoje fosse preservada a vida de muitas pessoas. ");
INSERT INTO poronbv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Por isso, não tenham medo. Vou sustentar vocês e seus filhos”. Assim, ele os tranquilizou e lhes falou amavelmente. ");
INSERT INTO poronbv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","José e toda a família de seu pai ficaram morando no Egito. Ele viveu cento e dez anos. ");
INSERT INTO poronbv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","José chegou a ver os filhos e os netos de Efraim. Viu também os filhos de Maquir, que era filho de Manassés, os quais José tomou no colo. ");
INSERT INTO poronbv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Disse José aos seus irmãos: “Está chegando o dia da minha morte; mas Deus certamente virá ao encontro de vocês no tempo certo e os tirará desta terra, e os fará voltar para a terra que ele jurou dar a Abraão, a Isaque e a Jacó”. ");
INSERT INTO poronbv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Então José fez que os filhos de Israel jurassem, dizendo-lhes: “Estou certo de que Deus fará o que acabo de dizer. Quando isso acontecer, levem os meus ossos daqui”. ");
INSERT INTO poronbv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","José morreu com cento e dez anos. Seu corpo foi embalsamado e colocado num caixão no Egito.");
INSERT INTO poronbv_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","São estes os nomes dos filhos de Israel que entraram com Jacó no Egito, com suas respectivas famílias: ");
INSERT INTO poronbv_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rúben, Simeão, Levi, Judá, ");
INSERT INTO poronbv_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issacar, Zebulom, Benjamim, ");
INSERT INTO poronbv_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dã, Naftali, Gade e Aser. ");
INSERT INTO poronbv_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","O número total de descendentes de Jacó foi setenta. José, porém, já estava no Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Passou o tempo, e morreram José, seus irmãos, e toda aquela geração. ");
INSERT INTO poronbv_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Mas os filhos de Israel eram muito férteis, e tornaram-se muito numerosos e fortaleceram-se grandemente, de maneira que encheram aquela terra. ");
INSERT INTO poronbv_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Nesse meio-tempo, um novo rei que não conhecia José subiu ao trono do Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","O novo rei disse ao povo: “Vejam! O povo israelita é muito numeroso e mais forte do que nós! ");
INSERT INTO poronbv_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Precisamos ser astutos para com esse povo, para que não se tornem mais numerosos ainda e, em caso de guerra, não se aliem aos nossos inimigos, pelejem contra nós e sejamos forçados a fugir do país”. ");
INSERT INTO poronbv_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Então colocaram sobre eles mestres de obras para forçarem os israelitas a trabalhos pesados. E assim os israelitas construíram para o faraó as cidades-celeiro de Pitom e Ramessés. ");
INSERT INTO poronbv_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","No entanto, quanto mais os maltratavam, mais eles se multiplicavam e se espalhavam, de maneira que os egípcios passaram a ficar com medo dos israelitas. ");
INSERT INTO poronbv_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Então os egípcios os sujeitaram a uma escravidão severa. ");
INSERT INTO poronbv_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Tornaram a vida deles amarga, impondo-lhes o árduo trabalho de preparar o barro para fazer tijolos, além de todo o trabalho no campo. Em todas as situações, os israelitas eram sujeitados a uma cruel escravidão. ");
INSERT INTO poronbv_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","O rei do Egito deu ordens às parteiras hebreias, entre elas Sifrá e Puá, dizendo: ");
INSERT INTO poronbv_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Quando vocês ajudarem as mulheres hebreias a dar à luz, façam o seguinte: se for menino, matem-no; se for menina, deixem-na viver”. ");
INSERT INTO poronbv_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mas as parteiras temiam a Deus e não obedeceram às ordens do rei do Egito. Elas deixavam os meninos viver também. ");
INSERT INTO poronbv_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Então o rei do Egito mandou chamar as duas parteiras e perguntou-lhes: “Por que vocês fizeram isso? Por que deixaram os meninos viver?” ");
INSERT INTO poronbv_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","As parteiras responderam ao faraó: “As mulheres hebreias não são como as egípcias. Elas são cheias de saúde e dão à luz antes que chegue a parteira”. ");
INSERT INTO poronbv_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Deus abençoou as parteiras; e o povo continuou crescendo, e se tornou cada vez mais forte. ");
INSERT INTO poronbv_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Como as parteiras temeram a Deus, ele foi bom com elas e fez com que tivessem suas próprias famílias. ");
INSERT INTO poronbv_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Então, o faraó ordenou a todo o seu povo: “Joguem no rio Nilo todos os meninos hebreus recém-nascidos. Só deixem viver as meninas”. ");
INSERT INTO poronbv_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Um homem e uma mulher da tribo de Levi se casaram, ");
INSERT INTO poronbv_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ela engravidou e deu à luz um filho. Vendo que o menino era bonito, escondeu-o por três meses. ");
INSERT INTO poronbv_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Como já não era mais possível manter o bebê escondido, ela pegou um cesto feito de junco e o vedou com betume e pôs nele o menino. Depois deixou o cesto entre os juncos à beira do rio. ");
INSERT INTO poronbv_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","A irmã do menino ficou vigiando de longe, para ver o que aconteceria com ele. ");
INSERT INTO poronbv_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","A filha do faraó desceu ao Nilo para tomar banho, acompanhada das suas servas, que ficaram passeando pela margem do rio. A princesa viu um cesto entre os juncos e mandou sua serva buscá-lo. ");
INSERT INTO poronbv_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Quando abriu o cesto, viu o menino que estava chorando. Ela teve compaixão dele e disse: “Deve ser um menino hebreu!” ");
INSERT INTO poronbv_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Então a irmã do menino aproximou-se e perguntou à filha do faraó: “A senhora quer que eu vá e arranje uma ama hebreia para criar o bebê?” ");
INSERT INTO poronbv_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“Sim, faça isso”, respondeu a filha do faraó. E a moça foi chamar a mãe do menino. ");
INSERT INTO poronbv_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Então a filha do faraó disse a ela: “Leve este menino e crie-o para mim. Pagarei pelo seu trabalho”. A mulher levou o menino e o criou. ");
INSERT INTO poronbv_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Quando o menino cresceu, a mãe o levou à filha do faraó, que o adotou. Assim ele passou a ser o filho da filha do faraó. Ela o chamou de Moisés, dizendo: “Porque eu o tirei das águas”. ");
INSERT INTO poronbv_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Anos mais tarde, quando Moisés já era adulto, foi visitar seus irmãos hebreus e viu o quanto estavam sofrendo. Ele viu um egípcio espancar um hebreu, que pertencia ao seu povo. ");
INSERT INTO poronbv_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Moisés olhou para um lado e para o outro e, como não viu ninguém, matou o egípcio e o escondeu na areia. ");
INSERT INTO poronbv_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","No dia seguinte, saiu de novo e viu que dois hebreus estavam brigando. Então perguntou ao culpado: “Por que você está espancando o seu irmão?” ");
INSERT INTO poronbv_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","O homem respondeu: “Quem o colocou como príncipe e juiz sobre nós? Quer matar-me como matou o egípcio?” Moisés ficou com medo e pensou: “Com certeza já descobriram!” ");
INSERT INTO poronbv_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","O faraó ficou sabendo desse caso e decretou a morte de Moisés. Mas Moisés fugiu do faraó e foi para a terra de Midiã. Quando chegou lá, sentou na beira de um poço. ");
INSERT INTO poronbv_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","O sacerdote de Midiã tinha sete filhas. Elas vieram tirar água e encheram os bebedouros para dar de beber aos rebanhos de seu pai. ");
INSERT INTO poronbv_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Então vieram os pastores daquela região e expulsaram as moças dali. Moisés se apressou em defender as jovens e deu água ao rebanho delas. ");
INSERT INTO poronbv_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Quando voltaram para casa, seu pai Reuel perguntou: “Por que vocês voltaram tão cedo hoje?” ");
INSERT INTO poronbv_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Elas responderam: “Um egípcio nos defendeu dos pastores. Além disso, tirou água e deu de beber ao rebanho”. ");
INSERT INTO poronbv_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","“E onde ele está?”, perguntou o pai a elas. “Por que o deixaram lá? Convidem o homem para jantar conosco”. ");
INSERT INTO poronbv_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moisés aceitou morar na casa de Reuel; e ele deu a Moisés sua filha Zípora como esposa. ");
INSERT INTO poronbv_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Eles tiveram um filho, a quem ele chamou de Gérson, dizendo: “Sou forasteiro em terra estrangeira”. ");
INSERT INTO poronbv_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Depois de muito tempo, morreu o rei do Egito. Os israelitas estavam gemendo debaixo da terrível escravidão e clamaram a Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Deus ouviu o seu gemido e atentou para a aliança que tinha feito com Abraão, com Isaque e com Jacó. ");
INSERT INTO poronbv_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","E Deus deu atenção aos sofrimentos dos israelitas. ");
INSERT INTO poronbv_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moisés estava cuidando do rebanho do seu sogro Jetro, sacerdote de Midiã. Ele levou o rebanho para o lado leste do deserto e chegou perto de Horebe, o monte de Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ali o Anjo do Senhor lhe apareceu no meio de uma chama de fogo que saía de uma sarça. Moisés olhou e viu que a sarça estava em chamas, mas o fogo não consumia a sarça. ");
INSERT INTO poronbv_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Então disse consigo: “Vou lá ver de perto essa coisa espantosa! Por que o fogo não queima aquela sarça?” ");
INSERT INTO poronbv_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mas, vendo o Senhor que ele se aproximava para observar, do meio da sarça o chamou: “Moisés! Moisés!” Ele respondeu: “Eis-me aqui!” ");
INSERT INTO poronbv_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","“Não se aproxime”, continuou Deus. “Tire as sandálias, pois você está pisando em terra santa”. ");
INSERT INTO poronbv_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Disse ainda: “Eu sou o Deus de seu Pai, o Deus de Abraão, o Deus de Isaque, o Deus de Jacó”. Moisés cobriu o rosto com as mãos, com medo de olhar para Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Disse ainda o Senhor: “Eu tenho visto a opressão do meu povo no Egito e tenho ouvido o seu clamor, por causa dos seus mestres de obras. Conheço bem o sofrimento do meu povo! ");
INSERT INTO poronbv_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Por isso, desci para libertar os israelitas das mãos dos egípcios e para levá-los do Egito para uma terra boa e ampla, terra em que existe leite e mel em abundância. É a terra dos cananeus, dos heteus, dos amorreus, dos ferezeus, dos heveus e dos jebuseus. ");
INSERT INTO poronbv_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Sim, porque o clamor dos filhos de Israel chegou até os meus ouvidos, e tenho visto como os egípcios os estão oprimindo. ");
INSERT INTO poronbv_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Agora venha, e eu o enviarei ao faraó, para tirar o meu povo, os filhos de Israel, do Egito”. ");
INSERT INTO poronbv_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Então, disse Moisés a Deus: “Quem sou eu para ir ao faraó e tirar os filhos de Israel do Egito? Eu não sou a pessoa certa para essa tarefa”. ");
INSERT INTO poronbv_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Deus lhe respondeu: “Eu estarei com você; e este será o sinal de que você está sendo enviado por mim: Depois de tirar os israelitas do Egito, eles virão prestar culto a mim neste monte”. ");
INSERT INTO poronbv_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moisés disse a Deus: “Suponhamos que eu vá falar com os filhos de Israel e lhes diga: ‘O Deus de seus pais me enviou para falar com vocês’. Se eles perguntarem: ‘Qual é o nome do seu Deus?’, o que vou dizer a eles?” ");
INSERT INTO poronbv_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Deus respondeu a Moisés: “Eu Sou o que Sou”. Disse ainda: “Assim você dirá aos filhos de Israel: ‘Eu Sou me enviou a vocês’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Deus continuou a falar com Moisés: “Diga aos filhos de Israel: O Senhor, o Deus dos seus pais, o Deus de Abraão, o Deus de Isaque e o Deus de Jacó, enviou-me a vocês; este é o meu nome eterno, nome pelo qual serei lembrado de geração em geração”. ");
INSERT INTO poronbv_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Agora vá”, continuou Deus, “reúna os líderes de Israel e diga-lhes: ‘O Senhor, o Deus dos seus pais, o Deus de Abraão, o Deus de Isaque e o Deus de Jacó, apareceu a mim. Ele me disse: Acompanho o meu povo e vejo o que fizeram com ele no Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Prometi tirá-los da opressão do Egito e levá-los para a terra dos cananeus, dos heteus, dos amorreus, dos ferezeus, dos heveus e dos jebuseus, terra em que existe leite e mel em abundância’. ");
INSERT INTO poronbv_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Os líderes de Israel aceitarão a sua palavra. Depois você irá com os líderes de Israel ao rei do Egito e você dirá: O Senhor, o Deus dos hebreus, se encontrou conosco. Agora, pois, deixe-nos ir a uma distância de três dias, para o deserto, para oferecermos sacrifícios ao Senhor, nosso Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Eu sei que o rei do Egito não os deixará sair, a não ser que uma poderosa mão o force. ");
INSERT INTO poronbv_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Eu mesmo estenderei a minha mão e castigarei os egípcios com todos os meus milagres que farei no meio deles. Só então ele os deixará ir. ");
INSERT INTO poronbv_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Quando isso acontecer, vou fazer com que os egípcios tratem vocês com bondade, de maneira que, quando vocês saírem, não sairão de mãos vazias. ");
INSERT INTO poronbv_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Cada mulher israelita pedirá à sua vizinha e às suas hóspedes joias de prata e de ouro, e roupas, com as quais vocês vestirão os seus filhos e as suas filhas. E assim vocês tomarão as riquezas dos egípcios”. ");
INSERT INTO poronbv_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mas Moisés disse: “Eles não vão acreditar em mim, nem vão querer fazer o que eu disser. Eles vão dizer: ‘O Senhor não apareceu a você!’ ” ");
INSERT INTO poronbv_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Então o Senhor lhe perguntou: “O que você tem na mão?” Moisés respondeu: “Uma vara de pastor”. ");
INSERT INTO poronbv_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","O Senhor disse: “Jogue a vara no chão”. Ele a jogou, e a vara transformou-se numa serpente. E Moisés fugiu dela. ");
INSERT INTO poronbv_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Disse o Senhor a Moisés: “Estenda a mão e pegue a serpente pela cauda”. Moisés estendeu a mão, pegou a serpente, e ela transformou-se numa vara novamente. ");
INSERT INTO poronbv_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","E o Senhor disse: “Com isso eles vão crer que o Deus de seus pais, o Deus de Abraão, o Deus de Isaque e o Deus de Jacó, apareceu a você”. ");
INSERT INTO poronbv_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","E o Senhor continuou: “Coloque a mão no peito”. Ele obedeceu. Quando tirou a mão, viu que a mão estava leprosa, branca como a neve. ");
INSERT INTO poronbv_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Então Deus ordenou: “Agora, coloque de novo a mão no peito”. Moisés fez isso e, quando a tirou, viu que estava completamente curada, como o restante da sua pele. ");
INSERT INTO poronbv_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Continuou o Senhor: “Se eles não acreditarem ao ver o primeiro milagre, acreditarão ao ver o segundo. ");
INSERT INTO poronbv_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","E se por acaso não crerem em você depois destes dois sinais, e não quiserem ouvir o que você disser, farei outro sinal. Tire água do rio Nilo e derrame-a na terra seca. Quando você derramar essa água na terra seca, ela se transformará em sangue”. ");
INSERT INTO poronbv_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moisés continuou teimando. Ele disse ao Senhor: “Ah! Senhor! Nunca fui bom para falar, nem antes, nem depois que o Senhor falou com o seu servo. Tenho muita dificuldade em me expressar”. ");
INSERT INTO poronbv_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","O Senhor lhe disse: “Quem deu a boca aos homens? Quem faz com que o homem fale ou não fale, veja ou não veja, escute ou não escute? Não sou eu, o Senhor? ");
INSERT INTO poronbv_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Pois agora vá. Eu estarei com você e direi o que você deve falar”. ");
INSERT INTO poronbv_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mas Moisés replicou: “Ah! Senhor! Mande outro no meu lugar!” ");
INSERT INTO poronbv_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Então o Senhor ficou irado com Moisés e disse: “Está bem. O levita Arão não é o seu irmão? Eu sei que ele tem facilidade para falar. Ele está vindo ao seu encontro e se alegrará em vê-lo. ");
INSERT INTO poronbv_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Você dirá a ele as palavras, e ele falará em seu lugar. Eu os ajudarei a falar e direi o que devem fazer. ");
INSERT INTO poronbv_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ele será o intermediário entre você e o povo. Você falará por meio dele e será como Deus para ele. ");
INSERT INTO poronbv_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Mais uma coisa: Não esqueça da vara. Com ela você vai operar os sinais”. ");
INSERT INTO poronbv_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moisés voltou para casa e disse ao seu sogro Jetro: “Permita-me voltar ao Egito. Quero ver se meus parentes ainda estão vivos”. Disse-lhe Jetro: “Vá em paz!” ");
INSERT INTO poronbv_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Nesse meio-tempo, o Senhor falou com Moisés em Midiã. Disse ele: “Você pode voltar tranquilo para o Egito. Digo isso porque todos aqueles que queriam matar você, já morreram”. ");
INSERT INTO poronbv_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Então Moisés colocou a sua mulher e os seus filhos num jumento e voltou para o Egito. Moisés levou com ele a “vara de Deus”. ");
INSERT INTO poronbv_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","O Senhor disse a Moisés: “Quando você voltar para o Egito, esteja pronto para fazer diante do faraó todos os sinais que eu mostrei a você. Mas eu vou endurecer o coração dele, para não deixar o povo sair. ");
INSERT INTO poronbv_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Você deverá dizer ao faraó que assim diz o Senhor: Israel é meu filho mais velho. ");
INSERT INTO poronbv_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Sou eu que estou mandando você deixar meu filho sair para me prestar culto. Mas, se você não deixar meu filho ir, você perderá seu filho mais velho!” ");
INSERT INTO poronbv_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Durante a viagem, Moisés parou para passar a noite numa pensão. Ali o Senhor apareceu e ameaçou matar Moisés. ");
INSERT INTO poronbv_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Então Zípora pegou uma pedra afiada e circuncidou o filho e lançou a pele cortada aos pés de Moisés e disse: “Você é para mim um marido sanguinário!” ");
INSERT INTO poronbv_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ela disse isso por causa da circuncisão. Aí o Senhor deixou Moisés viver. ");
INSERT INTO poronbv_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Então o Senhor disse a Arão: “Vá se encontrar com Moisés no deserto”. Arão foi e encontrou Moisés no monte Horebe, o monte de Deus, e o saudou com um beijo. ");
INSERT INTO poronbv_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moisés contou a Arão tudo o que Deus tinha dito e falou dos milagres que deviam fazer diante do faraó. ");
INSERT INTO poronbv_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Então Moisés e Arão foram para o Egito e convocaram uma assembleia com todos os líderes de Israel. ");
INSERT INTO poronbv_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Arão disse tudo o que o Senhor tinha falado a Moisés, e este fez os sinais na frente deles. ");
INSERT INTO poronbv_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Assim o povo de Israel acreditou que Deus tinha mandado Moisés e Arão. E quando os ouviram dizer que o Senhor tinha visitado os israelitas e tinha visto a aflição deles, inclinaram as cabeças e prestaram culto a Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Depois Moisés e Arão foram falar com o faraó e disseram: “Viemos trazer uma mensagem da parte do Senhor, o Deus de Israel. Ele diz: ‘Deixe o meu povo ir ao deserto para que celebre uma festa e preste culto a mim’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","“Ora!”, respondeu o faraó. “Quem é esse Senhor, para que eu lhe obedeça e deixe Israel sair do país?” ");
INSERT INTO poronbv_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Moisés e Arão insistiram: “O Deus dos hebreus encontrou-se conosco. Deixe-nos ir para o deserto, a uma distância de três dias de viagem. Lá vamos oferecer sacrifícios ao Senhor, nosso Deus. Se não lhe obedecermos, ele nos castigará com pragas ou com a espada”. ");
INSERT INTO poronbv_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Então lhes disse o rei do Egito: “O que vocês estão querendo fazer? Por que fazem o povo parar de trabalhar? Voltem ao trabalho!” ");
INSERT INTO poronbv_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","E acrescentou: “O povo já cresceu demais, e vocês ficam aí querendo afastar todo mundo do trabalho!” ");
INSERT INTO poronbv_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","No mesmo dia, o faraó deu novas ordens aos mestres de obras e aos oficiais nomeados para mandar nos israelitas. As ordens foram estas: ");
INSERT INTO poronbv_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“De agora em diante, vocês não vão mais dar palha aos israelitas para fazer tijolos como antes. Eles mesmos vão ter de ajuntar a palha! ");
INSERT INTO poronbv_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Mas não diminuam a tarefa deles. Eles vão ter de produzir a mesma quantidade de tijolos. Não reduzam a sua cota! Decerto está sobrando tempo para eles! “Senão, não estariam clamando: ‘Vamos oferecer sacrifícios ao nosso Deus’. ");
INSERT INTO poronbv_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Aumentem a carga de trabalho deles, porque assim pensarão só no serviço. Não sobrará tempo, nem terão forças para dar ouvidos a palavras mentirosas!” ");
INSERT INTO poronbv_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Os mestres de obras e os oficiais transmitiram logo as ordens ao povo, dizendo: “Assim diz o faraó: ‘Vocês não receberão mais palha. ");
INSERT INTO poronbv_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Vocês mesmos terão de procurar e ajuntar palha onde puderem achá-la, mas a cota de tijolos de vocês em nada será reduzida’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Então os israelitas se espalharam por todos os lados do Egito em busca de sobras de palha. ");
INSERT INTO poronbv_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Os mestres de obras os atormentavam, dizendo: “Tratem de acabar o serviço. Produzam a mesma quantidade de tijolos por dia de quando recebiam a palha!” ");
INSERT INTO poronbv_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","E espancavam os oficiais israelitas que tinham sido nomeados pelos oficias do faraó para dirigir os israelitas, e diziam: “Por que não acabaram a tarefa de ontem e de hoje, fazendo tijolos como antes?” ");
INSERT INTO poronbv_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Então os oficiais israelitas foram falar com o faraó: “Majestade, por que trata os seus servos dessa forma? ");
INSERT INTO poronbv_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Não nos dão palha, contudo nos dizem: ‘Façam tijolos!’ Como isso não é possível, somos açoitados. Mas a culpa é do seu próprio povo”. ");
INSERT INTO poronbv_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Mas o faraó respondeu: “Vocês são preguiçosos! Preguiçosos! Por isso ficam dizendo: ‘Vamos oferecer sacrifícios ao Senhor’. ");
INSERT INTO poronbv_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Voltem ao trabalho! Não receberão palha nenhuma, porém terão de produzir a mesma quantidade de tijolos que produziam antes!” ");
INSERT INTO poronbv_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Então os oficiais israelitas se viram em má situação quando ouviram que não poderiam reduzir a cota diária de tijolos. ");
INSERT INTO poronbv_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Quando saíram de diante do faraó, encontraram-se com Moisés e Arão, que estavam ali à espera deles. ");
INSERT INTO poronbv_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Os oficiais disseram aos dois irmãos: “O Senhor seja o juiz de vocês, pois atraíram o ódio do faraó e dos seus oficiais sobre nós e deram motivo para nos matarem!” ");
INSERT INTO poronbv_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moisés clamou ao Senhor: “Ó Senhor”, disse ele, “por que maltrata esse povo? Por que me enviou? ");
INSERT INTO poronbv_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Pois desde que transmiti a sua mensagem ao faraó, ele tem maltratado este povo. E a verdade é que o Senhor não libertou o seu povo!” ");
INSERT INTO poronbv_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","“Agora você verá o que vou fazer ao faraó!”, disse o Senhor a Moisés. “Pois por minha mão poderosa ele os deixará sair. Não só isso; por minha mão poderosa ele os expulsará do seu país”. ");
INSERT INTO poronbv_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Deus disse ainda a Moisés: “Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Eu me apresentei a Abraão, a Isaque e a Jacó, com o nome de Deus Todo-poderoso. Não revelei a eles todo o significado do meu nome, que é ‘Senhor’. ");
INSERT INTO poronbv_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Depois estabeleci a minha aliança com eles. Nessa aliança prometi dar a eles e aos seus descendentes a terra de Canaã, onde eles moravam como estrangeiros. ");
INSERT INTO poronbv_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Agora que ouvi o gemido dos israelitas, a quem os egípcios mantêm como escravos, atentei para a minha aliança. ");
INSERT INTO poronbv_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Portanto, diga a Israel: ‘Eu sou o Senhor e vou libertá-los das cargas e da escravidão do Egito. Vou fazer esse livramento com meu grande poder e com grandes manifestações de julgamento. ");
INSERT INTO poronbv_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Eu os farei meu povo e serei o seu Deus; e vocês saberão que eu sou o Senhor, o Deus de Israel, que vai tirar o meu povo do Egito. E meu povo estará livre dos abusos dos egípcios. ");
INSERT INTO poronbv_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Eu mesmo farei entrar o povo de Israel naquela terra, a qual jurei dar a Abraão, a Isaque e a Jacó. O meu povo será dono daquela terra! Eu sou o Senhor’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moisés falou tudo isso aos israelitas, mas eles não acreditaram nele, porque estavam muito desanimados, e porque a escravidão era muito cruel. ");
INSERT INTO poronbv_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","O Senhor voltou a falar a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Vá falar com o faraó, o rei do Egito. Diga a ele que deixe os israelitas saírem do país”. ");
INSERT INTO poronbv_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","“Mas, Senhor!”, respondeu Moisés. “Se nem meu povo me dá mais ouvidos, como esperar que o faraó me escute? Além disso, não sou bom na arte de falar”. ");
INSERT INTO poronbv_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Então o Senhor ordenou a Moisés e a Arão que fossem falar com os israelitas e com o faraó, o rei do Egito, para dizer que tinham ordem para tirar o povo de Israel do Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","São estes os nomes dos chefes dos grupos de famílias, das várias tribos de Israel: Filhos de Rúben, o filho mais velho de Israel: Enoque, Palu, Hezrom e Carmi; são essas as famílias de Rúben. ");
INSERT INTO poronbv_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Filhos de Simeão: Jemuel, Jamim, Oade, Jaquim, Zoar e Saul, filho de uma mulher cananeia; são essas as famílias de Simeão. ");
INSERT INTO poronbv_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Filhos de Levi, por ordem de idade: Gérson, Coate e Merari. Levi viveu 137 anos. ");
INSERT INTO poronbv_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Filhos de Gérson: Libni e Simei, cada um com o seu grupo de famílias. ");
INSERT INTO poronbv_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Filhos de Coate: Anrão, Jizar, Hebrom e Uziel. Coate viveu 133 anos. ");
INSERT INTO poronbv_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Filhos de Merari: Mali e Musi. São esses os chefes dos grupos de famílias de Levi, segundo a ordem de idade. ");
INSERT INTO poronbv_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Anrão casou com Joquebede, sua tia pelo lado paterno. Arão e Moisés eram filhos desse casal. Anrão viveu 137 anos. ");
INSERT INTO poronbv_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Filhos de Jizar: Corá, Nefegue e Zicri. ");
INSERT INTO poronbv_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Filhos de Uziel: Misael, Elzafã e Sitri. ");
INSERT INTO poronbv_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Arão casou com Eliseba, filha de Aminadabe e irmã de Naassom. O casal teve estes filhos: Nadabe, Abiú, Eleazar e Itamar. ");
INSERT INTO poronbv_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Filhos de Corá: Assir, Elcana e Abiasafe. São estas as famílias pertencentes ao grupo de famílias de Corá. ");
INSERT INTO poronbv_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar, filho de Arão, casou com uma filha de Putiel. Fineias era filho desse casal. Esses são os nomes dos grupos de famílias dos levitas e das famílias que formavam esses grupos. ");
INSERT INTO poronbv_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Foi a este Arão e a este Moisés que o Senhor disse: “Tirem todo o povo de Israel da terra do Egito, segundo as suas divisões”. ");
INSERT INTO poronbv_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","E foram enviados ao faraó, rei do Egito, para tirar os israelitas do Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Quando o Senhor falou com Moisés no Egito, ");
INSERT INTO poronbv_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","disse-lhe: “Eu sou o Senhor. Vão entregar ao faraó a mensagem que dei a vocês”. ");
INSERT INTO poronbv_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Moisés, contudo, respondeu ao Senhor, dizendo: “Não posso fazer esse trabalho! Não sei falar bem. Como posso esperar que o faraó me escute?” ");
INSERT INTO poronbv_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","O Senhor disse a Moisés: “Veja! Eu nomeei você como meu representante perante o faraó, como se eu mesmo estivesse falando com ele! E o seu irmão Arão falará por você. ");
INSERT INTO poronbv_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Você falará a Arão tudo o que eu ordenar, e o seu irmão falará com o faraó, para que deixe os israelitas saírem do Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Mas eu vou fazer com que o faraó resista em deixar o povo sair, e vou multiplicar os meus milagres no Egito, como sinais do meu poder. ");
INSERT INTO poronbv_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Mesmo assim, o faraó não os ouvirá. Então farei pesar a minha mão sobre o Egito e castigarei essa nação com grandes manifestações de juízo. Assim tirarei todo o meu povo, os israelitas, da terra do Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","E os egípcios saberão de uma vez por todas que eu sou o Senhor, quando mostrar o meu poder sobre o Egito e tirar de lá o povo de Israel!” ");
INSERT INTO poronbv_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moisés e Arão fizeram como o Senhor lhes tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moisés tinha oitenta anos de idade e Arão oitenta e três quando falaram com o faraó. ");
INSERT INTO poronbv_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","O Senhor disse a Moisés e Arão: ");
INSERT INTO poronbv_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Quando o faraó pedir a vocês que façam algum sinal para provar que eu os enviei, você, Moisés, dirá a Arão: Jogue a sua vara no chão diante do faraó. E a vara se transformará numa serpente”. ");
INSERT INTO poronbv_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Então Moisés e Arão foram falar com o faraó e fizeram o que o Senhor tinha ordenado. No momento certo, Arão jogou a vara no chão, diante do faraó e dos oficiais do rei, e, de fato, ela se transformou em serpente. ");
INSERT INTO poronbv_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Então o faraó mandou chamar os sábios e mágicos do Egito, e eles fizeram a mesma coisa que Arão tinha feito, por meio de artes mágicas. ");
INSERT INTO poronbv_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Cada um deles jogou a sua vara no chão, e estas se transformaram em serpentes. Só que a serpente de Arão devorou as serpentes deles. ");
INSERT INTO poronbv_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Todavia, o coração do faraó se endureceu e ele não atendeu a Moisés e Arão, como o Senhor tinha dito. ");
INSERT INTO poronbv_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","O Senhor disse a Moisés: “O faraó continua de coração duro, e teima em não deixar sair o povo. ");
INSERT INTO poronbv_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Mas vá ao encontro do faraó amanhã cedo. A essa hora ele irá até o rio. Fique lá, à espera dele, na beira do rio. Leve na mão a mesma vara que se transformou em serpente. ");
INSERT INTO poronbv_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Quando o rei chegar, diga-lhe: O Senhor, o Deus dos hebreus, me mandou dizer: Deixe que o meu povo vá me prestar culto no deserto. Mas até agora Vossa Majestade não deu atenção. ");
INSERT INTO poronbv_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Assim diz o Senhor: Com esta vara que trago comigo vou bater nas águas do rio, e elas se transformarão em sangue. ");
INSERT INTO poronbv_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Os peixes do rio morrerão e o rio ficará cheirando mal, e os egípcios terão nojo de beber água do rio”. ");
INSERT INTO poronbv_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","O Senhor disse ainda a Moisés: “Mande Arão estender a sua vara sobre as águas do Egito; sobre os rios, sobre os canais, sobre as lagoas e sobre os açudes e todos os reservatórios de água, para que a água se transforme em sangue. Haverá sangue por toda a terra do Egito, até nas vasilhas de madeira e nos tanques de pedra!” ");
INSERT INTO poronbv_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moisés e Arão fizeram o que o Senhor tinha ordenado. Arão levantou a vara e bateu com ela nas águas do rio. O faraó e seus oficiais estavam vendo tudo; e toda a água do rio transformou-se em sangue. ");
INSERT INTO poronbv_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Os peixes morreram, o rio ficou cheirando mal e os egípcios não podiam beber água do rio. Havia sangue no Egito inteiro! ");
INSERT INTO poronbv_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mas os mágicos egípcios fizeram a mesma coisa. Com práticas de magia, transformaram água em sangue. Por isso o coração do faraó continuou endurecido, e ele não deu atenção a Moisés e Arão, como o Senhor os tinha prevenido. ");
INSERT INTO poronbv_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Nem este grande milagre fez o faraó considerar seriamente a situação. Ele simplesmente virou as costas e foi para o seu palácio. ");
INSERT INTO poronbv_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Para achar água potável, os egípcios tiveram de cavar poços perto do rio, porque das águas do rio não podiam beber. ");
INSERT INTO poronbv_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Passaram-se sete dias depois que o Senhor feriu as águas do rio. ");
INSERT INTO poronbv_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Depois o Senhor disse a Moisés: “Vá ao faraó e diga-lhe: Assim diz o Senhor: Deixe o meu povo ir para me oferecer culto. ");
INSERT INTO poronbv_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Se você não deixar, vou encher todos os seus territórios de rãs. ");
INSERT INTO poronbv_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","O rio transbordará delas. Elas subirão do rio, avançarão pela terra e entrarão na sua casa. Nem nos quartos de dormir vocês terão descanso, pois as rãs entrarão neles e subirão nas camas. Isso também ocorrerá nas casas dos seus oficiais, e avançarão sobre o povo. Entrarão nos seus fornos e nas bacias de amassar pão. ");
INSERT INTO poronbv_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","As rãs virão sobre você, seu povo e todos os seus oficiais”. ");
INSERT INTO poronbv_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","E o Senhor continuou falando a Moisés: “Diga a Arão que estenda a vara sobre os rios, sobre os canais, sobre as lagoas, para fazer subir rãs em toda a terra do Egito”. ");
INSERT INTO poronbv_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Arão estendeu a mão sobre as águas do Egito, e apareceram rãs que cobriram a terra do Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Mas os mágicos do Egito fizeram a mesma coisa com as suas artes mágicas. Fizeram aparecer rãs na terra. ");
INSERT INTO poronbv_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Naquela situação crítica, o faraó mandou chamar Moisés e Arão e disse-lhes: “Peçam ao Senhor que tire as rãs. E eu deixarei o povo ir oferecer sacrifícios ao Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moisés respondeu ao faraó: “É só dizer quando devo orar a seu favor, pelos seus oficiais e pelo seu povo, para que as rãs sejam retiradas da terra e fiquem somente no rio”. ");
INSERT INTO poronbv_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","O faraó respondeu: “Que seja amanhã”. E Moisés disse: “Está bem. Vossa Majestade saberá que não existe ninguém como o Senhor, nosso Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","As rãs serão afastadas de você e das suas casas, dos seus oficiais e do seu povo. Ficarão somente no rio”. ");
INSERT INTO poronbv_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Então Moisés e Arão saíram da presença do faraó. Moisés clamou ao Senhor por causa das rãs, como tinha prometido ao faraó. ");
INSERT INTO poronbv_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","E o Senhor atendeu ao pedido de Moisés. Assim, morreram todas as rãs que estavam nas casas, nos pátios e nos campos. ");
INSERT INTO poronbv_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ajuntaram as rãs mortas em montões, espalhando um terrível cheiro por todo o país. ");
INSERT INTO poronbv_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mas quando o faraó viu que o país estava livre das rãs, endureceu o coração e não deixou o povo ir. Isto aconteceu como o Senhor tinha dito que iria acontecer. ");
INSERT INTO poronbv_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Então o Senhor disse a Moisés: “Mande Arão bater com a vara no pó da terra. Ao fazer isso, o pó vai se transformar em piolhos por toda a terra do Egito”. ");
INSERT INTO poronbv_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Moisés e Arão fizeram o que Deus tinha ordenado. Assim que o pó da terra foi tocado pela vara de Arão, os homens e os animais ficaram infestados de piolhos. Todo o pó se transformou em piolhos na terra do Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ora, os mágicos do Egito tentaram fazer a mesma coisa com as suas artes secretas, mas não conseguiram produzir piolhos! E os piolhos infestaram os homens e os animais. ");
INSERT INTO poronbv_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","“Isso é o dedo de Deus!”, disseram eles ao faraó. Mas o coração do faraó continuou endurecido. Ele teimou em não dar ouvidos a Moisés e Arão, como o Senhor os tinha prevenido. ");
INSERT INTO poronbv_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Em seguida o Senhor disse a Moisés: “Levante cedo de manhã e vá encontrar o faraó na beira do rio, quando ele estiver indo às águas. Diga a ele: ‘Assim diz o Senhor: Deixe o meu povo ir oferecer culto a mim. ");
INSERT INTO poronbv_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Se não deixar, vou mandar enxames e mais enxames de moscas sobre você, sobre os seus oficiais e sobre o seu povo. E as casas do seu povo e toda a terra em que vivem os egípcios estarão cheias de moscas. ");
INSERT INTO poronbv_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Mas note bem! Farei com que na terra de Gósen isso não aconteça. As moscas não amolarão os israelitas. Assim você terá de reconhecer que eu sou o Senhor de toda a terra. ");
INSERT INTO poronbv_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Para deixar isso claro, vou fazer distinção entre o meu povo e o seu povo. Esse sinal do meu poder mostrarei amanhã!’ ” ");
INSERT INTO poronbv_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","E o Senhor fez o que disse, de modo que a casa do faraó e as casas dos oficiais e de toda a terra do Egito ficaram infestadas de moscas. E a terra foi arruinada pelas moscas. ");
INSERT INTO poronbv_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Então o faraó mandou chamar Moisés e Arão e disse: “Vão, podem oferecer sacrifícios ao seu Deus. Mas façam isso aqui mesmo, no Egito”. ");
INSERT INTO poronbv_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","“Isso não!”, respondeu Moisés. “Os nossos sacrifícios são uma abominação para os egípcios. Se fizermos isso aqui, na frente deles, não nos apedrejarão? ");
INSERT INTO poronbv_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Precisamos ir ao deserto, a uma distância de três dias de viagem. Lá ofereceremos sacrifícios ao Senhor, nosso Deus, como ele nos mandou”. ");
INSERT INTO poronbv_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Então o faraó disse: “Podem ir e oferecer sacrifícios ao Senhor, o seu Deus, no deserto. Mas não vão muito longe, e orem por mim também”. ");
INSERT INTO poronbv_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moisés respondeu-lhe: “Assim que eu sair daqui, vou orar ao Senhor. Pode estar certo de que amanhã os enxames de moscas se retirarão do faraó, dos seus oficiais e do seu povo. Mas não queira nos enganar de novo, impedindo que o povo de Israel vá oferecer sacrifícios ao Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Logo depois que Moisés se despediu do faraó, orou ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","O Senhor atendeu ao pedido de Moisés, e as moscas deixaram o faraó, seus oficiais e seu povo. Não restou uma só mosca! ");
INSERT INTO poronbv_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mas também dessa vez o faraó endureceu o coração e não deixou o povo ir. ");
INSERT INTO poronbv_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","O Senhor ordenou a Moisés: “Volte ao faraó e diga-lhe: ‘Assim diz o Senhor, o Deus dos hebreus: Deixe o meu povo ir para que ofereça culto a ele. ");
INSERT INTO poronbv_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Se não deixar e insistir em impedir o povo, ");
INSERT INTO poronbv_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","saiba que o poder do Senhor destruirá o seu rebanho, que está no campo. Morrerão os cavalos, os jumentos, os camelos, os bois e as ovelhas. Porque Deus mandará uma praga gravíssima. ");
INSERT INTO poronbv_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Mas a praga só atingirá os animais do Egito. Nenhum animal dos israelitas morrerá’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","O Senhor determinou um prazo: “Amanhã o Senhor fará o que prometeu nesta terra”. ");
INSERT INTO poronbv_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","E foi o que aconteceu. No dia seguinte, todos os rebanhos dos egípcios morreram, mas dos rebanhos dos israelitas nenhum animal morreu. ");
INSERT INTO poronbv_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","O faraó mandou verificar e viu que nenhum animal dos israelitas tinha morrido. Apesar disso, continuou com o coração endurecido e não deixou o povo ir. ");
INSERT INTO poronbv_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","O Senhor disse a Moisés e a Arão: “Peguem com a mão cinza de um forno, e Moisés jogará a cinza para o ar, diante do faraó. ");
INSERT INTO poronbv_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","A cinza se tornará em pó fino sobre toda a terra do Egito. Esse pó vai produzir tumores que se abrirão em úlceras nos homens e nos animais em todo o Egito”. ");
INSERT INTO poronbv_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Eles pegaram cinza do forno e se apresentaram ao faraó. Moisés jogou a cinza para o ar, e ela produziu tumores que se abriram em úlceras nos homens e nos animais. ");
INSERT INTO poronbv_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Os mágicos nem conseguiam ficar em pé diante de Moisés, porque ficaram cobertos de tumores, junto com o restante dos egípcios. ");
INSERT INTO poronbv_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Mas o Senhor endureceu o coração do faraó, e ele não deu ouvidos a Moisés e Arão. O Senhor os tinha prevenido de que isso aconteceria. ");
INSERT INTO poronbv_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Depois o Senhor disse a Moisés: “Levante bem cedo amanhã e diga ao faraó: ‘Assim diz o Senhor, o Deus dos hebreus: “Deixe o meu povo sair do Egito para me servir. ");
INSERT INTO poronbv_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Desta vez enviarei todas as minhas pragas contra você, contra seus oficiais e contra o seu povo, para que você saiba que não há ninguém semelhante a mim em toda a terra. ");
INSERT INTO poronbv_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Pois eu já poderia ter destruído você e seu povo com uma peste mortal que teria eliminado você da terra”. ");
INSERT INTO poronbv_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mas conservei a sua vida para mostrar-lhe o meu poder e para anunciar o meu nome em toda a terra. ");
INSERT INTO poronbv_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Vai continuar desafiando o meu poder? Vai continuar proibindo o meu povo, para não deixá-lo ir? ");
INSERT INTO poronbv_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Amanhã a esta hora enviarei uma chuva de pedras sobre o Egito. E vai ser terrível! Nunca, em toda a história do Egito, desde que foi fundado, caiu uma chuva tão forte como a que vai cair amanhã. ");
INSERT INTO poronbv_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Agora, trate de mandar recolher o seu gado e tudo o que você tem no campo. Porque os homens e os animais que estiverem no campo e que não estiverem abrigados serão atingidos pela chuva de pedras e morrerão’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Alguns oficiais do faraó temeram a palavra do Senhor e se apressaram em recolher seus servos e seus rebanhos em abrigos. ");
INSERT INTO poronbv_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mas os que não se importaram com a palavra do Senhor deixaram no campo os servos e seus rebanhos. ");
INSERT INTO poronbv_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Então o Senhor disse a Moisés: “Levante a mão para o céu, e cairá chuva de pedras em todo o Egito. Cairá sobre os homens, sobre os animais e sobre as plantações”. ");
INSERT INTO poronbv_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Assim que Moisés estendeu a vara para o céu, o Senhor mandou trovões e chuva de pedras, e raios caíam sobre a terra do Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","A chuva de pedras e os relâmpagos caíam sem parar. Nunca o Egito tinha sofrido uma tempestade como aquela, desde que se tornou uma nação. ");
INSERT INTO poronbv_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Foi grande a destruição em toda a terra do Egito. Os animais e os homens que estavam no campo morreram. A chuva de pedras destruiu também toda a vegetação e quebrou todas as árvores do campo. ");
INSERT INTO poronbv_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Somente na terra de Gósen, onde viviam os israelitas, não caiu a chuva de pedras. ");
INSERT INTO poronbv_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Então, o faraó mandou chamar Moisés e Arão: “Finalmente vejo que pequei”, confessou. “O Senhor é justo; eu e o meu povo erramos. ");
INSERT INTO poronbv_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Orem ao Senhor, pedindo que faça parar esses trovões e essa chuva de pedras. Façam isso, e eu os deixarei ir. Vocês não precisam mais ficar aqui!” ");
INSERT INTO poronbv_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moisés respondeu: “Logo depois que eu sair da cidade, vou levantar as mãos ao Senhor, e os trovões e a chuva de pedras cessarão. Isto será mais uma prova de que a terra pertence ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mas quanto a Vossa Majestade e aos seus oficiais, bem sei que não temem ao Senhor Deus”. ");
INSERT INTO poronbv_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","O linho e a cevada foram destruídos pela tempestade, pois a cevada já estava na espiga e o linho estava em flor. ");
INSERT INTO poronbv_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Mas o trigo e o centeio não foram destruídos, porque ainda não tinham brotado da terra. ");
INSERT INTO poronbv_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Quando Moisés deixou o faraó e saiu da cidade, ergueu as mãos para o Senhor. Imediatamente os trovões e a chuva de pedras pararam por completo. ");
INSERT INTO poronbv_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Assim que parou a tempestade, o faraó voltou a pecar e endureceu o coração, ele e os seus oficiais. ");
INSERT INTO poronbv_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","O coração do faraó continuou endurecido, e ele não deixou o povo de Israel sair. O Senhor tinha dito a Moisés que isso iria acontecer. ");
INSERT INTO poronbv_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","O Senhor disse a Moisés: “Vá de novo falar com o faraó, mas eu mesmo endurecerei o coração dele e dos oficiais egípcios, a fim de mostrar os sinais do meu poder no meio deles, ");
INSERT INTO poronbv_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","e para que você possa contar aos seus filhos e netos as coisas que fiz com os egípcios e quantos milagres realizei no meio deles. Assim vocês saberão que eu sou o Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Assim Moisés e Arão foram novamente se apresentar ao faraó e lhe disseram: “Assim diz o Senhor, o Deus dos hebreus: ‘Até quando você vai teimar em não submeter-se a mim? Deixe o meu povo ir, para me prestar culto. ");
INSERT INTO poronbv_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Se você não estiver disposto a deixá-lo ir, mandarei nuvens de gafanhotos ao seu território amanhã. ");
INSERT INTO poronbv_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Serão tantos que cobrirão a terra, a ponto de não se poder enxergar coisa alguma. Eles devorarão tudo que sobrou dos estragos feitos pela chuva de pedras e todas as árvores que estiverem brotando no campo. ");
INSERT INTO poronbv_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Eles vão invadir os seus palácios, as casas dos seus oficiais e todas as casas dos egípcios. Algo que seus pais e antepassados jamais viram, desde o dia em que entraram nesta terra até o dia de hoje!’ ” E Moisés deu as costas ao faraó e saiu. ");
INSERT INTO poronbv_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Então os oficiais do faraó se reuniram e falaram com o faraó: “Até quando vamos ficar nas mãos desse homem? Será que Vossa Majestade não sabe que o Egito está completamente arruinado? Deixe esses homens irem oferecer culto ao Senhor, o Deus deles”. ");
INSERT INTO poronbv_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Então, Moisés e Arão foram levados outra vez à presença do faraó. “Podem ir oferecer culto ao Senhor o seu Deus”, disse faraó. “Mas me digam uma coisa: Quem irá?” ");
INSERT INTO poronbv_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moisés respondeu-lhe: “Temos de ir todos: os jovens e os velhos, nossos filhos e nossas filhas, nossos rebanhos e nossos bois, porque vamos celebrar uma festa ao Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","O faraó reagiu: “Que o Senhor esteja com vocês! Mas não deixarei, de forma alguma, que levem as crianças. É claro que vocês estão tramando uma conspiração! ");
INSERT INTO poronbv_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Não será assim. Se quiserem, vão só os homens oferecer culto ao Senhor, como vocês têm pedido”. E os dois foram expulsos da sala do faraó. ");
INSERT INTO poronbv_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Então o Senhor disse a Moisés: “Erga a mão sobre a terra do Egito, para que venham gafanhotos e devorem toda a vegetação, tudo que sobrou da chuva de pedras”. ");
INSERT INTO poronbv_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moisés levantou a vara, e o Senhor fez soprar um vento do leste durante todo o dia e toda a noite. Pela manhã, o vento tinha trazido os gafanhotos, ");
INSERT INTO poronbv_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","os quais desceram em grande número sobre todo o território do Egito, de ponta a ponta. Nunca ocorreu uma praga de gafanhotos como essa, em toda a história do Egito, nem nunca tornará a ocorrer! ");
INSERT INTO poronbv_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Pois os gafanhotos cobriram a superfície da terra de tal forma que ela escureceu. E devoraram toda a vegetação e todos os frutos das árvores que tinham sobrado da chuva de pedras. Não ficou nada verde nas árvores nem nos pastos, em toda a terra do Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Faraó mandou chamar Moisés e Arão às pressas e disse-lhes: “Confesso que pequei contra o Senhor, o seu Deus, e contra vocês! ");
INSERT INTO poronbv_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Agora, pois, peço que perdoem o meu pecado e orem ao Senhor, o seu Deus, para que me livre desta morte”. ");
INSERT INTO poronbv_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moisés saiu dali e orou ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","E o Senhor fez soprar um vento muito forte, vindo do oeste, que levantou os gafanhotos e os lançou no mar Vermelho. Não restou um gafanhoto sequer em todo o território egípcio. ");
INSERT INTO poronbv_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mas o Senhor endureceu o coração do faraó, e ele não deixou o povo de Israel sair. ");
INSERT INTO poronbv_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","O Senhor disse a Moisés: “Erga a sua mão para o céu, e a terra do Egito ficará na escuridão. A escuridão será tão forte que poderá ser apalpada!” ");
INSERT INTO poronbv_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moisés ergueu a mão para o céu, e por três dias houve densas trevas em todo o Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Durante esses três dias, as pessoas não podiam ver umas às outras, e ninguém pôde sair do seu lugar. Mas onde os israelitas moravam não faltou luz. ");
INSERT INTO poronbv_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Então o faraó mandou chamar Moisés e lhe disse: “Podem ir servir o Senhor, e levem também as crianças. Deixem somente seus rebanhos e os bois”. ");
INSERT INTO poronbv_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moisés respondeu: “Nesse caso, Vossa Majestade deveria nos dar os animais para os sacrifícios e ofertas queimadas que vamos apresentar ao Senhor, nosso Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Pois nós vamos levar os nossos rebanhos. Nenhum casco de animal ficará aqui. Precisamos levar tudo para o culto ao Senhor. Só quando chegarmos lá é que vamos saber que animais devemos sacrificar”. ");
INSERT INTO poronbv_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Porém, o Senhor endureceu o coração do faraó, e ele se recusou a deixá-los ir. ");
INSERT INTO poronbv_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Além disso, o faraó disse a Moisés: “Saia da minha presença, e nunca mais apareça diante de mim! No dia em que você vir o meu rosto, você morrerá”. ");
INSERT INTO poronbv_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moisés respondeu-lhe: “Nisso Vossa Majestade está certo. De fato, nunca mais verei a sua face”. ");
INSERT INTO poronbv_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Disse o Senhor a Moisés: “Enviarei mais uma praga sobre o faraó e sobre o Egito. Então o faraó vai deixar o meu povo sair. Na verdade ele vai expulsar vocês daqui. ");
INSERT INTO poronbv_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Agora instrua bem o povo. Fale a todo homem e a toda mulher que peçam aos seus vizinhos objetos de prata e de ouro”. ");
INSERT INTO poronbv_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","E o Senhor fez com que os egípcios se tornassem favoráveis aos israelitas. Moisés se tornou um homem famoso em todo o Egito, tanto entre os oficiais do faraó quanto por todo o povo. ");
INSERT INTO poronbv_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moisés disse ao faraó: “Assim diz o Senhor: ‘Por volta de meia-noite, passarei por todo o Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","E todos os filhos mais velhos morrerão, desde o filho mais velho do faraó, que se assenta no seu trono, até o filho mais velho da modesta serva que trabalha no moinho. Até mesmo as primeiras crias dos animais vão morrer. ");
INSERT INTO poronbv_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Haverá grande clamor em todo o Egito. Nunca antes se ouviu um clamor assim no Egito, nem jamais se ouvirá! ");
INSERT INTO poronbv_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mas os israelitas estarão seguros. Nem sequer um cão latirá contra um homem ou um animal’. E assim vocês ficarão sabendo que o Senhor fez distinção entre os egípcios e os israelitas. ");
INSERT INTO poronbv_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Então os seus oficiais virão a mim e se inclinarão diante de mim e vão dizer: ‘Saiam logo do Egito, você e seu povo!’ Só então sairei”. Depois de falar estas coisas ao faraó, Moisés saiu da presença dele muito irado. ");
INSERT INTO poronbv_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","O Senhor tinha dito a Moisés: “O faraó não vai dar ouvidos a você, para que os meus sinais se multipliquem na terra do Egito”. ");
INSERT INTO poronbv_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moisés e Arão realizaram todos aqueles sinais, como manifestação do poder de Deus, diante do faraó, mas o Senhor endureceu o coração do faraó, e ele não quis deixar Israel sair do país. ");
INSERT INTO poronbv_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","O Senhor disse a Moisés e a Arão, no Egito: ");
INSERT INTO poronbv_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Este mês passa a ser o mais importante para Israel. Será o primeiro mês do ano (no calendário dos hebreus). ");
INSERT INTO poronbv_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Reúna toda a comunidade de Israel e diga: No décimo dia deste mês, cada um vai pegar um cordeiro. Dentro dos grupos de famílias, terá de ser um cordeiro para cada família. ");
INSERT INTO poronbv_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Se uma família for pequena demais para um cordeiro, ela convidará o seu vizinho mais próximo. É só calcular quantas pessoas bastam para comer um cordeiro. ");
INSERT INTO poronbv_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","O cordeiro deverá ser sem defeito, macho de um ano. Em vez de cordeiro, pode ser um cabrito. ");
INSERT INTO poronbv_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Guardem o animal até o décimo quarto dia do mês. Nesse dia, no fim da tarde, toda a comunidade de Israel matará seu cordeiro ou cabrito. ");
INSERT INTO poronbv_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","E o sangue será passado no alto e nas laterais das portas das casas nas quais vocês comerão o animal. ");
INSERT INTO poronbv_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Naquela mesma noite terão de comer carne assada no fogo, além de pães sem fermento e ervas amargas. ");
INSERT INTO poronbv_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Não comam a carne crua, nem cozida em água. Tanto a cabeça como as pernas e as vísceras terão de ser assadas no fogo. ");
INSERT INTO poronbv_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Comam tudo o que puderem durante a noite. O que sobrar, na manhã seguinte precisará ser queimado. ");
INSERT INTO poronbv_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ao comerem, estejam preparados para sair: já vestidos, sandálias nos pés e o cajado na mão! E comam depressa! Essa é a Páscoa do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Naquela mesma noite passarei pela terra do Egito e matarei todos os filhos mais velhos, tanto dos homens como dos animais. Assim cumprirei a sentença de juízo que lancei sobre os deuses do Egito. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","O sangue vai servir de sinal nas casas em que vocês estiverem. Quando eu vir o sangue, passarei por cima, sem ferir ninguém. Assim, a praga de destruição com a qual ferirei o Egito não atingirá vocês. ");
INSERT INTO poronbv_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Esse dia será um memorial que vocês e seus descendentes celebrarão como festa ao Senhor. Essa celebração é uma lei permanente. ");
INSERT INTO poronbv_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Durante sete dias comerão pães sem fermento. Logo no primeiro dia tratem de jogar fora todo o fermento que tiverem em casa. Porque, quem comer coisa fermentada, do primeiro ao sétimo dia, será eliminado do povo de Israel. ");
INSERT INTO poronbv_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","No primeiro e no último dia da semana, convoquem uma santa convocação. Nesses dias não façam nenhum trabalho, a não ser a preparação da comida. Somente isso poderá ser feito. ");
INSERT INTO poronbv_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Celebrem a festa dos pães sem fermento, para lembrar que nesse dia eu tirei todo o povo de Israel do Egito. Portanto, vocês guardarão este dia para sempre por todas as suas gerações. ");
INSERT INTO poronbv_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Comerão pães sem fermento, desde a tarde do décimo quarto dia até o entardecer do vigésimo primeiro dia. ");
INSERT INTO poronbv_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Durante os sete dias, que ninguém tenha fermento em casa! Porque aquele que comer pão fermentado será eliminado da comunidade de Israel. E isso vale tanto para o estrangeiro como para o nascido nas terras de Israel. ");
INSERT INTO poronbv_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Em todas as casas não comam coisa alguma fermentada. E quanto aos pães, só comam pães sem fermento”. ");
INSERT INTO poronbv_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Moisés convocou todos os líderes de Israel e disse: “Escolham cordeiros suficientes para as suas famílias. Sacrifiquem-nos para celebrar a Páscoa. ");
INSERT INTO poronbv_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Molhem um feixe de hissopo no sangue que estiver na bacia (usada para sangrar o animal) e passem o sangue no alto e nas laterais da porta. E que ninguém saia de casa até o dia seguinte! ");
INSERT INTO poronbv_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Porque o Senhor vai passar para matar os egípcios. Mas quando vir o sangue no alto e nas laterais da porta, ele passará sobre aquela porta e não permitirá que o destruidor entre nas casas para matá-los. ");
INSERT INTO poronbv_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Portanto, obedeçam a essas instruções como lei permanente para vocês e para os seus descendentes. ");
INSERT INTO poronbv_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","E quando estiverem morando na terra que o Senhor vai dar a vocês, como prometeu, continuem fazendo essa comemoração. ");
INSERT INTO poronbv_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Quando os seus filhos lhes perguntarem: ‘Que comemoração é esta?’ ");
INSERT INTO poronbv_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","respondam-lhes: ‘É o sacrifício da Páscoa ao Senhor. Isto nos faz lembrar que o Senhor passou por cima das casas dos israelitas no Egito e poupou nossas casas quando matou os egípcios’ ”. Ao ouvir essas coisas, o povo se inclinou e adorou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Os israelitas foram e fizeram tudo o que o Senhor tinha mandado por meio de Moisés e Arão. ");
INSERT INTO poronbv_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Então, à meia-noite, o Senhor matou todos os filhos mais velhos do Egito, desde o filho mais velho do faraó, que sentava no trono, até o filho mais velho do escravo que estava preso no calabouço. Também morreram todas as primeiras crias dos animais. ");
INSERT INTO poronbv_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","No meio da noite o faraó, todos os seus oficiais e todos os egípcios se levantaram. E houve grande clamor no Egito, porque não havia casa que não tivesse um morto. ");
INSERT INTO poronbv_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Naquela mesma noite, o faraó mandou chamar Moisés e Arão e disse-lhes: “Aprontem-se rápido, e saiam já do meio do meu povo, vocês e os demais israelitas. Vão servir ao Senhor, como vocês pediram. ");
INSERT INTO poronbv_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Levem também os seus rebanhos e os seus bois, como vocês tinham dito. Vão embora e me abençoem também!” ");
INSERT INTO poronbv_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Os egípcios pressionavam para o povo sair o mais rápido possível do país, dizendo: “Todos nós vamos morrer!” ");
INSERT INTO poronbv_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Os israelitas amarraram em trouxas as amassadeiras, a massa de pão sem fermento e as roupas. Em seguida colocaram as trouxas sobre os ombros. ");
INSERT INTO poronbv_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Antes de partir, pediram aos egípcios objetos de prata e de ouro, além de roupas. Tudo como Moisés tinha dito. ");
INSERT INTO poronbv_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","O Senhor fez com que os egípcios dessem de boa vontade, de modo que lhes davam tudo o que pediam. Dessa forma os israelitas tomaram as riquezas dos egípcios. ");
INSERT INTO poronbv_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Assim, partiram os israelitas de Ramessés para Sucote. Era uma multidão de cerca de seiscentos mil homens a pé, além de mulheres e crianças. ");
INSERT INTO poronbv_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Foram também com eles uma multidão de estrangeiros, além de grandes rebanhos, tanto de bois como de ovelhas e cabras — um número enorme de animais. ");
INSERT INTO poronbv_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Com a massa que levaram do Egito, cozinharam pães e bolos sem fermento. A massa não tinha fermentado, porque foram expulsos do Egito. Não puderam preparar outros alimentos. ");
INSERT INTO poronbv_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ora, o tempo que os israelitas habitaram no Egito foi de quatrocentos e trinta anos. ");
INSERT INTO poronbv_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","No fim desse período, todas as tribos do povo do Senhor saíram do Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Por isso, a noite desse dia ficou marcada para sempre na história de Israel, porque foi nessa noite que o Senhor tirou seu povo do Egito. Essa é a noite do Senhor! Deve ser comemorada por todos os israelitas, por todas as suas gerações. ");
INSERT INTO poronbv_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","O Senhor disse ainda a Moisés e Arão: “Esta é a ordenança da Páscoa: Nenhum estrangeiro poderá comê-la. ");
INSERT INTO poronbv_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Porém, todo escravo comprado por dinheiro, depois de ter sido circuncidado, poderá comer a Páscoa. ");
INSERT INTO poronbv_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Mas o estrangeiro que estiver de passagem e o que vive de salário não comerão dela. ");
INSERT INTO poronbv_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“O cordeiro da Páscoa deverá ser comido numa só casa. Nenhum pedaço de carne deverá ser levado para fora da casa e nenhum osso do cordeiro poderá ser quebrado. ");
INSERT INTO poronbv_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Todos os membros da comunidade de Israel terão que celebrar a Páscoa. ");
INSERT INTO poronbv_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Quando algum estrangeiro estiver morando na casa de um israelita e quiser participar da Páscoa do Senhor, terá de circuncidar todas as pessoas do sexo masculino. Então ele poderá participar da Páscoa, e será considerado como se fosse cidadão natural de Israel. Mas notem bem! Nenhum homem incircunciso poderá participar da Páscoa. ");
INSERT INTO poronbv_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","A mesma lei se aplicará tanto ao cidadão natural de Israel quanto ao estrangeiro que estiver vivendo nas terras de Israel”. ");
INSERT INTO poronbv_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Todos os israelitas fizeram o que o Senhor tinha ordenado por meio de Moisés e Arão. ");
INSERT INTO poronbv_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Naquele mesmo dia, o Senhor tirou o povo de Israel do Egito, segundo as suas tribos. ");
INSERT INTO poronbv_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","O Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Consagre a mim todo primeiro filho homem. O primeiro filho israelita me pertence. Isso se refere não apenas aos homens, mas também aos animais”. ");
INSERT INTO poronbv_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Então Moisés disse ao povo: “Celebrem esse dia! É o dia em que vocês saíram do Egito, da terra da escravidão. É o Senhor que nos tirou daqui, com seu grande poder. Portanto, não comam pão fermentado. ");
INSERT INTO poronbv_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Vocês estão saindo no mês de abibe. ");
INSERT INTO poronbv_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Quando o Senhor os fizer entrar na terra em que vivem os cananeus, os heteus, os amorreus, os heveus e os jebuseus — a qual ele jurou aos seus antepassados que daria a vocês, terra que jorra leite e mel — vocês deverão fazer essa comemoração neste mês. ");
INSERT INTO poronbv_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Durante sete dias vocês só poderão comer pães sem fermento. No último dia da semana, haverá uma festa solene dedicada ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Naqueles sete dias comam pão sem fermento. Em toda a terra não deverá haver fermento, nem pão fermentado. ");
INSERT INTO poronbv_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“Nessa ocasião, cada um contará ao seu filho, dizendo: ‘Esta comemoração é realizada pelo que o Senhor fez por mim, quando me tirou do Egito’. ");
INSERT INTO poronbv_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Assim, a Páscoa servirá de sinal em sua mão e comemoração diante dos seus olhos, para que a lei do Senhor esteja nos seus lábios. Pois o Senhor o tirou do Egito com grandes demonstrações de poder. ");
INSERT INTO poronbv_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Por isso, devemos guardar este mandamento na data certa, todos os anos. ");
INSERT INTO poronbv_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Quando o Senhor introduzir vocês na terra dos cananeus, terra que jurou dar a você e aos seus pais, ");
INSERT INTO poronbv_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","separem para o Senhor todo o primeiro filho, do sexo masculino, e toda primeira cria dos animais, que seja macho. Eles pertencem ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Toda primeira cria macho, nascida da jumenta, precisará ser resgatada com o cordeiro. Ou seja, em vez do jumento, será consagrado a mim um cordeiro. Agora, se não for possível resgatar o jumento, ele precisará ser morto. Quanto aos homens, todo primeiro filho precisará ser resgatado. ");
INSERT INTO poronbv_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Mais tarde, quando o seu filho perguntar a você: ‘Pai, o que significa isto?’ você bem sabe o que responder. ‘É que o Senhor nos tirou do Egito, da terra da escravidão, com demonstrações de poder’, você dirá a seu filho. ");
INSERT INTO poronbv_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","E continuará contando: ‘Quando o coração do faraó ficou endurecido, recusou-se a deixar-nos sair. Então o Senhor matou todos os primeiros filhos do Egito, tanto dos homens quanto dos animais. Por isso o nosso povo oferece em sacrifício ao Senhor todo primeiro filhote macho e resgatamos nossos primeiros filhos’. ");
INSERT INTO poronbv_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","“Isso será como sinal em sua mão e símbolo entre seus olhos. Para que lembremos sempre que o Senhor nos tirou do Egito com sua forte mão”. ");
INSERT INTO poronbv_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Quando o faraó deixou sair o povo, Deus não o levou pela estrada que vai para a terra dos filisteus. Era o caminho mais curto, mas Deus disse: “Não por lá, porque os filisteus estão em guerra. Ora, se os israelitas virem a guerra, podem se arrepender e querer voltar para o Egito”. ");
INSERT INTO poronbv_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Por isso, Deus fez o povo dar a volta pelo deserto, pelo caminho que levava ao mar Vermelho. Os israelitas marcharam em grupos organizados, armados para guerrear, ao saírem do território egípcio. ");
INSERT INTO poronbv_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moisés levou os ossos de José, pois José tinha feito os israelitas jurarem, quando disse: “Deus certamente virá socorrer vocês. Quando isso acontecer, levem daqui os meus ossos”. ");
INSERT INTO poronbv_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Os israelitas saíram de Sucote e acamparam em Etã, na entrada do deserto. ");
INSERT INTO poronbv_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","O Senhor ia adiante deles, para mostrar o caminho. De dia, o Senhor ia numa coluna de nuvem, e de noite, numa coluna de fogo, para iluminar o caminho. Assim podiam caminhar de dia e de noite. ");
INSERT INTO poronbv_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","A coluna de nuvem, de dia, e a coluna de fogo, de noite, nunca se afastaram do povo de Israel. ");
INSERT INTO poronbv_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","O Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Diga ao povo que volte a acampar perto de Pi-Hairote, entre Migdol e o mar. Acampem à beira-mar, de frente para Baal-Zefom. ");
INSERT INTO poronbv_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Então o faraó pensará: ‘Veja só! Os israelitas estão andando sem rumo. Eles estão presos entre o deserto e o mar!’ ");
INSERT INTO poronbv_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Então endurecerei o coração do faraó, e ele perseguirá o meu povo. Todavia, eu serei glorificado com o que vou fazer com o faraó e com todo o seu exército. Aí os egípcios vão saber que eu sou o Senhor”. Os israelitas fizeram o que o Senhor mandou. ");
INSERT INTO poronbv_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Quando contaram ao rei do Egito que os israelitas estavam fugindo, ele e seus oficiais mudaram de ideia e disseram: “O que foi que fizemos? Como fomos deixar que Israel parasse de nos servir?” ");
INSERT INTO poronbv_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Faraó mandou preparar logo a sua carruagem e levou consigo o seu exército. ");
INSERT INTO poronbv_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Levou também seiscentos carros escolhidos e todos os carros do Egito; cada um era chefiado por um oficial de comando do exército egípcio. ");
INSERT INTO poronbv_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","O Senhor endureceu o coração do faraó, rei do Egito, e este perseguiu o povo de Israel, que marchava de maneira vitoriosa. ");
INSERT INTO poronbv_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Todas as forças armadas do Egito se lançaram à perseguição, com todos os soldados da infantaria, a cavalaria e os carros de guerra do faraó, e alcançaram os israelitas em Pi-Hairote, junto ao mar, em frente de Baal-Zefom, onde estavam acampados. ");
INSERT INTO poronbv_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","De repente, os israelitas olharam e viram o faraó chegando com todo aquele exército egípcio. Ficaram apavorados e clamaram ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Começaram a queixar-se e disseram a Moisés: “Para morrer dessa forma no deserto, seria melhor ter ficado no Egito! Ou você acha que lá não existem túmulos para nós? Por que você fez isso conosco, fazendo-nos sair do Egito? ");
INSERT INTO poronbv_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Lembra do que dizíamos lá no Egito? Pois dizíamos: ‘Deixe-nos em paz! Trabalharemos para os egípcios’. Melhor viver como escravos dos egípcios do que morrer neste deserto!” ");
INSERT INTO poronbv_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moisés respondeu ao povo: “Não fiquem com medo! Tenham calma e vejam o que o Senhor vai fazer para nos libertar! Vai ser hoje! Porque os egípcios que vocês estão vendo, não os verão nunca mais! ");
INSERT INTO poronbv_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","O próprio Senhor vai lutar por vocês. Portanto, parem de reclamar!” ");
INSERT INTO poronbv_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","O Senhor disse a Moisés: “Por que você está clamando a mim? Mande o povo de Israel marchar! ");
INSERT INTO poronbv_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Quanto a você, estenda a vara sobre o mar, e as águas se dividirão, e abrirão caminho para que os israelitas passem pelo mar pisando em terra seca. ");
INSERT INTO poronbv_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Eu, porém, endurecerei o coração dos egípcios para que queiram atravessar também. E eu serei glorificado com a derrota do faraó e de todo o seu exército, ou seja, a infantaria, a cavalaria e os carros de guerra. ");
INSERT INTO poronbv_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","E os egípcios saberão que eu sou o Senhor, quando eu for glorificado com a derrota do faraó, com seus carros de guerra e seus cavaleiros”. ");
INSERT INTO poronbv_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Então o Anjo de Deus, que ia à frente do exército de Israel, colocou-se atrás dele; da mesma forma a coluna de nuvem se retirou de diante deles e colocou-se atrás deles. ");
INSERT INTO poronbv_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ela ficou entre o povo de Israel e os egípcios. Naquela noite, a coluna de fogo trouxe trevas para os egípcios e luz para os israelitas! Assim, os egípcios não puderam aproximar-se dos israelitas a noite inteira. ");
INSERT INTO poronbv_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Então Moisés estendeu a vara sobre o mar, e um forte vento oriental soprou a noite inteira e afastou o mar e o tornou em terra seca. As águas se dividiram, ");
INSERT INTO poronbv_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","e os israelitas entraram pelo meio do mar em terra seca, tendo uma parede de água à sua direita e outra à sua esquerda. ");
INSERT INTO poronbv_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Os egípcios os perseguiram, e todos os carros de guerra e os cavaleiros do faraó foram atrás deles até o meio do mar. ");
INSERT INTO poronbv_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","De madrugada, o Senhor olhou da coluna de fogo e de nuvem para o exército dos egípcios e causou uma grande confusão entre eles. ");
INSERT INTO poronbv_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Fez com que as rodas dos seus carros emperrassem, de forma que tinham grande dificuldade em avançar. Então disseram os egípcios: “Fujamos daqui! Porque o Senhor está lutando a favor deles e contra nós!” ");
INSERT INTO poronbv_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Quando Israel já estava do outro lado, o Senhor disse a Moisés: “Estenda a mão sobre o mar, para que as águas cubram os egípcios e os carros de guerra e seus cavaleiros”. ");
INSERT INTO poronbv_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Então Moisés estendeu a mão sobre o mar, e ao amanhecer o mar voltou à posição normal. Quando os egípcios tentaram fugir, foram ao encontro das águas, e o Senhor os afogou no meio do mar. ");
INSERT INTO poronbv_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","As águas voltaram e cobriram os carros de guerra e os seus cavaleiros e todo o exército do faraó que havia perseguido Israel pelo fundo do mar, e ninguém sobreviveu. ");
INSERT INTO poronbv_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Com os israelitas foi diferente. Eles atravessaram o mar em terra seca, por entre as duas paredes de águas! ");
INSERT INTO poronbv_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Assim, o Senhor salvou Israel dos egípcios naquele dia, e os israelitas viram os egípcios mortos na praia. ");
INSERT INTO poronbv_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israel viu o grande poder que o Senhor exercera contra os egípcios. O povo temeu o Senhor, e passou a confiar nele e em seu servo Moisés. ");
INSERT INTO poronbv_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Então Moisés e os israelitas cantaram este hino ao Senhor: “Cantarei ao Senhor, porque ele venceu maravilhosamente. Lançou nas profundezas do mar o cavalo e o seu cavaleiro! ");
INSERT INTO poronbv_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","O Senhor é a minha força e a minha canção; ele é a minha salvação! Ele é o meu Deus; por isso cantarei louvores a ele. Ele é Deus de meu pai; por isso eu o exaltarei. ");
INSERT INTO poronbv_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","O Senhor é guerreiro! O seu nome é Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Lançou no fundo do mar os carros de guerra do faraó e o seu exército. Os seus melhores oficiais morreram afogados no mar Vermelho. ");
INSERT INTO poronbv_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Águas profundas os cobriram; desceram direto para o fundo, como uma pedra! ");
INSERT INTO poronbv_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Senhor, a sua mão direita é majestosa em poder! Senhor, a sua mão direita despedaçou o inimigo! ");
INSERT INTO poronbv_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Na grandeza da sua majestade, derrubou os que se levantaram contra o Senhor. Enviou o seu furor, que consumiu os seus inimigos, como o fogo consome a palha. ");
INSERT INTO poronbv_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Com um sopro das suas narinas, as águas se amontoaram. As águas turbulentas ficaram firmes como duas paredes, e as águas profundas se solidificaram no coração do mar. ");
INSERT INTO poronbv_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“O inimigo dizia: ‘Vou perseguir e alcançá-los, e repartirei os bens que conseguir tomar. Com a espada os destruirei’. ");
INSERT INTO poronbv_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Mas o Senhor enviou o seu sopro, e o mar os encobriu. Afundaram como chumbo nas águas profundas. ");
INSERT INTO poronbv_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Quem entre os deuses é semelhante ao Senhor? Quem é como o Senhor? Quem é majestoso em santidade? Quem é terrível em feitos gloriosos? Quem realiza maravilhas como o Senhor? ");
INSERT INTO poronbv_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","O Senhor estendeu a sua mão direita, e a terra os engoliu. ");
INSERT INTO poronbv_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Por causa do seu amor, guiou o povo que libertou. Com o seu poder conduziu o seu povo ao lugar santo que escolheu para morar. ");
INSERT INTO poronbv_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Os povos souberam o que aconteceu e tremeram! A angústia apoderou-se do povo da Filístia. ");
INSERT INTO poronbv_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Os comandantes de Edom estão aflitos. Os poderosos de Moabe tremem. O povo de Canaã esmorece. ");
INSERT INTO poronbv_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Estão dominados de terror e medo, pela força do seu braço, e estão paralisados como pedras, até que passe o seu povo, ó Senhor, até que passe o povo que o Senhor comprou. ");
INSERT INTO poronbv_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","O Senhor fará com que o seu povo entre e seja plantado no monte do seu santo nome. Sim, o seu povo morará no lugar que o Senhor preparou, no seu lar, no santuário que o Senhor mesmo construiu. ");
INSERT INTO poronbv_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","O Senhor reinará para todo o sempre!” ");
INSERT INTO poronbv_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Quando os cavalos, os cavaleiros e os carros de guerra do faraó entraram no mar, o Senhor lançou sobre eles as paredes de água, mas os israelitas atravessaram o mar pisando em terra seca! ");
INSERT INTO poronbv_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Então Miriã, a profetisa, irmã de Arão, tomou um tamborim e começou a dançar, acompanhada pelas mulheres. ");
INSERT INTO poronbv_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Foi esta a canção de Miriã: “Cantem ao Senhor, porque ele triunfou maravilhosamente. Precipitou no mar o cavalo e o seu cavaleiro!” ");
INSERT INTO poronbv_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Depois Moisés conduziu os israelitas desde o mar Vermelho até o deserto de Sur. Ali andaram três dias sem achar água. ");
INSERT INTO poronbv_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Finalmente chegaram a Mara e acharam água. Mas não puderam bebê-la porque era amarga. Por isso aquele lugar chamou-se Mara. ");
INSERT INTO poronbv_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Então o povo começou a murmurar contra Moisés, dizendo: “O que beberemos?” ");
INSERT INTO poronbv_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moisés clamou ao Senhor, e este lhe mostrou um arbusto, e Moisés o lançou na água, e a água se tornou boa. Em Mara o Senhor lhes deu leis e uma ordem, e os colocou à prova, ");
INSERT INTO poronbv_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","dizendo: “Se vocês derem atenção à voz do Senhor, o seu Deus, se fizerem o que for correto aos seus olhos, e se guardarem os seus mandamentos e obedecerem todos os seus estatutos, não deixarei que vocês sofram nenhuma das doenças que trouxe sobre os egípcios. Eu sou o Senhor que os cura”. ");
INSERT INTO poronbv_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Depois os israelitas foram embora dali e chegaram a Elim, onde acamparam. Nesse lugar havia doze fontes de água e setenta palmeiras. ");
INSERT INTO poronbv_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Toda a comunidade de Israel partiu de Elim e foi para o deserto de Sim, que fica entre Elim e o monte Sinai. Chegaram lá no décimo quinto dia do segundo mês, depois da saída do Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ali, no deserto, toda a comunidade de Israel reclamou a Moisés e Arão. ");
INSERT INTO poronbv_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Os israelitas disseram: “Seria melhor que o Senhor tivesse nos matado no Egito! Pelo menos tínhamos panelas de carne e pão à vontade. Mas vocês nos trouxeram a este deserto para matar de fome toda esta multidão!” ");
INSERT INTO poronbv_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Nessa situação, disse o Senhor a Moisés: “Vou fazer chover pão do céu, e o povo deverá sair todas as manhãs para recolher pão suficiente para cada dia. Vou provar o meu povo. Quero ver se segue ou não as minhas ordens. ");
INSERT INTO poronbv_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","No sexto dia da semana, porém, deverão colher uma porção dobrada”. ");
INSERT INTO poronbv_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moisés e Arão convocaram a comunidade de Israel. Disseram a todos os israelitas: “Ao entardecer, vocês vão saber que foi o Senhor que tirou vocês do Egito, ");
INSERT INTO poronbv_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","e amanhã cedo vocês verão outra demonstração da glória do Senhor, porque ele ouviu a queixa de vocês. Suas queixas não são contra nós, pois quem somos nós para que vocês reclamem a nós?” ");
INSERT INTO poronbv_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Disse ainda Moisés: “O Senhor dará carne a vocês para comerem ao entardecer e pão à vontade pela manhã, porque ele ouviu as suas queixas contra ele. Pois quem somos nós? Vocês não estão murmurando contra nós, e sim contra o Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moisés disse a Arão: “Diga a toda a comunidade de Israel para que se apresente diante do Senhor, pois o Senhor ouviu as queixas feitas contra ele”. ");
INSERT INTO poronbv_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Arão chamou o povo. Enquanto isso toda a comunidade de Israel olhou para o deserto e viu aparecer na coluna de nuvem a glória do Senhor! ");
INSERT INTO poronbv_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Ouvi as queixas dos israelitas. Diga a eles: Ao entardecer vocês vão comer carne, e de manhã se fartarão de pão. Assim saberão que eu sou o Senhor, o seu Deus”. ");
INSERT INTO poronbv_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","De fato, ao entardecer apareceram muitas codornizes e cobriram o lugar onde estavam acampados. E, pela manhã, o deserto ao redor do acampamento estava coberto de orvalho. ");
INSERT INTO poronbv_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Quando o orvalho evaporou, flocos finos semelhantes a escamas ou geada estavam sobre a superfície do deserto. ");
INSERT INTO poronbv_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Quando os israelitas viram aquilo, começaram a perguntar uns aos outros: “Que é isso?”, pois não tinham ideia do que se tratava. Disse-lhes Moisés: “Isto é maná que o Senhor está dando para vocês comerem. ");
INSERT INTO poronbv_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Assim ordenou o Senhor: ‘Cada chefe de família deve recolher todo dia a quantidade suficiente para a sua família, uma tigela por pessoa’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Os israelitas fizeram como lhes foi dito. Alguns recolhiam mais, outros menos. ");
INSERT INTO poronbv_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Porém quando mediam com a tigela não sobrava nem faltava para ninguém. Cada um recolheu quanto podia comer. ");
INSERT INTO poronbv_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moisés preveniu todos, dizendo: “Não deixem alguma sobra para o dia seguinte”. ");
INSERT INTO poronbv_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Todavia, alguns deles não deram ouvidos a Moisés e guardaram um pouco de maná para o dia seguinte, mas esse criou bichos e começou a cheirar mal. Por isso Moisés ficou irado com eles. ");
INSERT INTO poronbv_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Assim se acostumaram a recolher diariamente o maná, em quantidade suficiente para cada dia. Eles tinham de fazer isso cedo, porque quando o sol subia, derretia o maná. ");
INSERT INTO poronbv_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","No sexto dia da semana, recolheram pão em dobro — duas tigelas para cada um; e os líderes da comunidade foram contar isso a Moisés, ");
INSERT INTO poronbv_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","que lhes explicou: “Mas foi isso que o Senhor mandou: ‘Amanhã será dia de descanso, o santo sábado do Senhor. Assim, preparem, assem e cozinhem o que quiserem — bolo de maná assado no forno, ou maná cozido na água. O que sobrar podem guardar para a manhã seguinte’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","E eles guardaram até a manhã seguinte, como Moisés tinha mandado, e não criou bichos, nem cheirou mal. ");
INSERT INTO poronbv_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moisés disse: “Podem comer o pão do céu recolhido ontem, pois hoje é sábado, o dia de descanso separado para o Senhor. Hoje vocês não vão encontrar maná no terreno do acampamento. ");
INSERT INTO poronbv_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Durante seis dias vocês podem recolhê-lo, mas no sétimo não. O sétimo dia é o sábado, dia de descanso”. ");
INSERT INTO poronbv_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Apesar disso alguns teimaram em recolher maná no sétimo dia, mas não encontraram nada. ");
INSERT INTO poronbv_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Então o Senhor disse a Moisés: “Até quando vocês se recusarão a obedecer aos meus mandamentos e às minhas leis? ");
INSERT INTO poronbv_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Eu separei o sétimo dia para descanso do meu povo. Por isso dou maná para dois dias no sexto dia da semana”. ");
INSERT INTO poronbv_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Então o povo aprendeu a descansar no sétimo dia. ");
INSERT INTO poronbv_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Foi o povo de Israel que deu ao pão do céu o nome de maná. O maná era branco, semelhante à semente de coentro e tinha gosto de bolo de mel. ");
INSERT INTO poronbv_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moisés disse: “O Senhor mandou separar uma tigela cheia de maná. Esse maná ficará guardado de geração em geração: ‘Para que os seus descendentes vejam o pão que lhes dei no deserto, depois que os tirei do deserto’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","“Pegue um vaso”, disse Moisés a Arão, “e despeje nele uma tigela de maná. Depois coloque o vaso diante do Senhor. Assim ficará guardado para nossos descendentes, de geração em geração”. ");
INSERT INTO poronbv_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Arão obedeceu. Ele colocou o vaso cheio de maná diante do Senhor, junto às tábuas da aliança, para que ficasse guardado ali. ");
INSERT INTO poronbv_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Os israelitas comeram maná durante 40 anos, até entrarem em terras habitáveis. Eles comeram maná até chegarem às fronteiras de Canaã. ");
INSERT INTO poronbv_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","A tigela (ômer) era a décima parte do efa. ");
INSERT INTO poronbv_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Toda comunidade de Israel partiu do deserto de Sim, andando de um lugar para o outro, conforme o Senhor mandava. Acamparam em Refidim, onde não havia água para beber. ");
INSERT INTO poronbv_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Por isso o povo queixou-se a Moisés, exigindo: “Dê-nos água para beber”. Moisés respondeu-lhes: “Por que estão brigando comigo? Por que estão provocando o Senhor?” ");
INSERT INTO poronbv_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Mas o povo estava com sede e continuou murmurando a Moisés: “Por que você nos tirou do Egito? Para matar de sede a nós, os nossos filhos e os nossos rebanhos?” ");
INSERT INTO poronbv_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Então Moisés clamou ao Senhor: “O que farei com este povo? Estão a ponto de me apedrejar!” ");
INSERT INTO poronbv_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","O Senhor respondeu-lhe: “Vá à frente do povo e leve com você alguns líderes de Israel. Tenha na mão a vara que você usou para golpear as águas do rio Nilo. ");
INSERT INTO poronbv_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Eu estarei à sua espera sobre a rocha no monte Horebe. Bata com a vara na rocha, e dela sairá água, e o povo terá água para beber”. Moisés fez isso diante dos líderes de Israel. ");
INSERT INTO poronbv_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Moisés chamou aquele lugar de Massá e Meribá, porque ali os israelitas reclamaram e puseram o Senhor à prova, ao dizer: “O Senhor está conosco ou não?” ");
INSERT INTO poronbv_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Então Israel foi atacado pelas forças de Amaleque, em Refidim. ");
INSERT INTO poronbv_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moisés deu estas ordens a Josué: “Escolha alguns homens e lute contra os amalequitas. Amanhã ficarei no alto do monte, segurando a vara de Deus”. ");
INSERT INTO poronbv_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josué fez o que Moisés mandou, e lutou contra os amalequitas. Moisés, Arão e Hur subiram até o alto do monte. ");
INSERT INTO poronbv_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Enquanto Moisés mantinha as mãos erguidas, os israelitas venciam; quando, porém, baixava o braço, os amalequitas venciam. ");
INSERT INTO poronbv_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Quando Moisés sentiu o peso das mãos, pegaram uma pedra e puseram por baixo dele e Moisés ficou sentado nela. Arão e Hur ficaram sustentando as mãos dele, um de cada lado, de modo a permanecerem firmes até o pôr do sol. ");
INSERT INTO poronbv_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","E Josué derrotou o exército de Amalaque ao fio da espada! ");
INSERT INTO poronbv_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Depois o Senhor disse a Moisés: “Escreva isso num rolo para que seja lembrado e repita-o a Josué; porque vou acabar com a fama de Amaleque para sempre debaixo do céu!” ");
INSERT INTO poronbv_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moisés construiu ali um altar e o chamou de “O Senhor é a minha bandeira”. ");
INSERT INTO poronbv_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","E disse: “O Senhor jurou que guerreará contra os amalequitas de geração em geração”. ");
INSERT INTO poronbv_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetro, sacerdote de Midiã, sogro de Moisés, ficou sabendo de tudo o que Deus tinha feito a Moisés e pelo povo de Israel; como o Senhor havia tirado Israel do Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Moisés tinha mandado sua mulher Zípora e seus filhos para a casa de Jetro, que a recebeu ");
INSERT INTO poronbv_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","com os seus dois filhos. Um se chamava Gérson, pois Moisés disse: “Sou forasteiro em terra estranha”. ");
INSERT INTO poronbv_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","O outro se chamava Eliézer, pois Moisés disse: “O Deus de meu pai foi minha ajuda e livrou-me da espada do faraó”. ");
INSERT INTO poronbv_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jetro, sogro de Moisés, com os filhos de Moisés e a sua mulher foram ao encontro de Moisés no deserto. Chegaram ao acampamento de Israel, perto do monte de Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jetro mandou este recado a Moisés: “Eu, seu sogro Jetro, estou indo encontrá-lo, e comigo estão a sua mulher e os seus filhos”. ");
INSERT INTO poronbv_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Então Moisés saiu ao encontro do sogro, inclinou-se e o beijou. Eles perguntaram um ao outro como estavam e entraram na tenda de Moisés. ");
INSERT INTO poronbv_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Então Moisés contou ao sogro tudo o que o Senhor tinha feito ao faraó e aos egípcios, por amor a Israel. Contou também como os israelitas tinham sofrido no Egito e como o Senhor os tinha livrado. ");
INSERT INTO poronbv_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetro alegrou-se com tudo que o Senhor tinha feito aos israelitas, libertando-os das mãos dos egípcios. ");
INSERT INTO poronbv_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ele disse: “Bendito seja o Senhor que libertou vocês das mãos dos egípcios e do faraó! ");
INSERT INTO poronbv_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Agora sei que o Senhor é maior do que todos os deuses, pois livrou este povo da mão dos egípcios, pois agiram com arrogância contra o povo!” ");
INSERT INTO poronbv_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Então Jetro, sogro de Moisés, ofereceu a Deus ofertas queimadas e sacrifícios. Vieram Arão e todos os líderes de Israel para comerem com o sogro de Moisés, diante de Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","No dia seguinte, Moisés sentou-se para julgar as questões do povo. E o povo estava em pé diante de Moisés, desde a manhã até o pôr do sol. ");
INSERT INTO poronbv_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Quando o sogro de Moisés viu tudo o que ele fazia pelo povo, disse: “O que você está fazendo? Por que só você se assenta para julgar e todo este povo espera em pé diante de você, desde a manhã até o pôr do sol?” ");
INSERT INTO poronbv_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moisés respondeu: “É que o povo me procura para que eu consulte a Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Cada vez que uma pessoa tem uma questão, vem a mim, para que eu decida quem tem razão, e ensino-lhes os mandamentos e as leis de Deus”. ");
INSERT INTO poronbv_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","O sogro de Moisés respondeu-lhe: “Não é bom o que você está fazendo. ");
INSERT INTO poronbv_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Desse jeito você e seu povo ficarão esgotados. Esse trabalho é pesado demais para você. Você não pode realizá-lo sozinho. ");
INSERT INTO poronbv_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Agora ouça o meu conselho, e que Deus o abençoe: Você deve trabalhar como representante do povo diante de Deus. Assim você levará a Deus as causas do povo. ");
INSERT INTO poronbv_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Além disso, você deve ensinar os estatutos e as leis de Deus e mostrar-lhes como deve ser sua conduta e quais são os seus deveres. ");
INSERT INTO poronbv_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Mas você deve escolher dentre o povo homens capazes, tementes a Deus, amantes da verdade e inimigos da avareza. Uns serão responsáveis por mil pessoas, outros, por cem, outros, por cinquenta e outros, responsáveis por dez pessoas. ");
INSERT INTO poronbv_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Eles julgarão o povo em todo o tempo. Trarão a você apenas as questões mais graves; todas as causas mais simples, eles mesmos resolverão. Com isso, a sua carga ficará mais leve. Na verdade, eles estarão ajudando você a levar a carga. ");
INSERT INTO poronbv_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Se você aceitar a minha proposta, e Deus a aprovar, você poderá suportar o peso do trabalho, e todo este povo voltará para casa em paz”. ");
INSERT INTO poronbv_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moisés aceitou o conselho do sogro e seguiu as sugestões dele. ");
INSERT INTO poronbv_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moisés escolheu homens capazes, de todo o Israel, e os colocou como líderes sobre o povo: chefes de mil, chefes de cem, chefes de cinquenta, e chefes de dez. ");
INSERT INTO poronbv_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Estes julgavam o povo todo o tempo. Os casos graves levavam a Moisés; os mais simples, porém, eles mesmos julgavam. ");
INSERT INTO poronbv_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Então Moisés se despediu de seu sogro, e este voltou para a sua terra. ");
INSERT INTO poronbv_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","No terceiro mês da saída dos israelitas da terra do Egito, no primeiro dia desse mês, chegaram ao deserto do Sinai. ");
INSERT INTO poronbv_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Levantaram acampamento de Refidim, foram para o Sinai e acamparam diante do monte. ");
INSERT INTO poronbv_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moisés subiu ao monte para falar com Deus. E o Senhor o chamou e disse: “Anuncie o seguinte aos descendentes de Jacó, os filhos de Israel: ");
INSERT INTO poronbv_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Vocês viram o que eu fiz aos egípcios e como trouxe vocês a mim como se estivesse levando vocês sobre asas de águias! ");
INSERT INTO poronbv_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Agora, se derem atenção cuidadosa ao que digo e cumprirem os termos da minha aliança, vocês serão minha propriedade particular, dentre todas as nações. Embora toda a terra seja minha, ");
INSERT INTO poronbv_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","vocês serão para mim um reino de sacerdotes, uma nação santa. Diga essas palavras aos israelitas”. ");
INSERT INTO poronbv_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moisés convocou os líderes de Israel e transmitiu a eles tudo o que o Senhor havia dito. ");
INSERT INTO poronbv_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","O povo respondeu a uma só voz: “Vamos fazer tudo o que o Senhor ordenou”. E Moisés levou ao Senhor a resposta do povo. ");
INSERT INTO poronbv_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","O Senhor disse a Moisés: “Falarei com você do meio de uma grossa nuvem. O povo ouvirá a minha voz e acreditará sempre em você”. Então Moisés relatou ao Senhor o que o povo tinha respondido. ");
INSERT INTO poronbv_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","E o Senhor disse a Moisés: “Tome providência para purificar os israelitas hoje e amanhã. Que eles lavem a roupa ");
INSERT INTO poronbv_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","e fiquem prontos no terceiro dia, porque no terceiro dia o Senhor descerá sobre o monte Sinai, à vista de todo o povo. ");
INSERT INTO poronbv_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Marque com cuidado limites para o povo em volta do monte e diga ao povo: ‘Tenham cuidado para não subirem no monte e não pisarem na linha dos limites demarcados. Aquele que tocar o monte será morto. ");
INSERT INTO poronbv_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ninguém deverá tocar o monte com a mão. Será apedrejado ou morto a flechadas, seja homem, seja animal. Quando a corneta soar com um toque comprido, então o povo poderá subir no monte’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moisés desceu do monte e consagrou o povo. E todos lavaram suas roupas. ");
INSERT INTO poronbv_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Disse Moisés ao povo: “Preparem-se para o terceiro dia, e não tenham relação sexual com suas esposas”. ");
INSERT INTO poronbv_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Quando amanheceu o terceiro dia, o povo estremeceu com o que viu e ouviu. Houve trovões e relâmpagos, uma grossa nuvem cobriu o monte, e ouviu-se um forte ressoar de trombeta. ");
INSERT INTO poronbv_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moisés levou o povo para fora do acampamento para encontrar-se com Deus ao pé do monte. ");
INSERT INTO poronbv_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Saía fumaça do monte Sinai, porque o Senhor tinha descido sobre ele no meio de labaredas de fogo. Subia fumaça como de uma fornalha. E todo o monte tremia violentamente. ");
INSERT INTO poronbv_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","O som da trombeta aumentava cada vez mais. Moisés falava, e Deus respondia por meio de trovões. ");
INSERT INTO poronbv_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","O Senhor desceu no alto do monte Sinai e mandou Moisés subir até lá. Moisés subiu, ");
INSERT INTO poronbv_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","e o Senhor disse a Moisés: “Desça e avise o povo para não ultrapassar os limites para ver o Senhor. É preciso dar esse aviso para evitar que muitos morram. ");
INSERT INTO poronbv_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Mesmo os sacerdotes, que estão acostumados a se apresentarem a mim, devem consagrar-se. Senão, eu os destruirei”. ");
INSERT INTO poronbv_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Então Moisés disse ao Senhor: “O povo sabe que não pode subir o monte Sinai, porque o Senhor nos advertiu, dizendo: Marque limites ao redor do monte e consagre o povo”. ");
INSERT INTO poronbv_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","O Senhor respondeu: “Desça lá e diga aos sacerdotes e ao povo para não ultrapassarem os limites e subam ao Senhor, senão serão mortos. Depois, suba aqui de novo e traga Arão com você”. ");
INSERT INTO poronbv_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Então Moisés foi e disse tudo isso ao povo. ");
INSERT INTO poronbv_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Deus disse tudo o que segue: ");
INSERT INTO poronbv_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Eu sou o Senhor, seu Deus. Eu tirei você do Egito, onde você foi um povo escravo. ");
INSERT INTO poronbv_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Não creia nem adore outros deuses, além de mim. ");
INSERT INTO poronbv_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Não faça ídolos. Não ofereça cultos a imagens de qualquer coisa em cima no céu, na terra ou nas águas debaixo da terra. ");
INSERT INTO poronbv_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Não adore nem se prostre diante de nenhuma imagem, pois eu sou o Senhor, seu Deus. Sou Deus zeloso e castigo filhos pelos pecados dos pais até a terceira e quarta geração daqueles que me odeiam, ");
INSERT INTO poronbv_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","mas mostro bondade até mil gerações àqueles que me amam e guardam os meus mandamentos. ");
INSERT INTO poronbv_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Não use em vão o nome do Senhor, seu Deus, pois não deixarei de punir qualquer abuso nesse sentido. ");
INSERT INTO poronbv_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Guarde o sétimo dia como um dia santo. ");
INSERT INTO poronbv_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Trabalhe nos outros seis dias, ");
INSERT INTO poronbv_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","mas o sétimo dia é o dia de descanso do Senhor, seu Deus. Nenhum trabalho será feito nesse dia, nem por você, nem pelo seu filho, nem pela sua filha, nem pelo seu servo, nem pela sua serva, nem pelos seus animais, nem mesmo pelos estrangeiros que estiverem morando com você. Todos devem descansar nesse dia. ");
INSERT INTO poronbv_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Porque em seis dias o Senhor fez o céu, a terra, o mar e tudo o que neles há, mas no sétimo dia descansou. Por isso, o Senhor abençoou o sétimo dia e o santificou. ");
INSERT INTO poronbv_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Honre seu pai e sua mãe, para que tenha vida longa na terra que o Senhor dá a você. ");
INSERT INTO poronbv_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Não mate. ");
INSERT INTO poronbv_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Não pratique adultério. ");
INSERT INTO poronbv_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Não roube. ");
INSERT INTO poronbv_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Não dê falso testemunho contra o seu próximo. ");
INSERT INTO poronbv_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Não cobice a casa do seu próximo. Não cobice a mulher do seu próximo, nem seus servos ou servas, nem seu boi ou seu jumento, nem qualquer outra coisa que ele possua”. ");
INSERT INTO poronbv_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","O povo viu os trovões e relâmpagos, o som da trombeta e o monte lançando fumaça. O povo ficou de longe observando e tremendo. ");
INSERT INTO poronbv_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Os israelitas disseram a Moisés: “É melhor você falar conosco. Nós o ouviremos. É melhor que Deus não fale diretamente conosco para que não morramos!” ");
INSERT INTO poronbv_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moisés disse a todos: “Não tenham medo! O Senhor veio provar vocês, para que tenham sempre temor por ele e não pequem”. ");
INSERT INTO poronbv_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Mas o povo ficou em pé, longe do monte, ao passo que Moisés aproximou-se da nuvem escura em que Deus estava. ");
INSERT INTO poronbv_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Então o Senhor mandou Moisés dizer aos israelitas: “Todos viram que do céu falei com vocês. ");
INSERT INTO poronbv_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Não façam ídolos de prata ou de ouro para me representarem. ");
INSERT INTO poronbv_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“Façam um altar de terra ou de pedra e nele ofereçam as suas ofertas queimadas e ofertas de paz, sacrifícios de ovelhas e de bois. Seja onde for que eu mandar celebrar o meu nome, eu estarei presente e os abençoarei. ");
INSERT INTO poronbv_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Agora, notem bem: Se o altar for de pedras, usem pedras brutas, porque o uso de ferramentas o profanaria. ");
INSERT INTO poronbv_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Não subam degraus para o meu altar, para que a sua nudez não seja ali exposta”. ");
INSERT INTO poronbv_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“São estas as minhas leis que você apresentará ao povo: ");
INSERT INTO poronbv_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Se você comprar um escravo hebreu, ele trabalhará para você por seis anos. No sétimo ano será liberto de graça. ");
INSERT INTO poronbv_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Se o escravo era solteiro quando foi comprado, receberá a liberdade como solteiro; mas se chegou casado, a mulher irá com ele. ");
INSERT INTO poronbv_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Se o senhor der uma mulher a ele, e tiverem filhos ou filhas, ele sairá livre sozinho. A mulher e os filhos pertencerão ao mesmo senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Pode ser que o escravo diga: ‘Eu amo o meu senhor. Além disso, amo a minha mulher e os meus filhos, e não quero sair livre’. ");
INSERT INTO poronbv_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Neste caso, o senhor levará o escravo ao tribunal para legalizar a declaração dele. O seu senhor o levará à porta ou à lateral da porta da casa e furará a orelha do escravo com um furador. Assim, o homem será escravo dele para sempre. ");
INSERT INTO poronbv_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Se alguém vender a filha como escrava, ela não sairá livre como os escravos homens. ");
INSERT INTO poronbv_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Se ela foi comprada para casar com o dono, e ele achar que ela não serve para ser sua esposa, então ele deverá permitir que ela seja resgatada, isto é, terá de permitir que paguem pela libertação dela. Mas não poderá vender a escrava a estrangeiros, pois ele estaria sendo desleal com ela. ");
INSERT INTO poronbv_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Se o seu senhor a escolher para a dar em casamento ao seu filho, ela terá de ser tratada como se fosse sua filha. ");
INSERT INTO poronbv_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Caso o senhor tomar uma segunda mulher para o seu filho, a primeira continuará com os mesmos direitos que tinha antes, ou seja, não poderá privá-la do mesmo sustento, das mesmas roupas e dos mesmos direitos conjugais. ");
INSERT INTO poronbv_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Se essas três condições não forem atendidas, ela poderá sair livre sem devolver nem pagar nada. ");
INSERT INTO poronbv_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Quem ferir mortalmente um homem, precisará morrer também. ");
INSERT INTO poronbv_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Mas, se não o fez intencionalmente, e Deus permitiu que o outro caísse nas mãos dele e morresse, vai ser determinado um lugar para onde ele possa fugir. ");
INSERT INTO poronbv_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Agora, se alguém tiver planejado matar alguém deliberadamente, deverá ser morto, mesmo que tenha procurado refúgio no meu altar. ");
INSERT INTO poronbv_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Quem agredir seu pai ou sua mãe, será morto. ");
INSERT INTO poronbv_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Aquele que sequestrar alguém e o vender, ou se for achado em poder dele, será morto. ");
INSERT INTO poronbv_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Quem amaldiçoar seu pai ou sua mãe, será morto. ");
INSERT INTO poronbv_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Se dois homens brigarem e um deles ferir o outro com uma pedra ou com o punho e este ficar de cama e não morrer, ");
INSERT INTO poronbv_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","aquele que o feriu será absolvido se o ferido mais tarde puder levantar-se e andar apoiado em uma bengala; mas precisará pagar pelo tempo que este perdeu e ajudá-lo na sua completa recuperação. ");
INSERT INTO poronbv_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Se alguém surrar com vara seu escravo ou escrava, e como resultado o escravo morrer, será castigado; ");
INSERT INTO poronbv_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","mas se o escravo ou escrava sobreviver um ou dois dias, o senhor não será condenado, visto que o escravo é propriedade do seu senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Se dois ou mais homens brigarem e ferirem uma mulher grávida, e ela der à luz prematuramente, não havendo dano sério, o culpado precisará pagar a indenização que o marido daquela mulher exigir. A forma de pagamento será determinada pelos juízes. ");
INSERT INTO poronbv_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mas, se houver danos graves, então o castigo será vida por vida, ");
INSERT INTO poronbv_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","olho por olho, dente por dente, mão por mão, pé por pé, ");
INSERT INTO poronbv_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","queimadura por queimadura, ferimento por ferimento, golpe por golpe. ");
INSERT INTO poronbv_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Se alguém machucar e inutilizar o olho do seu escravo ou escrava, precisará dar liberdade ao escravo como compensação pelo olho. ");
INSERT INTO poronbv_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","A mesma coisa ocorrerá se com violência quebrar o dente de um escravo ou escrava. Pagará com a libertação do escravo como compensação pelo dente. ");
INSERT INTO poronbv_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Se um boi matar a chifradas um homem ou mulher, o boi precisará ser morto a pedradas, e não poderão comer a sua carne. Mas o dono do boi não receberá nenhuma condenação. ");
INSERT INTO poronbv_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Agora, se o boi tinha o costume de chifrar e o dono sabia disso, mas não o manteve preso, a situação é diferente. Nesse caso, se o boi matar um homem ou uma mulher, o boi será apedrejado e o dono dele também será morto. ");
INSERT INTO poronbv_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Se o acusador preferir receber resgate, o culpado pagará tudo que for pedido, para salvar a própria vida. ");
INSERT INTO poronbv_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Esse julgamento será aplicado quando a pessoa morta pelo boi for um menino ou uma menina. ");
INSERT INTO poronbv_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Se a pessoa morta pelo boi for escravo ou escrava, o preço do resgate será de 30 moedas de prata pago ao dono do escravo. Além disso, o boi será apedrejado. ");
INSERT INTO poronbv_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Se alguém deixar uma cova aberta, ou se fizer uma cova e não tampá-la, e cair nela um boi ou jumento e morrer, a regra é clara. ");
INSERT INTO poronbv_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","O responsável pela cova pagará o preço do animal ao dono, mas ficará com o animal morto. ");
INSERT INTO poronbv_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“No caso de um boi matar outro, o boi vivo será vendido. O dinheiro da venda será repartido em partes iguais, tanto o valor do boi vivo quanto o do boi morto. ");
INSERT INTO poronbv_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Porém, se o boi costumava chifrar, e o dono não o manteve preso, o caso é diferente. Este dará um boi vivo e ficará com o boi morto. ");
INSERT INTO poronbv_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Se alguém roubar um boi ou uma ovelha e abatê-lo ou vendê-lo, para cada boi pagará cinco bois e para cada ovelha pagará quatro ovelhas. ");
INSERT INTO poronbv_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Quem matar um ladrão enquanto ele estava roubando a casa, não será condenado por homicídio, ");
INSERT INTO poronbv_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","mas se isso acontecer durante o dia, será culpado de homicídio. “Quanto ao roubo, o ladrão precisará restituir o que roubou. Se não puder devolver ou pagar o que roubou, ele mesmo será vendido como escravo. O dinheiro da venda servirá para pagar o roubo. ");
INSERT INTO poronbv_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Se o ladrão for apanhado no ato de roubar um animal vivo, seja boi, jumento ou ovelha, precisará pagar o dobro. ");
INSERT INTO poronbv_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Se alguém soltar seu animal e este entrar na vinha ou no pasto de outro homem, pagará o prejuízo com o melhor que tiver do seu próprio campo ou da sua vinha. ");
INSERT INTO poronbv_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Quem acender fogo, e o fogo destruir as colheitas já feitas ou por fazer, ou as pastagens de outra pessoa, restituirá totalmente o prejuízo. ");
INSERT INTO poronbv_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Se alguém pede a outra pessoa para guardar prata ou objetos de valor, e um ladrão rouba aquilo que foi guardado, se o ladrão for achado, pagará em dobro o que roubou. ");
INSERT INTO poronbv_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Mas se não acharem o ladrão, o dono da casa será levado perante um tribunal para que se determine se ele roubou ou não os bens do outro. ");
INSERT INTO poronbv_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Sempre que alguém se apossar de bois, jumentos, ovelhas, roupa ou qualquer coisa perdida, e alguém disser: ‘Isto é meu’, as duas partes envolvidas apresentarão o caso diante de um tribunal. Aquele que for condenado pelo tribunal, pagará o dobro do prejuízo que causou ao seu próximo. ");
INSERT INTO poronbv_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Se alguém pede ao próximo para guardar o seu jumento, boi, ovelha, ou outro animal, e o animal morrer, ficar ferido, ou for afugentado, sem que alguém saiba para onde, ");
INSERT INTO poronbv_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","a pessoa deve então fazer um juramento solene diante do Senhor de que não roubou o animal. O dono aceitará a palavra, e não será exigida uma restituição da pessoa. ");
INSERT INTO poronbv_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Mas, se a pessoa roubou aquilo que estava guardando, ela precisará restituir o que roubou ao legítimo dono. ");
INSERT INTO poronbv_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Se foi despedaçado por um animal selvagem, apresentará o animal despedaçado ao dono, como prova. Nesse caso não precisará fazer restituição. ");
INSERT INTO poronbv_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Se alguém pedir emprestado um animal, e este animal ficar aleijado ou morrer enquanto o dono esteve ausente, ele fará a restituição do valor do animal. ");
INSERT INTO poronbv_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Mas, se o dono estiver presente quando isso aconteceu, o que tomou emprestado não precisará pagar o prejuízo. Se o animal era alugado, basta pagar o preço do aluguel. ");
INSERT INTO poronbv_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Se um homem seduzir uma moça virgem não comprometida e tiver relações com ela, pagará o preço do seu dote, e ela será sua mulher; ");
INSERT INTO poronbv_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","mas se o pai da moça proibir o casamento, o sedutor pagará a ele o equivalente ao dote das moças virgens. ");
INSERT INTO poronbv_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Não deixem as feiticeiras viver. ");
INSERT INTO poronbv_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Quem tiver relação sexual com um animal deve ser morto. ");
INSERT INTO poronbv_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Quem oferecer sacrifícios a deuses falsos, e não unicamente ao Senhor, será destruído. ");
INSERT INTO poronbv_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Não maltrate nem explore os estrangeiros. Não esqueça que você foi estrangeiro no Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Não maltrate nenhuma viúva, nem os órfãos. ");
INSERT INTO poronbv_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Se você os maltratar, e eles clamarem a mim, atenderei ao seu clamor. ");
INSERT INTO poronbv_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ficarei muito irado e matarei você e todos os que fizerem isso. Então as suas mulheres ficarão viúvas e os seus filhos ficarão órfãos. ");
INSERT INTO poronbv_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Se você emprestar dinheiro a alguém do meu povo, a algum necessitado que esteja com você, não cobre juros dele! ");
INSERT INTO poronbv_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Se tomar como garantia a capa de alguém, não abuse! Devolva a capa a ele antes do pôr do sol, ");
INSERT INTO poronbv_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","porque a capa é o seu cobertor. É a veste do seu corpo. Se você ficar com ela, em que vai se deitar? Quando ele clamar a mim, eu atenderei, porque sou misericordioso. ");
INSERT INTO poronbv_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Não blasfeme contra Deus, nem amaldiçoe uma autoridade do seu povo. ");
INSERT INTO poronbv_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Traga sem demora as ofertas dos melhores produtos das suas colheitas do trigo, das plantações de uvas e do azeite. “Consagre a mim o primeiro filho. ");
INSERT INTO poronbv_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Faça o mesmo com a primeira cria da vaca e da ovelha. A primeira cria ficará sete dias com a mãe. Depois, no oitavo dia, entreguem-na para mim. ");
INSERT INTO poronbv_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Vocês serão homens consagrados. Por isso, não comam carne de animal despedaçado no campo. Deem essa carne aos cães. ");
INSERT INTO poronbv_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Não espalhe notícias falsas. Não concorde com a pessoa má dando testemunho falso. ");
INSERT INTO poronbv_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Não acompanhe a multidão na prática do mal. Ao prestar um depoimento num processo judicial, não dê testemunho para favorecer a maioria. ");
INSERT INTO poronbv_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Não seja parcial, nem para favorecer o pobre. ");
INSERT INTO poronbv_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Se você encontrar o boi ou o jumento que pertence ao seu inimigo, leve de volta o animal extraviado. ");
INSERT INTO poronbv_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Se você vir o jumento de alguém que o odeia, caído sob o peso da sua carga, não o deixe ali! Vá ajudar o homem a erguer o animal. ");
INSERT INTO poronbv_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Não falsifique o julgamento para prejudicar a causa do pobre. ");
INSERT INTO poronbv_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Afaste-se da acusação falsa. Não condene à morte o inocente, nem o homem justo. Saiba que eu não absolverei o que vive para o mal. ");
INSERT INTO poronbv_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Não aceite suborno, porque o suborno cega os que têm entendimento e corrompe as palavras dos honestos. ");
INSERT INTO poronbv_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Não explore o estrangeiro. Vocês, israelitas, bem sabem como se sente um estrangeiro, pois foram estrangeiros no Egito! ");
INSERT INTO poronbv_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Por seis anos plante em suas terras e colha o que elas produzirem. ");
INSERT INTO poronbv_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Mas, de sete em sete anos, deixe a terra descansar um ano. O sétimo ano é de descanso para a terra. Nesse ano ela não deverá ser cultivada, para que os pobres de Israel achem o que comer, e os animais comerão o que sobrar do campo. Essa lei também vale para as vinhas e olivais. ");
INSERT INTO poronbv_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Faça tudo o que tiver de fazer nos seis primeiros dias, mas descanse no sétimo para que o seu boi e o seu jumento também descansem, e para que o seu escravo e o estrangeiro renovem suas forças. ");
INSERT INTO poronbv_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Israelitas, tenham cuidado em fazer tudo o que eu disse. E prestem atenção: Não se lembrem, nem falem o nome de outros deuses! ");
INSERT INTO poronbv_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Celebrem uma festa em memória de mim, três vezes por ano. ");
INSERT INTO poronbv_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Primeiro, a festa dos pães sem fermento. Durante sete dias, comam pães sem fermento, como já lhes ordenei. Essa festa deverá ocorrer no primeiro mês do ano, o mês de abibe, porque foi nesse mês que vocês saíram do Egito. “Ninguém deverá aparecer diante de mim de mãos vazias. ");
INSERT INTO poronbv_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“A segunda festa é a festa da colheita dos primeiros frutos. Depois do plantio, assim que forem colher os primeiros frutos, celebrem essa festa. “A terceira festa é a festa da colheita geral, no final do ano, quando armazenarem do campo o fruto do seu trabalho. ");
INSERT INTO poronbv_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Três vezes por ano, todo homem deverá se apresentar diante do Senhor Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Ninguém deve oferecer o sangue do sacrifício junto com pão fermentado. “Não deverá ficar gordura da minha festa durante a noite, até a manhã seguinte. ");
INSERT INTO poronbv_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Tragam à casa do Senhor, o seu Deus, os primeiros frutos das suas terras. “Não cozinhem o cabrito no leite da própria mãe dele. ");
INSERT INTO poronbv_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Vou enviar um anjo à frente do meu povo para guardá-lo pelo caminho e levá-lo ao lugar que preparei para ele. ");
INSERT INTO poronbv_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Prestem atenção diante dele! Escutem o que ele disser! Não se rebelem contra ele, pois não perdoará os pecados que cometerem contra ele, porque nele está o meu nome. ");
INSERT INTO poronbv_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Mas se tiverem cuidado de obedecer ao que ele disser e de fazer o que ele mandar, então serei inimigo dos seus inimigos e adversário dos seus adversários. ");
INSERT INTO poronbv_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","O meu anjo irá à frente de vocês. Ele os vai levar aos amorreus, aos heteus, aos ferezeus, aos cananeus, aos heveus e aos jebuseus. E eu vou destruir todos esses povos! ");
INSERT INTO poronbv_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Não adorem os seus deuses, nem ofereçam culto a eles. Não façam o que eles fazem. Ao contrário! Destruam totalmente e despedacem suas colunas sagradas. ");
INSERT INTO poronbv_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Sirvam ao Senhor, o Deus de vocês. Então o Senhor abençoará o seu pão e a sua água. Tirará do meio de vocês as doenças. ");
INSERT INTO poronbv_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Na sua terra não haverá mulher grávida que perderá seu filho, nem haverá mulher incapaz de conceber ou de dar à luz. Eu darei vida longa e completa a vocês. ");
INSERT INTO poronbv_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Mandarei adiante de vocês o meu medo, que colocará em confusão todas as nações onde vocês entrarem. Farei com que todos os seus inimigos voltem as costas para vocês e fujam. ");
INSERT INTO poronbv_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mandarei vespas na frente de vocês. Elas expulsarão de diante de vocês os heveus, os cananeus e os heteus. ");
INSERT INTO poronbv_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Não expulsarei esses povos todos em um só ano. Se fizer isso, a terra se transformará num deserto e os animais selvagens se multiplicarão contra vocês. ");
INSERT INTO poronbv_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Eu expulsarei aqueles povos aos poucos, até que vocês se tornem numerosos o suficiente para tomar posse efetiva da terra que já dei a vocês por herança. ");
INSERT INTO poronbv_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Eu mesmo vou traçar os limites do seu país. Os limites serão estes: desde o mar Vermelho até o mar dos Filisteus, e do deserto até o rio Eufrates. Vou entregar em suas mãos os moradores daquelas terras, os quais vocês expulsarão de diante de vocês. ");
INSERT INTO poronbv_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Não façam nenhuma aliança com esses povos, nem com os falsos deuses deles! ");
INSERT INTO poronbv_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Não deixem que esses povos morem na terra de vocês, para que não levem vocês a pecar contra mim. Se oferecerem culto aos seus deuses, isso será uma armadilha para vocês”. ");
INSERT INTO poronbv_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Deus continuou falando com Moisés, dizendo: “Subam o monte para apresentar-se ao Senhor, você e Arão, Nadabe e Abiú e mais setenta líderes de Israel. Mas adorem à distância. ");
INSERT INTO poronbv_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Só Moisés se aproximará do Senhor. Os outros ficarão de longe, e o povo não deve subir com ele”. ");
INSERT INTO poronbv_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moisés desceu e transmitiu ao povo todas as palavras e leis do Senhor. Então todo o povo respondeu a uma só voz e disse: “Faremos tudo o que o Senhor falou”. ");
INSERT INTO poronbv_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moisés escreveu todas as palavras do Senhor, e na manhã seguinte se levantou bem cedo e fez um altar ao pé do monte. Construiu ali 12 pilares, um para cada tribo de Israel. ");
INSERT INTO poronbv_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Depois enviou alguns moços israelitas para oferecerem ofertas queimadas e ofertas de paz ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moisés despejou a metade do sangue em bacias e a outra metade do sangue derramou sobre o altar. ");
INSERT INTO poronbv_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Em seguida, Moisés leu o Livro da Aliança de Deus para o povo, e eles disseram: “Seremos obedientes e faremos tudo o que o Senhor falou”. ");
INSERT INTO poronbv_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Então Moisés pegou as bacias e derramou o sangue sobre o povo, dizendo: “Este é o sangue da minha aliança que o Senhor fez com vocês, de acordo com os termos que acabei de ler”. ");
INSERT INTO poronbv_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Então, Moisés, Arão, Nadabe, Abiú e os setenta oficiais de Israel subiram o monte ");
INSERT INTO poronbv_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","e viram o Deus de Israel, cujos pés estavam pisando num pavimento de pedras de safira. Parecia o céu num dia claro! ");
INSERT INTO poronbv_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Deus não estendeu a mão para ferir os escolhidos de Israel; porém eles viram a Deus! E ali comeram e beberam. ");
INSERT INTO poronbv_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","O Senhor disse a Moisés: “Suba até o topo do monte, venha até mim e fique aqui. Darei a você duas tábuas de pedra com a lei e os mandamentos que eu mesmo escrevi para ensinar o povo”. ");
INSERT INTO poronbv_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moisés partiu com seu ajudante Josué e, ao subir o monte de Deus, ");
INSERT INTO poronbv_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","disse aos líderes: “Esperem aqui até voltarmos. Arão e Hur ficarão com vocês. Quem tiver alguma questão para resolver, fale com eles”. ");
INSERT INTO poronbv_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Assim que Moisés subiu, uma nuvem cobriu o monte. ");
INSERT INTO poronbv_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","A glória do Senhor permaneceu sobre o monte Sinai. A nuvem cobriu o monte por seis dias. No sétimo dia o Senhor chamou Moisés do interior da nuvem. ");
INSERT INTO poronbv_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Para o povo de Israel, que olhava de longe, a aparência da glória do Senhor era tremenda. Era como um fogo consumidor, no alto do monte! ");
INSERT INTO poronbv_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moisés entrou na nuvem e subiu o monte; e lá permaneceu quarenta dias e quarenta noites! ");
INSERT INTO poronbv_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","O Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Diga aos israelitas que me tragam uma oferta. Receba a oferta de todo aquele que quiser ofertar de coração. ");
INSERT INTO poronbv_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Quero receber deles o seguinte como oferta: ouro, prata e bronze, ");
INSERT INTO poronbv_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","fios de tecido azul, vermelho-púrpura e vermelho-carmesim, linho fino e pelos de cabra, ");
INSERT INTO poronbv_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","peles de carneiro tingidas de vermelho, couro e madeira de acácia, ");
INSERT INTO poronbv_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","azeite para iluminação, especiarias para o óleo da unção e para o incenso aromático; ");
INSERT INTO poronbv_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","pedras de ônix e pedras próprias para serem fixadas na faixa sacerdotal e na peça que vai no peito do sacerdote. ");
INSERT INTO poronbv_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“E deverão construir um santuário para mim, para que eu possa morar no meio deles. ");
INSERT INTO poronbv_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Darei o modelo do Tabernáculo e de cada utensílio. Façam tudo exatamente como eu lhe mostrar. ");
INSERT INTO poronbv_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Faça também uma arca de madeira de acácia. A arca medirá um metro e dez centímetros de comprimento, setenta e cinco centímetros de largura e setenta e cinco centímetros de altura. ");
INSERT INTO poronbv_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ela precisará ser revestida de ouro puro, por dentro e por fora. Além disso, será feita uma moldura de ouro em volta dela. ");
INSERT INTO poronbv_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Faça quatro argolas de ouro, para os quatro cantos da arca, duas para cada lado. ");
INSERT INTO poronbv_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Faça também varas de madeira de acácia, revestidas de ouro. ");
INSERT INTO poronbv_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","As varas serão introduzidas nas argolas laterais da arca, para que possa ser carregada. ");
INSERT INTO poronbv_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","As varas terão de ficar o tempo todo nas argolas. Ninguém poderá tirá-las. ");
INSERT INTO poronbv_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Dentro da arca você colocará as duas tábuas da aliança — a prova da minha presença e de que dei a Israel a minha Lei. ");
INSERT INTO poronbv_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Faça uma tampa de ouro puro. Deverá medir um metro e dez centímetros de comprimento por setenta centímetros de largura. ");
INSERT INTO poronbv_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Depois faça dois querubins de ouro batido, um em cada extremidade da tampa. ");
INSERT INTO poronbv_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Isso deve ser feito de tal modo que a tampa e os querubins formem uma só peça. ");
INSERT INTO poronbv_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Os querubins estenderão as suas asas para cima, cobrindo com elas a tampa. Ficarão de frente um para o outro, olhando para a tampa. ");
INSERT INTO poronbv_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Coloque a tampa sobre a arca. Dentro da arca, coloque as tábuas da aliança que darei a você. ");
INSERT INTO poronbv_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ali sobre a tampa, no meio dos querubins que estão sobre a arca da aliança, me apresentarei a você. Na arca estarão as leis que dão testemunho da minha aliança. Ali darei a vocês os meus mandamentos aos israelitas. ");
INSERT INTO poronbv_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Faça também uma mesa de madeira de acácia, com noventa centímetros de comprimento, quarenta e cinco centímetros de largura e setenta centímetros de altura. ");
INSERT INTO poronbv_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Revista-a de ouro puro e faça uma moldura de ouro ao seu redor. ");
INSERT INTO poronbv_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Faça também um friso ao seu redor com quatro dedos de largura e uma moldura de ouro para esse friso. ");
INSERT INTO poronbv_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Faça quatro argolas de ouro para a mesa, uma para cada canto da mesa. ");
INSERT INTO poronbv_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","As argolas devem estar próximas ao friso para que sustentem as varas, usadas para transportar a mesa. ");
INSERT INTO poronbv_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Faça então as varas para carregar a mesa. Elas devem ser feitas de madeira de acácia, revestidas de ouro. ");
INSERT INTO poronbv_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Faça de ouro puro os pratos, os talheres, as vasilhas para o incenso e as jarras para as bebidas sacrificiais. ");
INSERT INTO poronbv_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","E deixe sempre em cima da mesa, diante de mim, os pães da Presença. ");
INSERT INTO poronbv_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Faça também um candelabro de ouro puro. O pedestal, a haste, as taças, as flores e os botões formarão uma só peça. ");
INSERT INTO poronbv_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Seis braços sairão dos seus lados: três de cada lado da haste central. ");
INSERT INTO poronbv_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Cada braço terá três taças em forma de flor de amêndoa, e será enfeitado com três botões e três flores. Assim serão os seis braços que saem do candelabro. ");
INSERT INTO poronbv_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Mas a haste central do candelabro terá quatro taças com formato de flor de amêndoa, cada uma com seu botão e sua flor. ");
INSERT INTO poronbv_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Entre cada par de braços haverá um botão e uma flor, além dos que vão por cima e dos que vão por baixo do conjunto de braços. ");
INSERT INTO poronbv_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Os braços com seus botões formarão uma só peça com o candelabro de ouro puro batido. ");
INSERT INTO poronbv_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Depois faça sete lâmpadas. Coloque as lâmpadas de modo que iluminem a frente do candelabro. ");
INSERT INTO poronbv_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Os cortadores de pavios e os apagadores serão de ouro puro. ");
INSERT INTO poronbv_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Você precisará de cerca de trinta e cinco quilos de ouro puro para fazer o candelabro com todas as peças que o acompanham. ");
INSERT INTO poronbv_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Tenha cuidado para fazer tudo de acordo com o modelo que lhe foi mostrado neste monte. ");
INSERT INTO poronbv_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Faça o Tabernáculo com dez cortinas. O tecido deverá ser de linho fino trançado, com fios de tecido azul, vermelho-púrpura e vermelho-carmesim, e mande artistas gravarem nelas desenhos de querubins. ");
INSERT INTO poronbv_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Cada cortina deverá medir doze metros e sessenta centímetros de comprimento e um metro e oitenta centímetros de largura. ");
INSERT INTO poronbv_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Cada um dos lados do Tabernáculo será formado por cinco cortinas ligadas umas às outras. ");
INSERT INTO poronbv_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Faça laços de tecido azul ao longo da borda da cortina externa do primeiro conjunto. Você fará o mesmo com a borda da cortina externa do segundo conjunto. ");
INSERT INTO poronbv_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Faça cinquenta laços numa cortina e cinquenta laços na cortina que está na extremidade do outro conjunto, de modo que os laços estejam contrapostos uns aos outros. ");
INSERT INTO poronbv_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Depois faça cinquenta prendedores de ouro, e com eles junte os dois conjuntos de cortinas. Assim, o Tabernáculo — o lugar da morada de Deus — se tornará um conjunto único. ");
INSERT INTO poronbv_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“A cobertura do Tabernáculo será feita com onze cortinas de pelos de cabra. ");
INSERT INTO poronbv_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Cada cortina deverá ter o mesmo tamanho, medindo treze metros e meio de comprimento e um metro e oitenta centímetros de largura. ");
INSERT INTO poronbv_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Prenda de um lado cinco cortinas umas nas outras, formando um conjunto, e as outras seis, formando outro conjunto, ficando a sexta cortina dobrada na frente da tenda. ");
INSERT INTO poronbv_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Faça cinquenta laços ao longo da borda do primeiro conjunto de cortinas e mais cinquenta laços ao longo da borda do outro conjunto de cortinas. ");
INSERT INTO poronbv_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Em seguida, faça cinquenta prendedores de bronze e coloque-os nos laços, unindo assim os dois conjuntos, e a cobertura do Tabernáculo se tornará um todo. ");
INSERT INTO poronbv_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","A sobra no comprimento das cortinas internas ficará pendurada na parte de trás do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","As dez cortinas internas serão quarenta e cinco centímetros mais compridas de cada lado; estas sobras deverão ser penduradas nos dois lados, e assim o Tabernáculo ficará coberto. ");
INSERT INTO poronbv_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Faça mais uma cobertura de peles de carneiro, tingidas de vermelho, e outra cobertura em cima desta, feita de peles finas. ");
INSERT INTO poronbv_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“As armações verticais do Tabernáculo deverão ser de madeira de acácia. ");
INSERT INTO poronbv_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Cada armação deverá medir quatro metros e meio de comprimento por setenta centímetros de altura. ");
INSERT INTO poronbv_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Cada armação terá dois encaixes paralelos para juntar uma à outra. ");
INSERT INTO poronbv_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Vinte dessas armações formarão o lado sul do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Para cada armação haverá duas bases de prata, uma debaixo de cada encaixe. ");
INSERT INTO poronbv_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Faça a mesma coisa para o lado norte do Tabernáculo. Faça vinte armações ");
INSERT INTO poronbv_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","e quarenta bases de prata, duas debaixo de cada armação. ");
INSERT INTO poronbv_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Nos fundos do Tabernáculo, o lado oeste, você fará seis armações ");
INSERT INTO poronbv_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","e mais duas armações para os cantos da parte de trás do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","As armações dos cantos serão duplas. Em cada canto, as armações duplas ficarão ligadas em cima, pela primeira argola. ");
INSERT INTO poronbv_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Portanto, haverá oito armações e dezesseis bases de prata na parte de trás do Tabernáculo, duas bases debaixo de cada armação. ");
INSERT INTO poronbv_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Faça também travessões de madeira de acácia: cinco para as armações de um lado do Tabernáculo, ");
INSERT INTO poronbv_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","cinco para as armações do outro lado e cinco para o lado oeste, na parte de trás do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","O travessão central se estenderá a meia altura, ligando todas as armações de uma extremidade à outra. ");
INSERT INTO poronbv_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","As armações devem ser revestidas de ouro. As argolas por onde vão passar as travessas serão de ouro, e as próprias travessas serão revestidas de ouro. ");
INSERT INTO poronbv_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Arme o Tabernáculo de acordo com o modelo que mostrei a você neste monte. ");
INSERT INTO poronbv_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Faça também um véu de linho fino trançado, de fios de lã azul, vermelho-púrpura e vermelho-carmesim, e mande artistas bordarem nele desenhos de querubins. ");
INSERT INTO poronbv_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Pendure o véu em quatro colunas de madeira de acácia revestidas de ouro, que terão prendedores de ouro e serão fixadas em quatro bases de prata. ");
INSERT INTO poronbv_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Pendure o véu nos prendedores. Atrás do véu, coloque a arca da aliança. O véu servirá para separar o Lugar Santo do Lugar Santíssimo. ");
INSERT INTO poronbv_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Coloque a tampa sobre a arca da aliança no Lugar Santíssimo. ");
INSERT INTO poronbv_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Coloque a mesa do lado de fora do véu, no lado norte do Tabernáculo, e o candelabro em frente à mesa, no lado sul. ");
INSERT INTO poronbv_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Para a entrada do Tabernáculo, faça uma cortina de linho fino trançado e de fios de lã azul, vermelho-púrpura e vermelho-carmesim, e confie o trabalho a um bordador. ");
INSERT INTO poronbv_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Para sustentar essa cortina, faça colunas de madeira de acácia revestida de ouro, com prendedores de ouro. As cinco bases — uma para cada poste — devem ser de bronze. ");
INSERT INTO poronbv_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Faça também o altar de madeira de acácia. Ele será quadrado, medindo dois metros e vinte e cinco centímetros de largura e um metro e trinta e cinco centímetros de altura. ");
INSERT INTO poronbv_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Faça quatro pontas, em forma de chifre, uma em cada canto do altar, que formarão uma só peça. Cubra de bronze o altar. ");
INSERT INTO poronbv_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Depois faça de bronze todos os seus utensílios: vasilhas e pás para recolher a cinza, bacias, garfos e braseiros. ");
INSERT INTO poronbv_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Faça também uma grelha de bronze, em forma de rede, com quatro argolas de bronze — uma em cada canto da grelha. ");
INSERT INTO poronbv_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Coloque a grelha abaixo da beirada do altar, de modo que fique a meia altura do altar. ");
INSERT INTO poronbv_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Faça ainda varas para carregar o altar. Use madeira de acácia. As varas devem ser revestidas de bronze. ");
INSERT INTO poronbv_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Para transportar o altar, as varas serão colocadas nas argolas, dos dois lados do altar. ");
INSERT INTO poronbv_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","O altar deve ser oco, feito de tábuas, conforme o modelo que você viu no monte. ");
INSERT INTO poronbv_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Faça um pátio para o Tabernáculo, cercado de cortinas de linho fino trançado. O lado sul, de quarenta e cinco metros de comprimento, será coberto por cortinas. ");
INSERT INTO poronbv_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Elas estarão presas em vinte colunas de bronze, firmadas em vinte bases de bronze. As varas para estender as cortinas e os ganchos para prendê-las nas colunas serão de prata. ");
INSERT INTO poronbv_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Faça a mesma coisa no lado norte do pátio, com quarenta e cinco metros de comprimento, e cortinas fixas em vinte colunas e bases de bronze, e varas e ganchos de prata. ");
INSERT INTO poronbv_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“O lado oeste do pátio com as cortinas terá vinte e dois metros, com dez colunas e dez bases. ");
INSERT INTO poronbv_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","No lado leste, o pátio também será de vinte e dois metros e meio de comprimento. ");
INSERT INTO poronbv_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Um lado da entrada terá cortinas de seis metros e setenta e cinco centímetros de comprimento, presas em três colunas fixas sobre três bases. ");
INSERT INTO poronbv_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","O outro lado também terá cortinas de seis metros e setenta e cinco centímetros presas em três colunas fixas sobre três bases. ");
INSERT INTO poronbv_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“A entrada do pátio será protegida por uma cortina de oito metros e oitenta centímetros de comprimento. A cortina deve ser de linho fino trançado e de fios de tecido azul, vermelho-púrpura e vermelho-carmesim, obra de bordador. Quatro colunas fixas em quatro bases sustentarão a cortina. ");
INSERT INTO poronbv_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Todas as colunas ao redor do pátio serão ligadas por suportes de prata. Os ganchos serão todos de prata e as bases de bronze. ");
INSERT INTO poronbv_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","O pátio todo terá quarenta e cinco metros de comprimento e vinte e dois metros e meio de largura, com cortinas de linho fino trançado de dois metros e vinte e cinco centímetros de altura. As bases serão de bronze. ");
INSERT INTO poronbv_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Todos os utensílios usados para o serviço do Tabernáculo serão de bronze. As estacas do Tabernáculo e as estacas do pátio serão de bronze. ");
INSERT INTO poronbv_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Diga aos israelitas que tragam azeite puro de oliveira refinado, para o candelabro, para que as lâmpadas fiquem acesas o tempo todo. ");
INSERT INTO poronbv_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Arão e os seus filhos serão responsáveis por manter tudo em ordem e a luz acesa do entardecer até pela manhã, perante o Senhor. Farão isso no Lugar Santo, fora do véu, atrás do qual está a arca da aliança. Este regulamento é permanente, entre os israelitas, de geração em geração. ");
INSERT INTO poronbv_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Chame o seu irmão Arão e consagre-o dentre os israelitas, e também seus filhos Nadabe, Abiú, Eleazar e Itamar. Eles serão os sacerdotes para me servirem. ");
INSERT INTO poronbv_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Faça roupas especiais para Arão, para indicar que ele foi separado para o meu serviço. Devem ser roupas que o dignifiquem e honrem. ");
INSERT INTO poronbv_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Fale a todos os homens artesãos, capazes e habilidosos, para que façam roupas para a consagração de Arão para me servir como sacerdote. ");
INSERT INTO poronbv_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","As roupas que farão são estas: um peitoral, um colete sacerdotal, um manto, uma túnica bordada, um turbante e um cinturão. Essas roupas sacerdotais feitas para Arão e seus filhos serão sagradas, para que me sirvam como sacerdotes. ");
INSERT INTO poronbv_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Esses artesãos deverão usar ouro, linho fino trançado azul, vermelho-púrpura e vermelho-carmesim. ");
INSERT INTO poronbv_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Os artesãos farão o colete sacerdotal de linho fino trançado, de fios de ouro e de fios de tecido azul, vermelho-púrpura e vermelho-carmesim, trabalho feito com capricho. ");
INSERT INTO poronbv_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","O colete terá duas partes — a da frente e a de atrás — e terá duas ombreiras que deverão ser presas nos dois lados do manto. ");
INSERT INTO poronbv_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","O cinturão, feito com arte, passará pela cintura do colete sacerdotal para prendê-lo; será feito do mesmo material, ou seja, linho fino trançado, fios de ouro e fios de tecido azul, vermelho-púrpura e vermelho-carmesim. ");
INSERT INTO poronbv_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Pegue duas pedras de ônix e grave nelas os nomes dos filhos de Israel; ");
INSERT INTO poronbv_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","seis nomes em cada pedra, por ordem de nascimento dos filhos de Israel. ");
INSERT INTO poronbv_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Para gravar os nomes dos filhos de Israel, use a técnica de um lapidador, utilizada para gravar selos. Em seguida encaixe as pedras em bases de ouro. ");
INSERT INTO poronbv_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Fixe as duas pedras nas ombreiras do manto sacerdotal. Elas servirão para manter viva a lembrança do povo de Israel. Assim, Arão levará sempre nos ombros os nomes das tribos, para manter viva a lembrança diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Faça também encaixes de ouro ");
INSERT INTO poronbv_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","e duas correntes de ouro puro trançado. Prenda as correntes nos encaixes. ");
INSERT INTO poronbv_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Depois faça artisticamente o peitoral, que servirá para orientar as decisões da parte de Deus. Faça com o mesmo material usado para fazer o colete sacerdotal: linho fino trançado, fios de ouro, fios de tecido azul, vermelho-púrpura e vermelho-carmesim. ");
INSERT INTO poronbv_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","O peitoral será quadrado e dobrado em dois, formando um bolso, medindo vinte e dois centímetros de comprimento por vinte e dois centímetros de largura. ");
INSERT INTO poronbv_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Em seguida, fixe nele quatro fileiras de pedras preciosas. Na primeira fila fixe as seguintes pedras: sárdio, topázio e carbúnculo. ");
INSERT INTO poronbv_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Na segunda fila, esmeralda, safira e diamante. ");
INSERT INTO poronbv_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Na terceira fila, jacinto, ágata e ametista. ");
INSERT INTO poronbv_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Na quarta fila, berilo, ônix e jaspe. Os encaixes serão modelados em ouro. ");
INSERT INTO poronbv_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Cada pedra representará uma das 12 tribos de Israel. O nome de cada tribo será gravado nela como um selo. ");
INSERT INTO poronbv_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Prenda o peitoral no colete sacerdotal por meio de duas correntes de ouro puro, trançadas com corda. ");
INSERT INTO poronbv_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Faça também duas argolas de ouro e prenda-as às duas pontas do peitoral. ");
INSERT INTO poronbv_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Prenda as duas correntes de ouro às argolas nas pontas do peitoral. ");
INSERT INTO poronbv_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","As outras pontas das duas cordas ficarão presas às partes da frente dos dois encaixes de pedras de ônix, nas ombreiras do colete sacerdotal. ");
INSERT INTO poronbv_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Faça também outras duas argolas de ouro e prenda-as às duas pontas de baixo, por dentro do peitoral, junto ao colete sacerdotal. ");
INSERT INTO poronbv_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Faça mais duas argolas de ouro e prenda-as às duas ombreiras do colete sacerdotal, abaixo, na frente, sobre o cinturão de trabalho esmerado que passa por cima do colete sacerdotal. ");
INSERT INTO poronbv_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Depois ligue o fundo do peitoral às argolas da base do manto sacerdotal. Faça a ligação por meio de uma fita azul, ligando o peitoral ao cinturão. Isto manterá o peitoral sempre unido ao colete sacerdotal. ");
INSERT INTO poronbv_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Desse modo, Arão levará os nomes das tribos de Israel no peitoral, sobre o seu coração, toda vez que entrar no Lugar Santo. Assim o Senhor se lembrará sempre das tribos de Israel. ");
INSERT INTO poronbv_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Coloque no peitoral das decisões o Urim e o Tumim, para serem levados junto ao coração de Arão, quando se apresentar ao Senhor. Assim, Arão levará sempre sobre o coração os meios para saber o que o Senhor quer do povo de Israel. ");
INSERT INTO poronbv_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“O manto, roupa que vai por cima do colete sacerdotal, será tecido inteiramente de fios de lã azul ");
INSERT INTO poronbv_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","e com uma abertura para a cabeça no meio. Essa abertura terá um forro em volta, como uma gola, para não se rasgar. ");
INSERT INTO poronbv_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","O manto será todo enfeitado com desenhos de romã de pano azul, vermelho-púrpura e vermelho-carmesim; em volta da borda do manto, intercalados com sinos de ouro, ou seja, um sino e uma romã, outro sino de ouro e outra romã, e assim por diante. ");
INSERT INTO poronbv_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Os sinos de ouro e as romãs devem se alternar por toda a volta da borda do manto. ");
INSERT INTO poronbv_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Arão terá de usar esse manto sempre que for fazer o serviço sacerdotal. O som dos sinos será ouvido quando ele entrar no Lugar Santo diante do Senhor e quando sair; fará assim para que não morra! ");
INSERT INTO poronbv_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Faça depois uma lâmina de ouro puro e grave nela — como se gravam os selos — a seguinte frase: ‘Consagrado ao Senhor’. ");
INSERT INTO poronbv_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Essa lâmina será presa por um cordão na parte da frente do turbante com uma fita azul. ");
INSERT INTO poronbv_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Estará sobre a testa de Arão, para que ele leve a culpa de qualquer pecado que os israelitas cometerem ao oferecerem e consagrarem suas ofertas ao Senhor. Essa lâmina estará sempre sobre a testa de Arão, para que os israelitas sejam aceitos e perdoados pelo Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Faça também uma túnica bordada para Arão — uma manta de linho xadrez. E faça um turbante de linho fino, e o cinturão, trabalhado artisticamente por um bordador. ");
INSERT INTO poronbv_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Faça para os filhos de Arão os mantos, os cinturões e os turbantes. Essas peças devem conferir-lhes honra e dignidade. ");
INSERT INTO poronbv_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Depois de vestir seu irmão Arão e os seus filhos, consagre esses homens ao Senhor para o ministério sacerdotal. Para isso, deverão ser ungidos com azeite de oliveira — derramado sobre suas cabeças. ");
INSERT INTO poronbv_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Faça roupas de baixo para eles — calções de linho — para cobrirem a pele nua, e que vão da cintura até quase os joelhos. ");
INSERT INTO poronbv_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Sempre que Arão e seus filhos entrarem no Tabernáculo ou forem até o altar que está no Lugar Santo, deverão vestir essas peças. Desse modo eles não terão culpa e não morrerão. “Este estatuto é permanente para Arão e para os seus descendentes. ");
INSERT INTO poronbv_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Consagre Arão e seus filhos para que me sirvam como sacerdotes da seguinte maneira: Pegue um novilho e dois carneiros sem defeito. ");
INSERT INTO poronbv_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Pegue pães e bolos feitos sem fermento e com farinha amassada. Pegue também bolos finos sem fermento untados com azeite. ");
INSERT INTO poronbv_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Coloque-os numa cesta. Depois traga as cestas, o novilho e os dois cordeiros. ");
INSERT INTO poronbv_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Então mande Arão e seus filhos chegarem perto da porta do Santuário e lave-os com água. ");
INSERT INTO poronbv_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Depois vista Arão com as roupas especiais: o manto, a túnica bordada, o colete sacerdotal, o peitoral e o cinturão de trabalho artístico do colete sacerdotal. ");
INSERT INTO poronbv_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ponha-lhe o turbante na cabeça e prenda a lâmina de ouro ao turbante. ");
INSERT INTO poronbv_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Derrame o azeite da unção na cabeça dele. ");
INSERT INTO poronbv_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Depois vista os filhos dele com as roupas sacerdotais. Coloque neles as túnicas bordadas, ");
INSERT INTO poronbv_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","os cinturões, os turbantes na cabeça. Assim você consagrará Arão e os seus filhos. E serão sacerdotes para sempre. ");
INSERT INTO poronbv_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Traga o novilho para a frente do Tabernáculo. Arão e seus filhos colocarão as mãos sobre a cabeça do novilho. ");
INSERT INTO poronbv_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Você deverá sacrificar o novilho na entrada do Tabernáculo, diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Com o dedo ponha o sangue do novilho nos chifres do altar e derrame o resto do sangue sobre a base do altar. ");
INSERT INTO poronbv_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Depois pegue a gordura que cobre as vísceras, incluindo a melhor parte do fígado, os dois rins com a gordura que os envolve, e queime tudo isso no altar. ");
INSERT INTO poronbv_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Mas o restante do corpo, incluindo a carne, o couro e o excremento, queime fora do acampamento; é oferta pelo pecado. ");
INSERT INTO poronbv_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Depois traga um dos carneiros, e Arão e seus filhos colocarão as mãos sobre a cabeça dele. ");
INSERT INTO poronbv_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Sacrifique o carneiro e borrife o sangue dele por todos os lados do altar. ");
INSERT INTO poronbv_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Corte o carneiro em pedaços. Lave as vísceras e as pernas do animal e ponha tudo isso sobre os outros pedaços e a cabeça. ");
INSERT INTO poronbv_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Queime tudo sobre o altar. É oferta queimada de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Depois pegue o outro carneiro. Arão e seus filhos colocarão as mãos sobre a cabeça. ");
INSERT INTO poronbv_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Sacrifique o carneiro. Molhe com o sangue do carneiro a ponta da orelha direita de Arão e dos seus filhos. Molhe também os polegares da mão direita e do pé direito de cada um deles. Borrife todos os lados do altar com o restante do sangue. ");
INSERT INTO poronbv_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Pegue um pouco de sangue do altar e um pouco de óleo da unção e borrife essa mistura em Arão e nas suas roupas, e nos seus filhos e nas roupas deles. Assim, eles e suas roupas estarão santificados ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Depois tire a gordura desse cordeiro, a parte gorda da cauda, a gordura que cobre as vísceras, a melhor parte do fígado, os dois rins e a gordura que os envolve, e a coxa direita, porque este é o carneiro da oferta de ordenação dos sacerdotes. ");
INSERT INTO poronbv_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Pegue também um pão, um bolo assado com azeite e um pão fino da cesta de pães sem fermento, colocada diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ponha todas essas coisas nas mãos de Arão e seus filhos e, movendo-as de um lado para o outro, apresente-as com gestos rituais perante o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Em seguida, pegue tudo de volta das mãos deles e queime essas ofertas no altar. É oferta queimada ao Senhor, é oferta de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Pegue o peito do carneiro para a ordenação de Arão e mova-o de um lado para o outro, apresente-o com gestos rituais perante o Senhor. Essa parte pertencerá a você. ");
INSERT INTO poronbv_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Consagre o peito e a coxa do carneiro da oferta apresentada com gestos rituais, isto é, as partes tiradas do cordeiro da ordenação que pertencem a Arão e seus filhos. ");
INSERT INTO poronbv_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","O povo de Israel sempre terá de dar essas partes dos sacrifícios a Arão e seus filhos. É contribuição obrigatória permanente que farão aos sacerdotes, das suas ofertas de paz ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“As vestes sagradas de Arão passarão aos seus descendentes, para vesti-las quando forem ungidos e ordenados. ");
INSERT INTO poronbv_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","O filho que servir como sacerdote no lugar de Arão e que entrar no santuário para servir no Lugar Santo vestirá essas roupas durante sete dias. ");
INSERT INTO poronbv_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Pegue o carneiro da ordenação e cozinhe a sua carne no Lugar Santo. ");
INSERT INTO poronbv_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Na entrada do santuário eles deverão comer a carne do cordeiro e o pão que está na cesta. ");
INSERT INTO poronbv_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Eles comerão as coisas que foram oferecidas como sacrifício para tirar os pecados para consagrá-los e para santificá-los. Somente os sacerdotes poderão comê-las, pois são sagradas. ");
INSERT INTO poronbv_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Se sobrar na manhã seguinte alguma coisa da carne do cordeiro da ordenação ou do pão, deverá ser queimada. Ninguém deve comê-la, porque é sagrada. ");
INSERT INTO poronbv_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Para a ordenação de Arão e seus filhos, faça tudo o que lhe mandar, durante sete dias. ");
INSERT INTO poronbv_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Cada dia prepare um novilho para ser sacrificado como oferta pelo pecado. É o sacrifício para alcançar o perdão dos pecados de todos. Com o sacrifício para tirar pecados você purificará o altar. Depois você derramará o azeite da unção sobre o altar, para a sua santificação. ");
INSERT INTO poronbv_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Durante sete dias faça o sacrifício pelo altar, para consagrá-lo. Com isso o altar será santíssimo, e tudo o que encostar nele ficará santo. ");
INSERT INTO poronbv_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Agora veja as ofertas que você deve sacrificar regularmente sobre o altar: ofereça todos os dias dois cordeiros de um ano de idade. ");
INSERT INTO poronbv_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ofereça um cordeiro de manhã e o outro ao entardecer. ");
INSERT INTO poronbv_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ofereça com o primeiro cordeiro cerca de três litros da melhor farinha misturada, preparada com um litro de azeite de oliva refinado. Como oferta de bebida ofereça um litro de vinho. ");
INSERT INTO poronbv_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ofereça o outro cordeiro ao entardecer, junto com a oferta de cereais e com a oferta de bebida, como de manhã. Será oferta queimada de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Assim será apresentada constantemente a oferta queimada, de geração em geração, à entrada do Tabernáculo, diante do Senhor. Ali me encontrarei com os israelitas e falarei com você. ");
INSERT INTO poronbv_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ali visitarei os israelitas, e o lugar será consagrado pela minha glória. ");
INSERT INTO poronbv_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Assim consagrarei o Tabernáculo e o altar. Santificarei também Arão e os seus filhos para que me sirvam como sacerdotes. ");
INSERT INTO poronbv_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","E morarei no meio dos israelitas e serei o seu Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Saberão que eu sou o Senhor, o seu Deus, que os tirou da terra do Egito para morar no meio deles. Eu sou o Senhor, o seu Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Faça também um altar de madeira de acácia para queimar incenso. ");
INSERT INTO poronbv_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","O altar deve ser quadrado, com quarenta e cinco centímetros de cada lado, e noventa centímetros de altura. Os chifres, nas pontas e o altar devem formar uma só peça inteiriça. ");
INSERT INTO poronbv_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Revista de ouro a parte de cima, as paredes laterais e os chifres. Além disso, faça uma moldura de ouro. ");
INSERT INTO poronbv_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Faça duas argolas de ouro de cada lado do altar, logo abaixo da moldura. Essas argolas servem para sustentar as varas utilizadas para carregar o altar. ");
INSERT INTO poronbv_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","As varas serão de madeira de acácia, recobertas de ouro. ");
INSERT INTO poronbv_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Coloque o altar em frente ao véu que se encontra diante da arca da aliança, diante da tampa que está sobre ela. Ali me encontrarei com você. ");
INSERT INTO poronbv_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Arão queimará nesse altar o incenso aromático todas as manhãs, quando vier preparar as lâmpadas, ");
INSERT INTO poronbv_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","e também à tarde, quando vier acendê-las. O incenso será queimado continuamente perante o Senhor, de geração em geração. ");
INSERT INTO poronbv_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Não ofereçam o que não seja meu nesse altar, nem ofertas queimadas, nem oferta de cereais. Também não apresente ofertas de bebida sobre ele. ");
INSERT INTO poronbv_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Uma vez por ano, Arão fará uma cerimônia de propiciação sobre os chifres do altar com o sangue do animal sacrificado para tirar os pecados do povo. Isto será feito pelas gerações. Esse altar é santíssimo ao Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","O Senhor disse ainda a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Quando você fizer o recenseamento do povo de Israel, preste atenção! Cada israelita terá de pagar o seu próprio resgate ao Senhor quando for contado. Dessa maneira, nenhuma praga virá sobre eles quando a contagem estiver sendo feita. ");
INSERT INTO poronbv_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Todo aquele que passar pelo recenseamento contribuirá com seis gramas de prata, com base no peso padrão do santuário, que é de doze gramas de prata. Os seis gramas serão uma oferta ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Todo aquele que tiver mais de vinte anos de idade e for registrado no recenseamento, dará essa oferta ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","O rico não dará mais de seis gramas, nem o pobre menos que seis gramas, quando apresentarem a oferta ao Senhor quando pagarem pelos pecados da sua vida. ");
INSERT INTO poronbv_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Receba dos israelitas o dinheiro dessas ofertas pelo perdão dos pecados e use-o no serviço do Tabernáculo. Assim, as ofertas pelos pecados feitas por suas vidas serão sempre lembradas diante do Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","O Senhor continuou falando com Moisés: ");
INSERT INTO poronbv_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Faça uma bacia de bronze com uma base de bronze, para servir de lavatório. Coloque a bacia entre o santuário e o altar, e encha-a de água. ");
INSERT INTO poronbv_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Arão e seus filhos devem lavar as mãos e os pés com a água da bacia. ");
INSERT INTO poronbv_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Toda vez que entrarem no santuário ou quando se aproximarem do altar para prestarem serviço ao Senhor, apresentando uma oferta queimada ao Senhor, terão de lavar-se com água para que não morram. ");
INSERT INTO poronbv_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Eles, pois, lavarão as mãos e os pés para que não morram. Isso é lei permanente para Arão e os seus descendentes, de geração em geração”. ");
INSERT INTO poronbv_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Em seguida, o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Junte as mais finas especiarias: seis quilos de mirra líquida, a metade disso, ou seja, três quilos de cálamo aromático, ");
INSERT INTO poronbv_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","três quilos de cássia aromática, com base no peso padrão do siclo do santuário, e aproximadamente 5 litros de azeite de oliveira. ");
INSERT INTO poronbv_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Entregue tudo aos perfumistas especializados para prepararem uma mistura de aromas, que será o óleo sagrado para a unção. ");
INSERT INTO poronbv_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Use esse óleo sagrado para ungir o Tabernáculo, a arca da aliança, ");
INSERT INTO poronbv_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","a mesa e todos os utensílios, o candelabro com seus utensílios, o altar de incenso, ");
INSERT INTO poronbv_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","o altar das ofertas queimadas com todos os seus utensílios e a bacia com a sua base. ");
INSERT INTO poronbv_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Deste modo você consagrará todas essas coisas e se tornarão santíssimas, e tudo o que tocar nelas se tornará santo. ");
INSERT INTO poronbv_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Use também o óleo da unção para derramar em Arão e nos seus filhos e consagreos para me servirem como sacerdotes. ");
INSERT INTO poronbv_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Diga aos israelitas: ‘Este será o meu óleo sagrado para a unção, geração após geração. ");
INSERT INTO poronbv_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ele não deverá ser usado para ungir o corpo de nenhum outro homem, e não fabriquem outro óleo com a mesma fórmula. Esse óleo é sagrado, e assim deve ser considerado. ");
INSERT INTO poronbv_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Qualquer pessoa que preparar óleo com essa fórmula, ou ungir um estranho, será eliminada do meio do seu povo’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","O Senhor deu ordens a Moisés, a respeito do incenso, dizendo: “Junte as seguintes essências: estoraque, ônica, gálbano e incenso puro, todas em quantidades iguais, ");
INSERT INTO poronbv_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","e faça um incenso de mistura aromática. Tempere com sal, puro e santo, segundo a arte do perfumista. ");
INSERT INTO poronbv_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Moa uma parte desse incenso para que se torne pó. Coloque o incenso em pó em frente à arca da aliança, no Tabernáculo, onde me encontrarei com você. Considerem esse incenso santíssimo. ");
INSERT INTO poronbv_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ninguém deve usar essa fórmula para fabricar incenso para uso particular. Considerem-no sagrado, dedicado ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Quem fizer incenso parecido, para usufruir do seu aroma, será eliminado do seu povo”. ");
INSERT INTO poronbv_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","O Senhor disse mais a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Eu escolhi Bezalel, filho de Uri e neto de Hur, da tribo de Judá, ");
INSERT INTO poronbv_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","e o enchi do Espírito de Deus. Dei a ele habilidade, inteligência e conhecimento artístico ");
INSERT INTO poronbv_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","para desenhar e trabalhar em ouro, prata e bronze, ");
INSERT INTO poronbv_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","para lapidar e esculpir pedras; para entalhar madeira, e para fazer toda espécie de obra artesanal. ");
INSERT INTO poronbv_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Escolhi como seu companheiro Aoliabe, filho de Aisamaque, da tribo de Dã. Também capacitei todos os artesãos para fazerem tudo o que mandei. ");
INSERT INTO poronbv_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Farão o Tabernáculo, a arca da aliança, a tampa que estará sobre ela e todos os outros utensílios do Tabernáculo, ");
INSERT INTO poronbv_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","a mesa com as suas vasilhas, o candelabro de ouro com todos os seus utensílios, o altar de incenso; ");
INSERT INTO poronbv_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","o altar das ofertas queimadas com todos os seus utensílios e a bacia com a sua base, ");
INSERT INTO poronbv_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","as roupas de tecido fino, e as roupas sagradas para o sacerdote Arão e os seus filhos, quando me servirem como sacerdotes; ");
INSERT INTO poronbv_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","o óleo para as unções e o incenso aromático para o Lugar Santo. Tudo deve ser feito seguindo as instruções que dei a você”. ");
INSERT INTO poronbv_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","O Senhor disse ainda a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Diga aos israelitas: ‘Certamente vocês guardarão os meus sábados. Isso será um sinal entre mim e vocês, de geração em geração, para que se lembrem que eu sou o Senhor que os santifica. ");
INSERT INTO poronbv_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Portanto, guardem o sábado, porque é santo para vocês. Aquele que fizer alguma obra nesse dia, será eliminado do meio do seu povo. ");
INSERT INTO poronbv_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Por isso, trabalhem seis dias da semana, mas descansem no sábado, que é o sétimo dia, consagrado ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","O povo de Israel deverá guardar o sábado, de geração em geração, como uma aliança perpétua. ");
INSERT INTO poronbv_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","É um sinal permanente da minha aliança com o meu povo, porque o Senhor fez os céus e a terra em seis dias, e no sétimo dia ele descansou’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Quando ele acabou de falar com Moisés no monte Sinai, deu-lhe as duas tábuas da aliança, tábuas em pedra, escritas pelo dedo de Deus! ");
INSERT INTO poronbv_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mas, vendo o povo que Moisés demorava para descer do monte, reuniram-se todos ao redor de Arão e disseram: “Faça deuses que sirvam de guias para nós, pois a Moisés — esse homem que nos tirou do Egito — não sabemos o que aconteceu”. ");
INSERT INTO poronbv_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Arão respondeu-lhes: “Tirem as argolas de ouro das orelhas de suas mulheres, de seus filhos e de suas filhas e tragam-nas a mim”. ");
INSERT INTO poronbv_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Então, todo o povo tirou das orelhas as argolas de ouro e as trouxeram a Arão. ");
INSERT INTO poronbv_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ele as recebeu, derreteu o ouro, e com ferramentas próprias fez um bezerro fundido. Então disseram: “Israel, este é o deus que tirou você do Egito!” ");
INSERT INTO poronbv_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ao ver isso, Arão edificou um altar diante do bezerro e anunciou: “Amanhã vamos fazer uma festa ao Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","No dia seguinte, todos levantaram cedo e ofereceram ofertas queimadas e ofertas de paz ao bezerro de ouro. O povo assentou-se para comer e beber e levantou-se para se divertir. ");
INSERT INTO poronbv_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Então o Senhor disse a Moisés: “Desça, pois o seu povo, o povo que você tirou do Egito, corrompeu-se ");
INSERT INTO poronbv_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","e depressa se desviou do caminho que eu havia ordenado. Fez um bezerro de ouro fundido e lhe ofereceu culto, e ofereceu sacrifícios a ele! Além disso, o povo diz: ‘Israel, este é o seu deus que tirou você do Egito!’ ” ");
INSERT INTO poronbv_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","O Senhor disse mais a Moisés: “Tenho percebido que este povo é um povo rebelde. ");
INSERT INTO poronbv_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Agora deixe-me sozinho, para que a minha ira se acenda sobre eles, e eu os destruirei. Depois, farei de você uma grande nação”. ");
INSERT INTO poronbv_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mas Moisés implorou ao Senhor, seu Deus. “Senhor”, disse ele, “por que ficar indignado assim com o seu povo, que o Senhor tirou da terra do Egito com grande poder e forte mão? ");
INSERT INTO poronbv_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Por que deixar os egípcios dizer: ‘Foi com má intenção que os tirou, para matá-los nos montes e para bani-los da face da terra’? Volte atrás, eu peço, e apague a sua indignação. Tenha piedade e desista de fazer esse terrível mal ao seu povo! ");
INSERT INTO poronbv_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Lembre-se dos seus servos Abraão, Isaque e Israel, aos quais jurou pelo seu nome: ‘Multiplicarei os seus descendentes, como as estrelas do céu e darei a eles toda esta terra que prometi a eles, e os seus descendentes herdarão esta terra para sempre’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Então, o Senhor desistiu do mal que faria ao povo. ");
INSERT INTO poronbv_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moisés desceu do monte, levando nas mãos as duas tábuas da Lei, tábuas escritas de ambos os lados, frente e verso. ");
INSERT INTO poronbv_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Deus mesmo tinha feito as tábuas. O que nelas estava gravado também fora escrito por Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Quando Josué ouviu o barulho do povo gritando, disse a Moisés: “Parece que há um barulho de guerra no acampamento”. ");
INSERT INTO poronbv_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","“Nada disso!”, disse Moisés. “Não é nem barulho de vitória, nem de derrota. Na verdade, ouço gente cantando”. ");
INSERT INTO poronbv_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Quando Moisés se aproximou do acampamento e viu o bezerro e as danças, ficou furioso! Ele jogou as duas tábuas de pedra no chão, quebrando-as ao pé do monte! ");
INSERT INTO poronbv_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Em seguida, pegou o bezerro que eles tinham feito e o derreteu, depois o moeu, reduzindo-o a pó, que espalhou na água, e fez os israelitas beberem aquela água. ");
INSERT INTO poronbv_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Depois Moisés perguntou a Arão: “O que foi que esse povo fez a você, para que você o levasse a cometer um pecado tão grande?” ");
INSERT INTO poronbv_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Arão respondeu: “Não fique irado comigo, meu senhor. Você sabe como este povo está sempre pronto para fazer o mal. ");
INSERT INTO poronbv_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Eles me disseram: ‘Faça deuses que sirvam de guias para nós, pois a Moisés — o homem que nos tirou do Egito — não sabemos o que aconteceu’. ");
INSERT INTO poronbv_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Então eu disse a eles: ‘Quero que me tragam o ouro que tiverem’. O povo trouxe-me o ouro, eu o joguei no fogo e — veja só! — surgiu esse bezerro!” ");
INSERT INTO poronbv_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moisés viu que o povo estava desenfreado e que Arão o deixou completamente fora de controle, tendo se tornado objeto de zombaria para os seus inimigos. ");
INSERT INTO poronbv_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Então ficou em pé, à entrada do acampamento, e disse: “Quem é do Senhor, venha até mim”. Logo foram para perto dele os filhos de Levi. ");
INSERT INTO poronbv_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Disse Moisés a eles: “Assim diz o Senhor, o Deus de Israel: ‘Pegue cada um a sua espada, percorra o acampamento, de ponta a ponta, ida e volta, de porta em porta, e mate cada um o seu irmão, o seu amigo e o seu vizinho’ ”. ");
INSERT INTO poronbv_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","E fizeram os levitas conforme a palavra de Moisés, e naquele dia foram mortos cerca de três mil homens. ");
INSERT INTO poronbv_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moisés então falou aos levitas: “Hoje vocês se consagraram ao Senhor, pois nenhum de vocês poupou seu filho ou seu irmão, de modo que o Senhor os abençoou hoje”. ");
INSERT INTO poronbv_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","No dia seguinte Moisés disse ao povo: “Vocês cometeram um terrível pecado. Mas eu subirei novamente ao Senhor, e talvez consiga obter o perdão pelo pecado de vocês”. ");
INSERT INTO poronbv_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moisés voltou ao Senhor e disse: “O povo cometeu grande pecado, fazendo deuses de ouro. ");
INSERT INTO poronbv_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mas agora, lhe imploro, perdoe o pecado deles. Senão, peço que me risque do livro que o Senhor escreveu”. ");
INSERT INTO poronbv_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","O Senhor respondeu a Moisés: “Riscarei do meu livro todo aquele que pecar contra mim. ");
INSERT INTO poronbv_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Agora vá e conduza o povo ao lugar de que lhe falei; esteja certo de que o meu anjo irá à sua frente. Porém, no dia da minha visitação, eu os punirei pelos seus pecados”. ");
INSERT INTO poronbv_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","E o Senhor lançou grande castigo sobre os israelitas por causa do bezerro que Arão tinha feito. ");
INSERT INTO poronbv_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Depois o Senhor ordenou a Moisés: “Leve este povo que você tirou do Egito para a terra que jurei dar a Abraão, a Isaque e a Jacó. Pois eu disse a eles: ‘Darei esta terra aos seus descendentes’. ");
INSERT INTO poronbv_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mandarei à sua frente o anjo. Expulsarei do território os cananeus, os amorreus, os heteus, os ferezeus, os heveus e os jebuseus. ");
INSERT INTO poronbv_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Vão para a terra que jorra leite e mel. Mas eu não irei com vocês, pois vocês são um povo rebelde, e eu poderia destruí-los no caminho”. ");
INSERT INTO poronbv_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Quando o povo ouviu essas más notícias, começou a chorar, e nenhum deles usou as suas joias. ");
INSERT INTO poronbv_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Pois o Senhor tinha mandado Moisés falar ao povo: “Vocês são um povo rebelde. Se eu for com vocês, ainda que por um só momento, os destruiria. Agora, tirem as joias e enfeites que estão usando, até eu decidir o que faço com vocês”. ");
INSERT INTO poronbv_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Por isso, a partir do monte Horebe, os israelitas deixaram de usar joias e enfeites. ");
INSERT INTO poronbv_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moisés costumava armar a tenda longe do acampamento. Ele a chamava de “Tenda do Encontro com Deus”. Todo aquele que quisesse consultar o Senhor ia à tenda, fora do acampamento. ");
INSERT INTO poronbv_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Sempre que Moisés ia para a tenda, todo o povo se levantava e ficava em pé à entrada de suas tendas, e o observavam pelas costas, até que entrasse na tenda. ");
INSERT INTO poronbv_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Assim que Moisés entrava, a coluna de nuvem descia e ficava à entrada da tenda. E o Senhor falava com Moisés. ");
INSERT INTO poronbv_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Quando o povo via a coluna de nuvem na entrada da tenda, todos ficavam em pé, à entrada da sua própria tenda, e adoravam ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","O Senhor falava com Moisés face a face, como quem fala com um amigo. Depois Moisés voltava ao acampamento, mas Josué, filho de Num, seu ajudante, não se afastava daquela tenda. ");
INSERT INTO poronbv_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moisés disse ao Senhor: “O Senhor me ordenou: ‘Leve este povo’, mas não me diz quem enviará comigo. Também me disse: ‘Conheço você pelo nome e você tem me agradado’. ");
INSERT INTO poronbv_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Se o Senhor me vê com agrado, peço que me revele agora os seus caminhos, para que eu o conheça e continue sendo agradável ao Senhor. Lembre-se que esta nação é o seu povo”. ");
INSERT INTO poronbv_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","O Senhor respondeu: “Eu mesmo irei com você e darei descanso a você”. ");
INSERT INTO poronbv_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Então Moisés disse: “Se a sua presença não for comigo, não nos mande sair deste lugar! ");
INSERT INTO poronbv_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Como eu e o meu povo saberemos se podemos contar com o seu favor, se o Senhor não for conosco? Quem poderá saber que somos o seu povo e que somos diferentes de todos os povos da terra?” ");
INSERT INTO poronbv_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","O Senhor disse a Moisés: “Vou atender ao seu pedido, porque tenho me agradado de você e o conheço pelo nome”. ");
INSERT INTO poronbv_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moisés disse: “Peço que me deixe ver a sua glória”. ");
INSERT INTO poronbv_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","O Senhor respondeu: “Farei passar toda a minha bondade, e diante de você farei saber o meu nome: Eu sou o Senhor. Terei misericórdia de quem eu quiser ter misericórdia, e me compadecerei de quem eu quiser me compadecer”. ");
INSERT INTO poronbv_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","E acrescentou: “Mas você não poderá ver a minha face, porque nenhum homem poderá continuar vivo depois de me ver”. ");
INSERT INTO poronbv_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","O Senhor prosseguiu: “Contudo, fique nesta pedra, ao meu lado. ");
INSERT INTO poronbv_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Quando a minha glória passar, eu o colocarei numa fenda da rocha e o cobrirei com a minha mão, até que tenha acabado de passar. ");
INSERT INTO poronbv_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Depois tirarei a mão e você me verá pelas costas; mas a minha face ninguém poderá ver”. ");
INSERT INTO poronbv_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","O Senhor disse a Moisés: “Talhe duas tábuas de pedra como as primeiras, e nelas escreverei as mesmas palavras que estavam nas tábuas que você quebrou. ");
INSERT INTO poronbv_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Amanhã cedo esteja pronto para subir no monte Sinai e se apresentar a mim no alto do monte. ");
INSERT INTO poronbv_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Que ninguém vá com você e que ninguém pise em algum lugar no monte; nem mesmo as ovelhas e os bois devem pastar perto do monte”. ");
INSERT INTO poronbv_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Moisés, pois, preparou duas tábuas de pedra como as primeiras e subiu com elas no monte Sinai, logo de manhã, como o Senhor havia mandado. ");
INSERT INTO poronbv_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","O Senhor desceu na nuvem, permaneceu ali com Moisés e proclamou o seu nome: o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","E passou diante de Moisés, proclamando: “Eu, somente eu, sou Deus compassivo e cheio de graça, paciente, cheio de misericórdia e de fidelidade. ");
INSERT INTO poronbv_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Mostro o meu amor fiel até mil gerações, perdoo a maldade, a rebelião e o pecado. Não deixo sem castigo o culpado; castigo os filhos e os netos pelo pecado dos pais até a terceira e quarta geração”. ");
INSERT INTO poronbv_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moisés se curvou depressa, com o rosto no chão, e o adorou, dizendo: ");
INSERT INTO poronbv_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“Senhor, se achei mesmo favor diante dos seus olhos, siga conosco para a Terra Prometida. Sei que este povo é rebelde e teimoso, mas peço: Perdoe a nossa maldade e o nosso pecado e aceite-nos como seu povo!” ");
INSERT INTO poronbv_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Então o Senhor disse: “Faço uma aliança. Diante de todo o seu povo farei maravilhas que nunca foram feitas em toda a terra, nem entre nação alguma. Assim todo o povo — com o qual você está — vai ver os atos poderosos que eu, o Senhor, farei. ");
INSERT INTO poronbv_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Obedeça às ordens que hoje dou a você. Expulsarei da sua presença os cananeus, os amorreus, os heteus, os ferezeus, os heveus e os jebuseus. ");
INSERT INTO poronbv_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Não faça nenhum acordo com os moradores da terra para onde você vai. Assim você não cairá na armadilha deles. ");
INSERT INTO poronbv_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Em vez disso, destrua os seus altares, quebre as suas colunas sagradas e seus postes-ídolos. ");
INSERT INTO poronbv_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Nunca adore nenhum outro deus, porque o Senhor, cujo nome é Zeloso, de fato é Deus zeloso! ");
INSERT INTO poronbv_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Por isso, nada de fazer acordo com os habitantes daquela terra; pois quando eles forem fazer seus cultos imorais e os sacrifícios aos falsos deuses, convidarão você e poderão levá-lo a comer dos sacrifícios oferecidos aos ídolos ");
INSERT INTO poronbv_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","e a escolher mulheres para os seus filhos dentre as moças daqueles povos. Quando elas se prostituírem com seus deuses, poderão passar a infidelidade deles para os seus filhos. ");
INSERT INTO poronbv_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Por isso, não fabrique deuses de metal para você. ");
INSERT INTO poronbv_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Celebre a festa dos pães sem fermento. Durante sete dias coma pão sem fermento, como lhe mandei. Faça isso na data certa — no mês de abibe; porque nesse mês você saiu do Egito. ");
INSERT INTO poronbv_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Todos os primeiros filhos são meus. Também são meus todos os machos dentre as primeiras crias dos seus rebanhos. ");
INSERT INTO poronbv_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","No caso dos jumentos é diferente. A primeira cria terá de ser resgatada com um cordeiro. Quer dizer, no lugar do jumento, o dono me dará um cordeiro. Se não for resgatado, terá de ser morto. Paguem o resgate por todos os seus primeiros filhos. “Ninguém compareça diante de mim de mãos vazias, isto é, sem oferta. ");
INSERT INTO poronbv_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Trabalhe seis dias, mas descanse no sétimo — tanto na época da semeadura como na época da colheita. ");
INSERT INTO poronbv_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Celebre também as outras duas festas anuais. Celebre a festa das semanas, a festa dos primeiros frutos da colheita de trigo e a festa da colheita, no fim do ano. ");
INSERT INTO poronbv_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Resumindo, são três festas por ano. Nessas três vezes, todo homem de Israel se apresentará ao Senhor Deus, o Deus de Israel. ");
INSERT INTO poronbv_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Expulsarei as nações de diante de você e vou aumentar muito o território do meu povo. Ninguém cobiçará a sua terra quando você subir três vezes ao ano para apresentar-se ao Senhor, o seu Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“No sacrifício, não ofereçam sangue misturado com pão fermentado, e não deixem sobra alguma do sacrifício da festa da Páscoa para o dia seguinte. ");
INSERT INTO poronbv_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Quando fizer a primeira colheita, traga o melhor dos primeiros frutos à casa do Senhor, o seu Deus. “Não cozinhe o cabrito no leite da própria mãe”. ");
INSERT INTO poronbv_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","O Senhor disse a Moisés: “Escreva essas palavras, porque são os termos da minha aliança com você e com Israel”. ");
INSERT INTO poronbv_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moisés ficou quarenta dias e quarenta noites com o Senhor. Durante esse tempo ele não comeu pão nem bebeu água; e escreveu nas tábuas as palavras da aliança: os Dez Mandamentos. ");
INSERT INTO poronbv_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ao descer o monte Sinai com as tábuas da aliança nas mãos, Moisés não percebeu que o seu rosto resplandecia, por ter ficado na presença de Deus. ");
INSERT INTO poronbv_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Quando Arão e todos os israelitas viram Moisés com o rosto brilhando, tiveram medo de aproximar-se dele. ");
INSERT INTO poronbv_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Então Moisés os chamou. Arão e os líderes da comunidade de Israel se aproximaram, e Moisés falou com eles. ");
INSERT INTO poronbv_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Depois chegaram também todos os israelitas, e ele transmitiu todos os mandamentos que o Senhor lhe tinha dado no monte Sinai. ");
INSERT INTO poronbv_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Quando Moisés acabou de falar com eles, cobriu o rosto com um véu. ");
INSERT INTO poronbv_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Cada vez que Moisés vinha perante o Senhor para falar com ele, tirava o véu até sair. Sempre que saía, transmitia aos israelitas tudo o que lhe tinha sido ordenado. ");
INSERT INTO poronbv_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Assim o povo de Israel via o rosto de Moisés brilhar. Mas, logo depois de transmitir as ordens de Deus, Moisés tornava a cobrir o rosto com o véu, até falar novamente com o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moisés convocou toda a comunidade de Israel e disse-lhe: “Estas são as palavras que o Senhor mandou que vocês obedecessem: ");
INSERT INTO poronbv_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","‘Trabalhem seis dias da semana, mas o sétimo dia será santo para vocês, o sábado solene de descanso, dedicado ao Senhor. Quem trabalhar nesse dia, terá de morrer. ");
INSERT INTO poronbv_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Não acendam fogo em nenhuma de suas casas no dia de sábado!’ ” ");
INSERT INTO poronbv_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moisés continuou falando à comunidade de Israel. Ele disse: “Foi isto que o Senhor mandou fazer: ");
INSERT INTO poronbv_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‘Separem dos seus bens uma oferta ao Senhor. Todo aquele que sentir o desejo no coração, traga como oferta ao Senhor ouro, prata e bronze; ");
INSERT INTO poronbv_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","fios de tecido azul, vermelho-púrpura e vermelho-carmesim; linho fino e pelos de cabra; ");
INSERT INTO poronbv_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","peles de carneiro tingidas de vermelho e couro; madeira de acácia; ");
INSERT INTO poronbv_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","azeite para a iluminação; especiarias para o óleo de unção e para o incenso aromático especial; ");
INSERT INTO poronbv_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","pedras de ônix e outras pedras preciosas para prender no colete sacerdotal e no peitoral das roupas sacerdotais’ ” . ");
INSERT INTO poronbv_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Todos os homens habilidosos venham fazer o que o Senhor mandou: ");
INSERT INTO poronbv_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","o Tabernáculo com a tenda e sua cobertura, os prendedores, as armações, os travessões, as colunas e as bases; ");
INSERT INTO poronbv_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","a arca e suas varas, a tampa e o véu para cobrir o Lugar Santo; ");
INSERT INTO poronbv_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","a mesa, suas varas e todos os seus utensílios, e os pães da Presença divina; ");
INSERT INTO poronbv_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","o candelabro, com seus utensílios, as lâmpadas e o azeite para a iluminação; ");
INSERT INTO poronbv_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","o altar de incenso e suas varas, o óleo da unção e o incenso aromático especial; a cortina divisória à entrada do Tabernáculo; ");
INSERT INTO poronbv_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","o altar para as ofertas queimadas, a grelha de bronze, as varas e todos os utensílios do altar; a bacia de bronze e sua base; ");
INSERT INTO poronbv_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","as cortinas para as paredes do pátio com suas colunas e bases, e a cortina da entrada para o pátio; ");
INSERT INTO poronbv_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","as estacas e as cordas para firmar o Tabernáculo e o pátio; ");
INSERT INTO poronbv_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","as roupas sagradas para os sacerdotes usarem quando estiverem servindo no Lugar Santo, tanto as roupas sagradas de Arão como as roupas de seus filhos, para quando servirem como sacerdotes”. ");
INSERT INTO poronbv_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Então toda a comunidade de Israel saiu da presença de Moisés, ");
INSERT INTO poronbv_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","e todos aqueles que estavam dispostos trouxeram de boa vontade suas ofertas ao Senhor, para a construção do Tabernáculo, para todos os seus serviços e para as roupas sagradas. ");
INSERT INTO poronbv_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Vieram homens e mulheres, todos que sentiam disposição no coração. Trouxeram fivelas, colares, brincos, anéis, braceletes e outros objetos de ouro. Todos os homens faziam ofertas de ouro ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Os que possuíam tecido azul, vermelho-púrpura ou vermelho-carmesim, linho fino, pelos de cabra, peles de carneiro tingidas de vermelho ou couro ofertavam essas coisas ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Outros trouxeram como oferta ao Senhor objetos de prata ou de bronze, além de madeira de acácia própria para a construção. ");
INSERT INTO poronbv_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Todas as mulheres habilidosas trouxeram o que elas fizeram com suas próprias mãos: tecido azul, vermelho-púrpura e vermelho-carmesim e linho fino. ");
INSERT INTO poronbv_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Todas as mulheres que tinham habilidade, teceram os pelos de cabra. ");
INSERT INTO poronbv_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Os líderes trouxeram pedras de ônix e outras pedras de valor para serem colocadas no colete sacerdotal e no peitoral. ");
INSERT INTO poronbv_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Deram também especiarias e azeite de oliva para a iluminação, para o óleo de unção e para o incenso aromático especial. ");
INSERT INTO poronbv_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Os israelitas, tanto homens como mulheres, que sentiram em seu coração o desejo de ajudar em todo o trabalho que o Senhor mandou fazer por meio de Moisés, trouxeram oferta voluntária ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moisés disse aos israelitas: “O Senhor escolheu Bezalel, filho de Uri, neto de Hur, da tribo de Judá, ");
INSERT INTO poronbv_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","e o Espírito de Deus o encheu de habilidade, inteligência e capacidade artística em todas as artes e ofícios necessários, ");
INSERT INTO poronbv_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","para elaborar os desenhos e trabalhar em ouro, prata e bronze, ");
INSERT INTO poronbv_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","para talhar e lapidar pedras e entalhar madeira para fazer todo tipo de trabalho artesanal. ");
INSERT INTO poronbv_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Além disso, o Senhor deu a ele e a Aoliabe, filho de Aisamaque, da tribo de Dã, o dom de ensinar os outros. ");
INSERT INTO poronbv_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ele lhes deu a capacidade extraordinária para realizar todo tipo de serviços de carpinteiro e joalheiro. Também para fazer bordados em linho fino e de fios de tecido azul, vermelho-púrpura e vermelho-carmesim e para fazer qualquer trabalho artesanal”. ");
INSERT INTO poronbv_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Assim, Bezalel, Aoliabe e todos os homens capazes a quem o Senhor tinha concedido habilidade e inteligência para fazerem toda a obra de construção do Santuário executaram a obra como o Senhor tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moisés chamou Bezalel, Aoliabe e todos os homens hábeis em cujo coração o Senhor tinha colocado sabedoria, e que tinham se colocado à disposição para vir e começar a obra. ");
INSERT INTO poronbv_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Moisés entregou a eles os materiais doados pelo povo para a construção do santuário. E todas as manhãs o povo trazia mais ofertas voluntárias a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Por isso, todos os construtores habilidosos que trabalhavam no santuário interromperam o trabalho ");
INSERT INTO poronbv_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","e disseram a Moisés: “O povo está trazendo muito mais do que o necessário para realizar a obra que o Senhor ordenou”. ");
INSERT INTO poronbv_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Então Moisés mandou proclamar em todo acampamento a seguinte mensagem: “Nenhum homem ou mulher traga mais oferta alguma para a construção do santuário”. Foi preciso proibir o povo de dar mais ofertas, ");
INSERT INTO poronbv_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","pois já havia mais do que o suficiente para realizar toda a obra. ");
INSERT INTO poronbv_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Todos os homens habilidosos dentre os trabalhadores fizeram o Tabernáculo com dez cortinas internas. As cortinas eram de linho fino trançado e de fios de tecido azul, vermelho-púrpura e vermelho-carmesim. Nelas foram bordados querubins, ou seja, figuras de anjos. O trabalho foi feito com muita arte. ");
INSERT INTO poronbv_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Cada cortina media doze metros e sessenta centímetros de comprimento por um metro e oitenta centímetros de largura. ");
INSERT INTO poronbv_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ligaram cinco cortinas internas umas às outras, e fizeram o mesmo com as outras cinco. ");
INSERT INTO poronbv_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Fizeram laços de tecido azul ao longo da borda da última cortina de cada um dos conjuntos de cortinas. ");
INSERT INTO poronbv_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Depois fizeram cinquenta laços na primeira cortina interna e cinquenta laços na última cortina do segundo conjunto; os laços ficavam de frente uns para os outros. ");
INSERT INTO poronbv_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Os dois conjuntos de cortinas foram presos um no outro por meio de cinquenta prendedores de ouro. Dessa maneira o Tabernáculo ficou sendo uma peça só. ");
INSERT INTO poronbv_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","A cobertura do Tabernáculo foi feita com um total de onze cortinas de pelos de cabra. ");
INSERT INTO poronbv_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","E todas as cortinas internas tinham o mesmo tamanho, ou seja, treze metros e meio de comprimento por um metro e oitenta centímetros de largura. ");
INSERT INTO poronbv_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Prenderam cinco cortinas umas nas outras, formando um conjunto, e as outras seis formaram o outro conjunto. ");
INSERT INTO poronbv_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Depois fizeram cinquenta laços em volta da borda da última cortina de um dos conjuntos e também na borda da última cortina do outro conjunto. ");
INSERT INTO poronbv_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Fizeram também cinquenta prendedores de bronze para unir a tenda, para se tornar uma peça inteiriça. ");
INSERT INTO poronbv_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Fizeram mais uma cobertura, de peles de carneiro tingidas de vermelho, e por cima desta outra cobertura de couro. ");
INSERT INTO poronbv_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Para a estrutura do Tabernáculo fizeram armações verticais de madeira de acácia. ");
INSERT INTO poronbv_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Cada armação media quatro metros e meio de comprimento por setenta centímetros de largura. ");
INSERT INTO poronbv_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Cada armação tinha dois encaixes paralelos, de modo que todas as armações ficavam encaixadas umas nas outras. ");
INSERT INTO poronbv_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Fizeram também vinte armações para o lado sul do Tabernáculo, ");
INSERT INTO poronbv_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","quarenta bases de prata para serem colocadas debaixo das armações; duas bases para cada armação, uma para cada junção dos encaixes. ");
INSERT INTO poronbv_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Para o outro lado, o lado norte, fizeram a mesma coisa: vinte armações ");
INSERT INTO poronbv_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","e quarenta bases de prata, duas debaixo de cada armação. ");
INSERT INTO poronbv_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Nos fundos, no lado oeste do Tabernáculo, fizeram seis armações, ");
INSERT INTO poronbv_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","além de duas armações para os cantos na parte de trás do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Nesses dois cantos as armações eram duplas, formando uma só peça até a primeira argola que ficava na parte de cima. ");
INSERT INTO poronbv_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Portanto, havia oito armações ao todo e todas estavam fixas em dezesseis bases de prata — duas para cada armação. ");
INSERT INTO poronbv_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Também fizeram travessões de madeira de acácia: cinco para as armações de um lado do Tabernáculo, ");
INSERT INTO poronbv_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","cinco para as armações do outro lado e cinco para as armações para a parte de trás do Tabernáculo, que dá para o ocidente. ");
INSERT INTO poronbv_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Fizeram o travessão central, passando pelo meio das armações, ligando todas as armações, de ponta a ponta do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","As armações e as travessas foram revestidas de ouro, e fizeram as argolas de ouro para sustentar os travessões. ");
INSERT INTO poronbv_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Para a parte de dentro do Tabernáculo, fizeram um véu de linho fino trançado e de fios de tecido azul, vermelho-púrpura e vermelho-carmesim, e mandaram bordar, por artistas, figuras de querubins. ");
INSERT INTO poronbv_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","O véu ficou pendendo de quatro colunas de madeira de acácia recobertas de ouro. Para prender e fixar o véu, foram usados prendedores de ouro e foram feitas quatro bases de prata. ");
INSERT INTO poronbv_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Para a entrada do Tabernáculo, fizeram uma cortina de linho fino trançado e de fios de tecido azul, vermelho-púrpura e vermelho-carmesim. O trabalho foi confiado a um bordador. ");
INSERT INTO poronbv_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Para sustentar as cortinas, fizeram cinco colunas com os prendedores necessários. Revestiram de ouro a parte de cima das colunas e as molduras das cortinas, mas as cinco bases eram de bronze. ");
INSERT INTO poronbv_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel fez também a arca. Era de madeira de acácia e media um metro e dez centímetros de comprimento, setenta centímetros de largura e setenta centímetros de altura. ");
INSERT INTO poronbv_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Revestiu-a de ouro puro, por dentro e por fora, e fez uma moldura de ouro ao seu redor. ");
INSERT INTO poronbv_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Fundiu quatro argolas de ouro para os quatro cantos da arca, duas para cada lado. ");
INSERT INTO poronbv_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Fez também varas de madeira de acácia revestidas de ouro. ");
INSERT INTO poronbv_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","As varas foram introduzidas nas argolas dos lados para carregar a arca. ");
INSERT INTO poronbv_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Fez uma tampa de ouro medindo um metro e dez centímetros de comprimento por setenta centímetros de largura. ");
INSERT INTO poronbv_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Fez também dois querubins de ouro batido, um em cada ponta da tampa. ");
INSERT INTO poronbv_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","A tampa e os querubins formavam uma peça inteira. ");
INSERT INTO poronbv_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Os querubins tinham as asas estendidas para cima, cobrindo com elas a tampa. Estavam com as faces voltadas uma para a outra, olhando para a tampa. ");
INSERT INTO poronbv_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ele fez a mesa com madeira de acácia, com noventa centímetros de comprimento, quarenta e cinco centímetros de largura e setenta centímetros de altura. ");
INSERT INTO poronbv_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Revestiu-a de ouro puro e fez uma moldura de ouro em volta dela. ");
INSERT INTO poronbv_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Fez também um friso ao seu redor de quatro dedos de largura, e fez um enfeite de ouro, com um bordado, em volta do friso. ");
INSERT INTO poronbv_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Fundiu quatro argolas de ouro, uma para canto da mesa, onde estavam os quatro pés. ");
INSERT INTO poronbv_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Colocou as argolas nas pernas da mesa, pouco abaixo do friso, para que sustentassem as varas usadas para transportar a mesa. ");
INSERT INTO poronbv_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Fez as varas para transportar a mesa. As varas foram feitas de madeira de acácia, e foram revestidas de ouro. ");
INSERT INTO poronbv_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Também fez de ouro puro os utensílios para a mesa: os pratos, os talheres, as vasilhas para o incenso e as jarras para as ofertas de bebida. ");
INSERT INTO poronbv_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Fez também o candelabro de ouro puro batido. O pedestal, a haste, as taças, as flores e os botões formavam uma só peça. ");
INSERT INTO poronbv_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Eram seis braços, três de cada lado da haste central. ");
INSERT INTO poronbv_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Cada braço tinha três taças em forma de amêndoa, cada uma com botão e flor, e três taças com formato de flor de amêndoa no braço seguinte, cada uma com botão e flor. Assim era com os seis braços que saem do candelabro. ");
INSERT INTO poronbv_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Mas a haste central do candelabro tinha quatro taças em forma de amêndoa, cada uma com flor e botão. ");
INSERT INTO poronbv_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Havia um botão debaixo de cada par dos seis braços que saíam do candelabro. ");
INSERT INTO poronbv_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Os botões, os braços e o candelabro formavam uma só peça de ouro puro batido. ");
INSERT INTO poronbv_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Depois fez sete lâmpadas. Os cortadores de pavios e os apagadores eram de ouro puro. ");
INSERT INTO poronbv_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Foram gastos trinta e cinco quilos de ouro puro para fazer o candelabro com todos os seus utensílios. ");
INSERT INTO poronbv_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Fez ainda o altar de incenso, de madeira de acácia. Era quadrado, medindo quarenta e cinco centímetros de largura, e noventa centímetros de altura. As pontas de chifre e o altar propriamente dito formavam uma só peça. ");
INSERT INTO poronbv_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Revestiu de ouro puro a parte de cima, as paredes em volta e os chifres. Além disso, foi feita uma moldura de ouro ao seu redor. ");
INSERT INTO poronbv_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Fez também duas argolas de ouro de cada lado do altar, abaixo da moldura. Nessas argolas foram introduzidas as varas, para carregar o altar. ");
INSERT INTO poronbv_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","As varas eram de madeira de acácia, revestidas de ouro. ");
INSERT INTO poronbv_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Fez ainda o óleo santo da unção e o incenso aromático especial. Esse serviço foi feito por perfumistas especializados. ");
INSERT INTO poronbv_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezalel fez o altar das ofertas queimadas. Para esse serviço usou madeira de acácia. Era quadrado e media dois metros e vinte e cinco centímetros de comprimento e dois metros e vinte e cinco centímetros de largura e um metro e trinta e cinco centímetros de altura. ");
INSERT INTO poronbv_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Fez quatro pontas ou chifres que saíam dos quatro cantos do altar, formando uma só peça com o altar. O altar foi revestido de bronze. ");
INSERT INTO poronbv_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","De bronze fez também todos os utensílios do altar. Fez as vasilhas para recolher as cinzas, as pás, as bacias de aspersão, os garfos e os braseiros. ");
INSERT INTO poronbv_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Fez também uma grelha de bronze, em forma de rede, a meia altura do altar. ");
INSERT INTO poronbv_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Fundiu quatro argolas de bronze — uma em cada canto, para sustentar as varas. ");
INSERT INTO poronbv_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Fez as varas de madeira de acácia, revestidas de bronze. ");
INSERT INTO poronbv_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Para transportar o altar — que era de tábuas e oco — foram colocadas argolas nos dois lados. ");
INSERT INTO poronbv_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Fez ainda a bacia para servir de lavatório. A bacia e seu suporte eram de bronze, aproveitando os espelhos doados pelas mulheres que serviam na entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Fez também o pátio. O lado sul tinha quarenta e cinco metros de comprimento e cortinas externas de linho fino trançado. ");
INSERT INTO poronbv_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Eram sustentadas por vinte colunas e vinte bases de bronze. Os ganchos e os suportes das cortinas eram de prata. ");
INSERT INTO poronbv_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ele fez a mesma coisa no lado norte do pátio de quarenta e cinco metros de comprimento, com cortinas apoiadas em vinte colunas e vinte bases de bronze. Os ganchos e os suportes das colunas eram de prata. ");
INSERT INTO poronbv_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","O lado oeste, com cortinas externas, media vinte e dois metros e meio de largura, com dez colunas e dez bases. Os ganchos e os suportes eram de prata. ");
INSERT INTO poronbv_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","No lado leste era a mesma coisa: vinte e dois metros e meio de largura. ");
INSERT INTO poronbv_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","As cortinas de um lado da entrada eram de seis metros e setenta e cinco centímetros de comprimento, com três colunas e três bases. ");
INSERT INTO poronbv_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Do outro lado da entrada do pátio, as cortinas eram de seis metros e setenta e cinco centímetros de comprimento, também com três colunas e três bases. ");
INSERT INTO poronbv_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Todas as cortinas ao redor do pátio eram de linho fino trançado. ");
INSERT INTO poronbv_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","As bases das colunas eram de bronze. Os ganchos e os suportes das colunas eram de prata; a parte de cima das colunas também era revestida de prata, de modo que todas as colunas em volta do pátio eram unidas por suportes de prata. ");
INSERT INTO poronbv_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","A cortina da entrada do pátio era feita de linho fino trançado e de fios de tecidos azul, vermelho-púrpura e vermelho-carmesim, obra de bordador. Tinha nove metros de comprimento e, segundo a medida das cortinas do pátio, tinha dois metros e vinte e cinco centímetros de altura, ");
INSERT INTO poronbv_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","com quatro colunas e quatro bases de bronze. Os ganchos e suportes e a parte de cima das colunas eram de prata. ");
INSERT INTO poronbv_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Todas as estacas usadas na construção do Tabernáculo e do pátio eram de bronze. ");
INSERT INTO poronbv_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Essa é a relação do material usado no Tabernáculo, a saber, o Tabernáculo da aliança, registrada por ordem de Moisés, para que os levitas pudessem continuar seu ministério, sob a direção de Itamar, filho do sacerdote Arão. ");
INSERT INTO poronbv_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel, filho de Uri e neto de Hur, da tribo de Judá, fez tudo o que o Senhor ordenou a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Com ele estava Aoliabe, filho de Aisamaque, da tribo de Dã, perito desenhista e bordador em pano de linho fino e de fios de tecido azul, vermelho-púrpura e vermelho-carmesim. ");
INSERT INTO poronbv_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","O peso total do ouro que o povo trouxe como oferta e que foi usado em toda a obra do santuário foi de uma tonelada, conforme o peso padrão do santuário. ");
INSERT INTO poronbv_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","O total da prata recebida dos que foram contados no recenseamento da comunidade foi superior a três toneladas e meia. ");
INSERT INTO poronbv_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Seis gramas para cada um dos contados. Essa cobrança foi feita para todos de vinte anos para cima, que somaram 603.550. ");
INSERT INTO poronbv_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","As três toneladas e meia de prata foram usadas para fundir as bases do santuário e do véu: cem bases feitas das três toneladas e meia, trinta e cinco quilos para cada base. ");
INSERT INTO poronbv_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Vinte quilos e trezentos gramas foram usados para fazer os ganchos para as colunas e para revestir a parte de cima das colunas e para fazer os suportes. ");
INSERT INTO poronbv_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","O povo doou duas toneladas e meia de bronze. ");
INSERT INTO poronbv_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Com o bronze foram feitas as bases da entrada do Tabernáculo, o altar de bronze, a sua grelha e todos os utensílios do altar, ");
INSERT INTO poronbv_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","as bases do conjunto de cortinas do pátio, e todas as estacas usadas no Tabernáculo e no pátio que ficava em volta do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Foram feitas as roupas sacerdotais para o serviço do santuário para ministrar no Lugar Santo. Para isso, usaram fios de tecido azul, vermelho-púrpura e vermelho-carmesim. Também foram feitas as roupas sagradas para Arão. Tudo como o Senhor tinha mandado Moisés fazer. ");
INSERT INTO poronbv_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Fizeram o colete sacerdotal de linho fino trançado, de fios de ouro e de fios de tecido azul, vermelho-púrpura e vermelho-carmesim. ");
INSERT INTO poronbv_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","O ouro foi batido até se tornar em finas lâminas. As lâminas foram cortadas em fios. E os fios de ouro foram colocados entre os tecidos de linho fino, azul, vermelho-púrpura e vermelho-carmesim; verdadeiro trabalho artesanal. ");
INSERT INTO poronbv_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","O colete sacerdotal tinha duas partes — a da frente e a de trás — unidas nos ombros por ombreiras, atadas às duas extremidades. ");
INSERT INTO poronbv_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","O cinturão, que passava por cima do colete sacerdotal, formava uma peça só. O cinturão também foi feito de linho findo trançado, de fios de ouro e de fios de tecido azul, vermelho-púrpura e vermelho-carmesim, como o Senhor tinha mandado Moisés fazer. ");
INSERT INTO poronbv_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Também foram preparadas as pedras de ônix, encaixadas em base de ouro. Nelas foram gravados os nomes das tribos de Israel, como um lapidador grava um selo. ");
INSERT INTO poronbv_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Colocaram essas pedras nas ombreiras do colete sacerdotal, para conservar viva a memória do povo de Israel, como o Senhor tinha ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Depois fizeram artisticamente o peitoral, como o colete sacerdotal: de ouro e de fios de tecido azul, vermelho-púrpura e vermelho-carmesim e de linho fino trançado. ");
INSERT INTO poronbv_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Era quadrado, dobrado em dois, como um bolso, medindo vinte e dois centímetros de comprimento por vinte e dois centímetros de largura. ");
INSERT INTO poronbv_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Em seguida fixaram nele quatro fileiras de pedras preciosas. Na primeira fileira havia sárdio, topázio e carbúnculo; ");
INSERT INTO poronbv_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","na segunda fila, esmeralda, safira e diamante; ");
INSERT INTO poronbv_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","na terceira fila, jacinto, ágata e ametista; ");
INSERT INTO poronbv_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","na quarta fila, berilo, ônix e jaspe. Os encaixes foram modelados em ouro. ");
INSERT INTO poronbv_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Havia doze pedras. Cada pedra representava uma das tribos de Israel, cada uma gravada com o nome de uma das doze tribos, como um lapidador grava um selo. ");
INSERT INTO poronbv_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","E prenderam o peitoral no colete sacerdotal por meio de duas correntes trançadas de ouro puro, como cordas. ");
INSERT INTO poronbv_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Fizeram também duas argolas de ouro e as prenderam nas duas pontas do peitoral. ");
INSERT INTO poronbv_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Prenderam as duas correntes de ouro às argolas nas pontas do peitoral. ");
INSERT INTO poronbv_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","As outras pontas das duas cordas ficaram presas às partes da frente dos dois encaixes de pedras de ônix, nas ombreiras do colete sacerdotal. ");
INSERT INTO poronbv_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Fizeram também outras duas argolas de ouro e as prenderam nas duas pontas de baixo, por dentro do peitoral, junto ao colete sacerdotal. ");
INSERT INTO poronbv_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Depois fizeram mais duas argolas de ouro e as prenderam nas duas ombreiras do colete sacerdotal, abaixo, na frente, sobre o cinturão, que passa por cima do manto sacerdotal. ");
INSERT INTO poronbv_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Depois ligaram o fundo do peitoral às argolas da base do colete sacerdotal. Fizeram a ligação por meio de uma fita azul, ligando o peitoral ao cinturão. Isso mantém o peitoral sempre unido ao colete sacerdotal, como o Senhor tinha ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","O manto, roupa que vai por cima do colete sacerdotal, foi tecido inteiramente de fios de lã azul ");
INSERT INTO poronbv_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","e com uma abertura para a cabeça no meio. Essa abertura tinha um forro em volta, como uma gola, para não se rasgar. ");
INSERT INTO poronbv_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","O manto foi todo enfeitado com desenhos de romã de pano azul, vermelho-púrpura e vermelho-carmesim, em volta da borda do manto. ");
INSERT INTO poronbv_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Fizeram ainda pequenos sinos de ouro puro, atando-os em volta da borda, entre as romãs. ");
INSERT INTO poronbv_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Os sinos e as romãs eram intercalados, ou seja, um sino de ouro e uma romã, outro sino de ouro e outra romã, e assim por diante. Tudo feito para uso no ministério, como o Senhor tinha ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Para Arão e seus filhos fizeram de linho fino as túnicas — trabalho de tecelão — ");
INSERT INTO poronbv_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","o turbante, os gorros e os calções de linho fino trançado; ");
INSERT INTO poronbv_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","e o cinturão de linho fino trançado e de fios de tecido azul, vermelho-púrpura e vermelho-carmesim — trabalho de bordador — como o Senhor tinha ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Fizeram uma lâmina de ouro puro. Gravaram nela, como se grava um selo, a seguinte frase: “Consagrado ao Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","E prenderam a lâmina com um cordão azul na parte da frente do turbante, como o Senhor tinha ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Assim terminaram toda a obra do Tabernáculo. Os israelitas fizeram tudo conforme o Senhor tinha ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Então trouxeram o Tabernáculo inteiro a Moisés: a tenda e todos os seus utensílios, os prendedores, as armações, os travessões, as colunas e as bases, ");
INSERT INTO poronbv_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","a cobertura de pele de carneiro tingida de vermelho, a cobertura de couro e o véu protetor, ");
INSERT INTO poronbv_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","a arca da aliança com as suas varas e a tampa, ");
INSERT INTO poronbv_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","a mesa com todos os seus utensílios e os pães da Presença, ");
INSERT INTO poronbv_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","o candelabro de ouro puro com as suas lâmpadas nos seus lugares, com todos os seus utensílios e o azeite da iluminação; ");
INSERT INTO poronbv_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","o altar de ouro, o óleo da unção, o incenso aromático especial e a cortina da entrada do Tabernáculo, ");
INSERT INTO poronbv_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","o altar de bronze com a sua grelha, as suas varas e todos os demais utensílios do altar, a bacia e a sua base, ");
INSERT INTO poronbv_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","as cortinas externas do pátio com as suas colunas e bases e a cortina para a entrada do pátio, as cordas e as estacas da tenda do pátio, todos os utensílios para o serviço do Tabernáculo ");
INSERT INTO poronbv_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","e as roupas sacerdotais finamente tecidas, para serem usadas no serviço do santuário, e as roupas sagradas do sacerdote Arão e as roupas dos seus filhos para serem usadas durante a realização das suas funções sacerdotais. ");
INSERT INTO poronbv_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Os israelitas fizeram toda a obra conforme o Senhor tinha ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moisés inspecionou o trabalho deles e viu que tinham feito tudo conforme o Senhor tinha ordenado. E Moisés os abençoou. ");
INSERT INTO poronbv_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Depois dessas coisas, o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“No primeiro dia do mês arme o Tabernáculo da Tenda do Encontro. ");
INSERT INTO poronbv_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Coloque nele a arca da aliança (com os Dez Mandamentos) e cubra-a com o véu. ");
INSERT INTO poronbv_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Coloque no lugar próprio a mesa, e coloque em ordem as coisas que devem ficar sobre ela. Depois traga o candelabro e monte as suas lâmpadas. ");
INSERT INTO poronbv_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Coloque o altar de ouro para o incenso diante da arca da aliança e pendure a cortina à entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Ponha o altar das ofertas queimadas diante da porta do Tabernáculo; ");
INSERT INTO poronbv_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","coloque a bacia entre a tenda do santuário e o altar, e encha-a de água. ");
INSERT INTO poronbv_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Depois arme o pátio ao redor da tenda e instale a cortina na entrada do pátio. ");
INSERT INTO poronbv_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Então pegue o óleo da unção, e unja o Tabernáculo e tudo o que faz parte dele; desse modo você fará a consagração do Tabernáculo, com tudo que nele se encontra, e ele será sagrado. ");
INSERT INTO poronbv_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Em seguida, derrame o óleo da unção no altar das ofertas queimadas e todos os seus utensílios; consagre-o e ele se tornará santíssimo. ");
INSERT INTO poronbv_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Unja também a bacia com a sua base e consagre-a. ");
INSERT INTO poronbv_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Mande Arão e seus filhos chegarem à entrada do Tabernáculo e lave-os com água. ");
INSERT INTO poronbv_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Depois vista Arão com as roupas sagradas, unja-o e consagre-o para me servir como sacerdote. ");
INSERT INTO poronbv_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Traga também os filhos dele e vista-os com as roupas sacerdotais. ");
INSERT INTO poronbv_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Unjaos como você ungiu o pai deles, para que possam me servir como sacerdotes. Essa unção para o sacerdócio vale para sempre, de modo que os descendentes deles também serão sacerdotes, de geração em geração”. ");
INSERT INTO poronbv_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moisés fez tudo conforme o Senhor tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Assim, no primeiro dia do primeiro mês do segundo ano, o Tabernáculo foi montado. ");
INSERT INTO poronbv_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moisés armou o Tabernáculo, colocando as bases em seus lugares, as armações e as travessas e levantou as colunas. ");
INSERT INTO poronbv_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Depois estendeu a tenda sobre o tabernáculo e colocou a cobertura sobre ela, como o Senhor tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Tomou as tábuas da aliança e as colocou na arca. Introduziu as varas nas argolas da arca e colocou sobre ela a tampa. ");
INSERT INTO poronbv_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Em seguida levou a arca para dentro do Tabernáculo e estendeu o véu para cobrir a arca da aliança, como o Senhor tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Depois pôs a mesa no Santuário, no lado norte do Tabernáculo, do lado de fora do véu. ");
INSERT INTO poronbv_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Colocou sobre ela os pães da Presença, diante do Senhor, como o Senhor tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Pôs também o candelabro no Santuário, em frente da mesa, no lado sul do Tabernáculo, ");
INSERT INTO poronbv_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","e acendeu as lâmpadas diante do Senhor, como ele tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Pôs o altar de ouro no santuário, diante do véu, ");
INSERT INTO poronbv_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","e nele queimou o incenso aromático especial, como o Senhor tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Então pendurou a cortina na entrada do Tabernáculo ");
INSERT INTO poronbv_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","e pôs o altar das ofertas queimadas à entrada do Tabernáculo, a Tenda do Encontro, ofereceu sobre ele uma oferta queimada e uma oferta de cereais, como o Senhor tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Pôs a bacia entre a Tenda do Encontro e o altar e encheu-a de água. ");
INSERT INTO poronbv_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Nela, Moisés, Arão e os seus filhos lavavam as mãos e os pés. ");
INSERT INTO poronbv_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Todas as vezes que entravam no Tabernáculo e iam até o altar, eles se lavavam, como o Senhor tinha ordenado. ");
INSERT INTO poronbv_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Então Moisés armou o pátio ao redor do Tabernáculo e do altar e colocou a cortina à entrada do pátio. Assim Moisés acabou a obra. ");
INSERT INTO poronbv_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Então a nuvem cobriu o Tabernáculo e a glória do Senhor o encheu. ");
INSERT INTO poronbv_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moisés não podia entrar no Tabernáculo, porque a nuvem estava sobre ela e a glória do Senhor o enchia. ");
INSERT INTO poronbv_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Sempre que a nuvem se levantava de cima do Tabernáculo, os israelitas seguiam viagem. ");
INSERT INTO poronbv_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Mas, se a nuvem parava, eles também paravam, até o dia em que ela se levantava. ");
INSERT INTO poronbv_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","A nuvem do Senhor repousava sobre o Tabernáculo de dia, e de noite havia fogo sobre ele, diante dos olhos de toda a nação de Israel, em toda a sua peregrinação.");
INSERT INTO poronbv_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","O Senhor chamou Moisés ao Tabernáculo e lhe disse: ");
INSERT INTO poronbv_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Fale o seguinte aos israelitas: Quando alguém de vocês oferecer sacrifício ao Senhor, escolha um animal do seu gado ou do seu rebanho de ovelhas. ");
INSERT INTO poronbv_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Se a oferta queimada for de gado, deverá ser usado um macho sem defeitos físicos. Traga o animal à entrada do Tabernáculo, para que seja aceito pelo Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Aquele que estiver fazendo a oferta colocará a mão sobre a cabeça do animal, para que seja aceito no seu lugar. Ou seja, o animal é sacrificado, sofrendo no lugar do homem o castigo dos seus pecados, e o homem fica livre do castigo desses pecados. ");
INSERT INTO poronbv_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","O homem matará o touro ou novilho diante do Senhor, e os descendentes de Arão — os sacerdotes — apresentarão o sacrifício ao Senhor, borrifando o sangue em todos os lados do altar que está à entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Em seguida, eles deverão tirar a pele do animal e cortá-lo em pedaços. ");
INSERT INTO poronbv_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","E os descendentes do sacerdote Arão acenderão fogo sobre o altar e arrumarão a lenha para o fogo. ");
INSERT INTO poronbv_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Depois colocarão os pedaços junto com a cabeça e a gordura sobre a lenha do fogo do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","As vísceras e as pernas serão lavadas com água e depois queimadas sobre o altar pelo sacerdote. Então será uma oferta queimada, de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Se a oferta for de animal pequeno, quer de carneiro ou de cabrito, terá de ser um macho sem defeito. ");
INSERT INTO poronbv_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","O homem que estiver fazendo a oferta, terá de matar o animal diante do Senhor. Fará isso no lado norte do altar. E os sacerdotes, descendentes de Arão, borrifarão o sangue sobre o altar, em todos os lados. ");
INSERT INTO poronbv_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Depois o homem cortará o animal em pedaços. O sacerdote colocará os pedaços, junto com a cabeça e a gordura, sobre a lenha do fogo do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Mas as vísceras e as pernas terão de ser primeiro lavadas com água. Então o sacerdote queimará tudo sobre o altar, como oferta de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Se a oferta queimada ao Senhor for de aves, poderá ser de rolinhas ou de pombinhas. ");
INSERT INTO poronbv_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","O sacerdote trará a ave ao altar e torcerá o pescoço dela com a mão. Depois queimará tudo sobre o altar e deixará o sangue da ave escorrer pela parede do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Então o sacerdote tirará o papo e as penas, e jogará tudo isso do lado leste do altar, junto com as cinzas. ");
INSERT INTO poronbv_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Em seguida, rasgará a ave pelas asas, mas sem que fique inteiramente partida. E o sacerdote a queimará sobre a lenha acesa do altar. É uma oferta queimada, de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Quando alguém oferecer uma oferta de cereais ao Senhor, deverá trazer farinha da melhor qualidade. Derramará azeite e incenso sobre a farinha ");
INSERT INTO poronbv_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","e a entregará aos descendentes de Arão, os sacerdotes. Um dos sacerdotes apanhará um punhado da farinha, com azeite e incenso, e queimará essa parte diante do Senhor. Esse punhado levado ao fogo representa toda a quantidade do cereal trazido, de modo que o Senhor o receberá como oferta de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","O restante da oferta ficará com Arão e seus descendentes; é considerada a parte mais sagrada das ofertas queimadas ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Se alguém oferecer uma oferta de cereais assada no forno, deve usar farinha da melhor qualidade para fazer bolos sem fermento, assados com azeite, ou pães finos sem fermento, untados com azeite. ");
INSERT INTO poronbv_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Se a oferta de cereais for preparada na assadeira, também deve ser usada farinha da melhor qualidade, sem fermento, amassada com azeite. ");
INSERT INTO poronbv_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Deve ser cortada em pedaços, e sobre os pedaços deve ser derramado azeite. Não tenham dúvidas: é oferta de cereais. ");
INSERT INTO poronbv_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Se a oferta de cereais for preparada numa frigideira, também deve ser feita de farinha da melhor qualidade, misturada com azeite. ");
INSERT INTO poronbv_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Traga ao Senhor a oferta de cereais e entregue-a ao sacerdote, que a levará ao altar. ");
INSERT INTO poronbv_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","O sacerdote queimará sobre o altar uma parte representativa da oferta de cereais; é oferta queimada, de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","O restante da oferta é para uso pessoal de Arão e seus descendentes; é considerada a parte mais sagrada das ofertas queimadas ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Não ponham fermento na farinha das ofertas de cereais. Nas ofertas queimadas ao Senhor é proibido usar fermento e mel. ");
INSERT INTO poronbv_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","A oferta de cereais poderá ser trazida como oferta dos primeiros frutos ao Senhor, mas não poderá ser oferecida sobre o altar como aroma agradável. ");
INSERT INTO poronbv_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Todas as ofertas de cereais devem ser temperadas com sal. Não deixem faltar sal nas suas ofertas de cereais, pois o sal lembra a aliança de Deus com seu povo. Coloquem sal em todas as suas ofertas. ");
INSERT INTO poronbv_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Se você trouxer uma oferta de cereais dos primeiros frutos, apresente-a com grãos verdes tirados das espigas. Os grãos das espigas verdes devem ser esmagados e tostados no fogo. Depois apresente a sua oferta ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Derrame azeite e incenso sobre a oferta, pois é oferta de cereais. ");
INSERT INTO poronbv_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Então o sacerdote queimará parte dos grãos esmagados e misturados com azeite, junto com todo o incenso; é parte representativa da oferta queimada ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Quando alguém quiser dar uma oferta como sacrifício de gratidão ao Senhor, poderá oferecer um novilho ou novilha. Mas o animal deve ser sem defeito. Só assim poderá ser sacrificado como oferta ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","O homem que apresentar a oferta colocará a mão sobre a cabeça do animal. Depois matará o novilho ou novilha junto à porta de entrada do Tabernáculo. Então os descendentes de Arão — os sacerdotes — deverão borrifar o sangue em todos os lados do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Do sacrifício de gratidão apresentará como oferta queimada ao Senhor: a gordura que cobre as vísceras ou está ligada a elas, ");
INSERT INTO poronbv_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","os dois rins com a gordura que os cobre e que fica próximo dos lombos, e o lóbulo do fígado, que ele removerá junto com os rins. ");
INSERT INTO poronbv_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Os descendentes de Arão queimarão tudo isso sobre o altar, como oferta queimada que é colocada sobre a lenha no fogo; é oferta queimada de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Se a oferta para o sacrifício de gratidão for de gado de pequeno porte, poderá ser macho ou fêmea, mas sem defeito. ");
INSERT INTO poronbv_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Se for um cordeiro, ele fará a oferta diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Colocará a mão sobre a cabeça e matará o animal à entrada do Tabernáculo. Os descendentes de Arão borrifarão o sangue em todos os lados do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Então, do sacrifício de gratidão trará ao Senhor como oferta queimada a gordura da cauda, tirada rente à espinha, toda a gordura que cobre as vísceras, ");
INSERT INTO poronbv_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","como também os dois rins com a gordura que os cobre e que fica próximo dos lombos, e o lóbulo do fígado, que ele removerá junto com os rins. ");
INSERT INTO poronbv_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","O sacerdote queimará tudo isso sobre o altar; será oferta de gratidão queimada ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Se a oferta for uma cabra, aquele que apresenta a oferta trará o animal à presença do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Colocará a mão sobre a cabeça do animal e o matará diante do Tabernáculo. Então os descendentes de Arão borrifarão o sangue no altar, por todos os lados, ");
INSERT INTO poronbv_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","e apresentarão como oferta queimada ao Senhor a gordura que cobre as vísceras e a que está ligada a elas, ");
INSERT INTO poronbv_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","os dois rins, a gordura que os cobre e que fica próximo dos lombos, e o lóbulo do fígado que ele removerá junto com os rins. ");
INSERT INTO poronbv_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","O sacerdote queimará tudo sobre o altar. É oferta queimada de aroma agradável. Toda a gordura é do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“Esta é uma lei permanente para todas as famílias de Israel: Os israelitas jamais poderão comer gordura nem sangue”. ");
INSERT INTO poronbv_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Então o Senhor deu mais estas instruções a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Diga ao povo de Israel que estas leis são para os casos em que uma pessoa quebra sem intenção algum dos meus mandamentos: ");
INSERT INTO poronbv_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Se um sacerdote ungido — em pleno exercício das funções sacerdotais — pecar sem intenção, trazendo culpa sobre o povo, deverá oferecer um novilho sem defeito como oferta pelo pecado. ");
INSERT INTO poronbv_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Trará o novilho até a porta do Tabernáculo, colocará a mão sobre a cabeça do animal e o matará diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Então esse sacerdote levará o sangue do novilho para o Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Depois molhará o dedo no sangue e borrifará o sangue sete vezes, diante do Senhor, em frente ao véu que impede a entrada para o Lugar mais Santo. ");
INSERT INTO poronbv_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Então o sacerdote colocará um pouco de sangue nas pontas do altar do incenso aromático, diante do Senhor, no Tabernáculo. O restante do sangue será derramado na base do altar das ofertas queimadas, à entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Depois ele tirará toda a gordura do novilho da oferta pelo pecado — gordura que cobre as vísceras e está ligada a elas, ");
INSERT INTO poronbv_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","os dois rins com a gordura que os cobre e que fica próximo dos lombos, e o lóbulo do fígado, que ele removerá junto com os rins — ");
INSERT INTO poronbv_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","do mesmo jeito que é tirada a gordura de um novilho quando é sacrificado como oferta de gratidão. ");
INSERT INTO poronbv_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Mas o restante do novilho — o couro e toda a sua carne, além da cabeça e das pernas, as vísceras e os intestinos ");
INSERT INTO poronbv_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","— ou seja, o novilho todo, será levado para um lugar cerimonialmente limpo, fora do acampamento, onde são lançadas as cinzas do altar. Ali será queimado o restante do novilho, sobre uma fogueira feita de lenha. ");
INSERT INTO poronbv_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Se toda a comunidade de Israel pecar sem intenção, fazendo alguma coisa contra os mandamentos do Senhor, mesmo que não tenha consciência disso, a comunidade será culpada. ");
INSERT INTO poronbv_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Quando a culpa for exposta, o povo sacrificará um novilho como oferta pelo pecado. E apresentará o animal diante do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Os líderes da comunidade porão as mãos sobre a cabeça do novilho e matarão o animal na presença do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Então o sacerdote em exercício trará o sangue do sacrifício ao Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","No Tabernáculo, o sacerdote molhará o dedo no sangue e o borrifará sete vezes diante do Senhor, em frente ao véu. ");
INSERT INTO poronbv_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Depois ele porá sangue nas pontas do altar, diante do Senhor, no Tabernáculo. Ele derramará o restante do sangue na base do altar das ofertas queimadas, na entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Toda a gordura do novilho será tirada e queimada sobre o altar. ");
INSERT INTO poronbv_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Com esse novilho será feita a mesma coisa que se faz com o novilho da oferta pelo pecado. Assim o sacerdote oferecerá esse sacrifício para obter o perdão dos pecados do povo, e todo o povo será perdoado. ");
INSERT INTO poronbv_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Depois disso, o sacerdote levará o novilho para fora do acampamento. Lá queimará o animal, como no caso do sacrifício do outro novilho para a obtenção do perdão de pecados individuais. Nesse caso é oferta pelo pecado da comunidade. ");
INSERT INTO poronbv_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Se um homem que ocupa uma posição de liderança pecar sem intenção, sendo culpado por desobedecer a um dos mandamentos do Senhor, ");
INSERT INTO poronbv_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","quando alguém o conscientizar do seu pecado, terá de oferecer em sacrifício um bode sem defeito. ");
INSERT INTO poronbv_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ele colocará a mão sobre a cabeça do bode, e o matará no lugar onde são sacrificados os animais para as ofertas queimadas, diante do Senhor. Esta é a oferta pelo pecado pessoal do líder. ");
INSERT INTO poronbv_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Então o sacerdote pegará um pouco do sangue do sacrifício com o dedo e o porá nas pontas do altar das ofertas queimadas. Depois derramará o restante do sangue na base do mesmo altar. ");
INSERT INTO poronbv_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ele queimará toda a gordura no altar, do mesmo modo como queimou a gordura do sacrifício de gratidão. Assim o sacerdote oferecerá o sacrifício para obter o perdão dos seus pecados. E ele será perdoado. ");
INSERT INTO poronbv_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Se qualquer pessoa pertencente à comunidade de Israel pecar sem intenção, contrariando algum mandamento do Senhor, será considerada culpada. ");
INSERT INTO poronbv_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Logo que a conscientizarem do seu pecado, trará uma cabra sem defeito como oferta pelo pecado cometido. ");
INSERT INTO poronbv_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","O culpado colocará a mão sobre a cabeça da cabra e a matará no lugar em que são mortos os animais para as ofertas queimadas. ");
INSERT INTO poronbv_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Então o sacerdote pegará do sangue e com o dedo colocará um pouco nas pontas do altar das ofertas queimadas. Depois derramará o sangue restante na base do mesmo altar. ");
INSERT INTO poronbv_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Tirará toda a gordura, como no caso da oferta de gratidão. Depois o sacerdote queimará a gordura no altar como aroma agradável ao Senhor. Assim o sacerdote oferecerá o sacrifício para obter o perdão de pecados, e a pessoa será perdoada. ");
INSERT INTO poronbv_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Se alguém trouxer uma ovelha como oferta pelo pecado, ela terá de ser sem defeito. ");
INSERT INTO poronbv_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","O culpado trará o animal ao lugar onde são mortos os animais para as ofertas queimadas. Ali colocará a mão sobre a cabeça da ovelha e matará o animal como oferta pelo seu pecado. ");
INSERT INTO poronbv_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","O sacerdote recolherá sangue da oferta pelo pecado, e com o dedo colocará um pouco dele nas pontas do altar das ofertas queimadas. O restante será derramado na base do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","A gordura será usada como no caso do cordeiro sacrificado como oferta de gratidão; será queimada pelo sacerdote no altar como qualquer outra das ofertas queimadas ao Senhor. Deste modo, o sacerdote oferecerá o sacrifício para obter o perdão de pecados daquela pessoa. E ela será perdoada. ");
INSERT INTO poronbv_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Se alguém não quiser depor como testemunha de um fato que sabe que aconteceu ou que viu ser praticado, então será culpado e sofrerá o castigo. ");
INSERT INTO poronbv_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Se alguém tocar em alguma coisa que a lei declara impura, torna-se cerimonialmente impuro e terá de ser julgado culpado. Isso se refere ao cadáver de animal selvagem ou de animal doméstico ou de animal que se arrasta pelo chão. A pessoa será culpada mesmo que tenha tocado no cadáver sem perceber. ");
INSERT INTO poronbv_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“Se alguém tocar em qualquer coisa expelida do corpo humano, coisa cerimonialmente impura, mesmo por descuido, desde o momento em que o perceber será culpado. ");
INSERT INTO poronbv_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Se alguém, sem pensar, jurar fazer uma coisa boa ou má, sem perceber que a promessa foi feita precipitadamente e de modo imprudente, quando o perceber, será culpado. ");
INSERT INTO poronbv_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Em qualquer desses casos citados, a pessoa terá de confessar a culpa ");
INSERT INTO poronbv_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","e, pelo pecado que cometeu, fazer uma oferta ao Senhor. A oferta pode ser de uma ovelha ou de uma cabra. O sacerdote oferecerá o animal em sacrifício para obter o perdão do pecado. ");
INSERT INTO poronbv_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Se o culpado não tiver recursos para oferecer uma ovelha ou uma cabra, pode trazer duas rolinhas ou dois pombinhos, como oferta pela culpa do pecado que cometeu. Uma das aves será trazida como oferta pelo pecado; a outra como oferta queimada. ");
INSERT INTO poronbv_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","O culpado entregará as duas aves ao sacerdote, que oferecerá primeiro uma ave como sacrifício pelo pecado. Ele torcerá o pescoço da ave, sem arrancar a cabeça. ");
INSERT INTO poronbv_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Depois borrifará o sangue da ave na parede do altar e deixará escorrer o restante do sangue nas bases do altar. Essa é a oferta pelo pecado. ");
INSERT INTO poronbv_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","O sacerdote então sacrificará a outra ave, como oferta queimada, segundo as instruções prescritas. Desse modo, o sacerdote oferecerá esse sacrifício para obter o perdão de pecados, e o culpado ficará livre daquela culpa. ");
INSERT INTO poronbv_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Se o culpado não tiver recursos nem para oferecer duas rolinhas ou dois pombinhos, então ele trará como oferta pelo pecado um jarro da farinha da melhor qualidade como oferta pelo pecado. Mas não derramará azeite nem incenso sobre a farinha, pois é oferta pelo pecado. ");
INSERT INTO poronbv_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","O culpado entregará a farinha ao sacerdote, que apanhará um punhado representativo da oferta e queimará essa parte sobre o altar, em cima das ofertas queimadas ao Senhor. Essa oferta é pelo pecado. ");
INSERT INTO poronbv_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Assim o sacerdote oferecerá esse sacrifício para obter o perdão do pecado que aquela pessoa cometeu, e ela será perdoada. O restante da farinha pertence ao sacerdote, como no caso da oferta de cereais”. ");
INSERT INTO poronbv_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","O Senhor continuou falando a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Se alguém pecar profanando e manchando, sem intenção, coisas santas, dedicadas ao Senhor, trará ao Senhor um carneiro sem defeito do rebanho. O valor da oferta deve atender à avaliação em siclos de prata, segundo o siclo usado no Tabernáculo, como oferta pelo pecado que cometeu. ");
INSERT INTO poronbv_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","O culpado restituirá o que foi profanado, ou o que reteve das coisas sagradas, acrescentando um quinto do valor, e o entregará ao sacerdote. O sacerdote pegará o carneiro que é entregue para tirar a culpa e o oferecerá como sacrifício para obter o perdão do pecado, e ele será perdoado. ");
INSERT INTO poronbv_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Todo aquele que desobedecer a alguma Lei do Senhor, mesmo sem perceber que está desobedecendo, é culpado e deverá ser castigado. ");
INSERT INTO poronbv_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Por isso ele terá de trazer do seu rebanho um carneiro sem defeito ao sacerdote, devidamente avaliado de acordo com a tabela de preços usada no Tabernáculo. O carneiro será trazido como oferta pela culpa daquele que pecou. Assim o sacerdote oferecerá o animal como sacrifício para obter o perdão do pecado que a pessoa cometeu sem intenção, e ela será perdoada. ");
INSERT INTO poronbv_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","É oferta pela culpa, porque não há dúvida de que ela tornou-se culpada perante o Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Disse ainda o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Se alguém pecar, cometendo ofensa contra o Senhor, deixando de devolver alguma coisa deixada com ele pelo próximo, como penhor ou garantia de pagamento de empréstimo, ou não quiser devolver o que foi confiado a ele, o que roubou, o que conseguiu explorando o próximo; ");
INSERT INTO poronbv_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ou não quiser devolver uma coisa que achou de outra pessoa, jurando que não achou, ou ainda jurando falsamente a respeito de qualquer coisa em que o homem costuma pecar; ");
INSERT INTO poronbv_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","quando pecar dessa forma, tornando-se culpado, terá de devolver aquilo que roubou ou tomou por meio de extorsão, o que guardou em depósito, ou os bens perdidos que achou. ");
INSERT INTO poronbv_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Terá de devolver tudo aquilo sobre o que tenha jurado falsamente. Além de devolver tudo — sem faltar nada — acrescentará a isso um quinto do valor e dará tudo ao proprietário quando apresentar a sua oferta pela culpa. ");
INSERT INTO poronbv_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Como oferta pela culpa, ele trará um carneiro sem defeito e devidamente avaliado, do seu rebanho, como oferta dedicada ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","O sacerdote receberá o animal e oferecerá ao Senhor, para obter o perdão dos pecados, e aquele que pecou será perdoado e ficará livre da culpa do mal que fez”. ");
INSERT INTO poronbv_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","O Senhor falou mais estas coisas a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Dê a Arão e a seus filhos as seguintes instruções a respeito das ofertas queimadas: a oferta queimada terá de ficar toda a noite sobre as brasas do altar, onde o fogo terá de ser mantido aceso. ");
INSERT INTO poronbv_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","O sacerdote vestirá a sua túnica de linho e os calções de linho por baixo, e tirará a cinza de cima do altar e a colocará ao lado do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Depois trocará de roupa, e levará a cinza para um lugar cerimonialmente limpo, fora do acampamento. ");
INSERT INTO poronbv_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Enquanto isso, o fogo do altar deve ser mantido aceso. Cada manhã o sacerdote colocará lenha no altar, mantendo o fogo aceso. Colocará no altar a oferta queimada e queimará sobre ela a gordura das ofertas de gratidão. ");
INSERT INTO poronbv_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","O fogo do altar deverá ser mantido continuamente aceso; não deve ser apagado. ");
INSERT INTO poronbv_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Estas são as leis a respeito da oferta de cereais: Os filhos de Arão a oferecerão ao Senhor, diante do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Um dos sacerdotes pegará um punhado de farinha da melhor qualidade, misturada com azeite e com todo o incenso que está sobre a oferta de cereais, e queimará no altar esse punhado, como aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Arão e seus descendentes comerão o restante da oferta, mas deverão comê-la sem fermento, em lugar sagrado, no pátio do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Essa oferta não será cozida com fermento; essa parte das ofertas de cereais pertence a eles como porção das ofertas trazidas para mim. É coisa santíssima, semelhante à oferta pelo pecado e à oferta pela culpa. ");
INSERT INTO poronbv_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Somente os homens descendentes de Arão poderão comer essa parte das ofertas. Esta lei é permanente, de geração em geração. Somente eles podem comer das ofertas queimadas ao Senhor. Tudo o que tocar nelas se tornará santo”. ");
INSERT INTO poronbv_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Disse ainda o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Esta é a oferta que Arão e seus filhos oferecerão ao Senhor no dia em que forem ungidos: um jarro de farinha da melhor qualidade, como na oferta de cereais que é feita regularmente; de manhã é apresentada a metade e à tarde a outra metade. ");
INSERT INTO poronbv_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Será preparada com óleo numa assadeira; a mistura deverá ser benfeita, e a massa cortada em pedaços que, depois de bem cozidos, deverão ser apresentados como ofertas de cereais com aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Toda vez que um sacerdote, descendente de Arão, for ungido e introduzido no sacerdócio, preparará essa oferta, que será totalmente queimada. ");
INSERT INTO poronbv_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Esta regra é permanente: a oferta de cereais preparada pelo sacerdote será queimada totalmente ao Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Disse mais o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Diga a Arão e seus filhos que estas são as instruções para a oferta pelo pecado. Esta oferta é muito santa! Por isso o sacrifício desta oferta é realizado no mesmo lugar onde são mortos os animais para as ofertas queimadas ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","O sacerdote que oferecer o animal comerá a oferta no pátio do Tabernáculo. Isso porque precisa ser comida no lugar consagrado ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Tudo o que tocar na carne se tornará santo; se o sangue respingar na roupa de alguém, essa roupa terá de ser lavada ali mesmo, no lugar consagrado ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","A vasilha de barro usada para cozinhar a carne terá de ser quebrada; se a vasilha for de bronze, será lavada; terá de ser esfregada e enxaguada com água. ");
INSERT INTO poronbv_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Somente os homens da família dos sacerdotes poderão comer dessa oferta; é uma oferta muito santa! ");
INSERT INTO poronbv_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Entretanto, toda oferta pelo pecado, em que o sangue do sacrifício é levado ao Lugar Santo do Tabernáculo a fim de obter o perdão de pecados, não será comida; ela será queimada totalmente diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Estas são as leis a respeito da oferta pela culpa. É uma oferta muito santa: ");
INSERT INTO poronbv_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","O animal da oferta pela culpa será morto no lugar onde são mortos os animais para as ofertas queimadas. O sangue dele será borrifado em todos os lados do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Serão oferecidos sobre o altar toda a gordura, a cauda e a gordura que cobre as vísceras, ");
INSERT INTO poronbv_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","os dois rins com a gordura que os cobre que fica próximo dos lombos e o lóbulo do fígado, que ele removerá junto com os rins. ");
INSERT INTO poronbv_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","O sacerdote queimará todas essas partes sobre o altar, como oferta dedicada ao Senhor. É oferta pela culpa. ");
INSERT INTO poronbv_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Todos os homens da família dos sacerdotes poderão comer do animal sacrificado, num lugar sagrado, porque é oferta muito santa. ");
INSERT INTO poronbv_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“A regulamentação da oferta pelo pecado é a mesma da oferta pela culpa. A lei é a mesma para ambas. A carne pertence ao sacerdote encarregado de oferecer o sacrifício para obter o perdão de pecados. ");
INSERT INTO poronbv_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","O sacerdote encarregado de oferecer o animal que vai ser completamente queimado em favor de alguém, ficará com o couro do animal sacrificado. ");
INSERT INTO poronbv_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","O sacerdote que apresentar a oferta de cereais, tanto as ofertas levadas ao forno como as ofertas assadas na assadeira, tem o direito de ficar com elas; ");
INSERT INTO poronbv_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","e todas as ofertas de cereais — as misturadas com azeite ou não — pertencem aos filhos e descendentes de Arão. ");
INSERT INTO poronbv_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Instruções para os sacrifícios feitos ao Senhor como ofertas de paz: ");
INSERT INTO poronbv_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Se for oferta de gratidão, então deve vir acompanhada destas coisas: bolos sem fermento e amassados com óleo, pães finos sem fermento e untados com óleo, e bolos com farinha da melhor qualidade; tudo bem preparado e misturado com azeite. ");
INSERT INTO poronbv_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Além disso, deve ser trazido pão feito com massa fermentada. Assim deve ser feita a oferta de paz com gratidão. ");
INSERT INTO poronbv_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","De cada oferta, será separado um bolo ao Senhor, que será para o sacerdote, que borrifará o sangue da oferta de paz. ");
INSERT INTO poronbv_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Mas a carne do sacrifício dessa oferta voluntária de gratidão tem de ser comida no dia em que for feita a oferta; não poderá sobrar nada para o dia seguinte. ");
INSERT INTO poronbv_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Se alguém trouxer oferta para cumprir um voto, ou se for uma oferta voluntária, a carne do sacrifício será comida no dia em que for apresentada, e o que sobrar poderá ser comido no dia seguinte. ");
INSERT INTO poronbv_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Mas, no terceiro dia, se ainda sobrar carne, ela deverá ser queimada. ");
INSERT INTO poronbv_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Se alguém comer da oferta de paz no terceiro dia, ela não será aceita. Aquele que ofereceu o sacrifício não será aceito pelo Senhor; será como se a pessoa não tivesse apresentado a oferta. Essa carne é impura, e quem dela comer sofrerá as consequências da sua culpa. ");
INSERT INTO poronbv_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Ninguém pode comer carne que encostar em alguma coisa impura perante a lei. Essa carne será queimada. Qualquer pessoa que estiver cerimonialmente limpa poderá comer a carne da oferta de paz. ");
INSERT INTO poronbv_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Mas, se a pessoa, por algum motivo, estiver cerimonialmente impura e comer da carne da oferta de paz que pertence ao Senhor, será cortada do meio do seu povo. ");
INSERT INTO poronbv_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Se alguém encostar em qualquer coisa cerimonialmente impura, seja impureza humana, seja de gado impuro, ou de qualquer réptil, e comer da carne do sacrifício de paz oferecido ao Senhor, será eliminado do meio do seu povo”. ");
INSERT INTO poronbv_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","E disse o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Diga aos israelitas: Não comam gordura alguma de boi, de carneiro ou de cabra. ");
INSERT INTO poronbv_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Quando morrer um animal, seja por morte natural ou porque foi atacado por alguma fera, pode ser usado para qualquer outra finalidade, menos para comer! ");
INSERT INTO poronbv_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Quem comer a gordura de um animal sacrificado ao Senhor como oferta queimada, será eliminado do meio do seu povo. ");
INSERT INTO poronbv_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Em qualquer lugar que vocês morarem, não comam sangue, quer de aves, quer de gado. ");
INSERT INTO poronbv_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Toda pessoa que comer sangue será eliminada do meio do seu povo”. ");
INSERT INTO poronbv_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Disse mais o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Diga aos israelitas: Quando alguém apresentar sacrifício de paz ao Senhor, terá de oferecer parte do sacrifício como oferta especial. ");
INSERT INTO poronbv_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","A pessoa deverá trazer com as próprias mãos as partes das ofertas queimadas ao Senhor; trará a gordura do peito juntamente com o peito, para os movimentos de apresentação da oferta ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","O sacerdote queimará a gordura sobre o altar, mas o peito pertence a Arão e a seus descendentes. ");
INSERT INTO poronbv_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","A parte da coxa direita do animal da oferta de paz será para o sacerdote. ");
INSERT INTO poronbv_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","O sacerdote que oferecer o sangue do sacrifício de paz e a gordura receberá a coxa direita como porção. ");
INSERT INTO poronbv_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","O peito que é movido ritualmente e a coxa da oferta de paz serão dados pelos israelitas ao sacerdote Arão e a seus descendentes, e esta minha ordem é permanente. ");
INSERT INTO poronbv_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","“Essa é a porção das ofertas queimadas ao Senhor, destinada a Arão e aos seus filhos e a seus descendentes, a partir do dia em que foram escolhidos para servir ao Senhor como sacerdotes. ");
INSERT INTO poronbv_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Foi isso que o Senhor ordenou dar a eles, desde o dia em que os separou e os ungiu. Este é um estatuto perpétuo, que os israelitas devem obedecer em todas as gerações”. ");
INSERT INTO poronbv_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Foram essas as instruções a respeito da oferta queimada, da oferta de cereais, da oferta pelo pecado e da oferta pela culpa, da oferta de consagração e das ofertas de paz. ");
INSERT INTO poronbv_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","O Senhor deu essas instruções a Moisés no monte Sinai, para ensinar aos israelitas o modo certo de oferecer sacrifícios ao Senhor no deserto do Sinai. ");
INSERT INTO poronbv_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Disse mais o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Reúna Arão e os filhos dele e junte as roupas deles, o óleo a ser derramado neles, o novilho para ser sacrificado como oferta pelo pecado, os dois carneiros e a cesta de pães sem fermento; ");
INSERT INTO poronbv_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","e convoque toda a comunidade de Israel à entrada do Tabernáculo”. ");
INSERT INTO poronbv_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moisés fez como o Senhor lhe tinha ordenado, e a comunidade reuniu-se à entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Então Moisés disse à comunidade: “O que estou fazendo foi mandado pelo Senhor”; ");
INSERT INTO poronbv_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","e pediu que Arão e seus filhos se aproximassem e os lavou com água. ");
INSERT INTO poronbv_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Depois Moisés vestiu Arão com o manto preso com o cinto, e por cima pôs o colete sacerdotal; depois prendeu a ele o manto sacerdotal com o cinturão bem trabalhado; ");
INSERT INTO poronbv_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","colocou também o peitoral, e nele pôs o Urim e o Tumim; ");
INSERT INTO poronbv_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","colocou o turbante na cabeça de Arão e, na parte de frente do turbante, prendeu uma placa de ouro, ou seja, a coroa sagrada, conforme o Senhor tinha ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Então Moisés pegou o óleo da unção e com ele ungiu o Tabernáculo e tudo o que nele havia. Desse modo foi consagrado o Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Depois derramou óleo sete vezes sobre o altar, ungindo o altar e todos os seus utensílios, como também a bacia e o seu suporte, para consagrá-los. ");
INSERT INTO poronbv_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Em seguida, derramou o óleo da unção sobre a cabeça de Arão para consagrá-lo. ");
INSERT INTO poronbv_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Então Moisés fez os filhos de Arão chegarem à frente, vestiu-os com as vestimentas sacerdotais — os mantos, os cinturões e os turbantes — como o Senhor havia mandado. ");
INSERT INTO poronbv_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Então Moisés trouxe para perto deles um novilho para a oferta pelo pecado. Arão e seus filhos puseram as mãos sobre a cabeça do novilho. ");
INSERT INTO poronbv_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Moisés sacrificou o novilho e, com o dedo, colocou um pouco de sangue em todas as pontas do altar, para purificá-lo. Derramou depois o restante do sangue na base do altar e desse modo o consagrou para pedir perdão pelos seus pecados. ");
INSERT INTO poronbv_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Então Moisés pegou toda a gordura que cobre as vísceras, o lóbulo do fígado e os dois rins com a gordura que os cobre, e queimou-os no altar. ");
INSERT INTO poronbv_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Mas o que sobrou do novilho, incluindo o couro, a carne e os intestinos, ele queimou fora do acampamento, segundo a ordem que havia recebido do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Depois Moisés mandou trazer o carneiro da oferta queimada. Arão e seus filhos puseram as mãos sobre a cabeça do carneiro, ");
INSERT INTO poronbv_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","e Moisés matou o carneiro e borrifou o sangue nos lados do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Depois cortou o carneiro em pedaços e queimou a cabeça, os pedaços e a gordura do animal sacrificado. ");
INSERT INTO poronbv_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Então lavou com água as vísceras e as pernas do carneiro. Em seguida queimou o carneiro inteiro sobre o altar, que é oferta de aroma agradável ao Senhor, como o Senhor havia mandado. ");
INSERT INTO poronbv_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Então Moisés mandou trazer outro carneiro, o carneiro da consagração. Arão e seus filhos puseram as mãos sobre a cabeça do segundo carneiro, ");
INSERT INTO poronbv_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","e Moisés sacrificou o carneiro. Depois molhou com o sangue a ponta da orelha direita de Arão, o polegar da mão direita e o polegar do pé direito. ");
INSERT INTO poronbv_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Moisés também fez a mesma coisa com os filhos de Arão: com o sangue do carneiro molhou a orelha direita, o polegar da mão direita e o polegar do pé direito. Depois Moisés derramou o restante do sangue em todos os lados do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Em seguida, pegou a gordura, a cauda, toda a gordura que cobre as vísceras, o lóbulo do fígado, os dois rins e a gordura que os cobre e a coxa direita. ");
INSERT INTO poronbv_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Também pegou a cesta de pães sem fermento, que estava diante do Senhor; tirou dela um bolo sem fermento, uma forma de pão feito com azeite e um pão fino, e colocou-os sobre a gordura e sobre a coxa direita. ");
INSERT INTO poronbv_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Colocou todas essas coisas nas mãos de Arão e dos seus filhos e fez delas oferta movida ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Depois Moisés pegou tudo aquilo das mãos deles e queimou no altar, em cima da oferta queimada ao Senhor. Essa foi a oferta de consagração, oferta queimada, de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moisés pegou o peito e fez os movimentos apropriados de apresentação ao Senhor. Essa parte do carneiro da consagração pertencia a Moisés, como o Senhor lhe havia ordenado. ");
INSERT INTO poronbv_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moisés pegou também o óleo da unção e o sangue que estava sobre o altar, e os borrifou sobre Arão e suas roupas, como também sobre os filhos de Arão e as suas roupas. ");
INSERT INTO poronbv_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Então Moisés disse a Arão e aos seus filhos: “Cozinhem a carne do sacrifício na entrada do Tabernáculo. Comam ali a carne e o pão que está na cesta dos pães da consagração. Façam exatamente como ordenei a vocês, dizendo: ‘Arão e seus filhos a comerão’. ");
INSERT INTO poronbv_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Depois queimem o restante da carne e do pão. ");
INSERT INTO poronbv_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Não saiam da entrada do Tabernáculo durante sete dias, até que se completem os dias da consagração de vocês, pois o Senhor consagrará vocês por sete dias. ");
INSERT INTO poronbv_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","O que se fez hoje foi ordenado pelo Senhor a fim de obter o perdão dos pecados de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Vocês permanecerão, pois, à entrada do Tabernáculo dia e noite, por sete dias, e observarão as prescrições do Senhor, para que não morram; pois assim me foi ordenado”. ");
INSERT INTO poronbv_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Dessa forma, Arão e os seus filhos fizeram tudo o que o Senhor tinha ordenado por meio de Moisés. ");
INSERT INTO poronbv_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ao oitavo dia da cerimônia de consagração, Moisés convocou Arão, os filhos dele e as autoridades de Israel. ");
INSERT INTO poronbv_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","E disse a Arão: “Traga um bezerro para a oferta pelo pecado e um carneiro para a oferta queimada, ambos sem defeito, e apresente-os ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","E diga aos israelitas: Escolham um bode para a oferta pelo pecado; um bezerro e um cordeiro, ambos de um ano de idade e sem defeito, para a oferta queimada; ");
INSERT INTO poronbv_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","um boi e um carneiro para a oferta de gratidão, em sacrifício realizado diante do Senhor; ou ainda uma oferta de cereais, preparada com azeite; porque hoje o Senhor aparecerá a vocês”. ");
INSERT INTO poronbv_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Assim trouxeram todas estas coisas à entrada do Tabernáculo, como Moisés tinha ordenado, e a comunidade inteira colocou-se diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Disse Moisés a todos: “Sigam as ordens do Senhor, e a sua glória aparecerá a vocês”. ");
INSERT INTO poronbv_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Então Moisés disse a Arão: “Venha até o altar e ofereça a sua oferta pelo pecado e a sua oferta queimada, para Deus perdoar os seus próprios pecados, e depois as ofertas pelo povo, conforme o Senhor havia mandado”. ");
INSERT INTO poronbv_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Arão foi até o altar e matou o bezerro em sacrifício pelos seus próprios pecados. ");
INSERT INTO poronbv_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Os filhos de Arão levaram-lhe o sangue, e ele molhou o dedo no sangue e o pôs nas pontas do altar. Depois derramou o restante do sangue na base do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Então ele queimou no altar a gordura, os rins e o lóbulo do fígado da oferta pelo pecado, conforme o Senhor havia ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Depois disso, ele queimou a carne e o couro fora do acampamento. ");
INSERT INTO poronbv_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Feito tudo isso, Arão matou o animal da oferta queimada. Os seus filhos levaram-lhe o sangue, que ele borrifou em todos os lados do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Também entregaram a Arão o animal cortado em pedaços. Entregaram-lhe pedaço por pedaço, inclusive a cabeça, e ele queimou todas as partes no altar. ");
INSERT INTO poronbv_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Depois ele lavou as vísceras e as pernas do animal, oferecendo-as como oferta queimada no altar. ");
INSERT INTO poronbv_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Em seguida fez o sacrifício da oferta pelo povo. Matou o bode da oferta pelo pecado do povo, e o ofereceu como sacrifício pelo pecado, como fizera com a oferta pelo seu próprio pecado. ");
INSERT INTO poronbv_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Assim Arão apresentou a oferta queimada ao Senhor, de acordo com as instruções rituais. ");
INSERT INTO poronbv_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Então chegou a vez da oferta de cereais. Arão pegou um punhado dela e a queimou no altar, além da oferta queimada, apresentada costumeiramente pela manhã. ");
INSERT INTO poronbv_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Depois ele matou o boi e o carneiro como sacrifício da oferta de paz pelo povo. Seus filhos trouxeram-lhe o sangue, e ele borrifou o sangue por todo o altar. ");
INSERT INTO poronbv_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Tomaram também as porções de gordura do boi e do carneiro, a cauda, a gordura que cobre as vísceras, os rins e o lóbulo do fígado, ");
INSERT INTO poronbv_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","e colocaram sobre o peito dos animais; e Arão queimou tudo no altar. ");
INSERT INTO poronbv_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Em seguida, Arão moveu o peito e a coxa direita ao Senhor, com os movimentos e gestos de apresentação apropriados, como Moisés havia ordenado. ");
INSERT INTO poronbv_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Depois Arão levantou as mãos em direção ao povo e o abençoou. E, tendo oferecido o sacrifício pelo pecado, a oferta queimada e a oferta de gratidão, desceu da plataforma do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Assim Moisés e Arão entraram juntos no Tabernáculo e, quando saíram, abençoaram o povo; e a glória do Senhor apareceu a toda a comunidade de Israel. ");
INSERT INTO poronbv_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Então saiu fogo da presença do Senhor e consumiu a oferta queimada e as porções de gordura sobre o altar. Quando o povo viu isso, gritou de alegria e prostrou-se com o rosto no chão. ");
INSERT INTO poronbv_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadabe e Abiú, filhos de Arão, pegaram cada um o seu incensário, puseram neles fogo, acrescentaram incenso, e trouxeram fogo profano perante o Senhor. Eles fizeram algo que contrariava as ordens que o Senhor havia acabado de dar! ");
INSERT INTO poronbv_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Então saiu fogo da presença do Senhor e os consumiu; morreram perante o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Então Moisés disse a Arão: “Foi isto que o Senhor disse: “Mostrarei a minha santidade para aqueles que chegam perto de mim, e serei glorificado diante de todo o povo!” Porém, Arão ficou em silêncio. ");
INSERT INTO poronbv_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Então Moisés chamou Misael e Elzafã, primos de Arão, filhos de Uziel, e disse aos dois: “Venham até aqui, e levem seus primos da frente do Tabernáculo para fora do acampamento”. ");
INSERT INTO poronbv_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Eles se aproximaram e usaram os seus mantos para levá-los para fora do acampamento, conforme Moisés havia ordenado. ");
INSERT INTO poronbv_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Então Moisés disse a Arão e aos seus filhos Eleazar e Itamar: “Não lamentem a morte deles. Não desarrumem os cabelos, nem rasguem suas roupas como sinal de luto, senão vocês também morrerão, e o Senhor ficará irado com todo o povo de Israel. Mas os seus parentes e toda a nação de Israel poderão chorar a morte deles e lamentar o terrível fogo do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Não saiam da entrada do Tabernáculo, para que não morram. Lembrem que foi derramado sobre vocês o óleo da unção do Senhor”. E eles fizeram conforme Moisés havia ordenado. ");
INSERT INTO poronbv_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Depois o Senhor deu as seguintes instruções a Arão: ");
INSERT INTO poronbv_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Você e seus filhos não devem beber vinho nem qualquer outra bebida forte antes de entrar no Tabernáculo, senão vocês morrerão. E esta lei vale também para os seus descendentes, de geração em geração. ");
INSERT INTO poronbv_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Vocês têm a obrigação de fazer separação entre o santo e o profano, entre o impuro e o puro. ");
INSERT INTO poronbv_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Vocês têm a responsabilidade de ensinar ao povo de Israel todas as leis dadas pelo Senhor por meio de Moisés”. ");
INSERT INTO poronbv_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Então Moisés disse a Arão e aos filhos que ficaram vivos, Eleazar e Itamar: “Comam a oferta de cereais, que sobrou das ofertas queimadas ao Senhor. Comam essa oferta sem fermento junto ao altar, pois é coisa muito sagrada. ");
INSERT INTO poronbv_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Comam os pães num lugar sagrado, pois é a parte das ofertas queimadas ao Senhor que cabe a você e a seus filhos. Essa foi a ordem que recebi do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Quanto ao peito apresentado ao Senhor com movimentos rituais apropriados e à coxa da oferta, você, seus filhos e as suas filhas poderão comer num lugar cerimonialmente limpo. Essas partes dos sacrifícios foram dadas a você e a seus filhos como parte das ofertas de paz dos israelitas. ");
INSERT INTO poronbv_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","A coxa ofertada e o peito apresentado com movimentos rituais apropriados devem ser trazidos junto com as porções de gordura das ofertas preparadas no fogo. Essas partes serão apresentadas ao Senhor, com os movimentos rituais apropriados diante do Senhor. Depois pertencerão a você e aos seus descendentes. Esse direito é permanente, conforme o Senhor havia ordenado”. ");
INSERT INTO poronbv_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Quando Moisés procurou por toda parte o bode da oferta pelo pecado, e soube que já havia sido queimado, irou-se contra Eleazar e Itamar, filhos de Arão que ficaram vivos, e perguntou: ");
INSERT INTO poronbv_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Por que vocês não comeram a carne da oferta pelo pecado no Lugar Santo? É uma oferta muito sagrada! E o Senhor a deu a vocês para levar a maldade do povo, e para obter o perdão dos pecados deles diante do Senhor! ");
INSERT INTO poronbv_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","O sangue desta oferta não foi trazido para dentro do Lugar Santo, e era ali que vocês deviam comer as partes pertencentes a vocês, conforme as ordens que receberam de mim”. ");
INSERT INTO poronbv_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Mas Arão respondeu a Moisés: “Hoje eles ofereceram o sacrifício pelo pecado deles e a oferta queimada diante do Senhor. Você viu o que aconteceu! Será que teria agradado ao Senhor se eu tivesse comido a oferta pelo pecado num dia como hoje?” ");
INSERT INTO poronbv_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","E Moisés aceitou a explicação. ");
INSERT INTO poronbv_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Disse o Senhor a Moisés e a Arão: ");
INSERT INTO poronbv_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Digam ao povo de Israel: De todos os animais que vivem na terra, estes são os animais cuja carne vocês podem comer: ");
INSERT INTO poronbv_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","todo animal que tem os cascos fendidos divididos em duas unhas, e que rumina. ");
INSERT INTO poronbv_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“Vocês não poderão comer os seguintes animais que só ruminam ou que só têm unhas fendidas: o camelo, que rumina, mas não tem unhas fendidas; considerem-no impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","O coelho, embora rumine, não tem unhas fendidas; portanto, é impuro para vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","A lebre, embora, rumine, também não tem unhas fendidas; considerem-na impura. ");
INSERT INTO poronbv_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","E o porco, embora tenha casco fendido e dividido em dois, não rumina; também considerem-no impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Vocês não devem comer a carne nem encostar no cadáver desses animais. Considerem-nos impuros. ");
INSERT INTO poronbv_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","De todos os animais que vivem nas águas, vocês poderão comer os seguintes: todos os que têm barbatana e escamas, tanto nos mares como nos rios. ");
INSERT INTO poronbv_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Mas todos os outros seres aquáticos que não têm barbatanas nem escamas, tanto nos mares quanto nos rios, todas as pequenas criaturas que povoam as águas serão abomináveis para vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Não comam a sua carne e considerem impuros os seus cadáveres. ");
INSERT INTO poronbv_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Toda criatura que vive na água e não tem barbatanas ou escamas será proibida para vocês comerem. ");
INSERT INTO poronbv_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“As aves que vocês devem considerar impuras e não podem comer são estas: a águia, o urubu, a águia-marinha, ");
INSERT INTO poronbv_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","o milhano, o falcão, ");
INSERT INTO poronbv_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","toda espécie de corvo, ");
INSERT INTO poronbv_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","o avestruz, a coruja, a gaivota, toda espécie de gavião, ");
INSERT INTO poronbv_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","o mocho, a coruja-marinha e a íbis, ");
INSERT INTO poronbv_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","a gralha, o pelicano, o abutre, ");
INSERT INTO poronbv_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","a cegonha, todo tipo de garça, a poupa e o morcego. ");
INSERT INTO poronbv_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Vocês não podem comer os insetos voadores, de quatro pernas; ");
INSERT INTO poronbv_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","mas vocês poderão comer os insetos saltadores, que andam sobre quatro pés e que têm as pernas traseiras mais compridas do que as pernas dianteiras. ");
INSERT INTO poronbv_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Desses vocês poderão comer os seguintes: toda variedade de locusta, toda variedade de gafanhoto devorador e toda variedade de grilo. ");
INSERT INTO poronbv_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Mas considerem impuros todos os outros insetos que voam e que têm quatro pés. ");
INSERT INTO poronbv_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Por meio deles vocês se tornarão impuros; qualquer pessoa que tocar em seus cadáveres se tornará impura até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Quem carregar os cadáveres deles terá de lavar as suas roupas e ficará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“Todo animal que tem as unhas fendidas, mas o casco não dividido em dois, e não rumina é considerado impuro; quem tocar em um desses animais se tornará impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Todos os animais quadrúpedes, que andam sobre a planta dos pés, são impuros para vocês; todo aquele que tocar nos seus cadáveres ficará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Quem carregar os cadáveres deles terá de lavar as roupas e ficará impuro até a tarde. Esses animais são impuros para vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Dos animais que se movem rente ao chão e que enchem a terra, serão considerados impuros para vocês: a doninha, o rato, toda espécie de lagarto, ");
INSERT INTO poronbv_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","o geco, a toupeira, a lagartixa, o lagarto da areia e o camaleão. ");
INSERT INTO poronbv_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Essas criaturas são impuras para vocês. Quem nelas tocar depois de mortas estará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","E, se o cadáver de qualquer um desses animais cair em cima de alguma coisa, essa coisa se tornará impura, seja objeto de madeira, de tecido, de couro ou de pano de saco. O objeto atingido deverá ser posto na água, e estará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","E se o corpo de um desses animais cair numa vasilha de barro, tudo o que estiver na vasilha se tornará impuro, e a vasilha terá de ser quebrada. ");
INSERT INTO poronbv_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Qualquer alimento sobre o qual cair essa água ficará impuro, e qualquer líquido que estiver dentro da vasilha se tornará impuro também. ");
INSERT INTO poronbv_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Se o corpo de um desses animais cair sobre alguma coisa, se for um forno ou um fogão de barro, terá de ser quebrado. Será considerado impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Mas se cair numa fonte ou num poço em que se recolhe água, ela permanece limpa; mas quem tocar no cadáver se tornará impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Se um desses cadáveres cair sobre alguma semente a ser semeada, essa semente não ficará contaminada; ");
INSERT INTO poronbv_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","mas se alguém derramar água sobre a semente, e o cadáver cair na água, então a semente se tornará impura. ");
INSERT INTO poronbv_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Quando morrer algum dos animais que vocês podem comer, e alguém tocar nesse cadáver, se tornará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Quem comer da carne desse animal morto terá de lavar as roupas que estiver usando, e se tornará impuro até a tarde. Quem carregar o cadáver desse animal terá de lavar suas roupas, e se tornará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Vocês não deverão comer qualquer criatura de todas as que rastejam na terra. Elas são consideradas imundas. ");
INSERT INTO poronbv_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Tudo o que se move rente ao chão ou sobre o ventre, ou anda sobre quatros pernas, ou tem muitos pés, não comam. São todas criaturas impuras segundo a Lei. ");
INSERT INTO poronbv_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Não se contaminem com nenhuma dessas criaturas. Não se tornem impuros. ");
INSERT INTO poronbv_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Eu sou o Senhor, o Deus de vocês. Portanto, consagrem-se e sejam santos, porque eu sou santo. Não se tornem impuros com nenhum desses animais que rastejam na terra. ");
INSERT INTO poronbv_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Lembrem! Eu sou o Senhor que os tirou da terra do Egito para ser o seu Deus. Sejam santos, porque eu sou santo. ");
INSERT INTO poronbv_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“São estas as leis referentes aos animais, às aves e a todos os seres vivos das águas e todo animal que rasteja na terra. ");
INSERT INTO poronbv_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Elas mostram a diferença entre os que são puros e os impuros, entre os animais que podem ser comidos e os que não podem ser comidos”. ");
INSERT INTO poronbv_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Disse o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Fale aos filhos de Israel: Quando uma mulher engravidar e der à luz um menino, ficará impura durante sete dias. Ela estará debaixo das mesmas exigências que a Lei faz das mulheres no seu período menstrual. ");
INSERT INTO poronbv_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","No oitavo dia depois do nascimento, o menino terá de ser circuncidado. ");
INSERT INTO poronbv_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Depois disso, a mãe aguardará trinta e três dias para ser purificada por causa da perda de sangue. Nesse período ela não poderá tocar em nenhuma coisa sagrada e não poderá ir ao Tabernáculo, até que se cumpram os dias da sua purificação. ");
INSERT INTO poronbv_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Se der à luz uma menina, ficará impura por duas semanas, como acontece durante o seu período menstrual. Depois ficará ainda sessenta e seis dias em processo de purificação por causa da perda de sangue. ");
INSERT INTO poronbv_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Terminando o prazo da purificação, quer pelo nascimento de um filho ou de uma filha, a mãe trará um cordeiro de um ano de idade e um pombinho ou uma rolinha. O cordeiro é para a oferta queimada; e a ave para a oferta pelo pecado. Essas ofertas deverão ser trazidas ao sacerdote, à entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","O sacerdote apresentará as ofertas ao Senhor, a fim de obter perdão pelos pecados da mulher, e ela ficará purificada da perda de sangue causada pelo nascimento da criança. ");
INSERT INTO poronbv_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Mas se ela não tiver recursos para oferecer um cordeiro, poderá trazer dois pombinhos ou duas rolinhas; uma ave para a oferta queimada e a outra para a oferta pelo pecado. Assim, o sacerdote fará a oferta para obter o perdão dos pecados, e ela ficará pura”. ");
INSERT INTO poronbv_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Disse o Senhor a Moisés e a Arão: ");
INSERT INTO poronbv_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Quando alguém tiver um inchaço na pele, uma erupção ou mancha brilhante que possa indicar que seja lepra, será levado ao sacerdote Arão, ou a um dos seus filhos, para ser examinado. ");
INSERT INTO poronbv_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","O sacerdote examinará bem a parte da pele. Se os pelos daquele lugar do inchaço ficarem brancos e se a mancha parecer mais funda do que a pele normal, é sinal de lepra. Depois de examiná-lo, o sacerdote o declarará impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Mas se a mancha branca não parecer mais funda do que a pele sadia, e os pelos dali não estiverem brancos, então o sacerdote o isolará por sete dias. ");
INSERT INTO poronbv_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Passados os sete dias, o sacerdote examinará a mancha. Se ele verificar que a doença na pele não se alterou nem se espalhou, então o manterá isolado por mais sete dias. ");
INSERT INTO poronbv_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ao sétimo dia, o sacerdote fará novo exame. Se a parte afetada diminuiu, perdendo o brilho, e não se alastrou, o sacerdote o declarará puro. Não é lepra; é apenas uma mancha comum ou uma erupção. Basta que essa pessoa lave as roupas que estiver usando, e será considerada limpa. ");
INSERT INTO poronbv_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mas, se depois de se apresentar ao sacerdote para ser declarada pura, a mancha se espalhar na pele, o sacerdote fará novo exame. ");
INSERT INTO poronbv_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Se a mancha se espalhou pela pele, ele a declarará impura; é lepra. ");
INSERT INTO poronbv_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Quando alguém apresentar sinal de lepra, será levado ao sacerdote. ");
INSERT INTO poronbv_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Este o examinará, e se houver algum inchaço branco na pele, se os pelos no inchaço estiverem brancos, e se houver uma ferida aberta no inchaço, ");
INSERT INTO poronbv_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","então é um caso crônico de lepra, e o sacerdote o declarará impuro. Nesse caso ele não precisará ficar isolado para verificação, porque já está claro que ele está impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Se o sacerdote vê que a lepra tomou conta do corpo todo da pessoa, da cabeça aos pés, cobrindo a pele toda da pessoa, até onde é possível ao sacerdote verificar, ");
INSERT INTO poronbv_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","será feito um novo exame. Se, de fato, a lepra cobriu todo o corpo, então tornou-se lepra branca e a pessoa se tornou pura. Isto é mesma coisa que estar curado. Por isso o sacerdote declarará a pessoa curada e cerimonialmente pura. ");
INSERT INTO poronbv_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mas no dia em que aparecer uma ferida aberta, a pessoa estará impura. ");
INSERT INTO poronbv_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Ao ver isso, o sacerdote declarará a pessoa impura. Uma ferida aberta é sinal de lepra. ");
INSERT INTO poronbv_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Mas se a ferida aberta retroceder e a pele se tornar branca, o leproso voltará ao sacerdote, ");
INSERT INTO poronbv_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","que o examinará outra vez. Se ele verificar que a lepra ficou inteiramente branca, então aquela pessoa está pura, e o sacerdote a declarará pura. ");
INSERT INTO poronbv_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Quando alguém tiver uma ferida purulenta em sua pele e ela sarar, ");
INSERT INTO poronbv_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","mas no lugar dela aparecer um inchaço branco ou uma mancha levemente avermelhada, deve se apresentar ao sacerdote. ");
INSERT INTO poronbv_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","O sacerdote examinará a mancha e, se parecer mais profunda do que a pele, e os pelos embranquecerem, o sacerdote o declarará impuro. É sinal de lepra que brotou da ferida. ");
INSERT INTO poronbv_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Mas se o sacerdote vir que os pelos na mancha não estão brancos e que o local não está mais profundo do que a pele, e menos brilhante, então o sacerdote o colocará em isolamento por sete dias. ");
INSERT INTO poronbv_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Se a mancha se alastrar pela pele, o sacerdote o declarará impuro. É sinal de lepra. ");
INSERT INTO poronbv_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Mas, se a mancha brilhante parar de crescer e não se alastrar, é apenas cicatriz que a ferida purulenta deixou, e o sacerdote o declarará puro. ");
INSERT INTO poronbv_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“No caso de pele queimada pelo fogo, e a carne viva da queimadura se tornar mancha brilhante avermelhada ou branca, ");
INSERT INTO poronbv_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","o sacerdote examinará a mancha. Se os pelos estiverem brancos e a mancha parecer mais funda do que a pele, é lepra que surgiu da queimadura. O sacerdote o declarará impuro; é sinal de lepra na pele. ");
INSERT INTO poronbv_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Mas, se o sacerdote examinar a mancha e perceber que os pelos não estão brancos e que a mancha não está brilhante, e não estiver mais profunda do que a pele, então ele isolará a pessoa por sete dias. ");
INSERT INTO poronbv_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Depois desse prazo, o sacerdote examinará de novo a mancha. Se ela tiver se espalhado pela pele, é lepra. O sacerdote a declarará impura. ");
INSERT INTO poronbv_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Mas, se a mancha brilhante não avançou nem se espalhou pela pele, tendo também perdido o seu brilho, então foi apenas um inchaço provocado pela queimadura. O sacerdote declarará a pessoa pura; é apenas a cicatriz da queimadura. ");
INSERT INTO poronbv_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Se um homem ou uma mulher tiver uma ferida na cabeça ou no queixo, ");
INSERT INTO poronbv_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","deverá ser examinado pelo sacerdote. Se a ferida parecer mais funda do que a pele, e os cabelos do local forem amarelados e finos, o sacerdote declarará a pessoa impura; é sarna, ou seja, lepra da cabeça ou do queixo. ");
INSERT INTO poronbv_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Mas se o exame feito pelo sacerdote mostrar que é apenas uma mancha superficial da pele, e não houver pelo escuro na parte enferma, então o sacerdote colocará a pessoa infectada em isolamento por sete dias. ");
INSERT INTO poronbv_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","No sétimo dia o sacerdote examinará o local afetado. Se a sarna não tiver se espalhado e não houver pelo amarelado nela e não parecer mais funda do que a pele, ");
INSERT INTO poronbv_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","então a pessoa rapará os pelos, exceto a parte afetada, e o sacerdote a isolará por mais sete dias. ");
INSERT INTO poronbv_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","No fim dos outros sete dias, o sacerdote voltará a examinar a doença. Se ela não tiver se alastrado e não parecer mais funda do que a pele, o sacerdote declarará a pessoa pura, bastando que ela lave as roupas que estiver usando, e estará pura. ");
INSERT INTO poronbv_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Mas, se depois de todo esse processo de purificação a doença se alastrar pela pele, depois que a pessoa for declarada pura, ");
INSERT INTO poronbv_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","o sacerdote fará novo exame. Ficando confirmado o alastramento da doença, o sacerdote nem precisa verificar se os cabelos no local da infecção estão amarelados; a pessoa é considerada impura. ");
INSERT INTO poronbv_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Por outro lado, se o sacerdote achar que a doença não avançou, e que nasceram cabelos sadios no local enfermo, é sinal de que a lepra sarou. A pessoa está pura, e o sacerdote a declarará pura. ");
INSERT INTO poronbv_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Se um homem ou uma mulher tiverem manchas brilhantes na pele, ");
INSERT INTO poronbv_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","o sacerdote examinará as manchas; se ele verificar que aparecem manchas brancas mas sem brilho, não é nada grave. A pessoa é considerada pura. ");
INSERT INTO poronbv_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Se caírem os cabelos de um homem, isso não significa que ele seja leproso. Ele está apenas ficando calvo, porém puro. ");
INSERT INTO poronbv_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Se caírem os cabelos apenas da parte da frente da cabeça, ele está meio-calvo, porém puro. ");
INSERT INTO poronbv_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mas, se tiver uma ferida avermelhada na parte calva ou na meia-calva, é lepra. ");
INSERT INTO poronbv_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","O sacerdote o examinará, e se a ferida inchada na sua calva ou na meia-calva for avermelhada como as que aparecem na pele, ");
INSERT INTO poronbv_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","o homem é leproso, e está impuro. O sacerdote que verificar isso o declarará impuro por causa da ferida na cabeça. ");
INSERT INTO poronbv_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Uma pessoa que ficar leprosa deverá vestir roupas rasgadas, andar com os cabelos despenteados, cobrir o rosto da boca para baixo e gritar: ‘Impuro! Impuro!’ ");
INSERT INTO poronbv_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Enquanto tiver a doença, será considerada impura. Viverá sozinha, fora do acampamento. ");
INSERT INTO poronbv_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Quando aparecer uma mancha de lepra em alguma peça de roupa, seja de lã ou de linho, ");
INSERT INTO poronbv_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ou em qualquer peça tecida ou entrelaçada de linho ou de lã, ou em uma peça feita de couro, ");
INSERT INTO poronbv_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","se a mancha for esverdeada ou avermelhada na roupa, ou no couro, ou na peça tecida ou entrelaçada, ou em qualquer coisa feita de couro, é lepra, e a pessoa deverá se apresentar ao sacerdote. ");
INSERT INTO poronbv_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","O sacerdote examinará a mancha e manterá isolado por sete dias o objeto afetado. ");
INSERT INTO poronbv_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","No sétimo dia o sacerdote examinará de novo a mancha e, se ela tiver se espalhado pela roupa, ou pela peça tecida ou entrelaçada, ou pelo pedaço de couro, não importa o seu uso, é lepra contagiosa; o objeto é impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","A roupa será queimada, seja peça tecida ou entrelaçada, seja de lã ou de linho, ou qualquer objeto de couro que tiver mancha, pois é lepra contagiosa; a roupa deverá ser destruída pelo fogo. ");
INSERT INTO poronbv_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Mas se o sacerdote vir que a mancha não se alastrou pela roupa, ou pela peça tecida ou entrelaçada, ou pelo objeto de couro, ");
INSERT INTO poronbv_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","o sacerdote dará ordem para que o objeto seja lavado e colocado em isolamento por sete dias. ");
INSERT INTO poronbv_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Depois o sacerdote examinará o objeto novamente, e se a mancha não se alastrou, mas não tiver alterado sua cor, o objeto é impuro. O objeto contaminado deverá ser queimado. É lepra corrosiva, esteja na parte de frente ou na parte de trás do objeto. ");
INSERT INTO poronbv_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Mas se o sacerdote vir que a mancha perdeu a cor e o brilho, depois de ter sido lavada a peça, então ele cortará aquela parte da roupa, ou do pedaço de couro, ou da peça tecida ou entrelaçada. ");
INSERT INTO poronbv_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Mas, se a mancha ainda aparecer na roupa, na peça tecida ou entrelaçada, ou em qualquer objeto feito de couro, e se alastrar, é lepra. Essa peça terá de ser queimada. ");
INSERT INTO poronbv_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Mas, se a mancha desaparecer da roupa, ou da peça tecida ou entrelaçada, ou do objeto feito de couro, esse objeto afetado será lavado pela segunda vez e poderá ser usado de novo”. ");
INSERT INTO poronbv_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","São estes os regulamentos a respeito da lepra nas roupas de lã e de linho, ou nas peças tecidas ou entrelaçadas, ou nos objetos feitos de couro, a fim de que sejam considerados puros ou impuros. ");
INSERT INTO poronbv_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Disse o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Esta é a regulamentação para os casos de um leproso purificado: Ele será levado ao sacerdote, ");
INSERT INTO poronbv_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","e este sairá do acampamento para examinar a pessoa. Se a pessoa estiver curada da lepra, ");
INSERT INTO poronbv_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","então o sacerdote ordenará que sejam trazidos duas aves vivas e puras, e um pedaço de madeira de cedro, um pano tingido de vermelho-carmesim e um ramo de hissopo. ");
INSERT INTO poronbv_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ele mandará matar uma das aves e que seja posta numa vasilha de barro sobre água corrente. ");
INSERT INTO poronbv_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","O sacerdote tomará a outra ave, o pedaço de madeira de cedro, o pano tingido de vermelho-carmesim e o hissopo e os molhará com o sangue da ave sacrificada em água corrente. ");
INSERT INTO poronbv_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Então ele borrifará sete vezes aquela pessoa que está sendo purificada da lepra. Só depois disso, o sacerdote a declarará pura. Em seguida, soltará a ave viva, para que viva livremente em campo aberto. ");
INSERT INTO poronbv_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Para completar a purificação, a pessoa que está sendo purificada lavará as suas roupas, rapará todos os seus pelos e tomará banho; e assim estará pura. Depois disso, poderá entrar no acampamento, mas terá de ficar fora da entrada da sua tenda por sete dias. ");
INSERT INTO poronbv_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","No sétimo dia, rapará todos os seus pelos: o cabelo, a barba, as sobrancelhas e o restante dos seus pelos, lavará suas roupas e banhará o corpo com água e então será considerada pura. ");
INSERT INTO poronbv_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“No oitavo dia pegará dois cordeiros sem defeito, uma cordeira de um ano de idade, e três jarros de farinha da melhor qualidade preparada com azeite, como oferta de cereais, e uma caneca de azeite. ");
INSERT INTO poronbv_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","O sacerdote encarregado de fazer a purificação apresentará ao Senhor a pessoa e as ofertas que trouxe, na entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Então o sacerdote pegará um dos cordeiros e o sacrificará como oferta pela culpa, além da caneca com azeite; ele os moverá diante do Senhor com o gesto de apresentação apropriado. ");
INSERT INTO poronbv_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Então matará o cordeiro no lugar em que se costuma matar os animais das ofertas pelo pecado e das ofertas queimadas, no Lugar Santo; porque a oferta pela culpa como a oferta pelo pecado pertencem ao sacerdote; é oferta muito sagrada. ");
INSERT INTO poronbv_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","O sacerdote usará o sangue da oferta pela culpa para colocar um pouco na orelha direita daquele que será purificado, no polegar da sua mão direita e no polegar do seu pé direito. ");
INSERT INTO poronbv_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Depois o sacerdote pegará a caneca com azeite e o derramará na palma da sua mão esquerda; ");
INSERT INTO poronbv_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","molhará o dedo direito no azeite que está na palma da mão esquerda, e daquele azeite borrifará com o dedo sete vezes diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Da sobra do azeite que está na mão esquerda, o sacerdote colocará um pouco na ponta da orelha direita, no polegar da mão direita e no polegar do pé esquerdo daquele que está sendo purificado, como tinha feito com o sangue da oferta pela culpa. ");
INSERT INTO poronbv_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","O restante do azeite que está em sua mão, o sacerdote derramará sobre a cabeça daquele que está sendo purificado. Assim, na presença do Senhor, o sacerdote obterá o perdão dos pecados daquela pessoa. ");
INSERT INTO poronbv_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Então o sacerdote apresentará a oferta pelo pecado, obtendo com isso o perdão dos pecados da pessoa que está sendo purificada da sua impureza. Feito isso, o sacerdote matará o animal dado para a oferta queimada ");
INSERT INTO poronbv_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","e o oferecerá com a oferta de cereais sobre o altar; assim, o sacerdote obterá o perdão dos pecados para aquela pessoa, que, finalmente, será declarada pura. ");
INSERT INTO poronbv_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Se a pessoa for pobre, não tendo recursos para isso, poderá trazer somente um cordeiro para a oferta pela culpa, para ser apresentado ao Senhor com os movimentos apropriados feitos pelo sacerdote para obter o perdão dos pecados. Além do cordeiro, a pessoa trará um jarro de farinha da melhor qualidade, preparada com azeite, para a oferta de cereais, e uma caneca de azeite. ");
INSERT INTO poronbv_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Deverá trazer também duas rolinhas ou dois pombinhos, conforme os seus recursos, e usar um deles como oferta pelo pecado e o outro como oferta queimada. ");
INSERT INTO poronbv_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","No oitavo dia, essas coisas serão trazidas ao sacerdote à entrada do Tabernáculo, para a sua purificação diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","O sacerdote deverá pegar o cordeiro da oferta pela culpa e a caneca com o azeite em separado, e os moverá perante o Senhor com os gestos de apresentação apropriados. ");
INSERT INTO poronbv_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Depois matará o cordeiro e pegará um pouco de sangue e o colocará na ponta da orelha direita, no polegar da mão direita e no polegar do pé direito daquele que está sendo purificado. ");
INSERT INTO poronbv_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","O sacerdote derramará azeite na palma da sua mão esquerda, ");
INSERT INTO poronbv_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","e com o dedo direito borrifará um pouco do azeite da palma da sua mão esquerda sete vezes diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Depois colocará um pouco de azeite da palma da sua mão na ponta da orelha direita, no polegar da mão direita e no polegar do pé esquerdo daquele que está sendo purificado, como tinha feito com o sangue da oferta pela culpa. ");
INSERT INTO poronbv_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","O azeite restante na mão do sacerdote será derramado na cabeça daquele que está sendo purificado, para obter perdão pelos pecados, diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Depois oferecerá uma das rolinhas ou dos pombinhos, conforme os seus recursos. ");
INSERT INTO poronbv_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Uma das aves é para a oferta pelo pecado; a outra como oferta queimada — para ser sacrificada junto com a oferta de cereais. Assim o sacerdote obterá o perdão dos pecados diante do Senhor daquele que está sendo purificado”. ");
INSERT INTO poronbv_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","São estas, pois, as leis para a purificação das pessoas que têm lepra e que não têm os recursos devidos para fazer a oferta da sua purificação. ");
INSERT INTO poronbv_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Disse ainda o Senhor a Moisés e a Arão: ");
INSERT INTO poronbv_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Quando vocês entrarem na terra de Canaã — terra que darei a vocês — e eu puser uma mancha de lepra numa casa, na terra que lhes pertence, ");
INSERT INTO poronbv_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","o dono da casa comunicará o fato ao sacerdote, dizendo: ‘Parece que há uma mancha de lepra em minha casa’. ");
INSERT INTO poronbv_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","O sacerdote mandará que desocupem a casa, antes de examinar a lepra, para que nada que houver na casa se torne impuro. Depois disso, o sacerdote irá até lá e examinará a casa. ");
INSERT INTO poronbv_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ele examinará as manchas nas paredes e, se elas estiverem esverdeadas ou avermelhadas e parecerem mais profundas do que a superfície da parede, ");
INSERT INTO poronbv_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","o sacerdote sairá e trancará a casa, ficando interditada por sete dias. ");
INSERT INTO poronbv_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Sete dias depois, o sacerdote fará novo exame. Se as manchas se alastraram nas paredes da casa, ");
INSERT INTO poronbv_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ordenará que as pedras contaminadas pelas manchas sejam arrancadas e lançadas fora da cidade, num lugar declarado impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Além disso, fará que a casa inteira seja raspada por dentro e que o reboco raspado seja jogado fora da cidade, num lugar impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Serão colocadas outras pedras no lugar das que foram arrancadas, e a casa será rebocada com novo reboco. ");
INSERT INTO poronbv_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Se as manchas tornarem a alastrar-se pela casa, depois de terem arrancado as pedras e a casa ter sido raspada e rebocada, ");
INSERT INTO poronbv_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","será examinada outra vez pelo sacerdote. Se as manchas se alastraram pela casa, é lepra contagiosa; a casa será impura. ");
INSERT INTO poronbv_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Essa casa será então totalmente demolida: as pedras, as madeiras e todo o reboco da casa; tudo será levado para fora da cidade, para um lugar impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Quem entrar na casa enquanto ela estiver interditada ficará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Quem se deitar ou comer naquela casa terá de lavar a roupa usada na ocasião. ");
INSERT INTO poronbv_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Mas, se o sacerdote for examiná-la e as manchas não se alastraram nas paredes reformadas, ele declarará pura a casa porque as manchas desapareceram. ");
INSERT INTO poronbv_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Para completar a purificação da casa, pegará duas aves, um pedaço de madeira de cedro, um pano vermelho e hissopo. ");
INSERT INTO poronbv_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Depois matará uma das aves numa vasilha de barro em água corrente. ");
INSERT INTO poronbv_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Em seguida pegará o pedaço de madeira de cedro, o hissopo, o pano vermelho e a ave viva, e os molhará no sangue da ave morta e na água, e borrifará o sangue sete vezes na casa. ");
INSERT INTO poronbv_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ele purificará a casa com o sangue da ave, com a água corrente, com a ave viva, com o pedaço de madeira de cedro, com o hissopo e com o pano vermelho. ");
INSERT INTO poronbv_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Então o sacerdote soltará a ave fora da cidade, para que viva livremente nos campos. Assim fará a cerimônia da purificação da casa, e ela ficará pura”. ");
INSERT INTO poronbv_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","São essas as leis acerca dos vários tipos de lepra, de sarna, ");
INSERT INTO poronbv_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","de manchas nas roupas ou numa casa, ");
INSERT INTO poronbv_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ou de inchaço, feridas ou tumores e manchas brilhantes na pele. ");
INSERT INTO poronbv_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Assim deve-se fazer quando alguma coisa é pura ou impura. São essas as leis a respeito de qualquer tipo de lepra. ");
INSERT INTO poronbv_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","O Senhor disse a Moisés e a Arão: ");
INSERT INTO poronbv_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Deem as seguintes instruções ao povo de Israel: Quando um homem tiver um corrimento, ficará impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ele ficará impuro por causa do seu corrimento, quer continue vazando o corrimento do membro, quer cesse o corrimento dele. ");
INSERT INTO poronbv_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Qualquer cama em que um homem com corrimento se deitar ficará impura, e todos os lugares em que se assentar ficarão impuros. ");
INSERT INTO poronbv_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Quem tocar na cama dele terá de lavar as suas roupas e tomar banho, e ficará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Quem se sentar sobre qualquer coisa na qual esse homem se sentou terá de lavar as suas roupas e tomar banho, e estará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“Quem tocar no corpo do homem que tiver um corrimento terá de lavar as suas roupas e tomar banho, e ficará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“Se o homem que tem o corrimento cuspir em alguém que está puro, esta pessoa também terá de lavar as suas roupas e tomar banho e ficará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Também qualquer sela em que o homem montar se tornará impura, ");
INSERT INTO poronbv_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","e todo aquele que tocar em alguma coisa que esteve debaixo dele ficará impuro até a tarde; se alguém pegar naquilo em que o homem sentou, terá de lavar as suas roupas e tomar banho, e ficará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“Se o homem que tem o corrimento tocar numa pessoa sem primeiro ter lavado as mãos, então aquela pessoa deverá lavar as suas roupas e tomar banho, e ficará impura até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“Se esse homem pegar numa vasilha de barro, ela deverá ser quebrada; se tocar numa vasilha de madeira, basta que seja lavada. ");
INSERT INTO poronbv_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Quando cessar o corrimento de um homem, iniciará o processo de purificação que durará sete dias. Para isso ele terá de lavar as suas roupas e tomar banho em água corrente, e então ficará puro. ");
INSERT INTO poronbv_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","No oitavo dia, deverá trazer duas rolinhas ou dois pombinhos ao sacerdote, à entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","O sacerdote sacrificará uma ave como oferta pelo pecado e a outra como oferta queimada. Assim o sacerdote fará a cerimônia de purificação perante o Senhor em favor do homem, por causa do corrimento. ");
INSERT INTO poronbv_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Sempre que um homem expelir líquido seminal, terá de banhar o seu corpo com água, e ficará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Toda roupa ou peça de couro em que cair o líquido seminal terá de ser lavada com água e ficará impura até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","“Quando um homem tiver relações sexuais com uma mulher e lhe sair o líquido seminal, ambos terão de banhar-se com água, e estarão impuros até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Quando uma mulher estiver no seu período de menstruação, ficará impura durante sete dias. Nesse período, quem nela tocar ficará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“Todos os objetos e todos os lugares em que ela sentar ou deitar durante o período de menstruação ficarão impuros também. ");
INSERT INTO poronbv_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Quem tocar na cama dela terá de lavar a sua roupa e tomar banho, e ficará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Quem tocar em alguma coisa sobre a qual ela esteve sentada, terá de lavar as suas roupas e tomar banho, e estará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Também quem tocar em alguma coisa que estiver sobre a cama ou sobre aquilo em que ela esteve sentada ficará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“Se um homem tiver relação sexual com ela durante o período de menstruação ficará impuro sete dias; e tornará impura toda cama em que se deitar. ");
INSERT INTO poronbv_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Quando uma mulher continuar menstruada além do tempo normal, ela ficará impura enquanto durar a menstruação. ");
INSERT INTO poronbv_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Qualquer cama em que ela se deitar enquanto continuar a sua hemorragia estará impura, como ocorre com a sua cama durante a sua menstruação; assim também tudo sobre o que ela sentar será impuro, como durante o período de menstruação. ");
INSERT INTO poronbv_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","E quem tocar na cama ou naquilo em que ela sentou ficará impuro e terá de lavar as suas roupas e tomar banho, e ficará impuro até a tarde. ");
INSERT INTO poronbv_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“Sete dias depois de parar a hemorragia, a mulher estará pura. ");
INSERT INTO poronbv_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","No oitavo dia, trará duas rolinhas e dois pombinhos ao sacerdote, à entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","O sacerdote sacrificará uma das aves como oferta pelo pecado, e a outra como oferta queimada, e assim o sacerdote fará a cerimônia da purificação por ela, na presença do Senhor, por causa daquela impureza. ");
INSERT INTO poronbv_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Deste modo vocês cuidarão de manter isoladas as coisas e pessoas impuras dos israelitas, para que não morram por contaminar com sua impureza o meu Tabernáculo que está entre eles”. ");
INSERT INTO poronbv_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Essas são as leis a respeito do homem que tem corrimento ou perda do líquido seminal, tornando-o impuro, ");
INSERT INTO poronbv_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","também da mulher em sua menstruação, do homem e da mulher que têm corrimento e do homem que tiver relação sexual com uma mulher que está impura. ");
INSERT INTO poronbv_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Depois que morreram os dois filhos de Arão, porque se apresentaram ao Senhor de maneira indevida, o Senhor falou com Moisés. ");
INSERT INTO poronbv_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Ele disse: “Diga a seu irmão Arão que não entre a qualquer hora, sem necessidade, no Lugar Santíssimo, atrás do véu, diante da tampa da arca, para que não morra; porque eu mesmo aparecerei ali na nuvem, acima da tampa. ");
INSERT INTO poronbv_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Arão só poderá entrar no Lugar Santíssimo depois de trazer um novilho como oferta pelo pecado e um carneiro como oferta queimada. ");
INSERT INTO poronbv_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ele vestirá o manto sagrado de linho, com os calções de linho por baixo; colocará o cinto de linho na cintura e também o turbante de linho. Só vestirá essa roupa sagrada depois de banhar-se com água. ");
INSERT INTO poronbv_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Ele receberá da comunidade de Israel dois bodes como oferta pelo pecado e um carneiro como oferta queimada. ");
INSERT INTO poronbv_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Primeiro Arão sacrificará ao Senhor um novilho como oferta pelo seu próprio pecado, para obter perdão dos seus pecados e da sua família. ");
INSERT INTO poronbv_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Depois trará os dois bodes à presença do Senhor, à entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ali fará o sorteio para decidir em relação aos dois bodes: qual deverá ser oferecido ao Senhor e qual será designado para Azazel. ");
INSERT INTO poronbv_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","O bode sorteado que pertence ao Senhor será sacrificado por Arão, como oferta pelo pecado. ");
INSERT INTO poronbv_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","O outro bode, conhecido como bode emissário, será apresentado vivo ao Senhor para obter o perdão dos pecados do povo, e depois será mandado embora para o deserto, levando com ele o pecado do povo. ");
INSERT INTO poronbv_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Arão sacrificará o novilho da oferta pelo pecado para obter o perdão dos seus próprios pecados e da sua família. ");
INSERT INTO poronbv_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Em seguida, pegará diante do Senhor o incensário cheio de brasas de fogo e dois punhados de incenso aromático bem moído, e os levará para trás do véu. ");
INSERT INTO poronbv_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ali, diante do Senhor, ele colocará o incenso sobre as brasas de fogo, de modo que a nuvem de fumaça formada pelo incenso cubra a tampa que está acima da Arca que contém as tábuas da aliança, para que não morra. ");
INSERT INTO poronbv_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ele pegará um pouco do sangue do novilho e com o dedo borrifará a parte dianteira superior da tampa. Depois, borrifará o sangue sete vezes, diante da tampa. ");
INSERT INTO poronbv_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Então sairá para matar o bode da oferta pelo pecado, em favor do povo. Tendo sacrificado o animal, entrará de novo, levando o sangue para trás do véu. Ele fará com esse sangue o que fez com o sangue do novilho; ele o borrifará sobre a tampa e na frente dela. ");
INSERT INTO poronbv_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Assim, Arão purificará o Lugar Santíssimo, as impurezas dos israelitas e as transgressões deles. Ele fará propiciação para purificar o Tabernáculo, que está no meio de um povo impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ninguém ficará dentro do Tabernáculo enquanto Arão estiver no Lugar Santíssimo fazendo a cerimônia da purificação para cobrir os pecados do povo. Isto só poderá ocorrer depois que ele obteve o perdão dos seus próprios pecados, dos pecados da sua família e dos pecados do povo de Israel. ");
INSERT INTO poronbv_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Então sairá e irá ao altar que está diante do Senhor. Ali fará a cerimônia da purificação do altar. Para isso pegará um pouco do sangue do novilho e do sangue do bode e borrifará as pontas do altar. ");
INSERT INTO poronbv_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Com o dedo borrifará o sangue sete vezes sobre o altar. Assim o altar estará purificado dos pecados dos filhos de Israel. E o altar será santo depois disso. ");
INSERT INTO poronbv_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Quando Arão terminar de fazer a cerimônia da purificação do Lugar Santíssimo, do Tabernáculo e do altar, trará o bode vivo. ");
INSERT INTO poronbv_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Ele colocará as duas mãos sobre a cabeça do bode vivo, e nessa posição confessará as maldades, rebeldias e todos os pecados do povo de Israel; dessa forma, os colocará sobre a cabeça do bode. Em seguida, enviará o bode ao deserto aos cuidados de um homem encarregado desse serviço. ");
INSERT INTO poronbv_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Assim o bode levará embora todos os pecados do povo para uma terra solitária. E o homem soltará o bode no deserto. ");
INSERT INTO poronbv_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Em seguida, Arão voltará para dentro do Tabernáculo. Ali tirará e deixará as roupas de linho que usou para entrar no Lugar Santíssimo. ");
INSERT INTO poronbv_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ele tomará um banho num lugar sagrado e vestirá as suas roupas. Então sairá para oferecer sacrifício queimado por si mesmo e outro pelo povo, para obter o perdão pelos seus próprios pecados e pelos pecados do povo de Israel. ");
INSERT INTO poronbv_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Também queimará a gordura da oferta pelo pecado no altar. ");
INSERT INTO poronbv_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","O homem que levou o bode emissário ao deserto terá de lavar em água sua roupa e o corpo, e depois poderá entrar no acampamento. ");
INSERT INTO poronbv_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","O novilho e o bode sacrificado como oferta pelo pecado, cujo sangue foi trazido ao Lugar Santíssimo para a cerimônia da purificação, serão levados para fora do acampamento. O couro, a carne e os intestinos serão queimados. ");
INSERT INTO poronbv_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","A pessoa encarregada de queimar os restos dos animais sacrificados terá de lavar a roupa e tomar banho, antes de voltar para o acampamento. ");
INSERT INTO poronbv_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“O seguinte decreto terá de ser obedecido para sempre: No décimo dia do sétimo mês vocês jejuarão. Ninguém trabalhará nesse dia — nem os israelitas, nem os estrangeiros que moram no meio do povo; ou seja, cada um fará um exame de consciência, exame sério com um espírito humilde. ");
INSERT INTO poronbv_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Porque naquele dia será realizado um sacrifício para obter o perdão dos pecados para purificá-los. Então, perante o Senhor, vocês estarão puros de todos os seus pecados. ");
INSERT INTO poronbv_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Portanto, este é o sábado de descanso solene, quando vocês se humilharão. Esta lei é permanente! ");
INSERT INTO poronbv_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Nas gerações futuras, esta cerimônia será dirigida por aquele que for ungido e ordenado sumo sacerdote, no lugar de seu pai. Ele fará a cerimônia da purificação; colocará as roupas sagradas de linho ");
INSERT INTO poronbv_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","e fará a cerimônia da purificação pelo Lugar Santíssimo, pelo Tabernáculo e pelo altar, pelos sacerdotes e por todo o povo. ");
INSERT INTO poronbv_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Esta lei vale para sempre para vocês. Será realizada a cerimônia da purificação, uma vez por ano, para cobrir os pecados do povo de Israel”. Arão seguiu todas as instruções ordenadas pelo Senhor a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Disse o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Transmita mais estas ordens a Arão, aos filhos dele e a todo o povo de Israel: ");
INSERT INTO poronbv_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Qualquer israelita que sacrificar um boi, um cordeiro ou uma cabra dentro ou fora do acampamento, ");
INSERT INTO poronbv_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","e não o trouxer à porta do Tabernáculo para oferecê-lo como sacrifício ao Senhor, diante do Tabernáculo do Senhor, será considerado culpado por derramar sangue. Por esse motivo essa pessoa será eliminada do meio do seu povo. ");
INSERT INTO poronbv_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","A finalidade dessa lei é que os israelitas não ofereçam sacrifícios por conta própria em campo aberto. Eles deverão levá-los ao sacerdote, à entrada do Tabernáculo. Ali serão oferecidos como ofertas de gratidão. ");
INSERT INTO poronbv_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","O sacerdote borrifará o sangue sobre o altar do Senhor, à entrada do Tabernáculo, e queimará a gordura como aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ficam, pois, terminantemente proibidos os sacrifícios oferecidos aos demônios no campo, aos quais prestam culto idólatra. Esta ordem é para ser obedecida para sempre, por todas as gerações. ");
INSERT INTO poronbv_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Diga a eles: Todo israelita ou estrangeiro que vive no meio do povo de Israel que oferecer ao Senhor as suas ofertas que serão completamente queimadas ou qualquer outro sacrifício, ");
INSERT INTO poronbv_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","e não as trouxer à entrada do Tabernáculo para oferecê-las ao Senhor, será expulso do meio do povo. ");
INSERT INTO poronbv_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Também estarei contra todo israelita ou estrangeiro que vive no meio do povo de Israel que comer sangue de qualquer animal, e o eliminarei do meio do seu povo. ");
INSERT INTO poronbv_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Porque a vida da carne está no sangue. Por isso mesmo, eu dei o sangue para ser derramado no altar, a fim de obter o perdão dos pecados do povo. Pois é o sangue, ou seja, a vida, que tira os pecados. ");
INSERT INTO poronbv_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Por esta razão, ordeno aos israelitas e aos estrangeiros que vivem no meio do povo: Nenhum de vocês poderá comer sangue. ");
INSERT INTO poronbv_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Quando um israelita ou um estrangeiro que vive no meio do povo caçar um animal ou uma ave que se pode comer, deverá derramar o sangue na terra e depois cobri-lo com terra, ");
INSERT INTO poronbv_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","porque a vida de todo ser vivente está no seu sangue. Por isso, mandei os israelitas não comerem o sangue de nenhum animal, pois o sangue é a vida. Quem comer sangue será expulso do povo. ");
INSERT INTO poronbv_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Todo homem, quer israelita, quer estrangeiro, que comer carne de animal que sofreu morte natural, ou que foi destroçado por alguma fera, deverá lavar a sua roupa e tomar banho, e ficará impuro até a tarde. Depois ficará puro novamente. ");
INSERT INTO poronbv_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Mas, se não lavar a sua roupa nem se banhar, sofrerá as consequências do seu pecado”. ");
INSERT INTO poronbv_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Disse mais o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Fale aos israelitas e diga-lhes: Eu sou o Senhor, o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Por isso, não imitem o povo do Egito, onde vocês moraram, nem o povo de Canaã, para onde estou levando vocês. Não sigam as suas práticas. ");
INSERT INTO poronbv_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Pelo contrário, obedeçam às minhas leis e minhas ordenanças e sigam-nas. Eu sou o Senhor, o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Obedeçam fielmente às minhas leis e aos meus mandamentos e vocês viverão. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Ninguém deverá aproximar-se de uma parenta próxima para ter relações sexuais com ela. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“Não tenha relações sexuais com o seu pai, nem com a sua mãe. Ela é a sua mãe; não tenha relações sexuais com ela. ");
INSERT INTO poronbv_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“Não tenha relações sexuais com a mulher do seu pai; isso desonraria o seu pai. ");
INSERT INTO poronbv_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“Não tenha relações sexuais com a sua irmã, seja por parte de pai e de mãe ou somente por parte de pai; seja nascida na mesma casa ou em outro lugar. ");
INSERT INTO poronbv_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“Não tenha relações sexuais com a filha do seu filho ou da sua filha; isso desonraria você. ");
INSERT INTO poronbv_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“Não tenha relações sexuais com a filha somente por parte de pai; ela é sua irmã. ");
INSERT INTO poronbv_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“Não tenha relações sexuais com a irmã de seu pai; ela é parenta próxima de seu pai. ");
INSERT INTO poronbv_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“Não tenha relações sexuais com a irmã de sua mãe; ela é parenta próxima de sua mãe. ");
INSERT INTO poronbv_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“Não tenha relações sexuais com a mulher do seu tio por parte de pai; ela é sua tia. ");
INSERT INTO poronbv_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“Não tenha relações sexuais com a sua nora, mulher do seu filho. ");
INSERT INTO poronbv_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“Também não tenha relações sexuais com a mulher do seu irmão; isso desonraria seu irmão. ");
INSERT INTO poronbv_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“Não tenha relação sexual com uma mulher e sua filha. Não tenha relações sexuais com a filha do seu filho ou com a filha da sua filha; elas são parentas próximas. Isso seria uma perversidade. ");
INSERT INTO poronbv_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“Não case com duas irmãs, tendo relações sexuais com elas; isso as tornaria rivais. ");
INSERT INTO poronbv_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Não tenha relações sexuais com a mulher quando está no seu período de menstruação. ");
INSERT INTO poronbv_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“Não tenha relações sexuais com a mulher de outro homem, para que você não fique impuro. ");
INSERT INTO poronbv_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Não entregue nenhum dos seus filhos para ser sacrificado a Moloque. Não profane o nome do seu Deus. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Nenhum homem deverá ter relações sexuais com outro homem como se fosse mulher. Isso é repugnante. ");
INSERT INTO poronbv_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“Nenhum homem ou mulher terá relações sexuais com qualquer animal, contaminando-se com ele. Isto é uma terrível perversão! ");
INSERT INTO poronbv_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Israelitas, não se contaminem com nenhuma dessas coisas, porque as nações que vou expulsar da presença de vocês são as que se contaminam com essas coisas. ");
INSERT INTO poronbv_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Estes territórios estão contaminados por essas práticas perversas. Por isto estou castigando seus habitantes, e eu os vomitarei da terra que vai ser de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Vocês terão de obedecer rigorosamente a todas as minhas leis e regulamentos. Nem o natural da terra nem o estrangeiro que mora no meio de vocês praticará qualquer uma dessas abominações, ");
INSERT INTO poronbv_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","pois todas essas abominações foram praticadas pelos homens que habitaram essa terra antes de vocês; por isso a terra ficou contaminada! ");
INSERT INTO poronbv_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Cuidado para que vocês não tornem a terra impura, senão ela os vomitará, como vomitou o povo que nela habitava antes de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“Todo aquele que fizer alguma dessas abominações será eliminado do meio do seu povo. ");
INSERT INTO poronbv_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Portanto, obedeçam às minhas leis. Que ninguém caia no erro de praticar aqueles costumes repugnantes que eram praticados antes de vocês. Não se tornem impuros. Eu sou o Senhor, o Deus de vocês”. ");
INSERT INTO poronbv_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Disse mais o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Diga o seguinte a toda a comunidade de Israel: Sejam santos porque eu, o Senhor, o Deus de vocês, sou santo. ");
INSERT INTO poronbv_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“Cada um respeite a sua mãe e o seu pai, e guarde os meus sábados. Eu sou o Senhor, o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Não se voltem para os ídolos, nem façam deuses de metal para vocês. Eu sou o Senhor, o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Quando vocês oferecerem sacrifício de gratidão ao Senhor, ofereçam-no de tal maneira que eu o aceite. ");
INSERT INTO poronbv_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Comam das ofertas no dia em que forem apresentadas ao Senhor. O que sobrar poderá ser comido no dia seguinte; mas as sobras do terceiro dia terão de ser queimadas. ");
INSERT INTO poronbv_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Se alguma coisa do sacrifício for comida no terceiro dia, é abominação e não será aceito. ");
INSERT INTO poronbv_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Se alguém comer da oferta no terceiro dia, será culpado e sofrerá as consequências da sua transgressão, porque profanou o que é santo ao Senhor; por isso, será eliminado do meio do seu povo. ");
INSERT INTO poronbv_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Quando você fizer a colheita da sua terra, deixe de colher nos cantos dos terrenos cultivados, e não ajunte as espigas que caírem da sua colheita. ");
INSERT INTO poronbv_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Não faça a segunda colheita da sua vinha, nem apanhe as uvas que caírem no chão. Elas são para o necessitado e para o estrangeiro. Eu sou o Senhor, o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Não roube. “Não minta. “Não engane os outros. ");
INSERT INTO poronbv_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“Não jure falsamente pelo meu nome, profanando dessa maneira o nome do seu Deus. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Não explore o seu próximo, nem roube dele. “Não fique até o dia seguinte com o salário de um trabalhador pago por dia de trabalho. ");
INSERT INTO poronbv_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“Não amaldiçoe o surdo nem faça tropeçar o cego, mas tema o seu Deus. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Quando julgar alguma causa, não cometa injustiça; não favoreça o pobre, nem procure agradar os poderosos. Seja justo para com o seu próximo. ");
INSERT INTO poronbv_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“Não fique falando mal de todo mundo. “Não faça acusações falsas. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Não guarde ódio no seu coração contra o seu irmão, mas repreenda-o com franqueza, para que, por causa dele, você não cometa um pecado. ");
INSERT INTO poronbv_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“Não procure a vingança, nem guarde rancor contra alguém do seu povo. Ame o seu próximo como a si mesmo. Eu sou o Senhor! ");
INSERT INTO poronbv_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Obedeça às minhas leis. “Não cruze animais de espécies diferentes. “Não semeie sementes de duas espécies diferentes nas suas terras. “Não use roupa feita com vários tipos de tecido. ");
INSERT INTO poronbv_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Se um homem tiver relações sexuais com uma escrava, noiva de outro homem, que não tenha sido resgatada, nem colocada em liberdade, ambos serão castigados, mas não serão mortos, porque ela não é livre, é escrava. ");
INSERT INTO poronbv_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Mas o homem que pecou terá de trazer um carneiro como oferta ao Senhor pela culpa à entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","O sacerdote oferecerá o carneiro da oferta pela culpa a Deus e assim obterá o perdão dos pecados perante o Senhor; assim, o pecado que ele cometeu será perdoado. ");
INSERT INTO poronbv_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Quando vocês entrarem na Terra Prometida e plantarem árvores frutíferas de toda espécie, não comam do fruto delas nos três primeiros anos de produção. As frutas produzidas dentro desse prazo são impuras. ");
INSERT INTO poronbv_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","A produção do quarto ano será dedicada ao Senhor; será uma oferta de louvor ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Somente no quinto ano vocês poderão comer as frutas dessas árvores. Farei aumentar a sua produção. Eu sou o Senhor, o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Não comam coisa alguma com sangue. “Não pratiquem adivinhação nem feitiçaria. ");
INSERT INTO poronbv_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“Não façam o corte arredondado do cabelo, nem aparem as pontas da barba. ");
INSERT INTO poronbv_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“Não façam cortes no corpo por causa dos mortos, nem marca alguma no corpo. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Não desonre a sua filha, entregando-a à prostituição, para que a terra não se contamine, nem se encha de maldade. ");
INSERT INTO poronbv_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“Guardem os meus sábados e reverenciem o meu Tabernáculo. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Não se tornem impuros procurando os que consultam os mortos, nem os que procuram adivinhar o futuro, pois vocês serão contaminados por eles. Eu sou o Senhor, o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Levantem-se na presença de pessoas idosas, e deem a devida honra aos anciãos; temam o seu Deus. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Não explorem os estrangeiros que vivem na terra de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Eles devem ser tratados como se fossem naturais do povo de Israel. Amem os estrangeiros como a vocês mesmos. Lembrem-se que vocês também foram estrangeiros na terra do Egito. Eu sou o Senhor, o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Não julguem de maneira desonesta, usando medidas falsas de comprimento, peso ou quantidade. ");
INSERT INTO poronbv_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Usem balanças justas, pesos e medidas exatas, tanto para cereais quanto para líquidos. Eu sou o Senhor, o Deus de vocês, que tirei vocês da terra do Egito. ");
INSERT INTO poronbv_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“Obedeçam rigorosamente às minhas leis e mandamentos e pratiquem-nos. Eu sou o Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Disse o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Diga aos israelitas: Qualquer israelita ou estrangeiro que vive no meio do meu povo que sacrificar um dos seus filhos a Moloque terá de ser morto. Será apedrejado pelos líderes do povo. ");
INSERT INTO poronbv_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Eu mesmo me voltarei contra aquele homem e farei que seja eliminado do meio do seu povo; pois deu o seu filho a Moloque. Com isso ele contaminou o meu Tabernáculo, profanando o meu santo nome. ");
INSERT INTO poronbv_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Se os líderes do povo deliberadamente fecharem os olhos quando um homem entregar um dos seus filhos a Moloque e deixar que continue vivendo, ");
INSERT INTO poronbv_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","eu mesmo me voltarei contra ele e contra a sua família, e eliminarei aquele homem e todos os que me deixaram e seguiram Moloque. ");
INSERT INTO poronbv_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Voltarei o meu rosto contra quem consultar necromantes e contra aquele que consultar adivinhos para segui-los. Eu o eliminarei do meio do seu povo. ");
INSERT INTO poronbv_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“Portanto, consagrem as suas vidas e sejam santos, porque eu sou o Senhor, o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Obedeçam a todos os mandamentos e pratiquem-nos. Eu sou o Senhor que os santifica. ");
INSERT INTO poronbv_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Se alguém amaldiçoar seu pai ou sua mãe será condenado à morte. Essa pessoa é responsável pela sua própria morte, pois amaldiçoou o pai ou a mãe. ");
INSERT INTO poronbv_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Se um homem cometer adultério com a mulher do seu próximo, o adúltero e a adúltera serão mortos. ");
INSERT INTO poronbv_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“Se um homem tiver relações sexuais com a mulher de seu pai, estará desonrando o seu próprio pai. Os dois adúlteros — o homem e a mulher do seu pai — serão mortos. ");
INSERT INTO poronbv_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“Se um homem tiver relações sexuais com a sua nora, ambos terão de ser mortos. Cometeram depravação; eles são responsáveis pela sua própria morte. ");
INSERT INTO poronbv_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“Se um homem tiver relações sexuais com outro homem como quem se deita com uma mulher, ambos terão de ser mortos por causa do ato imoral; eles são responsáveis pela sua própria morte. ");
INSERT INTO poronbv_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“Se um homem tiver relações sexuais com uma mulher e com a mãe dela, comete um ato perverso. O homem e as duas mulheres terão de morrer queimados, para acabar com essa maldade entre vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“Se um homem tiver relações sexuais com um animal, os dois serão mortos. ");
INSERT INTO poronbv_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“Se uma mulher tiver relações sexuais com algum animal, ambos serão mortos; eles são responsáveis pela sua própria morte. ");
INSERT INTO poronbv_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Se um homem tomar por mulher sua irmã, filha de seu pai ou de sua mãe, e tiver relações sexuais com ela, pratica uma coisa muito vergonhosa. Eles serão eliminados na presença do povo de Israel. Esse homem desonrou sua irmã e sofrerá o castigo da sua maldade. ");
INSERT INTO poronbv_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“Se um homem tiver relações sexuais com uma mulher durante o seu período menstrual, ambos serão expulsos do meio do seu povo. Os dois se tornaram impuros, porque quebraram as leis da pureza. ");
INSERT INTO poronbv_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Não tenha relações sexuais com a irmã de sua mãe, nem com a irmã de seu pai, pois são parentes próximos; pois quem se envolver com uma parenta próxima sofrerá o castigo da sua transgressão. ");
INSERT INTO poronbv_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“Se um homem tiver relações sexuais com a mulher do seu tio, está desonrando seu tio. Eles não escaparão das consequências do seu pecado; morrerão sem filhos. ");
INSERT INTO poronbv_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“Se um homem tomar para si a mulher do seu irmão, ficarão sem filhos. ");
INSERT INTO poronbv_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Israelitas! Obedeçam fielmente às minhas leis e mandamentos, para que a terra que vai ser de vocês não os vomite. ");
INSERT INTO poronbv_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Não sigam os costumes dos povos que estou expulsando de diante de vocês. Porque é por causa desses costumes que fiquei irado com eles. ");
INSERT INTO poronbv_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Quanto a vocês, prometi que haveriam de herdar a terra deles, terra que jorra leite e mel. Eu sou o Senhor, o Deus de vocês, que os separei dos outros povos. ");
INSERT INTO poronbv_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“Portanto, façam separação entre animais e aves que permiti que sirvam de alimento para vocês, e os outros animais e aves impuros. Não se contaminem com animais e aves ou com qualquer criatura que se arrasta pelo chão, os quais declarei impuros. ");
INSERT INTO poronbv_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Sejam santos para mim, porque eu, o Senhor, sou santo, e separei vocês dos outros povos para serem meus. ");
INSERT INTO poronbv_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“O homem e a mulher entre vocês que forem necromantes ou feiticeiros, terão de ser castigados com a morte. Serão apedrejados. Essas pessoas serão responsáveis pela sua própria morte”. ");
INSERT INTO poronbv_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Disse o Senhor a Moisés: “Diga o seguinte aos sacerdotes, os filhos de Arão: Que nenhum sacerdote fique impuro por tocar no corpo de alguém do seu povo que venha a morrer, ");
INSERT INTO poronbv_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","salvo se o morto for um parente próximo, como a mãe ou o pai, o filho ou a filha, irmão ");
INSERT INTO poronbv_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ou irmã virgem por quem o sacerdote tenha ficado responsável. Com ela poderá contaminar-se. ");
INSERT INTO poronbv_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","O sacerdote exerce funções importantes entre o povo. Por isso, não poderá tornar-se impuro ou profanar-se. ");
INSERT INTO poronbv_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Os sacerdotes não raparão a cabeça, nem apararão as pontas da barba, nem farão cortes no corpo. ");
INSERT INTO poronbv_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Eles serão santos ao seu Deus, e não profanarão o nome do seu Deus; pois são eles que apresentam as ofertas queimadas ao Senhor, ofertas de alimento do seu Deus. Para estas funções, eles têm de ser santos. ");
INSERT INTO poronbv_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“Não poderão casar com uma prostituta ou mulher mundana, nem com uma mulher divorciada de seu marido, pois o sacerdote é santo ao seu Deus. ");
INSERT INTO poronbv_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","O sacerdote deverá ser consagrado, porque apresenta o sacrifício ao seu Deus. Considerem-no santo, porque eu, o Senhor, que santifico vocês, sou santo. ");
INSERT INTO poronbv_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“Se a filha de um sacerdote cair em prostituição, estará manchando a honra do seu pai, que é santo ao Senhor. Ela terá de morrer queimada. ");
INSERT INTO poronbv_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“O sumo sacerdote, aquele que entre seus irmãos for ungido com o óleo da unção especialmente derramado sobre sua cabeça, e que for consagrado para usar as roupas sagradas, não andará com o cabelo desalinhado, nem rasgará as roupas em sinal de luto. ");
INSERT INTO poronbv_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ele não chegará perto de um cadáver, mesmo que seja o seu pai ou a sua mãe, para não se tornar impuro; ");
INSERT INTO poronbv_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","e não poderá sair do santuário, nem profanará o Tabernáculo do seu Deus, pois a consagração do óleo da unção do seu Deus está sobre ele. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“O sacerdote deverá casar com uma virgem. ");
INSERT INTO poronbv_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Não poderá casar com uma viúva, nem com uma mulher mundana ou prostituta. Mas tomará uma mulher virgem do seu próprio povo. ");
INSERT INTO poronbv_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Isso para que os seus descendentes não sejam profanados entre o seu povo. Eu sou o Senhor, que separo vocês para serem santos”. ");
INSERT INTO poronbv_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Disse ainda o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Diga a Arão: Nenhum dos seus descendentes, por todas as gerações, que tiver algum defeito físico poderá aproximar-se para apresentar as ofertas de alimento do seu Deus. ");
INSERT INTO poronbv_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Nenhum homem que tenha algum defeito poderá oferecer sacrifícios a mim: ninguém que seja cego, ou aleijado, ou tiver o rosto deformado, ou tiver o corpo deformado; ");
INSERT INTO poronbv_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ninguém que tenha o pé ou a mão quebrados, ");
INSERT INTO poronbv_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ou que seja corcunda, ou anão, ou que tenha doença nos olhos, ou que sofra de sarna, ou outra doença de pele, ou que tenha os testículos defeituosos. ");
INSERT INTO poronbv_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Nenhum descendente do sacerdote de Arão que tenha qualquer defeito poderá aproximar-se para apresentar ofertas queimadas ao Senhor; ele tem defeito e não poderá oferecer as ofertas de alimento ao seu Deus. ");
INSERT INTO poronbv_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ele poderá comer das ofertas do seu Deus, tanto das ofertas santas como das mais santas; ");
INSERT INTO poronbv_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","mas, por causa do seu defeito, não poderá se aproximar do véu nem do altar, para que não profane o meu santuário. Eu sou o Senhor que santifica vocês para que sejam santos”. ");
INSERT INTO poronbv_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Assim Moisés deu essas instruções a Arão, a seus filhos e a todo o povo de Israel. ");
INSERT INTO poronbv_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","O Senhor continuou falando com Moisés e disse: ");
INSERT INTO poronbv_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Diga a Arão e aos seus filhos que tomem todo o cuidado para não mancharem as ofertas sagradas que os israelitas dedicaram a mim, e que tenham o cuidado de não profanar o meu santo nome. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Diga a eles: Todo aquele que, dentre todos os seus descendentes, em todas as suas gerações, estiver impuro quando se aproximar para oferecer os sacrifícios que os israelitas consagraram ao Senhor, será eliminado da minha presença. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Nenhum descendente de Arão que tenha lepra ou um corrimento no membro poderá comer dos sacrifícios santos, até que fique puro. A mesma coisa ocorre com aquele que estiver impuro por ter tocado em um cadáver, com aquele que tenha expelido líquido seminal, ");
INSERT INTO poronbv_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ou com aquele que tenha tocado em alguma criatura, ou em alguma pessoa que o torne impuro por qualquer motivo. ");
INSERT INTO poronbv_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Esse sacerdote ficará impuro até a tarde. E só depois de tomar banho poderá comer das ofertas sagradas. ");
INSERT INTO poronbv_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Depois do pôr do sol estará puro, e só então poderá comer das ofertas sagradas, pois ele depende desses alimentos sagrados para viver. ");
INSERT INTO poronbv_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","O sacerdote não poderá comer carne de qualquer animal que sofreu morte natural ou que foi despedaçado por algum animal selvagem. Se comer, ficará impuro. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Os sacerdotes terão de obedecer cuidadosamente às minhas ordens. Se desobedecerem, estarão profanando o nome do Senhor. Levarão sobre si o seu pecado e morrerão. Eu sou o Senhor que os santifico. ");
INSERT INTO poronbv_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Somente o sacerdote e as pessoas da sua família poderão comer das ofertas sagradas. Ninguém mais. Nem o hóspede de um sacerdote, nem o seu empregado. ");
INSERT INTO poronbv_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mas o escravo, comprado pessoalmente pelo sacerdote, e os filhos do escravo nascidos na casa do sacerdote poderão comer dessas ofertas. ");
INSERT INTO poronbv_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Se a filha de um sacerdote casar com um estrangeiro, não poderá comer das ofertas sagradas. ");
INSERT INTO poronbv_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Mas, se a filha do sacerdote ficar viúva, ou se divorciar e não tiver filhos, e voltar a viver na casa do pai, como na sua mocidade, poderá comer das ofertas sagradas. Fique claro, porém, que ninguém que não pertence às famílias dos sacerdotes poderá comer desse alimento. ");
INSERT INTO poronbv_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Se alguém, sem intenção, comer das ofertas sagradas, deverá restituir ao sacerdote uma porção igual àquela que comeu, e acrescentar um quinto do seu valor. ");
INSERT INTO poronbv_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","“Os sacerdotes não profanarão as ofertas sagradas trazidas pelo povo de Israel ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Eles não permitirão que as ofertas sejam comidas por quem não tem esse direito. Quem desobedecer a essa lei será culpado e deverá ser castigado. Eu sou o Senhor que os santifico”. ");
INSERT INTO poronbv_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Disse o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Diga o seguinte a Arão, a seus filhos e a todo o povo de Israel: Se um israelita ou um estrangeiro que vive no meio do povo quiser apresentar em sacrifício ao Senhor um animal que vai ser queimado, seja para cumprir voto, seja como oferta voluntária, ");
INSERT INTO poronbv_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","apresentará um macho sem defeito, podendo ser um boi, um carneiro ou um bode, para que seja aceito. ");
INSERT INTO poronbv_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Nenhum animal com defeito será aceito, pois não produzirá benefício algum a vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Se alguém apresentar uma oferta de paz, trazendo um animal do gado ou do rebanho de ovelhas, seja para cumprir um voto ou como oferta voluntária, o animal deverá ser sem defeito para que seja aceita a oferta. ");
INSERT INTO poronbv_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Um animal cego, aleijado, mutilado, com ferida ou com outra doença na pele não deverá ser oferecido ao Senhor. Não poderá ser apresentado como oferta queimada no altar do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Porém, vocês poderão apresentar um boi ou um carneiro deformado como oferta voluntária, mas no caso de cumprimento de voto não serão aceitos. ");
INSERT INTO poronbv_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Vocês não poderão oferecer ao Senhor um animal com os testículos machucados, esmagados, arrancados ou cortados. Nunca pensem em oferecer um animal nessas condições na sua terra. ");
INSERT INTO poronbv_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Também não aceitem de um estrangeiro um animal nessas condições, para oferecê-lo como alimento ao seu Deus. Esses animais são impuros e imprestáveis por causa dos seus defeitos e não serão aceitos em favor de vocês”. ");
INSERT INTO poronbv_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","O Senhor continuou falando com Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Quando nascer um bezerro, um cordeiro ou um cabrito, ficará sete dias junto com a mãe. Do oitavo dia em diante, poderá ser sacrificado como oferta queimada ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Não mate no mesmo dia uma vaca ou uma ovelha e sua cria. ");
INSERT INTO poronbv_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Quando vocês oferecerem um sacrifício de gratidão ao Senhor, ofereçam-no de tal maneira que seja aceito em favor de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Será comido no mesmo dia em que for morto. Não deixem nada para o dia seguinte. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Obedeçam rigorosamente aos meus mandamentos e coloquem-nos em prática. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Não profanem o meu santo nome. Deem a mim o lugar central e único no meio do povo de Israel. Pois eu, o Senhor, separei vocês para que sejam santos para mim. ");
INSERT INTO poronbv_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Eu tirei vocês do Egito, para ser o Deus de vocês. Eu sou o Senhor!” ");
INSERT INTO poronbv_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Disse o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Diga aos israelitas o seguinte: As festas do Senhor, que vocês proclamarão como convocações santas, são estas: ");
INSERT INTO poronbv_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Vocês trabalharão seis dias, mas o sétimo dia será o sábado, o dia de descanso solene, quando todos se reúnem para adorar a Deus. Não realizem nenhum trabalho nesse dia. O sábado é do Senhor em todas as casas de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Estas são as festas fixas ao Senhor, as reuniões sagradas que vocês celebrarão no seu devido tempo: ");
INSERT INTO poronbv_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","a Páscoa do Senhor, que deve começar no entardecer do décimo quarto dia do primeiro mês. ");
INSERT INTO poronbv_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","No décimo quinto dia daquele mês começa a festa dos pães sem fermento ao Senhor; durante sete dias vocês comerão pães sem fermento. ");
INSERT INTO poronbv_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","No primeiro dia realizem uma reunião sagrada, e ninguém trabalhará nesse dia. ");
INSERT INTO poronbv_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Durante sete dias apresentem a oferta queimada ao Senhor, e no sétimo dia realizem uma reunião sagrada. Também nesse dia ninguém trabalhará”. ");
INSERT INTO poronbv_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Disse mais o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Diga ao povo de Israel o seguinte: Quando vocês entrarem na terra que eu estou dando a vocês, e fizerem as colheitas de cereais, tragam um feixe da primeira colheita ao sacerdote. ");
INSERT INTO poronbv_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","O sacerdote apresentará a oferta ao Senhor fazendo os movimentos rituais apropriados, para que vocês sejam aceitos. ");
INSERT INTO poronbv_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Nesse mesmo dia em que fizerem o movimento ritual do feixe, vocês oferecerão um cordeiro de um ano de idade sem defeito como oferta queimada ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Além disso, apresentem também uma oferta de cereais. Para esta oferta é preciso trazer dois jarros de farinha da melhor qualidade, preparada com azeite; essa oferta deve ser preparada no fogo e é oferta de aroma agradável ao Senhor. Apresentem também um litro de vinho como oferta de bebida. ");
INSERT INTO poronbv_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Enquanto não for trazida a oferta ao Deus de vocês, não comam pão, nem espigas de trigo verde, nem espigas tostadas. Esta é uma lei perpétua para vocês e seus descendentes, em todas as moradas de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“A partir do dia seguinte ao sábado, o dia em que vocês oferecerão ao Senhor o primeiro feixe da oferta ritualmente movida, contem sete semanas completas. ");
INSERT INTO poronbv_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Contem cinquenta dias, o dia seguinte ao sétimo sábado, e então apresentem uma nova oferta de cereais ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Cada família trará de casa dois pães movidos de forma apropriada diante do Senhor. Estes pães serão feitos com dois jarros de farinha da melhor qualidade, cozidos com fermento. Esses pães são uma oferta ao Senhor, lembrando ainda os primeiros frutos. ");
INSERT INTO poronbv_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Junto com o pão e o vinho, ofereçam sete cordeiros sem defeito, cada um com um ano de idade, um novilho e dois carneiros. Serão apresentados como oferta queimada ao Senhor, junto com as ofertas de cereais e as bebidas sacrificiais; é oferta queimada de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Depois sacrifiquem um bode como oferta pelo pecado, e dois carneiros de um ano de idade como oferta de gratidão. ");
INSERT INTO poronbv_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Então o sacerdote moverá os dois cordeiros diante do Senhor, com o gesto ritualmente apropriado, juntamente com o pão dos primeiros frutos das colheitas. É uma oferta santa ao Senhor, que pertence aos sacerdotes. ");
INSERT INTO poronbv_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Esse dia será anunciado como um dia de santa convocação de todo o povo. Ninguém trabalhará nesse dia. Esta lei é permanente e deverá ser obedecida em todos os lugares onde vocês morarem, de geração em geração. ");
INSERT INTO poronbv_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Quando fizerem a colheita da sua terra, deixem de colher nos cantos dos terrenos cultivados. E as espigas que caírem terão de ser deixadas no chão. São para os pobres e para os estrangeiros. Eu sou o Senhor, o Deus de vocês”. ");
INSERT INTO poronbv_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","O Senhor continuou dando instruções a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Diga também aos israelitas: No primeiro dia do sétimo mês vocês terão um dia de descanso solene, um memorial, uma reunião sagrada celebrada com som de trombeta. ");
INSERT INTO poronbv_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Não trabalhem nesse dia, mas apresentem ao Senhor ofertas preparadas no fogo”. ");
INSERT INTO poronbv_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","O Senhor falou a Moisés sobre a seguinte festa solene: ");
INSERT INTO poronbv_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“O décimo dia deste sétimo mês é o dia em que os pecados do povo são perdoados. Vocês terão uma reunião sagrada; humilhem-se e apresentem ao Senhor uma oferta preparada no fogo. ");
INSERT INTO poronbv_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Nesse dia ninguém trabalhará, porque é o dia especial para obter o perdão dos pecados do povo diante do Senhor, o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Quem não se humilhar nesse dia será eliminado do seu povo. ");
INSERT INTO poronbv_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Eu destruirei do meio do seu povo aquele que fizer algum trabalho nesse dia. ");
INSERT INTO poronbv_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Não façam trabalho algum. Esta lei é permanente em todos os lares e por todas as gerações de Israel. ");
INSERT INTO poronbv_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Pois esse dia é o sábado de descanso solene, e vocês se humilharão. Desde o entardecer do nono dia do mês até o entardecer do dia seguinte, vocês celebrarão o sábado, o dia sagrado de descanso”. ");
INSERT INTO poronbv_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Disse o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Diga ainda aos filhos de Israel: No décimo quinto dia deste sétimo mês começa a festa dos tabernáculos do Senhor, que dura sete dias. ");
INSERT INTO poronbv_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","No primeiro dia haverá uma reunião sagrada; ninguém trabalhará nesse dia. ");
INSERT INTO poronbv_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Em cada um dos sete dias serão apresentadas ao Senhor ofertas preparadas no fogo. No oitavo dia realizem outra reunião sagrada e apresentem uma oferta queimada ao Senhor. É uma reunião solene, e nesse dia ninguém deverá trabalhar. ");
INSERT INTO poronbv_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“São essas, pois, as festas do Senhor, que devem ser realizadas regularmente e que vocês proclamarão como reuniões sagradas para apresentarem ao Senhor ofertas preparadas no fogo, ofertas queimadas, ofertas de cereais, sacrifícios e ofertas de vinho. Cada festa será realizada na data marcada. ");
INSERT INTO poronbv_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Essas ofertas serão apresentadas além das ofertas dos sábados do Senhor, além das dádivas e de todos os votos de vocês, e de todas as ofertas voluntárias que vocês vão dar ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Assim, no dia quinze do sétimo mês, ao terminar a colheita, vocês começarão a celebrar a festa do Senhor durante sete dias. E tanto o primeiro dia como o oitavo serão dias de descanso. ");
INSERT INTO poronbv_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","No primeiro dia da festa, colham frutas das melhores árvores, folhas de palmeira, galhos de árvores com muitas folhas e ramos de salgueiro; e por sete dias vocês se alegrarão na presença do Senhor, o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Celebrem essa festa ao Senhor durante sete dias, todos os anos. É uma lei perpétua para todas as gerações; celebrem-na no sétimo mês. ");
INSERT INTO poronbv_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Durante esses sete dias, todos os israelitas de nascimento terão de morar em tendas, ");
INSERT INTO poronbv_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","para que os descendentes de vocês nunca esqueçam, de geração em geração, que eu fiz os israelitas viverem em tendas, quando os tirei da terra do Egito. Eu sou o Senhor, o Deus de vocês”. ");
INSERT INTO poronbv_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Assim Moisés anunciou ao povo as festas anuais do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Disse o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Mande o povo de Israel trazer azeite de oliva puro para o candelabro, para que as lâmpadas fiquem sempre acesas. ");
INSERT INTO poronbv_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","No Tabernáculo, do lado de fora do véu que esconde a arca da aliança, Arão cuidará para que o fogo das lâmpadas não se apague diante do Senhor, desde o entardecer até a manhã seguinte. Esta lei é permanente, devendo ser obedecida por todas as gerações de Israel. ");
INSERT INTO poronbv_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Mantenha sempre em ordem as lâmpadas do candelabro de ouro puro na presença do Senhor continuamente. ");
INSERT INTO poronbv_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Tome farinha da melhor qualidade e asse doze pães, usando dois jarros para cada pão, ");
INSERT INTO poronbv_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","e coloque-os em duas fileiras, com seis pães em cada uma, sobre a mesa de ouro que está diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Sobre cada fileira coloque um pouco de incenso puro, como uma porção memorial. É oferta ao Senhor preparada no fogo. ");
INSERT INTO poronbv_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Todos os sábados, Arão colocará esses pães em ordem perante o Senhor, continuamente, como aliança — uma aliança eterna — entre Deus e o povo de Israel. ");
INSERT INTO poronbv_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Esses pães pertencem a Arão e seus descendentes, que os comerão em um lugar sagrado, porque são muito sagrados, pois são ofertas ao Senhor preparadas no fogo, como lei permanente”. ");
INSERT INTO poronbv_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Um dia o filho de uma mulher israelita com um egípcio brigou com um homem no acampamento. ");
INSERT INTO poronbv_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","No meio da briga, o filho da israelita blasfemou o nome do Senhor e lançou maldição sobre ele. Por isso o levaram à presença de Moisés para ser julgado. O nome da mãe dele era Selomite, filha de Dibri, da tribo de Dã. ");
INSERT INTO poronbv_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ele foi levado para o cárcere até que a vontade do Senhor fosse revelada. ");
INSERT INTO poronbv_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Então o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Leve o blasfemador para fora do acampamento. Diga a todos os que ouviram o que ele disse contra mim que ponham as mãos sobre a cabeça dele; depois toda a comunidade de Israel irá apedrejá-lo. ");
INSERT INTO poronbv_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","E diga ao povo de Israel: Aquele que amaldiçoar a Deus levará sobre si o seu pecado; ");
INSERT INTO poronbv_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","quem blasfemar o nome do Senhor certamente será morto. Toda a comunidade apedrejará o culpado. Esta lei vale tanto para o estrangeiro como para o natural da terra. Quem blasfemar, ofendendo o nome do Senhor, terá de ser morto. ");
INSERT INTO poronbv_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Quem matar uma pessoa, será morto. ");
INSERT INTO poronbv_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Quem matar um animal pertencente a outra pessoa, terá de fazer a restituição: vida por vida. ");
INSERT INTO poronbv_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Quem ferir alguém, deixando-o defeituoso, receberá um castigo correspondente ao mal que fez. A regra é esta: ");
INSERT INTO poronbv_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","fratura por fratura, olho por olho, dente por dente. O que um homem fizer a outro, assim será feito com ele. ");
INSERT INTO poronbv_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Quem matar um animal, devolverá ao dono outro igual. Mas quem matar um ser humano, será morto. ");
INSERT INTO poronbv_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","A lei vale tanto para o estrangeiro quanto para o natural da terra. Eu sou o Senhor, o Deus de vocês”. ");
INSERT INTO poronbv_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Então Moisés mandou que os israelitas levassem para fora do acampamento o que tinha blasfemado e o apedrejaram. O povo de Israel obedeceu à ordem dada pelo Senhor a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Enquanto Moisés estava no alto do monte Sinai, ");
INSERT INTO poronbv_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Deus deu a ele estas instruções para o povo de Israel: “Quando vocês entrarem na terra que eu dou a vocês, a terra guardará um sábado ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Durante seis anos vocês poderão cultivar as suas lavouras, semeando, podando as suas vinhas e colhendo os produtos da terra. ");
INSERT INTO poronbv_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Mas no sétimo ano a terra terá um sábado de descanso, um descanso dedicado ao Senhor. Não semeiem as suas lavouras, nem aparem as suas vinhas. ");
INSERT INTO poronbv_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Nem mesmo colham o que nascer sozinho nas lavouras e as uvas que as suas vinhas produzirem sem os cuidados do cultivo. A terra descansará o ano inteiro. É descanso solene para a terra, determinado pelo Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Mas os produtos da terra deixados em descanso servirão de alimento para vocês, para os seus escravos, as suas escravas, para os trabalhadores contratados e para os estrangeiros que peregrinam entre vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","O gado e todos os animais das terras de Israel também comerão do que a terra produzir. ");
INSERT INTO poronbv_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Contem sete semanas de anos, sete vezes sete anos, totalizando 49 anos. ");
INSERT INTO poronbv_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Depois, no dia dez do sétimo mês façam soar fortemente a trombeta por toda a terra de vocês; é o Dia do Perdão. ");
INSERT INTO poronbv_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Consagrem o ano cinquenta. Será tempo de proclamar liberdade por toda a terra e para todos os moradores. Este será o Ano do Jubileu. Nesse ano todos os que tiverem sido vendidos como escravos voltarão livres para as suas famílias e todas as dívidas públicas e particulares serão canceladas. Nesse ano todas as propriedades familiares vendidas serão devolvidas aos primeiros proprietários ou aos herdeiros deles. ");
INSERT INTO poronbv_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","O quinquagésimo ano é o Ano do Jubileu. É o ano em que vocês não poderão semear. Não poderão colher o que cresce sozinho, nem as uvas das vinhas apesar de não terem sido podadas. ");
INSERT INTO poronbv_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","É o Ano feliz! Razão do seu nome: Ano do Jubileu. Esse ano é sagrado para o povo. Vocês se alimentarão apenas do que a terra produzir por si mesma. ");
INSERT INTO poronbv_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“No Ano do Jubileu, cada um de vocês voltará para a sua propriedade. ");
INSERT INTO poronbv_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“Quando vocês venderem alguma propriedade ao seu próximo, ou se comprarem alguma propriedade dele, não explorem o seu irmão. ");
INSERT INTO poronbv_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","O que comprar do seu próximo será avaliado de acordo com o número dos anos decorridos desde o Jubileu. O vendedor calculará o preço na base dos anos de colheita que ainda faltam até o Ano do Jubileu. ");
INSERT INTO poronbv_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Se faltar muito tempo, o preço deve ser alto. Se faltar pouco tempo, o preço deve ser baixo, porque quem compra as terras faz a compra pelo número de colheitas que espera ter. ");
INSERT INTO poronbv_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Que ninguém explore o próximo, mas temam ao seu Deus. Eu sou o Senhor, o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Se vocês obedecerem às minhas leis e guardarem as minhas ordenanças, vocês viverão com segurança na terra. ");
INSERT INTO poronbv_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","A terra dará o seu fruto, e vocês terão fartura; e viverão em segurança. ");
INSERT INTO poronbv_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Se perguntarem: ‘Que vamos comer no sétimo ano, pois não podemos semear nem colher?’, ");
INSERT INTO poronbv_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","saibam que os abençoarei tanto no sexto ano que colherão produtos suficientes para três anos. ");
INSERT INTO poronbv_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Quando vocês estiverem plantando no oitavo ano, estarão comendo daquilo que colheram no sexto ano e disso continuarão comendo até a colheita do nono ano. ");
INSERT INTO poronbv_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“E lembrem que a terra é minha. Portanto, nenhuma terra poderá ser vendida definitivamente. Vocês são simples estrangeiros e peregrinos. ");
INSERT INTO poronbv_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Todo contrato de venda terá de ter uma cláusula que dá o direito ao vendedor de resgatar a terra vendida mediante o pagamento do resgate. ");
INSERT INTO poronbv_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Se o seu irmão empobrecer e vender uma parte das suas terras, seu parente mais próximo virá e resgatará o que seu irmão vendeu. ");
INSERT INTO poronbv_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Pode ocorrer que ninguém possa fazer esse pagamento. Neste caso, assim que melhorar a situação financeira do vendedor, ele poderá recuperar a terra. ");
INSERT INTO poronbv_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","O preço será calculado de acordo com o número de colheitas que falta fazer até o Ano do Jubileu. Aquele que tinha comprado a terra terá de aceitar o negócio. Assim o primeiro proprietário poderá voltar às terras dele. ");
INSERT INTO poronbv_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Mas, se não adquirir os recursos para tornar a comprar a terra, terá de esperar até o Ano do Jubileu. Nesse ano a terra voltará a pertencer ao primeiro proprietário. ");
INSERT INTO poronbv_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Quando alguém vender uma casa numa cidade murada, o vendedor só poderá comprar de novo a casa dentro de um ano, a contar do dia da venda. ");
INSERT INTO poronbv_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Se não for resgatada dentro desse prazo, a casa ficará definitivamente com o novo proprietário e com os descendentes dele; nem no Ano do Jubileu será devolvida ao primeiro proprietário. ");
INSERT INTO poronbv_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Mas as casas das vilas que não forem muradas serão negociadas como as terras. Tanto poderão ser compradas de novo pelo primeiro proprietário como terão de ser devolvidas no Ano do Jubileu, se não tiverem sido resgatadas antes. ");
INSERT INTO poronbv_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“No caso das cidades dos levitas, eles sempre terão o direito de resgatar suas casas nas cidades que lhes pertencem. ");
INSERT INTO poronbv_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Mas, se o levita vender a sua casa numa dessas cidades e não tornar a comprá-la, é resgatável e terá de ser devolvida no Jubileu, porque as casas das cidades onde os levitas moram serão suas propriedades permanentes entre os israelitas. ");
INSERT INTO poronbv_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Mas os campos em volta das cidades não podem ser vendidos; são propriedades permanentes dos levitas. ");
INSERT INTO poronbv_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Se o seu irmão empobrecer e não puder sustentar-se, você é responsável pelo sustento dele. Ajude-o como se ele fosse um estrangeiro que mora no meio do povo ou peregrino, para que possa continuar morando com você. ");
INSERT INTO poronbv_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Não cobre dele juro, nem pagamento algum; mas tema ao seu Deus, para que o seu irmão continue a viver entre vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Note bem! Não queira tirar proveito dele. Você não poderá exigir juros do dinheiro que você emprestar a ele, nem emprestar mantimento visando algum lucro. ");
INSERT INTO poronbv_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Eu sou o Senhor, o Deus de vocês, que os tirou da terra do Egito, para dar a vocês a terra de Canaã e para ser o seu Deus! ");
INSERT INTO poronbv_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Se alguém do povo israelita ficar tão pobre e se vender a você, não o faça trabalhar como um escravo! ");
INSERT INTO poronbv_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Ele prestará serviços a você como trabalhador contratado, ou como residente temporário; ele trabalhará para você até o Ano do Jubileu. ");
INSERT INTO poronbv_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Então ele e os seus filhos estarão livres e poderão voltar para a sua família e para a propriedade herdada dos seus pais. ");
INSERT INTO poronbv_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Porque os israelitas são meus servos, a quem tirei da terra do Egito. Eles não poderão ser vendidos como escravos! ");
INSERT INTO poronbv_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Portanto, não maltratem os seus concidadãos como se vocês fossem os seus senhores, mas temam o seu Deus. ");
INSERT INTO poronbv_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“Vocês poderão comprar escravos e escravas das nações vizinhas de Israel. ");
INSERT INTO poronbv_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Também poderão comprar escravos entre os filhos dos residentes temporários que vivem entre vocês e das famílias estrangeiras estabelecidas em Israel, mesmo os nascidos na terra de vocês; eles se tornarão seus escravos. ");
INSERT INTO poronbv_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Vocês poderão deixá-los como herança para os seus filhos, e eles serão seus escravos para sempre; mas vocês não poderão dominar com crueldade seus irmãos israelitas. ");
INSERT INTO poronbv_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Se um estrangeiro estabelecido em Israel ou um residente temporário em Israel ficar rico, e o seu irmão empobrecer e se vender a esse estrangeiro ou a alguém da família desse estrangeiro, ");
INSERT INTO poronbv_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","depois de ter-se vendido, terá o direito de resgate. O resgate poderá ser pago por qualquer parente próximo. ");
INSERT INTO poronbv_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Poderá ser seu tio ou primo ou qualquer parente próximo. Além disso, se prosperar, ele mesmo poderá comprar a sua liberdade. ");
INSERT INTO poronbv_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ele e o seu comprador calcularão o tempo desde o ano em que se vendeu até o Ano do Jubileu. O cálculo será feito tendo como base o salário de um trabalhador contratado por dia de serviço. ");
INSERT INTO poronbv_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Portanto, o preço será maior ou menor, dependendo do número de anos que faltam para o Ano do Jubileu. ");
INSERT INTO poronbv_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Se faltarem apenas poucos anos até o Ano do Jubileu, o preço será menor. ");
INSERT INTO poronbv_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Mas enquanto estiver vendido ao estrangeiro, deverá ser tratado como um trabalhador contratado anualmente; não deixem que o proprietário o trate com impiedade. ");
INSERT INTO poronbv_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“Se não for resgatado por nenhuma dessas maneiras, ele e seus filhos sairão livres no Ano do Jubileu. ");
INSERT INTO poronbv_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Porque os israelitas são os meus servos, os quais tirei da terra do Egito. Eu sou o Senhor, o Deus de vocês”. ");
INSERT INTO poronbv_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Não façam ídolos, nem imagens lavradas, nem construam colunas ou monumentos religiosos, nem ponham pedras modeladas em sua terra para curvar-se diante delas. Eu sou o Senhor, o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“Guardem os meus sábados e respeitem o meu Tabernáculo. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Se vocês obedecerem às minhas leis e aos meus mandamentos, e os praticarem, ");
INSERT INTO poronbv_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","eu darei chuva a vocês no tempo certo, e a terra dará a sua colheita, e as árvores do campo darão o seu fruto. ");
INSERT INTO poronbv_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Mal estarão acabando de debulhar as espigas, e já estarão colhendo uvas, e a colheita das uvas se estenderá até a época de semear novamente os campos; vocês terão comida com fartura e viverão em segurança em sua terra. ");
INSERT INTO poronbv_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Darei paz a vocês, e vocês poderão dormir tranquilos, sem medo nem perturbação. Farei desaparecer da terra os animais nocivos, e não haverá derramamento de sangue na sua terra. ");
INSERT INTO poronbv_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Os inimigos que queiram combater Israel serão perseguidos, e as espadas dos israelitas derrubarão todos eles! ");
INSERT INTO poronbv_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Cinco de vocês farão correr cem inimigos. Cem de vocês serão capazes de perseguir dez mil, e os seus inimigos cairão vencidos diante de vocês! ");
INSERT INTO poronbv_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“Cuidarei de vocês e lhes darei muitos filhos. Cumprirei a minha aliança com vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Vocês ainda estarão comendo da colheita armazenada do ano anterior, e terão de se livrar dela para dar espaço para a nova colheita. ");
INSERT INTO poronbv_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Estabelecerei o meu Tabernáculo no meio de vocês e não os rejeitarei. ");
INSERT INTO poronbv_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Andarei entre vocês e serei o seu Deus, e vocês serão o meu povo. ");
INSERT INTO poronbv_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Eu sou o Senhor, o Deus de vocês, que os tirou da terra do Egito para não serem mais escravos; quebrei as correntes que os prendia e os fiz andar de cabeça erguida. ");
INSERT INTO poronbv_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Mas se não derem ouvidos a mim e não obedecerem fielmente a todos esses mandamentos, ");
INSERT INTO poronbv_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","se rejeitarem as minhas ordens e deixarem de colocar em prática os meus mandamentos, rompendo os termos da minha aliança, ");
INSERT INTO poronbv_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","então eu os tratarei da seguinte maneira: Castigarei vocês com pavor repentino, doenças e febre abrasadora. Os seus olhos enfraquecerão, e a vida de vocês definhará. Vocês semearão em vão, porque os seus inimigos comerão as suas colheitas. ");
INSERT INTO poronbv_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Virarei o meu rosto contra vocês, e vocês serão perseguidos e derrotados pelos seus inimigos; os seus adversários os dominarão, e vocês fugirão apavorados mesmo quando ninguém os estiver perseguindo. ");
INSERT INTO poronbv_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Se, depois de tudo isso vocês não me derem ouvidos, eu os castigarei sete vezes mais, por causa dos seus pecados. ");
INSERT INTO poronbv_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Quebrarei o orgulho do seu poder; e farei os céus como ferro e a terra como bronze. ");
INSERT INTO poronbv_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Vocês gastarão as suas forças de tanto trabalhar, mas a terra não lhes dará colheita, nem as árvores darão o seu fruto! ");
INSERT INTO poronbv_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“E se mesmo assim continuarem rebeldes e surdos ao que digo, multiplicarei o castigo de vocês sete vezes, segundo os seus pecados. ");
INSERT INTO poronbv_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Mandarei animais ferozes contra vocês. Eles matarão os seus filhos. Acabarei com os seus rebanhos e reduzirei vocês cada vez mais, a ponto de os caminhos de Israel ficarem desertos. ");
INSERT INTO poronbv_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Se apesar disso vocês não se corrigirem e não voltarem para mim, continuando a me desafiar, ");
INSERT INTO poronbv_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","eu marcharei contra vocês e os castigarei sete vezes mais, por causa dos seus pecados! ");
INSERT INTO poronbv_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Farei com que os inimigos os ataquem para vingar a minha aliança. Quando se refugiarem em suas cidades, mandarei uma praga sobre vocês, e vocês serão dominados pelos inimigos. ");
INSERT INTO poronbv_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Quando eu lhes cortar o suprimento de pão, dez mulheres assarão o pão num só forno, e cada pessoa receberá uma porção tão pequena de comida que não conseguirá matar a sua fome. ");
INSERT INTO poronbv_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Se ainda não me ouvirem, e continuarem desobedecendo às minhas ordens, ");
INSERT INTO poronbv_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","então voltarei a minha ira contra vocês com castigos sete vezes maiores por causa dos seus pecados. ");
INSERT INTO poronbv_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Vocês chegarão a comer a carne dos seus filhos e das suas filhas! ");
INSERT INTO poronbv_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Destruirei os altares nos morros, onde vocês adoram ídolos, despedaçarei as imagens do deus sol. Depois jogarei os cadáveres de vocês em cima dos seus ídolos caídos, e rejeitarei vocês. ");
INSERT INTO poronbv_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Transformarei as suas cidades em deserto, destruirei os seus lugares de culto e não terei prazer no aroma das suas ofertas. ");
INSERT INTO poronbv_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Arrasarei de tal forma a terra em que vocês moram que isso causará espanto aos inimigos invasores. ");
INSERT INTO poronbv_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Espalharei vocês entre as nações e desembainharei a espada atrás de vocês. Sua terra ficará deserta e as suas cidades em ruínas. ");
INSERT INTO poronbv_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Então a sua terra poderá gozar dos seus anos sabáticos. Enquanto estiver abandonada e deserta, e enquanto vocês estiverem espalhados entre as nações dos seus inimigos, a terra que dei a vocês poderá desfrutar dos seus sábados. ");
INSERT INTO poronbv_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Enquanto estiver abandonada, a terra terá o descanso sabático, porque, quando vocês moravam lá, não lhe deram o devido descanso. ");
INSERT INTO poronbv_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Quanto aos que sobreviverem nas terras dos seus inimigos, encherei o seu coração de tal pavor que fugirão assustados ao movimento de uma folha. Fugirão como se estivessem sendo perseguidos por homens armados de espadas, e cairão, sem que estejam sendo perseguidos por alguém. ");
INSERT INTO poronbv_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Sem que ninguém persiga esses israelitas, eles cairão, tropeçando uns nos outros. E caídos uns sobre os outros, serão facilmente apanhados e destruídos pelos inimigos. ");
INSERT INTO poronbv_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Vocês morrerão entre as nações. A terra dos seus inimigos os consumirá. ");
INSERT INTO poronbv_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Os que sobreviverem nas terras inimigas finalmente serão destruídos pelos seus próprios pecados, e também por causa dos pecados dos seus antepassados. ");
INSERT INTO poronbv_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Mas se confessarem os seus pecados e dos seus antepassados, reconhecendo que foram infiéis a mim, ");
INSERT INTO poronbv_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","fazendo com que eu ficasse contra eles e os espalhasse pela terra dos seus inimigos; se o seu coração obstinado se humilhar, e aceitarem o castigo do seu pecado, ");
INSERT INTO poronbv_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","eu me lembrarei da minha aliança com Jacó, da minha aliança com Isaque e da minha aliança com Abraão, e me lembrarei da terra de Israel. ");
INSERT INTO poronbv_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Enquanto isso, a terra aproveitará a desolação para desfrutar dos sábados. Receberão o castigo pelos seus pecados porque desobedeceram às minhas leis e desprezaram os meus mandamentos. ");
INSERT INTO poronbv_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Mesmo assim, quando estiverem na terra do inimigo, não os desprezarei, nem os abandonarei para destruí-los totalmente. Nem quebrarei a minha aliança com eles, pois eu sou o Senhor, o Deus deles. ");
INSERT INTO poronbv_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Por amor deles eu me lembrarei da aliança que fiz com os seus antepassados que tirei da terra do Egito à vista das nações, para ser o Deus deles. Eu sou o Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Essas foram as leis, as ordens e as instruções que o Senhor deu ao povo de Israel, no monte Sinai, por meio de Moisés. ");
INSERT INTO poronbv_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Disse o Senhor a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Diga ao povo de Israel o seguinte: Quando alguém fizer um voto especial dedicando pessoas ao Senhor, deve ser feito conforme o devido valor; ");
INSERT INTO poronbv_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","um homem que tenha entre vinte e sessenta anos de idade pagará o valor de seiscentos gramas de prata, tomando como base o padrão de pesos do Tabernáculo; ");
INSERT INTO poronbv_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","uma mulher que tenha entre vinte e sessenta anos pagará o valor de trezentos e sessenta gramas. ");
INSERT INTO poronbv_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Se for um menino ou jovem, entre cinco e vinte anos, pagará o valor de duzentos e quarenta gramas de prata; se for uma menina ou moça, pagará o valor de cento e vinte gramas. ");
INSERT INTO poronbv_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Se for um menino entre um mês e cinco anos de idade, pagará o valor de sessenta gramas de prata; se for uma menina, pagará o valor de trinta e seis gramas de prata. ");
INSERT INTO poronbv_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Um homem de mais de sessenta anos de idade pagará o valor de cento e oitenta gramas de prata; uma mulher dessa idade pagará o valor de cento e vinte gramas. ");
INSERT INTO poronbv_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Se a pessoa que fez o voto for muito pobre para pagar o valor estabelecido, procurará o sacerdote, que decidirá o valor a ser pago de acordo com as posses daquela pessoa. ");
INSERT INTO poronbv_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Se um doador prometeu mediante voto dedicar um animal ao Senhor, esse animal dado ao Senhor será considerado santo. ");
INSERT INTO poronbv_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","O doador não poderá trocar um animal por outro; ele não poderá trocar um animal bom por outro ruim, nem um animal ruim por outro bom. Se, porém, por algum motivo os trocar, ambos serão consagrados, pertencendo ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Se o que ele prometeu mediante voto for um animal impuro, que o Senhor não aceita, deve ser apresentado ao sacerdote, ");
INSERT INTO poronbv_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","que fará a avaliação, seja bom, seja ruim. A avaliação do sacerdote determinará o valor do animal. ");
INSERT INTO poronbv_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Se o dono desejar resgatar esse animal, deverá pagar o preço estabelecido, acrescido de um quinto”. ");
INSERT INTO poronbv_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Se um homem dedicar a sua casa ao Senhor, chamará o sacerdote para fazer a avaliação da casa. ");
INSERT INTO poronbv_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Se esse homem quiser resgatá-la, terá de pagar o preço da casa, acrescido de um quinto. ");
INSERT INTO poronbv_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Se alguém dedicar ao Senhor uma parte das terras da sua família, o preço dessas terras será calculado de acordo com a semeadura, com a seguinte base: seiscentos gramas de prata para cada barril de semente de cevada. ");
INSERT INTO poronbv_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Se a sua terra for dedicada durante o Ano do Jubileu, o valor será integral; ");
INSERT INTO poronbv_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","mas, se a terra for dedicada depois do Ano do Jubileu, o sacerdote calculará o valor de acordo com os anos que faltarem para o Ano do Jubileu seguinte. ");
INSERT INTO poronbv_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Caso queira resgatar a terra que dedicou ao Senhor, o dono terá de pagar o valor estabelecido, acrescido de um quinto; e a terra voltará a ser sua. ");
INSERT INTO poronbv_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Mas se ele não a resgatar, ou se tiver vendido a terra a outra pessoa, não mais poderá resgatá-la; ");
INSERT INTO poronbv_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","quando a terra for liberada no Ano do Jubileu, será santa e pertencerá ao Senhor, como terreno dedicado a ele, e se tornará propriedade do sacerdote. ");
INSERT INTO poronbv_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Se alguém dedicar ao Senhor um campo que comprou, e não for parte da sua herança, ");
INSERT INTO poronbv_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","o sacerdote calculará o valor tomando como base os anos que faltam para o Ano do Jubileu. No mesmo dia, o homem pagará o seu valor e dedicará o dinheiro ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","No Ano do Jubileu a propriedade será devolvida àquele de quem foi comprada. ");
INSERT INTO poronbv_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Todas as avaliações serão feitas de acordo com o peso padrão de prata do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Ninguém deverá dedicar a primeira cria de um animal, pois já pertence ao Senhor; seja cria de vaca ou de animal de menor tamanho. ");
INSERT INTO poronbv_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Mas, no caso de um animal impuro — proibido para o sacrifício — é diferente. Será resgatado pelo preço estabelecido pelo sacerdote, acrescido de um quinto. Se não for resgatado, será vendido pelo valor estabelecido. ");
INSERT INTO poronbv_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Entretanto, ninguém poderá vender ou resgatar quer pessoa, quer animal, quer terras de sua propriedade, que tiverem sido dedicados ao Senhor de modo definitivo. Pois tudo aquilo que for dedicado dessa maneira será muito santo ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Se alguém for condenado à morte, segundo as leis do Senhor, não poderá ser resgatado. Terá de ser morto. ");
INSERT INTO poronbv_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Todos os dízimos dos produtos da terra são do Senhor, quer dos cereais, quer das frutas; essa parte é santa ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Se um homem desejar resgatar parte do seu dízimo, terá de pagar o preço dela, acrescido de um quinto. ");
INSERT INTO poronbv_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Também de todos os animais criados pelo homem, seja do gado ou dos rebanhos, o dízimo pertence ao Senhor. De cada dez animais, um é do Senhor, ");
INSERT INTO poronbv_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","não importa se os animais dedicados como dízimos são bons ou ruins. O dono não poderá trocar um animal pelo outro. Se algum animal consagrado como dízimo for trocado por outro, os dois pertencerão ao Senhor. Serão santos e não poderão ser resgatados”. ");
INSERT INTO poronbv_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","O Senhor deu esses mandamentos a Moisés, no monte Sinai, para o povo de Israel.");
INSERT INTO poronbv_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","No primeiro dia do segundo mês do segundo ano depois que os israelitas saíram do Egito, o Senhor deu as seguintes ordens a Moisés, no Tabernáculo, no deserto do Sinai: ");
INSERT INTO poronbv_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Façam um recenseamento, você e Arão, de toda a comunidade de Israel, por grupos de famílias e por famílias, contando todos os homens, um por um, ");
INSERT INTO poronbv_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","com vinte anos de idade ou mais, que estão aptos para ir à guerra em Israel, organizados segundo as suas divisões. ");
INSERT INTO poronbv_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Um homem de cada tribo, o chefe de grupo de famílias, ajudará vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Estes são os nomes dos homens que vão ajudar vocês na contagem: “de Rúben, Elizur, filho de Sedeur; ");
INSERT INTO poronbv_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","de Simeão, Selumiel, filho de Zurisadai; ");
INSERT INTO poronbv_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","de Judá, Naassom, filho de Aminadabe; ");
INSERT INTO poronbv_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","de Issacar, Natanael, filho de Zuar; ");
INSERT INTO poronbv_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","de Zebulom, Eliabe, filho de Helom; ");
INSERT INTO poronbv_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","dos filhos de José: de Efraim, Elisama, filho de Amiúde; de Manassés, Gamaliel, filho de Pedazur; ");
INSERT INTO poronbv_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","de Benjamim, Abidã, filho de Gideoni; ");
INSERT INTO poronbv_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","de Dã, Aiezer, filho de Amisadai; ");
INSERT INTO poronbv_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","de Aser, Pagiel, filho de Ocrã; ");
INSERT INTO poronbv_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","de Gade, Eliasafe, filho de Deuel; ");
INSERT INTO poronbv_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","de Naftali, Aira, filho de Enã”. ");
INSERT INTO poronbv_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Esses foram os líderes das tribos dos seus antepassados, chefes dos grupos de famílias, escolhidos dentre a comunidade de Israel. ");
INSERT INTO poronbv_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Então, Moisés e Arão reuniram os líderes escolhidos ");
INSERT INTO poronbv_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","e convocaram toda a comunidade no primeiro dia do segundo mês; reuniram todos os homens de Israel de vinte anos de idade ou mais para fazer a contagem por grupos de famílias e por famílias, um por um, pelo nome. ");
INSERT INTO poronbv_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Fizeram como o Senhor tinha ordenado a Moisés e assim os contaram no deserto do Sinai. ");
INSERT INTO poronbv_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Dos descendentes de Rúben, o filho mais velho de Israel: Todos os homens de vinte anos ou mais que eram aptos para ir para a guerra foram relacionados, segundo a sua origem, cada um de acordo com o seu grupo de famílias e na sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Foram contados ao todo da tribo de Rúben 46.500 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Dos descendentes de Simeão: Todos os homens de vinte anos ou mais que eram aptos para ir para a guerra foram relacionados, segundo a sua origem, cada um de acordo com o seu grupo de famílias e na sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Foram contados ao todo da tribo de Simeão 59.300 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Dos descendentes de Gade: Todos os homens de vinte anos ou mais que eram aptos para ir para a guerra foram relacionados, segundo a sua origem, cada um de acordo com o seu grupo de famílias e na sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Foram contados ao todo da tribo de Gade 45.650 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Dos descendentes de Judá: Todos os homens de vinte anos ou mais que eram aptos para ir para a guerra foram relacionados, segundo a sua origem, cada um de acordo com o seu grupo de famílias e na sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Foram contados ao todo da tribo de Judá 74.600 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Dos descendentes de Issacar: Todos os homens de vinte anos ou mais que eram aptos para ir para a guerra foram relacionados, segundo a sua origem, cada um de acordo com o seu grupo de famílias e na sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Foram contados ao todo da tribo de Issacar 54.400 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Dos descendentes de Zebulom: Todos os homens de vinte anos ou mais que eram aptos para ir para a guerra foram relacionados, segundo a sua origem, cada um de acordo com o seu grupo de famílias e na sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Foram contados ao todo da tribo de Zebulom 57.400 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Dos filhos de José: Dos descendentes de Efraim: Todos os homens de vinte anos ou mais que eram aptos para ir para a guerra foram relacionados, segundo a sua origem, cada um de acordo com o seu grupo de famílias e na sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Foram contados ao todo da tribo de Efraim 40.500 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Dos descendentes de Manassés: Todos os homens de vinte anos ou mais que eram aptos para ir para a guerra foram relacionados, segundo a sua origem, cada um de acordo com o seu grupo de famílias e na sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Foram contados ao todo da tribo de Manassés 32.200 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Dos descendentes de Benjamin: Todos os homens de vinte anos ou mais que eram aptos para ir para a guerra foram relacionados, segundo a sua origem, cada um de acordo com o seu grupo de famílias e na sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Foram contados ao todo da tribo de Benjamin 35.400 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dos descendentes de Dã: Todos os homens de vinte anos ou mais que eram aptos para ir para a guerra foram relacionados, segundo a sua origem, cada um de acordo com o seu grupo de famílias e na sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Foram contados ao todo da tribo de Dã 62.700 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Dos descendentes de Aser: Todos os homens de vinte anos ou mais que eram aptos para ir para a guerra foram relacionados, segundo a sua origem, cada um de acordo com o seu grupo de famílias e na sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Foram contados ao todo da tribo de Aser 41.500 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Dos descendentes de Naftali: Todos os homens de vinte anos ou mais que eram aptos para ir para a guerra foram relacionados, segundo a sua origem, cada um de acordo com o seu grupo de famílias e na sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Foram contados ao todo da tribo de Naftali 53.400 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Esses foram os homens contados por Moisés e Arão e pelos doze líderes das tribos de Israel, cada um representando a sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Todos os homens israelitas de vinte anos ou mais que estavam aptos para ir para a guerra, de acordo com as suas famílias, ");
INSERT INTO poronbv_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","somaram um total de 603.550 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Este total, porém, não incluiu os levitas, ");
INSERT INTO poronbv_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","porque o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Você não deve fazer o recenseamento da tribo de Levi nem relacione o número de levitas no total geral dos israelitas. ");
INSERT INTO poronbv_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Mas diga aos levitas que se responsabilizem pelo cuidado do Tabernáculo, das tábuas da aliança, de todos os utensílios e por tudo o que pertence a ele. Eles levarão o Tabernáculo e todos os seus utensílios, e acamparão junto a ele. ");
INSERT INTO poronbv_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Sempre que o Tabernáculo tiver de ser removido, só os levitas poderão desmontar e armar o Tabernáculo. Qualquer estranho não autorizado que se aproximar do Tabernáculo morrerá. ");
INSERT INTO poronbv_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Cada tribo de Israel terá o seu próprio acampamento e armará as suas tendas separadamente, segundo as suas divisões, e nesse lugar ficará a bandeira da tribo. ");
INSERT INTO poronbv_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Mas os levitas armarão o seu acampamento ao redor do Tabernáculo que guarda as tábuas da aliança, para cuidar do Tabernáculo e para que a comunidade de Israel não seja atingida pela ira de Deus”. ");
INSERT INTO poronbv_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Então os filhos de Israel obedeceram a tudo o que o Senhor havia ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","E o Senhor deu mais ordens para Moisés e Arão: ");
INSERT INTO poronbv_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Cada tribo de Israel deve acampar em um lugar próprio, ao redor do Tabernáculo, onde colocarão a bandeira da tribo e os símbolos de cada família”. ");
INSERT INTO poronbv_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Do lado leste acamparão os exércitos da tribo de Judá junto à sua bandeira. O chefe de Judá será Naassom, filho de Aminadabe; ");
INSERT INTO poronbv_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","e o seu exército, segundo o censo, é de 74.600 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","A tribo de Issacar acampará ao lado de Judá. O chefe de Issacar será Natanael, filho de Zuar; ");
INSERT INTO poronbv_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","e o seu exército, segundo o censo, é de 54.400 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Depois virá a tribo de Zebulom. Eliabe, filho de Helom, será o chefe de Zebulom, ");
INSERT INTO poronbv_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","e o seu exército, segundo o censo, é de 57.400 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","O número total dos homens recenseados do acampamento de Judá, segundo os seus exércitos, é de 186.400. Esses homens marcharão primeiro. ");
INSERT INTO poronbv_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Do lado sul acamparão os exércitos da tribo de Rúben junto à sua bandeira. O chefe de Rúben será Elizur, filho de Sedeur; ");
INSERT INTO poronbv_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","e o seu exército, segundo o censo, é de 46.500 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","A tribo de Simeão acampará ao lado de Rúben. O chefe de Simeão será Selumiel, filho de Zurisadai; ");
INSERT INTO poronbv_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","e o seu exército, segundo o censo, é de 59.300 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Depois virá a tribo de Gade. Elisafe, filho de Deuel, será o chefe de Gade, ");
INSERT INTO poronbv_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","e o seu exército, segundo o censo, é de 45.650 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","O número total dos homens recenseados do acampamento de Rúben, segundo os seus exércitos, é de 151.450. Esses marcharão em segundo lugar. ");
INSERT INTO poronbv_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Depois marcharão os exércitos dos levitas levando o Tabernáculo no meio dos outros acampamentos, na mesma ordem em que acamparem; cada um no seu devido lugar, seguindo a sua bandeira. ");
INSERT INTO poronbv_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Do lado oeste acamparão os exércitos da tribo de Efraim junto à sua bandeira. O chefe de Efraim será Elizama, filho de Amiúde; ");
INSERT INTO poronbv_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","e o seu exército, segundo o censo, é de 40.500 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","A tribo de Manassés acampará ao lado de Efraim. O chefe de Manassés será Gamaliel, filho de Pedazur; ");
INSERT INTO poronbv_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","e o seu exército, segundo o censo, é de 32.200 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Depois virá a tribo de Benjamim. Abidã, filho de Gideoni, será o chefe de Benjamim; ");
INSERT INTO poronbv_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","e o seu exército, segundo o censo, é de 32.200 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","O número total dos homens recenseados do acampamento de Efraim, segundo os seus exércitos, é de 108.100. Esses marcharão em terceiro lugar. ");
INSERT INTO poronbv_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Do lado norte acamparão os exércitos da tribo de Dã junto à sua bandeira. O chefe de Dã será Aiezer, filho de Amisadai; ");
INSERT INTO poronbv_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","e o seu exército, segundo o censo, é de 62.700 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","A tribo de Aser acampará ao lado de Dã. O chefe de Aser será Pagiel, filho de Ocrã; ");
INSERT INTO poronbv_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","e o seu exército, segundo o censo, é de 41.500 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Depois virá a tribo de Naftali. Aira, filho de Enã, será o chefe de Naftali; ");
INSERT INTO poronbv_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","e o seu exército, segundo o censo, é de 53.400 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","O número total dos homens recenseados do acampamento de Dã, segundo os seus exércitos, é de 157.600 homens. Esses marcharão em último lugar, junto às suas bandeiras. ");
INSERT INTO poronbv_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","O número total de homens de Israel contados de acordo com as suas famílias, nos acampamentos, de acordo com os seus exércitos foi de 603.550. ");
INSERT INTO poronbv_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Mas os levitas não foram contados com os outros israelitas, como o Senhor havia ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Assim, o povo de Israel fez tudo o que o Senhor havia ordenado a Moisés; eles acampavam junto à sua bandeira e marchavam cada um com o seu grupo de famílias e com a sua família. ");
INSERT INTO poronbv_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Estes foram os descendentes de Arão e de Moisés, quando o Senhor falou a Moisés no monte Sinai: ");
INSERT INTO poronbv_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Os nomes dos filhos de Arão são os seguintes: Nadabe, o filho mais velho, Abiú, Eleazar e Itamar. ");
INSERT INTO poronbv_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Esses são os nomes dos filhos de Arão, que foram ungidos e ordenados para o sacerdócio. ");
INSERT INTO poronbv_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Mas Nadabe e Abiú morreram na presença do Senhor, quando ofereciam fogo proibido pelo próprio Senhor, no deserto de Sinai. Tanto Nadabe quanto Abiú não tiveram filhos; por isso, somente Eleazar e Itamar serviram como sacerdotes diante de seu pai Arão. ");
INSERT INTO poronbv_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Então o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Reúna a tribo de Levi e diga ao sacerdote Arão que os levitas o auxiliarão. ");
INSERT INTO poronbv_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Os levitas devem cumprir bem os seus deveres no Tabernáculo para com Arão e seus filhos, e para com todo o povo. ");
INSERT INTO poronbv_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Eles tomarão conta de todos os utensílios do Tabernáculo, cumprindo as obrigações para com os filhos de Israel no serviço do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","A tribo de Levi será a escolhida entre os israelitas para servir a Arão e seus filhos. ");
INSERT INTO poronbv_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Mas só Arão e os seus filhos cuidarão do sacerdócio; qualquer outra pessoa não autorizada que se aproximar será morta”. ");
INSERT INTO poronbv_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Eu escolhi os levitas dentre os filhos de Israel, em lugar do primeiro filho de cada mulher israelita. Os levitas me pertencem, ");
INSERT INTO poronbv_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","porque todo primeiro filho que nasce em cada lar é meu. Desde aquele dia em que feri os primeiros filhos de cada família do Egito, separei para mim todos os primeiros filhos de cada família de Israel, inclusive as primeiras crias de cada animal. Eu sou o Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","E o Senhor falou com Moisés no deserto do Sinai: ");
INSERT INTO poronbv_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Faça uma contagem de todos os homens levitas que tenham mais de um mês de idade, de acordo com os seus grupos de família e a família de cada homem”. ");
INSERT INTO poronbv_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Então Moisés os contou, conforme a ordem do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","São estes os filhos de Levi pelos seus nomes: Gérson, Coate e Merari. ");
INSERT INTO poronbv_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","E estes são os nomes dos filhos de Gérson de acordo com as suas famílias: Libni e Simei. ");
INSERT INTO poronbv_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","E estes são os nomes dos filhos de Coate de acordo com as suas famílias: Anrão, Jizar, Hebrom e Uziel. ");
INSERT INTO poronbv_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","E estes são os nomes dos filhos de Merari de acordo com as suas famílias: Mali e Musi. ");
INSERT INTO poronbv_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","O grupo de famílias de Gérson era formado pelas famílias de Libni e de Simei. ");
INSERT INTO poronbv_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","O número de todos os que foram contados do sexo masculino, de um mês de idade para cima, foi 7.500. ");
INSERT INTO poronbv_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Esse grupo deveria se acampar a oeste, atrás do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","O chefe desse grupo de famílias era Eliasafe, filho de Lael. ");
INSERT INTO poronbv_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","A responsabilidade dessas duas famílias de levitas era cuidar do Tabernáculo, da tenda interior (ou santuário) da cobertura, da cortina da entrada do Tabernáculo, ");
INSERT INTO poronbv_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","das cortinas externas do pátio, da cortina da entrada do pátio que fica ao redor do Tabernáculo, do altar, e das cordas usadas para montar o Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","De Coate originaram-se os grupos de famílias dos anramitas, dos jizaritas, dos hebronitas e dos uzielitas. São essas as famílias dos coatitas. ");
INSERT INTO poronbv_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","O número de todos os que foram contados do sexo masculino, de um mês de idade para cima, foi 8.600. Eles eram responsáveis para cuidar do Santuário. ");
INSERT INTO poronbv_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Os coatitas deveriam acampar no lado sul do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","O chefe desse grupo de famílias era Elisafã, filho de Uziel. ");
INSERT INTO poronbv_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","A responsabilidade dessas quatro famílias de levitas era tomar conta da arca da aliança, da mesa, do candelabro, dos altares, dos utensílios do Santuário usados para ministrar, da cortina e de tudo que estava relacionado com esse serviço. ");
INSERT INTO poronbv_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","O líder dos chefes dos levitas era Eleazar, filho do sacerdote Arão. Ele era responsável pela supervisão dos encarregados que tomavam conta do Santuário. ");
INSERT INTO poronbv_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","O grupo das famílias de Merari era formado pelos malitas e os musitas. ");
INSERT INTO poronbv_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","O número de todos os que foram contados do sexo masculino, de um mês de idade para cima, foi 6.200. ");
INSERT INTO poronbv_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","O chefe do grupo de famílias de Merari era Zuriel, filho de Abiail. Os meraritas deveriam acampar no lado norte do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Os meraritas tinham a responsabilidade de cuidar das armações do Tabernáculo, de seus travessões, das colunas, das bases, de todos os seus utensílios, ");
INSERT INTO poronbv_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","bem como das colunas do pátio ao redor, e das bases, das estacas menores e das cordas usadas nesse trabalho. ");
INSERT INTO poronbv_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","As tendas de Moisés, de Arão e dos filhos de Arão deveriam ficar a leste do Tabernáculo. Eles tinham a responsabilidade de tomar conta do Tabernáculo e trabalhar como sacerdotes em favor dos israelitas. Qualquer pessoa estranha que se aproximasse deveria morrer. ");
INSERT INTO poronbv_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","A contagem dos levitas do sexo masculino, da idade de um mês para cima, que Moisés e Arão fizeram por ordem do Senhor, foi de 22.000. ");
INSERT INTO poronbv_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Então o Senhor disse a Moisés: “Conte todos os primeiros filhos de cada família de Israel, do sexo masculino, de um mês para cima e registre o nome de cada um deles. ");
INSERT INTO poronbv_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Trocarei o filho mais velho de cada família de Israel pelos levitas, e a primeira cria de todos os animais que existem em Israel pelos animais dos levitas. Os levitas são meus. Eu sou o Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Então Moisés contou todos os filhos mais velhos das famílias do povo de Israel, de acordo com a ordem do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","O número total dos filhos mais velhos do sexo masculino, de um mês para cima, segundo o censo, foi de 22.273. ");
INSERT INTO poronbv_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","O Senhor disse então a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Dedique os levitas em lugar dos filhos mais velhos do povo de Israel, e me entregue os animais dos levitas em troca da primeira cria dos animais do povo de Israel. Os levitas serão meus. Eu sou o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Para pagar o resgate dos 273 filhos mais velhos que excederam o número de levitas, ");
INSERT INTO poronbv_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","recolha sessenta gramas de prata por pessoa, com base no peso padrão do santuário. ");
INSERT INTO poronbv_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Entregue a Arão e aos seus dois filhos para o resgate do excedente de israelitas”. ");
INSERT INTO poronbv_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moisés então recebeu o valor do resgate dos 273 filhos mais velhos das famílias do povo de Israel que excederam o número de levitas. ");
INSERT INTO poronbv_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Dos filhos mais velhos de Israel ele recolheu quase dezesseis quilos de prata, com base no peso padrão do santuário. ");
INSERT INTO poronbv_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Como o Senhor mandou, Moisés entregou esse dinheiro a Arão e seus filhos. ");
INSERT INTO poronbv_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Então o Senhor disse a Moisés e a Arão: ");
INSERT INTO poronbv_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Façam um recenseamento dos coatitas, por grupo de famílias e por famílias da tribo de Levi. ");
INSERT INTO poronbv_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Contem todos os homens que têm entre trinta e cinquenta anos de idade, capazes de fazer o serviço do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“O serviço dos coatitas no Tabernáculo é cuidar das coisas muito sagradas. ");
INSERT INTO poronbv_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Quando o acampamento for desarmado, Arão e seus filhos entrarão primeiro no Tabernáculo para tirar o véu protetor e com ele cobrirão a arca da aliança. ");
INSERT INTO poronbv_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Então eles cobrirão a arca com couro, cobrirão o couro com um pano azul e colocarão as varas de carregar nas argolas da arca. ");
INSERT INTO poronbv_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“A seguir, devem colocar um pano azul sobre a mesa onde ficam os pães da Presença e colocarão os pratos, as taças de incenso, as taças das ofertas, os jarros para as ofertas de bebida e os pães da Presença sobre esse pano. ");
INSERT INTO poronbv_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Depois colocarão sobre tudo isso um pano vermelho, e finalmente o cobrirão com uma coberta de couro. Depois colocarão as varas nas argolas da mesa. ");
INSERT INTO poronbv_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Em seguida pegarão um pano azul e cobrirão o candelabro, as lâmpadas, as tesouras de cortar os pavios das lâmpadas, os seus apagadores e todos os jarros necessários para o suprimento de azeite. ");
INSERT INTO poronbv_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Então cobrirão tudo isso com uma coberta de couro e colocarão estes objetos sobre as varas para carregar. ");
INSERT INTO poronbv_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Eles cobrirão o altar de ouro com um pano azul e por cima colocarão uma coberta de couro. Depois colocarão os cabos nas argolas do altar. ");
INSERT INTO poronbv_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Eles embrulharão todos os outros utensílios usados na ministração no Tabernáculo com um pano azul e os cobrirão com uma coberta de couro, e colocarão tudo isso sobre as varas de carregar. ");
INSERT INTO poronbv_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Eles tirarão a cinza do altar de bronze e estenderão por cima dele um pano vermelho. ");
INSERT INTO poronbv_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Colocarão sobre ele todos os utensílios usados na ministração do altar: os braseiros, os garfos, as pás e as bacias, e todos os utensílios do altar; e sobre tudo isso estenderão uma coberta de couro. Então colocarão as varas de carregar nas argolas do altar. ");
INSERT INTO poronbv_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Quando Arão e seus filhos terminarem de desmontar o santuário e os utensílios do santuário, os coatitas deverão carregá-los durante a viagem. Mas não tocarão nos utensílios sagrados. Se o fizerem, morrerão. São esses os utensílios do Tabernáculo que os coatitas devem levar. ");
INSERT INTO poronbv_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eleazar, filho do sacerdote Arão, deve tomar conta do azeite para as lâmpadas do incenso aromático, da oferta diária de cereais e do óleo da unção. Ele ficará responsável por tomar conta de todo o Tabernáculo e por tudo o que nele há, ou seja, os seus utensílios e acessórios”. ");
INSERT INTO poronbv_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Então o Senhor disse a Moisés e a Arão: ");
INSERT INTO poronbv_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Não deixem que as famílias dos coatitas desapareçam entre os levitas. ");
INSERT INTO poronbv_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Vocês devem fazer o seguinte para que os coatitas não morram quando forem carregar as coisas sagradas: Arão e seus filhos entrarão no santuário e designarão a cada coatita o que deve carregar. ");
INSERT INTO poronbv_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Os coatitas nunca devem entrar no santuário nem ver as coisas sagradas. Se eles desobedecerem, morrerão”. ");
INSERT INTO poronbv_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Faça também um recenseamento dos gersonitas, por grupos de famílias e por famílias; ");
INSERT INTO poronbv_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","conte todos os homens que têm entre trinta e cinquenta anos de idade, e que são capazes de fazer o trabalho sagrado do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Os deveres dos gersonitas serão os seguintes: ");
INSERT INTO poronbv_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Eles devem carregar as cortinas do Tabernáculo, o próprio Tabernáculo, a sua cobertura de couro de cabra e as cortinas da entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Devem carregar também as cortinas externas do pátio que cercam o Tabernáculo, o altar, a cortina da entrada e as suas cordas com todos os utensílios usados em seu serviço. ");
INSERT INTO poronbv_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Arão e seus filhos darão as ordens aos gersonitas a respeito do serviço deles, e tudo o que devem fazer e carregar. ");
INSERT INTO poronbv_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Este é o serviço do grupo de famílias dos gersonitas no Tabernáculo; Itamar, filho do sacerdote Arão, será responsável pela supervisão de suas atividades. ");
INSERT INTO poronbv_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Depois faça uma contagem dos meraritas por grupo de famílias e por famílias, ");
INSERT INTO poronbv_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","de todos os homens entre trinta e cinquenta anos, capazes de fazer algum trabalho no Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Esta é a tarefa deles, de acordo com todo o serviço no Tabernáculo: levar as armações do Tabernáculo, seus travessões, suas colunas e suas bases; ");
INSERT INTO poronbv_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","as colunas do pátio que cerca o Tabernáculo, as suas bases, as suas estacas e suas cordas, e todas as outras coisas usadas para montar o Tabernáculo e tudo que pertence ao seu serviço. Diga a cada um o que deve carregar. ");
INSERT INTO poronbv_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Esse é o serviço do grupo de famílias dos meraritas no Tabernáculo. Itamar, filho do sacerdote Arão, será o responsável pela supervisão dos meraritas”. ");
INSERT INTO poronbv_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moisés, Arão e os líderes do povo fizeram a contagem dos coatitas, conforme seus grupos de famílias e suas famílias, ");
INSERT INTO poronbv_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","de todos os homens que tinham entre trinta e cinquenta anos de idade e que fossem capazes de fazer algum serviço no Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","O total dos coatitas contados, conforme as suas famílias, foi de 2.750 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Esse foi o total de recenseados das famílias dos coatitas contados por Moisés e Arão, que serviam no Tabernáculo, para obedecer às ordens que o Senhor deu a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Os gersonitas foram contados conforme seus grupos de famílias e suas famílias, ");
INSERT INTO poronbv_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","de todos os homens entre trinta e cinquenta anos de idade e que fossem capazes de fazer algum serviço no Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","O total de gersonitas contados, conforme os grupos de famílias e as famílias, foi de 2.630 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Esse foi o total de recenseados das famílias dos gersonitas contados por Moisés e Arão, que serviam no Tabernáculo, para obedecer às ordens que o Senhor deu a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Os meraritas foram contados conforme seus grupos de famílias e suas famílias, ");
INSERT INTO poronbv_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","de todos os homens entre trinta e cinquenta anos de idade, que fossem capazes de fazer algum serviço no Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","O total de meraritas contados, conforme os grupos de famílias, foi de 3.200 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Esse foi o total de recenseados das famílias dos meraritas contados por Moisés e Arão, que serviam no Tabernáculo, para obedecer às ordens que o Senhor deu a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Assim Moisés, Arão e os líderes de Israel chegaram à contagem final dos levitas, conforme os grupos de famílias e as famílias; ");
INSERT INTO poronbv_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","todos os levitas entre trinta e cinquenta anos de idade, capazes de fazer algum serviço no Tabernáculo, ");
INSERT INTO poronbv_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","totalizaram 8.580 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Fizeram a designação dos serviços e das cargas de cada um, conforme o Senhor tinha ordenado a Moisés. Assim foram contados, de acordo com as ordens que o Senhor tinha dado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","E o Senhor deu mais ordens a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Diga aos israelitas que eles devem tirar todos os leprosos do acampamento, todos os que tiverem hemorragia, e todo impuro que tiver tocado em um cadáver. ");
INSERT INTO poronbv_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Isso vale tanto para homens como para mulheres. Tire essas pessoas do acampamento para que elas não contaminem o acampamento onde eu habito”. ");
INSERT INTO poronbv_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","E o povo de Israel obedeceu às instruções que o Senhor deu a Moisés e os tirou do acampamento. ");
INSERT INTO poronbv_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Diga ao povo de Israel: Quando um homem ou uma mulher prejudicar outra pessoa e, portanto, ofender o Senhor, será culpado. ");
INSERT INTO poronbv_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Confessará o pecado que cometeu, fará restituição completa, e acrescentará um quinto a esse valor e o dará à pessoa prejudicada. ");
INSERT INTO poronbv_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Mas, se a pessoa prejudicada não tiver parente próximo que possa receber a restituição, então o culpado deverá pagar ao Senhor, entregando a restituição ao sacerdote, junto com o sacrifício de um carneiro para obter o perdão do pecado. ");
INSERT INTO poronbv_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Sempre que os filhos de Israel trazem uma dádiva sagrada ao Senhor, isso pertencerá ao sacerdote. ");
INSERT INTO poronbv_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","As dádivas sagradas de uma pessoa pertencem a ela, mas o que ela der ao sacerdote deverá ficar com o sacerdote”. ");
INSERT INTO poronbv_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Diga também aos israelitas o seguinte: Se a esposa de um homem se desviar e for infiel a ele, ");
INSERT INTO poronbv_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","tiver relações sexuais com outro homem, esconder isso do marido e a impureza dela não for descoberta, não havendo testemunha contra ela, por não ter sido apanhada no ato, ");
INSERT INTO poronbv_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","se o marido dela tiver ciúmes e desconfiar de sua mulher, estando ela impura ou não, ");
INSERT INTO poronbv_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ele deve levar a esposa ao sacerdote com uma oferta de um jarro de farinha de cevada em favor dela. Não misturará com azeite nem colocará incenso sobre a farinha, porque é uma oferta de cereal pelo ciúme para revelar a verdade. ");
INSERT INTO poronbv_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“O sacerdote deve trazer a mulher diante do Senhor, ");
INSERT INTO poronbv_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","apanhar um pouco de água sagrada num jarro de barro e pegar um pouco da terra do chão do Tabernáculo e misturá-lo na água. ");
INSERT INTO poronbv_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ele apresentará a mulher perante o Senhor. Em seguida deverá soltar o cabelo da mulher e colocar nas mãos dela a oferta de suspeita para descobrir se a desconfiança do marido tem procedência ou não. O sacerdote deve ficar na frente da mulher segurando o jarro com a água amarga que traz a maldição. ");
INSERT INTO poronbv_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Então o sacerdote deve pedir à mulher que jure que é inocente e lhe dirá: ‘Se você não teve relações com nenhum outro homem a não ser o seu marido, nem cometeu algum ato que a tornou impura, então que esta água amarga, que traz maldição, não lhe faça mal. ");
INSERT INTO poronbv_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Mas, se você foi infiel durante o seu casamento e se tornou impura, por ter tido relações com outro homem, ");
INSERT INTO poronbv_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","então que o Senhor faça com que você seja objeto de maldição e desprezo no meio do seu povo, fazendo com que nunca mais tenha filhos e sua barriga fique inchada. ");
INSERT INTO poronbv_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Que esta água de maldição entre no seu estômago, inche a sua barriga e a impeça de ter filhos’. “Então a mulher deve dizer: ‘Que assim seja!’ ");
INSERT INTO poronbv_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Depois o sacerdote deve escrever essas maldições num livro e usar a água amarga para apagá-las. ");
INSERT INTO poronbv_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Ele fará a mulher beber a água amarga que traz maldição. Quando beber, a água lhe causará amargo sofrimento. ");
INSERT INTO poronbv_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Então o sacerdote pegará a oferta de suspeita, a moverá com um gesto ritual ao Senhor e a trará ao altar. ");
INSERT INTO poronbv_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Em seguida pegará um pouco da oferta com a mão e a queimará sobre o altar. Depois dará a água para a mulher beber. ");
INSERT INTO poronbv_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Se, de fato, a mulher foi infiel ao seu marido e ficou impura, quando o sacerdote fizer com que ela beba a água amarga que traz maldição, a água lhe causará amargo sofrimento; sua barriga inchará, ela será incapaz de ter filhos e será objeto de uma maldição no meio do seu povo. ");
INSERT INTO poronbv_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Porém, se a mulher não cometeu adultério, mas estiver pura, estará livre e poderá ter filhos. ");
INSERT INTO poronbv_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Essa é, pois, a lei para o caso de ciúmes, quando a mulher for infiel e se tornar impura, quando estiver casada, ");
INSERT INTO poronbv_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ou quando o homem, sem motivo, suspeitar de sua mulher; ele deve trazer a mulher perante o Senhor, e o sacerdote agirá de acordo com essa lei. ");
INSERT INTO poronbv_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","O homem ficará livre da culpa; mas se a mulher for culpada, sofrerá as consequências do seu pecado”. ");
INSERT INTO poronbv_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","O Senhor deu mais ordens a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Diga o seguinte aos filhos de Israel: Se um homem ou uma mulher fizer um voto especial de nazireu, isto é, de dedicar-se ao Senhor de uma maneira especial, ");
INSERT INTO poronbv_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","essa pessoa terá de abster-se de tomar vinho ou outra bebida alcoólica, e não poderá beber vinagre feito de vinho, nem vinagre de bebida forte; não poderá tomar suco de uva nem comer uvas frescas ou secas. ");
INSERT INTO poronbv_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Enquanto for nazireu, não poderá comer nada que venha da videira, nem mesmo as sementes ou as cascas das uvas. ");
INSERT INTO poronbv_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Durante todo o período do seu voto de nazireu não poderá cortar o seu cabelo, porque essa pessoa é consagrada e separada para o Senhor. Por isso deve deixar crescer livremente o cabelo. ");
INSERT INTO poronbv_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Durante o período do seu voto de nazireu não poderá aproximar-se de um cadáver. ");
INSERT INTO poronbv_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Mesmo que o seu pai, sua mãe, sua irmã ou o irmão morra, não poderá tornar-se impuro, chegando perto de algum cadáver, porque traz sobre a cabeça o seu voto de separação para Deus. ");
INSERT INTO poronbv_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Enquanto for nazireu, essa pessoa estará separada para o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Se alguém morrer repentinamente ao lado dele, contaminando o cabelo consagrado, ele terá de rapar a cabeça sete dias depois, porque foi contaminado. Este é o dia da purificação. ");
INSERT INTO poronbv_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","No oitavo dia, trará duas rolinhas ou dois filhotes de pombo ao sacerdote na entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","O sacerdote deve oferecer uma das aves como oferta pelo pecado, e a outra como oferta queimada, para obter o perdão dos pecados que cometeu quando se aproximou do cadáver. No mesmo dia, o nazireu deve fazer de novo os votos e deixar crescer o cabelo. ");
INSERT INTO poronbv_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Os dias que passaram desde o primeiro voto não têm mais valor, porque ficou contaminado durante a sua consagração. Ele se dedicará de novo ao serviço do Senhor pelo tempo de sua separação e deverá trazer um carneiro de um ano de idade como oferta para tirar a culpa. ");
INSERT INTO poronbv_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","No final do período do voto de separação para o Senhor, o nazireu deverá ir à entrada do Tabernáculo ");
INSERT INTO poronbv_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","e ali oferecerá a sua oferta ao Senhor: um cordeiro de um ano e sem defeito como oferta queimada, uma ovelha de um ano e sem defeito como oferta pelo pecado, um carneiro sem defeito como oferta de paz, ");
INSERT INTO poronbv_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","uma cesta de pão sem fermento, bolos feitos de farinha da melhor qualidade com azeite e pães finos untados com azeite, acompanhados da sua oferta de cereais e a oferta de bebidas. ");
INSERT INTO poronbv_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“O sacerdote deve apresentar essas ofertas ao Senhor na seguinte ordem: primeiro a oferta pelo pecado e a oferta queimada, ");
INSERT INTO poronbv_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","depois apresentará o carneiro como oferta de paz ao Senhor, junto com a cesta de pão sem fermento; e finalmente a oferta de cereais junto com a oferta de bebidas. ");
INSERT INTO poronbv_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Então o nazireu, à entrada do Tabernáculo, rapará o cabelo, que é o sinal do voto de separação, e o jogará no fogo que fica debaixo do sacrifício da oferta de paz. ");
INSERT INTO poronbv_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Depois que o nazireu rapar o cabelo do seu voto de separação, o sacerdote deve colocar nas mãos dele um ombro cozido do carneiro, um dos bolos feitos sem fermento e um pão fino, também feito sem fermento, que foram tirados da cesta. ");
INSERT INTO poronbv_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","O sacerdote moverá essas coisas perante o Senhor como ritual de apresentação; tudo isso é sagrado e pertence ao sacerdote, junto com o peito e com a coxa da oferta que foram apresentados ao Senhor. Depois disso o nazireu poderá beber vinho. ");
INSERT INTO poronbv_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Esta é a lei sobre o nazireu e sobre os sacrifícios no final do tempo de dedicação especial. Além desses sacrifícios, ele deve trazer qualquer outra oferta que prometeu quando fez o voto de nazireu”. ");
INSERT INTO poronbv_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","O Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Diga a Arão e aos seus filhos que eles devem abençoar os filhos de Israel da seguinte maneira: ");
INSERT INTO poronbv_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Que o Senhor os abençoe e proteja; ");
INSERT INTO poronbv_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","que o Senhor faça resplandecer o seu rosto sobre vocês e tenha misericórdia de vocês; ");
INSERT INTO poronbv_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","que o Senhor olhe para vocês com amor e lhes dê a paz. ");
INSERT INTO poronbv_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Esta é a maneira como Arão e seus filhos pedirão para que eu abençoe os filhos de Israel, e eu mesmo responderei e os abençoarei”. ");
INSERT INTO poronbv_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","No dia em que Moisés terminou de montar o Tabernáculo, ele o ungiu e o consagrou juntamente com todos os utensílios, inclusive o altar e os seus utensílios. ");
INSERT INTO poronbv_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Então os líderes de Israel, os chefes das tribos, os homens que fizeram a contagem, apresentaram, cada um, uma oferta. ");
INSERT INTO poronbv_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Eles trouxeram as suas dádivas ao Senhor: seis carroças cobertas e doze bois. Cada carroça era puxada por dois bois, ou seja, cada dois chefes ofereceram uma carroça, e cada um deles, um boi. E as apresentaram diante do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","O Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Receba as carroças e os bois deles para que sejam usados no trabalho do Tabernáculo. Dê as carroças aos levitas, para que eles usem no que for necessário”. ");
INSERT INTO poronbv_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Desse modo, Moisés recebeu as carroças e os bois e os entregou aos levitas. ");
INSERT INTO poronbv_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Duas carroças e quatro bois ficaram com os gersonitas, de acordo com o serviço que faziam, ");
INSERT INTO poronbv_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","e quatro carroças e oito bois ficaram com os meraritas, de acordo com o serviço que faziam. Itamar, filho de Arão, era o responsável por tomar conta dos gersonitas e dos meraritas. ");
INSERT INTO poronbv_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mas os coatitas não receberam nada de Moisés, porque o trabalho deles era carregar nos ombros os objetos sagrados pelos quais eram responsáveis. ");
INSERT INTO poronbv_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","No dia em que Moisés ungiu o altar, os líderes também trouxeram suas ofertas de dedicação do altar e as colocaram diante do altar. ");
INSERT INTO poronbv_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","O Senhor disse a Moisés: “Cada dia um dos líderes deverá trazer a sua oferta para a dedicação do altar”. ");
INSERT INTO poronbv_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Então, no primeiro dia veio Naassom, filho de Aminadabe, que pertencia à tribo de Judá, trazendo a sua oferta. ");
INSERT INTO poronbv_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","A oferta dele era um prato de prata de um quilo e quinhentos e sessenta gramas e uma bacia de prata para as aspersões, de oitocentos e quarenta gramas, segundo o peso padrão do santuário, cada um cheio de ofertas de cereais da melhor farinha amassada com óleo; ");
INSERT INTO poronbv_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","uma vasilha de ouro de cento e vinte gramas, cheia de incenso; ");
INSERT INTO poronbv_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","um novilho, um carneiro e um cordeiro de um ano de idade, para a oferta queimada; ");
INSERT INTO poronbv_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","um bode para a oferta pelo pecado; ");
INSERT INTO poronbv_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","e dois bois, cinco carneiros, cinco bodes e cinco cordeiros de um ano para serem oferecidos como sacrifício de paz. Essa foi a oferta de Naassom, filho de Aminadabe. ");
INSERT INTO poronbv_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","No segundo dia, Natanael, filho de Zuar e líder de Issacar, trouxe a sua oferta. ");
INSERT INTO poronbv_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","A oferta dele era um prato de prata de um quilo e quinhentos e sessenta gramas e uma bacia de prata para as aspersões, de oitocentos e quarenta gramas, segundo o peso padrão do santuário, cada um cheio de ofertas de cereais da melhor farinha amassada com óleo; ");
INSERT INTO poronbv_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","uma vasilha de ouro de cento e vinte gramas, cheia de incenso; ");
INSERT INTO poronbv_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","um novilho, um carneiro, e um cordeiro de um ano de idade para a oferta queimada; ");
INSERT INTO poronbv_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","um bode para a oferta pelo pecado; ");
INSERT INTO poronbv_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","e dois bois, cinco carneiros, cinco bodes e cinco cordeiros de um ano para serem oferecidos como sacrifício de paz. Essa foi a oferta de Natanael, filho de Zuar. ");
INSERT INTO poronbv_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","No terceiro dia chegou Eliabe, filho de Helom e líder da tribo de Zebulom, e trouxe a sua oferta. ");
INSERT INTO poronbv_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","A oferta dele era um prato de prata de um quilo e quinhentos e sessenta gramas e uma bacia de prata para as aspersões, de oitocentos e quarenta gramas, segundo o peso padrão do santuário, cada um cheio de ofertas de cereais da melhor farinha amassada com óleo; ");
INSERT INTO poronbv_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","uma vasilha de ouro de cento e vinte gramas, cheia de incenso; ");
INSERT INTO poronbv_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","um novilho, um carneiro e um cordeiro de um ano de idade para a oferta queimada; ");
INSERT INTO poronbv_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","um bode para a oferta pelo pecado; ");
INSERT INTO poronbv_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","e dois bois, cinco carneiros, cinco bodes e cinco cordeiros de um ano para serem oferecidos como sacrifício de paz. Essa foi a oferta de Eliabe, filho de Helom. ");
INSERT INTO poronbv_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Elizur, filho de Sedeur e líder de Rúben, veio no quarto dia e trouxe a sua oferta. ");
INSERT INTO poronbv_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","A oferta dele era um prato de prata de um quilo e quinhentos e sessenta gramas e uma bacia de prata para as aspersões, de oitocentos e quarenta gramas, segundo o peso padrão do santuário, cada um cheio de ofertas de cereais da melhor farinha amassada com óleo; ");
INSERT INTO poronbv_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","uma vasilha de ouro de cento e vinte gramas, cheia de incenso; ");
INSERT INTO poronbv_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","um novilho, um carneiro e um cordeiro de um ano de idade, para a oferta queimada; ");
INSERT INTO poronbv_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","um bode para a oferta pelo pecado; ");
INSERT INTO poronbv_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","e dois bois, cinco carneiros, cinco bodes e cinco cordeiros de um ano para serem oferecidos como sacrifício de paz. Essa foi a oferta de Elizur, filho de Sedeur. ");
INSERT INTO poronbv_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Da tribo de Simeão veio Selumiel, filho de Zurisadai e líder da tribo, no quinto dia. Ele também trouxe a sua oferta. ");
INSERT INTO poronbv_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","A oferta dele era um prato de prata de um quilo e quinhentos e sessenta gramas e uma bacia de prata para as aspersões, de oitocentos e quarenta gramas, segundo o peso padrão do santuário, cada um cheio de ofertas de cereais da melhor farinha amassada com óleo; ");
INSERT INTO poronbv_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","uma vasilha de ouro de cento e vinte gramas, cheia de incenso; ");
INSERT INTO poronbv_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","um novilho, um carneiro e um cordeiro de um ano de idade para a oferta queimada; ");
INSERT INTO poronbv_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","um bode para a oferta pelo pecado; ");
INSERT INTO poronbv_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","e dois bois, cinco carneiros, cinco bodes e cinco cordeiros de um ano para serem oferecidos como sacrifício de paz. Essa foi a oferta de Selumiel, filho de Zurisadai. ");
INSERT INTO poronbv_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","No sexto dia, chegou Eliasafe, filho de Deuel e líder da tribo de Gade. Ele também trouxe a sua oferta. ");
INSERT INTO poronbv_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","A oferta dele era um prato de prata de um quilo e quinhentos e sessenta gramas e uma bacia de prata para as aspersões, de oitocentos e quarenta gramas, segundo o peso padrão do santuário, cada um cheio de ofertas de cereais da melhor farinha amassada com óleo; ");
INSERT INTO poronbv_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","uma vasilha de ouro de cento e vinte gramas, cheia de incenso; ");
INSERT INTO poronbv_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","um novilho, um carneiro e um cordeiro de um ano de idade para a oferta queimada; ");
INSERT INTO poronbv_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","um bode para a oferta pelo pecado; ");
INSERT INTO poronbv_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","e dois bois, cinco carneiros, cinco bodes e cinco cordeiros de um ano para serem oferecidos como sacrifício de paz. Essa foi a oferta de Eliasafe, filho de Deuel. ");
INSERT INTO poronbv_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Elisama, líder da tribo de Efraim e filho de Amiúde, trouxe a sua oferta no sétimo dia. ");
INSERT INTO poronbv_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","A oferta dele era um prato de prata de um quilo e quinhentos e sessenta gramas e uma bacia de prata para as aspersões, de oitocentos e quarenta gramas, segundo o peso padrão do santuário, cada um cheio de ofertas de cereais da melhor farinha amassada com óleo; ");
INSERT INTO poronbv_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","uma vasilha de ouro de cento e vinte gramas, cheia de incenso; ");
INSERT INTO poronbv_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","um novilho, um carneiro e um cordeiro de um ano de idade para a oferta queimada; ");
INSERT INTO poronbv_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","um bode para a oferta pelo pecado; ");
INSERT INTO poronbv_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","e dois bois, cinco carneiros, cinco bodes e cinco cordeiros de um ano para serem oferecidos como sacrifício de paz. Essa foi a oferta de Elisama, filho de Amiúde. ");
INSERT INTO poronbv_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","No oitavo dia veio o líder da tribo de Manassés, Gamaliel, filho de Pedazur, trazendo a sua oferta. ");
INSERT INTO poronbv_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","A oferta dele era um prato de prata de um quilo e quinhentos e sessenta gramas e uma bacia de prata para as aspersões, de oitocentos e quarenta gramas, segundo o peso padrão do santuário, cada um cheio de ofertas de cereais da melhor farinha amassada com óleo; ");
INSERT INTO poronbv_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","uma vasilha de ouro de cento e vinte gramas, cheia de incenso; ");
INSERT INTO poronbv_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","um novilho, um carneiro e um cordeiro de um ano de idade para a oferta queimada; ");
INSERT INTO poronbv_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","um bode para a oferta pelo pecado; ");
INSERT INTO poronbv_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","e dois bois, cinco carneiros, cinco bodes e cinco cordeiros de um ano para serem oferecidos como sacrifício de paz. Essa foi a oferta de Gamaliel, filho de Pedazur. ");
INSERT INTO poronbv_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","No nono dia foi a vez de Abidã, filho de Gideoni e líder da tribo de Benjamim, trazer a sua oferta. ");
INSERT INTO poronbv_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","A oferta dele era um prato de prata de um quilo e quinhentos e sessenta gramas e uma bacia de prata para as aspersões, de oitocentos e quarenta gramas, segundo o peso padrão do santuário, cada um cheio de ofertas de cereais da melhor farinha amassada com óleo; ");
INSERT INTO poronbv_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","uma vasilha de ouro de cento e vinte gramas, cheia de incenso; ");
INSERT INTO poronbv_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","um novilho, um carneiro e um cordeiro de um ano de idade para a oferta queimada; ");
INSERT INTO poronbv_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","um bode para a oferta pelo pecado; ");
INSERT INTO poronbv_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","e dois bois, cinco carneiros, cinco bodes e cinco cordeiros de um ano para serem oferecidos como sacrifício de paz. Essa foi a oferta de Abidã, filho de Gideoni. ");
INSERT INTO poronbv_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Aiezer, filho de Amisadai, chegou no décimo dia com a sua oferta. Ele era líder da tribo de Dã. ");
INSERT INTO poronbv_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","A oferta dele era um prato de prata de um quilo e quinhentos e sessenta gramas e uma bacia de prata para as aspersões, de oitocentos e quarenta gramas, segundo o peso padrão do santuário, cada um cheio de ofertas de cereais da melhor farinha amassada com óleo; ");
INSERT INTO poronbv_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","uma vasilha de ouro de cento e vinte gramas, cheia de incenso; ");
INSERT INTO poronbv_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","um novilho, um carneiro e um cordeiro de um ano de idade para a oferta queimada; ");
INSERT INTO poronbv_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","um bode para a oferta pelo pecado; ");
INSERT INTO poronbv_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","e dois bois, cinco carneiros, cinco bodes e cinco cordeiros de um ano para serem oferecidos como sacrifício de paz. Essa foi a oferta de Aiezer, filho de Amisadai. ");
INSERT INTO poronbv_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","No dia seguinte, ou seja, no décimo primeiro dia, chegou Pagiel, líder da tribo de Aser e filho de Ocrã, com a sua oferta. ");
INSERT INTO poronbv_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","A oferta dele era um prato de prata de um quilo e quinhentos e sessenta gramas e uma bacia de prata para as aspersões, de oitocentos e quarenta gramas, segundo o peso padrão do santuário, cada um cheio de ofertas de cereais da melhor farinha amassada com óleo; ");
INSERT INTO poronbv_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","uma vasilha de ouro de cento e vinte gramas, cheia de incenso; ");
INSERT INTO poronbv_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","um novilho, um carneiro e um cordeiro de um ano de idade para a oferta queimada; ");
INSERT INTO poronbv_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","um bode para a oferta pelo pecado; ");
INSERT INTO poronbv_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","e dois bois, cinco carneiros, cinco bodes e cinco cordeiros de um ano para serem oferecidos como sacrifício de paz. Essa foi a oferta de Pagiel, filho de Ocrã. ");
INSERT INTO poronbv_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","E, no último dia, no décimo segundo dia, veio Aira, líder da tribo de Naftali e filho de Enã, com a sua oferta. ");
INSERT INTO poronbv_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","A oferta dele era um prato de prata de um quilo e quinhentos e sessenta gramas e uma bacia de prata para as aspersões, de oitocentos e quarenta gramas, segundo o peso padrão do santuário, cada um cheio de ofertas de cereais da melhor farinha amassada com óleo; ");
INSERT INTO poronbv_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","uma vasilha de ouro de cento e vinte gramas, cheia de incenso; ");
INSERT INTO poronbv_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","um novilho, um carneiro e um cordeiro de um ano de idade para a oferta queimada; ");
INSERT INTO poronbv_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","um bode para a oferta pelo pecado; ");
INSERT INTO poronbv_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","e dois bois, cinco carneiros, cinco bodes e cinco cordeiros de um ano para serem oferecidos como sacrifício de paz. Essa foi a oferta de Aira, filho de Enã. ");
INSERT INTO poronbv_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Essas foram as ofertas dos líderes de Israel para a dedicação do altar, no dia em que foi ungido: doze pratos de prata, doze bacias de prata para as aspersões e doze vasilhas de ouro. ");
INSERT INTO poronbv_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Cada prato de prata pesava um quilo e quinhentos e sessenta gramas, e cada bacia pesava oitocentos e quarenta gramas. O total dos utensílios de prata pesava vinte e oito quilos e oitocentos gramas, tendo como padrão o peso do santuário. ");
INSERT INTO poronbv_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","As doze vasilhas de ouro cheias de incenso pesavam cada uma cento e vinte gramas, tendo como base o peso padrão do santuário. Todo ouro das vasilhas foi de um quilo e quatrocentos e quarenta gramas. ");
INSERT INTO poronbv_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","O total de animais oferecidos como ofertas queimadas foi: doze novilhos, doze carneiros e doze cordeiros de um ano de idade, junto com as ofertas de cereais. Foram trazidos doze bodes para a oferta pelo pecado. ");
INSERT INTO poronbv_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","E para os sacrifícios de paz eles trouxeram: vinte e quatro bois, sessenta carneiros, sessenta bodes e sessenta cordeiros de um ano de idade. Essas foram as ofertas trazidas para a dedicação do altar, depois que ele foi ungido. ");
INSERT INTO poronbv_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Sempre que Moisés entrava no Tabernáculo para falar com o Senhor, ele ouvia a voz que falava com ele de cima da tampa da arca da aliança, entre os dois querubins. Era assim que o Senhor falava com Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","O Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Diga o seguinte a Arão: Quando você colocar as sete lâmpadas, elas deverão iluminar a área da frente do candelabro”. ");
INSERT INTO poronbv_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","E assim fez Arão: colocou as lâmpadas de modo que estivessem voltadas para a frente do candelabro, como o Senhor havia ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Todo o candelabro foi feito de ouro batido, desde a base até os detalhes das flores, de acordo com o modelo que o Senhor tinha mostrado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Separe os levitas do meio do povo de Israel e purifique-os. ");
INSERT INTO poronbv_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Proceda da seguinte maneira em relação à purificação: você jogará água da purificação sobre eles, e eles cortarão o pelo do corpo e lavarão a roupa. Assim ficarão purificados. ");
INSERT INTO poronbv_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Em seguida, eles tomarão um novilho com a oferta de cereais, feita da melhor farinha, amassada com óleo; você, porém, tomará outro novilho como oferta pelo pecado. ");
INSERT INTO poronbv_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Traga os levitas até a porta do Tabernáculo para que todo o povo de Israel os veja. ");
INSERT INTO poronbv_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Em seguida você levará os levitas perante o Senhor, e os israelitas colocarão as mãos sobre as cabeças deles. ");
INSERT INTO poronbv_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Arão apresentará os levitas ao Senhor como oferta ritualmente movida da parte dos filhos de Israel, para que trabalhem no serviço do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Depois disso, os levitas colocarão as mãos sobre a cabeça dos dois novilhos, e você oferecerá um novilho como oferta pelo pecado e o outro como oferta queimada ao Senhor para purificar os levitas. ");
INSERT INTO poronbv_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Então você colocará os levitas em pé perante Arão e seus filhos, e os apresentará como oferta ritualmente movida ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Desse modo você separará os levitas do meio do povo de Israel, e os levitas serão meus. ");
INSERT INTO poronbv_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Depois disso, eles estarão prontos para ministrar no Tabernáculo; e você os purificará e os apresentará por meio de oferta movida. ");
INSERT INTO poronbv_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Os levitas foram separados do meio do povo de Israel para serem meus, em lugar de todo filho mais velho de cada família de Israel. ");
INSERT INTO poronbv_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Porque todo filho mais velho de cada família do povo de Israel e de cada cria de todo animal é meu. Eu os separei para mim quando feri os filhos mais velhos de cada família do Egito, ");
INSERT INTO poronbv_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","e escolhi os levitas em lugar dos filhos mais velhos de cada família do povo de Israel. ");
INSERT INTO poronbv_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Agora entrego os levitas a Arão e aos seus filhos; eles ministrarão no Tabernáculo em nome dos israelitas, para obterem o perdão dos pecados e para protegerem os israelitas de alguma desgraça quando se aproximarem do Tabernáculo”. ");
INSERT INTO poronbv_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Dessa maneira, Moisés, Arão e todo o povo de Israel fizeram com os levitas de acordo com as ordens que o Senhor tinha dado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Os levitas se purificaram e lavaram as suas roupas. E Arão apresentou os levitas por oferta movida ao Senhor e fez os sacrifícios para obter o perdão dos pecados por eles, para purificá-los. ");
INSERT INTO poronbv_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Depois disso os levitas foram ao Tabernáculo para ministrar sob a supervisão de Arão e seus filhos. Fizeram tudo como o Senhor havia ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","O Senhor também disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Só poderão ministrar no Tabernáculo os levitas que tiverem entre vinte e cinco e cinquenta anos de idade. ");
INSERT INTO poronbv_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Mas desde a idade de cinquenta anos deverão afastar-se da atividade regular e nela nunca mais trabalharão. ");
INSERT INTO poronbv_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Eles poderão ajudar seus colegas no trabalho de cuidar do Tabernáculo, mas eles mesmos não deverão fazer o trabalho. Assim você deverá designar as responsabilidades dos levitas”. ");
INSERT INTO poronbv_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","No primeiro mês do segundo ano depois da saída do Egito, o Senhor deu as seguintes instruções a Moisés, quando o povo de Israel estava no deserto do Sinai: ");
INSERT INTO poronbv_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“O povo de Israel deve festejar a Páscoa no tempo certo. ");
INSERT INTO poronbv_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","No décimo quarto dia deste mês, começando ao anoitecer, no tempo determinado, celebrem a Páscoa, de acordo com todas as leis e ordens a respeito dela”. ");
INSERT INTO poronbv_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Então Moisés ordenou ao povo de Israel que celebrasse a Páscoa. ");
INSERT INTO poronbv_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","E os israelitas celebraram a Páscoa no deserto do Sinai, no fim da tarde do décimo quarto dia do primeiro mês, de acordo com as instruções que o Senhor tinha dado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Aconteceu que alguns homens haviam tocado num cadáver e, por isso, não puderam celebrar a Páscoa naquele dia. Então eles procuraram Moisés e Arão naquele dia ");
INSERT INTO poronbv_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","e disseram a Moisés: “Tocamos no cadáver de um homem e, por isso, nos tornamos impuros. Mas por que não podemos apresentar nosso sacrifício ao Senhor, no tempo oportuno com os outros israelitas?” ");
INSERT INTO poronbv_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Então Moisés respondeu: “Esperem aqui até que eu ouça o que o Senhor ordena a vocês”. ");
INSERT INTO poronbv_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Então o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Diga o seguinte aos filhos de Israel: Quando algum de vocês ou dos seus descendentes se tornar impuro por ter tocado num cadáver ou estiver viajando, ainda assim deve celebrar a Páscoa do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Deverão celebrá-la um mês depois, no décimo quarto dia do segundo mês, ao entardecer. Comerão o carneiro com os pães sem fermento e com ervas amargas. ");
INSERT INTO poronbv_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Não deverão deixar nada para a manhã seguinte, nem deverão quebrar um osso do cordeiro, pois deverão obedecer todas as ordens a respeito da Páscoa. ");
INSERT INTO poronbv_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Se, porém, um homem não estiver impuro, nem estiver viajando, e ainda assim não quiser celebrar a Páscoa no dia determinado, deverá ser eliminado do meio do seu povo porque não apresentou a oferta ao Senhor no tempo certo. Essa pessoa sofrerá as consequências desse pecado. ");
INSERT INTO poronbv_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Se um estrangeiro estiver habitando entre vocês e quiser celebrar a Páscoa do Senhor, deve obedecer às mesmas instruções da Páscoa, porque existe uma só lei para o estrangeiro e para o natural da terra”. ");
INSERT INTO poronbv_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","No dia em que armaram o Tabernáculo, a saber, a tenda do Testemunho, a nuvem o cobriu. Desde a tarde até a manhã a nuvem permaneceu sobre o Tabernáculo com a aparência de fogo. ");
INSERT INTO poronbv_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Era sempre assim que acontecia: de dia a nuvem ficava sobre o Tabernáculo, e de noite a nuvem tinha a aparência de fogo. ");
INSERT INTO poronbv_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Os filhos de Israel se preparavam para marchar sempre que a nuvem se levantava, e viajavam até que a nuvem parasse, e ali acampavam. ");
INSERT INTO poronbv_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Dessa maneira sabiam quando o Senhor queria que viajassem e quando queria que acampassem. Enquanto a nuvem permanecia em cima do Tabernáculo, eles permaneciam acampados. ");
INSERT INTO poronbv_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Se a nuvem ficava por muito tempo sobre o Tabernáculo, os israelitas cumpriam a ordem do Senhor e não partiam. ");
INSERT INTO poronbv_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Às vezes, a nuvem permanecia sobre o Tabernáculo poucos dias; assim, conforme a ordem do Senhor, permaneciam acampados, e, segundo a ordem do Senhor, partiam. ");
INSERT INTO poronbv_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Às vezes, a nuvem permanecia somente desde o entardecer até a manhã seguinte. Quando ela se levantava de manhã, o povo partia. Sempre que a nuvem se levantava, tanto de dia como de noite, o povo de Israel partia. ");
INSERT INTO poronbv_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Mas, se a nuvem permanecia sobre o Tabernáculo dois dias, um mês, ou um ano, os israelitas permaneciam acampados e não partiam. Mas assim que a nuvem se erguia, eles partiam. ");
INSERT INTO poronbv_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Acampavam e partiam sempre de acordo com a ordem do Senhor. Tudo o que o Senhor ordenava a Moisés, eles faziam. ");
INSERT INTO poronbv_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","E o Senhor ordenou a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Faça duas trombetas de prata batida que terão duas funções: elas devem ser usadas para reunir o povo e para dar a ordem para a partida do acampamento. ");
INSERT INTO poronbv_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Quando as duas trombetas forem tocadas, todo o povo deve se reunir na entrada do Tabernáculo, ");
INSERT INTO poronbv_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","mas, se tocar uma só trombeta, apenas os líderes das tribos se reunirão diante de você. ");
INSERT INTO poronbv_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Para distinguir entre o sinal para reunir o povo e o sinal para desmontar o acampamento e partir, serão necessários toques diferentes de trombeta. Quando tocar sons curtos e fortes, as tribos acampadas a leste deverão partir. ");
INSERT INTO poronbv_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ao som do segundo toque, as tribos do sul começarão a partir. Os toques curtos e fortes são o sinal para partir. ");
INSERT INTO poronbv_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Para reunir o povo, deverão ser dados toques longos. ");
INSERT INTO poronbv_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Só os sacerdotes, descendentes de Arão, poderão tocar as trombetas. Essa é uma lei permanente, para ser passada de pai para filho. ");
INSERT INTO poronbv_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Quando estiverem na terra de vocês e forem lutar contra os seus inimigos que os estiveram oprimindo, toquem as trombetas, e o Senhor, o seu Deus, se lembrará de vocês e os libertará dos seus inimigos. ");
INSERT INTO poronbv_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Também toquem as trombetas nas horas de alegria, isto é, durante as festas anuais e no início de cada mês, quando apresentarem as ofertas queimadas e as ofertas de paz, e elas servirão de memorial em favor de vocês, da aliança que ele fez com vocês. Eu sou o Senhor, o Deus de vocês”. ");
INSERT INTO poronbv_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","No vigésimo dia do segundo mês do segundo ano a nuvem se levantou de cima do Tabernáculo, ");
INSERT INTO poronbv_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","e os israelitas partiram do deserto do Sinai, viajando por etapas, até que a nuvem parou no deserto de Parã. ");
INSERT INTO poronbv_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Essa foi a primeira viagem que fizeram depois que receberam as ordens do Senhor anunciadas a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Primeiro partiu a bandeira de Judá com o exército da tribo logo atrás. O líder do exército era Naassom, filho de Aminadabe. ");
INSERT INTO poronbv_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Natanael, filho de Zuar, era o líder do exército de Issacar, ");
INSERT INTO poronbv_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","e Eliabe, filho de Helom, era o comandante do exército de Zebulom. ");
INSERT INTO poronbv_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Então os gersonitas e os meraritas desmontaram o Tabernáculo e partiram. ");
INSERT INTO poronbv_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Depois os exércitos do acampamento de Rúben partiram, junto à sua bandeira. O comandante do exército de Rúben era Elizur, filho de Sedeur. ");
INSERT INTO poronbv_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","O comandante do exército de Simeão era Selumiel, filho de Zurisadai, ");
INSERT INTO poronbv_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","e o comandante do exército de Gade era Elisafe, filho de Deuel. ");
INSERT INTO poronbv_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","A seguir os coatitas partiram carregando os objetos sagrados do Tabernáculo. O Tabernáculo já estava montado no novo acampamento quando os coatitas chegavam com os objetos sagrados. ");
INSERT INTO poronbv_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Depois partiram do acampamento os exércitos da tribo de Efraim, junto à sua bandeira. Elisama, filho de Amiúde, era o comandante desse exército; ");
INSERT INTO poronbv_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel, filho de Pedazur, comandante dos exércitos da tribo de Manassés, ");
INSERT INTO poronbv_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","e Abidã, filho de Gideoni, dos exércitos da tribo de Benjamim. ");
INSERT INTO poronbv_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Finalmente, atrás das últimas três tribos partiram os exércitos do acampamento de Dã, junto à sua bandeira, que era comandado por Aiezer, filho de Amisadai. ");
INSERT INTO poronbv_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagiel, filho de Ocrã, era o comandante do exército de Aser, ");
INSERT INTO poronbv_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","e Aira, filho de Enã, do exército da tribo de Naftali. ");
INSERT INTO poronbv_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Essa era a ordem em que os exércitos dos filhos de Israel seguiam quando estavam marchando. ");
INSERT INTO poronbv_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Um dia Moisés disse a Hobabe, filho do midianita Reuel, sogro de Moisés: “Estamos viajando para o lugar a respeito do qual o Senhor disse: ‘Eu o darei a vocês!’ Venha conosco e seremos bons para você, pois o Senhor tem feito promessas maravilhosas a Israel!” ");
INSERT INTO poronbv_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Mas Hobabe respondeu: “Não posso, porque preciso voltar para a minha terra e para os meus parentes”. ");
INSERT INTO poronbv_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Moisés, porém, insistiu: “Fique conosco, porque você sabe onde devemos acampar, e será de grande ajuda para nós. ");
INSERT INTO poronbv_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Se você vier conosco, participará de todos os benefícios que nos forem concedidos pelo Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Então eles partiram do monte do Senhor e viajaram durante três dias. E a arca da aliança do Senhor ia à frente deles para preparar um novo lugar para o povo descansar. ");
INSERT INTO poronbv_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","A nuvem do Senhor ficava sobre eles de dia quando partiam do acampamento. ");
INSERT INTO poronbv_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Sempre que a arca partia, Moisés exclamava: “Levante, ó Senhor. Sejam espalhados os seus inimigos, e fujam da sua presença os seus adversários”. ");
INSERT INTO poronbv_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","E quando a arca parava, ele dizia: “Volte, ó Senhor, para ficar com os milhares dos filhos de Israel”. ");
INSERT INTO poronbv_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Mas logo o povo começou a se queixar dos sofrimentos, e o Senhor ouviu a sua queixa. O Senhor ficou irado e fez cair fogo que queimou as extremidades do acampamento. ");
INSERT INTO poronbv_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","O povo então clamou a Moisés, que orou ao Senhor, e o fogo se apagou. ");
INSERT INTO poronbv_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Por isso aquele lugar foi chamado de Taberá, porque o fogo do Senhor queimou no meio deles. ");
INSERT INTO poronbv_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Um grupo de estrangeiros que havia no meio deles estava com muita vontade de comer carne, e até os próprios israelitas voltaram a reclamar, dizendo: “Ah, se tivéssemos carne para comer! ");
INSERT INTO poronbv_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Lembramo-nos dos peixes que comíamos de graça no Egito, além dos pepinos, dos melões, dos alhos silvestres, das cebolas e dos alhos. ");
INSERT INTO poronbv_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Mas agora não temos mais força, e todos os dias temos de comer este maná!” ");
INSERT INTO poronbv_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","O maná era como uma semente de coentro e tinha a aparência de resina da casca de uma árvore. ");
INSERT INTO poronbv_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Para apanhar o maná, o povo se espalhava pelo acampamento e recolhia o maná do chão; moía-o num moinho manual e o socava em pilões para fazer a farinha do maná; depois cozinhava o maná e fazia bolos. O gosto do maná era parecido com o bolo amassado com azeite. ");
INSERT INTO poronbv_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Quando, à noite, descia o orvalho sobre o acampamento, caía junto o maná. ");
INSERT INTO poronbv_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moisés ouviu o choro do povo. Cada família chorava na entrada da sua tenda. Então o Senhor ficou muito irado, e Moisés também estava descontente com o povo. ");
INSERT INTO poronbv_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Moisés perguntou ao Senhor: “Por que o Senhor me faz sofrer e não ajuda este seu servo, colocando sobre os meus ombros a responsabilidade por todo esse povo? ");
INSERT INTO poronbv_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Por acaso eles são meus filhos? Por acaso sou pai deles? Por que me pede para carregar o povo no colo, como uma babá carrega um recém-nascido, para levá-lo à terra que o Senhor prometeu sob juramento aos seus antepassados? ");
INSERT INTO poronbv_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Onde vou conseguir carne para todo esse povo? Pois eles ficam se queixando a mim, dizendo: ‘Dê-nos carne para comer!’ ");
INSERT INTO poronbv_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Sozinho não consigo cuidar de todo esse povo, pois a tarefa é pesada demais para mim. ");
INSERT INTO poronbv_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Se o Senhor vai continuar a tratar-me dessa maneira, mate-me agora mesmo; se o Senhor se agrada de mim, não me deixe ver a minha própria ruína”. ");
INSERT INTO poronbv_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Então o Senhor disse a Moisés: “Reúna diante de mim setenta líderes de Israel, entre os mais respeitados do povo de Israel. Leve-os diante do Tabernáculo para que estejam ali com você. ");
INSERT INTO poronbv_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Então descerei e falarei com você; e tirarei do Espírito que está sobre você para colocar também sobre eles. Eles o ajudarão a levar o pesado fardo de cuidar do povo, de modo que você não precisará fazer tudo sozinho. ");
INSERT INTO poronbv_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“E diga ao povo: Purifiquem-se, porque amanhã vocês terão carne para comer. O Senhor ouviu o choro de vocês, dizendo: ‘Ah, se tivéssemos carne para comer! Passávamos bem no Egito!’ Por isso o Senhor lhes dará carne, e vocês a comerão. ");
INSERT INTO poronbv_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Vocês não comerão carne apenas um dia, nem dois, nem cinco, nem dez ou vinte dias, ");
INSERT INTO poronbv_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","mas um mês inteiro, até que lhes saia carne pelo nariz, e vocês sentirão nojo dela. E isto ocorrerá porque rejeitaram o Senhor que está no meio de vocês, e se queixaram diante dele, dizendo: ‘Por que saímos do Egito?’ ” ");
INSERT INTO poronbv_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mas Moisés disse: “São 600.000 homens, e o Senhor diz: ‘Darei a eles carne para comerem durante um mês inteiro!’ ");
INSERT INTO poronbv_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Se matássemos todos os nossos rebanhos de ovelhas e gado, ainda faltaria carne! Será que todos os peixes do mar poderiam alimentar essa gente?” ");
INSERT INTO poronbv_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Então o Senhor disse a Moisés: “Será que o poder do Senhor é limitado? Agora você verá se a minha palavra se cumpre ou não!” ");
INSERT INTO poronbv_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Então Moisés saiu e contou ao povo as palavras do Senhor, e reuniu os setenta líderes do povo ao redor do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","E o Senhor desceu na nuvem e falou a Moisés, e tirou do espírito que estava sobre Moisés e o colocou sobre os setenta líderes. Quando o Espírito veio sobre os líderes, eles profetizaram, porém isso durou pouco tempo. ");
INSERT INTO poronbv_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Mas dois homens dos setenta, chamados Eldade e Medade, ainda estavam no acampamento e não foram até o Tabernáculo, quando o Espírito veio sobre eles e profetizaram. ");
INSERT INTO poronbv_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Então um jovem correu e contou a Moisés: “Eldade e Medade estão profetizando no acampamento”. ");
INSERT INTO poronbv_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Josué, filho de Num, que desde jovem era um dos ajudantes de Moisés, disse: “Moisés, meu senhor, proíba os dois de profetizarem!” ");
INSERT INTO poronbv_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mas Moisés respondeu: “Você está com ciúmes por causa de mim? Que bom seria se todo o povo do Senhor fosse profeta e que o Senhor pusesse o seu Espírito sobre eles!” ");
INSERT INTO poronbv_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Então Moisés voltou ao acampamento junto com os líderes de Israel. ");
INSERT INTO poronbv_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","E o Senhor mandou um vento que trouxe codornizes do lado do mar e as espalhou por todo o acampamento, a uma altura de noventa centímetros, em todas as direções, num raio de um dia de caminhada. ");
INSERT INTO poronbv_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Então o povo começou a recolher as codornizes durante todo aquele dia e à noite e no dia seguinte. A pessoa que recolheu menos codornizes recolheu dez barris. E o povo estendeu as codornizes para secar em volta do acampamento. ");
INSERT INTO poronbv_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Mas quando a carne ainda estava entre os seus dentes, a ira do Senhor acendeu-se contra o povo, e os castigou com uma terrível epidemia que matou muita gente. ");
INSERT INTO poronbv_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Por isso, chamaram aquele lugar de Haatavá, porque ali foram enterrados os que tinham grande desejo de comer carne. ");
INSERT INTO poronbv_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","De lá o povo viajou para Hazerote, onde ficaram algum tempo. ");
INSERT INTO poronbv_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Um dia Miriã e Arão criticaram Moisés porque ele tinha se casado com uma mulher cusita e disseram: ");
INSERT INTO poronbv_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“Será que o Senhor só fala por meio de Moisés? Ele também não tem falado por meio de nós?” E o Senhor ouviu isso. ");
INSERT INTO poronbv_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Ora, Moisés era um homem muito manso, mais do que qualquer outro homem que havia na terra. ");
INSERT INTO poronbv_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Imediatamente o Senhor disse a Moisés, a Arão e a Miriã: “Vocês três, venham até o Tabernáculo”. E os três foram para lá. ");
INSERT INTO poronbv_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Então o Senhor desceu numa coluna de nuvem, ficou na entrada do Tabernáculo e chamou Arão e Miriã. Quando ambos se apresentaram, ");
INSERT INTO poronbv_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ele disse: “Ouçam as minhas palavras: Quando há um profeta entre vocês, eu, o Senhor, me revelo a ele por meio de visões e falo com ele em sonhos. ");
INSERT INTO poronbv_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","“Não é assim, porém, com o meu servo Moisés, que é fiel em toda a minha casa. ");
INSERT INTO poronbv_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Com ele falo face a face, claramente, e não por meio de figuras; e ele chegou a ver a forma do Senhor. Por que não tiveram medo em criticar meu servo Moisés?” ");
INSERT INTO poronbv_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","E a ira do Senhor se acendeu contra eles, e ele se retirou. ");
INSERT INTO poronbv_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Enquanto a nuvem saía de cima do Tabernáculo, Miriã de repente ficou com lepra e com a pele branca como a neve. Quando Arão viu que Miriã estava com lepra, ");
INSERT INTO poronbv_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","disse a Moisés: “Por favor, meu senhor, não nos castigue por causa deste pecado. De fato fomos tolos e pecamos. ");
INSERT INTO poronbv_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Não deixe que Miriã seja como um feto abortado que nasce com a metade do corpo destruído”. ");
INSERT INTO poronbv_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Então Moisés clamou ao Senhor: “Ó Deus, eu peço que a cure!” ");
INSERT INTO poronbv_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","E o Senhor respondeu a Moisés: “Se o pai dela tivesse cuspido no rosto dela, ela não estaria contaminada durante sete dias? Então que Miriã fique isolada fora do acampamento por sete dias e depois poderá voltar”. ");
INSERT INTO poronbv_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Dessa forma, puseram Miriã para fora do acampamento por uma semana, e o povo não partiu enquanto ela não foi trazida de volta. ");
INSERT INTO poronbv_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Depois disso, partiram de Hazerote e foram para o deserto de Parã, onde acamparam. ");
INSERT INTO poronbv_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Envie alguns espiões para a terra de Canaã, terra que estou dando aos israelitas. Você deve enviar um líder de cada tribo dos seus antepassados”. ");
INSERT INTO poronbv_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moisés fez conforme a ordem do Senhor e os enviou do deserto de Parã. Todos eram líderes das tribos do povo de Israel. ");
INSERT INTO poronbv_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","São estes os seus nomes: Samua, filho de Zacur, da tribo de Rúben; ");
INSERT INTO poronbv_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Safate, filho de Hori, da tribo de Simeão; ");
INSERT INTO poronbv_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Calebe, filho de Jefoné, da tribo de Judá; ");
INSERT INTO poronbv_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Jigeal, filho de José, da tribo de Issacar; ");
INSERT INTO poronbv_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Oseias, filho de Num, da tribo de Efraim; ");
INSERT INTO poronbv_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Palti, filho de Rafu, da tribo de Benjamim; ");
INSERT INTO poronbv_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Gadiel, filho de Sodi, da tribo de Zebulom; ");
INSERT INTO poronbv_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gadi, filho de Susi, da tribo de José, isto é, da tribo de Manassés; ");
INSERT INTO poronbv_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Amiel, filho de Gemali, da tribo de Dã; ");
INSERT INTO poronbv_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Setur, filho de Micael, da tribo de Aser; ");
INSERT INTO poronbv_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nabi, filho de Vofsi, da tribo de Naftali; e ");
INSERT INTO poronbv_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Güel, filho de Maqui, da tribo de Gade. ");
INSERT INTO poronbv_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","São esses os nomes dos homens que Moisés enviou para espionar a terra. Foi nessa época que Moisés mudou o nome de Oseias, filho de Num, para Josué. ");
INSERT INTO poronbv_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moisés enviou os espiões para a terra de Canaã com as seguintes instruções: “Vão para o norte até o Neguebe e atravessem as montanhas, ");
INSERT INTO poronbv_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","voltando com informações sobre a terra. Vejam também como é o povo que mora lá, se é forte ou fraco, se são muitos ou poucos; ");
INSERT INTO poronbv_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Vejam também se a terra em que habitam é fértil ou não; se as cidades em que vivem são acampamentos ou se são fortificadas; ");
INSERT INTO poronbv_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","se a terra é rica ou pobre e se existem muitas árvores ou não. Sejam corajosos e tragam alguns frutos da terra”. Era a época da colheita das uvas. ");
INSERT INTO poronbv_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Eles subiram e observaram a terra desde o deserto de Zim até Reobe, que fica próximo de Hamate. ");
INSERT INTO poronbv_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","A caminho do norte, passaram pelo Neguebe e chegaram a Hebrom, onde viviam as famílias de Aimã, Sesai e Talmai, descendentes de Enaque. A propósito, Hebrom era muito antiga e foi fundada sete anos antes de Zoã, no Egito. ");
INSERT INTO poronbv_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Depois chegaram até o vale de Escol, onde apanharam um cacho de uvas tão grande que foram necessários dois homens para carregá-lo, pendurado numa vara. Colheram também romãs e figos. ");
INSERT INTO poronbv_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Esse lugar foi chamado de vale de Escol, por causa do cacho de uvas que os israelitas cortaram ali. ");
INSERT INTO poronbv_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ao fim de quarenta dias, voltaram de espionar a terra, ");
INSERT INTO poronbv_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","e fizeram um relatório a Moisés, a Arão e a todo o povo de Israel que estava no deserto de Parã, em Cades, e mostraram os frutos da terra. ");
INSERT INTO poronbv_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Este foi o relatório que fizeram a Moisés: “Entramos na terra à qual você nos enviou, e é de fato um lugar maravilhoso, uma terra que produz muito leite e mel! Aqui estão alguns frutos dela. ");
INSERT INTO poronbv_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mas o povo de lá é poderoso e as cidades são muito grandes e fortificadas. Também vimos lá os descendentes de Enaque. ");
INSERT INTO poronbv_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Os amalequitas vivem no sul, na terra do Neguebe; enquanto os heteus, os jebuseus e os amorreus vivem na zona montanhosa, e os cananeus moram no litoral e no vale do rio Jordão”. ");
INSERT INTO poronbv_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Mas Calebe pediu ao povo que estava ali diante de Moisés que se calasse, e disse: “Vamos partir e tomar a terra, porque é certo que vamos conquistá-la!” ");
INSERT INTO poronbv_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mas os outros espiões que tinham ido com ele disseram: “Não podemos lutar contra o povo da terra, porque é mais forte do que nós!” ");
INSERT INTO poronbv_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","E espalharam notícias negativas entre os israelitas acerca daquela terra. Eles disseram: “A terra que acabamos de ver não produz o suficiente nem para alimentar os próprios moradores. Lá todos os homens são de grande estatura. ");
INSERT INTO poronbv_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Vimos também alguns da família de Enaque, que são descendentes de uma antiga raça de gigantes. Perto deles nos sentíamos como gafanhotos; e, para eles, de fato éramos gafanhotos”. ");
INSERT INTO poronbv_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Então, naquela noite o povo começou a chorar em voz alta. ");
INSERT INTO poronbv_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Todos os israelitas queixaram-se contra Moisés e contra Arão, e toda a comunidade disse a eles: “Teria sido melhor morrer no Egito, ou mesmo aqui no deserto. ");
INSERT INTO poronbv_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Por que o Senhor nos trouxe para esta terra? Só para sermos mortos pela espada na guerra e nossas mulheres e nossos filhos serem presos e se tornarem escravos? Não seria melhor voltarmos para o Egito?” ");
INSERT INTO poronbv_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","E disseram uns aos outros: “Vamos escolher um líder e voltaremos para o Egito!” ");
INSERT INTO poronbv_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Então Moisés e Arão caíram no chão, com o rosto sobre a terra, diante de todo o povo de Israel. ");
INSERT INTO poronbv_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Então Josué, filho de Num, e Calebe, filho de Jefoné, dois dos líderes que fizeram parte da missão de espionar a terra, rasgaram as suas roupas ");
INSERT INTO poronbv_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","e disseram a todo o povo: “A terra que percorremos para espionar é muito boa. ");
INSERT INTO poronbv_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Se o Senhor se agradar de nós, ele nos ajudará a entrar nessa terra, que produz muito leite e mel, e a dará a nós. ");
INSERT INTO poronbv_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Apenas não sejam rebeldes contra o Senhor, e não tenham medo do povo que mora lá, porque nós os venceremos como se estivéssemos devorando pão. O Senhor está conosco e tirou a proteção deles; por isso, não tenham medo deles!” ");
INSERT INTO poronbv_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Mas a reação do povo foi falar em apedrejá-los. Então a glória do Senhor apareceu a todos os filhos de Israel, sobre o Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","E o Senhor disse a Moisés: “Até quando esse povo me provocará? Até quando vão deixar de crer em mim, apesar de todos os sinais que realizei no meio deles? ");
INSERT INTO poronbv_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Eu vou ferir este povo com pragas, e não serão mais meus herdeiros, mas de você farei um povo maior e mais forte do que este!”. ");
INSERT INTO poronbv_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mas Moisés respondeu ao Senhor: “Os egípcios conhecem bem o seu poder, pois o Senhor tirou este povo do Egito, ");
INSERT INTO poronbv_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","e contaram isto aos habitantes desta terra, que sabem que o Senhor está com este povo e que aparece a eles face a face. Eles sabem que a sua nuvem está sobre eles, e que o Senhor vai adiante deles numa coluna de nuvem de dia, e numa coluna de fogo de noite. ");
INSERT INTO poronbv_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Agora, se o Senhor matar o seu povo, as nações que ouviram falar da sua fama vão dizer: ");
INSERT INTO poronbv_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘O Senhor não conseguiu levar o seu povo para a terra que prometeu dar a eles por meio de juramento; por isso os matou no deserto’. ");
INSERT INTO poronbv_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Por isso, Senhor, clamo que mostre o seu grande poder, quando prometeu: ");
INSERT INTO poronbv_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘O Senhor é muito paciente e grande em misericórdia, e perdoa o pecado e a transgressão ainda que não deixa o pecado sem castigo, e pune o pecado dos pais nos filhos até a terceira e quarta geração’. ");
INSERT INTO poronbv_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Peço então que, por causa da sua grande misericórdia, o Senhor perdoe os pecados deste povo, da mesma maneira que tem perdoado este povo desde que saíram da terra do Egito até aqui”. ");
INSERT INTO poronbv_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Então o Senhor disse: “Está bem. Vou perdoar este povo como você me pediu. ");
INSERT INTO poronbv_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","No entanto, prometo que tão certo como eu vivo, e pela glória do Senhor que enche toda a terra, ");
INSERT INTO poronbv_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","que nenhum destes homens que viram a minha glória e os sinais que fiz no Egito e no deserto, e me puseram à prova dez vezes e não obedeceram à minha voz, ");
INSERT INTO poronbv_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","verá a terra que prometi por meio de juramento dar aos seus antepassados. Nenhum desses que me desprezou verá a terra. ");
INSERT INTO poronbv_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Mas o meu servo Calebe tem um espírito diferente e me segue com fidelidade. Ele entrará na terra que espionou, e seus descendentes a possuirão por herança. ");
INSERT INTO poronbv_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Já que os amalequitas e os cananeus habitam no vale, amanhã vocês mudarão de rumo e voltarão para o deserto em direção ao mar Vermelho”. ");
INSERT INTO poronbv_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Depois o Senhor disse a Moisés e a Arão: ");
INSERT INTO poronbv_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Até quando este povo mau se queixará contra mim? Tenho ouvido as queixas desses israelitas murmuradores. ");
INSERT INTO poronbv_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Diga a eles: ‘Tão certo como eu vivo, diz o Senhor, farei o que vocês pediram: ");
INSERT INTO poronbv_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Todos vocês, que têm mais de vinte anos de idade, que foram contados no recenseamento e que se queixaram contra mim, morrerão no deserto. ");
INSERT INTO poronbv_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Nenhum de vocês entrará nesta terra, que jurei com mão levantada dar a vocês como moradia, a não ser Calebe, filho de Jefoné, e Josué, filho de Num. ");
INSERT INTO poronbv_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Mas, quanto aos seus filhos, os quais vocês disseram que se tornariam escravos do povo desta terra, eu os levarei com segurança para desfrutarem da terra que vocês desprezaram. ");
INSERT INTO poronbv_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Quanto a vocês, morrerão, e os seus corpos cairão neste deserto. ");
INSERT INTO poronbv_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Seus filhos andarão sem rumo pelo deserto por quarenta anos, até que o último de vocês morra, como castigo pela sua infidelidade. ");
INSERT INTO poronbv_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Como os espiões estiveram na terra durante quarenta dias, vocês andarão sem rumo por quarenta anos — um ano para cada dia, sofrendo as consequências dos seus pecados. Eu lhes ensinarei o que significa rejeitar a mim. ");
INSERT INTO poronbv_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Eu, o Senhor, falei, e certamente farei essas coisas a toda essa comunidade má, que conspirou contra mim. Eles encontrarão o seu fim nesse deserto e morrerão’ ”. ");
INSERT INTO poronbv_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Os homens que Moisés enviou para espionar a terra e que depois de voltar colocaram medo no coração do povo, fazendo com que se queixasse contra ele ao espalhar informações negativas a respeito da terra, ");
INSERT INTO poronbv_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","esses homens que espalharam essas informações morreram repentinamente de praga diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","De todos os espiões que foram espionar a terra, somente Josué, filho de Num, e Calebe, filho de Jefoné, continuaram vivos. ");
INSERT INTO poronbv_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Quando Moisés contou essas palavras a todos os israelitas, uma grande tristeza tomou conta deles. ");
INSERT INTO poronbv_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","No dia seguinte se levantaram cedo e partiram em direção ao alto da região montanhosa, e disseram: “Aqui estamos! Reconhecemos que pecamos. Agora estamos prontos para ir à terra que o Senhor nos prometeu”. ");
INSERT INTO poronbv_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mas Moisés respondeu: “Por que vocês estão desobedecendo às ordens do Senhor de voltar para o deserto? É tarde demais! ");
INSERT INTO poronbv_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Não vão, porque o Senhor não está com vocês. Vocês serão derrotados pelos seus inimigos. ");
INSERT INTO poronbv_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Não se lembram? Os amalequitas e os cananeus estão aí na frente! Vocês abandonaram o Senhor, ele não estará com vocês, e vocês serão derrotados”. ");
INSERT INTO poronbv_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Apesar disso, eles foram em frente, em direção ao alto da região montanhosa, mesmo tendo Moisés e a arca da aliança do Senhor ficado no acampamento. ");
INSERT INTO poronbv_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Então os amalequitas e os cananeus que viviam nas montanhas desceram e atacaram os israelitas, derrotaram-nos e os perseguiram até Hormá. ");
INSERT INTO poronbv_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","O Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Dê as seguintes instruções ao povo de Israel: Quando os filhos de vocês entrarem na terra que eu dei a eles como moradia, ");
INSERT INTO poronbv_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","e apresentarem ao Senhor um animal do rebanho de gado ou uma ovelha como oferta queimada, seja um sacrifício para cumprir um voto ou como oferta voluntária, seja um sacrifício especial em uma das festas anuais ou qualquer outra oferta, ou ainda uma oferta preparada no fogo como aroma agradável ao Senhor, ");
INSERT INTO poronbv_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","aquele que trouxer a sua oferta ao Senhor apresentará a ele uma oferta de cereais de um jarro de farinha da melhor qualidade, amassada com um litro de azeite. ");
INSERT INTO poronbv_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Para cada cordeiro da oferta queimada, ou do sacrifício, deve preparar um litro de vinho como oferta de bebida. ");
INSERT INTO poronbv_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“Se o sacrifício for um carneiro, deve preparar uma oferta de cereais de dois jarros de farinha da melhor qualidade, ");
INSERT INTO poronbv_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","e um litro de vinho como oferta de bebida. Isso será apresentado como aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“Quando preparar um novilho para oferta queimada ou sacrifício, para cumprir um voto especial ou como oferta de paz ao Senhor, ");
INSERT INTO poronbv_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","então traga com o novilho uma oferta de cereais de três jarros de farinha da melhor qualidade, amassada com um litro e três quartos de azeite. ");
INSERT INTO poronbv_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Traga também um litro e três quartos de vinho para a oferta de bebida. Essa oferta deve ser preparada no fogo, como aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Essas são as instruções que devem acompanhar cada sacrifício de novilho, carneiro, ovelha ou cabrito. ");
INSERT INTO poronbv_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Quando for oferecido mais de um animal, as ofertas deverão ser aumentadas proporcionalmente. ");
INSERT INTO poronbv_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“Todo israelita natural da terra deverá proceder dessa maneira quando apresentar uma oferta preparada no fogo, para que seja uma oferta de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","E se um estrangeiro que mora no meio de vocês, ou entre os seus descendentes, apresentar uma oferta preparada no fogo, deverá proceder da mesma maneira, para que seja uma oferta de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Porque existe a mesma lei para todos, tanto para os israelitas de nascimento como para os estrangeiros que moram entre vocês; esta é uma lei que será verdadeira para sempre, de geração em geração, pois todos são iguais perante o Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","A mesma lei e o mesmo regulamento se aplicam tanto a vocês quanto ao estrangeiro”. ");
INSERT INTO poronbv_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","O Senhor também disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Diga ao povo de Israel: Quando entrarem na terra para onde os estou levando ");
INSERT INTO poronbv_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","e comerem do alimento que a terra produz, apresentem uma parte como oferta especial ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Preparem um bolo feito com a farinha da primeira colheita, que deverá ser apresentado como oferta especial. ");
INSERT INTO poronbv_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Dessa farinha vocês devem apresentar uma oferta especial ao Senhor, de geração em geração. ");
INSERT INTO poronbv_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“Se vocês falharem em cumprir estes regulamentos que o Senhor tem dado a vocês por meio de Moisés, ");
INSERT INTO poronbv_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","desde o dia em que o Senhor deu esses mandamentos a Moisés e a todas as gerações futuras, vocês deverão proceder da seguinte maneira: ");
INSERT INTO poronbv_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Se isso ocorrer sem intenção e ficar encoberto da comunidade, quando o povo perceber o erro, ele terá de oferecer um novilho como oferta queimada como aroma agradável ao Senhor. Também deverá apresentar com a sua oferta de cereais uma oferta de bebida, conforme o regulamento, e um bode como oferta pelo pecado. ");
INSERT INTO poronbv_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","E o sacerdote apresentará o sacrifício em favor de todo o povo de Israel para obter o perdão dos pecados deles, e esses pecados serão perdoados, pois o pecado não foi intencional, e eles corrigiram isso com o sacrifício preparado no fogo apresentado ao Senhor e com uma oferta pelo pecado. ");
INSERT INTO poronbv_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","E todo o povo, inclusive os estrangeiros que vivem no meio deles, serão perdoados, porque esse pecado involuntário e o perdão envolvem toda a comunidade. ");
INSERT INTO poronbv_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Se um único indivíduo pecar, então ele oferecerá uma cabra de um ano de idade como oferta pelo pecado. ");
INSERT INTO poronbv_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","O sacerdote fará o sacrifício pela pessoa que pecar involuntariamente perante o Senhor, e ela será perdoada. ");
INSERT INTO poronbv_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Esta mesma lei se aplica tanto aos israelitas de nascimento quanto aos estrangeiros que vivem no meio de vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Mas todo aquele que pecar deliberadamente, seja ele israelita de nascimento ou estrangeiro, blasfema contra o Senhor e será eliminado do meio do seu povo. ");
INSERT INTO poronbv_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Por ter desprezado o mandamento do Senhor e por vontade própria desobedecido à lei, essa pessoa será eliminada e sua culpa estará sobre ela”. ");
INSERT INTO poronbv_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Certo dia, quando o povo de Israel estava no deserto, encontraram um israelita recolhendo lenha no dia de sábado. ");
INSERT INTO poronbv_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Aqueles que o encontraram recolhendo lenha levaram-no a Moisés, a Arão e diante de todo o povo, ");
INSERT INTO poronbv_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","e o prenderam porque ainda não estava determinado o que deveria ser feito com ele. ");
INSERT INTO poronbv_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Então o Senhor disse a Moisés: “O homem deve morrer. Todo o povo apedrejará esse homem fora do acampamento”. ");
INSERT INTO poronbv_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Assim, toda a comunidade de Israel o levou para fora do acampamento e o apedrejou até a morte, conforme o Senhor havia ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","O Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Diga ao povo de Israel para fazerem pingentes nos cantos de suas roupas e para prenderem cada pingente num cordão azul; este é um mandamento permanente de geração em geração. ");
INSERT INTO poronbv_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","O propósito disto é lembrá-los, sempre que olharem para os pingentes, de todos os mandamentos do Senhor, de que devem obedecer às leis que ele deu, em vez de seguir os desejos dos seus corações e de seus olhos, sendo infiéis servindo a outros deuses. ");
INSERT INTO poronbv_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Assim vocês lembrarão de obedecer a todos os meus mandamentos e de ser santos perante o Deus de vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Eu sou o Senhor, o seu Deus, que os tirou do Egito para ser o Deus de vocês. Sim, eu sou o Senhor, o Deus de vocês”. ");
INSERT INTO poronbv_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Certo dia Coré, filho de Jizar, neto de Coate, bisneto de Levi, conspirou com Datã e Abirão, os filhos de Eliabe, e com Om, filho de Pelete, todos da tribo de Rúben, ");
INSERT INTO poronbv_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","contra Moisés. Com eles estavam duzentos e cinquenta israelitas, líderes respeitados do povo, eleitos pela comunidade de Israel. ");
INSERT INTO poronbv_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Eles se ajuntaram contra Moisés e Arão e disseram: “Chega! A assembleia toda é santa, e cada indivíduo é santo, e o Senhor está entre eles. Então por que vocês se colocam acima de nós e querem mandar em nós?” ");
INSERT INTO poronbv_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Quando Moisés ouviu isso, caiu no chão com o rosto na terra ");
INSERT INTO poronbv_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","e disse a Coré e a todos os seus seguidores: “Amanhã pela manhã o Senhor mostrará quem pertence a ele e quem é santo. E fará aproximar-se dele quem ele escolheu. ");
INSERT INTO poronbv_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Façam isto: Você, Coré, e todos os que estão com você, apanhem incensários ");
INSERT INTO poronbv_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","e amanhã coloquem fogo e incenso neles perante o Senhor, e descobriremos quem o Senhor escolheu. Chega, filhos de Levi!” ");
INSERT INTO poronbv_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Então Moisés falou novamente a Coré: “Agora ouçam-me, filhos de Levi: ");
INSERT INTO poronbv_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Parece sem valor, para vocês, o fato de Deus ter escolhido vocês dentre todo o povo de Israel para estar perto dele, quando trabalham no Tabernáculo do Senhor e ficam de pé perante o povo para servir? ");
INSERT INTO poronbv_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ele trouxe você e todos os seus irmãos levitas para perto dele. E agora vocês também querem ser sacerdotes. ");
INSERT INTO poronbv_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Esse é o verdadeiro motivo da sua rebelião contra o Senhor. Quem é Arão, para se queixarem dele?” ");
INSERT INTO poronbv_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Então Moisés mandou chamar Datã e Abirão, filhos de Eliabe, mas eles responderam: “Não iremos. ");
INSERT INTO poronbv_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Será que não foi suficiente você nos tirar de uma terra que produz muito leite e mel para matar-nos neste deserto? E ainda quer mandar em nós? ");
INSERT INTO poronbv_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Além disso, você não cumpriu a promessa de nos levar a uma terra que produz muito leite e mel, nem recebemos campos e vinhas como herança. Quem você quer enganar? Nós não iremos até você”. ");
INSERT INTO poronbv_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moisés ficou muito irado e disse ao Senhor: “Não aceite os sacrifícios deles, pois não roubei um só jumento deles, nem fiz mal a nenhum deles”. ");
INSERT INTO poronbv_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","E Moisés disse a Coré: “Você e todos os seus seguidores, apresentem-se aqui amanhã perante o Senhor; você e eles, e Arão também estará aqui. ");
INSERT INTO poronbv_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Cada um deverá trazer o seu incensário; nele colocará incenso e o apresentará ao Senhor. Ao todo serão duzentos e cinquenta incensários; você e Arão também apresentarão o seu incensário”. ");
INSERT INTO poronbv_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Assim, cada um deles apanhou o incensário, acendeu o incenso, e foram todos até a porta do Tabernáculo, junto com Moisés e Arão. ");
INSERT INTO poronbv_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Coré ajuntou todo o povo à entrada do Tabernáculo e o incitou contra Moisés e Arão. Então a glória do Senhor apareceu a todo o povo. ");
INSERT INTO poronbv_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","E o Senhor disse a Moisés e a Arão: ");
INSERT INTO poronbv_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Afastem-se deste povo, porque vou matá-los num momento”. ");
INSERT INTO poronbv_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mas Moisés e Arão caíram com o rosto na terra e disseram: “Ó Deus, Deus que cria e conserva toda a vida, será que por causa do pecado de um só homem o Senhor ficará irado com todo o povo?” ");
INSERT INTO poronbv_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Então o Senhor respondeu a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Diga a todo o povo para ficar longe das tendas de Coré, Datã e Abirão”. ");
INSERT INTO poronbv_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Então Moisés foi até as tendas de Datã e Abirão, e os líderes de Israel o seguiram. ");
INSERT INTO poronbv_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","E Moisés disse à comunidade: “Fiquem longe das tendas destes homens maus e não toquem em nada que seja deles, para que não morram por causa do pecado deles”. ");
INSERT INTO poronbv_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Então o povo se afastou das tendas de Coré, Datã e Abirão. E Datã e Abirão estavam em pé, à entrada de suas tendas, junto com as suas mulheres, seus filhos e suas crianças. ");
INSERT INTO poronbv_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","E Moisés disse: “Assim vocês saberão que foi o Senhor que me enviou para fazer todas estas coisas e que não fiz isso por mim mesmo. ");
INSERT INTO poronbv_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Se estes homens morrerem naturalmente, ou devido a um acidente ou doença, então o Senhor não me enviou, ");
INSERT INTO poronbv_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","mas, se o Senhor fizer alguma coisa diferente, se a terra se abrir e os engolir, junto com tudo que lhes pertence, e eles caírem vivos no abismo então vocês saberão que esses homens desprezaram o Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","E quando Moisés acabou de dizer isso, a terra se abriu debaixo deles ");
INSERT INTO poronbv_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","e engoliu Coré, Datã e Abirão junto com as suas famílias e todos os seus bens. ");
INSERT INTO poronbv_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Eles e tudo o que possuíam caíram vivos no abismo, a terra se fechou sobre eles, e eles morreram e desapareceram do meio da assembleia. ");
INSERT INTO poronbv_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Todo o povo de Israel, quando ouviu os gritos daqueles que morreram, fugiu com medo, gritando: “Que a terra não nos engula também!” ");
INSERT INTO poronbv_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Então o Senhor mandou fogo matando os duzentos e cinquenta homens que ofereciam incenso. ");
INSERT INTO poronbv_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Diga a Eleazar, filho do sacerdote Arão, para apanhar os incensários do meio do fogo e espalhar as brasas, porque os incensários são santos. ");
INSERT INTO poronbv_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","A respeito dos incensários daqueles que pecaram e morreram, serão transformados em placas de bronze e servirão para cobrir o altar. Esses incensários são sagrados, porque foram usados perante o Senhor, e servirão como sinal para os filhos de Israel”. ");
INSERT INTO poronbv_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Então o sacerdote Eleazar juntou os incensários de bronze daqueles que morreram queimados e os transformou em placas para cobrir o altar, ");
INSERT INTO poronbv_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","para lembrar a todo o povo de Israel que somente os sacerdotes, descendentes de Arão, podem acender incenso perante o Senhor, e para não acontecer o que aconteceu com Coré e os seus seguidores, conforme o Senhor havia mandado por meio de Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Mas no dia seguinte, todo o povo de Israel se queixou de Moisés e de Arão, dizendo: “Vocês mataram o povo do Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Quando o povo se ajuntou contra Moisés e Arão e se voltou para o Tabernáculo, subitamente a nuvem cobriu o Tabernáculo e a glória do Senhor apareceu. ");
INSERT INTO poronbv_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moisés e Arão vieram até diante do Tabernáculo, ");
INSERT INTO poronbv_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","e o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Fiquem longe desta comunidade, porque eu acabarei com este povo num instante”. Mas eles caíram no chão com o rosto em terra, ");
INSERT INTO poronbv_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","e Moisés disse a Arão: “Pegue o incensário, coloque fogo do altar e incenso nele e corra pelo meio do povo para obter o perdão dos pecados deles, porque o Senhor está muito irado e a praga já começou”. ");
INSERT INTO poronbv_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Arão fez o que Moisés ordenou e correu até o meio do povo. A praga já havia começado entre o povo, mas Arão ofereceu o incenso e obteve o perdão dos pecados do povo. ");
INSERT INTO poronbv_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ele ficou entre os vivos e os mortos, e a praga parou. ");
INSERT INTO poronbv_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","E os que morreram em decorrência da praga foram 14.700 pessoas, sem contar aqueles que morreram por causa de Coré. ");
INSERT INTO poronbv_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Então Arão voltou a Moisés, à entrada do Tabernáculo, pois a praga havia parado. ");
INSERT INTO poronbv_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","O Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Diga ao povo de Israel que traga doze varas, uma vara para cada líder das tribos. Escreva o nome de cada líder em uma das varas. ");
INSERT INTO poronbv_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Mas o nome de Arão será colocado na vara de Levi, pois é necessário que haja uma vara para cada líder da tribo. ");
INSERT INTO poronbv_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Coloque essas varas no Tabernáculo diante da arca das tábuas da aliança, onde eu me encontro com vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","A vara daquele que eu escolher florescerá, para que o povo pare de se queixar contra vocês”. ");
INSERT INTO poronbv_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Então Moisés falou aos israelitas, e todos os líderes trouxeram as varas, uma vara para cada líder das tribos, inclusive a vara com o nome de Arão. ");
INSERT INTO poronbv_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moisés colocou as varas perante o Senhor, em frente à arca da aliança. ");
INSERT INTO poronbv_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","No dia seguinte quando Moisés entrou no Tabernáculo, viu que a vara de Arão, representante da tribo de Levi, tinha brotos, flores e amêndoas. ");
INSERT INTO poronbv_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Então Moisés retirou todas as varas da presença do Senhor e as levou a todos os filhos de Israel. Eles viram as varas, e cada líder pegou a sua vara. ");
INSERT INTO poronbv_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","E o Senhor disse a Moisés: “Ponha a vara de Arão de volta em frente à arca da aliança, para servir de sinal para os rebeldes, a fim de que parem de se queixar contra mim e não morram”. ");
INSERT INTO poronbv_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","E Moisés agiu de acordo com as ordens do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Então os israelitas disseram a Moisés: “Nós morreremos! Morreremos todos. Estamos todos perdidos! ");
INSERT INTO poronbv_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Porque todo aquele que chegar perto do Tabernáculo do Senhor morrerá! Será que todos vamos morrer?” ");
INSERT INTO poronbv_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","O Senhor falou a seguir com Arão: “Você, seus filhos e a família do seu pai serão responsáveis pelas ofensas contra o Tabernáculo; você e seus filhos responderão pelas faltas cometidas no seu serviço como sacerdotes. ");
INSERT INTO poronbv_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Todas as pessoas da tribo de Levi, a tribo de seu pai, serão ajudantes no Tabernáculo, mas só você e seus filhos podem ministrar perante a tenda que guarda as tábuas da aliança. ");
INSERT INTO poronbv_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Os levitas ficarão a seu serviço, e a serviço de todo o Tabernáculo, mas não poderão se aproximar dos utensílios do santuário, nem do altar, para que não morram, tanto eles como vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Eles se unirão a vocês no serviço do Tabernáculo. Porém, nenhuma pessoa estranha poderá aproximar-se de vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Para que eu não fique irado outra vez contra o povo de Israel, vocês terão a responsabilidade de fazer o serviço do santuário e do altar. ");
INSERT INTO poronbv_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Eu mesmo separei os levitas do meio do povo de Israel, como um presente para vocês, dedicado ao Senhor, para fazer o serviço do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","E você e seus filhos servirão como sacerdotes em tudo que se refere ao altar e o que fica para dentro da cortina. Pois o sacerdócio é o presente especial de serviço que dou a vocês. Mas qualquer pessoa estranha que se aproximar, morrerá”. ");
INSERT INTO poronbv_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Então o Senhor deu mais instruções a Arão: “Eu mesmo confiei a você o cuidado pelas contribuições trazidas a mim; todas as ofertas sagradas que os israelitas me apresentarem pertencem a você e aos seus filhos para sempre. ");
INSERT INTO poronbv_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","As ofertas mais sagradas e que não forem queimadas, isto é, as ofertas de cereais, as ofertas pelo pecado e as ofertas pela culpa que eu receber serão separadas para você e seus filhos. ");
INSERT INTO poronbv_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Vocês as comerão como algo santo. Somente os homens poderão comê-las. E serão santas para vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Também dou a você, e a seus filhos e filhas, para sempre, as ofertas que são apresentadas a mim com gestos rituais. Toda pessoa da sua família que estiver cerimonialmente pura poderá comê-las. ");
INSERT INTO poronbv_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Os presentes que eu receber, isto é, o melhor azeite e o melhor vinho e o melhor das colheitas de cereais, eu dou a vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Os primeiros frutos da terra que trouxerem ao Senhor serão de vocês. Toda pessoa de sua família que estiver cerimonialmente pura poderá comê-los. ");
INSERT INTO poronbv_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Então, tudo o que em Israel for consagrado será de vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","E o primeiro filho de cada família, oferecido ao Senhor, e a primeira cria de cada animal serão de vocês. Mas vocês deverão resgatar todo filho mais velho, como também toda cria de animais impuros. ");
INSERT INTO poronbv_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Deve haver o pagamento do resgate quando tiverem um mês de idade. O preço do resgate estabelecido é de sessenta gramas de prata, com base no peso padrão do santuário. ");
INSERT INTO poronbv_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Mas a primeira cria de gado, das ovelhas e das cabras não pode ser resgatada, pois será sacrificada ao Senhor. Você derramará o sangue de cada primeira cria sobre o altar e queimará a gordura como oferta de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","A carne desses animais pertence a você, até mesmo o peito da oferta apresentada com gestos rituais e a coxa direita. ");
INSERT INTO poronbv_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Todas essas ofertas sagradas que os filhos de Israel oferecerem ao Senhor são de vocês e dos seus filhos para sempre. É uma aliança permanente perante o Senhor, para você e os seus descendentes”. ");
INSERT INTO poronbv_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","E o Senhor também disse a Arão: “Você não terá propriedades nem herança na terra do povo de Israel, porque eu sou a propriedade e a herança de vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Todos os dízimos que eu recebo do povo de Israel, dou aos levitas pelo serviço que fazem no Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","E, de agora em diante, o povo de Israel nunca mais se aproximará do Tabernáculo; caso contrário, levarão sobre si o seu pecado e morrerão. ");
INSERT INTO poronbv_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Apenas os levitas farão o trabalho do Tabernáculo e serão responsáveis pelas ofensas que cometerem contra ele. Essa lei é para sempre, de geração em geração. Os levitas não receberão nenhuma propriedade entre os filhos de Israel. ");
INSERT INTO poronbv_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Porque o dízimo que o povo de Israel apresenta como oferta especial, eu dou como herança aos levitas, porque eu disse que eles não teriam propriedade alguma entre os israelitas”. ");
INSERT INTO poronbv_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Fale o seguinte aos levitas: Quando receberem dos israelitas o dízimo que lhes dou como herança, vocês devem fazer uma oferta a mim com o dízimo dos dízimos. ");
INSERT INTO poronbv_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Essa oferta especial o Senhor considerará como se fosse o melhor da colheita e do vinho do tanque de prensar uvas. ");
INSERT INTO poronbv_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Por isso os levitas devem apresentar uma oferta especial ao Senhor de todos os dízimos que receberem do povo de Israel. Darão essa oferta ao sacerdote Arão. ");
INSERT INTO poronbv_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Os levitas devem separar a melhor parte dos dízimos que receberem e dar ao Senhor. Ela é considerada a parte sagrada. ");
INSERT INTO poronbv_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Diga aos levitas: Quando vocês oferecerem o melhor dos dízimos, isso será considerado o melhor da colheita e do vinho do tanque de prensar uvas. ");
INSERT INTO poronbv_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Vocês e suas famílias poderão comer dessa porção em qualquer lugar, como pagamento pelo trabalho de vocês no Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Vocês não serão culpados de ficar com os dízimos, se apresentarem a melhor parte ao Senhor. E não profanem as ofertas sagradas dos israelitas, para que não morram”. ");
INSERT INTO poronbv_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","E o Senhor disse ainda mais a Moisés e Arão: ");
INSERT INTO poronbv_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Esta é uma outra lei que o Senhor ordenou: Diga ao povo de Israel para trazer uma novilha vermelha, sem defeito e sem mancha, sobre a qual nunca foi colocada uma canga. ");
INSERT INTO poronbv_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","O povo deve entregar a novilha ao sacerdote Eleazar, que a levará para fora do acampamento, e ela será morta ali diante dele. ");
INSERT INTO poronbv_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Então o sacerdote Eleazar molhará o dedo com o sangue e borrifará sete vezes na direção do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Em seguida a novilha será queimada diante dele. Serão queimados o couro, a carne, o sangue e o excremento. ");
INSERT INTO poronbv_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","O sacerdote deverá apanhar um pedaço de madeira de cedro, hissopo e lã tingida de vermelho e lançar tudo no meio do fogo que estiver queimando a novilha. ");
INSERT INTO poronbv_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Depois disso, o sacerdote lavará as roupas e tomará banho, voltando em seguida ao acampamento, mas estará impuro até o final da tarde. ");
INSERT INTO poronbv_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","E aquele que queimou a novilha lavará as suas roupas e tomará banho, e também estará impuro até o final da tarde. ");
INSERT INTO poronbv_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Então um homem cerimonialmente puro apanhará as cinzas da novilha e as colocará fora do acampamento num lugar puro. As cinzas serão guardadas pelo povo de Israel para o preparo de uma água purificadora que serve como oferta pelo pecado. ");
INSERT INTO poronbv_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Aquele que pegou as cinzas da novilha também lavará as suas roupas e permanecerá impuro até o fim da tarde. Essa lei valerá para sempre, tanto para os israelitas como para os estrangeiros que moram no meio de vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Quem tocar em uma pessoa morta ficará impuro durante sete dias. ");
INSERT INTO poronbv_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Deverá purificar-se lavando-se com a água purificadora no terceiro e no sétimo dia. Mas, se não se purificar no terceiro e no sétimo dia, não estará puro. ");
INSERT INTO poronbv_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Aquele que tocar em uma pessoa morta e não se purificar, contamina o Tabernáculo do Senhor. Por isso, essa pessoa será eliminada de Israel, porque a água purificadora não foi borrifada sobre ela, e a sua impureza permanece sobre ela. ");
INSERT INTO poronbv_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“A lei é esta: quando alguém morrer em alguma tenda, toda pessoa que entrar ou estiver na tenda ficará impura por sete dias, ");
INSERT INTO poronbv_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","e todo o vaso que não estiver bem fechado ou destampado ficará impuro. ");
INSERT INTO poronbv_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Toda pessoa que for ao campo e tocar em alguém que foi morto à espada, ou em alguém que tenha sofrido morte natural, ou nos ossos de uma pessoa, ou em algum túmulo, ficará cerimonialmente impura durante sete dias. ");
INSERT INTO poronbv_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Para essa pessoa se purificar, deve-se apanhar a cinza da oferta queimada pelo pecado e colocá-la num vaso, e depois colocar água limpa nesse vaso. ");
INSERT INTO poronbv_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Então um homem cerimonialmente puro pegará o hissopo e o colocará na água e borrifará essa água sobre aquela tenda, sobre todos os utensílios da tenda e sobre as pessoas que estiverem dentro da tenda. Borrifará também essa água sobre a pessoa que tiver tocado num osso humano, ou em alguém que tenha sido morto, ou em alguém que tenha sofrido morte natural, ou num túmulo. ");
INSERT INTO poronbv_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","A pessoa que está cerimonialmente pura borrifará o cerimonialmente impuro no terceiro e no sétimo dia. E a pessoa que estava impura lavará suas roupas, tomará banho e ficará pura no final da tarde. ");
INSERT INTO poronbv_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Mas, se aquele que estiver impuro não se purificar, será eliminado do povo de Israel, porque contaminou o Tabernáculo do Senhor. Ele continua impuro porque não borrifaram água purificadora nele. ");
INSERT INTO poronbv_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Esta é uma lei perpétua: Quem borrifar a água purificadora também deve lavar as suas roupas, e quem encostar na água purificadora ficará impuro até o final da tarde. ");
INSERT INTO poronbv_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","E tudo o que o impuro tocar se tornará impuro até o final da tarde”. ");
INSERT INTO poronbv_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","O povo de Israel chegou ao deserto de Zim no primeiro mês, e acampou em Cades, onde Miriã morreu e foi sepultada. ");
INSERT INTO poronbv_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","E como não havia água, o povo se reuniu contra Moisés e Arão. ");
INSERT INTO poronbv_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Discutiram com Moisés e disseram: “Seria melhor se tivéssemos morrido com nossos irmãos que morreram perante o Senhor! ");
INSERT INTO poronbv_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Por que vocês trouxeram o povo do Senhor para este deserto, para que nós e os nossos animais morrêssemos aqui? ");
INSERT INTO poronbv_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","E por que nos tiraram do Egito para nos trazer a este lugar terrível, que não produz cereais, nem figos, nem uvas, nem romãs, nem fornece água para beber?” ");
INSERT INTO poronbv_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Então Moisés e Arão saíram de diante do povo, foram para a entrada do Tabernáculo e se prostraram com o rosto no chão, e a glória do Senhor apareceu. ");
INSERT INTO poronbv_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Pegue a vara de Arão e reúna todo o povo e fale à rocha diante de todo o povo, para que dela saia água. A água que você tirar será suficiente para todo o povo e para os seus animais”. ");
INSERT INTO poronbv_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","E Moisés fez conforme a ordem do Senhor. Ele apanhou a vara que estava diante do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","E então Moisés e Arão reuniram o povo em frente da rocha, e Moisés disse: “Prestem atenção, rebeldes! Será que vamos ter de tirar água desta rocha para vocês?” ");
INSERT INTO poronbv_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Então Moisés ergueu a mão e bateu duas vezes na rocha com a vara, e jorrou água. E o povo e os animais beberam. ");
INSERT INTO poronbv_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Mas o Senhor disse a Moisés e a Arão: “Como vocês não creram em mim e não me santificaram diante do povo de Israel, vocês não vão levar os filhos de Israel para a terra que prometi dar a eles”. ");
INSERT INTO poronbv_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","O nome deste lugar se chamou Meribá, porque o povo de Israel rebelou-se contra o Senhor, e ele mostrou ao povo que é santo. ");
INSERT INTO poronbv_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moisés enviou mensageiros de Cades ao rei de Edom, dizendo: “Somos descendentes do seu irmão Israel. Você conhece todas as dificuldades pelas quais passamos. ");
INSERT INTO poronbv_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Os nossos pais foram até o Egito, e ali moramos durante muito tempo. Então, os egípcios maltrataram a nós e aos nossos pais, ");
INSERT INTO poronbv_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","mas, quando clamamos ao Senhor, ele ouviu a nossa voz, enviou o Anjo e nos tirou do Egito. “Agora estamos em Cades, cidade na fronteira do seu país. ");
INSERT INTO poronbv_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Nós queremos autorização para passar pela sua terra. Não passaremos por nenhuma plantação ou vinha, nem beberemos água dos poços. Andaremos apenas pela estrada principal, sem nos desviarmos para a direita ou para a esquerda, até chegarmos ao outro lado da fronteira”. ");
INSERT INTO poronbv_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Mas Edom respondeu: “Não deixarei vocês passarem pelo meu país. Se tentarem, irei ao seu encontro com a espada”. ");
INSERT INTO poronbv_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","E os mensageiros disseram ao rei: “Andaremos apenas pela estrada principal. Se nós e os nossos rebanhos bebermos da água de vocês, pagaremos o preço dela. Nós só queremos passar pelo país”. ");
INSERT INTO poronbv_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mas Edom insistiu: “Não deixarei vocês passarem”. E o rei convocou o seu exército, que era grande e forte, para não deixar o povo de Israel cruzar a fronteira. ");
INSERT INTO poronbv_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Como Edom não deixou Israel passar pelo país, Israel se desviou dele. ");
INSERT INTO poronbv_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Todo o povo de Israel partiu de Cades e foi para o monte Hor. ");
INSERT INTO poronbv_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Naquele monte, que também fica na fronteira de Edom, o Senhor disse a Moisés e Arão: ");
INSERT INTO poronbv_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Arão morrerá e será reunido aos seus antepassados. Ele não entrará na terra que prometi dar aos israelitas, porque vocês dois se rebelaram contra as minhas instruções no caso das águas de Meribá. ");
INSERT INTO poronbv_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Leve Arão junto com o seu filho Eleazar até o alto do monte Hor. ");
INSERT INTO poronbv_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Então tire as vestes sacerdotais de Arão e coloque-as em seu filho Eleazar, pois Arão vai morrer ali e será reunido aos seus antepassados”. ");
INSERT INTO poronbv_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moisés agiu de acordo com a vontade do Senhor. Todo o povo viu os três subindo o monte Hor. ");
INSERT INTO poronbv_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Então Moisés tirou as vestes sacerdotais que Arão vestia e as colocou em Eleazar, filho de Arão. E Arão morreu ali no alto do monte. Depois disso, Moisés e Eleazar desceram do monte, ");
INSERT INTO poronbv_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","e quando o povo soube da morte de Arão, toda a nação de Israel chorou pela morte de Arão por trinta dias. ");
INSERT INTO poronbv_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Quando o rei cananeu de Arade, que morava no Neguebe, ouviu que o povo de Israel vinha pela estrada de Atarim, guerreou contra Israel e capturou alguns israelitas. ");
INSERT INTO poronbv_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Então Israel fez este voto ao Senhor: “Se o Senhor permitir que derrotemos esse povo, destruiremos todas as suas cidades”. ");
INSERT INTO poronbv_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","E o Senhor ouviu essa promessa e permitiu a derrota dos cananeus. O povo de Israel destruiu totalmente o povo e as suas cidades. E deram o nome de Hormá a esse lugar. ");
INSERT INTO poronbv_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","E o povo partiu do monte Hor pela estrada do mar Vermelho, dando a volta pelo país de Edom, mas os israelitas perderam a paciência no meio do caminho, ");
INSERT INTO poronbv_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","e se queixaram contra Deus e contra Moisés, dizendo: “Por que vocês nos tiraram do Egito para morrermos nesse deserto? Aqui não há pão nem água! E nós detestamos essa comida horrível!” ");
INSERT INTO poronbv_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Então o Senhor enviou serpentes venenosas que mordiam o povo, e muitas pessoas de Israel morreram. ");
INSERT INTO poronbv_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","O povo falou com Moisés e disse: “Nós pecamos porque falamos contra o Senhor e contra você. Ore pedindo para tirar as serpentes do meio do povo”. E Moisés orou pelo povo. ");
INSERT INTO poronbv_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","E o Senhor respondeu a Moisés: “Faça uma serpente de bronze e a coloque no alto de um poste. Quando alguém for mordido por uma serpente e olhar para a serpente no alto do poste, escapará com vida”. ");
INSERT INTO poronbv_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moisés fez uma serpente de bronze e a colocou no alto de um poste. Todas as pessoas que eram mordidas por uma serpente e olhavam para a serpente de bronze, permaneciam vivas. ");
INSERT INTO poronbv_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Os israelitas partiram então para Obote, onde acamparam. ");
INSERT INTO poronbv_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Depois viajaram e acamparam em Ijé-Abarim. Esse lugar fica no deserto, perto da fronteira oriental de Moabe. ");
INSERT INTO poronbv_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Dali partiram e foram acampar no vale de Zerede. ");
INSERT INTO poronbv_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Depois se mudaram para a outra margem do rio Arnom, que fica no deserto, perto da fronteira do território dos amorreus. O rio Arnom serve de fronteira entre Moabe e os amorreus. ");
INSERT INTO poronbv_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","É por isso que o Livro das Guerras do Senhor fala sobre isto quando diz que o vale do rio Arnom e a cidade de Vaebe, na região de Sufá, e os vales, ");
INSERT INTO poronbv_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ficam entre os amorreus e o povo de Moabe. ");
INSERT INTO poronbv_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","De lá Israel viajou para Beer, o poço sobre o qual o Senhor disse a Moisés: “Reúna o povo, e eu lhe darei água”. ");
INSERT INTO poronbv_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Então o povo de Israel cantou esta canção: “Comece a dar água, ó poço! Cantemos a respeito dele! ");
INSERT INTO poronbv_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Este é um poço que os líderes cavaram, e os mais importantes do povo abriram com os seus bastões de comando e com os seus cajados”. Então saíram do deserto e foram para Mataná, ");
INSERT INTO poronbv_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","de Mataná para Naaliel, de Naaliel para Bamote. ");
INSERT INTO poronbv_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Saíram então de Bamote para o vale que fica nas terras de Moabe, de onde se pode ver o deserto e o monte Pisga ao longe, em frente ao deserto. ");
INSERT INTO poronbv_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","E Israel enviou mensageiros a Seom, rei dos amorreus, para dizer a ele: ");
INSERT INTO poronbv_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Pedimos autorização para passar pelo seu país. Não andaremos pelas suas plantações e vinhas, nem beberemos da água dos seus poços. Andaremos apenas pela estrada principal até atravessar o seu país”. ");
INSERT INTO poronbv_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Mas Seom não deixou Israel atravessar o país e convocou o seu exército para lutar contra Israel. Vieram até o deserto e lutaram contra Israel em Jazar. ");
INSERT INTO poronbv_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","E Israel derrotou os amorreus e tomou a terra, desde o rio Arnom até o rio Jaboque, fronteira dos amonitas, que era bem fortificada. ");
INSERT INTO poronbv_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israel tomou todas as cidades dos amorreus e morou nelas, inclusive Hesbom e todos os seus povoados. ");
INSERT INTO poronbv_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hesbom era a cidade de Seom, rei dos amorreus, que havia lutado contra o antigo rei de Moabe, tendo tomado toda a sua terra até o rio Arnom. ");
INSERT INTO poronbv_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","É por isso que os poetas antigos fazem referência ao rei Seom: “Venham até Hesbom! Que seja edificada; seja construída a cidade de Seom! ");
INSERT INTO poronbv_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Porque saiu fogo de Hesbom, uma chama da cidade de Seom; consumiu a cidade de Ar em Moabe e os senhores nos altos do vale de Arnom! ");
INSERT INTO poronbv_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ai de você, Moabe! Você está perdido, povo de Camos: Seus filhos fugiram E sua filhas foram levadas cativas de Seom, rei dos amorreus. ");
INSERT INTO poronbv_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Mas nós os derrotamos; Hesbom está destruída até Dibom, Nós os arrasamos até Nofá e Medeba”. ");
INSERT INTO poronbv_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","E Israel morou na terra dos amorreus. ");
INSERT INTO poronbv_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Então Moisés mandou espionar Jazar, e os israelitas tomaram os povoados ao redor de Jazar e expulsaram os amorreus que moravam ali. ");
INSERT INTO poronbv_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Então voltaram e foram para a estrada que leva para a cidade de Basã. Mas Ogue, rei de Basã, convocou o seu exército para lutar contra Israel e foram lutar em Edrei. ");
INSERT INTO poronbv_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","E o Senhor disse a Moisés: “Não tenha medo dele, porque eu o entreguei a você, juntamente com todo o seu povo e a sua terra. Você fará com ele o mesmo que fez com Seom, rei dos amorreus, que habitava em Hesbom”. ");
INSERT INTO poronbv_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Então Israel o derrotou, bem como os seus filhos e seu povo. Ninguém escapou com vida. E tomaram posse da terra. ");
INSERT INTO poronbv_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","O povo de Israel partiu e acampou nas campinas de Moabe, a leste do rio Jordão, do lado oposto de Jericó. ");
INSERT INTO poronbv_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Então o rei Balaque, filho de Zipor, viu tudo o que Israel tinha feito aos amorreus, ");
INSERT INTO poronbv_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","e Moabe teve muito medo de Israel, por ser um povo muito numeroso. O rei ficou muito preocupado com Israel, ");
INSERT INTO poronbv_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","e foi consultar os líderes de Midiã, dizendo: “Essa multidão devorará tudo o que houver ao nosso redor, como o boi devora o capim do pasto”. Balaque, filho de Zipor, rei de Moabe, ");
INSERT INTO poronbv_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","mandou mensageiros até Balaão, filho de Beor, que morava com seu povo em Petor, cidade nas margens do rio Eufrates. A mensagem de Balaque dizia: “Um povo enorme que cobre toda a terra saiu do Egito e está vindo em minha direção. ");
INSERT INTO poronbv_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Venha agora lançar uma maldição contra esse povo, pois é muito mais forte do que eu. Talvez assim eu possa derrotá-lo e expulsá-lo da terra. E sei que se você abençoar alguém, essa pessoa será abençoada, e a quem você amaldiçoar, será amaldiçoado”. ");
INSERT INTO poronbv_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Então os líderes de Moabe e de Midiã foram até Balaão, levando dinheiro para pagar pelo trabalho de encantamento, e transmitiram a mensagem de Balaque. ");
INSERT INTO poronbv_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaão lhes respondeu: “Fiquem aqui esta noite e amanhã cedo trarei a resposta do Senhor”. Então os líderes de Moabe ficaram com Balaão. ");
INSERT INTO poronbv_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Naquela noite o Senhor apareceu a Balaão e perguntou: “Quem são esses homens que estão com você?” ");
INSERT INTO poronbv_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","E Balaão respondeu: “Balaque, rei dos moabitas e filho de Zipor, enviou esses homens com a seguinte mensagem: ");
INSERT INTO poronbv_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘O povo que saiu do Egito cobre a face da terra’. Balaque quer que eu amaldiçoe esse povo, para poder derrotá-lo e expulsá-lo”. ");
INSERT INTO poronbv_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Mas Deus disse a Balaão: “Você não irá com eles, nem amaldiçoará o povo, porque é um povo abençoado”. ");
INSERT INTO poronbv_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaão se levantou na manhã seguinte e disse aos líderes de Balaque: “Voltem para a terra de vocês, porque o Senhor não me permitiu ir com vocês”. ");
INSERT INTO poronbv_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Então os líderes moabitas voltaram até Balaque e lhe disseram: “Balaão recusou-se a vir conosco”. ");
INSERT INTO poronbv_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balaque enviou outros líderes do povo a Balaão. E dessa vez o número de líderes era maior e eles eram mais honrados do que os da primeira vez. ");
INSERT INTO poronbv_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Eles foram a Balaão e lhe disseram: “Assim diz Balaque, filho de Zipor: ‘Peço que venha logo até aqui, ");
INSERT INTO poronbv_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","porque o honrarei grandemente e farei tudo o que você mandar. Por favor, venha e amaldiçoe aquele povo’ ”. ");
INSERT INTO poronbv_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Mas Balaão respondeu aos servos de Balaque: “Mesmo que Balaque me oferecesse o seu palácio cheio de prata e de ouro, não poderia desobedecer à ordem do Senhor, meu Deus, para fazer qualquer coisa, grande ou pequena. ");
INSERT INTO poronbv_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Agora convido vocês a ficarem aqui esta noite, para que eu possa saber o que mais o Senhor vai me falar”. ");
INSERT INTO poronbv_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Naquela noite o Senhor veio a Balaão e disse: “Visto que aqueles homens vieram chamar você, vá com eles, mas faça apenas o que eu lhe disser”. ");
INSERT INTO poronbv_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Na manhã seguinte Balaão se levantou, pôs a sela sobre a sua jumenta e partiu com os líderes moabitas. ");
INSERT INTO poronbv_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Mas Deus ficou irado com a partida de Balaão. Então o Anjo do Senhor pôs-se no caminho para impedir que Balaão prosseguisse. Balaão ia montado na jumenta, e dois servos iam com ele. ");
INSERT INTO poronbv_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Quando a jumenta viu o Anjo do Senhor parado na estrada, segurando uma espada na mão, a jumenta se desviou do caminho e foi pelo campo. Balaão espancou-a para que voltasse para a estrada. ");
INSERT INTO poronbv_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","E de novo o Anjo do Senhor ficou no meio de uma passagem estreita entre duas vinhas, onde havia muros de ambos os lados. ");
INSERT INTO poronbv_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Quando a jumenta viu o Anjo do Senhor, espremeu-se contra o muro, apertando o pé de Balaão. Por isso, ele a espancou de novo. ");
INSERT INTO poronbv_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Então o Anjo do Senhor foi mais adiante na estrada, onde era bastante estreita e não havia espaço para desviar-se, nem para a direita nem para a esquerda. ");
INSERT INTO poronbv_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Quando a jumenta viu o Anjo do Senhor, deitou-se no chão. Balaão ficou com raiva e espancou-a com uma vara. ");
INSERT INTO poronbv_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Então o Senhor fez a jumenta falar, e ela disse a Balaão: “O que foi que eu fiz a você, para você me bater três vezes?” ");
INSERT INTO poronbv_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","E Balaão respondeu à jumenta: “Porque você zombou de mim. Se eu tivesse uma espada agora comigo, eu a mataria nesse instante”. ");
INSERT INTO poronbv_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Mas a jumenta disse a Balaão: “Não fui a sua jumenta, que você sempre montou até o dia de hoje? Será que tenho o costume de fazer isso com você?” Ele respondeu: “Não!” ");
INSERT INTO poronbv_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Então o Senhor abriu os olhos de Balaão, e ele viu o Anjo do Senhor na estrada, segurando uma espada na mão. Então Balaão prostrou-se com o rosto no chão. ");
INSERT INTO poronbv_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","E o Anjo do Senhor perguntou: “Por que você espancou a jumenta três vezes? Eu vim para detê-lo porque o seu caminho não me agrada. ");
INSERT INTO poronbv_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","A jumenta me viu três vezes e se desviou de mim. Se ela não se afastasse, certamente eu já o teria matado e deixado a jumenta com vida”. ");
INSERT INTO poronbv_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaão disse ao Anjo do Senhor: “Pequei, porque não sabia que o Senhor estava nesta estrada para me impedir de prosseguir. Agora, se o que estou fazendo não lhe agrada, voltarei”. ");
INSERT INTO poronbv_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Mas o Anjo do Senhor disse a Balaão: “Vá com esses homens, mas fale apenas o que eu lhe disser”. E Balaão continuou a viagem com os líderes de Balaque. ");
INSERT INTO poronbv_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Quando Balaque ouviu que Balaão estava chegando, foi ao seu encontro na cidade moabita na fronteira do Arnom, no limite do seu território. ");
INSERT INTO poronbv_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","E Balaque perguntou a Balaão: “Por que você se atrasou tanto? Não acreditou em mim quando eu disse que daria grandes honras a você?” ");
INSERT INTO poronbv_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaão respondeu a Balaque: “Aqui estou, mas só direi as palavras que o Senhor colocar em minha boca”. ");
INSERT INTO poronbv_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","E Balaão foi com Balaque até Quiriate-Huzote. ");
INSERT INTO poronbv_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Então Balaque matou bois e ovelhas, e deu parte da carne para Balaão e os líderes que estavam com ele. ");
INSERT INTO poronbv_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Na manhã seguinte Balaque levou Balaão até Bamote-Baal, de onde podiam ver uma parte do povo. ");
INSERT INTO poronbv_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaão disse a Balaque: “Construa aqui sete altares e prepare sete novilhos e sete carneiros”. ");
INSERT INTO poronbv_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaque atendeu ao pedido dele, e os dois ofereceram um novilho e um carneiro sobre cada altar. ");
INSERT INTO poronbv_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","E Balaão disse a Balaque: “Fique aqui com suas ofertas queimadas, enquanto eu me retiro. Talvez o Senhor apareça a mim. Direi então a você o que ele me disser”. E foi para uma colina descampada. ");
INSERT INTO poronbv_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Deus se encontrou ali com ele, e Balaão lhe disse: “Preparei sete altares, e em cada altar ofereci um novilho e um carneiro”. ");
INSERT INTO poronbv_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","E o Senhor colocou uma palavra na boca de Balaão, e disse: “Volte a Balaque e transmita essa mensagem”. ");
INSERT INTO poronbv_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Voltando a ele, o encontrou ao lado da sua oferta queimada, junto com os líderes moabitas. ");
INSERT INTO poronbv_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Então Balaão pronunciou a mensagem do Senhor a Balaque: “De Arã me fez vir Balaque, rei dos moabitas, das montanhas do oriente. Ele me disse: ‘Venha, amaldiçoe Jacó e deseje mal a Israel’. ");
INSERT INTO poronbv_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Como posso amaldiçoar quem Deus não amaldiçoou? Como posso desejar mal, se o Senhor não desejou mal? ");
INSERT INTO poronbv_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Vejo os israelitas do alto das montanhas, e também os observo de cima das colinas. Vejo que é um povo que vive separado e não se considera como as demais nações. ");
INSERT INTO poronbv_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Quem pode contar o povo de Jacó? Quem pode numerar a quarta parte de Israel? Que eu morra a morte dos justos, e seja o meu fim como o deles!” ");
INSERT INTO poronbv_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Então Balaque disse a Balaão: “Que foi que você me fez? Chamei você para amaldiçoar os meus inimigos e você os abençoou!” ");
INSERT INTO poronbv_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Mas Balaão respondeu: “Será que não devo dizer o que o Senhor colocou em minha boca?” ");
INSERT INTO poronbv_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Então o rei Balaque lhe disse: “Venha comigo para outro lugar de onde você verá só uma parte de Israel. E de lá quero que você amaldiçoe esse povo para mim”. ");
INSERT INTO poronbv_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Então Balaque levou Balaão até o campo de Zofim, no alto do monte Pisga, onde construiu sete altares e ofereceu um novilho e um carneiro sobre cada altar. ");
INSERT INTO poronbv_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","E Balaão disse a Balaque: “Fique aqui junto às ofertas queimadas e eu irei até ali me encontrar com o Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","E o Senhor encontrou-se com Balaão e colocou uma mensagem em sua boca e disse: “Volte a Balaque e transmita-lhe essa mensagem”. ");
INSERT INTO poronbv_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Balaque e os líderes moabitas estavam reunidos próximo às ofertas queimadas quando Balaão voltou. E Balaque perguntou-lhe: “O que o Senhor disse?” ");
INSERT INTO poronbv_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Então ele pronunciou esta mensagem: “Levante-se Balaque, e ouça-me. Preste atenção, você, filho de Zipor. ");
INSERT INTO poronbv_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Deus não é homem, pois não mente, nem um filho de homem para que se arrependa. Ele faz o que promete e cumpre o que diz. ");
INSERT INTO poronbv_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ele me mandou abençoar. Não posso anular o que ele abençoou. ");
INSERT INTO poronbv_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ele não encontrou pecado em Jacó, nem viu erro algum em Israel. O Senhor, o seu Deus, está com eles; e no meio deles ouve-se o grito de que o Senhor é o Rei. ");
INSERT INTO poronbv_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Deus os tirou do Egito. Israel tem a força de um boi selvagem. ");
INSERT INTO poronbv_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Não há magia capaz de amaldiçoar Jacó, nem de prever algum mal contra Israel. Na verdade todos podem dizer de Jacó e de Israel: ‘Vejam só o que Deus tem feito!’ ");
INSERT INTO poronbv_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Esse povo se levanta como uma leoa; ergue-se como um leão, que não se deita até devorar o animal que capturou e beber o sangue de suas vítimas”. ");
INSERT INTO poronbv_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Então Balaque disse a Balaão: “Se você não vai amaldiçoar esse povo, pelo menos não o abençoe”. ");
INSERT INTO poronbv_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Mas Balaão respondeu: “Eu já não lhe disse que faria tudo o que o Senhor mandasse?” ");
INSERT INTO poronbv_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Então Balaque disse a Balaão: “Venha comigo a um outro lugar. Talvez Deus concorde em deixar que você amaldiçoe o povo dali”. ");
INSERT INTO poronbv_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","E Balaque levou Balaão para o alto do monte Peor, de onde podiam ver o deserto de Jesimom. ");
INSERT INTO poronbv_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","E Balaão disse a Balaque: “Construa aqui sete altares e prepare sete novilhos e sete carneiros para mim”. ");
INSERT INTO poronbv_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","E Balaque obedeceu às ordens de Balaão, oferecendo um novilho e um carneiro sobre cada altar. ");
INSERT INTO poronbv_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Quando Balaão percebeu que agradava ao Senhor abençoar Israel, não foi ao encontro do Senhor como das vezes anteriores, mas olhou para o deserto. ");
INSERT INTO poronbv_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","E quando ele viu Israel acampado tribo após tribo, o Espírito de Deus veio sobre ele, ");
INSERT INTO poronbv_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","e ele pronunciou esta mensagem: “Esta é a mensagem que eu, Balaão, filho de Beor, recebi. São palavras do homem que pode ver claramente, ");
INSERT INTO poronbv_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","palavra daquele que presta atenção nas palavras de Deus, daquele que tem a visão do Deus Todo-poderoso, daquele que cai prostrado em sinal de respeito, mas sem deixar de prestar atenção naquilo que vê: ");
INSERT INTO poronbv_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Como são bonitas as tendas, ó Jacó, e as suas habitações ó Israel! ");
INSERT INTO poronbv_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","São como vales enormes, como jardins à beira dos rios, como árvores que o Senhor mesmo plantou, como cedros junto às águas. ");
INSERT INTO poronbv_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Seus reservatórios de água transbordarão e suas plantações serão bem irrigadas. “O seu rei será maior do que Agague; e o seu reino receberá muitas honras. ");
INSERT INTO poronbv_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Deus os tirou do Egito. Eles têm a força de um boi selvagem. Devoram as nações inimigas e quebram os seus ossos; E as suas flechas as atravessam. ");
INSERT INTO poronbv_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Como um leão poderoso eles se curvam e como uma leoa se deitam; quem tem coragem de acordar esse leão? “Sejam abençoados os que te abençoam; e amaldiçoados os que te amaldiçoam!” ");
INSERT INTO poronbv_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Então Balaque ficou com muita raiva de Balaão, bateu palmas em sinal de ódio e lhe disse: “Chamei você para amaldiçoar os meus inimigos, mas você já os abençoou três vezes. ");
INSERT INTO poronbv_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Agora, fuja para a sua casa. Eu queria dar muitos presentes para você, mas o Senhor não permitiu”. ");
INSERT INTO poronbv_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","E Balaão respondeu a Balaque: “Eu disse aos mensageiros que você me enviou: ");
INSERT INTO poronbv_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Mesmo que Balaque me oferecesse o seu palácio cheio de prata e de ouro, se o Senhor não me autorizar, não posso fazer coisa alguma de minha própria vontade, tanto o bem como o mal. Farei só o que o Senhor mandar. ");
INSERT INTO poronbv_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Voltarei para o meu povo, mas antes quero que você saiba o que Israel fará ao seu povo no futuro”. ");
INSERT INTO poronbv_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Então Balaão transmitiu esta mensagem: “Esta é a mensagem que eu, Balaão, filho de Beor, recebi. São palavras do homem que pode ver claramente; ");
INSERT INTO poronbv_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","palavra daquele que presta atenção no que Deus diz, porque conhece a sabedoria do Deus Altíssimo, daquele que tem a visão do Deus Todo-poderoso, daquele que cai prostrado em sinal de respeito, mas sem deixar de prestar atenção naquilo que vê. ");
INSERT INTO poronbv_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","‘Vejo o futuro; observo que daqui a algum tempo aparecerá uma estrela de Jacó; e de Israel se levantará um rei. Ele esmagará o povo de Moabe, bem como os filhos de Sete. ");
INSERT INTO poronbv_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom será dominado, e Seir, seu inimigo, também será dominado; Mas Israel será muito poderoso. ");
INSERT INTO poronbv_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Um dominador sairá de Jacó e destruirá os sobreviventes das cidades’ ”. ");
INSERT INTO poronbv_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Então Balaão viu os amalequitas e disse: “Amaleque era um dos principais países, mas ele será destruído para sempre”. ");
INSERT INTO poronbv_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Depois viu os queneus e fez esta profecia: “O lugar onde vocês moram é seguro; vocês construíram cidades em montes altos; ");
INSERT INTO poronbv_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","mas, vocês, queneus, serão destruídos, quando o rei da Assíria os levar prisioneiros”. ");
INSERT INTO poronbv_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balaão profetizou ainda o seguinte: “Quem conseguirá escapar quando Deus fizer essas coisas? ");
INSERT INTO poronbv_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Virão navios de Chipre, para afligir a Assíria e Héber, mas no final também serão destruídos”. ");
INSERT INTO poronbv_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Então Balaão voltou para o seu país e Balaque seguiu o seu caminho. ");
INSERT INTO poronbv_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Enquanto Israel estava em Sitim, os homens começaram a se entregar à imoralidade sexual com as mulheres de Moabe. ");
INSERT INTO poronbv_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","E estas mulheres os convidaram para fazer sacrifícios aos deuses dos moabitas. Não demorou muito e esses homens estavam participando das festas moabitas e adorando os seus deuses. ");
INSERT INTO poronbv_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Dentro de pouco tempo todo o povo de Israel estava adorando Baal-Peor, o deus dos moabitas. E o Senhor ficou muito irado com Israel. ");
INSERT INTO poronbv_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","O Senhor deu a seguinte ordem a Moisés: “Reúna todos os líderes das tribos de Israel e enforque-os à luz do sol, diante do Senhor, para que o fogo da ira do Senhor se afaste de Israel”. ");
INSERT INTO poronbv_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Então Moisés disse aos juízes de Israel: “Cada um de vocês deverá matar os homens da sua tribo que adoraram o deus Baal-Peor”. ");
INSERT INTO poronbv_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Um israelita chegou a ponto de trazer uma moça midianita ao acampamento, na presença de Moisés e de toda a comunidade de Israel, enquanto choravam na entrada do Tabernáculo. ");
INSERT INTO poronbv_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","E quando Fineias, filho de Eleazar, neto do sacerdote Arão, viu isso, saiu do meio do povo, apanhou uma lança, ");
INSERT INTO poronbv_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","seguiu o israelita e a midianita até o interior da tenda e os atravessou com a lança. Então a praga que havia começado parou. ");
INSERT INTO poronbv_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Morreram 24.000 pessoas em decorrência da praga. ");
INSERT INTO poronbv_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Fineias, filho de Eleazar e neto do sacerdote Arão, acabou com a minha ira contra o povo de Israel, pois também estava irado como eu. Por isso não matei os israelitas. ");
INSERT INTO poronbv_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Agora, você deve dizer a ele que estabeleço com ele uma aliança de paz. ");
INSERT INTO poronbv_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ele e a sua descendência serão sacerdotes para sempre, porque ele foi zeloso pelo seu Deus e fez sacrifícios em favor do povo de Israel para que fossem perdoados”. ");
INSERT INTO poronbv_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","O nome do israelita que foi morto com a midianita era Zinri, filho de Salu, líder de uma família de Simeão. ");
INSERT INTO poronbv_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","O nome da mulher midianita era Cosbi, filha de Zur, chefe de um grupo de famílias dos midianitas. ");
INSERT INTO poronbv_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Então o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Ataquem os midianitas e os destruam, ");
INSERT INTO poronbv_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","porque eles prejudicaram vocês quando os enganaram no caso de Peor e de Cosbi, filha do líder midianita, mulher do povo deles, que foi morta no tempo da praga que houve no monte Peor”. ");
INSERT INTO poronbv_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Depois que terminou a praga, o Senhor disse a Moisés e a Eleazar, filho do sacerdote Arão: ");
INSERT INTO poronbv_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Façam um recenseamento de todos os homens de Israel de vinte anos de idade para cima que são capazes de ir para a guerra”. ");
INSERT INTO poronbv_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Israel estava acampado nas campinas de Moabe ao lado do rio Jordão, do outro lado de Jericó, quando Moisés e o sacerdote Eleazar falaram com os líderes das tribos de Israel e disseram: ");
INSERT INTO poronbv_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Façam um recenseamento dos homens de vinte anos para cima”, conforme o Senhor tinha ordenado a Moisés. Estes foram os israelitas que saíram do Egito: ");
INSERT INTO poronbv_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Os descendentes de Rúben, filho mais velho de Israel, foram: os enoquitas, que tinham esse nome por causa de Enoque; os paluítas, que tinham esse nome por causa de Palu; ");
INSERT INTO poronbv_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","os hezronitas, que tinham esse nome por causa de Hezrom; os carmitas, que tinham esse nome por causa de Carmi. ");
INSERT INTO poronbv_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Foram contados dos grupos de famílias de Rúben 43.730 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","O filho de Palu foi Eliabe, ");
INSERT INTO poronbv_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","e os filhos de Eliabe foram Nemuel, Datã e Abirão. Datã e Abirão foram os dois líderes que se reuniram com Coré e se rebelaram contra Moisés e Arão, e contra o próprio Senhor! ");
INSERT INTO poronbv_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Mas a terra se abriu e os engoliu juntamente com Coré, e o fogo queimou 250 homens, seguidores deles. Isso serviu de advertência para todo o povo. ");
INSERT INTO poronbv_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Mas os filhos de Coré não morreram. ");
INSERT INTO poronbv_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Os descendentes de Simeão segundo os seus grupos de famílias foram: os nemuelitas, que tinham esse nome por causa de Nemuel; os jaminitas, que tinham esse nome por causa de Jamim; os jaquinitas, que tinham esse nome por causa de Jaquim; ");
INSERT INTO poronbv_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","os zeraítas, que tinham esse nome por causa de Zerá; os saulitas, que tinham esse nome por causa de Saul. ");
INSERT INTO poronbv_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Foram contados dos grupos de famílias de Simeão 22.200 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Os descendentes de Gade segundo os seus grupos de famílias foram: os zefonitas, que tinham esse nome por causa de Zefom; os hagitas, que tinham esse nome por causa de Hagi; os sunitas, que tinham esse nome por causa de Suni; ");
INSERT INTO poronbv_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","os oznitas, que tinham esse nome por causa de Ozni; os eritas, que tinham esse nome por causa de Eri; ");
INSERT INTO poronbv_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","os aroditas, que tinham esse nome por causa de Arodi; os arelitas, que tinham esse nome por causa de Areli. ");
INSERT INTO poronbv_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Foram contados dos grupos de famílias de Gade 40.500 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Além de Er e Onã que morreram na terra de Canaã, ");
INSERT INTO poronbv_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","os descendentes de Judá segundo os grupos de famílias foram: os selanitas, que tinham esse nome por causa de Selá; os perezitas, que tinham esse nome por causa de Perez; os zeraítas, que tinham esse nome por causa de Zerá. ");
INSERT INTO poronbv_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Os descendentes de Perez foram: os hezronitas, que tinham esse nome por causa de Hezrom; os hamulitas, que tinham esse nome por causa de Hamul. ");
INSERT INTO poronbv_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Foram contados dos grupos de famílias de Judá 76.500 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Os descendentes de Issacar segundo os seus grupos de famílias foram: os tolaítas, que tinham esse nome por causa de Tolá; os puvitas, que tinham esse nome por causa de Puva; ");
INSERT INTO poronbv_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","os jasubitas, que tinham esse nome por causa de Jasube; os sinronitas, que tinham esse nome por causa de Sinrom. ");
INSERT INTO poronbv_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Foram contados dos grupos de famílias de Issacar 64.300 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Os descendentes de Zebulom segundo os seus grupos de famílias foram: os sereditas, que tinham esse nome por causa de Serede; os elonitas, que tinham esse nome por causa de Elom; os jaleelitas, que tinham esse nome por causa de Jaleel. ");
INSERT INTO poronbv_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Foram contados dos grupos de famílias de Zebulom 60.500 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Os descendentes de José segundo os seus grupos de famílias, por meio de Manassés e Efraim, foram: ");
INSERT INTO poronbv_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Os descendentes de Manassés foram: os maquiritas, que tinham esse nome por causa de Maquir, filho de Manassés. Maquir teve um filho chamado Gileade, de onde vem a família dos gileaditas. ");
INSERT INTO poronbv_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Estes foram os descendentes de Gileade: os jezeritas, que tinham esse nome por causa de Jezer; os helequitas, que tinham esse nome por causa de Heleque; ");
INSERT INTO poronbv_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","os asrielitas, que tinham esse nome por causa de Asriel; os siquemitas, que tinham esse nome por causa de Siquém; ");
INSERT INTO poronbv_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","os semidaítas, que tinham esse nome por causa de Semida; os heferitas, que tinham esse nome por causa de Héfer. ");
INSERT INTO poronbv_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Mas Zelofeade, filho de Héfer, não teve filhos, apenas filhas, que foram: Maalá, Noa, Hogla, Milca e Tirza. ");
INSERT INTO poronbv_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Foram contados dos grupos de famílias de Manassés 52.700 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Os descendentes de Efraim segundo os seus grupos de famílias foram: os sutelaítas, que tinham esse nome por causa de Sutela; os bequeritas, que tinham esse nome por causa de Bequer; os taanitas, que tinham esse nome por causa de Taã. ");
INSERT INTO poronbv_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Estes foram os descendentes de Sutela: a família dos eramitas surgiu de Erã, filho de Sutela. ");
INSERT INTO poronbv_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Foram contados dos grupos de famílias de Efraim 32.500 homens. Esses foram os descendentes de José segundo os seus grupos de famílias. ");
INSERT INTO poronbv_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Os descendentes de Benjamim segundo os seus grupos de famílias foram: os belaítas, que tinham esse nome por causa de Belá; os asbelitas, que tinham esse nome por causa de Asbel; os airamitas, que tinham esse nome por causa de Airã; ");
INSERT INTO poronbv_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","os sufamitas, que tinham esse nome por causa de Sufã; os hufamitas, que tinham esse nome por causa de Hufã. ");
INSERT INTO poronbv_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Surgiram duas famílias a partir dos filhos de Belá: os arditas que tinham esse nome por causa de Arde, e os naamitas, que tinham esse nome por causa de Naamã. ");
INSERT INTO poronbv_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Foram contados dos grupos de famílias de Benjamim 45.600 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Os descendentes de Dã segundo os seus grupos de famílias foram: os suamitas, que tinham esse nome por causa de Suã, filho de Dã. Esses foram os grupos de famílias de Dã ");
INSERT INTO poronbv_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Foram contados dos grupos de famílias de Dã (todos eles dos grupos de famílias suamitas) 64.400 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Os descendentes de Aser segundo os seus grupos de famílias foram: os imnaítas, que tinham esse nome por causa de Imna; os isvitas, que tinham esse nome por causa de Isvi; os beriaítas, que tinham esse nome por causa de Berias. ");
INSERT INTO poronbv_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Surgiram duas famílias a partir dos filhos de Berias: os heberitas, que tinham esse nome por causa de Héber, e os malquielitas, que tinham esse nome por causa de Malquiel. ");
INSERT INTO poronbv_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aser teve uma filha chamada Sera. ");
INSERT INTO poronbv_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Foram contados dos grupos de famílias de Aser 53.400 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Os descendentes de Naftali segundo os seus grupos de famílias foram: os jazeelitas, que tinham esse nome por causa de Jazeel; os gunitas, que tinham esse nome por causa de Guni; ");
INSERT INTO poronbv_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","os jezeritas, que tinham esse nome por causa de Jezer; os silemitas, que tinham esse nome por causa de Silém. ");
INSERT INTO poronbv_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Foram contados dos grupos de famílias de Naftali 45.400 homens. ");
INSERT INTO poronbv_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","O número total de homens contados em Israel foi de 601.730. ");
INSERT INTO poronbv_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Então o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“A terra será dividida entre eles como herança, de acordo com o recenseamento. ");
INSERT INTO poronbv_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","A um grupo de famílias maior dê uma herança maior, e a um grupo de famílias menor, uma herança menor; cada um receberá a herança proporcional ao seu número de homens contados. ");
INSERT INTO poronbv_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","A terra será repartida por sorteio. Cada um herdará sua parte de acordo com o nome da tribo de seus pais. ");
INSERT INTO poronbv_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Os líderes das tribos maiores devem se reunir para sortear os pedaços maiores de terra entre si, e os líderes das tribos menores devem se reunir para sortear os pedaços de terra menores entre si”. ");
INSERT INTO poronbv_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","E estas são as famílias dos levitas contadas no recenseamento de acordo com os seus grupos de famílias: os gersonitas, que tinham esse nome por causa de Gérson; os coatitas, que tinham esse nome por causa de Coate; os meraritas, que tinham esse nome por causa de Merari. ");
INSERT INTO poronbv_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","E também havia os seguintes grupos de famílias entre os levitas: os libnitas, os hebronitas, os malitas, os musitas e os coreítas. E Coate era o pai de Anrão. ");
INSERT INTO poronbv_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Quando Levi estava no Egito, teve uma filha chamada Joquebede que se casou com Anrão, filho de Coate. E os filhos de Anrão e Joquebede foram Moisés, Arão e Miriã. ");
INSERT INTO poronbv_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","E os filhos de Arão foram Nadabe, Abiú, Eleazar e Itamar, ");
INSERT INTO poronbv_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","mas Nadabe e Abiú morreram quando ofereceram ao Senhor fogo que não era sagrado. ");
INSERT INTO poronbv_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","O número total de levitas contados do sexo masculino de um mês para cima foi de 23.000. Eles não foram contados junto com os outros israelitas porque não receberam propriedade na divisão da terra entre as tribos. ");
INSERT INTO poronbv_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Foram estes os que foram contados por Moisés e o sacerdote Eleazar, nas campinas de Moabe ao lado do rio Jordão, do outro lado de Jericó. ");
INSERT INTO poronbv_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Nenhum deles estava entre os israelitas que foram contados por Moisés e o sacerdote Arão no deserto de Sinai, ");
INSERT INTO poronbv_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","porque o Senhor havia dito que aqueles israelitas iriam morrer no deserto. Nenhum deles sobreviveu, exceto Calebe, filho de Jefoné, e Josué, filho de Num. ");
INSERT INTO poronbv_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Vieram então as filhas de Zelofeade, que era filho de Héfer, que era filho de Maquir, que era filho de Manassés; Zelofeade pertencia ao grupo de famílias de Manassés, que era filho de José. Os nomes das filhas de Zelofeade eram Maalá, Noa, Hogla, Milca e Tirza. ");
INSERT INTO poronbv_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Elas se prostraram à entrada do Tabernáculo diante de Moisés, do sacerdote Eleazar, dos líderes do povo e de toda a comunidade de Israel, e disseram: ");
INSERT INTO poronbv_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Nosso pai morreu no deserto. Ele não participou da revolta de Coré, que se ajuntaram contra o Senhor, mas morreu por causa do seu próprio pecado e não teve filhos. ");
INSERT INTO poronbv_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Então por que o nome de nosso pai deveria desaparecer do seu grupo de famílias por não ter tido filhos? Achamos que deveríamos receber uma propriedade junto com os irmãos de nosso pai”. ");
INSERT INTO poronbv_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Então Moisés levou o caso perante o Senhor, ");
INSERT INTO poronbv_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","e o Senhor respondeu a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“As filhas de Zelofeade estão certas. Você deve dar a elas uma propriedade por herança entre os parentes de seu pai, e passará a elas a herança de seu pai. ");
INSERT INTO poronbv_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Diga aos israelitas: Quando um homem morrer e não deixar filhos, a herança pertencerá à sua filha. ");
INSERT INTO poronbv_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Se ele não tiver filha, então a herança pertencerá aos irmãos dele. ");
INSERT INTO poronbv_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","E se não tiver irmãos, a herança pertencerá aos irmãos de seu pai. ");
INSERT INTO poronbv_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","E se o pai não tiver irmãos, a herança pertencerá ao parente mais próximo do seu grupo de famílias. Esta lei deve ser obedecida pelos israelitas, como o Senhor ordenou a Moisés”. ");
INSERT INTO poronbv_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Depois o Senhor disse a Moisés: “Suba até o alto do monte Abarim e olhe a terra que dei ao povo de Israel. ");
INSERT INTO poronbv_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Depois de ver a terra, você morrerá, como seu irmão Arão, ");
INSERT INTO poronbv_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","porque vocês dois desobedeceram à minha ordem de reconhecer diante deles o meu santo nome, quando a comunidade se rebelou nas águas do deserto de Zim”. Isso aconteceu nas águas de Meribá de Cades, no deserto de Zim. ");
INSERT INTO poronbv_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Então Moisés disse ao Senhor: ");
INSERT INTO poronbv_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Ó Senhor, o Deus que cria e conserva toda a vida, aponte um homem para liderar este povo, ");
INSERT INTO poronbv_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","alguém que guie o povo e vá com ele à guerra, para que o povo de Israel não seja como ovelha sem pastor”. ");
INSERT INTO poronbv_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Então o Senhor disse a Moisés: “Chame Josué, filho de Num, que tem o Espírito, e imponha as mãos sobre ele. ");
INSERT INTO poronbv_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Apresente-o ao sacerdote Eleazar e a toda a comunidade e transmita as ordens para ele na presença de todos. ");
INSERT INTO poronbv_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ponha sobre ele a sua autoridade, para que todo o povo obedeça ao novo líder. ");
INSERT INTO poronbv_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ele deverá apresentar-se ao sacerdote Eleazar, que consultará o Urim perante o Senhor para conhecer a vontade do Senhor. Josué e toda a comunidade de Israel seguirão as suas instruções. É assim que o Senhor continuará guiando o povo”. ");
INSERT INTO poronbv_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moisés fez de acordo com a vontade do Senhor; chamou Josué e o mostrou ao sacerdote Eleazar e a toda a comunidade. ");
INSERT INTO poronbv_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Impôs as mãos sobre ele e transmitiu as ordens do Senhor e o tornou seu sucessor. ");
INSERT INTO poronbv_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Ordene aos israelitas e diga-lhes: Tenham cuidado para não se esquecer de me trazer nos dias certos as ofertas de alimento preparadas no fogo, como aroma agradável para mim. ");
INSERT INTO poronbv_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Diga-lhes: Diariamente vocês devem oferecer ao Senhor como oferta queimada dois carneiros sem defeito e com um ano de idade. ");
INSERT INTO poronbv_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ofereçam um cordeiro de manhã e outro no fim da tarde, ");
INSERT INTO poronbv_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","juntamente com uma oferta de cereais de um jarro da melhor farinha amassada com um litro de azeite. ");
INSERT INTO poronbv_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Essa oferta queimada é diária, conforme foi instituído no monte Sinai, de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Junto com cada cordeiro deve haver a oferta de bebida de um litro de bebida fermentada. Derrame a oferta de bebida para o Senhor no santuário. ");
INSERT INTO poronbv_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","No fim da tarde ofereçam o outro cordeiro, junto com as mesmas ofertas de cereais e de bebida que vocês prepararam pela manhã. Essa oferta queimada será de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Todo sábado ofereçam dois carneiros de um ano, sem defeito, como oferta queimada, juntamente com a oferta de bebida e a oferta de cereais de dois jarros da melhor farinha amassada com azeite. ");
INSERT INTO poronbv_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Essa é a oferta queimada para cada sábado, além da oferta queimada diária e da oferta de bebida. ");
INSERT INTO poronbv_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“No início de cada mês, apresentem ao Senhor dois novilhos como oferta queimada, um carneiro e sete cordeiros de um ano. Esses animais não devem ter defeito. ");
INSERT INTO poronbv_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Para cada novilho ofereçam uma oferta de cereais de três jarros da melhor farinha amassada com azeite; para o carneiro, uma oferta de cereais de dois jarros da melhor farinha amassada com azeite; ");
INSERT INTO poronbv_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","e para cada cordeiro, uma oferta de cereais de um jarro da melhor farinha amassada com azeite. Essa oferta queimada é de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Para cada sacrifício deve haver ofertas de bebida: dois litros de vinho; para o carneiro, um litro; e para cada cordeiro, um litro de vinho. Essa será a oferta queimada mensal, durante todo o ano. ");
INSERT INTO poronbv_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Além da oferta queimada contínua, juntamente com a oferta de bebida, será oferecido ao Senhor um bode como oferta pelo pecado. ");
INSERT INTO poronbv_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“No décimo quarto dia do primeiro mês de cada ano vocês devem celebrar a Páscoa do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","No décimo quinto dia desse mês começará uma festa de sete dias de duração; nesses dias comam pão sem fermento. ");
INSERT INTO poronbv_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","No primeiro dia da festa haverá uma santa convocação. Nesse dia ninguém trabalhará. ");
INSERT INTO poronbv_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Ofereçam ao Senhor uma oferta queimada de dois novilhos, um carneiro e sete cordeiros de um ano. Esses animais não podem ter defeito. ");
INSERT INTO poronbv_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","A oferta de cereais deve ser de três jarros da melhor farinha amassada com azeite para cada novilho; dois jarros para o carneiro; ");
INSERT INTO poronbv_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","e um jarro para cada um dos sete cordeiros. ");
INSERT INTO poronbv_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Vocês também devem oferecer um bode como oferta pelo pecado, para obter o perdão dos pecados de vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Apresentem essas ofertas, além da oferta queimada de cada manhã. ");
INSERT INTO poronbv_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Assim preparem cada dia, durante sete dias, o alimento para a oferta queimada de aroma agradável ao Senhor, além da oferta queimada diária junto com a oferta de bebida. ");
INSERT INTO poronbv_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","No sétimo dia da festa vocês terão uma santa convocação. Nesse dia ninguém deverá trabalhar. ");
INSERT INTO poronbv_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“O povo também deve se reunir no dia da festa da colheita dos primeiros frutos, na Festa das Semanas, quando apresentarão ao Senhor uma oferta com os primeiros frutos da colheita que começa. Nesse dia terão uma santa convocação e ninguém deverá trabalhar. ");
INSERT INTO poronbv_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Vocês então devem oferecer ao Senhor dois novilhos, um carneiro e sete cordeiros de um ano de idade como oferta queimada, de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","A oferta de cereais deve ser de três jarros da melhor farinha amassada com azeite para cada novilho; dois jarros para cada carneiro; ");
INSERT INTO poronbv_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","e um jarro para cada um dos sete cordeiros. ");
INSERT INTO poronbv_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Vocês também devem oferecer um bode como oferta pelo pecado, para obter o perdão dos pecados de vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Preparem todas essas ofertas além das ofertas queimadas diárias e da oferta de cereais e de bebida. Lembrem-se que os animais oferecidos devem ser sem defeito. ");
INSERT INTO poronbv_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“No primeiro dia do sétimo mês de cada ano tenham uma santa convocação. Nesse dia ninguém deverá trabalhar. Esse será o dia da Festa das Trombetas. ");
INSERT INTO poronbv_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Vocês devem oferecer como oferta queimada, com aroma agradável ao Senhor, um novilho, um carneiro e sete cordeiros de um ano. Todos esses animais não devem ter defeito. ");
INSERT INTO poronbv_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","A oferta de cereais deve ser de três jarros da melhor farinha amassada com azeite para cada novilho; dois jarros para cada carneiro; ");
INSERT INTO poronbv_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","e um jarro para cada um dos sete cordeiros. ");
INSERT INTO poronbv_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Vocês também devem oferecer um bode como oferta pelo pecado, para obter o perdão dos pecados de vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Vocês devem trazer essas ofertas, além das ofertas queimadas mensais e diárias, que vêm acompanhadas de ofertas de cereais e de bebida. Você devem apresentar essas ofertas de acordo com as ordens do Senhor, pois as ofertas queimadas devem ser de aroma agradável ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“No sétimo dia desse mês vocês terão uma santa convocação. Esse será um dia em que vocês se humilharão perante o Senhor. Ninguém deverá trabalhar nesse dia. ");
INSERT INTO poronbv_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","O povo deve oferecer como aroma agradável ao Senhor uma oferta queimada de um novilho, de um carneiro e de sete cordeiros de um ano de idade. Todos esses animais não devem ter nenhum defeito. ");
INSERT INTO poronbv_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","A oferta de cereais deve ser de três jarros da melhor farinha amassada com azeite para cada novilho; dois jarros para cada carneiro; ");
INSERT INTO poronbv_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","e um jarro para cada um dos sete cordeiros. ");
INSERT INTO poronbv_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Vocês também devem oferecer um bode como oferta pelo pecado, para obter o perdão dos pecados de vocês, além do bode que é oferecido para purificar o povo, e da oferta queimada diária, junto com as ofertas de cereais e de bebida. ");
INSERT INTO poronbv_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“No décimo quinto dia do sétimo mês, vocês terão uma santa convocação. Ninguém deverá trabalhar nesse dia. Celebrem uma festa ao Senhor durante sete dias. ");
INSERT INTO poronbv_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Apresentem a seguinte oferta queimada de aroma agradável ao Senhor: treze novilhos, dois carneiros e catorze cordeiros de um ano de idade. Todos esses animais não devem ter defeito. ");
INSERT INTO poronbv_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","A oferta de cereais deve ser de três jarros da melhor farinha amassada com azeite para cada um dos treze novilhos; dois jarros para cada carneiro; ");
INSERT INTO poronbv_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","e um jarro para cada um dos quatorze cordeiros. ");
INSERT INTO poronbv_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Vocês também devem oferecer um bode como oferta pelo pecado, além da oferta queimada diária, junto com as ofertas de cereais e de bebidas. ");
INSERT INTO poronbv_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“No segundo dia da festa vocês devem oferecer doze novilhos, dois carneiros e quatorze cordeiros de um ano de idade, todos sem defeito. ");
INSERT INTO poronbv_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","As ofertas de cereais e de bebida para os novilhos, para os carneiros e para os cordeiros devem ser de acordo com o seu número, segundo o regulamento. ");
INSERT INTO poronbv_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Vocês também devem oferecer um bode como oferta pelo pecado, além da oferta queimada diária, junto com as ofertas de cereais e de bebida. ");
INSERT INTO poronbv_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“No terceiro dia da festa vocês devem oferecer onze novilhos, dois carneiros e quatorze cordeiros de um ano de idade, todos sem defeito. ");
INSERT INTO poronbv_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","As ofertas de cereais e de bebida para os novilhos, para os carneiros e para os cordeiros devem ser de acordo com o seu número, segundo o regulamento. ");
INSERT INTO poronbv_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Vocês também devem oferecer um bode como oferta pelo pecado, além da oferta queimada diária, junto com as ofertas de cereais e de bebida. ");
INSERT INTO poronbv_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“No quarto dia da festa vocês devem oferecer dez novilhos, dois carneiros e quatorze cordeiros de um ano de idade, todos sem defeito. ");
INSERT INTO poronbv_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","As ofertas de cereais e de bebida para os novilhos, para os carneiros e para os cordeiros devem ser de acordo com o seu número, segundo o regulamento. ");
INSERT INTO poronbv_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Vocês também devem oferecer um bode como oferta pelo pecado, além da oferta queimada diária, junto com as ofertas de cereais e de bebida. ");
INSERT INTO poronbv_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“No quinto dia da festa vocês devem oferecer nove novilhos, dois carneiros e quatorze cordeiros de um ano de idade, todos sem defeito. ");
INSERT INTO poronbv_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","As ofertas de cereais e de bebida para os novilhos, para os carneiros e para os cordeiros devem ser de acordo com o seu número, segundo o regulamento. ");
INSERT INTO poronbv_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Vocês também devem oferecer um bode como oferta pelo pecado, além da oferta queimada diária, junto com as ofertas de cereais e de bebida. ");
INSERT INTO poronbv_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“No sexto dia da festa vocês devem oferecer oito novilhos, dois carneiros e quatorze cordeiros de um ano de idade, todos sem defeito. ");
INSERT INTO poronbv_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","As ofertas de cereais e de bebida para os novilhos, para os carneiros e para os cordeiros devem ser de acordo com o seu número, segundo o regulamento. ");
INSERT INTO poronbv_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Vocês também devem oferecer um bode como oferta pelo pecado, além da oferta queimada diária, junto com as ofertas de cereais e de bebida. ");
INSERT INTO poronbv_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“No sétimo dia da festa vocês devem oferecer sete novilhos, dois carneiros e quatorze cordeiros de um ano de idade, todos sem defeito. ");
INSERT INTO poronbv_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","As ofertas de cereais e de bebida para os novilhos, para os carneiros e para os cordeiros devem ser de acordo com o seu número, segundo o regulamento. ");
INSERT INTO poronbv_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Vocês também devem oferecer um bode como oferta pelo pecado, além da oferta queimada diária, junto com as ofertas de cereais e de bebida. ");
INSERT INTO poronbv_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“No oitavo dia vocês terão uma santa convocação. Ninguém deve trabalhar nesse dia. ");
INSERT INTO poronbv_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Apresentem uma oferta queimada, de aroma agradável ao Senhor. Essa oferta será de um novilho, um carneiro e sete cordeiros de um ano, e os animais não poderão ter defeito. ");
INSERT INTO poronbv_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","As ofertas de cereais e de bebidas devem ser de acordo com o número de animais e de acordo com as exigências da lei. ");
INSERT INTO poronbv_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Ofereçam também um bode como oferta pelo pecado, além da oferta queimada diária, junto com as ofertas de cereais e de bebida. ");
INSERT INTO poronbv_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“Além dos votos que fizerem e das ofertas voluntárias, estas são as ofertas que vocês devem apresentar ao Senhor nas solenidades de vocês: as ofertas queimadas, as ofertas de cereais, as ofertas de bebida e as ofertas de paz”. ");
INSERT INTO poronbv_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","E Moisés falou ao povo todas essas coisas que o Senhor havia ordenado. ");
INSERT INTO poronbv_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moisés reuniu os líderes das tribos de Israel e disse: “Isto é o que o Senhor ordena: ");
INSERT INTO poronbv_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Quando um homem fizer um voto ao Senhor ou um juramento que o envolva em algum compromisso, não poderá quebrar a palavra, mas deverá fazer tudo o que prometeu. ");
INSERT INTO poronbv_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Quando uma moça morar com os pais e fizer um voto ao Senhor para fazer ou deixar de fazer alguma coisa, ");
INSERT INTO poronbv_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","e o pai souber do voto e ficar quieto, então a moça terá de manter a palavra e cumprir o que prometeu ou jurou. ");
INSERT INTO poronbv_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Mas, se o pai da moça no dia em que souber do voto proibi-la de cumprir o que havia prometido, então a moça não precisará cumprir a sua palavra. O Senhor a perdoará, pois o pai não a deixou cumprir o que ela havia prometido. ");
INSERT INTO poronbv_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Mas se ela se casar depois de fazer um voto, mesmo que seja uma promessa feita de forma precipitada, sem pensar nas consequências, ");
INSERT INTO poronbv_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","e o seu marido, ao tomar conhecimento, nada lhe disser, ela deverá manter a palavra e cumprir a promessa. ");
INSERT INTO poronbv_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Mas, se o seu marido a proibir quando souber do voto, então ela não terá mais a obrigação de cumprir a sua palavra, e o Senhor a perdoará. ");
INSERT INTO poronbv_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Mas se a mulher é viúva ou divorciada, então deve cumprir o seu voto. ");
INSERT INTO poronbv_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“E se uma mulher que vive com o seu marido fizer um voto ou juramento para fazer ou deixar de fazer alguma coisa, ");
INSERT INTO poronbv_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","e se o seu marido souber, mas nada disser e não a proibir, então ela deverá cumprir tudo o que prometeu ou jurou. ");
INSERT INTO poronbv_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Mas se o marido, logo que souber, a proibir de cumprir tudo o que prometeu, então ela não precisa mais cumprir a sua palavra, e o Senhor a perdoará. ");
INSERT INTO poronbv_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Seu marido pode confirmar ou anular qualquer voto ou qualquer juramento que tenha feito, que a obrigue a humilhar-se. ");
INSERT INTO poronbv_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Mas, se o marido até o dia seguinte nada disser a respeito do assunto, então ele mostra que concorda com todos os votos ou obrigações. ");
INSERT INTO poronbv_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Mas, se ele depois de certo tempo os anular depois de ouvi-los, então ele responderá pela culpa dela”. ");
INSERT INTO poronbv_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Essas são as ordens que o Senhor deu a Moisés a respeito da relação entre marido e mulher, e entre uma moça e seu pai que ainda mora com a família. ");
INSERT INTO poronbv_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Vinguese dos midianitas pelo que fizeram ao povo de Israel. Depois disso você será reunido aos seus antepassados”. ");
INSERT INTO poronbv_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Então Moisés disse ao povo: “Alguns de vocês devem se preparar para lutar e realizar a vingança do Senhor contra os midianitas. ");
INSERT INTO poronbv_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Enviem à guerra mil homens de cada tribo de Israel”. ");
INSERT INTO poronbv_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Assim, dos milhares de israelitas foram separados de cada tribo mil soldados armados. O total de homens armados para a guerra foi de 12.000. ");
INSERT INTO poronbv_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","E Moisés mandou à guerra mil homens de cada tribo, juntamente com Fineias, filho do sacerdote Eleazar, que levava as trombetas sagradas para o toque de alarme. ");
INSERT INTO poronbv_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","E lutaram contra os midianitas, de acordo com as ordens que o Senhor tinha dado a Moisés, e mataram todos os homens. ");
INSERT INTO poronbv_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Entre os mortos estavam os cinco reis dos midianitas: Evi, Requém, Zur, Hur e Reba. Também mataram Balaão, filho de Beor. ");
INSERT INTO poronbv_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Os israelitas capturaram as mulheres e os filhos. Levaram também todo o seu gado e as posses dos midianitas. ");
INSERT INTO poronbv_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Queimaram todas as cidades em que os midianitas habitavam e todos os seus acampamentos. ");
INSERT INTO poronbv_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Tomaram todos os despojos além das pessoas e animais. ");
INSERT INTO poronbv_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Então trouxeram os prisioneiros e os despojos dos midianitas a Moisés, ao sacerdote Eleazar e a toda a comunidade de Israel, ao acampamento nas campinas de Moabe, junto ao rio Jordão, do outro lado de Jericó. ");
INSERT INTO poronbv_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moisés, o sacerdote Eleazar e todos os líderes do povo saíram e foram receber o exército fora do acampamento. ");
INSERT INTO poronbv_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Mas Moisés ficou irado com os oficiais do exército, os comandantes dos milhares e os comandantes de centenas, que voltaram da guerra. ");
INSERT INTO poronbv_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Ele perguntou: “Por que vocês deixaram viver todas as mulheres? ");
INSERT INTO poronbv_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Foram elas que seguiram o conselho de Balaão e levaram o povo de Israel a adorar ídolos no monte Peor, quando veio uma praga para castigar o povo do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Agora matem todas as crianças do sexo masculino e também todas as mulheres que já tiveram relação com algum homem. ");
INSERT INTO poronbv_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Mas deixem viver todas as meninas e também as moças que ainda são virgens. ");
INSERT INTO poronbv_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Todos vocês devem ficar fora do acampamento por uma semana. Todo aquele que matou alguém ou que tocou em algum morto deve se purificar no terceiro e no sétimo dia. Isso também se aplica aos seus prisioneiros. ");
INSERT INTO poronbv_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Vocês também devem purificar toda a roupa e também tudo que é feito de couro, de pelos de cabra, e também todo objeto de madeira”. ");
INSERT INTO poronbv_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Então o sacerdote Eleazar disse aos homens do exército que foram à guerra: “Estas são as ordens que o Senhor deu a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","O ouro, a prata, o bronze, o ferro, o estanho, o chumbo ");
INSERT INTO poronbv_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","e tudo aquilo que resiste ao fogo vocês terão de passar pelo fogo, para que seja purificado. Vocês também deverão purificar esses metais com a água da purificação. Mas tudo o que não resistir ao fogo terá de passar pela água. ");
INSERT INTO poronbv_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Vocês também devem lavar as roupas no sétimo dia para ficarem puros. Depois poderão entrar no acampamento”. ");
INSERT INTO poronbv_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","E o Senhor também disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Você, o sacerdote Eleazar e as autoridades das famílias do povo devem contar as pessoas e os animais capturados. ");
INSERT INTO poronbv_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Dividam em duas partes o que foi tomado. Uma parte será dos que foram à guerra, e a outra parte será do povo. ");
INSERT INTO poronbv_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Daquilo que os soldados trouxeram da guerra, separem um ‘tributo’ ao Senhor: de cada 500, um pertence ao Senhor, seja de pessoas, bois, jumentos ou ovelhas. ");
INSERT INTO poronbv_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Tomem a metade desse tributo que foi dado a eles e entreguem ao sacerdote Eleazar, como oferta ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","E da parte que pertence ao povo, de cada 50 um pertence ao Senhor, seja de pessoas, bois, jumentos, ovelhas, ou de qualquer outro animal, e entreguem-no aos levitas encarregados de cuidar do Tabernáculo do Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Então Moisés e o sacerdote Eleazar fizeram como o Senhor havia ordenado. ");
INSERT INTO poronbv_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","O total de pessoas e animais capturados pelos soldados, além das joias, roupas e outros objetos que eles guardaram para si, foi: 675.000 ovelhas, ");
INSERT INTO poronbv_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72.000 cabeças de gado, ");
INSERT INTO poronbv_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61.000 jumentos ");
INSERT INTO poronbv_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","e 32.000 moças que não tiveram relação com um homem. ");
INSERT INTO poronbv_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Então, a metade destinada aos que foram à guerra foi de 337.500 ovelhas, ");
INSERT INTO poronbv_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","das quais o tributo para o Senhor foi de 675 ovelhas; ");
INSERT INTO poronbv_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36.000 cabeças de gado, das quais o imposto para o Senhor foi de 72 cabeças; ");
INSERT INTO poronbv_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30.500 jumentos, dos quais o imposto para o Senhor foi de 61 jumentos; ");
INSERT INTO poronbv_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16.000 pessoas, das quais o tributo para o Senhor foi de 32 pessoas. ");
INSERT INTO poronbv_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moisés entregou o tributo ao sacerdote Eleazar como oferta ao Senhor, como ele havia ordenado a Moisés. ");
INSERT INTO poronbv_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","A outra parte, que pertencia ao povo de Israel, Moisés separou da parte que pertencia aos homens que foram à guerra. ");
INSERT INTO poronbv_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Essa foi a parte que pertencia à comunidade de Israel: 337.500 ovelhas, ");
INSERT INTO poronbv_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36.000 cabeças de gado, ");
INSERT INTO poronbv_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30.500 jumentos ");
INSERT INTO poronbv_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","e 16.000 pessoas. ");
INSERT INTO poronbv_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Da metade pertencente ao povo de Israel, Moisés separou um de cada cinquenta, tanto de pessoas como de animais, de acordo com o que o Senhor havia ordenado, e os entregou aos levitas, encarregados de cuidar do Tabernáculo do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Então os oficiais do exército, os comandantes de milhares e os comandantes de centenas foram a Moisés ");
INSERT INTO poronbv_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","e disseram: “Seus servos fizeram a contagem dos que foram à guerra e verificamos que não está faltando ninguém, ");
INSERT INTO poronbv_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","por isso trouxemos como oferta ao Senhor o que encontramos em objetos de ouro: braceletes, pulseiras, anéis-selo, brincos e colares para o pagamento pelo nosso pecado perante o Senhor”. ");
INSERT INTO poronbv_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","E Moisés e o sacerdote Eleazar receberam esses objetos de ouro, todos bem trabalhados. ");
INSERT INTO poronbv_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","O total do ouro da oferta que os comandantes de milhares e os comandantes de centenas ofereceram ao Senhor foi de 200 quilos. ");
INSERT INTO poronbv_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Cada homem que foi à guerra tinha tomado despojos para si mesmo. ");
INSERT INTO poronbv_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moisés e o sacerdote Eleazar receberam o ouro entregue pelos comandantes de milhares e pelos comandantes de centenas e o levaram até o Tabernáculo, perante o Senhor, para servir de lembrança permanente para os israelitas. ");
INSERT INTO poronbv_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Quando os israelitas chegaram às terras de Jazar e Gileade, as tribos de Rúben e Gade, que possuíam grandes rebanhos de gado, viram que o lugar era muito bom para a criação de animais. ");
INSERT INTO poronbv_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Então eles foram a Moisés, ao sacerdote Eleazar, e aos outros líderes do povo, e disseram: ");
INSERT INTO poronbv_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atarote, Dibom, Jazar, Nimra, Hesbom, Eleal, Sebã, Nebo e Beom, ");
INSERT INTO poronbv_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","terras que o Senhor nos entregou perante a comunidade de Israel, é terra excelente para a criação de gado, e os seus servos têm muito gado”. ");
INSERT INTO poronbv_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","E acrescentaram: “Por isso pedimos para ficar com esta terra como herança, em vez de cruzar o rio Jordão”. ");
INSERT INTO poronbv_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mas Moisés respondeu às tribos de Rúben e Gade: “E os seus irmãos irão à guerra enquanto vocês ficam aqui? ");
INSERT INTO poronbv_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Por que vocês desencorajam os israelitas para que não entrem na terra que o Senhor lhes está dando? ");
INSERT INTO poronbv_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Aliás, os seus pais fizeram a mesma coisa, quando estávamos em Cades-Barneia, quando enviei alguns homens para espionar a terra. ");
INSERT INTO poronbv_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Quando chegaram até o vale de Escol e viram a terra, desencorajaram o povo para não conquistar a terra que o Senhor nos deu. ");
INSERT INTO poronbv_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","E o Senhor ficou irado naquele dia, e fez o seguinte juramento: ");
INSERT INTO poronbv_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Nenhum dos homens que saíram do Egito com mais de 20 anos de idade verá a terra que prometi a Abraão, Isaque e Jacó. ");
INSERT INTO poronbv_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Calebe, filho de Jefoné, o quenezeu, e Josué, filho de Num, foram os únicos que continuaram fiéis ao Senhor’. ");
INSERT INTO poronbv_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Por isso o Senhor ficou irado com Israel e fez o povo andar sem destino durante 40 anos pelo deserto, até que morresse toda aquela geração que tinha desagradado ao Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“E agora vocês, multidão de homens pecadores, estão fazendo as mesmas coisas que seus pais fizeram, para aumentar ainda mais a ira do Senhor contra Israel. ");
INSERT INTO poronbv_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Se vocês deixarem de segui-lo, ele deixará todo o povo outra vez no deserto, e vocês serão culpados pela destruição deles”. ");
INSERT INTO poronbv_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Então as tribos de Rúben e de Gade se aproximaram de Moisés e disseram: “Construiremos aqui currais para o nosso gado e cidades para os nossos filhos. ");
INSERT INTO poronbv_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Mas nós nos prepararemos para a guerra, e estaremos prontos para irmos à frente do povo até que o levemos ao seu destino. Porém as nossas crianças morarão em cidades fortificadas para estarem protegidas dos ataques dos habitantes da terra. ");
INSERT INTO poronbv_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","E não voltaremos para os nossos lares até que todo o povo conquiste toda a terra que o Senhor deu como herança. ");
INSERT INTO poronbv_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Não herdaremos com eles a terra do outro lado do Jordão, pois preferimos ficar aqui, no lado leste do Jordão”. ");
INSERT INTO poronbv_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Então Moisés disse-lhes: “Está certo. Se vocês se prepararem para a batalha perante o Senhor, ");
INSERT INTO poronbv_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","e se, armados, atravessarem o Jordão perante o Senhor, até que ele tenha expulsado os seus inimigos diante dele, ");
INSERT INTO poronbv_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","e a terra seja conquistada para o Senhor, então vocês poderão voltar para cá e estarão livres da sua obrigação perante o Senhor e perante Israel. E o Senhor dará esta terra como propriedade para vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Mas, se vocês não fizerem como prometeram, então estarão pecando contra o Senhor e sofrerão as consequências do seu pecado. ");
INSERT INTO poronbv_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Construam cidades para as crianças e currais para os seus rebanhos, mas cumpram o que prometeram”. ");
INSERT INTO poronbv_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Então os homens de Gade e os filhos de Rúben responderam a Moisés: “Nós, seus servos, obedeceremos às ordens do senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nossos filhos e nossas mulheres, nossos rebanhos e todos os animais ficarão aqui nas cidades de Gileade, ");
INSERT INTO poronbv_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","mas nós, os seus servos, nos prepararemos para a guerra e atravessaremos para lutar perante o Senhor, de acordo com o que senhor está dizendo”. ");
INSERT INTO poronbv_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Então Moisés deu a seguinte ordem ao sacerdote Eleazar, a Josué, filho de Num, e aos chefes das famílias das tribos israelitas: ");
INSERT INTO poronbv_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Se os homens das tribos de Gade e de Rúben atravessarem armados com vocês o Jordão, perante o Senhor, e vocês tomarem a terra, então vocês devem entregar a eles como propriedade a terra de Gileade. ");
INSERT INTO poronbv_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Mas, se eles não se prepararem para a guerra e não atravessarem armados com vocês o rio Jordão, então terão de aceitar a herança deles na terra de Canaã”. ");
INSERT INTO poronbv_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","E as tribos de Gade e Rúben responderam: “Faremos o que o Senhor falou aos seus servos. ");
INSERT INTO poronbv_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Nós atravessaremos armados perante o Senhor e iremos à terra de Canaã, depois tomaremos conta da nossa parte deste lado do rio Jordão”. ");
INSERT INTO poronbv_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Moisés deu às tribos de Gade e de Rúben e à metade da tribo de Manassés, filho de José, o reino de Seom, rei dos amorreus, e o reino de Ogue, rei de Basã, toda a terra com as suas cidades e o território ao redor delas. ");
INSERT INTO poronbv_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","A tribo de Gade construiu as cidades de Dibom, Atarote, Aroer, ");
INSERT INTO poronbv_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atarote-Sofã, Jazar, Jogbeá, ");
INSERT INTO poronbv_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bete-Nimra e Bete-Harã. Construíram muralhas ao redor delas e currais para os rebanhos. ");
INSERT INTO poronbv_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","E a tribo de Rúben reconstruiu as seguintes cidades: Hesbom, Eleal, Quiriataim, ");
INSERT INTO poronbv_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","bem como Nebo, Baal-Meom e Sibma. Os israelitas mais tarde mudaram os nomes das cidades que reconstruíram. ");
INSERT INTO poronbv_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Os descendentes de Maquir, filho de Manassés, foram a Gileade, tomaram a cidade e expulsaram os amorreus que moravam ali. ");
INSERT INTO poronbv_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Então Moisés deu Gileade a Maquir, descendente de Manassés, e eles passaram a morar ali. ");
INSERT INTO poronbv_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair, descendente de Manassés, conquistou os povoados e mudou o nome da região para Havote-Jair. ");
INSERT INTO poronbv_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","E um homem chamado Noba conquistou a cidade de Quenate com seus povoados, e chamou-a pelo seu nome Noba. ");
INSERT INTO poronbv_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Este é o caminho que o povo de Israel percorreu debaixo das ordens de Moisés e Arão desde que saiu do Egito. ");
INSERT INTO poronbv_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moisés escreveu as etapas das jornadas, de acordo com os pontos de partida, conforme as ordens do Senhor. ");
INSERT INTO poronbv_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","O povo partiu de Ramessés no dia quinze do primeiro mês, ou seja, um dia depois da Páscoa. Saíram marchando triunfantes diante dos olhos de todos os egípcios, ");
INSERT INTO poronbv_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","enquanto os egípcios sepultavam cada um o filho mais velho que o Senhor havia ferido. Assim o Senhor fez justiça contra os seus deuses. ");
INSERT INTO poronbv_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Depois de os israelitas partirem de Ramessés, acamparam em Sucote. ");
INSERT INTO poronbv_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Saíram de Sucote e foram para Etã, que fica à beira do deserto. ");
INSERT INTO poronbv_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Saíram de Etã e voltaram a Pi-Hairote, a leste de Baal-Zefom, e acamparam perto do monte Migdol. ");
INSERT INTO poronbv_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Saíram de Hairote e atravessaram o mar Vermelho, e andaram durante três dias no deserto de Etã e acamparam em Mara. ");
INSERT INTO poronbv_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","E saíram de Mara e acamparam em Elim, onde havia doze fontes de água e setenta palmeiras. ");
INSERT INTO poronbv_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Saíram de Elim e acamparam junto ao mar Vermelho. ");
INSERT INTO poronbv_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Saíram do mar Vermelho e acamparam no deserto de Sim. ");
INSERT INTO poronbv_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Então saíram do deserto de Sim e acamparam em Dofca. ");
INSERT INTO poronbv_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Saíram de Dofca e acamparam em Alus. ");
INSERT INTO poronbv_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Saíram de Alus e acamparam em Refidim, onde não havia água para o povo beber. ");
INSERT INTO poronbv_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Saíram de Refidim e acamparam no deserto do Sinai. ");
INSERT INTO poronbv_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Saíram do deserto do Sinai e acamparam em Quibrote-Hataavá. ");
INSERT INTO poronbv_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Saíram de Quibrote-Hataavá e acamparam em Hazerote. ");
INSERT INTO poronbv_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Saíram de Hazerote e acamparam em Ritmá. ");
INSERT INTO poronbv_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Saíram de Ritmá e acamparam em Rimom-Perez. ");
INSERT INTO poronbv_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Saíram de Rimom-Perez e acamparam em Libna. ");
INSERT INTO poronbv_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Saíram de Libna e acamparam em Rissa. ");
INSERT INTO poronbv_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Saíram de Rissa e acamparam em Queelata. ");
INSERT INTO poronbv_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Saíram de Queelata e acamparam no monte Séfer. ");
INSERT INTO poronbv_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Saíram do monte Séfer e acamparam em Harada. ");
INSERT INTO poronbv_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Saíram de Harada e acamparam em Maquelote. ");
INSERT INTO poronbv_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Saíram de Maquelote e acamparam em Taate. ");
INSERT INTO poronbv_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Saíram de Taate e acamparam em Terá. ");
INSERT INTO poronbv_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Saíram de Terá e acamparam em Mitca. ");
INSERT INTO poronbv_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Saíram de Mitca e acamparam em Hasmona. ");
INSERT INTO poronbv_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Saíram de Hasmona e acamparam em Moserote. ");
INSERT INTO poronbv_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Saíram de Moserote e acamparam em Bene-Jaacã. ");
INSERT INTO poronbv_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Saíram de Bene-Jaacã e acamparam em Hor-Gidgade. ");
INSERT INTO poronbv_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Saíram de Hor-Gidgade e acamparam em Jotbatá. ");
INSERT INTO poronbv_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Saíram de Jotbatá e acamparam em Abrona. ");
INSERT INTO poronbv_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Saíram de Abrona e acamparam em Eziom-Geber. ");
INSERT INTO poronbv_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Saíram de Eziom-Geber e acamparam em Cades, no deserto de Zim. ");
INSERT INTO poronbv_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Saíram de Cades e acamparam no monte Hor, na fronteira de Edom. ");
INSERT INTO poronbv_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Então o sacerdote Arão subiu o monte Hor, de acordo com a ordem do Senhor, e morreu naquele lugar no primeiro dia do quinto mês, quarenta anos depois que os israelitas saíram do Egito. ");
INSERT INTO poronbv_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Arão tinha 123 anos de idade quando morreu no monte Hor. ");
INSERT INTO poronbv_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Então o rei cananeu Arade, que morava ao sul da terra de Canaã, soube que os israelitas estavam chegando. ");
INSERT INTO poronbv_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Eles saíram do monte Hor e acamparam em Zalmona. ");
INSERT INTO poronbv_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Saíram de Zalmona e acamparam em Punom. ");
INSERT INTO poronbv_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Saíram de Punom e acamparam em Obote. ");
INSERT INTO poronbv_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Saíram de Obote e acamparam em Ijé-Abarim, na fronteira de Moabe. ");
INSERT INTO poronbv_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Saíram de Ijé-Abarim e acamparam em Dibom-Gade. ");
INSERT INTO poronbv_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Saíram de Dibom-Gade e acamparam em Almom-Diblataim. ");
INSERT INTO poronbv_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Saíram de Almom-Diblataim e acamparam nos montes de Abarim, diante do monte Nebo. ");
INSERT INTO poronbv_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Saíram dos montes de Abarim e acamparam nas campinas de Moabe ao lado do rio Jordão, do outro lado de Jericó. ");
INSERT INTO poronbv_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Nas campinas de Moabe do lado do rio Jordão acamparam desde Bete-Jesimote até Abel-Sitim. ");
INSERT INTO poronbv_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Nas campinas de Moabe, junto ao rio Jordão, do outro lado de Jericó, o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Diga aos israelitas: Quando vocês atravessarem o rio Jordão para a terra de Canaã, ");
INSERT INTO poronbv_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","expulsem os habitantes da terra e destruam suas imagens esculpidas e todos os ídolos de metal fundido, e derrubem todos os seus altares. ");
INSERT INTO poronbv_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Tomem posse da terra e habitem nela, pois dei esta terra para que tomem posse dela. ");
INSERT INTO poronbv_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Repartam a terra por sorteio, entre os grupos de famílias. Aos grupos de famílias maiores vocês darão uma herança maior e aos grupos de famílias menores, uma herança menor. Cada grupo de famílias receberá a terra sorteada. Vocês herdarão segundo as tribos dos seus antepassados. ");
INSERT INTO poronbv_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“Mas, se vocês não expulsarem os habitantes da terra, eles serão como espinhos nos seus olhos e pontas de ferro na cintura de vocês. Eles vão hostilizar vocês na terra em que vocês vão habitar. ");
INSERT INTO poronbv_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Então farei a vocês o que havia pensado em fazer com eles”. ");
INSERT INTO poronbv_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Dê a seguinte ordem aos israelitas: Quando vocês entrarem na terra de Canaã, esta será a terra que cabe a vocês por herança, de acordo com as seguintes fronteiras: ");
INSERT INTO poronbv_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“A parte sul será de vocês, desde o deserto de Zim até a fronteira de Edom. A fronteira da parte sul começará no lado leste do mar Morto, ");
INSERT INTO poronbv_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","passando pela subida de Acrabim, chegará a Zim e depois até o sul de Cades-Barneia, que será o ponto mais ao sul. Depois passará por Hazar-Adar e irá até Azmom, ");
INSERT INTO poronbv_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","onde a fronteira será o ribeiro do Egito, e terminará no mar Mediterrâneo. ");
INSERT INTO poronbv_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","A fronteira ocidental de vocês será o litoral do mar Mediterrâneo. Essa será a fronteira do ocidente. ");
INSERT INTO poronbv_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","A fronteira do norte será a seguinte: tracem uma linha desde o mar Mediterrâneo até o monte Hor, ");
INSERT INTO poronbv_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","e do monte Hor até a entrada de Lebo-Hamate. Então a fronteira seguirá para Zedade, ");
INSERT INTO poronbv_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","e continuará até Zifrom e terminará em Hazar-Enã. Essa será a fronteira norte de vocês. ");
INSERT INTO poronbv_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","A fronteira oriental será a seguinte: tracem uma linha de Hazar-Enã até Sefã. ");
INSERT INTO poronbv_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","A fronteira descerá desde Sefã até Ribla, no lado oriental de Aim, e continuará descendo ao longo das encostas a leste do mar de Quinerete. ");
INSERT INTO poronbv_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Essa fronteira descerá então ao longo do rio Jordão e terminará no mar Morto. Essa será a terra de vocês, com as fronteiras que a cercam”. ");
INSERT INTO poronbv_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Moisés disse aos israelitas o seguinte: “Esse é o território que o Senhor mandou distribuir por sorteio às nove tribos e meia. ");
INSERT INTO poronbv_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","São nove tribos e meia porque as tribos de Rúben e de Gade, e meia tribo de Manassés, já receberam a sua herança. ");
INSERT INTO poronbv_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Essas duas tribos e meia receberam sua herança do lado leste do rio Jordão, do outro lado de Jericó”. ");
INSERT INTO poronbv_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","E o Senhor também disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“As pessoas responsáveis para distribuir a terra entre vocês como herança serão: o sacerdote Eleazar, Josué, filho de Num, ");
INSERT INTO poronbv_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","e um líder de cada tribo para ajudar na distribuição da terra. ");
INSERT INTO poronbv_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Estes são os nomes dos líderes: “da tribo de Judá, Calebe, filho de Jefoné; ");
INSERT INTO poronbv_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","da tribo de Simeão, Samuel, filho de Amiúde; ");
INSERT INTO poronbv_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","da tribo de Benjamim, Elidade, filho de Quislom; ");
INSERT INTO poronbv_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Buqui, filho de Jogli, líder da tribo de Dã; ");
INSERT INTO poronbv_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Haniel, filho de Éfode, líder da tribo de Manassés, filho de José; ");
INSERT INTO poronbv_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Quemuel, filho de Siftã, líder da tribo de Efraim, filho de José; ");
INSERT INTO poronbv_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Elisafã, filho de Parnaque, líder da tribo de Zebulom; ");
INSERT INTO poronbv_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Paltiel, filho de Azã, líder da tribo de Issacar; ");
INSERT INTO poronbv_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Aiúde, filho de Selomi, líder da tribo de Aser; ");
INSERT INTO poronbv_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Pedael, filho de Amiúde, líder da tribo de Naftali”. ");
INSERT INTO poronbv_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","O Senhor ordenou que essas pessoas repartissem a terra aos israelitas na terra de Canaã. ");
INSERT INTO poronbv_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","O Senhor disse a Moisés, nas campinas de Moabe, junto ao rio Jordão, do outro lado de Jericó: ");
INSERT INTO poronbv_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Diga aos israelitas que, da terra que receberem, eles devem dar algumas cidades aos levitas para nelas morarem. Também devem dar algum campo ao redor das cidades para os seus rebanhos, seu gado e todos os seus animais. ");
INSERT INTO poronbv_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Eles morarão nessas cidades e os animais deles ficarão no campo em volta das cidades. ");
INSERT INTO poronbv_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“As pastagens nos arredores das cidades que vocês darão aos levitas se estenderão por 450 metros desde o muro da cidade para cada um dos lados dessas cidades. ");
INSERT INTO poronbv_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Fora da cidade vocês medirão 900 metros para o lado leste, 900 metros para o lado oeste, 900 metros para o lado sul, e 900 metros para o lado norte, ficando a cidade no centro. Essas serão as áreas de pastagens das cidades. ");
INSERT INTO poronbv_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Seis das cidades que vocês darão aos levitas serão cidades de refúgio para onde irão aqueles que tiverem matado alguém. Além disso vocês darão a eles mais quarenta e duas cidades. ");
INSERT INTO poronbv_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Vocês devem então dar ao todo quarenta e oito cidades aos levitas, junto com o campo em volta. ");
INSERT INTO poronbv_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Essas cidades que vocês derem aos levitas, das terras dos israelitas, serão dadas proporcionalmente à herança de cada tribo: as tribos que tiverem muitas cidades darão mais cidades, e as tribos que tiverem poucas cidades darão menos cidades aos levitas”. ");
INSERT INTO poronbv_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","E o Senhor disse a Moisés: ");
INSERT INTO poronbv_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Diga aos israelitas que quando atravessarem o rio Jordão e entrarem na terra de Canaã ");
INSERT INTO poronbv_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","devem escolher quais serão as cidades de refúgio, para onde poderá fugir a pessoa que matar alguém involuntariamente. ");
INSERT INTO poronbv_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Essas cidades servirão para proteger a pessoa que tiver matado alguém involuntariamente dos parentes da vítima que quiserem se vingar, até que o povo julgue se o homicida é culpado ou não. ");
INSERT INTO poronbv_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Serão seis as cidades que vocês darão por cidades de refúgio, ");
INSERT INTO poronbv_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","das quais três cidades de refúgio ficarão do lado de cá do rio Jordão e três na terra de Canaã. ");
INSERT INTO poronbv_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Essas seis cidades serão um lugar de refúgio para os israelitas, para os estrangeiros que moram no meio de vocês e para os estrangeiros que estiverem de passagem pelo país, para que ali se refugie o homicida que matar alguém involuntariamente. ");
INSERT INTO poronbv_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“Mas se alguém ferir alguma pessoa com um pedaço de ferro e esta pessoa morrer, ele é homicida e terá de morrer. ");
INSERT INTO poronbv_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Ou, se ele a ferir com uma pedra, que possa causar a morte, e a pessoa morrer, ele é homicida e terá de morrer. ");
INSERT INTO poronbv_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Ou, se ele a ferir com um pedaço de madeira, que possa causar a morte, e a pessoa morrer, ele é homicida e terá de morrer. ");
INSERT INTO poronbv_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","O vingador da vítima matará o homicida quando encontrar essa pessoa. ");
INSERT INTO poronbv_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","E se alguém empurrar uma pessoa com ódio ou intencionalmente jogar alguma coisa contra essa pessoa, e essa pessoa morrer, ");
INSERT INTO poronbv_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ou se com má intenção matar uma pessoa com as próprias mãos, essa pessoa é homicida, e o vingador da vítima matará o homicida quando o encontrar. ");
INSERT INTO poronbv_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“Mas se empurrar uma pessoa sem ódio, ou empurrar uma pessoa ou então atirar alguma coisa contra ela involuntariamente, ");
INSERT INTO poronbv_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ou ainda, se deixar cair involuntariamente alguma pedra sobre ela que possa matá-la, e a pessoa morrer, não sendo sua inimiga, e quem matou não fez isso de propósito, ");
INSERT INTO poronbv_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","então a comunidade julgará entre ele e o vingador da vítima, de acordo com essas leis. ");
INSERT INTO poronbv_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","A comunidade livrará o acusado de assassinato do vingador da vítima, deixando o homicida continuar na cidade de refúgio para onde tinha fugido. Ali permanecerá até a morte do sumo sacerdote, que foi ungido com óleo sagrado. ");
INSERT INTO poronbv_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“Mas se o acusado sair por alguma razão dos limites da cidade de refúgio ");
INSERT INTO poronbv_vpl VALUES