﻿USE sofia;
DROP TABLE IF EXISTS sofia.porbrbsl_vpl;
CREATE TABLE porbrbsl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES porbrbsl_vpl WRITE;
INSERT INTO porbrbsl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","No início, Deus criou os céus e a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","A terra estava sem forma e vazia. A escuridão estava na superfície das profundezas e o Espírito de Deus pairava sobre a superfície das águas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Deus disse: “Que haja luz”, e houve luz. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Deus viu a luz, e viu que ela era boa. Deus dividiu a luz das trevas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Deus chamou a luz de “dia”, e a escuridão de “noite”. Havia a noite e havia a manhã, o primeiro dia. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Deus disse: “Que haja uma extensão no meio das águas, e que ela divida as águas das águas”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Deus fez a extensão, e dividiu as águas que estavam sob a extensão das águas que estavam acima da extensão; e assim foi. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Deus chamou a vastidão de “céu”. Havia a noite e havia a manhã, um segundo dia. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Deus disse: “Que as águas sob o céu sejam reunidas num só lugar, e que a terra seca apareça;” e assim foi. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Deus chamou a terra seca de “terra”, e a reunião das águas ele chamou de “mares”. Deus viu que era bom. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Deus disse: “Que a terra produza grama, ervas que produzam sementes, e árvores frutíferas que dêem frutos depois de sua espécie, com suas sementes dentro dela, na terra;” e assim foi. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","A terra produziu grama, ervas produzindo sementes depois de sua espécie, e árvores dando frutos, com suas sementes dentro dela, depois de sua espécie; e Deus viu que era boa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Havia a noite e havia a manhã, um terceiro dia. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Deus disse: “Que haja luzes na extensão do céu para dividir o dia da noite; e que sejam para que os sinais marquem as estações, os dias e os anos; ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","e que sejam para que as luzes na extensão do céu dêem luz sobre a terra;” e assim foi. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Deus fez as duas grandes luzes: a luz maior para governar o dia, e a luz menor para governar a noite. Ele também fez as estrelas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Deus as colocou na vastidão do céu para dar luz à terra, ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","e para governar o dia e a noite, e para dividir a luz da escuridão. Deus viu que era bom. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Havia a noite e havia a manhã, um quarto dia. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Deus disse: “Deixem as águas transbordar de seres vivos, e deixem as aves voar sobre a terra na extensão aberta do céu”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Deus criou as grandes criaturas marinhas e todos os seres vivos que se movem, com os quais as águas transbordaram, depois de sua espécie, e cada ave alada depois de sua espécie. Deus viu que era bom. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Deus os abençoou, dizendo: “Sede fecundos e multiplicai-vos, e enchei as águas dos mares, e deixai as aves multiplicarem-se na terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Havia a noite e havia a manhã, um quinto dia. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Deus disse: “Que a terra produza seres vivos segundo sua espécie, gado, coisas rastejantes e animais da terra segundo sua espécie”; e assim foi. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Deus fez os animais da terra depois de sua espécie, e o gado depois de sua espécie, e tudo o que rasteja no solo depois de sua espécie. Deus viu que era bom. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Deus disse: “Vamos fazer o homem à nossa imagem, à nossa semelhança”. Que tenham domínio sobre os peixes do mar, e sobre as aves do céu, e sobre o gado, e sobre toda a terra, e sobre cada coisa rasteira que se arrepia sobre a terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Deus criou o homem à sua própria imagem. À imagem de Deus ele o criou; macho e fêmea ele os criou”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Deus os abençoou. Deus lhes disse: “Sede fecundos, multiplicai-vos, enchei a terra e sujeitai-a”. Tenham domínio sobre os peixes do mar, sobre as aves do céu e sobre todo ser vivo que se move sobre a terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Deus disse: “Eis que vos dei toda erva que dá semente, que está na superfície de toda a terra, e toda árvore que dá fruto que dá semente”. Será seu alimento”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","A cada animal da terra, e a cada ave do céu, e a tudo que rasteja na terra, na qual há vida, eu dei toda erva verde para alimento”; e assim foi. ");
INSERT INTO porbrbsl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Deus viu tudo o que tinha feito e, eis que era muito bom. Havia a noite e havia a manhã, um sexto dia. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Os céus, a terra e toda a sua vasta gama foram terminados. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","No sétimo dia, Deus terminou seu trabalho que havia feito; e descansou no sétimo dia de todo o seu trabalho que havia feito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Deus abençoou o sétimo dia e o tornou santo, porque descansou nele de todo o seu trabalho de criação que havia feito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Esta é a história das gerações dos céus e da terra quando foram criados, no dia em que Javé Deus fez a terra e os céus. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Nenhuma planta do campo ainda estava na terra, e nenhuma erva do campo ainda havia brotado; pois Javé Deus não havia causado a chuva na terra. Não havia um homem para cultivar o solo, ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","mas uma névoa subiu da terra, e regou toda a superfície do solo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yahweh Deus formou o homem do pó da terra, e soprou em suas narinas o sopro da vida; e o homem se tornou uma alma viva. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Yahweh Deus plantou um jardim ao leste, no Éden, e ali colocou o homem que havia formado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Do solo Javé Deus fez crescer toda árvore agradável à vista e boa para o alimento, incluindo a árvore da vida no meio do jardim e a árvore do conhecimento do bem e do mal. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Um rio saiu do Éden para regar o jardim; e dali se separou, e se tornou a nascente de quatro rios. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","O nome do primeiro é Pishon: corre por toda a terra de Havilah, onde há ouro; ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","e o ouro daquela terra é bom. O Bdellium e a pedra ônix também estão lá. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","O nome do segundo rio é Gihon. É o mesmo rio que corre por toda a terra de Cush. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","O nome do terceiro rio é Hiddekel. Este é o que corre na frente da Assíria. O quarto rio é o Eufrates. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yahweh Deus tomou o homem e o colocou no jardim do Éden para cultivá-lo e guardá-lo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Javé Deus ordenou ao homem, dizendo: “Podeis comer livremente de toda árvore do jardim; ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","mas não comereis da árvore do conhecimento do bem e do mal; porque no dia em que dela comerdes, certamente morrereis”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Yahweh Deus disse: “Não é bom para o homem estar sozinho”. Vou fazer dele um ajudante comparável a ele”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Do chão Yahweh Deus formou cada animal do campo, e cada ave do céu, e os trouxe ao homem para ver o que ele os chamaria. O que quer que o homem chamasse cada ser vivo, tornou-se seu nome. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","O homem deu nomes a todo o gado, e às aves do céu, e a todos os animais do campo; mas para o homem não foi encontrado um ajudante comparável a ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Yahweh Deus fez com que o homem caísse num sono profundo. Enquanto o homem dormia, ele pegou uma de suas costelas e fechou a carne em seu lugar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yahweh Deus fez uma mulher da costela que ele havia tirado do homem, e a trouxe ao homem. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","O homem disse: “Isto agora é osso dos meus ossos, e carne da minha carne”. Ela será chamada 'mulher,' porque foi tirada do homem”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Portanto, um homem deixará seu pai e sua mãe, e se unirá à sua esposa, e eles serão uma só carne. ");
INSERT INTO porbrbsl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","O homem e sua esposa estavam ambos nus, e não tinham vergonha. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Agora a serpente era mais sutil do que qualquer animal do campo que Yahweh Deus tinha feito. Ele disse à mulher: “Deus realmente disse: 'Não comereis de nenhuma árvore do jardim'”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","A mulher disse à serpente: “Podemos comer frutas das árvores do jardim, ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","mas não o fruto da árvore que está no meio do jardim. Deus disse: “Não comereis dela”. Não lhe tocarás, para que não morras””. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","A serpente disse à mulher: “Você não morrerá de verdade, ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","pois Deus sabe que no dia em que a comer, seus olhos serão abertos, e você será como Deus, conhecendo o bem e o mal”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Quando a mulher viu que a árvore era boa para comer, e que era um deleite para os olhos, e que a árvore era para ser desejada para fazer um sábio, ela pegou alguns de seus frutos, e comeu. Depois ela deu alguns para seu marido com ela, e ele também os comeu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Seus olhos foram abertos, e ambos sabiam que estavam nus. Coseram folhas de figo juntas, e fizeram coberturas para si mesmos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Eles ouviram a voz de Javé Deus caminhando no jardim no frio do dia, e o homem e sua esposa se esconderam da presença de Javé Deus entre as árvores do jardim. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yahweh Deus chamou o homem e lhe disse: “Onde você está?” ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","O homem disse: “Ouvi sua voz no jardim, e tive medo, porque estava nu; por isso me escondi”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Deus disse: “Quem lhe disse que você estava nu? Você comeu da árvore da qual eu lhe ordenei que não comesse”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","O homem disse: “A mulher que você deu para estar comigo, ela me deu frutos da árvore, e eu os comi”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yahweh Deus disse à mulher: “O que você fez?” A mulher disse: “A serpente me enganou, e eu comi”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Disse Yahweh Deus à serpente, “Porque você fez isso, você está amaldiçoado acima de todos os animais, e acima de cada animal do campo. Você deve ir de barriga para baixo e você deve comer pó todos os dias de sua vida. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","I colocará hostilidade entre você e a mulher, e entre sua prole e sua descendência. Ele vai machucar sua cabeça, e você vai machucar seu calcanhar”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Para a mulher que ele disse, “Multiplicarei grandemente sua dor no parto. Você terá filhos em sofrimento. Seu desejo será para seu marido, e ele irá governar sobre você”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Para Adam, ele disse, “Porque você ouviu a voz de sua esposa, e comeram da árvore, sobre o qual eu lhe ordenei, dizendo: “Não comerá dele”. o chão está amaldiçoado para seu bem. Você comerá dele com muita mão-de-obra durante todos os dias de sua vida. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ela lhe dará espinhos e cardos; e você vai comer a erva do campo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Você comerá pão pelo suor do seu rosto até voltar ao chão, pois você foi tirado dele. Pois você é pó, e você voltará ao pó”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","O homem chamou sua esposa Eve porque ela seria a mãe de todos os vivos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yahweh Deus fez vestes de peles de animais para Adão e para sua esposa, e as vestiu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yahweh Deus disse: “Eis que o homem se tornou como um de nós, conhecendo o bem e o mal”. Agora, para que ele não estenda sua mão, e também tome da árvore da vida, e coma, e viva para sempre... ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Portanto, Javé Deus o enviou do jardim do Éden, para cultivar o solo do qual foi tomado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Então ele expulsou o homem; e colocou querubins ao leste do jardim do Éden, e uma espada flamejante que se virou para todos os lados, para guardar o caminho para a árvore da vida. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","O homem conhecia Eve, sua esposa. Ela concebeu, e deu à luz a Caim, e disse: “Consegui um homem com a ajuda de Javé”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Novamente ela deu à luz, ao irmão de Caim, Abel. Abel era um criador de ovelhas, mas Caim era um lavrador do solo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Com o passar do tempo, Caim trouxe uma oferta a Javé a partir do fruto do solo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel também trouxe alguns dos primogênitos de seu rebanho e de sua gordura. Javé respeitava Abel e sua oferenda, ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","mas não respeitava Caim e sua oferenda. Caim ficou muito zangado, e a expressão em seu rosto caiu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yahweh disse a Caim: “Por que você está com raiva? Por que a expressão de seu rosto caiu? ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Se você se sair bem, ela não será levantada? Se você não se sair bem, o pecado se agacha à porta. Seu desejo é para você, mas você deve governar sobre ele”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Caim disse a Abel, seu irmão: “Vamos para o campo”. Enquanto estavam no campo, Caim se levantou contra Abel, seu irmão, e o matou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Yahweh disse a Caim: “Onde está Abel, seu irmão?” Ele disse: “Eu não sei. Sou o guardião do meu irmão”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yahweh disse: “O que você fez? A voz do sangue de seu irmão chora para mim desde o chão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Agora você está amaldiçoado por causa do chão, que abriu sua boca para receber o sangue de seu irmão de sua mão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","De agora em diante, quando você lavrar o chão, ele não lhe dará sua força. Você será um fugitivo e um vagabundo na terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Caim disse a Javé: “Meu castigo é maior do que eu posso suportar”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Eis que hoje você me expulsou da superfície do solo. Estarei escondido de seu rosto e serei um fugitivo e um vagabundo na terra”. Quem me encontrar, me matará”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yahweh disse-lhe: “Portanto, quem matar Caim, será vingado sete vezes”. Yahweh apontou um sinal para Caim, para que quem o encontrasse não o atingisse. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Caim deixou a presença de Iavé e viveu na terra de Nod, a leste do Éden. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caim conheceu sua esposa. Ela concebeu, e deu à luz a Enoque. Ele construiu uma cidade e deu à cidade o nome de seu filho Enoque. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Irad nasceu para Enoque. Irad tornou-se o pai de Mehujael. Mehujael tornou-se o pai de Methushael. Methushael se tornou o pai de Lamech. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamech teve duas esposas: a primeira chamava-se Adah, e a segunda Zillah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah deu à luz a Jabal, que era o pai daqueles que moram em barracas e têm gado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","O nome de seu irmão era Jubal, que era o pai de todos os que manuseiam a harpa e o cachimbo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillah também deu à luz Tubal Cain, o falsificador de cada instrumento de corte de bronze e ferro. A irmã de Tubal Cain era Naamah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamech disse a suas esposas, “Adah e Zillah, ouçam minha voz. Vós, esposas de Lamech, escutai meu discurso, pois matei um homem por me ter ferido, um jovem por me machucar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Se Cain será vingado sete vezes, verdadeiramente Lamech setenta e sete vezes”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam conheceu sua esposa novamente. Ela deu à luz um filho e o nomeou Seth, dizendo: “pois Deus me deu outro filho ao invés de Abel, pois Caim o matou”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Um filho também nasceu para Seth, e ele lhe deu o nome de Enosh. Naquela época, os homens começaram a invocar o nome de Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Este é o livro das gerações de Adão. No dia em que Deus criou o homem, ele o fez à semelhança de Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ele os criou homem e mulher, e os abençoou. No dia em que eles foram criados, ele os chamou de Adão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adão viveu cento e trinta anos, e se tornou pai de um filho à sua imagem, e lhe deu o nome de Seth. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Os dias de Adão depois de se tornar pai de Seth foram oitocentos anos, e ele se tornou pai de outros filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Todos os dias que Adão viveu foram novecentos e trinta anos, depois ele morreu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth viveu cento e cinco anos, depois se tornou o pai da Enosh. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seth viveu depois de se tornar o pai de Enosh oitocentos e sete anos, e se tornou pai de outros filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Todos os dias de Seth foram novecentos e doze anos, depois ele morreu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosh viveu noventa anos, e tornou-se o pai de Kenan. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosh viveu depois de se tornar o pai de Kenan oitocentos e quinze anos, e se tornou pai de outros filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Todos os dias de Enosh foram novecentos e cinco anos, depois ele morreu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan viveu setenta anos, depois se tornou o pai de Mahalalel. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan viveu depois de se tornar o pai de Mahalalel oitocentos e quarenta anos, e tornou-se o pai de outros filhos e filhas ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","e todos os dias de Kenan foram novecentos e dez anos, depois ele morreu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel viveu sessenta e cinco anos, depois se tornou o pai de Jared. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel viveu depois de se tornar o pai de Jarede oitocentos e trinta anos, e se tornou pai de outros filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Todos os dias de Mahalalel foram oitocentos e noventa e cinco anos, depois ele morreu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared viveu cento e sessenta e dois anos, depois se tornou o pai de Enoque. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jared viveu depois de se tornar pai de Enoque oitocentos anos, e se tornou pai de outros filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Todos os dias de Jarede foram novecentos e sessenta e dois anos, depois ele morreu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoque viveu sessenta e cinco anos, depois se tornou o pai de Matusalém. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Após o nascimento de Matusalém, Enoque caminhou com Deus por trezentos anos, e se tornou o pai de mais filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Todos os dias de Enoque foram trezentos e sessenta e cinco anos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoque caminhou com Deus, e ele não foi encontrado, pois Deus o levou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusalém viveu cento e oitenta e sete anos, depois se tornou o pai de Lamech. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Matusalém viveu depois de se tornar o pai de Lamech setecentos e oitenta e dois anos, e tornou-se o pai de outros filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Todos os dias de Matusalém foram novecentos e sessenta e nove anos, depois ele morreu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamech viveu cento e oitenta e dois anos, depois se tornou o pai de um filho. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ele o chamou de Noé, dizendo: “Este nos confortará em nosso trabalho e na labuta de nossas mãos, causada pelo solo que Javé amaldiçoou”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamech viveu depois de se tornar pai de Noé quinhentos e noventa e cinco anos, e se tornou pai de outros filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Todos os dias de Lamech foram setecentos e setenta e sete anos, depois ele morreu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé tinha quinhentos anos, então Noé tornou-se o pai de Shem, Ham, e Japheth. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Quando os homens começaram a multiplicar-se na superfície do solo, e as filhas nasceram para eles, ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","os filhos de Deus viram que as filhas dos homens eram lindas, e levaram para si como esposas o que queriam. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yahweh disse: “Meu Espírito não lutará com o homem para sempre, porque ele também é carne; assim, seus dias serão cento e vinte anos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Os nefilins estavam na terra naqueles dias, e também depois disso, quando os filhos de Deus chegaram às filhas dos homens e tiveram filhos com eles. Esses eram os homens poderosos que eram de antigamente, homens de renome. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yahweh viu que a maldade do homem era grande na terra, e que toda imaginação dos pensamentos do coração do homem era continuamente apenas maligna. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yahweh lamentava ter feito o homem na terra, e isso o entristeceu em seu coração. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Yahweh disse: “Destruirei o homem que criei da superfície do homem-terra, juntamente com animais, coisas rastejantes e aves do céu - pois lamento tê-las feito”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mas Noé encontrou favor aos olhos de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Esta é a história das gerações de Noé: Noé era um homem justo, irrepreensível entre o povo de seu tempo. Noé caminhava com Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noé tornou-se o pai de três filhos: Shem, Ham, e Japheth. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","A terra era corrupta diante de Deus, e a terra estava cheia de violência. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Deus viu a terra, e viu que ela era corrupta, pois toda a carne havia corrompido o seu caminho na terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Deus disse a Noé: “Eu trarei um fim a toda a carne, pois a terra está cheia de violência através deles”. Eis que eu os destruirei e à terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Faça um navio de madeira de gopher. Vocês devem fazer espaços no navio, e selá-lo dentro e fora com breu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","É assim que você deve fazer. O comprimento do navio será de trezentos cúbitos, sua largura de cinqüenta cúbitos e sua altura de trinta cúbitos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Você deverá fazer um teto no navio, e deverá terminá-lo com um côvado para cima. Você deverá colocar a porta do navio em seu lado. Você deverá fazê-la com os níveis inferior, segundo e terceiro. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Eu, mesmo eu, trarei a inundação de águas nesta terra, para destruir toda a carne tendo o sopro da vida de baixo do céu. Tudo o que está na terra morrerá. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mas eu estabelecerei meu pacto com vocês. Vós entrareis no navio, vós, vossos filhos, vossa esposa e as esposas de vossos filhos convosco. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","De todos os seres vivos de toda a carne, você trará dois de todos os tipos para dentro do navio, para mantê-los vivos com você. Eles serão homens e mulheres. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Dos pássaros após sua espécie, do gado após sua espécie, de todo réptil do solo após sua espécie, dois de todo tipo virão até você, para mantê-los vivos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Leve consigo algum de todos os alimentos que são comidos, e recolha-o para si mesmo; e será para alimento para você e para eles”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Assim fez Noé. Ele fez tudo o que Deus lhe ordenou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yahweh disse a Noé: “Venha com toda sua casa para o navio, pois vi sua retidão diante de mim nesta geração”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Você levará consigo sete pares de cada animal limpo, o macho e sua fêmea. Dos animais que não estiverem limpos, leve dois, o macho e sua fêmea. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Também das aves do céu, sete e sete, macho e fêmea, para manter a semente viva na superfície de toda a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Em sete dias, farei chover sobre a terra durante quarenta dias e quarenta noites. Destruirei todos os seres vivos que fiz da superfície da terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noah fez tudo o que Yahweh lhe ordenou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noé tinha seiscentos anos quando a inundação de águas chegou à terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noé entrou no navio com seus filhos, sua esposa e as esposas de seus filhos, por causa da inundação das águas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Animais limpos, animais impuros, pássaros e tudo o que rasteja no chão ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","foram aos pares para Noé no navio, macho e fêmea, como Deus ordenou a Noé. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Após os sete dias, as águas da enchente vieram à terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","No sexto centésimo ano de vida de Noé, no segundo mês, no décimo sétimo dia do mês, naquele dia, todas as fontes do grande abismo se abriram, e as janelas do céu se abriram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Choveu sobre a terra durante quarenta dias e quarenta noites. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","No mesmo dia Noé, e Shem, Ham e Japheth - os filhos de Noé - e a esposa de Noé e as três esposas de seus filhos com eles, entraram no navio - ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","eles, e todos os animais após sua espécie, todo o gado após sua espécie, toda coisa rastejante que rasteja na terra após sua espécie, e toda ave após sua espécie, toda ave de toda espécie. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Pares de toda a carne com o sopro da vida neles foram para o navio para Noé. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Aqueles que entraram, entraram macho e fêmea de toda a carne, como Deus lhe ordenou; depois Yahweh o fechou dentro. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","A enchente foi de quarenta dias na terra. As águas aumentaram, e elevaram o navio, e este foi levantado acima da terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","As águas subiram, e aumentaram muito sobre a terra; e o navio flutuou sobre a superfície das águas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","As águas subiram muito alto sobre a terra. Todas as altas montanhas que estavam sob todo o céu foram cobertas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","As águas subiram quinze cúbitos mais alto, e as montanhas foram cobertas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Toda a carne morreu que se movia sobre a terra, incluindo aves, gado, animais, toda coisa rastejante que rasteja sobre a terra, e todo homem. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Todos na terra seca, em cujas narinas estava o sopro do espírito da vida, morreram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Todos os seres vivos foram destruídos na superfície do solo, incluindo o homem, o gado, os rastejantes e as aves do céu. Eles foram destruídos da terra. Somente Noé foi deixado, e aqueles que estavam com ele no navio. ");
INSERT INTO porbrbsl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","As águas inundaram a terra durante cento e cinqüenta dias. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Deus se lembrou de Noé, de todos os animais e de todo o gado que estavam com ele no navio; e Deus fez um vento para passar sobre a terra. As águas baixaram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","As fontes do fundo e as janelas do céu também foram paradas, e a chuva do céu foi contida. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","As águas recuaram continuamente da terra. Após o final de cento e cinqüenta dias as águas recuaram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","O navio descansou no sétimo mês, no décimo sétimo dia do mês, nas montanhas de Ararat. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","As águas recuaram continuamente até o décimo mês. No décimo mês, no primeiro dia do mês, os cumes das montanhas eram visíveis. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ao final de quarenta dias, Noé abriu a janela do navio que ele havia feito, ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","e enviou um corvo. Ele ia e voltava, até que as águas secassem da terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ele mesmo mandou uma pomba para ver se as águas eram abatidas da superfície do solo, ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","mas a pomba não encontrou lugar para descansar o pé, e ela voltou para o navio, pois as águas estavam na superfície de toda a terra. Ele estendeu sua mão, pegou-a e a trouxe até ele no navio. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ele esperou mais sete dias; e novamente ele enviou a pomba para fora do navio. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","A pomba voltou para ele à noite e, eis que na boca dela estava uma folha de oliveira recém colhida. Então Noé sabia que as águas tinham sido abatidas da terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ele esperou mais sete dias, e enviou a pomba; e ela não voltou mais para ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","No primeiro ano, no primeiro mês, no primeiro dia do mês, seiscentos anos, as águas foram secas da terra. Noé retirou a cobertura do navio, e olhou. Ele viu que a superfície do solo estava seca. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","No segundo mês, no vigésimo sétimo dia do mês, a terra estava seca. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Deus falou com Noé, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Saia do navio, você, sua esposa, seus filhos e as esposas de seus filhos com você. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Traga consigo todos os seres vivos que estão consigo de toda a carne, inclusive aves, gado e todos os répteis que se arrastam sobre a terra, para que se reproduzam abundantemente na terra, sejam fecundos e se multipliquem sobre a terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noé saiu com seus filhos, sua esposa e as mulheres de seus filhos com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Cada animal, cada coisa rasteira, e cada ave, qualquer coisa que se mova sobre a terra, depois que suas famílias, saíram do navio. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noé construiu um altar para Yahweh, e levou de cada animal limpo, e de cada ave limpa, e ofereceu ofertas queimadas sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yahweh sentiu o cheiro agradável. Yahweh disse em seu coração: “Não amaldiçoarei mais o chão por causa do homem porque a imaginação do coração do homem é maligna desde sua juventude”. Não voltarei a golpear todos os seres vivos, como já fiz”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Enquanto a terra permanecer, o tempo da semente e da colheita, e o frio e o calor, e o verão e o inverno, e o dia e a noite não cessarão”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Deus abençoou Noé e seus filhos, e lhes disse: “Sejam fecundos, multipliquem-se e reabasteçam a terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","O medo de vocês e o pavor de vocês estarão sobre cada animal da terra, e sobre cada ave do céu”. Tudo o que se move ao longo da terra, e todos os peixes do mar, são entregues em suas mãos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Cada coisa que se move que vive será alimento para você. Como eu lhe dei a erva verde, eu lhe dei tudo a você. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mas a carne com sua vida, ou seja, seu sangue, você não comerá. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Certamente exigirei a prestação de contas pelo sangue de sua vida. Às mãos de cada animal, eu o requererei. Na mão do homem, mesmo na mão do irmão de cada homem, eu exigirei a vida do homem. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Whoever derrama o sangue do homem, seu sangue será derramado pelo homem, pois Deus fez o homem à sua própria imagem. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Seja fecundo e multiplique. Aumenta abundantemente na terra, e multiplica-te nela”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Deus falou a Noé e a seus filhos com ele, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Quanto a mim, eis que estabeleço minha aliança com você, e com seus descendentes depois de você, ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","e com todo ser vivo que está com você: as aves, o gado e todo animal da terra com você, de todos os que saem do navio, até mesmo todo animal da terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Eu estabelecerei meu convênio com vocês: Toda a carne não será mais cortada pelas águas do dilúvio. Nunca mais haverá uma inundação para destruir a terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Deus disse: “Este é o sinal do pacto que faço entre mim e vós e todo ser vivo que está convosco, por gerações perpétuas”: ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Coloco meu arco-íris na nuvem, e será um sinal de um pacto entre mim e a Terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Quando eu trouxer uma nuvem sobre a terra, que o arco-íris será visto na nuvem, ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","eu me lembrarei da minha aliança, que é entre mim e você e todo ser vivo de toda a carne, e as águas não se tornarão mais uma inundação para destruir toda a carne. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","O arco-íris será visto na nuvem. Vou olhar para ele, para que eu possa me lembrar da aliança eterna entre Deus e cada ser vivo de toda a carne que está sobre a terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Deus disse a Noé: “Este é o símbolo do pacto que estabeleci entre mim e toda a carne que está sobre a terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Os filhos de Noé que saíram do navio eram Shem, Ham e Japheth. Ham é o pai de Canaã. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Estes três eram os filhos de Noé, e destes a terra inteira foi povoada. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noé começou a ser agricultor e plantou um vinhedo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ele bebeu do vinho e ficou bêbado. Ele foi descoberto dentro de sua tenda. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, o pai de Canaan, viu a nudez de seu pai, e contou aos seus dois irmãos lá fora. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Shem e Japheth pegaram uma roupa e a colocaram sobre os dois ombros, entraram de costas e cobriram a nudez de seu pai. Seus rostos estavam ao contrário e não viram a nudez do pai. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noé acordou de seu vinho e sabia o que seu filho mais novo havia feito com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Disse ele, “Canaã é amaldiçoada. Ele será um servo de servos para seus irmãos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ele disse, “Bendito seja Yahweh, o Deus de Shem”. Que Canaan seja seu servo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Que Deus amplie o Japheth. Deixe-o morar nas tendas de Shem. Que Canaan seja seu servo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noé viveu trezentos e cinqüenta anos após a enchente. ");
INSERT INTO porbrbsl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Todos os dias de Noé foram novecentos e cinqüenta anos, e então ele morreu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Agora esta é a história das gerações dos filhos de Noé e de Sem, Presunto e Jafé. Os filhos nasceram para eles após a enchente. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Os filhos de Japheth foram: Gomer, Magog, Madai, Javan, Tubal, Meshech e Tiras. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Os filhos de Gomer eram: Gomer, Magog, Madai, Javan, Tubal, Meshech, e Tiras: Ashkenaz, Riphath, e Togarmah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Os filhos de Javan eram: Ashkenaz, Riphath e Togarmah: Elishah, Tarshish, Kittim, e Dodanim. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Destes foram as ilhas das nações divididas em suas terras, todos depois de sua língua, depois de suas famílias, em suas nações. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Os filhos de Ham eram: Cush, Mizraim, Put, e Canaan. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Os filhos de Cush eram: Cush, Mizraim, Put, e Canaan: Seba, Havilah, Sabtah, Raamah, e Sabteca. Os filhos de Raamah eram: Seba, Havilah, Sabtah, Raamah, e Sabteca: Sheba e Dedan. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush tornou-se o pai de Nimrod. Ele começou a ser um poderoso na terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ele foi um poderoso caçador antes de Yahweh. Por isso se diz: “como Nimrod, um poderoso caçador antes de Yahweh”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","O início de seu reino foi Babel, Erech, Accad e Calneh, na terra de Shinar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Dessa terra ele entrou na Assíria, e construiu Nínive, Rehoboth Ir, Calah, ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","e Resen entre Nínive e a grande cidade de Calah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim tornou-se o pai de Ludim, Anamim, Lehabim, Naphtuhim, ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrusim, Casluhim (do qual os filisteus descenderam), e Caphtorim. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan tornou-se o pai de Sidon (seu primogênito), Heth, ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","os Jebusitas, os Amoritas, os Girgashitas, ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","os Hivitas, os Arkites, os Sinitas, ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","os Arvaditas, os Zemaritas, e os Hamatitas. Posteriormente, as famílias dos cananeus foram espalhadas pelo exterior. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","A fronteira dos cananeus era de Sidon - como você vai de Gerar para Gaza- como você vai de Sodoma, Gomorra, Admah, e Zeboiim para Lasha. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Estes são os filhos de Ham, depois de suas famílias, de acordo com seus idiomas, em suas terras e suas nações. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","As crianças também nasceram de Shem (o irmão mais velho de Japheth), o pai de todos os filhos de Eber. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Os filhos de Shem foram: Elam, Asshur, Arpachshad, Lud, e Aram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Os filhos de Aram eram: Elão, Asshur, Arpachshad, Lud, e Aram: Uz, Hul, Gether, e Mash. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpachshad tornou-se o pai de Selá. Shelah se tornou o pai de Eber. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Para Eber nasceram dois filhos. O nome de um era Peleg, pois em seus dias a terra estava dividida. O nome de seu irmão era Joktan. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan tornou-se o pai de Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, e Jobab. Todos estes foram filhos de Joktan. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Sua morada se estendia desde Mesha, enquanto se vai em direção a Sefar, a montanha do leste. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Estes são os filhos de Shem, por suas famílias, de acordo com suas línguas, terras e nações. ");
INSERT INTO porbrbsl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Estas são as famílias dos filhos de Noé, por suas gerações, de acordo com suas nações. As nações se dividiram destas na terra após o dilúvio. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","A Terra inteira era de uma língua e de um discurso. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ao viajarem para o leste, encontraram uma planície na terra de Shinar, e ali viveram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Disseram um ao outro: “Venham, vamos fazer tijolos, e queimá-los completamente”. Eles tinham tijolos para pedra, e usavam alcatrão para argamassa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Eles disseram: “Venham, vamos construir uma cidade, e uma torre cujo topo alcança o céu, e vamos fazer um nome para nós mesmos, para que não fiquemos espalhados no exterior sobre a superfície de toda a terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yahweh desceu para ver a cidade e a torre, que os filhos dos homens construíram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Yahweh disse: “Eis que eles são um só povo, e todos eles têm uma só língua, e é isso que eles começam a fazer. Agora nada lhes será negado, o que pretendem fazer”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Venha, vamos descer, e aí confundir a língua deles, para que não entendam o discurso uns dos outros”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Então Yahweh os espalhou dali para o exterior sobre a superfície de toda a terra. Eles pararam de construir a cidade. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Portanto, seu nome foi chamado Babel, porque ali Javé confundiu a linguagem de toda a terra. De lá, Javé os espalhou para o exterior na superfície de toda a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Esta é a história das gerações de Shem: Shem tinha cem anos quando se tornou o pai de Arpachshad dois anos após a enchente. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Shem viveu quinhentos anos depois de se tornar o pai de Arpachshad, e se tornou o pai de mais filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpachshad viveu trinta e cinco anos e tornou-se o pai de Selá. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpachshad viveu quatrocentos e três anos depois de se tornar o pai de Selá, e se tornou o pai de mais filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shelah viveu trinta anos, e tornou-se o pai de Eber. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Shelah viveu quatrocentos e três anos depois de se tornar o pai de Eber, e se tornou o pai de mais filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber viveu trinta e quatro anos, e tornou-se o pai de Peleg. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber viveu quatrocentos e trinta anos depois de se tornar o pai de Peleg, e se tornou o pai de mais filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg viveu trinta anos, e tornou-se o pai de Reu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg viveu duzentos e nove anos depois de se tornar o pai de Reu, e se tornou o pai de mais filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu viveu trinta e dois anos, e tornou-se o pai de Serug. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reu viveu duzentos e sete anos depois de se tornar o pai de Serug, e se tornou o pai de mais filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug viveu trinta anos, e tornou-se o pai de Nahor. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug viveu duzentos anos depois de se tornar o pai de Nahor, e se tornou o pai de mais filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor viveu vinte e nove anos, e tornou-se o pai de Terah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor viveu cento e dezenove anos depois de se tornar o pai de Terah, e se tornou o pai de mais filhos e filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah viveu setenta anos e tornou-se o pai de Abram, Nahor e Haran. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Now esta é a história das gerações de Terah. Terah tornou-se o pai de Abram, Nahor, e Haran. Haran se tornou o pai de Lot. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran morreu na terra de seu nascimento, em Ur dos Caldeus, enquanto seu pai Terah ainda era vivo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram e Nahor casaram esposas. O nome da esposa de Abram era Sarai, e o nome da esposa de Nahor era Milcah, a filha de Haran, que também era o pai de Iscah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai era estéril. Ela não tinha filhos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah levou Abram seu filho, Lot o filho de Haran, o filho de seu filho, e Sarai sua nora, a esposa de Abram, seu filho. Eles foram de Ur dos Caldeus, para ir para a terra de Canaã. Eles vieram para Haran e viveram lá. ");
INSERT INTO porbrbsl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Os dias de Terah foram duzentos e cinco anos. Terah morreu em Haran. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Now Yahweh disse a Abram: “Deixe seu país, e seus parentes, e a casa de seu pai, e vá para a terra que eu lhe mostrarei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Vou fazer de vocês uma grande nação. Eu o abençoarei e farei de seu nome uma grande nação”. Vocês serão uma bênção. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Abençoarei aqueles que te abençoarem e amaldiçoarei aquele que te tratar com desprezo. Todas as famílias da terra serão abençoadas através de vocês”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Então Abram foi, como Yahweh lhe havia dito. Muita coisa foi com ele. Abram tinha setenta e cinco anos de idade quando partiu de Haran. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram levou para a terra de Canaã Sarai sua esposa, o filho de Lot seu irmão, todos os seus bens que haviam reunido, e as pessoas que haviam adquirido em Harã, e eles foram para a terra de Canaã. Eles entraram na terra de Canaã. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram passou pela terra até o lugar de Shechem, até o carvalho de Moreh. Naquela época, os cananeus estavam na terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yahweh apareceu a Abram e disse: “Darei esta terra aos seus descendentes”. Ele construiu ali um altar para Yahweh, que lhe aparecera. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ele partiu dali para ir para a montanha ao leste de Betel e armou sua tenda, tendo Betel ao oeste, e Ai ao leste. Lá ele construiu um altar para Iavé e invocou o nome de Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abram viajou, continuando em direção ao Sul. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Havia uma fome na terra. Abram foi para o Egito para viver como estrangeiro lá, pois a fome era severa na terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Quando chegou perto de entrar no Egito, disse a Sarai sua esposa: “Veja agora, eu sei que você é uma bela mulher para se olhar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Acontecerá que quando os egípcios o virem, dirão: “Esta é sua esposa”. Eles vão me matar, mas vão te salvar vivo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Por favor, diga que você é minha irmã, que pode estar bem comigo por você, e que minha alma pode viver por sua causa”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Quando Abram chegou ao Egito, os egípcios viram que a mulher era muito bonita. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Os príncipes do faraó a viram e a elogiaram ao faraó; e a mulher foi levada para a casa do faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ele lidou bem com Abrão por causa dela. Ele tinha ovelhas, gado, burros machos, servos machos, servas, burros fêmeas e camelos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Yahweh afligiu o faraó e sua casa com grandes pragas por causa de Sarai, a esposa de Abram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","O Faraó chamou Abram e disse: “O que é isso que você fez comigo? Por que você não me disse que ela era sua esposa? ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Por que você disse: “Ela é minha irmã”, para que eu a aceitasse como minha esposa? Agora, portanto, veja sua esposa, leve-a, e siga seu caminho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","O Faraó comandou homens a seu respeito, e eles o acompanharam com sua esposa e tudo o que ele tinha. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram saiu do Egito - ele, sua esposa, tudo o que ele tinha, e Lot com ele - para o Sul. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram era muito rico em gado, em prata e em ouro. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ele foi em suas viagens do Sul até Betel, até o lugar onde sua tenda havia estado no início, entre Betel e Ai, ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","até o lugar do altar, que ele havia feito lá no início. Lá Abram invocou o nome de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot também, que foi com Abram, tinha rebanhos, rebanhos e tendas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","A terra não podia suportá-los, para que pudessem viver juntos; pois seus bens eram tão grandes que não conseguiam viver juntos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Havia uma disputa entre os pastores do rebanho de Abram e os pastores do rebanho de Lot. Os cananeus e os perizitas viviam na terra naquela época. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram disse a Lot: “Por favor, que não haja brigas entre você e eu, e entre seus pastores e meus pastores; pois somos parentes. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","A terra inteira não está diante de você? Por favor, separe-se de mim. Se você for para a mão esquerda, então eu irei para a direita. Ou se você for para a mão direita, então eu irei para a esquerda”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot levantou os olhos, e viu toda a planície do Jordão, que estava bem regada em todos os lugares, antes de Javé destruir Sodoma e Gomorra, como o jardim de Javé, como a terra do Egito, enquanto você vai a Zoar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Então, Lot escolheu a planície do Jordão para si mesmo. Lot viajou para o leste, e eles se separaram um do outro. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram viveu na terra de Canaã, e Lot viveu nas cidades da planície, e mudou sua tenda até Sodoma. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Now os homens de Sodoma eram extremamente perversos e pecadores contra Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Yahweh disse a Abram, depois que Lot foi separado dele: “Agora, levante os olhos e olhe do lugar onde você está, para norte e sul e para leste e oeste, ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","pois eu darei toda a terra que você vê para você e para sua descendência para sempre. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","farei sua prole como o pó da terra, para que se um homem puder contar o pó da terra, então sua prole também possa ser contada. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Levanta-te, caminha pela terra em seu comprimento e em sua largura; pois eu te darei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abram mudou sua tenda, e veio e viveu junto aos carvalhos de Mamre, que estão em Hebron, e construiu ali um altar para Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Nos dias de Amraphel, rei de Shinar; Arioch, rei de Ellasar; Chedorlaomer, rei de Elam; e Tidal, rei de Goiim, ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","fizeram guerra com Bera, rei de Sodoma; Birsha, rei de Gomorra; Shinab, rei de Admah; Shemeber, rei de Zeboiim; e o rei de Bela (também chamado Zoar). ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Todos estes unidos no vale de Siddim (também chamado de Mar Salgado). ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Serviram Chedorlaomer por doze anos, e no décimo terceiro ano se rebelaram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","No décimo quarto ano Chedorlaomer e os reis que estavam com ele vieram e atingiram o Rephaim em Ashteroth Karnaim, o Zuzim em Presunto, o Emim em Shaveh Kiriathaim, ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","e os Horites em seu Monte Seir, a El Paran, que fica no deserto. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Eles voltaram, e vieram para En Mishpat (também chamada Kadesh), e atingiram todo o país dos amalequitas, e também os amoritas, que viviam em Hazazon Tamar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","O rei de Sodoma, e o rei de Gomorra, o rei de Admah, o rei de Zeboiim, e o rei de Bela (também chamado Zoar) saíram; e ordenaram a batalha contra eles no vale de Siddim ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","contra Chedorlaomer, rei de Elam, rei de Goiim, Amraphel, rei de Shinar, e Arioch, rei de Ellasar; quatro reis contra os cinco. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Agora o vale de Siddim estava cheio de poços de alcatrão; e os reis de Sodoma e Gomorra fugiram, e alguns caíram ali. Os que ficaram fugiram para as colinas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Levaram todos os bens de Sodoma e Gomorra, e toda sua comida, e seguiram seu caminho. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Levaram Ló, o filho do irmão de Abrão, que vivia em Sodoma, e seus bens, e partiram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Um que tinha escapado veio e disse a Abram, o hebreu. Naquela época, ele vivia junto aos carvalhos de Mamre, o amorreu, irmão de Eshcol e irmão de Aner. Eles eram aliados de Abram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Quando Abram soube que seu parente tinha sido levado cativo, levou seus trezentos e dezoito homens treinados, nascidos em sua casa, e perseguidos até Dan. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ele se dividiu contra eles à noite, ele e seus servos, e os atingiu, e os perseguiu até Hobah, que está à esquerda de Damasco. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ele trouxe de volta todos os bens, e também trouxe de volta seu Lote relativo e seus bens, e as mulheres também, e as outras pessoas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","O rei de Sodoma saiu ao seu encontro após seu retorno da matança de Chedorlaomer e dos reis que estavam com ele, no vale de Shaveh (isto é, o Vale do Rei). ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melquisedeque, rei de Salém, trouxe pão e vinho. Ele era sacerdote do Altíssimo de Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ele o abençoou e disse: “Bendito seja Abrão de Deus Altíssimo, possuidor do céu e da terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Bendito seja o Deus Altíssimo, que entregou seus inimigos em suas mãos”. Abram lhe deu um décimo de tudo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","O rei de Sodoma disse a Abrão: “Dê-me o povo e leve a mercadoria para si”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram disse ao rei de Sodoma: “Levantei minha mão para Javé, Deus Altíssimo, possuidor do céu e da terra, ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","que não pegarei nem um fio, nem uma correia de sandália, nem nada que seja teu, para que não digas: 'Eu fiz Abram rico'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","nada aceitarei de você, exceto aquilo que os jovens comeram, e a porção dos homens que foram comigo: Aner, Eshcol, e Mamre. Deixe-os levar a porção deles”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Depois destas coisas a palavra de Javé veio a Abram em uma visão, dizendo: “Não tenha medo, Abram”. Eu sou seu escudo, sua recompensa excessivamente grande”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram disse: “Senhor Javé, o que o Senhor me dará, já que eu fico sem filhos, e aquele que herdará meus bens é Eliézer de Damasco”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram disse: “Eis que não me deste filhos; e eis que um nascido em minha casa é meu herdeiro”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Eis que a palavra de Javé veio a ele, dizendo: “Este homem não será seu herdeiro, mas aquele que sairá de seu próprio corpo será seu herdeiro”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yahweh o levou para fora, e disse: “Olhe agora em direção ao céu, e conte as estrelas, se você for capaz de contá-las”. Ele disse a Abram: “Assim será a sua descendência”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ele acreditou em Yahweh, que lhe creditou isso por justiça. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ele disse a Abram: “Eu sou Yahweh, que te tirei de Ur dos Caldeus, para te dar esta terra para herdá-la”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ele disse: “Senhor Yahweh, como saberei que vou herdá-lo?” ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ele lhe disse: “Traga-me uma novilha de três anos, uma cabra de três anos, um carneiro de três anos, uma rola e um pombo jovem”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ele lhe trouxe todas estas, e as dividiu no meio, e as colocou uma à outra; mas ele não dividiu as aves. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","As aves de rapina desceram sobre as carcaças, e Abram as expulsou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Quando o sol estava se pondo, um sono profundo caiu sobre Abram. Agora o terror e a grande escuridão caíram sobre ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ele disse a Abram: “Saiba com certeza que seus descendentes viverão como estrangeiros em uma terra que não é deles, e os servirão”. Eles os afligirão por quatrocentos anos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Eu também julgarei aquela nação, a quem eles servirão. Depois, eles sairão com grande riqueza; ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","mas vocês irão em paz para seus pais. Vocês serão enterrados numa boa velhice. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Na quarta geração eles virão aqui novamente, pois a iniqüidade do amorreu ainda não está cheia”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Aconteceu que, quando o sol se pôs, e estava escuro, eis que um forno fumegante e uma tocha ardente passaram entre estas peças. ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Naquele dia Javé fez um pacto com Abrão, dizendo: “Eu dei esta terra à sua prole, desde o rio do Egito até o grande rio, o rio Eufrates”: ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","a terra dos quenitas, dos quenizitas, dos kadmonitas, ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","os hititas, os perizitas, os refaim, ");
INSERT INTO porbrbsl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","os amoritas, os cananeus, os girgashitas, e os jebusitas”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Agora Sarai, a esposa de Abram, não lhe deu filhos. Ela tinha um servo, um egípcio, cujo nome era Hagar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai disse a Abram: “Veja agora, Yahweh me impediu de suportar”. Por favor, vá até o meu criado. Pode ser que eu obtenha filhos por ela”. Abram ouviu a voz de Sarai. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sarai, esposa de Abram, tomou Hagar, o egípcio, seu servo, depois de Abram ter vivido dez anos na terra de Canaã, e a deu a Abram, seu marido, para ser sua esposa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ele foi para Hagar, e ela concebeu. Quando ela viu que havia concebido, sua amante foi desprezada aos seus olhos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarai disse a Abram: “Este erro é culpa sua. Eu entreguei meu criado em seu seio e quando ela viu que havia concebido, desprezou-me. Que Yahweh julgue entre mim e você”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Mas Abram disse a Sarai: “Eis que sua empregada está em suas mãos”. Faça a ela o que for bom aos seus olhos”. Sarai lidou duramente com ela, e ela fugiu de seu rosto. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","O anjo de Yahweh a encontrou junto a uma fonte de água no deserto, junto à fonte a caminho de Shur. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ele disse: “Hagar, o servo de Sarai, de onde você veio? Para onde você está indo?” Ela disse: “Estou fugindo do rosto de minha amante Sarai”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","O anjo de Yahweh lhe disse: “Volte para sua amante e se submeta sob suas mãos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","O anjo de Yahweh disse a ela: “Multiplicarei grandemente sua descendência, que não serão contados por multidão”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","O anjo de Javé lhe disse: “Eis que você está grávida e dará à luz um filho”. Chamará seu nome Ismael, porque Yahweh ouviu sua aflição. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ele será como um burro selvagem entre os homens. Sua mão será contra todo homem, e a mão de todo homem contra ele. Ele viverá contra todos os seus irmãos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ela chamou o nome de Iavé que falou com ela: “Você é um Deus que vê”, pois ela disse: “Será que eu fiquei vivo depois de vê-lo? ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Portanto, o poço chamava-se Cerveja Lahai Roi. Eis que ele está entre Kadesh e Berede. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagar deu à luz um filho para Abram. Abram chamou o nome de seu filho, a quem Hagar deu à luz, Ismael. ");
INSERT INTO porbrbsl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram tinha oitenta e seis anos quando Hagar deu à luz Ishmael para Abram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Quando Abram tinha noventa e nove anos de idade, Yahweh apareceu a Abram e lhe disse: “Eu sou Deus Todo-Poderoso”. Caminhe diante de mim e seja irrepreensível”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Eu farei meu pacto entre mim e você, e multiplicarei você excessivamente”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram caiu de cara. Deus falou com ele, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Quanto a mim, eis que meu pacto é com você. Você será o pai de uma multidão de nações. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Seu nome não será mais chamado Abrão, mas seu nome será Abraão; pois eu fiz de você o pai de uma multidão de nações. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Eu te farei muito frutífero e farei de ti nações. Reis sairão de vós. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Estabelecerei meu pacto entre mim e vós e vossa descendência depois de vós, através de suas gerações, para um pacto eterno, para ser um Deus para vós e para vossa descendência depois de vós. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Eu darei a vocês, e a seus descendentes depois de vocês, a terra onde vocês estão viajando, toda a terra de Canaã, por uma posse eterna. Eu serei o Deus deles”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Deus disse a Abraão: “Quanto a vocês, guardarão meu pacto, vocês e seus descendentes depois de vocês através de suas gerações”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Este é meu pacto, que guardareis entre mim e vós e vossa descendência depois de vós. Todo macho entre vocês será circuncidado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Você será circuncidado na carne do seu prepúcio. Será um sinal do convênio entre mim e vocês. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Aquele que tiver oito dias de idade será circuncidado entre vocês, todo macho ao longo de suas gerações, aquele que nascer na casa, ou comprado com dinheiro de qualquer estrangeiro que não seja de sua descendência. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Aquele que nasce em sua casa, e aquele que é comprado com seu dinheiro, deve ser circuncidado. Meu convênio estará em sua carne para um convênio eterno. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","O homem incircunciso que não for circuncidado na carne de seu prepúcio, essa alma será cortada de seu povo. Ele quebrou meu pacto”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Deus disse a Abraão: “Quanto a Sarai sua esposa, você não chamará seu nome Sarai, mas seu nome será Sarah”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Eu a abençoarei, e além disso lhe darei um filho por ela”. Sim, eu a abençoarei, e ela será mãe de nações”. Os reis dos povos virão dela”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Então Abraão caiu de cara e riu, e disse em seu coração: “Nascerá uma criança com cem anos de idade? Sara, que tem noventa anos de idade, vai dar à luz”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraão disse a Deus: “Oh, que Ismael possa viver diante de você!” ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Deus disse: “Não, mas Sara, sua esposa, lhe dará um filho”. Você chamará seu nome de Isaac. Estabelecerei meu pacto com ele para um pacto eterno para sua descendência depois dele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Quanto a Ismael, eu já o ouvi. Eis que eu o abençoei e o farei frutificar e o multiplicarei muito. Ele se tornará o pai de doze príncipes, e farei dele uma grande nação. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mas estabelecerei meu convênio com Isaac, que Sara vos levará a esta hora estabelecida no próximo ano”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Quando terminou de falar com ele, Deus subiu de Abraão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Abraão levou a Ismael seu filho, todos os que nasceram em sua casa e todos os que foram comprados com seu dinheiro: todo homem entre os homens da casa de Abraão, e circuncidou a carne de seu prepúcio no mesmo dia, como Deus lhe havia dito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraão tinha noventa e nove anos de idade quando foi circuncidado na carne de seu prepúcio. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ishmael, seu filho, tinha treze anos quando foi circuncidado na carne de seu prepúcio. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","No mesmo dia, tanto Abraão quanto Ismael, seu filho, foram circuncidados. ");
INSERT INTO porbrbsl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Todos os homens de sua casa, os nascidos em casa, e os comprados com dinheiro de um estrangeiro, foram circuncidados com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yahweh apareceu para ele junto aos carvalhos de Mamre, enquanto ele se sentava na porta da tenda no calor do dia. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ele levantou os olhos e olhou, e viu que três homens estavam perto dele. Quando os viu, correu para encontrá-los da porta da tenda e se curvou diante da terra, ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","e disse: “Meu senhor, se agora encontrei favor em sua vista, por favor não se afaste de seu servo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Agora deixai ir buscar um pouco de água, lavai os pés e descansai debaixo da árvore”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Vou buscar um pedaço de pão para que possais refrescar vosso coração. Depois disso, podem seguir o vosso caminho, agora que chegaram ao vosso servo”. Eles disseram: “Muito bem, faça o que você disse”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham correu para a tenda de Sara e disse: “Prepare rapidamente três mares de refeição fina, amasse-os e faça bolos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abraão correu para o rebanho, pegou um terno e bom bezerro e o deu ao criado. Ele apressou-se a vesti-la. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ele pegou manteiga, leite e o bezerro que havia vestido e o colocou diante deles. Ele ficou ao lado deles, debaixo da árvore, e eles comeram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Eles lhe perguntaram: “Onde está Sarah, sua esposa?” Ele disse: “Ali, na tenda”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ele disse: “Certamente voltarei a você por volta desta época no próximo ano; e eis que Sarah, sua esposa, terá um filho”. Sarah ouviu na porta da tenda, que estava atrás dele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Agora Abraão e Sara eram velhos, bem avançados na idade. Sara havia ultrapassado a idade da procriação. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara riu dentro de si, dizendo: “Depois de envelhecer, terei prazer, sendo velho também meu senhor...”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yahweh disse a Abraão: “Por que Sarah riu, dizendo: 'Será que eu realmente vou ter um filho quando for velho? ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","É algo muito difícil para Yahweh? Na hora marcada eu voltarei para você, quando a estação chegar, e Sara terá um filho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Então Sarah negou, dizendo: “Eu não ri”, pois ela estava com medo. Ele disse: “Não, mas você riu”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Os homens se levantaram dali, e olharam para Sodoma. Abraão foi com eles para vê-los em seu caminho. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yahweh disse: “Esconderei de Abraão o que faço, ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","since Abraão certamente se tornará uma grande e poderosa nação, e todas as nações da terra serão abençoadas nele? ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Pois eu o conheci, a fim de que ele possa comandar seus filhos e sua casa depois dele, para que eles guardem o caminho de Javé, para fazer justiça e justiça; a fim de que Javé possa trazer sobre Abraão o que ele falou dele”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Yahweh disse: “Porque o grito de Sodoma e Gomorra é grande, e porque o pecado deles é muito grave, ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","vou descer agora, e ver se seus atos são tão maus quanto os relatórios que chegaram até mim. Se não, eu saberei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Os homens voltaram-se de lá e foram em direção a Sodoma, mas Abraão ainda estava diante de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraão aproximou-se, e disse: “Você vai consumir os justos com os ímpios? ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","E se houver cinqüenta justos dentro da cidade? Vocês consumirão e não pouparão o lugar para os cinqüenta justos que estão dentro dela? ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Que esteja longe de você fazer coisas como essa, matar o justo com o ímpio, para que o justo seja como o ímpio. Que isso esteja longe de você. Não deveria o Juiz de toda a terra fazer o bem?”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yahweh disse: “Se eu encontrar em Sodoma cinqüenta justos dentro da cidade, então eu pouparei todo o lugar para o bem deles”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraão respondeu: “Veja agora, assumi a responsabilidade de falar com o Senhor, embora eu seja pó e cinzas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","What se faltarão cinco dos cinqüenta justos? Vai destruir toda a cidade por falta de cinco”? Ele disse: “Não vou destruí-lo se encontrar quarenta e cinco lá”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ele falou com ele mais uma vez, e disse: “E se forem lá encontrados quarenta”? Ele disse: “Não o farei por causa dos quarenta”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ele disse: “Oh, não deixe o Senhor ficar com raiva, e eu falarei. E se forem encontrados lá trinta”? Ele disse: “Não o farei se encontrar lá trinta”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ele disse: “Veja agora, assumi a responsabilidade de falar com o Senhor”. E se forem encontrados lá vinte”? Ele disse: “Não vou destruí-lo por causa dos vinte”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ele disse: “Oh, não deixe o Senhor ficar bravo, e eu falarei apenas mais uma vez. E se dez forem encontrados lá”? Ele disse: “Não vou destruí-lo por causa dos dez”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yahweh seguiu seu caminho assim que terminou de comungar com Abraão, e Abraão voltou para seu lugar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Os dois anjos vieram a Sodoma à noite. O lote sentou-se no portão de Sodoma. Lot os viu, e se levantou para encontrá-los. Ele se curvou com o rosto na terra, ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","e disse: “Vede agora, meus senhores, por favor, entrem na casa de vosso servo, passem a noite toda, lavem os pés, e podem levantar-se cedo, e seguir seu caminho”. Eles disseram: “Não, mas vamos ficar na rua a noite toda”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ele os exortou muito, e eles entraram com ele, e entraram em sua casa. Ele fez-lhes um banquete, cozeu-lhes pão sem levedura e eles comeram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Mas antes de se deitarem, os homens da cidade, os homens de Sodoma, cercaram a casa, tanto jovens como velhos, todas as pessoas de cada bairro. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Eles chamaram Lot, e lhe disseram: “Onde estão os homens que vieram até você esta noite? Traga-os até nós, para que possamos ter sexo com eles”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot saiu para eles através da porta, e fechou a porta depois de si mesmo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ele disse: “Por favor, meus irmãos, não ajam de forma tão perversa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Veja agora, eu tenho duas filhas virgens. Por favor, deixe-me trazê-las até você, e você pode fazer com elas o que lhe parece bom. Só não faça nada a estes homens, porque eles vieram à sombra do meu teto”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Eles disseram: “Afastem-se!” Depois disseram: “Este indivíduo entrou para viver como estrangeiro, e ele se nomeia juiz. Agora vamos lidar pior com você do que com eles”! Eles pressionaram muito o homem Lot, e se aproximaram para quebrar a porta. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mas os homens estenderam a mão e trouxeram Lot para dentro de casa e fecharam a porta. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Eles atingiram os homens que estavam à porta da casa com cegueira, tanto pequenos quanto grandes, de modo que eles se cansaram de encontrar a porta. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Os homens disseram a Lot: “Você tem mais alguém aqui? Os genros, seus filhos, suas filhas e quem quer que tenham na cidade, tirem-nos do lugar: ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","pois vamos destruir este lugar, porque o clamor contra eles cresceu tanto antes de Javé que Javé nos enviou para destruí-lo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot saiu, e falou com seus genros, que se comprometeram a casar com suas filhas, e disse: “Levantem-se! Saia deste lugar, pois Yahweh destruirá a cidade”! Mas ele parecia estar brincando para seus genros. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Quando chegou a manhã, então os anjos apressaram Lot, dizendo: “Levantem-se! Leve sua esposa e suas duas filhas que estão aqui, para que você não seja consumido na iniqüidade da cidade”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mas ele demorou; e os homens agarraram sua mão, a mão de sua esposa e as mãos de suas duas filhas, sendo Yahweh misericordioso para com ele; e o levaram, e o colocaram fora da cidade. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Aconteceu que, quando os tiraram, ele disse: “Fuja para sua vida! Não olhe para trás, e não fique em nenhum lugar da planície. Fuja para as montanhas, para que você não seja consumido”! ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot disse-lhes: “Oh, não é assim, meu senhor. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Veja agora, seu servo encontrou favor em sua vista, e você ampliou sua bondade amorosa, que você me mostrou ao salvar minha vida. Não posso escapar para a montanha, para que o mal não me ultrapasse, e eu morra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Veja agora, esta cidade está próxima de fugir, e é uma cidade pequena. Oh, deixe-me escapar para lá (não é uma pequena?), e minha alma viverá”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ele lhe disse: “Eis que também atendi seu pedido em relação a isto, que não derrubarei a cidade da qual você falou”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Apresse-se, fuja para lá, pois não posso fazer nada até que você chegue lá”. Portanto, o nome da cidade foi chamado Zoar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","O sol tinha se levantado na terra quando Lot veio a Zoar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Então Yahweh chovia em Sodoma e em Gomorra enxofre e fogo de Yahweh do céu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ele derrubou aquelas cidades, toda a planície, todos os habitantes das cidades, e o que cresceu no chão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mas a esposa de Lot olhou para trás, e ela se tornou um pilar de sal. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham subiu de manhã cedo para o lugar onde havia estado antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ele olhou para Sodoma e Gomorra, e para toda a terra da planície, e viu que a fumaça da terra subia como a fumaça de uma fornalha. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Quando Deus destruiu as cidades da planície, Deus se lembrou de Abraão e enviou Ló para fora do meio do derrube, quando derrubou as cidades em que Ló vivia. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lote saiu de Zoar, e viveu na montanha, e suas duas filhas com ele; pois ele tinha medo de viver em Zoar. Ele vivia em uma caverna com suas duas filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","O primogênito disse aos mais jovens: “Nosso pai é velho, e não há um homem na terra para vir até nós no caminho de toda a terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Come, vamos fazer nosso pai beber vinho, e deitar-nos-emos com ele, para que possamos preservar a linha familiar de nosso pai”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Eles fizeram seu pai beber vinho naquela noite: e o primogênito entrou, e deitou-se com seu pai. Ele não sabia quando ela se deitava, nem quando ela se levantava. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","No dia seguinte, o primogênito disse aos mais jovens: “Eis que eu me deitei ontem à noite com meu pai”. Vamos obrigá-lo a beber vinho novamente esta noite. Você entra e deita-se com ele, para que possamos preservar a linha familiar de nosso pai”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Eles fizeram o pai deles beber vinho também naquela noite. Os mais jovens foram e deitaram-se com ele. Ele não sabia quando ela se deitava, nem quando se levantava. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Thus Ambas as filhas de Lot estavam com o pai grávida. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","O primogênito deu à luz um filho e lhe deu o nome de Moab. Ele é o pai dos moabitas até os dias de hoje. ");
INSERT INTO porbrbsl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","O mais novo também deu à luz um filho, e chamou-o de Ben Ammi. Ele é o pai dos filhos de Ammon até hoje. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraão viajou de lá para a terra do Sul, e viveu entre Kadesh e Shur. Ele viveu como estrangeiro em Gerar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham disse sobre Sara, sua esposa: “Ela é minha irmã”. Abimeleque, rei de Gerar, enviou e levou Sara. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mas Deus veio a Abimelech em um sonho da noite, e lhe disse: “Eis que você é um homem morto, por causa da mulher que tomou; pois ela é a esposa de um homem”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Agora Abimelech não tinha chegado perto dela. Ele disse: “Senhor, você vai matar até mesmo uma nação justa? ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ele não me disse: “Ela é minha irmã”? Ela, até ela mesma, disse: “Ele é meu irmão”. Eu fiz isto na integridade do meu coração e na inocência das minhas mãos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Deus lhe disse no sonho: “Sim, eu sei que na integridade de seu coração você fez isso, e eu também o retive de pecar contra mim”. Portanto, não permiti que você a tocasse. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Agora, portanto, restaure a esposa do homem. Pois ele é um profeta, e rezará por você, e você viverá. Se você não a restaurar, saiba com certeza que morrerá, você e todos os que são seus”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelech levantou-se de manhã cedo, chamou todos os seus criados e disse todas essas coisas ao seu ouvido. Os homens estavam muito assustados. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Então Abimelech chamou Abraão e lhe disse: “O que você fez conosco? Como pequei contra você, que você trouxe sobre mim e sobre meu reino um grande pecado? Vocês me fizeram atos que não deveriam ser feitos”! ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelech disse a Abraão: “O que você viu, que você fez esta coisa?” ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraão disse: “Porque eu pensei: 'Certamente o temor de Deus não está neste lugar'. Eles vão me matar por causa da minha esposa”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Além disso, ela é de fato minha irmã, a filha de meu pai, mas não a filha de minha mãe; e ela se tornou minha esposa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Quando Deus me fez sair da casa de meu pai, eu lhe disse: 'Esta é a sua bondade que você me mostrará'. Em todos os lugares que vamos, digamos de mim, “Ele é meu irmão””. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimelech levou ovelhas e bovinos, servos e servas, e os deu a Abraão, e restaurou Sara, sua esposa, a ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelech disse: “Eis que minha terra está diante de vocês”. Habita onde te aprouver”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A Sara ele disse: “Eis que eu dei a seu irmão mil moedas de prata”. Eis que é para você uma cobertura dos olhos de todos os que estão com você”. Diante de todos vocês, vocês estão justificados”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraão orou a Deus. Então Deus curou Abimelech, sua esposa e suas servas, e elas deram à luz filhos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Pois Javé tinha fechado bem todas as úteras da casa de Abimeleque, por causa de Sara, a esposa de Abraão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yahweh visitou Sarah como ele havia dito, e Yahweh fez com Sarah como ele havia falado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara concebeu, e deu a Abraão um filho em sua velhice, na época em que Deus lhe havia falado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraão chamou seu filho que nasceu para ele, que Sara lhe deu à luz, Isaque. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abraão circuncidou seu filho, Isaac, quando tinha oito dias de idade, como Deus lhe ordenara. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraão tinha cem anos de idade quando seu filho, Isaac, nasceu para ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara disse: “Deus me fez rir”. Todos os que ouvem vão rir comigo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ela disse: “Quem teria dito a Abraão que Sara iria cuidar das crianças? Pois eu lhe dei à luz um filho na sua velhice”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","A criança cresceu e foi desmamada. Abraão fez um grande banquete no dia em que Isaac foi desmamado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sara viu o filho de Agar, o egípcio, que ela havia carregado para Abraão, zombando. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Por isso ela disse a Abraão: “Expulsem este servo e seu filho! Pois o filho deste servo não será herdeiro com meu filho, Isaac”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","A coisa foi muito dolorosa aos olhos de Abraão por causa de seu filho. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Deus disse a Abraão: “Não deixe que seja doloroso aos seus olhos por causa do menino, e por causa de seu servo. Em tudo o que Sara lhe diz, escute a voz dela. Pois sua prole será nomeada através de Isaac. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Farei também uma nação do filho do servo, porque ele é seu filho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abraão levantou-se de manhã cedo, tomou pão e um recipiente com água, e deu-o a Agar, colocando-o no ombro dela; e deu-lhe a criança e a mandou embora. Ela partiu, e vagueou pelo deserto de Beersheba. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","A água do recipiente foi gasta, e ela colocou a criança debaixo de um dos arbustos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ela foi e se sentou em frente a ele, de uma boa maneira, a um tiro de arco. Pois ela disse: “Não me deixe ver a morte da criança”. Ela sentou-se diante dele, levantou sua voz e chorou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Deus ouviu a voz do menino. O anjo de Deus chamou a Hagar do céu e disse-lhe: “O que te incomoda, Hagar? Não tenha medo. Pois Deus ouviu a voz do menino onde ele está. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Levante-se, levante o menino e segure-o com sua mão. Pois eu farei dele uma grande nação”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Deus lhe abriu os olhos, e ela viu um poço de água. Ela foi, encheu o recipiente com água e deu ao menino uma bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Deus estava com o menino, e ele cresceu. Ele viveu no deserto, e à medida que crescia, tornou-se um arqueiro. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ele viveu no deserto de Paran. Sua mãe arranjou uma esposa para ele fora da terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Naquela época, Abimelech e Phicol, o capitão de seu exército, falaram com Abraão, dizendo: “Deus está com você em tudo o que você faz”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Agora, portanto, jurem-me aqui por Deus que não vão lidar falsamente comigo, nem com meu filho, nem com o filho de meu filho. Mas de acordo com a bondade que te fiz, tu me farás a mim e à terra em que viveste como estrangeiro”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham disse: “Eu juro”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abraham reclamou com Abimelech por causa de um poço de água, que os criados de Abimelech haviam tirado violentamente. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelech disse: “Eu não sei quem fez isto. Você não me disse, e eu não ouvi falar até hoje”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham levou ovelhas e gado, e os deu a Abimelech. Esses dois fizeram um pacto. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraão estabeleceu sete ovelhas do rebanho por conta própria. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelech disse a Abraão: “O que significam estas sete ovelhas, que vocês estabeleceram por si mesmos”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ele disse: “Você tirará estas sete ovelhas da minha mão, para que possa ser uma testemunha para mim, que eu cavei este poço”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Por isso ele chamou aquele lugar de Beersheba, porque ambos fizeram um juramento lá. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Então, fizeram um pacto em Beersheba. Abimelech levantou-se com Fícol, o capitão de seu exército, e eles voltaram para a terra dos filisteus. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraão plantou uma árvore de tamargueira em Beersheba, e lá ele invocou o nome de Yahweh, o Deus Eterno. ");
INSERT INTO porbrbsl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraão viveu como um estrangeiro na terra dos filisteus por muitos dias. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Depois destas coisas, Deus testou Abraão, e lhe disse: “Abraão!”. Ele disse: “Aqui estou eu”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ele disse: “Agora pegue seu filho, seu único filho, Isaac, a quem você ama, e vá para a terra de Moriah”. Ofereça-o lá como holocausto em uma das montanhas de que lhe falarei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraão levantou-se cedo pela manhã e selou seu burro; e levou consigo dois de seus jovens e Isaac seu filho. Ele dividiu a madeira para o holocausto, levantou-se e foi para o lugar de que Deus lhe dissera. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","No terceiro dia, Abraão levantou os olhos e viu o lugar distante. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraão disse a seus jovens: “Fiquem aqui com o burro. O garoto e eu iremos até lá”. Vamos adorar, e voltaremos para você”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraão pegou a madeira do holocausto e a colocou sobre Isaac, seu filho. Ele pegou na mão o fogo e a faca. Os dois foram juntos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac falou com Abraão, seu pai, e disse: “Meu pai...”. Ele disse: “Aqui estou eu, meu filho”. Ele disse: “Aqui está o fogo e a lenha, mas onde está o cordeiro para um holocausto”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraão disse: “Deus proverá a si mesmo o cordeiro para um holocausto, meu filho”. Então, ambos foram juntos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Eles vieram ao lugar de que Deus lhe havia falado. Abraão construiu ali o altar, e colocou a madeira em ordem, amarrou Isaque seu filho, e o colocou sobre o altar, sobre a madeira. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraão estendeu sua mão e pegou a faca para matar seu filho. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","O anjo de Javé o chamou do céu, e disse: “Abraão, Abraão!” Ele disse: “Aqui estou eu”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ele disse: “Não coloque sua mão sobre o menino ou faça nada com ele”. Por enquanto sei que você teme a Deus, já que não me escondeu seu filho, seu único filho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham levantou os olhos, olhou e viu que atrás dele estava um carneiro preso na mata por seus chifres. Abraão foi e pegou o carneiro, e o ofereceu em troca de um holocausto em vez de seu filho. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraão chamou o nome daquele lugar de “Yahweh proverá”. Como é dito até hoje, “Na montanha de Yahweh, será providenciado”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","O anjo de Javé chamou Abraão uma segunda vez do céu, ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","e disse: “'Jurei por mim mesmo', diz Javé, 'porque você fez esta coisa, e não reteve seu filho, seu único filho, ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","que eu o abençoarei muito, e multiplicarei seus descendentes como as estrelas dos céus, e como a areia que está na praia. Sua prole possuirá o portão de seus inimigos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Todas as nações da terra serão abençoadas por sua descendência, porque você obedeceu à minha voz”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Então Abraão voltou para seus jovens, e eles se levantaram e foram juntos para Beersheba. Abraão viveu em Beersheba. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Depois destas coisas, foi dito a Abraão: “Eis Milcah, ela também deu à luz filhos a seu irmão Nahor: ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz seu primogênito, Buz seu irmão, Kemuel o pai de Aram, ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Chesed, Hazo, Pildash, Jidlaph, e Bethuel”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel tornou-se o pai de Rebekah. Estes oito Milcah aborreceram Nahor, irmão de Abraham. ");
INSERT INTO porbrbsl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Sua concubina, cujo nome era Reumah, também deu à luz Tebah, Gaham, Tahash, e Maacah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah viveu cento e vinte e sete anos. Esta foi a duração da vida de Sarah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarah morreu em Kiriath Arba (também chamada Hebron), na terra de Canaã. Abraão veio para chorar por Sara, e chorar por ela. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abraão levantou-se de antes de sua morte e falou aos filhos de Heth, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Sou um estranho e um estrangeiro vivendo com você. Dê-me a posse de um lugar de sepultamento com você, para que eu possa enterrar meus mortos fora de minha vista”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Os filhos de Heth responderam a Abraão, dizendo-lhe: ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ouça-nos, meu senhor”. Vós sois um príncipe de Deus entre nós”. Enterrai vossos mortos no melhor de nossos túmulos”. Nenhum de nós lhe ocultará seu túmulo. Enterrai vossos mortos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraão se levantou e se curvou diante do povo da terra, diante dos filhos de Heth. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ele falou com eles, dizendo: “Se você concorda que eu deveria enterrar meus mortos fora de minha vista, ouça-me e rogue por mim a Efrom, filho de Zohar, ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","para que ele me venda a caverna de Machpelah, que ele tem, que está no fim de seu campo. Pelo preço total, deixai-o vender-ma entre vós como posse para um lugar de sepultamento”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Agora Ephron estava sentado no meio das crianças de Heth. Efrom, o hitita, respondeu a Abraão na audiência dos filhos de Heth, mesmo de todos que entraram pelo portão de sua cidade, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Não, meu senhor, ouça-me. Eu lhe dou o campo, e lhe dou a caverna que está nele. Na presença dos filhos de meu povo, eu o dou a vós. Enterrai vossos mortos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraão se curvou diante do povo da terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ele falou a Efron na audiência do povo da terra, dizendo: “Mas se você quiser, por favor, me ouça”. Eu darei o preço do campo”. Tirem-no de mim e eu enterrarei meus mortos lá”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron respondeu a Abraão, dizendo-lhe: ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Meu senhor, escute-me. O que é um pedaço de terra que vale quatrocentos siclos de prata entre mim e você? Enterrai, pois, vossos mortos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham ouviu Ephron. Abraão pesou para Ephron a prata que ele havia nomeado na audiência dos filhos de Heth, quatrocentos siclos de prata, de acordo com o padrão atual dos comerciantes. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Assim, o campo de Efron, que estava em Machpelah, que estava antes de Mamre, o campo, a caverna que estava nele, e todas as árvores que estavam no campo, que estavam em todas as suas fronteiras, foram escrituradas ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","a Abraão por posse na presença dos filhos de Heth, antes de todos os que entraram pelo portão de sua cidade. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Depois disto, Abraão enterrou Sara sua esposa na caverna do campo de Machpelah antes de Mamre (isto é, Hebron), na terra de Canaã. ");
INSERT INTO porbrbsl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","O campo, e a caverna que nele se encontra, foram escrituras de Abraão pelos filhos de Heth como possessão para um lugar de sepultamento. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham era velho, e bem avançado na idade. Javé havia abençoado Abraão em todas as coisas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraão disse a seu servo, o mais velho de sua casa, que governava sobre tudo o que tinha: “Por favor, coloque sua mão debaixo da minha coxa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Eu o farei jurar por Javé, o Deus do céu e o Deus da terra, que não tomará uma esposa para meu filho das filhas dos cananeus, entre os quais eu vivo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Mas ireis ao meu país, e aos meus parentes, e tomareis uma esposa para o meu filho Isaac”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","O criado lhe disse: “E se a mulher não estiver disposta a me seguir até esta terra? Devo trazer seu filho novamente para a terra de onde você veio”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraão disse-lhe: “Cuidado para não trazer meu filho lá novamente”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Javé, o Deus do céu - que me tirou da casa de meu pai e da terra do meu nascimento, que falou comigo e que me jurou, dizendo: 'Eu darei esta terra à sua prole - ele enviará seu anjo diante de você, e você tomará de lá uma esposa para meu filho'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Se a mulher não estiver disposta a segui-lo, então você estará livre deste juramento a mim. Somente você não trará meu filho de lá novamente”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","O criado pôs a mão sob a coxa de Abraão, seu amo, e jurou-lhe a respeito deste assunto. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","O servo pegou dez camelos de seu mestre e partiu, tendo consigo uma variedade de coisas boas de seu mestre. Ele se levantou e foi para a Mesopotâmia, para a cidade de Nahor. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ele fez os camelos ajoelharem-se fora da cidade junto ao poço de água na hora da noite, a hora em que as mulheres saem para tirar água. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ele disse: “Yahweh, o Deus de meu mestre Abraham, por favor, me dê sucesso hoje, e mostre bondade ao meu mestre Abraham. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Eis que estou junto à fonte da água. As filhas dos homens da cidade estão saindo para tirar água. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Que aconteça, que a jovem a quem eu direi: 'Por favor, abaixe seu cântaro, para que eu possa beber', então ela diz: 'Beba, e eu também darei de beber a seus camelos', '- deixe-a ser aquela que você designou para seu servo Isaac. Com isto saberei que você demonstrou gentileza para com meu senhor”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Antes de terminar de falar, eis que Rebekah saiu, que nasceu para Bethuel, filho de Milcah, a esposa de Nahor, irmão de Abraão, com seu cântaro no ombro. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","A jovem era muito bonita de se ver, uma virgem. Nenhum homem a havia conhecido. Ela desceu à fonte, encheu seu jarro, e subiu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","O criado correu para conhecê-la e disse: “Por favor, me dê uma bebida, um pouco de água de seu jarro”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ela disse: “Beba, meu senhor”. Ela se apressou, soltou seu jarro na mão e lhe deu uma bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Quando ela terminou de lhe dar uma bebida, ela disse: “Eu também vou desenhar para seus camelos, até que eles tenham terminado de beber”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","She apressou-se e esvaziou seu cântaro na gamela, e correu novamente para o poço para desenhar, e desenhou para todos os camelos dele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","O homem olhou com firmeza para ela, permanecendo em silêncio, para saber se Yahweh tinha feito sua jornada próspera ou não. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Como os camelos haviam bebido, o homem pegou um anel de ouro de meio shekel de peso, e duas pulseiras para suas mãos de dez shekels de peso de ouro, ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","e disse: “De quem você é filha? por favor, me diga. Há espaço na casa de seu pai para nós ficarmos”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ela lhe disse: “Sou a filha de Bethuel, filho de Milcah, a quem ela deu à luz a Nahor”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ela lhe disse ainda: “Temos palha e comida suficiente, e espaço para nos alojarmos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","O homem abaixou a cabeça e adorou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ele disse: “Bendito seja Javé, o Deus de meu mestre Abraão, que não abandonou sua bondade amorosa e sua verdade para com meu mestre”. Quanto a mim, Javé me conduziu no caminho para a casa dos parentes de meu amo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","A jovem correu e contou estas palavras à casa de sua mãe. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebekah tinha um irmão, e seu nome era Laban. Laban correu para o homem, para a fonte. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Quando ele viu o anel, e as pulseiras nas mãos de sua irmã, e quando ouviu as palavras de Rebekah, sua irmã, dizendo: “Isto é o que o homem me disse”, ele veio até o homem. Eis que ele estava ao lado dos camelos na primavera. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ele disse: “Entre, bendito de Javé”. Por que você está do lado de fora? Porque eu preparei a casa, e espaço para os camelos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","O homem entrou na casa, e descarregou os camelos. Ele deu palha e comida para os camelos, e água para lavar seus pés e os pés dos homens que estavam com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","A comida foi posta diante dele para comer, mas ele disse: “Não comerei até que eu tenha contado minha mensagem”. Laban disse: “Fale mais alto”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ele disse: “Eu sou o servo de Abraão”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yahweh abençoou muito meu mestre. Ele se tornou grande. Javé lhe deu rebanhos e rebanhos, prata e ouro, servos e servas masculinas e femininas, e camelos e burros. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sarah, esposa de meu amo, deu um filho a meu amo quando ela era velha. Ele deu tudo o que tinha a ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Meu senhor me fez jurar, dizendo: 'Você não tomará uma esposa para meu filho das filhas dos cananeus, em cuja terra eu vivo, ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","mas irá à casa de meu pai, e aos meus parentes, e tomará uma esposa para meu filho'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Perguntei ao meu mestre: 'E se a mulher não me seguir? ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ele me disse: 'Javé, diante de quem eu ando, enviará seu anjo com você, e prosperará em seu caminho'. Você levará uma esposa para meu filho de meus parentes, e da casa de meu pai”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Então você estará livre do meu juramento, quando vier aos meus parentes. Se eles não a derem a você, você ficará livre do meu juramento”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Vim hoje à fonte, e disse: 'Javé, o Deus de meu mestre Abraão, se agora você fizer prosperar o meu caminho - ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","eis que estou ao lado desta fonte de água. Que aconteça, que a donzela que sai para desenhar, a quem eu direi: “Por favor, dê-me um pouco de água de seu cântaro para beber”, ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","então ela me diz: “Beba, e eu também desenharei para seus camelos”, - que ela seja a mulher que Javé designou para o filho de meu mestre”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Antes que eu tivesse terminado de falar em meu coração, eis que Rebekah saiu com seu jarro no ombro. Ela desceu para a fonte, e desenhou. Eu disse a ela: “Por favor, deixe-me beber”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ela apressou-se e soltou seu jarro do ombro, e disse: 'Beba, e eu também darei de beber a seus camelos'. Então eu bebi, e ela também deu uma bebida aos camelos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Eu perguntei a ela, e disse: 'De quem é você, filha? Ela disse: 'A filha de Bethuel, o filho de Nahor, que Milcah lhe deu à luz'. Coloquei o anel no nariz dela, e as pulseiras nas mãos dela. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Inclinei minha cabeça e adorei Javé, e abençoei Javé, o Deus de meu mestre Abraão, que me havia conduzido da maneira correta para tomar a filha do irmão de meu mestre para seu filho. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Agora, se você vai lidar com meu mestre de forma gentil e verdadeira, diga-me. Se não, diga-me, que posso virar-me para a mão direita, ou para a esquerda”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Então Laban e Bethuel responderam: “A coisa procede de Yahweh”. Não podemos falar com você, nem mal nem bem. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Veja, Rebekah está diante de você. Pegue-a, e vá, e deixe-a ser a esposa do filho de seu mestre, como Yahweh falou”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Quando o servo de Abraão ouviu suas palavras, ele se curvou à terra para Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","O servo trouxe jóias de prata, e jóias de ouro, e roupas, e as entregou a Rebeca. Ele também deu coisas preciosas a seu irmão e sua mãe. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Eles comeram e beberam, ele e os homens que estavam com ele, e ficaram a noite toda. Eles se levantaram pela manhã e ele disse: “Mande-me embora para meu amo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Seu irmão e sua mãe disseram: “Deixe a jovem ficar conosco alguns dias, pelo menos dez”. Depois disso, ela irá”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ele lhes disse: “Não me impeçam, já que Yahweh prosperou no meu caminho”. Mande-me embora para que eu possa ir ter com meu mestre”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Eles disseram: “Vamos ligar para a jovem, e perguntar-lhe”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Eles ligaram para Rebekah, e disseram a ela: “Você irá com este homem?” Ela disse: “Eu irei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Eles mandaram embora Rebekah, sua irmã, com sua enfermeira, a criada de Abraão, e seus homens. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Eles abençoaram Rebeca, e lhe disseram: “Nossa irmã, que você seja a mãe de milhares de milhares, e deixe sua prole possuir o portão daqueles que os odeiam”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebekah se levantou com suas senhoras. Elas montaram nos camelos e seguiram o homem. O criado pegou Rebekah e seguiu seu caminho. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaac veio do caminho da Cerveja Lahai Roi, pois ele vivia na terra do Sul. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isaac saiu para meditar no campo à noite. Ele levantou os olhos e olhou. Eis que vinham camelos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah levantou os olhos, e quando viu Isaac, ela saiu do camelo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ela disse ao criado: “Quem é o homem que está caminhando no campo para nos encontrar?”. O criado disse: “É meu amo”. Ela pegou seu véu e se cobriu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","O criado contou a Isaac todas as coisas que ele havia feito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaac a trouxe para a tenda de sua mãe Sarah, e levou Rebekah, e ela se tornou sua esposa. Ele a amava. Então Isaac foi consolado após a morte de sua mãe. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham levou outra esposa, e seu nome era Keturah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","She lhe deu à luz Zimran, Jokshan, Medan, Midian, Ishbak e Shuah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan tornou-se o pai de Sheba, e Dedan. Os filhos de Dedan foram Asshurim, Letushim, e Leummim. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Os filhos de Midian foram Ephah, Epher, Hanoch, Abida, e Eldaah. Todos estes eram filhos de Keturah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraão deu tudo o que tinha a Isaac, ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","mas Abraão deu presentes aos filhos das concubinas de Abraão. Enquanto ainda vivia, ele os mandou para longe de Isaque, seu filho, para o leste, para o país oriental. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Estes são os dias dos anos da vida de Abraão que ele viveu: cento e setenta e cinco anos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraão desistiu de seu espírito, e morreu numa boa velhice, um homem velho e cheio de anos, e foi reunido ao seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaac e Ismael, seus filhos, o enterraram na caverna de Machpelah, no campo de Efron, o filho de Zohar, o hitita, que fica perto de Mamre, ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","o campo que Abraão comprou dos filhos de Heth. Abraão foi enterrado lá com Sara, sua esposa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Após a morte de Abraão, Deus abençoou Isaac, seu filho. Isaac viveu ao lado de Cerveja Lahai Roi. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Now esta é a história das gerações de Ismael, filho de Abraão, a quem Hagar, o egípcio, servo de Sara, deu de presente a Abraão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Estes são os nomes dos filhos de Ismael, pelos seus nomes, de acordo com a ordem de nascimento: o primogênito de Ismael, Nebaioth, depois Kedar, Adbeel, Mibsam, ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish, e Kedemah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Estes são os filhos de Ismael, e estes são seus nomes, por suas aldeias, e por seus acampamentos: doze príncipes, de acordo com suas nações. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Estes são os anos da vida de Ismael: cento e trinta e sete anos. Ele desistiu de seu espírito e morreu, e foi reunido ao seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Eles viveram de Havilah a Shur, que é antes do Egito, enquanto vão em direção à Assíria. Ele viveu em frente a todos os seus parentes. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Esta é a história das gerações de Isaac, filho de Abraão. Abraão tornou-se o pai de Isaac. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac tinha quarenta anos quando levou Rebeca, filha de Bethuel, o sírio de Paddan Aram, irmã de Laban, o sírio, para ser sua esposa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac tratou Yahweh por sua esposa, porque ela era estéril. Yahweh foi tratado por ele, e Rebekah sua esposa concebeu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","As crianças lutavam juntas dentro dela. Ela disse: “Se é assim, por que eu vivo?”. Ela foi perguntar a Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yahweh disse a ela, “Duas nações estão em seu ventre. Dois povos serão separados de seu corpo. Um povo será mais forte do que os outros. O mais velho servirá aos mais novos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Quando seus dias para ser entregue foram cumpridos, eis que havia gêmeos em seu ventre. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Os primeiros saíram vermelhos por toda parte, como uma peça de vestuário peluda. Deram-lhe o nome de Esaú. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Depois disso, seu irmão apareceu, e sua mão tinha segurado o calcanhar de Esaú. Ele foi chamado de Jacob. Isaac tinha sessenta anos de idade quando os aborreceu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Os meninos cresceram. Esaú era um hábil caçador, um homem do campo. Jacob era um homem quieto, vivendo em tendas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Agora Isaac amava Esaú, porque comia seu veado. Rebekah amava Jacob. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Jacob fervia guisado. Esaú chegou do campo, e ficou faminto. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau disse a Jacob: “Por favor, alimente-me com um pouco desse guisado vermelho, pois estou faminto”. Portanto, seu nome se chamava Edom. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob disse: “Primeiro, venda-me seu direito de nascimento”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau disse: “Eis que estou prestes a morrer”. De que me serve o direito de nascimento”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacob disse: “Jure primeiro para mim”. Ele jurou a ele. Ele vendeu seu direito de nascimento a Jacob. ");
INSERT INTO porbrbsl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jacob deu pão e guisado de lentilhas a Esaú. Ele comeu e bebeu, levantou-se e seguiu seu caminho. Então Esaú desprezou seu direito de nascença. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Havia uma fome na terra, além da primeira fome que ocorreu nos dias de Abraão. Isaac foi para Abimelech, rei dos filisteus, para Gerar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yahweh apareceu a ele, e disse: “Não desça ao Egito. Vive na terra de que te falarei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Vive nesta terra, e eu estarei contigo, e te abençoarei”. Pois eu lhe darei, e a seus descendentes, todas estas terras, e estabelecerei o juramento que fiz a Abraão, seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Multiplicarei seus descendentes como as estrelas do céu, e darei todas estas terras aos seus descendentes. Em sua descendência todas as nações da terra serão abençoadas, ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","porque Abraão obedeceu à minha voz e cumpriu minhas exigências, meus mandamentos, meus estatutos e minhas leis”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaac viveu em Gerar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Os homens do lugar lhe perguntaram sobre sua esposa. Ele disse: “Ela é minha irmã”, pois ele tinha medo de dizer: “Minha esposa”, para que, pensava ele, “os homens do lugar pudessem me matar por Rebekah, porque ela é linda de se ver”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Quando ele estava lá há muito tempo, Abimelech, rei dos filisteus, olhou por uma janela e viu, e eis que Isaac estava acariciando Rebekah, sua esposa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelech chamou Isaac e disse: “Veja, certamente ela é sua esposa”. Por que você disse: 'Ela é minha irmã'?”. Isaac disse-lhe: “Porque eu disse: 'Para que eu não morra por causa dela'”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelech disse: “O que é isso que você nos fez? Uma das pessoas poderia facilmente ter se deitado com sua esposa, e você teria trazido culpa sobre nós”! ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimelech comandou todo o povo, dizendo: “Aquele que tocar este homem ou sua esposa certamente será condenado à morte”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac semeou naquela terra, e colheu no mesmo ano cem vezes o que plantou. Yahweh o abençoou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","O homem cresceu muito, e cresceu mais e mais até se tornar muito grande. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ele tinha posses de rebanhos, posses de rebanhos e um grande lar. Os filisteus o invejavam. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Agora todos os poços que os servos de seu pai haviam cavado nos dias de Abraão, seu pai, os filisteus haviam parado, e se encheram de terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelech disse a Isaac: “Afaste-se de nós, pois você é muito mais poderoso do que nós”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaac partiu de lá, acampado no vale de Gerar, e viveu lá. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaac cavou novamente os poços de água, que haviam cavado nos dias de Abraão, seu pai, pois os filisteus os haviam impedido após a morte de Abraão. Ele chamou seus nomes depois dos nomes pelos quais seu pai os havia chamado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Os servos de Isaac cavaram no vale, e encontraram ali um poço de água corrente. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Os pastores de Gerar discutiram com os pastores de Isaac, dizendo: “A água é nossa”. Por isso ele chamou o nome do poço Esek, porque eles contendiam com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Eles cavaram outro poço, e discutiram sobre isso também. Então, ele chamou seu nome de Sitnah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ele deixou aquele lugar, e cavou outro poço. Eles não discutiram por causa daquele poço. Então, ele o chamou de Rehoboth. Ele disse: “Por enquanto Yahweh abriu espaço para nós, e nós seremos frutíferos na terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ele subiu de lá para Beersheba. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Yahweh apareceu-lhe na mesma noite e disse: “Eu sou o Deus de Abraão, seu pai. Não tenha medo, pois eu estou com você, e o abençoarei, e multiplicarei sua descendência por meu servo Abraão”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ele construiu ali um altar, invocou o nome de Yahweh e armou ali sua tenda. Ali os servos de Isaac cavaram um poço. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Então Abimelech foi até ele de Gerar com Ahuzzath, seu amigo, e Phicol, o capitão de seu exército. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac lhes disse: “Por que vocês vieram até mim, já que me odeiam e me mandaram embora de vocês”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Eles disseram: “Vimos claramente que Yahweh estava com você”. Dissemos: “Que haja agora um juramento entre nós, mesmo entre nós e você, e façamos um pacto com você, ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","que você não nos fará nenhum mal, pois não lhe tocamos, e como nós não fizemos a você nada além do bem, e o mandamos embora em paz”. Agora você é o abençoado de Javé”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ele os fez um banquete, e eles comeram e beberam. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Eles se levantaram algum tempo pela manhã, e fizeram um juramento um ao outro. Isaac os mandou embora, e eles se afastaram dele em paz. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","No mesmo dia, chegaram os servos de Isaac, e lhe disseram a respeito do poço que haviam cavado, e lhe disseram: “Encontramos água”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ele o chamou de “Shibah”. Portanto, o nome da cidade é “Beersheba” até hoje. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Quando Esaú tinha quarenta anos, tomou como esposa Judith, filha de Beeri, o hitita, e Basemath, a filha de Elon, o hitita. ");
INSERT INTO porbrbsl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","They entristeceu os espíritos de Isaac e Rebekah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Quando Isaac era velho, e seus olhos estavam escuros, para que ele não pudesse ver, chamou Esaú de seu filho mais velho, e disse-lhe: “Meu filho...”. Ele lhe disse: “Aqui estou eu”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ele disse: “Veja agora, eu sou velho. Eu não sei o dia da minha morte. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Agora, portanto, por favor, pegue suas armas, sua aljava e seu arco, e vá para o campo, e traga-me carne de veado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Faça-me comida saborosa, como eu amo, e traga-a até mim, para que eu possa comer, e para que minha alma possa abençoá-lo antes que eu morra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebekah ouviu quando Isaac falou com Esaú seu filho. Esaú foi para o campo para caçar veado e trazê-lo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah falou com Jacó seu filho, dizendo: “Eis que ouvi seu pai falar com Esaú seu irmão, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'Traga-me carne de veado, e faça-me comida saborosa, para que eu possa comer, e abençoá-lo antes de Yahweh antes de minha morte'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Agora, portanto, meu filho, obedece à minha voz segundo o que eu te ordeno. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Vá agora para o rebanho e traga-me dois bons cabritos de lá. Eu os farei comida saborosa para seu pai, tal como ele ama. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Você o trará a seu pai, para que ele possa comer, a fim de que ele o abençoe antes de sua morte”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacob disse a Rebekah sua mãe: “Eis que Esaú meu irmão é um homem peludo, e eu sou um homem liso. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","E se meu pai me tocar? Eu lhe parecerei como um enganador, e traria uma maldição sobre mim mesmo, e não uma bênção”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Sua mãe lhe disse: “Que sua maldição caia sobre mim, meu filho”. Obedeça apenas à minha voz, e vá buscá-los para mim”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ele foi, e os pegou, e os trouxe para sua mãe. Sua mãe fazia comidas saborosas, como as que seu pai amava. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebekah pegou as boas roupas de Esaú, seu filho mais velho, que estavam com ela em casa, e as colocou em Jacob, seu filho mais novo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","She colocou as peles das cabras jovens em suas mãos, e na lisa do pescoço dele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ela deu a comida saborosa e o pão, que ela havia preparado, na mão de seu filho Jacob. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ele veio até seu pai e disse: “Meu pai...”. Ele disse: “Aqui estou eu”. Quem é você, meu filho?” ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob disse a seu pai: “Eu sou Esaú, seu primogênito”. Fiz o que me pediu para fazer. Por favor, levanta-te, senta-te e come do meu veado, para que tua alma me abençoe”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaac disse a seu filho: “Como você o encontrou tão rapidamente, meu filho”? Ele disse: “Porque Yahweh seu Deus me deu o sucesso”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaac disse a Jacob: “Por favor, aproxime-se, para que eu possa sentir você, meu filho, quer você seja realmente meu filho Esaú ou não”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob se aproximou de Isaac, seu pai. Ele o sentiu e disse: “A voz é a voz de Jacó, mas as mãos são as mãos de Esaú”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ele não o reconheceu, porque suas mãos eram peludas, como as mãos de seu irmão Esaú. Por isso, ele o abençoou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ele disse: “Você é realmente meu filho Esaú?”. Ele disse: “Eu sou”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ele disse: “Traga-o perto de mim, e eu comerei do veado de meu filho, para que minha alma o abençoe”. Ele o trouxe para perto dele, e comeu. Trouxe-lhe vinho, e ele bebeu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Seu pai Isaac lhe disse: “Aproxime-se agora, e me beije, meu filho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ele se aproximou e o beijou. Ele sentiu o cheiro de suas roupas e o abençoou, e disse, “Eis o cheiro de meu filho é como o cheiro de um campo que Yahweh abençoou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Deus lhe dê do orvalho do céu, da gordura da terra, e abundância de grãos e vinho novo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Let as pessoas o servem, e as nações se curvam diante de você. Seja senhor de seus irmãos. Deixe que os filhos de sua mãe se curvem diante de você. Malditos sejam todos aqueles que o amaldiçoam. Abençoados sejam todos aqueles que vos abençoam”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Assim que Isaac terminou de abençoar Jacob, e Jacob tinha acabado de sair da presença de Isaac, seu pai, Esaú, seu irmão, veio de sua caçada. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ele também fez comida saborosa, e a trouxe para seu pai. Ele disse a seu pai: “Que meu pai se levante e coma do veado de seu filho, para que sua alma me abençoe”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaac seu pai lhe disse: “Quem é você?” Ele disse: “Eu sou seu filho, seu primogênito, Esaú”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac tremeu violentamente, e disse: “Quem, então, é aquele que tomou o veado e o trouxe até mim, e eu comi de tudo antes de você vir, e o abençoei? Sim, ele será abençoado”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Quando Esaú ouviu as palavras de seu pai, ele chorou com um grito extremamente grande e amargo, e disse a seu pai: “Abençoe-me, a mim também, meu pai”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ele disse: “Seu irmão veio com engano, e lhe tirou a bênção”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ele disse: “Ele não se chama corretamente Jacob? Pois ele me suplantou nestas duas vezes. Ele me tirou o direito de nascença. Veja, agora ele me tirou a bênção”. Ele disse: “Você não reservou uma bênção para mim?”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac respondeu a Esaú: “Eis que eu o fiz vosso senhor, e todos os seus irmãos lhe dei por servos”. Eu o sustentei com grãos e vinho novo”. O que farei então por ti, meu filho”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau disse a seu pai: “Você tem apenas uma bênção, meu pai? Abençoe-me, a mim também, meu pai”. Esaú levantou sua voz, e chorou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isaac, seu pai, lhe respondeu, “Eis que sua morada será da gordura da terra”, e do orvalho do céu vindo de cima. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Você viverá pela sua espada, e servirá a seu irmão. Isso acontecerá, quando você se soltará, que você vai sacudir seu jugo do pescoço”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau odiava Jacob por causa da bênção com a qual seu pai o abençoou. Esaú disse em seu coração: “Os dias de luto por meu pai estão próximos”. Então eu vou matar meu irmão Jacob”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","As palavras de Esaú, seu filho mais velho, foram ditas a Rebekah. Ela enviou e chamou Jacó, seu filho mais novo, e lhe disse: “Eis que seu irmão Esaú se conforta com você planejando matá-lo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Agora, portanto, meu filho, obedeça à minha voz. Levanta-te, foge para Laban, meu irmão, em Haran. ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Fique com ele alguns dias, até que a fúria de seu irmão se afaste - ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","até que a raiva de seu irmão se afaste de você, e ele esqueça o que você fez com ele. Então eu enviarei e o buscarei de lá. Por que eu deveria estar de luto por vocês dois em um dia”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebekah disse a Isaac: “Estou cansada de minha vida por causa das filhas de Heth. Se Jacó toma uma esposa das filhas de Heth, como estas, das filhas da terra, de que me servirá minha vida?”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac chamou Jacob, abençoou-o e ordenou-lhe: “Não tomarás esposa das filhas de Canaã”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Levanta-te, vai a Paddan Aram, à casa de Bethuel, o pai de tua mãe. Tire de lá uma esposa das filhas de Laban, o irmão de sua mãe. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Que Deus Todo-Poderoso te abençoe, te faça frutificar e te multiplique, para que sejas uma companhia de povos, ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","e te dê a bênção de Abraão, a ti e à tua descendência contigo, para que possas herdar a terra onde viajas, que Deus deu a Abraão”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isaac mandou Jacob embora. Ele foi para Paddan Aram para Laban, filho de Bethuel, o sírio, irmão de Rebekah, mãe de Jacob e Esaú. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Agora Esaú viu que Isaac havia abençoado Jacó e o mandado embora para Paddan Aram, para levar-lhe uma esposa de lá, e que ao abençoá-lo ele lhe deu uma ordem, dizendo: “Não tomarás esposa das filhas de Canaã”; ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","e que Jacó obedeceu a seu pai e sua mãe, e foi para Paddan Aram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esaú viu que as filhas de Canaã não agradaram a Isaac, seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Então Esaú foi para Ismael, e levou, além das esposas que tinha, Mahalath a filha de Ismael, filho de Abraão, irmã de Nebaioth, para ser sua esposa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob saiu de Beersheba, e foi em direção a Haran. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ele chegou a um certo lugar, e lá ficou a noite toda, porque o sol se tinha posto. Ele pegou uma das pedras do lugar, colocou-a sob sua cabeça e deitou-se naquele lugar para dormir. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ele sonhou e viu uma escada colocada sobre a terra, e seu topo alcançou o céu. Eis que os anjos de Deus estavam subindo e descendo sobre ela. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Eis que Javé estava acima dela e disse: “Eu sou Javé, o Deus de Abraão, teu pai, e o Deus de Isaac. Darei a você e a seus descendentes a terra sobre a qual você se deita”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Sua descendência será como o pó da terra, e você se espalhará para o oeste, para o leste, para o norte e para o sul. Em você e em sua prole, todas as famílias da terra serão abençoadas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Eis que eu estou com vocês, e os manterei, onde quer que vão, e os trarei novamente para esta terra. Pois não vos deixarei até que eu tenha feito aquilo de que vos falei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacob acordou de seu sono e disse: “Certamente Yahweh está neste lugar, e eu não sabia”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ele estava com medo, e disse: “Como este lugar é incrível! Esta não é outra coisa senão a casa de Deus, e esta é a porta do céu”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jacob levantou-se cedo pela manhã, pegou a pedra que havia colocado sob sua cabeça, colocou-a para um pilar e derramou óleo em sua parte superior. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ele chamou o nome daquele lugar de Betel, mas o nome da cidade foi Luz no início. ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jacob fez um voto, dizendo: “Se Deus estará comigo, e me manterá assim que eu for, e me dará pão para comer, e roupas para vestir, ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","para que eu volte à casa de meu pai em paz, e Yahweh será meu Deus, ");
INSERT INTO porbrbsl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","então esta pedra, que eu preparei para um pilar, será a casa de Deus. De tudo o que vocês me derem, eu certamente lhes darei um décimo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Então Jacob foi em sua viagem, e veio para a terra das crianças do leste. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ele olhou, e viu um poço no campo, e viu três rebanhos de ovelhas ali deitados junto a ele. Pois daquele poço, eles regaram os rebanhos. A pedra na boca do poço era grande. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ali todos os rebanhos estavam reunidos. Eles rolaram a pedra da boca do poço, regaram as ovelhas e colocaram a pedra de volta na boca do poço em seu lugar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob disse a eles: “Meus parentes, de onde vocês são?”. Eles disseram: “Somos de Haran”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ele disse a eles: “Você conhece Laban, o filho de Nahor?” Eles disseram: “Nós o conhecemos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ele lhes disse: “Está tudo bem com ele?” Eles disseram: “Está tudo bem. Veja, Raquel, sua filha, está vindo com as ovelhas”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ele disse: “Eis que ainda é o meio do dia, não o momento de reunir o gado. Regue as ovelhas, e vá alimentá-las”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Eles disseram: “Não podemos, até que todos os rebanhos estejam reunidos, e eles rolam a pedra da boca do poço”. Então, regaremos as ovelhas”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Enquanto ele ainda estava falando com eles, Rachel veio com as ovelhas de seu pai, pois ela as guardava. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Quando Jacó viu Raquel, filha de Laban, irmão de sua mãe, e as ovelhas de Laban, irmão de sua mãe, Jacob se aproximou e rolou a pedra da boca do poço, e regou o rebanho de Laban, irmão de sua mãe. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jacob beijou Raquel, levantou a voz e chorou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacó disse a Rachel que era parente de seu pai, e que era filho de Rebekah. Ela correu e contou ao pai dela. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Quando Laban ouviu a notícia de Jacob, filho de sua irmã, correu para encontrar Jacob, abraçou-o, beijou-o e o trouxe para sua casa. Jacob contou a Laban todas essas coisas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban disse a ele: “Certamente você é meu osso e minha carne”. Jacob ficou com ele por um mês. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban disse a Jacob: “Porque você é meu parente, você deveria então me servir para nada? Diga-me, qual será seu salário?”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban tinha duas filhas. O nome da mais velha era Leah, e o nome da mais nova era Rachel. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Os olhos de Leah eram fracos, mas Rachel era bonita na forma e atraente. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob amava Raquel. Ele disse: “Eu te servirei sete anos por Raquel, sua filha mais nova”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban disse: “É melhor que eu a dê a você, do que eu a dê a outro homem. Fique comigo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jacob serviu sete anos por Raquel. Eles lhe pareceram apenas alguns dias, pelo amor que ele tinha por ela. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Jacob disse a Laban: “Dê-me minha esposa, pois meus dias estão cumpridos, para que eu possa ir até ela”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban reuniu todos os homens do lugar, e fez um banquete. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","À noite, ele levou Leah, sua filha, e a trouxe para Jacob. Ele foi até ela. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban deu a Zilpah sua criada para sua filha Leah como criada. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Pela manhã, eis que era Leah! Ele disse a Laban: “O que é isso que você me fez? Eu não servi com você por Raquel? Por que então você me enganou?” ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban disse: “Não se faz isso em nosso lugar, para dar aos mais jovens antes dos primogênitos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Preencha a semana desta, e nós lhe daremos a outra também pelo serviço que você servirá comigo por mais sete anos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob o fez, e cumpriu sua semana. Ele lhe deu Raquel sua filha como esposa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban deu Bilhah, sua criada, à sua filha Rachel para ser sua criada. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ele foi também para Raquel, e amou também Raquel mais do que Léia, e serviu com ele por mais sete anos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yahweh viu que Leah era odiada, e abriu seu ventre, mas Rachel era estéril. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah concebeu, e deu à luz um filho, e ela lhe deu o nome de Reuben. Pois ela disse: “Porque Javé olhou para minha aflição; por agora meu marido vai me amar”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ela concebeu novamente, e deu à luz um filho, e disse: “Porque Javé ouviu dizer que eu sou odiado, ele me deu este filho também”. Ela lhe deu o nome de Simeão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ela concebeu de novo, e deu à luz um filho. Ela disse: “Agora desta vez meu marido se unirá a mim, porque eu lhe dei três filhos”. Portanto, seu nome foi chamado Levi. ");
INSERT INTO porbrbsl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ela concebeu de novo, e deu à luz um filho. Ela disse: “Desta vez eu louvarei Yahweh”. Por isso ela lhe deu o nome de Judá. Então ela parou de dar à luz. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Quando Rachel viu que não tinha filhos com Jacob, Rachel invejou sua irmã. Ela disse a Jacob: “Dê-me filhos, senão eu morrerei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","A raiva de Jacob queimou contra Raquel, e ele disse: “Estou eu no lugar de Deus, quem vos ocultou o fruto do ventre? ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ela disse: “Veja, minha empregada Bilhah. Vá até ela, para que ela possa suportar meus joelhos, e eu também possa obter filhos por ela”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","She deu-lhe Bilhah sua criada como esposa, e Jacob foi ter com ela. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah concebeu, e deu um filho a Jacob. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel disse: “Deus me julgou, e também ouviu minha voz, e me deu um filho”. Por isso ela chamou-o de Dan. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilhah, criada de Raquel, concebeu novamente, e deu a Jacó um segundo filho. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel disse: “Eu lutei com minha irmã com poderosas lutas, e prevaleceram”. Ela lhe deu o nome de Naftali. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Quando Leah viu que havia terminado de carregar, tomou Zilpah, seu criado, e a deu a Jacob como esposa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpah, a criada de Leah, deu um filho a Jacó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah disse: “Que sorte!”. Ela lhe deu o nome de Gad. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpah, criada de Leah, deu à luz um segundo filho a Jacó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah disse: “Feliz sou eu, pois as filhas me chamarão feliz”. Ela lhe deu o nome de Asher. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Reuben foi nos dias da colheita do trigo, e encontrou mandrágoras no campo, e as trouxe para sua mãe, Leah. Então Rachel disse a Leah: “Por favor, me dê algumas das mandrágoras de seu filho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leah disse-lhe: “É um pequeno assunto que você tenha tirado meu marido? Você tiraria também as mandrágoras do meu filho”? Rachel disse: “Portanto, ele se deitará com você hoje à noite para os mandrágoras de seu filho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Jacob veio do campo à noite, e Leah saiu ao seu encontro, e disse: “Você deve vir até mim; pois eu certamente o contratei com os mandrágoras de meu filho”. Ele deitou-se com ela naquela noite. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Deus ouviu Leah, e ela concebeu, e deu à luz um quinto filho a Jacob. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leah disse: “Deus me deu meu contrato, porque eu dei meu servo ao meu marido”. Ela lhe deu o nome de Issachar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leah concebeu novamente, e deu à luz um sexto filho a Jacó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leah disse: “Deus me dotou de um bom dote. Agora meu marido viverá comigo, porque eu lhe dei seis filhos”. Ela lhe deu o nome de Zebulun. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Em seguida, ela deu à luz uma filha e lhe deu o nome de Dinah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Deus se lembrou de Raquel, e Deus a ouviu, e abriu seu ventre. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","She concebeu, deu à luz um filho, e disse: “Deus me tirou a censura”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ela lhe deu o nome de José, dizendo: “Que Yahweh me acrescente outro filho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Quando Rachel deu à luz José, Jacob disse a Laban: “Mande-me embora, para que eu possa ir para minha própria casa e para meu país”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Dai-me minhas esposas e meus filhos, pelos quais eu vos servi, e deixai-me ir; pois vós sabeis o meu serviço com o qual vos tenho servido”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban disse-lhe: “Se agora encontrei favor em seus olhos, fique aqui, pois eu adivinhei que Yahweh me abençoou para seu bem”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ele disse: “Nomeie seu salário, e eu o darei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob lhe disse: “Você sabe como eu o servi e como seu gado se saiu comigo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Pois era pouco o que você tinha antes de eu vir, e aumentou para uma multidão. Yahweh o abençoou onde quer que eu me voltasse. Agora, quando eu também cuidarei da minha própria casa?”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban disse: “O que devo lhe dar?” Jacob disse: “Você não me dará nada”. Se você fizer isso por mim, eu voltarei a alimentar seu rebanho e o manterei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Hoje passarei por todo o seu rebanho, retirando de lá todo o manchado e manchado, e todo o preto entre as ovelhas, e o manchado e manchado entre os caprinos. Este será o meu contrato. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Portanto, minha retidão responderá por mim daqui por diante, quando vierem a respeito do meu recrutamento que está diante de vocês. Todo aquele que não for manchado e manchado entre as cabras, e o negro entre as ovelhas, que possa estar comigo, será considerado roubado”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban disse: “Eis, que seja de acordo com sua palavra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Naquele dia, ele removeu os caprinos machos que foram manchados e manchados, e todas as cabras que foram manchadas e manchadas, todas as que tinham branco, e todas as pretas entre as ovelhas, e as entregou na mão de seus filhos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ele estabeleceu três dias de viagem entre ele e Jacob, e Jacob alimentou o resto dos rebanhos de Laban. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacob tomou para si varas de choupo fresco, amêndoa e plátano, descascou as faixas brancas nelas, e fez aparecer o branco que estava nas varas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ele colocou as varas que ele havia descascado em frente aos rebanhos nos bebedouros onde os rebanhos vinham para beber. Eles conceberam quando vieram para beber. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Os bandos foram concebidos antes das varas, e os bandos produziram listrados, salpicados e manchados. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob separou os cordeiros, e colocou as faces dos rebanhos em direção às listras e todo o preto do rebanho de Laban. Ele separou seus próprios rebanhos, e não os colocou no rebanho de Laban. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Sempre que o mais forte do rebanho concebeu, Jacob colocou as varas na frente dos olhos do rebanho nos bebedouros, para que eles pudessem conceber entre as varas; ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","mas quando o rebanho estava debilitado, ele não as colocou. Por isso, os cobradores eram de Laban, e os mais fortes de Jacob. ");
INSERT INTO porbrbsl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","O homem aumentou excessivamente, e tinha grandes bandos, fêmeas e servos, e camelos e burros. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob ouviu as palavras dos filhos de Laban, dizendo: “Jacob tirou tudo o que era de nosso pai”. Ele obteve toda essa riqueza com aquilo que era de nosso pai”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacob viu a expressão no rosto de Laban, e, eis que não era para ele como antes. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Yahweh disse a Jacob: “Volte para a terra de seus pais, e para seus parentes, e eu estarei com você”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jacob enviou e chamou Rachel e Leah ao campo para seu rebanho, ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","e lhes disse: “Vejo a expressão no rosto de seu pai, que não é para mim como antes; mas o Deus de meu pai tem estado comigo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Você sabe que eu servi a seu pai com todas as minhas forças. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Seu pai me enganou, e mudou meu salário dez vezes, mas Deus não permitiu que ele me magoasse. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Se Ele disse: 'O salpicado será o seu salário', então todo o rebanho furou salpicado. Se Ele disse, 'O salpicado será seu salário', então todo o rebanho furou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Thus Deus tirou o gado de seu pai e o deu a mim. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Durante a época de acasalamento, levantei os olhos e vi em um sonho, e eis que os cabritos machos que saltaram sobre o rebanho estavam listrados, salpicados e grisalhos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","O anjo de Deus me disse no sonho, 'Jacob', e eu disse, 'Aqui estou eu'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ele disse: 'Agora levantem seus olhos, e eis que todos os bodes machos que saltaram sobre o rebanho estão estriados, salpicados e pardos, pois eu vi tudo o que Laban faz a vocês. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Eu sou o Deus de Betel, onde você ungiu um pilar, onde você fez um voto para mim. Agora levanta-te, sai desta terra, e volta à terra do teu nascimento””. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel e Leah responderam-lhe: “Existe ainda alguma parte ou herança para nós na casa de nosso pai? ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Aren não somos considerados por ele como estrangeiros? Pois ele nos vendeu, e também gastou nosso dinheiro. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Pois todas as riquezas que Deus tirou de nosso pai são nossas e de nossos filhos. Agora, pois, o que quer que Deus lhe tenha dito, faça”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Então Jacob se levantou e colocou seus filhos e suas esposas nos camelos, ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","e levou todo o seu gado, e todos os seus bens que havia recolhido, incluindo o gado que havia adquirido em Paddan Aram, para ir a Isaac, seu pai, à terra de Canaã. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Agora Laban tinha ido tosquiar suas ovelhas; e Rachel roubou os terafins que eram de seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob enganou Laban, o sírio, na medida em que ele não lhe disse que estava fugindo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Então, ele fugiu com tudo o que tinha. Ele se levantou, passou por cima do rio e colocou seu rosto em direção à montanha de Gilead. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Laban foi informado no terceiro dia que Jacob havia fugido. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ele levou seus parentes com ele, e o perseguiu durante sete dias de viagem. Ele o alcançou na montanha de Gilead. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Deus veio a Laban, o Sírio, em um sonho da noite, e disse-lhe: “Cuidado para não falar com Jacó nem bem nem mal”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban apanhou Jacob. Agora Jacob havia armado sua barraca na montanha, e Laban com seus parentes acampados na montanha de Gilead. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labão disse a Jacó: “O que você fez, que me enganou e levou minhas filhas como se fossem cativas da espada? ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Por que você fugiu secretamente, e me enganou, e não me disse, que eu poderia tê-lo mandado embora com alegria e com canções, com pandeiro e com harpa; ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","e não me permitiu beijar meus filhos e minhas filhas? Agora você fez uma tolice. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Está no poder da minha mão feri-lo, mas o Deus de seu pai falou comigo ontem à noite, dizendo: 'Cuidado para não falar com Jacó nem bem nem mal'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Agora, você quer ir embora, porque ansiava muito pela casa de seu pai, mas por que roubou os meus deuses”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob respondeu a Laban: “Porque eu tinha medo, pois disse: 'Não me tire suas filhas à força'”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Qualquer pessoa com quem você encontre seus deuses não viverá. Diante de nossos parentes, descubra o que é seu comigo, e leve-o”. Pois Jacó não sabia que Raquel as havia roubado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban entrou na tenda de Jacob, na tenda de Leah, e na tenda das duas servas; mas não as encontrou. Ele saiu da tenda de Leah, e entrou na tenda de Rachel. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Now Rachel tomou os terafins, colocou-os na sela do camelo, e sentou-se sobre eles. Laban sentiu ao redor de toda a tenda, mas não os encontrou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ela disse a seu pai: “Não deixe que meu senhor se zangue por eu não poder me levantar diante de você; pois estou tendo meu período”. Ele procurou, mas não encontrou o teraphim. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacob estava com raiva e discutiu com Laban. Jacob respondeu a Laban: “Qual é a minha transgressão? Qual é o meu pecado, que você me perseguiu calorosamente? ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Agora que você se sentiu em todas as minhas coisas, o que você encontrou de todas as suas coisas domésticas? Ponha-o aqui diante de meus parentes e de seus parentes, para que eles possam julgar entre nós dois. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Estes vinte anos que estou com você. Suas ovelhas e suas cabras não lançaram seus filhotes e eu não comi os carneiros de seus rebanhos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","O que foi rasgado de animais, eu não trouxe para você. Eu carreguei sua perda. Da minha mão você precisou, seja roubado de dia ou roubado à noite. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Esta era a minha situação: de dia a seca me consumia, e a geada à noite; e meu sono fugia dos meus olhos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Estes vinte anos em que estive em sua casa. Servi-lhe catorze anos por suas duas filhas, e seis anos por seu rebanho, e você mudou dez vezes meu salário. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","A menos que o Deus de meu pai, o Deus de Abraão, e o medo de Isaac, tivesse estado comigo, certamente agora você me teria mandado embora vazio. Deus viu minha aflição e o trabalho de minhas mãos, e te repreendeu ontem à noite”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban respondeu a Jacob: “As filhas são minhas filhas, as crianças são minhas filhas, os rebanhos são meus rebanhos, e tudo o que você vê é meu! O que posso fazer hoje a estas minhas filhas, ou a seus filhos que elas tiveram de suportar? ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Agora venha, vamos fazer um pacto, você e eu. Que seja para uma testemunha entre mim e você”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jacob pegou uma pedra, e a montou para um pilar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jacob disse a seus parentes: “Recolham pedras”. Eles pegaram pedras, e fizeram uma pilha. Eles comeram ali junto à pilha. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban chamou-a de Jegar Sahadutha, mas Jacob a chamou de Galeed. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban disse: “Esta pilha é testemunha entre mim e você hoje”. Portanto, foi chamado de Galeed ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","e Mizpah, pois ele disse: “Yahweh vigia entre mim e você, quando estamos ausentes um do outro”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Se vocês afligem minhas filhas, ou se vocês levam esposas além de minhas filhas, nenhum homem está conosco; eis que Deus é testemunha entre mim e vocês”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban disse a Jacob: “Veja este monte, e veja o pilar, que eu coloquei entre mim e você”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Que este monte seja uma testemunha, e o pilar seja uma testemunha, que eu não passarei este monte para vocês, e que vocês não passarão este monte e este pilar para mim, por mal. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","O Deus de Abraão, e o Deus de Nahor, o Deus de seu pai, julguem entre nós”. Então Jacó jurou pelo medo de seu pai, Isaac. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jacó ofereceu um sacrifício na montanha, e chamou seus parentes para comer pão. Eles comeram pão, e passaram a noite toda na montanha. ");
INSERT INTO porbrbsl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Early pela manhã, Laban levantou-se, beijou seus filhos e suas filhas, e os abençoou. Laban partiu e voltou para seu lugar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob seguiu seu caminho, e os anjos de Deus o conheceram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Quando os viu, Jacob disse: “Este é o exército de Deus”. Ele chamou o nome daquele lugar de Mahanaim. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob enviou mensageiros na sua frente para Esaú, seu irmão, para a terra de Seir, o campo de Edom. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ele lhes ordenou, dizendo: “Isto é o que dirá a meu senhor, Esaú: 'Isto é o que seu servo, Jacó, diz. Eu vivi como estrangeiro com Laban, e fiquei até agora. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Tenho gado, burros, rebanhos, servos masculinos e servos femininos. Enviei para dizer a meu senhor, que talvez eu encontre favor em sua vista”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Os mensageiros retornaram a Jacó, dizendo: “Viemos a seu irmão Esaú. Ele vem ao seu encontro, e quatrocentos homens estão com ele”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Então Jacó teve muito medo e ficou angustiado. Ele dividiu as pessoas que estavam com ele, junto com os rebanhos, os rebanhos e os camelos, em duas empresas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ele disse: “Se Esaú vier a uma empresa, e a atacar, então a empresa que restar escapará”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jacob disse: “Deus de meu pai Abraão, e Deus de meu pai Isaac, Javé, que me disse: 'Retorna ao teu país, e aos teus parentes, e te farei bem', ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Não sou digno da menor de todas as gentilezas amorosas, e de toda a verdade, que mostraste ao teu servo; pois com apenas o meu pessoal atravessei este Jordão; e agora me tornei duas empresas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Please livrai-me da mão de meu irmão, da mão de Esaú; pois eu o temo, para que ele não venha e me bata a mim e às mães com os filhos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Você disse: 'Certamente lhe farei bem, e farei sua prole como a areia do mar, que não pode ser contada porque são tantas'”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ele ficou lá naquela noite, e levou daquilo que tinha com ele um presente para Esaú, seu irmão: ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","duzentas cabras e vinte cabras, duzentas ovelhas e vinte carneiros, ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","thirty camelos de leite e seus potros, quarenta vacas, dez touros, vinte burros fêmeas e dez potros. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ele os entregou nas mãos de seus criados, cada rebanho por si só, e disse a seus criados: “Passem adiante de mim e coloquem um espaço entre rebanho e rebanho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ele ordenou o mais importante, dizendo: “Quando Esaú, meu irmão, te encontrar, e te perguntar, dizendo: 'De quem és tu? Onde você está indo? De quem são estes diante de você? ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Então você dirá: 'Eles são seus servos, de Jacó'. É um presente enviado a meu senhor, Esaú. Eis que ele também está atrás de nós'”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ele comandou também o segundo, e o terceiro, e tudo o que se seguiu aos rebanhos, dizendo: “Assim falareis com Esaú, quando o encontrardes”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","dirá: “Não só isso, mas eis que seu servo, Jacob, está atrás de nós””. Pois, disse ele, “eu o aplacarei com o presente que me precede, e depois verei seu rosto”. Talvez ele me aceite”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Assim, o presente passou diante dele, e ele mesmo passou aquela noite no acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ele se levantou naquela noite, pegou suas duas esposas, seus dois criados e seus onze filhos e cruzou o vau do Jabbok. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ele os pegou, e os enviou pelo riacho, e enviou por cima do que tinha. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jacob foi deixado sozinho, e lutou com um homem lá até o fim do dia. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Quando viu que não prevalecia contra ele, o homem tocou o oco da coxa, e o oco da coxa de Jacob foi esticado enquanto ele lutava. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","O homem disse: “Deixem-me ir, pois o dia se abre”. Jacob disse: “Não te deixarei ir a menos que me abençoes”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ele lhe disse: “Qual é o seu nome?” Ele disse: “Jacob”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ele disse: “Seu nome não se chamará mais Jacó, mas Israel; pois você lutou com Deus e com os homens, e prevaleceu”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacob perguntou-lhe: “Por favor, diga-me seu nome”. Ele disse: “Por que você pergunta qual é o meu nome?” Então ele o abençoou lá. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob chamou o nome do lugar Peniel; pois ele disse: “Eu vi Deus cara a cara, e minha vida é preservada”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","O sol nasceu sobre ele ao passar por cima de Peniel, e ele coxeava por causa de sua coxa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Portanto, as crianças de Israel não comem até hoje o tendão do quadril, que está sobre o oco da coxa, porque ele tocou o oco da coxa de Jacó no tendão do quadril. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob levantou os olhos e olhou, e eis que Esaú estava chegando, e com ele quatrocentos homens. Ele dividiu as crianças entre Leah, Raquel e os dois criados. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ele colocou os servos e seus filhos na frente, Leah e seus filhos depois, e Rachel e Joseph atrás. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ele mesmo passou na frente deles, e se curvou ao chão sete vezes, até chegar perto de seu irmão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esaú correu para encontrá-lo, abraçou-o, caiu em seu pescoço, beijou-o e eles choraram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ele levantou os olhos e viu as mulheres e as crianças; e disse: “Quem são estes com você?”. Ele disse: “As crianças que Deus graciosamente deu a seu servo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Então os servos se aproximaram com seus filhos, e eles se curvaram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leah também e seus filhos se aproximaram, e se curvaram. Depois deles, José se aproximou com Raquel, e eles se curvaram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau disse: “O que você quer dizer com toda essa empresa que eu conheci?” Jacob disse: “Para encontrar um favor aos olhos de meu senhor”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esau disse: “Já tenho o suficiente, meu irmão; que aquilo que você tem seja seu”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacob disse: “Por favor, não, se eu agora encontrei favor em sua visão, então receba meu presente em minhas mãos, porque eu vi seu rosto, como se vê o rosto de Deus, e você ficou satisfeito comigo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Por favor, aceite o presente que lhe trouxe, porque Deus tratou-me com bondade, e porque tenho o suficiente”. Ele o exortou, e ele o aceitou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau disse: “Vamos fazer nossa viagem, e vamos, e eu irei antes de você”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob disse-lhe: “Meu senhor sabe que as crianças são tenras, e que os rebanhos e rebanhos comigo têm seus filhotes, e se um dia eles os superarem, todos os rebanhos morrerão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Por favor, deixe meu senhor passar diante de seu servo, e eu seguirei suavemente, de acordo com o ritmo do gado que está diante de mim e de acordo com o ritmo das crianças, até que eu chegue a meu senhor para Seir”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau disse: “Deixe-me agora deixar com você algumas das pessoas que estão comigo”. Ele disse: “Por quê? Deixe-me encontrar um favor aos olhos de meu senhor”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Então Esau retornou naquele dia a caminho de Seir. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacob viajou para Succoth, construiu ele mesmo uma casa e fez abrigos para seu gado. Portanto, o nome do lugar é chamado Succoth. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacob veio em paz para a cidade de Shechem, que fica na terra de Canaã, quando veio de Paddan Aram; e acampou diante da cidade. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ele comprou a parcela de terreno onde havia estendido sua tenda, nas mãos dos filhos de Hamor, pai de Shechem, por cem peças de dinheiro. ");
INSERT INTO porbrbsl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ele ergueu ali um altar, e o chamou de El Elohe Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dinah, a filha de Leah, que ela carregou para Jacob, saiu para ver as filhas da terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shechem, filho de Hamor o Hivita, o príncipe da terra, a viu. Ele a levou, deitou-se com ela, e a humilhou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sua alma se uniu a Dinah, a filha de Jacó, e ele amava a jovem, e falou gentilmente com a jovem. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shechem falou com seu pai, Hamor, dizendo: “Traga-me esta jovem senhora como esposa”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Agora Jacob ouviu dizer que havia contaminado Dinah, sua filha; e seus filhos estavam com seu gado no campo. Jacó se calou até que eles chegaram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamor, o pai de Siquém, foi até Jacó para conversar com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Os filhos de Jacó vieram do campo quando o ouviram. Os homens ficaram tristes e muito zangados, porque ele tinha feito loucuras em Israel ao deitar-se com a filha de Jacó, coisa que não deveria ser feita. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor falou com eles, dizendo: “A alma de meu filho, Shechem, anseia por sua filha. Por favor, entregue-a a ele como esposa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Faça casamentos conosco. Entregue-nos suas filhas e leve nossas filhas para si. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Vós habitareis conosco e a terra estará diante de vós. Vivam e comerciem nela, e obtenham posses nela”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shechem disse a seu pai e a seus irmãos: “Deixe-me encontrar favor em seus olhos, e o que quer que você me diga, eu darei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Peça-me uma grande quantia por um dote, e eu darei o que você me pedir, mas dê-me a jovem como esposa”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Os filhos de Jacó responderam com engano a Shechem e Hamor, seu pai, quando falaram, porque ele havia contaminado Dinah, sua irmã, ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","e lhes disse: “Não podemos fazer isso, para dar nossa irmã a um incircunciso; pois isso é uma reprovação para nós. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Somente com esta condição consentiremos com você”. Se vocês forem como somos, que cada um de vocês seja circuncidado, ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","então daremos nossas filhas a vocês; e levaremos suas filhas até nós, e moraremos com vocês, e nos tornaremos um só povo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mas se vocês não nos escutarem e forem circuncidados, então levaremos nossa irmã, e nos tornaremos um só povo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Their palavras agradaram a Hamor e Shechem, o filho de Hamor. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","O jovem não esperou para fazer isto, porque ele tinha prazer na filha de Jacó, e foi honrado acima de tudo pela casa de seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor e Shechem, seu filho, chegaram ao portão da cidade deles, e conversaram com os homens da cidade deles, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Estes homens são pacíficos conosco. Portanto, deixe-os viver na terra e comerciar nela. Pois eis que a terra é grande o suficiente para eles. Vamos levar suas filhas até nós como esposas, e vamos dar-lhes nossas filhas”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Somente com esta condição os homens consentirão em viver conosco, em tornar-se um só povo, se cada homem entre nós for circuncidado, como eles são circuncidados. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Seu gado e seus bens e todos os seus animais não serão nossos? Só vamos dar nosso consentimento a eles, e eles vão morar conosco”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Todos os que saíram do portão de sua cidade ouviram Hamor e Shechem, seu filho; e todos os homens foram circuncidados, todos os que saíram do portão de sua cidade. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","No terceiro dia, quando estavam doridos, dois dos filhos de Jacó, Simeão e Levi, irmãos de Dinah, cada um deles pegou sua espada, veio sobre a cidade insuspeita e matou todos os machos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Eles mataram Hamor e Siquém, seu filho, com o fio da espada, e tiraram Dinah da casa de Siquém, e foram embora. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Os filhos de Jacó vieram sobre os mortos, e saquearam a cidade, porque haviam profanado sua irmã. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Levaram seus rebanhos, seus rebanhos, seus burros, aquilo que estava na cidade, aquilo que estava no campo, ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","e toda a sua riqueza. Levaram cativos todos os seus pequenos e suas esposas, e levaram como pilhagem tudo o que havia na casa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jacob disse a Simeon e Levi: “Vocês me perturbaram, para me tornar odioso para os habitantes da terra, entre os cananeus e os perizitas. Eu sou poucos em número. Eles se reunirão contra mim e me atacarão, e eu e minha casa seremos destruídos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Eles disseram: “Ele deve lidar com nossa irmã como com uma prostituta”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Deus disse a Jacob: “Levanta-te, vai até Betel, e vive lá. Faça lá um altar para Deus, que lhe apareceu quando você fugiu da face de Esaú, seu irmão”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Então Jacob disse à sua casa, e a todos que estavam com ele: “Guardem os deuses estrangeiros que estão entre vocês, purifiquem-se e mudem suas roupas”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Vamos levantar-nos e subir até Betel. Farei ali um altar a Deus, que me respondeu no dia da minha angústia, e estava comigo no caminho em que eu ia”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Eles deram a Jacó todos os deuses estrangeiros que estavam em suas mãos, e os anéis que estavam em seus ouvidos; e Jacó os escondeu debaixo do carvalho que era de Shechem. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Eles viajaram, e um terror de Deus estava sobre as cidades que os rodeavam, e não perseguiram os filhos de Jacó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Então Jacó veio para Luz (ou seja, Betel), que está na terra de Canaã, ele e todas as pessoas que estavam com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ele construiu ali um altar, e chamou o lugar de El Beth El; porque ali Deus lhe foi revelado, quando ele fugiu da face de seu irmão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deborah, enfermeira de Rebekah, morreu, e foi enterrada abaixo de Betel sob o carvalho; e seu nome foi chamado Allon Bacuth. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Deus apareceu novamente a Jacob, quando veio de Paddan Aram, e o abençoou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Deus disse a ele: “Seu nome é Jacó. Vosso nome não será mais Jacó, mas vosso nome será Israel”. Ele o nomeou Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Deus disse a ele: “Eu sou Deus Todo-Poderoso”. Sede fecundos e multiplicai-vos”. Uma nação e uma companhia de nações serão de ti, e reis sairão do teu corpo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","A terra que eu dei a Abraão e Isaac, eu a darei a vocês, e a seus descendentes depois de vocês, eu darei a terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Deus subiu dele no lugar onde ele falou com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacob ergueu um pilar no lugar onde falou com ele, um pilar de pedra. Ele derramou uma oferta de bebida sobre ele, e derramou óleo sobre ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacob chamou o nome do lugar onde Deus falou com ele de “Betel”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Eles viajaram de Betel. Ainda havia alguma distância para chegar a Ephrath, e Rachel viajou. Ela teve trabalho pesado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Quando ela estava em trabalhos forçados, a parteira lhe disse: “Não tenha medo, por enquanto você terá outro filho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Quando sua alma estava partindo (pois ela morreu), ela o chamou de Benoni, mas seu pai o chamou de Benjamin. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel morreu, e foi enterrada a caminho de Efrat (também chamada Belém). ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob montou um pilar em seu túmulo. O mesmo é o pilar da sepultura de Raquel até hoje. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel viajou, e espalhou sua tenda para além da torre do Eder. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Enquanto Israel vivia naquela terra, Rubem foi deitar-se com Bilhah, concubina de seu pai, e Israel ouviu falar dela. Agora os filhos de Jacob tinham doze anos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Os filhos de Leah: Reuben (primogênito de Jacó), Simeão, Levi, Judá, Issachar e Zebulom. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Os filhos de Raquel: José e Benjamim. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Os filhos de Bilhah (o criado de Rachel): Dan e Naftali. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Os filhos de Zilpah (criada de Leah): Gad e Asher. Estes são os filhos de Jacob, que nasceram para ele em Paddan Aram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob veio para Isaac, seu pai, para Mamre, para Kiriath Arba (que é Hebron), onde Abraão e Isaac viveram como estrangeiros. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Os dias de Isaac foram cento e oitenta anos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaac desistiu do espírito e morreu, e foi reunido ao seu povo, velho e cheio de dias. Esaú e Jacó, seus filhos, o enterraram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Now esta é a história das gerações de Esaú (ou seja, Edom). ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau tirou suas esposas das filhas de Canaã: Adah a filha de Elon, o hitita; e Oholibamah a filha de Anah, a filha de Zibeon, o Hivita; ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","e Basemath, a filha de Ismael, irmã de Nebaioth. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah aborreceu a Esau Eliphaz. Basemath deu à luz a Reuel. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamah deu à luz Jeush, Jalam, e Korah. Estes são os filhos de Esaú, que nasceram para ele na terra de Canaã. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaú levou suas esposas, seus filhos, suas filhas e todos os membros de sua família, com seu gado, todos os seus animais e todos os seus bens, que ele havia reunido na terra de Canaã, e foi para uma terra longe de seu irmão Jacó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Pois sua substância era grande demais para que eles habitassem juntos, e a terra de suas viagens não podia suportá-los por causa de seu gado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esaú vivia na região montanhosa de Seir. Esau é Edom. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esta é a história das gerações de Esaú, o pai dos Edomitas, na região montanhosa de Seir: ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","estes são os nomes dos filhos de Esaú: Elifaz, o filho de Adah, a esposa de Esaú; e Reuel, o filho de Basemath, a esposa de Esaú. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Os filhos de Elifaz eram Teman, Omar, Zepho e Gatam, e Kenaz. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna foi concubina de Elifaz, filho de Esaú; e ela se aborreceu com Elifaz Amalek. Estes são os descendentes de Adah, a esposa de Esaú. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Estes são os filhos de Reuel: Nahath, Zerah, Shammah, e Mizzah. Estes são os descendentes de Basemath, a esposa de Esaú. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Estes foram os filhos de Oholibamah, a filha de Anah, a filha de Zibeon, a esposa de Esau: ela se aborreceu com Esau Jeush, Jalam, e Korah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Estes são os chefes dos filhos de Esaú: os filhos de Eliphaz, o primogênito de Esaú: chefe Teman, chefe Omar, chefe Zepho, chefe Kenaz, ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","chefe Korah, chefe Gatam, chefe Amalek. Estes são os chefes que vieram de Elifaz na terra de Edom. Estes são os filhos de Adah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Estes são os filhos de Reuel, filho de Esaú: chefe Nahath, chefe Zerah, chefe Shammah, chefe Mizzah. Estes são os chefes que vieram de Reuel, na terra de Edom. Estes são os filhos de Basemath, a esposa de Esaú. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Estes são os filhos de Oholibamah, esposa de Esaú: chefe Jeush, chefe Jalam, chefe Korah. Estes são os chefes que vieram de Oholibamah, filha de Anah, a esposa de Esaú. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Estes são os filhos de Esaú (isto é, Edom), e estes são seus chefes. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Estes são os filhos de Seir, o Horita, os habitantes da terra: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, e Dishan. Estes são os chefes que vieram dos Horitas, os filhos de Seir, na terra de Edom. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Os filhos de Lotan eram Hori e Heman. A irmã de Lotan era Timna. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Estes são os filhos de Shobal: Alvan, Manahath, Ebal, Shepho, e Onam. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Estes são os filhos de Zibeon: Aiah e Anah. Esta é Anah, que encontrou as fontes termais no deserto, enquanto alimentava os burros de Zibeon, seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Estes são os filhos de Anah: Dishon e Oholibamah, a filha de Anah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Estes são os filhos de Dishon: Hemdan, Eshban, Ithran, e Cheran. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Estes são os filhos de Ezer: Bilhan, Zaavan, e Akan. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Estes são os filhos de Dishan: Uz e Aran. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Estes são os chefes que vieram dos Horites: chefe Lotan, chefe Shobal, chefe Zibeon, chefe Anah, ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","chefe Dishon, chefe Ezer, e chefe Dishan. Estes são os chefes que vieram dos horitas, de acordo com seus chefes na terra de Seir. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Estes são os reis que reinaram na terra de Edom, antes que qualquer rei reinasse sobre os filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, o filho de Beor, reinou em Edom. O nome de sua cidade era Dinhabah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela morreu, e Jobab, o filho de Zerah de Bozrah, reinou em seu lugar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab morreu, e Husham, da terra dos Temanitas, reinou em seu lugar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husham morreu, e Hadad, o filho de Bedad, que atingiu Midian no campo de Moab, reinou em seu lugar. O nome de sua cidade era Avith. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad morreu, e Samlah de Masrekah reinava em seu lugar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlah morreu, e Shaul de Rehoboth, junto ao rio, reinou em seu lugar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shaul morreu, e Baal Hanan, filho de Achbor, reinou em seu lugar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal Hanan, o filho de Achbor, morreu, e Hadar reinou em seu lugar. O nome de sua cidade era Pau. O nome de sua esposa era Mehetabel, a filha de Matred, a filha de Mezahab. ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Estes são os nomes dos chefes que vieram de Esaú, de acordo com suas famílias, após seus lugares, e por seus nomes: chefe Timna, chefe Alvah, chefe Jetheth, ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","chefe Oholibamah, chefe Elah, chefe Pinon, ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","chefe Kenaz, chefe Teman, chefe Mibzar, ");
INSERT INTO porbrbsl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","chefe Magdiel, e chefe Iram. Estes são os chefes de Edom, de acordo com suas habitações na terra de sua posse. Este é Esaú, o pai dos edomitas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob viveu na terra das viagens de seu pai, na terra de Canaã. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Esta é a história das gerações de Jacob. José, aos 17 anos, alimentava o rebanho com seus irmãos. Ele era um menino com os filhos de Bilhah e Zilpah, as esposas de seu pai. José trouxe um relato maligno deles ao pai. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Agora Israel amava José mais do que todos os seus filhos, porque ele era o filho de sua velhice, e ele fez dele uma túnica de muitas cores. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Seus irmãos viram que seu pai o amava mais do que todos os seus irmãos, e o odiavam, e não podiam falar pacificamente com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Joseph sonhou um sonho, e contou-o a seus irmãos, e eles o odiavam ainda mais. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ele lhes disse: “Por favor, ouçam este sonho que eu sonhei: ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","pois eis que estávamos amarrando feixes no campo, e eis que meu molho se levantou e também ficou de pé; e eis que seus feixes se aproximaram, e se curvaram ao meu molho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Seus irmãos lhe perguntaram: “Você realmente vai reinar sobre nós? Reinarás de fato sobre nós?” Eles o odiavam ainda mais por seus sonhos e por suas palavras. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ele sonhou mais um sonho, contou-o a seus irmãos, e disse: “Eis que sonhei mais um sonho: e eis que o sol e a lua e onze estrelas se curvaram diante de mim”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ele o contou para seu pai e para seus irmãos. Seu pai o repreendeu, e lhe disse: “Que sonho é esse que você sonhou? Será que eu e sua mãe e seus irmãos iremos realmente nos curvar perante a terra diante de você”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Seus irmãos o invejavam, mas seu pai mantinha este ditado em mente. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","His os irmãos foram alimentar o rebanho de seu pai em Shechem. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israel disse a José: “Seus irmãos não estão alimentando o rebanho em Siquém? Venha, e eu o enviarei para eles”. Ele disse a ele: “Aqui estou eu”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ele lhe disse: “Vá agora, veja se está bem com seus irmãos, e bem com o rebanho; e me traga notícias novamente”. Então ele o enviou para fora do vale de Hebron, e ele veio para Shechem. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Um certo homem o encontrou, e eis que ele estava vagando no campo. O homem lhe perguntou: “O que você está procurando?”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ele disse: “Estou à procura de meus irmãos. Diga-me, por favor, onde eles estão alimentando o rebanho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","O homem disse: “Eles saíram daqui, pois eu os ouvi dizer: 'Vamos para Dothan'”. Joseph foi atrás de seus irmãos, e os encontrou em Dothan. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Eles o viram de longe, e antes que ele se aproximasse deles, conspiraram contra ele para matá-lo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Disseram um para o outro: “Eis que vem este sonhador”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Venha agora, portanto, e vamos matá-lo e lançá-lo em um dos fossos, e diremos: “Um animal maligno o devorou”. Veremos o que será de seus sonhos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Reuben ouviu e o entregou de suas mãos, e disse: “Não vamos tirar-lhe a vida”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Reuben disse a eles: “Não derramemos sangue”. Jogue-o neste poço que está no deserto, mas não coloque nenhuma mão sobre ele” - para que ele possa libertá-lo das mãos deles, para restituí-lo a seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Quando Joseph chegou a seus irmãos, eles tiraram Joseph de sua túnica, a túnica de muitas cores que estava sobre ele; ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","e o pegaram, e o jogaram na cova. A cova estava vazia. Não havia água dentro dela. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Eles se sentaram para comer pão, levantaram os olhos e olharam, e viram que uma caravana de ismaelitas vinha de Gilead, com seus camelos contendo especiarias e bálsamo e mirra, indo levá-lo para o Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Judah disse a seus irmãos: “Que proveito teremos se matarmos nosso irmão e ocultarmos seu sangue? ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Venha, e vamos vendê-lo aos ismaelitas, e não deixemos nossa mão estar sobre ele; pois ele é nosso irmão, nossa carne”. Seus irmãos o escutaram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Os midianitas que eram comerciantes passaram por aqui, tiraram e levantaram José do poço e venderam José aos ismaelitas por vinte moedas de prata. Os mercadores trouxeram José para o Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Reuben voltou ao poço, e viu que Joseph não estava no poço; e rasgou suas roupas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ele voltou para seus irmãos, e disse: “A criança não está mais; e eu, para onde irei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Eles pegaram a túnica de José, mataram um bode macho e mergulharam a túnica no sangue. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Eles pegaram a túnica de muitas cores e a trouxeram ao pai, e disseram: “Encontramos isto. Examinem-na agora e vejam se é ou não a túnica de seu filho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ele a reconheceu, e disse: “É a túnica de meu filho”. Um animal maligno o devorou. José está, sem dúvida, despedaçado”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jacob rasgou suas roupas, colocou saco na cintura e chorou por seu filho por muitos dias. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Todos os seus filhos e todas as suas filhas se levantaram para confortá-lo, mas ele se recusou a ser consolado. Ele disse: “Pois eu irei ao Sheol para o meu filho, de luto”. Seu pai chorou por ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Os midianitas o venderam no Egito a Potiphar, um oficial do faraó, o capitão da guarda. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Naquela época, Judah desceu de seus irmãos e visitou um certo Adullamite, cujo nome era Hirah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ali, Judah viu a filha de um certo cananeu chamado Shua. Ele a levou, e foi até ela. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ela concebeu, e deu à luz um filho; e ele o chamou de Er. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ela concebeu novamente, e deu à luz um filho; e ela lhe deu o nome de Onan. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ela mais uma vez deu à luz um filho, e ele lhe deu o nome de Selá. Ele estava em Chezib quando ela o deu à luz. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judah tomou uma esposa para Er, seu primogênito, e seu nome era Tamar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er, o primogênito de Judah, era perverso aos olhos de Iavé. Então Yahweh o matou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Judah disse a Onan: “Vá até a esposa de seu irmão e cumpra o dever de irmão de um marido para com ela, e crie descendência para seu irmão”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan sabia que a prole não seria dele; e quando ele foi até a esposa de seu irmão, derramou seu sêmen no chão, para não dar a prole para seu irmão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","O que ele fez foi mal aos olhos de Iavé, e ele também o matou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Então Judah disse a Tamar, sua nora: “Fique viúva na casa de seu pai, até que Selá, meu filho, seja adulto”; pois ele disse: “Para que ele não morra também, como seus irmãos”. Tamar foi morar na casa de seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Após muitos dias, a filha de Shua, a esposa de Judah, morreu. Judah foi consolado, e subiu para seus tosquiadores de ovelhas para Timnah, ele e seu amigo Hirah, o adullamita. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Foi dito a Tamar: “Eis que seu sogro está subindo para Timnah para tosquiar suas ovelhas”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ela tirou as vestes de sua viuvez, cobriu-se com seu véu, embrulhou-se e sentou-se no portão de Enaim, que está a caminho de Timnah; pois ela viu que Selá era adulto e não foi dada a ele como esposa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Quando Judah a viu, ele pensou que ela era uma prostituta, pois ela havia coberto seu rosto. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","A propósito, ele se voltou para ela e disse: “Por favor, venha, deixe-me ir até você”, pois ele não sabia que ela era sua nora. Ela disse: “O que você vai me dar, para que você possa vir até mim”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ele disse: “Eu lhe enviarei um cabrito do rebanho”. Ela disse: “Você vai me dar uma promessa, até que você a envie?” ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ele disse: “Que promessa eu lhe darei?” Ela disse: “Seu selo e seu cordão, e seu pessoal que está em suas mãos”. Ele os deu a ela, e ela veio até ela, e ela concebeu por ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ela se levantou, foi embora, tirou-lhe o véu e vestiu as vestes de sua viuvez. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judah enviou a cabra jovem pela mão de seu amigo, o Adullamita, para receber o penhor da mão da mulher, mas ele não a encontrou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Então ele perguntou aos homens de sua casa, dizendo: “Onde está a prostituta, que estava em Enaim à beira da estrada?”. Eles disseram: “Não tem havido aqui nenhuma prostituta”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ele voltou para Judah, e disse: “Não a encontrei; e também os homens do lugar disseram: 'Não houve prostituta aqui'”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judah disse: “Deixe-a ficar com ela, para que não tenhamos vergonha”. Eis que eu enviei esta cabra jovem, e vocês não a encontraram”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Cerca de três meses depois, Judah foi informado: “Tamar, sua nora, interpretou a prostituta. Além disso, eis que ela está com a criança pela prostituição”. Judah disse: “Tragam-na para fora e deixem-na ser queimada”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Quando ela foi trazida para fora, ela enviou para seu sogro, dizendo: “Estou com a criança pelo homem que é dono disto”. Ela também disse: “Por favor, discernam de quem são estes: o sinete, os cordões e o pessoal”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judah os reconheceu e disse: “Ela é mais justa do que eu, porque eu não a dei a Selá, meu filho”. Ele não a conhecia mais. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Na época de seu trabalho, eis que os gêmeos estavam em seu ventre. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Quando ela viajou, um estendeu uma mão e a parteira pegou e amarrou um fio escarlate em sua mão, dizendo: “Isto saiu primeiro”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Quando ele puxou sua mão para trás, eis que seu irmão saiu, e ela disse: “Por que você fez uma brecha para si mesmo?”. Portanto, seu nome foi chamado Perez. ");
INSERT INTO porbrbsl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Depois, seu irmão saiu, que tinha o fio escarlate na mão, e seu nome se chamava Zerah. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joseph foi trazido para o Egito. Potiphar, um oficial do faraó, o capitão da guarda, um egípcio, comprou-o da mão dos ismaelitas que o haviam levado para lá. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yahweh estava com José, e ele era um homem próspero. Ele estava na casa de seu mestre, o egípcio. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Seu mestre viu que Javé estava com ele, e que Javé fez tudo o que ele fez prosperar em sua mão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Joseph encontrou um favor em sua visão. Ele o serviu, e Potiphar o fez superintendente de sua casa, e tudo o que ele tinha em suas mãos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Desde que o fez superintendente em sua casa, e sobre tudo o que ele tinha, Javé abençoou a casa do egípcio por causa de José. A bênção de Javé estava sobre tudo o que ele tinha, na casa e no campo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ele deixou tudo o que tinha nas mãos de José. Ele não se preocupou com nada, exceto com a comida que ele comia. Joseph era bem construído e bonito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Depois destas coisas, a esposa de seu mestre pôs os olhos em Joseph; e ela disse: “Deite-se comigo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mas ele recusou, e disse à esposa de seu mestre: “Eis que meu mestre não sabe o que está comigo na casa, e ele colocou tudo o que tem na minha mão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ninguém é maior nesta casa do que eu, e ele não escondeu nada de mim a não ser você, porque você é sua esposa. Como então posso fazer esta grande maldade, e pecar contra Deus”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Enquanto ela falava com Joseph dia após dia, ele não a ouvia, não mentia por ela, nem estava com ela. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Mais ou menos nessa época, ele entrou na casa para fazer seu trabalho, e não havia nenhum dos homens da casa dentro. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ela o pegou pela roupa dele, dizendo: “Deite-se comigo”. Ele deixou sua roupa na mão dela, e correu para fora. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Quando viu que ele tinha deixado sua roupa na mão dela, e tinha corrido para fora, ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ela chamou os homens de sua casa, e falou com eles, dizendo: “Eis que ele trouxe um hebreu até nós para zombar de nós”. Ele veio até mim para deitar-se comigo, e eu chorei com uma voz alta. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Quando ele ouviu que eu levantei minha voz e chorei, ele deixou sua roupa por mim, e correu para fora”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ela colocou sua veste por ela, até que seu mestre voltou para casa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ela falou com ele de acordo com estas palavras, dizendo: “O servo hebreu, que você nos trouxe, veio até mim para zombar de mim, ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","e enquanto eu levantava minha voz e chorava, ele deixou sua veste por mim, e correu para fora”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Quando seu mestre ouviu as palavras de sua esposa, que ela lhe falou, dizendo: “Foi isso que seu servo me fez”, sua ira se acendeu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","O mestre de José o levou e o colocou na prisão, o lugar onde os prisioneiros do rei estavam presos, e ele estava lá sob custódia. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mas Yahweh estava com Joseph, e mostrou gentileza para com ele, e deu-lhe um favor aos olhos do guardião da prisão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","O guardião da prisão entregou à mão de José todos os prisioneiros que estavam na prisão. O que quer que eles lá fizessem, ele era responsável por isso. ");
INSERT INTO porbrbsl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","O guardião da prisão não cuidou de nada que estivesse sob sua mão, porque Yahweh estava com ele; e o que ele fez, Yahweh fez prosperar. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Depois destas coisas, o mordomo do rei do Egito e seu padeiro ofenderam seu senhor, o rei do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","O Faraó ficou furioso com seus dois oficiais, o copeiro chefe e o padeiro chefe. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ele os colocou sob custódia na casa do capitão da guarda, na prisão, o lugar onde José estava amarrado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","O capitão da guarda os destinou a Joseph, e ele cuidou deles. Eles permaneceram na prisão por muitos dias. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ambos sonharam um sonho, cada homem seu sonho, em uma noite, cada homem de acordo com a interpretação de seu sonho, o portador da taça e o padeiro do rei do Egito, que estavam amarrados na prisão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","José chegou até eles pela manhã, e os viu, e viu que estavam tristes. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ele perguntou aos oficiais do Faraó que estavam com ele sob custódia na casa de seu mestre, dizendo: “Por que você parece tão triste hoje”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Eles lhe disseram: “Sonhamos um sonho, e não há ninguém que possa interpretá-lo”. Joseph disse-lhes: “As interpretações não pertencem a Deus? Por favor, diga-me isso”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","O chefe da copa contou seu sonho a José, e disse-lhe: “Em meu sonho, eis que uma videira estava na minha frente, ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","e na videira havia três ramos. Era como se ela brotasse, florescesse e seus cachos produzissem uvas maduras. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","A taça do Faraó estava na minha mão; e eu peguei as uvas e as espremi na taça do Faraó, e dei a taça na mão do Faraó”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph disse-lhe: “Esta é sua interpretação: os três ramos são três dias”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dentro de mais três dias, o Faraó levantará sua cabeça, e o restituirá ao seu escritório. Você dará a taça do Faraó em sua mão, da mesma forma que você fez quando era seu portador da taça. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mas lembre-se de mim quando estiver bem com você. Por favor, mostre bondade comigo, faça menção de mim ao Faraó e me tire desta casa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Pois de fato, fui roubado da terra dos hebreus, e aqui também nada fiz para que eles me colocassem no calabouço”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Quando o padeiro chefe viu que a interpretação era boa, ele disse a Joseph: “Eu também estava em meu sonho, e eis que três cestas de pão branco estavam sobre minha cabeça. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Na cesta mais alta havia todo tipo de comida cozida para o Faraó, e os pássaros os comiam da cesta na minha cabeça”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph respondeu: “Esta é sua interpretação”. As três cestas são de três dias. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dentro de mais três dias, o Faraó levantará sua cabeça de cima de você, e o pendurará em uma árvore; e os pássaros comerão sua carne de cima de você”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","No terceiro dia, que foi o aniversário do Faraó, ele fez um banquete para todos os seus servos, e levantou a cabeça do copeiro chefe e a cabeça do padeiro chefe entre seus servos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ele restaurou o chefe portador da taça e entregou a taça na mão do Faraó; ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","mas ele enforcou o chefe padeiro, como José havia interpretado para eles. ");
INSERT INTO porbrbsl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","No entanto, o chefe da taça não se lembrava de Joseph, mas esqueceu-o. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ao final de dois anos inteiros, o Faraó sonhou, e eis que ele estava ao lado do rio. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Eis que sete cabeças de gado saíram do rio. Eram elegantes e gordos, e se alimentavam na grama do pântano. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Eis que sete outros bovinos subiram atrás deles do rio, feios e magros, e ficaram ao lado dos outros bovinos à beira do rio. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","O gado feio e magro devorou os sete gados elegantes e gordurosos. Então, o Faraó acordou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ele dormiu e sonhou uma segunda vez; e eis que sete cabeças de grão subiram em um talo, saudável e bom. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Eis que sete cabeças de grão, finas e queimadas com o vento leste, brotaram atrás delas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","As finas cabeças de grão engoliram as sete espigas saudáveis e cheias. O faraó acordou e eis que era um sonho. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Pela manhã, seu espírito estava perturbado, e ele enviou e chamou todos os mágicos e sábios do Egito. O Faraó contou-lhes seus sonhos, mas não havia ninguém que pudesse interpretá-los ao Faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Então, o chefe porta-copos falou ao Faraó, dizendo: “Hoje me lembro de minhas falhas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","O Faraó ficou furioso com seus servos e me colocou sob custódia na casa do capitão da guarda, com o chefe da padaria. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Sonhamos um sonho em uma noite, ele e eu. Cada homem sonhou de acordo com a interpretação de seu sonho. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Estava lá conosco um jovem, um hebreu, servo do capitão da guarda, e nós lhe contamos, e ele nos interpretou nossos sonhos. Ele interpretou para cada homem de acordo com seu sonho. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Como ele interpretou para nós, assim foi. Ele me devolveu ao meu escritório, e o enforcou”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Então o Faraó enviou e chamou José, e o trouxeram apressadamente para fora do calabouço. Ele se barbeou, trocou de roupa e chegou até o Faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","O Faraó disse a José: “Sonhei um sonho, e não há ninguém que possa interpretá-lo”. Ouvi dizer de você, que quando você ouve um sonho você pode interpretá-lo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph respondeu ao Faraó, dizendo: “Não está em mim”. Deus dará ao faraó uma resposta de paz”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","O Faraó falou a José: “Em meu sonho, eis que eu estava à beira do rio; ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","e eis que sete cabeças de gado gordas e lustrosas saíram do rio. Eles se alimentaram na grama do pântano; ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","e eis que outros sete bovinos subiram atrás deles, pobres e muito feios e magros, como nunca vi em toda a terra do Egito por fealdade. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","O gado magro e feio comeu os primeiros sete bovinos gordos; ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","e quando os comeram, não se podia saber que os tinham comido, mas ainda eram feios, como no início. Então, acordei. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Vi em meu sonho, e eis que sete cabeças de grãos subiram em um pé, cheias e boas; ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","e eis que sete cabeças de grãos, murchas, finas e queimadas com o vento leste, brotaram atrás delas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","As finas cabeças de grão engoliram as sete boas cabeças de grão. Eu disse isso aos mágicos, mas não havia ninguém que pudesse me explicar”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joseph disse ao faraó: “O sonho do faraó é um só. O que Deus está prestes a fazer, ele declarou ao Faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Os sete bons cabeças de gado são sete anos; e as sete boas cabeças de grãos são sete anos”. O sonho é um só. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Os sete bovinos magros e feios que vieram depois deles são sete anos, e também as sete cabeças de grão vazias, queimadas com o vento leste; serão sete anos de fome. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Foi o que eu falei ao Faraó. Deus mostrou ao faraó o que ele está prestes a fazer. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Eis que sete anos de grande abundância em toda a terra do Egito estão chegando. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Sete anos de fome surgirão depois deles, e toda a abundância será esquecida na terra do Egito. A fome consumirá a terra, ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","e a abundância não será conhecida na terra por causa da fome que se seguirá; pois será muito dolorosa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","O sonho foi duplicado para o Faraó, porque a coisa é estabelecida por Deus, e Deus em breve a realizará. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Agora, portanto, deixe o Faraó procurar um homem discreto e sábio, e o ponha sobre a terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Que o Faraó faça isso, e que ele nomeie supervisores sobre a terra, e assuma a quinta parte da terra dos produtos do Egito nos sete abundantes anos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Let eles reúnem toda a comida destes bons anos que vêm, e armazenam os grãos sob a mão do Faraó para comida nas cidades, e deixem que eles a guardem. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Os alimentos serão para fornecer a terra contra os sete anos de fome, que estarão na terra do Egito; para que a terra não pereça por causa da fome”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","A coisa era boa aos olhos do Faraó, e aos olhos de todos os seus servos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","O Faraó disse a seus servos: “Podemos encontrar um homem como este, um homem em quem está o Espírito de Deus”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Faraó disse a José: “Porque Deus lhe mostrou tudo isso, não há ninguém tão discreto e sábio como você”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Você estará sobre minha casa”. Todo o meu povo será governado de acordo com a sua palavra. Somente no trono serei maior do que vós”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","O Faraó disse a José: “Eis que eu te pus sobre toda a terra do Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","O Faraó tirou seu anel sinete da mão e o colocou na mão de José, vestiu-o com vestes de linho fino e colocou uma corrente de ouro em seu pescoço. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ele o fez andar na segunda carruagem que ele tinha. Choraram diante dele: “Curva o joelho!”. Ele o colocou sobre toda a terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","O Faraó disse a José: “Eu sou o Faraó. Sem você, nenhum homem levantará a mão ou o pé em toda a terra do Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","O Faraó chamou José de Zafenath-Paneah. Ele lhe deu Asenath, a filha de Potiphera, sacerdote de On, como esposa. José saiu sobre a terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","José tinha trinta anos de idade quando se apresentou diante do Faraó, rei do Egito. José saiu da presença do Faraó, e percorreu toda a terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Nos sete anos abundantes, a terra produziu em abundância. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ele reuniu todos os alimentos dos sete anos que estavam na terra do Egito, e depositou os alimentos nas cidades. Ele armazenava os alimentos em cada cidade a partir dos campos ao redor daquela cidade. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph depositou grãos como a areia do mar, muito, até que parou de contar, pois era sem número. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Para José nasceram dois filhos antes do ano da fome, que Asenath, a filha de Potiphera sacerdote de On, lhe deu à luz. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph chamou o nome do primogênito Manasseh, “Pois”, disse ele, “Deus me fez esquecer toda a minha labuta, e toda a casa de meu pai”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","O nome do segundo, ele chamou Efraim: “Porque Deus me fez frutificar na terra da minha aflição”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Os sete anos de abundância, que se passaram na terra do Egito, chegaram ao fim. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Os sete anos de fome começaram a chegar, tal como José havia dito. Havia fome em todas as terras, mas em todas as terras do Egito havia pão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Quando toda a terra do Egito ficou faminta, o povo clamou ao Faraó por pão, e o Faraó disse a todos os egípcios: “Ide ter com José”. O que ele vos disser, fazei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","A fome estava sobre toda a superfície da terra. José abriu todas as casas das lojas e vendeu para os egípcios. A fome era severa na terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Todos os países vieram ao Egito, a José, para comprar grãos, porque a fome era severa em toda a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Agora Jacob viu que havia grãos no Egito, e Jacob disse a seus filhos: “Por que vocês olham um para o outro? ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ele disse: “Eis que eu ouvi dizer que há grãos no Egito. Vá até lá, e compre para nós de lá, para que possamos viver, e não morrer”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Os dez irmãos de Joseph desceram para comprar grãos do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mas Jacob não enviou Benjamin, irmão de Joseph, com seus irmãos; pois ele disse: “Para que não lhe aconteça mal”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Os filhos de Israel vieram comprar entre aqueles que vieram, pois a fome estava na terra de Canaã. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","José era o governador sobre a terra. Foi ele quem vendeu para todo o povo da terra. Os irmãos de José vieram, e se curvaram diante dele com o rosto voltado para a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Joseph viu seus irmãos e os reconheceu, mas agiu como um estranho para eles, e falou grosseiramente com eles. Ele disse a eles: “De onde vocês vieram?”. Eles disseram: “Da terra de Canaã, para comprar comida”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph reconheceu seus irmãos, mas eles não o reconheceram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Joseph lembrou-se dos sonhos que sonhou com eles, e disse-lhes: “Vocês são espiões! Vocês vieram para ver a nudez da terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Eles lhe disseram: “Não, meu senhor, mas seus servos vieram para comprar comida. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Somos todos filhos de um só homem; somos homens honestos. Seus servos não são espiões”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ele lhes disse: “Não, mas vocês vieram para ver a nudez da terra”! ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Eles disseram: “Nós, seus servos, somos doze irmãos, filhos de um só homem na terra de Canaã; e eis que o mais novo está hoje com nosso pai, e um não está mais”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph disse-lhes: “É como eu lhes disse, dizendo: 'Vocês são espiões'! ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Por isso vocês serão testados. Pela vida do faraó, vocês não sairão daqui, a menos que seu irmão mais novo venha aqui. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Enviem um de vocês, e deixem-no pegar seu irmão, e ficarão presos, para que suas palavras possam ser testadas, quer haja verdade em vocês, quer pela vida do Faraó, certamente vocês são espiões”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ele os pôs todos juntos sob custódia por três dias. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Joseph disse a eles no terceiro dia: “Façam isso, e vivam, pois temo a Deus”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Se vocês são homens honestos, então deixem um de seus irmãos ser amarrado em sua prisão; mas vocês vão, carreguem grãos para a fome de suas casas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Traga seu irmão mais novo até mim; assim suas palavras serão verificadas, e você não morrerá”. Eles o fizeram. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Disseram um ao outro: “Certamente somos culpados em relação ao nosso irmão, pois vimos a aflição de sua alma, quando ele nos implorou, e não quisemos escutar. Portanto, esta angústia chegou até nós”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben respondeu-lhes, dizendo: “Eu não lhes disse, dizendo: 'Não pequem contra a criança', e vocês não quiseram ouvir? Portanto, também, eis que seu sangue é necessário”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Eles não sabiam que José os entendia, pois havia um intérprete entre eles. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ele se afastou deles, e chorou. Depois voltou para eles, falou com eles, tirou Simeão do meio deles e o amarrou diante dos olhos deles. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Então Joseph deu ordem para encher seus sacos com grãos, e para restaurar o dinheiro de cada homem em seu saco, e para dar-lhes comida para o caminho. Assim foi feito com eles. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Eles carregaram seus burros com seus grãos e partiram de lá. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Quando um deles abriu seu saco para dar comida ao burro no local de hospedagem, ele viu seu dinheiro. Eis que ele estava na boca de seu saco. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ele disse a seus irmãos: “Meu dinheiro foi restaurado! Eis que está no meu saco”! Seus corações falharam, e eles se viraram tremendo uns para os outros, dizendo: “O que é isto que Deus nos fez? ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Eles vieram a Jacó, seu pai, à terra de Canaã, e lhe contaram tudo o que lhes havia acontecido, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“O homem, o senhor da terra, falou grosso modo conosco, e nos tomou por espiões do país. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nós lhe dissemos: “Somos homens honestos”. Não somos espiões”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Somos doze irmãos, filhos de nosso pai; um não é mais, e o mais jovem está hoje com nosso pai na terra de Canaã”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","O homem, o senhor da terra, nos disse: 'Com isto saberei que vocês são homens honestos: deixem um de seus irmãos comigo, e levem grãos para a fome de suas casas, e sigam seu caminho'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Traga seu irmão mais novo até mim. Então saberei que vocês não são espiões, mas que são homens honestos”. Portanto, eu vos entregarei vosso irmão, e negociareis na terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Quando esvaziaram seus sacos, eis que o pacote de dinheiro de cada homem estava em seu saco. Quando eles e seu pai viram seus maços de dinheiro, ficaram com medo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob, o pai deles, disse a eles: “Vocês me enlutaram de meus filhos! José não é mais, Simeão não é mais, e você quer levar Benjamin embora. Todas estas coisas estão contra mim”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Reuben falou com seu pai, dizendo: “Matem meus dois filhos, se eu não o levar até vocês. Confie-o aos meus cuidados, e eu o trarei até você novamente”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ele disse: “Meu filho não descerá com você, pois seu irmão está morto, e só resta ele”. Se lhe acontecer algum mal pelo caminho em que você for, então derrubará meus cabelos grisalhos com tristeza para o Sheol”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","A fome era severa na terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Quando eles comeram os grãos que haviam trazido do Egito, seu pai lhes disse: “Vão novamente, comprem-nos um pouco mais de comida”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Judah falou com ele, dizendo: “O homem nos advertiu solenemente, dizendo: 'Você não verá meu rosto, a menos que seu irmão esteja com você'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Se você enviar nosso irmão conosco, nós desceremos e lhe compraremos comida; ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","mas se você não o enviar, nós não desceremos, pois o homem nos disse: 'Você não verá meu rosto, a menos que seu irmão esteja com você'”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel disse: “Por que você me tratou tão mal, dizendo ao homem que você tinha outro irmão”? ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Eles disseram: “O homem perguntou diretamente sobre nós mesmos, e sobre nossos parentes, dizendo: 'Seu pai ainda está vivo? Você tem outro irmão? Nós apenas respondemos às suas perguntas. Há alguma maneira de sabermos que ele diria: 'Traga seu irmão para baixo?'”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judah disse a Israel, seu pai: “Mande o menino comigo, e nós nos levantaremos e iremos, para que possamos viver, e não morrer, tanto nós, como você, e também nossos pequenos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I será uma garantia para ele. Da minha mão você vai precisar dele. Se eu não o trouxer até você, e o colocar diante de você, então deixe-me carregar a culpa para sempre; ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","pois se não tivéssemos nos atrasado, certamente já teríamos retornado uma segunda vez”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","O pai deles, Israel, disse-lhes: “Se deve ser assim, então façam isto: Pegue dos frutos escolhidos da terra em suas bolsas, e leve um presente para o homem, um pouco de bálsamo, um pouco de mel, especiarias e mirra, nozes e amêndoas; ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","e pegue o dinheiro em dobro em sua mão, e leve de volta o dinheiro que foi devolvido na boca de suas bolsas. Talvez tenha sido um lapso. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Pegue seu irmão também, levante-se e retorne ao homem. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Que Deus Todo-Poderoso lhe dê misericórdia diante do homem, para que ele lhe solte seu outro irmão e Benjamin. Se eu estou de luto por meus filhos, estou de luto”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Os homens pegaram aquele presente, pegaram o dobro do dinheiro na mão e Benjamin; e se levantaram, desceram ao Egito e se colocaram diante de José. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Quando Joseph viu Benjamin com eles, disse ao administrador de sua casa: “Traga os homens para dentro de casa, e açougue um animal, e prepare-se; pois os homens jantarão comigo ao meio-dia”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","O homem fez como José ordenou, e o homem trouxe os homens para a casa de José. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Os homens tiveram medo, porque foram trazidos à casa de José; e disseram: “Por causa do dinheiro que foi devolvido em nossos sacos na primeira vez, somos trazidos; para que ele busque ocasião contra nós, nos ataque e nos tome como escravos, junto com nossos burros”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Eles se aproximaram do mordomo da casa de José, e falaram com ele na porta da casa, ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","e disseram: “Oh, meu senhor, nós realmente descemos a primeira vez para comprar comida. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Quando chegamos ao alojamento, abrimos nossos sacos, e eis que o dinheiro de cada homem estava na boca de seu saco, nosso dinheiro em pleno peso. Trouxemo-lo de volta em nossas mãos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","We trouxemos outro dinheiro em nossa mão para comprar comida. Não sabemos quem colocou nosso dinheiro em nossos sacos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ele disse: “Que a paz esteja com você”. Não tenha medo. Seu Deus, e o Deus de seu pai, lhe deu um tesouro em seus sacos. Eu recebi seu dinheiro”. Ele trouxe Simeão até eles. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","O homem trouxe os homens para a casa de José, deu-lhes água e eles lavaram os pés. Ele deu forragem para os burros deles. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Eles prepararam o presente para a chegada de José ao meio-dia, pois souberam que ali deveriam comer pão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Quando Joseph chegou em casa, eles lhe trouxeram o presente que estava em suas mãos, e se curvaram diante dele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ele lhes perguntou sobre seu bem-estar, e disse: “Seu pai está bem, o velho de quem você falou? Ele ainda está vivo?” ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Eles disseram: “Seu servo, nosso pai, está bem”. Ele ainda está vivo”. Eles se curvaram humildemente. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ele levantou os olhos e viu Benjamin, seu irmão, o filho de sua mãe, e disse: “Este é seu irmão mais novo, de quem você falou comigo”? Ele disse: “Deus seja bondoso para contigo, meu filho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Joseph apressou-se, pois seu coração ansiava por seu irmão; e procurou um lugar para chorar. Ele entrou em seu quarto, e chorou ali. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Lavou seu rosto e saiu. Ele se controlou e disse: “Sirva a refeição”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Eles o serviram sozinho, e eles sozinhos, e os egípcios que comiam com ele sozinhos, porque os egípcios não comem com os hebreus, pois isso é uma abominação para os egípcios. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Eles se sentaram diante dele, o primogênito de acordo com seu direito de nascimento, e o mais jovem de acordo com sua juventude, e os homens se maravilharam uns com os outros. ");
INSERT INTO porbrbsl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ele enviou-lhes porções de antes dele, mas a porção de Benjamin era cinco vezes maior do que a de qualquer um deles. Eles bebiam, e se alegraram com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ele comandou o mordomo de sua casa, dizendo: “Encha os sacos dos homens com comida, tanto quanto eles possam carregar, e ponha o dinheiro de cada homem na boca de seu saco”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ponha meu copo, o copo de prata, na boca do saco dos mais jovens, com seu dinheiro de grãos”. Ele fez de acordo com a palavra que Joseph havia falado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Assim que a manhã estava leve, os homens foram mandados embora, eles e seus burros. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Quando saíram da cidade, e ainda não estavam longe, Joseph disse ao seu mordomo: “Para cima, sigam os homens”. Quando você os ultrapassar, pergunte-lhes: “Por que você recompensou o mal pelo bem? ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Não é isto que meu senhor bebe, e pelo qual ele realmente divulga? Você fez o mal ao fazer isso”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ele as ultrapassou, e lhes dirigiu estas palavras. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Disseram-lhe: “Por que meu senhor fala palavras como estas? Longe de seus servos que eles devam fazer tal coisa! ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Eis que o dinheiro, que encontramos na boca de nossos sacos, trouxemos de novo para fora da terra de Canaã. Como então devemos roubar prata ou ouro da casa de vosso senhor? ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Com quem de seus servos for encontrado, deixe-o morrer, e nós também seremos escravos de meu senhor”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ele disse: “Agora também que seja de acordo com suas palavras”. Aquele com quem for encontrado será meu escravo; e vós sereis irrepreensíveis”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Então eles se apressaram, e cada homem levou seu saco para o chão, e cada homem abriu seu saco. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ele procurou, começando pelo mais velho e terminando pelo mais novo. A taça foi encontrada no saco de Benjamin. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Então eles rasgaram suas roupas e cada homem carregou seu burro e voltou para a cidade. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Judah e seus irmãos chegaram à casa de José, e ele ainda estava lá. Eles caíram no chão diante dele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph disse-lhes: “Que ação é essa que vocês fizeram? Você não sabe que um homem como eu pode realmente fazer adivinhações?”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah disse: “O que diremos a meu senhor? O que diremos? Como vamos nos esclarecer? Deus descobriu a iniqüidade de seus servos. Eis que somos escravos de meu senhor, tanto nós quanto ele, em cuja mão se encontra o cálice”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ele disse: “Longe de mim que eu deva fazer isso”. O homem em cuja mão o copo é encontrado, ele será meu escravo; mas quanto a você, suba em paz para seu pai”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Então Judah aproximou-se dele e disse: “Oh, meu senhor, por favor, deixe seu servo falar uma palavra aos ouvidos de meu senhor, e não deixe sua raiva arder contra seu servo; pois você é até mesmo como Faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Meu senhor perguntou a seus servos, dizendo: “Você tem um pai, ou um irmão? ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Dissemos a meu senhor: “Temos um pai, um homem velho, e um filho de sua velhice, um pequeno; e seu irmão está morto, e só ele é deixado de sua mãe; e seu pai o ama”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Você disse a seus servos: 'Tragam-no até mim, para que eu possa colocar meus olhos sobre ele'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Dissemos a meu senhor: 'O menino não pode deixar seu pai, pois se ele deixasse seu pai, seu pai morreria'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Você disse a seus servos: 'A menos que seu irmão mais novo desça com você, você não verá mais meu rosto'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Quando chegamos a seu servo meu pai, dissemos-lhe as palavras de meu senhor. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Nosso pai disse: 'Vá novamente e compre um pouco de comida para nós'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Dissemos: 'Não podemos descer'. Se nosso irmão mais novo estiver conosco, então desceremos: pois podemos não ver o rosto do homem, a menos que nosso irmão mais novo esteja conosco”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Seu servo, meu pai, nos disse: 'Você sabe que minha mulher me deu dois filhos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Um saiu de mim, e eu disse: “Certamente ele está em pedaços”; e não o vi desde então. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","If você tira este também de mim, e o mal lhe acontece, você trará para baixo meus cabelos grisalhos com tristeza ao Sheol”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Agora, portanto, quando eu for ao seu servo meu pai, e o menino não estiver conosco; já que sua vida está ligada à vida do menino; ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","acontecerá, quando ele vir que o menino não está mais, que ele vai morrer. Seus servos farão cair os cabelos grisalhos de seu servo, nosso pai, com tristeza ao Sheol. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Pois seu servo tornou-se garantia para o menino para meu pai, dizendo: 'Se eu não o trouxer até você, então eu arcarei com a culpa para meu pai para sempre'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Agora, portanto, por favor, deixe seu servo ficar no lugar do menino, escravo de meu senhor; e deixe o menino subir com seus irmãos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Pois como subirei com meu pai, se o menino não estiver comigo... para que não veja o mal que virá sobre meu pai”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Então Joseph não conseguiu se controlar diante de todos aqueles que estavam diante dele, e ele gritou: “Porque todos saiam de mim”! Ninguém mais ficou com ele, enquanto Joseph se deu a conhecer a seus irmãos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ele chorou em voz alta. Os egípcios ouviram, e a casa do faraó ouviu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph disse a seus irmãos: “Eu sou Joseph! Meu pai ainda vive?”. Seus irmãos não puderam responder-lhe, pois estavam aterrorizados com sua presença. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Joseph disse a seus irmãos: “Aproximem-se de mim, por favor”. Eles se aproximaram. Ele disse: “Eu sou José, seu irmão, a quem você vendeu para o Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Agora não fiquem contristados, nem zangados com vocês mesmos, por me terem vendido aqui, pois Deus me enviou antes de vocês para preservar a vida. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Durante estes dois anos a fome tem estado na terra, e ainda há cinco anos, nos quais não haverá arado nem colheita. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Deus me enviou antes de você para preservar para você um remanescente na terra, e para salvá-lo vivo por uma grande libertação. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Então agora não foi você quem me enviou aqui, mas Deus, e Ele me fez um pai para o Faraó, senhor de toda sua casa, e governante de toda a terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Apresse-se, e vá até meu pai, e diga-lhe: 'Isto é o que seu filho José diz: “Deus me fez senhor de todo o Egito”. Desça até mim”. Não espere. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Habitarás na terra de Gósen, e estarás perto de mim, tu, teus filhos, os filhos de teus filhos, teus rebanhos, teus rebanhos, e tudo o que tens. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Lá eu te proverei; pois ainda há cinco anos de fome; para que não venhas à pobreza, tu e tua casa, e tudo o que tens”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Eis que teus olhos vêem, e os olhos de meu irmão Benjamin, que é minha boca que fala contigo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Diga a meu pai toda a minha glória no Egito, e tudo o que você viu. Apresse-se e traga meu pai para cá”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ele caiu sobre o pescoço de seu irmão Benjamin e chorou, e Benjamin chorou sobre seu pescoço. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ele beijou todos os seus irmãos e chorou sobre eles. Depois disso, seus irmãos conversaram com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","O relatório foi ouvido na casa do faraó, dizendo: “Os irmãos de José vieram”. Agradou bem ao faraó e a seus servos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","O Faraó disse a Joseph: “Diga a seus irmãos: 'Façam isso: Carreguem seus animais, e vão, viajem para a terra de Canaã. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Pegue seu pai e suas famílias, e venha até mim, e eu lhe darei o bem da terra do Egito, e você comerá a gordura da terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Agora você está ordenado a fazer isso: Tire as carroças da terra do Egito para seus pequenos, e para suas esposas, e traga seu pai, e venha. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Também, não se preocupem com seus pertences, pois o bem de toda a terra do Egito é seu”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Os filhos de Israel o fizeram. José lhes deu carroças, de acordo com o mandamento do Faraó, e lhes deu provisões para o caminho. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ele deu a cada um deles trocas de roupa, mas a Benjamim ele deu trezentas moedas de prata e cinco trocas de roupa. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ele enviou o seguinte a seu pai: dez burros carregados com as coisas boas do Egito, e dez burras carregadas com grãos e pão e provisões para seu pai, a propósito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Então ele mandou seus irmãos embora, e eles partiram. Ele lhes disse: “Vejam se não brigam pelo caminho”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Saíram do Egito, e entraram na terra de Canaã, para Jacó, seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Eles lhe disseram, dizendo: “José ainda está vivo, e ele é o governante de toda a terra do Egito”. Seu coração desmaiou, pois ele não acreditava neles. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Contaram-lhe todas as palavras de José, que ele havia dito a eles. Quando ele viu as carroças que José havia enviado para carregá-lo, o espírito de Jacó, o pai deles, reviveu. ");
INSERT INTO porbrbsl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israel disse: “É suficiente. José, meu filho, ainda está vivo. Eu irei vê-lo antes de morrer”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israel viajou com tudo o que tinha, e veio a Beersheba, e ofereceu sacrifícios ao Deus de seu pai, Isaac. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Deus falou a Israel nas visões da noite, e disse: “Jacó, Jacó! Ele disse: “Aqui estou eu”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ele disse: “Eu sou Deus, o Deus de seu pai”. Não tenha medo de descer ao Egito, pois lá eu farei de você uma grande nação”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Eu descerei com vocês no Egito. Certamente também o trarei novamente para cima. A mão de José fechará seus olhos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jacó se levantou de Berseba, e os filhos de Israel carregaram Jacó, seu pai, seus pequenos e suas esposas, nos vagões que o Faraó havia enviado para carregá-lo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Levaram seu gado e seus bens, que haviam conseguido na terra de Canaã, e entraram no Egito-Jacob e toda sua descendência com ele, ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","seus filhos, e os filhos de seus filhos com ele, suas filhas e as filhas de seus filhos, e ele trouxe toda sua descendência com ele para o Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Estes são os nomes dos filhos de Israel, que vieram para o Egito, Jacó e seus filhos: Reuben, o primogênito de Jacó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Os filhos de Rúben: Hanoch, Pallu, Hezron e Carmi. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Os filhos de Simeão: Jemuel, Jamin, Ohad, Jachin, Zohar, e Shaul, filho de uma mulher cananéia. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Os filhos de Levi: Gershon, Kohath, e Merari. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Os filhos de Judá: Er, Onan, Shelah, Perez e Zerah; mas Er e Onan morreram na terra de Canaã. Os filhos de Perez eram Hezron e Hamul. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Os filhos de Issachar: Tola, Puvah, Iob, e Shimron. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Os filhos de Zebulun: Sered, Elon, e Jahleel. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Estes são os filhos de Leah, que ela levou a Jacob em Paddan Aram, com sua filha Dinah. Todas as almas de seus filhos e de suas filhas eram trinta e três. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Os filhos de Gad: Ziphion, Haggi, Shuni, Ezbon, Eri, Arodi, e Areli. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Os filhos de Asher: Imnah, Ishvah, Ishvi, Beriah, e Serah, sua irmã. Os filhos de Beriah: Heber e Malchiel. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Estes são os filhos de Zilpah, que Laban deu a Leah, sua filha, e estes ela deu a Jacob, até mesmo dezesseis almas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Os filhos de Raquel, a esposa de Jacó: José e Benjamim. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","A José na terra do Egito nasceram Manassés e Efraim, que Asenath, filha de Potiphera, sacerdote de On, lhe deu à luz. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Os filhos de Benjamin: Bela, Becher, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim e Ard. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Estes são os filhos de Raquel, que nasceram de Jacob: todas as almas eram catorze. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","O filho de Dan: Hushim. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Os filhos de Naftali: Jahzeel, Guni, Jezer, e Shillem. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Estes são os filhos de Bilhah, que Laban deu a Raquel, sua filha, e estes ela deu a Jacó: todas as almas eram sete. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Todas as almas que vieram com Jacó para o Egito, que foram sua descendência direta, além das esposas dos filhos de Jacó, todas as almas eram sessenta e seis. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Os filhos de José, que nasceram para ele no Egito, eram duas almas. Todas as almas da casa de Jacó, que entraram no Egito, eram setenta. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacó enviou Judá antes dele para José, para mostrar o caminho diante dele para Gósen, e eles vieram para a terra de Gósen. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","José preparou sua carruagem, e subiu ao encontro de Israel, seu pai, em Gósen. Apresentou-se a ele, caiu sobre seu pescoço e chorou um bom tempo no pescoço. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel disse a José: “Agora deixe-me morrer, já que vi seu rosto, que você ainda está vivo”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph disse a seus irmãos, e à casa de seu pai: “Subirei, e falarei com o Faraó, e lhe direi: 'Meus irmãos, e a casa de meu pai, que estavam na terra de Canaã, vieram até mim'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Estes homens são pastores, pois foram criadores de gado, e trouxeram seus rebanhos, e seus rebanhos, e tudo o que eles têm”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Acontecerá, quando o Faraó o convocar, e dirá: “Qual é a sua ocupação? ");
INSERT INTO porbrbsl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","que você dirá: 'Seus servos têm sido criadores de gado desde nossa juventude até agora, tanto nós como nossos pais:' para que você possa habitar na terra de Gósen; pois cada pastor é uma abominação para os egípcios'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Então José entrou e disse ao Faraó: “Meu pai e meus irmãos, com seus rebanhos, seus rebanhos e tudo o que possuem, saíram da terra de Canaã; e eis que estão na terra de Gósen”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","De entre seus irmãos, ele pegou cinco homens e os apresentou ao Faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","O Faraó disse a seus irmãos: “Qual é sua ocupação?”. Eles disseram ao Faraó: “Seus servos são pastores, tanto nós quanto nossos pais”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Eles também disseram ao Faraó: “Viemos para viver como estrangeiros na terra, pois não há pasto para os rebanhos de seus servos. Pois a fome é severa na terra de Canaã. Agora, portanto, por favor, deixem seus servos morar na terra de Gósen”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","O Faraó falou com José, dizendo: “Seu pai e seus irmãos vieram até você”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","A terra do Egito está diante de você. Faça seu pai e seus irmãos habitarem no melhor da terra. Deixe-os habitar na terra de Gósen. Se você conhece algum homem capaz entre eles, então coloque-os a cargo do meu gado”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","José trouxe Jacó, seu pai, e o colocou diante do faraó; e Jacó abençoou o faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","O Faraó disse a Jacó: “Quantos anos você tem?” ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob disse ao faraó: “Os anos da minha peregrinação são cento e trinta anos. Os dias dos anos da minha vida têm sido poucos e maus. Eles não chegaram aos dias dos anos da vida de meus pais nos dias de sua peregrinação”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jacob abençoou o faraó e saiu da presença do faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","José colocou seu pai e seus irmãos, e lhes deu uma posse na terra do Egito, no melhor da terra, na terra de Ramsés, como o faraó havia ordenado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","José forneceu pão a seu pai, a seus irmãos e a toda a família de seu pai, de acordo com o tamanho de suas famílias. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Não havia pão em toda a terra; pois a fome era muito severa, de modo que a terra do Egito e a terra de Canaã desmaiaram por causa da fome. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","José reuniu todo o dinheiro que foi encontrado na terra do Egito, e na terra de Canaã, para o grão que compraram: e José trouxe o dinheiro para a casa do faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Quando o dinheiro foi todo gasto na terra do Egito, e na terra de Canaã, todos os egípcios vieram até José, e disseram: “Dai-nos pão, pois por que morreremos na vossa presença? Porque nosso dinheiro falha”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseph disse: “Dê-me seu gado; e eu lhe darei comida para seu gado, se seu dinheiro tiver desaparecido”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Eles trouxeram seu gado para José, e José lhes deu pão em troca dos cavalos, dos rebanhos, dos rebanhos e dos burros: e ele os alimentou com pão em troca de todo o seu gado para aquele ano. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Quando aquele ano terminou, eles vieram até ele no segundo ano e lhe disseram: “Não esconderemos de meu senhor como nosso dinheiro é gasto, e os rebanhos de gado são de meu senhor”. Não sobra nada aos olhos de meu senhor, a não ser nossos corpos e nossas terras. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Por que devemos morrer diante de seus olhos, tanto nós quanto nossa terra? Comprem-nos e nossa terra por pão, e nós e nossa terra seremos servos do faraó. Dai-nos semente, para que possamos viver, e não morrer, e para que a terra não seja desolada”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Então José comprou toda a terra do Egito para o Faraó, para cada homem dos egípcios vendeu seu campo, porque a fome era severa sobre eles, e a terra tornou-se do Faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Quanto ao povo, ele os mudou para as cidades de um extremo da fronteira do Egito até mesmo para o outro extremo dele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Somente ele não comprou a terra dos sacerdotes, pois os sacerdotes tinham uma porção do Faraó, e comeram sua porção que o Faraó lhes deu. É por isso que eles não venderam suas terras. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Então José disse ao povo: “Eis que hoje eu comprei você e sua terra para o Faraó. Eis que aqui está a semente para vós, e semeareis a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Acontecerá nas colheitas, que você dará um quinto ao Faraó, e quatro partes serão suas, para a semente do campo, para seu alimento, para eles de suas casas, e para o alimento de seus pequenos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Eles disseram: “Vocês salvaram nossas vidas! Encontremos favor aos olhos de meu senhor, e seremos servos do Faraó”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Joseph fez um estatuto relativo à terra do Egito até hoje, que o Faraó deveria ter o quinto. Somente a terra dos sacerdotes não se tornou a terra do faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel viveu na terra do Egito, na terra de Gósen; e aí adquiriram posses, foram frutíferas e se multiplicaram excessivamente. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacó viveu na terra do Egito dezessete anos. Assim, os dias de Jacó, os anos de sua vida, foram cento e quarenta e sete anos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Chegou a hora de Israel morrer, e ele chamou seu filho José, e lhe disse: “Se agora eu encontrei favor a seus olhos, por favor ponha sua mão debaixo da minha coxa, e lide com gentileza e verdade comigo”. Por favor, não me enterre no Egito, ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","mas quando eu dormir com meus pais, você me levará para fora do Egito, e me enterrará em seu lugar de sepultamento”. Joseph disse: “Farei como você disse”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Israel disse: “Jure para mim”, e ele jurou-lhe. Então Israel se curvou sobre a cabeça da cama. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Depois destas coisas, alguém disse a Joseph: “Eis que seu pai está doente”. Ele levou consigo seus dois filhos, Manasseh e Ephraim. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Someone disse a Jacó, e disse: “Eis que seu filho José vem a você”, e Israel se fortaleceu, e sentou-se na cama. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacó disse a José: “Deus Todo-Poderoso me apareceu na Luz, na terra de Canaã, e me abençoou, ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","e me disse: 'Eis que te farei frutificar e te multiplicarei, e farei de ti uma companhia de povos, e darei esta terra aos teus descendentes, depois de ti, para uma possessão eterna'. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Agora seus dois filhos, que nasceram para você na terra do Egito antes que eu viesse para você no Egito, são meus; Efraim e Manassés, mesmo como Rúben e Simeão, serão meus. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Sua descendência, da qual você se tornará o pai depois deles, será sua. Eles serão chamados segundo o nome de seus irmãos em sua herança. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Quanto a mim, quando vim de Paddan, Rachel morreu ao meu lado na terra de Canaã no caminho, quando ainda havia alguma distância para chegar a Éfrata, e eu a enterrei lá no caminho de Éfrata (também chamada Belém)”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israel viu os filhos de José, e disse: “Quem são estes?”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph disse a seu pai: “Eles são meus filhos, que Deus me deu aqui”. Ele disse: “Por favor, traga-os até mim, e eu os abençoarei”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Now os olhos de Israel estavam escuros para a idade, de modo que ele não conseguia ver bem. José os trouxe para perto dele; e os beijou e os abraçou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel disse a José: “Eu não pensava ver seu rosto, e eis que Deus me deixou ver também sua prole”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","José os tirou de entre seus joelhos, e se curvou com seu rosto à terra. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","José pegou os dois, Efraim em sua mão direita em direção à mão esquerda de Israel, e Manassés em sua mão esquerda em direção à mão direita de Israel, e os trouxe para perto dele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israel estendeu sua mão direita e a colocou sobre a cabeça de Efraim, que era o mais jovem, e sua mão esquerda sobre a cabeça de Manassés, guiando suas mãos conscientemente, pois Manassés era o primogênito. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ele abençoou José, e disse, “O Deus diante do qual caminharam meus pais Abraão e Isaac”, o Deus que me alimentou durante toda a minha vida até os dias de hoje, ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","o anjo que me redimiu de todo o mal, abençoe os rapazes, e deixar que meu nome seja mencionado neles, e o nome de meus pais Abraão e Isaac. Deixe-os crescer em uma multidão sobre a terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Quando Joseph viu que seu pai colocou sua mão direita sobre a cabeça de Efraim, isso o desagradou. Ele levantou a mão de seu pai, para retirá-la da cabeça de Efraim para a cabeça de Manasseh. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Joseph disse a seu pai: “Não é assim, meu pai, pois este é o primogênito”. Ponha sua mão direita sobre a cabeça dele”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Seu pai recusou, e disse: “Eu sei, meu filho, eu sei”. Ele também se tornará um povo, e ele também será grande. Entretanto, seu irmão mais novo será maior que ele, e sua prole se tornará uma multidão de nações”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ele os abençoou naquele dia, dizendo: “Israel abençoará em você, dizendo: 'Deus o faça como Efraim e como Manassés'”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Israel disse a José: “Eis que estou morrendo, mas Deus estará contigo, e te levará novamente à terra de teus pais”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Moreover Eu vos dei uma parte acima de vossos irmãos, que tirei da mão do amorreu com minha espada e com meu arco”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob chamou seus filhos, e disse: “Reúnam-se, para que eu possa dizer-lhes o que lhes acontecerá nos próximos dias”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Reúnam-se, e ouçam, filhos de Jacob. Ouça Israel, seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Reuben, você é meu primogênito, minha força e o começo de minha força, Excesso de dignidade e excitação no poder. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Boiling como a água, você não deve se sobressair, porque você foi para a cama do seu pai, depois a sujou. Ele foi até o meu sofá. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon e Levi são irmãos. Suas espadas são armas de violência. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Minha alma, não venha ao conselho deles. Minha glória, não se unam à sua assembléia; pois em sua raiva mataram homens. Em sua vontade própria, eles manietaram o gado. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Amaldiçoada seja a raiva deles, pois foi feroz; e sua ira, pois foi cruel. Vou dividi-los em Jacob, e os espalhe em Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Judah, seus irmãos o elogiarão. Sua mão estará sobre o pescoço de seus inimigos. Os filhos de seu pai se curvarão diante de você. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah é uma cria de leão. Da presa, meu filho, você subiu. Ele abaixou-se, agachou-se como um leão, como uma leoa. Quem o despertará? ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","O ceptro não se afastará de Judá, nem o bastão do governante entre seus pés, até que ele venha a quem pertence. A obediência dos povos será para ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ligando seu potro à videira, o potro de seu burro para a videira escolhida, ele lavou suas peças de vestuário em vinho, suas vestes no sangue das uvas. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Seus olhos ficarão vermelhos com vinho, seus dentes brancos com leite. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebulun habitará no paraíso do mar. Ele será para um refúgio de navios. Sua fronteira será em Sidon. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Issachar é um burro forte, deitado entre os alforges. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ele viu um lugar de descanso, que era bom, a terra, que era agradável. Ele se curva ao peso do peso, e se torna um servo fazendo trabalhos forçados. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan irá julgar seu povo, como uma das tribos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan será uma serpente na trilha, uma víbora no caminho, que morde os calcanhares do cavalo, para que seu cavaleiro caia para trás. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Esperei por sua salvação, Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Uma tropa vai pressionar o Gad, mas ele vai pressionar o calcanhar deles. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“A comida do Asher será rica. Ele produzirá delicadezas reais. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali é uma corça libertada, que carrega belos peões. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Joseph é uma videira frutífera, uma videira frutífera por uma fonte. Seus ramos correm sobre a parede. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","The os arqueiros o entristeceram gravemente, atirou nele, e o perseguiu: ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mas seu arco permaneceu forte. Os braços de suas mãos foram tornados fortes, pelas mãos do Poderoso de Jacob, (de lá é o pastor, a pedra de Israel), ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","mesmo pelo Deus de seu pai, que o ajudará, pelo Todo-Poderoso, que o abençoará, com as bênçãos do céu acima, bênçãos das profundezas que se encontram abaixo, bênçãos dos seios, e do útero. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","As bênçãos de seu pai prevaleceram sobre as bênçãos de meus antepassados, acima dos limites das colinas antigas. Eles ficarão na cabeça de José, sobre a coroa da cabeça daquele que está separado de seus irmãos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin é um lobo esfomeado. Pela manhã, ele devorará a presa. À noite, ele dividirá o saque”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Todas estas são as doze tribos de Israel, e foi isto que seu pai lhes falou, e os abençoou. Ele abençoou a todos de acordo com sua própria bênção. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ele os instruiu e lhes disse: “Vou ser reunido ao meu povo”. Enterrem-me com meus pais na caverna que está no campo de Efron, o hitita, ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","na caverna que está no campo de Machpelah, que está antes de Mamre, na terra de Canaã, que Abraão comprou com o campo de Efron, o hitita, como local de sepultamento. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ali enterraram Abraão e Sara, sua esposa. Ali enterraram Isaac e Rebekah, sua esposa, e ali enterrei Leah: ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","o campo e a caverna que lá se encontra, que foi comprada dos filhos de Heth”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Quando Jacó terminou de carregar seus filhos, ele levantou os pés na cama, deu seu último suspiro e foi reunido ao seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Joseph caiu no rosto de seu pai, chorou sobre ele, e o beijou. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","José ordenou a seus servos, os médicos, que embalsamassem seu pai; e os médicos embalsamaram Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Quarenta dias foram usados para ele, pois é o número de dias que leva para embalsamar. Os egípcios choraram por Israel durante setenta dias. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Quando os dias de choro por ele passaram, José falou ao pessoal do Faraó, dizendo: “Se agora eu encontrei favor em seus olhos, por favor fale aos ouvidos do Faraó, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","'Meu pai me fez jurar, dizendo: “Eis que estou morrendo”. Enterrai-me na minha sepultura que cavei para mim mesmo na terra de Canaã”. Agora, portanto, por favor, deixe-me subir e enterrar meu pai, e eu virei novamente”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","O Faraó disse: “Sobe e enterra teu pai, como ele te fez jurar”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","José subiu para enterrar seu pai; e com ele subiram todos os servos do Faraó, os anciãos de sua casa, todos os anciãos da terra do Egito, ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","toda a casa de José, seus irmãos, e a casa de seu pai. Somente seus pequeninos, seus rebanhos e seus rebanhos, eles partiram para a terra de Gósen. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Tanto as carruagens como os cavaleiros subiram com ele. Foi uma grande companhia. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Eles chegaram à eira de Atad, que fica além do Jordão, e lá lamentaram com uma lamentação muito grande e severa. Ele lamentou por seu pai durante sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Quando os habitantes da terra, os cananeus, viram o luto no chão de Atad, disseram: “Este é um luto doloroso por parte dos egípcios”. Por isso seu nome foi chamado Abel Mizraim, que está além do Jordão. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Seus filhos lhe fizeram exatamente como ele lhes ordenou, ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","pois seus filhos o levaram para a terra de Canaã, e o enterraram na caverna do campo de Macpela, que Abraão comprou com o campo, como posse para um local de sepultamento, de Efron, o hitita, perto de Mamre. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","José voltou ao Egito - ele e seus irmãos, e tudo o que subiu com ele para enterrar seu pai, depois que ele havia enterrado seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Quando os irmãos de Joseph viram que seu pai estava morto, eles disseram: “Pode ser que Joseph nos odeie, e nos pague integralmente por todo o mal que lhe fizemos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Eles enviaram uma mensagem a Joseph, dizendo: “Seu pai ordenou antes de morrer, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","'Você deve dizer a Joseph: “Agora, por favor, perdoe a desobediência de seus irmãos, e o pecado deles, porque eles lhe fizeram o mal”. Agora, por favor, perdoe a desobediência dos servos do Deus de seu pai”. José chorou quando eles falaram com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Seus irmãos também foram e caíram diante de seu rosto; e eles disseram: “Eis que somos teus servos”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Joseph disse-lhes: “Não tenham medo, pois estou no lugar de Deus? ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Quanto a vocês, quiseram dizer mal contra mim, mas Deus o quis dizer para o bem, para salvar muitas pessoas vivas, como está acontecendo hoje. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Agora, portanto, não tenha medo. Eu proverei para você e seus pequenos”. Ele os consolou e falou gentilmente com eles. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph viveu no Egito, ele e a casa de seu pai. José viveu cem e dez anos. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joseph viu os filhos de Efraim até a terceira geração. Os filhos também de Machir, o filho de Manasseh, nasceram de joelhos de José. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","José disse a seus irmãos: “Estou morrendo, mas Deus certamente vos visitará e vos fará subir desta terra para a terra que ele jurou a Abraão, a Isaac, e a Jacó”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","José fez um juramento dos filhos de Israel, dizendo: “Deus certamente vos visitará, e vós levareis meus ossos daqui para cima”. ");
INSERT INTO porbrbsl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Então José morreu, tendo cem e dez anos de idade, e eles o embalsamaram, e foi colocado em um caixão no Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Agora estes são os nomes dos filhos de Israel, que vieram ao Egito (cada homem e sua família vieram com Jacó): ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeão, Levi e Judá, ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulun e Benjamin, ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan e Naftali, Gad e Asher. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Todas as almas que saíram do corpo de Jacó eram setenta almas, e José já estava no Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","José morreu, assim como todos os seus irmãos, e toda aquela geração. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Os filhos de Israel foram fecundos, e aumentaram abundantemente, e se multiplicaram, e cresceram excessivamente poderosos; e a terra se encheu deles. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Agora surgiu um novo rei sobre o Egito, que não conhecia José. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ele disse ao seu povo: “Eis que o povo dos filhos de Israel é mais e mais poderoso do que nós”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Venha, vamos lidar sabiamente com eles, para que não se multipliquem, e acontece que quando alguma guerra eclode, eles também se unem a nossos inimigos e lutam contra nós, e escapam da terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Por isso, eles colocam os encarregados sobre eles para afligi-los com seus fardos. Eles construíram cidades de armazenamento para o Faraó: Pithom e Raamses. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mas quanto mais eles os afligiam, mais se multiplicavam e mais se espalhavam. Eles começaram a temer os filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Os egípcios impiedosamente fizeram os filhos de Israel servir, ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","e tornaram suas vidas amargas com serviço duro em argamassa e em tijolos, e em todos os tipos de serviço no campo, todo o seu serviço, no qual impiedosamente os fizeram servir. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","O rei do Egito falou às parteiras hebraicas, das quais o nome de uma era Shiphrah, e o nome da outra Puah, ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","e ele disse: “Quando você cumprir o dever de uma parteira para com as mulheres hebraicas, e vê-las no banco de nascimento, se for um filho, então você o matará; mas se for uma filha, então ela viverá”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mas as parteiras temiam a Deus, e não fizeram o que o rei do Egito lhes ordenou, mas salvaram os meninos bebês vivos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","O rei do Egito chamou as parteiras e disse-lhes: “Por que vocês fizeram isso e salvaram os meninos vivos?”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","As parteiras disseram ao faraó: “Porque as mulheres hebraicas não são como as mulheres egípcias; pois elas são vigorosas e dão à luz antes que a parteira chegue até elas”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Deus lidou bem com as parteiras, e o povo se multiplicou, e cresceu muito poderoso. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Como as parteiras temiam a Deus, Ele lhes deu famílias. ");
INSERT INTO porbrbsl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","O Faraó ordenou a todo seu povo, dizendo: “Lançareis no rio todo filho que nascer, e toda filha salvareis com vida”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Um homem da casa de Levi foi e levou uma filha de Levi como sua esposa. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","A mulher concebeu e deu à luz um filho. Quando ela viu que ele era uma boa criança, ela o escondeu três meses. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Quando não podia mais escondê-lo, ela pegou uma cesta de papiro para ele, e a revestiu com alcatrão e com breu. Ela colocou a criança dentro dela, e a colocou nos canaviais junto à margem do rio. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Sua irmã ficou muito longe, para ver o que seria feito com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","A filha do faraó desceu para banhar-se no rio. Suas donzelas caminharam ao longo da margem do rio. Ela viu a cesta entre os canaviais e mandou seu criado buscá-la. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","She abriu-a e viu a criança, e eis que o bebê chorou. Ela teve compaixão dele, e disse: “Este é um dos filhos dos hebreus”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Então sua irmã disse à filha do faraó: “Devo ir chamar uma enfermeira para você das mulheres hebraicas, para que ela possa cuidar da criança para você?”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","A filha do faraó lhe disse: “Vá”. A jovem mulher foi e chamou a mãe da criança. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","A filha do faraó lhe disse: “Leve esta criança embora e cuide dele por mim, e eu lhe darei seu salário”. A mulher pegou a criança e cuidou dela. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","A criança cresceu, e ela o trouxe para a filha do Faraó, e ele se tornou seu filho. Ela o chamou de Moisés, e disse: “Porque eu o tirei da água”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Naqueles dias, quando Moisés tinha crescido, ele foi até seus irmãos e viu os fardos deles. Ele viu um egípcio atacando um hebreu, um de seus irmãos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ele olhou para este e para aquele lado, e quando viu que não havia ninguém, matou o egípcio, e o escondeu na areia. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ele saiu no segundo dia, e eis que dois homens dos hebreus estavam brigando um com o outro. Ele disse a ele que fez o mal: “Por que você bate no seu companheiro”? ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ele disse: “Quem fez de você um príncipe e um juiz sobre nós? Você planeja me matar, como você matou o egípcio?” Moisés estava com medo e disse: “Certamente esta coisa é conhecida”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Agora, quando o Faraó ouviu esta coisa, ele procurou matar Moisés. Mas Moisés fugiu da face do faraó, e viveu na terra de Midian, e sentou-se junto a um poço. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Agora o padre de Midian tinha sete filhas. Elas vinham e bebiam água, e enchiam os bebedouros para regar o rebanho de seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Os pastores vieram e as expulsaram; mas Moisés se levantou e as ajudou, e regou seu rebanho. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Quando chegaram a Reuel, seu pai, ele disse: “Como é que vocês voltaram tão cedo hoje”? ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Eles disseram: “Um egípcio nos entregou da mão dos pastores e, além disso, tirou água para nós, e regou o rebanho”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ele disse a suas filhas: “Onde ele está? Por que o senhor deixou o homem? Chame-o, para que ele possa comer pão”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moisés contentou-se em morar com o homem. Ele deu a Moisés Zipporah, sua filha. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ela teve um filho, e ele o chamou de Gershom, pois ele disse: “Eu vivi como estrangeiro em uma terra estrangeira”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Durante esses muitos dias, o rei do Egito morreu, e os filhos de Israel suspiravam por causa da escravidão, e eles choravam, e seu grito chegou a Deus por causa da escravidão. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Deus ouviu seus gemidos, e Deus lembrou-se de sua aliança com Abraão, com Isaac e com Jacó. ");
INSERT INTO porbrbsl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Deus viu os filhos de Israel, e Deus compreendeu. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Agora Moisés estava mantendo o rebanho de Jetro, seu sogro, o sacerdote de Midian, e conduziu o rebanho para o fundo do deserto, e veio para a montanha de Deus, para Horebe. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","O anjo de Javé apareceu-lhe em uma chama de fogo do meio de um arbusto. Ele olhou, e eis que o arbusto ardeu com fogo, e o arbusto não foi consumido. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moisés disse: “Eu vou agora, e verei esta grande visão, porque o arbusto não está queimado”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Quando Javé viu que ele veio ver, Deus o chamou do meio do mato e disse: “Moisés! Moisés!”. Ele disse: “Aqui estou eu”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ele disse: “Não chegue perto. Tire suas sandálias, pois o lugar em que você está de pé é terra sagrada”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Moreover ele disse: “Eu sou o Deus de seu pai, o Deus de Abraão, o Deus de Isaac, e o Deus de Jacó”. Moisés escondeu seu rosto porque tinha medo de olhar para Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yahweh disse: “Eu certamente vi a aflição de meu povo que está no Egito, e ouvi seu grito por causa de seus mestres, pois eu conheço suas tristezas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Desci para libertá-los da mão dos egípcios, e para trazê-los para fora daquela terra para uma terra boa e grande, para uma terra que flui com leite e mel; para o lugar do cananeu, do hitita, do amorreu, do perizeu, do hivita, e do jebuseu. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Agora, eis que o grito dos filhos de Israel chegou até mim. Além disso, vi a opressão com que os egípcios os oprimem. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Vinde agora, portanto, e eu vos enviarei ao Faraó, para que tireis meu povo, os filhos de Israel, do Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moisés disse a Deus: “Quem sou eu, que devo ir ao Faraó, e que devo tirar os filhos de Israel do Egito”? ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ele disse: “Certamente eu estarei com você”. Este será o sinal para você, que eu lhe enviei: quando você tiver trazido o povo para fora do Egito, você servirá a Deus nesta montanha”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moisés disse a Deus: “Eis que, quando eu for ter com os filhos de Israel e lhes disser: 'O Deus de vossos pais me enviou a vós', e eles me perguntarem: 'Qual é o seu nome?' o que devo dizer-lhes? ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Deus disse a Moisés: “EU SOU QUEM SOU”, e ele disse: “Diga isto aos filhos de Israel”: EU SOU me enviou a vocês””. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Deus disse ainda mais a Moisés: “Dirás isto aos filhos de Israel: 'Javé, o Deus de teus pais, o Deus de Abraão, o Deus de Isaac e o Deus de Jacó, me enviou a ti'. Este é meu nome para sempre, e este é o meu memorial para todas as gerações. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ide reunir os anciãos de Israel e dizei-lhes: 'Javé, o Deus de vossos pais, o Deus de Abraão, de Isaac e de Jacó, me apareceu, dizendo: “Certamente vos visitei e vi o que vos foi feito no Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Eu disse: “Eu vos tirarei da aflição do Egito para a terra do cananeu, do hitita, do amorreu, do perizeu, do hivita e do jebuseu, para uma terra que flui com leite e mel””. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Eles ouvirão a sua voz. Virão, você e os anciãos de Israel, ao rei do Egito, e lhe dirão: 'Javé, o Deus dos hebreus, se encontrou conosco'. Agora, por favor, deixe-nos ir três dias de viagem ao deserto, para que possamos sacrificar a Javé, nosso Deus”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Eu sei que o rei do Egito não lhe dará permissão para ir, não, não por uma mão poderosa. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Estenderei minha mão e atingirei o Egito com todas as minhas maravilhas que farei entre eles, e depois disso ele o deixará ir. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Darei a este povo um favor aos olhos dos egípcios, e acontecerá que quando você for, não irá de mãos vazias. ");
INSERT INTO porbrbsl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Mas toda mulher deverá pedir ao seu próximo, e àquele que visitar sua casa, jóias de prata, jóias de ouro e roupas. Você as colocará em seus filhos, e em suas filhas. Pilhareis os egípcios”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moisés respondeu: “Mas eis que eles não acreditarão em mim, nem ouvirão minha voz, pois dirão: 'Javé não vos apareceu'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yahweh disse-lhe: “O que é isso em sua mão?” Ele disse: “Uma vara”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ele disse: “Jogue-o no chão”. Ele jogou-a no chão, e ela se tornou uma cobra; e Moisés fugiu dela. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yahweh disse a Moisés: “Estenda sua mão e pegue-a pela cauda”. Ele estendeu sua mão, pegou-a e se tornou um bastão em sua mão. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Isto é para que eles possam acreditar que Javé, o Deus de seus pais, o Deus de Abraão, o Deus de Isaac, e o Deus de Jacó, apareceu a você”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Yahweh disse-lhe ainda: “Agora ponha sua mão dentro de seu manto”. Ele colocou sua mão dentro do manto, e quando a tirou, eis que sua mão era leprosa, branca como a neve. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ele disse: “Coloque sua mão dentro de seu manto de novo”. Ele colocou sua mão dentro de seu manto novamente, e quando o tirou de seu manto, eis que ele tinha voltado novamente como sua outra carne. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Acontecerá, se não acreditarem em você ou não ouvirem a voz do primeiro sinal, que acreditarão na voz do segundo sinal. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","“Acontecerá, se eles não acreditarem nem mesmo nestes dois sinais ou não escutarem sua voz, que você tomará da água do rio, e a derramará sobre a terra seca. A água que vocês retirarem do rio se tornará sangue na terra seca”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moisés disse a Javé: “Ó Senhor, não sou eloqüente, nem antes, nem depois que falastes com vosso servo; pois sou lento de falar e de língua lenta”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yahweh disse a ele: “Quem fez a boca do homem? Ou quem faz um mudo, ou surdo, ou vendo, ou cego? Não sou eu, Yahweh? ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Agora, portanto, vá, e eu estarei com sua boca, e lhe ensinarei o que você deve falar”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moisés disse: “Oh, Senhor, por favor, mande outra pessoa”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","A raiva de Javé queimou contra Moisés, e ele disse: “E Arão, seu irmão, o levita? Eu sei que ele pode falar bem. Além disso, eis que ele está saindo ao seu encontro. Quando ele o vir, ele ficará contente em seu coração. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Você falará com ele, e colocará as palavras em sua boca. Eu estarei com sua boca, e com a boca dele, e lhe ensinarei o que você deve fazer. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ele será seu porta-voz para o povo. Acontecerá que ele será para você uma boca, e você será para ele como Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Tomareis esta vara em vossa mão, com a qual fareis os sinais”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moisés foi e voltou a Jetro, seu sogro, e lhe disse: “Por favor, deixe-me ir e retornar aos meus irmãos que estão no Egito, e ver se eles ainda estão vivos”. Jethro disse a Moisés: “Vá em paz”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Yahweh disse a Moisés em Midian: “Vá, volte ao Egito; pois todos os homens que procuraram sua vida estão mortos”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moisés levou sua esposa e seus filhos, e os colocou em um burro, e voltou para a terra do Egito. Moisés pegou a vara de Deus em sua mão. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yahweh disse a Moisés: “Quando você voltar ao Egito, veja que você faça diante do Faraó todas as maravilhas que coloquei em sua mão, mas eu endurecerei seu coração e ele não deixará o povo ir. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Você dirá ao Faraó: 'Javé diz: Israel é meu filho, meu primogênito, ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","e eu lhe disse: “Deixe meu filho ir, para que ele possa me servir;” e você se recusou a deixá-lo ir. Eis que eu matarei seu primogênito””. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","No caminho em um alojamento, Yahweh conheceu Moisés e quis matá-lo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Então Zipporah pegou uma pedra, cortou o prepúcio de seu filho e o jogou a seus pés; e ela disse: “Certamente você é um noivo de sangue para mim”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Então, ele o deixou em paz. Então ela disse: “Você é um noivo de sangue”, por causa da circuncisão. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yahweh disse a Aaron: “Vá para o deserto para encontrar Moisés”. Ele foi e o encontrou na montanha de Deus, e o beijou. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moisés contou a Arão todas as palavras de Javé com as quais ele o havia enviado e todos os sinais com os quais ele o havia instruído. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moisés e Aarão foram e reuniram todos os anciãos dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Arão falou todas as palavras que Javé havia dito a Moisés, e fez os sinais aos olhos do povo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","O povo acreditou, e quando ouviram que Javé havia visitado os filhos de Israel, e que ele havia visto a aflição deles, então eles curvaram a cabeça e adoraram. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Depois vieram Moisés e Aarão, e disseram ao Faraó: “Isto é o que Javé, o Deus de Israel, diz: 'Deixe o meu povo ir, para que me celebrem um banquete no deserto'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Faraó disse: “Quem é Iavé, que eu deveria ouvir sua voz para deixar Israel ir? Eu não conheço Iavé, e além disso não vou deixar Israel ir”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Eles disseram: “O Deus dos hebreus se reuniu conosco. Por favor, deixe-nos ir três dias de viagem ao deserto, e sacrificar-nos a Javé, nosso Deus, para que ele não caia sobre nós com pestilência, ou com a espada”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","O rei do Egito disse-lhes: “Por que vocês, Moisés e Aarão, tiram o povo de seu trabalho? Voltem aos seus fardos”! ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","O Faraó disse: “Eis que o povo da terra é agora muitos, e vós os fazeis descansar de seus fardos”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","No mesmo dia, o Faraó comandou os encarregados do povo e seus oficiais, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Não darás mais palha ao povo para fazer tijolos, como antes”. Deixe-os ir e recolher a palha para si mesmos”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Você exigirá deles o número dos tijolos que eles fizeram antes. Não diminuirá nada disso, pois eles estão ociosos. Portanto, eles choram, dizendo: “Vamos e sacrifiquemos a nosso Deus”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Que o trabalho mais pesado seja imposto aos homens, para que eles possam trabalhar nele. Não deixe que eles prestem atenção às palavras mentirosas”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Os encarregados do povo saíram com seus oficiais e falaram ao povo, dizendo: “Isto é o que o Faraó diz: 'Não lhe darei palha'. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Go vós mesmos, recebei palha onde puderdes encontrá-la, pois nada do vosso trabalho será diminuído”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Assim, o povo estava espalhado por toda a terra do Egito para colher palha. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Os encarregados da tarefa diziam com urgência: “Cumpram sua quota de trabalho diariamente, como quando havia palha”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Os oficiais das crianças de Israel, que os encarregados do Faraó tinham colocado sobre eles, foram espancados e perguntaram: “Por que você não cumpriu sua cota tanto ontem como hoje, ao fazer tijolos como antes?” ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Então os oficiais das crianças de Israel vieram e gritaram ao Faraó, dizendo: “Por que você lida desta maneira com seus servos? ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Não se dá palha a seus servos, e eles nos dizem: “Façam tijolos!” e eis que seus servos são espancados; mas a culpa está em seu próprio povo”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Mas o Faraó disse: “Você está ocioso! Vocês estão ociosos! Portanto, você diz: “Vamos e sacrifiquemos a Javé”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Go portanto agora, e trabalhai; pois não vos será dada nenhuma palha; contudo, entregareis o mesmo número de tijolos”! ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Os oficiais das crianças de Israel viram que estavam em apuros quando foi dito: “Você não diminuirá nada de sua cota diária de tijolos”! ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Eles encontraram Moisés e Aarão, que ficaram de pé ao longo do caminho, ao saírem do Faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Disseram-lhes: “Que Javé olhe para vocês e julgue, porque vocês nos fizeram um fedor a ser abominado aos olhos do Faraó, e aos olhos de seus servos, para colocar uma espada na mão deles para nos matar”! ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moisés voltou para Yahweh e disse: “Senhor, por que você trouxe problemas a este povo? Por que o Senhor me enviou? ");
INSERT INTO porbrbsl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Pois desde que vim ao faraó para falar em seu nome, ele trouxe problemas a este povo. O Senhor não resgatou seu povo de maneira alguma”! ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yahweh disse a Moisés: “Agora verás o que farei ao Faraó, porque por uma mão forte os deixará ir, e por uma mão forte os expulsará de sua terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Deus falou a Moisés e disse-lhe: “Eu sou Yahweh”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Eu apareci a Abraão, a Isaac e a Jacó, como Deus Todo-Poderoso; mas pelo meu nome Yahweh eu não era conhecido por eles. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Também estabeleci minha aliança com eles, para dar-lhes a terra de Canaã, a terra de suas viagens, na qual eles viveram como estrangeiros. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Além disso, ouvi o gemido dos filhos de Israel, que os egípcios mantêm em cativeiro, e lembrei-me de meu pacto. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Portanto, diga aos filhos de Israel: 'Eu sou Yahweh, e vos tirarei do fardo dos egípcios, e vos livrarei da escravidão deles, e vos redimirei com um braço estendido, e com grandes julgamentos'. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Eu vos levarei para mim mesmo como um povo. Eu serei seu Deus; e você saberá que eu sou Yahweh, seu Deus, que o faz sair de baixo do fardo dos egípcios. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Eu vos levarei para a terra que jurei dar a Abraão, a Isaac e a Jacó; e eu vo-la darei por herança: Eu sou Yahweh”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moisés falou assim com os filhos de Israel, mas eles não ouviram Moisés por angústia de espírito e por uma escravidão cruel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Yahweh falou a Moisés, dizendo, ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Entra, fala ao Faraó, rei do Egito, que ele deixou os filhos de Israel saírem de sua terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moisés falou diante de Javé, dizendo: “Eis que os filhos de Israel não me escutaram. Como então o Faraó me escutará, quando eu tiver lábios incircuncisos”? ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Javé falou a Moisés e a Arão, e deu-lhes uma ordem aos filhos de Israel, e ao Faraó, rei do Egito, para trazer os filhos de Israel para fora da terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Estes são os chefes das casas de seus pais. Os filhos de Rúben, o primogênito de Israel: Hanoch, e Pallu, Hezron e Carmi; estas são as famílias de Reuben. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Os filhos de Simeão: Jemuel, e Jamin, e Ohad, e Jachin, e Zohar, e Shaul, filho de uma mulher cananéia; estas são as famílias de Simeon. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Estes são os nomes dos filhos de Levi, de acordo com suas gerações: Gershon, e Kohath, e Merari; e os anos da vida de Levi foram cento e trinta e sete anos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Os filhos de Gershon: Libni e Shimei, de acordo com suas famílias. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Os filhos de Kohath: Amram, e Izhar, e Hebron, e Uzziel; e os anos da vida de Kohath foram cento e trinta e três anos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Os filhos de Merari: Mahli e Mushi. Estas são as famílias dos Levitas, de acordo com suas gerações. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram levou para si a irmã de seu pai Jochebed como esposa; e ela o deu à luz Aarão e Moisés. Os anos da vida de Amrão foram cento e trinta e sete anos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Os filhos de Izhar: Korah, e Nefegue, e Zichri. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Os filhos de Uzziel: Mishael, Elzaphan, e Sithri. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron tomou Elisheba, filha de Amminadab, irmã de Nahshon, como esposa; e ela lhe deu à luz Nadab e Abihu, Eleazar e Ithamar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Os filhos de Corá: Assir, Elkanah e Abiasaf; estas são as famílias dos coraítas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","O filho de Eleazar Aaron tomou uma das filhas de Putiel como esposa; e ela o deu à luz Phinehas. Estes são os chefes das casas dos pais dos levitas, de acordo com suas famílias. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Estes são aquele Aarão e Moisés a quem Javé disse: “Tragam os filhos de Israel da terra do Egito, de acordo com seus exércitos”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Estes são aqueles que falaram ao Faraó, rei do Egito, para trazer os filhos de Israel do Egito. Estes são aqueles que Moisés e Aarão. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","No dia em que Javé falou a Moisés na terra do Egito, ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Javé disse a Moisés: “Eu sou Javé”. Diga ao Faraó, rei do Egito, tudo o que eu lhe digo”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Moisés disse diante de Javé: “Eis que sou de lábios incircuncisos, e como o Faraó me escutará? ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yahweh disse a Moisés: “Eis que eu te fiz como Deus ao Faraó; e Arão, teu irmão, será teu profeta”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Dirás tudo o que eu te ordeno; e Arão, teu irmão, falará ao faraó, para que ele deixe os filhos de Israel saírem de sua terra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Endurecerei o coração do Faraó e multiplicarei meus sinais e minhas maravilhas na terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Mas o Faraó não lhe dará ouvidos, então porei minha mão sobre o Egito, e tirarei meus exércitos, meu povo, os filhos de Israel, da terra do Egito por grandes julgamentos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Os egípcios saberão que eu sou Yahweh quando eu estender minha mão sobre o Egito, e tirar os filhos de Israel do meio deles”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moisés e Aaron o fizeram. Como lhes ordenou Yahweh, assim o fizeram. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moisés tinha oitenta anos, e Aarão oitenta e três anos, quando falaram com o Faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yahweh falou a Moisés e a Aarão, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Quando o faraó falar com você, dizendo: 'Faça um milagre!' então você dirá a Aarão: 'Pegue sua vara e a jogue diante do faraó, e ela se tornará uma serpente'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moisés e Arão foram ao Faraó, e o fizeram, como Yahweh havia ordenado. Aarão derrubou sua vara diante do faraó e diante de seus servos, e ela se tornou uma serpente. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Então o Faraó também chamou os sábios e os feiticeiros. Eles também, os magos do Egito, fizeram a mesma coisa com seus encantamentos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Pois cada um deles lançou suas varas, e eles se tornaram serpentes; mas a vara de Aarão engoliu suas varas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","O coração do faraó foi endurecido, e ele não os ouviu, como Yahweh havia falado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Yahweh disse a Moisés: “O coração do Faraó é teimoso”. Ele se recusa a deixar o povo ir. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Vá ao Faraó pela manhã. Eis que ele está indo para a água. Você deve ficar à margem do rio para encontrá-lo. Você pegará a vara que foi virada para uma serpente em sua mão. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Você lhe dirá: 'Javé, o Deus dos hebreus, me enviou a você, dizendo: “Deixe meu povo ir, para que me sirvam no deserto. Eis que até agora você não me escutou”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Yahweh diz: “Nisto você saberá que eu sou Yahweh”. Contemplem: Eu atacarei com a vara que está na minha mão as águas que estão no rio, e elas serão transformadas em sangue. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Os peixes que estão no rio morrerão e o rio se tornará sujo. Os egípcios odiarão beber a água do rio””. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yahweh disse a Moisés: “Diga a Arão: 'Pegue sua vara e estenda sua mão sobre as águas do Egito, sobre seus rios, sobre seus riachos, e sobre suas piscinas, e sobre todas as suas lagoas de água, para que se tornem sangue. Haverá sangue em toda a terra do Egito, tanto em vasos de madeira quanto em vasos de pedra”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moisés e Arão o fizeram, como ordenou Javé; e levantou a vara, e bateu nas águas que estavam no rio, na vista do Faraó, e na vista de seus servos; e todas as águas que estavam no rio foram transformadas em sangue. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Os peixes que estavam no rio morreram. O rio ficou sujo. Os egípcios não conseguiam beber água do rio. O sangue estava em toda a terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Os magos do Egito fizeram a mesma coisa com seus encantamentos. Então o coração do Faraó foi endurecido e ele não os ouviu, como Yahweh havia falado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","O Faraó virou-se e foi para sua casa, e nem sequer levou isto a sério. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Todos os egípcios cavaram ao redor do rio para beber água; pois não conseguiam beber a água do rio. ");
INSERT INTO porbrbsl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Sete dias foram cumpridos, após Yahweh ter atingido o rio. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Yahweh falou a Moisés: “Vá até o Faraó e diga-lhe: 'Isto é o que Yahweh diz: 'Deixe meu povo ir, para que me sirvam'. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","If vocês se recusam a deixá-los ir, eis que eu vou atormentar todas as suas fronteiras com sapos”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","O rio se inundará de rãs, que subirão e entrarão em sua casa, e em seu quarto, e em sua cama, e na casa de seus criados, e em seu povo, e em seus fornos, e em seus cochos de amassar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Os sapos subirão sobre você, e sobre seu povo, e sobre todos os seus criados”'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Yahweh disse a Moisés: “Diga a Aaron: 'Estenda sua mão com sua vara sobre os rios, sobre os riachos e sobre as piscinas, e faça subir rãs na terra do Egito'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaron estendeu sua mão sobre as águas do Egito; e as rãs subiram, e cobriram a terra do Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Os mágicos fizeram a mesma coisa com seus encantamentos, e criaram rãs na terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Então o Faraó chamou Moisés e Arão e disse: “Rogai a Javé que tire as rãs de mim e do meu povo; e eu deixarei o povo ir, para que se sacrifiquem a Javé”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moisés disse ao Faraó: “Dou-lhe a honra de fixar o tempo em que devo rezar por você, por seus servos e por seu povo, para que os sapos sejam destruídos de você e de suas casas, e permaneçam apenas no rio”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Pharaoh disse: “Amanhã”. Moisés disse: “Que seja de acordo com sua palavra, para que você saiba que não há ninguém como Javé nosso Deus”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Os sapos partirão de vocês, e de suas casas, e de seus servos, e de seu povo”. Eles permanecerão apenas no rio”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moisés e Arão saíram do Faraó, e Moisés chorou a Javé a respeito dos sapos que ele havia trazido ao Faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Yahweh fez de acordo com a palavra de Moisés, e os sapos morreram fora das casas, fora dos tribunais e fora dos campos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Eles os reuniram em montões, e a terra cheirava mal. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mas quando o Faraó viu que havia um descanso, endureceu seu coração, e não os ouviu, como Yahweh havia falado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yahweh disse a Moisés: “Diga a Arão: 'Estica tua vara e golpeia o pó da terra, para que ela se torne piolho em toda a terra do Egito'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Eles o fizeram; e Arão estendeu sua mão com sua vara, e golpeou o pó da terra, e houve piolhos no homem, e nos animais; todo o pó da terra se tornou piolho em toda a terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Os mágicos tentaram com seus encantos produzir piolhos, mas não conseguiram. Havia piolhos sobre o homem e sobre os animais. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Então os magos disseram ao Faraó: “Este é o dedo de Deus”; mas o coração do Faraó se endureceu, e ele não os ouviu, como Yahweh havia falado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Yahweh disse a Moisés: “Levanta-te cedo pela manhã, e apresenta-te diante do Faraó; eis que ele sai à água; e diz-lhe: 'Isto é o que Yahweh diz: 'Deixa o meu povo ir, para que me sirva'. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Else, se você não deixar meu povo ir, eis que eu enviarei enxames de moscas sobre você, e sobre seus servos, e sobre seu povo, e para suas casas”. As casas dos egípcios estarão cheias de enxames de moscas, e também o chão onde elas estão. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Nesse dia separarei a terra de Gósen, na qual meu povo habita, para que não haja enxames de moscas, até o final vocês poderão saber que eu sou Yahweh na terra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Vou colocar uma divisão entre meu povo e seu povo. Este sinal acontecerá até amanhã””. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Yahweh o fez; e vieram multidões de moscas para a casa do faraó e para as casas de seus servos. Em toda a terra do Egito, a terra foi corrompida por causa dos enxames de moscas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","O Faraó chamou por Moisés e por Aarão, e disse: “Vai, sacrifício a teu Deus na terra”! ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moisés disse: “Não é apropriado fazê-lo; pois sacrificaremos a abominação dos egípcios a Javé nosso Deus”. Eis que, se sacrificarmos a abominação dos egípcios diante de seus olhos, eles não nos apedrejarão? ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Iremos três dias de viagem ao deserto, e sacrificaremos a Javé nosso Deus, como ele nos ordenar”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","O Faraó disse: “Eu te deixarei ir, para que sacrifiques a Javé teu Deus no deserto, só que não irás muito longe”. Reze por mim”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moses disse: “Eis que estou saindo de você”. Rezarei a Javé para que os enxames de moscas possam partir do Faraó, de seus servos, e de seu povo, amanhã; só não deixe mais o Faraó negociar enganosamente em não deixar o povo ir para o sacrifício a Javé”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moses saiu do Faraó, e rezou a Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Yahweh fez de acordo com a palavra de Moisés, e ele removeu os enxames de moscas do Faraó, de seus servos e de seu povo. Não restou nenhum. ");
INSERT INTO porbrbsl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Pharaoh endureceu seu coração desta vez também, e ele não deixou o povo ir. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Então Javé disse a Moisés: “Vá até o Faraó e lhe diga: 'Isto é o que Javé, o Deus dos hebreus, diz: “Deixe meu povo ir, para que me sirvam. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Pois se você se recusar a deixá-los ir, e segurá-los quietos, ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","eis que a mão de Javé está no seu gado que está no campo, nos cavalos, nos burros, nos camelos, nos rebanhos e nos rebanhos com uma pestilência muito grave. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Yahweh fará uma distinção entre o gado de Israel e o gado do Egito; e nada morrerá de tudo o que pertence aos filhos de Israel””. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yahweh indicou um horário fixo, dizendo: “Amanhã Yahweh fará isto na terra”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Javé fez essa coisa no dia seguinte; e todo o gado do Egito morreu, mas do gado dos filhos de Israel, nem um morreu. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faraó enviou, e eis que não havia tanto como um dos animais de gado dos israelitas mortos. Mas o coração do Faraó era teimoso, e ele não deixou o povo ir. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Yahweh disse a Moisés e a Arão: “Pegue um punhado de cinzas da fornalha e deixe Moisés borrifar em direção ao céu à vista do Faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Tornar-se-á pequeno pó sobre toda a terra do Egito, e haverá furúnculos e bolhas que se espalharão sobre o homem e sobre os animais, por toda a terra do Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Eles pegaram as cinzas do forno e se colocaram diante do Faraó; e Moisés aspergiu-o em direção ao céu; e ele se transformou em furúnculos e bolhas que irromperam sobre o homem e sobre os animais. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Os magos não puderam estar diante de Moisés por causa das fervuras; pois as fervuras estavam sobre os magos e sobre todos os egípcios. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Yahweh endureceu o coração do Faraó, e não os ouviu, como Yahweh havia falado a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Yahweh disse a Moisés: “Levanta-te cedo pela manhã, levanta-te diante do Faraó e diz-lhe: 'Isto é o que Yahweh, o Deus dos hebreus, diz: “Deixa o meu povo ir, para que me sirvam. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Por esta vez enviarei todas as minhas pragas contra seu coração, contra seus oficiais e contra seu povo; para que saiba que não há ninguém como eu em toda a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Por enquanto eu teria estendido minha mão e teria atingido você e seu povo com pestilência, e você teria sido cortado da terra; ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","mas de fato por esta causa eu o fiz valer: para mostrar-lhe meu poder, e para que meu nome seja declarado em toda a terra, ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","because você ainda se exalta contra meu povo, para que não o deixe ir. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Eis que amanhã, por esta ocasião, farei chover uma chuva de granizo muito grave, como não tem acontecido no Egito desde o dia em que foi fundado, até agora. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Agora, portanto, ordene que todo o seu gado e tudo o que você tem no campo seja levado para um abrigo. O granizo cairá sobre todo homem e animal que for encontrado no campo, e não for trazido para casa, e eles morrerão”'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Aqueles que temiam a palavra de Javé entre os servos do faraó fizeram seus servos e seu gado fugir para as casas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Aqueles que não respeitaram a palavra de Iavé deixaram seus servos e seu gado no campo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Yahweh disse a Moisés: “Estende tua mão em direção ao céu, para que possa haver granizo em toda a terra do Egito, sobre o homem, sobre os animais e sobre cada erva do campo, em toda a terra do Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moisés estendeu sua vara em direção aos céus, e Javé enviou trovões e granizo; e relâmpagos desceram à terra. Yahweh chovia granizo na terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Portanto, houve granizo muito forte, e relâmpagos misturados com o granizo, como não havia estado em toda a terra do Egito desde que se tornou uma nação. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","O granizo atingiu em toda a terra do Egito tudo o que havia no campo, tanto homem quanto animal; e o granizo atingiu cada erva do campo, e quebrou cada árvore do campo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Somente na terra de Gósen, onde estavam os filhos de Israel, não houve granizo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","O Faraó enviou e chamou Moisés e Arão, e disse-lhes: “Desta vez pequei”. Javé é justo e eu e meu povo somos perversos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Reze a Javé, pois já houve trovões e granizo o suficiente. Eu te deixarei ir, e não ficarás mais”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moisés disse-lhe: “Assim que eu tiver saído da cidade, estenderei minhas mãos para Iavé”. Os trovões cessarão, e não haverá mais granizo; para que saibam que a terra é de Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mas quanto a você e seus servos, sei que ainda não temem a Deus Yahweh”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","O linho e a cevada foram atingidos, pois a cevada havia amadurecido e o linho estava florindo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Mas o trigo e a espelta não foram batidos, pois não tinham crescido. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moisés saiu da cidade vindo do Faraó, e estendeu suas mãos para Iavé; e os trovões e o granizo cessaram, e a chuva não foi derramada sobre a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Quando o Faraó viu que a chuva e o granizo e os trovões tinham cessado, ele pecou ainda mais, e endureceu seu coração, ele e seus servos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","O coração do Faraó foi endurecido, e ele não deixou ir os filhos de Israel, assim como Yahweh havia falado através de Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Javé disse a Moisés: “Ide ao Faraó, porque endureci seu coração e o coração de seus servos, para que eu possa mostrar estes meus sinais entre eles; ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","e para que possais dizer na audiência de vosso filho, e do filho de vosso filho, o que fiz ao Egito, e os meus sinais que fiz entre eles; para que possais saber que sou Javé”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moisés e Arão foram ao Faraó, e disseram-lhe: “Isto é o que Javé, o Deus dos hebreus, diz: 'Por quanto tempo você se recusará a humilhar-se diante de mim? Deixe meu povo ir, para que me sirvam. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ou então, se você se recusar a deixar meu povo ir, eis que amanhã trarei gafanhotos ao seu país, ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","e eles cobrirão a superfície da terra, para que não se possa ver a terra. Eles comerão o resíduo daquilo que escapou, que sobrou para vocês do granizo, e comerão todas as árvores que crescem para vocês fora do campo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Vossas casas se encherão, e as casas de todos os vossos servos, e as casas de todos os egípcios, como nem vossos pais nem os pais de vossos pais viram, desde o dia em que estiveram sobre a terra até hoje”. Ele se virou, e saiu do Faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Os servos do Faraó lhe disseram: “Por quanto tempo este homem será um laço para nós? Deixe os homens irem, para que possam servir a Javé, seu Deus”. Você ainda não sabe que o Egito está destruído?” ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Moisés e Arão foram levados novamente ao Faraó, e ele lhes disse: “Ide, servi ao Senhor vosso Deus; mas quem são aqueles que irão?”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moisés disse: “Iremos com nossos jovens e com nossos velhos”. Iremos com nossos filhos e com nossas filhas, com nossos rebanhos e com nossos rebanhos; pois devemos fazer um banquete a Javé”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ele disse a eles: “Yahweh esteja com vocês se eu os deixar ir com seus pequenos! Vejam, o mal está claramente diante de seus rostos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Não é assim! Vão agora vocês que são homens, e sirvam a Javé; pois é isso que desejam”! Então foram expulsos da presença do faraó. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Yahweh disse a Moisés: “Estende tua mão sobre a terra do Egito para que os gafanhotos possam subir na terra do Egito, e comer todas as ervas da terra, mesmo tudo o que o granizo deixou”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moisés estendeu sua vara sobre a terra do Egito, e Javé trouxe um vento oriental sobre a terra durante todo aquele dia e toda a noite; e quando era manhã, o vento oriental trouxe os gafanhotos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Os gafanhotos subiram sobre toda a terra do Egito, e descansaram em todas as fronteiras do Egito. Eram muito dolorosos. Antes deles não havia gafanhotos como eles, nem nunca mais haverá. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Pois eles cobriram a superfície de toda a terra, de modo que a terra ficou escura, e comeram cada erva da terra, e todos os frutos das árvores que o granizo havia deixado. Não ficou nada verde, nem árvore nem erva do campo, por toda a terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Então o Faraó chamou Moisés e Arão apressadamente, e disse: “Pequei contra Javé, vosso Deus, e contra vós”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Agora, portanto, por favor, perdoe novamente meu pecado e ore a Javé seu Deus, para que ele também possa tirar de mim esta morte”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moisés saiu do Faraó, e rezou a Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Yahweh enviou um vento ocidental extremamente forte, que tomou os gafanhotos e os levou ao Mar Vermelho. Não restou um só gafanhoto em todas as fronteiras do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mas Javé endureceu o coração do Faraó e não deixou ir os filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yahweh disse a Moisés: “Estende tua mão em direção ao céu, para que possa haver escuridão sobre a terra do Egito, mesmo escuridão que possa ser sentida”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moisés estendeu sua mão em direção ao céu, e houve uma escuridão espessa em toda a terra do Egito por três dias. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Eles não se viram, e ninguém se levantou de seu lugar por três dias; mas todos os filhos de Israel tinham luz em suas habitações. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","O Faraó chamou Moisés e disse: “Vai, serve a Javé”. Deixem apenas seus rebanhos e seus rebanhos ficarem para trás”. Deixem seus filhotes também ir com vocês”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moisés disse: “Você também deve dar em nossas mãos sacrifícios e ofertas queimadas, para que possamos sacrificar a Javé, nosso Deus”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Nosso gado também deve ir conosco. Nem um casco será deixado para trás, pois dele devemos levar para servir a Javé nosso Deus; e não sabemos com o que devemos servir a Javé, até chegarmos lá”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Mas Yahweh endureceu o coração do Faraó e ele não os deixou ir. ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","O Faraó lhe disse: “Afaste-se de mim! Cuidado para não mais ver meu rosto; pois no dia em que vires meu rosto, morrerás”! ");
INSERT INTO porbrbsl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moisés disse: “Você falou bem”. Não voltarei a ver seu rosto”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Yahweh disse a Moisés: “Eu trarei ainda mais uma praga sobre o Faraó e sobre o Egito; depois ele o deixará ir”. Quando ele te deixar ir, certamente te expulsará por completo”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Fale agora aos ouvidos do povo, e deixe cada homem pedir ao seu próximo, e cada mulher do seu próximo, jóias de prata, e jóias de ouro”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yahweh deu ao povo um favor aos olhos dos egípcios. Além disso, o homem Moisés era muito grande na terra do Egito, aos olhos dos servos do Faraó, e aos olhos do povo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moisés disse: “Isto é o que diz Javé: 'Por volta da meia-noite irei para o meio do Egito, ");
INSERT INTO porbrbsl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","e todos os primogênitos na terra do Egito morrerão, desde o primogênito do Faraó que se senta em seu trono, até o primogênito da criada que está atrás do moinho, e todos os primogênitos do gado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Haverá um grande grito em toda a terra do Egito, como não houve, nem haverá mais. ");
INSERT INTO porbrbsl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mas contra qualquer um dos filhos de Israel um cão não ladrará nem moverá sua língua, contra o homem ou animal, para que você saiba que Javé faz uma distinção entre os egípcios e Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Todos esses seus servos virão até mim, e se curvarão diante de mim, dizendo: “Saia, com todas as pessoas que o seguirem;” e depois disso eu sairei”. Saiu do Faraó em fúria quente. ");
INSERT INTO porbrbsl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yahweh disse a Moisés: “O Faraó não lhe dará ouvidos, para que minhas maravilhas se multipliquem na terra do Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moisés e Arão fizeram todas essas maravilhas diante do Faraó, mas Javé endureceu o coração do Faraó e não deixou os filhos de Israel saírem de sua terra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yahweh falou com Moisés e Aarão na terra do Egito, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Este mês será para vocês o início dos meses. Será para vocês o primeiro mês do ano. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Falou a toda a congregação de Israel, dizendo: “No décimo dia deste mês, levarão a cada homem um cordeiro, de acordo com a casa de seus pais, um cordeiro para uma casa; ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","e se a casa for muito pequena para um cordeiro, então ele e seu vizinho ao lado de sua casa levarão um de acordo com o número de almas. Você fará sua contagem para o cordeiro de acordo com o que todos podem comer. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Seu cordeiro deve ser sem defeito, um macho de um ano. Você o tirará das ovelhas ou dos cabritos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Você o guardará até o décimo quarto dia do mesmo mês; e toda a assembléia da congregação de Israel o matará à noite. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Pegarão um pouco do sangue e o colocarão nos dois postes das portas e no lintel, nas casas em que o comerão. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","comerão a carne naquela noite, assada com fogo, com pão ázimo. Eles a comerão com ervas amargas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Não a comerão crua, nem cozida com água, mas assada com fogo; com sua cabeça, suas pernas e suas partes internas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Nada restará dele até a manhã; mas o que restar dele até a manhã, queimará com fogo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Assim o comerás: com teu cinto na cintura, tuas sandálias nos pés e teu cajado na mão; e o comerás apressadamente: é a Páscoa de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Pois eu atravessarei a terra do Egito naquela noite, e atingirei todos os primogênitos na terra do Egito, tanto o homem como o animal. Executarei julgamentos contra todos os deuses do Egito. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","O sangue será para vocês um sinal sobre as casas onde vocês estão. Quando eu vir o sangue, passarei por cima de vocês, e nenhuma praga estará sobre vocês para destruí-los quando eu atacar a terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Este dia será um memorial para vocês. Você o guardará como um banquete para Iavé. Guardá-lo-eis para sempre como um banquete ao longo de vossas gerações por uma portaria. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“'Sete dias comereis pães ázimos; mesmo no primeiro dia tirareis fermento de vossas casas, pois quem comer pão fermentado desde o primeiro dia até o sétimo dia, essa alma será extirpada de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","No primeiro dia haverá para vós uma santa convocação, e no sétimo dia uma santa convocação; nenhum tipo de trabalho será feito neles, exceto o que todo homem deve comer, somente o que pode ser feito por vós. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Observareis a festa dos pães ázimos; pois neste mesmo dia trouxe vossos exércitos para fora da terra do Egito. Portanto, observareis este dia através de vossas gerações por uma ordenança para sempre. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","No primeiro mês, no décimo quarto dia do mês à noite, comereis pães ázimos, até o vigésimo primeiro dia do mês à noite. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Não será encontrado fermento em vossas casas durante sete dias, pois quem comer o fermento, essa alma será excluída da congregação de Israel, seja estrangeiro, seja nascido na terra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Nada comerá fermentado. Em todas as vossas habitações comereis pão ázimo”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Então Moisés chamou todos os anciãos de Israel e lhes disse: “Saiam e levem cordeiros de acordo com suas famílias, e matem a Páscoa”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Pegue um monte de hissopo e mergulhe-o no sangue que está na bacia, e bata o lintel e os dois postes da porta com o sangue que está na bacia. Nenhum de vocês deve sair da porta de sua casa até a manhã seguinte. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Pois Yahweh passará para atingir os egípcios; e quando vir o sangue no lintel, e nos dois postes da porta, Yahweh passará por cima da porta, e não permitirá que o destruidor entre em suas casas para atingi-lo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Você observará isto para uma ordenança a você e a seus filhos para sempre. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Acontecerá quando vocês chegarem à terra que Yahweh lhes dará, como ele prometeu, que vocês manterão este serviço. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Acontecerá, quando seus filhos lhe perguntarem: 'O que você quer dizer com este serviço? ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","que você dirá: 'É o sacrifício da Páscoa de Javé, que passou por cima das casas dos filhos de Israel no Egito, quando ele atingiu os egípcios, e poupou nossas casas'”. O povo curvou a cabeça e adorou. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Os filhos de Israel foram e o fizeram; como Javé havia ordenado a Moisés e Arão, assim o fizeram. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","À meia-noite, Javé atingiu todos os primogênitos na terra do Egito, desde o primogênito do Faraó que se sentou em seu trono até o primogênito do cativo que estava no calabouço, e todos os primogênitos do gado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","O Faraó levantou-se à noite, ele, e todos os seus servos, e todos os egípcios; e houve um grande grito no Egito, pois não havia uma casa onde não houvesse um morto. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ele chamou por Moisés e Aarão à noite, e disse: “Levantai-vos, saí do meio do meu povo, tanto vós como os filhos de Israel; e ide, servi a Iavé, como haveis dito! ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Levem seus rebanhos e seus rebanhos, como vocês disseram, e desapareçam; e abençoem-me também”! ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Os egípcios tinham urgência com o povo, para enviá-los para fora da terra à pressa, pois diziam: “Somos todos homens mortos”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","O povo tomou sua massa antes que ela fosse fermentada, suas cochos de amassar sendo amarrados em suas roupas sobre seus ombros. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Os filhos de Israel fizeram de acordo com a palavra de Moisés; e pediram aos egípcios jóias de prata, e jóias de ouro, e roupas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yahweh deu ao povo um favor aos olhos dos egípcios, para que eles pudessem ter o que pediram. Eles saquearam os egípcios. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","As crianças de Israel viajaram de Ramsés a Succoth, cerca de seiscentos mil a pé, que eram homens, além de crianças. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Uma multidão mista subiu também com eles, com rebanhos, rebanhos e até mesmo muito gado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Cozinharam bolos ázimos da massa que trouxeram do Egito; pois não era fermentado, porque foram expulsos do Egito, e não podiam esperar, e não tinham preparado nenhum alimento para si mesmos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Agora o tempo em que as crianças de Israel viviam no Egito era de quatrocentos e trinta anos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ao final de quatrocentos e trinta anos, até hoje, todos os exércitos de Iavé saíram da terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","É uma noite a ser muito observada para Iavé por tirá-los da terra do Egito. Esta é aquela noite de Iavé, a ser muito observada por todos os filhos de Israel através de suas gerações. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yahweh disse a Moisés e Arão: “Esta é a ordenança da Páscoa. Nenhum estrangeiro comerá dela, ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","mas o servo de todo homem que for comprado por dinheiro, quando o tiver circuncidado, então ele comerá dela. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Um estrangeiro e um servo contratado não comerão dela. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Deve ser comido em uma casa. Não deverá carregar nenhuma das carnes fora da casa. Não deve quebrar nenhum de seus ossos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Toda a congregação de Israel deve guardá-la. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Quando um estranho viver como estrangeiro com você, e quiser guardar a Páscoa para Javé, que todos os seus machos sejam circuncidados, e então que ele se aproxime e a guarde. Ele será como aquele que nasce na terra; mas nenhuma pessoa incircuncisada comerá dela. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Uma lei será para aquele que nasceu em casa, e para o estrangeiro que vive como um estrangeiro entre vós”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Todos os filhos de Israel o fizeram. Como Javé ordenou a Moisés e Arão, assim o fizeram. ");
INSERT INTO porbrbsl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Nesse mesmo dia, Javé tirou os filhos de Israel da terra do Egito por seus exércitos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Santifica-me todos os primogênitos, o que quer que abra o ventre entre os filhos de Israel, tanto do homem como do animal. É meu”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moisés disse ao povo: “Lembra-te deste dia, em que saíste do Egito, da casa da servidão; pois pela força da mão Yahweh te tirou deste lugar”. Nenhum pão fermentado deve ser comido. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Hoje vocês saem no mês Abib. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Será, quando Javé vos trouxer à terra dos cananeus, e dos hititas, e dos amorreus, e dos heveus, e dos jebuseus, que ele jurou a vossos pais que vos daria, uma terra que flui com leite e mel, que guardareis este serviço neste mês. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sete dias comerá pão ázimo, e no sétimo dia será um banquete para Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Pães ázimos serão comidos durante os sete dias; e nenhum pão levedado será visto com você. Nenhuma levedura será vista com vocês, dentro de todas as suas fronteiras. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Naquele dia dirá a seu filho: “É por causa do que Javé fez por mim quando eu saí do Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Será para um sinal em sua mão, e para um memorial entre seus olhos, que a lei de Javé possa estar em sua boca; pois com uma mão forte Javé o tirou do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Portanto, você deverá manter esta portaria em sua época de ano a ano. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Será, quando Javé vos introduzir na terra dos cananeus, como ele jurou a vós e a vossos pais, e vos dará, ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","que separareis a Javé tudo o que abrir o ventre, e todo primogênito que vier de um animal que tiverdes. Os machos serão de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Todo primogênito de um burro você resgatará com um cordeiro; e se não o resgatar, então quebrará seu pescoço; e resgatará todos os primogênitos do homem entre seus filhos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Será, quando seu filho lhe perguntar a tempo, dizendo: “O que é isto?”, que lhe dirá: “Pela força da mão Javé nos tirou do Egito, da casa da servidão”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Quando o Faraó teimou em nos deixar ir, Javé matou todos os primogênitos da terra do Egito, tanto os primogênitos do homem, quanto os primogênitos do gado. Portanto, eu sacrifico a Javé tudo o que abre o ventre, sendo machos; mas todos os primogênitos de meus filhos eu resgato”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Será por um sinal em sua mão, e por símbolos entre seus olhos; pois pela força da mão Yahweh nos tirou do Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Quando o Faraó deixou o povo ir, Deus não o conduziu pelo caminho da terra dos filisteus, embora isso estivesse próximo; pois Deus disse: “Para que o povo não mude de idéia quando vir a guerra, e volte ao Egito”; ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","mas Deus conduziu o povo pelo caminho do deserto pelo Mar Vermelho; e as crianças de Israel subiram armadas para fora da terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moisés levou consigo os ossos de José, pois tinha feito os filhos de Israel jurarem, dizendo: “Deus certamente vos visitará, e vós levareis os meus ossos para longe daqui convosco”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","They fizeram sua viagem de Succoth, e acamparam em Etham, na orla do deserto. ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yahweh foi antes deles de dia numa coluna de nuvem, para guiá-los em seu caminho, e de noite numa coluna de fogo, para dar-lhes luz, para que pudessem ir de dia e de noite: ");
INSERT INTO porbrbsl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","a coluna de nuvem de dia, e a coluna de fogo de noite, não partiram de diante do povo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yahweh falou com Moisés, dizendo, ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Fale com as crianças de Israel, que elas voltem e acampem antes de Pihahiroth, entre Migdol e o mar, antes de Baal Zephon. Acamparão em frente a ele junto ao mar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","O Faraó dirá dos filhos de Israel: 'Eles estão enredados na terra'. O deserto os encerrou”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","endurecerei o coração do Faraó, e ele os seguirá; e obterei honra sobre o Faraó, e sobre todos os seus exércitos; e os egípcios saberão que eu sou Yahweh”. Eles o fizeram. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Foi dito ao rei do Egito que o povo havia fugido; e o coração do Faraó e de seus servos mudou para o povo, e eles disseram: “O que é isso que fizemos, que deixamos Israel ir de nos servir”? ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ele preparou sua carruagem e levou seu exército com ele; ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","e levou seiscentas carruagens escolhidas, e todas as carruagens do Egito, com capitães sobre todas elas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Javé endureceu o coração do Faraó, rei do Egito, e perseguiu os filhos de Israel; pois os filhos de Israel saíram com mão alta. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Os egípcios os perseguiram. Todos os cavalos e carros do Faraó, seus cavaleiros e seu exército os alcançaram acampados junto ao mar, ao lado de Pihahiroth, antes de Baal Zephon. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Quando o Faraó se aproximou, os filhos de Israel levantaram os olhos, e eis que os egípcios marchavam atrás deles; e eles ficaram com muito medo. As crianças de Israel gritaram a Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Disseram a Moisés: “Porque não havia sepulturas no Egito, você nos levou para morrer no deserto? Por que nos trataram desta maneira, para nos tirar do Egito? ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Não é esta a palavra que falamos com você no Egito, dizendo: “Deixe-nos em paz, para que possamos servir aos egípcios? Pois teria sido melhor para nós servir os egípcios do que morrer no deserto”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moisés disse ao povo: “Não tenha medo”. Fique parado e veja a salvação de Javé, que ele trabalhará para você hoje; pois você nunca mais verá os egípcios que você viu hoje”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yahweh lutará por você, e você ficará quieto”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Yahweh disse a Moisés: “Por que você chora para mim? Fale com os filhos de Israel, que eles vão em frente. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Levante sua vara, estenda sua mão sobre o mar e divida-o. Então os filhos de Israel irão para o meio do mar em terra firme. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Eis que eu mesmo endurecerei os corações dos egípcios, e eles entrarão atrás deles. Eu mesmo conseguirei honra sobre o Faraó, sobre todos os seus exércitos, sobre as suas carruagens e sobre os seus cavaleiros. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Os egípcios saberão que eu sou Yahweh quando eu tiver conseguido honra sobre o Faraó, sobre suas carruagens, e sobre seus cavaleiros”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","O anjo de Deus, que foi antes do acampamento de Israel, moveu-se e foi atrás deles; e a coluna de nuvem se moveu de diante deles, e ficou atrás deles. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Veio entre o acampamento do Egito e o acampamento de Israel. Havia a nuvem e a escuridão, mas ela dava luz à noite. Uma não chegou perto da outra a noite toda. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moisés estendeu sua mão sobre o mar, e Yahweh fez com que o mar voltasse por um forte vento leste durante toda a noite, e fez com que o mar se tornasse terra seca, e as águas foram divididas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Os filhos de Israel foram para o meio do mar em terra seca; e as águas eram um muro para eles à sua direita e à sua esquerda. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Os egípcios perseguiram e foram atrás deles até o meio do mar: todos os cavalos do faraó, suas carruagens e seus cavaleiros. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Na vigília da manhã, Javé olhou para o exército egípcio através da coluna de fogo e de nuvens, e confundiu o exército egípcio. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ele tirou as rodas de suas carruagens, e eles as dirigiram com força; de modo que os egípcios disseram: “Vamos fugir da face de Israel, pois Javé luta por eles contra os egípcios! ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yahweh disse a Moisés: “Estende tua mão sobre o mar, para que as águas possam vir novamente sobre os egípcios, sobre suas carruagens, e sobre seus cavaleiros”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moisés estendeu sua mão sobre o mar, e o mar voltou à sua força quando a manhã apareceu; e os egípcios fugiram contra ele. Yahweh derrubou os egípcios no meio do mar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","As águas voltaram, e cobriram as carruagens e os cavaleiros, até mesmo todo o exército do Faraó que foi atrás deles para o mar. Não restou nem mesmo um deles. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mas os filhos de Israel caminharam em terra firme no meio do mar, e as águas eram um muro para eles à sua direita e à sua esquerda. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Assim Javé salvou Israel naquele dia da mão dos egípcios; e Israel viu os egípcios mortos na praia do mar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israel viu a grande obra que Javé fez aos egípcios, e o povo temia a Javé; e eles acreditaram em Javé e em seu servo Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Então Moisés e as crianças de Israel cantaram esta canção para Javé, e disseram, “Vou cantar para Javé, pois ele triunfou gloriosamente. Ele jogou o cavalo e seu cavaleiro no mar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yah é minha força e meu canto. Ele se tornou minha salvação. Este é meu Deus, e eu o louvarei; o Deus de meu pai, e eu o exaltarei. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yahweh é um homem de guerra. Yahweh é seu nome. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ele lançou as carruagens do faraó e seu exército no mar. Seus capitães escolhidos estão afundados no Mar Vermelho. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","As profundezas as cobrem. Eles desceram às profundezas como uma pedra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Sua mão direita, Yahweh, é gloriosa no poder. Sua mão direita, Yahweh, trai o inimigo em pedaços. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Na grandeza de sua excelência, o senhor derruba aqueles que se levantam contra o senhor. Você envia sua fúria. Ela os consome como restolho. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Com o sopro de suas narinas, as águas foram empilhadas. As enchentes se ergueram como uma pilha. As profundezas foram congeladas no coração do mar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","O inimigo disse: 'Eu perseguirei'. Eu irei superar. Vou dividir o saque. Meu desejo será satisfeito com eles. Eu desembainharei minha espada. Minha mão vai destruí-los'. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Você soprou com seu vento. O mar os cobriu. Afundaram como chumbo nas águas impetuosas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Quem é como você, Yahweh, entre os deuses? Quem é como você, glorioso em santidade, temeroso em elogios, fazendo maravilhas? ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Você esticou sua mão direita. A terra os engoliu. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Você, em sua bondade amorosa, conduziu o povo que você resgatou. Você os guiou em suas forças para sua morada sagrada. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Os povos já ouviram falar. Eles tremem. As panelas se apoderaram dos habitantes da Filístia. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Então os chefes da Edom ficaram consternados. O tremor se apodera dos poderosos homens de Moab. Todos os habitantes de Canaã derreteram. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","O terror e o pavor caem sobre eles. Pela grandeza de seu braço, eles são tão imóveis quanto uma pedra, até que seu povo passe para o outro lado, Yahweh, até que as pessoas que você comprou passem por cima. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Você os trará e os plantará na montanha de sua herança, o lugar, Yahweh, que você mesmo fez para morar: o santuário, Senhor, que suas mãos estabeleceram. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yahweh reinará para todo o sempre”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Pois os cavalos do Faraó entraram com suas carruagens e com seus cavaleiros no mar, e Javé trouxe de volta as águas do mar sobre eles; mas os filhos de Israel caminharam em terra firme no meio do mar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miriam, a profetisa, irmã de Aarão, pegou um pandeiro na mão; e todas as mulheres saíram atrás dela com pandeiros e com danças. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam respondeu-lhes, “Canta para Javé, pois ele triunfou gloriosamente”. Ele jogou o cavalo e seu cavaleiro no mar”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moisés conduziu Israel em frente do Mar Vermelho, e eles saíram para o deserto de Shur; e foram três dias no deserto, e não encontraram água. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Quando chegaram a Marah, não puderam beber das águas de Marah, pois estavam amargurados. Portanto, seu nome era Marah. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","O povo murmurou contra Moisés, dizendo: “O que devemos beber?”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Então ele gritou a Javé. Javé lhe mostrou uma árvore, e ele a jogou nas águas, e as águas se tornaram doces. Ali ele fez um estatuto e uma portaria para eles, e ali os testou. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ele disse: “Se ouvirdes diligentemente a voz de Javé, vosso Deus, e fizerdes o que é justo aos seus olhos, e prestardes atenção aos seus mandamentos, e guardardes todos os seus estatutos, não porei sobre vós nenhuma das doenças que pus sobre os egípcios; pois eu sou Javé que vos cura”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Eles vieram para Elim, onde havia doze nascentes de água e setenta palmeiras. Eles acamparam ali junto às águas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Eles fizeram sua viagem desde Elim, e toda a congregação dos filhos de Israel veio para o deserto de Sinai, que fica entre Elim e Sinai, no décimo quinto dia do segundo mês após sua partida da terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Toda a congregação dos filhos de Israel murmurou contra Moisés e contra Arão no deserto; ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","e os filhos de Israel disseram-lhes: “Desejamos ter morrido pela mão de Javé na terra do Egito, quando nos sentamos junto às panelas de carne, quando comemos nossa fartura de pão, pois vocês nos trouxeram a este deserto para matar toda esta assembléia de fome”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Então Javé disse a Moisés: “Eis que choverei pão do céu por ti, e o povo sairá e recolherá a porção de um dia todos os dias, para que eu possa testá-los, quer andem ou não na minha lei”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Acontecerá no sexto dia, que prepararão o que trouxerem, e será o dobro da porção que recolherem diariamente”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moisés e Arão disseram a todos os filhos de Israel: “À noite, vocês saberão que Javé os tirou da terra do Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Pela manhã, vocês verão a glória de Iavé; porque ele ouve seus murmúrios contra Iavé. Quem somos nós, que você murmura contra nós?”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moisés disse: “Agora Javé lhe dará carne para comer à noite, e de manhã pão para satisfazê-lo, porque Javé ouve suas murmurações que você murmura contra ele”. E quem somos nós? Suas murmurações não são contra nós, mas contra Yahweh”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moisés disse a Arão: “Diga a toda a congregação dos filhos de Israel: 'Aproximai-vos de Javé, pois ele ouviu vossas murmurações'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Quando Arão falou a toda a congregação dos filhos de Israel, eles olharam para o deserto, e eis que a glória de Javé apareceu na nuvem. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Javé falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Ouvi os murmúrios dos filhos de Israel”. Fale com eles, dizendo: “À noite comerão carne, e de manhã se encherão de pão”. Então sabereis que eu sou Yahweh, vosso Deus””. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","À noite, a codorniz surgiu e cobriu o acampamento; e pela manhã o orvalho circundava o acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Quando o orvalho que jazia tinha desaparecido, eis que na superfície do deserto era uma pequena coisa redonda, pequena como a geada no chão. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Quando as crianças de Israel o viram, disseram umas para as outras: “O que é isso?”. Pois eles não sabiam o que era. Moisés lhes disse: “É o pão que Javé lhes deu para comer”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Isto é o que Javé ordenou: “Recolhei dele todos de acordo com sua alimentação; um omer uma cabeça, de acordo com o número de vossas pessoas, tomai-o, cada homem para aqueles que estão em sua tenda””. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","As crianças de Israel o fizeram, e algumas se reuniram mais, outras menos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Quando o mediram com um gômero, aquele que muito reuniu não tinha nada, e aquele que pouco reuniu não tinha falta. Cada um deles se reunia de acordo com sua alimentação. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moisés disse-lhes: “Não deixem ninguém sair dele até de manhã”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Notwithstanding eles não deram ouvidos a Moisés, mas alguns deles saíram dele até de manhã, então ele criou minhocas e se tornou sujo; e Moisés ficou furioso com eles. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Eles o reuniram pela manhã, todos de acordo com sua alimentação. Quando o sol ficou quente, ele derreteu. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","No sexto dia, eles juntaram o dobro do pão, dois presságios para cada um; e todos os governantes da congregação vieram e disseram a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ele lhes disse: “Isto é o que Javé disse: 'Amanhã é um descanso solene, um sábado santo para Javé'”. Cozinhem o que quiserem cozinhar, e cozam o que quiserem ferver; e tudo o que sobrar, fiquem deitados para serem guardados até a manhã””. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Eles o deitaram até a manhã, como Moisés ordenou, e não se tornou sujo, e não havia minhocas nele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moisés disse: “Comam isso hoje, pois hoje é um sábado para Yahweh. Hoje você não o encontrará no campo”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Seis dias você o reunirá, mas no sétimo dia é o Sábado. Nele não haverá nenhum”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","No sétimo dia, algumas das pessoas saíram para se reunir, e não encontraram nenhum. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Yahweh disse a Moisés: “Por quanto tempo você se recusa a guardar meus mandamentos e minhas leis? ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Eis que, porque Javé te deu o sábado, por isso ele te dá no sexto dia o pão de dois dias”. Todos ficam em seu lugar. Que ninguém saia de seu lugar no sétimo dia”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Portanto, o povo descansou no sétimo dia. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","A casa de Israel chamou seu nome de “Maná”, e era como uma semente de coentro, branca; e seu sabor era como hóstias com mel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moisés disse: “Esta é a coisa que Javé ordenou: 'Que um gérmen cheio dele seja guardado através de vossas gerações, para que vejam o pão com o qual vos alimentei no deserto, quando vos tirei da terra do Egito'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moisés disse a Aaron: “Pegue uma panela, e ponha nela um caramelo cheio de maná, e coloque-o diante de Yahweh, para ser guardado através de suas gerações”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Como Yahweh ordenou a Moisés, assim Aaron o colocou antes do Testemunho, para ser mantido. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Os filhos de Israel comeram o maná durante quarenta anos, até chegarem a uma terra habitada. Eles comeram o maná até chegarem às fronteiras da terra de Canaã. ");
INSERT INTO porbrbsl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Now um omer é um décimo de uma efa. ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Toda a congregação dos filhos de Israel viajou do deserto de Pecado, começando segundo o mandamento de Javé, e acampados em Rephidim; mas não havia água para o povo beber. ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Portanto, o povo discutiu com Moisés e disse: “Dê-nos água para beber”. Moisés disse a eles: “Por que discutem comigo? Por que vocês testam Yahweh”? ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","O povo estava sedento de água; então o povo murmurou contra Moisés, e disse: “Por que nos trouxeste para fora do Egito, para nos matar, nossos filhos e nosso gado com sede”? ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moisés gritou a Javé, dizendo: “O que devo fazer com essas pessoas? Eles estão quase prontos para me apedrejar”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yahweh disse a Moisés: “Caminhe diante do povo, leve consigo os anciãos de Israel, pegue a vara na mão com a qual você bateu no Nilo e vá. ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Eis que estarei ali diante de vós na rocha de Horeb. Baterás na rocha, e dela sairá água, para que o povo possa beber”. Moisés o fez diante dos olhos dos anciãos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ele chamou o nome do lugar Massah, e Meribah, porque os filhos de Israel brigaram, e porque testaram Yahweh, dizendo: “Yahweh está entre nós, ou não? ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Então Amalek veio e lutou com Israel em Rephidim. ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moisés disse a Josué: “Escolha homens para nós, e saia para lutar com Amalek”. Amanhã estarei no topo da colina com a vara de Deus na mão”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Então Josué fez como Moisés lhe havia dito, e lutou com Amalek; e Moisés, Arão e Hur subiram ao topo da colina. ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Quando Moisés ergueu sua mão, Israel prevaleceu. Quando ele soltou sua mão, Amalek prevaleceu. ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mas as mãos de Moisés eram pesadas; então eles pegaram uma pedra e a colocaram debaixo dele, e ele se sentou sobre ela. Aarão e Hur levantaram suas mãos, uma de um lado e a outra do outro. Suas mãos estavam firmes até o pôr-do-sol. ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Josué derrotou Amalek e seu povo com o fio da espada. ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Yahweh disse a Moisés: “Escreva isto para um memorial em um livro e ensaie nos ouvidos de Josué: que eu apagarei completamente a memória de Amalek de debaixo do céu”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moisés construiu um altar, e chamou seu nome de “Yahweh our Banner”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ele disse: “Yahweh jurou: 'Yahweh terá guerra com Amalek de geração em geração'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Agora Jetro, o sacerdote de Midian, sogro de Moisés, ouviu falar de tudo o que Deus havia feito por Moisés e por Israel, seu povo, como Javé havia tirado Israel do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jethro, sogro de Moisés, recebeu Zipporah, a esposa de Moisés, depois que ele a mandou embora, ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","e seus dois filhos. O nome de um filho era Gershom, pois Moisés disse: “Eu vivi como estrangeiro em uma terra estrangeira”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","O nome do outro era Eliezer, pois ele disse: “O Deus de meu pai foi minha ajuda e me libertou da espada do faraó”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jetro, sogro de Moisés, veio com os filhos de Moisés e sua esposa para Moisés no deserto onde ele estava acampado, na Montanha de Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Ele disse a Moisés: “Eu, seu sogro Jetro, vim até você com sua esposa, e seus dois filhos com ela”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moisés saiu ao encontro de seu sogro, fez uma reverência e o beijou. Eles perguntaram um ao outro sobre seu bem-estar, e entraram na tenda. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moisés contou a seu sogro tudo o que Javé havia feito ao Faraó e aos egípcios pelo bem de Israel, todas as dificuldades que lhes haviam sido infligidas no caminho e como Javé as havia libertado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro regozijou-se por toda a bondade que Iavé fizera a Israel, na medida em que os havia libertado das mãos dos egípcios. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jethro disse: “Bendito seja Javé, que vos libertou da mão dos egípcios, e da mão do Faraó; que libertou o povo de debaixo da mão dos egípcios”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Agora sei que Yahweh é maior que todos os deuses por causa da maneira arrogante como trataram as pessoas”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jetro, sogro de Moisés, aceitou um holocausto e sacrifícios por Deus. Aarão veio com todos os anciãos de Israel, para comer pão com o sogro de Moisés diante de Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","No dia seguinte, Moisés sentou-se para julgar o povo, e o povo ficou de pé ao redor de Moisés desde a manhã até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Quando o sogro de Moisés viu tudo o que ele fez ao povo, ele disse: “O que é isso que você faz pelo povo? Por que você se senta sozinho, e todo o povo fica ao seu redor de manhã à noite”? ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moisés disse a seu sogro: “Porque o povo vem a mim para perguntar a Deus”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Quando têm um assunto, eles vêm a mim, e eu julgo entre um homem e seu próximo, e os faço conhecer os estatutos de Deus, e suas leis”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","O sogro de Moisés lhe disse: “O que você faz não é bom”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Vocês certamente se desgastarão, tanto vocês como este povo que está com vocês; pois a coisa é pesada demais para vocês. Você não é capaz de realizá-lo sozinho. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ouça agora a minha voz. Eu lhe darei conselhos, e Deus esteja com você. Vocês representam o povo diante de Deus e trazem as causas a Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Você lhes ensinará os estatutos e as leis, e lhes mostrará o caminho que devem seguir, e o trabalho que devem fazer. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Moreover vós fornecereis de todo o povo homens capazes que temem a Deus: homens de verdade, odiando ganhos injustos; e os colocareis sobre eles, para serem governantes de milhares, governantes de centenas, governantes de cinqüenta e governantes de dezenas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Deixe-os julgar o povo em todos os momentos. Será que cada grande assunto que trouxerem até vós, mas cada pequeno assunto que eles mesmos julgarem. Assim será mais fácil para vocês, e eles compartilharão a carga com vocês. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Se fizerdes isto, e Deus vos ordenar, então podereis suportar, e todas estas pessoas também irão para o seu lugar em paz”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Então Moisés ouviu a voz de seu sogro, e fez tudo o que ele tinha dito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moisés escolheu homens capazes de todo Israel, e os fez cabeças sobre o povo, governantes de milhares, governantes de centenas, governantes de cinqüenta, e governantes de dezenas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Eles julgavam o povo em todos os momentos. Eles levaram os casos difíceis a Moisés, mas cada pequeno assunto que eles julgaram a si mesmos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Moisés deixou seu sogro partir, e foi para sua própria terra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","No terceiro mês após os filhos de Israel terem saído da terra do Egito, nesse mesmo dia eles entraram no deserto do Sinai. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Quando partiram de Rephidim, e chegaram ao deserto do Sinai, acamparam no deserto; e ali Israel acampou diante da montanha. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moisés subiu a Deus, e Javé o chamou para fora da montanha, dizendo: “Isto é o que você dirá à casa de Jacó, e dirá aos filhos de Israel”: ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","'Vocês viram o que eu fiz aos egípcios, e como eu os aborreci nas asas das águias, e os trouxe até mim. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Portanto, agora, se de fato obedecerdes à minha voz e guardardes o meu pacto, então sereis minha própria posse entre todos os povos; pois toda a terra é minha; ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","e sereis para mim um reino de sacerdotes e uma nação santa”. Estas são as palavras que falareis aos filhos de Israel”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moisés veio e chamou os anciãos do povo, e pôs diante deles todas estas palavras que Iavé lhe ordenou. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Todas as pessoas responderam juntas, e disseram: “Tudo o que Javé falou, nós faremos”. Moisés relatou as palavras do povo a Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yahweh disse a Moisés: “Eis que venho a ti numa nuvem espessa, para que o povo possa ouvir quando eu falar contigo, e possa também acreditar em ti para sempre”. Moisés disse as palavras do povo a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Yahweh disse a Moisés: “Ide ao povo, e santificai-os hoje e amanhã, e deixai-os lavar suas vestes, ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","e estejam prontos para o terceiro dia; pois no terceiro dia Yahweh descerá à vista de todo o povo do Monte Sinai. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Você deve estabelecer limites para as pessoas ao redor, dizendo: 'Cuidado para não subir a montanha, nem tocar sua fronteira'. Quem tocar a montanha será certamente morto. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Nenhuma mão lhe tocará, mas ele certamente será apedrejado ou abatido; seja animal ou homem, ele não viverá”. Quando a trombeta soar longa, eles subirão à montanha”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moisés desceu da montanha para o povo, e santificou o povo; e eles lavaram suas roupas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ele disse ao povo: “Estejam prontos até o terceiro dia”. Não tenha relações sexuais com uma mulher”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","No terceiro dia, quando era manhã, havia trovões e relâmpagos, e uma nuvem espessa na montanha, e o som de uma trombeta extremamente alta; e todas as pessoas que estavam no acampamento tremeram. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moisés conduziu o povo para fora do acampamento ao encontro de Deus; e eles ficaram na parte mais baixa da montanha. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Todo o Monte Sinai fumava, porque Javé descia sobre ele em fogo; e sua fumaça subia como a fumaça de uma fornalha, e toda a montanha tremia muito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Quando o som da trombeta cresceu cada vez mais alto, Moisés falou, e Deus lhe respondeu por uma voz. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yahweh desceu no Monte Sinai, até o topo da montanha. Javé chamou Moisés para o topo da montanha, e Moisés subiu. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Yahweh disse a Moisés: “Desça, avise o povo, para que ele não se aproxime de Yahweh para olhar, e muitos deles pereçam. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Let os sacerdotes também, que se aproximam de Iavé, se santificam, para que Iavé não se aproxime deles”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moisés disse a Javé: “O povo não pode subir ao Monte Sinai, pois você nos avisou, dizendo: 'Fixe limites ao redor da montanha e santifique-a'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yahweh disse-lhe: “Vá para baixo! Trará Arão consigo, mas não deixe que os sacerdotes e o povo se separem para subir até Yahweh, para que ele não se revolte contra eles”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Então Moisés foi até o povo e lhes disse. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Deus falou todas estas palavras, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Eu sou Yahweh, vosso Deus, que vos tirei da terra do Egito, da casa da servidão”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Vocês não terão outros deuses diante de mim. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Não fareis para vós mesmos um ídolo, nem qualquer imagem de algo que esteja nos céus acima, ou que esteja na terra abaixo, ou que esteja nas águas debaixo da terra: ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","não vos inclinareis diante deles, nem os servireis, pois eu, Javé vosso Deus, sou um Deus ciumento, visitando a iniqüidade dos pais sobre os filhos, sobre a terceira e quarta geração daqueles que me odeiam, ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","e demonstrando amorosa bondade para com milhares daqueles que me amam e guardam meus mandamentos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Você não usará indevidamente o nome de Javé, seu Deus, pois Javé não o considerará sem culpa quem usar indevidamente seu nome. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Lembre-se do dia de sábado, para mantê-lo santo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Você trabalhará seis dias e fará todo o seu trabalho, ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","mas o sétimo dia é um sábado para Yahweh seu Deus. Não trabalharás nele, nem tu, nem teu filho, nem tua filha, nem teu servo, nem tua serva, nem tua serva, nem teu animal, nem teu estrangeiro que está dentro de tuas portas; ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","pois em seis dias Javé fez o céu e a terra, o mar e tudo o que neles há, e descansou no sétimo dia; portanto Javé abençoou o sábado, e o santificou. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Honre seu pai e sua mãe, para que seus dias sejam longos na terra que Yahweh seu Deus lhe dá. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Você não deve assassinar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Você não cometerá adultério. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Você não deve roubar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Você não deve prestar falso testemunho contra seu próximo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Você não cobiçará a casa de seu vizinho. Não cobiçarás a mulher de teu vizinho, nem seu servo, nem sua criada, nem seu boi, nem seu burro, nem nada que seja de teu vizinho”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Todas as pessoas perceberam os trovões, os relâmpagos, o som da trombeta e o fumo da montanha. Quando as pessoas o viram, tremeram, e ficaram à distância. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Disseram a Moisés: “Fale conosco e nós mesmos escutaremos; mas não deixe Deus falar conosco, para que não morramos”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moisés disse ao povo: “Não tenhais medo, pois Deus veio para vos testar, e que seu temor esteja diante de vós, para que não pequeis”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","O povo ficou à distância, e Moisés se aproximou da escuridão espessa onde Deus estava. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yahweh disse a Moisés: “Isto é o que vocês dirão aos filhos de Israel: 'Vocês mesmos viram que eu falei com vocês do céu'. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Certamente não fareis deuses de prata ou deuses de ouro para vós mesmos estarem ao meu lado”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Fareis um altar de terra para mim, e nele sacrificareis vossos holocaustos e vossas ofertas pacíficas, vossas ovelhas e vosso gado. Em todos os lugares onde eu gravar meu nome, virei até vós e vos abençoarei. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Se me fizerdes um altar de pedra, não o construireis de pedras cortadas; pois se levantardes vossa ferramenta sobre ele, vós o poluístes. ");
INSERT INTO porbrbsl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Não subireis por degraus até meu altar, para que vossa nudez não seja exposta a ele”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Agora estas são as portarias que você deverá apresentar perante eles: ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Se você comprar um servo hebreu, ele servirá seis anos, e no sétimo ele sairá livre sem pagar nada. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","“Se ele entrar sozinho, sairá sozinho. Se ele for casado, então sua esposa sairá com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Se seu amo lhe der uma esposa e ela lhe der filhos ou filhas, a esposa e seus filhos serão de seu amo e ele sairá sozinho. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Mas se o servo disser claramente: 'Eu amo meu senhor, minha esposa e meus filhos'. Não sairei livre; ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","então seu senhor o levará a Deus, e o levará à porta ou ao umbral da porta, e seu senhor lhe furará os ouvidos com uma sovela, e ele o servirá para sempre. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Se um homem vende sua filha para ser uma criada feminina, ela não deve sair como os criados masculinos fazem. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Se ela não agradar ao seu senhor, que casou com ela mesma, então ele a deixará ser redimida. Ele não terá o direito de vendê-la a um povo estrangeiro, uma vez que lidou com ela de forma enganosa. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Se ele a casar com seu filho, ele a tratará como uma filha. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Se ele levar outra esposa para si, não diminuirá sua comida, suas roupas e seus direitos conjugais. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Se ele não fizer essas três coisas por ela, ela poderá ficar livre sem pagar nada. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Aquele que golpeia um homem para que ele morra certamente será morto, ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","mas não se for involuntário, mas Deus permite que isso aconteça; então eu lhe designarei um lugar onde ele fugirá. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Se um homem se intrometer e vier presunçosamente sobre seu próximo para matá-lo, você o tirará de meu altar, para que ele possa morrer. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Qualquer pessoa que atacar seu pai ou sua mãe será certamente condenada à morte. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Qualquer pessoa que rapte alguém e o venda, ou se ele for encontrado em sua mão, certamente será morto. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Qualquer pessoa que amaldiçoe seu pai ou sua mãe certamente será condenada à morte. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Se o homem brigar e um bater no outro com uma pedra, ou com seu punho, e ele não morrer, mas estiver confinado à cama; ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","se ele se levantar novamente e andar por aí com seu bastão, então aquele que o bateu será ilibado; somente ele pagará pela perda de seu tempo, e providenciará sua cura até que ele esteja completamente curado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Se um homem golpear seu criado ou sua empregada com uma vara, e ele morrer sob sua mão, o homem certamente será punido. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Notwithstanding, se seu criado se levantar após um ou dois dias, ele não será punido, pois o criado é de sua propriedade. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Se os homens lutam e ferem uma mulher grávida para que ela dê à luz prematuramente, e ainda assim nenhum mal se segue, ele certamente será multado tanto quanto o marido da mulher exigir e os juízes permitirem. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mas se algum dano se seguir, então você deve tirar a vida pela vida, ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","olho por olho, dente por dente, mão por mão, pé por pé, ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","burning por queimadura, ferida por ferida, e hematoma por hematoma. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Se um homem bater no olho de seu criado, ou no olho de sua empregada, e o destruir, ele o deixará ir livre por causa de seu olho. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Se ele golpear o dente de seu servo masculino, ou o dente de sua empregada, ele deixará o servo ir livre por causa de seu dente. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Se um touro matar um homem ou uma mulher, o touro certamente será apedrejado e sua carne não será comida; mas o proprietário do touro não será responsabilizado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Mas se o touro tinha o hábito de chifrar no passado, e isto foi testemunhado a seu proprietário, e ele não o manteve dentro, mas matou um homem ou uma mulher, o touro será apedrejado, e seu proprietário também será morto. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Se um resgate for imposto a ele, então ele dará pela redenção de sua vida o que quer que seja imposto. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Quer tenha chifrado um filho, quer tenha chifrado uma filha, de acordo com este julgamento será feito a ele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Se o touro chifrar um servo ou uma criada, trinta siclos de prata serão dados ao seu amo, e o boi será apedrejado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Se um homem abre uma fossa, ou se um homem cavar uma fossa e não a cobrir, e um touro ou um burro cair nela, ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","o proprietário da fossa deve torná-la boa. Ele dará dinheiro a seu proprietário, e o animal morto será seu. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Se o touro de um homem ferir o de outro, para que morra, então eles venderão o touro vivo, e dividirão seu preço; e também dividirão o animal morto. ");
INSERT INTO porbrbsl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ou se for sabido que o touro tinha o hábito de chifrar no passado, e seu dono não o manteve dentro, ele certamente pagará touro por touro, e o animal morto será seu próprio animal. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Se um homem rouba um boi ou uma ovelha, e a mata ou vende, pagará cinco bois por um boi, e quatro ovelhas por uma ovelha. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Se o ladrão for encontrado arrombando e for atingido para que morra, não haverá culpa de derramamento de sangue por ele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Se o sol se levantou sobre ele, ele é culpado de derramamento de sangue. Ele deverá fazer a restituição. Se ele não tiver nada, então será vendido por seu roubo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Se o bem roubado for encontrado vivo na mão dele, seja boi, burro ou ovelha, ele pagará o dobro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Se um homem faz com que um campo ou vinhedo seja comido deixando seu animal solto, e ele pasta no campo de outro homem, ele fará a restituição do melhor de seu próprio campo, e do melhor de seu próprio vinhedo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Se o fogo irromper, e pegar em espinhos para que os choques do grão, ou o grão em pé, ou o campo sejam consumidos; aquele que ateou o fogo certamente fará a restituição. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Se um homem entregar ao seu vizinho dinheiro ou coisas para guardar, e for roubado da casa do homem, se o ladrão for encontrado, ele pagará o dobro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Se o ladrão não for encontrado, então o dono da casa se aproximará de Deus, para saber se ele pôs ou não a mão nos bens de seu próximo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Para cada questão de transgressão, seja por boi, por burro, por ovelha, por roupa, ou por qualquer tipo de coisa perdida, sobre a qual se diz: “Isto é meu”, a causa de ambas as partes virá perante Deus. Aquele que Deus condena pagará o dobro a seu próximo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Se um homem entregar ao seu próximo um burro, um boi, uma ovelha ou qualquer animal para guardar, e ele morrer ou for ferido, ou expulso, nenhum homem o verá; ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","o juramento de Javé estará entre ambos, ele não terá colocado sua mão sobre os bens de seu próximo; e seu dono o aceitará, e ele não fará restituição. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Mas se lhe for roubado, aquele que o roubou fará a restituição ao seu proprietário. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Se for despedaçada, deixe-o trazê-la como prova. Ele não deverá reparar o que foi rasgado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Se um homem tomar emprestado algo de seu vizinho, e ele for ferido, ou morrer, seu dono não estiver com ele, ele certamente fará a restituição. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Se seu proprietário estiver com ele, ele não o fará bem. Se for uma coisa alugada, ela veio para seu arrendamento. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Se um homem atrai uma virgem que não se compromete a se casar e se deita com ela, certamente pagará um dote para que ela seja sua esposa. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","If seu pai se recusa totalmente a dá-la a ele, ele pagará dinheiro de acordo com o dote de virgens. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Você não deve permitir que uma feiticeira viva. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Quem fizer sexo com um animal certamente será condenado à morte. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Aquele que se sacrifica a qualquer deus, exceto a Iavé somente, será totalmente destruído. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Você não deve enganar um estrangeiro ou oprimi-lo, pois você foi um estrangeiro na terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Você não deve tirar proveito de nenhuma viúva ou criança sem pai. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Se você se aproveitar deles, e eles chorarem para mim, certamente ouvirei seu grito; ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","e minha ira se acenderá, e eu vos matarei com a espada; e vossas mulheres serão viúvas, e vossos filhos órfãos de pai. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Se você emprestar dinheiro a qualquer um de meu povo com você que é pobre, você não será para ele como credor. Você não lhe cobrará juros. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Se você levar a roupa de seu vizinho como garantia, você a devolverá a ele antes do sol se pôr, ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","pois essa é sua única cobertura, é sua roupa para sua pele. Em que ele dormiria? Acontecerá, quando ele chorar para mim, que eu ouvirei, pois sou gracioso. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Você não blasfemará contra Deus, nem amaldiçoará um governante de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Você não deve demorar a oferecer a partir de sua colheita e da saída de suas prensas. “Você me dará o primogênito de seus filhos”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Você fará o mesmo com seu gado e com suas ovelhas”. Estará com sua mãe sete dias, depois no oitavo dia mo darás”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Vocês serão homens santos para mim, portanto não comerão nenhuma carne que seja rasgada por animais no campo. Vocês a jogarão para os cães. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Você não deve divulgar um relatório falso. Não junte sua mão aos ímpios para ser uma testemunha maliciosa. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Você não deve seguir uma multidão para fazer o mal. Você não testemunhará em tribunal ao lado de uma multidão para perverter a justiça. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","“Não favorecerá um homem pobre em sua causa. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Se você encontrar o boi de seu inimigo ou o burro dele se desviando, certamente o trará de volta para ele novamente. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","“Se você vir o burro dele que o odeia cair sob seu fardo, não o deixe. Você certamente o ajudará com isso. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Você não deve negar justiça a seu pobre povo em seus processos judiciais. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“Mantenha-se longe de uma acusação falsa, e não mate os inocentes e justos; pois eu não justificarei os ímpios. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Você não aceitará suborno, pois um suborno cega aqueles que têm visão e perverte as palavras dos justos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Você não oprimirá um estrangeiro, pois você conhece o coração de um estrangeiro, uma vez que foi um estrangeiro na terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Durante seis anos semearás tua terra, e recolherás em seu aumento, ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","mas no sétimo ano a deixarás descansar e ficar em pousio, para que os pobres de teu povo possam comer; e o que eles deixarem o animal do campo comerá. Da mesma forma, você lidará com seu vinhedo e com seu olival. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Seis dias você fará seu trabalho, e no sétimo dia descansará, para que seu boi e seu burro descansem, e o filho de seu servo, e o estrangeiro possa ser refrescado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Tenha cuidado para fazer todas as coisas que lhe disse; e não invoque o nome de outros deuses ou mesmo deixe que eles sejam ouvidos de sua boca. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Você deverá observar uma festa para mim três vezes ao ano. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Você observará a festa dos pães ázimos. Sete dias comereis pães ázimos, como vos ordenei, na hora marcada no mês de Abibe (pois nele saístes do Egito), e ninguém aparecerá vazio diante de mim. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","E a festa da colheita, os primeiros frutos de vosso trabalho, que semeais no campo; e a festa da colheita, no final do ano, quando vos reunirdes em vosso trabalho fora do campo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Três vezes no ano, todos os seus machos aparecerão perante o Senhor Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Você não oferecerá o sangue do meu sacrifício com pão levedado. A gordura do meu banquete não permanecerá a noite toda até a manhã. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Você trará o primeiro dos primeiros frutos de sua terra para a casa de Yahweh, seu Deus. “Você não deve ferver um cabrito no leite de sua mãe. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Eis que envio um anjo diante de vocês, para mantê-los no caminho e para trazê-los ao lugar que preparei. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Preste atenção nele, e escute sua voz. Não o provoque, pois ele não perdoará sua desobediência, pois meu nome está nele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Mas se você realmente ouvir sua voz, e fizer tudo o que eu falar, então eu serei um inimigo para seus inimigos, e um adversário para seus adversários. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Pois meu anjo irá perante vós, e vos levará ao amorreu, ao hitita, ao perizeu, ao cananeu, ao hivita e ao jebuseu; e eu os cortarei. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Não vos curvareis diante de seus deuses, nem os servireis, nem seguireis suas práticas, mas os derrubareis totalmente e demolireis seus pilares. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Servirás a Javé teu Deus, e ele abençoará teu pão e tua água, e eu tirarei do meio de ti a doença. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ninguém abortará ou será estéril em sua terra. Cumprirei o número de seus dias. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Enviarei meu terror diante de vocês, e confundirei todas as pessoas a quem vocês vêm, e farei com que todos os seus inimigos voltem as costas para vocês. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Enviarei o vespeiro diante de vocês, que expulsará o Hivita, o Canaanita e o Hitita, de diante de vocês. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Não os expulsarei de diante de vocês em um ano, para que a terra não se torne desolada e os animais do campo não se multipliquem contra vocês. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Pouco a pouco os expulsarei de diante de vocês, até que vocês tenham aumentado e herdado a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Fixarei sua fronteira do Mar Vermelho até o mar dos filisteus, e do deserto até o rio; pois eu entregarei os habitantes da terra em suas mãos, e você os expulsará de sua frente. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Não fareis nenhum pacto com eles, nem com seus deuses. ");
INSERT INTO porbrbsl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Eles não habitarão em tua terra, para que não te façam pecar contra mim, pois se servires os deuses deles, isso certamente será um laço para ti”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ele disse a Moisés: “Suba a Yahweh, você e Arão, Nadab, e Abihu, e setenta dos anciãos de Israel; e adore à distância”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Somente Moisés se aproximará de Iavé, mas eles não se aproximarão. O povo não subirá com ele”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moisés veio e disse ao povo todas as palavras de Javé, e todas as ordenanças; e todo o povo respondeu com uma só voz, e disse: “Todas as palavras que Javé disse, nós faremos”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moisés escreveu todas as palavras de Javé, depois levantou-se de manhã cedo e construiu um altar na base da montanha, com doze pilares para as doze tribos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ele enviou jovens das crianças de Israel, que ofereceram holocaustos e sacrificaram ofertas pacíficas de gado a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moisés tomou metade do sangue e o colocou em bacias, e metade do sangue que aspergiu sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ele pegou o livro do pacto e o leu na audiência do povo, e eles disseram: “Faremos tudo o que Javé disse, e seremos obedientes”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moisés tomou o sangue, aspergiu-o sobre o povo e disse: “Olha, este é o sangue do pacto, que Javé fez contigo a respeito de todas estas palavras”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Então Moisés, Arão, Nadab, Abihu, e setenta dos anciãos de Israel subiram. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Eles viram o Deus de Israel. Sob seus pés era como uma obra pavimentada de pedra de safira, como os céus para a claridade. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ele não colocou sua mão sobre os nobres dos filhos de Israel. Eles viram Deus, e comeram e beberam. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yahweh disse a Moisés: “Vem até mim na montanha, e fica aqui, e eu te darei as tábuas de pedra com a lei e os mandamentos que escrevi, para que tu as ensines”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moisés se levantou com Josué, seu servo, e Moisés subiu à Montanha de Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ele disse aos anciãos: “Esperem aqui por nós, até voltarmos a vocês”. Eis que Aarão e Hur estão com vocês”. Quem estiver envolvido em uma disputa pode ir até eles”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moisés subiu na montanha, e a nuvem cobriu a montanha. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","A glória de Yahweh assentou no Monte Sinai, e a nuvem a cobriu durante seis dias. No sétimo dia ele chamou Moisés para fora do meio da nuvem. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","A aparência da glória de Javé era como devorar fogo no topo da montanha aos olhos dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moisés entrou no meio da nuvem e subiu na montanha; e Moisés estava na montanha por quarenta dias e quarenta noites. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yahweh falou com Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Fale com as crianças de Israel, que elas aceitam uma oferta por mim. De todos aqueles cujo coração o faz querer, vocês aceitarão minha oferta. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Esta é a oferenda que você receberá deles: ouro, prata, bronze, ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","azul, roxo, escarlate, linho fino, pêlo de cabra, ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","rams' peles tingidas de vermelho, peles de vaca do mar, madeira de acácia, ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","óleo para a luz, especiarias para o óleo de unção e para o incenso doce, ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","pedras de ônix e pedras a serem colocadas para o éfode e para a couraça. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Let elas fazem de mim um santuário, para que eu possa morar entre elas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","According a tudo o que vos mostro, o padrão do tabernáculo e o padrão de todos os seus móveis, mesmo assim o fareis. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Eles farão uma arca de madeira de acácia. Seu comprimento será de dois cúbitos e meio, sua largura de um cúbito e meio, e um cúbito e meio de sua altura. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","“Cobri-la-ão com ouro puro. Cobri-la-á por dentro e por fora, e fará um molde de ouro em torno dela. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Você deve fundir quatro anéis de ouro para ele, e colocá-los em seus quatro pés. Dois anéis estarão de um lado e dois anéis do outro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Você deve fazer postes de madeira de acácia, e cobri-los com ouro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Você deverá colocar os postes nas argolas dos lados da arca para carregar a arca. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Os postes estarão nos anéis da arca. Eles não serão retirados dela. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Você colocará na arca o pacto que eu lhe darei. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Você deverá fazer um assento de misericórdia de ouro puro. Dois côvados e meio será seu comprimento, e um côvado e meio sua largura. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Você fará dois querubins de ouro martelado. Você deve fazê-los nas duas extremidades do propiciatório. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Faça um querubim em uma extremidade, e um querubim na outra extremidade. Você fará o querubim em suas duas extremidades de uma peça com o propiciatório. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Os querubins estenderão suas asas para cima, cobrindo o propiciatório com suas asas, com seus rostos voltados um para o outro. Os rostos dos querubins devem estar voltados para o propiciatório. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Você colocará o propiciatório em cima da arca, e na arca colocará o pacto que eu lhe darei. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Lá eu me encontrarei com vocês, e lhes direi de cima do propiciatório, de entre os dois querubins que estão na arca do pacto, tudo o que eu lhes ordenarei para os filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Você deve fazer uma mesa de madeira de acácia. Seu comprimento deve ser de dois cúbitos, e sua largura de um côvado, e sua altura de um côvado e meio. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","“Você deverá cobri-la com ouro puro, e fazer uma moldagem de ouro em torno dela. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Você deve fazer uma borda de uma largura de mão em torno dela. Você deve fazer uma moldagem dourada em seu aro ao seu redor. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Você deve fazer quatro anéis de ouro para ele, e colocar os anéis nos quatro cantos que estão em seus quatro pés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Os anéis devem estar próximos ao aro, para os lugares onde os postes podem carregar a mesa. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Você deverá fazer os postes de madeira de acácia, e cobri-los com ouro, para que a mesa possa ser carregada com eles. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Você deverá fazer seus pratos, suas colheres, suas conchas e suas tigelas com as quais poderá derramar oferendas. Fá-los-eis de ouro puro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Colocará sempre o pão da presença sobre a mesa diante de mim. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Você deve fazer um suporte de lâmpada de ouro puro. O suporte da lâmpada deve ser feito de trabalho martelado. Sua base, seu eixo, seus copos, seus botões e suas flores devem ser de uma só peça com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","There será de seis ramos saindo de seus lados: três ramos da lâmpada saem de um lado, e três ramos da lâmpada saem do outro lado; ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","três copos feitos como flores de amêndoa em um ramo, um botão e uma flor; e três copos feitos como flores de amêndoa no outro ramo, um botão e uma flor, assim para os seis ramos que saem do suporte da lâmpada; ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","e no suporte de lâmpada quatro copos feitos como flores de amêndoa, seus botões e suas flores; ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","e um botão sob dois ramos de uma peça com ele, e um botão sob dois ramos de uma peça com ele, e um botão sob dois ramos de uma peça com ele, para os seis ramos que saem do suporte de lâmpada. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Seus botões e seus ramos devem ser de uma só peça com ele, e todos eles um trabalho batido de ouro puro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Você deve fazer suas lâmpadas sete, e elas devem acender suas lâmpadas para dar luz ao espaço à sua frente. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Its Os rapés e seus pratos de rapé devem ser de ouro puro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Será feito de um talento de ouro puro, com todos estes acessórios. ");
INSERT INTO porbrbsl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Veja que você os faça depois de seu padrão, que lhe foi mostrado na montanha. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Além disso, você deve fazer o tabernáculo com dez cortinas de linho fino torcido, azul, roxo e escarlate, com querubim. Você deve fazê-las com o trabalho de um artesão hábil. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","O comprimento de cada cortina será de vinte e oito cúbitos, e a largura de cada cortina de quatro cúbitos: todas as cortinas terão uma medida. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Cinco cortinas devem ser acopladas umas às outras, e as outras cinco cortinas devem ser acopladas umas às outras. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Você deverá fazer laços de azul na borda de uma cortina a partir da borda do acoplamento, e você deverá fazer o mesmo na borda da cortina que está mais externa no segundo acoplamento. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Você deverá fazer cinqüenta laçadas em uma cortina, e você deverá fazer cinqüenta laçadas na borda da cortina que se encontra no segundo acoplamento. Os anéis devem ser opostos entre si. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Você deverá fazer cinqüenta presilhas de ouro, e unir as cortinas uma à outra com as presilhas. O tabernáculo deve ser uma unidade. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Você deve fazer cortinas de cabelo de cabra para uma cobertura sobre o tabernáculo. Você deverá fazer onze cortinas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","O comprimento de cada cortina será de trinta cúbitos, e a largura de cada cortina de quatro cúbitos: as onze cortinas terão uma medida. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Você deve juntar cinco cortinas sozinha, e seis cortinas sozinha, e deve dobrar sobre a sexta cortina na frente da tenda. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Você deve fazer cinqüenta laçadas na borda de uma cortina que está mais externa no acoplamento, e cinqüenta laçadas na borda da cortina que está mais externa no segundo acoplamento. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Você deve fazer cinqüenta presilhas de bronze, e colocar as presilhas nos laços, e unir a tenda, que pode ser uma só. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","A parte saliente que sobra das cortinas das dez cortinas - a meia cortina que sobra - deve pendurar sobre a parte de trás do tabernáculo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","O côvado de um lado e o côvado do outro, do que restar no comprimento das cortinas da tenda, deve pendurar sobre os lados do tabernáculo deste lado e daquele lado, para cobri-lo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Você deve fazer uma cobertura para a tenda de peles de carneiros tingidas de vermelho, e uma cobertura de peles de vacas marinhas acima. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Você deverá fazer as tábuas para o tabernáculo de madeira de acácia, de pé, na vertical. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Dez côvados serão o comprimento de uma tábua, e um côvado e meio a largura de cada tábua. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Haverá dois encaixes em cada tábua, unidos um ao outro: assim você fará para todas as tábuas do tabernáculo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Você fará vinte tábuas para o tabernáculo, para o lado sul, para o sul. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Você fará quarenta bases de prata sob as vinte tábuas; duas bases sob uma tábua para seus dois encaixes, e duas bases sob outra tábua para seus dois encaixes. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Para o segundo lado do tabernáculo, no lado norte, vinte tábuas, ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","e suas quarenta bases de prata; duas bases sob uma tábua, e duas bases sob outra tábua. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Para o outro lado do tabernáculo, no lado oeste, você deve fazer seis tábuas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Você deverá fazer duas tábuas para os cantos do tabernáculo no outro lado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Serão duplas por baixo, e da mesma forma estarão inteiras até seu topo para um anel: assim será para os dois; serão para os dois cantos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Haverá oito tábuas, e suas bases de prata, dezesseis bases; duas bases sob uma tábua, e duas bases sob outra tábua. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Você deve fazer barras de madeira de acácia: cinco para as tábuas de um lado do tabernáculo, ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","e cinco barras para as tábuas do outro lado do tabernáculo, e cinco barras para as tábuas do lado do tabernáculo, para o extremo oeste. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","A travessa central no meio das tábuas deve passar de ponta a ponta. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Você deverá sobrepor as tábuas com ouro, e fazer suas argolas de ouro para os lugares das barras. Você deverá sobrepor as barras com ouro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Você deverá armar o tabernáculo de acordo com a forma que lhe foi mostrada na montanha. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Você deve fazer um véu de azul, e roxo, e escarlate, e linho fino torcido, com querubim. Será o trabalho de um artesão habilidoso. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Você deve pendurá-lo em quatro pilares de acácia revestidos de ouro; seus ganchos devem ser de ouro, em quatro bases de prata. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Você pendurará o véu sob os fechos, e trará a arca do pacto para dentro do véu. O véu separará o lugar santo do lugar santíssimo para você. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Você colocará o propiciatório sobre a arca do pacto no lugar santíssimo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Você colocará a mesa fora do véu, e a lâmpada ficará em frente à mesa do lado do tabernáculo, em direção ao sul. Você deve colocar a mesa no lado norte. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Você deve fazer uma tela para a porta da Tenda, de azul, roxo, e escarlate, e linho fino torcido, o trabalho da bordadeira. ");
INSERT INTO porbrbsl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","“Você deverá fazer para a tela cinco pilares de acácia, e cobri-los com ouro. Seus ganchos devem ser de ouro. Você deve fundir cinco bases de bronze para eles. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Você deve fazer o altar de madeira de acácia, cinco côvados de comprimento e cinco côvados de largura. O altar deve ser quadrado. Sua altura deve ser de três côvados. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Você fará seus chifres em seus quatro cantos. Seus chifres serão de uma só peça com ele. Você o cobrirá com bronze. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Você fará suas panelas para tirar suas cinzas; e suas pás, suas bacias, seus ganchos de carne, e suas panelas de fogo. Você deve fazer todos os seus recipientes de bronze. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Você deve fazer uma grade para ele de rede de bronze. Na rede, você fará quatro anéis de bronze em seus quatro cantos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Debaixo do parapeito ao redor do altar, para que a rede possa chegar à metade do altar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Você fará postes para o altar, postes de madeira de acácia, e os cobrirá com bronze. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Seus mastros serão colocados nos anéis, e os mastros estarão nos dois lados do altar ao carregá-lo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Você deve torná-lo oco com tábuas. Fá-lo-ão como lhe foi mostrado na montanha. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Você fará o pátio do tabernáculo: para o lado sul, haverá enforcamentos para o pátio de linho fino torcido de cem côvados de comprimento para um lado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Its os pilares serão vinte, e suas bases vinte, de bronze. Os ganchos dos pilares e seus filetes devem ser de prata. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Da mesma forma, para o comprimento do lado norte, haverá penduras de cem côvados de comprimento, e seus pilares vinte, e suas bases vinte, de bronze; os ganchos dos pilares, e seus filetes, de prata. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","For a largura da quadra do lado oeste será de cinqüenta côvados; seus pilares dez, e suas bases dez. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","a largura da quadra do lado leste será de cinqüenta côvados. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","As pendurações para um lado do portão serão de quinze côvados; seus pilares três, e suas bases três. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Para o outro lado serão penduras de quinze côvados; suas colunas três, e suas bases três. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Para a porta do pátio será uma tela de vinte côvados, de azul, e roxo, e escarlate, e linho fino torcido, o trabalho do bordador; seus pilares quatro, e suas bases quatro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Todos os pilares da quadra ao redor devem ser preenchidos com prata; seus ganchos de prata e suas soquetes de bronze. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","O comprimento da quadra deve ser de cem côvados, e a largura de cinqüenta por toda a largura, e a altura de cinco côvados, de linho fino torcido, e suas bases de bronze. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Todos os instrumentos do tabernáculo em todos os seus serviços, e todos os seus pinos, e todos os pinos da quadra, devem ser de bronze. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Você ordenará aos filhos de Israel, que lhe tragam azeite de oliva puro batido para a luz, para fazer com que uma lâmpada arda continuamente. ");
INSERT INTO porbrbsl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Na Tenda da Reunião, fora do véu que está diante do pacto, Aarão e seus filhos a manterão em ordem de noite a manhã antes de Yahweh: será um estatuto para sempre através de suas gerações em nome dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Traga Aarão seu irmão, e seus filhos com ele, perto de você, dentre os filhos de Israel, para que ele possa ministrar a mim no escritório do sacerdote: Aarão, com Nadab, Abihu, Eleazar e Ithamar, filhos de Aarão”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Você fará vestes sagradas para Aarão, seu irmão, para glória e beleza. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Falareis a todos os sábios de coração, a quem enchi com o espírito de sabedoria, para que façam as vestes de Aarão para santificá-lo, para que ele possa ministrar a mim no ofício sacerdotal. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Estas são as vestes que farão: uma couraça, um éfode, um manto, uma túnica ajustada, um turbante e uma faixa. Eles farão vestes sagradas para Arão, seu irmão e seus filhos, para que ele possa ministrar a mim no ofício de sacerdote. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Eles usarão o ouro, e o azul, e o roxo, e o escarlate, e o linho fino. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Eles devem fazer o éfode de ouro, azul, roxo, escarlate, e linho fino torcido, o trabalho do habilidoso trabalhador. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Deverá ter duas alças de ombro unidas às duas extremidades, para que possam ser unidas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","A faixa habilmente tecida, que está sobre ela, deve ser como seu trabalho e da mesma peça; de ouro, azul, roxo, escarlate, e linho fino torcido. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Você deverá pegar duas pedras ônix, e gravar nelas os nomes dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Seis de seus nomes em uma pedra, e os nomes dos seis que permanecem na outra pedra, na ordem de seu nascimento. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Com o trabalho de um gravador em pedra, como as gravuras de um selo, você gravará as duas pedras, de acordo com os nomes dos filhos de Israel. Você fará com que elas sejam encerradas em cenários de ouro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Você colocará as duas pedras nas alças do éfode, para serem pedras de memorial para os filhos de Israel. Arão levará seus nomes perante Iavé em seus dois ombros para um memorial. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Você deverá fazer ajustes de ouro, ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","e duas correntes de ouro puro; você as fará como cordas de trabalho trançado. Você colocará as correntes trançadas nos ajustes. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Você fará uma couraça de julgamento, o trabalho do artesão habilidoso; como o trabalho do éfode você o fará; de ouro, de azul, e roxo, e escarlate, e de linho fino torcido, você o fará. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Será quadrado e dobrado duas vezes; um vão será seu comprimento, e um vão sua largura. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","You deverá colocar em seu interior conjuntos de pedras, quatro fileiras de pedras: uma fileira de rubi, topázio e berilo será a primeira fileira; ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","e a segunda fileira uma turquesa, uma safira e uma esmeralda; ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","e a terceira fileira um jacinto, uma ágata e uma ametista; ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","e a quarta fileira um crisólito, um ônix e um jaspe. Eles serão encerrados em ouro em seus ambientes. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","As pedras serão segundo os nomes dos filhos de Israel, doze, segundo seus nomes; como as gravuras de um selo, cada um segundo seu nome, serão para as doze tribos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Você deverá fazer na couraça correntes como cordas, de trançados de ouro puro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Você fará no peitoral dois anéis de ouro, e colocará os dois anéis nas duas extremidades do peitoral. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Você deverá colocar as duas correntes trançadas de ouro nos dois anéis nas extremidades do peitoral. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","As outras duas pontas das duas correntes trançadas você colocará nas duas configurações, e as colocará nas alças do ombro do éfode em sua parte dianteira. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Você fará dois anéis de ouro e os colocará nas duas extremidades da couraça, em sua borda, que está voltada para o lado do éfode para dentro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Você fará dois anéis de ouro, e os colocará sobre as duas alças do éfode, embaixo, em sua parte dianteira, junto ao seu acoplamento, acima da faixa habilmente tecida do éfode. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Eles devem amarrar o peitoral por seus anéis aos anéis do éfode com uma renda azul, para que fique sobre a faixa habilmente tecida do éfode, e para que o peitoral não possa balançar para fora do éfode. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Arão levará os nomes dos filhos de Israel na couraça de julgamento em seu coração, quando entrar no lugar santo, para um memorial diante de Iavé continuamente. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Na couraça do juízo, porás o Urim e o Tumim; e eles estarão no coração de Aarão, quando ele entrar diante de Yahweh. Arão levará o julgamento dos filhos de Israel sobre seu coração diante de Iavé continuamente. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Você deve fazer o manto do éfode todo de azul. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Deverá ter um buraco para a cabeça no meio dele. Terá uma amarração de trabalho tecida ao redor de seu buraco, como se fosse o buraco de uma capa de correio, para que não seja rasgada. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Em sua bainha você deve fazer romãs de azul, e de roxo, e de escarlate, ao redor de sua bainha; com sinos de ouro entre elas e ao redor delas: ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","um sino dourado e uma romã, um sino dourado e uma romã, ao redor da bainha do manto. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Estará em Aarão para ministrar: e seu som será ouvido quando ele entrar no lugar santo antes de Yahweh, e quando ele sair, que ele não morra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Você deverá fazer uma placa de ouro puro, e gravar nela, como as gravuras de um selo, “HOLY TO YAHWEH.” ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Você deverá colocá-la sobre uma renda de azul, e ela deverá estar sobre a faixa. Deverá estar na parte da frente da faixa. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Estará na testa de Arão, e Arão levará a iniqüidade das coisas santas, que os filhos de Israel santificarão em todos os seus santos dons; e estará sempre em sua testa, para que sejam aceitos diante de Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Você tecerá a túnica com linho fino. Você fará um turbante de linho fino. Você fará uma faixa, o trabalho do bordador. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Você deve fazer túnicas para os filhos de Aaron. Você fará faixas para eles. Farás fitas de cabeça para eles, para a glória e para a beleza. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Colocá-las-eis sobre Arão, vosso irmão, e sobre seus filhos com ele, e as ungirás, e as consagrarás, e as santificarás, para que possam ministrar a mim no ofício de sacerdote. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Você os fará calças de linho para cobrir sua carne nua. Chegarão desde a cintura até as coxas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Estarão sobre Aarão e sobre seus filhos, quando entrarem na Tenda da Reunião, ou quando se aproximarem do altar para ministrar no lugar santo, para que não sofram iniqüidade, e morram. Isto será um estatuto para ele e para seus descendentes para sempre, depois dele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Isto é o que você deve fazer com eles para torná-los santos, para ministrar a mim no ofício sacerdotal: pegue um touro jovem e dois carneiros sem defeito, ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","pão ázimo, bolos ázimos misturados com óleo e bolachas ázimos untadas com óleo. Faça-os de farinha de trigo fina. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Você deve colocá-los em uma cesta, e trazê-los na cesta, com o touro e os dois carneiros. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Levarás Arão e seus filhos à porta da Tenda da Reunião, e os lavarás com água. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Pegareis as vestes, e vestireis Arão com a túnica, o manto do éfode, o éfode e a couraça, e o vestireis com a faixa habilmente tecida do éfode. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Você colocará o turbante sobre sua cabeça e colocará a coroa sagrada sobre o turbante. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Então você pegará o óleo da unção, e o derramará sobre sua cabeça, e o ungirá. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Levarás seus filhos, e lhes porás túnicas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Você os vestirá com cintos, Arão e seus filhos, e lhes colocará fitas de amarrar na cabeça. Eles terão o sacerdócio por um estatuto perpétuo. Consagrarás Aarão e seus filhos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Você levará o touro antes da Tenda da Reunião; e Aarão e seus filhos colocarão as mãos sobre a cabeça do touro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","“Você matará o touro antes de Yahweh, na porta da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Você tirará o sangue do touro e o colocará sobre os chifres do altar com seu dedo; e derramará todo o sangue na base do altar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tomarás toda a gordura que cobre as entranhas, a cobertura do fígado, os dois rins e a gordura que está sobre eles, e os queimarás no altar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Mas a carne do touro, e sua pele, e seu esterco, você queimará com fogo fora do acampamento. É uma oferta pelo pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Você também tomará o único carneiro, e Arão e seus filhos colocarão as mãos sobre a cabeça do carneiro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","“Você matará o carneiro, tomará seu sangue e o polvilhará sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Você cortará o carneiro em seus pedaços, e lavará suas entranhas, e suas pernas, e as colocará com seus pedaços, e com sua cabeça. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Você queimará o carneiro inteiro sobre o altar: é uma oferta queimada a Javé; é um aroma agradável, uma oferta feita pelo fogo a Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Você tomará o outro carneiro, e Arão e seus filhos colocarão as mãos sobre a cabeça do carneiro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Então você matará o carneiro, e tomará um pouco de seu sangue, e o colocará na ponta da orelha direita de Aarão, e na ponta da orelha direita de seus filhos, e no polegar da mão direita deles, e no dedo grande do pé direito deles; e espargirá o sangue ao redor do altar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Você tomará do sangue que está sobre o altar, e do óleo da unção, e o espargirá sobre Aarão, e sobre suas vestes, e sobre seus filhos, e sobre as vestes de seus filhos com ele; e ele será santificado, e suas vestes, e seus filhos, e as vestes de seus filhos com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Também tomarás um pouco da gordura do carneiro, a cauda gorda, a gordura que cobre as entranhas, a cobertura do fígado, os dois rins, a gordura que está sobre eles, e a coxa direita (pois é um carneiro de consagração), ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","e um pão, um bolo de pão azeitado e uma hóstia da cesta de pães ázimos que está diante de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Você colocará tudo isso nas mãos de Arão, e nas mãos de seus filhos, e os acenará para uma oferta de onda diante de Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Você os tirará das mãos deles e os queimará no altar sobre o holocausto, para um aroma agradável diante de Iavé: é uma oferta feita pelo fogo a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Você pegará o peito do carneiro de consagração de Aaron, e o acenará para uma oferta de onda antes de Yahweh. Será a sua porção. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Você santificará o peito da oferta de onda e a coxa da oferta de onda, que é ondulada, e que é levantada, do carneiro de consagração, mesmo do que é para Arão, e do que é para seus filhos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Será para Aarão e seus filhos como sua porção para sempre dos filhos de Israel; pois é uma oferta de ondas. Será uma oferta de ondas dos filhos de Israel dos sacrifícios de suas ofertas de paz, até mesmo sua oferta de ondas para Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“As vestes sagradas de Aarão serão para seus filhos depois dele, para serem ungidos nelas, e para serem consagrados nelas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Sete dias o filho que for sacerdote em seu lugar as vestirá, quando entrar na Tenda da Reunião para ministrar no lugar santo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Você deve tomar o carneiro da consagração e ferver sua carne em um lugar sagrado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Arão e seus filhos comerão a carne do carneiro, e o pão que está na cesta, na porta da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Eles comerão as coisas com as quais foi feita a expiação, para consagrá-los e santificá-los; mas um estranho não comerá delas, porque são santas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Se alguma coisa da carne da consagração, ou do pão, ficar para a manhã, então queimarão o restante com fogo. Não será comido, porque é sagrado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Você o fará a Aaron e a seus filhos, de acordo com tudo o que eu lhe ordenei. Consagrá-los-á sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","“Todos os dias você oferecerá o touro da oferta pelo pecado para expiação. Você limpará o altar quando fizer a expiação por ele. Você o ungirá, para santificá-lo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sete dias fará expiação pelo altar, e o santificará; e o altar será santíssimo. Tudo o que tocar o altar será santo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Agora isto é o que você deve oferecer no altar: dois cordeiros por ano, dia após dia, continuamente. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Um cordeiro que você oferecerá pela manhã; e o outro à noite; ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","e com um cordeiro uma décima parte de uma efa de farinha fina misturada com a quarta parte de um lombo de azeite batido, e a quarta parte de um lombo de vinho para uma oferta de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","O outro cordeiro que você oferecerá à noite, e o fará de acordo com a oferta de refeição da manhã e de acordo com sua oferta de bebida, para um aroma agradável, uma oferta feita pelo fogo a Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Será uma oferta queimada contínua através de suas gerações na porta da Tenda de Reunião antes de Yahweh, onde me encontrarei com vocês, para falar-lhes lá. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ali me encontrarei com os filhos de Israel; e o lugar será santificado por minha glória. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Santificarei a Tenda do Encontro e o altar. Santificarei também Aarão e seus filhos para ministrar a mim no ofício de sacerdote. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Habitarei entre os filhos de Israel, e serei seu Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Eles saberão que eu sou Yahweh seu Deus, que os tirei da terra do Egito, para que eu possa habitar entre eles: Eu sou Yahweh, o Deus deles. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Você deve fazer um altar para queimar incenso. Você deve fazer de madeira de acácia. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Seu comprimento será de um côvado, e sua largura de um côvado. Será quadrado, e sua altura será de dois côvados. Seus chifres serão de uma só peça com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Cobri-la-á com ouro puro, seu topo, seus lados ao seu redor e seus chifres; e fará uma moldagem de ouro ao seu redor. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Você fará dois anéis de ouro para ele sob sua moldagem; em suas duas costelas, em seus dois lados você os fará; e eles serão para lugares para postes com os quais o suportará. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Você fará os postes de madeira de acácia, e os cobrirá com ouro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","O colocareis diante do véu que está junto à arca do pacto, diante do assento de misericórdia que está sobre o pacto, onde eu me encontrarei convosco. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aarão queimará incenso de especiarias doces sobre ele todas as manhãs. Quando ele cuidar das lâmpadas, ele as queimará. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Quando Aaron acender as lâmpadas à noite, ele o queimará, um incenso perpétuo diante de Yahweh através de suas gerações. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Você não oferecerá sobre ele incenso estranho, nem holocausto, nem oferta de refeição; e não derramará sobre ele oferta de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Arão fará expiação em seus chifres uma vez no ano; com o sangue da oferta pelo pecado da expiação uma vez no ano, fará expiação por ela através de vossas gerações. É santíssimo para Yahweh”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Javé falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Quando você fizer um censo dos filhos de Israel, de acordo com aqueles que são contados entre eles, então cada homem dará um resgate por sua alma a Javé quando os contar, para que não haja peste entre eles quando os contar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Eles darão isto, todos os que passarem para aqueles que forem contados, meio siclo de acordo com o siclo do santuário (o siclo é de vinte gerahs); meio siclo por uma oferta a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Todos que passarem para aqueles que são contados, a partir de vinte anos de idade, darão a oferenda a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Os ricos não darão mais, e os pobres não darão menos, do que o meio siclo, quando derem a oferta de Yahweh, para fazer expiação por suas almas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Tomareis o dinheiro da expiação dos filhos de Israel, e o designareis para o serviço da Tenda da Reunião; que possa ser um memorial para os filhos de Israel perante Iavé, para fazer expiação por vossas almas”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yahweh falou com Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Você também fará uma bacia de bronze, e sua base de bronze, na qual se deve lavar. Você a colocará entre a Tenda da Reunião e o altar, e nela colocará água. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Arão e seus filhos lavarão suas mãos e seus pés nela. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Quando entrarem na Tenda da Reunião, lavarão com água, para não morrer; ou quando se aproximarem do altar para ministrar, para queimar uma oferta feita pelo fogo a Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Assim, lavarão as mãos e os pés, para que não morram. Isto será um estatuto para eles para sempre, até mesmo para ele e para seus descendentes através de suas gerações”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Além disso Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Também tome especiarias finas: de mirra líquida, quinhentos shekels; e de canela perfumada pela metade, até duzentos e cinqüenta; e de cana perfumada, duzentos e cinqüenta; ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","e de cássia quinhentos, de acordo com o siclo do santuário; e um hin de azeite de oliva. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Você o transformará em um óleo sagrado da unção, um perfume composto segundo a arte do perfumista: será um óleo sagrado da unção. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Você deverá usá-lo para ungir a Tenda da Reunião, a arca da aliança, ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","a mesa e todos os seus artigos, o suporte de lâmpada e seus acessórios, o altar do incenso, ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","o altar do holocausto com todos os seus utensílios, e a bacia com sua base. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","santificá-los-eis, para que sejam santíssimos. Tudo o que os tocar será sagrado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","ungirás Aarão e seus filhos, e os santificarás, para que possam ministrar-me no ofício sacerdotal. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Falareis aos filhos de Israel, dizendo: “Este será para mim um óleo sagrado de unção através de vossas gerações”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Não será derramado sobre a carne do homem e não fará nenhum semelhante, de acordo com sua composição. Ele é sagrado. Será santo para vós. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Quem quer que compõe algo parecido, ou quem quer que coloque algo parecido em um estranho, será cortado de seu povo'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yahweh disse a Moisés: “Tome para si especiarias doces, resina de goma, onycha e gálbano: especiarias doces com puro incenso. Haverá um peso igual de cada uma. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Você deve fazer dele um incenso, um perfume segundo a arte do perfumista, temperado com sal, puro e santo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Você deve bater um pouco dele muito pequeno, e colocar um pouco dele antes do convênio na Tenda da Reunião, onde eu me encontrarei com você. Será para vocês muito santo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Não fareis este incenso, de acordo com sua composição, para vós mesmos: ele vos será sagrado para Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Quem quer que faça algo assim, para cheirá-lo, será cortado de seu povo”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Eis que chamei pelo nome Bezalel o filho de Uri, o filho de Hur, da tribo de Judá. ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Eu o enchi com o Espírito de Deus, na sabedoria, na compreensão, no conhecimento e em todo tipo de obra, ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","para conceber trabalhos hábeis, para trabalhar em ouro, em prata e em bronze, ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","e no corte de pedras para fixar, e no entalhe de madeira, para trabalhar em todo tipo de obra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Eis que eu mesmo nomeei com ele Oholiab, o filho de Ahisamach, da tribo de Dan; e no coração de todos os sábios, coloquei sabedoria, para que façam tudo o que lhes ordenei: ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","a Tenda da Reunião, a arca do convênio, o assento de misericórdia que está sobre ela, todos os móveis da Tenda, ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","a mesa e seus vasos, o suporte de lâmpada pura com todos os seus vasos, o altar de incenso, ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","o altar de holocausto com todos os seus vasos, a bacia e sua base, ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","as vestes finamente trabalhadas - as vestes sagradas para Arão, o sacerdote, as vestes de seus filhos para ministrar no escritório do sacerdote - ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","o óleo de unção, e o incenso de especiarias doces para o lugar santo: de acordo com tudo o que eu lhe ordenei, eles farão.” ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Javé falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ Fale também aos filhos de Israel, dizendo: “Certamente guardareis meus sábados; pois é um sinal entre mim e vós ao longo de vossas gerações, para que saibais que eu sou o Javé que vos santifica. ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Portanto, guardareis o sábado, pois ele é sagrado para vós. Todo aquele que o profanar será certamente morto; pois quem nele fizer algum trabalho, essa alma será extirpada do meio de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Seis dias de trabalho serão cumpridos, mas no sétimo dia é um sábado de descanso solene, santo para Javé. Quem quer que faça qualquer trabalho no dia do sábado certamente será morto. ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Therefore os filhos de Israel guardarão o Sábado, para observar o Sábado ao longo de suas gerações, para um pacto perpétuo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","É um sinal entre mim e os filhos de Israel para sempre; pois em seis dias Javé fez o céu e a terra, e no sétimo dia descansou, e se refrescou”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Quando terminou de falar com ele no Monte Sinai, ele deu a Moisés as duas tábuas do pacto, tábuas de pedra, escritas com o dedo de Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Quando o povo viu que Moisés demorou a descer da montanha, o povo se reuniu a Arão e lhe disse: “Vem, faze-nos deuses, que irão adiante de nós; pois quanto a este Moisés, o homem que nos tirou da terra do Egito, não sabemos o que aconteceu com ele”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron disse-lhes: “Tirem os anéis dourados, que estão nos ouvidos de suas esposas, de seus filhos e de suas filhas, e tragam-mos até mim”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Todas as pessoas tiraram os anéis dourados que estavam em seus ouvidos, e os trouxeram para Aaron. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ele recebeu o que lhe entregaram, moldou-o com uma ferramenta de gravação e fez dele um bezerro moldado. Depois disseram: “Estes são seus deuses, Israel, que o trouxeram para fora da terra do Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Quando Aaron viu isto, construiu um altar diante dele; e Aaron fez uma proclamação, e disse: “Amanhã será uma festa para Yahweh”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Eles se levantaram cedo no dia seguinte, ofereceram holocaustos e trouxeram ofertas de paz; e as pessoas se sentaram para comer e beber, e se levantaram para brincar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Yahweh falou a Moisés: “Vai, desce; pois seu povo, que você criou fora da terra do Egito, se corrompeu! ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Eles se afastaram rapidamente do caminho que eu lhes ordenei. Fizeram para si um bezerro moldado, adoraram-no e se sacrificaram a ele, e disseram: “Estes são os vossos deuses, Israel, que vos fizeram subir da terra do Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Yahweh disse a Moisés: “Eu vi estas pessoas, e eis que são um povo de pescoço duro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Agora, portanto, deixai-me em paz, para que minha ira arda contra eles, e para que eu os consuma; e eu farei de vós uma grande nação”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moisés implorou a Javé seu Deus, e disse: “Javé, por que sua ira arde contra seu povo, que você tirou da terra do Egito com grande poder e com uma mão poderosa? ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Por que os egípcios deveriam falar, dizendo: “Ele os trouxe para fora para o mal, para matá-los nas montanhas, e para consumi-los da superfície da terra? Vire-se de sua ira feroz, e afaste-se deste mal contra seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Lembre-se de Abraão, Isaac e Israel, seus servos, a quem você jurou por si mesmo, e lhes disse: 'Multiplicarei a sua prole como as estrelas do céu, e toda esta terra de que falei darei à sua prole, e eles a herdarão para sempre'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Então Yahweh se afastou do mal que ele disse que faria ao seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moisés virou-se, e desceu da montanha, com as duas tábuas do pacto na mão; tábuas que estavam escritas de ambos os lados. Elas foram escritas de um lado e do outro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","As tábuas eram obra de Deus, e a escrita era a escrita de Deus, gravada nas tábuas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Quando Josué ouviu o barulho do povo enquanto gritavam, disse a Moisés: “Há o barulho da guerra no acampamento”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ele disse: “Não é a voz daqueles que gritam por vitória. Não é a voz daqueles que clamam por ser vencidos; mas o barulho daqueles que cantam que eu ouço”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Assim que chegou perto do acampamento, ele viu o bezerro e a dança. Então a raiva de Moisés esquentou, e ele jogou as tábuas fora de suas mãos, e as quebrou sob a montanha. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ele pegou o bezerro que eles tinham feito, queimou-o com fogo, moeu-o em pó e o espalhou sobre a água, e fez as crianças de Israel bebê-lo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moisés disse a Aaron: “O que essas pessoas fizeram com você, que você trouxe um grande pecado sobre eles”? ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron disse: “Não deixe a raiva de meu senhor esquentar”. Vocês conhecem o povo, que está voltado para o mal. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Pois eles me disseram: 'Faça-nos deuses, que irão adiante de nós'. Quanto a este Moisés, o homem que nos tirou da terra do Egito, não sabemos o que aconteceu com ele”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Eu lhes disse: 'Quem tiver ouro, que o tire'. Então eles mo deram; e eu o joguei no fogo, e saiu este bezerro”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Quando Moisés viu que o povo estava fora de controle, (pois Aaron os havia deixado perder o controle, causando zombaria entre seus inimigos), ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","então Moisés ficou no portão do acampamento, e disse: “Quem estiver do lado de Javé, venha até mim”! Todos os filhos de Levi se reuniram a ele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ele lhes disse: “Yahweh, o Deus de Israel, diz: 'Cada homem põe sua espada na coxa, e vai e vem de porta em porta por todo o campo, e cada homem mata seu irmão, e cada homem seu companheiro, e cada homem seu próximo'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Os filhos de Levi fizeram de acordo com a palavra de Moisés. Cerca de três mil homens caíram do povo naquele dia. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moisés disse: “Consagrai-vos hoje a Javé, pois cada homem foi contra seu filho e contra seu irmão, para que ele vos dê hoje uma bênção”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","No dia seguinte, Moisés disse ao povo: “Vocês pecaram um grande pecado”. Agora eu irei até Yahweh. Talvez eu faça expiação por seu pecado”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moisés voltou a Iavé e disse: “Oh, este povo pecou um grande pecado e se fez deuses de ouro”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mas agora, se você quiser, perdoe o pecado deles - e se não, por favor, tire-me de seu livro que você escreveu”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yahweh disse a Moisés: “Quem quer que tenha pecado contra mim, eu o apagarei do meu livro”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Agora vá, conduza o povo ao lugar de que lhe falei”. Eis que meu anjo irá diante de vós. No entanto, no dia em que eu castigar, castigá-los-ei por seu pecado”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Yahweh atingiu o povo, por causa do que eles fizeram com o bezerro, que Arão fez. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yahweh falou a Moisés: “Parta, suba daqui, você e o povo que você criou da terra do Egito, para a terra da qual eu jurei a Abraão, a Isaac e a Jacó, dizendo: 'Eu o darei à sua descendência'. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Enviarei um anjo diante de vocês; e expulsarei os cananeus, os amorreus, e os hititas, e os perizeus, os hivitas, e os jebuseus. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ide a uma terra que flui com leite e mel; mas não subirei entre vós, pois sois um povo de pescoço duro, para que eu não vos consuma no caminho”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Quando as pessoas ouviram esta má notícia, lamentaram; e ninguém colocou suas jóias. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yahweh havia dito a Moisés: “Diga aos filhos de Israel: 'Vocês são um povo de pescoço duro'. Se eu subisse entre vocês por um momento, eu os consumiria”. Portanto, agora tirem suas jóias de vocês, para que eu possa saber o que fazer com vocês””. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","As crianças de Israel se despojaram de suas jóias do Monte Horeb em diante. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Agora Moisés costumava pegar a tenda e armá-la fora do acampamento, longe do acampamento, e ele a chamava de “A Tenda do Encontro”. Todos que procuravam Yahweh saíam para a Tenda do Encontro, que ficava fora do acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Quando Moisés saiu para a Tenda, todo o povo se levantou e ficou de pé, todos à porta de sua tenda, e observou Moisés, até que ele entrasse na Tenda. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Quando Moisés entrou na Tenda, a coluna de nuvem desceu, ficou à porta da Tenda, e Yahweh falou com Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Todas as pessoas viram a coluna de nuvem ficar à porta da Tenda, e todas as pessoas se levantaram e adoraram, todas à porta de suas tendas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Javé falou com Moisés cara a cara, como um homem fala com seu amigo. Ele se transformou novamente no acampamento, mas seu servo Josué, o filho de Freira, um jovem, não se afastou da Tenda. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moisés disse a Javé: “Eis que me dizes: 'Trazei este povo'; e não me deixastes saber quem enviareis comigo. Mas você disse: 'Conheço você pelo nome, e você também encontrou um favor na minha vista'. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Agora, portanto, se eu encontrei favor à sua vista, mostre-me seu caminho, agora, para que eu possa conhecê-lo, para que eu possa encontrar favor à sua vista; e considere que esta nação é seu povo”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ele disse: “Minha presença irá com você, e eu lhe darei descanso”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moisés lhe disse: “Se sua presença não for comigo, não nos carregue daqui para cima. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Pois como as pessoas saberiam que encontrei favor em sua vista, eu e seu povo? Não é que você vai conosco, para que estejamos separados, eu e seu povo, de todas as pessoas que estão na superfície da terra”? ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yahweh disse a Moisés: “Eu farei isto também que você falou; pois você encontrou favor à minha vista, e eu o conheço pelo nome”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moisés disse: “Por favor, mostre-me sua glória”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ele disse: “Farei passar toda a minha bondade diante de vocês e proclamarei o nome de Javé diante de vocês”. Eu serei gracioso para com quem eu for gracioso, e terei misericórdia de quem eu for misericordioso”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ele disse: “Você não pode ver meu rosto, pois o homem pode não me ver e viver”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Yahweh também disse: “Eis que há um lugar ao meu lado, e tu estarás sobre a rocha”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Acontecerá, enquanto minha glória passar, que eu te colocarei numa fenda da rocha, e te cobrirei com minha mão até que eu tenha passado; ");
INSERT INTO porbrbsl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","então tirarei minha mão, e verás minhas costas; mas meu rosto não será visto”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yahweh disse a Moisés: “Cinzel duas tábuas de pedra como a primeira. Vou escrever nas tábuas as palavras que estavam nas primeiras tábuas, que você quebrou. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Esteja pronto pela manhã, e suba pela manhã ao Monte Sinai, e apresente-se a mim lá no topo da montanha. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ninguém deve subir com você ou ser visto em qualquer lugar da montanha. Não deixe os rebanhos ou rebanhos pastarem em frente a essa montanha”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ele esculpiu duas tábuas de pedra como a primeira; depois Moisés levantou-se cedo pela manhã e subiu ao Monte Sinai, como Yahweh lhe havia ordenado, e tomou na mão duas tábuas de pedra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yahweh desceu na nuvem, e ficou com ele lá, e proclamou o nome de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Iavé passou diante dele e proclamou: “Iavé! Javé, um Deus misericordioso e gracioso, lento na ira e abundante em bondade amorosa e verdade, ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","mantendo bondade amorosa para milhares, perdoando a iniqüidade e a desobediência e o pecado; e que de modo algum limpará os culpados, visitando a iniqüidade dos pais sobre os filhos, e sobre os filhos dos filhos, sobre a terceira e a quarta geração”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moisés apressou-se e inclinou a cabeça em direção à terra, e adorou. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ele disse: “Se agora encontrei graça aos teus olhos, Senhor, por favor deixa o Senhor ir entre nós, ainda que este seja um povo de pescoço duro; perdoa nossa iniqüidade e nosso pecado, e toma-nos por tua herança”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ele disse: “Eis que faço um pacto: diante de todo o vosso povo farei maravilhas, tais como não ter sido trabalhado em toda a terra, nem em nenhuma nação; e todas as pessoas entre as quais vós estais verão o trabalho de Iavé; pois é uma coisa maravilhosa que faço convosco. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Observem o que eu lhes ordeno hoje. Eis que expulsarei diante de vós o Amorreu, o Cananeu, o Hitita, o Perizeu, o Hivita e o Jebuseu. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Cuidado, para que não faças um pacto com os habitantes da terra para onde vais, para que não seja por um laço entre vós; ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","mas derrubarás seus altares, e despedaçarás seus pilares, e cortarás seus bastões de Cinzas; ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","pois não adorarás outro deus; pois Javé, cujo nome é Jealous, é um Deus ciumento. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Não faça um pacto com os habitantes da terra, para que eles não se prostituam após seus deuses, e se sacrifiquem a seus deuses, e um chama você e você come de seu sacrifício; ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","e você leva de suas filhas para seus filhos, e suas filhas se prostituem após seus deuses, e faz com que seus filhos se prostituam após seus deuses. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Vocês não devem fazer ídolos de elenco para vocês mesmos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Você deverá manter a festa dos pães ázimos. Sete dias comereis pães ázimos, como vos ordenei, na hora marcada no mês de Abibe; pois no mês de Abibe saístes do Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Tudo o que abre o útero é meu; e todo o seu gado que é macho, o primogênito de vacas e ovelhas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Você deve resgatar o primogênito de um burro com um cordeiro. Se você não o resgatar, então você deve quebrar seu pescoço. Você deverá resgatar todos os primogênitos de seus filhos. Ninguém aparecerá vazio diante de mim. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Seis dias você trabalhará, mas no sétimo dia você descansará: no tempo de arado e na colheita você descansará. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Você deve observar a festa das semanas com os primeiros frutos da colheita do trigo, e a festa da colheita no final do ano. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Três vezes no ano todos os seus machos comparecerão perante o Senhor Javé, o Deus de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Pois eu expulsarei as nações diante de vós e alargarei as vossas fronteiras; nenhum homem desejará a vossa terra quando subirem para comparecer perante o Senhor Javé, vosso Deus, três vezes no ano. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Você não oferecerá o sangue do meu sacrifício com pão levedado. O sacrifício da festa da Páscoa não será deixado para a manhã. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Você trará o primeiro dos primeiros frutos de sua terra para a casa de Yahweh, seu Deus. “Você não deve ferver um cabrito no leite de sua mãe”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yahweh disse a Moisés: “Escreve estas palavras; pois de acordo com estas palavras fiz um pacto contigo e com Israel”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ele esteve lá com Javé por quarenta dias e quarenta noites; não comeu pão, nem bebeu água. Ele escreveu nas tábuas as palavras do convênio, os dez mandamentos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Quando Moisés desceu do Monte Sinai com as duas tábuas do pacto na mão de Moisés, quando desceu da montanha, Moisés não sabia que a pele de seu rosto brilhava em razão de ter falado com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Quando Aarão e todos os filhos de Israel viram Moisés, eis que a pele de seu rosto brilhou; e tiveram medo de se aproximar dele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moisés chamou-os, e Arão e todos os dirigentes da congregação voltaram a ele; e Moisés falou com eles. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Depois disso, todos os filhos de Israel se aproximaram, e ele lhes deu todos os mandamentos que Javé havia falado com ele no Monte Sinai. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Quando Moisés terminou de falar com eles, colocou um véu em seu rosto. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Mas quando Moisés entrou antes de Iavé para falar com ele, tirou o véu, até sair; e saiu, e falou aos filhos de Israel o que lhe foi ordenado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Os filhos de Israel viram o rosto de Moisés, que a pele do rosto de Moisés brilhava; então Moisés colocou o véu em seu rosto novamente, até que entrou para falar com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moisés reuniu toda a congregação dos filhos de Israel e disse-lhes: “Estas são as palavras que Javé ordenou, que vocês as façam”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","'Seis dias de trabalho serão feitos, mas no sétimo dia haverá um dia santo para vocês, um sábado de descanso solene para Javé: quem quer que faça qualquer trabalho nele será condenado à morte. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Não ateareis fogo em vossas habitações no dia de sábado'”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moisés falou a toda a congregação dos filhos de Israel, dizendo: “Isto é o que Javé ordenou, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","'Recebam de entre vós uma oferta a Javé. Quem tiver um coração disposto, que o traga como oferenda de Javé: ouro, prata, bronze, ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","azul, roxo, escarlate, linho fino, pêlo de cabra, ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","rams' peles tingidas de vermelho, peles de vaca do mar, madeira de acácia, ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","óleo para a luz, especiarias para o óleo de unção e para o incenso doce, ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","pedras de ônix e pedras a serem colocadas para o éfode e para a couraça. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“'Deixem vir todo homem sábio entre vocês, e façam tudo o que Yahweh ordenou: ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","o tabernáculo, sua cobertura exterior, seu teto, seus fechos, suas tábuas, suas barras, seus pilares e suas bases; ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","a arca, e seus postes, o banco da misericórdia, o véu da tela; ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","a mesa com seus postes e todas as suas vasilhas, e o pão do show; ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","o suporte da lâmpada também para a luz, com seus vasos, suas lâmpadas e o óleo para a luz; ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","e o altar do incenso com seus postes, o óleo da unção, o incenso doce, a tela para a porta, na porta do tabernáculo; ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","o altar de holocausto, com sua grade de bronze, seus postes e todos os vasos, a bacia e sua base; ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","as dependências do tribunal, seus pilares, suas bases e a tela para a porta do tribunal; ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","os alfinetes do tabernáculo, os alfinetes do tribunal e suas cordas; ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","as vestes finamente trabalhadas para ministrar no lugar santo - as vestes sagradas para Arão, o sacerdote, e as vestes de seus filhos - para ministrar no ofício sacerdotal.’” ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Toda a congregação das crianças de Israel partiu da presença de Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Eles vieram, todos cujo coração o despertou, e todos que seu espírito se dispôs a isso, e trouxeram a oferta de Javé pelo trabalho da Tenda do Encontro, e por todo o seu serviço, e pelas vestes sagradas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Eles vieram, tanto homens como mulheres, tantos quantos eram de bom coração, e trouxeram broches, brincos, anéis de sinalização e pulseiras, todas jóias de ouro; até mesmo todos os homens que ofereceram uma oferta de ouro a Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Todos com quem foi encontrado azul, roxo, escarlate, linho fino, cabelo de cabra, peles de carneiros tingidas de vermelho, e peles de vaca do mar, os trouxeram. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Todos que ofereceram uma oferta de prata e bronze trouxeram a oferta de Yahweh; e todos com quem foi encontrada madeira de acácia para qualquer trabalho do serviço, trouxeram-na. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Todas as mulheres que foram sabiamente fiadas com as mãos, e trouxeram aquilo que tinham fiado: o azul, o roxo, o escarlate, e o linho fino. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Todas as mulheres cujo coração as agitava com sabedoria fiaram o cabelo das cabras. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","As réguas trouxeram as pedras ônix e as pedras a serem colocadas para o éfode e para a couraça; ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","com o tempero e o óleo para a luz, para o óleo de unção e para o incenso doce. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Os filhos de Israel trouxeram uma oferta de livre vontade a Javé; todo homem e mulher cujo coração os fez dispostos a trazer para todo o trabalho, que Javé havia ordenado que fosse feito por Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moisés disse aos filhos de Israel: “Eis que Javé chamou pelo nome Bezalel o filho de Uri, o filho de Hur, da tribo de Judá. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Ele o encheu do Espírito de Deus, na sabedoria, no entendimento, no conhecimento e em todo tipo de obra; ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","e para fazer trabalhos hábeis, para trabalhar em ouro, em prata, em bronze, ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","no corte de pedras para fixar, e no entalhe de madeira, para trabalhar em todo tipo de obra hábeis. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ele colocou em seu coração para ensinar, tanto ele como Oholiab, o filho de Ahisamach, da tribo de Dan. ");
INSERT INTO porbrbsl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ele os encheu de sabedoria de coração para trabalhar em todos os tipos de artesanato, do gravador, do habilidoso trabalhador e da bordadeira, de azul, roxo, escarlate e linho fino, e do tecelão, mesmo daqueles que fazem qualquer trabalho, e daqueles que fazem trabalhos habilidosos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Bezalel e Oholiab trabalharão com todo homem sábio, em quem Javé colocou sabedoria e compreensão para saber fazer todo o trabalho para o serviço do santuário, de acordo com tudo o que Javé ordenou”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moisés chamou Bezalel e Oholiab, e todo homem sábio, em cujo coração Javé tinha colocado sabedoria, até mesmo todos cujo coração o agitava para vir ao trabalho para fazê-lo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Eles receberam de Moisés toda a oferta que os filhos de Israel haviam trazido para a obra do serviço do santuário, com a qual o faziam. Eles continuavam trazendo ofertas de livre vontade a ele todas as manhãs. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Todos os sábios, que executaram todo o trabalho do santuário, cada um veio de seu trabalho que ele fez. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Eles falaram com Moisés, dizendo: “O povo trouxe muito mais do que o suficiente para o serviço da obra que Javé mandou fazer”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Moisés deu um mandamento, e eles fizeram com que ele fosse proclamado em todo o campo, dizendo: “Que nem o homem nem a mulher façam outra coisa pela oferta para o santuário”. Assim, o povo foi impedido de trazer. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Pelo material que tinham era suficiente para fazer todo o trabalho, e demais. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Todos os homens de coração sábio entre aqueles que fizeram o trabalho fizeram o tabernáculo com dez cortinas de linho fino torcido, azul, roxo e escarlate. Eles os fizeram com querubins, o trabalho de um artesão habilidoso. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","O comprimento de cada cortina era de vinte e oito cúbitos, e a largura de cada cortina de quatro cúbitos. Todas as cortinas tinham uma medida. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ele acoplou cinco cortinas umas às outras, e as outras cinco cortinas ele acoplou umas às outras. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ele fez laçadas de azul na borda de uma cortina a partir da borda do acoplamento. Da mesma forma, ele fez na borda da cortina que estava mais externa no segundo acoplamento. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ele fez cinqüenta voltas na borda de uma cortina, e fez cinqüenta voltas na borda da cortina que estava no segundo acoplamento. As alças eram opostas umas às outras. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ele fez cinqüenta presilhas de ouro, e acoplou as cortinas umas às outras com as presilhas: assim, o tabernáculo era uma unidade. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ele fez cortinas de cabelo de cabra para uma cobertura sobre o tabernáculo. Ele as fez onze cortinas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","O comprimento de cada cortina era de trinta cúbitos, e quatro cúbitos a largura de cada cortina. As onze cortinas tinham uma medida. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ele acoplou cinco cortinas por si só, e seis cortinas por si só. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ele fez cinqüenta laçadas na borda da cortina que estava mais externa no acoplamento, e fez cinqüenta laçadas na borda da cortina que estava mais externa no segundo acoplamento. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ele fez cinqüenta presilhas de bronze para unir a tenda, para que ela pudesse ser uma unidade. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ele fez uma cobertura para a tenda de peles de carneiros tingidas de vermelho, e uma cobertura de peles de vaca do mar acima. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ele fez as tábuas para o tabernáculo de madeira de acácia, de pé. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Dez côvados era o comprimento de uma tábua, e um côvado e meio da largura de cada tábua. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Cada tábua tinha duas tábua, unidas uma à outra. Ele fez todas as tábuas do tabernáculo desta maneira. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ele fez as tábuas para o tabernáculo, vinte tábuas para o lado sul. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ele fez quarenta bases de prata sob as vinte tábuas: duas bases sob uma tábua para seus dois encaixes, e duas bases sob outra tábua para seus dois encaixes. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Para o segundo lado do tabernáculo, no lado norte, ele fez vinte tábuas ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","e suas quarenta bases de prata: duas bases debaixo de uma tábua, e duas bases debaixo de outra tábua. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Para a parte mais distante do tabernáculo, no lado oeste, ele fez seis tábuas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Ele fez duas tábuas para os cantos do tabernáculo, na parte mais distante. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Estavam dobradas por baixo e, da mesma forma, estavam até o topo do tabernáculo com um anel. Ele fez isso com as duas nos dois cantos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Havia oito placas e suas soquetes de prata, dezesseis soquetes - sob cada placa duas soquetes. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ele fez barras de madeira de acácia: cinco para as tábuas de um lado do tabernáculo, ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","e cinco barras para as tábuas do outro lado do tabernáculo, e cinco barras para as tábuas do tabernáculo para a parte de trás para o oeste. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ele fez a barra do meio para passar no meio das tábuas de uma extremidade à outra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ele cobriu as tábuas com ouro, e fez seus anéis de ouro como lugares para as barras, e cobriu as barras com ouro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ele fez o véu de azul, roxo, escarlate, e linho fino torcido, com querubim. Ele fez dele o trabalho de um artesão habilidoso. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ele fez quatro pilares de acácia para ele, e os revestiu com ouro. Seus ganchos eram de ouro. Ele lançou quatro soquetes de prata para eles. ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ele fez uma tela para a porta da tenda, de azul, roxo, escarlate e linho fino torcido, obra de um bordador; ");
INSERT INTO porbrbsl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","e os cinco pilares da mesma com seus ganchos. Ele cobriu suas capitéis e seus filetes com ouro, e suas cinco bases eram de bronze. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel fez a arca de madeira de acácia. Seu comprimento era de dois côvados e meio, e sua largura de um côvado e meio, e um côvado e meio de sua altura. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ele a revestiu com ouro puro por dentro e por fora, e fez uma moldagem de ouro para ela ao seu redor. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ele fundiu quatro anéis de ouro para ele em seus quatro pés-dois anéis de um lado, e dois anéis do outro lado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ele fez postes de madeira de acácia e os revestiu com ouro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ele colocou os postes nos anéis dos lados da arca, para suportar a arca. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ele fez um assento de misericórdia de ouro puro. Seu comprimento era de dois cúbitos e meio, e um côvado e meio de sua largura. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ele fez dois querubins de ouro. Ele os fez de trabalho batido, nas duas extremidades do propiciatório: ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","um querubim em uma extremidade, e um querubim na outra extremidade. Ele fez o querubim de uma peça com o propiciatório em suas duas extremidades. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","O querubim estendeu suas asas acima, cobrindo o propiciatório com suas asas, com seus rostos voltados um para o outro. Os rostos dos querubins estavam voltados para o propiciatório. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ele fez a mesa de madeira de acácia. Seu comprimento era de dois cúbitos, e sua largura de um côvado, e sua altura de um côvado e meio. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ele a revestiu com ouro puro, e fez uma moldagem de ouro em torno dela. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ele fez uma borda com a largura de uma mão ao seu redor, e fez uma moldagem dourada em sua borda ao seu redor. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ele fundiu quatro anéis de ouro para ele, e colocou os anéis nos quatro cantos que estavam em seus quatro pés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Os anéis estavam perto da borda, os lugares para os postes carregarem a mesa. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ele fez os postes de madeira de acácia, e os revestiu com ouro, para carregar a mesa. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ele fez os recipientes que estavam sobre a mesa, seus pratos, suas colheres, suas tigelas e seus cântaros com os quais derramar, de ouro puro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ele fez o suporte da lâmpada de ouro puro. Ele fez o suporte da lâmpada de trabalho batido. Sua base, seu eixo, seus copos, seus botões e suas flores eram de uma só peça com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","There eram seis ramos que saíam de seus lados: três ramos da lâmpada saem de um lado, e três ramos da lâmpada saem do outro lado: ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","três copos feitos como flores de amêndoa em um ramo, um botão e uma flor, e três copos feitos como flores de amêndoa no outro ramo, um botão e uma flor; assim, para os seis ramos que saem do candeeiro, ele fez o candeeiro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","No candeeiro estavam quatro copos feitos como flores de amêndoa, seus botões e suas flores; ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","e um botão sob dois ramos de uma peça com ele, e um botão sob dois ramos de uma peça com ele, e um botão sob dois ramos de uma peça com ele, para os seis ramos que saem dele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Seus botões e seus galhos eram de uma só peça com ele. A coisa toda era um trabalho batido de ouro puro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ele fez suas sete lâmpadas, e seus rapé, e seus pratos de rapé, de ouro puro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ele o fez de um talento de ouro puro, com todos os seus recipientes. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ele fez o altar do incenso de madeira de acácia. Era quadrado: seu comprimento era de um côvado, e sua largura de um côvado. Sua altura era de dois côvados. Seus chifres eram de uma só peça com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ele o revestiu com ouro puro: seu topo, seus lados ao seu redor e seus chifres. Ele fez uma moldagem de ouro ao seu redor. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ele fez dois anéis dourados para ele sob sua coroa de moldagem, em suas duas costelas, em seus dois lados, para lugares para postes com os quais ele poderia ser transportado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ele fez os postes de madeira de acácia, e os revestiu com ouro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ele fez o óleo sagrado da unção e o incenso puro de especiarias doces, depois da arte do perfumista. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ele fez o altar de holocausto de madeira de acácia. Era quadrado. Seu comprimento era de cinco cúbitos, sua largura era de cinco cúbitos e sua altura de três cúbitos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ele fez seus chifres em seus quatro cantos. Seus chifres eram de uma só peça com ele, e ele o revestiu com bronze. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ele fez todos os vasos do altar: as panelas, as pás, as bacias, os garfos e as panelas de fogo. Ele fez todos os seus vasos de bronze. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ele fez para o altar uma grade de uma rede de bronze, sob o parapeito em torno dele, chegando a meio caminho para cima. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ele lançou quatro anéis para os quatro cantos da grade de bronze, para serem lugares para os postes. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ele fez os postes de madeira de acácia, e os revestiu com bronze. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Colocou os postes nos anéis dos lados do altar, com os quais transportar. Ele o fez oco com tábuas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ele fez a bacia de bronze, e sua base de bronze, a partir dos espelhos das ministras que ministraram à porta da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ele fez a quadra: para o lado sul, os enforcamentos da quadra eram de linho fino torcido, cem cúbitos; ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","their os pilares eram vinte, e suas bases vinte, de bronze; os ganchos dos pilares e seus filetes eram de prata. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Para o lado norte cem côvados, seus pilares vinte, e suas bases vinte, de bronze; os ganchos dos pilares, e seus filetes, de prata. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Para o lado ocidental, os ganchos dos pilares e seus filetes eram de cinqüenta côvados, seus pilares dez, e suas bases dez; os ganchos dos pilares, e seus filetes, de prata. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","For para o lado leste, cinqüenta côvados, ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","para o lado leste, quinze côvados; seus pilares três, e suas bases três; ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","e assim para o outro lado: nesta e naquela mão junto ao portão do pátio, quinze côvados; seus pilares três, e suas bases três. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Todos os penduricalhos ao redor da quadra eram de linho fino torcido. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","As bases para os pilares eram de bronze. Os ganchos dos pilares e seus filetes eram de prata. Suas capitéis eram revestidas de prata. Todos os pilares da quadra tinham faixas prateadas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","A tela para o portão da quadra era obra do bordador, de azul, roxo, escarlate e linho fino torcido. Vinte côvados era o comprimento, e a altura ao longo da largura era de cinco côvados, como os enforcamentos da quadra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Their pilares eram quatro, e suas bases quatro, de bronze; seus ganchos de prata, e a sobreposição de suas capitéis, e seus filetes, de prata. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Todos os pinos do tabernáculo, e ao redor da quadra, eram de bronze. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Estas são as quantidades de materiais utilizados para o tabernáculo, mesmo o Tabernáculo do Testemunho, como foram contados, segundo o mandamento de Moisés, para o serviço dos Levitas, pela mão de Itamar, filho de Aarão, o sacerdote. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel o filho de Uri, o filho de Hur, da tribo de Judá, fez tudo o que Javé ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Com ele estava Oholiab, filho de Ahisamach, da tribo de Dan, gravador e artesão, e bordador em azul, em roxo, em escarlate e em linho fino. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Todo o ouro que foi usado para o trabalho em todo o trabalho do santuário, mesmo o ouro da oferenda, era de vinte e nove talentos e setecentos e trinta siclos, de acordo com o siclo do santuário. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","A prata dos que foram contados da congregação foi cem talentos e mil setecentos e setenta e cinco siclos, de acordo com o siclo do santuário: ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","uma beka uma cabeça, ou seja, meio siclo, de acordo com o siclo do santuário, para todos aqueles que passaram para aqueles que foram contados, a partir dos vinte anos de idade, para seiscentos e três mil e quinhentos e cinqüenta homens. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Os cem talentos de prata foram para fundir as tomadas do santuário e as tomadas do véu: cem tomadas para os cem talentos, um talento por tomada. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Dos mil setecentos e setenta e cinco siclos, ele fez ganchos para os pilares, sobrepôs suas capitais e fez filetes para eles. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","O bronze da oferta foi setenta talentos e dois mil e quatrocentos shekels. ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Com isto ele fez as bases da porta da Tenda da Reunião, o altar de bronze, a grade de bronze para ele, todos os vasos do altar, ");
INSERT INTO porbrbsl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","as bases ao redor da corte, as bases da porta da corte, todos os pinos do tabernáculo, e todos os pinos ao redor da corte. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Do azul, roxo e escarlate, eles fizeram as vestes finamente trabalhadas para ministrar no lugar santo, e fizeram as vestes sagradas para Arão, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ele fez o éfode de ouro, azul, roxo, escarlate, e linho fino torcido. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Eles bateram o ouro em chapas finas e o cortaram em fios, para trabalhá-lo com o azul, o roxo, o escarlate e o linho fino, o trabalho do artesão habilidoso. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Eles fizeram alças para o ombro, unidas entre si. Foi unido nas duas extremidades. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","A habilmente tecida faixa que estava sobre ela, com a qual se fixava, era da mesma peça, como seu trabalho: de ouro, de azul, roxo, escarlate, e linho fino torcido, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Eles trabalharam as pedras ônix, encerradas em cenários de ouro, gravadas com as gravuras de um selo, de acordo com os nomes dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ele as colocou sobre as alças do éfode, para serem pedras de memorial para os filhos de Israel, como Javé ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ele fez o peitoral, o trabalho de um artesão habilidoso, como o trabalho do éfode: de ouro, de azul, roxo, escarlate e de linho fino torcido. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Era quadrado. Fizeram a couraça dupla. Seu comprimento era um vão, e sua largura um vão, sendo duplo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","They Colocou nele quatro fileiras de pedras. Uma fileira de rubi, topázio e berilo era a primeira fileira; ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","e a segunda fileira, uma turquesa, uma safira e uma esmeralda; ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","e a terceira fileira, um jacinto, uma ágata e uma ametista; ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","e a quarta fileira, um crisólito, um ônix e um jaspe. Estavam encerrados em cenários dourados. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","As pedras estavam de acordo com os nomes dos filhos de Israel, doze, de acordo com seus nomes; como as gravuras de um selo, todos de acordo com seu nome, para as doze tribos. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Elas faziam sobre o peitoral correntes como cordas, de trançados de ouro puro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Eles fizeram dois ajustes de ouro, e dois anéis de ouro, e colocaram os dois anéis nas duas extremidades da couraça. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Colocam as duas correntes trançadas de ouro nos dois anéis nas extremidades da couraça. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","As outras duas pontas das duas correntes trançadas, elas colocam nas duas configurações, e as colocam nas alças do ombro do éfode, em sua frente. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Eles fizeram dois anéis de ouro, e os colocaram nas duas extremidades do peitoral, em sua borda, que estava voltada para o lado do éfode, para dentro. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Eles fizeram mais dois anéis de ouro, e os colocaram nas duas alças do éfode, embaixo, em sua frente, perto por seu acoplamento, acima da habilmente tecida faixa do éfode. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Eles amarram a couraça por seus anéis aos anéis do éfode com uma renda azul, para que ela pudesse estar sobre a habilmente tecida faixa do éfode, e para que a couraça não se soltasse do éfode, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ele fez o manto do éfode do trabalho tecido, todo de azul. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","A abertura do manto no meio dele foi como a abertura de um casaco de correio, com uma encadernação ao redor de sua abertura, que não deveria ser rasgado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Eles fizeram nas saias do manto romãs de linho azul, roxo, escarlate e torcido. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Eles fizeram sinos de ouro puro, e colocaram os sinos entre as romãs ao redor das saias do manto, entre as romãs; ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","um sino e uma romã, um sino e uma romã, ao redor das saias do manto, para ministrar, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Eles fizeram as túnicas de linho fino de trabalho tecido para Aaron e para seus filhos, ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","o turbante de linho fino, as faixas de cabeça de linho fino, as calças de linho fino torcido, ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","a faixa de linho fino torcido, azul, roxo e escarlate, o trabalho do bordador, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Eles fizeram a placa da coroa sagrada de ouro puro, e escreveram nela uma inscrição, como as gravuras de um selo: “HOLY TO YAHWEH”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Amarraram-lhe uma renda de azul, para prendê-la no turbante acima, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Assim, todo o trabalho do tabernáculo da Tenda da Reunião foi concluído. Os filhos de Israel fizeram de acordo com tudo o que Iavé ordenou a Moisés; assim o fizeram. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Eles trouxeram o tabernáculo a Moisés: a tenda, com todos os seus móveis, seus fechos, suas tábuas, suas barras, seus pilares, suas bases, ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","a cobertura de peles de carneiros tingidas de vermelho, a cobertura de peles de vacas marinhas, o véu da tela, ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","a arca do convênio com seus bastões, o banco da misericórdia, ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","a mesa, todos os seus recipientes, o pão de exposição, ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","o suporte de lâmpada pura, suas lâmpadas, até mesmo as lâmpadas a serem colocadas em ordem, todos os seus recipientes, o óleo para a luz, ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","o altar dourado, o óleo de unção, o incenso doce, a tela para a porta da Tenda, ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","o altar de bronze, sua grade de bronze, seus postes, todos os seus vasos, a bacia e sua base, ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","os penduricalhos da quadra, seus pilares, suas bases, a tela para a porta da quadra, seus cordões, seus pinos, e todos os instrumentos do serviço do tabernáculo, para a Tenda da Reunião, ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","as vestes finamente trabalhadas para ministrar no lugar santo, as vestes sagradas para Aarão, o sacerdote, e as vestes de seus filhos, para ministrar no ofício de sacerdote. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","According a tudo o que Javé ordenou a Moisés, assim os filhos de Israel fizeram todo o trabalho. ");
INSERT INTO porbrbsl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moisés viu todo o trabalho, e eis que eles o tinham feito como Javé havia ordenado. Eles o tinham feito; e Moisés os abençoou. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“No primeiro dia do primeiro mês você levantará o tabernáculo da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Você colocará a arca do convênio nela, e examinará a arca com o véu. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Você deverá trazer a mesa, e colocar em ordem as coisas que nela estão. Você deverá trazer o suporte da lâmpada, e acender suas lâmpadas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Você colocará o altar dourado para incenso diante da arca do convênio, e colocará a cortina da porta para o tabernáculo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Você deverá colocar o altar de holocausto diante da porta do tabernáculo da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","“Você deverá colocar a bacia entre a Tenda da Reunião e o altar, e nela deverá colocar água. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Você deverá erguer a quadra ao redor dela e pendurar a tela do portão da quadra. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Você tomará o óleo da unção, ungirá o tabernáculo e tudo o que há nele, e o santificará, e todos os seus móveis, e ele será santo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Você ungirá o altar de holocausto, com todos os seus vasos, e santificará o altar, e o altar será santíssimo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Você ungirá a bacia e sua base, e a santificará. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Você deverá levar Aarão e seus filhos à porta da Tenda da Reunião, e lavá-los com água. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Vestirás Arão com as vestes sagradas; e o ungirás, e o santificarás, para que ele possa ministrar-me no ofício sacerdotal. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Trarás seus filhos e lhes porás túnicas. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ungi-los-eis, como ungistes o pai deles, para que possam ministrar a mim no ofício sacerdotal. A unção deles será para eles para um sacerdócio eterno através de suas gerações”. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moisés o fez. De acordo com tudo o que Iavé lhe ordenou, assim ele o fez. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","No primeiro mês do segundo ano, no primeiro dia do mês, o tabernáculo foi levantado. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moisés levantou o tabernáculo, colocou suas bases, montou suas tábuas, colocou suas barras e ergueu seus pilares. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ele estendeu a cobertura sobre a tenda, e colocou o teto do tabernáculo acima dela, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ele tomou e colocou o pacto na arca, e colocou as varas sobre a arca, e colocou o assento de misericórdia acima sobre a arca. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ele trouxe a arca para dentro do tabernáculo, e colocou o véu da tela, e examinou a arca do pacto, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ele colocou a mesa na Tenda da Reunião, no lado norte do tabernáculo, do lado de fora do véu. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Colocou o pão em ordem nela antes de Yahweh, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ele colocou o suporte da lâmpada na Tenda do Meeting, no lado oposto à mesa, no lado sul do tabernáculo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ele acendeu as lâmpadas antes de Yahweh, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ele colocou o altar dourado na Tenda da Reunião diante do véu; ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","e queimou incenso de especiarias doces sobre ele, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ele colocou a tela da porta para o tabernáculo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ele colocou o altar de holocausto na porta do tabernáculo da Tenda da Reunião, e ofereceu sobre ele a oferta queimada e a oferta de refeição, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ele colocou a bacia entre a Tenda da Reunião e o altar, e colocou água nela, com a qual lavar. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moisés, Arão e seus filhos lavaram ali suas mãos e seus pés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Quando entraram na Tenda da Reunião, e quando chegaram perto do altar, lavaram-se, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ele levantou a corte ao redor do tabernáculo e do altar e ergueu a tela da porta da corte. Assim, Moisés terminou o trabalho. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Então a nuvem cobriu a Tenda da Reunião, e a glória de Yahweh encheu o tabernáculo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moisés não pôde entrar na Tenda da Reunião, porque a nuvem permaneceu sobre ela, e a glória de Javé encheu o tabernáculo. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Quando a nuvem foi levantada de cima do tabernáculo, os filhos de Israel seguiram em frente, durante todas as suas viagens; ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","mas se a nuvem não foi levantada, então eles não viajaram até o dia em que foi levantada. ");
INSERT INTO porbrbsl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Pois a nuvem de Javé estava sobre o tabernáculo de dia, e havia fogo na nuvem à noite, à vista de toda a casa de Israel, ao longo de todas as suas jornadas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Javé chamou Moisés, e falou com ele da Tenda da Reunião, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Fale com as crianças de Israel, e diga-lhes: 'Quando alguém de vocês oferecer uma oferta a Javé, vocês oferecerão sua oferta do gado, do rebanho e do rebanho'. ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“'Se sua oferta for uma oferta queimada do rebanho, ele deve oferecer um macho sem defeito. Ele a oferecerá na porta da Tenda de Reunião, para que possa ser aceita antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ele colocará sua mão sobre a cabeça do holocausto, e será aceito para ele fazer expiação por ele. ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ele matará o touro antes de Yahweh. Os filhos de Arão, os sacerdotes, apresentarão o sangue e aspergirão o sangue em torno do altar que está à porta da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ele esfolará o holocausto e o cortará em pedaços. ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Os filhos de Arão, o sacerdote, porão fogo sobre o altar e porão lenha em ordem sobre o fogo; ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","e os filhos de Arão, os sacerdotes, porão os pedaços, a cabeça e a gordura em ordem sobre a lenha que está sobre o fogo que está sobre o altar; ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","mas ele lavará suas entranhas e suas pernas com água. O sacerdote queimará tudo isso sobre o altar, para um holocausto, uma oferta feita pelo fogo, de agradável aroma a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“'Se sua oferta for do rebanho, das ovelhas ou dos caprinos, para uma oferta queimada, ele deve oferecer um macho sem defeito. ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ele o matará no lado norte do altar, antes de Yahweh. Os filhos de Arão, os sacerdotes, aspergirão seu sangue sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ele o cortará em seus pedaços, com sua cabeça e sua gordura. O sacerdote os colocará em ordem sobre a lenha que está sobre o fogo que está sobre o altar, ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","mas as entranhas e as pernas ele lavará com água. O sacerdote oferecerá o todo, e o queimará sobre o altar. É um holocausto, uma oferta feita pelo fogo, de aroma agradável a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“'Se sua oferta a Javé é um holocausto de aves, então ele oferecerá sua oferta de rolas ou de pombos jovens. ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","O sacerdote a levará ao altar, arrancar-lhe-á a cabeça e a queimará sobre o altar; e seu sangue será drenado na lateral do altar; ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","e tirará sua colheita e suas penas, e a lançará ao lado do altar na parte leste, no lugar das cinzas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Ele o rasgará por suas asas, mas não o dividirá. O sacerdote o queimará sobre o altar, sobre a lenha que está sobre o fogo. É um holocausto, uma oferenda feita pelo fogo, de agradável aroma a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“'Quando alguém oferece uma oferta de refeição a Iavé, sua oferta deve ser de farinha fina. Ele derramará óleo sobre ela, e colocará incenso sobre ela. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Ele o trará aos filhos de Arão, os sacerdotes. Ele tomará seu punhado de sua farinha fina, e de seu óleo, com todo seu incenso, e o sacerdote queimará seu memorial sobre o altar, uma oferta feita pelo fogo, de aroma agradável a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","O que restar da oferta de refeição será de Aarão e de seus filhos. É uma parte santíssima das ofertas de Yahweh feitas pelo fogo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“'Quando você oferece uma oferta de refeição cozida no forno, serão bolos ázimos de farinha fina misturada com óleo, ou bolachas ázimas untadas com óleo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Se sua oferta for uma oferta de refeição feita em uma chapa, deve ser de farinha ázimo fino, misturada com óleo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Você deve cortá-la em pedaços, e despejar óleo sobre ela. É uma oferta de refeição. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Se sua oferta for uma oferta de refeição da panela, deve ser feita de farinha fina com óleo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Você deve trazer a oferta de refeição que é feita destas coisas para Yahweh. Ela será apresentada ao sacerdote e ele a levará ao altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","O sacerdote tomará da oferta de refeição seu memorial, e o queimará sobre o altar, uma oferta feita pelo fogo, de aroma agradável a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","O que restar da oferta de refeição será de Aarão e de seus filhos. É uma parte santíssima das ofertas de Yahweh feitas pelo fogo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“'Nenhuma oferta de refeição que você oferecerá a Javé será feita com fermento; pois você não queimará fermento, nem mel algum, como oferta feita por fogo a Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Como oferta de primícias, oferecê-los-eis a Iavé, mas não se levantarão como um aroma agradável sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Toda oferenda de sua oferta de refeição deverá ser temperada com sal. Você não permitirá que falte o sal do pacto de seu Deus em sua oferta de refeição. Com todas as suas ofertas, você deve oferecer sal. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“'Se você oferecer uma oferta de primeira fruta a Iavé, você oferecerá para a oferta de sua primeira fruta cabeças frescas de grãos secos com fogo e esmagados. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Você deve colocar óleo e colocar incenso sobre ele. É uma oferta de refeição. ");
INSERT INTO porbrbsl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","O sacerdote queimará como memorial parte de seu grão triturado e parte de seu óleo, junto com todo seu incenso. É uma oferenda feita pelo fogo a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“'Se sua oferta for um sacrifício de ofertas de paz, se ele a oferecer do rebanho, seja macho ou fêmea, ele a oferecerá sem defeito diante de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ele colocará sua mão sobre a cabeça de sua oferta e a matará na porta da Tenda da Reunião. Os filhos de Arão, os sacerdotes, aspergirão o sangue em torno do altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Ele oferecerá do sacrifício de ofertas de paz uma oferta feita pelo fogo a Iavé. A gordura que cobre as entranhas, e toda a gordura que está sobre as entranhas, ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","e os dois rins, e a gordura que está sobre eles, que está junto aos lombos, e a cobertura sobre o fígado, com os rins, ele tirará. ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Os filhos de Arão a queimarão no altar sobre o holocausto, que está sobre a lenha que está no fogo: é uma oferenda feita pelo fogo, de aroma agradável a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“'Se sua oferta por um sacrifício de ofertas de paz a Javé é do rebanho, seja macho ou fêmea, ele a oferecerá sem defeito. ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Se ele oferecer um cordeiro por sua oferta, então ele o oferecerá antes de Yahweh; ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","e colocará sua mão sobre a cabeça de sua oferta, e a matará antes da Tenda da Reunião. Os filhos de Arão aspergirão seu sangue sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Ele oferecerá do sacrifício de ofertas pacíficas uma oferta feita pelo fogo a Javé; sua gordura, toda a gordura da cauda, ele a tirará perto da espinha dorsal; e a gordura que cobre as entranhas, e toda a gordura que está sobre as entranhas, ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","e os dois rins, e a gordura que está sobre eles, que está junto aos lombos, e a cobertura do fígado, com os rins, ele a tirará. ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","O sacerdote a queimará sobre o altar: é o alimento da oferenda feita pelo fogo a Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“'Se sua oferta for um bode, então ele a oferecerá antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Ele colocará sua mão sobre sua cabeça, e a matará antes da Tenda da Reunião; e os filhos de Aarão aspergirão seu sangue ao redor sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ele oferecerá dela como sua oferta, uma oferta feita pelo fogo a Javé; a gordura que cobre as entranhas, e toda a gordura que está sobre as entranhas, ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","e os dois rins, e a gordura que está sobre eles, que está junto aos lombos, e a cobertura sobre o fígado, com os rins, ele a tirará. ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","O sacerdote os queimará no altar: é o alimento da oferenda feita pelo fogo, para um aroma agradável; toda a gordura é de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“'Será um estatuto perpétuo através de vossas gerações em todas as vossas habitações, que não comereis gordura nem sangue'”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Javé falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ Fale aos filhos de Israel, dizendo: 'Se alguém pecar involuntariamente, em alguma das coisas que Javé ordenou que não fossem feitas, e fizer alguma delas, ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","se o sacerdote ungido pecar para trazer culpa ao povo, então deixe-o oferecer por seu pecado que ele tenha pecado um jovem touro sem defeito a Javé por uma oferta pelo pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ele levará o touro à porta da Tenda da Reunião antes de Iavé; e porá sua mão sobre a cabeça do touro e matará o touro antes de Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","O sacerdote ungido tomará parte do sangue do touro e o levará para a Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","O sacerdote mergulhará seu dedo no sangue, e aspergirá parte do sangue sete vezes antes de Yahweh, diante do véu do santuário. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","O sacerdote colocará parte do sangue nos chifres do altar do incenso doce diante de Iavé, que está na Tenda da Reunião; e derramará o resto do sangue do touro na base do altar do holocausto, que está na porta da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ele retirará toda a gordura do touro da oferta pelo pecado: a gordura que cobre as entranhas, e toda a gordura que está sobre as entranhas, ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","e os dois rins, e a gordura que está sobre eles, que está junto aos lombos, e a cobertura sobre o fígado, com os rins, ele retirará, ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","como é retirado do touro do sacrifício das ofertas de paz. O sacerdote os queimará sobre o altar de holocausto. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ele levará a pele do touro, toda sua carne, com sua cabeça e com suas pernas, suas entranhas e seu esterco ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","- todo o resto do boi do acampamento para um lugar limpo onde as cinzas são derramadas, e o queimará sobre lenha com fogo. Será queimado no local onde as cinzas são despejadas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“'Se toda a congregação de Israel pecar, e a coisa estiver escondida dos olhos da assembléia, e eles tiverem feito qualquer das coisas que Javé ordenou que não fossem feitas, e forem culpados; ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","quando o pecado em que pecaram for conhecido, então a assembléia oferecerá um touro jovem para uma oferta pelo pecado, e o trará perante a Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Os anciãos da congregação colocarão suas mãos sobre a cabeça do touro perante Yahweh; e o touro será morto perante Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","O sacerdote ungido trará parte do sangue do touro para a Tenda da Assembléia. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","O sacerdote mergulhará seu dedo no sangue e o polvilhará sete vezes antes de Yahweh, antes do véu. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ele colocará parte do sangue nos chifres do altar que está diante de Iavé, ou seja, na Tenda da Reunião; e o resto do sangue ele derramará na base do altar de holocausto, que está à porta da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Toda sua gordura ele tirará dela, e a queimará sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ele fará isto com o touro; como fez com o touro da oferta pelo pecado, assim fará com isto; e o sacerdote fará expiação por eles, e eles serão perdoados. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Ele levará o touro para fora do acampamento, e o queimará como queimou o primeiro touro. É a oferta pelo pecado para a assembléia. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“'Quando um governante peca, e involuntariamente faz qualquer uma de todas as coisas que Javé seu Deus ordenou que não fossem feitas, e é culpado, ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","se seu pecado no qual ele pecou lhe for dado a conhecer, ele trará como sua oferta um bode, um macho sem defeito. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ele colocará sua mão sobre a cabeça do bode, e o matará no lugar onde matam o holocausto diante de Javé. É uma oferta pelo pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","O sacerdote tomará parte do sangue da oferta pelo pecado com seu dedo e a colocará sobre os chifres do altar de holocausto. Ele deve derramar o resto de seu sangue na base do altar de holocausto. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Toda sua gordura ele queimará sobre o altar, como a gordura do sacrifício de ofertas pela paz; e o sacerdote fará expiação por ele a respeito de seu pecado, e ele será perdoado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“'Se alguém do povo comum pecar involuntariamente, ao fazer qualquer das coisas que Javé ordenou que não fossem feitas, e for culpado, ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","se seu pecado que cometeu lhe for dado a conhecer, então ele trará para sua oferta uma cabra, uma fêmea sem defeito, por seu pecado que cometeu. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ele colocará sua mão sobre a cabeça da oferta pelo pecado, e matará a oferta pelo pecado no lugar da oferta queimada. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","O sacerdote tomará um pouco de seu sangue com seu dedo e o colocará sobre os chifres do altar de holocausto; e o resto de seu sangue derramará na base do altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Toda sua gordura ele tirará, como a gordura é tirada do sacrifício de ofertas pacíficas; e o sacerdote a queimará sobre o altar para um aroma agradável a Javé; e o sacerdote fará expiação por ele, e ele será perdoado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“'Se ele trouxer um cordeiro como sua oferta por uma oferta pelo pecado, ele deve trazer uma fêmea sem defeito. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ele colocará sua mão sobre a cabeça da oferta pelo pecado, e a matará por uma oferta pelo pecado no local onde matam a oferta queimada. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","O sacerdote deve tomar parte do sangue da oferta pelo pecado com seu dedo, e colocá-lo sobre os chifres do altar de holocausto; e todo o resto de seu sangue ele deve derramar na base do altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ele deve remover toda sua gordura, como a gordura do cordeiro é removida do sacrifício de ofertas pacíficas. O sacerdote as queimará sobre o altar, sobre as ofertas de Javé feitas pelo fogo. O sacerdote fará expiação por ele de seu pecado que cometeu, e ele será perdoado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“'Se alguém pecar, por ouvir uma admoestação pública para testemunhar, sendo testemunha, quer tenha visto ou conhecido, se não o denunciar, então deverá suportar sua iniqüidade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“'Ou se alguém tocar alguma coisa impura, seja a carcaça de um animal impuro, ou a carcaça de um animal imundo, ou a carcaça de um animal imundo, ou a carcaça de coisas imundas que se rastejam, e se ela estiver escondida dele, e ele for impuro, então ele será culpado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“'Ou se ele tocar a imundícia do homem, qualquer que seja sua imundícia com a qual ele é impuro, e ela for escondida dele; quando ele souber disso, então ele será culpado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“'Or if anyone swears rashly with his lips to do evil or to do good - o que quer que seja que um homem possa proferir rashly com um juramento, e isso é escondido dele - quando ele souber disso, então ele será culpado de um destes. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Será, quando for culpado de um destes, confessará aquilo em que pecou; ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","e trará sua oferta pela culpa a Javé pelo pecado que cometeu: uma fêmea do rebanho, um cordeiro ou um bode, como oferta pelo pecado; e o sacerdote fará expiação por ele a respeito de seu pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“'Se ele não puder pagar um cordeiro, então ele deve trazer sua oferta de transgressão por aquilo em que ele pecou, duas rolas, ou dois pombinhos, para Yahweh; um por uma oferta pelo pecado, e o outro por uma oferta queimada. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ele os trará ao sacerdote, que primeiro oferecerá aquele que é para a oferta pelo pecado. Ele arrancar-lhe-á a cabeça do pescoço, mas não a cortará completamente. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ele aspergirá parte do sangue da oferta pelo pecado na lateral do altar; e o resto do sangue será drenado na base do altar. É uma oferta pelo pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ele oferecerá a segunda por um holocausto, de acordo com a ordenança; e o sacerdote fará expiação por ele de seu pecado que ele pecou, e ele será perdoado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“'Mas se ele não puder pagar duas rolas ou dois pombinhos, então ele trará como sua oferta por aquilo em que pecou, um décimo de uma efa de farinha fina para uma oferta pelo pecado. Ele não colocará óleo e não colocará qualquer incenso, pois é uma oferta pelo pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ele o levará ao sacerdote, e o sacerdote tomará seu punhado como a porção memorial, e o queimará sobre o altar, sobre as ofertas de Yahweh feitas pelo fogo. É uma oferenda pelo pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","O sacerdote fará por ele expiação de seu pecado que tenha pecado em qualquer destas coisas, e ele será perdoado; e o resto será do sacerdote, como a oferta de refeição”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Javé falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Se alguém cometer uma transgressão, e pecar involuntariamente em relação às coisas santas de Javé, então trará sua oferta de transgressão a Javé: um carneiro sem defeito do rebanho, de acordo com sua estimativa em prata por shekels, de acordo com o siclo do santuário, para uma oferta de transgressão. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ele fará a restituição do que fez de errado em relação à coisa santa, e acrescentará uma quinta parte a ela, e a dará ao sacerdote; e o sacerdote fará expiação por ele com o carneiro da oferta pela culpa, e ele será perdoado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Se alguém pecar, fazendo alguma das coisas que Javé ordenou que não fossem feitas, embora não o soubesse, ele ainda é culpado e deve suportar sua iniqüidade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ele trará um carneiro sem defeito do rebanho, de acordo com sua estimativa, para oferta pela culpa, ao sacerdote; e o sacerdote fará expiação por ele a respeito da coisa em que pecou e não sabia, e ele será perdoado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","É uma oferta de transgressão. Ele é certamente culpado diante de Yahweh”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yahweh falou com Moisés, dizendo, ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Se alguém pecar e cometer uma transgressão contra Yahweh, e lidar falsamente com seu vizinho em uma questão de depósito, ou de barganha, ou de roubo, ou tiver oprimido seu vizinho, ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ou tiver encontrado o que estava perdido, e mentiu sobre isso, e jurando - em qualquer uma dessas coisas - que um homem peca em suas ações - ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","então será, se ele tiver pecado e for culpado, ele restaurará aquilo que tomou por roubo, ou aquilo que recebeu por opressão, ou o depósito que lhe foi cometido, ou a coisa perdida que encontrou, ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ou qualquer coisa sobre a qual jurou falsamente: ele o restituirá por completo, e lhe acrescentará mais uma quinta parte. Ele a devolverá àquele a quem pertence, no dia em que for considerado culpado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Ele levará sua oferta de transgressão a Iavé: um carneiro sem defeito do rebanho, de acordo com sua estimativa, para oferta de transgressão, ao sacerdote. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","O sacerdote fará expiação por ele perante Iavé, e ele será perdoado de tudo o que fizer para se tornar culpado”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Comande Arão e seus filhos, dizendo: 'Esta é a lei do holocausto: o holocausto estará sobre o coração do altar toda a noite até a manhã; e o fogo do altar será mantido aceso sobre ele. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","O sacerdote vestirá sua roupa de linho, e vestirá suas calças de linho sobre seu corpo; e removerá as cinzas de onde o fogo consumiu o holocausto sobre o altar, e as colocará ao lado do altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ele tirará suas vestes, vestirá outras vestes e levará as cinzas para fora do acampamento a um lugar limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","O fogo sobre o altar será mantido queimando sobre ele, não se apagará; e o padre queimará lenha sobre ele todas as manhãs. Ele colocará o holocausto em ordem sobre ele, e queimará sobre ele a gordura das ofertas pacíficas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Fire será continuamente queimado sobre o altar; ele não se apagará. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“'Esta é a lei da oferta de refeição: os filhos de Aarão a oferecerão diante de Yahweh, diante do altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Ele levará de lá seu punhado da farinha fina da oferta de refeição, e de seu óleo, e todo o incenso que está na oferta de refeição, e o queimará no altar para um aroma agradável, como sua porção memorial, a Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","O que restar dele, Arão e seus filhos comerão. Será comido sem fermento em lugar sagrado. Eles o comerão no pátio da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Não será cozido com levedura. Eu o dei como porção das minhas oferendas feitas pelo fogo. É muito santo, assim como a oferta pelo pecado e a oferta pela transgressão. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Every macho entre os filhos de Aarão comerá dela, como sua porção para sempre através de vossas gerações, das ofertas de Yahweh feitas pelo fogo. Quem os tocar será santo”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Esta é a oferta de Arão e de seus filhos, que oferecerão a Javé no dia em que ele for ungido: um décimo de um efa de farinha fina para uma oferta de refeição perpetuamente, metade dela pela manhã, e metade à noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Deve ser feita com óleo em uma chapa. Quando estiver ensopada, você a trará para dentro. Você deve oferecer a oferta de refeição em pedaços assados para um aroma agradável a Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","O sacerdote ungido que estará em seu lugar entre seus filhos a oferecerá. Por um estatuto para sempre, ela será totalmente queimada para Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Toda oferta de refeição de um padre será totalmente queimada. Não será comido”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Fale a Arão e a seus filhos, dizendo: 'Esta é a lei da oferta pelo pecado: no lugar onde o holocausto é morto, a oferta pelo pecado será morta antes de Yahweh. É santíssimo”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","The o sacerdote que a oferecer pelo pecado a comerá”. Será comida em lugar santo, no tribunal da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Whatever tocará sua carne será santa. Quando houver algum de seu sangue aspergido sobre uma roupa, lavar-se-á aquilo sobre o qual foi aspergido em um lugar santo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","But o vaso de barro no qual foi cozido será quebrado; e se for cozido em um vaso de bronze, será lavado, e enxaguado em água. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Every o macho entre os sacerdotes comerá dele. É santíssimo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","No oferta pelo pecado, da qual qualquer do sangue é trazido para a Tenda da Reunião para fazer expiação no Lugar Santo, será comido. Será queimada com fogo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“'Esta é a lei da oferta de transgressão: É santíssima. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","No lugar em que matarem a oferta queimada, ele matará a oferta de transgressão; e seu sangue ele aspergirá em torno do altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ele oferecerá toda sua gordura: a cauda gorda, e a gordura que cobre as entranhas, ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","e tirará os dois rins, e a gordura que está sobre eles, que está junto aos lombos, e a cobertura do fígado, com os rins; ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","e o sacerdote os queimará no altar para uma oferta feita por fogo a Javé: é uma oferta de transgressão. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Todo homem entre os sacerdotes pode comer dela. Será comido em lugar santo. É santíssimo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“'Como é a oferta pelo pecado, assim é a oferta pela transgressão; há uma lei para eles. O sacerdote que fizer expiação com eles a terá. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","O sacerdote que oferecer a oferta queimada de qualquer homem terá para si a pele do holocausto que ele ofereceu. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Toda oferta de refeição que for assada no forno, e tudo o que for preparado na panela e na chapa, será do padre que a oferecer. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Toda oferta de refeição, misturada com óleo ou seca, pertence a todos os filhos de Aarão, tanto um como outro. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“'Esta é a lei do sacrifício das ofertas de paz, que se deve oferecer a Iavé: ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Se ele oferecer por uma ação de graças, então oferecerá com o sacrifício de bolos ázimos misturados com óleo, e bolachas ázimos untadas com óleo, e bolos misturados com óleo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ele oferecerá sua oferta com o sacrifício de suas ofertas pacíficas para uma ação de graças com bolos de pão levedado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Dela ele oferecerá uma de cada oferta por uma oferta alçada a Yahweh. Será o sacerdote quem asperge o sangue das ofertas pacíficas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","A carne do sacrifício de suas ofertas pacíficas para ação de graças será comida no dia de sua oferta. Ele não deixará nada disso até a manhã. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“'Mas se o sacrifício de sua oferta for um voto, ou uma oferta de livre vontade, ele será comido no dia em que ele oferecer seu sacrifício. No dia seguinte, o que restar dele será comido, ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","mas o que restar da carne do sacrifício no terceiro dia será queimado com fogo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Se alguma das carnes do sacrifício de sua oferta pacífica for comida no terceiro dia, ela não será aceita, e não será creditada a quem a oferecer. Será uma abominação, e a alma que comer qualquer uma delas suportará sua iniqüidade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“'A carne que toca qualquer coisa impura não deve ser consumida. Deve ser queimada com fogo. Quanto à carne, todos que estiverem limpos poderão comê-la; ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","mas a alma que comer da carne do sacrifício das ofertas de paz que pertence a Iavé, tendo sua imundícia sobre ele, essa alma será cortada de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Quando alguém tocar qualquer coisa impura, a imundícia do homem, ou um animal impuro, ou qualquer abominação impura, e comer alguma da carne do sacrifício das ofertas pacíficas que pertence a Iavé, essa alma será extirpada de seu povo'”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ Fale aos filhos de Israel, dizendo: “Não comereis gordura, nem de touro, nem de ovelha, nem de cabra”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","A gordura daquilo que morre de si mesmo, e a gordura daquilo que é rasgado dos animais, pode ser usada para qualquer outro serviço, mas não comereis de forma alguma dela. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Para quem comer a gordura do animal que os homens oferecem como oferta feita pelo fogo a Javé, até mesmo a alma que a come será cortada de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Você não comerá nenhum sangue, seja de pássaro ou de animal, em nenhuma de suas habitações. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Quem quer que seja que come qualquer sangue, essa alma será cortada de seu povo'”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Javé falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Fale aos filhos de Israel, dizendo: 'Aquele que oferecer o sacrifício de suas ofertas de paz a Javé trará sua oferta a Javé do sacrifício de suas ofertas de paz'. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Com suas próprias mãos ele trará as ofertas de Iavé feitas pelo fogo”. Ele trará a gordura com o peito, para que o peito possa ser acenado para uma oferta de ondas diante de Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","O sacerdote queimará a gordura sobre o altar, mas o peito será de Aarão e de seus filhos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","A coxa direita que você dará ao sacerdote para uma oferta alçada dos sacrifícios de suas ofertas pacíficas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ele entre os filhos de Aarão que oferecer o sangue das ofertas pacíficas, e a gordura, terá a coxa direita por uma porção. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Pelo peito ondulado e pela coxa pesada que tirei dos filhos de Israel dos sacrifícios de suas ofertas pacíficas, e os dei a Arão, o sacerdote, e a seus filhos como porção para sempre dos filhos de Israel”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Esta é a porção consagrada de Aarão, e a porção consagrada de seus filhos, das ofertas de Iavé feitas pelo fogo, no dia em que ele os apresentou para ministrar a Iavé no gabinete do sacerdote; ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","que Iavé ordenou que lhes fosse dada dos filhos de Israel, no dia em que ele os ungiu. É a porção deles para sempre através de suas gerações. ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Esta é a lei do holocausto, a oferta de refeição, a oferta pelo pecado, a oferta pela culpa, a consagração e o sacrifício de ofertas de paz ");
INSERT INTO porbrbsl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","que Javé ordenou a Moisés no Monte Sinai no dia em que ordenou aos filhos de Israel que oferecessem suas ofertas a Javé, no deserto do Sinai. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Leve Aarão e seus filhos com ele, e as vestes, e o óleo da unção, e o touro da oferta pelo pecado, e os dois carneiros, e a cesta de pão ázimo; ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","e reúna toda a congregação à porta da Tenda da Reunião”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moisés fez como Yahweh lhe ordenou; e a congregação foi reunida à porta da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moisés disse à congregação: “Esta é a coisa que Javé ordenou que fosse feita”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moisés trouxe Aarão e seus filhos, e os lavou com água. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ele colocou a túnica sobre ele, amarrou a faixa sobre ele, vestiu-o com o manto, colocou o éfode sobre ele, e amarrou a faixa habilmente tecida do éfode sobre ele e a prendeu a ele com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Ele colocou a couraça sobre ele. Colocou o Urim e o Thummim no peitoral. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ele colocou o turbante em sua cabeça. Colocou a placa dourada, a coroa sagrada, na frente do turbante, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Moisés tomou o óleo da unção, ungiu o tabernáculo e tudo o que havia nele, e os santificou. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ele aspergiu-o sobre o altar sete vezes, e ungiu o altar e todos os seus vasos, e a bacia e sua base, para santificá-los. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ele derramou um pouco do óleo da unção na cabeça de Aaron, e o ungiu para santificá-lo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moisés trouxe os filhos de Arão, vestiu-os com túnicas, amarrou-lhes faixas e colocou-lhes fitas de cabeça, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ele trouxe o touro da oferta pelo pecado, e Arão e seus filhos colocaram suas mãos sobre a cabeça do touro da oferta pelo pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Ele o matou; e Moisés tomou o sangue, colocou-o com o dedo sobre os chifres do altar, purificou o altar, derramou o sangue na base do altar e o santificou, para fazer expiação por ele. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ele pegou toda a gordura que estava nas entranhas, e a cobertura do fígado, e os dois rins, e sua gordura; e Moisés a queimou sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Mas o touro, e sua pele, e sua carne, e seu esterco, ele queimou com fogo fora do acampamento, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Ele apresentou o carneiro do holocausto. Aarão e seus filhos colocaram suas mãos sobre a cabeça do carneiro. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ele o matou; e Moisés aspergiu o sangue em volta sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ele cortou o carneiro em pedaços; e Moisés queimou a cabeça, e os pedaços, e a gordura. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ele lavou as entranhas e as pernas com água; e Moisés queimou o carneiro inteiro no altar. Era uma oferta queimada para um aroma agradável. Foi uma oferenda feita pelo fogo a Iavé, como Iavé ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ele apresentou o outro carneiro, o carneiro da consagração. Arão e seus filhos colocaram suas mãos sobre a cabeça do carneiro. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Ele o matou; e Moisés tomou um pouco de seu sangue, e o colocou na ponta da orelha direita de Aarão, e no polegar de sua mão direita, e no dedo grande de seu pé direito. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ele trouxe os filhos de Arão; e Moisés colocou um pouco do sangue na ponta da orelha direita deles, e no polegar da mão direita deles, e no dedo grande do pé direito deles; e Moisés aspergiu o sangue ao redor do altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ele pegou a gordura, a cauda gorda, toda a gordura que estava nas entranhas, a cobertura do fígado, os dois rins e sua gordura, e a coxa direita; ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","e da cesta de pão ázimo que estava antes de Yahweh, ele pegou um bolo ázimo, um bolo de pão azeitado, e uma hóstia, e os colocou sobre a gordura e sobre a coxa direita. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Ele colocou tudo isso nas mãos de Aaron e de seus filhos, e os acenou para uma oferta de onda diante de Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Moisés os tirou de suas mãos e os queimou no altar sobre o holocausto. Eles eram uma oferenda de consagração por um aroma agradável. Era uma oferenda feita pelo fogo a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moisés tomou o peito, e o acenou para uma oferenda de onda antes de Yahweh. Era a porção de Moisés do carneiro de consagração, como Iavé ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moisés tomou parte do óleo da unção, e parte do sangue que estava sobre o altar, e aspergiu-o sobre Arão, sobre suas vestes, e sobre seus filhos, e sobre as vestes de seus filhos com ele, e santificou Arão, suas vestes, e seus filhos, e as vestes de seus filhos com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moisés disse a Aarão e a seus filhos: “Ferva a carne na porta da Tenda da Reunião, e ali a coma e o pão que está na cesta da consagração, como ordenei, dizendo: 'Aarão e seus filhos a comerão'. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","What restos da carne e do pão que se queimará com fogo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Não saireis da porta da Tenda da Reunião durante sete dias, até que os dias de vossa consagração sejam cumpridos: pois ele vos consagrará sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","O que foi feito hoje, assim mandou Javé fazer, para fazer expiação por você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Você ficará à porta da Tenda da Reunião dia e noite sete dias, e manterá a ordem de Yahweh, para que você não morra: pois assim me é ordenado”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Arão e seus filhos fizeram todas as coisas que Yahweh ordenou por Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","No oitavo dia, Moisés chamou Aarão e seus filhos, e os anciãos de Israel; ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","e disse a Aarão: “Pegue um bezerro do rebanho para oferta pelo pecado, e um carneiro para oferta queimada, sem defeito, e ofereça-os diante de Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Você falará aos filhos de Israel, dizendo: “Tomai um bode macho para oferta pelo pecado; e um bezerro e um cordeiro, ambos de um ano, sem defeito, para oferta queimada; ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","e um touro e um carneiro para oferta pacífica, para sacrificar diante de Iavé; e uma oferta de refeição misturada com óleo: pois hoje Iavé lhe aparece”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Eles trouxeram o que Moisés ordenou antes da Tenda da Reunião. Toda a congregação se aproximou e ficou diante de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moisés disse: “Esta é a coisa que Javé ordenou que você fizesse; e a glória de Javé aparecerá a você”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Moisés disse a Arão: “Aproximai-vos do altar e fazei vossa oferta pelo pecado e vosso holocausto e fazei expiação por vós e pelo povo; e oferecei a oferta do povo e fazei expiação por eles, como Javé ordenou”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Então Arão aproximou-se do altar, e matou o bezerro da oferta pelo pecado, que era para si mesmo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Os filhos de Aarão apresentaram-lhe o sangue; e ele mergulhou seu dedo no sangue, colocou-o nos chifres do altar e derramou o sangue na base do altar; ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","mas a gordura, e os rins, e a cobertura do fígado da oferta pelo pecado, ele queimou sobre o altar, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","A carne e a pele que ele queimou com fogo fora do acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ele matou a oferta queimada; e os filhos de Arão entregaram o sangue a ele, e ele o aspergiu em torno do altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Eles lhe entregaram o holocausto, pedaço por pedaço, e a cabeça. Ele os queimou sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ele lavou as entranhas e as pernas, e as queimou sobre o holocausto sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ele apresentou a oferta do povo, e tomou a cabra da oferta pelo pecado que era pelo povo, e a matou, e a ofereceu pelo pecado, como a primeira. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ele apresentou a oferta queimada, e a ofereceu de acordo com a ordenança. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ele apresentou a oferta de refeição, e de lá encheu sua mão, e a queimou no altar, além do holocausto da manhã. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Ele também matou o touro e o carneiro, o sacrifício das ofertas de paz, que era pelo povo. Os filhos de Arão entregaram-lhe o sangue, que ele aspergiu sobre o altar; ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","e a gordura do touro e do carneiro, a cauda gorda, e a que cobre as entranhas, e os rins, e a cobertura do fígado; ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","e colocaram a gordura sobre os seios, e ele queimou a gordura sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Arão acenou os seios e a coxa direita para uma oferenda de onda diante de Yahweh, como Moisés ordenou. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Arão levantou suas mãos para o povo e os abençoou; e desceu de oferecer a oferta pelo pecado, e o holocausto, e as ofertas pela paz. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moisés e Arão entraram na Tenda da Reunião, saíram e abençoaram o povo; e a glória de Iavé apareceu a todo o povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","O fogo saiu de antes de Javé, e consumiu a oferta queimada e a gordura sobre o altar. Quando todo o povo o viu, eles gritaram e caíram de cara. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadab e Abihu, os filhos de Aarão, cada um pegou seu incensário, colocou fogo e incendiou-o, e ofereceu fogo estranho diante de Iavé, que ele não lhes havia comandado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","O fogo saiu de antes de Yahweh, e os devorou, e eles morreram antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Então Moisés disse a Aaron: “Era disto que Yahweh falava, dizendo, “Mostrar-me-ei santo para aqueles que se aproximam de mim”, e diante de todas as pessoas serei glorificado”. Aaron manteve sua paz. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moisés chamou Mishael e Elzaphan, os filhos de Uzziel, tio de Aarão, e disse-lhes: “Aproximai-vos, levai vossos irmãos de diante do santuário para fora do acampamento”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Então eles se aproximaram, e os levaram em suas túnicas para fora do acampamento, como Moisés havia dito. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Moisés disse a Aarão, a Eleazar e a Itamar, seus filhos: “Não soltem os cabelos de vossas cabeças e não rasguem suas roupas, para que não morram, e para que ele não se irrite com toda a congregação; mas deixem seus irmãos, toda a casa de Israel, lamentar a queima que Javé acendeu. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Não saireis da porta da Tenda da Reunião, para que não morrais; pois o óleo da unção de Iavé está sobre vós”. Eles fizeram de acordo com a palavra de Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Então Javé disse a Arão, ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Você e seus filhos não devem beber vinho ou bebida forte sempre que entrarem na Tenda da Reunião, ou vocês morrerão. Este será um estatuto para sempre ao longo de suas gerações”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Vocês devem fazer uma distinção entre o santo e o comum, e entre o impuro e o limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Vocês devem ensinar aos filhos de Israel todos os estatutos que Iavé lhes falou por Moisés”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moisés falou a Arão, a Eleazar e a Itamar, seus filhos que ficaram: “Tomai a oferta de alimentos que sobrou das ofertas de Javé feitas pelo fogo, e comei-a sem fermento ao lado do altar, porque é santíssimo; ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","e comê-la-eis em lugar santo, porque é a vossa porção, e a porção de vossos filhos, das ofertas de Javé feitas pelo fogo; pois assim me foi ordenado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","O peito ondulado e a coxa pesada comereis em lugar limpo, vós e vossos filhos, e vossas filhas convosco; pois são dados como vossa porção, e a porção de vossos filhos, dos sacrifícios das ofertas pacíficas dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Eles trarão a coxa pesada e o peito ondulado com as ofertas feitas pelo fogo da gordura, para acená-la para uma oferta de onda diante de Iavé. Será sua, e de seus filhos com você, como uma porção para sempre, como Javé ordenou”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moisés perguntou diligentemente sobre a cabra da oferta pelo pecado, e eis que ela foi queimada. Ele estava zangado com Eleazar e com Itamar, os filhos de Arão que ficaram, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Por que não comeste a oferta pelo pecado no lugar do santuário, já que é santíssimo, e ele a deu a ti para suportar a iniqüidade da congregação, para fazer expiação por eles perante Javé? ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Eis que seu sangue não foi trazido para o interior do santuário. Certamente o devíeis ter comido no santuário, como eu ordenei”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Arão falou a Moisés: “Eis que hoje eles ofereceram sua oferta pelo pecado e seu holocausto diante de Javé; e coisas como estas aconteceram comigo. Se eu tivesse comido a oferta pelo pecado hoje, teria sido agradável aos olhos de Iavé”? ");
INSERT INTO porbrbsl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Quando Moisés ouviu isso, foi agradável aos seus olhos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yahweh falou a Moisés e a Arão, dizendo-lhes: ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ Fale aos filhos de Israel, dizendo: “Estes são os seres vivos que vocês podem comer entre todos os animais que estão sobre a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Quaisquer que sejam as partes do casco, e é tecido com os pés, e mastiga o cudinho entre os animais, para que você possa comer. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“'No entanto, estes você não deve comer daqueles que mastigam o casco, ou daqueles que têm o casco partido: o camelo, porque mastiga o casco mas não tem um casco partido, é impuro para você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","O hyrax, porque mastiga o casco, mas não tem casco separado, é impuro para você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","A lebre, porque mastiga o casco, mas não tem um casco separado, é impura para você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","O porco, porque tem um casco fendido, e é de casco fendido, mas não mastiga o casco, é impuro para você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Você não deve comer a carne deles. Você não deve tocar as carcaças deles. Para você, elas são imundas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“'Você pode comer de tudo isso que está nas águas: o que tiver barbatanas e escamas nas águas, nos mares, e nos rios, que você pode comer. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Tudo o que não tem barbatanas e escamas nos mares e rios, tudo o que se move nas águas, e todos os seres vivos que estão nas águas, eles são uma abominação para você, ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","e você deve detestá-los. Não comereis de sua carne, e detestareis suas carcaças. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","O que não tem barbatanas nem escamas nas águas, é uma abominação para você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“'Você os detestará entre as aves; eles não serão comidos porque são uma abominação: a águia, o abutre, o abutre negro, ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","o papagaio vermelho, qualquer tipo de papagaio negro, ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","qualquer tipo de corvo, ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","a coruja com cornos, a coruja gritante, a gaivota, qualquer tipo de falcão, ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","a coruja pequena, o corvo-marinho, a coruja grande, ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","a coruja branca, a coruja do deserto, a águia-pesqueira, ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","a cegonha, qualquer tipo de garça, a poupa, e o morcego. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“'Todos os insetos voadores que andam de quatro em quatro são uma abominação para você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","No entanto, você pode comê-los: de todos os répteis alados que andam de quatro em quatro, que têm pernas longas e articuladas para saltar sobre a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Até mesmo destes você pode comer: qualquer tipo de gafanhoto, qualquer tipo de katydid, qualquer tipo de grilo, e qualquer tipo de gafanhoto. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Mas todas as coisas rastejantes aladas que têm quatro pés são uma abominação para você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“'Por estes você se tornará imundo: quem tocar em sua carcaça ficará imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Quem carregar qualquer parte de sua carcaça deverá lavar suas roupas, e ficar imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“'Todo animal que tem um casco rachado que não está completamente dividido, ou que não mastiga a guloseima, é impuro para você. Todos os que os tocam serão imundos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","O que quer que se passe em suas patas, entre todos os animais que vão de quatro em quatro, eles são imundos para você. Quem tocar em sua carcaça será imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Aquele que carrega seu cadáver lavará suas roupas, e ficará imundo até a noite. Para você, eles são imundos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“'Estes são aqueles que são impuros para você entre as coisas rastejantes que rastejam na terra: a doninha, o rato, qualquer tipo de grande lagarto, ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","a osga, e o lagarto monitor, o lagarto da parede, o skink, e o camaleão. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Estes são aqueles que são impuros para você entre todos aqueles rastejantes. Quem os tocar quando estiverem mortos, ficará imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Tudo o que cair sobre eles quando estiverem mortos será imundo; seja qualquer recipiente de madeira, ou roupa, ou pele, ou saco, seja qual for o recipiente, com o qual se faça qualquer trabalho, deve ser colocado na água, e será imundo até a noite. Então, estará limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Todo vaso de barro em que qualquer um deles cair e tudo o que estiver nele será imundo. Você deve quebrá-lo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Todos os alimentos que puderem ser consumidos e que estiverem embebidos em água serão imundos. Toda bebida que possa ser bebida em cada um desses recipientes deverá ser imunda. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Tudo aquilo em que parte de sua carcaça cair será imundo; quer seja forno, quer seja fogão para panelas, será quebrado em pedaços. Eles serão imundos, e serão imundos para você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","No entanto, uma fonte ou uma cisterna na qual se recolhe água será limpa, mas a que tocar seu cadáver será imunda. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Se parte de sua carcaça cair sobre qualquer semente a ser semeada, ela estará limpa. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Mas se for colocada água sobre a semente, e parte de sua carcaça cair sobre ela, ela será impura para você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“'Se algum animal do qual você possa comer morrer, aquele que tocar sua carcaça ficará impuro até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Aquele que comer de sua carcaça deverá lavar suas roupas, e ficar imundo até a noite. Aquele que carrega seu cadáver também lavará suas roupas, e ficará imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“'Cada coisa que se arrepia na terra é uma abominação. Não deve ser comido. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","O que quer que se passe em sua barriga, e o que quer que se passe de quatro em quatro, ou o que quer que tenha muitos pés, mesmo todas as coisas rastejantes que rastejam sobre a terra, não se deve comer; pois são uma abominação. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Não se tornarão abomináveis com qualquer coisa rastejante que se arrependa. Não vos tornareis imundos com eles, que devíeis ser contaminados por eles. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Pois eu sou Yahweh, vosso Deus. Santificai-vos, pois, e sede santos, porque eu sou santo. Não vos contamineis com nenhum tipo de coisa rastejante que se mova sobre a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Pois eu sou Yahweh que vos fiz subir da terra do Egito, para ser vosso Deus. Sereis, pois, santos, porque eu sou santo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“'Esta é a lei do animal, e da ave, e de todo ser vivo que se move nas águas, e de todo ser vivo que se arrepia na terra, ");
INSERT INTO porbrbsl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","para fazer uma distinção entre o impuro e o limpo, e entre o ser vivo que pode ser comido e o ser vivo que não pode ser comido'”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Fale aos filhos de Israel, dizendo: 'Se uma mulher conceber e tiver um filho varão, então ela será imunda sete dias; como nos dias de seu período mensal, ela será imunda. ");
INSERT INTO porbrbsl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","No oitavo dia, a carne de seu prepúcio será circuncidada. ");
INSERT INTO porbrbsl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ela continuará no sangue de purificação por trinta e três dias. Ela não tocará em nenhuma coisa santa, nem entrará no santuário, até que os dias de sua purificação sejam completados. ");
INSERT INTO porbrbsl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Mas se ela tiver uma criança fêmea, então ela estará imunda duas semanas, como no seu período; e continuará no sangue da purificação sessenta e seis dias. ");
INSERT INTO porbrbsl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“'Quando os dias de sua purificação estiverem completos para um filho ou para uma filha, ela trará ao padre à porta da Tenda da Reunião, um cordeiro de um ano para uma oferta queimada, e um pombo jovem ou uma rola-tartaruga, para uma oferta pelo pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Ele a oferecerá diante de Javé, e fará expiação por ela; então ela será purificada da fonte de seu sangue. “'Esta é a lei para ela que carrega, seja um homem ou uma mulher. ");
INSERT INTO porbrbsl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Se ela não puder pagar um cordeiro, então ela deve levar duas rolas ou dois pombinhos: um para uma oferta queimada, e o outro para uma oferta pelo pecado. O padre fará expiação por ela, e ela estará limpa”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yahweh falou a Moisés e a Arão, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Quando um homem tiver um inchaço na pele de seu corpo, ou uma sarna, ou uma mancha brilhante, e se tornar na pele de seu corpo a praga da lepra, então ele será levado a Arão, o sacerdote, ou a um de seus filhos, os sacerdotes. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","O sacerdote examinará a praga na pele do corpo. Se o pêlo da praga ficou branco, e a aparência da praga é mais profunda que a pele do corpo, é a praga da lepra; então o sacerdote o examinará e o declarará impuro. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Se a mancha brilhante for branca na pele de seu corpo, e sua aparência não for mais profunda do que a pele, e seu pêlo não tiver ficado branco, então o padre deverá isolar a pessoa infectada por sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","O padre deverá examiná-lo no sétimo dia. Eis que se aos seus olhos a peste for presa e a peste não se tiver espalhado na pele, então o sacerdote o isolará por mais sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","O sacerdote o examinará novamente no sétimo dia. Eis que, se a praga tiver desaparecido e a peste não se tiver espalhado na pele, então o sacerdote o declarará limpo. É uma sarna. Ele lavará suas roupas, e estará limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mas se a sarna se espalhar na pele depois que ele se mostrar ao padre para sua purificação, ele se mostrará novamente ao padre. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","O sacerdote o examinará; e eis que, se a sarna se espalhar na pele, o sacerdote o declarará impuro. É hanseníase. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Quando a praga da lepra estiver num homem, ele será levado ao padre; ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","e o padre o examinará. Eis que, se houver um inchaço branco na pele, e o pêlo tiver ficado branco, e houver carne crua no inchaço, ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","é uma lepra crônica na pele de seu corpo, e o sacerdote o declarará impuro. Ele não deve isolá-lo, pois ele já está impuro. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Se a hanseníase irrompe por toda a pele, e a lepra cobre toda a pele da pessoa infectada desde sua cabeça até os pés, até onde parece ao padre, ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","então o padre deverá examiná-lo. Eis que, se a lepra cobriu toda sua carne, ele o declarará limpo da praga. Ficou tudo branco: ele está limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mas sempre que a carne crua aparecer nele, ele será imundo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","O sacerdote examinará a carne crua e o declarará imundo: a carne crua é imunda. É hanseníase. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ou se a carne crua vira novamente, e é transformada em branca, então ele virá ao sacerdote. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","O sacerdote o examinará. Eis que, se a praga se tornou branca, então o sacerdote o declarará limpo da praga. Ele está limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Quando o corpo tiver uma fervura na pele, e estiver curado, ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","e no lugar da fervura houver um inchaço branco, ou uma mancha brilhante, branca-avermelhada, então ela será mostrada ao padre. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","O padre deve examiná-la. Eis que, se sua aparência for mais profunda que a pele, e seu cabelo tiver ficado branco, então o sacerdote o declarará impuro. É a praga da hanseníase. Ela se rompeu na fervura. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Mas se o padre a examinar, e eis que não há pêlos brancos nela, e não é mais profunda do que a pele, mas é fraca, então o padre o isolará por sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Se ele se espalhar na pele, então o sacerdote o declarará impuro. É uma praga. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Mas se a mancha brilhante permanece em seu lugar, e não se espalhou, é a cicatriz da fervura; e o sacerdote o declarará limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Ou quando o corpo tem uma queimadura de fogo em sua pele, e a carne crua da queimadura torna-se uma mancha brilhante, branca-avermelhada ou branca, ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","então o padre a examinará; e eis que, se o pêlo na mancha brilhante ficou branco, e sua aparência é mais profunda que a pele, é hanseníase. Ele se rompeu na queimadura, e o padre o declarará impuro. É a praga da hanseníase. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Mas se o padre a examinar, e eis que não há pêlos brancos na mancha brilhante, e não é mais profunda que a pele, mas se desvaneceu, então o padre o isolará sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","O padre o examinará no sétimo dia. Se tiver se espalhado na pele, então o sacerdote o declarará impuro. É a praga da hanseníase. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Se a mancha brilhante permanece em seu lugar, e não se espalhou na pele, mas está desbotada, é o inchaço da queimadura, e o sacerdote o declarará limpo, pois é a cicatriz da queimadura. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Quando um homem ou mulher tiver uma praga na cabeça ou na barba, ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","então o sacerdote examinará a praga; e eis que, se sua aparência for mais profunda que a pele, e o pêlo nela for amarelo e fino, então o sacerdote o declarará impuro. É uma coceira. É hanseníase da cabeça ou da barba. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Se o sacerdote examinar a praga da coceira, e eis que sua aparência não é mais profunda do que a pele, e não há pêlo preto nela, então o sacerdote deverá isolar a pessoa infectada com coceira sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","No sétimo dia o sacerdote examinará a praga; e eis que, se a coceira não se espalhou, e não há pêlos amarelos nela, e a aparência da coceira não é mais profunda do que a pele, ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","então ele será depilado, mas não fará a comichão. Então o padre isolará aquele que tem a coceira por mais sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","No sétimo dia, o sacerdote examinará a coceira; e eis que, se a coceira não se espalhou na pele, e sua aparência não é mais profunda que a pele, então o sacerdote o declarará limpo. Ele lavará suas roupas e estará limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Mas se a coceira se espalhar na pele após sua limpeza, ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","então o sacerdote o examinará; e eis que, se a coceira se espalhou na pele, o sacerdote não procurará o pêlo amarelo; ele está imundo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Mas se nos seus olhos a coceira for presa e os cabelos pretos crescerem nela, então a coceira é curada. Ele está limpo. O padre deve declará-lo limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Quando um homem ou uma mulher tem manchas brilhantes na pele do corpo, mesmo manchas brancas, ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","então o padre deve examiná-las. Eis que, se as manchas brilhantes na pele de seu corpo são um branco baço, trata-se de uma erupção cutânea inofensiva. Ela se rompeu na pele. Ele está limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Se o cabelo de um homem caiu de sua cabeça, ele está careca. Ele está limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Se seu cabelo caiu da parte da frente da cabeça, ele está calvo na testa. Ele está limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mas se uma praga branca-avermelhada estiver na cabeça calva ou na testa calva, é a lepra que está surgindo em sua cabeça calva ou na testa calva. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Então o padre deve examiná-lo. Eis que, se o inchaço da praga for branco-avermelhado em sua cabeça calva, ou em sua testa calva, como a aparência de lepra na pele do corpo, ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ele é um homem leproso. Ele é impuro. O padre certamente o declarará impuro. Sua praga está em sua cabeça. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“O leproso em quem a peste está vestindo roupas rasgadas, e os cabelos de sua cabeça devem ficar soltos. Ele cobrirá seu lábio superior, e gritará: “Impuro! Impuro!”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Todos os dias em que a peste estiver nele, ele será imundo. Ele será imundo. Ele habitará sozinho. Sua morada será fora do acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“A peça de vestuário em que se encontra a praga da lepra, seja ela de lã ou de linho; ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","seja de urdidura ou urdidura; de linho ou de lã; seja de couro ou de qualquer coisa feita de couro; ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","se a praga for esverdeada ou avermelhada na peça de vestuário, ou no couro, ou na urdidura, ou na urdidura, ou em qualquer coisa feita de couro; é a praga da lepra, e deve ser mostrada ao padre. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","O padre examinará a praga e isolará a praga por sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ele examinará a praga no sétimo dia. Se a praga se espalhou na vestimenta, seja na urdidura, seja na trama, seja na pele, seja qual for o uso da pele, a praga é um míldio destrutivo. Ela é impura. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ele deve queimar a peça de vestuário, seja na urdidura ou na trama, na lã ou no linho, ou em qualquer coisa de couro, onde a peste esteja, pois é um míldio destrutivo. Deve ser queimada no fogo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Se o padre a examinar, e eis que a peste não se espalhou na roupa, nem na urdidura, nem na trama, nem em nada de pele; ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","então o padre ordenará que lavem aquilo em que a peste está, e ele a isolará por mais sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","então o sacerdote a examinará, depois que a peste for lavada; e eis que, se a peste não mudou de cor, e a peste não se espalhou, está imunda; queimá-la-á no fogo. É uma mancha mofada, seja por dentro ou por fora. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Se o padre olhar, e eis que a peste se desvaneceu depois de lavada, então a rasgará da roupa, ou da pele, ou da urdidura, ou da trama; ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","e se ela aparecer novamente na roupa, seja na urdidura, ou na trama, ou em qualquer coisa de pele, ela está se espalhando. Você deve queimar o que a peste está com o fogo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","A peça de vestuário, seja na urdidura, ou na trama, ou em qualquer coisa de pele, que você deve lavar, se a peste se afastou deles, então será lavada pela segunda vez, e estará limpa”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Esta é a lei da praga do míldio em uma roupa de lã ou linho, seja na urdidura, ou na trama, ou em qualquer coisa de pele, para declará-la limpa, ou para declará-la impura. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yahweh falou com Moisés, dizendo, ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Esta será a lei do leproso no dia de sua purificação: Ele será levado ao padre, ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","e o padre sairá do acampamento. O sacerdote o examinará. Eis que, se a praga da lepra for curada no leproso, ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","então o sacerdote ordenará que levem para ele, que deve ser limpo, duas aves vivas limpas, madeira de cedro, escarlate e hissopo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","o sacerdote lhes ordenará que matem um dos pássaros em um vaso de barro sobre água corrente. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Quanto à ave viva, ele a tomará, a madeira de cedro, o escarlate e o hissopo, e os mergulhará e a ave viva no sangue da ave que foi morta sobre a água corrente. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ele aspergirá sete vezes sobre aquele que deve ser limpo da lepra e o declarará limpo, e deixará a ave viva ir para o campo aberto. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Aquele que deve ser limpo deve lavar suas roupas, raspar todos os seus cabelos e banhar-se em água; e deve estar limpo. Depois disso, ele entrará no acampamento, mas morará fora de sua tenda sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Será no sétimo dia, que ele raspará todos os seus cabelos da cabeça, a barba e as sobrancelhas. Ele rapará todos os seus cabelos. Lavará suas roupas, e banhará seu corpo em água. Então ele estará limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“No oitavo dia ele levará dois cordeiros machos sem defeito, uma ovelha por ano sem defeito, três décimos de uma efa de farinha fina para uma oferta de refeição, misturada com óleo, e um log de óleo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","O sacerdote que o limpa colocará o homem que deve ser limpo, e essas coisas, antes de Yahweh, na porta da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“O padre pegará um dos cordeiros machos e o oferecerá para uma oferta de transgressão, com o tronco de azeite, e os acenará para uma oferta de onda antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Ele matará o cordeiro macho no lugar onde eles matam a oferta pelo pecado e a oferta queimada, no lugar do santuário; pois assim como a oferta pelo pecado é do sacerdote, também o é a oferta pela culpa. Ela é santíssima. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","O sacerdote tomará parte do sangue da oferta pela culpa, e o sacerdote a colocará na ponta da orelha direita daquele que deve ser purificado, e no polegar de sua mão direita, e no dedo polegar de seu pé direito. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","O sacerdote pegará um pouco do tronco de azeite e o derramará na palma de sua própria mão esquerda. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","O sacerdote mergulhará seu dedo direito no óleo que está em sua mão esquerda, e borrifará parte do óleo com seu dedo sete vezes antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","O sacerdote colocará parte do restante do óleo que está em sua mão na ponta da orelha direita daquele que deve ser purificado, e no polegar da mão direita, e no dedo grande do pé direito, sobre o sangue da oferta de transgressão. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","O restante do óleo que está na mão do sacerdote ele colocará na cabeça daquele que deve ser purificado, e o sacerdote fará expiação por ele antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“O sacerdote oferecerá a oferta pelo pecado e fará expiação por aquele que deve ser purificado por causa de sua impureza. Depois ele matará o holocausto; ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","então o sacerdote oferecerá o holocausto e a oferta de refeição sobre o altar. O sacerdote fará expiação por ele, e ele ficará limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Se ele for pobre, e não puder pagar tanto, então ele levará um cordeiro macho para uma oferta de transgressão a ser acenada, para fazer expiação por ele, e um décimo de uma efa de farinha fina misturada com óleo para uma oferta de refeição, e um tronco de óleo; ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","e duas rolinhas, ou dois pombos jovens, como ele é capaz de pagar; e um será uma oferta pelo pecado, e o outro uma oferta queimada. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“No oitavo dia ele os levará para sua purificação ao padre, à porta da Tenda da Reunião, antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","O sacerdote levará o cordeiro da oferta de transgressão, e o tronco de azeite, e o sacerdote os acenará para uma oferta de onda antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Ele matará o cordeiro da oferta de transgressão. O sacerdote tomará um pouco do sangue da oferta pela culpa e o colocará na ponta da orelha direita daquele que deve ser purificado, e no polegar de sua mão direita, e no dedo polegar de seu pé direito. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","O sacerdote derramará um pouco do óleo na palma de sua própria mão esquerda; ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","e o sacerdote aspergirá com seu dedo direito parte do óleo que está em sua mão esquerda sete vezes antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Então o sacerdote colocará parte do óleo que está em sua mão na ponta da orelha direita daquele que deve ser purificado, e no polegar da mão direita, e no dedo grande do pé direito, no lugar do sangue da oferta de transgressão. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","O resto do óleo que está na mão do sacerdote ele colocará sobre a cabeça daquele que deve ser purificado, para fazer expiação por ele antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Ele oferecerá uma das rolinhas, ou dos pombos jovens, que ele sempre pode pagar, ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","do tipo que ele pode pagar, uma para oferta pelo pecado, e outra para oferta queimada, com a oferta de refeição. O padre fará expiação por aquele que deve ser purificado antes de Yahweh”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Esta é a lei para aquele em quem a praga da hanseníase é a praga, que não é capaz de arcar com o sacrifício para sua purificação. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yahweh falou a Moisés e a Arão, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Quando você tiver entrado na terra de Canaã, que eu lhe dou por uma possessão, e eu colocar um míldio espalhado em uma casa na terra de sua possessão, ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","então aquele que possui a casa virá e dirá ao sacerdote, dizendo: 'Parece-me que há algum tipo de praga na casa'. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","O padre ordenará que esvaziem a casa, antes que o padre entre para examinar a praga, que tudo o que está na casa não seja tornado impuro. Em seguida, o padre deve entrar para inspecionar a casa. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ele examinará a praga; e eis que, se a praga estiver nas paredes da casa com estrias ocas, esverdeadas ou avermelhadas, e parecer ser mais profunda que a parede, ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","então o sacerdote sairá da casa para a porta da casa, e fechará a casa sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","O padre voltará no sétimo dia, e olhará. Se a praga se espalhou nas paredes da casa, ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","então o sacerdote ordenará que retirem as pedras em que está a praga e as joguem em um lugar impuro fora da cidade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ele fará com que o interior da casa seja raspado por toda parte. Eles despejarão a argamassa que rasparam fora da cidade em um lugar impuro. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Pegarão outras pedras, e as colocarão no lugar dessas pedras; e ele pegará outra argamassa, e rebocará a casa. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Se a praga vier novamente, e se alastrar na casa depois de ter tirado as pedras, e depois de ter raspado a casa, e depois de ter sido rebocada, ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","então o padre entrará e olhará; e eis que, se a praga se alastrou na casa, é um míldio destrutivo na casa. É impura. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ele derrubará a casa, suas pedras e sua madeira, e toda a argamassa da casa. Ele as levará para fora da cidade, para um lugar impuro. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Além disso, aquele que entrar na casa enquanto ela estiver fechada, ficará imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Aquele que se deitar na casa lavará suas roupas; e aquele que comer na casa lavará suas roupas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Se o padre entrar e examiná-la, e eis que a praga não se espalhou na casa, depois que a casa foi rebocada, então o padre deverá pronunciar a casa limpa, porque a praga está curada. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Para limpar a casa ele levará dois pássaros, madeira de cedro, escarlate e hissopo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ele matará um dos pássaros em um vaso de barro sobre água corrente. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ele pegará a madeira de cedro, o hissopo, o escarlate e o pássaro vivo e os mergulhará no sangue do pássaro morto, e na água corrente, e aspergirá a casa sete vezes. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ele limpará a casa com o sangue da ave, e com a água corrente, com a ave viva, com a madeira de cedro, com o hissopo, e com o escarlate; ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","mas deixará a ave viva sair da cidade para o campo aberto. Assim ele fará expiação pela casa; e ela será limpa”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Esta é a lei para qualquer praga de hanseníase, e para uma coceira, ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","e para o míldio destrutivo de uma roupa, e para uma casa, ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","e para um inchaço, e para uma sarna, e para uma mancha brilhante; ");
INSERT INTO porbrbsl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","para ensinar quando está suja, e quando está limpa. Esta é a lei da hanseníase. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yahweh falou com Moisés e com Arão, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Fale com os filhos de Israel, e diga-lhes: 'Quando qualquer homem tem uma descarga de seu corpo, por causa de sua descarga, ele é impuro. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Esta será sua impureza na sua descarga: quer seu corpo corra com sua descarga, quer seu corpo tenha parado de ser descarregado, é sua impureza. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“'Toda cama em que jaz aquele que tem a descarga será imunda; e tudo em que ele se senta será imundo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Quem tocar sua cama lavará suas roupas, e se banhará em água, e será imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Aquele que se sentar sobre qualquer coisa sobre a qual o homem que tiver a descarga se sentar lavará suas roupas, e se banhará em água, e será imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“'Aquele que toca o corpo daquele que tem a descarga deve lavar suas roupas, banhar-se em água e ficar impuro até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“'Se aquele que tem a descarga cuspir sobre aquele que está limpo, então ele deverá lavar suas roupas, banhar-se em água e ficar imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“'Seja qual for a sela em que ele que tiver a descarga montar, será imundo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Quem tocar em qualquer coisa que estava debaixo dele será imundo até a noite. Aquele que carrega essas coisas lavará suas roupas, e se banhará em água, e será imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“'Aquele que tiver a descarga toca, sem ter lavado as mãos na água, deve lavar suas roupas, banhar-se em água, e ficar impuro até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“'O vaso de barro, que quem tem a descarga toca, deve ser quebrado; e todo vaso de madeira deve ser enxaguado na água. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“'Quando aquele que tiver uma descarga for limpo de sua descarga, então contará para si mesmo sete dias para sua limpeza, e lavará suas roupas; e banhará sua carne em água corrente, e estará limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","“'No oitavo dia ele levará duas rolinhas, ou dois pombinhos, e virá antes de Yahweh à porta da Tenda da Reunião, e os entregará ao padre. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","O padre os oferecerá, um para oferta pelo pecado, e o outro para oferta queimada. O sacerdote fará expiação por ele diante de Yahweh por sua exoneração. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“'Se qualquer homem tiver uma emissão de sêmen, então ele deve banhar toda sua carne em água, e ficar impuro até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Toda vestimenta e toda a pele em que o sêmen estiver colocado será lavada com água, e ficará imunda até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Se um homem deitar com uma mulher e houver uma emissão de sêmen, ambos se banharão em água e ficarão imundos até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“'Se uma mulher tem uma descarga, e sua descarga em sua carne é sangue, ela estará em sua impureza por sete dias. Quem a tocar será impuro até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“'Tudo aquilo em que ela jaz em sua impureza será impuro. Também tudo aquilo em que ela se senta será imundo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Quem tocar na cama dela deverá lavar suas roupas, banhar-se em água e ficar imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Quem tocar em qualquer coisa sobre a qual ela se sente, lavará suas roupas, e se banhará em água, e será imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Se estiver sobre a cama, ou sobre qualquer coisa em que ela se sente, quando ele a tocar, ficará imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“'Se algum homem se deitar com ela, e seu fluxo mensal estiver sobre ele, será imundo sete dias; e toda cama onde ele se deitar será imunda. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“'Se uma mulher tem uma descarga de seu sangue por muitos dias não no tempo de seu período, ou se ela tem uma descarga além do tempo de seu período, todos os dias da descarga de sua impureza serão como nos dias de seu período. Ela está impura. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Toda cama que ela deitar em todos os dias de sua descarga será para ela como a cama do seu período. Tudo em que ela se sentar será imundo, como a imundícia de seu período. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Quem tocar nestas coisas será imundo, e lavará suas roupas e se banhará em água, e será imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“'Mas se ela for limpa de sua descarga, então ela contará para si mesma sete dias, e depois disso ela estará limpa. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","No oitavo dia, ela levará duas rolinhas, ou dois pombinhos, e os levará ao padre, à porta da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","O sacerdote oferecerá um para oferta pelo pecado, e o outro para holocausto; e o sacerdote fará expiação por ela diante de Yahweh pela imundícia de sua descarga. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“'Assim separareis os filhos de Israel de sua impureza, para que não morram em sua impureza quando profanarem meu tabernáculo que está entre eles'”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Esta é a lei daquele que tem uma descarga, e daquele que tem uma emissão de sêmen, de modo que ele é impuro por ela; ");
INSERT INTO porbrbsl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","e daquela que tem seu período, e de um homem ou mulher que tem uma descarga, e daquele que se deita com ela que é impuro. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Yahweh falou a Moisés após a morte dos dois filhos de Aarão, quando eles se aproximaram antes de Yahweh, e morreram; ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","e Yahweh disse a Moisés: “Diga a Aarão seu irmão que não venha a qualquer momento ao Santíssimo Lugar dentro do véu, diante do propiciatório que está sobre a arca; para que ele não morra; pois eu aparecerei na nuvem sobre o propiciatório. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Aaron entrará no santuário com um touro jovem para oferta pelo pecado e um carneiro para oferta queimada. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","“Ele colocará a túnica de linho sagrado. Ele terá as calças de linho em seu corpo, e vestirá a faixa de linho, e será revestido com o turbante de linho. Eles são as vestes sagradas. Ele banhará seu corpo em água, e as vestirá. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Ele tomará da congregação dos filhos de Israel dois bodes masculinos para oferta pelo pecado e um carneiro para holocausto. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Aarão oferecerá o touro da oferta pelo pecado, que é para si mesmo, e fará expiação por si mesmo e por sua casa. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ele levará os dois bodes, e os colocará à porta da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Arão lançará sorteio para os dois bodes: um lote para Javé e o outro lote para o bode expiatório. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Arão apresentará o bode sobre o qual o lote caiu para Iavé, e o oferecerá por uma oferta pelo pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Mas o bode sobre o qual o lote caiu para o bode expiatório será apresentado vivo perante Iavé, para fazer expiação por ele, para mandá-lo embora como bode expiatório para o deserto. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Arão apresentará o touro da oferta pelo pecado, que é para si mesmo, e fará expiação por si e por sua casa, e matará o touro da oferta pelo pecado que é para si mesmo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ele tomará um incensário cheio de brasas de fogo do altar diante de Javé, e dois punhados de incenso doce batido pequeno, e o trará dentro do véu. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ele colocará o incenso no fogo diante de Yahweh, para que a nuvem do incenso possa cobrir o assento de misericórdia que está no pacto, para que ele não morra. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ele tomará um pouco do sangue do touro e o polvilhará com o dedo sobre o propiciatório no leste; e diante do propiciatório ele polvilhará um pouco do sangue com o dedo sete vezes. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Então ele matará o bode da oferta pelo pecado que é pelo povo, e trará seu sangue dentro do véu, e fará com seu sangue como fez com o sangue do touro, e o polvilhará sobre o propiciatório e diante do propiciatório. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ele fará expiação pelo Santo Lugar, por causa da imundícia dos filhos de Israel, e por causa de suas transgressões, mesmo todos os seus pecados; e assim fará pela Tenda da Reunião que habita com eles no meio de sua imundícia. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ninguém estará na Tenda da Reunião quando ele entrar para fazer expiação no Santo Lugar, até que ele saia, e tenha feito expiação por si mesmo e por sua casa, e por toda a assembléia de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Ele sairá ao altar que está diante de Javé e fará expiação por ele, e tomará um pouco do sangue do touro, e um pouco do sangue do bode, e o colocará em torno dos chifres do altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ele aspergirá um pouco do sangue com o dedo sete vezes, e o purificará, e o santificará da imundícia dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Quando tiver terminado de expiar o Santo Lugar, a Tenda da Reunião e o altar, ele apresentará o bode vivo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Arão porá ambas as mãos sobre a cabeça do bode vivo e confessará sobre ele todas as iniquidades dos filhos de Israel, e todas as suas transgressões, mesmo todos os seus pecados; e os porá sobre a cabeça do bode, e o mandará para o deserto pela mão de um homem que esteja pronto. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","O bode levará todas as suas iniquidades sobre si mesmo para uma terra solitária, e ele soltará o bode no deserto. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Aaron entrará na Tenda da Reunião, e tirará as roupas de linho que colocou quando entrou no Lugar Santo, e as deixará lá. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Então ele se banhará em água num lugar santo, vestirá suas vestes e sairá para oferecer seu holocausto e o holocausto do povo, e fará expiação por si e pelo povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","A gordura da oferta pelo pecado, ele queimará sobre o altar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Aquele que soltar o bode como bode expiatório lavará suas roupas, e banhará sua carne em água, e depois entrará no acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“O touro para a oferta pelo pecado, e o bode para a oferta pelo pecado, cujo sangue foi trazido para fazer expiação no Lugar Santo, serão levados para fora do acampamento; e queimarão suas peles, sua carne, e seu esterco com fogo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Aquele que os queimar lavará suas vestes, e banhará sua carne em água, e depois entrará no acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Será um estatuto para vós para sempre: no sétimo mês, no décimo dia do mês, afligireis vossas almas, e não fareis nenhum tipo de trabalho, quer nascido nativo ou estrangeiro que viva como estrangeiro entre vós; ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","pois neste dia será feita expiação por vós, para purificar-vos. Estareis limpos de todos os vossos pecados diante de Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","É um sábado de descanso solene para vós, e afligireis vossas almas. É um estatuto para sempre. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","O sacerdote, que é ungido e que é consagrado sacerdote no lugar de seu pai, fará a expiação, e vestirá as vestes de linho, até mesmo as vestes sagradas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Então fará expiação pelo Santo Santuário; e fará expiação pela Tenda da Assembléia e pelo altar; e fará expiação pelos sacerdotes e por todo o povo da Assembléia. ");
INSERT INTO porbrbsl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Este será um estatuto eterno para você, para fazer expiação pelos filhos de Israel uma vez no ano por causa de todos os seus pecados”. Foi feito como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Fale a Arão, e a seus filhos, e a todos os filhos de Israel, e diga a eles: 'Isto é o que Yahweh ordenou': ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Qualquer homem da casa de Israel que mate um touro, ou cordeiro, ou cabra no acampamento, ou que o mate fora do acampamento, ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","e não o tenha levado à porta da Tenda da Reunião para oferecê-lo como oferta a Javé perante o tabernáculo de Javé: o sangue será imputado a esse homem. Ele derramou sangue. Aquele homem será cortado do meio de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Isto é para que os filhos de Israel possam trazer seus sacrifícios, que sacrificam em campo aberto, para que os levem a Iavé, à porta da Tenda da Reunião, ao sacerdote, e os sacrifiquem por sacrifícios de ofertas de paz a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","O sacerdote aspergirá o sangue no altar de Iavé, na porta da Tenda da Reunião, e queimará a gordura para um aroma agradável a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Eles não sacrificarão mais seus sacrifícios aos ídolos da cabra, depois dos quais se farão de prostituta. Isto será um estatuto para eles para sempre ao longo de suas gerações”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Dir-lhes-eis: “Qualquer homem da casa de Israel, ou dos estrangeiros que vivem como estrangeiros entre eles, que oferece um holocausto ou sacrifício, ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","e não o traz à porta da Tenda da Reunião para sacrificá-lo a Javé, esse homem será cortado de seu povo”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“'Qualquer homem da casa de Israel, ou dos estrangeiros que vivem como estrangeiros entre eles, que come qualquer tipo de sangue, eu colocarei meu rosto contra aquela alma que come sangue, e o cortarei do meio de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Pois a vida da carne está no sangue. Eu vos dei no altar para fazer expiação por vossas almas; pois é o sangue que faz expiação em razão da vida. ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Portanto, eu disse aos filhos de Israel: “Nenhuma pessoa entre vós pode comer sangue, nem nenhum estrangeiro que vive como estrangeiro entre vós pode comer sangue”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“'Seja qual for o homem dos filhos de Israel, ou dos estranhos que vivem como estrangeiros entre eles, que leva em caça qualquer animal ou ave que possa ser comido, ele derramará seu sangue, e o cobrirá com pó. ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Pois, quanto à vida de toda carne, seu sangue está com sua vida. Por isso eu disse aos filhos de Israel: “Não comereis o sangue de qualquer tipo de carne; pois a vida de toda carne é o seu sangue”. Quem quer que a comer será cortado”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“'Toda pessoa que come o que morre de si mesma, ou o que é rasgado por animais, seja nativa ou estrangeira, deve lavar suas roupas, banhar-se em água, e ficar impura até a noite. Então, ele deve estar limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Mas se ele não as lavar, ou não banhar sua carne, então suportará sua iniqüidade'”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yahweh disse a Moisés, ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Fala aos filhos de Israel e diz-lhes: 'Eu sou Yahweh, vosso Deus'. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Não fareis como eles fazem na terra do Egito, onde vivestes. Não farás como eles fazem na terra de Canaã, onde eu te trago”. Não seguireis os estatutos deles. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Você fará minhas ordenanças. Guardareis os meus estatutos e andareis neles. Eu sou Yahweh, vosso Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Portanto, guardareis meus estatutos e minhas ordenanças, as quais, se um homem as cumprir, viverá nelas. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“'Nenhum de vocês deve se aproximar de parentes próximos, para descobrir a nudez deles: Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“'Você não deve descobrir a nudez de seu pai, nem a nudez de sua mãe: ela é sua mãe. Você não deve descobrir a nudez dela. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“'Você não deve descobrir a nudez da esposa de seu pai. É a nudez de seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“'Você não deve descobrir a nudez de sua irmã, da filha de seu pai ou da filha de sua mãe, nascida em casa ou nascida no exterior. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“'Você não descobrirá a nudez da filha de seu filho, ou da filha de sua filha, mesmo a nudez deles; pois a nudez deles é sua própria nudez. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“'Você não deve descobrir a nudez da filha da esposa de seu pai, concebida por seu pai, já que ela é sua irmã. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“'Você não deve descobrir a nudez da irmã de seu pai. Ela é a parente próxima de seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“'Você não deve descobrir a nudez da irmã de sua mãe, pois ela é a parente próxima de sua mãe. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“'Você não deve descobrir a nudez do irmão de seu pai. Não te aproximarás da esposa dele. Ela é sua tia. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“'Você não deve descobrir a nudez de sua nora. Ela é a esposa de seu filho. Você não deve desvendar a nudez dela. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“'Você não deve descobrir a nudez da esposa de seu irmão. É a nudez de seu irmão. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“'Você não deve descobrir a nudez de uma mulher e de sua filha. Você não deve levar a filha de seu filho, ou a filha de sua filha, para desvendar sua nudez. Elas são parentes próximas. É a perversidade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“'Você não deve levar uma esposa além de sua irmã, para ser uma rival, para descobrir sua nudez, enquanto sua irmã ainda estiver viva. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“'Você não deve se aproximar de uma mulher para descobrir sua nudez, desde que ela seja impura por sua impureza. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“'Você não deve mentir carnalmente com a esposa de seu vizinho e se contaminar com ela. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“'Você não deve dar nenhum de seus filhos como sacrifício a Molech. Você não profanará o nome de seu Deus. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“'Você não deve deitar-se com um homem como com uma mulher. Isso é detestável. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“'Você não deve deitar-se com nenhum animal para se contaminar com ele. Nenhuma mulher pode se entregar a um animal, deitar-se com ele: é uma perversão. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“'Não se contaminem em nenhuma destas coisas; pois em todas estas nações que estou expulsando antes de vocês foram contaminadas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","A terra foi profanada. Portanto, castiguei sua iniqüidade e a terra vomitou seus habitantes. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Portanto, guardareis meus estatutos e minhas ordenanças, e não fareis nenhuma destas abominações; nem o nativo nascido, nem o estrangeiro que vive como estrangeiro entre vós ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(para os homens da terra que foram antes de vós que fizeram todas estas abominações, e a terra foi contaminada), ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","que a terra não vos vomite também, quando a contaminardes, como vomitou a nação que foi antes de vós. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“'Para quem quer que faça qualquer uma destas abominações, até mesmo as almas que as fizerem serão cortadas do meio de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Portanto, guardareis minhas exigências, que não pratiqueis nenhum desses abomináveis costumes que foram praticados antes de vós, e que não vos contamineis com eles. Eu sou Yahweh, vosso Deus”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Javé falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Fala a toda a congregação dos filhos de Israel e diz-lhes: 'Sereis santos, porque eu, Javé, vosso Deus, sou santo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“'Cada um de vocês deve respeitar sua mãe e seu pai. Vocês guardarão meus sábados. Eu sou Yahweh, vosso Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“'Não se voltem para ídolos, nem façam deuses derretidos para si mesmos. Eu sou Yahweh, vosso Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“'Quando você oferece um sacrifício de ofertas de paz a Iavé, você deve oferecê-lo para que possa ser aceito. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Será comido no mesmo dia em que você o oferecer, e no dia seguinte. Se algo permanecer até o terceiro dia, será queimado com fogo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Se for comido no terceiro dia, é uma abominação. Não será aceita; ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","mas todo aquele que a comer levará sua iniqüidade, porque profanou a coisa santa de Javé, e essa alma será cortada de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“'Quando você colher a colheita de sua terra, não deverá colher totalmente os cantos de seu campo, nem colher os respigões de sua colheita. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Você não colherá seu vinhedo, nem colherá as uvas caídas de seu vinhedo. Você as deixará para os pobres e para os estrangeiros. Eu sou Yahweh, vosso Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“'Você não deve roubar. “'Você não deve mentir. “'Vocês não se enganarão uns aos outros. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“'Você não jurará falsamente pelo meu nome, e profanará o nome de seu Deus. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“'Você não deve oprimir seu vizinho, nem roubá-lo. “'O salário de um empregado contratado não deve permanecer com você a noite toda até a manhã. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“'Não amaldiçoareis os surdos, nem colocareis um tropeço diante dos cegos; mas temereis a vosso Deus. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“'Você não deve fazer injustiça no julgamento. Não serás parcial para com os pobres, nem mostrarás favoritismo para com os grandes; mas julgarás teu próximo com justiça. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“'Você não deve andar por aí como um caluniador entre seu povo. “'Você não porá em perigo a vida de seu próximo. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“'Você não deve odiar seu irmão em seu coração. Certamente repreenderás teu próximo, e não suportarás o pecado por causa dele. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“'Você não se vingará, nem guardará rancor contra os filhos de seu povo; mas amará seu próximo como a si mesmo. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“'Vocês devem manter meus estatutos. “'Você não deve cruzar diferentes tipos de animais. “'Você não deve semear seu campo com dois tipos de sementes; “'Não use uma peça de vestuário feita de dois tipos de material. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“'Se um homem se deita carnalmente com uma mulher que é escrava, prometeu se casar com outro homem e não foi resgatada ou lhe foi dada liberdade; eles serão punidos. Não serão condenados à morte, porque ela não foi livre. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ele levará sua oferta de transgressão a Iavé, à porta da Tenda da Reunião, até mesmo um carneiro para uma oferta de transgressão. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","O sacerdote fará expiação por ele com o carneiro da oferta pela culpa perante Iavé por seu pecado que cometeu; e o pecado que cometeu lhe será perdoado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“'Quando você entrar na terra, e tiver plantado todos os tipos de árvores para alimentação, então você contará seus frutos como proibidos. Durante três anos, será proibido para você. Não serão comidos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Mas no quarto ano todos os seus frutos serão sagrados, para louvar a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","No quinto ano comereis seu fruto, para que ele possa render-vos seu aumento. Eu sou Yahweh, vosso Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“'Você não deve comer nenhuma carne com o sangue ainda dentro dela. Não usarás encantamentos, nem praticarás feitiçaria. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“'Você não deve cortar o cabelo nos lados da cabeça ou cortar a borda da barba. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“'Você não deve fazer nenhum corte em sua carne para os mortos, nem tatuar nenhuma marca em você. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“'Não profane sua filha, para fazer dela uma prostituta; para que a terra não caia na prostituição e a terra não se torne cheia de maldade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“'Guardareis meus sábados, e reverenciareis meu santuário; eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“'Não se volte para aqueles que são médiuns, nem para os feiticeiros. Não os procure, para ser contaminado por eles. Eu sou Yahweh, seu Deus”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“'Você se levantará diante da cabeça cinzenta e honrará o rosto dos idosos; e temerá seu Deus. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“'Se um estranho vive como estrangeiro com você em sua terra, você não deve fazer mal a ele. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","O estrangeiro que vive como estrangeiro contigo será para ti como o nativo nascido entre vocês, e tu o amarás como a ti mesmo; pois tu viveste como estrangeiro na terra do Egito. Eu sou Yahweh, vosso Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“'Você não deve fazer injustiça no julgamento, nas medidas de comprimento, de peso ou de quantidade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","“'Você terá apenas equilíbrios, apenas pesos, um efah justo e um hin justo. Eu sou Yahweh, vosso Deus, que vos tirou da terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“'Observará todos os meus estatutos e todos os meus decretos, e os cumprirá. Eu sou Yahweh”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yahweh falou a Moisés, dizendo, ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Além disso, você deve dizer aos filhos de Israel, “Qualquer um dos filhos de Israel, ou dos estrangeiros que vivem como estrangeiros em Israel, que der qualquer de seus descendentes a Molech certamente será condenado à morte. O povo da terra apedrejará essa pessoa com pedras”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Também colocarei meu rosto contra essa pessoa, e o cortarei do meio de seu povo, porque ele deu de sua prole a Moloque, para profanar meu santuário e profanar meu santo nome. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Se o povo da terra esconder seus olhos dessa pessoa quando ele der de sua descendência a Molech, e não o matar, ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","então colocarei meu rosto contra esse homem e contra sua família, e o cortarei, e todos que se fizerem de prostituta depois dele para fazer de prostituta com Molech, do meio de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“'A pessoa que se volta para aqueles que são médiuns e feiticeiros, para se fazer de prostituta depois deles, eu vou até colocar meu rosto contra aquela pessoa, e vou cortá-lo do meio de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“'Santificai-vos, portanto, e sede santos, pois eu sou Yahweh, vosso Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Guardareis meus estatutos, e os cumprireis. Eu sou Yahweh, que vos santifica. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“'Pois todo aquele que amaldiçoa seu pai ou sua mãe certamente será condenado à morte. Ele amaldiçoou seu pai ou sua mãe. Seu sangue estará sobre si mesmo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“'O homem que comete adultério com a esposa de outro homem, mesmo aquele que comete adultério com a esposa do vizinho, o adúltero e a adúltera serão certamente mortos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“'O homem que se deita com a esposa de seu pai descobriu a nudez de seu pai. Ambos certamente serão condenados à morte. O sangue deles estará sobre si mesmos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“'Se um homem se deita com sua nora, ambos certamente serão condenados à morte. Eles cometeram uma perversão. O sangue deles estará sobre si mesmos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“'Se um homem se deita com um homem, como com uma mulher, ambos cometeram uma abominação. Certamente serão condenados à morte. O sangue deles estará sobre si mesmos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“'Se um homem leva uma esposa e sua mãe, é uma maldade. Eles serão queimados com fogo, tanto ele como eles, para que não haja maldade entre vós. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“'Se um homem se deitar com um animal, certamente será morto; e você matará o animal. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“'Se uma mulher se aproxima de qualquer animal e se deita com ele, você deve matar a mulher e o animal. Eles certamente serão mortos. O sangue deles estará sobre eles. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“'Se um homem leva sua irmã - a filha de seu pai, ou a filha de sua mãe - e vê sua nudez, e ela vê sua nudez, é uma vergonha. Eles devem ser cortados à vista dos filhos de seu povo. Ele descobriu a nudez de sua irmã. Ele deve suportar sua iniqüidade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“'Se um homem se deita com uma mulher tendo seu período mensal, e descobre sua nudez, ele a fez nua, e ela descobriu a fonte de seu sangue. Ambos devem ser cortados do meio de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“'Você não deve descobrir a nudez da irmã de sua mãe, nem da irmã de seu pai, pois ele fez seu parente próximo ficar nu. Eles devem suportar sua iniqüidade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Se um homem deitar-se com a mulher de seu tio, ele terá descoberto a nudez de seu tio. Eles suportarão seus pecados. Eles morrerão sem filhos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“'Se um homem leva a esposa de seu irmão, é uma impureza. Ele descobriu a nudez de seu irmão. Eles devem ser sem filhos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“'Portanto, guardareis todos os meus estatutos e todos os meus decretos, e os cumprireis, para que a terra onde vos levo para morar não vos vomite. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","“'Não andareis nos costumes da nação que estou expulsando diante de vós; pois eles fizeram todas essas coisas, e por isso eu os abomino. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Mas eu vos disse: “Herdareis a terra deles, e eu vo-la darei para possuí-la, uma terra que mana leite e mel”. Eu sou Yahweh, vosso Deus, que vos separou dos povos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“'Você deve, portanto, fazer uma distinção entre o animal limpo e o impuro, e entre a ave impura e o limpo. Vocês não se tornarão abomináveis pelo animal, ou pela ave, ou por qualquer coisa com que o solo fervilha, que eu separei de vocês como impuro para vocês. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Sereis santos para mim, pois eu, Javé, sou santo e vos separei dos povos, para que sejais meus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“'Um homem ou uma mulher que seja um médium ou um feiticeiro certamente será condenado à morte. Eles devem ser apedrejados com pedras. O sangue deles será sobre si mesmos””. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Javé disse a Moisés: “Fala aos sacerdotes, filhos de Aarão, e diz-lhes: 'O sacerdote não se contaminará pelos mortos entre seu povo, ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","exceto por seus parentes que lhe são próximos: por sua mãe, por seu pai, por seu filho, por sua filha, por seu irmão, ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","e por sua irmã virgem que lhe é próxima, que não teve marido; por ela ele pode se contaminar. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ele não se profanará, sendo um chefe entre seu povo, para profanar-se a si mesmo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“'Eles não devem raspar a cabeça ou raspar os cantos da barba ou fazer qualquer corte na carne. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Serão santos ao seu Deus, e não profanarão o nome do seu Deus, pois oferecerão as ofertas de Javé feitas pelo fogo, o pão do seu Deus. Portanto, serão santos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“'Eles não devem se casar com uma mulher que seja prostituta ou profana. Um padre não se casará com uma mulher divorciada de seu marido; pois ele é santo para seu Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Portanto o santificareis, pois ele oferece o pão de vosso Deus. Ele será santo para vós, pois eu, Yahweh, que vos santifica, sou santo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“'A filha de qualquer padre, se ela se profana fazendo-se de prostituta, ela profana o pai. Ela deve ser queimada com fogo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“'Aquele que é o sumo sacerdote entre seus irmãos, sobre cuja cabeça se derrama o óleo da unção, e que se consagra a vestir as vestes, não deixará soltar os cabelos de sua cabeça, nem rasgará suas roupas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ele não deve entrar em nenhum cadáver, nem se contaminar por seu pai ou por sua mãe. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ele não deve sair do santuário, nem profanar o santuário de seu Deus; pois a coroa do óleo da unção de seu Deus está sobre ele. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“'Ele deve ter uma esposa na sua virgindade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ele não se casará com uma viúva, ou uma divorciada, ou uma mulher que tenha sido profanada, ou uma prostituta. Ele tomará uma virgem de seu próprio povo como esposa. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Ele não profanará sua descendência entre seu povo, pois eu sou Yahweh, que o santifica”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“ Diga a Arão: “Nenhum de seus descendentes através de suas gerações que tem um defeito pode se aproximar para oferecer o pão de seu Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Para qualquer homem que tenha um defeito, ele não se aproximará: um homem cego, ou coxo, ou que tenha um nariz liso, ou qualquer deformidade, ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ou um homem que tenha um pé ferido, ou uma mão ferida, ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ou corcunda, ou um anão, ou um que tenha um defeito no olho, ou uma doença de coceira, ou crostas, ou que tenha testículos danificados. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Nenhum homem da descendência de Aarão, o sacerdote que tem um defeito, se aproximará para oferecer as ofertas de Yahweh feitas pelo fogo. Como ele tem um defeito, ele não se aproximará para oferecer o pão de seu Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ele comerá o pão de seu Deus, tanto do santíssimo, como do santo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ele não se aproximará do véu, nem do altar, porque tem um defeito; para não profanar meus santuários, pois eu sou Yahweh que os santifica”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Então Moisés falou com Arão, com seus filhos e com todos os filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Diga a Arão e seus filhos que se separem das coisas santas dos filhos de Israel, que eles me santificam, e que não profanem meu santo nome. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Diga-lhes: “Se alguém de todos os seus descendentes através de suas gerações se aproximar das coisas sagradas que os filhos de Israel santificam a Javé, tendo sua imundícia sobre ele, essa alma será cortada de diante de mim”. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“'Quem da descendência de Aaron for um leproso ou tiver uma descarga não comerá das coisas sagradas até que esteja limpo. Quem tocar em qualquer coisa que seja impura pelos mortos, ou um homem que tenha uma emissão seminal, ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ou quem tocar em qualquer coisa rasteira pela qual ele possa ser tornado impuro, ou um homem de quem ele possa tornar-se impuro, qualquer imundícia que ele tenha - ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","a pessoa que tocar em qualquer uma delas será imunda até a noite, e não comerá das coisas sagradas a menos que banhe seu corpo em água. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Quando o sol se puser, ele estará limpo; e depois comerá das coisas sagradas, porque o pão é seu. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ele não comerá o que morre por si mesmo ou é rasgado por animais, contaminando-se por ele. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“'Devem, portanto, seguir meu mandamento, para que não sofram pecado por ele e não morram nele, se o profanarem. Eu sou Yahweh, que os santifica. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“'Nenhum estranho comerá da coisa santa: um estrangeiro que viva com os sacerdotes, ou um servo contratado, não comerá da coisa santa. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mas se um sacerdote comprar um escravo, comprado por seu dinheiro, ele comerá dele; e aqueles que nasceram em sua casa comerão de seu pão. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Se a filha de um padre for casada com um forasteiro, ela não comerá da oferta alçada das coisas sagradas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Mas se a filha de um sacerdote for viúva, ou divorciada, e não tiver filhos, e tiver retornado à casa de seu pai como na sua juventude, ela poderá comer do pão de seu pai; mas nenhum estranho comerá dele. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“'Se um homem comer algo sagrado sem querer, então ele acrescentará a quinta parte de seu valor a ele, e dará a coisa sagrada ao sacerdote. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Os sacerdotes não profanarão as coisas santas dos filhos de Israel, que oferecem a Javé, ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","e assim os farão suportar a iniqüidade que traz a culpa quando comem suas coisas santas; pois eu sou o Javé que os santifica””. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Fale a Arão, e a seus filhos, e a todos os filhos de Israel, e diga-lhes: 'Quem for da casa de Israel, ou dos estrangeiros em Israel, que oferecer sua oferta, quer seja qualquer de seus votos, quer seja qualquer de suas ofertas de livre vontade, que eles ofereçam a Yahweh por uma oferta queimada': ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","that você pode ser aceito, você deve oferecer um macho sem defeito, dos touros, das ovelhas, ou dos caprinos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Mas você não oferecerá nada que tenha defeito, pois não será aceitável para você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Quem oferecer um sacrifício de ofertas de paz a Javé para cumprir um voto, ou por uma oferta de livre vontade do rebanho ou do rebanho, será perfeito para ser aceito. Não deverá ter nenhum defeito. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Você não deve oferecer o que é cego, está ferido, está mutilado, tem uma verruga, está apodrecendo, ou tem uma ferida que corre para Iavé, nem fazer uma oferta por fogo deles no altar a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Either um touro ou um cordeiro que tenha qualquer deformidade ou falta em suas partes, que você pode oferecer por uma oferta de livre vontade; mas por um voto não será aceito. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Você não deve oferecer a Javé aquilo que tem seus testículos machucados, esmagados, quebrados ou cortados. Você não deve fazer isso em sua terra. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Você não deve oferecer nenhum destes como o pão de seu Deus da mão de um estrangeiro, porque sua corrupção está neles. Há um defeito neles. Eles não devem ser aceitos por você”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Quando um touro, uma ovelha ou um bode nasce, ele permanecerá sete dias com sua mãe. A partir do oitavo dia ele será aceito para a oferta de uma oferta feita por fogo a Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Seja uma vaca ou uma ovelha, você não a matará nem a seus filhotes em um só dia. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Quando você sacrificar um sacrifício de ação de graças a Iavé, deverá sacrificá-lo para que possa ser aceito. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Será comido no mesmo dia; você não deixará nada dele até a manhã. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Portanto, guardareis meus mandamentos e os cumprireis”. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Não profanareis meu santo nome, mas eu serei santificado entre os filhos de Israel. Eu sou Yahweh que vos faz santos, ");
INSERT INTO porbrbsl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","que vos tirou da terra do Egito, para ser vosso Deus. Eu sou Yahweh”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Fala aos filhos de Israel, e diz-lhes: 'As festas fixas de Yahweh, que vocês proclamarão como sendo santas convocações, mesmo estas são as minhas festas fixas'. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“'Seis dias de trabalho devem ser feitos, mas no sétimo dia é um sábado de descanso solene, uma santa convocação; você não deve fazer nenhum tipo de trabalho. É um sábado para Yahweh em todas as suas habitações. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“'Estas são as festas estabelecidas de Yahweh, mesmo as santas convocações, que vocês proclamarão em sua época designada. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“'No primeiro mês, no décimo quarto dia do mês à noite, é a Páscoa de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","No décimo quinto dia do mesmo mês, é a festa dos pães ázimos a Iavé. Sete dias você comerá pães ázimos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","No primeiro dia, você terá uma santa convocação. Você não fará nenhum trabalho regular. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Mas oferecereis uma oferta feita por fogo a Iavé por sete dias. No sétimo dia é uma santa convocação. Não fareis trabalho regular'”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Fala aos filhos de Israel e diz-lhes: 'Quando entrardes na terra que eu vos dou, e ceifardes sua colheita, então trareis o molho das primícias de vossa colheita ao sacerdote'. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ele acenará o molho antes de Yahweh, para ser aceito por vocês. No dia seguinte, após o sábado, o sacerdote o acenará. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","No dia em que você acenar o molho, você oferecerá um cordeiro macho sem defeito com um ano de idade para uma oferta queimada a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","A oferta de refeição com ele será dois décimos de uma efa de farinha fina misturada com óleo, uma oferta feita pelo fogo a Iavé para um aroma agradável; e a oferta de bebida com ele será de vinho, a quarta parte de um hin. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Não se deve comer pão, nem grãos torrados, nem grãos frescos, até este mesmo dia, até que se tenha trazido a oferenda de seu Deus. Este é um estatuto para sempre ao longo de suas gerações em todas as suas habitações. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“'Você contará a partir do dia seguinte após o sábado, a partir do dia que você trouxe o molho da oferta da onda: sete sábados serão completados. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","“'No dia seguinte após o sétimo sábado, você contará cinqüenta dias; e oferecerá uma nova oferta de refeição a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Você trará de suas habitações dois pães para uma oferta de onda feita de dois décimos de uma efa de farinha fina. Eles serão cozidos com fermento, para primeiras frutas a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Você apresentará com o pão sete cordeiros sem defeito com um ano de idade, um touro jovem e dois carneiros. Eles serão um holocausto para Iavé, com sua oferta de refeição e suas ofertas de bebida, mesmo uma oferta feita pelo fogo, de um aroma doce para Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Você oferecerá um bode macho por uma oferta pelo pecado, e dois cordeiros machos por ano de idade por um sacrifício de ofertas de paz. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","O sacerdote os acenará com o pão das primícias para uma oferta de ondas perante Iavé, com os dois cordeiros. Eles serão santos a Javé para o sacerdote. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Você fará a proclamação, no mesmo dia, de que haverá uma santa convocação para você. Você não fará nenhum trabalho regular. Este é um estatuto para sempre em todas as suas residências, através de suas gerações. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“'Quando você colhe a terra, não deve colher totalmente nos cantos de seu campo. Você não deve colher os respigões de sua colheita. Você deve deixá-los para os pobres e para os estrangeiros. Eu sou Yahweh, vosso Deus”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Fale aos filhos de Israel, dizendo: 'No sétimo mês, no primeiro dia do mês, haverá um descanso solene para você, um memorial de soar trombetas, uma santa convocação. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Você não fará nenhum trabalho regular. Oferecerás uma oferta feita pelo fogo a Javé”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“No entanto, no décimo dia deste sétimo mês é o dia da expiação. Será uma santa convocação para você. Vós vos afligireis e oferecereis uma oferta feita pelo fogo a Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Não fareis nenhum tipo de trabalho nesse mesmo dia, pois é um dia de expiação, para fazer expiação por vós perante Yahweh vosso Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Pois quem quer que seja que não se negue nesse mesmo dia, será cortado de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Quem quer que faça qualquer tipo de trabalho nesse mesmo dia, eu destruirei essa pessoa do meio de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Você não fará nenhum tipo de trabalho: é um estatuto para sempre através de suas gerações em todas as suas habitações. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Será um sábado de descanso solene para vocês, e vocês se negarão. No nono dia do mês à noite, de noite em noite, guardareis o vosso sábado”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Fale com as crianças de Israel e diga: 'No décimo quinto dia deste sétimo mês é a festa dos estandes por sete dias para Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","No primeiro dia será uma santa convocação. Você não deverá fazer nenhum trabalho regular. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Sete dias você oferecerá uma oferta feita por fogo a Iavé. No oitavo dia, será uma santa convocação para você. Você oferecerá uma oferta feita pelo fogo a Iavé. É uma assembléia solene; você não fará nenhum trabalho regular. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“'Estas são as festas designadas de Yahweh que você proclamará como sendo convocações sagradas, para oferecer uma oferta feita pelo fogo a Yahweh, uma oferta queimada, uma oferta de refeição, um sacrifício e ofertas de bebida, cada uma em seu próprio dia - ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","além dos sábados de Yahweh, e em adição aos seus presentes, e em adição a todos os seus votos, e em adição a todas as suas ofertas de livre vontade, que você dá a Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“'Então, no décimo quinto dia do sétimo mês, quando você tiver colhido os frutos da terra, você deve manter a festa de Yahweh sete dias. No primeiro dia será um descanso solene, e no oitavo dia será um descanso solene. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","No primeiro dia tomarás os frutos de árvores majestosas, ramos de palmeiras e ramos de árvores grossas e salgueiros do riacho; e te alegrarás diante de Javé teu Deus sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Você o guardará como um banquete para Iavé sete dias no ano. É um estatuto para sempre ao longo de suas gerações. Você o guardará no sétimo mês. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Você deverá morar em abrigos temporários por sete dias. Todos os nativos de Israel morarão em abrigos temporários, ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","para que suas gerações saibam que eu fiz os filhos de Israel morar em abrigos temporários quando os tirei da terra do Egito. Eu sou Yahweh, vosso Deus”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Assim, Moisés declarou aos filhos de Israel as festas designadas de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yahweh falou a Moisés, dizendo, ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Comande os filhos de Israel, que eles lhe tragam azeite de oliva puro batido para a luz, para fazer com que uma lâmpada arda continuamente. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Fora do véu do Testemunho, na Tenda da Reunião, Aarão deve mantê-lo em ordem da noite à manhã antes de Yahweh continuamente. Será um estatuto para sempre ao longo de suas gerações. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ele manterá em ordem as lâmpadas da lâmpada de ouro puro diante de Yahweh continuamente. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Você deve pegar farinha fina e assar doze bolos dela: dois décimos de um efa devem estar em um bolo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","“Você os colocará em duas fileiras, seis em uma fileira, na mesa de ouro puro, antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Você colocará incenso puro em cada fileira, para que seja ao pão para um memorial, mesmo uma oferta feita pelo fogo a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Todo dia de sábado, ele o porá em ordem diante de Iavé continuamente. É um pacto eterno em nome dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Será para Aarão e seus filhos. Eles o comerão num lugar santo; pois para ele é santíssimo as ofertas de Javé feitas pelo fogo por um estatuto perpétuo”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","O filho de uma mulher israelita, cujo pai era egípcio, saiu entre os filhos de Israel; e o filho da mulher israelita e um homem de Israel lutaram juntos no acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","O filho da mulher israelita blasfemou o Nome, e amaldiçoou; e o trouxeram a Moisés. O nome de sua mãe era Shelomith, a filha de Dibri, da tribo de Dan. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Eles o colocaram sob custódia até que o testamento de Iavé lhes fosse declarado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Tragam aquele que amaldiçoou para fora do acampamento; e que todos os que o ouviram ponham as mãos sobre sua cabeça, e que toda a congregação o apedreje”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Falareis aos filhos de Israel, dizendo: “Quem amaldiçoar seu Deus, levará sobre si o pecado”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Aquele que blasfemar o nome de Javé, certamente será condenado à morte. Toda a congregação certamente o apedrejará. Tanto o estrangeiro como o nativo serão mortos quando ele blasfemar o nome. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“'Aquele que golpear qualquer homem mortalmente será certamente condenado à morte. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Aquele que golpear mortalmente um animal, fará com que seja bom, vida por vida. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Se alguém ferir seu próximo, isso lhe será feito como ele fez: ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","fratura por fratura, olho por olho, dente por dente. Será feito a ele como se ele tivesse ferido alguém. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Aquele que matar um animal o fará bem; e aquele que matar um homem será condenado à morte. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Você terá um tipo de lei tanto para o estrangeiro como para o nativo; pois eu sou Yahweh, vosso Deus”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moisés falou aos filhos de Israel; e eles trouxeram aquele que tinha amaldiçoado para fora do acampamento, e o apedrejaram com pedras. Os filhos de Israel fizeram como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yahweh disse a Moisés no Monte Sinai, ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Fala aos filhos de Israel e diz-lhes: 'Quando entrardes na terra que eu vos dou, então a terra guardará um sábado para Yahweh'. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Semearás teu campo seis anos, e podarás tua vinha seis anos, e colherás seus frutos; ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","mas no sétimo ano haverá um sábado de descanso solene para a terra, um sábado para Javé. Você não semeará seu campo nem podará seu vinhedo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","What cresce de si mesmo em sua colheita não colherá, e não colherá as uvas de sua vinha despida. Será um ano de descanso solene para a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","O Sábado da terra servirá de alimento para você; para você mesmo, para seu servo, para sua empregada, para seu empregado contratado e para seu estranho, que vive como um estrangeiro com você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Para seu gado também, e para os animais que estão em sua terra, todo o seu aumento será para alimento. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“'Você contará sete sábados de anos, sete vezes sete anos; e haverá para você os dias de sete sábados de anos, mesmo quarenta e nove anos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Então tocareis a trombeta em voz alta no décimo dia do sétimo mês. No Dia da Expiação, soareis a trombeta em toda a vossa terra. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Fareis santo o quinquagésimo ano, e proclamareis a liberdade em toda a terra a todos os seus habitantes. Será um jubileu para vocês; e cada um de vocês retornará à sua propriedade e cada um de vocês retornará à sua família. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Esse quinquagésimo ano será para vocês um jubileu. Nele não semearão, nem colherão o que cresce de si mesmos, nem colherão das videiras despidas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Pois é um jubileu; será santo para vós. Comereis do seu crescimento fora do campo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“'Neste Ano do Jubileu, cada um de vocês retornará à sua propriedade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“'Se você vender algo a seu vizinho, ou comprar de seu vizinho, vocês não se enganarão uns aos outros. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","De acordo com o número de anos após o Jubileu, vocês devem comprar de seu vizinho. De acordo com o número de anos das colheitas que ele venderá a você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","De acordo com a duração dos anos você deve aumentar seu preço, e de acordo com a brevidade dos anos você deve diminuir seu preço; pois ele está vendendo o número das colheitas para você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Não vos enganareis uns aos outros, mas temereis vosso Deus; pois eu sou Yahweh vosso Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“'Portanto, cumprireis meus estatutos, guardareis minhas ordenanças e as cumprireis; e residireis na terra em segurança. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","A terra dará seus frutos, e você comerá seu alimento, e habitará nela em segurança. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Se você dissesse: “O que comeremos no sétimo ano? Eis que não semearemos, nem colheremos em nosso crescimento;” ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","então eu lhe darei minha bênção no sexto ano, e ela dará frutos durante os três anos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Você semeará no oitavo ano, e comerá dos frutos da velha loja até o nono ano. Até que seus frutos cheguem, você comerá da velha loja. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“'A terra não será vendida perpetuamente, pois a terra é minha; pois vocês são estranhos e vivem como estrangeiros comigo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Em toda a terra de sua posse, você concederá um resgate pela terra. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“'Se seu irmão se torna pobre e vende alguns de seus bens, então seu parente que está ao seu lado virá, e resgatará o que seu irmão vendeu. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Se um homem não tiver ninguém para resgatá-lo, e se tornar próspero e encontrar meios suficientes para resgatá-lo, ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","então deixe-o contar os anos desde sua venda, e restituirá o excedente ao homem a quem o vendeu; e ele retornará à sua propriedade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Mas se ele não for capaz de recuperá-lo para si mesmo, então o que ele vendeu permanecerá na mão daquele que o comprou até o Ano do Jubileu. No Jubileu, será liberado e ele retornará à sua propriedade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“'Se um homem vende uma casa em uma cidade murada, então ele pode resgatá-la dentro de um ano inteiro após ter sido vendida. Durante um ano inteiro, ele terá o direito de redenção. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Se não for redimida dentro do espaço de um ano inteiro, então a casa que está na cidade murada será garantida perpetuamente para aquele que a comprou, através de suas gerações. Ela não será liberada no Jubileu. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Mas as casas das aldeias que não têm muros ao seu redor serão contabilizadas com os campos do país: poderão ser resgatadas, e serão liberadas no Jubileu. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“'No entanto, nas cidades dos Levitas, os Levitas podem resgatar as casas nas cidades de sua posse a qualquer momento. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Os levitas podem resgatar a casa que foi vendida e a cidade de sua possessão, e será liberada no Jubileu; pois as casas das cidades dos levitas são sua possessão entre os filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Mas o campo das terras de pasto de suas cidades não pode ser vendido, pois é sua posse perpétua. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“'Se seu irmão ficou pobre, e sua mão não pode se sustentar entre vocês, então vocês o sustentarão. Ele viverá com vocês como um estrangeiro e um residente temporário. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Não se interesse por ele nem lucre; mas temei a vosso Deus, para que vosso irmão possa viver entre vós. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Você não emprestará a ele seu dinheiro a juros, nem lhe dará sua comida com fins lucrativos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Eu sou Yahweh vosso Deus, que vos tirou da terra do Egito, para vos dar a terra de Canaã, e para ser vosso Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“'Se seu irmão ficou pobre entre vocês, e se vende a vocês, vocês não o obrigarão a servir como escravo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Como servo contratado, e como residente temporário, ele estará com vocês; ele servirá com vocês até o Ano do Jubileu. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Então ele sairá de você, ele e seus filhos com ele, e voltará para sua própria família, e para a posse de seus pais. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Pois eles são meus servos, que eu trouxe da terra do Egito. Eles não serão vendidos como escravos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Não governará sobre ele com dureza, mas temerá a seu Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“'Quanto aos seus escravos masculinos e femininos, que você pode ter das nações que estão ao seu redor, deles você pode comprar escravos masculinos e femininos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Além disso, dos filhos dos alienígenas que vivem entre vocês, deles vocês podem comprar, e de suas famílias que estão com vocês, que eles conceberam em suas terras; e eles serão sua propriedade. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Você pode fazer deles uma herança para seus filhos depois de você, para que sejam possuídos. Deles você pode tomar seus escravos para sempre, mas sobre seus irmãos os filhos de Israel você não governará, uns sobre os outros, com dureza. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“'Se um estrangeiro ou residente temporário com você ficar rico, e seu irmão ao seu lado ficar pobre, e se vender para o estranho ou estrangeiro que vive entre você, ou para um membro da família do estranho, ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","após a venda ele poderá ser resgatado. Um de seus irmãos pode redimi-lo; ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ou seu tio, ou o filho de seu tio, pode redimi-lo, ou qualquer parente próximo de sua família pode redimi-lo; ou se ele ficou rico, pode redimir-se a si mesmo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ele deve contar com aquele que o comprou do ano em que ele se vendeu a ele para o Ano do Jubileu. O preço de sua venda será de acordo com o número de anos; ele estará com ele de acordo com o tempo de um servo contratado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Se ainda houver muitos anos, segundo eles, ele devolverá o preço de sua redenção do dinheiro para o qual foi comprado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Se restarem apenas alguns anos até o ano do jubileu, então ele contará com ele; de acordo com seus anos de serviço, ele devolverá o preço de sua redenção. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Como servo contratado ano após ano, ele estará com ele. Ele não governará com dureza sobre ele à sua vista. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Se ele não for redimido por estes meios, então será libertado no Ano do Jubileu: ele e seus filhos com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Pois para mim os filhos de Israel são servos; eles são meus servos que tirei da terra do Egito. Eu sou Yahweh, vosso Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“'Não fareis para vós mesmos ídolos, e não levantareis uma imagem esculpida ou um pilar, e não colocareis nenhuma pedra figurativa em vossa terra, para vos curvardes a ela; pois eu sou Yahweh vosso Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“'Guardareis meus sábados, e tereis reverência pelo meu santuário. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“'Se você entrar em meus estatutos e guardar meus mandamentos, e os cumprir, ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","então eu lhe darei suas chuvas em sua estação, e a terra produzirá seu aumento, e as árvores do campo produzirão seus frutos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Sua debulha continuará até a colheita, e a colheita continuará até a época da semeadura. Vocês comerão seu pão em abundância e viverão em sua terra com segurança. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“'Darei a paz na terra, e você se deitará, e ninguém lhe fará temer. Tirarei os animais maus da terra, nem a espada passará por sua terra. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Perseguireis vossos inimigos, e eles cairão à vossa frente pela espada. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Cinco de vocês perseguirão cem, e cem de vocês perseguirão dez mil; e seus inimigos cairão à sua frente pela espada. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“'Terei respeito por você, farei você frutificar, multiplicarei você, e estabelecerei meu pacto com você. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Vocês comerão os suprimentos antigos há muito tempo guardados, e vocês sairão do velho por causa do novo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Eu colocarei minha tenda entre vocês, e minha alma não os abominará. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Caminharei entre vós, e serei vosso Deus, e vós sereis meu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Eu sou Yahweh, vosso Deus, que vos tirou da terra do Egito, para que não sejais seus escravos. Quebrei as barras de vosso jugo e vos fiz caminhar de pé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“'Mas se não me ouvirdes, e não fizerdes todos estes mandamentos, ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","e se rejeitardes meus estatutos, e se vossa alma abomina minhas ordenanças, para que não façais todos os meus mandamentos, mas quebreis meu pacto, ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","eu também o farei a vós: Eu nomearei terror sobre vós, mesmo consumo e febre, que consumirão os olhos, e farão a alma definhar. Semearás tua semente em vão, pois teus inimigos a comerão. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Eu colocarei meu rosto contra você, e você será atingido diante de seus inimigos. Aqueles que te odeiam te governarão; e tu fugirás quando ninguém te perseguir. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“'Se você, apesar destas coisas, não me ouvir, então eu o castigarei sete vezes mais por seus pecados. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Romperei o orgulho de seu poder e farei seu céu como ferro, e seu solo como bronze. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Sua força será gasta em vão; pois sua terra não produzirá seu aumento, nem as árvores da terra produzirão seus frutos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“'Se você caminhar ao contrário de mim, e não me ouvir, então eu trarei sete vezes mais pragas sobre você de acordo com seus pecados. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Enviarei os animais selvagens entre vocês, que lhes roubarão seus filhos, destruirão seu gado e farão de vocês poucos em número. Seus caminhos ficarão desolados. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“'Se por essas coisas você não voltará para mim, mas caminhará contrariamente a mim, ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","então eu também caminharei contrariamente a você; e eu lhe baterei, até mesmo eu, sete vezes por seus pecados. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","trarei sobre ti uma espada que executará a vingança do pacto. Vocês estarão reunidos dentro de suas cidades, e eu enviarei a peste entre vocês. Vocês serão entregues nas mãos do inimigo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Quando eu partir seu bastão de pão, dez mulheres cozerão seu pão em um forno, e elas voltarão a entregar seu pão por peso. Vocês comerão e não ficarão satisfeitos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“'Se você, apesar disso, não me ouvir, mas caminhar contrariamente a mim, ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","então caminharei contrariamente a você com raiva. Também o castigarei sete vezes por seus pecados. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Você comerá a carne de seus filhos, e você comerá a carne de suas filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","destruirei vossos lugares altos, cortarei vossos altares de incenso e lançarei vossos corpos mortos sobre os corpos de vossos ídolos; e minha alma vos abominará. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Desperdiçarei vossas cidades, e levarei vossos santuários à desolação. Não me deleitarei com a doce fragrância de vossas oferendas. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","trarei a terra à desolação, e vossos inimigos que nela habitam ficarão espantados com ela. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Espalharei vocês entre as nações, e desembainharei a espada atrás de vocês. Sua terra será uma desolação, e suas cidades serão um desperdício. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Então a terra gozará seus sábados enquanto estiver desolada e vocês estiverem na terra de seus inimigos. Mesmo assim, a terra descansará e desfrutará seus sábados. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Enquanto estiver desolada, terá descanso, mesmo o resto que não tinha em seus sábados quando você viveu nela. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“'Quanto àqueles de vocês que restarem, enviarei um desmaio aos seus corações nas terras de seus inimigos. O som de uma folha movida os colocará em fuga; e eles fugirão, como se foge da espada. Eles cairão quando ninguém os perseguir. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Eles tropeçarão uns sobre os outros, como se fosse antes da espada, quando ninguém perseguir. Não terão poder para ficar diante de seus inimigos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Vós perecereis entre as nações. A terra de seus inimigos os devorará. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Those de vocês, que ficarem, se definharão em sua iniqüidade nas terras de seus inimigos; e também nas iniqüidades de seus pais, se definharão com eles. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“'Se confessarem sua iniqüidade e a iniqüidade de seus pais, em sua transgressão que eles cometeram contra mim; e também que porque eles caminharam contra mim, ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","eu também caminhei contra eles, e os trouxe para a terra de seus inimigos; se então seu coração incircunciso é humilhado, e eles então aceitam o castigo de sua iniqüidade, ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","então eu me lembrarei de minha aliança com Jacó, minha aliança com Isaac, e também minha aliança com Abraão; e me lembrarei da terra. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","A terra também será deixada por eles, e desfrutarão de seus sábados, enquanto ela fica desolada sem eles; e aceitarão a punição de sua iniqüidade porque rejeitaram minhas ordenanças, e sua alma abominou meus estatutos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","No entanto, por tudo isso, quando estiverem na terra de seus inimigos, não os rejeitarei, nem os abominarei, para destruí-los totalmente e quebrar meu pacto com eles; pois eu sou Yahweh, seu Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Mas, por causa deles, lembrarei o pacto de seus antepassados, que tirei da terra do Egito aos olhos das nações, para que eu pudesse ser seu Deus. Eu sou Yahweh”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Estes são os estatutos, ordenanças e leis, que Javé fez entre ele e os filhos de Israel no Monte Sinai por Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Fale aos filhos de Israel, e diga a eles: 'Quando um homem consagra uma pessoa a Yahweh em um voto, de acordo com sua avaliação, ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","sua avaliação de um homem de vinte anos a sessenta anos será de cinqüenta siclos de prata, de acordo com o siclo do santuário'. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Se ela for uma fêmea, então sua avaliação será de trinta siclos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Se a pessoa tiver de cinco a vinte anos de idade, então sua avaliação será para um homem de vinte siclos, e para uma mulher de dez siclos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Se a pessoa tiver de um mês a cinco anos, então sua avaliação será para um homem de cinco siclos de prata, e para uma mulher, sua avaliação será para três siclos de prata. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Se a pessoa for de sessenta anos de idade ou mais; se for macho, sua avaliação será de quinze siclos, e para uma fêmea de dez siclos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Mas se ele for mais pobre do que sua avaliação, então ele será colocado diante do padre, e o padre lhe atribuirá um valor. O sacerdote lhe atribuirá um valor de acordo com sua capacidade de pagamento. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“'Se é um animal do qual os homens oferecem uma oferta a Javé, tudo o que qualquer homem dá de tal a Javé torna-se sagrado. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ele não deve alterá-lo, nem trocá-lo, um bem por um mal, ou um mal por um bem. Se ele trocar animal por animal, tanto este como aquele pelo qual é trocado serão santos. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Se for qualquer animal imundo, do qual não ofereçam como oferenda a Javé, então ele colocará o animal diante do sacerdote; ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","e o sacerdote o avaliará, se é bom ou mau. Como o padre o avalia, assim será. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Mas se ele de fato o resgatar, então ele acrescentará a quinta parte dele à sua avaliação. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“'Quando um homem dedica sua casa para ser santa a Javé, então o padre a avaliará, seja ela boa ou má. Como o padre a avalia, assim ela permanecerá. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Se aquele que a dedica resgatar sua casa, então ele acrescentará a quinta parte do dinheiro de sua avaliação, e ela será dele. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“'Se um homem se dedica a Yahweh parte do campo de sua posse, então sua avaliação deve ser de acordo com a semente para ela. A sementeira de um homer de cevada deve ser avaliada em cinqüenta siclos de prata. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Se ele dedicar seu campo a partir do Ano do Jubileu, de acordo com sua avaliação, ele permanecerá de acordo com sua avaliação. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Mas se ele dedicar seu campo após o Jubileu, então o sacerdote lhe contará o dinheiro de acordo com os anos que restam do Ano do Jubileu; e será feito um abatimento de sua avaliação. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Se aquele que dedicou o campo de fato o resgatará, então acrescentará a ele a quinta parte do dinheiro de sua avaliação, e permanecerá dele. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Se ele não resgatar o campo, ou se tiver vendido o campo a outro homem, ele não será mais resgatado; ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","mas o campo, quando sair no Jubileu, será santo para Javé, como um campo dedicado. Ele será propriedade dos sacerdotes. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“'Se ele dedica a Javé um campo que ele comprou, que não é do campo de sua posse, ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","então o padre lhe contará o valor de sua avaliação até o Ano do Jubileu; e ele dará sua avaliação naquele dia, como uma coisa santa a Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","No Ano do Jubileu, o campo voltará para aquele a quem foi comprado, mesmo para aquele a quem pertence a posse da terra. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Todas as suas avaliações serão de acordo com o siclo do santuário: vinte gerahs para o siclo. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“'Entretanto o primogênito entre os animais, que pertence a Iavé como primogênito, nenhum homem pode se dedicar, seja um boi ou uma ovelha. É de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Se for um animal impuro, ele deverá comprá-lo de volta de acordo com sua avaliação, e acrescentar-lhe a quinta parte; ou se não for resgatado, então será vendido de acordo com sua avaliação. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“'Não obstante, nenhuma coisa dedicada que um homem dedique a Iavé de tudo o que tem, seja de homem ou animal, ou do campo de sua posse, será vendida ou resgatada. Tudo o que é permanentemente dedicado é santíssimo para Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“'Ninguém dedicado à destruição, que deve ser devotado entre os homens, será resgatado. Ele certamente será morto. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“'Todo o dízimo da terra, seja da semente da terra ou do fruto das árvores, é de Yahweh. É sagrado para Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Se um homem redimir algo de seu dízimo, ele deve acrescentar uma quinta parte a ele. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Todo o dízimo do rebanho ou dos rebanhos, o que quer que passe debaixo da vara, o décimo será santo para Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ele não examinará se é bom ou mau, nem o trocará. Se ele o trocar, então tanto ele como aquele pelo qual for trocado serão santos. Não será resgatada”. ");
INSERT INTO porbrbsl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Estes são os mandamentos que Javé ordenou a Moisés para os filhos de Israel no Monte Sinai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Yahweh falou a Moisés no deserto do Sinai, na Tenda da Reunião, no primeiro dia do segundo mês, no segundo ano depois de terem saído da terra do Egito, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Faça um censo de toda a congregação dos filhos de Israel, por suas famílias, pela casa de seus pais, de acordo com o número dos nomes, cada homem, um por um, ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","a partir de vinte anos de idade, todos os que são capazes de sair para a guerra em Israel. Você e Aarão os contarão por suas divisões. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Contigo estará um homem de cada tribo, cada um dos chefes da casa de seus pais. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Estes são os nomes dos homens que estarão com vocês: De Ruben: Elizur, o filho de Shedeur. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","De Simeon: Shelumiel, o filho de Zurishaddai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","De Judah: Nahshon, o filho de Amminadab. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","De Issachar: Nethanel, o filho de Zuar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","De Zebulun: Eliab, o filho de Helon. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Dos filhos de José: de Efraim: Elishama o filho de Ammihud; de Manasseh: Gamaliel, o filho de Pedahzur. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","De Benjamin: Abidan, o filho de Gideoni. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","De Dan: Ahiezer, o filho de Ammishaddai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","De Asher: Pagiel, o filho de Ochran. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","De Gad: Eliasaph, o filho de Deuel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","De Naftali: Ahira, o filho de Enan”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Estes são aqueles que foram chamados da congregação, os príncipes das tribos de seus pais; eles eram os chefes dos milhares de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moisés e Aarão levaram estes homens que são mencionados pelo nome. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Eles reuniram toda a congregação no primeiro dia do segundo mês; e declararam sua ascendência por suas famílias, pela casa de seus pais, de acordo com o número dos nomes, a partir dos vinte anos de idade, um por um. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Como Javé ordenou a Moisés, assim ele os contou no deserto do Sinai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Os filhos de Rúben, o primogênito de Israel, suas gerações, por suas famílias, pela casa de seus pais, de acordo com o número de nomes, um por um, cada homem a partir de vinte anos de idade, todos os que puderam sair à guerra: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","those que foram contados deles, da tribo de Rúben, eram quarenta e seis mil e quinhentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Dos filhos de Simeão, suas gerações, por suas famílias, pela casa de seus pais, aqueles que foram contados, de acordo com o número dos nomes, um por um, cada homem a partir de vinte anos, todos os que puderam sair à guerra: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","those que foram contados deles, da tribo de Simeão, eram cinqüenta e nove mil e trezentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Dos filhos de Gad, suas gerações, por suas famílias, pela casa de seus pais, de acordo com o número de nomes, a partir de vinte anos, todos os que puderam sair para a guerra: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","those que foram contados deles, da tribo de Gad, eram quarenta e cinco mil seiscentos e cinqüenta. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Dos filhos de Judá, suas gerações, por suas famílias, pela casa de seus pais, de acordo com o número de nomes, a partir de vinte anos, todos os que puderam sair para a guerra: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","those que foram contados deles, da tribo de Judá, eram setenta e quatro mil e seiscentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Dos filhos de Issachar, suas gerações, por suas famílias, pela casa de seus pais, de acordo com o número de nomes, a partir dos vinte anos de idade, todos os que puderam sair para a guerra: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","those que foram contados deles, da tribo de Issachar, eram cinqüenta e quatro mil e quatrocentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Dos filhos de Zebulun, suas gerações, por suas famílias, pela casa de seus pais, de acordo com o número de nomes, a partir dos vinte anos de idade, todos os que puderam sair para a guerra: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","those que foram contados deles, da tribo de Zebulom, eram cinqüenta e sete mil e quatrocentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Dos filhos de José: dos filhos de Efraim, suas gerações, por suas famílias, pela casa de seus pais, de acordo com o número de nomes, a partir dos vinte anos de idade, todos os que puderam sair à guerra: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","those que foram contados deles, da tribo de Efraim, eram quarenta mil e quinhentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Dos filhos de Manasseh, suas gerações, por suas famílias, pela casa de seus pais, de acordo com o número de nomes, a partir dos vinte anos de idade, todos os que puderam sair para a guerra: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","those que foram contados deles, da tribo de Manasseh, eram trinta e dois mil e duzentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Dos filhos de Benjamin, suas gerações, por suas famílias, pela casa de seus pais, de acordo com o número de nomes, a partir dos vinte anos de idade, todos os que puderam sair para a guerra: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","those que foram contados deles, da tribo de Benjamin, eram trinta e cinco mil e quatrocentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dos filhos de Dan, suas gerações, por suas famílias, pela casa de seus pais, de acordo com o número de nomes, a partir dos vinte anos de idade, todos os que puderam sair para a guerra: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","those que foram contados deles, da tribo de Dan, eram sessenta e dois mil e setecentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Dos filhos de Asher, suas gerações, por suas famílias, pela casa de seus pais, de acordo com o número de nomes, a partir dos vinte anos de idade, todos os que puderam sair para a guerra: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","those que foram contados deles, da tribo de Asher, eram quarenta e um mil e quinhentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Dos filhos de Naftali, suas gerações, por suas famílias, pela casa de seus pais, de acordo com o número de nomes, a partir dos vinte anos de idade, todos os que puderam sair para a guerra: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","those que foram contados deles, da tribo de Naftali, eram cinqüenta e três mil e quatrocentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Estes são os que foram contados, que Moisés e Aarão contaram, e os doze homens que foram príncipes de Israel, cada um para a casa de seus pais. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Portanto, todos aqueles que foram contados dos filhos de Israel pela casa de seus pais, a partir dos vinte anos de idade, todos os que puderam sair para a guerra em Israel - ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","todos os que foram contados foram seiscentos e três mil e quinhentos e cinqüenta. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Mas os levitas após a tribo de seus pais não foram contados entre eles. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Pois Javé falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Somente a tribo de Levi não contareis, nem fareis um censo deles entre os filhos de Israel; ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","mas designai os Levitas sobre o Tabernáculo do Testemunho, e sobre todos os seus móveis, e sobre tudo o que lhe pertence. Eles levarão o tabernáculo e toda sua mobília; e cuidarão dele, e acamparão ao seu redor. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Quando o tabernáculo tiver que se mover, os Levitas o levarão para baixo; e quando o tabernáculo tiver que ser instalado, os Levitas o instalarão. O estranho que se aproximar será morto. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Os filhos de Israel armarão suas tendas, cada homem por seu próprio acampamento, e cada homem por seu próprio padrão, de acordo com suas divisões. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Mas os levitas acamparão ao redor do Tabernáculo do Testemunho, para que não haja ira sobre a congregação dos filhos de Israel. Os Levitas serão responsáveis pelo Tabernáculo do Testemunho”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Assim o fizeram as crianças de Israel. De acordo com tudo o que Javé ordenou a Moisés, assim o fizeram. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yahweh falou a Moisés e a Arão, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Os filhos de Israel acamparão cada homem por seu próprio padrão, com os estandartes das casas de seus pais. Eles acamparão ao redor da Tenda da Reunião, a uma distância dela. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“Aqueles que acampam no lado leste em direção ao nascer do sol devem ser do padrão do acampamento de Judá, de acordo com suas divisões. O príncipe dos filhos de Judá será Nahshon, filho de Amminadab. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Sua divisão, e os que foram contados deles, eram setenta e quatro mil e seiscentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“Aqueles que acamparem ao seu lado serão a tribo de Issachar. O príncipe dos filhos de Issachar será Nethanel, o filho de Zuar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","“Sua divisão, e os que foram contados dela, eram cinqüenta e quatro mil e quatrocentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“A tribo de Zebulom: o príncipe dos filhos de Zebulom será Eliab, o filho de Helon. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","“ Sua divisão, e os que foram contados dela, eram cinqüenta e sete mil e quatrocentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“Todos os que foram contados do campo de Judá eram cento e oitenta e seis mil e quatrocentos, de acordo com suas divisões. Eles devem partir em primeiro lugar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“No lado sul, será o padrão do campo de Reuben de acordo com suas divisões. O príncipe dos filhos de Rúben será Elizur, o filho de Shedeur. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Sua divisão, e os que foram contados dela, eram quarenta e seis mil e quinhentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“Aqueles que acampam ao seu lado serão a tribo de Simeão. O príncipe dos filhos de Simeão será Shelumiel, o filho de Zurishaddai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","“ Sua divisão, e os que foram contados deles, eram cinqüenta e nove mil e trezentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“A tribo de Gad: o príncipe dos filhos de Gad será Eliasafe, o filho de Reuel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Sua divisão, e os que foram contados deles, eram quarenta e cinco mil seiscentos e seiscentos e cinqüenta. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“Todos os que foram contados do campo de Reuben eram cento e cinqüenta e um mil quatrocentos e cinqüenta, de acordo com seus exércitos. Eles se colocarão em segundo lugar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Então a Tenda da Reunião deverá partir, com o acampamento dos Levitas no meio dos acampamentos. À medida que acampam, assim se colocarão, cada homem em seu lugar, de acordo com seus padrões. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“No lado oeste, será o padrão do campo de Ephraim de acordo com suas divisões. O príncipe dos filhos de Efraim será Elishama, o filho de Ammihud. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Sua divisão, e aqueles que foram contados deles, eram quarenta mil e quinhentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“Ao seu lado estará a tribo de Manasseh. O príncipe dos filhos de Manassés será Gamaliel, o filho de Pedahzur. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Sua divisão, e os que foram contados deles, eram trinta e dois mil e duzentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“A tribo de Benjamin: o príncipe dos filhos de Benjamin será Abidan, o filho de Gideoni. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","“Seu exército, e os que foram contados deles, eram trinta e cinco mil e quatrocentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“Todos os que foram contados do campo de Efraim eram cento e oito mil e cem, de acordo com suas divisões. Eles se estabeleceram em terceiro lugar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“No lado norte será o padrão do acampamento de Dan de acordo com suas divisões. O príncipe dos filhos de Dan será Ahiezer, o filho de Ammishaddai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Sua divisão, e aqueles que foram contados deles, eram sessenta e dois mil e setecentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“Aqueles que acamparem ao seu lado serão a tribo de Asher. O príncipe dos filhos de Asher será Pagiel, o filho de Ochran. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","“ Sua divisão, e os que foram contados deles, eram quarenta e um mil e quinhentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“A tribo de Naftali: o príncipe dos filhos de Naftali será Ahira, o filho de Enan. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Sua divisão, e os que foram contados deles, eram cinqüenta e três mil e quatrocentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“Todos os que foram contados do campo de Dan eram cento e cinqüenta e sete mil e seiscentos. Eles devem estabelecer-se em último lugar por seus padrões”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Estes são aqueles que foram contados dos filhos de Israel pelas casas de seus pais. Todos os que foram contados dos campos de acordo com seus exércitos foram seiscentos e três mil e quinhentos e cinqüenta. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Mas os levitas não foram contados entre os filhos de Israel, como Javé ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Assim o fizeram as crianças de Israel. De acordo com tudo o que Javé ordenou a Moisés, então eles acamparam de acordo com seus padrões, e assim eles partiram, todos por suas famílias, de acordo com as casas de seus pais. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Agora esta é a história das gerações de Aaron e Moses no dia em que Yahweh falou com Moses no Monte Sinai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Estes são os nomes dos filhos de Aarão: Nadab, o primogênito, e Abihu, Eleazar, e Ithamar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Estes são os nomes dos filhos de Aaron, os sacerdotes que foram ungidos, a quem ele consagrou para ministrar no ofício sacerdotal. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab e Abihu morreram antes de Yahweh quando ofereceram fogo estranho diante de Yahweh no deserto do Sinai, e não tiveram filhos. Eleazar e Ithamar ministraram no escritório do sacerdote na presença de Aaron, seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Traga a tribo de Levi para perto e coloque-os diante de Arão, o sacerdote, para que eles possam ministrar a ele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Eles devem manter suas exigências, e as exigências de toda a congregação antes da Tenda da Reunião, para fazer o serviço do tabernáculo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Eles deverão guardar todo o mobiliário da Tenda da Reunião, e as obrigações dos filhos de Israel, para fazer o serviço do tabernáculo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Entregarão os Levitas a Aarão e a seus filhos. Eles serão totalmente entregues a ele em nome dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Designareis Aarão e seus filhos, e eles conservarão seu sacerdócio, mas o estrangeiro que se aproximar será condenado à morte”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Javé falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Eis que tomei os levitas do meio dos filhos de Israel em vez de todos os primogênitos que abrem o ventre entre os filhos de Israel; e os levitas serão meus, ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","pois todos os primogênitos são meus. No dia em que derrubei todos os primogênitos na terra do Egito, santificei para mim todos os primogênitos em Israel, tanto o homem como o animal. Eles serão meus. Eu sou Yahweh”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yahweh falou a Moisés no deserto do Sinai, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Conte os filhos de Levi pelas casas de seus pais, por suas famílias. Contarás cada homem a partir de um mês de idade”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moisés os contou de acordo com a palavra de Iavé, como lhe foi ordenado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Estes eram os filhos de Levi por seus nomes: Gershon, Kohath, e Merari. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Estes são os nomes dos filhos de Gershon por suas famílias: Libni e Shimei. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Os filhos de Kohath por suas famílias: Amram, Izhar, Hebron, e Uzziel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Os filhos de Merari por suas famílias: Mahli e Mushi. Estas são as famílias dos Levitas de acordo com as casas de seus pais. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","De Gershon era a família dos Libnitas, e a família dos Shimeítas. Estas são as famílias dos Gershonitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Aqueles que foram contados deles, de acordo com o número de todos os homens a partir de um mês de idade, mesmo aqueles que foram contados deles eram sete mil e quinhentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","As famílias dos Gershonitas acamparão atrás do tabernáculo para o oeste. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eliasaph, filho de Lael, será o príncipe da casa dos pais dos gershonitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","O dever dos filhos de Gershon na Tenda da Reunião será o tabernáculo, a tenda, sua cobertura, a tela para a porta da Tenda da Reunião, ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","os enforcamentos do tribunal, a tela para a porta do tribunal que está junto ao tabernáculo e ao redor do altar, e suas cordas para todos os seus serviços. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","de Kohath era a família dos Amramitas, a família dos Izharitas, a família dos Hebronitas, e a família dos Uzzielitas. Estas são as famílias dos Kohathitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","According para o número de todos os homens a partir de um mês de idade, havia oito mil e seiscentos mantendo as exigências do santuário. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","As famílias dos filhos de Kohath deverão acampar no lado sul do tabernáculo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","O príncipe da casa dos pais das famílias dos Kohathitas será Elizaphan, filho de Uzziel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Seu dever será a arca, a mesa, o candeeiro, os altares, os vasos do santuário com os quais ministram, a tela e todos os seus serviços. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eleazar, filho de Aarão, o sacerdote, será príncipe dos príncipes dos levitas, com a supervisão daqueles que guardam os requisitos do santuário. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","De Merari era a família dos Mahlites e a família dos Mushites. Estas são as famílias de Merari. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Aqueles que foram contados deles, de acordo com o número de todos os machos a partir de um mês de idade, eram seis mil e duzentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","O príncipe da casa dos pais das famílias de Merari era Zuriel, filho de Abihail. Eles devem acampar no lado norte do tabernáculo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","O dever nomeado dos filhos de Merari serão as tábuas do tabernáculo, suas barras, seus pilares, suas bases, todos os seus instrumentos, todos os seus serviços, ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","os pilares da corte ao seu redor, suas bases, seus pinos e suas cordas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Aqueles que acampam antes do tabernáculo para o leste, em frente à Tenda da Reunião em direção ao nascer do sol, serão Moisés, com Aarão e seus filhos, mantendo as exigências do santuário para o dever dos filhos de Israel. O forasteiro que se aproximar será condenado à morte. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Todos os que foram contados dos levitas, que Moisés e Arão contaram por ordem de Iavé, por suas famílias, todos os homens a partir de um mês de idade, eram vinte e dois mil. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Yahweh disse a Moisés: “Conte todos os primogênitos masculinos dos filhos de Israel, a partir de um mês de idade, e tome o número de seus nomes”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Você levará os levitas para mim - eu sou Yahweh - em vez de todos os primogênitos entre os filhos de Israel; e o gado dos levitas em vez de todos os primogênitos entre o gado dos filhos de Israel”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moisés contou, como Iavé lhe ordenou, todos os primogênitos entre os filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Todos os primogênitos machos, de acordo com o número de nomes a partir de um mês de idade, daqueles que foram contados, eram vinte e dois mil duzentos e setenta e três. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Levem os levitas ao invés de todos os primogênitos entre os filhos de Israel, e o gado dos levitas ao invés de seu gado; e os levitas serão meus. Eu sou Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Para a redenção dos duzentos e setenta e três dos primogênitos dos filhos de Israel que excederem o número dos levitas, ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","tomarás cinco siclos cada um; de acordo com o siclo do santuário os tomarás (o siclo é de vinte gerahs); ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","e darás o dinheiro, com o qual o restante deles será redimido, a Arão e a seus filhos”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moisés tirou o dinheiro da redenção daqueles que excederam o número daqueles que foram redimidos pelos levitas; ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","do primogênito dos filhos de Israel ele tirou o dinheiro, mil trezentos e sessenta e cinco siclos, segundo o siclo do santuário; ");
INSERT INTO porbrbsl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","e Moisés deu o dinheiro da redenção a Arão e a seus filhos, segundo a palavra de Javé, como Javé ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yahweh falou a Moisés e a Arão, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Faça um censo dos filhos de Kohath entre os filhos de Levi, por suas famílias, pelas casas de seus pais, ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","a partir dos trinta anos de idade até os cinqüenta anos de idade, todos os que entram no serviço para fazer o trabalho na Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Este é o serviço dos filhos de Kohath na Tenda da Reunião, em relação às coisas mais sagradas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Quando o acampamento avançar, Arão entrará com seus filhos; e eles tirarão o véu da tela, cobrirão a arca do Testemunho com ela, ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","colocarão uma cobertura de pele de foca sobre ela, espalharão um pano azul sobre ela e a colocarão em seus bastões. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Sobre a mesa do pão de exposição, estenderão um pano azul, e colocarão sobre ela os pratos, as colheres, as tigelas e os copos com os quais despejar; e o pão contínuo estará sobre ela. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Espalharão sobre eles um pano escarlate, e o cobrirão com uma cobertura de pele de foca, e o colocarão em seus postes. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Eles pegarão um pano azul e cobrirão o suporte da lâmpada, suas lâmpadas, seus rapé, seus pratos de rapé, e todos os seus recipientes de óleo, com os quais ministram a ela. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","“Eles o colocarão e todos os seus recipientes dentro de uma cobertura de pele de selo, e o colocarão sobre a moldura. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“No altar dourado devem espalhar um pano azul, cobri-lo com uma cobertura de pele de foca, e colocá-lo em seus postes. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Eles pegarão todos os recipientes do ministério com os quais ministram no santuário e os colocarão em um pano azul, os cobrirão com uma cobertura de pele de selo, e os colocarão sobre a moldura. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Eles tirarão as cinzas do altar e espalharão um pano roxo sobre ele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","“ Eles colocarão sobre ele todos os seus recipientes com os quais ministram sobre ele, as panelas de fogo, os ganchos de carne, as pás e as bacias - todos os recipientes do altar; e espalharão sobre ele uma cobertura de pele de foca, e colocarão em seus postes. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Quando Aarão e seus filhos tiverem terminado de cobrir o santuário e todos os móveis do santuário, conforme o acampamento avança; depois disso, os filhos de Kohath virão para carregá-lo; mas não tocarão no santuário, para que não morram. Os filhos de Kohath carregarão estas coisas pertencentes à Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“O dever de Eleazar, filho de Arão, o sacerdote, será o óleo para a luz, o incenso doce, a oferta contínua de refeições e o óleo de unção, as exigências de todo o tabernáculo e de tudo o que nele existe, o santuário e seus móveis”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yahweh falou com Moisés e com Arão, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Não corte a tribo das famílias dos Kohathitas dentre os Levitas; ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","mas faça isso com eles, para que possam viver, e não morrer, quando se aproximarem das coisas mais sagradas: Aarão e seus filhos entrarão e nomearão todos para seu serviço e para seu fardo; ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","mas não entrarão para ver o santuário nem por um momento, para que não morram”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Façam um censo dos filhos de Gershon também, pela casa de seus pais, por suas famílias; ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","vocês os contarão a partir dos trinta anos de idade até os cinqüenta anos de idade: todos os que entrarem para aguardar o serviço, para fazer o trabalho na Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Este é o serviço das famílias dos Gershonitas, ao servirem e ao carregarem fardos: ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","levarão as cortinas do tabernáculo e da Tenda da Reunião, sua cobertura, a cobertura de pele de selo que está sobre ela, a tela da porta da Tenda da Reunião, ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","os enforcamentos do tribunal, a tela da porta do tribunal que está junto ao tabernáculo e ao redor do altar, suas cordas e todos os instrumentos do seu serviço, e tudo o que for feito com eles. Eles devem servir ali. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","À ordem de Aarão e de seus filhos será todo o serviço dos filhos dos gersonitas, em todo o seu fardo e em todo o seu serviço; e lhes designareis o dever em todas as suas responsabilidades. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Este é o serviço das famílias dos filhos dos Gershonitas na Tenda da Reunião. Seu dever estará sob a mão de Itamar, filho de Arão, o sacerdote. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Quanto aos filhos de Merari, você os contará por suas famílias, pela casa de seus pais; ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","você os contará a partir dos trinta anos de idade até os cinqüenta anos de idade - qualquer um que entre no serviço, para fazer o trabalho da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Este é o dever de seu fardo, de acordo com todo seu serviço na Tenda da Reunião: as tábuas do tabernáculo, suas barras, seus pilares, suas bases, ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","os pilares da quadra ao seu redor, suas bases, seus pinos, suas cordas, com todos os seus instrumentos, e com todo seu serviço. Você deverá nomear os instrumentos do dever de seu encargo para eles por nome. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Este é o serviço das famílias dos filhos de Merari, de acordo com todo o seu serviço na Tenda da Reunião, sob a mão de Ithamar, filho de Arão, o sacerdote”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moisés e Aarão e os príncipes da congregação contaram os filhos dos Kohathitas por suas famílias e pela casa de seus pais, ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","a partir dos trinta anos de idade até os cinqüenta anos de idade, todos que entraram no serviço para trabalhar na Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","aqueles que foram contados por suas famílias eram dois mil setecentos e cinqüenta. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Estes são os que foram contados das famílias dos Kohathitas, todos os que serviram na Tenda da Reunião, que Moisés e Arão contaram de acordo com o mandamento de Yahweh por Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Aqueles que foram contados dos filhos de Gershon, por suas famílias e pela casa de seus pais, ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","a partir dos trinta anos de idade até os cinqüenta - todos os que entraram no serviço para trabalhar na Tenda do Encontro, ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","even aqueles que foram contados deles, por suas famílias, pela casa de seus pais, foram dois mil seiscentos e trinta. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Estes são os que foram contados das famílias dos filhos de Gershon, todos que serviram na Tenda da Reunião, que Moisés e Arão contaram de acordo com o mandamento de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Aqueles que foram contados das famílias dos filhos de Merari, por suas famílias, pelas casas de seus pais, ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","a partir dos trinta anos de idade até os cinqüenta - todos os que entraram no serviço para trabalhar na Tenda do Encontro, ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","even aqueles que foram contados deles por suas famílias, eram três mil e duzentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Estes são aqueles que foram contados das famílias dos filhos de Merari, que Moisés e Arão contaram segundo o mandamento de Iavé por Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Todos aqueles que foram contados dos levitas que Moisés e Arão e os príncipes de Israel contaram, por suas famílias e pela casa de seus pais, ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","de trinta anos para cima até os cinqüenta, todos os que entraram para fazer o trabalho de serviço e o trabalho de carregar cargas na Tenda da Reunião, ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","even aqueles que foram contados deles, eram oito mil e quinhentos e oitenta. ");
INSERT INTO porbrbsl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","de acordo com o mandamento de Iavé foram contados por Moisés, todos de acordo com seu serviço e de acordo com seu fardo. Assim, foram contados por ele, como Javé ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Comande os filhos de Israel que eles expulsem do campo todos os leprosos, todos os que têm uma descarga e todos os que estão imundos por um cadáver. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Colocarão tanto homens quanto mulheres fora do acampamento para que não contaminem seu acampamento, no meio do qual eu moro”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Os filhos de Israel o fizeram e os colocaram fora do campo; como Javé falou com Moisés, assim fizeram os filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Javé falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Fale aos filhos de Israel: 'Quando um homem ou mulher cometer qualquer pecado que os homens cometam, de modo a transgredir contra Javé, e essa alma for culpada, ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","então ele confessará seu pecado que cometeu; e fará a restituição total de sua culpa, acrescentará a quinta parte dela, e a dará a ele a respeito de quem ele foi culpado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Mas se o homem não tiver parentes a quem possa ser feita a restituição da culpa, a restituição da culpa que for feita a Javé será do sacerdote, além do carneiro da expiação, pelo qual será feita a expiação por ele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Toda oferta alçada de todas as coisas santas dos filhos de Israel, que eles apresentarem ao sacerdote, será dele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","As coisas santas de cada homem serão suas; tudo o que qualquer homem der ao sacerdote, será dele”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Yahweh falou com Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Fale com as crianças de Israel, e diga-lhes: Se a esposa de algum homem se desvia e é infiel a ele, ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","e um homem se deita com ela carnalmente, e isso é escondido dos olhos de seu marido, e isso é mantido escondido, e ela é contaminada, não há testemunha contra ela, e ela não é levada em flagrante; ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","e o espírito de ciúme vem sobre ele, e ele tem ciúmes de sua esposa e ela é contaminada; ou se o espírito de ciúme vem sobre ele, e ele tem ciúmes de sua esposa e ela não é contaminada; ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","então o homem trará sua esposa ao sacerdote, e trará sua oferta por ela: um décimo de uma efa de refeição de cevada. Ele não derramará óleo sobre ela, nem colocará incenso sobre ela, pois é uma oferta de refeição de ciúmes, uma oferta de refeição memorial, trazendo a iniqüidade à memória. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","O sacerdote a aproximará e a porá diante de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","O sacerdote tomará água benta em um vaso de barro; e o sacerdote tomará um pouco do pó que está no chão do tabernáculo e o colocará na água. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","O sacerdote colocará a mulher diante de Iavé, e deixará os cabelos da cabeça da mulher soltos, e colocará em suas mãos a oferta de refeição do memorial, que é a oferta de refeição do ciúme. O sacerdote terá em sua mão a água da amargura que traz uma maldição. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","O sacerdote fará com que ela faça um juramento e dirá à mulher: “Se nenhum homem se deitou com você, e se você não se afastou da impureza, estando sob a autoridade de seu marido, fique livre dessa água de amargura que traz uma maldição”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Mas se você se desviou, estando sob a autoridade de seu marido, e se você está contaminada, e algum homem se deitou com você além de seu marido...”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","então o sacerdote fará a mulher jurar com o juramento de maldição, e o sacerdote dirá à mulher: “Que Javé faça de você uma maldição e um juramento entre seu povo, quando Javé permitir que sua coxa caia, e seu corpo inchar; ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","e esta água que traz uma maldição entrará em suas entranhas, e fará seu corpo inchar, e sua coxa cair”. A mulher dirá: “Amém, Amém”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“'O padre escreverá estas maldições num livro e as enxugará na água da amargura. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Ele fará a mulher beber a água de amargura que causa a maldição; e a água que causa a maldição entrará nela e se tornará amarga. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","O sacerdote tirará a oferta de refeição do ciúme da mão da mulher, e agitará a oferta de refeição diante de Javé, e a levará ao altar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","O sacerdote pegará um punhado da oferta de refeição, como sua porção memorial, e a queimará no altar, e depois fará a mulher beber a água. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Quando ele a tiver feito beber a água, então acontecerá, se ela estiver contaminada e tiver cometido uma transgressão contra seu marido, que a água que causa a maldição entrará nela e se tornará amarga, e seu corpo inchará, e sua coxa cairá; e a mulher será uma maldição entre seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Se a mulher não estiver contaminada, mas estiver limpa; então ela será livre, e conceberá descendência. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“'Esta é a lei do ciúme, quando uma esposa, estando sob seu marido, se desvia e é contaminada, ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ou quando o espírito do ciúme vem sobre um homem, e ele tem ciúmes de sua esposa; então ele colocará a mulher perante Yahweh, e o sacerdote executará sobre ela toda esta lei. ");
INSERT INTO porbrbsl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","O homem será livre da iniqüidade, e essa mulher suportará sua iniqüidade”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yahweh falou com Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Fale com as crianças de Israel, e diga-lhes: “Quando um homem ou mulher fizer um voto especial, o voto de um nazista, para se separar de Yahweh, ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ele se separará do vinho e da bebida forte”. Ele não beberá vinagre de vinho, ou vinagre de bebida fermentada, nem beberá qualquer suco de uva, nem comerá uvas frescas ou secas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Todos os dias de sua separação ele não comerá nada que seja feito da videira, desde as sementes até as peles. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“'Todos os dias de seu voto de separação nenhuma lâmina de barbear virá sobre sua cabeça, até que os dias em que ele se separar para Yahweh sejam cumpridos. Ele será santo. Ele deixará crescer as madeixas dos cabelos de sua cabeça. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“'Todos os dias que ele se separa de Yahweh ele não deve se aproximar de um cadáver. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ele não se tornará impuro por seu pai, ou por sua mãe, por seu irmão, ou por sua irmã, quando eles morrerem, porque sua separação para Deus está sobre sua cabeça. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Todos os dias de sua separação ele é santo para Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“'Se algum homem morrer muito de repente ao seu lado, e ele profanar a cabeça de sua separação, então ele deve raspar sua cabeça no dia de sua purificação. No sétimo dia, ele deverá raspá-la. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","No oitavo dia ele levará duas rolas ou dois pombinhos para o padre, para a porta da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","O sacerdote oferecerá um para oferta pelo pecado, e o outro para holocausto, e fará expiação por ele, porque pecou por causa dos mortos, e santificará sua cabeça naquele mesmo dia. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ele separará para Javé os dias de sua separação, e trará um cordeiro macho de um ano para oferta pela culpa; mas os primeiros dias serão nulos, porque sua separação foi contaminada. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“'Esta é a lei do nazista: quando os dias de sua separação forem cumpridos, ele será levado à porta da Tenda da Reunião, ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","e oferecerá sua oferta a Javé: um cordeiro macho de um ano sem defeito para uma oferta queimada, uma ovelha de um ano sem defeito para uma oferta pelo pecado, um carneiro sem defeito para ofertas pela paz, ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","uma cesta de pão ázimo, bolos de farinha fina misturada com óleo, e bolachas ázimas ungidas com óleo com sua oferta de refeição e suas ofertas de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","O sacerdote as apresentará diante de Javé, e oferecerá sua oferta pelo pecado e sua oferta queimada. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ele oferecerá o carneiro para um sacrifício de ofertas pacíficas a Iavé, com a cesta de pães ázimos. O sacerdote oferecerá também sua oferta de refeição e sua oferta de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","O nazireu rapará a cabeça de sua separação na porta da Tenda da Reunião, tomará os cabelos da cabeça de sua separação e os colocará no fogo que está sob o sacrifício de ofertas pacíficas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","O sacerdote tirará o ombro cozido do carneiro, um bolo ázimo da cesta e uma hóstia ázima, e os colocará nas mãos do nazireu depois de ter raspado a cabeça de sua separação; ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","e o sacerdote os acenará para uma oferta de ondas antes de Yahweh. Eles são santos para o sacerdote, junto com o peito que é ondulado e a coxa que é oferecida. Depois disso, o nazireu pode beber vinho. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“'Esta é a lei do nazista que jura e de sua oferta a Javé por sua separação, além do que ele é capaz de pagar. De acordo com seu voto que ele faz, assim ele deve fazer após a lei de sua separação'”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Fala a Arão e a seus filhos, dizendo: “Assim abençoarás os filhos de Israel”. Você lhes dirá, ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","'Yahweh te abençoe, e te guarde. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Yahweh faz o seu rosto para brilhar em você, e seja gracioso com você. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Yahweh levanta o rosto na sua direção, e lhe dar paz”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Assim porão meu nome sobre os filhos de Israel; e eu os abençoarei”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","No dia em que Moisés havia terminado de erigir o tabernáculo, e o havia ungido e santificado com todos os seus móveis, e o altar com todos os seus vasos, e os havia ungido e santificado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","os príncipes de Israel, os chefes das casas de seus pais, fizeram oferendas. Estes eram os príncipes das tribos. Estes eram os que estavam sobre aqueles que foram contados; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","e eles trouxeram suas ofertas diante de Javé, seis carroças cobertas e doze bois; uma carroça para cada dois dos príncipes, e para cada um deles um boi. Eles os apresentaram diante do tabernáculo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Aceite-os deles, para que possam ser usados no serviço da Tenda da Reunião; e você os entregará aos Levitas, a cada homem de acordo com seu serviço”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moisés pegou as carroças e os bois e os deu aos levitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ele deu duas carroças e quatro bois aos filhos de Gershon, de acordo com o serviço deles. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Ele deu quatro carroças e oito bois aos filhos de Merari, de acordo com seu serviço, sob a direção de Ithamar, filho de Aarão, o sacerdote. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mas aos filhos de Kohath ele não deu nenhum, porque o serviço do santuário lhes pertencia; eles o carregavam sobre os ombros. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Os príncipes deram oferendas para a dedicação do altar no dia em que ele foi ungido. Os príncipes deram suas oferendas diante do altar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Yahweh disse a Moisés: “Eles oferecerão sua oferta, cada príncipe em seu dia, para a dedicação do altar”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Aquele que ofereceu sua oferta no primeiro dia foi Nahshon, filho de Amminadab, da tribo de Judá, ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","e sua oferta foi: uma bandeja de prata, cujo peso era de cento e trinta shekels, uma bacia de prata de setenta siclos, de acordo com o siclo do santuário, ambos cheios de farinha fina misturada com óleo para uma oferta de refeição; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","uma concha dourada de dez shekels, cheia de incenso; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","um jovem touro, um carneiro, um cordeiro macho por ano de idade, para uma oferta queimada; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","um bode macho para uma oferta pelo pecado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","e pelo sacrifício de ofertas de paz, duas cabeças de gado, cinco carneiros, cinco bodes e cinco cordeiros machos por ano de idade. Esta foi a oferta de Nahshon, o filho de Amminadab. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","No segundo dia Nethanel, filho de Zuar, príncipe de Issachar, fez sua oferta. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ele se ofereceu por sua oferta: uma bandeja de prata, cujo peso era de cento e trinta shekels, uma bacia de prata de setenta siclos, de acordo com o shekel do santuário, ambos cheios de farinha fina misturada com óleo para uma oferta de refeição; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","uma concha dourada de dez shekels, cheia de incenso; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","um jovem touro, um carneiro, um cordeiro macho por ano de idade, para uma oferta queimada; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","um bode macho para uma oferta pelo pecado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","e pelo sacrifício das ofertas de paz, duas cabeças de gado, cinco carneiros, cinco bodes, cinco cordeiros machos por ano de idade. Esta foi a oferta de Nethanel, o filho de Zuar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","No terceiro dia Eliab, filho de Helon, príncipe das crianças de Zebulun, ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","gave sua oferta: uma bandeja de prata, cujo peso era de cento e trinta shekels, uma bacia de prata de setenta siclos, de acordo com o siclo do santuário, ambos cheios de farinha fina misturada com óleo para uma oferta de refeição; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","uma concha dourada de dez shekels, cheia de incenso; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","um jovem touro, um carneiro, um cordeiro macho por ano de idade, para uma oferta queimada; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","um bode macho para uma oferta pelo pecado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","e pelo sacrifício de ofertas de paz, duas cabeças de gado, cinco carneiros, cinco bodes e cinco cordeiros machos por ano de idade. Esta foi a oferenda de Eliab, o filho de Helon. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","No quarto dia Elizur, filho de Shedeur, príncipe dos filhos de Rúben, ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","gave sua oferta: uma bandeja de prata, cujo peso era de cento e trinta shekels, uma bacia de prata de setenta siclos, de acordo com o siclo do santuário, ambos cheios de farinha fina misturada com óleo para uma oferta de refeição; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","uma concha dourada de dez shekels, cheia de incenso; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","um jovem touro, um carneiro, um cordeiro macho por ano de idade, para uma oferta queimada; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","um bode macho para uma oferta pelo pecado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","e pelo sacrifício de ofertas de paz, duas cabeças de gado, cinco carneiros, cinco bodes e cinco cordeiros machos por ano de idade. Esta foi a oferenda de Elizur, o filho de Shedeur. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","No quinto dia Shelumiel, filho de Zurishaddai, príncipe dos filhos de Simeão, ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","gave sua oferta: uma bandeja de prata, cujo peso era de cento e trinta shekels, uma bacia de prata de setenta siclos, de acordo com o siclo do santuário, ambos cheios de farinha fina misturada com óleo para uma oferta de refeição; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","uma concha dourada de dez shekels, cheia de incenso; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","um jovem touro, um carneiro, um cordeiro macho por ano de idade, para uma oferta queimada; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","um bode macho para uma oferta pelo pecado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","e pelo sacrifício das ofertas de paz, duas cabeças de gado, cinco carneiros, cinco bodes e cinco cordeiros machos por ano: esta foi a oferta de Shelumiel, o filho de Zurishaddai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","No sexto dia, Eliasaph, filho de Deuel, príncipe dos filhos de Gad, ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","gave sua oferta: uma bandeja de prata, cujo peso era de cento e trinta shekels, uma bacia de prata de setenta siclos, de acordo com o siclo do santuário, ambos cheios de farinha fina misturada com óleo para uma oferta de refeição; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","uma concha dourada de dez shekels, cheia de incenso; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","um jovem touro, um carneiro, um cordeiro macho por ano de idade, para uma oferta queimada; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","um bode macho para uma oferta pelo pecado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","e pelo sacrifício de ofertas de paz, duas cabeças de gado, cinco carneiros, cinco bodes e cinco cordeiros machos por ano de idade. Esta foi a oferenda de Eliasaph, o filho de Deuel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","No sétimo dia Elishama, filho de Ammihud, príncipe dos filhos de Efraim, ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","gave sua oferta: uma bandeja de prata, cujo peso era de cento e trinta shekels, uma bacia de prata de setenta siclos, de acordo com o siclo do santuário, ambos cheios de farinha fina misturada com óleo para uma oferta de refeição; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","uma concha dourada de dez shekels, cheia de incenso; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","um jovem touro, um carneiro, um cordeiro macho por ano de idade, para uma oferta queimada; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","um bode macho para uma oferta pelo pecado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","e pelo sacrifício de ofertas de paz, duas cabeças de gado, cinco carneiros, cinco bodes e cinco cordeiros machos por ano de idade. Esta foi a oferenda de Elishama, o filho de Ammihud. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","No oitavo dia Gamaliel, filho de Pedahzur, príncipe dos filhos de Manasseh, ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","gave sua oferta: uma bandeja de prata, cujo peso era de cento e trinta shekels, uma bacia de prata de setenta siclos, de acordo com o siclo do santuário, ambos cheios de farinha fina misturada com óleo para uma oferta de refeição; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","uma concha dourada de dez shekels, cheia de incenso; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","um jovem touro, um carneiro, um cordeiro macho por ano de idade, para uma oferta queimada; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","um bode macho para uma oferta pelo pecado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","e pelo sacrifício de ofertas de paz, duas cabeças de gado, cinco carneiros, cinco bodes e cinco cordeiros machos por ano de idade. Esta foi a oferta de Gamaliel, o filho de Pedahzur. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","No nono dia Abidan, filho de Gideoni, príncipe dos filhos de Benjamin, ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","gave sua oferta: uma bandeja de prata, cujo peso era de cento e trinta shekels, uma bacia de prata de setenta siclos, de acordo com o siclo do santuário, ambos cheios de farinha fina misturada com óleo para uma oferta de refeição; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","uma concha dourada de dez shekels, cheia de incenso; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","um jovem touro, um carneiro, um cordeiro macho por ano de idade, para uma oferta queimada; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","um bode macho para uma oferta pelo pecado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","e pelo sacrifício de ofertas de paz, duas cabeças de gado, cinco carneiros, cinco bodes e cinco cordeiros machos por ano de idade. Esta foi a oferta de Abidan, o filho de Gideoni. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","No décimo dia Ahiezer, filho de Ammishaddai, príncipe dos filhos de Dan, ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","gave sua oferta: uma bandeja de prata, cujo peso era de cento e trinta shekels, uma bacia de prata de setenta siclos, de acordo com o siclo do santuário, ambos cheios de farinha fina misturada com óleo para uma oferta de refeição; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","uma concha dourada de dez shekels, cheia de incenso; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","um jovem touro, um carneiro, um cordeiro macho por ano de idade, para uma oferta queimada; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","um bode macho para uma oferta pelo pecado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","e pelo sacrifício de ofertas de paz, duas cabeças de gado, cinco carneiros, cinco bodes e cinco cordeiros machos por ano de idade. Esta foi a oferta de Ahiezer, o filho de Ammishaddai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","No décimo primeiro dia Pagiel, filho de Ochran, príncipe dos filhos de Asher, ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","gave sua oferta: uma bandeja de prata, cujo peso era de cento e trinta shekels, uma bacia de prata de setenta siclos, de acordo com o siclo do santuário, ambos cheios de farinha fina misturada com óleo para uma oferta de refeição; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","uma concha dourada de dez shekels, cheia de incenso; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","um jovem touro, um carneiro, um cordeiro macho por ano de idade, para uma oferta queimada; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","um bode macho para uma oferta pelo pecado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","e pelo sacrifício de ofertas de paz, duas cabeças de gado, cinco carneiros, cinco bodes e cinco cordeiros machos por ano de idade. Esta foi a oferta de Pagiel, o filho de Ochran. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","No décimo segundo dia Ahira, filho de Enan, príncipe dos filhos de Naftali, ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","gave sua oferta: uma bandeja de prata, cujo peso era de cento e trinta shekels, uma bacia de prata de setenta siclos, de acordo com o siclo do santuário, ambos cheios de farinha fina misturada com óleo para uma oferta de refeição; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","uma concha dourada de dez shekels, cheia de incenso; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","um jovem touro, um carneiro, um cordeiro macho por ano de idade, para uma oferta queimada; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","um bode macho para uma oferta pelo pecado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","e pelo sacrifício de ofertas de paz, duas cabeças de gado, cinco carneiros, cinco bodes e cinco cordeiros machos por ano de idade. Esta foi a oferta de Ahira, o filho de Enan. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Esta foi a oferenda de dedicação do altar, no dia em que foi ungido, pelos príncipes de Israel: doze bandejas de prata, doze taças de prata, doze conchas douradas; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","cada bandeja de prata pesando cento e trinta siclos, e cada taça setenta; toda a prata dos vasos dois mil e quatrocentos siclos, segundo o siclo do santuário; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","as doze conchas douradas, cheias de incenso, pesando dez siclos cada uma, segundo o siclo do santuário; todo o ouro das conchas pesava cento e vinte siclos; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","todo o gado para o holocausto doze touros, os carneiros doze, os cordeiros machos um ano de idade doze, e sua oferta de refeição; e doze bodes machos para a oferta pelo pecado; ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","e todo o gado para o sacrifício de ofertas de paz: vinte e quatro touros, sessenta carneiros, sessenta bodes e sessenta cordeiros machos de um ano de idade. Esta foi a oferenda de dedicação do altar, depois de ter sido ungido. ");
INSERT INTO porbrbsl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Quando Moisés entrou na Tenda da Reunião para falar com Javé, ouviu sua voz falando com ele de cima do propiciatório que estava na arca do Testemunho, de entre os dois querubins; e falou com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yahweh falou com Moisés, dizendo, ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Fale com Aaron, e diga-lhe: 'Quando você acender as lâmpadas, as sete lâmpadas darão luz em frente ao suporte da lâmpada'”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaron o fez. Ele acendeu suas lâmpadas para iluminar a área em frente ao suporte de lâmpadas, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Este foi o trabalho da banca de lâmpadas, trabalho batido de ouro. De sua base até suas flores, era um trabalho batido. Ele fez o candeeiro de acordo com o padrão que Yahweh havia mostrado a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Pegue os levitas dentre os filhos de Israel e os limpe. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Você fará isso com eles para limpá-los: polvilhe a água da limpeza sobre eles, deixe-os raspar o corpo inteiro com uma lâmina de barbear, deixe-os lavar suas roupas e limpar-se. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Em seguida, deixe-os levar um touro jovem e sua oferta de refeição, farinha fina misturada com óleo; e outro touro jovem que você levará para uma oferta pelo pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Você apresentará os Levitas antes da Tenda da Reunião. Vocês reunirão toda a congregação dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Apresentareis os Levitas antes de Yahweh. Os filhos de Israel imporão suas mãos sobre os levitas, ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","e Arão oferecerá os levitas diante de Iavé para uma oferta de onda em nome dos filhos de Israel, para que possa ser deles a fazer o serviço de Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Os levitas colocarão suas mãos sobre a cabeça dos touros, e você oferecerá um por uma oferta pelo pecado e o outro por uma oferta queimada a Javé, para fazer expiação pelos levitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Você colocará os levitas diante de Aarão e diante de seus filhos, e os oferecerá como uma oferta pela onda a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Assim você separará os levitas entre os filhos de Israel, e os levitas serão meus. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Depois disso, os Levitas devem entrar para fazer o serviço da Tenda de Reunião. Você deverá limpá-los e oferecê-los como uma oferta de onda. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Pois eles me são totalmente dados dentre os filhos de Israel; em vez de todos os que abrem o ventre, mesmo o primogênito de todos os filhos de Israel, eu os levei até mim. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Pois todos os primogênitos entre os filhos de Israel são meus, tanto o homem como o animal. No dia em que atingi todos os primogênitos na terra do Egito, eu os santificei para mim mesmo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Levei os levitas ao invés de todos os primogênitos entre os filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Dei os levitas como presente a Arão e a seus filhos dentre os filhos de Israel, para fazer o serviço dos filhos de Israel na Tenda da Reunião, e fazer expiação pelos filhos de Israel, para que não haja praga entre os filhos de Israel quando os filhos de Israel se aproximarem do santuário”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moisés e Aarão, e toda a congregação das crianças de Israel o fizeram aos levitas. De acordo com tudo o que Javé ordenou a Moisés a respeito dos levitas, assim os filhos de Israel o fizeram a eles. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Os levitas se purificaram do pecado, e lavaram suas roupas; e Arão os ofereceu para uma oferta de ondas antes que Iavé e Arão fizessem expiação por eles para limpá-los. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Depois disso, os levitas foram fazer seu serviço na Tenda da Reunião diante de Aarão e diante de seus filhos: como Javé havia ordenado a Moisés a respeito dos levitas, assim eles fizeram com eles. ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“É isto que é atribuído aos Levitas: a partir dos vinte e cinco anos de idade eles entrarão para aguardar o serviço na Tenda da Reunião; ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","e a partir dos cinqüenta anos de idade eles se retirarão do trabalho, e não servirão mais, ");
INSERT INTO porbrbsl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","mas ajudarão seus irmãos na Tenda da Reunião, para cumprir o dever, e não prestarão nenhum serviço. É assim que vocês farão com que os Levitas cumpram suas obrigações”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Yahweh falou a Moisés no deserto do Sinai, no primeiro mês do segundo ano após eles terem saído da terra do Egito, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Que os filhos de Israel guardem a Páscoa em sua época designada. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","No décimo quarto dia deste mês, à noite, guardá-la-ão em sua estação designada. Guardá-la-eis de acordo com todos os seus estatutos e de acordo com todas as suas ordenanças”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moisés disse aos filhos de Israel que eles deveriam manter a Páscoa. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Eles guardaram a Páscoa no primeiro mês, no décimo quarto dia do mês, à noite, no deserto do Sinai. De acordo com tudo o que Iavé ordenou a Moisés, assim o fizeram os filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Havia certos homens que estavam imundos por causa do cadáver de um homem, para que não pudessem celebrar a Páscoa naquele dia, e chegaram diante de Moisés e Aarão naquele dia. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Aqueles homens lhe disseram: “Estamos imundos por causa do cadáver de um homem”. Por que somos mantidos afastados, para que não ofereçamos a oferta de Javé em sua época designada entre os filhos de Israel”? ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moisés respondeu-lhes: “Esperem, para que eu possa ouvir o que Iavé mandará a seu respeito”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Diga aos filhos de Israel: 'Se algum homem de vocês ou de suas gerações for imundo por causa de um cadáver, ou estiver em uma viagem para longe, ele ainda guardará a Páscoa para Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","No segundo mês, no décimo quarto dia da noite a celebrarão; comerão com pão ázimo e ervas amargas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Não deixarão nada dela até a manhã, nem quebrarão um osso dela. De acordo com todo o estatuto da Páscoa, eles a guardarão. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Mas o homem que estiver limpo, e não estiver em viagem, e não guardar a Páscoa, essa alma será cortada de seu povo. Como ele não ofereceu a oferenda de Javé em sua época designada, esse homem deverá suportar seu pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“'Se um estrangeiro vive entre vocês e deseja manter a Páscoa a Iavé, então ele o fará de acordo com o estatuto da Páscoa, e de acordo com sua portaria. Tereis um estatuto, tanto para o estrangeiro como para aquele que nasceu na terra””. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","No dia em que o tabernáculo foi erguido, a nuvem cobriu o tabernáculo, até mesmo a Tenda do Testemunho. À noite, estava sobre o tabernáculo, como se fosse o aparecimento do fogo, até de manhã. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Assim foi continuamente. A nuvem o cobria, e a aparência de fogo à noite. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Sempre que a nuvem era levantada de cima da Tenda, depois disso as crianças de Israel viajavam; e no lugar onde a nuvem permanecia, ali as crianças de Israel acampavam. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Por ordem de Iavé, os filhos de Israel viajavam, e por ordem de Iavé, acampavam. Enquanto a nuvem permaneceu no tabernáculo, eles permaneceram acampados. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Quando a nuvem permaneceu no tabernáculo por muitos dias, então os filhos de Israel mantiveram o comando de Iavé, e não viajaram. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Algumas vezes a nuvem permanecia alguns dias no tabernáculo; então, de acordo com o mandamento de Javé, eles permaneceram acampados, e de acordo com o mandamento de Javé, eles viajaram. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Às vezes a nuvem era da noite até de manhã; e quando a nuvem era levantada pela manhã, eles viajavam; ou de dia e de noite, quando a nuvem era levantada, eles viajavam. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Quer fossem dois dias, ou um mês, ou um ano que a nuvem permaneceu no tabernáculo, permanecendo nele, os filhos de Israel permaneceram acampados, e não viajaram; mas quando a nuvem foi levantada, eles viajaram. ");
INSERT INTO porbrbsl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ao mandamento de Iavé eles acamparam, e ao mandamento de Iavé eles viajaram. Mantiveram o comando de Iavé, à ordem de Iavé por Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yahweh falou com Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Faça duas trombetas de prata. Faça-as de trabalho batido. Você as usará para a vocação da congregação e para a viagem dos acampamentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Quando os soprarem, toda a congregação se reunirá à sua porta na Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Se eles soprarem apenas um, então os príncipes, os chefes dos milhares de Israel, se reunirão à sua presença. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Quando soprarem um alarme, os campos que se encontram no lado leste seguirão em frente. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Quando soprar um alarme pela segunda vez, os acampamentos que se encontram no lado sul seguirão adiante. Eles devem soprar um alarme para suas viagens. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Mas quando a assembléia estiver para ser reunida, soprarão, mas não soarão um alarme. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Os filhos de Aarão, os sacerdotes, tocarão as trombetas. Isto será para vocês por um estatuto para sempre através de suas gerações”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Quando entrarem em guerra em suas terras contra o adversário que vos oprime, então soarão um alarme com as trombetas. Então você será lembrado perante Javé, seu Deus, e será salvo de seus inimigos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","“Também no dia de sua alegria, e em suas festas de conjunto, e no início de seus meses, você soprará as trombetas sobre suas ofertas queimadas, e sobre os sacrifícios de suas ofertas de paz; e elas serão para você para um memorial diante de seu Deus. Eu sou Yahweh, vosso Deus”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","No segundo ano, no segundo mês, no vigésimo dia do mês, a nuvem foi tirada de cima do tabernáculo do convênio. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","As crianças de Israel seguiram em suas viagens para fora do deserto do Sinai; e a nuvem permaneceu no deserto de Paran. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Eles primeiro seguiram em frente de acordo com o mandamento de Iavé por Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Primeiro, o padrão do acampamento das crianças de Judah foi adiante de acordo com seus exércitos. Nahshon, filho de Amminadab, estava sobre seu exército. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nethanel, filho de Zuar, estava sobre o exército da tribo dos filhos de Issachar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliab, filho de Helon, estava sobre o exército da tribo dos filhos de Zebulun. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","O tabernáculo foi derrubado; e os filhos de Gershon e os filhos de Merari, que carregavam o tabernáculo, seguiram em frente. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","O padrão do acampamento de Rúben foi para frente de acordo com seus exércitos. Elizur, o filho de Shedeur, estava sobre seu exército. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumiel, o filho de Zurishaddai, estava sobre o exército da tribo dos filhos de Simeão. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliasaph, filho de Deuel, estava sobre o exército da tribo dos filhos de Gad. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Os kohatitas se adiantaram, levando o santuário. Os outros montaram o tabernáculo antes de chegarem. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","O padrão do acampamento das crianças de Efraim estabelecido de acordo com seus exércitos. Elishama, o filho de Ammihud, estava sobre seu exército. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel, filho de Pedahzur, estava sobre o exército da tribo dos filhos de Manasseh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidan, filho de Gideoni, estava sobre o exército da tribo dos filhos de Benjamin. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","O padrão do acampamento das crianças de Dan, que era a retaguarda de todos os acampamentos, estabelecido para frente de acordo com seus exércitos. Ahiezer, o filho de Ammishaddai, estava sobre seu exército. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagiel, filho de Ochran, estava sobre o exército da tribo dos filhos de Asher. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahira o filho de Enan estava sobre o exército da tribo dos filhos de Naftali. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Thus eram as viagens dos filhos de Israel de acordo com seus exércitos; e eles seguiram em frente. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moisés disse a Hobab, o filho de Reuel, o Midianita, sogro de Moisés: “Estamos viajando para o lugar do qual Yahweh disse: 'Eu to darei'”. Venha conosco, e nós o trataremos bem; pois Javé falou bem de Israel”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ele lhe disse: “Eu não irei; mas partirei para minha própria terra e para meus parentes”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Moisés disse: “Não nos deixe, por favor; porque você sabe como devemos acampar no deserto, e você pode ser nossos olhos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Será, se você for conosco - sim, será - que qualquer bem que Yahweh nos fizer, nós faremos o mesmo com você”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Eles partiram do Monte de Yahweh em três dias de viagem. A arca do convênio de Iavé foi antes deles três dias de viagem, para buscar um lugar de descanso para eles. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","A nuvem de Iavé estava sobre eles de dia, quando partiram do acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Quando a arca foi adiante, Moisés disse: “Levanta-te, Javé, e deixa que teus inimigos sejam dispersos! Que aqueles que te odeiam fujam diante de ti”! ");
INSERT INTO porbrbsl_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Quando descansou, ele disse: “Retorna, Javé, aos dez mil dos milhares de Israel”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","As pessoas estavam reclamando nos ouvidos de Yahweh. Quando Javé ouviu isso, sua raiva queimou; e o fogo de Javé queimou entre eles, e consumiu alguns dos arredores do acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","O povo chorou a Moisés; e Moisés orou a Javé, e o fogo diminuiu. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","O nome daquele lugar foi chamado Taberah, porque o fogo de Iavé queimou entre eles. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","A multidão mista que estava entre eles cobiçava demais; e os filhos de Israel também choraram novamente, e disseram: “Quem nos dará carne para comer? ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Recordamos o peixe, que comemos no Egito por nada; os pepinos, e os melões, e os alhos-porros, e as cebolas, e o alho; ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","mas agora perdemos o apetite. Não há nada além deste maná para se olhar”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","O maná era como uma semente de coentro, e parecia bdellium. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","As pessoas foram em volta, o colheram e o moeram em moinhos, ou o bateram em argamassas, e o cozeram em panelas, e fizeram bolos com ele. Seu sabor era como o sabor do óleo fresco. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Quando o orvalho caiu no acampamento durante a noite, o maná caiu sobre ele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moisés ouviu as pessoas chorando em suas famílias, cada homem à porta de sua tenda; e a raiva de Javé ardeu muito; e Moisés ficou descontente. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Moisés disse a Javé: “Por que você tem tratado tão mal seu servo? Por que não encontrei favor em sua visão, que você me impôs o fardo de todo este povo? ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Será que eu concebi todo este povo? Se os trouxe para fora, que me diga: 'Carregue-os em seu seio, como uma enfermeira carrega uma criança amamentada, para a terra que você jurou aos pais deles'? ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Onde eu poderia conseguir carne para dar a todas essas pessoas? Pois eles choram diante de mim, dizendo: 'Dê-nos carne, para que possamos comer'. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Não sou capaz de suportar toda esta gente sozinha, porque é muito pesada para mim. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Se você me tratar desta maneira, por favor, mate-me agora mesmo, se eu encontrei favor em sua vista; e não me deixe ver minha miséria”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Yahweh disse a Moisés: “Reuni a mim setenta homens dos anciãos de Israel, que vós sabeis ser os anciãos do povo e oficiais sobre eles; e levai-os à Tenda da Reunião, para que estejam ali convosco. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Eu descerei e falarei com vocês lá. Tomarei do Espírito que está sobre vós, e o porei sobre eles; e eles carregarão o fardo do povo convosco, para que não o carregueis sozinhos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Digam ao povo: 'Santificai-vos em preparação para o amanhã, e comereis carne; pois chorastes aos ouvidos de Javé, dizendo: “Quem nos dará carne para comer? Pois foi bom para nós no Egito”. Portanto, Javé vos dará carne e vós comereis. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Você não comerá apenas um dia, ou dois dias, ou cinco dias, ou dez dias, ou vinte dias, ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","mas um mês inteiro, até que saia em suas narinas, e é repugnante para você; porque você rejeitou Yahweh que está entre vocês, e chorou diante dele, dizendo: “Por que saímos do Egito””. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moisés disse: “O povo, entre os quais estou, são seiscentos mil homens a pé; e você disse: 'Eu lhes darei carne, para que possam comer um mês inteiro'. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Shall rebanhos e rebanhos são abatidos para eles, para que sejam suficientes para eles? Todos os peixes do mar devem ser reunidos para eles, para que sejam suficientes para eles”? ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yahweh disse a Moisés: “A mão de Yahweh ficou curta? Agora você vai ver se minha palavra vai acontecer com você ou não”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moisés saiu e contou ao povo as palavras de Javé; e reuniu setenta homens dos anciãos do povo, e os colocou em torno da Tenda. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Yahweh desceu na nuvem, falou com ele, tomou do Espírito que estava sobre ele, e o colocou sobre os setenta anciãos. Quando o Espírito descansou sobre eles, eles profetizaram, mas eles não o fizeram mais. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Mas dois homens permaneceram no acampamento. O nome de um era Eldad, e o nome do outro Medad; e o Espírito repousou sobre eles. Eles eram daqueles que foram escritos, mas não tinham saído para a Tenda; e profetizaram no acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Um jovem correu, disse a Moisés, e disse: “Eldad e Medad profetizam no acampamento”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Josué, filho de Freira, o servo de Moisés, um de seus escolhidos, respondeu: “Meu senhor Moisés, proíbe-os”! ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moisés lhe disse: “Você está com ciúmes por minha causa? Gostaria que todo o povo de Javé fosse profetas, que Javé colocasse seu Espírito sobre eles”! ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Moisés foi para o campo, ele e os anciãos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Um vento de Javé saiu e trouxe codornizes do mar, e as deixou cair junto ao acampamento, cerca de um dia de viagem deste lado, e um dia de viagem do outro lado, ao redor do acampamento, e cerca de dois cúbitos acima da superfície da terra. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","O povo levantou-se todo aquele dia, e toda aquela noite, e todo o dia seguinte, e juntou as codornizes. Aquele que menos reuniu dez pessoas, e as espalhou por si mesmo ao redor do acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Enquanto a carne ainda estava entre seus dentes, antes de ser mastigada, a raiva de Yahweh queimou contra o povo, e Yahweh atingiu o povo com uma praga muito grande. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","O nome daquele lugar se chamava Kibroth Hattaavah, porque ali enterraram as pessoas que cobiçavam. ");
INSERT INTO porbrbsl_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","De Kibroth Hattaavah, as pessoas viajaram para Hazeroth; e ficaram em Hazeroth. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriam e Arão falaram contra Moisés por causa da mulher cuchita com quem ele havia casado; pois ele havia casado com uma mulher cuchita. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Eles disseram: “Será que Yahweh realmente falou somente com Moisés? Ele não falou também conosco?”. E Yahweh ouviu. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Agora o homem Moisés era muito humilde, mais do que todos os homens que estavam na superfície da terra. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Yahweh falou subitamente a Moisés, a Arão e a Miriam: “Vocês três venham para a Tenda da Reunião”! Os três saíram. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Yahweh desceu em uma coluna de nuvem, e ficou na porta da Tenda, e chamou Aaron e Miriam; e ambos se apresentaram. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ele disse: “Agora ouçam minhas palavras. Se houver um profeta entre vocês, eu, Yahweh, me farei conhecer a ele numa visão. Falarei com ele em um sonho. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Meu servo Moisés não é assim. Ele é fiel em toda a minha casa. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Com ele, falarei boca a boca, mesmo claramente, e não por enigmas; e ele verá a forma de Javé. Por que então não teve medo de falar contra meu servo, contra Moisés”? ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","A raiva de Javé queimou contra eles; e ele partiu. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","A nuvem partiu de cima da Tenda; e eis que Miriam era leprosa, tão branca como a neve. Aaron olhou para Miriam, e eis que ela era leprosa. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Arão disse a Moisés: “Oh, meu senhor, por favor não conte este pecado contra nós, no qual fizemos tolices, e no qual pecamos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Que ela não seja, oro, como um morto, de quem a carne é meio consumida quando ele sai do ventre de sua mãe”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moisés gritou a Javé, dizendo: “Cura-a, Deus, eu te imploro”! ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Yahweh disse a Moisés: “Se seu pai só tivesse cuspido na cara dela, ela não deveria ter vergonha de sete dias? Que ela fique fechada fora do acampamento sete dias, e depois disso ela será trazida novamente”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriam foi fechada fora do acampamento por sete dias, e as pessoas não viajaram até que Miriam fosse trazida novamente. ");
INSERT INTO porbrbsl_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Depois disso, o povo viajou de Hazeroth, e acamparam no deserto de Paran. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Manda homens, para que espiem a terra de Canaã, que eu dou aos filhos de Israel. De cada tribo de seus pais, enviareis um homem, cada um príncipe entre eles”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moisés os enviou do deserto de Paran de acordo com o mandamento de Yahweh. Todos eles eram homens que eram chefes dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Estes eram seus nomes: Da tribo de Reuben, Shammua o filho de Zaccur. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Da tribo de Simeão, Shaphat o filho de Hori. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Da tribo de Judá, Calebe o filho de Jefoné. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Da tribo de Issachar, Igal o filho de José. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Da tribo de Efraim, Hoshea o filho de Freira. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Da tribo de Benjamin, Palti o filho de Raphu. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Da tribo de Zebulun, Gaddiel o filho de Sodi. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Da tribo de José, da tribo de Manasseh, Gaddi o filho de Susi. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Da tribo de Dan, Ammiel o filho de Gemalli. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Da tribo de Asher, Sethur o filho de Michael. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Da tribo de Naftali, Nahbi o filho de Vophsi. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Da tribo de Gad, Geuel o filho de Machi. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Estes são os nomes dos homens que Moisés enviou para espionar a terra. Moisés chamou Hoshea de filho de Freira Josué. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moisés os enviou para espionar a terra de Canaã, e lhes disse: “Subam por aqui pelo Sul, e subam para a região montanhosa”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Veja a terra, o que é; e as pessoas que nela habitam, se são fortes ou fracas, se são poucas ou muitas; ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","e em que terra habitam, se é boa ou má; e em que cidades habitam, se em acampamentos, ou em fortalezas; ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","e o que é a terra, se é fértil ou pobre, se há madeira nela, ou não. Seja corajoso e traga alguns dos frutos da terra”. Agora era a época das primeiras uvas maduras. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Então eles subiram, e espiaram a terra desde o deserto de Zin até Rehob, até a entrada de Hamath. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Eles subiram pelo Sul e chegaram a Hebron; e Ahiman, Sheshai e Talmai, os filhos de Anak, estavam lá. (Agora Hebron foi construída sete anos antes de Zoan no Egito.) ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Eles chegaram ao vale de Eshcol, e cortaram de lá um ramo com um cacho de uvas, e o carregaram em um bastão entre dois. Eles também trouxeram algumas das romãs e figos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Aquele lugar foi chamado o vale do Escol, por causa do cacho que as crianças de Israel cortaram de lá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Eles voltaram de espionar a terra ao final de quarenta dias. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Eles foram e vieram a Moisés, a Aarão e a toda a congregação dos filhos de Israel, ao deserto de Paran, a Cades; e trouxeram de volta notícias para eles e para toda a congregação. Eles lhes mostraram o fruto da terra. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Eles lhe disseram, e disseram: “Viemos à terra para onde vocês nos enviaram”. Certamente ela flui com leite e mel, e este é o seu fruto”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Entretanto, as pessoas que habitam a terra são fortes, e as cidades são fortificadas e muito grandes. Além disso, vimos lá os filhos de Anak. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalek mora na terra do Sul. O hitita, o jebusita, e o amorreu habitam na região montanhosa. Os cananeus habitam junto ao mar, e ao longo da margem do Jordão”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Caleb, que se aproximou do povo antes de Moisés, disse: “Vamos subir imediatamente e possuí-lo, pois somos bem capazes de superá-lo”! ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mas os homens que subiram com ele disseram: “Não somos capazes de subir contra o povo; pois eles são mais fortes do que nós”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Eles trouxeram à tona um relato maligno da terra que tinham espionado aos filhos de Israel, dizendo: “A terra, pela qual fomos espioná-la, é uma terra que devora seus habitantes; e todas as pessoas que vimos nela são homens de grande estatura. ");
INSERT INTO porbrbsl_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Lá vimos os nefilins, os filhos de Anak, que vêm dos nefilins. Estávamos à nossa própria vista como gafanhotos, e assim estávamos à vista deles”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Toda a congregação levantou sua voz, e chorou; e o povo chorou naquela noite. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Todas as crianças de Israel murmuraram contra Moisés e contra Arão. Toda a congregação lhes disse: “Desejamos que tivéssemos morrido na terra do Egito, ou que tivéssemos morrido neste deserto! ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Por que Iavé nos traz a esta terra, para cair à espada? Nossas esposas e nossos pequenos serão capturados ou mortos! Não seria melhor para nós voltarmos ao Egito?” ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Disseram um ao outro: “Vamos escolher um líder, e vamos voltar ao Egito”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Então Moisés e Arão caíram de rosto caído diante de toda a assembléia da congregação dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Josué, filho de Nun e Caleb, filho de Jephunneh, que eram dos que espiaram a terra, rasgaram suas roupas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Eles falaram a toda a congregação dos filhos de Israel, dizendo: “A terra, pela qual passamos para espioná-la, é uma terra extremamente boa”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Se Yahweh se deleita conosco, então ele nos trará para esta terra, e nos dará: uma terra que flui com leite e mel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Somente não se revolte contra Iavé, nem tema o povo da terra; pois eles são pão para nós. Sua defesa é retirada de cima deles, e Yahweh está conosco. Não tenha medo deles”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Mas toda a congregação ameaçou apedrejá-los com pedras. A glória de Yahweh apareceu na Tenda de Reunião para todas as crianças de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Yahweh disse a Moisés: “Quanto tempo este povo vai me desprezar? Por quanto tempo eles não acreditarão em mim, por todos os sinais que tenho trabalhado entre eles? ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Vou atacá-los com a peste e deserdá-los, e farei de vocês uma nação maior e mais poderosa do que eles”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moisés disse a Iavé: “Então os egípcios o ouvirão; pois você educou este povo em seu poder de entre eles”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Eles o dirão aos habitantes desta terra”. Eles ouviram dizer que você, Javé, está entre este povo; pois você, Javé, é visto face a face, e sua nuvem está sobre eles, e você vai diante deles, num pilar de nuvem de dia, e num pilar de fogo de noite. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Agora, se você matou este povo como um só homem, então as nações que ouviram a fama de você falarão, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","'Porque Javé não foi capaz de trazer este povo para a terra que ele lhes jurou, por isso ele os matou no deserto'. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Agora, por favor, deixai que o poder do Senhor seja grande, conforme falastes, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","'Yahweh é lento na ira, e abundante na bondade amorosa, perdoando a iniqüidade e a desobediência; e ele de modo algum limpará os culpados, visitando a iniqüidade dos pais sobre os filhos, sobre a terceira e a quarta geração'. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Por favor, perdoe a iniqüidade deste povo de acordo com a grandeza de sua bondade amorosa, e assim como você perdoou este povo, desde o Egito até agora”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Yahweh disse: “Perdoei de acordo com a sua palavra; ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","mas em toda a ação - como eu vivo, e como toda a terra será cheia da glória de Yahweh - ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","porque todos aqueles homens que viram minha glória e meus sinais, que eu trabalhei no Egito e no deserto, mas me tentaram estas dez vezes, e não escutaram minha voz; ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","certamente não verão a terra que eu jurei a seus pais, nem nenhum daqueles que me desprezaram a verão. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Mas meu servo Caleb, porque tinha outro espírito com ele, e me seguiu plenamente, eu o trarei para a terra para onde ele foi. Sua descendência a possuirá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Since os amalequitas e os cananeus habitam no vale, amanhã viram e vão para o deserto pelo caminho do Mar Vermelho”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Yahweh falou a Moisés e a Arão, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Por quanto tempo vou suportar esta má congregação que se queixa contra mim? Ouvi as queixas dos filhos de Israel, que se queixam contra mim. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Diga-lhes: “Como eu vivo, diz Javé, certamente como vocês falaram aos meus ouvidos, assim eu farei a vocês”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Seus cadáveres cairão neste deserto; e todos os que foram contados de vocês, de acordo com seu número inteiro, a partir de vinte anos de idade, que reclamaram contra mim, ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","certamente não entrarão na terra a respeito da qual jurei que os faria habitar, exceto Calebe, filho de Jefoné, e Josué, filho de Freira. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Mas eu trarei seus pequenos que você disse que deveriam ser capturados ou mortos, e eles conhecerão a terra que você rejeitou. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Mas quanto a vocês, seus cadáveres cairão neste deserto. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Seus filhos serão errantes no deserto durante quarenta anos, e suportarão sua prostituição, até que seus cadáveres sejam consumidos no deserto. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Após o número de dias em que vocês espiaram a terra, mesmo quarenta dias, por cada dia do ano, vocês suportarão suas iniquidades, mesmo quarenta anos, e conhecerão minha alienação'. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Eu, Yahweh, falei. Certamente farei isto a toda esta congregação maligna que está reunida contra mim. Neste deserto eles serão consumidos, e ali morrerão”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Os homens que Moisés enviou para espionar a terra, que voltaram e fizeram toda a congregação murmurar contra ele, trazendo um relatório maligno contra a terra, ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","mesmo aqueles homens que trouxeram um relatório maligno sobre a terra, morreram pela peste antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Mas Josué, filho de Nun, e Calebe, filho de Jefoné, permaneceram vivos daqueles homens que foram espionar a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Moisés disse estas palavras a todas as crianças de Israel, e o povo lamentou muito. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Eles se levantaram de manhã cedo e subiram ao topo da montanha, dizendo: “Eis que estamos aqui, e iremos ao lugar que Javé prometeu; pois pecamos”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Moisés disse: “Por que agora você desobedece ao mandamento de Iavé, já que ele não prosperará? ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Não suba, pois Yahweh não está entre vocês; assim não será derrubado diante de seus inimigos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Pois ali os amalequitas e os cananeus estão diante de vocês, e vocês cairão pela espada porque voltaram a seguir a Iavé; portanto Iavé não estará com vocês”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Mas eles presumiram subir até o topo da montanha. No entanto, a arca do pacto de Iavé e Moisés não saíram do acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Então os amalequitas desceram, e os cananeus que viviam naquela montanha, e os atingiram e bateram até mesmo em Hormah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Fale aos filhos de Israel, e diga-lhes: 'Quando vocês entrarem na terra de suas habitações, que eu lhes dou, ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","e fizerem uma oferta pelo fogo a Yahweh - uma oferta queimada, ou um sacrifício, para cumprir um voto', ou como uma oferta de livre vontade, ou em suas festas de conjunto, para fazer um aroma agradável a Javé, do rebanho, ou do rebanho - ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","então aquele que oferecer sua oferta oferecerá a Javé uma oferta de refeição de um décimo de um efa de farinha fina misturada com um quarto de um him de óleo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","preparará vinho para a oferta de bebida, um quarto de um him, com a oferta queimada ou para o sacrifício, para cada cordeiro. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“'Para um carneiro, você se preparará para uma refeição oferecendo dois décimos de uma efa de farinha fina misturada com a terceira parte de um him de azeite; ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","e para a oferta de bebida você oferecerá a terceira parte de um him de vinho, de aroma agradável a Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Quando você preparar um touro para uma oferta queimada ou para um sacrifício, para cumprir um voto, ou para ofertas de paz a Iavé, ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","então oferecerá com o touro uma oferta de refeição de três décimos de um efa de farinha fina misturada com meia parte de um hino de óleo; ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","e oferecerá pela oferta de bebida metade de um hino de vinho, por uma oferta feita pelo fogo, de aroma agradável a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Assim será feito para cada touro, para cada carneiro, para cada um dos cordeiros machos, ou dos cabritos jovens. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","De acordo com o número que você deve preparar, assim você deve fazer a todos de acordo com seu número. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“'Todos os nativos devem fazer estas coisas desta maneira, oferecendo uma oferta feita pelo fogo, de um aroma agradável a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Se um estrangeiro viver como estrangeiro com você, ou quem quer que esteja entre vocês através de suas gerações, e oferecer uma oferta feita pelo fogo, de aroma agradável a Iavé, como você faz, assim ele fará. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Para a assembléia, haverá um estatuto para você e para o estrangeiro que vive como estrangeiro, um estatuto para sempre ao longo de suas gerações. Como você é, assim o estrangeiro estará perante Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Uma lei e uma portaria serão para você e para o estrangeiro que vive como estrangeiro com você”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Javé falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Fala aos filhos de Israel, e diz-lhes: 'Quando entrardes na terra onde eu vos trago, ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","então será que quando comerdes do pão da terra, oferecereis uma oferta de onda a Javé'. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","da primeira de sua massa, você oferecerá um bolo para uma oferta de ondas. Como a oferta de onda da eira, assim você a oferecerá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Da primeira de sua massa, você oferecerá a Iavé uma oferta de onda através de suas gerações. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“'Quando você errar, e não observar todos estes mandamentos que Javé falou a Moisés - ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","mesmo tudo o que Javé lhe ordenou por Moisés, desde o dia em que Javé lhe deu o mandamento e em diante através de sua geração - ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","então será, se foi feito involuntariamente, sem o conhecimento da congregação, que toda a congregação oferecerá um touro jovem para uma oferta queimada, para um aroma agradável a Iavé, com sua oferta de refeição e sua oferta de bebida, de acordo com a ordenança, e um bode macho para uma oferta pelo pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","O sacerdote fará expiação por toda a congregação dos filhos de Israel, e eles serão perdoados; pois foi um erro, e eles trouxeram sua oferta, uma oferta feita pelo fogo a Javé, e sua oferta pelo pecado diante de Javé, por seu erro. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Toda a congregação dos filhos de Israel será perdoada, assim como o estrangeiro que vive como estrangeiro entre eles; pois em relação a todo o povo, isso foi feito involuntariamente. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“'Se uma pessoa pecar involuntariamente, então deve oferecer uma cabra de um ano de idade por uma oferta pelo pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","O sacerdote fará expiação pela alma que erra quando peca involuntariamente diante de Yahweh. Ele fará expiação por ele; e ele será perdoado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Tereis uma lei para aquele que faz qualquer coisa involuntariamente, para aquele que nasceu entre os filhos de Israel, e para o estrangeiro que vive como estrangeiro entre eles. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“'Mas a alma que faz qualquer coisa com mão alta, quer seja nativa ou estrangeira, blasfema Yahweh. Essa alma será cortada do meio de seu povo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Por ter desprezado a palavra de Javé, e por ter violado seu mandamento, essa alma será totalmente extirpada. Sua iniqüidade estará sobre ele”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Enquanto as crianças de Israel estavam no deserto, eles encontraram um homem juntando paus no dia de sábado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Aqueles que o encontraram reunindo paus o trouxeram a Moisés e Aarão, e a toda a congregação. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Eles o colocaram sob custódia, porque não havia sido declarado o que deveria ser feito com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Yahweh disse a Moisés: “O homem certamente será condenado à morte. Toda a congregação o apedrejará fora do acampamento”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Toda a congregação o levou para fora do acampamento e o apedrejou até a morte, como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yahweh falou com Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Fale com os filhos de Israel, e diga-lhes que eles devem fazer-se franjas nas bordas de suas vestes através de suas gerações, e que eles coloquem na franja de cada fronteira um cordão de azul. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Será para vocês uma franja, para que possam vê-la e lembrar-se de todos os mandamentos de Javé e cumpri-los; e para que não sigam seu próprio coração e seus próprios olhos, depois do que costumavam fazer de prostituta; ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","para que possam lembrar-se e cumprir todos os meus mandamentos, e serem santos para seu Deus. ");
INSERT INTO porbrbsl_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Eu sou Yahweh, vosso Deus, que vos tirou da terra do Egito, para ser vosso Deus: Eu sou Yahweh, vosso Deus”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Now Korah, filho de Izhar, filho de Kohath, filho de Levi, com Datã e Abiram, filhos de Eliab, e On, filho de Peleth, filhos de Rúben, levou alguns homens. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Levantaram-se diante de Moisés, com alguns dos filhos de Israel, duzentos e cinqüenta príncipes da congregação, chamados à assembléia, homens de renome. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Eles se reuniram contra Moisés e contra Aarão, e lhes disseram: “Vocês assumem demais, pois toda a congregação é santa, todos eles, e Yahweh está entre eles! Por que vocês se elevam acima da assembléia de Iavé”? ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Quando Moisés ouviu isso, caiu de cara. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ele disse a Korah e a toda sua companhia: “Pela manhã, Yahweh mostrará quem é seu, e quem é santo, e o fará aproximar-se dele”. Mesmo aquele que ele escolher, ele fará com que se aproxime dele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Faça isto: faça com que Korah e toda sua companhia tomem censores, ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ponha fogo neles, e coloque incenso neles antes de Yahweh amanhã. Será que o homem que Yahweh escolher, ele será santo. Vocês foram longe demais, seus filhos de Levi”! ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moisés disse a Coré: “Ouçam agora, filhos de Levi! ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","É uma coisa pequena para vocês que o Deus de Israel os separou da congregação de Israel, para trazê-los para perto de si, para fazer o serviço do tabernáculo de Javé, e para se apresentarem diante da congregação para ministrar a eles; ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","e que ele os aproximou, e a todos os seus irmãos, os filhos de Levi, com vocês? Vocês também buscam o sacerdócio? ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Portanto, você e toda a sua empresa se reuniram contra Javé! O que é Aarão que você reclama contra ele”? ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Moisés enviou para chamar Dathan e Abiram, os filhos de Eliab; e eles disseram: “Nós não subiremos! ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","É uma pequena coisa que você nos fez subir de uma terra que flui com leite e mel, para nos matar no deserto, mas você também deve fazer-se um príncipe sobre nós? ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Além disso, você não nos trouxe para uma terra que flui com leite e mel, nem nos deu herança de campos e vinhedos. Você vai apagar os olhos desses homens? Não vamos subir”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moisés ficou muito zangado e disse a Javé: “Não respeite a oferta deles”. Eu não tirei um burro deles, nem machuquei um deles”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moisés disse a Korah: “Você e toda sua empresa vão antes de Yahweh, você, e eles, e Aaron, amanhã. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Cada homem pega seu incensário e põe incenso nele, e cada homem traz diante de Javé seu incensário, duzentos e cinqüenta incensários; você também, e Aarão, cada um com seu incensário”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Cada um pegou seu incensário, colocou fogo, incendiou-o e ficou à porta da Tenda de Encontro com Moisés e Aarão. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Korah reuniu toda a congregação em frente à porta da Tenda de Reunião. A glória de Yahweh apareceu a toda a congregação. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Yahweh falou com Moisés e com Arão, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Separem-se desta congregação, para que eu possa consumi-los em um momento”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Eles caíram de cara, e disseram: “Deus, o Deus dos espíritos de toda a carne, pecará um só homem, e você ficará zangado com toda a congregação”? ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Yahweh falou com Moisés, dizendo, ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Fale com a congregação, dizendo, 'Afaste-se da tenda de Corá, Datã e Abirão! ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moisés levantou-se e foi para Datã e Abirão; e os anciãos de Israel o seguiram. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ele falou à congregação, dizendo: “Parta, por favor, das tendas destes homens maus, e não toque em nada do que é deles, para que não seja consumido em todos os seus pecados”! ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Então eles se afastaram da tenda de Corá, Datã e Abiram, de todos os lados. Datã e Abirão saíram, e ficaram à porta de suas tendas com suas esposas, seus filhos e seus pequenos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moisés disse: “Nisto sabereis que Javé me enviou para fazer todas estas obras; pois não são de minha própria mente. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Se estes homens morrerem a morte comum de todos os homens, ou se experimentarem o que todos os homens experimentam, então Iavé não me enviou. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Mas se Javé faz uma coisa nova, e o chão abre sua boca, e os engole com tudo o que lhes pertence, e eles descem vivos no Sheol, então vocês entenderão que estes homens desprezaram Javé”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ao terminar de dizer todas estas palavras, o chão que estava sob elas se dividiu. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","A terra abriu sua boca e os engoliu com suas casas, todos os homens de Corá e todos os seus bens. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Então eles, e tudo o que lhes pertencia, caíram vivos no Sheol. A terra se fechou sobre eles, e pereceram entre a assembléia. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Todo Israel que estava ao seu redor fugiu ao seu grito; pois disseram: “Que a terra não nos engula”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","O fogo saiu de Javé, e devorou os duzentos e cinqüenta homens que ofereceram o incenso. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Fale a Eleazar, filho de Aarão, o sacerdote, que tire os censores da fogueira, e espalhe o fogo para longe do campo; pois eles são santos, ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","even os censores daqueles que pecaram contra suas próprias vidas. Que sejam espancados em pratos para uma cobertura do altar, pois eles os ofereceram diante de Javé. Portanto, eles são santos. Eles serão um sinal para os filhos de Israel”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Eleazar o padre levou os censores de bronze que aqueles que foram queimados tinham oferecido; e eles os espancaram para uma cobertura do altar, ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","to ser um memorial aos filhos de Israel, para que nenhum estranho que não seja da descendência de Aarão, se aproximasse para queimar incenso diante de Javé, para que ele não fosse como Corá e como sua companhia; como Javé lhe falou por Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","But no dia seguinte toda a congregação das crianças de Israel reclamou contra Moisés e contra Arão, dizendo: “Vocês mataram o povo de Yahweh! ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","When a congregação foi reunida contra Moisés e contra Aaron, eles olharam para a Tenda da Reunião. Eis que a nuvem a cobriu e a glória de Yahweh apareceu. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moses e Aarão veio para a frente da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Afaste-se do meio desta congregação, para que eu possa consumi-los em um momento”. Eles caíram de cara. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moses disse a Aaron: “Pegue seu incensário, ponha fogo no altar, coloque incenso nele, leve-o rapidamente à congregação e faça expiação por eles; pois a ira saiu de Javé! A praga já começou”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aaron fez como Moisés disse, e correu para o meio da assembléia. A peste já havia começado entre o povo. Ele pôs o incenso, e fez expiação pelo povo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","He ficou entre os mortos e os vivos; e a peste ficou. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Now os que morreram pela peste eram quatorze mil e setecentos, além dos que morreram por causa da questão de Corá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Aaron voltou para Moisés à porta da Tenda da Reunião, e a peste foi detida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Fale com os filhos de Israel, e tire deles, um para cada casa dos pais, de todos os seus príncipes de acordo com as casas dos pais, doze varas. Escreva o nome de cada homem em sua vara. ");
INSERT INTO porbrbsl_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Você deve escrever o nome de Arão no bastão de Levi. Haverá uma vara para cada cabeça da casa de seus pais. ");
INSERT INTO porbrbsl_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Você os colocará na Tenda de Reunião antes do convênio, onde eu me encontrarei com você. ");
INSERT INTO porbrbsl_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Acontecerá que a vara do homem que escolherei brotará. Farei cessar de mim as murmurações dos filhos de Israel, que eles murmuram contra vós”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moisés falou aos filhos de Israel; e todos os seus príncipes lhe deram varas, para cada príncipe uma, segundo as casas de seus pais, um total de doze varas. A vara de Arão estava entre suas varas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moisés colocou as varas antes de Yahweh na Tenda do Testemunho. ");
INSERT INTO porbrbsl_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","No dia seguinte, Moisés entrou na Tenda do Testemunho; e eis que a vara de Arão para a casa de Levi havia brotado, brotado, produzido flores, e amêndoas maduras. ");
INSERT INTO porbrbsl_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moisés trouxe todas as varas de antes de Yahweh para todos os filhos de Israel. Eles olharam, e cada homem pegou sua vara. ");
INSERT INTO porbrbsl_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Yahweh disse a Moisés: “Ponha de volta a vara de Aarão antes do pacto, para ser guardada como um sinal contra os filhos da rebelião; para que você possa pôr um fim às suas queixas contra mim, para que eles não morram”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moisés o fez. Como Yahweh lhe ordenou, assim o fez. ");
INSERT INTO porbrbsl_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Os filhos de Israel falaram a Moisés, dizendo: “Eis que perecemos! Estamos desfeitos! Todos nós estamos desfeitos! ");
INSERT INTO porbrbsl_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Everyone que continua se aproximando do tabernáculo de Yahweh, morre! Todos nós pereceremos”? ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yahweh disse a Arão: “Você e seus filhos e a casa de seus pais convosco carregarão a iniqüidade do santuário; e você e seus filhos convosco carregarão a iniqüidade de seu sacerdócio”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Traga também seus irmãos, a tribo de Levi, a tribo de seu pai, perto de você, para que se unam a você, e ministrem a você; mas você e seus filhos com você estarão diante da Tenda do Testemunho. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Eles manterão suas ordens e o dever de toda a Tenda; somente não se aproximarão dos vasos do santuário e do altar, para que não morram, nem eles nem você. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Eles serão unidos a você e manterão a responsabilidade da Tenda de Reunião, por todo o serviço da Tenda. Um desconhecido não se aproximará de você. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Você cumprirá o dever do santuário e o dever do altar, de que não haja mais ira sobre os filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","“Eis que eu mesmo tomei seus irmãos os levitas dentre os filhos de Israel. Eles são um presente para vocês, dedicados a Iavé, para fazer o serviço da Tenda de Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Vós e vossos filhos convosco guardareis vosso sacerdócio para tudo do altar, e para isso dentro do véu. Vocês servirão. Eu lhe dou o serviço do sacerdócio como um presente. O estrangeiro que se aproximar será morto”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Yahweh falou a Arão: “Eis que eu mesmo vos dei o comando de minhas ofertas de ondas, mesmo todas as coisas santas dos filhos de Israel. Eu as dei a vocês por causa da unção, e a seus filhos, como uma porção para sempre”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Isto será vosso das coisas santíssimas do fogo: toda oferta deles, mesmo toda oferta de refeição deles, e toda oferta pelo pecado deles, e toda oferta pela culpa deles, que eles me farão, será santíssima para vós e para vossos filhos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Comereis dela como das coisas santíssimas. Todo macho comerá dela. Será santo para vós. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Isto também é seu: a oferta ondulatória deles, até mesmo todas as ofertas ondulatórias das crianças de Israel. Eu as dei a vocês, a seus filhos e a suas filhas com vocês, como uma porção para sempre. Todos os que estiverem limpos em sua casa comerão dela. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Eu lhes dei o melhor do azeite, o melhor da safra e do grão, os primeiros frutos que eles dão a Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Os primeiros frutos maduros de tudo o que está em suas terras, que eles trazem a Iavé, serão seus. Todos os que estiverem limpos em sua casa comerão dela. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Tudo o que for dedicado em Israel será seu. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Tudo o que abre o ventre, de toda a carne que eles oferecem a Javé, tanto do homem como do animal, será seu. Entretanto, certamente resgatarás o primogênito do homem e resgatarás o primogênito dos animais imundos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","You resgatará aqueles que devem ser resgatados a partir de um mês, segundo sua estimativa, por cinco siclos de dinheiro, segundo o siclo do santuário, que pesa vinte gerahs. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Mas você não deve resgatar o primogênito de uma vaca, ou o primogênito de uma ovelha, ou o primogênito de uma cabra. Eles são sagrados. Polvilharão seu sangue sobre o altar, e queimarão sua gordura por uma oferta feita pelo fogo, por um aroma agradável a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","A carne deles será sua, como o peito da oferta ondulante e como a coxa direita, será sua. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Todas as ofertas de ondas das coisas sagradas que os filhos de Israel oferecem a Iavé, eu dei a você e a seus filhos e suas filhas com você, como uma porção para sempre. É um pacto de sal para sempre diante de Iavé para você e para seus descendentes com você”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Yahweh disse a Aaron: “Você não terá herança em suas terras, nem terá nenhuma porção entre eles”. Eu sou sua porção e sua herança entre os filhos de Israel”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Aos filhos de Levi, eis que eu dei todo o dízimo em Israel por uma herança, em troca do serviço que eles servem, até mesmo o serviço da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Henceforth os filhos de Israel não se aproximarão da Tenda da Reunião, para que não sofram pecado e morram. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Mas os levitas prestarão o serviço da Tenda da Reunião, e suportarão sua iniqüidade. Será um estatuto para sempre através de suas gerações. Entre os filhos de Israel, eles não terão herança. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Para o dízimo dos filhos de Israel, que eles oferecem como uma oferta de onda a Javé, eu dei aos Levitas por uma herança. Por isso lhes disse: 'Entre os filhos de Israel não terão herança'”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“ Além disso, você falará aos levitas, e lhes dirá: “Quando você tomar dos filhos de Israel o dízimo que eu lhes dei por sua herança, então você oferecerá uma oferta de onda dele para Yahweh, um dízimo do dízimo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Sua oferta de onda será creditada a você, como se fosse o grão da eira, e como a plenitude do lagar do vinho. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Assim, você também oferecerá a Javé uma oferta de ondas de todos os seus dízimos, que você recebe dos filhos de Israel; e dela dará a oferta de ondas de Javé a Arão, o sacerdote. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","De todos os seus dons, você oferecerá cada oferta de onda a Iavé, de todas as suas melhores partes, até mesmo a parte santa”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Portanto, você lhes dirá: “Quando você der o seu melhor, então será creditado aos Levites como o aumento da eira e como o aumento do lagar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Você pode comê-lo em qualquer lugar, você e sua casa, pois é sua recompensa em troca de seu serviço na Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Você não deve suportar nenhum pecado em razão disso, quando tiver tirado o melhor proveito disso. Não profanareis as coisas santas dos filhos de Israel, para que não morrais”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Yahweh falou com Moisés e com Arão, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Este é o estatuto da lei que Yahweh ordenou. Diga aos filhos de Israel que lhe tragam uma novilha vermelha sem mancha, na qual não há defeito, e que nunca foi jungida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Você a entregará a Eleazar, o sacerdote, e ele a trará para fora do acampamento, e alguém a matará diante de sua face. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleazar, o sacerdote, tomará um pouco do sangue dela com o dedo, e aspergirá o sangue dela em direção à frente da Tenda da Reunião sete vezes. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","A novilha será queimada à sua vista; sua pele, e sua carne, e seu sangue, com seu esterco, será queimado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","O padre pegará madeira de cedro, hissopo e escarlate e atirá-la-á no meio da queima da novilha. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Então o sacerdote lavará suas vestes, e banhará sua carne em água, e depois entrará no acampamento, e o sacerdote ficará imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Aquele que a queimar lavará suas vestes em água, e banhará sua carne em água, e será imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Um homem limpo recolherá as cinzas da novilha e as depositará fora do acampamento em um lugar limpo; e será guardado para a congregação das crianças de Israel para uso na água para limpeza de impurezas. É uma oferta pelo pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Aquele que recolher as cinzas da novilha lavará suas roupas, e ficará imundo até a noite. Será para os filhos de Israel, e para o estrangeiro que vive como um estrangeiro entre eles, por um estatuto para sempre. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Aquele que tocar o cadáver de qualquer homem será imundo por sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ele se purificará com água no terceiro dia, e no sétimo dia estará limpo; mas se não se purificar no terceiro dia, então no sétimo dia não estará limpo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Quem tocar um morto, o corpo de um homem que morreu, e não se purificar, profanará o tabernáculo de Javé; e essa alma será cortada de Israel; porque a água para a impureza não foi aspergida sobre ele, ele será imundo. Sua impureza ainda está sobre ele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Esta é a lei quando um homem morre em uma tenda: todos que entram na tenda, e todos que estão na tenda, devem estar imundos sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Todo recipiente aberto, que não tem cobertura presa, é imundo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Quem no campo aberto tocar alguém que for morto com uma espada, ou um cadáver, ou um osso de um homem, ou uma sepultura, será imundo sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Para os impuros, eles devem tomar das cinzas da queima da oferta pelo pecado; e água corrente deve ser derramada sobre eles em um recipiente. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Uma pessoa limpa pegará o hissopo, mergulhá-lo-á na água e aspergi-lo-á sobre a tenda, sobre todos os vasos, sobre as pessoas que lá estavam e sobre aquele que tocou o osso, ou o morto, ou o morto, ou a sepultura. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","A pessoa limpa deve aspergir sobre o impuro no terceiro dia, e no sétimo dia. No sétimo dia, ele o purificará. Ele lavará suas roupas e se banhará em água, e será limpo à noite. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Mas o homem que for imundo, e não se purificar, essa alma será extirpada do meio da assembléia, porque contaminou o santuário de Iavé. A água para a impureza não foi aspergida sobre ele. Ele é impuro. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Será um estatuto perpétuo para eles. Aquele que asperge a água para a impureza lavará suas roupas, e aquele que toca a água para a impureza será imundo até a noite. ");
INSERT INTO porbrbsl_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","“O que a pessoa imunda tocar será imundo; e a alma que tocar será imunda até a noite”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","As crianças de Israel, mesmo toda a congregação, entraram no deserto de Zin no primeiro mês. O povo permaneceu em Kadesh. Miriam morreu lá, e foi enterrada lá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Não havia água para a congregação; e eles se reuniram contra Moisés e contra Aarão. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","O povo discutiu com Moisés e falou, dizendo: “Gostaríamos de ter morrido quando nossos irmãos morreram antes de Yahweh! ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Por que vocês trouxeram a assembléia de Iavé para este deserto, para que morrêssemos lá, nós e nossos animais? ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Por que vocês nos fizeram subir do Egito, para nos trazer para este lugar maligno? Não é lugar de semente, nem de figos, nem de figos, nem de videiras, nem de romãs; também não há água para beber”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moisés e Aaron passaram da presença da assembléia para a porta da Tenda da Reunião, e caíram de cara. A glória de Yahweh apareceu para eles. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Pegue a vara, e reúna a congregação, você e Aarão, seu irmão, e fale com a pedra diante dos olhos deles, para que ela derrame sua água. Tirarás água da rocha para eles; assim darás de beber à congregação e ao gado deles”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moisés tomou a vara de antes de Yahweh, como ele lhe ordenou. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Moisés e Arão reuniram a assembléia diante da rocha, e ele lhes disse: “Ouçam agora, rebeldes! Devemos tirar água desta rocha para vocês”? ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moisés levantou a mão e bateu duas vezes na rocha com sua vara, e a água saiu abundantemente. A congregação e seu gado beberam. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Yahweh disse a Moisés e Aarão: “Porque não acreditastes em mim, para me santificardes aos olhos dos filhos de Israel, portanto não introduzireis esta assembléia na terra que eu lhes dei”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Estas são as águas do Meribah; porque as crianças de Israel lutaram com Yahweh, e ele foi santificado nelas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moisés enviou mensageiros de Kadesh para o rei de Edom, dizendo: “Seu irmão Israel diz: Você conhece todo o trabalho que nos aconteceu; ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","how nossos pais desceram ao Egito, e nós vivemos no Egito por muito tempo. Os egípcios maltrataram a nós e a nossos pais. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Quando choramos a Javé, ele ouviu nossa voz, enviou um anjo e nos tirou do Egito. Eis que estamos em Kadesh, uma cidade à beira de sua fronteira. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","“Por favor, deixe-nos passar por sua terra. Não passaremos pelo campo ou pela vinha, nem beberemos da água dos poços. Iremos pela rodovia do rei. Não nos desviaremos para a direita nem para a esquerda, até que tenhamos passado sua fronteira”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edom disse-lhe: “Você não passará por mim, para que eu não saia com a espada contra você”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","As crianças de Israel lhe disseram: “Subiremos pela estrada; e se bebermos sua água, eu e meu gado, então eu darei seu preço. Só me deixe, sem fazer mais nada, passar de pé”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ele disse: “Você não deve passar”. Edom saiu contra ele com muita gente, e com uma mão forte. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Thus Edom se recusou a dar passagem a Israel através de sua fronteira, então Israel se afastou dele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Eles viajaram de Cades, e as crianças de Israel, até mesmo toda a congregação, vieram ao Monte Hor. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Javé falou com Moisés e Aarão no Monte Hor, junto à fronteira da terra de Edom, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aarão será reunido ao seu povo, pois não entrará na terra que dei aos filhos de Israel, porque se rebelaram contra a minha palavra nas águas do Meribá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Leve Aarão e Eleazar, seu filho, e leve-os ao Monte Hor; ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","e despoje Aarão de suas vestes, e coloque-os sobre Eleazar, seu filho. Arão será recolhido, e morrerá ali”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moisés fez como ordenou Yahweh. Eles subiram ao Monte Hor, à vista de toda a congregação. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moisés despiu Arão de suas vestes, e as colocou sobre Eleazar, seu filho. Aarão morreu lá no topo da montanha, e Moisés e Eleazar desceram da montanha. ");
INSERT INTO porbrbsl_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Quando toda a congregação viu que Aarão estava morto, eles choraram por Aarão trinta dias, até mesmo por toda a casa de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","O cananeu, o rei de Arad, que vivia no Sul, ouviu dizer que Israel veio pelo caminho de Atharim. Ele lutou contra Israel, e levou alguns deles cativos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Israel fez um voto a Iavé, e disse: “Se vocês realmente entregarem este povo em minhas mãos, então eu destruirei completamente suas cidades”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Javé ouviu a voz de Israel, e entregou os cananeus; e eles os destruíram totalmente e suas cidades. O nome do lugar foi chamado Hormah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Eles viajaram do Monte Hor a caminho do Mar Vermelho, para contornar a terra de Edom. A alma do povo estava muito desanimada por causa da viagem. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","O povo falou contra Deus e contra Moisés: “Por que vocês nos trouxeram do Egito para morrer no deserto? Porque não há pão, não há água, e nossa alma odeia este alimento nojento”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Yahweh enviou cobras venenosas entre o povo, e elas morderam o povo. Muitas pessoas de Israel morreram. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","O povo veio a Moisés e disse: “Nós pecamos, porque falamos contra Javé e contra você. Reze a Javé, para que ele nos tire as serpentes”. Moisés rezou pelo povo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Yahweh disse a Moisés: “Faça uma cobra venenosa e coloque-a em um poste”. Acontecerá que todo aquele que for mordido, quando o vir, viverá”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moisés fez uma serpente de bronze, e a colocou sobre o poste. Se uma serpente tivesse mordido qualquer homem, quando olhou para a serpente de bronze, ele viveu. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","As crianças de Israel viajaram, e acamparam em Oboth. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Viajaram de Oboth, e acamparam no Iyeabarim, no deserto que está antes de Moab, em direção ao nascer do sol. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","De lá viajaram, e acamparam no vale de Zered. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","De lá viajaram, e acamparam do outro lado do Arnon, que fica no deserto que sai da fronteira dos Amoritas; pois o Arnon é a fronteira de Moab, entre Moab e os Amoritas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Portanto é dito no Livro das Guerras de Yahweh, “Vaheb em Suphah, os vales do Arnon, ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","a encosta dos vales que se inclinam para a morada de Ar, inclina-se na fronteira de Moab”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","De lá viajaram para Cerveja; esse é o poço do qual Javé disse a Moisés: “Reúna o povo e eu lhe darei água”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Depois Israel cantou esta canção: “Mola para cima, bem! Cantem para ela, ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","o poço, que os príncipes cavaram, que os nobres do povo cavaram, com o ceptro, e com seus pólos”. Do deserto eles viajaram para Mattanah; ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","and de Mattanah para Nahaliel; e de Nahaliel para Bamoth; ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","e de Bamoth para o vale que está no campo de Moab, para o topo do Pisgah, que olha para baixo no deserto. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israel enviou mensageiros a Sihon, rei dos Amoritas, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Deixe-me passar por sua terra”. Não nos transformaremos em campo ou vinhedo. Não beberemos da água dos poços. Passaremos pela rodovia do rei, até que tenhamos passado sua fronteira”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sihon não permitiria que Israel passasse por sua fronteira, mas Sihon reuniu todo o seu povo, e saiu contra Israel para o deserto, e veio para Jahaz. Ele lutou contra Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israel o atingiu com o fio da espada, e possuiu sua terra desde o Arnon até o Jabbok, até os filhos de Amon; pois a fronteira dos filhos de Amon foi fortificada. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israel tomou todas estas cidades. Israel viveu em todas as cidades dos Amoritas, em Heshbon, e em todas as suas aldeias. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Pois Heshbon era a cidade de Sihon, o rei dos amorreus, que havia lutado contra o antigo rei dos moabitas, e tirado todas as suas terras de suas mãos, até mesmo para o Arnon. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Portanto, dizem aqueles que falam em provérbios, “Venha para Heshbon. Deixe a cidade de Sihon ser construída e estabelecida; ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","para um incêndio saiu de Heshbon, uma chama da cidade de Sihon. Ele devorou Ar de Moab, Os senhores dos lugares altos do Arnon. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ai de você, Moab! Vocês estão desfeitos, povo de Chemosh! Ele deu seus filhos como fugitivos, e suas filhas em cativeiro, a Sihon, rei dos Amoritas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Nós atiramos neles. Heshbon pereceu até mesmo para a Dibon. Desperdiçamos até mesmo para Nophah, Que chega até Medeba”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Thus Israel vivia na terra dos Amoritas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moisés enviou para espionar Jazer. Eles tomaram suas aldeias e expulsaram os amorreus que lá estavam. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Eles apareceram e subiram pelo caminho de Bashan. Og, o rei de Basã, saiu contra eles, ele e todo seu povo, para lutar em Edrei. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Yahweh disse a Moisés: “Não o temais, pois eu o entreguei em vossas mãos, com todo seu povo e sua terra. Far-lhe-eis como fizestes a Sihon, rei dos amorreus, que viveu em Heshbon”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Então eles o atingiram, com seus filhos e todo seu povo, até que não houve sobreviventes; e eles possuíam sua terra. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","As crianças de Israel viajaram e acamparam nas planícies de Moab, além do Jordão, em Jericó. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak, o filho de Zippor, viu tudo o que Israel tinha feito aos Amoritas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moab tinha muito medo do povo, porque eles eram muitos. Moab estava angustiado por causa dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moab disse aos anciãos de Midian: “Agora esta multidão lamberá tudo o que está ao nosso redor, pois o boi lambe a erva do campo”. Balak, o filho de Zippor, era o rei dos Moab naquela época. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ele enviou mensageiros a Balaão, filho de Beor, a Pethor, que está junto ao rio, à terra dos filhos de seu povo, para chamá-lo, dizendo: “Eis que há um povo que saiu do Egito. Eis que eles cobrem a superfície da terra, e ficam em frente a mim”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Por favor, venha agora e amaldiçoe este povo para mim, pois eles são poderosos demais para mim”. Talvez eu prevaleça, para que possamos golpeá-los e expulsá-los da terra; pois sei que aquele a quem vós abençoais é abençoado, e aquele a quem vós amaldiçoais é amaldiçoado”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Os anciãos de Moab e os anciãos de Midian partiram com as recompensas da adivinhação em suas mãos. Eles vieram a Balaão e falaram com ele as palavras de Balak. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ele disse a eles: “Fiquem aqui esta noite, e eu lhes trarei notícias novamente, pois Yahweh falará comigo”. Os príncipes de Moab ficaram com Balaam. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Deus veio a Balaão e disse: “Quem são estes homens com você?”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaão disse a Deus: “Balak, filho de Zippor, rei dos Moab, disse-me: ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","'Eis que o povo que saiu do Egito cobre a superfície da terra. Agora, venha amaldiçoá-los por mim. Talvez eu seja capaz de lutar contra eles, e os expulse”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Deus disse a Balaam: “Não ireis com eles. Não amaldiçoareis o povo, pois eles são abençoados”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaam levantou-se pela manhã e disse aos príncipes de Balak: “Vá para sua terra; pois Javé se recusa a permitir que eu vá com você”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Os príncipes de Moab se levantaram, foram a Balak e disseram: “Balaam se recusa a vir conosco”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak enviou novamente príncipes, mais e mais honrados do que eles. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Eles vieram a Balaão, e lhe disseram: “Balak, o filho de Zippor, diz: 'Por favor, nada o impeça de vir até mim, ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","pois eu o promoverei a uma grande honra, e o que quer que me diga, eu farei”. Por favor, venha portanto, e amaldiçoe este povo por mim”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam respondeu aos servos de Balak: “Se Balak me desse sua casa cheia de prata e ouro, não poderia ir além da palavra de Javé meu Deus, para fazer menos ou mais”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Agora, portanto, por favor, fique aqui também esta noite, para que eu possa saber o que mais Yahweh falará comigo”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Deus veio a Balaão à noite, e lhe disse: “Se os homens vieram para chamá-lo, levante-se, vá com eles; mas somente a palavra que eu lhe falo, que você fará”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam levantou-se pela manhã, selou seu burro e foi com os príncipes de Moab. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","A raiva de Deus queimou porque ele foi; e o anjo de Javé se colocou no caminho como um adversário contra ele. Agora ele estava montado em seu burro, e seus dois servos estavam com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","O burro viu o anjo de Javé parado no caminho, com sua espada desembainhada na mão; e o burro saiu do caminho, e foi para o campo. Balaam bateu no burro, para transformá-lo no caminho. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Então o anjo de Yahweh ficou em um caminho estreito entre as vinhas, com uma parede deste lado, e uma parede deste lado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","O burro viu o anjo de Yahweh, empurrou-se para a parede e esmagou o pé de Balaão contra a parede. Ele bateu nela novamente. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","O anjo de Yahweh foi mais longe, e ficou em um lugar estreito, onde não havia como virar nem para a direita nem para a esquerda. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","O burro viu o anjo de Yahweh, e deitou-se sob Balaam. A raiva de Balaam queimou, e ele bateu no burro com seu cajado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Yahweh abriu a boca do burro e disse a Balaam: “O que eu fiz com você, que você me bateu três vezes”? ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam disse ao burro: “Porque você zombou de mim, eu gostaria que houvesse uma espada na minha mão, por enquanto eu teria te matado”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","O burro disse a Balaam: “Eu não sou seu burro, no qual você cavalgou por toda a sua vida até hoje? Eu já tive o hábito de fazer isso com você”? Ele disse: “Não”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Então Javé abriu os olhos de Balaão, e viu o anjo de Javé de pé no caminho, com a espada desembainhada na mão; e abaixou a cabeça e caiu de cara. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","O anjo de Yahweh disse-lhe: “Por que você bateu no seu burro estas três vezes? Eis que eu saí como um adversário, porque seu caminho é perverso diante de mim. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","O burro me viu, e virou as costas diante de mim estas três vezes. A menos que ela tivesse se afastado de mim, certamente agora eu teria matado você e a salvado viva”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam disse ao anjo de Yahweh: “Eu pequei, pois não sabia que você estava no caminho contra mim”. Agora, portanto, se isso te desagradar, eu voltarei novamente”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","O anjo de Yahweh disse a Balaam: “Vá com os homens; mas você só dirá a palavra que eu lhe falarei”. Então, Balaam foi com os príncipes de Balak. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Quando Balak soube que Balaam tinha chegado, foi ao seu encontro na cidade de Moab, que fica na fronteira do Arnon, que fica na parte mais alta da fronteira. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak disse a Balaam: “Eu não mandei chamá-lo com sinceridade? Por que você não veio até mim? Não sou realmente capaz de promovê-lo para honrá-lo?” ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam disse a Balak: “Eis que eu vim até você”. Tenho agora algum poder para falar alguma coisa? Falarei a palavra que Deus coloca em minha boca”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaam foi com Balak, e eles vieram para Kiriath Huzoth. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak sacrificou gado e ovelhas, e enviou para Balaam, e para os príncipes que estavam com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Pela manhã, Balak levou Balaam, e o levou aos lugares altos de Baal; e ele viu de lá parte do povo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam disse a Balak, “Construa aqui sete altares para mim, e prepare aqui sete touros e sete carneiros para mim”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak fez como Balaam tinha falado; e Balak e Balaam ofereceram em cada altar um touro e um carneiro. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam disse a Balak: “Fique de pé com sua oferta queimada, e eu irei”. Talvez Yahweh venha ao meu encontro”. O que quer que ele me mostre, eu lhe direi”. Ele foi a uma altura nua. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Deus encontrou Balaão e lhe disse: “Preparei os sete altares e ofereci um touro e um carneiro em cada altar”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Yahweh pôs uma palavra na boca de Balaam, e disse: “Volte para Balak, e assim você falará”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ele voltou para ele, e eis que estava junto a seu holocausto, ele e todos os príncipes dos moabitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ele retomou sua parábola, e disse, “De Aram, Balak me trouxe”, o rei dos Moab das montanhas do Leste. Venha, amaldiçoe Jacob por mim. Venha, desafie Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Como devo amaldiçoar quem Deus não amaldiçoou? Como devo desafiar quem Javé não desafiou? ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Pois do alto das rochas eu o vejo. Das colinas, eu o vejo. Eis que é um povo que mora sozinho, e não devem ser listadas entre as nações. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Quem pode contar o pó de Jacob, ou contar a quarta parte de Israel? Deixe-me morrer a morte dos justos! Que meu último fim seja como o dele”! ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak disse a Balaam: “O que você fez comigo? Eu o levei para amaldiçoar meus inimigos, e eis que você os abençoou completamente”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ele respondeu e disse: “Não devo ter cuidado para falar aquilo que Iavé põe na minha boca?”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak disse-lhe: “Por favor, venha comigo para outro lugar, onde você possa vê-los”. Você verá apenas uma parte deles e não os verá todos”. Amaldiçoe-os de lá por mim”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ele o levou para o campo de Zophim, ao topo de Pisgah, e construiu sete altares, e ofereceu um touro e um carneiro em cada altar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Ele disse a Balak: “Fique aqui ao lado de sua oferta queimada, enquanto eu encontro Deus ali”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Yahweh encontrou Balaam, e colocou uma palavra em sua boca, e disse: “Volte para Balak, e diga isto”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ele veio até ele, e eis que ele estava junto a seu holocausto, e os príncipes dos Moab com ele. Balak lhe disse: “O que Javé falou?”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ele retomou sua parábola, e disse, “Levanta-te, Balak, e ouve! Ouça-me, seu filho de Zippor. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Deus não é um homem, que ele deve mentir, nem um filho do homem, que deveria se arrepender. Ele já disse, e não o fará? Ou ele já falou e não vai fazer com que seja bom? ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Eis que recebi uma ordem para abençoar. Ele abençoou, e eu não posso reverter isso. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ele não viu iniqüidade em Jacob. Nem ele viu perversidade em Israel. Yahweh, seu Deus, está com ele. O grito de um rei está entre eles. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Deus os traz para fora do Egito. Ele tem como que a força do boi selvagem. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Certamente não há nenhum encantamento com Jacob; também não há nenhuma adivinhação com Israel. Agora se falará de Jacó e de Israel, O que Deus tem feito! ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Eis que um povo se levanta como uma leoa. Como um leão, ele se levanta. Ele não deve deitar-se até que coma a presa, e bebe o sangue dos mortos”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balak disse a Balaam: “Nem os amaldiçoe, nem os abençoe”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Mas Balaam respondeu a Balak: “Eu não te disse, dizendo: 'Tudo o que Yahweh fala, que eu devo fazer? ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak disse a Balaam: “Venha agora, eu o levarei a outro lugar; talvez agrade a Deus que você possa amaldiçoá-los por mim de lá”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak levou Balaam para o topo de Peor, que olha para baixo no deserto. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam disse a Balak: “Construa sete altares para mim aqui, e prepare sete touros e sete carneiros para mim aqui”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak fez como Balaam havia dito, e ofereceu um touro e um carneiro em cada altar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Quando Balaam viu que agradou a Iavé abençoar Israel, ele não foi, como nas outras vezes, para usar a adivinhação, mas colocou seu rosto em direção ao deserto. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaão levantou os olhos e viu Israel habitando de acordo com suas tribos; e o Espírito de Deus veio sobre ele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Ele retomou sua parábola, e disse, “Balaam, o filho de Beor, diz, diz o homem cujos olhos estão abertos; ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","diz ele, quem ouve as palavras de Deus, que vê a visão do Todo-Poderoso, caindo, e com os olhos abertos: ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Como são boas suas tendas, Jacob, e suas moradias, Israel! ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Como vales, eles estão espalhados, como jardins à beira do rio, como aloés que Yahweh plantou, como cedros ao lado das águas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","A água deve fluir de seus baldes. Sua semente deve estar em muitas águas. Seu rei deve ser mais alto que Agag. Seu reino será exaltado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Deus o traz para fora do Egito. Ele tem como que a força do boi selvagem. Ele consumirá as nações que lhe são adversárias, devem quebrar seus ossos em pedaços, e os fura com suas setas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ele deitou-se, deitou-se como um leão, como uma leoa; quem o despertará? Todos que o abençoam são abençoados. Todo aquele que te amaldiçoa é amaldiçoado”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","A raiva de Balak queimou contra Balaam, e ele bateu com as mãos juntas. Balak disse a Balaam: “Eu os chamei para amaldiçoar meus inimigos e, eis que vocês os abençoaram completamente estas três vezes. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Portanto, fuja para o seu lugar, agora! Pensei em promovê-lo com grande honra; mas, eis que Yahweh o impediu de honrá-lo”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam disse a Balak: “Eu também não disse a seus mensageiros que você me enviou, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","'Se Balak me desse sua casa cheia de prata e ouro, eu não poderia ir além da palavra de Iavé, para fazer o bem ou o mal da minha própria mente. Eu direi o que Javé diz”? ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Agora, eis que eu vou para o meu povo. Vinde, eu vos informarei o que este povo fará ao vosso povo nos últimos dias”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ele retomou sua parábola, e disse, “Balaam, o filho de Beor, diz, diz o homem cujos olhos estão abertos; ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ele diz, quem ouve as palavras de Deus, conhece o conhecimento do Altíssimo, e quem vê a visão do Todo-Poderoso, caindo, e com os olhos abertos: ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Eu o vejo, mas não agora. Eu o vejo, mas não perto. Uma estrela sairá de Jacob. Um cetro se levantará de Israel, e deve atacar pelos cantos de Moab, e esmagar todos os filhos de Sheth. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom deve ser uma posse. Seir, seu inimigo, também será uma possessão, enquanto Israel faz valentemente. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","De Jacob, um deve ter domínio, e destruirá o remanescente da cidade”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ele olhou para Amalek, e retomou sua parábola, e disse, “Amalek foi a primeira das nações, mas seu último fim chegará à destruição”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ele olhou para o Kenita, e retomou sua parábola, e disse “Seu lugar de residência é forte. Seu ninho está colocado na rocha. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","No entanto, Kain deve ser desperdiçado, até Asshur te levar em cativeiro”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ele retomou sua parábola, e disse, “Ai de mim, quem viverá quando Deus fizer isso? ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Mas os navios devem vir da costa do Kittim. Eles afligirão Asshur, e afligirão Eber. Ele também deve chegar à destruição”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balaam levantou-se, foi e voltou para sua casa; e Balak também seguiu seu caminho. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israel ficou em Shittim; e o povo começou a brincar de prostituta com as filhas de Moab; ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","pois elas chamaram o povo para os sacrifícios de seus deuses. O povo comeu e se curvou diante de seus deuses. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Israel se uniu a Baal Peor, e a raiva de Javé ardeu contra Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Javé disse a Moisés: “Pegue todos os chefes do povo e pendure-os diante de Javé diante do sol, para que a raiva feroz de Javé se afaste de Israel”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moisés disse aos juízes de Israel: “Todos matam seus homens que se uniram a Baal Peor”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Eis que um dos filhos de Israel veio e trouxe a seus irmãos uma mulher midianita aos olhos de Moisés e de toda a congregação dos filhos de Israel, enquanto choravam à porta da Tenda da Reunião. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Quando Phinehas, o filho de Eleazar, o filho de Arão, o sacerdote, viu isso, levantou-se do meio da congregação e pegou uma lança em sua mão. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Ele foi atrás do homem de Israel até o pavilhão, e empurrou ambos, o homem de Israel, e a mulher através de seu corpo. Então a peste foi detida entre os filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Os que morreram pela peste eram vinte e quatro mil. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Phinehas, o filho de Eleazar, o filho de Arão, o sacerdote, afastou minha ira dos filhos de Israel, pois tinha ciúmes com meu ciúme entre eles, para que eu não consumisse os filhos de Israel em meu ciúme. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Por isso diz: “Eis que eu lhe dou meu pacto de paz”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Será para ele, e para seus descendentes depois dele, o pacto de um sacerdócio eterno, porque teve inveja de seu Deus, e fez expiação pelos filhos de Israel””. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Now o nome do homem de Israel que foi morto, que foi morto com a mulher midianita, era Zimri, o filho de Salu, príncipe da casa de um pai entre os simeonitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","O nome da mulher midianita que foi assassinada era Cozbi, a filha de Zur. Ele era o chefe do povo da casa de um pai em Midian. ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Ataquem os midianitas, e ataquem-nos; ");
INSERT INTO porbrbsl_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","pois eles o assediaram com suas artimanhas, em que o enganaram no caso de Peor, e no incidente relativo a Cozbi, a filha do príncipe de Midian, sua irmã, que foi assassinada no dia da praga no caso de Peor”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Após a peste, Javé falou a Moisés e a Eleazar, filho de Aarão, o sacerdote, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Façam um censo de toda a congregação dos filhos de Israel, a partir dos vinte anos de idade, junto às casas de seus pais, todos os que podem sair à guerra em Israel”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Moisés e Eleazar, o sacerdote, falaram com eles nas planícies de Moab, junto ao Jordão em Jericó, dizendo, ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Façam um censo, a partir de vinte anos, como Javé ordenou a Moisés e aos filhos de Israel”. Estes são aqueles que saíram da terra do Egito. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Reuben, o primogênito de Israel; os filhos de Reuben: de Hanoch, a família dos Hanochitas; de Pallu, a família dos Paluítas; ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","de Hezron, a família dos Hezronitas; de Carmi, a família dos Carmites. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Estas são as famílias dos Rubenitas; e as que foram contadas delas foram quarenta e três mil setecentos e trinta. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","O filho de Pallu: Eliab. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Os filhos de Eliab: Nemuel, Datã, e Abiram. Estes são aqueles Datã e Abirão que foram chamados pela congregação, que se rebelaram contra Moisés e contra Arão na companhia de Coré quando se rebelaram contra Yahweh; ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","e a terra abriu sua boca, e os engoliu junto com Coré quando aquela companhia morreu; na época o fogo devorou duzentos e cinqüenta homens, e eles se tornaram um sinal. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Notwithstanding, os filhos de Corá não morreram. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Os filhos de Simeão depois de suas famílias: de Nemuel, a família dos Nemuelitas; de Jamin, a família dos Jaminitas; de Jachin, a família dos Jachinitas; ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","de Zerah, a família dos Zerahitas; de Shaul, a família dos Shaulitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Estas são as famílias dos Simeonitas, vinte e dois mil e duzentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Os filhos de Gad depois de suas famílias: de Zephon, a família dos zefonitas; de Haggi, a família dos Haggitas; de Shuni, a família dos Shunitas; ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","de Ozni, a família dos Oznitas; de Eri, a família dos Erites; ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","de Arod, a família dos Aroditas; de Areli, a família dos Arelitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Estas são as famílias dos filhos de Gad de acordo com aqueles que foram contados deles, quarenta mil e quinhentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Os filhos de Judá: Er e Onan. Er e Onan morreram na terra de Canaã. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Os filhos de Judá depois de suas famílias foram: de Selá, a família dos Shelanitas; de Perez, a família dos Perezitas; de Zerah, a família dos Zerahitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Os filhos de Perez eram: de Hezron, a família dos Hezronitas; de Hamul, a família dos Hamulitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Estas são as famílias de Judá, segundo aqueles que foram contados deles, setenta e seis mil e quinhentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Os filhos de Issachar após suas famílias: de Tola, a família dos Tolaítas; de Puvah, a família dos Punitas; ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","de Jashub, a família dos Jashubitas; de Shimron, a família dos Shimronitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Estas são as famílias de Issachar de acordo com aqueles que foram contados deles, sessenta e quatro mil e trezentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Os filhos de Zebulom depois de suas famílias: de Sered, a família dos Sereditas; de Elon, a família dos Elonitas; de Jahleel, a família dos Jahleelitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Estas são as famílias dos zebulunitas de acordo com aqueles que foram contados deles, sessenta mil e quinhentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Os filhos de José, depois de suas famílias: Manasseh e Efraim. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Os filhos de Manassés: de Machir, a família dos Machirites; e Machir tornou-se o pai de Gilead; de Gilead, a família dos Gileaditas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Estes são os filhos de Gilead: de Iezer, a família dos Iezeritas; de Helek, a família dos Helekitas; ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","e Asriel, a família dos Asrielitas; e Shechem, a família dos Shechemites; ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","e Shemida, a família dos Shemidaitas; e Hepher, a família dos Hepheritas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelophehad, o filho de Hepher, não tinha filhos, mas filhas: e os nomes das filhas de Zelophehad eram Mahlah, Noé, Hoglah, Milcah, e Tirzah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Estas são as famílias de Manasseh. Os que foram contados deles eram cinqüenta e dois mil e setecentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Estes são os filhos de Efraim depois de suas famílias: de Shuthelah, a família dos Shuthelahitas; de Becher, a família dos Becheritas; de Tahan, a família dos Tahanitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Estes são os filhos de Shuthelah: de Eran, a família dos Eranitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Estas são as famílias dos filhos de Efraim, segundo aqueles que foram contados deles, trinta e dois mil e quinhentos. Estes são os filhos de José, depois de suas famílias. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Os filhos de Benjamim depois de suas famílias: de Bela, a família dos Belaítas; de Ashbel, a família dos Ashbelitas; de Ahiram, a família dos Ahiramitas; ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","de Shephupham, a família dos Shuphamitas; de Hupham, a família dos Huphamitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Os filhos de Bela eram Ard e Naaman: a família dos Arditas; e de Naaman, a família dos naamitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Estes são os filhos de Benjamin depois de suas famílias; e os que foram contados deles foram quarenta e cinco mil e seiscentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Estes são os filhos de Dan depois de suas famílias: de Shuham, a família dos Shuhamitas. Estas são as famílias de Dan, depois de suas famílias. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Todas as famílias dos Shuhamitas, segundo aqueles que foram contados deles, eram sessenta e quatro mil e quatrocentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Os filhos de Asher depois de suas famílias: de Imnah, a família dos imnitas; de Ishvi, a família dos Ishvitas; de Beriah, a família dos beritas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Dos filhos de Beriah: de Heber, a família dos Heberitas; de Malchiel, a família dos Malchielitas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","O nome da filha de Asher era Serah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Estas são as famílias dos filhos de Asher de acordo com aqueles que foram contados deles, cinqüenta e três mil e quatrocentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Os filhos de Naftali depois de suas famílias: de Jahzeel, a família dos Jahzeelitas; de Guni, a família dos Gunitas; ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","de Jezer, a família dos Jezeritas; de Shillem, a família dos Shillemites. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Estas são as famílias de Naftali de acordo com suas famílias; e aqueles que foram contados deles eram quarenta e cinco mil e quatrocentos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Estes são os que foram contados dos filhos de Israel, seiscentos e um mil e setecentos e trinta. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“A estes a terra será dividida para uma herança de acordo com o número de nomes”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","“Quanto mais você der mais herança, e quanto menos você der menos herança. A todos, de acordo com aqueles que foram contados dele, será dada sua herança. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Notwithstanding, a terra será dividida por sorteio. De acordo com os nomes das tribos de seus pais, eles herdarão. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","De acordo com o lote, sua herança será dividida entre os mais e os menos”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Estes são aqueles que foram contados dos Levitas depois de suas famílias: de Gershon, a família dos Gershonitas; de Kohath, a família dos Kohathitas; de Merari, a família dos Meraritas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Estas são as famílias dos Levi: a família dos Libnitas, a família dos Hebronitas, a família dos Mahlitas, a família dos Mushitas, e a família dos Korahitas. Kohath tornou-se o pai de Amram. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","O nome da esposa de Amram era Jochebed, a filha de Levi, que nasceu a Levi no Egito. Ela deu à luz a Amram Arão e Moisés, e Miriam, sua irmã. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Para Aaron nasceram Nadab e Abihu, Eleazar e Ithamar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab e Abihu morreram quando ofereceram fogo estranho antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Os que foram contados entre eles eram vinte e três mil, cada homem de um mês para cima; pois não foram contados entre os filhos de Israel, pois não houve herança dada a eles entre os filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Estes são os que foram contados por Moisés e Eleazar, o sacerdote, que contavam os filhos de Israel nas planícies de Moabe, junto ao Jordão, em Jericó. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Mas entre eles não havia um homem que fosse contado por Moisés e Arão, o sacerdote, que contava os filhos de Israel no deserto do Sinai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Pois Yahweh havia dito deles: “Certamente morrerão no deserto”. Não sobrou nenhum homem deles, exceto Calebe, filho de Jefoné, e Josué, filho de Freira. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Então as filhas de Zelophehad, o filho de Hepher, o filho de Gilead, o filho de Machir, o filho de Manasseh, das famílias de Manasseh, o filho de José, se aproximaram. Estes são os nomes de suas filhas: Mahlah, Noé, Hoglah, Milcah, e Tirzah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Eles se apresentaram diante de Moisés, diante de Eleazar, o sacerdote, e diante dos príncipes e de toda a congregação, na porta da Tenda da Reunião, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Nosso pai morreu no deserto. Ele não estava na companhia daqueles que se reuniram contra Javé na companhia de Corá, mas morreu em seu próprio pecado. Ele não tinha filhos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Por que o nome de nosso pai deveria ser tirado de sua família, porque ele não tinha filho? Dê-nos uma posse entre os irmãos de nosso pai”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moisés trouxe sua causa perante Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“As filhas de Zelophehad falam bem. Certamente lhes dará a posse de uma herança entre os irmãos de seu pai. Você fará com que a herança de seu pai passe para elas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Falareis aos filhos de Israel, dizendo: 'Se um homem morrer e não tiver filho, fareis passar a herança dele para sua filha'. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Se ele não tiver filha, então você dará sua herança a seus irmãos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Se ele não tiver irmãos, então você dará sua herança aos irmãos de seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Se seu pai não tiver irmãos, então você dará sua herança a seu parente que está ao seu lado de sua família, e ele a possuirá. Isto será um estatuto e uma ordenança para os filhos de Israel, como Javé ordenou a Moisés”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Yahweh disse a Moisés: “Suba a esta montanha de Abarim e veja a terra que eu dei aos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Quando tiverdes visto, também sereis reunidos ao vosso povo, como Arão, vosso irmão, foi reunido; ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","porque na contenda da congregação vos rebelastes contra minha palavra no deserto de Zin, para honrar-me como santo nas águas diante de seus olhos”. (Estas são as águas do Meribah de Kadesh, no deserto de Zin). ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moisés falou a Javé, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Que Javé, o Deus dos espíritos de toda a carne, nomeie um homem sobre a congregação, ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","que possa sair diante deles, e que possa entrar diante deles, e que possa conduzi-los para fora, e que possa trazê-los para dentro, para que a congregação de Javé não seja como ovelhas que não têm pastor”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Yahweh disse a Moisés: “Pegue Josué, o filho de Freira, um homem em quem está o Espírito, e ponha sua mão sobre ele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Coloque-o diante de Eleazar, o sacerdote, e diante de toda a congregação; e comissione-o à vista deles. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Você lhe dará autoridade, para que toda a congregação dos filhos de Israel possa obedecer. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ele se apresentará diante de Eleazar, o sacerdote, que o interrogará pelo julgamento do Urim perante Javé. À sua palavra sairão, e à sua palavra entrarão, tanto ele como todos os filhos de Israel com ele, mesmo toda a congregação”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moisés fez como Yahweh lhe ordenou. Ele tomou Josué, e o colocou diante de Eleazar, o sacerdote, e diante de toda a congregação. ");
INSERT INTO porbrbsl_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ele colocou suas mãos sobre ele e o encarregou, como Iavé falou por Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Yahweh falou a Moisés, dizendo, ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Comande as crianças de Israel, e diga-lhes, 'Veja que você apresenta minha oferta, minha comida para minhas ofertas feitas pelo fogo, como um aroma agradável para mim, em sua devida estação”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Você lhes dirá: 'Esta é a oferta feita pelo fogo que você oferecerá a Javé: cordeiros machos com um ano de idade sem defeito, dois dias por dia, para uma oferta queimada contínua. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Você oferecerá um cordeiro pela manhã e o outro à noite, ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","com um décimo de um efa de farinha fina para uma oferta de refeição, misturada com a quarta parte de um galho de óleo batido. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","É uma oferta queimada contínua que foi ordenada no Monte Sinai por um aroma agradável, uma oferta feita pelo fogo a Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Its a oferta de bebida será a quarta parte de um lombo para cada cordeiro. Você deve derramar uma oferta de bebida forte a Iavé no lugar santo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","O outro cordeiro que você oferecerá à noite. Como oferta de refeição da manhã, e como sua oferta de bebida, você a oferecerá, uma oferta feita pelo fogo, para um aroma agradável a Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“'No dia de sábado, você deve oferecer dois cordeiros machos por ano sem defeito, e dois décimos de uma efa de farinha fina para uma oferta de refeição misturada com óleo, e sua oferta de bebida: ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","this é a oferta queimada de cada Sábado, além da oferta queimada contínua e sua oferta de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“'No início de seus meses, você deve oferecer uma oferta queimada a Iavé: dois touros jovens, um carneiro, sete cordeiros machos por ano sem defeito, ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","e três décimos de uma efa de farinha fina para uma oferta de refeição misturada com óleo, para cada touro; e duas décimas de farinha fina para uma oferta de refeição misturada com óleo, para o carneiro; ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","e uma décima parte de farinha fina misturada com óleo para uma oferta de refeição para cada cordeiro, como uma oferta queimada de aroma agradável, uma oferta feita pelo fogo para Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Suas ofertas de bebida serão meio lombo de vinho para um touro, a terceira parte de um lombo para o carneiro e a quarta parte de um lombo para um cordeiro. Esta é a oferta queimada de cada mês ao longo dos meses do ano. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Também, um bode macho para oferta pelo pecado a Iavé será oferecido, além da oferta queimada contínua e sua oferta de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“'No primeiro mês, no décimo quarto dia do mês, é a Páscoa de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","No décimo quinto dia deste mês, será uma festa. O pão ázimo será comido durante sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","No primeiro dia será uma santa convocação. Você não fará nenhum trabalho regular, ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","mas oferecerá uma oferta feita pelo fogo, um holocausto a Javé: dois novilhos, um carneiro e sete cordeiros machos por ano de idade. Eles devem estar sem defeito, ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","com sua oferta de refeição, farinha fina misturada com óleo. Oferecerão três décimos para um touro e dois décimos para o carneiro. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Você oferecerá um décimo por cada cordeiro dos sete cordeiros; ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","e um bode macho por uma oferta pelo pecado, para fazer expiação por você. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Você os oferecerá além da oferta queimada da manhã, que é para uma oferta queimada contínua. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Desta forma, você oferecerá diariamente, durante sete dias, o alimento da oferta feita pelo fogo, de um aroma agradável a Iavé. Deve ser oferecido além do holocausto contínuo e sua oferta de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","No sétimo dia, você terá uma santa convocação. Você não deverá fazer nenhum trabalho regular. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“'Também no dia das primeiras frutas, quando você oferecer uma nova oferta de refeição a Iavé em sua festa de semanas, você terá uma santa convocação. Você não fará nenhum trabalho regular; ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","mas oferecerá um holocausto por um aroma agradável a Iavé: dois novilhos, um carneiro, sete cordeiros machos por ano; ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","e sua oferta de refeição, farinha fina misturada com óleo, três décimos para cada touro, dois décimos para o carneiro, ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","um décimo para cada cordeiro dos sete cordeiros; ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","e um bode macho, para fazer expiação por você. ");
INSERT INTO porbrbsl_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Além da oferta queimada contínua e sua oferta de refeição, você oferecerá a eles e suas ofertas de bebida. Veja que elas não apresentem defeitos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“'No sétimo mês, no primeiro dia do mês, você terá uma santa convocação; você não fará nenhum trabalho regular. É um dia de soar trombetas para você. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Você oferecerá um holocausto para um aroma agradável a Iavé: um touro jovem, um carneiro, sete cordeiros machos por ano sem defeito; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","e sua oferta de refeição, farinha fina misturada com óleo: três décimos para o touro, dois décimos para o carneiro, ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","e um décimo para cada cordeiro dos sete cordeiros; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","e um bode macho para uma oferta pelo pecado, para fazer expiação por você; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","além do holocausto da lua nova com sua oferta de refeição, e o holocausto contínuo com sua oferta de refeição, e suas ofertas de bebida, de acordo com sua ordenança, para um aroma agradável, uma oferta feita pelo fogo a Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“'No décimo dia deste sétimo mês, você terá uma santa convocação. Vocês afligirão suas almas. Não fareis nenhum tipo de trabalho; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","mas oferecereis uma oferta queimada a Javé por um aroma agradável: um touro jovem, um carneiro, sete cordeiros machos por ano, todos sem defeito; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","e sua oferta de refeição, farinha fina misturada com óleo: três décimos para o touro, dois décimos para o carneiro, ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","um décimo para cada cordeiro dos sete cordeiros; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","um bode macho para a oferta pelo pecado, além da oferta pelo pecado da expiação, e a oferta queimada contínua, e sua oferta de refeição, e suas ofertas de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“'No décimo quinto dia do sétimo mês, você terá uma santa convocação. Você não deverá fazer nenhum trabalho regular. Você manterá um banquete para Yahweh durante sete dias. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Você oferecerá um holocausto, uma oferta feita pelo fogo, de aroma agradável a Iavé: treze novilhos, dois carneiros, catorze cordeiros machos por ano, todos sem defeito; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","e sua oferta de refeição, farinha fina misturada com óleo: três décimos para cada touro dos treze touros, dois décimos para cada carneiro dos dois carneiros, ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","e um décimo para cada cordeiro dos catorze cordeiros; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","e um bode macho para oferta pelo pecado, além da oferta queimada contínua, sua oferta de refeição, e sua oferta de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“'No segundo dia você oferecerá doze novilhos, dois carneiros e catorze cordeiros machos por ano sem defeito; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","e sua oferta de refeição e suas ofertas de bebida para os touros, para os carneiros e para os cordeiros, de acordo com seu número, após a ordenança; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","e um bode macho para uma oferta pelo pecado, além da oferta queimada contínua, com sua oferta de refeição e suas ofertas de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“'No terceiro dia: onze touros, dois carneiros, catorze cordeiros machos por ano sem defeito; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","e sua oferta de refeição e suas ofertas de bebida para os touros, para os carneiros, e para os cordeiros, de acordo com seu número, após a ordenança; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","e um bode macho para uma oferta pelo pecado, além da oferta queimada contínua, e sua oferta de refeição, e sua oferta de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“'No quarto dia dez touros, dois carneiros, catorze cordeiros machos por ano sem defeito; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","their oferta de refeição e suas ofertas de bebida para os touros, para os carneiros, e para os cordeiros, de acordo com seu número, após a ordenança; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","e um bode macho para uma oferta pelo pecado; além da oferta queimada contínua, sua oferta de refeição, e sua oferta de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“'No quinto dia: nove touros, dois carneiros, catorze cordeiros machos por ano sem defeito; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","e sua oferta de refeição e suas ofertas de bebida para os touros, para os carneiros, e para os cordeiros, de acordo com seu número, após a portaria, ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","e um bode macho para uma oferta pelo pecado, além da oferta queimada contínua, e sua oferta de refeição, e sua oferta de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“'No sexto dia: oito touros, dois carneiros, catorze cordeiros machos por ano sem defeito; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","e sua oferta de refeição e suas ofertas de bebida para os touros, para os carneiros, e para os cordeiros, de acordo com seu número, após a portaria, ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","e um bode macho para uma oferta pelo pecado; além da oferta queimada contínua, sua oferta de refeição, e as ofertas de bebida dela. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“'No sétimo dia: sete touros, dois carneiros, catorze cordeiros machos por ano sem defeito; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","e sua oferta de refeição e suas ofertas de bebida para os touros, para os carneiros, e para os cordeiros, de acordo com seu número, após a portaria, ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","e um bode macho para uma oferta pelo pecado; além da oferta queimada contínua, sua oferta de refeição, e sua oferta de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“'No oitavo dia, você terá uma assembléia solene. Você não fará nenhum trabalho regular; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","mas oferecerá uma oferta queimada, uma oferta feita pelo fogo, um aroma agradável para Javé: um touro, um carneiro, sete cordeiros machos por ano sem defeito; ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","their oferta de refeição e suas ofertas de bebida para o touro, para o carneiro, e para os cordeiros, será de acordo com seu número, após a ordenança, ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","e um bode macho para uma oferta pelo pecado, além da oferta queimada contínua, com sua oferta de refeição, e sua oferta de bebida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“'Você os oferecerá a Yahweh em suas festas - além de seus votos e suas ofertas de livre vontade - para suas ofertas queimadas, suas ofertas de refeições, suas ofertas de bebidas e suas ofertas de paz'”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Moses disse aos filhos de Israel de acordo com tudo o que Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moisés falou aos chefes das tribos dos filhos de Israel, dizendo: “Esta é a coisa que Javé ordenou”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Quando um homem faz um voto a Javé, ou faz um juramento de amarrar sua alma com um vínculo, ele não deve quebrar sua palavra. Ele fará de acordo com tudo o que procede de sua boca. ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Também, quando uma mulher faz um voto a Javé e se vincula por um compromisso, estando na casa de seu pai, em sua juventude, ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","e seu pai ouve seu voto e seu compromisso com o qual ela tem vinculado sua alma, e seu pai não lhe diz nada, então todos os seus votos se manterão, e todo compromisso com o qual ela tem vinculado sua alma se manterá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Mas se seu pai a proibir no dia em que ouvir, nenhum de seus votos ou de suas promessas com as quais ela tiver vinculado sua alma se manterá de pé. Yahweh a perdoará, porque seu pai a proibiu. ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Se ela tiver um marido, enquanto seus votos estiverem sobre ela, ou o pronunciar precipitado de seus lábios com os quais ela ligou sua alma, ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","e seu marido o ouvir, e não lhe disser nada no dia em que o ouvir; então seus votos se manterão, e suas promessas com as quais ela ligou sua alma se manterão. ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Mas se seu marido a proíbe no dia em que a ouvir, então ele anula seu voto que está sobre ela e a pronúncia precipitada de seus lábios, com os quais ela ligou sua alma. Yahweh a perdoará. ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Mas o voto de uma viúva, ou de uma divorciada, tudo com o qual ela se ligou a sua alma se colocará contra ela. ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Se ela fez um voto na casa de seu marido ou amarrou sua alma por um vínculo com um juramento, ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","e seu marido o ouviu, e se calou com ela e não a negou, então todos os seus votos se manterão, e todo juramento com o qual ela amarrou sua alma se manterá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Mas se seu marido os anulou no dia em que os ouviu, então o que quer que tenha saído de seus lábios a respeito de seus votos, ou a respeito do vínculo de sua alma, não se manterá de pé. Seu marido os fez nulos. Yahweh a perdoará. ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Cada voto, e cada juramento vinculativo para afligir a alma, seu marido pode estabelecê-lo, ou seu marido pode torná-lo nulo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Mas se seu marido não lhe disser nada de dia a dia, então ele estabelece todos os seus votos ou todas as suas promessas que estão sobre ela. Ele os estabeleceu, porque nada lhe disse no dia em que os ouviu. ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Mas se ele os torna nulos depois de ouvi-los, então ele suportará a iniqüidade dela”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","These são os estatutos que Javé ordenou a Moisés, entre um homem e sua esposa, entre um pai e sua filha, estando em sua juventude, na casa de seu pai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Vingar as crianças de Israel nos midianitas”. Depois disso, vocês serão reunidos ao seu povo”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moisés falou ao povo, dizendo: “Armem homens dentre vocês para a guerra, para que possam ir contra Midian, para executar a vingança de Yahweh sobre Midian. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Vocês enviarão mil de cada tribo, de todas as tribos de Israel, para a guerra”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","So foram entregues, dos milhares de Israel, mil de cada tribo, doze mil armados para a guerra. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moisés os enviou, mil de cada tribo, para a guerra com Finéias, filho de Eleazar, o sacerdote, para a guerra, com os vasos do santuário e as trombetas para o alarme em sua mão. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Eles lutaram contra Midian, como Yahweh ordenou a Moisés. Eles mataram todos os homens. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Mataram os reis de Midiã com o resto de seus mortos: Evi, Rekem, Zur, Hur, e Reba, os cinco reis de Midiã. Eles também mataram Balaão, o filho de Beor, com a espada. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Os filhos de Israel levaram as mulheres de Midian cativas com seus pequenos; e todo o seu gado, todos os seus rebanhos e todos os seus bens, eles levaram como pilhagem. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Todas as suas cidades nos lugares em que viviam, e todos os seus acampamentos, queimavam com fogo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Levaram todos os cativos, e todo o saque, tanto do homem como do animal. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Levaram os cativos com a presa e o saque, a Moisés, e a Eleazar, o sacerdote, e à congregação dos filhos de Israel, ao acampamento nas planícies de Moab, que estão junto ao Jordão em Jericó. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moisés e Eleazar, o sacerdote, com todos os príncipes da congregação, saíram ao seu encontro fora do acampamento. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moisés ficou furioso com os oficiais do exército, os capitães de milhares e os capitães de centenas, que vieram do serviço da guerra. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Moisés disse-lhes: “Vocês salvaram todas as mulheres vivas? ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Eis que estas fizeram com que as crianças de Israel, através do conselho de Balaão, cometessem transgressão contra Javé no caso de Peor, e assim a praga estava entre a congregação de Javé. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Agora, portanto, matem todos os homens entre os pequenos, e matem todas as mulheres que conheceram o homem, deitando-se com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Mas todas as meninas, que não conheceram o homem deitando-se com ele, mantenham-se vivas para si mesmas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Acampar fora do acampamento por sete dias. Quem matou qualquer pessoa, e quem tocou qualquer morto, purifiquem-se no terceiro dia e no sétimo dia, você e seus cativos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Purificareis toda vestimenta, e tudo o que é feito de pele, e todo o trabalho de pêlos de cabras, e todas as coisas feitas de madeira”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Eleazar, o sacerdote, disse aos homens de guerra que foram à batalha: “Este é o estatuto da lei que Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Entretanto o ouro, a prata, o bronze, o ferro, o estanho e o chumbo, ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","tudo o que possa resistir ao fogo, você fará para atravessar o fogo, e ele será limpo; no entanto, será purificado com a água para a impureza. Tudo o que não resistir ao fogo, você deverá fazer para atravessar a água. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Lavarão suas roupas no sétimo dia e estarão limpas. Depois, entrareis no acampamento”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Conte o saque que foi levado, tanto do homem quanto do animal, você, e Eleazar, o sacerdote, e os chefes de família dos pais da congregação; ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","e divida o saque em duas partes: entre os homens hábeis na guerra, que saíram para a batalha, e toda a congregação. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Levar um tributo a Javé dos homens de guerra que saíram para a batalha: uma alma de quinhentos; das pessoas, do gado, dos burros, e dos rebanhos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Pegue-a de sua metade e dê-a a Eleazar, o sacerdote, pela oferta da onda de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Da metade dos filhos de Israel, tirareis um de cada cinqüenta, das pessoas, do gado, dos burros e dos rebanhos, de todo o gado, e os dareis aos levitas, que cumprem o dever do tabernáculo de Iavé”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moisés e Eleazar, o sacerdote, fizeram como Yahweh ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Agora o saque, além do saque que os homens de guerra levaram, era de seiscentas e setenta e cinco mil ovelhas, ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","seventy-dois mil cabeças de gado, ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","sixty-um mil burros, ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","e trinta e duas mil pessoas no total, das mulheres que não tinham conhecido o homem deitado com ele. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","A metade, que foi a porção dos que saíram para a guerra, estava em número de trezentas e trinta e sete mil e quinhentas ovelhas; ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","e a homenagem de Javé às ovelhas foi seiscentas e setenta e cinco. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","O gado era de trinta e seis mil, dos quais a homenagem de Iavé era de setenta e dois. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Os burros eram trinta mil e quinhentos, dos quais o tributo de Iavé era sessenta e um. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","As pessoas eram dezesseis mil, das quais o tributo de Iavé era de trinta e duas pessoas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moisés deu o tributo, que era a oferta de onda de Iavé, a Eleazar, o sacerdote, como Iavé ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Da metade dos filhos de Israel, que Moisés dividiu dos homens que lutaram ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","(agora a metade da congregação era de trezentos e trinta e sete mil e quinhentas ovelhas, ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","thirty-seis mil cabeças de gado, ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","trinta e quinhentos burros, ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","e dezesseis mil pessoas), ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","mesmo da metade dos filhos de Israel, Moisés tirou um de cada cinqüenta, tanto do homem como do animal, e os deu aos levitas, que cumpriram o dever do tabernáculo de Javé, como Javé ordenou a Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Os oficiais que estavam acima dos milhares do exército, os capitães de milhares, e os capitães de centenas, aproximaram-se de Moisés. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Eles disseram a Moisés: “Seus servos tomaram a soma dos homens de guerra que estão sob nosso comando, e não falta um só homem de nós. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Trouxemos a oferta de Javé, o que todo homem encontrou: ornamentos de ouro, braceletes, pulseiras, anéis de sinalização, brincos e colares, para fazer expiação por nossas almas diante de Javé”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moisés e Eleazar, o sacerdote, levaram seu ouro, mesmo todas as jóias trabalhadas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Todo o ouro da oferta da onda que eles ofereceram a Javé, dos capitães de milhares e dos capitães de centenas, foi de dezesseis mil setecentos e cinqüenta siclos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Os homens de guerra tinham levado espólio, cada um por si. ");
INSERT INTO porbrbsl_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moisés e Eleazar, o sacerdote, levaram o ouro dos capitães de milhares e de centenas, e o trouxeram à Tenda da Reunião para um memorial para os filhos de Israel antes de Yahweh. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Agora as crianças de Reuben e as crianças de Gad tinham uma grande multidão de animais. Eles viram a terra de Jazer, e a terra de Gilead. Eis que o lugar era um lugar para o gado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Então os filhos de Gad e os filhos de Rúben vieram e falaram a Moisés, e a Eleazar, o sacerdote, e aos príncipes da congregação, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Ataroth, Dibon, Jazer, Nimrah, Heshbon, Elealeh, Sebam, Nebo, e Beon, ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","a terra que Yahweh atingiu perante a congregação de Israel, é uma terra para o gado; e seus servos têm gado”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Eles disseram: “Se achamos favor a seus olhos, que esta terra seja dada a seus servos por uma possessão. Não nos traga sobre o Jordão”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moisés disse aos filhos de Gad, e aos filhos de Reuben: “Irão seus irmãos à guerra enquanto você se senta aqui? ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Por que vocês desencorajam o coração dos filhos de Israel de ir para a terra que Iavé lhes deu? ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Seus pais o fizeram quando os enviei de Kadesh Barnea para ver a terra. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Pois quando subiram ao vale de Eshcol e viram a terra, desencorajaram o coração dos filhos de Israel, para que não entrassem na terra que Iavé lhes havia dado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","A ira de Javé queimou naquele dia, e ele jurou, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","'Certamente nenhum dos homens que subiram do Egito, de vinte anos para cima, verá a terra que jurei a Abraão, a Isaac e a Jacó; porque não me seguiram totalmente, ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","exceto Calebe, filho de Jefoné, o quenizita, e Josué, filho de Num, porque seguiram a Javé completamente'. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","A raiva de Javé queimou contra Israel, e ele os fez vagar de um lado para o outro no deserto por quarenta anos, até que toda a geração que tinha feito o mal aos olhos de Javé foi consumida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Eis que vocês se levantaram no lugar de seus pais, um aumento de homens pecadores, para aumentar a raiva feroz de Iavé para com Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Pois se vocês se afastarem dele, ele os deixará mais uma vez no deserto; e vocês destruirão todas essas pessoas”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Eles se aproximaram dele e disseram: “Aqui construiremos pastos de ovelhas para nosso gado, e cidades para nossos pequenos; ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","mas nós mesmos estaremos prontos armados para ir diante das crianças de Israel, até trazê-las ao seu lugar”. Nossos pequenos habitarão nas cidades fortificadas por causa dos habitantes da terra. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Não voltaremos às nossas casas até que todos os filhos de Israel tenham recebido sua herança. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Pois não herdaremos com eles do outro lado do Jordão e além, porque nossa herança chegou até nós deste lado do Jordão para o leste”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moisés disse a eles: “Se vocês fizerem isso, se vocês se armarem para ir antes de Yahweh para a guerra, ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","e cada um de seus homens armados passará o Jordão antes de Yahweh até que ele tenha expulsado seus inimigos de antes dele, ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","e a terra seja subjugada antes de Yahweh; então, depois disso, vocês voltarão, e ficarão livres de obrigações para Yahweh e para Israel. Então esta terra será sua posse antes de Iavé. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Mas se você não o fizer, eis que você pecou contra Javé; e esteja certo de que seu pecado o descobrirá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Construa cidades para seus pequenos, e pregas para suas ovelhas; e faça o que saiu de sua boca”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Os filhos de Gad e os filhos de Rúben falaram a Moisés, dizendo: “Seus servos farão o que meu senhor manda”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nossos pequeninos, nossas esposas, nossos rebanhos e todo nosso gado estarão lá nas cidades de Gilead; ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","mas seus servos passarão, todos os homens armados para a guerra, antes de Yahweh para a batalha, como diz meu senhor”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Assim Moisés ordenou a respeito deles a Eleazar, o sacerdote, e a Josué, filho de Freira, e aos chefes de família dos pais das tribos dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Moisés lhes disse: “Se os filhos de Gad e os filhos de Rúben passarem com vocês sobre o Jordão, todo homem que estiver armado para lutar diante de Iavé, e a terra for subjugada diante de vocês, então vocês lhes darão a terra de Gilead por uma possessão; ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","mas se eles não passarem com vocês armados, eles terão possessões entre vocês na terra de Canaã”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Os filhos de Gad e os filhos de Reuben responderam, dizendo: “Como Javé disse a seus servos, assim faremos nós”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Passaremos armados diante de Javé para a terra de Canaã, e a posse de nossa herança permanecerá conosco além do Jordão”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Moisés deu a eles, mesmo aos filhos de Gade, e aos filhos de Rubem, e à meia tribo de Manassés, filho de José, o reino de Siom, rei dos amorreus, e o reino de Og, rei de Basã; a terra, de acordo com suas cidades e fronteiras, mesmo as cidades da terra ao redor. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Os filhos de Gad construíram Dibon, Ataroth, Aroer, ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atroth-shophan, Jazer, Jogbehah, ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth Nimrah, e Beth Haran: cidades fortificadas e currais para ovelhas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","As crianças de Reuben construíram Heshbon, Elealeh, Kiriathaim, ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, e Baal Meon, (seus nomes estão sendo mudados), e Sibmah. Eles deram outros nomes às cidades que eles construíram. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Os filhos de Machir, filho de Manasseh, foram para Gilead, levaram-no e desapossaram os amoritas que estavam lá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Moisés deu Gileade a Machir, o filho de Manassés; e ele viveu lá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair, o filho de Manasseh, foi e tomou suas aldeias, e as chamou de Havvoth Jair. ");
INSERT INTO porbrbsl_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobah foi e tomou Kenath e suas aldeias, e o chamou de Nobah, depois de seu próprio nome. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Estas são as viagens dos filhos de Israel, quando saíram da terra do Egito por seus exércitos sob as mãos de Moisés e Aarão. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moisés escreveu os pontos de partida de suas viagens pelo mandamento de Yahweh. Estas são suas jornadas de acordo com seus pontos de partida. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Eles viajaram de Ramsés no primeiro mês, no décimo quinto dia do primeiro mês; no dia seguinte após a Páscoa, os filhos de Israel saíram com uma mão alta à vista de todos os egípcios, ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","enquanto os egípcios enterravam todos os seus primogênitos, que Yahweh havia golpeado entre eles. Javé também executou juízos sobre seus deuses. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","As crianças de Israel viajaram de Ramsés, e acamparam em Succoth. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Viajaram de Succoth, e acamparam em Etham, que fica na orla do deserto. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Viajaram de Etham, e voltaram para Pihahiroth, que fica antes de Baal Zephon, e acamparam antes de Migdol. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Viajaram de antes de Hahiroth, e atravessaram o meio do mar para o deserto. Foram três dias de viagem no deserto de Etham, e acamparam em Marah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Viajaram de Marah, e vieram para Elim. Em Elim, havia doze nascentes de água e setenta palmeiras, e eles acamparam lá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Viajaram de Elim, e acamparam junto ao Mar Vermelho. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","They viajaram do Mar Vermelho, e acamparam no deserto de Pecado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","They viajaram do deserto de Sin, e acamparam em Dophkah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","They viajou de Dophkah, e acampado em Alush. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","viajaram de Alush, e acamparam em Rephidim, onde não havia água para o povo beber. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","They viajaram de Rephidim, e acamparam no deserto do Sinai. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","They viajou do deserto do Sinai, e acampado em Kibroth Hattaavah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","They viajou de Kibroth Hattaavah, e acampado em Hazeroth. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","They viajou de Hazeroth, e acampado em Rithmah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","They viajou de Rithmah, e acampado em Rimmon Perez. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","They viajou de Rimmon Perez, e acampado em Libnah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","They viajou de Libnah, e acampado em Rissah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","They viajou de Rissah, e acampado em Kehelathah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","They viajou de Kehelathah, e acampado em Mount Shepher. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","They viajou de Mount Shepher, e acampado em Haradah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","They viajou de Haradah, e acampado em Makheloth. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","They viajado desde Makheloth, e acampado em Tahath. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","They viajado desde Tahath, e acampado em Terah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","They viajou de Terah, e acampou em Mithkah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","They viajaram de Mithkah, e acamparam em Hashmonah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","They viajou de Hashmonah, e acampou em Moseroth. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","They viajou de Moseroth, e acampado em Bene Jaakan. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","They viajou de Bene Jaakan, e acampou em Hor Haggidgad. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","They viajou de Hor Haggidgad, e acampado em Jotbathah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","They viajou de Jotbathah, e acampado em Abronah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","They viajou de Abronah, e acampou em Ezion Geber. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Viajaram de Ezion Geber, e acamparam em Kadesh, no deserto de Zin. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Viajaram de Cades, e acamparam no Monte Hor, na borda da terra de Edom. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Aaron, o sacerdote, subiu ao Monte Hor por ordem de Javé e morreu lá, no quadragésimo ano depois que os filhos de Israel saíram da terra do Egito, no quinto mês, no primeiro dia do mês. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaron tinha cento e vinte e três anos de idade quando morreu no Monte Hor. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","O rei cananeu de Arade, que vivia no Sul, na terra de Canaã, ouviu falar da vinda dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","They viajou do Monte Hor, e acampou em Zalmonah. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","They viajou de Zalmonah, e acampou em Punon. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","They viajou de Punon, e acampou em Oboth. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","They viajou de Oboth, e acampou em Iye Abarim, na fronteira de Moab. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","They viajou de Iyim, e acampado em Dibon Gad. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","They viajou de Dibon Gad, e acampado em Almon Diblathaim. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Viajaram de Almon Diblathaim, e acamparam nas montanhas de Abarim, antes de Nebo. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Viajaram das montanhas de Abarim, e acamparam nas planícies de Moab, junto ao Jordão, em Jericó. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Acamparam junto ao Jordão, desde Beth Jeshimoth até Abel Shittim, nas planícies de Moab. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Yahweh falou a Moisés nas planícies de Moabe, junto ao Jordão, em Jericó, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Fale aos filhos de Israel e diga-lhes: “Quando vocês passarem o Jordão para a terra de Canaã, ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","então vocês expulsarão todos os habitantes da terra de antes de vocês, destruirão todos os seus ídolos de pedra, destruirão todas as suas imagens fundidas e demolirão todos os seus lugares altos. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","tomarás posse da terra, e nela habitarás; pois eu te dei a terra para que a possuísses. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Você herdará a terra por sorteio de acordo com suas famílias; aos grupos maiores você dará uma herança maior, e aos menores você dará uma herança menor. Onde quer que o lote caiba a qualquer homem, esse será o seu. Vocês herdarão de acordo com as tribos de seus pais. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“Mas se você não expulsar os habitantes da terra de antes de você, então aqueles que você deixar ficar deles serão como picadas em seus olhos e espinhos em seus lados. Eles o assediarão na terra em que você mora. ");
INSERT INTO porbrbsl_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Acontecerá que como eu pensava fazer com eles, assim eu farei com você”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Yahweh falou com Moisés, dizendo, ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Comande os filhos de Israel, e diga-lhes, 'Quando você entrar na terra de Canaã (esta é a terra que lhe caberá por herança, mesmo a terra de Canaã de acordo com suas fronteiras), ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","então seu bairro sul será do deserto de Zin ao lado de Edom, e sua fronteira sul será do final do Mar Salgado para o leste. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Sua fronteira virará ao sul da subida de Akrabbim, e passará para Zin; e passará para o sul de Kadesh Barnea; e daí irá para Hazar Addar, e passará para Azmon. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","A fronteira virará de Azmon para o riacho do Egito, e terminará no mar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“'Para a fronteira ocidental, você terá o grande mar e sua fronteira. Esta será sua fronteira oeste. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“'Esta será sua fronteira norte: do grande mar, vocês marcarão para si mesmos o Monte Hor. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Do Monte Hor vocês marcarão até a entrada de Hamath; e a fronteira passará por Zedad. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Então a fronteira irá para Ziphron, e terminará em Hazar Enan. Esta será sua fronteira norte. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“'Você deve marcar sua fronteira leste de Hazar Enan a Shepham. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","A fronteira descerá de Shepham para Riblah, no lado leste de Ain. A fronteira descerá, e chegará ao lado do mar de Chinnereth, ao leste. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","A fronteira deve descer até o Jordão, e terminar no Mar Salgado. Esta será sua terra, de acordo com suas fronteiras ao seu redor”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Moisés ordenou aos filhos de Israel, dizendo: “Esta é a terra que herdareis por sorteio, que Javé mandou dar às nove tribos e à meia tribo; ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","para a tribo dos filhos de Rúben, segundo as casas de seus pais, a tribo dos filhos de Gade, segundo as casas de seus pais, e a meia tribo de Manassés receberam sua herança. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","As duas tribos e a meia-tribos receberam sua herança além do Jordão, em Jericó para o leste, em direção ao nascer do sol”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Estes são os nomes dos homens que dividirão a terra para você por herança: Eleazar, o sacerdote, e Josué, o filho de Freira. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Você levará um príncipe de cada tribo, para dividir a terra em herança. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Estes são os nomes dos homens: Da tribo de Judá, Calebe, o filho de Jefoné. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Da tribo dos filhos de Simeão, Shemuel, o filho de Ammihud. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Da tribo de Benjamin, Elidad o filho de Chislon. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Da tribo dos filhos de Dan um príncipe, Bukki o filho de Jogli. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Dos filhos de José: da tribo dos filhos de Manasseh um príncipe, Hanniel o filho de Éfod. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Da tribo dos filhos de Efraim, um príncipe, Kemuel, filho de Shiphtan. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Da tribo dos filhos de Zebulom um príncipe, Elizaphan o filho de Parnach. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Da tribo dos filhos de Issachar, um príncipe, Paltiel, filho de Azzan. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Da tribo dos filhos de Asher um príncipe, Ahihud o filho de Shelomi. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Da tribo dos filhos de Naftali um príncipe, Pedahel o filho de Amihud”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Estes são aqueles que Yahweh mandou dividir a herança para os filhos de Israel na terra de Canaã. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Yahweh falou a Moisés nas planícies de Moab, junto ao Jordão, em Jericó, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Comande os filhos de Israel a darem aos levitas cidades para morar fora de sua herança. Darão aos levitas terras de pasto para as cidades ao seu redor. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Eles terão as cidades para habitarem. Suas terras de pasto serão para seu gado, e para seus bens, e para todos os seus animais. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“As terras de pasto das cidades, que você dará aos levitas, serão da muralha da cidade e para fora mil cúbitos ao redor dela. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","“Você deve medir fora da cidade para o lado leste dois mil cúbitos, e para o lado sul dois mil cúbitos, e para o lado oeste dois mil cúbitos, e para o lado norte dois mil cúbitos, estando a cidade no meio. Estas devem ser as terras de pasto de suas cidades. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“As cidades que você dará aos Levitas, serão as seis cidades de refúgio, que você dará para que o homem assassino fuja para lá. Além delas, dareis quarenta e duas cidades. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","“Todas as cidades que dareis aos Levitas serão quarenta e oito cidades junto com suas terras de pasto. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Concerning as cidades que dareis da posse dos filhos de Israel, das muitas tereis muitas, e das poucas tereis poucas. Cada um, segundo sua herança que herdar, dará algumas de suas cidades aos levitas”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Yahweh falou a Moisés, dizendo: ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Falai aos filhos de Israel, e dizei-lhes: 'Quando passardes o Jordão para a terra de Canaã, ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","então designareis para vós mesmos cidades para serem cidades de refúgio para vós, para que o assassino que matar qualquer pessoa involuntariamente possa fugir para lá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","As cidades serão para vós cidades de refúgio do vingador, para que o homem assassino não morra até que se apresente perante a congregação para julgamento. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","As cidades que você dará serão para você seis cidades de refúgio. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Dareis três cidades além do Jordão, e dareis três cidades na terra de Canaã. Elas serão cidades de refúgio. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Estas seis cidades serão refúgio para os filhos de Israel, para o estrangeiro e para o estrangeiro que vive entre eles, para que todo aquele que matar qualquer pessoa involuntariamente possa fugir para lá. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“'Mas se ele o atingiu com um instrumento de ferro, de modo que ele morreu, ele é um assassino. O assassino certamente será condenado à morte. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Se ele o golpeou com uma pedra na mão, pela qual um homem pode morrer, e ele morreu, ele é um assassino. O homicida certamente será morto. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Ou se ele o atingiu com uma arma de madeira na mão, pela qual um homem pode morrer, e ele morreu, ele é um assassino. O assassino certamente será condenado à morte. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","O próprio vingador do sangue deve matar o assassino. Quando ele o encontrar, ele o matará. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Se ele o empurrou por ódio, ou atirou algo contra ele enquanto esperava, de modo que ele morreu, ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ou em hostilidade o golpeou com a mão, de modo que ele morreu, aquele que o golpeou certamente será morto. Ele é um assassino. O vingador do sangue deve matar o assassino quando ele o encontrar. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“'Mas se ele o empurrou de repente sem hostilidade, ou lançou sobre ele qualquer coisa sem esperar, ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ou com qualquer pedra, pela qual um homem pode morrer, não vendo-o, e lançou sobre ele para que morresse, e ele não era seu inimigo e não procurava seu mal, ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","então a congregação julgará entre o grevista e o vingador do sangue de acordo com estas ordenanças. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","A congregação libertará o assassino da mão do vingador do sangue, e a congregação o restituirá à sua cidade de refúgio, onde ele havia fugido. Ele morará ali até a morte do sumo sacerdote, que foi ungido com o óleo sagrado. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“'Mas se o assassino de homens for a qualquer momento além da fronteira de sua cidade de refúgio onde foge, ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","e o vingador de sangue o encontrar fora da fronteira de sua cidade de refúgio, e o vingador de sangue matar o assassino de homens, ele não será culpado de sangue, ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","porque ele deveria ter permanecido em sua cidade de refúgio até a morte do sumo sacerdote. Mas após a morte do sumo sacerdote, o homem assassino deverá voltar à terra de sua posse. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“'Estas coisas serão para um estatuto e uma ordenação para você através de suas gerações em todas as suas habitações. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“'Quem matar qualquer pessoa, o assassino será morto com base no depoimento de testemunhas; mas uma testemunha não testemunhará sozinha contra qualquer pessoa para que ela morra. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“'Além disso, você não aceitará resgate pela vida de um assassino que seja culpado de morte. Ele certamente será condenado à morte. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“'Não aceitas resgate por aquele que fugiu para sua cidade de refúgio, para que ele possa voltar a morar na terra antes da morte do sacerdote. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“'Portanto, você não deve poluir a terra onde vive; pois o sangue polui a terra. Nenhuma expiação pode ser feita pela terra pelo sangue que nela é derramado, mas pelo sangue daquele que o derrama. ");
INSERT INTO porbrbsl_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Não contaminarás a terra que habitas, onde eu habito; pois eu, Javé, habito entre os filhos de Israel”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Os chefes de família dos pais dos filhos de Gilead, o filho de Machir, o filho de Manasseh, das famílias dos filhos de José, aproximaram-se e falaram diante de Moisés e diante dos príncipes, os chefes de família dos pais dos filhos de Israel. ");
INSERT INTO porbrbsl_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Eles disseram: “Javé ordenou a meu senhor que desse a terra em herança por sorteio aos filhos de Israel”. Meu senhor foi ordenado por Javé a dar a herança de Zelofeade nosso irmão para suas filhas. ");
INSERT INTO porbrbsl_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Se elas forem casadas com algum dos filhos das outras tribos dos filhos de Israel, então sua herança será retirada da herança de nossos pais, e será acrescentada à herança da tribo à qual elas pertencerão. Portanto, ela será tirada do lote de nossa herança. ");
INSERT INTO porbrbsl_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Quando chegar o jubileu dos filhos de Israel, então sua herança será acrescentada à herança da tribo à qual eles pertencerão. Assim sua herança será tirada da herança da tribo de nossos pais”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Moisés ordenou aos filhos de Israel, segundo a palavra de Javé, dizendo: “A tribo dos filhos de José fala o que é certo”. ");
INSERT INTO porbrbsl_vpl VALUES ("NU36_6","005