﻿USE sofia;
DROP TABLE IF EXISTS sofia.porblt_vpl;
CREATE TABLE porblt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES porblt_vpl WRITE;
INSERT INTO porblt_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Este livro é o registro da genealogia de Jesus Cristo, filho de Davi, filho de Abraão: ");
INSERT INTO porblt_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraão gerou Isaque; Isaque gerou Jacó; Jacó gerou Judá e seus irmãos; ");
INSERT INTO porblt_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá gerou Perez e Zera, cuja mãe foi Tamar; Perez gerou Esrom; Esrom gerou Arão; ");
INSERT INTO porblt_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arão gerou Aminadabe; Aminadabe gerou Naassom; Naassom gerou Salmom; ");
INSERT INTO porblt_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmom gerou Boaz, cuja mãe foi Raabe; Boaz gerou Obede, cuja mãe foi Rute; Obede gerou Jessé; ");
INSERT INTO porblt_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jessé gerou o rei Davi. Davi gerou Salomão, cuja mãe tinha sido mulher de Urias; ");
INSERT INTO porblt_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomão gerou Roboão; Roboão gerou Abias; Abias gerou Asa; ");
INSERT INTO porblt_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa gerou Josafá; Josafá gerou Jorão; Jorão gerou Uzias; ");
INSERT INTO porblt_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzias gerou Jotão; Jotão gerou Acaz; Acaz gerou Ezequias; ");
INSERT INTO porblt_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequias gerou Manassés; Manassés gerou Amom; Amom gerou Josias; ");
INSERT INTO porblt_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josias gerou Jeconias e seus irmãos, no tempo em que houve o exílio na Babilônia. ");
INSERT INTO porblt_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Após o exílio na Babilônia, Jeconias gerou Salatiel; Salatiel gerou Zorobabel; ");
INSERT INTO porblt_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel gerou Abiúde; Abiúde gerou Eliaquim; Eliaquim gerou Azor; ");
INSERT INTO porblt_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor gerou Sadoque; Sadoque gerou Aquim; Aquim gerou Eliúde; ");
INSERT INTO porblt_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliúde gerou Eleazar; Eleazar gerou Matã; Matã gerou Jacó; ");
INSERT INTO porblt_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","E Jacó gerou José, esposo de Maria, da qual nasceu Jesus, que é chamado Messias. ");
INSERT INTO porblt_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Assim, todas as gerações, desde Abraão até Davi, são quatorze. Desde Davi até o exílio na Babilônia, quatorze. E desde o exílio na Babilônia até Cristo, quatorze gerações. ");
INSERT INTO porblt_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Foi assim que Jesus Cristo nasceu: sua mãe, Maria, estava prometida em casamento a José, mas, antes que mantivessem relações, ela ficou grávida pelo Espírito Santo. ");
INSERT INTO porblt_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Por ser José, seu noivo, um bom homem, o qual não queria expô-la à desonra pública, decidiu anular secretamente o casamento. ");
INSERT INTO porblt_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Enquanto assim pensava, um anjo do Senhor apareceu em sonho e lhe disse: “José, filho de Davi, não tenha medo de se casar com Maria, pois ela está grávida pelo Espírito Santo. ");
INSERT INTO porblt_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ela dará à luz um filho e você deverá chamá-lo Jesus, porque ele salvará as pessoas de seus pecados.” ");
INSERT INTO porblt_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","(Tudo isso aconteceu para que se cumprisse o que o Senhor disse pelo profeta: ");
INSERT INTO porblt_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“A virgem ficará grávida e dará à luz um filho, a quem colocarão o nome de Emanuel”, que significa “Deus conosco.”) ");
INSERT INTO porblt_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José despertou e fez o que o anjo do Senhor lhe havia ordenado. ");
INSERT INTO porblt_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ele se casou com Maria, porém não mantiveram relações até que ela desse à luz um filho, a quem deu o nome de Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Após Jesus nascer na cidade de Belém, na Judeia, durante o reinado de Herodes, magos, vindos do Oriente, chegaram a Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Onde está o rei dos judeus que acaba de nascer?”, perguntaram. “Nós vimos a estrela dele no Oriente e viemos adorá-lo.” ");
INSERT INTO porblt_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ao ouvir isso, o rei Herodes ficou muito preocupado, assim como toda a Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Então, Herodes reuniu todos os chefes dos sacerdotes e educadores religiosos do povo e lhes perguntou onde deveria nascer o Messias. ");
INSERT INTO porblt_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Na cidade de Belém, na Judeia”, eles responderam, “pois o profeta escreveu: ");
INSERT INTO porblt_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Você, Belém, da terra da Judeia, de forma alguma é a menos importante entre as principais cidades de Judá, pois será o berço do líder que guiará o meu povo de Israel.’” ");
INSERT INTO porblt_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Então, Herodes chamou os magos e os encontrou secretamente, descobrindo assim o exato momento em que a estrela aparecera. ");
INSERT INTO porblt_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ele os enviou para Belém e disse: “Ao chegarem lá, procurem o menino. E, ao encontrá-lo, avisem-me, para que eu também possa ir adorá-lo.” ");
INSERT INTO porblt_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Após ouvirem o rei, eles seguiram o seu caminho, e a estrela, que já tinham visto no Oriente, os guiou até parar exatamente acima do lugar em que a criança estava. ");
INSERT INTO porblt_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Quando viram a estrela, eles ficaram muito felizes! ");
INSERT INTO porblt_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Entraram na casa e viram o menino com a sua mãe, Maria. Eles se ajoelharam e o adoraram. Então, abriram as bolsas em que traziam seus tesouros e o presentearam com ouro, incenso e mirra. ");
INSERT INTO porblt_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Alertados por um sonho para não retornarem para junto de Herodes, eles voltaram ao seu país por um caminho diferente. ");
INSERT INTO porblt_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Após os magos terem ido embora, um anjo do Senhor apareceu em um sonho a José e lhe disse: “Levante-se, pegue a criança e sua mãe e fujam para o Egito. Fiquem lá até que eu lhe diga, pois Herodes irá procurar a criança para matá-la.” ");
INSERT INTO porblt_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Então, José se levantou, pegou a criança e sua mãe e fugiu durante a noite para o Egito. ");
INSERT INTO porblt_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Eles ficaram lá até à morte de Herodes. Assim se cumpriu o que o Senhor disse pelo profeta: “Eu chamei o meu filho para retornar do Egito.” ");
INSERT INTO porblt_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Quando Herodes percebeu que tinha sido enganado pelos magos, ficou muito zangado. Ele enviou homens para matar todos os meninos que tivessem dois anos de idade ou menos em Belém e nas regiões próximas. Ele se baseou no período de tempo em que os magos o tinham informado. ");
INSERT INTO porblt_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Assim se cumpriu a profecia de Jeremias: ");
INSERT INTO porblt_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ouviu-se o som de terrível choro e lamentação em Ramá; era Raquel chorando por seus filhos. Eles tinham morrido, e não havia quem a pudesse consolar.” ");
INSERT INTO porblt_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Após a morte de Herodes, o anjo do Senhor apareceu em um sonho para José, no Egito, e lhe disse: ");
INSERT INTO porblt_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Levante-se! Pegue a criança e a sua mãe e volte para a terra de Israel, pois as pessoas que estavam tentando matar a criança morreram.” ");
INSERT INTO porblt_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Então, José se levantou, pegou o menino e a sua mãe e retornou para a terra de Israel. ");
INSERT INTO porblt_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mas, após saber que Arquelau governava a Judeia no lugar de seu pai, Herodes, José ficou com medo de ir para lá. Em um sonho, José foi avisado para ir para a região da Galileia ");
INSERT INTO porblt_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","e que deveria morar na cidade de Nazaré. Assim se cumpriu o que os profetas disseram: “Ele será chamado de Nazareno.” ");
INSERT INTO porblt_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Algum tempo depois, no deserto da Judeia, apareceu João Batista pregando: ");
INSERT INTO porblt_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Arrependam-se, pois o Reino do Céu chegou!” ");
INSERT INTO porblt_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Era sobre João que Isaías se referia ao dizer: “Alguém está gritando no deserto: ‘Preparem o caminho para o Senhor! Abram um caminho reto para ele!’” ");
INSERT INTO porblt_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","João usava uma roupa feita de pelo de camelo e um cinto de couro. Ele comia gafanhotos e mel silvestre. ");
INSERT INTO porblt_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Moradores de Jerusalém, de toda Judeia e de todas as regiões próximas ao rio Jordão vinham até ele, ");
INSERT INTO porblt_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","confessando os seus pecados e sendo batizados no rio Jordão. ");
INSERT INTO porblt_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mas quando João viu muitos fariseus e saduceus vindo para serem batizados, ele disse: “Ninhada de víboras venenosas! Quem disse que vocês escaparão do julgamento que está próximo? ");
INSERT INTO porblt_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mostrem, por meio de suas ações, que verdadeiramente se arrependeram dos seus pecados, ");
INSERT INTO porblt_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","e não ousem dizer uns aos outros com orgulho: ‘Abraão é nosso antepassado.’ Pois eu lhes digo que Deus pode fazer descendentes de Abraão com estas pedras. ");
INSERT INTO porblt_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mas, na verdade, o machado está pronto para cortar as árvores pela raiz. Toda árvore que não der bons frutos será cortada e jogada no fogo. ");
INSERT INTO porblt_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Sim, eu os batizo com água, para mostrar que vocês estão arrependidos dos seus pecados, mas aquele que virá depois de mim é mais poderoso do que eu. Eu não sou digno nem mesmo de tirar suas sandálias. Ele os batizará com o Espírito Santo e com fogo. ");
INSERT INTO porblt_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ele já está segurando a sua pá. Ele limpará a eira e recolherá o trigo no depósito, mas queimará a palha com o fogo que nunca se apaga.” ");
INSERT INTO porblt_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Então, Jesus veio da Galileia para ser batizado por João no rio Jordão. ");
INSERT INTO porblt_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mas João tentou convencê-lo a mudar de ideia. Ele disse a Jesus: “Eu é que preciso ser batizado por você, e você vem para que eu o batize?” ");
INSERT INTO porblt_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mas Jesus lhe disse: “Por favor, faça isso, pois é bom que façamos o que Deus diz ser o certo.” Então, João concordou. ");
INSERT INTO porblt_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Imediatamente após ter sido batizado, Jesus saiu da água. Os céus se abriram, e ele viu o Espírito de Deus descer como uma pomba e pousar sobre ele. ");
INSERT INTO porblt_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Uma voz vinda do céu disse: “Este é o meu filho a quem eu amo, que me deixa muito feliz.” ");
INSERT INTO porblt_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Então, o Espírito levou Jesus para o deserto, para ser tentado pelo diabo. ");
INSERT INTO porblt_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Após quarenta dias e quarenta noites sem comer, Jesus estava com fome. ");
INSERT INTO porblt_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","O tentador se aproximou e lhe disse: “Se você é realmente o Filho de Deus, mande estas pedras virarem pão.” ");
INSERT INTO porblt_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesus respondeu: “Como as Sagradas Escrituras dizem: ‘Os seres humanos não vivem apenas de pão, mas vivem de cada palavra dita por Deus.’” ");
INSERT INTO porblt_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Então, o diabo o levou à cidade santa e o colocou na parte mais alta do Templo. ");
INSERT INTO porblt_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Se você realmente é o Filho de Deus, então, jogue-se daqui”, disse para Jesus. “Como as Sagradas Escrituras dizem: ‘Ele mandará que os seus anjos o protejam. Eles irão segurá-lo, para que você não tropece em uma pedra.’” ");
INSERT INTO porblt_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus respondeu: “Como as Sagradas Escrituras também dizem: ‘Você não deve pôr à prova o Senhor, seu Deus.’” ");
INSERT INTO porblt_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Em seguida, o diabo levou Jesus para uma montanha muito alta e lhe mostrou todos os gloriosos reinos do mundo. ");
INSERT INTO porblt_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ele disse para Jesus: “Eu lhe darei tudo isso se você se ajoelhar e me adorar.” ");
INSERT INTO porblt_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesus disse: “Vá embora, Satanás!” “Como as Sagradas Escrituras dizem: ‘Você deve adorar o Senhor, seu Deus, e servi-lo, apenas a Ele.’” ");
INSERT INTO porblt_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Então, o diabo foi embora, e anjos vieram para cuidar de Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Quando Jesus soube que João tinha sido preso, ele voltou para a Galileia. ");
INSERT INTO porblt_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ele saiu de Nazaré e foi morar em Cafarnaum, às margens do mar, na região de Zebulom e Naftali. ");
INSERT INTO porblt_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Assim se cumpriu o que o profeta Isaías disse: ");
INSERT INTO porblt_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Na terra de Zebulom e na terra de Naftali, na estrada que leva para o mar, do outro lado do rio Jordão, na Galileia, onde os pagãos vivem: ");
INSERT INTO porblt_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","O povo que vivia na escuridão viu uma forte luz. A luz do amanhecer brilhou sobre aqueles que viviam na terra sombria da morte.” ");
INSERT INTO porblt_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","A partir daquele momento, Jesus começou a anunciar a sua mensagem, dizendo: “Arrependam-se, pois o Reino do Céu chegou!” ");
INSERT INTO porblt_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Enquanto caminhava pelo mar da Galileia, Jesus viu dois irmãos, Simão, também conhecido como Pedro, e seu irmão André, que pescavam com sua rede no mar. Eles ganhavam a vida pescando. ");
INSERT INTO porblt_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesus lhes disse: “Venham e me sigam e eu os ensinarei a pescar pessoas.” ");
INSERT INTO porblt_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Eles imediatamente largaram suas redes e o seguiram. ");
INSERT INTO porblt_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mais adiante, ele viu dois irmãos, Tiago e João. Eles estavam em um barco com seu pai, Zebedeu, consertando suas redes de pesca. Jesus os chamou para segui-lo. ");
INSERT INTO porblt_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Eles imediatamente deixaram o barco e seu pai e o seguiram. ");
INSERT INTO porblt_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus viajou por toda a Galileia, ensinando nas sinagogas, anunciando as boas novas do Reino, curando todas as doenças e enfermidades das pessoas. ");
INSERT INTO porblt_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","As notícias sobre ele se espalharam por toda a província da Síria. As pessoas levavam a Jesus todos os doentes: epiléticos, pessoas possuídas por demônios, doentes mentais, paralíticos e ele curava a todos. ");
INSERT INTO porblt_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Grandes multidões, vindas da Galileia, de Decápolis, de Jerusalém, da Judeia e da região além do rio Jordão, o seguiam. ");
INSERT INTO porblt_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Quando Jesus viu a multidão que o seguia, ele subiu um monte. Lá, ele se sentou junto aos seus discípulos ");
INSERT INTO porblt_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","e começou a ensiná-los, dizendo: ");
INSERT INTO porblt_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Felizes as pessoas que sabem que são espiritualmente pobres, pois o Reino do Céu é delas. ");
INSERT INTO porblt_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Felizes as pessoas que choram, pois elas serão consoladas. ");
INSERT INTO porblt_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Felizes as pessoas de bom coração, pois delas será o mundo todo. ");
INSERT INTO porblt_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Felizes as pessoas que têm grande desejo de fazer o que é certo, pois elas serão satisfeitas. ");
INSERT INTO porblt_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Felizes as pessoas que têm compaixão pelos outros, pois também terão compaixão por elas. ");
INSERT INTO porblt_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Felizes as pessoas que têm a alma pura, pois elas verão a Deus. ");
INSERT INTO porblt_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Felizes as pessoas que trabalham pela paz, pois elas serão chamadas de filhos de Deus. ");
INSERT INTO porblt_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Felizes as pessoas que são perseguidas por fazerem o que é certo, pois o Reino do Céu é delas. ");
INSERT INTO porblt_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Felizes são vocês quando são insultados, perseguidos e caluniados, por me seguirem. ");
INSERT INTO porblt_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sintam-se alegres, realmente felizes, pois vocês receberão uma grande recompensa no céu. Porque foi exatamente dessa forma que perseguiram os profetas que vieram antes de vocês. ");
INSERT INTO porblt_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Vocês são o sal da terra, mas se o sal perder o seu sabor, como poderão torná-lo salgado de novo? Ele não serve para mais nada, então, é jogado fora e pisado. ");
INSERT INTO porblt_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Vocês são a luz do mundo. Não se pode esconder uma cidade construída sobre uma colina. ");
INSERT INTO porblt_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ninguém acende um lampião para colocá-lo embaixo de um cesto. Ao contrário, ele é colocado em um velador, para iluminar a todos que estão na casa. ");
INSERT INTO porblt_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Da mesma forma, vocês devem deixar sua luz brilhar diante de todos, para que eles possam ver as coisas boas que são feitas por vocês e para que louvem o seu Pai celestial. ");
INSERT INTO porblt_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Não pensem que eu vim para acabar com a lei ou com os ensinamentos dos profetas. Eu não vim para acabar com eles, mas para cumpri-los. ");
INSERT INTO porblt_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Eu afirmo a vocês, enquanto o céu e a terra durarem, nem uma letra, nem um único acento será tirado da lei até que tudo seja cumprido. ");
INSERT INTO porblt_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Assim, qualquer um que desobedecer o menor mandamento e ensinar as pessoas a fazerem o mesmo será considerado o menor no Reino do Céu. Mas aquele que praticar e ensinar os mandamentos será considerado o maior no Reino do Céu. ");
INSERT INTO porblt_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Eu lhes afirmo que só entrarão no Reino do Céu se a sua retidão moral for maior do que a dos educadores religiosos e a dos fariseus. ");
INSERT INTO porblt_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Vocês ouviram o que antigamente a lei dizia às pessoas: ‘Não matarás, e qualquer um que cometer assassinato será considerado culpado.’ ");
INSERT INTO porblt_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mas eu lhes digo que qualquer um que estiver com raiva do seu irmão será considerado culpado. Quem chamar seu irmão de idiota deverá responder ao conselho, mas quem verbalmente abusar dos outros estará sujeito ao fogo da Geena. ");
INSERT INTO porblt_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Se você estiver fazendo uma oferta no altar e se lembrar de que seu irmão tem algo contra você, ");
INSERT INTO porblt_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","deixe a sua oferta no altar e, primeiro, faça as pazes com ele e só depois volte e faça a sua oferta. ");
INSERT INTO porblt_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Enquanto estiver indo para o tribunal com o seu adversário, certifique-se de, rapidamente, entrar em acordo com ele. Caso contrário, essa pessoa poderá entregá-lo ao juiz, e o juiz o entregará ao carcereiro, e você será jogado na prisão. ");
INSERT INTO porblt_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Eu lhe afirmo que isto é verdade: você não ficará livre até que tenha pago o último centavo. ");
INSERT INTO porblt_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Vocês ouviram o que foi dito: ‘Não cometa adultério.’ ");
INSERT INTO porblt_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mas eu lhes digo que qualquer um que olhar para uma mulher com o desejo de possuí-la já cometeu adultério em seu coração. ");
INSERT INTO porblt_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Se o seu olho direito o fizer pecar, então, arranque-o e jogue-o fora, pois é melhor perder uma parte do seu corpo do que todo o seu corpo arder no fogo da Geena. ");
INSERT INTO porblt_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Se a sua mão direita o fizer pecar, então, corte-a e jogue-a fora, pois é melhor perder um dos seus membros do que todo o seu corpo arder no fogo da Geena. ");
INSERT INTO porblt_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Também foi dito: ‘Se um homem se divorciar de sua esposa, ele deverá dar a ela uma certidão de divórcio.’ ");
INSERT INTO porblt_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mas eu lhes digo que qualquer homem que se divorciar de sua esposa, a não ser por imoralidade sexual, pode fazer dela uma adúltera, se ela se casar de novo; e quem se casar com essa mulher divorciada cometerá adultério. ");
INSERT INTO porblt_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","E, novamente, vocês ouviram o que foi dito aos seus antepassados: ‘Não quebrem as suas promessas. Pelo contrário, tenham certeza de cumprir o que vocês juraram ao Senhor.’ ");
INSERT INTO porblt_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mas eu lhes digo: não jurem de forma alguma. Não jurem pelo céu, pois é o trono de Deus. ");
INSERT INTO porblt_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Não jurem pela terra, pois é o descanso para os pés de Deus. Não jurem por Jerusalém, pois é a cidade do grande Rei. ");
INSERT INTO porblt_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nem mesmo jurem por sua cabeça, pois vocês não são capazes de fazer um único fio de cabelo se tornar branco ou preto. ");
INSERT INTO porblt_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Simplesmente digam sim ou não, pois mais do que isso vem do maligno. ");
INSERT INTO porblt_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Vocês ouviram o que foi dito: ‘Olho por olho, dente por dente.’ ");
INSERT INTO porblt_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mas eu lhes digo: não se oponham a quem lhes fizer o mal. Se alguém lhe der um tapa na cara, vire o outro lado para que ele bata também. ");
INSERT INTO porblt_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Se alguém quiser processá-lo e lhe tirar a camisa deixe que ele leve o seu casaco também. ");
INSERT INTO porblt_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Se alguém exigir que você caminhe um quilômetro, caminhe dois. ");
INSERT INTO porblt_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Dê a quem lhe pedir algo e não se afaste de quem lhe pedir algo emprestado. ");
INSERT INTO porblt_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Vocês ouviram o que foi dito: ‘Ame o seu vizinho e odeie o seu inimigo.’ ");
INSERT INTO porblt_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mas eu lhes digo: amem os seus inimigos e orem por aqueles que perseguem vocês; ");
INSERT INTO porblt_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","assim, vocês se tornarão filhos do seu Pai celestial. Pois o seu sol brilha tanto sobre os bons quanto sobre os maus; e ele faz a chuva cair tanto sobre quem faz o que é certo quanto sobre quem faz o que é errado. ");
INSERT INTO porblt_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pois, se vocês amam apenas quem os ama, que recompensa terão? Até mesmo os cobradores de impostos fazem isso! ");
INSERT INTO porblt_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Se vocês falarem gentilmente apenas com a sua família, o que é que estarão fazendo a mais do que as outras pessoas? Até os pagãos fazem isso! ");
INSERT INTO porblt_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Cresçam e tornem-se completamente dignos de confiança, exatamente como é digno de confiança o seu Pai Celestial. ");
INSERT INTO porblt_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Certifiquem-se de não praticar suas boas ações em público apenas para serem vistos pelos outros. Caso contrário, vocês não receberão qualquer recompensa do seu Pai que está no céu. ");
INSERT INTO porblt_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Quando vocês derem aos pobres, não sejam como os hipócritas, que tocam trombetas nas sinagogas e nas ruas para anunciar o que estão fazendo, para que as pessoas os elogiem. Eu lhes afirmo que isto é verdade: eles já têm a sua recompensa. ");
INSERT INTO porblt_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Quando vocês derem alguma coisa a uma pessoa necessitada, não deixem que a sua mão esquerda saiba o que a sua mão direita está fazendo. ");
INSERT INTO porblt_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Assim, o que vocês derem estará em segredo, e o seu Pai, que vê o que acontece em segredo, os recompensará. ");
INSERT INTO porblt_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Quando vocês orarem, não sejam como os hipócritas, pois eles gostam de ficar em pé e orar nas sinagogas e nas esquinas das ruas, para que as pessoas possam vê-los. Eu lhes afirmo que isso é verdade: eles já receberam a sua recompensa. ");
INSERT INTO porblt_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mas vocês, quando orarem, entrem, fechem a porta, e orem ao seu Pai sozinhos. E o seu Pai, que vê o que acontece em segredo, os recompensará. ");
INSERT INTO porblt_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Quando orarem, não balbuciem coisas sem sentido como os pagãos, que pensam que serão ouvidos por causa de todas as palavras que repetem. ");
INSERT INTO porblt_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Não sejam como eles, pois o seu Pai sabe do que vocês precisam, mesmo antes de lhe pedirem. ");
INSERT INTO porblt_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Então, orem assim: ");
INSERT INTO porblt_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pai nosso, que estás no céu, que o seu nome seja honrado. Venha o seu Reino! Que a sua vontade seja feita aqui na terra como é feita no céu. ");
INSERT INTO porblt_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Por favor, dá-nos hoje o alimento que precisamos. ");
INSERT INTO porblt_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Perdoa-nos as nossas ofensas, assim como perdoamos as pessoas que nos ofenderam. ");
INSERT INTO porblt_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Não deixes que sejamos tentados a fazer algo errado e livra-nos do mal. ");
INSERT INTO porblt_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Pois se vocês perdoarem àqueles que os ofenderam, seu Pai celestial também perdoará as ofensas de vocês. ");
INSERT INTO porblt_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mas, se vocês não perdoarem aqueles que os ofenderam, então, seu Pai celestial não perdoará as ofensas de vocês. ");
INSERT INTO porblt_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Quando vocês jejuarem, não sejam como os hipócritas, que fazem caras tristes e se apresentam com aspecto horrível, para que todos saibam que eles estão jejuando. Eu afirmo a vocês que isto é verdade: eles já têm a sua recompensa. ");
INSERT INTO porblt_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ao contrário, quando jejuarem, lavem o rosto e se arrumem. ");
INSERT INTO porblt_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Assim, as pessoas não verão que vocês estão jejuando, mas vocês serão vistos por seu Pai; e seu Pai, que vê o que acontece em segredo, os recompensará. ");
INSERT INTO porblt_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Não acumulem riquezas aqui na terra, onde traças e ferrugem as destroem e onde ladrões arrombam e as roubam. ");
INSERT INTO porblt_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ao contrário, vocês devem guardar suas riquezas no céu, onde traças e ferrugem não as destroem e onde ladrões não arrombam e as roubam. ");
INSERT INTO porblt_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pois, o que vocês mais valorizam mostra quem vocês realmente são. ");
INSERT INTO porblt_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Os olhos são como uma lâmpada que ilumina o corpo. Assim, se os seus olhos são saudáveis, então, todo o seu corpo ficará iluminado. ");
INSERT INTO porblt_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mas, se os seus olhos forem maus, então, todo o seu corpo ficará nas trevas. Se a luz que há em você são trevas, que terríveis serão essas trevas! ");
INSERT INTO porblt_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ninguém pode servir a dois mestres. Ou vocês odiarão um e amarão o outro, ou se dedicarão a um e desprezarão o outro. Vocês não podem servir a Deus e ao Dinheiro. ");
INSERT INTO porblt_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Por isso, eu lhes digo para não se preocuparem com a vida de vocês. Não se preocupem com o que comer, com o que beber ou com que roupas vestir. A vida não é mais do que comida? E o corpo não é mais do que roupas? ");
INSERT INTO porblt_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Vejam os pássaros – eles não semeiam, não colhem, nem guardam comida em celeiros, pois o seu Pai celestial os alimenta. Vocês não valem mais do que os pássaros? ");
INSERT INTO porblt_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Quem de vocês, por mais que se preocupe, pode encompridar a própria vida? ");
INSERT INTO porblt_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","E por que vocês estão preocupados com roupas? Vejam as lindas flores do campo. Vejam como elas crescem: elas não trabalham e nem fazem suas roupas. ");
INSERT INTO porblt_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mas eu afirmo a vocês que nem mesmo Salomão, com toda a sua riqueza, se vestia como essas flores. ");
INSERT INTO porblt_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Então, se Deus enfeita assim os campos, com a erva que está aqui hoje e que amanhã será jogada no fogo, ele não fará muito mais por vocês, que acreditam tão pouco? ");
INSERT INTO porblt_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Por isso, não se preocupem, dizendo: ‘O que comeremos hoje?’ ‘O que beberemos?’ ou: ‘O que vestiremos?’ ");
INSERT INTO porblt_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Essas são todas as coisas que os pagãos procuram, mas o seu Pai celestial sabe de tudo o que vocês precisam. ");
INSERT INTO porblt_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Busquem o seu Reino primeiro e o seu modo certo de viver, e tudo lhes será dado. ");
INSERT INTO porblt_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Então, não se preocupem com o amanhã, porque o amanhã pode se preocupar consigo mesmo. Já há mal suficiente em cada dia. ");
INSERT INTO porblt_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Não julguem os outros, para que vocês não sejam julgados. ");
INSERT INTO porblt_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pois seja qual for o padrão que usem para julgar os outros, o mesmo será usado para julgá-los, e seja qual for a medida que vocês usarem para medir os outros, a mesma será usada para medi-los. ");
INSERT INTO porblt_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Por que é que você vê o cisco que está no olho do seu irmão? Você não nota a tábua que está em seu próprio olho? ");
INSERT INTO porblt_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Como é que você pode dizer ao seu irmão: ‘Deixe-me tirar esse cisco do seu olho’, quando você está com uma tábua no seu próprio olho? ");
INSERT INTO porblt_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Você está sendo hipócrita! Tire primeiro a tábua que está em seu olho. Depois você será capaz de ver claramente para retirar o cisco do olho do seu irmão. ");
INSERT INTO porblt_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Não deem para os cães o que é sagrado. Não joguem suas pérolas aos porcos. Assim, os porcos não as pisarão, e os cães não se voltarão contra vocês e não os atacarão. ");
INSERT INTO porblt_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Peçam e lhes será dado; busquem e encontrarão; batam e a porta se abrirá para vocês. ");
INSERT INTO porblt_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Todos aqueles que pedem, recebem; todos aqueles que buscam, acham; e para todos aqueles que batem à porta, ela se abrirá. ");
INSERT INTO porblt_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Algum de vocês daria a seu filho uma pedra, se ele pedisse pão? ");
INSERT INTO porblt_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ou se ele pedisse peixe, dariam a ele uma cobra? ");
INSERT INTO porblt_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Então, se mesmo vocês, que são maus, sabem dar boas coisas a seus filhos, muito mais o seu Pai celestial dará coisas boas a quem lhe pedir. ");
INSERT INTO porblt_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tratem os outros como gostariam de ser tratados. Isso resume o que a lei e os profetas querem dizer. ");
INSERT INTO porblt_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Entrem pela porta estreita. Pois a porta que é ampla e o caminho que é largo levam à destruição, e muitos vão por esse caminho. ");
INSERT INTO porblt_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mas a entrada que é estreita e o caminho que é difícil levam à vida, e apenas poucas pessoas encontram esse caminho. ");
INSERT INTO porblt_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Cuidado com os falsos profetas! Eles chegam disfarçados de ovelhas, mas, na verdade, são lobos cruéis. ");
INSERT INTO porblt_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Vocês podem reconhecê-los por seus frutos. As pessoas colhem uvas dos espinheiros ou figos dos cardos? ");
INSERT INTO porblt_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Então, toda árvore boa produz bons frutos, enquanto uma árvore má produz frutos ruins. ");
INSERT INTO porblt_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Uma árvore boa não pode produzir frutos ruins e uma árvore ruim não pode produzir bons frutos. ");
INSERT INTO porblt_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Toda árvore que não produz bons frutos é cortada e jogada no fogo. ");
INSERT INTO porblt_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Então, vocês os reconhecerão por seus frutos. ");
INSERT INTO porblt_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nem todos aqueles que me chamam: ‘Senhor, Senhor’, entrarão no Reino do Céu. Apenas aqueles que fizerem a vontade do meu Pai entrarão no céu. ");
INSERT INTO porblt_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","No Dia do Julgamento, muitos dirão para mim: ‘Senhor, Senhor, em seu nome não fizemos profecias, expulsamos demônios e realizamos muitos milagres?’ ");
INSERT INTO porblt_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Então, lhes direi: ‘Eu nunca os conheci. Afastem-se de mim, vocês que praticam o mal!’ ");
INSERT INTO porblt_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Todos os que ouvem as palavras que eu digo e que as seguem são como um homem sábio, que construiu sua casa na rocha. ");
INSERT INTO porblt_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","A chuva caiu, vieram as enchentes e o vento soprou forte contra a casa, mas ela não caiu, porque a sua base foi construída na rocha. ");
INSERT INTO porblt_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Todos os que ouvem as palavras que eu digo e não as seguem são como um homem tolo, que construiu sua casa na areia. ");
INSERT INTO porblt_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","A chuva caiu, vieram as enchentes e o vento soprou forte contra a casa; ela desabou e ficou totalmente destruída.” ");
INSERT INTO porblt_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Quando Jesus acabou de explicar essas coisas, a multidão estava impressionada com a sua forma de ensinar, ");
INSERT INTO porblt_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","pois ele ensinava como alguém com autoridade e, não, como os educadores religiosos. ");
INSERT INTO porblt_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Uma grande multidão seguiu Jesus quando ele desceu do monte. ");
INSERT INTO porblt_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Um leproso aproximou-se dele e, ajoelhando-se, disse: “Senhor, se for da sua vontade, por favor, cure-me!” ");
INSERT INTO porblt_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesus estendeu a mão e o tocou. “Sim, eu quero!”, ele disse. “Você está curado!” Imediatamente, ele foi curado da lepra. ");
INSERT INTO porblt_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesus lhe disse: “Não fale isso para ninguém. Vá, apresente-se ao sacerdote e ofereça o sacrifício que Moisés exigiu como uma prova pública.” ");
INSERT INTO porblt_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Quando Jesus entrou na cidade de Cafarnaum, um comandante romano veio até ele, implorando sua ajuda: ");
INSERT INTO porblt_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Senhor, meu empregado está em casa, deitado, incapaz de se mover. Ele está sofrendo muito.” ");
INSERT INTO porblt_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus respondeu: “Eu irei curá-lo.” ");
INSERT INTO porblt_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","O comandante romano respondeu: “Senhor, eu não mereço que entre em minha casa. Apenas dê uma ordem e meu empregado será curado. ");
INSERT INTO porblt_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Pois eu mesmo estou sob o comando de oficiais superiores e também tenho soldados que estão sob minha autoridade. Eu ordeno a um deles: ‘Vá!’, e ele vai. Digo a outro: ‘Venha!’, e ele vem. Eu digo ao meu empregado: ‘Faça isto!’, e ele faz.” ");
INSERT INTO porblt_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Quando Jesus ouviu o que ele disse, ficou surpreso. Ele disse aos que o seguiam: “Eu lhes afirmo que isto é verdade: eu nunca vi tanta fé em qualquer lugar de Israel. ");
INSERT INTO porblt_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Eu lhes digo que muitas pessoas virão do Leste e do Oeste, e se sentarão com Abraão, Isaque e Jacó no Reino do Céu. ");
INSERT INTO porblt_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mas os herdeiros do Reino serão jogados na escuridão absoluta, onde chorarão e rangerão os dentes.” ");
INSERT INTO porblt_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Então, Jesus disse ao comandante romano: “Vá para casa! Por acreditar que aconteceria, o que você pediu foi feito.” O empregado foi imediatamente curado. ");
INSERT INTO porblt_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Quando Jesus chegou à casa de Pedro, percebeu que a sogra dele estava na cama, com febre. ");
INSERT INTO porblt_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ele tocou na mão dela e a febre passou. Ela se levantou e preparou uma refeição para Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Quando a noite chegou, o povo levou até Jesus muitas pessoas possuídas pelo demônio. Ele expulsou os espíritos maus com o seu comando e curou todos aqueles que estavam doentes. ");
INSERT INTO porblt_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Assim se cumpriu o que o profeta Isaías disse: “Ele curou nossas doenças e nos libertou de nossas enfermidades.” ");
INSERT INTO porblt_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Quando Jesus viu a multidão ao seu redor, ele ordenou que eles fossem para o outro lado do lago. ");
INSERT INTO porblt_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Um dos educadores religiosos se aproximou dele e disse: “Mestre, eu o seguirei aonde você for!” ");
INSERT INTO porblt_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus lhe disse: “As raposas têm as suas tocas e os pássaros têm os seus ninhos, mas o Filho do Homem não tem onde descansar.” ");
INSERT INTO porblt_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Outro discípulo disse para Jesus: “Senhor, permita-me primeiro voltar e sepultar o meu pai.” ");
INSERT INTO porblt_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“Siga-me! Deixe que os mortos sepultem os seus mortos”, Jesus respondeu. ");
INSERT INTO porblt_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Então, Jesus subiu em um barco e os seus discípulos foram com ele. ");
INSERT INTO porblt_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","De repente, chegou uma tempestade violenta, que fazia as ondas cobrirem o barco, mas Jesus continuava dormindo. ");
INSERT INTO porblt_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Os discípulos chegaram perto dele e o acordaram. “Senhor, salve-nos! Nós iremos morrer!”, eles gritaram. ");
INSERT INTO porblt_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","“Por que vocês estão com tanto medo? Por que vocês têm fé tão pequena?”, ele perguntou. Então, ele se levantou e ordenou que os ventos e as ondas parassem. Tudo ficou absolutamente calmo. ");
INSERT INTO porblt_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Os discípulos ficaram admirados e disseram: “Quem é este? Até mesmo os ventos e as ondas lhe obedecem!” ");
INSERT INTO porblt_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Quando ele chegou ao outro lado, na região de Gadara, dois homens possuídos por demônios saíram do cemitério para encontrá-lo. Eles eram tão perigosos que ninguém se atrevia a passar por aquele caminho. ");
INSERT INTO porblt_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Eles gritaram: “Filho de Deus, o que você quer de nós? Você veio nos castigar antes do tempo?” ");
INSERT INTO porblt_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Próximo dali havia muitos porcos que se alimentavam. ");
INSERT INTO porblt_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Os demônios suplicaram a ele: “Se você vai nos expulsar, mande-nos para aqueles porcos.” ");
INSERT INTO porblt_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesus disse: “Vão!” Os demônios saíram dos homens e entraram nos porcos. Todos os porcos se jogaram da encosta e se afogaram no mar. ");
INSERT INTO porblt_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Os homens que tomavam conta dos porcos fugiram. Eles chegaram à cidade e contaram para as pessoas de lá tudo o que havia acontecido com os porcos e com os homens possuídos por demônios. ");
INSERT INTO porblt_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Todos os moradores da cidade foram conhecer Jesus. Quando eles o encontraram, imploraram para que ele fosse embora daquela região. ");
INSERT INTO porblt_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Assim, Jesus subiu em um barco, atravessando o lago de volta para a cidade em que ele morava. ");
INSERT INTO porblt_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chegando lá, as pessoas levaram até ele um paralítico que estava em uma esteira. Quando Jesus viu como eles confiavam nele, disse para o paralítico: “Meu amigo, alegre-se! Os seus pecados estão perdoados.” ");
INSERT INTO porblt_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Naquele momento, alguns educadores religiosos disseram uns para os outros: “Ele está dizendo blasfêmias!” ");
INSERT INTO porblt_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mas Jesus sabia o que eles pensavam. Ele perguntou: “Por que vocês abrigam esses maus pensamentos em sua mente? ");
INSERT INTO porblt_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","O que é mais fácil dizer: ‘Os seus pecados estão perdoados’ ou ‘Levante-se e ande’? ");
INSERT INTO porblt_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mas para convencê-los de que eu, o Filho do Homem, tenho autoridade para perdoar pecados, digo ao paralítico: levante-se, pegue a sua esteira e vá para casa!” ");
INSERT INTO porblt_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","O homem se levantou e foi para casa. ");
INSERT INTO porblt_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","A multidão ficou assustada ao ver o que havia acontecido. Então, eles louvaram a Deus por ter dado aos seres humanos esse poder. ");
INSERT INTO porblt_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ao sair dali, Jesus viu um homem chamado Mateus, sentado no lugar em que cobrava impostos. Jesus lhe disse: “Siga-me!” Ele se levantou e seguiu Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Enquanto Jesus comia na casa de Mateus, muitos cobradores de impostos e pecadores vieram e sentaram-se à mesa com Jesus e com os seus discípulos. ");
INSERT INTO porblt_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Quando os fariseus viram isso, eles perguntaram aos discípulos de Jesus: “Por que o seu Mestre come com cobradores de impostos e pecadores?” ");
INSERT INTO porblt_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Quando Jesus ouviu a pergunta, respondeu: “As pessoas que estão bem não precisam de um médico, mas os doentes precisam. ");
INSERT INTO porblt_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Vão e tentem entender o que isso significa: ‘Eu quero compaixão, e não sacrifício.’ Pois eu não vim chamar quem faz o que é certo; eu vim chamar os pecadores.” ");
INSERT INTO porblt_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Depois, os discípulos de João vieram e perguntaram: “Por que é que nós e os fariseus jejuamos muitas vezes, mas os seus discípulos não?” ");
INSERT INTO porblt_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","“Os convidados de um casamento ficam tristes enquanto o noivo está com eles?” Jesus respondeu. “Mas chegará o momento em que o noivo se afastará de perto deles e, então, eles irão jejuar. ");
INSERT INTO porblt_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ninguém coloca um retalho de pano novo em uma roupa velha, caso contrário, o retalho encolheria e aumentaria o rasgo da roupa. ");
INSERT INTO porblt_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ninguém também coloca vinho novo em odres velhos, porque senão, os odres arrebentariam, derramariam o vinho e ficariam estragados. Pelo contrário, o vinho novo é colocado em odres novos e, assim, os dois não estragam.” ");
INSERT INTO porblt_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Enquanto Jesus falava isso, um dos chefes se aproximou e se curvou diante dele. Ele disse para Jesus: “Minha filha acabou de morrer. Mas se você vier e colocar a mão sobre ela, eu sei que ela viverá novamente.” ");
INSERT INTO porblt_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesus e seus discípulos foram com ele. ");
INSERT INTO porblt_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Naquele momento, uma mulher, que tinha uma hemorragia que já durava doze anos, veio por trás de Jesus e tocou na barra da capa dele. ");
INSERT INTO porblt_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ela pensou: “Se eu conseguir apenas tocar na sua roupa, ficarei curada.” ");
INSERT INTO porblt_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus se virou e viu a mulher. “Fique feliz! Por ter acreditado em mim, você foi curada”, ele lhe disse. E, assim, a mulher foi curada. ");
INSERT INTO porblt_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesus chegou na casa do chefe. Ele viu os flautistas e as pessoas que choravam, numa grande confusão. ");
INSERT INTO porblt_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ele lhes disse: “Por favor, saiam! A menina não está morta; ela está apenas dormindo.” Mas eles riram e zombaram dele. ");
INSERT INTO porblt_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Assim que a multidão saiu, ele se aproximou da menina e pegou a sua mão e ela se levantou. ");
INSERT INTO porblt_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A notícia do que havia acontecido se espalhou por toda a região. ");
INSERT INTO porblt_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Quando Jesus saiu dali, dois cegos o seguiram, gritando: “Filho de Davi, por favor, tenha pena de nós!” ");
INSERT INTO porblt_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Quando Jesus chegou na casa em que estava recebendo abrigo, os cegos se aproximaram. Jesus lhes perguntou: “Vocês creem que eu sou capaz de fazer isso?” Eles responderam: “Sim, Senhor!” ");
INSERT INTO porblt_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Então, Jesus tocou os olhos deles e disse: “Porque vocês creem em mim, assim acontecerá!” ");
INSERT INTO porblt_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","E eles conseguiram enxergar novamente. Naquele momento Jesus os avisou: “Não contem isso para ninguém!” ");
INSERT INTO porblt_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mas eles saíram e espalharam a notícia a respeito de Jesus em todos os lugares. ");
INSERT INTO porblt_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Quando Jesus e os seus discípulos estavam indo embora, um homem mudo e possuído por um demônio foi levado até ele. ");
INSERT INTO porblt_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Assim que o demônio foi expulso, o homem começou a falar, e a multidão ficou maravilhada. As pessoas disseram: “Nunca antes aconteceu uma coisa como essa em Israel!” ");
INSERT INTO porblt_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mas os fariseus responderam: “Ele expulsa os demônios, usando o poder do chefe dos demônios.” ");
INSERT INTO porblt_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus viajou, visitando as cidades e vilas. Ele ensinava nas sinagogas, falando a respeito da boa notícia do Reino e curava todo tipo de enfermidade e doenças. ");
INSERT INTO porblt_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Quando Jesus viu as multidões, ele ficou com muita pena daquelas pessoas, porque elas estavam desesperadas e abandonadas, como ovelhas sem um pastor. ");
INSERT INTO porblt_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ele disse aos seus discípulos: “A colheita é grande, mas temos apenas alguns trabalhadores. ");
INSERT INTO porblt_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Peçam ao dono da plantação que envie mais trabalhadores para fazer a colheita.” ");
INSERT INTO porblt_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus reuniu seus doze discípulos e lhes deu poder para que expulsassem os espíritos maus e para que curassem todos os tipos de doenças e de enfermidades. ");
INSERT INTO porblt_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Estes são os nomes dos doze apóstolos: primeiro, Simão (também conhecido como Pedro) e o seu irmão André; Tiago e o seu irmão João, filhos de Zebedeu; ");
INSERT INTO porblt_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipe e Bartolomeu; Tomé e Mateus, o cobrador de impostos; Tiago, filho de Alfeu, e Tadeu; ");
INSERT INTO porblt_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simão, o revolucionário e Judas Iscariotes, que traiu Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesus enviou esses doze homens, dizendo: “Não vão a qualquer cidade pagã ou samaritana. ");
INSERT INTO porblt_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Vocês devem procurar as ovelhas perdidas da casa de Israel. ");
INSERT INTO porblt_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Onde quer que estejam, digam às pessoas: ‘O Reino do Céu está próximo.’ ");
INSERT INTO porblt_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Curem as pessoas que estiverem doentes. Ressuscitem os mortos. Curem os leprosos. Expulsem os demônios. Vocês receberam de graça; então, deem de graça também. ");
INSERT INTO porblt_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Não guardem ouro, prata ou moedas de cobre em seus bolsos. ");
INSERT INTO porblt_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nem levem para a sua jornada uma bolsa, dois mantos ou sandálias, ou uma bengala, pois um trabalhador merece receber o seu sustento. ");
INSERT INTO porblt_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Onde quer que estejam, em qualquer cidade ou vila, peçam a alguém, que viva de acordo com os bons princípios, para recebê-los em sua casa e fiquem nessa casa até irem embora do lugar. ");
INSERT INTO porblt_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Quando entrarem na casa, abençoem esse lugar. ");
INSERT INTO porblt_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Se a casa merecer, deixem que a sua paz fique aí, mas se a casa não merecer, façam com que a sua paz retorne para vocês. ");
INSERT INTO porblt_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Se alguém não quiser recebê-los e se recusar a ouvir o que vocês têm a dizer, então, saiam da casa ou da cidade e, ao sair, sacudam o pó de seus pés. ");
INSERT INTO porblt_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Eu afirmo a vocês que isto é verdade: no Dia do Julgamento, Sodoma e Gomorra serão menos cobradas do que aquela cidade. ");
INSERT INTO porblt_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Atenção! Eu os envio como ovelhas para o meio de lobos. Então, sejam espertos como as serpentes e inocentes como as pombas. ");
INSERT INTO porblt_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tenham cuidado, pois os entregarão para serem julgados pelos tribunais e chicoteados nas suas sinagogas. ");
INSERT INTO porblt_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Por me seguirem, vocês serão levados aos governadores e reis para testemunharem diante deles e dos pagãos. ");
INSERT INTO porblt_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mas quando eles os julgarem, não se preocupem como devem falar ou sobre o que devem dizer, pois vocês saberão o que dizer no momento certo. ");
INSERT INTO porblt_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Porque não serão vocês que falarão, mas, sim, o Espírito do Pai é que falará por intermédio de vocês. ");
INSERT INTO porblt_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Um irmão trairá seu outro irmão e o matará, e um pai fará o mesmo com o seu filho. Os filhos ficarão contra os seus pais e os matarão. ");
INSERT INTO porblt_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Por me seguirem, todos os odiarão. Mas, aqueles que ficarem firmes até o final serão salvos. ");
INSERT INTO porblt_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Quando vocês forem perseguidos em uma cidade, fujam para a próxima. Eu afirmo a vocês que isto é verdade: vocês não terão percorrido todas as cidades de Israel antes que o Filho do Homem chegue. ");
INSERT INTO porblt_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Os alunos não são mais importantes do que o seu professor. Os empregados não são mais importantes do que o seu patrão. ");
INSERT INTO porblt_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Os alunos devem ficar felizes por serem como o seu professor, e os empregados por serem como o seu patrão. Se o dono da casa for xingado pelo nome do chefe dos demônios, Belzebu, então, os membros da sua família serão ainda mais xingados. ");
INSERT INTO porblt_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Por isso, não tenham medo deles, pois não há nada encoberto que não venha a ser exposto e não há nada que esteja escondido que não venha a ser conhecido. ");
INSERT INTO porblt_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","O que eu digo para vocês, aqui no escuro, repitam quando for dia, e o que é sussurrado em seus ouvidos gritem para que todos ouçam. ");
INSERT INTO porblt_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Não tenham medo das pessoas que podem matá-los fisicamente, mas não podem matá-los espiritualmente. Ao contrário, tenham medo daquele que pode destruí-los física e espiritualmente nas fogueiras da Geena. ");
INSERT INTO porblt_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Dois passarinhos não são vendidos apenas por alguns centavos? Mas, nenhum deles cai no chão sem que o seu Pai saiba. ");
INSERT INTO porblt_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mesmo os cabelos em sua cabeça foram todos contados. ");
INSERT INTO porblt_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Então, não se preocupem! Vocês valem mais do que muitos pássaros. ");
INSERT INTO porblt_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Qualquer pessoa que publicamente afirmar que está comprometida comigo, eu também irei afirmar que estou comprometido com ela, diante do meu Pai, que está no céu. ");
INSERT INTO porblt_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mas quem me negar diante de todos, eu também o negarei diante do meu Pai, que está no céu. ");
INSERT INTO porblt_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Não pensem que eu vim trazer paz ao mundo. Eu não vim trazer paz, mas espada. ");
INSERT INTO porblt_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Eu vim ‘para fazer o homem ficar contra o seu pai, a filha contra a sua mãe e a nora contra a sua sogra. ");
INSERT INTO porblt_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Os seus inimigos serão os seus próprios parentes!’ ");
INSERT INTO porblt_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Se você ama o seu pai ou a sua mãe mais do que me ama, então, não merece pertencer a mim. Se você ama o seu filho ou a sua filha mais do que a mim, então, não merece pertencer a mim. ");
INSERT INTO porblt_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Se você não pegar a sua cruz e me seguir, então, não merece pertencer a mim. ");
INSERT INTO porblt_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Se tentar salvar a sua vida, você a perderá. Mas se você perder a sua vida, por mim, você será salvo. ");
INSERT INTO porblt_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Aqueles que receberem vocês estarão me recebendo, e aqueles que me receberem estarão recebendo quem me enviou. ");
INSERT INTO porblt_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aqueles que recebem um profeta, porque este é profeta, receberão a mesma recompensa que ele. Aqueles que receberem uma pessoa que faz o bem receberão a mesma recompensa que ela. ");
INSERT INTO porblt_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Eu afirmo a vocês que isto é verdade: aqueles que derem um copo de água fria ao menos importante dos meus discípulos, certamente irão receber a sua recompensa.” ");
INSERT INTO porblt_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Quando Jesus acabou de orientar seus doze discípulos, ele saiu dali e foi ensinar e divulgar sua mensagem nas cidades próximas. ");
INSERT INTO porblt_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na cadeia, João Batista ouviu dizer o que o Messias estava fazendo. Então, ele enviou os seus discípulos ");
INSERT INTO porblt_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","para perguntar em seu nome: “Você é aquele que estávamos esperando vir ou devemos continuar a nossa procura?” ");
INSERT INTO porblt_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus respondeu: “Voltem e digam a João Batista o que vocês ouvem e o que veem. ");
INSERT INTO porblt_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Os cegos podem ver, os paralíticos podem andar, os leprosos são curados, os surdos podem ouvir, os mortos são ressuscitados e os pobres ouvem o evangelho. ");
INSERT INTO porblt_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Abençoados são aqueles que não me rejeitam!” ");
INSERT INTO porblt_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Quando os discípulos de João saíram, Jesus começou a falar para a multidão sobre João Batista. “O que vocês esperavam ver quando foram para o deserto? Um junco que o vento agitava? ");
INSERT INTO porblt_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Então, o que vocês foram ver? Um homem muito bem-vestido? Bem, pessoas que se vestem com roupas finas moram nos palácios dos reis. ");
INSERT INTO porblt_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Então, o que afinal de contas vocês foram ver? Um profeta? Sim, e eu lhes digo que ele é muito mais do que um profeta. ");
INSERT INTO porblt_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ele é aquele de quem está escrito: ‘Eu estou enviando o meu mensageiro antes de você. Ele irá preparar o seu caminho.’ ");
INSERT INTO porblt_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Eu afirmo a vocês que isto é verdade: na humanidade não há pessoa mais importante do que João Batista. Mas mesmo o menos importante no Reino do Céu é mais importante do que ele. ");
INSERT INTO porblt_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Desde João Batista até agora, o Reino do Céu é tomado por esforço, e os que se esforçam se apoderam dele. ");
INSERT INTO porblt_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Até João vir, todos os profetas e a lei falavam em nome de Deus. ");
INSERT INTO porblt_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Se vocês estiverem preparados para acreditar, ele é Elias, aquele que estava para vir. ");
INSERT INTO porblt_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aqueles que têm ouvidos, ouçam! ");
INSERT INTO porblt_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Com que eu posso comparar esta geração de hoje? São como crianças sentadas na praça, gritando umas para as outras: ");
INSERT INTO porblt_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nós tocamos flauta, mas vocês não dançaram. Cantamos canções tristes e vocês não choraram.’ ");
INSERT INTO porblt_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","João não veio para festejar e beber. Então, as pessoas dizem: ‘Ele está possuído pelo demônio!’ ");
INSERT INTO porblt_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Por outro lado, o Filho do Homem come e bebe, e as pessoas dizem: ‘Vejam! Ele é guloso e bebe muito. Ele é amigo dos cobradores de impostos e dos pecadores.’ Mas é pelo que se faz que se mostra a verdadeira sabedoria.” ");
INSERT INTO porblt_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Então, Jesus começou a reprovar as cidades em que ele tinha feito a maioria dos seus milagres. Ele as criticou porque os seus moradores não tinham se arrependido dos seus pecados. ");
INSERT INTO porblt_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ai de você, Corazim! Ai de você, Betsaida! Se os milagres que foram realizados entre vocês tivessem sido feitos em Tiro e em Sidom, os habitantes dessas cidades já teriam se arrependido há muito tempo. Eles vestiriam roupas de saco e se cobririam de cinzas, para mostrar o seu sentimento. ");
INSERT INTO porblt_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mas eu lhes digo que no Dia do Julgamento haverá mais compaixão por Tiro e Sidom do que por vocês. ");
INSERT INTO porblt_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","E você, cidade de Cafarnaum? Acha que será elevada até os céus? Não, você será jogada no mundo dos mortos! Se os milagres feitos entre vocês tivessem sido realizados na cidade de Sodoma, ela ainda existiria hoje. ");
INSERT INTO porblt_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mas eu lhes digo que no Dia do Julgamento haverá mais compaixão por Sodoma do que por vocês.” ");
INSERT INTO porblt_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Então, Jesus orou: “Agradeço a você, Pai, Senhor do céu e da terra, porque esconde estas coisas dos inteligentes e dos intelectuais, mas as revela às pessoas simples. ");
INSERT INTO porblt_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Sim, Pai, isso o deixa feliz! ");
INSERT INTO porblt_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Meu Pai me deu tudo. E ninguém entende mais o Filho do que o Pai. E ninguém entende mais o Pai do que o Filho e do que aqueles para quem o Filho escolher mostrar seu Pai. ");
INSERT INTO porblt_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Venham a mim, todos que lutam e que carregam um peso grande demais. Eu lhes darei descanso. ");
INSERT INTO porblt_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Aceitem a minha orientação e aprendam comigo. Porque eu sou gentil e tenho um coração humilde. E em mim, vocês encontrarão o descanso que precisam. ");
INSERT INTO porblt_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Porque a minha autoridade é suave e a minha carga é leve.” ");
INSERT INTO porblt_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Naquela ocasião, num sábado, Jesus estava caminhando por campos de trigo. Os seus discípulos estavam com fome e, por isso, começaram a colher espigas de trigo e a comê-las. ");
INSERT INTO porblt_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Quando os fariseus viram aquilo, disseram a Jesus: “Veja! Os seus discípulos estão fazendo algo que é proibido aos sábados!” ");
INSERT INTO porblt_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mas Jesus lhes disse: “Vocês não leram o que Davi fez quando ele e os seus companheiros estavam com fome? ");
INSERT INTO porblt_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ele foi até a casa de Deus, e ele e os seus companheiros comeram o pão sagrado, o que não era permitido, pois apenas os sacerdotes poderiam comer esse pão. ");
INSERT INTO porblt_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Vocês não leram na lei que, aos sábados, os sacerdotes no Templo violam as regras, mas não são considerados culpados? ");
INSERT INTO porblt_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","No entanto, eu lhes digo que há alguém aqui que é mais importante do que o Templo. ");
INSERT INTO porblt_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Se vocês soubessem o que realmente significa: ‘Eu quero compaixão, não sacrifício’, vocês não condenariam inocentes. ");
INSERT INTO porblt_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pois o Filho do Homem é o Senhor do sábado.” ");
INSERT INTO porblt_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Então, Jesus saiu dali e foi para uma sinagoga. ");
INSERT INTO porblt_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ali estava um homem que tinha uma deficiência na mão. Algumas pessoas que queriam acusar Jesus perguntaram a ele: “A lei permite que se cure aos sábados?” ");
INSERT INTO porblt_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","“Suponha que vocês tenham uma ovelha e que ela caia em um buraco em pleno sábado. Vocês não irão tentar de tudo para tirá-la do buraco?” Jesus lhes perguntou: ");
INSERT INTO porblt_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","“Vocês não acham que um ser humano vale mais do que uma ovelha? Então, sim, é permitido fazer o bem aos sábados.” ");
INSERT INTO porblt_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ele se virou para o homem e disse: “Estenda a sua mão!” O homem estendeu a mão e ela foi curada e ficou exatamente como a outra. ");
INSERT INTO porblt_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Os fariseus saíram de lá e começaram a planejar como matar Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sabendo disso, Jesus foi embora dali, com uma grande multidão seguindo-o. Ele curou todos, ");
INSERT INTO porblt_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","mas os orientou para que não contassem para as pessoas sobre quem ele era. ");
INSERT INTO porblt_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Assim se cumpriu o que o profeta Isaías disse: ");
INSERT INTO porblt_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Este é o servo a quem escolhi, A quem amo e que me dá muita alegria. Eu colocarei o meu Espírito nele, E ele anunciará aos pagãos o que é correto. ");
INSERT INTO porblt_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","E ninguém ouvirá a sua voz nas ruas. Ele não fará discursos nas ruas. ");
INSERT INTO porblt_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ele não quebrará o galho que está rachado, E não apagará o fogo no pavio, Até que tenha provado que o seu julgamento é justo, ");
INSERT INTO porblt_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","E os pagãos irão pôr nele a sua esperança.” ");
INSERT INTO porblt_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Então, levaram a Jesus um homem que estava possuído por um demônio e que era cego e mudo. Jesus o curou, e o mudo pôde falar e ver. ");
INSERT INTO porblt_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Todas as pessoas ficaram maravilhadas e perguntaram: “Será que este homem é realmente o Filho de Davi?” ");
INSERT INTO porblt_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mas quando os fariseus ouviram isso, eles responderam: “Este homem só consegue expulsar os demônios, usando o poder de Belzebu, o chefe dos demônios!” ");
INSERT INTO porblt_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sabendo o que os fariseus pensavam, Jesus lhes disse: “Qualquer reino que esteja dividido, em que seus habitantes lutam entre si, será destruído. Nenhuma cidade ou família poderá se manter, se estiver dividida e cujos membros lutam entre si. ");
INSERT INTO porblt_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Se Satanás expulsar Satanás, então, ele estará dividido e lutando contra si mesmo. Então, como poderia seu reino se manter? ");
INSERT INTO porblt_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Se eu expulso demônios em nome de Belzebu, em nome de quem o seu povo expulsa os demônios? É o seu próprio povo que mostra como vocês estão errados! ");
INSERT INTO porblt_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mas, se eu expulso demônios pelo poder do Espírito de Deus, então, o Reino de Deus já chegou até vocês! ");
INSERT INTO porblt_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Vocês poderiam entrar na casa de um homem forte e roubar seus pertences sem primeiro amarrá-lo? Se vocês o amarrarem, poderão levar tudo o que ele tem em sua casa. ");
INSERT INTO porblt_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Aqueles que não estão comigo estão contra mim. E aqueles que não me ajudam a ajuntar estão fazendo o oposto, ou seja, estão espalhando. ");
INSERT INTO porblt_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","É por isso que eu lhes digo que todo o pecado e toda a blasfêmia que vocês cometerem serão perdoados. Mas não será perdoada a blasfêmia dita contra o Espírito. ");
INSERT INTO porblt_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Quem disser algo contra o Filho do Homem será perdoado. Mas quem disser algo contra o Espírito Santo não será perdoado, nem nesta vida e nem na próxima. ");
INSERT INTO porblt_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Decidam se a árvore é boa e dá bons frutos ou se a árvore é ruim e dá frutos ruins, pois a árvore é conhecida pelos frutos que nela nasce. ");
INSERT INTO porblt_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ninhada de cobras venenosas! Como vocês, que são maus, podem dizer algo bom? Pois a boca simplesmente fala daquilo que a mente está cheia. ");
INSERT INTO porblt_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Uma pessoa boa tira o bem do seu depósito de coisas boas, e uma pessoa má tira o mal do seu depósito de coisas ruins. ");
INSERT INTO porblt_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Eu lhes digo que, no Dia do Julgamento, todos terão que prestar contas por todas as palavras inúteis que disseram. ");
INSERT INTO porblt_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pois o que vocês dizem mostrará se são inocentes ou culpados.” ");
INSERT INTO porblt_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Então, alguns educadores religiosos e fariseus se aproximaram de Jesus e disseram: “Mestre, queremos ver você fazer um milagre.” ");
INSERT INTO porblt_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","“São as pessoas más, que não confiam em Deus, que buscam um sinal de milagre. O único sinal que elas terão será o sinal do profeta Jonas”, Jesus disse a eles. ");
INSERT INTO porblt_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","“Da mesma forma que Jonas ficou no estômago de um grande peixe durante três dias e três noites, o Filho do Homem ficará por três dias e três noites no fundo da terra. ");
INSERT INTO porblt_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Os habitantes de Nínive se levantarão e acusarão esta geração, pois eles se arrependeram dos seus pecados, respondendo à mensagem de Jonas. E como vocês podem ver, há alguém aqui que é mais importante do que Jonas. ");
INSERT INTO porblt_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","A Rainha de Sabá se levantará e acusará esta geração, pois ela veio de muito longe para ouvir os sábios ensinamentos de Salomão. E como vocês podem ver, há alguém aqui que é mais importante do que Salomão. ");
INSERT INTO porblt_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Quando um espírito mau sai de alguém, ele anda por lugares desertos, procurando descanso e não encontra nenhum lugar para descansar. ");
INSERT INTO porblt_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Então, ele diz: ‘Eu voltarei para o lugar de onde saí.’ E quando ele volta, encontra o lugar vazio, todo limpo e arrumado. ");
INSERT INTO porblt_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aí, ele sai e retorna com outros sete espíritos ainda piores do que ele, e todos entram e ficam morando ali. Assim, a pessoa fica em uma pior situação do que estava no início. É isso que acontecerá com esta geração perversa.” ");
INSERT INTO porblt_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Enquanto ele falava para a multidão, a sua mãe e os seus irmãos chegaram e ficaram do lado de fora, esperando para falar com ele. ");
INSERT INTO porblt_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Uma pessoa veio e disse para Jesus: “Escute! A sua mãe e os seus irmãos estão lá fora, esperando para falar com você.” ");
INSERT INTO porblt_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesus perguntou: “Quem é a minha mãe? Quem são os meus irmãos?” ");
INSERT INTO porblt_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ele apontou para os seus discípulos e disse: “Vejam! Eles são a minha mãe e os meus irmãos. ");
INSERT INTO porblt_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pois quem faz a vontade do meu Pai celestial é meu irmão, minha irmã e minha mãe.” ");
INSERT INTO porblt_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mais tarde, naquele mesmo dia, Jesus saiu de casa e se sentou para ensinar perto do lago. ");
INSERT INTO porblt_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Foram tantas as pessoas que se reuniram em volta dele, que ele entrou em um barco e lá se sentou para ensinar, enquanto as pessoas ficaram na praia. ");
INSERT INTO porblt_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ele explicou muitas coisas para eles, usando histórias como exemplos. “Certo homem saiu para semear”, ele começou a contar. ");
INSERT INTO porblt_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","“Enquanto realizava a semeadura, algumas sementes caíram pelo caminho. Os pássaros vieram e as comeram. ");
INSERT INTO porblt_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Outras sementes caíram no chão duro como pedra, em que havia pouca terra. As sementes brotaram rapidamente. ");
INSERT INTO porblt_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","O sol veio e as queimou e elas secaram, porque não tinham raízes. ");
INSERT INTO porblt_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Outras sementes caíram entre espinhos, que cresceram e sufocaram as plantas. ");
INSERT INTO porblt_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Outra parte das sementes caiu em uma terra boa. Elas produziram uma colheita – algumas cem, algumas sessenta e algumas trinta vezes o que tinha sido plantado. ");
INSERT INTO porblt_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Quem tem ouvidos para ouvir, ouça!” ");
INSERT INTO porblt_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Os discípulos vieram até Jesus e perguntaram: “Por que você usa exemplos quando fala com as pessoas?” Jesus respondeu: ");
INSERT INTO porblt_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","“Vocês são privilegiados, pois os mistérios do Reino do Céu lhes foram revelados, mas a eles, esse conhecimento não foi dado. ");
INSERT INTO porblt_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aqueles que já têm receberão mais, muito mais do que o bastante. Mas aqueles que não têm, até o pouco que têm lhes será tirado. ");
INSERT INTO porblt_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","É por isso que eu falo com eles por meio de exemplos. Pois eles olham e não enxergam; escutam e não ouvem, nem entendem. ");
INSERT INTO porblt_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","A profecia de Isaías se cumpre neles: ‘Mesmo que vocês escutem, não entenderão. E mesmo que vocês vejam, não perceberão. ");
INSERT INTO porblt_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Eles são insensíveis, não querem escutar e fecham os seus olhos. Se eles não fizessem assim, seriam capazes de ver com os seus olhos, ouvir com os seus ouvidos e de entender com a mente. Então, eles poderiam voltar para mim e eu os curaria.’ ");
INSERT INTO porblt_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Vocês são felizes, pois os seus olhos veem e os seus ouvidos ouvem. ");
INSERT INTO porblt_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Eu lhes digo: muitos profetas e boas pessoas desejaram ver o que vocês estão vendo, mas não viram. Eles desejaram ouvir o que vocês estão ouvindo, mas não ouviram. ");
INSERT INTO porblt_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Então, escutem e entendam a história do homem que semeava. ");
INSERT INTO porblt_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Quando as pessoas ouvem a mensagem sobre o Reino e não a compreendem, o maligno aparece e arranca o que foi semeado nelas. Isso é o que acontece com as sementes que foram semeadas na beira do caminho. ");
INSERT INTO porblt_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","As sementes que foram semeadas onde havia muitas pedras são as pessoas que ouvem a mensagem e, no mesmo instante, alegremente, a aceitam. ");
INSERT INTO porblt_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Elas duram um pouco, porque, por não terem raízes, quando os problemas e as confusões chegam, elas logo abandonam a mensagem. ");
INSERT INTO porblt_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","As sementes que caíram entre os espinhos são as pessoas que ouvem a mensagem, mas, então, as preocupações da vida e a tentação do dinheiro sufocam a mensagem, fazendo com que elas não produzam frutos. ");
INSERT INTO porblt_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","As sementes que se desenvolveram em um bom solo são as pessoas que ouvem a mensagem e a compreendem e que produzem uma boa colheita – algumas cem, algumas sessenta e algumas trinta vezes o que tinha sido plantado.” ");
INSERT INTO porblt_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Então, ele lhes contou outra história, por meio de exemplos: “O Reino do Céu é como um homem que semeou boas sementes em seu campo. ");
INSERT INTO porblt_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mas, enquanto os seus empregados estavam dormindo, um inimigo veio e jogou sementes de ervas daninhas sobre a plantação de trigo. E depois foi embora. ");
INSERT INTO porblt_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Então, quando o trigo cresceu e produziu espigas de trigo, as ervas daninhas também cresceram. ");
INSERT INTO porblt_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Os empregados do dono do campo chegaram e perguntaram a ele: ‘Senhor, você não semeou boas sementes em seu campo? De onde vieram as ervas daninhas?’ ");
INSERT INTO porblt_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Algum inimigo fez isso,’ ele respondeu. E eles perguntaram: ‘Você quer que nós arranquemos as ervas daninhas?’ O patrão respondeu: ");
INSERT INTO porblt_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Não. Porque, quando vocês arrancarem as ervas daninhas, poderão arrancar também o trigo. ");
INSERT INTO porblt_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Deixem que eles cresçam juntos até a época da colheita. Então, eu direi a quem for trabalhar na colheita para primeiro juntar as ervas daninhas, fazer feixes e queimá-las. Depois, que juntem o trigo e os guarde em meu celeiro.’” ");
INSERT INTO porblt_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus lhes deu outro exemplo: “O Reino do Céu é como a semente de mostarda, que um fazendeiro plantou em seu campo. ");
INSERT INTO porblt_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mesmo que ela seja a menor das sementes, ao crescer, torna-se muito maior do que as outras hortaliças. Na verdade, ela se torna uma árvore grande o bastante para que os pássaros façam ninhos em seus galhos.” ");
INSERT INTO porblt_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ele lhes contou mais uma história: “O Reino do Céu é como o fermento, que uma mulher misturou em uma grande quantidade de farinha, até que toda a massa tivesse crescido.” ");
INSERT INTO porblt_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus explicou todas essas coisas para a multidão, usando histórias como exemplo. Na verdade, ele sempre falava com elas usando histórias. ");
INSERT INTO porblt_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Assim se cumpriu o que o profeta disse: “Eu falarei usando histórias e explicarei coisas desconhecidas desde a criação do mundo.” ");
INSERT INTO porblt_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Então, Jesus deixou a multidão e voltou para casa. Seus discípulos juntaram-se a ele e pediram: “Por favor, explique para nós a história das ervas daninhas no campo.” ");
INSERT INTO porblt_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","“Quem semeia as sementes boas é o Filho do Homem”, Jesus explicou. ");
INSERT INTO porblt_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","“O campo representa o mundo. As boas sementes são os filhos do Reino. As sementes de erva daninha são os filhos do maligno. ");
INSERT INTO porblt_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","O inimigo que semeou as sementes de erva daninha é o diabo. A colheita é o fim do mundo. Os que trabalham na colheita são os anjos. ");
INSERT INTO porblt_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Da mesma maneira que as ervas daninhas são colhidas e queimadas, no fim do mundo acontecerá o mesmo. ");
INSERT INTO porblt_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","O Filho do Homem enviará seus anjos e eles juntarão tudo que representa o pecado e todos que fazem o mal. ");
INSERT INTO porblt_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Então, eles jogarão os maus na fornalha de fogo ardente, onde estes chorarão e rangerão os dentes. ");
INSERT INTO porblt_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","E depois, aqueles que vivem de forma honesta brilharão como o sol no Reino do seu Pai. Todos os que têm ouvidos para ouvir, que ouçam! ");
INSERT INTO porblt_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","O Reino do Céu é como um tesouro escondido no campo. Um homem o encontrou e o enterrou de novo. Depois, muito alegremente, vendeu tudo o que tinha e comprou aquele campo. ");
INSERT INTO porblt_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","O Reino do Céu também é como um comerciante procurando belas pérolas. ");
INSERT INTO porblt_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Quando ele encontrou a pérola mais cara, ele vendeu tudo o que tinha e a comprou. ");
INSERT INTO porblt_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","O Reino do Céu também é como uma rede de pesca jogada ao mar, que pegou todo tipo de peixes. ");
INSERT INTO porblt_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Quando ela estava cheia, foi recolhida. Os peixes bons foram colocados em cestos, enquanto os ruins foram jogados fora. ");
INSERT INTO porblt_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Assim acontecerá quando o fim do mundo chegar. Os anjos sairão e separarão as pessoas ruins das boas. ");
INSERT INTO porblt_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","As pessoas ruins serão jogadas na fornalha de fogo ardente, onde chorarão e rangerão os dentes. ");
INSERT INTO porblt_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Agora vocês compreendem tudo?” “Sim!”, eles responderam. ");
INSERT INTO porblt_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesus disse: “Todo educador religioso que aprendeu sobre o Reino do Céu é como o dono de uma casa, que tira do seu depósito tanto coisas novas quanto antigas.” ");
INSERT INTO porblt_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Após Jesus ter acabado de contar essas histórias, ele foi embora. ");
INSERT INTO porblt_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ele retornou para a sua cidade natal. Lá, ele ensinou na sinagoga. As pessoas ficaram maravilhadas e perguntaram: “De onde vêm a sua sabedoria e os seus milagres? ");
INSERT INTO porblt_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ele não é o filho do carpinteiro? A mãe dele não se chama Maria? E seus irmãos não são Tiago, José, Simão e Judas? ");
INSERT INTO porblt_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","As irmãs dele não moram aqui entre nós? Então, de onde ele consegue tudo isso?” ");
INSERT INTO porblt_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","E, assim, eles se recusaram a crer nele. Jesus lhes disse: “Um profeta é respeitado em toda parte, menos em sua terra natal e em sua família.” ");
INSERT INTO porblt_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Como eles não confiaram nele, Jesus não fez muitos milagres ali. ");
INSERT INTO porblt_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Naquela época, Herodes, o tetrarca, ouviu a respeito do que Jesus fazia ");
INSERT INTO porblt_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","e disse aos seus criados: “Esse homem deve ser João Batista, que foi ressuscitado. E é por isso que ele tem esses poderes!” ");
INSERT INTO porblt_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes tinha detido João, amarrado as suas mãos e o colocado na prisão a pedido de Herodias, esposa de Filipe, seu irmão. ");
INSERT INTO porblt_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Pois João Batista lhe disse: “Pela lei, você não pode se casar com ela.” ");
INSERT INTO porblt_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes queria matar João, mas tinha medo da reação das pessoas, pois eles consideravam João um profeta. ");
INSERT INTO porblt_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","No entanto, na festa de aniversário de Herodes, a filha de Herodias dançou diante de todos, e Herodes ficou fascinado por ela. ");
INSERT INTO porblt_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Então, ele prometeu que daria qualquer coisa que ela pedisse. ");
INSERT INTO porblt_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aconselhada pela mãe, ela disse: “Quero a cabeça de João Batista em um prato.” ");
INSERT INTO porblt_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","O rei se arrependeu da promessa que tinha feito, mas por ter prometido diante dos seus convidados, ele deu a ordem para que o pedido fosse atendido. ");
INSERT INTO porblt_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A ordem foi transmitida e João foi decapitado na prisão. ");
INSERT INTO porblt_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Então, trouxeram a cabeça em um prato e a deram para a garota, que a levou para a sua mãe. ");
INSERT INTO porblt_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Os discípulos de João vieram, levaram o corpo dele e o sepultaram. Depois eles foram e contaram isso para Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ao ouvir a notícia, Jesus saiu de barco sozinho para um lugar calmo. Mas quando as pessoas descobriram onde ele estava, elas saíram de suas cidades e o seguiram a pé. ");
INSERT INTO porblt_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Quando Jesus saiu do barco e viu tanta gente, ele ficou com pena deles e curou os que estavam doentes. ");
INSERT INTO porblt_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","No fim da tarde, os discípulos se aproximaram de Jesus e lhe disseram: “Este lugar é muito deserto e está ficando tarde. Mande as pessoas embora, para que elas possam ir aos povoados comprar algo para comer.” ");
INSERT INTO porblt_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mas, Jesus lhes disse: “Eles não precisam ir embora. Deem algo para eles comerem.” ");
INSERT INTO porblt_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Eles responderam: “Tudo que temos são cinco pães e dois peixes.” ");
INSERT INTO porblt_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Traga-os para mim”, Jesus falou. ");
INSERT INTO porblt_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Depois disse para as pessoas se sentarem na grama. Então, ele pegou os cinco pães e os dois peixes, olhou para o céu e os abençoou. Depois disso, ele partiu os pães, entregou-os aos discípulos e eles distribuíram os pães para a multidão. ");
INSERT INTO porblt_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Todos comeram até ficarem satisfeitos. Então, com as sobras que juntaram, os discípulos encheram doze cestos. ");
INSERT INTO porblt_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Cerca de cinco mil homens comeram, sem contar as mulheres e as crianças. ");
INSERT INTO porblt_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Logo após isso, ele fez com que os discípulos entrassem no barco e voltassem para o outro lado do lago, enquanto ele se despedia das pessoas. ");
INSERT INTO porblt_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Após ter se despedido das pessoas, ele subiu um monte para orar. Anoiteceu e ele estava ali sozinho. ");
INSERT INTO porblt_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Naquele momento o barco já estava longe da terra firme, sendo golpeado pelas ondas, por causa do vento que soprava contra ele. ");
INSERT INTO porblt_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Eram aproximadamente entre três e seis horas da manhã quando Jesus os alcançou, andando sobre o mar. ");
INSERT INTO porblt_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Quando os discípulos o viram andando em cima da água, ficaram com muito medo e gritaram: “É um fantasma!” ");
INSERT INTO porblt_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Então, Jesus imediatamente lhes disse: “Não se preocupem, sou eu! Não tenham medo!” ");
INSERT INTO porblt_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedro falou: “Senhor, se for realmente você, diga-me para ir até onde está, andando sobre a água.” ");
INSERT INTO porblt_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Então, venha!”, disse Jesus. Pedro saiu do barco e caminhou sobre a água até onde Jesus estava. ");
INSERT INTO porblt_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mas, quando percebeu como o vento soprava forte, ele ficou com medo e começou a afundar. Ele gritou: “Senhor, salve-me!” ");
INSERT INTO porblt_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesus rapidamente o alcançou e segurando-o disse: “Você tem tão pouca fé em mim! Por que você duvidou?” ");
INSERT INTO porblt_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Quando eles chegaram ao barco, o vento parou ");
INSERT INTO porblt_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","e os discípulos o adoraram, dizendo: “Você é realmente o Filho de Deus!” ");
INSERT INTO porblt_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Após atravessarem o lago, chegaram à Genesaré. ");
INSERT INTO porblt_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Quando as pessoas perceberam que Jesus estava lá, espalharam a notícia para que todos na região soubessem. Todos os doentes foram levados até Jesus ");
INSERT INTO porblt_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","e imploraram para que ele os deixasse tocar na barra da sua capa. Todas as pessoas que o tocaram foram curadas. ");
INSERT INTO porblt_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Então, alguns fariseus e educadores religiosos, vindos de Jerusalém, se aproximaram de Jesus e lhe perguntaram: ");
INSERT INTO porblt_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Por que os seus discípulos quebram a tradição de nossos antepassados ao não lavarem as mãos antes de comer?” ");
INSERT INTO porblt_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus respondeu: “Por que vocês desobedecem ao mandamento de Deus por causa de sua tradição?” ");
INSERT INTO porblt_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","“Pois Deus disse: ‘Respeitem o seu pai e a sua mãe.’ E também: ‘Aqueles que amaldiçoam seu pai ou sua mãe deveriam morrer.’ ");
INSERT INTO porblt_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mas, vocês dizem que se alguém disser ao seu pai ou a sua mãe: ‘Qualquer ajuda que vocês esperam receber de mim, agora é uma oferta para Deus,’ então ");
INSERT INTO porblt_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","eles não precisam respeitar seu pai. Assim, vocês anulam a Palavra de Deus em nome de sua tradição. ");
INSERT INTO porblt_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Seus hipócritas! Isaías tinha razão quando disse o seguinte sobre vocês: ");
INSERT INTO porblt_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Essas pessoas dizem que me respeitam, mas em seus pensamentos elas não ligam para mim. ");
INSERT INTO porblt_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","A adoração delas é inútil. O que essas pessoas ensinam são apenas exigências dos homens.’” ");
INSERT INTO porblt_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ele chamou a multidão e lhes disse: “Escutem e compreendam o que eu digo: ");
INSERT INTO porblt_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","não é o que entra em sua boca o que os corrompe. É o que sai da sua boca que os desonra.” ");
INSERT INTO porblt_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Então, os discípulos de Jesus vieram até ele e disseram: “Notou como os fariseus ficaram ofendidos com o que o senhor disse?” ");
INSERT INTO porblt_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","“Toda a planta que meu Pai celestial não tenha plantado será arrancada,” Jesus respondeu. ");
INSERT INTO porblt_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Esqueçam-se deles. Eles são guias cegos. E, se um homem cego guia outro cego, os dois cairão em um buraco.” ");
INSERT INTO porblt_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Então, Pedro pediu: “Por favor, explique para nós o que você quis dizer com esse exemplo.” ");
INSERT INTO porblt_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","“Vocês ainda não compreenderam o que eu disse?”, Jesus perguntou. ");
INSERT INTO porblt_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Vocês não percebem que tudo que entra pela boca passa pelo estômago e depois sai do corpo e vai para o esgoto? ");
INSERT INTO porblt_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mas, o que sai da boca vem da mente, e é isso que os contamina. ");
INSERT INTO porblt_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pois o que vem da mente são pensamentos maldosos, assassinatos, adultérios, imoralidades sexuais, roubos, mentiras e blasfêmias, ");
INSERT INTO porblt_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","e é isso o que os corrompe. Comer sem lavar as mãos não faz isso a vocês.” ");
INSERT INTO porblt_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus saiu dali e foi para a região de Tiro e Sidom. ");
INSERT INTO porblt_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Uma mulher cananeia, que morava na região, veio e gritou: “Senhor, Filho de Davi, por favor, tenha pena de mim! Minha filha está muito mal, pois está possuída por um demônio.” ");
INSERT INTO porblt_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mas Jesus não falou absolutamente nada. Seus discípulos se aproximaram dele e disseram: “Diga para ela parar de nos seguir. Toda essa gritaria é muito irritante!” ");
INSERT INTO porblt_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Então, Jesus respondeu para a mulher: “Eu fui enviado somente para as ovelhas perdidas de Israel.” ");
INSERT INTO porblt_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Porém, a mulher veio e se ajoelhou diante dele, dizendo: “Senhor, por favor, ajude-me!” ");
INSERT INTO porblt_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus lhe disse: “Não é certo tirar o alimento dos filhos e jogá-lo aos cachorros.” ");
INSERT INTO porblt_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ela respondeu: “Sim, Senhor. Mas até mesmo os cachorros comem as migalhas que caem da mesa do seu dono.” ");
INSERT INTO porblt_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesus disse: “A sua fé em mim é grande. Eu farei como me pede.” E a filha da mulher foi imediatamente curada. ");
INSERT INTO porblt_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus voltou, passando pelo mar da Galileia. Ele foi até um monte próximo, onde se sentou. ");
INSERT INTO porblt_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Grandes multidões vieram até ele, trazendo coxos, cegos, aleijados, mudos e muitos outros doentes. Eles foram colocados no chão, aos seus pés, e Jesus curou a todos. ");
INSERT INTO porblt_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","As pessoas ficaram espantadas com o que viram acontecer: os surdos podiam falar, os aleijados foram curados, os coxos andaram e os cegos puderam enxergar. Eles louvaram o Deus de Israel. ");
INSERT INTO porblt_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus chamou os seus discípulos e lhes disse: “Eu sinto muita pena destas pessoas. Elas estão comigo há três dias e não têm nada para comer. Eu não quero mandá-las embora com fome, pois elas podem desmaiar em seu caminho de volta para casa.” ");
INSERT INTO porblt_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Os discípulos responderam: “Onde conseguiríamos encontrar pão para alimentar todas estas pessoas aqui neste deserto?” ");
INSERT INTO porblt_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Quantos pães vocês têm?” Jesus perguntou. “Sete e alguns peixes pequenos,” eles disseram. ");
INSERT INTO porblt_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesus pediu para que a multidão se sentasse na grama. ");
INSERT INTO porblt_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ele pegou os sete pães e os peixes e, após abençoar a comida, ele os repartiu e os deu aos discípulos, para que eles distribuíssem às pessoas que estavam ali. ");
INSERT INTO porblt_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Todos comeram até ficarem satisfeitos. Das sobras, os discípulos recolheram encheram sete cestos. ");
INSERT INTO porblt_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Quatro mil homens comeram, sem contar mulheres e crianças. ");
INSERT INTO porblt_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Então, Jesus enviou a multidão de volta para casa, entrou em um barco e foi para a região de Magadã. ");
INSERT INTO porblt_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Os fariseus e os saduceus vieram testar Jesus, exigindo que ele lhes mostrasse um sinal vindo do céu. ");
INSERT INTO porblt_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesus respondeu: “No fim da tarde, vocês dizem: ‘Amanhã será um bom dia, porque o céu está avermelhado.’ ");
INSERT INTO porblt_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","E de manhã vocês dizem: ‘Hoje o tempo ficará ruim, porque o céu está avermelhado e nublado.’ Vocês sabem prever o tempo, ao olhar como o céu está, mas não conseguem reconhecer os sinais desta época! ");
INSERT INTO porblt_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","As pessoas más, que não têm fé em Deus, são aquelas que buscam um sinal milagroso. Mas, nenhum sinal lhes será dado, a não ser o sinal de Jonas.” Jesus os deixou e foi embora dali. ");
INSERT INTO porblt_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ao atravessarem o lago, os discípulos se esqueceram de levar pão. Jesus, então, lhes disse: ");
INSERT INTO porblt_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","“Cuidado com o fermento dos fariseus e dos saduceus!” ");
INSERT INTO porblt_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Os discípulos começaram a discutir entre si e concluíram: “Ele está falando isso porque não trouxemos pão.” ");
INSERT INTO porblt_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus sabia o que eles diziam e falou: “Vocês têm tão pouca fé em mim! Por que estão discutindo a respeito de não terem pão? ");
INSERT INTO porblt_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Vocês ainda não entenderam? Não se lembram dos cinco pães, que alimentaram cinco mil pessoas? Quantos cestos vocês encheram com as sobras? ");
INSERT INTO porblt_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","E dos sete pães, que alimentaram quatro mil pessoas? Quantos cestos vocês encheram com as sobras? ");
INSERT INTO porblt_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Vocês ainda não compreenderam que eu não estou falando sobre pão? E sim: cuidado com o fermento dos fariseus e dos saduceus!” ");
INSERT INTO porblt_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Então, eles perceberam que ele não os estava alertando para terem cuidado com o fermento para pão, mas, sim, a respeito dos ensinamentos dos fariseus e dos saduceus. ");
INSERT INTO porblt_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Quando Jesus chegou na região de Cesareia de Filipe, perguntou aos seus discípulos: “Quem as pessoas dizem que o Filho do Homem é?” ");
INSERT INTO porblt_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Eles responderam: “Alguns dizem que é João Batista; outros dizem que é Elias; e há outros ainda que dizem que é Jeremias ou algum dos outros profetas.” ");
INSERT INTO porblt_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesus lhes perguntou: “Mas e vocês? Quem vocês dizem que eu sou?” ");
INSERT INTO porblt_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simão Pedro respondeu: “Você é o Messias, o Filho do Deus vivo.” ");
INSERT INTO porblt_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Você, Simão, filho de João, é realmente abençoado,” Jesus lhe disse. “Pois isso não lhe foi revelado por nenhum ser humano, mas, sim, pelo meu Pai celestial. ");
INSERT INTO porblt_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Eu também lhe digo que você é Pedro, e sobre esta rocha, eu construirei a minha igreja e nem a morte a irá vencer. ");
INSERT INTO porblt_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Eu lhe darei as chaves do Reino do Céu. E tudo aquilo que você proibir na terra, também será proibido no céu. E o que você aceitar na terra, também será aceito no céu.” ");
INSERT INTO porblt_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Então, ele alertou seus discípulos para não dizerem a ninguém que ele era o Messias. ");
INSERT INTO porblt_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A partir daquele momento, Jesus começou a explicar aos seus discípulos que ele precisaria ir para Jerusalém e que lá sofreria terrivelmente nas mãos dos anciãos do povo, dos chefes dos sacerdotes e dos educadores religiosos. Também os alertou que ele seria morto, mas que ressuscitaria no terceiro dia. ");
INSERT INTO porblt_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro chamou Jesus de lado e disse que ele não deveria dizer tais coisas. Pedro disse: “Que Deus nunca permita que isso aconteça com o senhor!” ");
INSERT INTO porblt_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus se virou e disse a Pedro: “Afaste-se de mim, Satanás! Você é uma pedra para me fazer tropeçar, pois está pensando como os homens e, não, como Deus pensa!” ");
INSERT INTO porblt_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Então, Jesus disse a seus discípulos: “Se vocês querem ser meus seguidores, devem negar a si mesmos. Devem pegar cada um a sua cruz e me seguirem. ");
INSERT INTO porblt_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pois se quiserem salvar a sua vida, vocês a perderão. E se perderem a sua vida por mim, vocês serão salvos. ");
INSERT INTO porblt_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Do que serve ganhar o mundo todo se perderem sua vida? O que vocês dariam em troca de sua vida? ");
INSERT INTO porblt_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Pois o Filho do Homem virá na glória do seu Pai, junto com os seus anjos. E ele dará a todos o que eles merecem, de acordo com o que fizeram. ");
INSERT INTO porblt_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Eu lhes afirmo que isto é verdade: há alguns, que aqui estão, que não morrerão antes de verem vir o Filho do Homem em seu Reino.” ");
INSERT INTO porblt_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis dias depois, Jesus subiu um alto monte, levando com ele apenas Pedro e os irmãos Tiago e João. ");
INSERT INTO porblt_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ele se transformou na frente deles. Seu rosto brilhou como o sol. Suas roupas ficaram brancas como a luz. ");
INSERT INTO porblt_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Então, de repente, Moisés e Elias apareceram diante deles, conversando com Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Então, Pedro disse a Jesus: “Senhor, é realmente muito bom estarmos aqui! Se você quiser, eu farei três tendas: uma para você, uma para Moisés e outra para Elias.” ");
INSERT INTO porblt_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Enquanto ele ainda estava falando, uma nuvem brilhante os cobriu. Uma voz vinda da nuvem disse: “Este é o meu Filho a quem tanto amo e que tanta alegria me dá! Escutem o que ele diz.” ");
INSERT INTO porblt_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ao ouvirem isso, os discípulos, totalmente apavorados, ajoelharam e colocaram o rosto no chão. ");
INSERT INTO porblt_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesus se aproximou deles e os tocou. “Levantem-se!”, ele lhes disse. “Não tenham medo!” ");
INSERT INTO porblt_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Quando os discípulos olharam para cima, não viram mais ninguém além de Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Quando desceram do monte, Jesus lhes deu esta ordem: “Não digam a ninguém o que vocês viram, até que o Filho do Homem tenha ressuscitado dos mortos.” ");
INSERT INTO porblt_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Então, seus discípulos perguntaram: “Por que os educadores religiosos dizem que Elias deve vir primeiro?” ");
INSERT INTO porblt_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus assim respondeu: “É verdade que Elias vem para colocar tudo em ordem. ");
INSERT INTO porblt_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mas, eu lhes digo que Elias já veio e as pessoas não o reconheceram. Eles fizeram tudo o que queriam com ele. Da mesma maneira, o Filho do Homem também sofrerá em suas mãos.” ");
INSERT INTO porblt_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Naquele momento, os discípulos entenderam que Jesus estava falando a respeito de João Batista. ");
INSERT INTO porblt_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Quando eles se aproximaram da multidão, um homem veio até Jesus e se ajoelhou diante dele. ");
INSERT INTO porblt_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ele disse: “Senhor, por favor, tenha pena do meu filho! Ele perde a razão e sofre espasmos tão terríveis que frequentemente cai no fogo ou na água. ");
INSERT INTO porblt_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Eu o levei para os seus discípulos, para que eles o curassem, mas eles não conseguiram.” ");
INSERT INTO porblt_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","“Vocês se recusam a crer em mim! Gente perversa e sem fé!” Jesus respondeu. “Por quanto tempo eu terei que ficar com vocês? Por quanto tempo eu terei que suportá-los? Tragam o menino para mim!” ");
INSERT INTO porblt_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesus repreendeu o demônio, e ele saiu do corpo do garoto, que foi imediatamente curado. ");
INSERT INTO porblt_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Então, os discípulos se aproximaram de Jesus e, em particular, lhe perguntaram: “Por que nós não conseguimos expulsar aquele demônio?” ");
INSERT INTO porblt_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesus lhes disse: “Porque vocês não têm fé o bastante. Eu lhes digo: mesmo se a sua fé fosse tão pequena quanto um grão de mostarda, vocês poderiam dizer para esta montanha: ‘Saia daqui e vá para lá!’, e isso aconteceria. Nada seria impossível para vocês.” ");
INSERT INTO porblt_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Conforme eles caminhavam juntos para a Galileia, Jesus lhes disse: “O Filho do Homem será traído e as pessoas terão poder sobre ele. ");
INSERT INTO porblt_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Eles o matarão, mas, no terceiro dia, ele ressuscitará.” Os discípulos ficaram muito tristes. ");
INSERT INTO porblt_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Quando eles chegaram à cidade de Cafarnaum, os cobradores do imposto do Templo se aproximaram de Pedro e perguntaram: “O seu mestre paga o imposto do Templo, não paga?” ");
INSERT INTO porblt_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro respondeu: “Sim, claro!” Ao retornar para onde eles estavam, Jesus antecipou a questão e perguntou: “O que você acha, Simão? Os reis deste mundo cobram impostos e taxas dos seus próprios filhos ou dos outros?” ");
INSERT INTO porblt_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro respondeu: “Dos outros.” Então, Jesus lhe disse: “Nesse caso, os filhos estão isentos. ");
INSERT INTO porblt_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mas, para evitar ofender a qualquer um, vá até o lago e jogue uma linha de pesca com um anzol na ponta. Puxe o primeiro peixe que pegar e, ao abrir a sua boca, você encontrará uma moeda de estáter. Pegue a moeda e dê a eles, para pagar tanto o meu quanto o seu imposto.” ");
INSERT INTO porblt_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Naquele momento, os discípulos se aproximaram de Jesus e perguntaram: “Quem é o mais importante no Reino do Céu?” ");
INSERT INTO porblt_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesus chamou uma criança. Ele a colocou diante deles. ");
INSERT INTO porblt_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Eu lhes afirmo que isto é verdade: se vocês não mudarem a sua forma de pensar e não se tornarem como as criancinhas, nunca entrarão no Reino do Céu”, ele lhes disse. ");
INSERT INTO porblt_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","“Mas, todo aquele que se tornar humilde como esta pequena criança é o mais importante no Reino do Céu. ");
INSERT INTO porblt_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Qualquer um que aceita uma criança como esta, em meu nome, também me aceita. ");
INSERT INTO porblt_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Porém, aquele que faz com que um desses pequeninos, que crê em mim, peque, seria melhor que tivesse uma grande pedra amarrada em seu pescoço e que afundasse nas profundezas do mar. ");
INSERT INTO porblt_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ai dos que incitam outros ao pecado! Isso certamente acontecerá, mas será terrível para a pessoa que fizer isso! ");
INSERT INTO porblt_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Se a sua mão ou o seu pé fizer você pecar, corte-o e jogue-o fora. É melhor que você entre na vida eterna aleijado, do que com as duas mãos ou com os dois pés ser jogado no fogo eterno. ");
INSERT INTO porblt_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Se os seus olhos fazem você pecar, tire-os e jogue-os fora. É melhor você entrar na vida eterna com um olho, do que ter os dois olhos e ser jogado no fogo da Geena. ");
INSERT INTO porblt_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Tenham certeza de não desprezar estas criancinhas. Eu lhes afirmo que isto é verdade: no céu, os anjos deles estão sempre com meu Pai celestial. ");
INSERT INTO porblt_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","O que vocês acham disso? Se um homem tem cem ovelhas, e uma delas se perde, o homem não deixará as noventa e nove na colina e irá em busca daquela que se perdeu? ");
INSERT INTO porblt_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","E, se ele a encontrar, eu lhes digo que ele realmente se alegrará com aquela, mais do que com as noventa e nove que não se perderam. ");
INSERT INTO porblt_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Da mesma maneira, meu Pai celestial não quer que qualquer uma destas criancinhas se perca. ");
INSERT INTO porblt_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Se um irmão pecar contra você, vá e mostre o erro para ele, mas em particular. Se ele o ouvir, você conquistou o seu irmão. ");
INSERT INTO porblt_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mas, se ele não o ouvir, então, reúna uma ou duas pessoas, para que a verdade possa ser confirmada por duas ou três testemunhas. ");
INSERT INTO porblt_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","No entanto, se ele se recusar a ouvi-los, então, comunique à igreja. Se ele também se recusar a ouvir a igreja, então, trate-o como um pagão e como a um cobrador de impostos. ");
INSERT INTO porblt_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Eu lhes digo que isto é verdade: tudo aquilo que vocês proibirem na terra também será proibido no céu. E o que vocês aceitarem na terra também será aceito no céu. ");
INSERT INTO porblt_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Eu também lhes digo que se dois de vocês concordarem, aqui na terra, a respeito de algo que pedem, em oração, então, meu Pai celestial fará isso por vocês. ");
INSERT INTO porblt_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pois onde dois ou três se reunirem em meu nome, eu estarei lá com eles.” ");
INSERT INTO porblt_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pedro se aproximou de Jesus e lhe perguntou: “Quantas vezes eu devo perdoar o meu irmão por pecar contra mim? Sete vezes?” ");
INSERT INTO porblt_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus lhe disse: “Não, não sete vezes. Eu diria setenta vezes sete!” ");
INSERT INTO porblt_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“É por isso que o Reino do Céu é como um rei que resolveu acertar contas com os seus empregados que lhe deviam dinheiro. ");
INSERT INTO porblt_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Conforme ele começou a acertar as contas, um empregado que lhe devia uma quantia de dez mil talentos foi levado até ele. ");
INSERT INTO porblt_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Por ele não ter o dinheiro para pagar, o patrão ordenou que ele fosse vendido, juntamente com a sua esposa, seus filhos e tudo que possuía, para que, assim, a dívida pudesse ser paga. ");
INSERT INTO porblt_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","O empregado se ajoelhou e disse ao patrão: ‘Por favor, tenha paciência comigo! Eu lhe pagarei tudo que devo!’ ");
INSERT INTO porblt_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","O patrão teve pena do empregado, deixou que ele fosse embora e perdoou-lhe a dívida. ");
INSERT INTO porblt_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mas quando esse mesmo empregado saiu, encontrou um dos seus companheiros de trabalho que lhe devia a quantia de apenas cem denários. Ele o agarrou pelo pescoço e o sacudiu, dizendo: ‘Pague o que você me deve!’ ");
INSERT INTO porblt_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Seu companheiro se ajoelhou diante dele e lhe implorou: ‘Por favor, seja paciente comigo! Eu lhe pagarei!’ ");
INSERT INTO porblt_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mas, o homem se recusou a perdoar e colocou o devedor na cadeia, até que ele lhe pagasse tudo que devia. ");
INSERT INTO porblt_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Quando os outros empregados viram o que havia acontecido, ficaram revoltados e foram até o patrão e disseram o que havia acontecido. ");
INSERT INTO porblt_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Então, o patrão chamou novamente o homem e lhe disse: ‘Empregado miserável! Eu lhe perdoei toda a sua dívida, porque você me implorou. ");
INSERT INTO porblt_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Você não deveria ter sido misericordioso com seu companheiro, da mesma maneira que eu fui com você?’ ");
INSERT INTO porblt_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","O seu patrão ficou furioso e o mandou para a cadeia, até que ele pagasse toda a dívida. ");
INSERT INTO porblt_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Isso é o que o meu Pai celestial fará a cada um de vocês, a menos que vocês perdoem sinceramente aos seus irmãos.” ");
INSERT INTO porblt_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Assim que Jesus acabou de falar, ele saiu da Galileia e foi para a região da Judeia, que ficava do outro lado do rio Jordão. ");
INSERT INTO porblt_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Uma quantidade imensa de pessoas o seguiu, e ele curou os que estavam doentes. ");
INSERT INTO porblt_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Alguns fariseus perguntaram-lhe, com o objetivo de testá-lo: “É permitido que um homem, por qualquer motivo, se divorcie da sua esposa?” ");
INSERT INTO porblt_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus respondeu: “Vocês não leram que Deus, que criou as pessoas no início de tudo, fez um homem e uma mulher? ");
INSERT INTO porblt_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ele disse: ‘Esta é a razão pela qual um homem deixará seu pai e sua mãe e se unirá a sua esposa. E os dois deverão se tornar uma só pessoa.’ ");
INSERT INTO porblt_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Assim, eles não são mais duas pessoas e, sim, uma. O que Deus uniu ninguém deveria separar.” ");
INSERT INTO porblt_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Os fariseus perguntaram: “Então, por que Moisés permitiu que um homem pudesse se divorciar de sua esposa, desde que desse a ela uma certidão de divórcio e a mandasse embora?” ");
INSERT INTO porblt_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","E Jesus respondeu: “Foi por causa da atitude insensível de vocês que Moisés permitiu que se divorciassem de suas esposas. Mas, no princípio, as coisas não eram assim. ");
INSERT INTO porblt_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Porém, eu lhes digo que qualquer um que se divorciar de sua esposa, a não ser por imoralidade sexual e, depois, se casar com outra mulher, estará cometendo adultério.” ");
INSERT INTO porblt_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Os discípulos disseram a Jesus: “Se essa é a situação entre marido e mulher, então, é melhor não casar!” ");
INSERT INTO porblt_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus lhes disse: “Nem todos podem aceitar este ensinamento, apenas aqueles para quem ele é dado. ");
INSERT INTO porblt_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Alguns nascem castrados. Outros são castrados pelos homens. E há ainda outros que decidem não se casar por causa do Reino do Céu. Quem puder aceitar isso, deve fazê-lo.” ");
INSERT INTO porblt_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","As pessoas trouxeram crianças para que Jesus as abençoasse e orasse por elas. Mas, os discípulos repreenderam essas pessoas. ");
INSERT INTO porblt_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Porém, Jesus disse: “Deixem as criancinhas virem até mim! Não as proíbam! O Reino do Céu pertence àqueles que são como elas.” ");
INSERT INTO porblt_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ele colocou as suas mãos sobre as crianças e as abençoou. Depois, foi embora. ");
INSERT INTO porblt_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Um homem se aproximou de Jesus e lhe perguntou: “Mestre, o que devo fazer de bom para conseguir a vida eterna?” ");
INSERT INTO porblt_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus respondeu: “Por que você me pergunta a respeito do que é bom? Há apenas um que é bom. Mas, se você quiser conseguir a vida eterna, então, cumpra os mandamentos.” ");
INSERT INTO porblt_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","O homem lhe perguntou: “Quais mandamentos?” Jesus respondeu: “Não mate, não cometa adultério, não roube, não dê falso testemunho, ");
INSERT INTO porblt_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","respeite seu pai e sua mãe e ame ao próximo como a você mesmo.” ");
INSERT INTO porblt_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Eu cumpro todos esses mandamentos,” o jovem disse. “O que mais eu preciso fazer?” ");
INSERT INTO porblt_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus lhe disse: “Se você quiser ser perfeito, então, venda tudo o que possui, doe o dinheiro aos pobres e, no céu, você receberá muitas riquezas. Depois, venha e me siga.” ");
INSERT INTO porblt_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Quando o jovem ouviu a resposta de Jesus, ele se afastou muito triste, pois era rico. ");
INSERT INTO porblt_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesus disse aos discípulos: “Eu lhes digo que isto é verdade: é difícil os ricos entrarem no Reino do Céu. ");
INSERT INTO porblt_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","E também lhes digo: é mais fácil um camelo passar pelo buraco de uma agulha do que um rico entrar no Reino de Deus.” ");
INSERT INTO porblt_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Quando os discípulos ouviram isto, eles ficaram muito surpresos e perguntaram: “Então, quem pode ser salvo?” ");
INSERT INTO porblt_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus olhou para eles e disse: “De um ponto de vista humano, é impossível; mas todas as coisas são possíveis para Deus.” ");
INSERT INTO porblt_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro lhe respondeu: “Bem, nós deixamos tudo para segui-lo. O que ganharemos como recompensa?” ");
INSERT INTO porblt_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus lhe respondeu: “Eu lhes afirmo que isto é verdade: quando tudo for refeito, e o Filho do Homem estiver sentado em seu glorioso trono, vocês, que me seguiram, também se sentarão em doze tronos e julgarão as doze tribos de Israel. ");
INSERT INTO porblt_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Todos aqueles que por mim tiverem deixado suas casas, seus irmãos, suas irmãs, seu pai, sua mãe, seus filhos e seus campos, receberão cem vezes mais e também receberão a vida eterna. ");
INSERT INTO porblt_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pois, muitos que são os primeiros serão os últimos. E muitos que são os últimos serão os primeiros. ");
INSERT INTO porblt_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Pois o Reino do Céu é como o dono de terras que de manhã cedo saiu para contratar trabalhadores para a sua plantação de uvas. ");
INSERT INTO porblt_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ele concordou em pagar aos trabalhadores um denário por dia, e os enviou para trabalhar em sua plantação. ");
INSERT INTO porblt_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Por volta de nove da manhã, ele saiu novamente e viu outras pessoas sem trabalho, paradas na praça do mercado. ");
INSERT INTO porblt_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ele lhes disse: ‘Vão e trabalhem na minha plantação de uvas também. Eu lhes pagarei o que for justo.’ Então, eles foram trabalhar. ");
INSERT INTO porblt_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Por volta do meio-dia e das três horas da tarde, ele saiu e fez a mesma coisa. ");
INSERT INTO porblt_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Às cinco horas da tarde, ele voltou à praça e encontrou outras pessoas que lá estavam. Ele lhes perguntou: ");
INSERT INTO porblt_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Por que vocês estão parados quase o dia todo sem fazer nada?’ Eles responderam: ‘Porque ninguém nos contratou.’ O dono das terras disse: ‘Vão e trabalhem na minha plantação também.’ ");
INSERT INTO porblt_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Quando chegou no final da tarde, o proprietário da plantação disse ao seu gerente: ‘Chame os trabalhadores e pague-lhes os seus salários. Comece com os trabalhadores contratados por último até chegar aos primeiros.’ ");
INSERT INTO porblt_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Aqueles que foram contratados às cinco horas da tarde vieram e receberam um denário. ");
INSERT INTO porblt_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Então, quando aqueles que foram contratados primeiro chegaram para receber, pensaram que ganhariam mais, mas seu salário também foi de um denário. ");
INSERT INTO porblt_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ao receberem o seu pagamento, eles reclamaram com o proprietário: ");
INSERT INTO porblt_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘As pessoas que foram contratadas por último trabalharam apenas por uma hora e receberam o mesmo que nós, que trabalhamos todo o dia debaixo de sol quente.’ ");
INSERT INTO porblt_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","O dono das terras respondeu a um deles: ‘Amigo, eu não fui injusto com vocês. Vocês não concordaram em trabalhar por um denário? ");
INSERT INTO porblt_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Peguem o seu pagamento e vão embora. Eu quero pagar para aqueles que foram contratados por último o mesmo que eu paguei para vocês. ");
INSERT INTO porblt_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Eu não posso fazer com o meu próprio dinheiro o que eu quiser? Por que vocês me lançam olhares maldosos, por eu querer fazer o bem?’ ");
INSERT INTO porblt_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dessa maneira, os últimos serão os primeiros, e os primeiros serão os últimos.” ");
INSERT INTO porblt_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","No caminho para Jerusalém, Jesus chamou os doze discípulos para um lado e lhes disse, em particular, enquanto caminhavam: ");
INSERT INTO porblt_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Escutem! Estamos indo para Jerusalém, e o Filho do Homem será entregue nas mãos dos chefes dos sacerdotes e dos educadores religiosos. Eles irão condená-lo à morte ");
INSERT INTO porblt_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","e o entregarão aos pagãos para ser humilhado, chicoteado e crucificado. Mas, no terceiro dia, ele se levantará dos mortos.” ");
INSERT INTO porblt_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Então, a mãe dos filhos de Zebedeu se aproximou de Jesus, junto com os seus dois filhos. Ela se ajoelhou diante de Jesus, para fazer um pedido. ");
INSERT INTO porblt_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“O que você quer me pedir?”, ele lhe perguntou. Ela disse: “Por favor, escolha os meus filhos para se sentarem ao seu lado em seu Reino. Um, a sua direita e o outro, a sua esquerda.” ");
INSERT INTO porblt_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Então, Jesus respondeu: “Vocês não sabem o que estão pedindo. Vocês são capazes de beber do cálice que eu beberei?” Eles lhe responderam: “Sim, nós podemos fazer isso.” ");
INSERT INTO porblt_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus, então, falou: “Vocês certamente beberão do meu cálice, mas eu não posso escolher quem se sentará a minha direita ou a minha esquerda. Meu Pai já decidiu quem ocupará esses lugares.” ");
INSERT INTO porblt_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Quando os outros dez discípulos ouviram o que eles pediram, ficaram chateados com os dois irmãos. ");
INSERT INTO porblt_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesus os reuniu e lhes disse: “Vocês sabem que os governadores dos povos pagãos os comandam e os poderosos os oprimem. ");
INSERT INTO porblt_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Entre vocês não deve ser assim. Quem entre vocês quiser ser o mais importante deverá servir aos outros. ");
INSERT INTO porblt_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Quem quiser ser o primeiro deverá ser como um escravo para os outros. ");
INSERT INTO porblt_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Da mesma forma, o Filho do Homem não veio para ser servido, mas, sim, para servir e dar a sua vida para salvar muitas pessoas.” ");
INSERT INTO porblt_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Quando eles estavam saindo de Jericó, uma grande multidão seguia Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dois homens cegos estavam sentados na beira da estrada. Quando ouviram que Jesus estava passando, eles pediram ajuda: “Tenha pena de nós, Senhor, Filho de Davi!” ");
INSERT INTO porblt_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A multidão mandou que eles ficassem quietos, mas os dois gritaram ainda mais alto: “Tenha pena de nós, Senhor, Filho de Davi!” ");
INSERT INTO porblt_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus parou e lhes chamou, perguntando: “O que querem que eu faça por vocês?” ");
INSERT INTO porblt_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Eles responderam: “Senhor, por favor, queremos poder enxergar.” ");
INSERT INTO porblt_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus teve pena deles e tocou seus olhos. Imediatamente, eles conseguiram ver e o seguiram. ");
INSERT INTO porblt_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesus e os seus discípulos seguiram para Jerusalém. Conforme foram se aproximando, eles chegaram à vila de Betfagé, no monte das Oliveiras. Jesus enviou dois discípulos na frente, ");
INSERT INTO porblt_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","dizendo-lhes: “Vão para a vila. Mais adiante, vocês encontrarão uma jumenta presa ao seu filhote. Desamarre-os e traga-os para mim. ");
INSERT INTO porblt_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Se alguém lhes perguntar o que vocês estão fazendo, apenas lhe diga: ‘O Senhor precisa deles.’ E eles logo os deixarão trazer os animais.” ");
INSERT INTO porblt_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Assim se cumpriu o que o profeta disse: ");
INSERT INTO porblt_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Digam à filha de Sião: ‘Veja! O seu Rei está chegando. Ele é humilde e está montado em um jumento, e em um jumentinho, filhote de jumenta.’” ");
INSERT INTO porblt_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Os discípulos foram e fizeram como Jesus havia dito. ");
INSERT INTO porblt_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Eles trouxeram a jumenta e o seu filhote. Eles colocaram suas capas sobre os animais e Jesus montou. ");
INSERT INTO porblt_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Muitas pessoas na multidão cobriram o chão com as suas capas, enquanto outras cortavam galhos das árvores e os colocavam sobre a estrada. ");
INSERT INTO porblt_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A grande quantidade de pessoas que iam na frente e as que vinham atrás dele gritavam: “Hosana ao filho de Davi! Abençoado seja ele, que vem em nome do Senhor! Hosana nas alturas!” ");
INSERT INTO porblt_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Quando Jesus chegou em Jerusalém, havia uma grande agitação na cidade. As pessoas perguntavam: “Quem é ele?” ");
INSERT INTO porblt_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","E a multidão respondia: “Ele é Jesus, o profeta de Nazaré da Galileia.” ");
INSERT INTO porblt_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesus entrou no Templo e expulsou todas as pessoas que lá estavam comprando e vendendo. Ele virou as mesas dos que trocavam dinheiro e as cadeiras dos vendedores de pombas. ");
INSERT INTO porblt_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ele lhes disse: “As Sagradas Escrituras dizem: ‘Minha casa deverá ser chamada de casa de oração’, mas vocês a transformaram em um esconderijo de ladrões.” ");
INSERT INTO porblt_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Cegos e coxos vinham até ele no Templo, e ele os curava. ");
INSERT INTO porblt_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mas, os chefes dos sacerdotes e os educadores religiosos ficaram ofendidos ao verem os milagres maravilhosos que ele fazia, e as crianças gritando no Templo: “Hosana ao filho de Davi!” Eles perguntaram a Jesus: “Você está ouvindo o que estas crianças estão dizendo?” ");
INSERT INTO porblt_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesus respondeu: “Sim. Vocês nunca leram a passagem das Sagradas Escrituras que diz: ‘Façam com que as crianças e as criancinhas ofereçam o louvor perfeito?’” ");
INSERT INTO porblt_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesus os deixou e saiu daquela cidade para ficar na aldeia de Betânia. ");
INSERT INTO porblt_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na manhã seguinte, conforme ele voltava para a cidade, ficou com fome. ");
INSERT INTO porblt_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ele viu uma figueira na beira da estrada. Então, ele foi até ela, mas não encontrou frutos, apenas folhas. Ele disse à figueira: “Nunca mais dê figos!” Imediatamente, a figueira secou. ");
INSERT INTO porblt_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Os discípulos ficaram espantados ao ver isso. Eles perguntaram: “Como a figueira secou tão rápido?” ");
INSERT INTO porblt_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus respondeu: “Eu lhes afirmo que isto é verdade: se vocês realmente acreditarem em Deus e não duvidarem dele, poderão não só fazer o que eu fiz com a figueira, mas muito mais. Vocês poderão dizer para esta montanha: ‘Levante-se e jogue-se no mar!’ E isso acontecerá. ");
INSERT INTO porblt_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Vocês receberão tudo o que pedirem em oração, desde que acreditem em Deus.” ");
INSERT INTO porblt_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus entrou no Templo. Os chefes dos sacerdotes e os anciãos do povo se aproximaram de Jesus, enquanto ele ensinava, e perguntaram: “Com que autoridade você faz estas coisas? Quem lhe deu esta autoridade?” ");
INSERT INTO porblt_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus respondeu: “Eu também tenho uma pergunta para vocês. Se vocês me responderem, eu lhes digo com que autoridade faço estas coisas: ");
INSERT INTO porblt_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","De onde era o batismo de João? Do céu ou dos seres humanos?” Eles discutiram entre si: “Se dissermos ‘do céu’, então, ele nos perguntará: então por que vocês não creram em João? ");
INSERT INTO porblt_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mas, se dissermos ‘dos seres humanos’, então, a multidão irá se virar contra nós, pois todos eles consideram João um profeta.” ");
INSERT INTO porblt_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Diante disso, eles responderam a Jesus: “Nós não sabemos.” Jesus disse: “Então, eu não direi a vocês com que autoridade faço estas coisas. ");
INSERT INTO porblt_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mas, o que vocês acham desta história?: Havia um homem que tinha dois filhos. Ele se virou para o primeiro filho e disse: ‘Filho, vá e trabalhe na plantação de uvas hoje.’ ");
INSERT INTO porblt_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","O filho respondeu: ‘Eu não irei.’ Mas depois, ele se arrependeu do que tinha dito e foi trabalhar na plantação. ");
INSERT INTO porblt_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","O homem se aproximou do segundo filho e disse a mesma coisa. O filho respondeu: ‘Eu irei.’ Mas, ele não foi. ");
INSERT INTO porblt_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Qual dos dois filhos fez o que seu pai queria?” Eles responderam: “O primeiro.” “Eu lhes afirmo que isto é verdade: os cobradores de impostos e as prostitutas estão entrando no Reino de Deus antes de vocês”, Jesus lhes disse. ");
INSERT INTO porblt_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","“João veio para lhes mostrar o caminho certo, mas vocês não acreditaram nele. Ao contrário de vocês, os cobradores de impostos e a prostitutas creram nele. Depois, quando vocês viram o que aconteceu, ainda assim, não se arrependeram, nem acreditaram nele. ");
INSERT INTO porblt_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Vou lhes contar outra história. Havia um homem, dono de terras, que plantava uvas. Ele colocou uma cerca em volta de suas terras. Construiu um tanque para pisar as uvas e uma torre para o vigia. Então, ele alugou as terras para alguns lavradores e foi viajar. ");
INSERT INTO porblt_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Na época da colheita, ele enviou os seus empregados para receber dos lavradores a parte dele. ");
INSERT INTO porblt_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mas, os lavradores atacaram seus empregados. Eles bateram em um, mataram outro e apedrejaram um terceiro. ");
INSERT INTO porblt_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Diante do acontecido, ele enviou mais empregados, mas os lavradores fizeram a mesma coisa com eles. ");
INSERT INTO porblt_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Então, ele enviou o seu próprio filho, pensando: ‘Eles irão respeitar o meu filho.’ ");
INSERT INTO porblt_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Porém, os lavradores, quando viram o filho do dono das terras, disseram uns aos outros: ‘Ele é o herdeiro. Vamos! Se o matarmos, poderemos ficar com a sua herança!’ ");
INSERT INTO porblt_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eles o agarraram, jogaram-no para fora da plantação e o mataram. ");
INSERT INTO porblt_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Quando o dono da plantação voltar, o que ele irá fazer com aqueles lavradores?” ");
INSERT INTO porblt_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Os chefes dos sacerdotes e os anciãos do povo disseram a Jesus: “Ele condenará à morte aqueles homens perversos da forma mais terrível e alugará a plantação de uvas a outros lavradores, que certamente lhe darão a sua parte na colheita no momento certo.” ");
INSERT INTO porblt_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus lhes perguntou: “Então, vocês não leram essa passagem nas Sagradas Escrituras: ‘A pedra que os construtores rejeitaram se tornou o pilar fundamental. O Senhor fez isso, e é uma coisa maravilhosa?’ ");
INSERT INTO porblt_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","É por isso que eu lhes digo que o Reino de Deus será tirado de vocês. E será dado a pessoas que produzam o tipo certo de fruto. ");
INSERT INTO porblt_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Qualquer um que cair em cima dessa pedra ficará partido, mas, se essa pedra cair sobre alguém, essa pessoa irá virar pó.” ");
INSERT INTO porblt_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Quando os chefes dos sacerdotes e os fariseus ouviram essa história, eles perceberam que Jesus estava falando a respeito deles. ");
INSERT INTO porblt_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Eles queriam prendê-lo, mas tinham medo do que as pessoas poderiam fazer, pois elas acreditavam que ele era um profeta. ");
INSERT INTO porblt_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus falou com eles, usando mais histórias como exemplo. ");
INSERT INTO porblt_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“O Reino do Céu é como um rei que organizou uma festa de casamento para o seu filho”, Jesus explicou. ");
INSERT INTO porblt_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","“Ele enviou seus empregados para falar com todos os convidados para irem à festa, mas eles se recusaram. ");
INSERT INTO porblt_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Então, ele enviou mais empregados, com a seguinte ordem: ‘Digam aos convidados que eu já preparei o banquete de casamento. Os bois e os bezerros gordos já foram mortos e já está tudo pronto. Então, venham para a festa!’ ");
INSERT INTO porblt_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mas, os convidados ignoraram o convite e saíram para cuidar de outras coisas. Um foi para seu campo, e o outro foi cuidar do seu negócio. ");
INSERT INTO porblt_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Os outros agarraram os empregados do rei e os maltrataram, e acabaram por matá-los. ");
INSERT INTO porblt_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","O rei ficou furioso. Ele enviou seus soldados para destruir aqueles assassinos e queimar a cidade deles. ");
INSERT INTO porblt_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Então, o rei disse aos seus empregados: ‘O banquete de casamento está pronto, mas as pessoas que convidei não mereciam participar desta festa. ");
INSERT INTO porblt_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Vão pelas ruas e convidem a todos que encontrarem para que venham ao casamento.’ ");
INSERT INTO porblt_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","E, assim, os empregados fizeram. Saíram pelas ruas e trouxeram todos que puderam encontrar, tanto as pessoas boas quanto as más. O salão da festa de casamento ficou lotado. ");
INSERT INTO porblt_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mas, quando o rei veio encontrar os convidados, ele notou que um homem não estava vestido com roupas apropriadas para uma festa. ");
INSERT INTO porblt_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ele lhe perguntou: ‘Amigo, como você entrou aqui sem estar vestido adequadamente para uma festa?’ O homem não disse nada. ");
INSERT INTO porblt_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Então, o rei disse aos seus empregados: ‘Amarrem suas mãos e seus pés e o joguem nas trevas, onde chorará e rangerá os dentes.’ ");
INSERT INTO porblt_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pois muitos são os convidados, mas poucos são os escolhidos.” ");
INSERT INTO porblt_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nesse momento, os fariseus saíram e se encontraram para fazer um plano de como poderiam conseguir alguma prova contra Jesus, usando o que ele tinha dito. ");
INSERT INTO porblt_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Eles enviaram alguns dos seus discípulos até ele, juntamente com alguns dos apoiadores de Herodes. Eles, então, começaram: “Mestre, nós sabemos que você é um homem honesto e que ensina o caminho de Deus, de acordo com a verdade. Você não se permite ser influenciado por ninguém e não se importa com aparências. ");
INSERT INTO porblt_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Então, queremos saber a sua opinião: É certo pagar impostos para o imperador romano, ou não?” ");
INSERT INTO porblt_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesus sabia que eles estavam mal-intencionados. Ele lhes respondeu: “Por que vocês estão tentando me pegar em uma armadilha? Hipócritas! ");
INSERT INTO porblt_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mostrem-me a moeda que é usada para pagar o imposto.” Eles lhe trouxeram uma moeda de denário. ");
INSERT INTO porblt_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ele lhes perguntou: “De quem são a imagem e o nome inscritos aqui?” ");
INSERT INTO porblt_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Eles responderam: “De César, o imperador romano.” Jesus, então, lhes disse: “Vocês devem dar a César o que é de César e a Deus o que é de Deus.” ");
INSERT INTO porblt_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Quando eles ouviram a resposta de Jesus, ficaram impressionados. Eles saíram e deixaram Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mais tarde, naquele mesmo dia, alguns saduceus vieram vê-lo. (Eles são aqueles que dizem que não há ressurreição.) ");
INSERT INTO porblt_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Eles perguntaram para Jesus: “Mestre, Moisés disse que se um homem casado morrer sem deixar filhos, seu irmão deve se casar com a viúva e ter filhos, que serão considerados filhos do irmão que morreu. ");
INSERT INTO porblt_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bem, havia entre nós sete irmãos. O primeiro se casou e morreu. Como ele não tinha filhos, a sua viúva se casou com o seu irmão. ");
INSERT INTO porblt_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","A mesma coisa aconteceu com o segundo e com o terceiro maridos, até chegar ao sétimo. ");
INSERT INTO porblt_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","No fim, a mulher morreu também. ");
INSERT INTO porblt_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Então, quando houver a ressurreição, de qual dos sete irmãos a mulher será a esposa, já que ela se casou com todos eles?” ");
INSERT INTO porblt_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus respondeu: “O erro de vocês é que não conhecem as Sagradas Escrituras ou o que Deus pode fazer. ");
INSERT INTO porblt_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pois as pessoas que ressuscitarem não se casam, e, também, não serão dadas em casamento. Elas são como os anjos no céu. ");
INSERT INTO porblt_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Em relação à ressurreição dos mortos, vocês não leram o que Deus disse? Ele afirmou: ");
INSERT INTO porblt_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Eu sou o Deus de Abraão, o Deus de Isaque e o Deus de Jacó.’ Ele não é Deus dos mortos, mas, sim, dos vivos.” ");
INSERT INTO porblt_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Quando a multidão ouviu o que Jesus disse, ficou maravilhada com o seu ensinamento. ");
INSERT INTO porblt_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Quando os fariseus ouviram dizer que Jesus tinha feito os saduceus calarem a boca, eles se reuniram e foram lhe fazer algumas perguntas. ");
INSERT INTO porblt_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Um deles, que era um especialista na lei, fez uma pergunta a Jesus, para tentar fazer com que ele caísse em uma armadilha: ");
INSERT INTO porblt_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mestre, qual é o mandamento mais importante da Lei?” ");
INSERT INTO porblt_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus lhes disse: “‘Ame o Senhor, seu Deus, com todo o seu coração, com toda a sua alma e com todo o seu entendimento.’ ");
INSERT INTO porblt_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Esse é o primeiro e mais importante mandamento. ");
INSERT INTO porblt_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","O segundo é parecido com o primeiro: ‘Ame ao próximo como ama a você mesmo.’ ");
INSERT INTO porblt_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Toda a lei bíblica e todos os textos dos profetas dependem desses dois mandamentos.” ");
INSERT INTO porblt_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Enquanto os fariseus estavam lá reunidos, Jesus lhes fez uma pergunta: ");
INSERT INTO porblt_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“O que vocês pensam a respeito do Messias? De quem ele é filho?” Eles responderam: “É filho de Davi.” ");
INSERT INTO porblt_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Mas, como Davi, inspirado pelo Espírito Santo, chamou o Messias de ‘Senhor’?”, Jesus lhes perguntou. “Ele falou: ");
INSERT INTO porblt_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘O Senhor disse para o meu Senhor: Sente-se a minha direita até que eu derrote todos os seus inimigos.’ ");
INSERT INTO porblt_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Se Davi o chamou de Senhor, como o Messias pode ser seu filho?” ");
INSERT INTO porblt_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nenhum deles pôde responder a Jesus. E, a partir daquele momento, ninguém mais teve coragem de perguntar qualquer outra coisa para ele. ");
INSERT INTO porblt_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Então, Jesus falou para a multidão e para os seus discípulos: ");
INSERT INTO porblt_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Os educadores religiosos e os fariseus são responsáveis por interpretar a lei de Moisés. ");
INSERT INTO porblt_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Por isso, obedeçam a eles e façam tudo que eles lhes dizem. Mas, não sigam o que eles fazem, pois eles não praticam o que pregam. ");
INSERT INTO porblt_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Eles amarram cargas pesadas e as colocam sobre os ombros das pessoas, porém eles mesmos não levantam um único dedo para ajudá-las. ");
INSERT INTO porblt_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tudo que eles fazem é para garantir que sejam notados. Eles fazem para si mesmos grandes caixas de oração para usarem e colocam longas franjas em suas roupas. ");
INSERT INTO porblt_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Eles amam ter os lugares de honra nos banquetes e os melhores assentos nas sinagogas. ");
INSERT INTO porblt_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Eles gostam de ser cumprimentados com respeito nas praças dos mercados e de que as pessoas os chamem de ‘Rabi.’ ");
INSERT INTO porblt_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Vocês não devem ser chamados de ‘Rabi’, pois todos vocês são irmãos e têm apenas um Mestre. ");
INSERT INTO porblt_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aqui, na terra, não chamem ninguém de ‘Pai’, pois apenas um é o seu Pai, e ele está no céu. ");
INSERT INTO porblt_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Não deixem que as pessoas lhes chamem de ‘Líder’, uma vez que apenas um é o seu Líder, o Messias. ");
INSERT INTO porblt_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","O mais importante entre vocês é aquele que serve aos outros. ");
INSERT INTO porblt_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aqueles que se engrandecem serão humilhados. E aqueles que se humilham serão engrandecidos. ");
INSERT INTO porblt_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ai de vocês, educadores religiosos e fariseus, hipócritas! Vocês fecham a porta do Reino do Céu na cara das pessoas. Vocês mesmos não entram, e nem deixam que entrem os que estão querendo entrar. ");
INSERT INTO porblt_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ai de vocês, educadores religiosos e fariseus, hipócritas! Pois vocês viajam por terra e por mar para converter uma pessoa para a sua religião. E quando conseguem, fazem dele duas vezes um filho da Geena como vocês mesmos. ");
INSERT INTO porblt_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ai de vocês que dizem: ‘Se você jurar pelo Templo, não precisa cumprir o juramento; mas, se você jurar pelo ouro do Templo, então, precisa manter o juramento.’ Como são tolos e cegos! ");
INSERT INTO porblt_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","O que é mais importante: o ouro ou o Templo, que torna o ouro santificado? ");
INSERT INTO porblt_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Vocês dizem: ‘Se você jurar pelo altar, não precisa cumprir o juramento. Mas, se você jurar pela oferta que está sobre o altar, então, precisa manter o juramento.’ ");
INSERT INTO porblt_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Como são cegos! O que é mais importante: a oferta ou o altar que santifica a oferta? ");
INSERT INTO porblt_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Se você jura pelo altar, jura por ele e por tudo o que está sobre ele. ");
INSERT INTO porblt_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Se você jura pelo Templo, jura por ele e por aquele que lá vive. ");
INSERT INTO porblt_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Se você jura pelo céu, jura pelo trono de Deus e por quem nele se senta. ");
INSERT INTO porblt_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ai de vocês, educadores religiosos e fariseus, hipócritas! Vocês pagam a décima parte da menta, da erva-doce e do cominho, mas desprezam os aspectos vitais da lei, que são: ser justo com os outros, mostrar misericórdia e agir com honestidade. Sim, vocês devem pagar o seu dízimo, mas não devem se esquecer dessas outras coisas. ");
INSERT INTO porblt_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Guias cegos! Vocês filtram o que bebem para não engolir um mosquito, mas, então, engolem um camelo! ");
INSERT INTO porblt_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ai de vocês, educadores religiosos e fariseus, hipócritas! Vocês limpam o copo e o prato por fora, mas, por dentro, vocês estão cheios de ganância e submissão aos próprios desejos. ");
INSERT INTO porblt_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseus cegos! Limpem primeiro a parte de dentro do copo e do prato, para que a parte de fora também fique limpa. ");
INSERT INTO porblt_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ai de vocês, educadores religiosos e fariseus, hipócritas! Vocês são como túmulos cuidadosamente limpos, que parecem bonitos por fora, mas, por dentro, estão cheios de ossos de mortos e de todo tipo de podridão. ");
INSERT INTO porblt_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Vocês são exatamente assim. Por fora, vocês parecem ser pessoas boas, mas, por dentro, estão cheios de hipocrisia e maldade. ");
INSERT INTO porblt_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ai de vocês, educadores religiosos e fariseus, hipócritas! Vocês constroem túmulos para homenagear os profetas e decoram os túmulos das pessoas que viveram de forma correta ");
INSERT INTO porblt_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","e dizem: ‘Se tivéssemos vivido na época dos nossos antepassados, não teríamos derramado o sangue dos profetas, como eles fizeram.’ ");
INSERT INTO porblt_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mas, ao dizer isso, vocês testemunham contra si mesmos, provando que são descendentes daqueles que assassinaram os profetas! ");
INSERT INTO porblt_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Então, vão e terminem o que eles começaram! ");
INSERT INTO porblt_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Cobras, ninhada de serpentes! Como vocês escaparão do julgamento da Geena? ");
INSERT INTO porblt_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","É por isso que estou enviando profetas, sábios e mestres para vocês. Vocês irão matar alguns, crucificar outros, chicotear alguns em suas sinagogas e persegui-los de cidade em cidade. ");
INSERT INTO porblt_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Por isso, vocês serão responsáveis pelo sangue de todas as boas pessoas que foi derramado na terra, desde o sangue de Abel, que fez o que era certo, até o sangue de Zacarias, filho de Baraquias, que foi morto entre o Templo e o altar. ");
INSERT INTO porblt_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Eu lhes digo que isto é verdade: as consequências de tudo isso cairão sobre as pessoas de hoje. ");
INSERT INTO porblt_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalém, Jerusalém, que mata os profetas e apedreja aqueles que são enviados para você! Muitas vezes eu quis abraçar todo o seu povo, como as galinhas fazem com os seus pintinhos, acolhendo-os debaixo de suas asas, mas vocês não quiseram. ");
INSERT INTO porblt_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Vejam! A casa de vocês ficará completamente vazia e abandonada. ");
INSERT INTO porblt_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Eu lhes digo que isto é verdade: vocês não me verão mais, até que digam: ‘Abençoado é aquele que vem em nome do Senhor!’” ");
INSERT INTO porblt_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Quando Jesus estava saindo do Templo, seus discípulos se aproximaram dele, apontando orgulhosamente para os prédios do Templo. ");
INSERT INTO porblt_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mas, Jesus respondeu: “Vocês veem todos estes prédios? Eu lhes digo que isto é verdade: não ficará uma única pedra sobre a outra. Todas elas cairão!” ");
INSERT INTO porblt_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Quando Jesus se sentou no monte das Oliveiras, os discípulos chegaram perto dele e, em particular, lhe pediram: “Por favor, diga-nos quando isso irá acontecer e qual será o sinal da sua chegada e do fim do mundo.” ");
INSERT INTO porblt_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus respondeu: “Tenham cuidado para que ninguém os engane. ");
INSERT INTO porblt_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Muitos se passarão por mim e dirão: ‘Eu sou o Messias!’ E eles enganarão muitas pessoas. ");
INSERT INTO porblt_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Vocês ouvirão a respeito de guerras e de rumores sobre guerras, mas não fiquem ansiosos. Essas coisas precisam acontecer, mas isso não é o fim. ");
INSERT INTO porblt_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","As nações atacarão umas às outras e os reinos irão guerrear uns contra os outros. Haverá muita fome e terremotos em vários lugares, ");
INSERT INTO porblt_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","mas tudo isso é apenas o começo das dores do parto. ");
INSERT INTO porblt_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Então, eles irão prendê-los, persegui-los e os matarão. Todas as pessoas os odiarão por serem meus seguidores. ");
INSERT INTO porblt_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nessa época, muitos que creem deixarão de acreditar. Eles vão trair e odiar uns aos outros. ");
INSERT INTO porblt_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Muitos profetas falsos aparecerão e enganarão muitas pessoas. ");
INSERT INTO porblt_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","A maldade crescerá tanto que fará com que o amor de muitas pessoas esfrie. ");
INSERT INTO porblt_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mas, aquele que aguentar firme até o fim será salvo. ");
INSERT INTO porblt_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","As boas novas do Reino serão divulgadas em todo o mundo, como testemunho a toda humanidade. E, assim, o fim chegará. ");
INSERT INTO porblt_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Então, quando vocês virem a abominação ocorrer no lugar sagrado, sobre a qual o profeta Daniel falou (aqueles que lerem isto, por favor, considerem com cuidado), ");
INSERT INTO porblt_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","será o momento em que os moradores da Judeia deverão correr e se refugiar nas montanhas. ");
INSERT INTO porblt_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Aqueles que estiverem nos terraços das suas casas não devem descer para tentar pegar o que estiver lá dentro. ");
INSERT INTO porblt_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aqueles que estiverem nos campos não devem voltar para pegar seus casacos. ");
INSERT INTO porblt_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ai das mulheres grávidas e das que tiverem bebês nesses dias! ");
INSERT INTO porblt_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Peçam a Deus para que vocês não precisem fugir no inverno ou no sábado. ");
INSERT INTO porblt_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Pois, nesses dias, haverá uma perseguição terrível. Isso será muito pior do que qualquer coisa que já tenha acontecido desde o início do mundo até agora e nunca mais se repetirá. ");
INSERT INTO porblt_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","A menos que esses dias de sofrimento sejam diminuídos, ninguém será salvo. Mas, pelo bem dos escolhidos por Deus, esse tempo será abreviado. ");
INSERT INTO porblt_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Então, se alguém lhes disser: ‘Vejam! Aqui está o Messias,’ ou: ‘O Messias está lá,’ não acreditem. ");
INSERT INTO porblt_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pois falsos messias e falsos profetas aparecerão. E eles mostrarão sinais e farão milagres incríveis para, se possível, enganar os escolhidos por Deus. ");
INSERT INTO porblt_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Atenção! Eu estou lhes dizendo isso antes mesmo que aconteça. ");
INSERT INTO porblt_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Então, se lhes disserem: ‘Vejam! Ele está no deserto’, não vão para lá. Ou se eles disserem: ‘Vejam! Ele está escondido aqui’, não acreditem. ");
INSERT INTO porblt_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pois a vinda do Filho do Homem será como o relâmpago, que brilha intensamente de leste a oeste. ");
INSERT INTO porblt_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","‘Os urubus se reúnem onde há o corpo de um morto.’ ");
INSERT INTO porblt_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Mas, logo após esses dias de perseguição, o sol ficará escuro, e a lua não irá brilhar. As estrelas cairão do céu, e os poderes do espaço serão abalados. ");
INSERT INTO porblt_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Então, o sinal do Filho do Homem aparecerá no céu, e todas as pessoas na terra chorarão. Elas verão o Filho do Homem vindo sobre as nuvens do céu, com poder e em glória brilhante. ");
INSERT INTO porblt_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Com o toque de trombeta, ele enviará seus anjos para reunir as pessoas escolhidas por Deus, em todos os lugares do mundo. ");
INSERT INTO porblt_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Aprendam com a história da figueira. Quando os seus galhos ficam verdes e as folhas começam a brotar, vocês sabem que o verão está chegando. ");
INSERT INTO porblt_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Da mesma maneira, quando vocês virem todas essas coisas acontecendo, saberão que o tempo está perto, e logo chegará. ");
INSERT INTO porblt_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Eu lhes digo que isto é verdade: esta geração não desaparecerá até que todas essas coisas tenham acontecido. ");
INSERT INTO porblt_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","O céu e a terra podem acabar, mas as minhas palavras não desaparecerão. ");
INSERT INTO porblt_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Mas, ninguém sabe o dia e nem a hora em que isso acontecerá, nem os anjos no céu e nem o Filho. Apenas o Pai sabe. ");
INSERT INTO porblt_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Quando o Filho do Homem vier, será como aconteceu na época de Noé. ");
INSERT INTO porblt_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Será como nos dias antes do dilúvio, quando as pessoas comiam e bebiam, casavam-se e eram dadas em casamento, até o dia em que Noé entrou na arca. ");
INSERT INTO porblt_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Eles não sabiam o que iria acontecer até que o dilúvio veio e levou a todos. Assim será quando o Filho do Homem chegar. ");
INSERT INTO porblt_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dois homens estarão trabalhando no campo. Um será levado e o outro será deixado. ");
INSERT INTO porblt_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Duas mulheres estarão triturando grãos em um moinho. Uma será levada e a outra será deixada. ");
INSERT INTO porblt_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Então, estejam atentos, pois vocês não sabem em que dia o Senhor chegará. ");
INSERT INTO porblt_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mas, considerem isto: se o dono da casa soubesse quando o ladrão chegaria, ele ficaria vigiando. Ele não permitiria que a sua casa fosse arrombada e roubada. ");
INSERT INTO porblt_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Vocês também precisam estar preparados, porque o Filho do Homem chegará quando vocês menos esperarem. ");
INSERT INTO porblt_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Pois quem é o empregado confiável e atento? É aquele que o patrão coloca como responsável pelos outros empregados, para que ele lhes dê os mantimentos no tempo adequado. ");
INSERT INTO porblt_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Como será bom para esse empregado estar fazendo o que lhe foi ordenado, quando o seu patrão voltar! ");
INSERT INTO porblt_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Eu lhes digo que isto é verdade: o patrão colocará esse empregado como responsável por tudo o que ele tem. ");
INSERT INTO porblt_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mas, se esse empregado for ruim, ele dirá a si mesmo: ‘Meu patrão está demorando para voltar.’ ");
INSERT INTO porblt_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","E, então, começar a bater nos outros empregados e a comer e beber com os bêbados. ");
INSERT INTO porblt_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Então, o patrão desse empregado voltará quando ele não estiver esperando, e em uma hora que ele não saiba. ");
INSERT INTO porblt_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ele castigará o empregado e o tratará da mesma maneira que os hipócritas, enviando-o para um lugar onde há choro e onde rangerá os dentes.” ");
INSERT INTO porblt_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“O Reino do Céu é como dez moças que pegaram suas lamparinas para sair e se encontrar com o noivo. ");
INSERT INTO porblt_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco eram tolas e cinco eram espertas. ");
INSERT INTO porblt_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","As garotas tolas levaram suas lamparinas, mas se esqueceram do óleo de reserva, ");
INSERT INTO porblt_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","enquanto as garotas espertas levaram óleo de reserva para suas lamparinas. ");
INSERT INTO porblt_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","O noivo demorou a chegar e todas as garotas ficaram com sono e dormiram. ");
INSERT INTO porblt_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","À meia-noite alguém gritou: ‘Vejam! O noivo chegou! Venham e o encontrem!’ ");
INSERT INTO porblt_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Todas as garotas se levantaram e arrumaram o pavio de suas lamparinas. As moças tolas disseram para as espertas: ");
INSERT INTO porblt_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","‘Deem-nos um pouco do seu óleo, pois nossas lamparinas estão se apagando.’ Mas, as garotas espertas responderam: ");
INSERT INTO porblt_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Não, ou não haverá óleo suficiente para vocês e para nós. Vão comprar óleo.’ ");
INSERT INTO porblt_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Enquanto elas foram comprar o óleo, o noivo chegou, e as garotas que estavam prontas foram com ele para a festa de casamento e a porta foi trancada. ");
INSERT INTO porblt_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","As outras garotas chegaram mais tarde e chamaram: ‘Senhor, Senhor! Abra a porta para nós!’ ");
INSERT INTO porblt_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mas, o noivo respondeu: ‘Eu lhes digo que isto é verdade: eu não as conheço.’ ");
INSERT INTO porblt_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Então, fiquem atentos! Pois vocês não sabem o dia e nem a hora. ");
INSERT INTO porblt_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","É como um homem que saiu em uma viagem. Ele chamou os seus empregados e os deixou responsáveis pelo que ele possuía. ");
INSERT INTO porblt_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ele distribuiu os valores de acordo com a capacidade de cada um: para um deles, ele deu a quantia de cinco talentos. Para o outro, ele deu o valor de dois talentos. E para o terceiro, deu apenas um talento. Então, ele foi viajar. ");
INSERT INTO porblt_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Imediatamente, o que ganhou cinco talentos investiu o dinheiro em um negócio, que lhe rendeu mais cinco talentos. ");
INSERT INTO porblt_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Da mesma maneira, o empregado que ficou com dois talentos, obteve o dobro do valor que recebera. ");
INSERT INTO porblt_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mas, o homem que havia recebido o valor de um talento saiu e cavou um buraco, onde escondeu o dinheiro do patrão. ");
INSERT INTO porblt_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Muito tempo depois, o patrão desses empregados retornou da viagem e foi acertar contas com eles. ");
INSERT INTO porblt_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","O empregado que recebera cinco talentos devolveu o valor de dez talentos para o patrão. Ele disse: ‘Senhor, você me deu cinco talentos. Veja! Eu obtive cinco talentos de lucro.’ ");
INSERT INTO porblt_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Seu patrão lhe disse: ‘Parabéns! Você é um empregado bom e leal. Você provou ser confiável, negociando uma pequena quantia; então, agora eu o deixarei negociar uma quantia bem maior. Fique feliz! Você realmente me deixou satisfeito!’ ");
INSERT INTO porblt_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","O empregado que recebera dois talentos também veio e disse: ‘Senhor, eu ganhei dois talentos e lhe devolvo o dobro.’ ");
INSERT INTO porblt_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","O patrão lhe disse: ‘Bom trabalho! Você é um empregado bom e leal. Você provou ser confiável para negociar pequenos valores; então, agora o deixarei responsável por valores maiores. Fique feliz! Você realmente me deixou satisfeito!’ ");
INSERT INTO porblt_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Então, o homem que recebera um talento chegou e disse: ‘Senhor, eu sei que você é um homem severo. Você colhe onde não semeou e junta onde não plantou. ");
INSERT INTO porblt_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Então, como eu estava com medo de você, enterrei seu dinheiro em um buraco. Assim, devolvo o que lhe pertence.’ ");
INSERT INTO porblt_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mas, seu patrão lhe respondeu: ‘Você é um empregado mau e preguiçoso! Se você pensa que eu colho onde não semeio, e junto onde não planto, ");
INSERT INTO porblt_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","então, deveria ter depositado o meu dinheiro no banco, para que, quando eu voltasse, pudesse receber meu dinheiro com juros. ");
INSERT INTO porblt_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tirem o dinheiro dele e deem para o empregado que devolveu dez talentos. ");
INSERT INTO porblt_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pois aquele que tem receberá ainda mais. E aquele que não tem, até mesmo o pouco que possui será tirado dele. ");
INSERT INTO porblt_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Agora, joguem este empregado inútil nas trevas, onde irá chorar e ranger os dentes.’ ");
INSERT INTO porblt_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Mas, quando o Filho do Homem vier, em toda a sua glória, trazendo todos os anjos com ele, então, ele se sentará em seu majestoso trono. ");
INSERT INTO porblt_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Todos serão levados diante dele. Ele irá separar uns dos outros, como um pastor separa as ovelhas das cabras. ");
INSERT INTO porblt_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ele colocará as ovelhas do seu lado direito, e as cabras, do seu lado esquerdo. ");
INSERT INTO porblt_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Então, o rei dirá aos que estiverem à sua direita: ‘Venham, vocês são abençoados pelo meu Pai! Recebam o Reino que foi preparado para vocês desde o início do mundo. ");
INSERT INTO porblt_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pois eu estava com fome, e vocês me alimentaram. Eu estava com sede, e vocês me deram o que beber. Eu era um desconhecido, e vocês me convidaram para entrar. ");
INSERT INTO porblt_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Eu estava nu, e vocês me vestiram. Eu estava doente, e vocês cuidaram de mim. Eu estava na prisão, e vocês me visitaram.’ ");
INSERT INTO porblt_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Então, aqueles que estavam à direita perguntarão: ‘Senhor, quando foi que o vimos com fome e o alimentamos? Ou quando o vimos com sede e lhe demos o que beber? ");
INSERT INTO porblt_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Quando o vimos como um desconhecido e o convidamos para entrar? Ou nu e o vestimos? ");
INSERT INTO porblt_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Quando foi que o vimos doente ou na prisão e o visitamos?’ ");
INSERT INTO porblt_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","O rei lhes dirá: ‘Eu lhes digo que isto é verdade: o que vocês fizeram para o menos importante dos meus irmãos, na verdade, fizeram para mim.’ ");
INSERT INTO porblt_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ele também dirá aos que estão à sua esquerda: ‘Afastem-se de mim! Vocês estão condenados ao fogo eterno, preparado para o diabo e os seus anjos! ");
INSERT INTO porblt_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pois eu estava com fome, e vocês não me alimentaram. Eu estava com sede, e vocês não me deram de beber. ");
INSERT INTO porblt_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Eu era um desconhecido, e vocês não me convidaram para entrar. Eu estava nu, e vocês não me vestiram. Eu estava doente e na prisão, e vocês não me visitaram.’ ");
INSERT INTO porblt_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Então, eles também irão perguntar: ‘Senhor, quando foi que o vimos com fome ou com sede, como um desconhecido, nu, doente ou na prisão e não cuidamos de você?’ ");
INSERT INTO porblt_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ele, então, lhes dirá: ‘Eu lhes digo que isto é verdade: o que vocês não fizeram para o menos importante dos meus irmãos, não fizeram para mim.’ ");
INSERT INTO porblt_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Estes irão para o castigo eterno. Mas, aqueles que são bons entrarão na vida eterna.” ");
INSERT INTO porblt_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Depois que Jesus ensinou tudo isso, disse aos seus discípulos: ");
INSERT INTO porblt_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Vocês sabem que daqui há dois dias será comemorada a Páscoa, e o Filho do Homem será entregue para ser crucificado.” ");
INSERT INTO porblt_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Então, os chefes dos sacerdotes e os anciãos do povo se reuniram no pátio de Caifás, o grande sacerdote. ");
INSERT INTO porblt_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Lá, eles fizeram um plano para prender Jesus sobre um pretexto traiçoeiro e matá-lo. ");
INSERT INTO porblt_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mas, eles disseram: “Não vamos fazer isso durante a festa da Páscoa; assim, as pessoas não arrumarão confusão.” ");
INSERT INTO porblt_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Enquanto Jesus estava na casa de Simão, o leproso, na aldeia de Betânia, ");
INSERT INTO porblt_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","uma mulher chegou perto dele, trazendo um vaso feito de alabastro com um perfume muito caro. Ela despejou o perfume na cabeça de Jesus enquanto ele estava sentado, comendo. Mas, quando os discípulos viram o que ela fez, ficaram chateados e disseram: ");
INSERT INTO porblt_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","“Que desperdício! ");
INSERT INTO porblt_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Esse perfume deveria ter sido vendido por uma grande quantia e o dinheiro, dado aos pobres.” ");
INSERT INTO porblt_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus estava atento ao que acontecia e lhes disse: “Por que vocês estão zangados com esta mulher? Ela fez algo maravilhoso para mim! ");
INSERT INTO porblt_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Vocês sempre terão os pobres com vocês, mas, a mim, nem sempre. ");
INSERT INTO porblt_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ao derramar este perfume em meu corpo, ela está me preparando para o sepultamento. ");
INSERT INTO porblt_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Eu lhes digo que isto é verdade: sempre que no mundo este evangelho for anunciado, a história do que esta mulher fez também será contada, para que se lembrem dela.” ");
INSERT INTO porblt_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Então, Judas Iscariotes, um dos doze discípulos, foi se encontrar com os chefes dos sacerdotes e lhes perguntou: ");
INSERT INTO porblt_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Quanto irão me pagar para eu entregar Jesus para vocês?” Eles lhe deram trinta moedas de prata. ");
INSERT INTO porblt_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A partir daquele momento, ele procurou uma oportunidade para trair Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","No primeiro dia da Festa dos Pães sem Fermento, os discípulos se aproximaram de Jesus e lhe perguntaram: “Onde quer que preparemos a refeição da Páscoa para você?” ");
INSERT INTO porblt_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesus respondeu: “Vão para a cidade e encontrem um certo homem e lhe falem que o Mestre disse: ‘A minha hora está próxima. Eu irei comemorar a Páscoa com meus discípulos em sua casa.’” ");
INSERT INTO porblt_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Os discípulos fizeram como Jesus havia dito e prepararam a refeição da Páscoa lá. ");
INSERT INTO porblt_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Quando a noite chegou, ele se sentou para jantar com os doze discípulos. ");
INSERT INTO porblt_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Enquanto eles estavam comendo, Jesus lhes disse: “Eu lhes digo que isto é verdade: um de vocês irá me trair.” ");
INSERT INTO porblt_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Eles ficaram extremamente abalados. Todos perguntaram a Jesus: “Senhor, não sou eu, sou?” ");
INSERT INTO porblt_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesus respondeu: “Aquele que coloca a mão no prato junto comigo irá me trair. ");
INSERT INTO porblt_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","O Filho do Homem morrerá exatamente como foi profetizado a respeito dele. Mas, ai daquele que trair o Filho do Homem! Seria melhor para esse homem não ter nascido!” ");
INSERT INTO porblt_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas, aquele que iria trair Jesus, perguntou: “Acaso, sou eu, Rabi?” Jesus lhe disse: “Você mesmo é quem está dizendo isso.” ");
INSERT INTO porblt_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Enquanto eles comiam, Jesus pegou o pão e o abençoou. Então, ele o partiu e distribuiu os pedaços aos discípulos, dizendo: “Peguem e comam, pois isto é o meu corpo.” ");
INSERT INTO porblt_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Depois, ele pegou o cálice, abençoou-o e o deu a eles, dizendo: “Bebam, todos vocês, ");
INSERT INTO porblt_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","pois isto é o meu sangue, o sangue do acordo, derramado em favor de muitos para o perdão dos pecados. ");
INSERT INTO porblt_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","No entanto, eu lhes digo: eu não beberei deste fruto da videira, até o dia em que hei beber com vocês um vinho novo, no Reino do meu Pai.” ");
INSERT INTO porblt_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Depois, eles cantaram uma música e foram para o monte das Oliveiras. ");
INSERT INTO porblt_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","“Todos vocês me abandonarão esta noite,” Jesus lhes disse. “Como as Sagradas Escrituras dizem: ‘Eu atacarei o pastor, e o rebanho de ovelhas se espalhará completamente.’ ");
INSERT INTO porblt_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mas, após eu ter ressuscitado, irei adiante de vocês para a Galileia.” ");
INSERT INTO porblt_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Porém, Pedro disse a Jesus: “Mesmo se todos o abandonarem, eu nunca o abandonarei.” ");
INSERT INTO porblt_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Mas Jesus lhe disse: “Eu lhe digo que isto é verdade: Nesta noite, antes que o galo cante, você me negará três vezes.” ");
INSERT INTO porblt_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mas, Pedro insistiu: “Mesmo que eu tenha que morrer com você, nunca o negarei!” E todos os discípulos disseram a mesma coisa. ");
INSERT INTO porblt_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Em seguida, Jesus foi com seus discípulos para um jardim chamado Getsêmani. Ele lhes disse: “Sentem-se aqui, enquanto eu vou ali orar.” ");
INSERT INTO porblt_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ele levou Pedro e os dois filhos de Zebedeu com ele. Jesus começou a sentir grande tristeza e aflição. ");
INSERT INTO porblt_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Então, ele lhes disse: “A minha tristeza é tão profunda que está me matando. Fiquem aqui vigiando comigo.” ");
INSERT INTO porblt_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ele foi um pouco mais adiante, colocou seu rosto no chão e orou: “Meu Pai, por favor, se for possível, afaste de mim este cálice de sofrimento! Ainda assim, que não seja feito o que eu quero, mas o que o senhor quer.” ");
INSERT INTO porblt_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ele voltou aos discípulos e os encontrou dormindo. Jesus disse a Pedro: “O quê? Vocês não conseguem ficar acordados comigo nem por apenas uma hora? ");
INSERT INTO porblt_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Vigiem e orem, para que não caiam em tentação. Sim, o espírito tem força de vontade, mas o corpo é fraco.” ");
INSERT INTO porblt_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ele se afastou novamente e orou, dizendo: “Meu Pai, se este cálice não pode ser afastado de mim sem que eu beba dele, então, que seja feita a sua vontade!” ");
INSERT INTO porblt_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ele voltou e os encontrou dormindo, pois eles simplesmente não conseguiam ficar acordados. ");
INSERT INTO porblt_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Então, Jesus se afastou deles mais uma vez e foi orar uma terceira vez, repetindo as mesmas palavras. ");
INSERT INTO porblt_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Depois, ele voltou para onde estavam os discípulos e lhes disse: “Como vocês ainda estão dormindo e descansando? Vejam! Chegou a hora. O Filho do Homem está próximo de ser entregue nas mãos dos pecadores! ");
INSERT INTO porblt_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Levantem-se e vamos! Olhem! Aquele que está me traindo chegou.” ");
INSERT INTO porblt_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Assim que ele disse isso, Judas, um dos doze apóstolos, chegou com uma grande multidão, armada com espadas e porretes, enviada pelos chefes dos sacerdotes e pelos anciãos do povo. ");
INSERT INTO porblt_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","O traidor tinha combinado de lhes dar um sinal. Ele lhes disse: “Prendam aquele que eu beijar, pois é ele.” ");
INSERT INTO porblt_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas rapidamente se aproximou de Jesus e disse: “Olá, Rabi!”, e o beijou. ");
INSERT INTO porblt_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus disse a Judas: “Amigo, faça o que veio fazer.” Então, eles vieram, agarraram Jesus e o prenderam. ");
INSERT INTO porblt_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Um daqueles que estavam com Jesus alcançou a sua espada e a sacou. Ele golpeou o empregado do grande sacerdote, cortando a sua orelha. ");
INSERT INTO porblt_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mas, Jesus lhe disse: “Largue a sua espada! Todos que lutam com a espada morrerão pela espada. ");
INSERT INTO porblt_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Você não acha que eu poderia pedir ao meu Pai, e ele imediatamente enviaria mais de doze legiões de anjos? ");
INSERT INTO porblt_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mas, então, como poderia se cumprir o que as Sagradas Escrituras dizem que deve acontecer?” ");
INSERT INTO porblt_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Então, Jesus disse à multidão: “Vocês vêm com espadas e porretes para me prender, como se eu fosse algum tipo de bandido perigoso? Todos os dias eu me sentei no Templo, ensinando, e vocês não me prenderam. ");
INSERT INTO porblt_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mas, tudo isto está acontecendo para que se cumpra o que os profetas escreveram.” Então, todos os discípulos o abandonaram e fugiram. ");
INSERT INTO porblt_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Os homens que prenderam Jesus o levaram até a casa de Caifás, o grande sacerdote, onde os educadores religiosos e os anciãos do povo estavam reunidos. ");
INSERT INTO porblt_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro o seguiu a uma certa distância, e entrou no pátio da casa do grande sacerdote. Ele se sentou junto dos guardas para ver como tudo terminaria. ");
INSERT INTO porblt_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Os chefes dos sacerdotes e o conselho superior estavam tentando encontrar alguma evidência falsa contra Jesus para que, então, o pudessem condenar à morte. ");
INSERT INTO porblt_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mas, eles não conseguiam encontrar nada, ainda que muitas testemunhas falsas se apresentassem contra ele. Finalmente, dois homens se aproximaram ");
INSERT INTO porblt_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","e relataram: “Este homem disse: ‘Eu posso destruir o Templo de Deus e reconstruí-lo em três dias.’” ");
INSERT INTO porblt_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","O grande sacerdote se levantou e perguntou para Jesus: “Você não irá responder? O que você tem a dizer em sua defesa?” ");
INSERT INTO porblt_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mas, Jesus permaneceu em silêncio. O grande sacerdote disse a Jesus: “Em nome do Deus vivo, eu o coloco sob juramento. Diga se você é o Messias, o Filho de Deus.” ");
INSERT INTO porblt_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus respondeu: “É o senhor quem está dizendo isso. E eu também lhes digo que, no futuro, vocês verão o Filho do Homem sentado à direita do Todo-Poderoso e vindo nas nuvens do céu.” ");
INSERT INTO porblt_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Então, o grande sacerdote rasgou suas roupas e disse: “Ele está insultando a Deus! Por que precisamos de mais testemunhas? Vejam! Agora, vocês ouviram por si mesmos a sua blasfêmia! ");
INSERT INTO porblt_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Qual é a sua decisão?” Eles responderam: “Culpado! Ele merece morrer!” ");
INSERT INTO porblt_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Então, eles deram um tapa em seu rosto e bateram nele. Alguns o esmurravam ");
INSERT INTO porblt_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","e diziam: “Messias, adivinhe e diga-nos quem bateu em você!” ");
INSERT INTO porblt_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nesse meio tempo, Pedro estava sentado do lado de fora do pátio. Uma empregada veio e lhe disse: “Você também estava com Jesus da Galileia!” ");
INSERT INTO porblt_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mas, ele negou isso na frente de todos, dizendo: “Eu não sei do que você está falando.” ");
INSERT INTO porblt_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Quando ele voltou para a entrada do pátio, outra empregada o viu e disse para as pessoas que lá estavam: “Este homem estava com Jesus de Nazaré.” ");
INSERT INTO porblt_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Uma vez mais Pedro negou, dizendo com um juramento: “Eu não o conheço.” ");
INSERT INTO porblt_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pouco tempo depois, as pessoas que estavam lá paradas se aproximaram de Pedro e disseram: “Definitivamente, você é um deles. O seu modo de falar o entrega.” ");
INSERT INTO porblt_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Então, ele começou a jurar: “Que Deus me castigue se eu estiver mentindo! Eu não conheço aquele homem!” Nesse mesmo instante, o galo cantou. ");
INSERT INTO porblt_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Então, Pedro se lembrou do que Jesus lhe tinha dito: “Antes do galo cantar, você negará que me conhece por três vezes.” Ele saiu dali e chorou amargamente. ");
INSERT INTO porblt_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","No outro dia de manhã, todos os chefes dos sacerdotes e anciãos do povo se reuniram e decidiram que Jesus deveria ser condenado à morte. ");
INSERT INTO porblt_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Eles o amarraram e o levaram até Pilatos, o governador. ");
INSERT INTO porblt_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Quando Judas, o traidor de Jesus, viu que Jesus tinha sido condenado à morte, ele se arrependeu do que tinha feito e foi devolver as trinta moedas de prata para os chefes dos sacerdotes e anciãos do povo. Ele lhes disse: ");
INSERT INTO porblt_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Eu pequei! Traí um homem inocente!” Eles responderam: “O que é que nós temos com isso? O problema é seu!” ");
INSERT INTO porblt_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas jogou as moedas de prata no chão do santuário e saiu. Ele foi embora e se enforcou. ");
INSERT INTO porblt_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Os chefes dos sacerdotes pegaram as moedas e disseram: “Este dinheiro está sujo de sangue. Então, não é permitido que o coloquemos na caixa de ofertas do Templo.” ");
INSERT INTO porblt_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Assim, eles concordaram em comprar o campo do oleiro, para servir como cemitério para os não-judeus. ");
INSERT INTO porblt_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","É por isso que o campo é chamado, até hoje, de “Campo de Sangue.” ");
INSERT INTO porblt_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Assim se cumpriu a profecia de Jeremias: “Eles pegaram as trinta moedas de prata, o ‘valor’ daquele que foi comprado pelo preço estabelecido por alguns dos filhos de Israel, ");
INSERT INTO porblt_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","e as usaram para comprar o campo do oleiro, exatamente como o Senhor me orientou fazer.” ");
INSERT INTO porblt_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus foi trazido diante de Pilatos, o governador, que lhe perguntou: “Você é o Rei dos Judeus?” Jesus respondeu: “É você quem está dizendo isso.” ");
INSERT INTO porblt_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mas, quando os chefes dos sacerdotes e os anciãos do povo o acusaram, Jesus não respondeu. ");
INSERT INTO porblt_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatos perguntou a Jesus: “Você não ouviu as acusações que eles lhe fizeram?” ");
INSERT INTO porblt_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesus não disse nada, nem uma única palavra. Isso realmente surpreendeu o governador. ");
INSERT INTO porblt_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Era o costume na festa da Páscoa que o governador libertasse o prisioneiro que a multidão escolhesse. ");
INSERT INTO porblt_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Naquela época, havia um conhecido prisioneiro chamado Barrabás. ");
INSERT INTO porblt_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Então, Pilatos perguntou à multidão que estava ali reunida: “Quem vocês querem que eu solte: Barrabás ou Jesus, chamado o Messias?” ");
INSERT INTO porblt_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Ele percebeu que era por causa de inveja que eles tinham entregado Jesus para ser julgado.) ");
INSERT INTO porblt_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Enquanto Pilatos estava sentado no tribunal, sua esposa lhe enviou uma mensagem que dizia: “Não faça nada contra este homem inocente, pois hoje, num sonho, eu sofri muito por causa dele.” ");
INSERT INTO porblt_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mas, os chefes dos sacerdotes e os anciãos do povo convenceram a multidão a pedir por Barrabás e condenar Jesus à morte. ");
INSERT INTO porblt_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Quando o governador lhes perguntou: “Então, qual dos dois vocês querem que eu solte?” Eles responderam: “Barrabás.” ");
INSERT INTO porblt_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","E, então, Pilatos perguntou: “Neste caso, o que eu devo fazer com Jesus, o Messias?” Eles gritaram: “Crucifique-o!” ");
INSERT INTO porblt_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatos perguntou: “Por quê? Qual crime ele cometeu?” Mas, eles gritaram ainda mais alto: “Crucifique-o!” ");
INSERT INTO porblt_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Quando Pilatos viu que essa era uma causa perdida e que o tumulto estava começando, ele pediu água e lavou as mãos na frente da multidão. Ele lhes disse: “Sou inocente da morte deste homem. Isso é com vocês!” ");
INSERT INTO porblt_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Todas as pessoas responderam: “Que o seu sangue esteja em nossas mãos e nas mãos dos nossos filhos!” ");
INSERT INTO porblt_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Então, ele soltou Barrabás, mas mandou chicotear Jesus e o enviou para ser crucificado. ");
INSERT INTO porblt_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Os soldados do governador levaram Jesus para o Pretório e toda a tropa o cercou. ");
INSERT INTO porblt_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Eles tiraram a roupa dele e colocaram sobre ele um manto púrpura. ");
INSERT INTO porblt_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Eles fizeram uma coroa de espinhos e a colocaram em sua cabeça e puseram um bastão na sua mão direita. Eles se ajoelharam diante dele e zombaram, dizendo: “Nós o saudamos, Rei dos Judeus!” ");
INSERT INTO porblt_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eles cuspiram nele e lhe tiraram o bastão, batendo em sua cabeça com isso. ");
INSERT INTO porblt_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Quando pararam de ridicularizá-lo, eles tiraram o manto e colocaram novamente as suas roupas. Então, eles o levaram para longe, para crucificá-lo. ");
INSERT INTO porblt_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","No caminho, encontraram um homem chamado Simão, da cidade de Cirene, e o forçaram a carregar a cruz de Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Quando chegaram ao monte Gólgota, que significa “Lugar da Caveira”, ");
INSERT INTO porblt_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","eles deram a Jesus vinho misturado com fel. Mas, ao provar, Jesus se recusou a beber. ");
INSERT INTO porblt_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Depois deles o terem crucificado, jogaram os dados para decidir com quem ficaria cada peça das roupas de Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Então, eles se sentaram ali e ficaram guardando Jesus. ");
INSERT INTO porblt_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Eles colocaram uma placa sobre a sua cabeça com a seguinte acusação: “Este é Jesus, o Rei dos Judeus.” ");
INSERT INTO porblt_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Eles crucificaram dois ladrões junto com ele, um, a sua direita e o outro, a sua esquerda. ");
INSERT INTO porblt_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","As pessoas que passavam o insultavam, balançavam a cabeça e ");
INSERT INTO porblt_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","diziam: “Você que disse que poderia destruir o Templo e reconstruí-lo em três dias, por que não se salva? Se você é realmente o Filho de Deus, então, desça da cruz!” ");
INSERT INTO porblt_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Os chefes dos sacerdotes, os educadores religiosos e os anciãos do povo zombavam dele da mesma maneira. ");
INSERT INTO porblt_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Eles diziam: “Ele salvou outras pessoas, mas não pode se salvar! Se ele é mesmo o rei de Israel, que desça da cruz e, então, nós iremos crer nele! ");
INSERT INTO porblt_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ele confia em Deus com tanta convicção! Bem, deixe que Deus o salve agora, se ele o quiser, pois ele afirmou: ‘Eu sou o Filho de Deus.’” ");
INSERT INTO porblt_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Os ladrões que foram crucificados com ele também o insultavam da mesma maneira. ");
INSERT INTO porblt_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Do meio-dia até às três da tarde, a escuridão cobriu todo o país. ");
INSERT INTO porblt_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Próximo das três da tarde, Jesus gritou: “Eli, Eli, lamá sabachthani”?, que significa: “Meu Deus, meu Deus, por que você me abandonou?” ");
INSERT INTO porblt_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Algumas pessoas que estavam lá e ouviram isso, disseram: “Ele está chamando Elias!” ");
INSERT INTO porblt_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Imediatamente, um deles correu e molhou uma esponja em vinagre, colocou-a na ponta de um bastão e deu para que Jesus bebesse. ");
INSERT INTO porblt_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mas, os outros disseram: “Deixe-o sozinho. Vamos ver se Elias vem salvá-lo!” ");
INSERT INTO porblt_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesus gritou novamente e deu o seu último suspiro. ");
INSERT INTO porblt_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Naquele exato momento, a cortina do Templo se rasgou de cima até embaixo. A terra tremeu, as rochas se partiram ");
INSERT INTO porblt_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","e os túmulos se abriram. Muitas pessoas que viveram conforme os mandamentos e que haviam morrido voltaram à vida. ");
INSERT INTO porblt_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Após a ressurreição de Jesus, elas saíram dos cemitérios e entraram na cidade santa, onde muitas pessoas as viram. ");
INSERT INTO porblt_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Quando o comandante romano e os que guardavam Jesus viram o tremor e o que aconteceu, eles ficaram aterrorizados e disseram: “Este é realmente o Filho de Deus!” ");
INSERT INTO porblt_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Muitas mulheres também olhavam à distância. Elas tinham acompanhado Jesus desde a Galileia e o haviam ajudado. ");
INSERT INTO porblt_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Entre elas estavam Maria Madalena, Maria, mãe de Tiago e de José, e a mãe dos filhos de Zebedeu. ");
INSERT INTO porblt_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Quando a noite chegou, um homem rico, chamado José, da cidade de Arimateia, (que também era um discípulo de Jesus), ");
INSERT INTO porblt_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","foi até Pilatos e lhe pediu o corpo de Jesus. Pilatos ordenou que o entregassem a ele. ");
INSERT INTO porblt_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José levou o corpo e o enrolou em um tecido novo de linho ");
INSERT INTO porblt_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","e o colocou em seu próprio túmulo, que havia sido cavado recentemente em uma rocha. Ele colocou uma grande pedra na entrada do túmulo e foi embora. ");
INSERT INTO porblt_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Madalena e a outra Maria foram até lá e se sentaram em frente ao túmulo. ");
INSERT INTO porblt_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","No dia seguinte, após o dia da Preparação, os chefes dos sacerdotes e os fariseus foram juntos ver Pilatos. ");
INSERT INTO porblt_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Eles lhe disseram: “Senhor, nós lembramos o que o impostor disse enquanto ainda estava vivo: ‘Após três dias, eu ressuscitarei.’ ");
INSERT INTO porblt_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dê ordem para que o túmulo seja vigiado até o terceiro dia. Assim, os seus discípulos não poderão vir, roubar o seu corpo e dizer às pessoas que ele ressuscitou dos mortos. Pois essa última mentira será ainda pior do que a primeira.” ");
INSERT INTO porblt_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatos lhes disse: “Estes soldados os acompanharão. Agora vão e guardem o túmulo da melhor maneira possível.” ");
INSERT INTO porblt_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Então, eles foram e fizeram a segurança do túmulo, colocando um selo na pedra da entrada e deixando os guardas vigiando. ");
INSERT INTO porblt_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Depois do sábado, no domingo, ainda de madrugada, Maria Madalena e a outra Maria foram ver o túmulo. ");
INSERT INTO porblt_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","De repente, houve um grande tremor de terra, pois um anjo do Senhor desceu do céu, tirou a pedra da entrada e se sentou nela. ");
INSERT INTO porblt_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Seu rosto brilhava como o relâmpago, e suas roupas eram brancas como a neve. ");
INSERT INTO porblt_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Os guardas tremeram de medo e caíram como se tivessem morrido. ");
INSERT INTO porblt_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","O anjo disse às mulheres: “Não tenham medo! Eu sei que vocês estão procurando Jesus, que foi crucificado. ");
INSERT INTO porblt_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ele não está aqui. Ele ressuscitou dos mortos, exatamente como disse que faria. Venham e vejam onde o Senhor foi colocado. ");
INSERT INTO porblt_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Agora, sejam rápidas e digam aos seus discípulos que ele ressuscitou e que está indo adiante deles para a Galileia. Vocês o verão lá. É isso o que eu tinha para dizer a vocês!” ");
INSERT INTO porblt_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Elas deixaram o túmulo, rapidamente, com medo, mas também felizes e correram para contar tudo aos discípulos. ");
INSERT INTO porblt_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","De repente, Jesus veio para encontrá-las e cumprimentá-las. Elas se aproximaram dele, se ajoelharam e o adoraram. ");
INSERT INTO porblt_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Então, Jesus lhes disse: “Não tenham medo! Vão e digam aos meus irmãos para irem para a Galileia. E eles me encontrarão lá.” ");
INSERT INTO porblt_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Quando elas saíram, alguns dos guardas foram para a cidade e contaram aos chefes dos sacerdotes tudo o que havia acontecido. ");
INSERT INTO porblt_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Após os chefes dos sacerdotes terem se reunido com os anciãos do povo e elaborado um plano, eles subornaram os soldados com uma grande quantia em dinheiro. ");
INSERT INTO porblt_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Eles disseram aos soldados: “Digam que os seus discípulos vieram durante a noite e roubaram o corpo dele, enquanto vocês dormiam. ");
INSERT INTO porblt_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Se o governador ouvir isso, nós falaremos com ele e vocês não precisarão se preocupar.” ");
INSERT INTO porblt_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Então, os soldados pegaram o dinheiro e fizeram o que eles disseram. Essa história se espalhou entre o povo judeu desde esse dia. ");
INSERT INTO porblt_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mas, os onze discípulos foram para a Galileia, para o monte que Jesus havia indicado. ");
INSERT INTO porblt_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Quando o viram, eles o adoraram, embora alguns duvidassem. ");
INSERT INTO porblt_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesus veio até eles e lhes disse: “Todo poder no céu e na terra foi dado a mim. ");
INSERT INTO porblt_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Então, vão a todas as nações do mundo e façam com que me sigam. Batizem essas pessoas em nome do Pai, do Filho e do Espírito Santo. ");
INSERT INTO porblt_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ensinem para que eles cumpram todos os mandamentos que eu lhes dei. Lembrem-se de que eu estou sempre com vocês, até o fim do mundo.” ");
INSERT INTO porblt_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aqui começa o evangelho de Jesus Cristo, o Filho de Deus. ");
INSERT INTO porblt_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Exatamente como o profeta Isaías escreveu: “Estou enviando o meu mensageiro antes de você, para preparar o seu caminho. ");
INSERT INTO porblt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Alguém está gritando no deserto: ‘Preparem o caminho para o Senhor! Abram um caminho reto para ele!’” ");
INSERT INTO porblt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","João Batista apareceu no deserto, anunciando um batismo de arrependimento para o perdão dos pecados. ");
INSERT INTO porblt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Todos os moradores da Judeia e de Jerusalém foram até ele. Eles confessaram os seus pecados e foram batizados no rio Jordão. ");
INSERT INTO porblt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","João usava uma roupa feita de pelo de camelo e um cinto de couro. Ele comia gafanhotos e mel silvestre. ");
INSERT INTO porblt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Isto é o que ele dizia ao povo: “Aquele que virá depois de mim é mais poderoso do que eu. Eu não sou digno nem mesmo de tirar as suas sandálias. ");
INSERT INTO porblt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Eu os batizo com água, mas ele os batizará com o Espírito Santo.” ");
INSERT INTO porblt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Então, Jesus veio de Nazaré da Galileia e foi batizado por João no rio Jordão. ");
INSERT INTO porblt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Assim que Jesus saiu da água, ele viu os céus se abrirem e o Espírito, como uma pomba, descer e pousar sobre ele. ");
INSERT INTO porblt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Uma voz vinda do céu disse: “Você é o meu Filho, a quem eu amo e que me deixa muito feliz.” ");
INSERT INTO porblt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Logo em seguida, o Espírito o mandou para o deserto, ");
INSERT INTO porblt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","onde ele foi tentado por Satanás durante quarenta dias. Ele estava entre os animais selvagens, e os anjos cuidaram dele. ");
INSERT INTO porblt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mais tarde, após João ser preso, Jesus foi para a Galileia, anunciando as boas novas que vêm de Deus. ");
INSERT INTO porblt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesus dizia: “O tempo anunciado chegou! O Reino de Deus chegou! Arrependam-se e creiam no evangelho!” ");
INSERT INTO porblt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Andando à beira do mar da Galileia, Jesus viu Simão e o seu irmão André, jogando a rede de pesca na água, pois pescar era o meio de sobrevivência deles. ");
INSERT INTO porblt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus lhes disse: “Venham e sigam-me e eu lhes ensinarei a pescar pessoas!” ");
INSERT INTO porblt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Eles imediatamente largaram as redes e o seguiram. ");
INSERT INTO porblt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mais adiante, ele viu Tiago e o seu irmão João, filhos de Zebedeu. Eles estavam em um barco, consertando suas redes. ");
INSERT INTO porblt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Imediatamente, Jesus os chamou para segui-lo, e eles deixaram o seu pai Zebedeu no barco, com os empregados contratados, e seguiram Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Eles partiram para Cafarnaum e, no sábado, Jesus entrou na sinagoga e ensinou ali. ");
INSERT INTO porblt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","As pessoas ficaram maravilhadas com a sua forma de ensinar, pois ele falava com autoridade, diferente dos educadores religiosos. ");
INSERT INTO porblt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","De repente, ali mesmo na sinagoga, um homem possuído por um espírito mau começou a gritar: ");
INSERT INTO porblt_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus de Nazaré, por que você está nos incomodando? Você veio para nos destruir? Eu sei quem você é! Você é o Santo que Deus enviou!” ");
INSERT INTO porblt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus repreendeu o espírito mau, dizendo: “Fique quieto! Saia dele!” ");
INSERT INTO porblt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","O espírito mau gritou, fez o homem ter convulsões e saiu dele. ");
INSERT INTO porblt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Todos ficaram espantados com o que aconteceu. Eles perguntavam uns aos outros: “O que é isto? Este novo ensinamento tem tamanha autoridade? Mesmo os espíritos maus lhe obedecem!” ");
INSERT INTO porblt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","A notícia a respeito de Jesus se espalhou rapidamente por toda a região da Galileia. ");
INSERT INTO porblt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Então, eles saíram da sinagoga e foram para a casa de Simão e de André, junto com Tiago e João. ");
INSERT INTO porblt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A sogra de Simão estava deitada na cama, com febre. Eles, então, falaram com Jesus a respeito dela. ");
INSERT INTO porblt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ele se aproximou dela, segurou a sua mão e a ajudou a se levantar. Ela imediatamente ficou sem febre. Depois, ela preparou a comida para eles. ");
INSERT INTO porblt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Após o pôr-do-sol naquela tarde, as pessoas trouxeram os doentes e os possuídos por demônios para Jesus curar. ");
INSERT INTO porblt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Todas as pessoas da cidade se reuniram fora da casa de Simão. ");
INSERT INTO porblt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ele curou muitas pessoas que tinham diversas doenças e expulsou muitos demônios. Ele não permitia que os demônios falassem, pois eles sabiam quem ele era. ");
INSERT INTO porblt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","De manhã, bem cedo, enquanto o céu ainda estava escuro, Jesus se levantou e foi sozinho para um lugar calmo, para orar. ");
INSERT INTO porblt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simão e os outros foram procurá-lo. ");
INSERT INTO porblt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Quando o encontraram, eles lhe disseram: “Todos estão procurando você.” ");
INSERT INTO porblt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesus respondeu: “Nós precisamos ir para outras cidades próximas daqui, para que eu também possa anunciar o evangelho lá. Afinal, foi para isso que eu vim.” ");
INSERT INTO porblt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Então, ele percorreu toda a Galileia, anunciando seus ensinamentos nas sinagogas e expulsando os demônios. ");
INSERT INTO porblt_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Um leproso veio até ele, pedindo ajuda. O homem se ajoelhou diante de Jesus, dizendo: “Por favor, se você quiser, você pode me curar!” ");
INSERT INTO porblt_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Com pena, Jesus se aproximou, tocou nele e disse: “Sim, eu quero! Você está curado!” ");
INSERT INTO porblt_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A lepra o deixou imediatamente, e ele ficou curado. ");
INSERT INTO porblt_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesus o avisou antes de mandá-lo embora: ");
INSERT INTO porblt_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Cuidado para não contar sobre isso a ninguém. Vá e peça ao sacerdote que o examine. E ofereça o sacrifício que Moisés exigiu por essa purificação, para que as pessoas tenham uma prova”. ");
INSERT INTO porblt_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mas, o leproso curado foi e disse a todos o que tinha acontecido. Com isso, Jesus não podia mais ir publicamente às cidades. Ele precisou ficar em lugares mais afastados. E pessoas de todas as partes vinham procurá-lo. ");
INSERT INTO porblt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Alguns dias depois, Jesus retornou à cidade de Cafarnaum, e a notícia de que ele estava em casa se espalhou. ");
INSERT INTO porblt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tantas pessoas se juntaram, que a casa ficou lotada, não havendo espaço nem do lado de fora perto da porta. Enquanto Jesus lhes anunciava a mensagem, ");
INSERT INTO porblt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","quatro homens trouxeram um paralítico. ");
INSERT INTO porblt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","No entanto, eles não conseguiam chegar perto de Jesus, por causa da multidão. Então, eles subiram no telhado. Após terem feito um buraco exatamente acima de onde Jesus estava, eles desceram o paralítico, deitado em uma esteira. ");
INSERT INTO porblt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Quando Jesus viu a fé que esses homens tinham, disse ao paralítico: “Filho, os seus pecados estão perdoados.” ");
INSERT INTO porblt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Alguns educadores religiosos que estavam sentados ali pensaram: ");
INSERT INTO porblt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Por que ele está falando assim? Ele está insultando a Deus! Quem pode perdoar pecados? Apenas Deus pode fazer isso!” ");
INSERT INTO porblt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesus sabia exatamente o que eles estavam pensando. Ele lhes disse: “Por que vocês estão pensando dessa maneira? ");
INSERT INTO porblt_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","O que é mais fácil? Dizer a um paralítico: ‘Seus pecados estão perdoados,’ ou: ‘Levante-se, pegue a sua esteira e ande’? ");
INSERT INTO porblt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mas, para mostrar a vocês que o Filho do Homem tem o direito de perdoar pecados, ");
INSERT INTO porblt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","disse ao paralítico: ‘Levante-se, pegue a sua esteira e vá para casa.’” ");
INSERT INTO porblt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ele ficou em pé, pegou a sua esteira e caminhou na frente de todos que estavam lá. Eles ficaram impressionados e louvaram a Deus, dizendo: “Nós jamais vimos algo assim!” ");
INSERT INTO porblt_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus mais uma vez saiu e foi para perto do mar da Galileia, onde ensinava para as multidões que vinham até ele. ");
INSERT INTO porblt_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Conforme caminhava, ele viu Levi, filho de Alfeu, sentado no lugar em que cobrava impostos. Jesus lhe disse: “Siga-me!” Levi se levantou e seguiu Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Naquela noite, Jesus jantou na casa de Levi. Muitos cobradores de impostos e “pecadores” se juntaram a Jesus e a seus discípulos para a refeição, pois muitos deles seguiram Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Quando os líderes religiosos dos fariseus viram Jesus comendo com essas pessoas, perguntaram aos seus discípulos: “Por que ele come com cobradores de impostos e com pecadores?” ");
INSERT INTO porblt_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Quando Jesus ouviu isso, lhes disse: “Não são as pessoas saudáveis que precisam de um médico, mas, sim, as que estão doentes. Eu não vim para convidar os que vivem uma vida correta, mas os que não vivem assim, ou seja, os pecadores.” ");
INSERT INTO porblt_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Naqueles dias, os discípulos de João Batista e os fariseus estavam jejuando. Alguns deles se aproximaram de Jesus e lhe perguntaram: “Por que os discípulos de João e os fariseus jejuam, mas os seus discípulos não?” ");
INSERT INTO porblt_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus, então, lhes perguntou: “Os convidados para um casamento jejuam enquanto o noivo está com eles? Não, enquanto o noivo está presente eles não podem jejuar. ");
INSERT INTO porblt_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mas, virá o dia quando o noivo se afastará e, então, eles jejuarão. ");
INSERT INTO porblt_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ninguém coloca um retalho de pano novo em uma roupa velha. Caso contrário, o retalho encolheria e aumentaria o rasgo da roupa. ");
INSERT INTO porblt_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ninguém também coloca vinho novo em odres velhos. Se alguém fizer isso, os recipientes de couro arrebentam e se perdem tanto o vinho quanto os recipientes. Definitivamente, não. Vinho novo deve ser colocado em recipientes de couro novos.” ");
INSERT INTO porblt_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","No sábado, enquanto Jesus caminhava pelos campos de trigo, os seus discípulos começaram a colher espigas, enquanto andavam. ");
INSERT INTO porblt_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Os fariseus perguntaram a Jesus: “Veja! Por que eles estão fazendo o que não é permitido aos sábados?” ");
INSERT INTO porblt_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesus lhes perguntou: “Vocês não leram o que Davi fez quando ele e seus homens estavam famintos e necessitados? ");
INSERT INTO porblt_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ele foi à casa de Deus, quando Abiatar era o grande sacerdote, e comeu os pães oferecidos a Deus, que ninguém tem permissão para comer, a não ser os sacerdotes, e também deixou que seus homens comessem os pães.” ");
INSERT INTO porblt_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ele lhes disse: “O sábado foi feito para servir a vocês e, não, para que vocês sirvam ao sábado. ");
INSERT INTO porblt_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Pois, o Filho do Homem é o Senhor até mesmo do sábado.” ");
INSERT INTO porblt_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesus foi novamente para a sinagoga. Havia um homem que estava lá e que tinha uma deficiência na mão. ");
INSERT INTO porblt_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Algumas pessoas que estavam na sinagoga observavam Jesus, para ver se ele iria curar o homem no sábado. Eles procuravam um motivo para acusá-lo de desobedecer à lei. ");
INSERT INTO porblt_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus disse ao homem com a deficiência: “Venha e fique diante de todos!” ");
INSERT INTO porblt_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ele lhes perguntou: “É permitido fazer o bem aos sábados ou fazer o mal? Vocês deveriam salvar vidas ou deveriam matar?” Mas, eles não disseram uma palavra. ");
INSERT INTO porblt_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus os olhou com irritação. Ele ficou muito zangado com a atitude insensível deles. Então, ele disse ao homem: “Estenda a sua mão!” O homem a estendeu e ela foi curada. ");
INSERT INTO porblt_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Os fariseus saíram e imediatamente começaram a fazer um plano com os apoiadores de Herodes para matar Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Enquanto isso, Jesus voltou para perto do mar, e uma grande multidão o seguiu. Eles eram da Galileia, da Judeia, ");
INSERT INTO porblt_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","de Jerusalém, da Idumeia, da Transjordânia e das regiões de Tiro e Sidom. Muitas pessoas vinham vê-lo, por já terem ouvido a respeito de tudo que ele estava fazendo. ");
INSERT INTO porblt_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesus disse aos seus discípulos para arranjarem um pequeno barco, para que ele não fosse esmagado pela multidão, ");
INSERT INTO porblt_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","pois ele tinha curado tantas pessoas, que os doentes se juntavam em torno dele para tocá-lo. ");
INSERT INTO porblt_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sempre que espíritos maus o viam, eles se ajoelhavam diante dele e gritavam: “Você é o Filho de Deus!” ");
INSERT INTO porblt_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mas, Jesus lhes ordenava para não revelarem quem ele era. ");
INSERT INTO porblt_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Então, Jesus subiu a um monte. Ele chamou aqueles que ele quis, e eles se aproximaram dele. ");
INSERT INTO porblt_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ele escolheu doze pessoas para estarem com ele e lhes chamou de apóstolos. Eles deveriam ficar com ele e seriam enviados para anunciar o evangelho. ");
INSERT INTO porblt_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Eles também teriam autoridade para expulsar os demônios. ");
INSERT INTO porblt_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Estes são os doze que Jesus escolheu: Simão (a quem ele chamou Pedro), ");
INSERT INTO porblt_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tiago e seu irmão João, filhos de Zebedeu (a quem Jesus chamou Boanerges, que significa “filhos do trovão”), ");
INSERT INTO porblt_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","André, Filipe, Bartolomeu, Mateus, Tomé, Tiago, filho de Alfeu, Tadeu, Simão, o revolucionário, ");
INSERT INTO porblt_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","e Judas Iscariotes (o traidor de Jesus). ");
INSERT INTO porblt_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesus foi para casa, mas uma multidão tão grande se reuniu novamente, que ele e os seus discípulos não tinham nem mesmo tempo para comer. ");
INSERT INTO porblt_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Quando a família de Jesus soube disso, eles vieram para levá-lo, dizendo: “Ele perdeu os sentidos!” ");
INSERT INTO porblt_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mas, os líderes religiosos de Jerusalém disseram: “Ele está possuído por Belzebu! É pelos poderes do rei do mal que ele está expulsando os demônios!” ");
INSERT INTO porblt_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesus chamou a todos que estavam ali para perto dele. Usando exemplos, ele lhes perguntou: “Como Satanás pode expulsar Satanás? ");
INSERT INTO porblt_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Um reino que se divide em grupos que lutam entre si não pode se manter. ");
INSERT INTO porblt_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Uma família que se encontra dividida está condenada. ");
INSERT INTO porblt_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Se Satanás se dividir e lutar contra si mesmo, ele não irá durar muito. Ele logo chegará ao fim. ");
INSERT INTO porblt_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Se alguém invadir a casa de um homem forte e tentar roubar suas coisas, ele não será bem sucedido em seu roubo, a menos que amarre o homem forte primeiro. ");
INSERT INTO porblt_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Eu lhes digo que isto é verdade: todos os pecados e as blasfêmias podem ser perdoados. ");
INSERT INTO porblt_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mas se as pessoas insultarem o Espírito Santo, elas nunca poderão ser perdoadas, pois são culpadas de um pecado eterno.” ");
INSERT INTO porblt_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Jesus disse isso porque eles disseram: “Ele tem um espírito mau.”) ");
INSERT INTO porblt_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Então, a mãe de Jesus e os seus irmãos chegaram. Eles ficaram do lado de fora e lhe enviaram uma mensagem, pedindo para que saísse. ");
INSERT INTO porblt_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A multidão que estava sentada em volta dele lhe disse: “A sua mãe e os seus irmãos estão lá fora, perguntando por você.” ");
INSERT INTO porblt_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ele respondeu: “Quem é minha mãe? Quem são meus irmãos?” ");
INSERT INTO porblt_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Olhando para todos que estavam ali sentados em volta dele, ele disse: “Aqui está a minha mãe! Aqui estão os meus irmãos! ");
INSERT INTO porblt_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Qualquer um que faça o que Deus quer é meu irmão, minha irmã e minha mãe.” ");
INSERT INTO porblt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus começou a ensinar na beira do mar novamente. Tantas pessoas vieram ouvi-lo, que ele entrou em um barco e se sentou, enquanto a multidão o ouvia na praia. ");
INSERT INTO porblt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ele exemplificava seus ensinamentos, usando muitas histórias. ");
INSERT INTO porblt_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ele disse: “Escutem! Um homem saiu para semear. ");
INSERT INTO porblt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Enquanto ele espalhava as sementes, algumas caíram pelo caminho, e os pássaros vieram e as comeram. ");
INSERT INTO porblt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Outras sementes caíram no chão duro como pedra, onde havia pouca terra, e logo começaram a germinar. Mas como o solo não era profundo, ");
INSERT INTO porblt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","elas foram queimadas pelo sol. E por não terem raízes, elas logo secaram. ");
INSERT INTO porblt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Outras sementes caíram entre os espinhos. Os espinhos cresceram e sufocaram as sementes que germinavam. Por essa razão, elas não produziram nada. ");
INSERT INTO porblt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mas, algumas sementes caíram em um bom solo, onde germinaram e se desenvolveram. Elas produziram uma colheita de trinta, sessenta e até cem vezes o que tinha sido plantado. ");
INSERT INTO porblt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Se vocês tiverem ouvidos para ouvir, ouçam o que eu digo.” ");
INSERT INTO porblt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Quando a multidão foi embora, Jesus ficou sozinho com seus doze discípulos e algumas outras pessoas que o acompanhavam. Eles lhe perguntaram o que as histórias significavam. ");
INSERT INTO porblt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesus lhes disse: “O mistério do Reino de Deus lhes foi dado, para que vocês o entendam. Mas, para as pessoas que estão de fora há apenas as histórias. ");
INSERT INTO porblt_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Assim, ainda que elas vejam, não veem realmente. E ainda que ouçam, não compreendem; se não, elas poderiam se voltar para mim e serem perdoadas.” ");
INSERT INTO porblt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“Vocês não entendem essa história?”, Jesus lhes perguntou. “Se vocês não a compreendem, como poderão entender todas as outras histórias? ");
INSERT INTO porblt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","O semeador semeia a palavra. ");
INSERT INTO porblt_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","As sementes no caminho, onde a palavra está semeada, representam as pessoas que ouvem a mensagem. Então, Satanás imediatamente aparece e leva a palavra que foi semeada nelas. ");
INSERT INTO porblt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Da mesma maneira, as sementes no chão duro como pedra representam as pessoas que ouvem a palavra e, com muita felicidade, a aceitam de imediato. ");
INSERT INTO porblt_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mas, por elas não terem raízes, sua fé dura apenas um breve momento, até que surjam os problemas e as perseguições e, então, elas rapidamente perdem a fé. ");
INSERT INTO porblt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aquelas semeadas entre os espinhos representam as pessoas que ouvem a palavra, ");
INSERT INTO porblt_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mas as preocupações deste mundo, a tentação da riqueza e outras distrações sufocam o crescimento da palavra, e ela se torna improdutiva. ");
INSERT INTO porblt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","As sementes que foram semeadas em um bom solo representam as pessoas que ouvem a palavra, aceitam a mensagem e são produtivas. Elas conseguem produzir trinta, sessenta e até cem vezes o que foi originalmente semeado.” ");
INSERT INTO porblt_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus lhes perguntou: “Quem coloca um lampião debaixo de um cesto ou debaixo da cama? Ninguém. Coloca-se o lampião em um velador. ");
INSERT INTO porblt_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Então, tudo que está escondido será revelado, e tudo que está em segredo será conhecido.” ");
INSERT INTO porblt_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ele lhes disse: “Se vocês tiverem ouvidos para ouvir, ouçam o que eu digo! ");
INSERT INTO porblt_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Prestem atenção ao que vocês ouvem, pois lhes será dado de acordo com o quanto queiram receber, medida por medida. ");
INSERT INTO porblt_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Será dado mais para aqueles que já entenderam, mas, aqueles que não querem saber terão o pouco que entendem tirado deles.” ");
INSERT INTO porblt_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus disse: “O Reino de Deus é como um homem que joga as sementes na terra. ");
INSERT INTO porblt_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ele dorme e acorda, dia após dia. Mas, o homem não sabe como as sementes germinam e se desenvolvem. ");
INSERT INTO porblt_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A terra produz a colheita por si mesma. Primeiro, um ramo aparece, depois, as espigas de trigo e, finalmente, as espigas amadurecem. ");
INSERT INTO porblt_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Quando o trigo amadurece, o dono da terra o colhe com uma foice, pois a colheita está pronta.” ");
INSERT INTO porblt_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus perguntou: “Com o que podemos comparar o Reino de Deus? Qual história devemos usar? ");
INSERT INTO porblt_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","É como a semente de mostarda, que é a menor de todas as sementes. ");
INSERT INTO porblt_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mas, depois de semeada, torna-se maior do que todas as hortaliças. Ela tem galhos grandes o bastante para que os pássaros possam fazer seus ninhos neles.” ");
INSERT INTO porblt_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus usava muitas dessas histórias quando falava com as pessoas, para que elas entendessem melhor. ");
INSERT INTO porblt_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Na verdade, quando ele falava em público, ele usava apenas histórias. No entanto, ao falar com os seus discípulos, em particular, ele lhes explicava tudo. ");
INSERT INTO porblt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Naquele mesmo dia, de tardinha, ele disse aos seus discípulos: “Vamos para o outro lado do Mar.” ");
INSERT INTO porblt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Então, os discípulos deixaram as pessoas ali e foram com Jesus e entraram em um barco. Outros barcos os seguiram. ");
INSERT INTO porblt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Logo, uma terrível tempestade começou, e as ondas batiam com força contra o barco, fazendo com que ele se enchesse de água. ");
INSERT INTO porblt_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus estava dormindo na parte traseira do barco, com a cabeça em uma almofada. Os discípulos o acordaram, gritando: “Mestre, você não se importa que nós morramos?” ");
INSERT INTO porblt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus acordou. Ele disse para que o vento parasse e falou para as ondas: “Fiquem quietas! Acalmem-se!” O vento parou de soprar e a água ficou completamente calma. ");
INSERT INTO porblt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesus perguntou aos discípulos: “Por que vocês são tão medrosos? Vocês ainda não aprenderam a ter fé em mim?” ");
INSERT INTO porblt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Eles estavam surpresos e apavorados. Perguntavam uns para os outros: “Quem é este? Até mesmo o vento e as ondas lhe obedecem!” ");
INSERT INTO porblt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Eles chegaram à região de Gerasa, no outro lado do lago. ");
INSERT INTO porblt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Quando Jesus saiu do barco, um homem possuído por um espírito mau saiu do cemitério para encontrá-lo. ");
INSERT INTO porblt_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Esse homem morava entre os túmulos e era impossível prendê-lo mesmo com correntes. ");
INSERT INTO porblt_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Várias vezes o prenderam com correntes e algemas, mas ele simplesmente arrebentava as correntes e quebrava as algemas em pedaços. Ninguém tinha força para dominá-lo. ");
INSERT INTO porblt_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ele passava dias e noites gritando entre os túmulos e nas colinas próximas, cortando-se com pedras pontiagudas. ");
INSERT INTO porblt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ao ver Jesus de longe, ele correu e se ajoelhou diante dele. ");
INSERT INTO porblt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ele gritou: “O que você quer de mim, Jesus, Filho do Deus Todo-Poderoso? Jure por Deus que não irá me torturar!” ");
INSERT INTO porblt_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ele disse isso porque Jesus já havia falado para o espírito mau deixá-lo. ");
INSERT INTO porblt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Então, Jesus lhe perguntou: “Qual é o seu nome?” Ele respondeu: “Meu nome é Legião, pois somos muitos.” ");
INSERT INTO porblt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ele também implorou, insistentemente, para que Jesus não os mandasse para longe. ");
INSERT INTO porblt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Um grande rebanho de porcos se alimentava na encosta próxima. ");
INSERT INTO porblt_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Os espíritos maus imploraram a Jesus: “Mande-nos para aqueles porcos, para que possamos entrar neles.” ");
INSERT INTO porblt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesus permitiu que eles fizessem o que pediram. Os espíritos maus saíram do homem e entraram nos porcos. Todo o rebanho, cerca de dois mil porcos, se atirou penhasco abaixo, caiu no mar e se afogou. ");
INSERT INTO porblt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Os homens que tomavam conta dos porcos fugiram e espalharam a notícia por toda a cidade e também pelos campos. As pessoas vieram para ver o que havia acontecido. ");
INSERT INTO porblt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Quando elas encontraram Jesus, viram o homem que tinha sido possuído pela legião de espíritos maus sentado ali, vestido e em seu juízo perfeito. As pessoas ficaram assustadas com aquilo. ");
INSERT INTO porblt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Então, aqueles que viram o que havia acontecido com o homem e com os porcos contaram aos outros. ");
INSERT INTO porblt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Eles começaram a implorar para que Jesus saísse daquele distrito. ");
INSERT INTO porblt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Quando Jesus entrou no barco, o homem que tinha sido possuído pela legião de demônios pediu para ir com ele. ");
INSERT INTO porblt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mas Jesus recusou, dizendo: “Vá para casa e conte para a sua família o que o Senhor lhe fez e como foi bom para você.” ");
INSERT INTO porblt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Então, o homem foi embora e começou a falar para as pessoas das Dez Cidades tudo o que Jesus tinha feito por ele, e todos ficaram maravilhados. ");
INSERT INTO porblt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus voltou, de barco, para o outro lado do lago, onde já havia uma grande multidão, aguardando-o na praia. ");
INSERT INTO porblt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Um líder da sinagoga, chamado Jairo, aproximou-se de Jesus. Ao vê-lo, Jairo caiu aos seus pés ");
INSERT INTO porblt_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","e implorou, dizendo: “Minha filhinha está quase morrendo. Por favor, venha e coloque suas mãos sobre ela para que possa ser curada e fique viva.” ");
INSERT INTO porblt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Então, Jesus foi com ele. Todos o seguiram, apertando-o e empurrando-o. ");
INSERT INTO porblt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Uma mulher que se encontrava lá estava doente há doze anos, por causa de uma hemorragia que não parava. ");
INSERT INTO porblt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ela sofreu muito sob os cuidados de vários médicos e já havia gastado todas as suas economias. Mas, ela não melhorou de sua doença. Na verdade, ela havia até mesmo piorado. ");
INSERT INTO porblt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ela ouvira falar sobre Jesus, então, veio por trás dele, abrindo caminho entre a multidão e tocou a sua capa. ");
INSERT INTO porblt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ela disse a si mesma: “Se eu conseguir tocar, mesmo que seja em sua capa, ficarei curada.” ");
INSERT INTO porblt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","A hemorragia parou imediatamente, e ela sentiu o seu corpo curado da doença. ");
INSERT INTO porblt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesus sentiu, no mesmo instante, que dele havia saído poder. Então, se virou e perguntou: “Quem tocou na minha capa?” ");
INSERT INTO porblt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Os discípulos responderam: “Veja esta multidão apertando-o! O que quer dizer com: ‘Quem tocou na minha capa?’” ");
INSERT INTO porblt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesus ficou olhando em volta, para ver quem o havia tocado. ");
INSERT INTO porblt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A mulher, percebendo o que havia acontecido, veio, se ajoelhou diante dele e lhe disse toda a verdade. ");
INSERT INTO porblt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesus lhe disse: “Minha filha, você foi curada porque teve fé em mim. Vá em paz. Você está curada da sua doença.” ");
INSERT INTO porblt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Enquanto ele ainda estava falando, algumas pessoas vieram da casa do líder da sinagoga. Eles disseram ao líder: “A sua filha morreu. Você não precisa mais incomodar o Mestre.” ");
INSERT INTO porblt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus não deu atenção ao que eles disseram. Ele falou ao líder da sinagoga: “Não tenha medo, apenas confie em mim.” ");
INSERT INTO porblt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ele deixou apenas que Pedro, Tiago e seu irmão, João, fossem com ele. ");
INSERT INTO porblt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Quando eles chegaram à casa do líder da sinagoga, Jesus viu todo o tumulto que havia ali. As pessoas choravam e lamentavam. ");
INSERT INTO porblt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ele entrou e lhes perguntou: “Por que vocês estão fazendo tanto tumulto com toda esta choradeira? A garotinha não está morta; ela está apenas dormindo.” ");
INSERT INTO porblt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","As pessoas riram, zombando dele. Jesus fez com que todos saíssem. Então, ele entrou no quarto em que a menina estava, levando com ele o pai e a mãe da criança, além dos três discípulos. ");
INSERT INTO porblt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pegando a mão da menina, ele disse: “Talitha koum”, que significa, “Garotinha, levante-se!” ");
INSERT INTO porblt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","A menina, que tinha doze anos de idade, levantou-se imediatamente e começou a caminhar. Eles ficaram completamente surpresos com o que acontecera. ");
INSERT INTO porblt_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesus, então, lhes ordenou para que não contassem a ninguém sobre a cura e que dessem algo para a menina comer. ");
INSERT INTO porblt_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus saiu de lá e foi para Nazaré, onde havia morado, acompanhado por seus discípulos. ");
INSERT INTO porblt_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","No sábado, ele começou a ensinar na sinagoga, e muitas pessoas que o ouviam ficaram surpresas. Elas se perguntavam: “De onde ele tira essas ideias? Que sabedoria é essa que ele recebeu? De onde vem o seu poder para fazer milagres? ");
INSERT INTO porblt_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ele não é o carpinteiro, filho de Maria e irmão de Tiago, José, Judas e Simão? As irmãs dele não vivem entre nós?” Eles ficaram desiludidos com ele e o rejeitaram. ");
INSERT INTO porblt_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesus lhes disse: “Um profeta é tratado com respeito em todos os lugares, menos em sua cidade, entre os seus parentes e dentro de sua própria família.” ");
INSERT INTO porblt_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Por isso, Jesus não conseguiu fazer milagres ali, a não ser curar uns poucos doentes, impondo as mãos sobre eles. ");
INSERT INTO porblt_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ele ficou impressionado com a falta de fé que havia ali. Jesus ensinou nas vilas que havia perto dali. ");
INSERT INTO porblt_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ele reuniu os doze discípulos e começou a enviá-los em duplas, dando autoridade para que expulsassem os espíritos maus. ");
INSERT INTO porblt_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ele lhes disse para não levarem nada, a não ser um bastão para ajudá-los na caminhada. Não deveriam levar pão, sacola e nem dinheiro em seus cintos. ");
INSERT INTO porblt_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Eles poderiam usar sandálias, mas não deveriam levar qualquer peça a mais de roupa. ");
INSERT INTO porblt_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jesus lhes disse: “Quando vocês forem convidados para uma casa, fiquem lá até o momento de partirem. ");
INSERT INTO porblt_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Se vocês não forem recebidos em algum lugar e as pessoas não os ouvirem, então, tire o pó dos seus pés quando saírem, como um protesto contra elas.” ");
INSERT INTO porblt_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Então, os discípulos foram dizendo às pessoas para se arrependerem. ");
INSERT INTO porblt_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Eles expulsaram muitos demônios e curaram muitas pessoas que estavam doentes, colocando azeite na cabeça delas. ");
INSERT INTO porblt_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","O rei Herodes ouviu falar sobre Jesus, pois ele tinha se tornado conhecido. Algumas pessoas diziam: “Este é João Batista, que ressurgiu dos mortos. É por isso que ele tem poderes para fazer milagres.” ");
INSERT INTO porblt_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Outros diziam: “Ele é Elias.” Outras pessoas ainda diziam: “Ele é um profeta como os outros profetas de antigamente.” ");
INSERT INTO porblt_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Quando Herodes ouviu sobre isso, ele disse: “Ele é João Batista, a quem eu mandei decapitar. Ele foi ressuscitado!” ");
INSERT INTO porblt_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Pois tinha sido Herodes quem dera ordens para prender João, por causa de Herodias, a esposa do seu irmão, Filipe, com quem Herodes havia se casado. ");
INSERT INTO porblt_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","João tinha dito a Herodes: “É contra a lei você se casar com a esposa do seu irmão.” ");
INSERT INTO porblt_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Então, Herodias tinha raiva de João e queria que ele morresse. Mas, ela não era capaz de conseguir isso, ");
INSERT INTO porblt_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","pois Herodes sabia que João Batista era um homem santo, que fazia o que era certo. Herodes protegeu João e, embora o que João tinha lhe dito o tivesse deixado muito incomodado, ele ainda ficava feliz em ouvir o que João tinha a dizer. ");
INSERT INTO porblt_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodias teve a sua oportunidade na festa de aniversário de Herodes. Ele deu um banquete para os nobres, oficiais militares e líderes importantes da Galileia. ");
INSERT INTO porblt_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","A filha de Herodias entrou e dançou para eles. Herodes e seus convidados ficaram encantados com a dança. Então, Herodes disse à garota: ");
INSERT INTO porblt_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“Você pode me pedir o que quiser e eu lhe darei.” Ele confirmou a sua promessa com um juramento: “Eu lhe darei até a metade do meu reino.” ");
INSERT INTO porblt_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ela saiu e perguntou a sua mãe: “O que eu devo pedir?” Sua mãe lhe respondeu: “A cabeça de João Batista.” ");
INSERT INTO porblt_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","A garota voltou correndo e disse ao rei: “Eu quero que você me dê imediatamente a cabeça de João Batista em um prato.” ");
INSERT INTO porblt_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","O rei ficou muito chateado, mas, por causa do juramento que fizera diante dos seus convidados, não quis recusar o pedido dela. ");
INSERT INTO porblt_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Então, ele rapidamente enviou um carrasco para trazer a cabeça de João. Após decapitá-lo na prisão, ");
INSERT INTO porblt_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","o carrasco trouxe a cabeça de João em um prato e a deu para a garota, e ela a entregou a sua mãe. ");
INSERT INTO porblt_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Quando os discípulos de João souberam o que havia acontecido, vieram e levaram o corpo e o enterraram. ");
INSERT INTO porblt_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Os apóstolos retornaram e se reuniram com Jesus. Eles lhe disseram tudo o que tinham feito e o que haviam ensinado. ");
INSERT INTO porblt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesus lhes disse: “Venham comigo. Apenas vocês. Nós iremos para um lugar calmo e descansaremos um pouco.” Havia tantas pessoas vindo e saindo que eles não tinham tempo nem para comer. ");
INSERT INTO porblt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Então, eles foram de barco para um lugar sossegado, para ficarem sozinhos. ");
INSERT INTO porblt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mas as pessoas os viram saindo e os reconheceram. Então, pessoas de todas as cidades vizinhas correram na frente e chegaram lá antes deles. ");
INSERT INTO porblt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Quando Jesus saiu do barco, viu uma grande multidão e sentiu muita pena daquelas pessoas, pois elas eram como ovelhas sem um pastor. Assim, ele começou a lhes ensinar muitas coisas. ");
INSERT INTO porblt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Estava anoitecendo e os discípulos de Jesus se aproximaram dele. Eles lhe disseram: “Estamos em um lugar muito isolado e está muito tarde. ");
INSERT INTO porblt_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Você deveria dizer para as pessoas irem comprar algo para comer nas vilas e nos sítios mais próximos.” ");
INSERT INTO porblt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mas Jesus respondeu: “Deem algo para eles comerem!” Os discípulos responderam: “O quê? Precisaríamos de mais de duzentas moedas de prata para comprar pão para alimentar todas essas pessoas.” ");
INSERT INTO porblt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","“Bem, quantos pães vocês têm?” Jesus perguntou. “Vão e vejam!” Eles foram e viram quantos pães tinham. E disseram a Jesus: “Cinco pães e dois peixes.” ");
INSERT INTO porblt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesus, então, disse para as pessoas se sentarem na grama, divididos em grupos. ");
INSERT INTO porblt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Elas se sentaram em grupos de cem e de cinquenta pessoas cada. ");
INSERT INTO porblt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Então, Jesus pegou os cinco pães e os dois peixes. Olhando para o céu, ele abençoou a comida e repartiu os pães em pedaços. Depois, ele deu os pães aos discípulos, para que eles distribuíssem para as pessoas, e dividiu os dois peixes entre todos eles. ");
INSERT INTO porblt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Todos comeram até ficarem satisfeitos. ");
INSERT INTO porblt_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Então, eles recolheram as sobras de pão e de peixe e encheram doze cestos. ");
INSERT INTO porblt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Um total de cinco mil homens comeram naquele dia. ");
INSERT INTO porblt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Imediatamente após isso, Jesus orientou seus discípulos a voltarem para o barco. Eles deveriam ir antes dele para o povoado de Betsaida, do outro lado do lago, enquanto ele despedia a multidão. ");
INSERT INTO porblt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Assim que ele se despediu das pessoas, subiu a um monte para orar. ");
INSERT INTO porblt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mais tarde, naquela noite, o barco estava no meio do lago, enquanto Jesus estava sozinho, ainda em terra. ");
INSERT INTO porblt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ele conseguia vê-los sendo golpeados pelas ondas, enquanto tentavam remar com muita dificuldade, por causa do vento que soprava contra eles. De madrugada, Jesus foi até eles, caminhando sobre a água. E ia passar adiante deles, ");
INSERT INTO porblt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","mas quando o viram andando sobre a água, pensaram que ele era um fantasma. Eles gritaram, ");
INSERT INTO porblt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","pois todos conseguiam vê-lo e estavam totalmente amedrontados. Jesus rapidamente lhes disse: “Não se preocupem, sou eu. Não tenham medo!” ");
INSERT INTO porblt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ele foi até eles, subiu no barco e o vento parou. Eles ficaram completamente chocados, ");
INSERT INTO porblt_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","pois não tinham entendido o significado do milagre da multiplicação dos pães e dos peixes, por causa de sua mente fechada. ");
INSERT INTO porblt_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Depois de atravessarem o mar, eles chegaram à região de Genesaré e amarraram o barco. ");
INSERT INTO porblt_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Conforme eles saíam do barco, as pessoas imediatamente reconheciam Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Elas chegavam de todos os lugares próximos dali, trazendo os seus doentes em esteiras para o lugar onde ouviam que Jesus estava. ");
INSERT INTO porblt_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Onde quer que eles fossem, nas vilas, cidades ou no campo, as pessoas levavam os doentes para as praças e imploravam para que Jesus deixasse que os doentes tocassem apenas na barra de suas roupas. E todos que o tocavam eram curados. ");
INSERT INTO porblt_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Os fariseus e os líderes religiosos que tinham vindo de Jerusalém para encontrar Jesus ");
INSERT INTO porblt_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","observaram que alguns dos seus discípulos comiam com mãos “impuras” (significando não lavadas). ");
INSERT INTO porblt_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Os fariseus e todos os judeus não comem até que lavem as suas mãos, seguindo a tradição dos seus ancestrais. ");
INSERT INTO porblt_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Da mesma maneira, não comem quando voltam do mercado até que tenham tomado banho. Eles seguem muitos outros rituais, como a limpeza de copos, jarros, vasilhas de metal e camas.) ");
INSERT INTO porblt_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Então, os fariseus e os líderes religiosos perguntaram a Jesus: “Por que os seus discípulos não seguem a tradição de nossos antepassados? Eles comem a comida com as mãos por lavar.” ");
INSERT INTO porblt_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus respondeu: “Isaías estava certo sobre vocês, hipócritas, quando disse: ‘Essas pessoas afirmam que me honram, mas, em seu pensamento, estão longe de mim. ");
INSERT INTO porblt_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Não faz sentido sua devoção a mim, pois o que eles ensinam como doutrinas são apenas regras humanas.’” E lhes falou: ");
INSERT INTO porblt_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Vocês desrespeitam a lei de Deus e, em vez disso, seguem cuidadosamente as tradições humanas.” ");
INSERT INTO porblt_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","E continuou dizendo: “É incrível como vocês põem de lado a lei de Deus, para que possam seguir as suas tradições! ");
INSERT INTO porblt_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés disse: ‘Honrem o seu pai e a sua mãe’, e também: ‘Aquele que amaldiçoar o seu pai e a sua mãe deve morrer.’ ");
INSERT INTO porblt_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mas vocês dizem que se alguém disser ao seu pai ou a sua mãe: ‘Tudo que você possa receber de mim, agora é Corbã’ (que significa dedicado a Deus), ");
INSERT INTO porblt_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","então, ele não precisa ajudar a sua mãe ou ao seu pai. ");
INSERT INTO porblt_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Por essa tradição, que passa de geração em geração, vocês tornam a palavra de Deus nula e sem sentido. E vocês fazem muitas outras coisas como essa.” ");
INSERT INTO porblt_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesus chamou novamente a multidão e lhes disse: “Por favor, todos me escutem e entendam. ");
INSERT INTO porblt_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Não é o que está fora e vai para dentro que os torna impuros. É o que sai de dentro que os torna impuros.” ");
INSERT INTO porblt_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Quando Jesus entrou em casa, deixando a multidão, os seus discípulos lhe perguntaram sobre o exemplo que ele tinha dado. ");
INSERT INTO porblt_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ele lhes perguntou: “Vocês também não entenderam? Não percebem que aquilo que vocês comem não é o que os torna impuros? ");
INSERT INTO porblt_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","A comida não vai para a sua mente e, sim, para o seu estômago e, depois, ela sai do corpo. Então, todos os alimentos são cerimonialmente ‘puros.’ ");
INSERT INTO porblt_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","É o que sai de dentro de vocês que os torna impuros. ");
INSERT INTO porblt_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","É de dentro, das mentes das pessoas, que surgem os maus pensamentos: imoralidade sexual, roubo, assassinato, adultério, ");
INSERT INTO porblt_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ganância, malícia, mentira, indecência, inveja, calúnia, orgulho e falar e agir sem pensar nas consequências. ");
INSERT INTO porblt_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Todas essas maldades vêm de dentro e tornam as pessoas impuras.” ");
INSERT INTO porblt_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Então, Jesus saiu dali e foi para a região de Tiro. Ele não queria que ninguém soubesse que ele estava em uma casa dali, mas não conseguiu manter isso em segredo. ");
INSERT INTO porblt_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Assim que uma mulher, cuja filha estava possuída por um espírito mau, ouviu sobre ele, veio e se ajoelhou aos seus pés. ");
INSERT INTO porblt_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A mulher era grega, de nacionalidade siro-fenícia. Ela implorou para que Jesus expulsasse da sua filha o demônio. ");
INSERT INTO porblt_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesus respondeu: “Primeiro, deixe que os filhos comam até ficarem satisfeitos. Não é certo tirar o alimento dos filhos e jogá-lo aos cães.” ");
INSERT INTO porblt_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ela disse: “É verdade, senhor, mas até mesmo os cães comem as sobras que os filhos deixam cair debaixo da mesa.” ");
INSERT INTO porblt_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesus lhe disse: “Por causa de sua resposta, você pode ir; o demônio já saiu de sua filha.” ");
INSERT INTO porblt_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ela foi para casa e encontrou a sua filha deitada na cama, pois o demônio já havia saído dela. ");
INSERT INTO porblt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Saindo da região de Tiro, Jesus passou por Sidom e, depois, pelo mar da Galileia e pelo território das Dez Cidades. ");
INSERT INTO porblt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Lá, eles lhe levaram um homem surdo, que também não conseguia falar muito bem. Eles pediram que Jesus tocasse no homem com a sua mão e o curasse. ");
INSERT INTO porblt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Após Jesus tirá-lo do meio da multidão, colocou os seus dedos nos ouvidos do homem surdo. Depois, Jesus cuspiu e colocou um pouco do seu cuspe na língua do homem. ");
INSERT INTO porblt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jesus olhou para o céu e com um suspiro disse: “Efatá”, que significa, “Abra-se!” ");
INSERT INTO porblt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Os ouvidos do homem se abriram, seu problema de fala acabou, e ele começou a falar sem dificuldade. ");
INSERT INTO porblt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus ordenou para que ninguém contasse o que tinha acontecido. Mas quanto mais Jesus dizia isso, mais eles espalhavam a notícia. ");
INSERT INTO porblt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Eles ficaram completamente impressionados e disseram: “Tudo que ele faz é maravilhoso. Ele fez até mesmo o surdo ouvir, e o mudo falar!” ");
INSERT INTO porblt_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pouco tempo depois, formou-se outra grande multidão, que não tinha nada para comer. Jesus chamou os seus discípulos e lhes disse: ");
INSERT INTO porblt_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Estou com pena dessas pessoas, porque elas já estão comigo há três dias e não têm nada para comer. ");
INSERT INTO porblt_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Se eu as mandar para casa sem comer, elas poderão desmaiar pelo caminho. Algumas delas vieram de longe.” ");
INSERT INTO porblt_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Os discípulos responderam: “Onde se conseguiria encontrar pão suficiente para alimentá-las aqui neste lugar isolado?” ");
INSERT INTO porblt_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus perguntou: “Quantos pães vocês têm?” Eles responderam: “Sete.” ");
INSERT INTO porblt_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesus pediu que a multidão se sentasse no chão. Então, ele pegou os sete pães e deu graças a Deus. Ele partiu os pães e deu os pedaços para que os seus discípulos distribuíssem para a multidão. ");
INSERT INTO porblt_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Os discípulos também tinham alguns peixes, que Jesus abençoou e disse: “Peguem estes peixes e os distribuam também!” ");
INSERT INTO porblt_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Eles comeram e ficaram satisfeitos; depois, recolheram as sobras e com elas encheram sete cestos. ");
INSERT INTO porblt_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Havia quatro mil pessoas lá. Após se despedir das pessoas, ");
INSERT INTO porblt_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jesus entrou em um barco com seus discípulos e foi para a região da Dalmanuta. ");
INSERT INTO porblt_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Os fariseus chegaram e começaram a discutir com Jesus. Eles queriam que ele lhes desse um sinal milagroso que viesse do céu, para que ele mostrasse que seu poder vinha de Deus. ");
INSERT INTO porblt_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesus suspirou profundamente e respondeu: “Por que vocês querem um sinal? Eu lhes digo que isto é verdade: Eu não lhes darei um sinal.” ");
INSERT INTO porblt_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Então, ele foi embora, subiu no barco e voltou para o outro lado do lago. ");
INSERT INTO porblt_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mas, os discípulos se esqueceram de levar pão para a viagem. Tudo que eles tinham para comer no barco era um pão. ");
INSERT INTO porblt_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus, então, os alertou: “Atenção! Tenham cuidado com o fermento dos fariseus e de Herodes!” ");
INSERT INTO porblt_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Os discípulos falaram entre si: “Ele está dizendo isso é porque não trouxemos pão para a viagem.” ");
INSERT INTO porblt_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus sabia o que eles estavam falando e lhes disse: “Por que vocês estão falando que não têm pão? Vocês ainda não me entendem? Vocês fecharam as suas mentes? ");
INSERT INTO porblt_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Vocês têm olhos para enxergar, não é mesmo? E ouvidos para ouvir? ");
INSERT INTO porblt_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Vocês não se lembram quando eu dividi cinco pães entre cinco mil pessoas? Quantos cestos com sobras vocês recolheram?” Eles responderam: “Doze.” ");
INSERT INTO porblt_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“E de quando eu parti os sete pães para quatro mil pessoas, quantos cestos com sobras vocês recolheram?” Os discípulos disseram: “Sete.” ");
INSERT INTO porblt_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ele, então, lhes perguntou: “Vocês ainda não compreendem?” ");
INSERT INTO porblt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Eles foram para o povoado de Betsaida, onde algumas pessoas trouxeram um homem cego a Jesus. Eles imploraram para que Jesus o tocasse e curasse. ");
INSERT INTO porblt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ele pegou o cego e o levou para fora do povoado. Jesus aplicou saliva nos olhos do homem e o tocou com suas mãos. Então, Jesus lhe perguntou: “Você consegue ver?” ");
INSERT INTO porblt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","O homem olhou em volta e disse: “Eu consigo ver as pessoas, mas parecem árvores andando.” ");
INSERT INTO porblt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesus tocou os olhos do homem novamente. Agora, ele conseguiu enxergar perfeitamente. Ele estava curado e a sua visão ficou clara. ");
INSERT INTO porblt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesus mandou o homem para casa e lhe disse: “Não volte pelo povoado.” ");
INSERT INTO porblt_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesus e os seus discípulos saíram de Betsaida e foram para as vilas de Cesareia de Filipe. No caminho, ele perguntou aos seus discípulos: “Quem as pessoas dizem que eu sou?” ");
INSERT INTO porblt_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Eles responderam: “Alguns dizem que você é João Batista; outros dizem que é Elias; e há ainda alguns que dizem que é um dos profetas.” ");
INSERT INTO porblt_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ele, então, lhes perguntou: “Mas, quem vocês dizem que eu sou?” Pedro respondeu: “Você é o Messias!” ");
INSERT INTO porblt_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesus os advertiu para que não falassem sobre isso com ninguém. ");
INSERT INTO porblt_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Então, Jesus começou a explicar para eles que o Filho do Homem sofreria muitas coisas e que seria rejeitado pelos anciãos do povo, chefes dos sacerdotes e pelos educadores religiosos. Ele seria morto, mas, três dias depois, ele ressuscitaria. ");
INSERT INTO porblt_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesus lhes explicou isso de forma clara. Mas Pedro o levou para um lado e começou a repreendê-lo pelo que ele havia dito. ");
INSERT INTO porblt_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesus virou-se, olhou para os seus discípulos e repreendeu Pedro. Ele disse: “Saia de perto de mim, Satanás! Você não está pensando como Deus pensa, mas, sim, como os seres humanos pensam.” ");
INSERT INTO porblt_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesus chamou a multidão e os seus discípulos e lhes disse: “Se vocês querem me seguir, devem renunciar a si mesmos. Peguem a sua cruz e me sigam. ");
INSERT INTO porblt_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Se quiserem salvar sua vida, vocês a perderão; mas, se perderem sua vida, por mim e pelo evangelho, vocês a salvarão. ");
INSERT INTO porblt_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Do que vale para vocês ganharem tudo o que há no mundo e perder a vida verdadeira? ");
INSERT INTO porblt_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O que vocês dariam em troca dessa vida? ");
INSERT INTO porblt_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Se vocês tiverem vergonha de mim e do que eu digo entre estas pessoas pecadoras e sem fé, então, o Filho do Homem terá vergonha de vocês, quando ele vier na glória do seu Pai, com os santos anjos.” ");
INSERT INTO porblt_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesus lhes disse: “Eu lhes digo que isto é verdade: alguns que estão aqui não morrerão antes de verem o Reino de Deus chegar com poder.” ");
INSERT INTO porblt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis dias mais tarde, Jesus levou Pedro, Tiago e João com ele para o alto de um monte, para que ficassem a sós. Sua aparência mudou completamente. ");
INSERT INTO porblt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Suas roupas ficaram muito brancas e brilhantes, mais brancas do que qualquer um na terra conseguiria branquear. ");
INSERT INTO porblt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Então, Elias e Moisés apareceram diante deles e conversaram com Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Então Pedro disse: “Rabi, que maravilha é estarmos aqui! Nós devemos fazer três tendas: uma para você, outra para Moisés e ainda outra para Elias.” ");
INSERT INTO porblt_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Ele realmente não sabia o que dizer, porque eles todos estavam com muito medo!) ");
INSERT INTO porblt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Então, uma nuvem os cobriu, e uma voz vinda da nuvem disse: “Este é o meu Filho, a quem eu amo. Escutem o que ele diz.” ");
INSERT INTO porblt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Então, de repente, quando os discípulos olharam, não havia ninguém. Apenas Jesus estava com eles. ");
INSERT INTO porblt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Quando eles desceram do monte, Jesus os instruiu a não contar a ninguém o que tinham visto, até que o Filho do Homem tivesse ressuscitado. ");
INSERT INTO porblt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Eles mantiveram segredo sobre isso, mas conversaram entre si sobre o que significava essa ressurreição. ");
INSERT INTO porblt_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Eles perguntaram a Jesus: “Por que os educadores religiosos afirmam que Elias vem primeiro?” ");
INSERT INTO porblt_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesus respondeu: “É verdade que Elias vem primeiro, para preparar tudo. Mas, por que, então, está escrito nas Sagradas Escrituras que o Filho do Homem precisa sofrer muito e ser tratado com desprezo? ");
INSERT INTO porblt_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","No entanto, eu lhes digo que Elias já veio, e eles o maltrataram de todas as formas que queriam, exatamente como constava nas Sagradas Escrituras.” ");
INSERT INTO porblt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Quando eles voltaram para onde estavam os outros discípulos, viram que eles estavam cercados por uma grande multidão e por alguns educadores religiosos, que discutiam com eles. ");
INSERT INTO porblt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Assim que a multidão viu Jesus, ficou admirada e correu para cumprimentá-lo. ");
INSERT INTO porblt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","“Sobre o que vocês estão discutindo com eles?”, Jesus lhes perguntou. ");
INSERT INTO porblt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Uma das pessoas na multidão respondeu: “Rabi, eu trouxe o meu filho para você. Ele está possuído por um espírito mau, que o impede de falar. ");
INSERT INTO porblt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sempre que o espírito ataca o meu filho, joga-o no chão, e ele espuma pela boca, range os dentes e fica com o corpo rígido. Eu pedi aos seus discípulos para expulsá-lo do meu filho, mas eles não conseguiram.” ");
INSERT INTO porblt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus respondeu: “Vocês são pessoas sem fé! Por quanto tempo eu ainda devo ficar aqui entre vocês? Por quanto tempo eu terei que suportá-los? Traga-o aqui para mim!” ");
INSERT INTO porblt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Então, eles o levaram a Jesus. Quando o espírito maligno viu Jesus, ele imediatamente fez com que o garoto tivesse convulsões e o jogou no chão. Ele rolou e espumou pela boca. ");
INSERT INTO porblt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“Há quanto tempo ele tem isso?”, Jesus perguntou ao pai do menino. Ele respondeu a Jesus: “Desde que ele era pequeno. ");
INSERT INTO porblt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Muitas vezes o espírito o joga no fogo, para que ele se queime até morrer, ou o joga na água, para afogá-lo. Por favor, tenha pena de nós e nos ajude, se puder!” ");
INSERT INTO porblt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus respondeu: “Por que você diz: ‘Se você puder?’ Tudo é possível para quem tem fé!” ");
INSERT INTO porblt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","O homem gritou imediatamente: “Eu tenho fé! Ajude-me a ter ainda mais fé!” ");
INSERT INTO porblt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus, vendo que a multidão estava se aproximando, ordenou ao espírito mau: “Espírito que impede que este menino ouça e fale, eu ordeno que saia dele e nunca mais retorne!” ");
INSERT INTO porblt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","O espírito gritou e fez com que o garoto tivesse graves convulsões. Então, o espírito saiu do menino, deixando-o como se estivesse morto, a ponto de muitas pessoas dizerem: “Ele morreu!” ");
INSERT INTO porblt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mas, Jesus pegou a mão do menino e o ajudou a se levantar. E ele ficou em pé. ");
INSERT INTO porblt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mais tarde, quando Jesus entrou em casa, seus discípulos lhe perguntaram em particular: “Por que nós não conseguimos expulsar o espírito mau?” ");
INSERT INTO porblt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesus lhes disse: “Esse tipo de espírito só pode ser expulso com oração.” ");
INSERT INTO porblt_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Eles foram embora e atravessaram a Galileia. Jesus não queria que ninguém soubesse onde ele estava, ");
INSERT INTO porblt_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","pois estava ensinando aos seus discípulos. Ele lhes disse: “O Filho do Homem será entregue nas mãos de autoridades humanas. Eles o matarão; mas, três dias depois, ressuscitará.” ");
INSERT INTO porblt_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Eles não entenderam o que ele queria dizer e ficaram com muito medo de lhe perguntar sobre isso. ");
INSERT INTO porblt_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Eles chegaram em Cafarnaum e, estando Jesus em casa, ele lhes perguntou: “Sobre o que vocês conversavam no caminho?” ");
INSERT INTO porblt_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Eles não disseram nada, porque tinham discutido sobre quem era o mais importante. ");
INSERT INTO porblt_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesus sentou e chamou os doze discípulos. Ele lhes disse: “Se alguém quiser ser o primeiro, deve ser o último e deve servir a todos os outros.” ");
INSERT INTO porblt_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ele pegou uma criancinha e a colocou no meio deles. Depois, ele a abraçou e disse aos discípulos: ");
INSERT INTO porblt_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aquele que recebe uma criança como esta em meu nome também me recebe e, aquele que me recebe não recebe somente a mim, mas também aquele que me enviou.” ");
INSERT INTO porblt_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","João disse a Jesus: “Rabi, nós vimos uma pessoa expulsando demônios em seu nome. Mas nós o proibimos, porque ele não é do nosso grupo.” ");
INSERT INTO porblt_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesus lhe disse: “Não o proíbam. Ninguém que esteja fazendo milagres em meu nome pode, ao mesmo tempo, falar mal de mim. ");
INSERT INTO porblt_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Uma pessoa que não está contra nós está a nosso favor. ");
INSERT INTO porblt_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Qualquer pessoa que dê um copo de água para vocês, em meu nome, porque vocês pertencem a Cristo, com certeza, receberá a sua recompensa. Acreditem em mim. ");
INSERT INTO porblt_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mas, se alguém fizer pecar um destes pequeninos que creem em mim, seria melhor que ele se jogasse no mar com uma grande pedra de moinho amarrada em volta do pescoço. ");
INSERT INTO porblt_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Se a sua mão faz com que você peque, corte-a! É melhor você entrar na vida eterna aleijado do que ir com as duas mãos para a Geena, para o fogo que não se apaga. ");
INSERT INTO porblt_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Se o seu pé o faz pecar, corte-o! É melhor entrar na vida eterna manco do que ter os dois pés e ser jogado na Geena. ");
INSERT INTO porblt_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Se o seu olho o faz pecar, tire-o! Pois é melhor entrar no Reino de Deus apenas com um olho do que ter os dois olhos e ser jogado na Geena. ");
INSERT INTO porblt_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ali, os vermes não morrem, nem o fogo se apaga. ");
INSERT INTO porblt_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Todos serão ‘salgados’ pelo fogo. ");
INSERT INTO porblt_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","O sal é bom, mas se ele perder o sabor, como vocês podem fazê-lo ter gosto de novo? Vocês precisam ser como o sal e precisam viver em paz uns com os outros.” ");
INSERT INTO porblt_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus saiu daquele lugar e foi para a região da Judeia e da Transjordânia. Uma vez mais as pessoas se juntaram para vê-lo, e ele os ensinava como sempre fazia. ");
INSERT INTO porblt_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Alguns fariseus também estavam lá. Eles procuraram testar Jesus, perguntando-lhe: “De acordo com a nossa lei, um homem pode mandar embora a sua esposa?” ");
INSERT INTO porblt_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ele lhes respondeu: “O que Moisés lhes disse para fazer?” ");
INSERT INTO porblt_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Eles responderam: “Moisés permitiu que um homem desse para a sua esposa um certificado de divórcio e a mandasse embora.” ");
INSERT INTO porblt_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Então, Jesus lhes disse: “Moisés fez essa regra apenas por causa da dureza do coração de vocês. ");
INSERT INTO porblt_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","No entanto, no começo, desde a criação, Deus fez o homem e a mulher. ");
INSERT INTO porblt_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","É por isso que um homem deixa a casa do seu pai e da sua mãe e se une em casamento a sua esposa, ");
INSERT INTO porblt_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","e os dois se tornam um corpo apenas. Eles já não são dois, mas um. ");
INSERT INTO porblt_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Que não se separe o que Deus uniu.” ");
INSERT INTO porblt_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Quando voltaram para casa, os discípulos perguntaram a Jesus sobre esse assunto. ");
INSERT INTO porblt_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ele lhes disse: “Qualquer homem que se divorcia de sua esposa e casa novamente comete adultério contra ela. ");
INSERT INTO porblt_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","E se a esposa se divorcia do seu marido e casa novamente, ela também comete adultério.” ");
INSERT INTO porblt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Algumas pessoas trouxeram os seus filhos para que Jesus pudesse abençoá-los, mas os discípulos repreenderam essas pessoas e tentaram afastar as crianças. ");
INSERT INTO porblt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Quando Jesus viu o que estavam fazendo, ficou muito indignado e lhes disse: “Deixem as crianças virem até mim! Não as proíbam, pois o Reino de Deus pertence aos que são como essas crianças. ");
INSERT INTO porblt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Eu lhes digo que isto é verdade: quem não receber o Reino de Deus como uma criança, nunca entrará nele.” ");
INSERT INTO porblt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ele abraçou as crianças, colocou as suas mãos sobre elas e as abençoou. ");
INSERT INTO porblt_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Quando Jesus começava a sua jornada, um homem veio correndo e se ajoelhou diante dele. Ele perguntou: “Bom mestre, o que eu devo fazer para garantir a vida eterna?” ");
INSERT INTO porblt_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Por que você diz que eu sou bom?”, Jesus lhe perguntou. “Somente Deus é bom. ");
INSERT INTO porblt_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Você conhece os mandamentos: não mate, não cometa adultério, não roube, não dê falso testemunho contra ninguém, não engane, honre o seu pai e a sua mãe.” ");
INSERT INTO porblt_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","O homem respondeu: “Mestre, eu obedeço a todos esses mandamentos desde que era pequeno.” ");
INSERT INTO porblt_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus olhou para ele com amor e disse: “Só falta uma coisa para você fazer: vá e venda tudo o que você possui. Dê o dinheiro aos pobres e você terá seu tesouro no céu. Depois, venha e me siga.” ");
INSERT INTO porblt_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nesse momento, a expressão do rosto do homem mudou. Ele se sentiu muito triste, pois era muito rico. ");
INSERT INTO porblt_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus olhou em volta e disse aos seus discípulos: “É muito difícil que os ricos entrem no Reino do Céu!” ");
INSERT INTO porblt_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Os discípulos ficaram chocados com o que ele disse. Mas Jesus continuou: “Meus filhos, é difícil entrar no Reino de Deus. ");
INSERT INTO porblt_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","É mais fácil um camelo passar pelo buraco de uma agulha do que um rico entrar no Reino de Deus.” ");
INSERT INTO porblt_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Os discípulos ficaram ainda mais confusos. Eles perguntaram uns para os outros: “Então, quem na terra pode ser salvo?” ");
INSERT INTO porblt_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Olhando para eles, Jesus respondeu: “De um ponto de vista humano é impossível. Mas, não para Deus, porque para Deus tudo é possível.” ");
INSERT INTO porblt_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro disse: “Nós deixamos tudo para seguir o senhor.” ");
INSERT INTO porblt_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus disse: “Eu lhes digo que isto é verdade: quem deixar para trás sua casa, seus irmãos ou suas irmãs, sua mãe ou seu pai, seus filhos ou suas terras por mim e pelo evangelho, ");
INSERT INTO porblt_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","receberá, no devido tempo, cem vezes mais casas, irmãos e irmãs, filhos e terras, assim como perseguições. E no mundo que está por vir, receberá a vida eterna. ");
INSERT INTO porblt_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Porém, muitos que agora são os primeiros serão os últimos. E muitos que são os últimos serão os primeiros.” ");
INSERT INTO porblt_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Eles continuaram o seu caminho para Jerusalém, com Jesus andando na frente deles. Os discípulos estavam apreensivos e os outros que seguiam com eles estavam com medo. Então, Jesus chamou os seus discípulos para um lado e começou a lhes explicar o que aconteceria com ele. Ele lhes disse: ");
INSERT INTO porblt_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Nós iremos para Jerusalém, e o Filho do Homem será entregue aos chefes dos sacerdotes e aos educadores religiosos. Eles o condenarão à morte e o entregarão aos pagãos. ");
INSERT INTO porblt_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Eles irão zombar dele, cuspir nele, chicoteá-lo e, finalmente, o matarão. Mas, após três dias, ele ressuscitará.” ");
INSERT INTO porblt_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Depois, Tiago e João, os filhos de Zebedeu, se aproximaram de Jesus e disseram: “Mestre, nós queremos que você faça por nós o que vamos lhe pedir.” ");
INSERT INTO porblt_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesus perguntou: “Então, o que vocês querem me pedir?” ");
INSERT INTO porblt_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Eles lhe disseram: “Quando você for vitorioso e sentar em seu trono, garanta que iremos sentar ao seu lado, um a sua direita e o outro a sua esquerda.” ");
INSERT INTO porblt_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus replicou: “Vocês não sabem o que estão me pedindo. Vocês conseguem beber do cálice que eu bebo? Vocês podem ser batizados com o batismo de dor que eu sofrerei?” ");
INSERT INTO porblt_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Eles disseram: “Sim, nós conseguimos.” Jesus lhes falou: “Vocês beberão do cálice que eu bebo e serão batizados como eu serei batizado. ");
INSERT INTO porblt_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mas, não sou eu quem escolhe quem se sentará a minha direita ou a minha esquerda. Esses lugares estão reservados para aqueles para quem eles foram preparados.” ");
INSERT INTO porblt_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Quando os outros dez discípulos ouviram isso, ficaram irritados com Tiago e João. ");
INSERT INTO porblt_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesus os reuniu e lhes disse: “Vocês sabem que aqueles que governam as nações oprimem seu povo. Os governantes agem como tiranos. ");
INSERT INTO porblt_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mas entre vocês não pode ser assim. Quem quiser ser importante deve ser o servo dos outros, ");
INSERT INTO porblt_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","e quem quiser ser o primeiro entre vocês deve ser o escravo de todos os outros. ");
INSERT INTO porblt_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pois mesmo o Filho do Homem não veio para ser servido, mas para servir e dar a sua vida para resgatar muita gente.” ");
INSERT INTO porblt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus e os seus discípulos passaram por Jericó. E quando eles estavam saindo da cidade, acompanhados por uma grande multidão, Bartimeu, filho de Timeu, um mendigo cego, estava sentado na beira da estrada. ");
INSERT INTO porblt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Quando ele ouviu dizer que era Jesus de Nazaré quem estava passando, começou a gritar: “Jesus, Filho de Davi, por favor, tenha pena de mim!” ");
INSERT INTO porblt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Muitas pessoas disseram para ele ficar quieto, mas isso só fez com que ele gritasse ainda mais alto: “Jesus, Filho de Davi, por favor, tenha pena de mim!” ");
INSERT INTO porblt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus parou e disse: “Digam para que ele venha aqui.” Então, eles o chamaram, dizendo: “Boas notícias! Levante-se! Ele está chamando você.” ");
INSERT INTO porblt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimeu saltou, jogou a sua capa para um lado e correu até Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“O que você quer me pedir?”, Jesus lhe perguntou. Ele disse a Jesus: “Mestre, eu quero poder ver novamente!” ");
INSERT INTO porblt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Você pode ir. A sua fé em mim o curou.” Imediatamente, Bartimeu conseguiu enxergar de novo e seguiu Jesus pelo caminho. ");
INSERT INTO porblt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Quando eles se aproximaram de Jerusalém, próximo a Betfagé e Betânia, ao lado do Monte das Oliveiras, Jesus enviou dois dos seus discípulos na frente. ");
INSERT INTO porblt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ele lhes disse: “Entrem na vila ali adiante e, assim que entrarem, vocês encontrarão um jumentinho amarrado, que nunca foi montado por ninguém antes. Desamarrem-no e o tragam aqui. ");
INSERT INTO porblt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Se alguém perguntar o que vocês estão fazendo, digam-lhe: ‘O Senhor precisa dele e logo o enviará de volta.’” ");
INSERT INTO porblt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Então, eles partiram e encontraram o animal na rua, amarrado junto a um portão e o desamarraram. ");
INSERT INTO porblt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Algumas pessoas que estavam por perto perguntaram: “O que vocês estão fazendo, desamarrando o jumentinho”? ");
INSERT INTO porblt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Os discípulos responderam exatamente como Jesus lhes tinha dito e as pessoas os deixaram ir. ");
INSERT INTO porblt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Eles trouxeram o animal para Jesus, colocaram as suas capas nele e Jesus o montou. ");
INSERT INTO porblt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Muitas pessoas colocaram as suas capas na estrada, enquanto outras jogavam ramos, que tinham cortado nos campos, pelo caminho em que Jesus passava. ");
INSERT INTO porblt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","As pessoas que iam na frente e aquelas que iam atrás de Jesus, todas gritavam: “Hosana! Que Deus abençoe aquele que vem em nome do Senhor! ");
INSERT INTO porblt_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Que Deus abençoe o Reino do nosso pai Davi, que está vindo! Hosana nas alturas!” ");
INSERT INTO porblt_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus entrou em Jerusalém e foi ao Templo. Ele olhou em volta, observando tudo. E, então, como estava ficando tarde, ele voltou ao povoado de Betânia com os doze discípulos. ");
INSERT INTO porblt_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","No dia seguinte, quando saíram de Betânia, Jesus teve fome. ");
INSERT INTO porblt_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Desde uma certa distância viu uma figueira com folhas. Ele se aproximou da árvore, para ver se tinha frutos. Mas, quando chegou lá, descobriu que havia apenas folhas, pois não era a época de figos. ");
INSERT INTO porblt_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ele disse para a árvore: “Ninguém nunca mais comerá qualquer fruto seu!” E seus discípulos ouviram isso. ");
INSERT INTO porblt_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Eles chegaram em Jerusalém e Jesus entrou no Templo. Ele começou a expulsar as pessoas que estavam no Templo comprando e vendendo mercadorias. Ele virou as mesas dos que trocavam dinheiro e as cadeiras das pessoas que vendiam pombas. ");
INSERT INTO porblt_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","E parava todos que atravessavam o Templo, carregando coisas. ");
INSERT INTO porblt_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ele explicou para as pessoas que estavam lá: “As Sagradas Escrituras não dizem: ‘Minha casa será chamada de casa de oração para todas as nações’? Mas, vocês transformaram este lugar em um esconderijo de ladrões!” ");
INSERT INTO porblt_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Os chefes dos sacerdotes e os educadores religiosos ouviram o que havia acontecido e tentaram encontrar um meio de matar Jesus. Mas, eles ficaram com medo dele, pois todos estavam muito impressionados com os seus ensinamentos. ");
INSERT INTO porblt_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Quando a noite chegou, Jesus e os seus discípulos deixaram a cidade. ");
INSERT INTO porblt_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na manhã seguinte, quando eles voltaram, viram a figueira completamente murcha. ");
INSERT INTO porblt_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro se lembrou do que Jesus tinha feito e lhe disse: “Rabi, olhe! A figueira que você amaldiçoou ficou seca.” ");
INSERT INTO porblt_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus respondeu: “Confiem em Deus. ");
INSERT INTO porblt_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Acreditem quando eu digo a vocês que se disserem para esta montanha: ‘Saia daqui e se jogue no mar!’, e, se não duvidarem em seu coração e estiverem convencidos sobre o que pedem, então, acontecerá! ");
INSERT INTO porblt_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Eu lhes digo que sempre que vocês orarem e pedirem alguma coisa, creiam que já receberam, e isso será seu. ");
INSERT INTO porblt_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mas, quando estiverem orando, se tiverem algo contra alguém, perdoe essa pessoa, para que o seu Pai celestial também possa perdoar os seus pecados.” ");
INSERT INTO porblt_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Eles retornaram para Jerusalém e, enquanto Jesus caminhava pelo Templo, os chefes dos sacerdotes, os educadores religiosos e os líderes se aproximaram dele. ");
INSERT INTO porblt_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Eles lhe perguntaram: “Com que autoridade você está fazendo tudo isso?” “Quem lhe deu esse direito?” ");
INSERT INTO porblt_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus lhes disse: “Deixem que eu lhes faça uma pergunta. Vocês me respondem e eu lhes direi com que autoridade faço essas coisas. ");
INSERT INTO porblt_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Quem deu autoridade para João batizar: foi Deus ou foram as pessoas?” ");
INSERT INTO porblt_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Eles discutiram entre si sobre isso. E disseram: “Se dissermos que foi Deus, ele dirá: ‘Então, por que vocês não creram nele?’ ");
INSERT INTO porblt_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mas, se dissermos que foram as pessoas, ai de nós.” Pois todos acreditavam que João Batista fosse realmente um profeta. ");
INSERT INTO porblt_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Eles responderam o seguinte a Jesus: “Nós não sabemos!” Jesus lhes respondeu: “Então, eu não direi a vocês com que autoridade faço essas coisas.” ");
INSERT INTO porblt_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Depois Jesus começou a falar com eles, usando histórias. “Certo homem fez uma plantação de uvas. Ele colocou uma cerca em volta da plantação, construiu um tanque, para pisar as uvas, e fez uma torre para o vigia. Então, arrendou a plantação para alguns lavradores e foi viajar. ");
INSERT INTO porblt_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Quando chegou o tempo da colheita, o dono enviou seu empregado para cobrar dos lavradores a sua parte em uvas na plantação. ");
INSERT INTO porblt_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mas, os lavradores agarraram o empregado do dono, bateram nele e o mandaram de volta sem levar nada. ");
INSERT INTO porblt_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Então, o dono enviou outro empregado. Eles bateram na cabeça dele e o maltrataram. ");
INSERT INTO porblt_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ele enviou outro empregado, e este foi morto por eles. O dono enviou muitos outros empregados. Alguns apanharam dos lavradores e outros foram mortos por eles. ");
INSERT INTO porblt_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","No fim, o único que tinha sobrado era o filho do dono das terras, a quem ele amava muito. Finalmente, ele enviou o seu filho, pensando: ‘Eles irão respeitar o meu filho.’ ");
INSERT INTO porblt_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mas, os lavradores disseram uns para os outros: ‘Aqui está o herdeiro do dono das terras. Se nós o matarmos, poderemos ficar com o que ele herdaria!’ ");
INSERT INTO porblt_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Então, eles o agarraram e o mataram, jogando o seu corpo para fora da plantação. ");
INSERT INTO porblt_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Agora, o que o dono da plantação de uvas irá fazer? Ele irá até a plantação e matará os lavradores e, então, arrendará a plantação a outros. ");
INSERT INTO porblt_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Vocês não leram o que as Sagradas Escrituras dizem: ‘A pedra rejeitada pelos construtores se tornou a base da construção. ");
INSERT INTO porblt_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Isso vem do Senhor e é uma coisa maravilhosa de se ver!’?” ");
INSERT INTO porblt_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Os líderes dos judeus tentaram prendê-lo, pois perceberam que a história se referia a eles. Mas, eles estavam com medo da multidão. Então, eles o deixaram em paz e foram embora. ");
INSERT INTO porblt_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Depois, enviaram até Jesus alguns fariseus, juntamente com apoiadores de Herodes, numa tentativa de pegá-lo por algo que ele dissesse. ");
INSERT INTO porblt_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Eles chegaram e disseram: “Mestre, nós sabemos que você é uma pessoa honesta e que não espera a aprovação dos outros, pois não se importa com aparências. Pelo contrário, você ensina o caminho de Deus de acordo com a verdade. Então, é correto pagar impostos ao imperador, ou não? ");
INSERT INTO porblt_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nós deveríamos pagar, ou deveríamos nos recusar a pagar?” Jesus, percebendo a hipocrisia nas palavras deles, lhes perguntou: “Por que vocês estão tentando me pegar em uma armadilha? Tragam-me uma moeda para que eu a olhe.” ");
INSERT INTO porblt_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Eles deram uma moeda para Jesus. “De quem são esta imagem e este nome gravados na moeda?”, Jesus lhes perguntou. Eles responderam: “Do imperador.” ");
INSERT INTO porblt_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesus lhes disse: “Então, devolvam a César o que lhe pertence e devolvam a Deus o que lhe pertence.” Eles ficaram impressionados com a sua resposta. ");
INSERT INTO porblt_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Depois, os saduceus, que não acreditam na ressurreição, vieram até ele e lhe perguntaram: ");
INSERT INTO porblt_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mestre, Moisés nos orientou que, se um homem morrer, deixando a sua esposa sem filhos, então, o irmão dele deve se casar com a viúva e ter filhos com ela, que serão considerados filhos do irmão que morreu. ");
INSERT INTO porblt_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Acontece que havia sete irmãos. O primeiro se casou e, depois, morreu sem deixar filhos. ");
INSERT INTO porblt_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","O segundo se casou com a viúva e morreu sem deixar filhos. Aconteceu exatamente a mesma coisa com o terceiro dos irmãos. ");
INSERT INTO porblt_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na verdade, todos os sete morreram sem deixar filhos. No fim, a mulher também morreu. ");
INSERT INTO porblt_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Portanto, ao ressuscitar, a mulher que se casou com todos os sete irmãos, será esposa de qual deles?” ");
INSERT INTO porblt_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus lhes disse: “Isso prova que vocês estão errados e que não conhecem as Sagradas Escrituras, nem o poder de Deus. ");
INSERT INTO porblt_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Quando os mortos ressuscitarem, eles não irão se casar e também não serão dados em casamento. Eles serão como os anjos no céu. ");
INSERT INTO porblt_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mas em relação à ressurreição, vocês nunca leram a respeito disso no Livro de Moisés? Quando fala do arbusto que pegava fogo, em que Deus falou para Moisés: ‘Eu sou o Deus de Abraão, o Deus de Isaque e o Deus de Jacó?’ ");
INSERT INTO porblt_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ele não é Deus dos mortos, mas, sim, Deus dos vivos. Vocês estão completamente errados!” ");
INSERT INTO porblt_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Um dos educadores religiosos chegou e os ouviu discutindo. Ele reconheceu que Jesus tinha lhes dado uma boa resposta. Então, ele perguntou a Jesus: “Qual é o mandamento mais importante?” ");
INSERT INTO porblt_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus respondeu: “O mandamento mais importante é: ‘Ouça, povo de Israel! O Senhor, nosso Deus, é o único Senhor. ");
INSERT INTO porblt_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ame o Senhor, seu Deus, com todo o seu coração, com toda a sua alma, com toda a sua mente e com todas as suas forças.’ ");
INSERT INTO porblt_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","O segundo é: ‘Ame aos outros como ama a si mesmo.’ Não há mandamentos mais importantes do que esses.” ");
INSERT INTO porblt_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","O homem respondeu: “Está certo, Mestre. É verdade o que você disse sobre Deus ser único e que não há outro. ");
INSERT INTO porblt_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nós devemos amá-lo com todo o nosso coração, com toda a nossa compreensão e com todas as nossas forças e devemos amar aos outros como amamos a nós mesmos. Isso é muito mais importante do que ofertas e sacrifícios.” ");
INSERT INTO porblt_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesus viu que ele tinha lhe dado uma resposta bem pensada e disse: “Você não está longe do Reino de Deus.” Após isso, ninguém mais teve coragem para perguntar qualquer outra coisa a Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Enquanto Jesus ensinava no Templo, ele perguntou: “Por que os educadores religiosos afirmam que o Messias é filho de Davi? ");
INSERT INTO porblt_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","O próprio Davi declarou, inspirado pelo Espírito Santo, que ‘o Senhor disse ao meu Senhor: Sente-se a minha direita até que eu coloque seus inimigos aos seus pés.’ ");
INSERT INTO porblt_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Se o próprio Davi chama o Messias de Senhor, como ele pode ser filho de Davi?” A grande multidão que estava ali ouviu com grande alegria o que Jesus dizia. ");
INSERT INTO porblt_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus continuou a ensinar às pessoas, dizendo: “Tenham cuidado com os líderes religiosos! Eles adoram caminhar por aí, usando mantos compridos e gostam de ser cumprimentados de forma respeitosa nas praças dos mercados. ");
INSERT INTO porblt_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Eles gostam de ter as cadeiras mais importantes nas sinagogas, e os melhores lugares nos banquetes. ");
INSERT INTO porblt_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Eles enganam as viúvas, tirando o que elas têm e escondem quem eles realmente são, fazendo orações sem fim. Eles serão severamente castigados quando forem julgados.” ");
INSERT INTO porblt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus sentou-se no lado oposto à caixa de ofertas, observando as pessoas colocarem moedas ali. Muitas pessoas ricas colocavam uma quantia muito grande de dinheiro na caixa. ");
INSERT INTO porblt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Então, uma pobre viúva apareceu e colocou apenas duas moedas de pouco valor. ");
INSERT INTO porblt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ele chamou os seus discípulos e lhes disse: “Eu lhes digo que isto é verdade: essa pobre viúva colocou mais do que todos os outros. ");
INSERT INTO porblt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Todos os outros doaram das fortunas que tinham, mas ela, que já é tão pobre, deu tudo o que tinha para viver.” ");
INSERT INTO porblt_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Quando Jesus estava saindo do Templo, um dos seus discípulos lhe disse: “Mestre, veja estas pedras gigantescas e estes edifícios magníficos!” ");
INSERT INTO porblt_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","“Você está vendo todos estes grandes edifícios?”, Jesus respondeu. “Não sobrará uma única pedra sobre a outra. Tudo será destruído.” ");
INSERT INTO porblt_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesus estava sentado no monte das Oliveiras, olhando para o Templo, quando Pedro, Tiago, João e André lhe perguntaram em particular: ");
INSERT INTO porblt_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Mestre, conte para nós quando isso irá acontecer. Qual é o sinal que irá mostrar que tudo isso está próximo de se cumprir?” ");
INSERT INTO porblt_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus começou a lhes dizer: “Cuidado para que ninguém engane vocês. ");
INSERT INTO porblt_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Muitas pessoas virão em meu nome, afirmando: ‘Eu sou o Messias!’ Elas enganarão muita gente. ");
INSERT INTO porblt_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Não fiquem preocupados quando ouvirem sobre guerras em lugares próximos ou distantes. Essas coisas devem acontecer, mas ainda não é o fim. ");
INSERT INTO porblt_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Uma nação vai guerrear contra outra, e um reino lutará contra outro. Haverá tremores de terra em vários lugares, e a fome também se espalhará. Esses são os efeitos do início das dores do parto do mundo. ");
INSERT INTO porblt_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Cuidem-se! Eles entregarão vocês para serem julgados nos tribunais. Vocês apanharão nas sinagogas. Por me seguirem, vocês precisarão ficar diante de governadores, de reis e precisarão testemunhar para eles. ");
INSERT INTO porblt_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Primeiro, o evangelho deve ser anunciado a todas as pessoas. ");
INSERT INTO porblt_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Quando eles vierem prender vocês e levá-los aos tribunais, não se preocupem com o que devem falar. Apenas digam o que lhes for dado para dizer naquele momento, pois não serão vocês falando, mas, sim, o Espírito Santo. ");
INSERT INTO porblt_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Um irmão entregará outro irmão para ser morto e um pai entregará seu filho. Filhos se voltarão contra os seus pais e os matarão. ");
INSERT INTO porblt_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Vocês serão odiados por todos, por minha causa, mas, quem se mantiver firme até o fim será salvo. ");
INSERT INTO porblt_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Mas, quando vocês virem a ‘abominação’, situada onde não deveria estar (que o leitor entenda o que isso quer dizer), então, aqueles que estiverem na Judeia deverão correr para as montanhas. ");
INSERT INTO porblt_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","As pessoas que estiverem nos terraços de suas casas não entrem nas casas para pegar absolutamente nada. ");
INSERT INTO porblt_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aqueles que estiverem nos campos não voltem para casa para pegar os seus casacos. ");
INSERT INTO porblt_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Como sofrerão as mulheres grávidas e as que estiverem amamentando nessa época! ");
INSERT INTO porblt_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Peçam a Deus para que isso não aconteça durante o inverno. ");
INSERT INTO porblt_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Pois, esses serão dias turbulentos como nunca se viu desde que Deus criou o mundo. E nunca mais se verá uma coisa assim. ");
INSERT INTO porblt_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Se Deus não encurtar esses dias, ninguém sobreviverá. No entanto, pelo bem dos que Deus escolheu salvar, ele abreviou esses dias. ");
INSERT INTO porblt_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Então, se alguém lhes disser: ‘Veja! Aqui está o Messias.’ Ou: ‘Olhe!, aqui está ele’, não acreditem. ");
INSERT INTO porblt_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Falsos messias e falsos profetas aparecerão e farão sinais milagrosos e coisas maravilhosas para enganar, se possível, até os escolhidos por Deus. ");
INSERT INTO porblt_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Cuidado! Estou lhes dizendo todas essas coisas antes que elas aconteçam. ");
INSERT INTO porblt_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Isso é o que acontecerá após esses dias de tribulação: ‘O sol ficará escuro e a lua não brilhará. ");
INSERT INTO porblt_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","As estrelas cairão do céu e os poderes do espaço serão abalados.’ ");
INSERT INTO porblt_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Então, eles verão o Filho do Homem vindo nas nuvens, com grande poder e glória. ");
INSERT INTO porblt_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ele enviará os anjos e reunirá todos os seus escolhidos, seja onde estiverem, de um lado do mundo até o outro. ");
INSERT INTO porblt_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Aprendam com a lição da figueira. Quando os seus galhos ficam verdes e as folhas começam a surgir, vocês sabem que o verão está próximo. ");
INSERT INTO porblt_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Da mesma maneira, quando virem essas coisas acontecendo, vocês saberão que o tempo está próximo, pronto para começar! ");
INSERT INTO porblt_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Eu lhes digo que isto é verdade: as pessoas desta geração não morrerão até que todas essas coisas tenham acontecido. ");
INSERT INTO porblt_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Céu e terra chegarão ao fim, mas os meus ensinamentos permanecerão. ");
INSERT INTO porblt_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ninguém sabe quando chegará o dia ou a hora disso acontecer, nem os anjos no céu e nem mesmo o Filho; apenas o Pai sabe. ");
INSERT INTO porblt_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Vigiem! Fiquem atentos! Pois vocês não sabem quando isso irá acontecer. ");
INSERT INTO porblt_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","É como um homem que saiu em uma viagem. Ele saiu de sua casa e deu a cada um dos seus empregados a autorização para fazer o que ele lhes tinha ordenado. Ele disse ao porteiro para ficar atento. ");
INSERT INTO porblt_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Então, vigiem, pois vocês não sabem quando o proprietário da casa estará de volta: se será no final da tarde, no meio da noite, antes do amanhecer ou de manhã. ");
INSERT INTO porblt_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Vocês não irão querer ser pegos dormindo, caso ele retorne inesperadamente. ");
INSERT INTO porblt_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","O que eu estou dizendo a vocês, eu digo a todos: ‘Vigiem!’” ");
INSERT INTO porblt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Faltavam dois dias para a Páscoa e para a Festa dos Pães sem Fermento. Os chefes dos sacerdotes e os líderes religiosos estavam tentando encontrar um meio traiçoeiro para prender Jesus e o matar. ");
INSERT INTO porblt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Eles falavam uns para os outros: “Mas não durante a comemoração da Páscoa. Caso contrário, as pessoas podem se revoltar.” ");
INSERT INTO porblt_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Enquanto isso, Jesus estava no povoado de Betânia, comendo na casa de Simão, o leproso. Uma mulher veio com um frasco feito de alabastro com um perfume muito caro, feito de bálsamo puro. Ela abriu o frasco e derramou o perfume sobre a cabeça de Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Algumas das pessoas que estavam lá na casa ficaram irritadas e disseram: “Por que desperdiçar esse perfume? ");
INSERT INTO porblt_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Isso poderia ser vendido por mais de trezentas moedas de prata, e o dinheiro poderia ser dado aos pobres.” Eles ficaram muito bravos com ela. ");
INSERT INTO porblt_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mas Jesus respondeu: “Deixem essa mulher em paz! Por que vocês estão criticando-a por ela fazer algo bom para mim? ");
INSERT INTO porblt_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Vocês sempre terão os pobres com vocês e poderão ajudá-los sempre que quiserem. No entanto, eu não estarei sempre com vocês. ");
INSERT INTO porblt_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ela fez o que poderia fazer: ela perfumou o meu corpo antes do meu sepultamento. ");
INSERT INTO porblt_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Eu lhes digo que isto é verdade: sempre que o evangelho for anunciado pelo mundo, as pessoas se lembrarão do que ela fez por mim.” ");
INSERT INTO porblt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Depois, Judas Iscariotes, um dos doze discípulos, foi falar com os chefes dos sacerdotes e combinou entregar Jesus a eles. ");
INSERT INTO porblt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Quando os sacerdotes ouviram isso, ficaram muito satisfeitos e prometeram pagar uma quantia em dinheiro a Judas. Então, Judas começou a procurar uma oportunidade para entregar Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","No primeiro dia da Festa dos Pães sem Fermento, o período em que se sacrifica um cordeiro para a Páscoa, os discípulos de Jesus lhe perguntaram: “Onde é que o senhor quer que preparemos a sua refeição da Páscoa?” ");
INSERT INTO porblt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ele enviou dois discípulos, dizendo: “Vão para a cidade e lá vocês encontrarão um homem carregando um pote de água. Sigam-no, ");
INSERT INTO porblt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","e, quando ele entrar em uma casa, perguntem ao dono da casa onde os meus discípulos e eu podemos celebrar a Páscoa. ");
INSERT INTO porblt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ele os levará a uma grande sala no andar de cima, que está mobiliada e pronta para o jantar. Lá, vocês podem preparar tudo para nós.” ");
INSERT INTO porblt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Os discípulos foram para a cidade e encontraram as coisas exatamente como Jesus tinha lhes dito. Eles prepararam a refeição da Páscoa. ");
INSERT INTO porblt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","À noite, Jesus foi para lá junto com os doze discípulos. ");
INSERT INTO porblt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Enquanto eles estavam sentados, comendo, Jesus disse: “Eu lhes digo que isto é verdade: um de vocês irá me trair; alguém que está comendo comigo agora.” ");
INSERT INTO porblt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Eles ficaram chocados e, um por um, perguntaram: “Não sou eu, sou?” ");
INSERT INTO porblt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","“É um dos doze, um de vocês que compartilha esta refeição comigo”, ele respondeu. ");
INSERT INTO porblt_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“O Filho do Homem morrerá, exatamente como as Sagradas Escrituras anunciaram. Mas, ai do homem que trair o Filho do Homem! Seria melhor para esse homem nunca haver nascido.” ");
INSERT INTO porblt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Enquanto eles estavam comendo, Jesus pegou um pão. Ele o abençoou e distribuiu aos discípulos. Ele lhes disse: “Peguem! Isto é o meu corpo.” ");
INSERT INTO porblt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Então, ele pegou o cálice. Ele o abençoou e distribuiu aos discípulos. Todos eles beberam o vinho. ");
INSERT INTO porblt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ele lhes disse: “Isto é o meu sangue, o sangue do acordo, que está sendo derramado em favor de muitos. ");
INSERT INTO porblt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Eu lhes digo que isto é verdade: eu não beberei do fruto da videira até o dia em que eu beber o vinho novo no Reino de Deus.” ");
INSERT INTO porblt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Depois de terem cantado um salmo, eles foram para o monte das Oliveiras. ");
INSERT INTO porblt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesus lhes disse: “Todos vocês irão me abandonar. Pois, como as Sagradas Escrituras dizem: ‘Eu atacarei o pastor, e as ovelhas se espalharão completamente.’ ");
INSERT INTO porblt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mas, depois da minha ressurreição, eu irei adiante de vocês para a Galileia.” ");
INSERT INTO porblt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro disse: “Eu não o abandonarei, mesmo se todos os outros o abandonarem!” ");
INSERT INTO porblt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus lhe respondeu: “Eu lhe digo que isto é verdade: Hoje, nesta mesma noite, antes do galo cantar duas vezes, você negará três vezes que me conhece.” ");
INSERT INTO porblt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mas Pedro afirmava com insistência: “Mesmo que eu tenha que morrer com o senhor, eu nunca o negarei!” Todos os outros discípulos disseram o mesmo. ");
INSERT INTO porblt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Eles chegaram a um jardim, chamado Getsêmani, onde Jesus disse aos discípulos: “Sentem-se aqui, enquanto eu vou orar.” ");
INSERT INTO porblt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ele levou Pedro, Tiago e João com ele. Ele começou a sentir-se tomado de grande tristeza e aflição. ");
INSERT INTO porblt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jesus lhes disse: “Meu sofrimento é tão grande que parece que vai me matar. Por favor, fiquem aqui e vigiem!” ");
INSERT INTO porblt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ele foi um pouco mais longe e, depois, se ajoelhou. Ele orou, pedindo para, se possível, ser poupado daquele momento de sofrimento. ");
INSERT INTO porblt_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ele disse: “Pai, meu Pai! Você pode fazer tudo. Por favor, afaste este cálice de sofrimento de mim! Mas que seja feito o que o senhor quiser, e não o que eu quero.” ");
INSERT INTO porblt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Então, Jesus voltou e encontrou os discípulos dormindo. Ele disse a Pedro: “Simão, você está dormindo? Não consegue ficar acordado nem por uma hora? ");
INSERT INTO porblt_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Vigiem e orem! Assim vocês não cairão em tentação. Vocês podem até querer resistir à tentação; difícil mesmo é conseguir isso.” ");
INSERT INTO porblt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesus se afastou dos discípulos mais uma vez. Ele orou, dizendo as mesmas palavras. ");
INSERT INTO porblt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Depois ele voltou e, novamente, encontrou-os dormindo. Eles não conseguiam manter seus olhos abertos. Eles não sabiam o que dizer para Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pela terceira vez, Jesus voltou e lhes perguntou: “Vocês ainda estão dormindo? Vocês ainda estão descansando? Já é o bastante! Chegou a hora! Vejam, o Filho do Homem está sendo entregue aos pecadores. ");
INSERT INTO porblt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Levantem-se! Vamos! Vejam! Aqui está o meu traidor.” ");
INSERT INTO porblt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Exatamente quando ele disse isso, Judas, um dos doze discípulos, chegou com uma multidão que carregava espadas e porretes. Eles tinham sido enviados pelos chefes dos sacerdotes, líderes religiosos e pelos anciãos do povo. ");
INSERT INTO porblt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","O traidor havia combinado um sinal com eles: “Aquele a quem eu beijar é a pessoa que procuram. Prendam-no e levem-no bem seguro.” ");
INSERT INTO porblt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas se aproximou de Jesus. Ele disse: “Rabi”, e o beijou. ");
INSERT INTO porblt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Então, eles prenderam Jesus e o levaram. ");
INSERT INTO porblt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mas, um dos que estavam lá tirou a sua espada e atacou o empregado do grande sacerdote, cortando a sua orelha. ");
INSERT INTO porblt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus lhes perguntou: “Eu sou algum bandido, para vocês me prenderem com espadas e porretes? ");
INSERT INTO porblt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Todos os dias, eu estava lá com vocês, ensinando no Templo. Então, por que vocês não me prenderam antes? Mas, isso está acontecendo para cumprir o que dizem as Sagradas Escrituras.” ");
INSERT INTO porblt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Então, todos os discípulos de Jesus o abandonaram e fugiram. ");
INSERT INTO porblt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Um jovem, enrolado apenas num lençol, seguia Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Eles tentaram prendê-lo, mas ele fugiu nu, deixando o lençol para trás. ");
INSERT INTO porblt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Eles levaram Jesus para a casa do grande sacerdote, onde estavam reunidos todos os chefes dos sacerdotes, os anciãos do povo e os educadores religiosos. ");
INSERT INTO porblt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro seguiu Jesus, mantendo uma certa distância, e entrou no pátio da casa do grande sacerdote. Ele se sentou perto dos guardas e se aqueceu próximo ao fogo. ");
INSERT INTO porblt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Dentro da casa, os chefes dos sacerdotes e todo o conselho superior estavam tentando encontrar alguma evidência para condenar Jesus à morte, mas eles não conseguiam encontrar acusação alguma. ");
INSERT INTO porblt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Muitas pessoas testemunhavam falsamente contra ele, mas o que diziam não era coerente. ");
INSERT INTO porblt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Alguns deles levantavam-se para falar mentiras contra Jesus. Eles diziam: ");
INSERT INTO porblt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nós o ouvimos dizer: ‘Eu destruirei este Templo, que mãos humanas construíram, e, em três dias, eu construirei outro sem precisar usar mãos para isso.’” ");
INSERT INTO porblt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mas, mesmo assim, os seus depoimentos não eram coerentes. ");
INSERT INTO porblt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Então, o grande sacerdote ficou em frente ao conselho e perguntou a Jesus: “Você não tem nada a dizer em relação a essas acusações?” ");
INSERT INTO porblt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mas, Jesus permaneceu em silêncio e não respondeu. Então, o grande sacerdote perguntou novamente: “Você é o Messias, o Filho do Deus Bendito?” ");
INSERT INTO porblt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus respondeu: “Eu sou, e vocês verão o Filho do Homem se sentar à direita do Deus Todo-Poderoso e vir com as nuvens do céu.” ");
INSERT INTO porblt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","O grande sacerdote rasgou suas próprias roupas e perguntou: “Por que nós precisamos de qualquer outra testemunha? ");
INSERT INTO porblt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Vocês ouviram a blasfêmia! Qual a decisão de vocês?” Eles todos consideraram Jesus culpado e o condenaram à morte. ");
INSERT INTO porblt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Então, alguns deles começaram a cuspir nele. Eles colocaram uma venda nos olhos de Jesus, deram murros nele e disseram: “‘Profeta’, por que não adivinha quem lhe bateu?” Os guardas levaram Jesus com eles e também bateram nele. ");
INSERT INTO porblt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Enquanto isso, Pedro estava lá embaixo no pátio. Uma das empregadas do grande sacerdote passou por ele ");
INSERT INTO porblt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","e, ao vê-lo se esquentando junto ao fogo, olhou bem para Pedro e disse: “Você também estava com Jesus de Nazaré!” ");
INSERT INTO porblt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mas, ele negou. Pedro respondeu: “Eu não sei do que você está falando, ou o que quer dizer!” Então, ele saiu para a varanda, e o galo cantou. ");
INSERT INTO porblt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ao ver Pedro lá, a empregada repetiu novamente aos que estavam por perto: “Este homem é um deles!” ");
INSERT INTO porblt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mais uma vez, Pedro negou. Pouco tempo depois, eles viram Pedro novamente: “Definitivamente, você é um deles, porque você também é um galileu!” ");
INSERT INTO porblt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro começou a se amaldiçoar e jurou: “Eu não conheço esse homem de quem vocês estão falando!” ");
INSERT INTO porblt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Imediatamente, o galo cantou pela segunda vez. Então, Pedro se lembrou do que Jesus havia dito a ele: “Antes do galo cantar duas vezes, você me negará três vezes.” Quando ele percebeu o que tinha feito, começou a chorar. ");
INSERT INTO porblt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na manhã do dia seguinte, os chefes dos sacerdotes, os anciãos do povo e os educadores religiosos, ou seja, todo o conselho superior, chegou a uma decisão. Eles amarraram Jesus e o levaram para ser entregue a Pilatos. ");
INSERT INTO porblt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatos perguntou a Jesus: “Você é o Rei dos Judeus?” Jesus lhe disse: “Você é quem está dizendo isso!” ");
INSERT INTO porblt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Os chefes dos sacerdotes continuaram a fazer várias acusações contra Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatos lhe perguntou novamente: “Você não irá responder? Veja quantas acusações eles fazem contra você!” ");
INSERT INTO porblt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesus não respondeu mais nada, o que deixou Pilatos muito surpreso. ");
INSERT INTO porblt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Naquela época, era costume, na festa da Páscoa, o governador libertar um prisioneiro escolhido pelo povo, qualquer um que eles escolhessem. ");
INSERT INTO porblt_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Um dos prisioneiros era um homem chamado Barrabás, que pertencia a um grupo de rebeldes que tinha cometido assassinatos durante uma revolta. ");
INSERT INTO porblt_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","A multidão disse a Pilatos para libertar um prisioneiro, seguindo o costume. ");
INSERT INTO porblt_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatos perguntou para a multidão: “Vocês querem que eu liberte o Rei dos Judeus?” ");
INSERT INTO porblt_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ele sabia que os chefes dos sacerdotes tinham lhe entregado Jesus por inveja. ");
INSERT INTO porblt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mas, os chefes dos sacerdotes incentivavam a multidão para que eles pedissem a libertação de Barrabás. ");
INSERT INTO porblt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatos lhes perguntou: “Então, o que eu devo fazer com aquele que vocês chamam de o Rei dos Judeus?” ");
INSERT INTO porblt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Eles gritaram: “Crucifique-o!” ");
INSERT INTO porblt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Por quê? Qual crime ele cometeu?” Pilatos perguntou. Eles gritaram ainda mais alto: “Crucifique-o!” ");
INSERT INTO porblt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Querendo agradar a multidão, Pilatos libertou Barrabás, como eles tinham pedido. Primeiro, ele mandou chicotear Jesus e, depois, o entregou para ser crucificado. ");
INSERT INTO porblt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Os soldados o levaram para o pátio do Pretório, onde chamaram toda a tropa. ");
INSERT INTO porblt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Eles colocaram um manto púrpura sobre ele e fizeram uma coroa de espinhos, que colocaram em sua cabeça. ");
INSERT INTO porblt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Então, eles diziam a Jesus: “Viva o Rei dos Judeus!” ");
INSERT INTO porblt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Os soldados batiam em sua cabeça com uma vara, cuspiam nele e se ajoelhavam diante dele, como se o estivessem adorando. ");
INSERT INTO porblt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Depois que pararam de zombar de Jesus, eles tiraram o manto púrpura e o vestiram novamente com as suas próprias roupas. Depois, eles o levaram para ser crucificado. ");
INSERT INTO porblt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Eles obrigaram um homem, que lá passava, chamado Simão, de Cirene, que estava voltando do campo, a carregar a cruz de Jesus. Simão era o pai de Alexandre e de Rufo. ");
INSERT INTO porblt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Os soldados levaram Jesus para um lugar chamado Gólgota, que significa “o Lugar da Caveira.” ");
INSERT INTO porblt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Eles ofereceram a Jesus vinho misturado com um calmante chamado mirra, mas ele recusou. ");
INSERT INTO porblt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Então, eles o crucificaram. Eles dividiram as roupas de Jesus entre si, jogando os dados, para decidir qual peça de roupa ficaria para qual deles. ");
INSERT INTO porblt_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Eram nove horas da manhã quando eles o crucificaram. ");
INSERT INTO porblt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Colocaram uma placa com a acusação contra ele, em que se podia ler: “O Rei dos Judeus.” ");
INSERT INTO porblt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Eles crucificaram dois ladrões com ele. Um ficou a sua esquerda e o outro, a sua direita. ");
INSERT INTO porblt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","As pessoas que passavam ofendiam Jesus, balançando a cabeça e dizendo: “Ei! Você afirmava que iria destruir o Templo e o reconstruiria em três dias. ");
INSERT INTO porblt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Então, salve-se! Desça da cruz!” ");
INSERT INTO porblt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Os chefes dos sacerdotes e os educadores religiosos também caçoaram dele, dizendo uns para os outros: “Ele salvou os outros, mas não consegue salvar a si mesmo! ");
INSERT INTO porblt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Se é realmente o Messias, o Rei de Israel, então, desça da cruz, para que possamos ver e crer nele!” Até mesmo os dois ladrões que foram crucificados com ele o insultavam. ");
INSERT INTO porblt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ao meio-dia, a escuridão cobriu toda a terra e durou três horas. ");
INSERT INTO porblt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Às três horas da tarde, Jesus gritou: “Eloi, Eloi, lama sabachthani”, que significa, “Meu Deus, meu Deus, por que você me abandonou?” ");
INSERT INTO porblt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Algumas pessoas que estavam lá ouviram isso e disseram: “Ele está chamando Elias.” ");
INSERT INTO porblt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Um homem correu e molhou uma esponja em vinagre. Ele colocou a esponja na ponta de um bastão e tentou dar isso para que Jesus bebesse. Ele disse: “Deixe-o sozinho! Vamos ver se Elias virá para tirá-lo daí.” ");
INSERT INTO porblt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Então, Jesus deu um grito forte e morreu. ");
INSERT INTO porblt_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","A cortina do Templo se rasgou em duas partes, de cima para baixo. ");
INSERT INTO porblt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Quando o comandante romano, que estava lá na frente de Jesus, viu como ele morreu, disse: “Este homem era realmente o Filho de Deus!” ");
INSERT INTO porblt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Algumas mulheres estavam olhando a uma certa distância. Entre elas, estavam Maria Madalena, Maria, mãe de José e de Tiago, o mais jovem, e Salomé. ");
INSERT INTO porblt_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Elas tinham seguido Jesus e cuidado dele, enquanto ele estava na Galileia. Muitas outras mulheres, que tinham vindo com Jesus para Jerusalém, também estavam lá. ");
INSERT INTO porblt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Era sexta-feira, o dia antes do sábado. Quando a noite se aproximava, ");
INSERT INTO porblt_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","José de Arimateia, um membro do conselho superior, que também estava esperando pelo Reino de Deus, teve coragem de falar com Pilatos e lhe pedir o corpo de Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatos ficou surpreso por Jesus ter morrido tão rápido. Então, ele chamou o comandante romano e lhe perguntou se Jesus já havia morrido. ");
INSERT INTO porblt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Assim que ele teve a confirmação do oficial, deu permissão para José levar o corpo. ");
INSERT INTO porblt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José comprou um lençol de linho. Então, ele tirou o corpo de Jesus da cruz e o enrolou no lençol. Ele colocou o corpo em um túmulo que tinha sido cavado na rocha. Depois, rolou uma grande pedra, fechando a entrada do túmulo. ");
INSERT INTO porblt_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Madalena e Maria, mãe de José, viram onde o corpo de Jesus fora colocado. ");
INSERT INTO porblt_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Assim que o dia de sábado tinha acabado, Maria Madalena, Maria, a mãe de Tiago, e Salomé compraram perfumes para colocarem sobre o corpo de Jesus. ");
INSERT INTO porblt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","No domingo, bem cedo, assim que o sol nascia, elas foram ao túmulo. ");
INSERT INTO porblt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Elas perguntavam umas para as outras: “Quem irá rolar a pedra, para que consigamos entrar no túmulo?” ");
INSERT INTO porblt_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mas, quando elas chegaram e olharam, perceberam que a pedra muito grande e pesada já tinha sido tirada da entrada. ");
INSERT INTO porblt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Quando elas entraram no túmulo, viram um jovem sentado à direita, usando um longo manto branco. Elas ficaram muito assustadas. ");
INSERT INTO porblt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ele lhes disse: “Não tenham medo! Vocês estão procurando Jesus, o Nazareno, aquele que foi crucificado. Ele ressuscitou. Ele não está aqui. ");
INSERT INTO porblt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vejam! Este é o lugar em que eles o colocaram. Agora vão e digam a Pedro e aos outros discípulos que ele está indo antes deles para a Galileia. Vocês o encontrarão lá, exatamente como ele lhes disse.” ");
INSERT INTO porblt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Elas saíram e correram, tremendo e muito confusas. Elas não disseram nada a ninguém, porque estavam com muito medo. ");
INSERT INTO porblt_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Quando Jesus ressuscitou na manhã de domingo, ele apareceu primeiro a Maria Madalena, de quem expulsara sete demônios. ");
INSERT INTO porblt_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ela foi e contou aos companheiros de Jesus, pois eles estavam tristes e chorando. ");
INSERT INTO porblt_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Quando eles ouviram que Jesus estava vivo e que ela o tinha visto, eles não acreditaram. ");
INSERT INTO porblt_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Depois, Jesus apareceu em uma forma diferente para dois outros discípulos, que iam caminhando para o campo. ");
INSERT INTO porblt_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Eles voltaram e contaram aos outros, mas eles não acreditaram neles também. ");
INSERT INTO porblt_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Depois disso, ele apareceu aos onze discípulos, enquanto eles estavam comendo. Ele os repreendeu por sua falta de fé e sua teimosia, pois eles não acreditaram naqueles que o tinham visto após ter ressuscitado. ");
INSERT INTO porblt_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Então, ele lhes disse: “Anunciem pelo mundo inteiro o evangelho a todas as pessoas. ");
INSERT INTO porblt_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Qualquer um que tenha fé em mim e for batizado será salvo, mas quem escolher não ter fé será condenado. ");
INSERT INTO porblt_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Os seguintes sinais acompanharão os que têm fé em mim: em meu nome, eles expulsarão demônios. Eles falarão novos idiomas. ");
INSERT INTO porblt_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","E se pegarem em cobras ou beberem algum veneno, eles não sofrerão nenhum mal. Eles colocarão suas mãos nos doentes e eles serão curados.” ");
INSERT INTO porblt_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Depois, o Senhor Jesus, após acabar de falar com eles, foi levado para o céu, onde se sentou à direita de Deus. ");
INSERT INTO porblt_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Os discípulos foram e anunciaram o evangelho por toda parte. E o Senhor trabalhava com eles, por meio dos sinais milagrosos que acompanhavam a mensagem, confirmando que ela era verdadeira. ");
INSERT INTO porblt_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Como você sabe, muitas pessoas têm se esforçado para escrever as coisas que têm acontecido relacionadas a nós. ");
INSERT INTO porblt_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Elas se basearam em evidências transmitidas por testemunhas e por ministros da Palavra, que acompanharam esses fatos desde o início. ");
INSERT INTO porblt_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Então, eu também decidi que, por ter investigado com muito cuidado o que ocorreu desde o início, seria uma boa ideia escrever um relato preciso de tudo o que aconteceu. ");
INSERT INTO porblt_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Eu fiz isso, querido Teófilo, para que você tenha certeza de que aquilo que lhe foi ensinado é totalmente verdadeiro. ");
INSERT INTO porblt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Durante o tempo em que Herodes governou a Judeia, havia um sacerdote chamado Zacarias, que era do grupo dos sacerdotes de Abias. Ele se casou com Isabel, que era descendente de Arão, o sacerdote. ");
INSERT INTO porblt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ambos viviam de maneira justa diante de Deus, sendo muito cuidadosos em seguir todos os mandamentos e todas as leis do Senhor. ");
INSERT INTO porblt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Eles não tinham filhos, porque Isabel não podia ter filhos, e os dois já eram muito idosos. ");
INSERT INTO porblt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Enquanto Zacarias estava fazendo o seu trabalho como sacerdote diante de Deus, representando seu grupo de sacerdotes, ");
INSERT INTO porblt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ele foi escolhido entre vários, de acordo com o costume da época, para entrar no Templo do Senhor e queimar o incenso. ");
INSERT INTO porblt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Durante o tempo da oferta de incenso, uma grande multidão estava orando do lado de fora do Templo. ");
INSERT INTO porblt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Um anjo do Senhor apareceu para Zacarias, ficando à direita do altar de incenso. ");
INSERT INTO porblt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Quando Zacarias viu o anjo, ele ficou espantado e com muito medo. ");
INSERT INTO porblt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mas, o anjo lhe disse: “Não tenha medo, Zacarias! A sua oração foi ouvida. Isabel, sua esposa, lhe dará um filho e vocês devem chamá-lo João. ");
INSERT INTO porblt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ele lhe trará muita alegria e felicidade e muitas pessoas festejarão o seu nascimento. ");
INSERT INTO porblt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ele será importante aos olhos do Senhor. Ele não deverá beber vinho ou qualquer outra bebida alcoólica. Ele será cheio do Espírito Santo, mesmo antes do seu nascimento. ");
INSERT INTO porblt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ele fará com que muitos israelitas se voltem para o Senhor, o seu Deus. ");
INSERT INTO porblt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ele preparará o caminho para o Senhor com o mesmo ânimo e poder de Elias, para fazer com que os pais e seus filhos façam as pazes e para que os rebeldes voltem para o caminho certo e, assim, preparem o povo para o Senhor.” ");
INSERT INTO porblt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","“Como eu posso ter certeza disso?” Zacarias perguntou ao anjo. “Eu sou velho e minha esposa também está envelhecendo.” ");
INSERT INTO porblt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","O anjo respondeu: “Eu sou Gabriel. Sirvo a Deus e fui enviado para lhe dar essa boa notícia. ");
INSERT INTO porblt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mas, já que não acreditou no que eu lhe disse, você ficará mudo, incapaz de falar, até que minhas palavras se cumpram”. ");
INSERT INTO porblt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Do lado de fora do Templo, as pessoas esperavam que Zacarias saísse, pensando no motivo dele estar demorando tanto lá dentro. ");
INSERT INTO porblt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Quando finalmente ele saiu, não conseguia falar com eles. Eles perceberam que ele tinha tido uma visão no Templo, pois embora pudesse gesticular e se expressar, estava completamente mudo. ");
INSERT INTO porblt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Após haver terminado seus dias de serviço no Templo, ele voltou para casa. ");
INSERT INTO porblt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Algum tempo depois, sua esposa, Isabel, engravidou. Ela ficou em casa, sem sair, durante cinco meses. ");
INSERT INTO porblt_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Isabel disse: “O Senhor fez isso por mim. Agora, a vergonha que eu sentia diante dos outros acabou!” ");
INSERT INTO porblt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","No sexto mês de sua gravidez, Deus enviou o anjo Gabriel para uma jovem chamada Maria, que vivia na cidade de Nazaré, na Galileia. ");
INSERT INTO porblt_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ela estava noiva de um homem chamado José. ");
INSERT INTO porblt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","O anjo a cumprimentou. Ele lhe disse: “Você é muito abençoada! O Senhor está com você!” ");
INSERT INTO porblt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria estava muito confusa com o que ele disse e imaginava qual seria o significado desse cumprimento. ");
INSERT INTO porblt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","O anjo continuou: “Não se preocupe, Maria, pois Deus veio demonstrar sua bondade para você! ");
INSERT INTO porblt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Você ficará grávida e dará à luz um filho. Você deverá chamá-lo Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ele será muito importante e será conhecido como o Filho do Altíssimo. Deus, o Senhor, dará para ele o trono de Davi, seu pai, ");
INSERT INTO porblt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","e ele reinará sobre a casa de Jacó para sempre. Seu Reino nunca se acabará.” ");
INSERT INTO porblt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria perguntou: “Como isso é possível? Eu ainda sou virgem!” ");
INSERT INTO porblt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ele respondeu: “O Espírito Santo virá sobre você e o poder do Altíssimo a envolverá. O bebê que nascerá será santo e será chamado de Filho de Deus. ");
INSERT INTO porblt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","E até Isabel, a sua parenta, está grávida mesmo sendo mais velha. A mulher que todos diziam que não podia ter filhos já está no sexto mês de gravidez. ");
INSERT INTO porblt_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nada é impossível para Deus.” ");
INSERT INTO porblt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria disse: “Aqui estou eu, pronta para ser a serva de Deus! Que aconteça comigo exatamente como você disse!” Então, o anjo foi embora. ");
INSERT INTO porblt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pouco tempo depois, Maria se preparou e foi depressa para as colinas da Judeia, para a cidade em que ");
INSERT INTO porblt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacarias e sua mulher moravam. Ela chamou Isabel assim que chegou. ");
INSERT INTO porblt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","No mesmo instante em que Isabel ouviu a voz de Maria, o bebê sentiu tanta alegria que mexeu dentro da sua barriga. Então, tomada pelo poder do Espírito Santo, Isabel ");
INSERT INTO porblt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","falou bem alto: “Você é a mais abençoada das mulheres, e a criança que nascerá de você também será abençoada! ");
INSERT INTO porblt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Quem sou eu para receber a visita da mãe do meu Senhor? ");
INSERT INTO porblt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Assim que ouvi você me cumprimentar, o meu bebê se mexeu dentro da minha barriga, de tanta alegria que sentiu. ");
INSERT INTO porblt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Como você é abençoada! Pois você acredita que o Senhor fará o que lhe prometeu!” ");
INSERT INTO porblt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria respondeu: “Eu louvo ao Senhor! ");
INSERT INTO porblt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Estou tão feliz com Deus, meu Salvador! ");
INSERT INTO porblt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Pois ele decidiu que eu, sua serva, era digna de sua consideração, apesar de minha origem humilde. De agora em diante, todos dirão que eu fui abençoada, ");
INSERT INTO porblt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","pois o Deus Poderoso fez coisas maravilhosas por mim. Seu nome é santo. ");
INSERT INTO porblt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A sua bondade passa de geração em geração para aqueles que o respeitam. ");
INSERT INTO porblt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Com o seu poder, ele destrói os que, com arrogância, pensam que são muito espertos. ");
INSERT INTO porblt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ele tira de seus tronos reis poderosos e põe em altas posições os humildes. ");
INSERT INTO porblt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ele dá aos que têm fome boas coisas para comer e manda os ricos embora de mãos vazias. ");
INSERT INTO porblt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Exatamente como prometeu aos nossos antepassados, ele ajudou o povo de Israel, seu servo. ");
INSERT INTO porblt_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","E se lembrou de demonstrar piedade para Abraão e seus descendentes para sempre.” ");
INSERT INTO porblt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ficou com Isabel por três meses e, depois, voltou para sua casa. ");
INSERT INTO porblt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Chegou o momento de Isabel ter seu bebê, e ela deu à luz um menino. ");
INSERT INTO porblt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Seus vizinhos e parentes ouviram falar de como o Senhor tinha demonstrado sua imensa bondade com Isabel e foram comemorar junto com ela. ");
INSERT INTO porblt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Oito dias depois, vieram para fazer a circuncisão do menino. E eles queriam chamar o bebê de Zacarias, em homenagem a seu pai. ");
INSERT INTO porblt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mas, Isabel disse: “Não! Ele deve se chamar João.” ");
INSERT INTO porblt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Eles lhe disseram: “Mas, nenhum dos nossos parentes tem esse nome.” ");
INSERT INTO porblt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Gesticulando, eles perguntaram ao pai da criança, Zacarias, qual nome ele queria para o seu filho. ");
INSERT INTO porblt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarias mostrou, por meio de gestos, que queria algo em que pudesse escrever. Para a surpresa de todos, ele escreveu: “Seu nome é João.” ");
INSERT INTO porblt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Imediatamente, ele voltou a falar e começou a louvar a Deus. ");
INSERT INTO porblt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Todos os vizinhos ficaram assombrados com o que havia acontecido, e a notícia se espalhou por toda a região montanhosa da Judeia. ");
INSERT INTO porblt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Todos os que ouviam a notícia pensavam sobre o significado dela. Eles perguntavam: “O que o pequenino vai ser quando crescer?” Pois era certo que o menino era muito especial para Deus. ");
INSERT INTO porblt_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarias, seu pai, cheio do Espírito Santo, fez esta profecia: ");
INSERT INTO porblt_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“O Senhor, o Deus de Israel, é maravilhoso, pois ele veio para o seu povo e o libertou. ");
INSERT INTO porblt_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ele nos deu um grande Salvador, descendente do seu servo Davi, ");
INSERT INTO porblt_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","exatamente como tinha prometido, por intermédio dos seus santos profetas, muito tempo atrás. ");
INSERT INTO porblt_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ele prometeu nos salvar dos nossos inimigos, daqueles que nos odeiam. ");
INSERT INTO porblt_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ele foi bondoso para os nossos ancestrais, lembrando-se da sua santa aliança. ");
INSERT INTO porblt_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ele fez uma promessa para o nosso antepassado Abraão. ");
INSERT INTO porblt_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ele nos libertou do medo e nos resgatou das mãos dos nossos inimigos, ");
INSERT INTO porblt_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","para que possamos servi-lo, fazendo o que é bom e certo por toda a nossa vida. ");
INSERT INTO porblt_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Apesar de você ser apenas uma criancinha, será chamado profeta do Altíssimo, pois você irá à frente do Senhor, para lhe preparar o caminho. ");
INSERT INTO porblt_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Você anunciará a salvação ao povo de Deus, que virá por meio do perdão dos pecados deles. ");
INSERT INTO porblt_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Pela bondade e cuidado do nosso Deus, o sol nascente, vindo do céu, irá descer sobre nós, ");
INSERT INTO porblt_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","para iluminar aqueles que vivem nas trevas e na sombra da morte e para nos guiar pelo caminho da paz.” ");
INSERT INTO porblt_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","O menino João cresceu e se tornou espiritualmente forte. Ele viveu no deserto, até que chegou o momento de se apresentar ao povo de Israel. ");
INSERT INTO porblt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Naquela época, o imperador Augusto emitiu um decreto, no qual ordenava que fosse feita uma contagem de toda a população do Império Romano. ");
INSERT INTO porblt_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Essa foi a primeira contagem durante o governo de Quirino, na Síria. ");
INSERT INTO porblt_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Então, todos foram se registrar, cada um em sua própria cidade. ");
INSERT INTO porblt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Como José era descendente do rei Davi, ele saiu de Nazaré, na Galileia, e foi para Belém, a cidade de Davi, na Judeia. ");
INSERT INTO porblt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ele foi se registrar lá, juntamente com Maria, que estava prometida em casamento a ele e que esperava um bebê. ");
INSERT INTO porblt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Enquanto eles estavam em Belém, chegou a época do bebê nascer. ");
INSERT INTO porblt_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Maria deu à luz o seu filho primogênito. Ela embrulhou o bebê em panos e o deitou em uma manjedoura, pois não havia lugar para eles na pensão. ");
INSERT INTO porblt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Havia, naquela mesma região, alguns pastores que estavam passando a noite nos campos, cuidando dos seus rebanhos. ");
INSERT INTO porblt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Um anjo do Senhor apareceu aos pastores, e a glória do Senhor brilhou ao redor deles. Eles ficaram com muito medo. ");
INSERT INTO porblt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","O anjo lhes disse: “Não tenham medo! Eu estou aqui para lhes trazer as boas novas, que deixarão todas as pessoas realmente contentes. ");
INSERT INTO porblt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nasceu hoje, na cidade de Davi, o Salvador de vocês. Ele é o Messias, o Senhor. ");
INSERT INTO porblt_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Vocês o reconhecerão por este sinal: vocês encontrarão a criança enrolada em panos, dormindo em uma manjedoura.” ");
INSERT INTO porblt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","De repente, muitos seres celestiais apareceram, louvando a Deus e dizendo: ");
INSERT INTO porblt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Glória a Deus no céu e paz na terra às pessoas a quem ele quer bem!” ");
INSERT INTO porblt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Após os anjos voltarem para o céu, os pastores disseram uns para os outros: “Vamos até Belém, para ver o que aconteceu em relação ao que o Senhor nos disse.” ");
INSERT INTO porblt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eles correram para lá e encontraram Maria, José e o bebê, que estava deitado na manjedoura. ");
INSERT INTO porblt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Após eles terem visto o bebê, espalharam a notícia do que havia acontecido e o que eles tinham ouvido a respeito do menino. ");
INSERT INTO porblt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Todos os que ouviram o que os pastores diziam ficaram impressionados. ");
INSERT INTO porblt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mas, Maria se lembrava com carinho a respeito de todas essas coisas e muitas vezes pensava nelas. ");
INSERT INTO porblt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Os pastores voltaram para vigiar os seus rebanhos, glorificando e agradecendo a Deus por tudo o que eles tinham ouvido e visto, pois tudo foi exatamente como havia sido dito a eles. ");
INSERT INTO porblt_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Após oito dias, chegou o momento de ser feita a circuncisão no bebê e ele recebeu o nome de Jesus. Esse foi o nome dado a ele pelo anjo, antes dele ter sido concebido. ");
INSERT INTO porblt_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Quando o período da purificação deles de acordo com a lei de Moisés tinha chegado ao fim, José e Maria levaram Jesus a Jerusalém, para apresentá-lo ao Senhor, ");
INSERT INTO porblt_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","conforme a lei do Senhor afirma: “Todo filho recém-nascido deve ser dedicado ao Senhor.” ");
INSERT INTO porblt_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Eles também fizeram um sacrifício exatamente como a lei de Deus pede: “duas rolinhas ou dois pombinhos.” ");
INSERT INTO porblt_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Naquela época, vivia em Jerusalém um homem chamado Simeão. Ele era um homem bom e também muito piedoso. Ele estava esperando a salvação do povo de Israel e o Espírito Santo estava com ele. ");
INSERT INTO porblt_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","O próprio Espírito Santo tinha revelado a Simeão que ele não morreria sem antes ver o Messias do Senhor. ");
INSERT INTO porblt_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Seguindo as orientações do Espírito, Simeão foi ao Templo. Quando os pais de Jesus o levaram ao Templo, para ser dedicado como a Lei manda, ");
INSERT INTO porblt_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeão pegou Jesus em seus braços, agradeceu a Deus e disse: ");
INSERT INTO porblt_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Agora, Senhor, que cumpriu o que prometeu, já pode deixar este seu servo morrer em paz, ");
INSERT INTO porblt_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","pois vi com os meus olhos a sua salvação, ");
INSERT INTO porblt_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","a qual você preparou para todos. ");
INSERT INTO porblt_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ele é a luz que o mostrará para as pessoas de todas as nações. Ele é a glória do seu povo de Israel.” ");
INSERT INTO porblt_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","O pai e a mãe do menino ficaram admirados com o que Simeão dissera a respeito dele. ");
INSERT INTO porblt_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Então, Simeão os abençoou e disse a Maria, mãe de Jesus: “Este menino está destinado a ser tanto para destruição quanto para a salvação de muitos em Israel. Ele é um sinal de Deus que muitos irão rejeitar, ");
INSERT INTO porblt_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","revelando o que eles realmente pensam. Para você, Maria, será como uma espada atravessando-a.” ");
INSERT INTO porblt_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Também vivia em Jerusalém uma profetisa muito idosa, chamada Ana. Ela era filha de Fanuel, da tribo de Aser. Ela vivera com o marido durante sete anos, ");
INSERT INTO porblt_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","mas, depois, ficou viúva, e já estava com oitenta e quatro anos. Ana passava seus dias no Templo, adorando, jejuando e orando. ");
INSERT INTO porblt_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ela se aproximou deles exatamente naquele momento e começou a louvar a Deus. Ela falou sobre Jesus a todos que aguardavam que Deus libertasse Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Depois que eles cumpriram tudo que a lei de Deus exigia, voltaram para a sua cidade de Nazaré, na Galileia. ");
INSERT INTO porblt_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","O menino crescia e ficava forte, tinha muita sabedoria e Deus o abençoava. ");
INSERT INTO porblt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Os pais de Jesus viajavam para Jerusalém todo ano para a festa da Páscoa. ");
INSERT INTO porblt_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Quando Jesus tinha doze anos de idade, eles foram para a festa, como já era costume da família. ");
INSERT INTO porblt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Quando a festa terminou, eles começaram a viagem de volta para casa. No entanto, Jesus tinha ficado em Jerusalém sem que os seus pais percebessem. ");
INSERT INTO porblt_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Eles acharam que o menino estava com as outras pessoas que faziam a viagem de volta para casa. Passou-se um dia de viagem antes que começassem a procurá-lo entre os seus amigos e parentes. ");
INSERT INTO porblt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Como não o encontraram, voltaram a Jerusalém para procurá-lo por lá. ");
INSERT INTO porblt_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Buscaram o menino durante três dias, antes de encontrá-lo no Templo. Ele estava sentado entre os educadores religiosos, ouvindo o que eles diziam e fazendo-lhes perguntas. ");
INSERT INTO porblt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Todas as pessoas que ouviam Jesus falar ficavam surpresas com seu conhecimento e com suas respostas. ");
INSERT INTO porblt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Seus pais ficaram grandemente admirados quando viram o que ele estava fazendo. A sua mãe lhe perguntou: “Filho, por que você fez isso conosco? O seu pai e eu ficamos muito preocupados! Nós o procuramos em todos os lugares!” ");
INSERT INTO porblt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“Por que é que vocês estavam me procurando?”, Jesus respondeu. “Não sabiam que eu devia estar aqui na casa do meu Pai?” ");
INSERT INTO porblt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mas, eles não entenderam o que ele queria dizer. ");
INSERT INTO porblt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Então, Jesus voltou com os seus pais para Nazaré e continuou a ser obediente a eles. A sua mãe observava, com muita atenção, tudo o que acontecia. ");
INSERT INTO porblt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesus crescia cada vez mais inteligente e forte, e tanto Deus quanto as pessoas gostavam cada vez mais dele. ");
INSERT INTO porblt_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Fazia quinze anos que Tibério era imperador. Nesse tempo, Pôncio Pilatos era o governador da Judeia, Herodes era o governador da Galileia, seu irmão, Filipe, era o governador da Itureia e Traconites, e Lisânias era o governador de Abilene. ");
INSERT INTO porblt_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás e Caifás eram os grandes sacerdotes. Foi nessa época que a palavra de Deus chegou a João, filho de Zacarias, que estava morando no deserto. ");
INSERT INTO porblt_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ele percorreu toda a região do rio Jordão, anunciando a todos que eles precisavam ser batizados, para mostrar que se arrependeram e que seus pecados tinham sido perdoados. ");
INSERT INTO porblt_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Como Isaías, o profeta, escreveu: “Uma voz foi ouvida no deserto e dizia: ‘Preparem o caminho do Senhor! Abram um caminho reto para ele! ");
INSERT INTO porblt_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Todos os vales serão aterrados e todos os montes e colinas serão nivelados. Os caminhos tortos serão endireitados e as estradas esburacadas serão consertadas. ");
INSERT INTO porblt_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Todos os seres humanos verão a salvação de Deus.’” ");
INSERT INTO porblt_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","João dizia às multidões que vinham para serem batizadas por ele: “Ninhada de serpentes venenosas! Quem disse que vocês irão escapar do julgamento que virá? ");
INSERT INTO porblt_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Demonstrem que realmente se arrependeram dos seus pecados. Não tentem justificar a si mesmos, dizendo: ‘Nós somos descendentes de Abraão’, pois eu lhes digo que até destas pedras Deus pode criar filhos de Abraão. ");
INSERT INTO porblt_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","O machado está pronto para começar a cortar as árvores pela raiz. Qualquer árvore que não produzir bons frutos será cortada e jogada no fogo.” ");
INSERT INTO porblt_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A multidão perguntava a João: “Então, o que devemos fazer?” ");
INSERT INTO porblt_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ele lhes respondia: “Se vocês têm dois casacos, deem um a quem não tem nenhum. Se tiverem comida, repartam com aqueles que não têm nada para comer.” ");
INSERT INTO porblt_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Alguns cobradores de impostos vieram para serem batizados. Eles também perguntaram: “Mestre, o que devemos fazer?” ");
INSERT INTO porblt_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ele respondeu: “Não cobrem mais imposto do que a quantia devida.” ");
INSERT INTO porblt_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Alguns soldados perguntaram: “E nós, o que devemos fazer?” João respondeu: “Não exijam dinheiro por meio de ameaças ou violência. Não façam acusações falsas. Fiquem satisfeitos com os seus salários.” ");
INSERT INTO porblt_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","As pessoas aguardavam com grande expectativa e imaginavam que talvez o próprio João seria o Messias. ");
INSERT INTO porblt_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","João respondia e explicava a todos: “Sim, eu estou batizando vocês com água. Mas, aquele que está vindo é mais importante do que eu. E eu não sou digno nem de desamarrar as correias de suas sandálias. Ele batizará vocês com o Espírito Santo e com fogo. ");
INSERT INTO porblt_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ele já está segurando a sua pá e está pronto para separar o trigo da palha em sua eira. Ele reunirá o trigo em seu depósito, mas queimará a palha com o fogo que não se apaga.” ");
INSERT INTO porblt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","João dava muitos conselhos como esse quando ele anunciava o evangelho para as pessoas. ");
INSERT INTO porblt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mas, quando João reprovou a atitude de Herodes, o governador, de se casar com Herodias, a sua cunhada, e de todas as coisas más que ele tinha feito, ");
INSERT INTO porblt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes acrescentou a sua lista de crimes a prisão de João. ");
INSERT INTO porblt_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Depois do batismo de todas aquelas pessoas, Jesus também foi batizado. Enquanto ele estava orando, o céu se abriu ");
INSERT INTO porblt_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","e o Espírito Santo desceu na forma de uma pomba sobre ele. Uma voz vinda do céu disse: “Você é o meu Filho, a quem eu amo muito! Você realmente me deixa muito feliz!” ");
INSERT INTO porblt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus tinha cerca de trinta anos quando começou o seu trabalho. As pessoas achavam que ele era filho de José. José era filho de Eli, ");
INSERT INTO porblt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","filho de Matate, filho de Levi, filho de Melqui, filho de Janai, filho de José, ");
INSERT INTO porblt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","filho de Matatias, filho de Amós, filho de Naum, filho de Esli, filho de Nagai, ");
INSERT INTO porblt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","filho de Maate, filho de Matatias, filho de Semei, filho de José, filho de Jodá, ");
INSERT INTO porblt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","filho de Joanã, filho de Resa, filho de Zorobabel, filho de Salatiel, filho de Neri, ");
INSERT INTO porblt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","filho de Melqui, filho de Adi, filho de Cosã, filho de Elmadã, filho de Er, ");
INSERT INTO porblt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","filho de Josué, filho de Eliézer, filho de Jorim, filho de Matate, filho de Levi, ");
INSERT INTO porblt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","filho de Simeão, filho de Judá, filho de José, filho de Jonã, filho de Eliaquim, ");
INSERT INTO porblt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","filho de Meleá, filho de Mená, filho de Matatá, filho de Natã, filho de Davi, ");
INSERT INTO porblt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","filho de Jessé, filho de Obede, filho de Boaz, filho de Salmom, filho de Naassom, ");
INSERT INTO porblt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","filho de Aminadabe, filho de Arni, filho de Esrom, filho de Perez, filho de Judá, ");
INSERT INTO porblt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","filho de Jacó, filho de Isaque, filho de Abraão, filho de Tera, filho de Naor, ");
INSERT INTO porblt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","filho de Serugue, filho de Ragaú, filho de Faleque, filho de Éber, filho de Salá, ");
INSERT INTO porblt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","filho de Cainã, filho de Arfaxade, filho de Sem, filho de Noé, filho de Lameque, ");
INSERT INTO porblt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","filho de Matusalém, filho de Enoque, filho de Jarede, filho de Maalalel, filho de Cainã, ");
INSERT INTO porblt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","filho de Enos, filho de Sete, filho de Adão, filho de Deus. ");
INSERT INTO porblt_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus, cheio do Espírito Santo, voltou do rio Jordão e foi guiado, pelo mesmo Espírito, no deserto. ");
INSERT INTO porblt_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Lá ele foi tentado pelo diabo durante quarenta dias. Ele não comeu nada durante todo esse tempo. Então, no fim desse período, ele estava faminto. ");
INSERT INTO porblt_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","O diabo lhe disse: “Se você é o Filho de Deus, mande que esta pedra vire pão.” ");
INSERT INTO porblt_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus respondeu: “Está escrito nas Sagradas Escrituras: ‘O homem não viverá só de pão.’” ");
INSERT INTO porblt_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","O diabo levou Jesus para um lugar alto e, em uma visão rápida, lhe mostrou todos os reinos do mundo. ");
INSERT INTO porblt_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Então, o diabo disse a Jesus: “Eu lhe darei toda a autoridade sobre eles e toda a sua glória. Essa autoridade foi dada a mim e eu posso dá-la a quem eu quiser. ");
INSERT INTO porblt_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ajoelhe-se e me adore e poderá ter isso tudo.” ");
INSERT INTO porblt_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus respondeu: “Está escrito nas Sagradas Escrituras: ‘Adore o Senhor, seu Deus, e sirva apenas a ele.’” ");
INSERT INTO porblt_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","O diabo levou Jesus para Jerusalém e o deixou na parte mais alta do Templo e disse: “Se você é o Filho de Deus, então, pule. ");
INSERT INTO porblt_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pois está escrito nas Sagradas Escrituras: ‘Ele ordenará que os seus anjos cuidem de você, ");
INSERT INTO porblt_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","segurando-o para protegê-lo até mesmo de tropeçar em uma pedra.’” ");
INSERT INTO porblt_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesus respondeu: “Está escrito nas Sagradas Escrituras: ‘Não teste o Senhor, seu Deus.’” ");
INSERT INTO porblt_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Quando o diabo acabou de tentar Jesus de todas as formas, ele desistiu e preferiu esperar por outra oportunidade. ");
INSERT INTO porblt_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesus voltou para a Galileia, tomado pelo poder do Espírito. As notícias sobre Jesus se espalharam por todos os lugares. ");
INSERT INTO porblt_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesus ensinou nas sinagogas, e todos o elogiavam. ");
INSERT INTO porblt_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ele chegou em Nazaré, onde havia crescido. No sábado, foi para a sinagoga, como de costume. ");
INSERT INTO porblt_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Lá, eles deram o livro do profeta Isaías para que ele lesse. Jesus abriu o livro e encontrou o lugar em que está escrito: ");
INSERT INTO porblt_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“O Espírito do Senhor está sobre mim, pois ele me escolheu para anunciar as boas novas aos necessitados. Ele me enviou para anunciar que os prisioneiros serão soltos, que os cegos verão, que os oprimidos serão libertados ");
INSERT INTO porblt_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","e para declarar o momento em que o Senhor nos salvará.” ");
INSERT INTO porblt_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ele fechou o livro e o devolveu ao ajudante da sinagoga. Depois, ele se sentou. Todas as pessoas que estavam na sinagoga olhavam fixamente para Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ele lhes disse: “Este trecho das Sagradas Escrituras, que vocês acabaram de ouvir, se cumpriu hoje!” ");
INSERT INTO porblt_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Todos que estavam lá o elogiavam. Eles estavam maravilhados com a sua forma agradável de falar. As pessoas pensaram: “Ele não é o filho de José?” ");
INSERT INTO porblt_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesus respondeu: “Eu tenho certeza de que vocês repetirão esse provérbio para mim: ‘Médico, cure a si mesmo!’ E irão perguntar: ‘Por que você não faz aqui, em sua própria cidade, o que ouvimos que você fez em Cafarnaum?’ ");
INSERT INTO porblt_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Eu lhes digo que isto é verdade: nenhum profeta é bem recebido em sua própria cidade. ");
INSERT INTO porblt_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Eu garanto que havia muitas viúvas em Israel durante a época de Elias, quando houve uma grande seca durante três anos e meio, causando muita fome em todo o país. ");
INSERT INTO porblt_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ainda assim, Deus não enviou Elias para qualquer uma dessas viúvas. Ele se encaminhou apenas para uma viúva em Sarepta, na região de Sidom. ");
INSERT INTO porblt_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mesmo havendo muitos leprosos em Israel no tempo de Eliseu, o único que ele curou foi Naamã, o sírio.” ");
INSERT INTO porblt_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Quando eles ouviram isso, todos que estavam na sinagoga ficaram furiosos. ");
INSERT INTO porblt_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Eles se levantaram e o expulsaram da cidade. Depois, eles o levaram para o alto da colina em que a cidade estava construída, para jogá-lo do penhasco. ");
INSERT INTO porblt_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mas, ele passou entre eles e foi embora. ");
INSERT INTO porblt_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesus foi para Cafarnaum, uma cidade na região da Galileia. No sábado, ele começou a ensinar o povo de lá. ");
INSERT INTO porblt_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Eles estavam impressionados com o que ele lhes ensinava, pois falava com autoridade. ");
INSERT INTO porblt_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na sinagoga, havia um homem que estava possuído pelo demônio. Ele gritou: ");
INSERT INTO porblt_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Então, Jesus de Nazaré, o que você quer de nós? Você veio para nos destruir? Eu sei quem é você: é o Santo que Deus enviou!” ");
INSERT INTO porblt_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesus o interrompeu, dizendo: “Fique quieto!” Então, ele ordenou ao demônio: “Saia deste homem!” Na frente de todos, o demônio jogou o homem no chão e saiu dele sem lhe causar ferimentos. ");
INSERT INTO porblt_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Todos ficaram admirados e perguntavam uns aos outros: “Que palavras são essas? Com poder e autoridade, ele ordena que os espíritos saiam, e eles obedecem!” ");
INSERT INTO porblt_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","As notícias sobre Jesus se espalharam pelas cidades ao redor. ");
INSERT INTO porblt_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ao sair da sinagoga, Jesus foi para a casa de Simão. A sogra de Simão estava doente, com uma febre muito alta, e eles pediram que Jesus a ajudasse. ");
INSERT INTO porblt_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesus foi e ficou perto dela. Ele ordenou que a febre passasse e, assim, aconteceu. Ela se levantou imediatamente e preparou uma refeição para eles. ");
INSERT INTO porblt_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Quando o sol se pôs, eles levaram a Jesus todos que estavam doentes, sofrendo de várias doenças. Ele colocou as suas mãos sobre eles, um após o outro, e todos foram curados. ");
INSERT INTO porblt_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Vários demônios, expulsos das pessoas, gritavam: “Você é o Filho de Deus!” Mas, Jesus os repreendia e se recusava a deixar que eles falassem, pois eles sabiam que ele era o Messias. ");
INSERT INTO porblt_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na manhã do dia seguinte, Jesus saiu para encontrar um lugar tranquilo e silencioso. Mas, a multidão saiu a sua procura e, finalmente, o encontrou. Eles insistiam para que ele não fosse embora. ");
INSERT INTO porblt_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ele lhes disse: “Eu também preciso ir a outras cidades, para anunciar as boas novas do Reino de Deus. Foi para isso que eu fui enviado.” ");
INSERT INTO porblt_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Então, Jesus percorreu as sinagogas da Judeia, anunciando as boas novas do Reino. ");
INSERT INTO porblt_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Um dia, Jesus estava parado próximo ao lago de Genesaré, e muitas pessoas se aglomeravam a sua volta para ouvir a palavra de Deus. ");
INSERT INTO porblt_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ele notou dois barcos à beira do mar, deixados lá por pescadores que estavam limpando as suas redes. ");
INSERT INTO porblt_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesus entrou em um dos barcos, o que pertencia a Simão e pediu a ele para empurrar o barco para a água, para que ficasse um pouco afastado da praia. Então, Jesus se sentou e do barco começou a ensinar às pessoas. ");
INSERT INTO porblt_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Após acabar de falar, ele disse a Simão: “Vá para uma parte do mar em que as águas são mais profundas e jogue as suas redes para pescar!” ");
INSERT INTO porblt_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simão respondeu: “Senhor, nós trabalhamos duro durante toda a noite e não conseguimos pescar nada. Mas, se você diz para que eu faça assim, então, jogarei as redes.” ");
INSERT INTO porblt_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ao fazer o que Jesus tinha lhe dito, um grande cardume de peixes encheu as redes, e elas ficaram tão cheias que quase arrebentaram. ");
INSERT INTO porblt_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eles acenaram para os seus companheiros, que estavam no outro barco, para que eles os ajudassem. Os outros vieram e, juntos, eles encheram os dois barcos com peixes. Os barcos estavam tão cheios, que estavam a ponto de afundar. ");
INSERT INTO porblt_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Quando Simão Pedro viu o que estava acontecendo, ele se ajoelhou diante de Jesus e disse: “Por favor, Senhor, afaste-se de mim, pois eu sou um pecador!” ");
INSERT INTO porblt_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tanto Simão quanto os seus companheiros ficaram completamente espantados com a quantidade de peixes que eles tinham apanhado. ");
INSERT INTO porblt_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tiago e João, filhos de Zebedeu, companheiros de Simão, também ficaram admirados. Jesus disse a Simão: “Não tenha medo! De agora em diante, você irá pescar pessoas.” ");
INSERT INTO porblt_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Então, eles puxaram os barcos para a praia, deixaram tudo lá e seguiram Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Certa vez, Jesus visitava uma das cidades, quando ele encontrou um homem que tinha um caso muito grave de lepra. O homem se ajoelhou diante de Jesus, colocando o seu rosto no chão e implorou: “Por favor, se o senhor quiser, pode me purificar!” ");
INSERT INTO porblt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus estendeu a sua mão e tocou no homem. “Sim, eu quero!”, ele disse. “Você está purificado!” Imediatamente a lepra desapareceu. ");
INSERT INTO porblt_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesus disse ao homem: “Não diga nada a ninguém. Vá e peça ao sacerdote que o examine. Depois faça os sacrifícios cerimoniais como exigido pela lei de Moisés, para provar que você foi curado.” ");
INSERT INTO porblt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","No entanto, as notícias sobre Jesus se espalhavam ainda mais rapidamente. Grandes multidões se aglomeravam para ouvir Jesus e serem curadas de suas doenças. ");
INSERT INTO porblt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mas, muitas vezes, Jesus costumava procurar lugares calmos para orar. ");
INSERT INTO porblt_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Um dia, quando Jesus estava ensinando, havia fariseus e educadores religiosos vindos da Galileia, Judeia e de Jerusalém sentados próximos a ele. O poder do Senhor estava com Jesus; assim ele conseguia curar os doentes. ");
INSERT INTO porblt_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Alguns homens chegaram, carregando um paralítico em uma esteira. Eles estavam tentando levar o doente para colocá-lo diante de Jesus, ");
INSERT INTO porblt_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","mas não conseguiam abrir caminho entre a multidão. Então, os homens subiram no telhado e fizeram uma abertura entre as telhas. Depois, eles desceram o paralítico, deitado na esteira, no meio da multidão em frente a Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Quando Jesus viu a fé que eles tinham nele, disse ao paralítico: “Os seus pecados estão perdoados!” ");
INSERT INTO porblt_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Os educadores religiosos e os fariseus começaram a pensar: “Quem é esse homem que blasfema contra Deus? Quem pode perdoar pecados? Apenas Deus pode fazer isso!” ");
INSERT INTO porblt_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus sabia o que eles estavam pensando. Então, ele lhes perguntou: “Por que vocês estão pensando assim? ");
INSERT INTO porblt_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","O que é mais fácil? Dizer: ‘Os seus pecados estão perdoados’ ou: ‘Levante-se e ande’? ");
INSERT INTO porblt_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Contudo, irei mostrar a vocês que o Filho do Homem tem sobre a terra autoridade para perdoar pecados.” Então, ele disse ao paralítico: “Eu lhe digo: Levante-se!, pegue a sua esteira e vá para casa.” ");
INSERT INTO porblt_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Imediatamente, o homem ficou em pé na frente de todos. Ele pegou a esteira em que estava deitado e foi para casa, louvando a Deus, enquanto seguia o seu caminho. ");
INSERT INTO porblt_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Todos os que estavam lá ficaram completamente espantados com o que havia acontecido e, com grande admiração, louvaram a Deus, dizendo: “O que vimos acontecer hoje foi extraordinário!” ");
INSERT INTO porblt_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Depois, conforme Jesus estava indo embora da cidade, ele viu um cobrador de impostos, chamado Levi, sentado no lugar em que cobrava os impostos. Jesus lhe disse: “Siga-me!” ");
INSERT INTO porblt_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi se levantou, deixou tudo para trás e seguiu Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi organizou um grande banquete em sua casa, em homenagem a Jesus. Muitos cobradores de impostos e outras pessoas também faziam parte da multidão que estava sentada, comendo com eles. Mas, os fariseus e os educadores religiosos reclamaram com os discípulos de Jesus, perguntando: ");
INSERT INTO porblt_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","“Por que vocês comem e bebem com os cobradores de impostos e com os pecadores?” ");
INSERT INTO porblt_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus respondeu: “As pessoas saudáveis não precisam de médico, mas os doentes precisam. ");
INSERT INTO porblt_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Eu não vim para chamar os bons. Eu vim chamar os pecadores, para que se arrependam dos seus pecados.” ");
INSERT INTO porblt_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Eles novamente argumentaram com Jesus: “Bem, os discípulos de João Batista frequentemente jejuam e oram, como também os discípulos dos fariseus. Mas, os seus discípulos não; eles comem e bebem.” ");
INSERT INTO porblt_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus, então, perguntou: “Os padrinhos devem jejuar enquanto o noivo está entre eles? ");
INSERT INTO porblt_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Não. Mas, chegará o momento em que o noivo irá se afastar deles. Então, os padrinhos poderão jejuar.” ");
INSERT INTO porblt_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Depois, Jesus também deu estes exemplos para eles: “Não se deve tirar um retalho de uma roupa nova para arrumar uma roupa velha. Caso contrário, a roupa nova ficará estragada e o retalho da nova não combinará com o tecido da roupa velha. ");
INSERT INTO porblt_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Não se deve colocar vinho novo em recipientes de couro velhos. Pois o vinho novo arrebentaria os recipientes. O vinho seria desperdiçado e os recipientes de couro ficariam estragados. ");
INSERT INTO porblt_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Deve-se colocar vinho novo em recipientes de couro novos. ");
INSERT INTO porblt_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","E ninguém, após beber vinho velho, quer experimentar o vinho novo, pois eles dizem: ‘O vinho velho é melhor!’”. ");
INSERT INTO porblt_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Em um sábado, enquanto Jesus passeava pelos campos de trigo, seus discípulos começaram a colher e a debulhar algumas espigas e a comer os grãos. ");
INSERT INTO porblt_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Alguns fariseus questionaram Jesus: “Por que vocês estão fazendo o que não é permitido fazer aos sábados?” ");
INSERT INTO porblt_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus respondeu: “Vocês nunca leram o que Davi fez, quando ele e seus companheiros estavam com fome? ");
INSERT INTO porblt_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Como entrou na casa de Deus e pegou os pães consagrados? Ele comeu o pão e o deu para que os seus companheiros comessem também. Isso também não é permitido. Pois apenas os sacerdotes podem fazer isso.” ");
INSERT INTO porblt_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Então, ele lhes disse: “O Filho do Homem é o Senhor do Sábado.” ");
INSERT INTO porblt_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Em um outro sábado, Jesus foi para a sinagoga ensinar. Havia um homem lá que tinha uma deficiência na mão direita. ");
INSERT INTO porblt_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Os educadores religiosos e os fariseus estavam observando Jesus bem de perto, para ver se ele iria curar alguém no sábado. Eles queriam encontrar alguma coisa para poder acusá-lo. ");
INSERT INTO porblt_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mas, Jesus sabia o que eles tinham em mente. Ele disse ao homem que tinha o problema na mão: “Levante-se e fique diante de todos!” O homem fez como Jesus pediu. ");
INSERT INTO porblt_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Então, Jesus se virou para as pessoas que lá estavam e disse: “Quero lhes fazer uma pergunta. Está de acordo com a lei fazer o bem aos sábados ou fazer o mal? Salvar vidas ou destruí-las?” ");
INSERT INTO porblt_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ele olhou em volta para todos que lá estavam. Então, disse ao homem: “Estenda a sua mão!” O homem a estendeu e sua mão ficou curada. ");
INSERT INTO porblt_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mas, os educadores religiosos e os fariseus ficaram furiosos e começaram a discutir sobre o que deveriam fazer com Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","No dia seguinte, Jesus subiu um monte para orar. Ele ficou lá a noite toda, orando a Deus. ");
INSERT INTO porblt_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Quando o dia amanheceu, chamou os seus discípulos e escolheu doze deles. Estes são os nomes dos apóstolos: ");
INSERT INTO porblt_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simão (também chamado de Pedro por Jesus) e o seu irmão André; Tiago e o seu irmão João; Filipe e Bartolomeu; ");
INSERT INTO porblt_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateus e Tomé; Tiago, filho de Alfeu, e Simão, o revolucionário; ");
INSERT INTO porblt_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, filho de Tiago e Judas Iscariotes (o traidor de Jesus). ");
INSERT INTO porblt_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesus desceu do monte com eles e parou em um lugar plano. Havia uma grande multidão, na qual se encontravam muitos dos seus seguidores e muitas outras pessoas vindas da Judeia, de Jerusalém e do litoral de Tiro e Sidom, que se reuniu para ouvir Jesus e para ser curada de suas doenças. ");
INSERT INTO porblt_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","As pessoas atormentadas por espíritos maus também foram curadas. ");
INSERT INTO porblt_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Todos na multidão tentavam tocar em Jesus, pois havia poder saindo dele e curando a todos. ");
INSERT INTO porblt_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Olhando para os seus discípulos, Jesus lhes disse: ");
INSERT INTO porblt_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Felizes são vocês, os pobres, pois o Reino de Deus é de vocês. Felizes são vocês que agora sentem fome, pois comerão até se satisfazer. Felizes são vocês que agora choram, pois irão rir. ");
INSERT INTO porblt_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Felizes são vocês quando as pessoas os odiarem, excluirem, insultarem e disserem que são maus, por seguirem o Filho do Homem. ");
INSERT INTO porblt_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","No dia em que essas coisas acontecerem, fiquem felizes. Pulem de alegria, pois será grande a recompensa que os espera no céu. Não se esqueçam de que os seus antepassados maltrataram os profetas exatamente dessa forma. ");
INSERT INTO porblt_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mas, infelizes são vocês que são ricos, pois já receberam a sua recompensa. ");
INSERT INTO porblt_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Infelizes são vocês que estão satisfeitos agora, pois sentirão fome. Infelizes são vocês que riem agora, pois irão se lamentar e chorar. ");
INSERT INTO porblt_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Infelizes são vocês a quem todos elogiam. Não se esqueçam de que os seus antepassados elogiaram os falsos profetas exatamente da mesma maneira. ");
INSERT INTO porblt_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mas, eu digo para aqueles que estão me ouvindo: Amem os seus inimigos. Façam o bem para aqueles que os odeiam. ");
INSERT INTO porblt_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Queiram o bem daqueles que os amaldiçoam. Orem por aqueles que os maltratam. ");
INSERT INTO porblt_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Se alguém lhes bater na cara, virem o outro lado, para que bata também. Se alguém tomar o casaco de vocês, não o impeça de levar a sua camisa também. ");
INSERT INTO porblt_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Deem a qualquer um que lhes pedir. Se alguém tirar algo de vocês, não peçam que devolva. ");
INSERT INTO porblt_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Façam aos outros o que gostariam que eles fizessem a vocês. ");
INSERT INTO porblt_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Se vocês amarem apenas quem os ama, por que deveriam merecer qualquer crédito por isso? Até mesmo os pecadores amam aqueles que os amam. ");
INSERT INTO porblt_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Se vocês fizerem o bem apenas para aqueles que fazem coisas boas para vocês, por que deveriam merecer qualquer crédito por isso? Os pecadores fazem isso também. ");
INSERT INTO porblt_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Se vocês emprestarem dinheiro, esperando que seja devolvido, por que deveriam merecer qualquer crédito por isso? Os pecadores também emprestam dinheiro a outros pecadores, esperando receber o que foi emprestado. ");
INSERT INTO porblt_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Não! Porém façam diferente: amem os seus inimigos e façam boas coisas para eles e emprestem sem esperar receber o que foi emprestado. Assim, vocês irão receber uma grande recompensa e serão filhos do Deus Altíssimo, pois ele é bom também para as pessoas ingratas e más. ");
INSERT INTO porblt_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sejam misericordiosos, tal como o seu Pai é misericordioso. ");
INSERT INTO porblt_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Não julguem, e vocês não serão julgados. Não condenem, e vocês não serão condenados. Perdoem, e vocês serão perdoados. ");
INSERT INTO porblt_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Deem, e vocês receberão muito mais em troca. O que lhes é dado em troca é medido de tal forma para que mais possa lhes ser dado, derramando bênçãos que se espalham a sua volta. O quanto vocês dão, determinará o quanto irão receber.” ");
INSERT INTO porblt_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Então, Jesus fez as seguintes comparações: “Um cego pode guiar outro? Os dois não cairiam em um buraco? ");
INSERT INTO porblt_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Os alunos sabem mais do que o professor? Apenas quando eles aprenderem tudo o que lhes foi ensinado serão semelhantes ao seu professor. ");
INSERT INTO porblt_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Por que você está tão preocupado com o cisco que está no olho do seu irmão, quando não nota nem mesmo a trave de madeira que está em seu próprio olho? ");
INSERT INTO porblt_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Como você pode dizer a seu irmão: ‘Irmão, deixe-me ajudá-lo a tirar o cisco que está em seu olho.’ Se não consegue perceber nem mesmo a trave que está em seu próprio olho? Hipócrita! Primeiro, tire a trave do seu olho e, então, será capaz de ver bem o bastante para tirar o cisco que está no olho do seu irmão. ");
INSERT INTO porblt_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Uma boa árvore não produz frutos ruins. E uma árvore ruim não produz frutos bons. ");
INSERT INTO porblt_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","As árvores são conhecidas pelos frutos que elas produzem. Não há como colher figos de espinheiros ou uvas de ervas daninhas. ");
INSERT INTO porblt_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pessoas boas produzem o que é bom, pois há bons sentimentos e pensamentos guardados dentro delas. Pessoas más produzem o que é ruim, pois há sentimentos e pensamentos ruins guardados dentro delas. As pessoas simplesmente colocam para fora, quando falam, o que está dentro delas. ");
INSERT INTO porblt_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Então, por que vocês me chamam ‘Senhor, Senhor,’ mas não fazem o que eu digo? ");
INSERT INTO porblt_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Eu darei a vocês um exemplo de alguém que vem até mim, ouve as minhas orientações e as segue. ");
INSERT INTO porblt_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Essa pessoa é como um homem que constrói uma casa. Ele cava bem fundo e coloca o alicerce em uma rocha sólida. Quando o rio transborda e a enchente alcança a casa, ela não se danifica, porque foi muito bem construída. ");
INSERT INTO porblt_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","A pessoa que me ouve, mas não faz o que eu digo, é como um homem que constrói a sua casa sem o alicerce. Quando a enchente alcança a casa, ela cai imediatamente e fica destruída por completo.” ");
INSERT INTO porblt_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Quando Jesus acabou de dizer tudo isso às pessoas, ele foi para Cafarnaum. ");
INSERT INTO porblt_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Havia na cidade um comandante romano que tinha um empregado, de quem ele gostava muito, que estava doente, à beira da morte. ");
INSERT INTO porblt_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Quando esse comandante ouviu falar a respeito de Jesus, enviou alguns anciãos do povo para lhe pedir que viesse curar o seu empregado. ");
INSERT INTO porblt_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Quando os anciãos do povo encontraram Jesus, pediram com bastante insistência, dizendo: “Por favor, venha e faça o que ele pede! Ele merece a sua ajuda, ");
INSERT INTO porblt_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","pois ama o nosso povo e construiu uma sinagoga para nós.” ");
INSERT INTO porblt_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesus foi com eles e quando se aproximaram da casa, o comandante romano enviou alguns amigos até Jesus para lhe dizer: “Por favor, Senhor, não se incomode, pois eu não sou digno de que entre em minha casa. ");
INSERT INTO porblt_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Eu nem mesmo acho que sou digno de falar pessoalmente com o senhor. Basta que dê uma ordem, e meu empregado será curado. ");
INSERT INTO porblt_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Eu estou sob o comando dos meus oficiais superiores e eu mesmo tenho soldados sob o meu comando. Eu ordeno que um vá e ele vai. Digo a outro que venha e ele vem. Eu ordeno que o meu empregado faça algo e ele faz.” ");
INSERT INTO porblt_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus ficou admirado ao ouvir tais palavras. Ele se virou para a multidão que o seguia e disse: “Eu lhes digo que nem entre o povo de Israel encontrei tanta fé!” ");
INSERT INTO porblt_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Então, os amigos do oficial romano voltaram para a casa e encontraram o empregado saudável novamente. ");
INSERT INTO porblt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Logo depois, Jesus foi para uma cidade chamada Naim, juntamente com os seus discípulos e uma grande multidão. ");
INSERT INTO porblt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Quando ele se aproximava do portão da cidade, viu que estava saindo um enterro. O homem que tinha morrido era o filho único de uma viúva, e muitas pessoas da cidade a acompanhavam. ");
INSERT INTO porblt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Quando o Senhor a viu, ficou com muita pena dela. Ele lhe disse: “Não chore!” ");
INSERT INTO porblt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesus se aproximou do caixão e o tocou. E aqueles que o carregavam pararam. Jesus disse: “Jovem, eu lhe digo, levante-se!” ");
INSERT INTO porblt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","O morto se sentou e começou a falar, e Jesus o devolveu para a mãe dele. ");
INSERT INTO porblt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Todos sentiram medo e louvaram a Deus, dizendo: “Um grande profeta surgiu entre nós!” E também diziam: “Deus visitou o seu povo!” ");
INSERT INTO porblt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","As notícias a respeito de Jesus se espalharam pela Judeia e por todas as regiões ao redor. ");
INSERT INTO porblt_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Os discípulos de João Batista falaram com ele a respeito disso tudo. ");
INSERT INTO porblt_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","João chamou dois deles e os enviou para que perguntassem a Jesus: “O senhor é aquele que estava para vir ou devemos esperar outro?” ");
INSERT INTO porblt_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Quando eles encontraram Jesus, disseram: “João Batista nos enviou para lhe perguntar: ‘O senhor é aquele que estava para vir ou devemos esperar outro?’” ");
INSERT INTO porblt_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Naquele exato momento, Jesus estava curando muitas pessoas de suas doenças, enfermidades, espíritos maus e fazendo com que os cegos voltassem a enxergar. ");
INSERT INTO porblt_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesus respondeu aos discípulos de João: “Vão e digam a João o que vocês viram e ouviram. Digam que os cegos conseguem ver, os mancos andam, os leprosos ficam curados, os surdos ouvem, os mortos são ressuscitados e os pobres recebem as boas novas. ");
INSERT INTO porblt_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Felizes aqueles que não duvidam de mim!” ");
INSERT INTO porblt_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Após os mensageiros de João saírem, Jesus começou a falar sobre João para a multidão: “O que vocês esperavam encontrar quando foram ver João no deserto? Algum caniço sendo agitado pelo vento? ");
INSERT INTO porblt_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Procuravam um homem com roupas elegantes? Não, pois os que vestem roupas finas e vivem luxuosamente devem ser procurados nos palácios. ");
INSERT INTO porblt_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Vocês procuravam um profeta? Sim, e eu lhes digo que João é muito mais do que um profeta. ");
INSERT INTO porblt_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nas Sagradas Escrituras está escrito sobre João: ‘Veja! Estou enviando o meu mensageiro adiante de você, para que ele prepare o seu caminho.’ ");
INSERT INTO porblt_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Eu lhes digo: ninguém que tenha nascido de mulher é mais importante do que João. Mas, até mesmo o menos importante no Reino de Deus é mais importante do que ele!” ");
INSERT INTO porblt_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ao ouvirem isso, todos que estavam lá, mesmo os cobradores de impostos, entenderam que o que Deus dizia era bom e certo, pois eles tinham sido batizados por João. ");
INSERT INTO porblt_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mas, os fariseus e os educadores religiosos rejeitaram o que Deus queria que eles fizessem, pois se recusaram a ser batizados por João. ");
INSERT INTO porblt_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesus perguntou: “Com quem eu devo comparar essas pessoas? Elas se parecem com quem? ");
INSERT INTO porblt_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Elas são como crianças sentadas na praça do mercado, dizendo umas para as outras: ‘Nós tocamos flauta para que vocês dançassem e vocês não dançaram. Nós cantamos músicas tristes para que vocês ficassem emocionadas, mas vocês não se emocionaram.’ ");
INSERT INTO porblt_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Quando João Batista não come pão ou bebe vinho, vocês dizem que ele está possuído pelo demônio. ");
INSERT INTO porblt_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Agora, o Filho do Homem está aqui e come e bebe junto com as pessoas, mas vocês dizem: ‘Vejam! Ele passa o tempo dele comendo demais e bebendo muito vinho. E tem mais, ele é amigo de cobradores de impostos e de pecadores.’ ");
INSERT INTO porblt_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","No entanto, todos aqueles que seguem pelos sábios caminhos de Deus comprovam como eles são verdadeiros.” ");
INSERT INTO porblt_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Um dos fariseus convidou Jesus para ir a sua casa comer com ele. Jesus foi para a casa do fariseu e sentou-se para comer. ");
INSERT INTO porblt_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Uma mulher daquela cidade, conhecida como pecadora, descobriu que Jesus estava na casa do fariseu. Ela foi até lá, levando um vaso feito de alabastro cheio de perfume. ");
INSERT INTO porblt_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ela se ajoelhou ao lado de Jesus e suas lágrimas molharam os seus pés. Então, ela os secou, usando seus cabelos. Ela beijou os pés de Jesus e depois espalhou o perfume sobre eles. ");
INSERT INTO porblt_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Quando o fariseu que havia convidado Jesus viu isso, ele pensou: “Se esse homem fosse realmente um profeta, ele saberia quem é essa mulher que o está tocando e o tipo de pessoa que ela é, ou seja, uma pecadora.” ");
INSERT INTO porblt_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus disse ao fariseu: “Simão, eu tenho algo a lhe dizer.” Simão respondeu: “Diga, Mestre!” ");
INSERT INTO porblt_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Certa vez, duas pessoas deviam para um homem que emprestava dinheiro. Um devia quinhentos denários, e o outro, apenas cinquenta. ");
INSERT INTO porblt_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nenhum deles tinha condições de pagar o homem que lhes havia emprestado dinheiro. Então, ele perdoou as dívidas. Qual deles terá mais afeição por esse homem?” ");
INSERT INTO porblt_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simão respondeu: “Eu acho que aquele que devia mais.” Jesus disse: “Você está completamente certo.” ");
INSERT INTO porblt_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Virando-se para a mulher, ele disse para Simão: “Você vê essa mulher? Quando eu entrei em sua casa, você não me deu água para lavar os meus pés; mas, ela lavou os meus pés com as suas lágrimas. Ela secou os meus pés com os seus cabelos. ");
INSERT INTO porblt_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Você não me beijou; mas, desde que entrei, ela não parou de beijar os meus pés. ");
INSERT INTO porblt_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Você não colocou azeite na minha cabeça; mas ela derramou perfume em meus pés. ");
INSERT INTO porblt_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Então, eu lhe digo que os muitos pecados dela foram perdoados. E isso só foi possível porque o amor dela é grande. Mas, aquele que é pouco perdoado, pouco ama.” ");
INSERT INTO porblt_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Então, Jesus disse para a mulher: “Os seus pecados foram perdoados.” ");
INSERT INTO porblt_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Os que estavam sentados, comendo com ele, começaram a falar entre si: “Quem é este que até mesmo perdoa pecados?” ");
INSERT INTO porblt_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mas, Jesus disse para a mulher: “A sua fé a salvou. Vá em paz!” ");
INSERT INTO porblt_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pouco tempo depois, Jesus saiu e percorreu as cidades e as vilas nas proximidades, anunciando as boas novas do Reino de Deus. Os doze discípulos foram com ele, ");
INSERT INTO porblt_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","juntamente com diversas mulheres que tinham sido curadas de espíritos maus e de doenças. Entre elas, estava Maria, conhecida como Madalena, de quem Jesus tinha expulsado sete demônios; ");
INSERT INTO porblt_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, a esposa do administrador do governo de Herodes, chamado Cuza; Suzana; e muitas outras mulheres que forneciam apoio a Jesus e aos seus discípulos, com a doação dos seus próprios bens. ");
INSERT INTO porblt_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Certa vez, quando uma grande multidão havia se reunido, vinda de muitas cidades para ver Jesus, ele começou a lhes falar, usando uma história como exemplo. ");
INSERT INTO porblt_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Um homem saiu para plantar suas sementes. Enquanto ele espalhava as sementes, algumas caíram na estrada, onde foram pisadas pelas pessoas e comidas pelos pássaros. ");
INSERT INTO porblt_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Algumas caíram no chão duro como pedra e, assim que as sementes germinaram, secaram por falta de umidade no solo. ");
INSERT INTO porblt_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Algumas sementes caíram entre os espinhos, que cresceram junto com as plantas e as sufocaram. ");
INSERT INTO porblt_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Algumas sementes caíram em um bom solo e, após crescerem, produziram uma colheita cem vezes maior do que o que havia sido plantado.” Após lhes contar essa história, Jesus disse: “Se vocês têm ouvidos, então, ouçam!” ");
INSERT INTO porblt_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mas, seus discípulos lhe perguntaram: “O que essa história significa?” ");
INSERT INTO porblt_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesus respondeu: “Os conhecimentos a respeito dos mistérios do Reino de Deus são apresentados a vocês. Mas, para as outras pessoas, esse conhecimento vem por meio das histórias, para que: ‘Mesmo que eles vejam, não enxerguem realmente, e mesmo que eles ouçam, não entendam realmente.’ ");
INSERT INTO porblt_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Este é o significado da história: A semente é a palavra de Deus. ");
INSERT INTO porblt_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","As sementes que caem na beira da estrada são aqueles que ouvem a mensagem, mas, então, o diabo vem e tira a mensagem do coração deles, fazendo com que não acreditem em Deus e não sejam salvos. ");
INSERT INTO porblt_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","As sementes que caem no chão duro como pedra são aqueles que ouvem e recebem com alegria a mensagem, mas não têm raízes. Eles acreditam por algum tempo, mas quando os tempos difíceis chegam, eles desistem. ");
INSERT INTO porblt_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","As sementes que caem entre os espinhos são aquelas pessoas que ouvem a mensagem. No entanto, essa mensagem é sufocada pelas distrações da vida, como as preocupações, riquezas, prazeres. Então, essas pessoas não produzem nada. ");
INSERT INTO porblt_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","As sementes que caíram em bom solo são aquelas pessoas que são honestas e que fazem o que é certo. Elas ouvem a mensagem, agarram-se a ela e, por causa da sua perseverança, produzem uma boa colheita. ");
INSERT INTO porblt_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Não se acende um lampião e depois se coloca um cesto sobre ele para cobri-lo, ou se o coloca debaixo da cama. Não. O lampião deve ser colocado em um velador, para que qualquer um que entre veja a luz. ");
INSERT INTO porblt_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pois tudo o que está escondido será descoberto, e tudo que está em segredo se tornará conhecido e revelado. ");
INSERT INTO porblt_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Então, prestem atenção em como vocês ‘ouvem.’ Para aqueles que recebem será dado mais. Daqueles que não recebem até mesmo o que eles pensam que têm lhes será tirado!” ");
INSERT INTO porblt_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Então, a mãe de Jesus e os seus irmãos chegaram, mas não conseguiram passar pela multidão para vê-lo. ");
INSERT INTO porblt_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Disseram a Jesus: “Sua mãe e seus irmãos estão lá fora. Eles querem vê-lo.” ");
INSERT INTO porblt_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesus respondeu: “Minha mãe e meus irmãos são aqueles que ouvem a palavra de Deus e agem conforme ela ensina.” ");
INSERT INTO porblt_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Um dia, Jesus disse aos seus discípulos: “Vamos para o outro lado do lago.” Assim, eles entraram em um barco e partiram. ");
INSERT INTO porblt_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Enquanto navegavam, Jesus dormiu e uma tempestade começou a cair sobre o lago. O barco se encheu de água e corria o risco de afundar. ");
INSERT INTO porblt_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eles se aproximaram de Jesus e o acordaram, dizendo: “Mestre, mestre! Nós iremos morrer!” Jesus acordou e ordenou que o vento e as ondas agitadas parassem. A natureza lhe obedeceu e tudo ficou calmo. ");
INSERT INTO porblt_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ele lhes perguntou: “Acaso vocês não têm fé?” Aterrorizados e admirados, eles disseram uns para os outros: “Então, quem é ele? Ele ordena aos ventos e à água, e eles lhe obedecem!” ");
INSERT INTO porblt_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Eles chegaram à região de Gerasa, que fica no lado oposto à Galileia. ");
INSERT INTO porblt_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Quando Jesus saiu do barco, um homem, possuído pelo demônio, vindo da cidade, foi encontrá-lo. Já fazia muito tempo que esse homem não usava roupas ou morava em uma casa. Ele vivia entre os túmulos. ");
INSERT INTO porblt_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ao ver Jesus, ele gritou, caiu aos pés dele e lhe perguntou, aos berros: “O que você quer de mim, Jesus, Filho do Deus Altíssimo? Por favor, eu lhe imploro, não me castigue!” ");
INSERT INTO porblt_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","O espírito disse isso porque Jesus já havia ordenado ao espírito mau que saísse do homem. Esse espírito muitas vezes o dominava e, apesar das pessoas o amarrarem com correntes e algemas e o vigiarem, o homem quebrava as correntes e era levado pelo demônio para lugares desertos. ");
INSERT INTO porblt_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","“Qual é o seu nome?” Jesus lhe perguntou. “Legião”, ele respondeu, pois muitos demônios haviam entrado nele. ");
INSERT INTO porblt_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eles imploraram para que Jesus não ordenasse que eles fossem para o Abismo. ");
INSERT INTO porblt_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Havia uma grande quantidade de porcos que estavam comendo em uma encosta próxima. Os demônios imploraram para que Jesus permitisse que eles entrassem nos porcos. Jesus permitiu, ");
INSERT INTO porblt_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","e os demônios saíram do homem e entraram nos porcos. Os animais se jogaram da encosta, caíram no lago e se afogaram. ");
INSERT INTO porblt_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Quando os homens que tomavam conta dos porcos viram o que havia acontecido, fugiram e espalharam a notícia na cidade e também pelos campos. ");
INSERT INTO porblt_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","As pessoas foram ver o que havia acontecido. Quando chegaram perto de Jesus, descobriram que o homem estava livre dos demônios. Ele estava sentado aos pés de Jesus, vestindo roupas e em seu juízo perfeito. As pessoas ficaram apavoradas. ");
INSERT INTO porblt_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aqueles que viram o que havia acontecido explicaram como o homem possuído pelos demônios tinha sido curado. ");
INSERT INTO porblt_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Em seguida, todos os moradores da região de Gerasa pediram que Jesus fosse embora, pois eles estavam tomados pelo medo. Assim, ele voltou para o barco e foi embora. ");
INSERT INTO porblt_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","O homem que havia sido libertado dos demônios implorou para ir com ele, mas Jesus lhe disse: ");
INSERT INTO porblt_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Volte para casa e conte para as pessoas tudo que Deus fez por você.” O homem foi embora e contou para toda a cidade tudo o que Jesus tinha feito por ele. ");
INSERT INTO porblt_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Uma multidão foi dar as boas-vindas a Jesus quando ele retornou. Elas estavam ansiosas, esperando por ele. ");
INSERT INTO porblt_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Uma dessas pessoas era Jairo, um líder da sinagoga, que se aproximou de Jesus e se jogou aos seus pés. Ele implorou a Jesus para que fosse com ele para a sua casa, ");
INSERT INTO porblt_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","pois a sua única filha estava morrendo. A menina tinha cerca de doze anos. Enquanto Jesus caminhava para a casa de Jairo, as pessoas se amontoavam ao redor dele. ");
INSERT INTO porblt_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","No meio da multidão havia uma mulher que sofria há doze anos, com uma hemorragia. Ela havia gastado todo o seu dinheiro, pagando médicos para que a curassem, mas nenhum deles tinha sido capaz de ajudá-la. ");
INSERT INTO porblt_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ela foi por trás de Jesus e tocou na barra da capa dele. Imediatamente, a hemorragia parou. ");
INSERT INTO porblt_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","“Quem me tocou?”, Jesus perguntou. Todos que estavam em volta dele negaram ter feito isso. Pedro disse: “Mas, Mestre, há uma multidão a sua volta. E ela o aperta.” ");
INSERT INTO porblt_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesus disse: “Alguém tocou em mim. Eu sei, porque senti que de mim saiu poder.” ");
INSERT INTO porblt_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Quando a mulher percebeu que não poderia mais se esconder, ela se aproximou de Jesus e, tremendo, ajoelhou-se diante dele. Na frente de todos, ela explicou o motivo de ter tocado em Jesus e também explicou que, ao tocá-lo, foi imediatamente curada. ");
INSERT INTO porblt_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesus disse à mulher: “Filha, a sua fé a curou. Vá em paz!” ");
INSERT INTO porblt_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Enquanto ele falava, alguém veio da casa do líder da sinagoga e lhe disse: “A sua filha morreu. Você não precisa mais incomodar o Mestre.” ");
INSERT INTO porblt_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ao ouvir isso, Jesus disse a Jairo: “Não tenha medo! Se você tiver fé, ela ficará boa.” ");
INSERT INTO porblt_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Quando Jesus chegou na casa, ele permitiu apenas que Pedro, João e Tiago, além dos pais da garota, ficassem lá. Todas as outras pessoas tiveram que sair. ");
INSERT INTO porblt_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Todos que estavam ali choravam e se lamentavam pela menina. Jesus lhes disse: “Não chorem!” “Ela não está morta; a menina está apenas dormindo.” ");
INSERT INTO porblt_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Eles riram dele, pois sabiam que ela havia morrido. ");
INSERT INTO porblt_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mas, Jesus pegou a mão dela e disse em voz alta: “Menina, levante-se!” ");
INSERT INTO porblt_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ela voltou à vida e se levantou de uma vez. Jesus disse aos pais da menina para lhe dar algo para comer. ");
INSERT INTO porblt_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","O pai e a mãe da garota ficaram muito impressionados com o que acontecera, mas, Jesus lhes disse para não contarem a ninguém o que havia acontecido. ");
INSERT INTO porblt_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus reuniu os doze discípulos. Ele lhes deu poder e autoridade para expulsar todos os demônios e a capacidade para curar doenças. ");
INSERT INTO porblt_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Em seguida, ele os enviou para anunciar o Reino de Deus e para curar os doentes. ");
INSERT INTO porblt_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ele lhes disse: “Não levem nada com vocês para a viagem. Nem bengala para se apoiar, nem sacolas, pães, dinheiro, nem mesmo qualquer peça a mais de roupa. ");
INSERT INTO porblt_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Fiquem na casa em que vocês forem recebidos, até irem embora da cidade. ");
INSERT INTO porblt_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Se as pessoas se recusarem a recebê-los, tirem até mesmo o pó daquela cidade que esteja em seus pés. Ao fazer isso, vocês estarão dando um aviso de protesto contra elas.” ");
INSERT INTO porblt_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Os discípulos saíram e viajaram pelas vilas ao redor, anunciando o evangelho e curando em todos os lugares pelos quais eles passavam. ");
INSERT INTO porblt_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes, o tetrarca da Galileia, ouviu tudo que estava acontecendo e ficou muito confuso. Algumas pessoas diziam que João Batista havia ressuscitado. ");
INSERT INTO porblt_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Outras diziam que Elias tinha aparecido. Outras, ainda, que um dos antigos profetas havia ressuscitado. ");
INSERT INTO porblt_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes disse: “Não há dúvida, eu decapitei João. Então, quem é esse homem sobre quem ouço todas essas coisas?” E ele tentou pensar em uma maneira de encontrar Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Quando os apóstolos retornaram, contaram a Jesus tudo o que tinham feito. Em seguida, Jesus e os apóstolos foram para uma cidade chamada Betsaida. ");
INSERT INTO porblt_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","No entanto, a multidão descobriu aonde ele estava indo e o seguiu até lá. Jesus deu as boas-vindas para as pessoas, explicou-lhes sobre o Reino de Deus e também curou os que estavam doentes. ");
INSERT INTO porblt_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mais tarde, naquele mesmo dia, os doze discípulos se aproximaram de Jesus e disseram: “Senhor, mande as pessoas embora, para que possam ir às vilas e aos sítios que ficam perto daqui, para encontrarem algum lugar para ficar e algo para comer. Este lugar é deserto; não há nada por aqui.” ");
INSERT INTO porblt_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesus lhes disse: “Deem a elas algo para comer.” Eles responderam: “Tudo que nós temos são cinco pães e dois peixes, a não ser que o senhor queira que compremos comida para todos.” ");
INSERT INTO porblt_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Havia aproximadamente cinco mil homens lá. Ele disse aos discípulos: “Distribuam as pessoas em grupos de cinquenta.” ");
INSERT INTO porblt_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Eles fizeram como Jesus falou. Todos foram divididos em grupos e se sentaram. ");
INSERT INTO porblt_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesus pegou os cinco pães e os dois peixes e, olhando para o céu, abençoou os alimentos e os dividiu. Ele continuava a passar a comida para os discípulos, enquanto eles a distribuíam para as pessoas. ");
INSERT INTO porblt_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Todos comeram até ficarem satisfeitos, e os discípulos ainda encheram doze cestos com as sobras. ");
INSERT INTO porblt_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Em outra ocasião, quando Jesus estava orando com os seus discípulos a sós, ele lhes perguntou: “Quem todas essas pessoas dizem que eu sou?” ");
INSERT INTO porblt_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Eles responderam: “Alguns dizem que o senhor é João Batista, enquanto outras dizem que é Elias. E há também outras que dizem que é um dos antigos profetas que ressuscitou.” ");
INSERT INTO porblt_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesus perguntou novamente: “Mas, e vocês? Quem vocês dizem que eu sou?” Pedro respondeu: “O Messias enviado por Deus.” ");
INSERT INTO porblt_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesus, então, lhes ordenou que não dissessem isso a ninguém. ");
INSERT INTO porblt_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ele disse: “O Filho do Homem precisará passar por sofrimentos terríveis. Ele será rejeitado pelos anciãos do povo, pelos chefes dos sacerdotes e pelos educadores religiosos. Será morto, mas no terceiro dia ele ressuscitará.” ");
INSERT INTO porblt_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ele disse a todos eles: “Se qualquer um de vocês quiser me seguir, deve negar a si mesmo, pegar a sua cruz todos os dias e me seguir. ");
INSERT INTO porblt_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pois se quiserem salvar a sua vida, vocês a perderão; mas se perderem a sua vida por mim, vocês a salvarão. ");
INSERT INTO porblt_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Qual o benefício em ganhar o mundo todo se, no final, você se perdesse ou fosse destruído? ");
INSERT INTO porblt_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Se a pessoa tiver vergonha de mim ou da minha mensagem, o Filho do Homem também se envergonhará dessa pessoa quando vier em sua glória, na glória do Pai e dos santos anjos. ");
INSERT INTO porblt_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Eu lhes digo que isto é verdade: Alguns que estão aqui não morrerão até que vejam o Reino de Deus.” ");
INSERT INTO porblt_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mais ou menos oito dias depois de dizer essas coisas, Jesus chamou Pedro, João e Tiago e eles subiram ao monte para orar. ");
INSERT INTO porblt_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Enquanto Jesus estava orando, seu rosto mudou de aparência e suas roupas ficaram brancas e brilhantes. ");
INSERT INTO porblt_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Dois homens apareceram envolvidos por um brilho celestial. Eram Moisés e Elias, que começaram a conversar com Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Eles falavam sobre a sua morte que aconteceria em breve em Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro e os outros tinham pegado no sono. Quando acordaram, viram Jesus envolvido por uma luz divina e os dois homens que estavam próximos a ele. ");
INSERT INTO porblt_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Quando os dois homens já estavam quase indo embora, Pedro disse a Jesus: “Mestre, é maravilhoso estar aqui. Deixem-nos fazer três tendas: uma para você, outra para Moisés e uma terceira para Elias.” Pedro realmente não sabia o que estava dizendo. ");
INSERT INTO porblt_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Enquanto ele ainda estava falando, veio uma nuvem e os cobriu. Eles ficaram aterrorizados ao se verem cercados pela nuvem. ");
INSERT INTO porblt_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Uma voz vinda da nuvem disse: “Este é o meu Filho, o Escolhido. Escutem o que ele diz!” ");
INSERT INTO porblt_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Quando a voz parou de falar, Jesus já estava sozinho. Eles guardaram o que tinham visto dentro dos seus corações e, naquela época, não disseram nada a ninguém sobre o que haviam visto. ");
INSERT INTO porblt_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","No dia seguinte, quando eles tinham descido do monte, uma grande multidão esperava para encontrar Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Um homem gritou no meio da multidão: “Mestre, por favor, ajude o meu filho. Ele é o meu único filho! ");
INSERT INTO porblt_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ele está possuído por um espírito que, assim que entra nele, faz com que ele grite. Quando está possuído, ele tem convulsões e espuma pela boca. Dificilmente esse espírito deixa o meu filho em paz e o maltrata muito. ");
INSERT INTO porblt_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Eu implorei aos seus discípulos para expulsarem esse espírito mau, mas eles não conseguiram.” ");
INSERT INTO porblt_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus disse: “Gente má e sem fé! Por quanto tempo precisarei ficar aqui entre vocês e suportá-los?” “Traga o seu filho aqui.” ");
INSERT INTO porblt_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Até mesmo quando estava se aproximando de Jesus, o demônio fez o garoto ter convulsões, jogando-o ao chão. Jesus repreendeu o espírito mau, curou o garoto e o devolveu ao pai. ");
INSERT INTO porblt_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Todos ficaram maravilhados com essa demonstração do poder de Deus. Embora todos estivessem admirados com tudo que Jesus fizera, ele avisou aos seus discípulos: ");
INSERT INTO porblt_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Escutem com atenção o que eu vou lhes dizer: está próximo o momento em que o Filho do Homem será entregue nas mãos dos homens.” ");
INSERT INTO porblt_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Porém, eles não entenderam o que isso significava. O seu significado tinha sido escondido deles, para que não percebessem as suas consequências, e eles, por sua vez, tinham medo de lhe perguntar a respeito disso. ");
INSERT INTO porblt_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Então, começou uma discussão entre os discípulos sobre qual deles era o mais importante. ");
INSERT INTO porblt_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus, sabendo sobre o que eles discutiam, pegou uma criancinha e a colocou próximo a ele. ");
INSERT INTO porblt_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Depois, ele lhes disse: “Quem aceitar esta criancinha em meu nome também estará me aceitando. E quem me aceitar também estará aceitando aquele que me enviou. Aquele entre vocês que for o mais humilde será o mais importante.” ");
INSERT INTO porblt_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","João falou: “Senhor, nós vimos uma pessoa que expulsava demônios em seu nome e nós o proibimos de fazer isso, pois ele não faz parte do nosso grupo.” ");
INSERT INTO porblt_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesus respondeu: “Não o proíbam. Qualquer um que não for contra vocês está a seu favor.” ");
INSERT INTO porblt_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Como o momento dele subir aos céus se aproximava, Jesus estava determinado a ir para Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ele enviou mensageiros a sua frente para uma vila samaritana, para deixar tudo pronto para ele. ");
INSERT INTO porblt_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mas, as pessoas de lá não o receberam bem, pois perceberam que ele estava indo para Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Quando Tiago e João viram isso, disseram: “Senhor, você quer que nós mandemos descer fogo do céu para queimar esta vila?” ");
INSERT INTO porblt_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mas, Jesus se virou e reprovou a atitude dos discípulos. ");
INSERT INTO porblt_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Depois, eles prosseguiram para outra vila. ");
INSERT INTO porblt_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Enquanto eles caminhavam, um homem disse a Jesus: “Eu o seguirei para onde você for.” ");
INSERT INTO porblt_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus disse ao homem: “As raposas têm suas tocas, e os pássaros têm os seus ninhos, mas o Filho do Homem não tem nem mesmo um lugar para descansar.” ");
INSERT INTO porblt_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Então, Jesus disse a outro homem: “Siga-me!” Mas, o homem respondeu: “Senhor, primeiro deixe que eu vá para casa e sepulte o meu pai.” ");
INSERT INTO porblt_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus respondeu: “Deixe que os mortos sepultem os seus próprios mortos. Vá e anuncie o Reino de Deus.” ");
INSERT INTO porblt_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Outro homem disse: “Senhor, eu o seguirei! Porém, primeiro deixe-me ir para casa para me despedir da minha família.” ");
INSERT INTO porblt_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus lhe disse: “Quem começa a arar a terra e depois olha para trás, não serve para o Reino de Deus.” ");
INSERT INTO porblt_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Depois disso, o Senhor nomeou setenta outros discípulos e os enviou em duplas para cada cidade e cada lugar que ele planejava visitar. ");
INSERT INTO porblt_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesus lhes disse: “A colheita é grande, mas são poucos os trabalhadores. Orem para que o Senhor da colheita envie trabalhadores para ajudar na sua lavoura. ");
INSERT INTO porblt_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Então, prossigam em seu caminho: Estou lhes mandando como ovelhas para o meio de lobos. ");
INSERT INTO porblt_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Não levem dinheiro, sacola ou até mesmo um par de sandálias a mais e não percam tempo conversando com as pessoas que encontrarem pelo caminho. ");
INSERT INTO porblt_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","A primeira coisa que dirão ao entrar em uma casa será: ‘Que a paz esteja nesta casa!’ ");
INSERT INTO porblt_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Se lá morar uma pessoa pacífica, então, a paz de vocês ficará neste lar. Mas, se for ao contrário, e a pessoa não for de paz, a sua paz retornará para vocês. ");
INSERT INTO porblt_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Fiquem nessa casa, comendo e bebendo o que lhes derem, pois um trabalhador merece ser pago. Não fiquem mudando de uma casa para a outra. ");
INSERT INTO porblt_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Se vocês entrarem em uma cidade e as pessoas de lá receberem bem vocês, comam o que lhes oferecerem ");
INSERT INTO porblt_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","e curem os seus doentes. Depois, digam para os que vivem lá: ‘O Reino de Deus chegou para vocês.’ ");
INSERT INTO porblt_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Porém, se vocês entrarem em uma cidade e não forem bem recebidos, saiam pelas ruas, dizendo para os moradores de lá: ");
INSERT INTO porblt_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nós estamos limpando até mesmo o pó de sua cidade que grudou em nossos pés, para lhes mostrar a nossa desaprovação. Mas admitam isto: O Reino de Deus chegou para vocês.’ ");
INSERT INTO porblt_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Eu lhes digo que, no Dia do Julgamento, Deus terá mais tolerância com Sodoma do que com aquela cidade. ");
INSERT INTO porblt_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ai de você, Corazim! Ai de você, Betsaida! Pois se os milagres que vocês viram acontecer tivessem acontecido em Tiro e Sidom, as pessoas de lá teriam se arrependido há muito tempo, e elas vestiriam roupas de tecidos grosseiros e se cobririam de cinzas. ");
INSERT INTO porblt_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","É por isso que, no julgamento, Deus será mais tolerante com Tiro e Sidom do que com vocês. ");
INSERT INTO porblt_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","E você, cidade de Cafarnaum? Acha que subirá até o céu? Você será lançada no mundo dos mortos! ");
INSERT INTO porblt_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Quem os ouve também me ouve, e quem os rejeita também me rejeita. Mas, qualquer um que me rejeita também rejeita aquele que me enviou.” ");
INSERT INTO porblt_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Os setenta discípulos voltaram muito animados, dizendo: “Senhor, até mesmo os demônios nos obedecem quando, pelo poder do nome do senhor, ordenávamos que eles saíssem das pessoas!” ");
INSERT INTO porblt_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus respondeu: “Eu vi Satanás cair do céu como um raio. ");
INSERT INTO porblt_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sim, eu lhes dei poder para pisarem em serpentes e escorpiões e para superarem a força de todos os inimigos, e nada lhes fará mal. ");
INSERT INTO porblt_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mas, não fiquem contentes porque os espíritos maus lhes obedecem. Fiquem felizes porque os nomes de vocês estão escritos no céu.” ");
INSERT INTO porblt_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Naquele momento, Jesus foi tomado pela alegria do Espírito Santo e disse: “Agradeço a você, Pai, Senhor do céu e da terra, pois escondeu essas coisas das pessoas sábias e inteligentes, mas as revelou aos pequeninos! Sim, Pai, você ficou feliz ao fazer dessa maneira. ");
INSERT INTO porblt_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","O meu Pai me entregou todas as coisas. Ninguém entende o Filho, a não ser o Pai, e ninguém entende o Pai, a não ser o Filho e aqueles para quem o Filho escolhe mostrar quem o Pai é.” ");
INSERT INTO porblt_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Quando eles estavam sozinhos, Jesus se virou para os discípulos e lhes disse: “Aqueles que veem o que vocês estão vendo deveriam ficar realmente felizes. ");
INSERT INTO porblt_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Eu lhes digo: muitos profetas e reis gostariam de ver o que vocês estão vendo, mas eles não viram. E eles também gostariam de ouvir as coisas que vocês estão ouvindo, mas eles não ouviram.” ");
INSERT INTO porblt_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Certa vez, um especialista na lei religiosa se levantou e, tentando pegar Jesus em uma armadilha, disse: “Mestre, o que eu preciso fazer para conseguir a vida eterna?” ");
INSERT INTO porblt_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus perguntou: “O que está escrito na lei? Como você a interpreta?” ");
INSERT INTO porblt_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","O homem respondeu: “Ame o Senhor, seu Deus, com todo o seu coração e com toda a sua alma, com todas as suas forças e com todos os seus pensamentos. E ame o seu próximo como a si mesmo.” ");
INSERT INTO porblt_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus lhe disse: “Você está certo! Faça isso e você viverá.” ");
INSERT INTO porblt_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mas, o homem querendo se justificar, perguntou a Jesus: “E quem é o meu próximo?” ");
INSERT INTO porblt_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus respondeu: “Um homem estava descendo de Jerusalém para Jericó. Ele foi atacado por ladrões, que roubaram tudo o que ele tinha, bateram nele e o deixaram quase morto. ");
INSERT INTO porblt_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Por coincidência, um sacerdote estava viajando pelo mesmo caminho. Ele viu o homem, mas passou pelo outro lado da estrada. ");
INSERT INTO porblt_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Depois, um levita apareceu. Mas, quando ele chegou ao lugar e viu o homem, também fez questão de passar pelo outro lado da estrada. ");
INSERT INTO porblt_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Finalmente, um samaritano apareceu na estrada. Ao passar, ele viu o homem e sentiu pena dele. ");
INSERT INTO porblt_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ele se aproximou e tratou os ferimentos do homem com óleo e vinho e depois fez curativos. Então, ele levou o homem em seu jumento para uma pensão, onde cuidou dele. ");
INSERT INTO porblt_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","No dia seguinte, deu dois denários para o dono da pensão e lhe disse: ‘Cuide dele e, se você gastar mais do que o dinheiro que deixei, eu lhe pagarei quando voltar.’ ");
INSERT INTO porblt_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Qual desses três homens você acha que foi o próximo para o homem que foi atacado pelos ladrões?” ");
INSERT INTO porblt_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","O especialista em religião respondeu: “Aquele que o ajudou.” Jesus, então, disse-lhe: “Vá e faça o mesmo!” ");
INSERT INTO porblt_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Continuando sua jornada, Jesus chegou a uma vila, e uma mulher, chamada Marta, convidou-o para a sua casa. ");
INSERT INTO porblt_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tinha ela uma irmã chamada Maria, que se sentou aos pés do Senhor e ouviu os seus ensinamentos. ");
INSERT INTO porblt_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta ficou preocupada com tudo que precisava ser feito para a preparação da refeição. Então, veio até Jesus e lhe disse: “Mestre, você não se importa de minha irmã ter deixado todo o serviço da casa para que eu fizesse sozinha? Diga a ela para vir e me ajudar!” ");
INSERT INTO porblt_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","O Senhor respondeu: “Marta, Marta, você está preocupada e agitada com muitas coisas! ");
INSERT INTO porblt_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mas, apenas uma coisa é realmente necessária. Maria escolheu a melhor de todas, e esta não será tirada dela.” ");
INSERT INTO porblt_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Certa vez, Jesus estava orando em um determinado lugar. Quando ele terminou, um dos seus discípulos lhe pediu: “Senhor, por favor, ensine-nos a orar, como João Batista ensinou aos seus discípulos.” ");
INSERT INTO porblt_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesus lhes disse: “Quando vocês orarem, digam: ‘Pai, que o seu nome seja reconhecido como santo. Venha o seu Reino. ");
INSERT INTO porblt_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dá-nos cada dia o alimento que precisamos. ");
INSERT INTO porblt_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Perdoa-nos os nossos pecados, assim como perdoamos aos que nos têm ofendido. E não nos deixe cair em tentação.’” ");
INSERT INTO porblt_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesus continuou a lhes dizer: “Digamos que você tenha um amigo e que, no meio da noite, você vá à casa dele e lhe diga: ‘Meu amigo, empreste-me três pães, ");
INSERT INTO porblt_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","pois um amigo meu veio me visitar e eu não tenho nada para lhe oferecer.’ ");
INSERT INTO porblt_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Talvez, o seu amigo lá de dentro responda: ‘Não me incomode. Eu já tranquei a porta. Os meus filhos e eu já estamos deitados. Eu não vou me levantar para lhe dar nada agora.’ ");
INSERT INTO porblt_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Eu lhes digo: mesmo que ele se recuse a se levantar e lhe dar o pão, apesar de você ser seu amigo, se você for persistente, o seu amigo se levantará e lhe dará tudo o que você precisa. ");
INSERT INTO porblt_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Eu lhes digo: peçam, e vocês receberão; procurem, e vocês encontrarão; batam, e a porta se abrirá para vocês. ");
INSERT INTO porblt_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pois, todo o que pede recebe; todo o que procura acha; e para todo o que bate a porta se abrirá. ");
INSERT INTO porblt_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Qual de vocês, pais, se o seu filho lhe pedir um peixe, em lugar disso lhe dará uma cobra? ");
INSERT INTO porblt_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ou, se ele pedir um ovo, lhe dará um escorpião? ");
INSERT INTO porblt_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Então, se vocês, mesmo sendo maus, ainda sabem dar boas coisas para os seus filhos, quanto mais o Pai celestial dará o Espírito Santo para quem lhe pedir!” ");
INSERT INTO porblt_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus estava expulsando um demônio que tinha feito com que um homem ficasse mudo. Quando o demônio saiu, o mudo falou, e todos que estavam vendo ficaram admirados. ");
INSERT INTO porblt_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mas, alguns disseram: “Ele expulsa os demônios usando o poder de Belzebu, o chefe dos demônios.” ");
INSERT INTO porblt_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Outros procuravam testar Jesus, pedindo que ele fizesse um milagre, para mostrar que seu poder vinha de Deus. ");
INSERT INTO porblt_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesus sabia o que eles estavam pensando e disse: “Qualquer reino em que os cidadãos lutam entre si será destruído. Uma família em que seus membros lutam entre si também será destruída. ");
INSERT INTO porblt_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Se Satanás luta contra si mesmo, como pode o seu reino continuar a existir? Vocês dizem que eu expulso demônios usando o poder de Belzebu. ");
INSERT INTO porblt_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mas, se eu os expulso pelo poder de Belzebu, pelo poder de quem a sua própria gente os expulsa? Eles mesmos serão a prova de que vocês estão errados. ");
INSERT INTO porblt_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","No entanto, se eu estou expulsando demônios pelo poder de Deus, então, isso prova que o Reino de Deus chegou. Está aqui mesmo entre vocês! ");
INSERT INTO porblt_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Quando um homem forte, que está bem armado, vigia sua casa, tudo o que ele tem está a salvo. ");
INSERT INTO porblt_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mas, se um homem mais forte ainda vier e o vencer, tirando dele todas as armas das quais ele depende para a sua proteção, então, ele conseguirá levar tudo o que o dono da casa tem. ");
INSERT INTO porblt_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Assim, todos que não estão comigo estão contra mim, e todos que não constroem comigo estão destruindo. ");
INSERT INTO porblt_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Quando um espírito mau é expulso de alguém, ele vai direto para o deserto, procurando um lugar para ficar. Quando não consegue encontrar um lugar, ele diz: ‘Eu irei voltar para a casa da qual saí.’ ");
INSERT INTO porblt_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Quando ele volta, encontra sua antiga casa limpa e arrumada. ");
INSERT INTO porblt_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Então, ele sai e encontra mais outros sete espíritos, ainda piores do que ele, e todos ficam morando ali. No final, a situação desse homem fica ainda pior do que antes.” ");
INSERT INTO porblt_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Enquanto Jesus falava, uma mulher, no meio da multidão, gritou: “Abençoada é a mulher que pôs você no mundo e o amamentou!” ");
INSERT INTO porblt_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mas Jesus disse: “Ainda mais abençoados são aqueles que ouvem a palavra de Deus e fazem como ela diz!” ");
INSERT INTO porblt_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Quando as pessoas começaram a se juntar em volta de Jesus, ele lhes disse: “Esta é uma geração de pessoas más, pois procuram algum sinal milagroso, mas nenhum sinal será dado a eles, a não ser o sinal de Jonas. ");
INSERT INTO porblt_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Da mesma maneira que Jonas foi um sinal para o povo de Nínive, o Filho do Homem também será um sinal para esta geração. ");
INSERT INTO porblt_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","No julgamento, a rainha do Sul se levantará contra o povo desta geração e o condenará, pois ela veio de muito longe para ouvir os sábios ensinamentos de Salomão. E, agora, há aqui alguém ainda mais importante do que Salomão. ");
INSERT INTO porblt_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","No julgamento, o povo de Nínive se levantará contra as pessoas desta geração e as condenará, pois eles se arrependeram dos seus pecados, quando ouviram a mensagem de Jonas. E agora, há alguém aqui que é mais importante do que Jonas. ");
INSERT INTO porblt_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ninguém acende um lampião e depois o esconde ou o coloca debaixo de um cesto. Não, o lampião deve ser colocado no velador, para que aqueles que entram na casa possam ver a luz. ");
INSERT INTO porblt_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Os olhos são como uma luz para o corpo. Quando os seus olhos são bons, todo o seu corpo fica cheio de luz. Mas, quando os seus olhos são ruins, então, o seu corpo está nas trevas. ");
INSERT INTO porblt_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Então, tenha cuidado para que a luz que está dentro de você não seja, na verdade, trevas. ");
INSERT INTO porblt_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Se todo o seu corpo estiver cheio de luz, sem nenhuma parte escura, então, ele estará completamente iluminado, exatamente como acontece quando você é iluminado pela luz de um lampião.” ");
INSERT INTO porblt_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Após Jesus terminar de falar, um fariseu o convidou para comer com ele. Assim, Jesus foi e se sentou para comer. ");
INSERT INTO porblt_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","O fariseu ficou surpreso por Jesus não lavar as mãos antes de comer, como era cerimonialmente exigido. ");
INSERT INTO porblt_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Então, o Senhor lhe disse: “Vocês, fariseus, limpam a parte de fora do copo e do prato, mas, por dentro vocês estão cheios de ganância e maldade. ");
INSERT INTO porblt_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Seus tolos! Vocês não acham que aquele que fez a parte de dentro também fez a parte de fora? ");
INSERT INTO porblt_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Portanto, deem aos pobres o que está dentro do copo e do prato. Então, ao agirem assim, tudo ficará limpo para vocês. ");
INSERT INTO porblt_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ai de vocês, fariseus! Vocês pagam o dízimo sobre ervas e verduras, mas negligencia a justiça e o amor de Deus. Vocês precisam prestar atenção a essas coisas, mas não devem se esquecer de cumprir também as outras. ");
INSERT INTO porblt_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ai de vocês, fariseus! Vocês gostam de ter os melhores lugares nas sinagogas e de serem cumprimentados com respeito, quando estão nas praças dos mercados. ");
INSERT INTO porblt_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ai de vocês, que são como túmulos sem identificação, sobre os quais as pessoas andam sem nem perceberem!” ");
INSERT INTO porblt_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Um dos especialistas na lei religiosa reagiu, dizendo: “Mestre, quando você fala assim, também nos insulta!” ");
INSERT INTO porblt_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus respondeu: “Ai de vocês também, especialistas na lei! Vocês colocam sobre as pessoas cargas muito pesadas para serem carregadas, mas não levantam um único dedo para ajudá-las. ");
INSERT INTO porblt_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ai de vocês, que constroem túmulos para homenagear os profetas, mas foram os seus próprios antepassados que os mataram! ");
INSERT INTO porblt_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Assim, vocês mostram que concordam com o que os seus antepassados fizeram. Eles mataram os profetas, e vocês constroem túmulos para eles! ");
INSERT INTO porblt_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","É por isso que Deus, em toda a sua sabedoria, disse: ‘Enviarei profetas e apóstolos para eles. Alguns, eles matarão. Outros, eles perseguirão.’ ");
INSERT INTO porblt_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Por isso, esta geração de pessoas será culpada pelo sangue de todos os profetas que foi derramado desde o princípio do mundo; ");
INSERT INTO porblt_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","desde o sangue de Abel até o sangue de Zacarias, que foi assassinado entre o altar e o santuário. Sim, eu lhes digo: esta geração será culpada por tudo isso. ");
INSERT INTO porblt_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ai de vocês, especialistas na lei! Vocês guardaram a chave do conhecimento. Vocês mesmos não entram e também não deixam que os outros entrem.” ");
INSERT INTO porblt_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Enquanto Jesus estava saindo, os educadores religiosos e os fariseus começaram a atacá-lo agressivamente, fazendo todo tipo de perguntas para provocá-lo. ");
INSERT INTO porblt_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Eles estavam esperando uma oportunidade de pegá-lo, tentando fazer com que ele dissesse algo que pudesse ser usado contra ele. ");
INSERT INTO porblt_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nesse meio tempo, milhares de pessoas se ajuntaram, de tal modo que elas pisavam umas nas outras. Jesus falou primeiro aos seus discípulos: “Tenham cuidado com o fermento dos fariseus, ou seja, com a falsidade deles. ");
INSERT INTO porblt_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pois tudo que está escondido será revelado. Tudo que estiver em segredo será conhecido. ");
INSERT INTO porblt_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tudo o que vocês disseram na escuridão será ouvido na luz do dia. E tudo o que vocês disseram em segredo será anunciado aos quatro cantos da terra. ");
INSERT INTO porblt_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Eu lhes digo, meus amigos, não tenham medo daqueles que matam o corpo, pois uma vez que tenham feito isso, não há mais nada que eles possam fazer. ");
INSERT INTO porblt_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Deixem-me dizer de quem vocês devem ter medo: vocês devem temer aquele que, depois de ter matado, ainda tem o poder de lançá-los na Geena. É dele que vocês devem ter medo. ");
INSERT INTO porblt_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Não é verdade que cinco passarinhos são vendidos por alguns centavos? Mas, Deus não se esquece de nenhum deles. ");
INSERT INTO porblt_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Até os cabelos da cabeça de vocês foram contados. Não tenham medo! Vocês valem mais do que muitos passarinhos. ");
INSERT INTO porblt_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Eu lhes digo que isto é verdade: aqueles que disserem publicamente que pertencem a mim, o Filho do Homem também irá dizer, diante dos anjos de Deus, que essas pessoas pertencem a ele. ");
INSERT INTO porblt_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mas, aqueles que me negarem também serão negados por mim diante dos anjos de Deus. ");
INSERT INTO porblt_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Qualquer um que falar contra o Filho do Homem será perdoado, mas quem disser blasfêmias contra o Espírito Santo não será perdoado. ");
INSERT INTO porblt_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Quando vocês forem levados para serem julgados nas sinagogas, e diante de governantes e de autoridades, não se preocupem como irão se defender ou com o que irão dizer. ");
INSERT INTO porblt_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","O Espírito Santo lhes ensinará, naquela mesma hora, o que devem dizer.” ");
INSERT INTO porblt_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Alguém que estava na multidão disse a Jesus: “Mestre, por favor, diga ao meu irmão para dividir a herança comigo.” ");
INSERT INTO porblt_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesus respondeu: “Homem, quem me indicou como seu juiz para decidir como a sua herança deve ser dividida?” Ele disse às pessoas: ");
INSERT INTO porblt_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","“Prestem atenção! Tenham cuidado com todos os pensamentos e com todas as ações mesquinhas, pois a vida de uma pessoa não se resume a todas as coisas que ela possui.” ");
INSERT INTO porblt_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Então, ele contou para a multidão uma história como exemplo. “Certa vez, havia um homem rico que possuía terras muito produtivas. ");
INSERT INTO porblt_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","O homem pensou: ‘O que eu devo fazer? Eu não tenho onde guardar a minha colheita.’ ");
INSERT INTO porblt_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ele, então, decidiu: ‘Eu sei o que farei: vou derrubar os meus depósitos e construirei outros depósitos de cereais maiores ainda. Assim, eu terei espaço para guardar toda a minha colheita e também tudo o que possuo. ");
INSERT INTO porblt_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Depois, direi a mim mesmo: Você já tem riquezas o bastante para viver por muitos anos. Então, relaxe, coma, beba e aproveite!’ ");
INSERT INTO porblt_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mas, Deus lhe disse: ‘Você é um homem tolo! Nesta mesma noite, você morrerá e, aí, quem ficará com tudo que você guardou?’ ");
INSERT INTO porblt_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","É isso o que acontece com as pessoas que acumulam riquezas para si, mas não são ricas no que diz respeito a Deus.” ");
INSERT INTO porblt_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesus disse aos seus discípulos: “É por isso que eu lhes digo: não se preocupem com a vida, com o que comer ou com o que vestir. ");
INSERT INTO porblt_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A vida é bem mais do que apenas a comida, e o corpo é bem mais do que apenas vestir roupas. ");
INSERT INTO porblt_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Vejam os corvos. Eles não semeiam nem colhem, não têm despensas ou depósitos, mas Deus os alimenta. E vocês são mais valiosos do que os pássaros. ");
INSERT INTO porblt_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Vocês podem acrescentar uma hora a mais em sua vida, por mais que se preocupem com isso? ");
INSERT INTO porblt_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Se vocês não podem fazer nada em relação a uma coisa pequena como essa, então, por que se preocupar com o resto? ");
INSERT INTO porblt_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pensem nos lírios e em como eles crescem. Eles não trabalham e nem tecem os fios para fazerem roupas. Mas, eu lhes digo que nem mesmo Salomão, em toda a sua glória, se vestiu de forma tão bela quanto qualquer um deles. ");
INSERT INTO porblt_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Assim, se Deus veste a erva, que hoje está no campo, mas que amanhã é lançada no forno, muito mais irá vesti-los, vocês que têm fé tão pequena. ");
INSERT INTO porblt_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Não se preocupem com o que irão comer ou beber. Não se preocupem com isso. ");
INSERT INTO porblt_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Todas essas são coisas com que as pessoas no mundo se preocupam, mas o seu Pai sabe que vocês precisam delas. ");
INSERT INTO porblt_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Busquem primeiro o Reino de Deus, e vocês receberão as demais coisas. ");
INSERT INTO porblt_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Não tenha medo, pequeno rebanho, pois o seu Pai tem prazer em lhe dar o Reino. ");
INSERT INTO porblt_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Vendam o que vocês têm e deem o dinheiro aos pobres. Consigam para si mesmos bolsas que não se estragam: um tesouro no céu, que nunca irá acabar, onde nenhum ladrão poderá roubá-lo e nem as traças poderão destruí-lo. ");
INSERT INTO porblt_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pois o que vocês mais valorizam é o que realmente mostra quem vocês são. ");
INSERT INTO porblt_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Estejam vestidos e prontos e deixem seus lampiões acesos. ");
INSERT INTO porblt_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Sejam como os empregados que esperam pela volta do seu patrão depois da festa de casamento. Eles já estão preparados para abrir a porta assim que ele chegar e bater. ");
INSERT INTO porblt_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Felizes os empregados que o patrão encontra preparados quando ele chega. Eu lhes digo que isto é verdade: ele se vestirá, fará com que eles se sentem para comer e ele mesmo servirá seus empregados. ");
INSERT INTO porblt_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mesmo se ele chegar à meia-noite, ou mais tarde, felizes dos empregados se ele os encontrar alerta e prontos! ");
INSERT INTO porblt_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mas, lembrem-se disto: se o dono da casa soubesse quando um ladrão chegaria, ele ficaria vigiando e não deixaria que a sua casa fosse invadida. ");
INSERT INTO porblt_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Vocês também devem estar preparados, pois o Filho do Homem virá quando não estiverem esperando por ele.” ");
INSERT INTO porblt_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","“Você está contando essa história apenas para nós, ou é para todos?”, Pedro perguntou. ");
INSERT INTO porblt_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","O Senhor respondeu: “Então, quem é o administrador confiável e sábio, que o patrão coloca como responsável na casa, para distribuir a comida para os outros empregados na hora certa? ");
INSERT INTO porblt_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Feliz desse empregado quando o seu patrão voltar e descobrir que ele cumpriu tudo como deveria ser. ");
INSERT INTO porblt_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Eu lhes digo que isto é verdade: o patrão deixará esse empregado como o responsável por tudo. ");
INSERT INTO porblt_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mas, e se o empregado pensar: ‘Meu patrão está demorando para voltar.’ E então, ele começar a bater nos outros empregados, tantos nos homens quanto nas mulheres, e passar a comer e beber até ficar bêbado? ");
INSERT INTO porblt_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Um dia, o patrão desse empregado chegará de repente e ele não saberá. O patrão o punirá duramente e o condenará a ir para o lugar onde estão os desobedientes. ");
INSERT INTO porblt_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","O empregado que sabia qual era a vontade do seu patrão e, ainda assim, não se aprontou, ou não seguiu as instruções dele, será castigado com dureza. ");
INSERT INTO porblt_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mas, o empregado que não sabia e fez coisas que mereciam punição será punido apenas levemente. Para quem muito foi dado, muito será exigido. E para quem foi confiado mais, mais será pedido. ");
INSERT INTO porblt_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Eu vim para pôr fogo na terra e como seria bom se já estivesse queimando! ");
INSERT INTO porblt_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mas, eu preciso primeiro passar por um batismo, e como estou agoniado esperando por isso! ");
INSERT INTO porblt_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Vocês acham que eu vim trazer paz à terra? Não, eu lhes digo que trago a divisão. ");
INSERT INTO porblt_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","A partir de agora, se houver cinco pessoas em uma família, elas ficarão divididas: três contra duas e duas contra três. ");
INSERT INTO porblt_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pais ficarão contra os filhos e os filhos contra os pais. As mães contra as filhas e as filhas contra as mães. As sogras contra as noras e as noras contra as sogras.” ");
INSERT INTO porblt_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Então, Jesus falou para a multidão: “Quando vocês veem uma nuvem subindo no oeste, imediatamente dizem: ‘Vai chover.’ E isso realmente acontece. ");
INSERT INTO porblt_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","E quando sopra o vento sul, vocês dizem: ‘Irá fazer calor.’ E isso acontece. ");
INSERT INTO porblt_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hipócritas! Como é que vocês sabem interpretar com tanta certeza se vai fazer calor ou chover, mas não sabem como interpretar a época atual? ");
INSERT INTO porblt_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Por que vocês não pensam por si mesmos e julgam o que é o certo a ser feito? ");
INSERT INTO porblt_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Quando vocês estiverem indo para o tribunal com quem os acusou, tentem fazer um acordo com essa pessoa antes do julgamento. Caso contrário, vocês podem ser levados a um juiz, o juiz pode entregá-los ao guarda e o guarda pode jogá-los na prisão. ");
INSERT INTO porblt_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Eu lhes digo que vocês não irão sair da prisão enquanto não pagarem até o último centavo da dívida.” ");
INSERT INTO porblt_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mais ou menos naquele momento, algumas pessoas disseram a Jesus como Pilatos matara alguns galileus, enquanto eles ofereciam sacrifícios no Templo. ");
INSERT INTO porblt_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","“Vocês acham que esses galileus eram mais pecadores do que quaisquer outros, porque eles morreram desse jeito?” Jesus perguntou. ");
INSERT INTO porblt_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","“Eu lhes digo que não. Mas, a menos que vocês se arrependam, todos irão morrer também. ");
INSERT INTO porblt_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","E aquelas dezoito pessoas que morreram quando a torre em Siloé caiu sobre elas? Vocês acham que elas eram as piores pessoas em toda a Jerusalém? ");
INSERT INTO porblt_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Eu lhes digo que não. Porém, a não ser que vocês se arrependam, todos irão morrer também.” ");
INSERT INTO porblt_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Então, Jesus lhes contou esta história como exemplo: “Havia um homem que tinha uma figueira em sua plantação de uvas. Ele chegou, procurando frutos na árvore, mas não encontrou nenhum. ");
INSERT INTO porblt_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Então, disse ao jardineiro: ‘Veja! Durante três anos eu venho procurar algum fruto nesta figueira e não encontro nenhum. Corte esta árvore! Por que ela deveria ocupar espaço na minha plantação?’ ");
INSERT INTO porblt_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","O jardineiro respondeu: ‘Patrão, por favor, deixe a figueira aí apenas por mais um ano. Eu irei cavar a terra em volta dela e colocarei fertilizante. ");
INSERT INTO porblt_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Se ela produzir frutos, então, muito bem. Se não, então, mande cortá-la.’” ");
INSERT INTO porblt_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Um sábado, Jesus estava ensinando em uma sinagoga. ");
INSERT INTO porblt_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Havia ali uma mulher que fazia dezoito anos que se encontrava doente por causa de um espírito mau. Ela ficava curvada e não conseguia se endireitar. ");
INSERT INTO porblt_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Quando Jesus a viu, chamou-a e disse: “Você está curada da sua doença.” ");
INSERT INTO porblt_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Depois, ele colocou as suas mãos sobre ela e, imediatamente, a mulher se endireitou e louvou a Deus. ");
INSERT INTO porblt_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","No entanto, o líder da sinagoga ficou chocado por Jesus ter curado em um sábado. Ele disse para a multidão: “Há seis dias dedicados ao trabalho. Venham e sejam curados nesses dias e não no sábado.” ");
INSERT INTO porblt_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mas o Senhor disse para o líder: “Hipócritas! Qualquer um de vocês não desamarra, no sábado, seu boi ou jumento do estábulo e o leva para beber água? ");
INSERT INTO porblt_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Por que essa mulher, uma descendente de Abraão, que Satanás manteve amarrada por dezoito anos, não deveria ser desamarrada e libertada neste dia de sábado?” ");
INSERT INTO porblt_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","O que Jesus disse envergonhou todos os seus opositores. Mas, todos na multidão estavam muito felizes com todas as coisas maravilhosas que ele estava fazendo. ");
INSERT INTO porblt_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Depois, Jesus perguntou: “Então, com o que se parece o Reino de Deus? Com o que eu poderia compará-lo? ");
INSERT INTO porblt_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","É como uma semente de mostarda que um homem plantou em seu jardim. Ela cresceu e virou uma árvore. Os pássaros, então, vieram e fizeram ninhos em seus galhos.” ");
INSERT INTO porblt_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ele perguntou novamente: “Com o que eu posso comparar o Reino de Deus? ");
INSERT INTO porblt_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","É como o fermento que uma mulher pegou e misturou em três medidas de farinha e que fez com que toda a massa crescesse.” ");
INSERT INTO porblt_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus percorreu as cidades e vilas em volta, ensinando em seu caminho para Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Alguém lhe perguntou: “Senhor, apenas poucos serão salvos?” Jesus respondeu: ");
INSERT INTO porblt_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Tentem de todas as maneiras entrar pela porta estreita, pois, eu lhes digo que muitos tentarão entrar e não conseguirão. ");
INSERT INTO porblt_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Uma vez que o dono da casa se levante e feche a porta, vocês ficarão do lado de fora, batendo na porta e dizendo: ‘Senhor, por favor, abra a porta para nós!’ Mas, ele responderá: ‘Eu não conheço vocês e não sei de onde vocês são.’ ");
INSERT INTO porblt_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Então, vocês dirão: ‘Mas, nós comemos e bebemos com você. E você ensinou nas ruas da nossa cidade.’ ");
INSERT INTO porblt_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ele responderá: ‘Eu lhes digo que não conheço vocês e não sei de onde vocês são. Saiam de perto de mim, todos vocês que não fazem o bem.’ ");
INSERT INTO porblt_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Haverá choro e ranger de dentes quando vocês virem Abraão, Isaque, Jacó e todos os profetas no Reino de Deus, e vocês, do lado de fora. ");
INSERT INTO porblt_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","As pessoas virão do leste e do oeste, do norte e do sul, e se sentarão para comer no Reino de Deus. ");
INSERT INTO porblt_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pois, os últimos serão os primeiros, e os primeiros serão os últimos.” ");
INSERT INTO porblt_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nesse momento, alguns fariseus vieram até Jesus e lhe disseram: “Você deveria ir embora daqui, porque Herodes quer matá-lo.” ");
INSERT INTO porblt_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus respondeu: “Vão e digam para aquela raposa que eu continuarei a expulsar demônios e a curar pessoas hoje e amanhã. E no terceiro dia eu terminarei o que vim fazer. ");
INSERT INTO porblt_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bem, de qualquer forma, eu devo seguir o meu caminho hoje e amanhã e depois de amanhã também. Pois, não seria certo para um profeta morrer fora de Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalém, Jerusalém, que mata os profetas e apedreja aqueles que Deus envia para você! Por quantas vezes eu tentei reunir todos os seus filhos, exatamente como uma galinha faz com os seus pintinhos, quando os coloca debaixo de suas asas. Mas, vocês recusaram todas as vezes. ");
INSERT INTO porblt_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Vejam! A casa de vocês ficará abandonada. E eu lhes digo que vocês não me verão até o dia em que disserem: ‘Abençoado aquele que vem em nome do Senhor!’” ");
INSERT INTO porblt_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Em um sábado, Jesus foi comer na casa de um dos líderes dos fariseus, onde todos o observavam muito atentamente. ");
INSERT INTO porblt_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Havia um homem lá com os braços e as pernas inchados. ");
INSERT INTO porblt_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Então, Jesus perguntou aos especialistas na lei religiosa e aos fariseus: “A lei permite curar no sábado ou não?” ");
INSERT INTO porblt_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mas, eles ficaram quietos. Jesus tocou no homem, curou-o e o mandou embora. ");
INSERT INTO porblt_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Depois, Jesus lhes disse: “Se o seu filho ou o seu boi caísse em um poço no sábado, vocês não o tirariam de lá imediatamente?” ");
INSERT INTO porblt_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Eles não foram capazes de responder a Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Então, ao notar como os convidados tinham escolhido sentar nos lugares de honra, ele contou uma história para eles. E, assim, ele começou: ");
INSERT INTO porblt_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Quando você for convidado para uma festa de casamento, não escolha o lugar de honra, pois pode ser que alguém mais importante do que você tenha sido convidado. ");
INSERT INTO porblt_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","A pessoa que convidou os dois para a festa virá e lhe dirá: ‘Dê o seu lugar para este homem se sentar.’ Então, muito constrangido, você terá que sair desse lugar para se sentar em qualquer outro que tenha sobrado. ");
INSERT INTO porblt_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Em vez disso, quando você for convidado, sente-se no lugar menos importante, para que aquele que o convidou venha até você e diga: ‘Meu amigo, por favor, sente-se em um lugar melhor.’ Assim, você se sentirá honrado diante de todos os convidados. ");
INSERT INTO porblt_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pois, aqueles que se engrandecem serão humilhados, mas aqueles que se humilham serão engrandecidos.” ");
INSERT INTO porblt_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Em seguida, ele disse ao homem que o havia convidado: “Quando você oferecer um almoço ou um jantar, não convide os seus amigos, irmãos, parentes ou os seus vizinhos ricos, pois eles podem convidá-lo novamente e, assim, você seria recompensado. ");
INSERT INTO porblt_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Em vez disso, quando você der um banquete, convide os pobres, os deficientes, os mancos e os cegos, ");
INSERT INTO porblt_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","e você será abençoado, pois eles não têm nada para lhe dar em recompensa, e você será pago quando os que fazem o bem ressuscitarem.” ");
INSERT INTO porblt_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Quando um deles, que comia na mesa com Jesus, ouviu isso, disse a ele: “Como será maravilhoso para aqueles que irão sentar-se à mesa no Reino de Deus!” ");
INSERT INTO porblt_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesus respondeu; “Certa vez um homem preparou um grande banquete e convidou muita gente. ");
INSERT INTO porblt_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Quando chegou a hora de comer, enviou o seu empregado para dizer a todos os convidados: ‘Venham, pois o banquete está pronto!’ ");
INSERT INTO porblt_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mas, todos eles começaram a dar desculpas. O primeiro disse: ‘Comprei umas terras há pouco tempo e preciso ir vê-las. Por favor, desculpe-me!’ ");
INSERT INTO porblt_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Outro disse: ‘Acabei de comprar dez bois e preciso ver como eles trabalham. Por favor, desculpe-me!’ Ainda outro deu a seguinte desculpa: ");
INSERT INTO porblt_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","‘Casei-me há pouco, então, não poderei ir.’ ");
INSERT INTO porblt_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","O empregado voltou e contou ao seu patrão o que eles lhe tinham dito. O dono da casa ficou furioso e disse ao empregado: ‘Rápido! Saia pelas ruas e pelos becos da cidade e traga os pobres, os deficientes, os cegos e os mancos.’ ");
INSERT INTO porblt_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Então, o empregado disse: ‘Senhor, fiz o que você me disse para fazer, mas ainda há lugares que estão vazios.’ ");
INSERT INTO porblt_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Então, o patrão disse ao empregado: ‘Vá pelas estradas e pelos caminhos rurais e convide a todos. Eu quero que a minha casa fique completamente cheia. ");
INSERT INTO porblt_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pois eu lhe digo que ninguém que eu tenha convidado antes provará o meu banquete.’” ");
INSERT INTO porblt_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Grande multidões acompanhavam Jesus. Ele se virou para eles e disse: ");
INSERT INTO porblt_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Se vocês querem me seguir, e não me amar mais do que ama o seu pai e a sua mãe, a sua esposa e os seus filhos, os seus irmãos e as suas irmãs, e até mesmo a sua própria vida, vocês não podem ser meus discípulos. ");
INSERT INTO porblt_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Se não carregarem a sua cruz e me seguirem, não poderão ser meus discípulos. ");
INSERT INTO porblt_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Se planejarem construir uma torre, vocês primeiro não precisam saber quanto isso custará, e ver se terão dinheiro o bastante para pagar pela construção? ");
INSERT INTO porblt_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Caso contrário, se após colocarem o alicerce, vocês não forem capazes de terminá-la, todos que virem isso irão rir de vocês, dizendo: ");
INSERT INTO porblt_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Olhem! Ele começou a construir, mas não teve dinheiro suficiente para terminar.’ ");
INSERT INTO porblt_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Que rei entra em guerra com outro rei sem primeiro sentar e consultar os seus conselheiros, para descobrir se ele e os seus dez mil homens podem vencer o seu oponente que marcha contra ele com os seus vinte mil homens? ");
INSERT INTO porblt_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Se ele não puder vencer, enviará representantes para pedir um acordo de paz, enquanto o outro rei ainda estiver longe o bastante. ");
INSERT INTO porblt_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Da mesma maneira, nenhum de vocês pode ser meu discípulo sem antes abrir mão de tudo o que tem. ");
INSERT INTO porblt_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","O sal é bom, mas se ele perder o sabor, o que vocês poderão fazer para que ele volte a salgar os alimentos? ");
INSERT INTO porblt_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ele não é bom nem para a terra e nem para ser usado como fertilizante. Ele é simplesmente jogado fora. Aquele que tem ouvidos, que ouça!” ");
INSERT INTO porblt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Era comum os cobradores de impostos e outras pessoas de má fama virem para escutar o que Jesus tinha a dizer. ");
INSERT INTO porblt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Por causa disso, os fariseus e os educadores religiosos reclamaram: “Este homem recebe bem pessoas de má fama e até mesmo come com elas.” ");
INSERT INTO porblt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Então, Jesus usou uma história para servir como exemplo a eles: ");
INSERT INTO porblt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Imaginem que um homem tenha cem ovelhas e perde uma delas. Ele não deixa as noventa e nove no campo e procura a que se perdeu até encontrá-la? ");
INSERT INTO porblt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Quando ele a encontra, a coloca alegremente em seus ombros, para levá-la de volta. ");
INSERT INTO porblt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Quando ele chega em casa, reúne os seus amigos e os seus vizinhos e diz: ‘Venham comemorar comigo! Eu achei a minha ovelha perdida.’ ");
INSERT INTO porblt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Eu lhes digo que há mais alegria no céu por um pecador que se arrepende do que por noventa e nove pessoas boas que não precisam se arrepender. ");
INSERT INTO porblt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ou, pensem em uma mulher com dez moedas de prata que perdesse uma delas. Ela não acenderia um lampião e varreria a casa com muito cuidado até encontrar a moeda? ");
INSERT INTO porblt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Quando a encontrasse, ela reuniria seus amigos e seus vizinhos e diria: ‘Venham comemorar comigo! Eu achei a moeda de prata que tinha perdido.’ ");
INSERT INTO porblt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Eu lhes digo que há alegria na presença dos anjos de Deus por um pecador que se arrepende. ");
INSERT INTO porblt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesus continuou: Certo homem tinha dois filhos. ");
INSERT INTO porblt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","O mais jovem disse ao seu pai: ‘Pai, eu quero a minha parte da herança agora.’ Então, o homem dividiu os seus bens entre os filhos. ");
INSERT INTO porblt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Alguns dias depois, o filho mais novo juntou tudo o que ele tinha e foi para um país distante. Lá, ele perdeu todo o seu dinheiro, vivendo de uma forma irresponsável. ");
INSERT INTO porblt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Depois que ele gastou tudo, o país em que ele estava foi atingido por uma severa falta de alimentos e ele estava faminto. ");
INSERT INTO porblt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Então, ele arranjou um trabalho com um dos donos de terra de lá, que o mandou para os seus campos para alimentar os porcos. ");
INSERT INTO porblt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ele estava com tanta fome que comeria até mesmo a comida dos porcos, mas ninguém lhe deu nada para comer. ");
INSERT INTO porblt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Quando ele caiu em si, pensou: ‘Todos os trabalhadores do meu pai têm o bastante para comer. Então, por que eu estou morrendo de fome aqui? ");
INSERT INTO porblt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Eu irei voltar para a casa do meu pai, e lhe direi: Pai, eu pequei contra o céu e contra você. ");
INSERT INTO porblt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Eu não mereço mais ser chamado de filho por você. Por favor, trate-me como um dos seus empregados contratados.’ ");
INSERT INTO porblt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Assim, ele voltou para a casa do seu pai. Embora ele ainda estivesse longe, seu pai o viu chegando e seu coração se encheu de compaixão por seu filho. Ele correu para encontrar seu filho, abraçou-o e o beijou. ");
INSERT INTO porblt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","O filho lhe disse: ‘Pai, eu pequei contra o céu e contra você. Eu não mereço mais ser chamado de filho por você.’ ");
INSERT INTO porblt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mas, o pai disse aos seus empregados: ‘Rápido! Tragam a melhor roupa e vistam nele. Ponham um anel em seu dedo e sandálias em seus pés. ");
INSERT INTO porblt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tragam o bezerro que estivemos engordando e matem-no. Vamos fazer uma festa para comemorar. ");
INSERT INTO porblt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Pois, este meu filho estava morto, mas retornou vivo. Ele estava perdido, mas, agora, foi encontrado.’ Então, eles começaram a comemorar. ");
INSERT INTO porblt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Enquanto isso, o filho mais velho estivera trabalhando no campo. No caminho de volta para casa, ele ouviu música e viu pessoas dançando. ");
INSERT INTO porblt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Então, ele chamou um dos empregados e perguntou o que estava acontecendo. ");
INSERT INTO porblt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","O empregado respondeu: ‘O seu irmão está de volta, e o seu pai mandou matar o bezerro gordo, pois ele voltou para casa seguro e com saúde.’ ");
INSERT INTO porblt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","O irmão mais velho ficou furioso. Ele se recusou a entrar em casa. Então, seu pai saiu para insistir com ele para que entrasse. ");
INSERT INTO porblt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ele disse a seu pai: ‘Veja! Todos esses anos eu trabalhei para você. Eu nunca desobedeci a uma ordem sua, mas o senhor nunca me deu nem mesmo um cabrito, para que eu festejasse com os meus amigos. ");
INSERT INTO porblt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Agora, esse seu filho volta, depois de ter gastado todo o seu dinheiro com prostitutas, e você mata o bezerro gordo para ele!’ ");
INSERT INTO porblt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","O pai respondeu; ‘Meu filho, você está sempre ao meu lado. Tudo o que eu tenho é seu. ");
INSERT INTO porblt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mas, nós devemos ficar felizes e comemorar. Pois este é o seu irmão que estava morto, mas que voltou vivo. Ele estava perdido, mas foi encontrado!’” ");
INSERT INTO porblt_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus contou aos seus discípulos esta história: “Certa vez, havia um administrador de um homem rico que estava sendo acusado de desperdiçar os bens do seu patrão. ");
INSERT INTO porblt_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Então, o homem rico chamou o seu administrador e lhe perguntou: ‘É verdade o que eu estou ouvindo sobre você? Preste contas da sua administração, pois você não continuará a trabalhar como meu administrador.’ ");
INSERT INTO porblt_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","O administrador pensou: ‘O meu patrão irá me despedir. E agora? O que eu farei? Eu não sou forte o bastante para cavar a terra e tenho muita vergonha de pedir esmolas. ");
INSERT INTO porblt_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah! Já sei o que irei fazer para que, quando eu for demitido do meu trabalho, as pessoas me recebam bem em suas casas.’ ");
INSERT INTO porblt_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Então, ele convidou todos os que estavam em dívida com seu patrão para virem conversar com ele. Ele perguntou ao primeiro: ‘Quanto você deve para o meu patrão?’ ");
INSERT INTO porblt_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","O homem respondeu: ‘Cem barris de azeite.’ O administrador lhe disse: ‘Rápido! Sente-se. Pegue a sua conta e a mude para cinquenta.’ ");
INSERT INTO porblt_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Então, ele disse a outro devedor: ‘Quanto você deve?’ O homem respondeu: ‘Cem medidas de trigo.’ O administrador lhe disse: ‘Pegue a sua conta e mude para oitenta.’ ");
INSERT INTO porblt_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","O homem rico elogiou seu administrador desonesto por sua esperteza. Os filhos deste mundo são mais espertos uns com os outros do que os filhos da luz. ");
INSERT INTO porblt_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Eu lhes digo: usem as riquezas deste mundo para fazer amigos. Assim, quando ela acabar, vocês serão bem recebidos no lar eterno. ");
INSERT INTO porblt_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Se você pode ser confiável quando se trata de pouco, também será confiável quando houver muito. Se você for desonesto com pouco, também será desonesto com muito. ");
INSERT INTO porblt_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Então, se vocês não forem dignos de confiança quando se tratar das riquezas deste mundo, quem confiará em vocês para cuidar das riquezas verdadeiras? ");
INSERT INTO porblt_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","E se vocês não forem confiáveis com o que pertence aos outros, quem lhes dará o que é de vocês? ");
INSERT INTO porblt_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nenhum empregado pode obedecer a dois patrões. Ou ele irá odiar um e amar o outro, ou ele irá se dedicar mais a um e irá desprezar o outro. Vocês não podem servir a Deus e também ao dinheiro.” ");
INSERT INTO porblt_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Os fariseus, que amavam o dinheiro, ouviram o que Jesus disse e riram dele. ");
INSERT INTO porblt_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mas, Jesus lhes disse: “Vocês parecem ser bons para as pessoas, mas Deus sabe o que vocês estão pensando. Pois aquilo que as pessoas mais dão valor não vale nada para Deus. ");
INSERT INTO porblt_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","A Lei e os profetas apontaram o caminho até a época de João Batista. A partir daí, as boas novas do Reino de Deus estão sendo anunciadas, e todos estão forçando a sua entrada nele. ");
INSERT INTO porblt_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","No entanto, é mais fácil que o céu e a terra desapareçam do que ser tirado o mais simples acento da Lei. ");
INSERT INTO porblt_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Qualquer homem que se divorciar de sua esposa e se casar com outra mulher comete adultério. E um homem que se casar com uma mulher divorciada também comete adultério. ");
INSERT INTO porblt_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ora, havia um homem muito rico. Ele vestia roupas púrpuras e de linho fino e vivia cercado de luxo. ");
INSERT INTO porblt_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Um mendigo, chamado Lázaro, que tinha o corpo coberto de feridas, costumava se sentar no portão da casa desse homem ");
INSERT INTO porblt_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","e sempre queria comer os restos da mesa do homem rico. Até mesmo os cachorros vinham e lambiam as suas feridas. ");
INSERT INTO porblt_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Então, o mendigo morreu, e os anjos vieram levá-lo para fazer companhia a Abraão. O homem rico também morreu e foi sepultado. ");
INSERT INTO porblt_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","No mundo dos mortos, onde passava por grande sofrimento, ele olhou para cima e viu Abraão bem longe, com Lázaro ao lado dele. ");
INSERT INTO porblt_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ele gritou: ‘Pai Abraão, tenha pena de mim! Mande Lázaro molhar a ponta do seu dedo na água e refrescar a minha língua. Eu estou queimando em agonia.’ ");
INSERT INTO porblt_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mas, Abraão respondeu: ‘Meu filho, lembre-se de que você aproveitou as boas coisas da vida, enquanto Lázaro teve uma vida muito pobre. Ele agora está aqui sendo consolado, enquanto você está sofrendo. ");
INSERT INTO porblt_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Além disso, há um grande abismo entre nós e vocês. Ninguém que queira atravessar daqui até vocês irá conseguir e, também, ninguém daí poderia chegar até onde estamos.’ ");
INSERT INTO porblt_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","O homem rico disse: ‘Então, Pai, eu lhe imploro, por favor, envie Lázaro até a casa do meu pai. ");
INSERT INTO porblt_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Pois eu tenho mais cinco irmãos e ele pode avisá-los para que eles não acabem aqui neste lugar de sofrimento.’ ");
INSERT INTO porblt_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mas, Abraão respondeu: ‘Eles têm Moisés e os profetas. Eles devem escutá-los.’ ");
INSERT INTO porblt_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","O homem disse: ‘Não, pai Abraão. Eles poderão se arrepender, caso alguém ressuscitado for falar com eles.’ ");
INSERT INTO porblt_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraão lhe disse: ‘Se eles não escutarem Moisés nem os profetas, eles não se convencerão mesmo que alguém ressuscite.’” ");
INSERT INTO porblt_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus disse aos seus discípulos: “As tentações são inevitáveis, mas será terrível para aqueles que servem de tropeço para os outros! ");
INSERT INTO porblt_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Pois seria melhor para essas pessoas que elas tivessem uma grande pedra de moinho amarrada no pescoço e que fossem jogadas no mar do que fazer com que um desses pequeninos peque. ");
INSERT INTO porblt_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Então, cuidado com o que vocês fazem. Se o seu irmão pecar, aconselhe-o. E se ele se arrepender, perdoe-o. ");
INSERT INTO porblt_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mesmo se ele pecar contra você sete vezes por dia e se nas sete vezes vier e lhe disser: ‘Desculpe-me!’ Perdoe-o.” ");
INSERT INTO porblt_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Os apóstolos disseram ao Senhor: “Mestre, precisamos de ajuda para ter mais fé!” ");
INSERT INTO porblt_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","O Senhor respondeu: “Mesmo se a sua fé fosse tão pequena quanto uma semente de mostarda, vocês poderiam dizer a esta amoreira: ‘Arranque as suas raízes e vá se plantar no mar.’ E ela iria lhes obedecer. ");
INSERT INTO porblt_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Digamos que vocês tenham um empregado que cuide da terra ou que seja o pastor do seu rebanho. Quando ele chega do trabalho, vocês dizem a ele: ‘Entre e se sente para comer’? ");
INSERT INTO porblt_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Não. Vocês lhe diriam: ‘Faça a minha comida. Vista-se e sirva-me até que eu termine de comer. Depois, você pode comer.’ ");
INSERT INTO porblt_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","E vocês agradecem ao empregado por fazer o que vocês mandaram? Não. ");
INSERT INTO porblt_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Da mesma forma, uma vez que vocês tenham feito tudo o que foi dito para fazerem, deveriam apenas dizer: ‘Nós somos empregados inúteis. Fizemos apenas a nossa obrigação.’” ");
INSERT INTO porblt_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Enquanto Jesus continuava em seu caminho para Jerusalém, passou entre as regiões da Samaria e da Galileia. ");
INSERT INTO porblt_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Quando ele entrou em um povoado, dez leprosos o encontraram, mas mantiveram uma certa distância. ");
INSERT INTO porblt_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Eles gritaram: “Jesus, Mestre, por favor, tenha pena de nós!” ");
INSERT INTO porblt_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Quando Jesus os viu, disse-lhes: “Vão e se apresentem aos sacerdotes.” Enquanto eles iam fazer o que Jesus tinha dito, foram curados. ");
INSERT INTO porblt_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Um deles, quando percebeu que estava curado, voltou para onde estava Jesus e, gritando, louvou a Deus. ");
INSERT INTO porblt_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ele se ajoelhou aos pés de Jesus e lhe agradeceu. Ele era samaritano. ");
INSERT INTO porblt_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","“Não foram dez leprosos curados?”, Jesus perguntou. “Onde estão os outros nove? ");
INSERT INTO porblt_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nenhum deles voltou para louvar a Deus, mas apenas este estrangeiro?” ");
INSERT INTO porblt_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesus disse ao samaritano: “Levante-se e vá! A sua fé o curou.” ");
INSERT INTO porblt_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Certa vez, quando os fariseus vieram e perguntaram a Jesus sobre quando o Reino de Deus iria chegar, ele respondeu: “O Reino de Deus não virá com sinais visíveis que vocês possam ver. ");
INSERT INTO porblt_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","As pessoas não irão dizer: ‘Veja! Aqui está.’ Ou: ‘Olhe! Está lá’, pois o Reino de Deus está dentro de vocês.” ");
INSERT INTO porblt_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Então, Jesus disse aos discípulos: “Está chegando o momento em que vocês irão querer ver o dia em que o Filho do Homem houver chegado, mas não verão. ");
INSERT INTO porblt_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Eles lhes dirão: ‘Vejam! Lá está ele’, ou ‘Olhem! Ele está aqui’, mas, não corram atrás deles. ");
INSERT INTO porblt_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","O dia em que o Filho do Homem vier será exatamente como o relâmpago, que ilumina o céu de uma ponta até a outra. ");
INSERT INTO porblt_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mas, primeiro ele sofrerá muitas coisas e será rejeitado pelo povo de hoje. ");
INSERT INTO porblt_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","A época em que o Filho do homem vier será como a época de Noé: ");
INSERT INTO porblt_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","as pessoas comiam e bebiam, casavam-se e eram dadas em casamento, até o dia em que Noé entrou na arca. Depois veio o dilúvio e destruiu a todos. ");
INSERT INTO porblt_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Será como aconteceu no tempo de Ló: as pessoas comiam e bebiam, compravam e vendiam, plantavam e construíam. ");
INSERT INTO porblt_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mas, no dia em que Ló saiu de Sodoma, houve uma chuva de fogo e enxofre, que caiu do céu e matou todas as pessoas de lá. ");
INSERT INTO porblt_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","O dia em que o Filho do Homem aparecer será exatamente assim. ");
INSERT INTO porblt_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nesse dia, se vocês estiverem na parte de cima das suas casas, no terraço, não desçam para entrar em casa e pegar suas coisas. E se vocês estiverem trabalhando no campo, não voltem para casa também. ");
INSERT INTO porblt_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lembrem-se da esposa de Ló. ");
INSERT INTO porblt_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Se vocês tentarem preservar suas vidas, vocês as perderão. Mas, se vocês perderem as suas vidas, vocês as salvarão. ");
INSERT INTO porblt_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Eu lhes digo que, naquela noite, dois estarão dormindo na cama; um será levado e o outro será deixado. ");
INSERT INTO porblt_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Duas mulheres estarão moendo grãos, e uma será levada e a outra será deixada.” ");
INSERT INTO porblt_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Eles perguntaram: “Onde isso acontecerá, Senhor?” Jesus respondeu: “Os urubus se reúnem onde o corpo de um morto está.” ");
INSERT INTO porblt_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesus lhes contou esta história para incentivá-los a orar sempre e não desanimar: ");
INSERT INTO porblt_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Certa vez, havia um juiz em uma determinada cidade que não respeitava a Deus e nem se preocupava com as pessoas.” ");
INSERT INTO porblt_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","“Na mesma cidade vivia uma viúva que, repetidamente, ia até o juiz, dizendo: ‘Julgue o meu caso contra o meu adversário!’ ");
INSERT INTO porblt_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Por certo tempo, ele não quis fazer nada em relação a isso. Mas, finalmente, ele pensou: ‘Mesmo que eu não respeite a Deus ou ligue para as pessoas, ");
INSERT INTO porblt_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","essa viúva me irrita tanto que eu julgarei a sua causa. Assim, ela não vai mais me esgotar a paciência, vindo tantas vezes me ver.’ ");
INSERT INTO porblt_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Escutem o que até mesmo um juiz injusto decidiu”, disse o Senhor. ");
INSERT INTO porblt_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","“Vocês não acham que Deus garantirá a justiça para o povo que ele mesmo escolheu? Aqueles que gritam por ele dia e noite? Vocês acham que ele fará com que eles esperem? ");
INSERT INTO porblt_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Não. Eu lhes digo que ele fará com que a justiça seja feita muito rapidamente para eles. No entanto, quando o Filho do Homem vier, ele encontrará pessoas na terra que tenham fé nele?” ");
INSERT INTO porblt_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ele também contou esta história sobre as pessoas que estão muito certas de estarem vivendo do modo correto e que desprezam os outros: ");
INSERT INTO porblt_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Dois homens foram ao Templo orar. Um era fariseu e o outro era um cobrador de impostos. ");
INSERT INTO porblt_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","O fariseu ficou em pé e orou assim consigo mesmo: ‘Senhor, eu agradeço por não ser como as outras pessoas, como os trapaceiros, criminosos, adúlteros ou até mesmo como este cobrador de impostos. ");
INSERT INTO porblt_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Eu jejuo duas vezes por semana e pago a décima parte dos meus ganhos.’ ");
INSERT INTO porblt_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mas, o cobrador de impostos ficou a certa distância. Ele nem mesmo erguia os olhos para o céu. Em vez disso, batia com a mão no peito e orava: ‘Deus, por favor, tenha pena de mim! Eu sou um pecador.’ ");
INSERT INTO porblt_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Eu lhes digo que foi o cobrador de impostos que voltou para casa como justo na visão de Deus e não o fariseu. Pois aqueles que se engrandecem serão humilhados, enquanto aqueles que se humilham serão considerados grandes.” ");
INSERT INTO porblt_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Alguns pais estavam trazendo seus filhos pequenos para Jesus abençoá-los com o seu toque. Quando os discípulos viram o que estava acontecendo, eles tentaram impedi-los. ");
INSERT INTO porblt_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mas, Jesus chamou as crianças para que elas se aproximassem dele. Ele disse: “Deixem as crianças virem até mim. Não proíbam as crianças, pois o Reino de Deus pertence às pessoas que são como elas. ");
INSERT INTO porblt_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Eu lhes digo que isto é verdade: qualquer um que não receber o Reino de Deus como uma criança, nunca entrará nele.” ");
INSERT INTO porblt_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Um dos líderes se aproximou de Jesus e lhe perguntou: “Bom Mestre, o que eu preciso fazer para ganhar a vida eterna?” ");
INSERT INTO porblt_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Por que você diz que eu sou bom?”, Jesus respondeu. “Ninguém, além de Deus, é bom. ");
INSERT INTO porblt_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Você sabe os mandamentos: não cometa adultério, não mate, não roube, não dê falso testemunho, respeite o seu pai e a sua mãe.” ");
INSERT INTO porblt_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","O homem respondeu: “Eu cumpro todos esses mandamentos desde que eu era criança.” ");
INSERT INTO porblt_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Quando Jesus ouviu isso, disse ao homem: “Você se esqueceu de uma coisa: Vá e venda tudo o que você tem. Dê o dinheiro aos pobres, e você terá tesouros no céu. Depois, venha e siga-me.” ");
INSERT INTO porblt_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mas, quando o homem ouviu isso ficou muito triste, pois era muito rico. ");
INSERT INTO porblt_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Quando Jesus viu a reação do homem, ele disse: “Como é difícil para um rico entrar no Reino de Deus! ");
INSERT INTO porblt_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","É mais fácil um camelo passar pelo buraco de uma agulha do que um rico entrar no Reino de Deus.” ");
INSERT INTO porblt_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","As pessoas que ouviam isso pensaram: “Então, quem pode ser salvo?” ");
INSERT INTO porblt_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesus respondeu: “O que é impossível para os seres humanos é possível para Deus.” ");
INSERT INTO porblt_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro disse: “Nós deixamos tudo para segui-lo.” ");
INSERT INTO porblt_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesus disse: “Eu lhes digo que isto é verdade: quem deixa a sua casa, a sua esposa, os seus irmãos, seus pais ou filhos, por causa do Reino de Deus, ");
INSERT INTO porblt_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","receberá muito mais nesta vida, e a vida eterna no futuro.” ");
INSERT INTO porblt_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus chamou os doze discípulos em particular e lhes disse: “Nós iremos para Jerusalém, e tudo o que foi escrito pelos profetas sobre o Filho do Homem se cumprirá. ");
INSERT INTO porblt_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ele será entregue aos pagãos, e eles zombarão dele, o insultarão e cuspirão nele. ");
INSERT INTO porblt_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Eles baterão nele e o matarão. Mas, no terceiro dia, ele ressuscitará.” ");
INSERT INTO porblt_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Porém, eles não entenderam nada do que Jesus lhes dissera. O significado do que Jesus disse foi escondido dos discípulos, e eles não compreenderam o que ele estava falando. ");
INSERT INTO porblt_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesus se aproximou da cidade de Jericó. Havia um homem cego sentado na beira da estrada, pedindo esmola. ");
INSERT INTO porblt_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ele ouviu a multidão passando e perguntou o que estava acontecendo. ");
INSERT INTO porblt_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","As pessoas lhe disseram: “Jesus de Nazaré está passando.” ");
INSERT INTO porblt_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","O cego gritou: “Jesus, Filho de Davi, por favor, tenha pena de mim!” ");
INSERT INTO porblt_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aqueles que seguiam na frente da multidão disseram para ele parar de gritar e ficar quieto, mas isso só fazia com que ele gritasse ainda mais alto: “Filho de Davi, por favor, tenha pena de mim!” ");
INSERT INTO porblt_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesus parou e pediu para que trouxessem o homem cego até ele. Quando o cego se aproximou, Jesus lhe perguntou: ");
INSERT INTO porblt_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“O que é que você quer que eu faça?” Ele implorou: “Senhor, por favor, eu quero ver novamente!” ");
INSERT INTO porblt_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","“Então, veja!”, Jesus lhe disse. “A fé que você tem em mim o curou.” ");
INSERT INTO porblt_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Imediatamente, o homem voltou a enxergar. Ele seguiu Jesus, louvando a Deus. Todos os que estavam lá e que viram o que acontecera também louvaram a Deus. ");
INSERT INTO porblt_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus entrou em Jericó e estava atravessando a cidade. ");
INSERT INTO porblt_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Lá havia um homem que se chamava Zaqueu, que era chefe dos cobradores de impostos. Ele era muito rico. ");
INSERT INTO porblt_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zaqueu queria ver Jesus, mas, por ser muito baixo, não conseguia ver sobre a multidão que havia se formado. ");
INSERT INTO porblt_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Então, ele correu na frente e subiu em uma figueira brava, para ver Jesus quando ele passasse. ");
INSERT INTO porblt_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Quando Jesus chegou lá, olhou para cima e disse: “Zaqueu, desça rápido daí! Eu preciso ficar hoje em sua casa.” ");
INSERT INTO porblt_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueu desceu da árvore rapidamente e foi muito feliz receber Jesus em sua casa. ");
INSERT INTO porblt_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Quando as pessoas viram isso, todas elas reclamaram: “Ele irá ficar na casa de um pecador como este!” ");
INSERT INTO porblt_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mas, Zaqueu se levantou e disse diante do Senhor: “Olhe, Senhor, eu estou dando metade de tudo o que tenho para os pobres. E se eu tiver enganado alguém, devolverei quatro vezes mais!” ");
INSERT INTO porblt_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus respondeu: “Hoje, a salvação veio para esta casa, pois este homem demonstrou que também é um filho de Abraão. ");
INSERT INTO porblt_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Pois o Filho do Homem veio buscar e salvar aqueles que estão perdidos.” ");
INSERT INTO porblt_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Enquanto as pessoas ainda estavam prestando atenção, Jesus lhes contou uma história, pois eles já estavam próximos de Jerusalém e as pessoas pensavam que o Reino de Deus iria se tornar realidade muito em breve. ");
INSERT INTO porblt_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Certo homem nobre iria viajar para um país distante, para ser coroado rei daquele lugar e, depois, retornaria para casa. ");
INSERT INTO porblt_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ele chamou dez dos seus empregados, dividiu igualmente o dinheiro entre eles e lhes disse: ‘Invistam esse dinheiro até eu retornar da minha viagem.’ ");
INSERT INTO porblt_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mas, as pessoas do seu país o odiavam e enviaram um grupo de representantes depois que ele se foi para dizer: ‘Nós não queremos que esse homem seja o nosso rei.’ ");
INSERT INTO porblt_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Depois que foi coroado rei, ele retornou. Ele mandou chamar os seus empregados. Ele queria saber qual lucro que eles tiveram ao investir o dinheiro que havia deixado com eles. ");
INSERT INTO porblt_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","O primeiro empregado veio e disse: ‘Senhor, o seu dinheiro rendeu dez vezes mais.’ ");
INSERT INTO porblt_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Muito bem! Você é um bom empregado,’ disse o rei. ‘Como você provou ser confiável em coisas pequenas, eu o colocarei como responsável por dez cidades.’ ");
INSERT INTO porblt_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","O segundo empregado veio e disse: ‘Senhor, o seu dinheiro rendeu cinco vezes mais.’ ");
INSERT INTO porblt_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","O rei disse: ‘Eu o colocarei como responsável por cinco cidades.’ ");
INSERT INTO porblt_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Outro empregado chegou e disse: ‘Veja, senhor! Aqui está o seu dinheiro. Eu o mantive seguro, embrulhado em um pano. ");
INSERT INTO porblt_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Eu fiquei com medo de você, porque é um homem severo. Você tira dos outros o que não lhe pertence e colhe o que não plantou.’ ");
INSERT INTO porblt_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","O rei respondeu: ‘Eu irei julgá-lo por suas próprias palavras. Você sabe que eu sou severo, que, como você mesmo disse, tiro dos outros o que não me pertence e colho o que não plantei. ");
INSERT INTO porblt_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Então, por que você não depositou o meu dinheiro no banco, para que, quando eu voltasse, pudesse receber o meu dinheiro com juros?’ ");
INSERT INTO porblt_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","O rei disse aos que estavam em pé ao lado dele: ‘Tirem o dinheiro dele e deem para o empregado que fez meu dinheiro render dez vezes mais.’ ");
INSERT INTO porblt_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Eles responderam: ‘Mas, senhor, ele já tem dez vezes mais do que recebeu.’ ");
INSERT INTO porblt_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","O rei disse: ‘Eu lhes digo que, para aqueles que têm, mais será dado; mas, para aqueles que não têm, mesmo o pouco que eles possuem será tirado deles. ");
INSERT INTO porblt_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","E em relação aos meus inimigos, que não querem que eu seja o rei deste país, tragam-nos aqui e os matem na minha frente.’” ");
INSERT INTO porblt_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Depois que terminou de contar a história, Jesus foi para Jerusalém, caminhando na frente. ");
INSERT INTO porblt_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Quando ele se aproximava de Betfagé e de Betânia, no monte das Oliveiras, ele enviou dois discípulos, dizendo: ");
INSERT INTO porblt_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Vão para a vila que se encontra mais adiante. Ao entrarem lá, encontrarão um jumentinho amarrado, o qual nunca foi montado por ninguém. Desamarrem-no e o tragam aqui. ");
INSERT INTO porblt_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Se alguém lhes perguntar: ‘Por que vocês estão desamarrando este animal?’ Apenas digam assim: ‘O Senhor precisa dele.’” ");
INSERT INTO porblt_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Então, os dois discípulos foram e encontraram tudo exatamente como Jesus lhes tinha dito. ");
INSERT INTO porblt_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Quando eles foram desamarrar o jumentinho, os donos do animal lhes perguntaram: “Por que vocês estão desamarrando o jumentinho?” ");
INSERT INTO porblt_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Os discípulos responderam: “O Senhor precisa dele.” ");
INSERT INTO porblt_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Assim, eles levaram o jumento para Jesus. Então, eles colocaram as suas capas sobre o animal e ajudaram Jesus a montar nele. ");
INSERT INTO porblt_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Conforme ele prosseguia, as pessoas estendiam suas capas na estrada. ");
INSERT INTO porblt_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Quando ele se aproximou de Jerusalém, na descida do monte das Oliveiras, a multidão de discípulos começou a louvar alegremente a Deus, em voz alta, por todos os milagres que eles tinham visto. ");
INSERT INTO porblt_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Eles gritavam: “Abençoado seja o Reino que vem em nome do Senhor! Paz no céu e glória nas alturas!” ");
INSERT INTO porblt_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Alguns fariseus que estavam na multidão disseram para Jesus: “Mestre, faça com que os seus discípulos parem de dizer isso.” ");
INSERT INTO porblt_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mas Jesus respondeu: “Eu lhes digo que, se eles ficarem quietos, então, as pedras irão gritar!” ");
INSERT INTO porblt_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mas quando ele foi chegando mais perto, viu a cidade e chorou por ela. ");
INSERT INTO porblt_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ele disse: “Eu realmente queria que hoje, você, Jerusalém, até mesmo você, soubesse o caminho para chegar à paz! Mas, agora já não há como enxergar esse caminho. ");
INSERT INTO porblt_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Está chegando o momento em que os seus inimigos irão cercá-la, construirão rampas para atacá-la e não haverá como escapar. ");
INSERT INTO porblt_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Eles a esmagarão e, junto com você, todos os seus filhos serão destruídos. Não restará pedra alguma em pé, pois você se recusou a aceitar a salvação quando ela veio até você.” ");
INSERT INTO porblt_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesus entrou no Templo e começou a expulsar todos os vendedores que estavam lá. ");
INSERT INTO porblt_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ele lhes disse: “As Sagradas Escrituras afirmam que ‘a minha casa será uma casa de oração’, mas vocês a transformaram em um esconderijo de ladrões.” ");
INSERT INTO porblt_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Todos os dias, Jesus ensinava no Templo. Os chefes dos sacerdotes, os educadores religiosos e os líderes do povo estavam tentando encontrar um meio de matá-lo. ");
INSERT INTO porblt_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mas eles não conseguiam isso, pois todas as pessoas gostavam de Jesus e estavam fascinadas pelo que ele dizia. ");
INSERT INTO porblt_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Certa vez, quando Jesus estava ensinando às pessoas no Templo, dizendo para elas sobre as boas novas do Reino de Deus, alguns chefes dos sacerdotes e dos educadores religiosos chegaram com os anciãos do povo. ");
INSERT INTO porblt_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Eles perguntaram a Jesus: “Diga-nos, com a autoridade de quem você está fazendo essas coisas? Quem lhe deu o direito de fazer isso?” ");
INSERT INTO porblt_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesus respondeu: “Deixem-me também fazer uma pergunta a vocês. Digam-me: ");
INSERT INTO porblt_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","O batismo de João vinha do céu ou era apenas uma ação humana?” ");
INSERT INTO porblt_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Eles conversaram sobre isso entre eles: “Se dissermos que era do céu, ele perguntará: ‘Então, por que vocês não acreditaram nele?’ ");
INSERT INTO porblt_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","E se dissermos que vinha dos homens, todos aqui irão nos apedrejar, pois eles têm certeza de que João era um profeta.” ");
INSERT INTO porblt_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Assim eles responderam: “Nós não sabemos!” ");
INSERT INTO porblt_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesus respondeu: “Então, não direi a vocês quem me deu autoridade para fazer o que faço.” ");
INSERT INTO porblt_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Depois, ele começou a contar uma história para as pessoas: “Havia um homem que fez uma plantação de uvas. Ele então, arrendou essa área para alguns lavradores e foi morar em outro país por um longo tempo. ");
INSERT INTO porblt_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na época da colheita, ele enviou um empregado para receber dos lavradores a sua parte. Mas, os lavradores bateram no empregado e o mandaram embora sem nada. ");
INSERT INTO porblt_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Depois, o proprietário enviou outro empregado, mas eles bateram nele também e o trataram vergonhosamente. Esse empregado também voltou sem conseguir receber nada. ");
INSERT INTO porblt_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","O dono das terras enviou um terceiro empregado, mas eles bateram nele e o expulsaram. ");
INSERT INTO porblt_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","O dono da lavoura pensou: ‘O que eu devo fazer? Já sei! Enviarei o meu filho, que amo muito. Talvez, eles o respeitarão.’ ");
INSERT INTO porblt_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mas, quando os lavradores o viram chegando, disseram uns aos outros: ‘Este é o herdeiro do proprietário das terras. Vamos matá-lo! Assim, poderemos ficar com a herança.’ ");
INSERT INTO porblt_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eles o expulsaram da plantação e o mataram. E agora? O que o dono da plantação de uvas fará com os homens que mataram o seu filho? ");
INSERT INTO porblt_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ele virá e matará esses lavradores e arrendará a plantação a outros.” Quando eles ouviram a história, disseram: “Que isso nunca aconteça!” ");
INSERT INTO porblt_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mas, Jesus olhou para eles e disse: “Então, por que está escrito nas Sagradas Escrituras: ‘A pedra que os construtores rejeitaram, agora se tornou a base da construção?’ ");
INSERT INTO porblt_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Quem cair sobre essa pedra será partido em pedaços. E, se a pedra cair sobre alguém, essa pessoa será esmagada.” ");
INSERT INTO porblt_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Os educadores religiosos e os chefes dos sacerdotes queriam prendê-lo imediatamente, pois perceberam que a história de Jesus dizia respeito a eles. Mas, eles tinham medo de como as pessoas que estavam ali reagiriam. ");
INSERT INTO porblt_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Esperando por uma oportunidade, eles enviaram espiões, que fingiam ser sinceros. Eles tentavam pegar Jesus, usando algo que ele dissesse. Se encontrassem uma prova, poderiam entregá-lo à autoridade do governador. ");
INSERT INTO porblt_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Eles disseram: “Mestre, nós sabemos que você fala e ensina o que é bom e certo e que você não se deixa convencer pelas opiniões dos outros. Você verdadeiramente ensina o caminho de Deus. ");
INSERT INTO porblt_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Então, devemos pagar impostos ao imperador, ou não?” ");
INSERT INTO porblt_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mas, Jesus percebendo a má intenção deles, lhes disse: ");
INSERT INTO porblt_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mostre-me uma moeda de um denário. De quem é a imagem e o nome inscrito nela?” Eles responderam: “Do imperador.” ");
INSERT INTO porblt_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ele lhes disse: “Então, deem ao imperador o que pertence ao imperador. E deem a Deus o que pertence a Deus.” ");
INSERT INTO porblt_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Eles não conseguiram provas contra Jesus pelas coisas que ele dizia para as pessoas. Eles ficaram impressionados com sua resposta e se calaram. ");
INSERT INTO porblt_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Então, alguns saduceus, os quais não acreditam na ressurreição, vieram até Jesus e lhe perguntaram: ");
INSERT INTO porblt_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mestre, Moisés nos deu uma lei que diz que se um homem casado morrer, deixando a esposa sem filhos, o irmão dele deve se casar com a viúva e ter filhos, que serão considerados filhos do irmão que morreu. ");
INSERT INTO porblt_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Certa vez, havia sete irmãos. O primeiro tinha uma esposa, e ele morreu sem deixar filhos. ");
INSERT INTO porblt_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","O segundo ");
INSERT INTO porblt_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","e depois o terceiro irmãos se casaram com ela. No final, todos os sete irmãos se casaram com ela e morreram sem deixar filhos. ");
INSERT INTO porblt_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Finalmente, a mulher também morreu. ");
INSERT INTO porblt_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Então, como ela se casou com todos os sete irmãos, no dia da ressurreição, de qual deles ela será esposa?” ");
INSERT INTO porblt_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus explicou: “Nesta época, as pessoas se casam e são dadas em casamento. ");
INSERT INTO porblt_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mas, aquelas que são consideradas merecedoras de ter parte na época que chegará e na ressurreição não se casarão e nem serão dadas em casamento. ");
INSERT INTO porblt_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Elas não irão mais morrer e serão como anjos e são filhos de Deus, pois são filhos da ressurreição. ");
INSERT INTO porblt_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mas, sobre se os mortos podem reviver, até mesmo Moisés provou isso quando escreveu sobre o espinheiro em chamas. Quando ele diz ao Senhor: ‘o Deus de Abraão, o Deus de Isaque e o Deus de Jacó.’ ");
INSERT INTO porblt_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ele não é Deus dos mortos, mas, sim, dos vivos, pois, para ele, todos vivem.” ");
INSERT INTO porblt_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Alguns dos educadores religiosos responderam: Essa foi uma boa resposta, Mestre! ");
INSERT INTO porblt_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Depois disso, ninguém se atreveu a lhe perguntar mais nada. ");
INSERT INTO porblt_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Então, Jesus lhes perguntou: “Por que dizem que o Messias é filho de Davi? ");
INSERT INTO porblt_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pois o próprio Davi diz no livro dos Salmos: O Senhor Deus disse para o meu Senhor: ‘Sente-se a minha direita, ");
INSERT INTO porblt_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","até que eu faça de todos os seus inimigos como um estrado para os seus pés.’ ");
INSERT INTO porblt_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davi o chama ‘Senhor’, então, como ele pode ser filho de Davi?” ");
INSERT INTO porblt_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Enquanto todos prestavam atenção, Jesus disse aos discípulos: ");
INSERT INTO porblt_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Cuidado com os líderes religiosos, que gostam de andar por aí com mantos compridos e de ser cumprimentados com respeito nas praças dos mercados. Eles gostam de ter os melhores lugares nas sinagogas e de se sentar nos lugares de honra nos banquetes. ");
INSERT INTO porblt_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Eles enganam as viúvas, tirando o que elas têm, e escondem o tipo de pessoas que eles realmente são fazendo longas orações. Eles serão severamente castigados quando forem julgados.” ");
INSERT INTO porblt_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus estava olhando ao redor e viu pessoas ricas colocando suas contribuições na caixa de ofertas. ");
INSERT INTO porblt_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ele também viu uma viúva muito pobre colocar duas pequenas moedas. ");
INSERT INTO porblt_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ele disse: “Eu lhes digo que isto é verdade: esta pobre viúva colocou mais do que todos os outros juntos. ");
INSERT INTO porblt_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Todos eles deram da riqueza que eles tinham, mas ela deu de sua pobreza tudo o que tinha para viver.” ");
INSERT INTO porblt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Algumas pessoas que estavam lá comentavam sobre o Templo, a respeito das bonitas pedras com que estava enfeitado e das coisas que tinham sido ofertadas. Mas, Jesus disse: ");
INSERT INTO porblt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Em relação a estas coisas para as quais vocês estão olhando, está chegando o momento em que não restará uma pedra sobre a outra. Tudo será destruído!” ");
INSERT INTO porblt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Eles lhe perguntaram: “Mestre, quando isso acontecerá? Qual será o sinal que mostrará que essas coisas acontecerão?” ");
INSERT INTO porblt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesus lhes avisou: “Tenham cuidado para que não sejam enganados. Muitas pessoas vão aparecer, fingindo ser eu, afirmando: ‘Eu sou o Messias!’. E também: ‘O tempo chegou!’ Mas não as sigam. ");
INSERT INTO porblt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Quando vocês ouvirem sobre guerras e revoluções, não fiquem com medo, pois essas coisas precisam acontecer primeiro, mas não quer dizer que o fim virá imediatamente.” ");
INSERT INTO porblt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ele lhes disse: “As nações atacarão umas às outras, e os reinos lutarão uns contra os outros. ");
INSERT INTO porblt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Haverá fortes tremores de terra, muita fome e epidemias em muitos lugares. Além disso, serão vistos estranhos sinais no céu, que irão aterrorizar a todos. ");
INSERT INTO porblt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mas, antes de tudo isso, eles irão prendê-los e persegui-los. Eles irão arrastá-los até às sinagogas e os jogarão na prisão. Vocês serão julgados por reis e governadores, por minha causa. ");
INSERT INTO porblt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mas, isso lhes dará a oportunidade para falar em meu nome diante deles. ");
INSERT INTO porblt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Assim, não se preocupem sobre como falarão para se defender, ");
INSERT INTO porblt_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","pois eu lhes darei palavras de sabedoria, para que os seus inimigos não sejam capazes de resistir a vocês ou de desmenti-los. ");
INSERT INTO porblt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Vocês serão entregues até por seus pais, irmãos, parentes e amigos e irão até mesmo matar alguns de vocês. ");
INSERT INTO porblt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Todos odiarão vocês por serem meus seguidores. ");
INSERT INTO porblt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mas, nem um único fio de cabelo da cabeça de vocês será perdido. ");
INSERT INTO porblt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ao ficarem firmes, vocês ganharão as suas vidas. ");
INSERT INTO porblt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","No entanto, quando vocês virem Jerusalém cercada por exércitos, então, saberão que a destruição da cidade está próxima. ");
INSERT INTO porblt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","As pessoas que estiverem na Judeia deverão fugir para as montanhas, e aquelas que estiverem em Jerusalém deverão sair imediatamente. Os que se encontram nos campos não deverão entrar na cidade. ");
INSERT INTO porblt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Pois esses serão dias de punição, cumprindo assim o que está escrito. ");
INSERT INTO porblt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Que dias difíceis para as mulheres que estiverem grávidas ou amamentando os seus bebês nessa época! Porque virão problemas terríveis sobre a terra e acontecerá a punição para essas pessoas. ");
INSERT INTO porblt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Muitas serão mortas pela espada, e outras levadas como prisioneiras para todas as nações. Jerusalém será esmagada pelas nações pagãs até que se acabe o tempo delas fazerem isso. ");
INSERT INTO porblt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Haverá sinais no sol, na lua e nas estrelas. Aqui na terra, as nações ficarão em dificuldade e confusas pelo barulho furioso e pela agitação do mar. ");
INSERT INTO porblt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","As pessoas irão desmaiar de medo, aterrorizadas com o que estará acontecendo no mundo, pois os poderes dos céus serão abalados. ");
INSERT INTO porblt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Então, elas verão o Filho do Homem, vindo em uma nuvem, com poder e grande glória. ");
INSERT INTO porblt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mas, quando essas coisas acontecerem, fiquem firmes e ergam a cabeça, pois vocês logo serão salvos.” ");
INSERT INTO porblt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Então, Jesus lhes contou esta história como um exemplo para o que queria dizer: “Vejam a figueira ou qualquer outro tipo de árvore. ");
INSERT INTO porblt_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Quando vocês veem novas folhas aparecerem ninguém precisa lhes dizer que o verão está próximo. ");
INSERT INTO porblt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Da mesma maneira, quando vocês virem essas coisas acontecendo não precisarão que alguém lhes diga que o Reino de Deus está próximo. ");
INSERT INTO porblt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Eu lhes digo que isto é verdade: esta geração não morrerá antes que tudo isso aconteça. ");
INSERT INTO porblt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","O céu e a terra poderão desaparecer, mas a minha palavra não desaparecerá. ");
INSERT INTO porblt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Tomem cuidado para que não se distraiam com festas, bebedeiras ou com as preocupações desta vida, para que esse dia não os pegue de surpresa. ");
INSERT INTO porblt_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Pois esse dia virá para todos que vivem sobre a terra. ");
INSERT INTO porblt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Fiquem sempre alerta e orem. Assim, vocês poderão escapar de tudo que irá acontecer e permanecer em pé diante do Filho do Homem.” ");
INSERT INTO porblt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Todos os dias Jesus ensinava no Templo, e todas as noites ele ficava no monte das Oliveiras. ");
INSERT INTO porblt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Todas as pessoas vinham bem cedo de manhã para ouvi-lo no Templo. ");
INSERT INTO porblt_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Estava se aproximando a Festa dos Pães sem Fermento, também conhecida como Páscoa. ");
INSERT INTO porblt_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Os chefes dos sacerdotes e os educadores religiosos estavam tentando encontrar um modo de matar Jesus, mas tinham medo da reação das pessoas. ");
INSERT INTO porblt_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satanás entrou em Judas Iscariotes, um dos doze discípulos. ");
INSERT INTO porblt_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ele se encontrou com os chefes dos sacerdotes e com os oficiais da guarda, para falar sobre como poderia trair Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Eles ficaram felizes e lhe ofereceram dinheiro. ");
INSERT INTO porblt_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ele concordou e começou a procurar uma oportunidade para entregar Jesus quando não houvesse muita gente em torno dele. ");
INSERT INTO porblt_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Chegou o dia da Festa dos Pães sem Fermento, quando se sacrificavam cordeiros para comemorar a Páscoa. ");
INSERT INTO porblt_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus enviou Pedro e João, dizendo-lhes: “Vão e preparem a refeição da Páscoa. Assim, poderemos comer juntos.” ");
INSERT INTO porblt_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Eles lhe perguntaram: “Onde o senhor quer que preparemos o jantar?” ");
INSERT INTO porblt_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesus respondeu: “Quando vocês entrarem na cidade, encontrarão um homem, carregando um pote com água. Sigam esse homem e entrem em sua casa com ele. ");
INSERT INTO porblt_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Digam ao dono da casa que o Mestre perguntou: ‘Onde fica a sala onde eu poderei comemorar a Páscoa com os meus discípulos?’ ");
INSERT INTO porblt_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ele lhes mostrará uma grande sala no andar de cima da casa, onde tem tudo o que é necessário. Preparem a refeição lá.” ");
INSERT INTO porblt_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Os discípulos foram e encontraram tudo exatamente como Jesus tinha dito. Eles, então, prepararam a refeição de Páscoa lá. ");
INSERT INTO porblt_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Quando chegou a hora, ele se sentou à mesa com os seus apóstolos. Ele lhes disse: ");
INSERT INTO porblt_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","“Eu estava aguardando ansiosamente fazer esta refeição de Páscoa com vocês antes que o meu sofrimento comece. ");
INSERT INTO porblt_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Eu lhes digo que não comerei este jantar novamente, até que eu o coma no Reino de Deus.” ");
INSERT INTO porblt_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesus pegou o cálice e, após ter dado graças a Deus, ele disse: “Peguem isto e repartam entre vocês. ");
INSERT INTO porblt_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Eu lhes digo que não beberei novamente deste vinho, até que eu o beba no Reino de Deus.” ");
INSERT INTO porblt_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ele pegou o pão e, após ter dado graças a Deus, dividiu-o em pedaços e repartiu com os discípulos. Jesus lhes disse: “Isto é o meu corpo que é dado a vocês. Façam isso para se lembrarem de mim.” ");
INSERT INTO porblt_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Da mesma forma, quando acabaram de jantar, ele pegou o cálice e disse: “Este é o cálice do novo acordo, garantido pelo meu sangue, derramado em favor de vocês.” ");
INSERT INTO porblt_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Apesar disso, meu traidor está sentado bem aqui à mesa. ");
INSERT INTO porblt_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Pois foi determinado que o Filho do Homem irá morrer, mas ai do traidor!” ");
INSERT INTO porblt_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Eles começaram a discutir sobre quem seria e quem poderia fazer isso. ");
INSERT INTO porblt_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ao mesmo tempo, também houve uma discussão sobre quem era o mais importante entre eles. ");
INSERT INTO porblt_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesus lhes disse: “Os reis pagãos dominam os seus povos e, aqueles que têm poder querem até mesmo que as pessoas os chamem de ‘benfeitores.’ ");
INSERT INTO porblt_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mas, com vocês, não deve ser assim. Pelo contrário, o mais importante entre vocês deve ser como o menos importante, e o líder deve ser como um empregado. ");
INSERT INTO porblt_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Quem é mais importante: aquele que está sentado à mesa para comer ou aquele que serve? Não é aquele que está sentado à mesa? Mas, eu sou como aquele que serve vocês. ");
INSERT INTO porblt_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Vocês têm permanecido ao meu lado durante as minhas dificuldades. ");
INSERT INTO porblt_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","E eu darei a vocês autoridade para governar, exatamente como o meu Pai me deu também, ");
INSERT INTO porblt_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","para que vocês possam comer e beber a minha mesa, em meu Reino. E vocês se sentarão em tronos para julgar as doze tribos de Israel.” ");
INSERT INTO porblt_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simão, Simão, Satanás pediu todos vocês para peneirar como trigo, ");
INSERT INTO porblt_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","mas eu tenho orado por você, para que a sua fé em mim não acabe. E quando você se converter, dê força aos seus irmãos.” ");
INSERT INTO porblt_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro disse: “Senhor, estou pronto para ir com você para a prisão e para morrer com você!” ");
INSERT INTO porblt_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus respondeu: “Eu lhe digo Pedro, que antes que o galo cante hoje, você negará três vezes que me conhece.” ");
INSERT INTO porblt_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesus perguntou aos discípulos: “Quando eu os enviei sem dinheiro, sem bolsa e sem um par extra de sandálias, faltou algo para vocês?” Eles responderam: “Não, não faltou nada!” ");
INSERT INTO porblt_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Mas agora, se vocês tiverem dinheiro devem pegá-lo, o mesmo façam com uma bolsa. E se vocês não têm uma espada devem vender a sua capa e comprar uma. ");
INSERT INTO porblt_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Eu lhes digo que a afirmação que está nas Sagradas Escrituras sobre mim deve se cumprir: ‘Ele foi considerado como um criminoso.’ O que foi dito a meu respeito está se cumprindo agora.” ");
INSERT INTO porblt_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Eles disseram: “Veja, Senhor! Temos duas espadas.” Ele respondeu: “Isso basta!” ");
INSERT INTO porblt_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesus saiu e, como de costume, foi para o monte das Oliveiras, juntamente com os seus discípulos. ");
INSERT INTO porblt_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Quando chegou, disse aos discípulos: “Orem para que não caiam em tentação.” ");
INSERT INTO porblt_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Então, ele se afastou dos discípulos e foi caminhar a uns trinta metros de distância. Jesus se ajoelhou e começou a orar. ");
INSERT INTO porblt_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ele disse: “Pai, se você quiser, por favor, afaste de mim este cálice de sofrimento! Mas, que não seja feito o que eu quero, mas o que o senhor quer.” ");
INSERT INTO porblt_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na mesma hora, um anjo apareceu do céu para lhe dar forças. ");
INSERT INTO porblt_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sentindo uma grande angústia, Jesus orou com mais força e o seu suor caía como gotas de sangue no chão. ");
INSERT INTO porblt_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ele acabou sua oração, levantou-se e voltou para onde estavam os discípulos. Eles estavam adormecidos, esgotados pela tristeza. ");
INSERT INTO porblt_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesus lhes perguntou: “Por que vocês estão dormindo? Levantem-se e orem para que não caiam em tentação!” ");
INSERT INTO porblt_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Enquanto ele ainda estava falando, uma multidão apareceu, liderada por Judas, um dos doze discípulos. Judas se aproximou de Jesus e o beijou. ");
INSERT INTO porblt_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mas, Jesus lhe perguntou: “Judas, você está traindo o Filho do Homem com um beijo?” ");
INSERT INTO porblt_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Os seguidores de Jesus lhe perguntaram: “Senhor, devemos atacá-los com as nossas espadas?” ");
INSERT INTO porblt_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","E um deles atingiu o empregado do grande sacerdote, cortando sua orelha direita. ");
INSERT INTO porblt_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesus disse: “Parem! Chega disto!” Ele tocou a orelha do homem e o curou. ");
INSERT INTO porblt_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Depois, Jesus falou com os chefes dos sacerdotes, com os oficiais da guarda do Templo e com os anciãos do povo: “Eu sou algum tipo de criminoso, para que vocês tenham que vir com espadas e porretes? ");
INSERT INTO porblt_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Vocês não me prenderam antes, mesmo eu estando todos os dias com vocês no Templo. Mas agora, este é o seu momento. Este é o tempo em que as trevas estão no poder.” ");
INSERT INTO porblt_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Eles prenderam Jesus e o levaram para a casa do grande sacerdote. Pedro os seguiu a certa distância. ");
INSERT INTO porblt_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Eles acenderam uma fogueira no meio do pátio e se sentaram próximos a ela. Pedro estava entre eles. ");
INSERT INTO porblt_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Quando ele se sentou lá, uma empregada o viu, olhou diretamente para ele e disse: ");
INSERT INTO porblt_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","“Este homem estava com ele!” Mas, Pedro negou. Ele disse: “Não, eu não o conheço!” ");
INSERT INTO porblt_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pouco tempo depois, mais alguém olhou para ele e disse: “Você também é um deles!” E Pedro respondeu: “Não, eu não sou!” ");
INSERT INTO porblt_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Cerca de uma hora depois, outra pessoa insistiu: “Tenho certeza de que você estava com ele também, pois você é galileu.” ");
INSERT INTO porblt_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","“Eu não tenho ideia do que você está falando!”, Pedro respondeu. Naquele momento, enquanto ele ainda estava falando, o galo cantou. O Senhor virou-se e olhou para Pedro. ");
INSERT INTO porblt_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","E Pedro se lembrou do que o Senhor lhe tinha dito: “Hoje, antes que o galo cante, você me negará três vezes.” ");
INSERT INTO porblt_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedro saiu dali e chorou amargamente. ");
INSERT INTO porblt_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Os homens que vigiavam Jesus começaram a zombar e a bater nele. ");
INSERT INTO porblt_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Eles colocaram uma venda em seus olhos e depois lhe perguntaram: “Se você pode fazer profecias, então, adivinhe quem bateu em você dessa vez!” ");
INSERT INTO porblt_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Eles também disseram muitos outros insultos para ele. ");
INSERT INTO porblt_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Na manhã do dia seguinte, o conselho de anciãos do povo se reuniu com os chefes dos sacerdotes e com os educadores religiosos. Jesus foi levado diante do conselho. ");
INSERT INTO porblt_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Eles disseram: “Diga para nós se você é realmente o Messias.” Jesus respondeu: “Mesmo se eu dissesse, vocês não acreditariam em mim. ");
INSERT INTO porblt_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","E se eu lhes fizesse uma pergunta, vocês também não me responderiam. ");
INSERT INTO porblt_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mas, a partir de agora, o Filho do Homem se sentará à direita do Deus Todo-Poderoso.” ");
INSERT INTO porblt_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Todos eles perguntaram: “Então, você é o Filho de Deus?” Jesus respondeu: “São vocês quem estão dizendo isso!” ");
INSERT INTO porblt_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Eles falaram: “Por que nós precisamos de qualquer outra testemunha? Nós mesmos ouvimos isso de sua própria boca!” ");
INSERT INTO porblt_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Todo o conselho superior se levantou e levou Jesus a Pilatos. ");
INSERT INTO porblt_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Lá, eles começaram a acusá-lo. Eles disseram: “Nós descobrimos que este homem está enganando a nossa nação. Ele diz para as pessoas não pagarem impostos ao imperador. E também afirma ser o Messias, um rei.” ");
INSERT INTO porblt_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatos lhe perguntou: “Você é o Rei dos Judeus?” Jesus respondeu: “É você quem está dizendo isso!” ");
INSERT INTO porblt_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Então, Pilatos disse aos chefes dos sacerdotes e à multidão que estava lá: “Eu não acho que este homem seja culpado de qualquer crime!” ");
INSERT INTO porblt_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mas, eles insistiram, dizendo: “Ele está incentivando a rebelião em toda a Judeia com os seus ensinamentos, desde a Galileia até aqui em Jerusalém.” ");
INSERT INTO porblt_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ao ouvir isso, Pilatos perguntou: “Este homem é galileu?” ");
INSERT INTO porblt_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Quando ele soube que Jesus tinha vindo da jurisdição de Herodes, ele o enviou para Herodes que, naquela época, também estava em Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes ficou muito satisfeito em ver Jesus, pois há muito tempo ele queria conhecê-lo. Ele tinha ouvido a respeito de Jesus e tinha esperança de vê-lo realizar um milagre. ");
INSERT INTO porblt_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ele fez muitas perguntas a Jesus, mas não ouviu nenhuma resposta a qualquer pergunta que havia feito a ele, pois Jesus se calou. ");
INSERT INTO porblt_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Os chefes dos sacerdotes e os educadores religiosos ficaram lá, acusando-o ferozmente. ");
INSERT INTO porblt_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes e os seus soldados trataram Jesus com desprezo e zombaram dele. Então, eles colocaram um manto luxuoso nele e o enviaram de volta a Pilatos. ");
INSERT INTO porblt_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","A partir daquele dia, Herodes e Pilatos, que antes eram inimigos, se tornaram amigos. ");
INSERT INTO porblt_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatos reuniu os chefes dos sacerdotes, as autoridades e o povo ");
INSERT INTO porblt_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","e lhes disse: “Vocês trouxeram esse homem diante de mim, acusando-o de incentivar as pessoas a se revoltarem. Eu o interroguei com muito cuidado na presença de vocês e não acho que seja culpado das acusações que fazem contra ele. ");
INSERT INTO porblt_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nem Herodes acha, pois o enviou novamente para nós. Ele não fez nada que exija que seja condenado à morte. ");
INSERT INTO porblt_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Então, eu mandarei chicoteá-lo e depois o libertarei.” ");
INSERT INTO porblt_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mas, eles todos gritaram juntos: “Mate esse homem e liberte Barrabás para nós!” ");
INSERT INTO porblt_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barrabás foi preso por fazer parte em uma rebelião na cidade e por assassinato.) ");
INSERT INTO porblt_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatos queria libertar Jesus. Então, falou com eles novamente. ");
INSERT INTO porblt_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mas, eles continuavam a gritar: “Crucifique-o! Crucifique-o!” ");
INSERT INTO porblt_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatos lhes perguntou pela terceira vez: “Mas, por quê? Qual crime ele cometeu? Eu não encontro qualquer motivo para matá-lo. Então, irei mandar chicoteá-lo e depois o libertarei.” ");
INSERT INTO porblt_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Eles continuaram insistindo com altos gritos, exigindo que ele fosse crucificado. A gritaria deles foi bem sucedida, ");
INSERT INTO porblt_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","e Pilatos deu a sentença que eles tanto queriam. ");
INSERT INTO porblt_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ele libertou o homem preso por rebelião e assassinato, mas enviou Jesus para ser morto, de acordo com as exigências deles. ");
INSERT INTO porblt_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Quando os soldados o levavam embora, eles agarraram um homem chamado Simão, da cidade de Cirene, que estava voltando dos campos. Eles colocaram a cruz nele e o fizeram carregá-la atrás de Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Uma grande multidão o seguiu, juntamente com as mulheres, que choravam e se lamentavam por ele. ");
INSERT INTO porblt_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus se virou para elas e disse: “Filhas de Jerusalém, não chorem por mim! Chorem por si mesmas e por seus filhos. ");
INSERT INTO porblt_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Pois está chegando o momento em que eles dirão: ‘Felizes as mulheres que não têm filhos, as que nunca engravidaram e as que não amamentam.’ ");
INSERT INTO porblt_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Eles dirão para os montes: ‘Caiam sobre nós!’; e dirão para as colinas: ‘Cubram-nos!’ ");
INSERT INTO porblt_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pois, se eles fazem isso com a madeira que está verde, imagine o que não farão quando ela estiver seca!” ");
INSERT INTO porblt_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Eles também levaram dois outros criminosos para serem executados com Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Quando chegaram ao lugar chamado Caveira, crucificaram Jesus juntamente com os criminosos. Um deles ficou à direita de Jesus e o outro, a sua esquerda. ");
INSERT INTO porblt_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesus disse: “Pai, por favor, perdoe essas pessoas, pois elas não sabem o que fazem!” Eles dividiram as suas roupas, apostando com os dados para ver quem ficaria com qual peça de roupa. ");
INSERT INTO porblt_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","As pessoas ficaram paradas, olhando, enquanto os líderes ridicularizavam Jesus. Eles disseram: “Ele salvou os outros! Pois então, deixem que ele mesmo se salve, se ele for realmente o Messias de Deus, o Escolhido.” ");
INSERT INTO porblt_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Os soldados também zombaram dele, aproximando-se dele e oferecendo vinagre de vinho, dizendo: ");
INSERT INTO porblt_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Se você é o Rei dos Judeus, então, salve-se!” ");
INSERT INTO porblt_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na cruz, acima da cabeça de Jesus, foi colocada uma placa, que dizia: “Este é o Rei dos Judeus.” ");
INSERT INTO porblt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Um dos criminosos que estava crucificado se juntou ao outros, insultando Jesus. Ele disse: “Você não é o Messias?” “Então, salve a si mesmo e a nós também!” ");
INSERT INTO porblt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mas, o outro criminoso discordou e discutiu com ele, dizendo: “Você não teme a Deus mesmo quando está sofrendo a mesma punição? ");
INSERT INTO porblt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Para nós, a sentença é justa, pois estamos sendo punidos por algo que realmente fizemos. Mas esse homem não fez nada de errado.” ");
INSERT INTO porblt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Então, ele disse: “Jesus, por favor, lembre-se de mim quando você entrar em seu Reino!” ");
INSERT INTO porblt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus respondeu: “Eu lhe prometo hoje: você estará comigo no paraíso.” ");
INSERT INTO porblt_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Neste momento, já era quase meio-dia e toda a terra ficou na escuridão até às três horas da tarde. ");
INSERT INTO porblt_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","A luz do sol se escondeu, e a cortina do Templo rasgou-se em duas partes. ");
INSERT INTO porblt_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesus gritou bem alto: “Pai, eu me entrego em suas mãos!” Assim que disse isso, ele respirou pela última vez. ");
INSERT INTO porblt_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Quando o comandante romano viu o que havia acontecido, louvou a Deus e disse: “Certamente, esse homem era inocente!” ");
INSERT INTO porblt_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Quando todas as pessoas que tinham vindo para assistir a punição viram o que havia contecido, foram embora, batendo no peito, para demonstrar sua tristeza. ");
INSERT INTO porblt_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mas, todas as pessoas que conheciam Jesus, incluindo as mulheres que o seguiram desde a Galileia, olhavam a certa distância. ");
INSERT INTO porblt_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Havia um homem, chamado José, que era bom e honesto. Ele era membro do conselho superior, ");
INSERT INTO porblt_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","mas não havia concordado com as decisões e as ações tomadas pelos outros membros. Ele era natural da cidade de Arimateia, na região da Judeia, e esperava com ansiedade pelo Reino de Deus. ");
INSERT INTO porblt_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","José foi até Pilatos e lhe pediu o corpo de Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Então, ele desceu o corpo de Jesus da cruz e o enrolou num lençol de linho. Ele colocou o corpo de Jesus em um túmulo que nunca tinha sido usado, cavado na rocha. ");
INSERT INTO porblt_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Aquele era o dia da preparação, e o sábado logo chegaria. ");
INSERT INTO porblt_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","As mulheres que tinham vindo da Galileia com Jesus seguiram José e viram onde ficava o túmulo em que o corpo de Jesus havia sido colocado. ");
INSERT INTO porblt_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Elas voltaram para casa para prepararem perfumes e óleos. Mas, no sábado, elas descansaram, seguindo o mandamento. ");
INSERT INTO porblt_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Muito cedo no primeiro dia da semana, as mulheres foram até o túmulo, levando os perfumes que haviam preparado. ");
INSERT INTO porblt_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Elas viram que a pedra que fechava a entrada do túmulo havia sido retirada. ");
INSERT INTO porblt_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mas, ao entrarem, não encontraram o corpo do Senhor Jesus. ");
INSERT INTO porblt_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Enquanto pensavam sobre o que havia acontecido, apareceram, de repente, dois homens, vestidos com roupas muito brilhantes. ");
INSERT INTO porblt_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","As mulheres ficaram aterrorizadas e se curvaram, colocando seus rostos no chão. Eles disseram às mulheres: “Por que vocês estão procurando entre os mortos aquele que está vivo? ");
INSERT INTO porblt_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ele não está aqui. Ele ressuscitou! Lembrem-se do que ele lhes disse, enquanto vocês ainda estavam na Galileia: ");
INSERT INTO porblt_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘O Filho do Homem deve ser entregue nas mãos dos homens maus. Ele deve ser crucificado. E no terceiro dia ressuscitará.’” ");
INSERT INTO porblt_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Então, elas se lembraram do que Jesus havia dito. ");
INSERT INTO porblt_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Quando voltaram do túmulo, disseram tudo o que tinha acontecido aos onze discípulos e para todos os outros que lá estavam. ");
INSERT INTO porblt_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","As mulheres que disseram aos apóstolos o que havia acontecido foram Maria Madalena, Joana, Maria, mãe de Tiago, e outras mulheres que estavam com elas. ");
INSERT INTO porblt_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mas, isso tudo não fazia sentido para eles; então, não acreditaram no que as mulheres tinham dito. ");
INSERT INTO porblt_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","No entanto, Pedro se levantou e correu até o túmulo. Ele se abaixou e olhou para dentro e viu apenas o lençol de linho na sepultura. Depois, ele voltou para casa, pensando sobre o que havia acontecido. ");
INSERT INTO porblt_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","No mesmo dia, dois discípulos estavam caminhando para uma vila chamada Emaús, cerca de onze quilômetros de distância de Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Eles conversavam sobre o que havia acontecido. ");
INSERT INTO porblt_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Enquanto debatiam sobre isso, Jesus surgiu e começou a caminhar com eles. ");
INSERT INTO porblt_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mas eles, por algum motivo, não o reconheceram. ");
INSERT INTO porblt_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesus lhes perguntou: “O que vocês estão discutindo, enquanto caminham?” Eles pararam e seus rostos estavam tristes. ");
INSERT INTO porblt_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Um deles, chamado Cleopas, respondeu: “Você está apenas de passagem por Jerusalém? Talvez, você seja a única pessoa que não sabe sobre as coisas que aconteceram nos últimos dias.” ");
INSERT INTO porblt_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Que coisas?” Jesus perguntou. Eles responderam: “Sobre Jesus de Nazaré. Ele foi um profeta que falava com autoridade e realizou grandes milagres diante de Deus e de todas as pessoas. ");
INSERT INTO porblt_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mas, nossos grandes sacerdotes e líderes o entregaram para ser condenado à morte e, então, ele foi crucificado. ");
INSERT INTO porblt_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nós tínhamos esperança de que ele fosse aquele que tivesse vindo para salvar Israel. Faz três dias que tudo isso aconteceu. ");
INSERT INTO porblt_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mas depois, algumas mulheres em nosso grupo nos surpreenderam. ");
INSERT INTO porblt_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ao amanhecer, elas foram ao túmulo e não encontraram o corpo de Jesus. Elas voltaram, dizendo que tiveram uma visão de anjos, que lhes disseram que Jesus está vivo. ");
INSERT INTO porblt_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Fomos até o túmulo e encontramos tudo exatamente como as mulheres tinham dito. Mas, não o vimos.” ");
INSERT INTO porblt_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesus lhes disse: “Como vocês são cegos! Como são lentos em acreditar em tudo o que os profetas disseram! ");
INSERT INTO porblt_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","O Messias não tinha que sofrer, antes que pudesse receber toda a sua glória?” ");
INSERT INTO porblt_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Então, começando pelos livros de Moisés e passando por todos os profetas, ele explicou àqueles discípulos tudo o que estava escrito nas Sagradas Escrituras que falava sobre ele. ");
INSERT INTO porblt_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Quando eles se aproximaram da vila para onde seguiam, Jesus continuou a caminhar como se fosse para um lugar mais adiante. ");
INSERT INTO porblt_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mas, eles insistiram com ele, dizendo: “Por favor, venha e fique conosco! Está ficando tarde, e a noite está quase chegando.” Então, Jesus ficou com eles. ");
INSERT INTO porblt_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Quando se sentou para comer com eles, Jesus pegou o pão e deu graças a Deus. Depois, partiu o pão e deu a eles. ");
INSERT INTO porblt_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Então, seus olhos foram abertos e eles reconheceram Jesus. Depois, ele desapareceu da vista deles. ");
INSERT INTO porblt_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Os dois discípulos disseram um para o outro: “Os nossos pensamentos não pareciam estar em chamas, enquanto ele conversava e nos explicava as Sagradas Escrituras?” ");
INSERT INTO porblt_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Eles se levantaram imediatamente e voltaram para Jerusalém. Lá, encontraram os onze discípulos, além de outras pessoas que estavam reunidas com eles, ");
INSERT INTO porblt_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","que diziam: “O Senhor realmente ressuscitou! Ele apareceu a Simão.” ");
INSERT INTO porblt_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Depois, os dois discípulos, que haviam acabado de chegar, contaram para os outros discípulos o que havia acontecido na estrada e como tinham reconhecido Jesus quando ele partiu o pão. ");
INSERT INTO porblt_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Enquanto conversavam, o próprio Jesus apareceu no meio deles e disse: “Paz para vocês!” ");
INSERT INTO porblt_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Eles ficaram espantados e assustados, pensando ter visto um fantasma. ");
INSERT INTO porblt_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ele lhes perguntou: “Por que vocês estão com medo? Por que estão duvidando? ");
INSERT INTO porblt_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Olhem para as minhas mãos e para os meus pés. Vejam! Sou eu. Toquem em mim e vocês terão certeza, pois um espírito não é feito de carne e ossos, como vocês estão vendo que eu tenho?” ");
INSERT INTO porblt_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ao dizer isso, Jesus lhes mostrou as mãos e os pés. ");
INSERT INTO porblt_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mas, eles ainda não acreditavam, porque estavam muito animados e maravilhados. Ele lhes perguntou: “Vocês têm alguma coisa para eu comer?” ");
INSERT INTO porblt_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Eles lhe deram um pedaço de peixe assado. ");
INSERT INTO porblt_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Então, ele pegou o peixe e o comeu na frente deles. ");
INSERT INTO porblt_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Depois, Jesus lhes disse: “Foi isso que eu lhes expliquei enquanto ainda estávamos juntos. Tudo o que foi escrito sobre mim na Lei de Moisés, nos livros dos Profetas e nos Salmos precisava acontecer.” ");
INSERT INTO porblt_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Então, ele abriu as mentes deles para que fossem capazes de entender as Sagradas Escrituras. ");
INSERT INTO porblt_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ele lhes disse: “Assim está escrito que o Messias sofreria e ressuscitaria no terceiro dia. E em seu nome, ");
INSERT INTO porblt_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","o arrependimento para o perdão dos pecados seria anunciado para todas as nações, começando por Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Vocês são testemunhas de tudo isso. ");
INSERT INTO porblt_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Agora, eu irei lhes mandar o que o meu Pai prometeu, mas, esperem na cidade até que tenham recebido o poder do céu.” ");
INSERT INTO porblt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Então, ele os levou para fora da cidade e, quando se aproximaram de Betânia, Jesus levantou as suas mãos e os abençoou. ");
INSERT INTO porblt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Enquanto os abençoava, se afastou deles e foi levado para o céu. ");
INSERT INTO porblt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Eles o adoraram e depois voltaram cheios de alegria para Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Eles estavam sempre no Templo, louvando a Deus. ");
INSERT INTO porblt_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","No começo, aquele que é a Palavra já existia. Ele estava com Deus e era Deus. ");
INSERT INTO porblt_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","No início, ele estava com Deus. ");
INSERT INTO porblt_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Todas as coisas foram feitas por intermédio dele. Sem ele, nada do que existe teria sido feito. ");
INSERT INTO porblt_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A vida estava nele, a vida que era a luz de todos. ");
INSERT INTO porblt_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","A luz brilha nas trevas, e as trevas não a apagaram. ");
INSERT INTO porblt_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Deus enviou um homem, chamado João. ");
INSERT INTO porblt_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ele veio como uma testemunha para explicar sobre a luz para que, por meio dele, todos acreditassem na mensagem. ");
INSERT INTO porblt_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","João não era a luz, mas ele veio falar a respeito da luz. ");
INSERT INTO porblt_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","A luz verdadeira veio ao mundo para iluminar todas as pessoas. ");
INSERT INTO porblt_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ele estava no mundo e, apesar do mundo ter sido feito por meio dela, o mundo não a conheceu. ");
INSERT INTO porblt_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ele romveio para o seu próprio povo, mas eles não o aceitaram. ");
INSERT INTO porblt_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mas, para todas as pessoas que o aceitaram e creram nele, ele deu o direito de se tornarem filhos de Deus. ");
INSERT INTO porblt_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Esses são os filhos nascidos não da maneira convencional, não como o resultado do desejo humano ou da decisão de um pai, mas nascidos de Deus. ");
INSERT INTO porblt_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ele se tornou um ser humano e viveu entre nós, e vimos a sua glória, a glória do Filho único do Pai, cheio de graça e de verdade. ");
INSERT INTO porblt_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","João deu o seu testemunho a respeito dele, dizendo: “Este é aquele sobre quem eu lhes falei quando eu disse: ‘Aquele que virá depois de mim é mais importante do que eu, pois ele já existia antes de mim.’” ");
INSERT INTO porblt_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Todos nós somos beneficiados por sua natureza generosa, presenteando-nos com bênçãos e mais bênçãos. ");
INSERT INTO porblt_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","A lei foi dada por Moisés. A graça e a verdade vieram por meio de Jesus Cristo. ");
INSERT INTO porblt_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","E embora ninguém nunca tenha visto Deus, apenas o Filho único, que está próximo ao Pai, mostrou-nos quem é Deus. ");
INSERT INTO porblt_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Foi isso que João afirmou publicamente, quando os anciãos do povo enviaram sacerdotes e levitas de Jerusalém para lhe perguntar: “Quem é você?” ");
INSERT INTO porblt_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","João disse alto e claro, sem hesitar: “Eu não sou o Messias.” ");
INSERT INTO porblt_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Eles perguntaram: “Então, quem é você? Elias?” Ele respondeu: “Não, não sou.” “Você é o Profeta?” João respondeu: “Não.” ");
INSERT INTO porblt_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Eles perguntaram: “Bem, então, quem é você? Precisamos dar uma resposta para aqueles que nos enviaram. O que tem a dizer sobre você?” ");
INSERT INTO porblt_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","23 Usando as palavras do profeta Isaías, ele disse: “Eu sou uma voz, gritando no deserto: ‘Preparem um caminho reto para o Senhor!’” ");
INSERT INTO porblt_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Os sacerdotes e levitas, enviados pelos fariseus, ");
INSERT INTO porblt_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","perguntaram-lhe: “Por que, então, você está batizando se você não é o Messias, nem Elias ou o Profeta?” ");
INSERT INTO porblt_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","João respondeu: “Eu batizo com água, mas, no meio de vocês está alguém que vocês não conhecem. ");
INSERT INTO porblt_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ele vem depois de mim, mas eu não sou digno nem mesmo de tirar as suas sandálias.” ");
INSERT INTO porblt_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tudo isso aconteceu no povoado de Betânia, do outro lado do rio Jordão, onde João estava batizando as pessoas. ");
INSERT INTO porblt_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","No dia seguinte, João viu Jesus se aproximando e disse: “Aí está o Cordeiro de Deus, que tira o pecado do mundo! ");
INSERT INTO porblt_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","É sobre ele que eu falava, quando disse: ‘Um homem que vem depois de mim é mais importante do que eu, pois ele já existia antes de mim.’ ");
INSERT INTO porblt_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Eu mesmo não sabia quem ele era, mas eu vim batizando com água para que ele pudesse ser revelado a Israel.” ");
INSERT INTO porblt_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","João continuou seu testemunho sobre Jesus, dizendo: “Eu vi o Espírito descendo do céu como uma pomba e pousando sobre ele. ");
INSERT INTO porblt_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Eu não o teria reconhecido, se Deus, que me enviou para batizar com água, não tivesse me dito: ‘O homem em quem você vir o Espírito descer e pousar é quem batizará com o Espírito Santo.’ ");
INSERT INTO porblt_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Eu vi isso acontecer e afirmo que esse é o Filho de Deus.” ");
INSERT INTO porblt_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","No dia seguinte, João estava lá, parado com dois dos seus discípulos. ");
INSERT INTO porblt_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ele viu Jesus passando e disse: “Aí está o Cordeiro de Deus!” ");
INSERT INTO porblt_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Quando os dois discípulos ouviram o que ele disse, foram atrás de Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus se virou e viu que eles o seguiam. Ele perguntou: “O que vocês estão procurando?” Eles responderam: “Rabi (que significa ‘Mestre’), onde você mora?” ");
INSERT INTO porblt_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ele lhes disse: “Venham e vejam!” Então, eles foram com ele e viram onde Jesus estava morando. Era aproximadamente quatro horas da tarde, e os dois discípulos passaram o restante do dia com Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","André, o irmão de Simão Pedro, era um desses dois discípulos que tinham ouvido o que João Batista dissera, e seguiu Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","A primeira coisa que ele fez foi procurar seu irmão Simão, a quem disse: “Nós encontramos o Messias!” (que significa “Cristo”). ");
INSERT INTO porblt_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ele levou Simão até Jesus. Olhando diretamente para Simão, Jesus disse: “Você é Simão, filho de João. Mas, agora você será chamado de Cefas”, que significa “Pedro”. ");
INSERT INTO porblt_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","No dia seguinte, Jesus decidiu ir para a Galileia. Lá, ele encontrou Filipe e lhe disse: “Siga-me!” ");
INSERT INTO porblt_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipe era de Betsaida, a mesma cidade de André e Pedro. ");
INSERT INTO porblt_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipe encontrou Natanael e lhe disse: “Nós encontramos aquele a respeito de quem Moisés escreveu na lei e sobre quem os profetas também falaram, Jesus de Nazaré, o filho de José.” ");
INSERT INTO porblt_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“De Nazaré? E algo bom pode vir de lá?”, perguntou Natanael. Filipe respondeu: “Apenas venha e veja!” ");
INSERT INTO porblt_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Quando Jesus viu Natanael se aproximando, disse a respeito dele: “Vejam! Aqui está um verdadeiro israelita! Não há falsidade nele.” ");
INSERT INTO porblt_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael perguntou: “Como você sabe quem eu sou?” Jesus respondeu: “Eu o vi debaixo da figueira, antes de Filipe chamá-lo.” ");
INSERT INTO porblt_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael exclamou: “Rabi, você é o Filho de Deus, o rei de Israel!” ");
INSERT INTO porblt_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","“Você acredita nisso só porque eu disse que eu o vi debaixo da figueira?” Jesus respondeu. “Você verá muito mais do que isso!” ");
INSERT INTO porblt_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Então, Jesus disse: “Eu lhes digo que isto é verdade: vocês todos irão ver o céu aberto e os anjos de Deus subindo e descendo sobre o Filho do Homem.” ");
INSERT INTO porblt_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dois dias depois, houve uma festa de casamento em uma vila chamada Caná, na Galileia. A mãe de Jesus estava lá. ");
INSERT INTO porblt_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus e os seus discípulos também foram convidados para o casamento. ");
INSERT INTO porblt_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","O vinho acabou. Então, a mãe de Jesus lhe disse: “Eles não têm mais vinho para servir para os convidados.” ");
INSERT INTO porblt_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ele respondeu: “Mãe, por que a senhora me diz o que fazer? Ainda não chegou a minha hora.” ");
INSERT INTO porblt_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","A sua mãe disse aos empregados: “Façam tudo que ele lhes disser!” ");
INSERT INTO porblt_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ali perto havia seis potes de pedra, usados pelos judeus para as purificações cerimoniais. Em cada um deles era possível colocar de setenta e cinco a cento e treze litros de água. ");
INSERT INTO porblt_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus disse aos empregados: “Encham os potes com água!” Então, eles encheram os potes até a boca. ");
INSERT INTO porblt_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Depois, Jesus disse: “Tirem um pouco da água e levem para o mestre de cerimônias.” Os empregados fizeram como Jesus ordenara. ");
INSERT INTO porblt_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","O mestre de cerimônias não sabia de onde aquilo tinha vindo; apenas os empregados sabiam. Mas, quando ele provou a água que tinha virado vinho, chamou o noivo e disse: ");
INSERT INTO porblt_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Todos servem o melhor vinho primeiro e, depois de os convidados terem bebido bastante, eles servem o vinho comum. Mas você continua a servir o melhor vinho até o fim da festa!” ");
INSERT INTO porblt_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Esse foi o primeiro dos sinais milagrosos de Jesus, e foi realizado em Caná, na região da Galileia. Aqui, ele revelou a sua glória, e os seus discípulos creram nele. ");
INSERT INTO porblt_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Depois disso, Jesus foi para Cafarnaum com sua mãe, seus irmãos e seus discípulos, onde ficaram por alguns dias. ");
INSERT INTO porblt_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Como já estava próximo o dia da Páscoa dos judeus, Jesus foi para Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","No Templo, ele encontrou pessoas vendendo bois, ovelhas e pombos, além de pessoas sentadas as suas mesas, trocando dinheiro. ");
INSERT INTO porblt_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ele fez um chicote de cordas e expulsou todos eles do Templo, juntamente com as ovelhas e os bois. Ele também espalhou as moedas dos que trocavam dinheiro e virou as suas mesas. ");
INSERT INTO porblt_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jesus ordenou aos vendedores de pombas: “Tirem essas coisas daqui! Não transformem a casa do meu Pai em um mercado!” ");
INSERT INTO porblt_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Os seus discípulos se lembraram da passagem das Sagradas Escrituras que diz: “O cuidado que tenho por sua casa é como uma chama queimando dentro de mim!” ");
INSERT INTO porblt_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Os anciãos do povo reagiram, perguntando a Jesus: “Que direito você tem de fazer isso? Faça um milagre para nos provar a sua autoridade!” ");
INSERT INTO porblt_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus respondeu: “Destruam este Templo e em três dias eu o reconstruirei!” ");
INSERT INTO porblt_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Os anciãos do povo responderam: “Foram precisos quarenta e seis anos para construir este Templo, e você o irá reconstruir em três dias?” ");
INSERT INTO porblt_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mas, o Templo ao qual Jesus se referia era o seu próprio corpo. ");
INSERT INTO porblt_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Depois de sua ressurreição, os seus discípulos se lembraram do que ele tinha dito e, então, creram nas Sagradas Escrituras e nas próprias palavras de Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Como consequência dos milagres que Jesus fez enquanto ainda estava em Jerusalém, durante a Páscoa, muitas pessoas creram nele. ");
INSERT INTO porblt_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mas, Jesus não confiava nelas, pois ele conhecia muito bem as pessoas. ");
INSERT INTO porblt_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ele não precisava de que ninguém lhe dissesse a respeito da natureza humana, porque ele sabia o que as pessoas pensavam. ");
INSERT INTO porblt_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Havia um fariseu chamado Nicodemos, membro do conselho superior judeu. ");
INSERT INTO porblt_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Certa noite, ele foi ao lugar em que Jesus estava e disse: “Rabi, nós sabemos que você é um mestre enviado por Deus, pois ninguém pode fazer os milagres que você faz se Deus não estiver com ele.” ");
INSERT INTO porblt_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus respondeu: “Eu lhe digo que isto é verdade: a não ser que tenha renascido, você não poderá vivenciar o Reino de Deus.” ");
INSERT INTO porblt_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“Como pode um homem velho nascer de novo?”, Nicodemos perguntou. “Não é possível voltar para o útero de sua mãe e nascer uma segunda vez.” ");
INSERT INTO porblt_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus lhe disse: “Eu lhe digo que isto é verdade: você não pode entrar no Reino de Deus, a não ser que nasça da água e do Espírito. ");
INSERT INTO porblt_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Quem nasce da carne é um ser de natureza humana, e quem nasce do Espírito é um ser de natureza espiritual. ");
INSERT INTO porblt_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Não fique surpreso por eu lhe dizer que todos vocês devem nascer de novo. ");
INSERT INTO porblt_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","O vento sopra onde quer, você consegue ouvi-lo, mas não sabe de onde vem e nem para onde vai. O mesmo acontece com todas as pessoas que nascem do Espírito.” ");
INSERT INTO porblt_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Como isso é possível?”, Nicodemos perguntou. ");
INSERT INTO porblt_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus respondeu: “Você é um importante mestre em Israel e, ainda assim, não entende isso?”, Jesus respondeu. ");
INSERT INTO porblt_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","“Eu lhe digo que isto é verdade: nós falamos sobre o que sabemos e damos provas em relação ao que vimos, mas vocês se recusam a aceitar o nosso testemunho. ");
INSERT INTO porblt_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Se vocês não creem no que eu digo quando eu falo sobre as coisas deste mundo, como poderiam acreditar no que eu falo se eu contasse a vocês sobre as coisas do céu? ");
INSERT INTO porblt_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ninguém subiu ao céu, a não ser o Filho do Homem, que desceu do céu. ");
INSERT INTO porblt_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Exatamente como Moisés levantou a serpente no deserto, assim o Filho do Homem deve ser levantado, ");
INSERT INTO porblt_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","para que todos os que acreditam nele tenham a vida eterna. ");
INSERT INTO porblt_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pois Deus amou tanto o mundo, que deu o seu único Filho, para que todos os que acreditam nele não morram, mas, sim, tenham a vida eterna. ");
INSERT INTO porblt_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Deus não mandou o Filho ao mundo para condená-lo, mas para que o mundo encontre a salvação por meio dele. ");
INSERT INTO porblt_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","As pessoas que creem nele não são condenadas; ao passo que, os que não creem nele são condenados, pois eles não acreditam no único Filho de Deus. ");
INSERT INTO porblt_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","É assim que os casos são decididos: a luz veio ao mundo, mas as pessoas amaram mais as trevas do que a luz, pois as suas ações eram más. ");
INSERT INTO porblt_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Todos aqueles que fazem o mal odeiam a luz e se afastam dela, porque eles não querem que as suas ações sejam mostradas. ");
INSERT INTO porblt_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mas, as pessoas que fazem o bem vão para a luz, para que as suas ações, que são realizadas de acordo com a vontade de Deus, sejam reveladas.” ");
INSERT INTO porblt_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Depois disso, Jesus e seus discípulos foram para a Judeia e passaram algum tempo lá batizando as pessoas. ");
INSERT INTO porblt_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","João também estava batizando em Enom, perto de Salim, porque lá havia muita água e as pessoas continuavam a chegar para serem batizadas. ");
INSERT INTO porblt_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Isso foi antes de João Batista ser preso.) ");
INSERT INTO porblt_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Surgiu uma discussão entre os discípulos de João e os judeus em relação à purificação cerimonial. ");
INSERT INTO porblt_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Eles foram até João e lhe disseram: “Rabi, o homem com quem você estava no outro lado do rio Jordão, para quem deu o seu apoio, agora está batizando e todos estão indo até ele!” ");
INSERT INTO porblt_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","João respondeu: “Uma pessoa só recebe o que é dado pelo céu. ");
INSERT INTO porblt_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Vocês mesmos são testemunhas de que eu disse: ‘Eu não sou o Messias. Eu fui enviado para preparar o caminho dele.’ ");
INSERT INTO porblt_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Em um casamento, a noiva pertence ao noivo. O padrinho espera, escutando o que o noivo tem a falar e fica muito feliz ao ouvir a voz do noivo. A minha felicidade está agora igualmente completa. ");
INSERT INTO porblt_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ele deve se tornar mais importante, e a minha importância vai diminuir na mesma proporção.” ");
INSERT INTO porblt_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Aquele que vem de cima é mais importante do que tudo. Quem vem da terra pertence à terra e fala sobre as coisas terrenas. Quem vem do céu é mais importante do que tudo. ");
INSERT INTO porblt_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ele dá provas em relação ao que viu e ouviu, mas ninguém aceita o que ele diz. ");
INSERT INTO porblt_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Entretanto, aquele que aceita o que ele fala confirma que Deus é verdadeiro. ");
INSERT INTO porblt_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pois aquele que Deus enviou fala as palavras de Deus, porque Deus lhe dá o Espírito sem limitações. ");
INSERT INTO porblt_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","O Pai ama o Filho e colocou tudo em suas mãos. ");
INSERT INTO porblt_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Quem crê no Filho tem a vida eterna. Porém, quem se recusar a crer no Filho não terá a vida eterna, mas sofrerá o castigo de Deus. ");
INSERT INTO porblt_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Quando Jesus soube que os fariseus tinham ouvido dizer que ele estava conseguindo e batizando mais discípulos do que João, ");
INSERT INTO porblt_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(embora não fosse Jesus quem batizasse e, sim, os seus discípulos), ");
INSERT INTO porblt_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ele foi embora da Judeia e voltou para a Galileia. ");
INSERT INTO porblt_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","No caminho, passou pela região da Samaria. ");
INSERT INTO porblt_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Assim, chegou a uma cidade da Samaria, chamada Sicar, próxima às terras que Jacó tinha dado para o seu filho José. ");
INSERT INTO porblt_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","O poço de Jacó estava lá, e Jesus, que já estava cansado da viagem, sentou-se perto do poço. Isso aconteceu por volta do meio-dia. ");
INSERT INTO porblt_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Uma mulher samaritana veio buscar água. Jesus lhe disse: “Por favor, você poderia me dar um pouco de água?”, ");
INSERT INTO porblt_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","pois os seus discípulos tinham ido à cidade para comprar comida. ");
INSERT INTO porblt_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","“Você é judeu e eu sou uma mulher samaritana. Então, como me pede água?”, a mulher respondeu, pois os judeus não se relacionavam com os samaritanos. ");
INSERT INTO porblt_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus lhe respondeu: “Se você ao menos reconhecesse o que Deus dá e quem está pedindo água, você lhe pediria, e ele lhe daria a água da vida.” ");
INSERT INTO porblt_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Mas o senhor não tem um balde para tirar a água e o poço é fundo. Como o senhor vai tirar essa água da vida?”, ela perguntou. ");
INSERT INTO porblt_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","“O nosso pai Jacó nos deu o poço. Ele próprio bebeu de sua água, assim como os seus filhos e o seu rebanho. Você é mais importante do que ele?” ");
INSERT INTO porblt_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus respondeu: “Quem beber da água deste poço terá sede novamente. ");
INSERT INTO porblt_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mas, aquele que beber da água que eu lhe der nunca mais sentirá sede. A água que eu lhe der se tornará nele uma fonte de água e trará a vida eterna a essa pessoa.” ");
INSERT INTO porblt_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","A mulher respondeu: “Senhor, por favor, dê essa água para mim, para que eu não tenha mais sede e não precise mais ter que vir até aqui buscar água!” ");
INSERT INTO porblt_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus lhe disse: “Vá, chame o seu marido e voltem aqui!” ");
INSERT INTO porblt_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","A mulher respondeu: “Eu não tenho marido.” Jesus lhe disse: “Você está certa ao dizer que não tem marido. ");
INSERT INTO porblt_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Você já teve cinco maridos. E aquele que mora com você agora não é, de fato, seu marido. Então, o que você diz é verdade.” ");
INSERT INTO porblt_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","A mulher disse: “Senhor, posso ver que você é um profeta! ");
INSERT INTO porblt_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Diga-me: nossos ancestrais adoravam a Deus aqui neste monte, mas vocês dizem que Jerusalém é o lugar onde nós devemos adorar a Deus.” ");
INSERT INTO porblt_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus respondeu: “Mulher, acredite no que eu digo: está chegando o tempo em que você não irá adorar o Pai nem aqui neste monte e nem em Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Vocês, samaritanos, realmente não conhecem o Deus que adoram. Enquanto nós adoramos o Deus que conhecemos, porque a salvação vem dos judeus. ");
INSERT INTO porblt_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mas, está chegando a hora, e de fato já chegou, em que os verdadeiros adoradores irão adorar o Pai em espírito e em verdade, pois são esses que o Pai quer que o adorem. ");
INSERT INTO porblt_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Deus é Espírito; por isso os adoradores devem adorá-lo em espírito e em verdade.” ");
INSERT INTO porblt_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A mulher disse: “Bem, eu sei que o Messias (chamado Cristo) está chegando. Quando ele vier, explicará tudo isso para nós.” ");
INSERT INTO porblt_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus respondeu: “EU SOU – eu que estou falando com você.” ");
INSERT INTO porblt_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Exatamente, neste momento, os discípulos voltaram da cidade. Eles ficaram surpresos por Jesus estar conversando com uma mulher, mas nenhum deles perguntou: “O que você está fazendo?”, ou: “Por que você está conversando com ela?” ");
INSERT INTO porblt_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A mulher deixou o seu pote com água para trás e voltou correndo para a cidade, onde disse para as pessoas: ");
INSERT INTO porblt_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Venham ver um homem que me disse tudo o que eu tenho feito! Será que ele é o Messias?” ");
INSERT INTO porblt_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Então, as pessoas saíram da cidade para ir até onde Jesus estava. ");
INSERT INTO porblt_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nesse meio tempo, os discípulos de Jesus insistiam com ele: “Rabi, por favor, coma alguma coisa!” ");
INSERT INTO porblt_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mas Jesus respondeu: “Eu tenho algo para comer que vocês não conhecem.” ");
INSERT INTO porblt_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Os discípulos se perguntaram: “Será que alguém trouxe comida para ele?” ");
INSERT INTO porblt_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus lhes disse: “Meu alimento é fazer a vontade daquele que me enviou e completar o seu trabalho. ");
INSERT INTO porblt_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Vocês não costumam dizer que ‘daqui a quatro meses teremos a colheita?’ Abram seus olhos e vejam em volta! As plantações nos campos estão maduras, prontas para serem colhidas. ");
INSERT INTO porblt_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Quem colhe está sendo pago e está colhendo, como resultado do seu trabalho, a vida eterna. Dessa forma, tanto aquele que semeia quanto aquele que colhe poderão comemorar juntos. ");
INSERT INTO porblt_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Então, é verdadeiro o provérbio que diz: ‘Um semeia e o outro colhe.’ ");
INSERT INTO porblt_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Eu mandei vocês para colherem o que não plantaram. Outros trabalharam duro e vocês colhem os benefícios do que eles fizeram.” ");
INSERT INTO porblt_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Muitos samaritanos daquela cidade creram em Jesus por causa do que a mulher lhes disse: “Ele me disse tudo o que tenho feito.” ");
INSERT INTO porblt_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Assim, quando eles vieram vê-lo, imploraram para que ele ficasse com eles. Jesus ficou lá por dois dias. ");
INSERT INTO porblt_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","E muitas outras pessoas acreditaram nele pelas palavras que ele dizia. ");
INSERT INTO porblt_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","As pessoas disseram para a mulher: “Agora, a nossa fé nele não é apenas por causa do que você nos disse, mas, também, pelo que nós mesmos ouvimos dele. Nós temos certeza de que ele é o Salvador no mundo.” ");
INSERT INTO porblt_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Depois dos dois dias, ele continuou sua viagem para a Galileia. ");
INSERT INTO porblt_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesus havia comentado que um profeta não é respeitado em sua própria terra. ");
INSERT INTO porblt_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mas, quando ele chegou na Galileia, as pessoas o receberam muito bem. Elas também estiveram na comemoração da Páscoa em Jerusalém e tinham visto tudo o que ele havia feito por lá. ");
INSERT INTO porblt_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesus visitou novamente Caná, na Galileia, onde ele tinha transformado água em vinho na festa de casamento. E, próximo da cidade de Cafarnaum, vivia um funcionário do rei, cujo filho estava muito doente. ");
INSERT INTO porblt_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Quando ele ouviu que Jesus tinha voltado da Judeia para a Galileia, foi encontrá-lo. O homem implorou para que Jesus o acompanhasse até sua casa e curasse seu filho, que já estava quase morrendo. ");
INSERT INTO porblt_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus disse: “Vocês só têm fé quando veem os sinais e os milagres.” ");
INSERT INTO porblt_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","O funcionário do rei implorou: “Senhor, por favor, apenas venha comigo antes que o meu filho morra!” ");
INSERT INTO porblt_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus lhe disse: “Vá para casa! O seu filho irá viver.” O homem confiou no que Jesus disse e foi embora. ");
INSERT INTO porblt_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Enquanto ele estava no caminho de casa, os seus empregados o encontraram e lhe disseram que o seu filho estava vivo e se recuperando. ");
INSERT INTO porblt_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ele, então, perguntou a que horas o seu filho tinha começado a melhorar. Os empregados disseram: “Ontem, à uma hora da tarde, a febre passou.” ");
INSERT INTO porblt_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","O homem percebeu que foi exatamente nesse horário que Jesus lhe dissera: “O seu filho irá viver!” A partir daí, ele e todos em sua casa tiveram fé em Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Esse foi o segundo milagre que Jesus fez, após voltar da Judeia para a Galileia. ");
INSERT INTO porblt_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Depois disso, Jesus foi para Jerusalém, por causa de uma festa dos judeus. ");
INSERT INTO porblt_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Próximo ao Portão das Ovelhas, em Jerusalém, havia um tanque com cinco entradas ao seu redor. Em hebraico, esse tanque era chamado de Betezata. ");
INSERT INTO porblt_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Muitas pessoas doentes estavam deitadas nessas entradas. Eram cegos, mancos, paralíticos, entre outros. ");
INSERT INTO porblt_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Havia um homem que também estava lá, doente há trinta e oito anos. Jesus olhou para ele, já sabendo que o homem estava deitado lá por muito tempo e lhe perguntou: ");
INSERT INTO porblt_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","“Você quer ser curado?” ");
INSERT INTO porblt_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","O homem respondeu: “Senhor, não há ninguém que possa me ajudar a entrar na água quando ela é agitada. Quando eu tento entrar na água, sempre há alguém que passa na minha frente e entra primeiro.” ");
INSERT INTO porblt_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus lhe disse: “Fique em pé, pegue sua esteira e comece a andar!” ");
INSERT INTO porblt_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Imediatamente, o homem foi curado. Ele pegou sua esteira e caminhou. Foi em um sábado que isso aconteceu. ");
INSERT INTO porblt_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Então, os judeus disseram ao homem que havia sido curado: “Hoje é sábado! É contra a lei carregar sua esteira neste dia.” ");
INSERT INTO porblt_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ele respondeu aos judeus: “O homem que me curou disse para que eu pegasse a minha esteira e começasse a andar.” ");
INSERT INTO porblt_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Os judeus perguntaram: “Quem lhe disse para pegar sua esteira e andar?” ");
INSERT INTO porblt_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Porém, ele não tinha ideia de quem era, pois Jesus havia desaparecido no meio da multidão. ");
INSERT INTO porblt_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mais tarde, Jesus encontrou, no Templo, o homem que havia curado e lhe disse: “Veja! Agora você está curado. Então, pare de pecar ou algo pior pode lhe acontecer.” ");
INSERT INTO porblt_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","O homem foi dizer aos judeus que fora Jesus quem o havia curado. ");
INSERT INTO porblt_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Os judeus, então, começaram a perseguir Jesus porque ele estava curando aos sábados. ");
INSERT INTO porblt_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mas, Jesus lhes disse: “Meu Pai ainda está trabalhando, e eu também.” ");
INSERT INTO porblt_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Essa foi a justificativa para os judeus quererem ainda mais matá-lo, porque, além de não obedecer a lei do sábado, também dizia que Deus era seu próprio Pai, fazendo-se, assim, igual a Deus. ");
INSERT INTO porblt_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesus explicou aos judeus: “Eu lhes digo que isto é verdade: o Filho não pode fazer nada por si mesmo. Ele só faz o que vê o Pai fazer. Tudo o que o Pai fizer, o Filho faz também. ");
INSERT INTO porblt_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pois o Pai ama o Filho e mostra para ele tudo o que faz. E o Pai irá mostrar a ele coisas até mais incríveis do que essas e que farão com que vocês fiquem completamente fascinados. ");
INSERT INTO porblt_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Pois exatamente como o Pai dá vida aos que ele ressuscita do mundo dos mortos, o Filho também dá vida para os que ele quer. ");
INSERT INTO porblt_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","O Pai não julga ninguém. Ele deu ao Filho toda a autoridade para julgar, ");
INSERT INTO porblt_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","para que, assim, todos possam respeitar o Filho da mesma maneira que respeitam o Pai. Qualquer pessoa que não respeita o Filho também não respeita o Pai, que o enviou. ");
INSERT INTO porblt_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Eu lhes digo que isto é verdade: quem segue o que eu digo, e tem fé naquele que me enviou, tem a vida eterna. E não será condenado, mas já passou da morte para a vida. ");
INSERT INTO porblt_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Eu lhes digo que isto é verdade: Está chegando o tempo, de fato ele já chegou, quando os mortos ouvirão a voz do Filho de Deus, e aqueles que a ouvirem irão viver! ");
INSERT INTO porblt_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Exatamente como o próprio Pai tem vida em si mesmo também concedeu ao Filho ter vida em si mesmo. ");
INSERT INTO porblt_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","O Pai também lhe deu autoridade de julgar, pois ele é o Filho do Homem. ");
INSERT INTO porblt_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Não fiquem surpresos com isso, pois está chegando o tempo em que todos aqueles que estão mortos ouvirão a sua voz ");
INSERT INTO porblt_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","e sairão dos túmulos. Aqueles que fizeram o bem ressuscitarão para a vida, e aqueles que fizeram o mal ressuscitarão para serem condenados. ");
INSERT INTO porblt_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Eu não posso fazer nada sozinho. Eu julgo com base no que o Pai me diz, e o meu julgamento é correto, pois eu não estou fazendo de acordo com a minha própria vontade e, sim, seguindo a vontade daquele que me enviou. ");
INSERT INTO porblt_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Se eu fizesse declarações a meu favor, elas não teriam valor. ");
INSERT INTO porblt_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mas, é outro que dá provas a meu respeito, e eu sei que o que ele diz sobre mim é verdade. ");
INSERT INTO porblt_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Vocês perguntaram a João sobre mim, e ele disse a verdade. ");
INSERT INTO porblt_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Porém, eu não preciso da aprovação dos homens. Eu estou apenas explicando isso para que vocês sejam salvos. ");
INSERT INTO porblt_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","João era como uma luz que brilhava intensamente e, por um tempo, vocês se alegraram com sua luz. ");
INSERT INTO porblt_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mas, a prova que eu estou dando é muito mais importante do que a de João. Pois estou fazendo o trabalho que o Pai me mandou fazer, ");
INSERT INTO porblt_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","e esta é a prova de que o Pai me enviou. E o próprio Pai que me enviou testemunha a meu favor. Vocês nunca ouviram a sua voz ou viram como ele se parece, ");
INSERT INTO porblt_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","e vocês não aceitam o que ele diz, pois não acreditam naquele que ele enviou. ");
INSERT INTO porblt_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Vocês estudam as Sagradas Escrituras porque pensam que, por meio delas, ganharão a vida eterna. E são exatamente elas que testemunham a meu favor. ");
INSERT INTO porblt_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","E, no entanto, vocês não querem vir até mim para terem vida. ");
INSERT INTO porblt_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Eu não busco a aprovação dos homens. ");
INSERT INTO porblt_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Eu os conheço, e sei que vocês não têm o amor de Deus em seus corações. ");
INSERT INTO porblt_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Pois eu vim com autoridade do meu Pai, e vocês não me aceitam. Mas, se outro vier com sua própria autoridade, então, este vocês o aceitarão. ");
INSERT INTO porblt_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Como vocês podem crer em mim, se procuram elogios uns dos outros e, no entanto, não buscam o elogio do único Deus verdadeiro? ");
INSERT INTO porblt_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mas, não pensem que eu farei acusações contra vocês diante do Pai. Moisés, aquele em quem vocês colocam sua esperança, é quem vai acusá-los. ");
INSERT INTO porblt_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Se vocês realmente acreditassem em Moisés também acreditariam em mim, pois ele escreveu a meu respeito. ");
INSERT INTO porblt_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mas, como não acreditam no que ele escreveu, por que acreditariam no que eu digo?” ");
INSERT INTO porblt_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tempos depois, Jesus foi para o outro lado do mar da Galileia, também conhecido como mar de Tiberíades. ");
INSERT INTO porblt_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Uma grande multidão o estava seguindo, porque eles tinham testemunhado os seus milagres de cura. ");
INSERT INTO porblt_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus subiu a um monte e se sentou lá com os discípulos. ");
INSERT INTO porblt_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Estava chegando o dia da comemoração da Páscoa judaica. ");
INSERT INTO porblt_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Quando Jesus percebeu que havia uma grande multidão vindo para encontrá-lo, perguntou a Filipe: “Onde podemos comprar pão o bastante para alimentar todas essas pessoas?” ");
INSERT INTO porblt_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ele só perguntou isso para ver como Filipe reagiria, pois Jesus já sabia o que ia fazer. ");
INSERT INTO porblt_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","E Filipe respondeu: “Duzentas moedas de prata não comprariam pão o bastante para cada um ter o seu pedaço.” ");
INSERT INTO porblt_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Um dos seus discípulos, André, irmão de Simão Pedro, disse: ");
INSERT INTO porblt_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Há um garoto aqui que tem cinco pães de cevada e dois peixinhos, mas do que adiantaria isso com tantas bocas para alimentar?” ");
INSERT INTO porblt_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus respondeu: “Façam com que todos fiquem sentados!” Havia um grande terreno gramado lá, então, todos se sentaram no chão. Quase cinco mil homens estavam ali. ");
INSERT INTO porblt_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesus pegou os pães, deu graças a Deus e os distribuiu entre os que estavam lá. Então, ele fez o mesmo com os peixes, garantindo que todos tivessem o bastante para ficarem satisfeitos. ");
INSERT INTO porblt_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Depois de todos terem comido, ele disse aos discípulos: “Juntem as sobras, para que nada se perca!” ");
INSERT INTO porblt_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Os discípulos encheram doze cestos com as sobras dos cinco pães de cevada, que as pessoas comeram. ");
INSERT INTO porblt_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Quando as pessoas viram esse milagre, disseram: “Certamente este é o Profeta que devia vir ao mundo!” ");
INSERT INTO porblt_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesus percebeu que eles queriam forçá-lo a se tornar o seu rei, então, saiu e subiu sozinho o monte. ");
INSERT INTO porblt_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","No fim da tarde, os discípulos desceram para o mar, ");
INSERT INTO porblt_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","entraram em um barco e cruzaram as águas em direção à cidade de Cafarnaum. Já era noite e Jesus ainda não tinha se juntado aos discípulos. ");
INSERT INTO porblt_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Um forte vento começou a soprar e o mar ficou muito agitado. ");
INSERT INTO porblt_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Quando o barco já estava a uns cinco ou seis quilômetros longe da costa, eles viram Jesus, caminhando sobre a água, vindo em direção a eles. Eles ficaram muito assustados. ");
INSERT INTO porblt_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesus lhes disse: “Não tenham medo! Sou eu.” ");
INSERT INTO porblt_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Então, eles, com boa vontade, ajudaram Jesus a subir no barco e, imediatamente, chegaram ao lugar para onde queriam ir. ");
INSERT INTO porblt_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","No dia seguinte, a multidão que havia ficado do outro lado do mar notou que havia apenas um barco lá e que Jesus não tinha ido no mesmo barco com os seus discípulos, quando eles saíram. ");
INSERT INTO porblt_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Então, outros barcos chegaram da cidade de Tiberíades, parando perto do lugar em que eles tinham comido pão, que fora abençoado pelo Senhor. ");
INSERT INTO porblt_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Quando a multidão percebeu que nem Jesus e nem os seus discípulos estavam mais lá, eles entraram nos barcos e foram para a cidade de Cafarnaum, para encontrar Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Quando eles encontraram Jesus do outro lado do mar, perguntaram a ele: “Rabi, quando você chegou aqui?” ");
INSERT INTO porblt_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus respondeu: “Eu lhes digo que isto é verdade: vocês estão me procurando porque comeram os pães e ficaram satisfeitos; não porque entenderam os milagres. ");
INSERT INTO porblt_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Não se preocupem com a comida que se estraga; pelo contrário, concentrem-se na comida que dura para a vida eterna e que o Filho do Homem dará a vocês, pois Deus, o Pai, colocou o seu selo de aprovação no Filho.” ");
INSERT INTO porblt_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Então, eles lhe perguntaram: “O que precisamos fazer para realizar o que Deus quer?” ");
INSERT INTO porblt_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus respondeu; “O que Deus quer que vocês façam é ter fé naquele que foi enviado por ele.” ");
INSERT INTO porblt_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Eles perguntaram: “Que milagre o senhor vai realizar para que vejamos e tenhamos fé? O que o senhor é capaz de fazer? ");
INSERT INTO porblt_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Os nossos antepassados comeram o maná no deserto, para cumprir o que as Sagradas Escrituras dizem: ‘Ele lhes deu pão do céu, para que comessem.’” ");
INSERT INTO porblt_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus respondeu: “Eu lhes digo que isto é verdade: não foi Moisés quem lhes deu pão do céu. É o meu Pai quem lhes dá o verdadeiro pão do céu. ");
INSERT INTO porblt_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pois o pão de Deus é aquele que desceu do céu e dá vida ao mundo.” ");
INSERT INTO porblt_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Eles disseram: “Senhor, por favor, sempre nos dê esse pão!” ");
INSERT INTO porblt_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus respondeu: “Eu sou o pão da vida. Todos os que vêm até mim nunca mais passarão fome, e todos os que creem em mim nunca mais terão sede. ");
INSERT INTO porblt_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Porém, como eu expliquei a vocês antes: vocês me veem, mas ainda não têm fé em mim. ");
INSERT INTO porblt_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Todos aqueles que o Pai me dá virão a mim, e eu não rejeitarei nenhum deles. ");
INSERT INTO porblt_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Pois eu desci do céu não para fazer o que eu quero, mas, sim, para fazer o que meu Pai quer. ");
INSERT INTO porblt_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","O que ele quer é que eu não perca ninguém que ele tenha me dado, mas que eu ressuscite todos eles no último dia. ");
INSERT INTO porblt_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","O que o meu Pai quer é que todos que veem o Filho e têm fé nele tenham a vida eterna e, também, que eu os ressuscite no último dia.” ");
INSERT INTO porblt_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Então, os judeus começaram a reclamar de Jesus, por ter dito: “Eu sou o pão que desceu do céu.” ");
INSERT INTO porblt_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Eles disseram: “Este não é Jesus, o filho de José? Nós conhecemos o seu pai e a sua mãe. Então, como ele pode agora nos dizer: ‘Eu desci do céu’?” ");
INSERT INTO porblt_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus disse: “Parem de resmungar uns com os outros! ");
INSERT INTO porblt_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ninguém poderá vir até mim, a não ser aquele que o Pai, que me enviou, me trouxer. E eu irei ressuscitá-lo no último dia. ");
INSERT INTO porblt_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Como os profetas escreveram nas Sagradas Escrituras: ‘Todos serão ensinados por Deus.’ Todos os que escutam o Pai e que aprendem com ele vêm até mim. ");
INSERT INTO porblt_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Isso não significa que alguém tenha visto o Pai, a não ser aquele que vem de Deus. Ele, sim, já viu o Pai. ");
INSERT INTO porblt_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Eu lhes digo que isto é verdade: qualquer um que crê em mim tem a vida eterna. ");
INSERT INTO porblt_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Eu sou o pão da vida. ");
INSERT INTO porblt_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Os seus antepassados comeram o maná no deserto, mas mesmo assim morreram. ");
INSERT INTO porblt_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Porém, esse é o pão que desceu do céu, e qualquer um que comer desse pão nunca morrerá. ");
INSERT INTO porblt_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Eu sou o pão vivo que desceu do céu, e quem comer desse pão viverá para sempre. O pão é minha carne, que eu dou para que o mundo possa viver.” ");
INSERT INTO porblt_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Então, os judeus discutiram intensamente entre si: “Como este homem pode nos dar sua carne para comermos?” ");
INSERT INTO porblt_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus lhes disse: “Eu lhes digo que isto é verdade: a menos que vocês comam a carne do Filho do Homem e bebam o seu sangue, vocês não poderão verdadeiramente viver. ");
INSERT INTO porblt_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aqueles que comem a minha carne e bebem o meu sangue têm a vida eterna e serão ressuscitados no último dia. ");
INSERT INTO porblt_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pois a minha carne é alimento verdadeiro e o meu sangue é bebida verdadeira. ");
INSERT INTO porblt_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Os que comem a minha carne e bebem o meu sangue permanecem em mim, da mesma maneira que eu permaneço neles. ");
INSERT INTO porblt_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Assim como o Pai, que vive, foi quem me enviou, e eu vivo por causa dele, todos os que se alimentam de mim viverão por minha causa. ");
INSERT INTO porblt_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Este é o pão que desceu do céu, não do tipo de pão que os seus antepassados comeram e mesmo assim morreram. Todos que comerem deste pão viverão para sempre.” ");
INSERT INTO porblt_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesus disse isso enquanto ensinava na sinagoga de Cafarnaum. ");
INSERT INTO porblt_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Muitos dos seus discípulos, ao ouvirem o que ele lhes falara, disseram: “Isso é difícil de aceitar! Quem pode seguir esses ensinamentos?” ");
INSERT INTO porblt_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesus percebeu que seus discípulos estavam murmurando a respeito do que ele tinha dito, então, lhes perguntou: “Vocês ficaram ofendidos com isso? ");
INSERT INTO porblt_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Então, e se vocês vissem o Filho subir para onde ele estava antes? ");
INSERT INTO porblt_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","O Espírito é o que dá vida, mas o ser humano não pode fazer isso. As palavras que eu lhes disse são espírito e vida! ");
INSERT INTO porblt_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ainda assim, há alguns de vocês que não creem em mim.” Jesus sabia desde o início quem não tinha fé nele e quem o haveria de trair. ");
INSERT INTO porblt_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesus também falou: “É por isso que eu lhes disse que ninguém poderá vir até mim, a não ser que o Pai torne isso possível.” ");
INSERT INTO porblt_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","A partir desse momento, muitos dos discípulos de Jesus desistiram e não o seguiram mais. ");
INSERT INTO porblt_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Então, Jesus perguntou aos doze discípulos: “E quanto a vocês? Também querem ir embora?” ");
INSERT INTO porblt_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simão Pedro respondeu: “Senhor, quem nós seguiríamos? Você é o único que tem as palavras da vida eterna. ");
INSERT INTO porblt_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nós cremos em você, e também temos certeza de que você é o Santo que Deus enviou.” ");
INSERT INTO porblt_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus respondeu: “Fui eu que escolhi vocês, os doze discípulos. Ainda assim, um de vocês é um diabo.” ");
INSERT INTO porblt_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesus estava se referindo a Judas, filho de Simão Iscariotes. Ele foi aquele que, mesmo sendo um dos doze, iria trair Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Após isso, Jesus passou seu tempo percorrendo a Galileia. Ele não queria ir para a Judeia, porque os judeus de lá queriam matá-lo. ");
INSERT INTO porblt_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mas, como já estava quase no dia da festa judaica das Tendas, ");
INSERT INTO porblt_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","seus irmãos lhe disseram: “Você deveria ir para a Judeia; assim os seus seguidores poderão ver os milagres que você pode fazer. ");
INSERT INTO porblt_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","As pessoas que querem ser reconhecidas não escondem o que podem fazer. Se você pode fazer milagres tão maravilhosos, então, mostre-se ao mundo!” ");
INSERT INTO porblt_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Pois, até mesmo os irmãos de Jesus não acreditavam realmente nele. ");
INSERT INTO porblt_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus lhes disse: “Esta não é a hora certa para eu ir; ainda não. Mas, vocês podem ir quando quiserem, pois qualquer tempo é o certo para vocês. ");
INSERT INTO porblt_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","O mundo não tem motivos para odiá-los, mas ele me odeia. E isso tudo por eu deixar claro que os caminhos do mundo são maus. ");
INSERT INTO porblt_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Vão para a festa! Eu, por enquanto, não vou, porque esta não é a hora certa para mim.” ");
INSERT INTO porblt_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Depois de dizer isso, Jesus ficou na Galileia. ");
INSERT INTO porblt_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Após os seus irmãos saírem para ir à Festa das Tendas, Jesus também foi, mas, não abertamente e, sim, em segredo. ");
INSERT INTO porblt_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Enquanto isso, na festa, os anciãos do povo estavam procurando Jesus e seguiam perguntando: “Onde ele está?” ");
INSERT INTO porblt_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Muitas pessoas na multidão estavam comentando a respeito dele. Algumas pessoas diziam: “Ele é um bom homem!” Mas, outras discordavam: “Não! Ele engana as pessoas.” ");
INSERT INTO porblt_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mas, ninguém se atrevia a falar abertamente sobre Jesus, porque eles tinham medo da reação dos anciãos do povo. ");
INSERT INTO porblt_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Quando a festa já estava na metade, Jesus foi para o Templo e começou a ensinar. ");
INSERT INTO porblt_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Os anciãos do povo ficaram muito surpresos e perguntaram: “Como esse homem tem tanto conhecimento, sendo que ele não estudou?” ");
INSERT INTO porblt_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus respondeu: “O que eu ensino não vem de mim, mas daquele que me enviou. ");
INSERT INTO porblt_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Quem escolhe seguir a vontade de Deus saberá se o que eu ensino vem de Deus, ou se estou falando por mim mesmo. ");
INSERT INTO porblt_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aqueles que falam por si mesmos querem o próprio reconhecimento, mas, quem engrandece aquele que o enviou é verdadeiro e não mente. ");
INSERT INTO porblt_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés não lhes deu a lei? No entanto, nenhum de vocês obedece à lei! Por que vocês estão tentando me matar?” ");
INSERT INTO porblt_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","A multidão respondeu: “Você está possuído pelo demônio! Ninguém está tentando matá-lo.” ");
INSERT INTO porblt_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus disse: “Vocês todos estão chocados por eu ter feito um milagre! ");
INSERT INTO porblt_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Entretanto, como Moisés lhes disse para fazer a circuncisão – não que isso realmente tenha vindo de Moisés, já que os seus antepassados faziam isso antes dele – vocês realizam a circuncisão até mesmo aos sábados. ");
INSERT INTO porblt_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Se vocês circuncidam aos sábados, para garantir que a lei de Moisés não seja quebrada, por que estão indignados contra mim por eu ter curado alguém no sábado? ");
INSERT INTO porblt_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Não julguem pelas aparências, e sim, com justiça!” ");
INSERT INTO porblt_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Então, algumas pessoas que vieram de Jerusalém começaram a se perguntar: “Não é este aquele a quem eles estão tentando matar? ");
INSERT INTO porblt_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mas, vejam só! Ele está falando aqui na frente de todos, e eles não estão dizendo nada contra ele. Vocês acham que as autoridades acreditam que ele é o Messias? ");
INSERT INTO porblt_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mas, isso é impossível, pois nós sabemos de onde ele é. Quando o Messias vier, ninguém saberá de onde ele vem.” ");
INSERT INTO porblt_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Enquanto Jesus estava ensinando no Templo, ele falou bem alto: “Então, vocês acham mesmo que me conhecem e que sabem de onde eu vim? No entanto, eu não vim por mim mesmo. Aquele que me enviou é verdadeiro. Vocês não o conhecem, ");
INSERT INTO porblt_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","mas eu o conheço, pois eu venho dele e ele me enviou.” ");
INSERT INTO porblt_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Então, eles tentaram prender Jesus, mas ninguém colocou as mãos nele, porque a sua hora ainda não havia chegado. ");
INSERT INTO porblt_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Contudo, muitas pessoas da multidão creram nele. Elas disseram: “Quando o Messias chegar, ele fará milagres maiores do que este homem tem feito?” ");
INSERT INTO porblt_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Quando os fariseus ouviram a multidão cochichando a respeito dele, eles e os chefes dos sacerdotes mandaram que os guardas prendessem Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Então, Jesus disse para as pessoas: “Eu ficarei com vocês apenas por mais algum tempo; mas depois, eu retornarei para junto daquele que me enviou. ");
INSERT INTO porblt_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Vocês irão me procurar, porém, não me encontrarão, e também não poderão me seguir para onde irei.” ");
INSERT INTO porblt_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Os judeus disseram uns aos outros: “Para onde será que ele vai que nós não poderemos encontrá-lo? Será que ele está planejando viver entre os judeus que se encontram espalhados entre os pagãos? Será que ele vai ensiná-los? ");
INSERT INTO porblt_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","O que ele quer dizer com: ‘Vocês irão me procurar, porém, não me encontrarão e não poderão me seguir para onde irei?’” ");
INSERT INTO porblt_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","No último e mais importante dia da festa, Jesus se levantou e gritou forte: “Se vocês tiverem sede, venham até mim e bebam! ");
INSERT INTO porblt_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Como as Sagradas Escrituras dizem: Se vocês crerem em mim, serão como fontes de onde fluirão rios de água viva.” ");
INSERT INTO porblt_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesus estava se referindo ao Espírito Santo, que aqueles que tiveram fé nele receberiam. O Espírito não tinha sido dado a essas pessoas, porque Jesus ainda não tinha sido glorificado. ");
INSERT INTO porblt_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ao ouvirem o que Jesus dissera, algumas pessoas falaram: “Definitivamente, esse homem é o Profeta!” ");
INSERT INTO porblt_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Outros disseram: “Ele é o Messias!” Outras pessoas ainda falaram: “Como pode o Messias vir da Galileia? ");
INSERT INTO porblt_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","As Sagradas Escrituras não dizem que o Messias é descendente de Davi e que vem da cidade em que Davi morou, ou seja, Belém?” ");
INSERT INTO porblt_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Então, a multidão começou a expressar uma forte diferença de opinião a respeito de Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Alguns queriam que ele fosse preso, mas ninguém encostou um único dedo nele. ");
INSERT INTO porblt_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Então, os guardas voltaram para onde estavam os chefes dos sacerdotes e os fariseus, que lhes perguntaram: “Por que vocês não o prenderam?” ");
INSERT INTO porblt_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","E os guardas responderam: “Nunca houve ninguém que tenha falado como esse homem!” ");
INSERT INTO porblt_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Os fariseus disseram aos guardas: “Até vocês foram enganados por ele? ");
INSERT INTO porblt_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Algum governador ou fariseu acreditou nele? Não! ");
INSERT INTO porblt_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mas, essa multidão, que não sabe nada sobre os ensinamentos da lei, seja maldita! Eles estão condenados de qualquer forma!” ");
INSERT INTO porblt_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Porém Nicodemos, que já havia se encontrado com Jesus antes e era um deles, perguntou: ");
INSERT INTO porblt_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Porventura, nossa lei condena um homem sem primeiro ouvi-lo e sem saber o que ele realmente fez?” ");
INSERT INTO porblt_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Eles disseram: “Então, você também é um galileu? Estude as Sagradas Escrituras e descobrirá que da Galileia nunca surgiu nenhum profeta.” ");
INSERT INTO porblt_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Depois, todos eles saíram e foram embora. ");
INSERT INTO porblt_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesus foi para o monte das Oliveiras. ");
INSERT INTO porblt_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na manhã do dia seguinte, ele voltou para o Templo, onde muitas pessoas se reuniram a sua volta e ele se sentou para ensiná-las. ");
INSERT INTO porblt_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Os educadores religiosos e os fariseus trouxeram uma mulher que tinha sido pega cometendo adultério, e fizeram com que ela ficasse em pé, na frente de todos que estavam lá. ");
INSERT INTO porblt_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Eles disseram a Jesus: “Mestre, esta mulher foi apanhada cometendo um ato de adultério. ");
INSERT INTO porblt_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","De acordo com a Lei de Moisés, mulheres adúlteras devem ser apedrejadas. E você, o que diz sobre isso?” ");
INSERT INTO porblt_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Eles usaram essa pergunta como uma armadilha para tentar condenar Jesus. Mas, Jesus se abaixou e começou a escrever no chão com o dedo. ");
INSERT INTO porblt_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Eles continuaram a exigir uma resposta dele. Então, ele se levantou e lhes disse: “Aquele de vocês que nunca tenha pecado seja o primeiro a jogar pedra nessa mulher.” ");
INSERT INTO porblt_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Depois, ele se abaixou de novo e continuou a escrever no chão. ");
INSERT INTO porblt_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ao ouvirem isso, as pessoas começaram a sair, uma após a outra, começando pelos mais velhos. Até que restaram apenas Jesus e a mulher. ");
INSERT INTO porblt_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ele se levantou e perguntou a ela: “Mulher, onde estão aqueles seus acusadores? Não ficou nenhum deles para condená-la?” ");
INSERT INTO porblt_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ela respondeu: “Nenhum deles, senhor!” Jesus lhe disse: “Eu também não a condenarei. Vá! E não peque mais!” ");
INSERT INTO porblt_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus falou novamente para as pessoas e disse: “Eu sou a luz do mundo. Se vocês me seguirem, não andarão nas trevas, pois terão a luz da vida.” ");
INSERT INTO porblt_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Os fariseus responderam: “Você não pode testemunhar a seu favor. O que você diz não prova nada!” ");
INSERT INTO porblt_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus lhes disse: “Mesmo que eu esteja falando em meu próprio benefício, meu testemunho é verdadeiro, pois eu sei de onde vim e para onde irei. Mas, vocês não sabem de onde eu vim, nem para onde estou indo. ");
INSERT INTO porblt_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Vocês julgam por padrões tipicamente humanos, mas eu não julgo ninguém. ");
INSERT INTO porblt_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mesmo se eu julgasse, minha decisão seria justa, porque eu não estou fazendo isso sozinho. O Pai que me enviou está comigo. ");
INSERT INTO porblt_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","A própria lei de vocês afirma que o testemunho de duas pessoas é válido. ");
INSERT INTO porblt_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Eu testemunho a respeito de mim mesmo, e meu Pai, que me enviou, é a minha outra testemunha.” ");
INSERT INTO porblt_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Eles perguntaram: “Onde está seu pai?” Jesus respondeu: “Vocês não me conhecem, nem conhecem o meu Pai. Se vocês me conhecessem, também conheceriam o meu Pai.” ");
INSERT INTO porblt_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus disse isso, enquanto ensinava próximo à caixa das ofertas do Templo. Mesmo assim, ninguém o prendeu, porque sua hora ainda não tinha chegado. ");
INSERT INTO porblt_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus disse novamente a eles: “Eu vou embora, e vocês irão me procurar; mas morrerão sem que os seus pecados sejam perdoados. Vocês não podem ir para onde eu vou.” ");
INSERT INTO porblt_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Os judeus perguntaram em voz alta: “Será que ele irá se matar? É isso que ele quer dizer com: ‘Vocês não podem ir para onde eu vou?’” ");
INSERT INTO porblt_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus lhes disse: “Vocês são daqui de baixo, e eu sou lá de cima. Vocês são deste mundo, e eu não sou deste mundo. ");
INSERT INTO porblt_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","É por isso que eu disse que vocês irão morrer sem que os seus pecados sejam perdoados. Pois se vocês não crerem que ‘Eu sou’, então, morrerão sem o perdão dos seus pecados.” ");
INSERT INTO porblt_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nesse momento, eles perguntaram a Jesus: “Quem é você?” “Exatamente quem eu disse que era desde o início,” Jesus respondeu. ");
INSERT INTO porblt_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","“Existem muitas coisas sobre vocês das quais eu preciso falar e as quais eu preciso julgar. Mas aquele que me enviou diz a verdade e o que eu digo a vocês aqui neste mundo é o que eu ouvi dele.” ");
INSERT INTO porblt_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Eles não entenderam o que ele estava falando a respeito do Pai. Então, Jesus lhes explicou: ");
INSERT INTO porblt_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","“Quando vocês levantarem o Filho do Homem, então, saberão que ‘Eu sou’ e irão perceber que não faço nada por mim mesmo, mas que apenas digo o que o meu Pai me ensinou. ");
INSERT INTO porblt_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Aquele que me enviou está comigo; ele não me abandonou, pois eu sempre faço o que lhe agrada.” ");
INSERT INTO porblt_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Muitas pessoas que ouviram Jesus dizer essas palavras creram nele. ");
INSERT INTO porblt_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Assim Jesus disse para os judeus que creram nele: “Se vocês seguem o que eu digo, então, vocês realmente são meus discípulos. ");
INSERT INTO porblt_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Vocês irão descobrir a verdade, e a verdade os libertará.” ");
INSERT INTO porblt_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Eles responderam: “Nós somos descendentes de Abraão! Nunca fomos escravos de ninguém. Como você pode dizer que seremos livres?” ");
INSERT INTO porblt_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus respondeu: “Eu lhes digo que isto é verdade: todos aqueles que pecam são escravos do pecado. ");
INSERT INTO porblt_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Um escravo não tem lugar permanente na família, mas o filho sempre será parte da família. ");
INSERT INTO porblt_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Se o Filho os libertar, então, vocês serão verdadeiramente livres. ");
INSERT INTO porblt_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Eu sei que vocês são descendentes de Abraão, ainda que estejam tentando me matar por se recusarem a aceitar as minhas palavras. ");
INSERT INTO porblt_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Eu lhes digo o que o Pai mostrou para mim, enquanto vocês fazem o que os seus pais lhes dizem para fazer.” ");
INSERT INTO porblt_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Eles responderam: “Abraão é o nosso pai!” Jesus lhes disse: “Se vocês são realmente filhos de Abraão, então, façam o que Abraão fez. ");
INSERT INTO porblt_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mas agora, vocês estão tentando me matar, porque eu lhes disse a verdade que ouvi de Deus. Abraão nunca teria feito isso. ");
INSERT INTO porblt_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Vocês estão fazendo o que o seu pai fez.” Eles responderam: “Bem, nós não somos filhos ilegítimos. Nosso único pai é Deus!” ");
INSERT INTO porblt_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus disse: “Se Deus fosse realmente o pai de vocês, vocês me amariam. Eu vim de Deus e agora estou aqui. A decisão de vir não foi minha, mas daquele que me enviou. ");
INSERT INTO porblt_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Por que vocês não conseguem entender o que eu digo? É porque vocês se recusam a ouvir a minha mensagem! ");
INSERT INTO porblt_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","O pai de vocês é o diabo e o que vocês querem é cumprir os desejos perversos do seu pai. Ele foi um assassino desde o início do mundo. Ele nunca defendeu a verdade, pois não há verdade nele. Faz parte da natureza dele mentir, pois ele é um mentiroso e é o pai das mentiras. ");
INSERT INTO porblt_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Então, por eu lhes dizer a verdade, vocês não acreditam em mim! ");
INSERT INTO porblt_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Digam-me: qual de vocês pode provar que eu sou um pecador? Se eu lhes digo a verdade, por que vocês não creem em mim? ");
INSERT INTO porblt_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Qualquer pessoa que pertença a Deus escuta o que Deus diz. O motivo de vocês não escutarem é porque não pertencem a Deus.” ");
INSERT INTO porblt_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Os judeus disseram: “Nós não temos razão quando o chamamos de samaritano e dizemos que está possuído pelo demônio?” ");
INSERT INTO porblt_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus respondeu: “Não, eu não estou possuído pelo demônio. Eu respeito o meu Pai, mas vocês não me respeitam. ");
INSERT INTO porblt_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Eu não estou aqui buscando glória para mim mesmo. Mas, há alguém que faz isso por mim e que julga a meu favor. ");
INSERT INTO porblt_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Eu lhes digo que isto é verdade: aquele que seguir as minhas palavras nunca morrerá.” ");
INSERT INTO porblt_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","“Agora nós temos certeza de que você está possuído pelo demônio”, os judeus disseram. “Abraão e os profetas morreram; mas você nos diz que: ‘Aquele que seguir as minhas palavras nunca morrerá’! ");
INSERT INTO porblt_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Por acaso, você é mais importante do que nosso pai, Abraão? Ele morreu, assim como os profetas. Quem você pensa que é?” ");
INSERT INTO porblt_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus respondeu: “Se eu engrandecer a mim mesmo, isso não terá valor algum. Porém, é aquele que vocês afirmam: ‘Ele é o nosso Deus,’ quem me engrandece. ");
INSERT INTO porblt_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Vocês não o conhecem, mas eu o conheço. Se eu disser que não o conheço estarei mentindo, exatamente como vocês fazem. Mas, realmente, o conheço e também sei o que ele diz. ");
INSERT INTO porblt_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraão, o pai de vocês, ficou muito feliz enquanto aguardava com ansiedade pela minha vinda. E foi um momento muito alegre quando ele viu isso acontecer.” ");
INSERT INTO porblt_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Os judeus responderam: “Você não tem nem cinquenta anos. Como pode ter visto Abraão?” ");
INSERT INTO porblt_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus disse: “Eu lhes digo que isto é verdade: Antes de Abraão nascer, Eu sou.” ");
INSERT INTO porblt_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nesse momento, eles pegaram pedras para jogar nele; mas Jesus se escondeu e saiu do Templo. ");
INSERT INTO porblt_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Conforme Jesus caminhava, ele viu um homem que havia nascido cego. ");
INSERT INTO porblt_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Os seus discípulos lhe perguntaram: “Rabi, por que este homem nasceu cego? Foi ele quem pecou ou foram os pais dele?” ");
INSERT INTO porblt_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus respondeu: “Isso não aconteceu porque ele ou os pais dele pecaram. Mas para que o poder de Deus se manifeste na vida dele. ");
INSERT INTO porblt_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nós precisamos continuar fazendo o trabalho daquele que me enviou enquanto ainda é dia. Está chegando a noite, quando ninguém pode trabalhar. ");
INSERT INTO porblt_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Enquanto estou no mundo, eu sou a luz do mundo.” ");
INSERT INTO porblt_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Após dizer isso, Jesus cuspiu no chão e fez um pouco de lama com a saliva. Ele, então, pegou a lama e a colocou nos olhos do cego. ");
INSERT INTO porblt_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Depois, Jesus lhe disse: “Vá e lave o rosto no Tanque de Siloé” (que significa “enviado”). O homem foi, lavou o rosto e voltou vendo. ");
INSERT INTO porblt_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Os vizinhos dele e as pessoas que o viam pedindo esmola, perguntaram: “Este não é o homem que costumava se sentar e pedir esmola?” ");
INSERT INTO porblt_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Algumas pessoas diziam que era ele, enquanto outras diziam: “Não, é apenas alguém que se parece com ele.” Mas, o homem continuava dizendo: “Sou eu!” ");
INSERT INTO porblt_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Eles perguntaram: “Então, como você conseguiu enxergar?” ");
INSERT INTO porblt_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ele respondeu: “Um homem, chamado Jesus, fez um pouco de lama, colocou-a em meus olhos e me disse: ‘Vá e lave o rosto no Tanque de Siloé.’ Então, fiz o que ele me disse e agora eu consigo enxergar.” ");
INSERT INTO porblt_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","As pessoas perguntaram: “Onde ele está?” E o homem respondeu: “Eu não sei!” ");
INSERT INTO porblt_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Eles levaram o homem que tinha sido cego aos fariseus. ");
INSERT INTO porblt_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesus tinha feito a lama e aberto os olhos do homem cego em um dia de sábado. ");
INSERT INTO porblt_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Então, os fariseus também perguntaram ao homem como ele conseguiu enxergar. Ele falou para os fariseus: “Ele colocou a lama em meus olhos. Então, eu fui, lavei meu rosto e agora eu consigo enxergar.” ");
INSERT INTO porblt_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Alguns fariseus disseram: “O homem que fez isso não pode ser de Deus, pois ele não respeita a lei do sábado.” Mas, outros perguntaram: “Como poderia um pecador fazer tais milagres?” Assim, houve uma divisão de opiniões no grupo dos fariseus. ");
INSERT INTO porblt_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Então, eles continuaram perguntando ao homem: “Qual é a sua opinião sobre ele, já que foram os seus olhos que ele curou?” O homem respondeu: “Ele é um profeta!” ");
INSERT INTO porblt_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Os líderes judeus não acreditaram que o homem, antes cego, agora pudesse enxergar. Então, eles chamaram os pais do homem. ");
INSERT INTO porblt_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Eles perguntaram aos pais dele: “Este homem é o filho de vocês, que dizem ter nascido cego? Então, como é possível que agora ele consiga enxergar?” ");
INSERT INTO porblt_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Os pais do homem responderam: “Nós reconhecemos que este é o nosso filho que nasceu cego. ");
INSERT INTO porblt_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mas, não temos ideia de como ele consegue enxergar agora, ou quem o curou. Por que vocês não perguntam a ele? Afinal, ele tem idade o bastante para responder por si mesmo.” ");
INSERT INTO porblt_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","O motivo dos pais dele dizerem isso era porque tinham medo do que os líderes judeus fariam. Os líderes judeus já haviam anunciado que qualquer pessoa que declarasse que Jesus era o Messias seria expulso da sinagoga. ");
INSERT INTO porblt_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Por isso os pais do homem disseram: “Perguntem a ele; afinal, ele tem idade o bastante.” ");
INSERT INTO porblt_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Uma vez mais eles chamaram o homem que tinha sido cego e lhe disseram: “Dê a glória a Deus! Nós sabemos que esse homem é um pecador.” ");
INSERT INTO porblt_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","O homem respondeu: “Se ele é um pecador ou não, eu não sei. Tudo o que eu sei é que eu era cego e agora posso enxergar.” ");
INSERT INTO porblt_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Então, eles perguntaram ao homem: “O que ele fez para você? Como ele curou os seus olhos?” ");
INSERT INTO porblt_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ele respondeu: “Eu já disse a vocês. Vocês não estavam me escutando? Por que vocês querem ouvir isso novamente? Vocês, por acaso, querem ser discípulos dele também?” ");
INSERT INTO porblt_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Eles o xingaram e disseram: “Discípulo dele é você! ");
INSERT INTO porblt_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nós somos discípulos de Moisés. Nós sabemos que Deus falou com Moisés, mas quanto a esse homem, não sabemos nem mesmo de onde ele é.” ");
INSERT INTO porblt_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","O homem, então, respondeu: “É incrível! Vocês não sabem de onde ele é, mas ele curou os meus olhos. ");
INSERT INTO porblt_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nós sabemos que Deus não ouve pecadores, mas, sim, ouve qualquer um que o louve e que faça a sua vontade. ");
INSERT INTO porblt_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Desde que o mundo existe, nunca se ouviu dizer que alguém tenha curado alguém que nasceu cego. ");
INSERT INTO porblt_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Se esse homem não tivesse vindo de Deus, ele não poderia fazer nada.” ");
INSERT INTO porblt_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Eles responderam: “Você nasceu cheio de pecado e ainda quer nos ensinar?” E o expulsaram da sinagoga. ");
INSERT INTO porblt_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Quando Jesus ouviu o que os líderes judeus tinham feito com o homem, foi encontrá-lo e lhe perguntou: “Você crê no Filho do Homem?” ");
INSERT INTO porblt_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","O homem respondeu: “Diga-me quem ele é, senhor, assim posso crer nele.” ");
INSERT INTO porblt_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","“Você já o viu. Ele é quem está falando com você neste exato momento”, Jesus lhe disse. ");
INSERT INTO porblt_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Eu creio em você, Senhor!”, ele disse. Então, se ajoelhou diante de Jesus e o adorou. ");
INSERT INTO porblt_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Depois, Jesus lhe disse: “Eu vim ao mundo para julgar, para que os cegos possam ver e os que veem fiquem cegos.” ");
INSERT INTO porblt_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Alguns fariseus que estavam lá com Jesus lhe perguntaram: “Por acaso, nós também somos cegos?” ");
INSERT INTO porblt_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus respondeu: “Se vocês fossem cegos, não seriam culpados. Mas, agora que vocês dizem que podem ver, a culpa de vocês permanece.” ");
INSERT INTO porblt_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Eu lhes digo que isto é verdade: qualquer um que não entre pela porta do curral das ovelhas, mas sobe por outro lugar, é um ladrão e bandido. ");
INSERT INTO porblt_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Aquele que entra pela porta é o pastor das ovelhas. ");
INSERT INTO porblt_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","O porteiro abre a porta para ele, e as ovelhas respondem ao comando de sua voz. Ele chama suas ovelhas por seus nomes e as leva para fora do curral. ");
INSERT INTO porblt_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Após trazer o rebanho para fora, ele caminha na frente das ovelhas e elas o seguem, porque reconhecem a sua voz. ");
INSERT INTO porblt_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Elas não seguirão o comando de estranhos. Na verdade, elas fugiriam de um estranho, pois não reconhecem a voz de estranhos.” ");
INSERT INTO porblt_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Quando Jesus contou essa história como exemplo, as pessoas que o escutavam não entenderam o que ele quis dizer. ");
INSERT INTO porblt_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Então, Jesus explicou novamente: “Eu lhes digo que isto é verdade: Eu sou a porta do curral. ");
INSERT INTO porblt_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Todos aqueles que vieram antes de mim eram ladrões e bandidos, mas as ovelhas não lhes deram atenção. ");
INSERT INTO porblt_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Eu sou a porta. Todos aqueles que entram por mim serão curados. Eles serão capazes de entrar e sair e encontrarão o alimento que precisam. ");
INSERT INTO porblt_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","O ladrão vem apenas para roubar, matar e destruir. Eu vim lhes trazer vida, e vida completa. ");
INSERT INTO porblt_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Eu sou o bom pastor. O bom pastor dá a vida pelas ovelhas. ");
INSERT INTO porblt_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","O homem pago para cuidar das ovelhas não é o pastor. Quando ele vê o lobo se aproximando, foge. Ele abandona as ovelhas, porque elas não são dele. Então, o lobo ataca e espalha o rebanho. ");
INSERT INTO porblt_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","O homem foge porque ele está trabalhando apenas pelo dinheiro e não se importa com as ovelhas. ");
INSERT INTO porblt_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Eu sou o bom pastor. Eu sei que as ovelhas são minhas e que elas me conhecem. ");
INSERT INTO porblt_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Da mesma maneira, o Pai me conhece e eu o conheço. Eu dou a minha vida pelas ovelhas. ");
INSERT INTO porblt_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Eu tenho outras ovelhas que não estão neste curral. Eu devo trazê-las também. Elas ouvirão a minha voz e haverá apenas um rebanho com apenas um pastor. ");
INSERT INTO porblt_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","É por isso que o Pai me ama, pois eu dou a minha vida para recebê-la de novo. ");
INSERT INTO porblt_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ninguém a tira de mim; pelo contrário, eu a entrego de maneira espontânea. Eu tenho o direito de dar a minha vida e de recebê-la novamente. Isso é o que meu Pai me mandou fazer.” ");
INSERT INTO porblt_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Os judeus ficaram novamente divididos em relação ao que pensavam sobre o que Jesus tinha acabado de dizer. ");
INSERT INTO porblt_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Muitos deles diziam: “Ele está possuído pelo demônio! Ele é louco! Por que vocês estão escutando o que ele diz?” ");
INSERT INTO porblt_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mas, outros diziam: “Estas não são palavras ditas por alguém possuído pelo demônio. Além disso, um demônio não consegue curar os olhos de um cego.” ");
INSERT INTO porblt_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Era inverno, e estavam comemorando, em Jerusalém, a Festa da Dedicação. ");
INSERT INTO porblt_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus estava andando no Templo, próximo a uma entrada conhecida como Alpendre de Salomão. Os judeus o cercaram e perguntaram: ");
INSERT INTO porblt_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","“Por quanto tempo você nos manterá em dúvida? Se você é realmente o Messias, então, nos diga claramente.” ");
INSERT INTO porblt_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus respondeu: “Eu já lhes disse, mas vocês não acreditaram. Os milagres que eu faço em nome do meu Pai provam quem eu sou. ");
INSERT INTO porblt_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Vocês não creem em mim porque não são minhas ovelhas. ");
INSERT INTO porblt_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","As minhas ovelhas reconhecem a minha voz; eu as conheço e elas me seguem. ");
INSERT INTO porblt_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Eu dou para elas a vida eterna. Elas nunca morrerão, e ninguém poderá tomá-las de mim. ");
INSERT INTO porblt_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Meu Pai, que as deu para mim, é maior do que todos, e ninguém pode tirá-las dele. ");
INSERT INTO porblt_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Eu e o Pai somos um.” ");
INSERT INTO porblt_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mais uma vez, os judeus pegaram pedras para jogar em Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus, então, lhes disse: “Vocês têm visto muitas boas ações que eu faço em nome do Pai. Por qual delas vocês estão querendo me apedrejar?” ");
INSERT INTO porblt_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Os judeus responderam: “Nós não estamos querendo apedrejá-lo por uma boa ação e, sim, por blasfêmia; pois você não passa de um homem que afirma ser Deus.” ");
INSERT INTO porblt_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus disse: “Por acaso, na lei de vocês não está escrito: ‘Eu disse: Vocês são deuses’? ");
INSERT INTO porblt_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Deus chamou aquelas pessoas de ‘deuses,’ pessoas as quais foi dirigida a Palavra de Deus, e as Sagradas Escrituras não podem falhar. ");
INSERT INTO porblt_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Então, por que vocês estão dizendo que aquele que o Pai escolheu e enviou ao mundo está dizendo mentiras ao afirmar: ‘Eu sou o Filho de Deus’? ");
INSERT INTO porblt_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Se eu não estiver fazendo o que o meu Pai faz, então, não creiam em mim. ");
INSERT INTO porblt_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mas, se eu estiver fazendo, mesmo que não creiam em mim, acreditem ao menos no que eu faço. Assim, vocês poderão saber e entender que o Pai está em mim e eu estou no Pai.” ");
INSERT INTO porblt_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Eles tentaram prender Jesus novamente, mas ele conseguiu escapar. ");
INSERT INTO porblt_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ele voltou, atravessando o rio Jordão até o local em que João tinha começado a batizar e lá ficou. ");
INSERT INTO porblt_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Muitas pessoas foram até onde ele estava e diziam: “João não fez milagres, mas tudo o que ele disse sobre Jesus é verdade.” ");
INSERT INTO porblt_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Muitos dos que foram ver Jesus creram nele. ");
INSERT INTO porblt_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Um homem chamado Lázaro estava doente. Ele morava no povoado de Betânia com suas irmãs, Maria e Marta. ");
INSERT INTO porblt_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria, cujo irmão Lázaro estava doente, foi a mesma que colocou perfume no Senhor e enxugou, com seus cabelos, os pés dele. ");
INSERT INTO porblt_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Então, as irmãs enviaram uma mensagem a Jesus: “Senhor, o seu querido amigo está doente.” ");
INSERT INTO porblt_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Quando Jesus ouviu a notícia, disse: “A doença de Lázaro não acabará em morte. Isso está acontecendo para que a glória de Deus seja revelada e, assim, o Filho de Deus seja respeitado.” ");
INSERT INTO porblt_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Embora Jesus amasse Marta, Maria e Lázaro ");
INSERT INTO porblt_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","e tivesse ouvido a notícia sobre a doença dele, ele permaneceu no lugar em que estava ainda por dois dias. ");
INSERT INTO porblt_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Então, Jesus disse aos seus discípulos: “Vamos voltar para a Judeia.” ");
INSERT INTO porblt_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","E os discípulos disseram: “Rabi, apenas há alguns dias, os judeus tentaram apedrejá-lo. Você realmente quer voltar para lá agora?” ");
INSERT INTO porblt_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus respondeu: “O dia não tem doze horas? ");
INSERT INTO porblt_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Se vocês andarem durante o dia não tropeçarão, pois a luz deste mundo os ajuda a ver para onde estão indo. Mas, se vocês caminharem durante a noite tropeçarão, pois não há luz para iluminar o seu caminho.” ");
INSERT INTO porblt_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Após isso, Jesus continuou: “O nosso amigo Lázaro está dormindo, mas eu irei lá e o acordarei.” ");
INSERT INTO porblt_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Os discípulos disseram: “Senhor, se ele está dormindo, então, irá melhorar.” ");
INSERT INTO porblt_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesus estava se referindo à morte de Lázaro, mas os discípulos pensaram que ele estivesse realmente dormindo. ");
INSERT INTO porblt_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Então, Jesus lhes disse claramente: “Lázaro está morto. ");
INSERT INTO porblt_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Para o bem de vocês, eu estou feliz por não ter estado lá com ele, pois assim vocês serão capazes de crer em mim. Vamos vê-lo!” ");
INSERT INTO porblt_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomé, chamado o Gêmeo, disse para os outros discípulos: “Vamos também! Assim, poderemos morrer com o Mestre.” ");
INSERT INTO porblt_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ao chegar, Jesus soube que Lázaro havia sido sepultado já há quatro dias. ");
INSERT INTO porblt_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","O povoado de Betânia ficava apenas três quilômetros de Jerusalém, ");
INSERT INTO porblt_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","e muitos judeus tinham ido até lá para consolar Maria e Marta pela morte do seu irmão. ");
INSERT INTO porblt_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Quando Marta soube que Jesus estava vindo, ela foi encontrá-lo; porém, Maria ficou em casa. ");
INSERT INTO porblt_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta disse a Jesus: “Se o senhor estivesse aqui, o meu irmão não teria morrido! ");
INSERT INTO porblt_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mas, eu tenho certeza de que, mesmo agora, Deus lhe dará qualquer coisa que o senhor pedir.” ");
INSERT INTO porblt_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus lhe disse: “O seu irmão irá ressuscitar!” ");
INSERT INTO porblt_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta respondeu: “Eu sei que ele voltará do mundo dos mortos na ressurreição, no último dia.” ");
INSERT INTO porblt_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","E Jesus disse: “Eu sou a ressurreição e a vida. Aquele que crê em mim viverá, mesmo que esteja morto. ");
INSERT INTO porblt_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","E quem vive e crê em mim não morrerá, eternamente. Você acredita nisso?” ");
INSERT INTO porblt_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Sim, Senhor!”, ela respondeu. “Eu creio que o senhor é o Messias, o Filho de Deus, aquele que devia vir a este mundo.” ");
INSERT INTO porblt_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Depois que disse isso, Marta voltou para casa e disse a sua irmã, Maria, em particular: “O Mestre está aqui e pediu para vê-la.” ");
INSERT INTO porblt_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Assim que Maria ouviu isso, rapidamente se levantou e foi vê-lo. ");
INSERT INTO porblt_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus ainda não tinha chegado ao povoado. Ele ainda estava no lugar em que Marta o havia encontrado. ");
INSERT INTO porblt_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Os judeus, que estavam consolando Maria em sua casa, viram como ela se levantou rápido e saiu. Então, eles a seguiram, pensando que ela talvez fosse até o túmulo do seu irmão para chorar. ");
INSERT INTO porblt_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Quando Maria chegou ao local em que Jesus estava e o viu, ela caiu aos seus pés e disse: “Se o senhor estivesse aqui, o meu irmão não teria morrido!” ");
INSERT INTO porblt_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Quando Jesus a viu chorando, e também os judeus que vinham atrás dela, ele ficou muito comovido e aflito. ");
INSERT INTO porblt_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ele perguntou: “Onde vocês o sepultaram?” Eles responderam: “Senhor, venha e veja!” ");
INSERT INTO porblt_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Então, Jesus chorou. ");
INSERT INTO porblt_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Os judeus disseram: “Vejam como ele amava Lázaro!” ");
INSERT INTO porblt_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mas, alguns deles disseram: “Se ele conseguiu curar a cegueira de um cego, então, ele não poderia ter impedido que Lázaro moresse?” ");
INSERT INTO porblt_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus, se sentindo muito aflito, foi até o túmulo. Era uma caverna, com uma grande pedra colocada na entrada. ");
INSERT INTO porblt_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus lhes disse: “Retirem a pedra!” Porém, Marta, a irmã de Lázaro, disse: “Senhor, haverá um cheiro terrível, pois Lázaro já está morto há quatro dias.” ");
INSERT INTO porblt_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","“Eu não lhe disse que se crer em mim, você verá o poder de Deus?”, Jesus respondeu. ");
INSERT INTO porblt_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Então, eles tiraram a pedra. Jesus olhou para o céu e disse: “Pai, obrigado por me ouvir. ");
INSERT INTO porblt_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Eu sei que você sempre me escuta. Eu digo isso para que a multidão que aqui está acredite que você me enviou.” ");
INSERT INTO porblt_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Após dizer isso, Jesus gritou: “Lázaro, venha para fora!” ");
INSERT INTO porblt_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","O morto veio. Havia tiras de linho envolvendo as suas mãos e os seus pés e também um pedaço de tecido sobre o seu rosto. Jesus lhes disse: “Tirem as faixas dele e deixem que ele vá.” ");
INSERT INTO porblt_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Assim, muitos dos judeus que vieram para consolar Maria e que viram o que Jesus tinha feito creram nele. ");
INSERT INTO porblt_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mas, outros foram até os fariseus e disseram para eles o que Jesus havia feito. ");
INSERT INTO porblt_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Então, os chefes dos sacerdotes e os fariseus fizeram uma reunião do conselho superior. Eles perguntaram: “O que devemos fazer? Esse homem está fazendo muitos milagres. ");
INSERT INTO porblt_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Se permitirmos que ele continue, todos irão acreditar nele e, então, os romanos irão destruir tanto o Templo quanto a nós como país.” ");
INSERT INTO porblt_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Caifás, que era o grande sacerdote daquele ano, disse: “Vocês não entendem nada! ");
INSERT INTO porblt_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Não conseguem perceber que é melhor que morra apenas um homem pelo povo do que toda uma nação ser destruída?” ");
INSERT INTO porblt_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ele não disse isso por si mesmo, mas como grande sacerdote naquele ano, ele estava profetizando que Jesus iria morrer pela nação. ");
INSERT INTO porblt_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","E que ele se sacrificaria não apenas pela nação judaica, mas por todos os filhos de Deus espalhados por toda a parte. Então, eles se reuniriam e formariam um só povo. ");
INSERT INTO porblt_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","A partir daquele momento, eles começaram a planejar como conseguiriam matar Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Por isso, Jesus não andava mais publicamente entre os judeus; ele foi para uma cidade chamada Efraim, na região próxima ao deserto e lá ficou com os seus discípulos. ");
INSERT INTO porblt_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Já estava próximo o dia da Páscoa judaica, e muitas pessoas saíram dos campos e foram para Jerusalém, para se purificarem para a Páscoa. ");
INSERT INTO porblt_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","As pessoas procuravam por Jesus e, enquanto estavam no Templo, falavam a respeito dele. Elas se perguntavam: “O que você acha? Ele virá para a festa?” ");
INSERT INTO porblt_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Os chefes dos sacerdotes e os fariseus tinham dado ordens para que todos que soubessem onde Jesus estava contassem a eles, pois queriam prendê-lo. ");
INSERT INTO porblt_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seis dias antes da Páscoa, Jesus foi para Betânia, para a casa de Lázaro, a quem ele tinha ressuscitado. ");
INSERT INTO porblt_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ali, fizeram um jantar em sua homenagem. Marta ajudou a servir a comida, enquanto Lázaro se sentou na mesa com Jesus e com os outros convidados. ");
INSERT INTO porblt_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria trouxe um frasco de perfume muito caro, feito de nardo puro, e derramou o perfume nos pés de Jesus, secando-os depois com os seus próprios cabelos. O cheiro do perfume se espalhou por toda a casa. ");
INSERT INTO porblt_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mas, um dos discípulos, Judas Iscariotes, que depois iria trair Jesus, perguntou: ");
INSERT INTO porblt_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Por que esse perfume não foi vendido e o dinheiro da venda dado aos pobres? Ele valeria trezentos denários.” ");
INSERT INTO porblt_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ele não disse isso por estar preocupado com os pobres, mas porque era ladrão. Era ele quem cuidava do dinheiro dos discípulos e, quase sempre, pegava uma parte desse dinheiro para si. ");
INSERT INTO porblt_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesus respondeu: “Não a critique! Ela está me preparando para o meu sepultamento. ");
INSERT INTO porblt_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Os pobres sempre estarão com vocês, mas eu não estarei sempre com vocês.” ");
INSERT INTO porblt_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Muitas pessoas descobriram que Jesus estava lá. Elas foram até lá não apenas para ver Jesus, mas porque queriam ver Lázaro também. Afinal, ele era o homem que Jesus ressuscitara dentre os mortos. ");
INSERT INTO porblt_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Então, os chefes dos sacerdotes planejaram matar Lázaro também, ");
INSERT INTO porblt_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","já que ele era o motivo de tantos judeus passarem a crer em Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","No dia seguinte, a multidão que tinha vindo para a festa da Páscoa ouviu que Jesus estava a caminho de Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Elas cortaram folhas de palmeiras e foram dar as boas-vindas a ele, gritando: “Hosana! Que Deus abençoe aquele que vem em nome do Senhor! Que Deus abençoe o rei de Israel!” ");
INSERT INTO porblt_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus encontrou um jumentinho e montou nele, como as Sagradas Escrituras dizem: ");
INSERT INTO porblt_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Não tenha medo, filha de Sião! Veja! O seu rei está chegando, montado em um jumentinho!” ");
INSERT INTO porblt_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Naquela ocasião, os discípulos de Jesus não entenderam o que isso significava. Apenas tempos mais tarde, quando ele foi glorificado, eles entenderam que o que tinha acontecido havia sido escrito antes e que dizia respeito a ele. ");
INSERT INTO porblt_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Muitas pessoas na multidão tinham visto Jesus dizer a Lázaro para sair do túmulo e que ressuscitasse. E essas mesmas pessoas estavam recontando essa história. ");
INSERT INTO porblt_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Foi por esse motivo que muitos foram ver Jesus, pois tinham ouvido falar sobre esse milagre. ");
INSERT INTO porblt_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Os fariseus disseram uns para os outros: “Veja! Nós não conseguimos resultado algum! Todos estão correndo para vê-lo!” ");
INSERT INTO porblt_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Entre os que tinham ido à Jerusalém para adorar durante a festa estavam alguns gregos. ");
INSERT INTO porblt_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Eles se aproximaram de Filipe, que era de Betsaida, na Galileia, e disseram: “Senhor, nós gostaríamos de ver Jesus!” ");
INSERT INTO porblt_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipe disse isso para André. Os dois, então, foram dizer a Jesus sobre os gregos. ");
INSERT INTO porblt_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus respondeu: “Chegou o momento do Filho do Homem ser glorificado. ");
INSERT INTO porblt_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Eu lhes digo que isto é verdade: a menos que um grão de trigo seja plantado no solo e morra, ele ainda será apenas um grão. Mas, se ele morrer, irá produzir muitos outros grãos de trigo. ");
INSERT INTO porblt_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Se vocês amam a sua própria vida, a perderão. Mas, se não amam a própria vida, neste mundo, vocês a manterão para a vida eterna. ");
INSERT INTO porblt_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Se vocês quiserem me servir, precisam me seguir. Meus servos estarão onde eu estou, e o meu Pai irá honrar qualquer pessoa que me sirva. ");
INSERT INTO porblt_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Agora eu estou realmente aflito. O que eu devo dizer? Eu direi: ‘Pai, salve-me desse tempo de sofrimento que virá?’ Não, pois foi para isso que eu vim; para passar por este tempo de sofrimento. ");
INSERT INTO porblt_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pai, mostre a glória do seu caráter.” Uma voz veio do céu e disse: “Eu já a mostrei e irei mostrá-la de novo.” ");
INSERT INTO porblt_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A multidão que estava lá ouviu o que foi dito. Algumas pessoas disseram que tinha sido um trovão. Porém, outras disseram que um anjo tinha falado com Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus lhes disse: “Esta voz veio não para mim, mas para vocês. ");
INSERT INTO porblt_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Agora, começa o julgamento deste mundo. Agora, o príncipe deste mundo será expulso. ");
INSERT INTO porblt_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mas, quando eu for levantado da terra, atrairei todas as pessoas para mim.” ");
INSERT INTO porblt_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesus disse isso para mostrar como iria morrer. ");
INSERT INTO porblt_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","A multidão respondeu: “A Lei nos diz que o Messias irá viver para sempre. Então, como você pode dizer que o Filho do Homem será ‘levantado da terra’? Quem é esse ‘Filho do Homem’?” ");
INSERT INTO porblt_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus respondeu: “A luz ficará aqui com vocês por um pouco mais de tempo. Caminhem enquanto vocês ainda têm luz, para que as trevas não os alcance. Aqueles que caminham na escuridão não sabem para onde estão indo. ");
INSERT INTO porblt_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Creiam na luz enquanto vocês ainda a têm, para que, assim, possam se tornar filhos da luz.” Depois que Jesus disse isso para as pessoas, ele saiu e se ocultou delas. ");
INSERT INTO porblt_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mas, apesar de todos os milagres que ele fez na presença deles, eles ainda não tinham fé em Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Isso aconteceu para que se cumprisse a mensagem do profeta Isaías: “Senhor, quem acreditou no que dissemos? E para quem foi revelado o poder do Senhor?” ");
INSERT INTO porblt_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Eles não foram capazes de crer nele e, assim, eles cumpriram o que Isaías também tinha dito: ");
INSERT INTO porblt_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ele cegou os olhos deles e fez com que suas mentes ficassem vazias, para que os seus olhos não pudessem ver e para que as suas mentes não pensassem e, assim, eles não se voltariam para mim, pois se eles o fizessem, eu os curaria.” ");
INSERT INTO porblt_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías viu a glória de Jesus e disse isso em relação a ele. ");
INSERT INTO porblt_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Até mesmo muitos dos líderes creram em Jesus. No entanto, eles não admitiram isso publicamente, porque não queriam que os fariseus os expulsassem da sinagoga. ");
INSERT INTO porblt_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Eles queriam mais a admiração dos homens do que a aprovação de Deus. ");
INSERT INTO porblt_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus disse bem alto: “Se vocês creem em mim, não estão crendo apenas em mim, mas também naquele que me enviou. ");
INSERT INTO porblt_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Quando vocês me veem, também veem aquele que me enviou. ");
INSERT INTO porblt_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Eu vim como uma luz que brilha para o mundo. Então, se vocês creem em mim, não permanecerão nas trevas. ");
INSERT INTO porblt_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Eu não julgo quem ouve as minhas palavras, mas não as segue. Eu vim para salvar o mundo, não para julgá-lo. ");
INSERT INTO porblt_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Qualquer pessoa que me rejeita e não aceita as minhas palavras será julgada no julgamento final de acordo com o que eu disse. ");
INSERT INTO porblt_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Pois eu não estou falando por mim mesmo, mas pelo meu Pai, que me enviou. Foi ele quem me orientou sobre o que eu devia dizer e como dizer. ");
INSERT INTO porblt_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Eu sei que o seu mandamento traz a vida eterna. Então, qualquer coisa que eu diga é o que o Pai me disse.” ");
INSERT INTO porblt_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Um dia antes da festa da Páscoa, Jesus sabia que havia chegado o momento de deixar este mundo e ir se juntar ao seu Pai. Ele amou os seus que estavam neste mundo e, agora, demonstrava o completo e verdadeiro amor que sentia por eles. ");
INSERT INTO porblt_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesus e os discípulos estavam jantando. E o diabo já havia colocado na mente de Judas, filho de Simão Iscariotes, o pensamento de trair Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus sabia que o Pai tinha colocado tudo sob o seu poder, e que ele tinha vindo de Deus e que para Deus estava voltando. ");
INSERT INTO porblt_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Então, Jesus ficou em pé, tirou seu manto e enrolou uma toalha em volta da cintura. ");
INSERT INTO porblt_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ele colocou água em uma bacia e começou a lavar os pés dos discípulos, secando-os com a toalha que havia amarrado na cintura. ");
INSERT INTO porblt_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ele se aproximou de Simão Pedro, que lhe perguntou: “O Senhor irá lavar os meus pés?” ");
INSERT INTO porblt_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus respondeu: “Você não compreende o que estou fazendo por você agora. Mas, um dia, entenderá.” ");
INSERT INTO porblt_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","“Não!”, Pedro protestou. “Você nunca lavará os meus pés!” Jesus respondeu: “Se eu não fizer isso, você não será mais meu discípulo!” ");
INSERT INTO porblt_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","“Então, Senhor, lave não apenas os meus pés, mas as minhas mãos e a minha cabeça também!”, Simão Pedro exclamou. ");
INSERT INTO porblt_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus respondeu: “Aqueles que tomaram banho só precisam lavar os pés e, assim, estarão completamente limpos. Vocês estão limpos, mas não todos.” ");
INSERT INTO porblt_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Pois ele sabia quem era o traidor. É por isto que ele disse: “Vocês estão limpos, mas não todos.” ");
INSERT INTO porblt_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Depois que Jesus lavou os pés deles, ele colocou o seu manto novamente e se sentou. Ele lhes perguntou: “Vocês compreendem o que eu fiz? ");
INSERT INTO porblt_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Vocês me chamam de ‘Mestre’ e ‘Senhor’ e têm razão, pois é isto o que eu sou. ");
INSERT INTO porblt_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Então, se eu, seu Mestre e Senhor, lavei seus pés, vocês devem lavar os pés uns dos outros. ");
INSERT INTO porblt_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Eu dei a vocês o exemplo. Assim, façam como eu fiz a vocês. ");
INSERT INTO porblt_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Eu lhes digo que isto é verdade: os empregados não são mais importantes do que o seu patrão. E aquele que foi enviado não é mais importante do que aquele que o enviou. ");
INSERT INTO porblt_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Agora que vocês já entendem estas coisas, serão felizes se as praticarem. ");
INSERT INTO porblt_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Eu não estou falando sobre todos vocês, pois eu conheço aqueles que foram escolhidos por mim. Mas, isto acontece para que se cumpra a Escritura: ‘Aquele que compartilha o alimento comigo virou-se contra mim.’ ");
INSERT INTO porblt_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Estou lhes dizendo isso agora, antes que aconteça, para que, quando acontecer, vocês se convençam de que eu sou quem sou. ");
INSERT INTO porblt_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Eu lhes digo que isto é verdade: quem receber bem qualquer um que eu envie me recebe bem. E quem me recebe, recebe aquele que me enviou.” ");
INSERT INTO porblt_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Após ter dito isso, Jesus ficou muito aflito e declarou: “Eu lhes digo que isto é verdade: um de vocês irá me trair.” ");
INSERT INTO porblt_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Os discípulos olharam uns para os outros, imaginando sobre qual deles Jesus estava falando. ");
INSERT INTO porblt_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","O discípulo a quem Jesus amava estava sentado ao lado dele na mesa, inclinado próximo a ele. ");
INSERT INTO porblt_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simão Pedro fez um sinal para ele e disse para que perguntasse a Jesus a respeito de qual deles ele estava falando. ");
INSERT INTO porblt_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Então, ele se aproximou de Jesus e perguntou: “Senhor, quem irá traí-lo?” ");
INSERT INTO porblt_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus respondeu: “É aquele a quem eu vou dar um pedaço de pão passado no molho deste prato.” ");
INSERT INTO porblt_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Após molhar o pedaço de pão, ele o deu a Judas, filho de Simão Iscariotes. Assim que Judas comeu o pão, Satanás entrou nele. Jesus lhe disse: “O que você irá fazer, faça rápido!” ");
INSERT INTO porblt_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ninguém dos que estavam à mesa entendeu o que Jesus quis dizer com isso. ");
INSERT INTO porblt_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Como Judas era o responsável pelo dinheiro dos apóstolos, alguns deles pensaram que Jesus estava falando para que Judas fosse comprar o que era necessário para a festa da Páscoa, ou que doasse algo para os pobres. ");
INSERT INTO porblt_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas saiu imediatamente após ter comido o pedaço de pão. E era noite. ");
INSERT INTO porblt_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Depois que Judas saiu, Jesus disse: “Agora o Filho do Homem foi glorificado e, por intermédio dele, Deus também foi glorificado. ");
INSERT INTO porblt_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Se Deus foi glorificado por meio dele, então, Deus irá glorificar o Filho nele mesmo e o glorificará imediatamente. ");
INSERT INTO porblt_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Meus filhos, eu ficarei com vocês apenas por um pouco mais de tempo. Vocês irão procurar por mim, mas eu lhes digo agora exatamente como disse aos judeus: vocês não podem ir para onde eu vou. ");
INSERT INTO porblt_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Eu lhes dou um novo mandamento: Amem uns aos outros. Amem uns aos outros da mesma maneira que eu os amei. ");
INSERT INTO porblt_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Se vocês amarem uns aos outros, provarão a todos que são meus discípulos.” ");
INSERT INTO porblt_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simão Pedro lhe perguntou: “Senhor, para onde é que você vai?” Jesus respondeu: “Você não pode me seguir agora para onde eu estou indo. Mais tarde você irá me seguir.” ");
INSERT INTO porblt_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","“Senhor, por que eu não posso segui-lo agora?”, Pedro perguntou. “Eu daria a minha vida pelo senhor.” ");
INSERT INTO porblt_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","“Você realmente está pronto para morrer por mim? Eu lhe digo que isto é verdade: antes que o galo cante, você irá me negar três vezes”, Jesus respondeu. ");
INSERT INTO porblt_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Não fiquem angustiados. Creiam em Deus e creiam em mim também. ");
INSERT INTO porblt_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na casa do meu Pai há muitos quartos. Se não fosse assim, eu teria dito a vocês. Eu irei preparar um lugar para cada um de vocês. ");
INSERT INTO porblt_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Quando eu tiver ido e preparado um lugar para vocês, voltarei e os levarei comigo, para que possam estar lá comigo também. ");
INSERT INTO porblt_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Vocês conhecem o caminho para o lugar aonde eu vou.” ");
INSERT INTO porblt_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomé lhe disse: “Senhor, nós não sabemos aonde é que o senhor vai. Como podemos conhecer o caminho para esse lugar?” ");
INSERT INTO porblt_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus respondeu: “Eu sou o caminho, a verdade e a vida. Ninguém vem ao Pai, a não ser por mim. ");
INSERT INTO porblt_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Se vocês me conhecessem, conheceriam também o meu Pai. A partir de agora, vocês o conhecem e o têm visto.” ");
INSERT INTO porblt_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipe disse: “Senhor, mostre-nos o Pai e isso é o suficiente para nós!” ");
INSERT INTO porblt_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus respondeu: “Filipe, há tanto tempo estou com vocês, e você ainda não me conhece? Quem me vê, também vê o Pai. Como você pode dizer: ‘Mostre-nos o Pai’? ");
INSERT INTO porblt_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Você não acredita que eu vivo no Pai e que o Pai vive em mim? As palavras que eu falo não são minhas; é o Pai que vive em mim que está fazendo o seu trabalho. ");
INSERT INTO porblt_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Acredite em mim quando lhes digo que eu vivo no Pai e que o Pai vive em mim ou, ao menos, creiam por causa de tudo o que eu já fiz. ");
INSERT INTO porblt_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Eu lhes digo que isto é verdade: quem crê em mim fará as mesmas coisas que eu estou fazendo. Na verdade, fará coisas até maiores, pois eu estou indo para o Pai. ");
INSERT INTO porblt_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Eu farei qualquer coisa que vocês pedirem em meu nome, para que o Pai possa ser glorificado por intermédio do Filho. ");
INSERT INTO porblt_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Eu farei qualquer coisa que vocês me pedirem em meu nome. ");
INSERT INTO porblt_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Se vocês me amam, obedecerão aos meus mandamentos. ");
INSERT INTO porblt_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Eu pedirei ao Pai, e ele lhes dará outro Consolador, ");
INSERT INTO porblt_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","o Espírito da verdade, que sempre estará com vocês. O mundo não pode recebê-lo, porque não está esperando por ele e não o conhece. Mas, vocês o conhecem, porque ele vive com vocês e estará em vocês. ");
INSERT INTO porblt_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Eu não os deixarei abandonados como órfãos; eu voltarei para vocês. ");
INSERT INTO porblt_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Logo o mundo não me verá mais, porém vocês irão me ver. E, porque eu vivo, vocês também irão viver. ");
INSERT INTO porblt_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nesse dia, vocês saberão que eu vivo no Pai, que vocês vivem em mim e que eu vivo em vocês. ");
INSERT INTO porblt_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Aqueles que obedecem aos meus mandamentos são os que me amam. Aqueles que me amam serão também amados por meu Pai. Eu também os amarei e irei mostrar quem eu sou para eles.” ");
INSERT INTO porblt_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas, não o Iscariotes, perguntou: “Senhor, por que você se mostraria para nós e não para o mundo?” ");
INSERT INTO porblt_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus respondeu: “Aqueles que me amam farão como eu digo. Meu Pai os amará e, então, nós viremos e viveremos com eles. ");
INSERT INTO porblt_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Aqueles que não me amam não farão como eu digo. Essas palavras não vêm de mim, mas, sim, do Pai, que me enviou. ");
INSERT INTO porblt_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Eu lhes digo tudo isso enquanto ainda estou aqui com vocês. ");
INSERT INTO porblt_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mas, quando o Pai enviar o Consolador, o Espírito Santo, em meu lugar, ele lhes ensinará todas as coisas e fará com que se lembrem de tudo o que eu disse a vocês. ");
INSERT INTO porblt_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Eu deixo com vocês a paz. Eu lhes dou a minha paz. A paz que eu lhes dou não é como a paz que o mundo dá. Não fiquem angustiados e não tenham medo. ");
INSERT INTO porblt_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Vocês me ouviram dizer: ‘Estou indo embora. Mas eu voltarei para vocês.’ Se vocês realmente me amassem, ficariam felizes por eu estar indo para o Pai, pois o Pai é maior do que eu. ");
INSERT INTO porblt_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Eu lhes digo tudo isso antes mesmo que aconteça, para que, quando acontecer, vocês creiam. ");
INSERT INTO porblt_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Eu não posso falar muito mais, pois o príncipe do mundo está chegando. Ele não tem autoridade para me controlar, ");
INSERT INTO porblt_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","mas eu estou fazendo o que meu Pai me disse que deve ser feito, pois, assim, o mundo saberá que eu amo o Pai. Agora, levantem-se! Vamos sair daqui!” ");
INSERT INTO porblt_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Eu sou a videira verdadeira, e o meu Pai é o agricultor. ");
INSERT INTO porblt_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ele corta todos os ramos que há em mim que não dão frutos. E ele poda todo o ramo que produz fruto, para que possa produzir ainda mais frutos. ");
INSERT INTO porblt_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Vocês já estão podados e limpos pela mensagem que eu lhes tenho passado. ");
INSERT INTO porblt_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Permaneçam em mim, e eu permanecerei em vocês. Exatamente como um ramo não pode produzir uvas, a não ser que continue a fazer parte da videira, o mesmo acontece com vocês, que só podem produzir frutos se permanecerem comigo. ");
INSERT INTO porblt_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Eu sou a videira e vocês são os ramos. Aqueles que permanecem em mim, e eu neles, produzirão muitos frutos, pois longe de mim vocês não podem fazer nada. ");
INSERT INTO porblt_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Quem não permanece em mim é como um ramo que é arrancado e seca. Esses ramos são juntados e jogados no fogo para serem queimados. ");
INSERT INTO porblt_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Se vocês permanecerem em mim e minhas palavras permanecerem em vocês, então, poderão pedir o que quiserem e receberão. ");
INSERT INTO porblt_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","O poder do meu Pai se revela quando vocês produzem muitos frutos e, assim, vocês provam que são meus discípulos. ");
INSERT INTO porblt_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Da mesma maneira que o Pai me amou, eu amei vocês. Permaneçam em meu amor. ");
INSERT INTO porblt_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Se vocês fizerem o que eu digo, permanecerão em meu amor, assim como eu faço o que o meu Pai diz e permaneço em seu amor. ");
INSERT INTO porblt_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Eu lhes digo isso para que a minha alegria esteja com vocês e para que a alegria de vocês possa ser completa. ");
INSERT INTO porblt_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Este é o meu mandamento: amem uns aos outros como eu os amei. ");
INSERT INTO porblt_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Não há amor maior do que aquele que dá a sua vida pelos seus amigos. ");
INSERT INTO porblt_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Vocês são meus amigos se fizerem o que eu lhes digo. ");
INSERT INTO porblt_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Eu não os chamo mais de empregados, pois o patrão não compartilha seus pensamentos com os empregados. Eu os chamo de amigos, pois tudo o que o meu Pai me disse eu expliquei para vocês. ");
INSERT INTO porblt_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Vocês não me escolheram. Fui eu quem os escolhi. Eu lhes dei a responsabilidade de irem e produzirem frutos que não se percam e permaneçam. Então, o Pai lhes dará qualquer coisa que pedirem em meu nome. ");
INSERT INTO porblt_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Este é o meu mandamento para vocês: amem uns aos outros. ");
INSERT INTO porblt_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Se o mundo odiar vocês, lembrem-se de que ele me odiou primeiro. ");
INSERT INTO porblt_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Se vocês fossem do mundo, ele os amaria, por vocês serem dele. Mas, vocês não são do mundo. E eu os escolhi e os tirei do mundo; por isso ele odeia vocês. ");
INSERT INTO porblt_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Lembrem-se do que eu lhes disse: os empregados não são mais importantes do que o seu patrão. Se eles me perseguiram, também irão persegui-los. Se eles obedeceram às minhas palavras, também obedecerão as suas. ");
INSERT INTO porblt_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mas, tudo o que eles fizerem para vocês será por minha causa, pois eles não conhecem aquele que me enviou. ");
INSERT INTO porblt_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Se eu não tivesse vindo e falado com eles, pecado não teriam. Mas agora, eles não podem mais dar desculpas por seus pecados. ");
INSERT INTO porblt_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Quem me odeia também odeia o meu Pai. ");
INSERT INTO porblt_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Se eu não tivesse lhes dado uma demonstração por meio das coisas que nunca ninguém fez antes, pecado não teriam. Mas, apesar de testemunhar tudo o que fiz, eles odiaram tanto a mim quanto ao meu Pai. ");
INSERT INTO porblt_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","No entanto, isso acontece para que se cumpra o que diz a lei deles: ‘Eles me odiaram sem motivo algum.’ ");
INSERT INTO porblt_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Mas, eu enviarei a vocês o Consolador, que vem do Pai. Quando ele vier, falará a respeito de mim. Ele é o Espírito da verdade, que vem do Pai. ");
INSERT INTO porblt_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Vocês também falarão a meu respeito, porque estão comigo desde o início. ");
INSERT INTO porblt_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Eu lhes disse isso para que vocês não percam sua fé em mim. ");
INSERT INTO porblt_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Eles expulsarão vocês das sinagogas e, na verdade, chegará o tempo em que aquele que matar vocês pensará que está fazendo a vontade de Deus. ");
INSERT INTO porblt_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Eles farão isso porque nunca conheceram o Pai ou a mim. Eu lhes disse isso para que, quando essas coisas acontecerem, vocês se lembrem de que eu já os tinha avisado. ");
INSERT INTO porblt_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Eu não precisava lhes dizer isso logo no início, porque eu estava com vocês. ");
INSERT INTO porblt_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mas agora, eu irei me juntar àquele que me enviou e, ainda assim, nenhum de vocês me pergunta: ‘Para onde o senhor está indo?’ ");
INSERT INTO porblt_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Eu sei que agora que eu lhes disse isso, vocês estão sofrendo muito. ");
INSERT INTO porblt_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mas, eu lhes digo que isto é verdade: é melhor para vocês que eu vá, porque se eu não for, o Auxiliador não virá para vocês. Se eu for, o enviarei para vocês. ");
INSERT INTO porblt_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Quando ele vier, irá convencer as pessoas do mundo de que elas têm uma ideia errada a respeito do pecado, do que é justo e do julgamento: ");
INSERT INTO porblt_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Errada quanto ao pecado, porque elas não creem em mim. ");
INSERT INTO porblt_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Errada em relação ao que é justo, porque eu estou indo para junto do Pai, e vocês não irão mais me ver. ");
INSERT INTO porblt_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","E errada quanto ao julgamento, porque quem governa este mundo já foi condenado. ");
INSERT INTO porblt_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Há muito mais que eu gostaria de explicar a vocês, mas, no momento, vocês não suportariam saber. ");
INSERT INTO porblt_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","No entanto, quando o Espírito da verdade vier, ele fará com que conheçam toda a verdade. Ele não falará por si mesmo, mas dirá tudo o que ouviu, e lhes dirá o que vai acontecer. ");
INSERT INTO porblt_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","O Espírito trará glória para mim, pois ele lhes ensinará tudo o que ele receber de mim. ");
INSERT INTO porblt_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","E tudo o que pertence ao Pai também me pertence. É por isso que eu digo que o Espírito irá lhes ensinar tudo o que eu disser a ele. ");
INSERT INTO porblt_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Em pouco tempo, vocês não irão mais me ver; mas, um pouco depois, vocês me verão novamente.” ");
INSERT INTO porblt_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Alguns dos seus discípulos comentaram: “O que ele quer dizer com: ‘Em pouco tempo, vocês não irão me ver mais; mas, um pouco depois, vocês me verão novamente’? E também quando disse: ‘Porque eu estou indo para junto do Pai’?” ");
INSERT INTO porblt_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Eles se perguntavam também: “O que ele quer dizer com: ‘em pouco tempo’? Nós não sabemos sobre o que ele está falando.” ");
INSERT INTO porblt_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus percebeu que eles queriam lhe perguntar a respeito do que ele havia falado. Então, ele perguntou aos discípulos: “Vocês estão pensando sobre eu ter falado que em pouco tempo vocês não iriam mais me ver, mas que pouco tempo depois, vocês me veriam novamente, não é? ");
INSERT INTO porblt_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Eu lhes digo que isto é verdade: vocês irão chorar e lamentar, mas as pessoas deste mundo se alegrarão com isso. Vocês irão sofrer, mas o seu sofrimento se transformará em alegria. ");
INSERT INTO porblt_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Uma mulher que está para dar à luz sente dor, porque a sua hora chegou. Mas quando o bebê nasce, ela se esquece do sofrimento, por causa da alegria por ter trazido uma criança a este mundo. ");
INSERT INTO porblt_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","E o mesmo acontece com vocês, pois estão sofrendo agora; mas, eu os verei de novo; e vocês ficarão muito felizes, e ninguém poderá tirar de vocês esse sentimento bom. ");
INSERT INTO porblt_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Quando esse dia chegar, vocês não precisarão me pedir nada. Eu lhes digo que isto é verdade: o Pai irá lhes dar tudo o que vocês pedirem em meu nome. ");
INSERT INTO porblt_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Até agora, vocês não pediram nada em meu nome. Então, peçam e receberão. Assim, a sua felicidade estará completa. ");
INSERT INTO porblt_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Eu tenho passado os meus ensinamentos para vocês por meio de histórias. Mas, logo, não falarei mais com vocês dessa forma. Em vez disso, eu explicarei a respeito do Pai para vocês de uma maneira muito direta. ");
INSERT INTO porblt_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nesse dia, vocês pedirão coisas em meu nome. Eu não estou dizendo que pedirei ao Pai por vocês, ");
INSERT INTO porblt_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","porque o próprio Pai os ama. E isso é porque vocês me amam e creem que eu tenha vindo de Deus. ");
INSERT INTO porblt_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Eu deixei o Pai e vim para o mundo. Agora, deixo o mundo e volto para o Pai.” ");
INSERT INTO porblt_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Então, os discípulos disseram: “Agora, sim, você está falando claramente e não está usando histórias para passar sua mensagem. ");
INSERT INTO porblt_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Agora, sim, nós temos certeza de que o senhor tudo sabe. E, justamente por isso, não precisa que lhe façam perguntas. Por isso cremos que o senhor veio de Deus.” ");
INSERT INTO porblt_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","“Vocês realmente acreditam agora?”, Jesus perguntou. ");
INSERT INTO porblt_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","“Está chegando o momento, e, na verdade, já chegou, em que vocês irão se espalhar, cada um indo para a sua própria casa e irão me deixar completamente sozinho. Mas, eu não estarei realmente só, porque o Pai estará comigo. ");
INSERT INTO porblt_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Eu lhes disse tudo isso para que vocês tenham paz, pois vocês estão unidos a mim. Vocês irão sofrer neste mundo; mas sejam fortes! Pois eu venci o mundo!” ");
INSERT INTO porblt_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Quando Jesus terminou de falar, ele olhou para o céu e disse: “Pai, a hora chegou. Glorifique o seu Filho, para que ele possa glorificá-lo também. ");
INSERT INTO porblt_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pois você deu ao seu Filho autoridade sobre todas as pessoas, para que ele possa dar vida eterna a todos aqueles que o Senhor deu a ele. ");
INSERT INTO porblt_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","E a vida eterna significa conhecê-lo, o único Deus verdadeiro, e conhecer Jesus Cristo, aquele que você enviou. ");
INSERT INTO porblt_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Eu trouxe glória para você aqui na terra, terminando assim a obra que me deu para fazer. ");
INSERT INTO porblt_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Agora, Pai, deixe que, em sua presença, eu tenha a mesma grandeza que eu tinha junto a você antes que o mundo existisse. ");
INSERT INTO porblt_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Eu mostrei quem você é para todos os que você tirou do mundo e me deu. Eles pertenciam a você, e você os deu para mim. E, por isso, eles têm feito como você mandou. ");
INSERT INTO porblt_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Agora, eles sabem que tudo o que tenho vem do Senhor. ");
INSERT INTO porblt_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Eu lhes dei a mensagem que o Senhor me transmitiu. Eles aceitaram a sua mensagem e se convenceram totalmente de que eu vim de você e de que você me enviou. ");
INSERT INTO porblt_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Eu estou pedindo por eles, não pelo mundo, mas, sim, por aquelas pessoas que você me deu, pois elas pertencem a você. ");
INSERT INTO porblt_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Todos os que pertencem a mim são seus, e todos os que pertencem a você são meus, e a minha glória se mostra por meio deles. ");
INSERT INTO porblt_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Eu estou indo embora do mundo, mas eles permanecerão no mundo. Eu estou indo para junto do Senhor. Pai Santo, proteja-os em seu nome, o nome que o Senhor me deu, para que eles sejam um, exatamente como o Senhor e eu somos um. ");
INSERT INTO porblt_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Enquanto estava com eles, eu protegi, em seu nome, aqueles que o Senhor me deu. Eu cuidei deles e nenhum se perdeu, a não ser o ‘filho da perdição,’ para que, assim, as Sagradas Escrituras fossem cumpridas. ");
INSERT INTO porblt_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Agora, eu estou indo para junto do Senhor. E eu digo essas coisas enquanto ainda estou aqui no mundo, para que eles tenham a plenitude de minha alegria em si mesmos. ");
INSERT INTO porblt_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Eu lhes dei a sua mensagem, mas o mundo os odiou, porque eles não são do mundo, assim como eu também não sou. ");
INSERT INTO porblt_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Eu não estou lhe pedindo para que os tire do mundo e, sim, para que você os proteja do maligno. ");
INSERT INTO porblt_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Eles não são do mundo, assim como eu também não sou. ");
INSERT INTO porblt_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Que eles sejam seus, por meio da verdade. E a sua mensagem é a verdade. ");
INSERT INTO porblt_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Da mesma maneira que o Senhor me enviou ao mundo, eu os enviei ao mundo. ");
INSERT INTO porblt_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Em favor deles eu me entrego completamente ao Senhor, para que também eles possam ser completamente seus. ");
INSERT INTO porblt_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Eu não estou pedindo apenas por eles. Também peço por aqueles que vão crer em mim por causa da mensagem que eles irão transmitir. ");
INSERT INTO porblt_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Eu peço para que todos possam ser um, exatamente como você, Pai, está unido a mim e eu unido a você. Assim eles também estejam unidos a nós, fazendo com que o mundo acredite que você me enviou. ");
INSERT INTO porblt_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Eu dei a eles a glória que você me deu, a fim de que eles possam ser um, exatamente como nós somos um. ");
INSERT INTO porblt_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Eu estou unido com eles e você está unido a mim. Que eles sejam completamente unidos; assim, o mundo todo saberá que você me enviou e que você os ama da mesma maneira que me ama. ");
INSERT INTO porblt_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Pai, eu quero que aqueles que o Senhor me deu estejam comigo onde eu estiver, para que possam ver a glória que você me deu, pois você já me amava antes mesmo de o mundo ser criado. ");
INSERT INTO porblt_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bom Pai, o mundo não o conhece, mas eu, sim, e aqueles que estão aqui comigo sabem que você me enviou. ");
INSERT INTO porblt_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Eu mostrei para eles o seu caráter e continuarei a fazer isso, para que o amor que o Senhor tem por mim esteja neles, e também para que eu continue unido a eles.” ");
INSERT INTO porblt_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Depois que Jesus terminou de falar, ele e os seus discípulos atravessaram o riacho de Cedrom, onde havia um jardim, onde Jesus entrou com eles. ");
INSERT INTO porblt_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, o traidor, conhecia o lugar, pois Jesus sempre ia até lá com os seus discípulos. ");
INSERT INTO porblt_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Então, Judas levou uma tropa de soldados com ele, além de guardas dos chefes dos sacerdotes e dos fariseus. Eles chegaram até lá, carregando tochas, lampiões e armas. ");
INSERT INTO porblt_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus já sabia tudo o que aconteceria com ele. Ele foi encontrá-los e perguntou: “Por quem vocês procuram?” ");
INSERT INTO porblt_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Eles responderam: “Jesus de Nazaré!” Então, Jesus lhes disse: “Sou eu!” Judas, o traidor, estava em pé com eles. ");
INSERT INTO porblt_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Quando Jesus disse: “Sou eu!”, eles recuaram e caíram no chão. ");
INSERT INTO porblt_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Então, ele novamente lhes perguntou: “Quem vocês procuram?” E eles novamente responderam: “Jesus de Nazaré!” ");
INSERT INTO porblt_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus respondeu: “Eu já lhes disse que sou eu. Então, se eu sou quem vocês procuram, deixem que esses outros vão embora.” ");
INSERT INTO porblt_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Estas palavras cumpriram o que Jesus tinha dito antes: “Eu não perdi nenhum daqueles que você me deu.” ");
INSERT INTO porblt_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Então, Simão Pedro tirou uma espada e atingiu Malco, o empregado do grande sacerdote, cortando sua orelha direita. ");
INSERT INTO porblt_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus disse a Pedro: “Guarde a espada! Você acha que eu não deveria beber do cálice que o meu Pai me deu?” ");
INSERT INTO porblt_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Então, os soldados, o comandante da tropa e os guardas dos judeus prenderam Jesus e amarraram as suas mãos. ");
INSERT INTO porblt_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Primeiro, eles o levaram até à casa de Anás, que era sogro de Caifás, o grande sacerdote naquele ano. ");
INSERT INTO porblt_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Foi Caifás quem falou para os judeus: “É melhor que morra apenas um homem pelo povo.” ");
INSERT INTO porblt_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simão Pedro e um outro discípulo seguiram Jesus. O discípulo era conhecido do grande sacerdote e, por isso, ele entrou no pátio da casa do grande sacerdote com Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mas, Pedro ficou do lado de fora, próximo à porta. Então, o outro discípulo que conhecia o grande sacerdote foi e falou com a empregada que cuidava da porta, para que deixasse Pedro entrar. ");
INSERT INTO porblt_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","A garota perguntou a Pedro: “Você não é um dos discípulos daquele homem?” Pedro respondeu: “Eu? Não, eu não sou!” ");
INSERT INTO porblt_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Estava frio, e os empregados e os guardas estavam perto de uma fogueira, que fizeram para se aquecerem. Pedro ficou perto deles para se aquecer também. ");
INSERT INTO porblt_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Então, o grande sacerdote, Anás, perguntou a Jesus a respeito dos seus discípulos e sobre o que ele havia ensinado. ");
INSERT INTO porblt_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus respondeu: “Eu tenho falado publicamente a todos. Eu sempre ensinei nas sinagogas e no Templo, onde todo o povo judeu se reúne. Eu nunca disse nada em segredo. ");
INSERT INTO porblt_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Então, por que você está me fazendo essas perguntas? Pergunte para as pessoas que me ouviram o que eu lhes disse! Elas sabem o que eu disse!” ");
INSERT INTO porblt_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Quando Jesus disse isso, um dos guardas, que estava próximo a ele, deu um tapa em seu rosto e disse: “Isso é maneira de falar com o grande sacerdote?” ");
INSERT INTO porblt_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus respondeu: “Se eu disse algo errado, então, mostre a todos o erro. Mas, se eu disse a verdade, por que você me bateu?” ");
INSERT INTO porblt_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anás enviou Jesus, com as mãos ainda amarradas, para o grande sacerdote, Caifás. ");
INSERT INTO porblt_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Enquanto Simão Pedro ainda estava perto da fogueira se aquecendo, as pessoas lhe perguntaram: “Você não é um dos discípulos dele?” Pedro negou e disse: “Não, eu não sou!” ");
INSERT INTO porblt_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Um dos empregados do grande sacerdote, um parente do homem a quem Pedro cortara a orelha, perguntou: “Eu não o vi com ele no jardim?” ");
INSERT INTO porblt_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro negou de novo, e, logo em seguida, um galo cantou. ");
INSERT INTO porblt_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","No dia seguinte, bem cedo, eles levaram Jesus da casa de Caifás para o palácio do governador romano. Os líderes judeus não entraram no palácio porque, se eles o fizessem, estariam cerimonialmente impuros, e eles queriam estar puros para comerem a refeição da Páscoa. ");
INSERT INTO porblt_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Então, Pilatos saiu para encontrá-los. Ele perguntou: “Do que acusam este homem?” ");
INSERT INTO porblt_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Eles responderam: “Se ele não fosse um criminoso, nós não o teríamos trazido até o senhor.” ");
INSERT INTO porblt_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatos lhes disse: “Então, levem este homem e o julguem de acordo com a sua lei.” Os judeus responderam: “Nós não podemos matar ninguém.” ");
INSERT INTO porblt_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Assim se cumpriu o que Jesus tinha dito sobre como ele morreria. ");
INSERT INTO porblt_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatos entrou novamente em seu palácio. Ele chamou Jesus e lhe perguntou: “Você é o Rei dos Judeus?” ");
INSERT INTO porblt_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus respondeu: “Esta pergunta é do senhor mesmo? Ou foram outras pessoas que falaram para você sobre mim?” ");
INSERT INTO porblt_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","“Por acaso eu sou judeu?”, Pilatos disse. “Foi o seu próprio povo e os chefes dos sacerdotes que o entregaram a mim. O que foi que você fez?” ");
INSERT INTO porblt_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus respondeu: “Meu Reino não é deste mundo. Se fosse deste mundo, os meus seguidores lutariam para que eu não fosse entregue aos judeus. Mas, o meu Reino não é daqui.” ");
INSERT INTO porblt_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Depois, Pilatos perguntou: “Então você é rei?” Jesus respondeu: “É o senhor quem diz que eu sou rei. A razão de eu ter nascido e vindo para o mundo foi para falar a verdade. Todos aqueles que aceitam a verdade prestam atenção no que eu digo.” ");
INSERT INTO porblt_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“O que é a verdade?” Ao dizer isso, Pilatos saiu e disse aos judeus: “Eu considero que ele não é culpado de crime algum. ");
INSERT INTO porblt_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","No entanto, segundo o costume de vocês, eu liberto um prisioneiro na Páscoa. Vocês querem que eu solte o Rei dos Judeus?” ");
INSERT INTO porblt_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Eles gritaram: “Não, ele não! Nós queremos que solte Barrabás.” Barrabás era um criminoso. ");
INSERT INTO porblt_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Então, Pilatos mandou chicotear Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Os soldados fizeram uma coroa de espinhos e a colocaram na cabeça dele. Também o vestiram com um manto púrpura. ");
INSERT INTO porblt_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Eles se aproximavam dele e diziam: “Viva o Rei dos Judeus!”, e batiam em seu rosto. ");
INSERT INTO porblt_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatos saiu mais uma vez e disse aos judeus: “Eu o trouxe aqui fora para que vocês saibam que eu não o considero culpado de crime algum.” ");
INSERT INTO porblt_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Então, Jesus veio para fora com a coroa de espinhos e o manto púrpura. Pilatos disse: “Vejam! Aqui está o homem!” ");
INSERT INTO porblt_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Quando os chefes dos sacerdotes e os guardas viram Jesus, eles gritaram: “Crucifique-o! Crucifique-o!” Pilatos respondeu: “Vocês que o levem e o crucifiquem. Pois para mim ele não é culpado.” ");
INSERT INTO porblt_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Os líderes judeus responderam: “Nós temos uma lei e, de acordo com essa lei, ele deve morrer, porque ele diz ser o Filho de Deus.” ");
INSERT INTO porblt_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Quando Pilatos ouviu isso, ficou ainda com mais receio ");
INSERT INTO porblt_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","e voltou para o palácio. Ele perguntou a Jesus: “De onde você é?” Mas, Jesus não respondeu. ");
INSERT INTO porblt_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","“Você está se recusando a conversar comigo?”, Pilatos disse a Jesus. “Você não percebe que eu tenho poder para libertá-lo ou crucificá-lo?” ");
INSERT INTO porblt_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus respondeu: “O senhor não teria poder sobre mim, se esse não lhe fosse dado por Deus. Portanto, quem me entregou ao senhor é culpado de um pecado maior.” ");
INSERT INTO porblt_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Depois que Pilatos ouviu isso, ele tentou libertar Jesus. Mas os líderes judeus gritaram: “Se você libertar esse homem, você não é amigo do imperador romano. Qualquer um que se diz rei está se rebelando contra César.” ");
INSERT INTO porblt_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ao ouvir isso, Pilatos trouxe Jesus para fora e sentou-se no tribunal, em um lugar chamado Calçada de Pedra (em hebraico, Gabatá). ");
INSERT INTO porblt_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Era quase meio-dia no dia da preparação, um dia antes da Páscoa. Pilatos disse aos judeus: “Vejam! Aqui está o seu rei!” ");
INSERT INTO porblt_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","E eles gritavam: “Mate-o! Mate-o! Crucifique-o!” “Vocês querem que eu crucifique o seu rei?” Os chefes dos sacerdotes responderam: “O único rei que nós temos é César.” ");
INSERT INTO porblt_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Então, Pilatos entregou Jesus para ser crucificado. ");
INSERT INTO porblt_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Eles levaram Jesus dali. Ele carregava sua própria cruz e foi levado para um lugar chamado Calvário (Gólgota, em hebraico). ");
INSERT INTO porblt_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Eles o crucificaram lá, juntamente com dois prisioneiros, um de cada lado dele. ");
INSERT INTO porblt_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatos ordenou que fosse colocado um letreiro na parte de cima da cruz, no qual se lia: “Jesus de Nazaré, o Rei dos Judeus.” ");
INSERT INTO porblt_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Muitas pessoas leram o letreiro, pois o local em que Jesus tinha sido crucificado ficava perto da cidade. Esse letreiro foi escrito em hebraico, latim e grego. ");
INSERT INTO porblt_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Então, os chefes dos sacerdotes foram até Pilatos e lhe pediram: “Não escreva ‘o Rei dos Judeus’, mas, sim, ‘Este homem disse: Eu sou o Rei dos Judeus.’” ");
INSERT INTO porblt_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatos respondeu: “O que eu escrevi, escrevi!” ");
INSERT INTO porblt_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Quando os soldados crucificaram Jesus, eles tiraram as roupas dele e as dividiram em quatro partes, para que cada soldado ficasse com alguma peça. Havia também o manto, feito de uma peça só de tecido, sem costura. ");
INSERT INTO porblt_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Então, eles disseram uns aos outros: “Não vamos rasgar esse manto. É melhor que joguemos os dados para ver quem ficará com ele.” Assim, se cumpriu o trecho das Sagradas Escrituras que diz: “Eles dividiram minhas roupas entre si e jogaram os dados para decidir quem ficaria com o meu manto.” E foi exatamente assim que os soldados fizeram. ");
INSERT INTO porblt_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Perto da cruz estavam Maria, mãe de Jesus, e a irmã dela, e Maria, esposa de Clopas e Maria Madalena. ");
INSERT INTO porblt_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Quando Jesus viu a sua mãe, e o discípulo a quem ele amava ao lado dela, ele disse a sua mãe: “Mãe, este é o seu filho.” ");
INSERT INTO porblt_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","E, depois, disse ao discípulo: “Esta é a sua mãe.” A partir de então, o discípulo levou Maria para que ela morasse na casa dele. ");
INSERT INTO porblt_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesus, então, percebeu que havia terminado tudo o que tinha vindo fazer. Para que se cumprisse o que está escrito nas Sagradas Escrituras, disse: “Estou com sede!” ");
INSERT INTO porblt_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lá, havia uma vasilha com vinagre de vinho. Então, eles molharam uma esponja nesse líquido, colocaram a esponja na ponta de um ramo de hissopo e molharam os lábios de Jesus. ");
INSERT INTO porblt_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Após isso, Jesus disse: “Tudo está completado!” Ele, então, inclinou a cabeça e deu seu último suspiro. ");
INSERT INTO porblt_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Era o dia da preparação, e os líderes judeus não queriam que os corpos ficassem expostos nas cruzes no sábado (de fato, esse era um sábado especial). Então, eles pediram a Pilatos que as pernas dos crucificados fossem quebradas, para que os corpos pudessem ser tirados de lá. ");
INSERT INTO porblt_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Assim, os soldados vieram e quebraram as pernas do primeiro homem que havia sido crucificado com Jesus e depois quebram as pernas do outro. ");
INSERT INTO porblt_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mas, quando eles se aproximaram de Jesus, viram que ele já havia morrido, e por isso não quebraram as pernas dele. ");
INSERT INTO porblt_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","No entanto, um dos soldados furou o lado de Jesus com uma lança. Nesse momento, saiu sangue e água. ");
INSERT INTO porblt_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Quem viu isso contou o que aconteceu, e o seu testemunho é verdadeiro. Ele tem certeza de que o que diz é verdade; então, vocês também podem crer. ");
INSERT INTO porblt_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Isso aconteceu assim para que se cumprisse o que está escrito nas Sagradas Escrituras: “Nenhum dos seus ossos será quebrado”, ");
INSERT INTO porblt_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","e o que está escrito em outro trecho das Escrituras que diz: “Eles irão olhar para aquele a quem perfuraram com a lança.” ");
INSERT INTO porblt_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Depois disso, José de Arimateia perguntou a Pilatos se ele poderia retirar o corpo de Jesus, e Pilatos lhe deu permissão. José era um discípulo de Jesus, mas mantinha isso em segredo, pois tinha medo dos judeus. Então, José veio e levou o corpo. ");
INSERT INTO porblt_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ele foi ajudado por Nicodemos, aquele que viera falar com Jesus à noite. Ele trouxe cerca de trinta e quatro quilos de uma mistura de mirra e aloés. ");
INSERT INTO porblt_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Eles pegaram o corpo de Jesus e o envolveram em lençóis juntamente com essa mistura, seguindo o costume do sepultamento judaico. ");
INSERT INTO porblt_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Havia um jardim próximo ao local onde Jesus fora crucificado. Nesse jardim havia um túmulo novo que ainda não tinha sido usado. ");
INSERT INTO porblt_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Como era o dia judaico da preparação e o túmulo estava próximo, eles colocaram o corpo de Jesus lá. ");
INSERT INTO porblt_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Logo cedo, no primeiro dia da semana, enquanto ainda estava escuro, Maria Madalena foi até o túmulo e viu que a pedra que estava na entrada dele havia sido retirada. ");
INSERT INTO porblt_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Então, ela correu para avisar Simão Pedro e o outro discípulo, aquele a quem Jesus amava: “Eles tiraram o Senhor do seu túmulo e não sabemos para onde o levaram!” ");
INSERT INTO porblt_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Então, Pedro e o outro discípulo foram até o túmulo. ");
INSERT INTO porblt_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Os dois corriam juntos, mas o outro discípulo foi mais rápido e chegou primeiro ao túmulo. ");
INSERT INTO porblt_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ele se inclinou e, ao olhar, viu apenas os lençóis de linho, mas não entrou no túmulo. ");
INSERT INTO porblt_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Então, Simão Pedro chegou depois dele e entrou no túmulo. Ele viu os lençóis de linho ");
INSERT INTO porblt_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","e percebeu que o tecido que havia sido colocado na cabeça de Jesus não estava junto dos outros tecidos e, sim, dobrado e separado dos outros lençóis. ");
INSERT INTO porblt_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Depois, o outro discípulo, que havia chegado ao túmulo primeiro, entrou também. ");
INSERT INTO porblt_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ele olhou em volta e acreditou que era verdade, pois até então, eles não tinham compreendido as Sagradas Escrituras, que dizem que Jesus precisava ressuscitar. ");
INSERT INTO porblt_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Eles, então, voltaram para casa. ");
INSERT INTO porblt_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mas, Maria permaneceu do lado de fora do túmulo, chorando e, enquanto chorava, se inclinou e olhou para dentro do túmulo. ");
INSERT INTO porblt_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ela viu dois anjos com roupas brancas, sentados onde estivera o corpo de Jesus. Um estava sentado na cabeceira e o outro nos pés. ");
INSERT INTO porblt_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Eles perguntaram para Maria: “Por que você está chorando?” Ela respondeu: “Porque levaram o meu Senhor embora e eu não sei onde o colocaram.” ");
INSERT INTO porblt_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Após ter dito isso, ela se virou e viu Jesus ali em pé, mas não o reconheceu. ");
INSERT INTO porblt_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus perguntou a ela: “Por que está chorando? Quem você está procurando?” Pensando que ele fosse o jardineiro, ela lhe disse: “Senhor, se você o levou embora, diga-me onde o colocou, para que eu possa ir buscá-lo.” ");
INSERT INTO porblt_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus lhe respondeu: “Maria!” Ela se virou para ele e respondeu em hebraico: “Rabôni!” (Que significa Mestre.) ");
INSERT INTO porblt_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus lhe disse: “Não me segure, pois eu ainda não subi ao céu para estar junto do meu Pai. Vá até os meus irmãos e lhes diga que eu estou subindo ao céu, para junto do meu Pai e do Pai deles, do meu Deus e do Deus deles.” ");
INSERT INTO porblt_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Então, Maria Madalena foi e disse aos discípulos: “Eu vi o Senhor!” E ela lhes contou o que Jesus lhe havia dito. ");
INSERT INTO porblt_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nessa noite, no primeiro dia da semana, os discípulos estavam reunidos a portas fechadas, pois estavam com medo dos judeus. Jesus, então, veio e, em pé, entre eles, disse: “Que a paz esteja com vocês!” ");
INSERT INTO porblt_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Após essa saudação, ele mostrou a eles as suas mãos e o lado do seu corpo. Os discípulos ficaram muito contentes ao verem o Senhor. ");
INSERT INTO porblt_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","“Que a paz esteja com vocês!”, Jesus disse novamente. “Da mesma maneira que o Pai me enviou, eu estou enviando vocês.” ");
INSERT INTO porblt_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ao dizer isso, soprou sobre eles e lhes disse: “Recebam o Espírito Santo! ");
INSERT INTO porblt_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Se vocês perdoarem os pecados de alguém, esses pecados estarão perdoados; mas, se não os perdoarem, eles não estarão perdoados.” ");
INSERT INTO porblt_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Um dos doze discípulos, Tomé, chamado o Gêmeo, não estava com eles quando Jesus chegou. ");
INSERT INTO porblt_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Então, os outros discípulos disseram a ele: “Nós vimos o Senhor!” Mas, ele respondeu: “Eu não acredito; a não ser que eu veja as marcas dos pregos nas mãos dele e as toque com os meus dedos e também coloque a minha mão no lado do seu corpo.” ");
INSERT INTO porblt_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Uma semana depois, os discípulos estavam reunidos dentro de casa, e Tomé estava com eles. As portas estavam trancadas e, mesmo assim, Jesus entrou e ficou em pé entre eles. Ele disse: “Que a paz esteja com vocês!” ");
INSERT INTO porblt_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Então, ele disse a Tomé: “Coloque o seu dedo aqui e olhe as minhas mãos. Coloque a sua mão na ferida no lado do meu corpo. Pare de duvidar e creia em mim!” ");
INSERT INTO porblt_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","“Meu Senhor e meu Deus!”, Tomé respondeu. ");
INSERT INTO porblt_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus lhe disse: “Você crê em mim porque me viu. Felizes são aqueles que não me viram e, ainda assim, creem em mim.” ");
INSERT INTO porblt_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus fez muitos outros milagres, enquanto estava com os seus discípulos, que não estão registrados neste livro. ");
INSERT INTO porblt_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mas, estes foram escritos aqui para que vocês possam crer que Jesus é o Messias, o Filho de Deus e, para que, ao crer nele e em quem ele é, vocês tenham vida por meio dele. ");
INSERT INTO porblt_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Depois disso, Jesus apareceu novamente aos discípulos, junto ao mar da Galileia. Foi assim que aconteceu: ");
INSERT INTO porblt_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simão Pedro, Tomé, o Gêmeo, Natanael de Caná, na Galileia, os filhos de Zebedeu e outros dois discípulos estavam juntos. ");
INSERT INTO porblt_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simão Pedro lhes disse: “Eu vou pescar.” Eles responderam: “Nós iremos com você.” Então, eles saíram e entraram no barco, mas não pegaram um único peixe a noite toda. ");
INSERT INTO porblt_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Quando estava amanhecendo, Jesus estava na praia; mas os discípulos não sabiam que era ele. ");
INSERT INTO porblt_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesus os chamou: “Olá, meus amigos! Vocês pegaram alguma coisa?” Eles responderam: “Nada!” ");
INSERT INTO porblt_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ele lhes disse: “Joguem a rede do lado direito do barco e vocês encontrarão peixe.” Então, eles jogaram a rede, mas não conseguiram puxá-la de volta, porque havia muitos peixes dentro dela. ");
INSERT INTO porblt_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","O discípulo a quem Jesus amava disse a Pedro: “É o Senhor Jesus!” Quando Pedro ouviu que era Jesus, ele se vestiu, pois havia tirado a roupa e pulou no mar. ");
INSERT INTO porblt_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Os outros discípulos seguiram no barco, puxando a rede cheia de peixes, pois eles estavam apenas a uns cem metros da praia. ");
INSERT INTO porblt_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Assim que eles saíram do barco, viram uma fogueira, onde peixes estavam sendo assados e havia também pão. ");
INSERT INTO porblt_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus lhes disse: “Tragam um pouco dos peixes que pegaram.” ");
INSERT INTO porblt_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simão Pedro subiu no barco e arrastou a rede para a terra. Havia cento e cinquenta e três peixes grandes e, mesmo assim, a rede não arrebentou. ");
INSERT INTO porblt_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus lhes disse; “Venham e tomem o café da manhã!” Nenhum dos discípulos teve coragem o bastante de perguntar: “Quem é você?” Eles sabiam que era o Senhor. ");
INSERT INTO porblt_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus pegou o pão e os peixes e os distribuiu entre eles. ");
INSERT INTO porblt_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Essa foi a terceira vez que Jesus apareceu para os discípulos depois que ressuscitara. ");
INSERT INTO porblt_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Depois do café da manhã, Jesus perguntou a Simão Pedro: “Simão, filho de João, você me ama mais do que estes?” Pedro respondeu: “Sim, Senhor! Você sabe que eu o amo!” ");
INSERT INTO porblt_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesus lhe disse: “Cuide das minhas ovelhas!” Jesus perguntou novamente: “Simão, filho de João, você me ama?” Ele respondeu: “Sim, Senhor! Você sabe que eu o amo!” ");
INSERT INTO porblt_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesus lhe disse: “Cuide das minhas ovelhas!” E perguntou uma terceira vez: “Simão, filho de João, você me ama?” Pedro ficou triste por Jesus lhe perguntar uma terceira vez se ele o amava. E respondeu para Jesus: “O Senhor sabe tudo. O Senhor sabe que eu o amo!” Jesus disse: “Cuide das minhas ovelhas!” ");
INSERT INTO porblt_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jesus disse: “Eu lhe digo que isto é verdade: quando você era jovem, você se vestia e ia para onde queria. Mas, quando for velho, você estenderá as suas mãos e alguém o irá vestir e o levará para onde você não quer ir.” ");
INSERT INTO porblt_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesus disse isso para explicar o tipo de morte que Pedro teria e que, assim, ele iria glorificar a Deus. Então, ele disse a Pedro: “Siga-me!” ");
INSERT INTO porblt_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Quando Pedro se virou para trás, ele viu o discípulo a quem Jesus amava, seguindo-os. Foi esse o discípulo que havia chegado mais próximo de Jesus durante a refeição da Páscoa e perguntado: “Senhor, quem irá traí-lo?” ");
INSERT INTO porblt_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro perguntou a Jesus: “E a respeito deste aqui, Senhor?” ");
INSERT INTO porblt_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus lhe respondeu: “Se eu quiser que ele fique vivo até que eu volte, o que você tem a ver com isso? Quanto a você, siga-me!” ");
INSERT INTO porblt_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","E foi assim que se espalhou a notícia entre os seguidores de Jesus de que aquele discípulo não morreria. Mas, Jesus não disse isso. Ele apenas disse: “Se eu quiser que ele fique vivo até que eu volte, o que você tem a ver com isso?” ");
INSERT INTO porblt_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Este é o discípulo que confirma essas coisas e que escreveu a respeito delas. E nós sabemos que o que ele diz é verdade. ");
INSERT INTO porblt_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesus fez muitas outras coisas também e, se tudo o que ele fez fosse registrado, eu acho que não haveria espaço no mundo todo para guardar os livros que seriam escritos. ");
INSERT INTO porblt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Prezado Teófilo, em meu livro anterior eu escrevi a respeito de tudo o que Jesus fez e ensinou, desde o início ");
INSERT INTO porblt_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","até o dia em que ele foi levado para o céu. Isso foi após ele ter dado orientações, por meio do Espírito Santo, para os apóstolos que ele havia escolhido. ");
INSERT INTO porblt_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Por quarenta dias, depois da sua morte, ele apareceu a eles, provando que estava vivo com sinais convincentes. Ele apareceu e lhes falou a respeito do Reino de Deus. ");
INSERT INTO porblt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Enquanto Jesus ainda estava com eles, deu a seguinte instrução: “Não saiam de Jerusalém. Esperem para que recebam o que o Pai prometeu, exatamente como eu lhes falei. ");
INSERT INTO porblt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","É verdade que João batizou com água, mas em apenas alguns dias, vocês serão batizados com o Espírito Santo.” ");
INSERT INTO porblt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Então, quando os discípulos encontraram Jesus, eles lhe perguntaram: “Senhor, já chegou o momento em que o senhor irá restabelecer o Reino de Israel?” ");
INSERT INTO porblt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesus lhes respondeu: “Vocês não precisam saber a respeito de tempos e épocas que são determinados pela autoridade do Pai. ");
INSERT INTO porblt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mas, receberão poder quando o Espírito Santo descer sobre vocês. E vocês serão minhas testemunhas em Jerusalém, em toda a Judeia e Samaria e até nos cantos mais distantes da terra.” ");
INSERT INTO porblt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Depois que Jesus lhes disse isso, ele foi levado para o céu, enquanto eles olhavam, e uma nuvem o encobriu da vista deles. ");
INSERT INTO porblt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ao mesmo tempo em que eles olhavam atentamente para o céu, vendo Jesus subir, dois homens vestidos de branco apareceram, de repente, ao lado deles. ");
INSERT INTO porblt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Eles perguntaram: “Homens da Galileia, por que vocês estão aqui, olhando para o céu? Esse mesmo Jesus, que estava com vocês e foi levado para o céu, voltará da mesma maneira que vocês o viram subir.” ");
INSERT INTO porblt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Então, os discípulos foram embora do monte das Oliveiras e voltaram para Jerusalém. O monte fica a uma distância de mais ou menos a caminhada de um sábado daquela cidade. ");
INSERT INTO porblt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Quando eles chegaram em casa, subiram para o andar superior, onde estavam hospedados. E lá se encontravam: Pedro, João, Tiago, André, Filipe, Tomé, Bartolomeu, Mateus, Tiago, filho de Alfeu, Simão, o revolucionário, e Judas, filho de Tiago. ");
INSERT INTO porblt_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Todos eles se uniram para orar, juntamente com as mulheres e com a mãe de Jesus, Maria, além dos irmãos dele. ");
INSERT INTO porblt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Em um daqueles dias, Pedro se levantou e se voltou para os cerca de cento e vinte seguidores de Jesus, que também estavam reunidos lá. ");
INSERT INTO porblt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ele disse: “Meus irmãos e minhas irmãs, era preciso que se cumprisse o que está escrito nas Sagradas Escrituras, dito por Davi, pelo Espírito Santo, sobre Judas, que guiou aqueles que prenderam Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ele era considerado um de nós e teve parte neste ministério.” ");
INSERT INTO porblt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judas comprou um terreno com o dinheiro que recebeu pelo seu pecado. Nesse terreno ele caiu e se arrebentou e os seus intestinos se espalharam pela terra. ");
INSERT INTO porblt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Todos que moravam em Jerusalém ouviram a respeito disso, e o lugar em que a morte de Judas aconteceu passou a se chamar “Aceldama”, que significa “Campo de sangue.”) ");
INSERT INTO porblt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Como está escrito no livro dos Salmos: “Deixe que a casa dele fique abandonada e que ninguém mais more lá.” E também: “Deixe que outra pessoa ocupe o seu lugar.” ");
INSERT INTO porblt_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Portanto, precisamos escolher alguém que conviveu conosco durante todo o tempo que Jesus esteve entre nós. ");
INSERT INTO porblt_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Alguém que tenha acompanhado desde quando João Batista estava batizando até o dia em que Jesus foi levado para o céu. Devemos escolher um homem para se juntar a nós como testemunha da ressurreição de Jesus.” ");
INSERT INTO porblt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Então, foram apresentados dois nomes: José, apelidado de Justo, também conhecido como Barsabás, e Matias. ");
INSERT INTO porblt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Eles oraram juntos e disseram: “Senhor, você que conhece os pensamentos de todos, por favor, mostre-nos qual desses dois homens você escolheu ");
INSERT INTO porblt_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","para substituir Judas como um apóstolo neste trabalho que ele abandonou, para ir ao lugar que merecia.” ");
INSERT INTO porblt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Eles, então, fizeram um sorteio, e Matias foi o escolhido. Ele foi considerado um apóstolo juntamente com os outros onze. ");
INSERT INTO porblt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Quando chegou o dia de Pentecostes, todos os seguidores de Jesus estavam reunidos em um só lugar. ");
INSERT INTO porblt_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","De repente, veio um som do céu, semelhante a um vento soprando muito forte, que tomou conta de toda a casa em que eles estavam. ");
INSERT INTO porblt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Eles viram chamas parecidas com línguas de fogo, que se separaram e tocaram em cada um deles. ");
INSERT INTO porblt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Todos eles ficaram cheios do Espírito Santo e começaram a falar em diferentes línguas, pois o Espírito lhes deu essa habilidade. ");
INSERT INTO porblt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nessa ocasião, havia judeus devotos, vindos de todas as partes do mundo, morando em Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Quando eles ouviram esse som, uma grande multidão deles se reuniu. Eles ficaram confusos, porque todos ouviam sua própria língua sendo falada. ");
INSERT INTO porblt_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Eles ficaram totalmente maravilhados e disseram: “Essas pessoas que estão falando não são todas da Galileia? ");
INSERT INTO porblt_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Então, como é possível que estejamos todos conseguindo ouvi-los falar, cada um em nossa própria língua materna? ");
INSERT INTO porblt_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Somos da Pártia, da Média, do Elão, da Mesopotâmia, da Judeia, da Capadócia, do Ponto, da província da Ásia, ");
INSERT INTO porblt_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","da Frígia, da Panfília, do Egito e da área da Líbia, próxima de Cirene. Alguns de nós são visitantes, vindos de Roma, tanto judeus quanto convertidos ao judaísmo. ");
INSERT INTO porblt_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Outros de nós são de Creta e da Arábia. Todos nós os ouvimos falando em nossas próprias línguas sobre todas as coisas maravilhosas que Deus tem feito.” ");
INSERT INTO porblt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Eles todos ficaram impressionados e confusos. Eles se perguntavam: “O que isso significa?” ");
INSERT INTO porblt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mas, outros zombavam e diziam: “Eles devem ter bebido muito vinho!” ");
INSERT INTO porblt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Então, Pedro se levantou com os outros onze discípulos e falou em voz alta: “Meus amigos judeus e todos que moram aqui em Jerusalém, prestem atenção em mim, pois eu lhes explicarei o que está acontecendo! ");
INSERT INTO porblt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Esses homens não estão bêbados, como vocês estão pensando. São apenas nove horas da manhã! ");
INSERT INTO porblt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","O que está acontecendo aqui é justamente o que o profeta Joel previu: ");
INSERT INTO porblt_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Deus disse: ‘Nos últimos dias, eu irei derramar o meu Espírito sobre todas as pessoas. Os seus filhos e as suas filhas irão fazer profecias. Os seus jovens terão visões. E os velhos irão sonhar. ");
INSERT INTO porblt_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Eu irei derramar o meu Espírito sobre os meus servos e as minhas servas, e eles farão profecias. ");
INSERT INTO porblt_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Eu também lhes mostrarei sinais milagrosos vindos tanto do alto dos céus, quanto de baixo, da terra, em forma de sangue, fogo e nuvens de fumaça. ");
INSERT INTO porblt_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","O sol ficará negro e a lua ficará vermelha como sangue, antes do grande e glorioso dia do Senhor. ");
INSERT INTO porblt_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mas, quem pedir a ajuda do Senhor será salvo.’ ");
INSERT INTO porblt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Povo de Israel, escute isto: Jesus de Nazaré foi um homem aprovado por Deus diante de vocês e, como vocês bem sabem, Deus demonstrou isso por meio dos milagres e sinais poderosos que Ele realizou por intermédio de Jesus, exatamente aqui no meio de vocês. ");
INSERT INTO porblt_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Deus, sabendo antecipadamente de tudo o que aconteceria, seguiu o seu plano e resolveu entregar Jesus a vocês. Pelas mãos de homens maus, vocês mataram Jesus, pregando-o em uma cruz. ");
INSERT INTO porblt_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mas, Deus o trouxe novamente à vida, libertando seu Filho do poder da morte, pois não era possível que a morte o mantivesse preso. ");
INSERT INTO porblt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Davi disse a respeito dele: ‘Eu sempre via o Senhor diante de mim. A minha fé não será abalada, pois ele está a minha direita. ");
INSERT INTO porblt_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","É por isso que eu me sinto tão feliz! E é por isso que as minhas palavras demonstram tanta alegria! Por isso o meu corpo está repleto de esperança! ");
INSERT INTO porblt_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Pois eu não serei abandonado pelo senhor na hora de minha morte, nem ele permitirá que o seu Santo apodreça. ");
INSERT INTO porblt_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","O Senhor me mostrou os caminhos da vida. E, na sua presença, me encherá de alegria.’ ");
INSERT INTO porblt_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Meus irmãos e minhas irmãs, falarei com clareza a vocês a respeito do patriarca Davi, que morreu e foi sepultado, e seu túmulo ainda se encontra aqui conosco até hoje. ");
INSERT INTO porblt_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ele era um profeta, e sabia que Deus tinha lhe prometido, sob juramento, colocar um dos seus descendentes em seu trono. ");
INSERT INTO porblt_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davi viu o que aconteceria e falou sobre a ressurreição do Cristo, pois Ele não foi abandonado na morte, nem o seu corpo apodreceu. ");
INSERT INTO porblt_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Deus ressuscitou esse Jesus, e todos nós somos testemunhas disso. ");
INSERT INTO porblt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Agora, ele está sentado ao lado direito de Deus e recebeu o Espírito Santo do Pai, como lhe foi prometido. E Jesus derramou o que vocês estão vendo e ouvindo. ");
INSERT INTO porblt_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pois, Davi não subiu aos céus, mas disse: o Senhor Deus disse ao meu Senhor: ‘Sente-se aqui a minha direita, ");
INSERT INTO porblt_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","até que eu tenha feito dos seus inimigos um estrado para os seus pés.’ ");
INSERT INTO porblt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Agora, que todos em Israel estejam completamente convencidos disso: Deus fez com que esse Jesus, que foi morto por vocês em uma cruz, se tornasse tanto Senhor quanto Messias!” ");
INSERT INTO porblt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Quando as pessoas ouviram isso, ficaram com a consciência pesada. Elas perguntaram a Pedro e aos outros apóstolos: “Irmãos, o que nós devemos fazer?” ");
INSERT INTO porblt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","“Arrependam-se!”, Pedro respondeu. “Todos vocês devem ser batizados em nome de Jesus Cristo, para o perdão dos seus pecados, e receberão o dom do Espírito Santo. ");
INSERT INTO porblt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Essa promessa é para vocês, para os seus filhos e para todos os que estão longe, ou seja, para todos que o Senhor nosso Deus chamar.” ");
INSERT INTO porblt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro continuou a falar, dando o seu testemunho com muitas outras palavras. Ele os alertou: “Salvem-se dessa gente má!” ");
INSERT INTO porblt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Aqueles que aceitaram o que Pedro dizia foram batizados e, assim, naquele dia, somaram-se quase três mil pessoas ao grupo dos seguidores de Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eles se dedicavam ao que os apóstolos ensinaram, à comunhão entre os irmãos na fé, a “dividir o pão” e às orações. ");
INSERT INTO porblt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Todos estavam muito admirados, e os apóstolos fizeram muitos milagres e maravilhas. ");
INSERT INTO porblt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Todos os que criam estavam juntos e compartilhavam tudo o que tinham. ");
INSERT INTO porblt_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Eles vendiam suas propriedades e os seus bens e dividiam o dinheiro com todos, de acordo com a necessidade de cada um. ");
INSERT INTO porblt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Todos os dias, eles continuaram a se reunir no Templo e a dividir o alimento em suas casas. Eles participavam das refeições com humildade e alegria. Eles louvavam a Deus, e todos tinham simpatia por eles. ");
INSERT INTO porblt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Todos os dias, o Senhor acrescentava ao grupo aqueles que iam sendo salvos. ");
INSERT INTO porblt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pedro e João estavam indo ao Templo na hora da oração da tarde, por volta das três horas da tarde. ");
INSERT INTO porblt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Estava ali um homem, que era manco desde que nascera. Ele era levado para lá todos os dias e colocado à porta do Templo chamada Formosa, para pedir esmolas às pessoas que iam até lá. ");
INSERT INTO porblt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ele viu Pedro e João quando eles estavam quase entrando no Templo e lhes pediu uma esmola. ");
INSERT INTO porblt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro olhou direto para ele. João fez o mesmo. Pedro disse ao homem: “Olhe para nós!” ");
INSERT INTO porblt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","O homem olhou para eles muito atentamente, esperando que lhe dessem algo. ");
INSERT INTO porblt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedro falou: “Eu não tenho prata nem ouro, mas eu lhe darei o que tenho. Em nome de Jesus Cristo de Nazaré, ande!” ");
INSERT INTO porblt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pedro o pegou pela mão direita e o ajudou a se levantar. No mesmo instante, os seus pés e os seus tornozelos ficaram fortes novamente. ");
INSERT INTO porblt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ele deu um pulo, ficou em pé e começou a andar. Ele entrou no Templo com Pedro e João, caminhando, pulando e louvando a Deus. ");
INSERT INTO porblt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Todos que estavam lá viram-no andando e louvando a Deus. ");
INSERT INTO porblt_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Eles reconheceram que ele era o mendigo que costumava ficar assentado à Porta Formosa do Templo; e ficaram muito surpresos e maravilhados com o que lhe tinha acontecido. ");
INSERT INTO porblt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ele se agarrou firmemente a Pedro e a João, enquanto todas as pessoas correram até eles, no Alpendre de Salomão. Elas estavam completamente admiradas com o que havia acontecido. ");
INSERT INTO porblt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Quando Pedro viu isso, falou a todos os que lá estavam: “Povo de Israel, por que vocês estão surpresos com o que aconteceu com esse homem? Por que vocês estão olhando para nós, como se tivesse sido pelo nosso próprio poder ou fé que esse homem tenha conseguido andar? ");
INSERT INTO porblt_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","O Deus dos nossos antepassados, o Deus de Abraão, de Isaque e de Jacó foi quem glorificou seu servo Jesus. Foi ele que vocês entregaram e rejeitaram na presença de Pilatos, mesmo após Pilatos ter decidido soltá-lo. ");
INSERT INTO porblt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Vocês rejeitaram alguém santo e bom e pediram para que um assassino fosse solto. ");
INSERT INTO porblt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Vocês mataram o Autor da vida, mas Deus o ressuscitou dos mortos, e nós somos testemunhas disso. ");
INSERT INTO porblt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Esse homem foi curado por sua fé no nome de Jesus. Vocês estão vendo esse homem e o conhecem. Por meio da fé em Jesus, esse homem foi completamente curado diante de todos vocês. ");
INSERT INTO porblt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Agora eu sei, irmãos e irmãs, que vocês e seus líderes fizeram isso por ignorância. ");
INSERT INTO porblt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mas, Deus cumpriu o que havia anunciado por todos os profetas: que o seu Messias iria sofrer. ");
INSERT INTO porblt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Agora, tratem de se arrepender e mudem os seus caminhos, para que os seus pecados sejam perdoados. Assim, o Senhor poderá conceder a vocês a oportunidade para que se curem e se recuperem ");
INSERT INTO porblt_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","e também poderá enviar Jesus, que Ele havia escolhido para ser o Messias de vocês. ");
INSERT INTO porblt_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pois Jesus precisa ficar no céu até que chegue o tempo em que tudo seja renovado, exatamente como Deus anunciou há muito tempo, pelos seus santos profetas. ");
INSERT INTO porblt_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés disse: ‘O Senhor Deus enviará, assim como me enviou, um profeta para vocês, que será escolhido entre o seu próprio povo. Ouçam tudo o que ele lhes disser. ");
INSERT INTO porblt_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Qualquer um que não o ouvir será totalmente afastado do seu povo.’ ");
INSERT INTO porblt_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Todos os profetas, desde Samuel até os que vieram depois dele, falaram a respeito destes dias. ");
INSERT INTO porblt_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Vocês são os filhos dos profetas e do acordo que Deus fez com os seus antepassados, quando ele disse para Abraão: ‘Por meio dos seus descendentes, todas as famílias da terra serão abençoadas.’ ");
INSERT INTO porblt_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Deus preparou o seu Servo e o enviou primeiro a vocês, para abençoá-los, afastando cada um de vocês do caminho do mal.” ");
INSERT INTO porblt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Enquanto Pedro e João falavam para as pessoas, chegaram os sacerdotes, o capitão da guarda do Templo e os saduceus. ");
INSERT INTO porblt_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Eles estavam furiosos pelos apóstolos estarem ensinando ao povo que, por meio da fé em Jesus, há a ressurreição dos mortos. ");
INSERT INTO porblt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Eles prenderam os dois e os colocaram sob vigilância até o dia seguinte, pois já era tarde. ");
INSERT INTO porblt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mas, muitas pessoas que tinham ouvido a mensagem acreditaram nela e, assim, o total de seguidores de Jesus aumentou em quase cinco mil pessoas. ");
INSERT INTO porblt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","No dia seguinte, os governantes, os anciãos do povo e os líderes religiosos se reuniram em Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Entre eles estavam Anás, o grande sacerdote, Caifás, João, Alexandre e outros membros da família do grande sacerdote. ");
INSERT INTO porblt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mandaram que Pedro e João fossem trazidos diante deles e começaram a perguntar aos dois: “Com que poder ou em nome de quem vocês fizeram isso?” ");
INSERT INTO porblt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedro, cheio do Espírito Santo, respondeu-lhes: “Governantes e anciãos do povo, ");
INSERT INTO porblt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nós estamos sendo interrogados em relação a uma boa ação feita a um homem que não podia se ajudar e sobre como ele veio a ser curado? ");
INSERT INTO porblt_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Se a razão é essa, todos vocês deveriam saber, e todo o povo de Israel também, que isso foi feito em nome de Jesus Cristo de Nazaré, aquele a quem vocês crucificaram e que Deus ressuscitou. É por causa de Jesus que esse homem está em pé diante de vocês, completamente curado. ");
INSERT INTO porblt_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","‘Jesus é a pedra que vocês, construtores, rejeitaram, mas que se tornou a base da construção.’ ");
INSERT INTO porblt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Não há salvação em ninguém mais; não há outro nome, abaixo do céu, que tenha sido dado a humanidade com o poder de nos salvar.” ");
INSERT INTO porblt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Eles ficaram muito surpresos ao perceberem a segurança de Pedro e João, pois eles eram homens simples e sem instrução. Eles também reconheceram que os dois eram companheiros de Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Eles não tinham nada a dizer contra os dois, pois o homem que tinha sido curado estava lá, em pé, junto deles. ");
INSERT INTO porblt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Então, os líderes disseram aos dois que esperassem do lado de fora do conselho, enquanto discutiam o assunto entre eles. ");
INSERT INTO porblt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Eles perguntaram: “O que devemos fazer com esses homens?” “Não podemos negar que eles fizeram um milagre significativo. Todos os que moram aqui em Jerusalém já sabem o que aconteceu. ");
INSERT INTO porblt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mas, para evitar que isso se espalhe ainda mais entre as pessoas, devemos ameaçá-los, para que nunca mais toquem nesse nome de novo para quem quer que seja.” ");
INSERT INTO porblt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Então, eles os chamaram e lhes ordenaram para nunca mais falarem ou ensinarem em nome de Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mas, Pedro e João responderam: “Os senhores decidem o que é justo aos olhos de Deus: obedecer a vocês ou a Deus? ");
INSERT INTO porblt_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pois não podemos deixar de falar a respeito de tudo o que vimos e ouvimos.” ");
INSERT INTO porblt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Após fazerem mais ameaças a eles, os membros do conselho os deixaram ir embora. Eles não puderam castigá-los, porque as pessoas estavam louvando a Deus pelo que havia acontecido. ");
INSERT INTO porblt_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","O homem que havia recebido esse milagre de cura tinha mais de quarenta anos. ");
INSERT INTO porblt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Depois que os discípulos foram soltos, eles voltaram para junto do seu grupo e lhes contaram tudo o que os chefes dos sacerdotes e os anciãos do povo tinham falado. ");
INSERT INTO porblt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ao ouvirem o que havia acontecido, eles se juntaram para orar: “Senhor, que fez o céu, a terra, o mar e tudo que há neles. ");
INSERT INTO porblt_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","O Senhor falou pelo Espírito Santo, por intermédio de Davi, nosso antepassado e seu servo, dizendo: ‘Por que as pessoas de outras nações ficaram tão furiosas? Por que elas fizeram planos tão tolos contra mim? ");
INSERT INTO porblt_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Os reis da terra se prepararam para a guerra, e os governantes se uniram contra o Senhor e contra o seu Escolhido.’ ");
INSERT INTO porblt_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Isso realmente aconteceu exatamente aqui nesta cidade! Tanto Herodes quanto Pôncio Pilatos se uniram aos pagãos e ao povo de Israel contra o seu santo servo, Jesus, que o Senhor escolheu para ser o Messias. ");
INSERT INTO porblt_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Eles fizeram tudo o que o Senhor, pelo seu poder e pela sua vontade, já tinha decidido que iria acontecer. ");
INSERT INTO porblt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Agora, Senhor, veja como eles nos ameaçam! Dá-nos coragem para anunciarmos, sem temor, a sua mensagem. ");
INSERT INTO porblt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Estende a mão para efetuar curas. Que sinais e milagres possam ser realizados por meio do nome do seu santo servo, Jesus!” ");
INSERT INTO porblt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Quando eles terminaram de orar, o lugar onde estavam reunidos tremeu. Todos eles ficaram cheios do Espírito Santo e corajosamente anunciaram a palavra de Deus. ");
INSERT INTO porblt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Todos os que creram pensavam e sentiam da mesma forma. Nenhum deles considerava que as coisas que possuía eram apenas suas. Pelo contrário, todos compartilhavam uns com os outros tudo o que tinham. ");
INSERT INTO porblt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Os apóstolos continuavam a testemunhar sobre a ressurreição do Senhor Jesus com grande poder, e Deus derramava muitas bênçãos sobre todos eles. ");
INSERT INTO porblt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Não havia entre eles nenhum necessitado, pois os que possuíam terras ou propriedades as vendiam, ");
INSERT INTO porblt_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","e o dinheiro dessas vendas era oferecido aos apóstolos, para que fosse dividido com todos os que precisavam. ");
INSERT INTO porblt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","José, a quem os apóstolos chamavam de Barnabé (que significa “filho do encorajamento”), era um levita nascido na ilha de Chipre. ");
INSERT INTO porblt_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ele vendeu as terras que lhe pertenciam, trouxe o dinheiro e o deu aos apóstolos. ");
INSERT INTO porblt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mas, um homem chamado Ananias e a sua esposa Safira venderam um terreno. ");
INSERT INTO porblt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ele guardou uma parte do dinheiro da venda para si e deu o restante aos apóstolos. Safira sabia o que o marido estava fazendo. ");
INSERT INTO porblt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Então, Pedro lhe perguntou: “Ananias, por que você deixou Satanás convencê-lo a mentir para o Espírito Santo e guardar para si uma parte do dinheiro do terreno que vendeu? ");
INSERT INTO porblt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Enquanto você tinha o terreno, ele não lhe pertencia? E, depois que o vendeu, você não continuava a ter controle sobre o dinheiro? Por que você decidiu fazer isso? Você não mentiu aos homens, mas, sim, a Deus!” ");
INSERT INTO porblt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ao ouvir o que Pedro dissera, Ananias caiu no chão e morreu. Todos os que ouviram o que aconteceu ficaram muito assustados. ");
INSERT INTO porblt_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Alguns jovens se levantaram e enrolaram o corpo de Ananias em um lençol. Depois, eles levaram o corpo para fora e o sepultaram. ");
INSERT INTO porblt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Cerca de três horas depois, a esposa de Ananias chegou, sem saber o que havia acontecido. ");
INSERT INTO porblt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro lhe perguntou: “Diga-me, foi por esse valor que vocês venderam aquele terreno?” Ela respondeu: “Sim, foi por esse valor!” ");
INSERT INTO porblt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Então, Pedro lhe disse: “Como você e o seu marido puderam concordar em enganar o Espírito do Senhor? Veja! Aqueles que sepultaram seu marido já estão voltando, e eles a levarão também!” ");
INSERT INTO porblt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","E ela, imediatamente, caiu aos pés de Pedro e morreu. Os jovens voltaram e a encontraram morta. Então, levaram o corpo dela para fora e a sepultaram ao lado do marido. ");
INSERT INTO porblt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Todos que estavam na igreja ficaram com muito medo, da mesma maneira que todos os que ouviram sobre o que havia acontecido. ");
INSERT INTO porblt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Muitas pessoas foram abençoadas pelos sinais milagrosos que os apóstolos realizavam. Todos os que creram costumavam se reunir no Alpendre de Salomão. ");
INSERT INTO porblt_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ninguém de fora do grupo ousava se juntar a eles, muito embora as pessoas tivessem muito respeito por eles. ");
INSERT INTO porblt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","No entanto, muitos homens e muitas mulheres começaram a acreditar no Senhor. ");
INSERT INTO porblt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","E, por isso, as pessoas traziam os doentes para as ruas e os deitavam em camas e esteiras para que, quando Pedro passasse, ao menos a sua sombra pudesse se projetar em alguns deles. ");
INSERT INTO porblt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Multidões vinham das cidades ao redor de Jerusalém, trazendo seus doentes e as pessoas possuídas por maus espíritos. Todos eles eram curados. ");
INSERT INTO porblt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Contudo, o grande sacerdote e os que o seguiam (que eram saduceus) ficaram com muita inveja e decidiram tomar medidas contra os apóstolos. ");
INSERT INTO porblt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Eles prenderam os apóstolos e os colocaram na cadeia. ");
INSERT INTO porblt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mas, durante a noite, um anjo do Senhor abriu as portas da prisão, libertou-os e lhes disse: ");
INSERT INTO porblt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Vão para o Templo e anunciem às pessoas tudo a respeito desta nova forma de viver!” ");
INSERT INTO porblt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Os apóstolos fizeram o que o anjo ordenou e, ainda de madrugada, foram ao Templo e começaram a ensinar. Então, o grande sacerdote e os seus seguidores reuniram o conselho, juntamente com todos os líderes de Israel. Ele mandou que os apóstolos fossem trazidos da cadeia para se apresentarem ao conselho. ");
INSERT INTO porblt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mas, quando os guardas chegaram na cadeia e não encontraram os apóstolos, eles voltaram e disseram ao conselho: ");
INSERT INTO porblt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nós encontramos a cadeia completamente fechada e com guardas na porta. Porém, quando mandamos que eles abrissem a cadeia, não havia ninguém lá dentro.” ");
INSERT INTO porblt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","No momento em que o capitão dos guardas do Templo e os chefes dos sacerdotes ouviram a notícia, eles ficaram totalmente perplexos e se perguntaram o que teria acontecido. ");
INSERT INTO porblt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Então, alguém se aproximou e disse: “Escutem! Os homens que vocês colocaram na cadeia estão lá no Templo ensinando às pessoas!” ");
INSERT INTO porblt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","O capitão saiu apressadamente com os seus guardas e trouxeram os apóstolos. Mas não usaram a força, porque eles estavam com medo de que as pessoas os apedrejassem. ");
INSERT INTO porblt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Os apóstolos foram colocados diante do conselho. O grande sacerdote os interrogou, ");
INSERT INTO porblt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","dizendo: “Nós não lhes ordenamos que não ensinassem sobre esse homem? Agora, vejam só! Vocês espalharam seu ensinamento por toda a Jerusalém e estão tentando nos culpar pela morte dele!” ");
INSERT INTO porblt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mas, Pedro e os apóstolos responderam: “Nós devemos obedecer a Deus e, não, aos homens. ");
INSERT INTO porblt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","O Deus dos nossos antepassados ressuscitou Jesus, aquele que vocês mataram, pendurando-o numa cruz. ");
INSERT INTO porblt_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Deus o colocou em uma posição de honra, ao seu lado direito, como Príncipe e Salvador, para que o povo de Israel se arrependa e para que os seus pecados sejam perdoados. ");
INSERT INTO porblt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nós somos testemunhas do que aconteceu, nós e o Espírito Santo, que Deus dá aos que lhe obedecem.” ");
INSERT INTO porblt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ao ouvirem isso, eles ficaram furiosos e queriam matar todos os apóstolos. ");
INSERT INTO porblt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mas, então, um dos membros do conselho se levantou para falar. O nome dele era Gamaliel, um fariseu e mestre da lei muito respeitado por todos. Ele ordenou que os apóstolos saíssem por um momento. ");
INSERT INTO porblt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Gamaliel se dirigiu aos outros membros do conselho: “Líderes de Israel, tenham cuidado com o que planejam fazer com esses homens. ");
INSERT INTO porblt_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Algum tempo atrás, apareceu um homem, chamado Teudas, que tentou trazer muito reconhecimento para si mesmo. Ele conseguiu reunir cerca de quatrocentos seguidores a sua volta. Ele foi morto e todos os seus seguidores foram espalhados. Os esforços de Teudas não deram em nada. ");
INSERT INTO porblt_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Então, depois dele, apareceu Judas, da Galileia, durante a época do recenseamento, e ele atraiu muitos seguidores para si. Ele também morreu e, da mesma forma que os seguidores de Teudas, os de Judas se espalharam. ");
INSERT INTO porblt_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Então, neste caso atual, eu recomendo que vocês deixem esses homens em paz, que os deixem ir embora. Porque se o que eles estiverem planejando ou fazendo vier dos homens, eles serão simplesmente derrotados. ");
INSERT INTO porblt_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mas se, pelo contrário, tudo isso vier de Deus, vocês não serão capazes de vencê-los. Vocês podem até mesmo se encontrar batalhando contra Deus.” ");
INSERT INTO porblt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Eles se convenceram com as palavras de Gamaliel. Então, o conselho chamou os apóstolos e mandou que eles fossem chicoteados, ordenando-lhes que não falassem mais nada a respeito de Jesus. Depois disso, o conselho os soltou. ");
INSERT INTO porblt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Os apóstolos saíram de lá felizes por terem sido considerados dignos de serem insultados por causa de sua fé em Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Diariamente, eles continuaram a ensinar e a anunciar Jesus como o Messias enviado por Deus, tanto no Templo quanto de casa em casa. ");
INSERT INTO porblt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Naquela época, quando o número dos seguidores de Jesus aumentava rapidamente, começou a surgir uma queixa dos seguidores que falavam grego contra outros que falavam aramaico. Eles reclamavam que as viúvas deles estavam sendo discriminadas em relação à distribuição diária de alimentos. ");
INSERT INTO porblt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Os doze apóstolos reuniram todos os seguidores e lhes disseram: “Não é certo deixarmos de anunciar a palavra de Deus para servirmos às mesas. ");
INSERT INTO porblt_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Irmãos, escolham entre vocês sete homens de confiança, que sejam cheios do Espírito Santo e de sabedoria. Nós daremos essa responsabilidade a eles. ");
INSERT INTO porblt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Enquanto isso, dedicaremos toda a nossa energia às orações e ao trabalho de anunciar a palavra de Deus.” ");
INSERT INTO porblt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Todos ficaram felizes com a solução e escolheram Estêvão (um homem cheio de fé e do Espírito Santo), Filipe, Prócoro, Nicanor, Timom, Pármenas e Nicolau (originalmente um não-judeu convertido ao judaísmo, vindo de Antioquia). ");
INSERT INTO porblt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Esses homens foram apresentados aos apóstolos, que oraram por eles e colocaram as suas mãos sobre eles para abençoá-los. ");
INSERT INTO porblt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","A palavra de Deus continuou a ser anunciada. O número de discípulos em Jerusalém crescia imensamente, e muitos sacerdotes aceitavam a fé cristã. ");
INSERT INTO porblt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estêvão, cheio da graça e do poder de Deus, realizou milagres extraordinários entre o povo. ");
INSERT INTO porblt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mas, algumas pessoas começaram a discutir com ele. Elas eram da sinagoga conhecida como “Sinagoga dos Homens Livres”, assim como pessoas vindas das cidades de Cirene, de Alexandria, da Cilícia e da Ásia Menor. ");
INSERT INTO porblt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mas, essas pessoas não eram capazes de resistir à sabedoria de Estêvão ou ao Espírito com o qual ele falava. ");
INSERT INTO porblt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Então, elas subornaram para que alguns homens dissessem: “Nós ouvimos este homem dizer blasfêmias contra Moisés e também contra Deus!” ");
INSERT INTO porblt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Eles agitaram o povo e, junto com os anciãos do povo e os mestres da lei, vieram e prenderam Estêvão. Eles o levaram diante do conselho ");
INSERT INTO porblt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","e chamaram as falsas testemunhas, que falaram contra ele. Elas disseram: “Esse homem está sempre dizendo injúrias contra o santo Templo e contra a Lei de Moisés. ");
INSERT INTO porblt_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nós o ouvimos dizer que o tal Jesus de Nazaré vai destruir o Templo e mudar as leis que recebemos de Moisés.” ");
INSERT INTO porblt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Todos os que estavam sentados no conselho olharam atentamente para Estêvão, e viram que o rosto dele parecia como o rosto de um anjo. ");
INSERT INTO porblt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Então, o grande sacerdote perguntou a Estêvão: “Essas pessoas estão dizendo a verdade?” ");
INSERT INTO porblt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Estêvão respondeu: “Irmãos e pais, escutem o que eu digo: O glorioso Deus apareceu para o nosso antepassado Abraão, quando ele vivia na Mesopotâmia, antes de se mudar para Harã. ");
INSERT INTO porblt_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Deus lhe disse: ‘Abandone o seu país e deixe a sua família. Vá para o país que eu lhe mostrarei.’ ");
INSERT INTO porblt_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Então, Abraão saiu da Caldeia e foi morar em Harã. Após a morte do pai dele, Deus o trouxe para esta terra, em que vocês vivem agora. ");
INSERT INTO porblt_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Deus não deu para Abraão herança alguma aqui, nem mesmo um metro quadrado de terra. Mas, Deus prometeu a Abraão que ele e os seus descendentes teriam a posse desta terra, mesmo que ele ainda não tivesse filhos. ");
INSERT INTO porblt_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Deus também lhe disse que os seus descendentes viveriam em um país estrangeiro e que lá eles seriam escravizados e maltratados por quatrocentos anos. ");
INSERT INTO porblt_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Deus disse: ‘Eu irei punir a nação que os escravizar. E, finalmente, eles sairão daquele país e virão para cá para me adorar.’ ");
INSERT INTO porblt_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Deus também deu para Abraão o acordo em relação à circuncisão. Por isso, quando Isaque nasceu, Abraão fez a circuncisão em seu filho no oitavo dia após o seu nascimento. Isaque gerou Jacó, e Jacó gerou os doze patriarcas. ");
INSERT INTO porblt_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Os patriarcas, que tinham inveja de José, o venderam para ser escravo no Egito. Mas, Deus estava com ele ");
INSERT INTO porblt_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","e o livrou de todas as suas aflições. Ele lhe deu sabedoria e o ajudou para que o faraó, o rei do Egito, lhe fosse favorável. E, assim, aconteceu, pois José se tornou governador do Egito e do palácio real. ");
INSERT INTO porblt_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Naquele momento, houve falta de alimento em todo o Egito e em Canaã. Isso trouxe grande sofrimento, e os nossos antepassados não tinham o que comer. ");
INSERT INTO porblt_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Quando Jacó ouviu que havia trigo no Egito, ele enviou, pela primeira vez, os nossos antepassados para lá. ");
INSERT INTO porblt_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Durante a segunda visita deles, José revelou aos seus irmãos quem ele era, e o faraó conheceu a família de José. ");
INSERT INTO porblt_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","José mandou buscar seu pai e todos os seus parentes, que totalizavam setenta e cinco pessoas. ");
INSERT INTO porblt_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jacó viajou ao Egito, onde ele e os nossos antepassados ficaram morando até o dia de suas mortes. ");
INSERT INTO porblt_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Os seus corpos foram trazidos para Siquém e colocados no túmulo que Abraão tinha comprado dos descendentes de Hamor, por um certo valor. ");
INSERT INTO porblt_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Quando estava se aproximando o tempo de Deus cumprir o que havia prometido a Abraão, o número do nosso povo no Egito tinha aumentado muito. ");
INSERT INTO porblt_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Então, um novo rei, que não sabia nada sobre José, começou a governar o Egito. ");
INSERT INTO porblt_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ele tirou vantagem do nosso povo e tratou nossos antepassados muito mal, forçando-os a abandonar os seus recém-nascidos, para que eles morressem. ");
INSERT INTO porblt_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Foi nessa época que Moisés nasceu. Ele era uma criança linda e durante três meses foi cuidado na casa do seu pai. ");
INSERT INTO porblt_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Quando chegou o momento dele também ser abandonado, a filha do faraó o resgatou e o criou como se fosse seu próprio filho. ");
INSERT INTO porblt_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moisés foi educado em todas as áreas do conhecimento egípcio e se tornou um líder que falava com autoridade. ");
INSERT INTO porblt_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","No entanto, quando completou quarenta anos, decidiu visitar seus parentes, os israelitas. ");
INSERT INTO porblt_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ele viu um deles ser maltratado por um egípcio. Então, ele interferiu para defender o homem ofendido e matou o egípcio. ");
INSERT INTO porblt_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés pensou que os seus irmãos israelitas o veriam como a ferramenta usada por Deus para a salvação do seu povo, mas não foi o que aconteceu. ");
INSERT INTO porblt_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","No dia seguinte, ele viu dois israelitas brigando. Ele tentou fazer com que fizessem as pazes e parassem de brigar, dizendo: ‘Homens, vocês são irmãos! Por que estão atacando um ao outro?’ ");
INSERT INTO porblt_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mas, o homem que tinha começado a briga empurrou Moisés e lhe disse: ‘Quem o colocou como nosso líder? Você é nosso juiz agora?’, ele perguntou. ");
INSERT INTO porblt_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Você quer me matar, como matou o egípcio ontem?’ ");
INSERT INTO porblt_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Quando Moisés ouviu isso, ele fugiu. Ele saiu do Egito e foi morar em Midiã, e ali nasceram seus dois filhos. ");
INSERT INTO porblt_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Quarenta anos depois, no deserto do monte Sinai, um anjo apareceu a Moisés nas chamas de um espinheiro que estava queimando. ");
INSERT INTO porblt_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Quando Moisés viu aquilo, ele ficou impressionado com a visão e se aproximou para olhar mais de perto. Ele, então, ouviu a voz do Senhor, que lhe disse: ");
INSERT INTO porblt_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Eu sou o Deus dos seus antepassados, o Deus de Abraão, o Deus de Isaque e o Deus de Jacó.’ Moisés tremia de medo e não ousava olhar. ");
INSERT INTO porblt_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","O Senhor lhe disse: ‘Tire as suas sandálias, pois o lugar em que está é um solo sagrado. ");
INSERT INTO porblt_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Eu tenho observado o sofrimento do meu povo no Egito com muita atenção e ouvi os seus gemidos. Eu desci para salvá-los. Agora, venha! Vou enviar você para o Egito.’ ");
INSERT INTO porblt_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Esse foi o mesmo Moisés a quem o povo tinha rejeitado, quando disseram: ‘Quem o colocou como nosso líder e nosso juiz?’ Deus o enviou para ser tanto um líder quanto um libertador, por meio do anjo que apareceu a ele no espinheiro. ");
INSERT INTO porblt_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés libertou os israelitas após realizar sinais milagrosos no Egito, no mar Vermelho e no deserto, durante quarenta anos. ");
INSERT INTO porblt_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Esse é o mesmo Moisés que prometeu aos israelitas: ‘Deus irá enviar um profeta, como eu, escolhido entre o seu povo.’ ");
INSERT INTO porblt_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisés estava reunido com o povo de Deus no deserto, quando o anjo falou com ele no monte Sinai. E lá, junto com os nossos antepassados, ele recebeu a palavra viva de Deus para nos dar. ");
INSERT INTO porblt_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ele foi aquele a quem os nossos antepassados não quiseram dar ouvidos. Eles rejeitaram Moisés e decidiram voltar para o Egito. ");
INSERT INTO porblt_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Os israelitas disseram a Arão: ‘Faça-nos deuses que possamos seguir, pois nós não sabemos o que aconteceu com esse Moisés, que nos tirou do Egito.’ ");
INSERT INTO porblt_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Eles, então, fizeram um ídolo com a forma de um bezerro, sacrificaram animais para ele e fizeram uma festa para comemorar a imagem que eles mesmos tinham feito. ");
INSERT INTO porblt_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Então, Deus se afastou deles. Ele os deixou para que adorassem as estrelas do céu. Foi assim que os profetas escreveram: ‘Vocês me deram ofertas ou fizeram sacrifícios para mim durante os quarenta anos no deserto, israelitas? ");
INSERT INTO porblt_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Não. Vocês carregaram a barraca do deus Moloque e a estrela do deus Renfã. Vocês fizeram esses ídolos para os adorar. Por isso, eu os enviarei para o exílio, para além da Babilônia.’ ");
INSERT INTO porblt_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","No deserto, os nossos antepassados tinham a Tenda da Presença de Deus. Deus havia dito a Moisés como ele deveria construí-la, seguindo o modelo que ele tinha visto. ");
INSERT INTO porblt_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Depois, os nossos antepassados levaram a Tenda com eles quando, liderados por Josué, foram ocupar a terra das nações que o Senhor expulsara diante deles. A Tenda permaneceu com eles até a época de Davi. ");
INSERT INTO porblt_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davi ganhou a aprovação de Deus e pediu para construir uma casa que fosse mais definitiva para o Deus de Jacó. ");
INSERT INTO porblt_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Porém, foi Salomão quem construiu um Templo para ele. ");
INSERT INTO porblt_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","É claro que o Altíssimo não vive nos templos que construímos. Como o profeta disse: ");
INSERT INTO porblt_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘O céu é o meu trono, e a terra é o local em que descanso os meus pés. Que tipo de casa vocês poderiam construir para mim?’, o Senhor pergunta. ‘Que lugar vocês poderiam construir para eu morar? ");
INSERT INTO porblt_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Não fui eu quem fez tudo isso?’ ");
INSERT INTO porblt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Vocês são pessoas arrogantes e cruéis! Vocês nunca escutam! E sempre rejeitam o Espírito Santo! Vocês agem exatamente como os seus antepassados! ");
INSERT INTO porblt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Houve algum profeta que os seus antepassados não tenham perseguido? Eles mataram aqueles que fizeram profecias a respeito da vinda daquele que é realmente bom e justo. Ele é aquele que vocês traíram e assassinaram. ");
INSERT INTO porblt_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Vocês receberam a lei por meio dos anjos, mas se recusaram a obedecer essa lei.” ");
INSERT INTO porblt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ao ouvirem isso, os membros do conselho ficaram furiosos e rangeram os dentes contra ele. ");
INSERT INTO porblt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mas, Estêvão, cheio do Espírito Santo, olhou para o céu e viu a glória de Deus. Ele também viu Jesus em pé, ao lado direito de Deus. ");
INSERT INTO porblt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Estêvão disse: “Olhem! Eu vejo o céu se abrir, e o Filho do Homem em pé, ao lado direito de Deus.” ");
INSERT INTO porblt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mas, eles taparam os ouvidos e gritaram o mais alto possível. Eles, então, avançaram todos juntos contra Estêvão, ");
INSERT INTO porblt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","arrastaram-no para fora da cidade e jogaram pedras nele. Aqueles que o acusavam, deixaram suas capas com um jovem, chamado Saulo. ");
INSERT INTO porblt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Enquanto eles o apedrejavam, Estêvão orava: “Senhor Jesus, receba o meu espírito!” ");
INSERT INTO porblt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ele se ajoelhou e gritou; “Senhor, por favor, não os condene por causa deste pecado!” Após dizer essas palavras, ele morreu. ");
INSERT INTO porblt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","E Saulo aprovou a morte de Estêvão. Naquele mesmo dia, começou a acontecer uma terrível perseguição contra a igreja em Jerusalém, e todos, exceto os apóstolos, foram espalhados pelas regiões da Judeia e de Samaria. ");
INSERT INTO porblt_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","(Alguns seguidores fiéis de Deus sepultaram Estêvão, com grande tristeza.) ");
INSERT INTO porblt_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mas Saulo se lançou à destruição da igreja, indo de casa em casa e arrastando tanto homens quanto mulheres para a prisão. ");
INSERT INTO porblt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Os seguidores, que foram espalhados, anunciavam o evangelho por onde quer que fossem. ");
INSERT INTO porblt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipe foi para a cidade de Samaria. E lá ele falou a respeito do Messias para as pessoas. ");
INSERT INTO porblt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Quando elas ouviam Filipe falar e viam os milagres que ele realizava, todas prestavam atenção às palavras dele. ");
INSERT INTO porblt_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Muitos se livraram de espíritos maus que os possuíam e que gritavam quando eram expulsos. E muitos outros, que eram mancos ou tinham outros tipos de deficiências, foram curados. ");
INSERT INTO porblt_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","E, assim, a alegria tomou conta da cidade. ");
INSERT INTO porblt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Naquela época, existia um homem que vivia na cidade, chamado Simão. Ele praticava feitiçaria. Ele afirmava ser alguém muito importante e impressionava o povo de Samaria. ");
INSERT INTO porblt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Por causa do que fazia, ele chamava a atenção de todas as pessoas que viviam na cidade. Desde os mais humildes até os mais importantes da sociedade de Samaria diziam: “Este homem é o poder de Deus! Ele é o Grande Poder!” ");
INSERT INTO porblt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Eles sentiam profunda admiração por ele, pois Simão os iludia com sua mágica há muito tempo. ");
INSERT INTO porblt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mas, quando ouviram o que Filipe lhes falou a respeito das boas novas sobre o Reino de Deus e sobre o nome de Jesus Cristo, eles creram e foram batizados, tanto homens quanto mulheres. ");
INSERT INTO porblt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","O próprio Simão creu e foi batizado. Ele acompanhou Filipe, impressionado com os sinais milagrosos e as maravilhas que ele viu. ");
INSERT INTO porblt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Quando os apóstolos voltaram a Jerusalém e ouviram que as pessoas de Samaria tinham aceitado a palavra de Deus, eles enviaram Pedro e João para visitá-los. ");
INSERT INTO porblt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ao chegarem lá, eles oraram para que as pessoas que tinham se convertido em Samaria recebessem o Espírito Santo. ");
INSERT INTO porblt_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","O Espírito Santo não havia vindo para qualquer um deles, pois eles tinham sido batizados apenas em nome do Senhor Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Então, os apóstolos colocaram suas mãos sobre eles, e todos os convertidos receberam o Espírito Santo. ");
INSERT INTO porblt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simão, ao ver que o Espírito Santo havia sido dado quando os apóstolos colocaram suas mãos sobre as pessoas, ofereceu-lhes dinheiro. ");
INSERT INTO porblt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ele, então, pediu aos apóstolos: “Também quero que me deem esse poder, para que todos sobre quem eu colocar as minhas mãos também recebam o Espírito Santo.” ");
INSERT INTO porblt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro respondeu: “Que o seu dinheiro seja destruído juntamente com você, por pensar que o dom de Deus é algo que possa ser comprado! ");
INSERT INTO porblt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Você não tem o direito de fazer parte desse ministério, pois a sua atitude diante de Deus é totalmente errada. ");
INSERT INTO porblt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Arrependa-se de sua maldade. Ore ao Senhor e peça perdão por pensar assim. ");
INSERT INTO porblt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Eu posso ver que você está tomado por uma inveja amarga e acorrentado aos seus pecados.” ");
INSERT INTO porblt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","“Por favor, orem por mim, para que nada do que vocês disseram aconteça comigo!”, respondeu Simão. ");
INSERT INTO porblt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Depois de terem dado o seu testemunho e de terem compartilhado a palavra do Senhor, Pedro e João voltaram para Jerusalém. Eles iam pelo caminho, anunciando as boas novas do Reino em muitos povoados da Samaria. ");
INSERT INTO porblt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Um anjo do Senhor disse a Filipe: “Esteja pronto e vá para o sul, pela estrada deserta que leva de Jerusalém a Gaza.” ");
INSERT INTO porblt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Então, Filipe partiu e encontrou um homem da Etiópia, um eunuco de alta posição a serviço de Candace, a rainha da Etiópia. Ele era o tesoureiro da rainha. Ele tinha ido a Jerusalém para adorar a Deus e ");
INSERT INTO porblt_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","estava voltando de sua viagem, sentado na sua carruagem. Ele estava lendo em voz alta o livro do profeta Isaías. ");
INSERT INTO porblt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","O Espírito disse a Filipe: “Aproxime-se da carruagem!” ");
INSERT INTO porblt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Então, Filipe correu e ouviu o homem lendo o livro do profeta Isaías. Filipe perguntou: “Você entende o que está lendo?” ");
INSERT INTO porblt_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","O homem respondeu: “Como poderei entender se alguém não me explicar?” Ele, então, convidou Filipe para subir na carruagem e se sentar ao seu lado. ");
INSERT INTO porblt_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A passagem das Sagradas Escrituras que ele estava lendo era esta: “Ele foi levado como uma ovelha para ser morta. Como um cordeiro mudo diante de quem vai cortar a sua lã, ele não disse uma palavra. ");
INSERT INTO porblt_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ele foi humilhado e injustiçado. Ninguém poderá falar a respeito dos seus descendentes, pois a sua vida chegou ao fim.” ");
INSERT INTO porblt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","O eunuco perguntou a Filipe: “Diga-me, sobre quem o profeta está falando? É sobre ele mesmo ou sobre outra pessoa?” ");
INSERT INTO porblt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Então, iniciando por essa passagem das Sagradas Escrituras, Filipe começou a contar para ele sobre Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Conforme eles prosseguiam, encontraram um lugar em que havia água. O eunuco disse: “Olhe! Há água aqui. Poderia me batizar?” ");
INSERT INTO porblt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ele mandou parar a carruagem. Filipe e ele desceram e entraram na água, onde Filipe o batizou. ");
INSERT INTO porblt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Quando eles saíram da água, o Espírito do Senhor levou Filipe embora. O eunuco não viu mais Filipe, mas continuou a sua viagem, cheio de alegria. Filipe, de repente, se encontrou na cidade de Azoto. ");
INSERT INTO porblt_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ele anunciou as boas novas do Reino em todas as cidades ao longo do caminho, até chegar em Cesareia. ");
INSERT INTO porblt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Enquanto isso, Saulo continuava a ameaçar de morte os discípulos do Senhor. Ele foi até o grande sacerdote ");
INSERT INTO porblt_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","e lhe pediu cartas de autorização para levar às sinagogas em Damasco. Essas cartas permitiam que ele prendesse e levasse para Jerusalém qualquer pessoa que ele encontrasse, fosse homem ou mulher, que cresse no Caminho. ");
INSERT INTO porblt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","De repente, quando Saulo se aproximava de Damasco, uma luz vinda do céu brilhou ao redor dele. ");
INSERT INTO porblt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ele caiu no chão e ouviu uma voz que disse: “Saulo, Saulo, por que você está me perseguindo?” ");
INSERT INTO porblt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Quem é você, Senhor?” Saulo perguntou. A voz respondeu: “Eu sou Jesus, aquele a quem você persegue. ");
INSERT INTO porblt_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Levante-se e vá para a cidade. Lá lhe será dito o que deve fazer.” ");
INSERT INTO porblt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Os homens que viajavam com Saulo ficaram lá parados, sem conseguir dizer uma só palavra. Eles ouviram a voz falando, mas não viram ninguém. ");
INSERT INTO porblt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo ficou em pé e, quando abriu os olhos, não enxergava absolutamente nada. Os homens que acompanhavam Saulo o pegaram pela mão e o levaram para a cidade de Damasco. ");
INSERT INTO porblt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Durante três dias ele não conseguiu enxergar e também não comeu e nem bebeu nada. ");
INSERT INTO porblt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Havia um seguidor de Jesus em Damasco, chamado Ananias. Ele teve uma visão em que o Senhor lhe dizia: “Ananias!” E Ananias respondeu: “Eu estou aqui, Senhor!” ");
INSERT INTO porblt_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","E o Senhor lhe disse: “Levante-se e vá para a rua Direita. Na casa de Judas, pergunte por um homem, chamado Saulo, da cidade de Tarso. Ele está orando. ");
INSERT INTO porblt_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ele teve uma visão em que um homem chamado Ananias vinha e colocava as suas mãos sobre ele e, então, ele conseguiu enxergar de novo.” ");
INSERT INTO porblt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias respondeu: “Mas, Senhor, eu ouvi muito a respeito desse homem. Ouvi sobre todas as coisas ruins que ele fez aos seguidores do Senhor em Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Os chefes dos sacerdotes lhe deram poder para prender aqui em Damasco a todos que adoram o Senhor.” ");
INSERT INTO porblt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mas, o Senhor disse a Ananias: “Vá, pois ele é a pessoa que eu escolhi para levar o meu nome aos não-judeus e aos reis, assim como também ao povo de Israel. ");
INSERT INTO porblt_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Eu mostrarei a ele tudo o que irá sofrer por amor ao meu nome.” ");
INSERT INTO porblt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Então, Ananias saiu e foi até a casa de Judas. Ele colocou as suas mãos sobre Saulo. Ele disse: “Irmão Saulo, quem me enviou aqui foi o Senhor Jesus, que apareceu a você na estrada para Damasco. Ele me mandou para que você volte a enxergar e fique cheio do Espírito Santo.” ");
INSERT INTO porblt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Imediatamente, algo parecido com escamas caiu dos olhos de Saulo, e ele voltou a enxergar. Ele se levantou e foi batizado. ");
INSERT INTO porblt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ele também se alimentou e ficou mais forte. Saulo passou vários dias com os discípulos em Damasco. ");
INSERT INTO porblt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ele logo começou a anunciar nas sinagogas, dizendo: “Jesus é o Filho de Deus!” ");
INSERT INTO porblt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Todos que o ouviam ficavam admirados e perguntavam: “Não é ele o homem que, em Jerusalém, causou tantos problemas aos seguidores de Jesus? Ele não veio aqui para prender os seguidores e levá-los acorrentados aos chefes dos sacerdotes?” ");
INSERT INTO porblt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulo ficava cada vez mais confiante. Ele demonstrava, com fortes provas, que Jesus é o Messias, que até os judeus que moravam em Damasco não conseguiam refutá-lo. ");
INSERT INTO porblt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Algum tempo depois, os judeus planejaram matá-lo, ");
INSERT INTO porblt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","mas Saulo sabia dos planos deles. Dia e noite, eles esperavam perto dos portões da cidade para matá-lo. ");
INSERT INTO porblt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Então, em uma noite, os seguidores de Saulo o colocaram em um cesto e o desceram pela muralha da cidade. ");
INSERT INTO porblt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Quando Saulo chegou em Jerusalém, ele tentou se encontrar com os discípulos, mas todos tinham medo dele, pois não tinham certeza se ele era realmente um discípulo. ");
INSERT INTO porblt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","No entanto, Barnabé o levou para encontrar os apóstolos e disse a eles como Saulo tinha visto o Senhor na estrada e como o Senhor tinha falado com ele. Barnabé também disse sobre a coragem de Saulo ao anunciar o evangelho em nome de Jesus, quando estava em Damasco. ");
INSERT INTO porblt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saulo ficou com os apóstolos e os acompanhou por toda a Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ele demonstrava muita coragem ao anunciar o evangelho em nome do Senhor. Ele conversava e debatia com os judeus que falavam grego, mas, mesmo assim, eles tentavam matá-lo. ");
INSERT INTO porblt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Quando os irmãos souberam disso, levaram Saulo para a cidade de Cesareia e, depois, o enviaram para Tarso. ");
INSERT INTO porblt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Durante esse período, reinou a paz para a igreja em toda a região da Judeia, Galileia e Samaria. A igreja cresceu muito, e o número de seguidores, encorajados pelo Espírito Santo, que dedicavam suas vidas para respeitar a palavra do Senhor, aumentava rapidamente. ");
INSERT INTO porblt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Durante uma de suas viagens, Pedro foi visitar os seguidores de Jesus em Lida. ");
INSERT INTO porblt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Lá, ele encontrou um homem, chamado Eneias, que, por causa de sua paralisia, já estava há oito anos sem poder sair da cama. ");
INSERT INTO porblt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro lhe disse: “Eneias, Jesus Cristo vai curá-lo! Levante-se e arrume a sua cama!” Nesse mesmo instante, Eneias se levantou. ");
INSERT INTO porblt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Todos que moravam na cidade de Lida e na região de Sarom viram o que havia acontecido com Eneias e creram no Senhor. ");
INSERT INTO porblt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Havia em Jope, uma seguidora de Jesus chamada Tabita (Dorcas, em grego). Ela sempre fazia boas ações e ajudava os pobres. ");
INSERT INTO porblt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Contudo, nessa época, ela adoeceu e morreu. Depois, o corpo de Tabita foi lavado e colocado em um quarto no andar de cima. ");
INSERT INTO porblt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida ficava perto de Jope. Então, os discípulos de Jope, ao saberem que Pedro estava em Lida, enviaram dois homens, com a seguinte mensagem para ele: “Por favor, venha até nós imediatamente!” ");
INSERT INTO porblt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro atendeu e foi com eles. Quando ele chegou, foi levado para o andar de cima da casa. Todas as viúvas estavam lá, chorando. Elas mostraram a Pedro todas as capas e roupas que Dorcas havia costurado enquanto ainda estava com elas. ");
INSERT INTO porblt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro disse para que todos saíssem e, depois, se ajoelhou e orou. Ele se virou para o corpo e disse: “Tabita, levante-se!” Ela abriu os olhos e, quando viu Pedro, ela se sentou. ");
INSERT INTO porblt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ele a pegou pela mão e a ajudou a se levantar. Ele chamou os seguidores de Jesus, inclusive as viúvas, e lhes mostrou Tabita viva. ");
INSERT INTO porblt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","A notícia se espalhou por toda Jope e isso fez com que muitos passassem a crer no Senhor. ");
INSERT INTO porblt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro passou bastante tempo na cidade de Jope e, enquanto estava lá, ficou hospedado na casa de Simão, um curtidor de couros. ");
INSERT INTO porblt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Em Cesareia vivia um homem chamado Cornélio, um comandante romano do batalhão italiano. ");
INSERT INTO porblt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ele era um homem religioso que, juntamente com todos em sua casa, tinha grande respeito por Deus. Ele ajudava muito os pobres e orava sempre a Deus. ");
INSERT INTO porblt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Um dia, cerca de três horas da tarde, ele teve uma visão em que viu muito claramente um anjo de Deus se aproximar dele e falar: “Cornélio!” ");
INSERT INTO porblt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Assustado, Cornélio ficou olhando para o anjo e perguntou: “O que quer, Senhor?” O anjo respondeu: “Deus prestou atenção nas suas orações e reconheceu a sua generosidade para com os pobres. ");
INSERT INTO porblt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Agora, envie alguns homens a Jope, para que tragam Simão, conhecido como Pedro, ");
INSERT INTO porblt_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","que está na casa de Simão, o curtidor de couros, que mora perto do mar.” ");
INSERT INTO porblt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Quando o anjo foi embora, Cornélio chamou dois empregados de sua casa e um soldado de sua guarda pessoal, que também era um homem religioso. ");
INSERT INTO porblt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Após ter explicado a eles tudo o que acontecera, ele os enviou a Jope. ");
INSERT INTO porblt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","No dia seguinte, enquanto eles seguiam o seu caminho e se aproximavam da cidade, Pedro subiu no telhado da casa para orar. Era quase meio-dia, ");
INSERT INTO porblt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","e ele estava com fome, esperando pelo almoço. Mas, enquanto a comida estava sendo feita, ele caiu em transe e ");
INSERT INTO porblt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","teve uma visão, em que o céu se abriu. Ele viu alguma coisa descendo, parecida com um grande lençol, amarrado pelas quatro pontas, que chegou ao chão. ");
INSERT INTO porblt_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Dentro havia todos os tipos de animais, répteis e pássaros. ");
INSERT INTO porblt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ele ouviu uma voz dizer: “Levante-se, Pedro, mate e coma!” ");
INSERT INTO porblt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mas Pedro respondeu: “De modo algum, Senhor! Eu nunca comeria alguma coisa que fosse impura e suja.” ");
INSERT INTO porblt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ele ouviu a voz falar novamente: “Não chame de impuro o que Deus purificou!” ");
INSERT INTO porblt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Isso aconteceu três vezes e, então, o lençol voltou rapidamente para o céu. ");
INSERT INTO porblt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Enquanto Pedro continuava intrigado sobre qual seria o significado da visão que havia tido, os homens que Cornélio havia mandado chegaram à casa de Simão e ficaram na porta. ");
INSERT INTO porblt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Eles chamaram, perguntando se Simão, conhecido como Pedro, estava lá. ");
INSERT INTO porblt_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro ainda estava pensando na visão, quando o Espírito Santo lhe disse: “Veja! Há três homens procurando você. ");
INSERT INTO porblt_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Levante-se, desça e vá com eles. Não se preocupe, pois fui eu quem os enviou.” ");
INSERT INTO porblt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro, então, desceu e os encontrou. Ele disse: “Sou eu quem vocês procuram. Por que estão aqui?” ");
INSERT INTO porblt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Eles responderam: “Fomos mandados pelo comandante Cornélio, um homem bom e religioso, que teme a Deus e é muito respeitado pelo povo judeu. Um anjo do Senhor mandou que ele o chamasse para ir até à casa dele, para que ele ouvisse o que você tem a dizer.” ");
INSERT INTO porblt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Então, Pedro os convidou para entrarem e ficarem lá. No dia seguinte, ele se levantou e foi com eles. Alguns dos irmãos que habitavam em Jope também foram. ");
INSERT INTO porblt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","No dia seguinte eles chegaram em Cesareia, onde Cornélio já os esperava com os seus parentes e amigos mais próximos reunidos. ");
INSERT INTO porblt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Quando Pedro entrou na casa, Cornélio o encontrou, se ajoelhou diante dele e o adorou. ");
INSERT INTO porblt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mas, Pedro o fez levantar, dizendo: “Levante-se! Eu sou apenas um homem.” ");
INSERT INTO porblt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pedro conversou com Cornélio e, então, entraram na casa, onde havia muitas outras pessoas esperando-o. ");
INSERT INTO porblt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pedro lhes disse: “Vocês certamente sabem que não é permitido que judeus se tornem amigos ou visitem as casas de pagãos. Mas, Deus me mostrou que eu não devo chamar qualquer pessoa de impura ou suja. ");
INSERT INTO porblt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","É por isso que eu vim sem qualquer hesitação, quando fui chamado. Então, agora, eu gostaria de saber a razão de você ter me chamado.” ");
INSERT INTO porblt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornélio explicou: “Há quatro dias, perto das três horas da tarde, eu estava orando em minha casa. De repente, vi um homem parado na minha frente, vestido com roupas que brilhavam muito. ");
INSERT INTO porblt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ele me disse: ‘Cornélio, as suas orações foram ouvidas, e Deus reconheceu a sua generosidade para com os pobres. ");
INSERT INTO porblt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Envie alguém a Jope, para chamar Simão Pedro. Ele está hospedado na casa de Simão, um curtidor de couros, que fica perto do mar.’ ");
INSERT INTO porblt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Então, imediatamente eu mandei chamá-lo e que bom que tenha vindo. É por isso que estamos todos aqui, reunidos diante de Deus, prontos para ouvir tudo o que o Senhor disse a você.” ");
INSERT INTO porblt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro respondeu: “Eu agora tenho certeza de que Deus não discrimina ninguém. ");
INSERT INTO porblt_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Em todas as nações, Deus aceita aqueles que o respeitam e fazem o que é bom e certo. ");
INSERT INTO porblt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Vocês conhecem a mensagem que ele enviou ao povo de Israel, compartilhando as boas novas de paz, que vêm por meio de Jesus Cristo, que é o Senhor de todos. ");
INSERT INTO porblt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Vocês sabem que essas boas novas se espalharam por toda a Judeia, começando pela Galileia, depois que João pregou sobre o batismo. ");
INSERT INTO porblt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Sabem também sobre Jesus de Nazaré, como Deus derramou sobre ele o Espírito Santo e lhe deu poder. Como Jesus andou por todos os lugares, fazendo o bem, curando aqueles que estavam sob o domínio do mal, pois Deus estava com ele. ");
INSERT INTO porblt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nós podemos dizer a todos o que ele fez na Judeia e em Jerusalém, pois estávamos com ele. E, então, eles o mataram, pendurando-o em uma cruz. ");
INSERT INTO porblt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mas, Deus o ressuscitou no terceiro dia e fez com que ele aparecesse. ");
INSERT INTO porblt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ele não apareceu a todos, mas apenas para as testemunhas escolhidas por Deus, inclusive para nós, que comemos e bebemos com ele depois que Deus o ressuscitou. ");
INSERT INTO porblt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ele nos mandou anunciar isso para todas as pessoas, para declarar que ele é o escolhido por Deus para ser o Juiz dos que estão vivos e dos mortos. ");
INSERT INTO porblt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jesus é aquele a respeito de quem todos os profetas falaram, dizendo que aqueles que creem nele receberão, por meio do seu nome, o perdão dos pecados.” ");
INSERT INTO porblt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Enquanto Pedro ainda estava falando, o Espírito Santo desceu sobre todos os que estavam ouvindo a mensagem. ");
INSERT INTO porblt_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Os seguidores judeus, que tinham vindo de Jope com Pedro, ficaram surpresos, pois o dom do Espírito Santo também tinha sido derramado sobre os pagãos. ");
INSERT INTO porblt_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Eles os ouviram falar em diferentes línguas, glorificando a Deus. ");
INSERT INTO porblt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Então, Pedro perguntou: “Alguém poderá impedi-los de serem batizados na água, sendo que eles receberam o Espírito Santo exatamente como nós?” ");
INSERT INTO porblt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Assim, Pedro mandou que eles fossem batizados em nome de Jesus Cristo. E eles pediram a Pedro para que ficasse com eles por mais algum tempo. ");
INSERT INTO porblt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Os apóstolos e os irmãos na Judeia ouviram que não-judeus também tinham aceitado a palavra de Deus. ");
INSERT INTO porblt_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Quando Pedro voltou para Jerusalém, aqueles que acreditavam que a circuncisão ainda era fundamental discutiram com ele. Eles disseram: ");
INSERT INTO porblt_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Você visitou homens não circuncidados e comeu com eles.” ");
INSERT INTO porblt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedro começou a explicar a eles tudo o que havia acontecido: ");
INSERT INTO porblt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Eu estava na cidade de Jope orando e, em um transe, tive uma visão. Algo parecido com um grande lençol estava sendo baixado do céu, preso pelas quatro pontas, até que desceu no lugar em que eu estava. ");
INSERT INTO porblt_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Quando olhei dentro dele, vi animais quadrúpedes, animais selvagens, répteis e pássaros. ");
INSERT INTO porblt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Então, ouvi uma voz que me disse: ‘Levante-se, Pedro! Mate-os e coma!’ ");
INSERT INTO porblt_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mas, eu respondi: ‘De modo algum, Senhor! Nunca comi nada que fosse impuro ou sujo!’ ");
INSERT INTO porblt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","A voz do céu falou novamente e disse: ‘Não chame de impuro ao que Deus purificou!’ ");
INSERT INTO porblt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Isso aconteceu três vezes e, depois, o lençol, com tudo que estava dentro, voltou para o céu. ");
INSERT INTO porblt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Exatamente naquele momento, três homens estavam em frente à casa onde eu estava hospedado. Eles foram enviados da cidade de Cesareia, para me ver. ");
INSERT INTO porblt_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","O Espírito me disse para acompanhá-los, sem duvidar. Estes seis irmãos que estão aqui também foram comigo, e nós entramos na casa de Cornélio. ");
INSERT INTO porblt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ele nos explicou como um anjo havia aparecido a ele em sua casa. Esse anjo lhe disse: ‘Envie alguém para a cidade de Jope e traga Simão, também conhecido como Pedro. ");
INSERT INTO porblt_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ele irá lhe dizer o que você precisa ouvir para que, tanto você quanto toda a sua família sejam salvos.’ ");
INSERT INTO porblt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Quando comecei a falar, o Espírito Santo desceu sobre eles, exatamente como tinha descido sobre nós no início. ");
INSERT INTO porblt_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","‘Então, me lembrei do que o Senhor disse: João batizou com água, mas vocês serão batizados com o Espírito Santo.’ ");
INSERT INTO porblt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Então, se Deus deu a eles o mesmo dom que ele nos deu, quando cremos no Senhor Jesus Cristo, como eu poderia me opor a Deus?” ");
INSERT INTO porblt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Depois que eles ouviram a explicação de Pedro, não discutiram mais com ele e louvaram a Deus, dizendo: “Deus agora deu a oportunidade para que não-judeus também se arrependam e ganhem a vida eterna.” ");
INSERT INTO porblt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Os seguidores de Jesus, que haviam fugido por causa da perseguição que aconteceu quando Estêvão foi morto, percorreram todo o caminho até a Fenícia, a ilha de Chipre e a cidade de Antioquia. Eles só anunciavam as boas novas entre os judeus. ");
INSERT INTO porblt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mas, quando algum deles, vindos de Chipre e da cidade de Cirene, chegaram na cidade de Antioquia, anunciaram a palavra de Deus também aos gregos, falando para eles sobre o Senhor Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","O poder do Senhor estava com eles e muitas pessoas creram e se converteram ao Senhor. ");
INSERT INTO porblt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","A notícia sobre o que havia acontecido chegou até a igreja em Jerusalém, e eles enviaram Barnabé para Antioquia. ");
INSERT INTO porblt_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Quando ele chegou e viu por si mesmo como Deus havia abençoado aquelas pessoas, ele ficou muito feliz. Ele encorajou todos a se dedicarem de todo o coração a Deus e a permanecerem fiéis. ");
INSERT INTO porblt_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabé era um bom homem, cheio do Espírito Santo e que depositou toda a sua fé em Deus. Muitas pessoas foram trazidas para o Senhor. ");
INSERT INTO porblt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Então, Barnabé foi até à cidade de Tarso, para procurar por Saulo. ");
INSERT INTO porblt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Quando o encontrou, ele o levou para Antioquia. Durante todo um ano, eles trabalharam junto com a igreja, ensinando a mensagem para multidões de pessoas. Foi na cidade de Antioquia que, pela primeira vez, os que haviam crido em Jesus foram chamados de “cristãos.” ");
INSERT INTO porblt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Foi durante esse período que alguns profetas foram de Jerusalém para Antioquia. ");
INSERT INTO porblt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Um deles se chamava Ágabo. Ele se levantou e, pelo poder do Espírito Santo, avisou que haveria uma terrível falta de alimentos, que afetaria todas as partes do mundo. (Isso ocorreu no reinado do imperador Cláudio.) ");
INSERT INTO porblt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Os seguidores de Jesus decidiram enviar ajuda para os irmãos que moravam na Judeia, com cada um doando de acordo com o que tinha. ");
INSERT INTO porblt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Então, eles fizeram isso e enviaram, por intermédio de Barnabé e Saulo, o dinheiro arrecadado para os líderes da igreja de lá. ");
INSERT INTO porblt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nessa época, o rei Herodes começou a perseguir alguns membros da igreja. ");
INSERT INTO porblt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ele mandou matar Tiago, irmão de João, à espada. ");
INSERT INTO porblt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Quando Herodes percebeu que os judeus estavam agradecidos por isso, ele mandou que prendessem Pedro também, o que aconteceu durante a Festa dos Pães sem Fermento. ");
INSERT INTO porblt_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Após ter prendido Pedro, ele o colocou na cadeia, com quatro grupos de quatro soldados cada para vigiá-lo. Ele planejava levar Pedro a julgamento público depois da Páscoa. ");
INSERT INTO porblt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Enquanto Pedro estava na prisão, a igreja orava intensamente para que Deus o ajudasse. ");
INSERT INTO porblt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Na noite anterior ao julgamento, Pedro dormia entre dois soldados, acorrentado a cada um deles e com guardas na porta, que o vigiavam. ");
INSERT INTO porblt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","De repente, um anjo do Senhor apareceu e a cela ficou completamente iluminada. O anjo sacudiu Pedro para que ele acordasse e disse: “Rápido! Levante-se!” As correntes que o prendiam caíram dos seus pulsos, ");
INSERT INTO porblt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","e o anjo lhe disse: “Vista-se e coloque as sandálias!” E foi o que Pedro fez. Depois, o anjo disse: “Coloque a sua capa e me siga!” ");
INSERT INTO porblt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Então, Pedro seguiu o anjo. Ele não percebeu de imediato que tudo aquilo estava realmente acontecendo. Ele pensou que estava tendo uma visão. ");
INSERT INTO porblt_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Eles passaram pelo primeiro e depois pelo segundo grupo de guardas, até chegarem ao portão de ferro que dava para a cidade. O portão se abriu sozinho para que eles passassem. Pedro e o anjo saíram e desceram por uma rua, quando, de repente, o anjo partiu. ");
INSERT INTO porblt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Quando Pedro caiu em si, e disse: “Agora vejo que tudo isso realmente aconteceu! O Senhor enviou o seu anjo para me salvar das garras de Herodes e de tudo que o povo judeu tinha a intenção de me fazer.” ");
INSERT INTO porblt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Depois de ter tomado consciência de tudo que havia acontecido, Pedro foi para a casa de Maria, mãe de João Marcos. Muitas pessoas tinham se reunido ali e estavam orando. ");
INSERT INTO porblt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Quando Pedro bateu na porta da frente, uma empregada, chamada Rode, veio abrir. ");
INSERT INTO porblt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mas, tamanha foi a sua emoção, ao reconhecer a voz de Pedro, que ela não abriu a porta. Em vez disso, ela correu de volta para dentro, gritando: “Pedro está lá fora!” ");
INSERT INTO porblt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Eles disseram para ela: “Você está maluca!” Mas, ela continuava insistindo que estava falando a verdade. Então, eles disseram: “Deve ser o anjo dele.” ");
INSERT INTO porblt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Enquanto isso, Pedro continuava batendo na porta. Quando eles finalmente a abriram, viram que era realmente ele e ficaram muito chocados. ");
INSERT INTO porblt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pedro levantou a sua mão, sinalizando para que eles ficassem quietos e, assim, pôde lhes explicar como o Senhor o havia ajudado a escapar da cadeia. Ele lhes disse: “Avisem Tiago e os outros irmãos sobre isso.” Depois, ele saiu de lá e foi para outro lugar. ");
INSERT INTO porblt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Quando o dia amanheceu, os soldados ficaram totalmente confusos sobre o que havia acontecido com Pedro. ");
INSERT INTO porblt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes fez uma busca completa por ele, mas não conseguiu encontrá-lo. Após interrogar os guardas, Herodes ordenou que eles fossem executados. Depois, Herodes foi embora da Judeia e ficou na cidade de Cesareia. ");
INSERT INTO porblt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes estava furioso com os moradores de Tiro e de Sidom. Eles, então, enviaram um grupo para vê-lo e conseguiram ganhar o apoio de Blasto, o assistente pessoal do rei. Eles pediram paz a Herodes, pois dependiam das terras do rei para obter alimentos. ");
INSERT INTO porblt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Quando chegou o dia do encontro com o rei, Herodes colocou a sua roupa de rei, sentou-se no trono e começou a discursar. ");
INSERT INTO porblt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","O público respondeu aos gritos: “Esta é a voz de um deus, não a de um homem!” ");
INSERT INTO porblt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Imediatamente, o anjo do Senhor feriu Herodes, pois ele não tinha glorificado a Deus. Ele foi consumido por vermes e morreu. ");
INSERT INTO porblt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Mas, a palavra de Deus se espalhou e cada vez mais pessoas acreditavam na mensagem do Senhor. ");
INSERT INTO porblt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Assim que terminaram sua missão, Barnabé e Saulo voltaram de Jerusalém, levando João Marcos com eles. ");
INSERT INTO porblt_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Na igreja de Antioquia havia os seguintes profetas e mestres: Barnabé, Simeão, chamado “o Negro”, Lúcio de Cirene, Manaém (amigo de infância de Herodes, o tetrarca) e Saulo. ");
INSERT INTO porblt_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Enquanto eles estavam adorando o Senhor e jejuando, o Espírito Santo disse: “Separem Barnabé e Saulo para que façam o trabalho para o qual eu os chamei.” ");
INSERT INTO porblt_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Depois que eles jejuaram, oraram e colocaram as suas mãos sobre eles para abençoá-los, eles enviaram Barnabé e Saulo para a sua missão. ");
INSERT INTO porblt_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Então, Barnabé e Saulo, orientados pelo Espírito Santo, foram para Selêucia. De lá, eles partiram de barco para a ilha de Chipre. ");
INSERT INTO porblt_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Chegando na cidade de Salamina, eles anunciaram a palavra de Deus nas sinagogas judaicas. João estava com eles como auxiliar. ");
INSERT INTO porblt_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Eles viajaram por toda a ilha e finalmente chegaram a Pafos. Lá, encontraram um mágico judeu, um falso profeta, chamado Barjesus. ");
INSERT INTO porblt_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ele era amigo do governador Sérgio Paulo, um homem inteligente. Sérgio Paulo convidou Barnabé e Saulo para visitá-lo, pois ele queria ouvir a palavra de Deus. ");
INSERT INTO porblt_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mas, o mágico Elimas (este é o nome dele em grego) era contra os apóstolos e tentou evitar que o governador cresse em Deus. ");
INSERT INTO porblt_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Então, Saulo, também chamado Paulo, cheio do Espírito Santo, olhou direto para Elimas e disse: ");
INSERT INTO porblt_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Você está repleto de mentiras e de tudo o que é mau. Filho do diabo!, inimigo de tudo o que é justo!, você nunca desistirá de torcer os verdadeiros ensinamentos do Senhor? ");
INSERT INTO porblt_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Escute! A mão do Senhor está sobre você e o deixará cego. Você não verá o sol por algum tempo.” Imediatamente, névoa e escuridão cobriram os olhos de Elimas e ele precisou encontrar alguém que o guiasse pela mão. ");
INSERT INTO porblt_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Quando o governador viu o que havia acontecido, ele creu em Deus e ficou completamente maravilhado com os ensinamentos sobre o Senhor. ");
INSERT INTO porblt_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Então, Paulo e os que estavam com ele navegaram da cidade de Pafos para Perge, na região da Panfília. Enquanto isso, João os deixou e voltou para Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Eles passaram por Perge e continuaram até Antioquia da Pisídia. No sábado, eles entraram na sinagoga e se sentaram. ");
INSERT INTO porblt_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Após a leitura da Lei e do livro dos Profetas, os líderes da sinagoga mandaram dizer-lhes: “Irmãos, por favor, compartilhem com o povo quaisquer palavras de encorajamento que possam ter.” ");
INSERT INTO porblt_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulo se levantou, fez um sinal com a mão, para pedir a atenção dos que lá estavam, e começou a falar: “Homens de Israel e todos os não-judeus que temem a Deus, ouçam-me! ");
INSERT INTO porblt_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","O Deus do povo de Israel escolheu nossos antepassados e deu ao nosso povo prosperidade durante a sua permanência no Egito. Depois, com o seu grande poder, ele os tirou do Egito e, ");
INSERT INTO porblt_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","no deserto, aguentou aquela gente durante quarenta anos. ");
INSERT INTO porblt_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Após ter destruído sete nações que viviam na região de Canaã, Deus dividiu essa terra e deu-a como herança aos israelitas. Tudo isso levou cerca de quatrocentos e cinquenta anos. ");
INSERT INTO porblt_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Então, Deus lhes deu juízes para serem seus líderes até o tempo do profeta Samuel. ");
INSERT INTO porblt_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","A partir daí, as pessoas pediram um rei, e Deus lhes deu Saul, filho de Quis, da tribo de Benjamim. Saul governou por quarenta anos. ");
INSERT INTO porblt_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Depois, Deus rejeitou Saul e fez de Davi o novo rei. Deus aprovou Davi, dizendo: ‘Encontrei em Davi, filho de Jessé, um homem que está de acordo com o meu coração. Ele fará tudo o que eu quero.’ ");
INSERT INTO porblt_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jesus é descendente de Davi. Ele é o Salvador que Deus prometeu ao povo de Israel. ");
INSERT INTO porblt_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Antes de Jesus vir, João anunciou o batismo de arrependimento para todo o povo de Israel. ");
INSERT INTO porblt_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Quando João já estava quase terminando a sua missão, ele disse: ‘Quem vocês acham que eu sou? Eu não sou aquele que vocês procuram. Mas, depois de mim, virá aquele cujas sandálias eu nem mesmo sou digno de desamarrar.’ ");
INSERT INTO porblt_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Meus irmãos, descendentes de Abraão, e também vocês não-judeus, que são tementes a Deus: a mensagem desta salvação foi enviada para nós! ");
INSERT INTO porblt_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","O povo que vive em Israel e os seus líderes não reconheceram Jesus e nem compreenderam as palavras dos profetas, que são lidas todos os sábados. Na verdade, eles cumpriram as profecias, ao condenar Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mesmo que eles não tenham conseguido encontrar qualquer prova para condená-lo, ainda assim, eles pediram para que Pilatos o matasse. ");
INSERT INTO porblt_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Depois que fizeram tudo como estava previsto nas Sagradas Escrituras, tiraram Jesus da cruz e o puseram em um túmulo. ");
INSERT INTO porblt_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mas, Deus o ressuscitou dos mortos, ");
INSERT INTO porblt_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","e ele apareceu durante muitos dias para as pessoas que o tinham seguido da Galileia até Jerusalém. Esses seguidores agora são testemunhas que falam sobre Jesus para todos. ");
INSERT INTO porblt_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nós estamos aqui para trazer a vocês as boas novas da promessa que Deus fez aos nossos antepassados. ");
INSERT INTO porblt_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Promessa que ele cumpriu para nós, seus filhos, ao ressuscitar Jesus. Como está escrito no Salmo número dois: ‘Você é o meu Filho; hoje eu me tornei o seu Pai.’ ");
INSERT INTO porblt_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Deus o ressuscitou, para que ele nunca mais morresse, como indicou ao dizer: ‘Eu cumprirei em favor de vocês as santas e fiéis promessas feitas a Davi.’ ");
INSERT INTO porblt_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","E, em outro salmo também é dito: ‘Não permitirá que o seu Santo apodreça no túmulo.’ ");
INSERT INTO porblt_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Mas Davi morreu, após ter feito o que Deus queria. Ele foi, então, sepultado com os seus antepassados, e o seu corpo se decompôs. ");
INSERT INTO porblt_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Porém, aquele que Deus ressuscitou não experimentou a decadência do corpo. ");
INSERT INTO porblt_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Meus irmãos, quero que entendam que nós estamos lhes dizendo que, por intermédio desse homem, podemos encontrar o perdão para os nossos pecados. ");
INSERT INTO porblt_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ele torna os que creem nele moralmente justos, libertando-os de tudo que é errado. E isso é feito de uma maneira que nem mesmo a lei de Moisés conseguiria. ");
INSERT INTO porblt_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Tenham cuidado para que não aconteça com vocês o que os profetas disseram: ");
INSERT INTO porblt_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Vocês, que desprezam a Deus, olhem com espanto e morram! Pois eu farei coisas que vocês nunca acreditariam ser possível, mesmo se alguém lhes dissesse!’” ");
INSERT INTO porblt_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Quando Paulo e Barnabé estavam saindo da sinagoga, as pessoas pediram que eles voltassem novamente no sábado seguinte, para lhes falar mais sobre essas coisas. ");
INSERT INTO porblt_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Depois da reunião na sinagoga, muitos judeus e pessoas convertidas ao judaísmo seguiram Paulo e Barnabé, que falavam com eles, encorajando-os a continuarem firmes na graça de Deus. ");
INSERT INTO porblt_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","No sábado seguinte, quase toda a cidade se reuniu para ouvi-los falar sobre a palavra de Deus. ");
INSERT INTO porblt_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","No entanto, quando os judeus viram a multidão que estava lá reunida, ficaram com muita inveja e, então, começaram a dizer o contrário do que Paulo dizia e o insultaram. ");
INSERT INTO porblt_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Então, cheios de coragem, Paulo e Barnabé disseram: “Nós precisávamos anunciar a palavra de Deus primeiro a vocês. Mas, já que a rejeitam, vocês mesmos estão decidindo que não são dignos da vida eterna e, por isso, iremos anunciar a mensagem de Deus para os não-judeus. ");
INSERT INTO porblt_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Isso é o que o Senhor nos disse: ‘Eu fiz de você uma luz para os não judeus e, por meio de você, a salvação será levada para todos os cantos do mundo.’” ");
INSERT INTO porblt_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Quando os não-judeus ouviram o que os apóstolos disseram, eles ficaram muito felizes e começaram a louvar a palavra do Senhor. E, todos os que foram escolhidos para ter a vida eterna creram em Deus. ");
INSERT INTO porblt_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Assim, a mensagem de Deus se espalhou por toda a região. ");
INSERT INTO porblt_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mas, os judeus incitaram as mulheres religiosas importantes e os líderes da cidade para que perseguissem Paulo e Barnabé. Eles conseguiram que os dois fossem expulsos daquelas terras. ");
INSERT INTO porblt_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Os apóstolos tiraram até o pó de suas sandálias, como um sinal de protesto contra eles, e se dirigiram para a cidade de Icônio. ");
INSERT INTO porblt_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","E os cristãos de Antioquia da Pisídia transbordavam de alegria e eram cheios do Espírito Santo. ");
INSERT INTO porblt_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Em Icônio, Paulo e Barnabé foram para a sinagoga judaica e falaram de forma tão convincente que muitos judeus e não-judeus creram em Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mas, os judeus que se recusaram a crer em Jesus atiçaram os sentimentos dos pagãos e os colocaram contra os que criam. ");
INSERT INTO porblt_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulo e Barnabé ficaram lá por um longo tempo, falando para eles com muita coragem sobre o Senhor. E Jesus confirmava a mensagem de graça que eles anunciavam dando-lhes poder de realizar milagres e maravilhas. ");
INSERT INTO porblt_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Os moradores da cidade ficaram divididos: alguns apoiavam os judeus que não acreditaram, enquanto outros defendiam os apóstolos. ");
INSERT INTO porblt_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mas, então, os pagãos e os judeus, juntamente com os seus líderes, decidiram atacar e apedrejar Paulo e Barnabé. ");
INSERT INTO porblt_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Entretanto, eles ficaram sabendo disso e fugiram para a região da Licaônia, para as cidades de Listra e Derbe, ");
INSERT INTO porblt_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","onde continuaram a anunciar as boas novas do Reino de Deus. ");
INSERT INTO porblt_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Na cidade de Listra, havia um homem que era aleijado dos pés. Ele nasceu aleijado e nunca tinha sido capaz de andar. ");
INSERT INTO porblt_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ele se sentou para ouvir Paulo falar. Quando Paulo olhou diretamente para ele e percebeu que o homem acreditava que Deus poderia curá-lo, ");
INSERT INTO porblt_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Paulo disse em voz alta: “Fique em pé!” O homem deu um salto e começou a andar. ");
INSERT INTO porblt_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Quando a multidão que lá estava viu o que havia acontecido, gritaram em sua língua: “Os deuses tomaram a forma humana e desceram do céu até nós!” ");
INSERT INTO porblt_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Eles pensaram que Barnabé fosse o deus Júpiter, e que Paulo fosse Mercúrio, pois ele era o que mais falava. ");
INSERT INTO porblt_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","O sacerdote do templo de Júpiter, que ficava na entrada da cidade, trouxe bois e coroas de flores para os portões da cidade. Ele planejava fazer um sacrifício diante da multidão. ");
INSERT INTO porblt_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mas, quando os apóstolos Barnabé e Paulo souberam disso, eles rasgaram as suas roupas e correram até a multidão, gritando: ");
INSERT INTO porblt_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“O que vocês estão fazendo? Nós somos humanos exatamente como vocês. Viemos trazer a palavra de Deus para que vocês abandonem essas coisas sem sentido e se voltem para um Deus que está verdadeiramente vivo. Ele é quem fez o céu, a terra, o mar e tudo que existe. ");
INSERT INTO porblt_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","No passado, ele deixou que cada nação seguisse o seu próprio caminho. ");
INSERT INTO porblt_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ainda assim, ele continua a dar provas da sua existência, fazendo boas ações. Ele envia a chuva do céu e faz com que as lavouras cresçam no tempo certo. É ele quem dá alimento a vocês e enche seus corações de alegria.” ");
INSERT INTO porblt_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mesmo dizendo isso, os apóstolos tiveram dificuldade para impedir a multidão de lhes sacrificar os animais. ");
INSERT INTO porblt_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mas, alguns judeus vindos de Antioquia e de Icônio chegaram e conseguiram o apoio da multidão. Eles apedrejaram Paulo e o jogaram para fora dos portões da cidade, pensando que ele havia morrido. ");
INSERT INTO porblt_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mas, quando os cristãos se reuniram em volta dele, Paulo se levantou e voltou para a cidade. No dia seguinte, Paulo e Barnabé foram para a cidade de Derbe. ");
INSERT INTO porblt_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Após anunciarem o evangelho às pessoas naquela cidade, e muitos moradores se converterem em seguidores de Jesus, os dois voltaram para as cidades de Listra, Icônio e Antioquia. ");
INSERT INTO porblt_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Eles animavam os seguidores de Jesus para que continuassem firmes e mantivessem a sua fé nele. Paulo e Barnabé diziam: “Precisamos passar por muitos desafios para entrar no Reino de Deus.” ");
INSERT INTO porblt_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Depois de terem nomeado presbíteros para todas as igrejas e terem orado e jejuado com eles, Paulo e Barnabé os deixaram aos cuidados do Senhor, em quem eles criam. ");
INSERT INTO porblt_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Os dois passaram pela Pisídia e chegaram na Panfília. ");
INSERT INTO porblt_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Eles anunciaram a palavra de Deus em Perge e, depois, foram para Atália. ");
INSERT INTO porblt_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","De lá, eles voltaram de barco para Antioquia, de onde tinham começado a viagem e que era o lugar em que Deus lhes havia determinado a missão, agora concluída, de anunciar a sua palavra. ");
INSERT INTO porblt_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Eles chegaram e logo reuniram a igreja. Os dois contaram tudo o que Deus tinha realizado por meio deles e de como ele havia aberto a porta para que os não-judeus cressem nele. ");
INSERT INTO porblt_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Paulo e Barnabé ficaram ali por um longo tempo com os seguidores de Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Alguns homens, que vieram da Judeia e chegaram em Antioquia, começaram a falar para os seguidores de Jesus: “Vocês só serão salvos se fizerem a circuncisão, de acordo com a regras determinadas por Moisés.” ");
INSERT INTO porblt_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulo e Barnabé não concordaram com isso e tiveram grande discussão com eles. Então, eles dois e mais alguns outros foram escolhidos para irem a Jerusalém conversar com os apóstolos e os líderes de lá sobre essa questão. ");
INSERT INTO porblt_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","A igreja os enviou e, no caminho, enquanto passavam pela Fenícia e por Samaria, eles explicavam para as pessoas como os pagãos estavam se convertendo a Deus. Isso deixava aqueles que criam em Jesus muito felizes. ");
INSERT INTO porblt_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Quando eles chegaram em Jerusalém, foram bem recebidos pelos membros da igreja, pelos apóstolos e pelos presbíteros. Eles, então, explicaram tudo o que Deus havia feito por intermédio deles. ");
INSERT INTO porblt_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mas, eles encontraram oposição entre os seguidores que pertenciam ao partido dos fariseus. Eles disseram: “Aqueles que se convertem devem ser circuncidados e obrigados a seguir a lei de Moisés.” ");
INSERT INTO porblt_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Os apóstolos e os presbíteros se reuniram para discutir o assunto. ");
INSERT INTO porblt_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Após muito debate, Pedro se levantou e lhes disse: “Irmãos, vocês sabem que há muito tempo, Deus me escolheu entre vocês para que os não-judeus pudessem ouvir a mensagem das boas novas e para crerem em Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Deus, que sabe o que pensamos, mostrou que os aceita, dando a eles o Espírito Santo da mesma forma que fez conosco. ");
INSERT INTO porblt_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ele não fez diferença alguma entre nós e eles. Ele purificou os pensamentos deles quando passaram a crer nele. ");
INSERT INTO porblt_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Então, por que vocês querem se opor a Deus, colocando uma carga tão pesada nas costas dos que agora creem? Carga essa que nem nós e nem os nossos antepassados pudemos carregar? ");
INSERT INTO porblt_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nós estamos convencidos de que somos salvos por meio da graça do Senhor Jesus, da mesma maneira que eles são.” ");
INSERT INTO porblt_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Todos ouviram atentamente Barnabé e Paulo, enquanto eles explicavam os milagres que Deus tinha realizado por meio deles entre os não-judeus. ");
INSERT INTO porblt_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Assim que eles terminaram de falar, Tiago disse: “Irmãos, ouçam! ");
INSERT INTO porblt_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simão explicou como Deus primeiro mostrou a sua preocupação com os não-judeus, ao escolher entre eles um povo comprometido com ele. ");
INSERT INTO porblt_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Isso aconteceu de acordo com as palavras dos profetas, que escreveram: ");
INSERT INTO porblt_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘No futuro, eu irei voltar e reconstruirei a casa de Davi, que caiu. Eu juntarei os seus pedaços e a colocarei em pé. ");
INSERT INTO porblt_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Eu farei isso para que os que foram deixados possam buscar o Senhor, incluindo os não-judeus que chamam pelo meu nome. ");
INSERT INTO porblt_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Foi assim que o Senhor falou, anunciando essas coisas há muito tempo.’ ");
INSERT INTO porblt_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Então, a minha opinião é a de que nós não deveríamos atrapalhar os não-judeus que se convertem a Deus. ");
INSERT INTO porblt_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Deveríamos escrever a eles e lhes dizer para evitarem comer a carne dos animais sacrificados aos ídolos, que não pratiquem imoralidade sexual, que não comam carne de animais que foram estrangulados e não consumam sangue. ");
INSERT INTO porblt_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Pois a lei de Moisés está sendo ensinada em todas as cidades já há muito tempo e é lida todos os sábados nas sinagogas.” ");
INSERT INTO porblt_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Então, os apóstolos e os presbíteros, juntamente com toda a igreja, decidiram que seria bom escolher alguns representantes e enviá-los até Antioquia com Paulo e Barnabé. Os escolhidos foram Judas, conhecido como Barsabás, e Silas, os quais eram muito respeitados entre os irmãos. ");
INSERT INTO porblt_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Junto com eles, foi enviada a seguinte carta: “Nós, os apóstolos, os presbíteros e os irmãos mandamos saudações aos não-judeus de Antioquia, da Síria e da Cilícia. ");
INSERT INTO porblt_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nós ouvimos que alguns membros do nosso grupo os confundiram com as palavras que disseram, causando problemas para vocês. Nós podemos lhes garantir que não dissemos para eles fazerem isso. ");
INSERT INTO porblt_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Então, concordamos em escolher alguns representantes para enviá-los até vocês, juntamente com os nossos queridos irmãos Barnabé e Paulo, ");
INSERT INTO porblt_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","que arriscaram a vida pelo nome do nosso Senhor Jesus Cristo. ");
INSERT INTO porblt_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Assim, enviamos Judas e Silas, que podem lhes confirmar pessoalmente o que estamos dizendo. ");
INSERT INTO porblt_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Pareceu bem ao Espírito Santo e a nós não colocar sobre vocês nenhuma carga mais pesada do que estas importantes exigências: ");
INSERT INTO porblt_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Vocês devem evitar comer a carne dos animais sacrificados aos ídolos, consumir sangue, comer a carne de animais estrangulados e não praticar imoralidade sexual. Vocês estarão agindo bem se obedecerem a essas exigências. Deus os abençoe!” ");
INSERT INTO porblt_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Assim, enviaram os homens para Antioquia. Quando eles chegaram lá, reuniram a todos e entregaram a carta. ");
INSERT INTO porblt_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Após lerem o que estava escrito, as pessoas ficaram muito felizes pela mensagem encorajadora. ");
INSERT INTO porblt_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas e Silas, que também eram profetas, incentivaram os irmãos, explicando a eles muitas coisas e fortalecendo a sua fé. ");
INSERT INTO porblt_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Após passarem algum tempo lá, os irmãos os mandaram de volta, desejando que enviassem as suas bênçãos para aqueles que os tinham enviado de Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Mas, Paulo e Barnabé continuaram em Antioquia, ensinando e anunciando a palavra de Deus, juntamente com muitos outros. ");
INSERT INTO porblt_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Algum tempo depois, Paulo disse a Barnabé: “Vamos voltar e visitar os irmãos nas cidades em que compartilhamos a palavra do Senhor e ver como eles estão.” ");
INSERT INTO porblt_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabé queria levar João Marcos também. ");
INSERT INTO porblt_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Mas Paulo não achou uma boa ideia que ele os acompanhasse, pois ele os tinha deixado na Panfília e não tinha continuado o trabalho com eles. ");
INSERT INTO porblt_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Eles se desentenderam tão profundamente que se separaram. Barnabé levou Marcos com ele e navegaram para a ilha de Chipre. ");
INSERT INTO porblt_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulo escolheu Silas e, quando eles partiram, os irmãos pediram ao Senhor que a sua bênção seguisse com eles. ");
INSERT INTO porblt_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Paulo viajou pela Síria e pela Cilícia, incentivando as igrejas de lá. ");
INSERT INTO porblt_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo foi primeiro para a cidade de Derbe e depois, para Listra, onde ele encontrou um cristão, chamado Timóteo. A mãe dele era judia-cristã e o seu pai era grego. ");
INSERT INTO porblt_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Os irmãos de Listra e de Icônio falavam muito bem de Timóteo. ");
INSERT INTO porblt_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo queria que Timóteo viajasse com ele. Então, ele o circuncidou, porque os judeus daquela região sabiam que o pai de Timóteo era grego. ");
INSERT INTO porblt_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Conforme viajavam por diferentes cidades, eles passavam para os cristãos as exigências que os apóstolos e os presbíteros em Jerusalém lhes haviam dito que deveriam ser obedecidas. ");
INSERT INTO porblt_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","As igrejas fortaleciam a sua fé no Senhor e, a cada dia, o número de cristãos aumentava. ");
INSERT INTO porblt_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Eles viajaram pela região da Frígia-Galácia, pois o Espírito Santo os impediu de ir à província da Ásia para anunciar a palavra. ");
INSERT INTO porblt_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Quando eles chegaram à fronteira de Mísia, tentaram entrar na região da Bitínia, mas o Espírito de Jesus não deixou que eles fossem para lá. ");
INSERT INTO porblt_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Então, eles passaram por Mísia e desceram para a cidade de Trôade. ");
INSERT INTO porblt_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Lá, durante a noite, Paulo teve uma visão de um homem da província da Macedônia, que estava em pé e lhe pedia: “Por favor, venha até a Macedônia e ajude-nos!” ");
INSERT INTO porblt_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Após Paulo ter essa visão, nós imediatamente arrumamos nossas coisas e fomos para a Macedônia, pois concluímos que Deus nos havia chamado para anunciar as boas novas ao povo de lá. ");
INSERT INTO porblt_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nós navegamos de Trôade direto para a ilha de Samotrácia. No dia seguinte, fomos para Neápolis ");
INSERT INTO porblt_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","e, de lá, para Filipos, cidade da Macedônia, primeira do distrito e também uma colônia romana. Ficamos nessa cidade por vários dias. ");
INSERT INTO porblt_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","No sábado, nós saímos da cidade e fomos para a beira do rio, onde pensamos que as pessoas iriam para orar. Sentamos e conversamos com as mulheres que estavam reunidas ali. ");
INSERT INTO porblt_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Uma delas chamada Lídia, que vendia tecido púrpura, era da cidade de Tiatira. Ela adorava a Deus e escutava o que tínhamos a dizer. O Senhor abriu a sua mente para o que Paulo estava dizendo, e ela aceitou o que ele lhe disse. ");
INSERT INTO porblt_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Depois que ela e todas as pessoas de sua casa foram batizadas, ela nos pediu: “Se vocês realmente acham que eu estou, de coração, comprometida com o Senhor, então, venham e fiquem em minha casa.” Ela continuou insistindo, até que concordamos. ");
INSERT INTO porblt_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Um dia, quando estávamos descendo para o lugar de oração, encontramos uma escrava possuída por um espírito maligno. Ela ganhava muito dinheiro para os seus donos, adivinhando o futuro. ");
INSERT INTO porblt_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Essa garota seguiu Paulo e o restante de nós, gritando: “Estes homens são servos de Deus Todo-Poderoso. Eles estão dizendo a vocês o que precisam fazer para serem salvos!” ");
INSERT INTO porblt_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ela continuou a fazer isso por muitos dias. Isso incomodou Paulo. Então, ele se virou e disse ao espírito: “Eu ordeno, em nome de Jesus Cristo, que você saia do corpo dela!” E o espírito imediatamente a deixou. ");
INSERT INTO porblt_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mas, quando os donos dela viram que tinham perdido o seu meio de ganhar dinheiro, eles agarraram Paulo e Silas e os arrastaram para que encarassem as autoridades na praça pública. ");
INSERT INTO porblt_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Eles os levaram diante das autoridades romanas e os acusaram: “Estes judeus estão causando grande confusão em nossa cidade. ");
INSERT INTO porblt_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Eles estão propagando costumes que são contra a nossa lei, e que nós, romanos, não podemos aceitar, nem praticar.” ");
INSERT INTO porblt_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","A multidão se uniu para atacá-los. As autoridades tiraram as roupas de Paulo e Silas e ordenaram que batessem neles com varas. ");
INSERT INTO porblt_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Depois que bateram muito neles, eles foram jogados na cadeia e deram ordem para que o carcereiro os mantivesse trancados na cela. ");
INSERT INTO porblt_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","O carcereiro cumpriu o que lhe foi dito. Ele jogou Paulo e Silas na cela e acorrentou os pés deles em troncos de madeira. ");
INSERT INTO porblt_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Era próximo da meia-noite, e Paulo e Silas estavam orando e cantando hinos a Deus, enquanto os outros prisioneiros os escutavam. ");
INSERT INTO porblt_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","De repente, um tremor de terra muito forte balançou as fundações da prisão. Imediatamente, todas as portas se abriram e as correntes que prendiam a todos caíram. ");
INSERT INTO porblt_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","O carcereiro acordou e viu as portas da cadeia completamente abertas. Ele tirou sua espada e estava a ponto de se matar, pensando que os prisioneiros tinham fugido. ");
INSERT INTO porblt_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Mas, Paulo gritou: “Não se machuque! Nós todos ainda estamos aqui.” ");
INSERT INTO porblt_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","O carcereiro pediu que trouxessem uma luz e entrou depressa na cela. Tremendo de medo, ele se ajoelhou diante de Paulo e de Silas. ");
INSERT INTO porblt_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ele os levou para fora e perguntou: “Senhores, o que eu preciso fazer para que possa ser salvo?” ");
INSERT INTO porblt_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Eles responderam: “Creia no Senhor Jesus, e você e toda a sua família serão salvos.” ");
INSERT INTO porblt_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Então, eles anunciaram a palavra do Senhor a ele e a todas as pessoas da casa dele. ");
INSERT INTO porblt_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Embora fosse bem tarde da noite, ele limpou as feridas dos apóstolos e foi batizado, junto com toda a sua família. ");
INSERT INTO porblt_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ele os levou para a sua casa e preparou uma refeição para eles. O carcereiro e todas as pessoas da sua família estavam cheios de alegria, porque agora criam em Deus. ");
INSERT INTO porblt_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","No dia seguinte, bem cedo, as autoridades romanas enviaram guardas até o carcereiro e eles lhe disseram: “Solte aqueles homens!” ");
INSERT INTO porblt_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","O carcereiro disse a Paulo: “As autoridades mandaram soltá-los. Então, vocês podem sair e vão em paz!” ");
INSERT INTO porblt_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mas Paulo lhes disse: “Nós somos cidadãos romanos, e eles nos bateram publicamente sem que houvesse um julgamento. Depois, ainda fomos jogados na cadeia. Agora, eles querem nos mandar embora em segredo? Não, eles mesmos devem vir pessoalmente para nos soltar.” ");
INSERT INTO porblt_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Os guardas voltaram e disseram para as autoridades romanas o que Paulo havia falado. Ao saberem que Paulo e Silas eram cidadãos romanos, eles ficaram realmente preocupados ");
INSERT INTO porblt_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","e foram se desculpar com eles. Eles o levaram para fora e imploraram para que deixassem a cidade. ");
INSERT INTO porblt_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Então, Paulo e Silas saíram da cadeia e foram para a casa de Lídia. Lá, eles se encontraram com seguidores de Jesus e os encorajaram. Depois, eles continuaram a sua viagem. ");
INSERT INTO porblt_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Depois que Paulo e Silas passaram pelas cidades de Anfípolis e Apolônia, eles chegaram à Tessalônica, onde havia uma sinagoga judaica. ");
INSERT INTO porblt_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Como de costume, Paulo entrou na sinagoga e, durante três sábados, conversou com as pessoas que estavam lá sobre as Sagradas Escrituras. ");
INSERT INTO porblt_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ele explicou o que significam as Sagradas Escrituras, provando que o Messias precisava morrer e ressuscitar dos mortos. Ele disse para as pessoas: “Este Jesus, que eu lhes anuncio, é o Messias.” ");
INSERT INTO porblt_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Alguns deles se convenceram e se uniram a Paulo e Silas, juntamente com muitos seguidores que falavam grego, além de algumas mulheres importantes da cidade. ");
INSERT INTO porblt_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Mas, os judeus ficaram com inveja e, junto com alguns agitadores que reuniram na praça do mercado, eles formaram um bando. Eles causaram confusão pela cidade e atacaram a casa de Jasão. Eles tentaram encontrar Paulo e Silas, para que pudessem levá-los para o meio da multidão. ");
INSERT INTO porblt_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Como não os encontraram, eles arrastaram Jasão e alguns outros seguidores de Jesus para apresentá-los aos líderes da cidade, gritando: “Estas pessoas são conhecidas por causar problemas, virando o mundo de cabeça para baixo. Agora, eles vieram para cá, ");
INSERT INTO porblt_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","e Jasão os recebeu em sua casa. Todos eles desobedecem às leis do imperador romano, cometendo traição ao dizerem que há outro rei, chamado Jesus.” ");
INSERT INTO porblt_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","As pessoas e os líderes da cidade ficaram muito perturbados ao ouvirem isso. ");
INSERT INTO porblt_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Então, fizeram Jasão e os outros pagarem fiança para serem soltos. ");
INSERT INTO porblt_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Os irmãos fizeram com que Paulo e Silas fossem para Bereia naquela mesma noite. Ao chegarem em Bereia, eles foram para a sinagoga judaica. ");
INSERT INTO porblt_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","As pessoas de lá eram mais bem educadas do que as de Tessalônica e, com isso, elas aceitaram a palavra de Deus com muito interesse. Todos os dias, liam as Sagradas Escrituras, para garantir que o que ouviam era o certo. ");
INSERT INTO porblt_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Assim, muitas delas se tornaram irmãos de fé, juntamente com algumas mulheres e homens gregos de elevada posição social. ");
INSERT INTO porblt_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Mas, quando os judeus em Tessalônica ouviram dizer que Paulo também estava anunciando a palavra de Deus em Bereia, eles foram para lá e incitaram o povo contra eles. ");
INSERT INTO porblt_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Imediatamente, os seguidores enviaram Paulo para o litoral, enquanto Silas e Timóteo ficaram em Bereia. ");
INSERT INTO porblt_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Os que estavam acompanhando Paulo levaram-no para Atenas. Depois, retornaram para Bereia, com orientações de Paulo para Silas e Timóteo se unirem a ele o mais depressa possível. ");
INSERT INTO porblt_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Enquanto Paulo estava esperando pelos seus companheiros em Atenas, ele ficou muito perturbado por ver tantos ídolos serem adorados na cidade. ");
INSERT INTO porblt_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ele falou na sinagoga com os judeus e com não-judeus que louvavam a Deus, assim como na praça do mercado com as pessoas que ele encontrava diariamente. ");
INSERT INTO porblt_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Alguns filósofos epicureus e estoicos também discutiam com ele. Eles perguntavam: “Sobre o que ele está falando?” Outros concluíam: “Ele parece estar ensinando sobre alguns deuses estrangeiros.” Diziam isso porque Paulo estava falando sobre Jesus e sobre a ressurreição. ");
INSERT INTO porblt_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Então, eles o levaram ao Areópago e lhe disseram: “Por favor, diga para nós sobre estes novos ensinamentos que você está promovendo. ");
INSERT INTO porblt_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nós ouvimos você falar a respeito de coisas que não conhecemos. Então, gostaríamos de tentar entendê-las.” ");
INSERT INTO porblt_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Todos os atenienses, incluindo os estrangeiros que moravam lá, gostavam de passar o tempo contando e ouvindo as últimas novidades.) ");
INSERT INTO porblt_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulo ficou em pé no meio do Areópago e disse: “Povo de Atenas! Observei que vocês são muito religiosos. ");
INSERT INTO porblt_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Andando pela cidade, observando os seus santuários, encontrei um altar em que está escrito: ‘Ao Deus Desconhecido.’ Este Deus desconhecido, a quem vocês adoram sem conhecer, é aquele que estou anunciando a vocês. ");
INSERT INTO porblt_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","O Deus que criou o mundo e tudo que há nele; o Senhor do céu e da terra, que não vive em templos feitos por mãos de seres humanos. ");
INSERT INTO porblt_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ele não precisa ser servido por nós, como se precisasse de algo, pois ele é a fonte de toda a vida para cada ser vivo. ");
INSERT INTO porblt_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","A partir de um só homem, ele criou todos os povos que vivem na terra e decidiu previamente quando e onde eles deveriam viver. ");
INSERT INTO porblt_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","O propósito de Deus era que todos o buscassem e, talvez, conseguissem encontrá-lo, embora ele não esteja longe de qualquer um de nós. ");
INSERT INTO porblt_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Nele nós vivemos, nos movemos e existimos. Exatamente como um dos seus poetas escreveu: ‘Nós somos seus filhos.’ ");
INSERT INTO porblt_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","E, já que somos seus filhos, nós não deveríamos pensar que Deus é como ídolos de ouro, de prata ou de pedra, que são moldados pelo talento e pela imaginação do ser humano. ");
INSERT INTO porblt_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Deus não levou em conta a ignorância humana no passado, mas agora ele ordena que todos, em qualquer lugar, se arrependam dos seus pecados. ");
INSERT INTO porblt_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Pois ele determinou um dia em que irá julgar o mundo com justiça, por meio do homem que ele escolheu. E ele provou para todos quem é o escolhido, ao ressuscitá-lo dos mortos.” ");
INSERT INTO porblt_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Alguns deles riram ao ouvirem sobre a ressurreição dos mortos, enquanto outros disseram: “Por favor, volte mais tarde para que possamos ouvir mais a respeito disso.” ");
INSERT INTO porblt_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Então, Paulo os deixou. ");
INSERT INTO porblt_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Alguns poucos homens se juntaram a ele e creram em Deus, incluindo Dionísio, um membro do Areópago, e também uma mulher, chamada Dâmaris, e algumas outras pessoas. ");
INSERT INTO porblt_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Depois, Paulo saiu de Atenas e foi para a cidade de Corinto, ");
INSERT INTO porblt_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","onde ele encontrou um judeu, chamado Áquila, que era natural da província do Ponto. Ele havia chegado há pouco da Itália com a sua esposa, Priscila, pois Cláudio tinha ordenado que todos os judeus saíssem de Roma. Paulo foi vê-los ");
INSERT INTO porblt_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","e, por eles também serem fabricantes de tendas, como Paulo, ele ficou com eles. ");
INSERT INTO porblt_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Paulo ensinava na sinagoga todos os sábados e convencia tanto os judeus quanto os gregos. ");
INSERT INTO porblt_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Quando Silas e Timóteo chegaram, vindos da Macedônia, Paulo passou a empregar todo o seu tempo para anunciar a mensagem, dizendo aos judeus que Jesus é o Messias. ");
INSERT INTO porblt_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Quando eles ficaram contra ele e o insultaram, ele sacudiu as suas roupas e lhes disse: “O sangue de vocês está em suas próprias mãos! Eu sou inocente de qualquer culpa e, a partir de agora, irei anunciar a palavra aos não-judeus.” ");
INSERT INTO porblt_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ele saiu e foi morar na casa de Tício Justo, um não-judeu, que adorava a Deus e que morava ao lado da sinagoga. ");
INSERT INTO porblt_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispo, líder da sinagoga, acreditou no Senhor Jesus, assim como todos que moravam em sua casa. Muitas pessoas de Corinto ouviram a mensagem, creram e foram batizadas. ");
INSERT INTO porblt_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Paulo teve uma visão durante a noite, na qual o Senhor lhe dizia: “Não tenha medo! Continue falando e não se cale. ");
INSERT INTO porblt_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Pois estou com você, e ninguém irá lhe fazer nenhum mal, porque muitas pessoas nesta cidade são minhas.” ");
INSERT INTO porblt_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paulo permaneceu lá por um ano e seis meses, anunciando às pessoas a palavra de Deus. ");
INSERT INTO porblt_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","No entanto, durante a época em que Gálio foi governador da província da Acaia, os judeus se uniram em um ataque contra Paulo e o levaram diante do tribunal. ");
INSERT INTO porblt_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Eles afirmaram: “Este homem está convencendo as pessoas a adorar a Deus de uma maneira que é contra nossa lei.” ");
INSERT INTO porblt_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Mas, quando Paulo ia começar a se defender, Gálio disse aos judeus: “Judeus, se vocês apresentassem acusações criminais ou alguma ofensa séria, haveria alguma razão para que eu lhes escutasse. ");
INSERT INTO porblt_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mas, já que vocês estão apenas discutindo por causa de palavras, nomes e questões de sua própria lei, então, lidem com isso vocês mesmos. Eu não irei julgar tais assuntos.” ");
INSERT INTO porblt_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Então, Gálio os expulsou do tribunal. ");
INSERT INTO porblt_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Então, a multidão se virou contra Sóstenes, o líder da sinagoga, e bateu nele do lado de fora do tribunal, mas Gálio pouco se importou com isso. ");
INSERT INTO porblt_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo ficou em Corinto por algum tempo. Depois, ele deixou os irmãos e, de barco, foi para a Síria, levando com ele Priscila e Áquila. Ele tinha raspado a cabeça em Cencreia, pois tinha feito um voto. ");
INSERT INTO porblt_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Eles chegaram na cidade de Éfeso, onde Priscila e Áquila decidiram ficar. Ele foi para a sinagoga para conversar com os judeus. ");
INSERT INTO porblt_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Eles lhe pediram para ficar por mais tempo, mas ele se recusou. ");
INSERT INTO porblt_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ele se despediu e partiu de Éfeso, dizendo a eles: “Eu voltarei e os verei, se for a vontade de Deus.” ");
INSERT INTO porblt_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Após desembarcar em Cesareia, ele foi à Jerusalém, onde cumprimentou os membros da igreja e, depois, prosseguiu para Antioquia. ");
INSERT INTO porblt_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ele passou algum tempo lá e, depois, partiu em viagem por toda a região da Galácia e da Frígia, encorajando todos os irmãos de fé. ");
INSERT INTO porblt_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nesse meio tempo, um judeu, chamado Apolo, vindo da Alexandria, chegou em Éfeso. Ele falava muito bem e era profundo conhecedor das Sagradas Escrituras. ");
INSERT INTO porblt_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ele também era instruído no caminho do Senhor. Apolo falava com grande entusiasmo, apresentando Jesus de forma precisa quando falava e ensinava. Mas, ele conhecia apenas o batismo de João. ");
INSERT INTO porblt_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ele começou a falar abertamente na sinagoga. Então, quando Priscila e Áquila o ouviram, eles o convidaram para se unir a eles e lhe explicaram mais profundamente o caminho de Deus. ");
INSERT INTO porblt_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Quando ele decidiu partir para Acaia, os irmãos o animaram e escreveram para os discípulos de lá, pedindo para que o recebessem bem. Ao chegar lá, Apolo ajudou muito as pessoas que, pela graça de Deus, haviam crido. ");
INSERT INTO porblt_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Pois ele era capaz de, com fortes argumentos, contestar os judeus publicamente, demonstrando, pelas Sagradas Escrituras, que Jesus é o Messias. ");
INSERT INTO porblt_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Enquanto Apolo estava em Corinto, Paulo viajou pelo interior e chegou em Éfeso, onde encontrou alguns cristãos. ");
INSERT INTO porblt_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Paulo lhes perguntou: “Vocês receberam o Espírito Santo quando creram?” E eles lhe responderam: “Não, nós nem sabíamos que existe o Espírito Santo.” ");
INSERT INTO porblt_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Então Paulo lhes perguntou: “Qual batismo vocês receberam?” Eles responderam: “O batismo de João.” ");
INSERT INTO porblt_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Disse-lhes Paulo: “João batizou com o batismo do arrependimento. Ele disse para as pessoas que elas deveriam crer naquele que viria depois dele, ou seja, elas deveriam crer em Jesus.” ");
INSERT INTO porblt_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ao ouvirem isso, aqueles cristãos de Éfeso foram batizados em nome do Senhor Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Depois, Paulo colocou suas mãos sobre eles. Então, o Espírito Santo desceu sobre eles e começaram a falar em línguas diferentes e a fazer profecias. ");
INSERT INTO porblt_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ao todo havia cerca de doze homens lá. ");
INSERT INTO porblt_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo foi para a sinagoga e durante três meses falou com coragem ao povo. Ele conversava com eles e tentava convencê-los a respeito do Reino de Deus. ");
INSERT INTO porblt_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mas, alguns deles eram teimosos e se recusavam a crer. Eles falavam mal do Caminho para as outras pessoas. Então, Paulo desistiu deles e saiu da sinagoga, levando com ele os que criam. Ele passou a debater diariamente na escola de Tirano. ");
INSERT INTO porblt_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ele fez isso por dois anos, resultando em que todos os que moravam na província da Ásia, tanto judeus quanto gregos, ouvissem a palavra do Senhor. ");
INSERT INTO porblt_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Deus realizava milagres extraordinários por intermédio de Paulo, ");
INSERT INTO porblt_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","tanto que as pessoas pegavam lenços ou aventais que ele tinha tocado, para curar doentes e para expulsar espíritos malignos. ");
INSERT INTO porblt_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Alguns judeus, que andavam expulsando espíritos maus, decidiram usar o nome do Senhor Jesus para fazer isso. Eles diziam: “Eu ordeno que vocês saiam em nome de Jesus, o mesmo que Paulo anuncia.” ");
INSERT INTO porblt_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Os homens que faziam isso eram sete filhos de Ceva, um dos chefes dos sacerdotes judeus. ");
INSERT INTO porblt_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Mas um dia, um espírito maligno disse a eles: “Eu conheço Jesus e Paulo, mas quem são vocês?” ");
INSERT INTO porblt_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","O homem possuído pelo demônio pulou sobre eles e os dominou. Ele os atacou com tanta violência que eles saíram correndo da casa, nus e muito machucados. ");
INSERT INTO porblt_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","A população de Éfeso, tanto os judeus quanto os gregos ouviram a respeito disso. Eles ficaram espantados com o que havia acontecido, e o nome do Senhor Jesus se tornou ainda mais respeitado. ");
INSERT INTO porblt_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Muitos vieram a crer no Senhor e a confessar seus pecados, admitindo abertamente as coisas más que praticavam. ");
INSERT INTO porblt_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Várias pessoas, que costumavam praticar feitiçaria, pegaram seus livros de magia e os trouxeram para queimá-los diante de todos. Eles calcularam o valor dos livros que foram queimados, e o total foi de cinquenta mil moedas de prata. ");
INSERT INTO porblt_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Dessa maneira, a palavra do Senhor se fortaleceu e se espalhou amplamente. ");
INSERT INTO porblt_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Algum tempo depois, Paulo decidiu ir para Jerusalém, passando primeiro pela Macedônia e por Acaia. Ele disse: “Depois que eu for a Jerusalém, precisarei ir também a Roma.” ");
INSERT INTO porblt_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ele enviou dois dos seus auxiliares, Timóteo e Erasto, para a Macedônia, enquanto ele ainda ficou por mais algum tempo na província da Ásia. ");
INSERT INTO porblt_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Foi próximo dessa época que ocorreram sérios problemas em relação ao Caminho. ");
INSERT INTO porblt_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Um artesão, que trabalhava com prata, chamado Demétrio, estava produzindo pequenas cópias em prata do templo da deusa Diana. Esse comércio trazia muito lucro aos artesãos. ");
INSERT INTO porblt_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demétrio os reuniu, juntamente com outros que trabalhavam com comércios semelhantes e disse: “Amigos, vocês sabem que é por causa desse comércio que ganhamos nosso dinheiro. ");
INSERT INTO porblt_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","E tenho certeza de que vocês têm visto e ouvido, não apenas aqui em Éfeso, mas praticamente em toda a Ásia, esse tal de Paulo, convencendo e enganando muitas pessoas. Ele lhes diz que deuses feitos por mãos humanas não são deuses. ");
INSERT INTO porblt_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Não se trata apenas de uma questão do nosso negócio estar em perigo de perder o respeito que sempre teve, mas de o templo da grande deusa Diana ser considerado sem valor. A própria Diana seria destronada de sua alta posição como aquela a quem todos na Ásia e em todo o mundo veneram.” ");
INSERT INTO porblt_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ao ouvirem isso, eles ficaram furiosos e gritaram: “Viva a grande deusa Diana dos efésios!” ");
INSERT INTO porblt_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","A cidade virou um completo caos. As pessoas correram para o anfiteatro, arrastando com elas Gaio e Aristarco, os companheiros de viagem de Paulo, vindos da Macedônia. ");
INSERT INTO porblt_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo achava que deveria enfrentar a multidão, mas os irmãos não o deixaram ir. ");
INSERT INTO porblt_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Alguns dos altos funcionários da província, que eram amigos de Paulo, também enviaram uma mensagem, implorando para que ele não fosse ao anfiteatro. ");
INSERT INTO porblt_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Algumas pessoas gritavam uma coisa, e outras gritavam outra, pois a multidão lá reunida estava em total confusão, sendo que muitos deles não faziam ideia do motivo de estarem lá. ");
INSERT INTO porblt_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Os judeus na multidão empurraram Alexandre para a frente. Alexandre fez um sinal com a mão para que todos ficassem calados, pois queria explicar o que estava acontecendo para as pessoas. ");
INSERT INTO porblt_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mas, quando a multidão percebeu que ele era judeu, todos gritaram juntos por cerca de duas horas: “Viva a grande deusa Diana dos efésios!” ");
INSERT INTO porblt_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Depois que o secretário municipal conseguiu fazer a multidão se acalmar, ele lhes disse: “Povo de Éfeso, quem não sabe que a nossa cidade é a guardiã do templo da grande Diana e de sua imagem que veio do céu? ");
INSERT INTO porblt_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Já que tais fatos não podem ser negados, vocês devem se acalmar. Não se precipitem. ");
INSERT INTO porblt_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Vocês trouxeram esses homens aqui, mas eles não roubaram um templo e nem disseram blasfêmias contra a nossa deusa. ");
INSERT INTO porblt_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Então, se Demétrio e os outros artesãos têm alguma queixa contra alguém, que procurem as autoridades e os tribunais. Eles podem apresentar suas queixas lá. ");
INSERT INTO porblt_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Se há mais alguma coisa, então, isso deve ser decidido em assembleia. ");
INSERT INTO porblt_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Na verdade, nós mesmos corremos perigo de sermos acusados de revolta, por causa do tumulto de hoje, já que não houve motivo para isso. E, além disso, nem podemos justificar o porquê disso acontecer.” ");
INSERT INTO porblt_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Quando ele terminou de falar, a multidão se dispersou. ");
INSERT INTO porblt_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Logo que tudo se acalmou, Paulo reuniu os irmãos e conversou com eles para animá-los. Depois, ele se despediu e foi para a Macedônia. ");
INSERT INTO porblt_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ele viajou por aquela região, compartilhando muitas palavras de encorajamento com as pessoas que criam e, então, viajou para a Grécia. ");
INSERT INTO porblt_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Após ter ficado uma temporada de três meses lá e, exatamente quando estava próximo de sua viagem para a Síria, soube que os judeus estavam tramando contra ele. Assim, ele decidiu voltar pela Macedônia. ");
INSERT INTO porblt_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ele teve como companheiros de viagem as seguintes pessoas: Sópatro, da cidade de Bereia, filho de Pirro, Aristarco e Segundo, de Tessalônica, Gaio de Derbe, Timóteo, Tíquico e Trófimo, da província da Ásia. ");
INSERT INTO porblt_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Eles seguiram na frente e esperaram por nós na cidade de Trôade. ");
INSERT INTO porblt_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Depois da Festa dos Pães sem Fermento, nós saímos de barco da cidade de Filipos e os encontramos cinco dias depois em Trôade, onde ficamos por uma semana. ");
INSERT INTO porblt_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Era o primeiro dia da semana, e nós nos reunimos para partir o pão, enquanto Paulo falava para o povo. Ele estava planejando sair na manhã seguinte e, assim, continuou a falar até à meia-noite. ");
INSERT INTO porblt_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","(O salão no andar superior, onde estávamos reunidos era iluminado por vários lampiões.) ");
INSERT INTO porblt_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Um jovem, chamado Êutico, estava sentado na janela e começou a se sentir muito sonolento. Enquanto Paulo continuava a falar, Êutico dormiu e caiu do terceiro andar. Quando eles o levantaram do chão, ele estava morto. ");
INSERT INTO porblt_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulo desceu, inclinou-se sobre o corpo do rapaz e o abraçou. Paulo disse: “Não se preocupem! Ele está vivo.” ");
INSERT INTO porblt_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Paulo subiu novamente para o salão, partiu o pão e o comeu junto com os outros que lá estavam. Ele continuou a conversar com eles até de madrugada e, depois, foi embora. ");
INSERT INTO porblt_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Eles levaram o jovem Êutico para casa vivo e bem e ficaram muito agradecidos por isso. ");
INSERT INTO porblt_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nós fomos na frente e embarcamos para o porto de Assôs. Chegando lá, deveríamos esperar por Paulo, que tinha decidido viajar a pé. ");
INSERT INTO porblt_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","E ele, de fato, nos encontrou em Assôs. Ele embarcou, e todos fomos para a cidade de Mitilene. ");
INSERT INTO porblt_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Partindo dali, chegamos à ilha de Quios e, no dia seguinte, paramos por pouco tempo na ilha de Samos e, no dia seguinte, chegamos ao porto de Mileto. ");
INSERT INTO porblt_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo tinha planejado não parar em Éfeso, pois não queria se demorar na província da Ásia. Ele estava ansioso para chegar em Jerusalém a tempo do Dia de Pentecostes. ");
INSERT INTO porblt_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","De Mileto, Paulo enviou uma mensagem aos presbíteros da igreja de Éfeso. ");
INSERT INTO porblt_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Quando eles chegaram, Paulo lhes disse: “Vocês sabem como eu sempre me comportei enquanto estive com vocês, desde o primeiro dia em que eu cheguei na província da Ásia. ");
INSERT INTO porblt_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Eu servi ao Senhor com humildade e lágrimas. Eu suportei os problemas e a tensão causados pelas conspirações dos judeus contra mim. ");
INSERT INTO porblt_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","No entanto, eu nunca deixei de ajudar vocês e de ensinar em público e também de casa em casa. ");
INSERT INTO porblt_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Eu disse, tanto aos judeus quanto aos gregos, que deviam se arrepender, buscar a Deus e terem fé em nosso Senhor Jesus Cristo. ");
INSERT INTO porblt_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Agora, obedecendo ao Espírito, vou para Jerusalém, não sabendo o que irá acontecer comigo lá. ");
INSERT INTO porblt_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Tudo o que sei é que, em toda a cidade que visito, o Espírito Santo me avisa que tanto a prisão quanto o sofrimento me acompanharão. ");
INSERT INTO porblt_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Mas, não considero que a minha vida tenha um valor assim tão grande para mim. Pois, eu apenas quero completar a minha missão e o trabalho que o Senhor Jesus me deu de anunciar as boas novas da graça de Deus. ");
INSERT INTO porblt_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Agora, eu tenho certeza de uma coisa: de que vocês, para quem eu anunciei o Reino de Deus, não me verão novamente. ");
INSERT INTO porblt_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Assim, declaro a vocês, hoje, que eu não sou responsável caso alguém se perca. ");
INSERT INTO porblt_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Eu não hesitei em contar a vocês tudo o que Deus queria que soubessem. ");
INSERT INTO porblt_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Cuidem-se e cuidem também de todo o rebanho que o Espírito Santo lhes deu para que o acompanhem e o guardem. Cuidem da igreja de Deus, a qual ele comprou com o sangue do seu próprio Filho. ");
INSERT INTO porblt_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Eu sei que, depois que eu for embora, lobos ferozes chegarão para atacá-los e irão espalhar o rebanho. ");
INSERT INTO porblt_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Surgirão, dentro do seu próprio grupo, homens que irão torcer o que é certo e bom para conseguirem seguidores para eles mesmos. ");
INSERT INTO porblt_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Então, cuidado! Não se esqueçam de que, por três anos, eu os ensinei por dias e noites, derramando lágrimas por vocês. ");
INSERT INTO porblt_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Agora, eu os deixo aos cuidados de Deus e com a mensagem de sua graça, ele que é capaz de fortalecê-los e de lhes dar a herança que pertence a todos os que se mantêm firmes com ele. ");
INSERT INTO porblt_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Eu nunca desejei a prata, o ouro ou as roupas de ninguém. ");
INSERT INTO porblt_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Vocês sabem que eu trabalhei com minhas próprias mãos para suprir tudo o que eu e os que me acompanhavam precisávamos. ");
INSERT INTO porblt_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Em tudo o que fiz, mostrei-lhes que devemos trabalhar para ajudar os mais fracos, sempre nos lembrando das palavras do Senhor Jesus: ‘Há mais felicidade em dar do que em receber.’” ");
INSERT INTO porblt_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Quando ele acabou de falar, ajoelhou-se e orou com todos eles. ");
INSERT INTO porblt_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Eles todos choraram ao abraçá-lo e beijá-lo. ");
INSERT INTO porblt_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","O que mais os entristeceu foi ele ter dito que eles nunca mais o veriam de novo. Então, eles o acompanharam até o navio. ");
INSERT INTO porblt_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Depois que nos despedimos deles, navegamos diretamente para a ilha de Cós e, no dia seguinte, para o porto de Rodes. Dali chegamos em Pátara, ");
INSERT INTO porblt_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","onde encontramos um navio que ia para a Fenícia. Nós subimos a bordo e partimos. ");
INSERT INTO porblt_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Avistamos a ilha de Chipre a nossa esquerda e continuamos navegando na direção da Síria e chegamos à cidade de Tiro, onde o navio foi descarregado. ");
INSERT INTO porblt_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Encontramos irmãos e ficamos com eles por uma semana. Os irmãos, orientados pelo Espírito Santo, disseram a Paulo que não fosse para Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Quando chegou a hora, nós saímos e voltamos para o barco, para continuar nossa jornada. Todos os irmãos, suas esposas e filhos nos acompanharam, enquanto deixávamos a cidade. Ajoelhamo-nos na praia, oramos e nos despedimos deles. ");
INSERT INTO porblt_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Então, entramos no barco, e eles voltaram para suas casas. ");
INSERT INTO porblt_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nossa viagem de Tiro acabou em Ptolemaida. Ao desembarcar nessa cidade, cumprimentamos os irmãos e ficamos com eles por um dia. ");
INSERT INTO porblt_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","No dia seguinte, fomos embora e chegamos à cidade de Cesareia. Lá, ficamos na casa de Filipe, o evangelista (um dos Sete). ");
INSERT INTO porblt_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filipe tinha quatro filhas solteiras, que profetizavam. ");
INSERT INTO porblt_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Depois de vários dias que estávamos lá, apareceu um profeta, chamado Ágabo, que tinha vindo da Judeia. ");
INSERT INTO porblt_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ele se aproximou de nós, pegou o cinto de Paulo e amarrou as próprias mãos e os próprios pés. Depois, ele disse: “O Espírito Santo diz: ‘É assim que os judeus de Jerusalém amarrarão o homem a quem esse cinto pertence e eles o entregarão aos não-judeus.’” ");
INSERT INTO porblt_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ao ouvir isso, nós e os irmãos de fé imploramos para que Paulo não fosse para Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Mas, Paulo respondeu: “O que vocês estão fazendo? Chorando assim só deixam o meu coração mais triste. Eu estou pronto não apenas para ser amarrado, mas até para morrer em Jerusalém pelo nome do Senhor Jesus.” ");
INSERT INTO porblt_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Vendo que não conseguíamos fazê-lo mudar de ideia, nós desistimos e lhe dissemos: “Que seja feita a vontade do Senhor!” ");
INSERT INTO porblt_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Depois, nós arrumamos as nossas coisas e fomos para Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Alguns dos irmãos de Cesareia vieram conosco e nos levaram até a casa de Menasom, onde iríamos ficar hospedados. Menasom era da ilha de Chipre e foi um dos primeiros a crer em Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ao chegarmos em Jerusalém, os irmãos de lá nos receberam muito bem. ");
INSERT INTO porblt_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","No dia seguinte, Paulo nos acompanhou em uma visita a Tiago, que estava com todos os líderes da igreja. ");
INSERT INTO porblt_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Depois de cumprimentá-los, Paulo falou em detalhes sobre tudo o que Deus tinha feito pelos não-judeus, por meio do seu trabalho. ");
INSERT INTO porblt_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Depois de ouvirem, eles oraram a Deus e disseram a Paulo: “Irmão, como vê, milhares de judeus vieram a crer no Senhor, e eles cumprem fielmente a Lei de Moisés. ");
INSERT INTO porblt_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Eles foram informados de que você ensina os judeus que vivem entre os não-judeus a ignorarem a Lei. Que você diz a eles para não circuncidarem os seus filhos e para não seguirem os nossos costumes. ");
INSERT INTO porblt_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Então, o que faremos a respeito disso? As pessoas certamente saberão que você está aqui. ");
INSERT INTO porblt_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nós queremos que você faça o seguinte: Quatro homens que estão entre nós fizeram um voto. ");
INSERT INTO porblt_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Vá, faça os rituais de purificação com eles e pague a despesa para que eles possam rapar a cabeça. Assim, todos saberão que não há verdade nos rumores que eles ouviram sobre você e também verão que você vive de acordo com a Lei. ");
INSERT INTO porblt_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Quanto aos não-judeus que creem no Senhor, nós já escrevemos uma carta com a nossa decisão para que eles evitem comer animais sacrificados aos ídolos, consumir sangue, comer qualquer animal que tenha sido estrangulado e evitar a imoralidade sexual.” ");
INSERT INTO porblt_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Então, Paulo levou os homens com ele e, no dia seguinte, ele os acompanhou nos rituais de purificação. Depois eles foram ao Templo, para acertar sobre o cumprimento dos dias da purificação e sobre a oferta que cada um deles faria. ");
INSERT INTO porblt_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Os sete dias de purificação já tinham quase acabado, quando alguns judeus, vindos da Ásia, viram Paulo no Templo e instigaram a multidão contra ele, prendendo-o. ");
INSERT INTO porblt_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Eles gritaram; “Povo de Israel, ajudem! Este é o homem que está ensinando a todos, em todos os lugares, a se voltarem contra o nosso povo, contra a Lei e o Templo. Ele até mesmo trouxe gregos para dentro do Templo, profanando este lugar sagrado.” ");
INSERT INTO porblt_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Eles disseram isso, porque tinham-no visto junto com Trófimo, de Éfeso, na cidade tempos antes, e presumiram que Paulo o havia levado até o Templo.) ");
INSERT INTO porblt_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Toda a cidade ficou chocada com isso e as pessoas vieram correndo para o Templo. Eles agarraram Paulo e o jogaram para fora do Templo. Imediatamente, as portas foram fechadas. ");
INSERT INTO porblt_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Como eles estavam tentando matá-lo, chegou a notícia ao comandante da tropa romana de que havia tumulto por toda a cidade de Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","O comandante, sem demora, levou alguns oficiais e soldados e correram para onde estava a multidão. Quando as pessoas viram o comandante e os soldados, pararam de bater em Paulo. ");
INSERT INTO porblt_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Então, o comandante prendeu Paulo e ordenou que ele fosse acorrentado com duas correntes. Ele perguntou quem ele era e o que ele tinha feito. ");
INSERT INTO porblt_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Algumas pessoas na multidão gritavam uma coisa e outras gritavam outra completamente diferente. Como o comandante não conseguia descobrir a verdade por causa de todo o barulho e toda a confusão, ele ordenou que Paulo fosse levado para a fortaleza. ");
INSERT INTO porblt_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Quando Paulo chegou às escadas, ele precisou ser carregado pelos soldados, pois a multidão estava muito violenta. ");
INSERT INTO porblt_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","As pessoas gritavam: “Acabem com ele!” ");
INSERT INTO porblt_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Quando faltava pouco para ele ser levado para dentro da fortaleza, Paulo perguntou ao comandante: “Eu posso lhe dizer uma coisa?” E o comandante lhe perguntou: “Você sabe grego? ");
INSERT INTO porblt_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Você não é o egípcio que, recentemente, incitou uma rebelião e levou quatro mil assassinos para o deserto?” ");
INSERT INTO porblt_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo respondeu: “Eu sou judeu de uma importante cidade, chamada Tarso, na Cilícia. Por favor, deixe-me falar com as pessoas.” ");
INSERT INTO porblt_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","O comandante permitiu que Paulo falasse. Então, ele ficou em pé nas escadas e pediu silêncio. Quando ficaram quietos, ele falou com eles em aramaico. ");
INSERT INTO porblt_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Ele disse: “Irmãos e pais, por favor, ouçam enquanto eu me defendo diante de vocês.” ");
INSERT INTO porblt_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Quando eles o ouviram falando em aramaico ficaram quietos. ");
INSERT INTO porblt_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Ele começou: “Eu sou um judeu nascido em Tarso, na Cilícia. Entretanto, fui trazido aqui para esta cidade e fui aluno de Gamaliel. Fui educado para seguir rigorosamente a lei dos nossos antepassados. Eu era muito dedicado a Deus, exatamente como todos vocês que estão aqui hoje, ");
INSERT INTO porblt_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","e perseguia as pessoas deste Caminho. Alguns condenei à morte e outros, tanto homens quanto mulheres, mandei prender. ");
INSERT INTO porblt_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Como o grande sacerdote e o conselho dos anciãos do povo também podem atestar, eu recebi deles cartas de autorização para os irmãos judeus em Damasco. E fui lá para prender essas pessoas e trazê-las como prisioneiras para Jerusalém, a fim de que fossem punidas. ");
INSERT INTO porblt_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Por volta do meio-dia, enquanto eu estava indo pela estrada, já me aproximando de Damasco, uma luz brilhante vinda do céu, de repente, brilhou em volta de mim. ");
INSERT INTO porblt_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Eu caí no chão e ouvi uma voz que disse: ‘Saulo, Saulo, por que você está me perseguindo?’ ");
INSERT INTO porblt_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Eu respondi: ‘Quem é o Senhor?’ E a voz disse: ‘Eu sou Jesus de Nazaré, aquele a quem você persegue.’ ");
INSERT INTO porblt_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","As pessoas que viajavam comigo também viram a luz, mas não entenderam o sentido da voz que falava comigo. ");
INSERT INTO porblt_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Eu perguntei: ‘O que eu devo fazer, Senhor?’ O Senhor me disse: ‘Levante-se e vá para Damasco! Lá, alguém lhe dirá tudo o que você precisa fazer.’ ");
INSERT INTO porblt_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Como eu não conseguia enxergar, por causa da claridade da luz, os que me acompanhavam me levaram pela mão até Damasco. ");
INSERT INTO porblt_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Lá, um homem chamado Ananias, veio me ver. Ele era um homem que temia a Deus, que seguia a lei e era muito respeitado pelos judeus que moravam em Damasco. ");
INSERT INTO porblt_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananias ficou em minha frente e disse: ‘Irmão Saulo, volte a enxergar!’ E, naquele momento, eu pude enxergar novamente e, então, olhei para ele. ");
INSERT INTO porblt_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ele me disse: ‘O Deus dos nossos antepassados o escolheu para que você saiba a vontade dele, para que veja o único que é verdadeiramente bom e justo e para ouvir o que ele tem para lhe dizer. ");
INSERT INTO porblt_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Você será testemunha dele para dizer a todas as pessoas o que tem visto e ouvido. Então, o que você está esperando? ");
INSERT INTO porblt_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Levante-se, peça misericórdia ao Senhor, seja batizado e livre-se dos seus pecados.’ ");
INSERT INTO porblt_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Eu voltei para Jerusalém e, quando estava orando no Templo, entrei em transe. ");
INSERT INTO porblt_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Tive uma visão do Senhor me dizendo: ‘Rápido! Você precisa deixar Jerusalém imediatamente, pois eles não irão aceitar o que você está dizendo a meu respeito.’ ");
INSERT INTO porblt_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Eu respondi: ‘Senhor, eles, com certeza, sabem que eu ia de sinagoga em sinagoga, batendo e aprisionando os que confiavam no Senhor. ");
INSERT INTO porblt_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Quando Estêvão foi morto, por testemunhar sobre você, eu estava lá, totalmente de acordo com aqueles que o mataram, segurando as capas deles.’ ");
INSERT INTO porblt_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","O Senhor me disse: ‘Saia agora! Pois eu o estou enviando para muito longe, para os não-judeus.’” ");
INSERT INTO porblt_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Até este momento, eles ouviam o que Paulo tinha a dizer, mas, então, começaram a gritar: “Sumam com este homem da face da terra! Ele não merece viver!” ");
INSERT INTO porblt_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Eles gritavam, tiravam suas capas e jogavam poeira no ar. ");
INSERT INTO porblt_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","O comandante ordenou que Paulo fosse trazido para a fortaleza e também deu ordem para que ele fosse chicoteado, a fim de que falasse o motivo das pessoas estarem gritando tanto contra ele. ");
INSERT INTO porblt_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Quando os soldados o estavam amarrando para chicoteá-lo, Paulo perguntou ao oficial que se encontrava lá: “É lícito chicotear um cidadão romano sem um julgamento?” ");
INSERT INTO porblt_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Quando o oficial ouviu o que Paulo havia dito, ele foi até o comandante e lhe perguntou: “O que você está fazendo? Esse homem é um cidadão romano.” ");
INSERT INTO porblt_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","O comandante veio e perguntou a Paulo: “Diga-me, você é um cidadão romano?” Paulo respondeu: “Sim, eu sou!” ");
INSERT INTO porblt_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","E o comandante disse: “Eu paguei muito dinheiro para me tornar um cidadão romano.” “Mas, eu nasci um cidadão romano”, Paulo respondeu. ");
INSERT INTO porblt_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Os soldados que estavam preparados para chicotear Paulo saíram imediatamente. O comandante ficou preocupado ao descobrir que Paulo era um cidadão romano e que ele o tinha acorrentado. ");
INSERT INTO porblt_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","No dia seguinte, querendo encontrar o motivo dos judeus estarem acusando Paulo, ele o soltou e ordenou que os chefes dos sacerdotes e todo o conselho se reunisse, para que ele levasse Paulo diante deles. Então, ele trouxe Paulo e o apresentou a eles. ");
INSERT INTO porblt_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo olhou diretamente para o conselho e disse: “Irmãos, até agora, eu me apresento a Deus com a consciência tranquila.” ");
INSERT INTO porblt_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananias, o grande sacerdote, ordenou que os guardas que estavam ao lado de Paulo batessem em sua boca. ");
INSERT INTO porblt_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulo lhe disse: “Deus o castigará, seu hipócrita! Você está sentado aí para me julgar de acordo com a lei e, ao ordenar que os guardas me batam, você está violando a lei!” ");
INSERT INTO porblt_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Os guardas que estavam próximos a Paulo disseram: “Como ousa insultar o grande sacerdote?” ");
INSERT INTO porblt_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo respondeu: “Irmãos, eu não sabia que ele era o grande sacerdote. Como as Sagradas Escrituras dizem: ‘Você não deve falar mal de qualquer governante do seu povo.’” ");
INSERT INTO porblt_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Quando Paulo percebeu que alguns membros do conselho eram saduceus e que outros eram fariseus, ele gritou: “Irmãos, eu sou fariseu e filho de fariseu! Eu estou sendo julgado por acreditar na ressurreição dos mortos!” ");
INSERT INTO porblt_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Quando ele disse isso, uma grande discussão aconteceu entre os fariseus e os saduceus, dividindo assim o conselho. ");
INSERT INTO porblt_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Os saduceus dizem que não há ressurreição dos mortos, nem anjos e nem espíritos; mas os fariseus acreditam em tudo isso.) ");
INSERT INTO porblt_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Uma grande confusão começou e alguns dos mestres da lei fariseus se levantaram e protestaram, dizendo; “Nós consideramos que este homem é inocente! Talvez um espírito ou um anjo tenha falado com ele.” ");
INSERT INTO porblt_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","A discussão estava saindo do controle, então, o comandante, com medo de Paulo ser despedaçado por eles, ordenou aos soldados para que tirassem Paulo de lá e o levassem novamente para a fortaleza. ");
INSERT INTO porblt_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Mais tarde, durante a noite, o Senhor esteve com Paulo e lhe disse: “Tenha coragem! Da mesma maneira que você falou a meu respeito em Jerusalém, deverá falar a meu respeito em Roma também.” ");
INSERT INTO porblt_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","No dia seguinte, alguns judeus se reuniram e juraram que não comeriam e nem beberiam até que conseguissem matar Paulo. ");
INSERT INTO porblt_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Mais de quarenta judeus faziam parte desse plano. ");
INSERT INTO porblt_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Eles foram até os chefes dos sacerdotes e líderes judeus e disseram: “Nós fizemos um juramento solene de não comer nada enquanto não matarmos Paulo. ");
INSERT INTO porblt_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Então, vocês e o conselho enviem uma mensagem ao comandante, para que ele traga Paulo até aqui para encontrá-los. Digam que querem examinar o caso dele mais detalhadamente. Nós estaremos preparados para matá-lo no meio do caminho.” ");
INSERT INTO porblt_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mas, o sobrinho de Paulo (o filho de sua irmã) ouviu sobre a armadilha que preparavam. Ele entrou na fortaleza e contou a Paulo sobre isso. ");
INSERT INTO porblt_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paulo chamou um dos oficiais e lhe disse: “Leve este jovem ao comandante, pois ele tem informações para ele.” ");
INSERT INTO porblt_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Então, o oficial levou o sobrinho de Paulo até o comandante e lhe disse: “O prisioneiro Paulo me chamou e pediu para que eu trouxesse este jovem até o senhor. Ele tem algo a lhe dizer.” ");
INSERT INTO porblt_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","O comandante levou o jovem para um lado e lhe perguntou: “O que você tem a me dizer?” ");
INSERT INTO porblt_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","O jovem explicou: “Os judeus estão tramando para pedir que o senhor leve Paulo até o conselho amanhã, como se eles quisessem fazer mais perguntas sobre o caso dele. ");
INSERT INTO porblt_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Mas, por favor, não dê ouvidos a eles. Eles planejam fazer uma emboscada contra Paulo com mais de quarenta homens, que juraram não comer e nem beber nada até o matarem. Eles já estão prontos, apenas esperando que o senhor concorde com o pedido.” ");
INSERT INTO porblt_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","O comandante mandou que o jovem fosse embora, mas o aconselhou: “Não diga a ninguém sobre o que você acabou de me contar.” ");
INSERT INTO porblt_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ele chamou dois oficiais e lhes disse: “Preparem duzentos soldados para irem até Cesareia, juntamente com setenta homens da cavalaria e duzentos lanceiros. Estejam prontos para sair às nove da noite. ");
INSERT INTO porblt_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Providenciem cavalos para Paulo montar, para garantir que ele chegue em segurança até o governador Félix.” ");
INSERT INTO porblt_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ele também escreveu uma carta, que dizia assim: ");
INSERT INTO porblt_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“De Cláudio Lísias para o Excelentíssimo Governador Félix, saudações! ");
INSERT INTO porblt_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Este homem foi preso pelos judeus, e eles o estavam quase matando, quando eu cheguei até a cena com soldados e o resgatei. Descobri posteriormente que se tratava de um cidadão romano. ");
INSERT INTO porblt_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Eu queria descobrir o motivo pelo qual os judeus o acusaram, então, o enviei diante do conselho deles. ");
INSERT INTO porblt_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Fiquei sabendo que as acusações contra ele se referem a questões ligadas a sua lei, mas ele não é culpado de algo que mereça pena de morte ou prisão. ");
INSERT INTO porblt_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ao descobrir que havia uma conspiração contra esse homem, eu o enviei ao senhor imediatamente, ordenando que os seus acusadores façam suas queixas diretamente ao senhor.” ");
INSERT INTO porblt_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Assim, os soldados cumpriram as ordens e levaram Paulo durante a noite para a cidade de Antipátride. ");
INSERT INTO porblt_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Na manhã seguinte, eles enviaram Paulo junto com a cavalaria e voltaram para a fortaleza. ");
INSERT INTO porblt_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Quando a cavalaria chegou em Cesareia, os soldados entregaram a carta ao governador e trouxeram Paulo diante dele. ");
INSERT INTO porblt_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Após ler a carta, o governador perguntou a Paulo de qual província ele era. Quando ele soube que ele era da região da Cilícia, disse a Paulo: ");
INSERT INTO porblt_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Eu investigarei o seu caso assim que os seus acusadores chegarem.” Ele ordenou que Paulo ficasse preso no palácio de Herodes. ");
INSERT INTO porblt_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Cinco dias depois, Ananias, o grande sacerdote, chegou com alguns dos líderes judeus e com um advogado, chamado Tértulo. Eles apresentaram queixas formais contra Paulo para o governador. ");
INSERT INTO porblt_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Quando Paulo foi chamado, Tértulo começou a apresentar as acusações contra ele. Ele disse: “Excelentíssimo Senhor Governador Félix, nós desfrutamos um longo período de paz sob o seu governo e, graças ao seu sábio julgamento, foram implementadas reformas que beneficiam a nação. ");
INSERT INTO porblt_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Todos nós, em todo o país, somos muito gratos ao senhor por tudo isso. ");
INSERT INTO porblt_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mas, a fim de não aborrecê-lo, por favor, tenha a gentileza de nos dar a sua atenção por algum tempo. ");
INSERT INTO porblt_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Descobrimos que este homem é uma verdadeira peste, que provoca rebeliões entre os judeus em todo o mundo, e é o líder do partido dos nazarenos. ");
INSERT INTO porblt_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ele tentou profanar o Templo e, por isso, nós o prendemos. ");
INSERT INTO porblt_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ao interrogá-lo, o senhor descobrirá a verdade das nossas acusações.” ");
INSERT INTO porblt_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Os judeus concordaram, dizendo que tudo o que havia sido dito era verdade. ");
INSERT INTO porblt_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","O governador fez sinal para que Paulo respondesse. Paulo começou: “Eu sei que o senhor atua há muito tempo como juiz desta nação e, por isso, me sinto à vontade para fazer a minha defesa. ");
INSERT INTO porblt_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","O senhor pode verificar, facilmente, que eu cheguei em Jerusalém para adorar a Deus há apenas doze dias. ");
INSERT INTO porblt_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ninguém me viu discutindo no Templo ou incitando as pessoas a se rebelarem em qualquer sinagoga ou em qualquer outro local da cidade. ");
INSERT INTO porblt_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","E nem meus acusadores podem provar qualquer uma das suas acusações contra mim. ");
INSERT INTO porblt_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Mas, admito ao senhor que eu sirvo ao Deus dos nossos antepassados, seguindo as crenças do Caminho, que eles chamam de uma seita falsa. Eu acredito em tudo o que a lei de Moisés nos ensina e no que está escrito nos livros dos profetas. ");
INSERT INTO porblt_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Eu compartilho da mesma esperança em Deus que eles, acreditando que haverá ressurreição, tanto dos bons quanto dos maus. ");
INSERT INTO porblt_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Assim, eu sempre tento manter boas atitudes, para que minha consciência fique limpa tanto diante de Deus quanto de qualquer pessoa. ");
INSERT INTO porblt_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Eu estive fora por alguns anos e voltei para trazer dinheiro para ajudar os pobres e para oferecer sacrifícios a Deus. ");
INSERT INTO porblt_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Foi isso que eles me viram fazendo no Templo, depois de ter concluído a cerimônia de purificação. Não havia lá qualquer confusão ou multidão presente. ");
INSERT INTO porblt_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Mas, alguns judeus da província da Ásia estavam no Templo, os quais deveriam estar aqui presentes diante do senhor, para apresentar suas queixas, se eles tivessem algo contra mim. ");
INSERT INTO porblt_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ou então, que estes homens que aqui estão expliquem qual crime eu cometi para ter sido levado diante do conselho. ");
INSERT INTO porblt_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","A não ser que me acusem por eu ter gritado para eles: ‘Eu estou diante de vocês, sendo acusado por acreditar na ressurreição dos mortos!’” ");
INSERT INTO porblt_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Félix, que já estava bem informado a respeito do Caminho, suspendeu o julgamento. Ele disse: “Quando o comandante Lísias chegar, tomarei a minha decisão em relação ao seu caso.” ");
INSERT INTO porblt_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ele ordenou que o oficial mantivesse Paulo sob vigilância, mas que lhe dessem certa liberdade e que deixasse que os seus amigos cuidassem dele, sem interferência. ");
INSERT INTO porblt_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Alguns dias depois, Félix veio com Drusila, sua esposa, que era judia. Ele mandou buscar Paulo e o ouviu falar a respeito da fé em Cristo Jesus. ");
INSERT INTO porblt_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Paulo falou com eles sobre viver uma vida correta, ter autocontrole e sobre o dia do julgamento que estava próximo. Félix ficou assustado e disse a Paulo: “Pode ir agora! Eu o mandarei buscar quando for o momento.” ");
INSERT INTO porblt_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Esperando que Paulo lhe desse algum dinheiro, Félix o chamava frequentemente e conversava com ele. ");
INSERT INTO porblt_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Dois anos se passaram, e Félix foi sucedido por Pórcio Festo como governador. Félix queria agradar aos judeus, então, ao sair, deixou que Paulo continuasse preso. ");
INSERT INTO porblt_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Três dias após sua chegada na província, Festo saiu da cidade de Cesareia e foi para Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Os chefes dos sacerdotes e os líderes judeus vieram encontrá-lo e lhe apresentaram as acusações que tinham contra Paulo. ");
INSERT INTO porblt_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Eles pediram a Festo, como um favor, que enviasse Paulo a Jerusalém, pois planejavam uma emboscada no caminho para matá-lo. ");
INSERT INTO porblt_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Mas, Festo respondeu que Paulo estava sob custódia em Cesareia e que, em pouco tempo, ele mesmo iria até lá. ");
INSERT INTO porblt_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ele lhes disse: “Os seus líderes podem me acompanhar e apresentar as suas acusações contra esse homem, caso ele tenha feito algo errado.” ");
INSERT INTO porblt_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festo ficou de oito a dez dias entre eles e, depois, voltou para Cesareia. No dia seguinte, ele se sentou no tribunal e mandou que Paulo fosse trazido diante dele. ");
INSERT INTO porblt_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Quando Paulo entrou, os judeus, que tinham vindo de Jerusalém, o cercaram e fizeram sérias acusações contra ele, das quais não tinham provas. ");
INSERT INTO porblt_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulo se defendeu, dizendo: “Eu não pequei de forma alguma contra a lei judaica, contra o Templo ou contra o imperador.” ");
INSERT INTO porblt_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Mas Festo, querendo agradar os judeus, perguntou a Paulo: “Você quer ir a Jerusalém, e ali ser julgado por mim a respeito dessas questões?” ");
INSERT INTO porblt_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo respondeu: “Estou diante do tribunal do imperador, onde convém seja eu julgado. Eu não fiz nada de errado contra os judeus, como o senhor sabe muito bem. ");
INSERT INTO porblt_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Se eu tiver cometido algo que mereça a morte, eu não me recusarei a morrer. Mas, se não há verdade nas acusações que eles fazem contra mim, então, ninguém, para agradar-lhes, tem o direito de me entregar a eles. Eu apelo ao imperador!” ");
INSERT INTO porblt_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Então, Festo se reuniu com os seus conselheiros e respondeu: “Você apelou ao imperador. Então, deve ir até o imperador.” ");
INSERT INTO porblt_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Alguns dias depois, o rei Agripa e a sua irmã Berenice chegaram em Cesareia para cumprimentar Festo. ");
INSERT INTO porblt_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Eles já estavam lá há alguns dias, então, Festo apresentou o caso de Paulo para o rei: “Há um homem que Félix deixou como prisioneiro aqui. ");
INSERT INTO porblt_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Quando estive em Jerusalém, os chefes dos sacerdotes e os líderes judeus fizeram acusações contra ele e me pediram para condená-lo. ");
INSERT INTO porblt_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Eu respondi que não era assim que a lei romana funciona, pois, segundo a nossa lei, não se pode condenar alguém sem que o acusado fique diante dos seus acusadores e tenha a oportunidade de se defender. ");
INSERT INTO porblt_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Então, quando os seus acusadores chegaram aqui, eu não perdi tempo e convoquei o tribunal para o dia seguinte. Eu mandei que o homem fosse trazido. ");
INSERT INTO porblt_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","No entanto, quando os acusadores se levantaram, eles não apresentaram queixas de atos graves, como eu achei que fariam. ");
INSERT INTO porblt_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Pelo contrário, só havia discussões a respeito de questões religiosas e sobre um homem chamado Jesus, que já morreu, mas que Paulo afirmava estar vivo. ");
INSERT INTO porblt_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Como eu estava indeciso sobre como dar prosseguimento a isso, perguntei para o homem se queria ir a Jerusalém e ser julgado lá. ");
INSERT INTO porblt_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Mas, Paulo apelou para que o caso fosse ouvido pelo imperador. Então, ordenei que ele continuasse preso, até que eu possa enviá-lo ao imperador.” ");
INSERT INTO porblt_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Então, Agripa disse a Festo: “Eu gostaria de ouvir esse homem.” E Festo respondeu: “Eu farei com que o ouça amanhã.” ");
INSERT INTO porblt_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","No dia seguinte, Agripa chegou com Berenice, com grande cerimônia e luxo, e entraram no auditório, juntamente com os comandantes e os homens mais importantes da cidade. Depois, Festo ordenou que Paulo fosse trazido diante deles. ");
INSERT INTO porblt_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festo começou a falar: “Rei Agripa e todos os que se encontram aqui, diante de vocês está um homem sobre quem todo o povo judeu, tanto aqui quanto em Jerusalém, se queixa. Eles dizem que este homem deve ser condenado à morte. ");
INSERT INTO porblt_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Porém, descobri que ele não cometeu qualquer crime que mereça a pena de morte. E, já que ele apelou ao imperador, decidi atender ao seu pedido. ");
INSERT INTO porblt_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mas, não tenho nada específico para escrever a respeito dele a Sua Majestade Imperial. E é por isso que eu o trouxe diante de vocês, para que possam me ajudar a escrever algo concreto sobre ele. ");
INSERT INTO porblt_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Não me parece justo enviar um prisioneiro sem explicar as acusações feitas contra ele.” ");
INSERT INTO porblt_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Então, Agripa disse a Paulo: “Você pode falar em sua defesa.” Estendendo o braço, Paulo começou sua defesa: ");
INSERT INTO porblt_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“É um prazer, rei Agripa, poder, hoje, me defender diante do senhor em relação a tudo que os judeus me acusam. ");
INSERT INTO porblt_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Principalmente porque o senhor conhece muito bem todas as questões e costumes dos judeus. Peço a sua paciente compreensão enquanto ouve o que tenho a dizer. ");
INSERT INTO porblt_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Todos os judeus conhecem a minha história de vida. Desde os meus primeiros dias, em meu próprio país, até os dias de hoje, em Jerusalém. ");
INSERT INTO porblt_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Eles me conhecem há muito tempo e podem confirmar, se assim quiserem, que eu sigo a escola religiosa que cumpre a nossa fé da forma mais rigorosa. Eu vivi como um fariseu. ");
INSERT INTO porblt_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Agora, eu me encontro aqui em pé, sendo julgado por ter esperança na promessa que Deus fez aos nossos antepassados. ");
INSERT INTO porblt_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Promessa que as nossas doze tribos esperam receber, ao se dedicarem continuamente ao serviço de Deus. Sim, é por causa dessa esperança que eu sou acusado pelos judeus, ó Majestade! ");
INSERT INTO porblt_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Por que deveria qualquer um dos senhores pensar que é inacreditável que Deus ressuscite os mortos? ");
INSERT INTO porblt_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Antigamente, eu estava muito convencido que deveria fazer todo o possível para ir contra o nome de Jesus de Nazaré. ");
INSERT INTO porblt_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Foi exatamente isso que eu fiz em Jerusalém. Eu joguei na cadeia muitos dos que criam em Jesus. E foram os chefes dos sacerdotes que me deram permissão para fazer isso. Quando eles eram sentenciados à morte, eu dava o meu voto contra eles. ");
INSERT INTO porblt_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Eu os punia em todas as sinagogas, tentando fazer com que eles negassem o nome de Jesus. Eu estava tão enfurecido contra eles que fui até às cidades fora do nosso país para persegui-los. ");
INSERT INTO porblt_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","E é por isso que um dia eu estava indo para Damasco com a autoridade e as ordens dos chefes dos sacerdotes. ");
INSERT INTO porblt_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Era quase meio-dia, ó rei, quando eu caminhava pela estrada e vi uma luz vinda do céu, que brilhava mais forte que o sol. Essa luz me envolveu e também àqueles que viajavam comigo. ");
INSERT INTO porblt_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Todos nós caímos no chão. Então, ouvi uma voz que falou comigo em aramaico: ‘Saulo, Saulo, por que você está me perseguindo? É difícil para você lutar contra mim!’ ");
INSERT INTO porblt_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Eu perguntei: ‘Quem é você, Senhor?’ E o Senhor respondeu: ‘Eu sou Jesus, aquele que você está perseguindo. ");
INSERT INTO porblt_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Mas, levante-se e fique em pé! A razão de eu ter aparecido a você é para o escolher como meu servo. Você também será a minha testemunha, que falará aos outros como me viu e sobre tudo que eu mostrarei para você. ");
INSERT INTO porblt_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Eu o salvarei do seu próprio povo e dos não-judeus. Eu o estou enviando a eles ");
INSERT INTO porblt_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","para que abra os olhos deles, fazendo com que saiam das trevas e alcancem a luz, para que saiam do poder de Satanás e se voltem para Deus, e para que eles possam receber o perdão dos seus pecados. E passem, pela fé em mim, a fazer parte do povo escolhido de Deus.’ ");
INSERT INTO porblt_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Portanto, ó rei Agripa, eu não poderia desobedecer a essa visão que veio do céu. ");
INSERT INTO porblt_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Eu anunciei esta mensagem de arrependimento primeiro em Damasco, depois em Jerusalém e, então, em toda a Judeia e também para os não-judeus. E essa mensagem diz que devemos nos voltar para Deus, demonstrando todo o nosso arrependimento, por meio de nossas ações. ");
INSERT INTO porblt_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","E é por isso que os judeus me prenderam no Templo e tentaram me matar. ");
INSERT INTO porblt_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Mas Deus tem cuidado de mim e, por isso, estou aqui hoje como uma testemunha para todos, para as pessoas comuns e até para aquelas que são importantes. Eu estou apenas repetindo o que Moisés e os profetas disseram que aconteceria. ");
INSERT INTO porblt_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Eles falavam que o Messias precisaria sofrer e que ele seria o primeiro da ressurreição dos mortos, para anunciar a luz da salvação de Deus para judeus e para não-judeus.” ");
INSERT INTO porblt_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Festo interrompeu Paulo enquanto ele fazia a sua defesa, gritando: “Paulo, você enlouqueceu! Todo esse seu conhecimento está afetando o seu juízo!” ");
INSERT INTO porblt_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paulo respondeu: “Eu não estou louco, excelentíssimo Festo. O que estou dizendo é verdade e faz sentido. ");
INSERT INTO porblt_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","O rei sabe sobre isso que estou falando, e eu estou explicando tudo muito claramente. Tenho certeza de que ele está ciente do que tem acontecido, pois nada disso ocorreu em um lugar escondido. ");
INSERT INTO porblt_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Rei Agripa, o senhor acredita no que os profetas disseram? Tenho certeza que sim!” ");
INSERT INTO porblt_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","“Você pensa que pode me convencer a me tornar um cristão assim tão rápido?”, Agripa perguntou a Paulo. ");
INSERT INTO porblt_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo respondeu: “Se levará pouco ou muito tempo, não importa. Mas, o que peço em minhas orações para Deus é que, não apenas o senhor, mas todas as pessoas que me ouvem aqui, hoje, se tornem como eu, mas sem essas correntes.” ");
INSERT INTO porblt_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","O rei ficou em pé, juntamente com o governador e Berenice, e todos os que estavam sentados com ele. ");
INSERT INTO porblt_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Eles saíram comentando entre si e concluíram: “Este homem não fez nada para merecer a morte ou a prisão.” ");
INSERT INTO porblt_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa disse a Festo: “Ele poderia já estar solto, se não tivesse pedido para ser julgado pelo imperador.” ");
INSERT INTO porblt_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Quando chegou o dia de navegarmos para a Itália, Paulo e alguns outros prisioneiros foram entregues a um oficial, chamado Júlio, do Batalhão Imperial. ");
INSERT INTO porblt_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nós embarcamos em um navio da cidade de Adramítio, que partiria para os portos da província da Ásia e, finalmente, partimos. Aristarco, um macedônio da cidade de Tessalônica, nos acompanhou nessa viagem. ");
INSERT INTO porblt_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","No dia seguinte, nós fizemos uma breve parada em Sidom, e Júlio foi muito gentil ao deixar que Paulo desembarcasse para visitar seus amigos e receber deles o que precisava. ");
INSERT INTO porblt_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nós saímos de lá e navegamos ao norte da ilha de Chipre, para evitarmos os ventos que sopravam contra nós. ");
INSERT INTO porblt_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Então, navegamos em mar aberto, ao longo da costa da região da Cilícia e da Panfília, chegando ao porto de Mirra, na província de Lícia. ");
INSERT INTO porblt_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Lá, o oficial romano encontrou um navio da cidade de Alexandria, que navegaria para a Itália, e conseguiu que embarcássemos nele. ");
INSERT INTO porblt_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Lentamente, navegamos durante vários dias e, por fim, chegamos em frente da cidade de Cnido. Porém, como os ventos não nos permitiam continuar, navegamos pelo lado sul da ilha de Creta, próximo ao cabo Salmona. ");
INSERT INTO porblt_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Com certa dificuldade, navegamos ao longo do litoral até chegarmos a um local chamado Bons Portos, junto à cidade de Laseia. ");
INSERT INTO porblt_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Perdemos muito tempo, e a viagem estava ficando perigosa, pois já havia passado a época do Jejum, e o inverno se aproximava. Paulo aconselhou: ");
INSERT INTO porblt_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Homens, eu prevejo que essa viagem irá resultar em muitas dificuldades, com dano e muito prejuízo, não apenas da carga e do navio, mas também da nossa vida.” ");
INSERT INTO porblt_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Mas, o oficial romano deu mais atenção ao conselho do capitão do navio e do seu proprietário do que ao que Paulo disse. ");
INSERT INTO porblt_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Como o porto não era grande o bastante para passar o inverno, a maioria decidiu que era melhor sair dali e tentar, se possível, chegar ao porto de Fênix. Esse porto fica em Creta, com um lado voltado para o noroeste e outro para o sudoeste. E eles achavam que seria melhor passar o inverno aí. ");
INSERT INTO porblt_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Quando um vento sul moderado começou a soprar, eles pensaram que poderiam fazer conforme estavam planejando. Levantaram âncora e navegaram perto da costa de Creta. ");
INSERT INTO porblt_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Mas, não demorou muito para que um vento muito forte, chamado “Nordeste”, viesse da ilha. ");
INSERT INTO porblt_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","O navio foi arrastado de tal forma que não conseguia resistir ao vento. Então, decidimos parar as manobras e deixar que o vento nos levasse. ");
INSERT INTO porblt_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nós finalmente conseguimos passar ao sul de uma pequena ilha, chamada Cauda e, com dificuldade, recolhemos o bote. ");
INSERT INTO porblt_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Os marinheiros recolheram o bote para dentro do navio e amarraram cordas em volta do casco, para reforçá-lo. Depois, preocupados com o navio, que poderia ser destruído nos bancos de areia de Sirte, eles baixaram a âncora e deixaram que ele ficasse à deriva. ");
INSERT INTO porblt_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","No dia seguinte, ainda sendo violentamente atingidos pela tempestade, a tripulação começou a jogar a carga no mar. ");
INSERT INTO porblt_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","No terceiro dia, eles pegaram os equipamentos do navio e também jogaram no mar. ");
INSERT INTO porblt_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nós não vimos o sol ou as estrelas por muitos dias, e a tempestade continuava a nos atingir. Assim, qualquer esperança que tínhamos de sermos salvos se acabou. ");
INSERT INTO porblt_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Já há muito tempo que ninguém comia nada. Então, Paulo ficou em pé diante deles e lhes disse: “Homens, vocês deveriam ter me ouvido quando disse que era melhor não sair de Creta. Assim, poderiam ter evitado todo esse sofrimento e todas as perdas. ");
INSERT INTO porblt_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Mas, agora, eu lhes aconselho a ficarem firmes, pois ninguém perderá a vida, mas o navio será destruído. ");
INSERT INTO porblt_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Na noite passada, um anjo do meu Deus, a quem eu sirvo, ficou ao meu lado. ");
INSERT INTO porblt_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Ele disse: ‘Paulo, não tenha medo! Você precisa ser julgado pelo imperador. Veja! Deus, em sua infinita bondade, deu-lhe a vida de todos que estão navegando com você.’ ");
INSERT INTO porblt_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Então, homens, coragem! Eu creio em Deus e estou convencido de que tudo acontecerá como ele me disse. ");
INSERT INTO porblt_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Entretanto, seremos arrastados para alguma ilha.” ");
INSERT INTO porblt_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Por volta da meia-noite, passados quatorze dias da tempestade e ainda sendo jogados de um lado para o outro no mar Adriático, a tripulação suspeitou que estávamos nos aproximando de terra firme. ");
INSERT INTO porblt_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Eles verificaram a profundidade e descobriram que era de uns quarenta metros. Pouco tempo depois, mediram novamente e já tinha baixado para trinta metros. ");
INSERT INTO porblt_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Os marinheiros ficaram com receio de que batêssemos nas rochas. Então, jogaram quatro âncoras, que estavam na parte de trás do navio, e oraram para que o dia amanhecesse. ");
INSERT INTO porblt_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","A tripulação tentou sair do navio e baixaram o bote no mar, fingindo que iriam jogar as âncoras pela parte da frente do navio. ");
INSERT INTO porblt_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Mas, Paulo disse ao oficial e aos soldados: “A menos que a tripulação fique no navio, vocês não conseguirão se salvar.” ");
INSERT INTO porblt_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Então, os soldados cortaram as cordas que prendiam o bote, e ele se perdeu no mar. ");
INSERT INTO porblt_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ao amanhecer, Paulo insistiu para que todos comessem alguma coisa. Ele lhes disse: “Há quatorze dias que vocês estão sem comer, por estarem muito angustiados e preocupados. ");
INSERT INTO porblt_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Por favor, façam o que eu digo e comam algo. Isso os ajudará a terem força. Pois ninguém aqui perderá um único fio de cabelo.” ");
INSERT INTO porblt_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Quando ele terminou de falar, pegou um pedaço de pão e, diante de todos, agradeceu a Deus por isso. Depois, ele partiu o pão e começou a comer. ");
INSERT INTO porblt_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Todos se animaram e comeram também. ");
INSERT INTO porblt_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","No navio, havia um total de duzentas e setenta e seis pessoas. ");
INSERT INTO porblt_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Depois que todos tinham comido o suficiente, a tripulação fez o navio ficar mais leve, ao jogar a carga de trigo ao mar. ");
INSERT INTO porblt_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Quando amanheceu, eles não reconheceram a costa, mas viram uma baía onde havia uma praia. Eles decidiram tentar fazer o navio encalhar lá. ");
INSERT INTO porblt_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Então, cortaram as cordas das âncoras e as deixaram no mar. Ao mesmo tempo, desamarraram as cordas que prendiam os lemes, suspendendo a vela do lado dianteiro, para que o navio seguisse em direção à praia. ");
INSERT INTO porblt_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Mas, eles bateram em um banco de areia e o navio encalhou. A parte da frente ficou presa, e a parte de trás começou a se partir, pela força das ondas. ");
INSERT INTO porblt_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Os soldados combinaram em matar os prisioneiros, para que nenhum deles nadasse e fugisse. ");
INSERT INTO porblt_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Mas, o oficial romano, querendo salvar a vida de Paulo, impediu que eles fizessem isso e ordenou que os que conseguissem nadar pulassem no mar primeiro e chegassem à terra firme. ");
INSERT INTO porblt_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","O restante se agarrou em tábuas e em outros pedaços do navio. Dessa forma, todos foram capazes de alcançar a terra em segurança. ");
INSERT INTO porblt_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Quando chegamos em terra, sãos e salvos, descobrimos que estávamos na ilha de Malta. ");
INSERT INTO porblt_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","As pessoas de lá foram muito gentis. Elas fizeram uma fogueira e chamaram a todos nós para que nos aquecêssemos, pois chovia e fazia muito frio. ");
INSERT INTO porblt_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulo recolheu lenha e a jogou na fogueira. Mas, uma cobra venenosa saiu do meio dos pedaços de lenha por causa do calor e o mordeu, enrolando-se em sua mão. ");
INSERT INTO porblt_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Quando as pessoas viram a cobra pendurada na mão dele, disseram umas para as outras: “Este homem deve ser um assassino. Mesmo tendo escapado da morte no mar, a Justiça divina não o deixará viver.” ");
INSERT INTO porblt_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Mas, Paulo sacudiu a cobra para dentro do fogo e não sentiu nada. ");
INSERT INTO porblt_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Eles esperavam que ele fosse ficar inchado ou que fosse cair morto de repente. Mas, após esperar por um longo tempo, viram que nada de ruim tinha acontecido com ele. Assim, eles mudaram de ideia e começaram a dizer que ele devia ser um deus. ");
INSERT INTO porblt_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ali perto, havia terras que pertenciam a Públio, a principal autoridade da ilha. Ele nos recebeu muito bem e cuidou de nós durante três dias, com muita bondade. ");
INSERT INTO porblt_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","O pai de Públio se encontrava doente, deitado em uma cama, com muita febre e disenteria. Paulo entrou para vê-lo, orou por ele e colocou suas mãos sobre o homem, que logo ficou curado. ");
INSERT INTO porblt_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Depois disso, todas as pessoas que estavam doentes na ilha vieram até Paulo e foram curadas. ");
INSERT INTO porblt_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Eles nos deram muitos presentes e, quando tivemos de partir, eles nos abasteceram com tudo que precisávamos para a viagem. ");
INSERT INTO porblt_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Depois de uma parada de três meses, embarcamos em um navio da cidade de Alexandria, que tinha na proa a figura dos Gêmeos Celestiais. Esse navio tinha passado todo o inverno na ilha. ");
INSERT INTO porblt_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Paramos na cidade de Siracusa, onde ficamos por três dias. ");
INSERT INTO porblt_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","De lá, navegamos até a cidade de Régio. No dia seguinte, soprou um vento do sul e, em dois dias, chegamos ao porto de Putéoli, ");
INSERT INTO porblt_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","onde encontramos alguns irmãos de fé. Eles nos pediram para que ficássemos com eles por uma semana. Então, finalmente, chegamos em Roma. ");
INSERT INTO porblt_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Quando alguns dos irmãos em Roma ouviram dizer que havíamos chegado, eles vieram nos encontrar na Praça de Ápio e de Três Vendas. Quando Paulo os viu, ficou muito agradecido a Deus e também muito animado. ");
INSERT INTO porblt_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Quando entramos em Roma, Paulo recebeu permissão para ficar em uma casa, sendo vigiado por um soldado. ");
INSERT INTO porblt_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Três dias depois, Paulo convidou os líderes judeus de Roma para virem vê-lo. Quando estavam todos reunidos, Paulo lhes disse: “Irmãos, muito embora eu não tenha feito nada de errado contra o nosso povo ou contra os costumes dos nossos antepassados, fui preso em Jerusalém e entregue às autoridades romanas. ");
INSERT INTO porblt_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Após terem me interrogado, os romanos queriam me soltar, por eu não ter feito nada que justificasse minha condenação à morte. ");
INSERT INTO porblt_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Mas, os líderes judeus foram contra a minha libertação. Assim, fui obrigado a apelar ao imperador, embora não tenha qualquer acusação contra o meu próprio povo. ");
INSERT INTO porblt_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Por isso pedi para encontrá-los e falar com os senhores, pois é por causa da esperança de Israel que eu me encontro acorrentado desta maneira.” ");
INSERT INTO porblt_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Os líderes disseram a Paulo: “Nós não recebemos carta alguma vinda da Judeia sobre você. E ninguém do nosso povo veio até aqui relatar algo contra você ou falar algo de ruim sobre você. ");
INSERT INTO porblt_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Mas, queremos ouvir de você em que acredita, especialmente em relação a essa seita, que sabemos ser condenada em todos os lugares.” ");
INSERT INTO porblt_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Então, marcaram um encontro com Paulo. No dia marcado, muitas pessoas foram ao lugar em que Paulo estava. Paulo ficou desde a manhã até à noite dando explicações e falando com eles a respeito do Reino de Deus. Ele tentou convencê-los a respeito de Jesus, usando os textos da lei de Moisés e dos livros dos profetas. ");
INSERT INTO porblt_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Alguns aceitaram o que Paulo dizia, mas outros se recusaram a crer. ");
INSERT INTO porblt_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Eles não conseguiam chegar a um acordo. Então, resolveram ir embora depois que Paulo lhes disse: “O Espírito Santo estava certo quando falou, por intermédio de Isaías, o profeta, com respeito aos seus antepassados: ");
INSERT INTO porblt_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Vá e diga a essas pessoas: Mesmo que ouçam, vocês não entenderão, e mesmo que vejam, vocês não perceberão. ");
INSERT INTO porblt_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Pois a mente dessas pessoas está fechada, os seus ouvidos não conseguem ouvir e fecharam os seus olhos. Caso elas pudessem enxergar com os seus olhos, ouvir com os seus ouvidos e compreender com as suas mentes e se voltassem para mim, eu iria curá-las.’ ");
INSERT INTO porblt_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Assim, os senhores deveriam saber que esta salvação, que vem de Deus, foi enviada para os não-judeus e eles ouvirão.” ");
INSERT INTO porblt_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Durante dois anos Paulo morou na casa que havia alugado, recebendo bem a todos os que queriam encontrá-lo. ");
INSERT INTO porblt_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ele falava sobre o Reino de Deus e ensinava a respeito do Senhor Jesus Cristo, com muita coragem e sem impedimento algum. ");
INSERT INTO porblt_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Eu, Paulo, um fiel servo de Jesus Cristo, é quem escreve esta carta. Foi Deus quem me chamou e me separou para me tornar um apóstolo, a fim de que eu anuncie as boas novas ");
INSERT INTO porblt_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","que ele já havia prometido, por intermédio dos seus profetas, nas Sagradas Escrituras. ");
INSERT INTO porblt_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","As boas novas falam a respeito do seu Filho, de quem Davi foi o antepassado aqui na terra, ");
INSERT INTO porblt_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","mas, que se revelou como Filho de Deus por meio de sua ressurreição dos mortos, pelo poder do Espírito Santo. Ele é Jesus Cristo, o nosso Senhor. ");
INSERT INTO porblt_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Foi por meio dele que recebi o privilégio de me tornar um apóstolo, para chamar todas as nações para se dedicarem à fé nele. ");
INSERT INTO porblt_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Vocês também se incluem entre aqueles que foram chamados para pertencerem a Jesus Cristo. ");
INSERT INTO porblt_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Eu escrevo a todos vocês em Roma, que são amados por Deus e chamados para serem o seu povo especial. Que a graça e a paz de Deus, nosso Pai, e do Senhor Jesus Cristo estejam com vocês! ");
INSERT INTO porblt_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Deixem-me começar dizendo que agradeço ao meu Deus, por meio de Jesus Cristo, por todos vocês, pois a sua fé em Deus é reconhecida no mundo todo. ");
INSERT INTO porblt_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Deus, a quem eu sirvo com todo o meu coração, compartilhando as boas novas a respeito de seu Filho, é testemunha de que eu sempre oro por vocês. ");
INSERT INTO porblt_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Em minhas orações, sempre peço que, se for da vontade de Deus, eu tenha a oportunidade de visitá-los. ");
INSERT INTO porblt_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Eu realmente quero visitá-los e repartir com vocês alguma bênção espiritual, para lhes fortalecer a fé. ");
INSERT INTO porblt_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Assim, poderemos dar forças uns aos outros por intermédio da fé que vocês e eu temos em Deus. ");
INSERT INTO porblt_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Eu gostaria que soubessem, meus irmãos e minhas irmãs, que eu sempre planejei me reunir com vocês, mas tal oportunidade não surgiu até agora. Eu quero ver alguns bons resultados espirituais entre vocês, da mesma forma que vi em outros não-judeus. ");
INSERT INTO porblt_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Pois tenho o dever de trabalhar tanto para os povos civilizados quanto para os não civilizados, tanto para os instruídos quanto para aqueles que não têm instrução. ");
INSERT INTO porblt_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","É por isso que eu me sinto tão entusiasmado para anunciar o evangelho também a vocês que moram em Roma. ");
INSERT INTO porblt_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Eu, absolutamente, não me envergonho do evangelho, pois é o poder de Deus para salvar todos os que creem, sendo primeiramente para o povo judeu e depois para todos os outros povos também. ");
INSERT INTO porblt_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Pois, no evangelho, Deus é mostrado como bom e justo, confiável do início ao fim. Como as Sagradas Escrituras dizem: “Aqueles que são justos para com Deus viverão por meio da fé que têm nele.” ");
INSERT INTO porblt_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","A hostilidade de Deus se revela do céu contra as pessoas que não creem e que não são moralmente justas, contra aqueles que escondem a verdade por meio do mal que praticam. ");
INSERT INTO porblt_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","O que pode ser conhecido sobre Deus é evidente, pois ele tornou tudo muito claro para elas. ");
INSERT INTO porblt_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Desde que o mundo foi criado, os aspectos invisíveis de Deus, tanto o seu poder eterno quanto a sua natureza divina, são claramente visíveis para os seres humanos, por meio do que Deus criou. Não há desculpa para essas pessoas, ");
INSERT INTO porblt_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","pois, mesmo tendo conhecido a Deus, elas não o louvam, nem lhe são agradecidas. Pelo contrário, o seu pensamento sobre Deus as tornou completamente tolas, e as trevas preencheram suas mentes vazias. ");
INSERT INTO porblt_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Embora elas afirmem ser sábias, tornaram-se tolas. ");
INSERT INTO porblt_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Elas trocaram a glória do Deus imortal por ídolos, imagens de seres humanos mortais, aves, animais e répteis. ");
INSERT INTO porblt_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Então, Deus as abandonou aos desejos mundanos de suas mentes depravadas, e elas cometeram atos vergonhosos e degradantes umas às outras. ");
INSERT INTO porblt_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Elas trocaram a fé em Deus por uma mentira, servindo e adorando as criaturas, em vez de servirem e adorarem o próprio Criador, o qual sempre merece ser louvado. Amém! ");
INSERT INTO porblt_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","E é por isso que Deus as abandonou aos seus desejos malignos. Até mesmo as suas mulheres trocaram as relações naturais pelas que vão contra a natureza. ");
INSERT INTO porblt_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","E da mesma forma, os homens deixaram as relações naturais com as mulheres para se entregarem a paixões ardentes uns pelos outros. Os homens fizeram coisas indecentes uns com os outros e, como resultado, sofreram as consequências inevitáveis de suas perversões. ");
INSERT INTO porblt_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Como eles não achavam que valia a pena conhecer os ensinamentos de Deus, ele os abandonou aos seus pensamentos desprezíveis e duvidosos, fazendo o que nunca deveria ser feito. ");
INSERT INTO porblt_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Eles se deixaram tomar por tudo o que é errado: maldade, ganância, ódio, inveja, assassinato, brigas, mentira, malícia e intriga. ");
INSERT INTO porblt_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Eles falam mal uns dos outros e odeiam a Deus. Eles são prepotentes, arrogantes e pretensiosos. A imaginação deles é grande quanto a inventar novas formas de pecar. Eles desobedecem aos seus pais. ");
INSERT INTO porblt_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Não procuram entender, não mantêm as suas promessas e não demonstram qualquer gentileza ou compaixão. ");
INSERT INTO porblt_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Mesmo que saibam exatamente o que Deus exige, eles fazem coisas que merecem a morte. Eles não apenas fazem essas coisas, mas, também, apoiam outros que fazem o mesmo que eles. ");
INSERT INTO porblt_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Então, pouco importa quem você seja, pois, se julga os outros, não há desculpa para você. Porque, ao julgar os outros, você está se condenando, já que faz as mesmas coisas que condena nas outras pessoas. ");
INSERT INTO porblt_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Nós sabemos que o julgamento de Deus sobre aqueles que fazem essas coisas tem como base a verdade. ");
INSERT INTO porblt_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Quando os julga, você realmente acha que assim poderá evitar o julgamento de Deus? ");
INSERT INTO porblt_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ou será que você despreza a imensa bondade, tolerância e paciência de Deus, sem notar que Deus é bom e está tentando guiá-lo para que se arrependa? ");
INSERT INTO porblt_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Por causa de sua atitude insensível e por se recusar a se arrepender, você está fazendo coisas que merecerão uma resposta muito mais dura no dia em que o julgamento justo do Senhor acontecer. ");
INSERT INTO porblt_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Deus fará com que todos recebam o que merecem, de acordo com o que cada um fez. ");
INSERT INTO porblt_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","As pessoas que continuaram tentando fazer o que é bom e certo receberão glória, honra e vida eterna. ");
INSERT INTO porblt_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Mas aqueles que pensam apenas em si, que rejeitam a verdade e deliberadamente escolhem fazer o mal, receberão a punição e a furiosa hostilidade divinas. ");
INSERT INTO porblt_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Todos os que fazem o mal terão problemas e sofrimento, sendo o povo judeu primeiro e, depois, também os não-judeus. ");
INSERT INTO porblt_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Mas, as pessoas que fazem o bem terão glória, honra e paz, sendo o povo judeu primeiro, e os não-judeus também. ");
INSERT INTO porblt_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Para Deus, todos são iguais; não há favoritos. ");
INSERT INTO porblt_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Aqueles que pecam, mesmo que não conheçam a lei escrita, ainda assim estão perdidos; já aqueles que pecam conhecendo a lei escrita serão condenados por essa lei. ");
INSERT INTO porblt_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Apenas escutar o que a lei diz não os torna justos aos olhos de Deus. São os que fazem o que a lei diz que agem da forma justa. ");
INSERT INTO porblt_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Os não-judeus não têm a lei escrita, mas quando eles, naturalmente, fazem o que nela está escrito, estão cumprindo a lei, mesmo sem tê-la. ");
INSERT INTO porblt_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Dessa maneira, eles mostram que têm a lei escrita no coração. Como eles pensam a respeito do que estão fazendo, a consciência deles os acusa por fazer o errado ou os defende quando fazem o que é bom e justo. ");
INSERT INTO porblt_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","As boas novas que eu compartilho com vocês é que está chegando o dia em que Deus julgará, por intermédio de Jesus Cristo, os pensamentos secretos de todas as pessoas. ");
INSERT INTO porblt_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","E o que dizer de você, que se denomina judeu? Você confia na lei escrita e se orgulha de ter uma relação especial com Deus. ");
INSERT INTO porblt_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Você sabe qual é a vontade dele. Você faz o que é certo, porque aprendeu com a lei. ");
INSERT INTO porblt_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Há uma certeza absoluta em você de que pode guiar os cegos e que é luz para aqueles que estão nas trevas. ");
INSERT INTO porblt_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Você acha que pode aconselhar pessoas que não têm instrução e se coloca como um mestre de crianças, pois você conhece toda a verdade que há para ser conhecida na lei. ");
INSERT INTO porblt_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Então, se você está ocupado, ensinando os outros, por que não ensina a si mesmo? Você diz aos outros que não se deve roubar, mas você rouba? ");
INSERT INTO porblt_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ou diz para as pessoas não cometerem adultério, mas você o comete? Você diz às pessoas para não adorar ídolos, mas você profana templos? ");
INSERT INTO porblt_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Você se orgulha de ter a lei, mas representa mal a Deus, porque desobedece a sua lei. ");
INSERT INTO porblt_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Como se lê nas Sagradas Escrituras: “Os não-judeus proferem blasfêmias contra Deus por causa de vocês, judeus.” ");
INSERT INTO porblt_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","O fato de ser circuncidado só tem valor se você faz o que a lei manda. Mas, se você transgride a lei, a sua circuncisão vale tanto quanto se você não fosse circuncidado. ");
INSERT INTO porblt_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Se um homem que não fez a circuncisão cumpre a lei, ele deveria ser considerado como sendo circuncidado, mesmo que não o seja de fato. ");
INSERT INTO porblt_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Os não-judeus não circuncidados, que cumprem a lei, o condenarão se você transgredir a lei, ainda que você tenha a lei escrita e a circuncisão. ");
INSERT INTO porblt_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Não é o que está no exterior que torna alguém judeu e nem o sinal físico da circuncisão. ");
INSERT INTO porblt_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","O que o torna alguém judeu está no interior. É a “circuncisão do coração”, coisa que a lei escrita não pode fazer, mas, sim, o Espírito. O louvor que essa pessoa busca não vem das pessoas e, sim, de Deus. ");
INSERT INTO porblt_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Então, há vantagem em ser judeu? A circuncisão traz algum benefício? ");
INSERT INTO porblt_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Sim, há muitos benefícios. O primeiro deles é que Deus confiou a sua mensagem ao povo judeu. ");
INSERT INTO porblt_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","E, se alguns não creram, a incredulidade deles anula a fidelidade de Deus? ");
INSERT INTO porblt_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","É claro que não! Mesmo que todos sejam mentirosos, Deus sempre diz a verdade. Como está escrito nas Sagradas Escrituras a respeito dele: “O que você disser provará ser verdade, e você vencerá o seu caso quando for julgado.” ");
INSERT INTO porblt_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Mas, se o fato de estarmos errados ajuda a mostrar que Deus está certo, o que nós deveríamos concluir? Que Deus está errado ao anunciar a sua decisão sobre nós? (Eu estou falando aqui a partir de uma perspectiva humana.) ");
INSERT INTO porblt_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","É claro que não! Como Deus poderia julgar o mundo de outra forma? ");
INSERT INTO porblt_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Alguém poderia dizer: “Por que eu ainda sou condenado como pecador se as minhas mentiras tornam, em contrapartida, a verdade de Deus e a sua glória mais evidentes?” ");
INSERT INTO porblt_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Seria o caso de dizer: “Vamos praticar males para que venham bens”? É isso que algumas pessoas nos acusam de dizer, de forma caluniosa. Elas deveriam ser merecidamente condenadas! ");
INSERT INTO porblt_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Então, nós, os judeus, somos melhores do que os outros? Definitivamente, não! Lembrem-se de que nós já afirmamos que tanto os judeus quanto os não-judeus estão sob o controle do pecado. ");
INSERT INTO porblt_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Como as Sagradas Escrituras dizem: “Ninguém faz o que é correto, nem mesmo uma única pessoa. ");
INSERT INTO porblt_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ninguém entende e ninguém busca a Deus. ");
INSERT INTO porblt_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Todos viraram as costas para ele. Todos só fazem o que é errado. Ninguém faz o que é bom, nem uma única pessoa. ");
INSERT INTO porblt_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","As gargantas deles são como um túmulo aberto. As suas línguas espalham mentiras. Dos seus lábios escorrem veneno de serpentes. ");
INSERT INTO porblt_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","As suas bocas estão cheias de amargura e maldições, ");
INSERT INTO porblt_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","e eles são rápidos em causar dor e matar. ");
INSERT INTO porblt_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","O caminho deles leva ao desastre e à miséria. ");
INSERT INTO porblt_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Eles não sabem como viver em paz. ");
INSERT INTO porblt_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Eles não se importam, de forma alguma, em respeitar a Deus.” ");
INSERT INTO porblt_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","É claro que tudo na lei se aplica aos que vivem segundo ela, para que, assim, ninguém tenha desculpas e para garantir que as pessoas no mundo todo estejam sujeitas a Deus. ");
INSERT INTO porblt_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Pois ninguém é considerado justo diante de Deus por fazer o que a lei manda. A lei apenas nos ajuda a reconhecer o que o pecado realmente é. ");
INSERT INTO porblt_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Mas, agora, sem as obras da lei, se manifestou a justiça de Deus, testemunhada pela lei de Moisés e pelos profetas. ");
INSERT INTO porblt_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Essa justiça de Deus é por meio da fé em Jesus Cristo, para todos os que creem nele, porque Deus não faz distinção de pessoas, ");
INSERT INTO porblt_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","pois todos nós pecamos e estamos muito longe do ideal da glória de Deus. ");
INSERT INTO porblt_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ainda assim, ao nos dar, sem nada exigir, o dom da sua graça, Deus nos torna justos, por meio de Cristo Jesus, que nos liberta. ");
INSERT INTO porblt_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Deus nos deu Jesus como um dom que traz a paz para aqueles que creem nele. Ele é aquele que derrama o seu próprio sangue. Deus fez isso para demonstrar que ele é verdadeiramente bom e justo, pois, no passado, ele não puniu os pecados das pessoas. ");
INSERT INTO porblt_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Mas agora, Deus prova que é justo e faz o que é certo e que ele é justo com aqueles que creem em Jesus. ");
INSERT INTO porblt_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Então, nós devemos nos orgulhar disso? Claro que não! Não há lugar para isso! E por que não? Será que é porque respeitamos a lei de Deus e cumprimos suas exigências? Não; pelo contrário, é porque cremos em Cristo. ");
INSERT INTO porblt_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Podemos concluir que as pessoas se tornam justas diante de Deus por meio de sua fé nele, e não pelo cumprimento da lei. ");
INSERT INTO porblt_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Deus seria apenas o Deus dos judeus? Ele também não é Deus dos outros povos? É claro que ele é! ");
INSERT INTO porblt_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Há apenas um Deus, e ele nos torna moralmente justos por meio da nossa fé nele, sejamos nós judeus ou não-judeus. ");
INSERT INTO porblt_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Isso significa que, pelo fato de crermos em Deus, tornamos a lei sem valor? É claro que não! Na verdade, crendo em Deus, nós apenas afirmamos a importância da lei. ");
INSERT INTO porblt_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Vamos tomar Abraão como exemplo. A partir de um ponto de vista humano, ele é o pai da nossa nação. Devemos nos perguntar: “Qual era a experiência dele?” ");
INSERT INTO porblt_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Pois, se Abraão foi considerado justo pelo que ele fez, ele deveria ter algo de que se orgulhar, mas não aos olhos de Deus. ");
INSERT INTO porblt_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","No entanto, o que está escrito nas Sagradas Escrituras? “Abraão acreditou em Deus e, assim, foi considerado como uma pessoa justa.” ");
INSERT INTO porblt_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Quem trabalha deve receber o seu pagamento; não é considerado um presente e, sim, o salário por conta do trabalho que fez. ");
INSERT INTO porblt_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Mas Deus, que transforma pecadores em justos, considera-os justos, não porque eles trabalharam por isso, mas por causa da fé que eles depositam nele. É por isso que ");
INSERT INTO porblt_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Davi fala a respeito da felicidade das pessoas a quem Deus considera justas, e não por elas terem trabalhado por isso: ");
INSERT INTO porblt_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Felizes são aqueles cujos erros são perdoados e cujos pecados são apagados. ");
INSERT INTO porblt_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Felizes aqueles que o Senhor não considera como pecadores.” ");
INSERT INTO porblt_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Mas, esta bênção vem apenas para os judeus, ou vem para os outros também? Nós acabamos de dizer que Abraão foi considerado justo por causa de sua fé em Deus. ");
INSERT INTO porblt_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Mas, quando isso aconteceu? Quando Abraão estava circuncidado ou antes? Foi antes e não depois. ");
INSERT INTO porblt_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Na verdade, foi antes dele ser circuncidado. O fato dele ser circuncidado apenas confirmou a sua fé em Deus, que o aceitou. Isso aconteceu antes dele ser circuncidado. Então, ele é o pai de todos que creem em Deus e que são considerados justos por Deus, muito embora eles possam não ser circuncidados. ");
INSERT INTO porblt_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ele também é o pai dos circuncidados, não apenas por eles assim o serem, mas por eles seguirem o exemplo da fé em Deus, que o nosso antepassado Abraão teve antes de ser circuncidado. ");
INSERT INTO porblt_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","A promessa de Deus para Abraão e para os seus descendentes, de que o mundo pertenceria a ele, não foi por ele cumprir a lei, mas por ele ser considerado justo por sua fé em Deus. ");
INSERT INTO porblt_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Pois, se a herança prometida fosse baseada no cumprimento da lei, então, a discussão de se acreditar em Deus não seria necessária, e a promessa não faria sentido. ");
INSERT INTO porblt_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Pois a lei resulta em punição; mas se não há lei, então, não existe desobediência à lei. ");
INSERT INTO porblt_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Assim, a promessa se baseia na fé em Deus. E ela é dada como um presente, sem que nada seja cobrado em troca, garantida a todos os descendentes de Abraão. A promessa não é apenas para aqueles que seguem a lei, mas também para os que creem, como Abraão, o pai de todos nós. ");
INSERT INTO porblt_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Como dizem as Sagradas Escrituras: “Eu o tornei pai de muitas nações.” Pois, na presença de Deus, Abraão creu em Deus, que faz os mortos reviverem e faz com que exista o que antes não existia. ");
INSERT INTO porblt_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Contra toda a esperança, Abraão manteve sua esperança e creu em Deus. Então, ele se tornou o pai de muitos povos, exatamente como Deus tinha prometido a ele: “É assim que você terá muitos descendentes!” ");
INSERT INTO porblt_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Sua fé em Deus não enfraqueceu, mesmo quando ele pensou que o seu corpo estava praticamente morto (ele tinha quase cem anos de idade) e sabia que Sara já estava muito idosa para ter filhos. ");
INSERT INTO porblt_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ele se manteve firme à promessa de Deus e não duvidou dela. Pelo contrário, sua fé em Deus ficou ainda mais forte, e ele louvou a Deus. ");
INSERT INTO porblt_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ele estava totalmente convencido de que Deus tinha o poder para cumprir o que havia prometido. ");
INSERT INTO porblt_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","É por isso que Abraão foi considerado justo por Deus. ");
INSERT INTO porblt_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","As palavras “Abraão foi considerado justo” não foram escritas apenas para o seu benefício. ");
INSERT INTO porblt_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Elas também foram escritas para nós, para aqueles entre nós que serão considerados justos, pois temos fé em Deus, que ressuscitou nosso Senhor Jesus dos mortos. ");
INSERT INTO porblt_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Jesus foi entregue para morrer por causa dos nossos pecados e foi ressuscitado para nos tornar justos. ");
INSERT INTO porblt_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Agora que Deus nos tornou justos por crermos nele, nós temos paz com ele, por meio do nosso Senhor Jesus Cristo. ");
INSERT INTO porblt_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","É por meio de Jesus, pela nossa fé nele, que temos acesso à graça de Deus, na qual estamos firmes, e nos alegramos na esperança de participarmos da glória de Deus. ");
INSERT INTO porblt_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","E não apenas isso; nós também seguimos confiantes, mesmo quando aparecem os problemas, pois sabemos que, ao enfrentarmos problemas, desenvolvemos a nossa força espiritual. ");
INSERT INTO porblt_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","E a força espiritual, por sua vez, desenvolve um caráter maduro, o que resulta em uma esperança que traz confiança. ");
INSERT INTO porblt_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Uma vez que temos essa esperança, nunca ficaremos desapontados, pois o amor de Deus se derrama sobre nós, por meio do Espírito Santo que ele nos deu. ");
INSERT INTO porblt_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Quando estávamos completamente indefesos, no momento certo Cristo morreu por nós, um povo que não tinha fé. ");
INSERT INTO porblt_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Quem morreria por outra pessoa, mesmo que fosse uma pessoa que faz o que é certo? (Embora, talvez possa existir alguém que seja corajoso o bastante para morrer por uma pessoa realmente boa.) ");
INSERT INTO porblt_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Mas, Deus demonstra o seu amor para conosco, por meio de Cristo, que morreu por nós quando ainda éramos pecadores. ");
INSERT INTO porblt_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Agora, que nos tornamos justos por meio da sua morte, podemos estar absolutamente certos de que seremos salvos por ele no dia do julgamento que está por vir. ");
INSERT INTO porblt_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Embora estivéssemos contra ele, Deus nos tornou seus amigos pela morte do seu Filho e, exatamente por isso, podemos estar certos de que ele nos salvará, por meio da vida do seu Filho. ");
INSERT INTO porblt_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Além disso, nós agora comemoramos o que Deus fez, por meio do nosso Senhor Jesus Cristo, para nos reconciliar com ele e nos tornar seus amigos. ");
INSERT INTO porblt_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Pois, por meio de um homem, o pecado entrou no mundo e trouxe com ele a morte. E, assim, a morte veio para todos nós, pois todos pecamos. ");
INSERT INTO porblt_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Mesmo antes da lei nos ser dada, o pecado estava no mundo; porém, quando não existe lei, Deus não leva em conta o pecado. ");
INSERT INTO porblt_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Porém, a morte ainda dominava desde a época de Adão até Moisés, mesmo sobre aqueles que não pecaram como Adão pecou. Agora, Adão representa aquele que havia de vir. ");
INSERT INTO porblt_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Mas, o presente de Jesus não é semelhante ao pecado de Adão. Embora muitas pessoas tenham morrido por causa do pecado de um único homem, a graça de Deus é muito maior e tem sido compartilhada com muitas pessoas, por meio do seu presente misericordioso, na pessoa de Jesus Cristo. ");
INSERT INTO porblt_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","O resultado do presente não é semelhante ao do pecado. O resultado do pecado de Adão foi julgamento e condenação; mas o presente nos torna justos diante de Deus, apesar dos nossos muitos pecados. ");
INSERT INTO porblt_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Por causa do pecado de um homem, a morte dominou o mundo. Mas, a graça de Deus é muito maior e o seu presente nos torna justos, pois todos que recebem a sua graça reinarão em vida, por meio da pessoa de Jesus Cristo! ");
INSERT INTO porblt_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Da mesma maneira que apenas um pecado trouxe a condenação para todos os seres humanos, um único ato de justiça deu a todos a oportunidade de viver de forma justa. ");
INSERT INTO porblt_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","E assim como a desobediência de um único homem fez com que muitos se tornassem pecadores, assim também a obediência de apenas um homem faz com que muitos se tornem justos diante de Deus. ");
INSERT INTO porblt_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Quando a lei foi apresentada, o pecado se tornou ainda mais evidente. Mas, à medida que o pecado se tornou mais evidente, a graça também se tornou muito mais óbvia! ");
INSERT INTO porblt_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Assim como o pecado nos dominou e nos trouxe a morte, agora a graça governa o mundo e nos torna justos diante de Deus, trazendo a vida eterna para nós, por meio de Jesus Cristo, o nosso Senhor. ");
INSERT INTO porblt_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Então, qual é a nossa resposta? Vamos continuar a pecar para que possamos ter ainda mais graça? ");
INSERT INTO porblt_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","É claro que não! Já que nós morremos para o pecado, como continuaremos a viver em pecado? ");
INSERT INTO porblt_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Vocês não sabem que todos aqueles entre nós que foram batizados em Jesus Cristo também foram batizados em sua morte? ");
INSERT INTO porblt_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Pelo batismo, nós fomos sepultados com ele na morte, para que, como Cristo ressuscitou dos mortos, pela glória do Pai, nós também possamos viver uma nova vida. ");
INSERT INTO porblt_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Se nos tornamos um com ele ao morrer como ele morreu, então, também ressuscitaremos como ele. ");
INSERT INTO porblt_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Nós sabemos que o nosso antigo eu foi crucificado com ele, para que o corpo morto do pecado fosse destruído, fazendo com que nós não fôssemos mais escravizados pelo pecado. ");
INSERT INTO porblt_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Pois qualquer um que tenha morrido, libertou-se do pecado. ");
INSERT INTO porblt_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Já que morremos com Cristo, nós temos confiança de que também iremos viver com ele. ");
INSERT INTO porblt_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Pois nós sabemos que por Jesus ter ressuscitado, ele não morrerá nunca, pelo fato da morte não ter mais qualquer poder sobre ele. ");
INSERT INTO porblt_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Ao morrer, ele morreu para o pecado de uma vez por todas. Mas agora ele vive, e ele vive para Deus! ");
INSERT INTO porblt_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Exatamente da mesma maneira, vocês deveriam se considerar mortos para o pecado, mas vivos para Deus, por estarem unidos a Cristo Jesus. ");
INSERT INTO porblt_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Não deixem que o pecado controle o seu corpo mortal. Não se deixem cair em suas tentações. ");
INSERT INTO porblt_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","E nem usem qualquer parte do corpo de vocês como uma ferramenta maligna do pecado. Pelo contrário, dediquem-se a Deus, como aqueles que foram trazidos da morte para a vida, e usem todas as partes do seu corpo como ferramentas para fazer o bem para Deus. ");
INSERT INTO porblt_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","O pecado não os dominará, pois vocês não estão sob a lei, mas, sim, sob a graça de Deus. ");
INSERT INTO porblt_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Então, quer dizer que nós deveríamos pecar porque não estamos sob a lei e, sim, sob a graça de Deus? É claro que não! ");
INSERT INTO porblt_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Não percebem que se vocês se tornarem escravos de alguém, obedecerem as suas ordens, serão escravos daquele a quem vocês obedecem? Se vocês forem escravos do pecado, o resultado é a morte. Mas se obedecerem a Deus, o resultado é que vocês se tornarão justos diante dele. ");
INSERT INTO porblt_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Porém, graças a Deus, que embora, no passado, vocês tenham sido escravos do pecado, vocês, de todo o coração, escolheram seguir a verdade que Deus lhes deu e vocês a receberam. ");
INSERT INTO porblt_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Agora que já se libertaram do pecado, vocês se tornaram escravos de Deus para fazerem o que é moralmente certo. ");
INSERT INTO porblt_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Eu estou usando esse exemplo simples, pois o pensamento de vocês é limitado. Assim como antes vocês se escravizaram em nome da imoralidade, acumulando um pecado após o outro, agora vocês devem se tornar escravos do que é puro e justo. ");
INSERT INTO porblt_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Quando vocês eram escravos do pecado, vocês não faziam o que é certo. ");
INSERT INTO porblt_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Mas, no que isso resultou? Vocês não se envergonham das coisas que fizeram? Essas coisas levam à morte! ");
INSERT INTO porblt_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Mas, agora que se libertaram do pecado e se tornaram escravos de Deus, os resultados serão uma vida pura e, no fim, a vida eterna. ");
INSERT INTO porblt_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Porque o salário do pecado é a morte, mas o presente de Deus, que nada cobra em troca, é a vida eterna, por meio de Cristo Jesus, o nosso Senhor. ");
INSERT INTO porblt_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Irmãos e irmãs (eu estou falando aqui para pessoas que conhecem a lei), vocês não percebem que a lei tem autoridade sobre alguém apenas enquanto essa pessoa estiver viva? ");
INSERT INTO porblt_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Por exemplo, uma mulher casada está ligada pela lei ao marido enquanto ele estiver vivo; mas, se ele morrer, ela está livre dessa obrigação legal para com ele. ");
INSERT INTO porblt_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Então, se ela viver com outro homem, enquanto o marido dela estiver vivo, ela estará cometendo adultério. No entanto, se o marido dela morrer e depois ela se casar com outro homem, então, ela não será culpada de adultério. ");
INSERT INTO porblt_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Da mesma maneira, meus amigos, vocês morreram para a lei, por meio do corpo de Cristo. Assim, a partir de agora, vocês pertencem a outra pessoa, pertencem a Cristo, que ressuscitou para que nós pudéssemos viver uma vida produtiva para Deus. ");
INSERT INTO porblt_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Enquanto éramos controlados pela natureza antiga, os desejos do pecado (como revelado pela lei) estavam trabalhando dentro de nós e isso resultou em morte. ");
INSERT INTO porblt_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Mas agora, fomos libertados da lei, e morremos para o que nos acorrentava. Dessa maneira, nós podemos servir a Deus de uma nova maneira, obedecendo ao Espírito de Deus, e não na forma antiga da lei escrita. ");
INSERT INTO porblt_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Então, o que podemos concluir? Que a lei é pecado? É claro que não! Eu não saberia o que o pecado é, a não ser que a lei o definisse. Eu não entenderia que desejar para mim as coisas que outras pessoas têm é errado, se a lei não dissesse: “Não deseje para si o que pertence a outra pessoa.” ");
INSERT INTO porblt_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Mas, por meio desse mandamento, o pecado encontrou um meio de despertar em mim toda a forma de desejos egoístas, porque se a lei não existir, o pecado está morto. ");
INSERT INTO porblt_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Eu costumava viver sem perceber o que a lei realmente significa. Mas quando eu compreendi as consequências desse mandamento, então, o pecado ganhou vida, e eu morri. ");
INSERT INTO porblt_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Eu descobri que o próprio mandamento que deveria me trazer vida, trouxe, em vez disso, a morte. ");
INSERT INTO porblt_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Pois o pecado encontrou, por meio do mandamento, uma forma de me enganar e usou o mandamento para me matar. ");
INSERT INTO porblt_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Entretanto, a lei é santa, e o mandamento é santo, justo e bom. ");
INSERT INTO porblt_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Então, uma coisa que é boa me mataria? É claro que não! Mas, o pecado se mostra como pecado ao usar o que é bom para causar a minha morte. Assim, por meio do mandamento, o terrível pecado se revela como ele realmente é. ");
INSERT INTO porblt_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nós sabemos que a lei é espiritual, mas eu sou hum