﻿USE sofia;
DROP TABLE IF EXISTS sofia.por_WBTC_vpl;
CREATE TABLE por_WBTC_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES por_WBTC_vpl WRITE;
INSERT INTO por_WBTC_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Esta é a lista dos antepassados de Jesus Cristo, descendente de Davi, que era descendente de Abraão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraão foi pai de Isaque; Isaque, pai de Jacó; Jacó, pai de Judá e de seus irmãos; ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá, pai de Peres e de Zera. (A mãe deles foi Tamar.) Peres foi pai de Esrom; Esrom, pai de Arão; ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arão, pai de Aminadabe; Aminadabe, pai de Nasom; ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Nasom, pai de Salmom; Salmom, pai de Boaz. (A mãe de Boaz foi Raabe.) Boaz foi pai de Obede. (A mãe de Obede foi Rute.) Obede foi pai de Jessé; ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jessé, pai do rei Davi; Davi, pai de Salomão. (A mãe de Salomão tinha sido esposa de Urias.) ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomão foi pai de Roboão; Roboão, pai de Abias; Abias, pai de Asa; ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa, pai de Josafá; Josafá, pai de Jorão; Jorão, pai de Uzias; ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzias, pai de Jotão; Jotão, pai de Acaz; Acaz, pai de Ezequias; ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequias, pai de Manassés; Manassés, pai de Amom; Amom, pai de Josias; ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josias, pai de Jeconias e dos seus irmãos. (Nessa época o povo de Israel foi levado prisioneiro para a Babilônia). ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Depois do povo ter sido levado para a Babilônia, Jeconias foi pai de Salatiel; Salatiel, pai de Zorobabel; ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel, pai de Abiúde; Abiúde, pai de Eliaquim; Eliaquim, pai de Azor; ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor, pai de Sadoque; Sadoque, pai de Aquim; Aquim, pai de Eliúde; ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliúde, pai de Eleazar; Eleazar, pai de Matã; Matã, pai de Jacó; ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacó, pai de José. José foi marido de Maria, e Maria foi a mãe de Jesus, chamado Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Quatorze, portanto, é o número de gerações que separa Abraão de Davi. Quatorze, também, é o número de gerações que separa Davi do tempo em que o povo de Israel foi levado prisioneiro para a Babilônia. Quatorze, ainda, é o número de gerações que vai desde o cativeiro de Israel na Babilônia até o nascimento de Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","O nascimento de Jesus Cristo aconteceu assim: Maria, sua mãe, ia se casar com José. Antes de se casar, porém, Maria ficou grávida pelo poder do Espírito Santo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, seu futuro marido, resolveu romper o contrato de casamento sem dizer nada a ninguém, pois era um homem bom e não queria humilhar Maria. ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Enquanto José estava pensando nisso, um anjo do Senhor lhe apareceu em sonho e disse: —José, filho de Davi. Não tenha medo de receber Maria como esposa. É pelo poder do Espírito Santo que ela está grávida. ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ela terá um filho e você lhe dará o nome de Jesus, pois Ele irá salvar o seu povo dos pecados deles. ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tudo isto aconteceu para se cumprir o que o Senhor tinha dito pelo profeta: ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Olhem, a virgem vai ficar grávida e vai ter um filho, ao qual será dado o nome Emanuel”. (Emanuel quer dizer “Deus está conosco”.) ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Quando José acordou, fez o que o anjo do Senhor havia mandado. Ele recebeu Maria como esposa, ");
INSERT INTO por_WBTC_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","mas não tiveram nenhuma relação sexual até que o menino nascesse. E quando o menino nasceu, José lhe deu o nome de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus nasceu em Belém, na província da Judéia, no tempo em que Herodes era o rei. Nessa mesma época, alguns homens sábios, vindos do Oriente, chegaram a Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Os sábios perguntaram: —Onde está o menino que nasceu para ser o rei dos judeus? Nós vimos a sua estrela no Oriente e viemos para adorá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Quando o rei Herodes soube disso, ficou muito perturbado e todo o povo de Jerusalém também. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ele, então, mandou reunir todos os líderes dos sacerdotes e professores da lei, e lhes perguntava onde deveria nascer o Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Eles responderam: —Em Belém, na província da Judéia, pois foi isto que o profeta escreveu: ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“E você, Belém, da terra de Judá, de maneira nenhuma é a menor entre as principais cidades da Judéia. De você virá o líder que será o pastor do meu povo Israel”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodes, então, chamando os sábios em particular, descobriu o momento exato em que a estrela havia aparecido. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Depois, enviando-os para Belém, disse-lhes: —Vão e procurem o menino com todo o cuidado e, quando o encontrarem, venham me dizer, para que eu também possa ir adorá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Os sábios ouviram as palavras do rei e depois partiram para Belém. A estrela que eles tinham visto no Oriente foi adiante deles até que, chegando, parou sobre o lugar onde o menino estava. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Quando viram a estrela, os sábios sentiram grande e intensa alegria. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Eles entraram na casa e viram o menino com Maria, sua mãe. Então, ajoelhando-se, o adoraram. Depois, abriram as caixas que levavam e lhe ofereceram presentes: ouro, incenso e mirra. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Deus os avisou em sonho que não voltassem para onde Herodes estava e eles voltaram para sua terra por outro caminho. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Depois dos sábios terem ido embora, um anjo do Senhor apareceu a José num sonho e disse-lhe: —Levante-se! Pegue o menino e sua mãe e fuja para o Egito. Fique lá até eu lhe dizer que você pode voltar. Faça isso, pois Herodes vai procurar o menino para matá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","José se levantou, pegou o menino e sua mãe e partiu para o Egito durante a noite. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Eles ficaram no Egito até a morte de Herodes. Isto aconteceu para que se cumprisse o que o Senhor havia dito pelo profeta. “Eu chamei o meu Filho, e Ele veio da terra do Egito”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Quando Herodes percebeu que os sábios o tinham enganado, ficou furioso. Depois de calcular o tempo, de acordo com os dados fornecidos pelos sábios, mandou matar todos os meninos com menos de dois anos de idade que vivessem tanto em Belém como nos arredores. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Isso aconteceu para que se cumprissem as palavras ditas por Deus por meio do profeta Jeremias: ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Um som foi ouvido em Ramá, e esse som mostrava um choro sentido e uma grande tristeza. Era Raquel que chorava por seus filhos, não querendo ser consolada, pois eles já não existem”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Depois da morte de Herodes, um anjo do Senhor apareceu a José no Egito, durante um sonho, ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","e disse: —Levante-se! Pegue o menino e sua mãe e leve-os para Israel, pois as pessoas que queriam matar o menino já morreram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","José, então, se levantou, pegou o menino e a sua mãe e os levou para Israel. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mas quando soube que Arquelau reinava na Judéia no lugar do seu pai Herodes, teve medo de ir para lá. Entretanto, depois de ter sido avisado por Deus em sonho, partiu dali para a Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Eles foram morar numa cidade chamada Nazaré, para que assim se cumprisse o que Deus havia dito por meio dos profetas: “Ele será chamado nazareno”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Naquele tempo, João Batista apareceu e começou a proclamar no deserto da Judéia, ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","dizendo: —Arrependam-se, pois o reino do céu está próximo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Era a João Batista que o profeta Isaías estava se referindo quando disse: “Uma voz clama no deserto: Preparem o caminho para o Senhor, e abram estradas retas para Ele passar”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","João usava roupas feitas de pêlo de camelo e um cinto de couro amarrado na cintura e se alimentava com gafanhotos e mel silvestre. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Muita gente ia ouvir a mensagem de João; eram pessoas vindas de Jerusalém, de toda a província da Judéia e também de toda a região das redondezas do rio Jordão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Elas confessavam os seus pecados e eram batizadas por João Batista no rio Jordão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Quando João viu que muitos dos fariseus e saduceus estavam se aproximando para serem batizados por ele, disse-lhes: —Raça de cobras venenosas! Quem os avisou para escaparem do castigo que Deus vai mandar? ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Façam coisas que mostrem que vocês se arrependeram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Não comecem a dizer entre vocês mesmos: “Abraão é nosso pai”. Pois eu lhes digo que até destas pedras Deus é capaz de fazer descendentes de Abraão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","O machado está pronto para cortar as árvores pela raiz. Toda árvore que não produz bom fruto será cortada e jogada no fogo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","—Eu os batizo em água para arrependimento. Mas aquele que vem depois de mim os batizará com o Espírito Santo e com fogo. Ele é muito mais poderoso do que eu e eu não sou digno nem de lhe tirar as sandálias. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ele tem uma pá nas mãos e com ela vai separar o trigo da palha. O trigo será juntado em seu depósito, mas a palha será queimada com um fogo que nunca se apaga. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Naquela mesma época Jesus viajou da Galiléia para o rio Jordão e foi ao encontro de João Batista, pois queria que ele o batizasse. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","João, porém, queria impedi-lo, pois dizia: —Eu é que devo ser batizado pelo senhor e é o senhor que vem a mim pedindo que eu o batize? ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesus, entretanto, respondeu: —Deixe as coisas como estão por agora. Devemos fazer tudo o que é exigido por Deus. Então, depois de ouvir isto, João concordou em batizar Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesus foi batizado e, assim que se levantou da água, viu o céu se abrir e o Espírito de Deus descer sobre Ele na forma de uma pomba. ");
INSERT INTO por_WBTC_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","E uma voz vinda do céu disse: —Este é o meu Filho querido. Ele me dá muita alegria! ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Então, Jesus foi levado pelo Espírito para o deserto, a fim de ser tentado pelo Diabo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Depois de não comer nada durante quarenta dias e quarenta noites, Jesus teve fome. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","O tentador aproximou-se, então, dele e disse: —Se você é mesmo o Filho de Deus, mande estas pedras se transformarem em pão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesus, porém, respondeu: —As Escrituras dizem: “Nem só de pão vive o homem; mas de toda a palavra que procede de Deus”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","O Diabo levando-o depois para a cidade santa de Jerusalém, colocou-o sobre o ponto mais alto do templo ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","e lhe disse: —Se você é mesmo o Filho de Deus, atire-se daqui para baixo, pois as Escrituras dizem: “Deus dará ordens aos seus anjos para que cuidem de você. Eles vão segurá-lo com suas mãos para que nem os seus pés se machuquem nas pedras”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus, porém, respondeu: —Mas as Escrituras também dizem: “Não ponha o Senhor seu Deus à prova”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","A seguir o Diabo o tentou novamente, levando-o para um lugar muito alto. Ele lhe mostrou todos os reinos do mundo e toda a glória que eles tinham. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Depois, disse: —Eu lhe darei todas estas coisas se você se ajoelhar diante de mim e me adorar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesus lhe disse: —Vá embora daqui, Satanás! As Escrituras dizem: “Adore ao Senhor seu Deus, e sirva somente a Ele”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Depois disto, o Diabo o deixou e os anjos vieram e o serviram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Quando Jesus ouviu dizer que João tinha sido preso, voltou para a Galiléia, ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","mas não permaneceu em Nazaré. Ele foi viver em Cafarnaum, cidade próxima do lago da Galiléia, na região de Zebulom e Naftali. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Isto aconteceu para que se cumprisse o que tinha sido dito por Deus por meio do profeta Isaías: ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Terra de Zebulom e de Naftali! Caminho para o Mar Mediterrâneo e lado ocidental do rio Jordão! Galiléia dos que não são judeus! ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","O povo que vive na escuridão verá uma grande luz, e até os que vivem nas regiões sombrias da morte serão iluminados por esta luz”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Daí em diante, Jesus começou a proclamar a mensagem, dizendo: —Arrependam-se, pois o reino do céu está próximo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesus estava andando na beira do lago da Galiléia quando viu dois irmãos: Simão, também conhecido como Pedro, e André. Eles eram pescadores e estavam jogando suas redes no lago ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","quando Jesus lhes disse: —Sigam-me e eu os ensinarei a serem pescadores de pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","E, imediatamente, eles deixaram as suas redes e o seguiram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesus continuou caminhando e encontrou outros dois irmãos, Tiago e João, filhos de Zebedeu. Eles estavam no barco com seu pai, consertando as suas redes. Jesus os chamou ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","e eles, imediatamente, deixaram seu pai e o barco e o seguiram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus viajou por toda a província da Galiléia, ensinando nas sinagogas, proclamando as Boas Novas do reino de Deus e curando todo tipo de doença e de enfermidade entre o povo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A fama de Jesus se espalhou por toda a região da Síria e o povo levou a Ele todos os doentes que sofriam de vários tipos de doenças e males. Ele curou a todos: os que tinham dores, os que estavam possuídos por demônios, os epiléticos e os paralíticos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Muitas pessoas o seguiam—gente vinda da Galiléia, de Decápolis, de Jerusalém, da Judéia e também de toda a região situada do outro lado do rio Jordão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Quando Jesus viu a grande multidão, subiu para o alto de um monte e se sentou. Os seus discípulos se aproximaram ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","e Ele começou a ensiná-los, dizendo: ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Felizes os que reconhecem que precisam de Deus, pois o reino do céu é deles. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Felizes os que choram, pois Deus os consolará. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Felizes os humildes, pois eles herdarão a terra que Deus prometeu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Felizes os que têm fome e sede de justiça, pois ficarão completamente satisfeitos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Felizes os que têm misericórdia dos outros, pois receberão misericórdia. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Felizes os que têm coração puro, pois verão a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Felizes os que fazem a paz, pois serão chamados “filhos de Deus”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Felizes aqueles que são perseguidos por fazerem a vontade de Deus, pois a eles pertence o reino do céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","—Felizes serão vocês quando forem insultados, perseguidos e mesmo quando receberem todo tipo de calúnias pelo fato de me seguirem. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Alegrem-se e fiquem realmente muito felizes, pois grande é a recompensa que receberão no céu. Foi desta mesma maneira que os profetas que viveram antes de vocês também foram perseguidos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Vocês são o sal da terra! Se o sal, porém, perde o seu sabor, como poderá voltar a ser salgado? Ele não presta para mais nada! É jogado fora e pisado pelos que passam! ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","—Vocês são a luz do mundo! Uma cidade situada no alto de uma montanha não pode ser escondida. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Da mesma forma, ninguém acende um lampião para colocá-lo debaixo de um vaso, mas sim para colocá-lo em cima da mesa, para que possa iluminar a todos os que estão na casa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Que a luz de vocês brilhe diante das pessoas de tal forma que, ao verem as boas obras de vocês, elas dêem glória ao Pai que está no céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","—Não pensem que eu vim para acabar com a lei de Moisés ou com o ensino dos profetas. Não vim destruí-los, e sim dar o verdadeiro significado deles. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Digo a verdade a vocês: Enquanto o céu e a terra durarem, nem uma letra ou mesmo um único acento desaparecerá da lei até que todas as coisas aconteçam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Portanto, quem desobedecer o menor dos mandamentos e ensinar outras pessoas a fazerem o mesmo, será considerado o menor no reino do céu. Por outro lado, quem obedecer os mandamentos e ensiná-los a outras pessoas será considerado o maior no reino do céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Digo a verdade a vocês: A não ser que excedam os professores da lei e os fariseus em fazer o que Deus quer, jamais entrarão no reino do céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—Vocês ouviram que aos nossos antepassados foi dito isto: “Não mate” e “Quem matar alguém será levado a julgamento”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mas eu lhes digo: Qualquer um que ficar com raiva de uma outra pessoa será levado para julgamento. Qualquer que insultar uma outra pessoa será levado ao Conselho Superior. Quem chamar uma outra pessoa de “tolo” merece ser jogado no fogo do inferno. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","—Portanto, se você for até o altar para dar a sua oferta e se lembrar ali de que alguém tem alguma coisa contra você, ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","deixe a sua oferta lá mesmo, diante do altar. Primeiro vá e faça as pazes com aquela pessoa; depois volte e dê a sua oferta. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","—Entre em acordo sem demora com o seu adversário, enquanto você estiver a caminho com ele. Caso contrário, ele o entregará ao juiz, o juiz o entregará aos guardas e você será colocado na prisão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Digo a verdade a você: Não sairá de lá até que pague tudo o que deve. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—Vocês ouviram o que foi dito: “Não cometa adultério”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Eu, porém, lhes digo que todo aquele que olhar para uma mulher desejando possuí-la, já cometeu adultério em seu coração. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Portanto, se o seu olho direito faz com que você peque, arranque-o e jogue-o fora, pois é melhor que uma parte do seu corpo seja destruída do que todo o seu corpo seja atirado no inferno. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Da mesma forma, se a sua mão direita faz com que você peque, corte-a e jogue-a fora, pois é melhor que uma parte do seu corpo seja destruída do que todo o seu corpo ir para o inferno. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—E também foi dito: “Se alguém se separar de sua esposa deve dar-lhe carta de divórcio”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Eu, porém, lhes digo que qualquer um que se divorciar de sua esposa sem que ela seja culpada de imoralidade sexual, faz com que ela cometa adultério e quem se casar com ela também comete adultério. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Vocês também ouviram o que foi dito aos nossos antepassados: “Não quebre um juramento, mas cumpra o que você jurou ao Senhor que ia fazer”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Eu, porém, lhes digo: Não jurem por nada. Não jurem pelo céu, pois é o trono de Deus; ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nem pela terra, pois é onde Deus coloca os seus pés; nem por Jerusalém, que é a cidade do grande Rei. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Não jurem nem por suas próprias cabeças, pois vocês não são capazes de tornar um só fio de cabelo branco ou preto. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Vocês devem dizer somente “sim” ou “não”. O que passar disso vem do Diabo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","—Vocês também ouviram: “Olho por olho e dente por dente”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Eu, porém, lhes digo: Não se oponha aos perversos. Mas, ao contrário, se alguém lhe bater na face direita, vire-lhe também a esquerda. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Se alguém quiser processar você a fim de lhe tomar a capa, deixe que leve também a túnica. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Se alguém lhe obrigar a carregar uma carga por um quilômetro, leve-a por dois quilômetros. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Dê a quem lhe pedir alguma coisa e não vire as costas a quem lhe pedir emprestado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—Vocês também ouviram que foi dito: “Ame o seu próximo e odeie os seus inimigos”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Eu, porém, lhes digo: Amem os seus inimigos e orem por aqueles que perseguem a vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Dessa forma o Pai que está no céu os considerará seus filhos, pois Ele faz com que o seu Sol brilhe tanto para os bons como para os maus e manda suas chuvas tanto para os justos como para os injustos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Se vocês amarem somente às pessoas que amam a vocês, o que é que vocês ganham? Até mesmo os cobradores de impostos fazem isto! ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","E se cumprimentarem somente aos seus irmãos, o que fazem de mais? Até mesmo os que não crêem em Deus fazem isso. ");
INSERT INTO por_WBTC_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Portanto, sejam perfeitos assim como o Pai de vocês, que está nos céus, também o é. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","—Tenham cuidado! Não pratiquem boas obras em público somente para serem vistos pelos outros. Se vocês fizerem assim, não receberão nenhuma recompensa do Pai que está no céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Quando você der alguma coisa a um pobre, não espalhe para todo mundo o que fez. Os hipócritas é que fazem isso nas sinagogas e nas ruas, a fim de receberem elogios das pessoas. Digo a verdade a vocês: Eles já receberam a recompensa que mereciam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Você, entretanto, quando der alguma coisa aos pobres, não deixe nem que a sua mão esquerda fique sabendo o que a sua mão direita fez. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Assim a sua esmola vai ficar em segredo; e o seu Pai que vê tudo o que é feito em segredo lhe dará a recompensa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—E quando vocês orarem, não façam como os hipócritas, que gostam de orar de pé nas sinagogas e nas esquinas para poderem ser vistos pelo povo. Digo a verdade a vocês: Eles já receberam a recompensa que mereciam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Você, entretanto, quando orar, vá para o quarto, feche a porta e ore ao seu Pai, que não pode ser visto. E seu Pai, que vê o que você faz em segredo, lhe dará a recompensa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","—Quando vocês orarem, não repitam palavras que não significam nada, como os pagãos; pois eles pensam que por causa das suas muitas palavras Deus os ouvirá. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Portanto, não sejam como eles, pois o Pai de vocês sabe o que vocês precisam antes mesmo de vocês pedirem. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Quando vocês orarem, orem assim: “Pai nosso que está no céu. Que todos reconheçam que o seu nome é santo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Que o seu reino venha a nós. Que a sua vontade seja feita aqui na terra como no céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dê-nos hoje o pão nosso de cada dia. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Perdoe os nossos pecados assim como nós perdoamos aos que nos fazem mal. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Não nos deixe cair em tentação, mas livre-nos do mal”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Pois se vocês perdoarem as ofensas que as outras pessoas lhes fazem, o Pai de vocês que está no céu também lhes perdoará. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Se, entretanto, não perdoarem as ofensas dos outros, o Pai de vocês também não lhes perdoará as suas ofensas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Quando vocês jejuarem, não façam cara de doente como os hipócritas, que mudam o aspecto de seus rostos para que todos saibam que estão jejuando. Digo a verdade a vocês: Eles já receberam a recompensa que mereciam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Quando você jejuar, entretanto, penteie o cabelo e lave o rosto ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","para que ninguém fique sabendo que está jejuando. O seu Pai, a quem você não pode ver, verá que você está jejuando. E esse mesmo Pai, que vê tudo o que é feito em segredo, lhe dará a recompensa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—Não ajuntem riquezas neste mundo, onde a traça e a ferrugem as destruirão e onde os ladrões arrombam e as roubam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ao invés disso, ajuntem riquezas no céu, onde nem a traça nem a ferrugem as destruirão e nem os ladrões arrombam e as roubam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Lembrem-se disto: Onde estiver o seu tesouro, lá também estará o seu coração. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Os olhos são a fonte de luz para o corpo. Se os seus olhos forem bons, todo o seu corpo estará cheio de luz. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Se, porém, os seus olhos forem maus, todo o seu corpo estará na escuridão. Portanto, se a luz que há em vocês não passa de escuridão, então a escuridão que há em vocês é enorme. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Ninguém pode servir a dois senhores, pois ou odiará a um e amará o outro, ou se dedicará a um e desprezará o outro. Vocês não podem servir a Deus e ao mesmo tempo servir às riquezas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Por isso eu lhes digo: Não se preocupem com a comida ou com a bebida que precisam para viver ou mesmo com as roupas que precisam para se vestir. Pois a vida é mais importante do que comida e o corpo é mais importante do que roupas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Reparem nos pássaros do céu; eles não plantam nem colhem, nem juntam em celeiros. No entanto, o Pai de vocês que está no céu lhes dá o que comer. Será que vocês não valem mais do que eles? ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Qual de vocês, por mais que se preocupe, pode adicionar uma hora à sua vida? ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","E por que se preocupam por causa de roupas? Reparem nas flores do campo; elas não trabalham nem fazem roupas para si mesmas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Contudo eu lhes digo que nem mesmo o rei Salomão, com toda a sua riqueza, se vestiu como uma delas! ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Se Deus veste dessa maneira as plantas do campo, que hoje estão aqui e amanhã são jogadas no fogo, quanto mais Ele vestirá vocês, gente de pouca fé? ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","—Portanto, não fiquem preocupados, dizendo: “O que iremos comer?” ou “O que iremos beber?” ou ainda “Com o que iremos nos vestir?” ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Os pagãos é que estão sempre procurando todas essas coisas. Mas o Pai de vocês que está no céu sabe que vocês precisam delas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Portanto, ponham em primeiro lugar em suas vidas o reino de Deus e aquilo que Deus quer e Ele lhes dará todas estas outras coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Não se preocupem com o dia de amanhã, pois o dia de amanhã trará suas próprias preocupações. Para cada dia bastam os seus próprios problemas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—Não julguem os outros para que vocês também não sejam julgados. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pois da mesma maneira como vocês julgam os outros, também serão julgados e a medida que usarem para outros, essa será a mesma medida que Deus usará para vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","—Por que você olha o cisco que está no olho do seu irmão e não vê o tronco que está no seu próprio olho? ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Como é que pode dizer ao seu irmão: “Deixe-me tirar o cisco do seu olho” quando você mesmo tem um tronco no seu próprio olho? ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hipócrita! Tire primeiro o tronco que está no seu olho e então verá muito melhor para tirar o cisco do olho do seu irmão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Não dêem as coisas sagradas aos cães nem atirem as suas pérolas aos porcos, pois os porcos pisarão nas pérolas e os cães se virarão e atacarão a vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Peçam e lhes será dado; procurem e vocês acharão; batam e a porta lhes será aberta. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pois todo aquele que pede, recebe; todo aquele que procura, acha; e a porta se abre a todo aquele que bate. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","—Qual de vocês dará uma pedra a um filho se este lhe pedir pão? ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ou lhe dará uma cobra quando ele lhe pedir peixe? ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ora, se até mesmo vocês, que são maus, sabem dar coisas boas aos seus filhos, quanto mais o Pai que está no céu dará coisas boas a quem lhe pedir! ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Portanto, tratem as outras pessoas da mesma maneira que gostariam de ser tratados por elas. Este é o real significado da lei de Moisés e do ensino dos profetas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","—Entrem pelo portão estreito! O portão largo e a estrada fácil de passar conduzem à perdição e muita gente anda por ela. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pois estreito é o portão e apertado o caminho que conduz para a vida e pouca gente encontra essa estrada! ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—Tenham cuidado com os falsos profetas! Eles se aproximam de vocês disfarçados de ovelhas, mas por dentro são lobos selvagens. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Vocês os reconhecerão pelos frutos que eles produzirem. Pode-se por acaso colher uvas dos espinheiros ou figos das plantas espinhosas? ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Uma árvore boa produz bons frutos e uma árvore que não presta produz frutos ruins. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","A árvore que é boa não produz frutos ruins, nem a árvore que não presta produz bons frutos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Toda árvore que não produz bons frutos é cortada e lançada ao fogo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Assim, pois, vocês conhecerão as pessoas pelos frutos que elas produzem. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Nem todo o que me diz: “Senhor, Senhor” entrará no reino do céu, mas somente aquele que faz a vontade de meu Pai que está no céu! ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Quando aquele Dia chegar, muitas pessoas me dirão: “Senhor, Senhor! Não foi em seu nome que nós profetizamos? Também não foi em seu nome que expulsamos demônios? Não foi em seu nome, ainda, que fizemos muitos milagres?” ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Eu, porém, lhes direi abertamente: “Eu nunca os conheci! Afastem-se de mim, seus malfeitores!” ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Todo aquele que ouve estas minhas palavras e as obedece, pode ser comparado a um homem prudente que construiu a sua casa sobre a rocha. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Caíram as chuvas, vieram as enchentes e os ventos sopraram com força contra aquela casa, mas ela não desabou porque tinha sido construída sobre a rocha. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Porém, todo aquele que ouve estas minhas palavras e não as obedece, pode ser comparado a um homem tolo que construiu a sua casa sobre a areia. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Caíram as chuvas, vieram as enchentes e os ventos sopraram com força contra aquela casa e ela desabou completamente, sendo total a sua destruição. ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","—Quando Jesus acabou de falar essas coisas, todo o povo estava admirado com a sua maneira de ensinar, ");
INSERT INTO por_WBTC_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","pois Ele não os ensinava como os professores da lei, mas sim como quem tem autoridade. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Quando Jesus desceu do monte, uma grande multidão o seguiu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Então, um homem com lepra aproximou-se dele e, ajoelhando-se, disse: —Eu sei que, se quiser, o senhor pode curar-me. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesus estendeu a mão, tocou nele e disse: —Eu quero; fique curado! E, no mesmo instante, a lepra desapareceu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Então Jesus lhe disse: —Olhe, não conte nada disto a ninguém, mas apresente-se ao sacerdote e mostre-lhe que você está curado. Depois, ofereça o sacrifício que Moisés mandou, para provar que está curado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Quando Jesus entrou em Cafarnaum, um oficial romano se aproximou dele e lhe implorou: ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Senhor, o meu servo está em casa, de cama, sem poder se mexer e sofrendo dores horríveis. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus lhe disse: —Eu vou lá curá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","O oficial romano, então, lhe disse: —Eu não sou digno de que o senhor entre em minha casa. Dê apenas uma ordem e o meu servo ficará curado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Digo isto, pois também tenho superiores que me dão ordens e soldados a quem eu dou ordens. Eu digo a um “Vá” e ele vai; e a outro: “Venha” e ele vem. Da mesma forma digo ao meu servo: “Faça isto” e ele faz. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Quando Jesus ouviu isto, ficou admirado e disse aos que o acompanhavam: —Digo a verdade a vocês: Nem mesmo entre o povo de Israel encontrei alguém com uma fé tão grande como esta. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","E eu lhes digo ainda mais: Muitas pessoas virão do Oriente e do Ocidente e tomarão seus lugares à mesa no reino do céu juntamente com Abraão, com Isaque e com Jacó. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","E aquelas pessoas a quem esses lugares pertenciam anteriormente serão lançadas fora para a escuridão, onde irão chorar e ranger os dentes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Depois Jesus disse ao oficial: —Vá para casa. Seja feito conforme a sua fé. E nesse mesmo momento o seu servo foi curado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesus seguiu depois para a casa de Pedro e lá encontrou a sogra deste de cama e com muita febre. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesus tocou na mão dela e a febre a deixou. Ela, então, levantou-se e começou a servi-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Naquela tarde, muitas pessoas que estavam possuídas por demônios foram levadas a Jesus que, com sua ordem, os expulsou. Jesus também curou todos os doentes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Essas coisas aconteceram para que as palavras que Deus tinha dito por meio do profeta Isaías se cumprissem: “Ele levou as nossas doenças e carregou as nossas enfermidades”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Quando Jesus viu a multidão à sua volta, mandou seus discípulos irem para o outro lado do lago. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Um professor da lei se aproximou dele e disse: —Mestre, eu o seguirei aonde quer que o senhor vá. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mas Jesus respondeu: —As raposas têm tocas e as aves do céu têm ninhos, mas o Filho do Homem não tem onde descansar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Um outro discípulo de Jesus lhe disse: —Senhor, deixe-me primeiro ir enterrar meu pai. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mas Jesus falou: —Siga-me e deixe que os mortos enterrem os seus próprios mortos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesus entrou num barco e os seus discípulos o acompanharam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","De repente, uma grande tempestade agitou o lago e as suas ondas eram tão grandes que cobriam o barco. Entretanto, Jesus dormia. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mas os discípulos foram acordá-lo e disseram: —Salve-nos, Senhor, pois estamos prestes a morrer! ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesus, porém, lhes disse: —Por que vocês estão com tanto medo, homens de pouca fé? E, levantando-se, repreendeu o vento e o lago e tudo ficou calmo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Os discípulos ficaram muito espantados e diziam: —Que tipo de homem é este que até o vento e o lago lhe obedecem? ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Quando Jesus chegou ao país dos gadarenos, do outro lado do lago, dois homens que estavam possuídos por demônios foram ao seu encontro. Eles tinham saído dos túmulos e estavam tão furiosos que ninguém podia passar por aquele caminho. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Os dois homens se aproximaram de Jesus e gritaram: —O que o senhor quer conosco, Filho de Deus? Veio para nos castigar antes do tempo? ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Não muito longe dali havia uma grande manada de porcos comendo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Os demônios a seguir imploraram a Jesus: —Se vai nos obrigar a sair destes homens, então mande-nos entrar naqueles porcos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesus disse-lhes: —Vão! E os demônios, saindo dos homens, entraram nos porcos. Então, todos os porcos se atiraram morro abaixo, para dentro do lago, onde se afogaram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Os homens que tomavam conta dos porcos fugiram dali e foram para a vila. Ali contaram tudo isso e o que tinha acontecido com os homens que estavam possuídos pelos demônios. ");
INSERT INTO por_WBTC_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Então, toda a vila foi ao encontro de Jesus e, quando o viram, imploraram que Ele fosse embora da terra deles. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesus entrou no barco e atravessou novamente o lago, voltando para sua própria cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Algumas pessoas lhe trouxeram um paralítico deitado numa maca. Ao ver a fé que eles tinham, Jesus disse ao paralítico: —Coragem, meu filho! Os seus pecados estão perdoados. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Alguns professores da lei ouviram aquilo e começaram a comentar entre si: —Este homem está insultando a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus, porém, sabia o que eles estavam pensando e disse: —Por que estão pensando essas coisas malignas? ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","O que é mais fácil dizer ao paralítico: “Os seus pecados estão perdoados”, ou “Levante-se e ande”? ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mas eu vou lhes mostrar que o Filho do Homem tem poder na terra para perdoar pecados. E então disse ao paralítico: —Levante-se, pegue a sua maca e vá para casa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","E o homem que era paralítico levantou-se e foi para casa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Quando a multidão viu aquilo ficou com muito medo e deu glória a Deus por Ele ter dado tal poder aos homens. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Quando Jesus estava indo embora, viu um homem sentado no lugar onde se pagavam os impostos. O nome dele era Mateus. Jesus disse a ele: —Siga-me! Então Mateus se levantou e o seguiu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Quando Jesus estava comendo na casa de Mateus, muitos cobradores de impostos e pecadores também chegaram e tomaram lugar à mesa com Ele e seus discípulos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Quando os fariseus viram aquilo, perguntaram aos discípulos de Jesus: —Por que o mestre de vocês come com cobradores de impostos e com pecadores? ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesus, ouvindo a pergunta dos fariseus, respondeu-lhes: —Não são os que têm saúde que precisam de médico, mas sim os doentes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Vão e procurem entender o que quer dizer este trecho das Escrituras: “O que eu quero é bondade e não sacrifícios”. Pois eu não vim para chamar os justos, e sim os pecadores. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Os discípulos de João Batista se aproximaram então de Jesus e lhe perguntaram: —Por que é que tanto nós como os fariseus jejuamos muitas vezes enquanto que os seus discípulos não jejuam? ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus lhes respondeu: —Num casamento, os amigos do noivo não ficam tristes enquanto o noivo está com eles. Dias virão, porém, em que o noivo lhes será tirado e nesses dias eles jejuarão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","—Ninguém remenda uma roupa velha com retalho de pano novo pois, se o fizer, o pano novo encolhe e rasga a roupa velha, deixando o primeiro rasgo ainda pior. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Da mesma forma, ninguém coloca vinho novo em odres velhos, pois, se o fizer, os odres se arrebentarão, o vinho se derramará e os odres ficarão arruinados. Ao contrário, vinho novo é colocado em odres novos e ambos se conservam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mal Jesus tinha acabado de dizer essas coisas, quando um chefe da sinagoga aproximou-se dele e, ajoelhando-se, disse: —Minha filha acaba de morrer; mas venha e coloque as mãos sobre ela para que ela volte à vida. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesus, então, levantou-se e o seguiu. Os seus discípulos também foram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Enquanto caminhavam, uma mulher que há doze anos sofria de hemorragia aproximou-se por trás de Jesus e tocou na barra de sua roupa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ela fez aquilo porque pensava: —Se eu ao menos tocar em sua roupa, ficarei curada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus virou-se e, vendo a mulher, lhe disse: —Coragem, minha filha, a sua fé a curou. E desde aquele momento a mulher ficou curada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesus chegou à casa do chefe da sinagoga e viu algumas pessoas tocando música de enterro e o povo em alvoroço. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ao ver aquilo, Jesus disse: —Saiam todos! A menina não está morta; apenas dorme! Muitas pessoas começaram a caçoar dele por causa disso. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Depois de todos terem saído, Jesus entrou no quarto da menina, pegou-a pela mão e ela se levantou. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","E a notícia a respeito desse fato se espalhou por toda aquela região. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus estava indo embora quando dois cegos o seguiram. Eles gritavam: —Tenha misericórdia de nós, Filho de Davi! ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Assim que Jesus entrou na casa, os cegos se aproximaram dele e Jesus lhes perguntou: —Vocês crêem que eu posso realmente curá-los? E eles responderam: —Sim, senhor! ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesus tocou nos olhos deles e disse: —Que seja feito de acordo com a sua fé. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","E os olhos dos cegos se abriram. Jesus, entretanto, os avisou severamente, dizendo: —Não deixem que ninguém saiba disso! ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mas assim que eles saíram, espalharam as notícias a respeito de Jesus por toda aquela região. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Depois de eles terem ido embora, algumas pessoas levaram um homem até Jesus. Ele era mudo, pois estava possuído por um demônio. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Quando o demônio foi expulso, o homem começou a falar e toda a multidão, admirada, dizia: —Nunca se viu coisa igual a esta em Israel! ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Os fariseus, porém, diziam: —É o chefe dos demônios que lhe dá poder para expulsar demônios. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus viajava por todas as cidades e aldeias daquela região e ensinava nas suas sinagogas. Ele proclamava as Boas Novas do reino a todos e curava toda espécie de doenças e enfermidades. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Quando Jesus viu a multidão, teve muita pena, pois as pessoas pareciam aflitas e desamparadas, como ovelhas que não têm pastor. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jesus, então, disse aos seus discípulos: —A colheita é grande, mas os trabalhadores são poucos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Portanto, orem ao Senhor para que Ele mande mais trabalhadores para a sua colheita, pois Ele é o dono dos campos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus chamou os seus doze discípulos e lhes deu poder tanto para expulsarem demônios como para curarem toda espécie de doença e enfermidade. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Estes são os nomes dos doze apóstolos: Simão, também chamado Pedro e André, seu irmão; os irmãos Tiago e João, filhos de Zebedeu; ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipe; Bartolomeu; Tomé; Mateus, o cobrador de impostos; Tiago, filho de Alfeu; Tadeu; ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simão, o zelote; e Judas Iscariotes, que traiu Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesus enviou estes doze homens com a seguinte ordem: —Não entrem em nenhuma cidade cujo povo não seja judeu, nem em nenhuma das cidades dos samaritanos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ao invés disso, procurem as pessoas da nação de Israel, que são como ovelhas perdidas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Vão e proclamem esta mensagem: “O reino do céu está próximo!” ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Curem os leprosos e os outros doentes, ressuscitem os mortos e expulsem os demônios. Vocês receberam este poder de graça, portanto façam tudo isso de graça. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Vocês não devem levar nenhum dinheiro—nem ouro, nem prata, nem cobre, ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","e nem sacola de viagem. Também não devem levar nem roupas extras, nem sandálias, nem cajado. Digo isto porque todo trabalhador merece receber o seu alimento. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—Quando vocês chegarem a uma cidade ou a uma vila, procurem uma pessoa de confiança e fiquem com ela até a hora de irem embora. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Quando vocês entrarem numa casa, cumprimentem as pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Se as pessoas da casa forem dignas, que a paz que vocês desejarem a elas ao cumprimentá-las permaneça sobre elas. Mas se não forem dignas, que a sua paz volte para vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Se alguma casa ou alguma cidade se recusar a recebê-los ou a ouvir o que vocês têm para dizer, então saiam de lá. E quando vocês estiverem indo embora, sacudam a poeira de suas sandálias, como uma advertência para aquela gente. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Digo a verdade a vocês: No Dia do Julgamento haverá mais tolerância para com o povo das cidades de Sodoma e de Gomorra do que para com as pessoas daquela cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Escutem, eu estou enviando vocês como ovelhas para o meio de lobos. Sejam, portanto, espertos como cobras e simples como pombas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tenham cuidado com as pessoas, pois elas vão levá-los aos tribunais e vão chicoteá-los em suas sinagogas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Vocês serão levados para serem julgados diante de governadores e de reis por minha causa, e lá vocês terão oportunidade de testemunhar tanto aos judeus como também aos que não são judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Quando forem presos, não se preocupem nem com “o que” vocês vão falar nem com “a maneira pela qual” vocês vão falar. Quando chegar a hora certa, lhes será dito o que vocês devem falar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Lembrem-se de que não serão vocês que estarão falando, mas sim que o Espírito do Pai é que estará falando por intermédio de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","—Algumas pessoas entregarão seus próprios irmãos para serem mortos e outras entregarão seus próprios filhos. Filhos se voltarão contra seus pais e os matarão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Vocês serão odiados por todos por causa do meu nome, mas aquele que permanecer firme até o fim será salvo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Quando vocês estiverem sendo perseguidos numa cidade, fujam para outra, pois eu lhes digo que o Filho do Homem voltará antes que vocês consigam percorrer todas as cidades de Israel. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","—Nenhum discípulo é mais importante do que o seu mestre, nem nenhum escravo é mais importante do que o seu senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","O discípulo deve ficar satisfeito em ser como o seu mestre e o escravo em ser como o seu senhor. Se até mesmo o chefe da família é chamado de Belzebu, quanto mais os membros da família? ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Não tenham medo dos homens, pois não há nada que esteja oculto e que não venha a ser revelado, nem nada que esteja escondido que não seja descoberto. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Eu quero que vocês digam à luz do dia o que estou dizendo às escuras e que gritem em voz alta o que estou dizendo em particular. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Não tenham medo daqueles que podem matar o corpo, mas não podem matar a alma. Mas antes, tenham medo daquele que pode destruir no inferno tanto a alma como o corpo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Vocês podem comprar dois pardais por um centavo, mas nem um só deles cai no chão sem a permissão do Pai de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Até mesmo os fios de cabelo de suas cabeças estão contados! ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Por isso, não tenham medo. Vocês valem muito mais do que muitos pardais. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Se alguém afirmar publicamente ser meu seguidor, então eu também afirmarei diante de meu Pai que está no céu que tal pessoa é meu seguidor. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mas aquele que me negar publicamente, eu também o negarei diante de meu Pai que está no céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Não pensem que vim trazer paz ao mundo. Não vim trazer paz, mas sim espada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Eu vim para fazer com que estas coisas aconteçam: “Filhos se voltarão contra seus pais, filhas contra suas mães e noras contra suas sogras. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Os piores inimigos de uma pessoa serão os membros de sua própria família”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Quem ama a seu pai ou a sua mãe mais do que a mim, não é digno de mim; e quem ama a seu filho ou a sua filha mais do que a mim, não é digno de mim. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Quem não tomar a sua cruz e me seguir, não é digno de mim. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aquele que quiser salvar a sua vida, irá perdê-la; mas aquele que perder sua vida por minha causa, irá salvá-la. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—Quem recebe a vocês, recebe também a mim; e quem me recebe, recebe aquele que me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Quem recebe um profeta pelo fato de ele ser profeta, receberá a recompensa de profeta. Quem recebe a um homem justo pelo fato de ele ser justo, receberá a recompensa de justo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","E lhes digo também isto: Qualquer pessoa que der mesmo que seja um copo de água fria a qualquer um destes pequeninos, que são meus seguidores, por causa do meu nome, sem dúvida que também receberá a sua recompensa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Quando Jesus terminou de dar essas instruções a seus doze discípulos, partiu dali e foi ensinar e proclamar a sua mensagem nas cidades deles. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Quando João, que estava na prisão, ouviu falar a respeito de todas as coisas que Jesus estava fazendo, mandou seus discípulos perguntarem-lhe: ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—O senhor é aquele que ia vir, ou ainda devemos esperar por outro? ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","E Jesus lhes respondeu: —Vão e digam a João Batista tudo o que vocês estão vendo e ouvindo, isto é: ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Os cegos vêem, os coxos estão andando normalmente, os leprosos são curados, os surdos ouvem, os mortos são ressuscitados e os pobres ouvem as Boas Novas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Feliz é aquele que não vê dificuldade em me aceitar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Quando os discípulos de João Batista estavam indo embora, Jesus se dirigiu às multidões e começou a falar a respeito de João, dizendo: —O que vocês esperavam ver no deserto quando foram ao encontro de João? Uma cana sacudida pelo vento? ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","O que vocês foram ver? Um homem vestido com roupas finas? Ora, os homens vestidos com roupas finas são encontrados nos palácios e não no deserto! ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mas o que é que vocês foram ver? Um profeta? Sim, e eu lhes digo que o homem que vocês viram é muito mais do que um profeta! ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","João é aquele a respeito de quem está escrito: “Aqui está o meu mensageiro que envio antes de você, e ele vai à sua frente para preparar o caminho para você”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","—Digo-lhes a verdade: De todos os homens que nasceram, não há nenhum que seja mais importante do que João Batista. E ainda assim, o menor no reino do céu é maior do que ele. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Desde a época em que João Batista começou a anunciar as Boas Novas até agora, o reino do céu tem sofrido muito. Ele tem sido atacado violentamente por homens malvados que tentam conquistá-lo à força. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tanto os profetas como a lei de Moisés profetizaram somente até à época em que João Batista veio, ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","e se vocês querem aceitar o que a lei e o que os profetas disseram, João Batista é o Elias que estava para vir. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Quem pode ouvir, ouça. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","—Com o que eu poderia comparar esta gente de hoje? São como grupos de crianças que, sentadas na praça, gritam umas às outras: ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Nós tocamos músicas alegres e vocês não dançaram; cantamos músicas tristes e vocês não choraram!” ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Isto ocorreu também com João Batista. Ele jejuava e não bebia vinho e, mesmo assim, as pessoas diziam: “Ele tem demônio!” ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Depois veio o Filho do Homem. Ele come, bebe vinho e as pessoas dizem: “Olhem para este homem! Não passa de um comilão e beberrão! Ele é amigo de cobradores de impostos e pecadores”. A sabedoria, entretanto, encontra sua razão de ser em suas obras. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Depois Jesus começou a acusar as cidades nas quais tinha feito numerosos milagres, pois os seus moradores não tinham se arrependido de seus pecados. Ele dizia: ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Ai de você, cidade de Corazim! Ai de você, cidade de Betsaida! Digo isto pois, se os milagres que foram feitos aí tivessem sido feitos nas cidades de Tiro e de Sidom, há muito que o povo daquelas cidades já teria se arrependido e mostrado o seu arrependimento usando roupas de saco e derramado cinzas sobre suas cabeças. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mas eu lhes digo que no Dia do Julgamento haverá mais tolerância para com as cidades de Tiro e de Sidom do que para com vocês! ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","E você, cidade de Cafarnaum, pensa que será elevada até o céu? Você será jogada no lugar dos mortos. Digo isto pois, se os milagres que foram feitos aí tivessem ocorrido na cidade de Sodoma, ela ainda existiria hoje! ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mas eu lhes digo que no Dia do Julgamento haverá mais tolerância para com o povo da cidade de Sodoma do que para com vocês! ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Naquela ocasião Jesus disse: —Pai, Senhor do céu e da terra! Eu lhe agradeço por ter escondido estas coisas dos sábios e dos entendidos e por tê-las mostrado aos que são simples. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Sim, Pai, pois esta era a sua vontade. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","—Todas as coisas foram dadas a mim pelo meu Pai. Ninguém conhece o Filho, a não ser o Pai; e ninguém conhece o Pai a não ser o Filho e aqueles a quem o Filho o quiser revelar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Venham a mim todos vocês que estão cansados ou sobrecarregados e eu lhes darei descanso. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Aceitem o meu jugo e aprendam de mim, pois eu sou bondoso e tenho espírito humilde. Dessa forma vocês encontrarão descanso para as suas almas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Eu digo isso pois o meu jugo é suave e a carga que lhes dou para carregar é leve. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Naquela mesma época, num sábado, Jesus estava atravessando um campo de trigo. Seus discípulos tiveram fome e então começaram a colher algumas espigas e a comê-las. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Quando os fariseus viram aquilo, disseram a Jesus: —Olhe! Os seus discípulos estão fazendo o que não é permitido fazer no sábado! ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesus, porém, lhes perguntou: —Por acaso vocês nunca leram o que Davi e seus companheiros fizeram quando estavam com fome? ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Davi entrou na casa de Deus e, tanto ele como os seus companheiros comeram dos pães consagrados a Deus, os quais não era permitido comer, nem a ele nem aos seus companheiros. Somente os sacerdotes podiam comê-los. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ou, por acaso, vocês também nunca leram na lei de Moisés que os sacerdotes que ficam no templo em dia de sábado desobedecem a lei e ficam sem culpa? ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pois eu lhes digo que aqui está alguém que é maior do que o templo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Se vocês soubessem o que as Escrituras significam quando dizem: “Eu quero compaixão entre as pessoas e não sacrifícios de animais”, não condenariam pessoas inocentes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","O Filho do Homem é Senhor do sábado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesus saiu dali e foi para a sinagoga deles. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Havia ali um homem que tinha uma das mãos aleijada. Alguns judeus, então, se aproximaram de Jesus e perguntaram: —É permitido curar alguém no sábado? (Eles tinham perguntado aquilo pois queriam arranjar um meio de acusar Jesus de desobedecer a lei.) ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mas Jesus lhes disse: —Suponhamos que um de vocês tenha uma ovelha e que ela caia num barranco num sábado. Será que você não se esforçará para tirá-la de lá? ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ora, não vale uma pessoa muito mais do que uma ovelha? Portanto, é permitido fazer o bem no sábado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Depois Jesus dirigiu-se ao homem que tinha a mão aleijada e disse-lhe: —Estenda a sua mão. E quando o homem a estendeu, ela sarou completamente, ficando igual à outra. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Os fariseus foram embora e começaram a fazer planos para matar a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Quando Jesus descobriu o que os fariseus queriam fazer contra Ele, saiu dali. Muitas pessoas o seguiram e Ele curou todos os doentes, ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","e recomendou para que não contassem a ninguém quem Ele era. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Isto aconteceu para que se cumprisse o que foi dito por Deus por meio do profeta Isaías: ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Aqui está o meu servo! Fui eu que o escolhi! Eu o amo, e Ele me dá muita alegria. Porei nele o meu Espírito, e Ele proclamará justiça para todas as nações. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ele não discutirá nem gritará, e ningéum ouvirá a sua voz nas praças. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ele não quebrará o ramo que já está trincado, e nem tampouco apagará a luz que já está fraca. Ao contrário! Ele persistirá até que a justiça triunfe. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","E então, todas as nações depositarão nele suas esperanças”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Depois disto, algumas pessoas levaram até Jesus um homem cego e mudo, pois estava possuído por um demônio. Jesus o curou e ele passou a falar e a ver. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Todas as pessoas ficaram muito admiradas e começaram a dizer: —Será que este homem é o Filho de Davi? ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Quando os fariseus ouviram o que o povo estava falando, disseram: —É pelo poder de Belzebu, o chefe dos demônios, que ele expulsa os demônios. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus, porém, sabia o que eles estavam pensando e disse: —Todo reino que se divide contra si mesmo ficará arruinado. E toda cidade ou família que se divide contra si mesma não pode durar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Se Satanás expulsa o próprio Satanás, isto quer dizer que o seu reino está dividido contra si mesmo. Como pode o seu reino continuar a existir? ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Se é verdade que eu expulso demônios pelo poder de Belzebu, então pelo poder de quem é que os expulsam aqueles que seguem a vocês? Assim, os seus próprios seguidores provam que vocês estão completamente errados. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Porém, se eu expulso demônios pelo poder do Espírito de Deus, isso prova que o reino de Deus chegou até vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ou, como poderia alguém entrar na casa de um homem forte e lhe roubar tudo o que tem sem primeiro prendê-lo? Somente depois de prender o homem forte é que ele será capaz de roubar a casa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—Aquele que não está a meu favor, está contra mim; e aquele que não me ajuda a ajuntar, espalha. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","É por isso que eu lhes digo: As pessoas serão perdoadas por todo pecado e insulto, mas o insulto contra o Espírito não será perdoado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Quem fala mal do Filho do Homem será perdoado, mas quem fala mal do Espírito Santo não será perdoado, nem neste mundo nem no mundo que há de vir. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","—Para vocês terem bons frutos, vocês devem ter uma árvore boa. Se a árvore não presta, seus frutos também não prestarão. É pelos frutos que se conhece a árvore. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Raça de cobras venenosas! Como podem dizer coisas boas sendo maus? A boca fala daquilo que o coração está cheio. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A pessoa boa tira coisas boas do bem que tem acumulado em si, enquanto que a pessoa má tira coisas más do mal que tem acumulado em si. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Eu lhes digo isto: No Dia do Julgamento todas as pessoas terão de prestar contas de todas as coisas inúteis que disseram; ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","pois pelas suas palavras você será declarado justo ou condenado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Depois, alguns professores da lei e alguns fariseus pediram a Jesus: —Mestre, nós queremos que o senhor faça um milagre que possamos ver. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus, porém, lhes disse: —As pessoas de uma geração má e infiel andam à procura de um sinal. Mas nenhum sinal lhes será dado, a não ser o sinal dado ao profeta Jonas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pois assim como Jonas esteve três dias e três noites na barriga do grande peixe, também o Filho do Homem estará três dias e três noites no fundo da terra. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","No Dia do Julgamento o povo da cidade de Nínive vai se levantar com as pessoas desta geração e vai condená-las, pois o povo se arrependeu dos seus pecados quando ouviu a mensagem de Jonas. E eu afirmo que quem está aqui agora é superior a Jonas! ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","No Dia do Julgamento, a Rainha do Sul vai se levantar com as pessoas desta geração e condená-las, pois ela veio do outro lado do mundo para ouvir a sabedoria de Salomão. E eu afirmo que quem está aqui agora é superior a Salomão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","—Quando um demônio sai de uma pessoa, ele atravessa lugares desertos à procura de descanso. Como não encontra, ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","diz: “Voltarei para a casa de onde vim”. Quando ele volta, encontra a casa vazia, limpa e arrumada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Então, sai e vai buscar outros sete demônios piores ainda do que ele e ali vão viver. Assim, o último estado daquela pessoa se torna ainda pior do que o primeiro. E isso é exatamente o que vai acontecer com as pessoas más de hoje. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus ainda estava falando para a multidão quando sua mãe e seus irmãos chegaram. Eles ficaram do lado de fora, mas pediram para falar com Ele. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Alguém, então, disse a Jesus: —Sua mãe e seus irmãos estão lá fora, pedindo para falar com o senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesus, então, respondeu: —Quem é a minha mãe e quem são os meus irmãos? ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","E apontando para os seus discípulos, disse: —Aqui estão a minha mãe e os meus irmãos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Todo aquele que faz a vontade do meu Pai que está no céu é meu irmão, minha irmã e minha mãe. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Naquele mesmo dia Jesus saiu de casa e se sentou à beira do lago. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Uma grande multidão se juntou ao seu redor. Havia tanta gente que Jesus entrou num barco e se sentou; e toda a multidão permanecia de pé na praia. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesus lhes ensinou muitas coisas por meio de parábolas. Ele dizia: —Certo homem saiu para semear. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Enquanto semeava, uma parte das sementes caiu à beira do caminho e os pássaros vieram e as comeram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Outra parte caiu no meio de pedras, onde havia pouca terra. Essas sementes brotaram depressa pois a terra não era funda, ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","mas, quando o sol apareceu, elas secaram, pois não tinham raízes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Outra parte das sementes caiu no meio de espinhos, os quais cresceram e as sufocaram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Uma outra parte ainda caiu em terra boa e deu frutos, produzindo 30, 60 e até mesmo 100 vezes mais do que tinha sido plantado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Quem pode ouvir, ouça. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Os discípulos de Jesus, então, se aproximaram dele e lhe perguntaram: —Por que o senhor ensina o povo por meio de parábolas? ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","E Jesus lhes respondeu: —Somente a vocês é dado o privilégio de conhecer as verdades secretas do reino do céu e não aos outros. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pois quem tem, receberá ainda mais e terá em abundância. Mas quem não tem, até o que tem lhe será tirado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","E é por isto que ensino o povo por meio de parábolas: Eles olham, mas não vêem; ouvem, mas não entendem. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Portanto, por intermédio deles acontece o que disse o profeta Isaías: “Vocês ouvirão mas, mesmo ouvindo, não conseguirão entender; vocês olharão mas, mesmo olhando, não conseguirão ver. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Isto acontece pois o coração deste povo está endurecido. Eles taparam os ouvidos e fecharam os olhos. Se não fosse assim, eles poderiam ver com os olhos, ouvir com os ouvidos e entender com o coração, e se voltariam para mim e eu os curaria”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","—Mas felizes são os seus olhos, pois eles podem ver; e os seus ouvidos, pois eles podem ouvir. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Digo a verdade a vocês: Muitos profetas e homens justos desejaram ver as coisas que vocês vêem, mas não viram. Eles desejaram ouvir o que vocês ouvem, mas não ouviram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","—Ouçam o que a parábola daquele que semeia quer dizer. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","A semente que caiu à beira do caminho representa a pessoa que ouve a mensagem a respeito do reino, mas não a compreende, e Satanás então vem e tira as coisas que foram semeadas em seu coração. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","A semente que caiu no meio de pedras representa a pessoa que ouve a mensagem a respeito do reino e a aceita imediatamente e com muita alegria. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mas, como não tem raiz, não dura muito tempo. Assim que encontra dificuldades ou que é perseguida por causa da mensagem, abandona a sua fé. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A semente que caiu no meio de espinhos representa a pessoa que ouve a mensagem a respeito do reino mas é sufocada pelas preocupações com as coisas desta vida e pela ilusão das riquezas. Essa pessoa não produz nenhum fruto. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mas a semente que caiu em terra boa representa a pessoa que ouve a mensagem e a compreende. Essa pessoa cresce e produz muitos frutos, algumas vezes trinta, outras sessenta e outras ainda cem vezes mais. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus depois lhes disse esta outra parábola: —O reino do céu é como um homem que semeou boa semente na sua terra. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mas naquela noite, enquanto todos estavam dormindo, o seu inimigo veio, semeou joio no meio do trigo e foi-se embora. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mais tarde, quando as plantas cresceram e se formaram as espigas, o joio também apareceu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Então, os servos do homem aproximaram-se dele e perguntaram-lhe: “O senhor semeou boa semente em sua terra, não é verdade? Então de onde veio este joio?” ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","E o homem lhes respondeu: “Foi algum inimigo que fez isto”. Os servos, então, perguntaram: “O senhor quer que arranquemos o joio?” ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","E o homem respondeu: “Não, pois quando vocês forem arrancar o joio poderão arrancar também o trigo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Deixem que ambos cresçam juntos. Quando chegar a época da colheita eu direi aos ceifeiros: ‘Apanhem primeiro o joio, amarrem-no em feixes e atirem-no ao fogo. Depois, arranquem o trigo e o levem para o celeiro’”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus contou ainda outra parábola: —O reino do céu é como uma semente de mostarda que um homem semeou em sua terra. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ela é a menor de todas as sementes mas, quando cresce, transforma-se na maior de todas as hortaliças; ela se transforma numa árvore e as aves do céu fazem ninhos em seus ramos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesus, então, lhes disse uma outra parábola: —O reino do céu é como fermento que uma mulher pega e mistura com três medidas de farinha até que tudo fique fermentado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus ensinou todas essas coisas ao povo por meio de parábolas, e não lhes dizia nada a não ser por meio delas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Isso aconteceu para que se cumprisse o que foi dito por Deus por meio do profeta: “Eu falarei mediante parábolas, e explicarei coisas que são desconhecidas desde o princípio do mundo”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesus, então, despedindo as multidões, foi para casa. Os discípulos se aproximaram dele e pediram: —Explique-nos a parábola do joio no campo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","E Jesus lhes disse: —Aquele que planta boa semente é o Filho do Homem. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","O campo é o mundo. A boa semente são as pessoas que pertencem ao reino e o joio são as pessoas que pertencem ao Maligno. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","O inimigo que semeia o joio é o próprio Diabo. A colheita é o fim dos tempos e os ceifeiros são os anjos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Assim como o joio é arrancado e jogado ao fogo, assim também será no fim dos tempos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","O Filho do Homem enviará os seus anjos e eles arrancarão do seu reino todas as pessoas que fazem com que os outros pequem e também todos os que praticam a maldade. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","E os anjos jogarão essas pessoas na fornalha acesa, onde elas vão chorar e ranger os dentes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Então os justos brilharão como o sol no reino do Pai. Quem pode ouvir, ouça. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","—O reino do céu é como um tesouro que foi enterrado num campo. Certo homem o encontrou e, de tão feliz que ficou, escondeu-o de novo, foi e vendeu tudo o que tinha e comprou aquele campo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","—O reino do céu também é como um homem que negocia e procura boas pérolas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Quando encontrou uma pérola que era realmente muito valiosa, foi, vendeu tudo o que tinha e comprou aquela pérola. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—O reino do céu ainda é como uma rede que, quando jogada no mar, recolheu peixes de todos os tipos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Quando a rede ficou cheia, os pescadores a puxaram para a praia e, sentados, escolheram os peixes, colocando os bons em cestos e jogando os ruins fora. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","No fim dos tempos também será assim: Os anjos virão para separar as pessoas más das pessoas justas ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","e depois vão jogar os maus na fornalha acesa, onde eles vão chorar e ranger os dentes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus perguntou, então, aos seus discípulos: —Vocês entenderam as coisas que eu acabei de dizer? E eles responderam: —Sim, entendemos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","E Jesus lhes disse: —É por isso que todo professor da lei, quando aprende a respeito do reino do céu, se torna semelhante a um pai de família que tira de seu depósito tanto coisas novas como coisas velhas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Quando Jesus terminou de ensinar essas parábolas, deixou aquele lugar ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","e partiu para a sua cidade natal. Ele começou a ensinar na sinagoga deles e todos ficaram muito admirados e perguntavam: —Onde ele conseguiu essa sabedoria e esse poder de fazer milagres? ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Esse homem não é o filho do carpinteiro? O nome da mãe dele não é Maria? Ele não é irmão de Tiago, de José, de Simão e de Judas? ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Não vivem as suas irmãs aqui conosco? Então de onde é que ele conseguiu tudo isso? ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","E não queriam saber dele. Mas Jesus lhes disse: —Todo profeta é respeitado em toda parte, menos em sua própria terra e em sua própria casa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","E Jesus não fez muitos milagres lá, pois o povo não tinha fé. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Naquele tempo Herodes, que era o governador da Galiléia, ouviu falar a respeito de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Então, disse aos seus empregados: —Esse homem é João Batista! Ele ressuscitou dos mortos e é por isso que tem esse poder para fazer milagres. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","(Herodes é quem tinha mandado prender João, amarrá-lo e colocá-lo na prisão. Ele tinha feito isto por causa de sua cunhada Herodias, esposa de seu irmão Filipe.) ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","João tinha dito várias vezes a Herodes: “Você não pode viver com a esposa de seu irmão, pois isso é errado”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes queria matar João mas tinha medo dos judeus, pois eles o consideravam profeta. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","No dia do aniversário de Herodes, a filha de Herodias dançou para ele e para os seus convidados e agradou muito a Herodes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Herodes, então, prometeu-lhe com juramento dar-lhe qualquer coisa que ela pedisse. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mas a moça, instigada por sua mãe, pediu-lhe: —Eu quero que o senhor me dê a cabeça de João Batista num prato. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodes ficou muito triste, mas por causa do juramento que tinha feito diante de seus convidados, determinou que dessem à moça o que ela tinha pedido, ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","e mandou que cortassem a cabeça de João Batista na prisão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A cabeça de João foi levada num prato e entregue à jovem que, por sua vez, a entregou à mãe. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Os discípulos de João vieram e, levando o corpo, o enterraram. Depois foram e contaram a Jesus o que tinha acontecido. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Quando Jesus ficou sabendo o que tinha acontecido, saiu dali num barco e foi sozinho para um lugar isolado. Quando a multidão soube disso, deixou os povoados e o seguiu por terra. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Quando Jesus saiu do barco e viu a grande multidão, teve muita pena do povo e curou os doentes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ao anoitecer, os discípulos de Jesus se aproximaram e lhe disseram: —Este lugar é isolado e já é tarde; despeça estas pessoas para que elas possam chegar até as vilas próximas e comprar comida para si. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesus, porém, lhes disse: —Essa gente não precisa ir embora; por que vocês mesmos não lhes dão alguma coisa para comer? ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Eles, no entanto, responderam: —Mas tudo o que temos são cinco pães e dois peixes! ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesus, então, disse: —Tragam os pães e os peixes aqui. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Depois mandou que a multidão se sentasse na grama. A seguir, Jesus pegou os cinco pães e os dois peixes, olhou para o céu e agradeceu a Deus pelo alimento. Então, partiu os pães, deu-os aos discípulos que os distribuíram entre a multidão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Todos comeram e ficaram satisfeitos e os discípulos recolheram ainda doze cestos cheios dos pedaços que sobraram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Os que comeram foram mais ou menos cinco mil homens, sem contar as mulheres e as crianças. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Logo depois, Jesus mandou que seus discípulos entrassem no barco e partissem para o outro lado do lago da Galiléia, enquanto Ele despedia a multidão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Quando a multidão foi embora, Jesus subiu sozinho para o monte a fim de orar. A noite veio e Jesus permanecia ali, sozinho. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","O barco, no entanto, já se encontrava há vários quilômetros da praia e estava sendo sacudido pelas ondas, pois o vento soprava contra ele. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Entre três e seis horas da madrugada, Jesus foi ao encontro deles andando em cima do lago. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Os discípulos, porém, quando o viram andando por sobre a água do lago, ficaram apavorados e disseram: —É um fantasma!—e gritaram de medo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","E nesse instante Jesus lhes disse: —Coragem, sou eu! Não tenham medo! ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mas Pedro disse: —Se é o senhor mesmo, Senhor, mande que eu vá andando em cima da água até onde está. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","E Jesus lhe disse: —Venha! E Pedro, saindo do barco, andou em cima da água em direção a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Porém, ao sentir o forte vento, Pedro teve medo e começou a afundar e gritou: —Salve-me, Senhor! ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","E Jesus imediatamente estendeu a sua mão e, segurando-o, disse-lhe: —Como a sua fé é pequena! Por que é que você duvidou? ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","E ao entrarem ambos no barco o vento parou de soprar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Os que estavam no barco o adoraram e disseram: —Realmente o senhor é o Filho de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Depois de terem atravessado o lago, eles chegaram à praia, em Genesaré. ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Quando os habitantes daquele lugar o reconheceram, mandaram avisar toda aquela região sobre a sua chegada. As pessoas, então, levaram a Ele todos os que estavam doentes ");
INSERT INTO por_WBTC_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","e lhe imploraram para que deixasse ao menos tocarem na barra de sua roupa. E todos os que tocaram ficaram curados. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Alguns fariseus e professores da lei de Jerusalém se aproximaram de Jesus e lhe perguntaram: ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Por que os seus discípulos quebram as tradições dos anciãos? Pois eles não lavam as mãos antes de comer. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus, porém, lhes respondeu: —Por que vocês desobedecem aos mandamentos de Deus, seguindo as suas próprias tradições? ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Porque Deus disse: “Honre a seu pai e a sua mãe” e “Quem quer que insulte a seu pai ou a sua mãe deve ser punido com a morte”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","—Mas vocês dizem que qualquer um que disser a seu pai ou a sua mãe: “Eu não posso ajudá-lo, pois tudo o que tenho está dedicado a Deus”, ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","não precisa honrar a seus pais. Vocês têm anulado a palavra de Deus por causa de suas tradições! ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hipócritas! Isaías estava certo quando profetizou a respeito de vocês e disse: ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Esse povo me honra com suas palavras, mas o seu coração está longe de mim. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","E em vão me adoram, ensinando coisas que são mandamentos de homens”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Então, chamando a multidão, Jesus lhes disse: —Ouçam e entendam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Não é o que entra pela boca de uma pessoa que a contamina, mas sim o que sai dela. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Os discípulos de Jesus, então, se aproximaram dele e disseram: —Sabe que os fariseus ficaram ofendidos quando ouviram o que o senhor disse? ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mas Jesus lhes respondeu: —Toda planta que meu Pai que está no céu não plantou será arrancada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Não se preocupem com eles, pois são cegos, guiando outros cegos. E se um cego guiar outro cego, ambos cairão no buraco! ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro, porém, pediu: —Explique-nos o significado do que o senhor acabou de dizer. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mas Jesus disse: —Vocês também ainda não entendem? ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Vocês não entendem que tudo o que entra pela boca vai para o estômago e depois sai do corpo? ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","O que sai da boca vem do coração e é isso o que contamina a pessoa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pois é do coração que vêm todos os maus pensamentos, homicídios, adultérios, imoralidade sexual, roubos, mentiras e insultos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","São essas coisas que contaminam a pessoa; comer sem antes lavar as mãos não contamina ninguém. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus partiu daquele lugar e dirigiu-se para a região das cidades de Tiro e de Sidom. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Uma mulher cananéia que morava naquela região aproximou-se dele e começou a gritar, dizendo: —Senhor, Filho de Davi, tenha piedade de mim! Minha filha está possuída por um demônio e sofre terrivelmente! ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesus, porém, não lhe respondeu nada. Seus discípulos, então, se aproximaram dele e disseram: —Mande essa mulher embora, pois ela vem gritando atrás de nós. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesus, então, disse: —Eu fui enviado somente às ovelhas perdidas do povo de Israel. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mas a mulher, aproximando-se, ajoelhou-se diante dele e disse: —Ajude-me, Senhor! ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Em resposta Jesus lhe disse: —Não está certo tirar a comida dos filhos para dá-la aos cachorrinhos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mas a mulher disse: —Isso é verdade, Senhor, porém os cachorrinhos comem das migalhas que caem da mesa de seus donos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ao ouvir aquilo, Jesus lhe disse: —A sua fé é grande, senhora! Que seja feito o que a senhora deseja. E naquele mesmo momento sua filha ficou curada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus, então, partiu daquele lugar e voltou para junto do lago da Galiléia. Depois subiu ao monte e se sentou ali. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Uma grande multidão foi até Ele, levando consigo coxos, aleijados, cegos, mudos e muitos outros doentes. Eles eram colocados aos pés de Jesus e este curava a todos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Os mudos voltavam a falar, os aleijados eram curados e os cegos recobravam a visão; e todo o povo, ao ver aquilo, ficou muito admirado e deu louvores ao Deus de Israel. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus, então, chamou os seus discípulos e disse-lhes: —Eu tenho muita pena de toda essa gente. Já faz três dias que estão comigo e agora não têm nada para comer. Não quero mandá-los embora sem lhes dar comida, pois eles podem desmaiar pelo caminho. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Seus discípulos, então, lhe perguntaram: —Onde é que vamos arranjar tanta comida para dar para toda esta gente num lugar deserto como este? ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mas Jesus lhes perguntou: —Quantos pães vocês têm? E eles responderam: —Temos sete pães e alguns pequenos peixes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesus, então, mandou que a multidão se sentasse no chão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Depois, pegou os sete pães e os peixes, deu graças a Deus e, partindo-os, deu-os aos seus discípulos, que os distribuíram entre a multidão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Todos comeram e ficaram satisfeitos e os discípulos ainda recolheram sete cestos cheias com os pedaços que sobraram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","E os que comeram foram quatro mil homens, sem contar as mulheres e as crianças. ");
INSERT INTO por_WBTC_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Depois disto, Jesus despediu a multidão, entrou no barco e partiu para a região de Magadã. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Alguns fariseus e saduceus foram falar com Jesus, pois queriam colocá-lo à prova. Eles pediram que Jesus lhes mostrasse um sinal vindo do céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesus, porém, lhes disse: —Quando está escurecendo vocês dizem: “Vai fazer bom tempo, pois o céu está avermelhado”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","E quando está amanhecendo vocês dizem: “Vai chover, pois o céu está avermelhado e escuro”. Vocês sabem interpretar os sinais do céu e não são capazes de interpretar os sinais do tempo em que vocês estão vivendo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Uma geração má e infiel pede por um sinal, mas o sinal de Jonas é o único que lhes será dado. E, deixando-os, foi embora. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Os discípulos de Jesus atravessaram para o outro lado do lago da Galiléia, mas se esqueceram de levar pão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus, então, disse-lhes: —Tenham cuidado com o fermento dos fariseus e dos saduceus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Quando os discípulos ouviram isso, começaram a discutir entre si, dizendo: —Ele está falando isso porque nós não trouxemos pão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus, porém, percebendo o que estava acontecendo, disse: —Como a fé de vocês é pequena! Por que estão discutindo entre si por não terem pão? ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Vocês ainda não entenderam? Vocês não se lembram dos cinco pães que foram repartidos entre os cinco mil homens e de quantos cestos vocês encheram com as sobras? ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Vocês também não se lembram dos sete pães que foram repartidos entre os quatro mil homens e de quantos cestos vocês encheram com as sobras? ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Como é possível que não tenham entendido que eu não lhes falei a respeito de pães? Eu lhes disse para se prevenirem contra o fermento dos fariseus e dos saduceus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Então eles entenderam que Jesus não lhes tinha dito para se prevenirem contra o fermento usado nos pães, mas sim dos ensinamentos dos fariseus e dos saduceus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Chegando à região de Cesaréia de Filipe, Jesus perguntou aos seus discípulos: —Quem o povo diz que o Filho do Homem é? ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","E eles responderam: —Alguns dizem que é João Batista; outros dizem que é Elias; outros ainda dizem que é Jeremias ou um dos outros profetas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","E Jesus, então, lhes perguntou: —E vocês? Quem é que vocês dizem que eu sou? ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simão Pedro respondeu: —Dizemos que o senhor é o Cristo, o Filho do Deus vivo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ao ouvir aquilo, Jesus lhe disse: —Feliz de você, Pedro, filho de João, pois esta verdade não lhe foi revelada por nenhum ser humano, mas sim por meu Pai que está no céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Eu lhe digo que você é Pedro, e que sobre esta pedra eu construirei a minha igreja e os poderes da morte não prevalecerão contra ela. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Eu lhe darei as chaves do reino do céu—aquilo que você proibir aqui na terra será o que foi proibido no céu e o que você permitir aqui na terra será o que foi permitido no céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Depois Jesus advertiu os discípulos para que eles não contassem a ninguém que Ele era o Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Desde aquela época, Jesus começou a explicar a seus discípulos que Ele deveria ir a Jerusalém e sofrer muitas coisas nas mãos dos anciãos, dos líderes dos sacerdotes e dos professores da lei. Ele também lhes explicou que iria ser morto e que no terceiro dia iria ressuscitar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro, então, chamando-o de lado, começou a criticá-lo, dizendo: —Que Deus não permita! De modo nenhum isso acontecerá com o senhor! ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mas Jesus se virou e disse a Pedro: —Afaste-se de mim, Satanás! Você é uma pedra de tropeço no meu caminho, pois não está pensando como Deus pensa, mas sim como as pessoas pensam! ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","E Jesus, então, disse aos seus discípulos: —Se alguém quiser vir comigo, tem que negar a si mesmo, pegar a sua cruz e me seguir. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Digo isto pois todo aquele que quiser salvar a sua vida, irá perdê-la; e todo aquele que perder a sua vida por minha causa, irá salvá-la. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","O que adianta uma pessoa ganhar o mundo inteiro e perder a sua própria vida? Ou, o que uma pessoa pode dar em troca de sua própria alma? ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","O Filho do Homem virá com os seus anjos na glória do Pai e retribuirá a todos de acordo com o que cada um fez. ");
INSERT INTO por_WBTC_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Digo a verdade a vocês: Há entre vocês alguns que não morrerão sem antes ver a vinda do Filho do Homem no seu reino. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis dias depois, Jesus chamou a Pedro, Tiago e João, irmão de Tiago, e os levou para um alto monte para poderem ficar sozinhos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ali, Jesus se transfigurou diante deles. O seu rosto brilhava como o sol e as suas roupas se tornaram brancas como a luz. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","De repente, Moisés e Elias também apareceram diante deles e ambos começaram a conversar com Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro, então, disse a Jesus: —É bom que nós estejamos aqui, Senhor! Se quiser eu posso construir aqui três tendas—uma para o senhor, uma para Moisés e outra para Elias. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro mal tinha acabado de falar quando uma nuvem brilhante apareceu e os envolveu. E da nuvem também vinha uma voz que dizia: —Este é o meu Filho! Eu o amo muito e Ele me dá muita alegria. Ouçam-no! ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Quando os discípulos de Jesus ouviram aquilo, ficaram com tanto medo que caíram de bruços. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesus, então, aproximou-se e, tocando neles, disse-lhes: —Levantem-se! Não tenham medo! ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Quando eles olharam, não viram mais ninguém a não ser Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ao descerem do monte, Jesus disse aos seus discípulos: —Não digam nada a ninguém a respeito do que vocês viram até que o Filho do Homem tenha sido ressuscitado dos mortos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Então os discípulos perguntaram: —Por que os professores da lei dizem que Elias deve vir antes do Cristo? ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","E Jesus lhes respondeu: —De fato, Elias virá e colocará todas coisas em ordem. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Eu, porém, lhes digo que Elias já veio e não o reconheceram. Ao contrário! Eles fizeram com ele o que quiseram e agora tratarão o Filho do Homem exatamente da mesma maneira. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Então os seus discípulos entenderam que Jesus estava falando a respeito de João Batista. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Quando voltaram para junto da multidão, um homem aproximou-se de Jesus e, ajoelhando-se aos seus pés, ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","disse-lhe: —Senhor, tenha piedade do meu filho, pois ele é epilético e sofre terrivelmente. Ele freqüentemente cai no fogo ou na água, ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","e eu o trouxe aos seus discípulos, mas eles não conseguiram curá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus, então, lhe disse: —Gente sem fé e desviada! Até quando terei de ficar com vocês? Até quando terei de suportá-los? Tragam o menino aqui. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesus deu uma ordem e o demônio saiu do menino; e, no mesmo instante, ele ficou curado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Os discípulos de Jesus aproximaram-se então dele em particular e lhe perguntaram: —Por que nós não fomos capazes de expulsar aquele demônio? ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","E Jesus lhes respondeu: —Porque a sua fé é pequena! Digo a verdade a vocês: Se a sua fé fosse do tamanho de uma semente de mostarda, poderiam dizer a este monte: “Vá daqui para lá” e ele iria. Nada lhes seria impossível. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mais tarde, os discípulos de Jesus se reuniram na Galiléia. Nessa ocasião, Jesus lhes disse: —O Filho do Homem vai ser entregue nas mãos dos homens ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","e estes o matarão, mas ao terceiro dia Ele ressuscitará! Ao ouvirem aquilo, os discípulos de Jesus ficaram muito tristes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Quando Jesus e seus discípulos entraram na cidade de Cafarnaum, aqueles que cobravam o imposto do templo se aproximaram de Pedro e lhe perguntaram: —O professor de vocês não paga o imposto do templo? ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","E Pedro respondeu: —Sim, paga! Pedro foi para a casa onde Jesus estava e, antes que pudesse falar, Jesus lhe perguntou: —Simão, o que você acha? De quem os reis da terra cobram impostos e taxas: dos seus próprios filhos, ou dos estranhos? ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","E Pedro, então, lhe respondeu: —Dos estranhos. E Jesus lhe disse: —Os filhos, então, estão isentos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nós, porém, não queremos ofender as autoridades. Por isso vá até o lago, jogue o seu anzol e puxe o primeiro peixe que você pescar. Na boca dele você encontrará uma moeda que dará para pagar o seu imposto e o meu. Pegue-a e entregue a eles por mim e por você. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Naquele momento os discípulos de Jesus chegaram perto dele e lhe perguntaram: —Quem é o maior no reino do céu? ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesus, então, chamou uma criança e, colocando-a diante deles, ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","disse-lhes: —Digo a verdade a vocês: Vocês devem mudar de atitude e se tornar como crianças. Se não fizerem isso, jamais entrarão no reino do céu! ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Portanto, o maior no reino do céu é aquele que se humilha para ser como esta criança. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Todo aquele que, em meu nome, recebe uma criança como esta, é como se estivesse recebendo a mim. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","—Se alguém fizer com que um destes pequeninos que tem fé em mim peque, será melhor para essa pessoa que ela seja jogada no mar com uma enorme pedra amarrada no pescoço. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ai do mundo por causa daquelas coisas que fazem com que as pessoas pequem! Essas coisas têm que acontecer, mas ai dos que são responsáveis por elas! ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Se a sua mão ou o seu pé faz com que você peque, corte-o e jogue-o fora. Pois é melhor entrar para a vida eterna manco ou aleijado do que ser jogado no fogo eterno do inferno com as duas mãos ou os dois pés. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Se o seu olho faz com que você peque, arranque-o e jogue-o fora! Pois é melhor entrar para a vida eterna só com um olho do que ser jogado no fogo eterno do inferno com ambos os olhos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","—Tomem cuidado, portanto, para não desprezar nenhum destes pequeninos, pois os anjos deles estão sempre na presença de meu Pai que está no céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Digam-me o que vocês acham. Se um homem tiver cem ovelhas e uma delas se perder, será que ele não vai deixar as outras noventa e nove nos montes para procurar aquela que se perdeu? ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","É claro que vai! E eu lhes digo que quando ele a encontrar, vai ficar mais feliz por causa desta ovelha do que por causa das outras noventa e nove que nunca se perderam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Da mesma forma, o Pai de vocês também não quer que nenhum destes pequeninos se perca. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—Se o seu irmão pecar contra você, vá e repreenda-o. Mas faça isso em particular, somente entre vocês dois. Se ele lhe der atenção, você terá ganho um irmão de volta. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Se ele, porém, não lhe der atenção, pegue e leve uma ou duas pessoas com você. Assim, pelo depoimento de duas ou três testemunhas, toda acusação será confirmada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mas se ele não der atenção nem mesmo a elas, informe a igreja. E se ele se recusar a ouvir também a igreja, trate-o como um pagão ou como um coletor de impostos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","—Digo a verdade a vocês: Tudo o que proibirem na terra será o que foi proibido no céu; e tudo o que permitirem na terra será o que foi permitido no céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","E eu também lhes digo que se dois de vocês aqui na terra concordarem e pedirem a mesma coisa em oração, o pedido de vocês será realizado pelo meu Pai que está no céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Digo isso pois onde quer que duas ou três pessoas estejam reunidas em meu nome, eu estarei entre elas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pedro, então, aproximou-se de Jesus e perguntou: —Senhor, se meu irmão continuar pecando contra mim, até quantas vezes eu devo perdoar-lhe? Até sete vezes? ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus, porém, lhe respondeu: —Eu não lhe digo que até sete vezes, mas até setenta vezes sete. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","—Por isso o reino do céu pode ser comparado a um rei que decidiu acertar as contas com os seus servos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Assim que ele começou, um homem que lhe devia milhões de moedas de prata foi levado até ele. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","O homem, entretanto, não tinha como pagar a dívida. O rei, então, mandou que ele fosse vendido, juntamente com sua mulher, seus filhos e tudo o que possuía. Dessa forma a sua dívida seria paga. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","O devedor, porém, se ajoelhou aos pés do rei e implorou: “Tenha paciência comigo e eu lhe pagarei tudo que lhe devo”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","—O rei sentiu pena daquele servo e perdoou-lhe a dívida, deixando-o ir embora. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Quando o servo saiu, encontrou um outro servo que lhe devia cem moedas de prata. Ele agarrou este outro servo pelo pescoço e, sufocando-o, dizia: “Pague-me o que você me deve”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Este outro servo, ajoelhando-se aos pés dele, implorou: “Tenha paciência comigo e eu pagarei tudo o que lhe devo”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","—Ele, entretanto, não concordou. Ao contrário, jogou o servo na prisão até que ele pagasse o que lhe devia. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Quando os outros servos viram o que tinha acontecido, ficaram muito tristes e foram à procura do seu senhor para lhe contar o que tinha acontecido. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Então o senhor chamou o primeiro servo e lhe disse: “Você é um mau servo! Você me implorou e eu perdoei toda a sua dívida para comigo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Por que você não teve pena do outro servo assim como eu tive pena de você?” ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","O senhor ficou com muita raiva e mandou que aquele servo fosse castigado até que lhe pagasse toda a dívida. ");
INSERT INTO por_WBTC_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","É assim que meu Pai que está no céu fará com vocês, se cada um não perdoar de coração ao seu irmão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Depois de Jesus ter terminado de dizer estas coisas, partiu da Galiléia para a região da Judéia, no outro lado do rio Jordão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Uma grande multidão o seguiu e Ele curou os doentes ali. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Alguns fariseus se aproximaram de Jesus com o fim de colocá-lo à prova e perguntaram: —É permitido ao marido se divorciar de sua esposa por qualquer motivo? ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mas Jesus lhes respondeu: —Vocês nunca leram as Escrituras que dizem: “No princípio o Criador os fez homem e mulher”? ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Depois, ainda, Deus disse: “Por isso o homem deve deixar seu pai e sua mãe e unir-se à sua esposa e os dois serão um só”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Assim, eles não são mais dois, mas sim um só. Portanto, que nenhum homem separe o que foi unido por Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mas os fariseus tornaram a perguntar a Jesus: —Por que, então, Moisés mandou dar carta de divórcio e repudiar a esposa? ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","E Jesus respondeu: —Moisés fez isso por causa da dureza do coração de vocês, mas no princípio da criação não era assim. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Eu, porém, lhes digo: Se um homem se divorciar de sua esposa sem ser por motivo de imoralidade sexual e se casar com outra mulher, estará cometendo adultério. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Os discípulos de Jesus disseram: —Se é esta a situação entre o homem e sua esposa, então é melhor não casar! ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus, porém, lhes disse: —Este ensino não é para todo mundo, mas apenas para aqueles a quem Deus deu a habilidade de aceitá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Há vários motivos pelos quais alguns homens não se casam; alguns deles não se casam porque nasceram sem ter a habilidade de gerar filhos; outros, porque os homens os fizeram ficar assim; e outros ainda não se casam por causa do reino do céu. Quem puder, que aceite este ensino. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Algumas pessoas levaram crianças até Jesus para que Ele as abençoasse e orasse por elas, mas os seus discípulos as repreenderam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesus, então, disse: —Deixem que as crianças venham até mim. Não as proíbam, pois o reino do céu pertence às pessoas que são como estas crianças. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","E, depois de abençoá-las, foi embora. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Certa ocasião, um jovem aproximou-se de Jesus e perguntou-lhe: —Senhor! O que devo fazer de bom para herdar a vida eterna? ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Mas Jesus lhe respondeu: —Por que você está me perguntando a respeito do que é bom? Somente Deus é bom. Porém, se você quer ter vida, obedeça aos mandamentos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mas o rapaz lhe perguntou: —Que mandamentos? E Jesus lhe respondeu: —“Não mate, não cometa adultério, não roube, não dê falso testemunho, ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","honre o seu pai e a sua mãe” e “Ame ao seu próximo como a si mesmo”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ao ouvir aquilo, o jovem disse a Jesus: —Eu tenho obedecido a todos esses mandamentos. O que mais me falta? ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus, então, lhe respondeu: —Se você quer ser perfeito, vá, venda tudo o que tem e dê o dinheiro aos pobres. Dessa forma você terá um tesouro no céu. Depois venha e siga-me. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","O jovem, porém, ouvindo aquilo, foi embora triste, pois era muito rico. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesus, então, disse aos seus discípulos: —Digo a verdade a vocês: É muito difícil um rico entrar no reino do céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Eu lhes digo que é mais fácil um camelo passar pelo buraco de uma agulha do que um rico entrar no reino de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Quando os discípulos ouviram aquilo, ficaram muito admirados e perguntaram: —Então quem poderá ser salvo? ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mas Jesus, olhando para eles, respondeu: —Para os homens isto é impossível, mas para Deus tudo é possível. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro, então, disse: —Nós abandonamos tudo e seguimos o senhor. O que ganharemos? ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","E Jesus lhe respondeu: —Digo a verdade a vocês: Quando as coisas forem renovadas, o Filho do Homem se sentará no seu trono glorioso. Então, todos vocês que me seguiram também se sentarão em doze tronos para julgar as doze tribos de Israel. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","E todos os que, por minha causa, abandonarem casa, irmãos, irmãs, pai, mãe, filhos ou propriedades, receberão cem vezes mais e também a vida eterna. ");
INSERT INTO por_WBTC_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Muitos que agora são os primeiros serão os últimos e muitos que agora são os últimos serão os primeiros. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","—O reino do céu é como o dono de uma fazenda que sai de manhã cedo para contratar trabalhadores para a sua plantação de uvas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ele combinou com os trabalhadores que lhes pagaria uma moeda de prata por dia de trabalho e depois mandou-os para a sua vinha. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Por volta das nove horas, o dono da fazenda saiu novamente e, dirigindo-se à praça do mercado, encontrou ali alguns homens desocupados. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Então, lhes disse: “Por que vocês também não vão trabalhar na minha plantação de uvas? Se forem, eu lhes pagarei o que é justo”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","E os homens foram. Por volta de meio-dia e também por volta de três da tarde, o dono da fazenda tornou a fazer a mesma coisa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Por volta de cinco horas ele saiu novamente e, dirigindo-se à praça do mercado, encontrou alguns homens que estavam por ali. Então, perguntou-lhes: “Por que vocês estão o dia todo aqui, sem fazer nada?” ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Mas eles responderam: “É porque ninguém nos contratou”. O dono da fazenda disse aos homens: “Vão vocês também trabalhar na minha vinha”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","—No fim do dia, o dono da fazenda chamou o seu administrador e disse-lhe: “Chame os trabalhadores e faça o pagamento, começando pelos que foram contratados por último e terminando pelos que foram contratados primeiro”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Assim, os trabalhadores que tinham sido contratados às cinco horas da tarde receberam cada um uma moeda de prata. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Quando os trabalhadores que tinham sido contratados primeiro chegaram, pensaram que iam receber mais, mas eles também receberam uma moeda de prata cada um. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pegaram o dinheiro e foram reclamar com o dono da fazenda: ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Nós trabalhamos o dia inteiro debaixo deste sol quente e estes homens que foram contratados por último trabalharam somente uma hora. Contudo o senhor pagou a eles o mesmo que a nós”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","—O dono da fazenda disse então a um deles: “Amigo, eu não estou sendo injusto para com você. Nós não combinamos que eu lhe pagaria uma moeda de prata? ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pegue o que é seu e vá para casa. Eu quero pagar a este homem que foi contratado por último a mesma coisa que paguei a você. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Por acaso não tenho o direito de fazer o que quero com o que é meu? Ou será que você está com inveja porque eu sou bom?” ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","E, terminando, Jesus disse: —É por isso que eu digo: Os primeiros serão os últimos e os últimos serão os primeiros. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Quando Jesus e seus discípulos estavam caminhando para Jerusalém, Ele os chamou de lado e lhes disse: ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Escutem bem! Nós estamos indo para Jerusalém, onde o Filho do Homem será entregue aos líderes dos sacerdotes e aos professores da lei. Eles o condenarão à morte. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Depois o entregarão aos que não são judeus para que façam pouco dele, batam nele e para que o crucifiquem. No terceiro dia, porém, Ele ressuscitará. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Depois, a mãe dos filhos de Zebedeu aproximou-se de Jesus com seus filhos e, ajoelhando-se, pediu-lhe um favor. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesus, então, perguntou-lhe: —O que você quer? E ela respondeu: —Eu quero que o senhor me prometa que estes meus dois filhos vão reinar com o senhor, um sentado à sua direita e outro sentado à sua esquerda. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus, porém, lhe respondeu: —Você não sabe o que está pedindo. Por acaso vocês podem beber o cálice que eu vou beber? E eles responderam: —Sim, podemos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus, então, lhes disse: —Vocês beberão o meu cálice, mas não sou eu que estabeleço quem vai sentar à minha direita ou à minha esquerda. Esses lugares são para as pessoas para quem meu Pai os preparou. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Quando os outros dez discípulos ouviram aquilo, ficaram muito zangados com os dois irmãos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mas Jesus chamou a todos para perto dele e disse: —Vocês sabem que aqueles que não são judeus são dominados pelos seus governadores e que os líderes exercem autoridade sobre eles. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Entre vocês, porém, não deve ser assim. Ao contrário! Quem quiser ser importante deve servir aos outros, ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","e quem quiser ser o primeiro deve ser escravo dos outros. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Vocês devem ser exatamente como o Filho do Homem; Ele não veio para ser servido, mas sim para servir e para dar a sua vida como resgate por muitos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Quando estavam partindo da cidade de Jericó, uma grande multidão seguiu a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Quando dois cegos que estavam sentados à beira da estrada ouviram que Jesus estava passando por ali, gritaram: —Senhor, Filho de Davi! Tenha pena de nós! ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A multidão os repreendia, mandando que eles ficassem quietos, mas eles gritaram ainda mais, dizendo: —Senhor, Filho de Davi! Tenha pena de nós! ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus, então, parou e, chamando-os, perguntou: —O que vocês querem que eu lhes faça? ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","E eles responderam: —Nós queremos ser capazes de enxergar, Senhor! ");
INSERT INTO por_WBTC_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","E Jesus, sentindo muita pena, tocou nos olhos deles. No mesmo instante eles recuperaram a visão e o seguiram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Quando Jesus e seus discípulos se aproximavam da cidade de Jerusalém, chegaram a uma vila chamada Betfagé, perto do Monte das Oliveiras. Dali Jesus enviou dois dos seus discípulos, ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","com as seguintes instruções: —Sigam até a próxima vila que fica logo adiante e encontrarão presos uma jumenta e um jumentinho. Soltem os dois e tragam-nos até aqui. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Se alguém perguntar alguma coisa, digam o seguinte: “O Senhor precisa deles; Ele logo os mandará de volta”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Isso aconteceu para que se cumprisse o que foi escrito por meio do profeta: ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Digam à cidade de Sião: Olhem! O seu Rei está chegando! Ele é humilde e está montado num jumento, num jumentinho, filho de animal de carga!” ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Os discípulos foram e fizeram exatamente o que Jesus lhes tinha dito, ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","levando a jumenta e o jumentinho. Depois, colocaram suas capas em cima deles e Jesus montou sobre elas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Muitas pessoas estenderam suas capas pelo caminho, e muitas outras cortaram ramos de árvores e os espalharam pela estrada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Todos os que caminhavam, tanto à frente como atrás de Jesus, gritavam: —Glória ao Filho de Davi! ‘Bendito é aquele que vem em nome do Senhor!’ Glória a Deus nas maiores alturas! ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Quando Jesus entrou em Jerusalém, toda a cidade ficou agitada e todo mundo perguntava: —Quem é este homem? ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","E as multidões repetiam sem parar: —Este é o profeta Jesus, da cidade de Nazaré da Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Quando Jesus entrou no templo, expulsou de lá todos os que compravam e vendiam coisas, e derrubou as mesas dos que trocavam dinheiro e as cadeiras dos que vendiam pombos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ele lhes disse: —As Escrituras dizem: “Minha casa será chamada casa de oração”; vocês, porém, a transformaram num “esconderijo de ladrões”! ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Alguns cegos e coxos foram ao encontro de Jesus no templo, e Ele os curou. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Quando os líderes dos sacerdotes e os professores da lei viram as maravilhas que Jesus tinha feito e também as crianças do templo gritando: “Glória ao Filho de Davi!”, ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ficaram muito zangados, e lhe perguntaram: —O senhor está escutando o que estas crianças estão dizendo? E Jesus lhes respondeu: —Sim. Vocês nunca leram as Escrituras que dizem: “Ó Deus, o senhor ensinou as crianças e os pequeninos a dar louvores”? ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Depois, partindo dali, Jesus saiu da cidade de Jerusalém e dirigiu-se à cidade de Betânia, onde passou a noite. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","No dia seguinte, bem cedo, quando Jesus estava voltando para a cidade de Jerusalém, teve fome. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ao ver uma figueira à beira da estrada, Ele foi até lá, mas não encontrou nada, a não ser as folhas. Então, disse para a árvore: —Que você nunca mais dê frutos! E no mesmo instante a figueira secou completamente. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Quando os seus discípulos viram aquilo, ficaram maravilhados e disseram: —Como a figueira secou depressa! ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus, porém, lhes disse: —Digo a verdade a vocês: Se tiverem fé e não duvidarem, serão capazes de fazer não somente o que eu fiz a esta figueira, mas poderão até dizer a este monte: “Levante-se e jogue-se no mar!”, ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","e isso acontecerá. Se tiverem fé, receberão tudo o que pedirem por meio de oração. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus voltou para o templo e começou a ensinar. Os líderes dos sacerdotes e os anciãos do povo, então, se aproximaram dele e lhe perguntaram: —Com que autoridade faz estas coisas e quem lhe deu essa autoridade? ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","E Jesus lhes respondeu: —Eu vou lhes fazer uma pergunta. Se me responderem, eu também lhes responderei com que autoridade faço estas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Digam-me: De quem João Batista recebeu autorização para batizar: de Deus ou dos homens? Então, discutindo entre si mesmos, diziam: —Nós não podemos dizer que foi de Deus, porque senão Ele nos perguntará: “Então por que vocês não acreditaram nele?” ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mas nós também não podemos dizer que foi dos homens, porque temos medo do que o povo pode fazer, pois todos consideram João Batista um profeta. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Então responderam: —Não sabemos. E Jesus lhes disse: —Bem, então eu também não vou lhes dizer com que autoridade faço estas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","—O que vocês acham disso? Um homem tinha dois filhos. Dirigindo-se ao mais velho, o homem disse: “Filho, vá trabalhar na vinha hoje”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","O rapaz respondeu: “Não quero ir”, mas, mais tarde, ele mudou de idéia e foi. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","O homem, então, dirigindo-se ao filho mais novo, disse a mesma coisa e este respondeu: “Sim, senhor”, mas não foi. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Agora eu lhes pergunto: Qual dos dois fez a vontade do pai? E eles responderam: —O mais velho. Jesus, então, lhes disse: —Digo a verdade a vocês: Os coletores de impostos e as prostitutas entrarão no reino de Deus na frente de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Eu digo isto porque João Batista veio para mostrar a maneira certa de viver e vocês não acreditaram nele; os cobradores de impostos e as prostitutas, no entanto, acreditaram. Vocês, porém, mesmo depois de terem visto estas coisas, não se arrependeram para crer nele. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—Escutem esta outra parábola: Certo homem, dono de um campo, plantou uvas e colocou uma cerca ao redor da plantação. Depois construiu um tanque, onde as uvas seriam amassadas, e uma torre. O homem, então, arrendou a vinha para alguns lavradores e foi viajar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Quando chegou a época da colheita, o dono da vinha mandou servos até os lavradores a fim de receber a sua parte dos frutos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Os lavradores, entretanto, bateram num, mataram outro e ainda apedrejaram um outro. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","—O dono da vinha, então, numa segunda vez, enviou um número maior de servos, mas os lavradores fizeram a mesma coisa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Por último, o dono da vinha enviou seu próprio filho, dizendo: “Ao meu filho eles respeitarão”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mas quando os lavradores viram o filho, disseram entre si: “Este é o herdeiro! Vamos matá-lo, pois assim poderemos nos apoderar da herança dele”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","E eles, então, o pegaram, o jogaram para fora da vinha e o mataram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","O que é que vocês acham que o dono da vinha irá fazer com aqueles lavradores quando ele chegar? ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","E eles, então, lhe responderam: —Usará para com eles da mesma crueldade que usaram para com os outros e depois entregará a plantação de uvas a lavradores que lhe dêem a sua parte da colheita no tempo certo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus, então, lhes perguntou: —Vocês nunca leram o que as Escrituras dizem? “A pedra que os construtores rejeitaram veio a ser a pedra mais importante. Isto foi feito pelo Senhor, e é maravilhoso aos nossos olhos!” ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","—Portanto, eu lhes digo: O reino de Deus será tirado de vocês e será entregue às pessoas que vivam de uma maneira que esteja de acordo com o reino. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Se alguém cair em cima desta pedra será quebrado em pedaços; se esta pedra cair em cima de alguém, o esmagará. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Quando os líderes dos sacerdotes e os fariseus ouviram aquelas parábolas, reconheceram que Jesus estava falando a respeito deles. ");
INSERT INTO por_WBTC_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tentaram prendê-lo, mas ficaram com medo da multidão, pois ela o considerava um profeta. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus falou novamente ao povo por meio de parábolas, e disse: ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—O reino do céu é como um rei que preparou uma festa de casamento para o seu filho. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Depois, ele mandou que seus servos fossem chamar as pessoas que tinham sido convidadas para a festa, mas elas não quiseram ir. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","O rei, então, chamando novamente os seus servos, disse: “Vão a todas as pessoas que foram convidadas e digam: Já está tudo preparado para a festa. Os bois e os bezerros gordos já foram mortos e está tudo pronto. Venham para a festa!” ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Os convidados, porém, não se importaram. Um foi para o seu campo, outro foi tratar de seus negócios, ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ao passo que outros maltrataram e mataram os servos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","O rei ficou tão furioso que enviou soldados, mandando que matassem aqueles assassinos e incendiassem a cidade deles. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Depois disse aos servos: “A festa de casamento está pronta, mas as pessoas que tinham sido convidadas não a mereciam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Portanto, vão pelas esquinas e convidem para a festa todas as pessoas que encontrarem”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Os servos, então, foram pelas ruas e convidaram todas as pessoas que encontraram, tanto pessoas boas como más, e o salão da festa ficou lotado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Quando o rei entrou para ver os convidados, notou um homem que não estava vestido com roupa de festa ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","e perguntou-lhe: “Amigo, como é que você entrou aqui sem roupa de festa?” —Mas o homem não respondeu nada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","O rei, então, disse aos seus servos: “Amarrem as mãos e os pés dele e ponham-no para fora, na escuridão, onde as pessoas vão chorar e ranger os dentes”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","—Digo isto porque muitos são chamados, mas poucos escolhidos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Os fariseus, então, se retiraram e se reuniram para planejar como poderiam fazer para pegar Jesus em contradição. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Depois, mandaram alguns de seus seguidores e alguns membros do partido de Herodes perguntar a Jesus: —Mestre, sabemos que o senhor é honesto, que ensina sobre o caminho de Deus com toda sinceridade e que não se incomoda com a opinião dos outros, pois não julga pela aparência das pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Diga-nos o que o senhor acha; é certo pagar impostos a César ou não? ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesus, porém, conhecendo as más intenções deles, disse: —Como vocês são hipócritas! Por que estão me testando? ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tragam-me uma moeda com a qual se paga imposto. Eles lhe deram a moeda ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","e Jesus, então, lhes perguntou: —De quem são esta imagem e esta inscrição? ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","E eles responderam: —São de César. Então Jesus lhes disse: —Portanto, dêem a César o que é de César e dêem a Deus o que é de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ao ouvirem aquilo, eles ficaram muito admirados e, deixando Jesus em paz, foram embora. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Naquele mesmo dia, alguns saduceus, os quais afirmam não haver ressurreição, se aproximaram de Jesus e lhe perguntaram: ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Mestre! Moisés nos deixou escrito o seguinte: “Se um homem morrer sem deixar filhos, seu irmão deve se casar com a viúva a fim de terem filhos que serão considerados filhos do irmão que morreu”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ora, entre nós havia sete irmãos. O primeiro irmão se casou e algum tempo depois morreu sem deixar filhos. O segundo irmão, então, se casou com a viúva. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","A mesma coisa aconteceu com o segundo irmão, com o terceiro e com todos os outros até chegar o sétimo, ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","e depois deles a mulher também morreu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Agora, de qual dos sete irmãos a mulher será esposa no dia da ressurreição, uma vez que todos eles se casaram com ela? ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus respondeu: —Vocês estão errados, pois não conhecem nem as Escrituras nem o poder de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pois quando os mortos ressuscitarem, ninguém se casará nem será dado em casamento; serão todos como os anjos do céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","E já que estamos falando em ressurreição, vocês nunca leram o que foi dito por Deus? Ele disse: ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Eu sou o Deus de Abraão, o Deus de Isaque e o Deus de Jacó”. Ora, Ele não é Deus dos mortos, mas sim dos vivos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Quando a multidão ouviu isso, ficou admirada com o ensino de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Os fariseus tinham ouvido falar que Jesus havia deixado os saduceus sem resposta. Eles se reuniram ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","e um deles, que era professor da lei, testando Jesus, perguntou-lhe: ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Mestre, qual é o mandamento mais importante? ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","E Jesus lhe respondeu: —“Ame o Senhor seu Deus de todo o seu coração, de toda a sua alma e de todo o seu entendimento”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Este é o primeiro mandamento, e também o mais importante. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Há também um segundo mandamento que é parecido com este, e que diz: “Ame ao seu próximo como você ama a você mesmo”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Toda a lei e tudo o que foi escrito pelos profetas depende destes dois mandamentos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Como os fariseus ainda estavam reunidos, Jesus lhes perguntou: ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—O que vocês pensam a respeito do Messias? De quem ele é filho? ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","E eles lhe responderam: —Ele é filho de Davi! Ao ouvir aquilo, Jesus lhes fez outra pergunta, dizendo: —Então como é que Davi, inspirado pelo Espírito, chamou o Messias de Senhor, quando disse: ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“O Senhor disse ao meu Senhor: Sente-se do meu lado direito e governe, até que eu coloque todos os seus inimigos debaixo dos seus pés”? ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","—Agora, se Davi o chama de Senhor, como pode o Messias ser filho de Davi? ");
INSERT INTO por_WBTC_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ninguém pôde lhe responder nada e daquele dia em diante ninguém mais teve coragem de lhe fazer nenhuma outra pergunta. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesus, então, dirigindo-se aos seus discípulos e à multidão, disse-lhes: ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Os professores da lei e os fariseus têm a autoridade de interpretar a lei de Moisés. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Por isso, vocês devem obedecer e seguir tudo o que eles ensinam. O que vocês não devem, entretanto, é imitar as ações deles, pois eles mesmos não fazem o que ensinam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Amarram cargas pesadas e difíceis de carregar e as colocam sobre os ombros dos outros, entretanto eles mesmos nem com o dedo querem movê-las. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Fazem tudo para serem vistos pelas outras pessoas. Alargam os recipientes das Escrituras e alongam as suas franjas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Gostam dos lugares de destaque nas festas e dos lugares mais importantes nas sinagogas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Eles também gostam de ser cumprimentados com respeito nas praças e ser chamados de “Mestre” pelo povo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Vocês, porém, não permitam que as pessoas os chamem de “Mestre”, pois o “Mestre” de vocês é um só, e vocês todos são simplesmente irmãos uns dos outros. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Também não chamem a ninguém de “Pai” aqui na terra, pois vocês têm somente um “Pai”, que está no céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Também não deixem que ninguém os chame de “Guia”, pois vocês têm somente um “Guia”: Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","O mais importante entre vocês será o servo de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Todo aquele que se exaltar será humilhado, e todo aquele que se humilhar será exaltado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","—Ai de vocês, professores da lei e fariseus, hipócritas! Digo isto pois são vocês mesmos que fecham as portas do reino do céu para as pessoas; dessa forma vocês nem entram nem deixam que outras pessoas entrem. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Ai de vocês, professores da lei e fariseus, hipócritas! Digo isto pois vocês fazem longas viagens e atravessam mar e terra com o propósito de converter uma pessoa à religião de vocês e, quando conseguem, tornam essa pessoa duas vezes mais merecedora do inferno do que vocês mesmos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ai de vocês, guias cegos! Digo isto pois vocês dizem: “Se uma pessoa jurar pelo templo, não significa nada; mas se jurar pelo ouro do templo, então é obrigada a cumprir com o seu juramento”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Como vocês são tolos e cegos! Não é o templo que faz com que o ouro seja sagrado? Então, o que é mais importante: o ouro que está no templo ou o próprio templo? ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Vocês também dizem: “Se uma pessoa jurar pelo altar, não significa nada; mas se jurar pela oferta que está sobre o altar, então é obrigada a cumprir o seu juramento”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Como vocês são cegos! Não é o altar que faz com que a oferta seja sagrada? Então, o que é mais importante: a oferta que está sobre o altar, ou o próprio altar? ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Se uma pessoa jurar pelo altar, estará jurando tanto pelo altar em si como por tudo o que está sobre ele! ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Da mesma forma, se uma pessoa jurar pelo templo, estará jurando tanto pelo templo em si como por tudo que está dentro dele! ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Assim também, se uma pessoa jurar pelo céu, estará jurando não só pelo trono de Deus, como também por Aquele que está sentado no trono! ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Ai de vocês, professores da lei e fariseus, hipócritas! Digo isto pois vocês dão a Deus um décimo de tudo o que possuem, até mesmo da hortelã, da erva-doce e do cominho, mas deixam de obedecer as coisas mais importantes da lei, que são a justiça, a misericórdia e a fé. É necessário que vocês façam estas coisas sem desprezar aquelas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Vocês são guias cegos! Coam a bebida e tiram o mosquito, mas engolem o camelo! ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ai de vocês, professores da lei e fariseus, hipócritas! Lavam o copo e o prato por fora, mas por dentro eles estão cheios das coisas que vocês conseguiram por enganarem as outras pessoas e por satisfazerem o seu próprio egoísmo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseu cego! Limpe primeiro o lado de dentro do copo, pois assim o lado de fora também ficará limpo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","—Ai de vocês, professores da lei e fariseus, hipócritas! Digo isto pois vocês são como túmulos pintados de branco; parecem bonitos por fora, mas por dentro estão cheios de ossos de mortos e de impureza. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Assim também vocês por fora parecem ser boas pessoas, mas por dentro estão cheios de hipocrisia e maldade. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","—Ai de vocês, professores da lei e fariseus, hipócritas! Digo isto pois vocês constroem túmulos para os profetas, enfeitam as sepulturas dos justos ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","e dizem: “Se nós tivéssemos vivido no tempo dos nossos antepassados, não teríamos nos unido a eles para matar os profetas”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Dessa forma vocês estão confessando para vocês mesmos que são os descendentes daqueles que mataram os profetas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Continuem, portanto, e terminem o que eles começaram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","—Cobras venenosas! Raça de víboras! Como vocês pensam que podem escapar de serem condenados ao inferno? ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ouçam bem isto: Eu estou lhes mandando profetas, homens sábios e também professores. Vocês, porém, vão matar a alguns, vão crucificar a outros, vão chicotear a outros nas sinagogas, e a outros, ainda, vão perseguir de cidade em cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Por causa disso vocês é que receberão o castigo por todas as pessoas inocentes que os antepassados de vocês mataram, desde o justo Abel até Zacarias, filho de Baraquias, o qual vocês mataram entre o santuário e o altar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Digo a verdade a vocês: São as pessoas desta geração que receberão o castigo por todos esses pecados. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","—Jerusalém, Jerusalém! Você mata os profetas e apedreja os mensageiros que Deus lhe envia! Quantas vezes eu quis ajuntar o seu povo, assim como a galinha ajunta os pintinhos debaixo de suas asas, mas você não quis! ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Agora a sua casa ficará completamente abandonada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Declaro, portanto, que você nunca mais me verá até que diga: “Bendito é aquele que vem em nome do Senhor!” ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus tinha saído do templo e estava indo embora sozinho, quando seus discípulos se aproximaram dele para lhe mostrar as construções do templo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesus, porém, lhes disse: —Vocês estão vendo tudo isto? Eu lhes digo que não ficará uma pedra sobre outra, que não seja derrubada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesus estava sentado no Monte das Oliveiras quando seus discípulos se aproximaram dele e lhe perguntaram em particular: —Diga-nos: Quando essas coisas vão acontecer? Qual será o sinal que mostrará que chegou o tempo da sua vinda e do fim do mundo? ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","E Jesus, então, lhes respondeu: —Tomem cuidado para que ninguém os engane. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Eu digo isso pois muitas pessoas virão em meu nome e dirão: “Eu sou o Cristo!”, e enganarão muita gente. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Não tenham medo quando ouvirem o barulho de batalhas e ficarem sabendo de guerras. Essas coisas devem acontecer, mas ainda não será o fim. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Uma nação fará guerra contra outra, e um país atacará outro. Haverá fome e terremotos por toda parte, ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","mas essas coisas serão somente o começo, assim como as primeiras dores da mulher que está para dar à luz. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Nessa época vocês serão presos e entregues para serem castigados. Vocês serão mortos e odiados por todos os povos por causa do meu nome. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nessa época muitas pessoas vão abandonar a sua fé e vão trair e odiar umas às outras. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Muitos falsos profetas aparecerão e enganarão a muita gente ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","e a maldade se espalhará de tal maneira que o amor da maioria das pessoas esfriará. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Aquele, porém, que permanecer firme até o fim, será salvo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","E as Boas Novas sobre o reino de Deus serão anunciadas no mundo inteiro como testemunho a toda a humanidade; e então virá o fim. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","—O profeta Daniel falou a respeito da “terrível coisa que causa desolação”. Vocês verão essa coisa no templo (quem estiver lendo isto que entenda o que significa). ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Então, quem estiver na Judéia deve fugir para as montanhas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Quem estiver na parte de cima de sua casa não deve descer para pegar coisa alguma ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","e quem estiver trabalhando no campo não deve voltar para casa para buscar suas roupas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ai das mulheres que estiverem grávidas ou amamentando nessa época! ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Orem para que essa sua fuga não aconteça nem durante o inverno nem num sábado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Digo isso pois nessa época haverá grandes sofrimentos, como nunca houve desde o começo do mundo e jamais haverá. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Se Deus não tivesse diminuído esse período de sofrimento, ninguém seria salvo. Mas por causa das pessoas que foram escolhidas, esse período de sofrimento será diminuído. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","—Portanto, se nessa época alguém lhes disser: “Olhe! Aqui está o Cristo!”, ou então: “O Cristo está aqui!”, não acreditem! ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Eu digo isso pois muitos falsos cristos e falsos profetas vão aparecer e fazer milagres e maravilhas a fim de enganar, se possível, até mesmo aqueles que tinham sido escolhidos por Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Olhem que eu tenho avisado a vocês antes que estas coisas aconteçam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—Se algumas pessoas lhes disserem: “Olhem, o Cristo está no deserto!”, não saiam. Ou: “Olhem, Ele está dentro da casa!”, não acreditem! ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Eu lhes digo isso pois a vinda do Filho do Homem será como o brilho de um relâmpago no céu que sai do leste e se mostra até o oeste. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Onde quer que esteja um cadáver, ali se ajuntarão os urubus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","—Logo depois desse período de sofrimento, “O sol se apagará e a lua não brilhará. As estrelas cairão do céu e os corpos celestes serão abalados”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nessa época o sinal da vinda do Filho do Homem será visto no céu e todos os povos da terra chorarão e verão o Filho do Homem vindo entre as nuvens com poder e grande glória. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Um alto som de trombeta será ouvido, e o Filho do Homem enviará os seus anjos e eles recolherão de um a outro lado do mundo aqueles que tenham sido escolhidos por Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","E Jesus, depois, lhes disse: —Aprendam a lição que a figueira lhes ensina. Assim que os seus galhos se renovam e as suas folhas começam a brotar, vocês sabem que o verão está próximo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Da mesma forma, quando vocês virem todas essas coisas acontecerem, saberão que o tempo está próximo, pronto para chegar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Digo a verdade a vocês: Todas essas coisas acontecerão antes que morram todas as pessoas que agora estão vivas. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","O céu e a terra passarão, porém as minhas palavras nunca passarão. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","—Ninguém sabe o dia ou a hora em que essas coisas acontecerão—nem os anjos do céu nem o próprio Filho. Somente o Pai sabe quando elas vão acontecer. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Pois assim como foi no tempo de Noé, também será quando o Filho do Homem voltar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Digo isto pois, antes de vir o dilúvio, as pessoas estavam comendo, bebendo, se casando e se dando em casamento, até o dia em que Noé entrou na arca. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ninguém sabia o que ia acontecer até que veio o dilúvio e levou a todos. A mesma coisa acontecerá quando o Filho do Homem voltar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nesse dia dois homens estarão trabalhando no campo—um será levado e outro será deixado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Duas mulheres estarão moendo trigo no moinho—uma será levada, e a outra deixada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Portanto, se cuidem, pois vocês não sabem em que dia o Senhor virá. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lembrem-se disto: Se o dono da casa soubesse a que hora da noite o ladrão viria, ele ficaria acordado e não deixaria que o ladrão arrombasse a sua casa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","É por isso que eu digo que vocês devem ficar preparados, pois o Filho do Homem virá na hora em que não estiverem esperando. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—Quem é, então, o servo fiel e prudente a quem o senhor deixou a responsabilidade de tomar conta dos outros servos e de lhes dar comida nas horas certas? ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Feliz é o servo que estiver fazendo assim quando o seu senhor chegar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Digo a verdade a vocês: Ele o colocará para tomar conta de todos os seus bens. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Por outro lado, imaginem um servo mau. Ele diz consigo mesmo: “Meu senhor vai demorar para voltar”, ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","e então começa a bater nos outros servos e a comer e beber com bêbados. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","O senhor desse servo chegará num dia que ele não o espera, e numa hora que ele nem imagina. ");
INSERT INTO por_WBTC_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ele o castigará com severidade e o condenará a sofrer o mesmo destino dos hipócritas. E lá eles vão chorar e ranger os dentes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","—Nesse dia o reino do céu será como dez moças que pegaram as suas lamparinas e saíram para se encontrar com o noivo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Dessas dez moças, cinco eram tolas e cinco eram prudentes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","As moças que eram tolas pegaram as suas lamparinas, mas não levaram óleo de reserva; ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","as prudentes, porém, além das lamparinas, levaram também vasilhas de óleo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Como o noivo estivesse demorando, as moças ficaram com sono e começaram a cochilar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Quando deu meia-noite, ouviu-se um grito: “Olhem, o noivo! Venham se encontrar com ele!” ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Quando ouviram aquilo, todas as dez moças se levantaram e prepararam as suas lamparinas; ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","mas as tolas disseram às prudentes: “Dêem-nos um pouco do óleo de vocês, pois as nossas lamparinas estão se apagando”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","As prudentes, porém, responderam: “Não, para que não falte nem a nós nem a vocês. Se vocês querem óleo, procurem quem o venda e comprem”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","As moças tolas saíram então para comprar óleo e, enquanto estavam fora, o noivo chegou. Sendo assim, as moças que estavam prontas entraram com o noivo para a festa de casamento e, depois de terem entrado, a porta foi fechada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","—Mais tarde, quando as moças tolas chegaram, começaram a bater na porta e a gritar, dizendo: “Senhor, senhor! Abra a porta e deixe-nos entrar!” ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","O noivo, porém, lhes respondeu: “Digo a verdade a vocês: Eu não as conheço”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","É por isso que eu lhes digo: Estejam sempre preparados, pois vocês não sabem nem o dia nem a hora em que o Filho do Homem virá. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","—Nesse dia o reino do céu será como um homem que precisou fazer uma viagem e, chamando três servos seus, os colocou para tomar conta de suas propriedades. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A um ele deu cinco mil moedas de prata, a outro ele deu duas mil, e a outro mil. A cada um deu de acordo com a sua própria capacidade; e então partiu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","O servo que tinha recebido as cinco mil moedas de prata saiu imediatamente e, investindo aquele dinheiro, ganhou outras cinco mil moedas de prata. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","A mesma coisa aconteceu com o segundo servo; ele investiu as duas mil moedas de prata e conseguiu outras duas mil. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","O terceiro, porém, saindo, cavou um buraco na terra e escondeu o dinheiro do seu senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Depois de muito tempo, o senhor daqueles servos voltou e acertou contas com eles. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","O servo que tinha recebido cinco mil moedas de prata aproximou-se do seu senhor e, entregando-lhe as outras cinco mil moedas, disse-lhe: “O senhor me deu cinco mil moedas de prata para tomar conta; aqui estão outras cinco mil que ganhei”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","—O senhor, então, disse: “Muito bem! Você é um servo bom e fiel! Como você me foi fiel no pouco, eu vou colocá-lo para tomar conta de muitas coisas. Venha participar da minha alegria”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—O servo que tinha recebido duas mil moedas de prata aproximou-se do senhor e disse-lhe: “O senhor me deu duas mil moedas de prata para tomar conta; aqui estão outras duas mil que ganhei”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","—O senhor, então, lhe disse: “Muito bem! Você é um servo bom e fiel! Como você me foi fiel no pouco, eu vou colocá-lo para tomar conta de muitas coisas. Venha participar da minha alegria”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","—E, finalmente, aquele que tinha recebido mil moedas de prata, aproximou-se do seu senhor e disse: “Eu sei que o senhor é um homem duro, que colhe em campo que não plantou e que ajunta onde não semeou. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Fiquei com medo e por isso escondi o seu dinheiro num buraco na terra. Aqui está o seu dinheiro”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","—O senhor, porém, lhe disse: “Você é um servo mau e preguiçoso! Não foi você mesmo que disse que colho em campo que não plantei e que ajunto onde não semeei? ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","A sua obrigação, portanto, era ter depositado o meu dinheiro no banco para que eu, quando voltasse, o recebesse com juros. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tirem dele as mil moedas de prata, e dêem-nas ao que já tem dez. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pois aquele que tem receberá ainda mais, e terá muito mais do que realmente precisa; mas aquele que não tem, até o que ele tem lhe será tirado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Quanto a este servo inútil, joguem-no para fora, na escuridão. Ali haverá choro e ranger de dentes”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","—Quando o Filho do Homem vier, com todo o seu poder e com todos os seus anjos, Ele se sentará no seu glorioso trono. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Então, todos os povos da terra se reunirão diante dele e Ele separará uns dos outros, assim como o pastor separa as ovelhas dos cabritos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ele colocará as ovelhas à sua direita e os cabritos à sua esquerda. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Então o Rei dirá aos que estiverem à sua direita: “Venham, vocês que são abençoados por meu Pai! Venham e recebam o reino que está preparado para vocês desde a criação do mundo. Este reino é a recompensa de vocês, ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","pois eu estava com fome e me deram o que comer, estava com sede e me deram o que beber, era forasteiro e me receberam em suas casas, ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","estava sem ter o que vestir e me deram roupas, estava doente e cuidaram de mim, estava na prisão e foram me visitar”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—Então, os bons perguntarão: “Senhor, quando foi que nós o vimos com fome e lhe demos o que comer, ou o vimos com sede e lhe demos o que beber? ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Quando foi ainda que, como forasteiro, nós o recebemos em nossas casas, ou que o vimos sem ter o que vestir e lhe demos roupas, ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ou mesmo que, estando doente ou preso, nós o visitamos?” ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","—O rei, porém, lhes responderá: “Digo a verdade a vocês: Todas as vezes que vocês fizeram essas coisas ao mais simples dos meus irmãos, na realidade foi a mim que fizeram”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—E o rei, então, dirá àqueles que estão à sua esquerda: “Saiam daqui! Vocês estão debaixo da maldição de Deus! Vocês irão para o fogo eterno, o qual foi preparado por Deus para o Diabo e seus anjos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Esse é o castigo que merecem, pois eu estava com fome, mas mesmo assim vocês não me deram o que comer; estava com sede, mas mesmo assim não me deram o que beber; ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","era forasteiro, mas mesmo assim não me receberam nas suas casas; não tinha o que vestir, mas mesmo assim não me deram roupas; estava doente e preso, mas mesmo assim não foram me visitar”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","—Mas eles também lhe perguntarão: “Senhor, quando foi que nós o vimos com fome, ou com sede, ou como forasteiro, ou sem ter o que vestir, ou mesmo doente ou preso e não o ajudamos?” ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","—Mas o Rei, então, lhes responderá: “Digo a verdade a vocês: Todas as vezes que deixaram de fazer qualquer uma dessas coisas ao mais simples dos meus irmãos, na realidade foi a mim que vocês deixaram de fazê-la”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","—Estes, portanto, irão para o castigo eterno; mas os bons, irão para a vida eterna. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Depois que Jesus acabou de ensinar todas essas coisas, disse aos seus discípulos: ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Vocês sabem que daqui a dois dias será comemorada a Páscoa; nesse dia o Filho do Homem será entregue para ser crucificado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Os líderes dos sacerdotes e os anciãos do povo se reuniram no palácio de Caifás, o sumo sacerdote. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nessa reunião planejaram um meio de prender Jesus à traição, para que depois pudessem matá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Eles, porém, diziam entre si: —Não vamos prendê-lo durante a festa da Páscoa, porque se o fizermos o povo pode se revoltar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesus estava na cidade de Betânia, na casa de Simão, o leproso, ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","quando uma mulher chegou. Ela carregava um vaso feito de alabastro, e este estava cheio de um perfume muito caro. Ela se aproximou de Jesus enquanto Ele estava à mesa e derramou todo o perfume sobre a sua cabeça. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Quando os discípulos viram aquilo, ficaram zangados, e perguntaram: —Por que este desperdício? ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Esse perfume poderia ter sido vendido por muito dinheiro, e esse dinheiro poderia ter sido dado aos pobres! ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus, porém, vendo aquilo, disse-lhes: —Por que vocês estão aborrecendo esta mulher? Ela me fez uma coisa muito boa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Os pobres estarão sempre com vocês, mas eu não. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ao derramar este perfume sobre mim, ela preparou o meu corpo para o enterro. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Digo a verdade a vocês: Em todos os lugares onde as Boas Novas forem anunciadas, será contada também a história do que essa mulher fez hoje. Dessa forma ela será lembrada em todo o mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Então, Judas Iscariotes, um dos doze discípulos, foi falar com os líderes dos sacerdotes. Ele disse: ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—Quanto vocês me pagam se eu lhes entregar Jesus? Os sacerdotes lhe deram trinta moedas de prata ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","e, desse momento em diante, Judas passou a procurar uma boa chance para entregar a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","No primeiro dia da Festa dos Pães sem Fermento, os discípulos se aproximaram de Jesus e lhe perguntaram: —Onde quer que nós preparemos tudo para a Páscoa? ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","E Ele, então, respondeu: —Vão até a cidade. Lá vocês encontrarão um homem; digam-lhe que o Mestre manda dizer o seguinte: “A minha hora está chegando! Meus discípulos e eu vamos comemorar a Páscoa em sua casa”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Os discípulos fizeram exatamente o que Jesus lhes tinha dito e prepararam tudo para a Páscoa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Quando anoiteceu, Jesus e seus doze discípulos se colocaram à mesa para jantar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Enquanto comiam, Jesus lhes disse: —Digo a verdade a vocês: Um de vocês vai me trair. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Todos ficaram muito tristes e, um por um, começaram a perguntar-lhe: —Senhor, não acha que sou eu, acha? ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mas Jesus, então, lhes disse: —Quem vai me trair é aquele que molha o pão no prato comigo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","O Filho do Homem será traído. As Escrituras dizem que isso vai acontecer. Porém, ai daquele que vai traí-lo! Seria melhor que ele nunca tivesse nascido! ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Então, Judas, que era o traidor, perguntou a Jesus: —Mestre, não acha que sou eu, acha? Mas Jesus lhe respondeu: —Sim, é você. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Enquanto comiam, Jesus pegou o pão e deu graças a Deus por ele. Depois, partindo-o, deu-o a seus discípulos, dizendo: —Peguem e comam; isto é o meu corpo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Em seguida, Jesus pegou o cálice e deu graças a Deus por ele. Depois, passando-o a seus discípulos, disse: —Bebam deste cálice, todos vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Isto é o meu sangue, que sela a aliança entre Deus e seu povo. Esse sangue é derramado em favor de muitos para o perdão dos pecados. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Digo isto pois nunca mais beberei deste vinho até o dia em que beba com vocês o novo vinho no reino do meu Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Então, depois de terem cantado um hino, eles saíram para o Monte das Oliveiras. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","E Jesus disse então aos seus discípulos: —Esta noite todos vocês vão fugir e me abandonar, porque as Escrituras dizem: “Eu matarei o pastor, e todas as ovelhas do rebanho ficarão dispersas”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","—Porém, depois que eu ressuscitar, irei à frente de vocês para a Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro, então, disse a Jesus: —Mesmo que todos o abandonem, eu nunca o abandonarei. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ao ouvir aquilo, Jesus disse: —Digo-lhe a verdade: Ainda hoje à noite, antes mesmo que o galo cante, você negará três vezes que me conhece. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro, porém, respondeu: —Eu nunca o abandonarei, mesmo que tenha de morrer com o senhor. E todos os outros discípulos disseram a mesma coisa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Depois disso, tanto Jesus como seus discípulos foram para um lugar chamado Getsêmani, e lá Ele lhes disse: —Sentem-se aqui, enquanto vou até ali adiante para orar. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesus levou junto Pedro e os dois filhos de Zebedeu. Depois, Ele começou a sentir uma grande tristeza e aflição. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Então lhes disse: —Estou tão triste que eu poderia morrer! Fiquem aqui e vigiem comigo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ele foi um pouco mais adiante, ajoelhou-se e orou, dizendo: —Meu Pai, se for possível, afaste de mim este cálice de sofrimento. Porém, não seja feito o que eu quero, mas sim o que o senhor quer. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Depois voltou para onde os três discípulos estavam e os encontrou dormindo. Então disse a Pedro: —Será possível que vocês não conseguem vigiar comigo nem ao menos por uma hora? ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Vigiem e orem para que vocês não caiam em tentação. O espírito está pronto, mas o corpo é fraco. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Pela segunda vez Jesus foi e orou, dizendo: —Meu Pai, se não for possível que este cálice de sofrimento seja afastado de mim sem que eu o beba, que seja feita a sua vontade. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","E, voltando para onde os três discípulos estavam, encontrou-os novamente dormindo, pois seus olhos estavam pesados. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesus tornou a se afastar deles e foi orar novamente, repetindo as mesmas palavras. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Depois Ele voltou para onde os discípulos estavam, e lhes disse: —Vocês ainda estão dormindo e descansando? Olhem, chegou a hora! O Filho do Homem está sendo entregue nas mãos dos pecadores. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Levantem-se, vamos embora! O traidor está chegando. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus mal tinha acabado de falar aquelas palavras, quando Judas, um dos doze discípulos, chegou. Havia muitos homens com ele e todos carregavam espadas ou cacetes. Eles tinham sido enviados pelos líderes dos sacerdotes e pelos anciãos do povo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","O traidor tinha combinado com eles um sinal, dizendo: “Vocês podem prender o homem que eu beijar, pois é Ele”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","E, sendo assim, Judas aproximou-se de Jesus e lhe disse: —Olá, Mestre!—e o beijou. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus, porém, respondeu: —Faça de uma vez o que você veio para fazer, amigo. E nesse momento os soldados se aproximaram, pegaram Jesus e o prenderam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Um dos homens que estava com Jesus sacou da sua espada, atacou um dos servos do sumo sacerdote e cortou-lhe a orelha. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesus, então, disse-lhe: —Guarde a sua espada, pois todos que usam da espada serão mortos pela espada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Será que você não entende que eu poderia orar ao meu Pai e Ele me mandaria, neste exato momento, mais de doze tropas de anjos? ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Porém, se fizesse isto, como se cumpririam as passagens das Escrituras que dizem que isso deve acontecer? ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","E naquele momento Jesus disse aos homens que tinham ido prendê-lo: —Por que vocês vieram me prender com espadas e cacetes, como se eu fosse um bandido? Por que é que vocês não me prenderam quando eu estava no templo? Eu não ia lá todos os dias e me sentava no meio de vocês? ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mas tudo isto está acontecendo desta forma para se cumprir o que os profetas disseram por meio das Escrituras. Então todos os discípulos fugiram e o abandonaram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Os homens que tinham prendido Jesus o levaram até a casa de Caifás, o sumo sacerdote, onde os professores da lei e os anciãos estavam reunidos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro o seguiu de longe até o pátio do palácio do sumo sacerdote. Depois, resolveu entrar e sentar-se entre os guardas, para ver o que ia acontecer. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ora, os principais sacerdotes e todo o Conselho Superior dos judeus estavam reunidos com o fim de encontrar algum pretexto para que pudessem acusar a Jesus. O que eles queriam era condená-lo à morte. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Muitas pessoas testemunharam mentiras a respeito de Jesus, mas mesmo assim não conseguiram condená-lo. Finalmente, duas pessoas apareceram e disseram: ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Este homem disse: “Eu posso destruir o templo de Deus e construí-lo de novo em três dias”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","O sumo sacerdote, então, se levantou e perguntou a Jesus: —Você não vai se defender das acusações que estão sendo feitas contra você? ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesus, porém, não respondeu nada. O sumo sacerdote, então, voltou a perguntar: —Em nome do Deus vivo eu lhe ordeno que você me responda isto: Você é o Messias, o Filho do Deus vivo? ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","E Jesus respondeu: —É verdade e eu lhe digo que um dia vocês verão o Filho do Homem sentado à direita de Deus, o Todo-poderoso, e descendo sobre as nuvens do céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","O sumo sacerdote, ao ouvir aquilo, rasgou suas roupas e disse: —Ele insultou a Deus. Nós não precisamos mais de nenhuma testemunha! Todos aqui ouviram este insulto contra Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","O que é que vocês acham? E todos responderam: —Ele é culpado e merece a morte! ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","E alguns deles passaram a cuspir no rosto de Jesus, outros começaram a dar-lhe murros e outros ainda davam-lhe bofetadas e diziam: ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—Adivinhe agora, Messias! Diga quem foi que lhe bateu! ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ora, Pedro estava sentado no pátio quando uma serva se aproximou dele e disse: —Você também não estava com Jesus da Galiléia? ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro, porém, negou diante de todos que conhecia a Jesus. Ele disse: —Não sei do que você está falando. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","E, saindo dali em direção à porta do pátio, ele foi visto por uma outra criada, que disse aos homens que estavam ali: —Este homem também estava com Jesus, o Nazareno. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","E Pedro, pela segunda vez, negou que conhecia Jesus, jurando: —Eu não conheço esse homem! ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pouco tempo depois, alguns homens se aproximaram de Pedro e lhe disseram: —Não há dúvida de que você também é um deles; o seu modo de falar o acusa. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pedro, então, começou a afirmar sob juramento, dizendo: —Já disse que não conheço esse homem! E nesse mesmo instante o galo cantou. ");
INSERT INTO por_WBTC_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nesse momento Pedro se lembrou que Jesus tinha lhe dito: “Antes que o galo cante, você negará três vezes que me conhece”. Então Pedro saiu dali, e chorou amargamente. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Quando rompeu o dia, todos os líderes dos sacerdotes e anciãos do povo se reuniram para planejar como iriam condenar Jesus à morte. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Eles o amarraram e o levaram até a presença do governador Pôncio Pilatos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Quando Judas, que o traiu, viu que Jesus tinha sido condenado, ficou cheio de remorso. Ele foi até os líderes dos sacerdotes e anciãos, devolveu as trinta moedas de prata que tinha recebido para trair a Jesus ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","e disse: —Eu pequei, pois traí um homem inocente. Eles, porém, lhe disseram: —Nós não temos nada com isso. Isso é problema seu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas, então, atirou as moedas de prata para dentro do templo, saiu de lá e se enforcou. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Os líderes dos sacerdotes pegaram o dinheiro e disseram: —Nós não podemos colocar este dinheiro na caixa das ofertas do templo, pois é preço de sangue. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","E, depois de entrarem em acordo, eles decidiram usar aquele dinheiro para comprar o Campo do Oleiro, para que servisse de cemitério para os forasteiros. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","E aquele campo, por causa disso, até hoje é conhecido como “Campo de Sangue”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Dessa forma se cumpriu o que Deus disse por intermédio do profeta Jeremias: “Eles pegaram as trinta moedas de prata, preço que o povo de Israel tinha concordado em pagar por ele, ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","e compraram o Campo do Oleiro, assim como o Senhor tinha mandado que eu fizesse”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus estava de pé, diante do governador, e este lhe interrogou, dizendo: —Você é o rei dos judeus? Ao que Jesus lhe respondeu: —É verdade. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","E, mesmo sendo acusado pelos líderes dos sacerdotes e pelos anciãos, Jesus não respondia nada. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatos, então, lhe perguntou: —Não está ouvindo todas as acusações que estão sendo feitas contra você? ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesus, porém, não respondeu nada e isso impressionou muito o governador. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Era época da Páscoa e, nessa época, o governador costumava soltar um dos prisioneiros, conforme a vontade do povo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nessa ocasião, havia um prisioneiro muito conhecido, chamado Barrabás. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Como o povo estava reunido, Pilatos perguntou a todos: —Quem vocês querem que eu solte: Barrabás ou Jesus, chamado Cristo? ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Pilatos tinha perguntado isso porque ele sabia que Jesus tinha sido entregue por pura inveja ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","e porque, quando estava sentado no tribunal, tinha recebido um recado de sua mulher, dizendo: Não se envolva no caso desse homem inocente, pois esta noite eu tive um sonho horrível por causa dele.) ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Os líderes dos sacerdotes e os anciãos, porém, convenceram o povo a pedir a Pilatos que soltasse a Barrabás e condenasse a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Sendo assim, quando o governador Pilatos perguntou ao povo pela segunda vez: “Qual dos dois prisioneiros vocês querem que eu solte?”, eles responderam: —Queremos que o senhor liberte Barrabás. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatos, porém, lhes perguntou: —E o que querem que eu faça com Jesus, chamado Cristo? E todos responderam: —Crucifique-o! ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—Que crime ele cometeu?—perguntou Pilatos. Mas o povo, gritando cada vez mais alto, pedia: —Crucifique-o! ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Quando Pilatos percebeu que seu esforço para salvar Jesus não estava adiantando nada mas, ao contrário, estava fazendo com que as coisas ficassem cada vez piores, pediu que lhe trouxessem água. E, diante de todo o povo, lavou as mãos e disse: —Sou inocente pela morte deste homem. Fiquem vocês com essa responsabilidade. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","E o povo todo respondeu: —Que o castigo referente à morte dele caia sobre nós e sobre nossos filhos! ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilatos, então, soltou a Barrabás e, depois de ter mandado chicotear a Jesus, entregou-o para que Ele fosse crucificado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Logo depois os soldados de Pilatos levaram Jesus para o palácio do governador e reuniram toda a tropa ao redor dele. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tiraram a roupa dele e o vestiram com um manto vermelho. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Fizeram uma coroa de espinhos e a colocaram na cabeça de Jesus e depois lhe deram uma vara para que ele segurasse na mão direita. Ajoelharam-se diante dele e fizeram zombarias, dizendo: —Viva o rei dos judeus! ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eles cuspiram nele, pegaram a vara que lhe haviam dado e bateram com ela na cabeça dele. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Depois de se divertirem bastante às custas dele, tiraram-lhe o manto vermelho e o vestiram com suas próprias roupas. Em seguida, o levaram para ser crucificado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Quando estavam saindo, eles encontraram um homem chamado Simão, da cidade de Cirene, e o obrigaram a levar a cruz de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","E, ao chegarem a um lugar chamado Gólgota (que significa “Lugar da Caveira”), ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","deram vinho misturado com fel para Jesus beber. Ele, porém, depois de experimentar, não quis beber. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Depois de o crucificarem, os soldados dividiram suas roupas entre si, tirando a sorte com dados, para ver qual seria a parte de cada um. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","E, sentados ali, aguardavam a morte de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Acima da cabeça de Jesus haviam colocado uma placa, onde estava escrita a sua acusação: “Este é Jesus, o rei dos judeus”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Dois ladrões também foram crucificados com Jesus, estando um à sua direita e outro à sua esquerda. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","As pessoas que passavam por ali caçoavam e, balançando a cabeça, diziam: ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Não foi você que disse que podia destruir o templo de Deus e construí-lo de novo em três dias? Então, se você é mesmo o Filho de Deus, desça da cruz e salve a si mesmo! ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","E tanto os líderes dos sacerdotes como os professores da lei e os anciãos também faziam pouco dele, e diziam: ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Ele salvou a outros, mas não consegue salvar a si mesmo. Se Ele é o rei de Israel, então que desça da cruz! Se ele fizer isso, nós acreditaremos nele! ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ele confiou em Deus, e disse: “Sou Filho de Deus!” Pois então, que Deus venha livrá-lo agora, se de fato lhe quer bem! ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","E até mesmo os ladrões, que tinham sido crucificados com Ele, o insultavam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ao meio-dia, toda a região ficou escura, e a escuridão continuou por três horas. Às três horas da tarde, Jesus gritou bem alto: ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","“Eli, Eli, lemá sabactâni?”, que quer dizer: “Meu Deus, Meu Deus, por que o senhor me abandonou?” ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Algumas pessoas que estavam ali por perto, ao ouvirem aquilo, diziam: —Ele está chamando por Elias. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Então alguém correu e molhou uma esponja em vinagre, pôs na ponta de uma vara e deu para Jesus beber. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Algumas pessoas, porém, disseram: —Espere. Vamos ver se Elias vem salvá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mas nesse momento, Jesus deu outro grito e morreu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","No mesmo instante a cortina do templo se rasgou em duas partes, de alto a baixo, houve um terremoto e as rochas se partiram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Os túmulos se abriram e muitos mortos que pertenciam ao povo de Deus ressuscitaram e ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","saíram dos túmulos. E, depois da ressurreição de Jesus, eles entraram na cidade santa de Jerusalém e apareceram a muita gente. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","O comandante do exército romano e os soldados que estavam com ele guardando Jesus, ao verem o terremoto e tudo o mais que estava acontecendo, ficaram com muito medo, e disseram: —De fato, este homem era o Filho de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Algumas mulheres também estavam por ali, observando de longe. Elas tinham seguido a Jesus desde a Galiléia para servi-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Entre elas se achavam: Maria Madalena, Maria (a mãe de Tiago e de José), e a esposa de Zebedeu. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Quando era quase noite, um homem rico da cidade de Arimatéia chegou. Seu nome era José, também discípulo de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Este homem foi conversar com Pilatos para lhe pedir o corpo de Jesus e Pilatos permitiu que ele o levasse. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José, então, pegou o corpo de Jesus, enrolou-o num lençol de linho limpo ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","e o colocou em seu próprio túmulo. (O túmulo era novo e tinha sido cavado numa rocha há pouco tempo). Depois rolou uma grande pedra para fechar a entrada do túmulo e retirou-se. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Madalena e a outra Maria estavam sentadas ali, na frente do túmulo. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","No dia seguinte, isto é, no sábado, os líderes dos sacerdotes e os fariseus se reuniram e foram falar com Pilatos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Eles disseram: —Senhor governador, nós nos lembramos de que, enquanto aquele mentiroso estava vivo, ele tinha dito: “Depois de três dias que eu tiver morrido, eu ressuscitarei”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dê ordens, portanto, para que o túmulo dele seja guardado até o terceiro dia. Dessa forma nós evitaremos que os discípulos dele venham, roubem o corpo e depois digam ao povo que ele ressuscitou dos mortos. Se isso acontecer, esta segunda mentira será ainda pior do que a primeira. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatos, então, lhes disse: —Vocês podem levar alguns soldados; vão e guardem o túmulo da melhor maneira possível. ");
INSERT INTO por_WBTC_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Com aquela autorização, eles foram, selaram a pedra que fechava o túmulo e deixaram ali os soldados para o vigiarem. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Passado o sábado, no domingo bem cedo, Maria Madalena e a outra Maria foram ver o túmulo onde Jesus tinha sido enterrado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Naquela ocasião houve um grande terremoto, pois um anjo do Senhor tinha descido do céu, removido a pedra que fechava o túmulo e agora estava sentado sobre a pedra. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ele se parecia com um relâmpago e as suas roupas eram brancas como a neve. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Os guardas tinham ficado com tanto medo que estavam duros, como se estivessem mortos. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Então o anjo disse às mulheres: —Não tenham medo! Eu sei que vocês vieram procurar por Jesus, aquele que foi crucificado, ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","mas Ele não está mais aqui. Ele ressuscitou, exatamente como havia dito que iria fazer. Venham ver o lugar onde Ele estava deitado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Agora vão depressa e digam aos discípulos dele o seguinte: “Jesus ressuscitou dos mortos e vai adiante de vocês para a Galiléia. Lá vocês o verão novamente”. Façam exatamente como eu falei. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Elas saíram depressa do túmulo, pois estavam com muito medo, mas também muito felizes, e correram para contar aos discípulos o que havia acontecido. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","De repente, Jesus apareceu diante delas e disse: —Olá! E elas se aproximaram dele, abraçaram seus pés e o adoraram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesus, então, lhes disse: —Não tenham medo! Vão e digam aos meus irmãos para se dirigirem à Galiléia. Lá eles me verão novamente. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Quando as mulheres partiram, alguns soldados foram até a cidade e contaram tudo o que tinha acontecido aos líderes dos sacerdotes. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Eles e os anciãos, então, se reuniram para decidir o que iriam fazer. Depois, deram uma boa quantia de dinheiro aos soldados ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","e lhes disseram: —É isto o que vocês devem dizer: “Os discípulos dele vieram de noite e roubaram o corpo enquanto estávamos dormindo”. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Se essas coisas chegarem aos ouvidos do governador, nós o convenceremos de que foi isso mesmo que aconteceu. Vocês não terão problema nenhum. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Os soldados, então, depois de receberem o dinheiro, fizeram exatamente o que os líderes dos sacerdotes e os anciãos tinham dito. E, até o dia de hoje, é nessa versão que os judeus acreditam. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Os onze discípulos seguiram para a Galiléia, para o monte que Jesus lhes havia indicado. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Quando o viram, alguns o adoraram, mas alguns duvidaram. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesus, porém, se aproximou deles, e lhes disse: —Eu recebi autoridade sobre tudo o que está no céu e na terra. ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Portanto, vão, façam discípulos em todas as nações da terra, batizando as pessoas em nome do Pai, do Filho e do Espírito Santo, ");
INSERT INTO por_WBTC_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","e ensinando-as a obedecer todas as coisas que eu ensinei a vocês. E eu estarei com vocês todos os dias, até o fim dos tempos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Isto é o princípio das Boas Novas a respeito de Jesus Cristo, o Filho de Deus, ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","assim como está escrito no livro do profeta Isaías: “Olhe, eu estou enviando o meu mensageiro antes de você. Ele vai preparar o seu caminho”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Escute a voz daquele que clama no deserto: Preparem o caminho para o Senhor, e abram estradas retas para ele passar”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","E foi assim que João Batista apareceu no deserto, batizando o povo e anunciando um batismo de arrependimento para o perdão dos pecados. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Todas as pessoas tanto da região da Judéia como da cidade de Jerusalém iam até ele e, depois de confessarem seus pecados, eram batizadas por ele no rio Jordão. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","João se vestia com roupas feitas de pêlo de camelo, usava um cinto de couro amarrado na cintura e se alimentava com gafanhotos e mel silvestre. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ele dizia: —Depois de mim virá alguém que é mais poderoso do que eu e eu não sou digno sequer de me abaixar para desamarrar as correias das suas sandálias. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Eu os batizo em água, mas ele os batizará no Espírito Santo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Naquela época Jesus veio de uma cidade da Galiléia chamada Nazaré e foi batizado por João Batista no rio Jordão. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Assim que saiu da água, Jesus viu o céu se abrir e o Espírito descer sobre ele na forma de uma pomba. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","E uma voz vinda do céu disse: —Você é o meu Filho querido e me dá muita alegria. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Logo depois o Espírito Santo levou Jesus para o deserto, ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","onde ele foi tentado por Satanás durante quarenta dias. Ele esteve até mesmo com animais selvagens, mas os anjos cuidaram dele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Depois de João ter sido preso, Jesus foi para a Galiléia, anunciando as Boas Novas de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ele dizia: —Chegou a hora! O reino de Deus está próximo. Arrependam-se e acreditem nas Boas Novas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesus estava andando pelo lago da Galiléia quando viu Simão Pedro e seu irmão, André. Eles estavam jogando a rede no mar, pois eram pescadores. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus lhes disse: —Venham comigo e eu farei de vocês pescadores de pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","E eles imediatamente deixaram as suas redes e o seguiram. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Um pouco adiante, Jesus viu outros dois irmãos: Tiago e João, filhos de Zebedeu. Eles estavam no barco preparando as suas redes. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesus os chamou e eles o seguiram, deixando seu pai Zebedeu no barco com os empregados. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Eles foram para a cidade de Cafarnaum. No sábado seguinte Jesus foi para a sinagoga e começou a ensinar o povo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Todos ficaram admirados com o ensino de Jesus, pois ele ensinava como quem tem autoridade, e não como os professores da lei. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Havia na sinagoga um homem que estava possuído por um demônio e, de repente, ele começou a gritar, dizendo: ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—O que você quer de nós, Jesus de Nazaré? Você veio para nos destruir? Eu sei que você é o Santo de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mas Jesus o repreendeu, dizendo: —Cale-se e saia desse homem. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Então o demônio sacudiu o homem várias vezes e, dando um grito bem alto, saiu dele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Todos ficaram impressionados e perguntavam uns aos outros: —O que é isso? Que tipo de ensino novo é esse? Vocês viram com que autoridade ele dá ordens até mesmo a demônios e eles lhe obedecem? ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","E a fama de Jesus se espalhou rapidamente por toda a região da Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Depois de terem saído da sinagoga, eles foram diretamente para a casa de Simão e André, juntamente com Tiago e João. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A sogra de Simão estava de cama, com febre, e assim que Jesus chegou eles lhe contaram a respeito dela. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesus aproximou-se e, pegando-a pela mão, levantou-a. No mesmo momento a febre a deixou e ela começou a servi-los. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","No fim da tarde, ao pôr-do-sol, as pessoas levaram todos os doentes e todos os que estavam possuídos por demônios até Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","E toda a cidade se juntou na porta da casa. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus curou muitas pessoas, as quais sofriam de vários tipos de doenças. Ele também expulsou muitos demônios, não permitindo, porém, que eles falassem, pois sabiam quem ele era. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","De manhã bem cedo, quando ainda estava escuro, Jesus se levantou e foi para um lugar solitário, e ali orou. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pedro e todos os que estavam com ele foram à sua procura e, ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","encontrando-o, disseram-lhe: —Todo mundo está à sua procura. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mas Jesus lhes disse: —Vamos partir para as cidades próximas para que eu possa anunciar as Boas Novas lá também, pois foi para isso que eu vim. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","E Jesus viajou por toda a região da Galiléia, anunciando as Boas Novas nas sinagogas e expulsando demônios. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Um homem com lepra se aproximou de Jesus e, ajoelhando-se diante dele, suplicou-lhe: —Eu sei que, se quiser, o senhor pode me curar. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus ficou cheio de compaixão e, estendendo a mão, tocou nele e disse: —Eu quero; fique curado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","No mesmo instante a lepra o deixou e o homem ficou curado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesus disse então a ele que podia ir embora, mas antes disso fez uma advertência muito séria, ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","dizendo: —Não diga nada disto a ninguém. Antes de mais nada vá até o sacerdote e apresente-se a ele. Depois ofereça o sacrifício que a lei de Moisés manda que seja oferecido pela sua cura. Faça isso para servir de testemunho ao povo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","O homem foi embora, mas começou a contar a todo mundo sobre o que lhe tinha acontecido. Por causa disso Jesus não pôde mais entrar em nenhuma cidade abertamente. Ele passou a viver em lugares isolados; mas, mesmo assim, pessoas de todas as partes iam até ele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Alguns dias depois, Jesus voltou para a cidade de Cafarnaum e a notícia de que ele estava em casa se espalhou. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Então, juntou-se tamanha multidão que não havia lugar nem mesmo perto da porta, do lado de fora. Jesus estava ensinando a sua mensagem a eles ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","quando quatro homens chegaram, levando um paralítico. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Eles não estavam conseguindo se aproximar de Jesus por causa da multidão. Então, abriram um buraco no telhado acima do lugar onde Jesus estava e, pela abertura, abaixaram até ele a maca onde o paralítico estava deitado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ao ver a fé que eles tinham, Jesus disse ao paralítico: —Os seus pecados estão perdoados, meu filho. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Alguns professores da lei, que estavam ali sentados, começaram a perguntar a si mesmos: ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Por que este homem está dizendo essas coisas? Ele está ofendendo a Deus. Quem é que pode perdoar pecados, senão um, que é Deus? ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Imediatamente Jesus percebeu no seu íntimo o que eles pensavam e disse: —Por que vocês estão pensando essas coisas? ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","O que é mais fácil dizer ao paralítico: “Os seus pecados estão perdoados”, ou: “Levante-se, pegue a sua maca e ande”? ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mas eu vou lhes mostrar que o Filho do Homem tem poder na terra para perdoar pecados. Então Jesus disse ao paralítico: ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Levante-se, pegue a sua maca e vá para casa. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ele se levantou e imediatamente pegou a sua maca e, diante de todos que estavam lá, caminhou para fora. Todos ficaram maravilhados e louvavam a Deus, dizendo: —Nunca vimos nada parecido com isto! ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","De novo Jesus saiu e foi para a margem do lago. Toda a multidão foi ao seu encontro e Jesus começou a ensiná-los. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Enquanto Jesus caminhava, ele viu Levi, filho de Alfeu, sentado no lugar onde se pagavam os impostos. Jesus lhe disse: —Siga-me! E Levi, então, levantou-se e o seguiu. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mais tarde, Jesus estava comendo na casa de Levi. Junto com Jesus e seus discípulos estavam muitos cobradores de impostos e pecadores que o seguiam. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Quando os professores da lei, do grupo dos fariseus, viram que Jesus comia com pecadores e com cobradores de impostos, eles perguntaram aos seus discípulos: —Por que ele come com cobradores de impostos e com pecadores? ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus, porém, ao ouvir isto, lhes respondeu: —Não são os que têm boa saúde que precisam de médico, mas sim os que estão doentes. Eu não vim para chamar os justos, mas sim os pecadores. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Os discípulos de João e os fariseus estavam jejuando. Então algumas pessoas se aproximaram de Jesus e lhe perguntaram: —Por que é que tanto os discípulos de João Batista como os fariseus jejuam, e os seus discípulos não jejuam? ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","E Jesus lhes respondeu: —Por acaso os convidados do noivo jejuam enquanto o noivo está com eles? Enquanto o noivo estiver com eles, é claro que não. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Virá o tempo, porém, em que o noivo será levado para longe deles; aí, então, eles jejuarão. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","—Ninguém usa um pedaço de pano novo para remendar uma roupa velha, pois o pano novo vai encolher e rasgar a roupa velha, e o rasgo ficará ainda maior. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Da mesma forma, ninguém coloca vinho novo em odres velhos, pois o vinho arrebentará os odres e tanto o vinho como os odres ficarão arruinados. Vinho novo é colocado em odres novos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Num sábado, Jesus estava atravessando as searas. Enquanto passavam, seus discípulos começaram a colher espigas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Os fariseus, então, lhe perguntaram: —Por que os seus discípulos fazem o que não é permitido fazer no sábado? ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Mas Jesus lhes respondeu: —Vocês nunca leram o que Davi fez quando ele e seus companheiros estavam com fome e não tinham o que comer? ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Davi entrou na casa de Deus no tempo em que Abiatar era o sumo sacerdote, e comeu do pão consagrado a Deus. Somente os sacerdotes é que podiam comer desse pão, mas Davi não só o comeu como também o repartiu com os homens que estavam com ele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Depois Jesus lhes disse: —O sábado foi feito para o homem e não o homem para o sábado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Portanto, o Filho do Homem é Senhor até do sábado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Numa outra ocasião, Jesus entrou novamente na sinagoga. Encontrava-se lá também um homem que tinha uma das mãos aleijada. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Algumas pessoas, porém, estavam lá somente para observar Jesus de perto. Eles queriam ver se Jesus iria curar alguém no sábado, pois assim eles poderiam acusá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus disse ao homem com a mão aleijada: —Levante-se e coloque-se de frente para todos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Depois Jesus perguntou: —O que é permitido fazer no sábado: o bem ou o mal? É permitido salvar uma vida ou destruí-la? Mas ninguém lhe respondeu nada. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus, então, olhou para eles à sua volta. Ele estava zangado e muito triste por causa da dureza dos seus corações. Ele se dirigiu ao homem e lhe disse: —Estenda a sua mão. O homem a estendeu e ela ficou curada. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Os fariseus, então, saíram e, encontrando-se com os herodianos, começaram imediatamente a fazer planos para matá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus partiu com os seus discípulos para o lago da Galiléia, mas uma grande multidão o seguia. Eram pessoas vindas das regiões da Galiléia e da Judéia, ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","de Jerusalém e da Iduméia. Muitos também eram de regiões que ficavam do outro lado do rio Jordão e dos arredores das cidades de Tiro e de Sidom. Eles formavam uma enorme multidão e tinham vindo porque ouviram falar de todas as coisas que Jesus fazia. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","A multidão era tão grande que Jesus pediu aos seus discípulos que lhe arranjassem um barco para que assim ele não fosse apertado pelo povo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ele já tinha curado muita gente e, por causa disso, muitos doentes tentavam a todo custo chegar mais perto de Jesus, a fim de poder tocar nele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Quando os demônios o viam, caíam no chão na sua frente e gritavam: —Você é o Filho de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mas Jesus os advertia severamente para que eles não dissessem quem ele era. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus subiu a um monte e chamou para si aqueles que ele queria. Eles foram e, ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","dentre eles, Jesus escolheu doze, a quem chamou de apóstolos. Jesus os escolheu para que eles andassem sempre com ele, e também para que pudesse enviá-los a proclamar sua mensagem, ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","dando-lhes autoridade até para expulsar demônios. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Estes doze foram os escolhidos: Simão, a quem Jesus deu o nome de Pedro; ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","os irmãos Tiago e João, filhos de Zebedeu, aos quais deu o nome de Boanerges (que quer dizer “Filhos do Trovão”); ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","André, Filipe, Bartolomeu, Mateus e Tomé; Tiago, o filho de Alfeu; Tadeu; Simão, o cananeu; ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","e Judas Iscariotes, que foi quem o traiu. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Depois disso Jesus voltou para casa, mas novamente uma grande multidão se reuniu. Havia tanta gente que Jesus e seus discípulos nem sequer podiam comer. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Quando os parentes de Jesus ficaram sabendo dessas coisas, foram buscá-lo, pois as pessoas estavam dizendo que ele tinha perdido a razão. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Os professores da lei, que tinham vindo de Jerusalém, diziam: —Ele está possuído por Belzebu, o chefe dos demônios! É pelo poder dele que Jesus expulsa os demônios! ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesus, então, chamou-os para perto dele e, por meio de parábolas, lhes disse: —Como é que Satanás pode expulsar Satanás? ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Um reino que estiver dividido e lutar contra si mesmo, não pode durar. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Uma família que estiver dividida e lutar contra si mesma, não pode durar. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Se Satanás se opuser a si mesmo e estiver dividido, ele não durará, porém este será o seu fim. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ninguém entra na casa de um homem forte para lhe roubar os bens sem primeiro amarrá-lo. Depois de fazer isso, então, o ladrão pode entrar e roubar a casa. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Digo a verdade a vocês: Os homens podem ser perdoados de todos os pecados que cometerem e também de todas as coisas más que disserem contra Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mas aquele que insultar o Espírito Santo, esse não será perdoado, uma vez que ele é culpado de pecado eterno. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Jesus disse isto porque eles diziam que ele estava possuído por um demônio.) ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Logo em seguida chegaram a mãe e os irmãos de Jesus. Eles ficaram do lado de fora e mandaram chamá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A multidão sentada à sua volta lhe disse: —A sua mãe e os seus irmãos estão aí fora, perguntando por você. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesus, então, disse: —Quem é a minha mãe e quem são os meus irmãos? ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Depois, olhando para os que estavam sentados no círculo ao seu redor, disse: —Aqui estão a minha mãe e os meus irmãos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Todo aquele que faz a vontade de Deus é meu irmão, minha irmã e minha mãe. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus voltou a ensinar à beira do lago e uma grande multidão juntou-se à sua volta. ele sentou-se então num barco que estava no lago, enquanto as pessoas o escutavam da praia. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesus lhes ensinava muitas coisas mediante parábolas; ele dizia: ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Certo homem saiu para semear. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Enquanto semeava, uma parte das sementes caiu pelo caminho e foi comida pelos pássaros. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Outra parte caiu num terreno onde havia muitas pedras. Essas sementes brotaram rapidamente, pois a terra não era profunda. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","O sol, porém, queimou todas as plantas e elas secaram pois não tinham raiz. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Outra parte das sementes caiu no meio de espinhos. Os espinhos cresceram ao redor das plantas e as sufocaram e por isso elas não deram frutos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Outra parte ainda caiu em terra boa. Elas brotaram, cresceram, deram frutos e produziram trinta, sessenta e até mesmo cem vezes mais. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","E depois disso, disse-lhes: —Aquele que pode ouvir, ouça. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Quando Jesus ficou só, aqueles que estavam ao redor dele vieram com os doze apóstolos e lhe perguntaram por que ele falava por meio de parábolas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesus lhes respondeu: —A vocês é revelado o mistério do reino de Deus. Mas, aos de fora, tudo é ensinado por meio de parábolas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Dessa forma, “Eles olharão e olharão, mas não conseguirão ver; eles escutarão e ouvirão, mas não conseguirão entender. Isto acontecerá para que eles não venham a arrepender-se e a ser perdoados de seus pecados”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesus, então, lhes perguntou: —Vocês não entendem esta parábola? Como, então, poderão entender as outras parábolas? ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","O semeador semeia a mensagem de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Algumas pessoas são como as sementes que caíram à beira do caminho. Elas ouvem a mensagem de Deus, mas logo depois Satanás vem e tira a mensagem que havia sido plantada nelas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Outras pessoas são como as sementes que caíram no meio das pedras. Elas ouvem a mensagem de Deus e a recebem rapidamente e com alegria, ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","mas duram pouco, pois não têm raiz. Elas abandonam a fé assim que as dificuldades e perseguições chegam por causa da mensagem. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Outras pessoas são como as sementes que caíram entre os espinhos. Elas ouvem a mensagem de Deus, ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mas as preocupações com as coisas desta vida, a ilusão das riquezas e o desejo de outras coisas chegam e sufocam a mensagem, e ela não dá frutos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Outras pessoas, ainda, são como as sementes que caíram em terra boa. Elas são aquelas que ouvem a mensagem de Deus, aceitam-na e produzem frutos. Umas produzem trinta, outras sessenta, e outras ainda cem vezes mais. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","E Jesus continuou: —Por acaso um lampião é colocado debaixo de um cesto ou debaixo de uma cama? Ou será que ele é colocado num velador? ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Pois tudo o que está escondido virá a ser descoberto, e tudo o que está em segredo virá a ser revelado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Aquele que pode ouvir, ouça. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Depois, Jesus lhes disse: —Prestem muita atenção a tudo o que vocês ouvem, pois Deus julgará a vocês com a mesma medida que vocês usarem para julgar os outros, e ainda com mais dureza. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Quem tem, receberá ainda mais, mas aquele que não tem, até o que ele tem lhe será tirado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","E Jesus continuou: —O reino de Deus é assim: Um homem joga a semente na terra. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Quer ele esteja dormindo ou acordado, noite e dia, a semente brota e cresce e ele não sabe como isso acontece. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pois a terra produz os grãos por si mesma. Primeiro aparece a planta, depois a espiga e depois os grãos que enchem a espiga. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","E o homem corta a espiga assim que os grãos amadurecem, pois chegou o tempo da colheita. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","E Jesus lhes disse ainda: —O que nós poderíamos dizer a respeito do reino de Deus? A que nós poderíamos compará-lo? ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","O reino de Deus é como um grão de mostarda, que é a menor de todas as sementes quando é plantada na terra. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Depois de plantada, porém, a semente brota e a planta cresce, tornando-se a maior de todas as hortaliças. E ela produz grandes ramos a ponto de as aves dos céus poderem fazer ninhos à sua sombra. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus lhes transmitiu a mensagem de Deus com parábolas como estas, ensinando-lhes até o ponto que podiam entender. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ele somente lhes ensinava por meio de parábolas, mas quando estava sozinho com os seus discípulos, explicava tudo para eles. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Naquele dia, quando estava anoitecendo, Jesus disse aos discípulos: —Vamos atravessar o lago para chegar até o outro lado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Então, deixando a multidão, entraram no barco onde Jesus estava e o levaram; e outros barcos o seguiram. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Uma ventania muito forte começou a soprar e as ondas batiam contra o barco com tal força que ele já estava quase cheio de água. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","E Jesus estava na parte de trás do barco, dormindo sobre um travesseiro. Os discípulos o acordaram e lhe perguntaram: —Mestre, estamos afundando! O senhor não se importa? ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus levantou-se e, depois de repreender o vento, disse para o mar: —Pare! Fique calmo! O vento, então, parou de soprar e tudo ficou calmo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Depois, Jesus lhes disse: —Por que vocês estão com medo? Vocês não têm fé? ");
INSERT INTO por_WBTC_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Os discípulos, porém, sentiam muito medo, e perguntavam uns aos outros: —Quem é este homem que até o vento e o mar lhe obedecem? ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Depois de terem atravessado o lago, eles chegaram à região dos gerasenos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Assim que Jesus saiu do barco, um homem, possuído por um demônio, foi ao seu encontro. Ele vinha do cemitério, ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","pois morava entre os túmulos. Ninguém conseguia prendê-lo nem mesmo com correntes. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Por várias vezes, suas mãos e seus pés tinham sido presos com correntes, mas ele sempre quebrava as correntes e ninguém conseguia dominá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ele sempre andava pelos túmulos e pelos montes, noite e dia, gritando e ferindo-se com pedras. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Quando viu Jesus de longe, o homem correu até ele, caiu de joelhos diante dele e ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","gritou bem alto, dizendo: —O que o senhor quer de mim, Jesus, Filho do Deus Altíssimo? Eu lhe imploro que o senhor jure por Deus que não vai me torturar. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Ele pediu isso porque Jesus estava dizendo: “Demônio, saia desse homem!”) ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","E Jesus lhe perguntou: —Qual é o seu nome? E ele respondeu: —Meu nome é Multidão, pois somos muitos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mas o homem continuou a insistir, pedindo que Jesus não os mandasse para fora daquela região. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Havia um grupo muito grande de porcos pastando num morro ali perto. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Os demônios, então, insistiram com Jesus, pedindo: —Mande-nos para aqueles porcos para que entremos neles. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","E Jesus permitiu que eles saíssem. Então os demônios deixaram o homem e entraram nos porcos. E estes, que eram mais ou menos dois mil porcos, se atiraram morro abaixo, para dentro do lago, onde se afogaram. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Os homens que tomavam conta dos porcos fugiram e contaram tudo isso tanto para os que estavam na cidade como para os que estavam nos campos, e todo o povo correu para ver o que tinha acontecido. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Quando se aproximaram de Jesus, viram o homem que tinha a multidão de demônios sentado, vestido, no seu perfeito juízo; e ficaram com muito medo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Os que tinham visto todas aquelas coisas contaram tudo o que tinha acontecido com o homem que tinha o demônio e com os porcos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","E todo o povo, então, começou a implorar a Jesus para que saísse daquela região. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Quando Jesus estava entrando no barco, o homem que tinha sido curado pediu-lhe: —Deixe-me ir com o senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesus, porém, não o permitiu, e lhe disse: —Vá para a sua própria casa e para o seu próprio povo, e conte-lhes tudo o que o Senhor tem feito por você e também como ele teve misericórdia de você. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","O homem, então, foi embora e começou a contar a todas as pessoas em Decápolis tudo quanto Jesus tinha feito por ele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus voltou para o outro lado do lago e uma grande multidão se reuniu em volta dele na praia. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Um homem chamado Jairo, chefe da sinagoga, também foi. Assim que viu a Jesus, ajoelhou-se aos seus pés, ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","e insistentemente começou a suplicar: —Minha filhinha está morrendo! Eu lhe peço que venha e coloque as suas mãos sobre ela, para que seja curada e que viva. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesus foi com ele e uma grande multidão o seguia, apertando-o de todos os lados. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Havia na multidão uma mulher que há doze anos sofria de hemorragia. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ela já tinha sofrido muito e já tinha gasto tudo o que possuía tratando-se com vários médicos, mas ao invés de melhorar, ia piorando cada vez mais. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Quando ouviu falar de Jesus, atravessou pelo meio da multidão e, aproximando-se por trás dele, tocou em suas roupas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ela dizia consigo mesma: “Se eu puder ao menos tocar nas roupas dele, ficarei curada”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Assim que tocou nele, o sangue parou de correr e ela sentiu em seu corpo que estava curada da sua enfermidade. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","No mesmo instante Jesus percebeu que dele havia saído poder. Virou-se então para a multidão e perguntou: —Quem tocou na minha roupa? ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Os seus discípulos disseram: —Está vendo que a multidão o empurra de todos os lados e ainda pergunta quem o tocou? ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesus, porém, continuou a olhar para todos para ver quem tinha feito aquilo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A mulher, então, tremendo de medo e ciente do que havia acontecido, aproximou-se dele, ajoelhou-se aos seus pés, e disse-lhe toda a verdade. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesus disse a ela: —Filha, a sua fé a curou! Vá em paz; você está curada da sua enfermidade. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus ainda estava falando quando alguns homens chegaram, vindos da casa de Jairo, chefe da sinagoga, dizendo: —A sua filha já morreu, Jairo. Não há mais razão para continuar incomodando o Mestre. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus tinha ouvido o que os homens tinham dito ao chefe da sinagoga e lhe disse: —Não tenha medo; simplesmente tenha fé. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","E Jesus não deixou que ninguém o acompanhasse a não ser Pedro, Tiago e João, o irmão de Tiago. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Eles chegaram à casa do chefe da sinagoga, e lá Jesus viu pessoas desesperadas, chorando muito e lamentando alto. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ele entrou e disse a todos: —Por que todo este desespero e todo este choro? A menina não está morta; ela está apenas dormindo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Todos caçoaram dele. Então, pedindo a todos que se retirassem, levou os pais da criança e os três que estavam com ele para o quarto onde estava a menina. ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Depois, pegou na mão dela e disse: —Talita cumi!— (que quer dizer: “Menina, eu lhe mando que se levante!”). ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","No mesmo instante a menina se levantou e começou a andar pelo quarto, e todos ficaram muito admirados. (A menina tinha doze anos.) ");
INSERT INTO por_WBTC_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesus, então, lhes ordenou que de jeito nenhum contassem nada daquilo a ninguém e também que dessem de comer à menina. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus partiu dali e voltou com seus discípulos para Nazaré, sua cidade, ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","e começou a ensinar na sinagoga no sábado. Muitas pessoas ficaram admiradas quando o ouviram e perguntavam: —Onde este homem aprendeu todas estas coisas? Que tipo de sabedoria é esta que lhe foi dada? Como é que ele faz esses milagres? ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Este homem não é aquele carpinteiro filho de Maria e irmão de Tiago, de José, de Judas e de Simão? Estas moças que estão conosco não são também irmãs dele? Eles não queriam saber dele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesus, então, lhes disse: —Um profeta é respeitado em toda parte, menos em sua própria cidade, entre os seus próprios parentes e dentro de sua própria casa. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","E não pôde fazer nenhum milagre em Nazaré, a não ser curar algumas pessoas depois de colocar as mãos sobre elas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesus, então, ficou admirado com a falta de fé deles. E Jesus percorria as vilas vizinhas ensinando o povo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ele chamou os seus doze discípulos e começou a enviá-los, dois a dois, dando-lhes poder para expulsar demônios. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ele também lhes deu instruções para que não levassem nada com eles durante a viagem, a não ser um cajado. Eles não deveriam levar nem comida, nem sacola, nem dinheiro. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Eles deveriam ir calçados de sandálias, mas não poderiam levar roupas extras. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","E disse-lhes também: —Quando vocês entrarem numa casa, permaneçam lá até que saiam daquela cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","E se vocês chegarem a uma cidade e não forem bem recebidos e não os ouvirem, saiam de lá e sacudam o pó de suas sandálias como uma advertência para aquela gente. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eles, então, partiram e começaram a anunciar que todos deveriam se arrepender de seus pecados. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Eles expulsaram muitos demônios, e curaram muitas pessoas doentes, derramando azeite sobre elas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","O rei Herodes ouviu falar disso, pois o nome de Jesus tinha se tornado conhecido em toda parte. Algumas pessoas diziam: —João Batista ressuscitou e é por isso que ele tem poder para fazer milagres. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Outras diziam: —Ele é Elias. E outras ainda diziam: —Ele é um profeta como um daqueles profetas antigos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Quando Herodes ouviu essas coisas, disse: —João, o homem de quem eu mandei cortar a cabeça, ressuscitou. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes disse isso pois ele mesmo tinha mandado que João fosse preso e colocado na cadeia. Ele tinha feito isso por causa de Herodias, com quem se casara, apesar de ela ser mulher de seu irmão Filipe. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Herodes tinha mandado prender a João, pois este não parava de dizer: —Não lhe é permitido ter a mulher do seu irmão. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias odiava a João por causa dessas coisas e procurava um jeito de matá-lo, mas não encontrava. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes, porém, tinha medo de João e, portanto, o protegia, pois sabia que ele era um homem justo e santo. Herodes gostava muito de ouvi-lo, apesar de João deixá-lo sempre perplexo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Certo dia, porém, Herodias teve a sua chance e não a desperdiçou. No seu aniversário, Herodes deu um banquete para os seus mais altos funcionários, para os oficiais militares e também para as pessoas mais importantes da Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Quando a filha de Herodias entrou e dançou, agradou muito a Herodes e a seus convidados. O rei, então, disse: —Peça-me o que você quiser e eu lhe darei. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","E prometeu-lhe: —Eu lhe darei o que você quiser, mesmo que seja metade do meu reino. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A moça saiu e perguntou à sua mãe: —O que eu poderia pedir? E Herodias respondeu-lhe: —Peça a cabeça de João Batista. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Então, voltando imediatamente à presença do rei, a jovem pediu-lhe: —Quero que o senhor me dê a cabeça de João Batista num prato, agora. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","O rei ficou muito triste mas não podia recusar o pedido dela, não só por causa da promessa que tinha feito, como também por causa de seus convidados. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Então, no mesmo momento o rei deu ordens a um soldado para trazer-lhe a cabeça de João. Ele foi até a prisão, cortou-lhe a cabeça, ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","trouxe-a num prato, deu-a à jovem, e esta a deu à sua mãe. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Quando os seus discípulos ouviram o que tinha acontecido, foram buscar seu corpo e o sepultaram. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Os apóstolos voltaram e, reunindo-se com Jesus, contaram-lhe tudo quanto tinham feito e ensinado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Havia tanta gente indo e vindo que Jesus e seus apóstolos não tinham tempo sequer para comer. Então Jesus lhes disse: —Venham comigo. Vamos sozinhos encontrar um lugar tranqüilo para descansar um pouco. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","E eles partiram de barco, sozinhos, para um lugar sossegado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Muitas pessoas, porém, os viram partir e reconheceram quem eles eram. Pessoas de todos os povoados correram para lá, a pé, e chegaram antes deles. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Quando Jesus saiu do barco, viu uma grande multidão e sentiu muita pena deles, pois eram como ovelhas sem pastor. Então, começou a ensinar-lhes muitas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Quando já estava escurecendo os discípulos de Jesus se aproximaram dele e lhe disseram: —Este lugar é deserto e já está ficando tarde; ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","mande esta gente ir embora para que eles possam chegar até as fazendas e vilas mais próximas e comprar alguma coisa para comer. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","E Jesus lhes disse: —Por que vocês mesmos não lhes dão alguma coisa para comer? Mas eles lhe disseram: —Para comprar pão para toda essa gente nós precisaríamos de duzentas moedas de prata! ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesus, então, perguntou-lhes: —Quantos pães vocês têm? Vão ver. Depois de verificar, eles voltaram e disseram: —Nós temos cinco pães e dois peixes. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Depois de Jesus ouvir isso, mandou que os discípulos fizessem com que todos se sentassem em grupos na grama verde. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","E todos se sentaram em grupos de cem e de cinqüenta pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesus, então, pegou os cinco pães e os dois peixes, olhou para o céu e agradeceu a Deus pelo alimento. Depois os repartiu em pedaços e deu a seus discípulos para que distribuíssem entre o povo. E ele fez o mesmo com os peixes. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","E todos comeram e ficaram satisfeitos, ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","e depois os discípulos encheram doze cestos com pedaços de pão e peixe. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Os homens que comeram dos pães eram cinco mil. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Imediatamente depois, Jesus fez com que os seus discípulos embarcassem e partissem na sua frente para a cidade de Betsaida, do outro lado do lago. Enquanto isso, ele ficaria e despediria a multidão. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Depois de ter-se despedido deles, Jesus foi até um monte para orar. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Quando a noite chegou, o barco estava no meio do lago, e Jesus sozinho em terra. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesus percebeu que eles estavam tendo dificuldades em remar, pois o vento era contrário. Então, por volta das quatro horas da madrugada, Jesus foi até eles caminhando por sobre as águas do lago. E ele estava quase passando adiante deles, quando ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","o viram caminhando por sobre as águas. Eles pensaram que se tratava de um fantasma e gritaram. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Estavam todos aterrorizados por tê-lo visto. Mas logo Jesus falou com eles, dizendo: —Coragem, sou eu! Não tenham medo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Depois, Jesus subiu ao barco com eles e o vento se acalmou. Eles ficaram completamente confusos, ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","pois ainda não tinham entendido nem o milagre dos pães. Eles não conseguiam entender. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Depois de atravessarem o lago, chegaram à cidade de Genesaré, onde amarraram o barco. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Assim que saíram do barco, o povo reconheceu a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Então, correndo por toda aquela região, levavam os doentes em seus leitos para onde quer que ouviam que Jesus estava. ");
INSERT INTO por_WBTC_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","E quer Jesus fosse a vilas, quer a cidades, quer a fazendas, as pessoas levavam os seus doentes para as praças e pediam que os deixassem ao menos tocar na barra de suas roupas. E todos aqueles que tocavam nele ficavam curados. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Os fariseus e alguns dos professores da lei, que tinham vindo de Jerusalém, se aproximaram de Jesus e ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","repararam que alguns dos seus discípulos estavam comendo com mãos impuras, isto é, estavam comendo sem antes terem lavado as mãos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Pois os fariseus e todos os outros judeus não comem sem antes lavar suas mãos com muito cuidado, mantendo a tradição dos antigos.) ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Quando voltam dos mercados das praças, eles não comem nada que não tenha sido muito bem lavado. E há também muitas outras tradições que eles observam, tais como a lavagem de copos, de jarros e até de panelas de metal e camas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","E os professores da lei e os fariseus perguntaram, então, a Jesus: —Por que os seus discípulos não seguem a tradição dos antigos, mas ao invés disso, comem com as mãos impuras? ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mas Jesus lhes disse: —Isaías tinha razão quando profetizou a respeito de vocês, hipócritas, quando escreveu: “Este povo me honra com os seus lábios, mas o seu coração está longe de mim. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","O culto que eles me prestam não vale nada, pois os ensinamentos que eles ensinam são mandamentos feitos por homens”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","—Vocês deixam de lado o mandamento de Deus e se apegam à tradição dos homens. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","E disse-lhes ainda: —Vocês são muito bons em deixar de lado os mandamentos de Deus e estabelecer os seus próprios ensinamentos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Por exemplo: Moisés disse: “Honre a seu pai e a sua mãe” e ainda: “Quem quer que insulte a seu pai ou a sua mãe deve ser punido com a morte”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mas vocês dizem: “Se alguém se aproximar de seu pai ou de sua mãe e disser: Todos os recursos que eu poderia usar para ajudar a vocês são Corbã, isto é, oferta para o Senhor, ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","então vocês o dispensam de fazer qualquer coisa para ajudar a seu pai ou a sua mãe. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Dessa forma vocês anulam os mandamentos de Deus pelas tradições que vocês têm transmitido. E assim como fazem isto, fazem também muitas outras coisas”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesus chamou a multidão para perto de si novamente e lhes disse: —Escutem todos o que eu vou dizer, e entendam: ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Não há nada fora de uma pessoa que, ao entrar nela, a torne impura. Mas, o que sai da pessoa é o que a contamina. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Quando Jesus deixou a multidão e foi para casa, os seus discípulos lhe perguntaram o significado daquela parábola. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","E ele lhes disse: —Será possível que nem vocês compreendem? Será que vocês não entendem que não há nada fora de uma pessoa que, ao entrar nela, possa contaminá-la, ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","pois não vai para o seu coração, mas sim para o estômago, e depois sai para fora do corpo? E, ao dizer isto, ele estava declarando puras todas as comidas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Depois, acrescentou: —É o que sai da pessoa que a torna impura, ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","pois é de dentro, do coração de cada um, que saem os maus pensamentos, os atos imorais, os roubos e os assassinatos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","É do coração também que saem os adultérios, as avarezas, as maldades, a má-fé, a imoralidade, a inveja, as calúnias, a arrogância e a tolice. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Todos estes males vêm de dentro, e são essas coisas que tornam uma pessoa impura. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesus partiu dali e foi para as redondezas da cidade de Tiro. Assim que chegou, entrou numa casa, pois não queria que ninguém soubesse que ele estava ali, mas foi impossível esconder-se. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Logo que uma mulher ouviu falar a respeito de Jesus, foi até ele e se ajoelhou a seus pés. (Ela tinha uma filha possuída por um demônio.) ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A mulher era grega, da região siro-fenícia, e lhe implorava que expulsasse o demônio de sua filha. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ele lhe disse: —Deixe que as crianças se alimentem primeiro, pois não está certo tirar a comida das crianças para dá-la aos cachorrinhos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ela, porém, disse: —Sim, Senhor, mas os cachorros que estão debaixo da mesa comem as migalhas que as crianças deixam cair. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesus, então, lhe disse: —Por causa da resposta que me deu, você pode ir para sua casa em paz, pois o demônio já saiu da sua filha. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","E depois de voltar para casa, a mulher encontrou a filha deitada na cama, pois o demônio já tinha saído dela. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Novamente Jesus partiu das redondezas da cidade de Tiro, e foi para o lago da Galiléia, passando pela cidade de Sidom e também pelo território de Decápolis. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Assim que chegou lá, algumas pessoas levaram a ele um homem que era surdo e gago, e lhe pediram que pusesse a mão sobre ele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus o tirou do meio da multidão e, à parte, tocou nos ouvidos dele com os dedos, e em seguida tocou a língua do homem com saliva. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Depois, olhando para o céu, deu um suspiro profundo e disse:—Efatá!—(que quer dizer: “Abra-se!”). ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","E no mesmo instante os ouvidos do homem se abriram e a sua língua ficou livre e ele começou a falar normalmente. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus tinha ordenado que eles não dissessem nada a ninguém, mas quanto mais ele pedia, mais eles falavam. ");
INSERT INTO por_WBTC_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Todo o povo tinha ficado grandemente admirado e todos diziam: —Ele faz tudo tão bem! Faz até mesmo com que os surdos ouçam e com que os mudos falem! ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Em outra ocasião, uma outra grande multidão se reuniu e não tinham nada para comer. Jesus, então, chamou seus discípulos e disse-lhes: ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Sinto muita pena de toda esta gente; já faz três dias que estão comigo e não têm nada para comer. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Se eu mandá-los embora sem comer eles morrerão pelo caminho, pois alguns deles são de muito longe. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Os seus discípulos perguntaram: —Mas onde poderíamos encontrar comida suficiente para toda essa multidão no meio deste deserto? ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mas Jesus lhes perguntou: —Quantos pães vocês têm? Eles responderam: —Sete. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Então, ordenando à multidão que se sentasse no chão, Jesus pegou os sete pães, agradeceu a Deus, partiu-os e os deu aos seus discípulos, que os distribuíram entre a multidão. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","E, como tinham também alguns peixinhos, Jesus agradeceu a Deus por eles e os deu aos discípulos para que também fossem distribuídos entre o povo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Todos comeram e ficaram satisfeitos e, em seguida, recolheram sete cestos cheios com os pedaços que sobraram. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","(Havia mais ou menos quatro mil pessoas.) Depois disso Jesus mandou que todos fossem para suas casas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Logo depois disto Jesus entrou num barco com os seus discípulos e partiu para a região de Dalmanuta. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Os fariseus chegaram e começaram a discutir com ele e, testando-o, pediram-lhe que lhes mostrasse algum sinal do céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mas Jesus, dando um suspiro profundo, disse: —Por que é que esta geração pede um sinal? Digo a verdade a vocês: nenhum sinal será mostrado para esta geração. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Depois, deixando-os, voltou para o barco e partiu para o outro lado do lago. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Aconteceu que os discípulos tinham se esquecido de levar pão e tinham somente um pão com eles no barco. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus, então, chamando a atenção deles, disse: —Olhem, previnam-se contra o fermento dos fariseus e de Herodes. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eles começaram a discutir uns com os outros e diziam: —Ele está dizendo isso porque nós não temos pão. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus entendeu o que estava acontecendo com eles e lhes disse: —Por que vocês estão discutindo a respeito do fato de não haver pão? Ainda não entenderam? Será que as mentes de vocês são tão estreitas assim? ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Vocês têm olhos mas não vêem; têm ouvidos mas não ouvem! Será que já se esqueceram? ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Quando eu reparti os cinco pães entre aquelas cinco mil pessoas, quantos cestos vocês encheram com o que sobrou?—Doze—responderam eles. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—E quando eu reparti os sete pães para aquelas quatro mil pessoas, quantos cestos vocês encheram com o que sobrou?—Sete—responderam eles. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Então Jesus lhes disse: —Vocês ainda não entenderam? ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Depois disso eles chegaram a Betsaida. Lá as pessoas levaram a ele um cego e imploraram para que tocasse nele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus levou o cego pela mão e guiou-o para fora da vila. Depois, cuspiu-lhe nos olhos e, colocando as mãos sobre ele, perguntou-lhe: —Você está vendo alguma coisa? ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ele olhou e respondeu: —Sim, estou vendo pessoas; e elas se parecem com árvores, mas estão andando. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesus colocou novamente as mãos nos olhos dele. Ele abriu de novo os olhos, sua visão foi restabelecida e podia ver tudo claramente. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Depois disto Jesus mandou que fosse para casa, dizendo: —Não vá para a vila. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesus e seus discípulos partiram para as vilas situadas ao redor da cidade de Cesaréia de Filipe. No caminho, Jesus perguntou a seus discípulos: —Quem é que as pessoas dizem que eu sou? ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Eles responderam: —Alguns dizem que é João Batista; outros dizem que é Elias; e outros, ainda, dizem que é um dos profetas, ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Então Jesus lhes perguntou: —E vocês? Quem é que vocês dizem que eu sou? E Pedro respondeu: —É o Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ao ouvir isto, Jesus lhes ordenou que não dissessem nada a ninguém a respeito dele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Depois Jesus começou a ensinar a seus discípulos, dizendo: —É necessário que o Filho do Homem sofra muitas coisas, que seja rejeitado pelos anciãos, pelos líderes dos sacerdotes e pelos professores da lei, que seja morto e que ressuscite no terceiro dia. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesus disse estas coisas claramente a eles. Mas Pedro o chamou de lado e começou a repreendê-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Então Jesus virou-se e, olhando para os discípulos, repreendeu a Pedro, dizendo: —Afaste-se de mim, Satanás! Você não está interessado nas coisas de Deus, mas nas coisas humanas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Depois de convocar a multidão e os seus discípulos, disse-lhes: —Se alguém quiser vir comigo, tem que negar a si mesmo, pegar a sua cruz e me seguir. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pois todo aquele que quiser salvar a sua vida, irá perdê-la; mas aquele que perder a sua vida por minha causa e por causa das Boas Novas, irá salvá-la. ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Que vantagem terá alguém em ganhar o mundo inteiro e perder a sua alma? ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O que pode um homem dar em troca de sua alma? ");
INSERT INTO por_WBTC_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Se alguém desta geração perversa e pecadora tiver vergonha de mim e das coisas que ensino, o Filho do Homem também terá vergonha dele quando vier na glória de seu Pai com os santos anjos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Depois Jesus lhes disse: — Digo a verdade a vocês: Alguns dos que estão aqui presentes não morrerão antes de ver a vinda poderosa do reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis dias depois Jesus levou Pedro, Tiago e João para um alto monte. Ali Jesus foi transfigurado diante deles. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A sua roupa ficou brilhante de tão branca que nenhum lavadeiro na terra poderia branqueá-la daquela forma. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Moisés e Elias também apareceram e conversavam com Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro, então, disse a Jesus: —Mestre, é bom que nós estejamos aqui. Vamos fazer três tendas: uma para o senhor, uma para Moisés e outra para Elias. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Ele não sabia o que dizer, pois estavam todos com muito medo.) ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Então, uma nuvem veio do céu e cobriu a todos com sua sombra e uma voz, vinda da nuvem, dizia: —Este é o meu Filho querido. Ouçam-no! ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","E, de repente, quando olharam ao redor deles, não viram mais ninguém com eles, a não ser Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Depois, enquanto estavam descendo o monte, Jesus disse-lhes que não contassem a ninguém a respeito das coisas que tinham visto até que o Filho do Homem ressuscitasse dos mortos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Eles guardaram para si o que tinha acontecido, mas perguntavam uns aos outros o que seria a “ressurreição dos mortos”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","E fizeram-lhe esta pergunta: —Por que é que os professores da lei dizem que Elias deve vir primeiro? ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","E Jesus lhes respondeu: —É verdade que Elias virá primeiro para colocar todas as coisas em ordem. Mas então, por que está escrito que o Filho do Homem tem que sofrer muito e ser desprezado? ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Eu lhes digo que Elias já veio e que já fizeram com ele tudo o que quiseram, exatamente como está escrito a seu respeito. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Quando chegaram perto do lugar onde os outros discípulos estavam, viram uma grande multidão ao redor deles. Viram também que os professores da lei estavam discutindo com eles. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Assim que as pessoas da multidão o viram, ficaram surpresas e correram para cumprimentá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ele então lhes perguntou: —O que vocês estão discutindo com eles? ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Um homem que estava no meio da multidão respondeu: —Mestre, eu trouxe o meu filho para que o senhor o visse, pois ele está possuído por um demônio que não permite que ele fale. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Quando esse demônio o ataca, atirando-o no chão, ele espuma pela boca, range os dentes e o seu corpo se torna rígido. Pedi aos seus discípulos para expulsarem o demônio, mas eles não conseguiram. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus, então, disse: —Gente sem fé! Até quando tenho que estar entre vocês? Até quando terei que tolerá-los? Tragam o menino até aqui. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","E eles o levaram. Quando o demônio viu a Jesus, ele imediatamente sacudiu o garoto com força, fazendo com que rolasse no chão e espumasse pela boca. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus perguntou ao pai do rapaz: —Há quanto tempo o garoto está assim? E ele respondeu: —Desde criança. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Muitas vezes esse demônio o atira no fogo ou na água para matá-lo. Se o senhor puder fazer alguma coisa, tenha compaixão de nós e ajude-nos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus lhe disse: —Você disse: “Se o senhor puder”. Tudo é possível para quem tem fé. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","E imediatamente o pai do rapaz gritou, dizendo: —Eu tenho fé! Ajude-me a ter mais fé! ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Quando Jesus viu que uma multidão estava se juntando rapidamente ao redor deles, repreendeu o demônio e disse-lhe: —Eu ordeno, demônio surdo e mudo, que saia deste menino e nunca mais entre nele! ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","O demônio, então, gritando, sacudiu o rapaz com violentas convulsões e saiu dele, deixando-o como morto. A maioria das pessoas dizia que o rapaz tinha morrido. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mas Jesus o pegou pela mão, ajudou-o a se levantar e ele ficou de pé. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Depois que Jesus chegou a casa, seus discípulos lhe perguntaram em particular: —Por que nós não conseguimos expulsar aquele demônio? ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","E Jesus lhes respondeu: —Esse tipo somente pode ser expulso por meio de oração. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesus e seus discípulos saíram dali e viajaram através da região da Galiléia. Jesus não queria que ninguém soubesse onde eles estavam, ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","pois queria ensinar os seus discípulos. E lhes disse: —O Filho do Homem está prestes a ser entregue nas mãos dos homens. Eles o matarão, mas ele ressuscitará depois de três dias. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Os discípulos não entenderam o que Jesus estava dizendo, mas ficaram com medo de perguntar. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Depois foram para a cidade de Cafarnaum. Logo que chegaram a casa, Jesus lhes perguntou: —O que é que vocês estavam discutindo no caminho? ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Eles, porém, não responderam nada, pois durante a viagem tinham discutido a respeito de qual deles seria o mais importante de todos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Então, sentando-se, ele chamou os doze e disse: —Se alguém quiser ser o primeiro, deve ser o último e deve servir a todos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Depois, pegou uma criança e colocou-a no meio deles. A seguir, abraçou-a e disse-lhes: ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Qualquer pessoa que receber uma criança em meu nome, recebe a mim; e quem me recebe, não recebe somente a mim, mas também Aquele que me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","João lhe disse: —Mestre, vimos um homem expulsando demônios em seu nome, mas nós o proibimos porque ele não é do nosso grupo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mas Jesus explicou: —Não o proíbam, pois não há ninguém que faça um milagre em meu nome e logo a seguir possa falar mal de mim. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pois, quem não está contra nós, está a nosso favor. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Digo a verdade a vocês: Se alguém lhes der um copo de água por vocês pertencerem a Cristo, com toda a certeza receberá a sua recompensa. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","—Se alguém fizer com que um destes pequeninos que tem fé em mim peque, seria melhor para essa pessoa que ela fosse jogada ao mar com uma enorme pedra amarrada ao pescoço. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Se a sua mão faz com que você peque, corte-a fora, pois é melhor entrar para a vida eterna sem uma das mãos do que ter as duas mãos e ir para o inferno, para o fogo que nunca se apaga. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","E se o seu pé faz com que você peque, corte-o fora. Pois é melhor entrar para a vida eterna aleijado do que ser jogado no inferno com os dois pés. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","E se o seu olho faz com que você peque, arranque-o fora. Pois é melhor entrar no reino de Deus somente com um olho do que, tendo os dois, ser jogado no inferno, ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","onde os vermes nunca morrem e o fogo nunca se apaga. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Todos serão castigados com fogo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","O sal é bom, mas se perder o seu sabor, como é possível restaurar esse sabor? Desenvolvam boas qualidades em vocês mesmos e vivam em paz uns com os outros. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Depois, partindo dali, ele se dirigiu para a região da Judéia, cruzando o rio Jordão. Uma grande multidão se juntou novamente ao redor de Jesus e ele, como era seu costume, os ensinava. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Alguns fariseus também se aproximaram dele e lhe perguntaram: —É permitido a um homem se divorciar de sua esposa? (Eles perguntaram isso para colocá-lo à prova.) ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ele respondeu: —O que Moisés ordenou? ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Eles responderam: —Moisés permitiu ao homem dar carta de divórcio e mandar a sua mulher embora. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus, porém, lhes disse: —Moisés lhes deu essa lei por causa da teimosia de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pois desde o princípio da criação, como foi dito, “Deus os fez homem e mulher”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Por isso o homem deve deixar seu pai e sua mãe e unir-se à sua esposa, ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","e os dois serão um só”. Portanto, eles não são mais dois, mas sim um só. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Por isso, que ninguém separe o que Deus uniu. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Quando chegaram a casa, os discípulos voltaram a perguntar sobre este assunto. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","E Jesus lhes disse: —Quem se divorcia de sua esposa e se casa com uma outra mulher comete adultério contra sua esposa. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","E a mulher que se divorcia de seu marido e se casa com outro homem também comete adultério. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Depois disso alguns trouxeram algumas crianças para que Jesus as abençoasse, mas os discípulos os repreenderam. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ao ver isto, Jesus ficou indignado e disse-lhes: —Deixem que as crianças venham até a mim. Não as impeçam, pois o reino de Deus pertence aos que são como estas crianças. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Digo a verdade a vocês: Quem não receber o reino de Deus assim como uma criança o faz, nunca entrará nele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","E pegando as crianças no colo, colocava as suas mãos sobre elas e as abençoava. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Quando Jesus estava começando de novo a sua viagem, um homem correu ao seu encontro e, ajoelhando-se aos seus pés, perguntou: —Bom Mestre, o que eu devo fazer para herdar a vida eterna? ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus lhe respondeu: —Por que você me chama de bom? Só Deus é bom e mais ninguém! ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Você conhece os mandamentos: “Não mate, não cometa adultério, não roube, não dê falso testemunho, não seja desonesto, honre o seu pai e a sua mãe”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","O homem, então, disse: —Mestre, desde pequeno tenho obedecido a todos esses mandamentos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus olhou para ele e, sentindo um grande amor por ele, disse-lhe: —Está faltando somente uma coisa: Vá, venda tudo o que você tem e distribua o dinheiro entre os pobres, pois assim você terá tesouro no céu. Depois venha e siga-me. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","O homem, porém, ficou contrariado ao ouvir isso e foi embora triste, pois ele tinha muitos bens. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus olhou ao seu redor e disse aos discípulos: —Como é difícil para os ricos entrarem no reino de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Os discípulos acharam estranho o que Jesus tinha dito, mas ele disse novamente: —Meus filhos, como é difícil entrar no reino de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","É mais fácil um camelo passar pelo buraco de uma agulha, do que um rico entrar no reino de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Eles acharam isso ainda mais estranho e começaram a perguntar uns aos outros: —Então, quem é que pode ser salvo? ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Olhando para eles, Jesus explicou: —É impossível para as pessoas, mas não para Deus, porque para Deus tudo é possível. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro, então, disse: —Olhe, nós deixamos tudo e seguimos o senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","E Jesus respondeu: —Digo a verdade a vocês: Aquele que deixar casa, irmãos, irmãs, mãe, pai, filhos ou propriedades por minha causa e por causa das Boas Novas, ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","receberá muito mais, ainda nesta vida. Ele receberá cem vezes mais casas, irmãos, irmãs, mães, filhos e propriedades, com perseguições. E no futuro receberá a vida eterna. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Muitos dos que agora são os primeiros serão os últimos e muitos dos que agora são os últimos serão os primeiros. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Eles estavam viajando para Jerusalém e Jesus caminhava à frente deles. Os discípulos estavam admirados com ele, mas alguns que o seguiam estavam com muito medo. Então, Jesus chamou os doze discípulos de lado e começou a revelar as coisas que iam acontecer a ele, dizendo: ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Escutem bem! Nós estamos indo para Jerusalém. Lá o Filho do Homem será entregue aos líderes dos sacerdotes e aos professores da lei e eles o condenarão à morte e o entregarão aos que não são judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Eles zombarão dele, cuspirão nele, baterão nele e, por fim, o matarão. Três dias depois ele ressuscitará. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tiago e João, os filhos de Zebedeu, se aproximaram de Jesus e pediram: —Mestre, gostaríamos que nos fizesse uma coisa. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","E Jesus perguntou: —O que vocês querem que eu faça? ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Eles disseram: —Nós gostaríamos que nos desse o direito de sentar ao seu lado na sua glória, um à sua direita e outro à sua esquerda. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus, porém, disse-lhes: —Vocês não sabem o que estão pedindo. Vocês podem, por acaso, beber o cálice que eu bebo ou ser batizados com o batismo com que eu sou batizado? ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Eles responderam: —Podemos. E Jesus lhes disse: —Vocês beberão o cálice que eu bebo e serão batizados com o batismo com que eu sou batizado; ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","mas não sou eu que estabeleço quem vai se sentar à minha direita ou à minha esquerda. Esses lugares são para as pessoas para quem eles foram preparados. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Quando os outros dez ouviram isto, ficaram zangados com Tiago e João. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mas Jesus os chamou e disse-lhes: —Vocês sabem que os que não são judeus são dominados pelos que são considerados seus governadores e são os seus líderes que exercem autoridade sobre eles. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Com vocês, entretanto, isto não acontece. Pelo contrário, aquele que, entre vocês, quiser ser importante, tem que servir a vocês; ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","e aquele que quiser ser o primeiro entre vocês, tem que ser servo de todos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Digo isto pois nem mesmo o Filho do Homem veio para ser servido, mas sim para servir e até mesmo para dar a sua vida como resgate por muitos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus e seus discípulos atravessaram a cidade de Jericó. Quando saíam da cidade, acompanhados por grande multidão, encontraram um mendigo cego sentado à beira da estrada. Seu nome era Bartimeu (isto é, filho de Timeu). ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Quando o cego ouviu que era Jesus de Nazaré que estava passando, começou a gritar, dizendo: —Jesus, filho de Davi, tenha pena de mim! ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Muitas pessoas o repreenderam, mandando que ele ficasse quieto, mas ele gritava ainda mais: —Filho de Davi, tenha pena de mim! ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus, então, parou e disse: —Chamem-no. E eles chamaram o cego, dizendo-lhe: —Coragem! Levante-se, pois ele está chamando você. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimeu atirou o seu casaco para o lado, levantou-se depressa e foi até Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus lhe perguntou: —O que você quer que eu faça por você? E o cego respondeu: —Eu quero voltar a ver, Mestre! ");
INSERT INTO por_WBTC_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Então Jesus lhe disse: —Você pode ir embora agora, pois a sua fé o curou. E no mesmo instante o cego recuperou a sua visão e começou a seguir Jesus estrada fora. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Quando se aproximavam de Jerusalém, Jesus e seus discípulos foram até Betfagé e Betânia, junto ao Monte das Oliveiras. Jesus enviou dois dos seus discípulos, ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","dizendo: —Vão até aquela vila ali adiante. Assim que entrarem na vila vocês encontrarão preso um jumento que nunca foi montado. Soltem-no e tragam-no até aqui. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Se alguém lhes perguntar: “Por que vocês estão fazendo isso?”, respondam: “Porque o Senhor precisa dele, mas logo o devolverá”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Eles partiram e encontraram o jumento preso do lado de fora, perto da porta de uma casa e o soltaram. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Algumas pessoas que estavam lá lhes perguntaram: —O que vocês estão fazendo? Por que estão soltando o jumentinho? ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Os discípulos responderam o que Jesus tinha mandado que eles respondessem e as pessoas deixaram que eles fossem embora. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Eles levaram o jumento até onde Jesus estava, colocaram nele suas capas e Jesus o montou. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Muitas pessoas estenderam as suas capas sobre o caminho e outras espalharam ramos que tinham cortado dos campos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","E todas as pessoas, tanto os que iam à frente de Jesus como os que iam atrás, gritavam: —“‘Glória a Deus’! ‘Bendito é aquele que vem em nome do Senhor!’ ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bendito o reino que vem, o reino do nosso antepassado Davi! Glória a Deus nas maiores alturas!” ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus entrou na cidade de Jerusalém e dirigiu-se para o templo, olhando tudo à sua volta. Como já era tarde, ele partiu para Betânia com seus doze discípulos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","No dia seguinte, quando saíam de Betânia, Jesus sentiu fome. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Então, ao ver uma figueira ao longe com folhas, dirigiu-se até ela para ver se havia algum figo. Mas, ao aproximar-se da árvore, não encontrou nenhum fruto, mas somente folhas, pois não era tempo de figos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Então Jesus disse: —Que nunca mais ninguém coma dos seus frutos! E os discípulos ouviram isto. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Depois disso Jesus e seus discípulos seguiram para a cidade de Jerusalém. Quando entraram no templo, Jesus começou a expulsar todas as pessoas que estavam comprando ou vendendo alguma coisa lá. Ele virou as mesas daqueles que estavam trocando dinheiro e também daqueles que estavam vendendo pombas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Também não deixou que ninguém atravessasse o templo carregando coisa alguma. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Depois, ele começou a ensiná-los, dizendo: —Não está escrito: “Minha casa será chamada casa de oração para todos os povos”? Vocês, porém, a transformaram num “esconderijo de ladrões”! ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ao ouvirem isto, tanto os líderes dos sacerdotes como os professores da lei começaram a procurar uma maneira de matá-lo. Eles tinham medo dele, pois a multidão estava maravilhada com o seu ensino. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Quando anoiteceu, eles saíram da cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na manhã seguinte, quando caminhavam, eles viram a figueira e ela estava seca desde a raiz. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro lembrou e disse a Jesus: —Olhe, Mestre! A figueira que o senhor amaldiçoou ontem secou! ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus, então, disse: —Tenham fé em Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Digo a verdade a vocês: Se alguém disser a este monte: “Levante-se e atire-se no mar” e acreditar que o que disse vai acontecer, sem ter dúvidas em seu coração, então o que disse acontecerá. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Por isso eu lhes digo que tudo quanto vocês pedirem em oração, acreditem que já receberam e será de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","E, quando vocês estiverem orando, se tiverem alguma coisa contra alguém, perdoem a essa pessoa. Dessa forma, o Pai de vocês, que está no céu, também perdoará os seus pecados. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Depois disso eles voltaram para Jerusalém. Enquanto Jesus andava pelo templo, os líderes dos sacerdotes, os professores da lei e os anciãos se aproximaram dele ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","e perguntaram: —Com ordem de quem faz essas coisas? Quem lhe deu autoridade para fazê-las? ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Então, Jesus lhes disse: —Eu vou lhes fazer uma pergunta. Se me responderem, eu lhes direi quem me deu autoridade para fazer essas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Respondam-me isto: Quem deu a João Batista autoridade para batizar: foi Deus ou foram os homens? ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Eles começaram a discutir entre si, dizendo: —Se nós dissermos que foi Deus, ele dirá: “Então por que vocês não acreditaram nele?” ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mas se dissermos que foram os homens …—era para ter medo do povo, pois todos acreditavam que João Batista era verdadeiramente um profeta. ");
INSERT INTO por_WBTC_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Então eles responderam: —Nós não sabemos. Ao que Jesus lhes disse: —Então também não vou dizer com que autoridade faço essas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Depois disto Jesus começou a falar com eles mediante parábolas, e disse: —Um homem fez uma plantação de uvas e a cercou com um muro. Depois construiu um tanque, onde as uvas seriam amassadas, e uma torre. Então arrendou a plantação para alguns lavradores e foi viajar. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Quando chegou o tempo certo, o dono mandou um servo seu aos lavradores a fim de receber parte dos frutos da sua plantação de uvas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Os lavradores, porém, pegaram o servo e, surrando-o, o mandaram de volta de mãos vazias. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ele enviou-lhes outro, mas eles bateram na cabeça dele e o insultaram. Enviou-lhes, então, um outro que, por sua vez, foi morto por eles. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","O dono da plantação de uvas enviou-lhes muitos outros, mas eles bateram em alguns e mataram a outros. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Só restava ao dono da plantação enviar seu querido filho. E enviando-o, finalmente, disse: “Ao meu filho eles respeitarão”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Os lavradores, porém, disseram uns aos outros: “Este é o herdeiro. Se nós o matarmos a herança será nossa”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Então, agarrando ao filho do dono, mataram-no e jogaram o seu corpo fora da plantação. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Agora eu lhes pergunto: O que o dono da plantação de uvas vai fazer com esse lavradores? Ele virá e os matará e arrendará a sua terra a outros lavradores. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Vocês nunca leram as Escrituras? Elas dizem: “A pedra que os construtores rejeitaram veio a ser a pedra mais importante. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Isto foi feito pelo Senhor e é maravilhoso aos nossos olhos!” ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Os líderes dos sacerdotes e os professores da lei entenderam que Jesus tinha dito esta parábola contra eles e começaram a procurar um meio de prendê-lo, mas tinham medo do povo. Então, deixando-o, foram embora. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Depois, enviaram alguns fariseus e alguns herodianos até Jesus para ver se o pegavam em alguma coisa que ele dissesse. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","E, aproximando-se dele, disseram: —Mestre, nós sabemos que é um homem honesto e que não se importa com o que as pessoas possam pensar, pois o senhor não olha para as aparências, mas ensina sempre o caminho de Deus com toda honestidade. É certo ou não pagar impostos a César? Devemos pagá-los ou não? ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesus, porém, percebendo a hipocrisia deles, disse-lhes: —Por que estão me testando? Tragam-me uma moeda de prata para eu ver. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Eles lhe deram a moeda e ele lhes perguntou: —De quem são esta imagem e esta inscrição? —De César—eles responderam. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesus, então, disse-lhes: —Dêem a César o que é de César e dêem a Deus o que é de Deus. E todos ficaram admirados com ele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Depois, alguns saduceus, os quais dizem não haver ressurreição, se aproximaram dele e perguntaram: ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Mestre, Moisés nos deixou escrito que se um homem morrer e deixar a esposa sem filhos, o irmão dele deve casar-se com a viúva para terem filhos que serão considerados filhos do irmão que morreu. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Era uma vez sete irmãos. O primeiro se casou e morreu sem deixar filhos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","O segundo se casou com a viúva e morreu sem deixar filhos. Com o terceiro aconteceu a mesma coisa, ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","e nenhum dos sete teve filhos. Por último, morreu também a mulher. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","No dia da ressurreição, quando todos voltarem à vida, de quem ela será esposa, uma vez que foi casada com todos os sete irmãos? ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus, porém, lhes respondeu: —Como vocês estão enganados! E a razão é que não conhecem as Escrituras nem o poder de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Quando o dia da ressurreição chegar, ninguém se casará nem ninguém será dado em casamento. Porém todos serão como os anjos no céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mas a respeito da ressurreição dos mortos, vocês nunca leram no livro de Moisés, a passagem que fala sobre o arbusto que queimava? Nela Deus disse a Moisés: “Eu sou o Deus de Abraão, o Deus de Isaque e o Deus de Jacó”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ora, ele não é Deus dos mortos, mas sim dos vivos! Vocês estão completamente errados! ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Um dos professores da lei aproximando-se de Jesus, ouviu a discussão e, como tivesse gostado da resposta que Jesus havia dado, perguntou-lhe: —Qual é o mandamento mais importante? ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus respondeu: —O mandamento mais importante é o primeiro: “Ouça, Israel! O Senhor nosso Deus é o único Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ame o Senhor seu Deus de todo o seu coração, de toda a sua alma, de todo o seu entendimento e de toda a sua força”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","O segundo mandamento é este: “Ame ao seu próximo como você ama a você mesmo”. Não há nenhum outro mandamento que seja maior do que estes. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","O professor da lei disse-lhe: —O senhor tem razão, Mestre! Está certo quando diz que Deus é único e que não existe outro a não ser ele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","O senhor também está certo quando diz que devemos amá-lo de todo o nosso coração, com todo o nosso entendimento e com toda a nossa força, e que também devemos amar ao nosso próximo assim como amamos a nós mesmos, pois tudo isso é superior a quaisquer ofertas de animais queimados ou sacrifícios. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Quando Jesus ouviu aquela resposta sábia do professor da lei, disse-lhe: —Você não está longe do reino de Deus. Depois disto, ninguém se atreveu a fazer-lhe mais perguntas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Quando Jesus estava ensinando no templo, disse: —Como podem os professores da lei dizer que o Cristo é filho de Davi? ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","O próprio Davi, inspirado pelo Espírito Santo, disse: “O Senhor disse ao meu Senhor: Sente-se do meu lado direito até que eu coloque todos os seus inimigos debaixo dos seus pés”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Se o próprio Davi o chama de Senhor, como pode ele ser seu filho? E a multidão o ouvia com prazer. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","E enquanto ensinava, dizia: —Tenham cuidado com os professores da lei. Eles gostam de andar com as suas roupas elegantes e de ser cumprimentados com respeito nos lugares públicos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Eles também gostam de ocupar os lugares mais importantes nas sinagogas e os lugares de honra nas festas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Eles exploram as viúvas, roubando delas os seus bens e, ao mesmo tempo, fazem longas orações para serem notados. Estes receberão o pior castigo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus estava sentado perto da caixa de contribuições do templo e observava como as pessoas punham seu dinheiro nela. Muitos ricos depositavam grandes quantias. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Veio, porém, uma viúva pobre e colocou duas pequenas moedas, correspondentes a um centavo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesus, então, chamando os seus discípulos, disse-lhes: —Digo a verdade a vocês: Esta viúva pobre colocou na caixa de contribuições mais do que o fizeram todos os outros! ");
INSERT INTO por_WBTC_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Digo isto pois todos deram o que tinham sobrando; ela, porém, na sua pobreza, deu tudo o que tinha para viver. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Quando Jesus estava saindo do templo, um de seus discípulos lhe disse:—Mestre, veja que beleza de pedras e de edifícios! ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mas Jesus lhe disse: —Você está vendo estes grandes edifícios? Pois eu lhe digo que nenhuma pedra será deixada sobre outra; todas elas serão derrubadas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Quando Jesus estava sentado no Monte das Oliveiras, em frente ao templo, Pedro, Tiago, João e André foram falar com ele em particular: ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Diga-nos, quando essas coisas vão acontecer? Quais serão os sinais que mostrarão que essas coisas estão prestes a se cumprir? ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus, então, começou a dizer-lhes: —Tenham cuidado para que ninguém os engane. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Muitas pessoas virão em meu nome e dirão: “Eu sou Ele” e enganarão muita gente. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Não se assustem quando ouvirem sons de batalhas ou notícias de guerra; essas coisas têm que acontecer, mas ainda não será o fim. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Digo isto porque uma nação fará guerra contra outra e um país atacará outro. Haverá terremotos e fome em vários lugares. Essas coisas serão como as primeiras dores de parto. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","—Vocês precisam ter cuidado! Serão presos e levados aos tribunais e serão espancados nas sinagogas. Também terão de comparecer perante governadores e reis por minha causa a fim de dar testemunho sobre as Boas Novas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","E isto acontecerá porque as Boas Novas devem ser proclamadas primeiro em todas as nações. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Quando vocês forem presos e levados aos tribunais, não se preocupem antes do tempo com o que irão dizer. Naquele momento, digam o que lhes for dado, pois não serão vocês que estarão falando, mas sim o Espírito Santo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Irmãos entregarão a seus irmãos para serem mortos, e pais entregarão seus próprios filhos. Filhos se levantarão contra seus pais e os matarão. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Vocês serão odiados por todos por causa do meu nome, mas aquele que se mantiver firme até o fim será salvo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Quando virem “a terrível coisa que causa desolação” no lugar onde não deveria estar (que o leitor entenda o que isto quer dizer), então quem estiver na Judéia deve fugir para as montanhas, ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","quem estiver em cima da sua casa, no terraço, não deve entrar nela para pegar coisa alguma ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","e quem estiver no campo não deve voltar atrás para ir buscar seu casaco. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ai das mulheres que estiverem grávidas ou amamentando nessa época! ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Orem para que isto não aconteça no inverno. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Porque o sofrimento daqueles dias será tal como nunca aconteceu desde o princípio, quando Deus criou o mundo, até agora. E nunca mais acontecerá. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Se o Senhor não tivesse abreviado aqueles dias, ninguém poderia sobreviver. Mas ele abreviou aqueles dias por causa dos escolhidos que ele selecionou. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","E se alguém lhes disser: “Olhe! Aqui está o Cristo!” ou ainda: “Ali está ele!”, não acreditem. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Digo isto porque falsos Cristos e falsos profetas aparecerão e eles farão milagres e maravilhas com a intenção de, se possível, enganar até o próprio povo escolhido de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Portanto, tenham cuidado! Eu estou lhes avisando com antecedência. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","—Mas naqueles dias, depois dos sofrimentos, “O sol escurecerá e a lua não brilhará. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","As estrelas cairão do firmamento e os corpos celestes serão abalados”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","E então o Filho do Homem será visto, vindo numa nuvem com poder e grande glória. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ele enviará os seus anjos por toda a terra e reunirá os escolhidos de Deus, da extremidade da terra até a extremidade do céu. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","—Aprendam a lição que a figueira nos ensina: Quando os seus ramos se tornam macios e as suas folhas começam a brotar, vocês sabem que o verão está chegando. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Da mesma forma, quando vocês virem estas coisas acontecerem, saibam que o tempo está próximo, batendo à porta. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Digo a verdade a vocês: Esta geração não passará até que todas estas coisas aconteçam. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","O céu e a terra desaparecerão, as minhas palavras, porém, permanecerão para sempre. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","—A respeito daquele dia ou da hora, ninguém sabe, nem os anjos no céu, nem o Filho, mas somente o Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Portanto, tenham cuidado! Estejam sempre alerta, pois ninguém sabe quando a hora vai chegar. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","—É como se um homem que, saindo do país, deixa a sua casa entregue aos cuidados dos seus servos, cada um com a sua obrigação, e manda o porteiro vigiar. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Vocês também devem vigiar, pois também não sabem quando o senhor da casa vai chegar. Ele pode chegar tanto à tarde como à meia-noite, tanto de madrugada como pela manhã. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Vigiem para que, se ele vier inesperadamente, não os encontre dormindo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","O que, porém, lhes digo, digo a todos: Vigiem! ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Faltavam apenas dois dias para a Páscoa e para a Festa dos Pães sem Fermento e tanto os líderes dos sacerdotes como os professores da lei procuravam um meio de prender Jesus à traição, e matá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Eles diziam: —Não vamos fazer isso durante a festa, para que não haja tumulto entre o povo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesus estava na cidade de Betânia, à mesa na casa de Simão, o leproso, quando chegou uma mulher. Ela entrou com um frasco de alabastro cheio de um perfume muito caro feito de nardo puro. Quebrou o frasco e derramou o perfume sobre a cabeça de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Algumas das pessoas que estavam presentes ficaram indignadas e diziam umas para as outras: —Que desperdício! Por que ela fez isso? ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Esse perfume poderia ter sido vendido por mais de 300 moedas de prata e o dinheiro distribuído entre os pobres! E começaram a criticá-la severamente. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mas Jesus lhes disse: —Deixem-na em paz! Por que vocês a estão incomodando? Ela me fez uma coisa boa! ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Os pobres estarão sempre com vocês e poderão ajudá-los quando quiserem. Eu, no entanto, não estarei sempre com vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ela fez o que pôde; derramou perfume sobre o meu corpo antes do tempo e assim preparou-o para o enterro. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Digo a verdade a vocês: Em todos os lugares do mundo onde as Boas Novas forem proclamadas, o que ela acabou de fazer será contado em memória dela. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariotes, um dos doze discípulos, foi falar com os líderes dos sacerdotes a fim de trair Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Quando ouviram isto, eles ficaram muito felizes e lhe prometeram dinheiro. Assim, Judas começou a procurar uma boa oportunidade para trair a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","No primeiro dia da Festa dos Pães sem Fermento, quando o cordeiro da Páscoa era sacrificado, os seus discípulos lhe perguntaram: —Onde quer que nós preparemos o jantar da Páscoa? ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesus, então, chamando dois de seus discípulos, disse-lhes: —Vão até a cidade. Lá, um homem que estará carregando um jarro de água se encontrará com vocês. Sigam-no ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","e digam isto ao dono da casa onde ele entrar: “O Mestre pergunta: Onde fica a sala na qual eu e meus discípulos poderemos comer o jantar da Páscoa?” ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ele lhes mostrará uma sala grande, toda mobiliada e pronta, no andar de cima da casa; façam ali os preparativos para nós. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Os discípulos partiram e foram para a cidade e, encontrando tudo exatamente como Jesus lhes tinha dito, prepararam o jantar da Páscoa. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Quando anoiteceu, Jesus e os seus doze discípulos foram até lá e, ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","enquanto estavam à mesa jantando, disse-lhes: —Digo a verdade a vocês: Um de vocês, que come comigo, me trairá. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","E eles começaram a ficar tristes e a dizer-lhe, um após o outro: —Por acaso sou eu? ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mas Jesus lhes disse: —É um dos doze; um que molha o pão no prato comigo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","O Filho do Homem vai partir, assim como está escrito a respeito dele. Mas ai daquele por quem o Filho do Homem será traído! Seria melhor que ele nunca tivesse nascido! ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Enquanto estavam comendo, Jesus pegou o pão e deu graças a Deus. Depois, partindo-o, deu-o a seus discípulos, dizendo: —Tomem; isto é o meu corpo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Em seguida, Jesus pegou o cálice, deu graças a Deus e passou-o aos discípulos e todos beberam dele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Então Jesus lhes disse: —Isto é o meu sangue, o sangue que sela a aliança entre Deus e seu povo, derramado a favor de muitos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Digo a verdade a vocês: Eu nunca mais beberei vinho até o dia em que beber do vinho novo no reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Em seguida cantaram um hino e foram todos para o Monte das Oliveiras. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesus disse a todos: —Vocês abandonarão a sua fé, pois as Escrituras dizem: “Eu matarei o pastor e as ovelhas se espalharão”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mas, depois que eu ressuscitar, irei adiante de vocês para a Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro, porém, disse-lhe: —Mesmo que todos abandonem a fé, eu nunca a abandonarei. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Então Jesus lhe disse: —Digo-lhe a verdade: Hoje, nesta mesma noite, antes mesmo que o galo cante pela segunda vez, você negará três vezes que me conhece. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro, entretanto, insistiu, dizendo: —Eu nunca negarei que o conheço, nem mesmo que eu tenha que morrer com o senhor. E todos os outros disseram a mesma coisa. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Depois, todos foram para um lugar chamado Getsêmani. Jesus disse aos seus discípulos: —Sentem-se aqui enquanto eu oro. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","E levou Pedro, Tiago e João com ele. Jesus começou a sentir-se angustiado e aflito ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","e então disse aos três: —Meu coração está tão triste que eu poderia morrer. Fiquem aqui e vigiem. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","E, afastando-se um pouco, ajoelhou-se e orou pedindo que, se fosse possível, Deus lhe poupasse aquela hora. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ele pedia: —Pai, querido Pai! Todas as coisas são possíveis para o senhor. Eu lhe imploro que afaste de mim esse cálice de sofrimento, mas que seja feita a sua vontade, e não a minha. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Depois, voltando até o lugar onde os três discípulos estavam, encontrou-os dormindo. Então disse a Pedro: —Você está dormindo, Simão? Será que não pôde vigiar nem mesmo por uma hora? ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Vigiem e orem, para que vocês não caiam em tentação. O espírito está pronto, mas o corpo é fraco. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Depois disso Jesus afastou-se novamente e orou, pedindo a mesma coisa. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","E, voltando pela segunda vez, Jesus os encontrou novamente dormindo, pois os olhos deles estavam pesados. Eles não sabiam o que lhe dizer. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","E, voltando pela terceira vez, disse-lhes: —Vocês continuam dormindo e descansando? Basta! Chegou a hora. O Filho do Homem está sendo entregue nas mãos dos pecadores. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Levantem-se e vamos embora! Olhem! Aí vem o homem que está me traindo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","E nesse mesmo instante, enquanto Jesus estava ainda falando, Judas, um dos doze, apareceu. Muitos homens, armados com espadas ou com pedaços de pau, o acompanhavam. Eles tinham sido enviados pelos líderes dos sacerdotes, pelos professores da lei e pelos anciãos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","O traidor tinha combinado um sinal com eles, dizendo: “Aquele a quem eu beijar, é ele; prendam-no e levem-no com segurança”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Assim que Judas chegou, aproximou-se de Jesus e disse-lhe: —Mestre!—e o beijou. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Então os homens que estavam com Judas pegaram a Jesus e o prenderam. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Um dos homens que estava ali puxou de sua espada e feriu o servo do sumo sacerdote, cortando-lhe a orelha. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus então disse a eles: —Por que vocês vieram com espadas e pedaços de pau para me prender como se eu fosse algum bandido? ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Eu estava com vocês todos os dias, ensinando no templo, e vocês não me prenderam. Mas isto está acontecendo porque as Escrituras têm de ser cumpridas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Então, todos os discípulos o abandonaram e fugiram. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Um jovem que seguia a Jesus usava somente um lençol para cobrir seu corpo. Eles tentaram agarrá-lo pelo lençol, ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","mas ele, largando o lençol, fugiu completamente nu. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesus foi levado ao sumo sacerdote e todos os líderes dos sacerdotes, anciãos e professores da lei se reuniram. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro o tinha seguido de longe até chegar ao pátio do palácio do sumo sacerdote, e estava sentado com os guardas perto do fogo, se aquecendo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Os líderes dos sacerdotes e todo o Conselho Superior de judeus procuravam encontrar alguma prova contra Jesus para que assim pudessem condená-lo à morte, mas não conseguiam. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Muitas pessoas testemunhavam mentiras contra ele, mas os depoimentos não eram coerentes. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Então, alguns homens se levantaram e testemunharam mentiras contra ele, dizendo: ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nós o ouvimos dizer o seguinte: Eu destruirei este templo feito por mãos humanas e, em três dias, construirei outro, que não será feito por mãos humanas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nem assim o testemunho deles era coerente. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","O sumo sacerdote levantou-se então diante de todos e perguntou a Jesus: —Você não vai responder nada? Não vai se defender das acusações que estão sendo feitas contra você? ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesus, no entanto, permaneceu calado, não respondendo nada. O sumo sacerdote dirigiu-se novamente a ele e perguntou: —É verdade que você é o Cristo, Filho do Deus Bendito? ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus lhe respondeu: —É verdade, e vocês verão o Filho do Homem sentado ao lado direito do Todo-poderoso, descendo do céu entre nuvens. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","O sumo sacerdote, então, rasgando as suas roupas, disse: —Será que ainda precisamos de mais provas? ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Vocês ouviram esse insulto contra Deus. O que vocês acham? E todos o julgaram réu de morte. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Algumas pessoas começaram a cuspir nele, a cobrir o seu rosto, a dar-lhe murros e a dizer-lhe: —Revele-nos quem lhe bateu! E os guardas o pegaram e bateram nele. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro ainda estava no pátio do palácio quando uma das empregadas do sumo sacerdote chegou. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Quando ela viu Pedro se aquecendo, olhou bem para ele e disse: —Você também estava com Jesus de Nazaré. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mas ele negou, dizendo: —Eu não o conheço. Não sei do que você está falando. E saiu para o corredor. Logo depois disso o galo cantou. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mas quando a empregada o viu lá, começou a dizer aos que estavam perto: —Este homem é um deles. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","E novamente Pedro negou que conhecia Jesus. Pouco tempo depois as pessoas que estavam ali começaram a dizer a Pedro: —Sem dúvida que você também é um deles, pois você também é da Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro, então, começou a afirmar com juramento: —Eu não conheço esse homem de quem vocês estão falando. ");
INSERT INTO por_WBTC_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","E nesse mesmo instante o galo cantou pela segunda vez, e Pedro se lembrou do que Jesus tinha dito: “Você negará que me conhece por três vezes antes que o galo cante pela segunda vez”. E caindo em si, começou a chorar. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Assim que amanheceu, os líderes dos sacerdotes, os anciãos, os professores da lei e todo o Conselho Superior dos judeus chegaram a uma decisão. Eles amarraram Jesus, levaram-no e o entregaram a Pilatos. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatos lhe perguntou: —Você é o rei dos judeus? Ele respondeu: —É verdade. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Os líderes dos sacerdotes, então, começaram a acusá-lo de muitas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatos tornou a perguntar: —Não vai responder nada? Veja quantas acusações estão sendo feitas contra você! ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mas mesmo assim Jesus não respondeu e Pilatos ficou muito admirado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Durante a festa da Páscoa, Pilatos tinha o costume de soltar um dos prisioneiros, qualquer um que o povo escolhesse. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Havia entre os prisioneiros um homem chamado Barrabás. Ele e outros revolucionários tinham sido presos por terem matado várias pessoas durante um tumulto. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","A multidão se ajuntou e começou a pedir que Pilatos lhes fizesse como de costume. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatos, então, lhes perguntou: —Vocês querem que eu solte o rei dos judeus? ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","(Pilatos disse isso porque sabia que por inveja os líderes dos sacerdotes tinham entregado a Jesus.) ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mas os líderes dos sacerdotes incitaram o povo a pedir que Pilatos lhes entregasse Barrabás ao invés de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatos, então, lhes perguntou mais uma vez: —Então, o que vocês querem que eu faça com este homem que chamam de rei dos judeus? ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","E todos eles gritaram: —Queremos que o senhor o crucifique! ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatos, porém, lhes perguntou: —Mas que mal ele fez? A multidão, no entanto, gritava cada vez mais: —Crucifique-o! ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatos então, para contentar o povo, soltou-lhes Barrabás. Em seguida, mandou que Jesus fosse chicoteado e que depois fosse levado para ser crucificado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Os soldados levaram Jesus para o pátio interno do palácio do governador e lá reuniram toda a tropa. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Primeiro eles o vestiram com uma capa vermelha. Depois, entrelaçando espinhos em forma de uma coroa, puseram-na sobre a cabeça dele ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","e começaram a saudá-lo, dizendo: —Viva o Rei dos Judeus! ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eles bateram na cabeça dele com um pedaço de pau, cuspiram nele e, ajoelhando-se diante dele, o adoravam. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Depois de terem zombado dele, tiraram-lhe a capa vermelha e o vestiram com suas próprias roupas. Em seguida, levaram-no para fora para ser crucificado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","No caminho eles encontraram um homem chamado Simão, da cidade de Cirene. Ele era pai de Alexandre e de Rufo e estava vindo do campo quando os soldados o obrigaram a carregar a cruz de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Eles o levaram até um lugar chamado Gólgota, que quer dizer “Lugar da Caveira”, ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","e lhe deram vinho misturado com mirra para beber, mas ele não aceitou. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Eles o crucificaram e depois dividiram as suas roupas entre si, tirando a sorte com dados para saber qual seria a parte de cada um. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Eram nove horas da manhã quando crucificaram Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Um pouco acima da cabeça de Jesus, pregaram na cruz uma tabuleta onde estava escrito como acusação: “O rei dos judeus”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Crucificaram-no com dois ladrões, um à sua direita e outro à sua esquerda. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","As pessoas que passavam por ali faziam pouco dele e, sacudindo a cabeça, diziam: —Ele não disse que ia destruir o templo e que ia construí-lo de novo em três dias? ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Então que desça da cruz e que se salve! ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Os líderes dos sacerdotes e os professores da lei também caçoavam dele e diziam uns aos outros: —Salvou outros e não consegue salvar a si mesmo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Desça da cruz agora o Cristo, o rei de Israel, para que vejamos e possamos acreditar. E até os que foram crucificados com ele o insultavam. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ao meio-dia uma escuridão cobriu a terra, que permaneceu às escuras por três horas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Às três horas da tarde, Jesus gritou bem alto: —Eloí, Eloí, lamá sabactâni?—(que quer dizer: “Meu Deus, meu Deus! Por que me abandonou?”). ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Quando algumas pessoas que estavam ali ouviram isto, disseram: —Escutem! Ele está chamando a Elias! ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Alguém correu, molhou uma esponja em vinagre e, colocando-a na ponta de uma vara, deu de beber a Jesus. Depois ele disse: —Deixem-no! Vamos ver se Elias vem tirá-lo da cruz! ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mas Jesus deu um grito forte e morreu. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nesse mesmo instante a cortina do templo se rasgou em duas partes, de cima até embaixo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Quando o oficial da guarda que estava em frente de Jesus o ouviu gritar e viu como ele havia morrido, disse: —Realmente este homem era o Filho de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Algumas mulheres que também estavam ali observavam de longe. Entre elas estavam: Maria Madalena, Salomé e Maria, a mãe de Tiago, o jovem, e de José. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Estas mulheres tinham acompanhado e ajudado a Jesus desde o tempo em que ele estava na Galiléia. Muitas outras mulheres que também estavam ali tinham ido com ele para Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Era o dia da preparação, isto é, véspera do sábado. Já era quase noite quando ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","José de Arimatéia, importante membro do Conselho Superior dos judeus e que também esperava pelo reino de Deus, chegou. Com muita coragem José se dirigiu a Pilatos e pediu o corpo de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatos ficou admirado quando ouviu que Jesus já tinha morrido. E, chamando um oficial, perguntou-lhe se fazia muito tempo que Jesus morrera. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Depois de se certificar da morte de Jesus por informação do oficial, Pilatos permitiu que José levasse o corpo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José comprou um lençol de linho e, tirando o corpo de Jesus da cruz, enrolou-o no lençol. Depois, colocou o corpo num túmulo que tinha sido cavado numa rocha e rolou uma grande pedra para fechar a entrada do túmulo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Madalena e Maria, a mãe de José, estavam lá e viram onde o corpo de Jesus tinha sido colocado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Depois que passou o sábado, Maria Madalena, Maria, mãe de Tiago, e Salomé compraram perfumes para derramar sobre o corpo de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo bem cedo, antes mesmo do nascer do sol, elas foram até o túmulo ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","e, enquanto caminhavam, diziam entre si: —Quem vai rolar a pedra da entrada do túmulo para nós? ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","(Elas estavam dizendo isso porque a pedra era muito grande.) Ao olharem adiante, porém, viram que a pedra já tinha sido tirada. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Quando elas entraram no túmulo, ficaram muito assustadas, pois viram um rapaz vestido de roupas brancas, sentado do lado direito. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ele lhes disse: —Não se assustem. Vocês estão procurando a Jesus, o Nazareno, que foi crucificado, não é verdade? Mas ele não está mais aqui; ele ressuscitou. Vejam o lugar onde ele tinha sido colocado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Agora vão e dêem este recado aos discípulos e a Pedro: “Ele irá para a Galiléia antes de vocês. Vocês o encontrarão lá, exatamente como ele mesmo lhes disse”. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Elas saíram correndo do túmulo, pois estavam apavoradas e fora de si; e, por estarem com medo, não disseram nada a ninguém. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Depois de ter ressuscitado, na madrugada de domingo, Jesus apareceu primeiro a Maria Madalena, de quem expulsara sete demônios. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ela foi e contou o acontecido aos que tinham sido companheiros de Jesus, pois eles estavam muito tristes e choravam. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Quando ouviram que Jesus estava vivo e que ela o tinha visto, eles não acreditaram. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Depois disto, Jesus apareceu, numa forma diferente, a dois de seus discípulos que estavam caminhando em direção ao campo. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Eles voltaram e contaram aos outros discípulos, mas estes novamente não acreditaram no que eles disseram. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mais tarde Jesus apareceu aos onze discípulos enquanto estavam comendo. Ele os repreendeu pela sua falta de fé e pela sua teimosia, pois não tinham acreditado nas palavras daqueles que o tinham visto ressuscitado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ele lhes disse: —Espalhem-se por todo o mundo e anunciem as Boas Novas a todas as pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Quem crer e for batizado será salvo, mas quem não crer será condenado. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Estes são os sinais que acompanharão os que crêem: eles expulsarão demônios em meu nome e falarão em outras línguas; ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","se pegarem em cobras com as mãos ou beberem algum veneno, nada de mal lhes acontecerá; eles colocarão suas mãos sobre os doentes e estes ficarão curados. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Depois de ter-lhes dito todas estas coisas, Jesus foi levado ao céu e sentou-se à direita de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Os discípulos, então, partiram e anunciaram a mensagem por todos os lugares. O Senhor os ajudava e confirmava o que eles diziam, realizando por meio deles sinais milagrosos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Excelentíssimo Teófilo: Muitas pessoas já tentaram escrever a respeito das coisas que aconteceram entre nós. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","As mesmas coisas que nos foram transmitidas por aqueles que as viram desde o princípio e que anunciaram a mensagem. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Eu também estudei com bastante cuidado essas coisas e achei que seria bom escrever tudo isto em ordem, ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","para que o senhor saiba toda a verdade a respeito daquilo que lhe ensinaram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Quando Herodes era rei da Judéia, havia um sacerdote chamado Zacarias, que pertencia ao grupo de sacerdotes de Abias. Isabel, sua esposa, era da família de Arão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ambos eram justos diante de Deus e cumpriam sempre todas as leis e mandamentos do Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Eles, porém, não tinham filhos, pois Isabel era estéril e ambos eram muito velhos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Um dia, quando o grupo de Zacarias estava de serviço, coube a ele a função de sacerdote perante Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Conforme o costume, fizeram sorteio para ver quem iria entrar no templo e queimar incenso para o Senhor. A sorte coube a Zacarias. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Fora do templo, o povo continuava orando, enquanto o incenso estava sendo queimado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Então, um anjo do Senhor apareceu a Zacarias do lado direito do altar do incenso. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ao ver o anjo, Zacarias ficou perturbado e com muito medo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","O anjo lhe disse: —Não tenha medo, Zacarias! O Senhor ouviu a sua oração. Isabel, sua mulher, vai ter um filho e você lhe dará o nome de João. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ele vai lhe trazer muita alegria e satisfação e muitas pessoas ficarão felizes com o nascimento dele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ele será um grande homem diante do Senhor. Não beberá vinho nem bebidas fortes e até mesmo antes de nascer estará cheio do Espírito Santo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ele fará com que muitas pessoas do povo de Israel voltem para o Senhor seu Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ele irá à frente do Senhor com o espírito e o poder do profeta Elias. Ele fará com que os pais façam as pazes com os filhos e com que os desobedientes sejam prudentes como os justos. E assim vai preparar um povo para receber ao Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarias disse ao anjo: —Mas como isso pode ser possível? Tanto eu como a minha mulher somos velhos! ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","O anjo lhe disse: —Eu sou Gabriel e estou sempre diante de Deus. Ele me enviou para falar com você e lhe dar estas boas notícias. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tudo o que eu disse vai acontecer no tempo certo. Você, porém, não acreditou nas minhas palavras e, portanto, vai ficar mudo e não será capaz de falar até o dia do nascimento do seu filho. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","(Enquanto isso, a multidão lá fora esperava por Zacarias, admirada por ele se demorar tanto no templo). ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Quando Zacarias saiu, não podia falar com eles. Então entenderam que ele tinha tido uma visão no templo. E fazia sinais com as mãos ao povo, pois ele tinha ficado mudo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Quando terminou o seu trabalho, Zacarias voltou para casa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pouco tempo depois, sua mulher Isabel ficou grávida e não saiu de casa durante cinco meses. Ela disse: ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Finalmente o Senhor me ajudou! Não serei mais humilhada por ninguém! ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Seis meses depois de Isabel ter ficado grávida, Deus enviou o mesmo anjo, Gabriel, a uma vila na Galiléia chamada Nazaré. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ele apareceu a uma moça virgem que ia se casar com um homem chamado José. José era da família de Davi e o nome da moça era Maria. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel lhe disse: —Saudações, Maria! Você recebeu uma grande honra! O Senhor está com você. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ela ficou perturbada e perguntava a si mesma o que aquelas palavras queriam dizer. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","O anjo disse a ela: —Não tenha medo, Maria! Deus favoreceu a você. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Escute! Você vai ficar grávida e vai ter um filho a quem vai dar o nome de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ele será um grande homem e será chamado o Filho do Altíssimo. O Senhor Deus lhe dará o trono de seu pai Davi. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ele reinará eternamente sobre a casa de Jacó e o seu reino não terá fim! ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria então perguntou ao anjo: —Mas como será isso possível se eu nunca tive relações com um homem? ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","E o anjo respondeu a ela: —O Espírito Santo descerá sobre você e o poder do Altíssimo cobrirá você com uma sombra. Por isso, o menino que vai nascer de você será santo e será chamado Filho de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Isabel, sua prima, também ficou grávida apesar de sua velhice. Aquela a quem chamavam estéril está grávida de seis meses. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nada é impossível para Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria disse: —Eu sou uma serva do Senhor. Que aconteça comigo conforme o que diz. E o anjo foi embora. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Logo depois disso acontecer, Maria se aprontou e partiu para uma vila na Judéia, na região das montanhas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","E assim que chegou na casa de Zacarias, ela cumprimentou Isabel. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","E aconteceu que, quando Isabel ouviu a saudação de Maria, a criança se mexeu em seu ventre e Isabel ficou cheia do Espírito Santo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","E Isabel disse então, em voz alta: —Você é a mais abençoada de todas as mulheres! Abençoado também é o filho que lhe vai nascer! ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mas quem sou eu para que a mãe do meu Senhor venha me visitar? ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","O menino dentro de mim se mexeu de alegria assim que ouviu o seu cumprimento. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Você é abençoada por acreditar nas coisas que o Senhor disse que vão acontecer. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria então disse: — A minha alma glorifica o Senhor, ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","e o meu espírito se alegra em Deus, meu Salvador. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Pois olhou para a sua humilde serva e, de agora em diante, todos me chamarão de abençoada. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Porque o Deus poderoso fez grandes coisas por mim. Santo é o seu nome! ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ele é bondoso para com todas as pessoas que o temem, de geração em geração. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ele estende sua mão poderosa, e derrota os orgulhosos com os seus conceitos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ele derruba os poderosos dos seus tronos, e eleva os humildes. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ele enche de bens aqueles que têm fome, e manda os ricos embora de mãos vazias. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ele veio para ajudar o povo de Israel, seu servo, e não esqueceu da sua misericórdia. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ele tem feito o que prometeu aos nossos antepassados, Abraão e a seus descendentes, para sempre. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria permaneceu mais ou menos três meses na casa de Isabel e depois voltou para a sua casa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Chegou a hora de Isabel ter o seu filho e ela deu à luz um menino. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Os vizinhos e a família dela ouviram como o Senhor tinha sido bondoso com ela e também ficaram felizes. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","No oitavo dia, quando vieram para circuncidar o menino, queriam lhe dar o nome de Zacarias, como seu pai. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Porém a mãe dele disse: —Não. O nome do menino será João. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Então eles disseram a ela: —Mas ninguém tem esse nome na sua família! ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Então, por meio de sinais, perguntaram ao pai do menino que nome ele queria que lhe dessem. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarias pediu uma tabuinha de escrever e, para surpresa de todos, escreveu: “O seu nome é João”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nesse mesmo instante a sua língua ficou solta, a sua boca se abriu e Zacarias começou a falar e a louvar a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Todos os vizinhos ficaram impressionados e por todos os montes da Judéia as pessoas falavam destas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Todos os que ouviam estas coisas, meditavam nisto e diziam: —Quem virá a ser esta criança? (Pois era evidente que o poder do Senhor estava sobre ela.) ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Então Zacarias, pai de João, cheio do Espírito Santo, profetizou: ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Louvado seja o Senhor, Deus de Israel, porque ele veio para ajudar e dar liberdade ao seu povo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","E nos deu um poderoso Salvador, nascido da família do seu servo Davi. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Já faz muito tempo que Deus prometeu todas essas coisas por meio dos seus profetas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ele prometeu nos salvar dos nossos inimigos e do poder de todos os que nos odeiam. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ele prometeu que ia mostrar misericórdia para com os nossos pais e se lembrar da sua santa aliança. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ele prometeu a nosso pai Abraão que nos livraria do poder dos nossos inimigos, para que assim nós pudéssemos servir a Deus sem medo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ele fez isso para sermos santos e justos diante dele por todos os dia de nossa vida. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","E você, menino, será chamado profeta do Altíssimo, porque irá à frente do Senhor, para lhe preparar o caminho. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Você vai anunciar ao seu povo a salvação que vem por meio do perdão dos pecados. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Isto acontecerá porque o nosso Deus é bondoso e cheio de misericórdia. E a luz de um novo dia virá dos céus e brilhará sobre nós. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","E essa luz iluminará a todos que vivem na escuridão, na sombra da morte, e guiará os nossos passos no caminho da paz. ");
INSERT INTO por_WBTC_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","O menino crescia e se fortalecia no espírito. Ele viveu no deserto até o dia em que se apresentou ao povo de Israel. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Naquela época, o imperador Augusto mandou publicar uma lei dizendo que todo o mundo romano devia se registrar para um recenseamento. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Quando foi feito este primeiro recenseamento, Quirino era governador da Síria). ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Então, todos foram para as suas próprias cidades para se registrarem. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José também partiu da vila de Nazaré, na Galiléia, para a vila de Belém, na Judéia. José foi para lá porque era descendente do rei Davi e este tinha nascido em Belém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ele foi para lá para se registrar com Maria, que ia se casar com ele e estava grávida. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","E aconteceu que, enquanto estavam em Belém, completou-se o tempo da gravidez de Maria ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","e ela deu à luz o seu primeiro filho. Como não houvesse lugar para eles na hospedaria, Maria enrolou o menino em panos e o deitou numa manjedoura. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Naquela região havia pastores passando a noite no campo, tomando conta de seus rebanhos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Um anjo do Senhor apareceu aos pastores e a glória do Senhor brilhou ao redor deles. E eles ficaram com muito medo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","O anjo lhes disse: —Não tenham medo! Eu vim para lhes dar boas notícias de grande alegria para todo o povo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hoje, na mesma vila onde Davi tinha nascido, nasceu o Salvador. Ele é o Cristo, o Senhor! ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","E isto lhes servirá de sinal: Vocês encontrarão um menino enrolado com panos e deitado numa manjedoura. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","De repente, uma multidão de outros anjos vindos do céu juntou-se ao primeiro anjo. E, todos juntos, louvavam a Deus, dizendo: ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Glória a Deus nas alturas do céu! E paz na terra entre os homens a quem ele quer bem! ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Quando os anjos foram embora e voltaram para o céu, os pastores disseram uns aos outros: —Vamos até Belém para ver o que aconteceu, aquilo que o Senhor nos contou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","E então eles foram depressa e encontraram Maria e José e viram o menino deitado na manjedoura. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","E quando eles o viram, contaram a todos sobre a mensagem que tinham recebido a respeito daquela criança. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Todos os que ouviam o que os pastores diziam ficavam muito admirados. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria, porém, guardava todas estas coisas no coração e meditava sobre elas continuamente. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Os pastores retornaram glorificando e louvando a Deus por todas as coisas que eles tinham visto e ouvido. Tudo ocorrera exatamente como o anjo lhes havia dito. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Oito dias depois, no dia da circuncisão do menino, deram-lhe o nome de Jesus, pois esse era o nome que o anjo lhes tinha dado antes mesmo de o menino nascer. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Quando chegou o tempo da purificação deles, de acordo com a lei de Moisés, eles levaram o menino a Jerusalém para apresentá-lo ao Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Pois assim está escrito na lei do Senhor: “O primeiro filho homem deve ser dedicado ao Senhor”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Eles também foram para oferecer um sacrifício, como manda a lei do Senhor: “Um par de rolas, ou dois pombinhos”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Vivia em Jerusalém um homem justo e piedoso chamado Simeão. Ele estava esperando a libertação do povo de Israel e o Espírito Santo estava sobre ele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","O Espírito Santo lhe tinha prometido que ele não iria morrer antes de ver o Cristo enviado pelo Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Inspirado pelo Espírito, Simeão foi ao templo. Quando os pais levaram o menino Jesus para fazerem com ele o que a lei requeria, ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeão segurou o menino em seus braços e louvou a Deus dizendo: ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Agora, Senhor, deixe o seu servo ir em paz, de acordo com a sua promessa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Os meus olhos já viram a salvação que o Senhor trouxe, ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","a salvação que o Senhor preparou na presença de todos os povos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ele é a luz para guiar as nações e a glória de Israel, o seu povo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","O pai e a mãe do menino ficaram admirados com as coisas que Simeão falou a respeito de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeão os abençoou e disse a Maria, mãe do menino: —Este menino está destinado a fazer caire a levantar muita gente em Israel. Ele será também um sinal de Deus que muitos rejeitarão, ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","para que os pensamentos das pessoas sejam conhecidos. Para você, porém, todas estas coisas serão como espada a atravessar-lhe a própria alma. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Estava lá também uma profetisa chamada Ana. Ela era filha de Fanuel, da tribo de Aser. Ela já era bastante velha e tinha ficado viúva depois de ter vivido com seu marido apenas sete anos após o casamento. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Desde então, ela continuava viúva e estava com oitenta e quatro anos. Ela nunca saía do templo e adorava a Deus dia e noite, com jejuns e orações. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Naquele mesmo momento, ela se aproximou deles, deu graças a Deus e falou a respeito do menino a todos os que esperavam a libertação de Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Quando terminaram de fazer tudo o que a lei do Senhor mandava, José e Maria voltaram para a sua vila, Nazaré, na Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","O menino crescia e ficava cada vez mais forte e cheio de sabedoria, e a graça de Deus estava com ele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Todos os anos os pais de Jesus iam a Jerusalém, para a festa da Páscoa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Quando Jesus tinha doze anos, foram todos para a festa, como de costume. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Quando a festa terminou, ao voltarem para casa, o menino Jesus ficou em Jerusalém, sem que seus pais o soubessem. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mas eles pensaram que ele estivesse com os companheiros de viagem. Depois de terem viajado um dia inteiro, eles começaram a procurá-lo entre os parentes e amigos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Como não o encontraram, voltaram a Jerusalém para procurá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Depois de três dias, eles o encontraram no templo. Ele estava sentado entre os professores, ouvindo e fazendo perguntas a eles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","E todos os que o ouviam estavam admirados com a sua inteligência e com as suas respostas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Quando os pais dele o viram, ficaram surpresos e sua mãe lhe perguntou: —Filho, por que você fez isso? Seu pai e eu estávamos muito aflitos procurando por você. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesus respondeu a eles: —Por que vocês estavam me procurando? Não sabiam que eu devia estar na casa de meu Pai? ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Os pais dele, porém, não entenderam a sua resposta. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Então Jesus voltou com seus pais para Nazaré e lhes obedecia. Sua mãe, entretanto, guardava todas estas coisas no coração. ");
INSERT INTO por_WBTC_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesus crescia em sabedoria e em altura e tinha a aprovação de Deus e dos homens. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Era o décimo-quinto ano do reinado do Imperador Tibério. Pôncio Pilatos era governador da Judéia e Herodes governador da Galiléia. Filipe, irmão de Herodes, governava as regiões de Ituréia e Traconites, e Lisânias governava Abilene. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás e Caifás eram os sumos sacerdotes. Foi nessa época que João, filho de Zacarias, recebeu a mensagem de Deus no deserto. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","João, então, andou por toda a região do rio Jordão, anunciando um batismo baseado no arrependimento para perdão de pecados. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isto aconteceu como está escrito no livro do profeta Isaías: “Uma voz está clamando no deserto: Preparem o caminho para o Senhor, e abram estradas retas para ele passar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Todos os vales serão aterrados e todos os montes e colinas serão aplanados. Os caminhos tortos serão endireitados e as ruas esburacadas serão alisadas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","E todas as pessoas verão a salvação que vem de Deus”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","João dizia às multidões que vinham para serem batizadas por ele: —Raça de cobras venenosas! Quem avisou a vocês para escaparem do castigo que Deus vai mandar? ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Façam coisas que mostrem que vocês se arrependeram e não comecem a dizer entre vocês mesmos: “Abraão é nosso pai”. Pois eu lhes digo que até destas pedras Deus é capaz de fazer descendentes de Abraão! ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","O machado já está pronto para cortar as árvores pela raiz. Toda árvore que não produz bons frutos será cortada e jogada no fogo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","E a multidão perguntou a ele: —Então, o que devemos fazer? ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ele lhes respondeu: —Aquele que tem duas túnicas deve dar uma a quem não tem nenhuma. E aquele que tem comida deve repartir com quem não tem. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Alguns cobradores de impostos também vieram para serem batizados e perguntaram a João: —Mestre, o que devemos fazer? ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","E ele lhes respondeu: —Não cobrem mais do que a lei manda. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Alguns soldados lhe perguntaram: —E o que nós devemos fazer? Ele lhes disse: —Não tirem dinheiro de ninguém nem acusem ninguém injustamente. Contentem-se com o seu próprio salário. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","O povo estava cheio de expectativa e perguntava a si mesmo se não seria João o Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","João respondeu assim a todos: —Eu batizo vocês em água, mas virá alguém que é mais poderoso do que eu e eu não sou digno nem de desamarrar as sandálias dele. Ele batizará com o Espírito Santo e com fogo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ele tem uma pá nas mãos e com ela ele vai separar o trigo da palha. O trigo será juntado em seu depósito, mas a palha será queimada com um fogo que nunca se apaga. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","E João anunciou as Boas Novas ao povo com muitas outras admoestações. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","(Mas depois João falou contra Herodes, o governador, censurando-o por causa de seu relacionamento com Herodias, mulher do seu irmão, e por todas as outras maldades que ele tinha feito. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes então, além de tudo isso, fez uma maldade ainda pior: mandou prender a João.) ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Aconteceu que, quando todas as pessoas estavam sendo batizadas, Jesus também foi batizado. Enquanto ele estava orando, o céu se abriu ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","e o Espírito Santo desceu sobre ele em forma de pomba. E uma voz vinda do céu disse: —Você é o meu Filho querido. Você me dá muita alegria. ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus tinha cerca de trinta anos quando começou o seu trabalho. Ele era, conforme pensavam, filho de José. José era filho de Eli; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli, filho de Matate; Matate, filho de Levi; Levi, filho de Melqui; Melqui, filho de Janai; Janai, filho de José; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José, filho de Matatias; Matatias, filho de Amós; Amós, filho de Naum; Naum, filho de Esli; Esli, filho de Nagai; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai, filho de Maate; Maate, filho de Matatias; Matatias, filho de Semei; Semei, filho de José; José, filho de Joda; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda, filho de Joanã; Joanã, filho de Resa; Resa, filho de Zorobabel; Zorobabel, filho de Salatiel; Salatiel, filho de Neri; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, filho de Melqui; Melqui, filho de Adi; Adi, filho de Cosã; Cosã, filho de Elmadã; Elmadã, filho de Er; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er, filho de Josué; Josué, filho de Eliézer; Eliézer, filho de Jorim; Jorim, filho de Matate; Matate, filho de Levi; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi, filho de Simeão; Simeão, filho de Judá; Judá, filho de José; José, filho de Jonã; Jonã, filho de Eliaquim; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim, filho de Meleá; Meleá, filho de Mená; Mená, filho de Matatá; Matatá, filho de Natã; Natã, filho de Davi; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davi, filho de Jessé; Jessé, filho de Obede; Obede, filho de Boaz; Boaz, filho de Sala; Sala, filho de Nassom; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nassom, filho de Aminadabe; Aminadabe, filho de Admim; Admim, filho de Arni; Arni, filho de Esrom; Esrom, filho de Peres; Peres, filho de Judá; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá, filho de Jacó; Jacó, filho de Isaque; Isaque, filho de Abraão; Abraão, filho de Tera; Tera, filho de Naor; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor, filho de Seruque; Seruque, filho de Ragaú; Ragaú, filho de Faleque; Faleque, filho de Éber; Éber, filho de Sala; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala, filho de Cainã; Cainã, filho de Arfaxade; Arfaxade, filho de Sem; Sem, filho de Noé; Noé, filho de Lameque; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameque, filho de Metusalém; Metusalém, filho de Enoque; Enoque, filho de Jarete; Jarete, filho de Maleleel; Maleleel, filho de Cainã; ");
INSERT INTO por_WBTC_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainã, filho de Enos; Enos, filho de Sete; Sete, filho de Adão; e Adão, filho de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus estava cheio do Espírito Santo quando voltou do rio Jordão, e foi levado pelo Espírito para o deserto. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ali, durante quarenta dias ele foi tentado pelo Diabo e não comeu nada nesse período. Depois disso Jesus teve fome. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Então o Diabo lhe disse: —Se você é mesmo o Filho de Deus, mande esta pedra se transformar em pão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus respondeu: —As Escrituras dizem: “Nem só de pão vive o homem”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Então o demônio o levou para um lugar alto e lhe mostrou, num só momento, todos os reinos do mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","E lhe disse: —Eu lhe darei todo este poder e toda esta glória, pois tudo isto me foi dado e eu posso dar a quem quiser. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tudo isto será seu se você se ajoelhar para me adorar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus lhe disse: —As Escrituras dizem: “Adore ao Senhor seu Deus e sirva somente a ele”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Depois, o Diabo levou a Jesus para Jerusalém, colocou-o no ponto mais alto do templo e lhe disse: —Se você é mesmo o Filho de Deus, atire-se daqui para baixo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pois as Escrituras dizem: “Ele dará ordens aos seus anjos para que cuidem de você”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","As Escrituras também dizem: “Eles vão segurá-lo com suas mãos para que nem os pés machuque nas pedras”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesus lhe disse: —Também as Escrituras dizem: “Não ponha o Senhor seu Deus à prova”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Quando o Diabo acabou de tentar a Jesus de todas as maneiras, ele o deixou, até uma outra oportunidade. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesus voltou para a Galiléia e o poder do Espírito Santo estava com Ele. E a sua fama se espalhou por toda a região. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ele ensinava nas sinagogas e todos o elogiavam. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesus foi para Nazaré, onde ele tinha crescido. No sábado foi à sinagoga, como era seu costume. Ali ele se levantou para ler as Escrituras, ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","e lhe deram o livro do profeta Isaías. Ele o abriu e achou o lugar onde estava escrito: ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“O Espírito do Senhor está sobre mim. Ele me escolheu para proclamar as Boas Novas aos pobres e anunciar a liberdade aos presos. Ele me enviou para dar vista aos cegos, para libertar os que estão sendo maltratados e ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","para anunciar o ano em que o Senhor vai favorecer o seu povo”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Depois de ler, Jesus fechou o livro, deu-o ao ajudante da sinagoga e se sentou para ensinar. E os olhares de todos estavam fixos nele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Então ele começou a falar: —Hoje se cumpriu a Escritura que vocês acabaram de ouvir. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Todos estavam elogiando a Jesus e admirados com as palavras bonitas que ele falava. Eles diziam: —Este não é o filho de José? ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ele lhes disse: —Sem dúvida vocês vão me repetir aquele ditado que diz: “Médico, cure-se a si mesmo!”, e vão também dizer: “Por que não faz aqui, na sua terra, as mesmas coisas que ouvimos dizer que fez em Cafarnaum?” ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","E disse ainda: —Digo a verdade a vocês: Nenhum profeta é bem recebido em sua própria terra. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Digo a verdade a vocês: Havia muitas viúvas em Israel no tempo do profeta Elias, quando não choveu por três anos e meio e houve grande fome em toda a terra. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mas Elias foi enviado somente a uma viúva em Sarepta, na região de Sidom, e a nenhuma outra. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Havia também muitos leprosos em Israel no tempo do profeta Eliseu, mas nenhum deles foi curado, com exceção de Naamã, o sírio. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Todos os que estavam na sinagoga ficaram com muita raiva quando ouviram essas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Então levantaram-se, expulsaram-no da cidade e levaram-no para a beira do monte sobre o qual a cidade estava construída, com a intenção de jogá-lo de lá para baixo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesus, porém, passou pelo meio deles e seguiu o seu caminho. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Depois Jesus foi para Cafarnaum, cidade da Galiléia. Ali ele ensinava o povo no sábado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Todos ficaram admirados com o seu ensino porque ele falava com autoridade. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Estava na sinagoga um homem que tinha um demônio dentro de si e ele gritou bem alto: ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—O que você quer de nós, Jesus de Nazaré? Você veio para nos destruir? Eu sei que você é o Santo de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mas Jesus o repreendeu, dizendo: —Cale-se e saia desse homem! Então o demônio jogou o homem no chão no meio de todos e saiu dele sem o machucar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Todos ficaram impressionados e começaram a comentar uns com os outros: —Que ensino é este? Vocês viram com que autoridade e poder ele dá ordens aos demônios e eles saem? ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","E a sua fama se espalhou por toda região. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Depois de sair da sinagoga, Jesus foi para a casa de Simão. A sogra dele estava com uma febre muito alta e lhe pediram que a ajudasse. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesus debruçou-se sobre ela, repreendeu a febre e esta a deixou. No mesmo instante ela se levantou e começou a servi-los. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ao pôr do sol, todos aqueles que tinham parentes com vários tipos de doenças, os levaram a Jesus. Ele punha as mãos sobre cada um deles e os curava. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Também de muitos deles saíam demônios, gritando: —O senhor é o Filho de Deus! Mas Jesus os repreendeu e não os deixou falar, porque eles sabiam que ele era o Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Quando amanheceu, Jesus foi para um lugar solitário. A multidão estava à procura dele e, quando o encontraram, não queriam deixá-lo ir embora. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesus, porém, disse a eles: —Eu preciso anunciar as Boas Novas a respeito do reino de Deus a outras cidades também, pois foi para isso que Deus me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","E ele continuou a ensinar nas sinagogas da Judéia. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Certo dia, Jesus estava perto do Lago de Genesaré e uma multidão se ajuntou ao seu redor, apertando-o para ouvir a mensagem de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesus, então, viu dois barcos perto da praia. Os pescadores tinham desembarcado e estavam lavando as suas redes. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ele entrou no barco que era de Simão e lhe pediu que afastasse um pouco o barco da praia. Depois ele se sentou e começou a ensinar a multidão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Quando ele acabou de falar, disse a Simão: —Leve o barco para onde o lago é mais fundo. E você e seus companheiros joguem as redes para pescar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simão lhe disse: —Mestre, nós trabalhamos a noite inteira e não pegamos nada. Mas como manda jogar as redes, eu obedecerei. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Quando jogaram as redes, pegaram tantos peixes que as redes deles estavam quase arrebentando. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Então, fizeram sinais aos companheiros do outro barco para ajudá-los. Eles foram e encheram os dois barcos de tal maneira que quase se afundaram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simão Pedro, quando viu isso, se ajoelhou aos pés de Jesus e disse: —Afaste-se de mim, Senhor, pois eu sou um pecador! ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ele disse isso porque tanto ele como os outros estavam muito assustados com a quantidade de peixes que tinham apanhado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tiago e João, filhos de Zebedeu e companheiros de Simão, também estavam muito assustados. Então Jesus disse a Simão: —Não tenha medo! De agora em diante você será pescador de gente. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Eles então arrastaram os barcos para a terra, deixaram tudo, e o seguiram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","E aconteceu que, enquanto Jesus ensinava numa vila, lá também apareceu um homem coberto de lepra. Ao ver Jesus, o homem se ajoelhou com o rosto encostado na terra e pediu: —Eu sei que, se o senhor quiser, pode me curar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Então Jesus estendeu a mão, tocou nele e disse: —Eu quero! Fique curado. No mesmo instante a lepra desapareceu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesus, então, lhe deu esta ordem: —Não conte isso a ninguém, mas vá e se apresente ao sacerdote. Ofereça o sacrifício pela sua purificação, como Moisés mandou. Faça isso para provar que está curado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mas a sua fama se espalhava cada vez mais e grandes multidões se juntavam para ouvi-lo e para serem curadas de suas doenças. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ele, porém, sempre ia para lugares solitários para orar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Um dia, quando Jesus estava ensinando, achavam-se presentes alguns fariseus e professores da lei, vindos de todas as vilas da Galiléia e da Judéia e da cidade de Jerusalém. E o poder do Senhor estava com Jesus para realizar curas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Alguns homens chegaram trazendo um paralítico numa maca e tentavam levá-lo para perto de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","E, como não tinham conseguido entrar com ele por causa da multidão, subiram no telhado e, por entre as telhas, abaixaram a maca no meio das pessoas que estavam ali e o puseram diante de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ao ver a fé que eles tinham, Jesus disse: —Homem, os seus pecados estão perdoados! ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Os professores da lei e os fariseus começaram a perguntar a si mesmos: —Quem é este homem que está ofendendo a Deus com estas palavras? Quem pode perdoar pecados, senão um, que é Deus? ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus sabia o que eles estavam pensando e disse-lhes: —Por que vocês estão pensando essas coisas? ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","O que é mais fácil dizer: “Os seus pecados estão perdoados” ou “Levante-se e ande”? ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mas eu vou lhes mostrar que o Filho do Homem tem poder na terra para perdoar pecados. E então disse ao paralítico: —Levante-se, pegue a sua maca e vá para casa! ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","E imediatamente ele se levantou, pegou sua maca e foi para casa louvando a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Todos ficaram maravilhados e muito impressionados e por isso louvavam a Deus, dizendo: —Que coisa maravilhosa nós vimos hoje! ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Depois disto, Jesus saiu e viu um cobrador de impostos chamado Levi, que estava sentado no posto de cobrança e lhe disse: —Siga-me! ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi se levantou, deixou tudo, e o seguiu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi deu um grande banquete em sua casa para Jesus. Muitos cobradores de impostos e outras pessoas estavam comendo com eles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","E os professores da lei e os fariseus se queixavam aos discípulos de Jesus: —Por que vocês comem e bebem com cobradores de impostos e pecadores? ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","E Jesus lhes respondeu: —Aqueles que estão bem não precisam de médico, mas sim aqueles que estão doentes. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Eu vim para chamar os pecadores para se arrependerem e não os justos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Eles lhe disseram: —Os discípulos de João jejuam freqüentemente e fazem orações e o mesmo acontece com os discípulos dos fariseus. Os seus discípulos, porém, estão sempre comendo e bebendo! ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus perguntou: —Vocês acham que podem obrigar os convidados do noivo a jejuarem enquanto o noivo estiver com eles? ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Claro que não! Mas virá o tempo em que o noivo será levado para longe deles. Daí então jejuarão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesus lhes contou uma parábola: —Ninguém corta um pedaço de roupa nova para remendar numa roupa velha. Se fizer isso, além de estragar a roupa nova, o pedaço novo não vai combinar com a roupa velha. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ninguém coloca vinho novo em odres velhos. Se fizer isso, o vinho novo arrebentará os odres velhos, o vinho se derramará e os odres ficarão arruinados. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Deve-se colocar vinho novo em odres novos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ninguém, depois de beber vinho velho, quer vinho novo, pois diz: “O vinho velho é melhor!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Num certo sábado, Jesus estava atravessando um campo de trigo. Os seus discípulos começaram a colher algumas espigas e, debulhando-as, comiam os grãos de trigo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Então alguns dos fariseus disseram: —Por que vocês estão fazendo o que não é permitido fazer no sábado? ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus respondeu: —Vocês não leram o que Davi fez quando ele e os seus companheiros tiveram fome? ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Vocês não leram como ele entrou na casa de Deus, pegou o pão sagrado e o comeu, repartindo-o também com os homens que estavam com ele? Entretanto não é permitido a ninguém comer desse pão a não ser aos sacerdotes. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","E também disse a eles: —O Filho do Homem é Senhor do sábado! ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Num outro sábado, Jesus foi para a sinagoga e começou a ensinar. Lá estava também um homem que tinha sua mão direita aleijada. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Os professores da lei e os fariseus ficaram observando a Jesus para ver se ele ia curar alguém no sábado. Eles procuravam algum motivo para acusar a Jesus de desobedecer à lei. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesus conhecia o pensamento deles, mas mesmo assim disse ao homem com a mão aleijada: —Levante-se e fique de pé na frente de todos. Ele se levantou e ficou de pé. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Então Jesus disse a eles: —Agora eu pergunto a vocês: O que é permitido fazer no sábado: o bem ou o mal? É permitido salvar uma vida ou destruí-la? ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","E olhando ao seu redor para todos eles, disse ao homem: —Estenda a sua mão. O homem a estendeu e ela ficou boa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Eles, porém, ficaram furiosos e começaram a planejar o que poderiam fazer contra Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Naqueles dias Jesus subiu a um monte para orar e passou a noite toda orando a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Quando amanheceu, ele chamou os discípulos e escolheu doze entre eles, a quem deu nome de apóstolos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Eram eles: Simão, a quem ele deu o nome de Pedro, e André, irmão dele; Tiago e João; Filipe e Bartolomeu; ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateus e Tomé; Tiago, o filho de Alfeu; Simão, que pertencia ao grupo dos zelotes; ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, o filho de Tiago; e Judas Iscariotes, que se tornou traidor. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesus desceu com eles para um lugar plano onde havia uma grande multidão de seus discípulos. Estavam lá pessoas vindas de toda a Judéia, de Jerusalém e também de Tiro e de Sidom, cidades do litoral. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Elas tinham ido para ouvi-lo e para serem curadas de suas doenças. E aqueles que eram atormentados pelos demônios também eram curados. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Toda a multidão o seguia para tocar nele, porque dele vinha uma força que curava a todos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Olhando para os seus discípulos, disse: —Felizes são vocês, os pobres, porque o reino de Deus é de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Felizes são vocês que agora têm fome, porque terão fartura. Felizes são vocês que agora choram, porque vão rir. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Felizes são vocês, quando os homens os odeiam, os expulsam, os insultam, e quando desprezam os seus nomes e os rejeitam por causa do Filho do Homem. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Alegrem-se nesse dia e fiquem realmente muito felizes, porque uma grande recompensa está guardada para vocês no céu! Os antepassados destas pessoas fizeram o mesmo aos profetas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mas ai de vocês, os ricos, pois vocês já receberam o seu conforto! ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ai de vocês, os que agora têm fartura, porque vão ter fome! Ai de vocês que agora estão rindo, porque vão chorar e lamentar! ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ai de vocês que são elogiados por todos, porque os antepassados destas pessoas também elogiavam os falsos profetas! ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mas eu digo a vocês que estão me escutando: Amem os seus inimigos e façam o bem mesmo para aqueles que odeiam a vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Falem bem daqueles que amaldiçoam a vocês e orem por aqueles que maltratam a vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Se alguém lhe bater num lado do rosto, vire-lhe também o outro lado. Se alguém pegar a sua capa, deixe levar a sua túnica também. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dê para todo aquele que lhe pedir alguma coisa e, se alguém levar o que é seu, não peça de volta. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tratem as outras pessoas da maneira que vocês gostariam de ser tratados por elas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","—Pois, se vocês amarem somente aqueles que os amam, que louvor vocês esperam receber? Até mesmo os pecadores amam aqueles que os amam! ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","E se vocês fizerem o bem somente para aqueles que fazem o bem para vocês, que louvor vocês esperam receber? Até mesmo os pecadores fazem isso. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Se vocês emprestarem somente para aqueles que vocês acham que vão pagar, que méritos vocês esperam ganhar? Até os pecadores emprestam a pecadores para receberem de volta a mesma quantia. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ao contrário, amem os seus inimigos e façam o bem a eles. Emprestem e não esperem receber de volta o que emprestaram, pois assim a sua recompensa será grande e vocês serão chamados filhos do Altíssimo. Façam isto porque Deus também é bom para com os ingratos e maus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sejam misericordiosos como o Pai de vocês é misericordioso. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Não julguem os outros para que não sejam julgados. Não condenem os outros para que não sejam condenados. Perdoem os outros para que sejam perdoados. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dêem aos outros e também será dado a vocês. Vocês receberão muito, uma quantidade generosa que será colocada nas suas mãos, mais do que vocês poderão carregar. Pois a medida que vocês usarem para com os outros, será a mesma que se usará para com vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","E Jesus também fez esta comparação: —Pode um cego guiar outro cego? Por acaso não cairão os dois no buraco? ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nenhum discípulo é mais importante do que o seu mestre mas, qualquer um, depois de bem treinado, será igual ao seu mestre. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Por que você olha para o cisco que está no olho do seu irmão e não vê o tronco que está no seu próprio olho? ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Como você pode dizer: “Irmão, deixe-me tirar o cisco do seu olho”, quando você nem vê o tronco que está no seu próprio olho? Hipócrita! Tire primeiro o tronco que está no seu olho e então verá muito melhor para tirar o cisco do olho do seu irmão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Não há árvore boa que dê maus frutos, nem árvore má que dê bons frutos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Cada árvore é conhecida pelos seus próprios frutos. Não se colhe figos de espinheiros e nem uvas de plantas espinhosas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","A boa pessoa faz coisas boas, pois do tesouro do seu coração tira o bem. A má pessoa faz coisas más, pois do tesouro do seu coração tira o mal. Porque a boca fala do que está cheio o coração. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Por que vocês me chamam: “Senhor, Senhor” e não fazem o que eu digo? ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Eu vou lhes dizer como é o homem que vem a mim, que ouve as minhas palavras e as obedece. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ele é como um homem que construiu uma casa. Ele cavou bem fundo e pôs os alicerces sobre a rocha. Quando vieram as chuvas e as enchentes, a casa não se abalou, pois tinha sido bem construída. ");
INSERT INTO por_WBTC_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mas aquele que ouve as minhas palavras e não as obedece é como um homem que construiu sua casa sobre a terra, sem alicerces. Quando a água bateu sobre aquela casa, ela desabou e ficou completamente destruída. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Assim que Jesus acabou de dizer tudo o que ele queria que as pessoas ouvissem, foi para Cafarnaum. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lá vivia um oficial romano que tinha um escravo que estava morrendo e de quem ele gostava muito. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Quando ouviu falar a respeito de Jesus, enviou alguns anciãos dos judeus até ele para pedir que salvasse a vida do seu escravo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Os anciãos chegaram até Jesus e insistiram em que ele fosse até lá, dizendo: —Esse homem merece a sua ajuda. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ele ama muito o nosso povo e construiu a nossa sinagoga. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesus, então, foi com eles. Eles não estavam muito longe da casa quando o oficial enviou alguns amigos com este recado para Jesus: —Senhor, não se incomode, pois eu não sou digno de que entre em minha casa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Não sou digno nem de ir falar com o senhor pessoalmente. Porém, dê somente uma ordem e o meu servo será curado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Pois eu também tenho superiores que me dão ordens e soldados a quem eu dou ordens. Eu digo a um: “Vá!” e ele vai; e digo a outro: “Venha!” e ele vem. Da mesma forma, digo ao meu servo: “Faça isto!” e ele faz. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Quando Jesus ouviu isto, ficou admirado e, virando-se para a multidão que o seguia, disse: —Digo a vocês que nem mesmo entre o povo de Israel achei tanta fé! ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Quando aqueles que tinham sido enviados voltaram para casa, encontraram o escravo curado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Depois Jesus seguiu para uma cidade chamada Naim. Os seus discípulos e uma grande multidão o acompanhavam. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Quando ele estava perto do portão da cidade, viu um enterro. O morto era o único filho de uma viúva. Havia muitas pessoas da cidade no enterro. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Quando o Senhor a viu, ficou com muita pena dela e disse: —Não chore! ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesus chegou perto do caixão, tocou nele e os homens que o levavam pararam. Jesus disse: —Levante-se, jovem! ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","O morto se sentou e começou a falar. Então Jesus o entregou à sua mãe. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Todos ficaram muito impressionados e deram glórias a Deus, dizendo: —Um grande profeta está entre nós! E diziam também: —Deus veio para ajudar o seu povo! ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","A fama de Jesus se espalhou por toda a Judéia e por todos os arredores. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Os discípulos de João lhe contaram todas estas coisas. Ele então chamou dois de seus discípulos, ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","e mandou que eles fossem perguntar ao Senhor: “O senhor é aquele que ia chegar, ou ainda devemos esperar outro?” ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Quando os homens chegaram a Jesus, disseram: —João Batista mandou que viéssemos e perguntássemos se o senhor é aquele que ia chegar, ou se devemos esperar por outro. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Naquele momento, Jesus curou muitas pessoas que tinham doenças, enfermidades e demônios. Ele curou também muitos cegos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","E depois respondeu a eles: —Voltem a João e digam a ele tudo o que vocês viram e ouviram; os cegos vêem, os coxos andam normalmente, os leprosos são curados, os surdos ouvem, os mortos são ressuscitados e os pobres ouvem as Boas Novas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Feliz é aquele que não vê dificuldade em me aceitar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Depois de os mensageiros de João terem ido embora, Jesus começou a falar à multidão a respeito de João: —O que vocês esperavam ver quando foram ao deserto? Uma cana sacudida pelo vento? ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O que vocês foram ver? Um homem vestido com roupas finas? Ora, os homens que se vestem com roupas finas e vivem com luxo estão nos palácios dos reis. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mas então, o que vocês foram ver? Um profeta? Sim, e eu lhes digo que o homem que vocês viram é muito mais do que um profeta. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","João é aquele a respeito de quem está escrito: “Aqui está o meu mensageiro que envio antes de você. Ele vai preparar o caminho para você”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","—Eu digo a vocês que, de todos os homens que nasceram, não há nenhum que seja mais importante do que João. Porém, aquele que é o menos importante no reino de Deus, é mais importante do que ele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Quando todas as pessoas, até mesmo os cobradores de impostos, ouviram isto, reconheceram que os ensinamentos de Deus eram bons, pois eles tinham sido batizados por João. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Os fariseus e os professores da lei, porém, não quiseram ser batizados por João e assim rejeitaram o plano que Deus tinha para eles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","—Com o que eu poderia comparar as pessoas desta geração? Como é que elas são? ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","São como crianças que sentam na praça e gritam umas às outras: “Nós tocamos músicas alegres e vocês não dançaram; cantamos músicas fúnebres e vocês não choraram”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Isto ocorreu também com João Batista. Ele jejuava e não bebia vinho e vocês dizem: “Ele tem demônio!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","O Filho do Homem veio e ele come e bebe e vocês dizem: “É um comilão e beberrão, amigo de cobradores de impostos e de pecadores!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Porém, quem aceita a sabedoria de Deus sabe que ela é justa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Um fariseu convidou Jesus para jantar em sua casa. Ele foi e tomou lugar à mesa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Naquela cidade vivia uma mulher de má fama. Quando ela soube que Jesus estava jantando na casa do fariseu, pegou um vaso de alabastro cheio de perfume ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","e se colocou atrás de Jesus, aos pés dele e começou a chorar. As lágrimas dela caíam sobre os pés dele, molhando-os. Ela então os enxugou com os seus cabelos e os beijava e derramava o perfume neles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Quando o fariseu que o tinha convidado viu aquilo, disse para si mesmo: “Se este homem fosse mesmo um profeta, saberia que tipo de mulher é aquela que o está tocando. Ele saberia que ela é uma mulher de má fama”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus se dirigiu ao fariseu e lhe disse: —Simão, quero falar com você. Respondeu ele: —Pois não, Mestre. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","E Jesus disse: —Um certo credor tinha dois devedores. Um deles lhe devia quinhentas moedas de prata e o outro, cinqüenta. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Como nenhum dos dois conseguia pagar, ele cancelou os empréstimos. Agora eu lhe pergunto: Qual dos dois devedores o amará mais? ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simão respondeu: —Eu acho que é aquele que lhe devia mais. Jesus então disse: —Você está certo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","E, virando-se para a mulher, disse a Simão: —Você está vendo esta mulher? Eu entrei na sua casa e você não me deu água para lavar os pés; ela, porém, os lavou com as suas lágrimas e os enxugou com os seus cabelos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Você não me cumprimentou com um beijo; ela, porém, não pára de beijar meus pés desde que entrei. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Você não derramou óleo sobre a minha cabeça. Ela, porém, derramou perfume nos meus pés. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Por isso eu digo a você: Os muitos pecados dela foram perdoados; e isto é evidente, pois ela mostrou um grande amor. Mas a pessoa a quem se perdoa pouco, mostra pouco amor. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Então Jesus disse à mulher: —Os seus pecados estão perdoados. ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","E aqueles que estavam comendo com ele começaram a comentar uns com os outros: —Quem é este que até perdoa pecados? ");
INSERT INTO por_WBTC_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Então Jesus disse à mulher: —A sua fé a curou. Vá em paz. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Depois disto Jesus iniciou uma viagem por todas as cidades e vilas, proclamando e anunciando as Boas Novas do reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Iam com ele os seus doze discípulos e algumas das mulheres que tinham sido curadas de demônios e doenças: Maria, chamada Madalena (de quem tinham saído sete demônios); ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, mulher de Cuza (que era administrador da casa do rei Herodes); Susana e muitas outras. Estas mulheres ajudavam a Jesus e seus discípulos com o que elas possuíam. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Uma grande multidão se ajuntava e pessoas de várias vilas tinham ido ouvir a Jesus. Ele então contou a todos esta parábola: ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Certo homem saiu para semear. Enquanto semeava, uma parte das sementes caiu pelo caminho e foi pisada pelas pessoas e comida pelas aves do céu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Outra parte caiu num terreno onde havia muitas pedras e, quando começou a brotar, secou por falta de umidade. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Outra parte das sementes caiu entre espinhos. Os espinhos cresceram junto com as plantas e as sufocaram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Uma outra parte ainda caiu em terra boa e, ao crescer, produziu cem vezes mais grãos do que foi semeado. E, depois de dizer estas coisas, exclamou: —Aquele que pode me ouvir, ouça! ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Os discípulos perguntaram-lhe o que ele queria dizer com aquela parábola. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesus então disse: —A vocês é dado o privilégio de conhecer os segredos do reino de Deus, mas a todas as outras pessoas tudo é dito por meio de parábolas, para que “olhem e não enxerguem, ouçam e não compreendam”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","—O que a parábola quer dizer é o seguinte: A semente é a mensagem de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","As sementes que caíram pelo caminho representam aqueles que ouvem a mensagem. Mas em seguida vem o Diabo e tira a mensagem de seus corações, para que não acreditem e nem sejam salvos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","As sementes que caíram sobre o terreno onde havia muitas pedras representam aqueles que recebem a mensagem com grande alegria, mas que não têm raiz. Eles acreditam por uns tempos mas, quando são postos à prova, abandonam a fé. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","As sementes que caíram entre os espinhos representam os que ouvem a mensagem mas, por causa das preocupações, das riquezas e dos prazeres da vida, são sufocados e o seu fruto nunca amadurece. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Aquelas sementes, porém, que caíram em terreno bom representam os que têm corações bons e honestos. Quando eles ouvem a mensagem, a retêm e, pela sua persistência, produzem frutos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Ninguém acende um lampião e o cobre com um vaso ou o põe debaixo da cama. Ele é colocado em cima da mesa, para que as pessoas que entram possam ver a luz. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Isto acontece porque não há nada escondido que não venha a ser revelado, nem nada que seja secreto e que não venha a ser conhecido. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Por isso, tenham cuidado em como vocês ouvem o que eu falo. Quem tem receberá ainda mais, mas aquele que não tem, até o que ele pensa que tem lhe será tirado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","A mãe e os irmãos de Jesus foram até onde ele estava, mas por causa da multidão não puderam se aproximar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Então disseram a Jesus: —Sua mãe e seus irmãos estão lá fora procurando por você. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ele respondeu: —Minha mãe e meus irmãos são aqueles que ouvem a mensagem de Deus e a praticam. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Certo dia Jesus entrou com os seus discípulos num barco e lhes disse: —Vamos atravessar para o outro lado do lago. E eles partiram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Enquanto navegavam, Jesus adormeceu. Veio uma tempestade de vento no lago e o barco começou a se encher de água, correndo eles o perigo de afundarem. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Então acordaram a Jesus e disseram: —Mestre, Mestre! Nós vamos morrer! Jesus se levantou e repreendeu o vento e as ondas. Tudo se acalmou e o lago ficou tranqüilo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Depois Jesus lhes disse: —Onde está a sua fé? Eles, porém, estavam com medo e assustados e diziam uns aos outros: —Quem é este homem que repreende o vento e as águas e eles obedecem? ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Depois eles navegaram para a região dos gerasenos, do outro lado do lago da Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Quando Jesus desceu do barco, um homem possuído por demônios foi ao seu encontro. Já fazia muito tempo que ele não se vestia com roupas nem vivia numa casa, porém morava em túmulos no cemitério. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Quando viu a Jesus, o homem deu um grito, ajoelhou-se diante dele e disse em voz alta: —O que o senhor quer de mim, Jesus, Filho do Altíssimo Deus? Eu lhe suplico que não me atormente. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Ele disse isso porque Jesus já tinha mandado o demônio sair do homem, pois por muitas vezes tinha se apoderado dele. Embora prendessem as mãos e os pés do homem com correntes de ferro, ele as arrebentava e era levado para o deserto pelo demônio.) ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus perguntou a ele: —Qual é o seu nome? Ele disse: —Multidão. (Ele disse isso porque muitos demônios se encontravam nele.) ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","E os demônios imploravam a Jesus que não os mandasse para o abismo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Havia um grande número de porcos comendo num monte ali perto. Os demônios então imploraram a Jesus que os deixasse entrar nos porcos, e Jesus permitiu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Os demônios saíram do homem e entraram nos porcos, que se atiraram morro abaixo, para dentro do lago, onde se afogaram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Quando os homens que tomavam conta dos porcos viram o que tinha acontecido, fugiram e contaram tudo isso tanto para aqueles que estavam na cidade como para os que estavam nos campos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","E, quando as pessoas foram ver o que tinha acontecido, encontraram a Jesus e o homem de quem os demônios tinham saído. Eles encontraram o homem sentado aos pés de Jesus, vestido, no seu perfeito juízo; e ficaram com muito medo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aqueles que tinham visto como o endemoninhado tinha sido curado, contaram tudo ao povo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","E toda a população da região dos gerasenos pediu a Jesus que ele fosse embora, pois todos estavam apavorados. Então ele entrou no barco e voltou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","O homem de quem os demônios tinham saído insistia em acompanhar a Jesus. Jesus, porém, o mandou embora, dizendo: ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Volte para sua casa e diga a todos o que Deus fez por você. Então ele foi embora e anunciava por toda a vila todas as coisas que Jesus tinha feito por ele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ao retornar Jesus para a Galiléia, a multidão o recebeu com alegria, pois todos estavam esperando por ele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Então, um homem chamado Jairo, chefe da sinagoga, se ajoelhou aos pés de Jesus e lhe implorou que fosse com ele até sua casa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Pois ele tinha uma filha única de doze anos, que estava morrendo. E enquanto Jesus ia, a multidão que o seguia era tanta que ele era apertado de todos os lados. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Havia na multidão uma mulher que, há doze anos, sofria de hemorragia e que já tinha gastado tudo o que possuía com médicos, mas ninguém tinha conseguido curá-la. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ela se aproximou de Jesus por trás e tocou na barra da sua roupa. Naquele mesmo momento a hemorragia passou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesus disse: —Quem tocou em mim? Como ninguém se acusava, Pedro disse: —Mestre, as multidões estão à sua volta e o apertam! ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mas Jesus disse: —Alguém tocou em mim, pois eu senti que de mim saiu poder. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Quando a mulher viu que não podia mais ficar escondida, veio tremendo e se ajoelhou aos pés de Jesus. Então, na frente de todos, disse porque tinha tocado na barra da sua roupa e como tinha sido curada imediatamente. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesus lhe disse: —Filha, a sua fé a curou. Vá em paz! ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus ainda estava falando quando chegou uma pessoa da casa de Jairo, o chefe da sinagoga, e disse: —Sua filha já morreu. Não incomode mais o Mestre. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mas Jesus, tendo ouvido isso, respondeu: —Não tenha medo. Simplesmente tenha fé e ela ficará boa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Quando chegaram à casa de Jairo, Jesus não permitiu que ninguém entrasse com ele, a não ser Pedro, João, Tiago e os pais da menina. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Todas as pessoas estavam chorando e se lamentando por causa da menina. Jesus então disse: —Não chorem mais, pois a menina não está morta; ela apenas dorme. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Todos caçoaram dele porque sabiam que a menina estava morta. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Depois, Jesus pegou na mão dela e disse em voz alta: —Menina, levante-se! ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","O espírito voltou para ela e a menina imediatamente se levantou. Jesus então disse que lhe dessem de comer. ");
INSERT INTO por_WBTC_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Os pais dela ficaram admirados, mas Jesus mandou que não contassem a ninguém o que tinha acontecido. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Depois disto, Jesus chamou seus doze discípulos e lhes deu poder e autoridade sobre todos os demônios e também poder para curar doenças. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Então os enviou para anunciar a mensagem sobre o reino de Deus e para curar os doentes. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ele lhes disse: —Não levem nada para a viagem; nem cajado para se apoiarem, nem sacola, nem comida, nem dinheiro, nem mesmo roupas extras. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Fiquem na casa onde vocês forem recebidos, até saírem daquela cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Se não forem bem recebidos quando chegarem a uma cidade, sacudam o pó de seus pés ao saírem de lá, como uma advertência para aquela gente. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Assim, os discípulos partiram e passaram por todas as vilas, proclamando as Boas Novas e curando pessoas por toda parte. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Quando o governador Herodes ouviu a respeito destas coisas, ficou sem saber o que fazer. Alguns diziam que João tinha ressuscitado dos mortos, ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","outros diziam que Elias tinha aparecido e outros ainda diziam que um dos antigos profetas tinha ressuscitado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes, porém, disse: —Eu mandei cortar a cabeça de João! Quem será então este homem de quem eu ouço falar estas coisas? Daí em diante Herodes procurou ver a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Quando os apóstolos retornaram, contaram a Jesus tudo o que tinham feito. Ele então os levou para uma cidade chamada Betsaida, para ficar sozinho com eles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Quando a multidão ficou sabendo disso, seguiu-o até lá. Ele os recebeu bem, falou-lhes a respeito do reino de Deus e curou os que precisavam de cura. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Quando começou a anoitecer, os doze se aproximaram de Jesus e lhe disseram: —Mande essa gente embora para que possam ir para as vilas e campos aqui por perto e achar lugar onde comer e passar a noite, pois estamos num lugar deserto. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mas Jesus lhes disse: —Por que vocês mesmos não lhes dão alguma coisa de comer? Eles responderam: —Mas como, se tudo o que temos são cinco pães e dois peixes? A não ser que nós mesmos vamos comprar comida para toda essa gente! ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Estavam ali mais ou menos cinco mil homens). Ele disse aos discípulos: —Digam a todos que se sentem em grupos de mais ou menos cinqüenta pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Eles obedeceram e mandaram que todos se sentassem. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesus pegou os cinco pães e os dois peixes, olhou para o céu e agradeceu a Deus o alimento. Depois os repartiu em pedaços e deu a seus discípulos para que distribuíssem entre a multidão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Todos comeram e ficaram satisfeitos, e os discípulos encheram doze cestos com os pedaços que sobraram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Certa vez em que Jesus orava sozinho, os discípulos se aproximaram. Jesus perguntou-lhes: —Quem a multidão diz que eu sou? ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Eles responderam: —Alguns dizem que é João Batista, outros dizem que é Elias e outros ainda dizem que é um dos antigos profetas que ressuscitou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Então Jesus lhes perguntou: —E vocês? Quem vocês dizem que eu sou? Pedro respondeu: —O Cristo enviado por Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesus, então, lhes deu ordem para que não contassem isso a ninguém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","E continuou, dizendo: —Pois é necessário que o Filho do Homem sofra muitas coisas e que seja rejeitado pelos anciãos, pelos líderes dos sacerdotes e pelos professores da lei, que seja morto e que ressuscite no terceiro dia. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","E depois disse a todos: —Se alguém quiser vir comigo, tem que negar a si mesmo, carregar a sua cruz todos os dias e me seguir. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pois todo aquele que quiser salvar a sua vida, perdê-la-á; mas aquele que perder a sua vida por minha causa, salvá-la-á. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Que vantagem terá alguém em ganhar o mundo inteiro se ele mesmo for destruído ou se perder? ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Se alguém tiver vergonha de mim e das minhas palavras, o Filho do Homem também terá vergonha dele quando vier na sua glória e na glória do Pai e dos santos anjos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Digo a verdade a vocês: Alguns dos que estão aqui presentes não morrerão sem antes ver o reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mais ou menos oito dias depois de ter dito essas coisas, Jesus subiu a um monte para orar e levou consigo a Pedro, João e Tiago. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Enquanto orava, a aparência de seu rosto se modificou e as suas roupas ficaram brilhantes de tão brancas que estavam. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Então, dois homens apareceram e começaram a falar com ele; eram Moisés e Elias. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Eles apareceram rodeados por um brilho e falavam com Jesus a respeito de sua morte, que iria acontecer em Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro e aqueles que estavam com ele adormeceram, mas quando acordaram viram a glória de Jesus e os dois homens que estavam com ele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Quando os homens se despediram de Jesus, Pedro lhe disse: —Mestre, é bom que nós estejamos aqui. Vamos fazer três tendas: uma para o senhor, uma para Moisés e outra para Elias. (Ele não sabia o que estava dizendo). ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Enquanto dizia estas coisas, uma nuvem apareceu e os envolveu e eles ficaram com muito medo quando a nuvem os cobriu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","E da nuvem vinha uma voz que dizia: —Este é o meu Filho, o meu Escolhido! Ouçam-no! ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Quando a voz acabou de falar, Jesus estava sozinho. Então eles se mantiveram calados e, naqueles dias, não disseram nada a ninguém a respeito das coisas que tinham visto. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","No dia seguinte, ao descerem do monte, uma grande multidão foi ao encontro de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","E do meio da multidão um homem gritou: —Mestre, imploro que o senhor veja o meu filho, o meu único filho! ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Um espírito se apodera dele e, de repente, o obriga a gritar e faz com que ele tenha convulsões e espume pela boca. O espírito o maltrata e dificilmente o deixa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Eu pedi aos seus discípulos que o expulsassem, mas eles não conseguiram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus, então, disse: —Gente sem fé e desviada! Até quando tenho que estar entre vocês? Até quando terei que tolerar a vocês? Traga o seu filho aqui. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Quando o menino estava chegando, o demônio o derrubou, fazendo com que entrasse em convulsões. Jesus, então, repreendeu o demônio, curou o menino e o entregou de volta ao pai. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Enquanto todos estavam maravilhados com todas as coisas que Jesus tinha feito, ele disse aos discípulos: ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Prestem muita atenção nisto que vou lhes dizer agora: O Filho do Homem vai ser entregue nas mãos dos homens. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mas eles não entenderam o que ele estava dizendo. O significado daquelas palavras estava oculto deles e por isso não podiam compreender. Além disso, tinham medo de lhe perguntar o significado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Os discípulos começaram a discutir entre eles a respeito de qual deles seria o mais importante. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mas Jesus, conhecendo os pensamentos deles, pegou uma criança, colocou-a de pé a seu lado, ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","e lhes disse: —Quem receber esta criança em meu nome, recebe a mim; e quem me recebe, recebe Aquele que me enviou. Porque o mais humilde entre vocês é que é o mais importante. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","João disse: —Mestre, vimos um homem expulsando demônios em seu nome, mas nós o proibimos, pois ele não é do nosso grupo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mas Jesus lhe disse: —Não o proíbam, pois quem não é contra vocês é a favor de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Quando estava chegando o tempo de Jesus ir para o céu, ele resolveu ir para Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ele enviou mensageiros à sua frente, que partiram para uma vila samaritana a fim de prepararem acomodações. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Os samaritanos, porém, não queriam recebê-lo porque ele ia para Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Quando viram isto, os discípulos Tiago e João disseram: —Você quer que mandemos vir fogo do céu para consumir essa gente? ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Porém Jesus virou-se e os repreendeu ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Depois seguiram para outra vila. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Enquanto eles andavam pelo caminho, um homem lhe disse: —Eu o seguirei aonde quer que o senhor vá. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus lhe disse: —As raposas têm tocas e as aves do céu têm ninhos, mas o Filho do Homem não tem onde descansar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aí ele disse a outro homem: —Siga-me. Mas ele respondeu: —Senhor, deixe-me ir primeiro enterrar meu pai. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","E Jesus lhe disse: —Deixe que os mortos enterrem os seus próprios mortos! Vá e anuncie o reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Outro lhe disse: —Eu o seguirei, Senhor, mas deixe-me primeiro ir me despedir da minha família. ");
INSERT INTO por_WBTC_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus então disse: —Ninguém que ponha a mão no arado e olhe para trás serve para o reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Depois disto, o Senhor escolheu outros setenta e dois homens e os mandou ir, dois em dois a sua frente, para todas as cidades e lugares aonde ele mesmo pretendia ir. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","E disse a eles: —A colheita é grande, mas os trabalhadores são poucos. Portanto, orem ao Senhor da colheita para que ele mande trabalhadores para a sua colheita. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Vão e lembrem-se: Eu estou mandando vocês como cordeiros para o meio de lobos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Não levem nem bolsa, nem sacola, nem sandálias e nem parem no caminho para cumprimentar ninguém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Em qualquer casa que vocês entrarem, a primeira coisa que devem dizer é: “Que a paz esteja nesta casa!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Se ali morar um homem de paz, a paz de vocês ficará com ele. Mas se aquele que morar ali não for um homem de paz, ela voltará para vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Permaneçam naquela casa e comam e bebam o que derem a vocês, pois todo trabalhador merece o seu salário. Não fiquem andando de casa em casa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","E em qualquer cidade a que vocês chegarem e forem bem recebidos, comam o que as pessoas derem a vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Curem os doentes daquela cidade e digam-lhes: “O reino de Deus está próximo de vocês”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mas, em qualquer cidade a que vocês chegarem e não forem bem recebidos, vão para as ruas e digam: ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Até o pó desta cidade que grudou em nossos pés, nós sacudimos contra vocês! Mas saibam disto: O reino de Deus está próximo”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","—E eu lhes digo uma coisa: Naquele dia haverá mais tolerância para com as pessoas de Sodoma do que para com as daquela cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","—Ai de você, cidade de Corazim! Ai de você, cidade de Betsaida! Porque se os milagres que foram feitos aí tivessem sido feitos em Tiro e Sidom, há muito tempo que esses povos já se teriam arrependido. E para mostrar que estavam arrependidos, ter-se-iam sentado, vestidos com roupa de luto e cobertos com cinzas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Por isso, no julgamento, haverá mais tolerância para com as cidades de Tiro e Sidom do que para com vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","E você, cidade de Cafarnaum? Pensa que será elevada até o céu? Você será jogada no lugar dos mortos! ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Quem ouve a vocês, ouve a mim. Quem rejeita a vocês, rejeita a mim. E quem me rejeita, rejeita Aquele que me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Os setenta e dois voltaram alegres e disseram: —Senhor, até mesmo os demônios estavam sujeitos a nós em seu nome! ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ele lhes disse: —Vi Satanás cair do céu como um raio! ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Escutem: Eu dei a vocês autoridade para pisarem cobras e escorpiões. Dei também autoridade a vocês sobre todo o poder do inimigo. Nada lhes fará mal. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mas não se alegrem com o fato de que os espíritos estão sujeitos a vocês. Alegrem-se com o fato de que os nomes de vocês estão escritos no céu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Naquele momento, pelo poder do Espírito Santo, Jesus ficou muito alegre e disse: —Pai! Senhor do céu e da terra! Eu lhe agradeço por ter escondido estas coisas dos sábios e dos entendidos e por tê-las mostrado aos que são simples. Sim, Pai, pois esta era a sua vontade. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Todas as coisas foram dadas a mim pelo meu Pai. Ninguém conhece o Filho a não ser o Pai e ninguém conhece o Pai a não ser o Filho e aqueles a quem o Filho o quiser revelar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Então Jesus virou-se para os discípulos e lhes disse em particular: —Felizes são os olhos que vêem aquilo que vocês vêem! ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Eu digo que muitos profetas e reis desejaram ver as coisas que vocês vêem, mas não viram. Eles desejaram ouvir as coisas que vocês ouvem, mas não ouviram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Numa ocasião, um professor da lei se levantou e tentou colocar Jesus à prova, dizendo: —Mestre, o que devo fazer para conseguir a vida eterna? ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus lhe disse: —O que está escrito na lei? Como você interpreta o que está escrito nela? ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ele respondeu: —“Ame ao Senhor seu Deus de todo o seu coração, de toda a sua alma, de toda a sua força e de todo o seu entendimento”. E também: “Ame ao seu próximo assim como você ama a si mesmo”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus então lhe disse: —Você respondeu corretamente. Faça isso e viverá. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mas, querendo se justificar, ele disse a Jesus: —E quem é o meu próximo? ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus respondeu: —Certo homem ia de Jerusalém para Jericó quando foi assaltado por ladrões. Eles lhe tiraram a roupa, bateram nele e depois foram embora deixando o homem quase morto. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Por acaso um sacerdote estava passando por aquele caminho e, quando viu o homem, atravessou para o outro lado da estrada. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Da mesma forma, um levita também passou por ali e, quando o viu, também atravessou para o outro lado da estrada. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Um samaritano, porém, que também estava viajando por aquele mesmo caminho, teve pena do homem quando o viu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Chegou perto dele e fez curativos em suas feridas, colocando azeite e vinho nelas. Depois disso, colocou o homem em seu jumento e o levou a uma hospedaria e cuidou dele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","No dia seguinte, o samaritano deu duas moedas de prata ao dono da hospedaria e lhe disse: “Tome conta dele. Se por acaso gastar mais do que isto, pagarei o restante quando voltar”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","—Quem destes três você acha que foi o próximo do homem assaltado pelos ladrões? ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","O professor da lei então respondeu: —Aquele que socorreu o homem. Jesus lhe disse: —Vá e faça a mesma coisa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus e os seus discípulos continuaram seu caminho até chegarem a certa vila, onde foram recebidos por uma mulher chamada Marta. ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta tinha uma irmã chamada Maria. Maria sentou aos pés de Jesus para ouvir o que ele dizia, ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","enquanto Marta estava ocupada com o serviço da casa. Marta, então, chegou perto de Jesus e disse: —O senhor não se importa que a minha irmã me deixe trabalhando sozinha? Diga-lhe para vir me ajudar! ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","O Senhor lhe respondeu: —Marta, Marta! Você se preocupa e se incomoda com muitas coisas! ");
INSERT INTO por_WBTC_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Somente uma coisa é necessária! Eu digo isto porque Maria escolheu a melhor parte por si mesma e isso não lhe será tirado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Numa ocasião, Jesus estava orando em certo lugar. Quando terminou, um de seus discípulos lhe disse: —Senhor, ensine-nos a orar, assim como João ensinou aos seus discípulos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Então Jesus lhes disse: —Quando vocês orarem, digam: “Pai: Que todos reconheçam que o seu nome é santo. Que venha o seu reino. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dê-nos todos os dias o alimento de que precisamos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Perdoe-nos os nossos pecados, assim como nós também perdoamos aos que nos fazem o mal. Não nos deixe cair em tentação”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Depois Jesus lhes disse: —Suponha que você tivesse um amigo e que, numa ocasião, à meia-noite, você fosse até a casa dele e dissesse: “Amigo! Eu preciso que me empreste três pães, ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","pois um amigo meu acabou de chegar de viagem e não tenho nada para lhe oferecer”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","—E suponham que ele responda lá de dentro desta maneira: “Não me aborreça! A porta está trancada e tanto eu como meus filhos já estamos deitados. Não vou levantar agora para lhe dar nada!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","—Eu lhes digo que, mesmo que ele não se levante para lhe dar alguma coisa por ser seu amigo, ele se levantará e lhe dará tudo de que você precisa, por causa da sua insistência. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Por isso eu lhes digo: Peçam e lhes será dado; procurem e vocês acharão; batam e a porta lhes será aberta. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pois todo aquele que pede, recebe; todo aquele que procura, acha; e a porta se abre a todo aquele que bate. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Qual de vocês, que é pai, dará uma cobra a seu filho quando este lhe pedir um peixe? ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ou dará um escorpião a seu filho quando este lhe pedir um ovo? ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Se até mesmo vocês, que são maus, sabem dar coisas boas a seus filhos, quanto mais o Pai que está no céu! Ele dará o Espírito Santo para aqueles que lhe pedirem! ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus estava expulsando de um homem um demônio que o tinha deixado mudo. Assim que o demônio foi expulso, o homem começou a falar e a multidão ficou muito admirada. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mas alguns diziam: —Ele expulsa os demônios pelo poder de Belzebu, o chefe dos demônios! ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Outros, porém, para o colocarem à prova, lhe pediam um sinal do céu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mas Jesus conhecia os pensamentos deles e disse: —Se um reino está dividido e suas partes lutam entre si, esse reino está condenado à destruição. E se uma família está dividida em grupos que lutam entre si, também será destruída. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Se Satanás está dividido contra si mesmo, como vocês disseram, como pode o seu reino continuar a existir? Eu faço esta pergunta porque vocês disseram que eu expulso demônios pelo poder de Belzebu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","E se é verdade que eu expulso demônios pelo poder de Belzebu, então pelo poder de quem é que os expulsam aqueles que seguem a vocês? Assim, os seus próprios seguidores provam que vocês estão completamente errados. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mas, se eu expulso os demônios pelo poder de Deus, isso prova que o reino de Deus chegou até vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","—Quando um homem forte e bem armado guarda a sua própria casa, todos os seus bens estão seguros. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mas quando alguém mais forte do que ele o ataca e vence, leva todas as armas em que ele confiava, e reparte todos os bens que tomou dele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Aquele que não está a meu favor, está contra mim; e aquele que não me ajuda a ajuntar, espalha. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Quando um demônio sai de uma pessoa, ele atravessa lugares desertos à procura de descanso e, quando não o encontra, diz: “Voltarei para a casa de onde vim”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Quando ele volta, encontra a casa varrida e bem arrumada. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Então, sai e vai buscar mais sete demônios piores do que ele e ali vão viver. Assim, o último estado daquela pessoa se torna ainda pior do que o primeiro. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Enquanto dizia estas coisas, uma mulher que estava no meio da multidão falou bem alto: —Feliz é a mulher que o deu à luz e que o amamentou! ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mas ele lhe disse: —Muito mais felizes são aqueles que ouvem a mensagem de Deus e a obedecem! ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Uma grande multidão se juntava e ele disse: —Esta geração é má! Ela anda à procura de sinais, mas nenhum sinal lhe será dado, a não ser o sinal dado a Jonas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Assim como Jonas foi um sinal para os habitantes de Nínive, também o Filho do Homem será um sinal para esta geração. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","No dia do julgamento, a Rainha do Sul vai se levantar com as pessoas desta geração e vai condená-las, pois ela veio de muito longe para ouvir a sabedoria de Salomão. E eu afirmo que quem está aqui agora é superior a Salomão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","No dia do julgamento, o povo da cidade de Nínive vai se levantar com as pessoas desta geração e vai condená-las, pois o povo se arrependeu dos seus pecados quando ouviu a mensagem de Jonas. E eu afirmo que quem está aqui agora é superior a Jonas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ninguém acende um lampião e o coloca onde ninguém o possa ver, ou debaixo de um vaso. Ao contrário, colocam-no em cima de uma mesa, para que todos que entrem enxerguem bem. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Os seus olhos são a fonte de luz para o corpo. Se os seus olhos forem bons, todo o seu corpo ficará cheio de luz. Mas se os seus olhos forem maus, todo o seu corpo estará na escuridão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Portanto, tome cuidado para que a luz que há em você não vire escuridão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pois se todo o seu corpo estiver cheio de luz e sem nenhuma escuridão, você poderá ver tudo claramente, como se um lampião iluminasse a você com sua luz. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Quando Jesus acabou de falar, um fariseu o convidou para comer com ele. Jesus entrou e se sentou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","O fariseu o estava observando e ficou admirado por Jesus não ter lavado as mãos antes da refeição. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Então, o Senhor lhe disse: —Vocês, fariseus, limpam o copo e o prato por fora, mas por dentro vocês estão cheios de violência e maldade. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tolos! Quem fez o lado de fora não foi o mesmo que fez o lado de dentro? ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dêem o que está do lado de dentro aos pobres e então tudo ficará limpo para vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ai de vocês, fariseus, porque dão um décimo da hortelã, da arruda e de todas as outras hortaliças, mas se descuidam da justiça e do amor a Deus. Vocês devem fazer aquelas primeiras coisas sem se descuidarem destas últimas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ai de vocês, fariseus, porque gostam dos lugares de maior importância nas sinagogas e de serem saudados em lugares públicos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ai de vocês, porque são como túmulos que ninguém vê e, sobre os quais, as pessoas passam por cima sem saber. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Então, um dos professores da lei lhe disse: —Mestre, falando assim o senhor nos ofende também. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","E ele então respondeu: —Ai de vocês também, professores da lei, porque põem cargas tão pesadas sobre as costas das pessoas que elas mal podem carregar, mas vocês mesmos nem com um dedo querem tocar nestas cargas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ai de vocês, porque fazem túmulos para os profetas que os pais de vocês mataram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Dessa forma vocês testemunham e até mesmo aprovam os atos dos pais de vocês, pois eles os mataram, mas vocês lhes fizeram os túmulos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Foi também por esse motivo que Deus disse na sua sabedoria: “Eu lhes enviarei profetas e apóstolos. Eles matarão alguns e perseguirão outros”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Assim, esta geração pagará pela morte de todos os profetas que foram assassinados desde o princípio do mundo, ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","desde a morte de Abel até à morte de Zacarias, que foi morto entre o altar e a casa de Deus. Assim, eu afirmo a vocês que esta geração terá que pagar por estas mortes. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—Ai de vocês, professores da lei, porque esconderam as chaves que abrem as portas para o conhecimento da lei de Deus. Vocês mesmos não entram por elas e até mesmo impedem aqueles que tentam entrar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Quando ele foi embora, os professores da lei e os fariseus começaram a atacá-lo e a exigir respostas sobre vários assuntos, ");
INSERT INTO por_WBTC_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","sempre à procura de uma maneira para pegá-lo em alguma coisa errada que ele dissesse. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Milhares de pessoas se juntaram; e eram tantas que pisavam umas nas outras. Jesus, então, começou a falar, dirigindo-se primeiro aos seus discípulos: —Previnam-se contra o fermento dos fariseus, isto é, contra a falsidade deles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Não há nada que esteja oculto e que não venha a ser revelado; nem nada que esteja escondido e que não venha a ser descoberto. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Portanto, tudo o que vocês disseram às escuras será falado em plena luz; e tudo o que, num quarto fechado, vocês sussurraram aos ouvidos de alguém, será anunciado de cima das casas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mas eu digo a vocês, meus amigos: Não tenham medo daqueles que matam o corpo mas que não podem fazer mais nada depois disso. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Eu direi a vocês de quem é que vocês devem ter medo: Tenham medo daquele que, depois de matar, tem o poder de lançar vocês no inferno. Deste sim, eu lhes digo que vocês devem ter medo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","—Não se vendem cinco pardais por dois centavos? Deus, porém, não se esquece de nenhum deles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Até mesmo os fios de cabelo da cabeça de vocês estão contados. Não tenham medo de nada; vocês valem mais do que muitos pardais! ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Eu digo a vocês: Se alguém afirmar publicamente ser meu seguidor, então o Filho do Homem também afirmará, diante dos anjos de Deus, que essa pessoa lhe pertence. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Porém, aquele que publicamente me negar, também será negado diante dos anjos de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Todo aquele que falar contra o Filho do Homem será perdoado. Mas aquele que insultar o Espírito Santo não será perdoado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","—Quando levarem vocês para as sinagogas, diante das autoridades e governadores, não fiquem preocupados pensando em como vão se defender ou o que vão dizer. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pois, naquele instante, o Espírito Santo falará a vocês o que devem dizer. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Então, do meio da multidão alguém lhe disse: —Mestre, diga para o meu irmão dividir a herança comigo! ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mas Jesus respondeu: —Homem, quem me nomeou juiz ou árbitro sobre vocês? ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","E disse a todos: —Tenham cuidado! Evitem todo tipo de avareza, pois a vida de um homem não depende das coisas que ele tem, mesmo que seja muito rico. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","E então lhes contou esta parábola: —As terras de certo homem rico tinham produzido uma colheita muito boa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Então ele pensou: “Eu não tenho lugar para guardar a minha colheita. O que vou fazer?” ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Então disse: “Já sei o que vou fazer! Vou demolir os meus celeiros e construir outros maiores. Assim poderei guardar toda a minha colheita e todos os meus bens! ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Daí poderei dizer a mim mesmo: ‘Homem, você já tem muitas coisas boas guardadas para muitos anos. Portanto descanse, coma, beba e se divirta!’” ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Deus, porém, lhe disse: “Tolo! Esta noite a sua alma lhe será tirada. Com quem ficarão todas as coisas que você guardou?” ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","—A mesma coisa acontecerá para aqueles que acumulam tesouros para si mesmos, mas que não são ricos para com Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Depois disso Jesus disse aos seus discípulos: —Por isso eu lhes digo: Não se preocupem com a vida de vocês e com o que vão comer; nem com o corpo de vocês e com o que vão vestir. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pois a vida é mais importante do que comida e o corpo é mais importante do que roupas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Olhem para os corvos: Eles não plantam nem colhem, nem têm celeiros nem armazéns; e Deus lhes dá o que comer. Será que vocês não valem muito mais do que os pássaros? ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Qual de vocês, por mais que se preocupe, pode adicionar uma hora à sua vida? ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Portanto, se não podem conseguir uma coisa assim tão pequena, por que se preocupam com o resto? ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Olhem para os lírios e vejam como eles crescem! Eles não trabalham nem fazem roupas. Contudo eu lhes digo que nem mesmo o rei Salomão, com toda a sua riqueza, se vestiu como um deles! ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Se Deus veste dessa maneira as plantas do campo, que hoje estão aqui e amanhã são jogadas no fogo, quanto mais ele vestirá a vocês, gente de pouca fé! ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Portanto, não se preocupem com o que vão comer ou beber, nem se aflijam por causa disso. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","As pessoas do mundo é que estão sempre procurando essas coisas. Mas o Pai de vocês sabe que precisam delas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mas, antes de tudo, ponham em primeiro lugar em suas vidas o reino de Deus e ele lhes dará aquelas outras coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Não tenha medo, meu pequeno rebanho, pois o seu Pai tem prazer em lhe dar o reino. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Vendam os seus bens e dêem o dinheiro aos pobres. Façam para vocês mesmos bolsas que não se estraguem; acumulem um tesouro inesgotável no céu, onde nenhum ladrão o toca e nenhuma traça o destrói. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Lembrem-se disto: Onde estiver o seu tesouro, lá também estará o seu coração. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","—Estejam preparados e com os seus lampiões acesos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Sejam como as pessoas que esperam seu senhor voltar da festa de casamento, para que, quando ele chegar e bater à porta, elas possam abrir imediatamente. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Felizes são aqueles servos cujo senhor os encontrar acordados e prontos quando ele chegar! Digo a verdade a vocês: Ele mesmo se preparará e os servirá, enquanto eles estarão à mesa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","E mesmo que ele chegue à meia-noite ou até mais tarde, felizes serão eles se os encontrar preparados. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Porém, tenham certeza disto: Se o dono da casa soubesse a que horas viria o ladrão, certamente não permitiria que roubasse a sua casa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Portanto, estejam vocês também preparados, pois o Filho do Homem virá quando não estiverem esperando. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","E Pedro disse: —Senhor, está contando esta parábola para nós, ou para todos? ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Então o Senhor disse: —Quem será, então, o mordomo leal e prudente que o Senhor nomeará sobre os seus servos para lhes dar de comer na ocasião certa? ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Feliz é o servo que estiver fazendo isso quando o seu senhor chegar! ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Digo a verdade a vocês: Ele o colocará para tomar conta de todos os seus bens. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mas se aquele servo diz consigo mesmo: “O meu senhor está demorando muito” e começar a bater nos outros servos e servas, e a comer e beber e a ficar bêbado, o que vai lhe acontecer? ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","O senhor daquele servo chegará num dia em que ele não espera e numa hora que ele nem imagina, e o castigará severamente e o condenará para sofrer o mesmo destino dos infiéis. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","O servo que conhece a vontade de seu senhor e não se prepara, ou não faz aquilo que ele quer, será punido com muitas chicotadas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mas o servo que não conhece a vontade de seu senhor e que faz alguma coisa que merece castigo, será punido com poucas chicotadas. Sendo assim, para todo aquele a quem se dá muito, muito será pedido; e daquelas pessoas nas quais foi depositada maior confiança, muito mais será exigido. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Eu vim para pôr fogo na terra; e como eu gostaria que já estivesse queimando! ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tenho que receber um batismo, e como estou angustiado até que ele seja realizado! ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Vocês pensam que eu vim para trazer paz ao mundo? Não! Afirmo a vocês que eu vim para trazer divisões! ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Pois, de agora em diante, uma família de cinco pessoas estará dividida: três contra duas e duas contra três. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","O pai estará contra o filho e o filho contra o pai; a mãe estará contra a filha e a filha contra a mãe; a sogra estará contra a nora e a nora contra a sogra. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","E Jesus também disse ao povo: —Quando vocês vêem uma nuvem subindo no ocidente, logo dizem: “Vai chover!” E assim acontece. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","E quando sentem o vento soprando do sul, vocês dizem: “Vai fazer calor!” E assim acontece. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hipócritas! Se vocês sabem interpretar os sinais do céu e da terra, como é que não sabem interpretar esta época em que vivemos? ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","E Jesus terminou, dizendo: —Por que vocês não julgam por si mesmos o que é justo? ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Se alguém, por algum motivo, quiser levá-lo a um tribunal, faça o possível para chegar a um acordo com ele durante o caminho. Faça isso para que ele não o leve ao juiz, o juiz o entregue à polícia e a polícia o ponha na cadeia. ");
INSERT INTO por_WBTC_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Pois eu lhe digo que você não sairá de lá enquanto não pagar até o último centavo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nessa ocasião, uns homens que ali se achavam contaram a Jesus como Pilatos tinha assassinado alguns galileus e misturado o sangue deles com o sangue dos sacrifícios que estavam oferecendo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus lhes disse: —Vocês pensam que esses galileus pecaram mais do que todos os outros por terem sofrido dessa maneira? ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Eu lhes digo que não! E se não se arrependerem, vocês todos também morrerão, como eles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","E o que me dizem sobre aquelas dezoito pessoas que morreram quando a torre de Siloé caiu sobre elas? Vocês pensam que elas tinham mais culpa do que todos os outros que moravam em Jerusalém? ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Eu lhes digo que não! E se não se arrependerem, vocês todos também morrerão, como eles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Depois ele lhes contou esta parábola: —Um homem tinha uma figueira plantada em sua plantação, mas quando foi procurar figos, não encontrou nenhum. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Então disse ao homem que tomava conta da plantação: “Olhe! Já faz três anos que venho procurar figos nesta figueira, mas jamais achei nenhum. Portanto, corte-a; para que deixá-la aí somente ocupando espaço?” ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mas o homem lhe respondeu: “Senhor, deixe-a por mais um ano. Eu vou cavar em volta dela e colocar bastante adubo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Se ela der figos no ano que vem, muito bem; se não der, o senhor pode mandar cortá-la”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jesus estava ensinando numa das sinagogas no sábado, ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","e estava presente uma mulher que já há dezoito anos tinha um demônio, que a deixara doente. Ela andava curvada e de maneira nenhuma conseguia se endireitar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Quando Jesus a viu, chamou-a e lhe disse: —Mulher, você está livre da sua enfermidade. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Depois, ele colocou as mãos sobre ela, e imediatamente ela se endireitou e começou a louvar a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","O chefe da sinagoga ficou indignado por Jesus ter curado a mulher no sábado e disse à multidão: —Há seis dias nos quais se trabalha, portanto, venham nesses dias para serem curados, e não no sábado! ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","O Senhor então lhe respondeu: —Hipócritas! Vocês todos não soltam seus bois ou burros do curral e os levam para beber água no sábado? ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Por que então esta mulher, descendente de Abraão, a quem Satanás tem presa há dezoito anos, não deveria ser libertada da sua aflição no sábado? ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Quando Jesus disse isto, todos aqueles que estavam contra ele ficaram envergonhados, mas a multidão ficou alegre com as coisas maravilhosas que ele fazia. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Então disse: —Como é o reino de Deus? A que se pode compará-lo? ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","É como uma semente de mostarda que alguém plantou no seu jardim. Ela cresceu, transformou-se numa árvore e as aves do céu fizeram ninhos nos seus galhos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","E disse ainda: —A que mais eu poderia comparar o reino de Deus? ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","É como o fermento, que uma mulher misturou com três medidas de farinha, até tudo ficar fermentado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus passava por cidades e vilas e ensinava enquanto continuava no seu caminho para Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Um homem lhe disse: —Senhor, são poucos os que se salvarão? E ele lhes disse: ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Esforcem-se para entrar pela porta estreita, pois eu lhes digo que muitos tentarão entrar, mas não conseguirão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Uma vez que o dono da casa se levantar e fechar a porta, vocês ficarão do lado de fora. Então vocês baterão na porta, dizendo: “Abra a porta para nós, Senhor!” Mas ele responderá: “Não sei de onde vocês são!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","E vocês então dirão: “Nós comíamos e bebíamos com o senhor! O senhor ensinava em nossas ruas!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","E ele dirá a vocês: “Não sei de onde vocês são! Afastem-se de mim, todos os que fazem o mal!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Vocês verão a Abraão, Isaque, Jacó e todos os profetas no reino de Deus, mas vocês mesmos serão lançados fora. Então vão chorar e ranger os dentes. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","E muitos virão do ocidente e do oriente, do norte e do sul, e vão tomar lugar à mesa no reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Prestem atenção! Aqueles que são os últimos, serão os primeiros; e aqueles que são os primeiros, serão os últimos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nesse momento, alguns dos fariseus chegaram perto dele e disseram: —Vá embora daqui para algum outro lugar, pois Herodes quer matá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus então lhes disse: —Vão e digam a essa raposa o seguinte: “Eu expulsarei demônios e curarei pessoas hoje e amanhã e, no terceiro dia, terminarei o meu trabalho”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tenho que continuar no meu caminho hoje, amanhã e depois de amanhã, pois um profeta não deve morrer fora de Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalém, Jerusalém! Você que mata os profetas e apedreja os mensageiros que Deus lhe envia! Quantas vezes eu quis juntar o seu povo, como a galinha junta os pintinhos debaixo de suas asas, mas vocês não quiseram! ");
INSERT INTO por_WBTC_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Agora a sua casa ficará abandonada e eu lhes digo que vocês não me verão mais até que digam: “Bendito é aquele que vem em nome do Senhor”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Num sábado, Jesus foi comer na casa de certo líder dos fariseus e todas as pessoas o observavam. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","À sua frente se achava um homem muito inchado, que sofria de hidropisia. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesus então perguntou aos professores da lei e aos fariseus: —É permitido curar no sábado, ou não? ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mas eles não responderam nada. Jesus então segurou o homem, curou-o e depois o mandou embora. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Depois disse a eles: —Imaginem que vocês tivessem um filho ou um boi que caísse num poço num sábado. Será que vocês não o tirariam de lá, mesmo sendo sábado? ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","E eles não puderam responder. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Quando Jesus reparou que os convidados estavam escolhendo os lugares de honra à mesa, ele contou esta parábola: ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Quando alguém o convidar para uma festa de casamento, não ocupe o lugar de honra à mesa, pois alguém mais importante do que você pode também ter sido convidado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Então a pessoa que convidou os dois se aproximará de você e dirá: “Dê o seu lugar a este homem”. Você, então, envergonhado, terá que ocupar o lugar de menos importância. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mas, quando você for convidado, vá e tome o lugar de menor importância. Dessa forma, quando chegar a pessoa que o convidou, dirá: “Aproxime-se mais, meu amigo”. Então você será honrado diante de todos os que estão à mesa com você. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pois todo aquele que exaltar a si mesmo, será humilhado; e o que se humilhar, será exaltado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","E disse também para aquele que o tinha convidado: —Quando você der um almoço ou um jantar, não convide somente os seus amigos, os seus irmãos, os seus familiares ou os seus vizinhos ricos, para que não aconteça que eles também o convidem e, dessa forma, você seja recompensado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Porém, quando você der uma festa, convide os pobres, os inválidos, os aleijados e os cegos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Isso será uma bênção para você, pois eles não têm nada com que retribuir, e você será recompensado na ressurreição dos justos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Quando um dos homens que estava à mesa com ele ouviu isto, disse: —Felizes são todos os que comerem no reino de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mas Jesus lhe disse: —Certo homem estava preparando uma grande festa e convidou muitas pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Quando chegou a hora, ele mandou o seu servo dizer às pessoas que tinham sido convidadas: “Venham! Já está tudo pronto!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mas eles começaram, um por um, a dar desculpas. O primeiro disse ao servo: “Comprei um terreno e preciso ir dar uma olhada nele. Peço-lhe que me desculpe”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Um outro disse: “Comprei cinco juntas de bois e preciso ir ver se trabalham bem. Peço-lhe que me desculpe”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","E outro ainda disse: “Eu acabei de me casar e, por isso, não posso ir”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","O servo, então, regressou e contou essas coisas ao seu senhor. Este ficou muito bravo e disse: “Vá depressa pelas ruas e vielas da cidade e traga os pobres, os inválidos, os cegos e os aleijados”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","O servo disse: “Eu já fiz o que o senhor mandou, mas ainda há muitos lugares”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Então o senhor disse ao servo: “Saia pelas estradas e pelos caminhos das vilas e force todas as pessoas a virem, para que a minha casa fique cheia. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pois uma coisa eu digo: Nenhum dos convidados provará do meu jantar!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Uma grande multidão seguia a Jesus. Então ele se virou e disse: ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Se alguém vier a mim e amar o seu pai, a sua mãe, a sua mulher, os seus filhos, os seus irmãos, as suas irmãs, ou amar a sua própria vida mais do que a mim, esse não pode ser meu discípulo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Se alguém não carregar a sua cruz e me seguir, esse não pode ser meu discípulo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Se alguém de vocês quer construir uma torre, será que ele não se sentará primeiro e calculará o custo, para ver se o dinheiro dá? ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Por outro lado, se ele começar a construção e não conseguir acabá-la, todos os que a virem farão pouco dele e dirão: ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Este homem começou a construir, mas não conseguiu acabar”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ou, se um rei quiser entrar numa batalha contra outro rei, será que não se sentará primeiro para considerar se com dez mil homens é capaz de enfrentar o outro que vem contra ele com vinte mil? ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Se ele não for capaz, terá que enviar uma delegação ao inimigo, enquanto este ainda estiver longe, para perguntar quais são as condições de paz. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Da mesma forma, nenhum de vocês pode vir a ser meu discípulo se não renunciar a tudo o que tem. ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","—Ora, o sal é bom. Mas, se perder o seu sabor, para que mais ele serve? ");
INSERT INTO por_WBTC_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ele não presta para a terra nem para adubo; ele é jogado fora. Aquele que pode me ouvir, ouça! ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Todos os cobradores de impostos e pecadores se juntavam para ouvir a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Então, tanto os fariseus como os professores da lei começaram a criticá-lo, dizendo: —Este homem se mistura com pecadores e come com eles! ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Então ele lhes contou esta parábola: ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Se um de vocês tiver cem ovelhas e perder uma delas, será que não deixará as noventa e nove no pasto para procurar a ovelha perdida até encontrá-la? ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","E, quando a encontra, pôem-na alegremente sobre os ombros e, ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","depois de chegar a casa, chama os seus amigos e vizinhos e lhes diz: “Alegrem-se comigo, pois achei a minha ovelha que estava perdida!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Pois eu lhes digo que, da mesma maneira, haverá mais alegria no céu por causa de um pecador que se arrepende, do que por causa de noventa e nove pessoas justas que não precisam de arrependimento. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","—Ou, imaginem ainda uma mulher que tenha dez moedas de prata e perca uma. Será que ela não acenderá um lampião, varrerá a casa e a procurará cuidadosamente até achá-la? ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","E quando a encontrar, chamará as suas amigas e vizinhas, e dirá: “Alegrem-se comigo, pois encontrei a moeda que tinha perdido!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","E da mesma maneira eu lhes digo: Há alegria na presença dos anjos de Deus por causa de um pecador que se arrepende. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Depois disse: —Certo homem tinha dois filhos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","O mais novo disse ao pai: “Pai, quero a minha parte da herança agora”. O pai, então, dividiu os seus bens entre os dois filhos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Poucos dias mais tarde, o filho mais novo juntou tudo o que tinha e partiu para um país distante. Ali desperdiçou toda a herança que tinha recebido, vivendo uma vida libertina. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Quando ele já tinha gastado tudo, houve uma grande fome por todo aquele país, e ele começou a passar necessidades. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Então ele foi procurar emprego com um dos cidadãos daquele país, que o mandou para sua fazenda para dar de comer aos porcos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ali, com fome, ele desejava comer até mesmo das alfarrobas que os porcos comiam, mas ninguém lhe dava nada. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Quando ele caiu em si, disse: “Quantos empregados de meu pai têm comida de sobra, e eu estou aqui morrendo de fome! ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Vou me levantar, irei para a casa de meu pai, e lhe direi: Pai, pequei contra Deus e contra o senhor ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","e nem mereço mais ser chamado seu filho. Aceite-me como um de seus empregados”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Então ele se levantou e foi para a casa de seu pai. Enquanto o moço ainda estava longe, o pai o viu e ficou comovido. Então, correu ao seu encontro, abraçou-o e o beijou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","O filho lhe disse: “Pai, pequei contra Deus e contra o senhor e não mereço mais ser chamado seu filho”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mas o pai disse aos seus servos: “Depressa! Tragam a melhor roupa e vistam-no com ela e ponham um anel no seu dedo e sandálias nos seus pés. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Também tragam e matem o bezerro gordo. Vamos comê-lo e nos alegrar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Pois este meu filho estava morto e voltou a viver; estava perdido e foi achado!” E todos começaram a festejar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","O filho mais velho estava no campo. Quando regressou, ao chegar perto da casa, ouviu o barulho da música e da dança. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Então, chamou um dos servos e perguntou-lhe o que estava acontecendo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","E ele disse: “O seu irmão voltou para casa são e salvo, por isso seu pai mandou matar o bezerro gordo”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","O filho mais velho ficou muito irritado e não quis entrar em casa. Seu pai, então, veio para fora e insistiu que ele entrasse. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mas ele disse a seu pai: “Todos estes anos eu tenho trabalhado para o senhor e nunca desobedeci a nenhuma de suas ordens. Entretanto o senhor nunca me deu sequer um cabrito para eu poder festejar com meus amigos! ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mas quando esse seu filho, que desperdiçou os seus bens com prostitutas, volta, o senhor mata o bezerro gordo para ele”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","O pai então lhe disse: “Meu filho! Você está sempre comigo e tudo o que é meu é seu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mas nós tínhamos que festejar e nos alegrar, pois seu irmão estava morto e agora voltou a viver; ele estava perdido e foi achado”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus disse aos discípulos: —Havia um homem rico que tinha um administrador. Foram dizer a esse homem que o seu administrador estava desperdiçando os seus bens. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Então o homem chamou o administrador e lhe disse: “O que é isso que estou ouvindo dizer a seu respeito? Preste contas da sua administração, pois você não pode mais continuar como meu administrador”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","O administrador, então, disse para si mesmo: “O meu senhor está me despedindo! E agora? O que eu vou fazer? Eu não sou forte o bastante para trabalhar com a enxada e tenho vergonha de pedir esmolas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Já sei o que eu vou fazer, para que as pessoas me recebam em suas casas, quando eu for mandado embora”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Então ele chamou todos os devedores do seu senhor. Disse ao primeiro: “Quanto é que você deve ao meu senhor?” ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Este lhe disse: “Devo cem barris de azeite”. Então lhe disse: “Aqui está a sua conta; sente-se depressa e escreva cinqüenta”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Depois disse a outro: “E você, quanto deve?” Este lhe respondeu: “Devo trinta mil quilos de trigo”. Então lhe disse: “Aqui está a sua conta; escreva vinte e cinco”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","O senhor elogiou o administrador desonesto, por ter sido astuto. As pessoas deste mundo são muito mais astutas em seus negócios do que as pessoas que pertencem à luz. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","E eu lhes recomendo: Façam amigos com as riquezas deste mundo para que, quando elas se acabarem, vocês sejam recebidos nos lares eternos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Aquele que é fiel em pouco, também é fiel em muito. Aquele que é desonesto em pouco, também é desonesto em muito. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pois, se vocês não forem fiéis com as riquezas deste mundo, quem vai confiar a vocês as riquezas verdadeiras? ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","E se vocês não forem fiéis com o que pertence aos outros, quem lhes dará o que pertence a vocês? ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ninguém pode servir a dois senhores, pois ou odiará a um e amará o outro, ou se dedicará a um e desprezará o outro. Vocês não podem servir a Deus e ao mesmo tempo servir às riquezas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Como os fariseus gostavam muito de dinheiro, fizeram pouco dele quando o ouviram dizer isto. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Então Jesus lhes disse: —Vocês são aqueles que se fazem de bons aos olhos dos outros, mas Deus conhece os seus corações. Aquilo que os homens pensam que vale muito, para Deus é detestável. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","A lei e os profetas valeram até João. Daí em diante as Boas Novas do reino de Deus estão sendo anunciadas, e todos se esforçam para entrar nele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mas é mais fácil que o céu e a terra desapareçam, do que um só “til” caia da lei. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—Qualquer homem que se divorcie de sua mulher e se case com outra, comete adultério. Quem se casar com uma mulher divorciada pelo seu marido, também comete adultério. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","—Havia um homem rico que se vestia com roupas muito finas e que se divertia com muito luxo todos os dias. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Havia também um homem pobre chamado Lázaro, cujo corpo estava coberto de feridas, e que costumava ficar no portão da casa do homem rico. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lá ele desejava comer as migalhas que caíam da mesa do rico. Mas até mesmo os cães vinham lamber as suas feridas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lázaro morreu e foi levado pelos anjos para junto de Abraão. O homem rico também morreu e foi enterrado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","E no Hades, estando atormentado, o homem rico olhou e viu, bem longe, Abraão, e Lázaro ao seu lado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Então disse em voz alta: “Tenha pena de mim, pai Abraão! Mande Lázaro para que ele possa molhar a ponta de seu dedo em água e me refrescar a língua; pois sofro muito neste fogo!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mas Abraão disse: “Meu filho! Lembre-se de que, durante a sua vida, você teve tudo o que era bom, enquanto Lázaro só teve o que era ruim. Agora ele está consolado e você, sofrendo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Além do mais, um grande abismo foi colocado entre vocês e nós, para que os que queiram passar daqui para o lado de vocês não possam e para que ninguém daí possa atravessar para o nosso lado”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","E o rico disse: “Então eu lhe imploro, pai Abraão, que mande Lázaro até a casa de meu pai, ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","pois tenho cinco irmãos. Deixe que ele os avise para que eles não venham também para este lugar de tormento”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mas Abraão respondeu: “Eles têm Moisés e os profetas. Que os ouçam!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ele disse: “Isso não chega, pai Abraão! Mas se alguém dos mortos for até eles, arrepender-se-ão”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Então Abraão disse: “Se eles não escutarem nem a Moisés e nem aos profetas, tampouco se convencerão mesmo que alguém ressuscite”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus disse aos seus discípulos: —Sempre vão acontecer coisas que farão com que as pessoas pequem; mas ai daquele que as provoca! ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Seria melhor para ele ser jogado no mar com uma pedra de moinho amarrada no pescoço, do que fazer com que um dos meus seguidores peque. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tenham cuidado! Se o seu irmão pecar contra você, repreenda-o; e se ele se arrepender, perdoe-lhe. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","E, se o seu irmão pecar contra você sete vezes no mesmo dia, e, se todas as sete vezes ele vier e disser: “Estou arrependido”, perdoe-lhe. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Então os apóstolos disseram ao Senhor: —Aumente a nossa fé. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","E o Senhor lhes disse: —Se a sua fé fosse do tamanho de uma semente de mostarda, poderiam dizer a esta amoreira: “Arranque-se daqui com raiz e tudo e plante-se no mar” e ela lhes obedeceria. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","—Suponhamos que você tenha um servo que trabalhe na lavoura ou que cuide de ovelhas. Quando ele volta do trabalho, será que você vai lhe dizer: “Venha depressa e sente-se para comer”? Claro que não! ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Você vai lhe dizer: “Prepare o meu jantar, ponha o seu avental e me sirva, enquanto eu como e bebo. Depois você pode comer e beber”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Você não vai agradecer ao seu servo por fazer o que você mandou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","O mesmo acontece com vocês. Depois de fazerem tudo o que lhes foi ordenado fazer, devem dizer: “Somos servos e não temos mérito algum, pois fizemos somente o nosso dever”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Em seu caminho para Jerusalém, Jesus passou pelo meio da Galiléia e Samaria. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Quando se aproximava de uma vila, dez homens com lepra foram ao seu encontro. Eles pararam a certa distância ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","e gritaram: —Jesus, Mestre, tenha pena de nós! ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Quando Jesus os viu, disse: —Vão e apresentem-se aos sacerdotes. Enquanto eles estavam indo, ficaram curados. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Um deles, porém, voltou atrás, quando percebeu que estava curado e louvou a Deus em voz alta. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","E se ajoelhou aos pés de Jesus, e lhe agradeceu. Ele era samaritano. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesus lhe perguntou: —Não foram dez os homens que foram curados? Onde estão os outros nove? ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nenhum deles voltou atrás para dar graças a Deus a não ser este estrangeiro? ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Então Jesus disse ao homem: —Levante-se e vá embora. Você está curado porque teve fé. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Uma vez, quando os fariseus lhe perguntaram quando viria o reino de Deus, ele lhes respondeu: —O reino de Deus não vem de maneira visível. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nem ninguém poderá dizer: “Está aqui!” ou “está ali!”, porque o reino de Deus está dentro de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesus disse aos seus discípulos: —Dias virão em que vocês desejarão participar da glória do Filho do Homem quando ele voltar, mas não poderão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Então muitos dirão a vocês: “Aqui está ele!” ou “Lá está ele!” Mas não vão nem os sigam! ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Pois, assim como um relâmpago brilha e ilumina o céu de um lado a outro, assim também será no dia em que o Filho do Homem voltar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mas, antes disso, ele tem que sofrer muitas coisas e tem que ser rejeitado por esta geração. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Pois assim como aconteceu nos dias de Noé, também acontecerá quando o Filho do Homem voltar: ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Eles comiam e bebiam; os homens se casavam e as mulheres eram dadas em casamento; tudo isso até o dia em que Noé entrou na arca. Então veio o dilúvio e destruiu a todos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Acontecerá a mesma coisa que aconteceu no tempo de Ló: Todos comiam e bebiam, compravam e vendiam, plantavam e construíam. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mas, no dia em que Ló saiu de Sodoma, choveu fogo e enxofre do céu e destruiu a todos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Assim será no dia em que o Filho do Homem for revelado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nesse dia, aquele que estiver no telhado e tiver as suas coisas em casa, não entre para ir buscá-las. Assim também, aquele que estiver no campo, não volte para casa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lembrem-se da mulher de Ló! ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Quem tentar salvar a sua vida, irá perdê-la; e quem perder a sua vida, irá salvá-la. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Eu lhes digo uma coisa: Naquela noite, duas pessoas estarão numa cama; uma será levada e a outra, deixada. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Duas mulheres estarão moendo trigo juntas; uma será tirada e a outra, deixada. ");
INSERT INTO por_WBTC_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Os discípulos, então, lhe perguntaram: —Senhor, onde vai acontecer isto? E Jesus lhes disse: —Onde estiver o morto, ali se ajuntarão os urubus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesus lhes contou uma parábola para lhes ensinar que deveriam orar sempre, sem desanimar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ele disse: —Em certa cidade havia um juiz que não temia a Deus e nem respeitava a ninguém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nessa mesma vila vivia também uma viúva que sempre o procurava, pedindo: “Ajude-me a obter justiça contra o meu adversário”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Por muito tempo ele se negou a ajudar a viúva, mas um dia disse para si mesmo: “É certo que eu não temo a Deus e que também não respeito a ninguém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Porém, tenho que ajudar esta viúva a obter justiça, pois ela não pára de me aborrecer e, se eu não a ajudar, ela nunca me deixará em paz”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Então o Senhor disse: —Considerem o que o juiz desonesto disse. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Não fará Deus justiça a favor do seu povo que grita por socorro dia e noite? Será que ele vai demorar para ajudá-lo? ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Eu lhes digo que ele fará justiça ao seu povo e depressa. Porém, será que o Filho do Homem encontrará fé na terra quando voltar? ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Para aqueles que tinham certeza de que eram justos e que desprezavam os outros, ele contou esta parábola: ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Dois homens subiram ao templo para orar; um era fariseu e o outro cobrador de impostos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","O fariseu se levantou e orou consigo mesmo: “Meu Deus! Eu lhe agradeço por não ser como as outras pessoas: ladrões, desonestos, adúlteros, ou até mesmo como este cobrador de impostos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Jejuo duas vezes por semana e dou dez por cento de tudo o que ganho”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","O cobrador de impostos, porém, de longe, nem sequer olhava para o céu e, batendo no peito, dizia: “Meu Deus! Tenha compaixão de mim, pois sou pecador!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Eu lhes digo que este homem, e não o outro, foi para casa em paz com Deus. Pois todo aquele que se exaltar será humilhado, e aquele que se humilhar será exaltado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","E levavam até mesmo crianças a Jesus, para que ele pudesse abençoá-las. Quando, porém, os discípulos viram isto, repreenderam aqueles que as levavam. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mas Jesus, chamando as crianças para perto de si, disse: —Deixem que as criancinhas venham a mim; não as proíbam! Pois o reino de Deus pertence aos que são como estas crianças. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Digo a verdade a vocês: Quem não receber o reino de Deus assim como uma criança o faz, nunca entrará nele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Certo líder judeu perguntou-lhe: —Bom Mestre, o que devo fazer para herdar a vida eterna? ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus lhe respondeu: —Por que você me chama de bom? Só Deus é bom, e mais ninguém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Você conhece os mandamentos: “Não cometa adultério, não mate, não roube, não dê falso testemunho, honre a seu pai e a sua mãe”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","E o homem, então, disse: —Desde pequeno tenho obedecido a todos esses mandamentos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Quando Jesus ouviu isto, disse: —Ainda está faltando uma coisa: Venda tudo o que você tem e distribua o dinheiro entre os pobres; então você terá um tesouro no céu. Depois venha e siga-me. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Quando o homem ouviu isto, ficou muito triste, pois era riquíssimo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus viu que ele estava triste e disse: —Como é difícil para os ricos entrarem no reino de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","É mais fácil um camelo passar pelo buraco de uma agulha, do que um rico entrar no reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Os que o ouviam, disseram: —Então, quem é que pode ser salvo? ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ele disse: —O que é impossível para as pessoas, é possível para Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Então Pedro disse: —Olhe, nós deixamos tudo o que tínhamos para seguir o senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesus, então, lhes disse: —Digo a verdade a vocês: Não há ninguém que tenha deixado casa, mulher, irmãos, pais ou filhos por causa do reino de Deus, ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","e que não receba no presente muitas vezes mais e, no futuro, a vida eterna. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus chamou os doze discípulos de lado e lhes disse: —Escutem! Nós estamos indo para Jerusalém e todas as coisas que os profetas escreveram a respeito do Filho do Homem acontecerão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ele será entregue aos que não são judeus e estes vão zombar, insultar, cuspir nele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","E, depois de baterem nele, matá-lo-ão. Mas no terceiro dia ele ressuscitará. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Os discípulos, porém, não entenderam nada do que Jesus falou. O sentido daquelas palavras estava escondido deles e eles não sabiam do que Jesus falava. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesus estava chegando perto da cidade de Jericó. Um homem cego, sentado à beira da estrada, pedia esmolas ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","e, quando ouviu a multidão passando, perguntou o que estava acontecendo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","E lhe disseram que Jesus de Nazaré estava passando. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ao ouvir isto, ele começou a gritar: —Jesus, Filho de Davi, tenha pena de mim! ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aqueles que estavam indo na frente diziam para ele ficar quieto, mas ele gritava ainda mais: —Filho de Davi, tenha pena de mim! ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesus, então, parou e mandou que lhe trouxessem o cego. Quando o cego já estava perto dele, Jesus lhe perguntou: ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—O que quer que eu faça por você? E ele respondeu: —Quero voltar a ver, Senhor! ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Então Jesus lhe disse: —Receba a sua visão. A sua fé o curou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","E, no mesmo instante, o cego recuperou a vista e seguia Jesus e dava glórias a Deus. Todas as pessoas que viram isto louvavam a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus entrou em Jericó e estava atravessando a cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Havia em Jericó um homem rico chamado Zaqueu, chefe dos cobradores de impostos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ele queria ver quem era Jesus, mas não conseguia por causa da multidão e também porque era muito baixo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Então, correndo à frente de todos, Zaqueu subiu em uma figueira brava a fim de ver a Jesus, pois ele ia passar por ali. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Quando chegou àquele lugar, Jesus olhou para cima e lhe disse: —Desça depressa, Zaqueu, pois eu tenho que ficar na sua casa hoje. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ele desceu depressa e o recebeu com grande alegria. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Todos viram aquilo e começaram a reclamar, dizendo: —Ele vai ficar na casa desse pecador! ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueu se levantou e disse: —Olhe, Senhor! Eu darei metade de tudo o que tenho aos pobres e, se enganei alguém para lhe tirar alguma coisa, eu devolverei quatro vezes mais. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus, então, lhe disse: —Hoje a salvação entrou nesta casa, pois este homem também é descendente de Abraão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","O Filho do Homem veio para procurar e salvar o perdido. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Todos ouviam o que Jesus dizia. Então, como estavam perto de Jerusalém e como eles pensavam que o reino de Deus estava prestes a aparecer, Jesus continuou e lhes contou esta parábola: ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Um homem nascido de família importante foi para um país distante a fim de tomar posse de um reino e depois voltar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Então, chamou seus dez servos, deu-lhes dez sacos de dinheiro e lhes disse: “Vejam o que vocês podem fazer com este dinheiro até eu voltar”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mas o povo do seu reino o odiava, e mandou, então, uma delegação atrás dele, dizendo: “Nós não queremos que este homem reine sobre nós”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","O homem, porém, foi, tomou posse do seu reino e voltou para casa. Aí mandou chamar os servos a quem tinha dado o dinheiro, a fim de verificar os lucros que eles tinham conseguido. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","O primeiro chegou e disse: “Senhor, o dinheiro que o senhor me deu rendeu dez vezes mais”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","O senhor, então, lhe disse: “Muito bem! Você é um bom servo! Como você foi fiel em uma coisa pequena, vou nomeá-lo para tomar conta de dez cidades”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Depois veio o segundo e disse: “Senhor, o dinheiro que o senhor me deu rendeu cinco vezes mais”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ele disse a este: “Vou nomeá-lo para tomar conta de cinco cidades”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Então, veio o outro e disse: “Aqui está o seu saco de dinheiro, senhor. Eu o embrulhei num lenço e o guardei. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Eu tive medo porque sei que o senhor é um homem duro, pois tira o que não deu e colhe o que não plantou”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","O senhor então lhe disse: “Você é um mau servo! Eu usarei as suas próprias palavras para condená-lo! Se você sabia que eu era um homem duro, que tira o que não dá e colhe o que não planta, ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","por que não colocou o meu dinheiro num banco? Se tivesse feito isso, eu receberia o dinheiro de volta com juros!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Então, disse para as pessoas que estavam perto: “Tirem dele o saco de dinheiro e dêem ao que tem dez sacos”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","E eles responderam: “Mas senhor, ele já tem dez sacos!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","E o senhor afirmou: “Pois eu lhes digo que, a todo aquele que tem, mais será dado, mas aquele que não tem, até o que ele tem lhe será tirado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","E agora tragam aqui aqueles meus inimigos que não queriam mais que eu fosse rei deles e matem-nos na minha presença”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Depois de ter dito estas coisas, Jesus seguiu adiante para Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Quando estava próximo de Betfagé e de Betânia, junto ao Monte das Oliveiras, Jesus enviou dois de seus discípulos, dizendo: ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Vão até aquela vila ali na frente. Chegando lá, vocês encontrarão um jumentinho preso que nunca foi montado. Soltem-no e tragam-no aqui. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Se alguém lhes perguntar: “Por que vocês o estão soltando?”, digam: “Porque o Senhor precisa dele”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Os que tinham sido enviados foram e encontraram tudo exatamente como ele tinha dito. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","E, enquanto estavam desamarrando o jumentinho, os donos lhes perguntaram: —Por que vocês estão soltando o jumentinho? ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Eles responderam: —Porque o Senhor precisa dele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Então levaram o jumentinho a Jesus, puseram as suas capas em cima do animal e ajudaram-no a montá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Enquanto Jesus seguia, as pessoas estendiam suas capas pelo caminho. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Quando começaram a descer o Monte das Oliveiras, toda a multidão de discípulos começou a louvar a Deus alegremente e em alta voz, por todos os milagres que tinham visto. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Eles diziam: —“‘Bendito é o Rei que vem em nome do Senhor!’ Paz no céu e glória a Deus!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Alguns dos fariseus que estavam na multidão disseram a Jesus: —Mestre, diga a seus discípulos que fiquem quietos! ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ele respondeu: —Eu lhes digo que, se eles ficarem quietos, as próprias pedras gritarão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Quando Jesus se aproximou e viu a cidade de Jerusalém, chorou ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","e disse: —Se ao menos hoje você soubesse o que era preciso para conseguir a paz! Mas você não pode ver, pois isso está escondido de seus olhos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dias virão em que os seus inimigos levantarão barreiras à sua volta. Eles cercarão você e marcharão contra você de todos os lados. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Eles destruirão completamente a você e a todo o seu povo e não deixarão ficar uma pedra sobre outra, pois você não reconheceu o tempo em que Deus veio para lhe salvar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ao entrar no templo, Jesus começou a expulsar de lá os vendedores, ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","dizendo: —As Escrituras dizem: “A minha casa será uma casa de oração”. Vocês, porém, transformaram-na num “esconderijo de ladrões”! ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesus ensinava no templo todos os dias. Os líderes dos sacerdotes, os professores da lei e os líderes do povo estavam procurando um meio de matá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","No entanto, não conseguiam encontrar nenhuma forma de fazê-lo, pois todo o povo prestava muita atenção nas palavras dele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Um dia Jesus estava no templo ensinando o povo e anunciando as Boas Novas, quando os líderes dos sacerdotes, os professores da lei e os anciãos se aproximaram dele ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","e disseram: —Diga-nos que autoridade tem para fazer essas coisas e quem lhe deu essa autoridade? ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ele respondeu: —Eu também quero lhes fazer uma pergunta. Digam-me isto: ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Quem deu a João autoridade para batizar: Deus ou os homens? ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Eles começaram a discutir entre si e diziam: —Se nós respondermos: “Foi Deus”, ele nos perguntará: “Por que então vocês não acreditaram nele?” ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Se nós respondermos: “Foram os homens”, todo o povo nos apedrejará, pois estão convencidos de que João era um profeta. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Então eles responderam que não sabiam quem tinha dado autoridade a João para batizar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesus, então, lhes disse: —Então eu também não vou lhes dizer com que autoridade faço estas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Depois disto Jesus começou a contar ao povo esta parábola: —Um homem plantou uvas em suas terras, arrendou a plantação a alguns lavradores e depois foi-se embora por muito tempo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","No devido tempo, mandou um servo seu aos lavradores para que eles lhe dessem parte dos frutos da sua plantação de uvas. Os lavradores, porém, bateram no servo e o mandaram de volta de mãos vazias. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Então, ele mandou outro servo. Os lavradores, da mesma forma, também bateram nele, humilharam-no e mandaram-no de volta de mãos vazias. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Então, ele mandou ainda um terceiro servo, mas eles, da mesma forma, o feriram e o expulsaram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","O dono da plantação, então, disse: “O que é que eu vou fazer? Vou mandar o meu querido filho; talvez eles o respeitem!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mas, quando os lavradores o viram, conversaram entre eles e disseram: “Este é o herdeiro. Vamos matá-lo e assim a herança será nossa”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Então, eles o jogaram para fora da plantação de uvas e o mataram. O que o dono da plantação fará com esses lavradores? ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ele virá e matará esses lavradores e dará a sua plantação para outros. Quando ouviram isto, eles disseram: —Que isso nunca aconteça! ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mas Jesus olhou bem para eles e disse: —Então, o que querem dizer as Escrituras quando dizem: “A pedra que os construtores rejeitaram veio a ser a pedra mais importante”? ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Todo aquele que cair em cima desta pedra ficará em pedaços; e todo aquele sobre quem a pedra cair será esmagado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Os professores da lei e os líderes dos sacerdotes sabiam que aquela parábola tinha sido dita contra eles. Por isso eles procuravam um meio de prendê-lo ali mesmo, mas tinham medo do povo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Então, eles começaram a observá-lo e enviaram espiões que fingiam ser honestos. O plano deles era pegar a Jesus dizendo alguma coisa errada, pois assim poderiam entregá-lo ao poder e à autoridade do governador. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Os espiões, então, fizeram-lhe esta pergunta: —Mestre! Nós sabemos que o senhor só diz e ensina o que é certo, que o senhor é imparcial e que ensina o caminho de Deus com toda a honestidade. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Responda-nos, então: Devemos pagar impostos a César ou não? ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mas Jesus percebeu a sutileza deles e respondeu: ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Mostrem-me uma moeda de prata. De quem é a imagem e a inscrição na moeda? ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eles disseram: —De César. Então, ele lhes disse: —Dêem a César o que é de César e a Deus o que é de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Eles não conseguiram pegá-lo em nada que ele disse diante do povo. Ao contrário, ficaram admirados com a sua resposta e se calaram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Alguns saduceus se aproximaram de Jesus e, como não acreditavam em ressurreição, perguntaram-lhe: ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Mestre, Moisés nos deixou escrito que, se um homem casado morrer sem deixar filhos, o seu irmão deve se casar com a viúva e ambos devem ter filhos que serão considerados filhos do irmão que morreu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Era uma vez sete irmãos. O primeiro se casou e morreu sem ter filhos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Então, o segundo se casou com a viúva e também morreu sem filhos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Depois o terceiro. E assim aconteceu com os sete irmãos; eles se casaram e todos morreram sem deixar filhos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mais tarde, a mulher também morreu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Portanto, se todos os sete irmãos se casaram com ela, de quem ela vai ser esposa na ressurreição? ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus lhes respondeu: —As pessoas desta época se casam e são dadas em casamento. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Aquelas, porém, que serão consideradas dignas de participar na época que ainda virá e na ressurreição dos mortos, não se casarão nem serão dadas em casamento. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Elas não morrerão mais, pois são como anjos. Elas são filhos de Deus, pois ressuscitaram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisés mesmo mostrou que os mortos ressuscitam. Na passagem do arbusto que se queimava, ele se referiu ao Senhor como Deus de Abraão, Deus de Isaque e Deus de Jacó. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ora, ele não é Deus dos mortos, mas sim dos vivos, pois, para ele, todas as pessoas estão vivas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Alguns dos professores da lei disseram: —O senhor respondeu bem, Mestre! ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","E ninguém mais se atreveu a lhe fazer perguntas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesus, então, lhes perguntou: —Como vocês podem dizer que Cristo é filho de Davi? ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","O próprio Davi diz, no livro de Salmos: “O Senhor disse ao meu Senhor: Sente-se do meu lado direito ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","até que eu coloque os seus inimigos debaixo dos seus pés”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Se o próprio Davi o chama de Senhor, como pode ele ser seu filho? ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Enquanto as pessoas escutavam, Jesus disse aos seus discípulos: ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Tenham cuidado com os professores da lei. Eles gostam de andar com as suas roupas elegantes e gostam de ser cumprimentados com respeito em lugares públicos. Eles também gostam muito de ocupar os lugares mais importantes nas sinagogas e os lugares de honra nas festas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Eles exploram as viúvas, roubando delas os bens e, ao mesmo tempo, fazem longas orações para serem notados. Estes receberão o pior castigo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus viu algumas pessoas ricas colocando suas ofertas na caixa de contribuições do templo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Viu também uma viúva pobre colocando lá duas moedas pequenas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Então, disse: —Digo a verdade a vocês: Esta viúva pobre deu mais do que todos os outros. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Todas as outras pessoas fizeram as suas ofertas dando do dinheiro que tinham sobrando; ela, porém, na sua pobreza, deu tudo o que tinha para viver. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Alguns dos discípulos estavam comentando a respeito do templo, de como ele era bonito, da decoração feita com belas pedras e das ofertas dadas a Deus. Jesus, então, disse: ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Com relação ao que vocês estão vendo, dias virão em que nem uma pedra será deixada sobre a outra. Tudo será derrubado! ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Eles lhe perguntaram: —Mestre, quando acontecerão essas coisas? Qual será o sinal de que essas coisas estão prestes a acontecer? ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesus respondeu: —Tenham cuidado para não serem enganados, pois muitos virão em meu nome e dirão: “Eu sou ele”, ou ainda: “O tempo está próximo”. Não os sigam! ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Não tenham medo quando vocês ouvirem falar de guerras e revoluções. Todas essas coisas têm que acontecer primeiro, mas isso não quer dizer que o fim está próximo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Depois Jesus lhes disse: —Uma nação vai fazer guerra contra outra e um país atacará outro. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Haverá grandes terremotos, fome e epidemias em vários lugares. Acontecerão coisas terríveis e grandes sinais serão vistos no céu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mas antes de tudo isto acontecer, vocês serão presos e perseguidos. Vocês serão levados para as sinagogas para julgamento e serão postos em prisões. E por minha causa serão levados para diante dos reis e dos governadores. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Isto lhes dará uma oportunidade de dar testemunho a meu respeito. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Portanto, decidam desde já não se preocuparem antes da hora com o que vocês dirão para se defender, ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","pois Eu lhes darei palavras e sabedoria que nenhum dos seus adversários poderá resistir nem negar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Vocês serão traídos por seus pais, irmãos, parentes e amigos; alguns de vocês serão mortos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Vocês serão odiados por todos por causa do meu nome. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mas, nem um só fio de cabelo de sua cabeça se perderá. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","É por meio da perseverança que vocês salvarão suas almas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Quando virem Jerusalém cercada por exércitos, saberão que a sua destruição está próxima. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Assim, aqueles que estiverem na Judéia, fujam para as montanhas; aqueles que estiverem na cidade, saiam dela; e aqueles que estiverem nos campos, não voltem para a cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Pois estes são os dias de castigo, para que aconteçam todas as coisas que foram escritas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ai das mulheres que estiverem grávidas ou amamentando nessa época, pois haverá grande aflição na terra e a ira de Deus estará contra este povo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Muitos serão mortos à espada, outros serão levados como escravos para todos os países e Jerusalém será pisada por aqueles que não são judeus até que se complete o tempo deles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Haverá sinais no sol, na lua e nas estrelas e, na Terra, as nações estarão desesperadas, com medo do barulho e da agitação do mar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Muitos desmaiarão de medo e de apreensão com o que vai acontecer ao mundo, pois os corpos celestes serão abalados. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Depois, o Filho do Homem será visto vindo numa nuvem, com poder e grande glória. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Quando estas coisas começarem a acontecer, endireitem os seus corpos e levantem as suas cabeças, pois a libertação de vocês se aproxima. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesus, então, lhes contou esta parábola: —Olhem para a figueira ou para qualquer outra árvore. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Quando vêem as folhas começarem a brotar, vocês sabem que o verão está chegando. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Assim também, quando vocês virem estas coisas acontecerem, saibam que o reino de Deus está próximo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Digo a verdade a vocês: Esta geração não passará até que todas estas coisas aconteçam. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","O céu e a terra desaparecerão, porém as minhas palavras permanecerão para sempre. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","—Vigiem a si mesmos, para que os corações de vocês não se encham de festas, bebedeiras e preocupações com as coisas desta vida. Se vocês não fizerem isso, esse dia virá de repente e pegará vocês como uma armadilha, ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","pois ele virá sobre todos os que vivem na face da terra. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Vigiem-se a todo momento e orem para que sejam capazes de escapar de tudo o que vai acontecer e de se apresentar diante do Filho do Homem. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesus ensinava no templo todos os dias e passava as noites num monte chamado das Oliveiras. ");
INSERT INTO por_WBTC_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","E todo o povo se levantava cedo pela manhã e ia ao templo para ouvi-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Estava próxima a Festa dos Pães sem Fermento, chamada a Páscoa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Os líderes dos sacerdotes e os professores da lei procuravam um meio de matar a Jesus, mas temiam o povo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Então Satanás entrou em Judas, (chamado Iscariotes) que era um dos doze apóstolos e ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ele foi falar com os líderes dos sacerdotes e com os chefes da guarda do templo para combinar um jeito de entregar a Jesus nas mãos deles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Eles ficaram muito contentes e concordaram em lhe dar dinheiro. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas aceitou e começou a procurar uma oportunidade de trair Jesus, quando a multidão não estivesse com ele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","O dia da Festa dos Pães sem Fermento chegou e, nesse dia, o cordeiro da Páscoa era sacrificado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus, então, enviou Pedro e João dizendo: —Vão e preparem o jantar da Páscoa para nós comermos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Eles lhe disseram: —Onde o senhor quer que nós o preparemos? ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ele lhes respondeu: —Quando vocês entrarem na cidade, um homem, levando uma jarra de água, encontrará com vocês. Sigam-no e entrem na casa em que ele entrar. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Digam ao dono da casa: “O Mestre mandou perguntar onde fica a sala de jantar na qual ele e os seus discípulos poderão comer o jantar da Páscoa”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Esse homem lhes mostrará uma grande sala mobiliada, no andar de cima da casa; façam ali os preparativos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eles foram e encontraram tudo exatamente como ele lhes havia dito. E então prepararam o jantar da Páscoa. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Quando chegou a hora, Jesus tomou seu lugar à mesa com os apóstolos e ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","lhes disse: —Eu tenho desejado muito comer este jantar de Páscoa junto com vocês, antes de sofrer. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pois eu lhes digo que nunca mais o comerei até que ele receba o significado completo no reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Então, pegando o cálice, Jesus agradeceu a Deus e disse: —Peguem isto e dividam entre vocês, ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","pois eu lhes digo: Nunca mais beberei vinho até que chegue o reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","E, pegando o pão, agradeceu a Deus, partiu-o em pedaços e os deu a seus discípulos, dizendo: —Isto é o meu corpo, que é dado por vocês. Façam isto para se lembrar de mim. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Depois do jantar, Jesus fez o mesmo com o cálice, dizendo: —Este cálice representa a nova aliança entre Deus e seu povo, selada com o meu sangue, que é derramado a favor de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","No entanto, vejam! Aquele que vai me trair está aqui comigo à mesa! ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Isto acontece para que o Filho do Homem morra como já foi determinado; mas ai daquele por quem ele é traído! ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Eles, então, começaram a perguntar uns aos outros qual deles faria aquilo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","E também começaram a discutir entre si, querendo saber qual deles seria considerado o mais importante. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mas Jesus lhes disse: —Os reis das nações dominam o povo e os governadores fazem com que as pessoas os chamem de amigos do povo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mas, entre vocês não é assim. Pelo contrário, o maior entre vocês deve ser como o mais insignificante e o que governa como o que serve. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Pois, quem é mais importante? O que está à mesa ou o que serve? Não é o que está à mesa? Porém, eu estou entre vocês como aquele que serve. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Vocês têm estado sempre firmes comigo nas minhas provações. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","E assim como meu Pai me deu o poder real, eu o dou a vocês, ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","para que vocês possam comer e beber à mesa comigo no meu reino. E vocês, então, se sentarão em tronos e julgarão as doze tribos de Israel. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","—Simão, Simão! Satanás pediu para colocar todos vocês à prova, peneirando-os como se peneira o trigo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Eu tenho orado por você, para que não lhe falte fé. E, quando você voltar, ajude os seus irmãos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro lhe disse: —Eu estou pronto para ir para a cadeia ou até mesmo para morrer pelo senhor! ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","E Jesus lhe disse: —Eu lhe digo uma coisa, Pedro: Antes que o galo cante hoje, você negará três vezes que me conhece. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","E Jesus continuou, dizendo: —Quando eu os enviei sem dinheiro, sem mala, e sem sandálias, por acaso lhes faltou alguma coisa? Eles responderam: —Não, nada. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ele lhes disse: —Agora, porém, quem tiver dinheiro, que o leve; quem tiver mala, que a leve também; e quem não tiver uma espada, que venda a sua capa e compre uma. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pois as Escrituras dizem: “Ele foi considerado como um criminoso”. E esta referência, que deve ser cumprida em mim, está prestes a acontecer. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Eles disseram: —Senhor, olhe! Aqui estão duas espadas. —Basta!—disse Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Depois, como de costume, Jesus saiu e foi para o Monte das Oliveiras e os seus discípulos o seguiram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Quando chegaram ao lugar escolhido, Jesus lhes disse: —Orem para não caírem em tentação. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","E afastando-se deles alguns metros, ajoelhou-se e orou, dizendo: ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Pai, o senhor pode afastar de mim este cálice de sofrimento, se quiser. Mas, que seja feita a sua vontade, e não a minha. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Um anjo do céu apareceu para lhe dar forças. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesus, porém, cheio de angústia, orou ainda com mais força e seu suor era como gotas de sangue caindo no chão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Quando Jesus terminou de orar, levantou-se, aproximou-se dos discípulos e os encontrou dormindo. (Eles estavam exaustos, pois a tristeza deles era muito grande.) ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Então lhes disse: —Por que vocês estão dormindo? Levantem-se e orem para que não caiam em tentação! ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus ainda estava falando quando uma multidão apareceu, e Judas, um dos doze discípulos os guiava. Ele se aproximou de Jesus para beijá-lo, ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","mas Jesus lhe disse: —Você vai trair o Filho do Homem com um beijo, Judas? ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Quando os discípulos que estavam ao redor de Jesus viram o que ia acontecer, perguntaram: —Senhor, devemos pegar nossas espadas e atacar? ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","E um deles atacou o servo do sumo sacerdote e cortou-lhe a orelha direita. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesus, então, lhes respondeu: —Parem com isso! Aí ele tocou na orelha do servo e a curou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Depois, Jesus disse aos líderes dos sacerdotes, aos chefes dos guardas do templo e aos anciãos que tinham ido prendê-lo: —Por que vocês vieram com espadas e cacetes para me prender, como se eu fosse um ladrão? ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Eu estive com vocês todos os dias no templo, e ninguém pôs as mãos em mim! Mas esta é a hora de vocês—a hora de reinar a escuridão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Eles o prenderam e o levaram para a casa do sumo sacerdote. Pedro os seguia de longe. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Eles acenderam uma fogueira no meio do pátio e se sentaram juntos ao redor dela. Pedro estava no meio deles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Uma empregada o viu sentado junto ao fogo e, olhando bem para ele, disse: —Este homem também estava com ele! ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mas ele negou, dizendo: —Eu nem o conheço, mulher! ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pouco depois, outra pessoa o viu e disse: —Você também é um deles! Mas Pedro disse: —Não sou, homem! ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mais ou menos uma hora depois, uma outra pessoa começou a insistir, dizendo: —Sem dúvida que este homem também andava com ele, pois também é galileu! ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro respondeu: —Eu não sei do que você está falando, homem! E naquele momento, enquanto Pedro ainda falava, um galo cantou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Então o Senhor se virou e olhou para Pedro e este se lembrou das palavras do Senhor e de como ele tinha dito: “Antes que o galo cante hoje, você negará três vezes que me conhece”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedro, então, saiu de lá e chorou amargamente. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Os homens que estavam tomando conta de Jesus começaram a fazer pouco dele e também a bater nele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Taparam os olhos dele e começaram a interrogá-lo, dizendo: —Adivinhe! Quem bateu em você? ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","E disseram muitas outras coisas para insultá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Quando amanheceu, houve uma reunião entre os anciãos do povo, os líderes dos sacerdotes e os professores da lei. Depois mandaram levar a Jesus ao Conselho Superior deles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Então, disseram a ele: —Se você é o Cristo, diga-nos! Jesus respondeu: —Mesmo que eu lhes diga, vocês não acreditarão em mim. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","E se eu lhes fizer uma pergunta, vocês não responderão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mas, de agora em diante, o Filho do Homem estará sentado ao lado direito do Deus Todo-poderoso. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","E todos perguntaram: —Então, você é mesmo o Filho de Deus? E Jesus lhes respondeu: —Vocês estão certos em dizer que eu o sou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Então eles disseram: —Por que é que precisamos de mais testemunhas? Nós já não o ouvimos confessar com sua própria boca? ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Então, todos se levantaram, levaram Jesus até Pilatos ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","e começaram a acusá-lo, dizendo: —Encontramos este homem enganando o nosso povo! Ele é contra o pagamento de impostos ao imperador e afirma ser o Cristo, Rei! ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatos lhe perguntou: —Você é o rei do judeus? Jesus respondeu: —É verdade. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Então Pilatos disse aos líderes dos sacerdotes e à multidão: —Eu não encontro nenhum motivo para condenar este homem! ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mas eles insistiram, dizendo: —Ele está causando desordem entre o povo por toda a Judéia com o seu ensino; ele começou na Galiléia e agora chegou até aqui! ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ao ouvir isto, Pilatos perguntou se Jesus era da Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Quando soube que Jesus era galileu, e que, portanto, estava sob a jurisdição de Herodes, Pilatos o mandou até ele, pois Herodes estava em Jerusalém naqueles dias. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes ficou muito contente quando viu a Jesus, pois havia já muitos anos que queria vê-lo. Herodes tinha ouvido falar muito dele e esperava que fizesse algum milagre. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes fez muitas perguntas a Jesus, mas este não lhe respondeu nada. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Os líderes dos sacerdotes e os professores da lei também estavam presentes e o acusavam insistentemente. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes e os seus soldados fizeram pouco de Jesus e o trataram com desprezo. Depois, vestiram Jesus com uma capa luxuosa e o mandaram de volta a Pilatos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilatos e Herodes, que antes eram inimigos, se tornaram amigos nesse dia. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatos reuniu os líderes dos sacerdotes, os líderes dos judeus e todo o povo, ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","e lhes disse: —Vocês me trouxeram este homem, acusando-o de estar enganando o povo. Eu o interroguei na presença de vocês e não encontrei nenhum motivo para as acusações que têm contra ele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes também não encontrou nenhum motivo para acusá-lo, visto que o devolveu a nós. Como vocês vêem, ele não fez nada que mereça a morte. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Eu vou mandar castigá-lo com chicotadas e depois vou soltá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mas todos começaram a gritar ao mesmo tempo: —Fora com esse homem! Solte-nos Barrabás! ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barrabás tinha sido preso por promover arruaças na cidade e também por assassinato). ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatos queria libertar a Jesus e falou novamente com a multidão, ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","mas eles continuaram a gritar: —Crucifique-o! Crucifique-o! ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pela terceira vez Pilatos lhes disse: —Mas que crime este homem cometeu? Eu não encontro nele nenhum motivo para condená-lo à morte, portanto vou castigá-lo com chicotadas e depois vou soltá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mas eles continuaram a gritar e a exigir que ele fosse crucificado. Os gritos deles prevaleceram ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","e Pilatos decidiu fazer o que eles queriam. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilatos soltou o homem que tinha sido preso por arruaça e por assassinato—que era o que eles queriam. E lhes entregou a Jesus para fazerem com ele o que quisessem. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Então os soldados levaram a Jesus. No caminho, encontraram um homem de Cirene, chamado Simão, que vinha do campo. Eles o agarraram, puseram a cruz de Jesus sobre ele e o obrigaram a carregá-la, seguindo atrás de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Uma grande multidão o seguia, incluindo algumas mulheres que lamentavam e choravam por ele. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus se voltou e disse a elas: —Não chorem por minha causa, filhas de Jerusalém! Chorem, sim, por vocês mesmas e por seus filhos, ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","pois vão chegar os dias em que as pessoas dirão: “Felizes das mulheres estéreis, das que nunca tiveram filhos e também das que nunca amamentaram”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","E dirão às montanhas: “Caiam sobre nós!” e aos montes: “Cubram-nos!” ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pois, se as pessoas fazem estas coisas quando a árvore ainda está verde, o que acontecerá quando a árvore estiver seca? ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Dois outros homens, ambos criminosos, também estavam sendo levados com ele para serem mortos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Quando chegaram a um lugar chamado “A Caveira”, crucificaram a Jesus e os dois criminosos, um à sua direita e outro à sua esquerda. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Então Jesus disse: —Pai, perdoe-lhes, pois eles não sabem o que fazem. E os soldados sortearam as roupas de Jesus entre eles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","O povo permanecia ali, observando, e os líderes faziam pouco dele, dizendo: —Já que ele salvou outros, que salve a si mesmo, se é que ele é mesmo o Cristo, o escolhido de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Os soldados também se aproximaram e faziam pouco dele e lhe ofereceram vinagre de vinho. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","E diziam: —Salve a si mesmo se você é o Rei dos judeus! ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Acima dele havia uma inscrição que dizia: “Este é o rei dos judeus”. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Um dos criminosos suspensos na cruz o insultava e dizia: —Você não é o Cristo? Então salve a si mesmo e a nós! ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mas o outro repreendeu o primeiro e disse: —Você não teme a Deus? Nós estamos debaixo da mesma condenação! ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","A nossa condenação é justa, pois merecemos este castigo por causa do que fizemos. Mas este homem não fez mal nenhum! ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","E depois, disse: —Jesus, lembre-se de mim quando o senhor entrar no seu reino. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","E Jesus lhe respondeu: —Digo-lhe a verdade: Hoje mesmo você estará comigo no Paraíso. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Era mais ou menos meio-dia quando uma escuridão cobriu toda a terra até às três horas ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","e, durante esse período, o sol não brilhou. A cortina do templo se rasgou pelo meio ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","e Jesus exclamou em voz alta: —Pai, em suas mãos eu entrego o meu espírito! E, depois de dizer isto, ele morreu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Quando o oficial romano viu o que tinha acontecido, louvou a Deus e disse: —Esse homem era realmente inocente. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Quando todas as pessoas que tinham se reunido para o espetáculo viram o que tinha acontecido, foram embora batendo no peito. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Todos aqueles que o conheciam ficaram de longe para observar estas coisas. As mulheres que tinham seguido a Jesus desde a Galiléia também estavam com eles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Havia um homem bom e justo chamado José. Ele era membro do Conselho Judeu, ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","mas não estava de acordo nem com a decisão deles nem com o que eles tinham feito. Ele era de uma cidade da Judéia chamada Arimatéia e estava esperando pelo reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Esse homem foi até Pilatos e lhe pediu o corpo de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ele o tirou da cruz e o enrolou num lençol de linho. Depois ele o colocou num túmulo cavado numa rocha e que nunca tinha sido usado antes. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tudo isso aconteceu no dia da preparação e estava próximo o sábado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","As mulheres que tinham vindo com Jesus da Galiléia acompanharam José e viram o túmulo e como o corpo tinha sido colocado ali. ");
INSERT INTO por_WBTC_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Depois foram para casa e prepararam ervas aromáticas e perfumes para o corpo dele. No sábado elas descansaram, em obediência à lei. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","No primeiro dia da semana, bem cedo, as mulheres foram para o túmulo e levaram os perfumes que tinham preparado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Elas viram que a pedra tinha sido tirada da entrada do túmulo ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","e entraram, porém não encontraram o corpo do Senhor Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Enquanto elas estavam perplexas a esse respeito, apareceram dois homens, vestidos com roupas resplendentes, e se colocaram ao lado delas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Elas ficaram com muito medo e se ajoelharam, levando seus rostos até o chão. Então os dois homens lhes disseram: —Por que vocês estão procurando entre os mortos alguém que está vivo? ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ele não está mais aqui. Ele ressuscitou! Vocês não lembram do que ele disse quando ainda estava na Galiléia: ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","O Filho do Homem tem que ser entregue aos pecadores, ser crucificado e ressuscitar no terceiro dia? ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Então elas se lembraram das palavras de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Depois voltaram do túmulo e contaram todas estas coisas aos onze e a todos os outros. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Elas eram: Maria Madalena, Joana e Maria, a mãe de Tiago. Elas e as outras mulheres que estavam com elas, estavam contando estas coisas aos apóstolos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mas eles acharam que o que elas estavam falando era tolice e não acreditaram nelas. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedro, porém, se levantou e correu para o túmulo. E, ao abaixar-se, não viu nada a não ser os lençóis de linho. Então ele foi embora imaginando o que podia ter acontecido. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Naquele mesmo dia, dois dos discípulos estavam indo para uma vila chamada Emaús, situada mais ou menos a onze quilômetros de Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Eles estavam conversando a respeito das coisas que tinham acontecido. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Enquanto falavam e discutiam sobre o assunto, o próprio Jesus se aproximou e começou a andar com eles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Eles, porém, foram impedidos de o reconhecer. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesus lhes perguntou: —Sobre o que vocês discutiam pelo caminho? Eles pararam e pareciam estar bem tristes. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cléopas, um deles, lhe disse: —Você deve ser a única pessoa viva em Jerusalém que não sabe o que aconteceu por lá nestes últimos dias! ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","E Jesus perguntou: —Do que vocês estão falando? Eles lhe disseram: —É a respeito de Jesus de Nazaré, um homem profeta, poderoso em palavras e obras aos olhos de Deus e de todo o povo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Os nossos líderes e os líderes dos sacerdotes o entregaram para ser condenado à morte e o crucificaram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nós tínhamos esperança de que ele iria ser o libertador de Israel! Além de tudo isso, já faz três dias que essas coisas aconteceram ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","e algumas mulheres do nosso grupo nos surpreenderam, pois elas foram ao túmulo hoje de manhã cedo ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","e não encontraram o corpo dele. Então elas voltaram e nos disseram que tinham tido uma visão, na qual anjos lhes tinham dito que ele estava vivo. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Então, alguns daqueles que estavam conosco também foram ao túmulo e o encontraram exatamente como as mulheres tinham dito, mas não viram a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Então Jesus lhes disse: —Vocês são tolos e demoram muito para acreditar em todas as coisas que os profetas disseram. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Por acaso não era necessário que o Cristo sofresse essas coisas antes de entrar na sua glória? ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Depois, Jesus explicou a eles tudo o que os profetas tinham dito a respeito dele em todas as Escrituras, começando por Moisés. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Eles estavam se aproximando da cidade para onde iam e Jesus fez como quem ia para mais longe. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mas eles insistiram para que ele ficasse, dizendo: —Fique conosco porque é quase noite e o dia já está acabando. Então ele entrou e ficou com os dois discípulos. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Quando Jesus estava à mesa com eles, pegou o pão, deu graças e o repartiu entre eles. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Enquanto ele repartia o pão, os olhos deles se abriram e eles o reconheceram, mas Jesus desapareceu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Então um disse ao outro: —Não parecia que os nossos corações estavam queimando dentro do peito quando ele falava conosco durante o caminho, explicando as Escrituras? ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","E imediatamente eles se levantaram e voltaram para Jerusalém, onde encontraram os onze apóstolos reunidos com os outros. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Os apóstolos e os outros disseram: —O Senhor ressuscitou de verdade! Ele apareceu a Simão! ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Então os dois também contaram o que lhes tinha acontecido no caminho e como tinham reconhecido a Jesus quando ele partiu o pão. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Enquanto estavam falando sobre essas coisas, Jesus apareceu no meio dos discípulos e disse: —A paz esteja com vocês! ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Eles, porém, ficaram assustados e com muito medo e pensaram que estavam vendo um fantasma. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mas ele lhes disse: —Por que vocês estão perturbados? Por que há tantas dúvidas na cabeça de vocês? ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Olhem para as minhas mãos e para os meus pés e vejam que sou eu mesmo! Toquem em mim e vejam; um fantasma não tem carne e ossos como vocês verão que eu tenho! ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Depois de dizer isto, Jesus lhes mostrou suas mãos e os seus pés. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Os discípulos estavam tão alegres que nem podiam acreditar, mas estavam também muito espantados. Então, Jesus lhes disse: —Vocês têm alguma coisa para comer aqui? ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Eles lhe deram um pedaço de peixe assado. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ele o aceitou e o comeu diante deles ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","e lhes disse: —Estas são exatamente as coisas sobre as quais eu lhes falei quando ainda estava com vocês. Tudo o que está escrito a meu respeito na lei de Moisés, nos livros dos profetas e nos Salmos tinha que acontecer. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Então ele abriu as mentes deles para que pudessem entender as Escrituras. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","E lhes disse: —As Escrituras dizem que o Cristo sofrerá e ressuscitará no terceiro dia ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","e que o arrependimento para o perdão dos pecados será proclamado em seu nome para todas as nações, começando em Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Vocês são testemunhas destas coisas e eu lhes mandarei o que o meu Pai prometeu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mas fiquem na cidade, até que aquele poder lá de cima venha sobre vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Depois Jesus os levou até perto da região de Betânia. Ali ele levantou as mãos e os abençoou. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Enquanto os abençoava, Jesus os deixou e foi levado para o céu. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Então eles o adoraram e voltaram para Jerusalém cheios de alegria. ");
INSERT INTO por_WBTC_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Eles estavam sempre no templo, adorando a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Antes de existir qualquer outra coisa, a Palavra já existia. A Palavra estava com Deus. A Palavra era Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aquele que era a Palavra estava com Deus no princípio. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tudo o que existe foi criado por meio dele. Não existe nada que não tenha sido feito por ele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nele estava a vida e essa vida era luz para os homens. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","A luz brilha na escuridão e a escuridão não pôde apagá-la. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Havia um homem chamado João que tinha sido enviado por Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ele veio para falar a respeito da Luz, para que por meio dele todos os homens possam crer na Luz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","João não era a Luz; ele só veio para falar da Luz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Aquele que era a Luz verdadeira estava vindo para o mundo. A Luz verdadeira ilumina a todos os homens. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ele estava no mundo. O mundo foi feito por meio dele, mas o mundo não o conheceu. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ele veio para o mundo que era seu, mas o seu próprio povo não o recebeu. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Porém algumas pessoas o aceitaram. E para essas pessoas que têm fé nele, ele deu o direito de se tornarem filhos de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Eles não nasceram por um novo nascimento físico, ou por desejo ou decisão humana. Eles nasceram de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A Palavra se fez homem e viveu entre nós. A Palavra estava cheia de graça e verdade. Nós vimos a sua glória, glória que pertence somente ao único Filho do Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","João testemunhou a respeito dele e disse: —Era deste homem que eu falava: Aquele que vem depois de mim é mais importante do que eu, pois existia antes de mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ele estava cheio de graça e verdade e todos nós temos recebido dele bênçãos e mais bênçãos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","A lei foi dada por meio de Moisés, mas a graça e a verdade vieram por meio de Jesus Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ninguém jamais viu a Deus. Mas Deus, o único Filho, que está em perfeita união com o Pai, nos mostrou como Deus é. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Os judeus de Jerusalém mandaram alguns sacerdotes e levitas perguntar a João: —Quem é você? Então João, dando testemunho, ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","não hesitou em responder e disse claramente: —Eu não sou o Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Eles tornaram a perguntar: —Então, quem é você? Você é Elias? Ele respondeu: —Não, não sou Elias. Depois perguntaram: —Você é o Profeta? Ele respondeu: —Também não sou o Profeta. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Então disseram: —Diga-nos quem você é para que possamos levar uma resposta àqueles que nos enviaram. O que você diz de você mesmo? ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","João lhes respondeu nas palavras do profeta Isaías: “Eu sou a voz de alguém que clama no deserto: Endireitem o caminho para o Senhor”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","No grupo de judeus enviados a João, estavam também alguns fariseus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Eles disseram: —Você diz que não é o Cristo, nem Elias, nem o Profeta. Então por que está batizando? ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","João respondeu: —Eu batizo em água, mas entre vocês está um homem que vocês não conhecem, ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","e que vem depois de mim. Eu nem sequer sou digno de desamarrar as correias das suas sandálias. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tudo isso aconteceu em Betânia, do outro lado do rio Jordão. Era ali que João estava batizando pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","No dia seguinte, quando João viu que Jesus vinha ao seu encontro, disse: —Olhem o Cordeiro de Deus! O Cordeiro que tira os pecados do mundo! ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Era deste homem que eu dizia: Um homem que é mais importante do que eu virá depois de mim. Ele é mais importante do que eu porque já existia antes de mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Eu mesmo não sabia quem ele era. Mas vim batizando em água para que o povo de Israel pudesse saber quem ele é. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Depois João disse: —Eu não sabia quem era o Cristo. Mas Deus me mandou para batizar em água e disse: “Você vai ver o Espírito Santo descer e pousar num homem. Esse é o homem que vai batizar no Espírito Santo”. João continuou: —Eu vi isso acontecer. Vi o Espírito Santo descer do céu, na forma de uma pomba, e pousar nele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Por isso digo a todos: Ele é o Filho de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","No dia seguinte, João estava no mesmo local e com ele estavam dois dos homens que o seguiam. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ao ver Jesus passar por ali, João disse: —Olhem o Cordeiro de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Os dois homens que seguiam a João ouviram o que ele disse e foram atrás de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus, virando-se para trás, viu que eles o seguiam e disse: —O que vocês querem? Eles perguntaram: —Rabi, onde é que o senhor mora? (Rabi quer dizer “Mestre”.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesus respondeu: —Venham comigo e verão. Então os dois homens foram com ele, viram o lugar onde Jesus morava e ficaram lá com ele nesse dia. Eram mais ou menos quatro horas da tarde. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","André, irmão de Simão Pedro, era um dos dois homens que tinham ido atrás de Jesus depois de terem ouvido João falar dele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Logo depois, André foi procurar seu irmão Simão e lhe disse: —Encontramos o Messias! (Messias quer dizer “Cristo”.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Depois André levou Simão a Jesus. Jesus olhou para Simão e disse: —Você é Simão, filho de João; de agora em diante será chamado Cefas. (Cefas quer dizer “Pedro”.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","No outro dia, Jesus decidiu ir para a Galiléia. Encontrou Filipe e lhe disse: —Siga-me! ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipe era de Betsaida, onde também moravam André e Pedro. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipe encontrou Natanael e disse: —Nós encontramos o homem de quem Moisés escreveu na lei e sobre quem os profetas também escreveram! Ele é Jesus, filho de José. Ele é de Nazaré. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Mas Natanael disse a Filipe: —De Nazaré? Pode vir alguma coisa boa de Nazaré? —Venha ver—respondeu Filipe. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesus viu Natanael vindo em sua direção e disse: —Aqui está um verdadeiro homem do povo de Israel. Nele não há falsidade. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael perguntou: —De onde o senhor me conhece? Jesus respondeu: —Eu vi você quando estava debaixo da figueira, antes de Filipe o chamar. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Então Natanael disse a Jesus: —Mestre, o senhor é o Filho de Deus! O senhor é o Rei do povo de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus respondeu a Natanael: —Você acredita em mim só por eu ter dito que vi você debaixo da figueira? Irá ver coisas maiores do que esta. ");
INSERT INTO por_WBTC_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","E Jesus continuou: —Digo a verdade a vocês: Vocês todos vão ver o céu aberto e “os anjos de Deus subindo e descendo” sobre o Filho do Homem. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dois dias depois, houve um casamento na vila de Caná, na Galiléia. A mãe de Jesus estava ali. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus e os seus discípulos também foram convidados para o casamento. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Quando o vinho se acabou, a mãe de Jesus lhe disse: —Eles não têm mais vinho. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus respondeu: —Senhora, por que me incomoda? O momento determinado para mim ainda não chegou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","A sua mãe disse aos criados: —Façam tudo o que ele disser. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Havia nesse lugar seis jarros de pedra para água. Os judeus usavam jarros como estes para as suas purificações religiosas. Em cada jarro cabiam mais ou menos cem litros. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus disse aos criados: —Encham estes jarros de água. E eles encheram os jarros até a boca. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Depois disse: —Agora tirem um pouco de água e levem ao mestre de cerimônias. E os criados levaram. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Quando o dirigente da festa provou a água, ela tinha se tornado vinho. O dirigente não sabia de onde tinha vindo o vinho (mas os criados que tinham trazido a água sabiam). E então chamou o noivo ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","e disse: —É costume servir o melhor vinho primeiro. Depois de os convidados já terem bebido bastante é que se serve o vinho mais barato. Você, porém, guardou o melhor vinho até agora. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Assim, em Caná da Galiléia, Jesus fez o seu primeiro milagre. Ele mostrou a sua glória, e as pessoas que o seguiam creram nele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Depois disto, Jesus foi para a cidade de Cafarnaum. A mãe de Jesus, os seus irmãos e os seus discípulos foram com ele. Lá ficaram alguns dias. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mas, como se aproximava a festa da Páscoa dos judeus, Jesus foi para Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","No templo, ele viu homens vendendo gado, ovelhas e pombas. Também viu outros sentados às mesas trocando dinheiro. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesus fez um chicote com algumas cordas e expulsou a todos do templo e também as ovelhas e os bois. Virou as mesas e espalhou o dinheiro dos cambistas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Depois disse aos que vendiam pombas: —Tirem tudo isto daqui! Não façam da casa do meu Pai um lugar de compras e vendas! ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Quando isto aconteceu, os discípulos se lembraram que estava escrito nas Escrituras Sagradas: A minha grande dedicação pela tua casa vai me consumir. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Os judeus disseram a Jesus: —Que milagre você vai fazer para provar que tem autoridade para fazer essas coisas? ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus respondeu: —Destruam este templo e em três dias eu o construirei de novo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Os judeus responderam: —Levou quarenta e seis anos para construir este templo! Acredita que pode construí-lo de novo em três dias? ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","(Mas o templo de que Jesus falava era o seu próprio corpo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Depois da ressurreição de Jesus, os seus discípulos se lembraram que ele tinha dito isto e creram nas Escrituras Sagradas e nas palavras de Jesus.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesus estava em Jerusalém para a festa da Páscoa. Muitos creram nele porque viram os milagres que ele fez. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mas Jesus não confiava neles, pois conhecia todas as pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ele não precisava de que alguém lhe falasse a respeito delas. Ele mesmo sabia o que estava na mente delas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Havia entre os fariseus um homem chamado Nicodemos. Ele era um dos líderes do povo judeu. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Uma noite Nicodemos foi até Jesus e disse: —Mestre, nós sabemos que o senhor foi enviado por Deus para nos ensinar. Ninguém pode fazer os milagres que o senhor faz a não ser que Deus esteja com ele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus respondeu: —Digo-lhe a verdade: Se uma pessoa não nascer de novo, ela não pode fazer parte do reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemos disse: —Mas se um homem já é velho, como pode ele nascer de novo? Ele não pode entrar outra vez no ventre de sua mãe. Portanto, como pode nascer pela segunda vez? ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus respondeu: —Digo-lhe a verdade: Se uma pessoa não nascer da água e do Espírito, ela não pode entrar no reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","O corpo de uma pessoa nasce de pais humanos. Mas a vida espiritual nasce do Espírito. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Não se admire por eu lhe dizer: “Você tem de nascer de novo”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","O vento sopra onde quer. Você ouve o soprar do vento, mas não sabe nem de onde vem nem para onde vai. O mesmo acontece com todo aquele que nasce do Espírito. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemos perguntou: —Como isso pode ser possível? ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus disse: —Você é um líder importante do povo de Israel e não compreende estas coisas? ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Digo-lhe a verdade: Nós falamos do que sabemos e testemunhamos o que vimos. Mas vocês não aceitam o nosso testemunho. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Falei a vocês a respeito de coisas da terra, mas vocês não acreditam. Como então vão acreditar se eu lhes falar a respeito de coisas do céu? ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","A única pessoa que já subiu ao céu é aquela que desceu do céu: o Filho do Homem. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moisés levantou a serpente no deserto. Dessa mesma maneira o Filho do Homem também tem de ser levantado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","E ele tem de ser levantado para que todo o que nele crê possa ter a vida eterna. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pois Deus amou o mundo de tal maneira que deu o seu Filho único, para que todo o que nele crê não se perca, mas tenha a vida eterna. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Deus não enviou o seu Filho ao mundo para condenar o mundo, mas para salvar o mundo por meio dele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Quem acredita no Filho de Deus não é condenado. Quem não acredita no Filho de Deus já foi julgado e condenado, porque não acredita no Filho único de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Todos são julgados por este fato: A luz já veio ao mundo, mas os homens não amaram a luz. Amaram a escuridão porque faziam o mal. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Toda a pessoa que faz o mal odeia a luz. Ela não virá para a luz porque a luz mostrará todo o mal que essa pessoa tem feito. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mas quem pratica a verdade vem para a luz. Então a luz mostrará que as coisas que ele fez foram feitas por intermédio de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Depois disto, Jesus e os seus discípulos foram para a região da Judéia. Jesus ficou ali com os seus discípulos batizando as pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","João também estava batizando em Enom, perto de Salim, porque ali havia muita água. E as pessoas vinham e eram batizadas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Isto aconteceu antes de João ter sido preso.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Alguns dos discípulos de João tiveram uma discussão com um judeu a respeito das purificações religiosas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","E eles foram falar com João e disseram: —Mestre, aquele que estava com você no outro lado do rio Jordão, do qual você tem testemunhado, está batizando. E todos vão indo ao encontro dele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","João disse: —Um homem só pode receber o que Deus lhe dá. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Vocês próprios me ouviram dizer: Eu não sou o Cristo. Eu sou somente aquele que Deus mandou para lhe preparar o caminho. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A noiva só pertence ao noivo. O amigo que ajuda o noivo está esperando por ele. Ele quer ouvir a sua voz e, quando a ouve, se alegra. Essa é a alegria que eu agora sinto. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ele deve se tornar cada vez mais importante e eu, cada vez menos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","—Aquele que vem de cima é superior a todos. Aquele que é da terra é terrestre e fala daquilo que é da terra. Mas aquele que vem do céu é superior a todos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ele fala daquilo que viu e ouviu, mas ninguém aceita o que ele diz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Quem aceita o que ele diz dá prova de que Deus é verdadeiro. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Aquele que Deus enviou declara o que Deus diz, porque Deus lhe dá todo o seu Espírito. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","O Pai ama o Filho e lhe deu poder sobre todas as coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Quem crê no Filho tem a vida eterna. Mas quem não obedece ao Filho nunca terá essa vida. A ira de Deus permanece sobre ele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesus soube que os fariseus tinham ouvido falar que ele estava fazendo e batizando mais discípulos do que João. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(De fato quem batizava eram os seus discípulos e não Jesus.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Então ele saiu da Judéia e voltou para a Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Para ir para a Galiléia, Jesus tinha de atravessar Samaria. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chegou então a uma vila chamada Sicar, perto do terreno que Jacó tinha dado ao seu filho José. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Era ali que o poço de Jacó estava situado. Por volta do meio-dia, Jesus, cansado da viagem, sentou-se à beira do poço. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Uma mulher samaritana veio tirar água do poço e Jesus disse: —Por favor, dê-me um pouco de água. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Isto aconteceu quando os discípulos de Jesus tinham ido comprar comida na vila.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A mulher samaritana disse: —Como me pede água, se você é judeu e eu sou samaritana? (Os judeus não se dão bem com os samaritanos.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus respondeu: —Você não sabe o que Deus dá, nem quem é aquele que lhe pede água. Se soubesse, você teria me pedido e eu teria lhe dado água viva. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A mulher disse: —Senhor, onde é que vai buscar essa água viva? O poço é fundo e você não tem nada com que tirar a água. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Por acaso você é melhor que o nosso pai Jacó? Foi ele quem nos deu este poço. Ele próprio bebeu dele, assim como seus filhos e também seus rebanhos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus respondeu: —Toda a pessoa que bebe desta água, voltará a ter sede. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mas aquele que beber da água que eu dou nunca mais terá sede. A água que eu dou se tornará numa fonte de água viva dentro dele. Ela lhe dará a vida eterna. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","A mulher disse a Jesus: —Senhor, dê-me dessa água para que eu não tenha mais sede. E assim não terei que voltar aqui para tirar mais água. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus lhe disse: —Vá chamar o seu marido e volte aqui. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","A mulher respondeu: —Mas eu não tenho nenhum marido. Jesus disse: —Você tem razão quando diz que não tem nenhum marido. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Realmente você já teve cinco, mas o homem com quem está vivendo agora não é seu marido. Você diz a verdade. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","A mulher disse: —Senhor, vejo que é um profeta. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Os nossos pais adoraram a Deus neste monte. Mas vocês, judeus, dizem que é em Jerusalém que se deve adorar a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus disse: —Senhora, acredite no que lhe digo. Está chegando a hora em que vocês não terão de estar nem em Jerusalém nem neste monte para adorarem ao Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Vocês, samaritanos, adoram o que não conhecem. Nós, judeus, adoramos o que conhecemos. A salvação vem a todos por meio dos judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mas está chegando a hora, e de fato já chegou, em que os verdadeiros adoradores vão adorar ao Pai de modo espiritual e verdadeiro. São esses os adoradores que o Pai procura. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Deus é espírito. Os que adoram a Deus têm de adorar em espírito e em verdade. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A mulher disse: —Eu sei que o Messias virá. (Messias é aquele que se chama “Cristo”.) —Quando ele vier, vai nos explicar tudo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Então Jesus disse: —É ele quem fala com você agora. Sou eu mesmo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Naquele momento os seus discípulos chegaram da vila. Eles ficaram admirados por verem Jesus falando com uma mulher. Mas ninguém perguntou: “O que você quer?” ou “Por que você está falando com ela?” ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Então a mulher deixou a sua jarra de água e voltou para a vila. E dizia ao povo: ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Venham ver um homem que me disse tudo que eu tenho feito. Será que ele é o Cristo? ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Então o povo saiu da vila e foi ver a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Enquanto a mulher tinha ido para a vila, os discípulos de Jesus diziam: —Mestre, coma alguma coisa! ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mas Jesus respondeu: —Eu tenho uma comida para comer que vocês não conhecem. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Então os discípulos perguntaram uns aos outros: —Será que alguém lhe trouxe comida? ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus disse: —A minha comida é fazer a vontade daquele que me enviou. A minha comida é acabar o trabalho que ele me deu para fazer. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ao plantarem vocês costumam dizer: Daqui a quatro meses poderemos fazer a colheita. Mas eu digo: Abram os olhos e olhem para os campos. Vejam que eles já estão prontos para a colheita. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Agora mesmo, aquele que está colhendo já está sendo pago. Ele está colhendo para a vida eterna. E assim, tanto aquele que planta como aquele que colhe se alegram juntos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Pois neste caso é verdadeiro o que dizem: É uma pessoa que planta e outra a que colhe. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Eu mandei vocês colherem o que não plantaram. Outros fizeram o trabalho, e vocês recebem o benefício deste trabalho. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Muitos dos samaritanos naquela vila creram em Jesus porque a mulher lhes disse: “Ele me disse tudo o que eu fiz”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","E, quando os samaritanos foram encontrar Jesus, pediram-lhe que ficasse com eles. E ele ficou lá dois dias. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Muitos mais creram em Jesus por causa do que ele lhes disse. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Eles disseram para a mulher: —Agora cremos em Jesus não pelo que você nos disse, mas porque nós mesmos o ouvimos. Sabemos que ele é realmente o Salvador do mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Dois dias depois, Jesus partiu dali e foi para a Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Jesus tinha dito antes que nenhum profeta é respeitado na sua própria terra.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Quando Jesus chegou à Galiléia, os galileus o receberam bem, porque tinham visto tudo o que ele tinha feito na festa da Páscoa, em Jerusalém. Eles também tinham estado lá. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesus voltou para Caná da Galiléia onde tinha transformado a água em vinho. Um dos oficiais do rei vivia em Cafarnaum e seu filho estava doente. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Quando o oficial ouviu dizer que Jesus tinha voltado da Judéia para a Galiléia, ele foi ao seu encontro e pediu-lhe que fosse até Cafarnaum para curar seu filho. O filho dele estava morrendo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus lhe disse: —Se vocês não virem sinais e obras maravilhosas, de modo nenhum vão acreditar em mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","O oficial disse: —Senhor, venha depressa, antes que meu filho morra. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus respondeu: —Volte para casa. Seu filho viverá. O homem acreditou na palavra de Jesus e foi para casa. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Quando ia a caminho, os seus criados foram ao seu encontro e disseram: —O seu filho está bem. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ele então perguntou: —A que horas ele começou a melhorar? Eles responderam: —Ontem, por volta da uma hora, a febre desapareceu. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","O pai reconheceu que tinha sido naquela hora que Jesus tinha dito: “Seu filho viverá”. Então o homem e todas as pessoas da sua casa creram em Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Este foi o segundo milagre que Jesus fez depois de ir da Judéia para a Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Depois disso, Jesus foi para Jerusalém por causa de uma festa dos judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Em Jerusalém, perto do Portão das Ovelhas, há um tanque rodeado por cinco pavilhões. Na língua dos judeus o tanque é chamado Betezata. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Muitos doentes estavam deitados nestes pavilhões: cegos, aleijados e paralíticos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Havia um homem deitado ali, que estava doente há trinta e oito anos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus, vendo este homem e sabendo que ele estava doente há muito tempo, perguntou-lhe: —Você quer ser curado? ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ele respondeu: —Senhor, não tenho ninguém que me ajude a entrar no tanque quando a água é agitada. Enquanto eu estou tentando entrar, outro doente entra antes de mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Então Jesus disse: —Levante-se, pegue sua esteira, e ande. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","No mesmo instante, o homem ficou curado, pegou sua esteira, e começou a andar. Isto aconteceu no sábado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Então os judeus disseram ao homem que tinha sido curado: —Hoje é sábado, e nossa lei não permite que você carregue a esteira. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ele respondeu: —O homem que me curou disse que eu pegasse minha esteira e andasse. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Os judeus perguntaram: —Quem foi o homem que mandou você carregar sua esteira? ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mas ele não sabia quem o tinha curado, pois havia muita gente naquele lugar e Jesus já tinha desaparecido. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mais tarde Jesus o encontrou no templo, e disse: —Agora você está curado. Não peque mais para que não lhe aconteça algo pior. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Então o homem saiu dali e disse aos judeus que tinha sido Jesus quem o tinha curado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Daí em diante os judeus começaram a perseguir Jesus, porque ele fazia estas coisas no sábado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mas Jesus lhes disse: —Meu Pai nunca pára de trabalhar e eu também trabalho. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Por causa disso, os judeus procuravam ainda mais matar a Jesus, porque ele não só desobedecia à lei do sábado, como também dizia que Deus era seu Pai, fazendo-se igual a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mas Jesus declarou: —Digo a verdade a vocês: O Filho nada pode fazer por si próprio; ele só faz o que vê o Pai fazer, porque tudo que o Pai faz o Filho também faz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","O Pai ama o Filho e lhe mostra tudo que faz. O Pai ainda vai mostrar ao Filho obras maiores do que estas para o Filho fazer. Então vocês vão se admirar. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Assim como o Pai levanta os mortos e lhes dá vida, assim também o Filho dá vida a quem ele quiser. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Além disso, o Pai não julga a ninguém, mas deu ao Filho todo o julgamento. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Deus fez isto, para que todos honrem o Filho assim como honram o Pai. Quem não honra o Filho, também não honra o Pai que o enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","—Digo a verdade a vocês: Quem ouve o que eu digo e acredita naquele que me enviou, tem a vida eterna e não será julgado; ele já passou da morte para a vida. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","—Digo a verdade a vocês: A hora está chegando, e já chegou, em que os mortos ouvirão a voz do Filho de Deus. Aqueles que a ouvirem terão a vida eterna. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Pois assim como o Pai é a fonte da vida, da mesma maneira ele fez o Filho a fonte da vida. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","O Pai deu ao Filho o poder de julgar a todos, porque este Filho é o Filho do Homem. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Não se admirem disso, porque está chegando a hora em que todos os mortos ouvirão a sua voz ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","e sairão dos túmulos. Aqueles que fizeram o bem, vão ressuscitar para a vida eterna. Mas aqueles que fizeram o mal, vão ressuscitar para ser condenados. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Eu não posso fazer nada por minha própria autoridade. Assim como eu ouço, eu julgo. O meu julgamento é justo, porque não quero agradar a mim mesmo, mas agradar aquele que me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Se eu falar para as pessoas a respeito de mim mesmo, esse meu testemunho não é verdadeiro. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Outro é que fala a meu respeito e eu sei que o seu testemunho é verdadeiro. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","—Vocês enviaram homens a João e ele testemunhou sobre a verdade. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Eu não preciso que um homem testemunhe a meu respeito. Porém, digo a vocês estas coisas para que vocês possam ser salvos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","João era como uma lâmpada que ardia e dava luz e vocês, durante algum tempo, estavam contentes com a sua luz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mas eu tenho um testemunho maior do que o de João. As obras que eu faço, que meu Pai me deu para fazer, testemunham a meu respeito. Elas mostram que o Pai me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","O próprio Pai que me enviou testemunhou a meu respeito, mas vocês não o têm visto nem ouvido a sua voz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","O ensino do Pai não está nos seus corações porque vocês não acreditam naquele que o Pai enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Vocês estudam as Escrituras com muita atenção porque pensam que elas dão a vocês a vida eterna. E são as próprias Escrituras que testemunham a meu respeito. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mas vocês não querem vir a mim para que possam ter vida. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","—Eu procuro agradar a Deus e não preciso da glória que vem dos homens. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mas eu conheço a vocês e sei que não têm amor a Deus no coração. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Eu vim em nome do meu Pai, e vocês não me aceitam. Se outro vier em seu próprio nome, vocês vão aceitá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Como é que vocês podem crer, se gostam de receber glórias uns dos outros, e não procuram as glórias que vêm do único Deus? ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Não pensem que eu vou acusar a vocês diante do meu Pai; quem acusa é Moisés, em quem vocês confiam. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Se realmente acreditassem em Moisés, também acreditariam em mim, porque Moisés escreveu a meu respeito. ");
INSERT INTO por_WBTC_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mas, se vocês não acreditam no que Moisés escreveu, como podem acreditar naquilo que eu digo? ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Depois disto, Jesus atravessou o lago da Galiléia (ou lago de Tiberíades). ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Uma grande multidão o seguia porque tinha visto os milagres que ele fazia quando curava os doentes. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus subiu para um monte e ali se sentou com os seus discípulos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Estava próxima a festa da Páscoa dos judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus, então, olhou ao redor dele e, vendo a multidão que se aproximava, disse a Filipe: —Onde podemos comprar pão para toda esta gente? ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Mas Jesus perguntou isto para provar a Filipe; porque ele já sabia o que ia fazer.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipe respondeu: —Duzentas moedas de prata não seriam suficientes para comprar um pedaço de pão para cada pessoa. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Outro discípulo que lá estava, André, irmão de Simão Pedro, disse: ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Está aqui um rapaz com cinco pães de cevada e dois peixinhos. Mas o que é isso para tanta gente? ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus disse: —Digam a todos que se sentem. (Aquele lugar tinha muita grama.) E os homens, mais ou menos cinco mil, se sentaram. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Então Jesus pegou os pães, agradeceu a Deus, e os deu a todos que estavam sentados. Fez o mesmo com os peixes, dando a todos quanto queriam. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Todos ficaram satisfeitos. Quando acabaram de comer, Jesus disse aos seus discípulos: —Recolham todos os pedaços que sobraram para que nada se estrague. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Então eles recolheram os pedaços que tinham sobrado. Quando as pessoas começaram a comer, tinham apenas cinco pães de cevada. Mas os discípulos encheram doze cestos com as sobras. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Quando a multidão viu o milagre que Jesus tinha feito, começou a dizer: —Com certeza este é o Profeta que devia vir ao mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sabendo Jesus que a multidão estava com a idéia de pegá-lo à força para fazê-lo rei, voltou sozinho para o monte. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Ao anoitecer, os discípulos de Jesus desceram ao lago. Como já era noite e Jesus ainda não tinha chegado, eles decidiram entrar no barco e partir sozinhos para Cafarnaum. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Um vento muito forte começou a soprar e as ondas começaram a se agitar. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Eles já tinham remado cerca de cinco ou seis quilômetros quando viram a Jesus caminhando sobre as águas e se aproximando do barco. Os discípulos ficaram com medo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mas Jesus disse: —Sou eu, não tenham medo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ao ouvirem a Jesus, de bom grado os discípulos o receberam a bordo, e logo o barco chegou ao seu destino. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","No dia seguinte, as pessoas que tinham ficado do outro lado do lago, perceberam que somente um barco tinha estado lá. Eles sabiam que Jesus não tinha ido com os discípulos, pois eles tinham partido sozinhos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Alguns barcos de Tiberíades chegaram perto do lugar onde a multidão tinha comido depois de Jesus ter dado graças. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Quando as pessoas descobriram que nem Jesus nem seus discípulos estavam mais lá, entraram nos barcos e foram para Cafarnaum à procura de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Quando encontraram a Jesus no outro lado do lago perguntaram: —Mestre, quando foi que o senhor chegou aqui? ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus respondeu: —Digo a verdade a vocês: Vocês não estão me procurando porque viram os milagres que eu fiz. Vocês só andam atrás de mim porque comeram pão e ficaram satisfeitos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","A comida deste mundo se estraga e apodrece. Por isso, não trabalhem por este tipo de comida, mas trabalhem pela comida que é sempre boa e que lhes dá a vida eterna. O Filho do Homem, em quem Deus Pai impôs o seu selo de aprovação, lhes dará essa comida. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Perguntaram-lhe então: —Quais são as coisas que Deus quer que façamos? ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus respondeu: —Este é o trabalho que Deus quer que vocês façam: Que creiam naquele que ele enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Então eles disseram: —Nós gostaríamos de ver o senhor fazer um milagre para que possamos acreditar. O que vai fazer? ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Os nossos pais comeram o maná no deserto. Assim como está escrito nas Escrituras Sagradas: “Deus lhes deu pão do céu para comer”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus disse: —Digo a verdade a vocês: Não foi Moisés quem lhes deu o pão do céu, mas é meu Pai que lhes dá o verdadeiro pão do céu. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","O pão que vem de Deus é aquele que desce do céu e dá vida ao mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Disseram-lhe então: —Senhor, dê-nos sempre desse pão. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus disse: —Eu sou o pão que dá vida. Quem vem a mim nunca mais terá fome. Quem crê em mim nunca mais terá sede. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mas como lhes disse, vocês já me viram e ainda não acreditam. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Todo aquele que o Pai me dá virá a mim e eu nunca rejeitarei aquele que vier a mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Pois eu desci do céu para fazer a vontade daquele que me enviou e não para fazer a minha vontade. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Esta é a vontade daquele que me enviou: Que eu não perca nenhum daqueles que ele me deu, mas que eu os ressuscite no último dia. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Aquele que vê o Filho e crê nele tem a vida eterna e eu vou ressuscitá-lo no último dia. É esta a vontade de meu Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Então os judeus começaram a murmurar contra Jesus, porque ele tinha dito: “Eu sou o pão que desceu do céu”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Os judeus diziam: —Ele não é Jesus, o filho de José? Nós não conhecemos o seu pai e a sua mãe? Como então ele diz que desceu do céu? ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus respondeu: —Não murmurem uns com os outros! ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Foi o Pai quem me enviou. Ninguém pode vir a mim se o Pai não o trouxer; e eu o ressuscitarei no último dia. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Os profetas escreveram: “Deus vai ensinar a todos”. Todo o que ouve o Pai e aprende o que ele diz, vem a mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nunca ninguém viu o Pai a não ser aquele que veio do Pai. Só ele viu o Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","—Digo a verdade a vocês: Aquele que crê em mim tem a vida eterna. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Eu sou o pão que dá vida. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Os seus pais comeram o maná no deserto e, no entanto, morreram. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mas este é o pão que desce do céu e quem comer dele nunca morrerá. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Eu sou o pão vivo que desceu do céu e quem comer deste pão viverá para sempre. Este pão é o meu corpo, e eu darei o meu corpo para que o mundo possa ter vida. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Então os judeus começaram a discutir entre eles: —Como pode este homem nos dar para comer o seu próprio corpo? ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus disse: —Digo a verdade a vocês: Vocês têm que comer o corpo do Filho do Homem e têm que beber o seu sangue. Se não fizerem isto vocês não terão vida dentro de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Quem come o meu corpo e bebe o meu sangue tem a vida eterna e eu o ressuscitarei no último dia. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","O meu corpo é verdadeira comida e o meu sangue é verdadeira bebida. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Quem comer o meu corpo e beber o meu sangue permanece em mim e eu nele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","O Pai me enviou. O Pai vive e eu vivo por causa do Pai. Assim, quem comer de mim por mim também viverá. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Eu não sou como o pão que os vossos pais comeram. Eles comeram esse pão e mesmo assim morreram. Eu sou o pão que desceu do céu e quem comer deste pão viverá para sempre. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesus disse tudo isto enquanto ensinava na sinagoga de Cafarnaum. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Os discípulos de Jesus ouviram isto e muitos deles disseram: —Estas palavras são muito duras. Quem é que pode aceitá-las? ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesus sabia que os seus discípulos não tinham gostado do que ele tinha dito e que se queixavam uns aos outros. Então disse: —Vocês não gostaram do que eu disse? ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","E se virem o Filho do Homem voltar para o lugar de onde ele veio? ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","É o Espírito que dá vida; o corpo não vale nada. As palavras que eu disse são espírito e portanto dão vida. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mas alguns de vocês não acreditam. (Pois desde o princípio Jesus sabia quais eram os que não acreditavam e quem iria se voltar contra ele.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","E ele prosseguiu: —Foi por isso que eu disse: Aquele que o Pai não deixar vir a mim, não poderá vir. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Depois de Jesus dizer isto, muitos daqueles que o seguiam o abandonaram. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Então Jesus perguntou aos doze discípulos: —Vocês também querem ir embora? ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simão Pedro respondeu a Jesus: —Senhor, para onde podemos ir? O senhor é que tem as palavras que dão a vida eterna. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nós confiamos no senhor e sabemos que é o Santo de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Então Jesus respondeu: —Eu escolhi a todos vocês, aos doze, e um de vocês é diabo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesus estava falando de Judas, filho de Simão Iscariotes. Judas era um dos doze, mas iria trair a Jesus mais tarde. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Depois disto, Jesus andava pela Galiléia. Ele não queria mais andar pela Judéia porque os judeus procuravam matá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Estava próxima uma das festas dos judeus—a Festa dos Tabernáculos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Os irmãos de Jesus disseram-lhe: —Você deve sair daqui e ir para a Judéia. Assim os seus discípulos que estão lá poderão ver os milagres que você faz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Quem quer ser bem conhecido não esconde o que faz. Se faz estas coisas, mostre-se ao mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Nem mesmo os irmãos de Jesus acreditavam nele.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus então respondeu: —Ainda não chegou a hora oportuna para eu ir, mas para vocês qualquer hora serve. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","O mundo não pode odiar a vocês, mas me odeia porque eu falo do mal que ele faz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Portanto, vão vocês para a festa. Eu não vou agora pois ainda não chegou o momento certo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Depois de dizer isto, Jesus ficou na Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Os irmãos de Jesus foram para a festa. Depois de eles terem ido, Jesus também foi, mas não deixou que ninguém o visse. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Durante a festa, os judeus procuravam a Jesus. Eles perguntavam para as pessoas: —Onde está aquele homem? ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Havia muitas pessoas na festa, e várias falavam em voz baixa a respeito de Jesus. Algumas diziam: —Ele é um bom homem! Outras diziam: —Não, ele está enganando o povo! ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Porém, ninguém tinha coragem de falar dele abertamente por terem medo dos judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","No decorrer da festa, Jesus foi ao templo e começou a ensinar a todos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Os judeus, admirados, diziam: —Como é que este homem sabe tanto se ele nunca estudou? ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus respondeu: —As coisas que ensino não vêm de mim. O que eu ensino vem daquele que me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Se alguém quiser fazer a vontade de Deus, saberá que o meu ensino vem dele e não de mim mesmo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Quem ensina as suas próprias idéias quer glórias para si mesmo. Porém, aquele que procura a glória de quem o enviou fala a verdade e não engana ninguém. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés não deu a lei a vocês? Porém nenhum de vocês obedece a essa lei. Por que vocês querem me matar? ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","O povo respondeu: —Você tem um demônio. Quem é que quer matá-lo? ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus respondeu: —Fiz um milagre e vocês ficaram admirados. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés deu a lei da circuncisão a vocês. (Aliás, nem foi Moisés que deu essa lei. A lei da circuncisão já existia desde os tempos dos nossos pais.) No entanto vocês circuncidam os meninos no sábado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Se um menino pode ser circuncidado no sábado para se cumprir a lei de Moisés, por que então vocês se irritaram comigo por eu ter curado um homem por completo no sábado? ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Não julguem só pelas aparências. Sejam justos e julguem por aquilo que é reto. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Então algumas pessoas que viviam em Jerusalém disseram: —Não é este o homem que eles queriam matar? ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Vejam só! Ele está aí falando abertamente a todos e ninguém lhe faz nada! Será que os líderes do povo sabem que este é realmente o Cristo? ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nós sabemos de onde este homem vem mas, quando vier o Cristo, ninguém saberá de onde ele virá. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesus, que ainda estava ensinando no templo, exclamou em voz alta: —Vocês me conhecem e sabem de onde eu venho. Porém eu não vim por minha própria vontade. Eu fui enviado por aquele que é verdadeiro e que vocês não conhecem. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mas eu o conheço. Eu venho dele e foi ele quem me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Quando Jesus disse isto, o povo tentou prendê-lo, mas ninguém conseguiu sequer tocar nele, pois o momento certo ainda não tinha chegado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","E várias pessoas da multidão que acreditavam nele diziam: —Quando o Cristo vier, será que ele vai fazer mais milagres do que este homem? ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Os fariseus ouviram a multidão falando de Cristo. Então eles e os líderes dos sacerdotes decidiram mandar os guardas do templo prenderem a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesus disse: —Estarei com vocês um pouco mais. Depois voltarei para aquele que me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Vocês vão me procurar, mas não vão me encontrar. E para onde eu vou vocês não podem ir. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Os judeus perguntavam uns para os outros: —Onde é que ele vai que nós não poderemos ir ao seu encontro? Será que ele vai viver com os judeus que vivem nas cidades gregas? Vai ensinar os gregos? ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","O que ele quer dizer com as palavras: “Vocês vão me procurar, mas não vão me encontrar” e “Para onde eu vou vocês não podem ir”? ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","No último e mais importante dia da festa, Jesus disse a todos: —Se alguém tem sede, venha a mim e beba. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","E rios de água viva correrão do coração de quem crer em mim. Assim dizem as Escrituras Sagradas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesus estava falando do Espírito Santo. O Espírito ainda não tinha sido dado porque Jesus ainda não tinha sido glorificado. Mais tarde, aqueles que cressem em Jesus iriam receber esse Espírito. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Uma grande multidão ouvia a Jesus. Muitas pessoas diziam: —Com certeza ele é o Profeta. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Outras diziam: —Ele é o Cristo. Outras ainda diziam: —O Cristo não virá da Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","As Escrituras dizem que o Cristo virá de Belém, da terra e da família de Davi. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","E elas não concordavam umas com as outras. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Outras ainda queriam prender a Jesus, mas ninguém tocava nele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Quando os guardas do templo voltaram, os líderes dos sacerdotes e os fariseus perguntaram: —Por que vocês não prenderam Jesus? ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Os guardas do templo responderam: —As coisas que ele diz são superiores às palavras de qualquer outro homem. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Os fariseus disseram: —Então Jesus também enganou a vocês! ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Por acaso algum dos líderes dos fariseus crê nele? ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Essas pessoas que não sabem nada da lei estão debaixo da maldição de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemos, aquele que tinha ido visitar a Jesus de noite, disse: ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Não podemos julgar um homem antes de sabermos o que ele fez. Nossa lei não permite isso. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Os fariseus então responderam: —Você também vem da Galiléia? Estude as Escrituras! Você verá que nenhum profeta vem da Galiléia. ");
INSERT INTO por_WBTC_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","E todos foram embora para suas casas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesus foi para o Monte das Oliveiras. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","No outro dia, de manhã cedo, Jesus voltou outra vez para o templo e todo o povo se ajuntou perto dele. Jesus então se sentou e começou a ensinar. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Os professores da lei e os fariseus levaram a Jesus uma mulher que tinha sido apanhada cometendo adultério e puseram a mulher no meio de todos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Depois disseram a Jesus: —Mestre, esta mulher foi apanhada no ato de adultério. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","A lei de Moisés manda apedrejar todas as mulheres que façam isso. Que diz o senhor? ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Eles fizeram esta pergunta para comprometer a Jesus, para ver se ele dizia alguma coisa que pudesse ser usada contra ele. Jesus abaixou-se e começou a escrever na terra com o dedo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Eles perguntaram de novo. Então Jesus se levantou e disse: —Quem aqui pode dizer que nunca pecou? Quem não tem nenhum pecado pode atirar a primeira pedra. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Depois voltou a se abaixar e a escrever na terra. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Um por um, todos os que o ouviram foram embora, começando pelos mais velhos. Jesus ficou sozinho com a mulher, que continuava diante dele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesus levantou-se outra vez e perguntou: —Senhora, foram todos embora? Ninguém condenou você? ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ela respondeu: —Ninguém, senhor. Então Jesus disse: —Eu também não vou condenar você. Pode ir embora, mas não volte a pecar. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mais tarde, Jesus voltou a falar com o povo. Ele disse: —Eu sou a Luz do mundo. Quem me seguir nunca ficará na escuridão, mas terá luz, a luz que dá a vida. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mas os fariseus disseram-lhe: —Está testemunhando sobre você mesmo e isso não tem nenhum valor. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus respondeu: —Mesmo que eu testemunhe de mim mesmo, o que eu digo é válido. Eu sei de onde eu vim e para onde eu vou. Mas vocês não sabem de onde eu vim ou para onde eu vou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Vocês me julgam do mesmo jeito que julgam qualquer homem. Eu mesmo não julgo ninguém. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mas se eu julgo, o meu julgamento é verdadeiro porque eu não estou julgando sozinho. O Pai que me enviou está comigo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","A lei de vocês diz que quando duas testemunhas concordam uma com a outra, o testemunho delas é válido. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Eu, que falo de mim mesmo, sou uma testemunha. O Pai que me enviou é a outra. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Eles perguntaram: —Onde está o seu pai? Jesus respondeu: —Vocês não conhecem a mim nem ao meu Pai. Se me conhecessem, também conheceriam ao meu Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus disse estas coisas quando estava ensinando no templo. Ele estava perto das caixas de ofertas e ninguém o prendeu. O momento determinado para ele ainda não tinha chegado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Outra vez Jesus disse ao povo: —Eu vou deixar vocês. Vocês vão me procurar, mas morrerão em seus próprios pecados. Vocês não podem ir para onde eu vou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Então os judeus perguntaram: —Será que ele vai se matar e por isso diz: “Vocês não podem vir para onde eu vou”? ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mas Jesus disse: —Vocês são daqui de baixo, mas eu sou lá de cima. Vocês pertencem a este mundo, mas eu não pertenço a este mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Por isso é que eu disse que vocês morrerão em seus próprios pecados. Se vocês não acreditarem que EU SOU, certamente morrerão em seus próprios pecados. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Eles perguntaram: —Então quem é você? Jesus respondeu: —Eu sou o que eu venho dizendo que sou desde o princípio. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tenho muito o que dizer e julgar a respeito de vocês, mas só digo o que ouvi daquele que me enviou. Ele fala a verdade. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Eles não compreenderam que Jesus estava falando do Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Então Jesus disse: —Quando vocês levantarem o Filho do Homem, então saberão que EU SOU e que nada faço por mim mesmo. Eu só digo aquilo que o Pai me ensinou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Aquele que me enviou está comigo. Ele nunca me abandonou porque eu sempre faço o que lhe agrada. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Muitas pessoas creram em Jesus quando ele disse estas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Então Jesus disse aos judeus que acreditavam nele: —Se vocês continuarem a obedecer as minhas palavras, serão verdadeiramente meus discípulos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Então conhecerão a verdade; e a verdade libertará a vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Os judeus responderam: —Nós somos descendentes de Abraão e nunca fomos escravos de ninguém. Por que você diz que nós seremos libertados? ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus respondeu: —Digo a verdade a vocês: Todos os que pecam são escravos do pecado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ora, um escravo não pertence à família para sempre, mas um filho pertence. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Portanto, se o Filho libertar vocês, então serão realmente livres. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Eu sei que vocês são filhos de Abraão. Mas sei também que vocês querem me matar porque não aceitam o que eu digo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Eu falo das coisas que meu Pai me mostrou, mas vocês fazem o que ouviram do pai de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Eles responderam: —Nosso pai é Abraão. Jesus então disse: —Se vocês fossem realmente filhos de Abraão, fariam o que ele fez. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Entretanto vocês querem me matar, a mim, um homem que tem trazido a vocês a verdade que ouvi de Deus. Abraão nunca fez uma coisa dessas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Vocês fazem as obras do pai de vocês. Mas os judeus diziam: —Nós não somos filhos ilegítimos! Nós temos um pai que é Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus disse: —Se Deus fosse realmente o Pai de vocês, vocês me amariam. Eu vim de Deus e agora estou aqui. Não vim porque quis, mas porque Deus me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Vocês não compreendem o que eu ensino porque não conseguem aceitar o que eu digo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","O pai de vocês é o diabo. Vocês pertencem a ele e querem fazer a sua vontade. Ele foi um assassino desde o princípio. Ele é contra a verdade e nele não há verdade nenhuma. Quando mente só diz o que lhe é natural, pois é um mentiroso. Ele é o pai das mentiras. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Eu, porém, digo a verdade, mas vocês não acreditam em mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Pode algum de vocês me acusar de um pecado qualquer? Se digo a verdade, por que não acreditam em mim? ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Aquele que é de Deus, aceita o que Deus diz. Mas vocês não aceitam o que Deus diz porque não pertencem a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Os judeus responderam: —Temos ou não razão quando dizemos que você é um samaritano e que tem um demônio? ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus respondeu: —Eu não tenho nenhum demônio. Eu honro ao meu Pai, mas vocês me desonram. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Eu não estou tentando obter glória para mim mesmo. Há quem esteja tentando obter essa glória para mim. E ele é o Juiz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Digo a verdade a vocês: Aquele que obedecer aos meus ensinamentos nunca morrerá. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Os judeus disseram a Jesus: —Agora temos certeza de que você tem um demônio! Até mesmo Abraão e os profetas morreram, mas você diz: “Aquele que obedecer aos meus ensinamentos nunca morrerá”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Você pensa que é superior ao nosso pai Abraão? Abraão morreu e os profetas também morreram. Quem você pensa que é? ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus respondeu: —Se eu der glória a mim mesmo, essa glória não vale nada. Quem dá glória é o meu Pai. Vocês dizem que ele é o Deus de vocês, ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","mas a verdade é que vocês não o conhecem. Eu o conheço. Se eu dissesse que não o conheço, então seria um mentiroso como vocês são. Mas eu o conheço e obedeço a tudo o que ele diz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraão, o pai de vocês, queria muito ver o dia da minha vinda. Ele viu e ficou muito contente. ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Os judeus disseram: —O que você está dizendo? Você nunca viu Abraão! Não tem nem cinqüenta anos! ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus respondeu: —Digo a verdade a vocês: Antes de Abraão nascer, EU SOU! ");
INSERT INTO por_WBTC_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Então os judeus pegaram pedras para atirar em Jesus, mas ele se escondeu e depois saiu do templo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesus estava caminhando quando viu um homem que tinha nascido cego. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Os seus discípulos perguntaram: —Mestre, quem é que pecou para que este homem nascesse cego? Ele ou os pais dele? ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus respondeu: —Nem ele nem os pais dele. Ele nasceu cego para que o poder de Deus seja mostrado nele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Enquanto é dia, devemos continuar fazendo o trabalho daquele que me enviou. A noite está chegando. E ninguém pode trabalhar à noite. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Enquanto eu estiver no mundo, eu sou a Luz do mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Depois de Jesus ter dito isto, ele cuspiu no chão e fez um pouco de lama com a saliva. Depois passou a lama nos olhos do cego ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","e disse: —Vá se lavar no tanque de Siloé. (Siloé quer dizer “Enviado”.) O homem foi ao tanque, lavou-se e voltou vendo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Os vizinhos do homem e aqueles que costumavam vê-lo pedindo esmolas diziam: —Olhem! Não é este o homem que está sempre sentado pedindo esmolas? ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Alguns diziam: —É ele mesmo! Mas outros diziam: —Não, só se parece com ele. O homem então disse: —Sou eu mesmo! ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Eles perguntaram: —O que aconteceu? Como é que você agora pode ver? ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ele respondeu: —Um homem chamado Jesus fez lama, passou nos meus olhos e disse para eu ir me lavar no tanque de Siloé. Eu fui, lavei-me e agora estou vendo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Eles perguntaram: —Onde está esse homem? Ele então respondeu: —Não sei. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","O povo então levou o homem que tinha sido cego aos fariseus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","(Foi num sábado que Jesus tinha feito lama e curado os olhos do cego.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Assim os fariseus perguntaram ao homem: —Como você agora pode ver? Ele respondeu: —Um homem passou lama nos meus olhos, eu me lavei e agora estou vendo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Alguns dos fariseus estavam dizendo: —Esse homem não é de Deus, pois ele não respeita o sábado. Outros diziam: —Mas um homem pecador não faz milagres como este. E não concordavam uns com os outros. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Voltaram então a perguntar ao homem: —O que você diz dele? Afinal, foram os seus olhos que ele abriu! O homem respondeu: —Ele é um profeta. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Os judeus não acreditaram que ele tivesse nascido cego e que agora podia ver. Mandaram, então, chamar os pais dele ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","e lhes perguntaram: —Este homem é o filho de vocês? Vocês dizem que ele nasceu cego. Como é que agora ele está vendo? ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Os pais dele responderam: —Sabemos que ele é nosso filho e que nasceu cego. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mas não sabemos nem como ele agora vê e nem quem o curou. Perguntem a ele; ele tem idade suficiente para responder sozinho. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Os pais disseram isto porque tinham medo dos judeus. Os judeus tinham decidido expulsar da sinagoga qualquer pessoa que dissesse que Jesus era o Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Foi por isso que os seus pais disseram: “Perguntem a ele; ele tem idade suficiente para responder sozinho”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Pela segunda vez, os judeus mandaram chamar o homem que tinha sido cego. Eles disseram: —Você deve dizer a verdade e dar glória a Deus. Nós sabemos que esse homem é pecador. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ele respondeu: —Não sei se ele é pecador. Só sei de uma coisa: Eu era cego e agora posso ver. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Os judeus perguntaram: —O que foi que ele fez? Como é que ele curou a você? ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ele respondeu: —Já lhes disse uma vez, mas vocês não me escutaram. Por que vocês querem ouvir de novo? Vocês também querem ser discípulos dele? ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Então eles o ofenderam, dizendo: —Você é discípulo dele! Nós somos discípulos de Moisés. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sabemos que Deus falou a Moisés, mas sobre este homem, não sabemos nem de onde ele veio! ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","O homem disse: —É estranho que vocês não saibam de onde ele veio e, contudo, ele curou os meus olhos! ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nós todos sabemos que Deus não ouve os pecadores, mas ouve aqueles que o adoram e lhe obedecem. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nunca se ouviu falar de alguém que tivesse curado uma pessoa que tenha nascido cega. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Se ele não fosse de Deus, não poderia ter feito nada. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Eles responderam: —Você nasceu cheio de pecado e agora quer nos ensinar? E o expulsaram. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Quando Jesus ouviu que tinham expulsado o homem, foi ao seu encontro e disse: —Você crê no Filho do Homem? ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ele perguntou: —Senhor, quem é o Filho do Homem? Diga-me para que eu possa crer nele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus disse: —Você já o viu. O Filho do Homem é quem está falando com você agora. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","O homem respondeu: —Sim, Senhor, eu creio! E então se ajoelhou e adorou a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus disse: —Eu vim para este mundo para que o mundo possa ser julgado. Eu vim para que os cegos possam ver e para que os que vêem fiquem cegos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Alguns dos fariseus que estavam perto de Jesus, ao ouvirem isto, perguntaram: —Você quer dizer que nós somos cegos? ");
INSERT INTO por_WBTC_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Então Jesus lhes disse: —Se vocês fossem realmente cegos não seriam culpados de pecado. Mas vocês dizem que vêem e, por isso são culpados. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesus disse: —Digo a verdade a vocês: Se um homem não entra num curral de ovelhas pela porta, mas sobe pelo outro lado, é ladrão e assaltante. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Quem entra pela porta é o pastor das ovelhas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","O vigia abre a porta para ele e as ovelhas ouvem a sua voz. Ele chama as suas ovelhas pelo nome e as leva para fora. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Quando sai com todas as ovelhas, ele vai à frente delas e as guia. Elas o seguem porque conhecem a sua voz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","As ovelhas, porém, nunca seguirão um estranho. Elas fugirão dele porque não conhecem a sua voz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus disse isto para a multidão, mas as pessoas não compreenderam o que ele queria dizer. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Então Jesus lhes disse outra vez: —Digo a verdade a vocês: Eu sou a Porta das ovelhas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Todos os que vieram antes de mim eram ladrões e assaltantes e as ovelhas não os ouviram. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Eu sou a Porta e quem entrar por mim será salvo. Poderá entrar e sair e achar pasto. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","O ladrão vem para roubar, matar e destruir. Eu, porém, venho para dar vida e vida em abundância. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","—Eu sou o bom Pastor e o bom Pastor dá sua vida pelas ovelhas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","O empregado que é pago para guardar as ovelhas é diferente do pastor. As ovelhas são do pastor e não do empregado. Quando o empregado vê o lobo, foge e deixa as ovelhas sozinhas. Então o lobo vem, ataca e espalha as ovelhas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ele foge porque só é pago para tomar conta das ovelhas e não se importa realmente com elas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","—Eu sou o bom Pastor. Conheço as minhas ovelhas, assim como o meu Pai me conhece. E as minhas ovelhas me conhecem, assim como eu conheço o Pai. Eu dou a minha vida pelas ovelhas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tenho outras ovelhas que não são deste rebanho. Eu ainda tenho de trazê-las para este rebanho. Elas ouvirão a minha voz e haverá um só rebanho, um só pastor. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","O Pai me ama porque eu dou a minha vida para poder recebê-la de novo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ninguém pode me tirar a vida. Eu dou minha própria vida por minha livre vontade. Tenho o direito de dar minha vida, assim como tenho o direito de recebê-la de novo. Foi isto que o meu Pai me mandou fazer. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mais uma vez os judeus não concordavam entre eles por causa das palavras de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Muitos deles diziam: —Ele tem um demônio! Está louco! Por que o ouvimos? ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mas outros diziam: —Um homem louco, com um demônio, não diz as coisas que ele diz. Pode um demônio abrir os olhos dos cegos? ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Chegou a época da Festa da Dedicação em Jerusalém. Era inverno. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus estava no templo, no Alpendre de Salomão. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Os judeus se ajuntaram em volta dele e perguntaram: —Quanto tempo ainda vai nos deixar na dúvida a seu respeito? Se você é o Cristo, diga claramente. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus respondeu: —Já disse, mas vocês não acreditaram. Eu faço milagres em nome de meu Pai, e esses milagres mostram quem eu sou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Vocês não acreditam porque não são das minhas ovelhas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","As minhas ovelhas ouvem a minha voz. Eu as conheço e elas me seguem. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Eu lhes dou a vida eterna e elas nunca morrerão. Ninguém poderá roubá-las da minha mão. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Meu Pai, que me deu as ovelhas, é mais forte do que todos. Ninguém pode roubá-las da mão dele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","O Pai e eu somos um. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","De novo os judeus pegaram pedras para matar a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Porém Jesus lhes disse: —Eu tenho feito muitas boas obras por parte do Pai e vocês têm visto todas elas. Por qual delas é que vocês querem me matar? ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Os judeus responderam: —Nós não o matamos por nenhuma boa obra que você fez. Mas você diz coisas que são contra Deus. Você é somente um homem, mas se faz Deus. É por isso que queremos matá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus respondeu: —Na lei de vocês está escrito que Deus disse: “Vocês são deuses”! ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","O que a Escritura diz é verdade e a Escritura chamou de deuses as pessoas que receberam a mensagem de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Eu sou aquele que Deus escolheu e enviou ao mundo. Sendo assim, por que é que vocês dizem que estou falando contra Deus quando digo: Sou Filho de Deus? ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Não acreditem em mim se eu não fizer as obras que meu Pai faz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mas se eu fizer o que o meu Pai faz, mesmo que não acreditem em mim, acreditem no que eu faço. Então vocês saberão e compreenderão que o Pai está em mim e eu nele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Os judeus novamente tentaram prender Jesus, mas ele escapou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Depois Jesus voltou para o outro lado do rio Jordão, para o lugar onde João estava batizando no princípio e ficou ali. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Muitas pessoas chegavam perto dele e diziam: —João nunca fez nenhum milagre, mas tudo o que ele disse a respeito deste homem é verdade. ");
INSERT INTO por_WBTC_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","E ali muitas pessoas creram nele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Um homem chamado Lázaro estava doente. Ele vivia na cidade de Betânia, onde também viviam Maria e a sua irmã Marta. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Maria foi a mulher que, mais tarde, derramou perfume sobre o Senhor e enxugou-lhe os pés com os seus cabelos. Lázaro, o homem que estava doente, era irmão de Maria.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Então Maria e Marta mandaram um recado a Jesus dizendo: —Senhor, aquele a quem o senhor ama está doente. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Quando Jesus ouviu isso, disse: —Esta doença não é para a morte, mas para a glória de Deus; para que o Filho de Deus seja glorificado por ela. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus amava Marta, sua irmã Maria e Lázaro. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ainda assim, permaneceu por mais dois dias no lugar onde estava, mesmo sabendo que Lázaro estava doente. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Depois disso, Jesus disse aos seus discípulos: —Vamos voltar para a Judéia. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Os discípulos perguntaram: —Mas Mestre, ainda há pouco tempo atrás os judeus queriam apedrejá-lo, e agora o senhor quer voltar para lá? ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus respondeu: —Não há doze horas de luz no dia? Se alguém anda de dia não tropeça porque pode ver com a luz que brilha neste mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mas se alguém anda de noite, tropeça, pois não há luz para que ele possa ver. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Depois de Jesus ter dito isto, acrescentou: —O nosso amigo Lázaro adormeceu. Eu vou lá para acordá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Os discípulos disseram: —Senhor, se ele está dormindo, quer dizer que vai ficar bom. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesus queria dizer que Lázaro tinha morrido, mas os discípulos pensaram que ele estivesse falando de sono. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Então Jesus lhes disse claramente: —Lázaro morreu, ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","e eu estou contente por não ter estado lá, pois assim vocês podem crer. Vamos até lá para vê-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Então Tomé (o que se chama Dídimo) disse aos outros discípulos: —Vamos com o Mestre, assim poderemos morrer com ele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Quando Jesus chegou em Betânia, soube que Lázaro já tinha sido enterrado há quatro dias. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betânia ficava cerca de três quilômetros de Jerusalém ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","e muitos dos judeus tinham ido para lá confortar Marta e Maria pela morte de seu irmão. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Quando Marta ouviu dizer que Jesus estava chegando, foi ao seu encontro, mas Maria ficou em casa, sentada. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta disse a Jesus: —Senhor, se tivesse estado aqui o meu irmão não teria morrido. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mas eu sei que, mesmo agora, Deus dará tudo o que lhe pedir. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus disse a ela: —O seu irmão se levantará e viverá outra vez. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta respondeu: —Eu sei que ele se levantará e viverá outra vez na ressurreição, no último dia. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus lhe disse: —Eu sou a ressurreição e a vida. Quem crê em mim, mesmo que esteja morto, viverá; ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","e todo aquele que vive e crê em mim nunca morrerá. Você crê nisto? ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta respondeu: —Sim, Senhor! Eu creio que o senhor é o Cristo, o Filho de Deus, que estava para vir ao mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Depois de ter dito isto, Marta voltou, chamou sua irmã Maria e lhe disse em particular: —O Mestre está aqui e está chamando você. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ao ouvir isto, Maria levantou-se rapidamente e foi ao encontro de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Jesus ainda nem tinha entrado na cidade; ele tinha ficado no lugar onde Marta o havia encontrado.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Os judeus que estavam na casa de Maria para confortá-la, viram-na sair às pressas e a seguiram. Eles pensaram que ela estava indo ao túmulo para chorar. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria, porém, seguia para o lugar onde Jesus estava. Quando ela o viu, caiu aos pés dele e disse: —Senhor, se tivesse estado aqui o meu irmão não teria morrido. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Quando Jesus viu que Maria estava chorando e que os judeus que tinham vindo atrás dela também choravam, sentiu grande tristeza no coração e ficou muito perturbado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Então Jesus perguntou: —Onde foi que vocês o enterraram? Eles responderam: —Senhor, venha e verá. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","E Jesus chorou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Então os judeus disseram: —Vejam o quanto ele o amava! ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mas outros disseram: —Se Jesus abriu os olhos do cego, por que não impediu a morte de Lázaro? ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","De novo Jesus sentiu uma grande tristeza no coração e foi para o túmulo. Era uma gruta fechada por uma grande pedra. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus disse: —Tirem a pedra. Marta, a irmã do morto, então disse: —Senhor, já cheira mal, pois já faz quatro dias que ele morreu. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus disse a ela: —Eu não lhe disse que, se você cresse, veria a glória de Deus? ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Então tiraram a pedra da entrada do túmulo. Jesus olhou para o céu e disse: —Pai, obrigado pelo senhor ter me ouvido. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Eu sei que o senhor me ouve sempre, mas digo isto para que as pessoas que estão à minha volta possam crer que o senhor me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Depois de Jesus ter dito isto, chamou em voz alta: —Lázaro, venha para fora! ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","O homem que tinha morrido veio para fora. Ele tinha as mãos e os pés envolvidos em faixas de pano e seu rosto também estava coberto por um lenço. Jesus disse ao povo: —Tirem os panos dele e deixem-no ir. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Muitos dos judeus que tinham ido com Maria e visto o que Jesus tinha feito, creram nele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Outros, porém, foram contar aos fariseus o que Jesus tinha feito. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Então os líderes dos sacerdotes e os fariseus convocaram uma reunião do Conselho Superior dos judeus e perguntaram: —Que devemos fazer? Este homem está fazendo muitos milagres. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Se deixarmos que ele continue fazendo estas coisas, todos vão crer nele e os romanos virão e destruirão nosso templo e nossa nação. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Porém, estava entre eles o sumo sacerdote daquele ano, Caifás, e ele disse: —Vocês não entendem nada. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Vocês não percebem que é muito melhor que um homem morra pelo povo ao invés de ser destruída toda uma nação? ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás não disse isso de si mesmo. Sendo o sumo sacerdote daquele ano, ele estava profetizando que Jesus havia de morrer pela nação dos judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","E não só por ela, mas também por todos os filhos de Deus espalhados pelo mundo. E todos seriam um só povo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","A partir daquele dia, eles começaram a planejar uma maneira de matar Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Por já não poder mais andar livremente entre os judeus, Jesus saiu dali. Ele foi para uma cidade chamada Efraim, perto do deserto, e ali ficou com os seus discípulos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Estava próxima a festa da Páscoa dos judeus. Muitas pessoas do campo foram para a cidade de Jerusalém, antes da festa, para se purificarem. ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","O povo procurava Jesus. No templo perguntavam uns aos outros: —Será que ele virá para a festa? O que vocês acham? ");
INSERT INTO por_WBTC_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mas os líderes dos sacerdotes e os fariseus tinham dado ordens que, se alguém soubesse onde Jesus estava, devia informá-los para que eles pudessem prendê-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seis dias antes da festa da Páscoa Jesus foi para Betânia, onde Lázaro morava. (Lázaro era o homem que Jesus tinha ressuscitado.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ali lhe fizeram um jantar e Marta servia a comida. Lázaro era um dos que estavam com ele à mesa. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria, então, trouxe cerca de meio litro de um perfume muito caro, feito de nardo puro. Ela o derramou nos pés de Jesus e, depois, os enxugou com os seus cabelos. O aroma do perfume se espalhou por toda a casa. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iscariotes—um dos doze discípulos de Jesus—e que mais tarde iria traí-lo, disse: ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Este perfume vale 300 moedas de prata. Por que ele não foi vendido e não foi dado o dinheiro aos pobres? ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","(Judas não disse isto porque se importava realmente com os pobres, mas porque era ladrão. Era ele quem guardava a caixa de dinheiro e muitas vezes roubava o que era colocado lá.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesus respondeu: —Deixem-na! Ela fez bem em guardar este perfume para hoje—dia da preparação para o meu enterro. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Vocês terão sempre os pobres com vocês mas, a mim, nem sempre terão. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Muitos judeus descobriram que Jesus estava em Betânia e então foram para lá. Eles não queriam somente ver Jesus, mas também queriam ver Lázaro, a quem Jesus tinha ressuscitado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Os líderes dos sacerdotes estavam planejando matar também a Lázaro ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","pois, por causa dele, muitos judeus estavam se afastando de seus líderes e crendo em Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","No dia seguinte, quando a grande multidão que tinha ido para a festa ouviu dizer que Jesus estava indo para Jerusalém, ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","pegaram ramos de palmeiras e foram ao seu encontro, clamando: “‘Glória a Deus! Bendito é aquele que vem em nome do Senhor!’ Deus abençoe o Rei de Israel!” ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus encontrou um jumentinho e montou nele, assim como dizem as Escrituras: ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Não tenha medo, cidade de Sião! Aí vem o seu Rei, montado num jumentinho”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","(Os discípulos de Jesus não entenderam estas coisas no princípio, mas depois que Jesus subiu para a sua glória, eles se lembraram que aquelas coisas tinham sido escritas a respeito dele e que o povo as tinha feito a ele.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Quando Jesus ressuscitou Lázaro e lhe disse para sair do túmulo, várias pessoas tinham estado lá. E agora elas estavam dizendo a todos o que Jesus tinha feito. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","(Foi por isso que uma multidão foi ao encontro de Jesus, pois eles tinham ouvido que foi ele quem tinha feito este milagre.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Então os fariseus diziam entre si: —Vejam, nossos planos não estão funcionando. Olhem como todos estão indo atrás dele! ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Muitas pessoas tinham ido a Jerusalém para adorar a Deus durante a festa da Páscoa. Entre eles havia alguns gregos ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","e eles foram até Filipe (o que era de Betsaida, na Galiléia), e pediram: —Senhor, queremos ver a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipe foi dizer a André e os dois foram falar com Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus respondeu a eles: —Chegou a hora do Filho do Homem ser glorificado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Digo a verdade a vocês: Um grão de trigo tem de cair no chão e morrer para produzir muitos frutos. Mas, se não morrer, continuará sendo uma única semente. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Quem ama a sua própria vida vai perdê-la. Mas quem odeia a sua vida neste mundo, vai conservá-la para a vida eterna. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Aquele que é meu servo, tem de me seguir; e onde quer que eu esteja, meu servo também estará. E todo aquele que me serve, será honrado por meu Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","—Eu agora estou muito perturbado. Devo dizer: Pai, salve-me desta hora de sofrimento? Não, pois foi com este propósito que eu vim para esta hora. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pai, glorificado seja o seu nome! Então uma voz veio do céu: —Já o glorifiquei e vou glorificá-lo de novo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Uma multidão estava ali e ouviu a voz. Alguns diziam que era trovoada. Outros, porém, diziam: —Um anjo falou com ele! ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Em resposta, Jesus disse: —Esta voz veio por causa de vocês, e não por minha causa. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Chegou o momento de este mundo ser julgado; agora o príncipe deste mundo será expulso. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Eu serei levantado da terra e, quando isto acontecer, atrairei todas as pessoas para mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Jesus disse isto para mostrar de que maneira iria morrer.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Então a multidão disse a ele: —Nossa lei diz que o Cristo viverá para sempre. Por que você diz que o Filho do Homem tem de ser levantado? Quem é o Filho do Homem? ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus então disse: —A luz ainda estará com vocês por um pouco mais de tempo. Andem enquanto vocês têm esta luz para que a escuridão não os apanhe, pois quem anda na escuridão não vê para onde vai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Enquanto vocês têm a Luz, acreditem nela, pois assim vocês se tornarão filhos da luz. Depois de dizer isto, Jesus saiu e foi para um lugar onde o povo não podia encontrá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Apesar de Jesus ter feito todos estes milagres diante dos judeus, eles ainda não criam nele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Isto aconteceu para mostrar o significado total daquilo que o profeta Isaías tinha dito: “Senhor, quem acreditou naquilo que dissemos? Quem viu o poder do Senhor?” ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","É por isso que as pessoas não podiam acreditar; porque Isaías também disse: ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Deus cegou os olhos deles e fechou as suas mentes. Deus fez isto para que eles não vejam com os olhos e nem entendam com a mente e não se voltem para mim para que eu possa curá-los”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías disse isto porque viu a glória de Jesus e falou sobre ele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Contudo, até mesmo muitos entre os líderes dos judeus creram em Jesus. Mas, por causa dos fariseus, ninguém declarava sua fé abertamente, pois não queriam ser expulsos da sinagoga. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Eles amavam mais a glória que vem dos homens do que a glória que vem de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Então Jesus disse em voz alta: —Quem crê em mim está, na realidade, crendo naquele que me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Quem me vê está, na realidade, vendo aquele que me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Eu vim para o mundo como uma luz. Vim para que todo aquele que crê em mim não fique na escuridão. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Não sou eu quem vai julgar aquele que ouve as minhas palavras e não as obedece, pois não vim para julgar o mundo. Eu vim para salvar o mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Há um juiz para quem se recusa a acreditar em mim e não aceita as minhas palavras: As palavras que eu tenho dito vão julgá-lo no último dia! ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Aquilo que eu tenho ensinado não veio de mim mesmo. O Pai, que me enviou, me ordenou o que eu deveria dizer e ensinar. ");
INSERT INTO por_WBTC_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","E eu sei que o que o Pai ordena dá a vida eterna. Portanto, tudo o que eu digo é o que o Pai me mandou dizer. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Estava próxima a festa da Páscoa. Jesus sabia que tinha chegado a hora de ele ir embora deste mundo e voltar para o Pai. Ele tinha sempre amado aqueles no mundo, que eram dele, e mostrou a eles que seu amor era completo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesus e os seus discípulos estavam jantando. O diabo já tinha convencido Judas Iscariotes a trair Jesus. (Judas era filho de Simão.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus sabia que ele tinha vindo de Deus e que ia voltar para Deus. Ele também sabia que o Pai tinha lhe dado poder sobre todas as coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Por isso, durante a ceia, Jesus se levantou, tirou a sua túnica e, pegando uma toalha, amarrou-a na cintura. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Depois, derramando água numa bacia, começou a lavar os pés dos seus discípulos e a enxugá-los com a toalha que tinha na cintura. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Quando chegou a vez de Simão Pedro, ele disse a Jesus: —Senhor, vai lavar os meus pés? ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus respondeu: —Você agora não entende o que eu estou fazendo, mas vai entender mais tarde. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro disse: —Não! O senhor nunca vai lavar os meus pés. Jesus então respondeu: —Se eu não lavar os seus pés, você não terá mais nada a ver comigo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simão Pedro pediu: —Senhor, então não lave somente os pés, mas também as mãos e a cabeça! ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus disse: —Aquele que toma banho só precisa lavar de novo os pés, pois todo o resto do corpo está limpo. Vocês estão limpos, mas nem todos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Jesus sabia quem era aquele que iria traí-lo. Foi por isso que ele disse: “Nem todos vocês estão limpos”.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Acabando de lavar os pés deles, Jesus vestiu sua túnica, voltou para a mesa e perguntou a todos: —Vocês entenderam o que eu acabei de fazer a vocês? ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Vocês me chamam de Mestre e Senhor e têm razão, pois eu o sou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Se eu, que sou Senhor e Mestre de vocês, lavei os seus pés, vocês também devem lavar os pés uns dos outros. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Eu fiz isto para servir de exemplo a vocês. Assim, como eu fiz a vocês, também façam uns aos outros. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Digo a verdade a vocês: Nem o servo é superior ao seu senhor, nem o mensageiro é superior a quem o enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Se vocês entenderem estas coisas, serão felizes se as praticarem. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Não estou falando de todos vocês, pois eu conheço aqueles que escolhi. Porém, o que a Escritura disse tem de acontecer: “O homem que comeu da minha comida se levantou contra mim”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Eu estou dizendo isto a vocês agora, antes de acontecer, para que, quando isto acontecer, acreditem que EU SOU. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Digo a verdade a vocês: Aquele que recebe a quem eu enviar, também me recebe. Aquele que me recebe, também recebe a quem me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Depois de ter dito estas coisas, Jesus ficou bastante perturbado e falou a todos: —Digo a verdade a vocês: Um de vocês vai me trair. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Os discípulos começaram a olhar uns para os outros, sem saber de quem Jesus estava falando. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Um dos discípulos, aquele a quem Jesus amava, estava reclinado sobre o peito de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simão Pedro fez sinais para que ele perguntasse a Jesus de quem era que ele estava falando. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","O discípulo chegou um pouco mais perto de Jesus e perguntou: —Quem é? ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus respondeu: —Vou molhar um pedaço de pão no prato e vou dar para aquele que vai me trair. Jesus, então, molhou um pedaço de pão em seu prato e o deu a Judas Iscariotes, filho de Simão. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Assim que Judas pegou o pedaço de pão, Satanás entrou nele. Então Jesus lhe disse: —Faça depressa o que você pretende fazer! ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nenhum dos que estavam à mesa entendeu porque Jesus tinha dito isto a Judas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Como era Judas que guardava a caixa de dinheiro, alguns dos discípulos pensaram que Jesus estava dizendo para ele ir comprar as coisas de que iriam precisar para a festa. Outros pensaram que Jesus tinha dito que fosse dar alguma coisa aos pobres. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas aceitou o pão que Jesus deu e saiu imediatamente. Era noite. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Depois de Judas ter saído, Jesus disse: —Agora o Filho do Homem será glorificado, e Deus será glorificado por meio dele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Se Deus é glorificado por intermédio dele, então Deus também glorificará o Filho do Homem nele mesmo. E Deus vai lhe dar essa glória muito em breve. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Queridos filhos! Eu não vou ficar com vocês por muito mais tempo. Vocês vão me procurar mas, como eu já disse aos líderes dos judeus e repito agora a vocês: Vocês não podem ir para onde eu vou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Eu lhes dou um novo mandamento: Amem uns aos outros. Vocês devem amar uns aos outros da mesma forma como eu amei a vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nisto todas as pessoas saberão que vocês são meus discípulos, se vocês amarem uns aos outros. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simão Pedro perguntou a Jesus: —Para onde é que vai, Senhor? Jesus lhe respondeu: —Para onde eu vou, você não pode me seguir agora. Mais tarde, porém, você me seguirá. ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro disse a Jesus: —Por que não posso segui-lo agora, Senhor? Estou pronto até a morrer pelo senhor! ");
INSERT INTO por_WBTC_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus respondeu: —Está mesmo? Você daria realmente sua vida por mim? Digo-lhe a verdade: Antes que o galo cante, por três vezes você dirá que não me conhece. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesus disse: —Não se abalem! Continuem confiando em Deus e continuem confiando em mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na casa de meu Pai há muitos cômodos. Se não fosse assim, eu já lhes teria dito, pois vou preparar um lugar para vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Depois de ir e preparar lugar para vocês, eu voltarei. Então levarei vocês comigo, para que possam estar onde eu estiver. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Vocês sabem como chegar ao lugar para onde eu vou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomé então disse a Jesus: —Senhor, não sabemos para onde vai! Como podemos saber o caminho? ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus respondeu a ele: —Eu sou o Caminho, a Verdade e a Vida. Ninguém pode chegar até o Pai se não for por mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Se vocês realmente me conhecessem, então conheceriam também meu Pai. De agora em diante, vocês o conhecem, pois já o viram. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipe disse-lhe: —Senhor, mostre-nos o Pai e ficaremos satisfeitos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus respondeu: —Já faz tanto tempo que estou com vocês e você ainda não me conhece, Filipe? Quem me viu, viu também o Pai. Como você pode dizer: “Mostre-nos o Pai?” ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Você acredita que eu estou no Pai e que o Pai está em mim? As palavras que eu digo a vocês não vêm de mim. O Pai que vive em mim está fazendo suas próprias obras. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Acreditem em mim quando digo que eu estou no Pai e que o Pai está em mim. Se não for assim, acreditem, pelo menos, por causa das obras que faço. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Digo a verdade a vocês: Aquele que acredita em mim fará as mesmas coisas que eu faço. E fará coisas ainda maiores do que estas, porque eu estou indo para o meu Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","E tudo o que vocês pedirem em meu nome eu farei, para que o Pai receba glória por meio do Filho. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Qualquer coisa que vocês me pedirem em meu nome, eu farei. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","—Se vocês me amam, cumprirão os meus mandamentos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pedirei ao Pai e ele lhes dará um outro Auxiliador, para que esteja com vocês para sempre. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","O Auxiliador é o Espírito da verdade. O mundo não pode aceitá-lo porque não o vê nem o conhece. Mas vocês o conhecem, pois ele vive com vocês e estará em vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","—Não os deixarei órfãos; eu voltarei para vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Daqui a pouco o mundo não me verá mais, mas vocês me verão, porque eu vivo e vocês também viverão. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nesse dia, vocês saberão que eu estou em meu Pai; e saberão também que vocês estão em mim e que eu estou em vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Aquele que conhece os meus mandamentos e os obedece, é esse que me ama. Aquele que me ama será amado por meu Pai e eu também o amarei e me revelarei a ele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Então Judas (não o Judas Iscariotes) disse: —Mas Senhor, por que vai se revelar a nós e não ao mundo? ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus respondeu: —Se alguém me ama, obedecerá ao meu ensino. Meu Pai o amará, nós viremos até ele e viveremos com ele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Quem não me ama não obedece aos meus ensinamentos. E os ensinamentos que vocês estão ouvindo nem são de fato meus, mas do Pai que me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","—Eu lhes tenho dito todas estas coisas enquanto estou com vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mas o Auxiliador, que é o Espírito Santo e que o Pai vai mandar em meu nome, vai ensinar tudo a vocês. Ele vai lembrar a vocês tudo o que eu já lhes disse. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","—Eu lhes deixo a paz. A minha própria paz eu dou a vocês. Eu não lhes dou essa paz como o mundo a dá. Portanto seus corações não devem ficar nem perturbados nem com medo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Vocês me ouviram dizer que eu estou indo embora e que vou voltar para vocês. Se vocês me amassem, estariam felizes por eu estar indo para o Pai, pois ele é maior que eu. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Eu disse isto a vocês agora, antes de acontecer, para que, quando acontecer, vocês acreditem. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Não falarei com vocês por muito mais tempo, pois o príncipe deste mundo está chegando. Ele não tem poder sobre mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Porém, o mundo tem de saber que eu amo ao Pai e que, por isso, faço exatamente aquilo que ele me diz para fazer. Levantem-se e vamos embora. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","—Eu sou a videira verdadeira e meu Pai é o lavrador. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ele corta todos os galhos que não dão frutos. Mas ele poda e limpa todos os galhos que dão frutos, para que dêem ainda mais. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Vocês já estão limpos por causa dos ensinamentos que eu tenho dado a vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Continuem em mim e eu continuarei em vocês. Assim como o galho não pode dar frutos por si mesmo a não ser que continue na videira, vocês também não podem dar frutos por si mesmos, a não ser que continuem em mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","—Eu sou a videira e vocês são os galhos. Aquele que continuar em mim e eu nele, dará muitos frutos, porque sem mim vocês não podem fazer nada. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Se alguém, porém, não continuar em mim, é como o galho que é jogado fora e seca. As pessoas juntam os galhos secos e os queimam no fogo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","—Se vocês permanecerem em mim e continuarem a obedecer aos meus ensinamentos, pedirão tudo o que quiserem e será dado a vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Vocês devem dar muitos frutos e assim mostrar que são meus discípulos. Isto trará glória ao meu Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Assim como o Pai mostrou o seu amor por mim, eu também mostrei o meu amor por vocês. Continuem no meu amor. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Eu tenho obedecido aos mandamentos de meu Pai e assim continuo em seu amor. Da mesma forma, se vocês obedecerem aos meus mandamentos, continuarão no meu amor. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Digo estas coisas a vocês para que a minha alegria esteja em vocês e para que a alegria de vocês seja completa. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Este é o meu mandamento: Que vocês amem uns aos outros, assim como eu tenho amado a vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","O maior amor que alguém pode demonstrar por seus amigos é dar sua vida por eles. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Vocês são meus amigos se continuarem a fazer aquilo que eu digo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Eu não os chamo mais de servos, pois o servo não sabe o que o seu senhor faz. Agora eu os chamo de amigos, pois tenho dito a vocês tudo o que ouvi de meu Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Vocês não me escolheram; pelo contrário, eu escolhi a vocês. Vocês foram escolhidos para irem e darem frutos. E o meu desejo é que esses frutos durem muito. Então o Pai lhes dará tudo o que vocês pedirem em meu nome. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Este é o meu mandamento: Que vocês amem uns aos outros. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","—Se o mundo odeia a vocês, lembrem-se de que ele odiou primeiro a mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Se vocês pertencessem ao mundo, então o mundo amaria a vocês da mesma forma que ama a todos os que pertencem a ele. Mas vocês não pertencem ao mundo, pois eu os escolhi e os tirei do mundo. Por isso o mundo odeia a vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Lembrem-se do que eu disse a vocês: “O servo não é maior que o seu senhor”. Se perseguiram a mim, também perseguirão a vocês. Se obedeceram aos meus ensinamentos, também obedecerão aos de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Eles vão fazer tudo isto a vocês por minha causa, pois não conhecem aquele que me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Se eu não tivesse vindo e falado com eles, eles não seriam culpados de nenhum pecado. Mas agora eles não têm qualquer desculpa para seus pecados. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Aquele que me odeia também odeia ao meu Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Eu fiz obras entre eles que ninguém jamais fez e, se eu não tivesse feito essas obras, eles não seriam culpados de nenhum pecado. Mas eles viram todas as obras que fiz e, mesmo assim, ainda odeiam a mim e a meu Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Isto, porém, é assim para que aconteça o que está escrito na lei deles: “Eles me odiaram sem nenhum motivo”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","—Eu enviarei a vocês, da parte do Pai, o Auxiliador. Ele é o Espírito da verdade que vem do Pai e, quando ele vier, falará a meu respeito. ");
INSERT INTO por_WBTC_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Vocês também falarão a meu respeito, porque têm estado comigo desde o princípio. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","—Eu digo isto para que vocês não percam a fé. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Vão expulsar a vocês das sinagogas e chegará o tempo em que pessoas matarão a vocês, pensando que com isso eles estarão prestando um serviço a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","E farão estas coisas porque nunca conheceram nem ao Pai e nem a mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Eu digo estas coisas a vocês agora, antes que elas aconteçam, para que, quando elas acontecerem, vocês se lembrem de que eu os avisei. —Eu não disse estas coisas a vocês no princípio porque eu estava com vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mas agora eu estou indo embora para aquele que me enviou, e nenhum de vocês me pergunta: “Para onde o senhor vai?” ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","E porque eu lhes disse estas coisas, os corações de vocês ficaram cheios de tristeza. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mas eu digo a verdade a vocês: É melhor para vocês que eu vá embora, porque se eu não for, o Auxiliador não virá. Mas se eu for, eu o enviarei para vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","E quando o Auxiliador vier, ele vai convencer o mundo do pecado, de como ser justo diante de Deus e também do julgamento. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ele vai convencer do pecado porque eles não acreditam em mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ele vai convencer de como ser justo diante de Deus porque eu estou voltando para o Pai e vocês não me verão mais. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ele também vai convencer do julgamento porque o príncipe deste mundo já foi julgado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","—Ainda tenho muitas coisas para dizer, mas seria demais para vocês agora. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Porém, quando vier o Espírito da verdade, ele guiará a vocês para toda a verdade. Ele não vai falar por si mesmo; ele vai ensinar o que ouviu e vai falar sobre coisas que ainda vão acontecer. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ele me glorificará porque vai receber de mim o que vai falar para vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tudo o que o Pai tem é meu. Por isso é que eu disse que ele vai receber de mim o que vai falar para vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","—Daqui a pouco vocês não vão me ver mais, mas logo depois vocês vão me ver de novo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Alguns dos discípulos comentaram entre si: —O que será que ele quer dizer com isto: “Daqui a pouco vocês não vão me ver mais, mas logo depois vocês vão me ver de novo” e também com: “Estou indo para o Pai”? ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Também se perguntavam: —O que ele quer dizer com: “Daqui a pouco”? Nós não entendemos o que ele está dizendo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus sabia que eles queriam fazer perguntas a respeito disto e, por isso, disse: —Vocês estão se perguntando o que eu quero dizer com: “Daqui a pouco vocês não vão me ver mais, mas logo depois vocês vão me ver de novo”? ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Digo a verdade a vocês: Vocês vão chorar e se lamentar, enquanto o mundo vai estar alegre. Vocês vão estar tristes, mas a tristeza de vocês vai se transformar em alegria. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Quando a mulher está para ter um filho, ela sofre porque sua hora chegou. Mas quando o nenê nasce, ela se esquece do seu sofrimento, pois está feliz por ter trazido um filho ao mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","A mesma coisa acontece com vocês. Vocês estão tristes agora, mas eu vou vê-los de novo e vocês vão ficar cheios de alegria. E essa alegria ninguém vai poder tirar de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","E quando chegar esse dia, vocês não vão me perguntar nada. Digo a verdade a vocês: O meu Pai lhes dará tudo o que vocês pedirem em meu nome. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Até agora vocês não pediram nada em meu nome. Se vocês pedirem, vocês receberão, para que a alegria de vocês seja completa. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","—Eu tenho falado estas coisas a vocês por meio de parábolas, mas vai chegar o tempo em que eu não falarei mais assim. Eu falarei a vocês claramente a respeito do Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Nesse dia vocês vão pedir coisas ao Pai em meu nome e eu lhes digo que não vou precisar pedir ao Pai em favor de vocês, porque ele mesmo os ama. Ele ama a vocês porque vocês me têm amado e têm acreditado que eu vim de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Eu vim do Pai para o mundo. Agora estou deixando o mundo e voltando para o Pai. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Então os discípulos disseram: —Veja, agora o senhor está falando claramente e não com palavras que são difíceis de entender. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Agora nós sabemos que o senhor conhece todas as coisas e que não precisa que ninguém lhe faça qualquer pergunta. Por isso nós acreditamos que o senhor veio de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus replicou: —Então agora vocês acreditam? ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ouçam! Está chegando a hora—e na verdade já chegou—em que vocês serão espalhados, cada um de vocês irá para sua casa e me deixarão sozinho. Porém eu não estou sozinho, pois o meu Pai está comigo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","—Eu digo isto a vocês para que, por meu intermédio, vocês encontrem paz. Vocês sofrem neste mundo, mas sejam corajosos. Eu venci o mundo! ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Depois de ter falado estas coisas, Jesus olhou para o céu e disse: —Pai, chegou a hora! Glorifique ao seu Filho para que o seu Filho possa glorificá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pois o senhor lhe deu poder sobre todos, para que ele pudesse dar a vida eterna para aqueles que o senhor deu a ele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","E a vida eterna é esta: Que eles conheçam o senhor, o único Deus verdadeiro, e a Jesus Cristo, aquele por ele enviado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Eu o glorifiquei na terra e acabei o trabalho que me deu para fazer. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Agora, Pai, glorifique-me em sua presença com a mesma glória que eu tinha com o senhor antes de o mundo ser criado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","—O senhor me deu alguns homens do mundo e eu fiz o senhor conhecido entre eles. Embora eles fossem seus, o senhor os deu a mim e eles têm obedecido a sua palavra. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Agora eles sabem que todas as coisas que o senhor me deu vêm do senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Eu dei a eles o mesmo ensinamento que o senhor me deu e eles aceitaram. Eles realmente sabem que eu vim do senhor e acreditam que o senhor me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Eu estou orando por eles. Não oro pelo mundo, mas por aqueles que o senhor me deu, pois eles são seus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tudo o que eu tenho é seu, e tudo o que o senhor tem é meu; e eu sou glorificado neles. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Agora eu estou indo para onde o senhor está. Eles ainda vão ficar no mundo, mas eu não estarei mais aqui. Pai Santo! Guarde-os pelo poder de seu nome, o nome que o senhor me deu, para que eles sejam um só, assim como nós. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Enquanto eu estava com eles, eu os guardei com o poder do seu nome, nome que o senhor me deu. Eu os protegi e nenhum se perdeu, a não ser o filho da perdição, para que acontecesse o que a Escritura diz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","—Agora eu estou indo para onde o senhor está. Mas eu estou dizendo estas coisas enquanto ainda estou no mundo para que eles possam sentir dentro deles toda minha alegria. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Eu tenho dado a eles o seu ensinamento, mas o mundo os odiou pois eles não pertencem ao mundo assim como eu também não pertenço. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Não estou pedindo que o senhor os tire do mundo, mas que os guarde do maligno. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Eles não pertencem ao mundo, assim como eu também não pertenço ao mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Que o senhor os torne seus por meio da verdade. O seu ensinamento é a verdade. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Eu os enviei para o mundo assim como o senhor me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","A favor deles eu me entrego completamente ao senhor. Faço isso para que, mediante a verdade, eles possam pertencer ao senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","—Eu não estou orando somente por eles, mas também por aqueles que ainda vão acreditar em mim por intermédio do ensino deles, ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","para que todos sejam um só. Pai, oro também para que eles estejam em nós, assim como eu estou no senhor e o senhor está em mim. Que eles sejam um para que o mundo acredite que o senhor me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Eu dei a eles a glória que o senhor me deu para que eles possam ser um, assim como o senhor e eu somos um; ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Eu neles e o senhor em mim, para que eles possam ser completamente unidos. Então o mundo vai entender que o senhor me enviou e que o senhor amou a eles assim como ama a mim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","—Pai, eu quero que aqueles que o senhor me deu estejam comigo onde eu estiver. Eu quero que eles vejam a minha glória, glória que o senhor me deu porque o senhor me amou antes do mundo existir. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pai bondoso! O mundo não conhece o senhor, mas eu o conheço. E aqueles que acreditam em mim, sabem que foi o senhor que me enviou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Eu já mostrei o senhor a eles e ainda vou fazer isso outra vez. Eu vou fazer isso para que eles tenham o mesmo amor que o senhor tem por mim e eu viverei neles. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Quando Jesus acabou de orar, atravessou o vale de Cedrom com os seus discípulos. Eles foram para o outro lado do vale, onde havia um jardim. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","(Judas, o traidor, conhecia aquele lugar, pois Jesus costumava ir ali com seus discípulos.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Então Judas foi para lá se encontrar com ele. Ele estava guiando alguns soldados romanos e um grupo de guardas do templo enviados pelos líderes dos sacerdotes e pelos fariseus. Eles estavam armados e levavam lanternas e tochas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus sabia tudo o que ia acontecer. Por isso, deu alguns passos à frente e perguntou: —Quem vocês estão procurando? ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Eles responderam: —Jesus de Nazaré. Jesus disse: —Sou eu mesmo! (Judas, o traidor, estava ali com eles.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Quando Jesus lhes disse: “Sou eu mesmo”, eles se afastaram e caíram no chão. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Então Jesus lhes perguntou outra vez: —Quem vocês estão procurando? E eles responderam: —Jesus de Nazaré. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus disse a eles: —Já lhes disse que sou eu. Se vocês estão procurando por mim, então deixem estes homens irem embora. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesus falou isto para que acontecesse o que ele tinha dito antes: “Eu não perdi nenhum daqueles que você me deu”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simão Pedro trazia consigo uma espada. Ele a tirou e atacou o criado do sumo sacerdote, cortando-lhe a orelha direita. (O criado se chamava Malco). ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus disse a Pedro: —Guarde a sua espada! Eu tenho que beber do cálice de sofrimento que meu Pai me deu. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Em seguida, os soldados romanos juntamente com o seu comandante e os guardas do templo prenderam a Jesus e o amarraram. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Então, levaram-no primeiro a Anás, sogro de Caifás, que era o sumo sacerdote daquele ano. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","(Caifás foi aquele que disse aos judeus: “É melhor que um homem morra pelo povo”.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simão Pedro e outro discípulo seguiam atrás de Jesus. O outro discípulo conhecia o sumo sacerdote e, por isso, pôde entrar com Jesus no pátio da casa do sumo sacerdote. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro, porém, teve que ficar do lado de fora, perto da porta. Então, o discípulo que era conhecido do sumo sacerdote foi falar com a empregada que tomava conta da porta, e ela deixou Pedro entrar. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Então, aquela que tomava conta da porta perguntou a Pedro: —Você também é um dos discípulos de Jesus, não é? Pedro respondeu: —Não, eu não sou! ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Estava frio e, por causa disso, os empregados e os guardas do templo tinham feito uma fogueira e se aqueciam de pé em volta dela. Pedro estava junto com eles. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","O sumo sacerdote estava fazendo perguntas a Jesus a respeito de seus discípulos e do seu ensino. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus respondeu a ele: —Eu tenho falado publicamente para todas as pessoas. Eu sempre ensinei nas sinagogas e no templo, onde os judeus se reúnem, e nunca disse nada em segredo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Por que você está me fazendo todas estas perguntas? Interrogue as pessoas que me ouviram. Elas sabem muito bem o que eu disse. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Quando Jesus falou isto, um dos guardas que estavam ali lhe deu uma bofetada, e disse: —É assim que se responde ao sumo sacerdote? ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus disse a ele: —Se eu falei alguma coisa errada, diga a todos em que eu errei. Mas, se eu falei bem, por que você me bate? ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anás então mandou que Jesus fosse levado, ainda amarrado, a Caifás, o sumo sacerdote. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simão Pedro ainda estava lá, aquecendo-se perto da fogueira. Então lhe perguntaram: —Você não é um dos discípulos deste homem? Pedro negou e disse: —Não sou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Um dos criados do sumo sacerdote, parente do homem de quem Pedro tinha cortado a orelha, perguntou: —Não foi você que eu vi no jardim com ele? ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","E mais uma vez Pedro negou Jesus. Nesse momento um galo cantou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Depois disto, levaram Jesus da casa de Caifás para o palácio do governador romano. Já era de manhã cedo. Os judeus, porém, não entraram no palácio, pois queriam continuar puros para poderem comer o jantar da Páscoa. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Então, Pilatos foi até lá fora e perguntou-lhes: —De que é que vocês acusam este homem? ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Eles responderam: —Se ele não fosse um criminoso, nós não o teríamos trazido até o senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Então Pilatos disse aos judeus: —Por que vocês não o levam e não o julgam vocês mesmos, de acordo com a lei de vocês? Eles responderam: —Nossa lei não permite matar ninguém. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Isto aconteceu para que se cumprisse o que Jesus tinha dito a respeito da maneira pela qual ele ia morrer.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Então Pilatos entrou novamente no palácio, chamou a Jesus, e perguntou-lhe: —Você é o rei dos judeus? ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus disse: —O senhor está fazendo esta pergunta por si mesmo, ou foram outros que lhe falaram de mim? ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatos respondeu: —Você pensa que eu sou judeu? Pois eu não sou! Foi o seu povo e os líderes dos sacerdotes que trouxeram você até mim. O que foi que você fez? ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus respondeu: —O meu reino não é deste mundo. Se ele fosse deste mundo, os meus servos lutariam para que eu não fosse entregue aos judeus. O meu reino não é deste mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatos disse: —Então você é um Rei? Jesus respondeu: —O senhor está dizendo que eu sou Rei e isso é verdade. Foi para falar sobre a verdade que eu nasci, e foi por causa disso que vim ao mundo. Todos os que estão do lado da verdade ouvem a minha voz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatos perguntou: —O que é a verdade? Depois de dizer isto, ele foi novamente para onde os judeus estavam e lhes disse: —Eu não encontro nenhum motivo para condenar este homem. ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Já que é um costume entre vocês que eu lhes solte um preso na época da Páscoa, vocês querem que eu solte o “Rei dos judeus”? ");
INSERT INTO por_WBTC_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Então eles começaram a gritar, dizendo: —Não, esse não. Solte Barrabás! (Barrabás era um criminoso.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Então Pilatos mandou que levassem a Jesus para ser açoitado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Os soldados fizeram uma coroa de espinhos e a puseram na cabeça de Jesus, e o vestiram com um manto de púrpura. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Depois, chegavam perto dele e diziam: —Viva o rei dos judeus! E davam bofetadas nele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","E, mais uma vez, Pilatos saiu do palácio e disse aos judeus: —Escutem, eu vou trazer a Jesus aqui para fora. Eu quero que vocês saibam que não encontro nenhum motivo para condená-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Então Jesus saiu do palácio usando a coroa de espinhos e vestido com o manto de púrpura. Pilatos disse aos judeus: —Aqui está o homem! ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Quando os líderes dos sacerdotes e os guardas do templo viram a Jesus, começaram a gritar: —Pregue-o na cruz! Pregue-o na cruz! Então Pilatos respondeu: —Vocês que o levem e que o preguem na cruz vocês mesmos, pois eu não encontro nenhum crime nele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Os judeus responderam: —A nossa lei diz que ele deve morrer, pois ele afirma que é o Filho de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","(Quando Pilatos ouviu isto, ficou com mais medo ainda.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilatos entrou para o palácio outra vez e perguntou para Jesus: —De onde você é? Mas Jesus não respondeu nada. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatos então disse: —Você não quer responder? Você não sabe que tenho autoridade tanto para mandar soltá-lo como para mandar crucificá-lo? ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus respondeu: —O senhor só tem autoridade sobre mim porque essa autoridade foi dada por Deus. Por isso, aquele que me entregou ao senhor é mais culpado do que o senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Depois de ouvir isto, Pilatos tentou encontrar um jeito de soltar a Jesus. Os judeus, porém, gritavam: —Se o senhor soltar esse homem, o senhor não é amigo do Imperador! Qualquer um que diz ser rei é inimigo do Imperador! ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ao ouvir o que os judeus diziam, Pilatos levou a Jesus para fora, para um lugar chamado Calçada de Pedra (em aramaico chamava-se “Gabatá”), e ali se sentou no tribunal. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Era por volta de meio-dia da sexta-feira da semana da Páscoa. Pilatos disse aos judeus: —Aqui está o Rei de vocês! ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Os judeus gritavam: —Fora com ele! Fora com ele! Pregue-o na cruz! Pilatos perguntou-lhes: —Vocês querem que eu pregue o seu Rei numa cruz? Os líderes dos sacerdotes responderam: —O único rei que temos é o Imperador. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Então Pilatos entregou a Jesus para ser pregado na cruz e os soldados o levaram. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Carregando a sua própria cruz, Jesus dirigiu-se para um lugar chamado Caveira (que em aramaico chamava-se “Gólgota”.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ali pregaram a Jesus na cruz. E também outros dois homens foram pregados em cruzes com ele, um de cada lado e Jesus no meio. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatos também mandou escrever uma placa que dizia: “Jesus de Nazaré, rei dos judeus”, e mandou colocá-la na cruz. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Muitos judeus puderam ler a placa porque o lugar onde Jesus foi pregado na cruz ficava perto da cidade e porque ela estava escrita em aramaico, latim e grego. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Os líderes dos sacerdotes disseram a Pilatos: —Não escreva: “rei dos judeus”, mas escreva: Este homem disse: “Eu sou rei dos judeus”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatos respondeu: —Aquilo que eu escrevi, escrevi! ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Depois de terem pregado a Jesus na cruz, os soldados pegaram as roupas dele e as dividiram em quatro partes, uma para cada um. Pegaram também sua túnica, mas ela era feita de uma só peça de pano, sem costura. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Então disseram uns aos outros: —Não vamos rasgar a túnica! Vamos tirar a sorte para ver quem fica com ela. Isso aconteceu para que se cumprisse o que dizem as Escrituras: “Dividiram a minha roupa entre si, e tiraram a sorte pela minha túnica”. E os soldados assim o fizeram. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","A mãe de Jesus estava perto da cruz junto com a irmã dela. Também lá estavam Maria, que era a mulher de Clopas, e Maria Madalena. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Quando Jesus viu que sua mãe e o discípulo que ele amava estavam ali, ele disse para sua mãe: —Senhora, aí está o seu filho. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Depois disse ao discípulo: —Aí está a sua mãe. Daquele momento em diante, o discípulo a levou para morar em sua casa. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Depois disto, Jesus percebeu que tudo já estava terminado. Mas, para que acontecesse o que dizem as Escrituras, ele disse: —Tenho sede! ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Havia ali uma vasilha cheia de vinagre de vinho. Os soldados puseram uma esponja numa vara de hissopo, molharam-na no vinagre da vasilha e a levaram até a boca de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Depois que Jesus provou o vinagre, disse: —Está terminado! Então abaixou a cabeça e morreu. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tudo isto aconteceu na sexta-feira. Os judeus não queriam que os corpos ficassem na cruz até o dia seguinte, pois era um sábado muito especial. Pediram então a Pilatos que mandasse quebrar as pernas dos homens e tirar os corpos de lá. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Quando os soldados chegaram, quebraram as pernas do homem que estava de um lado de Jesus. Depois quebraram as pernas do homem que estava do outro lado de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mas, quando chegaram perto de Jesus, viram que ele já estava morto e não quebraram as pernas dele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Um dos soldados, porém, atravessou o lado de Jesus com uma lança, fazendo sair sangue e água. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Quem viu isto acontecer deu testemunho e o seu testemunho é verdadeiro. Ele sabe que fala a verdade para que vocês possam ter fé.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Foi assim para que se cumprisse o que dizem as Escrituras: “Nenhum dos seus ossos será quebrado”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","E também uma outra Escritura diz: “E eles olharão para aquele a quem traspassaram”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mais tarde, um homem de Arimatéia chamado José pediu a Pilatos o corpo de Jesus. (José era um discípulo de Jesus, mas em segredo, porque tinha medo dos judeus.) Pilatos deu permissão a José e ele veio e levou o corpo de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemos, aquele que tinha ido falar com Jesus à noite, também foi com José. Ele tinha levado um bálsamo feito de uma mistura de mirra e aloés que pesava uns trinta quilos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Os dois levaram o corpo de Jesus e o enrolaram em tiras de lençóis de linho perfumadas com o bálsamo. (Era assim que os judeus enterravam os mortos.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Havia um jardim no lugar onde Jesus foi crucificado. Nesse jardim havia um túmulo novo, onde ninguém ainda tinha sido enterrado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Puseram então o corpo de Jesus nesse túmulo, pois ficava perto e também porque os judeus estavam se preparando para o sábado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","No domingo bem cedo, quando ainda estava escuro, Maria Madalena foi ao túmulo e viu que a pedra tinha sido retirada da entrada. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Então Maria correu e foi se encontrar com Simão Pedro e o outro discípulo, aquele que Jesus amava e lhes disse: —Tiraram o Senhor do túmulo e não sabemos onde o puseram! ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ao ouvir isto, Pedro e o outro discípulo saíram e foram para o túmulo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ambos estavam correndo juntos, mas o outro discípulo correu mais depressa do que Pedro e chegou ao túmulo primeiro. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ele se abaixou para olhar para dentro do túmulo e viu as tiras de lençóis de linho no chão, mas não entrou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simão Pedro, que vinha logo atrás, chegou e entrou no túmulo. Ele viu os lençóis de linho, ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","e viu também o lenço que tinha sido enrolado em volta da cabeça de Jesus. O lenço não estava junto com as tiras de lençóis, mas tinha sido dobrado e estava num lugar separado. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Então o outro discípulo, que tinha chegado ao túmulo primeiro, também entrou. Ele viu e creu. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Eles ainda não tinham entendido as Escrituras, segundo as quais Jesus tinha que ressuscitar.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Depois disto, os discípulos foram para casa. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria Madalena, porém, ficou chorando do lado de fora do túmulo. Enquanto chorava, ela se abaixou e olhou para dentro do túmulo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Então, ela viu dois anjos vestidos de branco sentados no lugar onde o corpo de Jesus tinha estado. Um estava no lugar da cabeça e outro no lugar dos pés. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Eles lhe perguntaram: —Por que a senhora está chorando? Ela respondeu: —Tiraram o meu Senhor daqui e eu não sei onde o puseram. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ao dizer isto, ela se virou e viu Jesus ali em pé, mas não sabia que era ele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus lhe disse: —Por que a senhora está chorando? Quem a senhora está procurando? Maria pensou que ele fosse o jardineiro e respondeu: —Se foi o senhor que o tirou daqui, diga-me onde o senhor o colocou e eu irei buscá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus disse a ela: —Maria! Ela então se virou para ele e disse em aramaico: —Raboni!—(que quer dizer “Mestre”). ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus lhe disse: —Não me detenha, pois ainda não fui para o meu Pai. Vá e diga isto aos meus irmãos: “Eu vou subir para aquele que é meu Pai e Pai de vocês; meu Deus e Deus de vocês”. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Então Maria Madalena foi e disse aos discípulos: —Eu vi o Senhor! E contou a eles o que o Senhor tinha dito a ela. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nesse mesmo domingo, ao anoitecer, os discípulos se reuniram. Como tinham medo dos judeus, trancaram as portas. Jesus apareceu no meio deles e disse: —A paz esteja com vocês! ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Depois de ter dito isto, Jesus mostrou a eles as suas mãos e o seu lado. Ao verem o Senhor, os discípulos ficaram muito alegres. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","E Jesus disse de novo: —A paz esteja com vocês! Assim como o Pai me enviou, eu agora também envio vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Depois de ter dito isto, Jesus soprou sobre eles e disse: —Recebam o Espírito Santo. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Se vocês perdoarem os pecados de alguém, esses pecados estão perdoados; porém, se não perdoarem, não estão perdoados. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomé (chamado Dídimo), um dos doze discípulos, não estava com eles quando Jesus lhes apareceu. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Os outros discípulos disseram a Tomé: —Vimos o Senhor! Ele, porém, respondeu: —Enquanto eu não vir as marcas dos pregos em suas mãos, não tocar nelas com o meu dedo e não puser a minha mão no seu lado, eu não acreditarei. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Uma semana depois, os discípulos se reuniram de novo e, desta vez, Tomé também estava com eles. As portas estavam trancadas, mas Jesus apareceu no meio deles e disse: —A paz esteja com vocês! ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Depois disse a Tomé: —Ponha aqui o seu dedo e olhe para as minhas mãos. Estenda também a mão e ponha no meu lado. Não duvide mais, mas acredite. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomé respondeu: —Meu Senhor e meu Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Então Jesus lhe disse: —Você acredita porque me viu? Felizes daqueles que acreditam sem me ver! ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus fez diante dos seus discípulos muitos outros milagres que não estão escritos neste livro. ");
INSERT INTO por_WBTC_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Estes, porém, foram escritos para que vocês acreditem que Jesus é o Cristo, o Filho de Deus, e para que, acreditando, tenham vida pelo seu nome. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Depois disso, Jesus apareceu outra vez aos seus discípulos perto do Mar de Tiberíades. Foi assim: ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Estavam juntos Simão Pedro, Tomé (chamado Dídimo), Natanael (de Caná da Galiléia), os dois filhos de Zebedeu e outros dois discípulos. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simão Pedro disse aos outros: —Vou pescar. Os outros discípulos disseram: —Nós também vamos com você. Então eles foram e entraram no barco, mas naquela noite não pegaram nada. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","De manhã, quando começou a clarear, Jesus estava na praia, mas os discípulos não sabiam que era ele. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesus perguntou a eles: —Amigos, vocês não pescaram nada? E eles responderam: —Não, nada. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Então Jesus disse a eles: —Joguem a rede do lado direito do barco e vocês encontrarão alguma coisa. Eles jogaram a rede e logo depois já não podiam puxá-la para dentro do barco por causa da grande quantidade de peixes. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","O discípulo que Jesus amava disse a Pedro: —É o Senhor! Quando Pedro o ouviu dizer isto, amarrou o roupão à sua volta (pois o tinha tirado) e se jogou na água. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Os outros discípulos continuaram no barco, arrastando a rede cheia de peixes. Eles não estavam muito longe da praia, apenas a uns cem metros. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Quando os discípulos desceram do barco, viram uma fogueira com peixes nas brasas, e pão. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Então Jesus disse: —Tragam alguns dos peixes que vocês acabaram de pescar. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simão Pedro entrou no barco e puxou a rede até à margem. A rede estava cheia com cento e cinqüenta e três grandes peixes e, mesmo assim, ela não arrebentou. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus lhes disse: —Venham comer. (Nenhum dos discípulos se atrevia a perguntar quem ele era, pois todos sabiam que era o Senhor.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus chegou perto, pegou o pão e repartiu entre eles. E fez a mesma coisa com os peixes. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","(Esta foi a terceira vez que Jesus apareceu aos seus discípulos depois de ter ressuscitado dos mortos.) ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Quando acabaram de comer, Jesus disse a Simão Pedro: —Simão, filho de João, você me ama mais do que estes? Ele respondeu: —Sim, Senhor, o senhor sabe que eu o amo. Jesus disse: —Cuide dos meus cordeiros. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","E pela segunda vez Jesus perguntou: —Simão, filho de João, você me ama? E ele respondeu: —Sim, Senhor, o senhor sabe que eu o amo. Jesus disse: —Cuide das minhas ovelhas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","E Jesus perguntou pela terceira vez: —Simão, filho de João, você me ama? Pedro ficou triste, por Jesus ter perguntado ainda uma terceira vez se ele o amava e disse: —Senhor, o senhor sabe tudo! Sabe que eu o amo. Então Jesus lhe disse: —Cuide das minhas ovelhas. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Digo-lhe a verdade: Quando você era jovem, você mesmo amarrava a sua roupa em torno de você e ia para onde queria. Quando, porém, ficar velho, você estenderá as mãos e outra pessoa o amarrará e o levará para onde você não vai querer ir. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jesus disse isto para mostrar a maneira pela qual Pedro iria morrer e glorificar a Deus.) Depois Jesus disse a Pedro: —Siga-me! ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro se voltou e viu o discípulo que Jesus amava andando atrás dele. (Esse discípulo era o mesmo que se inclinara para perto de Jesus no dia do jantar, perguntando: “Senhor, quem vai traí-lo?”) ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Quando Pedro o viu atrás deles, perguntou a Jesus: —E quanto a ele, Senhor? ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus respondeu: —Se eu quiser que ele fique aqui até eu voltar, o que você tem com isso? Quanto a você, siga-me! ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Por causa disso, espalhou-se entre os seguidores de Jesus um boato de que aquele discípulo não morreria. Mas Jesus não tinha dito que o discípulo não iria morrer, mas sim: “Se eu quiser que ele fique aqui até eu voltar, o que você tem com isso?” ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Este é o discípulo que dá testemunho a respeito destas coisas e que as escreveu. E sabemos que o seu testemunho é verdadeiro. ");
INSERT INTO por_WBTC_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesus fez ainda muitas outras coisas. Se todas essas coisas fossem escritas, uma por uma, acho que nem no mundo inteiro caberiam os livros que seriam escritos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","No meu primeiro livro, Teófilo, eu escrevi a respeito de todas as coisas que Jesus fez e ensinou desde o princípio ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","até o dia em que foi levado para o céu. Antes, porém, por meio do Espírito Santo, Ele deu instruções aos apóstolos que tinha escolhido. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Depois de sua morte, Jesus se apresentou vivo aos apóstolos e lhes deu muitas e indiscutíveis provas de que estava vivo. Ele lhes apareceu durante quarenta dias e lhes falou a respeito do reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Numa ocasião, quando estava comendo com eles, Ele lhes deu esta ordem: —Não saiam de Jerusalém, mas esperem pela promessa do Pai, da qual eu lhes falei. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Pois João batizava em água, mas vocês serão batizados no Espírito Santo, daqui a alguns dias. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Quando os apóstolos estavam reunidos com Jesus, eles lhe perguntavam: —É agora, Senhor, que vai devolver o reino para Israel? ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ele lhes disse: —O Pai é o único que tem autoridade de decidir sobre datas e tempos; não cabe a vocês saber essas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mas receberão poder, quando o Espírito Santo vier sobre vocês, e então serão minhas testemunhas em Jerusalém, em toda a região da Judéia e Samaria e também pelos quatro cantos do mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Depois de dizer isto, Jesus foi levado para o céu diante deles; e uma nuvem o cobriu, escondendo-o deles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Eles continuaram olhando para o céu enquanto Jesus se afastava. De repente, dois homens vestidos de branco apareceram ao lado deles, ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","e disseram: —Homens da Galiléia, por que vocês estão aqui de pé olhando para o céu? Esse mesmo Jesus que foi levado de vocês para o céu voltará da mesma maneira que o viram partir. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Depois disto, os discípulos voltaram para Jerusalém. Eles estavam no Monte das Oliveiras, que ficava mais ou menos a um quilômetro de distância. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Quando chegaram, foram para uma sala que ficava no andar de cima de uma casa, pois era ali que eles iam ficar. Eram eles: Pedro, João, Tiago e André; Filipe, Tomé, Bartolomeu e Mateus; Tiago, o filho de Alfeu, Simão, o Zelote, e Judas, o irmão de Tiago. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Eles estavam sempre juntos e se dedicavam à oração. Com eles estavam também algumas mulheres, os irmãos de Jesus e Maria, a mãe dele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Naqueles dias, Pedro se levantou no meio dos irmãos (havia naquele lugar mais ou menos cento e vinte pessoas) e disse: ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Meus irmãos! As coisas que o Espírito Santo revelou por meio de Davi a respeito de Judas, e que estão nas Escrituras, tinham que acontecer. Foi Judas que guiou os homens que prenderam a Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Esse homem era do nosso grupo e ajudava no nosso serviço. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ele comprou um campo com o dinheiro que ganhou pela sua maldade e foi lá que ele caiu de cabeça para baixo e se arrebentou e os seus intestinos se esparramaram. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Todos em Jerusalém ficaram sabendo disso e o campo ficou conhecido na própria língua deles como “Aceldama”, que quer dizer “Campo de Sangue”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pois assim está escrito no livro dos Salmos: “Que a sua habitação fique deserta e que ninguém viva nela”. e também: “Que outra pessoa fique com o seu cargo”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Por isso, é necessário escolher um dos homens que esteve conosco todo o tempo em que o Senhor Jesus também esteve, ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","começando pelo batismo de João, até o dia em que Jesus foi para o céu, para que juntos possamos ser testemunhas da sua ressurreição. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Então eles sugeriram estes dois homens: José, chamado Barsabás, mas também conhecido como Justo, e Matias. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Depois eles oraram, dizendo: —O Senhor conhece os corações de todos. Então mostre-nos qual destes dois homens deve trabalhar conosco ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","e ocupar o cargo de apóstolo que Judas abandonou para ir para o seu próprio lugar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Eles sortearam entre os dois e a sorte saiu para Matias, que foi incluído no grupo dos onze apóstolos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Quando chegou o dia de Pentecostes, todos eles estavam reunidos no mesmo lugar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","De repente veio do céu um som parecido com o de uma ventania, e que encheu toda a casa onde eles estavam sentados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","E então apareceram línguas como de fogo que se espalharam e pousaram sobre cada um deles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Todos ficaram cheios do Espírito Santo e começaram a falar em outras línguas, de acordo com o que o Espírito lhes concedia que falassem. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Estavam morando em Jerusalém judeus cheios de fé, que tinham vindo de todas as nações do mundo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ao ouvirem aquele som, a multidão se ajuntou e todos ficaram muito admirados, pois cada um os ouvia falar em sua própria língua. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Surpresos e assombrados, diziam uns aos outros: —Não são galileus todos estes homens que estão falando? ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Como é, então, que cada um de nós os ouve falar em nossa própria língua nativa? ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Viemos da Pártia, da Média, do Elão, da Mesopotâmia, da Judéia, da Capadócia, do Ponto, da Ásia, ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","da Frígia, da Panfília, do Egito e das regiões da Líbia, que fica perto de Cirene. Alguns de nós são de Roma, ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","outros vieram de Creta e outros da Arábia. Alguns são judeus e outros são convertidos ao judaísmo. Nós os estamos ouvindo falar sobre a grandeza de Deus em nossas próprias línguas! ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Eles estavam todos admirados e sem saber o que pensar, e diziam uns aos outros: —O que quer dizer tudo isto? ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Outros, porém, faziam pouco deles e diziam: —Eles estão bêbados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Então Pedro se levantou junto com os onze apóstolos e, em voz bem alta, começou a falar para a multidão, dizendo: —Homens da Judéia! Todos vocês que estão morando em Jerusalém! Deixem que eu lhes diga uma coisa e prestem muita atenção ao que eu vou dizer. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Estes homens não estão bêbados como vocês pensam que estão, pois mal passa das nove horas da manhã! ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ao contrário! O que está acontecendo diz respeito ao que o profeta Joel falou: ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Nos últimos dias—diz Deus—derramarei o meu Espírito // sobre todas as pessoas; seus filhos e suas filhas profetizarão, os jovens terão visões e os velhos terão sonhos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sim, naqueles dias derramarei o meu Espíritonos meus servos homens e mulheres, e eles profetizarão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Eu mostrarei maravilhas em cima, no céu, e sinais em baixo, na terra. Haverá sangue e fogo e nuvens de fumaça. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","O sol se transformará em escuridão e a lua em sangue, antes de vir o grande e glorioso dia do Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","E todos os que procurarem pelo Senhor serão salvos”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","—Homens de Israel! Escutem o que eu vou dizer: Jesus de Nazaré foi um homem cujas credenciais foram aprovadas por Deus entre vocês, por meio de muitos milagres, maravilhas e sinais que o próprio Deus realizou por meio dele, como vocês bem sabem. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Esse homem foi entregue a vocês de acordo com o propósito e o prévio conhecimento de Deus; e vocês, com a ajuda de homens maus, mataram-no, crucificando-o. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Deus, porém, o ressuscitou, livrando-o das dores da morte, pois não era possível que Ele fosse dominado por ela. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Pois Davi disse isto a respeito dele: “Eu vi o Senhor sempre à minha frente; Ele está à minha direita para que eu não seja abalado. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Por isso, o meu coração está feliz, a minha boca fala coisas alegres e o meu corpo vive em esperança. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Isso acontece porque o senhor não abandonará a minha alma no mundo dos mortos e também não permitirá que o seu Santo entre em decomposição. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","O Senhor me revelou os caminhos da vida e me encherá de alegria com a sua presença”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","—Irmãos! Eu posso lhes dizer com confiança a respeito do patriarca Davi: Ele morreu, foi sepultado e o seu túmulo se encontra entre nós até os dias de hoje. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ele era um profeta e sabia que Deus lhe tinha jurado que um dos seus descendentes se sentaria no seu trono. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Vendo antecipadamente, Davi falou a respeito da ressurreição de Cristo. Davi disse que Cristo não seria abandonado no lugar dos mortos e também que seu corpo não entraria em decomposição. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Deus ressuscitou a Jesus e nós somos testemunhas disso. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Depois de ter sido levado para a direita de Deus, Ele recebeu do Pai o Espírito Santo, que o próprio Pai havia prometido, e derramou o que vocês agora estão vendo e ouvindo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Porque não foi Davi quem subiu para o céu e ele mesmo diz: “O Senhor disse ao meu Senhor: Sente-se aqui do meu lado direito ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","até que eu ponha os seus inimigos debaixo dos seus pés”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Portanto que todo o Israel tenha certeza de que esse mesmo Jesus, a quem vocês crucificaram, Deus o fez Senhor e Cristo! ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ao ouvirem aquilo, todos sentiram um profundo remorso e perguntaram a Pedro e aos demais apóstolos: —O que devemos fazer então, irmãos? ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro lhes disse: —Arrependam-se e cada um de vocês seja batizado em nome de Jesus Cristo, para o perdão dos pecados de vocês. Então receberão o dom do Espírito Santo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pois esta promessa é para vocês, para seus filhos e para todos aqueles que estão longe e a quem o Senhor, nosso Deus, chamar para si. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","E Pedro continuava a testemunhar, e os encorajava com muitas outras palavras, dizendo: —Salvem-se desta geração má! ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Aqueles que aceitaram a sua mensagem foram batizados e, mais ou menos, três mil pessoas foram adicionadas naquele dia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eles se dedicavam ao ensino dos apóstolos, à comunhão, ao partir do pão e às orações. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Os apóstolos fizeram muitos sinais e maravilhas, e um sentimento de muito respeito tomou conta de todos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Todos os que creram ficavam juntos e repartiam tudo o que tinham. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Eles venderam suas propriedades e os seus bens e distribuíram entre todos, conforme a necessidade de cada um. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Eles se reuniam no templo todos os dias, e dividiam o pão de casa em casa, repartindo a comida com alegria e com sinceridade no coração. ");
INSERT INTO por_WBTC_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Eles louvavam a Deus e eram estimados por todas as pessoas. E todos os dias o Senhor aumentava aquele grupo com pessoas que iam sendo salvas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Certo dia, às três horas da tarde—hora da oração—Pedro e João foram ao templo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Havia no templo um portão chamado Formoso. Todos os dias um homem que era paralítico desde que nascera era carregado até lá. Ele ficava perto do portão pedindo esmolas às pessoas que iam para o templo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Quando este homem viu a Pedro e João prestes a entrar no templo, pediu-lhes uma esmola. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro, assim como João, olharam bem para ele e disseram: —Olhe para nós! ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","O homem olhou para eles, esperando receber alguma coisa deles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mas Pedro lhe disse: —Eu não tenho nenhum dinheiro para dar, mas vou lhe dar o que tenho: Em nome de Jesus Cristo de Nazaré: levante-se e ande! ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","E, puxando-o pela mão direita, Pedro o levantou. No mesmo instante, os seus pés e tornozelos ficaram fortes e, ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","dando um salto, o homem se colocou de pé e começou a andar. Ele entrou no templo com eles, andando, saltando e louvando a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Todas as pessoas o viram andar e a louvar a Deus, ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","e reconheceram que ele era o homem que estava sempre pedindo esmolas perto do portão Formoso do templo. Todos ficaram admirados e maravilhados com o que tinha acontecido com ele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","O homem se agarrou a Pedro e João, e todas as pessoas, admiradas, corriam para onde eles estavam, no lugar chamado Alpendre de Salomão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Quando Pedro viu isso, disse ao povo: —Homens de Israel! Por que vocês ficaram admirados com isto? Por que vocês nos olham como se fosse pelo nosso próprio poder ou virtude que tivéssemos feito este homem andar? ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","O Deus dos nossos antepassados, o Deus de Abraão, de Isaque e de Jacó, glorificou ao seu servo Jesus. Vocês, porém, o entregaram às autoridades para ser morto e também o rejeitaram diante de Pilatos; e quando Pilatos quis soltá-lo, vocês não quiseram. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Vocês rejeitaram o Santo e o Justo e pediram que um assassino fosse libertado em seu lugar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Vocês mataram o Autor da vida, mas Deus o ressuscitou, e nós somos testemunhas disso. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Pela fé no poder de Jesus, esse mesmo poder fortaleceu a este homem que vocês vêem e conhecem. Sim, foi a fé que vem por meio de Jesus que curou completamente este homem diante de todos vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","—Agora, irmãos, eu sei que tanto vocês como os seus líderes fizeram o que fizeram por ignorância. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Foi dessa maneira que Deus fez com que acontecesse aquilo que Ele tinha dito pela boca de todos os profetas: que o seu Cristo tinha de sofrer. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Portanto, arrependam-se e voltem-se para Deus para que os pecados de vocês sejam apagados; ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","para que, da presença de Deus, venham tempos de alívio e também para que Deus possa enviar o Cristo que já escolheu para vocês, isto é, Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","—Mas é preciso que Jesus permaneça no céu até chegar o tempo de todas as coisas serem renovadas. Deus nos falou a respeito dessas coisas há muito tempo atrás, pela boca dos seus santos profetas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Pois Moisés disse: “O Senhor seu Deus lhes dará um profeta como eu, e esse profeta virá do meio do seu próprio povo. Vocês devem obedecer a tudo o que Ele lhes disser. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Qualquer pessoa que não obedecer àquele profeta será completamente eliminada do povo”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Todos os profetas, começando por Samuel e indo até todos os que vieram depois dele, falaram a respeito destes dias. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Vocês são os descendentes dos profetas e da aliança que Deus fez com os antepassados de vocês. Ele disse a Abraão: “Todas as pessoas do mundo serão abençoadas por meio de sua descendência”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Quando Deus ressuscitou o seu servo, Ele o enviou primeiro a vocês, para que cada um de vocês fosse abençoado ao abandonar a sua vida de pecados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Os sacerdotes, o capitão da guarda do templo e os saduceus se aproximaram enquanto eles ainda estavam falando. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Eles ficaram irritados porque Pedro e João estavam ensinando o povo e proclamando a ressurreição dos mortos por meio de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Então prenderam os dois e os puseram na cadeia até o dia seguinte, pois já era muito tarde. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","No entanto, muitos dos que ouviram a mensagem acreditaram e o número de homens subiu para cinco mil. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","No dia seguinte, os líderes do povo, os anciãos e os professores da lei se reuniram em Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Também estavam presentes: Anás, o sumo sacerdote, Caifás, João, Alexandre e todos os que pertenciam à família do sumo sacerdote. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ao colocar os apóstolos no meio deles, começaram a fazer-lhes perguntas: —Com que poder ou em nome de quem é que vocês fizeram isso? ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedro, então, cheio do Espírito Santo, disse-lhes: —Líderes do povo e anciãos! ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Parece que hoje nós estamos sendo interrogados por causa da boa ação que fizemos ao homem paralítico, e de como ele foi curado. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Muito bem! Então fiquem todos vocês e todo o povo de Israel sabendo que este homem se apresenta curado diante de vocês pelo poder de Jesus Cristo de Nazaré, o mesmo a quem vocês crucificaram e a quem Deus ressuscitou. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ele é “a pedra que vocês, os construtores, rejeitaram e que passou a ser a mais importante”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","E não há salvação em mais ninguém, pois não há nenhum outro nome debaixo do céu dado entre os homens, pelo qual importa que sejamos salvos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Os membros do Conselho Superior ficaram admirados com a coragem de Pedro e de João, pois sabiam que eles eram homens simples e sem cultura. Eles reconheceram, então, que os dois tinham sido companheiros de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Eles não puderam dizer nada, pois o homem que tinha sido curado estava de pé, ali, entre eles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Os membros do Conselho Superior ordenaram que os dois saíssem, e começaram a discutir entre si: ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—O que podemos fazer a estes homens? Está claro para todas as pessoas que vivem em Jerusalém que um milagre notável foi feito entre elas e isso nós não podemos negar! ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","No entanto, para que isto não se espalhe ainda mais pelo povo, vamos ameaçá-los e dizer para que não falem neste nome a mais ninguém. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","E, chamando os dois novamente, mandaram que eles nunca mais dissessem ou ensinassem coisa alguma a ninguém em nome de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mas Pedro e João lhes disseram: —Vocês decidam se é certo diante de Deus obedecer a vocês ao invés de obedecer a Ele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nós não podemos deixar de falar a respeito das coisas que vimos e ouvimos! ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Então, os membros do Conselho Superior os ameaçaram ainda mais e depois os deixaram ir embora. Eles não viam uma forma sequer de castigá-los, pois todo o povo estava dando graças a Deus pelo que tinha acontecido. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","O homem que fora curado pelo milagre tinha mais de quarenta anos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Quando foram libertados, Pedro e João voltaram para junto de seus companheiros e lhes contaram tudo o que os líderes dos sacerdotes e os anciãos tinham dito a eles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Quando ouviram aquilo, todos juntos oraram a Deus, dizendo: —Mestre! O Senhor fez o céu, a terra, o mar, e tudo o que neles existe. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","O Senhor disse por meio do Espírito Santo, pela boca do nosso antepassado Davi, seu servo: “Por que as nações se mostraram tão arrogantes e as pessoas conspiraram em vão? ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Os reis da terra se preparam para a batalha, e os líderes se reúnem contra o Senhor e contra o seu escolhido, Cristo”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Sim, pois Herodes, Pôncio Pilatos, os judeus e os que não são judeus se reuniram nesta cidade contra o seu santo servo, Jesus, a quem o Senhor ungiu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Eles se reuniram para fazer todas as coisas que o Senhor, pelo seu poder e vontade, já, há muito tempo, tinha decidido que deveriam acontecer. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","E agora, Senhor, ouça as ameaças deles e dê aos seus servos habilidade para falarem a sua mensagem com toda a coragem. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Enquanto isso, estenda a sua mão poderosa para curar, e faça com que sinais e coisas maravilhosas sejam feitos pelo poder do seu santo servo Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Quando acabaram de orar, o lugar onde eles tinham se reunido tremeu; todos ficaram cheios do Espírito Santo e começaram a falar a mensagem de Deus com coragem. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Todo o grupo dos que creram parecia ter um só coração e uma só alma. Ninguém dizia que qualquer coisa que tivesse era só sua; ao contrário, eles repartiam tudo o que tinham. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Com grande poder, os apóstolos davam testemunho a respeito da ressurreição do Senhor Jesus e grandes bênçãos de Deus eram derramadas sobre todos eles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ninguém do grupo passava necessidades, pois todos os que tinham casas ou terrenos os vendiam ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","e levavam o dinheiro da venda para os apóstolos. Então se distribuía a cada um conforme a sua necessidade. ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","José, a quem os apóstolos deram o sobrenome de Barnabé (que quer dizer “filho de encorajamento”), levita, que havia nascido em Chipre, ");
INSERT INTO por_WBTC_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","vendeu um terreno que possuía, levou todo o dinheiro e o colocou aos pés dos apóstolos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Entretanto, havia um homem chamado Ananias que, junto com sua mulher Safira, vendeu uma propriedade ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","e levou somente parte do dinheiro para os apóstolos, guardando o restante para ele. Safira sabia disso e concordou com a atitude do marido. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Então Pedro lhe disse: —Ananias, por que você deixou que Satanás enchesse o seu coração, para que mentisse ao Espírito Santo, ficando com parte do dinheiro da venda do terreno? ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","O terreno não era seu, antes de você vendê-lo? E depois que você o vendeu, não tinha a liberdade de fazer o que quisesse com o dinheiro? Por que decidiu fazer isso? Você não mentiu para os homens, mas sim para Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ao ouvir estas palavras, Ananias caiu morto, e todos os que souberam dessas coisas ficaram com muito medo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Alguns jovens se levantaram, cobriram-lhe o corpo, levaram para fora e o enterraram. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mais ou menos três horas mais tarde chegou Safira, ainda sem saber o que tinha acontecido a seu marido. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro, então, lhe perguntou: —Diga-me uma coisa: Foi por este preço que você e o seu marido venderam o terreno? Ela respondeu: —Sim, foi por essa quantia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Então Pedro lhe disse: —Por que você e seu marido concordaram em pôr à prova o Espírito do Senhor? Olhe! Os jovens que acabaram de enterrar seu marido estão aí e agora eles vão levar você também. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","E no mesmo instante ela caiu morta aos pés de Pedro. Ao entrarem os jovens, viram na morta e a levaram para fora e a enterraram ao lado de seu marido. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","E um grande temor veio sobre toda a igreja e sobre todos aqueles que ficaram sabendo dessas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Os apóstolos faziam muitos sinais e maravilhas entre o povo e todos se reuniam no Alpendre de Salomão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dos restantes, ninguém se atrevia a juntar-se a eles, mas o povo falava muito bem deles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","E mais e mais pessoas, tanto homens como mulheres, criam no Senhor e eram adicionados ao grupo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","E, como resultado disso, o povo levava os doentes para as ruas e os colocava em camas e macas para que, quando Pedro passasse, ao menos a sua sombra tocasse em alguns deles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Multidões de pessoas também vinham das cidades próximas a Jerusalém. Elas levavam os seus doentes e aqueles que eram atormentados por demônios e todos eram curados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","O sumo sacerdote e os seus associados, isto é, os saduceus, ficaram com muita inveja. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Então, mandaram prender os apóstolos e os colocaram numa cadeia pública. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Durante a noite, um anjo do Senhor abriu as portas da prisão, os levou para fora e disse: ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Vão para o templo e digam para as pessoas todas as coisas a respeito desta nova vida. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ao ouvir isto, eles foram para o templo assim que amanheceu, e começaram a ensinar. Quando o sumo sacerdote e os seus associados chegaram, mandaram convocar o Conselho Superior e toda a assembléia dos anciãos de Israel. Depois eles mandaram buscá-los na cadeia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Quando os guardas chegaram à prisão, eles não encontraram os apóstolos. Então voltaram e contaram isto: ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Nós encontramos a prisão bem fechada, e também os guardas ao lado das portas mas, quando as abrimos, não havia ninguém lá dentro. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Quando o capitão da guarda do templo e os líderes dos sacerdotes ouviram isto, ficaram sem saber o que pensar sobre eles e o que poderia acontecer em seguida. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Depois entrou alguém e disse: —Os homens que vocês puseram na cadeia estão no templo ensinando o povo! ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Então, o capitão e os guardas foram até lá e os levaram de volta. Eles não usaram de violência porque tinham medo que o povo os apedrejasse. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Eles os levaram para dentro e os puseram diante do Conselho Superior. O sumo sacerdote começou a interrogá-los, dizendo: ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Nós mandamos que vocês não ensinassem mais nesse nome, e vejam o que vocês fizeram! Vocês encheram Jerusalém com esse ensino e querem colocar a culpa da morte dele sobre nós! ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedro e os outros apóstolos disseram: —Nós devemos obedecer a Deus e não aos homens. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","O Deus de nossos antepassados ressuscitou a Jesus, a quem vocês mataram, pendurando-o numa cruz de madeira. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Deus o exaltou, colocando-o à sua direita como Líder e Salvador, para que Ele pudesse dar arrependimento e perdão de pecados a Israel. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nós somos testemunhas destas coisas; e o Espírito Santo, que Deus deu a todos os que lhe obedecem, também é testemunha. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Quando ouviram isto, eles ficaram furiosos e queriam matá-los. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mas, entre as pessoas que estavam no Conselho Superior, levantou-se certo fariseu chamado Gamaliel. Ele era professor da lei e todos o respeitavam. Ele mandou que os homens fossem levados para fora por um pouco de tempo e ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","depois disse ao Conselho: —Homens de Israel! Tenham cuidado com o que vocês vão fazer a estes homens! ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Há algum tempo atrás apareceu Teudas, insinuando ser ele alguém muito importante, e mais ou menos quatrocentos homens o seguiram. Teudas foi morto, os que o seguiam foram dispersos, e nada mais aconteceu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Depois dele veio Judas, o galileu; ele apareceu durante o período do recenseamento e, da mesma forma, algumas pessoas o seguiram. Ele também foi morto e todos que o seguiam também foram dispersos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Portanto, para esta situação de agora eu lhes digo: Afastem-se destes homens e deixem que eles vão embora! Se este plano ou esta obra que eles fazem vem de homens, ela também falhará, como as outras. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mas se a obra deles vem de Deus, vocês não conseguirão pará-los, e pode ser que vocês se achem lutando contra Deus. O tribunal decidiu aceitar o conselho de Gamaliel. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Eles mandaram chamar os apóstolos e, depois de os açoitarem, ordenaram que não falassem mais no nome de Jesus. Depois disso, deixaram que fossem embora. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Os apóstolos deixaram o Conselho Superior contentes por terem sido considerados dignos de sofrer por causa do nome de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","E todos os dias, quer no templo, quer de casa em casa, eles nunca paravam de ensinar e proclamar as Boas Novas a respeito de Jesus Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Naqueles dias, ao se multiplicar o número dos discípulos, houve queixas daqueles judeus que falavam grego contra os judeus que falavam aramaico, pois as suas viúvas não estavam sendo atendidas na distribuição diária. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Os doze apóstolos reuniram todo o grupo de discípulos e disseram: —Não está certo deixarmos de ensinar a mensagem de Deus para fazermos a distribuição diária. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Irmãos! Escolham entre vocês sete homens de confiança e que estejam cheios do Espírito e de sabedoria para que nós os encarreguemos deste serviço. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Dessa forma poderemos nos dedicar à oração e ao ensino da mensagem de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","A sugestão agradou a toda a comunidade e eles escolheram: Estêvão, homem cheio de fé e do Espírito Santo; Filipe, Prócoro, Nicanor, Timão, Pármenas e Nicolau, que era de Antioquia e tinha se tornado judeu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Os discípulos apresentaram estes homens aos apóstolos, e estes oraram e impuseram as suas mãos sobre eles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","A mensagem do Senhor se espalhava. O número de discípulos em Jerusalém se multiplicava e também um grande número de sacerdotes judeus aceitava a fé. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estêvão, um homem muito abençoado por Deus e cheio de poder, fez grandes maravilhas e sinais entre o povo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mas alguns dos homens da “Sinagoga dos Homens Livres” (era assim que a chamavam), opuseram-se a ele. Eles eram judeus da região de Cirene, de Alexandria, da Cilícia e da Ásia e começaram a discutir com Estêvão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Esses judeus, porém, não conseguiam vencer o Espírito e a sabedoria com que Estêvão falava. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Então eles subornaram algumas pessoas que disseram: —Nós ouvimos esse homem falar coisas ruins contra Moisés e contra Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","E dessa forma eles agitaram o povo, os anciãos e os professores da lei que o pegaram e o levaram para o Conselho Superior. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Eles arranjaram também testemunhas falsas para falar contra Estêvão, e elas diziam: —Esse homem nunca pára de falar contra este lugar santo e contra a lei. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nós o ouvimos dizer que Jesus de Nazaré vai destruir este templo e vai mudar todos os costumes que Moisés nos deu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Todos os que estavam sentados no Conselho Superior olharam bem para Estêvão e viram que o rosto dele parecia o rosto de um anjo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Então o sumo sacerdote lhe perguntou:—É verdade isso? ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ele respondeu: —Irmãos e pais, escutem! O Deus de glória apareceu ao nosso antepassado Abraão, enquanto ele ainda estava vivendo na Mesopotâmia, antes de ter ido viver em Harã, ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","e lhe disse: “Deixe o seu país e a sua família e vá para a terra que Eu vou lhe mostrar”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ele então partiu da terra dos caldeus e se mudou para Harã. Depois que o pai dele morreu, Deus fez com que Abraão se mudasse de lá e viesse viver nesta terra, onde vocês estão vivendo agora. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Não lhe deu nenhuma herança, nem um só metro de terra, mas prometeu dá-la a ele e a seus descendentes (nessa época Abraão ainda não tinha nenhum filho). ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Isto é o que Deus disse a ele: “Os seus descendentes vão viver como estrangeiros em país distante. Eles serão escravizados e maltratados por quatrocentos anos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","E Eu vou julgar o país que os escravizou”. E Deus ainda disse: “Depois disso eles sairão de lá e virão me adorar neste lugar”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","E então Deus e Abraão fizeram uma aliança de circuncisão. Por isso Abraão circuncidou a Isaque no oitavo dia depois do seu nascimento e Isaque fez o mesmo com Jacó e Jacó fez o mesmo com os doze patriarcas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","—Os patriarcas tinham inveja de José e o venderam como escravo para o Egito, mas Deus estava com ele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Deus o livrou de todos os seus problemas e lhe deu sabedoria e habilidade diante de Faraó, rei do Egito. Faraó o nomeou governador sobre o Egito e sobre toda a sua casa. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Depois, uma grande fome veio sobre toda a região do Egito e de Canaã. Houve muito sofrimento e os nossos antepassados não encontravam nada para comer. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Quando Jacó ouviu dizer que havia trigo no Egito, enviou nossos antepassados para lá pela primeira vez. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Numa segunda visita, José se revelou a seus irmãos e a família de José passou a ser conhecida pelo Faraó. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Então José mandou buscar a seu pai Jacó e toda a sua família, num total de setenta e cinco pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","E Jacó desceu ao Egito e foi lá que tanto ele como nossos antepassados morreram. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Eles foram trazidos de volta para Siquém, onde foram enterrados no túmulo que Abraão tinha comprado dos filhos de Emor por certa quantia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","—O tempo de se cumprir a promessa que Deus havia feito a Abraão estava próximo, e o nosso povo havia se multiplicado muito no Egito. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Então, um outro rei subiu ao trono do Egito e ele não conhecia a José. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Com grande astúcia, enganou o nosso povo e maltratou os nossos antepassados, forçando-os a abandonar os seus filhos para que eles não vivessem. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Naquele tempo nasceu Moisés. Ele era uma criança muito bonita e, durante três meses, foi mantido na casa de seus pais. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Depois disso ele foi abandonado, mas a filha de Faraó o recolheu e o criou como se fosse seu próprio filho. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moisés foi educado em toda a sabedoria dos egípcios e era poderoso em palavras e ações. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","—Quando Moisés estava com quarenta anos, decidiu visitar os seus irmãos, os israelitas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ao ver um deles sendo maltratado, defendeu e vingou o israelita oprimido, matando o egípcio. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ele pensava que seus irmãos iriam entender que Deus o estava usando para libertá-los, mas eles não entenderam assim. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","No dia seguinte, Moisés encontrou alguns homens brigando e, querendo apartar a briga, disse: “Ei, homens! Vocês são irmãos! Por que estão ferindo um ao outro?” ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mas o homem que estava maltratando o outro empurrou Moisés para trás e lhe disse: “Quem foi que nomeou a você chefe e juiz sobre nós? ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Por acaso você quer me matar assim como matou o egípcio ontem?” ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Quando Moisés ouviu aquilo, fugiu e foi viver como estrangeiro na terra de Midiã, onde teve dois filhos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","—Quarenta anos depois, um anjo apareceu a Moisés no deserto, perto do Monte Sinai, em meio ao fogo dum arbusto que estava em chamas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés ficou muito admirado com o que viu e, enquanto se aproximava para poder ver melhor, ouviu a voz do Senhor: ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Eu sou o Deus dos seus antepassados, o Deus de Abraão, de Isaque e de Jacó.” Moisés tremia de medo e não tinha coragem nem de olhar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Então o Senhor lhe disse: “Tire as suas sandálias dos pés, pois o lugar onde você está é terra santa. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Eu tenho olhado e tenho visto o sofrimento do meu povo no Egito. Eu ouvi os seus gemidos e desci para libertá-los. Venha, pois vou mandá-lo para o Egito”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","—Este é o mesmo Moisés a quem tinham rejeitado, dizendo: “Quem é que nomeou a você chefe e juiz sobre nós?” Ele foi o homem a quem Deus enviou para ser chefe e libertador. Deus enviou a Moisés com a ajuda de um anjo que lhe apareceu no arbusto que estava em chamas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ele os libertou e fez maravilhas e sinais no Egito, no Mar Vermelho e no deserto, durante quarenta anos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Foi este Moisés que disse aos israelitas: “Deus enviará um profeta como eu e ele virá do povo de vocês”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Foi ele que esteve reunido em assembléia no deserto. Moisés esteve lá com nossos antepassados e com o anjo que falou com ele no Monte Sinai. Foi ele quem recebeu as palavras de vida para nos dar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","—Os nossos antepassados, porém, não quiseram obedecer-lhe. Ao contrário, eles o rejeitaram e, em seus corações, voltaram para o Egito. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","E eles disseram para Arão: “Faça alguns deuses para nós, para que nos guiem, pois não sabemos o que aconteceu com esse Moisés que nos tirou do Egito”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nessa época eles fizeram uma imagem de um bezerro. Ofereceram sacrifício ao ídolo deles e também fizeram uma festa em honra ao que eles mesmos tinham feito com as suas próprias mãos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Deus, então, os deixou e os entregou para que adorassem os poderes celestiais, assim como está escrito no livro dos profetas: “Casa de Israel! Por acaso foi para mim que vocês mataram animais e ofereceram sacrifícios durante quarenta anos no deserto? ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Claro que não! O que vocês carregaram foi a imagem do deus Moloque e também a imagem da estrela do seu deus Refã, ídolos que vocês fizeram para a adoração. Por causa disso, eu os expulsarei para além da Babilônia”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","—A tenda do testemunho estava com os nossos antepassados no deserto. Essa tenda foi feita conforme Deus tinha dito para Moisés fazer, e de acordo com o modelo que ele tinha visto. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Depois de terem recebido a tenda, nossos antepassados, que eram liderados por Josué, introduziram a tenda na terra conquistada das nações que Deus tinha expulsado de diante deles. E a tenda foi mantida lá até os dias de Davi. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davi foi favorecido por Deus e lhe pediu se poderia construir uma casa para o Deus de Jacó. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mas foi Salomão quem construiu a casa para Ele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","—Entretanto, o Altíssimo não vive em casas feitas por mãos humanas, assim como diz o profeta: ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“O céu é o meu trono—diz o Senhor— e a terra é o lugar onde ponho os meus pés. Que tipo de casa vocês poderiam construir para mim? Onde está o lugar para Eu poder descansar? ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Não foram as minhas mãos que fizeram todas estas coisas?” ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","—Gente teimosa! Vocês são surdos e duros de coração, como aqueles que não conhecem a Deus! Vocês estão sempre resistindo ao Espírito Santo! Vocês são idênticos aos seus antepassados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Houve algum profeta que os pais de vocês não perseguiram? Eles até mataram aqueles que, antigamente, anunciaram a vinda do Justo, e agora vocês o traíram e o mataram. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Vocês são aqueles que receberam a lei que foi entregue por anjos, mas não a obedeceram. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Quando os membros do Conselho Superior ouviram o que Estêvão tinha dito, ficaram furiosos e rangeram os dentes contra ele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mas Estêvão, cheio do Espírito Santo, olhou para o céu e viu a glória de Deus e Jesus à sua direita, ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","e disse: —Olhem! Vejo o céu aberto e o Filho do Homem em pé à direita de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Então, eles taparam os ouvidos, começaram a gritar e juntos avançaram em Estêvão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Depois o arrastaram para fora da cidade e começaram a apedrejá-lo. As testemunhas deixaram as suas capas com um jovem que se chamava Saulo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Enquanto o apedrejavam, Estêvão gritava, dizendo: —Senhor Jesus, receba o meu espírito. ");
INSERT INTO por_WBTC_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Depois, Estêvão se ajoelhou e gritou bem alto: —Senhor! Não os condene por causa deste pecado! E, acabando de dizer isso, morreu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo tinha concordado com a morte de Estêvão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Alguns homens que temiam a Deus o enterraram e choraram muito por causa de sua morte. Daquele dia em diante a igreja em Jerusalém começou a sofrer uma grande perseguição. Todos os discípulos foram dispersos pelas regiões da Judéia e de Samaria, com exceção dos apóstolos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo procurava destruir a igreja. Ele ia de casa em casa, arrastava para fora tanto homens como mulheres e os punha na cadeia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Aqueles que tinham sido dispersos iam a todos os lugares anunciando as Boas Novas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipe foi para a cidade de Samaria e lá proclamava o Cristo a todos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Quando a multidão o ouviu e viu os sinais que ele fazia, começou a prestar muita atenção às coisas que ele dizia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Demônios, gritando alto, saíam de muitas pessoas possuídas por eles, muitos coxos e paralíticos eram curados ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","e houve grande alegria naquela cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Havia em Samaria um homem chamado Simão que, já há algum tempo, praticava magias e fascinava as pessoas de lá. Ele se dizia ser alguém importante ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","e todas as pessoas, desde o mais humilde até o mais importante, lhe davam atenção e diziam: —Este homem tem o poder de Deus, chamado “O Grande Poder!” ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Todos lhe davam muita atenção porque, já há algum tempo, os vinha fascinando com a sua magia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mas muitas pessoas, tanto homens como mulheres, acreditaram no que Filipe lhes tinha dito a respeito das Boas Novas do reino de Deus e do poder de Jesus Cristo e foram batizadas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Até mesmo Simão acreditou e, depois de ter sido batizado, acompanhava Filipe de perto, e observava fascinado os grandes sinais e milagres que eram feitos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Em Jerusalém, os apóstolos ouviram dizer que Samaria tinha aceitado a mensagem de Deus. Então eles enviaram a Pedro e João para lá. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Quando os dois chegaram, oraram por eles para que pudessem receber o Espírito Santo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Eles fizeram isso porque o Espírito Santo ainda não tinha descido sobre nenhum deles, uma vez que eles só tinham sido batizados em nome do Senhor Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Então Pedro e João puseram as mãos sobre eles e eles receberam o Espírito Santo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simão viu que o Espírito era dado quando os apóstolos punham as mãos sobre as pessoas. Então ele lhes ofereceu dinheiro e disse: ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","—Dêem-me também este poder, para que toda pessoa sobre quem eu puser as minhas mãos receba o Espírito Santo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro, então, lhe disse: —Que você e o seu dinheiro sejam destruídos para sempre! Você pensa que pode comprar a oferta de Deus com dinheiro? ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Você não tem lugar e nem pode participar deste ensino, pois o seu coração não é honesto diante de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Arrependa-se dessa sua maldade e ore ao Senhor! Assim, talvez, você poderá ser perdoado por ter pensado desta forma. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Pois vejo que está cheio de inveja e amargura e preso pelo pecado! ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Então Simão disse: —Orem ao Senhor por mim, para que nenhuma dessas coisas que vocês disseram me aconteça. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedro e João voltaram para Jerusalém depois de terem testificado e proclamado a mensagem do Senhor. No caminho, eles foram anunciando as Boas Novas em muitas aldeias samaritanas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Um anjo do Senhor falou com Filipe e disse: —Prepare-se e vá para o sul, pela estrada que desce de Jerusalém e vai até Gaza. (Aquela estrada é deserta). ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ele, então, se preparou e partiu. No caminho encontrou um homem etíope que era eunuco. Ele era um alto oficial de Candace, rainha da Etiópia, encarregado de todo o tesouro dela. Ele estava voltando de Jerusalém onde tinha ido adorar a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Sentado em sua carruagem, ele estava lendo o livro do profeta Isaías. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Então o Espírito disse a Filipe: —Vá até aquela carruagem e fique perto dela. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipe correu para perto da carruagem e ouviu o eunuco lendo o livro do profeta Isaías, e então disse: —O senhor entende o que está lendo? ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","O homem respondeu: —Como posso entender se ninguém me explica? E convidou a Filipe para subir e sentar-se com ele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A passagem da Escritura que o eunuco estava lendo era esta: “Ele foi levado como uma ovelha para o matadouro e assim como o cordeiro fica em silêncio diante daquele que corta a sua lã, ele também não abriu a sua boca. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Na sua humilhação, foi-lhe negada justiça e ninguém falará dos seus descendentes, pois a sua vida foi tirada da terra.” ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Então o eunuco perguntou a Filipe: —Por favor, diga-me: de quem o profeta está falando? Ele está falando dele mesmo ou de outra pessoa? ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Então Filipe começou a explicar por esta passagem da Escritura e anunciou ao eunuco as Boas Novas a respeito de Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","E, prosseguindo pela estrada, chegaram a um lugar onde havia água. O eunuco então disse: —Olhe! água! O que me impede de ser batizado? ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Então, mandou que a carruagem parasse e ambos, tanto ele como Filipe, entraram na água e Filipe o batizou. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Quando saíram da água, o Espírito do Senhor pegou a Filipe e o levou embora e o eunuco nunca mais o viu, mas seguiu o seu caminho cheio de alegria. ");
INSERT INTO por_WBTC_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","De repente Filipe se encontrou na cidade de Azoto e, partindo dali, foi anunciando as Boas Novas por todas as cidades, até chegar a Cesaréia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Enquanto isso, Saulo continuava a ameaçar de morte os discípulos do Senhor. Ele foi falar com o sumo sacerdote e ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","lhe pediu cartas de apresentação para as sinagogas de Damasco, para que, caso encontrasse alguns destes discípulos, quer fossem homens quer fossem mulheres, pudesse prendê-los e levá-los de volta para Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saulo estava indo em seu caminho e já se encontrava perto da cidade de Damasco quando, de repente, uma luz do céu brilhou à sua volta. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ele caiu no chão e ouviu uma voz que lhe dizia: —Saulo, Saulo, por que você me persegue? ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Então ele disse: —Quem é você, Senhor? E a voz respondeu: —Eu sou Jesus, a quem você está perseguindo! ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Levante-se e vá para a cidade. Lá você ficará sabendo o que deve fazer. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Os homens que estavam viajando com Saulo permaneceram em pé sem poder dizer nada. Eles ouviam a voz, mas não viam ninguém. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo se levantou mas, quando abriu os seus olhos, não conseguia ver nada. Então os outros o levaram pela mão e o guiaram até Damasco. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Saulo ficou três dias sem conseguir ver nada e, durante esses três dias, ele não comeu nem bebeu nada. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na cidade de Damasco havia um discípulo de Cristo chamado Ananias. Ele teve uma visão na qual o Senhor lhe disse: —Ananias! E ele disse: —Estou aqui, Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","O Senhor lhe disse: —Prepare-se e vá até a casa de Judas, na rua Direita. Ao chegar lá, pergunte por um homem de Tarso chamado Saulo. Ele está orando e, ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","numa visão, viu um homem chamado Ananias chegar e colocar as mãos sobre ele para que possa voltar a ver. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias, porém, respondeu: —Senhor, eu tenho ouvido muita gente falar a respeito desse homem e a respeito de todas as maldades que ele tem feito ao seu povo em Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Eu ouvi também que ele veio aqui com autoridade dos líderes dos sacerdotes para prender todos aqueles que acreditam no Senhor! ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","O Senhor, então, lhe disse: —Vá! Eu escolhi esse homem como instrumento para levar o meu nome às nações do mundo e aos reis, bem como ao povo de Israel. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Eu mesmo mostrarei a ele tudo quanto irá sofrer pelo meu nome. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Então Ananias foi, entrou na casa de Judas, colocou as mãos sobre Saulo e disse: —Irmão Saulo! O Senhor Jesus, que lhe apareceu quando você estava vindo para cá, me mandou aqui para que você pudesse ver de novo e ficar cheio do Espírito Santo. —");
INSERT INTO por_WBTC_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","E imediatamente, umas coisas que pareciam com escamas caíram dos olhos de Saulo e ele pôde ver novamente. Então ele se levantou e foi batizado ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","e, depois de comer alguma coisa, recuperou as suas forças. Saulo ficou alguns dias com os discípulos de Jesus em Damasco, ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","mas logo começou a anunciar nas sinagogas, dizendo: —Jesus é o Filho de Deus! ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Todos os que o ouviam ficavam admirados e diziam: —Não é este o homem que estava matando em Jerusalém aqueles que acreditam nesse Jesus? Não foi ele que, com a mesma intenção, veio aqui para prender essas pessoas e levá-las para os líderes dos sacerdotes? ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulo, porém, se tornava cada vez mais forte na fé e confundia os judeus que viviam em Damasco com as provas que dava de que Jesus é o Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Algum tempo depois os judeus começaram a fazer planos para matá-lo, ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","mas Saulo ficou sabendo do plano deles. Eles vigiavam os portões da cidade de dia e de noite para matá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Uma noite, porém, os discípulos o levaram e, colocando-o dentro de uma cesta, desceram-no pelo muro da cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Quando chegou a Jerusalém, Saulo procurou juntar-se aos discípulos, mas todos eles tinham medo dele, pois não acreditavam que ele fosse realmente um discípulo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabé, então, levou-o até os apóstolos e explicou-lhes como Saulo tinha visto o Senhor na estrada para Damasco e como o Senhor tinha falado com ele. Barnabé também lhes disse da maneira corajosa com que Saulo tinha falado no nome do Senhor em Damasco. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Depois disso Saulo ficou com eles. Ele andava por toda parte em Jerusalém e falava com muita coragem no nome do Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ele falava e discutia com os judeus que falavam grego, mas estes procuravam um meio de matá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Quando os irmãos em Cristo ficaram sabendo disso, levaram Saulo para a cidade de Cesaréia e depois o mandaram para a cidade de Tarso. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Depois disso a igreja teve um período de paz em toda a região da Judéia, Galiléia e Samaria. Ela foi sendo fortalecida e, como vivesse temendo ao Senhor e sendo encorajada pelo Espírito Santo, crescia em número. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro viajava por toda parte, e um dia foi visitar o povo de Deus que vivia na cidade de Lida. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ao chegar lá, encontrou um homem chamado Enéias. Ele era paralítico e fazia oito anos que estava de cama. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro lhe disse: —Enéias, Jesus Cristo cura a você! Levante-se e arrume a sua maca. E no mesmo instante ele se levantou. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","E todas as pessoas das cidades de Lida e Sarona que o viram se converteram ao Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Em Jope, havia entre os discípulos uma mulher chamada Tabita (que em grego quer dizer “Dorcas”, que significa “gazela”). Ela estava sempre fazendo boas obras e ajudando os pobres. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nessa época ela ficou doente e morreu; e depois de lavarem o seu corpo, puseram-no num quarto no andar de cima da casa. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida ficava perto de Jope e, quando os discípulos ouviram dizer que Pedro estava em Lida, enviaram dois homens até ele, pedindo: —Por favor, venha conosco. Depressa! ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro, então, se aprontou e foi com eles. Quando chegou lá, foi levado para o quarto no andar de cima da casa. Então, todas as viúvas o rodearam e, chorando, mostravam-lhe as túnicas e outras roupas que Dorcas tinha feito enquanto ainda estava com elas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro mandou que todos saíssem do quarto e, ajoelhando-se, orou. Depois, virando-se para o corpo, disse: —Tabita, levante-se! Ela abriu os olhos e, vendo a Pedro, sentou-se. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ele estendeu a mão e levantou-a. Depois chamou os discípulos, incluindo as viúvas e a apresentou viva. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Toda a cidade de Jope ficou sabendo disso e muitas pessoas creram no Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro permaneceu ainda em Jope por vários dias, na casa de um curtidor de couro chamado Simão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Havia na cidade de Cesaréia um homem de nome Cornélio, o qual era comandante do regimento chamado “italiano”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ele era um homem muito piedoso e temia muito a Deus, assim como todos os membros da sua família. Ajudava muito aos pobres e estava sempre orando a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Um dia, mais ou menos às três horas da tarde, Cornélio teve uma visão e viu claramente um anjo de Deus chegando e lhe dizendo: —Cornélio! ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ele olhou para o anjo e, com muito medo, disse: —O que é, Senhor? E o anjo lhe disse: —As suas orações e a ajuda que você tem dado aos pobres subiram até a presença de Deus e Ele se lembrou de você. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Envie homens até a cidade de Jope para que eles tragam de volta um homem de nome Simão, que é conhecido como Pedro. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ele está hospedado com Simão, o curtidor de couro, cuja casa fica perto do mar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Quando o anjo que estava falando com ele foi embora, Cornélio chamou dois empregados e um dos soldados que estavam a seu serviço e que também temia a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ele lhes contou tudo o que tinha acontecido e mandou que fossem até Jope. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","No dia seguinte, os homens que Cornélio tinha enviado estavam chegando a Jope. Por volta do meio-dia, Pedro subiu ao terraço para orar e ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","então sentiu fome e quis comer. Enquanto lhe preparavam a comida, Pedro teve uma visão: ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ele viu o céu se abrir e um objeto que parecia um grande lençol descer à terra, pendurado pelas quatro pontas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Dentro do lençol havia todos os tipos de animais de quatro patas, de bichos que se arrastam e de aves voadoras. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Então uma voz lhe disse: —Levante-se, Pedro! Mate e coma! ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mas Pedro disse: —De maneira nenhuma, Senhor! Eu nunca comi nada que fosse vulgar e impuro! ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","E a voz lhe falou pela segunda vez: —Não chame de impuro aquilo que Deus purificou. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Isto aconteceu por três vezes e, depois, o objeto foi elevado de volta para o céu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro estava tentando entender o que significava a visão que ele tivera. Enquanto isso, os homens que Cornélio tinha enviado já haviam perguntado onde era a casa de Simão e estavam agora no portão da casa. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Eles chamaram e perguntaram se Simão, o qual era conhecido como Pedro, estava hospedado lá. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro ainda estava pensando a respeito da visão quando o Espírito lhe disse: —Escute! Três homens estão procurando por você, ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","portanto levante-se, desça para o andar de baixo da casa e vá com eles. Vá tranqüilo, pois fui eu que os mandei. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro, então, desceu e disse aos homens: —Eu sou aquele a quem vocês estão procurando. Por que vocês vieram? ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Eles disseram: —O comandante Cornélio nos enviou. Ele é um homem justo e teme a Deus e todos os judeus falam bem dele. Um anjo santo lhe disse que convidasse o senhor para ir até a casa dele, para que ele ouvisse o que o senhor tem a dizer. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pedro, então, convidou-os a entrar e lhes deu acomodações. No dia seguinte, Pedro se aprontou e foi com eles, levando consigo alguns irmãos que viviam em Jope. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","No dia seguinte eles chegaram a Cesaréia e Cornélio, que tinha reunido seus parentes e amigos mais chegados, estava esperando por eles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Quando Pedro estava entrando, Cornélio foi ao seu encontro e, abaixando-se, ficou de joelhos diante dele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mas Pedro o levantou e disse: —Levante-se, pois eu sou apenas um homem como você. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Enquanto falava com Cornélio, Pedro entrou na casa e encontrou muitas pessoas reunidas ali. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Então disse a todos: —Vocês sabem que não é permitido a um judeu se associar ou mesmo visitar uma pessoa de outra raça. Deus, porém, me mostrou que não devo considerar ninguém vulgar ou impuro. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Por isso, quando fui convidado, vim de boa vontade. Agora, no entanto, eu lhes pergunto: Por que é que vocês me chamaram? ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornélio então disse: —Há quatro dias atrás a esta mesma hora, mais ou menos às três horas da tarde, eu estava em minha casa, orando. De repente, um homem vestido com roupas brilhantes apareceu diante de mim ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","e me disse: “Cornélio, as suas orações foram ouvidas e Deus se lembrou da ajuda que você tem dado aos pobres. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Envie alguém até Jope e convide a Simão, que é conhecido como Pedro, a vir até aqui. Ele está hospedado na casa de Simão, o curtidor de couro, cuja casa fica perto do mar”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Então mandei chamá-lo imediatamente e o senhor fez muito bem em ter vindo. Agora nós estamos todos aqui, na presença de Deus, para ouvir todas as coisas que o Senhor lhe mandou dizer. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Então Pedro começou a falar: —Agora eu entendo que Deus não faz diferença entre raças! ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Pelo contrário! Ele aceita as pessoas que o temem e que praticam o bem, não importando de que nação elas sejam. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Vocês conhecem a mensagem que Ele enviou ao povo de Israel, proclamando as Boas Novas de paz através de Jesus Cristo, que é Senhor de todos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Vocês sabem de tudo o que aconteceu por toda a região da Judéia, começando pela Galiléia depois do batismo que João anunciou. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Vocês sabem a respeito de Jesus de Nazaré e de como Deus o ungiu com o Espírito Santo e com poder. Vocês também sabem que Jesus andou por todos os lugares fazendo o bem e curando a todos os que estavam debaixo do poder do diabo, pois Deus estava com Ele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nós somos testemunhas de tudo o que Ele fez na terra dos judeus e também em Jerusalém. E eles o mataram, pendurando-o numa cruz de madeira. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mas, ao terceiro dia, Deus o ressuscitou e fez com que Ele aparecesse para nós. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Cristo não apareceu para todas as pessoas, mas somente a nós, testemunhas que Deus já tinha escolhido anteriormente. Nós comemos e bebemos com Ele depois de Deus o ter ressuscitado dos mortos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ele também nos ordenou que anunciássemos para as pessoas e que testemunhássemos que Ele é o escolhido por Deus para ser juiz dos vivos e dos mortos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Todos os profetas testemunham a respeito dele dizendo que, em seu nome, todas as pessoas que acreditam nele recebem o perdão de seus pecados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro ainda estava dizendo estas coisas quando o Espírito Santo desceu sobre todos os que estavam ouvindo a mensagem. ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Então, os judeus que criam em Jesus e que tinham ido com Pedro ficaram admirados, porque o dom do Espírito Santo tinha sido derramado também sobre pessoas que não eram do povo judeu, ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","pois eles os ouviram falar em línguas e louvar a Deus. Então Pedro disse: ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Pode alguém proibir que estas pessoas sejam batizadas em água? Eles receberam o Espírito Santo da mesma forma como nós recebemos! ");
INSERT INTO por_WBTC_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Então Pedro mandou que fossem batizados em nome de Jesus Cristo. Depois disso, pediram que Pedro ficasse com eles por alguns dias. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Os apóstolos e os irmãos de toda a região da Judéia souberam que pessoas que não eram judias também tinham aceitado a mensagem de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Então, quando Pedro foi para Jerusalém, os judeus que eram a favor da circuncisão o criticaram, ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","dizendo: —Você esteve na casa de homens que não são circuncidados, e até comeu com eles! ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedro, então, começou a explicar para eles exatamente o que tinha acontecido. Ele disse: ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Eu estava orando na cidade de Jope quando tive uma visão. Eu vi um objeto que parecia um grande lençol suspenso pelas quatro pontas e que desceu do céu até chegar perto de mim. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Eu fixei os meus olhos naquele objeto e vi animais de quatro patas, animais selvagens, répteis e aves voadoras. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Depois, ouvi uma voz que me dizia: “Levante-se, Pedro! Mate e coma!” ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mas eu disse: “De maneira nenhuma, Senhor! Nada vulgar ou impuro jamais tocou na minha boca”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","E a voz falou do céu uma segunda vez: “Você não deve considerar impuro aquilo que Deus purificou”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Isto aconteceu três vezes e depois tudo foi levado para o céu novamente. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Naquele mesmo momento, três homens que tinham sido enviados de Cesaréia chegaram à casa onde eu estava hospedado. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","O Espírito tinha me dito que eu deveria ir com eles sem qualquer dúvida. Então, estes seis irmãos também foram comigo e entramos na casa de Cornélio. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ele nos disse que tinha visto um anjo em sua casa, em pé, dizendo: “Envie alguém até a cidade de Jope e traga Simão, que é conhecido como Pedro. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ele lhe dirá coisas pelas quais você e toda a sua família serão salvos”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Quando comecei a falar, o Espírito Santo desceu sobre eles da mesma forma que desceu sobre nós no princípio. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Então me lembrei do que o Senhor tinha dito: “João batizava em água, mas vocês serão batizados no Espírito Santo.” ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Portanto, se Deus deu aos que não eram judeus o mesmo dom que deu a nós quando acreditamos no Senhor Jesus Cristo, quem era eu para impedir a Deus? ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ao ouvirem isto, eles pararam de interrogar a Pedro e louvaram a Deus, dizendo: —Então isso quer dizer que Deus deu a oportunidade de arrependimento para a vida até para os que não são judeus! ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Aqueles que tinham sido espalhados pela perseguição que houve no tempo de Estêvão tinham chegado até às regiões da Fenícia, de Chipre e da Antioquia, mas eles somente proclamavam a mensagem para aqueles que fossem judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Alguns deles, porém, de Chipre e Cirene, quando foram para Antioquia, começaram a falar também aos que não eram judeus. Eles falavam a todos a respeito das Boas Novas sobre o Senhor Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","O poder do Senhor estava com eles e um grande número de pessoas acreditou e se converteu ao Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","A igreja em Jerusalém ficou sabendo das coisas que estavam acontecendo em Antioquia e, então, lhes mandou Barnabé. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ao chegar a Antioquia, Barnabé ficou muito contente quando viu a graça de Deus e encorajou todos a permanecerem fiéis ao Senhor de todo o coração. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ele era um homem bom, cheio do Espírito Santo e de fé, e um grande número de pessoas se uniu ao Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Depois, Barnabé partiu para a cidade de Tarso à procura de Saulo e, ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","quando o encontrou, levou-o consigo para Antioquia. Durante um ano inteiro eles se reuniram com a igreja de lá e ensinaram um grande número de pessoas. Foi também em Antioquia que os discípulos foram chamados cristãos pela primeira vez. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nessa mesma época alguns profetas foram de Jerusalém para Antioquia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ágabo, um desses profetas, se levantou e, pelo poder do Espírito, predisse que haveria uma grande fome em todo o mundo. (Isso aconteceu no tempo em que Cláudio era o Imperador). ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Então todos os discípulos, cada um conforme as suas posses, resolveram enviar socorro aos irmãos que viviam na Judéia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","E assim eles fizeram, e mandaram as suas ofertas aos presbíteros por intermédio de Barnabé e Saulo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nesta ocasião, o rei Herodes prendeu alguns membros da igreja para os maltratar, ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","e mandou matar Tiago, irmão de João, à espada. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Quando percebeu que isto agradava aos judeus, Herodes mandou também prender Pedro. (Isto aconteceu durante os dias da Festa dos Pães Sem Fermento.) ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Depois de tê-lo prendido, Herodes o colocou na prisão, guardado por quatro grupos de soldados com quatro soldados em cada grupo. A sua intenção era de fazê-lo comparecer diante do povo, depois da Páscoa. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pedro estava preso, mas a igreja orava constantemente a Deus por ele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pedro estava dormindo entre dois soldados na noite antes de Herodes apresentá-lo ao povo. Ele estava amarrado com duas correntes e havia guardas vigiando a entrada da prisão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","De repente, um anjo do Senhor apareceu e uma luz brilhou na cela. Ele tocou em Pedro e, acordando-o, disse-lhe: —Levante-se depressa! E nesse mesmo momento as correntes caíram de suas mãos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","O anjo lhe disse: —Vista-se e calce as suas sandálias. Depois de Pedro ter feito isto, o anjo lhe disse: —Vista a sua capa e siga-me. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Então Pedro o seguiu para fora da prisão. Ele não sabia que aquilo que o anjo estava fazendo era real, pois pensava que tudo não passava de uma visão que estava tendo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Depois de terem passado pelo primeiro e pelo segundo guarda, eles chegaram a um portão de ferro que dava para a cidade. Este se abriu sozinho e Pedro e o anjo saíram e continuaram pela rua. Depois, de repente, o anjo desapareceu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Então, Pedro caiu em si e disse: —Agora eu entendo que tudo isto que está acontecendo é real! O Senhor enviou o seu anjo e ele me libertou das mãos de Herodes e de tudo o que os judeus queriam fazer comigo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Quando Pedro entendeu o que estava acontecendo, foi até a casa de Maria, mãe de João, que também é conhecido como Marcos. Lá, muitas pessoas estavam reunidas e orando. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedro bateu à porta e uma empregada chamada Rode foi ver quem era. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ao reconhecer a voz de Pedro, ela ficou tão alegre que, ao invés de abrir a porta, correu para dentro para anunciar que Pedro estava lá fora. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Eles disseram a ela: —Você está louca! Mas, como insistia ela em dizer que era verdade, eles lhe disseram: —É o anjo dele! ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedro, no entanto, continuava a bater. Quando eles abriram a porta e o viram, ficaram espantados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ele fez com a mão um sinal para que fizessem silêncio e lhes explicou como o Senhor o tinha tirado da prisão. Ele disse: —Contem tudo isto a Tiago e aos outros irmãos. Depois partiu e foi para outro lugar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Quando amanheceu o dia, havia uma grande confusão entre os guardas. Eles não sabiam o que pensar sobre o que tinha acontecido com Pedro. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes procurou por Pedro em toda parte, mas não o encontrou. Então, depois de interrogar os guardas, mandou matá-los. Depois disso, Herodes deixou a região da Judéia e foi para a cidade de Cesaréia, onde permaneceu por algum tempo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes estava com muita raiva das pessoas das cidades de Tiro e de Sidom. Então eles formaram um grupo e, depois de terem conseguido o apoio de Blasto, guarda pessoal do rei, foram visitar a Herodes. Foram pedir paz, pois o país deles recebia alimentos do país do rei. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","No dia marcado, Herodes se vestiu com o manto real e, sentando-se em seu trono, fez um discurso para o povo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","O povo gritava: —Isto é a voz de um deus e não de um homem! ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Então, de repente, um anjo do Senhor o feriu, pois ele não tinha dado glória a Deus. Herodes foi comido pelos vermes e morreu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Entretanto, a mensagem do Senhor se espalhava e continuava influenciando cada vez mais pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabé e Saulo terminaram o seu trabalho em Jerusalém e regressaram para a cidade de Antioquia. Eles levaram consigo a João, que era conhecido como Marcos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Havia alguns profetas e professores na igreja de Antioquia. Eles eram: Barnabé; Simeão, que tinha como sobrenome Níger; Lúcio, de Cirene; Manaém, que tinha crescido com o governador Herodes; e Saulo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Enquanto eles estavam servindo ao Senhor e jejuando, o Espírito Santo lhes disse: —Separem para mim Barnabé e Saulo, a fim de que eles façam o trabalho para o qual Eu os chamei. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Então, depois de terem jejuado e orado, puseram as mãos sobre eles e os deixaram partir. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Portanto, tendo sido enviados pelo Espírito Santo, Barnabé e Saulo partiram para a Selêucia e de lá navegaram para Chipre. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Quando chegaram à cidade de Salamina, Barnabé e Saulo anunciaram a mensagem de Deus nas sinagogas dos judeus. (João estava com eles como ajudante.) ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Eles percorreram toda a ilha até chegarem à cidade de Pafos, onde encontraram um judeu mágico, falso profeta, chamado Barjesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ele estava a serviço de Sérgio Paulo, governador da ilha. Este era um homem muito inteligente, e mandou chamar a Barnabé e a Saulo, pois queria ouvir a mensagem de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","O mágico Elimas, porém, estava contra Barnabé e Saulo e tentou desviar o governador da fé. (Elimas era o nome grego de Barjesus.) ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Então Saulo, que também é conhecido como Paulo, cheio do Espírito Santo, olhou bem firme para Elimas e disse: ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","—Filho do Diabo! Você é inimigo de tudo o que é bom! Você está cheio de todo o tipo de malvadezas e malícias. Será que nunca vai parar de distorcer os retos caminhos do Senhor? ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Agora o poder do Senhor está sobre você! Ficará cego e, por algum tempo, não verá o sol. Imediatamente um nevoeiro e uma escuridão caíram sobre ele e começou a dar voltas procurando alguém que o guiasse pela mão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Quando viu o que tinha acontecido, o governador acreditou, admirado com o ensino do Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo e os seus companheiros embarcaram em Pafos e partiram para a cidade de Perge, na região da Panfília. João, porém, deixou-os e voltou para Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Eles continuaram em sua jornada, partindo de Perge e indo para a cidade de Antioquia, na região da Pisídia. No sábado eles foram a uma sinagoga e se sentaram. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Depois de terem lido a lei de Moisés e os livros dos profetas, os líderes da sinagoga mandaram uma mensagem a Paulo e Barnabé, dizendo: —Irmãos, se vocês têm alguma palavra de encorajamento para o povo, falem. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulo, então, se levantou e, fazendo um sinal com a mão, disse: —Homens de Israel e todos vocês que temem a Deus, ouçam! ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","O Deus deste povo de Israel escolheu nossos antepassados e fez deles um grande povo enquanto estavam na terra do Egito. Com o seu grande poder Ele os tirou daquela terra e, ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","por quarenta anos, os suportou no deserto. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ele destruiu sete nações na terra de Canaã e lhes deu essa terra como herança, ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","o que levou quatrocentos e cinqüenta anos. Depois disso, Ele lhes deu juízes até o tempo do profeta Samuel, ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","quando lhe pediram um rei. Deus, então, lhes deu Saul, o filho de Quis, da tribo de Benjamim, que reinou por quarenta anos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Depois de Saul, Deus deu o trono a Davi, de quem testemunhou, dizendo: “Encontrei em Davi, o filho de Jessé, um homem que me agrada. Ele fará tudo que eu quero que faça”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","E Deus, dos descendentes de Davi, de acordo com a sua promessa, trouxe para Israel um Salvador, que é Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Antes da vinda de Jesus, João anunciou a todo o povo de Israel um batismo de arrependimento. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Mas quando João estava prestes a terminar a sua missão, disse: “Quem vocês pensam que eu sou? Eu não sou Ele! Mas, depois de mim virá aquele de quem eu não sou digno nem sequer de desamarrar as sandálias”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","—Irmãos, filhos da família de Abraão, e todos vocês que também temem a Deus! Esta mensagem de salvação foi enviada especialmente para nós. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Os judeus que viviam em Jerusalém e os seus líderes não reconheceram que Jesus era o Salvador e o condenaram. Dessa forma eles fizeram com que se cumprissem as palavras dos profetas que são lidas todos os sábados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","E, apesar de não terem encontrado nada que justificasse uma sentença de morte, pediram a Pilatos que o matasse. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Depois de terem cumprido todas estas coisas que estavam escritas a respeito dele, eles o tiraram da cruz e o colocaram num túmulo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Deus, porém, O ressuscitou dos mortos ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","e, durante muitos dias, Jesus apareceu para aqueles que o tinham acompanhado desde a Galiléia até Jerusalém. Eles agora são testemunhas dele para o povo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","E nós anunciamos as Boas Novas sobre a promessa que Deus fez aos nossos antepassados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","E foi para nós, que somos os filhos desses antepassados, que Deus cumpriu a promessa que havia feito aos nossos pais. Pois assim como está escrito no segundo Salmo: “Você é o meu Filho e hoje eu me tornei seu Pai”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","—E Deus ressuscitou a Jesus dos mortos para que seu corpo nunca entrasse em decomposição, e disse: “Eu darei a vocês as bênçãos santas e certas que prometi a Davi”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","E Deus também diz em outro lugar: “E o Senhor não permitirá que o seu Santo vire pó”. —");
INSERT INTO por_WBTC_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Depois de cumprir os planos de Deus em sua geração, Davi morreu e foi enterrado com seus antepassados. Davi virou pó, ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","mas aquele a quem Deus ressuscitou não entrou em decomposição. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Por isso, irmãos, vocês precisam saber que, por meio de Jesus, é proclamado a vocês o perdão dos pecados. Dessa forma, todas as coisas das quais não podiam ser libertados pela lei de Moisés ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","vocês agora podem, pois todos os que acreditam são livres em Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Portanto, tomem cuidado para que não aconteça com vocês aquilo que os profetas disseram: ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Olhem, vocês que fazem pouco caso! Admirem-se e pereçam! Pois eu vou realizar nos dias de vocês um trabalho no qual nunca acreditarão, nem que alguém lhes diga!” ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Quando Paulo e Barnabé estavam saindo, as pessoas pediram que eles voltassem no sábado seguinte para lhes falar mais a respeito daquelas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Depois da reunião, muitos judeus e pessoas convertidas ao judaismo seguiram a Paulo e a Barnabé, e ambos, ao falarem com as pessoas, os incentivavam a continuar na graça de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","No sábado seguinte, quase que a cidade inteira se reuniu para ouvir a mensagem do Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Quando os judeus viram as multidões, ficaram cheios de inveja e começaram a falar coisas contra o que Paulo dizia e a insultá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paulo e Barnabé, porém, falavam com mais coragem ainda: —Era preciso que a mensagem de Deus fosse dirigida a vocês em primeiro lugar. Mas, como vocês a rejeitam e não se consideram dignos da vida eterna, nós agora nos voltaremos para os que não são judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Pois esta foi a ordem que Deus nos deu: “Eu fiz de você uma luz para as nações, a fim de que possa levar salvação ao mundo inteiro”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ao ouvirem isto, os que não eram judeus ficaram muito felizes e começaram a dar glórias à mensagem do Senhor. E aqueles que tinham sido escolhidos para a vida eterna creram ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","e a mensagem do Senhor se espalhou por toda aquela região. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Os judeus, então, instigaram as senhoras mais importantes que se dedicavam ao judaísmo e os homens de alta posição na cidade, e eles começaram a perseguir a Paulo e Barnabé, forçando-os a sair daquela região. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Eles sacudiram a poeira de seus pés como uma advertência contra eles e foram embora para Icônio. ");
INSERT INTO por_WBTC_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Quanto aos discípulos, eles estavam cheios de alegria e do Espírito Santo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Em Icônio, como de costume, Paulo e Barnabé foram para a sinagoga dos judeus. Ao chegarem lá, falaram de tal maneira que uma grande multidão, formada tanto de judeus como de não judeus, creu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Os judeus que não tinham acreditado, porém, incitaram os que não eram judeus a pensar coisas más contra os irmãos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Eles se mantiveram lá por muito tempo e falaram, sem medo nenhum, em nome do Senhor. E o Senhor, confirmando a mensagem da sua graça, permitia que muitos sinais milagrosos e coisas maravilhosas fossem feitas pelas mãos deles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","A população da cidade estava dividida: Uns estavam do lado dos judeus e outros do lado dos apóstolos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Então, os judeus e os que não eram judeus, juntamente com os seus líderes, fizeram planos para maltratar Barnabé e Paulo e para apedrejá-los. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Quando souberam disso, os missionários fugiram para Listra e Derbe, cidades da Licaônia, e para os seus arredores. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Lá eles continuaram a proclamar as Boas Novas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Havia em Listra um homem que estava sempre sentado, pois era aleijado dos pés. Ele era paralítico de nascença e nunca tinha andado. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Este homem ouviu a Paulo falando e, quando Paulo olhou bem para ele, viu que ele tinha fé em ser curado. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Então Paulo disse em voz alta: —Levante-se! Fique de pé! O homem deu um pulo e começou a andar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Quando as pessoas da multidão viram o que Paulo tinha feito, gritaram em língua licaônica, dizendo: —Os deuses se transformaram em homens e desceram até nós. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Eles começaram a chamar a Barnabé de Júpiter e Paulo de Mercúrio, pois ele era o principal orador. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","O templo do deus Júpiter ficava bem perto da cidade. O seu sacerdote trouxe touros e coroas de flores para os portões da cidade, pois tanto ele como a multidão queriam oferecer sacrifícios a Paulo e a Barnabé. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Quando os apóstolos Barnabé e Paulo ouviram isso, rasgaram as suas roupas e correram para a multidão, ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","gritando e dizendo: —Homens, por que vocês estão fazendo isso? Nós também somos apenas homens, seres humanos como vocês! Nós estamos aqui para lhes dizer as Boas Novas, a fim de que vocês deixem essas coisas que não valem nada e se voltem para o Deus vivo, que fez o céu, a terra, o mar e tudo o que existe neles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","No passado, Deus deixou que todas as nações andassem nos seus próprios caminhos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Mas, nem por isso Ele as deixou sem qualquer evidência de quem Ele é, pois Ele tem feito boas coisas a todos. Ele tem dado chuva do céu e colheitas nos tempos certos. Ele não deixa que lhes falte comida, e enche os corações de vocês de alegria. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mesmo com estas palavras foi muito difícil impedir que a multidão oferecesse sacrifícios a eles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Depois disto, alguns judeus que tinham vindo de Antioquia e de Icônio convenceram as multidões e, juntos, apedrejaram a Paulo e o arrastaram para fora da cidade pensando que ele estivesse morto. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Quando os discípulos se juntaram ao seu redor, ele se levantou e voltou para a cidade. No dia seguinte ele e Barnabé partiram para Derbe. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Eles proclamaram as Boas Novas naquela cidade e fizeram muitos discípulos. Depois eles voltaram para as regiões de Listra, Icônio e Antioquia, sempre ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","fortalecendo as almas dos discípulos e encorajando-os a continuar na fé. Eles diziam: —Nós temos que passar por muitas aflições para podermos entrar no reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Eles nomearam presbíteros em cada igreja e, orando e jejuando, os entregaram ao Senhor em quem acreditavam. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Depois de Paulo e Barnabé terem passado pela região da Pisídia, chegaram até a região da Panfília. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Lá, depois de anunciarem a mensagem em Perge, foram para a Atália. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Dali eles navegaram para Antioquia onde tinham sido entregues aos cuidados de Deus para o trabalho que tinham agora terminado. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ao chegarem, eles reuniram toda a igreja e contaram tudo o que Deus havia feito por meio deles e como Deus tinha aberto as portas da fé para aqueles que não eram judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","E por muito tempo eles permaneceram lá com os discípulos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Alguns homens que tinham vindo da região da Judéia estavam ensinando os irmãos e diziam: —Se vocês não forem circuncidados, de acordo com o costume de Moisés, não poderão ser salvos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulo e Barnabé não concordavam com isso, e tiveram uma discussão muito forte com eles. Resolveu-se, então, mandar Paulo, Barnabé e alguns dos outros para Jerusalém a fim de falarem com os apóstolos e presbíteros a respeito dessa questão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Eles foram enviados pela igreja e atravessaram as regiões da Fenícia e de Samaria onde, falando a respeito da conversão dos que não eram judeus, causaram grande alegria entre os irmãos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Quando chegaram a Jerusalém, eles foram recebidos pela igreja, pelos apóstolos e pelos presbíteros e lhes contaram todas as coisas que Deus tinha feito por meio deles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Porém alguns dos fariseus que tinham crido se levantaram e disseram: —É necessário que eles sejam circuncidados e que obedeçam à lei de Moisés. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Os apóstolos e os presbíteros se reuniram para considerar esta questão ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","e, depois de uma longa discussão, Pedro se levantou e lhes disse: —Irmãos, vocês sabem que no começo Deus me escolheu para que, pela minha boca, os que não são judeus pudessem ouvir a mensagem das Boas Novas e acreditar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","E Deus, que conhece os corações das pessoas, mostrou que os aprovava dando a eles o Espírito Santo, exatamente da mesma forma que Ele fez conosco. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ele não fez nenhuma diferença entre nós e eles, purificando os corações deles por causa de sua fé. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Por que agora vocês querem colocar Deus à prova, pondo sobre os ombros dos discípulos uma carga que nem nós nem nossos antepassados fomos capazes de carregar? ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nós acreditamos que somos salvos pela graça do Senhor Jesus, exatamente como eles são. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Todos os que estavam na assembléia fizeram silêncio e escutaram a Barnabé e a Paulo enquanto eles descreviam todos os sinais e maravilhas que Deus tinha feito por meio deles entre os que não eram judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Quando acabaram de falar, Tiago disse: —Irmãos, escutem-me. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simão nos contou como Deus mostrou o seu amor pelos que não são judeus, pois Ele os aceitou e escolheu, dentre eles, um povo para ser o seu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","E as palavras dos profetas conferem com isto, pois está escrito: ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Depois disto Eu voltarei e reconstruirei a casa de Davi que caiu. Eu restaurarei os seus pedaços e tornarei a levantá-la, ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","para que o resto do mundo possa procurar ao Senhor, isto é, todos os que não são judeus e que são chamados pelo meu nome. Assim diz o Senhor ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","que faz estas coisas que têm sido conhecidas desde a eternidade”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","—Portanto, eu julgo que nós não deveríamos causar problemas para aqueles que não são judeus e que estão se convertendo a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ao invés disso, deveríamos escrever para eles dizendo-lhes que não comam aquela comida que ficou contaminada por ser oferecida aos ídolos, que não cometam imoralidade sexual, que não comam nada estrangulado e nem sangue. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Pois ainda há aqueles que, há muito tempo, vêm anunciando as palavras de Moisés nas sinagogas de todas as cidades, onde também é lida a sua lei todos os sábados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Então os apóstolos e presbíteros, juntamente com toda a igreja, decidiram escolher entre eles alguns homens para mandá-los para a cidade de Antioquia com Paulo e Barnabé. Os escolhidos foram: Judas (conhecido como Barsabás) e Silas, líderes entre os irmãos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","E eles também enviaram esta carta por meio deles: “Nós, os apóstolos e presbíteros, irmãos de vocês, mandamos saudações aos irmãos que não são judeus das cidades de Antioquia, Síria e Cilícia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nós soubemos que alguns homens do nosso grupo foram até aí sem a nossa autorização e os preocuparam com suas palavras, perturbando as mentes de vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nós todos chegamos a um acordo e decidimos escolher alguns homens e enviá-los a vocês com os nossos amados irmãos Barnabé e Paulo, ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","que arriscaram suas próprias vidas pelo nome do nosso Senhor Jesus Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nós lhes estamos enviando Judas e Silas, e eles lhes dirão estas mesmas coisas pessoalmente. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Pareceu bem ao Espírito Santo e a nós não pôr nenhuma carga sobre vocês, a não ser as coisas que são de fato necessárias, como estas: ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Vocês não devem comer comidas oferecidas a ídolos, sangue, ou ainda animais que tenham sido estrangulados. Vocês também não devem cometer imoralidades sexuais. Vocês farão bem se ficarem longe dessas coisas. Passem bem”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Então eles partiram e foram para a cidade de Antioquia. Lá eles reuniram a congregação e lhes entregaram a carta. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Depois de ela ter sido lida pelos irmãos, todos ficaram muito contentes pelas palavras de encorajamento que a carta trouxe. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas e Silas, que eram ambos profetas, falaram aos irmãos por muito tempo, encorajando-os e fortalecendo-os. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Depois de terem passado algum tempo ali, os irmãos os enviaram de volta em paz, para que eles voltassem para aqueles que os tinham enviado. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo e Barnabé permaneceram ainda algum tempo na cidade de Antioquia e, juntamente com muitos outros, ensinavam e proclamavam a mensagem do Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Alguns dias mais tarde, Paulo disse a Barnabé: —Vamos voltar e visitar os irmãos em todas as cidades onde já anunciamos a mensagem do Senhor para ver como eles estão indo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabé queria levar a João (que é conhecido como Marcos) com eles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Mas Paulo achava que seria melhor não levá-lo, pois ele já os tinha abandonado em Panfília uma vez e não os tinha acompanhado no trabalho. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","O desacordo entre eles foi tão forte que se separaram. Barnabé levou Marcos e navegou para a ilha de Chipre. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulo escolheu a Silas e partiu, depois de ter sido entregue pelos irmãos aos cuidados do Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Paulo passou pelas regiões da Síria e da Cilícia, sempre fortalecendo as igrejas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Depois, Paulo chegou à região das cidades de Derbe e Listra, onde encontrou o discípulo chamado Timóteo. Ele era filho de uma mulher judia e que também era uma discípula e o seu pai era grego. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Os irmãos das cidades de Listra e de Icônio falavam muito bem dele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Então Paulo, querendo levá-lo consigo, circuncidou-o, por causa dos judeus que estavam naqueles lugares (pois todos sabiam que o pai dele era grego). ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","E conforme passavam pelas cidades, eles entregavam as decisões tomadas pelos apóstolos e pelos presbíteros em Jerusalém, aconselhando-os a obedecerem a essas decisões. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Dessa forma as igrejas se fortaleciam na fé e cresciam em número a cada dia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Eles passaram pelas regiões da Frígia e da Galácia, mas foram impedidos pelo Espírito Santo de proclamar a mensagem na Ásia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Quando chegaram perto da fronteira da Mísia, eles tentaram ir para a cidade de Bitínia, mas o Espírito de Jesus não deixou que eles fossem. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Então eles atravessaram Mísia e chegaram a Trôade. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Durante a noite, Paulo teve uma visão. Ele viu um homem da Macedônia de pé que lhe implorava: —Venha para a Macedônia e ajude-nos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Logo depois de Paulo ter tido a visão, nós imediatamente procuramos partir para a Macedônia, pois concluímos que Deus nos tinha chamado para proclamar as Boas Novas ao povo de lá. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nós embarcamos no porto de Trôade e seguimos diretamente para a ilha de Samotrácia e, no dia seguinte navegamos para Neápolis. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","De lá seguimos para Filipos, onde permanecemos por vários dias. Filipos é a cidade mais importante daquela região da Macedônia e é também colônia romana. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","No sábado fomos até o rio que ficava fora dos portões da cidade, pois pensamos que lá acharíamos um lugar de oração. Nos sentamos e começamos a falar com as mulheres que estavam lá reunidas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Uma das mulheres presentes chamava-se Lídia, e era negociante de roupas finas da cidade de Tiatira. Ela temia a Deus e estava nos escutando; o Senhor abriu-lhe o coração para que ela prestasse atenção às coisas que Paulo dizia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Depois de ela e de todas as pessoas de sua casa terem sido batizadas, ela nos convidou, dizendo: —Se vocês acham que eu sou fiel ao Senhor, então fiquem em minha casa. E ela nos convenceu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Aconteceu que, quando estávamos indo para o lugar de oração, uma jovem escrava veio ao nosso encontro. Ela tinha um espírito oracular e dava muitos lucros aos seus donos, adivinhando o futuro. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ela seguia a Paulo e a nós e gritava: —Estes homens são servos do Deus Altíssimo! Eles estão anunciando a vocês o caminho da salvação! ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Isso se repetiu por vários dias até que Paulo, ficando aborrecido, virou-se e disse ao espírito: —Em nome de Jesus Cristo eu lhe ordeno que saia dela! E naquele mesmo instante o espírito saiu dela. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Quando os donos da escrava viram que sua fonte de lucros tinha secado, agarraram a Paulo e a Silas e os arrastaram à praça pública, diante das autoridades. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Eles os levaram para os oficiais romanos e disseram: —Estes homens são judeus e estão fazendo desordens em nossa cidade! ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Eles estão ensinando costumes que estão fora da nossa lei e que nós, os romanos, não podemos aceitar nem tampouco praticar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","A multidão se juntou para atacá-los e os oficiais romanos, então, rasgaram as roupas de Paulo e de Silas e mandaram que eles fossem açoitados com varas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Depois de terem batido bastante neles, os oficiais os atiraram na prisão e ordenaram ao carcereiro que os vigiasse com toda a segurança. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Depois de receber tal ordem, o carcereiro os levou para a prisão interior e prendeu os pés deles em pedaços de madeira pesados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mais ou menos à meia-noite, Paulo e Silas estavam orando e cantando hinos a Deus, enquanto os outros prisioneiros os escutavam. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","De repente, houve um terremoto tão grande que abalou até os alicerces da prisão. Nesse instante todas as portas se abriram e quebraram-se todas as correntes que prendiam os presos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","O carcereiro acordou e, quando viu as portas da prisão abertas, pensou que os prisioneiros tinham fugido. Então, tirou a espada para se matar, ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","mas Paulo gritou, dizendo: —Não faça nenhum mal a si mesmo, pois estamos todos aqui. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","O carcereiro, então, pediu luz e, entrando depressa, ajoelhou-se aos pés de Paulo e Silas tremendo de medo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Depois, levando-os para fora, disse-lhes: —Senhores, o que devo fazer para ser salvo? ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Eles disseram: —Creia no Senhor Jesus e você será salvo, você e toda a sua casa. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","E lhe anunciaram a mensagem do Senhor, como também a todos os que estavam em sua casa. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","O carcereiro os levou, àquela hora da noite mesmo, e lavou os ferimentos deles. Logo depois ele e todos os da sua família foram batizados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Depois ele levou Paulo e Silas para sua casa e lhes deu comida. Então, tanto ele como toda a sua família ficaram muito felizes por terem acreditado em Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Assim que amanheceu, os oficiais romanos enviaram alguns de seus guardas, dizendo: “Soltem esses homens”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Então, o carcereiro disse estas palavras a Paulo: —Os oficiais romanos mandaram soltar vocês. Vocês podem ir em paz, agora. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mas Paulo disse aos guardas: —Nós somos cidadãos romanos, mas mesmo assim, sem um processo formal, eles nos açoitaram publicamente e nos jogaram na prisão. Agora eles querem nos mandar embora às escondidas? Isso não! Eles que venham até aqui em pessoa e nos soltem! ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Os guardas disseram estas coisas para os oficiais romanos, e estes ficaram com medo quando souberam que eles eram cidadãos romanos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Então os oficiais foram pedir desculpas a eles e, depois de libertá-los, pediram-lhes que saíssem da cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ao saírem da prisão, Paulo e Silas foram para a casa de Lídia. Lá eles encontraram os irmãos e, depois de encorajá-los, foram embora. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Depois de terem passado por Anfípolis e Apolônia, Paulo e Silas chegaram a Tessalônica, onde havia uma sinagoga de judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulo foi até lá, como era seu costume fazer e, durante três sábados, discutiu as Escrituras com os judeus, ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","explicando e provando a eles que Jesus tinha de sofrer e ressuscitar dos mortos. Ele dizia: —Este Jesus que eu estou anunciando a vocês é o Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Alguns deles ficaram persuadidos e se juntaram a Paulo e Silas. Juntaram-se a eles também um grande número de gregos que temiam a Deus e muitas mulheres importantes. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Os judeus, porém, ficaram com muita inveja e, juntando alguns malandros de rua, formaram um grupo de desordeiros. Esse grupo agitou a cidade e atacou a casa de Jasom à procura de Paulo e Silas para entregá-los ao povo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Não os encontrando lá, o grupo arrastou a Jasom e a alguns dos irmãos para as autoridades da cidade. Eles gritavam: —Estes homens que têm transtornado o mundo chegaram também aqui. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Eles estão hospedados na casa de Jasom e todos desobedecem às leis de César, dizendo que há um outro rei, Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ao ouvirem essas coisas, tanto a multidão como as autoridades da cidade ficaram muito agitadas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Então, fizeram Jasom e os irmãos pagarem uma fiança e depois os soltaram. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Assim que anoiteceu, os irmãos fizeram com que Paulo e Silas partissem para a cidade de Beréia. Ao chegarem lá, eles foram para a sinagoga dos judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","As pessoas daquela cidade eram mais nobres do que as de Tessalônica, pois receberam a mensagem com grande entusiasmo. Eles examinavam as Escrituras todos os dias para ver se o que Paulo dizia era realmente verdadeiro. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Com isso muitos deles acreditaram, juntamente com muitas mulheres gregas importantes e muitos homens gregos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Quando os judeus de Tessalônica souberam que Paulo estava em Beréia proclamando a mensagem de Deus, foram até lá para promover desordens entre o povo e para agitá-lo contra Paulo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Os irmãos, então, imediatamente, mandaram Paulo para o litoral, mas Silas e Timóteo ficaram em Beréia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Aqueles que eram responsáveis por Paulo levaram-no até a cidade de Atenas. Depois eles partiram levando instruções para que Silas e Timóteo fossem encontrá-lo em Atenas o mais depressa possível. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Enquanto Paulo esperava por Timóteo e Silas em Atenas, o seu espírito se revoltou, pois ele viu que a cidade estava cheia de ídolos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Na sinagoga ele discutia com os judeus e com os gregos que temiam a Deus. E todos os dias, na praça principal, discutia com aqueles que se encontravam ali. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Um grupo de filósofos epicureus e estóicos começaram a discutir com ele, e alguns diziam: —O que esse tagarela está querendo dizer? Outros diziam: —Parece que ele está anunciando deuses estranhos. (Eles diziam isso porque Paulo estava falando a respeito de Jesus e da ressurreição). ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Paulo, então, foi levado até o Areópago. Lá eles lhe disseram: —Podemos saber que novo ensino é esse que você está nos apresentando? ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Você está trazendo coisas estranhas aos nossos ouvidos e, por isso, gostaríamos de saber o que elas significam. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Eles fizeram isso porque tanto os atenienses como os estrangeiros que lá viviam não faziam mais nada a não ser contar ou ouvir a respeito das últimas novidades). ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulo, então, se levantou no Areópago e disse: —Homens de Atenas! Vejo que vocês são bastante religiosos em tudo, pois, ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ao andar por aqui observei os objetos de adoração de vocês. Eu encontrei até mesmo um altar no qual estava escrito: “Ao deus desconhecido”. E é esse Deus—que vocês adoram mas que desconhecem—que eu estou anunciando a vocês. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Esse Deus fez o mundo e tudo o que nele existe e, desde que Ele é o Senhor do céu e da terra, Ele não mora em templos feitos por mãos humanas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ele não é servido por mãos humanas como se precisasse de alguma coisa, mas é Ele quem dá vida, respiração e tudo o mais a todos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ele fez todas as raças de homens de um só homem para que eles habitassem toda a terra, e determinou também os tempos e as fronteiras dos lugares onde eles viveriam. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ele fez isso com a esperança de que os homens buscassem a Deus e que, procurando, o encontrassem, pois Ele não está longe de nenhum de nós. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","“Nele vivemos, nos movemos e existimos” e assim como também alguns dos próprios poetas de vocês disseram: “Somos filhos dele”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Portanto, desde que somos filhos de Deus, não deveríamos pensar que a divindade é como ouro, prata ou pedra, trabalhados pela arte e pela imaginação do homem. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","No passado Deus não levou em conta tal ignorância. Agora, porém, Ele manda que todas as pessoas em todos os lugares se arrependam de seus pecados, ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","pois Ele tem um dia reservado, no qual irá julgar o mundo. Ele julgará o mundo com justiça, por meio de um homem que ele apontou e aprovou diante de todos, ressuscitando-o dos mortos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Quando ouviram Paulo falar a respeito de ressurreição dos mortos, alguns deles riram, outros, porém, disseram: —Queremos ouvir você falar sobre isto numa outra ocasião. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Paulo, então, foi embora dali. ");
INSERT INTO por_WBTC_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Algumas pessoas juntaram-se a ele e acreditaram. Entre eles estavam Dionísio, que era membro do Areópago, uma mulher chamada Dâmaris e alguns outros. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Depois disto, Paulo deixou a cidade de Atenas e foi para Corinto. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Lá ele encontrou um judeu chamado Áqüila, natural da região do Ponto. Ele e sua esposa, Priscila, tinham vindo da Itália há pouco tempo, porque o imperador Cláudio tinha decretado que todos os judeus saíssem de Roma. Paulo, então, foi visitá-los e ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","acabou ficando ali para trabalhar com eles, pois tinham a mesma profissão—fazer tendas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Todos os sábados Paulo discutia na sinagoga e tentava convencer tanto os judeus como aqueles que não eram judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Quando Silas e Timóteo chegaram da Macedônia, Paulo passou a dedicar todo o seu tempo à proclamação da mensagem, testemunhando aos judeus que Jesus é o Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Quando os judeus se opuseram a Paulo e o insultaram, ele sacudiu a poeira de suas roupas como uma advertência contra eles e lhes disse: —Se vocês se perderem, a culpa será somente de vocês. A minha consciência está tranqüila e, de agora em diante, eu irei para os que não são judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","E, saindo dali, Paulo foi para a casa de Tício Justo, homem temente a Deus e que morava ao lado da sinagoga. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Tanto Crispo, o chefe da sinagoga, como toda a sua família, creram no Senhor. Muitos dos coríntios, que também ouviram a Paulo, creram e foram batizados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Uma noite o Senhor disse a Paulo em sonho: —Não tenha medo. Continue falando às pessoas e não desista, ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","pois eu estou com você. Ninguém lhe atacará ou lhe fará mal, porque tenho muitas pessoas nesta cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Então Paulo permaneceu ali por um ano e meio, ensinando a mensagem de Deus entre eles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Quando Gálio era governador da Acaia, os judeus, num esforço conjunto, atacaram a Paulo e o levaram ao tribunal, ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","dizendo: —Este homem está convencendo o povo a adorar a Deus de maneira contrária à lei. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Quando Paulo ia falar, Gálio disse aos judeus: —Se isto fosse uma injustiça ou um crime sério, seria razoável que eu os escutasse. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mas desde que isto é uma questão a respeito de palavras, de nomes, e da própria lei de vocês, vocês que a resolvam por si mesmos. Eu me recuso a ser juiz em casos deste tipo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","E os expulsou do tribunal. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Então, todos eles agarraram a Sóstenes, o chefe da sinagoga, e o espancaram em frente do tribunal. Gálio, entretanto, nem se incomodava com isso. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo permaneceu ali ainda por vários dias, mas depois despediu-se dos irmãos e navegou para a Síria, juntamente com Priscila e Áqüila. Em Cencréia Paulo raspou a cabeça, pois tinha feito uma promessa a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Depois eles chegaram à cidade de Éfeso, onde Paulo deixou a Priscila e Áqüila. Ele mesmo, porém, entrando na sinagoga, discutia com os judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Estes lhe pediram para que ficasse com eles por mais tempo, mas Paulo recusou e, ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ao partir, disse: —Se Deus quiser, eu voltarei. E partiu da cidade de Éfeso. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Depois de chegar a Cesaréia, ele foi para Jerusalém. Ali cumprimentou a igreja e, em seguida, partiu para a cidade de Antioquia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Depois de ter permanecido lá por algum tempo, Paulo partiu e viajou de cidade em cidade por toda a região da Galácia e da Frígia, fortalecendo a todos os discípulos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nesse meio tempo, chegou a Éfeso um judeu chamado Apolo, natural da cidade de Alexandria. Ele era um bom orador e conhecia muito bem as Escrituras. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ele tinha sido instruído no caminho do Senhor; falava com bastante entusiasmo e ensinava de maneira correta a respeito de Jesus, apesar de conhecer somente o batismo de João. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ele falava sem medo na sinagoga e, quando Priscila e Áqüila o ouviram, chamaram-no de lado e lhe explicaram melhor o caminho de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo, então, quis ir para a região da Acaia. Os irmãos o encorajaram e escreveram aos discípulos de lá pedindo que o recebessem bem quando ele chegasse. Ele foi uma grande ajuda para aqueles que, pela graça, tinham acreditado, ");
INSERT INTO por_WBTC_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","pois derrotava os argumentos dos judeus em público e com muita coragem, provando pelas Escrituras que Jesus é o Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Enquanto Apolo estava na cidade de Corinto, Paulo viajou pelo interior do continente e chegou até Éfeso. Lá encontrou alguns discípulos e ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","perguntou-lhes: —Vocês receberam o Espírito Santo quando creram? Eles lhe responderam: —Nós nem sequer ouvimos dizer que existe um Espírito Santo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulo lhes perguntou: —Então, que tipo de batismo vocês receberam? Eles responderam: —O batismo de João. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo disse: —O batismo de João era um batismo baseado em arrependimento; ele dizia que as pessoas deviam acreditar naquele que viria depois dele, isto é, em Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Quando ouviram isto, eles foram batizados em nome do Senhor Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","E, quando Paulo colocou suas mãos sobre eles, o Espírito Santo veio sobre todos e eles começaram a falar em línguas e a profetizar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Eram ao todo uns doze homens. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Durante três meses Paulo continuou a ir à sinagoga, onde com muita coragem discutia e tentava convencer a todos a respeito do reino de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Alguns deles, porém, eram teimosos, se recusavam a acreditar e, ainda por cima, falavam coisas más a respeito do Caminho do Senhor na frente de todos. Por isso, Paulo os deixou e foi-se embora, levando consigo os discípulos. Depois começou a ensinar todos os dias na escola de um homem chamado Tirano. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","E continuou a fazer isso durante dois anos, até que todas as pessoas que viviam na região da Ásia (tanto os judeus como os que não eram judeus) ouviram a mensagem do Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Deus fazia milagres tão grandes pelas mãos de Paulo ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","que até mesmo lenços e roupas do seu uso pessoal eram levados aos doentes e eles ficavam curados e os demônios se retiravam. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Alguns judeus que viajavam de cidade em cidade expulsando demônios, tentaram usar o nome do Senhor Jesus para libertar aqueles que estavam possuídos por demônios. Eles disseram: —Eu lhes ordeno que saiam, em nome de Jesus, a quem Paulo proclama. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","(Os sete filhos de um judeu chamado Ceva, que era sumo sacerdote, estavam fazendo isto.) ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Mas o demônio lhes disse: —Eu conheço a Jesus e sei quem é Paulo, mas quem são vocês? ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","E o homem que tinha esse demônio se lançou sobre eles e, dominando a todos, bateu neles até que fugiram daquela casa, nus e feridos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Todos os moradores de Éfeso, tanto os judeus como os que não eram judeus, souberam dessas coisas e ficaram com muito medo. Isso fez com que o nome do Senhor Jesus fosse ainda mais respeitado. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Muitos dos que tinham acreditado vieram e confessaram publicamente os pecados que tinham cometido. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","E muitos daqueles que costumavam praticar bruxarias trouxeram os seus livros e os queimaram na frente de todos. Depois de calcular os preços dos livros, o total chegou a cinqüenta mil moedas de prata. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Desta maneira poderosa a mensagem do Senhor se espalhava por toda parte e influenciava mais e mais pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Depois de todas estas coisas terem acontecido, Paulo decidiu ir até a cidade de Jerusalém, após passar pelas regiões da Macedônia e Acaia. E ele também dizia: —Depois de Jerusalém eu ainda tenho que visitar Roma. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Paulo, então, enviou para a região da Macedônia dois de seus ajudantes, Timóteo e Erasto, enquanto ele mesmo permanecia na Ásia por mais algum tempo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nessa ocasião houve um grande tumulto na cidade de Éfeso por causa do Caminho do Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","25","Tudo começou quando Demétrio, um ourives, convocou uma reunião com todos os que estavam envolvidos em trabalhos desse tipo. (Essas pessoas faziam miniaturas de prata do templo da deusa Diana e esse negócio lhes dava muito lucro). Demétrio disse a todos: —Homens! Vocês sabem que este trabalho nos dá um bom lucro. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Como vocês podem ver e ouvir, esse tal de Paulo anda persuadindo e desencaminhando muita gente, dizendo que os deuses feitos por mãos humanas não são deuses. E isso vem acontecendo não só em Éfeso, mas também em quase toda a região da Ásia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Isso é muito perigoso, pois pode trazer má fama para os nossos negócios. E também pode fazer com que o templo da grande deusa Diana perca todo o seu prestígio. Há ainda o perigo de que a majestade de Diana—deusa adorada não somente na Ásia como também em todo o mundo—seja destruída. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ao ouvirem isto, todos ficaram furiosos e começaram a gritar: —Viva a grande Diana dos Efésios! ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","E a confusão tomou conta da cidade! A multidão agarrou os macedônios Gaio e Aristarco, companheiros de viagem de Paulo, e correram para o teatro. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo queria se apresentar ao povo, mas os discípulos não deixaram. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Alguns amigos de Paulo, autoridades provinciais, mandaram-lhe um recado pedindo-lhe que não fosse ao teatro. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Algumas pessoas gritavam uma coisa, outras gritavam outra e toda a assembléia estava numa total confusão. A maior parte deles não sabia nem a razão de estarem todos reunidos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Então os judeus empurraram Alexandre para a frente e alguns que estavam entre a multidão lhe deram instruções sobre o que falar. Alexandre fez um sinal com a mão e tentou explicar ao povo o que estava acontecendo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Quando as pessoas da multidão, porém, se deram conta de que ele também era judeu, puseram-se a gritar todos juntos: —Viva a grande Diana dos Efésios! E isto durou mais ou menos duas horas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Então o secretário da cidade acalmou a multidão e disse: —Povo de Éfeso! Há alguém no mundo que não saiba que a cidade de Éfeso é a guardiã do templo da grande Diana e da pedra sagrada que caiu do céu? ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Desde que ninguém pode negar isso, então fiquem calmos e não façam nada precipitadamente. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Por que vocês trouxeram estes homens até aqui? Eles não roubaram nenhum templo e tampouco disseram coisas más a respeito da nossa deusa! ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Se Demétrio e seus companheiros têm alguma acusação contra alguém, os tribunais estão abertos e, além do mais, existem os governadores. Eles que se acusem uns aos outros lá. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mas, se vocês querem saber mais alguma coisa, isso tem que ser resolvido em uma assembléia legal. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Do jeito que as coisas estão, há o perigo de sermos acusados de subversão pelo que aconteceu hoje. Pois não há motivo algum que possamos alegar para justificar este alvoroço. ");
INSERT INTO por_WBTC_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","E, depois de dizer isto, despediu a assembléia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Quando terminou o alvoroço, Paulo chamou os discípulos e, depois de encorajá-los, despediu-se deles e partiu para a Macedônia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ele viajou por todas aquelas regiões transmitindo-lhes muitas palavras de encorajamento. Depois foi para a região da Grécia, ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","onde permaneceu por três meses. Ele estava pronto para embarcar para a Síria quando ficou sabendo de um plano que os judeus tinham contra ele, então resolveu voltar para a Síria passando novamente pela Macedônia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Estavam viajando com Paulo: Sópatro, filho de Pirro, da cidade de Beréia; Aristarco e Secundo, de Tessalônica; Gaio, da cidade de Derbe; Timóteo, e também Tíquico e Trófimo, da região da Ásia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Estes foram à nossa frente e esperaram por nós na cidade de Trôade. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Depois da Festa dos Pães sem Fermento, navegamos de Filipos e, em cinco dias, encontramos com eles em Trôade. Lá passamos uma semana. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","No primeiro dia da semana, nós nos reunimos para partir o pão. Paulo ia viajar no dia seguinte e, como estávamos reunidos, começou a falar com eles e continuou falando até a meia-noite. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Na sala onde estávamos, no andar de cima, havia muitas lamparinas acesas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Um jovem chamado Êutico estava sentado no parapeito da janela e pegou num sono profundo durante o prolongado discurso de Paulo. Depois de estar completamente dominado pelo sono, o jovem caiu do terceiro andar e, quando o levantaram, ele já estava morto. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulo desceu até onde estava Êutico, abraçou-o e disse: —Não se preocupem, pois o rapaz está vivo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Em seguida ele voltou para o andar de cima, repartiu o pão e comeu. Depois continuou a falar até raiar o dia, quando partiu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Quanto ao jovem Êutico, este foi levado para casa vivo e todos ficaram grandemente confortados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nós partimos antes de Paulo, embarcando para o porto de Assôs, onde deveríamos recebê-lo a bordo. Ele mesmo combinou assim, pois pretendia chegar até Assôs por terra. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Quando Paulo se encontrou conosco em Assôs, nós o recebemos a bordo e partimos para a cidade de Mitilene. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Partimos de lá no dia seguinte e paramos defronte da ilha de Quios. No outro dia atravessamos para a ilha de Samos e no dia seguinte chegamos à cidade de Mileto. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo tinha decidido não passar pela cidade de Éfeso, pois não queria se demorar na Ásia. A sua intenção era chegar à cidade de Jerusalém, se possível, antes do dia de Pentecostes. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","De Mileto ele mandou chamar os presbíteros da igreja de Éfeso. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Quando eles chegaram, Paulo lhes disse: —Vocês sabem como eu me comportei durante todo o tempo que estive com vocês, desde o primeiro dia que cheguei na Ásia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Eu servi ao Senhor com toda a humildade, com lágrimas, apesar dos muitos problemas que tive por causa das ciladas que os judeus me prepararam. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Vocês sabem que eu não hesitei em lhes anunciar nada, desde que fosse para o bem de vocês, e de como lhes ensinei tanto publicamente como de casa em casa. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Testemunhei tanto aos judeus como aos que não são judeus a respeito de como era necessário que eles se arrependessem, que voltassem a Deus e que tivessem fé em nosso Senhor Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","E agora vou para Jerusalém, obrigado pelo Espírito, sem saber o que vai me acontecer por lá. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","A única coisa que sei é que em todas as cidades o Espírito Santo me avisa que prisões e sofrimentos estão à minha espera. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Porém, não dou valor à minha própria vida a fim de poder terminar a corrida e a missão que recebi do Senhor Jesus para testemunhar a respeito das Boas Novas da graça de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","—E agora sei que nenhum de vocês, em cujo meio passei anunciando o reino de Deus, me verá novamente. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Portanto, quero dizer-lhes hoje que sou inocente do sangue de todos vocês, ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","pois não hesitei em proclamar-lhes toda a vontade de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Estejam alerta e cuidem tanto de vocês mesmos como também de todo o rebanho sobre o qual o Espírito Santo os constituiu bispos, para pastorearem a igreja de Deus, a qual Ele comprou com o seu próprio sangue. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Digo isto porque sei que, depois que eu for embora, lobos ferozes aparecerão entre vocês e não terão pena do rebanho. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","E até mesmo dentre o próprio grupo de vocês, surgirão homens falando coisas erradas para arrastar os discípulos atrás deles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Portanto, cuidado! Lembrem-se de que durante três anos eu nunca deixei de avisar a nenhum de vocês, quer fosse de dia ou de noite, e mesmo com lágrimas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","—Agora portanto, eu os entrego a Deus e à mensagem da sua graça, pois ela é capaz de fortalecê-los e de lhes dar a herança entre todo o povo santo de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Não cobicei nem a prata, nem o ouro e nem a roupa de ninguém, ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","e vocês mesmos sabem como trabalhei com minhas próprias mãos para ter o necessário não só para mim como também para os meus companheiros. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Em tudo lhes mostrei que, trabalhando assim, devemos ajudar os necessitados e recordar as palavras do próprio Senhor Jesus: “Quem dá é mais feliz do que quem recebe”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Depois de ter dito todas essas coisas, ele se ajoelhou e orou com todos eles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","E todos choraram muito e o abraçaram e beijaram, ");
INSERT INTO por_WBTC_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","pois estavam muito tristes pelo fato de Paulo dizer que eles não voltariam a vê-lo. Depois disso, eles o acompanharam até o navio. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Depois de termos nos separado deles, embarcamos diretamente para a ilha de Cós. No dia seguinte, chegamos em Rodes e, de lá, seguimos para Pátara. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Lá encontramos um navio que ia para a Fenícia. Embarcamos nele e seguimos viagem. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Passamos pela ilha de Chipre e, deixando-a à esquerda, seguimos para a Síria. Quando chegamos à cidade de Tiro, tivemos que desembarcar, pois o navio tinha que ser descarregado. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ali nós encontramos alguns discípulos e ficamos com eles por uma semana e, pelo poder do Espírito, eles disseram a Paulo que não fosse para Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Passados aqueles dias, nós nos retiramos e continuamos nossa viagem. Todos eles nos acompanharam, com suas mulheres e filhos, da cidade até a praia, onde nos ajoelhamos e oramos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Depois de nos despedirmos uns dos outros, embarcamos e eles voltaram para suas casas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Prosseguimos nossa viagem partindo de Tiro e chegando em Ptolemaida. Lá cumprimentamos os irmãos e ficamos com eles por um dia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","No dia seguinte, partimos e seguimos para a cidade de Cesaréia. Ao chegar lá, fomos para a casa do evangelista Filipe, que era um dos sete, e ficamos com ele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ele tinha quatro filhas solteiras que profetizavam. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Tínhamos chegado há vários dias quando um profeta chamado Ágabo chegou da Judéia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ele veio para perto de nós, tirou o cinto de Paulo e, amarrando seus próprios pés e mãos, disse: —Assim diz o Espírito Santo: O dono deste cinto será amarrado desta maneira pelos judeus em Jerusalém e será entregue nas mãos dos que não são judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Quando ouvimos isto, tanto nós como os daquele lugar insistimos com Paulo para que ele não fosse para Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Paulo, porém, disse: —O que vocês pretendem chorando desse jeito e me entristecendo? Eu não só estou pronto para ser amarrado como também para morrer em Jerusalém pelo nome do Senhor Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Como não conseguimos convencê-lo, paramos de insistir e dissemos: —Que seja feita a vontade do Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Depois desses dias, nos preparamos e partimos para Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Alguns dos discípulos que eram da cidade de Cesaréia nos acompanharam e nos levaram até a casa de Mnasom, onde íamos ficar. Mnasom era da ilha de Chipre e era um dos primeiros discípulos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Quando chegamos a Jerusalém, fomos recebidos com alegria pelos irmãos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","No dia seguinte, Paulo nos acompanhou em visita a Tiago e todos os presbíteros da igreja estavam lá reunidos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulo cumprimentou a todos e contou-lhes, uma por uma, todas as coisas que Deus tinha feito entre os que não eram judeus por meio do seu trabalho. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ao ouvirem isto, todos louvaram a Deus e, depois, disseram a Paulo: —Irmão! Como você pode ver, milhares de judeus creram e acham que é importante seguir a lei de Moisés. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Eles ouviram dizer que você está ensinando a todos os judeus que vivem entre povos que não são judeus a abandonarem a lei de Moisés, dizendo-lhes que não devem circuncidar os filhos nem seguir os costumes judaicos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","O que é que podemos fazer então? Sem dúvida eles saberão da sua chegada. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Portanto, faça o que vamos lhe dizer: Estão conosco quatro homens que fizeram uma promessa. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Acompanhe esses homens em sua cerimônia de purificação e pague as despesas deles para que possam raspar a cabeça. Dessa forma, todos ficarão sabendo que não é verdade o que ouviram dizer a seu respeito e que, pelo contrário, você mesmo obedece à lei. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Quanto aos que não são judeus e que creram, já lhes escrevemos uma carta, dizendo: “Não comam carne de animais oferecidos a ídolos, nem sangue e tampouco carne de animais que tenham sido estrangulados. E também não cometam imoralidades sexuais”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","No dia seguinte, Paulo levou os homens e participou da cerimônia de purificação juntamente com eles. Depois, foi para o templo para anunciar quando terminariam os dias da purificação para que, no fim desses dias, fosse oferecido um sacríficio para cada um deles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Quando os sete dias da purificação estavam para acabar, alguns judeus da região da Ásia viram a Paulo no templo. Eles alvoroçaram toda a multidão e, agarrando-o, ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","gritaram: —Homens de Israel, ajudem-nos! Este é o homem que anda por toda parte ensinando a todos coisas que são contra o nosso povo, contra a lei de Moisés e contra este lugar. E agora ele trouxe até mesmo homens que não são judeus para dentro do templo, sujando este lugar santo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Eles tinham dito isto porque tinham visto Paulo na cidade em companhia de Trófimo, um efésio, e assumiram que Paulo o tinha levado ao templo.) ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Toda a cidade ficou agitada, e o povo corria, vindo de todos os lados. Eles agarraram a Paulo e o arrastaram para fora do templo, fechando as portas logo em seguida. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Enquanto procuravam matá-lo, o comandante de um batalhão romano foi informado de que toda a cidade de Jerusalém estava em completo alvoroço. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ele imediatamente reuniu alguns soldados e oficiais e correu para o meio do povo. Quando o povo viu o comandante e os soldados, parou de bater em Paulo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","O comandante, então, chegando perto de Paulo, prendeu-o e mandou que o amarrassem com duas correntes. Depois, dirigiu-se ao povo e perguntou-lhes quem ele era e o que tinha feito. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Na multidão, uns gritavam uma coisa e outros, outra. Ele, porém, não podendo apurar a verdade por causa do tumulto, ordenou que Paulo fosse levado para o quartel. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Quando chegaram às escadas, os soldados tiveram que carregá-lo no alto por causa da violência da multidão que, ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","seguindo-o, gritava: —Matem-no! ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Eles estavam prestes a entrar no quartel quando Paulo disse ao comandante: —Posso falar com o senhor? O comandante respondeu: —Oh! Você fala grego? ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Você não é o egípcio que há algum tempo atrás organizou uma revolta e levou quatro mil terroristas para o deserto? ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo disse: —Não! Eu sou judeu, cidadão de Tarso, cidade importante da Cilícia. Eu lhe peço que me deixe falar com o povo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Quando o comandante lhe deu permissão, Paulo se colocou de pé nos degraus e fez sinal com a mão para que a multidão fizesse silêncio. Depois que todos ficaram quietos, Paulo começou a falar-lhes em língua hebraica: ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Irmãos e pais! Escutem o que vou dizer em minha defesa. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","(Quando a multidão ouviu que ele lhes falava em hebraico, ficou ainda mais quieta.) Então Paulo disse: ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Eu sou judeu e nasci na cidade de Tarso, na Cilícia, mas cresci nesta cidade. Fui aluno de Gamaliel e com ele estudei profundamente a lei dos nossos antepassados. Eu era dedicado a Deus exatamente como todos vocês são hoje. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Persegui este Caminho até a morte, prendendo e colocando homens e mulheres na prisão, ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","assim como podem testemunhar tanto o sumo sacerdote como todos os que fazem parte do Conselho dos anciãos. Recebi destes cartas escritas para os irmãos judeus em Damasco e fui para lá a fim de prender os que lá estavam e de trazê-los para Jerusalém como prisioneiros, para que pudessem ser castigados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Eu já estava a caminho e me aproximava da cidade de Damasco quando, por volta do meio-dia, de repente, uma luz forte brilhou ao meu redor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Caí no chão e ouvi uma voz me dizer: “Saulo, Saulo, por que você me persegue?” ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Então perguntei: “Quem é o senhor?” Ele disse: “Sou Jesus de Nazaré, a quem você persegue”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Os homens que estavam comigo viram a luz, mas não entenderam o que a voz dizia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Em seguida perguntei: “O que devo fazer, Senhor?” E o Senhor me respondeu: “Levante-se e vá para Damasco. Lá você será informado de tudo o que deve fazer”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","O brilho daquela luz tinha me deixado cego e, por isso, tive de ser guiado pela mão pelos meus companheiros até Damasco. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","—Morava em Damasco um homem chamado Ananias. Ele era muito religioso de acordo com a lei e muito respeitado por todos os judeus daquela região. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ele veio ao meu encontro e, parando de frente para mim, disse: “Irmão Saulo, volte a enxergar!” E naquele mesmo instante eu voltei a enxergar e pude vê-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ele me disse: “O Deus de nossos antepassados escolheu a você para conhecer a vontade dele, para ver o Justo e também para ouvir a voz da sua boca. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Pois você testemunhará a todos os homens a respeito de tudo o que viu e ouviu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","E agora, o que está esperando? Levante-se, seja batizado e lave os seus pecados, confiando no nome do Senhor”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","—Eu voltei para Jerusalém e, quando estava orando no templo, tive uma visão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","E eu vi aquele que estava me dizendo: “Saia imediatamente de Jerusalém, pois este povo não aceitará o seu testemunho a meu respeito”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Então eu disse: “Senhor, estas pessoas sabem que eu percorri sinagogas, colocando na prisão e açoitando os que acreditavam no senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Elas sabem também que eu estava presente quando o sangue de Estêvão, a sua testemunha, foi derramado. E elas até sabem que eu aprovei aquele crime e que tomei conta das capas dos que o mataram”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Mas Ele me disse: “Vá, pois Eu vou enviá-lo para muito longe, para povos que não são judeus”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Eles escutaram o que Paulo tinha a dizer até aquele ponto, mas depois começaram a gritar, dizendo: —Tirem esse homem da terra, pois ele não merece viver! ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","E, enquanto gritavam, eles atiravam suas capas e jogavam poeira para cima. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","O comandante, então, ordenou que Paulo fosse levado para o quartel e que, com açoites, fosse interrogado para saber o motivo pelo qual a multidão gritava tanto contra ele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Mas quando eles o amarraram para açoitá-lo, Paulo perguntou ao oficial que estava perto dele: —Vocês têm permissão para açoitar um cidadão romano, sem este estar condenado? ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Quando o oficial ouviu isto, foi ao comandante e disse: —Veja bem o que o senhor vai fazer, pois este homem é um cidadão romano. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","O comandante, então, aproximando-se de Paulo, perguntou: —Diga-me uma coisa: Você é realmente cidadão romano? E Paulo respondeu: —Sim, sou. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","O comandante então disse: —A mim custou muito dinheiro para conseguir ser cidadão romano. Ao que Paulo respondeu: —Mas eu sou cidadão romano de nascimento. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Imediatamente os homens que estavam ali para interrogá-lo afastaram-se dele e o comandante ficou com medo quando soube que tinha mandado amarrar um romano. ");
INSERT INTO por_WBTC_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","O comandante queria saber exatamente porque Paulo estava sendo acusado pelos judeus. Então, depois de soltá-lo, mandou reunir em assembléia os líderes dos sacerdotes e todo o Conselho Superior. Depois ele mandou trazer Paulo e o colocou diante deles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo olhou bem para os membros do Conselho e disse: —Irmãos! Eu tenho vivido com a consciência limpa diante de Deus até o dia de hoje. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Então Ananias, o sumo sacerdote, mandou que os homens que estavam perto de Paulo lhe batessem na boca. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulo, então, lhe disse: —Deus vai bater em você, parede branqueada! Você está aí sentado para me julgar de acordo com a lei e, contra a lei, manda me bater? ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Os homens que estavam perto dele lhe disseram: —Como é que você insulta assim o sumo sacerdote de Deus? ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo respondeu: —Irmãos, eu não sabia que ele era o sumo sacerdote; as Escrituras dizem: “Não fale mal do líder do seu povo”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Quando Paulo percebeu que alguns homens do Conselho eram do partido dos saduceus e que outros eram do partido dos fariseus, falou bem alto: —Irmãos! Eu sou fariseu e filho de fariseu, e estou sendo julgado por causa da esperança que tenho na ressurreição dos mortos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Depois de terem ouvido Paulo dizer isto, os fariseus e os saduceus começaram a discutir e a assembléia se dividiu. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Os saduceus dizem que não há ressurreição e também que não existem nem anjos nem espíritos, mas os fariseus acreditam em tudo isso.) ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Todos os judeus começaram a gritar e alguns professores da lei do partido dos fariseus se levantaram e começaram a protestar: —Não encontramos nada contra este homem; e será que algum espírito ou anjo falou com ele? ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","A discussão se tornou tão violenta que o comandante ficou com medo que Paulo fosse despedaçado por eles. Então mandou que os soldados fossem até lá, tirassem Paulo do meio deles e que o levassem de volta para o quartel. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Na noite seguinte, o Senhor se colocou ao lado de Paulo e disse: —Tenha coragem! Assim como você testemunhou a meu respeito em Jerusalém, você também terá de fazer o mesmo em Roma. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","No dia seguinte, os judeus se reuniram e fizeram um juramento que não comeriam nem beberiam nada até que matassem Paulo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","(E o número de homens que conspiravam contra Paulo era de mais de quarenta.) ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Depois, foram falar com os líderes dos sacerdotes e com os anciãos, dizendo: —Juramos que não comeremos nada até que matemos Paulo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Portanto, o que vocês e o Conselho têm que fazer é mandar dizer ao comandante para trazê-lo até aqui, dizendo que querem examinar o caso dele mais de perto. Estaremos prontos para matá-lo antes que ele chegue. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","O filho da irmã de Paulo, porém, ouviu todo o plano e correu para o quartel a fim de avisar Paulo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paulo, então, chamou um dos oficiais e disse: —Leve este rapaz até o comandante, pois tem uma coisa para dizer a ele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","O oficial levou o rapaz até o comandante e disse: —O prisioneiro Paulo me chamou e pediu que eu trouxesse este rapaz até o senhor pois parece que ele tem alguma coisa para lhe dizer. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","O comandante levou o rapaz pela mão até um lugar onde poderiam conversar e perguntou-lhe: —O que você quer me dizer, rapaz? ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ele disse: —Os judeus combinaram pedir ao senhor que levasse Paulo até o Conselho amanhã com a desculpa de querer examinar o caso dele mais de perto. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Não acredite nisso! Mais de quarenta homens estão escondidos à espera de Paulo para matá-lo. Eles fizeram um juramento de não comer nem beber nada até que o matem. Está tudo pronto; eles só precisam da sua permissão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","O comandante, então, disse: —Você pode ir embora agora, mas não diga a ninguém que me contou essas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Depois que o rapaz foi embora, o comandante mandou chamar dois oficiais e disse: —Preparem duzentos soldados, setenta cavaleiros e duzentos lanceiros para ir até a cidade de Cesaréia. Estejam prontos às nove horas da noite. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mandem preparar um cavalo para Paulo e levem-no em segurança até o governador Félix. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Depois disto, o comandante escreveu esta carta: ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“De Cláudio Lísias, ao excelentíssimo governador Félix. Saudações! ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Este homem foi agarrado pelos judeus, e eles estavam prestes a matá-lo quando, ao ficarmos sabendo que ele era cidadão romano, eu e meus soldados o tiramos das mãos deles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Eu queria saber a razão pela qual eles o estavam acusando e, por isso, o levei ao Conselho Superior deles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Lá percebi que as acusações contra ele diziam respeito à lei deles, mas que ele não era culpado de nada que merecesse a morte ou a prisão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Assim que fui informado de um plano traçado para tirar-lhe a vida, resolvi enviá-lo para aí. E também ordenei aos que o acusam que apresentem as suas queixas diante do senhor”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Os soldados cumpriram as ordens que receberam e, durante a noite, levaram Paulo para a cidade de Antipátride. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","No dia seguinte, os cavaleiros seguiram com Paulo, mas o restante dos soldados retornou para o quartel. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Quando chegaram à cidade de Cesaréia, eles deram a carta ao governador e também lhe entregaram Paulo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","O governador leu a carta e perguntou a Paulo de que província ele era. Quando soube que era da Cilícia, ");
INSERT INTO por_WBTC_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","disse: —Eu o ouvirei assim que os homens que o acusam chegarem. Então mandou que Paulo fosse mantido preso no palácio de Herodes. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Cinco dias depois, Ananias, o sumo sacerdote, chegou à cidade de Cesaréia acompanhado de alguns anciãos e de um advogado chamado Tértulo. Eles se apresentaram ao governador com acusações contra Paulo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Este, então, foi chamado e Tértulo iniciou a sua acusação, dizendo: —Graças ao senhor, nós temos atravessado um período de muita paz e muitas reformas que eram necessárias neste país foram feitas por causa da sua sabedoria. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nós lhe somos muito gratos, excelentíssimo senhor governador, por tudo o que temos recebido em todas as situações e em todos os lugares. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Agora, para não detê-lo por muito tempo, peço-lhe que tenha a bondade de nos ouvir apenas por um pouco mais. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nós sabemos que este homem é uma peste e que provoca desordens entre os judeus espalhados por todas as partes do mundo. Sabemos também que ele é o líder da seita dos nazarenos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ele tentou até profanar o templo, e foi por isso que nós o prendemos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Interrogue-o o senhor mesmo! Assim o senhor tomará conhecimento de todas as coisas de que nós o acusamos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Os judeus também concordaram na acusação, afirmando que estas coisas eram assim. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Depois disto, o governador fez um sinal com a mão para que Paulo falasse. Então Paulo disse: —Eu sei que o senhor tem julgado esta nação por muitos anos, por isso é com muito prazer que faço minha defesa na sua presença. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Como o senhor pode verificar, não faz mais de doze dias que fui para Jerusalém para adorar a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Quando eles me encontraram no templo, eu não estava discutindo com ninguém. Eles também não me viram provocando desordens entre o povo nem nas sinagogas e em nenhum outro lugar da cidade. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Eles não podem nem sequer lhe provar as acusações que estão fazendo contra mim. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","O que eu tenho que confessar ao senhor é: Eu adoro ao Deus de nossos antepassados de acordo com o Caminho, o qual eles dizem ser falso. Acredito em tudo o que a lei de Moisés diz e em tudo o que está escrito nos livros dos profetas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Tenho a mesma esperança em Deus que eles também têm, isto é, que todos iremos ressuscitar, tanto os justos como os pecadores. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Portanto, faço o possível para manter minha consciência sempre limpa tanto diante de Deus como diante das pessoas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","—Tenho estado fora de Jerusalém por muitos anos e voltei para trazer alguma ajuda ao meu próprio povo e também para oferecer sacrifícios. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","E era exatamente isso que eu estava fazendo no templo, depois de já ter sido purificado, quando eles me encontraram. Não havia multidão ou mesmo desordem alguma. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Alguns judeus da Ásia que estavam lá é que deveriam vir à sua presença para me acusar, se é que eles têm alguma coisa contra mim. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ou mesmo estes homens que estão aqui digam que mal acharam em mim quando estive diante do Conselho Superior, ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","exceto uma coisa que eu gritei enquanto estava entre eles, que foi: “É por causa da ressurreição dos mortos que estou sendo julgado por vocês hoje”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Quando Félix, que estava bem informado a respeito do Caminho, ouviu isso, adiou a audiência e disse: —Decidirei o seu caso quando o comandante Lísias chegar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Depois, chamou o oficial e deu-lhe estas ordens: —Mantenha Paulo sob vigilância, mas dê-lhe alguma liberdade. Permita também que os amigos dele lhe tragam o que ele precisar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Alguns dias depois, chegando Félix com sua esposa Drusila, que era judia, mandou chamar Paulo e o ouviu falar a respeito da fé em Cristo Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Quando Paulo lhes falou a respeito de justiça, de domínio próprio e de julgamento futuro, Félix ficou com medo e disse: —Você pode ir embora agora. Eu voltarei a chamá-lo quando tiver outra oportunidade. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Félix esperava que Paulo lhe desse algum dinheiro, por isso mandou chamá-lo várias vezes para conversar com ele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Dois anos se passaram. Pórcio Festo assumiu o cargo de governador e Félix, querendo garantir o apoio dos judeus, deixou o posto deixando também Paulo na prisão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Três dias depois de ter chegado para ocupar o cargo de governador, Festo foi de Cesaréia para Jerusalém. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Lá, os líderes dos sacerdotes e os judeus mais importantes da cidade apresentaram-lhe as acusações que tinham contra Paulo. Eles também lhe pediram ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","que lhes fizesse este favor: que enviasse Paulo para Jerusalém. (Eles estavam preparando uma cilada para matá-lo durante a viagem.) ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festo, porém, disse: —Paulo está preso em Cesaréia e eu pretendo voltar para lá em breve. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Que alguns dos seus líderes me acompanhem até lá e o acusem, se é que ele fez alguma coisa errada. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festo ficou com eles não mais do que oito ou dez dias e depois partiu para Cesaréia. No dia seguinte, ele tomou o seu lugar no tribunal e mandou que Paulo fosse levado até lá. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Quando Paulo chegou, os judeus que tinham ido de Jerusalém o rodearam e começaram a acusá-lo de várias coisas graves, as quais não eram capazes de provar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulo, então, defendendo-se, disse: —Eu não fiz nada de errado nem contra a lei dos judeus, nem contra o templo e nem contra César. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festo, porém, querendo agradar aos judeus, disse a Paulo: —Você quer ir até Jerusalém e ser julgado ali por mim a respeito destas coisas? ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo respondeu: —Eu estou diante do tribunal de César e é aqui que devo ser julgado. O senhor sabe muito bem que eu não cometi crime algum contra os judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Se sou culpado de alguma coisa errada, ou se fiz alguma coisa pela qual mereça a morte, eu estou pronto para morrer. Mas, se as acusações que estes homens estão fazendo contra mim não são verdadeiras, ninguém pode me entregar a eles. Eu apelo para ser julgado por César. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Depois de conversar com seus conselheiros, Festo disse: —Você apelou para ser julgado por César, para César você irá. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Alguns dias depois, o rei Agripa e Berenice chegaram a Cesaréia para cumprimentar a Festo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Como eles permanecessem lá por vários dias, Festo apresentou o caso de Paulo ao rei, dizendo: —Está aqui um homem que foi deixado prisioneiro por Félix. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Quando estive em Jerusalém, os líderes dos sacerdotes e os anciãos dos judeus me apresentaram muitas acusações contra ele e pediram que fosse condenado. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Eu disse a eles que os romanos não costumam entregar ninguém sem primeiro haver um encontro, frente a frente, entre o acusado e os que o acusam. Dessa forma o acusado tem a chance de se defender das acusações. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Eles vieram comigo até aqui e eu não perdi tempo; no dia seguinte, tomei o meu lugar no tribunal e mandei que o homem fosse trazido. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Os homens que estavam contra ele se levantaram e começaram a acusá-lo, mas não mencionaram nenhum grande crime, como eu pensei que eles fossem fazer. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ao invés disso eles começaram a discutir com Paulo a respeito de coisas ligadas à religião deles e a respeito de um homem morto chamado Jesus, a quem Paulo afirmava estar vivo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Como eu não sabia o que fazer num caso destes, perguntei a Paulo se ele queria ir a Jerusalém para ser julgado lá a respeito destas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ele, porém, apelou para ficar em custódia para o julgamento do imperador. Então, eu ordenei que continuasse preso até que eu o enviasse a César. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Depois de ouvir estas coisas, o rei Agripa disse a Festo: —Eu gostaria de ouvir esse homem. Ao que Festo disse: —O senhor o ouvirá amanhã. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Então, no dia seguinte, Agripa e Berenice chegaram com grande pompa e entraram na sala da audiência juntamente com os comandantes militares e com os homens mais importantes da cidade. Festo mandou que Paulo fosse levado até aquele auditório ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","e depois disse: —Rei Agripa e todos os que estão presentes aqui! Vejam este homem! Toda a comunidade dos judeus, tanto daqui de Cesaréia como da cidade de Jerusalém, recorreu a mim gritando que este homem devia morrer. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Eu, entretanto, não acho que ele tenha feito nada que mereça a morte. Ele apelou para ser julgado pelo imperador e eu, então, decidi enviá-lo a César. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Eu não tenho nada de concreto para escrever a respeito dele ao soberano. Por isso resolvi trazê-lo diante de todos aqui hoje—e especialmente diante do senhor, rei Agripa, para que, depois do interrogatório, eu tenha alguma coisa para escrever. ");
INSERT INTO por_WBTC_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Pois me parece absurdo mandar um prisioneiro para julgamento sem indicar as acusações feitas contra ele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Então Agripa disse a Paulo: —Agora você pode se defender. Paulo estendeu a mão e começou a sua defesa: ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Rei Agripa. Estou muito feliz por ser diante do senhor que vou apresentar hoje minha defesa contra todas as coisas das quais os judeus estão me acusando, ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","especialmente levando-se em conta todo o seu conhecimento a respeito de todos os costumes e problemas dos judeus. Portanto, peço-lhe que me escute com paciência. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","—Todos os judeus sabem que eu tenho vivido em meu país e em Jerusalém desde que era jovem. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Eles me conhecem há muito tempo e podem, se quiserem, testemunhar que vivi como fariseu de acordo com a seita mais rigorosa da nossa religião. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Hoje eu estou sendo julgado por causa da esperança que tenho na promessa que Deus fez a nossos antepassados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","As doze tribos de Israel servem a Deus dia e noite na esperança de receber essa mesma promessa. E é por causa dessa esperança, ó rei, que estou sendo acusado pelos judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Por que parece inacreditável a vocês que Deus ressuscite os mortos? ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Eu mesmo pensava que tinha de fazer tudo o que pudesse contra o nome de Jesus de Nazaré ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","e foi exatamente isso o que fiz em Jerusalém. Eu recebi uma autorização dos líderes dos sacerdotes e, com ela, coloquei muitos do povo de Deus na prisão. Quando eles eram condenados à morte, o meu voto também estava contra eles. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Muitas vezes eu os castiguei por todas as sinagogas e tentei até forçá-los a insultar Jesus. Eu estava tão enfurecido contra eles que continuava a persegui-los mesmo em cidades estrangeiras. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","—Numa dessas viagens, quando ia para a cidade de Damasco, eu levava uma autorização e também ordens dos líderes dos sacerdotes. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Era por volta do meio-dia e eu já estava a caminho quando vi, ó rei, uma luz do céu. Ela brilhava mais que o sol e iluminou a mim e a todos os que estavam comigo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Todos nós caímos ao chão e então ouvi uma voz que me dizia, em hebraico: “Saulo, Saulo, por que você me persegue? Você está machucando a si mesmo, como o boi que dá coice contra a ponta do ferrão”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","—Então perguntei: “Quem é o senhor?” E Ele me respondeu: “Eu sou Jesus, a quem você está perseguindo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Mas levante-se e fique de pé. Eu apareci a você para que me sirva de servo e testemunha, tanto com relação ao que você já viu como também com relação ao que Eu ainda vou lhe mostrar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Vou livrá-lo tanto dos povos judeus como também dos que não são judeus, para os quais vou mandá-lo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Eu vou mandá-lo a eles para que você lhes abra os olhos a fim de que eles se voltem da escuridão para a luz e do poder de Satanás para Deus. Dessa forma, pela fé em mim, eles receberão perdão dos seus pecados e passarão a fazer parte do povo santo de Deus”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","—Portanto, Rei Agripa, eu obedeci à visão celestial que tive. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Comecei a anunciar aos de Damasco. De lá fui para a cidade de Jerusalém e, depois, viajei por toda a região da Judéia, anunciando inclusive para os que não são judeus. Eu anunciava que eles deviam se arrepender e voltar para Deus e também que tudo o que fizessem deveria mostrar que eles estavam realmente arrependidos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Foi por esse motivo que os judeus me agarraram quando eu estava no templo e tentaram me matar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Mas Deus tem me ajudado muito até o dia de hoje e é por isso que eu agora estou aqui, testemunhando a respeito dele tanto para os que são de condição simples como para os que são importantes. Eu nunca disse nada que fosse além daquilo que tanto os profetas como Moisés já disseram, ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","isto é, que Cristo iria sofrer e que iria ser o primeiro a ser ressuscitado e que assim anunciaria a luz tanto para os que são judeus como para os que não são judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulo estava dizendo estas coisas em sua defesa quando Festo gritou: —Você está louco, Paulo! Você estudou tanto que ficou maluco! ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Mas Paulo disse: —Eu não estou maluco, Excelentíssimo Festo. As coisas que eu estou dizendo são verdade e de bom senso. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","O próprio rei Agripa aqui presente sabe a respeito dessas coisas e eu tenho certeza de que nenhuma delas escapou ao conhecimento dele, pois nada foi feito às escondidas. É por isso que eu posso falar ao rei abertamente. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ó rei Agripa, acredita nos profetas? Eu sei que o senhor acredita. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Então o rei disse a Paulo: —Você acha que assim, em pouco tempo, pode me persuadir a me tornar cristão? ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo respondeu: —Assim Deus permitisse que, em pouco ou muito tempo, não apenas o senhor, ó rei, porém todos os que hoje me ouvem se tornassem como eu sou—só que sem estas correntes. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Então o rei Agripa, o governador, Berenice e todos os que estavam sentados com ele se levantaram e ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","saíram do auditório, comentando uns com os outros: —Esse homem não fez nada para merecer a morte e nem mesmo a prisão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","E Agripa disse a Festo: —Este homem já podia estar solto se não tivesse pedido para ser julgado por César. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ficou então decidido que navegaríamos para a Itália. Paulo e alguns dos outros presos foram entregues a um oficial chamado Júlio, o qual pertencia ao Regimento Imperial. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Embarcamos num navio que estava pronto para partir da cidade de Adramítio para costear a região da Ásia. Aristarco, um macedônio da cidade de Tessalônica, estava conosco. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","No dia seguinte, chegamos ao porto de Sidom. Júlio tratava Paulo com bondade, permitindo inclusive que ele fosse ver seus amigos e que recebesse deles o que precisasse. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","De lá nós partimos e navegamos sob a proteção da ilha de Chipre, pois o vento nos era contrário. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Atravessamos os mares do litoral da Cilícia e da Panfília e chegamos à Mirra, cidade da região da Lícia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ali o oficial encontrou um barco da cidade de Alexandria com destino à Itália e nos embarcou nele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Navegamos muito lentamente durante vários dias e foi a muito custo que chegamos perto da cidade de Cnido. O vento, porém, não nos deixava continuar nessa direção. Então navegamos sob a proteção da ilha de Creta, passando pelo porto de Salmona. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Assim fomos navegando bem perto do litoral e, ainda com dificuldade, chegamos a um lugar chamado Bons Portos, localizado perto da cidade de Laséia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Tinha-se perdido muito tempo e agora tornava-se perigoso navegar, pois o período do jejum já tinha passado. Paulo, então, avisou a todos, dizendo: ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","—Homens! Vejo que a nossa viagem será terrível e que trará muitos prejuízos, não somente para a carga e para o barco, como também para as nossas próprias vidas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Mas o oficial romano dava mais crédito ao piloto e ao dono do navio do que ao que Paulo dizia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Como o porto onde nós estávamos não era seguro para se passar o inverno, a maioria decidiu partir e tentar chegar à cidade de Fenice e passar o inverno ali. Fenice é um porto da ilha de Creta que olha para o sudoeste e para o noroeste. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Um vento fraco começou a soprar do sul. Então todos pensaram que poderiam seguir viagem tranqüilamente. Eles levantaram âncora e puseram-se a navegar ao longo do litoral de Creta. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Pouco depois, porém, um vento muito forte chamado “Nordeste” veio da ilha. Ele era tão forte como um furacão, ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","e arrastou o navio de tal maneira que não conseguíamos avançar contra ele. Então desistimos e deixamo-nos levar pelo vento. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Protegidos do vento por uma pequena ilha chamada Cauda, conseguimos, com muita dificuldade, amarrar o bote salva-vidas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Depois de terem suspendido o bote, os marinheiros amarraram o navio com cabos de segurança. Eles tinham medo de que ele fosse levado para a costa e que ficasse encalhado em Sirte. Depois baixaram a vela e deixaram que o navio fosse levado pelo vento. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","No dia seguinte, como o vento continuava a soprar fortemente, eles começaram a jogar a carga no mar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","E, no terceiro dia, eles, com as próprias mãos, atiraram a aparelhagem do navio no mar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Durante muitos dias, não pudemos ver o sol, nem as estrelas, e o vento continuava soprando forte. Finalmente, perdemos toda a esperança de sermos salvos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Como estávamos muito tempo sem comer nada, Paulo ficou de pé no meio deles, e disse: —Homens, vocês deveriam ter me escutado e ficado em Creta. Assim se teria evitado este dano e perda. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Agora, porém, é preciso que vocês sejam corajosos pois nenhum de vocês morrerá, mas somente o barco se perderá. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Digo isto porque ontem à noite um anjo de Deus, a quem eu pertenço e sirvo, apareceu junto a mim ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","e me disse: “Não tenha medo, Paulo, pois você deve aparecer diante de César e Deus, em sua bondade, lhe concedeu as vidas de todos os que estão navegando com você”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Portanto, alegrem-se, homens! Eu tenho fé em Deus e creio que Ele fará exatamente como o anjo me disse. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Mas nós temos que encalhar numa ilha. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Na décima quarta noite, estávamos sendo levados pelo vento através do Mar Adriático quando, por volta da meia-noite, os marinheiros perceberam que estávamos nos aproximando da terra. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Então, jogaram o prumo e viram que ali a água tinha trinta e seis metros de profundidade. Pouco tempo depois, eles mediram outra vez e deu só vinte e sete metros. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Eles começaram a ficar com medo que o barco batesse contra as rochas. Então foram até a parte de trás do navio e jogaram quatro âncoras no mar. Depois disso começaram a orar para que o dia clareasse logo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Os marinheiros tentaram escapar do navio. Eles baixaram o bote salva-vidas no mar fingindo estarem jogando a âncora na parte dianteira do barco. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paulo, porém, disse ao oficial romano e aos soldados: —Se esses homens não ficarem no navio, vocês não conseguirão se salvar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Os soldados, então, cortaram as cordas do bote salva-vidas e deixaram que ele caísse ao mar. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Um pouco antes de amanhecer, Paulo pediu a todos que comessem alguma coisa, dizendo: —Já faz duas semanas que vocês têm esperado sem comer nada. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Agora, porém, eu lhes peço que comam alguma coisa. Vocês precisam alimentar-se para continuar vivendo, pois nenhum de vocês perderá sequer um fio de cabelo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Depois de dizer isto, Paulo pegou um pedaço de pão e, agradecendo a Deus diante de todos, partiu-o e começou a comer. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Todos se sentiram encorajados e também comeram um pouco. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Éramos ao todo duzentas e setenta e seis pessoas no barco. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Depois de terem comido o suficiente, eles jogaram o restante do trigo no mar a fim de aliviar o peso do navio. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Quando amanheceu, eles não reconheceram a terra, mas viram certa baía com praia e resolveram fazer o possível para que o navio encalhasse lá. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Eles cortaram as âncoras e deixaram que elas caíssem no mar e também desamarraram as cordas que prendiam os remos. Depois eles levantaram a vela do lado dianteiro do navio ao vento e se dirigiram para a praia. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Porém bateram contra um banco de areia e o navio ficou encalhado. A parte da frente ficou presa e imóvel, e a parte de trás começou a se arrebentar por causa da força das ondas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Os soldados, então, resolveram matar todos os prisioneiros, para que eles não nadassem para a terra e fugissem. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","O oficial romano, porém, queria salvar Paulo e impediu que os soldados levassem seu plano adiante. Ele ordenou a todos aqueles que soubessem nadar que se atirassem primeiro no mar e que nadassem para a terra. ");
INSERT INTO por_WBTC_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Mandou também que todos os outros seguissem agarrados em tábuas ou em pedaços do navio. Assim todos chegamos à terra sãos e salvos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Quando já estávamos todos a salvo soubemos que a ilha se chamava Malta. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Os nativos da ilha nos receberam e nos trataram muito bem. Como começava a chover e fazia frio, eles nos fizeram uma grande fogueira. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulo ajuntou um feixe de galhos e, depois de jogá-los no fogo, uma víbora, por causa do calor, prendeu-se na mão dele. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ao verem a cobra pendurada em sua mão, os nativos comentaram uns com os outros: —Este homem deve ser um assassino. Ele escapou do mar, mas mesmo assim a Justiça não permite que continue vivendo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Paulo, porém, sacudiu a cobra para dentro da fogueira sem sofrer nada. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Os nativos esperavam que ele fosse inchar ou cair morto de repente. Mas, como não aconteceu nada, mesmo depois de terem esperado por um longo tempo, eles mudaram de idéia e começaram a dizer que Paulo era um deus. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Perto daquele lugar, havia alguns campos que pertenciam a Públio, o chefe da ilha. Ele nos recebeu em sua casa e nos hospedou durante três dias. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","O pai de Públio estava de cama, doente com febre e com disenteria. Paulo, então, foi visitá-lo e, depois de orar, colocou suas mãos sobre ele e o curou. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Quando isto aconteceu, todos os outros doentes da ilha vieram e foram curados. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Eles nos prestaram muitas honras e, quando embarcamos, nos deram tudo de que precisávamos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Depois de três meses, partimos num barco de Alexandria que tinha passado o inverno na ilha. O emblema do barco era Dióscuros. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Chegamos à cidade de Siracusa, onde permanecemos por três dias. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Depois seguimos viagem e chegamos à cidade de Régio. No dia seguinte começou a soprar um vento do sul e em dois dias chegamos à cidade de Potéoli. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Lá encontramos alguns irmãos e eles nos pediram que ficássemos com eles por uma semana. E foi assim que chegamos a Roma. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Os irmãos em Roma ouviram falar de nós e vieram ao nosso encontro à Praça de Ápio e às Três Vendas. Quando Paulo os viu, ele agradeceu a Deus e sentiu-se mais animado. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ao chegar a Roma, foi permitido a Paulo viver sozinho, com um soldado de guarda. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Três dias depois, Paulo chamou os chefes dos judeus para se reunirem com ele. Quando se reuniram, ele lhes disse: —Irmãos, embora não tenha feito nada contra o nosso povo ou contra os costumes dos nossos antepassados, fui preso em Jerusalém e entregue nas mãos dos romanos. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Eles interrogaram-me e queriam me soltar, pois eu não tinha feito nada que merecesse a morte. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Mas, como os judeus se opuseram, tive que apelar para César. Não que eu tenha alguma coisa contra o meu povo. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Esta é a razão porque pedi para falar com vocês. Pois é por causa da esperança de Israel que estou preso com esta corrente. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Eles disseram a Paulo: —Não recebemos nenhuma carta da Judéia a respeito de você e nenhum dos irmãos que vieram de lá falou mal a seu respeito. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Porém, gostaríamos de ouvir as suas idéias, pois sabemos que em toda parte se fala contra esta seita a que você pertence. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Então, depois de marcarem um dia, um grande número deles foi ao encontro de Paulo na sua própria residência. Ele, começando de manhã e indo até a tarde, lhes explicou e deu testemunho a respeito do reino de Deus, tentando persuadi-los a respeito de Jesus, tanto pela lei de Moisés como pelos profetas. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Alguns foram persuadidos pelo que ele dizia; porém outros continuaram não acreditando. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","E, depois de haver uma discussão entre eles, foram embora. Mas antes de saírem, Paulo disse: —Bem falou o Espírito Santo aos seus antepassados, por intermédio do profeta Isaías, quando disse: ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“Vai a este povo e diz: Vocês ouvirão e escutarão, mas não compreenderão; olharão e verão, mas não enxergarão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Pois o coração deste povo está endurecido; eles taparam os seus ouvidos e fecharam os seus olhos. Se não fosse assim, eles poderiam ver com os seus olhos, ouvir com os seus ouvidos, e eles se voltariam para mim e eu os curaria”. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","—Fiquem sabendo, pois, que esta salvação de Deus foi enviada àqueles que não são judeus. E eles a ouvirão. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Durante dois anos, Paulo morou numa casa alugada por ele. Ali recebia todos que o procuravam. ");
INSERT INTO por_WBTC_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ele anunciava o reino de Deus e ensinava com muita coragem e sem impedimento as coisas a respeito do Senhor Jesus Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Eu, Paulo, servo de Cristo Jesus, fui chamado por Deus para ser apóstolo e escolhido para proclamar a sua mensagem de salvação, as Boas Novas. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Há muito tempo Deus tinha prometido estas Boas Novas, por meio dos profetas, nas Sagradas Escrituras. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Estas Boas Novas falam a respeito de Jesus Cristo, nosso Senhor. Ele, de acordo com a sua natureza humana, nasceu da família de Davi. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Mas, pelo Espírito de santidade e de uma maneira muito poderosa, foi declarado Filho de Deus quando ressuscitou dos mortos. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Por meio de Cristo, tenho o privilégio de ser apóstolo, para que pessoas de todas as nações, tendo fé nele, lhe obedeçam. Dessa forma seu nome será honrado. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","E vocês também estão entre as pessoas chamadas para pertencer a Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Escrevo para todos vocês que estão em Roma, amados de Deus e chamados para ser o seu povo. Que Deus, nosso Pai, e o Senhor Jesus Cristo lhes dêem graça e paz. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Em primeiro lugar, quero lhes dizer que agradeço ao meu Deus, por meio de Jesus Cristo, por todos vocês, porque em todo o mundo se fala da fé que vocês têm. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Pois Deus, a quem eu adoro em espírito pela pregação das Boas Novas a respeito do seu Filho, é minha testemunha de como me lembro de vocês constantemente. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Em minhas orações, peço sempre a Deus que, de alguma maneira e se essa for a sua vontade, eu possa ir visitá-los. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Eu quero muito vê-los, para lhes dar algum benefício espiritual, e assim fortalecê-los na fé, ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","isto é, para que, enquanto eu estiver com vocês, possamos encorajar uns aos outros com a fé que temos. A fé de vocês vai me encorajar, e a minha fé vai encorajá-los. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Irmãos, quero que saibam que muitas vezes tentei ir vê-los, mas até agora não foi possível. Eu queria vê-los para que eu pudesse conseguir algum fruto entre vocês, assim como também consegui frutos entre outros povos que não são judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Devo muito a todos: aos gregos e aos que não são gregos, aos sábios e aos ignorantes. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","É por isso que também quero proclamar a mensagem de salvação a vocês que estão em Roma. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Pois eu não tenho vergonha das Boas Novas, porque elas são o poder de Deus para salvar todo aquele que crê: primeiro os que são judeus e depois os que não são judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","As Boas Novas mostram a maneira pela qual Deus nos declara justos, e ela está baseada inteiramente na fé, como está escrito: “Aquele, que pela fé é declarado justo, viverá”. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","A ira de Deus é revelada do céu contra todo o desrespeito e o pecado dos homens, os quais não deixam que a verdade seja conhecida por causa de suas más ações. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Porque o conhecimento a respeito de Deus está bem claro aos homens, pois o próprio Deus deixou este conhecimento claro a eles. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Desde o princípio da criação, as qualidades invisíveis de Deus, tanto o seu poder eterno como a sua natureza divina, são claramente percebidas pelas coisas que Ele fez. Portanto os homens não têm qualquer desculpa. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Pois embora conhecessem a Deus, não lhe deram a glória que lhe pertencia, nem sequer lhe agradeceram. Pelo contrário, os seus pensamentos tornaram-se inúteis e os seus corações insensatos encheram-se de escuridão. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Eles diziam que eram sábios, mas tornaram-se loucos. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","E então, em vez de darem glória ao Deus imortal, começaram a adorar imagens que fizeram com a aparência de seres humanos, de aves, de quadrúpedes e de répteis. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Por isso, Deus os abandonou e deixou que eles seguissem os desejos de seus corações, cometendo imoralidades e desonrando seus corpos uns com os outros. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Trocaram a verdade de Deus pela mentira e começaram a adorar a criação em vez do Criador, que é abençoado eternamente. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Por isso, Deus os abandonou e deixou que fizessem as ações vergonhosas que eles queriam. Pois até as suas mulheres trocaram as relações naturais por aquelas que são contra a natureza. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Da mesma maneira, os homens deixaram de ter relações sexuais naturais com mulheres e começaram a desejar uns aos outros. Assim, homens começaram a cometer atos imundos com outros homens, recebendo em seus próprios corpos o castigo pela sua perversão. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","E como desprezaram o conhecimento a respeito de Deus, o próprio Deus os abandonou e deixou que seguissem seus maus pensamentos para fazerem aquilo que não se deve fazer. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Eles ficaram cheios de toda a espécie de injustiça, malícia, ganância e maldade. Estavam cheios de inveja, crimes, brigas, mentiras, rancor e calúnias. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Eles se tornaram difamadores, inimigos de Deus, insolentes, orgulhosos, arrogantes, desobedientes aos pais, homens que inventam coisas más, ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","estúpidos, que não cumprem as promessas que fazem, que não têm carinho por ninguém e nem compaixão para com os outros. ");
INSERT INTO por_WBTC_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Eles sabem que a lei de Deus diz que quem vive desta maneira merece morrer, mas não só continuam nesta vida, como também aprovam aqueles que praticam estas coisas. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Se você, meu amigo, pensa que pode julgar os outros, está enganado. Porque quando você julga os outros está se condenando, pois você que está julgando pratica as mesmas coisas que condena. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","É Deus quem julga aqueles que praticam o mal; e nós sabemos que o seu julgamento é correto. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","E você, meu amigo, que julga os que fazem o mal, mas faz o mesmo que eles, pensa que vai escapar do julgamento de Deus? ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ou será que você despreza a grande bondade de Deus, a sua tolerância e a sua paciência? Por acaso não sabe que a bondade dele devia levar você a mudar de atitude e de vida? ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Mas você é duro de coração e não quer mudar de atitude. Assim vai fazer com que o seu castigo seja cada vez pior; o castigo que o espera naquele dia de fúria, em que Deus revelará os seus julgamentos justos. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ele retribuirá a todas as pessoas de acordo com o procedimento de cada um. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Deus dará vida eterna para aqueles que, pela persistência em fazer o bem, procuram glória, honra e imortalidade. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Mas vai castigar furiosamente os que, por seu egoísmo, se recusarem a obedecer à verdade e seguirem a maldade. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Haverá aflições e sofrimentos para todos os que fazem o mal; primeiro para os judeus e depois para todos os outros. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Mas haverá glória, honra e paz para todos os que fazem o bem; primeiro para os judeus e depois para todos os outros. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Porque Deus trata a todos da mesma maneira. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Tanto as pessoas que têm a lei, como aquelas que nunca ouviram falar dela, têm a mesma culpa quando pecam. Aquelas que não têm a lei e são pecadoras, estarão perdidas; e também aquelas que têm a lei e são pecadoras, serão condenadas pela lei. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Porque não são aqueles que ouvem a lei que são justos diante de Deus, mas aqueles que praticam o que a lei diz é que são declarados justos. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","(As pessoas que não são do povo judeu não têm a lei. Quando, porém, elas fazem o que a lei manda, sem nem mesmo conhecer a lei, então elas mesmas são a sua própria lei. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Elas mostram que as obras exigidas pela lei estão escritas nos seus corações. As suas próprias consciências provam isso e os seus pensamentos os acusarão ou os defenderão). ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Isto acontecerá no dia em que Deus, por meio de Jesus Cristo, julgar os segredos de todos, de acordo com as Boas Novas que anuncio. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Você diz que é judeu. Você confia na lei de Moisés e se gaba por estar junto de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Você conhece a vontade de Deus e sabe as coisas que têm importância porque foi educado na lei. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Você está convencido de que é um guia para os cegos e uma luz para os que caminham nas trevas. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Você pensa que é mestre dos ignorantes e professor daqueles que não sabem nada. Você pensa que sabe tudo e que tem toda a verdade porque você tem a lei. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Você ensina aos outros. Por que então não ensina a você mesmo? Você diz aos outros que não se deve roubar. Por que então você rouba? ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Você diz que não se deve cometer adultério. Por que então você mesmo comete? Você odeia os ídolos. Por que então rouba os templos? ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Você se orgulha da lei. Por que então desonra a Deus desobedecendo a essa mesma lei? ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","As Escrituras dizem: “Os que não são judeus falam mal de Deus por culpa de vocês”. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Se você segue a lei, então a sua circuncisão tem valor; mas, se você não obedece à lei, é como se você nunca tivesse sido circuncidado. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Se um homem não é circuncidado mas mesmo assim obedece aos mandamentos da lei, não será ele contado como um homem circuncidado? ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Vocês, que são circuncidados escrita mas a ela não obedecem, serão julgados por aqueles que obedecem a essa lei apesar de não serem fisicamente circuncidados. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Porque não é judeu quem o é apenas no seu corpo físico, pois a verdadeira circuncisão não é feita somente por fora do corpo. ");
INSERT INTO por_WBTC_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Porém, um verdadeiro judeu é aquele que o é por dentro e a circuncisão verdadeira é aquela feita no coração. Ela é feita pelo Espírito e não pela lei escrita. O verdadeiro judeu recebe honra de Deus e não dos homens. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Então que vantagem há em ser judeu? Qual é a utilidade da circuncisão? ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Muita, sob todos os aspectos. Primeiro porque foi aos judeus que Deus entregou as suas palavras. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","É verdade que alguns judeus não foram fiéis a Deus, mas será que isso vai impedir que Deus seja fiel? ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","De maneira nenhuma! Deus continuará a ser fiel mesmo que todos sejam falsos. Como dizem as Escrituras: “Você será provado justo nas suas palavras, e vencerá quando for julgado”. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Mas se ao fazermos o mal, mostramos mais claramente a justiça de Deus, poderemos nós dizer que Deus é injusto por nos castigar? (Falo em termos humanos.) ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","De maneira nenhuma! Se Deus não pudesse nos castigar, como Ele poderia julgar o mundo? ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Alguém pode dizer: “Mas se a minha falsidade serve para que a verdade de Deus seja mais gloriosa, por que sou julgado como pecador?” ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Isto é o mesmo que dizer: “Devemos fazer o mal para que venha o bem”. Há pessoas que nos acusam de ensinarmos isso. Tais pessoas estão erradas e deveriam ser condenadas. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Então o que se conclui? Que nós os judeus somos melhores do que os outros? De maneira nenhuma! Como já dissemos, todos os homens são igualmente pecadores; tanto os que são judeus como os que não são judeus. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Como dizem as Escrituras: “Não há ninguém sem pecado. Ninguém! ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Não há ninguém que entenda, ninguém que busque a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Todos se afastaram, todos ficaram sem qualquer valor. Não há ninguém que faça o bem. Ninguém!” ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Suas bocas são como túmulos abertos; usam a língua para mentir.” “O que dizem é como veneno de cobras!” ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“As suas bocas estão cheias de maldições e amargura.” ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Estão sempre prontos para matar ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","e para onde quer que vão causam ruína e miséria. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Não conhecem o caminho da paz.” ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Não tem nenhum respeito por Deus.” ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Sabemos que tudo o que a lei diz se aplica aos que estão debaixo dela: os judeus. Assim, ninguém poderá dar desculpas, e todo mundo ficará debaixo do julgamento de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Não há homem nenhum que, por fazer o que a lei manda, possa ser declarado justo diante de Deus. A lei simplesmente mostra o nosso pecado. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Mas agora nos foi revelada a maneira como Deus nos declara justos sem a lei, embora a lei e os profetas já a tivessem anunciado. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Deus declara o homem justo por meio da fé que ele tem em Jesus Cristo. Ele declara justas todas as pessoas que crêem em Cristo, porque não há distinção entre elas, ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","pois todas pecaram e portanto estão afastadas da glória de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Mas elas são declaradas justas de um modo gratuito, pela graça de Deus. Isto acontece porque, por meio de Jesus Cristo, elas são libertadas do pecado. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Com a morte de Cristo, Deus o apresentou como um sacrifício que traz o perdão dos pecados através da fé. Com este sacrifício, Deus provou que Ele é justo mesmo quando, em tempos passados, teve paciência com os homens e não lhes deu o castigo que seus pecados mereciam. Com este sacrifício, Deus também provou que Ele é justo nos tempos presentes, quando Ele perdoa os homens. Por causa deste sacrifício, Deus se mantém justo e, ao mesmo tempo, declara justos aqueles que têm fé em Jesus. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","O que aconteceu então com o orgulho humano? Foi eliminado! Será que ele foi eliminado pela obediência à lei? Não! É pela fé em Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Assim, cremos que o homem é declarado justo pela fé, e não por obedecer a lei. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Por acaso Deus é somente Deus dos judeus? De maneira nenhuma! Ele também é Deus de todos os outros! ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Há um só Deus! Ele vai declarar justos tanto os judeus pela sua fé, como também os que não são judeus pela fé que eles têm. ");
INSERT INTO por_WBTC_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Será que, quando seguimos a fé, estamos destruindo a lei? De maneira nenhuma! A fé nos faz ser o que a lei verdadeiramente quer que sejamos. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","O que devemos então dizer a respeito de Abraão, o pai do nosso povo? O que ele descobriu a respeito da fé? ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Se Abraão foi declarado justo pelas obras que fez, então tem com o que se gloriar; mas não diante de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","As Escrituras dizem: “Abraão teve fé em Deus e, pela sua fé, Deus o aceitou como justo”. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","O salário de quem trabalha não é considerado como um favor, mas como um direito. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","O pecador não pode fazer qualquer obra que o torne justo. Mas se ele tem fé naquele que declara justo o pecador, pela sua fé, Deus o aceita como justo. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Assim, Davi também falou da felicidade de uma pessoa a quem Deus aceita como justa, sem olhar para suas obras, quando disse: ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“As pessoas são realmente felizes quando Deus perdoa o mal que fazem, quando os seus pecados são cobertos! ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Quando o Senhor as aceita como se não tivessem pecado, então elas são realmente felizes”. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","É esta felicidade só para quem é circuncidado? Ou é também para os que não são circuncidados? Nós já dissemos que Deus aceitou a fé que Abraão tinha e que, por ela, Abraão foi aceito como justo. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Como aconteceu isto? Quando foi que Deus aceitou Abraão: antes ou depois da sua circuncisão? Deus o aceitou antes da circuncisão. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Mais tarde Abraão foi circuncidado para mostrar que Deus o tinha aceito. A sua circuncisão era a prova de que Deus o tinha considerado justo pela fé. Assim Abraão é o pai de todos os que têm fé embora não sejam circuncidados e, dessa forma, Deus também aceita como justos a todos eles. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Abraão também é o pai dos que são circuncidados, mas não é a circuncisão deles que o faz ser seu pai. Ele só é pai deles se viverem na fé que o nosso pai Abraão tinha antes de ser circuncidado. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Não foi por obedecer à lei que Abraão e seus descendentes receberam a promessa de que eles iriam herdar o mundo. Mas sim porque Deus, por causa da fé que Abraão tinha, o declarou justo. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Pois, se fosse possível receber a promessa de Deus por obediência à lei, não seria preciso a fé. E a promessa perderia todo o seu valor, ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","porque a lei provoca a ira de Deus quando as pessoas a ela não obedecem. Mas onde não há lei, não há nada para se desobedecer. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Assim, a promessa de Deus é dada pela fé, como oferta gratuita. Se essa promessa é gratuita, ela vale para todos os descendentes de Abraão. Não é somente para os que vivem sob a lei de Moisés, mas também para os que têm uma fé como a de Abraão. Ele é o pai de todos nós. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Como dizem as Escrituras: “Eu constituí você pai de muitos povos”. Ele é o nosso pai perante Deus. Abraão teve fé em Deus, o Deus que dá vida aos mortos e que faz existir o que não existe. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Não havia esperança alguma de Abraão vir a ter filhos, mas ele teve fé em Deus e continuou a esperar. Por isso veio a ser o pai de muitos povos. Conforme Deus lhe tinha dito: “Você vai ter muitos descendentes”. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abraão, com quase cem anos, era velho demais para poder ter filhos; além disso, Sara era estéril e não podia tê-los. Abraão sabia tudo isso, mas a sua fé não diminuiu. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ele nunca duvidou de que Deus pudesse cumprir a sua promessa, nunca perdeu a fé. Pelo contrário, a sua fé ficou mais forte e ele deu louvores a Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Abraão tinha a certeza de que Deus tem o poder de fazer aquilo que promete. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Assim, “Deus o aceitou como justo”. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Estas palavras (“Deus o aceitou como justo”), não foram somente escritas para o benefício de Abraão, ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","mas também foram escritas para nós. Deus também nos aceita porque cremos naquele que ressuscitou da morte a Jesus Cristo, nosso Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Jesus foi entregue para ser morto por causa dos nossos pecados e foi ressuscitado para que Deus pudesse nos declarar justos. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Portanto, desde que pela fé fomos declarados justos perante Deus, temos paz com Ele por meio de Jesus Cristo, nosso Senhor. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Através dele, pela fé, também pudemos entrar na graça de Deus, na qual agora nos encontramos. Portanto nos alegramos por causa da esperança que temos de participar da glória de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Além disso, até nos nossos sofrimentos nos alegramos, porque sabemos que o sofrimento produz a paciência; ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","a paciência produz caráter; e o caráter produz a esperança. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","A esperança não nos decepciona, pois Deus derramou o seu amor para encher os nossos corações por meio do Espírito Santo que nos foi dado. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Porque, quando não éramos capazes de nos salvar, Cristo morreu por nós, os pecadores, no momento certo. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Dificilmente alguém morreria para salvar a vida de uma pessoa justa; embora alguém possa ter coragem suficiente para dar a vida por uma pessoa boa. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Mas Cristo morreu por nós quando éramos pecadores. Assim Deus mostrou o grande amor que tem por nós. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Fomos declarados justos pelo sangue de Cristo. Com toda certeza, por meio dele, seremos salvos da ira de Deus. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Se, quando éramos inimigos de Deus, Ele estabeleceu a paz por intermédio da morte de seu Filho, muito mais agora, que estamos em paz com Deus, Ele nos salvará pela vida de seu Filho. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","E não é só isso! Nós também nos alegramos por esta nova relação que temos com Deus, pois por meio de Jesus Cristo, nosso Senhor, nós agora estamos em paz com Ele. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Assim como o pecado entrou no mundo por meio de um homem, e a morte por intermédio do pecado, também a morte passou a todos os homens, porque todos pecaram. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Antes da lei de Moisés ser dada, o pecado já existia no mundo. Porém, como não havia lei, o pecado não era levado em conta. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","No entanto, desde o tempo de Adão até Moisés, a morte teve poder mesmo sobre aqueles que não pecaram como Adão pecou quando desobedeceu a ordem de Deus. Adão era um modelo daquele que havia de vir. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","O pecado não se compara com a oferta gratuita de Deus. Pelo pecado de um homem, muitas pessoas morreram. Pela graça de um homem, Jesus Cristo, muitas pessoas receberam, em abundância, a graça de Deus e a sua salvação. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Adão foi condenado depois de ter pecado uma só vez, mas a oferta de Deus é diferente. A oferta de Deus salva as pessoas mesmo depois de terem pecado muitas vezes. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Pois, se a morte reinou pelo pecado de um homem, muito mais reinarão e viverão aqueles que recebem a graça abundante de Deus e a oferta gratuita de salvação, por meio de Jesus Cristo. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Assim, como por um pecado muitos foram condenados, também por uma ação justa muitos homens são declarados justos e viverão. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Assim, como pela desobediência de um homem muitos se tornaram pecadores, também pela obediência de um homem muitos se tornarão justos. ");
INSERT INTO por_WBTC_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","A lei veio para aumentar o pecado. Mas onde aum