﻿USE sofia;
DROP TABLE IF EXISTS sofia.pon2006a_vpl;
CREATE TABLE pon2006a_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pon2006a_vpl WRITE;
INSERT INTO pon2006a_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ni ahnsou me Koht tepin kapikada sampah oh mehkoaros me mi pahnlahng, ");
INSERT INTO pon2006a_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","sampah me liseliping de sohte mwomwe. Rotorot kipe wasa loal kan, oh ngehn en Koht kin ketiketseli pohn pihl kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Koht eri ketin mahsanih, “Marain en miehla”—marain ahpw pwarada. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Koht eri kupwurperenkihda lingan en maraino. E ahpw ketin katohrepeseng maraino oh rotorot, ");
INSERT INTO pon2006a_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","oh ketikihong eden maraino, “Rahn,” a eden rotoroto, “Pwohng.” Eri, pwohngo imwiseklahr oh marain en rahn pwarodohr—iei met wadepen keieun rahn. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Koht pil ketin mahsanih, “Pwalang ehu en miehla pwe en irepeseng pihl kan ong ni wasa tohrohr riau”—eri, e ahpw pweida. Koht eri ketin wiahda pwalang en lahng ehu me katohrepeseng pihl kan me mi pah oh powe. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Koht eri ketikihong eden pwalango, “Lahng.” Eri, pwohngo imwiseklahr oh marain en rahn pwarodohr—iei met wadepen keriaun rahn. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Koht pil ketin mahsanih, “Pihl kan me mi pahnlahng en kohpene wasateieu, pwe pwehl madekeng en pwarada”—eri, e ahpw pweida. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ih eri ketikihong eden pwehl madekengo “Sahpw,” a pihl kan me kohpene wasatehkis “Madau.” Koht eri kupwurperenkihda wiepen nin lime wet. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","E ahpw pil mahsanih, “Sahpw en kawosehda soangen tuhke koaros me kin kapwarehda wah laud oh wah tikitik”—eri, e ahpw pweida. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Eri, sahpw ahpw tapihada kawosehda soangen tuhke koaros me kin kapwarehda wah laud oh wah tikitik. Koht eri kupwurperenkihda wiepen nin lime pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Eri, pwohng imwiseklahr oh marain en rahn pwarodohr—iei met wadepen kesiluhwen rahn. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Koht pil ketin mahsanih, “Marain kei en miehla pahnlahng, mehn irepeseng rahn oh pwohng, oh mehn kilelehdi ahnsou me rahn akan, sounpar akan, oh iren ahnsou kan pahn kin tepida; ");
INSERT INTO pon2006a_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","re pahn kin lingaling pahnlahng oh kamakamarainih sampah”—eri, e ahpw pweida. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Koht eri ketin wiahda marain kalaimwun riau, iei ketipin me pahn kin kakaun nin rahn, oh maram me pahn kin kakaun nipwong; e pil ketin wiahda usu kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","E ketikidahng marain pwukat pahnlahng, pwe re en kin dakedaker sampah, ");
INSERT INTO pon2006a_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","kakaun rahn oh nipwong kan, oh ireirepeseng marain oh rotorot. Koht eri kupwurperenkihda wiepen nin lime pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Eri, pwohngo imwiseklahr oh marain en rahn pwarodohr—iei met wadepen kapahieun rahn. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Koht pil ketin mahsanih, “Soahng koaros me kin mie ar mour en audehla pihl akan, oh menpihr kan en audehla pahnlahng.” ");
INSERT INTO pon2006a_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Koht eri ketin kapikada mwahmw kalaimwun kan, oh soahng mour koaros me kin kousoan nan pihl, oh soangen menpihr koaros. Koht eri kupwurperenkihda wiepen nin lime pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","E ahpw ketin kupwuramwahwih irail koaros, mahsanih, “Kumwail koaros me momour nan pihl oh nansed, kumwail en kaparaparala oh audehla madau kan, a menpihr kan en pil tohtohla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Eri, pwohngo imwiseklahr oh marain en rahn pwarodohr—iei met wadepen kelimaun rahn. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Koht pil ketin mahsanih, “Pwelen sampah en kapwarehda soangen mahn mand oh lawalo koaros oh soangen mahn laud oh tikitik koaros”—eri, e ahpw pweida. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Koht eri ketin wiahda soangen mahn pwukat koaros. E ahpw kupwurperenkihda wiepen nin lime pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Koht eri pil ketin mahsanih, “A met kitail pahn wiahda aramas; kitail pahn wiahda aramas rasehng kitail. Re pahn ahneki manaman en kaunda mwahmw akan, menpihr kan, mahn mand oh lawalo, mahn laud oh tikitik koaros.” ");
INSERT INTO pon2006a_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Koht eri ketin wiahda aramas; e ahpw ketin wiahda aramas rasehng ih. E ketin wiahda ohl oh lih, ");
INSERT INTO pon2006a_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","oh kupwuramwahwih ira, mahsanih, “Kumwa kaparaparala pwe kadaudokamwa kan pahn kousoanla wasa koaros nin sampah oh kaunda mehkoaros. I kihong kumwa manaman en kaunda mwahmw akan, menpihr kan oh mahn lawalo kan koaros.” ");
INSERT INTO pon2006a_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Koht ahpw pil ketin mahsanihong ira, “Kumwa kilang pwe I kihong kumwa met soangen tuhke koaros me wararail kin mie, oh soangen wahntuhke koaros, pwe kumwa en wiahki amwa mehn tungoal; ");
INSERT INTO pon2006a_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","a ong mahn lawalo kan oh pil ong menpihr kan, I kihong tehntuhke kan oh kisintuhke kan pwe re en kin kangkang”—eri, e ahpw pweida. ");
INSERT INTO pon2006a_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Koht eri inenen kupwurperenkihda wiepen nin lime pwukat koaros. Eri, pwohngo imwiseklahr oh marain en rahn pwarodohr—iei met wadepen keweneun rahn. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Eri, wiepen sampah oh pahnlahng oh audepara kan koaros ahpw imwisekla. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Koht eri ketin kaimwisekala sapwellime doadoahk me e ketin wiewia kohdo, oh ketin kommoaldi ni keisuhn rahn. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","E ahpw ketin kupwuramwahwih keisuhn rahno, oh ketin kasarawihala pwe en wiahla rahn sarawi ehu, pwehki ih rahno me e ketin kaimwisekala wiepen nin lime kan oh ketin kommoaldihsang sapwellime doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ih duwen sampah eh wiawihda oh mehkoaros pahnlahng eh kepikipikda. Eri, ni ahnsou me KAUN-O Koht ketin wiahda sampah oh mehkoaros pahnlahng, ");
INSERT INTO pon2006a_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","sohte kisin tuhke pwoat mie nin sampah, pil sohte kisin werentuhke kis wosada, pwehki Koht eh sohte ketin kamwerehdi keteu pohn sampah; oh sohte aramas me pahn koadoahki pwelen sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Eri, mehnda ma sohte keteu, ahpw pihl kin kuskusdahsang nanpwel oh kin kalakalamwur sampah pwon. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","KAUN-O Koht eri ketikihda nesen pwehl ehu sang nanpwel oh ketin wiahkihda war ehu me mwomwen aramas. E ahpw ketikihong ni waro angin mour; ni ahnsowohte mour ahpw miehla ni paliweren aramaso. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","KAUN-O Koht eri ketin wiahda mwetuwel ehu ni palimese, me adaneki Ihden; oh ketikihong loale aramaso me e ketin wiahda. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","E ahpw ketin kakairada soangen tuhke kaselel koaros oh soangen tuhke me wah kan kin mwahu ong tungoal. Nan werengen mwetuwelo mie tuhke riapwoat, iei tuhkehn komour oh pil tuhkehn kehsehki aramas dahme mwahu oh dahme suwed. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Pillap pwoat kin pwilipwilsang nan Ihden pwe en kin kalamwur mwetuwelo; e ahpw kasangpeseng wiahda kahngen pillap pahieu. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Keieun kahngo adaneki Pison; eri, ih pillap me tang kapilpene wehin Apila unsek. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Ih wasakiset me kohl kaselel kin dierek ie, iangahki pwilin tuhke kesempwal, oh kisin takai kesempwal kin rek ie.) ");
INSERT INTO pon2006a_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Keriaun pillapo adaneki Kihon; me kapilpene wehin Kus. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Kesiluhwen pillapo me adaneki Daikris, e tang ni palimesehn wehin Asiria. Kapahieun pillapo, iei Iupreitis. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","KAUN-O Koht eri ketikihdiong aramaso nan mwetuwel en Ihden pwe en kin apwahpwalih oh sinsile. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","E ahpw mahsanihong, “Ke kak tungoale wahntuhke koaros me mi nan mwetuwelet, ");
INSERT INTO pon2006a_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ahpw ihte wahntuhkehn kehsehki aramas dahme mwahu oh dahme suwed me ke sohte pahn tungoale, ma ke pahn tungoale, ke pahn mehkihla rahnohte.” ");
INSERT INTO pon2006a_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","KAUN-O Koht pil ketin mahsanih, “E sohte konehng aramas menet en kelekelehpw. I pahn wiahiong eh werek en wia sawasepe.” ");
INSERT INTO pon2006a_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Eri, Koht ahpw pil ketin wiahda sang pwehl soangen mahn akan koaros oh soangen menpihr kan koaros. E ahpw ketikihong aramaso pwe en kihong adarail. Eri, ahd akan me e kihong emenemen, iei ih me re adaneki. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Eri, aramaso ahpw kihong eden menpihr kan, oh mahn akan koaros; ahpw e sohte diarada emen me konehng eh werek mehn sewese. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Eri, KAUN-O Koht ahpw ketin kameirkelikihala aramaso, oh nindokon eh memeir, Koht ahpw ketikihsang apwoat tihnkopwouwih ko, oh ketin pwurehng kapwurepene uduk en wasao. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","E ahpw ketin wiahda lih emen sang tihnkopwou me e ketikihsang rehn aramaso, oh ketin kahredohng aramaso. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Aramaso eri patohwan, “Iei met emen me rasehng iehte— tih me sang tih kat, oh uduk sang ni udukei. E pahn adaneki ‘Lih’ pwehki eh kohsang rehn ohl.” ");
INSERT INTO pon2006a_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Iei kahrepe wet me ohl emen pahn kin mweikihsang seme oh ine oh ehukihong eh pwoud, pwe ira en kin wiahla ehu. ");
INSERT INTO pon2006a_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Eri, ira koaros, ohlo oh liho, ira kilisou; ira ahpw sohte kin namenengki. ");
INSERT INTO pon2006a_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Eri, sineik ih mahn me keieu mwersuwed nanpwungen mahn akan me KAUN-O Koht ketin wiahda. E ahpw idekda rehn liho, “Mehlel apwoat me Koht ketin keinepwihsang kumwa en dehr tungoale wahntuhke kan en nan mwetuwelet?” ");
INSERT INTO pon2006a_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Liho eri sapengki, “Se kak tungoale wahntuhke koaros en mwetuwelet, ");
INSERT INTO pon2006a_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ihte wahntuhke me mi nanwerengeo me se sohte kak tungoale. Koht ketin keinepwihsang kiht wahntuhke pwoatet se en dehr tungoale de sair, pwe se de mehkihla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Sineiko ahpw sapengki liho, “Likamw pwoat men; kumwa sohte pahn mehla. ");
INSERT INTO pon2006a_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Koht mahsanih men pwehki eh mwahngih me ni ahnsowohte me kumwa pahn tungoale wahntuhkehn, kumwa pahn marainla oh duwehla Koht, pwe kumwa pahn esehla dahme mwahu oh dahme suwed.” ");
INSERT INTO pon2006a_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Liho eri lingankihda tuhkeo oh men tungoalehda wah ko; e ahpw lemehda kamwahupen eh pahn marainla. Ih eri dolung wahntuhkeo oh tungoale. E ahpw pil kihong eh pwoudo pwe en pil iang tungoale. Eh pwoudo ahpw pil iang tungoale. ");
INSERT INTO pon2006a_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ni ahnsowohte me ira tungoale, ira eri marainla oh diarada me ira kilisou; ira eri pahda tehntuhke pihk kei, wiahkihda ara koahl oh koalehda. ");
INSERT INTO pon2006a_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Nin soutik en rahno, ira ahpw rongada KAUN-O Koht eh ketiketseli nan mwetuwelo; ira ahpw rukula nanwerengen tuhke ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","A KAUN-O Koht ahpw malipe ohlo, mahsanih, “Ia kowe?” ");
INSERT INTO pon2006a_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ohlo ahpw sapeng, patohwan, ‘I patohwan rongada omwi ketiketseli nan mwetuwelet; I ahpw patohwan masepwehkada oh rukusang komwi, pwehki ei kilisou.” ");
INSERT INTO pon2006a_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Koht eri ketin keinemwe, “Pwe ihs me ndaiong uhk me ke kilisou? Ke so tungoalehda wahntuhke me I keinepwihsang uhko?” ");
INSERT INTO pon2006a_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ohlo ahpw patohwan sapeng, “Lih me komw ketikihong ieo me patohwanohng ie I en tungoale, iei me I tungoalehkihda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","KAUN-O Koht ketin keinemwe rehn liho, “Dahme ke wiahkihda met?” Liho ahpw patohwan sapeng, “Sineiko me keteweiehdi, ihme I patohwan tungoalehkihda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","KAUN-O Koht eri mahsanihong sineiko, “Pwehki omw wiadahr met, ke pahn alehki kalokolok; kowehte me pahn pwukoahki keria wet. Sang met kohla ke pahn kin limwahdengki kapehdomw, oh pwehl me pahn kin wia konomw kisin mwenge erein omw mour. ");
INSERT INTO pon2006a_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kowe oh liho pahn kin imwintihtipene; nein liho oh pil noumw kan pahn pil kin imwintihtipene kohkohlahte. Aramas akan pahn sok pohn moangomwen pwe en kamwutepene; oh ke pahn ke keimwen neh.” ");
INSERT INTO pon2006a_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","E ahpw pil mahsanihong liho, “I pahn katohtowehla omw apwal kan ni omw pahn kin liseian, oh kalaudehla omw medek en neitik, ahpw ke pahn kin ininangihete omw pwoud, oh ih me pahn kin kaunuhkada.” ");
INSERT INTO pon2006a_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","E ahpw pil mahsanihong ohlo, “Pwehki omw dukiong omw pwoudo oh tungoalehda wahntuhke me I keinepwihsang uhko, pwehki soahng wet me ke wiadahr, pwelin sampah pahn rialahr. Ke pahn doadoahk laud erein omw mour, pwe pwelin sampah en kawosada kisin mwenge me pahn itarohng uhk. ");
INSERT INTO pon2006a_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","E pahn kawosada dihpw tekatek oh reh, oh ke pahn kin tungoale wahntuhkehn nanwel kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ke pahn doadoahk oh kakerehdi pwudowomw, pwe ke en koadoahkihada wahn pwelin sampah, ke lao pwurehng wiepwella, me ke wiawihda sang ie. Pwe ke wiawihda sang pwehl oh ke pahn pwurehng wiepwella.” ");
INSERT INTO pon2006a_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam eri kihong eden eh pwoudo Ihp pwehki eh wia inen aramas momour koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","KAUN-O Koht eri ketin wiahiong Adam oh eh pwoud ara likou kilinmen, oh ketin kalikawihkinirahda. ");
INSERT INTO pon2006a_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","KAUN-O Koht eri mahsanih, “Met aramas menet duwelahr emen kiht, pwehki eh esedahr dahme mwahu oh dahme suwed. E sohte pahn mweimweiong en tungoale wahntuhkehn komour oh en ahneki mour poatopoat.” ");
INSERT INTO pon2006a_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","KAUN-O Koht eri ketin kausasang tepin aramas nan mwetuwel en Ihden, pwe en kin koadoahki pwelin sampah me pein ih wiawihda sang ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Koht ahpw ketikihong ni palimesehn mwetuwel en Ihden kerup kei, oh kedlahs kisiniei pwoat me mpwul sirangarang pali koaros, pwe en silehsang aramas koaros tuhken komouro. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam eri wiahiong nsenen pwopwoud ong eh pwoudo, liho eri liseianda. Liho naitikihada pwutak emen; ih eri patohwan, “I nainekidahr pwutak emen sang ni kalahngan en KAUN-O.” Ih eri kihong ede Kain. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Mwuri, e ahpw naitikihada pil emen pwutak, Eipel. Eipel eri wiahla sounsilepen sihpw, a Kain wia ohl en sapwasapw men. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mwurin ahnsou kei Kain ahpw wahdo ekei wahnsapwe ko oh meirongkihong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","A mwuri, Eipel ahpw kihda mesenihen nah sihpw akan oh kemehla, pwe en meirongkihong KAUN-O uduk me keieu kaselel en sihpwo. KAUN-O eri kupwurehla Eipel oh kupwurperenkihda eh meirongo, ");
INSERT INTO pon2006a_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ahpw e sohte ketin kupwure Kain oh eh meirongo. Iei me Kain lingeringerkihda kowahlap oh pohtoutoukihla. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","KAUN-O eri mahsanihong Kain, “Dahme ke lingeringerki oh pohtoutouki? ");
INSERT INTO pon2006a_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ma ke wia mehkot pwung, ke pahn pereperen; a pwehki omw wiadahr mehkot suwed, dihp rasehng mahn lawalo men me nektehn poar pohmw. E men kaunuhkada, ahpw ke uhdahn pahn powehdi.” ");
INSERT INTO pon2006a_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kain eri ndaiong rie Eipel, “Kita kolahng mwemweit nan mohso.” Ni ara lel nan mohso, Kain sohpeiongete rieo kemehla. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","KAUN-O ketin keinemwe rehn Kain, mahsanih, “Ia riomwo, Eipel?” A e sapeng, patohwan, “I sohte patohwan. Dah? Ngehi silepen rieio?” ");
INSERT INTO pon2006a_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","KAUN-O eri mahsanih, “Dahme ke wiahkihda suwed mwuledek wet? Ntahn riomwo likilikwerih ie sang nanpwel, likamwete ngihl ehu me pekipeki I en ikih. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ke rialahr, oh ke pahn pekeussang pohn pwelen sahpw wet me direkilahr ntahn riomwo. Likamwete e sarapeseng pwe en ale ntao sang ni pehmwen. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ma ke pahn sapwasapw, pwelen sahpw sohte pahn kawosadahng uhk mehkot; ke pahn sansaruaruseli nin sampah.” ");
INSERT INTO pon2006a_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain ahpw patohwanohng KAUN-O, “Kalokolok wet me nohn laud mehlel. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Rahnwet komw ketin kasareiesang nan sahpw wet oh sang mwohn silangmwi. I pahn sansaruaruseli nin sampah, oh mehmen me diar ie pahn kemeiehla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","A KAUN-O ketin sapeng, mahsanih, “Soh! Pwe mehmen me pahn kemeiukala, I pahn ikih suwed sang pahn pak isipak.” KAUN-O eri ketikihdiong pohn Kain kilel ehu, mehn kehsehki koaros me pahn kin tuhwong, pwe re de kemehla. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kain eri patopatohla sang mwohn silangin KAUN-O oh kousoanla nan sahpw ehu me adaneki “Saruaru,” ni palimesehn Ihden. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain oh eh pwoudo ahpw naitikihada pwutak emen, oh kihong ede Enok. Kain eri kauwada kahnimw ehu oh kihong eden nah pwutako. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok pil wiahda nah pwutak emen me adaneki Irad, me wia semen Meusael, a Meusael nainekihda pwutak emen ede Medusael, me wia semen Lamek. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek ahpw pwoudikihda lih riemen, eden emen Ada, a emen Silla. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada kaipwidi Sapal, pahpa kahlap en irail ko me kin kousoan nan impwal akan oh kin apwalih pelinmen kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Eden rieo Supal, pahpa kahlap en sounkeseng koaros me kin kesengki arp oh mehn pepeuk. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silla kaipwidi Tupal Kain, pahpa kahlap en sounwia mete koaros me kin wiahkihda dipwisou kan prons oh mete. Rien Tupal Kain serepein adaneki Naama. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek eri ndaiong eh pwoud ko, “Ada oh Silla, kumwa rong ie mahs: I kemehla mwahnakapw emen pwehki eh wokihiehdi. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ma mehmen me pahn kemehla Kain pahn ale kalokolok pak isipak, a mehmen me pahn kemeiehla pahn ale kalokolok pak isihsek isuh.” ");
INSERT INTO pon2006a_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam oh eh pwoudo ahpw pil naitikihada pil emen pwutak. Liho eri patohwan, “Koht ketikihong ie nei pwutaket pwe en wiliandi Eipel, me Kain kemelahr.” Ih eri kihong eden pwutako, Sehd. ");
INSERT INTO pon2006a_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sehd eri wiahda pwutak emen me e kihong ede Enos. Ih ahnsou me aramas akan tapihada kaudok ni mwaren KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ih met kadaudok en Adam kan. (Ni rahn me Koht ketin wiahda aramas akan, e ketin wiairailda rasehng ih. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","E ketin wiahda ohl oh lih, kupwuramwahwihirahla oh ketin kahdanekinirahla “Aramas.”) ");
INSERT INTO pon2006a_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ni Adam eh sounpar 130, e nainekihda pwutak emen duwehte ih, oh e kihong ede Sehd. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Mwurin met Adam pil momourki sounpar 800 oh pil nainekihda seri kei, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","e ahpw sipalla ni eh sounpar 930. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ni Sehd eh sounpar 105, e nainekihda pwutak emen, ede Enos, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","oh mwuri e momourki sounpar 807. E nainekihda pil seri kei, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","e ahpw sipalla ni eh sounpar 912. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ni Enos eh sounpar 90, e nainekihda pwutak emen, ede Kenan, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","oh mwuri e pil momourki sounpar 815. E pil nainekihda seri kei, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","e ahpw sipalla ni eh sounpar 905. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ni Kenan eh sounpar 70, e nainekihda pwutak emen, ede Maalalel, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","oh mwuri e pil momourki sounpar 840. E nainekihda pil seri kei, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","e ahpw sipalla ni eh sounpar 910. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ni Maalalel eh sounpar 65, e nainekihda pwutak emen, ede Sared, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","oh mwuri e pil momourki sounpar 830. E pil nainekihda seri kei, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","e ahpw sipalla ni eh sounpar 895. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ni Sared eh sounpar 162, e nainekihda pwutak emen, ede Enok, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","oh mwuri e pil momourki sounpar 800. E pil nainekihda seri kei, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","e ahpw sipalla ni eh sounpar 962. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ni Enok eh sounpar 65, e nainekihda pwutak emen, ede Medusala, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","mwurin met, Enok momourki sounpar 300 mwohn silangin Koht oh pil nainekihda seri kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enok eri momourki sounpar 365. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","E momour mwohn silangin Koht erein eh mour, e ahpw sohrala pwehki Koht eh ketin ketikihsang sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ni Medusala eh sounpar 187, e nainekihda pwutak emen, ede Lamek, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","oh mwuri e pil momourki sounpar 782. E pil nainekihda seri kei, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","e ahpw sipalla ni eh sounpar 969. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ni Lamek eh sounpar 182, e nainekihda pwutak emen; ");
INSERT INTO pon2006a_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","e ahpw mahsanih, “Sang nan pwehl me KAUN-O ketin kerialahr, seri menet pahn kamaiawihkitailda sang atail apwal akan”; ih eri kihong ede Noha. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamek eri pil momourki sounpar 595. E pil nainekihda seri kei, ");
INSERT INTO pon2006a_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","e ahpw sipalla ni eh sounpar 777. ");
INSERT INTO pon2006a_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Mwurin Noha eh lel sounpar 500, e nainekihda pwutak silimen, Sehm, Ahm, oh Saped. ");
INSERT INTO pon2006a_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ni ahnsowo aramas ngeder kaparaparalahr wasa koaros nin sampah, oh serepein kan ipwidier. ");
INSERT INTO pon2006a_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ekei nein koht ko ni ar kilangada lingan en serepein ko, re ahpw pwoudikihda me re mwahuki kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","KAUN-O eri mahsanih, “I solahr pahn mweidohng aramas re en mour kohkohlahte; pwe re pahn mehla. Sang met kohla re solahr pahn daulih sounpar 120.” ");
INSERT INTO pon2006a_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ni ahnsowo oh pil mwurihdohsang, mie kodon kei nin sampah, kadaudok en lih aramas akan oh koht ko. Iei irail me aramas kommwad oh ndand en mahsie. ");
INSERT INTO pon2006a_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ni KAUN-O eh ketin mahsanihada duwen aramas akan ar suwedlahr nin sampah, oh ar lamalam akan eh kin suwed ahnsou koaros, ");
INSERT INTO pon2006a_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","e ahpw koluhkihla eh ketin wiahda aramas oh ketikihdiong nin sampah. Kupwure eri toutoukihla, ");
INSERT INTO pon2006a_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","iei me e mahsaniheki, “I pahn kamwomwasang aramas koaros me I wiadahr, iangahki mahn akan oh menpihr kan, pwehki I koluhkilahr ei wiairailda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ahpw Noha kelehpw me keniken pahn kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Iet duwen poadopoad en Noha. E naineki pwutak silimen, Sehm, Ahm, oh Saped. Ohl lelepek men Noha, oh ihete me keniken rehn Koht ahnsowo. Eh mour poadidiong Koht, ");
INSERT INTO pon2006a_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","a aramas teikan koaros suwed mwohn silangin Koht, oh kamaramas kaparaparalahr wasa koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Mwohn silangin Koht sampah inenen suwed mehlel, pwehki aramas akan ar dipanlahr kowahlap. ");
INSERT INTO pon2006a_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Koht eri mahsanihong Noha, “I koasoanedier en kamwomwala aramas koaros. I pahn kamwomwala douluhl irail koaros, pwehki sampah direkilahr arail wiewia suwed kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Eri, wiahda weromw warihmw ehu sang tuhke mwahu; wiahda loale pere kei, oh litopwiheki loale oh liki tahr. ");
INSERT INTO pon2006a_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","E pahn reireiki piht 450, oh tehlepe piht 75, oh ile piht 45. ");
INSERT INTO pon2006a_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Wiahiong pwelengen warihmwen, oh nanpwungen pwelenge oh keile kan wehwe ieu en mie, me uwe ins 18. E pahn poasoake siluh, oh ke pahn wiahda wenihmw ehu ni pengepenge. ");
INSERT INTO pon2006a_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Pwe I pahn kadardiong sampah nohlik ehu pwe en kamwomwala mehkoros me momour nin sampah. Mehkoaros nin sampah pahn mehla, ");
INSERT INTO pon2006a_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","a ngehi I pahn kauwada ei inou nanpwungata. Eri, ke pahn pedolong nan warihmwo, iangahki omw pwoud, noumw pwutak kan oh ar pwoud kan, ");
INSERT INTO pon2006a_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","oh pil mahn akan, wad riemen ohl oh lih, sang ni soangen mahn koaros, oh sang ni soangen menpihr koaros, pwe re en iang uhk mourla. ");
INSERT INTO pon2006a_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Wahda soangen mwenge koaros me ke pahn kin tungoale oh irail pahn kin kangkang.” ");
INSERT INTO pon2006a_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noha eri ahpw kapwaiada mehkoaros me Koht ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","KAUN-O ahpw mahsanihong Noha, “Pedolong nan warihmwen, iangahki omw peneinei koaros; pwe kowehte rehn aramas pwukat me I diarada me kin wia dahme pwung. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Sehrehlong pwopwoud en mahn wad isuh sang ni soangen mahn mwakelekel koaros, ahpw pwopwoud wad ehu sang ni soangen mahn samin koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Pil sehrehlong pwopwoud en menpihr wad isuh sang ni soangen menpihr kan koaros. Ke pahn wia met pwe soangen mahn oh menpihr koaros en mourla, pwe re en kak pwurehng kaparaparala nin sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pwe mwurin rahn isuhte I pahn tapihada kamwerediong pohn sampah keteu me pahn mweremwer erein rahn pahisek oh pwohng pahisek, pwe en kamwomwala soahng mour koaros me I wiadahr.” ");
INSERT INTO pon2006a_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noha eri kapwaiada mehkoaros me KAUN-O ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noha sounpar 600 ahnsou me nohlik lapalap lelohng sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ih, eh pwoudo, nah pwutak ko, oh ar pwoud kan eri pedolong nan warihmwo pwe re en pitsang nohlik lapalapo. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Soangen mahn oh menpihr koaros ohl oh lih, me mwakelekel oh samin, ");
INSERT INTO pon2006a_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","re pil iang Noha pedolong nan warihmwo, duwen me Koht ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Mwurin rahn isuh nohlik lapalapo ahpw lel sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ni Noha eh sounpar 600, ni eisek isuhn Mei, keriaun sounpwong, pwarer koaros me mi pahn madau lapalap akan en sampah kakusada audeparail, oh pahnlahng likamwete e pwoarpeseng pwe en kakusedi pile kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Eri, keteu ahpw mweremwerki rahn pahisek oh pwohng pahisek. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Rahnohte Noha oh eh pwoudo, nah pwutak silimen, Sehm, Ahm oh Saped, iangahki ar pwoud kan, re ahpw pedolong nan warihmwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Soangen mahn akan koaros, mahn lawalo oh mahn mand, mahn laud oh tikitik, oh pil soangen menpihr kan koaros, pil iang irail pedolong. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ohl oh lih sang ni soangen mahn oh menpihr koaros, re pil iang Noha pedolong nan warihmwo, ");
INSERT INTO pon2006a_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","duwen me Koht ketin mahsanih. KAUN-O eri ketin ritingedi wenihmwen warihmwo sang liki. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Nohlik lapalapo ahpw wiewiawihki rahn pahisek, oh pihl kan lalaudlahte lao kapehda warihmwo sang nanpwel. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Pihlo inenen loalada mehlel, me kahrehda warihmwo peipeiseli powe. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Pihlo ahpw kohkohda oh koaduhpwaldi nahna me keieu ileile kan; ");
INSERT INTO pon2006a_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","e ahpw pil sikdahsang kumwen nahna ileile kan piht 25. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Soahng koaros me momour nin sampah ahpw mehla—menpihr kan, mahn akan, oh aramas akan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Soahng koaros me momour nin sampah mehla. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","KAUN-O ketin kamwomwala soahng momour koaros nin sampah— aramas akan, mahn akan, oh menpihr kan. Ihte me luhwe Noha oh irail ko me iang pedolong nan warihmwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Pihl akan eri mihmihte oh lalaudlahte pohn sampah erein rahn 150. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Koht sohte ketin meliehla Noha oh mahn akan koaros me iang mihmi nan warihmwo; iei me e kupwurehda en ketin ipiralahng pohn sampah kisinieng ehu, me kahrehda pihl kan ar tapihada pwuredi. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Pwarer en madau kan pahn sampah, oh pwoaren pahnlahng kan ahpw pinapinla. Keteu en nanleng ahpw tokedi, ");
INSERT INTO pon2006a_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","pihlo ahpw wie ngalangaldi erein rahn 150, ");
INSERT INTO pon2006a_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","oh ni eisek isuhn Oktoper, keisuhn sounpwong, warihmwo ahpw serada pohn nahnahn Ararat. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Pihl kan wia tikitiklahte, lel ni keieun Senweri, kaeisek en sounpwong, ahnsou me kumwen nahna kan pwarada. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Mwurin rahn 40 Noha ahpw ritingada wenihmwen warihmwo ");
INSERT INTO pon2006a_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","oh kapihrei menpihr toantoal emen. E pihriei oh pipihrseli lao pihl kan madadahsang pohn sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Mwuhr, Noha ahpw kadarei mwuroi men, mehn kehsehki ma pihl kan tikitiklahr, ");
INSERT INTO pon2006a_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ahpw pwehki pihl kan kipekipehte sampah, mwuroio sohte diar wasa e pahn sokedi ie. Noha eri kapaieila peho oh ale mwuroio, kapwurehlong nan warihmwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noha eri awiawihete mwurin rahn isuh e ahpw pil kadar mwuroio. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Mwuroio ahpw pwurodo nin soutik, ilahda tehntuhke olip ehu me ahpwtehn wosada. Noha eri esekihda me pihl kan sosohredihsangehr pohn sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","E ahpw pil komodoaloanki erein rahn isuh; e ahpw pil kadarei mwuroio; eri mwo, mwuroio sohte pwurodo. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ahnsou me Noha sounpar 601, ni keieun Eipril, keieun sounpwong, pihl akan ngalangaldier douluhl pohn sampah. Noha eri kihsang pwelengen warihmwo, e ahpw kilengiei oh kilangada duwen sahpw eh madekenglahr. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ni 27 en Mei, keriaun sounpwong, sampah eri madekengda douluhl. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Koht eri mahsanihong Noha, ");
INSERT INTO pon2006a_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Pedoisang nan warihmwen, iangahki omw pwoud, noumw pwutak kan oh ar pwoud kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kahreiei mahn akan oh menpihr kan koaros, pwe re en kaparaparala oh kipehdi wasa koaros nin sampah.” ");
INSERT INTO pon2006a_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noha eri pedoisang nan warihmwo, iangahki eh pwoudo, nah pwutak ko oh ar pwoud kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Mahn akan oh menpihr kan koaros ahpw pil pedohi wad soangen mahn akan sang loale. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noha eri kauwadahng KAUN-O pei sarawi ehu; e ahpw pilada mahn ekei wad emen sang rehn mahn mwakelekel oh menpihr ko, e ahpw meirongkihla pohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","KAUN-O eri kupwurperenkihda pwohn meirongo, e ahpw mahsanih, “I solahr pahn keriahla sampah kohkohlahte pwehki sapwung en aramas akan; pwe I ese me sang ni ar tikitik ar lamalam akan kin uhwongete ni me suwed. Eri, I solahr pahn pwurehng kamwomwala mour koaros nin sampah, duwen me I wiahier met. ");
INSERT INTO pon2006a_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Nindokon sampah eh pahn mihmihte, ahnsoun kamwarak oh ahnsoun dolung pahn mie. Ahnsoun pou oh ahnsoun karakar pahn mie; rahn oh pwohng pahn mie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Koht ahpw ketin kupwuramwahwiheki Noha oh nah pwutak ko mahsen wet: “Kumwail kaparaparala pwe kadaudokamwail kan en kousoanla wasa koaros nin sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mahn koaros en sampah, iangahki menpihr kan oh mwahmw akan, pahn lammwikin kumwail. Koaros pahn mi pahn amwail manaman. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kumwail kak tungoale soahng me momour koaros oh pil tuhke koaros. I kihong kumwail koaros pwe kumwail en wiahki amwail mehn tungoal. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ihte me kumwail sohte pahn tungoalehn: uduk me mie nta, I sohte mweidada pwehki mour mi nan nta. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Mehmen me pahn kihsang amwail mour, I pahn kalokehki mehla, oh I pahn kauwehla mahn emen me pahn kemeikumwailla. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Mehmen me pahn kemehla aramas, e pahn kamakamala rehn aramas; pwe aramas wiawihda rasehng Koht. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Kumwail eri kaparaparala pwe kadaudokamwail kan en tohtohla oh kousoanla wasa koaros nin sampah.” ");
INSERT INTO pon2006a_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Koht pil mahsanihong Noha oh nah pwutak ko, ");
INSERT INTO pon2006a_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Eri, met I pahn kauwada ei inou rehmwail oh rehn kadaudokamwail kan, ");
INSERT INTO pon2006a_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","oh pil rehn mahn mour koaros me mi rehmwail—menpihr kan oh mahn akan—oh mehkoaros me kohieisang nan warihmwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Eri, iet audepen ei inou en: I inoukihda me I solahr pahn pwurehng kauwehkihla nohlik lapalap soahng me momour kan nin sampah. Solahr pil ehu nohlik lapalap pahn wiawi pwe en kauwehla sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Eri, iet kilel poatopoat en ei inou ong kumwail oh ong soahng me momour kan koaros: ");
INSERT INTO pon2006a_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ahia pwoat me I padokadahng nan depwek kan. Ih me pahn wia kilel en ei inou ong sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ahnsou koaros me I pahn kapwarehda depwek pohn sampah oh ahia pwoat pahn sansal nan depwek kan, ");
INSERT INTO pon2006a_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","I pahn kin tamanda ei inou ong kumwail oh ong mahn akan koaros, duwen nohlik lapalap eh solahr pahn wiawi pwe en kauwehla soahng me momour kan koaros nin sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Eri, ni ahia eh pahn kin pwarada nan depwek kan, I pahn kin kilang oh tamanda inou poatopoat wet me mie nanpwungen ngehi oh soahng me momour kan koaros nin sampah.” ");
INSERT INTO pon2006a_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Koht ahpw pil mahsanihong Noha, “Ih met kilel en inou me I padokadahr nanpwungen ngehi oh soahng me momour kan koaros nin sampah.” ");
INSERT INTO pon2006a_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nein Noha ko me iang kohieisang nan warihmwo, iei Sehm, Ahm (semen Kenan), oh Saped. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nein Noha pwukat silimen iei irail me semen aramas koaros nin sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noha, ohlen wia sapwasapw men. Ih me tepin wiahda mwetuwel en wain ehu. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mwurin eh tungoale wain en eh mwetuwelo, e ahpw sakaula mehlel oh kilisouda wendiong nan imwe impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Eri, Ahm, semen Kenan, ni eh kilangada duwen semeo eh kilisou, e ahpw kohla oh padahkihong rie ko, Sehm oh Saped. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sehm oh Saped eri ale likou reirei ehu, kidahng pohn pwopwara oh kahsekirla nan impwalo oh pwaindi samarao. Masara ko sohsohpeisangete pwe ira dehr kilang samarao ni eh kilisou. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ni waino eh sarada oh Noha eri esehda dahme nah me tikitiko wiahiong, ");
INSERT INTO pon2006a_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","e ahpw patohwan, “Kenan en riahla! E pahn wiahla lidun rie kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Kaping ong KAUN-O, Koht en Sehm! Kenan pahn wiahla lidun Sehm. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Koht en ketin kaparahla Saped! Kadaudoke kan en kousoanla rehn nein Sehm kan! Kenan pahn wiahla lidun Saped.” ");
INSERT INTO pon2006a_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Eri, mwurin nohlik lapalapo, Noha pil momourki sounpar 350. ");
INSERT INTO pon2006a_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","E ahpw sipalla ni eh sounpar 950. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Iet kadaudok en nein Noha pwutak kan, Sehm, Ahm, oh Saped. Me silimenet naineki pwutak kei me ipwidi mwurin nohlik lapalapo. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Nein Saped pwutak kan iei—Komer, Makok, Madai, Sapan, Tupal, Mesek, oh Tiras—iei irail pwukat me wia pahpa kahlap en aramas ako me weuwa adarail kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Kadaudok en Komer iei irail mehn Askenas, Ripahd, oh Tokarma. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Kadaudok en Sapan iei irail mehn Elisa, mehn Spein, Saiprus, oh Rodes. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Iei irail me wia pahpa en aramas ako me kin koukousoan limwahn oaroahr oh nin deke kan. Ih met kan kadaudok en Saped, me kin koukousoan wasa kan rehn kadaudokarail tohrohr kan oh wasa kan, ehuehu pwihn kin lokaiahki pein ar lokaia. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Nein Ahm kan iei—Kus, Isip, Lipia, oh Kenan—irail me pahpa kahlap en aramas ako me weuwa adarail kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kadaudok en Kus iei irail mehn Sepa, Apila, Sapta, Raama, oh Sapteka. Kadaudok en Raama iei mehn Sipa oh Dedan. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus naineki pwutak emen ede Nimrod, me wiahla sounpei keieu lapalap emen nan sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Sang ni kupwur kalahngan en KAUN-O e wiahla sounkesik koahiek men, iei kahrepen aramas akan ar kin nda, “KAUN-O en ketin kupwurei komwi pwe komwi en wiahla sounkesik koahiek men duwehte Nimrod!” ");
INSERT INTO pon2006a_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nin tapio eh wehi iangahki Papilon, Erek, oh Akad, wasa siluh pwukat koaros mi nan Papilonia. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Sang nan wehio e ketila Asiria oh kauwada kahnimw kan en Ninipe, Rehopod Ir, Kala, ");
INSERT INTO pon2006a_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","oh Resen, me mihte nanpwungen Ninipe oh kahnimw laud en Kala. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Kadaudok en Isip kan iei mehn Lidia, Anam, Lehap, Napdu, ");
INSERT INTO pon2006a_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Padrus, Kaslu, oh Krihd, me mehn Pilisdia kan pwilisang ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Nein Kenan pwutak—Saidon, me keieu laud, oh Hed—irail me pahpa kahlap en aramas ako me weuwa adarail kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kenan pil wia pahpa kahlap en mehn Sepus, mehn Amor, mehn Kirkas, ");
INSERT INTO pon2006a_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","mehn Ip, mehn Ark, mehn Sin, ");
INSERT INTO pon2006a_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","mehn Arpad, mehn Semar oh mehn Amad. Kadaudok en mehn Kenan ikiparpeseng, ");
INSERT INTO pon2006a_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","lao irepen Kenan lellahng palieir en Saidon lel Kerar limwahn Kasa oh kolahng palimese lel Sodom, Komora, Adma, oh Sepoim limwahn Lasa. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ih met kan kadaudok en Ahm, me kin koukousoan rehn kadaudokarail kan oh wasa kan, ehuehu pwihn kin lokaiahki pein ar lokaia. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sehm, rien Saped me laud, ih me wia pahpa kahlap en mehn Ipru koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Nein Sehm pwutak—Elam, Ahsur, Arpaksad, Lud, oh Aram— irail me wia pahpa kahlap en aramas ako me weuwa adarail kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Kadaudok en mehn Aram ko iei mehn Us, Hul, Keder, oh Mesek. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad me naineki Sela, Sela me naineki Eper. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eper naineki pwutak riemen: emen adaneki Pelek, pwehki nindokon eh mwehi aramas en sampah pwalpeseng wiahda pali kei; oh meteio adaneki Sokdan. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Kadaudok en Sokdan kan iei mehn Almodad, Selep, Asarmaped, Sera, ");
INSERT INTO pon2006a_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Usal, Dikla, ");
INSERT INTO pon2006a_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Opal, Apimael, Sipa, ");
INSERT INTO pon2006a_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Apila, oh Sopap. Irail koaros pwildohsang Sokdan. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Sahpw me re kin kousoan ie tepisang Mesa kolahng Separ ni palimesehn sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ih met kan kadaudok en Sehm, me kin koukousoan rehn kadaudokarail kan oh wasa kan, ehuehu pwihn kin lokaiahki pein ar lokaia. ");
INSERT INTO pon2006a_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Aramas pwukat koaros wia kisehn kadaudok en Noha, ehuehu wehi nin duwen wekpeseng en ar kadaudok. Mwurin nohlik lapalapo, wehin sampah kan koaros pwildohsang rehn nein Noha pwutak ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nin tapio, tohn sampah koaros ahnekipene soangen mahsenteieu, pwe re kin doadoahngki soangen lepin mahsen kan me duwepenehte wasa koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ni ar mwekimwekidlahng palimese, re ahpw lel wasa patapat kis nan Papilonia, wasa re kousoanla ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Irail eri ndapene nanpwungarail, “Nna, kitail umwunda pwehl oh wiahkihda lepin takai.” Eri, re ahpw wiahda lepin takai pwehl, mehn kou ihmw, oh pil onopada tahr, mehn kapasapene takai ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Irail ahpw nda, “Eri, met kitail wiahda ehu kahnimw, oh ehu imwen doulik, me imwi pahn leldalahng pahnlahng, pwe kitail en ndandla oh dehr mwarahkpeseng wasa kan nin sampah.” ");
INSERT INTO pon2006a_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","KAUN-O eri ketidi pwe en mahsanih kahnimwo oh imwen douliko me aramas ako kauwadahr. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","E ahpw mahsanih, “Eri, aramas pwukat koaros wiahki ehu, oh re kin lokaiahki lokaiateieu; met iei tepin me re pahn wiewia kohwei. Mwurin met re pahn mwadangete kak wiahda soahng koaros me re anahne. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Eri, kitail kohdihwei oh kapingada ar lokaia, pwe re en dehr wehwehkipene ar lokaia kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","KAUN-O eri ketin kalipeihrpeseng ong wasa koaros nin sampah. Irail eri tokedihsang ar wiewia kahnimwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kahnimwo adaneki Papilon, pwehki iei wasao me KAUN-O ketin kapingada lokaiahn aramas koaros, oh sang wasao me e ketin kalipeihrpeseng ong wasa koaros nin sampah. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Iet kadaudok en Sehm kan. Sounpar riau mwurin nohlik lapalapo, ni Sehm eh sounpar 100, e nainekihda pwutak emen, ede Arpaksad. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Mwuri, e ahpw pil momourki sounpar 500 oh nainekihda pil seri kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ni Arpaksad eh sounpar 35, e nainekihda pwutak emen, ede Sela; ");
INSERT INTO pon2006a_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","mwuri, e momourki sounpar 403 oh nainekihda pil seri kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ni Sela eh sounpar 30, e nainekihda pwutak emen, ede Eper; ");
INSERT INTO pon2006a_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","mwuri, e ahpw pil momourki sounpar 403 oh nainekihda pil seri kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ni Eper eh sounpar 34, e nainekihda pwutak emen, ede Pelek; ");
INSERT INTO pon2006a_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","mwuri, e ahpw momourki sounpar 430 oh nainekihda pil seri kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ni Pelek eh sounpar 30, e nainekihda pwutak emen, ede Reu; ");
INSERT INTO pon2006a_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","mwuri, e ahpw pil momourki sounpar 209 oh nainekihda pil seri kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ni Reu eh sounpar 32, e nainekihda pwutak emen, ede Seruk; ");
INSERT INTO pon2006a_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","mwuri, e ahpw pil momourki sounpar 207 oh nainekihda pil seri kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ni Seruk eh sounpar 30, e nainekihda pwutak emen, ede Nahor; ");
INSERT INTO pon2006a_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","mwuri, e ahpw pil momourki sounpar 200 oh nainekihda pil seri kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ni Nahor eh sounpar 29, e nainekihda pwutak emen, ede Tera; ");
INSERT INTO pon2006a_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","mwuri, e ahpw pil momourki sounpar 119 oh nainekihda pil seri kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Mwurin Tera eh sounpar 70, e nainekihda Eipram, Nahor, oh Aran. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Iet kadaudok en Tera kan: Tera semen Eipram, Nahor oh Aran. Aran semen Lohd. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Eri, Aran mehla nan uhdakeo, Ur nan Papilonia, nindokon eh pahpao eh momourte. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aran semen Iska oh pil serepein men, Milka, en Nahor eh pwoud; oh Eipram pwoudikihda Sarai. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sohte nein Sarai seri, pwehki ih lih depwen men. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera eri kahrehda nah pwutak Eipram, oh Lohd nein Aran, rien Eipram ohl, oh Sarai, en Eipram eh pwoud; irail koaros ahpw mweselsang Ur, kahnimw en Papilonia, pwe re en kolahng Kenan. Irail ahpw lel kahnimw Aran, wasa re kousoanla ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera sipalla wasao ni eh sounpar 205. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","KAUN-O eri mahsanihong Eipram, “Kohkohla sang nan sapwomwen, rehn kisehmw kan, sang ni imwen semomwen, kowe eri kohla nan sahpw ehu me I pahn kasalehiong uhk. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","I pahn kihong uhk kadaudok ngedehrie, me pahn wiahla wehi lapalap ehu. I pahn kapaiaiukada oh kalinganahla edomw pwe en wiahla mehn kapai. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","I pahn kapaiahda irail kan me kin kapaiaiukada. Ahpw I pahn keriahla irail kan me kin keriaiukala. Wehi koaros en sampah pahn peki rehi I en kapaiairailda duwehte ei kapaiaiukadahr.” ");
INSERT INTO pon2006a_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Eipram, sounpar 75, e ahpw mweselsang Aran, nin duwen KAUN-O eh ketin mahsanih; Lohd eri iangihada. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","E pil kahre eh pwoud Sarai, oh Lohd nein rieo, iangahki kepwe koaros oh ladu koaros me re naineki nan Aran. Irail eri tapihada seiloaklahng Kenan. Ni ar lel nan Kenan, ");
INSERT INTO pon2006a_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Eipram ahpw kotehla sahpwo lao lel wasa sarawien kahnimw Sekem, lel tuhke sarawien More. (Ni ahnsowo mehn Kenan kan mihmihte nan sahpwo.) ");
INSERT INTO pon2006a_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","KAUN-O ahpw pwarohng Eipram oh mahsanihong, “Ih sahpwet me I pahn kihong kadaudokomw kan.” Eipram eri kauwada pei sarawi ehu wasao ong KAUN-O, pwehki eh ketin pwarohng. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Mwurin mwo, e ahpw douluhlsang wasao ong palieir, lel nahna me mi palimesehn kahnimw Pedel; e ahpw kauwada ie imwe impwal kan, nanpwungen Pedel me mi palikapi oh Ai me mi palimese. E pil kauwada wasao pei sarawi ehu, oh kaudokiong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Eri, e kin keseusang ehu wasa keseulahng ehu wasa, mwekimwekid kohla palieir en Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","A pwehki eh sohte kisin mwenge nan sahpwo, oh lehk laud eh lalaudlahte, Eipram douluhldilahte lel Isip, wasa e kousoanla ie ahnsou kis. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ni eh pahn kereniong pedolong nan Isip, e ahpw ndaiong eh pwoud Sarai, “Kilang, I ese me lih masamwahu men kowe. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Eri, ni mehn Isip kan ar pahn kilanguhkada, re pahn nda, ‘En Eipram eh pwoud met’—re ahpw pahn kemeiehla, oh re pahn mweidohng uhk ke en momour. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Eri, menlau ke ahpw ndaiong irail me riei serepein kowe; pwe re en kasamwo ie mwahu pwehki kowe oh mweidohng ie I en momourte.” ");
INSERT INTO pon2006a_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Eri, ni eh pedolong nan Isip, mehn Isip ko ahpw kilangada uwen lingan en eh pwoudo. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Lapalap akan ahpw kilangada liho oh kairehki Parao uwen eh lingan oh masamwahu; liho eri pakahrlahng nan tehnpas en Parao. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Parao ahpw kasamwo Eipram pwehki Sarai, oh ketikihong nah pelin sihpw oh kuht, kou, ahs, lidu, oh kamel tohto. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ahpw pwehki Parao eh ketikihsang Eipram Sarai. KAUN-O ahpw ketin kalokehki ih oh tohn tehnpeseo kalokolok laud en soumwahu suwed kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ihme Parao malipehdo Eipram oh keinemwe reh, “Dahme komw wiahiong ie? Dahme komw sohte padahkihongiehki me Sarai omwi pwoud? ");
INSERT INTO pon2006a_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Dahme kahrehda komw mahsaniheki me riomwi, ngehi eri alehda pwe I en pwoudiki? Eri, ien ih! Ale oh patopatohweisang met.” ");
INSERT INTO pon2006a_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Parao eri ketikihong Eipram rehn sapwellime aramas akan pwe re en kahreieisang nan irepen Isip, iangahki eh pwoud oh mehkoaros me e ahneki. ");
INSERT INTO pon2006a_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Eipram eri mweselsang Isip, kolahng paliepeng, iangahki eh pwoud oh mehkoaros me e ahneki, kolahng palieir en Kenan; Lohd pil iang ih. ");
INSERT INTO pon2006a_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Eipram inenen kepwehpwe, pwe e naineki sihpw, kuht, oh kou tohto, iangahki kohl oh silper. ");
INSERT INTO pon2006a_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Mwuhr, e ahpw douluhlsang mwo, mwekimwekid kolahng Pedel oh Ai, wasa e kauwada ie imwe impwal kan mahs ");
INSERT INTO pon2006a_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","iangahki pei sarawi ehu. E ahpw kaudokiong KAUN-O wasao. ");
INSERT INTO pon2006a_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lohd pil naineki sihpw, kuht, oh kou tohto, iangahki eh peneinei oh nah tohndoadoahk kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Eri, audepen sahpwo sohte itarohng pwe ira en kousoanpene ie; pwe ira koaros naineki pelinmen tohtohie. ");
INSERT INTO pon2006a_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Iei me pei oh akamai wiawihkihda nanpwungen nein Eipram oh nein Lohd neira silepen mahn akan. (Ni ahnsowo mehn Kenan oh mehn Peris kin kousoante nan sahpwo.) ");
INSERT INTO pon2006a_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Eipram eri ndaiong Lohd, “Kilang, kita peneinei, ihme noumw silepe kan oh nei silepe kan re en dehr akamaipene. ");
INSERT INTO pon2006a_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kita tohrohrpeseng. Menlau pilada mehnia sahpw me ke mwahuki kousoan ie, pwe ke en tohrohrala oh kousoanla ie. Ma ke pahn kohwei wasa kis, a I pahn kohla ekis wasa tohrohr.” ");
INSERT INTO pon2006a_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lohd ahpw irihrongseli oh kilangada duwen sahpw me Pillap Sordan tang loale eh patapat laud lellahng Soar oh eh diren pihl, likamwete sapwellimen KAUN-O mwetuwel de wehin Isip. (Eri, met mwohn KAUN-O eh ketin kamwomwala kahnimw kan en Sodom oh Komora.) ");
INSERT INTO pon2006a_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lohd eri pilada sahpw patapat en Sordan oh tohrohralahng ni palimese. Ih duwen met en ohl riemenet ara tohrohrpeseng. ");
INSERT INTO pon2006a_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Eipram mihmihte nan Kenan, a Lohd kousoanla nanpwungen kahnimw kan me mi limwahn Sordan oh kauwada imwe impwal kan limwahn Sodom. ");
INSERT INTO pon2006a_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tohn kahnimw wet aramas suwed kei, oh aramas dipan ekei mwohn silangin KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Mwurin Lohd eh tohrohrala sang Eipram, KAUN-O ahpw ketin mahsanihong Eipram, “Sang wasa ke mihmi iehn, irongowei wasa koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Pwe I pahn ketikihong uhk oh kadaudokomw kan sahpw koaros me ke kilikilang, oh e pahn wiahla sapwamwail kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","I pahn kangederehla kadaudokomw kan, re pahn uhdahn tohtohlahsang pwelpar en sampah. Ma mie me kak wadekedi pwelpar en sampah koaros, eri, e pahn kak wadekedi kadaudokomw kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Eri, met onopada oh kohwei wasa koaros nan sahpwet pwon, pwe I pahn ketikihong uhk koaros.” ");
INSERT INTO pon2006a_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Eipram eri kasauwada imwe impwal ko oh kohla kousoanla limwahn tuhke sarawi kan en Mamre karanih Epron. Ih eri kauwadahng KAUN-O pei sarawi ehu wasao. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Nanmwarki pahmen, Amrapel, nanmwarkien Papilonia, Ariok, nanmwarkien Elasar, Sedorlaomer, nanmwarkien Elam, oh Daidal, nanmwarkien Koiim, ");
INSERT INTO pon2006a_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","re mahweniong nanmwarki limmen pwukat: Pera, nanmwarkien Sodom, Pirsa, nanmwarkien Komora, Sinap, nanmwarkien Adma, Semeper, nanmwarkien Sepoim, oh nanmwarkien Pela (de Soar). ");
INSERT INTO pon2006a_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Nanmwarki limmen pwukat eri miniminpenehr nan Wahun Siddim, iei me ahnsou wet Sehden Mehla. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Erein sounpar eisek riau re ketiketkiher pahn manaman en Sedorlaomer, a ni kaeisek siluhn sounparo re pelianda oh moromorada. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ni kaeisek pahieun sounparo, Sedorlaomer oh ienge nanmwarki kan ahpw pokonpene, iangahki sapwellimarail karis en sounpei, oh kalowehdi mehn Repa kan nan Asterod Karnaim, mehn Sus kan nan Ahm, mehn Em kan nan patapat en Kiriadaim, ");
INSERT INTO pon2006a_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","oh mehn Hor kan ni nahna kan en Edom lellahng Elparan, me mi ni keilen sapwtehno. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Re ahpw pwurodohng Kades (de Enmispat). Re kalowehdi sapwen mehn Amalek koaros, oh kalowehdi mehn Amor kan, me kin kousoan nan Asason Damar. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Nanmwarkien Sodom, Komora, Adma, Sepoim oh Pela ahpw onopada sapwellimarail karis en sounpei kan nan Wauhn Siddim oh mahweniong ");
INSERT INTO pon2006a_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","nanmwarkien Elam, Koiim, Papilonia, oh Elasar, nanmwarki limmen uhwong nanmwarki pahmen. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Wahun Siddim me inenen diren pwoaren tahr. Eri, nanmwarkien Sodom oh Komora ahpw lempehdiong nan pwoahr ako, ni ara wekidek en tangasang nan mahweno. Iengara teiko ahpw tangdoaui oh rukula pohn nahna kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Nanmwarki pahmeno eri ketikihsang mehkoaros nan Sodom oh Komora, oh pil kisin mwenge; re ahpw ketiketlahsang. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Re pil wahsang Lohd oh mehkoaros me e ahneki, pwe e kin koukousoan nan kahnimw Sodom. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ohl emen sang rehn me pitla ko ahpw kohdo oh kairehki Eipram mehn Ipruo mehkoaros. Eipram kin koukousoan limwahn tuhke sarawi ko en Mamre, mehn Amor, me iei rien Eskol oh Aner; irail kin miniminiong Eipram. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Eipram lao rongada duwen nein rieo eh iangehr lohdi oh selidi, e ahpw kapokonepene ohl loalopwoat kan en eh kahnimpwalo, irail koaros me 318; e ahpw kahreiraillahng Dan, raparapahki nanmwarki pahmen ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","E ahpw katohrepeseng nah aramas ako ni pwihn kei wasao, e ahpw mahweniong irail nipwong oh kaloweiraildi. E ahpw pwakihirailla lao lel Hopa, paliepeng en Damaskus. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ih eri kapwurehsang irail kepwe koaros. E pil kapwurehsang irail Lohd, nein rieo, iangahki lih akan oh aramas teikan. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ni Eipram eh sapahldo sang eh kalowehdi nanmwarki Sedorlaomer oh nanmwarki teiko, nanmwarkien Sodom ahpw ketieila kasamwo ih nan Wahun Sape (me pil adaneki Wahun Nanmwarki). ");
INSERT INTO pon2006a_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkisedek, me iei nanmwarkien Salem oh pil samworo en Koht, Wasa Lapalahpie, e ahpw ketikihong Eipram pilawa oh wain. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","E ahpw kapaiahkihda mahsen pwukat: “Koht, Wasa Lapalahpie, me ketin kapikada nanleng oh sampah, en ketin kupwuramwahwih Eipram. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kaping en kohieng Koht, Wasa Lapalahpie, me ketikihong komwi manaman en powehdi omwi imwintihti kan.” Eri, Eipram ahpw ketikihong Melkisedek eisek kis ehun kepwe kan koaros me e kalowedier. ");
INSERT INTO pon2006a_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Nanmwarkien Sodom ahpw mahsanihong Eipram, “Komw kolokolete mehkoaros me komw kalowedier, ihte nei aramas akan me komw pahn kapwuredohng ie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Eipram eri sapeng, patohwan, “I kahukihla mwohn KAUN-O, Koht Wasa Lapalahpie, Sounwiepen nanleng oh sampah, ");
INSERT INTO pon2006a_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","me I sohte pahn ale mehkot sang rehmwi, mehnda ma mwulen dereht ehu de selen suht ehu. Pwe komwi dehr mahsanih, ‘Ngehi me kahrehiong Eipram eh kepwehpwehla.’ ");
INSERT INTO pon2006a_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Eri, sohte mehkot I pahn ale ahi. Ihte me I pahn ale, dahme nei ohl akan doadoahngkiher oh pwais me uhdahn en iengei kan, Aner, Eskol oh Mamre; irail me pahn ale pwaisarail.” ");
INSERT INTO pon2006a_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Mwurin mepwukat, Eipram ahpw kilangada kaudiahl ehu, e rongada KAUN-O eh mamahsanih, “Eipram, ke dehr masak; pwe iet ngehi perehpomw me pahn apwahpwalihiuk. I pahn kihong uhk keting ehu me lapalahpie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Eipram ahpw patohwan, “Maing KAUN, Wasa Lapalap, ia duwen omwi pahn ketikihong ie ketingpei lapalap, ni eh sohte ei tungoal seri? Elieser, mehn Damaskus, iei ihte me pahn ale ei sohso. ");
INSERT INTO pon2006a_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Pwehki sohte seri men komw ketikihong ie, ihme kahrehda emen ei ladu kan me pahn ale ei sohso.” ");
INSERT INTO pon2006a_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","E ahpw pil rongada KAUN-O eh ketin mahsanih, “Soh! Kaidehkin ladu menet me pahn ale omw sohso; pwe pein noumw pwutak.” ");
INSERT INTO pon2006a_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","KAUN-O eri ketin kahreieilahng liki oh mahsanih, “Kilengdalahng pahnlahng, oh wadek usu kan, ma ke kak; pwe iei pahn duwen ngeder en kadaudokomw kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Eipram eri likihala KAUN-O, oh ihme KAUN-O ketin kupwurperenkihla oh sapwellimanikihla. ");
INSERT INTO pon2006a_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kedekedeo, KAUN-O ahpw mahsanihong Eipram, “Iet ngehi KAUN-O, me kahluweiukasang Ur nan Papilonia, pwe I en kihong uhk sahpw wet, pwe en wiahla uhdahn sapwomw.” ");
INSERT INTO pon2006a_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","A Eipram sapeng, patohwanohng, “Maing KAUNO, Wasa Lapalap, dahme I pahn patohwan esehki me sahpw wet iei uhdahn ei tungoal?” ");
INSERT INTO pon2006a_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","KAUN-O ahpw ketin mahsanih, “Wadohng ie mahs emen koupwul me sounpar siluh, emen kuht me sounpar siluh, emen sihpw wol me sounpar siluh, emen mwuroi oh emen pitsin.” ");
INSERT INTO pon2006a_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Eipram eri patohwandohng Koht soangen mahn pwukat koaros. E ahpw pwalangirailpeseng wiahkihda riapali, e ahpw kasohpeipene kairekala; a menpihr ko e sohte pwalangpeseng. ");
INSERT INTO pon2006a_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Menpihr toantoal kei ahpw kin pihrdidohng pohn mahn mehla ko, a Eipram ahpw kin karawansang. ");
INSERT INTO pon2006a_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ni ketipino eh peiklahr, Eipram ahpw meirla oh meirkelikla, oh lemw ehu ahpw kipehdi. ");
INSERT INTO pon2006a_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","KAUN-O eri mahsanihong, “Kadaudokomw kan pahn keikeiruseli nan sapwen wai ehu; re pahn wiahla lidu wasao oh ale lokolok erein sounpar 400. ");
INSERT INTO pon2006a_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ahpw I pahn kaloke wehi me pahn wiahiong irail soahng wet, oh ni arail pahn kohkohlasang nan sahpwo, re pahn wahsang kepwe tohto. ");
INSERT INTO pon2006a_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","A kowe, ke pahn mour werei, ke lao pahn mehla ni popohl. Ke pahn seridi mwurin omw pahn mour werei. ");
INSERT INTO pon2006a_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Eri, mwurin dih pahieu kadaudokomw kan pahn pwurodo met, pwe I pahn kasarehsang met mehn Amor kan ahnsou me re pahn konehng ale kalokolok pwehki ar suwed laud kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ni ketipino eh kihrla oh wasa rotorotala, dahl ehu me wie edied oh kisiniei me wie mpwumpwul powe pa pwarada oh mwekimwekid kohla nanpwungen mahn me pwalpeseng ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Rahno KAUN-O eri kauwada inou ehu nanpwungen ih oh Eipram, mahsanih, “I inoukihda me I pahn kihong kadaudokomw kan sahpw wet pwon, sang ni irepen Isip lel Pillap Iupreitis, ");
INSERT INTO pon2006a_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","iangahki sapwen mehn Ken kan, sapwen mehn Kenis kan, mehn Kadmon kan, ");
INSERT INTO pon2006a_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","mehn Id kan, mehn Peris kan, mehn Repa kan, ");
INSERT INTO pon2006a_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","mehn Amor kan, mehn Kenan kan, mehn Kirkas kan, oh mehn Sepus kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, en Eipram eh pwoud, sohte neitikihong Eipram. Ahpw mie eh lidu lih emen, mehn Isip, ede Akar. ");
INSERT INTO pon2006a_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai eri ndaiong Eipram, “Kilang, KAUN-O sohte ketin kupwurehiong ie seri; dahme ke soh pekehikidahki ei liduwen? Mweinele e kak wiahiong ie emen serien.” Eipram ahpw pwungki dahme Sarai ndaiong. ");
INSERT INTO pon2006a_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sarai eri kihong Eipram eh lidu Akar, mehn Isipo, pwe en pekehiki. (Met wiawiher sounpar eisek mwurin Eipram eh koukousoankiher nan Kenan.) ");
INSERT INTO pon2006a_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Eri, mwurin Eipram eh ale Akar oh kapwaiada reh nsenen pwopwoud, Akar ahpw liseianda. Eri, ni eh pehmadahr me e liseiandahr, e ahpw aklapalapkihla oh tapihada mwamwahlikihla Sarai. ");
INSERT INTO pon2006a_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarai eri ndaiong Eipram, “Kowe me kahrehda Akar eh mwamwahlikiniehla. I kihong uhk ei liduwet ke en pekehiki. Eri, sang ni ahnsou me e liseiandahr, e mwamwahlikiniehla. KAUN-O en ketin kupwurehda ihs me pwung rehta.” ");
INSERT INTO pon2006a_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Eipram ahpw sapengki, “Me mwahu. Kapwurewei omw liduwen, oh wiahiong nsenomw.” Sarai eri kapwurehla liduwo oh kin sakosakone, kahrehda Akar eh tangasang. ");
INSERT INTO pon2006a_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Tohnleng en KAUN-O ahpw tuhwong Akar limwahn pwarer en nan sapwtehn, nanial en kolahng Sur. ");
INSERT INTO pon2006a_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","E ahpw mahsanihong, “Akar, en Sarai eh lidu, ke kohsang ia, oh ke kohkohla ia?” Akar ahpw sapeng, “I tangasang Sarai.” ");
INSERT INTO pon2006a_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Tohnlengo ahpw mahsanih, “Pwurala rehn liho, oh peki mahk reh.” ");
INSERT INTO pon2006a_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","E ahpw pil mahsanih, “I pahn kangederehla kadaudokomw kan, oh uwen tohtowe sohte me kak wadekada. ");
INSERT INTO pon2006a_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Kereniongehr ke pahn naitikihada noumw pwutak emen, oh ke pahn kihong ede, Ismael, pwe KAUN-O ketin karongeier ngilen omw apwal. ");
INSERT INTO pon2006a_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ahpw mouren noumw pwutak en pahn rasehng mouren ahs lawalo men; e pahn uhwong aramas koaros, oh aramas koaros pahn uhwong. E pahn kousoan dohsang kiseh kan koaros.” ");
INSERT INTO pon2006a_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Akar eri mengimengloalki, “Mehlel, me I kilangehr Koht, I ahpw momourte?” Ih eri kamwarenki KAUN-O, me ketin mahseniong, “Koht Me kin Mahsanih Wasa.” ");
INSERT INTO pon2006a_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ih kahrepen en aramas akan ar kin kahdanekihki pwarer me mi nanpwungen Kades oh Pered, “Pwarer en me Ieiaso Me ketin Mamahsanih Ie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Akar eri naitikihong Eipram pwutak emen; Eipram ahpw kihong ede Ismael. ");
INSERT INTO pon2006a_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Eipram sounpar 86 ni ahnsowo. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ni Eipram eh sounpar 99, KAUN-O ahpw ketin pwarohng oh mahsanihong, “Ngehi me Koht, Wasa Lapalap. Ke pahn peikiong ie, oh wia dahme pwung ahnsou koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","I pahn wia ei inou ong uhk, oh I pahn kangederehla kadaudokomw kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Eipram eri poaridi lel nanpwel, Koht ahpw mahsanih, ");
INSERT INTO pon2006a_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ih inowo met me I pahn wiahiong uhk: I inoukihong uhk me ke pahn wiahla semen wehi ngedehrie. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Sang met kohla ke solahr pahn adaneki Eipram, a ke pahn adanekihla Eipraam, pwehki i pahn wiahkinuhkala Semen Wehi ngedehrie. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","I pahn kangederehla kadaudokomw kan, oh ekei irail pahn wiahla nanmwarki. Kadaudokomw kan pahn ngeder mehlel, oh re pahn wiahla wehi kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“I pahn dadaurete ei inou ong uhk, oh pil ong kadaudokomw kan en dih me pahn kohdo kan oh pil kohkohlahte. I pahn kin wia omw Koht, oh Koht en kadaudokomw kan mwurimw. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","I pahn kihong uhk oh kadaudokomw kan sahpw wet me ke keikeiru ie met. Ke pahn sapwenikihla Kenan pwon kohkohlahte, oh I pahn wia arail Koht.” ");
INSERT INTO pon2006a_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Koht ahpw pil mahsanihong Eipraam, “Ke uhdahn pahn pil kapwaiada inou wet, kowe oh kadaudokomw kan, erein dih kan me pahn kohdo. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Eri, iet inou me kowe oh kadaudokomw kan pahn inoukihdahn: ohl koaros rehmwail pahn sirkumsaisla. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Sang met kohla, seri wol koaros pahn sirkumsaisla ni ar pahn mahki rahn 8, iangahki lidu kan me ipwidi rehmwail oh me pweipweido sang liki. Eri, met pahn wia kilel en inou me poadadahr nanpwungen ngehi oh kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Emenemen pahn sirkumsaisla, oh met pahn wia kilel ehu ni paliwaramwail kan, me pahn kasalehda ei inou poatopoat ong kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ohl emen me sohte pahn sirkumsaisla, eh solahr iang kisehn nei aramas akan, pwehki eh sohte kapwaiada ei inou wet.” ");
INSERT INTO pon2006a_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Koht ahpw pil mahsanihong Eipraam, “Sang met kohla ke solahr pahn kahdaneki omw pwoudo Sarai, ahpw Sara. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","I pahn kapaiahda, oh I pahn kihong en naitikihong uhk noumw pwutak emen. I pahn kapaiahda oh e pahn wiahla inen wehi tohto, oh sang rehn kadaudoke kan nanmwarki kei pahn pwarada.” ");
INSERT INTO pon2006a_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Eipraam ahpw poaridi lel nanpwel, e ahpw tapihada kouruhrki pein eh lamalam, nda, “Mie ohl laud me kak wiahda seri ni eh sounparehr 100? A Sara me sounparehr 90 kak neitik?” ");
INSERT INTO pon2006a_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ih eri patohwanohng Koht, “Maing, dahme komw sohte mweidohngki Ismael en wia semen kadaudok ei kan?” ");
INSERT INTO pon2006a_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","A Koht mahsanih, “Soh. Omw pwoud Sara pahn naitikihada pwutak emen, me ke pahn kihong ede Aisek. I pahn kapwaiada ei inou ong ih oh ong kadaudoke kan. Pwe inou poatopoat ehu met. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","I rongehr omw pekipek duwen Ismael, eri, I pahn kapaiahda oh kangederehla nah kan oh kadaudoke kan. E pahn wiahla semen kaun ehk riemen, oh I pahn kihong kadaudoke kan re en wiahla wehi laud ehu. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","I pahn dadaurete ei inou ong noumw pwutak Aisek, me Sara pahn naitikihada ni soangen ahnsou wet nan sounpar kohkohdo.” ");
INSERT INTO pon2006a_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Mwurin mahsen pwukat, Koht ahpw ketiketla sang Eipraam. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Eri rahnohte, Eipraam sirkumsaisihala nah pwutak Ismael, oh ohl koaros en tohn imweo, iangahki lidu kan me ipwidi reh oh me e pwainda kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Eipraam sounpar 99, ni eh sirkumsaisla, ");
INSERT INTO pon2006a_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","a nah pwutako Ismael sounpar 13. ");
INSERT INTO pon2006a_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ira koaros sirkumsaisla rahnteieu, ");
INSERT INTO pon2006a_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","iangahki nein Eipraam lidu ko koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","KAUN-O eri ketin pwarohng Eipraam ni tuhke sarawi kan en Mamre. Eipraam wie mwomwohd ni wenihmwen imwe impwalo ni ahnsou me karakar en rahn inenen laud. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ih eri kilenglahte kilangada ohl silimen me kesikesihnen mwowe. Eri, ni ahnsowohte e tangalahng irail pwe en kasamwo irail. E ahpw poaridi lel nanpwel, ");
INSERT INTO pon2006a_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","oh patohwan, “Maing ko, iet ngehi sapwellimamwail ladu, kumwail dehr douluhlweisang imweiet ahpw sohte kommoaldi. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","I pahn wadohng kumwail pihl pwe kumwail en widen nehmwail kan; eri, kumwail kommoaldi mahs pahn mwetehn tuhkeht. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","I pahn wiahda sakamwail, pwe kumwail en rosonda oh usehla amwail seiloaken. Kumwail leledohr ni imweiet; eri, I pahn papah kumwail.” Re ahpw sapeng, “Kalahngan en komwi; mehkoaros en wiawi duwen me komw mahsanih.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Eipraam eri mwadangete patohlong nan impwalo oh ndahng Sara, “Mwadang umwunda pilawa, sang nan ehd en pilawa me keieu mwahu.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Mwuri, e ahpw pil tangala rehn nah pelin kou ko oh pilada kou pwul me keieu pwulopwul oh mworourou, e ahpw kihong nah sounpapaho, pwe en pil kaunopada. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","E pil ale pwete, milik, oh uduken kouo, oh kihong irail. Nindokon arail sakasak, Eipraam kesikesihnen mparail pahn tuhkeo. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ni arail sakasak, re ahpw idek rehn Eipraam, “Ia Sara, omw pwoudo?” Eipraam ahpw sapeng, “E patopato nan impwalen.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Emen irail ahpw mahsanih, “I inoukihong komwi me omwi pwoud Sara pahn naitikihada nah pwutak emen mwurin sounpwong 9, oh ni ahnsowo I pahn pwurodo.” Sara ahpw mihmi loale limwahn wenihmwen impwalo, rongorong mehkoaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Eipraam oh Sara ira inenen likeilapalahr, oh Sara solahr wia eh pwung. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ihme e kouruhrkihda oh mengimengloalki, “Nan ei likeilapalahr oh solahr kak neitik, ia duwe, I pahn pil men wiewiahte nsenen pwopwoud? Oh ei pwoudo pil likeilapalahr mehlel.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","KAUN-O eri keinemwe rehn Eipraam, “Dahme Sara kouruhrki oh ndahki, ‘E pahn mehlel pwoat me I kak neitik nan ei likeilapalahr?’ ");
INSERT INTO pon2006a_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Mie mehkot me apwal ong KAUN-O? Ni ahnsou me I kilelehdi, mwurin sounpwong 9, I pahn pwurodo rehmw oh Sara pahn naitikihada pwutak emen.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Eri, pwehki Sara eh masepwehkada, e ahpw kahmahmkihla oh patohwan, “Soh! I sohte kouruhr.” KAUN-O ahpw ketin mahsanih, “Ei, ke kouruhrki.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Eri, ohlen keiru silimeno ahpw ketida oh ketiketlahng wasa kis me re kak iroirlahng kahnimw Sodom, oh Eipraam ahpw pil iangirailla pwe en kamwurirailla nanialo. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","KAUN-O eri ketin mengimengloalki, “I sohte pahn ekihsang Eipraam dahme I pahn wiaht. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Kadaudoke kan pahn wiahla wehi lapalap oh manaman ehu, oh wehi koaros en sampah pahn peki I en kapaiairailda duwehte ei kapaiadahr ih. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","I pilada ih pwe en padahkihong nah kan oh kadaudoke kan re en kin peikiong ei kosonned akan ni ar pahn kin wia dahme mwahu oh dahme pwung. I ahpw pahn kin kapwaiong ih soahng koaros me I inoukidahr.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","KAUN-O eri mahsanih, “Ngilen kedip ong Sodom oh Komora me inenen suwed, oh dipara kan me inenen toutou mehlel. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","I pahn kohdihwei pwe I en kadehde ma ngilen kedip kan me I rongehr me mehlel de soh.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Mehn keiru ko eri ketida oh ketiketlahng Sodom, a KAUN-O ketikette rehn Eipraam. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Eipraam eri keilahng mpen KAUN-O oh patohwanohng, “Ia duwe, komw uhdahn pahn ketin kamwomwala me dipan akan, iangahki me sohte dipe kan? ");
INSERT INTO pon2006a_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ma mie aramas sohte dipe limehk nan kahnimwo, komw pahn ketin kamwomwala kahnimwo pwon? Komw sohte pahn kupwur mahk oh sohte ketin kamwomwala kahnimwo pwehki me lelepek limehko? ");
INSERT INTO pon2006a_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Eri, uhdahn soh! Komw sohte kak kemehla me dipan akan iangahki me sohte dipe kan. Met sohte kak wiawi rehmwi. Pwe ma met pahn pweida, me sohte dipe kan pahn ale lokolok duwehte me dipan akan. Met sohte kak wiawi. Sounkopwung en sampah pwon uhdahn pahn kin pwung ni sapwellime wiewia kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","KAUN-O ahpw ketin sapeng, mahsanih, “Ma I pahn diar nan Sodom aramas limehk me sohte dipe, I pahn mahkohng kahnimwo unsek pwehki me limehko.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Eipraam ahpw pil pwurehng patohwan, “Maing KAUN, komw ketin kupwur mahk oh kupwure ei pahn pwurehng pato. Aramas emen ngehi, me sohwar mehlel en patohwanda mehkot. ");
INSERT INTO pon2006a_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ahpw ia duwe, mweinele aramas sohte dipe lelete pehklimmen, re sohte lel limehk. Komw pahn ketin kamwomwalahte kahnimwo pwon pwehki eh sohte lel limehko?” KAUN-O ahpw ketin sapeng, mahsanih, “I sohte pahn kamwomwala kahnimwo, ma I diar aramas sohte dipe pehklimmen ie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Eipraam pil pwurehng patohwan, “A ma ele mehte pehk me dierek?” KAUN-O ahpw ketin sapeng, “I sohte pahn kamwomwala, ma mehte pehk me dierek ie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Eipraam ahpw patohwan, “Maing, komw dehpa engiengda pahi ma I pwurupwurehngete ei peidek kat. A ma mehte siliakan me dierekda?” KAUN-O ahpw mahsanih, “I sohte pahn kamwomwala, ma me siliakan dierekda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Eipraam ahpw patohwanohng, “Maing, komw ketin kupwur mahk oh kupwure ei pahn pwurehng pato. A ma mehte riehk me dierekda?” KAUN-O ahpw mahsanih, I sohte pahn kamwomwala kahnimwo ma I diar aramas sohte dipe riehk ie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Eipraam ahpw pil patohwanohng, “Maing, komw kupwur mahk, peidektehr ehu me I pahn wia. A ma mehte ehk me dierek nan kahnimwo?” KAUN-O ahpw ketin sapeng, mahsanih, “I sohte pahn kamwomwala, ma me ehk dierekda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mwurin KAUN-O eh mahseniong Eipraam, e ahpw ketiketla sang; a Eipraam ahpw pwuralahng ni imweo. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ni tohnleng riemeno ara lel Sodom nin soutikpene, Lohd wie mwomwohd ni ewen kelen kahnimwo, wasa aramas akan kin pokonpene ie. Eri, ni Lohd eh kilangirahda, e ahpw uhda oh rahnmwahwih ira ");
INSERT INTO pon2006a_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","oh patohwan, “Maing ko, iet ngehi, I patopato wasaht pwe I en papah kumwa. Kumwa ketido ni imweiet. Kumwa pahn widen aluweluwamwa kan oh pweiekidi rehi. Nimenseng kumwa ahpw pahn usehla sapwellimamwa seiloak.” Ira ahpw sapeng Lohd, mahsanih, “Soh! Se pahn kommoaldi wasaht nan wasahn tuhpene en kahnimwet.” ");
INSERT INTO pon2006a_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ahpw Lohd ngidingidkihong ira en iangada, ketilahng ni imweo. Re ahpw ketiketla. Lohd eri ndaiong nah sounpapah ko re en umwun pilawa oh kaunopada kisin sak mwahu ong aramas en keiru ko. Ni soahng koaros eh nekier, re ahpw sak. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Mwohn mehn keiru ko ara pahn kolahng meirla, ohlen Sodom kan ahpw kapilpene ihmwo. Ohl koaros en kahnimwo, me pwulopwul oh me mah kan, iang mi wasao. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Re ahpw likwerih Lohd oh idek reh, “Ia ohl ako me kodohng pweidi rehmw nipwonget? Waieirahdo mahs pwe se en kak kapwaiada rehra ineng suwed en paliwarat akan, pwe se en pein kalel mahs nanpwungat.” ");
INSERT INTO pon2006a_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lohd ahpw pwerieila rehrail, oh ritingedi wenihmwo, ");
INSERT INTO pon2006a_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","e ahpw ndalahng irail, “Maing ko, menlau kumwail dehr wia soangen tiahk suweden! ");
INSERT INTO pon2006a_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Iet, mie nei serepein riemen me meipwon. I pahn kihong kumwail pwe kumwail en wiahiong ira nsenamwail. Ahpw I peki rehmwail, kumwail dehr wiahiong mehkot ohl pwukat, pwe ira mehn keiru kei ni imweiet, oh I uhdahn pahn apwalih ira.” ");
INSERT INTO pon2006a_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","A irail sapeng, ndalahng, “Pwulahkasang men; kowe mehn liki men! Ihs kowe pwe ke en ndahng kiht dahme se en wia? Keisang men, pwe se de pil wiahiong uhk me pahn suwed sang me se pahn wiahiong ira.” Re ahpw sikenla Lohd oh doudahla pwe re en kauwehla wenihmwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","A iet ohl riemen me mihmi loaleo sewesehda Lohd, sikenlong ong loale; ira ahpw ritingedi wenihmwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ira ahpw karotongehla mesen me mihmi liki ko koaros, irail eri sohla kak diar wenihmwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ohlen keiru riemeno eri idek rehn Lohd, “Mie kisehmw wasaht—noumw pwutak kan, serepein kan, oh en noumw kan ar pwoud kan, de kisehmw me iang koukousoan nan kahnimwet—wairailsang wasaht, ");
INSERT INTO pon2006a_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","pwe se pahn kamwomwala wasaht. KAUN-O ketin karongeier kedip suwed koaros ong tohn kahnimw wet, oh e ketin poaroneikitodo pwe se en kamwomwala Sodom.” ");
INSERT INTO pon2006a_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lohd eri kohla rehn ohl ako me pahn pwoudiki nah serepein ko, oh ndaiong ira, “Kumwa mwadang iang kohkohla sang wasaht; pwe KAUN-O pahn ketin kamwomwala wasaht.” Ira ahpw kihkihong me e wie kamwakamwanohng ira. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Nin sohrahno tohnleng ko ahpw keruwahda Lohd, mahsanihong, “Mwadang! Ale omw pwouden oh noumw serepein riemen en, oh mwadangehisang met, pwe kumwail dehr pil iang ohla ni kamwomwmwomwlahn kahnimw wet.” ");
INSERT INTO pon2006a_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lohd ahpw peikasalda; a KAUN-O ketin kupwurehla. Ihme tohnleng ko alehte pehn Lohd, pehn eh pwoudo, oh pehn nah serepein ko, oh kahreirailieisang nan kahnimwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ni ar miher likin kahnimwo, emen tohnleng ko mahsanihong Lohd, “Tang, pwe ke en mourla! Ke dehpa sohpeila pohn souwomwen, oh dehpa uhdi nan wahu. Tenge nahna kan, pwe ke de pil iang kamakamala.” ");
INSERT INTO pon2006a_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lohd ahpw sapeng, patohwan, “Soh, maing! Kaidehkin men me pahn wiawi. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Maing, komw ketin kupwureielahr mehlel; sapwellimomwi kalahngan me doareielahr. Nahna kan me nohn doh; mwohn ei pahn lel mwo kalokolok wet pahn koanoaiehdi oh I pahn mehla. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Komw mahsanih kisin kahnimwen? I kak lellahng mwo pwe me keren. Komw mweidohng ie I en patolahng mwo—wasa tikitik kis—oh ih wasa I kak pitla ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Tohnlengo eri sapeng, “Eri, me mwahu! I sohte pahn kamwomwala kisin kahnimwen. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Nna, mwadang tenge wasao! I sohte kak wia mehkot ke lao lel mwo.” Pwehki Lohd e kahdaneki kahnimwo kisin kahnimw tikitik, ihme kahnimwo adanekihki Soar. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lohd ahpw lel Soar ni ahnsou me ketipino ahpwtehn dakada. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","KAUN-O eri ketin kamwerehdi suwepel okohk, pohn Sodom oh Komora. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","E ahpw ketin kamwomwala kahnimw ko oh nan wahuo pwon, iangahki tohn kahnimw ko koaros oh mehkoaros me audepen sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ahpw en Lohd eh pwoud, me kilengla mwuri, e ahpw pikla wiahla uhr soahl. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mandahn rahno, nimensehngie, Eipraam ahpw sangkalahng wasa e patohwan tuhwong KAUN-O ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","E ahpw kilengdilahng Sodom oh Komora oh nan wahuo pwon, e ahpw kilangada duwen ediniei eh ediedida sang nan sahpwo, rasehng edin uhmw kalaimwun ehu. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ahpw ni ahnsou me Koht ketin kamwomwala kahnimw ko nan wahuo, e ketin kupwukupwurehte Eipraam oh ketin mweidohng Lohd en pitla. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Pwehki Lohd eh masak mihmihte Soar, ih oh nah serepein riemeno ahpw douluhllahng nin nahna kan; irail eri kin koukousoan nan pwoar ehu. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Nah serepein laudo eri ndaiong me tikitiko, “Kilang, ata pahpao likeilapalahr, oh sohte ohl emen nin sampah pwon luhwehdi me kak pwoudikinkitahda pwe kita en neitik seri duwen me kin wiawi. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Nna, kita kasakawihkihla wain e lao sakaula douluhl; kita ahpw wendi reh tuhkihong paliwarata pwe kita en neitikihong ata pahpa.” ");
INSERT INTO pon2006a_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Eri, nipwongo ira ahpw kasakawihkihla wain e lao sakaula douluhl. Serepein laudo eri wendi rehn eh pahpao oh tuhkihong paliwereo. Eh pahpao ahpw sohte kehnda mehkot nan eh sakaula douluhl. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mandahn rahno serepein laudo ahpw ndaiong me tikitiko, “Pwohng I wendi rehn pahpa oh tuhkihong paliwereiet. Kita pil kasakawihkihla wain pwonget, kowe eri pahn uhd wia duwen me I wiadahr. Kita koaros eri pahn neitikiong at pahpao.” ");
INSERT INTO pon2006a_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Eri, nipwongo ira ahpw pil kasakawihkihla wain e lao sakaula; oh serepein tikitiko ahpw uhd wendi rehn eh pahpao, oh tuhkihong paliwereo. Nan eh sakaula douluhl e ahpw sohte mwahn pil kehnda wasa. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Iei duwen met nein Lohd serepein riemeno ara liseianohng ara pahpao. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Serepein laudo eri naitikihada pwutak emen me e kihong ede Mohap. Ih me wia semen mehn Mohap en ahnsou wet kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Me tikitiko pil naitikihada nah pwutak emen, me e kihong ede Penami. Ih me wia semen mehn Ammon en ahnsouwet kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Eipraam eri mweselsang Mamre kolahng palieir en Kenan oh kousoanla nanpwungen Kades oh Sur. Nindokon eh koukousoanier nan Kerar, ");
INSERT INTO pon2006a_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","e kin patohwan me Sara, eh pwoudo, uhdahn rie. Apimelek, nanmwarkien Kerar, ahpw ketin poaronehdo Sara reh pwehn pekehikihda. ");
INSERT INTO pon2006a_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Koht ahpw ketin pwarohng Apimelek nipwong nan ouraman ehu oh mahsanihong, “Komw pahn mehla pwe lih me komw aledahr mie eh pwoud.” ");
INSERT INTO pon2006a_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ahpw Apimelek saikinte wia nsenen pwopwoud rehn liho, e ahpw patohwan, “Maing ei Kaun, ia duwen omwi pahn ketin kemehla aramas emen me sohte dipe? ");
INSERT INTO pon2006a_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Pein Eipraam patohwanohng ie me rie lih menet oh pil pein lihet patohwan me rie Eipraam. Iei me I wiadahr met ni kapehd oh lamalam mwakelekel.” ");
INSERT INTO pon2006a_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Koht ahpw ketin sapeng nan eh ouraman mahsanih, “Mehlel, I ese me ke wiadahr met ni kapehd oh lamalam mwakelekel, pwe ngehi me kasilehsang uhk ke en dehr wiahda dihp oh sohte mweidohng ke en sair liho. ");
INSERT INTO pon2006a_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Eri, met ale lihen kapwurelahng rehn uhdahn eh pwoudo, pwe soukohp men ih; oh e pahn kapakapkin uhk pwe ke en dehr mehla. Ma ke sohte pahn kapwurehla, ke en ese pwe kowe oh noumw kan koaros pahn mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mandahn rahno Apimelek ahpw mwadang kipada oh ketin kapokonepene sapwellime lapalap ako koaros oh mahsanihong irail soahng koaros me wiawihong, irail eri masepwehkada. ");
INSERT INTO pon2006a_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Apimelek ahpw malipehdo Eipraam oh mahsanihong, “Dahme komw wiahiong kiht? Dahme I wiahiong komwi pwe komwi en wadohng ie oh pohn ei wehi apwal laud wet? Komw wiahiong ie soangen ire ieu me sohte kin wiawihong ie sang mahs kohdo. ");
INSERT INTO pon2006a_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Dahme komw wiahki soangen irair wet?” ");
INSERT INTO pon2006a_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","A Eipraam sapengki, “Pwehki I lemeleme me sohte me pahn wahuneki Koht rehmwail; kumwail eri pahn kemeiehla pwehki ei pwoudo. ");
INSERT INTO pon2006a_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ahpw mehlel riei liho, pwe nein ei pahpa, ahpw kaidehn nein ei nohno, ihme I pwoudikihdahki. ");
INSERT INTO pon2006a_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ni Koht eh ketin kupwurehda I en patopatohsang rehn ei pahpao oh patopatolahng nan sapwen mehn liki kan, I patohwanohng lihet, ‘Ke pahn kin ndahng aramas akan me riei kowe, pwe ih duwen omw pahn kak kasalehda omw loalopwoatohng ie.’” ");
INSERT INTO pon2006a_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Apimelek ahpw kapwurehla Sara rehn Eipraam, iangahki sihpw, kou, oh lidu kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","E ahpw mahsanihong Eipraam, “Sahpwet pwon sapwei; kousoanla wasa me komw kupwurki.” ");
INSERT INTO pon2006a_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","E ahpw pil mahsanihong Sara, “Kilang, I kihongehr riomwo mwohni silper kid, kadehdepen eh sohte dipomw; aramas koaros pahn ese me sohte sapwung ehu ke wiahda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","KAUN-O ketin iredihsang lih koaros en peneinei en Apimelek re en dehr neitik, pwehki irairo me wiawihong Sara. Eri Eipraam ahpw kapakap ong Koht pwehki Apimelek; Koht eri ketin kupwurehla oh ketin kakehlahda iangahki eh pwoud oh neira lidu serepein kan, irail eri kakehr pwurehng neitik. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","KAUN-O ahpw ketin kupwuramwahwihala Sara, duwen me e ketin inoukidahr, ");
INSERT INTO pon2006a_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","e ahpw liseianda oh wiahiong Eipraam pwutak emen, ni Eipraam eh likeilapalahr. Kisin pwutako ipwidi ahnsou me Koht mahsanih me e pahn ipwidi. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Eipraam eri kihong ede Aisek. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ni eh mahkiher rahn 8, Eipraam ahpw sirkumsaisihala nin duwen me Koht ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Eipraam sounpar 100, ahnsou me Aisek ipwidi. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara eri patohwan, “Koht ketikihong ie peren oh kouruhr. Koaros me rong met pahn iang ie perenda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","E ahpw pil ketihtihki, “Ihs me kak ndahng Eipraam me Sara pahn kadihdi nah seri kan? Ahpw met I naitikiadahr seri men ong ih ni eh likeilapalahr.” ");
INSERT INTO pon2006a_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Serio eri keirda, oh nin rahn me e mweisang dihdi, Eipraam wiahda lapalahn kamadipw ehu. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Rahn ehu, Ismael, nein Akar mehn Isipo ong Eipraam, oh Aisek, nein Sara kisin pwutako, ira wie mwadomwadong. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sara eri kilangirahda oh ndaiong Eipraam, “Kilang, kasarehla lih liduwen oh nah pwutaken. Nein liduwen pwutaken sohte pahn kak iang ahneki mehkot sang omw kepwe kan, pwe nei pwutak, Aisek, me pahn sohsohki.” ");
INSERT INTO pon2006a_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Met kapwunodehda kowahlap Eipraam, pwe Ismael pil uhdahn nah seri. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Koht eri ketin mahsanihong, “Ke dehr pwunodki pwutaken oh omw lidu Akar. Kapwaiada mehkoaros me Sara pahn ndawei, pwe kadaudokomw kan me I inoukihonguhkehr pahn tepisang Aisek. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","I pahn pil kangederehla kadaudok en nein liduwen nah pwutaken, pwe re en wiahla wehi laud ehu. Pwe pil noumw pwutaken.” ");
INSERT INTO pon2006a_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Nin sohrahn en mandahn rahno, Eipraam ahpw kihong Akar eh tungoal kepinwar oh ehden pihl ehu. E ahpw koasoanehdi serio pohn tihnsewen liho oh kadarala. Liho eri mwesel oh kohla sansaruaruseli nan sapwtehn Peersepa. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ni nimara pihlo eh rosalahr, e ahpw kihdiong nah serio pahn tuhke pwoat. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Liho ahpw kohla mwohndi iaht 100 dohlahsang wasa serio mihmi ie. Ih eri mengimengloalki, “I sohte kakohng kilang nei seriet eh pahn mehla.” Eri, ni eh mwomwohd wasao, serio tapihada sengiseng. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Koht ketin karongehda ngilen serio, oh tohnleng en Kohto men sang nanleng ahpw mahsanihong Akar, “Akar, dahme ke pwunodkidahr? Ke dehr masak. Koht ketin karongeier ngilen noumw serien me wie sengiseng. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Uhda oh kohwei, ale oh kansenamwahwihala. I pahn wiahiong kadaudoke kan wehi lapalap ehu.” ");
INSERT INTO pon2006a_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Koht eri ketin kapehdpeseng pwoaren mese ko, liho eri kilangada pwarer ehu. E ahpw kohla oh idipada ehden pihlo, oh kanimpile nah serio. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Koht eri ketin kupwukupwurehte serio nindokon eh kekeirda. E ahpw kin koukousoan nan sapwtehn en Paran oh wiahla soupal en kesik mahn emen. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Eh nohno eri kapwopwoudikihda lihen Isip men. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ni ahnsowo Apimelek oh Pikol, kaunen sapwellime sounpei kan, ira ketila rehn Eipraam oh mahsanihong, “Koht ketin ieiang komwi ni mehkoaros me komw kin wia. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Eri, komw kahukihla mwohn silangin Koht me komw sohte pahn pitihedi, oh pitihdi nei seri kan de kadaudokei kan. Komw inoukihda me komw pahn loalopwoatohng ie oh pil ong sahpwet me komw koukousoan ie, duwen ei loalopwoatohng komwi.” ");
INSERT INTO pon2006a_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Eipraam ahpw sapengki, “I inoukihda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Eipraam ahpw kaulimkihong Apimelek duwen pwarer ehu me sapwellimen Apimelek tohndoadoahk ko adihasangehr. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Apimelek ahpw mahsanihong, “I sohte ese ihs me wia met. Komw sohte padahkihong ie oh I ahpwtehn rongada duwen irair wet.” ");
INSERT INTO pon2006a_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Eipraam ahpw patohwanohng Apimelek sihpw kei oh kou kei, ira eri wiahda inou ehu. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Eipraam katohrehsang sihmpwul isimen sang nan nah pelin sihpwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Apimelek ahpw keinemwe reh, “Ia wehwehn met?” ");
INSERT INTO pon2006a_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Eipraam ahpw sapengki, “Komw pahn ketiki sihmpwul isimen pwukat. Eri, met wehwehki me komw ketin pwungki me ngehi me weirada pwarer wet.” ");
INSERT INTO pon2006a_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ih kahrepe wet me wasao adanekihki, Peersepa, pwehki ih wasa me ohl riemenet wiahda inou ehu ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Mwurin ara wiadahr inou wet nan Peersepa, Apimelek oh Pikol ahpw sapahllahng nan Pilisdia. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Eipraam eri padokedi tuhke damarisk pwoat nan Peersepa oh kaudokiong KAUN-O, Koht Soutuk. ");
INSERT INTO pon2006a_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Eipraam eri koukousoan nan Pilisdia ahnsou reirei. ");
INSERT INTO pon2006a_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Kedekedeo, Koht ahpw ketin song Eipraam; e mahsanihong, “Eipraam!” A Eipraam sapeng, patohwan, “Iet ngehi, Maing!” ");
INSERT INTO pon2006a_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Koht ahpw ketin mahsanih, “Ale Aisek, noumw pwutak iehrosen, me ke kin kesempwalki, oh kohla nan wehin Moria. Kowe kohla meirongkihong ie nin duwen meirong isihs ehu pohn nahna me I pahn kasalehiong uhk.” ");
INSERT INTO pon2006a_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Eri, nin sohrahn en mandahn rahno, Eipraam ahpw wesehda eh tuwien meirongo, oh audehda nah ahso oh wahda Aisek, iangahki ladu riemen. Re ahpw mwesellahng wasa me Koht ketin mahsanih en patolahng ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ni kesiluhwen rahno Eipraam kilang wasao me sansaldo sang wasa doh. ");
INSERT INTO pon2006a_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ih eri ndaiong eh ladu ko, “Kumwa mihmihte met rehn ahset. Ngehi oh pwutaket pahn kolahng wia kaudok mwo, se ahpw pahn pwurodo rehmwa.” ");
INSERT INTO pon2006a_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Eipraam eri kihong Aisek en wahda tuwien meirong ko, a pein ih wahda samwit en kisiniei oh pil naip pwoat. Ni ara kohkohla nanialo, ");
INSERT INTO pon2006a_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aisek ahpw idek reh, “Ipa!” A e sapeng, “Dah mwo, samwa?” Aisek ahpw nda, “I kilikilang samwit en kisiniei oh tuwien meirong kat, a ia sihmpwul mehn meirongen?” ");
INSERT INTO pon2006a_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Eipraam sapeng, nda, “Samwa, Koht pahn pein ketikihda ata mehn meirong.” Ira eri dodouluhlla nanialo. ");
INSERT INTO pon2006a_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ni ara lel wasa me Koht ketin kasalehiong Eipraam, e ahpw kauwada pei sarawi ehu oh koasoanediong powe tuwi ko. E ahpw salihedi nah pwutak Aisek oh kidahng pohn kapakap en tuwi ko pohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","E ahpw ale nah naipo pwe en kemehkihla Aisek. ");
INSERT INTO pon2006a_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","A iet tohnleng en KAUN-O ahpw malipe sang nanleng, mahsanih, “Eipraam, Eipraam!” A e sapeng, “Iet ngehi, Maing.” ");
INSERT INTO pon2006a_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Tohnlengo ahpw mahsanih, “Ke dehr sair pwutaken, de wiahiong mehkot. I dehdehkiher uwen omw poadidiong Koht, pwehki omw sohte kahng meirongkihong ie noumw pwutak iehrosen.” ");
INSERT INTO pon2006a_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Eipraam ahpw kilikilengseli oh kilangada sihpw wol emen me kode ko tengalahr ni kisin rahntuhke kei. E ahpw kohla ale oh wiahkihla eh mehn meirong isihs wiliandi nah pwutako. ");
INSERT INTO pon2006a_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Eipraam ahpw kihong eden wasao, “KAUN-O me ketin Sawaskihda.” Lel rahnwet aramas akan kin kahdanehkihki wasao, “Nahnahn Sawas en KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Tohnleng en KAUN-O ahpw malipe Eipraam keriapak sang nanleng, mahsanih, ");
INSERT INTO pon2006a_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“I kahukilahr ni pein mwarei—KAUN-O me mamahsen—me I pahn kapaiaiukada mehlel, pwehki omw wiadahr met oh sohte kahng meirongkihong ie noumw pwutaken. ");
INSERT INTO pon2006a_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","I inoukihong uhk me I pahn kangederehla kadaudokomw kan duwehte ngeder en usu kan en pahnlahng de ngeder en pihk kan pohn oaroahr kan. Kadaudokomw kan pahn kalowehdi ar imwintihti kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Wehi koaros pahn peki I en kapaiairailda nin duwen ei kapaiadahr kadaudokomw kan—pwehki omw kapwaiadahr ei mahseno.” ");
INSERT INTO pon2006a_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Eipraam eri pwurala rehn eh ladu ko, re ahpw sapahllahng Peersepa, wasa e kin kousoan ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Mwurin ahnsou ehu Eipraam ahpw esehda me Milka naitikihada seri welimen ong rie Nahor: ");
INSERT INTO pon2006a_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Us me mesenih, rie pwutak Pus, Kemuel semen Aram, ");
INSERT INTO pon2006a_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Haso, Pildas, Sidlap, oh Petuel, ");
INSERT INTO pon2006a_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Petuel semen Repeka. Milka naitikihada pwutak welimen pwukat ong Nahor, rien Eipraam. ");
INSERT INTO pon2006a_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Reuma, en Nahor pekehi naitikihada Tepa, Kaam, Taas, oh Maaka. ");
INSERT INTO pon2006a_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara momourki sounpar 127. ");
INSERT INTO pon2006a_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","E ahpw mehla nan Epron, nan Kenan; Eipraam ahpw mwahieiki eh mehlao. ");
INSERT INTO pon2006a_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","E ahpw ketila sang wasa me paliweren eh pwoud wie wonohn ie oh ketila rehn mehn Id ko, oh mahsanihong irail, ");
INSERT INTO pon2006a_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ngehi mehn liki men me patopato rehmwail; kumwail menlau netikidohng ie wasa kis, me I kak nekidedi ie ei pwoudo.” ");
INSERT INTO pon2006a_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Re ahpw sapengki, ");
INSERT INTO pon2006a_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Maing, komw karongei kiht mahs. Se patohwan wiahkin komwi ohl lapalap oh manaman emen; komw ketin nekidedi omwi pwoud nan wasa keieu mwahu me mie reht. Kiht koaros pahn perenki patohwanohng komwi sousou ehu, pwe komwi en nekidedi ie omwi pwoudo.” ");
INSERT INTO pon2006a_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Eipraham ahpw poaridi mwohrail ");
INSERT INTO pon2006a_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","oh mahsanih, “Ma kumwail kupwure pwe I en nekidedi ei pwoud wasaht, a kumwail menlau peki rehn Epron nein Sohar ");
INSERT INTO pon2006a_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","pwe en netikihong ie poaren paip Makpela, me mihte ni keilen sahpweo. Kumwail peki reh pwe en netikihong ie uwen pweinen sahpwo unsek, met, mwohmwail, pwe I en kak sapwenikihla oh wiahkihla ei wasahn sousou.” ");
INSERT INTO pon2006a_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Pein Epron iang patopato rehn mehn Id ko ni ewen kehl wasahn tuhpene en aramas; ih eri sapeng mwohn aramas koaros wasao, ");
INSERT INTO pon2006a_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Maing, komw karonge mahs; I pahn patohwanohng komwi sahpwo pwon iangahki poaren paip me mihmi ieo. Met mwohn nei aramas akan, I pahn patohwanohng komwi, pwe komwi en kak nekidedi ie omwi pwoudo.” ");
INSERT INTO pon2006a_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Eipraam eri poaridi mwohn mehn Id ko ");
INSERT INTO pon2006a_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","oh mahsanihalahng Epron, pwe koaros en kak rong, “Eri, I peki rehmwi komwi menlau karonge ie. I pahn pwainda sahpwo pwon, komw ale pweineht, eri I pahn sarepedi ei pwoudo wasao.” ");
INSERT INTO pon2006a_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","A Epron sapengki, ");
INSERT INTO pon2006a_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Maing, sahpwo me komw men ale pahn pweipweiki sekel pahpwiki en silper—dahme mie nanpwungata? Eri komw nekidedi omwi pwoudo wasao.” ");
INSERT INTO pon2006a_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Eipraam eri pwungkihda oh teneki uwen pweipwei me Epron patohwanda mwohn pokono—sekel silper pahpwiki, nin duwen pweipwei me kin wiawi rehn sounnetinet kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ih duwen met sahpw me uhdahn sapwen Epron nan Makpela palimesehn Mamre, eh wiahla sapwen Eipraam. Met iangahki sahpwo, pwoaren paipo, oh tuhke koaros me mi loale. ");
INSERT INTO pon2006a_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Mehn Id koaros me iang mihmi wasao ahpw kilelehdier me uhdahn sapwen Eipraam wasao. ");
INSERT INTO pon2006a_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Eipraam ahpw nekidedi eh pwoud Sara nan pwoaren paip me mi nan sahpwo nan Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Eri sapwen mehn Id ko, oh pwoaren paipo me mi loale, ahpw wiahla en Eipraam eh wasahn sarepedi me melahr akan. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Eri, Eipraam inenen likeilapalahr, oh KAUN-O ahpw ketin kupwuramwahwiher ni mehkoaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Eipraam eri ndaiong nah laduwo me keieu maho, me pil sounkohwahn mehkoaros me e ahneki, “Kihdiong pehmwen nan dengeie oh wiahda inou. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","I anahne ke en inoukihong ie oh kahukihla mwohn KAUN-O, Koht en nanleng oh sampah, me ke sohte pahn pilada en nei pwutaket eh pwoud emen sang wasaht nan Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ke pahn pwurowei nan uhdakeio oh rapahkihda en nei pwutak Aisek, eh pwoud sang rehn kisehi ko.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Laduwo ahpw idek, “A ma serepeino sohte pahn men iang ie kohdo met, dahme I pahn wia? I pahn kadarala sapwellimomwi pwutaket nan sahpw me komw ketido sang ie?” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Eipraam ahpw sapengki, “Kalekehte ke kadarala nei pwutaken wasao! ");
INSERT INTO pon2006a_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","KAUN-O, Koht en nanleng, ketikiniesang rehn ei pahpao oh nan sapwen kisehi ko, ketikidohng ie wasaht, oh ketin kahukihla oh inoukihong ie me e pahn ketikihong sahpw wet kadaudokei kan. E pahn ketin kadar sapwellime tohnleng mwohmw pwe ke en kak alehsang wasao en nei pwutako eh pwoud. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","A ma serepeino sohte men iang uhk kohdo met, ke pahn saledeksang inou me ke wiahiong ie. Ahpw ke sohte mwahn pahn kapwurehla wasao nei pwutako.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Laduwo eri kihdi peho nanpwungen dengen Eipraam, eh soumaso, oh wiahda inou me e pahn kapwaiada mehkoaros me e kehkehlingkihong. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Laduwo, me sounkohwahn en Eipraam dipwisou kan, eri ale nein eh soumaso kamel ehk, e ahpw mwesel kohkolahng nan kahnimw wasa me Nahor kin koukousoan ie paliepeng en Mesopodamia. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ni eh lel wasao, e kommoalehdi kamel ko ni pwarer ehu likin kahnimwo. Eri, wasa soutikpenehr, oh ahnsowo lihen kahnimwo kan kin kodohng idipil. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","E ahpw kapakap, patohwan, “Maing KAUN, Koht en ei soumas Eipraam, komw ketin kupwure ie rahnwet oh kapwaiada sapwellimomwi inou ong ei tungoal soumaso. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Iet ngehi me patopato limwahn pwarer wet, wasa me serepein kan en kahnimw wet pahn patohdohng idipil ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Eri, serepein pwulopwul men me I pahn ndahng, ‘Menlau kaidi omw sahen pwe I en nimpil mahs.’ Ma e pahn nda, ‘Nna, ale oh nim; oh I pil pahn kanimpile noumw kamel kan,’ iei ih me komw ketin piladahr ong sapwellimomwi ladu Aisek. Ma met pahn pweida, I pahn patohwan esehki me komw ketin kapwaiada sapwellimomwi inou ong ei soumaso.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Mwohn eh kanekehla eh kapakapo, iet Repeka pa lel wasao, kapaik eh saho. Repeka nein Petuel, a Petuel nein Milka, en Nahor rien Eipraam eh pwoud. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Eri, Repeka serepein meipwon emen, me inenen kaselel. E kohdihla ni pwarero oh idipada nah saho oh pwurodohsang ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Laduwo ahpw tangala reh oh ndaiong, “Menlau kihdo mahs nimei kis pihlen sang nan noumw sahen.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","A serepeino ahpw sapeng, nda, “Nna, komw ale, maing.” Ih eri mwadangete kihdihsang pohn pwopwe saho, kanimpilehki laduwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Mwurin eh kanimpile laduwo, serepeino ahpw nda, “I pahn pil kanimpile noumw kamel kan, irail koaros lao medla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ih eri mwadangete wudekihdi audepen nah saho nan deupen pihl ko, oh pwuredihla idipil nan pwarero e lao kanimpile kamel ko koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Laduwo ahpw mwasamwasahn, ma Koht ketin kupwurehla eh seiloak de soh. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ni eh nekier en serepeino eh kanimpile mahn ako, laduwo ahpw ale rihng kesempwal ehu oh kihong ni tumwe, oh luwou kohl riau ong ni peh kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","E ahpw idek reh, “Nein ihs kowe, ihs omw pahpa? Menlau ndadohng ie mahs. Mie wasa ni imwen omw pahpao me ngehi oh nei mahn akan kak pweidi ie pwohnget?” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Serepeino ahpw sapeng, nda, “Ngehi nein Petuel, nein Nahor oh Milka.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Reh oh tahpwte reht, kenen mahn akan, oh mie wasa me kumwail kak pweidi ie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ohlo eri kelehpwikihdi oh kaudokiong KAUN-O, ketihtihki, ");
INSERT INTO pon2006a_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Kaping ong KAUN-O, Koht en ei soumas Eipraam, me ketin kapwaiadahr sapwellime inou ong ei soumas. KAUN-O me ketin kahluwaiedohng ni imwen kisehn ei soumaso.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Serepeino ahpw mwadangalahng ni imwen eh nohno oh padahkihong mehkoaros me wiawiher. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Mie rien Repeka ohl emen me adaneki Lapan, me tenge pwarero wasa me nein Eipraam laduwo mihmi ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","E kilangada rihngo oh luwou ko ni pehn rie serepeino, oh rongada mehkoaros me ohlo ndaiong serepeino. Ih eri kohla rehn nein Eipraam laduwo, me kesikesihnen limwahn kamel ko nin pwarero. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","E ahpw ndahng, “Komw ketido, KAUN-O ketin kupwuramwhwihiukadahr. Dahme komw ketiketki met, ni ei kaunopadahr deumwi ni imweio, oh dewen noumwi mahn akan?” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ohlo eri pedolong nan ihmwo, a Lapan akeredihsang pohn kamel ko kepwe ko oh kamwenge irail. Mwuhr, e ahpw kihong pihl laduwo oh ienge ko pwe re en widen nehrail ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kisin sak pil kaunopadahr mwohrail; laduwo ahpw ketihtihki, “I sohte pahn tungoal mwohn ei pahn sakarkihda kahrepen ei pwarodo.” Lapan eri nda, “Nna, komw kaselehda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ih eri tapiada koasoi: “Sapwellimen Eipraam ladu ngehi. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","KAUN-O ketin kupwuramwahwih mehlel ei soumaso, oh ketin kapaiahda ni mehkoaros. E ketikihong pelin sihpw ngeder, pelin kuht oh kou, silper, kohl, oh lidu kei, iangahki kamel oh ahs tohtohie. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, en ei soumaso eh pwoud, naitikihada pwutak emen ni eh likeilapalahr. Ei soumaso ketikihongehr eh sohso, mehkoaros me e ahneki. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","E kehkehlingkihong ie I en inoukihda oh kapwaiada eh mahsen, ni eh mahsanih, ‘Kaleke ke pilada en nei pwutaket eh pwoud sang nan wehin Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ke pahn kohwei rehn ei peneinei, rehn kisehi ko, oh pilasang rehrail en nei pwutaket eh pwoud.’ ");
INSERT INTO pon2006a_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ngehi ahpw patohwanohng ei soumaso, ‘A dahme pahn wiawi, ma serepeino sohte men iang patohdo?’ ");
INSERT INTO pon2006a_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","A e sapeng, mahsanih, ‘KAUN-O, me I kin peikiong ahnsou koaros, pahn ketin kadar sapwellime tohnleng pwe en ieiang uhk pwe omw seiloak en kak pweida. Ke pahn ale en nei pwutaket eh pwoud sang rehn ei peneinei, sang rehn en ei pahpao eh peneinei. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Eri, ma ke kapwaiada met, ke pahn saledeksang omw inowo; a ma ke kohla rehn ei peneinei, re ahpw kahng kihwei, ke pahn pil saledeksang omw inowo.’ ");
INSERT INTO pon2006a_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Eri, ni ei leledo rahnwet ni pwarero, I wia ei kapakap nin duwe met, ‘Maing KAUN, Koht en ei soumas Eipraam, komw ketin kupwure ei doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Iet ngehi me patopato ni pwarer wet. Eri, ni serepein pwulopwul men eh pahn kohieidohng idipil, I pahn peki en kihdo mahs nimei kis pihl sang nan nah saho. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Eri, ma e kihdo oh e pil pahn kanimpile nei kamel akan, iei ih me komw ketin pilada en nein ei soumaso pwutak eh pwoud.’ ");
INSERT INTO pon2006a_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Eri, mwohn ei kanekehla ei kapakapo, Repeka pa lella kapaik eh saho, e ahpw kohdihla idipil ni pwarero, I ahpw ndahng, ‘Menlau kihdo mahs nimei kis pihlen.’ ");
INSERT INTO pon2006a_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","A e mwadangete kihdi eh saho oh nda, ‘Ale, nim oh I pil pahn kanimpile noumw kamel akan.’ Ngehi eri nimpil oh ih kanimpile kamel ako. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","I ahpw idek reh, ‘Nein ihs kowe? Ihs omw pahpa?’ A e sapeng, nda, ‘Nein Petuel ngehi, nein Nahor oh Milka.’ Ngehi eri kihong kisin rihngo ni tumweo oh luwou ko ni peh ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ngehi eri kelehpwikihdi oh kaudokiong KAUN-O. I kapinga KAUN-O, Koht en ei soumas Eipraam, me ketin kahluwaiedohng rehn rien ei soumaso, wasa I diarehr ie en nein ei soumaso pwutak eh pwoud. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Eri, ma komw men kapwaiada omwi pwukoa ong ei soumaso, a komw menlau padahkihdo; ma so, komw pil mahsanihodo, pwe I en koasoanehdi dahme I pahn wia.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lapan oh Petuel eri sapeng, “Pwehki irair wet eh sang ni kupwuren KAUN-O, kitail sohte kak wia mehkot pwe kapwaiadahte. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Eri, iet Repeka; komw ale oh ketikihda. En pwoudikihda nein omw soumaso, pwutak, nin duwen me KAUN-O ketin kupwurkiher.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ni nein Eipraam laduwo eh rongada arail pasapeng en pekipek wet, e ahpw poaridi lel nanpwel oh kaudokiong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","E ahpw kapwarehda likou, silper, kohl oh dipwisou en kapwat ekei, oh kihong Repeka. E pil kihong ekei dipwisou pweilaud ko rehn rien Repeka ohlo oh eh nohno. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Eri, nein Eipraam laduwo oh ienge ko ahpw mwenge oh nim, oh pweidi wasao. Nimenseng en mandahn rahno, laduwo ahpw ndaiong irail, “Eri, kumwail mweidohng ie pwe I en pwuralahng rehn ei soumaso.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Lapan oh eh nohno ahpw sapeng, “Serepeinen en mihmihte mahs reht wihk ehu de rahn eisek; mwuhr, e kak kohkohwei.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","A e sapeng ira, nda, “Kumwail dehr kapweiekiehdi, pwe KAUN-O ketin kupwuramwahwihalahr ei seiloaket. Kumwail mweidohng ie I en pwurala rehn ei soumaso.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Irail eri sapeng, nda, “Kitail ekerodo serepeinen oh idek reh nsene.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Irail eri ekerodo Repeka oh idek reh, “Ke men iangada ohl menet kohkohla?” A e sapeng, “Ei, I pahn iangada.” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Eri, irail ahpw mweidala Repeka oh neirail sounpapaho en iangada nein Eipraam laduwo oh ienge ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Irail eri kapaiahda Repeka, nda: “Kowe riat serepein, ke en wiahla inen kadaudok ngedehrie! Kadaudokomw kan en kalowehdi kahnimw en ar imwintihti kan!” ");
INSERT INTO pon2006a_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Mwuhr, Repeka oh nah pwihnen serepein kan ahpw karadahng pohn kamel ko oh iangada nein Eipraam laduwo, re ahpw mwesel kohkohla. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aisek ahpw mwemweitlahng nan sapwtehn en “Pwarer en me Ieiaso Me ketin Mamahsanih Ie”; e ahpw kin koukousoan palieir en Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Soutik ehu, e ahpw wie mwemweitseli nan mohs akan, e ahpw kilangada kamel kei me kohkohdo. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ni Repeka eh kilangada Aisek, e ahpw keredihsang pohn dakepeo, ");
INSERT INTO pon2006a_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","oh idek rehn nein Eipraam laduwo, “Ihs ohl meno me kohkodohng kitail nan mohso?” Laduwo ahpw sapeng, nda, “Ih ei soumaso mwo.” Repeka eri alehte eh koaduhpwel, koaduhpwalkihdi meseo. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Laduwo eri ndaiong Aisek mehkoaros me e wiadahr. ");
INSERT INTO pon2006a_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Mwuhr, Aisek ahpw kahrehlong Repeka nan impwal en eh nohno, Sara, oh serepeino ahpw wiahla eh pwoud. Aisek poakepoakehla mehlel Repeka, iei me e sohla kin nsensuwedki mehlahn eh nohno. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Eipraam pil pwoudikihda emen lih torohr, me adaneki Ketura. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","E ahpw naitikihong Simran, Soksan, Medan, Midian, Ispak, oh Sua. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Soksan me semen Sipa oh Dedan, oh kadaudok en Dedan iei mehn Ahsur, mehn Letus oh mehn Leum. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Nein Midian pwutak iei Epa, Eper, Anok, Apida, oh Eldaa. Irail pwukat koaros iei kadaudok en Ketura. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Eipraam kihong Aisek mehkoaros me e ahneki; ");
INSERT INTO pon2006a_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ahpw nindokon eh momourte, e kihong kisakis kei ong nah pwutak me eh pwoud teiko wiahiong. E ahpw kadaralahng seri pwukat palimese dohlasang nah pwutak Aisek. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Eipraam eri sipalla ni eh sounpar 175. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Nah pwutak Aisek oh Ismael nekidedi kahlepe nan pwoaren paip Makpela, nan sahpw palimesehn Mamre me kisehn sapwen Epron nein Sohar mehn Id. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ih sahpwet me Eipraam pwainsang mehn Id ko; Eipraam oh eh pwoud ira koaros seridi wasao. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Mwurin sipallahn Eipraam, Koht ketin kupwuramwahwihala nah pwutak Aisek, me kin kousoan limwahn “Pwarer en me Ieiaso Me ketin Mahmahsanih Ie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ismael, me Akar, lidu en Sara mehn Isipo, wiahiong Eipraam, ");
INSERT INTO pon2006a_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","naineki pwutak pwukat, nin duwen irekidien ar ipwidi: Nepaiod, Kedar, Adpeel, Mipsam, ");
INSERT INTO pon2006a_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO pon2006a_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Setur, Napis, oh Kedema. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Irail wia pahpa kahlap en kadaudok eisek riauo, oh mwararail kan ahpw kohieng pohn arail kousapw oh wasahn kousoan kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael sounpar 137 ni eh sipalla. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Kadaudok en Ismael kan kousoanla nan sahpw me mi nanpwungen Apila oh Sur, ni palimesehn Isip nan ahl me tang kolahng Asiria. Re kin kousoan dohsang kadaudok teikan en Eipraam. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Iet duwen poadopoad en Aisek, nein Eipraam. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisek sounpar 40 ahnsou me e pwoudikihda Repeka, nein Petuel (mehn Aram oh Mesopodamia) oh rien Lapan serepein. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Pwehki Repeka eh sohte neitik, Aisek ahpw kapakapohng KAUN-O. KAUN-O ahpw kupwurehla eh pekipek, Repeka eri liseianda. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ni kisin mpwero ara pisipisikenpene nan kapehde, Repeka ahpw nda, “Dahme soahng wet kak wiawihkihong ie?” Ih eri patohwan peki rehn KAUN-O en ketin kamarainih. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","KAUN-O eri mahsanihong, “Tohn wehi riau me mihmi nan kapehdomw. Ke pahn naitikihada tohn wehi riau me pahn uhpene nanpwungara. Ehu pahn kehlail sang ehu; oh me laudo pahn liduwih me tikitiko.” ");
INSERT INTO pon2006a_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Eri, ni eh lelehr ahnsoun eh neitik, Repeka ahpw naitikihada mpwer ehu. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kisin pwutako me ipwidi mahso me poh weitahta, kili me wunaun; iei me irail kihongki ede Esau. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ni rieo eh pil ipwidi, e kolokol teng keimwin nehn Esauo; iei me irail kihongki ede Seikop. Seri ko ipwidi ni ahnsou me Aisek sounpar 60. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Eri, ni pwutak ko ara keirda, Esau wiahla soupal en kesik mahn emen, me kin perenki mihmihseli nansapw; a Seikop pwutak nennen emen me kin mihmihte ni imwe. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisek ahpw kesempwalkihla Esau pwehki eh kin perenki sakan mahn me Esau kin kasikihdi; a Repeka kin mwohneki Seikop. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Rahn ehu nindokon Seikop eh inihnim kene kisin sali, Esau ahpw pwurodo sang kesik nansapw, inenen men mwengehda. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","E ahpw ndahng Seikop, “I inenen duhpeklahr, kihdo mahs kenei kis konomw sali weitahtahn.” (Ihme e adanekihki Edom.) ");
INSERT INTO pon2006a_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Seikop ahpw sapeng, nda, “I pahn kihwei, ma ke pahn kihong ie omw pwungen sohso.” ");
INSERT INTO pon2006a_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau ahpw sapeng, ketihtihki, “I nektehn mehla, dah katepehiong ie ei sohso?” ");
INSERT INTO pon2006a_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Seikop eri sapeng, nda, “Nna, kahukihla mahs me ke pahn kihdo omw sohso.” Esau eri kahula oh inoukihong Seikop pwungen eh sohso. ");
INSERT INTO pon2006a_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Seikop eri kihong kene pilawa oh selie nan dahl ehu. E ahpw tungoalehla oh kohkohla. Ih duwen Esau eh sohte mwahn kesempwalki pwungen eh sohso. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Lehk lapalap ehu ahpw pweida nan sahpwo me tohrohrasang me wiawi ni mwehin Eipraam. Aisek eri kohla rehn Apimelek, nanmwarkien mehn Pilisdia kan, nan Kerar. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","KAUN-O ketin pwarohngehr Aisek oh mahsanihongehr, “Ke dehr kohdihla Isip, ahpw mihmihte nan sahpwet, wasa me I ndaiong uhk ke en mihmi ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Mihmihte nan sahpwet, I ahpw pahn ieiang uhk oh kupwuramwahwihiuk, pwe I pahn kihong uhk oh kadaudokomw kan sahpw pwukat koaros, pwe I en kapwaiada inou me I wiahiong semomwo, Eipraam. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I pahn katohtowehla kadaudokomw kan duwehte usu en pahnlahng kan, oh kihong irail sahpw pwukat koaros. Wehi koaros pahn peki I en kapaiairailda duwehte ei kapaiadahr kadaudokomw kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","I pahn kapaiaiukada, pwehki Eipraam e peikiong ie oh kapwaiada ei kosonned kan oh ei koasoandi koaros.” ");
INSERT INTO pon2006a_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Aisek eri kousoanla nan Kerar. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ni ohl akan en wasao ar kin idek ihs Repeka, e kin ndahng irail me rie. E perki ndaiong irail me eh pwoud Repeka, pwe ohl en wasao de kemehla pwe re en kihsang Repeka, pwe liho me inenen kaselel. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ni Aisek eh wereilahr wasao, Apimelek, nanmwarkien Pilisdia, ahpw mahsenieisang nan wenihmwtok ehu oh mahsanihada Aisek oh Repeka ara wiewia nsenen pwopwoud. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","E ahpw malipehdo Aisek oh mahsanihong, “Uhdahn omw pwoud lih menen, a dahme ke ndahki me riomw?” Aisek ahpw sapengki, “I perki pwe aramas akan de kemehkiniehla ma I pahn nda me ei pwoud.” ");
INSERT INTO pon2006a_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Apimelek ahpw mahsanih, “Dahme ke wiahkihong kiht soangen piht wet? Emen ohl pwukat kakete engda rehn omw pwouden oh kowe me pahn pwukoahkihdi sapwung wet.” ");
INSERT INTO pon2006a_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Apimelek ahpw mahsanihong aramas koaros koasoandi wet, “Mehmen me pahn kedirapwa ohl menet de eh pwoud pahn kamakamala.” ");
INSERT INTO pon2006a_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisek eri padokedi wahntuhke nan sahpwo, e ahpw dolung pak epwiki tohtohsang me e padokedi, pwe KAUN-O ketin kupwuramwahwih. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Rahn koaros e ahpw kin kekeirda nan eh paiamwahu, e lao wiahla ohl kepwehpwe men. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","E naineki kiden sihpw oh kou, oh tohndoadoahk ngeder, kahrehda mehn Pilisdia kan kin peiriniong. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Mehn Pilisdia kan eri audekihla pwehl pwarer en pihl koaros me nein eh pahpao, Eipraam, tohndoadoahk kan weiradahr mahs. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Apimelek ahpw mahsanihong Aisek, “Eri kohkohweisang nan wehiet, pwe ke inenen kehlailsangkihtehr.” ");
INSERT INTO pon2006a_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Aisek eri mwesel kohkohla oh kauwada imwe impwal kan nan Wahun Kerar, wasa me e kousoanla ie ahnsou kis. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Aisek ahpw pwurehng weirada pwarer me weiweidahr nan mwehin Eipraam, me mehn Pilisdia ko audekilahr pwehl. E ahpw kihong eden pwarer ko soangen ahd kante me eh pahpao kihong eden pwarer ko mahsie. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Nein Aisek tohndoadoahk ko weirada pwarer ehu nan wahuo oh diarada pihl me pwepwengkida sang loale. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Silepen sihpw kei en Kerar ahpw akamaiong nein Aisek silepen sihpw ko, ketihtihki, “Aht pwarer men.” Ih me Aisek kadanekihki pwarero “Akamai.” ");
INSERT INTO pon2006a_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Re pil weirada ehu pwarer, re ahpw pil akamaikihda; e ahpw kadanekihla pwarero “Pelian.” ");
INSERT INTO pon2006a_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","E ahpw mwekidsang wasao oh pil weirada ehu pwarer. Eri pwarer wet sohte akamaipe wiawi, e ahpw kadanekihla “Saledek.” Aisek ahpw mahsanih, “KAUN-O ketikihongkitailehr saledek pwe kitail en kousoan nan sahpwet, eri kitail pahn paiamwahula wasaht.” ");
INSERT INTO pon2006a_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Aisek ahpw mweselsang wasao oh kohdahla Peersepa. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Nipwongohte KAUN-O ketin pwarohng oh mahsanihong, “Ngehi me Koht en semomw Eipraam. Ke dehr masak mehkot; I kin ieiang uhk. I pahn kapaiaiukada oh kangederehla kadaudokomw kan pwehki ei inou ong ei ladu Eipraam.” ");
INSERT INTO pon2006a_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Aisek eri kauwada pei sarawi ehu wasao oh kaudokiong KAUN-O. Mwurin eh kauwada imwe impwal kan wasao, nah tohndoadoahk kan ahpw weirada pwarer ehu wasao. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Apimelek ketido sang Kerar, iangahki sapwellime sounkaweid Ahusad oh Pikol, kaunen sounpeio, pwe re en tuhwong Aisek. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aisek eri idek rehrail, “Dahme kumwail ketikihdo rehi met, nan amwail sohte kupwurkin ie oh kausiesang nan sapwellimamwail wehi?” ");
INSERT INTO pon2006a_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","A re sapeng, “Met se eseier me KAUN-O kin ketin ieiang komwi, iei me se koasoanehdi pwe kitail en wiahda inou nanpwungatail. Se men komwi en inoukihda ");
INSERT INTO pon2006a_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","me komwi sohte pahn wiahiong kiht mehkot suwed, duwehte at sohte wiahiong komwi mehkot suwed. Se kadek ong komwi oh mweidohng komwi en mweselsang reht ni popohl. Eri e uhdahn sansal me KAUN-O ketin kupwuramwahwihkomwier.” ");
INSERT INTO pon2006a_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Aisek eri kamadipweirailda, irail eri konot oh sakau. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nimensehngie en mandahn rahno, re ahpw wiahda ar inou oh kahula. Aisek eri kamwurirailla, re ahpw ketiketla ni popohl. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ni rahnohte nein Aisek tohndoadoahngko ahpw pwarodo oh kairehki duwen pwarer me re weiradahr. Re ndahng, “Se diaradahr pihl.” ");
INSERT INTO pon2006a_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ih eri kihong eden pwarero “Inou.” Ih me kahnimw en wasao adanekihki Peersepa. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ni Esau eh sounpar 40, e pwoudikihda serepein en Id riemen; Sudid, nein Peeri, oh Pasemad, nein Elon. ");
INSERT INTO pon2006a_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Serepein pwukat koaros kahrehiong en Aisek oh Repeka ara nsensuwed mehlel. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Eri, ni Aisek eh ohl laudlahr oh maskunlahr, e ahpw ekerodo nah pwutak laudo, Esau, oh ndaiong, “Samwa!” Esau ahpw sapeng, “Maing.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aisek ahpw ndahng, “Kilang, pwe I ohl laudlahr oh nektehn mehla. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ale noumw kesik ketieu oh kanenge kan, ke ahpw kohwei nansapw oh kasikiodo kenei emen mahnen. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ke ahpw umwunda duwen me I kin ioukio, oh wahdo rehi, pwe I en tungoale, I ahpw pahn kapaiaiukada mwohn ei pahn mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Repeka ahpw wie rongorong Aisek ni eh ndindaiong Esau mepwukat. Eri, ni Esau eh mwesel kolahng kesik, ");
INSERT INTO pon2006a_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Repeka ahpw ndaiong Seikop, “I rong omw pahpao eh ndahng Esau, ");
INSERT INTO pon2006a_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Wahdo mahs kenei emen mahnen, umwunda, pwe I en tungoale oh kapaiaiukada mwohn silangin KAUN-O mwohn ei pahn mehla.’ ");
INSERT INTO pon2006a_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Eri, samwa, kapwaiada me I pahn ndaiong uhk. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kohwei rehn pelin kuhto, pilada riakis kuht mworourou en oh wahdo rehi, pwe I en umwunda nin duwen omw pahpao eh kin iouki. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ke ahpw pahn walahng pwe en sakan, pwe en kapaiaiukada mwohn eh pahn mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Seikop ahpw ndahng eh nohno, “A ia duwen, pwe ke ese me riei Esau me kil wunaun, a ngehi I me kil medendel. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ma ei pahpao pahn sair ie, e pahn esehda me I pitipitih; e ahpw pahn keriaiehla oh sohte kapaiaiehda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Eh nohno ahpw sapeng, nda, “Keriapomw koaros en kohdi pohi, samwa. Kapwaiadahte me I ndaweiet, kohwei wahdo kuht ko.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Seikop eri kohla, pilada kuht ko, oh wahdo rehn eh nohno. Liho ahpw kaunopada nin duwen me Aisek kin inangih sakan. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Repeka eri ale en Esau eh likou kaselel ko, me e kin nekinekid nan imweo, oh kalikawihkihda Seikop. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","E ahpw kidimkipene pehn Seikop oh tepinwere kilin kuht ko, ");
INSERT INTO pon2006a_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","oh kihong kisin sak iou oh pilawa me e umwunda. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Seikop eri wa kohla rehn eh pahpao oh ndahng, “Ipa.” A e sapeng, “Ihs kowe?” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Seikop ahpw sapengki, “Ngehi Esau, noumwi pwutak mesenih. I wiahda mehkoaros duwen omwi mahsanihong ie. Pwourda oh sakan kisin uduk me I wadohng komwi pwe komwi en kapaiaiehda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Aisek eri sapeng, “Ke meid mwadang en diarada kisin uduk pwukan, samwa!” A e sapeng, nda, “KAUN-O, omwi Koht, me ketin sewese ie pwe I en mwadang diarada.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Aisek eri ndalahng Seikop, “Keido mahs pwe I en sair uhk, mehlel me kowe Esau?” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Seikop eri keilahng mpen eh pahpao. Eh pahpao eri sair oh mahsanih, “Ngilomwen ngilen Seikop, a pehmw kan pehn Esau.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","E sohte lemeleme me Seikop mwo, pwehki peh kan eh wunaun duwehte pehn Esau. Ih eri pahn kapaiahda Seikop, ");
INSERT INTO pon2006a_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","e ahpw pil pwurehng idek, “Mehlel me kowe Esau?” A Seikop sapeng, “Ei, maing,” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Aisek eri ndalahng, “Nna, kihdo mahs delen uduken, pwe I en tungoale; I ahpw pahn kapaiaiukada.” Seikop eri kailahng dahlo, e ahpw pil kihong wain pwe en nim. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Eri, E pahpao ahpw ndahng, “Keido metik ie, samwa.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Seikop eri keila oh metik eh pahpao. Eri, ni Aisek eh nedada pwohn eh likou ko, e ahpw kapaiahda oh nda, “Pwohtik pwohmwahu en nei pwutaket rasehng pwohtik pwohmwahu en sahpw ehu me KAUN-O ketin kupwuramwahwiher. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Koht en ketikihong uhk pwoaiken lahng oh kangederehla audepen sapwomw kan; en ketikihong uhk rahk en pilawa oh wain. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Wehi kan en uhpahiong uhk, oh aramas akan en poaridi mwohmw. Ke en kaunda omw peneinei kan, oh kadaudok en omw nohno kan en poaridi mwohmw. Irail kan me pahn keriaiukala, re en riahla, oh irail kan me pahn kapaiaiukada, re en paiamwahula.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisek eri kairalahte kapaiamwahu wet, Seikop ahpw mwesel kohkohla. Mwurihte, rie Esau pa pwersang. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","E pil wa kodohng eh pahpao kisin uduk me e umwundahr, oh ndahng, “Ipa, pwourda oh sakan, oh kapaiaiehda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aisek ahpw idek reh, “Ihs kowe?” A Esau sapeng, “Noumwi pwutak mesenih, Esau.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Aisek ahpw tapihada rerrer oh idek, “A pwe ihs me apwtehn kemehla mahn emen oh wadohng ie I en tungoale mwohn omw pwarodo? I tungoalehr oh kapaiadahr; oh e pahn pai kohkohlahte.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau lao rong mepwukat, e ahpw weriwer oh nsensuwedla mehlel, e ahpw ndaiong eh pahpao, “Ipa, menlau pil kapaiaiehda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Aisek ahpw sapeng, nda, “Riomwo kohdo oh pitihiehdi; e kihsangehr kapaipomw.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau eri nda, “Ih keriapak en eh pitihiehdi met. E konehng mehlel edeo, Seikop. E kihsangieier pwungen ei sohso, a met e pil kihsangehr kapaipei. Ia duwe, sohte kapaiamwahu ehu komw nekinekidohng ie?” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aisek ahpw sapeng, “I koasoanehdi en kaunuhkada, oh kilelehiong kiseh kan koaros re en kin liduwih. I kihong rahk en pilawa oh wain. Eri, met solahr me I kak wiahiong uhk, samwa.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau usehlahte eh pekipek ngidingid rehn eh pahpao, ndinda, “Ipa, ia duwe, kapaiamwahuteieu me mi rehmw? Menlau pil kapaiaiehda.” Ih eri sengiseng. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Aisek eri ndahng, “Sohte kapaien sampah ong kowe, sohte pahn pwoaiken nanleng ong sapwomw kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ke pahn momourki noumw kedlahs, oh uhpahiong riomwo. Ahpw soh, ni omw pahn pelian, ke pahn pitsang omw uhpahiong.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau eri kailongkihla mehlel Seikop, pwehki kapaiamwahu me eh pahpa wiahiong. E ahpw mengimengloalki, “Ahnsoun mwahieiki mehlahn ei pahpao kerendohr. Eri, mwurin ahnsowo, I ahpw pahn kemehla Seikop.” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ahpw ni Repeka eh rongada duwen lamalam en Esau, ih eri ekerodo Seikop oh ndahng, “Kilang, riomw Esau lemeleme en dupukohng uhk oh kemeiukala. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Eri, samwa, kapwaiada me I pahn ndawei. Onopada pwe ke en tangala rehn riei Lapan nan Aran. ");
INSERT INTO pon2006a_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Mihmi mahs reh ekis ahnsou, nsensuwed en riomwo lao meleileidi, ");
INSERT INTO pon2006a_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","oh e lao manokehla me ke wiahiong. Mwuhr, I ahpw pahn kadarala emen pwe en kapwureiukodo. Dahme nei pwutak riemenet pahn pwupwukihsang ie rahnteieu?” ");
INSERT INTO pon2006a_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Repeka ahpw ndahng Aisek, “I inenen tihwokilahr en Esau eh pwoud kan, lihen liki kan. Ma Seikop pahn pwoudikihda emen soangen lih pwukat, me pwilidak en Id, eri a, ihte me mwahu, I en mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Aisek eri ekerodo Seikop oh rahnmwahwih, e ahpw kehkehlingkihong nda, “Ke dehpa pwoudikihda emen lihen Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Onopada pwe ke en kohwei Mesopodamia, ni imwen Petuel, semen omw nohno. Ke ahpw pwoudikihda emen lihen wasao, emen nein Lapan, rien omw nohno, nah serepein ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Koht, Wasa Lapalap, en ketin kupwuramwahwihiuk oh ketikihong uhk noumw seri tohto, pwe ke en wiahla semen wehi tohto! ");
INSERT INTO pon2006a_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","En pil ketin kupwuramwahwihiuk oh kadaudokomw kan duwehte eh ketin kupwuramwahwih Eipraam, pwe kumwail en sapwenikihla sahpw wet me ke keikeiruier loale, oh me Koht ketikihong Eipraam.” ");
INSERT INTO pon2006a_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aisek eri kadarala Seikop Mesopodamia, rehn Lapan, nein Petuel mehn Aram. Lapan, iei rien Repeka me naineki Seikop oh Esau. ");
INSERT INTO pon2006a_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau ahpw esehda me Aisek kapaiadahr Seikop oh kadaralahngehr Mesopodamia, pwe en ale eh pwoud emen lihen wasao. E pil esehda me ni Aisek eh kapaiahda Seikop, e kehkehlingkihong en dehr pwoudikihda emen lihen Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","E pil diarada me Seikop peikiong eh pahpa oh nohno oh samwalahr Mesopodamia. ");
INSERT INTO pon2006a_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Eri, ni Esau eh esedahr me eh pahpa Aisek sohte pwungki lihen Kenan men en pwoudiki nah pwutako, ");
INSERT INTO pon2006a_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","e ahpw kohla rehn Ismael, nein Eipraam, oh pekehikihda emen lih tohrohr, ede Maalad, me tiksang Nepaiod. ");
INSERT INTO pon2006a_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Seikop eri mweselsang Peersepa oh seiloaklahng Aran. ");
INSERT INTO pon2006a_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","E ahpw lellahng wasa kis me e pweidi ie, pwehki wasa pwongihdi. Ih eri ale takai ehu wasao pwe en ulung oh meirla. ");
INSERT INTO pon2006a_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","E ahpw ouramanda dene e kilangada kehndake ieu me uhdahsang sampah oh leldahla nanleng; a tohnleng en Koht kei kin doudou kohda oh kin doudou kohdi powe. ");
INSERT INTO pon2006a_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","A dene KAUN-O ketiket limwah, e ahpw mahsanihong, “Ngehi me KAUN-O, Koht en Eipraam oh Aisek. I pahn kihong uhk oh kadaudokomw kan sahpw wet me ke pweidi ieht. ");
INSERT INTO pon2006a_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Kadaudokomw kan pahn ngeder, rasehng pwelpar en sampah; re pahn kaparaparala nan sahpw koaros nin sampah. Eri, wehi kan koaros nin sampah pahn men I en kapaiairailda nin duwen ei kapaiadahr kowe oh kadaudokomw kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Tamataman me I pahn ieiang uhk oh sinsileiuk wasa koaros me ke pahn kohla ie, oh I pahn kapwuredohng uhk nan sahpw wet. I sohte pahn keseiukala I lao kapwaiada mehkoaros me I inoukihong uhk.” ");
INSERT INTO pon2006a_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Seikop ahpw pirida, oh nda, “Mehlel me KAUN-O ketiket wasa kiset, I ahpw sohte ese.” ");
INSERT INTO pon2006a_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","E ahpw lemmwida oh nda, “Meid kelemw wasa kiset! Mehlel me tehnpas en Kohto met, oh wenihmwen lahng.” ");
INSERT INTO pon2006a_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Seikop ahpw pwourda nin sorahnie. E ahpw ale takai me e ulungo oh kauwada pwe en wia mehn kataman ehu. Ih eri kieldiong powe leh pwe en kasarawihong Koht. ");
INSERT INTO pon2006a_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","E ahpw kihong eden wasao Pedel. (Mahsie kahnimw en wasao adaneki Lus.) ");
INSERT INTO pon2006a_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Seikop ahpw pil wiahiong KAUN-O inou ehu, patohwanohng, “Maing, ma komw pahn ketin ieiang ie oh sewese ie ni ei seiloak wet, oh ketikihdo ei tungoal mehn ketihnain oh likou, ");
INSERT INTO pon2006a_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","oh ma I pahn paiamwahu pwuralahng ni imwen semeio; eri, komwi, maing, me pahn wiahla ei Koht. ");
INSERT INTO pon2006a_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Takai wet me I kauwadahr pwe en wia mehn kataman ehu, pahn wiahla tehnpasomwi, oh I pahn kin meirongkihong komwi eisek kis ehun mehkoaros me komw pahn kin ketikihong ie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Seikop eri usehla eh seiloaklahng sapwen mehn palimese. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ni eh kohkohla nanialo e ahpw kilangada pwarer ehu nan mohs ehu, oh pelin sihpw siluh me mihmi limwah. Pwe pelin sihpw ko kin nimpilsang ni pwarer wet, oh lapalahn takai ehu kin pwaindi pwarero. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ni pelin sihpw ko koaros ar kin pokonpene wasao, silepe kan kin katapwurehsang takaio pohn pwarero, oh kin kanimpile sihpw kan. Eri mwuhr, re kin kapwurehiong powe. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Seikop eri idek rehrail, “Riei ko, mehnia kei kumwail?” Irail ahpw sapeng, “Kiht mehn Aran.” ");
INSERT INTO pon2006a_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","A e idek, “Kumwail ese Lapan nein Nahor?” A irail sapeng, “Ei, se ese.” ");
INSERT INTO pon2006a_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","A e pil pwurehng idek, “E me kehlail, de soh?” Re ahpw sapengki, “Ei, e me kehlail; oh iet Resel nah serepein me kahkahre kohdo nah pelin sihpw.” ");
INSERT INTO pon2006a_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Seikop eri nda, “Pwehki wasa eh sousouwasete oh eh saikinte ahnsoun kapokonepene sihpw kan nan kehl, dahme kumwail so kanimpileirail oh kapwureiraillahng nan mohs pwe re en mwengemwenge mahs?” ");
INSERT INTO pon2006a_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Irail eri sapeng, nda, “Se sohte kak wia men; pelin sihpw koaros lao pokonpene, se ahpw pahn katapwurehsang takaien pohn pwareren oh kanimpile sihpw akan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Nindokon Seikop eh lokolokaiaiong irail, Resel pa lel wasao, kahre nein eh pahpao pelin sihpw; pwe ih me kin apwahpwalih irail. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ahnsou me Seikop kilangada Resel, nein Lapan rien eh nohno, ni eh kahkahre sihpw ko, e kohla ni pwarero oh katapwurehsang takaio powe, e ahpw kanimpile nein Lapan sihpw ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ih eri metik Resel oh sengisengki eh peren. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","E ahpw ndaiong, “Ngehi nein Repeka, oh kisehn omw papaho.” Resel eri tangala ndahng eh pahpao. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lapan rongadahte duwen Seikop, nein rie serepein Repeka, e mwadangalahte kasamwo, pwoalehdi oh metik; e ahpw kahrehdo ni imweo. Seikop eri koasoiaiong Lapan mehkoaros me wiawiher. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lapan ahpw ndaiong, “Ei, mehlelete, pwe kowe kisehn udukei oh kisehn ntai.” Seikop eri mihmihki reh sounpwong ehu. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lapan eri ndahng Seikop, “Mehnda ma kita peneinei ehu, a e sohte konehng ke en doadoahkohng ie ni sohte pweipwei. Ia uwen pweipwei me ke anahne?” ");
INSERT INTO pon2006a_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Mie nein Lapan nah serepein riemen: me laudo ede Lia, a me tikitiko Resel. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Ahpw Lia me ekis kersuwed, a Resel me inenen masamwahu oh paliwaramwahu. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Seikop mwahuki mehlel Resel, iei me e ndakihong Lapan, “I pahn doadoahkohng komwi erein sounpar isuh pwe I en pwoudiki Resel.” ");
INSERT INTO pon2006a_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","A Lapan sapeng, ndaiong, “Ei, I mwahuki kihong uhk sang emen tohrohr. Eri, ke pahn mihmihte rehi.” ");
INSERT INTO pon2006a_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Seikop eri doadoahngki erein sounpar isuh pwehki Resel, a sounpar isuho likamwete rahnte depe pwehki eh nohn poakepoake Resel. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Seikop eri ndaiong Lapan, “Eri, komw mweidohngiehla Resel pwe I en pwoudikihda, pwe ahnsou leledohr.” ");
INSERT INTO pon2006a_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Lapan eri wiahda kamadipw en kapwopwoud ehu oh lukehiong aramas koaros en wasao. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","A nipwongo, e kawaila Lia wiliandi Resel rehn Seikop; Seikop eri wiahda reh nsenen pwopwoud. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Lapan ahpw kihong Lia emen nah serepein lidu ko, ede Silpa, pwe en papah.) ");
INSERT INTO pon2006a_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Eri, nimensengo Seikop ahpw diarada me Lia me e wiahda reh nsenen pwopwoud. Ih eri ndahng Lapan, “Dahme ke wiahkihong ie met? I doadoahkohng komwi pwe I en ale Resel. Dahme komw pitihkiniehdi?” ");
INSERT INTO pon2006a_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lapan ahpw sapeng, nda, “Iet duwen tiahk en sahpwet, se sohte kin kapwopwoudihala nait serepein tikitik kan mwohn me laud kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Awih lao wihk ehu dou pohn kasarawihpen kapwopwoud wet, I ahpw pahn kihong uhk Resel, ma ke pahn doadoahkohng ie pil erein sounpar isuh.” ");
INSERT INTO pon2006a_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Seikop eri pwungkihda, oh mwurin wihk ehu, Lapan ahpw kihong Resel pwe en pwoudikihda. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Lapan ahpw kihong Resel emen nah serepein lidu ko, ede Pila, pwe en kin papah.) ");
INSERT INTO pon2006a_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Seikop eri pil wiahda nsenen pwopwoud rehn Resel oh e poakepoake laudsang e poakepoake Lia. Ih eri doadoahkohng Lapan pil erein sounpar isuh. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","KAUN-O lao ketin mwahngihada me Seikop sohte nohn poakepoake Lia, e ahpw ketin kupwurehla pwe en neitik; a Resel sohte neitik. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lia eri liseianda oh naitikihada pwutak emen. Ih eri patohwan, “KAUN-O ketin kupwurehla ei apwal oh met ei pwoudo pahn poakepoakeiehla.” Ih eri kihong eden pwutako Reupen. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","E pil pwurehng liseianda oh naitikihada pil emen pwutak. Ih eri patohwan, “KAUN-O pil ketikihong ie pwutak menet, pwehki eh karongehda duwen Seikop eh sohte nohn poakepoake ie.” Ih eri kihong ede Simion. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","E ahpw pil pwurehng liseianda oh naitikihada pil emen kisin pwutak. Ih eri patohwan, “Eri, met ei pwoudo pahn patehng ie oh poakohng ie, pwehki ei naitikiadahr pwutak silimen.” Ih eri kihong ede Lipai. ");
INSERT INTO pon2006a_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","E ahpw pil pwurehng liseianda oh naitikihada pil emen pwutak. Ih eri patohwan, “Met, I pahn kapinga KAUN-O.” Ih eri kihong ede Suda. Eri mwuri, e ahpw sohla neitik. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Eri, ni Resel eh eseier me e sohte neitik, e ahpw peiriniongada rieo Lia oh ndaiong Seikop, “Menlau wiahiong ie nei seri, ma soh, I pahn mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Seikop eri lingeringerda pahn Resel oh ndaiong, “Dah, ngehi me Koht? Pwe ih me ketin kupwurehda ke en wia lih depwen.” ");
INSERT INTO pon2006a_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","A Resel ahpw sapeng, nda, “Iet ei lidu, Pila. Ale oh pekehikihda, pwe en liseianda oh wiahiong ie nei seri. Eri, ih duwen ei pahn kak naineki seri sang rehn ei liduwet.” ");
INSERT INTO pon2006a_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ih eri kihong Seikop eh lidu Pila pwe en pekehikihda; Seikop eri wiahda rehn Pila nsenen pwopwoud. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Pila eri liseianda oh naitikihada kisin pwutak kis. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Resel eri nda, “Koht ketin kasalehiongieier ei pwuhng. E ketin karonge ei pekipek oh ketikihong ie nei seri.” Ih eri kihong ede Dan. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Eri, en Resel eh lidu ahpw pil pwurehng liseianda oh naitikiadahng Seikop nah pwutak keriemen. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Resel ahpw nda, “I uhwong oh pelianda riei serepein, oh kalowehdi.” Ih eri kihong eden pwutako Napdali. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ni Lia eh eseier me e solahr neitik, e kihong Seikop eh lidu Silpa pwe en pekehikihda. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silpa eri naitikihong Seikop pwutak emen. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lia eri nda, “I paiamwahulahr.” Ih eri kihong eden pwutako Kad. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","En Lia eh liduwo ahpw pil naitikihong Seikop nah pwutak keriemen. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lia eri nda, “Meid pai ngehi, pwe lih akan pahn kapaia ie.” Ih eri kihong eden pwutako Aser. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Eri, ni ahnsoun dolung wahn pilawa, Reupen ahpw kohla nansapw oh diarada soangen kisin tuhke me adaneki mandreik. Ih eri wadohng eh nohno Lia. Resel eri peki rehn Lia, nda, “Menlau kihdo ekis kisin mandreik sang rehn noumw serien.” ");
INSERT INTO pon2006a_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lia ahpw sapeng, nda, “Ke sohte itarki omw adihasang ie ei pwoudo, ke ahpw pil men song en kihsang en nei seriet eh mandreik kan?” Resel ahpw ndalahng, “Ma ke pahn kihdo en noumw serien eh mandreik kan, ke pahn wendi rehn Seikop pwonget.” ");
INSERT INTO pon2006a_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Eri, ni Seikop eh pwurodo sang nansapw nin soutiko, Lia ahpw kohieila oh kasamwo, oh ndahng, “Ke pahn wendi rehi pwonget, pwe I pwainkidahr en nei seriet eh mandreik ko.” Eri, Seikop ahpw wiahda reh pwongo nsenen pwopwoud. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Koht eri ketin karonge en Lia eh kapakap, ih eri liseianda oh naitikiadahng Seikop kelimmen en nah pwutak. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lia eri nda, “Koht ketin katingihkin ie ei kihong ei pwoud ei liduwo.” Ih eri kihong eden pwutako Isakar. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lia ahpw pil pwurehng liseianda oh wiahiong Seikop kewenemen en nah pwutak. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ih eri nda, “Koht ketikihong ie kisakis mwahu ieu. Eri met, ei pwoudo pahn perenki mihmi rehi, pwehki ei kihong nah pwutak wenemen.” Ih eri kihong eden pwutako Sepulon. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Mwuhr, e ahpw naitikihada serepein men, me e kihong ede Daina. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Koht pil ketin kupwukupwurehte Resel, pwe e ketin karonge eh pekipek oh kupwurehiong en kak neitik. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Resel ahpw liseianda oh naitikihada pwutak emen. Ih eri nda, “Koht ketikihsang ie kanamenekpen ei depwen. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","En pil ketikihong ie pil emen pwutaken.” Ih eri kihong eden pwutako Sosep. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Mwurin Sosep eh ipwidi, Seikop ndahng lapan, “Menlau mweidohng ie I en kohkolahng nan sapweio. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Kihdo ei pwoud kan oh nei seri kan me I papahkinuhkehr, pwe I en kohkohla. Ke ese mehlel duwen sawas me I wiahionguhkehr.” ");
INSERT INTO pon2006a_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lapan eri sapengki, “I pahn koasoia met: I eseier sang nan ei kosetipw me Koht ketin kupwuramwahwihieier pwehki kowe. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ke en kilelehdi dahme ei pweipwand ong uhk, I ahpw pahn pwainohng uhk.” ");
INSERT INTO pon2006a_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Seikop ahpw sapeng, “Ke ese duwen doadoahk me I wiahiong uhk oh duwen epwel mwahu me I wiahiong noumw mahn akan; ");
INSERT INTO pon2006a_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","mwohn ei pwarodo met re me malaulau, a met re tohtolahr mehlel, pwehki KAUN-O eh ketin kupwuramwahwihiuk sang ni ei pwarodo. Eri met e lelehr ei ahnsoun doadoahk ong ei peneinei.” ");
INSERT INTO pon2006a_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lapan eri idek reh, “A dahme I pahn katingihkin uhk?” Seikop ahpw sapeng nda, “Ke sohte pahn kihong ie mehkot, ahpw I pahn usehlahte apwahpwalih noumw mahn akan ma ke pahn mweidohng ie met: ");
INSERT INTO pon2006a_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","I en dawih noumw mahn akan koaros rahnwet oh katohrehsang sihpw poh toantoal koaros iangahki kuht mwangerenger koaros. Ihte soangen mahn pwukat me ke pahn pwainkin ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Sang met kohla, ni omw pahn kin dawih nei mahn akan; kuht men me sohte mwangerenger de sihpw men me sohte poh toantoal, ke pahn ese me I pirapahda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lapan eri nda, “Me pwung duwen me ke ndahn.” ");
INSERT INTO pon2006a_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","A rahnohte Lapan ahpw katohrehsang kuht wol alahl de mwangerenger ko oh kuht lih mwangerenger oh alahl koaros me mie mwei pwetepwet rehrail; oh sihpw toantoal koaros. E ahpw kihong rehn nah pwutak ko pwe re en apwahpwalih. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","E ahpw wahda nah pelinmeno oh kohkohla sang Seikop oh dohlahsang erein rahn siluh. Seikop ahpw apwahpwalih luhwen pelinmeno. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Seikop ahpw pelehdi lepin rahntuhke mour kei sang ni soangen tuhke kei, e ahpw tehrasang apali kilin tuhke ko pwe en kak mwomwen ahl pwetepwet. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","E ahpw kauwada lepin tuhke ko wasahn nimpil en mahn ako. E kauwada lepin tuhke pwukat wasao mwohn pelinmeno, pwe mahn ako en kin kowerek ni ahnsou me re pahn kin kolahng nimpil. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Eri, ni mahn ako ar kin kowerek limwahn lepin tuhke ko, re kin liseianda oh naitikihada kisin kuht alahl oh mwangerenger. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","A Seikop katohrehsang sihpw ko rehn kuht ko, e ahpw koasoanediong irail re en mihte mwohn nein Lapan sihpw me alahl oh poh toantoal ko. Ih eri pein apwalihada nah pelinmeno oh e sohte kin kapatahiong nein Lapan ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ni ahnsou me mahn me sohte soumwahu ko kin kowerek, Seikop kin kauwada lepin rahn tuhke ko ni wasahn nimpilo, mwohn mesen mahn ako, pwe re en kin kowerek limwahn lepin tuhke ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ahpw e sohte kin kihdi lepin tuhke ko mwohn mahn me soumwahu ko. Lapan eri kin inenehdi mahn soumwahu ko, a me kehlail ko Seikop. ");
INSERT INTO pon2006a_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ih duwen Seikop eh kepwehpwehla oh nainekihla pelinmen tohto, iangahki lidu, kamel oh ahs tohto. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Seikop esehda me nein Lapan pwutak ko koasoakoasoia dene, “Seikop kihsangehr mehkoaros me e ahneki sang rehn atail pahpao, oh e kepwehpwehkihla en atail pahpao dipwisou kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Seikop pil tehkada me mwomwen Lapan ong ih solahr duwehte mahs. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","KAUN-O eri ketin mahsanihong Seikop, “Pwurala nan sapwen omw pahpa kahlap ako, wasa ke ipwidi ieo, pwe I pahn ieiang uhk.” ");
INSERT INTO pon2006a_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Seikop eri ileklahng Resel oh Lia ira en pwarodo nansapw wasa e kin apwahpwalih ie nah pelin sihpw. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","E ahpw ndaiong ira, “I tehkadahr me mwomwen amwa pahpao ong ie solahr duwehte mahs; ahpw Koht en semeio ketin ieiangiehte. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Kumwa inenen dehdehki uwen laud en ei doadoahkohng amwa pahpao. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ahpw amwa pahpao pitihiehdi oh wekidala pak eisek pweinen ei doadoahk. Ahpw Koht sohte ketin mweidohng en wiahiong ie mehkot suwed. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ahnsou koaros me amwa pahpao kin ndahng ie, ‘Kuht mwangerenger kan pahn wia pweinen omw doadoahk,’ pelin meno unsek kin naitikihada me mwangerenger. A ni eh kin nda, ‘Kuht alahl kan pahn wia pweinen omw doaodahk,’ pelin meno unsek kin naitikihada kuht alahl. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Koht ketikihsang nein amwa pahpao pelinmen ko oh kitikihong ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Ni ahnsou mwahu en kaparmen, I auramanda me I kilenglahte kilangada duwen kuht wol kan ar kin kowerekiong kuht lih kan, re alahl oh mwangerenger. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Nan auramano tohnleng en Kohto ahpw malipe ie oh mahsanih, ‘Seikop!’ I ahpw sapeng patohwan, ‘Iet ngehi, maing.’ ");
INSERT INTO pon2006a_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ih eri mahsanih, ‘Kilang oh tehk mwahu duwen kuht wol kan ar kin kowerekih kuht lih kan, koaros alahl oh mwangerenger. I wiadahr met, pwe I kilangehr soahng koaros me Lapan wiahiong uhk. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ngehi me Koht me pwarohng uhk nan Pedel, wasa me ke keiehki takai lehn olip mehn kataman ehu oh wiahiong ie inou ehu. Eri, onopada oh kohkohla nan sahpw me ke ipwidi ieo.’” ");
INSERT INTO pon2006a_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Resel oh Lia ahpw sapeng nda, “Sohte mehkot luhwe me se pahn sohsohki sang at pahpao. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","E kin wiahkin kiht mehn liki kei. E netkinkitala oh doadoahngkihla pweinat ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Dipwisou koaros me Koht ketikihsang at pahpao uhdahn aht oh en nait seri kan. Eri kapwaiada mehkoaros me Koht mahsanihong uhk ke en wia.” ");
INSERT INTO pon2006a_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Seikop eri kaunopada mehkoaros, e kidahng nah seri ko, oh eh pwoud ko pohn kamel kei oh mwesel iangahki nah pelinmen koaros oh mehkoaros me e alehdi nan Mesopodamia, kohkolahng rehn eh pahpa Aisek nan Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Nindokon Lapan eh kolahng sehk winen nah sihpw ko, Resel ahpw kawaisang nein Lapan nah kisin mwomwen koht ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Seikop widinge Lapan ni eh sohte kehsehki me eh pahn mwesel. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Iei me Seikop tangasang Lapan wa soahng koaros me e ahneki. Mwurin e kotehla Pillap Iupreitis, e inenlahng ni wasa nahnahn Kilead. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Mwurin rahn siluh, Lapan ahpw rongada me Seikop tangehr. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","E mwadangete pwakihala iangahki kiseh ko oh mwurin rahn isuh e ahpw koanoahdi Seikop ni sahpw nahnahn Kilead. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ahpw nipwongo Koht ketin sansalohng Lapan nan auraman ehu oh mahsanihong, “Kaleke ke wiahiong Seikop mehkot suwed.” ");
INSERT INTO pon2006a_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Seikop koasoanedier imwe impwal ko pohn nahna ehu. Lapan oh kiseh ko ahpw uhd kauwada imwarail impwal ko nan wasa nahnahn Kilead. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Lapan ahpw ndahng Seikop, “Dahme ke widingehkin ie oh tangahkihsang nei serepein kan likamw aramas en poar mour kei? ");
INSERT INTO pon2006a_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Dahme ke widingehkin ie oh tangdoaui sohte padahkihong ie, pwe I en iang uhk kohdo oh kokoul en peren kesekesengki dampwurin oh arp? ");
INSERT INTO pon2006a_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ke sohte mweidohng ie I en kamwurimwuriong oh metik nei serepein kan oh neirail seri kan. Tiahk sakanakan ehu me ke wiadahr! ");
INSERT INTO pon2006a_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","I kakete wiahiong uhk mehkot suwed, ahpw Koht en semomwo mahsanihong ie pwohng, ‘Kaleke ke wiahiong Seikop mehkot suwed.’ ");
INSERT INTO pon2006a_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","I ese me ke men samwewohngehr rehn omw peneinei pwehki omw loaleidkiniraildahr, a dahme ke pirapasangki nei kisin mwomwen koht ko?” ");
INSERT INTO pon2006a_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Seikop ahpw sapeng nda, “I wiadahr met, pwehki ei perki ke de adihasang ie noumw serepein kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ahpw nin duwen pirapasang en noumw koht kan me ke kekeinakin ie, en kamakamala mwohtail koaros ihs me pahn dierekda kolokol noumw kisin koht ko, kisehtail kan me mihmi met re en wia sounkadehde en ire wet. Ma ke diarada mehkot met me uhdahn ahmw, a ale oh wahda.” Seikop sasairki me Resel me kawaisang nein Lapan kisin mwomwen koht ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lapan eri pedolong nan impwal en Seikop oh impwal en Lia pwehn rapahki kisin mwomwen koht ko oh pil nan impwal en lidu riemeno; ahpw e sohte diarada kisin mwomwen koht ko. E ahpw pedoisang mwo kohla nan en Resel. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","A Resel ahpw ale kisin mwomwen koht ko, oh ekihla pahn mehn mwomwohd en kamelo oh mwohdala powe. Lapan eri rapahkiseli nan impwal en Resel e ahpw sohte diar. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Resel ndalahng eh pahpao, “Maing, komw en kupwur mahk oh dehr suwedki ei sohte kak patohda mwohn sihlangomwi; pwe I patohwan wiewia met ei soumwahu en lih,” Lapan eri raparapahkiseli oh sohte diar kisin mwomwen koht ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Seikop eri lingeringerda oh ndalahng Lapan, “Sapwung dah de dihp dah me I wiahda, pwe ke en pwakihiehdo, oh ");
INSERT INTO pon2006a_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","sarepseli ei kepwe kan koaros? Dahme ke diarada me uhdahn ahmw sang ni ei kepwe kan? Ma mie mehkot ke diarada, a pwilikihdi met mwohn kisehta kan oh irail en wia sounkopwung nanpwungata. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Erein sounpar rieisek me I mihmihki rehmw, noumw sihpw lih kan oh kuht kan so mwahn emen iohla; I so mwahn kangasang mehmen sang rehn noumw pelin sihpw. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","I sohte mwahn wadohng uhk mahn emen me mahn lawalo kan kin kemehla; I kin pein kapwungala sapwung kan oh mehkoaros me kin wiawihong pelinmen ko sang ni pirap en nipwong de nin rahn. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ni rahn I kin mwasingkihla karakar uk en ketipin oh nipwong I kin kereniong mehkihla lemwulemwur en keteu, oh I sohte kak meirki. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Sang nan sounpar rieisek me I doadoahkohng uhk, sounpar eisek pahieu I lidiliduwihiuk pwehki noumw serepein riemenen oh sounpar weneu pwehki noumw pelinmen kan. Komwi ahpw wekidala pak eisek pweinen ei doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ma Koht en semei ko, Koht en Eipraam oh Aisek, sohte ketin kupwure ie, ele ke kasareielahr sohte wa mehkot. Ahpw Koht ketin mwahngihada ei apwal oh wahn ei doadoahk, ihme e ketin kapwungki ong uhk pwohng.” ");
INSERT INTO pon2006a_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lapan ahpw sapeng Seikop nda, “Uhdahn nei serepein kan iangahki neirail seri kan, oh pelinmen kan pil uhdahn nei. Mehlel, mehkoaros me ke kilang wasaht uhdahn ahi. Ahpw I sohte kak kolokol serepein pwukat oh nair seri kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Eri, kita pahn wiahda inou ehu nanpwungata. Kita koasoakehda ekei takai pwe en wia mehn kataman en ata inou.” ");
INSERT INTO pon2006a_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Seikop eri ale takai ehu oh kauwada mehn kataman. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","E ahpw ndaiong kiseh ko re en rikpene ekei takai oh koasoakehda. Irail eri tungoal limwahn koasoakoasoako. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lapan eri kihong eden wasao Sekar Saaduda, a Seikop kahdaneki Kaleed. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lapan eri ndahng Seikop, “Pehs wet pahn wia mehn kataman nanpwungata.” Ihme wasao adanekihki Kaleed. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Lapan pil nda, “KAUN-O en ketin sinsile nanpwungata, ni ata pahn tohrohrpeseng.” Eri wasao pil adanekihla Mispa. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Lapan ahpw pil nda, “Ma ke wiakauwe nei serepein kan de pwoudikihda ekei lih tohrohr, mehnda ma I sohte ese met, a ke en tamataman me Koht me pahn ketin mwahngih kita. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Iet takai pwukat me I koasoakedahr nanpwungata, oh takai wet pahn wia mehn kataman. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Koasoakoasoak en takai pwukat oh takai en kataman wet pahn wia mehn kataman ehu. I sohte pahn kotehwei koasoakoasoak wet pwe I en uhwong uhk, oh ke sohte pahn kotehdo takai en kataman wet pwe ke en uhwong ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Koht en Eipraam oh Koht en Nahor me pahn wia sounkopwung en nanpwungata.” Seikop eri kahukihla ni mwaren Kohto me seme Aisek kin kaudokiong, me e pahn kapwaiada inou wet. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ih eri kemehla mahn emen oh meirongkihla pohn nahnao oh luhkeiong kiseh ko pwe re en iang tungoal reh. Mwurin ar tungoal, re ahpw pweidi pohn nahnao. ");
INSERT INTO pon2006a_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Lapan eri pwourda nin sohrahnie, kamwurimwuriong irail, metik nah serepein ko oh neira pwutak ko, oh mwesel kohkolahng nan sapweo. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Nindokon Seikop eh wiewia eh seiloak, tohnleng en Koht kei ahpw tuhwong. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Eri, ni eh kilangirailda eh ahpw patohwan, “Iet karis en Koht kei.” E ahpw kihong eden wasao Mahanaim. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Seikop eri kadarala mwowe meninkeder kei rehn rie Esau nan wehin Edom. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","E kehkehlingkihong meninkeder ko re en ndaiong Esau, “Iet ngehi, Seikop, sapwellimomwi ladu, me patohwan pakairkiwohng ei kaun Esau duwen ei keikeiruier rehn Lapan oh mihmihte reh lel rahnwet. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mie rehi nei pelin kou, pelin ahs, pelin sihpw oh kuht, oh pil kiden lidu ohl oh lih. I patohwanowohng komwi, maing, pakair wet, pwe I en diar kalahngan pahn kupwuromwi.” ");
INSERT INTO pon2006a_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Meninkeder ko pwurodo rehn Seikop oh patohwanohng, “Se patohla rehn riomwi Esau, ahpw iet e ketiket kohdo rehmwi iangahki aramas 400.” ");
INSERT INTO pon2006a_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Seikop eri masepwehkada kowahlap, oh nehkpeseng aramas me mihmi reh ko, oh pil nah pelin sihpw oh kuht, pelin kou oh kamel ko, wiahkihda pwihn riau. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","E ahpw mengimengloalki, “Ma Esau pahn peiong ehu pwihn, a pwihn teio kakete pitlahsang.” ");
INSERT INTO pon2006a_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Seikop eri kapakap, patohwan, “Maing Koht en semei Eipraam, Koht en semei Aisek, komw ketin karong ie! Maing KAUN, komw ketin mahsanihongieier, ‘Pwurowei nan sapwomw rehn kisehmw kan, I ahpw pahn kupwuramwahwihiuk.’ ");
INSERT INTO pon2006a_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","I sohte warohng kalahngan koaros oh loalopwoat poatopoat me komw ketin kupwurehki sapwellimomwi ladu menet. I kotelahr Pillap Sordan sohte wa mehkot ihte sokon pwoat, a met I pwurodohr kahre pwihn riau wet. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Komw ketin doareiesang ni manaman en riei Esau. I perki ni eh patopatohdo pwe ede uhwong kiht oh kauweikitala koaros, iangahki lih akan oh pil seri kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Komw kupwukupwure sapwellimomwi inowo me mahsanih, ‘I pahn kupwuramwhwihiuk pwe mehkoaros en pweida rehmw, oh I pahn kihong uhk kadaudokomw ngedehrie me soh kak wadawad. Re pahn tohto duwehte pihken ni oaroahr akan.’” ");
INSERT INTO pon2006a_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Eri, mwurin eh pweidi wasao nipwongo, e pilada sang nan dipwisou ko me mihmi reh kisakis me e pahn kihong rie Esau. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Eri, iet kan: kuht lih 200 oh kuht wol 20, sihpw lih 200 oh sihpw wol 20, ");
INSERT INTO pon2006a_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kamel lih me apwtehn neitik 30 iangahki wahrail kan, kou lih 40 oh kouwol 10, ahs lih 20 oh ahs wol 10. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","E ahpw nehkpeseng pelinmen pwukat rehn ladu kei, oh ndaiong irail, “Kumwail tiengwei mwohi, oh dehr kapatapene pelinmen kan, ahpw irepeseng ehute soangen mahn ekis wasa. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","E ahpw pil kehkehlingkihong ladu me tiengo, “Ni omw pahn tuhwong riei Esau oh eh pahn idek rehmw, ‘Ihs me omw soumas? Ke pahn mi ia? Nein ihs mahn pwukat me ke kahkahre? ");
INSERT INTO pon2006a_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ke pahn sapengki, ‘En sapwellimomwi ladu Seikop eh tungoal mahn pwukat. Eh tungoal kisakis me e patohwan kadarodohng komwi, maing. Pein ih patopato kohdo mwurit.’” ");
INSERT INTO pon2006a_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","E ahpw pil wiahiong soangen kehkehlikohte ong keriemen, oh pil kesilimen, oh koaros me idihdawehn pelinmen ko, e ndaiong irail, “Ih soangen pato wette me kumwail pahn patohwanohng Esau, ni amwail pahn tuhwong. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kumwail pil pahn ndahng, ‘Ei, sapwellimomwi ladu Seikop patopatohdo mwurit.’” Seikop ahpw mengimengloalki, “I pahn kameleileikihdi Esau kisakis pwukat me pahn tiengla mwohi, oh ni ei pahn tuhwong, ele e pahn kadekohng ie oh mahkohng ie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kisakis ko eri pekederla mwowe, a ih e pweidi nipwongo nan imwe impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Nipwongohte Seikop pwourda oh ale eh pwoud riemeno, eh lih lidu riemeno, oh nah seri 11 ko oh kotehla Pillap Sappok. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Mwurin eh kadarihralahr, e ahpw pil kadarala eh kepwe ko koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ih eri kelekelepw wasao. A iet ohl emen ahpw pwarohng oh poadoarohng lao lel nin sohrahn. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ni ohlo eh pehmada me e sohte kak kesehdi, e poakih pwonen Seikopo. Eri, pwonen Seikopo ahpw piselpeseng. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ohlo ahpw nda, “Eri, pweisang ie, pwe wasa rahnehr.” A Seikop sapeng, nda, “I sohte pahn pweisang uhk, ke lao pahn kapaiaiehda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ohlo ahpw idek reh, “Ia edomw?” Seikop ahpw sapeng, “Seikop.” ");
INSERT INTO pon2006a_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ohlo ahpw ndahng, “Ke solahr pahn adaneki Seikop. Pwe ke poadoarongehr Koht oh aramas akan, ke ahpw powedier. Eri, ke pahn adanekilahr Israel.” ");
INSERT INTO pon2006a_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Seikop ahpw idek, “A komwi, ia mwaromwi?” A e sapeng, “Dahme ke idengki mwarei?” Ih eri kapaiahda Seikop wasao. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Seikop eri kihong eden wasao Peniel oh ketihtihki, “I kilangehr Koht ni uhdahn silangi, ahpw iet I momourte.” ");
INSERT INTO pon2006a_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Eri, ni eh mweselsang Peniel, ketipin ahpw dakerada, ih eri alu pelingek kohkohla pwehki pwoneo eh piselpesengehr. ");
INSERT INTO pon2006a_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ih kahrepen kadaudok en Israel kan ar sohte tungoale uduk me kin mi ni pwonen mahn, pwehki ih wasa me ohlo poakihdi rehn Seikop. ");
INSERT INTO pon2006a_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Seikop ahpw kilenglahte kilangada Esau eh kohkohdo iangahki ohl pahpwiki. Ih eri nehkpeseng nah seri ko nanpwungen Lia, Resel oh eh pekehi lih riemeno. ");
INSERT INTO pon2006a_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","E ahpw koasoanehdi mwohrail eh pekehi riemeno iangahki neira seri ko, mwuri Lia oh nah seri ko, a Resel oh Sosep me keieu mwuhr. ");
INSERT INTO pon2006a_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Seikop ahpw tiengla mwohrail oh poaridiong nanpwel pak isuh, ni ahnsou me rieo leledo. ");
INSERT INTO pon2006a_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau tangalahte pwoalehdi oh metik, ira koaros eri sengiseng. ");
INSERT INTO pon2006a_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ni Esau eh sarada oh kilangada lih ako oh seri ko, e ahpw idek, “Ihs aramas pwukat me ianguhket?” Seikop ahpw sapeng, “Maing, ih ei tungoal seri kan me Koht ketin kupwurehkin ie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Pekehi ko oh neira seri ko ahpw aluhdo oh rahnmwahwih oh poaridi mwowe; ");
INSERT INTO pon2006a_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","mwuri Lia oh nah ko pil aluhdahdo rahnmwahwih oh poaridi, Resel oh Sosep me aluhdahdo keieu mwuhr, ira ahpw rahnmwahwih oh pil poaridi. ");
INSERT INTO pon2006a_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau ahpw idek, “A ia wehwehn pwihn me I tuhwongo?” Seikop ahpw sapeng, “Maing, pwe I en diar kuwpuramwahu rehmwi.” ");
INSERT INTO pon2006a_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esau ahpw nda, “Itar kepwe kan me I ahneki; kolokolete mehkan me uhdahn ahmw.” ");
INSERT INTO pon2006a_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Seikop eri patohwan, “So maing, ma komw kupwureielahr, a komw ketikihda kisakis wet. Pwe ei pato pahn silangmwi rasehng ei pato pahn silangin Koht, pwehki omwi nohn kadekohng ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Komw ketikihda kisakis wet me I patohwandohng komwi; Koht ketin kupwurkalahngan ong ie oh ketikihong ie soahng koaros me I anahne.” Seikop eri wie ngidingidkihong eh lao ale dipwisou ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau eri nda, “Eri me mwahu, kitail onopada mwesel. I pahn tiengla mahs.” ");
INSERT INTO pon2006a_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","A Seikop sapengki, “Duwen omwi mahsanih, seri pwelel kat me luwet, oh pil mie pelin sihpw kei oh kou kei iangahki wahrail kan. Ma re pahn pakahrwei ni karuaru, pelinmen ko koaros pahn mehla. ");
INSERT INTO pon2006a_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Komw tiengwei, I ahpw pahn wawai kohwei ieiang mwekid en pelinmen kan oh seri kan, I lao lel rehmwi nan Edom.” ");
INSERT INTO pon2006a_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau ahpw nda, “Eri mweidohng ie I en kihdi ekei nei ohl ako pwe re en ianguhk.” Seikop ahpw sapeng, patohwan, “Komw dehr kupwurohki men, ihte I men komwi en kupwureiehla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Eri ni rahnohte Esau pwuralahng Edom. ");
INSERT INTO pon2006a_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Seikop ahpw kohla Sukot, wasa e kauwada ie imwe ihmw ehu oh impwal kei ong nah pelinmen ko. Ih kahrepen wasao e adanekihla Sukot. ");
INSERT INTO pon2006a_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ni Seikop eh pwurodohsang Mesopodamia, e sohte diar apwal ehu ih lao lel nan kahnimw en Sekem nan Kenan, e ahpw kauwada imwe imwpal ko nan mohs ehu limwahn kahnimwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","E pwainsang sahpwo rehn kisehn kadaudok en Amor ko, semen Sekem, ni uwen silper epwiki. ");
INSERT INTO pon2006a_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","E ahpw kauwada pei sarawi ehu wasao, oh kihong eden wasao El, Koht en Israel. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Rahn ehu Daina, nein Lia serepein ong Seikop, ahpw mwemweitla rehn lihen Kenan kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sekem, nein Amor mehn Ip, kaunen wasao, e kilangete Daina oh mwahukihda, e ahpw angkehlailiong. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","E ahpw kilangada uwen kaselel en serepeino, ihme kahrehda e inenen poakepoakehla oh song en kansenamwahwihala. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","E ahpw ndaiong eh pahpao, “Menlao pekihda serepein menet ei pwoud.” ");
INSERT INTO pon2006a_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Seikop eri rongada duwen nah serepeino eh adsuwedlahr, e ahpw sohte wia mehkot pwehki nah pwutak ko ar mihmi nansapw, apwahpwalih nair pelinmen ko, e sohte mwahn mweseiseiki, re lao pwurodo sang nansapw. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Amor, semen Sekem, ahpw kohla rehn Seikop pwe ira en koasoia duwen ire wet, ");
INSERT INTO pon2006a_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ni ahnsowo nein Seikop pwutak ko pa lelodo sang nansapwo. Ni ar rongada ire wet, re inenen pwuriamweikihla oh lingeringerkihda kowahlap, pwehki Sekem eh wiadahr soangen tiahk wet oh kanamenekilahr aramas en Israel kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Amor eri ndaiong Seikop, “Ei tungoal pwutako, Sekem, men pwoudiki sapwellimomwi serepeinen; komw kupwurehla oh ketikihong pwe en pwoudikihda. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kitail inoukipene en kapwopwoudipene neitail kan, kumwail mweidodohng kiht noumwail kan, a kiht se pahn uhd mweidohng kumwail nait kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Pwe kumwail en kak iang kousoanla nan sahpwet; kumwail kak kousoan wasa kan me kumwail anahne, oh iang wie netinetseli ni saledek, oh uhdahn sapwenikihla sahpw akan me kumwail kousoan loale. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekem eri ndaiong semen Daina oh rie ko, “Kumwail kupwurehla ei pekipek, I ahpw pahn patohwanohng kumwail soahng koaros me kumwail anahne. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Kumwail kilelehdi uwen pweinen serepeinen, oh soangen kisakis me kumwail anahne, pwe I pahn kihong kumwail soahng koaros me kumwail pahn peki, ma kumwail pahn mweidohng ie I en pwoudiki serepeinen.” ");
INSERT INTO pon2006a_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Nein Seikop pwutak ko ahpw wiahiong Sekem oh eh pahpao pasapeng widing ehu, pwehki ar lingeringerki riarail serepeino eh adsuwedlahr. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Irail eri nda, “Se sohte kak mweidohng riat serepeinet en pwoudiki aramas me sohte sirkumsais; pwe mehkot kanamenek reht soahngen. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ihte se pahn pwungki ma ohl koaros rehmwail pahn sirkumsaisla. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Eri kitail ahpw pahn kihpene neitail kan re en pwopwoudpene. Se pahn mihla rehmwail oh wiahla kisehmwail. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ahpw ma kumwail sohte pwungki at koasoandi duwen sirkumsaisla, eri, se pahn wahda serepeinet oh kohkohla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Amor oh nah pwutako, Sekem, ahpw pwungki koasoandi wet. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Pwutako eri mwadangete kapwaiada dahme re koasoanehdio, pwehki eh limpoakohng mehlel nein Seikop serepeino. Pwutaket me keieu wahu nan eh peneinei. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Amor oh nah pwutak Sekem eri kohla wasahn tuhpene en kahnimwo oh padahkihong aramas ako: ");
INSERT INTO pon2006a_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Aramas pwukat me kadek; kumwail mweidohng re en kousoanla rehtail oh seiloakseli ni saledek. Pwe sahpwet me laud oh itar irail en iang kousoan loale. Kitail kihong irail neitail serepein kan pwe re en pwoudiki, oh re pahn pil kihong kitail en pwoudiki neirail kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ahpw aramas pwukat pahn pwungki mihla rehtail oh wiahla kisehtail, ma ohl koaros rehtail pahn sirkumsaisla duwehte irail. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Eri, kitail sou pahn pil ahnekihla ar kepwe kan oh nair pelimen kan? Eri kitail mweidohng re en mihla rehtail.” ");
INSERT INTO pon2006a_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Eri ohl koaros en kahnimwo ahpw pwungkihda dahme Amor oh nah pwutak Sekem ndahng irail, ohl koaros en kahnimwo ahpw sirkumsaisla. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Eri mwurin rahn siluh, nindokon ohl ako ar weiweirengki ar sirkumsaiso, riemen nein Seikop pwutak ko, rien Daina ko, Simion oh Lipai, ira ahpw ale neira kedlahs oh waila kemehla ohl koaros en kahnimwo, ");
INSERT INTO pon2006a_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","iangahki Amor oh nah pwutak Sekem. Ira eri wahsang Daina nan imwen Sekemo oh kohkohla. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Mwurin ara kemehla ohl ako, nein Seikop pwutak teiko pedolong oh kauwehla kahnimwo, dupuken ar kadsuwedihala riarail serepeino. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Re pil wahsang mahn ako, sihpw, kou, ahs, oh mehkoaros me mi nan kahnimwo oh nansapw. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Re wahsang kepwe kesempwal koaros, iangahki lih oh seri koaros oh dipwisoun nan ihmw koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Seikop ahpw ndaiong Simion oh Lipai, “Kumwail kahrehiongieier nan apwal laud ehu; mehn Kenan oh Peris, iangahki koaros tohn sahpwet pahn kailongkiniela. Nei ohl akan me malaulau; ma re pahn ehupene oh mahweniong ie, atail peneinei pwon pahn mwomwla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","A re sapengki, “Se sohte kak mweidohng re en wiahkihla riato lih me kin netiki paliwere.” ");
INSERT INTO pon2006a_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Koht ketin mahsanihong Seikop, “Kohdawei Pedel met, oh kousoanla wasao. Kauwada ehu pei sarawi ong ie, ong Koht me pwarohng uhk ni ahnsou me ke tangatangasang riomw Esau.” ");
INSERT INTO pon2006a_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Seikop eri ndahng eh peneinei oh irail koaros me ieiang ih, “Kumwail kesehla koht en liki kan koaros me mihmi rehmwail; kumwail eri kamwakeleikumwailda oh pwuhriong nan likou mwakelekel. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Pwe kitail pahn kohdahla Pedel met, oh I pahn kauwada wasao pei sarawi ehu ong Koht me ketin karonge ie nan ei apwal oh ketin ieiang ie nan ei seiloak.” ");
INSERT INTO pon2006a_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Irail eri kihong Seikop koht en liki koaros me re kolokol oh mentiati koaros me mi ni salengarail kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ni Seikop oh nah pwutak ko ar mweselda, lemmwin Koht ahpw kipehdi kahnimw koaros me kapilirailpene, me kahrehda sohte emen pwakihirailla. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Seikop oh aramas koaros me ieiang ih ahpw lel Lus, me ahnsou wet adaneki Pedel, nan wehin Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","E kauwada pei sarawi ehu wasao oh kihong ede Pedel, pwe iei wasao me Koht ketin sansalohng ih nindokon eh tangatangasang rieo. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Depora, lih me kin apwahpwalih Repeka, eri mehla oh seridi pahn tuhke ohk pwoat pahnengin Pedel. Iei me tuhkeo adanekihki “Ohk en Mwahiei.” ");
INSERT INTO pon2006a_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ni Seikop eh pwurodohsang sang Mesopodamia, Koht ketin pwurehng pwarohng oh kupwuramwahwih. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Koht ahpw mahsanihong, “Sang met kohla ke solahr pahn adaneki Seikop, ahpw ke pahn adanekilahr Israel.” Ih eri adanekihla Israel. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Koht pil mahsanihong, “Ngehi Koht Wasa Lapalap. Noumw seri en ngederla. Wehi tohtohie pahn pwilisang rehmw oh nanmwarki kei pahn ipwisang rehmw. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Sahpw me I kihongehr Eipraam oh Aisek, I pahn uhd kihong uhk oh kadaudokomw kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Koht eri ketin sohrala sang reh. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Seikop eri kauwada pei sarawi ehu mehn kataman, wasa me Koht ketin mahseniong ih, oh e ahpw kasarawihala ni eh wudekihdiong powe wain oh lehn olip. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","E ahpw kihong eden wasao Pedel. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Seikop oh eh peneinei ahpw mweselsang wasao kohkolahng Eprat. Ni ar kohkohla nanialo Resel ahpw lelehr eh ahnsoun neitik, e ahpw medekda oh mihla nan apwal en neitik. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ni eh medeko eh uklahr mehlel, sounkaneitiko ahpw ndaiong, “Ke dehr masak pwe pil emen pwutak men.” ");
INSERT INTO pon2006a_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ahpw ni eh pahn melahr, e ahpw kihong eden nah pwutako Penoni, a eh pahpao kihong ede Pensamin. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Resel eri mehla oh seridi limwahn ahl en kolahng Eprat, me ahnsou wet adaneki Pedleem. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Seikop eri kauwada mehn kataman ehu pohn eh sousowo; oh iei kilel en mehn kataman wet me mihmihte lel rahnwet. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Seikop ahpw douluhlla oh kauwada imwe impwal ko palilahsang kengkeng en Eder. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Nindokon Seikop eh koukousoan wasao, Reupen kohla oh wiahiong nsenen pwopwoud rehn Pila, emen en eh pahpao eh pekehi ko. Ahnsou me Seikop rongada met, e inenen lingeringerkihda mehlel. Seikop naineki pwutak ehk riemen. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Nein Lia pwutak kan iei Reupen (nein Seikop pwutak mesenih), Simion, Lipai, Suda, Isakar, oh Sepulon. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Nein Resel pwutak kan iei Sosep oh Pensamin. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Pila, nein Resel liduwo me naitikihada Dan oh Napdali. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Silpa, nein Lia liduwo me naitikihada Kad oh Aser. Pwutak pwukat ipwidi nan Mesopodamia. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Seikop eri kohkohla rehn eh pahpa Aisek nan Mamre, limwahn Epron, wasa me Eipraam oh Aisek kin kousoan ie mahs. ");
INSERT INTO pon2006a_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisek momourki sounpar 180, ");
INSERT INTO pon2006a_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","e ahpw mehla ni eh ohl laud mehlel; nah pwutak ko Esau oh Seikop ahpw sarepedi ih. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iet kadaudok en Esau kan, me pil kin adaneki Edom. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau pwoudikihda lihen Kenan kei: Ada, nein Elon mehn Id; Olipama, nein Anah serepein, Anah nein Sipeon mehn Id; ");
INSERT INTO pon2006a_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","oh Pasemad, nein Ismael serepein oh rien Nepaiod. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada naitikihada Elipas; Pasemad naitikihada Reuel; ");
INSERT INTO pon2006a_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","oh Olipama naitikihada Seus, Salam, oh Kora. Pwutak pwukat koaros ipwidiong Esau nan Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau eri ale eh pwoud ko, nah pwutak ko oh serepein ko, oh tohn imwe koaros, iangahki nah mahn koaros oh mehkoaros me e ahneki nan Kenan oh kohkohla sang rehn rie Seikop, kohkolahng nan sahpw tohrohr ehu. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","E kohkohla sang wasao pwehki sahpwo me ih oh Seikop koukousoan loale sohte itar pwehn komokomour irail koaros; re naineki mahn tohto oh re solahr kak mihmipene. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esau eri kousoanla nan sahpw ileile nan Edom. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ih met kadaudok en Esau kan, pahpa kahlap en mehn Edom kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Ada, en Esau eh pwoud, naitikihada pwutak emen, ede Elipas, oh Elipas naineki pwutak limmen: Teman, Omar, Sepo, Katam, oh Kenas, oh sang emen lih torohr, Timna, pil emen pwutak, Amalek. En Esau eh pwoud Pasemad naitikihada pwutak emen ede Reuel, oh Reuel naineki pwutak pahmen: Nahad, Sera, Samma, oh Mihsa. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","En Esau eh pwoud Olipama, nein Anah serepein rien Sipeon, naitikihada pwutak silimen: Seus, Salam, oh Kora. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ih met kan kadaudok en Esau. Nein Esau mesenih pwutak Elipas iei pahpa kahlap en kadaudok pwukat: Teman, Omar, Sepo, Kenas, ");
INSERT INTO pon2006a_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Katam, oh Amalek. Irail pwukat koaros iei kadaudok en Esau eh pwoud Ada. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Nein Esau pwutak Reuel ih me pahpa kahlap en kadaudok pwukat: Nahad, Sera, Samma oh Mihsa. Irail pwukat koaros iei kisehn kadaudok en Esau eh pwoud Pasemad. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Kadaudok en Olipama en Esau eh pwoud, nein Anah serepein, iei kadaudok pwukat: Seus, Salam, oh Kora. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Kadaudok pwukat koaros iei kadaudok en Esau. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Pwilidak en Edom pwalpeseng wiahda kadaudok kei me tepidohsang Seir, mehn Hor: Lotan, Sopal, Sipeon, Anah, Dihson, Eser, oh Dihsan. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan me pahpa kahlap en peneineien Ori oh Eman. (Mie rien Lotan serepein men adaneki Timna.) ");
INSERT INTO pon2006a_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sopal iei pahpa kahlap en peneineien Alpan, Manaad, Epal, Sehpo, oh Onam. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sipeon naineki pwutak riemen: Aiah oh Anah. (Ih Anaho me diarada pwarer me karakar ko nan sapwtehn ni eh apwahpwalih nein eh pahpao ahs ako.) ");
INSERT INTO pon2006a_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Anah me wia semen Dihson, me wia pahpa kahlap en peneineien Emdan, Espan, Idran, oh Seran. Anah me pil naineki serepein me adaneki Olipama. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser wia pahpa kahlap en peneineien Pilan, Sapan, oh Akan. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dihsan wia pahpa kahlap en peneineien en Us oh Aran. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Ih met kan kadaudok en mehn Hor nan Edom: Lotan, Sopal, Sipeon, Anah, Dihson, Eser, oh Dihsan. ");
INSERT INTO pon2006a_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","39","Mwohn eh saikinte miehla nanmwarki nan Israel, nanmwarki pwukat iei irail me kaunda Edom: Pela nein Peor sang Dinapa Sosap nein Sera sang Posra Usam sang Teman Adad nein Pedad sang Apid (e kalwehdi mehn Midian kan nan mahwen ehu nan Mohap) Samla sang Masreka Saul sang Rehopod-limwan-pillapo Paal Anan nein Akpor Adad sang Pau (eh pwoud iei Methapel, nein Madred oh nein Mehsap serepein) ");
INSERT INTO pon2006a_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Esau wia pahpa kahlap en kadaudok en mehn Edom pwukat: Timna, Alpa, Seded, Olipama, Elah, Pinon, Kenas, Teman, Mipsar, Makdiel, oh Iram. Wasa kan me ehuehu kadaudok pwukat kousoanla ie kin adaneki eden kadaudoko. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Eri, Seikop ahpw usehlahte eh keikeiru nan Kenan, wasa me eh pahpao kin kousoan ie mahs. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Eri, iet duwen poadopoad en eh peneinei. Sosep, pwutak pwulopwul men me mahkiher sounpar eisek isuh oh kin iang rie ko, nein Pila oh Silpa en eh pahpao eh pekehi ko, apwahpwalih nair pelin sihpw oh pelin kuht kan. E ahpw kedipairailda rehn ar pahpao duwen mehkot sapwung me re wiahda. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Sosep inenen soisoi pahn Seikop sang rie teiko koaros, pwehki eh ipwidi ni eh pahpao eh ohl laudlahr. Seikop eri wiahiong Sosep eh likou reirei me kaselel oh peh reirei. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ni rie ko ar tehkada duwen ar pahpao e kesempwaliki kowahlap Sosep sang irail koaros, re kailongkihla mehlel, oh solahr men lokaia mwahu ong. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Kedekedeo, Sosep ahpw wiahda ouraman ehu, e ahpw koasoiaiong rie ko duwe. Met ahpw kahrehiong ar inenen kailongkihla. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","E ndaiong irail, “Kumwail rong mahs duwen me I ouramandahro. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Dene kitail koaros mihmi nansapw piripirepene kapakap en pilawa kei; a iet ei kapakapo pa kesihnenda, a amwail ko kapilpene ahio oh poaridi mwowe.” ");
INSERT INTO pon2006a_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Rie ko ahpw idek reh, “Ke lemeleme me ke pahn wiahla at nanmwarki, de ke pahn kaunkitada?” Ar kailongki ahpw ukla mehlel, pwehki eh ouramano. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Sosep pil pwurehng ouraman, oh ndaiong rie ko, “I pil pwurehng ouraman oh kilangada duwen ketipin, maram, oh usu eisek ehu ar poaridi mwohi.” ");
INSERT INTO pon2006a_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","E ahpw pil ndaiong eh pahpao duwen ouramano, eh pahpao eri lupwoarehda, ndaiong, “Ia duwe? Pwehki omw ouraman, ke lemeleme me omw nohno, riomw kan, oh pil ngehi, se pahn poaridi mwohmw?” ");
INSERT INTO pon2006a_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Rien Sosep ko ahpw kin peipeiriniong, a eh pahpao ahpw kin medemedewe irair wet. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Rien Sosep ko eri kohla likin Sekem pwe re en sinsile nein ar pahpao pelin mahn kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Seikop eri ndaiong Sosep, “I men ke en kohla Sekem, wasa me riomw ko kin apwahpwalih pelinmen ko.” Sosep ahpw sapeng, “Iet ngehi, I onopadahr.” ");
INSERT INTO pon2006a_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Eh pahpao eri ndahng, “Eri, kohwei oh kilang ia iren riomw ko, oh ia iren mahn akan. Ke ahpw pwurodo oh pakairkihong ie.” Semeo eri kadarala Sosep sang nan Wahun Epron. Ni Sosep eh lel Sekem, ");
INSERT INTO pon2006a_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ohl emen ahpw tuhwong ni eh kohkohseli nansapw, e ahpw idek reh, “Dahme ke raparapahki?” ");
INSERT INTO pon2006a_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Sosep ahpw sapeng, “I raparapahki riei ko. Ia wasa re kin apwahpwalih ie nait pelinmen ko?” ");
INSERT INTO pon2006a_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ohlo ahpw nda, “Re apwtehn mweselsang met. I mwur rong ar ndinda me re pahn kohla Dodan.” Sosep eri douluhlla raparapahki rie ko, e ahpw diarihrada Dodan. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Rie ko eri kilangada eh kohkohdo dohsang irail, oh mwohn eh kerendohng irail re inoukihda re en kemehla. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Re ndapene nanpwungarail, “Ien sounouramano, e kohkohdo. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Nna, kitail kemehla oh kesehdiong nan ehu pwareren. Kitail nek nda me mahn lawalo me kangala. Kitail ahpw pahn kilang da katepen eh ouraman kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Reupen rongada arail koasoio, e ahpw song en kapitasang Sosep rehrail. Ih eri ndahng irail, “Kitail dehr kakerehdi nta. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kumwail dehr kemehla. Kumwail kesehdiongete nan ehu pwareren nan sapwtehnet, ieremen kauwehla paliwere.” E ndaiong irail met pwe e men kapitasang Sosep rehrail oh kapwurelahng rehn eh pahpao. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ni Sosep eh lel rehn rie ko, re kapwuhrasang eh likou reireio; ");
INSERT INTO pon2006a_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","oh koledi kesehdiong nan pwoahr madekeng ehu. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Nindokon ar mwengemwenge, re kilenglahte kilangada mehn Ismael kei me seiseiloaksang Kilead. Neirail kamel kan wa diren kepwe kesempwal kei, me re weuwa kolahng Isip. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Suda eri ndaiong rie ko, “Dah katepehiong kitail, ma kitail kemehla riatailo oh ekihla eh mehla? ");
INSERT INTO pon2006a_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kitail netikihla rehn mehn Ismael pwukat, oh dehr wiahiong paliwere mehkot suwed; pwe ih pil riatail, kisehn udukatail oh ntahtail.” Rie ko eri pwungkihda. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Eri, ni sounnet en Midian kei ar keid wasao, pirieno ahpw apihadahsang Sosep nan pwoahro oh netikihong mehn Ismael ko ni mwohni silper 20. Mehn Ismael ko eri walahng Sosep Isip. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ni Reupen eh pwuralahng ni pwoahro oh diarada me Sosep solahr mi loale, e tehrasang eh likou ko uwen eh nsensuwedla. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ih eri pwurala rehn rie ko, oh ndahng irail, “Pwutako solahr mi wasao! Dahme I pahn wia?” ");
INSERT INTO pon2006a_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Irail eri kemehla kuht men, re ahpw ale en Sosep eh likou reireio oh kaduhdi nan ntahn kuhto. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Re ahpw walahng ar pahpao, nda, “Se diar likou wet. Kilang ma kaidehn en noumw pwutako?” ");
INSERT INTO pon2006a_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Seikop kadehdehte me iei, e ahpw nda, “En nei pwutako eh likowo met! Mahn lawalo me kemehla; mahn kommwad me kangala.” ");
INSERT INTO pon2006a_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Seikop eri tehrpeseng eh likou ko oh pwuhriong nan likoun nsensuwed. E ahpw mwahieiki nah pwutako rahn tohtohie. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Nah pwutak ko oh nah serepein koaros ahpw kin pokondohng reh, pwe re en kansenamwahwihala. Ahpw e sohte men nsenamwahula, e kin ndindahte, “I pahn mwahmwahieiki nei pwutako, I lao pahn kohdihla reh nan sousou.” Ih eri usehlahte mwahmwahieiki nah pwutak Sosep. ");
INSERT INTO pon2006a_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ni ahnsowo, mehn Midian ko netikihla Sosep rehn Podipar nan Isip, emen sapwellimen Parao lapalap ako, me kaunen pwihnen silasil en tehnpaso. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ni ahnsowo Suda eri mweselsang rehn rie ko oh kohla kousoanla rehn ohl emen ede Ira, sang kahnimw en Adullam. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","E ahpw tuhwong wasao serepein en Kenan men, me eh pahpa adaneki Sua. E ahpw pwoudikihda serepeino. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Serepeino eri naitikihong pwutak emen me e kihong ede Er. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","E pil pwurehng liseianda oh naitikihada pil emen pwutak, e ahpw kihong eden Onan. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","E pil neitik kasilipak oh kihong eden pwutako, Sela. Suda mihmi nan Aksip ni ahnsou me pwutako ipwidi. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Kedekedeo, Suda ahpw kapwopwoudihada nah pwutak mesenih Er, ong lih emen me ede Damar. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ahpw tiahk en Er me sohte mwahu, kahrehda e kahngiangihada kowahlap KAUN-O, iei me KAUN-O ketikihsang eh mour. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Suda eri ndaiong Onan, rien Er, “Kohwei kapwaiada nsenen pwopwoud rehn liohdio, en riomwo eh pwoudo, pwe ke en kapwaiada omw pwukoa ong riomwo oh wiahda nah seri, pwe en mie kadaudoke.” ");
INSERT INTO pon2006a_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ahpw Onan ese me seri me e pahn wiahda, kaidehn ih me pahn adki, eri ahnsou koaros me e kin kapwaiada nsenen pwopwoud rehn liohdio, e sohte kin kusiong, ahpw e kin kakusala liki, pwe en dehr wiahda kadaudok en rieo. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","E ahpw kahngiangihkihda KAUN-O soahng me e kin wiao, KAUN-O eri pil ketikihsang eh mour. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Suda eri ndaiong Damar, “Pwurala ni imwen omw pahpao wiewiate liohdi men, nei pwutak Sela lao keirda wiahla ohl.” Pwe e perki Sela de pil mehla duwehte rie ko. Damar eri pwurala ni imweo. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kedekedeo, en Suda eh pwoudo mehla. Mwurin ahnsoun mwahiei eh dauliher, Suda ahpw kohla Timna iangahki Ira mehn Adullam, pwe en sehkasang winen nah sihpw ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Damar eri rongada me Suda pahn kohla Timna pwehn sehk winen nah sihpw ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","E ahpw pwuhrsang nan eh likoun liohdi, pwainkihdi meseo koaduhpwel ehu, oh mwohndiong ni keilenial me tang kolahng Timna, pwe eh ese me nein Suda pwutak pekindihdi, Sela, wialahr ohl emen, e ahpw sohte kohieng pwe en pwoudiki. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ni Suda eh kilangada liho, e kihkihong me lihen netiki paliwere men ih, pwehki eh pwaindi meseo. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","E ahpw keilahng mpe ni keilenialo oh ndahng, “Ia uwen pweinomw?” (E sasairki me en nah pwutako eh pwoudo mwo.) Liho ahpw sapeng, “Dahme ke pahn kihong ie?” ");
INSERT INTO pon2006a_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","A ohlo sapengki, “I pahn kadarodohng uhk emen kisin kuht sang nan nei pelinmeno.” Liho ahpw nda, “Me mwahu, ma ke pahn kihong ie mehkot pwe I en kolokol oh wiahki kilel en ata inou lao ke kadarodohng ie kuhto.” ");
INSERT INTO pon2006a_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Suda eri idek, “Dahme I pahn kihong uhk me pahn wia kilel en ata inou?” A liho sapengki, “Omw katengen oh sokon me ke kolokolen.” E ahpw kihong liho dipwisou ko. Ira eri kapwaiada nsenen pwopwoud, liho eri liseianda. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Damar eri pwurala ni imweo, e ahpw kihsang eh koaduhpwelo, oh pwurehng pwuhriong nan likoun liohdi. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Suda eri kadarala Ira pwe en wahla kisin kuhto oh en kapwurehdo sang rehn liho dipwisou ko me wia kilel en ara inou. Ahpw Ira sohte diar liho. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","E ahpw idekseli rehn mehn Enaim ko, “Ia lih me kin netiki paliwereo me mihmi ni keileniale?” A irail sapeng, “Sohte mwahn lih emen me kin netiki paliwere men wasaht.” ");
INSERT INTO pon2006a_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","E ahpw pwurala rehn Suda oh ndahng, “I sohte diar liho. Tohn kahnimwo pil nda me sohte mwahn lihen netiki paliwere men wasao.” ");
INSERT INTO pon2006a_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Suda eri nda, “Eri, en ahnekihla ei dipwisou ko, pwe aramas de kouruhrkin kita. I kadarowohngehr kisin kuht me I inoukihong, ahpw ke sohte diar.” ");
INSERT INTO pon2006a_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ahpw mwurin sounpwong siluh, mie me ndahng Suda, ketihtihki, “En noumw pwutako eh pwoudo wialahr lihen netiki paliwere men, oh met e liseiandahr.” Suda eri nda, “Kumwail wahieila pwehn isihsla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Nindokon eh pakapakahrlahng wasahn kalokolok, e ahpw kadaralahng semen eh pwoudo pakair wet: “I liseianohng ohl me ahneki dipwisou pwukat. Kumwail kilang en ihs dipwisou pwukat— kilel me mi ni katenget oh sokonet.” ");
INSERT INTO pon2006a_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Suda kilangada dipwisou ko, e ahpw nda, “E pwung sang ie. Eh sapwung tikitik sang ei sapwung, pwehki ei sohte kihong nei pwutak Sela en pwoudiki.” Suda eri sohla wiahiong nsenen pwopwoud. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ni ahnsoun eh neitik eh lelehr, Damar diarada me mpwer ehu me mi nan kapehde. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ni eh pahn neitikier, emen mpwero kapwadei apali peho; sounkeneitiko ahpw koledi oh pirehiong ni peho kisinsel weitahta kis, pwe en wia kilel me ih me ipwidi mahs. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ahpw ni eh kapwurehlong peho, rie teio uhd pwediei; sounkeneitiko ahpw nda, “Ih duwen omw nantihong pwe ke en pwediei!” Ih me e adanekihki Peres. ");
INSERT INTO pon2006a_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Mwuri rieo ahpw pwediei; e ahpw adanekihla Sera. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Eri, mehn Ismael ko walahng Sosep nan Isip. Re ahpw netikihong Podipar, mehn Isip men, emen sapwellimen Parao lapalap ako, kaunen silepen tehnpas en nanmwarkio. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","KAUN-O eri kin ketin ieiang Sosep, pwe mehkoaros en kin pweida mwahu reh. E kin koukousoan ni imwen eh soumaso, me wia pwilidak en Isip men. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ohlo ahpw esehda me KAUN-O kin ketin ieiang Sosep oh mehkoaros kin pweida mwahu reh. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Podipar ahpw perenkihda mehlel en Sosep eh papah mwahu. Ih eri kasapwiladahng Sosep sounkohwahn imweo oh eh kepwe kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Sang ni ahnsowo kohla, KAUN-O kin ketin kupwuramwahwih imwen Podipar pwehki Sosep oh pil kin ketin kupwuramwahwih mehkoaros me mi nan imwe oh pil nan sapwe kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Podipar eri kihong mehkoaros Sosep en kin apwahpwalih oh sohte kin kedirepwki mehkot, ihte kisin tungoal kan me e kin tungoale. Sosep, pwutak paliwaramwahu men oh pil masamwahu. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kedekedeo, en Podipar eh pwoud ahpw inangihada Sosep oh peki en kohla mahs wendi reh. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","A Sosep sohte men dukiong, e ahpw ndaiong liho, “Ei soumas sohte kin kedirepwki mehkot nan ihmwet, pwehki eh likih ie. E wiahkinielahr sounkohwahn mehkoaros me e ahneki. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","At manaman duwepenehte nan ihmwet, oh e sohte irehdihsang ie mehkot, ihte komwi, eh pwoud, me e irehdihsang ie. Eri a, ia duwen ei pahn wiahda soangen sapwung laud wet, oh dipkihda mwohn Koht?” ");
INSERT INTO pon2006a_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Liho ahpw kin pekipeki reh rahn koaros, ahpw Sosep sohte dukiong wendi reh. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Rahn ehu Sosep ahpw pedolong nan ihmwo pwe en wia eh doadoahk, oh sohte ohl emen nan ihmwo ni ahnsowo. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Liho ahpw koledi en Sosep likowo oh ndahng, “Nna, wendi mahs rehi.” A Sosep uhdahte tangasang, tangeila liki, a eh likowo mihmihte rehn liho. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ni liho eh kilangada me e sohte wa eh likowo ni eh tangeisang reh, ");
INSERT INTO pon2006a_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","e ahpw ekerpene ladu ko en nan ihmwo, oh ndahng irail, “Kumwail kilang mahs! Ei pwoudo wadohng ni imwatailet mehn Ipru menet oh met e men kapailokei kitail. E pedolongodo nan ei pere oh song en angkehlailiong ie, I ahpw weriwer uwen ei kak. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ni ei weriwer, e ahpw kesehla eh likowet, ih eri tangeila likio.” ");
INSERT INTO pon2006a_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Liho eri nekidala likowo lao en Sosep eh soumaso pwurodo. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","E ahpw ndaiong koasoiohte, ketihtihki, “Omw lidu, mehn Ipruo, me ke wadohng kitail, pedolong nan ei pere oh kapailokei ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ahpw ni ei weriwer, e kesehlahte eh likowet, ih tangeila likio.” ");
INSERT INTO pon2006a_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Eri, en Sosep eh soumaso lingeringerda kowahlap. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ih eri ale Sosep oh kihong nan imweteng, wasa me sapwellimen nanmwarki aramas selidi kan kin sensel ie. Sosep eri mihla nan imwetengo. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ahpw KAUN-O ketin ieiangete Sosep, oh ketin kupwuramwahwihala, iei me kaunen imwetengo inenen perenkihla Sosep. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ih eri kasapwiladahng Sosep en kin apwahpwalih tohnimwetengo koaros. Sosep eri kin pwukoahki mehkoaros me kin wiawi nan imwetengo. ");
INSERT INTO pon2006a_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kaunen imwetengo sohte kin kedirepwki en Sosep pwukoa, pwe KAUN-O kin ketin ieiang Sosep pwe mehkoaros me e kin wia en pweida mwahu. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Kedekedeo, sounkohwahn wain, oh kaunen wia pilawahn nanmwarki, ira koaros kahngiangihada nanmwarkien Isip. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Parao eri engiengda pahra, ");
INSERT INTO pon2006a_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","oh ketikihlong ira nan imweteng rehn kaunen silasil ko; wasaohte me Sosep wie sensel ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kaunen silasilo eri kilelehiong Sosep pwe en papah ira. Irail ahpw mihmi nan imwetengo ahnsou reirei. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Pwohng ehu, sounkohwahn wain oh kaunen pilawahn nanmwarkio ira koaros ahpw ouramanda. Eri, wehwehn ara ouraman ko wekpeseng. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Sosep lao pedolong rehra nimengseng, e ahpw kasawihada ara mwomwen pahtou. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ih eri idek rehra, “Dahkot mwo, maing ko, dahme kumwa mwomwen pahtouki rahnwet?” ");
INSERT INTO pon2006a_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ira ahpw sapeng, nda, “Ahki kiht koaros se ouraman pwohng. Eri, sohte emen met me kak kawehwehiong kiht wehwehn at ouraman ko.” Sosep ahpw ndahng ira, “Koht kelehpw me kak ketin kawehwehda ouraman kan. Nna, kumwa ndadohng ie amwa ouraman kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Sounkohwahn waino eri nda, “I ouraman me tuhkehn wain pwoat mi mwohi ");
INSERT INTO pon2006a_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","me rah siluh mie. Ni tehntuhkeo eh pwerla oh wah, wahn wain akan eri mahla. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","I wie kolokol sapwellimen Parao dahlo. I ahpw dolungete wahn wain ako, wengidediong nan dahlo, oh loangedahng Parao.” ");
INSERT INTO pon2006a_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Sosep ahpw ndaiong, “Eri, iet wehwehn ouramanen: rahn tuhkehn wain siluho wehwehki rahn siluh me luhwe. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mwurin rahn siluh Parao pahn kasaledekeiukala, mahkohng uhk, oh kapwurehiong uhk nan deumw. Ke pahn loangedahng sapwellime dahl duwen me ke kin wia mahso, ni omw kin sounkohwahn wain. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","A ke ahpw tamantaman ie nan omw paiamwahu, oh menlau kataman ie rehn nanmarkio, pwe en ketikihsang ie nan imweteng wet. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Pwe ngehi aramas emen me pirapodohsang nan sapwen mehn Ipru kan, oh lao lel met sohte mehkot I wiahda pwe re en keseiehlong nan imweteng wet.” ");
INSERT INTO pon2006a_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Eri, ni kaunen wie pilawa eh rongada duwen kawehwehpen ouramano eh mwahu, e ahpw pil ndahng Sosep, “Ngehi pil ouraman. Eri, iet duwe: I ouraman me kopwoun pilawa siluh poasoakehda pohn moangeiet. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kopwou me keieu powe, inenen audaud en soangen kisin konot koaros, konot en Parao; ahpw menpihr kan wie kangkang.” ");
INSERT INTO pon2006a_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Sosep eri sapeng, nda, “Iet wehwe: kopwou siluho wehwehki rahn siluh me luhwe. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Eri, mwurin rahn siluh Parao pahn ketikihsang uhk nan imwetenget oh lupukasang moangomwen. E ahpw pahn langadahng uhk ni apwoat tuhkehn; menpihr kan ahpw pahn kangasang uduk en paliwaromwen.” ");
INSERT INTO pon2006a_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Eri, rahn siluh mwuri, rahnen ipwidien Parao, lapalahn kamadipw ehu ahpw wiawihong tohn tehnpeseo koaros. Ih eri malipehdo sapwellime sounkohwahn waino, oh pil kaunen pilawao, mwohn lapalap ako. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ih eri ketin kapwurehiong sounkohwahn waino nan dewe; ");
INSERT INTO pon2006a_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","a kaunen wie pilawao e ketin langahda nin tuhke pwoat. Ih duwen eh pweida ouraman ko me Sosep kawehwehda. ");
INSERT INTO pon2006a_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ahpw iet sounkohwahn waino nan eh pai, e ahpw manokehla, oh sohte tamanda Sosep. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Mwurin sounpar riau, Parao ahpw ketin elimanda me dene e ketiket ni keilen Pillap Nail, ");
INSERT INTO pon2006a_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ni ahnsowo kou kaselel mworourou isimen ahpw pwarada sang nan pillapo oh tapihada mwengemwenge ni keilen pillapo. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Mwuhr, pil kou isimen pwarada sang nan pillapo; re me inenen tihti oh mwomw suwed. Re kohda oh pil iang mihmi limwahn kou teiko, ");
INSERT INTO pon2006a_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","oh kou tihti ko uhdahte kangala kou mworourou ko. Parao eri ohpala wasa. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","E ahpw pil seimwokla oh pwurehng elimanda. Wahn kohn isuh uhsang ni kirikirtehpwoat; re inenen kaneng oh kaselel. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","A pil wahn kohn isuh pil wosada me sohte kanenge oh meng pwehki kisinieng en nan sapwtehn, ");
INSERT INTO pon2006a_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","re ahpw kangala wahn kohn isuh kaneng oh kaselel ko. Parao eri ohpala wasa, oh ketin diarada me e ketin eliman. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Nimenseng e ahpw kupwur toutoula, e ahpw kapokonepene sounakmanaman oh me loalokong kan koaros en Isip. Ih eri mahsanihong irail duwen sapwellime eliman ko; ahpw sohte emen rehrail me kak kawehwehda. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Sapwellime sounkohwahn waino ahpw patohwanohng Parao, “Rahnwet I pahn sakarkihda sapwung me I wiadahr. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ni omwi ketin engiengda pahi oh kaunen wie pilawao, komwi ahpw ketikihong kiht nan imweteng nan imwen kaunen silasil ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Se ahpw patohwan ouramanda pwohng ehu. Kiht koaros ouraman ahpw wehwehpara wekpeseng. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Mwahnakapw en Ipru men iang kiht mihmi nan imwetengo, lidun kaunen pwihnen silasil. Kiht eri padahkihong duwen at ouraman ko. E ahpw kawehwehiong kiht. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Soahng koaros eri pweida duwen me e kawehwedahr ko: ngehi eri pwurehng nan dewei, a soun wie pilawao langadahng nin tuhkeo.” ");
INSERT INTO pon2006a_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Parao eri poaronelahng Sosep en patohdo reh. Re ahpw mwadangete kihieisang nan imwetengo, oh mwurin eh kihsang eh alis ko, oh wilian eh likou kan, Sosep ahpw patohla pahn kupwur en Parao. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Parao eri mahsanihong, “Ahi ouraman ehu, ahpw sohte mehmen me kak kawehwehda. I rong me dene ke kak kawehwehda ouraman.” ");
INSERT INTO pon2006a_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Sosep eri patohwan sapeng, “I sohte kak, ahpw Koht me pahn ketin kupwurkalahngan kawehwehiong komwi.” ");
INSERT INTO pon2006a_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Parao ahpw mahsanih, “I ouraman me I kesikesihnen ni keilen Pillap Nail, ");
INSERT INTO pon2006a_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","a kou mworourou kaselel isimen ahpw pwarada sang nan pillapo oh tapihada mwengemwengeseli. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mwuhr, pil kou isimen pwarada sang nan pillapo, me inenen tihti oh mwomw suwed. I saikinte mwahn kilangada soangen kou sakanakan duwehte met kan nan Isip pwon. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Eri, kou tihti ko ahpw kangala kou mworourou ko, ");
INSERT INTO pon2006a_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ahpw sohte sansal lipwen ar kangala, pwe re mwomwomw suwedte oh wie tihtihte duwehte mahs. Ngehi eri pirada. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","I pil pwurehng ouraman, dene I kilangada wahn kohn isuh, me inenen kaneng oh kaselel, me uhsang ni kirikirtehpwoat. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mwuhr, pil wahn kohn isuh ahpw pil wosada, me sohte kanenge oh meng pwehki kisinieng en nan sapwtehn, ");
INSERT INTO pon2006a_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","re ahpw kangala wahn kohn kaselel ko. Eri, I padahkihongehr sounakmanaman akan ouraman pwukat, ahpw sohte emen rehrail me kak kawehwehiong ie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Sosep ahpw patohwanohng Parao, “Sapwellimomwi eliman riau wet wehwehteieu. Koht kupwurki kasalehiong komwi dahme e pahn ketin wia. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Eri, kou mworourou isimen ko wehwehki sounpar isuh, oh kohn kaneng isuh ko pil wehwehki sounpar isuh; koaros wehwehteieu. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","A kou tihti isimen ko me kohda mwuhr oh kohn sohte kanenge ko me mengkihla kisinieng en nan sapwtehn, wehwehki sounpar isuhwen lehk lapalap. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ih pahn duwen me I patohwanohngkomwier—Koht ketin kasalehiongkomwier dahme e pahn ketin wia. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Sounpar isuh rahk laplap pahn mie nan Isip pwon. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Mwurin sounpar isuh lehk lapalap pil pahn usehla, oh sohla me pahn tamatamanki ahnsoun rahko, pwehki lehk lapalapo pahn kauwehla wehiet. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Aramas akan pahn manokehla rahk lapalapo, pwehki lehk lapalap me pahn wiawi mwuri pahn mwuledek. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kahrepen omwi eliman pak riau pwehki Koht ketin kileledier me irair wet pahn pweida ni ahnsou keren. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Eri, met komw pahn ketin rapahkihda ohl loalokong oh koahiek men me komw pahn ketikihong doadoahk en apwahpwalih wehiet. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Komw pahn pil ketin kilelehdi ekei lapalap me pahn nekidala limakis ehun wahnsahpw erein sounpar isuhwen rahk. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Padahkihong irail re en nahkpene wahnsahpw koaros erein ahnsoun rahk me pahn kohdo, oh kihong irail manaman en nekidala oh sile pilawa kan nan kahnimw kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Pwe tohn wehi pokon en kak kang ni ahnsou me lehk lapalap pahn kohdo nan Isip. Pwe aramas akan en dehr duhpekla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Parao oh sapwellime lapalap akan ahpw kamanahla koasoandi wet. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Parao eri mahsanihong irail, “Kitail sohte kak diar emen ohl me duwehte Sosep, me audaukidahr ngehn en Koht.” ");
INSERT INTO pon2006a_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Parao eri mahsanihong Sosep, “Koht ketin kasalehiongkomwiher mepwukat koaros, eri e dehde mehlel me sohte emen ohl me loalokong oh koahiek sang komwi. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Eri, met I pahn kasapwilkomwihda, pwe komwi en kaunda ei wehi, oh nei aramas akan koaros pahn kin kapwaiada omwi koasoandi. Ngehite me pahn lapalapasang komwi. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Met I kasapwiladahngkomwiher en wiahla kepina en Isip pwon.” ");
INSERT INTO pon2006a_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Parao eri ketikihsang sapwellime kisin rihng en nanmwarki oh ketikihong ni sendin pehn Sosep. E ahpw pil ketin kalikawihkihda likou linen kaselel, oh ketin kammwarehkihda elin kohl ehu. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","E ahpw ketikihong sapwellime werennansapw keriau pwe en dake, oh sapwellime pwihnen sounpei ahpw tieng mwowe, pakapakairki ni ngihl laud, ndinda, “Kumwail poaridiong! Kumwail poaridiong!” Ih duwen Sosep eh wiahla kaunen Isip pwon. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Parao ahpw mahsanihong Sosep, “Ngehi me nanmwarki, ahpw sohte emen nan Isip pwon pahn kamwakid peh de neh, ma komw sohte pahn mweidohng.” ");
INSERT INTO pon2006a_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","E ahpw ketikidahng pohn Sosep mwar ehu, iei, Sapenat Panea; oh ketikihong eh pwoud, Asenat, nein Podipera serepein; Podipera me samworo en kahnimw Iliopolis. Sosep sounpar 30 ahnsou me eh tapihada papah Parao, nanmwarkien Isip. E ahpw seiloak kapilseli Isip pwon. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Erein sounpar isuhwen rahko, wahnsahpwo inenen pweida mwahu, ");
INSERT INTO pon2006a_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Sosep eri kihpene kisin mwenge koaros oh nahkpene nan kahnimw kan. Nan ehuehu kahnimw kan e kin kihpene mwengehn wasa kan me karanih kahnimwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","E kihpene wahn pilawa me uwe rasehng pihken ni oaroahr kan; e ahpw sohla sohng, pwehki eh sohla kak sosohng. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Eri, mwohn sounpar en lehk lapalap ko leledo, Asenat ahpw naitikihong Sosep pwutak riemen. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Sosep eri patohwan, “Koht me ketin kupwurehda pwe I en manokehla douluhl ei lokolok koaros oh peneineien ei pahpao”; ih eri kihong eden nah meseniho, Manase. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","E ahpw pil patohwan, “Koht me ketikihong ie wahnedi kan nan sapwen ei apwal kan”; ih eri kihong eden nah pwutak keriemeno, Epraim. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Sounpar isuhwen rahk nan Isip eri imwisekla, ");
INSERT INTO pon2006a_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","a sounpar isuhwen lehk lapalap ahpw uhd tepida, duwen Sosep eh kohpadahr. Lehk lapalap kipehdi wehi teikan koaros, ahpw nan Isip mie kisin mwenge. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ahpw ni ahnsou me mehn Isip ko kin men mwenge, re kin patohla peki kisin mwenge rehn Parao. Ih eri kin mahsanihong irail re en kohla rehn Sosep oh wia dahme e pahn patohwanohng irail. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ni lehk lapalapo eh uklahr oh kipehdi wasa koaros nan wehio pwon, Sosep ahpw ritingada imwen nahk koaros oh netikihong mehn Isip ko pilawa ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Sang wasa koaros nin sampah, aramas akan kin pwarodo rehn Sosep pwe re en pwainda arail tungoal pilawa, pwe lehk lapalapo pil lelpeseng wasa koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ni Seikop eh rongada me mie kohn nan Isip, e ahpw ndaiong nah pwutak ko, “Dahme kumwail mwomwohdmwahlki, sohte wia mehkot? ");
INSERT INTO pon2006a_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","I rong me mie kohn nan Isip; kumwail kohdihla mwo oh pwainda kanatail ekis, pwe kitail dehr mehkihla atail duhpek.” ");
INSERT INTO pon2006a_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Eri rien Sosep pwutak ehk ko ahpw kohdihla Isip pwe re en pwainda kanarail wahn kohn. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ahpw Seikop sohte mweidohng rien Sosepo, Pensamin, en iang irail kohdihla, pwehki e perki e de lelohng apwal. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Nein Seikop pwutak ko eri kohdihla iangahki aramas teikan pwehn pwain wahn kohn, pwe lehk lapalapo kipedier wasa koaros nan Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Sosep, kepina en Isip, me kin netinetikihong aramas akan wahn kohn. Rien Sosep ko eri lel Isip, re ahpw kohla oh rahnmwahwih oh poarikidiong masarail nanpwel. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Sosep mwadangete eseirailda ni e kilang irail, ahpw mwomwehda me e sehse irail. E ahpw lokaia lemei ong irail oh idek, “Kumwail kohsang ia?” A re sapeng, nda, “Se patohdo sang Kenan pwe se en pwain kisin mwenge.” ");
INSERT INTO pon2006a_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Sosep uhdahn wehwehki me rie ko mwo, ahpw irail sasairki me Sosep mwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ih eri tamanda ouraman me e wiahier duwen irail, e ahpw ndaiong irail, “Lipoahrok kei kumwail me kodohng kadehde wasa luwet akan en sahpwet.” ");
INSERT INTO pon2006a_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Re ahpw sapeng, patohwan, “Soh maing, sapwellimomwi lidu kat patohdohng pwain kisin mwenge. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kiht koaros nein sahm tehmen. Kiht aramas mehlel kei, kaidehn kiht lipoahrok kei.” ");
INSERT INTO pon2006a_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Sosep ahpw sapeng irail, mahsanih, “Soh, kumwail kodohn lipoahroke wasa luwet kan en at wehi.” ");
INSERT INTO pon2006a_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Irail sapeng, patohwan, “Maing, kiht koaros me ehk riemen, nein ohl tehmen nan Kenan. Me keieu tikitiko patopato rehn at tungoal pahpao, a emen mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Sosep ahpw mahsanih, “Sohte kak, uhdahn kumwail lipoahrok kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Eri iet duwen eh pahn dehdehda dahme kumwail ndindahn: I kahukihla ni mwaren Parao, me kumwail sohte pahn kohkohsang met, riamwail me tikitiko lao pahn pwarodo wasaht. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Eri kumwail kadarowei emen kumwail rehn riamwail me tikitiko pwehn kahrehdo, a kumwail meteikan koaros pahn sensel met, mehlel en amwail koasoi kan lao pahn dierekda; ma kumwail sohte pahn lokaia mehlel, nin duwen Parao eh ieias, kumwail lipoahrok kei.” ");
INSERT INTO pon2006a_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ih eri keseiraillong nan imweteng erein rahn siluh. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ni kesiluhn rahn Sosep ndaiong irail, “Ngehi aramas emen me kin lemmwiki Koht, eri, I pahn kadarkumwailla ma kumwail pahn kapwaiada dahme I pahn ndaiong kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Pwe en kadehdehda me kumwail ohl mehlel kei, eri, emen rehmwail me pahn mihmi nan imweteng, a meteikan pahn pwurala wahla wahn kohn me kumwail pwaindahr ong amwail peneinei me duhpeklahr. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ahpw kumwail uhdahn pahn wahdo riamwail me keieu tikitiko. Ih duwen amwail pahn kadehdehda mehlel en amwail koasoi, oh kumwail sohte pahn mehla.” Re ahpw iang pwungki koasoandi wet. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Re ahpw ndapene nanpwungarail, “Kitail uhdahn pahn ale lokolok pwehki soahng me kitail wiahiong riatailo; kitail kilang uwen laud en eh pwunod ni eh pekipeki rehtail kitail en poakehla, ahpw kitail sohte men rong. Ih kahrepen atail milahr nan apwal wet.” ");
INSERT INTO pon2006a_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reupen ahpw nda, “I ndaiong kumwail en dehr wia soangen sapwung wet ong riatailo, kumwail ahpw sohte men rong ie. Met kitail aleier pweinen eh mehlao.” ");
INSERT INTO pon2006a_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Re sasairki me Sosep mwahngih mehkoaros me re ndinda, pwehki eh mie sounkawehwehiong arail koasoi kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","E ahpw pweiekla sang irail oh tentenihr. Mwuhr e ahpw pwurodo rehrail oh pwurehng mahseniong irail. E ahpw pilada Simion, oh pirehdi mwohn masarail kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Sosep pil koasoanehdi pwe arail ehd ko en audaudkihda wahn kohn, nair mwohni ko en kapwurupwurdiong nan ehd ko, oh katihnaparail nan seiloak en kohieng irail. Eri, soahng pwukat ahpw wiawiher. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Pwihn pirieno ahpw kesedahng pohn ahs ako ehd en kohn me re pwaindahr, re ahpw mwesel kohkohla. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ni ar lel wasahn keiru nipwong, emen irail ahpw sapwadpeseng eh ehdo pwehn kamwenge nah ahso, e ahpw diarada ni ewen eh ehdo nah mwohni ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","E ahpw likwerkilahng rie ko, “Ser, nei mwohni ko kapwurupwuriong nan ei ehdet!” Re ahpw nsensuwedla oh masepwehkada ndapene nanpwungarail, “Dahme Koht ketin wiahiongkitailehr?” ");
INSERT INTO pon2006a_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ni arail lel rehn arail pahpao nan Kenan, re ahpw koasoiaiong soahng koaros me wiawihiong irail. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Re ndaiong, “Kepina en Isipo mahsen lemeiong kiht oh karaunihkin kiht me dene se lipoahroke sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","A se patohwanohng, ‘Kiht aramas mehlel kei; kaidehn kiht lipoahrok kei. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Kiht pirien ehu me ehk riemen, nein sahm tehmen; emen mehla, a me tikitiko mihmi rehn at pahpao nan Kenan.’ ");
INSERT INTO pon2006a_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ohlo ahpw sapengkin kiht, mahsanih, ‘Iet duwen ei pahn ese me kumwail aramas mehlel kei: emen kumwail pahn mihmi rehi; a mehteikan pahn pwurala wahla wahn kohn kan ong amwail peneinei me duhpeklahr akan. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ni amwail pahn pwurodo rehi iangahki riamwail me tikitiko, I pahn esehki me kumwail aramas mehlel kei, a kaidehn lipoahrok kei. I ahpw pahn kapwureiong kumwail riamwailet, oh kumwail kakehr mihmi wasaht oh netinetseli.’” ");
INSERT INTO pon2006a_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Eri, ni ar wudekidihsang kanengen ar ehd ko, re diarada nair mwohni ko mihmihte nan en emenemen eh ehd. Ni ar kilangada mwohni ko, irail koaros oh arail pahpao inenen masepwehkada. ");
INSERT INTO pon2006a_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Arail pahpao eri ndaiong irail, “Kumwail men adihasangieier nei seri kan koaros? Sosep solahr mie; Simion solahr mie; a met kumwail pil men kihsang ie Pensamin. Ngehi me lokolongki mepwukat!” ");
INSERT INTO pon2006a_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Reupen ahpw ndaiong eh pahpao, “Ipa, ngehi me pahn pwukoahki kapwurehdo Pensamin, eri, ma I sohte kapwurehdo rehmwi, a komw kak kemehla nei pwutak riemeno.” ");
INSERT INTO pon2006a_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","A Seikop sapeng, nda, “Nei pwutaket sohte pahn iang kumwail kohdihwei; rieo melahr, oh ihete me luhwe. Ehu apwal kakete lelohng nan amwail seiloaken. I ohl laudlahr, oh nsensuwed me kumwail pahn kahrehiong ie kakete kemeiehla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Lehk lapalapo nan Kenan inenen uklahr mehlel, ");
INSERT INTO pon2006a_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","eri, ni peneinei en Seikop ko ar tungoalelahr wahn kohn ko, me re wahdo sang Isip, Seikop ahpw ndaiong nah pwutak ko, “Kumwail pwurala oh pwurehng pwainda atail tungoal kisin mwenge.” ");
INSERT INTO pon2006a_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Suda ahpw sapeng eh pahpao, nda, “Ohlo kehlehlingkihong kiht ni kehlail, me se sohte pahn kak tuhwong ma riato sohte iang kiht. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ma ke mweidohng riato en iang kiht, eri, se pahn kohdihla oh pwainda omw tungoal wahn kohn. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","A ma ke sohte men mweidohng, eri se sohte pahn kohdihla, pwe ohlo mahsanihong kiht, me se sohte pahn tuhwong ma riato sohte iang kiht.’” ");
INSERT INTO pon2006a_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Seikop ahpw nda, “Pwe dahme kumwail pil ndakihong ohlo me mie emen riamwail? Kumwail inenen kihong ie nan apwal.” ");
INSERT INTO pon2006a_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","A re sapeng, nda, “Pwe ohlo idihdekte reht duwen oaretik en atail peneinei, ‘Amwail pahpao momourte? Mie pil emen riamwail?’ Eri, se uhdahn pahn sapeng eh peidek ko. Pala se kak ese me e pahn mahsanihong kiht se en wahla riato?” ");
INSERT INTO pon2006a_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Suda ahpw ndaiong eh pahpao, “Mweidohng pwutaken en iangiehda, pwe se en mwesel kohkohla, pwe emen kitail de mehkihla duhpek. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I pahn pangala pein ei mour, oh ngehi me pahn pwukoahki. Ma I sohte kapwurehdo, eri, I pahn dipada ong komwi kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kitail kauwelahr atail ahnsou, mahk kitail lelehr mwo oh pwurodohr pahn pak riapak.” ");
INSERT INTO pon2006a_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Arail pahpao eri ndaiong irail, “Eri, ma ih pahn duwe met, a kumwail audekihda amwail ehd kan wahnsahpw me keieu kaselel oh wahwei kisikisehki kepinao. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kumwail pil kalaudehla pak riapak uwen mwohni me kumwail pahn wa kohwei, oh kapwurehla mwohni me kumwail diar nan amwail ehd ko. Mweinele sapwungala ieu men. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kumwail pil kahrehda riamwailet oh kumwail pil mwadang pwurodo. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Koht Wasa Lapalap en ketin kupwure pwe kumwail en diar kalahngan rehn ohlo, pwe en kapwuredohng kumwail Pensamin oh riamwail teio, a ngehi, ma I sepwoupwoulahr solahr nei seri, so mehn wiawi, I pahn kanengamahiong.” ");
INSERT INTO pon2006a_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Pwihn pirieno eri ale arail mehn kisakis ko oh uwen mwohni laud pak riapak, oh iangahki Pensamin; re ahpw mwesel kohdilahng Isip pwe re en tuhwong Sosep. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ni Sosep eh mahsanihada me Pensamin iang irail, e ahpw mahsanihong sapwellime kaunen papah ko, “Kahrehla pwihno ni imweio, ke ahpw kemehla emen mahn en oh onopada pwe re pahn iang ie tungoal nin souwaset.” ");
INSERT INTO pon2006a_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kaunen papah ko eri kapwaiada mehkoaros me koasoandiong en wiawi, e ahpw kahreirailla nan tehnpas en Sosepo. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ni ar pedolong nan tehnpaso, re inenen masepwehkada, re ahpw mengimengloalki, “Kitail pakahrdohngehr wasaht pwehki mwohni ko me kapwurupwurlong nan atail ehd ko nin tapio. Re pahn kemeikitail, adihasang kitail neitail ahs akan oh kaliduwihkitailla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Irail eri keilahng mpen kaunen papah ko oh lokaiaiong ni wenihmwen tehnpaso. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Re patohwanohng, “Maing, komw kupwur mahk, pak ehu se patohwan pwarodohr wasakiset pwe se en pwainda at tungoal kisin mwenge. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ahpw ni at lel wasahn kommoal oh keiruhdi ie, se sapwadpeseng at tungoal ehd ko, oh diarada nan ewen en emenemen eh ehd mwohni ko. Se patohwan kapwurehdo koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Se pil iangahki mwohni mehn pwainda pil ekei mwenge. Se sohte patohwan ihs me kihdiong mwohni ko nan at tungoal ehd ko.” ");
INSERT INTO pon2006a_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Papaho ahpw ndaiong irail, “Kumwail dehr pwunod, kumwail dehr masak. Mweinele amwail Koht, Koht en samamwailo me ketikihong kumwail mwohni pwukan nan amwail ehd kan. I aleier pweinen kanamwail mwenge ko.” E ahpw kahreiei Simion rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Papaho eri kahrehlong pirieno nan tehnpas en Sosep. E ahpw kihong irail pihl mehn widen nehrail ko, oh e pil kamwenge neirail ahs ako. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Irail eri kaunopada arail kisakis ko mwohn Sosep eh pahn lelodo nin souwas, pwe re rongada me re pahn iang Sosep saken souwas. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ni Sosep eh lelodo, re ahpw walahng kisakis ko, oh poaridi mwowe lel nanpwel. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Sosep eri idek ia irarail oh pil mahsanih, “Kumwail koasoiaiong ie mahs duwen amwail pahpa ohl laudo, a ia ire? E momourte oh e me kehlail?” ");
INSERT INTO pon2006a_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Re sapeng, “Ei maing, sapwellimomwi ladu sohwar, at tungoal pahpa, momourte oh e me kehlail.” Re ahpw kelehpwkihdi oh poaridi mwowe. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ni Sosep eh kilangada rie Pensamin e ahpw idek, “Ih riamwail me tikitiko met me kumwail koasoiaiong ie duwe?” Ih eri mahsanihong, “Koht en ketin kupwuramwahwihiuk, samwa.” ");
INSERT INTO pon2006a_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","E ahpw mwadangete ketiketla sang irail, pwe nan kupwure mwekidikihda e poakohng rie ko, e ahpw solahr itarohng, ih eri ketilongala nan eh pere oh tentenihr ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Mwurin eh epwinekda, e ahpw ketieila oh nantihong kanengamahiong pepehm en nan kupwure, ih eri mahsanih sak en wiawihla. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Sosep ket ni ehu tehpel a rie ko ni ehu. Mehn Isip ko me iang kepin sako pil pato ni ehu tehpel, pwe re kin wiahki mehkot kanamenek oh kasaroh iang mehn Ipru kan mwohdehng ni ehu tehpel. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Pirieno ahpw mwohndiong ni tehpel sallahng Sosep, me meseniho mahs, mwuhri meteiko nin duwen irekidien sounpararail ko, lao lel me keieu tikitiko. Ni ar tehkada duwen koasoandi en ar mohndio, re ahpw inenen pwuriamweikihla. ");
INSERT INTO pon2006a_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Re audehda neirail dahl ako sang ni en Sosep tehpelo, oh en Pensamin eh tungoalo inenen laudsang en meteiko pak limau. Irail eri iang ih sakasak oh pereperen kowahlap. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Sosep eri ketikihong kaunen papah ko koasoandi pwukat: “Audekihda en aramas pwukat ar ehd kan kisin mwenge lao dir, uwen me re kak wahda, oh kapwurehiong nan ewen en emenemen eh ehd nah mwohni ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Pil kihong nei kep silpero nan en me keieu tikitiko eh ehdo, iangahki nah mwohni ko.” Kaunen papah ko eri kapwaiada sapwellimen Sosep koasoandi pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ni mandahn rahno nimenseng, pirieno oh nair ahs ako ahpw mwesel. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Re saikinte dohlahsang kahnimwo, a Sosep mahsanihong papaho, “Mwadang pwakihowei mahs pwihno. Ni omw pahn koanoairaildi, ke pahn idek rehrail, “Dahme kumwail dupuksuwedkihong ie ni ei apwalih kumwail? Dahme kumwail pirapakihsang sapwellimen ei kauno kep silpero? ");
INSERT INTO pon2006a_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Iei kepo me e kin sak pilki, oh kin wiewiahki mehn kosetipw. Kumwail wiadahr sapwung laud ehu!” ");
INSERT INTO pon2006a_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ni papaho eh koanoiraildi, e ahpw ndaiong irail dahme Sosep mahsaniher. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","A irail ahpw sapeng, nda, “Maing, ia duwen omwi kak mahsanih soahng pwukat? Se kahukihla me se sohte wiahda soangen tiahken. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Komwi pil mwahngih me se pil patohwandohr mwohni ko me se diarada ni ewen at tungoal ehd ko. Eri ia duwen at pahn kak pirapa silper oh kohl sang ni tehnpas en omwi kaun? ");
INSERT INTO pon2006a_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Mehmen reht me kep silpero pahn dierekda nan eh ehd, a en kamakamala, oh kiht koaros se pahn wiahla sapwellimomwi lidu.” ");
INSERT INTO pon2006a_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","A e sapeng, “Me mwahu; en wiawi dahme kumwail ndindahn. Ahpw so pwe mehmeno me kep silper wet dierekda reh, ihte me pahn wiahla lidu, a meteikan pahn saledekla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Irail eri mwadangete kihdi sang pohn ahs ako arail ehd ko, kihdiong nanpwel oh sapwadada. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","En Sosep laduwo ahpw tepihada rapahki, tepida sang rehn me laudo oh imwisekla rehn me tikitiko. Kepo ahpw dierekda nan en Pensamin ehdo. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Irail ahpw tehrpeseng ar likou ko pwehki arail nsensuwed, re ahpw kapwuredahng ar ehd ko pohn ahs ako oh pwuralahng nan kahnimwo. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ni ahnsou me Suda oh rie ko lellahng ni tehnpas en Sosep, e wie ketikette mwo. Re ahpw poaridi mwowe. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Sosep ahpw mahsanih, “Dahme kumwail wiadahr? Kumwail sehse me soangen aramas ngehiet kakete diarada duwen kumwail sang nan ei kosetipw?” ");
INSERT INTO pon2006a_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Suda ahpw sapeng, “Dahme se pahn sapengkin komwi, maing? Dahme se pahn patohwan akupwungkihong komwi? Ia duwen at pahn doareikitala patohwan me se uhdahn mwakelekel? Koht ketin kasaledahr at sapwung. Eri kiht koaros wialahr met sapwellimomwi lidu, kaidehn ihete me sapwellimomwi kepo dierekda reh.” ");
INSERT INTO pon2006a_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Sosep ahpw mahsanih, “Soh! Kaidehn men me pahn wiawi! Ihete me nei kepo dierekda reh me pahn wiahla ei lidu. Kumwail teikan koaros kak pwurowei ni meleilei rehn amwail pahpao.” ");
INSERT INTO pon2006a_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Suda ahpw keiong mpen Sosep oh patohwan, “Maing, komw kupwure ie mahs oh karonge ei pato kat. Komw dehr engieng pahi; pwe komwi pil rasehng Parao. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Maing, komw ketin idekehr reht, ‘Mie amwail pahpa de emen riamwail?’ ");
INSERT INTO pon2006a_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kiht eri sapengkin komwi, ‘Mie at tungoal pahpa me ohl laudlahr oh riat emen me tikitik, me ipwidi ni ahnsou me at pahpao ohl laudlahr. Uhdahn rien me tikitik menet melahr, oh ih kelehpwte me luhwe rehra, me inara tehmen; eri, e me inenen soisoi pahn at pahpao.’ ");
INSERT INTO pon2006a_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Maing, komwi ahpw mahsanihong kiht se en kahrehdihdo pwutako rehmwi, pwe komw kupwurki mahsanih, ");
INSERT INTO pon2006a_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","se ahpw patohwanohng komwi me pwutak menet sohte kak patohsang rehn eh pahpao; pwe eh pahpao uhdahn pahn kapilsalehdkihla. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Komwi ahpw mahsanih, ‘Ma riamwail me tikitiko sohte pahn iang kumwail pwurodo, eri kumwail sohte pahn kak tuhwong ie.’ ");
INSERT INTO pon2006a_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ni at patohwan pwuradahla rehn at tungoal pahpao, se patohwanohng mehkoaros me komw mahsanihong kiht. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Eri, at tungoal pahpao pil patohwanohng kiht se en pwuredihdo oh pwainda at tungoal mwenge. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Se ahpw sapengki, ‘Se sohte kak pwurala; se sohte pahn kak tuhwong ohlo ma riat me tikitiko sohte iang kiht. Se pahn kohla ma riat me tikitiko pahn iang kiht.’ ");
INSERT INTO pon2006a_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","At tungoal pahpao eri patohwanohng kiht, ‘Kumwail ese me ei pwoud Resel wiahiong ie nei pwutak riemente. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Eri, emen ira solahr mie. Oh mweinele mahn lawalo men me kangalahr, pwe lel rahnwet e saikinte pwarada. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ma kumwail pahn pil wahsang mehmenet rehi, oh paisuwed ehu ahpw lelohng, kumwail pahn kahrehiong ei pahn mehkihla nsensuwed, pwe I ohl laudlahr.’” ");
INSERT INTO pon2006a_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Suda ahpw pil patohwan, “Eri maing, ma I pahn pwurala rehn ei pahpao, ih eri kilangada me riatet sohte iang kiht, e uhdahn pahn kapilsalehkihla. Pwe pwutaket me kahrehiong eh momour, oh e pil ohl laudlahr, nsensuwed pahn kakete kahrehiong eh pahn kapilsalehdala. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Oh I pil pangalahr ei mour ong ei pahpao pwehki pwutaket. I patohwanohng ma I sohte pahn kapwurelahng pwutaket, eri, ngehi me pahn pwukoahki erein ei mour. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Eri maing, I pahn wiliandi pwutaket oh wiahla sapwellimomwi lidu; komw mweidohng en iang rie kan patopatohla. ");
INSERT INTO pon2006a_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ia duwen ei pahn kak pwurala rehn ei tungoal pahpao ma pwutaket sohte iang ie? I sohte pahn itarohng kilang nsensuwed laud me pahn lelohng ei pahpao.” ");
INSERT INTO pon2006a_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Sosep solahr kak irehdi mwekid kompoake kan en nan kupwure mwohn eh ladu ko, ih eri mahsanihong irail en pedoisang wasao. Sohte emen me pato reh ni ahnsou me e ketin kasalehiong rie ko pein ih. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ih eri tapihada tentenihr laud, me kahrehda mehn Isip kan ar rongada, oh rohng wet ahpw lellahng nan tehnpas en Parao. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Sosep eri mahsanihong rie ko, “Ngehi Sosep. Ei pahpao momourte?” Rie ko ahpw nennenlahte sohte sapeng, re inenen masepwehkada oh pwuriamweikihla. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Sosep eri mahsanihong irail, “Kumwail keido.” Ni ar keipenehng mpe, e ahpw mahsanih, “Ngehi riamwail Sosepo, me kumwail netikihla pwe en wisikdohng Isip. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Eri met kumwail dehr nsensuwed de kapwukoahkin kumwail pwehki amwail netikiniehdo wasaht. Pwe mehlel me Koht me ketin kadarodohng ie wasaht mwohmwail pwe I en komourala aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Erein sounpar riau met me lehk lapalap wiewiawi nan sahpwet; oh erein sounpar limau luhwe me sohte koadoahkpen wahnsahpw de dolung wahn sahpw pahn wiawi. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Koht ketin kadariehdo mwohmwail, pwe I en kapitkumwailla ni soangen irair kapwuriamwei wet pwe kumwail en momourte iangahki kadaudokamwail kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Eri kaidehn kumwail me kadariedohng wasaht, ahpw Koht. E ketin wiahkiniehla sapwellimen Parao aramas lapalap. Nghei me pwukoahki wehiet pwon; ngehi me kaunda Isip pwon. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Eri kumwail mwadang pwurowei rehn ei pahpao oh ndaiong me iet dahme nah pwutak Sosep patohwan: ‘Koht ketin kupwuredahr pwe I en wiahla kaunen Isip pwon; komw mwadangodo rehi, komw dehr pwahnd. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Komw pahn kousoanla nan Kosen, wasa me komw kak karanih ie—komwi, noumwi seri kan, nein noumwi seri kan, noumwi sihpw, kuht, kou, oh pil soahng koaros me komwi ahneki. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ma komw pahn kousoan nan Kosen, I pahn kak en apwalih komwi. Pwehki sounpar limau en lehk lapalap me luhwe; oh I sohte men komwi oh omwi peneinei oh noumwi mahn akan en duhpekla.’” ");
INSERT INTO pon2006a_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Sosep ahpw uselahte mahsanih, “Eri kumwail koaros, oh pil kowe Pensamin, kak kilang me ngehi uhdahn Sosep. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kumwail padahkihong ei pahpao duwen manaman me I ahneki nan Isip oh padahkihong soahng koaros me kumwail kilangehr. Eri kumwail mwadangowei oh kahrehdo ei pahpao wasaht.” ");
INSERT INTO pon2006a_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","E ahpw pwoalehdi rie Pensamin oh tapihada tentenihr; Pensamin eri pil sengiseng nindokon ara wie pwoaloapwoal. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Nindokon e wie tentenihr, e ahpw pwoalehdi oh metik emenemen rie ko. Mwuri, rie ko ahpw tapihada koasoieng. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ahnsou me rohng lel nan tehnpaso me rien Sosep kan leledohr, Parao oh sapwellime kan inenen perenkihda. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","E ahpw mahsanihong Sosep, “Komw patohwanohng riomwi kan re en audehda neirail mahn akan oh pwuralahng nan Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Irail en ale arail pahpao oh arail peneieni kan oh pwurodo wasaht. I pahn kihong irail sahpw me keieu mwahu nan Isip, oh re pahn ahneki me pahn depasang irail en mourki. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Komw pil patohwanohng irail en wahla werennansapw akan sang Isip pwe arail pwoud kan oh neirail seri kan oh ar pahpao en kak dake kodohng Isip. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Re en dehr pwunodki arail dipwisou kan nan imwarail kan; pwe re pahn iang ahneki dipwisou kaselel kan en Isip.” ");
INSERT INTO pon2006a_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Nein Seikop pwutak ko ahpw kapwaiada mehkoaros. Sosep kihong irail werennansapw kei, nin duwen me Parao mahsanih, e ketikihong irail katihnaparail ong ar seiloako. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","E pil wilianda en emenemen eh likou kan, e ahpw kihong Pensamin mwohni silper silipwiki oh likou limau. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","E ahpw kadaralahng e pahpao ahs ehk diren kepwe kaselel sang Isip oh ahs ehk diren wahn kohn, pilawa oh pil soangen mehn ketihnain teikan. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ni eh ketin kamwurirailla e ahpw mahsanihong irail, “Kaleke kumwail akakamai kohwei nanialo.” ");
INSERT INTO pon2006a_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Irail eri mweselsang Isip kohkolahng rehn arail pahpa Seikop nan Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Irail ahpw padahkihong arail pahpao, “Sosep momourte, ih me kaunda Isip pwon!” Seikop pwuriamweila oh sohte kak kamehlele irail. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ahpw ni arail koasoiaiong soahng koaros me Sosep mahsanihong irail, oh ni e kilangada werennansapw ako me Sosep kadaralahng pwehn dake kohdihla, ngenen Seikop pa tihnainda. ");
INSERT INTO pon2006a_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","E ahpw nda, “Nei pwutak Sosep momourte, ihte met me I peki! I en kohla kilang mwohn ei pahn mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Seikop eri kihpene eh kepwe kan koaros oh mwesellahng Peersepa, e ahpw wiahda meirong kei ong Koht en seme, Aisek, wasao. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Koht eri mahsanihong Seikop ni kasansal ehu nipwong, mahsanih, “Seikop, Seikop!” E ahpw patohwan sapeng, “Iet ngehi, maing.” ");
INSERT INTO pon2006a_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","E ahpw mahsanih, “Ngehi Koht, Koht en semomw, ke dehr perki kohla Isip; pwe I pahn wiahkihla kadaudokomw kan wehi lapalap ehu wasao. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I pahn iang uhk kohwei Isip, oh I pil pahn kapwurehdo kadaudokomw kan wasaht. Sosep pahn mi rehmw ni omw pahn mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Seikop eri mweselsang Peersepa. Nah pwutak ko eri kidahng Seikop, nair seri tikitik ko, oh ar pwoud ko, pohn werennansapw ko me Parao ketin kadarala pwe re en dake. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Irail eri wahda nair mahn ako, oh iangahki mehkoaros me re ahneki nan Kenan oh mwesellahng Isip. Seikop wa kohdihla kadaudoke kan koaros: ");
INSERT INTO pon2006a_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","nah pwutak ko, nah serepein ko, oh neirail seri ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Tohn peneineien Seikop me iang ih patohlahng Isip iei nah pwutak laud Reupen ");
INSERT INTO pon2006a_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","oh nein Reupen pwutak ko: Anok, Pallu, Esron, oh Karmi. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simion oh nah pwutak ko: Semuel, Samin, Ohad, Sakin, Sohar, oh Saul, nein lih lidu en Kenan men. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lipai oh nah pwutak ko: Kerson, Kohad, oh Merari. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Suda oh nah pwutak ko: Sela, Peres, oh Sera. (Nein Suda pwutak teiko, Er oh Onan, ira mehla nan Kenan.) Nein Peres pwutak iei Esron oh Amul. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakar oh nah pwutak ko: Tola, Pua, Sasup, oh Simron. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sepulon oh nah pwutak ko: Sered, Elon, oh Saleel. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ih met kan pwutak ko me Lia wiahiong Seikop nan Mesopodamia, iangahki Daina. Nah kan koaros sang Lia patpene wiahda me siliakan silimen. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Kad oh nah pwutak ko: Sepohn, Aki, Suni, Espon, Eri, Arod, oh Areli. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser oh nah pwutak ko: Imna, Ispa, Ispi, Peria, oh riarail serepein Sera. Nein Peria pwutak kan iei Eper oh Malkiel. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Me ehk wenemen pwutak iei kadaudok en Seikop sang Silpa, lidu serepein me Lapan kihong nah serepein Lia. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Resel, en Seikop eh pwoud, wiahiong pwutak riemen: Sosep oh Pensamin. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Nan Isip Sosep wiahda pwutak riemen: Manase oh Epraim, sang Asenad, nein Podipera serepein, samworo men nan Iliopolis. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Nein Pensamin pwutak kan iei Pela, Peker, Aspel, Kera, Nahman, Ehi, Ros, Muppin, oh Ard. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Me ehk pahmen pwukat iei kadaudok en Seikop sang Resel. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan oh nah pwutak Usim. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napdali oh nah pwutak ko: Sasehl, Kuni, Seser, oh Sillem. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Me isimen pwukat iei kadaudok en Seikop sang Pila, lidu serepein me Lapan kihong nah serepein Resel. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Eri, irail koaros kadaudok en Seikop ko me kohdilahng Isip me wenehk wenemen, a en nah pwutak ko ar pwoud ko sohte wadohng. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Nein Sosep pwutak riemen me ipwidi nan Isip, eri, irail koaros me kolahng wasao me isiakan. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Seikop eri kadarala Suda mwowe rehn Sosep pwe en peki en tuhwong nan Kosen. Ni ar lel wasao, ");
INSERT INTO pon2006a_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Sosep ahpw ketin kaunopada sapwellime werennansapw oh ketilahng Kosen pwe en tuhwong eh pahpa Seikop. Eri, ni eh tuhwong, e pwoalehdi oh tentenihr ahnsou reirei. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Seikop ahpw ndahng Sosep, “Met I kakehr mehla, ni ei kilanguhkehr oh eseier me ke momourte.” ");
INSERT INTO pon2006a_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Sosep eri mahsanihong rie ko oh eh peneinei, “I pahn kolahng ndahng Parao me peneineien ei pahpao, patohdohsangehr Kenan, wasa re kin koukousoan ie, oh re patodohr rehi. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","I pahn ndaiong me kumwail silepen sihpw kei oh kin apwahpwalih pelinmen kan oh kumwail wa kohdo noumwail pelinmen kan oh mehkoaros me kumwail ahneki. ");
INSERT INTO pon2006a_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Eri, ni Parao eh pahn malipei kumwail oh keinemwe da amwail doadoahk, ");
INSERT INTO pon2006a_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","kumwail pahn sapengki me kumwail kin apwalih pelinmen kan sang ni amwail tikitik, duwen me amwail pahpa kahlap ako kin wia. Pwe ma ih duwe met, e pahn ketin mweidohng kumwail en kousoan nan Kosen.” Sosep mahsanih met pwehki mehn Isip sohte kin mwahuki silepen sihpw kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Sosep eri wahda rie pwutak limmen oh patohla oh patohwanohng Parao, “Semeio oh rie ko patohdihdo sang Kenan, re wa arail tungoal kepwe kan koaros. Re patopato met nan Kosen.” ");
INSERT INTO pon2006a_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ih eri patohwan kapehsehiong Parao rie ko me iang ih. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Parao eri keinemwe rehrail, mahsanih, “Doadoahk da amwail?” Irail patohwan sapeng, “Silepen sihpw kei, kiht, maing, duwehte at tungoal pahpa kahlap ako. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Se patohdohng kousoanla nan sahpw wet, maing, pwe nan Kenan solahr kisin tungoal ong nait pelinmen kan, lehk lapalapet me inenen uk mehlel. Kalahngan en wasa lapalap en ketin kupwurei kiht pwe se en kak patohwan kousoan nan Kosen.” ");
INSERT INTO pon2006a_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Parao eri mahsanihong Sosep, “Ni omwi pahpao oh riomwi kan ar leledohr, ");
INSERT INTO pon2006a_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","irail kak sapwasapw wasa koaros nan Isip pwon. Re kak kousoanla nan Kosen, pwe iei wasa keieu kaselel. Oh ma mie ohl ekei nanpwungarail me koahiek, a komw kak kihong pwe re en kin apwahpwalih nei pelinmen kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Sosep eri patohwando seme Seikop rehn Parao. Seikop eri patohwan kapaiahda Parao. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Parao eri keinemwe reh, “Komw sounpar depe?” ");
INSERT INTO pon2006a_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Seikop ahpw patohwan sapeng, “Ei mour ni ei seiseiloakseli imwiseklahr ni ei sounpar 130. Sounpar malaulau kei met kan oh apwal; ahpw e sohte duwehte sounpar tohto en ei pahpa kahlap ako ni ar seiseiloakseli.” ");
INSERT INTO pon2006a_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Seikop eri sakarada pahn kupwur en Parao; ih eri patopatohla. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Sosep eri koasoanehdi semeo oh rie ko nan Isip, ketikihong irail sapwarail wasa kaselel kei, kereniong kahnimw Rameses, duwen me Parao mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Sosep pil ketikihong semeo, rie ko, oh eh peneinei koaros, iangahki me tikitik kan, kanarail kisin mwenge. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Lehk lapalapo inenen mwuledek mehlel wasa koaros nin sampah, oh mehn Isip oh Kenan re luwetkihla eh sohla mwenge. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Sosep eri ketin kihpene mwohni koaros me mehn Isip oh Kenan pwainkihda ar tungoal pilawa ko. Ih eri ketin nekidala mwohni ko nan tehnpas en Parao. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ahnsou me mwohni en Isip oh Kenan koaros neklahr, mehn Isip ko patohdo rehn Sosep oh patohwanohng, “Komw ketikihong kiht at tungoal kisin mwenge pwe se de mehla. Komw ketin kupwurei kiht, pwe solahr at tungoal mwohni.” ");
INSERT INTO pon2006a_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Sosep ketin sapeng irail, “Kumwail wahdo noumwail pelinmen kan, I ahpw pahn wiliankihong kumwail kisin mwenge, ma solahr noumwail mwohni.” ");
INSERT INTO pon2006a_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Irail eri wadohng Sosep nair pelinmen kan; ih eri ketikihong irail kisin mwenge wiliankihla neirail oahs akan, sihpw oh kuht, kou oh ahs akan. Nan sounparo e ketikihong irail mwenge wiliankihda neiral pelinmen kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Eri, sounpar ehu mwuri, re ahpw pwurala reh oh patohwanohng, “Se sohte pahn patohwan ekihsang komwi, maing, duwen eh solahr at tungoal mwohni oh duwen omwi ketin sapwellimanikilahr nait pelinmen kan. Solahr me se pahn patohwanohng komwi, maing, ihte paliwarat oh at tungoal sahpw akan me luhwehdi. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Komw ketin kupwurei kiht pwe se de patohwan mehla. Komw dehr mweidohng se en luhssang at tungoale sahpw akan. Komw ketikihda at tungoal paliwar akan oh at tungoal sahpw akan wiliankihla kisin mwenge. Se pahn patohwan liduwih Parao oh e pahn ketin nin limankihla at tungoal sahpw akan. Komw ketikihong kiht wahn kohn pwe se en kak mourki oh werentuhke pwe se en padokedi nan aht mohs kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Sosep eri ketin pwainda sahpw akan koaros nan Isip ni mwaren Parao. Emenemen mehn Isip ahpw netikihla sapwe, pwe lehko me inenen mwuledek. Eri, Parao ahpw ketin nin limankihla sahpw akan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Sang apali Isip lellahng apali, Sosep ahpw kaliduwihala aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ihte sahpw me e sohte pwainda, sapwen samworo ko. Re sohte netikihla sapwarail ko, pwe Parao kin ketikihong irail mwohni en sawas pwe re en kin momourki. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Sosep ahpw mahsanihong aramas akan, “Kumwail kilang, I pwainsangkumwailehr sahpw pwukat ni mwaren Parao pwe en nin limankihla. Iet amwail tungoal werentuhke kan, me kumwail pahn kamwarak nan sahpw akan. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Eri, ni ahnsoun dolung wahnsahpw, kumwail pahn kihong Parao limakis ehu. A luhwe kumwail pahn ahnekihla, mehn kamwarak nan sahpw, oh mehn wia amwail tungoal kisin mwenge ong pein kumwail, oh ong amwail peneinei kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Irail eri patohwan sapeng, “Komw ketin komourkitalahr; komwi ketin kupwur mwahu ong kihtehr, maing, eri, se pahn patohwan wiahla sapwellimen Parao lidu.” ");
INSERT INTO pon2006a_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Sosep eri kauwada kosonned ehu ong sahpw akan en Isip, pwe limakis ehun wahnsahpw en kin kohieng Parao. Eri, kosonned wet wie kekehlailte lel rahnwet. Ihte sapwen samworo ko me sohte wiahla nin limen Parao. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Mehn Israel ko eri kousoanla nan Kosen nan wehin Isip; re kepwehpwehla oh nainlahr mehlel. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Seikop koukousoanki Isip sounpar 17, e lao lel sounpar 147. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ni eh kereniongehr mehla, e ahpw ekerodo nah pwutak Sosep oh ndaiong, “Menlau kihdi pehmwen nan dengeie, oh inoukihda me ke pahn loalopwoat oh kadekohng ie, oh sohte pahn sarepiehdi nan Isip. ");
INSERT INTO pon2006a_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","I anahne seridi wasa me semei ko seridi ie. Eri, ke pahn waielahsang Isip, oh sarepiehdi nan ar sousou ko.” Sosep ahpw sapeng, “I pahn kapwaiada kupwuromwien.” ");
INSERT INTO pon2006a_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Seikop eri ndaiong, “Eri, kahukihla me ke pahn kapwaiada inou wet.” Sosep eri kahula, Seikop ahpw wia eh keimwseklahn kaping pohn eh pehto. ");
INSERT INTO pon2006a_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Kedekedeo, pakair ehu ahpw wiawihong Sosep me dene semeo me ekis luwet. Ih eri ketikihda sapwellime pwutak riemeno, Epraim oh Manase, oh ketila rehn Seikop. ");
INSERT INTO pon2006a_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ni Seikop eh rongada me nah pwutak, Sosep, ketiket kodohng reh, e tihnainda oh mwohdada nan dewe peht. ");
INSERT INTO pon2006a_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Seikop eri nadiong Sosep, “Koht, Wasa Lapalap, ketin pwarohng ie nan Lus nan Kenan, oh ketin kupwuramwahwih ie. ");
INSERT INTO pon2006a_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","E mahsanihong ie, ‘I pahn kangederehla noumw seri kan, oh kadaudokomw kan pahn wiahla wehi ngeder. I pahn kihong irail sahpw wet pwe re en sapwenikihla kohkohlahte.’” ");
INSERT INTO pon2006a_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Seikop pil mahsanih, “Eri, I pahn nainekihla noumw pwutak riemen me ipwidier nan Isip mwohn ei pwarodo met. Epraim oh Manase pahn wiahla nei pwutak, duwehte Reupen oh Simion. ");
INSERT INTO pon2006a_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","A seri kan me pahn ipwidi mwurira, kowe me pahn naineki; oh re pahn iang ale sohsohn riarail Epraim oh Manase. ");
INSERT INTO pon2006a_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","I wia met pwe ni ei pwurodo sang Mesopodamia, omw nohno Resel kahrehiong ie lapalahn nsensuwed ni eh mehla nan Kenan, ekis dohsang Eprat. Ngehi eri sarepidi liho wasao, limwahn ahl me kodohng Eprat.” (Eprat iei Pedleem.) ");
INSERT INTO pon2006a_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ni Seikop eh kilangada nein Sosep pwutak ko, e ahpw idek, “Ihs pwutak kan?” ");
INSERT INTO pon2006a_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Sosep eri sapeng, “Ih nei pwutak kan met, me Koht ketikihong ie nan Isip.” Seikop ahpw nda, “Kahreiradohng ie mahs pwe I en kapaiairahda.” ");
INSERT INTO pon2006a_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Mesen Seikop ko ediedlahr pwehki eh ohl laudlahr, oh e sohte kilang mwahu wasa. Sosep eri karehdohng reh nah pwutak ko, a Seikop pwoaloirahdi oh metik ira. ");
INSERT INTO pon2006a_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Seikop eri ndaiong Sosep, “Sohla ei koapworopwor en pwurehng tuhwong uhk, ahpw iet Koht ketin kupwure pwe I en pil tuhwong noumw pwutak kat.” ");
INSERT INTO pon2006a_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Sosep eri kihsang pwutak ko pohn nehn Seikop ko oh poaridi lel nanpwel. ");
INSERT INTO pon2006a_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Sosep eri kihla Epraim palimeing en Seikop a Manase palimaun. ");
INSERT INTO pon2006a_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Seikop ahpw kapisereihdi peh ko oh kihdi peh palimaun pohn moangen Epraim me tikitiko, a peh palimeing pohn moangen Manase me laudo. ");
INSERT INTO pon2006a_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ih eri kapaiahda Sosep patohwan, “Koht me semei ko, Eipraam oh Aisek, kin papah, en ketin kupwuramwahwih pwutak kat! Koht me ketin kakahluwa ie lel rahnwet, en ketin kupwuramwahwih ira! ");
INSERT INTO pon2006a_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Tohnlengo me ketin kapitiesang nan me suwed koaros, en pil ketin kupwuramwahwih ira! Mwarei, oh mwaren semei ko Eipraam oh Aisek, en poatopoatete rehn pwutak kat! Ira en neitik seri tohto, oh kadaudokara kan en ngeder!” ");
INSERT INTO pon2006a_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ni Sosep eh kilang duwen semeo eh kihdiong pohn moangen Epraim peh palimaun, e ahpw nsensuwedkihla. Ih eri kihsang pehn semeo pohn moangen Epraim pwe en kidahng pohn moangen Manase. ");
INSERT INTO pon2006a_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","E ahpw ndaiong semeo, “Ipa, kaidehkin ih pahn duwe men. Pwe iet me laudo; eri, kihdiong powe pehmw palimaunen.” ");
INSERT INTO pon2006a_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Semeo ahpw sapeng, nda, “I ese, samwa, I ese. Kadaudok en Manase kan pahn pil wiahla wehi lapalap ehu. Ahpw rie me tikitiket pahn lapalapasang, oh kadaudoke kan pahn wiahla wehi ngedehrie.” ");
INSERT INTO pon2006a_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ih eri kapaiairahda rahno, ketihtihki, “Mehn Israel kan pahn kin kapaiahda aramas akan ni edomwa. Re pahn nda, ‘Koht en ketin kupwurei kumwail pwe kumwail en duwehte Epraim oh Manase.’ ” Ih duwen met Seikop eh mwohnekihla Epraim sang Manase. ");
INSERT INTO pon2006a_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Seikop eri ndahng Sosep, “Kilang, pwe I nektehn mehla, a Koht pahn ketin ieiang uhk, oh e pahn ketin kahreiukalahng nan sapwen omw pahpa kahlap ako. ");
INSERT INTO pon2006a_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Kowe me I pahn kihong Sekem, a kaidehk riomw ko. Sekem wasa kaselelo me I kalowehkihdi nei kedlahs oh kesik ketieu sang mehn Amor.” ");
INSERT INTO pon2006a_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Seikop eri ekerpene nah pwutak ko oh patohwanohng irail, “Kumwail pokonpene, pwe I pahn ndaiong kumwail dahme pahn wiawihong kumwail ni ahnsou kan me pahn kohdo: ");
INSERT INTO pon2006a_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Kumwail nein Seikop kan, kumwail pokonpene oh rong. Kumwail rong amwail pahpa, Israel. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Reupen, kowe, me nei mesenih, kowe me ei kehl, oh tepin wahnedi. Kowe me keieu aklapalap oh keieu kehlail rehn nei pwutak kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ke rasehng ahden lapake kehlail, ahpw ke sohte mwahn pahn lapalapala, pwehki omw wiahiong nsenen pwopwoud rehn ei pekehio oh kasaminehla en omw pahpa eh peht. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simion oh Lipai pirien. Ira kin doadoahngki neira kedlahs ong ni pei eikek. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","I sohte pahn iang ira nan ara koasoandi kan, I sohte pahn iang ira nan ara mihting kan, pwehki ara kemelahr aramas nan ara lingeringer oh kauwehla nehn kouwol akan wiahki ara mehn mwadong. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ira en riahkihla ara lingeringer, pwehki eh nohn uk, oh ara mwakar, pwehki eh nohn laud. I pahn kihirapeseng nan Israel; I pahn keseirahla rehn mehn Israel kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“A kowe, Suda, riomw kan pahn kapingaiuk. Ke kolokol tepinweren omw imwintihti kan. Riomw kan pahn poaridi mwohmw. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Suda rasehng laion emen, me kin kemehla seike oh sapahlih nan pese, me kin kedengideng oh wendiong nanpwel, oh sohte me kak katairong limwah. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Suda pahn kin kolokol sokon en nanmwarki, manaman en kaunda wasa pahn mihmiehte rehn kadaudoke kan. Wehi teikan pahn nohpweiong oh poaridi mwowe. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","E kin saliediong sapwellime ahs nin tuhken wain, ni rahn wain me keieu kaselel. E kin kamwakelehki wain weitahta me duwehte nta sapwellime likou kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Pwoaren mese ko weitahtakihla eh kin nim wain. Ngih ko pwetepwetikihla eh kin niminim milik. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sepulon pahn kousoan ni keilen sehd. Eh oaroahr pahn wia wasahn peidien sohp kan. Oh sapwe pahn lellahng wehin Saidon. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakar, iei ahs kehlail emen me kin wonohn dengpeseng nanpwungen eh mehn wisik kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","E kilangada duwen mwahu en eh wasahn kommoaldi oh duwen kaselel en sahpwo. eri e kaidi tihnsewe pwe en wahda eh wisik oh idihdohng en doadoahk duwehte lidu. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan pahn wia kaunen tohn eh wehi. Re pahn duwehte kadaudok teikan en Israel. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan pahn rasehng sineik emen limwahnial, sineik me pwoisin suwed me wonohn limwahnial, me kin kehpene nehn oahs, pwe soundake oahs en dikousang powe. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Maing KAUN, I awiawihete sapwellimomwi komour. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Pwihn loallap suwed ehu pahn peiong Kad, ahpw e pahn sohpeiong irail oh pwakihirailda. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Sapwen Aser pahn kapwarehda wahnsahpw mwahu. E pahn kaunopohng nanmwarki kan konotarail me konehng. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Napdali rasehng tie men me kin tangatangseli ni saledek, me kin naitikihada nah me kaselel kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Sosep rasehng ahsen wel men, limwahn utuhnpihl pwoat, ahsen wel men ni keilen nahna. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Eh imwintihti kan pahn mahweniong oh pwakihki neirail kesik ketieu kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ahpw eh pahn kadangpeseng nah kesik ketieu oh sohte rerrer, oh peh kan pahn kin kehlailki manaman en Koht Lapalap en Seikop, oh mwaren Silepeo, Soundoarepen Israel. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Koht en semomw me sawasepomw, Koht Wasa Lapalap me kin kupwuramwahwihkinuhk kapaien keteu sang nanleng oh sang ni pwarer loal akan pahn pwehl, kapaien kou tohto oh seri ngeder, ");
INSERT INTO pon2006a_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","kapaien wahn pilawa oh wahntuhke kan, kapaien atail pahpa kahlap ako, soahng kansenamwahu kan en dohl poatopoat kan. Kapai pwukat en kohdiong pohn tapwin Sosep, pohn temwen me pilipildahr rehn rie ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Pensamin rasehng kidi en wel. Nimenseng oh nin soutik e kin kemehla oh kangala seike kan.” ");
INSERT INTO pon2006a_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ih met kan kadaudok eisek riaun Israel, oh ih met me samarailo ndaiong irail ni eh wia sapwellime mahsen en kamwurumwur ong emenemen sapwellime pwutak ko. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Seikop eri kehkehlingkihong nah pwutak ko, nda, “Met I pahn kolahng milahr rehn ei aramas me melahr ako. Kumwail sarepiehdi rehn semei ko nan peden paip me mi nan sapwen Epron, mehn Id, ");
INSERT INTO pon2006a_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","nan Makpela ni palimesehn Mamre, nan Kenan. Eipraam pwainda peden paip wet oh sahpw wet sang rehn Epron, mehn Id, pwe en wia eh wasahn sousou. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ih wasao me re sarepedi ie Eipraam oh eh pwoud Sara; ih wasao me re sarepedi ie Aisek oh eh pwoud Repeka; oh ih wasao me I pil sarepidi ie Lia. ");
INSERT INTO pon2006a_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Peden paipo oh sahpwo pweipweida sang rehn mehn Id. Kumwail sarepiehdi wasao.” ");
INSERT INTO pon2006a_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Eri, ni Seikop eh kaimwisekala eh kehkehlik pwukat ong nah pwutak ko, e ahpw kainenehla neh ko pohn pehto oh imwisekla. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Sosep eri ketin poaralahng pohn kahlep en semeo, tentenihr oh metimetik meseo. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ih eri mahsanihong toakte ko me kin papah, re en kihong wini ni kahlep en eh pahpao. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Re ahpw winiwiniehki erein rahn 40, uwen reireien ahnsou me wini kin kohieng ni kahlep en aramas mehla. Mwuhr, mehn Isip ahpw mwahieiki Seikop erein rahn 70. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ahnsoun mwahieio lao imwisekla, Sosep ahpw mahsanihong sapwellimen Parao lapalap ako, “Kumwail menlau padahkihong Parao pakair wet: ");
INSERT INTO pon2006a_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Ni ei pahpao eh pahn mehla, e patohwan peki rehi, I en inoukihong, me I pahn sarepedi nan sousou me e kaunopadahr nan Kenan. Eri, komw kupwurkalahngan mweidohng pwe I en patohla sarepedi semeio, I ahpw pahn patohwan pwurodo.’” ");
INSERT INTO pon2006a_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Parao ahpw sapeng, mahsanih, “Komw ketiwei sarepedi semomwen, duwen omwi ketin inoukihong.” ");
INSERT INTO pon2006a_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Sosep eri ketila sarepedi semeo. Sapwellimen Parao lapalap koaros, me mah kan, oh kaun akan koaros en Isip, ahpw iang Sosep patohdahla. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","En Sosep eh peneinei koaros, rie ko, oh peneineien eh pahpao pil iang ih kohla. Ihte seri tikitik ko, nair pelinmen kan, sihpw, kuht, oh kou kan, me sohte iang, pwe re mihmihte nan Kosen. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Aramas me dake werennansapw oh me dake oahs akan pil iang patohdahla; lapalahn pokon ehu me wia kaparo. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ni arail lel wasahn kamwakele kohn nan Atad, ni palimesehn Sordan, re wiahda sarawi lapalap oh reirei ehu en mwahiei. Sosep eri mwahieiki eh pahpao erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ni pwilidak en Kenan ko ar kilangada sarawien mwahieio nan Atad, re nda, “Sarawi lapalap ehu met rehn mehn Isip kan.” Iei kahrepen wasao eh adanekihla Apel Misraim. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Nein Seikop pwutak ko eri kapwaiada dahme arail pahpao kehkehlingkihong irail. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Re walahng nan Kenan, oh sarepedi nan poaren paipo nan Makpela, palimesehn Mamre, wasa me Eipraam pwainsang Epron, mehn Id, pwe en wiahla eh wasahn sousou. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Mwurin Sosep eh sarepedier semeo, e ahpw sapahllahng Isip, iangahki rie ko, oh pil irail koaros me iang patohdahla sarepedi Seikop. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Eri, mwurin mehlahn arail pahpao, rien Sosep ko ahpw patohwan, “Ia duwe, ma Sosep pahn ketin kadakadaur eh kailongkin kitail, oh men dupukohng kitail suwed me kitail wiahiong?” ");
INSERT INTO pon2006a_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Irail eri kadaralahng Sosep ilek ehu me ketihtihki, “Mwohn samatailo eh sipalla, ");
INSERT INTO pon2006a_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","e kehkehlingkihong kiht se en padahkihong komwi, ‘Menlau mahkikihong riomw kan sapwung me re wiahiong uhk.’ Eri, komw kupwurei kiht oh ketin mahkikihong kiht sapwung wet me kiht, ladun Koht en semomwio, wiadahr.” Sosep ahpw tentenihr ni arail patohwanohng mepwukat. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Rie ko eri piserwarodohng reh oh poaridi mwowe, patohwanohng, “Iet kiht sapwellimomwi lidu sohwar ekei.” ");
INSERT INTO pon2006a_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Sosep ahpw mahsanihong irail, “Kumwail dehr perki mehkot. I sohte kak wiliandi Koht. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Kumwail koasoanehdi kumwail en wiahiong ie me suwed, Koht ahpw ketin kawekiong ni mehkot mwahu, pwe en doarehla mouren aramas ngeder me momourkier rahnwet irair me wiawihero. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Eri, sohte mehkot kumwail pahn masak. I pahn apwalih kumwail oh noumwail seri kan.” Ih duwen eh ketin kakehlakahkinirailda mahsen pwukat me lel oh kamwakidada kapehdirail kan. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Sosep eri ketiket nan Isip rehn peneineien eh pahpa; e sounpar 110 ahnsou me eh sipalla. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","E ieiasete e lao ketin udiahl nein Epraim nah seri ko, oh pil nein nah seri ko. E pil ieiasete ni ahnsou me Makir nein Manase, nah seri ko ipwidi. ");
INSERT INTO pon2006a_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ih eri mahsanihong rie ko, “I nektehn mehla, ahpw Koht pahn ketin apwalih kumwail oh pahn ketin kahluwaikumwailsang nan sahpwet kahluwaikumwaillahng nan sahpw me e ketin inoukihong Eipraam, Aisek oh Seikop.” ");
INSERT INTO pon2006a_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Sosep eri peki rehn mehn Israel ko pwe re en wiahda inou ehu. E mahsanihong irail, “Kumwail inoukihong ie, me ahnsou me Koht pahn ketin kahluwaikumwaillahng nan sahpwo, kumwail pahn wahda paliwereiet.” ");
INSERT INTO pon2006a_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Sosep eri sipalla ni eh sounpar 110. Irail eri kihong wini ni kahlepeo oh kihdiong nan kohpwa. ");
INSERT INTO pon2006a_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Iet eden nein Seikop pwutak ko me iangih kohdihla Isip, emenemen irail iangahki eh peneinei: ");
INSERT INTO pon2006a_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reupen, Simion, Lipai, Suda, ");
INSERT INTO pon2006a_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakar, Sepulon, Pensamin, ");
INSERT INTO pon2006a_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Napdali, Kad, oh Aser. ");
INSERT INTO pon2006a_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Eri, koaros me uhdahn kisehn kadaudok en Seikop patpene me isiakan. A Sosep ketiketier nan Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Eri, Sosep oh rie ko, iangahki diho koaros, melahr. ");
INSERT INTO pon2006a_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Kadaudokarail ko, mehn Israel ko, ahpw kaparaparala oh inenen tohtohla; re pil kehlailla oh audehla wasa koaros nan sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Eri, nanmwarki kapw emen, me sohte mwahn mwahngih duwen Sosep, ahpw kesepwilda nan Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","E ahpw mahsanihong sapwellime aramas akan, “Kumwail kilang duwen mehn Israel kan ar wie tohtohla oh kehlailasang kitail. Met keper mehlel ong kitail. ");
INSERT INTO pon2006a_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Eri, e konehng kitail en wiahiong irail ehu koasoandien pwe re dehr tohtohla. Pwe, ni ahnsoun mahwen, re de miniminiong atail imwintihti kan oh mahweniong kitail, oh pil lipalahsang rehtail.” ");
INSERT INTO pon2006a_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Eri, mehn Isip ko koasoanediong arail kaunen doadoahk pwe re en kin itonehng irail nan doadoahk apwal re lao luwetala. Iei mehn Israel ko me kauwadahng Parao kahnimw kan en Pitom oh Rameses, wasahn nekidala mwenge. ");
INSERT INTO pon2006a_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Eri soh, ni uwen mehn Isip ar kaloke mehn Israel ko, re pil tohtohlahsang mahs oh parpeseng wasa koaros nan sahpwo. Mehn Isip ko eri masakala mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Re kin itonehng irail nan mour apwal en kalidu oh nan doadoahk laud en wiahda ihmw, oh pil soangen doadoahk koaros en nansapw. Re sohte kin poakeirailla. ");
INSERT INTO pon2006a_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Nanmwarkien Isip ahpw pil mahsanihong Sipra oh Pua sounkeneitik ko, me kin sewese lihen Ipru ko, ");
INSERT INTO pon2006a_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Ni amwa pahn kin sewese kanaitikih lihen Ipru kan, ma serio ipwidi kisin pwutak, a kumwa kemehla; a ma kisin serepein, a kumwa kamourala.” ");
INSERT INTO pon2006a_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ahpw sounkeneitik ko, lih masak Koht riemen, ihme ira sohte peikikiong nanmwarkio; pwe ira kin kamourala kisin pwutak kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Nanmwarkio eri malipeirahdo, oh keinemwe rehra, “Dahme kumwa kin kamourkihla seri ohl akan?” ");
INSERT INTO pon2006a_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Lih ako eri sapeng, patohwan, “Lihen Ipru kan sohte duwehte lihen Isip kan; pwe re kin mengei en neitik, oh serio kin ipwidi mwohn sounkeneitik eh kin lel rehrail.” ");
INSERT INTO pon2006a_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Eri, Koht ketin kupwurehla sounkeneitik ko, oh mehn Israel ko pil wie tohtohlahte oh kekehlailla. ");
INSERT INTO pon2006a_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Pwehki sounkeneitik ko ara masak Koht, Koht ketikihong ira neira seri tohto. ");
INSERT INTO pon2006a_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Parao eri mahsanihong sapwellime aramas koaros kosonned wet: ‘Kumwail kesehla nan Pillap Nail seri ohl koaros me ipwidihsang mehn Ipru kan, a kumwail kamourala serepein koaros.” ");
INSERT INTO pon2006a_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ohl emen me kisehn kadaudok en Lipai ahpw pwoudikihda lih emen me kisehn kadaudokohte. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Liho eri naitikihada kisin pwutak kis. Ni eh kilangada uwen kaselel en nah kisin pwutako, e ahpw ekihla erein sounpwong siluh. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ni eh solahr kak ekieki, e ahpw ale kopwou ehu me wiawihkihda ahlek oh litopwiheki tahr. Ih eri kihdiong loale kisin serio, oh pwilikihdi nan pelien ahlek ehu ni keilen pillapo. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","A rien kisin serio serepein men ahpw kesikesihnen kailalahsang, mwasamwasahn dahme pahn wiawihong serio. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Kedekedeo, sapwellimen Parao serepeino ahpw patohdilahng duhdu ni pillapo, oh nah papah kan wie mwemweitseli ni keilen pillapo. Ih eri kilangada kopwowo nan pelien ahlek en pillapo, e ahpw ilakih emen eh lidu ko en wadohng. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","E ahpw pahkada kopwowo oh kilangada loale kisin pwutak pwelel kis, me wie sengiseng. E ahpw poakepoakehda oh nda, “Ih emen nein mehn Ipru ko seri met.” ");
INSERT INTO pon2006a_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Rien kisin pwutako serepeino ahpw idek reh, “E soh mwahu I en patohla ekerodo emen lihen Ipru en, pwe en apwalihong komwi serien?” ");
INSERT INTO pon2006a_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","A e sapengki, “Nna, tangowei!” Serepeino eri tangala oh ekerodo en serio eh nohno. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Sapwellimen Parao serepeino ahpw ndahng, “Menlau ale seri pwelel menet oh apwalihada, I ahpw pahn pwainohng uhk.” Liho eri ale serio oh apwalihada. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ni serio eh laudla, e ahpw wahla rehn sapwellimen Parao serepeino, me pwekada oh wiahkihla uhdahn nah. Serepeino ahpw nda, “I kihsang seri menet nan pihl.” Ihme e kihongki ede Moses. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Kedekedeo, ni Moses eh laudlahr, e ahpw kohieilahng kilang kiseh kan, e ahpw kilangada duwen apwal en doadoahk me idihdiong re en wia. E kilangada mehn Isip men eh kemehla emen kiseh ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Moses eri kilikilengseli ma mie aramas, oh ni eh sohte kilangada emen, e uhdahte kemehla mehn Isipo, oh ekihla paliwereo nan pihk. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Mandahn rahno e pwureila oh kilangada mehn Ipru riemen ara pepei. Ih eri ndaiong me sapwung rehrao, “Dahme ke kemekemehki riomwen me uhdahn kisehmw?” ");
INSERT INTO pon2006a_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","A ohlo sapeng, nda, “Ihs me kilelehdi me komwi en kaunkitada oh kadeingkitada? Komw pahn kemeiehla duwehte omwi kemehla mehn Isipo?” Moses ahpw masepwehkada oh mengimengloalki, “Aramas akan esedahr dahme I wiadahro.” ");
INSERT INTO pon2006a_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","16","Ni Parao eh karongehda met, e ahpw song en kemehla Moses. Moses ahpw tangasang, tangala kousoanla nan Midian. Rahn ehu, e ahpw mwomwohd limwahn pwarer ehu, a nein samworoun Midian men, ede Sedro, nah serepein isimen, re ahpw kohieilahng idipil oh audehda dewen pihlo, mehn kanimpile nein ar pahpao sihpw oh kuht kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","A silepen sihpw kei ahpw pwakihasang nein Sedro serepein ko wasao. Moses ahpw doareirailla, oh kanimpile nair mahn akan. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ni ar pwuralahng rehn arail pahpa, e ahpw idek rehrail, “Dahme kumwail mwadang en pwurkihdo rahnwet?” ");
INSERT INTO pon2006a_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","A irail sapeng, nda, “Ahki mehn Isip men me doareikitala sang silepen sihpw ko, oh pein ih idipiliong kiht oh kanimpile nait mahn akan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ohlo ahpw idek rehrail, “A ia ih? Dahme kumwail sohte kahrehkihdo met? Kumwail pwurowei, ndaiong en kodohng tungoal rehtail.” ");
INSERT INTO pon2006a_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moses eri lemehda en kousoanla wasao. Sedro eri kihong nah serepein Sipora pwe en pwoudikihda. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sipora eri naitikihada nah pwutak emen, me Moses kihong ede Kersom, pwehki eh nda, “Ngehi mehn liki men nan sapwen liki wet.” ");
INSERT INTO pon2006a_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Kedekedeo, nanmwarkien Isip ahpw sipalla, ahpw mehn Israel ko wie lokolokete nan ar mouren kalidu, oh wie sengisengloalki ar men ale sawas. Ngilarail kan leldalahng rehn Koht, ");
INSERT INTO pon2006a_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Koht eri ketin karonge arail pekipek, oh pil ketin tamanda inou me e ketin wiahiong Eipraam, Aisek oh Seikop. ");
INSERT INTO pon2006a_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","E ketin kupwurehla en mehn Israel ko ar kaliduhla, oh ketin kasalehiong irail pein ih. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Rahn ehu Moses wie apwahpwalih nein en eh pwoudo eh pahpao, Sedro, samworoun Midian, nah sihpw oh kuht kei. E ahpw kahre pelinmen ko kotehla sapwtehn, kolahng Sainai, nahna sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Tohnleng en KAUN-O men ahpw pwarohng ni mwomwen mpwulen kisiniei me mpwumpwulsang nan kisin tuhke kis. Moses kilangada duwen kisin tuhkeo eh mpwumpwul, ahpw sohte roangala. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","E ahpw mengimengloalki, “Soahng kapwuriamwei wet, dahme kisin tuhke pwoatet sohte roangkihla? I pahn keila oh tehk mahs.” ");
INSERT INTO pon2006a_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ni KAUN-O eh mahsanihada eh keikeidohng kadehde kisin tuhkeo, e ahpw mahsen sang nan tuhkeo, mahsanih, “Moses! Moses!” E ahpw sapeng, patohwan, “Iet ngehi, maing.” ");
INSERT INTO pon2006a_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Koht ahpw ketin mahsanih, “Ke dehr keido met. Kihsang omw suht kan, pwe wasa me ke mihmi ie wasa sarawi ehu. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ngehi me Koht en semomw kan, Koht en Eipraam, Koht en Aisek, oh Koht en Seikop.” Moses eri perehla meseo, pwehki eh lemmwiki udiahl Koht. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","KAUN-O eri mahsanih, “I mahsaniher uwen lokolok laud en nei aramas akan nan Isip; I rongehr ar pekipeki sawas pwehki ar kaun kan me lemei. Ei, I dehdehkiher uwen ar lokolok laud. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Eri, I kohdidohng kapitasang irail rehn mehn Isip kan, oh kahreirailsang nan sahpwo, kahreiraillahng nan sahpw kaselel oh pwelmwahu ehu, sahpw ehu me reken mwenge oh kepwe, me ahnsou wet mehn Kenan, mehn Id, mehn Amor, mehn Peres, mehn Ip, oh mehn Sepus kin kousoan ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","I karongeier ngilen nei aramas akan. I mahsaniher uwen lokolok laud me mehn Isip kan kin wiahiong irail. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Eri, met I pahn kadaruhkowei rehn Parao, pwe ke en kahluwahsang nei aramas akan, mehn Israel, nan Isip.” ");
INSERT INTO pon2006a_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moses ahpw patohwanohng Koht, “Maing, ihs ngehi pwe I en patohla rehn Parao, oh kahluwahsang mehn Israel kan nan Isip?” ");
INSERT INTO pon2006a_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","A Koht ketin sapeng, mahsanih, “I pahn kin ieiang uhk; oh iet kadehdepen me ngehi me kadaruhkowei: ni omw pahn kahluwahsang nei aramas akan nan Isip, ke pahn kaudokiong ie pohn nahna wet.” ");
INSERT INTO pon2006a_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moses ahpw patohwan sapengki, “Ni ei pahn patohla rehn mehn Israel ko oh patohwanohng irail, ‘Koht en samamwail ko ketin poaroneiedohng kumwail,’ a ma re patohwan idek rehi, ‘Ia mwaren Koht menet?’ Eri, dahme I pahn sapengkin irail?” ");
INSERT INTO pon2006a_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Koht ahpw ketin mahsanih, “Ngehi iei uhdahn ngehi. Ke pahn ndaiong irail, ‘Me kin mwarenki NGEHI IEI, iei ih me ketin kadariedohng kumwail.’ ");
INSERT INTO pon2006a_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ndaiong mehn Israel ko, me ngehi, KAUN-O, Koht en amwail pahpa kahlap ako, Koht en Eipraam, Aisek, oh Seikop, me kadaruhkowei rehrail. Ih mwarei en met kohkohlahte; ih me dih koaros pahn kin kamwarehkin ie kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Eri, kohwei oh kapokonepe kaun akan koaros en Israel oh patohwanohng irail, me ngehi KAUN-O, Koht en arail pahpa ako, Koht en Eipraam, Aisek oh Seikop, ketin pwarohng uhk. Ndaiong irail me I mahsaniher dahme mehn Isip kan wiewiahiong irail. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Eri, I koasoanedier me I pahn kahluwairail sang Isip, wasa me irail wie lokolok laud ie, kahreiraillahng nan sapwen mehn Kenan, mehn Id, mehn Amor, mehn Peres, mehn Ip, oh mehn Sepus kan. Sahpw kaselel ehu met, me reken kepwe oh kisin mwenge. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Nei aramas akan pahn rong dahme ke pahn ndaiong irail. Eri, ke pahn iang kaunen Israel kan kohla rehn nanmwarkien Isip oh ndaiong, ‘KAUN-O, Koht en mehn Ipru kan, ketin kasalehiongkitehr pein ih. Eri, komw ketin mweidohng kiht pwe se en wia at seiloak en rahn siluh kolahng nan sapwtehn, pwe se en wia at meirong ong KAUN-O, at Koht.’ ");
INSERT INTO pon2006a_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","I mwahngiher me nanmwarkien Isip sohte pahn mweidohng kumwail en kohkohsang nan Isip, ma I sohte pahn idingki. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ahpw, I pahn doadoahngki ei manaman oh kalokehki Isip soahng kapwuriamwei kei me I pahn wiahda. Mwurin mwo, e ahpw pahn mweidkumwailla. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“I pahn pil sewese pwe nei aramas akan en keniken rehn mehn Isip kan, pwe ni amwail pahn mweselsang wasao, kumwail dehr mwesel kahiep. ");
INSERT INTO pon2006a_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Lih koaros pahn peki rehn kompoakeparail lih akan, oh rehn mehn mparail kan, likou oh dipwisou kesempwal en silper oh kohl. Kumwail eri pahn kapwatahkihda noumwail pwutak oh serepein kan, oh kumwail pahn wahsang dipwisou kan nan Isip.” ");
INSERT INTO pon2006a_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moses ahpw patohwan sapengki KAUN-O, “A ma mehn Israel kan sohte pahn kamehlele ie, oh sohte men rong ei pato kat, dahme I pahn wia ma re patohwan me komwi sohte mwahn pwarohng ie?” ");
INSERT INTO pon2006a_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","KAUN-O ahpw ketin keinemwe reh, “Dahme ke kolokolen?” A e patohwan, “Sokon pwoat.” ");
INSERT INTO pon2006a_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","KAUN-O eri mahsanih, “Kesehdiong nanpwelen.” Moses kesehdiongete nanpwehlo, a e wiahla sineik men. Moses ahpw pitipitte pweieklahsang. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","KAUN-O eri mahsanihong Moses, “Met, kapahwei pehmwen oh ale pwadaikien, pwekada.” Moses eri kapahla peho, ale pwadaikio, pwekada; e ahpw pwurehng wiahla sokon. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","KAUN-O eri mahsanih, “Eri, ke pahn wia met pwe re en kamehlele me KAUN-O, Koht en arail pahpa kahlap ako, Koht en Eipraam, Aisek, oh Seikop, pwarohng uhk.” ");
INSERT INTO pon2006a_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","KAUN-O pil pwurehng mahsanihong Moses, “Kapwadolong pehmwen nan omw likowen.” E ahpw kapwaiada; oh ni eh kapwadeisang, peho diren tokutoklahr, diren mwahi pwetepwet, duwehte sinoh. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","KAUN-O ahpw mahsanih, “Pwurehng kapwadolong pehmwen nan omw likowen.” E ahpw kapwaiada, oh ni eh kapwadeisang, sohte mehkot ie, pwe me inenen mwahu duwehte wasa teikan en paliwere. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","KAUN-O ahpw mahsanih, “Ma re sohte kamehlelehkin uhk kilel keieuo, a re pahn kamehleleiuk ni kilel keriau wet. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ma re sohte kamehlele kilel riau wet, oh sohte men rong uhk, eri, ke pahn ale ekis pihl sang nan pillapo oh wudekihdiong pohn pwehl madekeng. A pihlo pahn wekila, wiahla nta.” ");
INSERT INTO pon2006a_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","A Moses patohwan, “Maing, KAUN, komw dehr ketin poaroneiehla. I sohte kin kak pato mwohn pokon, a met ni omwi pil mahseniong ie, I pil sohte kakohng. I me soakoahiek en pato, oh loweiet me toutou.” ");
INSERT INTO pon2006a_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","KAUN-O ahpw mahsanihong, “Ihs me kin wiahda ewen aramas? Ihs me kin kalohtengihala de kasalengeponehla aramas? Ihs me kin wiahiong mesen aramas pwe en kilang wasa? De ihs me kin kamaskunihala aramas? Iei Ngehi, KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Eri, kohwei! Pwe I pahn seweseiuk pwe ke en kak lokaia, oh I pahn padahkihong uhk dahme ke pahn nda.” ");
INSERT INTO pon2006a_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","A Moses patohwanohng, “Maing, komw ketin poaronehla emen tohrohr.” ");
INSERT INTO pon2006a_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","KAUN-O eri ketin engiengda pahn Moses oh mahsanih, “Ia duwen Aaron, riomwo, me kisehn Lipai? I mwahngih duwen eh kadek lokaia. Ien ih, e kohkodohng tuhwong uhk, e pahn perenda ni eh pahn tuhwong uhk. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ke kak padahkihong dahme e pahn nda. Eri, I pahn sewesei kumwa koaros ni amwa pahn lokaia, oh I pahn padahkihong kumwa koaros dahme kumwa pahn wia. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","E pahn wilianuhkedi oh koasoi mwohn aramas akan. Eri, ke pahn rasehng Koht ni omw pahn audehki dahme e pahn koasoia. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Eri, ale sokon pwoatet, me ke pahn wiahkihda soangen manaman kei.” ");
INSERT INTO pon2006a_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mwurin met, Moses ahpw pwuralahng rehn Sedro, en eh pwoudo eh pahpa, oh ndaiong, “Komw menlau mweidohng ie I en pwurala rehn kisehi ko nan Isip pwe I en kadehde ma re momourte de soh.” Sedro eri kemwurimwuriong. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","KAUN-O ketin mahsanihong Moses nan Midian, “Eri, pwurowei nan Isip; pwe irail koaros me men kemeiukala, re melahr.” ");
INSERT INTO pon2006a_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moses eri ale eh pwoud oh nah seri kan, e ahpw kidahng pohn ahs emen oh pwuralahng Isip. E pil wa sokono me Koht ketikihong. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","KAUN-O eri pil pwurehng mahsanihong Moses, “Eri met, ni omw pahn pwurowei Isip, ke uhdahn pahn wiahda mwohn Parao manaman koaros me I kihonguhkehr. I pahn kakeptakaila nan kapehde, oh e sohte pahn mweidohng aramas akan en kohkohsang reh. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ke ahpw pahn patohwanohng Parao, me Ngehi, KAUN-O, mahsanih: ‘Israel, iei nei mesenih. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","I padahkihongkomwiher, komwi en mweidohng Israel en kohkohla, pwe en kak kaudokiong ie; komw ahpw sohte mweidohng. Eri, met I pahn kemehla sapwellimomwi pwutak mesenihen.’” ");
INSERT INTO pon2006a_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","KAUN-O ketin tuhwong Moses wasa me re komkommoal ie nindokon ar seiseiloaklahng Isip oh song en kemehla. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Eh pwoudo, Sipora, ahpw alehte kisin takai keng kis, serehsang imwin kilin dundun en nah pwutako, oh kasairehki ntao nehn Moseso. Pwehki sarawien sirkumsais, e ahpw nda, “Kowe uhdahn ei pwoud ni nta.” KAUN-O eri ketin mweidohng Moses en momourte. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Mwurin ahnsou kis, KAUN-O ahpw mahsanihong Aaron, “Kohwei nan sapwtehn, pwe ke en tuhwong Moses.” Ih eri patohla pwe en tuhwong Moses nin nahna sarawio; ni eh tuhwong, e ahpw metik. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moses eri patohwanohng Aaron mehkoaros me KAUN-O ketin mahsanihong ni eh ketin poaronehla, oh pil manaman koaros me KAUN-O ketin koasoanehdiong en wia. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moses oh Aaron, ira eri patohla oh kapokonepene kaun koaros en Israel. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron eri patohwanohng irail mehkoaros me KAUN-O mahsanihong Moses, ih eri pil wiahda manaman ko koaros mwohn masarail kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Irail eri kamehlelehla, oh ni ar rongada me KAUN-O ketidohr rehrail oh mahsaniher duwen ar lokolok, re ahpw poaridi oh pwongih. ");
INSERT INTO pon2006a_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Moses oh Aaron eri patohla rehn Parao oh patohwanohng, “KAUN-O, Koht en Israel, ketin mahsanih, ‘Komw ketin mweidala pwe nei aramas akan en patolahng kaudokiong ie nan sapwtehn.’” ");
INSERT INTO pon2006a_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Parao eri ketin sapeng, “Ihs KAUN-O menen, pwe I en dukiong oh mweidohng Israel en kohkohweisang rehi? Eri, I soh mwahn ese KAUN-O; oh I sohte pahn mweidohng Israel en kohkohla.” ");
INSERT INTO pon2006a_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","A ira ahpw patohwanohng, “Koht en mehn Ipru kan, ih me ketin pwarohng kiht. Eri, komw ketin mweidohng kiht se en wia seiloak en rahn siluh ong nan sapwtehn pwe se en kaudokiong KAUN-O, at Koht. Pwe ma se sohte pahn kapwaiada, e pahn ketin kalokehkin kiht soumwahu suwed de mahwen.” ");
INSERT INTO pon2006a_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Nanmwarkien Isipo eri mahsanihong Moses oh Aaron, “Dahme kumwa lidiliderehki aramas akan nan ar doadoahk? Kumwa pwurowei doadoahk pwe kumwa lidu riemen! ");
INSERT INTO pon2006a_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kumwa kilang ia uwen tohtohlahn aramas en Ipru kan sang pwilidak en sahpwet. A met, kumwa men re en kommoaldihsangehr ar doadoahk!” ");
INSERT INTO pon2006a_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Eri, rahnohte Parao koasoanediong mehn Isip ko me wia kaunen lidu ko oh kaunen Israel kan: ");
INSERT INTO pon2006a_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Kumwail dehr pwurehng kihong aramas akan dihpw, mehn wia takai pweht. Re en pein kolahng rapahki. ");
INSERT INTO pon2006a_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ahpw kumwail pahn itonehng irail re en wiahda uwen tohtohn takai pweht me re kin wiahda mahso; kaleke kumwail kamalaulauwihala. Pwe aramas pohnkahke kei irail, ihme re pekipekihki I en mweidohng irail re en kolahng kaudokiong arail Koht.’ ");
INSERT INTO pon2006a_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Kumwail kadoadoahkih laud aramas pwukat, pwe re en soupisekla mehlel, oh sohte kak rong kapahrek likamw pwukan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Eri, kaunen lidu ko, oh mehn Israel me kin kaun doadoahko, ahpw kohla oh ndaiong mehn Israel ko, “Parao mahsanih me e solahr pahn kihong kumwail dihpw. ");
INSERT INTO pon2006a_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Kumwail en pein kohwei oh ale wasa me kumwail kak diar ie, ahpw kumwail uhdahn pahn wiahda uwen tohtohn takai pweht duwehte mahs.” ");
INSERT INTO pon2006a_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Aramas akan eri kohpeseng nan Isip pwe re en kihpene dihpw. ");
INSERT INTO pon2006a_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Kaunen lidu ko ahpw kin koangoangehkin irail, re en wiahda uwen tohtohn takai pwetohte rahn koaros, duwehte ahnsou me irail kin pein kihong irail dihpw. ");
INSERT INTO pon2006a_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Mehn Isip kan me kaun lidu ko ahpw kin wokih kaunen mehn Israel ko me re koasoanehdi re en kin kaun doadoahko. Re ahpw kin idingkin irail, “Dahme kumwail sohte wiahkihda uwen tohtohn takai pweht rahnwet duwehte amwail kin wiahda mahso?” ");
INSERT INTO pon2006a_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Mehn Israel ko me kin kaun ahpw patohla rehn Parao oh repenpwung reh, patohwan, “Maing, dahme komw ketin wiahkihong kiht met? ");
INSERT INTO pon2006a_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Solahr dihpw me kohieng kiht, komwi ahpw kin ketin idingohng kiht se en wia takai pweht. A met, se pil kin kalokolok. Komwi me pahn pwukoahki met.” ");
INSERT INTO pon2006a_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Nanmwarkio ahpw ketin sapeng, mahsanih, “Pwehki kumwail me pohnkahke, ihme kumwail pekipekihki kumwail en kolahng kaudokiong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Kumwail pwurowei doadoahk! Sohte dihpw ehu me pahn kohieng kumwail, ahpw kumwail uhdahn pahn wiahda uwen tohtohn takai pweht me kileldi.” ");
INSERT INTO pon2006a_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Eri kaunen mehn Israel ko ese me re milahr nan apwal, ahnsou me nanmwarkio mahsanihong irail me re pahn wiahda uwen tohtohn takai pwehtohte rahn koaros, duwehte mahs. ");
INSERT INTO pon2006a_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Eri, ni ar patopatohla, re tuhwong Moses oh Aaron me awiawih irail. ");
INSERT INTO pon2006a_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Re apw ndaiong ira, “KAUN-O ketin mahsaniher dahme kumwa wiahiong kiht, oh e pahn ketin kalokei kumwa, pwehki amwa kahrehiong Parao oh sapwellime lapalap akan ar kailongkinkitala. Kumwa kihongehr kedlahs pwoat nan pehrail pwe re en kemeikitala.” ");
INSERT INTO pon2006a_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moses eri pwurehng patohwanohng KAUN-O, “Maing Kaun, dahme komw ketin likidmeliekilahr sapwellimomwi aramas akan? Dahme komw ketin poaronekiniehdo wasaht? ");
INSERT INTO pon2006a_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Pwe sang ni ei patohdohng rehn Parao pwe I en pato ni mwaromwi, e sohte tokedihsang wiakauwe sapwellimomwi aramas akan. Komwi ahpw sohte ketin seweseirailda!” ");
INSERT INTO pon2006a_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","KAUN-O eri ketin mahsanihong Moses, “Met ke pahn kilang dahme I pahn wiahiong Parao. I pahn idingohng en kadarala nei aramas akan. Ahpw mehlel, I pahn idingohng en kasareirailla sang nan sapweo.” ");
INSERT INTO pon2006a_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Koht ahpw ketin mahsanihong Moses, “Ngehi me KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","I pwarongehr Eipraam, Aisek, oh Seikop, nin duwen Koht, Wasa Lapalap. I ahpw sohte kasalehiong irail mwarei, KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","I pil wiadahr ei inou ong irail, I inoukihong irail me I pahn kihong irail Kenan, sahpw me re keikeiru ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Met I karongeier ngilen weirek en mehn Israel kan, me mehn Isip kan kaliduwihalahr, oh I tamandahr ei inowo. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Eri, ke pahn padahkihong mehn Israel kan, ‘Ngehi me KAUN-O; I pahn kamaiaweikumwailda sang nan doadoahk laud me mehn Isip kan kin idingohng kumwail. I pahn kapitasang kumwail nan mouren lidu. I pahn kapitkinkumwailla roson en nin limei kat me pahn kaloke irail mwuledek. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","I pahn pwengkumwailda, oh nainekinkumwailla; oh I pahn wiahla amwail Koht. Kumwail pahn esehla me ngehi KAUN-O, iei amwail Koht, me kin kamaiaweikumwailda sang pahn manaman en mehn Isip kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","I pahn kahluwaikumwaillahng nan sahpw me I kahukihla me I pahn kihong Eipraam, Aisek, oh Seikop. I pahn kihong kumwail sahpwo pwe kumwail en uhdahn sapwenikihla. Ngehi me KAUN-O.’” ");
INSERT INTO pon2006a_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moses eri patohwanohng mehn Israel ko mepwukat; ahpw re sohte men rong, pwehki apwal laud en kalidu me re mihmi loale. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","KAUN-O eri mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Kohwei rehn Parao, nanmwarkien Isip, oh kairehki me e uhdahn pahn mweidala mehn Israel kan pwe re en kohkohla sang nan sahpwet.” ");
INSERT INTO pon2006a_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","A Moses ahpw sapeng patohwan, “Ni mehn Israel kan ar sohte men rong, ia duwen Parao eh pahn ketin karonge ie, ni ei soakoahiek en pato?” ");
INSERT INTO pon2006a_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","KAUN-O eri ketikihong Moses oh Aaron kosonned ehu, ira en kairehki mehn Israel kan oh Parao, nanmwarkien Isip, duwen ara aleier kosonned pwe ira en kahreieisang nan Isip mehn Israel kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Nein Seikop mesenih, Reupen, naineki pwutak pahmen: Anok, Pallu, Esron oh Karmi; irail me wia pahpa kahlap en peneinei kan me weuwa adarail. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simion naineki pwutak wenemen: Semuel, Samin, Ohad, Sakin, Sohar, oh Saul, nein lihen Kenan men; iei irail pwukat me wia pahpa kahlap en peneinei kan me weuwa adarail. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lipai naineki pwutak silimen: Kerson, Kohad, oh Merari; iei irail me wia pahpa kahlap en peneinei kan me weuwa adarail. Lipai momourki sounpar 137. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Kerson naineki pwutak riemen: Lipni oh Simei, kadaudokara kan inenen ngeder. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohad naineki pwutak pahmen: Amram, Isar, Epron, oh Ussiel. Kohad momourki sounpar 133. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari naineki pwutak riemen: Mahli, oh Musi. Ih irail pwukat me wia peneineien Lipai kan oh kadaudokarail kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram pwoudikihda Soseped, rien eh pahpao serepein, iei ih me naitikihada Aaron oh Moses. Amram momourki sounpar 137. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isar naineki pwutak silimen: Kora, Nepek, oh Sikri. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ussiel pil naineki pwutak silimen: Misael, Elsapahn oh Sidri. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron pwoudikihda Elisehpa, nein Aminadap serepein oh rien Nahson; ih me naitikihada Nadap, Apihu, Eleasar oh Idamar. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora naineki pwutak silimen: Assir, Elkana oh Apiasap; iei irail me wia pahpa kahlap en pwihnlap en peneineien Kora. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleasar, nein Aaron pwutak, pwoudikihda emen nein Putiel serepein ko, ih me nainekihda Pineas. Iei irail me wia kaunen peneinei kan en kadaudok en Lipai. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aaron oh Moses iei ira me KAUN-O ketin mahsanihong: “Kumwa kahrehsang nan Isip kadaudok en Israel kan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Iei ira me patohwanohng nanmwarkien Isipo en ketin kasaledekihala mehn Israel kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ahnsou me KAUN-O mahseniong Moses nan Isip, ");
INSERT INTO pon2006a_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","e mahsanih, “Ngehi, iei KAUN-O. Ke pahn kairehki Parao, nanmwarkien Isip, mehkoaros me I padahkihong uhk.” ");
INSERT INTO pon2006a_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Moses ahpw sapeng, patohwan, “Komw mwahngih me ngehi aramas soakoahiek en pato men; a ia duwen Parao eh pahn ketin karonge ie?” ");
INSERT INTO pon2006a_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","KAUN-O ketin mahsanih, “I pahn wiahiong uhk pwe ke en rasehng Koht mwohn Parao, oh riomw Aaron pahn koasoiong duwehte omw soukohp. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ke pahn ndaiong Aaron mehkoaros me I koasoanediong uhk, oh e ahpw pahn patohwanohng Parao en mweidala mehn Israel kan pwe re en mweselda sang Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ahpw I pahn kakeptakaila nan kapehden nanmwarkio, oh e sohte pahn rong uhk, mehnda ma I pahn wiahda manaman kamasepwehk kei nan Isip, ");
INSERT INTO pon2006a_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","I pahn kalokehki mehn Isip kan kalokolok mwuledek, oh mwuri, I ahpw pahn kahluwa nei aramas akan sang nan sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Mehn Isip kan eri pahn esehla me iei ngehi me KAUN-O, ni ei pahn pelian irail oh kahluwaieisang mehn Israel kan nan Isip.” ");
INSERT INTO pon2006a_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moses oh Aaron eri kapwaiada dahme KAUN-O ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moses sounpar 80, a Aaron sounpar 83, ni ahnsou me ira tuhwong Parao. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","KAUN-O ahpw ketin mahsanihong Moses oh Aaron, ");
INSERT INTO pon2006a_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ma Parao pahn mahsanihong kumwa, ‘Kumwa kadehdehkihda pein kumwa ehu manamanen,’ eri, ke pahn ndaiong Aaron, ‘Ale omw sokonen oh kesehdiong mwohn Parao, oh e pahn wiahla sineik men.’” ");
INSERT INTO pon2006a_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moses oh Aaron eri patohla rehn Parao oh wiahda soahng koaros me KAUN-O ketin mahsanihong ira. Aaron kesehdiong nanpwel eh sokono mwohn Parao oh sapwellime lapalap ako, e ahpw wiahla sineik men. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Parao eri malipepene sapwellime aramas loalokong kan oh sounakmanaman kan; re ahpw pil wiahda soahngohte sang ni ar akmanaman. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Re kesehdiong nanpwel ar sokon kan, sokon ko ahpw pil wiahla sineik. Ahpw en Aaron eh sokono kadallehla ar sokon ko koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Eri soh, Parao me inenen keptakai; oh sohte men rong ira, duwen me KAUN-O ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","KAUN-O eri mahsanihong Moses, “Parao me inenen keptakai oh e sohte mweidohng aramas akan en kohkohla. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Eri, kohwei oh tuhwong Parao nimenseng, ni eh pahn ketilahng ni Pillap Nail. Awihedi ni keilen pillapo. Wa kohwei sokonen me wiahla sineik. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ke ahpw patohwanohng Parao, ‘KAUN-O, Koht en mehn Ipru kan, ketin kederiehdo pwe I en patohwanohng komwi en mweidohng sapwellime aramas akan re en patopatohla, pwe re en patolahng kaudokiong nan sapwtehn. Eri, lel met komw sohte men karonge. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Eri, maing, KAUN-O mahsanih, me komw pahn mwahngihala ihs ih sang dahme e pahn ketin wia. Eri, komw mahsanih, pwe I pahn poakihki sokon wet pilen pillapet, a e pahn wiahla nta. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Mwahmw akan pahn mehla oh matala nan pillap wet, me kahrehda mehn Isip kan sohla pahn kak nimpil sang ie.” ");
INSERT INTO pon2006a_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","KAUN-O ahpw pil mahsanihong Moses, “Ndaiong Aaron en ale eh sokono oh kapahwei pohn pihl koaros en Isip, pillap akan, dahu kan, oh leh kan. Pihl koaros pahn wiahla nta, oh nta pahn audehla wasa koaros nan sahpwo, pil iangahki nan pwoaren tuhke kan, oh nan pwoaren paip akan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Eri, Moses oh Aaron ahpw kapwaiada dahme KAUN-O ketin mahsanihong ira. Aaron pwekada eh sokono oh poakihki pillapo; pilen pillapo ahpw wiahla nta mwohn Parao oh sapwellime lapalap ako. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Mwahmw akan ahpw mehla nan pillapo, oh pihlo inenen pwohsuwedla, ihme kahrehda mehn Isip kan sohla kak nimpil sang ie. Pihl koaros nan Isip wiahla nta. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Sounakmanaman en Isip ko pil wiahda soahngohte, sang ni ar akmanaman, me kahrehda Parao inenen keptakaila. E sohte mwahn karonge Moses oh Aaron, duwen KAUN-O eh ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Parao eri ketin sapahllahng ni tehnpeseo, soh mwahn kupwurohki mehkotet. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Mehn Isip koaros ahpw weirada ni keilen pillapo pwoahr en pihl kei, pwehki ar sohla kak nim pilen pillapo. ");
INSERT INTO pon2006a_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Mwurin kalokolok wet, rahn isuh dou powe, a ehu kalokolok pil wiawi. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","KAUN-O eri ketin mahsanihong Moses, “Kohwei rehn Parao oh ndaiong me iet me KAUN-O mahsanih, ‘Komw ketin mweidala nei aramas akan en patolahng kaudokiong ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ma komw sohte pahn kupwurki mweidirailla, I pahn kalokehki sahpwo pwon kairu. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Pillapo pahn direkihla kairu; re pahn kohda sang loale, kohlong ong nan tehnpasomwi, nan omwi perehn seimwoak, pohn omwi peht, nan imwen sapwellimomwi lapalap akan oh aramas akan, nan omwi wasahn wia mwenge oh wia pilawa kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Re pahn lusungkomwiseli, oh pil sapwellimomwi aramas akan oh lapalap akan.’” ");
INSERT INTO pon2006a_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","KAUN-O ahpw mahsanihong Moses, “Ndaiong Aaron en kapahla eh sokono pohn pillap akan, pohn dahu kan, pohn leh kan, pwe en kapwarehda kairu kan nan Isip.” ");
INSERT INTO pon2006a_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaron eri kapahla peho pohn pihl akan en Isip, kairu kan ahpw pwarada oh kipehdi nan Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ahpw sounakmanaman akan pil kapwarehda kairu kan nan Isip sang ni ar akmanaman. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Parao eri malipehdo Moses oh Aaron, oh mahsanihong ira, “Kumwa kapakap oh peki rehn KAUN-O pwe en ketikihsang kairu kan, I ahpw pahn mweidala noumwa aramas akan en kohwei kaudokiong KAUN-O.’ ");
INSERT INTO pon2006a_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses ahpw sapeng, patohwan, “I pahn perenki kapakapkin komwi. Ahpw komw ketin kilelehdi ahnsou me I pahn kapakapkin komwi, sapwellimomwi lapalap akan oh aramas akan, pwe kairu kan en pweiekla sang kumwail, oh nan tehnpasamwail kan, pweieklahng nan pillapo.” ");
INSERT INTO pon2006a_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","A e ketin sapeng, mahsanih, “Komw kapakapkin ie lakapw.” Moses eri patohwan, “E pahn pweida duwen me komw mahsanih, pwe komwi en mwahngihala duwen eh sohte emen koht me duwehte KAUN-O, at Koht. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kairu kan pahn pweiekla sang komwi, oh nan tehnpasamwail kan, oh sang sapwellimomwi lapalap akan oh aramas akan; oh re pahn pweieklahng nan pillapo.” ");
INSERT INTO pon2006a_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moses oh Aaron eri patopatohla sang rehn Parao, Moses ahpw patohwan kapakapohng KAUN-O pwe en ketikihsang rehn Parao kairu kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","KAUN-O eri ketin kupwurehla en Moses eh kapakap; eri, kairu kan nan ihmw akan, nan mwetuwel kan, oh nan sahpw akan, ahpw mehla. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Mehn Isip kan ahpw koasoakehda kairu kan wiahda koasoakoasoak kalaimwun kei, me kahrehda pwohsuwedla wasa koaros nan sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Eri, ni Parao eh mwahngiher me kairu kan melahr, e pwurehng keptakaila, oh sohla men karonge Moses oh Aaron, duwen me KAUN-O ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","KAUN-O eri mahsanihong Moses, “Ndaiong Aaron en poakihki eh sokono nanpwel, a pwelpar ahpw pahn wekila wiahla amwise nan Isip pwon.” ");
INSERT INTO pon2006a_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Aaron eri poakihki nanpwel eh sokono. Pwelpar koaros en Isip wiahla amwise, oh kipehdi aramas akan oh mahn akan. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Sounakmanaman akan pil song en wiahda soahngohte sang ni ar akmanaman, pwe en kapwarehda amwise kan, ahpw re sohte kak. Amwise kan ahpw kipehdi wasa koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Sounakmanaman akan eri patohwanohng Parao, “Mehkotet sang nin limen Koht.” Ahpw Parao keptakailahte oh sohte men karonge Moses oh Aaron, duwen KAUN-O eh ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","KAUN-O eri mahsanihong Moses, “Nin sohrahn ke pahn kohwei oh tuhwong Parao ni eh pahn ketilahng ni pillapo, ke ahpw ndaiong me KAUN-O mahsanih, ‘Komw kadarala nei aramas akan pwe re en kaudokiong ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ma komw sohte pahn kupwurki kadarirailla, eri, I inoukihong komwi me I pahn kadarpeseng mwuten loahng kei pohmwi, pohn sapwellimomwi lapalap akan oh aramas akan. Nan imwen mehn Isip kan pahn direkihla loahng, oh e pil pahn kipehdi nan pwehl kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Rahnohte I pahn silehdi nan Kosen, wasa nei aramas akan kin koukousoan ie, pwe loahng kan en dehr mihla ie, pwe komwi en mwahngihala me ngehi KAUN-O, I kin iang mihmi nan sahpw wet. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","I pahn katohrepeseng nei aramas akan oh sapwellimomwi kan. Manaman wet pahn pweida lakapw.’” ");
INSERT INTO pon2006a_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","KAUN-O eri ketin wiahda met, oh mwuten loahng kei ahpw pihrdohng ni tehnpas en Parao, oh nan imwen sapwellime lapalap ako, oh nan Isip pwon. Sahpwo pwon ahpw ohkihla loahng. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Parao eri malipehdo Moses oh Aaron oh mahsanihong ira, “Kumwail kohwei oh kaudokiong amwail Koht nan sahpwette.” ");
INSERT INTO pon2006a_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moses ahpw sapeng, patohwan, “Met sohte kak wiawi, pwehki meirong en mahn akan me se pahn meirongkihong KAUN-O, at Koht, eh pahn kansensuwedihada mehn Isip kan. Ma se pahn doadoahngki mahn me kin kansensuwedihada mehn Isip kan oh meirongkihla mwohn masarail kan, re pahn kateikitedi oh kemeikitala. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Se uhdahn pahn wia seiloak en rahn siluh kolahng nan sapwtehn, pwe se en wia at meirong ong KAUN-O, at Koht, duwen me e mahsanihong kiht.” ");
INSERT INTO pon2006a_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Parao ahpw mahsanih, “I pahn mweidohng kumwail en kohwei oh kaudokiong KAUN-O, amwail Koht, nan sapwtehn, ahpw sohte dohweisang met. Eri, kumwail pil kapakapkin ie.” ");
INSERT INTO pon2006a_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moses ahpw sapeng, patohwan, “Ni ahnsowohte me I pahn kohkohla sang met, I pahn kapakapohng KAUN-O pwe lakapwete loahng kan en pweiekla sang komwi, oh sapwellimomwi lapalap akan oh aramas akan. Ahpw komw sohte pahn ketin pwurehng pitih kiht oh kapweiengkitasang at pahn kohla kaudokiong KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moses eri patopatohla sang rehn Parao oh patohwan wia eh kapakapohng KAUN-O, ");
INSERT INTO pon2006a_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","KAUN-O eri ketin kapwaiada pekipek en Moses. Loahng ko ahpw sohrasang rehn Parao, rehn sapwellime lapalap ako oh aramas ako; sohte mehmen me luhwehdi. ");
INSERT INTO pon2006a_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ahpw pil ahnsou wet kupwur en Parao kepikeptakaite, pwe e sohte men kadarala mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","KAUN-O eri mahsanihong Moses, “Kohwei rehn Parao oh ndaiong me KAUN-O, Koht en mehn Ipru kan, mahsanih, “Komw mweidala pwe nei aramas akan en patolahng kaudokiong ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ma komw sohte pahn pwurehng kupwurki re en patopatohla, ");
INSERT INTO pon2006a_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","I pahn kalokehkin komwi kalokolok suwed ehu ong mahn akan— ong sapwellimomwi oahs akan, ahs akan, kamel kan, kou kan, sihpw oh kuht kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","I pahn katohrepeseng nein mehn Israel mahn akan oh nein mehn Isip kan, oh sohte nein mehn Israel mahn emen pahn mehla. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ngehi KAUN-O, me kilelehdier me lakapw iei ahnsou me I pahn wiahda mepwukat.’” ");
INSERT INTO pon2006a_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Mandahn rahno KAUN-O ahpw ketin kapwaiahda dahme e mahsaniho. Eri, nein mehn Isip mahn ako koaros mehla, ahpw sohte emen nein mehn Israel ko mehla. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Parao eri keinemwe dahme wiawi, re ahpw padahkihong me sohte nein mehn Israel mahn emen me mehla. Ahpw nan kupwure keptakailahte oh sohte men mweidohng mehn Israel ko en patopatohla. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","KAUN-O eri mahsanihong Moses oh Aaron, “Kumwa ale ekei pehsen sang nan sidohp; Moses en sipedadawohng nan wehwe mwohn Parao. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Pehso ahpw pahn mwarakseli wasa koaros nan Isip duwehte pwelpar, oh e pahn kahrehiong aramas akan oh mahn akan ar pahn mpwoskihda, oh pahn sawapeseng wiahla kens.” ");
INSERT INTO pon2006a_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ira eri ale pehs sang nan sidohp oh uh mwohn Parao; Moses eri sipedadalahng pehso nan wehwe, e ahpw kahrehda mpwos rehn aramas akan oh mahn akan me sawapeseng wiahla kens. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Sounakmanaman ko sohte kak pwarodo mwohn Moses, pwehki ar diren mpwosala duwehte mehn Isip teiko. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","KAUN-O ahpw ketin kakeptakaila kupwur en Parao pwe en sohte men rong Moses oh Aaron, duwen me KAUN-O ketin mahsanihong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","KAUN-O eri mahsanihong Moses, “Nin sohrahn ke pahn kohwei rehn Parao oh ndaiong me iet me KAUN-O, Koht en mehn Ipru kan, mahsanih, ‘Mweidala nei aramas akan pwe re en kolahng kaudokiong ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Met I pahn kihong pein komwi ei kalokolok kan koaros, oh ong sapwellimomwi lapalap akan, pwe komwi en mwahngih duwen eh sohte emen koht mie nin sampah pwon duwehte ngehi. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ma I kamwakid pehiet pwe en kalokei komwi oh sapwellimomwi aramas akan, kumwail uhdahn pahn mwomwla douluhl. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ahpw I mweidohng komwi en momour pwe I en kasalehiong komwi ei manaman, oh mwarei en kipehla wasa koaros nin sampah. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Eri, komwi ahpw pil lemeiongete nei aramas akan oh sohte mweidohng re en kohkohwei. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Eri, lakapwte I pahn kamwerehdi keteu aihs takai, soahng me saikinte wiawi nan Isip sang ni eh wiawihda. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Eri, komwi mahsanih pwe sapwellimomwi mahn akan oh mehkoaros me mihmi likin ihmw en kohlong nan ihmw. Keteu aihs takai pahn mwerediong pohn aramas koaros oh mahn koaros me sohte rukula, oh re pahn mehla.’” ");
INSERT INTO pon2006a_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Eri, ekei sapwellimen Parao lapalap ako ahpw masakada mahsenen KAUN-O, iei me re kihlong nan ihmw neirail lidu kan oh mahn akan. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","A ekei sohte nsenohki mahseno, re ahpw sohte karukihala neirail lidu kan oh mahn akan. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","KAUN-O eri mahsanihong Moses, “Kauwadawohng pehmwen pahnlahng pwe keteu aihs takai en mwerediong pohn Isip, pohn aramas akan, mahn akan, oh dihpw en nansapw koaros.” ");
INSERT INTO pon2006a_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moses ahpw kauwadalahng eh sokono pahnlahng, KAUN-O eri ketikihdi nansapwe oh keteu aihs takai, oh lioal lel nanpwel. KAUN-O eri ketin kamwerehdi ");
INSERT INTO pon2006a_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","keteu aihs takai iangahki lioal me wie piripir. Iei met keieun melimel suwed me lel Isip sang ni eh wiahla wehin Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Wasa koaros nan Isip melimel en aihs takaio lel mehkoaros me mihmi likin ihmw, aramas oh mahn koaros. E kemehla dihpw koaros en nansapw akan oh kauwehla tuhke koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ihte wasa me melimelo sohte lel ie, iei nan Kosen, wasa me mehn Israel ko koukousoan ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Parao eri malipehdo Moses oh Aaron, oh mahsanihong ira, “Met I dipadahr. KAUN-O me ketin pwung; ngehi oh nei aramas akan me sapwung. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Kumwa kapakapkin kiht rehn KAUN-O; pwe soangen nansapwe oh keteu aihs takai wet en tokedi. I inoukihda me I pahn mweidohng kumwail en kohkohwei, kumwail sohte pahn mihmi met.” ");
INSERT INTO pon2006a_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses eri patohwanohng, “Ni ahnsou me I pahn patohieila sang nan kahnimw wet, I pahn kauwadalahng rehn KAUN-O pehi kat. Nansapwe ahpw pahn tokedi, oh sohla pahn keteu aihs takai, pwe komwi en mwahngih me sampah uhdahn nin limen KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","A met I ese me komwi oh sapwellimomwi lapalap akan saikinte lemmwikihla KAUN-O, Koht.” ");
INSERT INTO pon2006a_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Wahntuhke kan me adaneki plaks oh parli, re mengila, pwehki wahntuhke parli iower oh wahntuhke plaks ahpwtehn pwerla. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ahpw wahn wihd sohte ohla, pwehki e saikinte lel ahnsoun ar mah. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moses eri patopatohla sang rehn Parao patopatolahng likin kahnimwo. E ahpw kauwada peh ko pwe en kapakapohng KAUN-O. Eri, nansapwe oh keteu aihs takaio oh keteu ahpw tokedi. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ni ahnsou me Parao mahsanihada me keteu, keteu aihs takai, oh nansapwe tokedier, e pil pwurehng dipada, iangahki sapwellime lapalap ako. ");
INSERT INTO pon2006a_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Nan eh keptakailahr e sohte kupwurki mehn Israel ko en kohkohla, duwen me KAUN-O ketin mahsanihong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","KAUN-O eri mahsanihong Moses, “Kohwei rehn Parao, pwe I kakeptakaihalahr iangahki sapwellime lapalap akan, pwe I en wia ei manaman akan mwohrail, ");
INSERT INTO pon2006a_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","oh pwe ke en kak padahkihong noumw seri kan oh kadaudokomw kan duwen ei kapingkidahr mehn Isip kan ei manaman akan. Pwe kumwail koaros en ese me ngehi me KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moses oh Aaron eri patohla rehn Parao oh patohwanohng, “Iet me KAUN-O, Koht en mehn Ipru kan, mahsanih, ‘Ia erein omwi sohte pahn men karongei ie? Komw mweidohng nei aramas akan pwe re en kolahng kaudokiong ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ma komw sohte pahn mweidohng re en kohkohla, eri a, lakapwete I pahn kadirehkihla loukust omwi wehi. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Re pahn kipehdi wasa koaros nansapw, oh sohla me pahn kak kilang sahpw. Re pahn kangala mehkoaros me keteu aihs takaio sohte kauwehla, iangahki tuhke koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Re pahn audehla nan tehnpasomwi kan oh imwen sapwellimomwi lapalap akan oh aramas akan. Re pahn suwedsang kalokolok koaros me amwail pahpa kahlap ako udiahlehr.’” Moses eri pirekekte patopatohla. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Sapwellimen Parao lapalap ako ahpw patohwanohng, “Ia erein ohl menet eh pahn kedirepwei kitail? Komw ketin kupwureirailla, pwe re en kak kaudokiong KAUN-O, ar Koht. Komw sohte mahsanih duwen Isip eh ohlahr?” ");
INSERT INTO pon2006a_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Moses oh Aaron ahpw likwerdo sapahl mwohn Parao, e ahpw mahsanihong ira, “Kumwail kak kohwei oh kaudokiong KAUN-O, amwail Koht. Ahpw ihs me pahn iang kohwei?” ");
INSERT INTO pon2006a_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moses eri sapeng, patohwan, “Kiht koaruhsie pahn patopatohla, me tikitik kan oh me laud kan; nait pwutak oh serepein kan, nait sihpw kan oh kuht kan, oh pil nait pelin kou kan, pwehki se uhdahn pahn wia sarawi ehu ong KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Parao ahpw mahsanih, “I kahukihla KAUN-O me I sohte pahn mweidohng kumwail en wa lih akan oh seri kan! Uhdahn me dehde me kumwa koasoakoasone mehkot suwed nan kapehdomwa. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Sohte kak! Kumwail ohl akante me pahn kohwei oh kaudokiong KAUN-O, ma ih me kumwail anahne.” Ni ahnsowohte, ira ahpw pakasarasang mwohn Parao. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","KAUN-O ahpw mahsanihong Moses, “Kapahwei pehmwen pohn Isip, pwe loukust kan en pwarada oh kangala mehkoaros, pil tuhke koaros me luhwehdi sang keteu aihs takaio.” ");
INSERT INTO pon2006a_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moses eri kapahla eh sokono, a KAUN-O ahpw koasoanehdi pwe kisinieng ehu en ipidohng pohn sahpwo sang palimese, erein rahn ehu pwon oh pwohng ehu pwon. Mandahn rahno, nimenseng, kisiniengo ahpw ipirodo loukust ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Re ahpw kohdo oh kipehdi nan Isip pwon. Soangen tohto wet sohte wiawi sang mahs kohdo, oh pil sohte pahn wiawi sang met kohla. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Re ahpw kipehdi wasa kan oh rotongedi sahpwo; re kangala wahntuhke koaros me sohte ohkihla keteu aihs takaio. Sohte wahntuhke, de tehntuhke ieu, de kisin dihpw kis, me luhwehdi nan Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Parao eri mwadangete malipehdo Moses oh Aaron oh mahsanihong ira, “I dipadahr ong KAUN-O, amwa Koht, oh pil ong kumwa. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Eri, kumwa menlau mahkohng ie met, oh kapakapohng KAUN-O, amwa Koht, pwe en ketikihweisang ie kalokolok wet.” ");
INSERT INTO pon2006a_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moses eri patopatohla sang rehn Parao, oh patohwan wia eh kapakapohng KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","KAUN-O eri ketin wekidala kisiniengo, wekidiong ni kisinieng kehlail ehu me uhdo sang palikapi; e ahpw ipirasang loukust ko ipiralahng nan Sehd Weitahta. Sohte loukust men luhwehdi nan Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","KAUN-O ahpw kakeptakaila Parao, iei me e sohte mweidohng mehn Israel ko en kohkohla. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","KAUN-O eri mahsanihong Moses, “Kapahdawei pehmwen pahnlahng, pwe rotorot mosul me aramas kak pehmada en kipehdi nan Isip pwon.” ");
INSERT INTO pon2006a_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moses ahpw kapahda peho pahnlahng, a ni ahnsowohte rotorot mosul ehu ahpw kipehdi nan Isip pwon me wiewiawihki erein rahn siluh. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Mehn Isip ko sohla kak kilangki wasa, oh sohla me kohieisang nan imwe erein rahn siluhwo. A wasa me mehn Israel ko mihmi ie, marain. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Parao ahpw ketin malipehdo Moses oh mahsanihong, “Kumwail kakehr kohwei oh kaudokiong KAUN-O; pil lih akan oh noumwail seri kan kak iang kumwail; ihte noumwail sihpw kan, kuht kan, oh pelin kou kan, me pahn mihmi met.” ");
INSERT INTO pon2006a_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moses ahpw sapeng, patohwanohng, “Eri, ma ih duwen, a komw ketikihong kiht mahn akan, at mehn meirong oh meirong isihs ong KAUN-O, at Koht. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Nait mahn akan uhdahn pahn pil iang kiht; sohte mehmen pahn mihmi. Se uhdahn pahn kin pilada mahn me se pahn kin meirongkihong KAUN-O, at Koht. Ni at pahn lel wasahn kaudoko, pein kiht sohte patohwan ese mehnia mahn me se pahn meirongkihla nan at kaudok.” ");
INSERT INTO pon2006a_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","KAUN-O ahpw pil ketin kakeptakaila Parao, iei me e sohte mweidohng irail re en kohkohla. ");
INSERT INTO pon2006a_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","E ahpw mahsanihong Moses, “Eri, kohkohweisang mwohi! Kaleke komw pwurodo; ma komw pwurodo, rahnohte komw pahn kamakamala!” ");
INSERT INTO pon2006a_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moses ahpw sapeng, patohwan, “Ih me pahn wiawi, duwen me komw mahsanih. Komw solahr pahn pwurehng mahsanih ie.” ");
INSERT INTO pon2006a_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","KAUN-O ahpw mahsanihong Moses, “Kalokolok tehr ieu me I pahn kihong Parao oh mehn Isip kan. Mwuri, e pahn mweidkumwailla. Ahpw ni eh pahn mweidkumwaillahr, e pahn pwakih kumwail sang Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Eri, ke pahn ndaiong mehn Israel kan, ohl akan oh lih akan koaros, emenemen en peki sang rehn kompoakepah mehn Isip kan soangen dipwisou kesempwal me duwehte silper oh kohl. ");
INSERT INTO pon2006a_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Eri, KAUN-O ahpw ketin kupwurehda pwe mehn Israel kan en kenikenla rehn mehn Isip kan; lapalap akan oh aramas akan nan Isip kin wiahki Moses ohl wahun emen. ");
INSERT INTO pon2006a_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moses ahpw patohwanohng Parao, “Iet me KAUN-O mahsanih, ‘Nin lukepen pwong I pahn dawih Isip, ");
INSERT INTO pon2006a_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","oh mesenih koaros nan Isip pahn mehla, sang sapwellimen Parao mesenih, me pahn sohsohki mwoale, lel mesenihen lih lidu me kin kapikapirki peh takaien ngidarpene wahn wihd kan. Pil mesenihen kou kan koaros pahn mehla. ");
INSERT INTO pon2006a_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ngilen nsensuwed laud oh mwahiei pahn peida sang wasa koaros nan Isip. Soangen ngilen nsensuwed me saikinte mie sang mahs kohdo, oh pil sohte pahn mie sang met kohla. ");
INSERT INTO pon2006a_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","A rehn mehn Israel kan sohte me pahn rong kidi men e pahn ngoangih aramas akan de mahn akan. Eri met, kumwail pahn ese me ngehi, KAUN-O me katohrehsang mehn Israel kan sang mehn Isip kan.’ ");
INSERT INTO pon2006a_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Moses eri kaimwisengkihla eh koasoi, patohwan, “Sapwellimomwi lapalap akan koaros ahpw pahn pwarodo oh poaridi mwohi, patohwan, ‘Komw ketiketwei, komwi oh sapwellimomwi aramas akan koaros.’ Mwurin met, I ahpw pahn patopatohla.” Moses eri patopatohla sang rehn Parao ni eh lingeringer laud. ");
INSERT INTO pon2006a_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","KAUN-O eri mahsanihong Moses, “Parao sohte pahn karongeiuk. Eri met, I pahn katohtowehla ei manaman akan nan Isip.” ");
INSERT INTO pon2006a_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moses oh Aaron ahpw wiahda manaman pwukat koaros mwohn silangin Parao. KAUN-O ahpw ketin kakeptakailahte Parao; ihme e sohte kin mweidkihla mehn Israel kan en kohkohla sang Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","KAUN-O ahpw mahsanihong Moses oh Aaron nan Isip, ");
INSERT INTO pon2006a_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Eri, sounpwong wet, ih me pahn wiahla sounpwong en tepin pahr rehmwail. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Kumwa padahkihong mehn Israel koaros met: Ni kaeisek en rahnen sounpwong wet, emenemen ohl en pilada sihmpwul de kuht emen ong eh peneinei, mahn emen ong tohn ehu ihmw. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ma tohn peneinei ehu me nohn malaulau ong emen sihmpwul, a re pahn patehng tohn ehu ihmw keren, pwe irail koaros pahn ahnekipene sihmpwul tehmen. E pahn kasawih aramas depe me pahn kak kangala kisin mahno. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kumwail pahn pilada emen kuht de sihpw, me mahkiher sounpar ehu, oh sohte soumwahu. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Eri, ni eisek pahieun sounpwongo, mehn Israel koaros pahn kemehla mahn ako. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Irail pahn ale ekis nta oh iriski uhr en wenihmw kan oh nan temwen ihmw kan me re pahn tungoale ie mahno. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Nipwongohte, re pahn tungoale uduke me kereng pohn kisiniei, seliehki pilawa me sohte doal ihs iangahki tehntuhke katik. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Kumwail sohte pahn tungoale wasa kis rehn sihmpwulo amas de pwoail, pwe e pahn pwonte kereng, iangahki moange, peh kan, neh kan, oh pil kepwehn loale kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kumwail dehpa luhwekihdi mehkot ong nimensengen mandahn rahno. Ma mie luhwe, a kumwail isikala. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Eri, iet duwen amwail pahn tungoale mahno: kumwail pahn pwuhriong nan amwail likoun seiloak, oh pwuhriong nan amwail suht, oh kumwail pahn kolokol amwail sokon. Kumwail ahpw pahn tungoale pitipit. Pwe iei amwail kamadipw sarawi en Pahsohpa ong ngehi, KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Pwe nipwongohte, I pahn keidwei nan Isip oh kemehla mesenih ohl koaros en sahpwo, aramas oh mahn akan. I pahn kaloke koht koaros en Isip, pwe ngehi me KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ntao pahn wia kilel en ihmw kan me kumwail koukousoan ie. Ni ei pahn kilang ntao, I pahn daulih kumwail. Kalokoloko eri sohte pahn lelohng kumwail ni ei pahn kadaridi ei kamakam pohn wehin Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Rahno pahn wia rahnen kataman ehu rehmwail; kumwail pahn wia kamadipw sarawien kataman ong dahme ngehi, KAUN-O wiadahr. Kumwail pahn kin wia met erein dih koaros me pahn kohdo.” ");
INSERT INTO pon2006a_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","KAUN-O ketin mahsanih, “Erein rahn isuh kumwail pahn tungoale pilawa me sohte doal ihs. Ni rahnen tepin wihko, kumwail pahn kihsang ihs koaros nan imwamwail kan, pwe mehmen me pahn tungoale pilawa me doal ihs sang ni keieun rahn lel ni keisuhn rahn, e pahn lekdeksang rehn mehn Israel. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ni keieun rahn oh ni keisuhwen rahn, kumwail pahn wia pokon sarawi. Nin rahn ako sohte doadoahk pahn wiawi, ahpw ihte, doadoahk en kaunopada kisin tungoal me aramas koaros kin anahne. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Kumwail kapwaiada kamadipw sarawio, pwe ih rahno me I kahluwaieisang Isip kadaudokamwail kan. E pahn wiahla rahnen kamadipw sarawi ehu, erein dih koaros me pahn kohdo. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Kumwail pahn tungoale pilawa sohte doal ihs sang nin soutik en ni eisek pahieun keieun sounpwongo lel nin soutik en kerieisek ehun rahn. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Erein rahn isuh sohte ihs pahn mihmi nan imwamwail kan, pwe ma mehmen pahn tungoalehda pilawa me doal ihs, e pahn lekdeksang rehn mehn Israel kan, mehnda ma ih mehn liki de pwilidak en Israel men.” ");
INSERT INTO pon2006a_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Moses eri kapokonepene kaunen Israel akan koaros, oh ndaiong irail, “Emenemen kumwail pahn pilada sihmpwul de kuht emen oh kemehla pwe amwail peneinei kan en kak wia sarawien Pahsohpa wet. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Kumwail pahn ale apwoat rahn isop oh kaduh nan nta me mi nan peisin, oh iriski ntao ni uhr en wenihmw kan, oh nan temwen ihmw kan. Sohte emen kumwail pahn pedoisang nan imwe lao lel nimenseng. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Pwe KAUN-O pahn ket wasa koaros nan Isip pwe en ketin kemehla mehn Isip kan. Eri, ni eh pahn mahsanihada nta ni utuhn wenihmw kan, e sohte pahn ketin mweidohng meninkauwo en pedolong nan imwamwail kan oh kemeikumwailla. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Kumwail pahn peikiong koasoandi wet wiahkihla kosonned poatopoat ehu ong kumwail oh noumwail seri kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Eri, ni amwail pahn pedolong nan sahpw me KAUN-O pahn ketikihong kumwail, duwen me eh ketin inoukidahr, kumwail pahn pil kin wia tiahk sarawi pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Oh ni noumwail seri kan ar pahn idek rehmwail, ‘Ia wehwehn tiahk wet?’ ");
INSERT INTO pon2006a_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Kumwail pahn sapeng, nda, ‘Met atail meirong en Pahsohpa ong KAUN-O, pwehki eh ketin douluhlsang imwen mehn Israel kan nan Isip ahnsou me e ketin kalokehki mehla mehn Isip ko, e ahpw ketin kupwureikitailla.’” Mehn Israel ko eri kelepwikihdi oh pwongih Koht. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Re ahpw kohla oh kapwaiada mehkoaros duwen KAUN-O eh ketin mahsanihong Moses oh Aaron. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nin lukepen pwong KAUN-O eri ketin kemehla nein mehn Isip koaros nair mesenih, sapwellimen Parao pwutak mesenih, me pahn sohsohki mwoale, lel mesenih me sensel nan imweteng kan; iangahki mesenihen mahn akan. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Parao oh sapwellime lapalap akan koaros, oh pil mehn Isip koaros, ahpw opala wasa nipwongo; oh mwahiei laud ehu ahpw wiawi nan Isip, pwehki sohte ihmw ehu mie me pwutak men sohte mehla ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Nipwongohte, Parao ahpw malipehdo Moses oh Aaron, oh mahsanihong ira, “Kumwa pitipit kohkohweisang met, kumwa oh mehn Israel koaros. Kumwa kohkohweisang rehn nei aramas akan, oh kaudokiong KAUN-O, duwen me kumwail ndindahn. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Kumwail wahda noumwail sihpw kan oh kuht kan oh kou kan, duwen me kumwail pekidahr, oh kohkohwei. Kumwail eri pil kapakapkin ie.” ");
INSERT INTO pon2006a_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Mehn Isip ko ahpw koangoangehki mehn Israel ko re en mwadangeisang nan wehio; re ahpw nda, “Ma kumwail pwapwand, kiht koaros pahn mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Aramas ako eri ale arail pilawa ko mwohn eh saikinte doalihsda, oh me mihmihte nan deuparail, koarukipene nan arail likou kan oh kapaikada oh mwesel. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Mehn Israel ko eri kapwaiada dahme Moses kehkehlingkihong irail; pwe re en peki rehn mehn Isip ko soangen dipwisou kesempwal me duwehte silper oh kohl oh likou. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","KAUN-O ketin kupwurehla pwe mehn Israel ko en keniken pahn mehn Isip ko, iei me mehn Isip ko kihong irail dahme re pekipeki rehrail. Iei duwen ar wahsang en mehn Isip ko ar dipwisou kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Mehn Israel ko eri mweselsang Rameses kolahng Sukot. Ohl akan me 600,000, a lih oh seri sohte wadawadohng. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Pil pokon en ekei aramas iangirailda, iangahki kiden sihpw, kuht oh kou. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Re ahpw umwunda pilawa me sohte doal ihs sang ni pilawa me re wahsang Isip, pwehki mehn Isip ko ar keruwairailieisang nan Isip, oh sohla ar ahnsoun kaunopada ar tungoal kisin mwenge de pilawa me doal ihs. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Mehn Israel ko koukousoankiher nan Isip sounpar 430. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Nin rahn me kaimwisekla sounpar pahpwiki silihseko kadaudok en sapwellimen KAUN-O aramas koaros wiahkihteieu mweselsang Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Iei pwongo met me KAUN-O ketin sinsile irail pwe en ketin kahluwairailsang nan Isip. Iei me mehn Israel kan kasarawihalahr pwohngo ong KAUN-O erein dih koaros me pahn kohdo; re kin wia katamanpen pwohngo, re pahn kin pisilei. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","KAUN-O ketin mahsanihong Aaron oh Moses, “Iet koasoandi kan en Pahsohpa: Sohte mehn liki men pahn iang tungoale amwail Pahsohpa. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ahpw lidu men sohte lipilipil me pweipweida kak iang tungoale, ma kumwail pahn sirkumsaisihala mahs. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Sohte mehn keiru men de tohndoadoahk alahlda men pahn iang tungoale. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Kumwail pahn tungoale mahno unsek ni ihmwohte me kumwail kaunopada ie; sohte kisin uduk kis pahn kak wisiksang ni ihmwo wisikilahng liki. Kumwail sohte pahn kauwehla apwoat tihn mahno. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Mehn Israel koaros uhdahn pahn iang wia kamadipw wet. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ahpw sohte ohl me sohte sirkumsais pahn iang tungoale. Ma mehn liki men me mi rehmwail men iang kamadipw en Pahsohpa pwehn wauneki KAUN-O, ohl koaros me mi nan imwe pahn sirkumsaisla. Eri, e pahn kak iang kamadipw wet duwehte pwilidak en Israel men. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Kosonned pwukat pahn doadoahk rehn pwilidak en Israel kan oh rehn mehn liki kan me kousoanla rehmwail.” ");
INSERT INTO pon2006a_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Mehn Israel eri kapwaiada dahme KAUN-O mahsanihong Moses oh Aaron. ");
INSERT INTO pon2006a_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ni rahnohte KAUN-O ketin kahrehsang Isip kadaudok en Israel kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Kumwail kasarawihong ie mesenih ohl koaros, pwe mesenih ohl koaros oh mesenih mahn koaros, uhdahn nei.” ");
INSERT INTO pon2006a_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moses eri patohwanohng aramas ako, “Kumwail tamataman rahnwet—rahn me kumwail mweselsang Isip, wasa me kumwail wia lidu kei ie. Ih rahnwet me KAUN-O ketin waikumwaildo ni roson lapalap en nin lime. Kumwail sohte pahn tungoale pilawa doal ihs. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Kumwail pahn mweselsang Isip rahnwet, ni keieun sounpwong en Apip. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","KAUN-O ketin kahukihong amwail pahpa kahlap ako me e pahn ketikihong kumwail sapwen mehn Kenan, mehn Id, mehn Amor, mehn Ip, oh mehn Sepus. Eri, ni eh pahn ketin kahreikumwaildohng nan sahpwo me kaselel oh pwelmwahu, kumwail uhdahn pahn wia sarawi wet ni keieun sounpwong en pahr koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Erein rahn isuh kumwail pahn tungoale pilawa me sohte doal ihs, oh ni keisuhwen rahn pahn wia rahn sarawien wauneki KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Erein rahn isuh kumwail sohte pahn tungoale pilawa me doal ihs; sohte ihs de mehkot me doal ihs pahn mihmi nan sapwamwail. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ni rahn me kumwail pahn tapihada sarawio, kumwail pahn kawehwehiong noumwail pwutak kan me kumwail wiewia mepwukat pwehki dahme KAUN-O ketin wiahiong kumwail ni amwail mweselsang Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Sarawi wet pahn wia mehn kataman ehu, me rasehng mehkot me pirapiriong ni pehmwail oh nin temwamwail; e pahn katamankin kumwail en peupeusehla oh sukuhlki kosonned en KAUN-O, pwehki KAUN-O eh ketin kahluwaikumwaildo sang Isip ni roson lapalap en nin lime. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Iei me kumwail pahn kin wia sarawi wet ni ahnsou me kileledi nan pahr koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“KAUN-O pahn ketikihong kumwail sapwen mehn Kenan, me e ketin kahukihong kumwail oh amwail pahpa kahlap ako. Ni ahnsou me e pahn ketikihong kumwail, ");
INSERT INTO pon2006a_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","kumwail uhdahn pahn meirongkihong KAUN-O mesenih wol koaros en noumwail mahn akan, pwe KAUN-O me sapwellimaniki. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mesenih wol koaros en noumwail ahs akan kumwail pahn pwainkihla sihpwul men. Ma kumwail sohte men pwainla ahso, kumwail pahn katimpeseng tepinwere. Kumwail uhdahn pahn pwainla noumwail mesenih pwutak. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ehu rahn, ma noumw pwutak idek ia wehwehn sarawi wet, kumwail pahn sapengki, ‘Ni roson lapalap en nin lime, KAUN-O ketin waikitodo sang Isip wasa se kaliduhla ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ni ahnsou me nanmwarki en Isip keptakaila oh sohte men mweidohng se en mwesel, KAUN-O ahpw ketin kemehla mesenih koaros nan Isip, mesenihen aramas oh mahn akan. Ih kahrepen at kin meirongkihong KAUN-O mesenih wol koaros en mahn akan oh pwainkihla mesenih koaros en nait pwutak kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Eri, sarawi wet pahn wia kataman ehu rasehng mehkot me pirapiriong ni pehmwail oh nin temwamwail; katamanpen KAUN-O eh ketikihsang kitail nan Isip ni roson en nin lime.’” ");
INSERT INTO pon2006a_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ni Parao eh mweidalahr aramas akan en kohkohla sang nan sapwellime wehi, Koht sohte ketin kahluwa irail ni ahl me mi pohn oaroahr kohlahng Pilisdia, mehnda eh ahl keren pwoat. Pwe e kupwukupwure, “Re de wekidala ar lamalam oh men pwuralahng Isip ni ar pahn diarada me re pahn mahweniong imwintihti kan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ahpw e ketin kahluwairaillahng nan sapwtehn kolahng Sehd Weitahta. Mehn Israel ko mweselsang Isip wa arail tehtehn mahwen. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moses ahpw wa kohla tihn Sosep ko, duwen me Sosep pekihda rehn mehn Israel ko re en kahukihla ni inou me re pahn wahda sang Isip, ni eh mahsanihong irail, “Koht uhdahn pahn sewesei kumwail; eri, kumwail pahn wahda tih kat kohkohla sang wasaht.” ");
INSERT INTO pon2006a_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Irail eri mweselsang Sukot oh uhdi Edam, wasa re kauwada ie imwarail impwal kan, limwahn irepen sapwtehno. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ni rahn KAUN-O kin ketin tieng mwohrail ni mwomwen uhren depwek, pwe en ketin kasalehiong irail ahlo, a nipwong e pil kin ket mwohrail ni mwomwen uhren kisiniei, pwe en kin kamarainih irail. Irail eri kin kak wia ar seiloak ni rahn oh nipwong. ");
INSERT INTO pon2006a_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ahnsou koaros uhren depweko kin mi mwohn mehn Israel ko ni rahn, a uhr kisinieio kin mi mwohrail nipwong. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","KAUN-O ahpw mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ndaiong mehn Israel kan re en pweiekdo oh kauwada imwarail impwal kan kainene Pi Airod, nanpwungen Mikdol oh Sehd Weitahtao, mwohn Paal Sepon. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Pwe Parao pahn lemeleme me mehn Israel kan sansaruaruseli nan sapwtehno. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","I pahn kakeptakaila Parao, pwe en pwakih irail. Wauwi ahpw pahn sansal ni ei pahn powehdi Parao oh sapwellime karis en sounpei kan. Mehn Isip kan ahpw pahn esehla me iei ngehi KAUN-O.” Mehn Israel ko eri kapwaiada mahsen wet. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ni ahnsou me pakair wiawihong nanmwarkien Isipo, duwen mehn Israel kan ar tangdoauier, ih oh sapwellime lapalap akan eri ketin wekidala kupwurarail ong mehn Israel; re ahpw mahsanih, “Mehlel kitail sapwungala! Mehnda kitail mweidohng mehn Israel ko re en tang ni ar liduliduwih kitail?” ");
INSERT INTO pon2006a_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Parao eri ketin kaunopada sapwellime kurumahn mahwen oh ketin kapokonepene sapwellime karis en sounpei kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","E ketikihda werennansapw wonepwiki me keieu kaselel, iangahki pil ekei werennansapw, me kaunen sounpei ko kin tangahki. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","KAUN-O ahpw ketin kakeptakaila Parao, ihme e pwakiheki mehn Israel ko, me seiseiloak pahn epwelipen KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Sounpei en Isip kan, iangahki oahs oh werennansapw koaros, oh sountangahki mehpwukat koaros, ahpw pwakihala mehn Israel ko oh koanoiraildi wasa re kauwada imwarail impwal ko limwahn Sehd Weitahtao, kereniong Pi Airod, kainene Paal Sepon. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ni mehn Israel ko ar kilangada mehn Isip ko ar wie karis kohkodohng irail. Irail ahpw masepwehkada kowahlap oh likweriong KAUN-O pwe en ketin sewese irail. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Re ahpw patohwanohng Moses, “Sohte wasahn seridi nan wehin Isip me komw kahrehkinkitodohng nan sapwtehnet pwe se en mehla ie? Komw mahsanih dahme komw kahrehiongkitehr ni omwi kahreikitasang Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Se soh ndaiong komwi mwohn atail mweselo, me soangen irair wet uhdahn pahn pweida? Se ndaiong komwihte en piseksang kiht; pwe se en liduliduwih mehn Isip kan. Pwe e mwahwongete se en wiewiahte lidu sang kodohng mehla nan sapwtehnet.” ");
INSERT INTO pon2006a_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moses ahpw sapengkin irail, “Kumwail dehr masak! Kumwail nan kapehd kehlail, oh mwasahn dahme KAUN-O pahn ketin wiahda pwe en ketin kapitkumwailla rahnwet. Pwe mehn Isip pwukan me kumwail kilikilang rahnwet, kumwail solahr pahn kilang irail kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","KAUN-O me pahn ketin mahwenkin kumwail; kumwail sohte pahn kin wia mehkot.” ");
INSERT INTO pon2006a_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","KAUN-O ahpw mahsanihong Moses, “Dahme ke likilikwerihkin ie? Pakairkihong mehn Israel kan, re en mweselda. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","A kowe pwekada omw sokonen, oh kapahwei pohn sehden, pwe en pwalpeseng wiahda kehl riau, pwe mehn Israel kan en kak keidwei nanwerenge duwehte pohn ngalangal. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","I pahn kakeptakaila mehn Isip kan pwe re en pwakihkumwailwei. Eri, wauwi ahpw pahn sansal ni ei pahn powehdi Parao, oh sapwellime sounpei koaros, iangahki werennansapw akan oh pil sountangahki kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ni ei pahn kaloweiraildi, mehn Isip kan pahn esehla me iei ngehi KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Eri, tohnleng en Koht, me kin tieng mwohn karis en mehn Israel ko, e ahpw keseulahng mwurirail. Uhren depweko me kin mi mwohrail pil keseudohng mwurirail ");
INSERT INTO pon2006a_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","oh uhda nanpwungen karis en mehn Isip oh karis en mehn Israel ko. Eri, pwohngo me dapwakin oh me inenen rotorot lao lel nimenseng, oh karis riauo sohte kak kerenpene erein pwohngo pwon. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moses eri kapahla peho pohn sehdo, KAUN-O ahpw ketin kammadakihda sehdo kisinieng kehlail ehu sang palimese, me ipihpdo erein pwohngo pwon, oh kammadahda sehdo. Pihl akan lao kohpeseng wiahda kehl riau, ");
INSERT INTO pon2006a_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","mehn Israel ko ahpw kotehla wasao kekeid pohn ngalangal nanpwungen kehl en pihl riau palimeing oh palimaun. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Mehn Isip ko ahpw pwakihirailla oh idawehniraillahng nanwerengen sehdo, iangahki wararail oahs koaros, werennansapw akan oh sountangahki ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Nin sohrahn KAUN-O ahpw ketin mahsendihdo sang ni uhr kisinieio oh ni uhren depweko, mahsendidohng pohn karis en mehn Isip ko, oh ketin kapingirailda. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Pwe e ketin katengehla daian werennansapw ako, me kahrehda re sohla kak tang. Mehn Isip ko eri nda, “Kitail pweiekla oh tangasang mehn Israel kan, pwe KAUN-O me ketin pelian kitail oh mahmahwenkin irail.” ");
INSERT INTO pon2006a_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","KAUN-O ahpw mahsanihong Moses, “Kapahwei pehmwen pohn sehden, pwe sehden en pwilidohng pohn mehn Isip kan, oh pohn wararail werennansapw akan, iangahki sountangahki kan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moses eri kapahla peho pohn sehdo, a nimensehngie pilen sehdo koaros pa pwurpenehng nan dewe. Mehn Isip ko eri songosong re en tangasang ahden pihlo, re ahpw lohdiong loale, KAUN-O eri ketin kakihrirailla nan sehdo. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Sehdo eri pwurpene oh koaduhpwaldi karis en sounpei koaros, iangahki werennansapw akan, oh sountangahki kan, me pwakihala mehn Israel ko nansedo; sohte emen pitla. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","A mehn Israel ko keidlahte nan sehdo duwehte pohn ngalangal, nanpwungen kehl riaun pihl ni palimeing oh palimaun. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ih duwen KAUN-O eh ketin kapitala mehn Israel ko rahno sang mehn Isip ko. Mehn Israel ko ahpw kilang duwen mehn Isip ko ar mehla oh engiengpene pohn oaroahro. ");
INSERT INTO pon2006a_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Re pil kadehdehier manaman lapalap me KAUN-O ketin kasalehiong mehn Isip ko; irail eri lemmwikihda KAUN-O oh pwosonla ih oh sapwellime ladu Moses. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Moses oh mehn Israel ko eri koulkihong KAUN-O koul pwoatet: “I pahn koulkihong KAUN-O apwoat koulen, kapingpen roson lapalap en sapwellime powehdi, pwehki e ketin kakihralahng nan kepin madau oahs akan oh soundakepahr akan. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","KAUN-O me kehlepei kehlail; ih me ketin kapitiehla. Ih me ei Koht, I pahn kin kapikapinga; ih me Koht en semeio, I pahn kin koulki sapwelime roson lapalap. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","KAUN-O iei sounpei kommwad men; KAUN-O iei mware. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“E ketin sikendiong karis en sounpei en Isip kan oh wararail kan nan kepin madau; kaunen sounpei wadawad koaros ahpw duhla nan Sehd Weitahta. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ahden sehdo koaduhpwaliraildi; re ahpw kihrla, rasehng peitehl ehu me kin kihrdiong nan kepin madau. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Maing KAUN, meid kapwuriamwei roson en nin limomwi palimaun; me kin sipedpeseng at imwintihti kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Komw ketin kamwomwalahr sapwellimomwi imwintihti kan, ni roson lapalap en powehdi; engieng en nan kupwuromwi kamwasikairaillahr, rasehng mpwulen kisiniei me kin karoangehla dihpw meng. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Komwi ketin peuk sehdo, e ahpw pwalpeseng; wiahla kelen pihl riau, oh ngalangaldier lel nan kapi. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","At imwintihtio ahpw kahski, ‘I pahn pwakih irail oh koliraildi; I pahn nehkpeseng ar kepwe kan, oh kihsang irail mehkoaros me I anahne; I pahn usada nei kedlahs, oh adihasang mehkoaros me re ahneki.’ ");
INSERT INTO pon2006a_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ahpw, Maing KAUN, esingek teieu sang rehmwi, a mehn Isip ko duhla; re kihrla, rasehng leht, nan ahden pihlo. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Maing KAUN, ihs rehn koht akan me duwehte komwi, me sarawihe kowahlap? Ihs me duwehte komwi, me manaman lapalahpie, oh lammwin kowahlahpie ni wiepen nin limomwi kan? ");
INSERT INTO pon2006a_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Komw ketin kapahwei nin limomwi palimaun, a sampah ahpw kadallehla at imwintihti kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Komw ketin loalopwoatohng sapwellimomwi inowo, ni omwi ketin kahluwahier aramas akan me komw ketin kapitalahr; ni manaman en sapwellimomwi roson, komw ketin kahluwadohng irail nin limomwi sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Tohn wehi kan rongehr oh masepwehkadahr; pwunod laud ehu, rasehng medek en neitik, ahpw kepehdier mehn Pilisdia kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Kaunen Edom kan eri masepwehkadahr, me lapalap en Mohap kan tapihadahr rerrer, tohn Kenan koaros nan kapehd tikitiklahr. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Re masepwehkadahr oh lemmwidahr. Maing KAUN, re kilang sapwellimomwi roson, re ahpw uh nennenkihla ar masepwehk lao sapwellimomwi aramas akan douluhlwei— sapwellimomwi aramas akan me komwi kapitasang nan mour en lidu. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Komw ketin kahluwairaildo oh koasoanediong irail pohn sapwellimomwi nahna, Maing KAUN, wasa me komw ketin wiahda ie mwoalomwi, Tehnpas me pein komwi ketin wiahda. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Maing KAUN, komwi me pahn ketin nanmwarki erein dih koaros kohkohlahte.” ");
INSERT INTO pon2006a_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ni weren mehn Isip ko oahs akan, iangahki werennansapw ako oh soundakepahr ako, keidla nansedo, KAUN-O ketin kapwilodohng sehdo pohrail oh koaduhpwalikiniraildi. A mehn Israel ko ahpw kotehla wasao, sapasapal kohla pohn ngalangal. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Lih soukohp Miriam, rien Aaron, eri ale soangen keseng ehu me ede dampwurin; oh lih koaros idawehnla pil kesekesengki dampwurin oh kahkahlek. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam ahpw koulkihong irail koul pwoatet: “Kumwail koulkihong KAUN-O apwoat koulen, kapingpen roson lapalap en sapwellime powehdi; pwehki eh ketin kakihralahng nan kepin madau oahs akan oh soundakepahr akan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moses eri kaunopada mehn Israel ko pwe re en mweselsang ni Sehd Weitahtao kolahng nan sapwtehn en Sur. Re sapasapalki rahn siluh nan sapwtehn oh sohte diar pihl. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Re ahpw lellahng wasa me adaneki Mara, ahpw re sohte kak nim pilen wasao pwe me nohn sadik. Ihme kahrehda re kihong eden wasao Mara. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Aramas ako eri kaulimala oh lipahnedihada Moses, ndahng, “Dahme se pahn nim?” ");
INSERT INTO pon2006a_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moses eri kapakap ngidingid ong KAUN-O; KAUN-O eri ketin kasalehiong lepin tuhke lep; Moses ahpw kesehdiongete nan pihlo, pihlo pa ioula, sohla sadik. Ih wasaht me KAUN-O ketikihong irail kosonned kei, oh pil ketin song irail. ");
INSERT INTO pon2006a_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","E mahsanihong irail, “Ma kumwail pahn peikiong ie douluhl oh kapwaiada dahme pwung, oh dadaur ei koasoandi koaros, I sohte pahn kalokehkin kumwail ehu soangen soumwahu suwed ko me I kalokehkier mehn Isip ko. Pwe iei ngehi KAUN-O me kin kamwahwihkumwailla.” ");
INSERT INTO pon2006a_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Mandahn rahno re ahpw douluhllahng Elim, wasa me utuhnpihl eisek riau oh tuhke pahm isihsek mi ie. Irail eri kauwada imwarail impwal ko wasao limwahn pihl ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Eri pokon en mehn Israel ko ahpw mweselsang Elim, oh ni eisek limaun keriaun sounpwong, mwurin ar mweselda sang Isip, re ahpw lellahng sapwtehn en Sur, me mihte nanpwungen Elim oh Sainai. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Irail koaros eri kaulimala oh lipahnedihada Moses oh Aaron nan sapwtehno, ");
INSERT INTO pon2006a_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","re ndaiong ira, “E mwahwongete KAUN-O en ketin kemeikitala nan Isip, wasa se kin mwomwohdete mpen nait einpwoat en uduk ko oh tungutungoale uwen sali me se anahne. Komwi ahpw kahreikitodohng nan sahpwtehn wet pwe se en mehkihla duhpek.” ");
INSERT INTO pon2006a_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","KAUN-O ahpw mahsanihong Moses, “I pahn kamwerehdiong kumwail koaros pilawa sang pahnlahng. Rahn koaros aramas akan en kohieisang nan imwarail kan oh kihpene arail tungoal me pahn kin itarohng rahn ehu. Pwe I men song irail, ma re pahn idawehn ei kosonned akan de soh. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ni keweneun rahn, re en kihpene pak riapak uwen me re kihpene rahn teiko, oh kaunopada.” ");
INSERT INTO pon2006a_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moses oh Aaron eri padahkihong mehn Israel ko koaros, “Soutik wet kumwail pahn ese me KAUN-O, iei ih me ketin kahluwaikumwaildo sang Isip, ");
INSERT INTO pon2006a_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","oh nimengseng kumwail pahn kilang lingaling en KAUN-O. Pwe e ketin karongeier amwail kaulime—ei, amwail kaulime, pwe kiht, ihte at pwais, kapwaiada sapwellime kaweid kan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moses ahpw pil patohwan, “KAUN-O me pahn ketikihong kumwail uduk pwe kumwail en tungoale nin soutik wet, oh uwen pilawa me kumwail mwahuki nimenseng en lakapw, pwehki eh ketin karongeier kaulim oh lipahned kan me kumwail wiahiong. Pwe kaidehn kiht me kumwail kaulime, pwe KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moses eri ndaiong Aaron, “Ndaiong pokon en mehn Israel koaros re en patohdo oh uh mwohn silangin KAUN-O, pwe e ketin karongeier arail tungoal lipahned kan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Nindokon Aaron eh kapakapahrekiong pokono, re sohpeilahng nan saptehno, lingaling en KAUN-O pa pwarada nan pelien depwek pali. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","KAUN-O eri mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“I rongehr kaulim kan en mehn Israel. Padahkihong irail, me nin soutik kumwail pahn tungoale uduk, oh nimenseng kumwail pahn medkihla pilawa. Pwe irail en ese me ngehi, KAUN-O, iei arail Koht.” ");
INSERT INTO pon2006a_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Nin soutikpene kulu ngedehrie ahpw pihrdo oh kipehdi kahnimpwal ko, oh nimenseng pwoaik mwarakpeseng wasa koaros nan kahnimwo. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ni pwoaiken mensengo eh sohrala, mie mehkot tikitik pohn pwehl en sapwtehno me menipinip duwehte wunen mwahmw. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ni mehn Israel ko ar kilangada, re sehse dahkot mwo, re ahpw peipeidekpene nanpwungarail, ndinda, “Dahkot met?” Moses eri ndahng irail, “Ih pilawao met me KAUN-O ketikihong kumwail pwe kumwail en tungoale. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","KAUN-O ketin koasoanehdi pwe emenemen kumwail en kihpene uwen me e anahne tungoale, kereniong paun weneu ong emen aramas.” ");
INSERT INTO pon2006a_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Mehn Israel ko eri wia met, ekei kihpene me tohtohsang, a ekei me malaulausang. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Re ahpw paunihada, oh irail me kihpene tohtohsang me re anahne, e sohte laudla rehrail, oh irail me kihpene malaulausang me re anahne, e sohte tikitikla rehrail. Emenemen kihpenehte uwen me e anahne. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moses ahpw ndahng irail, “Sohte me pahn nahkohng lakapw luhwen mehkot.” ");
INSERT INTO pon2006a_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ekei irail eri sohte men rong Moses, re ahpw nahkihdi luhwe kei ong nimenseng en mandahn rahno. Nimensengo re diarada me e diren mwahs oh ohlahr. Moses eri lingeringerda pahrail. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Re kin kihpene nimenseng koaros uwen me itarohng emenmen; ahpw ni ahnsou me ketipin kin karakarala, e kin peipeseng. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ni keweneun rahn irail ahpw kihpene pak riau uwen tungoal me itarohng rahn ehu, paun eisek riau ong aramas emen. Kaunen mehn Israel koaros ahpw pwarodo rehn Moses oh pakairkihong duwen met, ");
INSERT INTO pon2006a_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","e ahpw ndaiong irail, “KAUN-O mahsaniher, me lakapw rahn sarawi, rahnen kommoal ehu, oh kasarawihong KAUN-O. Kumwail pahn umwunda dahme kumwail men umwun, oh pwoailihada dahme kumwail men pwoailih. Luhwe koaros kumwail pahn nekidala ong lakapw.” ");
INSERT INTO pon2006a_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Irail eri kapwaiada dahme Moses nda; re nahkohng mandao luhwe ko. Eri, e sohte ohla, oh sohte mwahs dierekda loale. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moses eri nda, “Kumwail tungoale met rahnwet, pwehki iei rahnen kommoal me kasarawihong KAUN-O, oh kumwail sohte pahn dierek mwenge nansapw. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Erein rahn weneu kumwail pahn kin kihpene, pwe ni keisuhwen rahn, me iei rahnen kommoal, kumwail sohte pahn diar.” ");
INSERT INTO pon2006a_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ni keisuhwen rahno ekei ahpw kohieilahng kihpene, re ahpw sohte diar mehkot. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","KAUN-O eri mahsanihong Moses, “Ia erein amwail sohte pahn kapwaiada ei kosonned akan? ");
INSERT INTO pon2006a_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kumwail tamanda pwe ngehi, KAUN-O, I kihong kumwail rahnen kommoalo, ihme kahrehda ni keweneun rahn I kihong kumwail mwenge me itarohng rahn riau. Koaros en mihmihte nan dewe ni keisuhwen rahn; sohte me pahn kohieila liki.” ");
INSERT INTO pon2006a_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Iei me aramas ako sohte kin doadoahngki ni keisuhwen rahn. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Mehn Israel ko kihong eden kisin mwengeo, manna. E duwehte werentuhke koriander; ahpw poh pwetepwet oh nemenemen keik me doal sukehn loangalap. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses ahpw nda, “KAUN-O, ketin mahsanih, kitail en nekidala ekei manna, pwehn nekinekohng kadaudokatail kan, pwe re en kilang soangen kisin tungoal me e katungoalehkin kitail nan sapwtehn ni eh kahluwaikitaildo sang Isip.” ");
INSERT INTO pon2006a_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moses eri ndaiong Aaron, “Ale ehu sahn oh audehkihda elep en kalon en manna, ke ahpw kihdiong mwohn silangin KAUN-O pwe en nekinekiong kadaudokatail kan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aaron eri kihdiong mwohn Kohpwahn Inowo saho, nin duwen KAUN-O eh ketin mahsanihong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Mehn Israel ko eri tungutungoale manna wet erein pahr pahisek, re lao lel wasa me re soandi ie, nan Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Elep en kalon pahrekiong eisek kis ehun mehnsohngo me re kin sohngki werentuhke kan.) ");
INSERT INTO pon2006a_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Mehn Israel ko koaros ahpw mweselda sang sapwtehn en Sin, re ahpw kin kommoaldi wasa kan me KAUN-O kin ketin kilelehdi re en kommoal ie. Nan Repidim re ahpw uhdi ie oh kauwada imwarail impwal kan, ahpw sohte pihl wasao mehn nimpil. ");
INSERT INTO pon2006a_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Irail eri pelianda Moses oh ndaiong, “Komw kanimpilei kiht wasaht.” Moses eri sapeng irail, nda, “Dahme kumwail uhkihong ie? Dahme kumwail men songki KAUN-O?” ");
INSERT INTO pon2006a_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ni ar men nimpildahr, re ahpw lipahnedihada Moses, ndinda, “Dahme komw wahkinkitodo sang Isip? Pwe komwi en kemeikitala, iangahki nait seri oh pil nait mahn akan?” ");
INSERT INTO pon2006a_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moses ahpw kapakap ngidingidiong KAUN-O, patohwanohng, “Maing, dahme I pahn wiahiong aramas pwukat? Re nektehn kostakai ie.” ");
INSERT INTO pon2006a_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","KAUN-O ahpw mahsanihong Moses, “Kahrehda kaunen mehn Israel kan, oh kumwail kohwei mwohn aramas akan. Wa kohwei omw sokon me ke poakiheki Pillap Nail. ");
INSERT INTO pon2006a_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","I pahn uh mwohmw wasao pohn Nahna Sainai. Ke pahn poakih paipo, a pihl ahpw pahn kusieisang, pwe aramas akan en nimpilsang ie.” Moses eri wiahda mepwukat mwohn kaunen mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Wasao eri adanekihla Massa oh Meripa, pwehki mehn Israel ko ar kaulim, oh kasongosonge KAUN-O ni ar nda, “KAUN-O ketin ieiang kitail, de soh?” ");
INSERT INTO pon2006a_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Mehn Amalek kan ahpw kohdo oh men mahweniong mehn Israel nan Repidim. ");
INSERT INTO pon2006a_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moses eri ndaiong Sosua, “Pilada ekei ohlen, ke ahpw kohwei lakapw oh mahweniong mehn Amalek kan. I pahn uh pohn dohlo, kolokol sokon me Koht ketikihong ie.” ");
INSERT INTO pon2006a_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Sosua eri kapwaiada dahme Moses ndaiong, ih eri mahweniong mehn Amalek ko; a Moses, Aaron oh Hur ahpw kohdahla pohn dohlo. ");
INSERT INTO pon2006a_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Eri, nindokon Moses kapakapahda peh ko, mehn Israel ko kin pweida nan mahweno; a ni eh kin kadaridi peh ko, mehn Amalek ko kin tapihada pweida. ");
INSERT INTO pon2006a_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ni pehn Moses ko eh daula, Aaron oh Hur ahpw ale takai ehu oh kamwohdangdiong Moses powe, ira ahpw kesikesihnen mpe kolokolada peh ko; lao ketipino kihrla. ");
INSERT INTO pon2006a_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Sosua eri kalowehdi mehn Amalek ko koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","KAUN-O eri mahsanihong Moses, “Ntingihedi met nan pwuhk, pwe en wia mehn kataman ehu. Ke ahpw kairehki Sosua me I pahn irisasang pahnlahng mwaren Amalek, pwe katamanpe en dehr kin wiawi.” ");
INSERT INTO pon2006a_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moses eri kauwada pei sarawi ehu wasao, me e kihong ede, “KAUN-O iei ei Pilaik.” ");
INSERT INTO pon2006a_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","E ahpw pil nda, “Kolada pilaik en KAUN-O! KAUN-O pahn kin ketin mahweniong mehn Amalek kohkohlahte!” ");
INSERT INTO pon2006a_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Semen en Moses eh pwoudo, me adaneki Sedro, samworo en Midian, rongada duwen mehkoaros me Koht ketin wiahiong Moses oh aramas en Israel ko ni e ketin kahluwairail sang nan Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ohlo ahpw kohla rehn Moses iangahki en Moses eh pwoudo, Sipora, me mihmihte iangahki neira pwutak riemen. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Emen pwutako adaneki Kersom; pwe Moses patohwan, “I wiahier mehn liki men nan sapwen mehn liki.” ");
INSERT INTO pon2006a_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Meteio adaneki Elieser; pwe e mahsanih, “Koht en semei iei sawasepei; oh e ketin doareiesang nin limen nanmwarkien Isip.” ");
INSERT INTO pon2006a_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Sedro eri kohla rehn Moses nan sapwtehn wasa e kauwada ie imwe impwal ko limwahn nahna sarawio, iangahki en Moses eh pwoudo oh nah seri riemeno. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","E ahpw pakairkilahng Moses me re kohkolahng reh. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moses eri kohla tuhwong oh poaridi mwowe oh metik; mwurin ara rahnmwahupene, re ahpw kohla nan imwen Moses impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moses eri padahkihong Sedro soahng koaros me KAUN-O ketin wiahiong nanmwarkien Isip, oh ong mehn Isip ko pwe en ketin kapitala mehn Israel ko. E pil padahkihong duwen apwal laud me re aledier nan ar seiloak oh duwen KAUN-O eh ketin kapitirailla. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Sedro inenen perenkihda eh rongada mepwukat koaros, ");
INSERT INTO pon2006a_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","e ahpw patohwan, “Kapinga KAUN-O, me ketin kapitkumwailla sang nanmwarkio oh aramas en Isip ko! Kapinga KAUN-O, me ketin kapitala sapwellime kan sang nan mour en lidu! ");
INSERT INTO pon2006a_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","I eseier me KAUN-O ketin lapalapasang koht koaros, pwehki eh ketin wiahda met nindokon mehn Isip kan ar wiakauwe oh mwamwahliki mehn Israel kan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Sedro eri wahdo meirong isihs ehu oh soangen meirong teikan pwe en meirongkihong Koht; Aaron oh kaunen mehn Israel koaros ahpw iang Sedro mwohdehng sak sarawio, nin duwen tiahk en kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mandahn rahno Moses ahpw soupisengkihla wiepen kopwung nanpwungen aramas ako me reperepen pwung reh sang nimenseng lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ni Sedro eh tehkada mehkoaros me Moses wiewiahiong aramas ako, e ahpw idek reh, “Dahme komw wiewiahiong aramas akan? Dahme komw kelehpw wiewiahki soahng pwukat koaros, aramas akan ahpw kin kesikesihnen awiawih wasaht sang nimenseng lel nin soutik pwe re en kin ale kaweid sang rehmwi?” ");
INSERT INTO pon2006a_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moses ahpw sapeng, patohwan, “I pahn wia met pwe aramas akan kin patohdo rehi pwe re en ese dah kupwur en Koht. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ni ahnsou me aramas riemen kin akamaida, re kin kohdo rehi, I ahpw kin koasoanehdi ihs rehra me pwung oh kin padahkihong ira sapwellimen Koht koasoandi kan oh kosonned akan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Sedro eri nda, “E sohte pwung dahme komw wiewiahn. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Komwi oh aramas akan uhdahn pahn pwangada. Doadoahk wet me nohn toutou oh komwi sohte kak kelehpw wiewia men. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Komw karonge ie mahs, oh I pahn patohwanda ehu kaweid mwahu en, oh Koht en ketin ieiang komwi. Me mwahu omwi wia wiliepen aramas akan mwohn silangin Koht oh omwi kin patohwandahng pahn kupwure ar kahpwal akan. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Komw pahn kin kawehwehiong irail duwen kupwur en Koht oh duwen ar pahn kin momour oh dahme re pahn kin wia. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ahpw komw pahn pilada sang rehn aramas akan ekei me koahiek oh koasoanehdi pwe re en kin wia kaunen aramas akan: kaunen aramas kid, epwiki, limehk oh ehk. Aramas pwukat uhdahn pahn masak Koht, pahn likilik oh sohte kin kapehd mwersuwed. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Mweidohng irail en wia sounkopwung, a ong ni ire kesempwal akan re en kin tuhkihong komwi; re en kin pein kapwungala nanpwungarail soangen ire kan me sohte nohn kesempwal. Met pahn mengeiong komwi, ma re pahn iang sewese omwi doadoahk toutouen. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ma komw pahn wia met, duwen me Koht ketin mahsanih, komw sohte pahn tihwokihla oh aramas pwukat koaros pahn pwurala ni imwarail kan nsenamwahu.” ");
INSERT INTO pon2006a_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moses eri idawehn kaweid en Sedro ");
INSERT INTO pon2006a_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","oh pilada aramas koahiek kei sang rehn mehn Israel ko. E kilelehdi pwe re en kin kaunen me kid, epwiki, limehk oh ehk. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Re ahpw kin wia sounkopwung en mehn Israel ko, oh ni mehkan me kesempwal oh apwal re kin tuhkihong Moses, a re kin kapwungala mehkan me sohte nohn apwal. ");
INSERT INTO pon2006a_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Moses eri rahnmwahwihala Sedro, Sedro ahpw mwesel kohkolahng nan uhdakeo. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Ni keieun rahnen kesiluhwen sounpwong mwurin ar mweselsang nan wehin Isip, mehn Israel ko seiloak sang Repidim, re lel nan sapwtehn en Sainai, irail eri kauwada ie imwarail impwal kan sallahng Nahna Sainai. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moses eri patohdahla pohn nahnao pwe en tuhwong Koht. KAUN-O eri mahseniong sang pohn nahnao, e mahsanih en patohwanohng mehn Israel kan, kadaudok en Seikop kan: ");
INSERT INTO pon2006a_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Kumwail pein kilangehr dahme ngehi, KAUN-O, wiahiong mehn Isip kan oh duwen ei waikumwaildo duwehte ikel men me kin wa nah kan pohn peh kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Eri, ma kumwail pahn peikiong ie oh dadaur ei inou, kumwail pahn wiahla nei aramas kesempwal. Tohn sampah pwon uhdahn nei, ahpw kumwail me pahn wiahla nei aramas pilipil. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Kumwail eri pahn wiahla wehi ehu me pahn papah ie duwen samworo, pwihnen aramas ehu me kasarawihong iehte.” ");
INSERT INTO pon2006a_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moses eri patohla kapokonepene kaun ako oh patohwanohng irail mehkoaros me KAUN-O mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Aramas ako koaros eri wiahkinteieu sapeng, patohwan, “Se pahn kapwaiada mehkoaros me KAUN-O ketin mahsanih.” Moses eri sakarkidahng KAUN-O en aramas ako pasapeng. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","KAUN-O ahpw mahsanihong Moses, “I pahn pwarodo rehmw nan depwek mosul ehu, pwe aramas akan en rong ei kin koasoi ong uhk, pwe re en kin kamehleleiuk.” Moses eri patohwanohng KAUN-O pasapeng en aramas ako. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","KAUN-O ahpw mahsanihong Moses, “Pwurowei rehn aramas akan oh padahkihong irail pwe rahnwet oh lakapw re en onopohng kaudok. Re en lopworada ar likou kan ");
INSERT INTO pon2006a_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","oh onopadahng pali. Pwe rahno I pahn kohdihwei pohn Nahna Sainai, wasa me aramas akan koaros kak kilang ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ke pahn wiahda kehl ehu kapilpene nahnaht, irepen aramas akan, oh padahkihong irail kaleke re de kohdahdo nin nahnaht de pil sair tapi. Mehmen me pahn sair nahnaht, e pahn kamakamala; ");
INSERT INTO pon2006a_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","sohte aramas pahn sair, pwe e pahn kostakaidi de kesingkihdi kesik ketieu. Eri, met pahn wiawihong aramas de mahn akan; re uhdahn pahn kamakamala. Ahnsou me ngilen sowi pahn lokaia, iei ahnsou me aramas akan pahn mwekididohng nin nahnaht.” ");
INSERT INTO pon2006a_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moses eri patohdihdo sang nin nahnao, patohdidohng rehn aramas akan, pwe en kaunop kin irail kaudoko. Mwurin ar kamwakelehda ar likou kan, ");
INSERT INTO pon2006a_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Moses ahpw ndaiong irail, “Kumwail onopadahng pali; kumwail dehpa wia nsenen pwopwoud.” ");
INSERT INTO pon2006a_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Eri, nimenseng en kesiluhwen rahn, nansapwe ieu pa pos pohn nahnao, lioal tapihada piripir, oh pelien depwek mosul pali pa kipehdi pohn nahnao; oh ngilen sowi laud ehu pa kadirehla nan wehwe. Aramas koaros en nan kahnimpwalo salohkihda kowahlap. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moses eri kahrehda aramas ako sang nan kahnimpwalo pwe re en patohlahng kasamwo Koht. Re ahpw uhdi oh awiawih nin tepin nahnao. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ediniei moron ehu eri koaduhpwaldi Nahna Sainai pwon, pwe KAUN-O ketididohr powe ni sansal en mpwulen kisiniei. Edied en nahnao rasehng edin uhmw kalaimwun ehu. Aramas akan koaros ahpw salohkihda kowahlap. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ngilen sowio wie lalaudla oh ukla mehlel. Moses kin pato, a Koht ketin sapengki ngilen nansapwe. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","KAUN-O ketidihdo pohn kumwen Nahna Sainai, oh ketin malipe Moses wasao; Moses eri patohdahla reh. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","KAUN-O eri mahsanihong, “Kohdihwei oh kehkehlingkihong aramas akan re dehpa kotehla kehlo pwe re en kodohng kilang ie, pwe ma re pahn wia met, me tohto rehrail pahn mehla. ");
INSERT INTO pon2006a_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Pil samworo kan me kin kerendohng ie, re pahn uhdahn kamwakele pein irail, pwe ma soh, I pahn kalokei irail.” ");
INSERT INTO pon2006a_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moses ahpw patohwanohng KAUN-O, “Aramas akan sohte kak patohdahdo, pwehki omwi ketin mahsanihong kiht se en wiahkihla nahna sarawi ehu met oh se en wiahda ehu kehl kapilkipene.” ");
INSERT INTO pon2006a_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","KAUN-O ahpw mahsanihong, “Kohdihwei oh kahredahdo Aaron. A samworo kan oh aramas akan sohte pahn kotehla kehlo pwe re en kohdadohng rehi, pwe ma re pahn wia met, I pahn kalokei irail.” ");
INSERT INTO pon2006a_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Moses eri patohdihla rehn aramas ako oh patohwanohng irail mepwukat koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Koht ketin poahngoak. oh iet audepe kan: ");
INSERT INTO pon2006a_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ngehi me KAUN-O, amwail Koht, me kahluweikumwaildo sang nan wehin Isip, wasa me kumwail kaliduhla ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Kumwail sohte pahn ahneki emen koht tohrohr mwohi. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Kumwail sohte pahn wiahiong kumwail dikedik en eni de sansal en mehkot me mi pahnlahng, de nin sampah, de nan pihl kan pahn sampah. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Kumwail sohte pahn poaridiong dikedik en eni men de pwongih, pwe iei ngehi me KAUN-O, amwail Koht, ngehi Koht luwakahk emen. Irail me kin kailongkin ie, I kin kaloke nair seri kan lel dih kesiluh oh kapahieu. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","A I kin kalahngan poatopoat ong irail kan me kin poakohng ie oh kapwaiada ei kosonned akan. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Kumwail sohte pahn kasaminehla mwarei, pwe ngehi, KAUN-O, amwail Koht, pahn kaloke mehmen me kin kasaminehla mwarei. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Kumwail tamataman rahnen Sapad, oh wiahki rahn sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Kumwail pahn kin wia amwail doadoahk koaros erein rahn weneu, ");
INSERT INTO pon2006a_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","a ni keisuhwen rahn, iei rahnen kommoal, kumwail pahn kasarawihong ie. Rahno sohte me pahn doadoahk—kumwail, oh noumwail seri kan, oh amwail lidu kan, oh noumwail mahn akan, oh mehn keiru kan me koukousoan rehmwail. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Erein rahn weneu ngehi, KAUN-O, me wiahda nanleng, sampah, madau kan, oh audepahr koaros, a ni keisuhwen rahn I kommoaldi. Ih kahrepen ngehi, KAUN-O, kasarawihala rahnen Sapad oh wiahkihla rahn sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Kumwail wauneki samamwail oh inamwail kan, pwe kumwail en mour werei nan sahpw me I pahn kihong kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Kumwail sohte pahn kemehla aramas. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Kumwail sohte pahn kamwahl. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Kumwail sohte pahn pirap. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Kumwail sohte pahn karaunlikamwohng aramas emen. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Kumwail sohte pahn noahroke imwen emen. Kumwail sohte pahn noahroke en emen eh pwoud, de eh lidu, de nah ahs de nah kou, de mehkot me uhdahn ah.” ");
INSERT INTO pon2006a_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ni aramas ako ar rongada nansapweo oh ngilen sowio, oh kilangada lioal eh piripir, oh nahnao eh wie edied, re rerrerki ar masepwehkada, oh uh kailalahsang nahnao. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Re ahpw ndaiong Moses, “Komwi me en koasoiong kiht, se ahpw pahn rong; a ieremen Koht, pwe se de mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moses ahpw sapengkin irail, “Kumwail dehr masak; pwe Koht ketido rehmwail pwe en ketin song kumwail, pwe kumwail en peikiong oh dehr wiahda dihp.” ");
INSERT INTO pon2006a_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ahpw aramas ako pil mihmihte kailalahsang nahnao; a Moses kelehpw me patolahng limwahn depwek mosul wasa me Koht ketiket ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","KAUN-O ketin mahsanihong Moses en padahkihong mehn Israel ko, “Kumwail pein kilangehr duwen ei mahseniongkumwailehr sang nanleng. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kumwail dehr pein wiahiong kumwail koht kohl de silper pwe kumwail en pwongih duwehte amwail kin pwongih ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Kumwail pahn wiahda ehu pei sarawi pwehl ong ie, oh pohn pei sarawi wet me kumwail pahn meirongkihong ie noumwail sihpw kan oh kou kan, nin duwen meirong isihs oh meirong en kaminimin. Wasa koaros me I pilada pwe kumwail en kin kaudokiong ie, I pahn kin iang kumwail mi wasao oh I pahn kin kapaikumwailda. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ma kumwail pahn wiahiong ie pei sarawi takai, kumwail dehpa wiahkihda takai perper, pwe ni amwail kin doadoahngki sisel pohn takai, kumwail kin kasaminehkihla pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Kumwail dehr kin wiahiong ie pei sarawi me kumwail kin doudahla pohn kehndake, pwe kumwail dehr kin sansal suwed ong aramas ni amwail kin karada powe. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Kihong mehn Israel kan kosonned pwukat: ");
INSERT INTO pon2006a_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ma kumwail pwainda lidu mehn Ipru men, e pahn liduwihiuk erein sounpar weneu; ni keisuhwen sounparo, e pahn saledekla sohte ale pweipwei. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ma e kiripw ni eh wiahla omw lidu, e pahn pil kiripw ni eh pahn mweselda; a ma e pwopwoud ni eh wiahla omw lidu, e pahn wa eh pwoud kohkohla. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ma eh soumas me kihong eh pwoud, eh pwoudo ahpw naitikihada nah pwutak de serepein kei, liho oh nah seri ko pahn mihmihte rehn soumaso nin duwen mehkot me uhdahn ah, a ohlo pahn kelehpw kohkohla. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ahpw ma liduwo kasalehda me e poakepoake eh soumaso, eh pwoud oh nah seri kan, oh e sohte men saledekla, ");
INSERT INTO pon2006a_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","eri eh soumaso pahn walahng wasahn kaudok. E pahn ndahng en kesihnenda ni wenihmw de ni uhr en ihmwo, ih eri pahn kihong en doaksaleng. Liduwo eri pahn wiahla nah lidu erein eh mour. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Ma aramas emen pahn netikihla nah serepein nin duwen lidu men, e sohte pahn kak saledekla duwehte lidu ohl kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ma e pahn netila rehn emen ohl me men wiahki eh pwoud, ahpw ohlo sohte mwahuki, eri serepeino pahn pwurehng netila rehn eh pahpao; eh soumaso sohte kak netikihla rehn mehn liki men, pwehki eh sohte pwung dahme e wiahiong serepeino. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ma ohl emen pahn pwainda serepein lidu men pwehn kihong nah pwutak, ohlo pahn wiahki serepeino duwehte uhdahn nah. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ma ohl emen pahn alehda emen lih tohrohr likin uhdahn eh pwoud, ohlo pahn uselahte kihkihong uhdahn eh pwoudo kisin mwenge, likou oh soangen pwuhngohte me liho ahneki mahs. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ma e sohte kapwaiada soangen pwukoa pwukat ong uhdahn eh pwoudo, e pahn kasaledekala liho sohte ale pweipwei ehu. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Mehmen me pahn keme emen aramas oh kemehla, e pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ahpw ma e depweikihla, kaidehn e nsenki kemehla, e kak tangala wasa kis me I pahn koasoanediong, oh e pahn rukula wasao. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ahpw ma aramas emen pahn lingeringer oh kemehla aramas emen sang nan nsene, e pahn kamakamala, mehnda ma e pahn tenge ei pei sarawi pwehn rukula ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Mehmen me pahn keme seme de ine en kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Mehmen me pahn pirapahla emen aramas oh netikihla, de kolokol pwehn wiahki eh lidu, en kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Mehmen me pahn lahlahwe seme oh ine, en kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Ma aramas riemen pahn peida, oh emen pahn kalipwelipwekihda meteio takai de peh, ahpw sohte kemehla, e sohte pahn alehki kalokolok. Ma aramas me lipwalipwadahro pahn mihmihki nan peht pwehki eh ohlao, ");
INSERT INTO pon2006a_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ahpw mwuhr e pwourda oh kohkohseli wie doadoahngki sokon, aramas me kalipwelipwehdao pahn pwukoahki pwain pweinen rahn ako me e mihmihki nan peht sohte doadoahk oh pweinen koadoahkpen eh ohla kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Mehmen me pahn wokih eh lidu ohl de lih, liduwo ahpw mehla ni ahnsowohte, aramas menet pahn uhdahn ale kalokolok. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ahpw ma liduwo sohte mehla mwurin rahn ehu de riau, soumaso sohte pahn ale kalokolok. Pwehki liduwo eh wia mehkot me uhdahn ah. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ma aramas ekei peida oh lel lih liseian emen kahrehda eh liseiano ohla ahpw paliweren liho sohte ohla, aramas me kahrehiong en liho eh liseiano eh ohla pahn pwukoahki pwain uwe ieu me en liho eh pwoudo pahn koasoanehdi oh mwoalen kopwung pwungki. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ahpw ma liho pahn ale ehu soangen ohla ni paliwere, kalokolok pahn mihmi ni mour pwehki mour, ");
INSERT INTO pon2006a_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","pwoaren mas pwehki pwoaren mas, ngih pwehki ngih, peh pwehki peh, neh pwehki neh, ");
INSERT INTO pon2006a_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","mwasikala pwehki mwasikala, ohla pwehki ohla, wowoki pwehki wowoki. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Ma aramas emen pahn poakih oh kauwehla pwoaren mesen eh lidu ohl de lih, e pahn kasaledekala liduwo pweinen meseo. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ma e kauwehla ngih pwoat rehn eh liduwo, e pahn kasaledekala eh liduwo pweinen ngiho. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ma kouwol men pahn kodom aramas emen lao kemehla, kouo pahn kostakaidi, oh sohte me pahn tungoale uduke; ahpw me nah kouo sohte pahn ale kalokolok. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ahpw ma kouo kin epwehnki poar pohn aramas akan oh aramas me naineki kouo, mwurin kehkehlik kei, e sohte kelehdi—eri ma kouo kemehla aramas emen, e pahn kostakaidi oh me naineki kouo pil pahn iang kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ahpw ma me naineki kouo pahn mweimweiong en kihda uwen mwohni ieu pwehn pitkihsang mehla, e pahn pwainla uwen me kileledi. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ma kouwol men kemehla kisin pwutak kis de kisin serepein kis, soangen kosonned wet pahn pil doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ma kouwol men pahn kemehla lidu ohl de lih, aramas me nah kouo pahn pwainohng soumas me naineki liduwo uwen mwohni silper silisek, oh kouo pahn kostakaidi. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Ma aramas emen pahn kihsang pweinen pwarer ehu, de ma e weirada pwarer ehu oh sohte pwaindi, oh ma kouwol men de ahs emen pahn pwupwudiong loale, ");
INSERT INTO pon2006a_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","e pahn pwain mahno. E pahn pwainohng aramas me nah mahno, ahpw e kak kolokol mahno. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ma nein emen kouwol kemehla nein emen tohrohr nah kouwol, aramas riemeno pahn netikihla kou momouro oh nehkpeseng mwohnio nanpwungara; ira pil pahn nehkpeseng uduk en kou me mehlao. ");
INSERT INTO pon2006a_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ahpw ma e dehde me kouo kin epwehnki pwahki oh poar pohn aramas de mahn oh aramas me naineki kouo sohte kelehdi, e pahn kihong aramas teio kouwol momouro, a e pahn kolokol me mehlao. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Ma aramas emen pirapahda kou men de sihpw men oh kemehla de netikihla, e uhdahn pahn kapwungkihla kou limmen kou emeno, oh sihpw pahmen sihpw emeno. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","E uhdahn pahn kapwungala dahme e pirapadao. Ma sohte mehkot me e kak kapwungkihla, e pahn netila nin duwen lidu men pwehn kapwungala dahme e pirapadao. Ma mahn pirapadao dierekda reh momour, mehnda ma kou men de sihpw men de ahs emen, e pahn kapwungkihla mahn riemen ong mahn emen. “Ma lipirap men dierekda ni eh wehdpeseng imwen emen nipwong, e ahpw kamakamala, aramas me kemehlao sohte pahn dipaniki dipen kamaramas. Ahpw ma met wiawi ni rahn, e pahn dipaniki dipen kamaramas. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Ma aramas emen pahn mweidohng nah mahn akan en mwengemwengeseli nan sahpw de nan mwetin wain, re ahpw pitla oh kangala en emen tohrohr eh wahnsahpw me mi nan sapwe, aramas me naineki mahn ako pahn kapwungala ohla ko sang nan audepen sapwe ko de eh mwetin wain ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Ma aramas emen tapihada isihs nan sapwe, oh kisinieio ahpw doula oh kamwasikahla wahnsahpw me kekeirda de dondolehr oh wonohn, me tapihada isihso pahn pwukoahki kapwungala ohlahn wahnsahpw ako. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Ma aramas emen pwungkihda en nekidala nein emen mwohni de mehkot kesempwal, dipwisowo ahpw pirapasang nan imwe, lipirapo, ma e dierekda, pahn kapwungala uwen dipwisou pirapalao pak riapak. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ahpw ma lipirapo sohte dierekda, aramas me nekinekid dipwisou kesempwal ko pahn wisikdohng ni wasahn kaudok, e ahpw pahn kahula me kaidehn ih me pirapahla dipwisou ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Repenpwung koaros me pid dipwisou, de pil pid kou, ahs, sihpw, likou, de soangen dipwisou pwupwula kan, aramas riemeno me wiewia ara repenpwung, pahn wisikdohng ni wasahn kaudok. Oh mehmen rehra me Koht ketin kasalehda me ih me dipadahr, pahn kapwungohng meteio pak riapak uwen pweinen dipwisowo. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Ma aramas emen pwungkihda en apwalih nein emen aramas nah ahs, kou, sihpw de ehu soangen mahn tohrohr, oh mahno ahpw mehla de ohla de kulsang ni ahnsoun mahwen, oh sohte mie sounkadehdehpen irair wet, ");
INSERT INTO pon2006a_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","aramas me apwalih mahno pahn kohla ni wasahn kaudok oh kahukihla me e sohte pirapasang nein aramas teio nah mahno. Ma mahno sohte pirapala, a aramas me nah mahno pahn mahkikihla ohla de mehlahn mahno, oh aramas me apwalih mahno sohte pahn kapwungala mahno; ");
INSERT INTO pon2006a_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ahpw ma mahno pirapala, aramas me apwalih mahno pahn kapwungohng me naineki mahno. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ma mahn lawalo kei me kemehla, aramaso pahn kapwarehda luhwen mahno pwehn wia mehn kadehde; oh e sohte pahn pwukoahki kapwungala dahme mahn lawalo ko wiahda. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Ma aramas emen pekihsang emen aramas mahn emen pwehn doadoahngki, mahno ahpw ohla de mehla ni ahnsou me aramas me nainekio sohte mie, aramas me pekihda mahno uhdahn pahn pwukoahki kapwungala mahno. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ahpw ma me naineki mahno mihmi ni ahnsou me mahno sapwungala, aramas me pekihda mahno sohte pahn kapwungala. Ma mahn emen me emen pekihda pwehn doadoahngki ni lepin ahnsou, eri pweinen eh doadaohngki mahno pahn kapwungala pweinen mahno. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Ma ohl emen pahn kauwehla meipwon emen me sohte inou en pwopwoud, e uhdahn pahn pwainda serepeino oh pwoudikihla. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ahpw ma en serepeino eh pahpa kahng en pwoudikihda, ohlo pahn kihong en serepeino eh pahpao uwen mwohni ieu me pahrekiong pweinen eh pahn pwoudiki serepein meipwon emen. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Lih emen me kin wunahni en kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Aramas emen me kin dihpki mahn en kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Mehmen me kin meirongohng emen koht likin ngehi, KAUN-O, en kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Kumwail dehr wiakauwe de kaloke mehn liki kan; tamanda me kumwail wiahier aramas en liki kei nan Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Kumwail dehr wiakauwe liohdi men de me sepwoupwou men. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ma kumwail pahn wia met, ngehi, KAUN-O, I pahn rong irail ni ar pahn likweriong ie pwe I en sewese irail, ");
INSERT INTO pon2006a_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","oh I pahn engiengda oh kemeikumwailla nan mahwen. Amwail pwoud kan pahn liohdihla oh noumwail seri kan pahn sepwoupwoula. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ma ke kamangaiong mwohni ong emen nei aramas me semwehmwe, ke dehr idingki en kapwuredohng uhk wihn en noumw mwohnio. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ma ke ale en emen eh sekid pwehn wia kadehdehpen eh pweipwandehng uhk, ke uhdahn pahn kapwurehiong eh sekido mwohn ketipin eh pahn kihrla, ");
INSERT INTO pon2006a_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","pwe ihte eh likou met me e kak likawih pwe en dehr pou. Dahme e pahn uhp nipwong? Ni eh pahn likweriong ie pwe I en sewese, I pahn rong pwe I me kin kupwurkalahngan. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Ke sohte pahn lahlahwe Koht, de keriahla kaunen omw wehi. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Ke pahn meirongkihong ie omw wahn kohn, wain, oh lehn olip ni eh pahn lel ni ahnsawi. “Ke pahn kihong ie mesenih en noumw pwutak kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","“Ke pahn kihong ie mesenih en noumw kou oh sihpw kan. Mweidohng mesenih wolo en mihmihte rehn eh nohno erein rahn isuh, a ni kawaluhn rahn ke pahn meirongkihong ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Nei aramas kumwail, eri kumwail sohte pahn kang uduk en mahn me mahn lawalo kan kemehla, ahpw kumwail kihong kenen kidi kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Ke dehr pakairkiseli rohng likamw akan oh dehr sewesehki me dipadahr emen omw kadehde likamw. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Pil dehr idawehn pali moron en aramas ni ar wia me sapwung de iangirail ni ar kin wia kadehde me pahn kauwehla pwuhng mwohn mwoalen kopwung. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Pil dehr uhpalihki me semwehmwe men nan eh kopwung. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ma ke kilangada nein omw imwintihti men nah kou de ahs eh pitla, ale oh kapwurelahng reh. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ma nein omw imwintihti men nah ahs pwupwudi oh wonohn pahn eh wisik toutou, ke dehr sohpeisang, ahpw sewesehda. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Ke dehr kahmahmkihla pwuhng en emen me semwehmwe nan eh kopwung. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ke dehr karaunlikamw, ke dehr pangala aramas me sohte dipe pwehn kamakamala, pwe i pahn kaloke aramas me kin wia soahng suwed wet. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ke dehr ale kisakis ieu sang emen pwe en pwainehng uhk ke en wia mehkot me sohte pwung, pwe soangen kisakis wet kin karotongehla aramas ong ni dahme pwung oh kin kauwehla pwung en irail kan me sohte diparail. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Kumwail dehr wiakauwe mehn liki men; kumwail ese mwomwen pepehm en mehn liki kan, pwe kumwail iang wia mehn liki kei nan Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Erein sounpar weneu ke pahn koadoahki sapwomwo oh rikpene wahnsahpw koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ahpw ni keisuhwen sounpar ke sohte pahn koadoahki oh sohte pahn rik mehkot me keirda loale. Pwe me semwehmwe kan en kak tungoale wahnsahpwo oh mahn akan en kak kang dahme luhwehdi. Ke pil pahn wia duwehte ong omw mwetin wain kan oh mwetin olip kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Ke pahn doadoahk erein rahn weneu nan wihk ehu, a ni keisuhwen rahn ke pahn kommoal, pwe omw lidu kan oh mehn liki kan me kin doadoahk ong uhk oh pil noumw mahn akan en pil kak kommoal. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Rong kanahieng mehkoaros me ngehi, KAUN-O, mahsanihonguhkehr—ke dehr kapakap ong koht teikan; ke dehr pil nda adarail kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Sarawi siluh pahn kin wiawi nan sounpar koaros pwehn kawauwih ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Nan sounpwong Apip, sounpwong me kumwail mwesel sang Isip, kumwail pahn wia Sarawien Pilawa Sohte Doal Ihs nin duwen ei koasoanediongkumwailehr. Kumwail sohte pahn tungoale pilawa me doal ihs erein rahn isuh en sarawi wet. Kumwail sohte pahn kodohn wia kaudok ong ie ahpw sohte wa mehn meirong. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Sarawien Wahnsahpw pahn wiawi ni ahnsou me kumwail pahn tapihada dolung wahnsahpw. Sarawien impwal kan pahn wiawi ni ahnsoun lemwulemwmwur, ni ahnsou me kumwail pahn dolung wahn amwail mwetin wain oh wahntuhke teikan. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Nan sounpar koaros ni ahnsoun sarawi siluh lapalap pwukat, ohl koaros rehmwail pahn kin pwarodo pwehn wia kaudok ong ie, amwail Koht oh amwail Kaun. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Kumwail dehr meirongkihong ie pilawa doal ihs ni amwail pahn meirongkihong ie mahn emen. Wih en mahn me meironglahr ni ahnsoun sarawi pwukat sohte pahn nekinek lel mandahsang rahno. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Nan sounpar koaros kumwail pahn wadohng ni tehnpas en KAUN-O amwail Koht wahnsahpw me kumwail pahn tepin dolung. “Kumwail sohte pahn kukih sihmpwul men de kuht men nan pilendihdi en eh nohno. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“I pahn kadar mwohmwail tohnleng men pwe en apwahpwalih kumwail nan amwail seiloak oh en kahluwaikumwaillahng wasa I onopadahr. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Rong eh mahsen oh peikiong. Kumwail dehr kahngohdiong, pwe ngehi me kadar oh e sohte pahn mahkohng amwail kahngohdi kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ahpw ma kumwail peikiong oh kapwaiada mehkoaros me I koasoanehdi, I pahn mahweniong amwail imwintihti kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Nei tohnleng pahn tieng mwohmwail oh kahluwaikumwaillahng nan sapwen mehn Amor, mehn Id, mehn Peris, mehn Kenan, mehn Ip oh mehn Sepus, I ahpw pahn kamwomwirailla. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Kumwail dehr poaridi mwohn ar koht kan de kaudokiong irail, kumwail dehr idawehn ar tiahk kan. Kumwail kamwomwala ar koht kan oh karangkepeseng ar uhr takai sarawi kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ma kumwail kaudokiong ie, KAUN-O amwail Koht, I pahn kupwuramwahwih kin kumwail kisin tungoal oh pihl oh I pahn kadowanewei sang kumwail soangen soumwahu koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Sohte lih emen pahn depwen de iohla nan sapwamwailo. I pahn kihong kumwail mour werei. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“I pahn kupwurehda pwe irail kan me kin uhwong kumwail re en masakiehla; I pahn kapingada irail kan me kumwail pahn mahweniong oh I pahn kupwurehda pwe amwail imwintihti kan en pirekekte tangasang kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","I pahn kamasakada amwail imwintihti kan. I pahn koakoahsang mehn Ip kan, mehn Kenan kan, mehn Id kan nindokon amwail pahn mwekimwekidwei. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","I sohte pahn kalipeirailla nan erein sounpar ehu; pwe ma I wia met, sahpwo pahn tehnla oh mahn lawalo kan pahn ngederla. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ahpw I pahn wad ekis oh kalikalipeirailla, kumwail lao ngederla oh itarohng sapwenikihla sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","I pahn koasoanehdi pwe irepen sapwamwail en sang Sehden Akapa lellahng Pillap Iupreitis oh sang Sehd Mediderenien lel nan sapwtehn. I pahn kihong kumwail manaman pohn tohn sahpwo oh kumwail pahn koakoairailsang nan sahpwo ni amwail pahn mwekimwekidwei. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Kumwail dehr wiahda inou ehu ong irail de ong arail koht kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Kumwail dehr mweidohng re en mihmi nan sapwamwail; pwe re de kihong kumwail nan dihp oh lidipihkumwaildi ong pwongih ar koht kan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","KAUN-O mahsanihong Moses, “Kohdahdo nin nahnaht, kowe, Aaron, Nadad, Apihu, oh kaunen mehn Israel isiakan. Ahpw nindokon amwail pahn alialu kohdahdo, oh saikinte kerendo wasaht, kumwail pahn poaridi oh pwongih ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Kowehte me pahn kohdahdo karanih ie; meteikan sohte pahn kerendohng ie, oh aramas akan sohte pahn kohdahdo pohn nahnaht.” ");
INSERT INTO pon2006a_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moses eri patohla patohwanohng aramas ako koaros me KAUN-O mahsanih oh sapwellime kosonned akan koaros. Aramas ako eri wiahkinteieu sapeng, nda, “Se pahn kapwaiada mehkoaros me KAUN-O ketin mahsanih.” ");
INSERT INTO pon2006a_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moses eri ntingihedi sapwellimen KAUN-O mahsen kan koaros. Mandahn rahno, nimensehngie, e ahpw kauwada pei sarawi ieu nin tepin nahnao, oh kihdiong wasao takai eisek riau, mehn katamanpen kadaudok eisek riaun Israel. ");
INSERT INTO pon2006a_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ih eri kadarala mwahnakapw kei pwe re en meirongkihong KAUN-O mehn meirong isihs kei, oh pil kemehla koupwul wol kei nin duwen meirong en kaminimin. ");
INSERT INTO pon2006a_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moses eri wudekihong elep en ntahn mahno ako nan peisin kei; a elep e wudekihong pohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Mwuhr, e ahpw ale pwuhken inowo, me sapwellimen KAUN-O kosonned akan ntingdier loale oh wadekohng aramas ako; aramas ako eri sapeng, nda, “Se pahn kapwaiada mehkoaros me KAUN-O ketin mahsanih.” ");
INSERT INTO pon2006a_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moses eri ale nta sang nan peisin ko oh usupihki aramas ako, nda, “Ih ntao met me kamanalahr inou me KAUN-O ketin wiahiong kumwail ni eh ketikihong kumwail mahsen pwukat koaros.” ");
INSERT INTO pon2006a_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Eri, Moses, Aaron, Nadap, Apihu oh kaunen mehn Israel isiakano, ahpw kohdahla nin nahnao, ");
INSERT INTO pon2006a_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","re ahpw udiahl Koht en Israel. Pahn aluweluwe kan likamwete taht takai kesempwal poh mei, lingan duwehte lingan en pahn pwetenleng. ");
INSERT INTO pon2006a_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Koht sohte ketin wia mehkot suwed ong kaunen mehn Israel pwukat. Re udiahlehr Koht; mwuhr, re ahpw tungoalpene. ");
INSERT INTO pon2006a_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","KAUN-O ahpw mahsanihong Moses, “Kohdahdo rehi pohn nahnaht, oh mihmi met. I pahn kihong uhk pelien takai riapali, me I ntingihedi powe ei kosonned akan, pwe ke en padahkihong aramas akan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moses eri kaunopada, ih oh sawasepe Sosua; Moses ahpw patohdahla pohn nahna sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Moses ahpw ndaiong kaun ako, “Kumwail awiawih met, se lao pwurodo. Aaron oh Hur pahn mihmihte rehmwail; mehmen me mie mehkot me e men kapwungala, a en tuhkihong ira.” ");
INSERT INTO pon2006a_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moses eri patohdahla pohn Nahna Sainai, a iet pelien depwek pali pa kipehdi nahnao. ");
INSERT INTO pon2006a_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Lingaling en KAUN-O ahpw kohdi pohn nahnao. Ong mehn Israel ko, marain wet duwehte mpwul en kisiniei me lullul pohn nahnao. Pelien depweko kipekipehte nahnao erein rahn weneu, oh ni keisuhwen rahn, KAUN-O ahpw ketin malipe Moses sang nan pelien depweko. ");
INSERT INTO pon2006a_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moses eri patohdahla pohn nahnao nan pelien depweko. E ahpw mihmihki wasao rahn pahisek oh pwohng pahisek. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ndaiong mehn Israel kan en wia kisakis ong ie. Ke ahpw ale soangen kisakis koaros me emenemen pahn pein nsenki kihda. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Kisakis pwukat pahn mihmi ni kohl, silper oh prons; ");
INSERT INTO pon2006a_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","likou linen kaselel; wunen sihpw poh mei, ntahnmwel, oh poh weitahta; likou me wiawihkihda wunen kuht; ");
INSERT INTO pon2006a_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","kilin wunen sihpw wol me koaduh nan poh weitahta; kilin kou kaselel; tuhke akesia; ");
INSERT INTO pon2006a_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","lehn lamp akan; soangen mehn doalo lehn kei oh warpwohmwahu kan; ");
INSERT INTO pon2006a_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","karnelian oh kisin takai kesempwal teikan mehn kapwata en Samworo Lapalap ihpod oh mehn kapwata perehpen mwaremware. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Aramas akan pahn wiahda Impwal sarawi ehu ong ie, pwe I en kin koukousoan nanpwungarail. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Re pahn wiahda Impwalo oh kapwate kan pahn kin wiawihda nin duwen koasoandi me I pahn kasalehiong uhk. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Ke pahn wiahda ehu Kohpwa sang tuhke akesia, me pahn reireiki ins 45, tehlap ins 27 oh ilehki ins 27. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ke ahpw kidimkihla loale oh liki kohl tohr, kapilkipene kohl keile ko koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Wiahda rihng kohl pahieu mehn wisik oh katengediong ni neh pahieu en Kohpwao, riau apali a riau apali. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Wiahda tuhkehn wisik sang ni tuhke akesia oh kidimkihla kohl, ");
INSERT INTO pon2006a_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ke ahpw kadil tuhke ko nan rihng ko ni keile riau en Kohpwao. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Tuhke ko pahn kin mihmihte nan rihng ko oh sohte pahn kin kohsang. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ke pahn kihdiong nan Kohpwao pelien takai riapali me I pahn kihwei, me kosonned kan ntinting powe. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Ke pahn wiahda pweine me kohl tohr wia, me pahn reireiki ins 45 oh tehlapki ins 27. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Pil wiahda kerup riemen me perperda sang kohl, ");
INSERT INTO pon2006a_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","emen pahn mi ni apali pweinen Kohpwao a emen apali. Kerup ko pahn wiawihda patehngete pweinen Kohpwao. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ira pahn sohpeipene pohn pweinen Kohpwao oh kapapeseng pehra ko powe oh koaduhpwaldi. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Kihdiong nan Kohpwao pelien takai riapalio oh pwainkihdi pweineo. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","I pahn tuhwong uhk wasao, oh pohn pweinen Kohpwao nanpwungen kerup riemeno I pahn kihong uhk kosonned koaros ong mehn Israel. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Ke pahn pil wiahda ehu tehpel sang tuhke akesia, me pahn reireiki ins 36, tehlapki ins 18 oh ilehki ins 27. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Kohl tohr me pahn kidim oh kapilkipene kohl ni keile ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Wiahda mehn kolpene me tehlepe mihmi ni ins 3 oh kohl me pahn kidim mehn kolpeneo. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Wiahda rihng kohl pahieu oh katengediong ehuehu ni keimw pahieu en nehn tehpelo. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Rihng ko me pahn kol tuhkehn wa tehpelo, pahn mi limwahn keilen tehpelo. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Tuhke akesia me pahn wia tuhkehn wa tehpelo oh pahn kidikidki kohl. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Pil wiahda pileit, kep, sah, oh ekei pwohl mehn doadoahk ong ni meirong en wain. Mepwukat koaros pahn wiawihkihda kohl tohr. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Tehpel wet pahn koasoansoandiong mwohn Kohpwahn Inowo, oh ahnsou koaros pilawa sarawi mehn meirong ong ie pahn kin mi pohn tepel wet. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Wiahda ehu dewen lamp me kohl tohr wia. Wiahkihda kapi oh inonde kohl me sukusukda. Wahntuhke kan me pahn kapwata, me iangahki wahntuhke mpwek oh teh, pahn patehngete dewen lampo. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Rah weneu pahn uhsang ni keile, siluh sang ni apali, a siluh apali. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ni ehuehu rah weneu ko pahn kapwatki wahnrohs siluh me mwomwen masal en almond iangahki mpweke oh teh kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Inonden dewen lampo pahn kapwatki wahnrohs pahieu me mwomwen masal en almond iangahki mpweke oh teh kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","E pahn mie ehu wahnrohs mpwek pahn ehuehu rah siluh ko koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Mpwek kan, rah kan oh dewen lampo pahn sukusukda ehute sang ni kohl tohr. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Lamp isuh pahn wiawihda ong ni dewen lamp wet oh koasoansoandi pwe re en kin kamarainih mwowe. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Wiahkihda kohl tohr tihpw kan oh opwong kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Doadoahngki paun 75 en kohl tohr mehn wiahda dewen lamp oh dipwisawi kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ke pahn kanahieng wiepen mepwukat nin duwen koasoandi me I kasalehiong uhk pohn nahnao. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Ke pahn wiahda loalen Impwal sarawio, iei Impwal me I pahn kin ketiket loale, ke pahn wiahkihda lepin likou linen kaselel eisek me pahn wiawihkihda wunen sihpw poh mei, ntahnmwel, oh weitahta. Mwomwen kerup kei pahn deiadidi powe. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Lepin likou koaros pahn soangen wehteieu, me pahn iaht 14 reirei oh iaht 2 tehlap. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Lepin likou limau pahn deideipene wiahla ehu, pil duwehte lepin likou limau teiko. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Wiahda kisin sahl likou me mwomwen pwakel poh mei ni keilen ehuehu kahdeng riauo. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Kihong pwakel limeisek pwukat ni pelien likou keieu en kahdeng keieu oh pil pwakel limeisek ong ni pelien likou kelimau en kahdeng keriauo, pwakel pwukat pahn pelialipene. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ke ahpw pil wiahda kisin metehn kateng kohl limeisek me pahn kolpene kahdeng riau pwukat pwehn wiahla ehu. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Ke pahn pwainkihdi Impwalo lepin likou eisek ehu me wiawihkihda wunen kuht. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Koaros pahn soangen wehteieu, iaht 15 reirei oh iaht 2 tehlap. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ke pahn dehkpene lepin likou limau wiahla ehu, oh lepin likou weneu teiko pwehn pil wiahla ehu. Welikpene keweneu en lepin likowo oh kihdiong mwohn Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Kihong pwakel limeisek ni keilen pweine keieuo oh pil pwakel limeisek ni keilen pweine teio. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Pil wiahda metehn kateng prons limeisek oh kihong ni kisin sahl ko pwehn kolpene pweine riauo pwehn wiahla mehn pweipwei ehu. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Langahda apali luhwen pweineo, pwehn mwotomwotou ni pengepengen Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Luhwen elep en iaht en pweine ko pahn langada ni pengepengen Impwalo, pwehn wia perehpe. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Pil wiahda mehn pweipwei riau, ehu pahn wiawihsang ni wunen sihpw wol me koaduh poh weitahta, a ehu sang ni kilin kou kaselel, met kan pahn wia pweinen maslikin Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Ke pahn wiahda uhr kan en Impwalo sang ni tuhke Akesia. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Apwoat uhr pahn reireiki piht 15 oh ins 27 tehlap, ");
INSERT INTO pon2006a_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","oh ni tepin uhr ko kihdiong kisin tuhke me pahn sikeisang mehn kolpene uhr ko. Kisin tuhke pwukat pahn mi ni uhr koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ke pahn wiahda uhr riehk ni palieir en Impwalo, ");
INSERT INTO pon2006a_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","oh wiahda poahsoan silper pahisek me pahn mi pahn uhr ko; poahsoan riau pahn apwoat uhr oh mie kisin tuhke me pahn sikeisang pwehn kolpene uhr ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Wiahda uhr riehk mehn mi ni paliepeng en Impwalo, ");
INSERT INTO pon2006a_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","oh poahsoan silper pahisek, poahsoan riau pahn mi pahn apwoat uhr. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Wiahda uhr wenepwoat ong ni palikapi en Impwalo, ");
INSERT INTO pon2006a_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","oh uhr riapwoat ong ni keimw kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Uhr en nan keimw pwukat pahn patpene kohda lel powe. Iei met duwen koasoandien uhr en nan keimw riauo. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Eri, uhr welipwoat pahn uhda pohn poahsoan silper eisek weneu, poahsoan silper riau pahn apwoat uhr. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Ke pahn wiahda tuhkehn ndape ehk sillep oh tuhkehn doakoloal rielep sang tuhke Akesia, limlep ong ni uhr akan en apali Impwalo, ");
INSERT INTO pon2006a_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","a limlep ong apali, oh limlep ong uhr en palikapi. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Doakoloal en nanwerenge, pahn mi nan lukopen uhr kan oh pahn uhsang elep Impwalo lel elep. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ke pahn kidimki uhr kan kohl oh kihong ekei rihng kohl me ndape oh doakoloal kan pahn kedil loale, ndape oh doakoloal kan pahn pil kidikidki kohl. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ke pahn kauwada Impwalo nin duwen koasoandi me I kasalehionguhkehr pohn nahnao. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Wiahda ehu kahdeng sang likou linen kaselel me wiawihkihda wunen sihpw me poh mei, weitahta, oh ntahnmwel. Mwomwen kerup kei pahn deiadidi powe. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ke pahn langadahng ni lepin uhr pahieu en tuhke Akesia me kidikidki kohl oh katengehkihdi metehn kateng, kihong pahn lepin uhr kan poahsoan silper pahieu. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Langahda kahdengo ni metehn kateng kan me irek pahn pwelengen Impwalo, oh koasoanehdi Kohpwahn Inowo me pelien takai riapalio mi loale masloalen kahdengo. Kahdengo pahn irepeseng Wasa Sarawio sang Wasa Sarawiheo. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ke ahpw kihdiong pohn Kopwahn Inowo pweineo. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Koasoanehdi tehpelo ni paliepeng en Impwalo likin Wasa Sarawiheo, oh dewen lampo ni palieir. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Ke pahn wiahkihda ehu kahdeng likou linen kaselel me wiawihda sang wunen sihpw poh mei, ntahnmel, oh weitahta, me deiad lingan, mehn mi ni wenihmwen Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Wiahda lepin uhr limpwoat sang tuhke Akesia me pahn kidikidki kohl me kahdeng wet pahn langadahng ie, iangahki ekei metehn kateng kohl; pil wiahda poahsoan prons limau mehn mi pahn lepin uhr pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Ke pahn wiahda ehu pei sarawi sang tuhke akesia. E pahn keimw pahieu, piht isuh elep reirei oh isuh elep tehlap, oh piht pahieu elep ile. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ni keimw pahieu kode pahieu pahn mi ie me pahn uhsangete ni pei sarawio, oh wasa koaros pahn kidikidki prons. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Wiahda ekei pan me pehs me kirihsla kan en kohieng loale, pil wiahda ekei sapwel, pwohl, tihpw, oh pan me kisiniei pahn kin mi loale. Dipwisou pwukat pahn wiawihda sang ni prons. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Wiahkihda prons ehu pasapas mehn inihn, oh ni keimw pahieu en mehn inihn wet ke pahn kihong rihng pahieu mehn wisik. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ke ahpw kihdiong mehn inihn wet pahn keilen pei sarawio. Ileile en mehn inihn wet pahn lelete nan lukopen pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ke pahn pil wiahda ekei tuhkehn wisik sang tuhke akesia mehn wa pei sarawio, oh kidimkihla prons, ");
INSERT INTO pon2006a_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","oh kadilong nan rihng ko, me mi ni pali riau en pei sarawio, mehn rowe pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ke pahn pil wiahkihda pei sarawio dinapw ni mwomwen kohpwa, nin duwen me I kasalehiong uhk pohn nahnao. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Ke pahn kelehkipene Impwal me I pahn kin ketiket loale ekei kahdeng me wiawihkihda likou linen kaselel. Kahdeng ko me pahn mi ni palieir en Impwalo pahn reireiki iaht 50. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Kahdeng ko pahn langada ni lepin uhr prons riehk oh lepin uhr ko pahn uhda pohn poahsoan prons rieisek, iangahki metehn kateng oh mete ahtikitik me pahn kedil nan kahdeng ko pahn wiawihkihda silper. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ke pahn pil wiahda soahngohte ni paliepeng en kehlo. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ni palikapi pahn pil mie ekei kahdeng me pahn reireiki iaht 25, oh lepin uhr ehk oh poahsoan eisek. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ni palimese, wasa me wenihmw pahn mi ie, kehlo pahn pil tehlapki iaht 25. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Ni pali riau en wenihmwo, kahdeng kan me pahn mi ie pahn reireiki iaht isuh elep, iangahki lepin uhr silipwoat oh poahsoan siluh. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ong ni wenihmwo kahdeng ehu pahn mi ie me pahn reireiki iaht 10, me pahn wiawihda sang ni likou linen kaselel me wiawihda sang ni wunen sihpw, me poh mei, ntahnmwel oh weitahta, me pahn deiad lingan. Kahdengo pahn langada ni lepin uhr pahpwoat me uhda pohn poahsoan pahieu. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Mete silper ahtikitik pahn kadokepene lepin uhr koaros me kapil kehlo, oh silper me pahn wia metehn kateng kan, oh prons me pahn wia poahsoane kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Kehlo pahn iaht 50 reirei, tehlap iaht 25 oh iaht riau elep ile. Kahdeng kan pahn wiawihda sang likou linen kaselel oh poahsoan kan pahn wiawihda sang prons. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Dipwisoun doadoahk koaros me pahn doadoahk nan Impwalo oh metehn kateng koaros en Impwalo oh kehlo pahn wiawihda sang prons. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Koasoanediong mehn Israel kan pwe re en wadohng uhk leh kaselel en olip, pwe lampo en kin kak isihsda soutik koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaron oh nah pwutak ko pahn kin kaunopada lampo likin kahdengo me mi mwohn Kohpwahn Inowo nan Impwal me I pahn kin ketiket loale. Eri, lampo pahn kin ngkengken mwohn silangi sang nin soutik lel nimenseng. Koasoandi wet pahn kin wiawi rehn mehn Israel kan oh kadaudokarail kan kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ekerodo riomw Aaron oh nah pwutak ko, Nadap, Apihu, Eleasar oh Idamar. Katohreirailsang rehn mehn Israel kan pwe re en kin papah ie nin duwen samworo kei. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Wiahiong riomw Aaron likou kaselel en samworo me pahn kawauwihala oh kalinganahla. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ekerpene aramas koahiek koaros me I kakoahiekihalahr, ke ahpw ndaiong irail re en wiahda en Aaron eh likou kan, pwe en kasarawihong ie nin duwen samworo, oh en wia doadoahk en samworo. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ndaiong irail en wiahda ehu perehpen mwaremware, ehu likou ihpod, likou puhp reirei, seht deiad, lisoarop oh katengen lukope. Re en wiahiong likou pwukat Aaron oh nah pwutak ko pwe re en kin papah ie nin duwen samworo kei. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Aramas koahiek pwukat pahn doadoahngki likou me wiawihda sang ni wunen sihpw me poh mei, ntahnmwel, oh weitahta, iangahki dereht kohl, oh likou linen kaselel. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Re pahn wiahkihda likou ihpodo wunen sihpw poh mei, ntahnmwel oh weitahta, dereht kohl oh likou linen kaselel me deiad lingan. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kisin likou riau pahn mie pohn imwin pwopwe mehn katengepene imwin powe riau. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Kateng ehu me pahn wiawihda sangete ni soangen likou ko pahn wiawihda patehngete ihpodo. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ale takai karnelian riau oh parada powe eden nein Seikop pwutak ehk riemeno, ");
INSERT INTO pon2006a_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","nin duwen irekidien ar ipwidi, ahd weneu ni ehu takai oh weneu ni ehu. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Emen samanen nting en wiahda pohn takai ko eden nein Seikop pwutak ehk riemeno oh kapwatahki ni mwomwen kisin kohl kei. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ke ahpw kihong takai riau wet pohn likou me katengepene pohn pwopwen likou ihpodo pwe en wia mehn kataman en kadaudok eisek riaun Israel. Ih duwen met Aaron eh pahn kin wa adarail kan pohn pwopwe, pwe ngehi, KAUN-O, I en kin tamataman nei aramas akan ahnsou koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ke pahn pil wiahda dewen kohl riau, ");
INSERT INTO pon2006a_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","oh sahl sihn riapwoat en kohl tohr, me ingkolpene wiahla sahl pwoat pahn uhsang ni dewen kohl ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Ke pahn wiahda perehpen mwaremware me Samworo Lapalap pahn doadoahngki ni eh pahn kin rapahki kupwur en Koht. E pahn wiawihkihda soangen dipwisou kesempwal me ihpodo wiawihda sang ie oh pil soangen deiadohte. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","E pahn keimw pahieu oh masriapar, ins 9 reirei oh ins 9 tehlap. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ke pahn kapwatahkihda kairek pahieu en kisin takai kesempwal kei; ni kairek keieuo kihdiong rupi, topas, oh karnet; ");
INSERT INTO pon2006a_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ni kairek keriauo, kihdiong emarald, sapair, oh daimon; ");
INSERT INTO pon2006a_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ni kesiluhwen kairek, turkuois, akat, oh amedist; ");
INSERT INTO pon2006a_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ni kapahieu, peril, karnelian, oh sasper. Kisin takai kesempwal pwukat pahn koasoandi ni mwomwen kohl. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ni ehuehu kisin takai eisek riau pwukat e pahn ntinting ie eden emenemen nein Seikop pwutak ko, mehn kasalehda kadaudok en Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ong ni perehpen mwaremwareo wiahda sahl sihn me kohl tohr oh ingkolpene. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Wiahda rihng riau en kohl, oh kihong ni keimw en perehpen mwaremware powe ");
INSERT INTO pon2006a_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","oh pirehiong sahl kohl riapwoato ni rihng riauo. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Pirehiong imwi riau teiko ni perehpen mwaremwareo, iei duwen eh pahn katengehdi mwohn pirapiren ihpodo. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ke ahpw pahn wiahda rihng riau en kohl oh koasoanediong ni keimw en pahn perehpen mwaremwareo maslikin ihpodo. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Pil wiahda rihng kohl riau oh kihdiong ni pali peh riau en ihpodo, limwahn katengen ihpodo. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Katengehkipene sahl poh mei rihng en perehpen mwaremware oh rihng en ihpodo, pwe perehpen mwaremware en soandi mwahu pohn katengepeo oh en dehr mwer. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Ni ahnsou me Aaron kin pedolong nan Wasa Sarawio, e pahn mi nan perehpen mwaremware me mwaren kadaudok en Israel ko ntinting powe, pwe ngehi, KAUN-O, en kin tamankihda nei aramas akan ahnsou koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Kihdiong pahn perehpen mwaremware Urim oh Dumim. pwe Aaron en kin wa ni ahnsou me eh pahn kin patohlong nan Wasa Sarawio mwohn silangi. E pahn kin wa perehpen mwaremware wet ahnsou koaros, pwe en kin rapahkihong mehn Israel kan audepen kupwurei. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Likou reirei me kin mi pohn ihpodo pahn wiawihkihda wunen sihpw poh mei. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","E pahn pwoar ni moange nanwerenge, oh pwoahro pahn pwungidi pwehn kehlail, dehr teipeseng. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Ni pwungipen imwin pah ke pahn kihdiong ekei wahn pwohmakraneid me wiawihda sang ni wunen sihpw me poh mei, ntahnmwel, oh weitahta, me pahn kapilpene kisin pehl kei me wiawihkihda kohl. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaron pahn kin likawih likou reirei wet ni eh pahn kin wia doadoahk en samworo. Ni eh pahn kin pwarodo mwohn silangi nan Wasa Sarawio, de ni eh pahn kin pedoisang wasao, ngilen kisin pehl ko pahn sekesek pwe en dehr kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Ke pahn wiahda ehu mehn kapwat sang kohl tohr, oh ntingihediong powe mahsen pwoatet ‘Kasarawihong KAUN-O.’ ");
INSERT INTO pon2006a_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Sahl poh mei me pahn pirehiong kapwat wet ni temwen lisoaropo. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aaron pahn mi nan lisoarop wet, nin duwen kilel ehu me ngehi, KAUN-O, pahn kupwurperenki meirong koaros me mehn Israel kan pahn meirongkihong ie, mehnda ma re kin sapwungala nan ar meirong kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“En Aaron seht pahn pil deideida sang ni likou linen kaselel oh lisoarop pahn pil wiawihkihda linen kaselel oh eh kateng pahn kapwatki deiad lingan. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Pil wiahda ekei seht, ekei kateng oh ekei kisin lisoarop ong nein Aaron pwutak ko, pwehn kawauwihirailla oh kalinganairailla. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Kalikawihkihda riomw Aaron oh nah pwutak kan likou pwukat. Kowe eri keiehkiniraildi lehn olip oh kasapwilirailda, pwe re en wiahla nei samworo. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Pil wiahiong irail saramada linen me pahn sang ni lukeparail lel ni tepin dengerail kan, pwe re en dehr kin sansal suwed. ");
INSERT INTO pon2006a_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron oh nah pwutak kan pahn kin likawih saramada pwukat ahnsou koaros me re pahn kin pedolong nan Impwal me I pahn kin ketiket loale de ni ar pahn kin keidohng papah nin duwen samworo kei nan Wasa Sarawio, pwe re en dehr kamakamkihla ar pahn sansal suwedla. Koasoandi poatopoat ehu met ong Aaron oh kadaudoke kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Iet me ke pahn wiahiong Aaron oh nah pwutak ko pwe ke en kasarawihong irail ni doadoahk en samworo oh papah ie. Ale emen koupwul wol oh sihpw wol riemen me sohte kisin samin kis rehra. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Ale pilawa amas me keieu kaselel, sohte doal ihs, ke ahpw wiahda ekei pilawa me doal lehn olip, a ekei sohte doal leh, ekei pahn mwomwen keik menipinip oh irisiki leh. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Kihong nan ehu kopwou oh meirongkihong ie ni omw pahn meirongki koupwul wolo oh sihpw wol riemeno. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Kahrehdo Aaron oh nah pwutak ko ni wenihmwen Impwal me I kin ketiket loale, pwe re en duhdu nin duwen tiahk en kamwakel. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Kalikawihkihda Aaron likoun samworo kan—seht, likou ihpod, likou puhp me kin mi pohn likou ihpodo, perehpen mwaremware oh kateng. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Kidahng pohn moange lisoarop en samworo oh katengehdiong powe kilel en kasarawi me ntinting ‘Kasarawihong KAUN-O.’ ");
INSERT INTO pon2006a_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ke ahpw ale lehn kei oh kieldiong pohn moange oh keiehki. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Kahrehdo nah pwutak ko oh kalikawihkinirailda seht kan; ");
INSERT INTO pon2006a_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","oh pirekipene lukeparail kan kateng oh kihong irail lisoarop. Ih duwen met omw pahn kasapwilada Aaron oh nah pwutak ko. Irail oh kadaudokarail kan pahn kin papah ie nin duwen samworo kei kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Ke pahn kahrehdo koupwul wolo mwohn Impwal me I kin ketiket loale oh ndahng Aaron oh nah pwutak ko en kidahng pehrail kan pohn moangen kouo. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ke ahpw kemehla kouwolo wasao mwohn silangi ni wenihmwen Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ke ahpw koaduh sendinpehmw nan ntaho oh iriski imwin pei sarawio. Mwuhr ke ahpw wudekihdiong luhwen ntaho nan tepin pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Mwuhr ke ahpw ale kirihs koaros en kepwehn loale kan, wasa mwahu en eho oh mwidihlik riau iangahki kirihs ko, ke ahpw isikala pohn pei sarawio nin duwen meirong ong ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","A uduken kouwolo, kilio oh kepwe teikan koaros en nan kapehde ke pahn isikala likin kahnimpwalo. Met iei meirong en tomwki dipen samworo kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Ale emen sihpw wol ko oh ndahng Aaron oh nah pwutak ko en kidahng pehrail ko pohn moangen sihpwo. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Kemehla oh ale ntaho oh usupihki keimw pahieu en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Sarpisetikihpene sihpwo; kamwakelehda kepwehn loale kan oh kumwutih kan oh kidahng pohn moangen mahno oh wasa teiko. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Isikala sihpwo pwon pohn pei sarawio nin duwen meirong en konot, pwohmwahu en meirong wet kin kaparanda kupwurei. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Ale sihpw wol teio—sihpw wol mehn wia doadoahk en kasarawio—oh ndaiong Aaron oh nah pwutak ko re en kidahng pehrail kan pohn moangen sihpwo. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Kemehla oh ale ekis ntaho oh iriski palimaun en imwin salengen Aaron oh nah pwutak ko oh palimaun en sendinpehlaparail ko oh palimaun en sendinnehlaparail ko. Ke ahpw usupihki luhwen ntaho keimw pahieu en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ale ekis ntaho me mi pohn pei sarawio oh ekis lehn kei oh usupihki Aaron, eh likou kan oh nah pwutak kan oh ar likou kan. Eri ih oh nah pwutak kan oh ar likou kan pahn kasarawihong ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Serehsang kirihs en sihpw wolo, kirihs en pwadaikio, kirihs en kepwehn loale kan, wasa mwahu en eho, mwidihlik riau iangahki kirihsih kan, oh denge palimaun. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Kihsang nan kopwou me meirongalahr ong ie, lopwon en pilawa ieu: lopwon en pilawa doal leh oh ehu me sohte doal leh, oh ehu keik menipinip. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Kihong kisin soangen mwenge pwukat nan pehn Aaron oh nah pwutak ko pwe re en kasarawihong ie nin duwen kisakis tohrohr ehu. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Eri, ke ahpw alehsang irail oh isikala pohn pei sarawio, pohn meirong me isihslahr ako nin duwen meirong en konot ong ie. Pwohmwahu en meirong wet me I kin kupwurperenki. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Ale mwaremwaren sihpw menet oh kasarawihong ie nin duwen kisakis tohrohr ehu. Eri met pahn wiahla omw kepinkonot. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Ni ahnsou me samworo men pahn kasarawihla, mwaremware oh dengen sihpw me doadoahk ni kasarawio pahn kasarawihong ie nin duwen kisakis tohrohr ehu oh pahn katohrohrla pwehn wia pwaisen samworo kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Met iei ei koasoandi poatopoat me ni ahnsou me nei aramas akan pahn kin wia arail meirong en kaminimin, samworo kan en kin kepinkonotki mwaremware oh dengen mahn akan. Pwe iei met en aramas akan ar kisakis ong ie, KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“En Aaron eh likoun samworo kan pahn kin kohieng nah pwutak ko mwurin eh pahn sipalla, pwe re en likawih ahnsou me re pahn uhd kasarawihala ong samworo. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Nein Aaron pwutak emen me pahn wiliandi ih wiahla samworo oh pahn kin pedolong nan Impwal sarawio mwohn silangi, pahn likawih likou pwukat erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Ke pahn ale uduk en sihpw wol me doadoahkehr ong ni kesepwildahn Aaron oh nah pwutak ko oh pwoailihada wasa sarawi ehu. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ni wenihmwen Impwalo mwohn silangi, re pahn kang iangahki pilawa me luhwehdi nan kopwowo. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Re pahn tungoale dahme doadoahkohng ni sarawien tomwen dihp ni ahnsou me re kesepwilda. Samworo kante me pahn kin tungoale mepwukat pwe soahng sarawi kei met. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ma mie luhwen uduk de pilawa me kasarawiher mandahn rahno nimenseng, e pahn isihsla; sohte me pahn kang, pwe mehkot me sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Erein rahn isuh ke pahn wiewia sarawien kesepwildahn Aaron oh nah pwutak kan nin duwen me I koasoanedier. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Rahn koaros ke pahn kin meirongkihla koupwul wol men, pwehn wia tomwen dihp. Met pahn kamwakelehda pei sarawio. Mwuhr ke pahn keiehki pei sarawio lehn olip, pwehn sarawihla. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Wia met erein rahn isuh. Pei sarawio eri pahn sarawihla douluhl oh mehmen de mehkot me pahn sair pahn ohkihla manaman en sarawi wet. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Iet me ke pahn meirongkihla rahn koaros pohn pei sarawio kohkohlahte: sihmpwul riemen me sounpar ehu. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Meirongkihla emen nimenseng a emen nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Iangahki keieun sihpwo paun riau en pilawa kaselel me doal lehn olip, ekis wain mehn meirong. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Meirongkihla keriaun sihpwo nin soutik, iangahki soangen uwen pilawa, lehn olip oh wain me wiawi nimensengo. Ih met meirong en konot ong ie, KAUN-O, oh pwohmwahu en meirong wet kin kaparanda kupwurei. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Sang met kohkohlahte meirong isihs wet pahn kin wiawi mwohn silangi mwohn wenihmwen Impwal me I pahn kin ketiket loale, wasa I pahn kin tuhwong ie nei aramas akan, oh mahseniong uhk. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Wasakiset, ih wasa me I pahn kin tuhwong mehn Israel kan, ihme lingaling en mwarei pahn kasarawihala wasaht. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","I pahn kasarawihala Impwalo oh pei sarawio, oh I pahn katohrehla Aaron oh nah pwutak ko pwe re en papah ie nin duwen samworo. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","I pahn kin mihmi nanpwungen mehn Israel kan oh wiewia arail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Re pahn esehla me ngehi KAUN-O, iei arail Koht me kahreiraildo sang Isip pwe I en kin kousoan nanpwungarail. Ngehi KAUN-O, arail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Ke pahn wiahda ehu pei sarawi sang tuhke akesia, wasa warpwohmwahu pahn kin isihsla ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","E pahn keimw pahieu oh reirei ins 18, oh ilehki ins 36. Koden imwi kan ni keimw pahieu pahn uhsangete pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Kidimki kohl tohr powe, ni keimw pahieu koaros oh iangahki kode ko. Kapilkipene ni keile kohl tohr. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Wiahda rihng riau mehn wisik oh kihdiong pahn keile ko pali riau mehn kolada tuhke riapwoat mehn wa pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Wiahkihda tuhkehn wisik pwukat tuhke akesia oh kidimki kohl. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Koasoanehdi pei sarawi wet likin kahdeng me mwotoudi mwohn Kohpwahn Inowo. Ih wasao me I pahn tuhwong uhk ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Nimenseng koaros, ni ahnsou me Aaron pahn kin kaunopada lamp kan, e pahn kin isikada warpwohmwahu pohn pei sarawi wet. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","E pil pahn wia soahngohte nin soutik kan ni eh pahn kin isikada lamp kan. Koasoandi en isik warpwohmwahu wet pahn kin wiawi erein dih koaros kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ke dehr wia meirong en warpwohmwahu me keinepwi pohn pei sarawi wet, de meirong en mahn, de wahnsahpw, de kieldiong powe meirong en wain. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Pak ehu nan sounpar koaros Aaron pahn wia kasarawien kamwakele pei sarawi wet ni eh pahn kin usupihki keimw pahieuo ntahn mahn me meirongalahr. Met pahn kin wiawi nan sounpar koaros kohkohlahte. Pei sarawi wet uhdahn pahn wia pei sarawi ehu me kasarawihong ie, KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Ni omw pahn wiahda wadawad en mehn Israel kan, emenemen aramas pahn kihong ie pweinen eh mour, pwe paisuwed en dehr lelohng nindokon wadawad en aramas eh wiewiawi. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Koaros me iangehr wadawadedi pahn kihda uwen paun en mwohni me koasoansoandier en kihda. Koaros pahn kihda uwen mwohni wet nin duwen meirong ehu ong ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Koaros me iangehr wadawadedi, wehwehki ohl koaros me mahkier sounpar rieisek kohda, pahn kihong ie uwen mwohni wet. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Me kepwehpwe kan sohte pahn kihda mwohni laudsang me kileldi oh me semwehmwe kan sohte pahn kihda tikitiksang, ni ar pahn kin kihda mwohni wet ong pweinen ar mour. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Rikpene soangen mwohni wet sang rehn mehn Israel kan oh doadoahngkihong ni kamwahupen Impwal me I pahn kin ketiket loale. Daksis wet pahn wia pweinen ar mour, oh eh pahn katamankin ie I en apwahpwalih irail.” ");
INSERT INTO pon2006a_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Wiahda ehu peisin me prons wia kapi. Ke ahpw koasoanediong nanpwungen Impwalo oh pei sarawio, oh audehkihda pihl. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaron oh nah pwutak ko pahn kin doadoahngki pihl wet pwe re en omwiomwki oh widenki nehrail kan ");
INSERT INTO pon2006a_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","mwohn ar pahn pedolong nan Impwalo de keiong ni pei sarawio pwe re en kin wia meirong en konot, ih duwen met ar sohte pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Re uhdahn pahn kin omwiomw oh widen nehrail kan pwe re dehr mehla. Koasoandi wet pahn poatopoat ong irail oh kadaudokarail kan kohkohlahte.” ");
INSERT INTO pon2006a_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ale soangen mehn doaloahda warpwohmwahu kaselel koaros— paun 12 pilen mir, paun 6 en sinamon pwohmwahu, paun 6 en reh pwohmwahu, ");
INSERT INTO pon2006a_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","oh paun 12 en kasia (koaros nin duwen paun me koasoandier). Kapatahiong kalon ehu en lehn olip, ");
INSERT INTO pon2006a_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","oh doaloapene wiahkihda lehn kei sarawi, duwehte lehn wai pwohmwahu. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Doadoahngki pwehn wia lehn keie Impwalo, Kohpwahn Inowo, ");
INSERT INTO pon2006a_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","tehpelo oh dipwisawi koaros, dewen lampo oh dipwisawi kan, pei sarawien isik warpwohmwahwo, ");
INSERT INTO pon2006a_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","pei sarawien meirong isihso, iangahki dipwisawi koaros oh peisin en omwiomw oh widene iangahki kapio. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Iei duwen mepwukat ar pahn kasarawihla, eri dipwisou pwukat uhdahn pahn sarawihla, oh mehmen de mehkot me pahn sair, pahn ohkihla manaman en sarawi wet. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Mwuri keiehdi Aaron oh nah pwutak ko, oh kasarawihirailla ong ni doadoahk en nei samworo. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ndahng aramas en Israel kan, ‘Lehn kei sarawi wet pahn kin doadoahk ong ie kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","E sohte pahn doadoahk ong aramas mwahl akan, oh kumwail sohte pahn alasang wiepen doalepe pwehn wiahda ehu lehn kei mwahl. Pwe met me sarawi, ke uhdahn pahn wiahki mehkot sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Mehmen me pahn wiahda leh ieu me duwehte met de doadoahngki ong emen me kaidehk samworo, e sohla pahn wia kisehn nei aramas akan.’” ");
INSERT INTO pon2006a_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","KAUN-O ketin mahsanihong Moses, “Ale soangen uwehte ieu sang ni dipwisou pwohmwahu pwukat—stakte, onika, kalpanum oh warpwohmwahu tohr. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Doaloapene pwehn wiahda warpwohmwahu, duwehte lehn wai. Kihong soahl pwe en mwakelekel oh sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Sukpene apali lao wiahla pehs oh wahla nan Impwalo oh kamwerehdi mwohn Kohpwahn Inowo. Wiahki warpwohmwahu wet mehkot me uhdahn sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Kumwail dehr alasang doalepen warpwohmwahu wet pwe kumwail en wiahkihda pein amwail warpwohmwahu. Wiahki met mehkot me sarawi me kasarawihong ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Mehmen me wiahda warpwohmwahu duwehte met ong pein eh doadoahk, e sohla pahn wia kisehn nei aramas akan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“I piladahr Pesalel, nein Uri nein Hur, sang ni kadaudok en Suda, ");
INSERT INTO pon2006a_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","oh I audehkidahr ei manaman en dehdehki, saman oh koahiek ong soangen doadoahk koaros en kalingan— ");
INSERT INTO pon2006a_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ong ni pilahnihada soangen mwahi koaros, oh ong wiepen soahng kan ni kohl, silper oh prons; ");
INSERT INTO pon2006a_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","doadoahk en parada takai kesempwal akan, iangahki tuhke; oh soangen doadoahk lingan teikan. ");
INSERT INTO pon2006a_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","I pil piladahr Oliap, nein Aisamak, sang ni kadaudok en Dan pwe en iang Pesalel doadoahk. I pil audehkidahr koahiek laud tohndoadoahk saman teikan, pwe re en kak wia soahng koaros me I koasoanedier en kin wiawi: ");
INSERT INTO pon2006a_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Impwal me I pahn kin ketiket loale, Kohpwahn Inowo oh pweine, mehn kalingan koaros en Impwalo, ");
INSERT INTO pon2006a_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","tehpel oh dipwisawi kan, dewen lamp kohl tohr oh dipwisawi koaros, pei sarawien isik warpwohmwahu, ");
INSERT INTO pon2006a_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","pei sarawien meirong isihs oh dipwisawi koaros, peisin en omwiomw iangahki kapi, ");
INSERT INTO pon2006a_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","likou lingan en samworo kan me Aaron oh nah pwutak ko pahn kin likawih ahnsoun ar pahn wia doadoahk en samworo, ");
INSERT INTO pon2006a_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","lehn keio oh warpwohmwahu ong Wasa Sarawio. Wiepen mepwukat koaros pahn wiawihda nin duwen me I koasoanedionguhkehr.” ");
INSERT INTO pon2006a_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","KAUN-O ahpw mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","en padahkihong mehn Israel kan, “Kumwail pahn kin wauneki rahnen Sapad, ei rahnen kommoal, pwe iei mehn kataman ehu nanpwungen ngehi oh kumwail oh pil kadaudokamwail kan, pwe kumwail en esehla me ngehi, KAUN-O, me wiahkinkumwaillahr nei aramas kesempwal. ");
INSERT INTO pon2006a_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Iei me kumwail pahn kin wauneki rahno, pwehki eh wialahr rahn sarawi rehmwail. Mehmen me sohte pahn wauneki rahno, pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Kumwail pahn kin doadoahk erein rahn weneu, a keisuhwen rahn, iei rahnen kommoal unsek me kasarawihla ong ie. Mehmen me pahn doadoahk rahno, pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Mehn Israel kan pahn kin wauneki rahnen kommoal wet nin duwen kilel en inowo. ");
INSERT INTO pon2006a_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","E pahn wiahla kilel poatopoat ehu nanpwungen ngehi oh aramas en Israel kan, pwehki ngehi, KAUN-O, me wiahda nanleng oh sampah erein rahn weneu, oh ni keisuhwen rahn I ahpw tokedi sang ei doadoahk oh kommoaldi.” ");
INSERT INTO pon2006a_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Mwurin Koht eh ketin kaimwisekala sapwellime mahsen ong Moses pohn Nahna Sainai, e ketikihong pelien takai riapalio, me pein ih ketin ntingihedier powe kosonned akan. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ni aramas ako ar tehkada duwen Moses eh pwand en pwuredi sang pohn nahnao, re ahpw keiong mpen Aaron oh ndaiong, “Nna, komw wiahiong kiht emen kohten me pahn kahluwei kiht, pwe se sehselahr dahme wiawihong ohl menet Moses, me kahreikitodo sang Isip.” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron eri sapeng irail, nda, “Me mwahu! Kumwail kihsang en amwail pwoud kan, en noumwail pwutak kan oh serepein kan, tiarail kohl, oh wadohng ie.” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Aramas ako koaros eri kihpene tiarail kohl kan oh wapene rehn Aaron. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ih eri ale oh inimada lao peipeseng, e ahpw wudekihong nan deupe ieu, oh wiahkihda mwomwen kouwol men. Aramas ako ahpw werkihda, nda, “Israel, iet atail koht me kahluweikitodo sang Isip.” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaron eri kauwada pei sarawi ieu mwohn mwomwen kouwolo. E ahpw nda, “Lakapw kitail pahn wia sarawi pwe en wauneki KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Nimenseng en mandahn rahno, re ahpw meirongkihla mahn akan mehn wia meirong isihs, oh pil meirong en kaminimin. Re ahpw mwohdpene oh mwenge; mwuhri, re ahpw uhd nim sakau oh sakaula oh pil wiewia nsenen pwopwoud. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","KAUN-O ahpw mahsanihong Moses, “Kohdihwei mwadang rehn aramas akan me ke kahrehdo sang Isip, pwe re sapwungalahr. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Re wetsangehr nan ahl me I kilelehiong irail re en kin idawehn; re wiadahr ong pein irail kouwol men me re wiahsang ni kohl me re inimada, re ahpw pwongipwongih oh wiewia meirong ong, ndinda me ih arail kohto, me kahluwairail sang Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","I ese duwen aramas pwukat ar nohn keptakai. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Eri, ke dehr kapweiekiehdi, pwe I uhdahn engieng pahrail, I pahn kamwomwirailla. I ahpw pahn wiahkin uhk oh kadaudokomw kan ehu wehi me ndand mehlel.” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moses ahpw ngidingidki eh pekipek, ong KAUN-O eh Koht, patohwan, “Maing KAUN, dahme komwi nohn engiengki pahn sapwellimomwi aramas akan, me komwi ketin kapitasang Isip ni roson oh manaman lapalahpie? ");
INSERT INTO pon2006a_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Pwe Mehn Isip kan en kak ndahki me komwi ketin kahluwa sang sapwellimomwi aramas akan Isip, pwe komwi koasoakoasoane en kemeirailla pohn nahna kan oh kamwomwirail douluhl? Komw ketin kameleileidi kupwuromwi; komw ketin kupwurehla sapwellimomwi aramas akan, oh dehr kauweirailla. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Komw ketin tamanda sapwellimomwi ladu ko, Eipraam, Aisek oh Seikop, oh duwen inowo me komw ketin wiahiong irail, ni omwi ketin kahukihong irail me komw pahn kangederehla kadaudokarail kan pwe re en duwehla tohtohn usu kan me mi pahnlahng, oh pahn kihong kadaudokarail kan sahpw me komw inoukidahr, pwe re en sapwenikihla kohkohlahte.” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","KAUN-O eri ketin wekidala kupwure, oh sohte ketin kapwaiong sapwellime aramas ako kalokolok me e ketin kupwuredahro. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moses eri patopatohdi sang pohn nahnao, wa pelien takai riapalio, me sapwellimen KAUN-O kosonned ko ntinting powe. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Pelien takai riapalio, iei wiepen pein nin limen Koht, oh nting ko pein Koht me ketin wiadiong powe. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Sosua eri rongada mwoaromwoarong en aramas ako, e ahpw ndaiong Moses, “Likamw I rong ngilen mahwen nan kahnimpwalo.” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moses ahpw sapeng, nda, “Kaidehk ngilen mwoarong kaperen en powehdi, de ngilen mwoarong kansensuwed en lohdi; mwoarong en aramas me kokoul me I rongorong.” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ni Moses eh kerendohngehr ni kahnimpwalo oh kilangada mwomwen kouwolo oh aramas ako ar kahkahlek, nan kapehde ahpw lingeringerda kowahlap. E ahpw katepwekehki tepin nahnao pelien takai riapalio me e weuwa kohdi, oh pwalangpeseng. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","E ahpw poarehngete mwomwen kouwolo, keselahng nan kisiniei. Mwuhr, e ahpw kamwutepene oh doaloahki pihl. Ih eri kanimpilehki mehn Israel ko pihlo. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","E ahpw ndaiong Aaron, “Dahme aramas pwukat wiahiong uhk pwe ke en kahrehiong irail nan dihp lapalap wet?” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron ahpw sapeng Moses, nda, “Maing, komw dehr lingeringer pahi; komw ese mwahu duwen aramas pwukat ar nohn semeniong me suwed. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Re ndaiong ie, ‘Wiadahng kiht emen kohten pwe en kahluwei kiht, pwe se sehselahr dahme wiahiong ohl menet Moses me kahreikitodo sang Isip.’ ");
INSERT INTO pon2006a_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ngehi eri ndaiong irail, re en wahdo neirail kohl kan, eri, irail ko me mie tiarail kohl re kihpene oh wadohng ie. Ngehi eri kesehdiong nan kisiniei, kouwol kohl menet pa pwarada!” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moses eri esehda duwen aramas ako ar pingkidahr en Aaron eh mweidada re en kaudokiong dikedik en kouwolo, mehnda ma wasao e keper ong irail pwehki ar imwintihti kan ar kapilirailpene. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","E ahpw kesihnenda ni ewen kelen kahnimpwal ako, oh nda, “Mehmen me men iang KAUN-O, en kohdo rehi!” Mehn Lipai ko koaros eri pokonpene oh kapilpene. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","E ahpw ndaiong irail, “KAUN-O, Koht en Israel, mahsanih, me emenemen kumwail koaros en ale noumwail kedlahs akan oh kohwei ni impwal kan koaros sang ni ewen kehl wet lel palio, oh kemehla riamwail kan, kompoakepamwail kan oh mehn mpamwail kan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Mehn Lipai ko eri kapwaiada duwen me Moses ndaiong irail, oh rahnohte, aramas kereniong 3,000 kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moses eri ndaiong mehn Lipai ko, “Rahnwet kumwail pein kasarawihongkumwailehr doadoahk en samworoun KAUN-O, ni amwail kemelahr noumwail pwutak kan oh riamwail kan. Eri, KAUN-O ketin kupwuramwahwihkumwailehr rahnwet.” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Mandahn rahno Moses ahpw ndaiong aramas ako, “Kumwail wiadahr dihp lapalap ehu. Eri, I pahn kohdalahng pohn nahnao rehn KAUN-O; mweinele I kak ale mahkpen dipamwailen.” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moses eri pwuradalahng rehn KAUN-O oh patohwanohng, “Maing, pokon en aramas pwukat wiadahr dihp lapalap ehu. Pwe re wiadahng pein irail koht emen sang kohl. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Eri, komw ketin kupwurmahkohng irail. Ma komw sohte pahn kupwurmahk, a komw ketin irisasang mwareiet nan pwuhk me komw ketin ntingihedi.” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","KAUN-O ahpw mahsanihong Moses, “Ihte me I pahn irisasang nan nei pwuhk, me kin wiahda dihp ong ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Eri met, kohwei oh kahluwalahng nei aramas akan wasa me I kilelehionguhkehr. Ke ahpw tamataman pwe nei tohnleng pahn kahluwaiuk, oh ni ahnsoun kalokolok, I ahpw pahn kalokehkin irail diparailo.” ");
INSERT INTO pon2006a_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","KAUN-O eri ketin kalokehkin irail soumwahu ieu, pwehki ar idingohng Aaron en wiahda kouwolo. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","KAUN-O ahpw mahsanihong Moses, “Mweselsang wasaht, iangahki aramas akan me ke kahredo sang Isip. Kumwail kohwei nan sahpw me I inoukihda me I pahn kihong Eipraam, Aisek, Seikop, oh pil kadaudokarail kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","I pahn kadarewei emen tohnleng pwehn kahluweikumwail. I pahn kasarehla mehn Kenan kan, mehn Amor kan, mehn Id kan, mehn Peris kan, mehn Ip oh mehn Sepus kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Kumwail pahn kohwei nan sahpw kaselel oh reken dipwisou. Ahpw I sohte pahn iang kumwail, pwehki amwail nan kapehd keptakai, I de kauweikumwailla nanialo.” ");
INSERT INTO pon2006a_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ahnsou me aramas ako rongada mahsen kansensuwed wet, re tapihada mwahiei oh kihsang arail kapwat akan. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Pwe KAUN-O mahsanihong Moses en ndaiong irail, “Aramas keptakai kei kumwail. Ma I pahn iang kumwail kohwei, mehnda ma ahnsoutehkis, I uhdahn pahn kamwomwkumwailla. Eri, kumwail kihsang noumwail kisin kohl kan; I ahpw pahn ese dahme I pahn wiahiong kumwail.” ");
INSERT INTO pon2006a_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Eri, ni arail mweselsang Nahna Sainai, mehn Israel ko sohla kapwatki kisin kohl. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Wasa koaros me mehn Israel kan pahn kin kauwada ie imwarail impwal akan, Moses kin epwehnki kauwada Impwal sarawio ekis dohlahsang imwarail impwal ko. Me adaneki Impwal me KAUN-O kin ketiket loale, oh mehmen me kin anahne tuhkihong KAUN-O mehkot, pahn kin kohla wasao. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ahnsou koaros me Moses pahn pwarala wasao, aramas koaros pahn kesihnenda ni wenihmwen imwarail impwal kan oh kilikilang Moses e lao kin pedolong loale. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mwurin, Moses eh kin pedolong loale, pelien depwek pali kin kohdi oh perehla wenihmwen Impwalo, KAUN-O ahpw kin ketin mahseniong Moses sang nan pelien depweko. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ahnsou me aramas ako pahn kilang pelien depweko ni wenihmwen Impwalo, re kin poaridi. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","KAUN-O ahpw kin ketin mahseniong Moses ni sansal mehlel, duwehte aramas emen eh kin lokaiaiong kompoakepah. Moses ahpw kin pwurala nan kahnimpwalo, a mwahnakapw me kin seweseo, me ede Sosua, nein Nun, e kin mihmihte nan Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moses ahpw patohwanohng KAUN-O, “Maing, mehlel pwoat me komw ketin mahsanih I en kahluwalahng aramas pwukat nan sahpwo, ahpw komw sohte ketin mahsanihong ie ihs me pahn iang ie patohla. Komw ketin mahsaniher me komwi mwahngih mehlel duwen ngehi, oh komw kupwurperenkin ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Eri, ma komw kupwurperenkin ie, I patohwan peki rehmwi, komwi en ketin kasalehiong ie kupwuromwien, pwe I en dadaurete ei kin papah komwi oh kin kaparanda kupwuromwi. Komwi en pil tamataman aramas pwukat me komw ketin piladahr pwehn wiahla sapwellimomwi.” ");
INSERT INTO pon2006a_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","KAUN-O ahpw mahsanih, “I pahn ieiang uhk, pwe ke en powehdi.” ");
INSERT INTO pon2006a_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moses ahpw sapengki, “Ma komw sohte pahn ketin ieiang kiht, a komw dehr kadarkitala sang wasa kiset. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Pwe ia duwen at pahn ese me komw ketin kupwurperenkin ie oh sapwellimomwi aramas akan, ma komw sohte ketin ieiang kiht? Ma komw pahn ketin ieiang kiht, se uhdahn pahn keniken pahn kupwuromwi mwohn aramas teikan en sampah.” ");
INSERT INTO pon2006a_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","KAUN-O ahpw mahsanihong Moses, “I pahn kapwaiada me ke ahpwtehn ndahn, pwehki ei kin kupwurperenkin uhk oh mwahngihiuk mehlel.” ");
INSERT INTO pon2006a_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moses eri peki rehn KAUN-O, patohwan, “Maing, komw ketin kupwurkalahngan kasalehiong ie mahs omwi lingaling.” ");
INSERT INTO pon2006a_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","KAUN-O ahpw ketin sapeng, mahsanih, “Eri, I pahn kasalehiong uhk ei lingan koaros, oh I pahn masanihada mwohmw mwarei; iei mwarei, KAUN-O, oh I me kin kupwurkalahngan ong irail kan me I kin pilada. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ke sohte kak kilang ie, pwe sohte aramas emen kak kilang ie ahpw momour; ");
INSERT INTO pon2006a_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ahpw iet wasa kis limwahi me ke kak kesihnenda pohn paip ehu. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ni ahnsou me ei lingaling pahn lel met, I pahn kihdiong uhk nan peden paipo, oh perehkihla pehiet mesomwen, I lao daulihiuk. ");
INSERT INTO pon2006a_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","A I ahpw pahn kihsang pehiet, ke ahpw pahn kak kilang tihnseweiet, a kaidehk silangiet.” ");
INSERT INTO pon2006a_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","KAUN-O ahpw mahsanihong Moses, “Wiahda pelien takai riapali me duwehte mehn mahs ako, pwe I en ntingihedi powe mahsen ko me ntingdier pohn takai riapalio me ke pwalangpesengo. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Nimenseng en lakapw ke pahn kaunopada oh kohdahdo pohn Nahna Sainai oh tuhwong ie. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Sohte me pahn iang uhk kohdahdo; sohte me pahn mihmiseli nin nahnaht; pil sohte sihpw de kou pahn mwengemwengeseli mpen nahnaht.” ");
INSERT INTO pon2006a_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Moses eri wiahda pelien takai riapali me duwehte mehn mahs ako, oh nimenseng en mandahn rahno e patohdahla pohn Nahna Sainai, duwen me KAUN-O ketin mahsanih; e ahpw wa pelien takai riapalio. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","KAUN-O eri ketidihdo, ket nan pelien depwek pali, e ahpw ket mwohn Moses oh mahsanih mware sarawi, KAUN-O! ");
INSERT INTO pon2006a_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","KAUN-O eri ketin keid mwowe oh mahsanih, “Ngehi, KAUN-O, Koht emen me diren kalahngan oh kadek, me sohte kin mwadahng lingeringerda, oh me diren limpoak lapalap oh loalopwoat mehlel. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","I kin kapwaiada ei inou ong me ngeder, oh kin mahkohng me suwed kan oh me dipan akan; ahpw I uhdahn pahn kalokehki seri kan oh nein neirail kan lel ni dih kesiluh oh kapahieu pwehki dipen samarail kan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ni ahnsowohte, Moses ahpw poaridiong nanpwel oh pwongih, ");
INSERT INTO pon2006a_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","e ahpw patohwan, “Maing, ma komw uhdahn ketin kupwurperenkin ie, a komw ketin ieiang kihtete. Aramas pwukat me keptakai, ahpw komw ketin mahkikihong kiht at sapwung oh dipat akan, oh wiahkinkitala sapwellimomwi.” ");
INSERT INTO pon2006a_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","KAUN-O ahpw mahsanihong Moses, “I pahn wiahda inou ehu ong mehn Israel. I pahn wiahda mwohrail soahng kapwuriamwei kei me saikinte wiawi nin sampah rehn tohn wehi kan. Pwe aramas akan me ieiang uhk en kilang dahme ngehi, KAUN-O, kak wiahda, pwe I pahn wiahiong kumwail mehkot lammwin mehlel. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Kumwail kapwaiada kosonned akan me I pahn kihong kumwail rahnwet. I pahn koahkoahsang mwohmwail mehn Amor kan, mehn Kenan kan, mehn Id kan, mehn Peris kan, oh mehn Sepus kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Kumwail dehr wiahiong inou ehu ong tohn wehio me kumwail kohkolahng, pwe met pahn kahrehiong kumwail amwail pahn lohdi. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ahpw kumwail pahn kauwehla arail pei sarawi kan, kamwomwala arail mwoahl sarawi kan, oh pelehdihsang arail kilel en koht lih Asera. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Kumwail sohte pahn pwongih emen koht tohrohr en liki, pwe ngehi, KAUN-O, me luwakahk. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Kumwail dehpa wiahiong tohn wehio inou ehu, pwe ni ar pahn pwongih ar koht likamw akan oh meirongohng irail, re de lukeikumwail en iang tungoale ar mehn meirong kan me meirongalahr. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Kumwail pil sohte pahn kapwopwoudiheki noumwail pwutak kan neirail serepein kan; pwe lihen liki pwukat kin wia tiahk suwed ni ar kin kaudokiong ar koht kan, oh re de kahrehiong noumwail pwutak kan ar sohpeisang ie oh papah koht likamw akan. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Kumwail sohte pahn wiahiong kumwail koht me wiawihda sang mete oh kaudokiong. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Kumwail pahn kapwaiada Sarawien Pilawa Sohte Doal Ihs. Nin duwen me I mahsanihong kumwailehr, erein rahn isuh kumwail pahn tungoale pilawa me sohte doal ihs nan sounpwong en Apip, pwe ih nan sounpwongo me kumwail mweseldo sang nan wehin Isip. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Mesenih ohl koaros oh mesenihen mahn akan uhdahn nei. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ahpw mesenihen ahs koaros kumwail pahn wiliankihda emen sihpwen; ma kumwail sohte pahn wilianda, a kumwail pahn katimpeseng tepinwere. A mesenihen noumwail pwutak kan kumwail pahn wiliankihda mwohni. “Sohte emen rehmwail pahn patohda mwohi kahiep, sohte wa mehkot mehn meirong. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Kumwail pahn doadoahk erein rahn weneu, a ni keisuhwen rahn kumwail pahn kommoal; mehnda ma pil ahnsoun deipwel oh dolung wahnsahpw. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Kumwail pahn kapwaiada Sarawien Wahnsahpw, ni ahnsoun dolung wahn pilawa kan. Kumwail pil pahn kapwaiada Sarawien Impwal, ni ahnsoun lemwulemwur, ni amwail pahn kihpene amwail wahnsahpw akan. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Pak siluh nan sounpar ehu ohl koaros pahn pwarodo oh pwongih ie, KAUN-O, Koht en Israel. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Mwurin ei pahn kausasang wehi kan mwohmwail oh kalaudehla irepen amwail wehi, sohte emen me pahn men song kalowehdi sapwamwail nindokon amwail pahn kin wiewia sarawi siluh pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Kumwail sohte pahn meirongkihong ie pilawa me doal ihs ni amwail pahn kin wiahiong ie meirongen mahn. Kumwail sohte pahn nahkohng nimenseng mehkot me kisehn mahn kamala me wia Sarawien Pahsohpa. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Kumwail pahn kin mwohwehiong tehnpas en KAUN-O dipwisou me keieu mwahu kan en nan sapwamwail kan. “Kumwail sohte pahn pwoailih kisin sihmpwul men de kuht men nan pilen dihdien eh nohno.” ");
INSERT INTO pon2006a_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","KAUN-O eri mahsanihong Moses, “Ntingihedi mahsen pwukat, pwe ih mahsen pwukat me I wiahki ei inou ong uhk oh ong mehn Israel.” ");
INSERT INTO pon2006a_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moses eri patopatohte rehn KAUN-O erein rahn pahisek oh pwohng pahisek, sohte kin tungoale mehkot de sohte kin nimpil. Ih eri ntingihediong pohn pelien takai riapalio mahsen kan en inowo—Kosonned Eiseko. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ni ahnsou me Moses patopatohdi sang pohn Nahna Sainai, wa pelien takaien kataman ko, e sasairki me meseo lingaling pwehki eh patopato ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ni Aaron oh aramas ako ar kilangada Moses oh diarada duwen meseo eh lingaling, re masak keilahng mpe. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moses eri eker irail, a Aaron oh kaunen mehn Israel koaros ahpw keilahng reh, ih eri lokaiaiong irail. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Mwuhr, mehn Israel ko koaros ahpw keipenehng mpe, e ahpw kasalehiong irail kosonned koaros me KAUN-O mahsanihong pohn Nahna Sainai. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ni Moses eh kaimwisekala eh kapahrek, e ahpw perehkihla meseo koaduhpwel ehu. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ahnsou koaros me e kin patohla nan Impwal me KAUN-O kin ketiket loale, pwe en tuhwong KAUN-O oh patohong, e kin kihsang perehpen meseo. Ni eh kin pedoisang loale, e kin padahkihong mehn Israel ko mehkoaros me KAUN-O kin ketin mahsanihong en patohwanda. ");
INSERT INTO pon2006a_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Irail kin kilang duwen meseo eh kin lingaling, ahpw e kin pwurehng perehkihla koaduhpwelo meseo lao lel ahnsou me e kin pwurala pwe en patohong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moses kapokonepene mehn Israel ko koaros oh patohwanohng irail, “Iet dahme KAUN-O ketin koasoanediong kumwail pwe kumwail en kapwaiada. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Erein rahn weneu kumwail kak doadoahk, ahpw ni keisuhwen rahno pahn wia rahn sarawi, rahn lapalap en kommoal me kasarawihong ie, KAUN-O. Mehmen me pahn doadoahk rahno pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Kumwail sohte pahn pil saunda kisiniei nan imwamwail kan ni rahnen Sapad.” ");
INSERT INTO pon2006a_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moses patohwanohng mehn Israel ko koaros, “Iet dahme KAUN-O ketin koasoanehdi: ");
INSERT INTO pon2006a_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Kumwail en wia amwail kisakis ong KAUN-O. Koaros me nsenki en patohwanohng KAUN-O eh kisakis en kohl, silper de prons; ");
INSERT INTO pon2006a_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","likou linen kaselel; wunen sihpw poh mei, ntahnmwel, oh weitahta; likou me wiawihkihda wunen kuht; ");
INSERT INTO pon2006a_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","wunen sihpw wol me koaduh nan poh weitahta; kilin kou kaselel; tuhke akesia; ");
INSERT INTO pon2006a_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lehn lamp akan; soangen mehn doalo lehn kei oh warpwohmwahu; ");
INSERT INTO pon2006a_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","karnelian oh kisin takai kesempwal teikan mehn kapwata ihpod en Samworo Lapalap oh kapwata perehpen mwaremware. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Toundoadoahk saman koaros rehmwail en patohdo oh wiahda mehkoaros me KAUN-O ketin koasoanehdi: ");
INSERT INTO pon2006a_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Impwalo, pweine oh pwelengen masliki, metehn kateng kan, uhr kan, lohlo kan, lepin uhr kan oh poahsoane kan; ");
INSERT INTO pon2006a_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Kohpwahn Inowo, oh tuhkehn wisik kan, pweine, kahdeng kan me wia perehpe; ");
INSERT INTO pon2006a_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","tehpelo iangahki tuhkehn wisik ko, oh dipwisou kan koaros, pilawa mehn meirong ong Koht; ");
INSERT INTO pon2006a_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","dewen lampo iangahki dipwisawi kan, oh lamp akan iangahki leh kan; ");
INSERT INTO pon2006a_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","pei sarawi en isik warpwohmwahu, iangahki tuhkehn wisik kan, oh lehn keio; warpwohmwahu; kahdeng en wenihmwen Impwalo; ");
INSERT INTO pon2006a_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","pei sarawi en isik mehn meirong kan, iangahki pasapas en inihn pronso oh tuhkehn wisik kan oh dipwisawi kan; peisin en omwiomw oh kapio; ");
INSERT INTO pon2006a_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","kahdeng en kehl iangahki lepin uhr kan oh poahsoane kan, kahdeng en wenihmwen kehlo; ");
INSERT INTO pon2006a_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","kisin tuhkehn katenge Impwalo oh sahl akan, oh kehlo; ");
INSERT INTO pon2006a_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","oh likou lingan akan me samworo kan pahn kin likawih ahnsoun ar papah nan Wasa Sarawio—likou sarawi kan en samworo Aaron oh nah pwutak kan.” ");
INSERT INTO pon2006a_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Mehn Israel ko koaros ahpw mweselpeseng, ");
INSERT INTO pon2006a_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","oh emenemen nin duwen me e nsenki ahpw patohwanohng KAUN-O eh meirong mehn wiahda Impwal me KAUN-O pahn kin ketiket loale. Re wahdo soahng koaros me anahnepe mie ong ni kaudok oh mehn wia likoun samworo kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","koaros me inengieng, ohl oh lih, ahpw wapene mehn kapwat kan, mehntiati kan, rihng kan, mwaramwar akan oh soangen kisintakai kesempwal kan me kohl wia oh kasarawihong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Koaros me mie arail likou linen kaselel; wunen sihpw me poh mei, ntahnmwel, oh weitahta; likou me wiawihda sang wunen kuht, wunen sihpw wol me koaduh nan poh weitahta; kilin kou kaselel, re wapene. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Koaros me kak kihda silper de prons re pil meirongkihong KAUN-O, oh koaros me pil mie ar tuhke akesia me kak doadoahk, re pil wahdo. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Lih saman koaros pil wapene dereht linen kaselel oh dereht me wiawihda sang ni wunen sihpw, me poh mei, weitahta, oh ntahnmwel. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Re pil wiahda dereht sang ni wunen kuht. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Kaun akan wapene karnelian oh kisintakai kesempwal teikan mehn kohieng ni likou ihpod oh ni perehpen mwaremware, ");
INSERT INTO pon2006a_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","oh mehn wia lehn lamp akan, lehn kei oh warpwohmwahu. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Mehn Israel koaros me men patohwando ar mehn meirong kan ong KAUN-O ong ni doadoahk me e ketin koasoanediong Moses en wia. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moses eri patohwanohng mehn Israel ko, “KAUN-O ketin piladahr Pesalel, nein Uri, nein Hur sang ni kadaudok en Suda. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Koht ketin audehkidahr sapwellime manaman oh ketikihong koahiek oh saman oh dehdehki ni soangen doadoahk koaros en kalingan, ");
INSERT INTO pon2006a_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ong ni pilahnihada soangen mwahi kan oh ong wiepen soahng kan ni kohl, silper oh prons; ");
INSERT INTO pon2006a_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","doadoahk en parada takai kesempwal akan; iangahki tuhke oh soangen doadoahk lingan teikan. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","KAUN-O ketikihong ih oh Oliap nein Aisamak, sang ni kadaudok en Dan, koahiek en padahkihong meteikan doadoahk saman pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","E ketikihong ira saman en doadoahk en parada dipwisou, pilahnihada oh dehkada likou linen kaselel; wunen sihpw poh mei, ntahnmwel, oh weitahta, soangen likou teikan. Irail kak wiahda soangen doadoahk koaros oh re inenen samanohng pilahnihada. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Pesalel, Oliap oh tohndoadoahk saman teikan koaros, me KAUN-O ketikihongirailehr koahiek oh loalokong, me ese wiahda soahng kan me anahnepe mie ong ni kokoudahn Impwal sarawio, pahn wiahda soahng koaros nin duwen me KAUN-O ketin koasoanehdi.” ");
INSERT INTO pon2006a_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moses eri ekerodo Pesalel, Oliap oh ohl koahiek teiko me KAUN-O ketikihongirailehr koahiek en doadoahk oh me men iang sawas, oh patohwanohng irail re en tapihada doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Re ahpw ale sang reh mehn meirong koaros me mehn Israel ko wapene pwehn sewesehda kokoupen Impwal sarawio. Mehn Israel ko uselahte weuwapene ar mehn meirong ko nimenseng koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ohl koahiek ko me tapihadahr doadoahk, ahpw patohla rehn Moses ");
INSERT INTO pon2006a_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","oh patohwanohng, “Aramas akan wapenehr dipwisou tohtohsang me kitail anahne ong doadoahk me KAUN-O ketin koasoanedier kitail en wia.” ");
INSERT INTO pon2006a_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Moses eri kadarpeseng pakair nan kahnimpwalo me aramas akan en tokedihsang ar wapene dipwisou ong ni kokoupen Impwal sarawio; aramas ako eri sohla wapene dipwisou. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Pwe dahme wisikpenehr, itarohngehr kanekehla doadoahko. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Ohl me keieu koahiek ni koadoahkpen Impwal me KAUN-O pahn kin ketiket loale, wiahkihda Impwalo sang ni lepin likou linen kaselel eisek me wiawihkihda wunen sihpw poh mei, ntahnmwel, oh weitahta, oh mwomwen kerup kei deiadidi powe. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Lepin likou ko koaros soangen wehteieu, iaht 14 reirei oh iaht 2 tehlap. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Re dehkpene limau lepin likou ko wiahla ehu, pil duwehte lepin likou limau teiko. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Re ahpw kihong ni keilen pelien likou riauo mwomwen pwakel limeisek me poh mei. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Re kihong pwakel limeisek ni pelien likou keieuo oh pil pwakel limeisek ni pelien likou keriauo, re kapahrekihpene pwakel ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Re wiahda kisin metehn kateng kohl limeisek, me kolpene pelien likou riauo oh wiahla ehu. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Re wiahkihda pweinen Impwalo lepin likou eisek ehu me wiawihkihda wunen kuht. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Re wiahda koaros soangen wehteieu, iaht 15 reirei oh iaht 2 tehlap. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Re dehkpene lepin likou limau wiahla ehu, oh me weneu teiko ong ni ehu. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Re kihong pwakel limeisek ni keilen kahdeng keieuo oh pil pwakel limeisek ni keilen kahdeng keriauo. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Re wiahda kisin metehn kateng limeisek oh kolkipene kahdeng riauo oh wiahla ehu pweipwei. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Re wiahda pweipwei riau, ehu wiawihda sang ni wunen sihpw wol me koaduh poh weitahta, a ehu sang ni kilin kou kaselel, mehn pwaindi maslikio. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Re wiahda uhr en Impwalo sang ni tuhke akesia. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ehuehu uhr reireiki piht 15 oh ins 27 tehlap, ");
INSERT INTO pon2006a_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","mie mehkot me sikeisang imwin ehueheu uhr pwehn kolpene uhr ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Re wiahda uhr riehk ong palieir, ");
INSERT INTO pon2006a_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","oh poahsoan silper pahisek mi pah, poahsoan riau pahn ehuehu uhr pwehn kolada mehkot sikeisang pahn uhr ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Re wiahda uhr riehk ong paliepeng en Impwalo, ");
INSERT INTO pon2006a_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","oh poahsoan silper pahisek, riau pahn eheuehu uhr. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ong ni palikapi en Impwalo, re wiahda uhr wenepwoat, ");
INSERT INTO pon2006a_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","oh uhr riapwoat ong ni keimw kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Uhr en keimw pwukat patpene sang pah kohda lel powe. Ih duwen kosoandien uhr riapwoat en nan keimw kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Eri uhr welipwoat me wiawihda oh poahsoan silper eisek weneu, poahsoan silper riau pahn ehuehu uhr. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Re wiahda lohlo eisek limau sang tuhke akesia, limpwoat ong uhr kan en apali Impwalo, ");
INSERT INTO pon2006a_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","a limpwoat ong apali, oh limpwoat ong uhr kan en palimese oh palikapi. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Lohlo en nanwerenge, pahn mi nanpwungen uhr kan, oh tang sang ni apali Impwalo lel apali. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Re kidimkihla uhr ko kohl oh kihong rihng kohl kei me kolpene lohlo ko, kohl me kidim lohlo ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Re wiahda kahdeng ehu sang likou linen kaselel me wiawihkihda wunen sihpw me poh mei, ntahnmwel, oh weitahta, oh mwomwen kerup kei deiadidi powe. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Re wiahda lepin uhr pahpwoat sang tuhke akesia oh kidimkihla kohl, me kahdengo pahn kin langada ie, oh katengehkihdi kisin metehn kateng kohl kei. Re ahpw wiahda poahsoan pahieu en silper mehn utungada lepin uhr ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ong ni wenihmwen Impwalo re wiahda kahdeng ehu sang likou linen kaselel me wiawihda sang wunen sihpw poh mei, ntahnmwel, oh weitahta, me deiad lingan. ");
INSERT INTO pon2006a_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ong kahdeng wet re wiahda lepin uhr limpwoat, oh katengehkihdi metehn kateng kei, me kidikidkihla kohl, oh wiahda poahsoan prons limau ong lepin uhr pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Pesalel wiahkihda Kopwahn Inowo sang tuhke akesia, me reireiki ins 45 oh tehlapki ins 27, oh ilehki ins 27. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","E ahpw kidimki kohl loale oh liki oh kapilkipene kohl keile ko koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","E wiahda rihng pahieu en kohl mehn wisik oh katengediong ni neh pahieu en Kohpwao, riau apali a riau apali. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","E wiahda tuhkehn wisik sang tuhke akesia, oh kidimkihla kohl, ");
INSERT INTO pon2006a_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","e ahpw kadil tuhke ko nan rihng ko ni keile riau en Kohpwao. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","E wiahda pweine me kohl tohr wia, me reireiki ins 45 oh ins 27 tehlap. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","E wiahda kerup riemen me perperda sang kohl, ");
INSERT INTO pon2006a_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","emen mi ni apali pweinen Kohpwao, a emen apali. Kerup ko wiawihdahte patehng pweinen Kohpawo. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ira sohpeipene pohn pweinen Kohpwao oh kapapeseng pehra ko powe oh koaduhpwaldi. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","E wiahda tehpel ehu sang tuhke akesia, me reireiki ins 36, tehlapki ins 18, oh ilehki ins 27. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","E ahpw kidimkihla kohl tohr oh kapilkipene kohl ni keile ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","E wiahda mehn kolpene me tehlapki ins 3 oh kohl me kidim mehn kolpeneo. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","E ahpw wiahda rihng kohl pahieu, oh katengediong ehuehu ni keimw pahieu en nehn tehpelo. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Rihng ko me kolada tuhkehn wa tehpelo mihte limwahn keilen tehpelo. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","E wiahda tuhkehn wisik ko sang tuhke akesia oh kidimkihla kohl. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","E wiahkihda kohl tohr dahl ekei mehn mi pohn tehpelo: pileit, kep, sah oh pwohl kei mehn doadoahk ong ni meirong en wain. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","E wiahkihda dewen lampo kohl tohr. E wiahkihda poahsoane oh inonde sang kohl sukusukda; kapwate kan, me iangahki wahntuhke mpwek oh teh, patehngete lampo. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Rah weneu uhsang ni keile, siluh sang apali a siluh apali. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ni ehuehu rah weneu ko mie kapwat wahnrohs siluh me mwomwen masal en almond iangahki mpweke oh teh kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ni inonden dewen lampo mie kapwat wahnrohs pahieu me mwomwen masal en almond iangahki mpweke oh teh kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Mie ehu wahnrohs mpwek pahn ehuehu rah siluh ko koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Mpwek kan, rah kan oh dewen lampo sukusukda ehute sang ni kohl tohr. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","E wiahda lamp isuh ong ni dewen lampo, oh e wiahkihda kohl tohr tihpw kei oh opwong kei. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","E doadoahngkier paun 75 en kohl ong ni dewen lampo oh dipwisawi kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","E wiahda pei sarawi ehu sang tuhke akesia, wasa warpwohmwahu pahn kin isihsla ie. E wiahda keimw pahieu oh reireiki ins 18, oh tehlapki ins 18 oh ilehki ins 36. Kode kan ni keimw pahieu uhsangete ni pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","E kidimki kohl tohr powe, ni keile pahieu koaros oh iangahki kode ko, oh kapilkipene ni keile kohl tohr. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","E wiahda rihng riau mehn wisik oh kihdiong pahn keile ko pali riau, mehn kolada tuhke riapwoat mehn wa pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Tuhke akesia me e wiahkihda tuhkehn wisik ko oh kidimkihla kohl. ");
INSERT INTO pon2006a_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","E pil wiahda lehn kei sarawi oh warpwohmwahu, me doalpene duwehte lehn wai pwohmwahu. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ong ni mehn meirong isihs, e wiahda pei sarawi ehu sang tuhke akesia. E keimw pahieu, piht isuh elep reirei oh isuh elep tehlap, oh piht pahieu elep ile. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","E wiahda ni keimw pahieu kode pahieu me uhsangete pei sarawio. E ahpw kidimkihla wasa koaros prons. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","E pil wiahda dipwisoun pei sarawio koaros: pan, sapwel, pwohl, tihpw, oh pan me kisiniei pahn mi loale. Dipwisou pwukat koaros wiawihkihda prons. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","E wiahkihda prons pasapas ehu mehn inihn, oh kihdiong pahn keilen pei sarawio, eri ile en mehn inihn wet lelte nan lukopen pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","E wiahda rihng pahieu mehn wisik oh kihdiong ni keimw pahieu ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","E wiahda tuhkehn wisik kei sang tuhke akesia oh kidimkihla prons, ");
INSERT INTO pon2006a_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","oh kadil nan rihng ko me mi ni pali riau en pei sarawio. Pei sarawio wiawihkihda dinapw oh mwowmen kohpwa. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","E wiahda peisin pronso oh kapio sang ni kilahs en irongen, lih akan me kin wie papah ni wenihmwen Impwal me KAUN-O kin ketiket loale me kihda kilahs pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","E wiahkihda likou linen kaselel kahdeng en kelen Impwal me KAUN-O pahn kin ketiket loale. Ni palieir kahdeng ko reireiki iaht 50, ");
INSERT INTO pon2006a_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","kahdeng ko langada ni lepin uhr prons rieisek me uhda sang pohn poahsoan prons rieisek, iangahki kisin metehn kateng oh mete ahtikitik me pahn kedil nan kahdengo, pil wiawihda sang silper. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Wiepen kehlo ni paliepeng duwehte wiepen palieir. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ni palikapi kahdeng ko reireiki iaht 25, oh lepin uhr eisek oh poahsoan eisek iangahki metehn kateng oh mete ahtikitik me pahn kedil nan kahdengo, pil wiawihda sang silper. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ni palimese, wasa me wenihmwo mi ie, kahdengo pil tehlapki iaht 25. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Ni pali riau en wenihmwo kahdeng iaht isuh elep mi ie, iangahki lepin uhr silipwoat oh poahsoan siluh. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Kahdeng koaros me kapil kehlo wiawihda sang ni likou linen kaselel. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Poahsoan en lepin uhr ko wiawihda sang prons, metehn kateng ko oh mete ahtikitik ko me pahn kedil nan kahdeng ko wiawihda sang ni silper, oh silper me pil kidim ni imwin lepin uhr ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Kahdeng en wenihmwen kehlo wiawihda sang likou linen kaselel me wiawihda sang ni wunen sihpw poh mei, ntahnmwel, oh weitahte me deiad lingan. E reireiki iaht eisek oh ilehki iaht riau elep, duwehte kahdeng en kehlo. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Kahdeng ko langada ni lepin uhr pahpwoat me uhda pohn poahsoan prons pahieu. Metehn kateng kan, pweinen imwin uhr kan oh mete ahtikitik me pahn kedil nan kahdeng ko pil wiawihda sang ni silper. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Metehn kateng koaros mehn katengediong nanpwel Impwalo oh kehlo wiawihda sang prons. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Iet uwen mete me doadoahkala ni wiepen Impwal me KAUN-O pahn kin ketiket loale, wasa me pelien takai riapalio me Kosonned Eiseko ntinting powe, kin nekinek ie. Moses me koasoanehdi oh mehn Lipai kan me wiahda pahn kaweidpen Idamar, nein samworo Aaron. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Pesalel nein Uri, nein Hur, sang kadaudok en Suda, wiadahr soahng koaros me KAUN-O ketin koasoanedier. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Sawasepe Oliap, nein Aisamak, kisehn kadaudok en Dan, ih me saman en sukada mehkot, pilahnihada, oh pil saman en wiahda likou linen kaselel sang wunen sihpw poh mei, ntahnmwel oh weitahta. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Kohl koaros me kasarawihong KAUN-O ong ni wiepen Impwal sarawio, toutouki paun 2,195 nin duwen wadawad en paun akan en Tehnpas sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Toutoun silper me alahldi sang rehn aramas akan me wadawadehr mihmi ni paun 7,550 nin duwen eh tenekehr oh nin duwen wadawad en paun akan en Tehnpas sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Uwen mwohni wet pahrekiong aramas koaros me wadawadier, emenemen pwainla uwen me koasoanedier oh tenek nin duwen wadawad en paun akan nan tehnpas sarawio. Ohl 603.550 me mahkier sounpar rieisek kohda me ntingdier nan wadawad en peneinei koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ong ni silper, paun 7,500 me doadoahkalahr pwehn wiahda poahsoan epwiki en Impwal sarawio iangahki kahdeng ko, paun 75 ong ni ehu poahsoan. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Luhwen silper ko me paun 50, Pesalel wiahkihda mete ahtikitik me kedil nan kahdeng ko, oh metehn katenge lepin uhr ko oh pil kidimkihla imwin uhr ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Prons me kasarawihongehr KAUN-O toutouki paun 5,310. ");
INSERT INTO pon2006a_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","E doadoahngkihong ni poahsoan kan en wenihmwen Impwal me KAUN-O pahn kin ketiket loale, iangahki pei sarawi pronso oh pasapas en inihno oh dipwisou koaros en pei sarawio, ");
INSERT INTO pon2006a_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","iangahki poahsoan koaros me kapil kehlo oh wenihmwen kehlo oh metehn katengediong Impwalo oh kehlo nanpwel. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Re wiahkihda likou kaselel kei sang ni likou wunen sihpw poh mei, ntahnmwel oh weitahta me samworo kan pahn kin likawih ni ar pahn kin wia ar doadoahk nan Wasa Sarawio. Re wiahiong Aaron eh likoun samworo nin duwen KAUN-O eh ketin koasoanediong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Re wiahda ihpod sang likou linen kaselel, me wiawihda sang ni wunen sihpw poh mei, ntahnmwel oh weitahta oh dereht kohl. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Re sukada kohl menipinip oh lupukedi ahtikitik oh dehkohng ni likou linen en wunen sihpw me poh mei, ntahmwel, oh weitahta. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Re kihong ni imwin pwopwen ihpodo kisin likou riau mehn katengepene imwin powe riau. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Kateng ehu pil wiawihda sangete ni soangen likowohte pil wiawihda patehngete ihpodo, nin duwen KAUN-O eh ketin koasoanediong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Re kaunopada kisin takai karnelian kan oh koasoanehdi ni mwomwen kohl; re ahpw ntingihdiong powe eden nein Seikop pwutak ehk riemeno. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Re ahpw kihong pohn kisin likou pohn pwopwen ihpodo mehn kataman kadaudok eisek riaun Israel duwen KAUN-O eh ketin koasoanediong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Re wiahda perehpen mwaremware oh doadoahngki soangen dipwisowohte me re wiahkihda ihpod oh soangen deiadohte. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","E keimw pahieu oh masriapar, ins 9 reirei oh ins 9 tehlap. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","11","Re kapwatahkihda kairek pahieu en kisin takai kesempwal kei: re kihong ni kairek keieu rupi, topas, oh karnet; ni kairek keriauo re kihdiong emarald, sapair, oh daimon; ");
INSERT INTO pon2006a_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ni kesiluhn kairek, turkuois, akat, oh amedist; ");
INSERT INTO pon2006a_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ni kapahieu, peril, karnelian, oh sasper. Kisin takai kesempwal pwukat koasoansoandi ni mwomwen kohl. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ni ehuehu kisin takai eisek riau pwukat e ntinting ie mwaren emenemen nein Seikop pwutak ko, mehn kasalehda kadaudok eisek riaun Israel. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ong ni perehpen mwaremwareo re wiahiong sahl sihn me kohl tohr oh ingkolpene. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Re wiahda kairek en kohl riau oh rihng kohl riau, oh kihong ni imwi powe en perehpen mwaremwareo. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Re pirehiong sahl kohl riapwoato ni rihng riauo, ");
INSERT INTO pon2006a_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","oh pirehiong imwi riau teiko ni perehpen mwaremwareo, ih duwen eh katengdiong mwohn pirapiren ihpodo. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Re wiahda rihng kohl riau oh koasoanediong ni keimw en pahn perehpen mwaremwareo maslikin ihpodo. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Re pil wiahda rihng kohl riau oh kihdiong ni pali peh riau en ihpodo, limwahn katengepen ihpodo. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Nin duwen me KAUN-O ketin koasoanediong Moses, re katengehkihdi sahl poh mei rihng riauo en perehpen mwaremwareo oh rihng en ihpodo, pwe perehpen mwaremwareo en soandi mwahu pohn katengepeo oh en dehr mwer. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Wunen sihpw poh mei me wia likou reirei me kin mi pohn ihpodo. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Pwoaren moangen likouo pwungidi pwehn kehlail, dehr teipeseng. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","Ni pwungipen imwi pah re kihdiong wahn pwohmakraneid kei me wiawihda sang ni wunen sihpw poh mei, ntahnmwel, oh weitahta oh kisin pehl kei me kohl tohr wia ahpw kapilpene, nin duwen me KAUN-O ketin koasoanediong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Re wiahda en Aaron oh nah pwutak ko arail seht, ");
INSERT INTO pon2006a_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","oh pil ar lisoarop, rausis linen, ");
INSERT INTO pon2006a_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","oh mehn kateng sang likou linen kaselel me wiawihda sang wunen sihpw me poh mei, ntahnmwel oh weitahta oh deiad lingan, nin duwen me KAUN-O ketin koasoanediong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Re wiahkihda kohl tohr dipwisou ko me wia kilel en kasarawi, re ahpw ntingihediong powe lepin mahsen wet “Kasarawihong KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Re ahpw pirehkihdi sahl poh mei ong ni temwen lisoaropo, nin duwen me KAUN-O ketin kosoanehdiong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Doadoahk koaros en Impwal me KAUN-O pahn kin ketiket loale ahpw imwisekla. Mehn Israel ko wiahda soahng koaros nin duwen me KAUN-O ketin koasoanediong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Re ahpw wadohng Moses Impwalo oh dipwisawi kan koaros, metehn kateng kan, uhr, ndape oh doakoloal kan, lepin uhr kan oh poahsoane kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Pweine me wiawihda sang wunen kuht wol oh koaduh poh weitahta; pweine kilin kou kaselel; kahdeng; ");
INSERT INTO pon2006a_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Kohpwahn Inowo me pelien takai riapalio mihmi loale, tuhkehn wisik ko oh pweine; ");
INSERT INTO pon2006a_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tehpelo oh dipwisawi koaros iangahki pilawa en meirong ong Koht; ");
INSERT INTO pon2006a_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","dewen lampo me kohl tohr wia, lamp akan oh dipwisawi koaros oh lehn lamp akan; ");
INSERT INTO pon2006a_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","pei sarawi kohlo; lehn kei; warpwohmwahu; kahdeng en kelen wenihmwen Impwalo; ");
INSERT INTO pon2006a_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","pei sarawi pronso iangahki pasapas en inihn pronso, tuhkehn wisik ko, oh dipwisawi koaros; peisin en omwiomw oh kapio; ");
INSERT INTO pon2006a_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","kahdeng en kehlo oh lepin uhr ko oh poahsoane kan; kahdeng en kelen wenihmwo oh sahl ako; metehn katengehdi Impwalo nan nanpwel; dipwisou koaros mehn doadoahk nan Impwalo; ");
INSERT INTO pon2006a_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","oh likou kaselel ko me samworo ko pahn kin likawih nan Wasa Sarawio—likou sarawi kan en Aaron oh nah pwutak ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Mehn Israel ko wiadahr mehkoaros nin duwen me KAUN-O ketin koasoanediong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moses dawiher mehkoaros oh kilangehr me re wiadahr mehkoaros nin duwen me KAUN-O ketin koasoanehdi. Moses eri kupwuramwahwihiralla. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ni keieun rahnen keieun sounpwong ke pahn kauwada Impwal me KAUN-O pahn kin ketiket loale. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ke pahn kihdiong loale Kohpwahn Inowo me pelien takai riapali en Kosonned Eisek mihmi loale, ke ahpw langadahng kahdengo mwowe. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Wahdo tehpelo oh koasoanediong powe dipwisawi kan. Pil walongodo dewen lampo oh kaunopada lamp akan powe. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Koasoanehdi pei sarawien warpwohmwahwo mwohn Kohpwahn Inowo oh kidahng kahdengo ni wenihmwen Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Pwilikihdi mwohn Impwalo pei sarawien meirong isihso. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kihdiong nanpwungen Impwalo oh pei sarawio peisin en omwiomwo, oh audehkihda pihl. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Koasoanehdi kehlo oh langahda kahdengo ni wenihmwen kehlo. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Ke ahpw kasarawihala Impwalo oh dipwisawi kan ni omw pahn keiehki leh sarawi, eri, e ahpw pahn sarawihla. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Mwuhr, ke pahn pil kasarawihala pei sarawio oh dipwisawi koaros ni omw pahn keiehki leh, e ahpw pahn sarawihla douluhl. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ke ahpw pil kasarawihala peisin en omwiomw oh kapio ni soangen mwohmwohte. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Ekerodo Aaron oh nah pwutak ko ong ni wenihmwen Impwalet oh padahkihong irail en duhdu nin duwen tiahk en kamwakel. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Kalikawihkihda Aaron likoun samworo, oh keiehki leh pwe en kasarawihla wiahla nei samworo. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Pil ekerodo nah pwutak ko oh kalikawihkinirailda seht kan. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ke ahpw keieiraildi duwehte omw keiedier samarailo, pwe re en kin papah ie nin duwen samworo kei. Kei sarawi wet pahn kahrehiong irail re en wiahla samworo kei erein dih koaros kohkohlahte.” ");
INSERT INTO pon2006a_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moses eri kapwaiada soahng koaros nin duwen me KAUN-O ketin koasoanehdi. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Eri, ni keieun rahnen keieun sounpwong ni sounpar keriau mwurin ar mweselsang Isip, Impwal me KAUN-O kin ketiket loale ahpw kokouda. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moses me kihdiong poahsoane kan, ih me kauwada uhr ko, ih me koasoanehdi lohlo ko, ih me kauwada lepin uhr ko. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","E ahpw pahkpeseng Impwalo oh kihdiong pweine powe, duwen me KAUN-O ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ih eri ale pelien takaien kataman ko oh kihdiong nan Kohpwahn Inowo. E pil kihdiong tuhkehn ro ko nan rihng en Kohpwao oh pwaindi. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","E ahpw wahlong Kohpwao nan Impwalo, oh langahda kahdengo. Iei duwen met eh perehla Kohpwahn Inowo, duwen me KAUN-O ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","E ahpw koasoanediong tehpelo nan Impwalo ni paliepeng, likin kahdengo, ");
INSERT INTO pon2006a_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","oh pwilikihdi powe pilawahn meirong ong KAUN-O, duwen me KAUN-O ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","A dewen lampo e pwilikihdi loale sallahng tehpelo, ni palieir en Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","E ahpw isikada lamp akan mwohn silangin KAUN-O, duwen me KAUN-O ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","E ahpw koasoanehdi pei sarawi kohlo nan Impwalo, mwohn kahdengo. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","E ahpw isikada warpwohmwahu powe, duwen me KAUN-O mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","E ahpw langahda kahdengo ni wenihmwen Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","A pei sarawien meirong isihso e kihdiong mwohn wenihmwen Impwalo. E ahpw wia eh meirong isihs oh meirong en wahn kohn powe, duwen me KAUN-O ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","E kihdiong peisin en omwiomwo nanpwungen Impwalo oh pei sarawio; e ahpw wudekihong pihl loale. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moses oh Aaron oh nah pwutak ko ahpw kin omwiomw loale oh widen nehrail ko wasao, ");
INSERT INTO pon2006a_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ni ar kin pedolong nan Impwalo, de keiong ni pei sarawio, duwen me KAUN-O ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Moses pil wiahda kehl ehu kapilpene Impwalo oh pei sarawio, oh langahda kahdeng ni wenihmwen kehlo. Moses eri kaimwisekala eh doadoahk koaros. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Pelien depwek pali eri kipehdi Impwalo oh lingaling en KAUN-O ahpw kadirehla tehnpaso. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moses eri sohla kak pedolong nan Impwalo, pwehki pelien depweko. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ahnsou koaros me pelien depweko kin saradasang pohn Impwalo, mehn Israel ko kin mweselda sang ehu wasa, mwesellahng ehu wasa tohrohr. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","A ma pelien depweko sohte kin saradasang, re sohte kin mwekidwei; re kin awiawihete lao lel rahn me pelien depweko kin saradasang. ");
INSERT INTO pon2006a_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Erein arail seiseiloak, re kak kilang pelien depwek en KAUN-O, me kin mihmi pohn Impwalo ni rahn, a nipwong kisiniei ehu me kin mpwumpwul powe. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","KAUN-O ketin malipe Moses sang nan Impwal me KAUN-O kin ketiket loale oh ketikihong kosonned pwukat ");
INSERT INTO pon2006a_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","pwe en patohwanohng mehn Israel kan en kapwaiada ni ar pahn kin wia arail meirong. Ni emen eh pahn meirongki mahn emen, e kak kihsang nin nah kou de sihpw de kuht kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ma eh meirong pahn mihmi ni meirong isihs en kou, mahno pahn kouwol emen, me sohte kisin samin kis reh. E pahn kahrehdo mahno ni wenihmwen Impwal me KAUN-O kin ketiket loale, pwe KAUN-O en ketin kupwurperenki. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Aramaso ahpw pahn kidahng peh pohn moangen mahno, pwehn wiahla eh meirong en tomwki dipe kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","E pahn kemehla kouo wasao, oh samworo kan me kadaudok en Aaron, pahn patohwandahng KAUN-O nta, a mwuhr re pahn usupihki ni keile pahieu koaros en pei sarawio me mihte ni wenihmwen Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Mwuhr e ahpw pahn kihsang kilin mahno oh sepepene uduke. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Eri, samworo kan pahn koasoanehdi tuwi pohn pei sarawio oh isikada. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Re pahn kihong uduk me sapidier ko pohn kisinieio, iangahki moange oh wihe ko. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Aramaso pahn kamwakelehda kepwehn mahno oh neh kan; eri samworo ahpw pahn isikala meirongo pwon pohn pei sarawio. Pwohn meirong en konot wet kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Ma aramas emen pahn meirongki sihpw men de kuht men, mahno pahn mahn wol emen me sohte kisin samin kis reh. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","E pahn kemehla ni paliepeng en pei sarawio, oh samworo kan ahpw pahn usupihki nta ni pali pahieu koaros en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Mwurin aramaso eh pahn sepepenehr uduken mahno, samworo ahpw pahn kihdi uduk en mahno pohn kisiniei, iangahki moange oh wihe ko. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Aramaso pahn kamwakelehda kepwehn loale kan oh neh kan; eri samworo ahpw pahn patohwandahng KAUN-O oh isikala meirongo pohn pei sarawio. Pwohn meirong en konot wet kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Ma aramaso pahn meirongki menpihr men nin duwen meirong isihs, menpihro pahn mwuroi men de emen menpihr me adaneki pitsin. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Samworo pahn wadohng menpihro ni pei sarawio; e ahpw pahn pirer tepinwere oh isikala moange pohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Samworo pahn kihsang kepwehn loale oh keselahng ni palimesehn pei sarawio wasa pehs ko kin lekdekla ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","E pahn ale pehn menpihro, kadangpeseng oh pwalangpeseng, ahpw e sohte pahn tehrasang peh kan, oh e pahn isikala pwon pohn pei sarawio. Pwohn meirong en konot wet kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Ma mehmen pahn meirongki wahnsahpw ong KAUN-O, en ngidarpene mahs pwe en wiahla pilawa. E pahn kihong lehn olip oh warpwohmwahu powe; ");
INSERT INTO pon2006a_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","E ahpw pahn wadohng rehn samworo kan me kadaudok en Aaron. Emen irail ahpw pahn ale ehu oaroahr en pilawao iangahki leho oh warpwohmwahu koaros oh isikala pohn pei sarawio, mehn wia kilel ehu me koaros meirongalahr ong KAUN-O. Pwohn meirong en konot wet kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Luhwen pilawa en meirongo pahn kohieng samworo ko. E wia mehkot me inenen sarawi, pwehki eh kisehn meirong me wiawihong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Ma mehn meirongo iei pilawa me umw, e pahn wiawihda sohte doal ihs. E kak mwomwen lopwon en pilawa doal lehn olip de ni mwomwen keik menipinip me lehn olip kohieng powe. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ma mehn meirongo iei pilawa me kuk nan mehn pirain, e pahn wiawihda sang ni pilawa doal lehn olip ahpw sohte doal ihs. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ke pahn pilitikihdi oh wudekihong leh powe, ni omw pahn wiahki mehn meirong. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ma mehn meirongo iei pilawa me kuk nan pan, e pahn wiawihda sang pilawa oh lehn olip. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Wahdo nin duwen meirong ehu ong KAUN-O oh kihong samworo, e ahpw pahn walahng pohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Samworo pahn kihsang ekis ni meirongo nin duwen kilel ehu me koaros meirongalahr ong KAUN-O, e ahpw pahn isikala pohn pei sarawio. Pwohn meirong en konot wet kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Luhwen mehn meirongo pahn kohieng samworo kan. E wia mehkot me inenen sarawi, pwehki eh kisehn meirong isihs me wiawihong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Meirong en wahn pilawa koaros me ke pahn wiahiong KAUN-O sohte pahn doal ihs; sohte ihs de sukehn loangalap pahn doadoahk ni meirong isihs me kin wiawihong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Wahn pilawa me aramas pahn kin tepin dolung nan sounpar koaros pahn wisikdohng rehn KAUN-O, ahpw e sohte pahn isihsla pohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Kihong soahl ni mehn meirong en wahn pilawa koaros, pwe soahl wehwehki inowo nanpwungen kumwail oh Koht. (Kihong soahl nan amwail mehn meirong koaros.) ");
INSERT INTO pon2006a_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ni omw pahn meirongkihong KAUN-O tepin wahn sapwomw koaros me ke pahn dolung, ke pahn meirongki wahn kohn kereng pohn kisiniei de kohn ngidar. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Kihong powe lehn olip oh warpwohmwahu. ");
INSERT INTO pon2006a_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Samworo ahpw pahn isikala warpwomwahu koaros iangahki ekis wahn kohno oh leho me pahn wia kilel ehu; nin duwen meirong en konot ehu ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Ma emen pahn wahdo nah kou pwehn wia meirong en kaminimin, e pahn kouwol de kou lih me sohte kisin samin kis reh. ");
INSERT INTO pon2006a_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Aramaso pahn kidahng peh pohn moangen kouo oh kemehla mwohn Impwal me KAUN-O kin ketiket loale. Samworo kan me kadaudok en Aaron ahpw pahn usupihki nta pali pahieu koaros en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Re ahpw pahn alehsang ni mahno wasa pwukat nin duwen meirong en konot ong KAUN-O: wih en kepwehn loale koaros, ");
INSERT INTO pon2006a_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","iangahki mwidihlik ko oh wihe ko oh wasa keieu mwahu en eho. ");
INSERT INTO pon2006a_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Samworo ko ahpw pahn isikala koaros pohn pei sarawio iangahki meirong isihs teikan. Pwohn meirong en konot wet kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Ma emen pahn wahdo sihpw men de kuht men pwe en wia meirong en kaminimin, e kak kuht wol de kuht lih me sohte kisin samin kis reh. ");
INSERT INTO pon2006a_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ma aramaso pahn meirongki sihpw men, ");
INSERT INTO pon2006a_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","e pahn kidahng peh pohn moangen mahno oh kemehla mwohn Impwalo. Samworo kan ahpw pahn usupihki nta pali pahieu koaros en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Re ahpw pahn alehsang ni mahno wasa pwukat nin duwen meirong en konot ong KAUN-O: Wihe, pwadaiki pwon pahn sapasang limwahn tihlapeo, oh wih koaros me patehng kepwehn loale kan, ");
INSERT INTO pon2006a_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","mwidihlik kan iangahki wihe kan oh wasa keieu mwahu en eho. ");
INSERT INTO pon2006a_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Samworo ahpw pahn isikala mepwukat koaros pohn pei sarawio nin duwen meirong en konot ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ma emen pahn meirongki kuht, ");
INSERT INTO pon2006a_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","e pahn kidahng peh pohn moangen kuhto oh kemehla mwohn Impwalo. Samworo kan ahpw pahn usupihki nta pali pahieu koaros en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Re ahpw pahn alehsang ni mahno wasa pwukat nin duwen meirong en konot ong KAUN-O: wihe koaros en kepwehn loale, ");
INSERT INTO pon2006a_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","mwidihlik ko oh wihe ko, oh wasa keieu mwahu en eho. ");
INSERT INTO pon2006a_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Samworo ahpw pahn isikala mepwukat koaros pohn pei sarawio nin duwen meirong en konot me pahn kaparanda kupwur en KAUN-O. KAUN-O me sapwellimaniki wih koaros. ");
INSERT INTO pon2006a_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Sohte mehn Israel men pahn tungoale wih de nta; koasoandi poatopoat ehu met ong mehn Israel koaros oh kadaudokarail kan wasa koaros me re pahn kousoan ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","en padahkihong mehn Israel kan: ma mehmen pahn wiahda dihp oh kauwehla ehu sapwellimen KAUN-O kosonned akan ni eh depweikihla, e pahn kapwaiada koasoandi pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Ma Samworo Lapalap me dipadahr oh kahrehda aramas akan en pwukoakihdi dipeo, e pahn meirongkihong KAUN-O koupwul wol men me sohte kisin samin kis reh pwehn tomwki dipeo. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","E pahn wahdo koupwul wolo ni wenihmwen Impwalo, oh kidahng peh pohn moange, oh kemehla wasao mwohn silangin KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Samworo Lapalapo pahn ale ekis ntahn kouo oh wahlong nan Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","E ahpw pahn kaduh sendinpeh nan ntao oh usupihki mwohn kahdeng sarawio pahn pak isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Mwuri e pahn pil iriski ntao koden keimw en pei sarawien warpwohmwahwo me mi nan Impwalo. E ahpw pahn wudekihdiong luhwen ntao ni poahsoan en pei sarawien meirong isihs me mi ni wenihmwen Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","E pahn kihsang wih en kouo koaros, wih en kepwehn loale kan, ");
INSERT INTO pon2006a_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","mwudihlik ko oh wihe ko, oh wasa keieu mwahu en eho. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Samworo ahpw pahn ale wih pwukat oh isikala pohn pei sarawien meirong isihso, duwen me e wiahiongehr wih en mahn me kamalahr ni meirong en kaminimino. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","E pahn ale kilio, uduke koaros, moange, neh ko oh kepwehn loale, iangahki mwasahltik ko; ");
INSERT INTO pon2006a_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","eh pahn wahieila mepwukat koaros likin kahnimpwalo, wasa mwakelekel en kaudok me pehs kan kin lekdekla ie, e ahpw pahn isikala wasao pohn koasoakoasoak en tuwi ko. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Ma mehn Israel koaros me dipadahr oh kauwelahr kosonned ehu en KAUN-O ni ar depweikihla, ");
INSERT INTO pon2006a_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","eri ni dihpo eh dehdehdahr, mehn Israel koaruhsie pahn iang wahdo koupwul wol men pwehn wia ar meirong en dihp. Re pahn wadohng ni Impwalen KAUN-O; ");
INSERT INTO pon2006a_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","oh kaun akan en mehn Israel ahpw pahn kidahng pehrail kan pohn moangen kouo, oh mahno ahpw pahn kamakamala wasao. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Samworo Lapalapo ahpw pahn ale ekis ntao oh wahlong nan Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","E pahn kaduh sendinpeho nan ntao oh usupihki mwohn kahdengo pahn pak isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Mwuri e pahn iriski ntao koden keimw en pei sarawien warpwohmwahwo me mi nan Impwalo. E ahpw pahn wudekihdiong luhwen ntao ni poahsoan en pei sarawien meirong isihs me mi ni wenihmwen Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","E ahpw pahn ale wihe koaros oh isikala pohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","E pahn wiahiong kou menet duwehte me e wiahiong kouwol en meirong en dihpo. Ih duwen eh pahn wia meirong en tomwen dihp en aramas akan oh diparail kan ahpw pahn lapwada. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Mwuhr e pahn ale kouwolo oh wahla likin kahnimpwalo oh isikala ie, duwehte eh isikala kouwol me wia meirong en dipe kan. Ih met duwen meirong en tomw oh lapwadahn dipen aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ma kaun emen me wiahda dihp oh kauwehla ehu kosonned en KAUN-O ni eh depweikihla, ");
INSERT INTO pon2006a_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","eri, ni petehkpen dihp wet eh pahn wiawiher, eh pahn wahdo eh mehn meirong emen koupwul wol me sohte kisin samin kis reh. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","E pahn kidahng peh pohn moangen mahno oh kemehla paliepeng en pei sarawio, wasa me mahn akan me kin wia mehn meirong isihs kin kamakamala ie. Met iei meirong en lapwahda dihp. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Samworo pahn kaduh sendinpeh nan ntahn mahno oh iriski koden keimw en pei sarawio, e ahpw pahn wudekihdiong luhwen ntao ni poahsoan en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Mwuri e pahn isikala wihe koaros pohn pei sarawio, duwehte eh isikala wih en mahn me kamala ong meirong en kaminimino. Ih duwen met samworo eh pahn wia meirong en tomwki dipen kaun akan, oh dipeo ahpw pahn lapwada. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Ma emen aramas mwahl akan me wiahda dihp oh kauwehla ehu kosonned en KAUN-O ni eh depweikihla, ");
INSERT INTO pon2006a_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","eri, ni petehkpen dihp wet eh wiawiher, e pahn wahdo eh mehn meirong emen kuht lih me sohte kisin samin kis reh. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","E pahn kidahng peh pohn moangen mahno oh kemehla ni paliepeng en pei sarawio, wasa me mahn en wia meirong isihs kin kamala ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Samworo pahn kaduh sendinpeh nan ntahn mahno oh iriski koden keimw en pei sarawio, e ahpw pahn wudekihdiong luhwen ntao ni poahsoan en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","E pahn kihsang wihe koaros, duwehte eh kihsang wih en mahn me kamala ni meirong en kaminimino, oh isakala wiho pohn pei sarawio. Pwohn meirong wet kin kaparanda kupwur en KAUN-O. Ih duwen met samworo eh pahn wia meirong en dipen aramas, dihpo ahpw pahn lapwada. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Ma aramas emen pahn wahdo emen sihpw pwehn wia mehn meirong en dihp, e pahn sihpw lih men me sohte kisin samin kis reh. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","E pahn kidahng peh pohn moangen mahno oh kemehla ni paliepeng en pei sarawio, wasa me mahn en wia meirong isihs kin kamala ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Samworo pahn kaduh sendinpeh nan ntahn mahno oh iriski koden keimw en pei sarawio, e ahpw pahn wudekihdiong luhwen ntao ni poahsoan en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Mwuri e ahpw pahn kihsang wihe koaros, duwehte eh kihsang wih en sihpw me wia meirong en kaminimino, e ahpw pahn isikala pohn pei sarawio iangahki meirong en konot me kin kohieng KAUN-O. Ih duwen met samworo eh pahn wia meirong en dipen aramas, oh dipeo ahpw pahn lapwada. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Meirong en dihp pahn wiawi ni ahnsou pwukat. Ma mehmen pahn likwerdohng ni mwoalen kopwung pwehn wia sounkadehde, e ahpw kahng kasalehda mehkot me e kilangehr de rongehr, eri e pahn pwukoahkihdi dihp wet. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ma mehmen pahn depweikihla oh sairada mehkot me samin ong kaudok, me rasehng mahn mehla, eri e saminlahr oh dipikidahr ni ahnsou me e diaradahr dahme e wiadahro. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ma mehmen pahn depweikihla oh sairada samin en aramas sohte lipilipil, eri e saminlahr oh dipikidahr ni ahnsou me e diaradahr dahme e wiadahro. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ma mehmen pahn kahukihla mehkot sohte lipilipil, ni eh sohte nsenohki, eri e dipikidahr ni ahnsou me e diarada dahme e wiadahr. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Ni mehmen eh pahn wiahda dihp, e pahn sakarkihda dipeo ");
INSERT INTO pon2006a_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","oh patohwanohng KAUN-O sihpw lih men de kuht lih men pwehn wia eh meirong en tomwki dihp. Eri samworo pahn meirongki mahno pwehn lapwahda dipen aramaso. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Ma aramas emen sohte kak meirongki sihpw de kuht, e pahn patohwandohng KAUN-O mwuroi riemen de pitsin riemen pwehn wia meirong en tomwen dipeo, emen mwuroio pahn wia meirong en dipe a emen pahn wia meirong isihs. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","E pahn wadohng samworo menpihr pwukat, samworo ahpw pahn wia mahs meirong en dihp. E pahn pirer tepinweren menpihro ahpw e sohte pahn dolsang moange, ");
INSERT INTO pon2006a_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","oh usupihki ekis ntao pengepengen pei sarawio. E ahpw pahn wudekihdiong luhwen ntao ni poahsoan en pei sarawio. Iei met meirong en dihp. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Mwuri e pahn meirongkihla keriemen en menpihro pwehn wia meirong isihs nin duwen me koasoandier. Ih duwen met samworo eh pahn wia meirong en tomwki dipen aramaso; dipeo ahpw pahn lapwada. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Ma aramas emen sohte kak meirongki mwuroi riemen de pitsin riemen, e pahn wahdo paun riau en pilawa mehn wia meirong en dihp. E sohte pahn kihong powe lehn olip de warpwohmwahu, pwehki meirong en dihp met, kaidehkin meirong en wahnsahpw. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","E pahn wadohng rehn samworo pwehn kihsang ehu oaroahr en pilawao, nin duwen kilel ehu me koaros meirongalahr ong KAUN-O, e ahpw pahn isikala pohn pei sarawio nin duwen meirong en konot. Met iei meirong en dihp. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ih duwen met samworo eh pahn wia meirong en tomwki dipen aramaso; dipeo ahpw pahn lapwada. Luhwen pilawao pahn kohieng samworo duwehte meirong en wahnsahpw. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","KAUN-O ketikihong Moses koasoandi pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Mehmen me pahn depweikihla oh wiahda dihp, pwehki eh sohte patohwando meirong kan me kasarawihong KAUN-O, e pahn patohwandohng KAUN-O sihpw wol de kuht wol men me sohte kisin samin kis reh pwehn wia eh meirong en kapwungala. Pweinen mahno pahn mihmi ni uwe ieu me koasoandier. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Aramaso pahn kapwungala dahme e sohte patohwandao, e pahn pil kapatahiong persent rieisek oh kihong samworo. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Ma mehmen dipada ni eh depweikihla oh kauwehla ehu kosonned en KAUN-O, e pahn dipaniki oh pwukoahki dipeo. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","E pahn wadohng samworo sihpw wol de kuht wol men me sohte kisin samin kis reh pwehn wia eh meirong en kapwungala. Pweinen mahno pahn mihmi ni uwe ieu me koasoandier. Samworo ahpw pahn wiahda meirong en tomwen dihp me aramaso depweikilahr, dipeo ahpw pahn lapwada. ");
INSERT INTO pon2006a_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ih met meirong en kapwungala dihp me aramaso wiahiong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","KAUN-O ketikihong Moses koasoandi pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Aramas emen pahn patohwanda eh meirong ma e wiahda dihp ong KAUN-O ni eh kahng kapwurehiong mehkot me rie mehn Israel men likihong, de ni eh pirapahsang de pitihasang mehkot, ");
INSERT INTO pon2006a_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","de lokaia likamwki mehkot me pwupwula ni eh kahukihla me e sohte diarada. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","Ma aramas emen pahn dipikihda ehu dihp pwukat, e pahn kapwungala dipwisowo pwehki eh wiahda likamw. Ni rahn me dipeo pahn dehdedahr, e pahn kapwurehiong dipwisou ko koaros rehn rie mehn Israelo oh pil kapatahiong persent rieisek. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","E ahpw pahn wadohng samworo sihpw wol de kuht wol men me sohte kisin samin kis reh pwehn wia eh meirong en kapwungala ong KAUN-O. Pweinen mahno pahn mihmi ni uwen me koasoandier. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Samworo ahpw pahn meirongkihla pwehn wia meirong en dipen aramaso, dipeo ahpw pahn lapwada. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","en padahkihong Aaron oh nah pwutak ko koasoandi pwukat duwen meirong isihs kan. Meirong isihs pahn mihmihte pohn pei sarawio erein pwohng ehu pwon, oh kisineio pahn lullulte. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Eri samworo me likawih likou linen reirei oh rausis linen pahn kihsang pehs ko pohn pei sarawio oh kihdiong ni pengepengen pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Mwuri e pahn wilian eh likou ko oh ale pehs ko walahng likin kahnimpwalo wasa kis me mwakelekel ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Kisiniei pohn pei sarawio pahn lullulte, sohte pahn koakunla. Nimenseng koaros samworo pahn kin kihong tuwi oh koasoanehdi meirong isihso powe, oh isikala wih en meirong en kaminimino. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Kisinieio pahn kin lullulte ahnsou koaros pohn pei sarawio, oh sohte pahn koakunla. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Iet duwen koasoandi kan me pid meirong en wahnsahpw. Emen samworo me kadaudok en Aaron pahn patohwandahng KAUN-O meirong en wahnsahpw mwohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","E ahpw pahn ale ekis oaroahr en pilawao oh leh, iangahki warpwohmwahu me mi powe, e ahpw pahn isikala pohn pei sarawio nin duwen kilel ehu me koaros meirongalahr ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","17","Samworo pahn tungoale luhwen pilawao. Re pahn wiahkihda pilawa umw me sohte doal ihs oh tungoale nan wasa sarawi ehu, nan kelen Impwal me KAUN-O kin ketiket loale. KAUN-O ketikihongehr samworo ko meirong wet pwe en wia kisehn ar meirong en konot. Meirong wet me inenen sarawi, duwehte meirong en dihp oh meirong en kapwungala. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Erein dih koaros kohkohlahte kadaudok en Aaron ohl koaros kak tungoale pilawa wet pwe pweisarail sang ni mwenge me meirongalahr ong KAUN-O. Mehmen sohte lipilipil me pahn sair meirong en konot ehu pahn ohla pwehki meirongo me sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","KAUN-O ketikihong Moses koasoandi pwukat ");
INSERT INTO pon2006a_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","me pid kesepwildahn emen samworo me kadaudok en Aaron. Ni rahn me e pahn sepwilda, e pahn meirongkihong KAUN-O paun en pilawa riau (duwehte mehn meirong en wahnsahpw en rahn koaros), elep nimenseng oh elep nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Pilawa wet pahn doal leh oh kuk pohn mehn prain. Mwuri e ahpw pahn pilitikihdi oh meirongki duwehte meirong en wahnsahpw me pwowe kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Kadaudok en Aaron koaros me pahn wia doadoahk en Samworo Lapalap pahn wia meirong wet erein dih koaros kohkohlahte. Re pahn isikala koaruhsie nin duwen meirong ehu ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Sohte emen pahn tungoale mehkot sang ni meirong en wahnsahpw me samworo emen pahn meirongki, koaruhsie pahn isihsla. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","en padahkihong Aaron oh nah pwutak ko koasoandi pwukat me pid meirong en dihp. Mahn me pahn wia mehn meirong en dihp, pahn kamakamala ni paliepeng en pei sarawio, wasa me mahn en meirong isihs kin kamala ie. Meirong wet me inenen sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Samworo me meirongkihla mahno pahn tungoale uduke nan wasa sarawi ehu, nan kelen Impwalen KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Mehmen de mehkot me pahn sair uduk en mahno, pahn ohla pwehki mahno me sarawi. Ma ntahn mahno kohieng ni likou ehu, likowo pahn lopwolopw nan wasa sarawi ehu. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ma re pwoailih uduko nan einpwoat me wiawihkida pwehl, re pahn kauwehla einpwoato. Ma re pwoailih uduko nan einpwoat mete, re pahn irisada oh udenki pihl. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ohl koaros en peneinei en samworo kak iang tungoale mehn meirong wet; meirong wet me inenen sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ahpw ma re pahn patohwanla ntahn mahno nan Impwalo pwe re en doadoahngki ni sarawien meirong en tomwki dihp, sohte me pahn tungoale uduk en mahno; re pahn isikala. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Iet koasoandi kan me pid meirong en kapwungala sapwung kan, me inenen sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Re pahn kemehla mahn en meirong wet ni paliepeng en pei sarawio, wasa me mahn en meirong isihs kan kin kamala ie, re ahpw pahn wudekihdiong ntao ni pali pahieu en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Re pahn kihsang wihe koaros oh meirongkihla pohn pei sarawio: wih en pwadaiki, wih en kepwehn loale ko, ");
INSERT INTO pon2006a_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","mwidihlik ko iangahki wih en wasa keieu mwahu en eho. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Samworo pahn isikala wih koaros pohn pei sarawio nin duwen meirong en konot ehu ong KAUN-O. Iei met meirong en kapwungala. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ohl koaros me peneinei en samworo kak iang tungoale meirong wet, ahpw re pahn kin tungoale nan wasa sarawi ehu, pwe met iei mehkot me inenen sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Mie koasoandi ehu me pid meirong en dihp oh pil meirong en kapwungala: uduk en mahno pahn kohieng pweisen samworo me wia meirongo, ");
INSERT INTO pon2006a_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","kilin mahn me wia meirong isihs pahn kohieng pweisen samworo me wia meirong isihso. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Meirong en wahnsahpw koaros me umw de kuk nan pan, de nan mehn prain, pahn kohieng pweisen samworo me wia meirongo ong Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ahpw mehn meirong en wahnsahpw koaros me amas, mehnda ma doal ihs de madekeng, iei pweisen samworo koaros me kadaudok en Aaron; met pahn nehne pahrek nanpwungarail. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Iet koasoandi kan me pid meirong en kaminimin ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ma aramas emen pahn wia meirong wet pwe eh tungoal kapingkalahngan ong KAUN-O, e pahn wahdo iangahki mahn en meirongo, pilawa me sohte doal ihs: ekei lopwon en pilawa doal lehn olip de keik menipinip me lehn olip kohieng ie de keik me pilawa wiahda me doal lehn olip. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","E pahn pil kapatahiong ekei lopwon en pilawa me doal ihs. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","E pahn kihsang ni ehuehu soangen pilawa pwukat mehn wia eh kisakis tohrohr ehu ong KAUN-O; eri met pahn kohieng pweisen samworo me wudekihdiong ntahn mahno pohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Re pahn tungoale uduk en mahno ni rahnohte me re wia meirongo; sohte mehkot luhwehdi pahn nekinekla ong nimenseng en mandahn rahno. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ma emen pahn wahdo mehn meirong en kaminimin pwehn kapwaiada eh inou de sang ni pein nsene, e pahn tungoale ni rahn me e wia meirongo; ahpw ma mie luhwe, e kak pil tungoale mandahn rahno. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ma mie luhwen uduko ni kasiluhn rahno, e pahn isihsla. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ma aramaso tungoale uduko ni kesiluhn rahn, Koht sohte pahn kupwurperenki eh meirongo. Aramaso sohte pahn ale kapaipen eh meirong pwe e saminlahr. Eri mehmen me pahn tungoale pahn pwukoahki ale lokolok en dipe. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Ma mehkot samin ong kaudok pahn sair uduko, sohte me pahn tungoale; e pahn isihsla. Mehmen me mwakelekel ong kaudok kak tungoale uduko; ");
INSERT INTO pon2006a_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ahpw ma emen me samin pahn tungoale, e sohlahr pahn wia kisehn sapwellimen Koht aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Pil ehu, ma mehmen pahn tungoale uduk en meirong wet mwurin eh sair mehkot me samin ong kaudok, mehnda ma sang rehn aramas de mahn, eri e solahr pahn wia kisehn sapwellimen Koht aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","KAUN-O ketikihong Moses koasoandi pwukat ");
INSERT INTO pon2006a_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","pwe en padahkihong mehn Israel kan. Sohte me pahn tungoale wih en kou de sihpw de kuht. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Sohte me pahn tungoale wih en mahn me mehla mwahl de mahn lawalo kemehla, ahpw e kak wiahki ehu soangen doadoahk tohrohr. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Mehmen me pahn tungoale wih en mahn me pahn wia mehn meirong en konot ong KAUN-O solahr pahn wia kisehn sapwellimen Koht aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Mehn Israel kan sohte pahn tungoale ntahn menpihr de ntahn mahn wasa koaros me re pahn kousoan ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Mehmen me pahn kauwehla kosonned wet solahr pahn wia kisehn sapwellimen Koht aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","KAUN-O ketikihong Moses koasoandi pwukat ");
INSERT INTO pon2006a_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","pwe en padahkihong mehn Israel kan. Mehmen me pahn wia eh meirong en kaminimin pahn patohwando ekis pwe en wia eh kisakis tohrohr ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Pein ih pahn patohwando nan peh nin duwen meirong en konot. E pahn patohwando wih en mahno iangahki mwaremware pwehn wia eh kisakis tohrohr ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Samworo pahn isikala wih ko pohn pei sarawio, oh mwaremwareo pahn kohieng pweisen samworo ko. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Aramaso pahn patohwanda palimaun en nehn mahno pwehn wia eh kisakis tohrohr ");
INSERT INTO pon2006a_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ong samworo me kin wia meirong en nta oh wih mehn meirong en kaminimin. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Mwaremwar en mahno, iei kisakis tohrohr ehu, oh palimaun en nehn mahno iei kisakis tohrohr me KAUN-O ketikihsangehr mehn Israel oh ketikihongehr samworo kan. Ih met me mehn Israel kan pahn kin patohwanohng samworo kan erein dih koaros kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Iei met pweisen Aaron oh nah pwutak kan sang ni meirong isihs ong KAUN-O ni rahn me re sepwildahng doadoahk en samworo. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ni rahno me KAUN-O mahsanihong mehn Israel kan re en patohwanohng irail pwais wet sang ni meirongo. Met iei koasoandi ehu me mehn Israel kan pahn kapwaiada erein dih koaros kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Eri ih koasoandi pwukat me pid meirong isihs, meirong en wahnsahpw, meirong en dihp, meirong en kapwungala, meirong en kesepwilda, oh meirong en kaminimin. ");
INSERT INTO pon2006a_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","KAUN-O ketikihong Moses koasoandi pwukat pohn Nahna Sainai ni rahn me e patohwanohng mehn Israel kan re en patohwanda arail meirong kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Ekerodo Aaron oh nah pwutak ko ni wenihmwen ei Impwalo, kowe eri wahdo likoun samworo kan, leh sarawio, kouwol mehn meirong en dihp, sihpw wol riemen oh kopwoun pilawa sohte doal ihs. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Kowe eri kapokonepene mehn Israel koaros wasao.” ");
INSERT INTO pon2006a_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moses eri kapwaiada me KAUN-O ketin mahsanihong. Eri ni mehn Israel ko ar pokonpenehr, ");
INSERT INTO pon2006a_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moses ahpw patohwanohng irail, “Met I pahn wia dahme KAUN-O ketin mahsanih I en wia.” ");
INSERT INTO pon2006a_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moses eri kahrehdahla Aaron oh nah pwutak ko mwohrail oh kamwakelekinirailda pihl. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","E ahpw kalikawihkihda Aaron sehto oh likou reireio oh pirekipene lukepeo katengo. E ahpw kidahng ihpod powe oh pirekipene lukepeo kateng deiad. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","E ahpw pil kihong perehpen mwaremware, oh kihong loale Urim oh Dumim ");
INSERT INTO pon2006a_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","E ahpw patohwandahng lisoarop likou pohn moange oh kihong mwohn lisoaropo kapwat kohl ehu, iei kilel sarawi ehu me e kasarawilahr, duwen KAUN-O eh ketin mahsanihong. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Moses ahpw ale leh sarawio oh kieldiong ni Impwalen KAUN-O iangahki dipwisawi kan koaros. Ih duwen met soahng koaros eh kasarawilahr ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","E ahpw usupihki leh sarawio pak isuh pohn pei sarawio oh dipwisawi kan, oh pil iangahki peisino oh kapio. Ih duwen met eh pil kasarawihong KAUN-O mepwukat. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","E ahpw kasapwilada Aaron ni eh kieldiong pohn moange leh sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Mwuhr, e ahpw kahrehdahla nein Aaron pwutak ko, oh kalikawihkinirailda seht ko, oh pirekipene lukeparail kan kateng deiad oh pil patohwandahng lisoarop ko pohn moangarail nin duwen KAUN-O eh ketin mahsanihong. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Mwuri Moses ahpw patohwando kouwol pwulo mehn meirong en dihp. Aaron oh nah pwutak ko ahpw kidahng pehrail ko pohn moangen kouo. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Moses eri kemehla kouo oh kaduh sendinpeh nan ntah oh iriski koden keimw pahieu en pei sarawio pwehn kasarawihala. E ahpw wudekihdiong luwen ntahn mahno ni poahsoan en pei sarawio. Ih duwen met eh kamwakelehda oh kasarawihala pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Moses ahpw ale wih koaros en kepwehn loale, wasa keieu mwahu en eho, mwidihlik oh wihe ko, oh isikala koaros pohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","A luhwen mahno iangahki kilio, udukeo, oh kepwehn loale, e wahieila likin kahnimpwalo oh isikala, nin duwen KAUN-O eh ketin mahsanihong. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Mwuhr, Moses pil ale sihpw wol mehn meirong isihs, Aaron oh nah pwutak ko ahpw pil kidahng pehrail ko pohn moangen sihpwo. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","E ahpw kemehla oh usupihki ntao ni pengepenge pahieu koaros en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","E ahpw saptikihdi sihpwo oh kamwakelehda kepwehn loale kan oh neh ko oh isikala moangeo, iangahki wihe oh luhwen sihpwo pohn pei sarawio, nin duwen KAUN-O eh ketin mahsanihong. Meirong isihs wet iei meirong en konot, oh pwowe kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Moses pil ale keriemen en sihpwo, mehn wia kasarawien kesepwildahn samworo kan, Aaron oh nah pwutak ko eri kidahng pehrail ko pohn moangen mahno. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moses eri kemehla oh ale ekis ntao oh iriski palimaun en imwin salengen Aaron, palimaun en sendilap en peh, oh palimaun en sendilap en neho. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","E pil wiahiong soahngohte nein Aaron pwutak ko. E ahpw wudekihdiong luhwen ntao ni pengepenge pahieu en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","E ale wih en mahno, wih en pwadaiki, wih en kepwehn loale, wasa keieu mwahu en eho, wih en mwidihlik ko oh palimaun en neho. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","E ahpw ale sang nan kopwou ehu lopwon en pilawa me sohte doal ihs me kasarawihongehr KAUN-O, ehu lopwon en pilawa doal leh, oh ehu keik menipinip, e ahpw kihdiong mepwukat pohn wih ko oh pohn palimaun en nehn mahno. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","E ahpw kihong mwenge mepwukat koaros nan pehn Aaron oh nah pwutak ko, pwe re en patohwandahng KAUN-O nin duwen ar kisakis tohrohr. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Moses pil pwurehng ale sang rehrail mwenge pwukat oh isikala pohn meirong isihso me mi pohn pei sarawio, nin duwen meirong en kasapwilada samworo. Iei met meirong en konot ehu, oh pwowe kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moses eri ale mwaremwaren mahno oh patohwandahng KAUN-O nin duwen kisakis tohrohr ehu. Ih met pweisen Moses sang ni sihpw wolo me wia mehn meirong en kasapwilada samworo. Moses wiadahr mekoaros me KAUN-O ketin mahsanihong. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moses eri ale ekis leh sarawio oh ekis ntahn mahno me mi pohn pei sarawio, oh usipihki Aaron oh nah pwutak ko oh pil ar likou kan. Ih duwen met eh kasarawihirailla iangahki ar likou kan ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moses patohwanohng Aaron oh nah pwutak ko, “Kumwail ale uduken mahn en oh wahla mwohn wenihmwen Impwal me KAUN-O kin ketiket loale oh pwoailihada oh tungoale wasao iangahki pilawa me mi nan kopwoun meirong en kasapwilada samworo nin duwen KAUN-O eh ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Kumwail eri isikala uduk oh pilawa me luhwe. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Erein rahn isuh kumwail sohte pahn kohkohsang ni wenihmwen Impwalo, lao amwail kasarawien kesepwilda pahn imwisekla. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","KAUN-O ketin mahsanihong kiht, se en wiahda dahme se patohwan wiahier rahnwet, pwe dipamwail kan en lapwada. ");
INSERT INTO pon2006a_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Kumwail pahn mihmihte nipwong oh ni rahn erein rahn isuh ni wenihmwen Impwalo, wiewia dahme KAUN-O ketin mahsanihong kumwail. Ma kumwail sohte pahn kapwaiada met, kumwail pahn mehla. Ih met me KAUN-O ketin mahsanihong ie.” ");
INSERT INTO pon2006a_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aaron oh nah pwutak ko eri kapwaiada mehkoaros me KAUN-O ketin mahsanihong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ni rahn mwurin kasarawihpen kesepwildao eh imwiseklahr, Moses ahpw ekerodo Aaron oh nah pwutak ko, iangahki kaunen mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","E ahpw patohwanohng Aaron, “Ale emen kouwol pwul oh emen sihpw wol me sohte kisin samin kis rehra oh meirongkihong KAUN-O, kouwolo pahn wia mehn meirong en dihp oh sihpw wolo pahn wia mehn meirong isihs. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ke pahn pil ndaiong mehn Israel kan re en wahdo emen kuht wol mehn wia meirong en dihp, emen kouwol me mahki sounpar ehu, oh emen sihmpwul me pil mahki sounpar ehu me sohte kisin samin kis reh, mahn pwukat pahn wia mehn meirong isihs, ");
INSERT INTO pon2006a_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","oh pil emen kouwol oh emen sihpw wol mehn wia meirong en kaminimin. Irail en meirongkihong KAUN-O mahn pwukat koaros iangahki meirong en wahnsahpw me doal leh. Re pahn wia met pwe KAUN-O pahn ketin pwarohng irail rahnwet.’” ");
INSERT INTO pon2006a_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Irail eri wapene mwohn wenihmwen Impwalo mehkoaros me Moses patohwanohng irail oh pokon en mehn Israel ko ahpw patopene wasao pwe re en kaudokiong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moses ahpw patohwanohng irail, “KAUN-O ketin mahsanihong kumwail en wia met, pwe sapwellime lingaling en pwarohng kumwail.” ");
INSERT INTO pon2006a_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Ih eri patohwanohng Aaron, “Kohwei ni pei sarawio oh wiahda meirong en dihp oh meirong isihs pwehn wia lapwepen dipomw kan oh dipen aramas akan, ke pahn wia meirong wet pwe dipen aramas akan en lapwada, nin duwen KAUN-O eh ketin mahsanih.” ");
INSERT INTO pon2006a_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aaron eri patohla ni pei sarawio oh kemehla koupwul wol men mehn wia meirong en dipe. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Nah pwutak ko ahpw patohwandohng ntahn kouo, ih eri kaduh sendinpeh nan ntao oh iriski koden keimw pahieu en pei sarawio oh wudekihdiong luhwen ntao ni poahsoan en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Mwuri e ahpw isikala wih en mahno pohn pei sarawio, iangahki mwidihlik ko oh wasa keieu mwahu en eho, nin duwen KAUN-O eh ketin mahsanihong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ahpw udukeo oh kilio e isikala likin kahnimpwalo. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Aaron pil kemehla mahn me wia eh meirong isihs. Nah pwutak ko pil patohwandohng ntao, e ahpw wudekihdiong ni pengepenge pahieu koaros en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Irail pil kihong moangeo oh wasa teikan en mahno, e ahpw isikala pohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Mwuri e kamwakelehda kepwehn loale kan oh neh ko, oh isikala pohn meirong isihso me mi pohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Mwurin mepwukat e ahpw patohwanda en aramas ako ar meirong. E ale kuht mehn wia meirong en dipen aramas ako oh kemehla. E ahpw meirongki duwehte me e wiahiong eh mehn meirong en dipeo. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","E pil ale; mahno mehn wia meirong isihs oh meirongkihla nin duwen kosonnedo. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","E patohwanda meirong en wahnsahpw wet, e ale oaroahr en pilawa ehu oh isikala pohn pei sarawio. (Met kin patehng meirong isihs en rahn koaros.) ");
INSERT INTO pon2006a_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","E kemehla kouwolo oh sihpw wolo pwehn wia meirong en kaminimin en aramas akan. Nah pwutak ko patohwandohng ntao, e ahpw wudekihdiong ni pengepenge pahieu koaros en pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Aaron ahpw kihong wih en kouwolo oh sihpw wolo ");
INSERT INTO pon2006a_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","pohn mwaremwaren mahn ako oh wahla koaros pohn pei sarawio. E ahpw isikala wih ko pohn pei sarawio, ");
INSERT INTO pon2006a_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","oh patohwandohng pweisen samworo kan mwaremwar ko oh neh palimaun kan nin duwen kisakis tohrohr ehu ong KAUN-O, nin duwen me Moses koasoanehdi. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ni Aaron eh kaimwisekala meirong koaros, e ahpw patohwanda peh ko pohn aramas koaros oh kupwuramwahwihirailla. E ahpw patohdi sang wasao. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moses oh Aaron ahpw patohlongala nan Impwalen KAUN-O. Ni ara pwureisang loale, ira ahpw kupwuramwahwih aramas ako. Lingaling en KAUN-O ahpw pwarada mwohn aramas ako koaros. ");
INSERT INTO pon2006a_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","KAUN-O eri mwadangete kadarala kisiniei oh isikala meirong isihso oh luhwen wih ko me mi pohn pei sarawio. Ni aramas ako ar kilangada irair wet, koaruhsie ahpw weriwer oh poaridiong nanpwel. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nein Aaron pwutak ko, Nadap oh Apihu, ira ale neira pan en kisiniei ko, audehkihda mwoalus oh kihong warpwohmwahu loale, oh patohwandahng KAUN-O. Ahpw kisinieio sohte sarawi, pwe KAUN-O sohte ketin mahsanih ira en wia. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","KAUN-O ahpw mwadangete kadarala kisiniei oh isikirahla, ira eri mehla wasao mwohn silangin KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Moses eri patohwanohng Aaron, “Ih duwen kupwur en KAUN-O met, ni eh ketin mahsanih, ‘Koaros me kin papah ie pahn wauneki ei sarawi; I ahpw pahn kasalehiong nei aramas akan ei lingan.’” Aaron ahpw nenenlahte sohte mwekid. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moses eri ekerodo Misael oh Elsapahn, nein Ussiel, ullap en Aaron, oh patohwanohng ira, “Kumwa menlao patohdo oh patohwansang paliweren riamwa ko ni Impwal sarawio oh wahieilahng likin kahnimpwalo.” ");
INSERT INTO pon2006a_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ira eri patohla oh ale ira nan ara mihmihte nan ara likoun samworo, oh wahieilahng likin kahnimpwalo, nin duwen Moses eh patohwanohng ira. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Moses ahpw patohwanohng Aaron oh nah pwutak ko Eleasar oh Idamar, “Kumwail dehpa kapingada pitenmoangamwail kan de tehrpeseng amwail likou kan pwehn kasalehda amwail nsensuwed. Ma kumwail pahn wia met, kumwail pahn mehla oh KAUN-O pahn pil ketin engiengda pahn aramas koaros; ahpw riamwail mehn Israel koaros kak mwahieiki riamwail ko me sapwellimen KAUN-O kisiniei kemelahr. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Kumwail dehr kohieiweisang ni wenihmwen Impwalo pwe kumwail dehr mehla; pwe kumwail kasarawihkilahr leh sarawien KAUN-O.” Irail eri kapwaiada dahme Moses patohwanohng irail. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","KAUN-O ketin mahsanihong Aaron, ");
INSERT INTO pon2006a_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Kowe oh noumw pwutak kan sohte pahn pedolong nan ei Impwalo mwurin amwail pahn kin nim wain de pihru; ma kumwail pahn wia met, kumwail pahn mehla. Kosonned ehu met me kadaudokamwail koaros pahn kin iang kapwaiada. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Kumwail en kin katohrepeseng dahme sapwellimen Koht oh dahme soh, dahme mwakelekel ong kaudok oh dahme samin. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Kumwail pahn padahkihong mehn Israel koaros kosonned koaros me KAUN-O ketikihong Moses pwehn padahkihong kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moses eri patohwanohng Aaron oh nah pwutak riemen me luhwehdi ko, Eleasar oh Idamar, “Kumwa ale meirong en wahnsahpw me luhwehdi kan sang ni meirong en konot me wiawihongehr KAUN-O, kumwa ahpw wiahkihda pilawa me sohte doal ihs oh tungoale limwahn pei sarawio, pwehki meirong wet me inenen sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Kumwail tungoale nan ehu wasa sarawi. Ih pwaisamwail met oh pweisen noumwail pwutak kan sang ni meirong en konot me wiawihongehr KAUN-O. Ih met me KAUN-O ketin mahsanihohg ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ahpw kumwail oh noumwail pwutak kan oh serepein kan pahn iang tungoale mwaremware oh nehn mahn me meirongalahr ong KAUN-O nin duwen kisakis tohrohr ehu ong KAUN-O oh pwais tohrohr ong samworo kan. Kumwail pahn tungoale nan wasa mwakelekel ong kaudok. Pwe meirong pwukat kohieng kumwail oh noumwail seri kan pwe en wia pwaisamwail sang ni meirong en kaminimin en mehn Israel kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Nehn mahn en meirongo oh mwaremwareo pahn wisikdo ni ahnsou me wiho pahn meirongala nin duwen meirong isihs ong KAUN-O. Re ahpw pahn wiahla pwaisamwail oh pweisen noumwail seri kan kohkohlahte, nin duwen KAUN-O eh ketin mahsanih.” ");
INSERT INTO pon2006a_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moses eri idekda kuhto, mehn wia meirong en dihp. E ahpw diarada me e isihslahr. E ahpw lingeringerda pahn nein Aaron pwutak ko, Eleasar oh Idamar, e ahpw patohwanohng ira, ");
INSERT INTO pon2006a_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Dahme kumwa sohte tungoalehki meirong en dihpo nan wasa sarawi ehu? Pwe met mehkot me inenen sarawi, oh KAUN-O ketikihong kumwa pwehn lapwahda dipen aramas akan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Pwehki ntao eh sohte wisiklong nan Impwal sarawio, kumwa uhdahn pahn tungoalehla meirongo wasao, duwen me I koasoanedier.” ");
INSERT INTO pon2006a_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaron ahpw sapeng Moses patohwan, “Ia duwe, ma I tungoalehla mehn meirong en dihpo rahnwet, KAUN-O pahn kupwur perenki? Aramas akan wahdo ar mehn meirong en dihp rahnwet oh ar mehn meirong isihs, ahpw me suwed pwukat pil wiawihong ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Ni Moses eh rongada met, e ahpw perenkihda. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","KAUN-O ketikihong Moses oh Aaron koasoandi pwukat, ");
INSERT INTO pon2006a_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","pwe ira en padahkihong mehn Israel kan. Kumwail kak tungoale mahn en nansapw koaros ");
INSERT INTO pon2006a_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","me kikin nehrail kan pwalpeseng oh me kin rukoa kanarail kisin mwenge, ");
INSERT INTO pon2006a_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","ahpw kumwail sohte pahn tungoale uduk en kamel, rak padser, de uduken rapit. Mahn pwukat pahn iang wadawadohng mehkot me samin—re kin rukoa kanarail kisin mwenge ahpw kikin nehrail kan sohte pwalpeseng. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Kumwail sohte pahn tungoale uduken pwihk—en wadawadohng mehkot me samin—kikirail kan pwalpeseng ahpw re sohte kin rukoa kanarail kisin mwenge. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Kumwail dehr tungoale uduken mahn pwukat de sair ni ar melahr; re me samin. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Kumwail kak tungoale soangen mwahmw koaros me mie sikarail oh wunarail, ");
INSERT INTO pon2006a_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ahpw mwahmw men me kin mihmi nan pihl, nansed de nan pillap, me sohte sike oh wune, kumwail sohte pahn tungoale. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Soangen mwahmw pwukat pahn iang wadawadohng mehkot me samin. Kumwail dehr tungoale de sair ni ar melahr. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Kumwail dehr tungoale mwahmw men me kin mihmi nansed de nan pihl me sohte sike oh wune. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","Kumwail sohte pahn tungoale uduken soangen menpihr pwukat: ikel, likoht, oahk, palkon, pwusards, puldur, krow, ostris; paret, sidoahk, kewelik, pelikan, kormorant; uhpoahs de pwehk. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Kisin mensiek koaros me mie arail pehnpihr, re me samin, ");
INSERT INTO pon2006a_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ihte me mwakelekel, me kin lusulus kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Kumwail kak tungoale loukust, kutohrenpil de mensiek. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ahpw meteikan koaros me mie arail pehnpihr ahpw kin kerep nanpwel, re en wadawadohng mehkot me samin. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","Mehmen me sairada soangen mahn pwukat me mehla pahn saminla lao lel nin soutik: eri mahn koaros me mie kikin pehrail me sohte kasangpeseng oh kin rukoa kanarail kisin mwenge oh mahn koaros me kin aluhki neh oh peh me kumwut kasang. Mehmen me pahn wahda mahn pwukat ni ar melahr, e pahn kamwakelehda eh likou kan, oh e pahn kin saminkihla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","Moul, kitik, lamwer, oh kieihl kan pahn wadawadohng mehkot me samin. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Mehmen me sairada mahn pwukat me mehla, pahn saminla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Oh ma mahn pwukat pahn pwupwudiong pohn mehkot ni ar melahr, eri mehkot me e pwupwudiong poweo pahn saminla. Eri mehkot me aramas kin doadoahngki rasehng tuhke, likou, kilin kou de tehnied. Dipwisowo pahn koaduhdi nan pihl ahpw e pahn samin lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ma mahn pwukat pahn pwupwudiong nan einpwoat ni ar melahr, mehkoaros loale pahn saminla oh kumwail pahn kauwehla einpwoato. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Kisin tungoal koaros me pilen einpwoato wudekiong powe pahn saminla oh mehkoaros me aramas pahn nimasang nan einpwoato me samin. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Mehkot me mahn mehla pwukat pwupwudiong powe pahn saminla; ma sidohp me wiawihkihda pwehl kumwail pahn kauwehla sidohpo, ");
INSERT INTO pon2006a_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ahpw ma pwarer ehu de sistern ehu e pahn wie mwakmwakelekelte, mehnda ma mehkot me sairada mahn mehla ko wiahla mehkot samin. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ma emen mahn mehla ko pahn pwupwudiong pohn werentuhkehn poad, werentuhkeo sohte pahn saminkihla. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ahpw ma werentuhkeo wie kelekelemwur nan pihl oh mahn mehlao ahpw pwupwudiong powe, e pahn saminla. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Ma mahn emen me kumwail kak tungoale pahn mehla, mehmen me pahn sairada, e pahn saminla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Oh mehmen me pahn tungoale ekis uduken mahno, e pahn kamwakelehda eh likou kan, ahpw e pahn saminla lao lel nin soutik; mehmen me wahda mahn mehlao pahn kamwakelehda eh likou kan, ahpw e pahn saminla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Kumwail sohte pahn tungoale mahn tikitik men me kin limwahdek nanpwel. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Mehnda ma e kin kerep de aluhki neh pahieu de neh tohto. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Kumwail dehr kasaminehkinkumwailla ni amwail pahn tungoale soangen mahn pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ngehi KAUN-O, amwail Koht; kumwail eri pahn sarawihla, pwehki ngehi me sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ngehi KAUN-O, me kahreikumwaildo sang Isip pwe I en wiahla amwail Koht. Eri kumwail pahn sarawihla pwehki ngehi me sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Ih met kosonned me pid duwen mahn akan oh menpihr kan, duwen mehkoaros me kin mi nansed de nan pihl oh mehkoaros me kin limwahdek nanpwel. ");
INSERT INTO pon2006a_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Kumwail pahn kanahieng katohrepeseng me mwakelekel oh me samin kan, mahn akan me kumwail kak tungoale oh sohte kak tungoale. ");
INSERT INTO pon2006a_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","KAUN-O ketikihong Moses koasoandi pwukat, ");
INSERT INTO pon2006a_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","pwe en padahkihong mehn Israel kan. Lih emen me pahn kaipwidi kisin pwutak pahn saminla ong kaudok erein rahn isuh, duwehte eh kin saminkihla eh soumwahu en lih. ");
INSERT INTO pon2006a_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ni kawaluhn rahn serio pahn sirkumsaisla. ");
INSERT INTO pon2006a_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Eri erein rahn silihsek siluh mwurin liho eh pahn kin saminkihla pwilipwil en nta; e sohte pahn sair mehkot me sarawi de pedolong nan Impwal sarawio, ahnsoun eh kamwakel lao imwisekla. ");
INSERT INTO pon2006a_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ni lih emen pahn kaipwidi kisin serepein kis, e pahn saminla ong kaudok erein rahn eisek pahieu, duwehte eh kin saminkihla eh soumwahu en lih. Eri mwurin rahn weneisek weneu lih pahn kin saminkihla pwilipwil en nta. ");
INSERT INTO pon2006a_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Ni ahnsou me rahn en eh kamwakel pahn imwisekla, mwurin eh naitikihada serepein de pwutak, e pahn wadohng samworo ni wenihmwen Impwal me KAUN-O kin ketiket loale sihmpwul men me sounpar ehu mehn wia meirong isihs oh mwuroi men de pitsin men mehn wia meirong en dihp. ");
INSERT INTO pon2006a_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Samworo ahpw pahn patohwandahng KAUN-O meirong pwukat oh wia sarawien kamwakelehsang eh samin, liho ahpw pahn mwakelekella ong kaudok. Ih met me lih emen pahn kin wia mwurin eh pahn neitik. ");
INSERT INTO pon2006a_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ma liho sohte kak meirongki sihmpwul, e pahn wahdo mwuroi riemen de pitsin riemen, emen mehn wia meirong isihs, a emen mehn wia meirong en dihp. Samworo ahpw pahn wia sarawien kamwakelehsang eh samin, liho ahpw pahn mwakelekella ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","KAUN-O ketikihong Moses oh Aaron koasoandi pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Ma mehmen mie kens ni kili de mpwos de mpwet me kak wia kilel en soumwahu tokutok, e pahn pakahrdohng rehn samworo kan me kadaudok en Aaron. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Samworo ahpw pahn kasawih kenso ni kilio. Ma wunen kilio me mi ni kenso poh pwetepwetalahr oh kenso loaldi, met kasalehda me iei soumwahu tokutok ehu, oh samworo pahn nda me aramaso saminlahr. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ahpw ma kenso poh pwetepwet oh sohte loaldi oh wune kan sohte poh pwetepwetala, samworo pahn katohrehsang aramaso rehn aramas teikan erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ni keisuhn rahn samworo pahn pwurehng kasawih, oh ma nin duwen eh lemeleme, kenso duweduwehte sohte laudla, e pahn katohrehla aramaso pil erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","E pahn pil pwurehng kasawih ni keisuhn rahn, oh ma kenso tikitiklahr oh sohte laudla, e pahn nda me aramaso mwakelekellahr ong kaudok. Pwe kens mwahl ehu mwo. Aramaso pahn kamwakelehda eh likou kan oh wialahr aramas mwakelekel ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ahpw ma kenso laudla mwurin samworo eh kasawiher oh nda me e mwakelekellahr, e pahn pwurehng patohla rehn samworo. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Samworo ahpw pahn pwurehng kasawih, oh ma e diarada me kenso laudlahr, e pahn nda me aramaso saminlahr; pwe soumwahu tokutok ehu mwo. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Ma emen pahn alehdi soumwahu suwed ni kili, e pahn wisikdohng rehn samworo, ");
INSERT INTO pon2006a_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","pwe en ale keseu reh. Ma kenso poh pwetepwet oh pil kapwetepwetihala wunen wasa me kenso mieo, oh diren nahn, ");
INSERT INTO pon2006a_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","iei soumwahu tokutok ehu me wereilahr. Samworo pahn nda me aramaso saminlahr, ahpw sohte pahn katohrehsang aramas akan; pwehki aramas kak kilang me e samin. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ma soumwahu tokutoko doupeseng ni kilin aramaso, lellahng ni moange oh nin neh kan, ");
INSERT INTO pon2006a_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","samworo pahn pwurehng kasawih. Ma e diarada me soumwahwo doupesengehr wasa koaros ni paliwere, e pahn nda me aramaso mwakelekellahr ong kaudok. Ma kilin aramaso poh pwetepwetala, e mwakelekellahr ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ahpw sang ni ahnsowohte me kens pahn pwarada ni kili, e saminlahr. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Samworo pahn pwurehng kasawih, oh ma e diarada me uduke kenspesengehr, e pahn nda me aramaso saminlahr. Pwe uduk me momour oh kenspeseng, iei tokutok. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ahpw ma kenso mwahula oh pwurehng poh pwetepwetala, aramaso pahn pwurala rehn samworo. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Samworo pahn pwurehng kasawih oh ma kenso poh pwetepwetala, e mwakelekellahr ong kaudok, eri samworo pahn nda me aramaso mwakelekellahr. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Mehmen me ahneki mpwos ehu me mwahulahr, ");
INSERT INTO pon2006a_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","oh ma mwuhr mie mpwos pwetepwet ehu de mwahi weitahta pwarada wasa mpwos mahso, e pahn pwarala rehn samworo. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Samworo ahpw pahn kasawih, oh ma mwahio loaldi ni kilio, oh ma wunen wasao poh pwetepwetala, e pahn nda me aramaso saminlahr. Pwe soumwahu tokutok me tepidahr ni mpwoso. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ahpw ma mwurin samworo eh kasawih, oh diarada me wunen wasao sohte poh pwetepwetala oh mwahio sohte loaldi, ahpw e poh mara, samworo pahn katohrehla sang aramas akan erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ma mwahio laudla pohn kilio, samworo pahn nda me aramaso saminlahr pwe soumwahu tokutok ehu mwo. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ahpw ma e duweduwehte sohte laudla de doupeseng, iei mohn mpwoso mwo, eri samworo pahn nda me e mwakelekellahr ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Ma mehmen mwasikala ni kili, uduken kilio ahpw poh pwetepwetala de poh pwetepwet weitahta, ");
INSERT INTO pon2006a_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","samworo pahn kasawih. Ma wunen aramaso ni mpwoso poh pwetepwetala oh mpwoso loaldi ni kilio, eri met tokutok me tepidahr wasa mwasikalao, oh samworo pahn nda me e saminlahr. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ahpw ma wune sohte poh pwetepwetala oh mwahio sohte loaldi ni kilio, oh e poh mara, samworo pahn katohrehla sang rehn aramas akan erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Samworo pahn pil pwurehng kasawih ni keisuhn rahn. Oh ma e lalaudla, eri soumwahu tokutok ehu mwo, samworo pahn nda me aramaso saminlahr. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ahpw ma mwahio duweduwehte sohte laudla oh e poh mara, kaidehkin tokutok. Samworo pahn nda me e mwakelekellahr ong kaudok, pwe iei mohn mpwos mwasikala ieu mwo. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Ma kens ehu pahn pwarada ni moangen de ni kaikaihn ohl emen de lih emen, ");
INSERT INTO pon2006a_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","samworo pahn kasawih, oh ma e diarada me kenso loaldi ni kilio oh wunen wasao me poh oangoahng, e soumwahu tokutok, oh samworo pahn nda me aramaso saminlahr. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ahpw ni eh kasawih, e diarada me kenso sohte loaldi ni kilio, oh wunen wasao sohte toantoal, samworo pahn katohrehla sang rehn aramas akan erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Eri ni keisuhn rahn e pahn pil pwurehng kasawih. Ma kenso sohte laudla oh wune sohte poh oangoahng oh sohte loaldi ni kilio, ");
INSERT INTO pon2006a_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","aramaso pahn sehkasang wune ko likin wasa me kenso mi ie. Samworo ahpw pahn katohrehla sang rehn aramas akan erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ni keisuhn rahn samworo pahn pwurehng kasawih, oh ma kenso sohte laudla oh sohte loaldi ni kilio, e pahn nda me aramaso mwakelekellahr ong kaudok. Aramaso pahn kamwakelehda eh likou kan, e ahpw pahn wiahla aramas mwakelekel. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ahpw ma kenso laudla, mwurin kadehdepen eh mwakelekellahr, ");
INSERT INTO pon2006a_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","samworo pahn pwurehng kasawih. Ma kenso laudla, e sohte anahne tehk ma wunen wasao poh oangoahng; pwe aramaso uhdahn saminlahr. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ahpw ma samworo lemeleme me kenso sohte laudla oh wunen wasao wosohsada poh toantoal, kenso mwahulahr, oh samworo pahn nda me aramaso mwakelekellahr ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Ma mwahi pwetepwet pahn pwarada ni kilin ohl emen de lih emen, ");
INSERT INTO pon2006a_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","samworo pahn kasawih. Ma mwahio poh reirei, eri mpwet ehu me pwarada ni kilio; aramaso mwakelekellahr ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Ma pitenmoangen aramas emen pahn mwerasang ni likinpaiki de pohn tepwe, met sohte pahn kahrehda eh saminkihla. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ahpw ma kens poh pwetepwet weitahta pahn pwarada wasao, iei soumwahu tokutok ehu. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Samworo ahpw pahn kasawih oh ma e diarada kens poh pwetepwet weitahta, ");
INSERT INTO pon2006a_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","e pahn nda me aramaso saminlahr pwehki soumwahu tokutok me mi nan moangeo. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Aramas emen me ahneki soumwahu tokutok pahn likawih likou tok, e sohte pahn karada moange, e pahn koaduhpwalihdi mese, oh likilikwerkiseli “Samin, samin!” ");
INSERT INTO pon2006a_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","E pahn samin erein eh wiewia soumwahu wet, oh e pahn mihmihte likin kahnimpwalo, katohrohrla sang aramas teikan. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ma mie eniep ni likou me wiawihda sang ni wunen sihpw de linen ");
INSERT INTO pon2006a_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","de ni mwein soangen likou pwukat de ni kilin kou de mehkot me wiawihda sang kilin kou, ");
INSERT INTO pon2006a_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","eri ma eniepo pohn dihpw de poh weitahta, eri iei ih soangen eniep me kin doupeseng, eri samworo pahn kilang. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Samworo ahpw pahn kasawih dipwisowo oh katohrehla erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ni kesiluhn rahn e pahn pil pwurehng kasawih, oh ma eniepo lalaudla, dipwisowo saminlahr. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Samworo pahn isikala pwehki eniep me kin lalaudla uhdahn pahn isihsla. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Ahpw ni eh kasawih e diarada me eniepo sohte lalaudla ni dipwisowo, ");
INSERT INTO pon2006a_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","e pahn koasoanehdi pwehn wudeuda oh katohrohrla erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Eri e pahn pwurehng kasawih, oh ma pohn eniepo sohte wekila, mehnda ma e sohte lalaudla, dipwisowo samsaminte. Ke pahn isikala dipwisowo, mehnda ma eniepo mi masloal de maslikin dipwisowo. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ahpw ni ahnsou me samworo pahn pwurehng kasawih, ma eniepo tikitiklahr, e pahn tehrasang ni likowo de ni kilin kouo. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ahpw ma eniepo pahn pwurehng pwarada, oh wie lalaudlahte, eri aramas me ahneki dipwisowo pahn isikala. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ma e pahn widen dipwisowo oh mwahio pahn sohrala, e pahn pwurehng widen; eri dipwisowo pahn mwakelekella ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Eri ih met kosonned me pid duwen eniep me mi ni likou me wiawihkihda wunen sihpw de linen oh de likou teikan oh ni mehkot me wiawihda sang ni kilin kou. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","KAUN-O ketikihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","koasoandi pwukat me pid duwen kamwakelehda aramas mwurin ar ahneki soumwahu tokutok pwe re en mwakelekella ong kaudok. Ni rahn me e pahn ale kadehdepen eh mwakelekel, e pahn pakahrdohng rehn samworo. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Samworo ahpw pahn kahrelahng likin kahnimpwalo oh kasawih. Ma soumwahwo mwahulahr, ");
INSERT INTO pon2006a_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","samworo pahn koasoanehdi pwe menpihr riemen me mwakelekel ong kaudok en wisikdo iangahki ehu rahntuhkehn sidar, ehu sahl weitahta, oh ehu rahntuhkehn isop. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Eri samworo pahn koasoanehdi pwe emen menpihr ko en kamakamala pohn pwohl ehu me wiawihkihda pwehl oh pilen pwarer mi loale. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","E ahpw pahn ale menpihr teio iangahki rahntuhkehn sidaro, sahl weitahtao, oh rahntuhkehn isopo oh kaduh nan ntahn menpihr me kamakamalahro. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","E pahn usupihki ntao pak isuh aramas me pahn kamwakelda sang eh soumwahu tokutok, e ahpw pahn nda me aramaso mwakelekellahr. E ahpw pahn kadarala menpihr mouro nanwehwe. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Aramaso pahn kamwakelehda eh likou kan oh sehkasang pitenmoange oh duhdu; e ahpw pahn mwakelekella ong kaudok. E kak pwuralahng nan kahnimpwalo, ahpw e pahn koukousoan likin imwe impwalo erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ni keisuhn rahno e pahn pwurehng sehkasang pitenmoange, eh alis, padi oh wunen paliwere koaros; eh pahn kamwakelehda eh likou oh duhdu, e ahpw pahn mwakelekella ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Ni kawaluhn rahn e pahn wahdo riemen sihmpwul wol oh emen sihmpwul lih me sounpar ehu me sohte kisin samin kis rehrail, paun limau pilawa doal lehn olip, oh ehu kep en lehn olip. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Samworo ahpw pahn ale aramaso oh mehn meirong pwukat oh walahng irail ni wenihmwen Impwalen KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","E pahn ale emen sihmpwul wol ko iangahki kep en lehn olipo, e ahpw pahn meirongkihong KAUN-O nin duwen meirong en kapwungala. E ahpw pahn patohwandahng mepwukat KAUN-O nin duwen kisakis tohrohr ehu. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Samworo ahpw pahn kemehla sihmpwulo nan wasa sarawio ehu, wasa me mahn akan mehn wia meirong en dihp oh meirong isihs kin kamala ie. E pahn wia met, pwehki mehn meirong en kapwungala, duwehte mehn meirong en dihp, me pahn kin kohieng samworo oh pil wia mehkot me sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Samworo pahn ale ekis ntahn sihmpwulo oh iriski imwin salenge palimaun, sendilepen peh palimaun, oh pil sendilepen neh palimaun en aramaso me pahn kamwakel ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Samworo pahn pil ale ekis lehn olip oh wudekihdiong nan peh palimeing, ");
INSERT INTO pon2006a_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","e ahpw pahn kaduh sendinpeh palimaun loale oh usupihki pak isuh wasao mwohn silangin KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","E pahn ale ekis leh me mihmi nan peh oh ekis ntahn sihmpwulo oh iriski imwin salenge palimaun, sendilepen peh palimaun, sendilepen neh palimaun en aramaso me pahn kamwakel ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","E pahn kihdiong luhwen leh me mihmi nan peh pohn moangen aramaso. Ih duwen met samworo eh pahn wia sarawien kamwakel. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Samworo ahpw pahn wia meirong en dihp oh sarawien kamwakel. Mwurin met, e pahn kemehla mahn en wia meirong isihs, ");
INSERT INTO pon2006a_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","oh meirongki iangahki meirong en wahnsahpw pohn pei sarawio. Ih duwen met samworo eh pahn wia sarawien kamwakel, aramaso ahpw pahn mwakelekella ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Ma aramaso me semwehmwe oh sohte kak wia met, e pahn wahdo emente sihmpwul wol mehn wia sarawien kamwakel, mehn wia eh meirong en kapwungala; iei kisakis tohrohr ehu ong KAUN-O. E pahn wahdo paunte riau pilawa me doal lehn olip oh ehu kep en lehn olip. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","E pil pahn wa kohdo mwuroi riemen de pitsin riemen, emen mehn wia meirong en dihp oh emen mehn wia meirong isihs. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Ni kawaluhn rahn en eh kamwakel, e pahn wadohng samworo mepwukat ni wenihmwen Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Samworo pahn ale sihmpwulo oh lehn olipo oh patohwandahng KAUN-O nin duwen kisakis tohrohr ehu. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","E pahn kemehla sihmpwulo oh ale ekis ntao oh iriski imwin salenge palimaun en aramaso, sendilepen peh palimaun, oh sendilepen neh palimaun. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Samworo ahpw pahn wudekihdiong ekis leh nan peh palimeing, oh ");
INSERT INTO pon2006a_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","sendinpeh palimaun pahn usupih wasao pak isuh mwohn silangin KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","E pahn pil iriski leh wasakohte me e iriski ntahn mahno, eri ni imwin salenge palimaun, ni sendilepen neh palimaun, oh ni sendilepen neh palimaun. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Luhwen leh me mi nan peh, e pahn kihdiong pohn moangen aramaso. Ih duwen met e pahn wia sarawien kamwakel. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Mwuhr e pahn meirongki emen mwuroi ko de pitsin ko, ");
INSERT INTO pon2006a_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","pwehn wia meirong en dihp oh emen pahn wia meirong isihs iangahki mehn meirong en wahnsahpw. Ih duwen met samworo e pahn wia sarawien kamwakel. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ih met duwen kosonned ong aramas me soumwahu tokutok ahpw sohte kak kihda eh mehn meirong me anahnepe mie pwe en mwakelekelkihla. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","KAUN-O ketikihong Moses oh Aaron ");
INSERT INTO pon2006a_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","koasoandi pwukat me pid ihmw kan me eniep kin doudoupeseng loale. (Aramas akan en kapwaiada koasoandi pwukat mwurin ar pahn pedolong nan wehin Kenan, sahpw me KAUN-O pahn ketikihong irail pwe re en sapwenikihla.) ");
INSERT INTO pon2006a_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Mehmen me diarada eniep nan imwe en pwarodo oh pakairkihong samworo. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Samworo ahpw pahn koasoanehdi pwe mehkoaros nan ihmwo en kemwekidsang mwohn eh pahn kolahng kasawih eniepo; ma re sohte kihsang, eri e pahn nda me mehkoaros nan ihmwo saminlahr. Eri e pahn pedolong nan ihmwo ");
INSERT INTO pon2006a_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","oh kasawih eniepo. Ma e diarada wasa kei me pohn dihpw de weitahta me mwomwen kangkang diden ihmwo, ");
INSERT INTO pon2006a_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","e pahn pedoisang loale oh loakehdi erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ni keisuhn rahn e pahn pwurala oh pwurehng kasawih. Ma eniepo laudla, ");
INSERT INTO pon2006a_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","e pahn koasoanehdi pwe takai ko me eniepo mi ie en poksang oh lekdeklahng wasa samin kei likin kahnimwo. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Mwuri e pahn pil koasoanehdi pwe re en korehdasang diden loale koaros oh kihd koaros en lekdeklahng wasa samin kei likin kahnimwo. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Eri takai kapw en wisikdo oh wiliandi takai me lekdeklahr ko, oh re pahn litapwiheki dihd ko litopw kapw. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Ma eniepo pahn pwurehng pwarada nan ihmwo mwurin takai ko eh poksangehr oh koroiroier oh pwurehngehr litopw, ");
INSERT INTO pon2006a_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","samworo pahn pwurala oh pwurehng kasawih. Ma eniepo laudlahr, eri ihmwo saminlahr. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ihmwo uhdahn pahn kerengpeseng, oh takai ko, tuhke ko, oh mehkoaros loale, pahn wisiklahng wasa samin kei likin kahnimwo. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Mehmen me pahn pedolong nan ihmwo ni eh loakdier pahn saminkihla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Mehmen me pahn wendi de mwenge nan ihmwo pahn kamwakelehda eh likou kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Ma samworo, ni eh pahn pwurala kilang, oh diarada me eniepo sohte pwurehng pwarada mwurin eh pwurehng litopw, e pahn nda me ihmwo mwakelekellahr ong kaudok pwehki eniepo eh kohsangehr douluhl. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Pwe ihmwo en kamwakelda, e pahn wahdo menpihr riemen, iangahki ehu rahntuhkehn sidar, ehu sahl weitahta, oh ehu rahntuhkehn isop. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","E pahn kemehla emen menpihr ko pohn einpwoat me wiawihkihda pwehl me pilen pwarer mi loale. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Mwuri e pahn ale rahntuhkehn sidaro, rahntuhkehn isopo, oh sahl weitahtao oh menpihr mouro; e ahpw pahn kaduh mepwukat nan ntahn menpihr me kamakamalahro oh nan pihlo. Eri e pahn usupihki ihmwo pak isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ih duwen met eh pahn kamwakelekihda ihmwo ntahn menpihro, pilen pwarero, menpihr me mouro, rahntuhkehn sidaro, rahntuhkehn isopo oh sahl weitahtao. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Eri e pahn kadarala menpihr mouro nanwehwe likin kahnimwo. Ih duwen met eh pahn wia sarawien kamwakelehda ihmwo; ihmwo eri pahn mwakelekellahr ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ih met kosonned akan me pid duwen soumwahu tokutok; ");
INSERT INTO pon2006a_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","56","duwehte kens, mpwos, de mpwet ape; oh pil pid duwen eniep ni likou de nan ihmw kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Kosonned pwukat kin kasalehda iahd me mehkot kin saminla oh iahd e kin mwakelekella. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","KAUN-O ketikihong Moses oh Aaron koasoandi pwukat ");
INSERT INTO pon2006a_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","pwe ira en padahkihong mehn Israel kan. Ma nahn pahn kohsang ni ohn mour en ohl, nahno me samin, ");
INSERT INTO pon2006a_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","mehnda ma e pein pwilisang ni ohn mouro de e pinahla. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ma ohlo pahn wendi de mwohndi pohn peht ehu, pehto pahn saminkihla. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Mehmen me pahn sair eh pehto, ");
INSERT INTO pon2006a_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","de mwohndi wasa me ohlo mwohd ie, pahn kamwakelehda eh likou kan oh duhdu, ahpw e pahn saminkihla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Mehmen me pahn sair paliweren ohl me nahn kin pwilipwilsang, pahn kamwakelehda eh likou kan oh duhdu, ahpw e pahn saminkihla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Ma ohl me nahno kin pwilipwilsang pahn kendipiong pohn aramas emen me mwakelekel ong kaudok, aramaso pahn kamwakelehda eh likou kan oh duhdu, ahpw e pahn saminkihla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Mehn mwomwohd koaros de pil mehn mwohd pohn oahs de kamel pahn saminla ma ohl me nahn kin pwilipwilisang pahn mwohndi powe. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Mehmen me pahn sair mehkot me ohl menet mwohndier powe pahn saminkihla lao lel nin soutik. Mehmen me pahn wahda mehkot me ohl menet mwohndier powe pahn kamwakelehda eh likou kan oh duhdu, ahpw e pahn saminkihla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ma ohl me nahn kin pwilipwilsang pahn doahke emen tohrohr ni eh sohte omwiomw mahs, aramas teio pahn kamwakelehda eh likou kan oh duhdu, ahpw e pahn saminkihla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ma ohl menet pahn doahke pwohl ehu me wiawihkihda pwehl, aramas pahn pwalangpeseng, de ma e doahke pwohl tuhke ehu, pwohlo pahn wideuda. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Ni eh pahn mwahula en ohl menet eh soumwahwo, e pahn awih erein rahn isuh, e ahpw pahn kamwakelehda eh likou kan oh duhduhki pilen pwarer, eri e ahpw pahn mwakelekella ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ni kawaluhn rahno, e pahn ale mwuroi riemen de pitsin riemen oh walahng ni wenihmwen Impwal me KAUN-O kin ketiket loale oh kihong samworo. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Samworo ahpw pahn wiahki emen menpihr ko mehn meirong en dihp oh emen mehn meirong isihs. Ih duwen met samworo eh pahn wia sarawien kamwakelehda ohlo. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Ma ohl emen pahn kakusiei pilen newe, paliwere pwon pahn duhdu, oh e pahn saminkihla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ma pilen ohlo pahn kusieng ni mehkoaros me wiawihkihda likou de kilin kou, dipwisowo pahn kamwakelkihda pihl, oh e pahn saminkihla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ma ohl emen oh lih emen pahn kapwaiada nsenen pwopwoud, ira koaros pahn duhdu mwuri, oh ira pahn saminkihla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Ahnsou me lih emen pahn kin wia eh soumwahu en lih, e pahn saminkihla erein rahn isuh. Mehmen me pahn doahke pahn saminkihla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Mehkot me liho pahn mwohndi powe de wendi powe erein eh wiewia eh soumwahu pahn saminla. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Mehmen me pahn sair kihen lih menet; eh peht de mehkot me e mwohndi powe pahn kamwakelehda eh likou kan oh duhdu, ahpw e pahn saminkihla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ma ohl emen pahn wiahiong lih emen nsenen pwopwoud ni ahnsou me e wiewia eh soumwahu en lih, eri e iangehr saminla, oh e pahn saminkihla erein rahn isuh; oh peht koaros me e pahn wendi powe, pil iangehr saminla. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Ma lih emen pahn mehnwarmwowi erein rahn ekei likin ahnsoun eh soumwahu en lih, de nta pwilipwil erein rahn ekei likin ahnsoun eh soumwahu en lih, e pahn saminkihla erein ntao eh pahn pwilipwil. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Peht koaros me e wendi powe de mehkot me e pahn mwohndi powe ni ahnsou me e wiewia soumwahu en nta pwilipwil pahn saminla. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Mehmen me pahn sair dipwisou pwukat pahn saminkihla, eri e pahn kamwakelehda eh likou kan oh duhdu, ahpw e pahn saminkihla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Mwurin eh soumwahu pwilipwilo pahn imwisekla e pahn awiawihete erein rahn isuh, e ahpw pahn mwakelekella ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ni kawaluhn rahn e pahn wahla mwuroi riemen de pitsin riemen rehn samworo ni wenihmwen Impwal me KAUN-O kin ketiket loale. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Samworo ahpw pahn wiahki emen menpihr ko mehn meirong en dihp oh emen mehn meirong isihs. Iei duwen met e pahn wia sarawien kamwakele liho. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","KAUN-O ketin mahsanihong Moses en kehkehlingkihong mehn Israel ko duwen ar samin pwe re dehr kasaminehla Impwal me mi nanwerengen kahnimpwalo. Ma re pahn kasaminehla, re pahn mehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ih met kosonned akan me pid duwen ohl me ahneki soumwahu en nahn pwilipwil oh ohl me pahn kakusala newe, ");
INSERT INTO pon2006a_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","de lih emen me wia eh soumwahu en lih, de ohl emen me pahn wiahiong nsenen pwopwoud lih emen me samin ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","KAUN-O mahseniong Moses mwurin mehlahn nein Aaron pwutak riemeno me kamakamkihla ara meirongkihong KAUN-O kisiniei keinepwi. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","E mahsanih, “Ndaiong riomwo, Aaron me ahnsou kesempwalte me e pahn kotehla kahdengo pwehn pedolong nan Wasa Sarawiheo, pwe iei wasa me I kin pwarada ie nan pelien depwek pali pohnangin pweinen Kohpwahn Inowo. Ma e sohte pahn peikiong ie, e pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","E pahn kak pedolong nan Wasa Sarawiheo; mwurin eh pahn wahdo emen kou wol pwulopwul mehn meirong en dihp oh emen sihpw wol mehn meirong isihs.” ");
INSERT INTO pon2006a_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","KAUN-O eri ketin koasoanehdi iren kaweid pwukat. Mwohn Aaron eh pahn pedolong nan Wasa Sarawiheo, e pahn duhdu mahs oh likawihada likoun samworo, iei likou reirei linen, rausis en loale, kateng, oh lisoarop. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Mehn Israel ko pahn kihong Aaron kuht wol riemen mehn meirong en dihp, oh emen sihpw wol mehn meirong isihs. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","E ahpw pahn meirongkihla kouwol men pwehki dipe kan oh dipen eh peneinei. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Eri, e ahpw pahn ale kuht wol riemeno oh patohwanlahng ni wenihmwen Impwal me KAUN-O kin ketiket loale. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","E pahn wia usuhs wasao, doadoahngki kisin takai riau, ehu nting powe, “ong KAUN-O” a ehu “ong Asasel.” ");
INSERT INTO pon2006a_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaron ahpw pahn meirongkihong KAUN-O kuht me usuhsdahro oh wiahkihla mehn meirong en dihp. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","A kuht me pilipildahr ong Asasel pahn mourte mweimweidahng KAUN-O oh pahn pekederlahng nan sapwtehn rehn Asasel pwehn lapwahsang dipen aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Ni ahnsou me Aaron pahn meirongkihla kouwolo pwehn wiahla meirong en dipe kan oh dipen eh peneinei, ");
INSERT INTO pon2006a_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","e pahn ale dahlen kisiniei ehu me diren mwoalus ngkengken sang pohn pei sarawio oh oaroahr riau en warpwohmwahu oh wahlongala nan Wasa Sarawiheo. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Eri, wasao, mwohn silangin KAUN-O, e pahn audehkihda kisinieio warpwohmwahwo; pwe edin warpwohmwahwo en kipehdi pweinen Kohpwahn Inowo pwe en dehr kilang oh mehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","E pahn alehki sendin peho ekis ntahn kouwolo oh usupihki pweinen kohpwao oh pil usupihki mwohn Kohpwahn Inowo pak isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Mwurin met, e pahn kemehla kuhto pwe en wiahla meirong en dipen aramas akan, e ahpw pahn wahla ntaho nan Wasa Sarawiheo oh usupihki pweinen kohpwao oh mwohn Kohpwahn Inowo, duwehte me e wiahiong ntahn kouwolo. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ih duwen met eh pahn wia tiahk sarawien kamwakelehda Wasa Sarawiheo sang samin en mehn Israel kan oh sang diparail kan koaros. E pahn wiahiong met ong Impwalo, pwehki Impwalo eh kin mihmi nan werengen kahnimpwal me saminlahn kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Sohte aramas emen pahn mi nan Impwalo sang ni ahnsou me Aaron pahn pedolong nan Wasa Sarawiheo pwe en wia tiahk sarawien kamwakel, lao e pahn pedoisang loale. Mwurin eh wiahier tiahk sarawien kamwakel ong pein ih, eh peneinei oh pil aramas koaros, ");
INSERT INTO pon2006a_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","e pahn pedoila ni pei sarawien meirong isihso oh wia tiahk sarawien kamwakelehda. E pahn wa kohla ekis ntahn kouwolo oh ntahn kuhto, oh kihdiong ni kohd pahieu me mi ni keimwen pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","E pahn alehki sendin peho ekis ntaho oh usupihki pohn pei sarawio pak isuh. Ih duwen met eh pahn kamwakelehsang dipen mehn Israel kan oh kasarawihala pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Ni Aaron eh kaimwisekalahr tiahk sarawien kamwakelehda Wasa Sarawiheo, oh wasa teikan en Impwal me KAUN-O kin ketiket loale, oh pei sarawio, e ahpw pahn patohwanohng KAUN-O kuht me momouro, me pilipildahr ong Asasel. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","E pahn kapahla peh ko pohn moangen kuhto oh sakarkihda tiahk suwed koaros, dihp koaros, oh kahngohdi en mehn Israel kan, ih eri pahn kasauwong dihp pwukat koaros pohn moangen kuhto. Eri, kuhto ahpw pahn pakahrlahng nan sapwtehn, oh mie ohl emen me kileldier me pahn wahla. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Eri, dipen aramas koaros pahn iang kuhto kolahng nan sahpw ehu me sohte towe. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Eri Aaron ahpw pahn pedolong nan Impwalo, oh kihsang eh likoun samworo ko me e likawihada mwohn eh pedolong nan Wasa Sarawiheo, oh pwilikihda likou pwukat wasao. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","E ahpw pahn duhdu nan wasa sarawi kis, oh pwuhriong nan uhdahn eh likou kan. Mwurin met, e pahn pedoila oh wia meirong isihs en lapwahda pein dipe kan oh dipen aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","E pahn isikala pohn pei sarawio wih en mahn mehn wia meirong en dihp. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Aramas me kahreieila kuhto rehn Asasel nan sapwtehn pahn kamwakelehda eh likou kan oh duhdu mwohn eh pahn pwurala nan kahnimpwalo. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","A kouwol oh kuht me kamakamalahr pwehn wia meirong en dihpo, me ntahra ko wisikdohng nan Wasa Sarawiheo mehn lapwahsang dihpo, pahn wisikla likin kahnimpwalo oh isihsla. Kili, uduke, oh kanengen nan kapehd koaros pahn isihsla. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Aramas me pahn isikala mahn ako pahn kamwakelehda eh likou oh duhdu mwohn eh pahn pwuralahng nan kahnimpwalo. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Eri, kosonned kan me pahn sansal pah pahn poatopoat ong kumwail ahnsou kan koaros me pahn kohdo. Ni kaeisek en rahn keisuhn sounpwong, mehn Israel koaros, oh mehn liki kan me kin kousoan rehrail, pahn kaisihsol oh sohte doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Nin rahno tiahk sarawien kamwakel pahn wiawi pwehn kamwakele sang irail diparail kan koaros, pwe re en mwakelekel ni ahnsou en kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Rahno uhdahn pahn wiahla rahn sarawi ehu, rahnen kaisihsol oh mweisang doadoahk. Kosonned pwukat pahn kin poatopoat kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Samworo Lapalap, me kesepwildahr oh kasarawilahr pwehn wiliandi eh pahpa, iei ih me pahn kin wia tiahk sarawien kamwakel wet. E pahn likawihada likoun samworo, ");
INSERT INTO pon2006a_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","oh wia tiahk sarawien kamwakele nan Wasa Sarawiheo, oh wasa teikan en Impwal me KAUN-O kin ketiket loale, pei sarawio, samworo kan, oh pokon en mehn Israel ko koaros. ");
INSERT INTO pon2006a_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Kosonned pwukat pahn kin poatopoat ong kumwail ahnsou kan koaros me pahn kohdo. Tiahk sarawi wet pahn kin wiawi pak ehu nan pahr ehu pwehn kamwakele sang mehn Israel kan nan diparail kan koaros. Eri, Moses kapwaiada mehkoaros, duwen me KAUN-O ketin koasoanehdi. ");
INSERT INTO pon2006a_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","KAUN-O ketin mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","en padahkihong Aaron oh nah pwutak ko oh mehn Israel kan koaros kosonned pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","Mehn Israel men me pahn kemehla kou men de sihpw men de kuht men pwehn wiahki eh meirong ong KAUN-O wasa kis me tohrohrasang ni wenihmwen Impwal me KAUN-O kin ketiket loale, e pahn kauwehla kosonned. E kakeredier nta oh solahr pahn wia kisehn sapwellimen Koht aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Wehwehn koasoandi wet pwe mehn Israel kan en kin wadohng KAUN-O mahn akan me re kin epwehnki kemehla nansapw. Re pahn kin wadohng rehn samworo ni wenihmwen Impwalo oh kemehla pwehn wia ar mehn meirong en kaminimin. ");
INSERT INTO pon2006a_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Samworo ahpw pahn usupihki ntao pei sarawio ni wenihmwen Impwalo oh isikala wih ko pwe pwohn meirongo en kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Mehn Israel kan eri solahr pahn soaloalopwoat ong KAUN-O ni ar pahn kemehla nair mahn akan nansapw pwehn wia meirong ong eni tepil kan. Mehn Israel kan pahn kapwaiada kosonned wet erein dih koaros kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Mehn Israel men de mehn liki men me kin kousoan rehn mehn Israel kan me pahn kin wia meirong isihs de ehu soangen meirong tohrohr, ");
INSERT INTO pon2006a_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ong KAUN-O ekis wasa likin mwohn wenihmwen Impwalo, e sohlahr pahn wia kisehn sapwellimen KAUN-O aramas. ");
INSERT INTO pon2006a_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Ma mehn Israel men de mehn liki men me kin kousoan rehn mehn Israel kan pahn tungoale uduk me nta mihmihte ie, KAUN-O pahn ketin sohpeisang oh e solahr pahn wiahki ih kisehn sapwellime aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Mour en mehkoaros me momour kin mihmi ni nta, ihme KAUN-O ketin koasoanehkihdi pwe nta koaros en kin widekiong pohn pei sarawio pwehn kin kihsang dipen aramas akan. Nta, me iei mour, iei me kin kihsang dihp. ");
INSERT INTO pon2006a_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ihme kahrehda KAUN-O ketin mahsanihong mehn Israel kan pwe irail de mehn liki kan me kin kousoan rehrail, re dehpa tungoale uduk me nta mihmihte ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Mehn Israel men de mehn liki men me kin kousoan rehn mehn Israel kan me pahn koledi mahn emen de menpihr men me mwakelekel ong kaudok, e pahn kakerehdiong ntahn mahno nanpwel oh kihong pwehl powe. ");
INSERT INTO pon2006a_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Mour en mehkoaros me momour mihmi ni nta, iei me KAUN-O ketin mahsanihkihong mehn Israel kan re dehr tungoale uduk me nta mihmihte ie oh mehmen me pahn tungoalehda e solahr pahn wia kisehn sapwellime aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Aramas emen, mehn Israel de mehn liki, me pahn tungoale uduk en mahn me mehla mwahl de me mahn lawalo kemehla, pahn lopworada eh likou kan, duhdu oh awih lao lel nin soutik mwohn eh pahn mwakelekella. ");
INSERT INTO pon2006a_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ma e sohte pahn kapwaiada met, e pahn ale kalokepen eh sapwung. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","KAUN-O ketin mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","en padahkihong mehn Israel kan, “Ngehi, KAUN-O amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Kumwail dehr idawehn tiahk en mehn Isip kan, wasa kumwail kousoan ie mahso, de mehn Kenan kan, wasa I kahkahrekumwaillahng ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Kumwail kapwaiada ei kosonned akan oh kapwaiada dahme I koasoanedier. Ngehi KAUN-O, amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Kumwail idawehn tiahk oh kosonned akan me I kihong kumwail; kumwail ahpw pahn mourla. Ngehi KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","KAUN-O ketikihda kosonned pwukat. Dehr wia nsenen pwopwoud ong emen me kisehn omw peneinei. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Dehr kanamenekihala omw pahpa ni omw pahn wia nsenen pwopwoud ong omw nohno. Ke dehr pil kanamenekihala pein omw nohno. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Dehr kanamenekihala omw pahpa ni omw pahn wia nsenen pwopwoud ong eh pwoud teikan. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Dehr wia nsenen pwopwoud ong riomw serepein, de serepein men me eh nohno pwoudiki omw pahpa, de serepein men me eh pahpa pwoudiki omw nohno, mehnda ma kumwa tikida wasa kis de soh. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Dehr wia nsenen pwopwoud ong nein noumw seri kan nair seri; pwe met pahn kanamenekihukala. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Dehr wia nsenen pwopwoud ong serepein men me amwa nohno tehmen de pahpa tehmen; pwe serepeino pil uhdahn riomw. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","13","Dehr wia nsenen pwopwoud ong rien omw pahpa lih de rien omw nohno lih. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Dehr wia nsenen pwopwoud ong rien en omw pahpa ohl eh pwoud; pwe liho pil pahn wiahla omw nohno. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Dehr wia nsenen pwopwoud ong en noumw pwutak eh pwoud ");
INSERT INTO pon2006a_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","de ong en riomw eh pwoud. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Ma ke wiahiongehr nsenen pwopwoud ong lih emen, a ke dehr pil wiahiong nsenen pwopwoud ong nein liho serepein de nah serepein; pwe ira kakete wia kisehmw, oh met tiahk en kilikileng suwed ehu. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Dehr pwoudikihda rien omw pwoud serepein, erein omw pwoudo eh momour. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Dehr wia nsenen pwopwoud ong lih emen nindokon eh wiewia eh soumwahu en lih, pwe liho me samin ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Dehr wia nsenen pwopwoud ong en emen ohl eh pwoud, pwe met pahn kasamineiukala. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Dehr mweidohng emen noumw seri kan en wia mehn meirong ong koht likamw Molek, pwehki met pahn kasaminehla mwar en Koht, me iei KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Sohte ohl emen pahn eng rehn emen ohl, pwe Koht kin ketin kalahdeki tiahk wet. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Sohte ohl emen de lih emen pahn eng rehn mahn emen; pwe e pahn saminkihla. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Dehr kasaminehkinkumwailla tiahk pwukat, pwe iei met me kahrehda me rotorot akan ar kin saminla, irail me rotorot akan me kin kousoan wasa me I kahkahreikumwailwohng ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ar tiahk kan kasaminelahr sapwarailo, iei me KAUN-O ketin kalokalokehki sahpwo, oh towe kan kin lekdeksang loale. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","27","Re kin wia tiahk saut pwukat koaros oh kin kasaminehkihla sahpwo, eri kumwail dehpa iang wia tiahk pwukat. Kumwail koaros me pwilidak kan oh mehn liki kan me kin kousoan rehmwail, kumwail pahn kapwaiada sapwellimen KAUN-O koasoandi oh kosonned akan, ");
INSERT INTO pon2006a_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","eri kumwail sohte pahn lekdeksang nan sahpwo, duwehte eh keselahr me rotorot akan me kin kousoan wasao mwohmwail. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Pwe aramas koaros me pahn kin wiahda soangen tiahk saut pwukat solahr pahn wia kisehn sapwellimen Koht aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","KAUN-O pil mahsanih, “Kumwail kapwaiada koasoandi kan me I kihong kumwail oh dehr idawehn tiahk en aramas ako me kousoanehr nan sahpwo mwohmwail, oh dehr kasamineikumwailla ni amwail pahn wiahda ekei soahng pwukat. Ngehi KAUN-O, amwail Koht.” ");
INSERT INTO pon2006a_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","KAUN-O mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","en patohwanohng mehn Israel ko, “Kumwail en sarawihla, pwe ngehi, KAUN-O, amwail Koht, me sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Emenemen kumwail pahn kin wauneki eh nohno oh eh pahpa, oh pil kapwaiada rahnen Sapad, duwen me I koasoanedier. Ngehi me KAUN-O, amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Kumwail dehr keseiehla oh pwongih dikedik en eni kan, pil dehr wiahda oh pwongih koht kan me wiawihkihda mete. Ngehi me KAUN-O, amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Ni amwail pahn kemehla mahn emen pwehn wia meirong en kaminimin, kumwail kapwaiada kosonned akan me I kihong kumwail; eri, I ahpw pahn perenki meirongo. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Kumwail pahn kang uduko ni rahn me kumwail kemehla mahno, de mandahn rahno. Ma mie uduk me luhwehdi lel ni kesiluhn rahn e pahn isihsla, ");
INSERT INTO pon2006a_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","pwehki eh saminlahr ong kaudok. Eri, ma mehmen pahn tungoale, I sohte pahn perenki meirongo. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Mehmen me pahn tungoale pahn kamwahlihala mehkot me kasarawihongieier, oh e solahr pahn wia kisehn nei aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Ni amwail pahn dolung wahn amwail mwetuwel kan, kumwail dehr pelehsang wahnsahpw kan me mi ni keilen amwail mwahto, pil dehr rikpene luhwen wahnsahpw kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Kumwail dehr dolung sapahlih amwail mwetin wain kan, wain me kumwail sohte kilang oh dauliher, de rikada wahn wain me pwupwudi kan; kumwail mweidohng kenen me semwehmwe kan oh mehn liki kan. Ngehi me KAUN-O, amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Kumwail dehr pirap, de mwersuwed, de wia likamw. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Kumwail dehr wiahda inou ni mwarei ma kumwail sohte lemeleme en kapwaiada; pwe met kin kahdsuwedihala mwarei. Ngehi me KAUN-O, amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Kumwail dehr wiahda mehkot suwed ong aramas emen, sohte lipilipil, de adihasang mehkot. Kumwail dehr kolokol pweinen noumwail tohndoadoahk kan, en dehr pil pwahndkihla rahn ehu. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Kumwail dehr lahlahwe aramas salengepon, de kihdiong mehkot mwohn me maskun men pwe en dipekelekelki, ahpw kumwail lemmwikin ie. Ngehi me KAUN-O, amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Kumwail wia dahme mehlel oh pwung ni amwail kin koasoanehdi pwunglahn kopwung kan nan mwoalen kopwung; dehr uhpalihki me semwehmwe kan, de masak me kepwehpwe kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Dehr karaunmwahlih aramas, oh ni emen eh pahn wia kopwung en eh mour, kasalehda omw kadehde ma e kak sewese ih. Ngehi me KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Ke dehr kadakadaur nan kapehdomw lamalam suwed ong emen, kapwungala soansuwed kan nanpwungen kowe oh mehn mpomw kan, pwe ke dehr wiahkihda dihp. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Dehr dupungki me suwed ong emen eh wia suwed ong uhk, de kadakadaur omw kailongki, ahpw ke en poakohng mehn mpomw duwehte omw kin poakohng pein uhk. Ngehi me KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Kumwail peikiong ei kosonned akan. Kumwail sohte pahn kowarakiheki noumwail mahn mahnd akan ong ehu soangen mahn tohrohr. Dehr padokedi soangen werentuhke riau nan mwetuwelteieu. Kumwail sohte pahn likawih likou me wiawihkihda soangen likou riau. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Ma e sansal me ohl emen wiahki eh pekehi serepein lidu men, ahpw serepeino saikinte pweipweida oh kasaledekla, oh ma emen ohl tohrohr pahn kapwaiada nsenen pwopwoud rehn serepeino, eri, ira pahn kalokolok, ahpw ira sohte pahn kamakamala, pwehki serepeino wia lidu men. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ohlo pahn wahla sihpw wol men ni wenihmwen Impwalo, mehn wia meirong en kapwungala, ");
INSERT INTO pon2006a_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","eri, samworo ahpw pahn wia sarawien kamwakel pwe en kamwakele sang dipen ohlo, Koht ahpw pahn ketin mahkikihong dipeo. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Ni amwail pahn pedolong nan sapwen inowo oh padokedi soangen wahntuhke sohte lipilipil, kumwail pahn wiahki me wahntuhke ko mehkot samin ong kaudok erein sounpar siluh. Kumwail dehr tungoale erein ahnsowo. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ni kapahieun sounpar wahntuhke koaros pahn kasarawihla nin duwen kisakis ehu mehn kasapahlkalahngan ong ie, KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ahpw ni kelimaun pahr, kumwail kakehr tungoale wahntuhke ko. Eri, ma kumwail pahn kin wia met, amwail tuhke kan pahn kin pweida oh wa mwahu. Ngehi me KAUN-O, amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Kumwail sohte pahn tungoale uduk doal nta. Dehr wia soangen tiahk en akmanaman oh kosetipw. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Kumwail sohte pahn sehk ni pengepengen moangamwail kan de koakoa amwail alis kan; ");
INSERT INTO pon2006a_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","kumwail sohte pil pahn palih kilimwail kan, de leke paliwaramwail pwe kumwail en kasalehda amwail nsensuwedkilahr me melahhr emen. Ngehi me KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Kumwail dehr kasaminehla noumwail serepein kan ni amwail kin wiahkin irail lihen netiki paliwere kei nan tehnpas sarawien mehn liki kan; pwe ma kumwail pahn wia met, kumwail pahn sohpeiong koht teikan; eri, sahpwet pahn direkihla tiahk suwed. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Kumwail kapwaiada rahnen Sapad oh wauneki tehnpesei. Ngehi me KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Kumwail dehr kohla rehn me kin ketieni kan. Ma kumwail pahn wia met, kumwail pahn saminla ong kaudok. Ngehi me KAUN-O, amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Kahkahki oh wauneki me mah kan. Kumwail lemmwikin ie oh peikiong ie. Ngehi me KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Dehr wiakauwe mehn liki kan me kin kousoan nan sapwamwail. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Kumwail nsenohkin irail duwehte amwail kin nsenohki riamwail mehn Israel kan, oh poakohng irail duwehte amwail kin poakohng pein kumwail. Kumwail en tamataman me kumwail wia mehn liki kei nan wehin Isip mahso. Ngehi me KAUN-O, amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Kumwail dehr pitihedi aramas ni amwail pahn doadoahngki mehn sohng sapwung oh mehn tenek sapwung. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Kumwail doadoahngki mehn sohng pwung oh mehn tenek pwung. Ngehi KAUN-O, amwail Koht, ngehi me waikumwaildo sang Isip. ");
INSERT INTO pon2006a_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Kumwail kapwaiada ei kosonned oh koasoandi koaros. Ngehi me KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","KAUN-O ketin mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","en padahkihong mehn Israel kan, “Mehmen rehmwail de emen sang rehn irail mehn liki me kin koukousoan rehmwail pahn wiahkihla mehn meirong ong koht likamw Molek emen nah seri kan, e pahn kostakaidi e lao mehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ma emen kumwail pahn meirongkihong Molek emen nah seri oh kasaminehkihla ei Impwal sarawio oh mwarei me sarawi, I pahn uhwong oh e solahr pahn wia kisehn nei aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ma aramas akan pohnsehse dahme aramaso wiadahr, oh sohte kemehla, ");
INSERT INTO pon2006a_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","eri, pein ngehi pahn uhwong ih oh eh peneinei unsek oh ong koaros me iang ih soaloalopwoat ong ie oh kaudokiong Molek. I solahr pahn wiahki ih kisehn nei aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Mehmen me pahn ale kaweid rehn soun ketieni de soun kosetipw, I pahn uhwong ih oh e solahr pahn wia kisehn nei aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Eri, kumwail en kolokol amwail mour sarawi, pwe ngehi KAUN-O amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Kumwail kapwaiada ei kosonned akan, pwehki ngehi KAUN-O, me kin kasarawihkumwailla.” ");
INSERT INTO pon2006a_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","KAUN-O ketikihda kosonned pwukat. Mehmen me pahn keriahla eh pahpa de eh nohno, e pahn kamakamala; pein ih pahn pwukoahki eh mehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Ma aramas emen pahn kamwahlihdi ienge mehn Israel men, ira koaros, ohlo oh liho, pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Pwutak emen me pahn wia nsenen pwopwoud ong emen en eh pahpa eh pwoud kan, e kanamenekihalahr eh pahpa oh ira koaros pwutako oh liho, pahn kamakamala. Ira me pein pwukoahki ara mehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ma ohl emen pahn wia nsenen pwopwoud ong en nah pwutak eh pwoud, ira koaros pahn kamakamala. Ira wiadahr tiahk en kilikileng suwed oh ira pahn pein pwukoahki ara mehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ma ohl emen pahn tuhkihong paliwere emen ohl, ira wiadahr tiahk kasaut ehu; ira koaros pahn kamakamala. Ira me pahn pein pwukoahki ara mehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Ma ohl emen pwoudikihda serepein men iangahki en serepeino eh nohno, irail koaros, ohlo oh lih riemeno pahn isihsla, pwehki kanamanek en tiahk me re wiadahr; pwe soangen tiahk wet sohte pahn wiawi nanpwungamwail. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Ma ohl emen pahn eng rehn mahn emen, ohlo oh mahno ira koaros pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Ma lih emen pahn song en eng rehn mahn emen, ira koaros pahn kamakamala. Ira pahn pein pwukoahki ara mehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Ma ohl emen pahn pwoudikihda rie serepein, de nein eh pahpa de nohno serepein, ira pahn lekdeksang rehn riarail aramas akan pwehki tiahk kanamenek wet; ohlo pahn pwukoakihdi tiahk suwed en kilikileng suwed. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Ma ohl emen pahn wia nsenen pwopwoud ong lih emen nindokon liho eh wiewia eh soumwahu en lih, ira koaros pahn lekdeksang rehn riara aramas akan, pwehki ara kauwehla kosonned kan me pid mwakelekel en kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Ma ohl emen pahn wia nsenen pwopwoud ong rien eh nohno de rien eh pahpa lih, ira koaros pahn pwukoahki dipen kilikileng suwed. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Ma pwutak emen pahn wia nsenen pwopwoud ong en rien eh pahpa eh pwoud, e kanamenekihalahr rien eh pahpa, eri ira koaros, pwutako oh liho pahn pwukoahki irair wet oh ira pahn mehla sohte neira seri. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ma ohl emen pahn pwoudikihda en rie eh pwoud, ira koaros pahn mehla sohte neira seri, pwehki eh wiadahr tiahk samin oh kanamenekihala rieo. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","KAUN-O ketin mahsanih, “Kumwail kapwaiada ei kosonned akan oh koasoandi kan, pwe kumwail dehr lekdeksang nan sahpw en Kenan, me I kahkahreikumwaillahng ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Kumwail dehr ale tiahk en tohn sahpwo; I kasakasare irail sang nan sahpwo pwe kumwail en kak pedolong loale. Pwe I kalahdkidahr tiahk saut kan me re wiadahr. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ahpw I inoukihongkumwailehr me I pahn kihong kumwail en sapwenikihla sahpw wet me rekiki kisin tungoal. Ngehi KAUN-O amwail Koht, me katohreikumwailsang wehi teikan. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Eri, kumwail en kin kadehde oh katohrehsang mahn oh menpihr mwakelekel kan sang rehn me samin kan. Kumwail dehr tungoale mahn de menpihr samin. I koasoanedier soangen mahn da me samin, eri ni amwail pahn tungoale kumwail pahn saminkihla. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kumwail pahn kin sarawi oh uhdahn wia nei aramas, pwehki ngehi me KAUN-O oh I me sarawi. I pilkumwaildahr sang nanpwungen wehi teikan pwe kumwail en wiahla nei aramas. ");
INSERT INTO pon2006a_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Ohl emen de lih emen sohte lipilipil me pahn kin wia katieni de kosetipw, pahn kostakaidi oh kamakamala; aramas emen me pahn wia tiahk wet pahn pein pwukoahki eh mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","KAUN-O ketin mahsanihong Moses en patohwanohng samworo kan me nein Aaron, “Sohte samworo men pahn kasaminehkihla pein ih ni eh pahn iang kasarawien sarepidi kiseh men me melahr, ");
INSERT INTO pon2006a_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","likin mehlahn eh pahpa, nohno, nah pwutak, nah serepein, rie ohl, ");
INSERT INTO pon2006a_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","de rie serepein me saikinte pwopwoud oh kin iang mihmi ni imweo. ");
INSERT INTO pon2006a_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","E sohte pahn kasaminehkihla pein ih mehlahn irail kan me pwopwoudohng nan eh peneinei. ");
INSERT INTO pon2006a_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Sohte samworo men pahn sehkasang pitenmoange de eh alis, de leke kili, pwe en kasalehda eh nsensuwedki mehlahn emen. ");
INSERT INTO pon2006a_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","E pahn sarawi oh e sohte pahn kasaminehla mwarei. E kin patohwandahng ie meirong en konot kan, eri e uhdahn pahn sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Samworo men sohte pahn pwoudikihda lih emem me kin netiki paliwere de lih me sohte meipwon de me mweisang eh pwoud. ");
INSERT INTO pon2006a_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Aramas akan pahn kin wiahki samworo aramas sarawi, pwehki eh kin patohwandahng ie meirong en konot kan. Ngehi KAUN-O; I me sarawi oh I kin kasarawihala nei aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ma nein samworo serepein pahn wiahla lihen netiki paliwere, serepeino pahn kanamenekihala eh pahpa; e uhdahn pahn isihsla lao mehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Samworo Lapalapo me keikidier leh sarawi pohn moange oh kasarawilahr pwehn kin likawih likoun samworo, sohte pahn kin kapingada pitenmoange de tehrpeseng eh likou pwehn kasalehda eh nsensuwedki me melahr emen. ");
INSERT INTO pon2006a_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","12","E kasarawihongieier oh e sohte pahn pein kasaminehla ih de kasaminehla ei Impwal sarawio ni eh pahn pedoisang oh kohla pedolong nan ihmw ehu wasa aramas mehla men mihmi ie, mehnda ma pil eh pahpa de eh nohno. ");
INSERT INTO pon2006a_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","E pahn pwoudikihda lih meipwon, ");
INSERT INTO pon2006a_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","kaidehk liohdi de lih me mweisang eh pwoud de lih me kin netiki paliwere. E pahn pwoudiki lih meipwon emen sang nan eh peneinei. ");
INSERT INTO pon2006a_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Ma soh, nah seri kan, me uhdahn pahn wia seri sarawi kei, pahn wiahla seri samin kei. Ngehi KAUN-O oh ngehi me piladahr oh katohrelahr ih pwehn wia Samworo Lapalap.” ");
INSERT INTO pon2006a_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","KAUN-O ketin mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","en padahkihong Aaron, “Sohte emen rehn kadaudokomw kan me mie mehkot suwed ni paliwere pahn kak mweimweiong en patohwandahng ie meirong en konot. Koasoandi wet pahn poatopoat erein dih koaros kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Sohte aramas emen me mie mehkot suwed ni paliwere kak mweimweiong en wia meirong: eri soangen aramas me rasehng me maskun, dangepel, de kiaweliwel; ");
INSERT INTO pon2006a_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","me pehtuk, de nehtuk; ");
INSERT INTO pon2006a_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","me mpwokos de me sokelei; sohte emen me masapang de kilinwai, de me lekwusol. ");
INSERT INTO pon2006a_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Sohte emen me kisehn kadadudok en samworo Aaron me mie mehkot mwomwsuwed ni paliwere pahn mweimweiong en patohwandahng ie meirong en konot. ");
INSERT INTO pon2006a_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Soangen aramas menet kak iang tungoale meirong en konot me kin kohieng ie, soangen meirong en konot kan koaros, me sarawi oh pil me inenen sarawihe kan, ");
INSERT INTO pon2006a_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ahpw pwehki mwomwsuwed ni paliwere e sohte pahn keidohng limwahn kahdeng sarawio de limwahn pei sarwio. E sohte pahn kasaminehla dipwisou sarawi pwukat, pwehki ngehi KAUN-O oh ngehi me kasarawihiraillahr.” ");
INSERT INTO pon2006a_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ih met me Moses patohwanohng Aaron, nein Aaron pwutak ko oh mehn Israel ko koaros. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","KAUN-O ketin mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","en padahkihong Aaron oh nah pwutak ko, “Kumwail dehr kin kasaminehla mwarei sarawi, kumwail wauneki mehn meirong sarawi kan me mehn Israel kan kin kasarawihong ie. Ngehi me KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Ma emen sang rehn kadaudokamwail kan, nan eh samin ong kaudok, ahpw keidohng mpen mehn meirong sarawi kan me mehn Israel kan kin kasarawihong ie, e solahr pahn pwurehng papah ni pei sarawi wet. Koasoandi wet pahn poatopoat kohkohlahte. Ngehi me KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Sohte emen sang rehn kadaudok en Aaron me ahneki soumwahu tukutuk de soumwahu en nahn pwilipwil mwahl, pahn kak tungoale meirong sarawi kan lao e pahn mwakelekella ong kaudok. Samworo koaros pahn saminla ma re doahkehda mehkot samin rasehng kahlep en aramas mehla de ma e nahn pwilipwil, ");
INSERT INTO pon2006a_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","de ma e doakehda mahn de aramas samin. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Samworo men me saminlahr, e pahn saminte lao lel nin soutik, oh e sohte pahn tungoale mehkot sang ni meirong sarawi kan, e lao duhdu. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Mwurin kihrlahn ketipin, e mwakelekellahr, eri ih ahnsowo me e kak tungoale meirong sarawi kan, me uhdahn pwaise. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","E sohte pahn tungoale uduk en mahn emen sohte lipilipil me mehla mwahl de mahn lawalo kemehla; pwe met pahn kahrehiong eh saminla. Ngehi me KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Samworo koaros pahn kapwaiada kosonned kan me I wiadahr. Ma soh, re pahn dipikihda oh mehkihla ar sohte peikiong kosonned sarawi pwukat. Ngehi me KAUN-O oh Ngehi me kin kasarawihirailla. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Peneineien samworo kante me kak tungoale meirong sarawi kan; irail kan me kin kousoan rehn samworo de kin doadoahkohng samworo kan sohte kak iang tungoale. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ahpw en samworo eh lidu kan me e pwainkihda pein nah mwohni de me ipwidi ni imwe, kak iang tungoale pweisen samworo. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Nein samworo serepein me pahn pwoudikihda emen me kaidehk samworo, sohte kak iang tungoale meirong sarawi kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ahpw nein samworo serepein me liohdi de mweisang eh pwoud me sohte nah seri oh me pwurodohng ni imwen eh pahpa kak iang tungoale kisin tungoal me eh pahpa kin ale, nin duwen samworo men. Kisehn peneineien samworo kante me kak iang tungoale pwaise. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Ma aramas emen me kaidehk kisehn peneineien samworo pahn tungoalehda meirong sarawi kan ni eh sohte nsenki, e pahn kapwungohng samworo pweinen meirong sarawio oh kapataiong persent 20. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Samworo kan sohte pahn kasaminehla meirong sarawi kan ");
INSERT INTO pon2006a_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ni ar pahn mweidohng aramas emen me sohte mweimweiong en iang tungoale; pwe met pahn kahrehda aramaso eh pahn dipikihda oh ale kalokepe. Ngehi me KAUN-O me kin kasarawihala meirong pwukat.” ");
INSERT INTO pon2006a_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","KAUN-O ketin mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","en padahkihong Aaron oh nah pwutak ko oh ong mehn Israel koaros kosonned pwukat. Ansou me mehn Israel men de mehn liki men me kin kousoan nan Israel pahn wia meirong isihs, pwehn kapwaiada inou ehu de wia meirong sang ni pein nsene, sohte kisin samin kis pahn mie rehn mahno. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Pwe KAUN-O en kak kupwurehla meirongo, e pahn mihmi ni mahn wol oh sohte kisin samin kis reh. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ma kumwail meirongki mahn emen me mie kisin samin kis reh, KAUN-O sohte pahn ketin kupwurehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ma emen pahn wiahda meirong en kaminimin ong KAUN-O, pwehn kapwaiada inou ehu de pwe en wia sang ni pein nsene, sohte pahn kisin samin kis rehn mahno, pwe KAUN-O en ketin kupwurehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kumwail dehr meirongkihong KAUN-O mahn emen me maskun de nehtuk de ohla ni paliwere, de kens, de tepwasang kili de ripwiripw. Kumwail dehr meirongki soangen mahn pwukat pohn pei sarawio nin duwen meirong en konot. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Kumwail kak meirongki mahn emen me sohte unsek de pakalong nin duwen meirong en nsen, ahpw KAUN-O sohte pahn kupwurehla pwehn wia meirong mehn kapwaiada inou. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Kumwail sohte pahn meirongkihong KAUN-O mahn me wisole mwutpene, lekasang, ohla, de pwal. Met sohte mweimweiong en wiawi nan sapwamwail. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Kumwail dehpa wiahki meirong en konot mahn emen me kumwail ale sang rehn mehn liki kan. Soangen mahn pwukat me samin oh KAUN-O sohte pahn ketin kupwurehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","27","Ahnsou me kou men de sihpw men pahn kin ipwidi, e sohte pahn katohrohrasang rehn eh nohno erein rahn isuh, ahpw mwurin rahn isuh e kakehr wia mehn meirong en konot me KAUN-O pahn ketin kupwurehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Kumwail sohte pahn meirongki kou men oh naho, de sihpw men oh naho de kuht men oh naho rahnteieu. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Ahnsou me kumwail pahn wia meirong en kapingkalahngan ong KAUN-O, kumwail kapwaiada kosonned pwukat pwe KAUN-O en kin ketin kupwurehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Eri, kumwail pahn kin tungoale rahnohte, sohte mehkot pahn luhwehdi ong mandahn rahno. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","KAUN-O ketin mahsanih, “Kumwail kapwaiada ei kosonned akan. Ngehi me KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Kumwail dehr kasaminehla mwarei sarawi; mehn Israel koaros pahn pohnese duwen ei sarawi. Ngehi me KAUN-O me kasarawihkumwailla. ");
INSERT INTO pon2006a_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ngehi me kahreikumwaildo sang Isip, pwe I en wiahla amwail Koht. Ngehi me KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","KAUN-O ketikihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","kosonned en sarawi pwukat ni ahnsou me mehn Israel kan pahn kin pokonpenehn wia kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Rahn weneu kumwail pahn doadoahk, kumwail ahpw tamataman pwe keisuhn rahn, iei rahnen Sapad, iei rahnen kommoal. Rahno kumwail pahn kin pokonpene ong kaudok. Pwe KAUN-O me ketin sapwellimaniki rahnen Sapad, sohte lipilipil wasa kumwail pahn mi ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Eri, iet kan soangen sarawi kan me kumwail pahn kin wia ni ahnsou me kileldi kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Pahsohpa, sarawi me kin wiawi pwe en wauneki KAUN-O, kin tepida ni ketipin eh pahn kihrla ni eisek pahieun rahnen tepin sounpwong. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Eri, Sarawien Pilawa sohte Doal Ihs pahn kin tepida ni eisek limaun rahnen sounpwongo; erein rahn isuh kumwail sohte pahn tungoale pilawa me doal ihs. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ni keieun rahn, kumwail pahn pokonpene ong kaudok; sohte doadoahk ehu pahn wiawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Kumwail pahn wia amwail meirong en konot ong KAUN-O erein rahn isuh. Eri, ni keisuhn rahn, kumwail pahn pwurehng pokonpene pwe kumwail en wia amwail kaudok, oh sohte doadoahk ehu pahn wiawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","10","Ni amwail pahn pedolong nan sahpw me KAUN-O pahn ketikihong kumwail oh dolung wahnsapwamwail, kumwail pahn mwowehiong samworo kan tepin wahnsapwamwail kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Samworo eri pahn patohwandahng wahnsahpw ako ong KAUN-O nin duwen meirong tohrohr ehu, pwe kumwail en ale kupwuramwahu. Samworo pahn wia met ni rahn mwurin rahnen Sapad. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ni rahnohte, emen sihpw wol me mahkier sounpar ehu oh sohte kisin samin kis reh pahn pil wia meirong isihs ong ni mwaren KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Kumwail pahn pil iangahki paunen pilawa pahiu doal lehn olip, mehn wia meirong en konot. KAUN-O kin ketin kupwurperenki pwohn soangen meirong wet. Eri, pahkis ehun kalon en wain pahn pil iang meirong en pilawao. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Kumwail sohte pahn tungoale pilawa amas, pilawa roang, de pilawa umwda, kumwail lao pahn mwowehiong Koht tepin wahnsapwamwail. Kosonned wet pahn poatopoat erein dih koaros me pahn kohdo. Eri, kadaudokamwail kan koaros pil pahn kapwaiada. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Eri, kumwail pahn wadek wihk isuh unsek sang ni keieun rahn mwurin rahnen Sapado me kumwail mwowehiong KAUN-O wahnsapwamwail kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ni kelimeisek en rahn, mwurin rahnen Sapad keisuh, kumwail pahn kihda pil ehu meirong kapw en wahnsapwamwail kan ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ehuehu peneinei pahn wahdo lopwon en pilawa riau oh meirongkihong KAUN-O nin duwen kisakis tohrohr ehu. Ehuehu lopwon pwukat pahn wiawikihda paunen pilawa pahieu, doal ihs oh umwda; oh pahn meironglahng KAUN-O nin duwen meirong en tepin wahnsahpw. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Eri, mehn Israel kan pahn iangahki pilawa pwukat sihmpwul isimen, kouwol emen, oh kuht riemen, me sohte kisin samin kis rehrail. Kumwail pahn wiahki mahn pwukat ehu meirong isihs ong KAUN-O, iangahki meirong en konot oh pil meirong en wain. KAUN-O kin ketin kupwurperenki pwohn soangen meirong wet. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Kumwail pahn pil meirongkihla emen kuht wol ong ni meirong en dihp oh sihmpwul wol riemen me sounpar ehu ong ni meirong en kaminimin. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Samworo pahn patohwandahng KAUN-O pilawa ko iangahki sihmpwul riemeno pwe en wia kisakis tohrohr ehu ong KAUN-O pwe en kohieng samworo ko. Meirong pwukat me uhdahn sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Rahno kumwail sohte pahn wia amwail doadoahk en rahn koaros, ahpw kumwail pahn pokonpene pwe kumwail en wia kaudok. Eri, kadaudokamwail kan pahn kin kapwaiada kosonned pwukat erein dih koaros me pahn kohdo, sohte lipilipil wasa re pahn kin kousoan ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Ni amwail pahn dolung wahn amwail mwetuwel kan, kumwail dehr pelehsang wahnsahpwo lel ni irepen mwahto, pil dehr rikpene luhwen wahnsahpwo; kumwail mweidalahng kenen me semwehmwe kan oh mehn liki kan. KAUN-O, iei amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","Ni keieun rahnen keisuhn sounpwong kumwail pahn wiahki rahnen kommoal kesempwal ehu, oh pokonpene pwe kumwail en wia kaudok ni ahnsou me kumwail pahn rong ngilen sowi kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Kumwail pahn patohwandahng KAUN-O amwail meirong en konot oh sohte me pahn doadoahk rahno. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","27","Ni kaeisek en rahnen keisuhn sounpwong, iei rahn me nan sounpar koaros me tiahk sarawi ehu pahn kin wiawi, eri, tiahk en lapwahsang dipen aramas akan. Kumwail pahn kaisihsol ni rahno; oh pokonpene ong kaudok oh wia meirong en konot ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Kumwail sohte pahn doadoahk rahno, pwehki eh wia rahnen tiahk sarawien lapwapen dihp. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Mehmen me pahn tungoale mehkot rahno, e sohla pahn wia kisehn sapwellimen Koht aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Oh ma emen pahn doadoahk ni rahno, pein KAUN-O pahn ketin kemehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Kosonned wet pahn doke kadaukokamwail kan koaruhsie, sohte lipilipil wasa re kin koukousoan ie. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Sang ketipin eh kin kihrla ni rahn keduwaun sounpwongo lel ni kihrlahn ketipin ni rahn kaeisek, kumwail pahn wiahki rahno rahnen kommoal kesempwal ehu, iei rahnen kaisihsol. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","34","Sarawien Impwal kan pahn kin tepida ni rahn kaeisek limaun keisuhn sounpwong, oh e pahn kin wereiki rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ni keieun rahn pwukat kumwail pahn pokonpene ong kaudok oh sohte doadoahk pahn wiawi. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Rahn koaros erein rahn isuho, kumwail pahn kin wia meirong en konot. Ni kawaluhwen rahn kumwail pahn pwurehng pokonpene ong kaudok oh wia meirong en konot. Rahnen kaudok ehu met; eri, kumwail sohte pahn doadoahk. (");
INSERT INTO pon2006a_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Ih rahn pwukat me kin wia rahn sarawi lapalap, me kumwail pahn kin wauneki Koht ni amwail pahn kin pokonpene ong kaudok oh wia meirong en konot, meirong isihs, wahnsahpw, oh wain, nin duwen anahnepen rahn akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Sarawi pwukat eri pahn kapatapatehng rahnen Sapad teikan, oh meirong pwukat pil pahn kapatapatehng amwail meirong me kumwail kin epwehnki wia, oh meirong kan mehn kapwaiada amwail inou kan, oh pil meirong kan me kumwail pil kin wiahiong KAUN-O sang ni pein nsenamwail.) ");
INSERT INTO pon2006a_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Ni rahn kaeisek limaun keisuhn sounpwong, ni amwail pahn dolungehr wahnsapwamwail kan, kumwail pahn kin wia sarawi wet erein rahn isuh. Eri, keieun rahn pahn wia rahn kesempwal en kommoal. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ni rahno kumwail pahn ale ekei wahn amwail tuhke kan me keieu mwahu, oh tehnpaini, pil tehntuhke sang nin tuhke kan; kumwail ahpw pahn tapihada sarawien wauneki KAUN-O, amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Eri, kumwail pahn kin wia sarawi wet erein rahn isuh. Kosonned wet pahn kin poatopoat rehn kadaudokamwail kan erein dih koaros me pahn kohdo. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Mehn Israel koaros pahn kin kousoan pahn mwetehn impwal pwukat erein rahn isuh, ");
INSERT INTO pon2006a_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","pwe kadaudokamwail kan en ese me KAUN-O me ketin kupwurehda pwe aramas en Israel kan en kin kousoan pahn mwetehn impwal kan ni eh ketin kahluwahdo sang irail nan Isip. Iei ih me KAUN-O, amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Eri, iei duwen met Moses eh kihong mehn Israel ko kosonned kan duwen sarawi kan me re pahn kin wia pwe re en wauneki KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","en padahkihong mehn Israel ko, re en wahdo leh kaselel en olip ong lamp akan en Impwalo, pwe re en kin ngkengken poatopoat. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Nin soutik koaros Aaron pahn kin isikada pwe re en kin ngkengken lao lel nimenseng, mwohn silangin KAUN-O likin kahdengo mwohn Kohpwahn Inowo, me mihte nan Wasa Sarawiheo. Kosonned wet pahn kin poatopoat kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aaron me pahn kin apwalih lamp akan me mi ni dewen lamp kohlo, oh pahn kin tetehk pwe re en kin ngkingkente mwohn silangin KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Ale paun 24 en pilawa oh umwunda lopwon en pilawa eisek riau. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Kairakihala lopwon en pilawa ko ni kahng riau, lopwon weneu ni ehu kahng, oh pwilikihdi pohn tehpel kohlo mwohn silangin KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Kihdiong pohn ehuehu kahng en lopwon en pilawa ko warpwohmwahu kaselel pwehn wia kilel en meirong en konot ong KAUN-O, iei me pahn wiliandi pilawa. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Rahnen Sapad koaros sang met kohla, pilawa wet pahn kin pwilidi mwohn silangin KAUN-O. Met iei pwukoahn mehn Israel kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Pilawa wet iei pweisen Aaron oh kadaudoke kan, oh re pahn tungoale wasa sarawi ehu, pwehki iei kisehn meirong en konot me keieu sarawihe, meirong en konot ong KAUN-O pwe samworo kan en kin tungoale. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Mie ohl emen me eh pahpa mehn Isip, a eh nohno mehn Israel, liho adaneki Selomid, nein Dipri, kisehn kadaudok en Dan. Ohl menet akamaiong mehn Israel men nan kahnimpwalo, e ahpw lahlahwe mwaren KAUN-O. Aramas ako eri walahng ohlo rehn Moses, ");
INSERT INTO pon2006a_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","oh kihong silepe, re ahpw awiawih lao KAUN-O pahn ketin koasoanehdi dahme pahn wiawihong. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","KAUN-O eri ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Ale aramas en wahieila likin kahnimpwalen. Koaros me rongehr eh lahlahwe pahn kidahng pohn moange pehrail kan mehn wia kadehdehpen eh lahlahwe, re ahpw pahn katehki takai e lao mehla. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Pil padahkihong mehn Israel kan me, ‘Mehmen pahn kin lahlahwe Koht, pahn ale kalokepe, ");
INSERT INTO pon2006a_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","oh pahn kamakamala.’ Aramas koaros pahn katehki takai oh kemehla mehn Israel de mehn liki men me kin kousoan nan Israel me pahn lahlahwe KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Mehmen me pahn kemehla aramas emen, pahn kamakamala, ");
INSERT INTO pon2006a_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","oh mehmen me pahn kemehla nein emen mahn, e pahn wilianla mahno. Poahsoan en ire wet pwe mour ong mour. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Mehmen me pahn kauwehla emen aramas, soahngohte me e wiahiong aramas ohlao, ihme aramas ohlao pahn pil wiahiong. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Ma e katipw apwoat tih, apwoat tih pahn pil katipwitimwpeseng; ma e kihsang apali pwoaren mesen emen, apali pwoaren mese ko pahn kohsang. Ma e kauwehla ngihn emen, apwoat ngih pahn usuhssang. Soangen ohlaohte me emen wiahiong emen, ihme pahn pil wiawihong. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Mehmen me pahn kemehla mahn emen, e pahn kapwungala, ahpw mehmen me pahn kemehla aramas emen, pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Kosonned wet doke kumwail koaros, mehn liki oh mehn Israel kan. Ngehi me KAUN-O, amwail Koht.” ");
INSERT INTO pon2006a_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mwurin Moses eh patohwanohng koasoandi pwukat ong mehn Israel ko, re ahpw wahieilahng ohl me lahlahweo likin kahnimpwalo oh katehki takai e lao mehla. Iei duwen mehn Israel ko ar kapwaiada dahme KAUN-O ketin mahsanihong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","KAUN-O ketin mahsanihong Moses nin Nahna Sainai ");
INSERT INTO pon2006a_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","en padahkihong mehn Israel ko kosonned pwukat. Ni amwail pahn pedolong nan sahpw me KAUN-O pahn ketikihong kumwail, kumwail pahn wauneki KAUN-O ni amwail sohte pahn koadoahki sahpwo ni keisuhn sounpar koaros. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Erein sounpar weneu kumwail kak padok tuhke nan amwail mwetuwel kan, kamwakelehsang rahn amwail tuhkehn wain kan, oh dolung wahnsahpw akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ahpw keisuhn sounpar pahn wia sounpar en kommoal unsek ong sahpwo, sounpar me pahn kasarawihong KAUN-O. Kumwail sohte pahn padok mehkot nan mwetuwel de kamwakele rahn amwail tuhkehn wain kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Kumwail sohte pahn pil rikpene werentuhke kan me kin pein wosada, de pil wahntuhke en wain akan me rah kan sohte kamwakel; pwe sounpar en kommoal douluhl ehu ong sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Mehnda ma kumwail sohte padok mehkot nan sahpwo erein sounparo, e pahn kihong kumwail amwail tungoal kisin mwenge, oh ong amwail lidu kan, toundoadoahk kan, oh ong mehn liki kan me koukousoan rehmwail, ");
INSERT INTO pon2006a_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","noumwail pelinmen kan, oh mahn lawalo kan nan sapwamwail kan. Soahng koaros me sahpwo pahn kapwarehda, kak wiahla mehn tungoal. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Wadek sounpar isuh pak isuh, wiahda sounpar pahisek duwau. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Mwuri, ni kaeisek en rahnen keisuhn sounpwong, Rahnen Tomw, kadarowei ohl emen pwe en peuk sowi nan sahpwo pwon. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ih duwen met amwail pahn katorehla sounpar kalimeisek wet oh lohkihda saledek ong tohn sahpwo koaros. Nan sounpar wet sahpw akan koaros me netlahr pahn kapwurupwurlahng aramaso me uhdahn sapweniki sahpwo, de kadaudoke kan; oh aramas akan me netlahr nin duwen lidu pahn pwuralahng rehn arail peneinei. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Kumwail sohte pahn padokedi mehkot nan sapwamwail kan, de dolung werentuhke me kin pein wosada de rikpene wahn wain nan amwail mwatin wain me rah kan sohte kamwakelda. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Sounparo pwon pahn wia ahnsou sarawi rehmwail. Ihte me kumwail pahn kak tungoale, wahnsahpw me kin pein osada. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Nan sounpar wet sahpw koaros me netlahr pahn kapwurupwurlahng aramas me uhdahn sapweniki sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Eri, ni amwail pahn netikihla sahpw rehn mehn Israel men de pwainsang, kumwail loaloapwoatpene dehr mwersuwed. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Pweinen sahpw pahn koasoansoandi nin duwen sounpar akan me sahpwo kak wa mwohn Sounparen Onohndasapahlo. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ma sounpar akan me tohto, pweine pahn laud, ahpw ma sounpar akan me malaulau, pweine pahn tikitik, pwe dahme pahn netla iei tohtohn wahnsahpw me sahpwo kak kihda. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Eri, kumwail dehr kin kapweipwei riamwail mehn Israel kan, ahpw kumwail en wauneki oh peikiong KAUN-O amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Kumwail kapwaiada sapwellimen KAUN-O kosonned oh koasoandi kan koaros, pwe kumwail en onepek nan amwail mour nan sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Sahpwo pahn kihda wah kan, oh kisin tungoal pahn itarohng kumwail, eri kumwail pahn onepek nan amwail mour. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ahpw ele emen rehmwail kak patohwan idek dahme aramas pahn tungoale ni keisuhn sounpar, ma sohte mehkot poadidi oh wahnsahpw sohte rikirikpene. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","KAUN-O pahn ketin kupwuramwahwih sahpwo ni keweneu en pahr pwehn kak kihda me pahn itarohng sounpar riau. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Ni ahnsou me kumwail pahn padokedi mehkot nan sapwamwail ni kawaluhn sounpar, kumwail pahn tungutungoalehte dahme kumwail dolung ni kaweneu en sounparo, eri e pahn mie kisin tungoal me pahn itar lao kumwail dolung wahnsahpw me kumwail padokedi nan pahro. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Sapwamwail kan sohte pahn netla kohkohlahte; pwe kaidehk sapwamwail, pwe uhdahn nin limen Koht. A kumwail rasehng mehn liki kei me mweimweiong en kohwahki. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Ni ahnsou me peliensapw ehu pahn netla, kumwail pahn pohnesehki pwungen aramas me uhdahn sapweniki pwe en pwurehng pwainda. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Ma mehn Israel men pahn semwehmwehla oh idihdohng en netikihla sapwe, kiseh me keieu karanih pahn pwainda pwehn kapwurehdo. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ahpw ma aramaso sohte kiseh me pahn pwainda oh kapwurehdo sahpwo, eri ni eh pahn paiamwahula mwuhr e pahn kak pwurehng pein pwainda oh kapwurehdo sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Ahpw e pahn pwainehng aramas me pwainsango uwe ieu me pahn kadokehla luhwe mwohn Sounparen Onohnsapahlo, ahnsou me e uhdahn pahn pwurehng sapweo. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ahpw ma sohte nah mwohni me itar en kapwurehdo sahpwo, sahpwo pahn mihmihte pahn manaman en aramas me pwaindao lao lel Sounparen Onohnsapahlo. Nan sounparo sahpwo pahn kapwurupwurlahng rehn me uhdahn sapwenikio. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Ma aramas emen netikihla imwe me mi nan kelen kahnimw ehu, mie eh pwungen pwainda sapahl erein pahr ehu pwon sang ni ahnsou me e netikihlao. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ahpw ma e sohte pwainda sapahl nan sounparo, e solahr ahneki pwungen pwainda sapahl oh imwo pahn wiahla uhdahn imwen me pwaindao oh kadaudoke kan. E sohte pahn kapwurupwurla nan Sounparen Onohnsapahlo. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ahpw ihmw kan me sohte mi nan kehl, pahn duwehte sahpw akan; me aramas me uhdahn sapweniki sahpwo ahneki pwungen pwurehng pwainda; oh sahpwo pahn kapwurupwurlahng aramas me uhdahn sapwenikio nan Sounparen Onohnsapahlo. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Ahpw mehn Lipai kan ahneki pwung ahnsou koaros en pwainda sapahl ihmw kan me uhdahn imwarail nan arail kahnimw kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ma mehn Lipai men pahn netikihla ihmw ehu nan kahnimw pwukat oh ihmwo sohte pweipweida sapahl, e pahn kapwurupwurla nan Sounparen Onohnsapahlo, pwehki ihmw kan me mehn Lipai kan kin imwaneki nan kahnimw kan uhdahn imwarail kohkohlahte rehn mehn Israel kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ahpw mohs kan me mihmi limwahn ar kahnimw kan, sohte pahn kak netla; pwe uhdahn arail sohso kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Ma riomw mehn Israel men me kin kousoan limwahmw semwehmwehla oh sohte kak pein kamakamour ih, ke pahn sewese duwen omw pahn sewese noumw tohndoadoahk, pwe en kak koukousoante limwahmw. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ke dehr kihong en pwain wihn en mwohni me ke kihongehr, ahpw peikiong Koht oh mweidohng riomw mehn Israelo en koukousoante limwahmw. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Dehr itonehng en pwainla wihn en mwohni me ke kamangaiong, pil dehr kihong wihn ni kisin tungoal me ke netikihong. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Iei met ehu koasoandi en KAUN-O amwail Koht me ketin kahreikumwaildo sang Isip, pwehn ketikihong kumwail wehin Kenan oh en wiahla amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Ma riomw mehn Israel men me kin kousoan limwahmw pahn semwehmwehla kahrehda eh men pangala pein ih rehmw oh wiahla omw lidu, ke sohte pahn kihong en wia doadoahk en lidu. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","E pahn mihmi rehmw duwen tohndoadoahk men oh wie doadoahk rehmw lao lel Sounparen Onohnsapahlo. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Ni ahnsowo ih oh nah seri kan pahn pedoisang rehmw oh pwuralahng nan eh peneinei oh nan sapwen eh pahpa kalahp ako. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Mehn Israel kan iei sapwellimen KAUN-O lidu, oh ih me kahreiraildo sang Isip; iei me irail sohte pahn netla wiahla lidu. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ke dehr wiakauwe irail, ahpw peikiong omw Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Ma kumwail anahne lidu, kumwail kak pwainsang nan wehi kan me kapilkumwailpene. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Kumwail pil kak pwainda nein mehn liki kan me kin kousoan rehmwail neirail seri kan. Soangen seri me ipwidi nan sapwamwail, kumwail kak nainekihla, ");
INSERT INTO pon2006a_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","oh noumwail seri kan pahn uhd sohsohkin irail oh irail pahn papah noumwail kan erein ar mour. Ahpw kumwail dehr wiakauwe riamwail mehn Israel kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Ma mehn liki men me kin kousoan rehmwail pahn kepwehpwehla, nindokon riamwail mehn Israel men semwehmwehla oh pangala pein ih rehn mehn liki kepwehpweo pwehn wiahla eh lidu, de pil rehn kisehn mehn likio pwehn wiahla eh lidu, ");
INSERT INTO pon2006a_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","mwurin eh netlahr, e ahnekihte pwungen pweipweida sapahl. Emen rie, ");
INSERT INTO pon2006a_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","de rien eh pahpa, de nein rien eh nohno de emen kiseh me karanih mehlel, kak pwainda sapahl; de ma pein ih kak koadoahkihada mwohni me pahn itar en pein pwainda eh saledek. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","E pahn tuhkihong ire wet aramas me pwainda ih, ira ahpw pahn wadek sounpar akan sang ahnsou me e pein netikihla pein ih pwehn wiahla lidu, lao lel Sounparen Onohnsapahlo, ira pil pahn koasoanehdi uwen pweinen kasaledekla nin duwen pweinen tohndoadoahk men. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","52","E pahn kapwurehla uwen pweinen kasaledekla nin duwen pahr me luhwe kan, ");
INSERT INTO pon2006a_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","duwehte ma e doadoahngki erein sounpar ehu. E soumaso sohte pahn wiakauwe. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ma e sohte ale saledek ni ehu soangen ire pwukat, ih oh nah seri kan uhdahn pahn saledekla nan Sounparen Onohnsapahlo. ");
INSERT INTO pon2006a_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Mehn Israel men sohte kak wiahla lidu kohkohlahte, pwehki mehn Israel kan iei sapwellimen Koht lidu kei. Ih me ketin kahreiraildo sang Isip; ih me KAUN-O arail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","KAUN-O ketin mahsanih, “Kumwail dehr wiahiong kumwail mwomwen koht likamw akan, de dikedik en eni, de sansal takai de uhr takai, de takai sukusukda pwe kumwail en pwongih. Ngehi KAUN-O amwail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Kumwail kapwaiada sarawi kan, oh wauneki wasa aramas kin kaudokohng ie. Ngehi me KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Ma kumwail pahn kin momourki ei kosonned akan oh kapwaiada ei koasoandi kan, ");
INSERT INTO pon2006a_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","I pahn kin kadaridiong kumwail keteu ni ahnsou mwahu, pwe sapwamwail kan en kin kihda wahnsahpw mwahu oh en kin mie wahntuhke kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Wahn sapwamwail kan pahn rekla mehlel oh kumwail pahn dondolung werentuhke kan lao lel ni ahnsoun rikada wahn wain, oh kumwail pahn rikirik wahn wain lao lel ahnsoun kamwarak werentuhke. Kisin tungoal pahn itarohng kumwail, oh kumwail pahn onepek mwahu nan sapwamwail. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“I pahn kihong kumwail popohl nan sapwamwail, kumwail pahn kin memeir oh sohte masak mehmen. I pahn karawansang nan sapwamwail kan mahn keper kan oh sohla mahwen pahn wiawi wasao. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Kumwail pahn kin powehdi amwail imwintihti kan; ");
INSERT INTO pon2006a_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","mehte limmen rehmwail pahn kak kalowehdi epwiki rehrail, oh me epwiki rehmwail kak kalowehdi nen. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","I pahn kapaiakumwailda oh katohtohwehla noumwail seri kan. I pahn kapwaiada ei inou me I wiahiong kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Wahn sapwamwail me kumwail pahn dolung pahn inenen rek, oh kumwail pahn tungutungoale erein sounpar ehu, eri, kumwail pahn kesehla luhwe ko pwehn wiliankihdi wahnsahpw kapw. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","I pahn kin mihmi nan ei Impwal sarawio rehmwail, oh I sohte mwahn pahn sohpeisang kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","I pahn kin ieiang kumwail, I pahn wiahla amwail Koht, oh kumwail pahn wiahla nei aramas. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ngehi me KAUN-O amwail Koht, me kahreikumwaildo sang Isip, pwe kumwail en dehr wia lidu. I kauwehla manaman me katoutouwih kumwailla oh mweidohng kumwail en inenda oh saledek weweidwei.” ");
INSERT INTO pon2006a_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","KAUN-O ketin mahsanih, “Ahpw ma kumwail sohte pahn kapwaiada ei kosonned akan, kumwail pahn ale lokolok. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Ma kumwail pahn kahng kapwaiada ei kosonned akan oh koasoandi kan oh kauwehla inou me I wiahiong kumwail, ");
INSERT INTO pon2006a_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","I pahn kalokei kumwail. I pahn kihong kumwail nan soangen lokolok kei duwehte—soumwahu me sohte kak mwahula, oh karakar me pahn kahrehiong kumwail amwail pahn maskunla oh lupukala amwail mour. Kumwail pahn koadoahki sapwamwail kan, ahpw sohte pahn katepe, pwe amwail imwintihti kan pahn kaloweikumwaildi oh kangasang wahn sapwamwail kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","I pahn sohpeisang kumwail pwe kumwail en lohdi oh irail me kin kailongkin kumwail re pahn kaunkumwailda; kumwail pahn masepwehkada kouwahlap oh pahn tang ni eh sohte mehmen me pwakipwakih kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Ma pil mwurin mepwukat, kumwail sohte pahn peikiong ie, I pahn kalaudehla amwail kalokolok pak isipak. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","I pahn kauwehla amwail keptakaiki amwail aklapalap; keteu sohla pahn mweredi, sapwamwail kan pahn madekengda oh kekeluwakala duwehla mete. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Amwail doadoahk kehlail koaros sohla pahn katepe, pwehki eh pahn sohla wahn sapwamwail kan oh sohla wahn amwail mwetuwel kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Ma kumwail pahn pil usehlahte nan amwail aklapalap oh sohte men peikiong ie, I pahn pil pwurehng kalaudehla amwail kalokolok pak isipak. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","I pahn kadarowohng kumwail mahn keper me pahn kemehla noumwail seri kan, kamwomwala noumwail pelinmen kan, oh kumwail pahn malaulaula oh sohla pahn mie moahl en aramas pohn ahl akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Ma mwurin kalokolok pwukat, kumwail pil duweduwehte sohte rong ie, ahpw usehlahte amwail uhwong ie, ");
INSERT INTO pon2006a_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","eri I pahn sohpeiong kumwail oh kalokei kumwail pak isipak, uksang mahs. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","I pahn kidohng kumwail mahwen pwe I en kalokehkin kumwail amwail kauwehla atail inou, oh ma kumwail pahn pokonpene nan kahnimw kan pwehn rukusang ie, I pahn kadaridiong kumwail soangen soumwahu me sohte kin mwahula, kumwail ahpw pahn peki mahk rehn amwail imwintihti kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","I pahn lupukala reken kisin mwenge kan, eri lih ehk pahn doadoahngkipene wasahn umwun pilawa ehu, pwe re en umwunda uwen pilawa me mie rehrail. Re pahn nehkohng kumwail, oh mwurin amwail pahn tungoalehla, kumwail pahn pil men mengehda. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Ma mwurin mepwukat koaros, kumwail pil usehlahte amwail kahngohdiong ie oh sohte men peikiong ie, ");
INSERT INTO pon2006a_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","eri nan ei engieng, I pahn sohpeiong kumwail oh kalokei kumwail pak isipak, uksang mahs. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Amwail duhpek pahn ukla mehlel oh kumwail pahn kangala noumwail seri. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","I pahn kamwomwala wasahn amwail kaudok kan pohn dohl akan, karangkehdi amwail pei sarawien warpwohmwahu kan oh kesepwekelahng kahlepamwail kan pohn mwomwen dikedik en eni kan me wonohn nanpwel. Nan ei sautkinkumwaillahr, ");
INSERT INTO pon2006a_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","I pahn kamwomwala amwail kahnimw kan oh kauwehla wasahn amwail kaudok kan, oh I sohte pahn kupwurehla amwail meirong kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","I pahn kamwomwala douluhl sapwamwail kan, amwail imwintihti kan me kin kousoanla ie pahn pwuriamweikihla soangen mwomwla wet. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","I pahn wadohng kumwail mahwen oh kamwarak kumwailpeseng nan wehin liki kan. Sapwamwail kan pahn tehnla oh amwail kahnimw kan pahn mwomwla. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Sahpwo eri pahn nsenamwahukihla eh pahn kommoaldi douluhl, kommoal me kumwail sohte kihong; oh pahn wonohn komkommoal nindokon amwail pahn kalipilipala oh mihmi nan sapwen amwail imwintihti kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“I pahn kamasak kumwail me kalipilipala kan, pwe kumwail en kin tangdoaui, ni amwail pahn kin rong kisin ngilen tehntuhke kis ni kisinieng eh pahn kin ipir. Kumwail pahn kin tang duwehte ma kumwail tangatangasang amwail imwintihti kan nan mahwen oh kumwail pahn pwupwudi ni eh sohte imwintihti men limwamwail. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Kumwail pahn pwumpwupw kohwei pohn emenemen kumwail ni eh sohte me pwakipwakih kumwail, oh kumwail sohte pahn kak mahweniong amwail imwintihti kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Kumwail pahn mehla nindokon amwail mihmihte wasa kumwail kalipilipalahng ie; sapwen amwail imwintihti kan pahn kadalleikumwailla. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Me malaulau rehmwail pahn mourla nan sapwen amwail imwintihtih oh re pahn sosohrala pwehki pein dipamwail kan oh dipen amwail pahpa kahlap ako. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Ahpw kadaudokamwail kan pahn sakarkihda diparail kan oh dipen arail pahpa kahlap ako, me uhwong ie oh kahngohdiong ie, ");
INSERT INTO pon2006a_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","me kahrehda I sohpeisang irail oh kalipeiraillahng nan sapwen arail imwintihti kan. Mwuri, kadaudokamwail ko ahpw aktikitikla oh koluhkihla oh kapwungala diparail kan oh ar kahngohdi, ");
INSERT INTO pon2006a_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","I pahn tamanda ei inou ong Seikop, Aisek oh Eipraam, oh I pahn onehda sapahl ei inowo me I pahn kihong aramas akan sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ahpw keieu, sahpwo pahn koakoahsang towe kan, pwehn kak kommoaldi douluhl, oh re pahn ale kalokolok pwehki ar soikala ei koasoandi oh kosonned akan. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ahpw ni ar pahn mihmihte nan sapwen ar imwintihti kan, I sohte pahn keseirailla doulluhl de kamwomwirailla. Pwe met pahn kaimwisekala ei inou ong irail. Ngehi me KAUN-O arail Koht. ");
INSERT INTO pon2006a_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","I pahn onehda sapahl inou me I wiahiong ar pahpa kahlap ako, ni ei kasalehiong wehi koaros ei manaman ni ei kahrehdohsang nei aramas sang Isip, pwe ngehi me KAUN-O, I en wiahla arail Koht.” ");
INSERT INTO pon2006a_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ih koasoandi oh kosonned pwukat koaros me KAUN-O ketikihong Moses nin Nahna Sainai pwe en patohwanohng mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","KAUN-O ketikihong Moses kosonned pwukat ");
INSERT INTO pon2006a_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","pwehn padahkihong mehn Israel kan. Ni aramas emen eh pahn wiahla mehn meirong ong KAUN-O pwehn kapwaiada inou kesempwal ehu, aramaso pahn kak kasaledekla ni eh pahn pweipweikihda uwen mwohni me pahn sansal pah, ");
INSERT INTO pon2006a_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","7","nin duwen me koasoandier: -ohl, sounpar rieisek lel weneisek: mwohni silper 50 -lih: mwohni silper 30 kisin pwutak, sounpar limau lel rieisek: mwohni silper 20 -kisin serepein: mwohni silper 10 -seri pwelel pwutak, pahnangin sounpar limwau: mwohni silper 5 -seri pwelel serepein, mwohni silper 3 -ohl pohnangin sounpar weneisek: mwohni silper 15 -lih pohnangin sounpar weneisek: mowhni silper 10 ");
INSERT INTO pon2006a_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ma aramas me wiahda inowo me semwehmwe mehlel oh sohte kak pwainla pweipwei me koasoandier, e pahn kahrehdo aramaso rehn samworo, oh samworo pahn koasoanehdiong uwen pweipwei ehu me tikitik, uwen me e pahn kak pwainkihla eh meirongo. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Ma inowo pid mahn emen me pahn wia meirong ehu me pahn kaparanda kupwuren KAUN-O, eri meirong koaros ong KAUN-O pahn wia mehkot sarawi, ");
INSERT INTO pon2006a_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","oh aramas me wiahda inowo sohte kak wiliankihda meirongo emen mahn tohrohr. Ma e pahn wiahda met, mahn riemeno koaros pahn wiahla sapwellimen KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ahpw ma inowo pid mahn emen me samin ong kaudok, me sohte pahn kaparanda kupwuren KAUN-O, aramaso pahn walahng mahno rehn samworo. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Samworo ahpw pahn koasoanehdi uwen pweinen mahno me pahn konehng mwomwen mahno ma e mwahu de mwomw suwed, oh pweipwei me samworo kilelehdi ihme pahn doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ma aramaso men pwurehng pwainda sapahl mahno, e pahn kihda uwen pweine iangahki persent 20. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Ahnsou me aramas emen pahn kasarawihong KAUN-O imwe, samworo pahn kilelehiong pweine nin duwen mwahu de suwed en ihmwo oh pweipweio iei me pahn doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ma aramas me kasarawiher imweo men pwurehng pwainda sapahl, e pahn kihda uwen pweine iangahki persent 20. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Ma aramas emen pahn kasarawihong KAUN-O ekis wasa nan sapwe, pweine pahn koasoandi nin duwen tohto en werentuhke me e kamwarakdi ong loale, ni mwohni silper eisek ong ehu kapakap en parli. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ma e kasarawihong KAUN-O sahpwo mwurinte Sounparen Onohnsapahlo, e pahn kihda pweine unsek. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ma e kasarawihong KAUN-O sahpwo ahnsou ehu mwuri, samworo pahn koasoanehdi uwen pweine me pahn konehng lel ni Sounparen Onohnsapahlo. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ma aramas me kasarawiher sahpwo men pwurehng pwainda sapahl, e pahn kihda pweine iangahki persent 20. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ma e netikihla sahpwo rehn emen, ni eh sohte pwurehng pwainda sapahl sang KAUN-O, e sohla pahn ahneki pwungen pwainda sapahl. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ni eh pahn lel ni Sounparen Onohnsapahlo, KAUN-O pahn ketin nin limanikihla douluhl sahpwo; e pahn kohieng samworo kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Ma aramas emen pahn kasarawihong KAUN-O peliensapw ehu me e pwainda, ");
INSERT INTO pon2006a_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","somworo pahn koasoanehdi uwen pweine me konehng tohtohn sounpar lel Sounparen Onohnsapahlo, oh aramaso pahn pwainla sahpwo rahnohte; oh KAUN-O me pahn sapwellimaniki mwohnio. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ni Sounparen Onohnsapahl, sahpwo pahn kapwurupwurdohng me tepin sapweniki, de kadaudoke kan. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Pweinen sahpw koaros pahn koasoandi nin duwen me koasoandier. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","KAUN-O me sapwellimaniki mahn mesenih koaros, eri sohte aramas emen pahn wiahki nsene oh meirongkihong kAUN-O. Kou men, sihpw men de kuht men KAUN-O me ketin sapwellimaniki, ");
INSERT INTO pon2006a_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ahpw mesenihen mahn samin men kak pweipweida sapahl nin duwen koasoandien pweipwei iangahki persent 20. Ma e sohte pweipweida sapahl, e kak netla rehn emen tohrohr ni pweipwei me koasoandier. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Sohte aramas emen kak netikihla de pwainda sapahl dahme e kasarawihongehr douluhl KAUN-O, mehnda ma aramas, mahn de sahpw. Pwe KAUN-O pahn ketin sapwellimanikihla douluhl kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Aramas koaros me milahr pahn keria, sohte kak en pweipweida sapahl, re uhdahn pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","KAUN-O me ketin sapwellimaniki eisek kis ehun wahnsahpw koaros, mehnda ma werentuhke de wahntuhke. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ma aramas emen men pwainda sapahl ekis wahnsahpw pwukat, e pahn kihda pweine me koasoandier iangahki persent 20. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Emen sang nan mahn ehk koaros uhdahn sapwellimen KAUN-O. Ni mahn akan ar kin wadawad, kaeisek en mahn koaros uhdahn sapwellimen KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Me naineki mahn akan sohte pahn koasoanehdi pwe mahn mwomw suwed kan en pilipilda. E sohte pahn pil wilianda. Ma e pahn wiliankihdi mahno emen mahn tohrohr, mahn ako koaros pahn wiahla sapwellimen KAUN-O oh mahn ako sohte kak pweipweida sapahl. ");
INSERT INTO pon2006a_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ih koasoandi pwukat me KAUN-O ketikihong Moses ni Nahna Sainai pwehn padahkihong mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","KAUN-O ketin mahseniong Moses nan Impwal me e kin ketiket loaleo, nan Sapwtehn Sainai, ni keieun rahnen sounpwong keriau ni sounpar keriau mwurin mehn Israel ko ar mweselsang Isip, e mahsanih, ");
INSERT INTO pon2006a_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Kowe oh Aaron pahn wia wadawad en aramas en Israel kan koaros nin duwen ar peneinei kan. Kumwa eri ntingihedi eden ohl koaros me mahkier ");
INSERT INTO pon2006a_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","sounpar rieisek kohda me kak wia sounpei. ");
INSERT INTO pon2006a_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Emen kaunen peneinei kan sang ni kadaudok koaros en sewesei kumwa. ");
INSERT INTO pon2006a_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","16","Eri iet mwaren irail kan, kaunen kadaudok kan, me pilipildahr pwehn wia doadoahk wet: Kadaudok Kaunen peneinei Reupen Elisur, nein Sedeur Simion Selumiel, nein Surisadai Suda Nahson, nein Aminadap Isakar Nedanel, nein Suar Sepulon Eliap, nein Elon Epraim Elisama, nein Ammihud Manase Kamaliel, nein Pedasur Pensamin Apidan, nein Kideoni Dan Ahieser, nein Amisadai Aser Pakiel, nein Okaran Kad Eliasap, nein Deuel Napdali Aira, nein Enan ");
INSERT INTO pon2006a_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Ohl ehk riemen pwukat sewesehda Moses oh Aaron ");
INSERT INTO pon2006a_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","kapokonepene mehn Israel koaros ni rahn keieu en keriaun sounpwong oh ntingihedi aramas koaros ni wadawad en peneinei. Mwaren ohl koaros sang sounpar rieisek kohda ntingdi oh wadawadedi, ");
INSERT INTO pon2006a_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","nin duwen KAUN-O eh ketin mahsanih. Moses ntingihedi mwaren aramas akan nan Sapwtehn Sainai. ");
INSERT INTO pon2006a_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","46","Ohl koaros me mahkier sounpar rieisek kohda me kak wia sounpei, kileldier nin duwen peneinei, tepisang kadaudok en Reupen nein Seikop mesenih. Koaruhsie patpene iet duwe: Kadaudok Uwen tohto Reupen 46,500 Simion 59,300 Kad 45,650 Suda 74,600 Isakaer 54,400 Sepulon 57,400 Epraim 40,500 Manase 32,200 Pensamin 35,400 Dan 62,700 Aser 41,500 Napdali 53,400 Patpene koaros: 603,550 ");
INSERT INTO pon2006a_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Mehn Lipai ko sohte iang patehng kileledi en mehn Israel teiko, ");
INSERT INTO pon2006a_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","pwehki KAUN-O eh mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ni omw pahn wia wadawad en aramas akan me kak wia sounpei, ke dehpa iangahki kadaudok en Lipai. ");
INSERT INTO pon2006a_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ahpw, kumwa pahn kihong mehn Lipai kan en pwukoahki apwahpwalih Impwal me I pahn kin ketiket loale iangahki dipwisou kan me mi loale. Re pahn kin wa iangahki dipwisawi kan, pil papah loale, oh kauwada imwarail impwal kan kapilkipene. ");
INSERT INTO pon2006a_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ahnsou koaros me kumwail pahn kin mwekidida, mehn Lipai kan pahn kin kamwerehdi Impwalo oh pahn kin pwurehng kauwada wasa kapw kis me kumwail pahn kin uhdi ie. Mehmen me kaidehn mehn Lipai me pahn keidohng mpen Impwalo pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Mehn Israel teikan pahn kin kauwada imwarail impwal ni koasoandien pwihn kei, emenemen aramas pahn iang eh pwihn pahn arail pilaik. ");
INSERT INTO pon2006a_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ahpw mehn Lipai kan pahn kauwada imwarail impwal kan kapilkipene Impwalo pwe re en sinsile, pwe emen en dehr kerendohng oh kahrehda ei engieng eh pahn lelohng mehn Israel koaros.” ");
INSERT INTO pon2006a_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Mehn Israel ko eri kapwaiada mehkoaros me KAUN-O mahsanihong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","KAUN-O ketikihong Moses oh Aaron kaweid pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Ahnsou me mehn Israel kan pahn kauwada imwarail impwal kan, emenemen pahn mi pahn pilaik en eh pwihnlap oh mi pahn pilaik en eh peneinei. Re pahn kauwada imwarail impwal kan kapilkipene Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","9","Irail kan me mi pahn pilaik en Suda pahn wiahda pwihn kei oh kauwada imwarail impwal kan ni palimese, pahn kaweidpen arail kaun pwukat: Kadaudok Kaun Uwen tohto Suda Nahson, nein Aminadap 74,600 Isakar Nedaniel, nein Suar 54,400 Sepulon Eliap, nein Elon 57,400 Patpene koaros: 186,400 Pwihnlap en Suda me pahn tiengki kaparo. ");
INSERT INTO pon2006a_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","16","Irail kan me mi pahn pilaik en pwihnlap en Reupen pahn wiahda pwihn kei oh kuwada imwarail impwal kan ni palieir, pahn kaweidpen arail kaun pwukat: Kadaudok Kaun Uwen tohto Reupen Elisur, nein Sedeur 46,500 Simion Selumiel, nein Surisadai 59,300 Kad Eliasap, nein Deuel 45,650 Patpene koaros: 151,450 Pwihnlap en Reupen me pahn keriaun mwekid. ");
INSERT INTO pon2006a_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Mehn Lipai kan pahn mwekidwei oh wa Impwalo mwurin pwihnlap riau me tiengo, oh mwohn pwihnlap riau me alu mwuhro. Ehuehu pwihnlap pahn mwekidwei ni soangen koasoanditeieu duwehte ar koasoandi ni ar pahn kin kauwada imwarail impwal kan, ni ehuehu pwihnlap pahn ar pilaik. ");
INSERT INTO pon2006a_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","24","Irail kan me mi pahn pilaik en pwihnlap en Epraim pahn wiahda pwihn kei oh kauwada imwarail impwal kan ni palikapi, pahn kaweidpen arail kaun pwukat: Kadaudok Kaun Uwen tohto Epraim Elisama, nein Ammihud 40,500 Manase Kamaliel, nein Pedasur 32,200 Pensamin Apidan son of Kideoni 35,400 Patpene koaros: 108,100 Pwihnlap en Epraim me pahn mwekid kesiluh. ");
INSERT INTO pon2006a_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","31","Irail kan me mi pahn pilaik en pwihnlap en Dan pahn wiahda pwihn kei oh kauwada imwarail impwal kan ni paliepeng, pahn kaweidpen arail kaun pwukat: Kadaudok Kaun Uwen tohto Dan Ahieser, nein Amisadai 62,700 Aser Pakiel, nein Okran 41,500 Napdali Aira, nein Enan 53,400 Patpene koaros: 157,600 Pwihnlap en Dan me pahn mwekid keieu mwuhr. ");
INSERT INTO pon2006a_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Uwen tohtohn mehn Israel koaros patpene me towehda pwihnlap akan, irail me 603,550. ");
INSERT INTO pon2006a_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Duwen KAUN-O eh ketin koasoanediong Moses, mehn Lipai ko sohte iang patehng wadawaden mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Mehn Israel ko eri kapwaiada mehkoaros me KAUN-O mahsanihong Moses. Re kauwada imwarail impwal, emenemen aramas pahn eh pilaik, oh re mwekidwei, emenemen iang pein eh peneinei. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Iet peneineien Aaron oh Moses ni ahnsou me KAUN-O ketin mahseniong Moses pohn Nahna Sainai. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aaron naineki pwutak pahmen: Nadap, iei ih me keieu laud, Apihu, Eleasar, oh Idamar. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Moses keieiraildier oh kasarawihirailla ong samworo, ");
INSERT INTO pon2006a_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ahpw Nadap oh Apihu kamakamala ni ahnsou me ira meirongkihong KAUN-O kisiniei keinepwi nan Sapwtehn Sainai. Sohte neira seri, Eleasar oh Idamar wiewiahki doadoahk en samworo nindokon Aaron eh momour. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Ekerodo kadaudok en Lipai oh kilelehdi pwe re en kin papah samworo Aaron. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Re pahn wia doadoahk me anahnepe mie nan Impwal me I pahn kin ketiket loale oh wia en Aaron pwukao kan oh en mehn Israel kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Re pahn apwalih dipwisou kan en nan Impwalo oh wia doadoahk ong mehn Israel kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ihte en mehn Lipai kan ar pwukoa, iei re en papah Aaron oh nah pwukat ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ke pahn pilada Aaron oh nah pwutak kan pwe re en wiewia pwukoahn samworo; mehmen me pahn song en iang wia pwukoa wet pahn kamakamala.” ");
INSERT INTO pon2006a_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“Sang met kohla mehn Lipai kan pahn wiahla nei aramas. Ni ei kemehla mesenih en mehn Isip ko, I kasarawihong ie mesenih en ehuehu peneineien mehn Israel oh mesenih en nair mahn koaros pwe re en wiahla nei. Met I piladahr mehn Lipai kan pwe re en wiahla nei, wiliandi mesenih en mehn Israel kan. Re wialahr nei aramas. Ngehi me KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","KAUN-O mahsanihong Moses nin Sapwtehn Sainai ");
INSERT INTO pon2006a_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","en ntingihedi mehn Lipai ko nin duwen ar peneinei, kilelehdi ohl koaros me mahki sounpwong ehu kohda. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moses eri kapwaiada. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","20","Lipai naineki pwutak silimen: Kerson, Kohad oh Merari, irail me pahpa kahlap en peneinei kan me weuwa adarail ko. Kerson naineki pwutak riemen: Lipni oh Simei; Kohad naineki pwutak pahmen: Amram, Isar, Epron, oh Ussiel; oh Merari naineki pwutak riemen: Mahli oh Musi. Irail me wia pahpa kahlap en peneinei kan me weuwa adarail kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Peneineien Kerson kispeseng wiahda peneineien Lipni oh Simei. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ohl koaros mehn Lipai me mahkier sounpwong ehu kohda patpene wiahda me 7,500. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Peneinei wet pahn kauwada imwarail impwal kan ni palikapi en Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eliasap, nein Lael me pahn wia kaunen peneinei wet. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Irail pahn pwukoahki Impwalo, pwelengen masloale oh liki, kahdeng en wenihmw, ");
INSERT INTO pon2006a_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","kahdeng en kehl me kapilpene Impwalo oh pei sarawio, oh kahdeng en wenihmwen kehlo. Irail me pwukoahki doadoahk koaros me pid dipwisou pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Peneineien Kohad kispeseng wiahda peneineien Amram, Isar, Epron, oh Ussiel. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ohl koaros mehn Lipai me mahkier sounpwong ehu kohda patpene wiahda me 8,600. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Peneinei wet pahn kauwada imwarail impwal kan ni palieir en Impwalo, ");
INSERT INTO pon2006a_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Elisapan, nein Ussiel me kaunen peneinei wet. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Irail me pwukoahki Kohpwahn Inowo, tehpelo, dewen lampo, pei sarawi ko, oh kepwehn kamwakel me samworo kin doadoahngki Wasa Sarawio, oh kahdeng en wenihmwen Wasa Sarawiheo. Irail me pwukoahki doadoahk me pid dipwisou pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Kaunen mehn Lipai ko iei Eleasar, nein Aaron. Ih me kin kaun irail me wiewia ar pwukao kan nan Wasa Sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Peneineien Merari kispeseng wiahda peneinei kan en Mahli oh Musi. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ohl koaros mehn Lipai me mahkier sounpwong ehu kohda patpene wiahda me 6,200. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Peneinei wet pahn kauwada imwarail impwal kan ni paliepeng en Impwalo, oh Suriel, nein Apieil me kaunen peneinei wet. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Re kileldi en pwukoahki uhr en Impwalo, ndape kan, lepin uhr ko, poahsoane, oh soahng teikan koaros. Re pwukoahki doadoahk koaros me pid dipwisou pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Re pil pwukoahki lepin uhr, poahsoane, tuhkehn kateng, oh sahl en likin kehlo. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moses oh Aaron oh nah pwutak ko pahn kauwada imwarail impwal kan mwohn Impwalo ni palimese. Re pahn wia en mehn Israel kan ar kaudok nan Wasa Sarawio. Ma emen tohrohr pahn song en wia doadoahk pwukat pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ohl koaros mehn Lipai me mahkier sounpwong ehu kohda me Moses ngtingihedi ni wadepen peneinei duwen me KAUN-O mahsanih, irail me 22,000. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","41","KAUN-O mahsanihong Moses, “Ngehi me naineki mesenih en mehn Israel kan koaros. Eri ngtingihedi eden mesenih pwutak koaros en Israel, sang me sounpwong ehu kohda. Ahpw mehn Lipai koaros me I naineki wiliandi mesenih koaros en Israel. Ngehi me KAUN-O! I pil naineki nein mehn Lipai pelinmen kan koaros.” ");
INSERT INTO pon2006a_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moses eri kapwaiada mehkoaros me KAUN-O mahsanihong oh ntingihedi mesenih ohl koaros me mahkier sounpwong ehu kohda; ");
INSERT INTO pon2006a_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","eri irail koaros patpene me 22,273. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Met kasarawihong ie mehn Lipai kan wiliandi mesenih ohl koaros en mehn Israel, oh nein mehn Lipai pelinmen kan wiliandi nein mehn Israel mesenih en mahn akan. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Pwehki mesenih en mehn Israel kan ar tohtohkihsang mesenih en mehn Lipai kan aramas 273, ke pahn pwainda mesenih 273-o. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Emenemen mesenih pahn pweipweiki mwohni silper limau nin duwen me koasoandier. ");
INSERT INTO pon2006a_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ke pahn kihong Aaron oh nah pwutak ko mwohni wet.” ");
INSERT INTO pon2006a_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moses eri kapwaiada mahsen wet oh ale ");
INSERT INTO pon2006a_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","mwohni silper 1,365 ");
INSERT INTO pon2006a_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","oh kihong Aaron oh nah pwutak ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","KAUN-O ketin mahsaniong Moses ");
INSERT INTO pon2006a_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","en wia wadawaden peneineien Kohad mehn Lipai nin duwen ar peneinei kan, ");
INSERT INTO pon2006a_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","oh pil ntingihedi mwaren ohl koaros me mahkier sounpar silihsek lel limeisek me kak wia doadoahk nan Impwal me KAUN-O pahn kin ketiket loale. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Arail doadoahk pahn pid soahng kan me uhdahn sarawihe. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","KAUN-O ketikihong Moses kaweid pwukat. Ni ahnsou me impwal kan pahn kin kamweremwerdi pwe mehn Israel kan en mwesel, Aaron oh nah pwutak kan pahn pedolong nan Impwalo, kihdihsang kahdeng me mi mwohn Kohpwahn Inowo oh pwainkihdi kohpwao. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Re ahpw pahn kidimkihdi kilin kou kaselel ehu, oh perekipeseng powe likou poh mei ehu, re ahpw pahn kadilong tuhkehn wisik ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Re pahn pil perekipeseng likou poh mei ehu pohn tehpel en meirong en pilawa ong KAUN-O oh koasoanediong powe dahl akan, pwohl en warpwohmwahu kan, pwohl en meirong kan, oh sah me wain en meirong kin mi loale. Pilawa pahn kin mihmihte pohn tehpelo ahnsou koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Re pahn perekipeseng likou poh weitahta ehu pohn mepwukat koaros, oh kihdiong powe kilin kou kaselel ehu, re ahpw pahn kadilong tuhkehn wisik ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Re pahn ale likou poh mei ehu oh kidimkipene dewen lampo, iangahki lamp akan, tihpw kan, opwong kan, oh deupen lehn olip ko koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Re pahn kidimkipene kilin kou kaselel ehu, iangahki dipwisawi kan koaros oh kihdiong pohn mehn ro ehu. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Mwuhr re ahpw pahn perekipeseng likou poh mei ehu pohn pei sarawi kohlo, oh pwainkihdi kilin kou kaselel ehu, re ahpw pahn kadilong tuhkehn wisik ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Re pahn ale dipwisou koaros me kin doadoahk nan Wasa Sarawio, oh kidimkipene likou poh mei ehu, oh pwainkihdi kilin kou kaselel ehu, oh kihdiong pohn mehn ro ehu. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Re pahn kihsang pehs me kirihsla ko pohn pei sarawio oh perekipeseng likou poh ntahnmwel ehu powe. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Re pahn kidahng powe dipwisou koaros me kin doadoahk ni pei sarawio: pan en kisiniei, metehn kateng, sapwel, oh peisin kan. Re ahpw pahn kidimkihdi kilin kou kaselel ehu oh kadilong tuhkehn wisik ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Ni ahnsoun kamwerehdi impwal kan, peneineien Kohad pahn kohla pwe re en wahda dipwisou sarawi kan, ahpw mwurin Aaron oh nah pwutak ko ar pahn kidimpenehr dipwisou kan. Peneineien Kohad ko sohte pahn sair dipwisou sarawi kan, pwe re de mehkihla. Ih met kan pwukoa kan en peneineien Kohad ahnsou koaros me Impwalo pahn kin kemwekida. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleasar, nein samworo Aaron, pahn pwukoahki apwahpwalih Impwalo pwon iangahki lehn lamp akan, warpwohmwau, wahntuhkehn meirong kan, lehn kei sarawio, oh mehkoaros me mi nan Impwalo me kasarawilahr ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","KAUN-O ketin mahsanihong Moses oh Aaron, ");
INSERT INTO pon2006a_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Kumwa dehpa mweidohng peneineien Kohad en ");
INSERT INTO pon2006a_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","mehkihla ar pahn keidohng limwahn dipwisou sarawi pwukat. Pwe irair wet en dehr wiawi, Aaron oh nah pwutak ko pahn pedolong oh kilelediong en emenemen ohl eh doadoahk oh ndahng dahme e pahn wa. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Pwe ma mehn Kohad kan pahn pedolong nan Impwalo oh kilang samworo ko ar kihkihpene dipwisou sarawi kan, re pahn mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","KAUN-O ketin mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","en wia wadawad en peneineien Kerson mehn Lipai nin duwen ar peneinei kan, ");
INSERT INTO pon2006a_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","oh pil ntingihedi mwaren ohl koaros me mahkier sounpar silihsek lel limeisek me kak wia doadoahk nan Impwal me KAUN-O pahn kin ketiket loale. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Re pahn pwukoahki wa dipwisou pwukat: ");
INSERT INTO pon2006a_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Impwalo, pwelengen masloale, pwelengen masliki, mehn pweipwei kilin kou kaselel me mi powe, kahdeng en wenihmwo, ");
INSERT INTO pon2006a_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","kahdeng ko oh sahl en kehl me kapilpene Impwalo oh pei sarawio, kahdeng en wenihmwen kehlo, oh soahng koaros me kin doadoahkohng dipwisou pwukat. Re pahn wia doadoahk koaros me anahnepe mie ong dipwisou pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Moses oh Aaron pahn tehk mwahu pwe mehn Kerson pwukat en kapwaiada mwahu ar pwukoa kan oh wahda soahng koaros me Aaron oh nah pwutak ko pahn kilelehiong irail. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ih met kan pwukao kan en peneineien Kerson ong Impwalo; re pahn kin wia pahn kaweidpen Idamar, nein samworo Aaron pwutak. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","KAUN-O ketin mahsanihong Moses en wia wadawad en penineien Merari mehn Lipai nin duwen ar peneinei kan, ");
INSERT INTO pon2006a_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","oh pil ntingihedi mwaren ohl koaros me mahkier sounpar silihsek lel limeisek me kak wia doadoahk nan Impwal me KAUN-O pahn kin ketiket loale. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Re pahn pwukoahki wa uhr ko, ndape oh doakoloal ko, lepin uhr ko, oh poahsoanen Impwalo, ");
INSERT INTO pon2006a_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","oh lepin uhr ko, poahsoane, kisin tuhkehn katengehdi Impwalo nan pwehl, oh sahl me kapilpene kelen Impwalo, iangahki soahng koaros me kin doadoahkohng ni kokoudahn dipwisou pwukat. Emenemen ohl pahn pwukoahki wa dipwisou me kileldiong en wa. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ih met pwukoa kan en peneineien Merari ong ni doadoahk en Impwalo; re pahn kapwaiada soahng pwukat koaros pahn kaweidpen Idamar, nein samworo Aaron pwutak. ");
INSERT INTO pon2006a_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Pwehn kapwaiada mahsen en KAUN-O, Moses oh Aaron oh kaunen mehn Israel ko wia wadawad en peneinei siluh en Lipai; Kohad, Kerson, oh Merari. Re wia wadawad wet nin duwen ar peneinei oh ntingihedi ohl koaros me mahkier sounpar silihsek lel limeisek me kak wia doadoahk nan Impwal me KAUN-O pahn kin ketiket loale, eri iet uwen tohtohn ohl akan: Peneinei Uwen tohto Kohad 2,750 Kerson 2,630 Merari 3,200 Patpene koaros 8,580 ");
INSERT INTO pon2006a_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Mwaren emenemen ohl ntingdi nin duwen KAUN-O eh ketin mahsanihong Moses; oh sang ni mahsen me KAUN-O wiahiong Moses, emenemen ohl kileldiongehr eh pwukoa ong ni doadoahk en papah de wisik dipwisou. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Koasoanediong mehn Israel kan re en kesehsang nan kahnimpwalo koaros me soumwahu tokutok oh me nahn kin pwilisang ni paliwere oh koaros me saminkilahr ar sairada aramas mehla. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Kadarala soangen aramas me samin ong kaudok pwukat koaros, pwe re dehr kasaminehla kahnimpwalo, wasa me I kin koukousoan ie rehn nei aramas akan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Mehn Israel ko eri kapwaiada oh keseirailsang nan kahnimpwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","KAUN-O ketikihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","kaweid pwukat pwe en padahkihong mehn Israel ko. Ma aramas emen pahn soaloalopwoatohng KAUN-O oh wiahda mehkot sapwung ong emen, ");
INSERT INTO pon2006a_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","e pahn sakarkihda eh sapwungo oh kapwungala ni unsek, patehng persent 20, ong aramas me e wiahiong sapwungo. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ahpw ma aramaso melahr oh sohte kiseh me karanih me pweipweio kak kohieng, e pahn kohieng KAUN-O pwe en uhd kohieng samworo. Pweipwei wet pahn patehng meirong en sihpw wol me samworo kin wia pwehn kamwakelehda aramas dipan meno. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Pil duwehte kisakis kesempwal koaros me mehn Israel kin meirongkihong KAUN-O kin uhd kohieng pweisen samworo men me re kin kihong meirongo. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Emenemen samworo pahn tungoalenkihla meirong kan me kin kohieng. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","KAUN-O ketin mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","14","en padakihong mehn Israel ko kaweid pwukat. Ma ohl emen pahn lemelemehkohng eh pwoud me dene e kin pitipitih oh kasaminehkilahr pein ih pwehki eh kapwaiada nsenen pwopwoud ong emen ohl tohrohr. Ahpw e sohte dehdehiong ohlo pwehki ele liho eh kin karkaririh—sohte sounkadehde, oh sohte me diarada eh wiewia tiahko. De ohl emen kak lemelemehkohng eh pwoud, mehnda ma liho sohte wia mehkot sapwung. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Eri, nan ire pwukat koaros ohlo pahn kahrelahng eh pwoud rehn samworo. E pil pahn wa kohla mehn meirong me koasoandier, paun riau en pilawa parli, ahpw e sohte pahn doaloahki lehn olip de warpwohmwau, pwehki eh wia meirong en ohl lemelemehk men, me men diarada dahme mehlel. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Samworo pahn kahrehla lih pwehn kesihnenda mwohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","E pahn wudekihong pihl sarawi nan pwohl ehu oh ale pwehl sang nan taten Impwal me KAUN-O kin ketiket loale oh kihong nan pihlo. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Mwuri, e pahn sapwadpeseng pitenmoangen liho oh kihdiong nan pehn liho pilawa amas mehn meirong. Samworo ahpw pahn kolada pwohl me pihl katiko mi loale mehn keriahla aramas. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Samworo ahpw pahn ndahng liho en pwungki kahula wet me samworo pahn wia, “Ma ke sohte wia dipen kamwahl, ke sohte pahn ale keria sang nan pihl wet. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ahpw ma ke wiadahr dipen kamwahl, ");
INSERT INTO pon2006a_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","KAUN-O en ketin wiahkihla edomwen mehn keria ieu rehn kisehmw kan. En ketin kupwurehda pwe omw wasa sarawien en wetikitikla oh kapehdomwen en mpwospeseng. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Pihl wet en kohlong nan kapehdomwen oh kamwpwosepeseng oh kanurpene omw wasa sarawien.” Liho ahpw pahn sapeng, nda, “Ei, I pwungki, kupwur en KAUN-O en pweida.” ");
INSERT INTO pon2006a_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Samworo ahpw pahn ntingihedi keria wet oh widensang ntingo nan pwohl en pihl katiko. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Mwohn eh pahn kihong liho en nim pihlo me pahn kak en kahrehiong weirek laud, ");
INSERT INTO pon2006a_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","samworo pahn ale meirong en pilawa me mi nan pehn liho, oh kolada pwehn kasarawihong KAUN-O oh patohwandiong pohn pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","E ahpw pahn ale ehu oaroahr en pilawao nin duwen kilel en meirong oh isikala pohn pei sarawio. Mwuhr e pahn kihong liho en nim pihlo. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ma e wiahda dihp ong emen ohl tohrohr, pihlo pahn kahrehiong eh pahn weirek laud; kapehde pahn mpwospeseng oh eh wasa sarawio pahn nurpene. Ede pahn wiahla mehn keria rehn kiseh kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ahpw ma e sohte dipada, e sohte pahn ale mehkot suwed oh e pahn kak neitik. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","Ih duwen kosonned ong ohl akan me kin luwak oh lemelemehk me ar pwoud kan kin kamwahl. Liho pahn kesihnenda mwohn pei sarawio, samworo ahpw pahn wia sarawi wet. ");
INSERT INTO pon2006a_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Ohlo pahn saledeksang dihp, ahpw ma liho dipada, e pahn lokolongki dipeo. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","KAUN-O ketin mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","en padahkihong mehn Israel ko kaweid pwukat. Ohl emen de lih emen me pahn wiahda inou en wiahla Nasaraid men oh kasarawihong pein ih KAUN-O ");
INSERT INTO pon2006a_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","pahn mweisang nim wain oh pihru. E sohte pahn nim mehkot me wiawihsang kreip de kang kreip de reisin. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Nindokon eh wiewia Nasaraid men, e sohte pahn kang mehkot me kohsang ni tuhkehn kreip, mehnda ma were de kilin kreip. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Erein eh pahn mihmi nan eh inowo, e sohte pahn sehk pitenmoange de koakoahsang eh alis. E pahn kapwaiada eh inowo erein eh kasarawihong KAUN-O, oh e pahn kadarala pitenmoange oh eh alis. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","7","Pitenmoange iei kilel en eh kasarawihong Koht, eri e sohte pahn kasaminehla pein ih ni eh pahn karanih aramas mehla men, mehnda ma eh pahpa de nohno, de rie. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Erein eh wiewia Nasaraid men, e kasarawihongehr KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Ma pitenmoangen Nasaraid men me kasarawilahr pahn saminkihla eh mihmi limwahn aramas emen me mwadangete mehla ni ahnsowohte; e pahn awih erein rahn isuh oh e ahpw pahn sehkasang pitenmoange oh eh alis, eri e ahpw pahn mwakelekella ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ni kawaluh en rahn, e pahn wahla rehn samworo mwuroi riemen de pitsin riemen ni wenihmwen Impwal me KAUN-O kin ketiket loale. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Samworo ahpw pahn meirongkihla emen mwuroi ko pwehn wiahki meirong en dihpo oh emen mwuroi ko e pahn wiahki meirong isihs mehn kamwakelehsang samin en eh sairada aramas mehlao. Ni rahnohte aramaso pahn kasarawihala sapahl pitenmoangeo ");
INSERT INTO pon2006a_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","oh tapihada sapahl eh mour en Nasaraid. Lepin ahnsou me e wiewiahki nasaraid mahs, solahr katepe, pwehki pitenmoange me kasarawilahro eh saminlahr. Pwehn wia meirong en kapwungala, e pahn wahdo emen sihmpwul me sounpar ehu. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Ni ahnsou me Nasaraid men pahn kanekelahr eh inou, e pahn wia sarawi. E pahn kohla ni wenihmwen Impwalo ");
INSERT INTO pon2006a_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","oh patohwandahng KAUN-O mahn silimen me sohte kisin samin kis rehrail: emen sihmpwul wol me sounpar ehu mehn meirong isihs, emen sihmpwul lih me sounpar ehu mehn meirong en dihp, emen sihpw wol mehn meirong en kaminimin. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","E pil pahn meirongkihla ehu kopwoun pilawa me sohte doal ihs: lopwon en pilawa mosul me doal lehn olip oh keik menipinip me lehn olip kohieng powe, oh pahn kapatahiong mepwukat meirong en wahnsahpw oh wain duwen me koasoandier en kin iang meirong kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Samworo ahpw pahn patohwandahng KAUN-O mepwukat oh wia meirong en dihp oh meirong isihs. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","E pahn meirongkihla sihpw wolo ong KAUN-O nin duwen meirong en kaminimin, iangahki kopwoun pilawao; e pahn pil patohwandahng meirong en wahnsahpw oh wain. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Nasaraido ahpw pahn sehkasang pitenmoange ni wenihmwen Impwalo oh isikala nan kisiniei en meirong en kaminimin me wie lullulo. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Mwuhr, ni tihnsewen sihpw wolo eh pwoailehr, samworo pahn ale oh kihong nan pehn Nasaraido, iangahki ehu lopwon en pilawa mosul oh keik menipinip sang nan kopwowo. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Mwuri, samworo pahn patohwandahng KAUN-O nin duwen kisakis kesempwal ehu; me wialahr meirong sarawi me pahn kohieng samworo, iangahki mwaremware oh neh me pahn kohieng pweisen samworo nin duwen kosonned. Mwurin met, Nasaraido kakehr nim wain. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Ih met kosonned kan me pid Nasaraid kan; ahpw ma Nasaraid men inoukihda en kihda meirong ehu me laud sang uwen me koasoandi ong eh inowo, e pahn kapwaiada inou me e wiadahro. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Eri, KAUN-O ketin mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","en padahkihong Aaron oh nah pwutak kan re en wia kapakap en kapai pwukat ni ahnsou me re pahn kapakapki mehn Israel kan: ");
INSERT INTO pon2006a_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","KAUN-O en ketin kupwuramwahwih kumwail oh apwahpwalih kumwail; ");
INSERT INTO pon2006a_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","KAUN-O en ketin kamarainihkin kumwail silangi oh kupwureikumwail: ");
INSERT INTO pon2006a_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","KAUN-O en ketin kasalehda sapwellime kupwurkalahngan ong kumwail oh ketikihong kumwail popohl. ");
INSERT INTO pon2006a_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","KAUN-O pil mahsanih, “Ma re pahn kin kapaiahkihda mehn Israel kan mwarei, eri I pahn kin kapaiairailda.” ");
INSERT INTO pon2006a_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Ni rahn me Moses kaimwisekala kokoudahn Impwal me KAUN-O kin ketiket loale, e ahpw keiehla oh kasarawihala Impwalo iangahki dipwisawi kan koaros oh pil pei sarawio iangahki dipwisawi kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Soupeidi en peneinei kan me wia kaunen kadaudok en Israel, iei irail ko me pil iang kaunda aramas akan me wadawadier, ");
INSERT INTO pon2006a_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","irail ahpw patohwanda ar mehn meirong kan ong KAUN-O: kuruma weneu oh kou ehk riemen, ehu kuruma ong kaun riemen oh kou men ong kaun emen. Mwurin ar wapenehr dipwisou pwukat, ");
INSERT INTO pon2006a_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","KAUN-O ahpw mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Ale meirong pwukat me pahn wia doadoahk ong ni Impwalo; ke ahpw kihong mehn Lipai kan pwehn wia doadoahk me re pahn wia.” ");
INSERT INTO pon2006a_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moses eri patohwanohng mehn Lipai ko kuruma ko oh kou ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","E kihong mehn Kerson kuruma riau oh kou pahmen, ");
INSERT INTO pon2006a_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","oh kuruma pahieu oh kou welimen ong mehn Merari. Ar doadoahk koaros pahn kin wiawi pahn epwelpen Idamar, nein samworo Aaron. ");
INSERT INTO pon2006a_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ahpw Moses sohte kihong mehn Kohad kuruma de kou, pwehki ar pahn kapaik dipwisou sarawi ko me re kin pwukoahki apwalih. ");
INSERT INTO pon2006a_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Kaun akan pil patohwanpene meirong kei mehn iang wia kasarawihpen pei sarawio. Ni ar onopadahr re en patohwanda ar meirong kan ni pei sarawio, ");
INSERT INTO pon2006a_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","KAUN-O ahpw ketin mahsanihong Moses, “Patohwanohng irail me erein rahn eisek riau irekweite emenemen kaun pahn wahdo eh kisakis en kasarawih pei sarawiet.” ");
INSERT INTO pon2006a_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Irail eri patohwando ar meirong kan nin duwe met: Rahn Kadaudok Kaun Keieu Suda Nahson, nein Aminadap Keriau Isakar Nedanel, nein Suar Kesiluh Sepulon Eliap, nein Elon Kapahieu Reupen Elisur, nein Sedeur Kelimau Simion Selumiel, nein Surisadai Keweneu Kad Eliasap, nein Deuel Keisuh Epriam Elisama, nein Ammihud Kawaluh Manase Kamaliel, nein Pedasur Keduwau Pensamin Apidan, nein Kideon Kaeisek Dan Ashier, nein Amisadai Kaeisek ehu Aser Pakiel, nein Okran Kaeisek riau Napdali Aira, nein Enan Kisakis kan me emenemen patohwanda soahngteieu, me iei: ehu pwohl silper me toutouki ouns 50 oh ehu peisin silper me toutouki ouns 30 nin duwen me koasoandier, koaros diren pilawa doal leh mehn wia meirong en wahnsahpw; ehu dahl kohl me toutouki ouns 4, diren warpwohmwahu; emen koupwul wol, emen sihpw wol, oh emen sihmpwul me sounpar ehu, mehn wia meirong isihs; emen kuht, mehn meirong en dihp; oh pil kou wol riemen, sihpw wol limmen, kuht limmen oh sihmpwul limmen me sounpar ehu, mehn wia meirong en kaminimin. ");
INSERT INTO pon2006a_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","88","Iet kan uwen tohtohn mehn meirong me kaun ehk riemeno wapene mehn wia kasarawihpen pei sarawio: -pwohl silper eisek riau oh peisin silper eisek riau me toutoui patpene wiahda paun 60 -dahl kohl eisek riau me toutoui patpene wiahda ouns 48 me diren warpwohmwahu -kou wol ehk riemen, sihpw wol ehk riemen, sihmpwul me sounpar ehu me ehk riemen, iangahki arail meirong en wahnsahpw, mehn wia meirong isihs. -kuht ehk riemem, mehn meirong en dihp. -kouwol riehk pahmen, sihpw wol wenehk, kuht wenehk, oh pil sihmpwul wenehk me sounpar ehu, mehn wia meirong en kaminimin. ");
INSERT INTO pon2006a_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ni ahnsou me Moses patohla nan Impwalo pwehn patohong KAUN-O, e ahpw rongada duwen KAUN-O e ketin mahmahseniong sang pohn pweinen Kohpwahn Inowo nanpwungen kerup riemeno. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Padahkihong Aaron me ni eh pahn kin koasoanehdi lamp isuh ko nan dewen lampo, en koasoanehdi pwe marain en kin dakerada mwohn dewen lampo.” ");
INSERT INTO pon2006a_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaron eri kapwaiada oh koasoanehdi lamp ako pwe en sohpeiong dewen lampo. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Dewen lampo pwon wiawihda sang kohl sukusukda nin duwen mwohmw me KAUN-O ketin kasalehiong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Katohrehsang mehn Lipai kan sang rehn mehn Israel teikan oh kamwakeleirailda ");
INSERT INTO pon2006a_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","nin duwe met: usupihkin irail pilen kamwakel oh re en sihpih wasa koaros ni paliwararail kan oh lopworada ar likou kan. Ih duwen ar pahn mwakelekella ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Re ahpw pahn ale emen koupwul wol iangahki mehn meirong en wahnsahpw me doal lehn olip; a kowe, ke pahn pil ale emen kouwol mehn wia meirong en dihp. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Mehn Lipai ko ahpw pahn patohdahdo mwohn Impwalo, wasa ke pahn kapokonepene ie mehn Israel kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Eri mehn Israel kan pahn kidahng pehrail kan pohn moangen mehn Lipai kan, ");
INSERT INTO pon2006a_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","oh Aaron ahpw pahn kasarawihong ie mehn Lipai kan nin duwen kisakis kesempwal ehu sang rehn mehn Israel kan, pwe re en wia ei doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Mehn Lipai kan ahpw pahn kidahng pehrail kan pohn moangen kouwol riemeno; emen mehn wia meirong en dihp, oh emen mehn wia meirong isihs, pwehn wia tiahk sarawien kamwakel ong mehn Lipai kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Kasarawihala mehn Lipai kan pwe re en wia kisakis tohrohr ehu ong ie, oh kihong Aaron oh nah pwutak kan en kin apwahpwali irail. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Eri ih duwen omw pahn katohrehsang mehn Lipai kan sang rehn mehn Israel teikan, pwe re en wiahla nei. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Mwurin omw pahn kamwakelehda oh kasarawihala mehn Lipai kan, re pahn kakehr doadoahk nan Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","I nainekiniraillahr wiliandi nein mehn Israel kan nair mesenih pwutak koaros oh re wialahr nei kelehpw. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ni ei kemehla mesenihen mehn Isip ko, I kasarawihalahr mesenih pwutak koaros en peneineien Israel oh mesenih koaros en nair mahn akan pwe re en wiahla nei. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Eri, met I nainekilahr mehn Lipai kan wiliandi mesenihen mehn Israel kan, ");
INSERT INTO pon2006a_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","eri I ketikihongehr Aaron oh nah pwutak ko mehn Lipai kan, pwe re en wia kisakis ehu sang mehn Israel kan, me pahn wiliandi mehn Israel oh doadoahk nan Impwalo oh sinsile irail sang apwal me pahn lelohng irail ma re pahn kin keidohng limwahn Wasa Sarawio.” ");
INSERT INTO pon2006a_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Eri Moses, Aaron oh mehn Israel koaros ahpw kasarawihala mehn Lipai ko, nin duwen me KAUN-O ketin mahsanihong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Mehn Lipai ko eri pein kamwakeleirailda oh lopworada ar likou kan, Aaron ahpw kasarawihirailla nin duwen kisakis tohrohr ehu ong KAUN-O. E pil wia sarawien kamwakeleirailda. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Mehn Israel ko eri kapwaiada mehkoaros me KAUN-O ketin mahsanihong Moses me pid duwen mehn Lipai ko. Eri mehn Lipai ko kakehr doadoahk nan Impwalo pahn kaweidpen Aaron oh nah pwutak ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Mehn Lipai koaros me sang sounpar rieisek limau pahn kin wia arail pwukoa kan nan Impwal me I pahn kin ketiket laole, ");
INSERT INTO pon2006a_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","oh re pahn kommoaldi ni ar pahn lel sounpar limeisek. ");
INSERT INTO pon2006a_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Mwurin met re kak sewese mehn Lipai teikan ni ar pwukoa kan nan Impwalo, ahpw re sohte pahn kelehpw wia sarawi. Ih duwen met omw pahn koasoanehdi en mehn Lipai kan ar doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","KAUN-O ketin mahsanihong Moses nan Sapwtehn Sainai ni keieun sounpwong en keriaun pahr mwurin mehn Israel ko ar mweselsang Isip, e mahsanih, ");
INSERT INTO pon2006a_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","3","“Ni kaeisek pahieun rahn en sounpwong wet, tepida nin soutik, mehn Israel kan pahn wia Sarawien Pahsohpa nin duwen koasoandi koaros en sarawi wet.” ");
INSERT INTO pon2006a_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moses eri patohwanohng mehn Israel ko re en wiahda Sarawien Pahsohpa, ");
INSERT INTO pon2006a_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","oh nin soutik en kaeisek pahieun rahn ni keieun sounpwong re ahpw wiahda sarawio nan Sapwtehn Sainai. Re wiahda soahng koaros nin duwen me KAUN-O mahsanihong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ahpw mie aramas ekei me samin ong kaudok, pwehki ar sairada aramas mehla, irail eri sohte kak iang wia Sarawien Pahsohpa rahno. Re ahpw patohla rehn Moses oh Aaron ");
INSERT INTO pon2006a_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","oh patohwanohng ira, “Se me samin pwehki at sairada aramas mehla, ahpw dahme se sohte pahn iangki mehn Israel kan patohwandahng KAUN-O at tungoal meirong?” ");
INSERT INTO pon2006a_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moses ahpw sapengkin irail, “Kumwail awih I lao ale kaweid sang rehn KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","KAUN-O eri mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","en patohwanohng mehn Israel ko, “Ni ahnsou me emen mehn Israel de emen kadaudoke kan pahn saminla pwehki eh sairada aramas mehla de e seiseiloakseli wasa doh, ahpw e men iang wia Sarawien Pahsohpa, ");
INSERT INTO pon2006a_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","e mweimweiong en iang wia sarawio ahpw mwurin sounpwoung ehu, nin soutik en kaeisek pahieun keriaun sounpwong. Soangen aramas menet pahn wia sarawio ni eh pahn tungoale pilawa me sohte doal ihs oh dihpw katik. ");
INSERT INTO pon2006a_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Sohte mehkot pahn luwehdi sang ni kisin tungoal pwukat ong manda sang rahno oh sohte tih pwoat rehn mahno pahn katipwitimwpeseng. Re pahn kapwaiada koasoandi koaros en Pahsohpa. ");
INSERT INTO pon2006a_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ahpw mehmen me mwakelekel ong kaudok oh sohte seiseiloakseli wasa doh, ahpw sohte iang kapwaiada Pahsohpa, e solahr pahn iang wia kisehn nei aramas akan, pwehki eh sohte iang patohwandahng ie meirong ni ahnsou me kileldi. Aramas meno pahn pwukoahki eh sapwung. ");
INSERT INTO pon2006a_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Ma mehn liki men me kin koukousoan rehmwail men iang wia Sarawien Pahsohpa, e pahn iang wia nin duwen koasoandi koaros en Sarawien Pahsohpa. Koasoandi ehute me pahn doadoahk ong aramas koaros, ong mehn liki de pwilidak kan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","16","Eri, rahn me Impwal me KAUN-O pahn kin ketiket loale eh kokouda, pelien depwek pali ahpw pwarada oh kipehdi. Nipwong, depweko kin mwomwen mpwulen kisiniei. ");
INSERT INTO pon2006a_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ni ahnsou me pelien depweko kin mwekidida, mehn Israel ko kin mweselda; oh wasa me e kin uhdi ie, re pil kin uhdi oh kauwada imwarail impwal kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Sang ni kupwur en KAUN-O re kin mwekidwei, oh sang ni kupwur en KAUN-O re kin uhdi. Re kin mihmihte wasatehkis erein pelien depweko eh kin mihmi pohn Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Eri, ma pelien depweko pahn kin mihmi werei pohn Impwalo, mehn Israel ko kin peikiong KAUN-O oh sohte kin mwekidwei. ");
INSERT INTO pon2006a_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ekei ahnsou pelien depweko kin mihmihki pohn Impwalo rahnte depe; ahpw mehnda, re kin mihmihte de mwekidida sang ni kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ekei ahnsou pelien depweko kin mihmihte sang nin soutik lel nimenseng; eri, aramas ako kin mwesel ni ahnsou me e kin mwekidida. Mehnda ma ni rahn de nipwong, ahpw re kin mweselda ni ahnsou me pelien depweko kin mwekidida. ");
INSERT INTO pon2006a_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Mehnda ma e mihmihki rahn riau, de sounpwong ehu, de sounpar ehu, de pil reireisang, erein pelien depweko eh kin mihmi pohn Impwalo, aramas akan sohte kin mweselda; a ni eh pahn mwekidida, re ahpw kin mweselda. ");
INSERT INTO pon2006a_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Eri, re kin kauwada imwarail impwal, oh re kin kihdihsang oh mweselda, nin duwen koasoandi kan me KAUN-O ketikihong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Wiahkihda sowi riau silper sukusukda, mehn doadoahk pwehn kin kapokonepene aramas akan oh pwehn wia kilel en mweselda. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ahnsou me sowi riau wet pahn pepeuk ni ngihl reirei, mehn Israel koaros pahn pokonpene rehmw ni wenihmwen Impwal me I kin ketiket loale. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ahpw ahnsou me ngilen sowi ehu pahn pepeuk, kaunen peneinei kante me pahn pokonpene rehmw. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ni pepeuk mwotomwot ehu, e pahn wia kilel pwe kadaudok kan me imwarail impwal kan mi ni palimese en mwekidida oh mwesel. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ni pepeuk mwotomwot keriapak, kilel pwe kadaudok en palieir kan re en mwekidida oh mwesel. Eri pepeuk mwotmwot kan pahn wia kilel en mwekidida oh mweselda, ");
INSERT INTO pon2006a_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","a pepeuk reirei pahn kin wia kilel en kapokonepene aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Nein samworo Aaron nah pwutak kan me pahn kin peuk sowi kan. “Koasoandi wet pahn poatopoat sang met kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ni ahnsoun mahwen nan sapwamwail kan, ni amwail pahn kin doandoare pein kumwail sang amwail imwintihti kan me pahn kin mahweniong kumwail, kumwail peuk sowi kan, Eri ngehi, KAUN-O, amwail Koht, pahn sewesei kumwail oh doarehsang kumwail amwail imwintihti kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ni amwail mwekid kaperen kan, ni Sarawien Maram Pwul oh rahn sarawi teikan, kumwail pahn pil kin peuk sowi kan ni ahnsou me kumwail pahn patohwanda amwail meirong isihs kan oh meirong en kaminimin kan. I ahpw pahn sewesei kumwail. Ngehi KAUN-O, amwail Koht.” ");
INSERT INTO pon2006a_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ni kerieisek en rahn en sounpwong keriau nan sounpahr keriau mwurin mehn Israel ko ar mweselsang Isip, pelien depweko me kin uh pohn Impwal me KAUN-O kin ketiket loale pa mwekidida sang powe. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Mehn Israel ko eri mweselda nan ar seiloak sang nan Sapwtehn Sainai. Pelien depweko eri uhdi pohn sapwtehn en Paran. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Irail tapihada mwekid nin duwen KAUN-O eh ketin koasoanediong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","eri ni ahnsou koaros me re kin pwurehng mweselda, re kin wia soangen mwekidteieu. Irail kan me mi pahn pilaik en pwihnlap en kadaudok en Suda me kin tieng oh Nahson, nein Aminadap, me kaunda. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nedanel, nein Suar, ih me kaunen kadaudok en Isakar, ");
INSERT INTO pon2006a_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","oh Eliap, nein Elon, ih me kaunen kadaudok en Sepulon. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Eri, Impwalo pahn kin kamweremwerdi, oh peneineien Kerson oh Merari me kin wa, pahn mweselda. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Mwuhr irail kan me mi pahn pilaik en pwihnlap en kadaudok en Reupen, pahn mweselda oh Elisur, nein Sedeur, me kaunda. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Selumiel, nein Surisadai me kaunda kadaudok en Simion, ");
INSERT INTO pon2006a_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","oh Eliap, nein Deuel me kaunda kadaudok en Kad. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Mwuhr peneineien Kohad mehn Lipai ahpw pahn mweselda wa dipwisou sarawi ko. Ni ahnsou me re kin lellahng wasa me re pahn kin pwurehng kommoaldi ie, Impwalo pahn kin kokoudahr sapahl wasao. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Mwuri, irail kan me mi pahn pilaik en pwihnlap en kadaudok en Epraim ahpw pahn mwekid oh Elisama, nein Ammihud, me kaunda. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Kamaliel, nein Pedasur, me kaunda kadaudok en Manase, ");
INSERT INTO pon2006a_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","oh Apidan, nein Kideoni, me kaunda kadaudok en Pensamin. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Me keieu mwesel mwuhr, irail kan me mi pahn pilaik en pwihnlap en kadaudok en Dan, me wia silepen pwihnlap kan koaros me mi mwuhr, ahpw pahn mweselda oh Ahieser, nein Amisadai, me kaunda. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pakiel, nein Okran, me kaunda kadaudok en Aser, ");
INSERT INTO pon2006a_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","oh Aira, nein Enan, me kaunda kadaudok en Napdali. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Eri ih duwen met, koasoandien kapar ong pwihn kan, ahnsou koaros me mehn Israel kan kin kamwerepeseng imwarail impwal kan oh mweselda. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moses eri patohwanohng en rie lih eh pwoud Opap, nein Sedro mehn Midian, “Kita pahn mwesel kohkolahng wasa me KAUN-O ketin mahsanih e pahn ketikihong kitail. E ketin inoukihda me e pahn ketin kapaiahda Israel; eri kohdo iangkitada pwe ke en iang ahneki at pai.” ");
INSERT INTO pon2006a_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Opap ahpw sapeng, patohwan, “Soh, I sohte pahn iang kumwail, pwe I pahn pwuralahng nan uhdakeio.” ");
INSERT INTO pon2006a_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Moses ahpw ndalahng, “Menlau ke dehr kohkoweisang reht. Ke ese wasa se kak kauwada ie at impwal akan nan sapwtehnet, ke kak kaweidkin kiht. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ma ke pahn iangkitala, ke pahn iang kiht ahnekihla pai kan me KAUN-O pahn ketin kupwurehiong kiht.” ");
INSERT INTO pon2006a_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Mehn Israel ko eri mweselsang nin nahna sarawi Sainai, re ahpw seiseiloak erein rahn siluh. Sapwellimen KAUN-O Kohpwahn Inowo kin tieng ahnsou koaros pwe en rapahkihong irail wasa me re pahn kin kommoaldi ie. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ni arail kin mweselsang wasahn kommoal koaros, pelien depwek en KAUN-O kin mihmi pohrail ni rahn. ");
INSERT INTO pon2006a_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Eri, ahnsou koaros me Kohpwahn Inowo kin mwekidida, Moses kin patohwan, “Maing KAUN, komw ketida oh kamwarakpeseng sapwellimomwi imwintihti kan pwe irail kan me kin kailongkin komwi en tangpeseng mwohmwi.” ");
INSERT INTO pon2006a_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","A ni depweko eh kin uhdi, Moses kin patohwan, “Maing KAUN, komw ketido nan peneinei en Israel pwukat me ngedehrie, me soh kak wadawad.” ");
INSERT INTO pon2006a_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Aramas ako ahpw kaulimkihla ar apwal akan oh lipahnedihada KAUN-O. Eri, ni eh ketin karongehda, e ahpw engiengda kowahlap. Kisiniei en KAUN-O eri lulda nanpwungarail oh kamwasikehla apalien ar kahnimpwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Aramas ako eri likwerih Moses pwe en sewese irail. Moses ahpw kapakapohng KAUN-O, kisinieio eri kunla. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Irail eri kihong eden wasao Taperah, pwehki kisiniei en KAUN-O eh luldahng irail wasao. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Mie mehn liki kei me iangala mehn Israel ko. Aramas pwukat eri tapihada ar inengieng tungoale uduk, oh mehn Israel ko pil iang irail kaulimala, ndinda, “Ihs me kak kihong kitail uduk pwe kitail en tungoale? ");
INSERT INTO pon2006a_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Tamanda kisin mwahmw ko me kitail kin tungoale, sohte pwain, nan Isip; iangahki kiuhri, wasmelen, anien, oh karlik! ");
INSERT INTO pon2006a_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","A met, kitail inenen luwetalahr. Sohte kanatail mehkot pwe ihte manna rahn koaros!” ( ");
INSERT INTO pon2006a_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna duwehte kisin weren wahntuhke kan, ahpw mwomwe me oangoang pohpwetepwet. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","E kin iang pwoaik mweredi nipwong nan kahnimpwalo. Aramas ako ahpw kin kohseli oh rikpene nimenseng, re kin sukpene pwe re en pwoailihada nan einpwoat oh wiahkihda kisin pankeik kei. Nemeneme duwehte pilawa umw me doal lehn olip.) ");
INSERT INTO pon2006a_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moses ahpw rongada en aramas ako ar kaukaulim, ni arail kin tuhpene ni wenihmwen imwarail impwal kan. E ahpw pahtoula pwehki KAUN-O eh ketin engiengda pahrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","E ahpw patohwanohng KAUN-O, “Dahme komw ketin wiakauwekinielahr? Dahme komwi solahr kupwurperenkiniehki? Dahme komw ketin kapwukoahkin ie epwelipen aramas pwukat koaros? ");
INSERT INTO pon2006a_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Kaidehkin ngehi me kapikirailda de kaipwidiong irail nin sampah. Dahme komw ketin kupwurehkihong ie I en wairailla duwehte sounepwel seri men oh tupwengeirailda duwehte seri pwelel kolahng nan sahpwo me komw ketin inoukihong ar pahpa kahlap ako? ");
INSERT INTO pon2006a_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","I pahn kihsang ia uduk pwe I en kak katungoalehki soangen aramas pokon wet? Re kin kalap sengiseng oh pekipeki kanarail uduk. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","I sohte kak kelehpw pwukoahki epwelpen aramas pwukat koaros, e me nohn toutou ong ie! ");
INSERT INTO pon2006a_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ma ih duwen kupwuromwi en met, a komw ketin kemeiehla; pwe I en sohla mi pahn sapwellimomwi engienget.” ");
INSERT INTO pon2006a_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","KAUN-O eri mahsanihong Moses, “Kapokonepene kaun isiakan me keniken pahn arams akan; oh kahreiraildohng ie ni ei Impwalo, pwe re en kesihnenda mpomw. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","I pahn ketidihdo oh mahseniong uhk wasao. I pahn ketikihsang ekis manaman en ngehn me I ketikihong uhk oh uhd ketikihong irail. Eri, re pahn kakehr iang uhk apwahpwalih aramas pwukat; eri, ke solahr pahn kelekelehpwkin irail. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Eri, padahkihong aramas akan, ‘Kumwail kamwakeleikumwailda ong lakapw, pwe kumwail pahn tungoale uduk. Pwe KAUN-O karongedahr amwail sengiseng oh ndinda me kumwail men tungoale uduk, oh me dene mourimwail nan Isip me mwahu. Eri, KAUN-O pahn ketikihong kumwail kanamwail uduk, oh kumwail uhdahn pahn tungoale. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Kumwail pahn tungoale, kaidehkinte rahn ehu de riau, rahn limau de eisek, kaidehkin pil rahn rieisek, ");
INSERT INTO pon2006a_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","pwe erein sounpwong ehu pwon, kumwail lao pahn sangatkihda oh sohla men ned pwowe. Met pahn wiawi pwehki amwail kesehla KAUN-O me kin ketiket rehmwail oh kaulimala oh ndinda dahme kumwail kohkihdohsang Isip.’” ");
INSERT INTO pon2006a_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moses eri patohwanohng KAUN-O, “Mie met aramas 600,000, a komw ketin mahsanih me komw pahn katungoalehkin irail uduk erein sounpwong ehu pwon? ");
INSERT INTO pon2006a_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ma kou koaros oh sihpw koaros pahn kamakamala, e pahn itarohng irail? Ma mwahmw akan koaros en nansed pahn lohdi, e pahn itarohng irail?” ");
INSERT INTO pon2006a_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","KAUN-O ahpw ketin mahsanihong Moses, “Ia duwe, mie irepen ei manaman? Ke pahn mwadang kilang ma ei koasoi pahn pweida de soh!” ");
INSERT INTO pon2006a_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moses eri kohieila oh patohwanohng aramas ako dahme KAUN-O mahsanih. E kapokonepene ohl isiakan sang rehn kaun akan; e ahpw koasoaneiraildi kapilkipene Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","KAUN-O eri ketidihdo nan pelien depwek pali oh mahseniong Moses. E ahpw ketikihsang ekis manaman en ngehn me e ketin audehkihda Moses mahso, oh ketikihong kaun isiakano. Eri, ni ngehno eh ti pohrail re ahpw tapihada kokohp ni ngihl laud; eri, re pil mwadangete tokedi. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Eri, kaun riemen, sang rehn kaun isiakano, me adaneki Eldad oh Medad, ira sohte iang kohla ni Impwalo, ira mihmihte nan kahnimpwalo. Ahpw wasao, nan kahimpwalo, ngehno pil ti pohra; eri, ira pil iang tapihada kokohp ni ngihl laud. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Mwahnakapw emen eri tenge Moses pwe en kehsehki dahme Eldad oh Medad wiewia. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Eri, Sosua, nein Nun, me papah Moses sang ni eh tikitik, ahpw ndalahng Moses, “Maing, komw katokeirahdi!” ");
INSERT INTO pon2006a_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moses ahpw sapengki, “Dah? Kowe me pahn kaweid ie? I ahpw men KAUN-O en ketin audehki aramas koaros sapwellime ngehn pwe re en pil kokohp ni ngihl laud!” ");
INSERT INTO pon2006a_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Moses oh kaun isiakano eri pwuralahng ni kahnimpwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Eri, mwurin met, kisinieng ehu ahpw kohda sang ni kupwur en KAUN-O; e ahpw ipirodohng nan kahnimpwalo lapalahn pelin kulu ieu, me kin pipihrseli piht siluh sang pohn pwehl. Re ahpw sokedi pohn kahnimpwalo oh pil pohn sahpw lel mwail kei pali koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Aramas ako eri soupisengkihla ar rikirikpene kulu ko ni rahno pwon, nipwongo pwon, oh pil manda sang rahno. Eri, me keieu malaulau me emen rikada, kohpwa laud limeisek. Re ahpw palangada pahn ketipin kapilpene kahnimpwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Eri, nindokon arail tungoal udungko eh saikinte rosala, KAUN-O ahpw engiengda pahn aramas ako oh ketin kalokehkin irail soumwahu lusulus ehu. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Iei me wasao adanekihla Kiprod Attapa (me wehwehki “Sousoun Mehwo kei”), pwehki ar sarepedi wasao aramas ako me mehwokihda uduk. ");
INSERT INTO pon2006a_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Mehn Israel ko eri mweselsang wasao, mwesellahng Aserod, wasa re kauwada ie imwarail impwal ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Eri, Miriam oh Aaron ahpw tapihada lipahnedih Moses, pwehki eh pwoudikihda lihen Kus men. ");
INSERT INTO pon2006a_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ira eri nda, “Pwe dah? Moses kelehpw me KAUN-O mahseniong? E soh pil mahseniong kita?” KAUN-O eri ketin karongehda ara lipahnedo. ");
INSERT INTO pon2006a_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Moses, iei ohl aktikitik men, me keieu aktikitik rehn aramas en sampah kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ni ahnsowohte, KAUN-O ahpw ketin mahsanihong Moses, Aaron oh Miriam, “I men kumwail silimenen en kohdo ni ei Impwalo.” Irail eri patohla. ");
INSERT INTO pon2006a_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","KAUN-O eri ketidihdo nan pelien depwek pali, e ahpw ket ni ewen Impwalo oh malipe Aaron oh Miriam. Ira eri patohla. ");
INSERT INTO pon2006a_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","A KAUN-O ahpw mahsanih, “Kumwa rong ei koasoi kat! Ma mie soukohp kei rehmwail, I pahn kasalehiong irail pein Ngehi nan kaudiahl, I pahn mahseniong irail nan ouraman. ");
INSERT INTO pon2006a_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","E pahn wekisang duwen ei kin mahseniong nei laduwen Moses, pwe I ketikihongehr en pwukoahki epwelpen nei aramas en Israel koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Eri, I kin mahseniong sang ni silangi, ni sansal, kaidehn ni mwohmw. E kilang ei lingan! Eri, ia duwen amwa kak kommwad en lipahnedih ei ladu Moses?” ");
INSERT INTO pon2006a_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","KAUN-O ketin engiengda pahrail; ih eri ketiketlahsang irail ");
INSERT INTO pon2006a_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","oh pelin depweko sohrasang pohn Impwalo, kilin Miriam ahpw tokutokla duwehla sinoh. Ni Aaron eh kilangada eh tokutoklahr, ");
INSERT INTO pon2006a_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","e ahpw patohwanohng Moses, “Maing, menlau komw dehr kapwukoahkin kiht kalokolok en dihp me se patohwan wiadahr nan at rotorot. ");
INSERT INTO pon2006a_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Komw dehr mweidohng lih menet en wiahla mehkot me ipwidi sohte mwomwe pwehki elep paliwere eh mwengesangehr.” ");
INSERT INTO pon2006a_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moses eri ngil laudida patohwanohng KAUN-O, “Maing Koht, komw kupwure oh ketin kamwahwihala liho!” ");
INSERT INTO pon2006a_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","KAUN-O eri ketin sapeng, mahsanih, “Ma eh pahpao kendipiong ni mese, e pahn namenekla erein rahn isuh. Eri en lekdeksang nan kahnimpwalen erein rahn isuh; mwuri e kak kapwurupwurdo.” ");
INSERT INTO pon2006a_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriam eri katohrohralahsang nan kahnimpwalo erein rahn isuh, eri aramas akan sohte mweselda e lao kapwurpwurdo nan kahnimpwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Irail eri mweselsang Aserod oh kohla kauwada imwarail impwal kan nan sapwtehn en Paran. ");
INSERT INTO pon2006a_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","KAUN-O mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Pilada emen kaun sang ni ehuehu kadaudok eisek riaun Israel kan oh kadarirailewei nan Kenan, nin duwen lipoahrok kei, pwe re en kasawih oh dawih sahpwo me I pahn kihong mehn Israel kan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","15","Moses eri kapwaiada oh kadarala lipoahrok pwukat sang ni sapwtehn en Paran: Kadaudok Kaun Reupen Samua nein Sakur Simion Sapad nein Ori Suda Kalep nein Sepune Isakar Ikal nein Sosep Epriam Osea nein Nun Pensamin Palti nein Rapu Sepulon Kadiel nein Sodi Manase Kaddi nein Susi Dan Ammiel nein Kemalli Aser Sedur nein Maikel Napdali Napi nein Popis Kad Keuel nein Makai ");
INSERT INTO pon2006a_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ih met kan lipoahrok kan me Moses kadarala pwehn kasawih oh dawih sahpwo. Eh ahpw kihong Osea, nein Nun, mwar kapw ehu, iei Sosua. ");
INSERT INTO pon2006a_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ni ahnsou me Moses kadarirailla, e patohwanohng irail, “Kumwail pahn keidwei paliepeng kolahng palieir en Kenan oh mwuhr keidwei pohn sahpw dohl kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Kumwail ahpw kilang soangen sahpw da ieu mwo, aramas depe me mihmi mwo oh ma re me kehlail. ");
INSERT INTO pon2006a_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Kumwail pil kilang ma sahpwo me kaselel de sakanakan oh ma aramas ako kin kousoan nansapw de nan kelen mahwen. ");
INSERT INTO pon2006a_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Pil kadehde ma pwelen sahpwo me mwahu oh ma mie tuhke tohto wasao. Kumwail pil wahdo ekei wahntuhke me kin keirda wasao.” (Ahnsowo iei ahnsoun pwerlahn wahn kreip.) ");
INSERT INTO pon2006a_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ohl ako eri keidla paliepeng oh dawih sahpwo sang nan sapwtehn en Sin ni palieir lao lel Rehop, limwahn Wasahn Kot en Amad ni paliepeng. ");
INSERT INTO pon2006a_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Re keidla ni palieir en sahpwo oh lel Epron, wasa me peneineien Aiman, Sesai, oh Talmai, kadaudok en kodon ko me adaneki mehn Anak kin kousoan ie. (Epron kokouda sounpar isuh mwohn Soan nan Isip.) ");
INSERT INTO pon2006a_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Irail ahpw lel nan Wahun Eskol, re ahpw pelehdi wasao rahntuhke kreip ehu me emwiemwin oh toutou, kahrehda ohl riemen me iniehda. Re pil wa pwurodo pwohmakraneid kei oh wahn pik kei. ");
INSERT INTO pon2006a_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","(Wasao adanekihla Wahun Eskol pwehki emwin kreip me mehn Israel ko wahsang wasao.) ");
INSERT INTO pon2006a_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Eri, mwurin rahn pahisek lipoahrok ko ahpw pwurodo sang ar dawih sahpwo; ");
INSERT INTO pon2006a_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","re ahpw pwurodo rehn Moses, Aaron oh pokon en mehn Israel ko nan Kades nan sapwtehn en Paran. Re ahpw koasoiaiong ira oh mehn Israel ko duwen dahme re kilang, oh re pil kasalehiong irail wahnsahpw ako me re wahdo sang nan sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Eri, iei koasoi me re wiahiong Moses; “Se lel nan sahpw me komw ketin kadarkitalahng ie. Sahpwo me audapan oh pwelmwahu, oh iet ekei wahnsahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ahpw towe kan me inenen kehlail, oh kahnimw kan me laud oh inenen kelpene mwahu. Se pil kilangada wasao aramas akan me kadaudok en kodon ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Mehn Amalek kin mihmi ni palieir; mehn Id, mehn Sepus oh mehn Amor kin mihmi ni wasa nahnahn kan; oh mehn Kenan kin mihmi limwahn Sehd Mediderenien oh ni keilen Pillap Sordan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalep eri oale irail en nennenla mwohn Moses, e ahpw nda, “Nna, kitail mwadang kohla mahweniong oh sapwenikihla sahpwo; pwe kitail uhdahn kak en kalowehdi.” ");
INSERT INTO pon2006a_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ahpw ohl ako me iang ih kohla, ahpw ketihtihki, “Soh! Kitail sohte kak mahweniong tohnsahpw pwukat, pwe re inenen kehlail sang kitail.” ");
INSERT INTO pon2006a_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Eri, arail koasoi ong mehn Israel ko duwen sahpw me re dawih oh kasawih me likamw. Re ahpw nda, “Wahnsahpw akan nan sahpwo sohte itarohng kamwenge towe kan. Aramas koaros me se kilangada wasa ko inenen reirei, ");
INSERT INTO pon2006a_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","oh se pil kilangada kodon kei wasao, me kadaudok en Anak, likamwete kiht mensiek uwen ar lapala.” ");
INSERT INTO pon2006a_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Eri, pwohng ehu pwon aramas ako sengisengki ar pwunod. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Re ahpw lipahnedihada Moses oh Aaron, ketihtihki, “Me pahn mwahu atail mehlahte nan Isip de nan sapwtehn wet! ");
INSERT INTO pon2006a_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Dahme KAUN-O ketikinkitaildohki nan sahpw wet? Kitail uhdahn pahn mehla nan mahwen; eri, atail pwoud kan oh neitail seri kan pahn wiahla dipwisou me lohdi nan mahwen. Atail pwuralahng Isip soh pahn mwahusang met?” ");
INSERT INTO pon2006a_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Irail eri tapihada ndapene, “Nna, kitail pilada emen me pahn kapwureikitailahng Isip.” ");
INSERT INTO pon2006a_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Eri, Moses oh Aaron ahpw poaridi nanpwel mwohn pokon en mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Oh riemen lipoahrok ko, me dawih sahpwo, Sosua, nein Nun, oh Kalep, nein Sepune, ahpw tehrpeseng ara likou ko, uwen ara nsensuwed, ");
INSERT INTO pon2006a_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ira eri ndalahng aramas ako, “Sahpw me se dawihero iei sahpw mwahu ehu. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ma KAUN-O ketin kupwurei kitail, e pahn ketin kahluwaikitaillahng nan sahpw kaselel wet oh ketikihong kitail. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Eri, kumwail dehr kahngohdiong KAUN-O. Kumwail dehr masak tohnsahpw wet; me mengei kitail en kaloweiraildi. KAUN-O pahn ketin ieiang kitail. E ketin kamwomwala ar koht akan, mehn doareparail. Kumwail dehr masak!” ");
INSERT INTO pon2006a_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ahpw pokono wie songosong en katehkin ira takai lao ira mehla; a ni ahnsowohte lingaling en KAUN-O pa sansalda pohn Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","KAUN-O ahpw mahsanihong Moses, “Ia erein aramas pwukat ar pahn mwamwahlikin ie? Ia erein ar pahn kahng kamehlele ie, ni ei wiadahr manaman tohtohie mwohn masarail kan? ");
INSERT INTO pon2006a_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Eri, I pahn kalokehkin irail soumwahu lusulus ehu pwe en kemeirailla. A kowe, I pahn wiahkin uhk wehi kapw ehu, wehi ehu me pahn lapalapasang oh tohtohsang irail.” ");
INSERT INTO pon2006a_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moses ahpw sapeng KAUN-O, patohwan, “Komwi me ketikihsang aramas pwukat nan Isip ni manaman lapalap en nin limomwi. A ni mehn Isip ar pahn rong dahme komw ketin wiahiong sapwellimomwi aramas pwukat, ");
INSERT INTO pon2006a_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","re soh pahn patohwanohng tohnsahpw wet? Pwe re pil iangehr rong duwen komwi, Maing KAUN, duwen omwi kin ketin ieiang kiht, duwen omwi kin ketin pwarada ni sansal mwohn masat ni ahnsou me sapwellimomwi pelien depweko eh kin uhdi poht, oh pil duwen omwi kin ketieng mwoht ni rahn ni mwomwen uhr depwek oh nipwong ni mwomwen uhr kisiniei. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Eri, ma komw pahn ketin kemehla sapwellimomwi aramas pwukat koaros, tohnwehi kan me rongehr duwen omwi ndand, pahn patohwan, ");
INSERT INTO pon2006a_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘KAUN-O sohte eh manaman pwe en ketikihong sapwellime aramas akan nan sahpw me e ketin inoukihong irail; ihme kahrehda e ketin kauwehkinirailla nan sapwtehn.’ ");
INSERT INTO pon2006a_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Eri, Maing KAUN, komw ketin kasalehda roson en sapwellimomwi manaman, oh wiahda dahme komw ketin inoukihong kiht ni sapwellimomwi mahsen wet, ");
INSERT INTO pon2006a_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Ngehi me KAUN-O, eri, I kin kanengamah oh kalahngan oh limpoak poatopoat; I kin mahkikihong dihp oh suwed en aramas; ahpw I pahn kaloke seri kan lel dih kesiluh oh kapahieu pwehki dipen ar pahpa oh nohno kan.’ ");
INSERT INTO pon2006a_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Eri, komw ketin kupwurkalahngan mahkikihong dipen aramas pwukat, duwen me konehng omwi limpoak lapalap oh poatopoat, nin duwen omwi ketin wiahiongirailehr sang ni ar mweselsang wehin Isip.” ");
INSERT INTO pon2006a_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","KAUN-O eri mahsanih, “Eri, I pahn mahkohng irail duwen me ke pekien. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ahpw I kahukihla ni mwarei oh pil ni ei lingaling me kin kadirehla sampah, ");
INSERT INTO pon2006a_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","me sohte emen nanpwungen aramas pwukat pahn pedolong nan sapwen inowo. Re kilangehr ei lingaling oh pil manaman akan me I wiadahr nan Isip oh pil nan sapwtehno; irail ahpw uhwong ie pak tohto oh sohte peikiong ie. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Eri, re sohte pahn pedolong nan sahpw wet me I inoukihong ar pahpa kahlap ako, sohte emen irail me mwamwahlikin ie pahn iang pedolong loale. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ahpw ei ladu Kalep kasalehda ehu soangen mour tohrohr oh e kin loalopwoatohng ie; ihme I pahn kahluwahng ih nan sahpw me e dawih oh kasawih, oh kadaudoke kan pahn sapwenikihla ");
INSERT INTO pon2006a_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","wasa patapat akan, wasa me mehn Amalek oh mehn Kenan kin kousoan ie met. Eri, lakapw kumwail mwesel oh pwurala nan sapwtehn kolahng ni Sehd Weitahta.” ");
INSERT INTO pon2006a_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Eri, KAUN-O ahpw mahsanihong Moses oh Aaron, ");
INSERT INTO pon2006a_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Ia erein pokon en aramas suwed pwukat ar pahn lipilipahnede ie? I pwahngahkidahr rongorong ar kaulim! ");
INSERT INTO pon2006a_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Eri, kihong irail ei pasapenget: ‘I kahukiha ni mwarei me I pahn wiahiong kumwail soahngohte me I rongasang kumwail. Ngehi, KAUN-O me mahmahsen. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Kumwail pahn mehla oh kahlepamwail kan pahn pwupwudiong nan sapwtehn wet. Pwehki amwail kaulimeielahr, sohte emen kumwail me mahkier sounpar rieisek kohda pahn pedolong nan sahpw ");
INSERT INTO pon2006a_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","me I kahukilahr mehlel I en koasoaneikumwaildi ie. Sohte mehmen kumwail pahn pedolong, ihte Kalep oh Sosua. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Kumwail nda me noumwail seri kan pahn wiahla dipwisou lohdi nan mahwen, ahpw iei irail pwukat me I pahn kapedolong ong nan sahpw me kumwail soikalahr; eri, re pahn sapwenikihla. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","A duwen kumwail, kumwail uhdahn pahn mehla nan sapwehten wet. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Noumwail seri kan pahn wiahla silepen sihpw oh kakahnseli nan sapwtehn erein sounpar 40, pweinen amwail soaloalopwoat, kumwail koaros lao pahn mehla. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kumwail pahn ale lokolok pwehki dipamwail kan erein sounpar 40, sounpar ehu ong ehuehu rahn pahiseko me kumwail dawihki sahpwo. Kumwail eri pahn pehmada wehwehn ei pahn uhwong kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","I kahukihla me I pahn wia soahng wet ong aramas suwed koaros me ehupene oh kahngohdihong ie. Kumwail koaros pahn mehla nan sapwtehn wet. Ngehi, KAUN-O, me mahmahsen.’” ");
INSERT INTO pon2006a_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Eri, ohl ako me Moses kadarala pwe re en dawih oh kasawih sahpwo, ahpw pwurodo oh wia koasoi likamw, me kahrehda mehn Israel ko kaulimehkihla KAUN-O oh lahlahwe. Eri, e ahpw ketin kalokehki lipoahrok pwukat soumwahu laud ehu me re mehkihla. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Sang rehn lipoahrok ehk riemeno, ihte me luhwehdi momour, Sosua oh Kalep. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ni Moses eh kasalehiong mehn Israel ko sapwellimen KAUN-O mahsen pwukat, aramas ako inenen pahtoula oh nsensuwedla kowahlap. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Eri, mandahn rahno, nimensehngie, re ahpw kohdalahng mahwen wasa nahna kan, ndinda, “Nna, kitail patopatohdalahng wasa me KAUN-O ketin mahsanihong kitail duwe. Kitail patohwan ese me kitail dipadahr.” ");
INSERT INTO pon2006a_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Moses ahpw patohwan, “Eri, dahme kumwail pahn ketiwohki sapeikiong KAUN-O met? Kumwail sohte pahn pweida. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Kumwail dehr kohdawei, pwe KAUN-O sohte ketin ieiang kumwail; kumwail uhdahn pahn lohdiong pahn amwail imwintihti kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ni amwail pahn mahweniong mehn Amalek kan oh mehn Kenan kan, kumwail uhdahn pahn kamakamala, pwehki amwail kahngalahr idawehn KAUN-O, me kahrehda e solahr pahn kin ketin ieiang kumwail.” ");
INSERT INTO pon2006a_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Irail ahpw wonlahte mwowe kohdalahng pohn nahna ko, mehnda ma sapwellimen KAUN-O Kohpwahn Inowo oh Moses sohte mwahn mwekidsang nan kahnimpwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Eri, mehn Amalek oh Kenan ahpw kohiei mahweniong irail oh kaloweiraildi, re ahpw pil pwakih irail lao lel Orma. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","KAUN-O ketikihong Moses koasoandi pwukat ");
INSERT INTO pon2006a_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","pwe mehn Israel kan en kin kapwaiada nan sahpw me e pahn ketikihong irail. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Kouwol men, sihpw wol men, sihpw men de kuht men pahn kin kak mweimweidahng KAUN-O pwehn wia meirong isihs de meirong en kapwaiada inou ehu de meirong en nsen, de meirong en warpwohmwahu, de meirong ni amwail sarawi kan. Pwohn meirong en konot pwukat kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","5","Mehmen me pahn patohwandahng KAUN-O sihpw men de kuht men, e pahn iangahki mahno paun en pilawa riau me doalki pain riau en lehn olip pwehn wia meirong en wahnsahpw, iangahki pain riau en wain. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Ma sihpw wol men me pahn wia mehn meirong, paun pahieu en pilawa me doalki pain siluh en lehn olip me pahn meirongala pwehn wia meirong en wahnsahpw, ");
INSERT INTO pon2006a_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","iangahki pain siluh en wain. Pwohn meirong pwukat kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Ma kouwol men me pahn meirongala pwehn wia meirong isihs de meirong en kapwaiada inou ehu de meirong en kaminimin, ");
INSERT INTO pon2006a_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","paun weneu en pilawa me doalki pain pahieu en lehn olip me pahn wia mehn meirong en wahnsahpw, ");
INSERT INTO pon2006a_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","iangahki pain pahieu en wain. Pwohn meirong pwukat kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Ih soahng pwukat me pahn meirongala ong emenemen kouwol, sihpw wol, sihpw de kuht eh pahn meirongala. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ni ahnsou me mahn tohtohsang emen me pahn meirongala, dipwisou me pahn iang emenemen mahn pahn duweduwehte ong emenemen mahn ako. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Mehn Israel koaros pahn kin wia met, ni arail pahn kin wia meirong en konot, pwowe kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Ahpw ahnsou koaros me mehn liki men me kin koukousoan rehmwail, mehnda ma ahnsou mwotomwot de reirei, me pahn wia meirong en konot, me pwowe kin kaparanda kupwur en KAUN-O, e pahn pil kapwaiada soangen koasoandiohte. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Sang met kohla koasoandi pwukat kin manaman ong kumwail oh ong mehn liki kan me kin kousoan rehmwail. Pwe kumwail oh irail soangen pahrekte ieu mwohn silangin KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Soangen kosonned oh koasoandi koaros kin doakedoake kumwail oh pil irail. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","KAUN-O ketikihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","koasoandi pwukat pwe mehn Israel ko en kin kapwaiada nan sahpw me e pahn ketikihong irail. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Ni amwail pahn kin tungoale wahnsahpwo, kumwail pahn kin katohrehsang ekis pwehn wia mehn kisakis kesempwal ehu ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ni ahnsou me kumwail pahn umwun pilawa, keieun lopwon sang ni wahn pilawa kapw pahn wia mehn kisakis kesempwal ehu ong KAUN-O. Met pahn meirongala duwehte kisakis kesempwal me kumwail kin wia ni meirong en wahnsahpw sang amwail wasahn koadoahki wahnsahpw. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Sang met kohla soangen kisakis kesempwal wet pahn kin wiawihong KAUN-O sang pilawa me kumwail pahn kin umwun. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Ahpw ma emen depweila oh sohte kapwaiada ehu koasoandi pwukat me KAUN-O ketikihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","oh ma sang met kohla mehn Israel koaros sohte kapwaiada mehkoaros me KAUN-O mahsanihong Moses pwe en padahkihong irail. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Ma sapwung wet wiawi pwehki ar sohte wehwehki, eri re pahn meirongkihla emen kouwol nin duwen meirong isihs, me pwowe kin kaparanda kupwur en KAUN-O, iangahki meirong en wahnsahpw oh wain me kin wiawi. Re pil pahn kapatahiong emen kuht wol mehn wia meirong en dihp. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Samworo ahpw pahn wia sarawien kamwakele mehn Israel koaros, oh diparailo ahpw pahn lapwada, pwehki ar depweikihla sapwung wet oh re patohwandahr ar meirong en dihp nin duwen meirong isihs ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Mehn Israel koaros iangahki mehn liki kan me kin kousoan rehrail pahn ale lapwepen diparailo, pwehki irail koaros iang pwukoahkihdi sapwung wet. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Ahpw ma aramas emen me depweikihla dihp ehu, e pahn meirongki kuht lih men me sounpar ehu nin duwen meirong en dihp. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Samworo ahpw pahn wia sarawien kamwakel mwohn silangin KAUN-O ni pei sarawio, dipen aramaso ahpw pahn lapwada. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Soangen koasoandihteieu doake koaros me pahn depweikihla dihp ehu, mehnda ma ih mehn Israel men de mehn liki men me kin kousoan rehmwail. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Ahpw aramas emen sohte lipilipil, mehn Israel de mehn liki, me dipada sang ni pein insene, e milahr nan dipen mwamwahliki KAUN-O, eri e pahn kamakamala, ");
INSERT INTO pon2006a_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","pwehki eh soikala kosonned en KAUN-O oh kauwehla ehu sapwellime koasoandi kan. E pahn pein pwukoahki eh mehla. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Nindokon mehn Israel kan ar koukousoan nan sapwtehn, ohl emen ahpw dierekda eh wesewesei tuwi ni rahnen Sapad. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","E ahpw pakahrdo rehn Moses, Aaron oh rehn mehn Israel ko koaros, ");
INSERT INTO pon2006a_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","re ahpw kihong nan imweteng, pwehki ar sehse dahme re pahn wiahiong. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","KAUN-O eri mahsanihong Moses, “Aramas menet pahn kamakamala; mehn Israel koaros pahn katehki takai likin kahnimpwalo e lao mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Mehn Israel koaros ahpw kahreieila ohlo likin kahnimpwalo oh katehki takai e lao mehla duwen KAUN-O e mahsanihong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","KAUN-O ketin mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","en patohwanohng mehn Israel kan, “Kumwail wiahda pengkir mehn kataman ni pwungipen amwail likou kan oh kihong kisin sahl poh mei ni ehuehu mehn kataman kan. Met pahn wiawi sang met kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Mehn kataman pwukat pahn katamankin kumwail ei kosonned koaros pwe kumwail dehr kin sohpeisang ie oh idawehn ineng en nan kapehdamwail kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Mehn kataman pwukat pahn kin katamankin kumwail en kapwaiada ei kosonned koaros; eri kumwail pahn wiahla nei aramas. ");
INSERT INTO pon2006a_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ngehi, KAUN-O amwail Koht, me kahreikumwaildo sang Isip pwe I en wiahla amwail Koht. Ngehi KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Kora, nein Isar, peneineien Kohad sang kadaudok en Lipai, ahpw kahngohdiongda Moses. Kadaudok en Reupen silimen ahpw iangala ih—Dadan oh Apiram, nein Eliap, oh On, nein Peled—pil iangahki mehn Israel 250, kaun ndahnd kei me pilipilda sang rehn mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Irail eri pokonpene mwohn Moses oh Aaron oh patohwanohng ira, “Kumwa nohn daulihala! KAUN-O ketin sapwellimaniki mehn Israel koaros, oh KAUN-O kin ketiket rehtail koaruhsie. Eri, a dahme komwi, Moses, kin pein kasapwilkomwihda pohn sapwellimen KAUN-O aramas akan?” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ni Moses eh rong met, e poaridiong nanpwel oh kapakap. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","E ahpw patohwanlahng Kora oh ienge ko, “Nimenseng en lakapw KAUN-O pahn ketin kasalehiong kitail ihs me e ketin sapwellimaniki; e pahn ketin mweidohng ih me e ketin sapwellimanikio, mehmeno, me e ketin piladahr en keieng mpe ni pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","Nimenseng en lakapw kowe oh iengomw kan pahn ale noumwail pan en kisiniei kan, audekihda mwoalus ngkingken oh warpwohmwahu, kumwail ahpw pahn walahng ni pei sarawio. Kitail ahpw pahn kilang ihs rehtail me KAUN-O ketin piladahr. Kumwail mehn Lipai kan, kumwail me nohn daulihalahr!” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moses pil usehla patohwanohng Kora, “Kumwail rong, kumwail mehn Lipai kan! ");
INSERT INTO pon2006a_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Kumwail wiahki mehkot mwahl, en Koht en Israel eh ketin katohreikumwailsang rehn mehn Israel teikan, pwe kumwail en kak keieng mpe, oh wia amwail doadoahk ni Impwal me KAUN-O kin ketiket loale, oh papah mehn Israel kan? ");
INSERT INTO pon2006a_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","E ketin mweidohng kumwail oh mehn Lipai teikan, kumwail en kak keieng mpe, a met kumwail pil anahne wiahla samworo! ");
INSERT INTO pon2006a_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ni omw akupwungiong Aaron, ni mehlel, KAUN-O, me kowe oh iengomw kan kahngohdiong.” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Moses eri ekerodo Dadan oh Apiram, ahpw ira sapeng ketihtihki, “Se sohte pahn kohwei! ");
INSERT INTO pon2006a_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Komw sohte itarki omwi kahreikitodo sang nan sahpw me pwelmwahu nan Isip, pwe komwi en kemeikitala nan sapwtehnet? Komw pil pahn kaunkitadahr? ");
INSERT INTO pon2006a_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Komw sohte kahreikitodohng nan sahpw pwelmwahu de kihong kiht mwetin wain, a met komw songosong en pitihkitedi. Soh, se sohte pahn patohwei rehmwi!” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moses eri lingeringerda oh patohwanohng KAUN-O, “Maing, komw dehpa kupwure meirong me aramas pwukat pahn patohwandohng komwi. I sohte wia mehkot suwed ong ira. I pil sohte kihsang emen neira ahs akan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moses ahpw patohwanohng Kora, “Kowe oh iengomw me 250 koaros pahn patohdo ni Impwal me KAUN-O kin ketiket loale; Aaron pahn pil iang mi wasao. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Emenemen kumwail pahn wa kohdo nah pan en kisiniei, oh audekihda mwoalus ngkingken oh warpwohmwahu loale, oh meirongki ong KAUN-O ni pei sarawio.” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Eri, emenemen irail ahpw ale nah pan en kisiniei, oh audekihda mwoalus ngkingken oh warpwohmwahu, oh uh ni wenihmwen Impwalo, iangahki Moses oh Aaron. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kora eri kapokonepene aramas koaros, re ahpw uh sohpeiong Moses oh Aaron ni wenihmwen Impwalo. Lingaling en KAUN-O pa mwadangete pwaradahng aramas koaros, ");
INSERT INTO pon2006a_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","KAUN-O eri mahsanihong Moses oh Aaron, ");
INSERT INTO pon2006a_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Kumwa keiweisang rehn aramas pwukat, pwe I pahn mwadang kamwomwirailla.” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Moses oh Aaron ahpw poaridiong nanpwel oh kapakap patohwan, “Maing Koht, komwi me pwarer en mour. Ahnsou me aramas emen kin dipada, komw kin ketin engiengda pahn aramas koaros?” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Ndaiong aramas akan re en keiweisang ni en Kora, Dadan oh Apiram imwarail impwal kan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moses eri patohla rehn Dadan oh Apiram iangahki kaunen mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","E ahpw patohwanohng irail, “Kumwail keiweisang limwahn en aramas suwed pwukat ar impwal kan oh dehr doahke mehkot me arail. Ma soh, kumwail pahn iang kamwomwmwomwla pwehki diparail kan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Irail eri keilahsang limwahn en Kora, Dadan oh Apiram ar impwal ko. Dadan oh Apiram ahpw pedoi oh kesikesihnen ni wenihmwen imwara impwal, iangahki ara pwoud kan oh neira seri kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moses ahpw patohwanohng aramas ako, “Ih duwen met amwail pahn ese me KAUN-O ketin kedariehdo pwe I en kapwaiada mepwukat koaros ahpw kaidehkin nsenei me I wiewiahki mepwukat. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ma aramas pwukat pahn mehkihla mehla mwahl ni sohte kalokolok sang rehn KAUN-O, eri a KAUN-O sohte ketin kadariehdo, ");
INSERT INTO pon2006a_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ahpw ma KAUN-O pahn ketin wiahda mehkot kapwuriamwei oh sampah pahn sarapeseng oh kadallehla ira oh mehkoaros me ira ahneki, pwe ira en kohdihla nan wasahn me melahr akan ni ara momourte, kumwail pahn esehki me aramas pwukat kahngohdiong KAUN-O oh soikala ih.” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","E nekte eh patohwan mepwukat, pwehl me mi pahn nehn Dadan oh Apiram pa sarapeseng ");
INSERT INTO pon2006a_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","oh kadallehla ira koaros oh ara peneinei kan iangahki iengen Kora koaros oh mehkoaros me irail ahneki. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Irail eri mourte kohdihla nan wasahn me melahr akan, iangahki ar dipwisou koaros. Pwehlo eri pwurpene oh irail sohrala. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Mehn Israel koaros me mihmi wasao ahpw tangpeseng ni ar rongada ngilen ar mwahmwahiei. Re ahpw weriwer ndinda, “Kitail tang pwe sampah dehr pil kadalleikitailla.” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","KAUN-O ahpw ketin kadaridi kisiniei me kamwasikahla aramas 250 me meirongki warpwohmwahu. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","KAUN-O eri mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Ndaiong Eleasar, nein samworo Aaron, en kihsang pan prons en kisiniei me mihmi rehn ohl me melahr ako, oh en kamwarakpeseng mwoalus ko ekis wasa doh, pwe pan en kisiniei ko me sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Pan pwukat kasarawihla ni ahnsou me re mweimweidahng KAUN-O ni pei sarawio. Eri, ale nein aramas pwukat me kamakamkihla diparail kan, neirail pan en kisiniei kan oh sukpene lao wiahla pelien mete menipinip oh wiahkihla mehn pwaindi pei sarawio. Met pahn wiahla mehn kapar ehu ong mehn Israel. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Eri, samworo Eleasar ahpw ale pan en kisiniei ko oh sukpene lao wiahla pelien mete menipinip pwe en wiahda pweinen pei sarawio. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Met wiahla mehn kapar ehu ong mehn Israel ko pwe emen me kaidehn kisehn kadaudok en Aaron dehr keiong mpen pei sarawio pwe en meirongkihong KAUN-O warpwohmwahu. Ma e pahn wia, e pahn kamakamala duwehte Kora oh ienge ko. Mepwukat koaros wiawiher nin duwen KAUN-O eh masanihong Moses en patohwanohng Eleasar. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Manda sang rahno aramas koaros ahpw lipahnedihada Moses oh Aaron ketihtihki, “Kumwa kemelahr ekei sapwellimen KAUN-O aramas akan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ni ar pokonpene pwe re en uhwong Moses oh Aaron, re sohpeilahng Impwalo oh kilangada duwen pelien depwek pali eh pwapwaindi oh lingaling en KAUN-O eh pwarada. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moses oh Aaron ahpw kohla oh uh mwohn Impwalo, ");
INSERT INTO pon2006a_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","KAUN-O ahpw mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Keiweisang mpen aramas pwukat pwe met I pahn kamwomwirailla!” Ira riemeno eri poaridiong nanpwel, ");
INSERT INTO pon2006a_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moses eri patohwanohng Aaron, “Ale noumw pan en kisiniei, oh audekihda mwoalus ngkingken sang ni pei sarawio oh kihong ekei warpwohmwahu nan mwoalus kan. Kowe eri mwadang kohwei rehn aramas akan oh wia sarawien kamwakel. Nna mwadang! Pwe engieng en KAUN-O tepidahr oh soumwahu lusulus ehu tepidahr.” ");
INSERT INTO pon2006a_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aaron eri kapwaiada, e ale nah pan en kisiniei oh tangala wasa me aramas ako wie pokopokon ie, ni eh kilangada me soumwahwo tepidahr, e ahpw kihong warpwohmwahu pohn mwoalus ko oh wiahda sarawien kamwakele aramas ako. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Met kahrehda soumwahwo eh tokedi, Aaron ahpw uh nanpwungen me momour oh me melahr akan. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Wadepen aramas me mehla mihmi ni 14,700, me mehla ni moromor en Kora sohte wadawadohng. ");
INSERT INTO pon2006a_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ni ahnsou me soumwahu lusuluso tokedi, Aaron ahpw pwurala rehn Moses ni wenihmwen Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Patohwanohng mehn Israel kan re en kihong uhk sokon ehk riapwoat, apwoat sang rehn kaunen ar kadaudok kan. Ke ahpw ntingihedi eden emenemen kauno ni eh sokon ");
INSERT INTO pon2006a_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","oh pil ntingihedi eden Aaron ni sokon en Lipai. Emenemen kaunen kadaudok kan pahn ahneki apwoat sokon. ");
INSERT INTO pon2006a_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ke ahpw wahla ni Impwal me I pahn kin ketiket loale oh kihdiong mwohn Kohpwahn Inowo, wasa I kin tuhwong uhk ieo. ");
INSERT INTO pon2006a_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Eri sokon en aramas me I piladahr pahn masalpeseng. Ih duwen met ei pahn katokihedi en mehn Israel kan ar kin lipahnedihiuk.” ");
INSERT INTO pon2006a_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moses eri patohwanohng mehn Israel ko, oh emenemen kaun ahpw kihong ar sokon kan, ehu sang ehu kadaudok, eri koaros patpene me ehk riapwoat, oh en Aaron eh sokon pil iang patehng. ");
INSERT INTO pon2006a_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moses eri patohwandiong nan Impwalo sokon ko koaros mwohn Kohpwahn Inowo. ");
INSERT INTO pon2006a_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Mandahsang rahno ni en Moses eh patohla nan Impwalo, e kilangada duwen en Aaron eh sokono, me wiliandi kadaudok en Lipai, eh masalpesengehr. E mpwekda, masalpeseng oh kapwarehda wahn almond kei me mahier. ");
INSERT INTO pon2006a_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moses eri ale sokon ko koaros oh wahiei oh kasalehiong mehn Israel ko. Re kilangehr dahme pweidahr oh emenemen ahpw ale uhdahn eh sokon. ");
INSERT INTO pon2006a_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","KAUN-O ahpw mahsanihong Moses, “Kapwurediong en Aaron sokonen mwohn Kohpwahn Inowen. Pwe en nekinek men pwe en wia mehn kapar ong mehn Israel me kahngohdi kan, pwe re en katokihedi ar lipahned kan; pwe ma soh, re pahn mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moses eri wiahda nin duwen KAUN-O eh mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Mehn Israel ko eri patohwanohng Moses, “Eri ih pahn imwilaht met! ");
INSERT INTO pon2006a_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Mehmen me pahn keiwohng mpen Impwalo eh pahn kamakamala, eri kitail koaruhsie pahn mehla!” ");
INSERT INTO pon2006a_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","KAUN-O ketin mahsanihong Aaron, “Kowe, noumw seri oh mehn Lipai kan, kumwail pahn pwukoahki mehkoaros me sapwung ni amwail doadoahk nan Impwal me I pahn kin ketiket loale; ahpw kowe oh noumw seri kan me pahn pwukoahki me sapwung ni amwail doadoahk en samworo. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Pil kahrehdo kisehmw, me kadaudok en Lipai, pwe re en kin sewesei kumwail nindokon kowe oh noumw seri kan amwail pahn kin doadoahk nan Impwal wet. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Re pahn seweseiuk oh kapwaiada arail pwukoa kan nan Impwalo, ahpw re sohte pahn sair pei sarawio de dipwisou sarawi kan nan Wasa Sarawio. Ma re pahn sair mepwukat, kowe oh irail koaros pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Irail pahn iang uhk doadoahk oh re pahn kapwaiada ar pwukoa kan me pid arail doadoahk nan Impwalo; ahpw sohte emen tohrohr me pahn iang uhk doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Kowe oh noumw pwutak kante me pahn pwukoahki doadoahk nan Wasa Sarawio oh ni pei sarawio, pwe ei engieng en dehr pwurehng lel mehn Israel kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ngehi me pilada kisehmw kadaudok en Lipai kan sang rehn men Israel kan, eri kalahngan ehu sang rehi. Re kasarawilahr ong ie pwe re en kapwaiada arail pwukoa kan nan Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ahpw kowe oh noumw pwutak kante me pahn pwukoahki pwukoahn samworo me pid pei sarawio oh audepen Wasa Sarawiheo. Ih met kan amwail pwukoa, pwehki ei kihong kumwail kalahngan en samworo. Mehmen me sohte iang pwihn en samworo e ahpw keieng mpen dipwisou sarawi pwukat pahn kamakamala.” ");
INSERT INTO pon2006a_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","KAUN-O ketin mahsanihong Aaron, “Tamataman pwe ngehi me kihong kumwail samworo kan pwaisamwail sang ni meirong kesempwal kan likin meirong isihs en mehn Israel kan. I kihong kumwail oh kadaudokamwail kan pwehn wia pwaisamwail kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Iet kan pwaisamwail sang ni meirong sarawi kan me sohte kin isihsla pohn pei sarawio: meirong en wahnsahpw, meirong en dihp, oh meirong en kapwungala sapwung kan. Mehkoaros me mweimweidahng ie pwehn wia meirong kesempwal iei pwaisomw oh pwaisen noumw seri kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Kumwail pahn kin tungoale soahng pwukat wasa sarawi ehu, oh ohl kante me pahn kin tungoale. Kumwail pahn kin wiahki mepwukat mehkot sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Kumwail pil pahn pwaisanki meirong kesempwal teikan me mehn Israel kan pahn kin mweidadahng ie. I kihong mepwukat ong kowe, noumw pwutak kan oh noumw serepein kan sang met oh kohkohlahte. Koaros me kisehn omw peneinei oh mwakelekel ong kaudok pahn kak iang tungoale. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“I pil kihongkumwailehr keieun wahnsahpw kaselel me mehn Israel kan kin nohpweikihong ie nan sounpar koaros: eri lehn olip, wain oh wahnsahpw. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Koaros pahn kohieng kumwail, oh tohn amwail peneinei koaros me mwakelekel ong kaudok kak iang tungoale. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Mehkoaros nan wehin Israel me kasarawihongieier pahn wia pwaisamwail. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“Mesenih koaros, aramas de mahn, me mehn Israel kan kin meirongkihong ie pahn kohieng kumwail, pwe kumwail en ahnekihla. Ahpw kumwail pahn ale pweinen pweipweida sapahl en mesenihen aramas koaros, oh pil ale pweinen mesenihen mahn me samin ong kaudok. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Seri kan pahn kin pweipweida sapahl ni ar sounpwong ehu ni pweipwein mwohni silper limau nin duwen me koasoandier. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Ahpw mesenihen kou, sihpw, oh kuht kan sohte pahn pweipweida sapahl, pwe ngehi me naineki oh re pahn meirongala. Kumwail usupihki ntahrail pei sarawio oh isikala wihe ko pwehn wia meirong en konot, me pwowe kin kaparaniehda. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Uduk kan iei pwaisamwail, duwehte mwaremware, oh neh palimaun en meirong kesempwal kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“I kihonguhkehr, oh ong noumw pwutak kan oh noumw serepein kan, sang met oh kohkohlahte, meirong kesempwal kan koaros me mehn Israel kan kin meirongkihong ie. Met inou ehu me sohte kak ohla me I wiahiong kumwail oh kadaudokamwail kan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","KAUN-O ketin mahsanihong Aaron, “Ke sohte pahn ale sohso ieu sang ni sapwen mehn Israel kan de sohte wasa kis pahn kohieng uhk, pwe ngehi, KAUN-O, me pahn wia pwaisomw oh omw sohso.” ");
INSERT INTO pon2006a_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","KAUN-O ketin mahsanih, “Mehn Israel kan kin meirongkihong ie eisek kis ehun arail dipwisou kan; eri meirong pwukat I kihongehr mehn Lipai kan. Met pwehn wia pweinen doadoahk en apwahpwalih Impwal me I pahn kin ketiket loale. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Mehn Israel teikan solahr pahn keieng mpen Impwalo, pwe re dehr ale kalokolok en kamala. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Sang met kohla mehn Lipai kante me pahn kin apwahpwalih Impwalo oh irailte me pahn kolokol pwukoa kan koaros. Met koasoandi poatopoat ehu me doke kumwail oh kadaudokamwail kan. Mehn Lipai kan sohte pahn sohsohki mehkot nan Israel, ");
INSERT INTO pon2006a_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","pwe I kihongirailehr ar sohso eisek kis ehun kisakis kan me mehn Israel kan kin mweidadahng ie ni mwomwen meirong kesempwal ehu. Ih me I ndakihong irail me re sohte pahn sohsohki mehkot nan Israel.” ");
INSERT INTO pon2006a_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","KAUN-O ketin mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","en ndaiong mehn Lipai ko, “Ni ahnsou me kumwail kin ale meirong kan sang mehn Israel kan me KAUN-O ketikihong kumwail pwe kumwail en pwaisanki, kumwail en patohwandahng KAUN-O eisek kis ehun meirong ko pwehn wia amwail kisakis kesempwal ehu ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Soangen meirong kesempwal wet kumwail pahn kin wiahki duwehte meirong me soumwet men kin wiahsang ni wahnsahpw kapw oh wain kapw. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ih duwen met amwail pahn pil wia amwail meirong kesempwal ong KAUN-O sang ni meirong koaros me kumwail kin ale sang rehn mehn Israel kan. Kumwail ahpw pahn patohwanohng Aaron meirong kesempwal pwukat me ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Kumwail patohwanohng me keieu kaselel sang ni kisakis pwukat me kumwail kin ale. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Mwurin amwail patohwandahngehr me keieu kaselel kan, kumwail kak pwaisanki me luhwe kan, duwehte soumwet me kin pwaisanki luhwen me e kin meirongkihla. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Kumwail oh amwail peneinei kan kak tungoale luhwe kan wasa koaros sohte lipilipil, pwe ih pweinen amwail doadoahk nan Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Kumwail sohte pahn dipaniki amwail pahn tungoale mepwukat pwehki amwail patohwandahngehr KAUN-O. Ahpw kumwail kanahieng pwe kumwail de kasaminehla kisakis sarawi pwukat en mehn Israel, ni amwail pahn tungoale mwohn ahnsou me keieu kaselel eh pahn meirongala; ma kumwail pahn wia met, kumwail pahn mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","KAUN-O ketin mahsanihong Moses oh Aaron ");
INSERT INTO pon2006a_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","ira en ndaiong mehn Israel kan koasoandi pwukat. Re en wahdo kou weitahta men me sohte kisin samin kis reh oh me saikinte doadoahk, ");
INSERT INTO pon2006a_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","oh re en kihong samworo Eleasar. Kouo ahpw pahn pakahrlahng likin kahnimpwalo oh kamakamala ie mwohn samworo. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Samworo Eleasar ahpw pahn kaduh sendinpeh nan ntao oh usupihki pak isuh mwohn Impwalo. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Mwuhr, mahno pwon, iangahki kili, uduke, nta oh kepwehn loale kan pahn isihsla mwohn mesen samworo. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Samworo ahpw pahn ale rahntuhke sidar ehu, isop ehu oh kisin sahl weitahta kis, oh keselahng nan kisinieio. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Samworo ahpw pahn lopworada eh likou kan oh duhpki paliwere pihl; mwurin met e pahn kak pwurodohng nan kahnimpwalo; ahpw e pahn samisaminte lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Aramas me isikala mahno pahn pil lopworada eh likou kan oh duhpki pihl paliwere, ahpw e pahn pil samisaminte lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Eri aramas emen me mwakelekel ong kaudok pahn kihpene pehs en kouo oh koasoanediong wasa mwakelekel kis likin kahnimpwalo. Ih wasao me e pahn nekinek ie pwe mehn Israel kan en kin doadoahngki ni ar pahn kin kaunopada pihl mehn kamwakel. Sarawi wet iei sarawien lapwahsang dihp. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Aramas me kihpenehr pehs en kouo pahn pil lopworada eh likou kan oh e pahn samisaminte lao lel nin soutik. Koasoandi wet pahn manaman kohkohlahte ong mehn Israel kan oh ong mehn liki kan me kin kousoan rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Mehmen me pahn sairada aramas mehla e pahn saminla ong kaudok erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","E pahn kamwakelkihda pilen kamwakel ni rahn kesiluh oh ni rahn keisuh, e ahpw pahn mwakelekella. Ahpw ma e sohte kamwakelehda pein ih ni kesiluh oh keisuhn rahn, e sohte pahn mwakelekella. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Mehmen me sairada aramas mehla men ahpw sohte kamwakelehda pein ih pahn samisaminte pwehki pilen kamwakel eh sohte kamwakelehda. E pahn kasaminehla Impwalen KAUN-O, oh e sohlar pahn wia kisehn sapwellimen Koht aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ma aramas emen pahn mehla nan impwal ehu, mehmen sohte lipilipil me mihmi nan impwalo ni ahnsoun mehlao de pedolong loale, pahn saminla erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Sah koaros oh einpwoat koaros me sohte pweine pil pahn saminla. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ma mehmen sairada aramas emen me kamakamalahr de melahr mwahl likin ihmw ehu, de ma mehmen sairada tihn aramas de sousou ehu, e pahn saminla erein rahn isuh. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Pwehn kamwakelsang soangen samin pwukat, pehs en kou weitahtao me isihslahr pwehn lapwahda dihp pahn wisikdo oh kohieng nan ehu einpwoat, oh pil iangahki pihl mwakelekel. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","A duwen impwalo me aramas mehla loale, mehmen me mwakelekel ong kaudok pahn ale rahn isop, kaduh nan pihlo oh usupihki impwalo, dipwisou kan koaros loale, oh iangahki aramas koaros me mihmi loale. Nin duwen aramaso me sairada aramas mehlao de tihn aramas de sousou ehu, mehmen me mwakelekel ong kaudok pahn usupihki pihlo aramaso me sairada soahng pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Ni kesiluh oh keisuhn rahn aramaso me mwakelekel ong kaudok pahn usupihki pihlo aramas samino. Ni keisuhn rahn e pahn kamwakelehda aramaso, oh mwurin aramaso eh pahn lopworada eh likou kan oh pein duhpki pihl paliwere, eri e pahn mwakelekelda nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Mehmen me pahn saminla ong kaudok ahpw sohte kamwakelehda pein ih pahn samisaminte pwehki pilen kamwakel eh sohte kamwakelehda. E pahn kasaminehla Impwalen KAUN-O, oh e solahr pahn wia kisehn sapwellimen Koht aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Kumwail pahn kin kapwaiada koasoandi wet kohkohlahte. Aramas me kin usupiki pihl en kamwakel pahn pil lopworada eh likou kan, oh mehmen me pahn doahke pihlo, pahn saminla ong kaudok lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Soahng koaros me aramas samin men pahn doahke pahn saminla, oh mehmen me pahn doahke soahng pwukat pahn saminla lao lel nin soutik. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Mehn Israel ko koaros eri lel nan sapwtehn Sin ni keieun sounpwong, re ahpw kousoanla wasao ahnsou kis, oh ih wasao me Miriam mehla oh seridi ie. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Pihl eri rosala wasao; aramas ako eri kohla kapilpene Moses oh Aaron, ");
INSERT INTO pon2006a_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","re ahpw kaulimla, ketihtihki, “E mwahwongete kitail en iang riatail mehn Israel ko mehla mwohn Impwalen KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Dahme komw kahrekinkitodohng nan sapwtehn wet? Pwe kiht oh nait mahn akan en mehla wasaht? ");
INSERT INTO pon2006a_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Dahme komw wahkinkitasang Isip, weikitodohng nan sahpw sakanakan wet? Sohte mehkot kak keirda wasaht, sohte kohn, sohte tuhke pik, sohte wahn wain, sohte tuhke pwohmakraneid. Pil sohte mwahn kisin pihl kis mehn nimpil.” ");
INSERT INTO pon2006a_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moses oh Aaron eri tohrohrala sang pokono oh patohla ni wenihmwen Impwalo. Ira eri poaridiong nanpwel, oh lingaling en KAUN-O ahpw pwarohng ira. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","KAUN-O eri ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Ale sokon me mi mwohn Kohpwahn Inowo. Eri, kowe oh riomw Aaron, kumwa kapokonepene mehn Israel kan koaros. Eri, mwohn masarail koaros kumwa lokaiaiong paipalapen, e ahpw pahn kakusada pihl. Ih duwen met amwa pahn kapwilasang pihl nan paipen pwe aramas akan, iangahki neirail mahn akan, re en nim.” ");
INSERT INTO pon2006a_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moses eri kohla ale sokono, nin duwen KAUN-O eh ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Ih oh Aaron eri kapokonepene aramas ako koaros mwohn paipalapo. Moses eri mahsanihong irail, “Kumwail rong, kumwail me nan kapehd keptakailahr kan. Ia duwe, se pahn kakusieisang pihl nan paipalap wet, pwe kumwail en nim?” ");
INSERT INTO pon2006a_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moses eri kolada sokono wokihki pak riau paipo. Pihl pa kusukusiei. Irail koaros oh nair mahn akan eri nimpil. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ahpw KAUN-O ketin mahsanihong Moses oh Aaron, “Pwehki amwa pwoson sohte itarohng amwa pahn kalohkihda roson en ei manaman sarawi mwohn mehn Israel kan, kumwa sohte pahn kahluwairaillahng nan sahpw me I inoukihong irail.” ");
INSERT INTO pon2006a_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Met wiawiher nan Meripa, wasa me mehn Israel ko uhwong KAUN-O oh kaulimala, oh wasa me e ketin kasalehiong irail ie me ih me sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moses eri kadarala meninkeder kei rehn nanmwarkien Edom sang Kades, ketihtihki, “Pekipek wet sang rehn kisehmwi kan, me kadaudok en Israel. Komw mwahngih duwen apwal akan me lelohngkitehr, ");
INSERT INTO pon2006a_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","duwen at pahpa kahlap ako ar patohdihla Isip, oh duwen at kousoan wasao erein sounpar tohto. Mehn Isip ko ahpw wiakauwehla at pahpa kahlap ako, oh pil kiht. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Se ahpw likweriong KAUN-O en ketin sewesei kiht. E ketin karongei kiht oh ketin kadarodo tohnleng men, oh ketin kahluwaikitasang wehin Isip. Eri met se patopato Kades, kahnimw ehu ni irepen sapwellimomwi wehi. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Komw kupwurkalahngan mweidohng kiht se en patohwan kotehla sapwellimomwi wehi. Kiht oh nait kou kan sohte pahn keid nansapw de nan mwetin wain kan. Se sohte pahn nimasang pilen sapwellimamwail pwarer kan. Se pahn keid nan allap, se lao daulih sapwellimomwi wehi.” ");
INSERT INTO pon2006a_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Mehn Edom kan ahpw sapeng, ketihtihki, “Se sohte pahn mweidohng kumwail en kotehla at wehi. Ma kumwail kotehla, se pahn mahweniong kumwail.” ");
INSERT INTO pon2006a_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Mehn Israel ko eri patohwan, “Ahpw ia duwe, pwe se pahn kekeidte nan elen wehi, ma kiht oh nait mahn akan pahn nim amwail pihl kan, se pahn pwainohng kumwail—ihte me se mwahuki, se en kotehwei sahpwen.” ");
INSERT INTO pon2006a_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mehn Edom kan ahpw pwurehng ketihtihki, “Soh! Kumwail sohte pahn kotehdo at wehi.” Irail eri kohieilahng tuhwong mehn Israel ko iangahki karis en sounpei pwe re en mahweniong irail. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Eri, pwehki mehn Edom kan ar kahngete mehn Israel ko en kotehla sapwarailo, mehn Israel ko eri keid ni apwoat ahl tohrohr. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Mehn Israel ko koaros eri mweselsang Kades, re ahpw kohla oh lel nin Nahna Or, ");
INSERT INTO pon2006a_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","limwahn irepen wehin Edom. Eri, KAUN-O ahpw mahsanihong Moses oh Aaron wasao, ");
INSERT INTO pon2006a_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaron sohte pahn iang pedolong nan sahpw me I inoukihda me I pahn kihong mehn Israel kan. E pahn mehla pwehki amwa uhwong ei mahsen kan nan Meripa. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Eri, ale Aaron oh nah pwutak Eleasar oh kahreiralahng nin Nahna Or. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Eri, ke ahpw kihsang en Aaron eh likoun samworo kan oh kalikawihkihda Eleasar, pwe Aaron pahn mehla wasao.” ");
INSERT INTO pon2006a_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moses eri kapwaiada mehkoaros duwen KAUN-O eh ketin mahsanih. Irail kohdahla pohn Nahna Or mwohn mesen aramas ako koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moses ahpw kihsang en Aaron eh likoun samworo ko oh kalikawihkihda Eleasar. Aaron eri mehla wasao pohn nahnao; oh Moses oh Eleasar pwuredihsang pohn nahnao. ");
INSERT INTO pon2006a_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Mehn Israel ko ahpw rongada me Aaron melahr, re ahpw mwahieiki erein rahn silihsek. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ni ahnsou me nanmwarkien Arad, mehn Kenan men me kin ketiket palieir en sahpwo, karongehda me mehn Israel ko kohkohdo nanial en Adarim, e ahpw mahweniong irail oh salihedi ekei irail. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Mehn Israel ko eri kahula oh inoukihong KAUN-O, patohwan, “Ma komwi pahn ketikihong aramas pwukat pahn at manaman, se pahn patohwan kasarawiong komwi douluhl ar kahnimw kan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","KAUN-O eri ketin karonge mehn Israel ko oh e ahpw ketikihong mehn Kenan ko pahn ar manaman. Mehn Israel ko eri kamwomwirailla douluhl iangahki ar kahnimw kan; ihme re kahdanekihla wasao Orma. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Mehn Israel ko eri mweselsang nin Nahna Or kolahng ni Sehden Akapa, pidipidahki likin wehin Edom. Ahpw aramas ako sohla kak kanengamahiong apwal en seiloako; ");
INSERT INTO pon2006a_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","re ahpw tapihada lipanedihada Koht oh Moses, ketihtihki, “Dahme komw waikinkitodohsang Isip? Pwe se en kodohng mehla nan sapwtehnet, wasa me sohte kisin tungoal, oh sohte pihl? Se solahr kak tungoale kisin tungoal sakanakan wet!” ");
INSERT INTO pon2006a_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","KAUN-O eri ketin kadarala sineik pwoisin kei rehn aramas ako me keirailpene oh kemehla mehn Israel tohto. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Aramas ako eri kohla rehn Moses oh ndaiong, “Se dipadahr ong KAUN-O oh pil ong komwi ni at lipanedih kumwa. Eri, komw kasakaskin kiht rehn KAUN-O pwe en ketikihsang sineik pwukat.” Moses eri kapakapki aramas ako. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","KAUN-O eri mahsanihong Moses en wiahkihda mete emen sineik oh langahda ni apwoat tuhkehn, pwe mehmen me sineik kan pahn ngalispene ahpw kilengdahng, e pahn mourla. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moses eri wiahda sineik men sang prons oh langahda ni tuhke pwoat. Pwe mehmen me sineik kan pahn ngalispene en kak kilengdahng oh e ahpw pahn mwahula. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Mehn Israel ko ahpw mwekidla oh kauwada imwarail impwal ko Apod. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Mwurin ar mweselsang wasao re kauwada imwarail impwal ko nan mohn imwen Aparim nan sapwtehn ni palimesehn sapwen mehn Mohap kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Mwuhr re ahpw kauwada imwarail impwal kan nan Wahun Sered. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Sang wasao re pil mwekidla oh kauwada imwarail impwal kan ni paliepeng en Pillap Arnon, nan sapwtehn me kohla lel sapwen mehn Amor kan. (Arnon iei irepen sapwen mehn Mohap oh sapwen mehn Amor.) ");
INSERT INTO pon2006a_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Ih kahrepen Pwuhken Mahwen kan en KAUN-O koasoia “...kisin kahnimw en Wahep nan Supa, oh wahu kan; Pillap Arnon, ");
INSERT INTO pon2006a_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","oh wasa ukedi en wahu kan me kolahng kahnimw Ar oh lellahng irepen Mohap.” ");
INSERT INTO pon2006a_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Sang wasao re ahpw kohla wasa kis me adaneki Pwarer Kan, wasa me KAUN-O mahsanihong Moses, “Kapokonepene aramas akan pwe I pahn kihong irail pihl.” ");
INSERT INTO pon2006a_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ni ahnsowo mehn Israel ko ahpw koulki koul pwoatet: Pwarer kan, kakusada amwail pihl; se ahpw pahn pereperen kasamwohki at koul— ");
INSERT INTO pon2006a_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","pwarero me soupeidi kan weirada oh kaunen aramas akan weirkihda reireiso pwoat oh arail sokon kan.” Re mwekid sang nan sapwtehn kolahng Madana, ");
INSERT INTO pon2006a_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","oh sang mwo re kohla Nahaliel, oh sang Nahaliel kolahng Pamod, ");
INSERT INTO pon2006a_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","oh sang Pamod kolahng wahun sapwen mehn Mohap kan, pahn kumwen Nahna Piska, sallahng sapwtehno. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Mehn Israel ko eri kadaralahng Sihon, nanmwarkien mehn Amor, meninkeder kei me ketihtihkihong, ");
INSERT INTO pon2006a_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Komw kupwurkalahngan mweidohng kiht se en patohwan kotehla sapwellimomwi wehi. Kiht oh nait kou kan sohte pahn patohsang nan ahl, se sohte pahn keid nansapw de nan mwetin wain kan. Se sohte pahn nimasang pilen sapwellimomwi pwarer kan. Se pahn keid nan allap, se lao daulih sapwellimomwi wehi.” ");
INSERT INTO pon2006a_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ahpw Sihon sohte kupwurki mehn Israel ko en kotehla sapwellime wehi. Iei me e kapokonepene sapwellime karis oh ketla Sahas nan sapwtehn oh mahweniong mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ahpw mehn Israel ko kemehla kiden imwintihti nan mahwen oh kalowehdi sapwen mehn Amor ko sang Pillap Arnon ni paliepeng en Sappok lel ni irepen mehn Ammon kan, pwe mehn Ammon kan kin sinsile mwahu sapwarailo. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Mehn Israel ko eri kalowehdi kahnimw koaros en mehn Amor iangahki Espon oh kahnimw koaros me mi limwah, re ahpw kousoanla wasa ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Espon iei poahsoan kaunen sapwellimen Sihon kahnimw, nanmwarkien mehn Amor kan, me mahweniong mahs nanmwarkien Mohap oh kalowehdi sahpwo pwon lellahng Pillap Arnon. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ih kahrepen koul pwoatet me ketihtihki, “Kumwail kohdo nan Espon, sapwellimen Nanmwarki Sihon kahnimw! Se men kilang eh pahn kokouda oh onohnda sapahl. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Ahnsou ehu sang wasaht nan kahnimw Espon sapwellimen Sihon karis mwekidsang ie rasehng mpwul en kisiniei; e kamwomwala kahnimw Ar nan Mohap oh kalowehdi dolen Arnon palipowe kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Meid kamasepwehk ong kumwail tohn Mohap! Kumwail me kin kaudokiong Kemos, kumwail olahr! Amwail koht keselahr noumwail sounpei kan, nanmwarkien Amor koledier lih akan. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ahpw met kadaudokarail kan kamwomwmwomwlahr, sangete Espon lellahng Dipon, sang Nasim lel Nopa, limwahn Medepa.” ");
INSERT INTO pon2006a_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Mehn Israel ko eri kousoanla nan sapwen mehn Amor ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moses eri kadarala ohl ekei pwe re en rapahki wasa mwahu en mahwen ong mehn Saser. Mehn Israel ko ahpw kalowehdi wasao oh kahnimw ko me kapilpene oh kausasang mehn Amor me kin kausoan wasao. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Mehn Israel ko ahpw pwurala oh keid ni ahl me kolahng Pasan, oh Ok, nanmwarkien Pasan, ahpw mwekidla iangahki sapwellime karis pwehn mahweniong mehn Israel ko ni Edrei. ");
INSERT INTO pon2006a_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","KAUN-O ahpw ketin mahsanihong Moses, “Ke dehr masak nanmwarki menet. Pwe I pahn mweidohng uhk ke en kalowehdi ih, sapwellime aramas akan koaros iangahki sapweo. Wiahiong soahng me ke wiahiong Sihon, nanmwarkien mehn Amor kan, me kaunda Espon.” ");
INSERT INTO pon2006a_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Mehn Israel ko eri kemehla Ok, nah pwutak ko oh sapwellime aramas koaros, sohte emen luwehdi; mwuhr, re ahpw kousoanla nan sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Mehn Israel ko eri wonlahte mwowe re lao lel wasa patapat akan nan wehin Mohap; re ahpw kauwada imwarail impwal kan wasao, ni palimesehn Pillap Sordan, sallahng Seriko. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Eri, ni nanmwarki Palak, nein Sippor, eh mwahngihada dahme mehn Israel ko wiahiong mehn Amor ko, ");
INSERT INTO pon2006a_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ih oh mehn Mohap ko koaros ahpw masakada mehn Israel ko pwehki ar nohn tohto. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Mehn Mohap ko eri ndaiong kaunen mehn Midian kan, “Aramas pwukat pahn mwadangete kamwomwala atail wehi kan koaros, rasehng kouwol me kin kangasang dihpw nan mohs. Nanmwarki Palak eri ");
INSERT INTO pon2006a_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","poaronelahng meninkeder kei rehn Palaam, nein Peor, me kin mihmi Pedor nan Amaw limwahn Pillap Iupreitis, pwe re en patohwanohng, “I men kairehkin komwi me lapalahn wehi ehu kohdo sang Isip; re mwarahkpeseng wasa koaros oh likamwete re pahn mahweniong kiht oh sapwenikihla sapwat akan. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Re nohn tohto oh kehlailasang kiht. Eri, menlau, ketido pwe komwi en keriahla tohnwehi wet. Iei duwen ele at pahn kak kaloweiraildi oh kasareirailsang nan at wehi. Pwe I ese me irail kan me komw kin kupwuramwahwih, re kin paiamwahula; a irail kan me komw kin keriahla, re kin paisuwedla.” ");
INSERT INTO pon2006a_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Kaunen Mohap oh Midian kan eri wahda pweinen kosetipwo oh kohkohla. Re kohla rehn Palaam oh ndaiong mehkoaros me Palak mahsanihong irail. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Palaam eri sapeng irail, “Kumwail pweidi rehi pwohnget; lakapw I ahpw pahn sapengkin kumwail dahme KAUN-O pahn mahsanihong ie.” Kaunen Mohap ko eri pweidi ni imwen Palaam. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Koht eri ketido oh keinemwe rehn Palaam, “Ihs aramas pwukan me mihmi rehmw?” ");
INSERT INTO pon2006a_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","11","Palaam eri sapeng, patohwan, “Nanmwarkien Mohap, Palak, me patohwan kadariraildo pwe re en patohwanohng ie duwen aramas ekei me patohdo sang Isip oh mwarahkseli nan sahpwo pwon. E peki I en kohla oh keriairailla pwe re en kak mahweniong irail oh kaloweiraildi oh kasareirailla sang wasao.” ");
INSERT INTO pon2006a_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Koht eri mahsanihong Palaam, “Ke dehr iang aramas pwukan kohwei; ke pil sohte pahn keriahla tohnwehien, pwe I kapaiairaildahr.” ");
INSERT INTO pon2006a_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Eri, mandahn rahno, nimenseng, Palaam ahpw ndaiong meninkeder ko, “Kumwail pwurowei nan amwail wehi, pwe KAUN-O sohte kupwurki I en iang kumwailda.” ");
INSERT INTO pon2006a_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Meninkeder ko eri mwesel pwurala rehn Palak oh patohwanohng me Palaam kahng iang irail patohdo. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Eri, Palak ahpw pil ketin poaronehla ekei meninkeder me tohto oh lapalapasang mehn mahs ako. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Re ahpw kohla rehn Palaam oh ndaiong en Palak mahsen wet: “Menlau, komw dehr mweidohng mehkot en iredihsang omwi pahn ketido rehi. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","I pahn kihong komwi keting laud mehlel ehu, oh I pahn kapwaiada mehkoaros me komw pahn peki rehi. Menlau, ketido oh keriahla aramas pwukat.” ");
INSERT INTO pon2006a_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Palaam ahpw sapeng patohwanohng meninkeder ko, “Mehnda ma Palak pahn pil ketikihong ie silper oh kohl koaros en tehnpeseo, ahpw I sohte kak kauwehla kosonned en KAUN-O, ei Koht, ni mehkot tikitik de laud. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ahpw kumwail pil pweidi rehi pwohnget, duwehte pwihn teio, pwe I en kak ese dahme kapw ni kupwur en KAUN-O ong ire wet.” ");
INSERT INTO pon2006a_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","KAUN-O eri ketido rehn Palaam nipwongo oh mahsanihong, “Ma aramas pwukat kodohn likwerihiuk, eri, pwourda oh iangirailda; ahpw ke dehr wia mehkot tohrohrasang me I pahn ndaiong uhk.” ");
INSERT INTO pon2006a_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Eri, manda nimenseng Palaam ahpw kaunopaoda nah ahso, oh iangala kaunen Mohap ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Koht eri ketin engiengkihda Palaam eh kohkohla, oh ni eh kohkohla dake nah ahso iangahki eh ladu riemen, tohnleng en KAUN-O pa uh nanialo pwehn irehdi ih. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ni ahso eh kilangada tohnleng men eh kesikesihnen wasao oh kolokol kedlahs pwoat, e ahpw wetsang nan ahlo wetlong nan dihpw ko. A Palaam ahpw wokih ahso pwe en kapwurelahng nanialo. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Tohnleng en KAUN-O ahpw uhda wasa wetikitik kis nanpwungen kelen mwetin wain kei. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ni ahso eh kilangada tohnlengo, e keilahng ni kehlo oh idangehng nehn Palaamo ie. Palaam eri pil pwurehng wokih ahso. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Tohnlengo ahpw pil ketila uh wasa me wetikitik mehlel, wasa me ahso sohte kak mwekidla ni palimeing de palimaun. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Eri, met ni ahso eh kilangada tohnlengo eh uh mwowe, e ahpw mwohndiong nanpwelo pahn Palaam. Palaam eri lingeringerdahte oh tapihada wokihki ahso eh sokono. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","KAUN-O eri ketin kupwurehda ahso en lokaia, ahso ahpw ndahng Palaam, “Dahme kahrehda ke wokihkin ie pak silipak? ");
INSERT INTO pon2006a_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","A Palaam ahpw sapeng, “Pwehki omw kapakapailokei ie! Ma mie nei kedlahs met, I kemeiukalahr.” ");
INSERT INTO pon2006a_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ahso ahpw ndalahng Palaam, “Kaidehkin noumw ahs ngehi, oh kaidehkin dakepomw ahs ngehi sang ni omw tikitik? Sang mahs kohdo, mie ahnsou ehu me I sohte papah iuk?” Ohlo ahpw sapeng, “Soh.” ");
INSERT INTO pon2006a_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","KAUN-O eri ketin mweidohng Palaam en kilangada tohnlengo eh kesikesihnen nanialo ngapkihda nah kedlahs pwoat. Palaam eri poaridiong mwowe lel nanpwel. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Tohnlengo ahpw mahsanihong, “Dahme ke wokihki pak silipak noumw ahsen? I kodohn karomwpwaiukala, pwe ke sohte pahn wia seiloak wet. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ahpw noumw ahsen kilangiehda, iei me e wetkihsang nan ahlet, mahkete I kemeiukalahr, a ahsen pahn pitla. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Palaam eri sapeng patohwan, “I dipadahr, I sohte patohwan me komwi ketiket mwohi nan ahlet pwe komwi en uhwong ie. Eri, ma komw sohte kupwurki ei seiloaket, a I pahn pwuralahng ni imweio.” ");
INSERT INTO pon2006a_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Tohnlengo ahpw mahsanihong, “Iangeweite aramas pwukat, ahpw ke pahn koasoia soahng kante me I padahkihong uhk ke en koasoia.” Palaam eri iangada nein Palaam meninkeder ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ni Palak eh karongehda me Palaam patopato kohdo, e ahpw ketieila pwe en tuhwong ni kahnimw Ar, me mi limwahn Pillap Arnon ni irepen wehin Mohap. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Palak ahpw mahsanihong Palaam, “I seu kadarowohng uhk meninkeder ko pwe ke en patohdo? Dahme ke sohte mwadangkihdo? Ke lemeleme me I sohte pahn kihong uhk keting laud?” ");
INSERT INTO pon2006a_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Palaam ahpw sapeng, patohwan, “Ahpw iet I patodohr. A soangen manaman dah me mie rehi? Ihte mahsenohte me Koht ketikihong ie me I pahn kak patohwanda.” ");
INSERT INTO pon2006a_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Palaam eri iangada Palak, ira ketiketlahng kahnimw Usod, ");
INSERT INTO pon2006a_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Palak ahpw kemehla sihpw oh kou kei wasao, oh kadaralahng kisin uduk kis Palaam oh meninkeder ko me e iangodo. ");
INSERT INTO pon2006a_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Eri, mandahn rahno, nimenseng, Palak eri ketin kahredalahng Palaam Pamod Paal, wasa Palaam kak kilang ekei aramas en Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Palaam eri patohwanohng Palak, “Komw ketin kauwada wasaht pei sarawi isuh oh ketikidohng ie kouwol isimen oh sihpw wol isimen.” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Palak eri ketin kapwaiada pekipek en Palaam. Ira ahpw meirongkihla kouwol men oh sihpw wol men pohn ehuehu pei sarawi ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Palaam eri patohwanohng Palak, “Komw ketin sepit mahs limwahn sapwellimomwi meirong isihs pwukat, pwe I pahn patolahng patohwan mahs ma KAUN-O ele pahn ketin tuhwong ie. Mehkoaros me e pahn mahsanihong ie, I pahn patohwanohng komwi.” Palaam eri patopatolahng pohn nahna ehu, ");
INSERT INTO pon2006a_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","oh Koht ahpw ketin tuhwong Palaam wasao. Palaam ahpw patohwanohng, “I patohwan kauwada pei sarawi isuh oh meirongkihla kouwol men oh sihpw wol men pohn ehuehu pei sarawi ko.” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","KAUN-O ahpw mahsanih, “Pwurowei rehn Palak oh patohwanda mahsen kan me I pahn mahsanihong uhk.” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Palaam eri pwurala oh tuhwong Palak me ketikette limwahn sapwellime meirong isihso, iangahki kaun koaros en wehin Mohap. ");
INSERT INTO pon2006a_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Palaam eri patohwanda mahsen en kokohp pwukat: “Palak, nanmwarkien Mohap, ketin malipeiehdo sang Siria, sang nin nahna kan en palimese. E mahsanih, ‘Kohdo wia kokohp ni mwarei; komw keriahla mehn Israel ko.” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","A ia duwen ei pahn keriahla me Koht sohte ketin keriahla? Ia duwen ei pahn kailongkihla me Koht sohte ketin kalahdeki? ");
INSERT INTO pon2006a_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Sang pohn paip ile kan I kak uduhdiahl irail, sang pohn dohl akan I kak mwasamwasahn irail. Wehi ehu irail me uhtohrada, me paiamwahusang wehi teikan. ");
INSERT INTO pon2006a_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Kadaudok en Israel kan me ngeder duwehte pwelpar, ihs me kak wadekada tohtohn irail? Komwi ketin kupwure ie pwe ei mour en imwisekla duwehte emen sapwellimen Koht aramas akan, pwe imwilahn ei mour en duwehte imwilahn me pwung kan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Eri, Palak ahpw mahsanihong Palaam, “Dahme ke wiewiahiong ie? I ekeruhkodo pwe ke en keriahla ei imwintihti kan, a dahme ke wia, ihte ke kapakapkin irail.” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","A Palaam sapeng, patohwan, “Pwe da? Kakete I en potohwanda ehu soahng tohrohrasang me KAUN-O ketikihong ie?” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Palak eri mahsanihong, “Iangiehda mahs, kita kohla ekis wasa tohrohr, wasa me ke pahn kilang ekeite mehn Israel ko. Eri, ke pahn keriairailla sang wasao.” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ih eri ketin kahrelahng Palaam nan mohsen Sopim, me mi pohn Nahna Piska, wasa me e ketin kauwada ie pei sarawi isuh oh ketin meirongkihla kouwol men oh sihpw wol men pohn ehuehu pei sarawi ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Palaam eri patohwanohng Palak, “Komw sepit mahs limwahn mehn meirong isihs pwukat, pwe I pahn patolahng tuhwong Koht mahs.” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","KAUN-O eri ketin tuhwong Palaam oh mahsanihong dahme e pahn patohwanda; e ahpw pil ketin kapwurelahng rehn Palak. ");
INSERT INTO pon2006a_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Palaam eri pwurala oh tuhwong Palak me ketikette limwahn mehn meirong isihs ko, iangahki kaunen Mohap ko. Palak eri keinemwe dahme KAUN-O ketin mahsanih; ");
INSERT INTO pon2006a_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","a Palaam ahpw patohwanda mahsen en kokohp pwukat: “Palak, nein Sippor, komw ketido mahs; oh rong kanahieng dahme I pahn patohwan. ");
INSERT INTO pon2006a_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Koht kaidek aramas emen me kin lokaia likamw; pil kaidehk aramas emen me kin wekidala audepen kupwure. Ni eh pahn ketin inoukihda mehkot, e kin ketin kapwaiada; mehkot me e kin mahsanih kin pweida. ");
INSERT INTO pon2006a_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","E ketin mahsanihong ie I en kapaiahda; eri, me Koht ketin kupwuramwahwih, I sohte kak wekidala. ");
INSERT INTO pon2006a_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","I sohte kilangada mehkot suwed rehn mehn Israel, de kahpwal, ni ahnsou kohkohdo. KAUN-O, arail Koht, kin ketin ieiang irail; re patohwan wiahki ih arail nanmwarki. ");
INSERT INTO pon2006a_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Koht ketin kahluwairaildo sang wehin Isip; e ketin uhpalihkin irail nan mahwen, rasehng kou lawalo men. ");
INSERT INTO pon2006a_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Sohte katepen tiahk en wunahni rehn mehn Israel, pil sohte ketepen kosetipw rehrail. Ih ahnsowo met ahnsoun patohwan duwen mehn Israel, ‘Kilang dahme Koht ketin wiadahr!’ ");
INSERT INTO pon2006a_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Iet wehin Israel me rasehng laion kehlail men: e sohte pahn wendi e lao kadallehla seike, oh nimala ntahn irail me e kemehla.” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Eri, Palak ahpw mahsanihong Palaam, “Ma ke sohte pahn keriahla mehn Israel kan, ke sohte pil pahn kapaiairailda.” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Palaam ahpw sapeng Palak, patohwan, “I soh patohwanohngkomwiher me I pahn patohwanda mehkoaros me KAUN-O ketin mahsanihong ie?” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Palak eri mahsanihong, “Kohdo mahs; I pahn kahreiukalahng ekis wasa tohrohr; mweinele Koht pahn ketin kupwurki ke en keriairailla sang wasao.” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ih eri ketin kahrelahng Palaam pohn kumwen Nahna Peor, sallahng sapwtehno. ");
INSERT INTO pon2006a_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Palaam ahpw patohwanohng, “Komw ketin kauwada pei sarawi isuh wasaht, oh ketikidohng ie kouwol isimen oh pil sihpw wol isimen.” ");
INSERT INTO pon2006a_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Palak eri ketin kapwaiada me Palaam patohwanohng; ih eri meirongkihla kouwol men oh sihpw wol men pohn ehuehu pei sarawi ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Palaam eri esehda me KAUN-O ketin kupwurki en kapaiahda mehn Israel ko. Kahrehda e sohla kohla rapahki kupwur en KAUN-O duwen me e kin wia. E ahpw kilikilengseli nan sapwtehn ");
INSERT INTO pon2006a_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","oh kilangada mehn Israel ko ni imwarail impwal ko ni wad kadaudok. Ngenen Koht eri ti powe, ");
INSERT INTO pon2006a_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ih eri patohwanda mahsen en kokohp pwukat: “Iet mahsen en Palaam, nein Peor, mahsen en aramas emen me kak kilang mehkoaros ni sansal, ");
INSERT INTO pon2006a_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","me kak rong mahsen en Koht. Mesei kat pehdpesengehr, I aleier kaudial ehu sang rehn Koht, Wasa Lapalap. ");
INSERT INTO pon2006a_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Impwal kan en mehn Israel ko me kaselel, ");
INSERT INTO pon2006a_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","rasehng nih kei me irihrek kohwei, mwetuwel kei ni keilen pillap, tuhkehn alos kei me KAUN-O ketin padokedi, rasehng tuhke sidar kei limwahn pihl. ");
INSERT INTO pon2006a_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Keteu pahn mwuledek rehrail oh arail werentuhke pahn poadidi nan pwehl wisekesek mwahu. Arail nanmwarki pahn lapalapasang Akak, oh roson en eh wehi pahn kohieng wasa doh kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Koht ketin kahluwairaildo sang wehin Isip; e kin ketin uhpalihkin irail nan mahwen, rasehng kou lawalo men. Re kin kadallehla arail imwintihti kan, kauwehla tihrail kan oh katimpeseng kanengen neirail kesik ketieu. ");
INSERT INTO pon2006a_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Arail wehi kin rasehng laion kehlail men; ni eh pahn memeir, sohte me eimahiong kapirida. Mehmen me pahn kapaiahda Israel, e pahn pil paiamwahu; a mehmen me pahn keriahla Israel, e pahn riahla.” ");
INSERT INTO pon2006a_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Palak eri engiengda kowahlap pahn Palaam. Ih eri rakopene lime ko oh mahsanihlahng Palaam, “I ekeruhkodo pwe ke en keriahla ei imwintihti kan, ke ahpw kapaiairailda pak siluh. ");
INSERT INTO pon2006a_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Eri, pwilipwilahkewei sang met, pwilahkewohng ni imwomwo! I inoukihda me I pahn kihong uhk keting laud ehu, a met KAUN-O ketikihsangehr keting wet rehmw.” ");
INSERT INTO pon2006a_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Palaam eri sapeng, patohwan, “I soh patohwanohng meninkeder ko me komw ketin kadaralahng ie, ");
INSERT INTO pon2006a_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","me mehnda ma komw pahn ketikihong ie silper oh kohl en tehnpasomwi koaros, ahpw I sohte kak kauwehla kosonned en KAUN-O ni ei pahn wiahda mehkot ni pein nsenei; pwe ihte me I pahn kin patohwandahn, dahme KAUN-O ketin mahsanihong ie.” ");
INSERT INTO pon2006a_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Palaam pil patohwanohng Palak, “Ahnsou wet I pahn patohla rehn riei aramas ako, ahpw mwohn ei pahn patohla, I men kehsehkin komwi dahme mehn Israel kan pahn wiahiong sapwellimomwi kan ni rahn akan me pahn kohdo.” ");
INSERT INTO pon2006a_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ih eri patohwanda mahsen en kokohp pwukat: “Iet mahsen en Palaam, nein Peor, mahsen en aramas emen me kak kilang mehkoaros ni sansal, ");
INSERT INTO pon2006a_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","me kak rong mahsen en Koht, me kin kupwurokongki kupwurokong en Wasa Lapalahpie. Mesei kat pehdpesengehr, I aleier kaudial sang rehn Koht, Wasa Lapalap. ");
INSERT INTO pon2006a_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","I patohwan kilikilenglahng ahnsou me pahn kohdo, I ahpw kilangada wehin Israel. Nanmwarki men pahn ketin pwarada nan wehio, rasehng usu ehu, e pahn ketieisang nan Israel, rasehng rakim lingaling ehu. E pahn ketin kauwehla kaunen wehin Mohap kan, oh kamwomwala me akalapalap oh lemei kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","E pahn ketin kalowehdi sapwellime imwintihti kan nan Edom, oh ketin nin limanikihla sapwarail; Israel eri pahn kin poweiraildi. ");
INSERT INTO pon2006a_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Wehin Israel pahn kaitiekiraildi oh kamwomwala douluhl me pitla kan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","“Eri, nan kaudialo, Palaam pil kilangada mehn Amalek kan; ih eri pil patohwanda mahsen en kokohp wet: “Wehin Amalek me keieu kehlail nanpwungen wehi kan, ahpw ni imwilah e pahn kamwomwmwomwla douluhl.” ");
INSERT INTO pon2006a_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Oh nan kaudialo, e ahpw pil kilangada mehn Ken kan; ih eri pil patohwanda mahsen en kokohp pwukat: “Amwail wasahn kousoan me kehlail oh mwahu, rasehng pesen menpihr men pohn paipalap ileilehie; ");
INSERT INTO pon2006a_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ahpw kumwail, mehn Ken, kumwail pahn mwomwla ni ahnsou mehn Asiria kan pahn kaloweikumwaildi.” ");
INSERT INTO pon2006a_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Palaam ahpw pil patohwanda mahsen en kokohp pwukat: “Ihs aramas pwukat me pokonpene ni paliepeng? ");
INSERT INTO pon2006a_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Karis kan pahn seiloakdo sang Saiprus; re pahn kalowehdi Asiria oh Papilon, a mwuhr, re ahpw pahn pil mwomwla kohkohlahte.” ");
INSERT INTO pon2006a_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Palaam eri uhdahte kohkohla ni imweo, oh Palak pil ketiketla sang wasao. ");
INSERT INTO pon2006a_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ahnsou me mehn Israel ko kauwada imwarail impwal ko nan Wahun Akasia, ohl ako ahpw tapihada neneke lih en Mohap kan me mihmi wasao. ");
INSERT INTO pon2006a_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","3","Lih pwukat kin luhke ohlen Israel ko ong arail kamadipw sarawi kan, wasa me re kin pwongih ie koht en Mohap. Mehn Israel ko eri kin iang tungoale kisin mwenge me kin meirongala ong Paal, koht en Peor, oh pil pwongih ih. KAUN-O eri ketin engiengda pahn mehn Isreal, ");
INSERT INTO pon2006a_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","oh mahsanihong Moses, “Ale kaunen mehn Israel kan oh kemeirailla ni pokon sansal, pwe iei duwen met ei sohla pahn engieng pahn aramas akan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moses eri patohwanohng kaun ako, “Emenemen kumwail pahn kemehla aramas koaros me kisehn eh kadaudok me iangalahr pwongih Paal en Peor.” ");
INSERT INTO pon2006a_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Emen mehn Israel ko ahpw pedolong nan imwe impwal iangahki lih en Midia men mwohn mesen Moses oh mwohn mehn Israel koaros, nindokon ar mwahmwahiei mwohn Impwal me KAUN-O kin ketiket loale. ");
INSERT INTO pon2006a_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ni Pineas, nein Eleasar, me pahpa kahlapki samworo Aaron, kilang met, e ahpw udahte kohkohla sang nan pokono. E ahpw ale ketieu pwoat, ");
INSERT INTO pon2006a_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","oh idawehnla ohlo oh liho nan impwalo oh doakoahki ketieuo pwar paliwarara ko koaros. Ih duwen met soumwahu lusuluso me kamwomwalahr mehn Israel ko eh tokedi, ");
INSERT INTO pon2006a_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ahpw mwurin soumwahwo eh kemelahr aramas rianen pahkid. ");
INSERT INTO pon2006a_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Pwehki wiewiahn Pineas, I solahr engieng pahn mehn Israel kan. E sohte mwahn mweidohng re en pwongih koht emen likin ngehi, ih kahrepen ei sohte kamwomwirailla nan ei engieng. ");
INSERT INTO pon2006a_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Eri, ke pahn padahkihong me I pahn kauwada inou ehu nanpwungen ngehi oh ih me pahn manaman kohkohlahte. ");
INSERT INTO pon2006a_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ih oh kadaudoke kan pahn wialahr samworo poatopoat kohkohlahte, pwehki eh nohn loalopwoat ong ie oh kahrehiong kupwurmahk pohn mehn Israel kan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Eden ohl en Israel me iang lih en Midiano kamakamala iei Simri, nein Salu, kaunen peneinei ehu nan kadaudok en Simion. ");
INSERT INTO pon2006a_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Eden liho iei Kospi. Sur, eh pahpa, wia kaunen ehu peneineien mehn Midia. ");
INSERT INTO pon2006a_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Mahweniong mehn Midia kan oh kamwomwirailla, ");
INSERT INTO pon2006a_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","pwehki suwed me re wiahiong uhk ni ahnsou me re pitihiukedi nan Peor, oh pwehki Kospi, me kamakamlahr ni ahnsoun soumwahu lusulus nan Peor.” ");
INSERT INTO pon2006a_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Mwurin soumwahu lusuluso, KAUN-O ketin mahsanihong Moses oh Eleasar, nein Aaron, ");
INSERT INTO pon2006a_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Kumwa wiahda wadawad en peneinei kan en mehn Israel koaros, ohl koaros me mahkier sounpar rieisek kohda me kak wia doadoahk en sounpei.” ");
INSERT INTO pon2006a_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","4","Moses oh Eleasar ahpw kapwaiada, ira eri kapokonepene ohl koaros me mahkier sounpar rieisek kohda. Re ahpw pokonpene nan patapat en Mohap ni keilen Pillap Sordan sallahng Seriko. Iet kan mehn Israel me kohdohsang Isip: ");
INSERT INTO pon2006a_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Kadaudok en Reupen (Reupen, iei nein Seikop mesenih): peneineien Anok, Pallu, ");
INSERT INTO pon2006a_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Esron oh Karmi. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Peneinei pwukat koaros patpene 43,730 ohl. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Peneineien Pallu iei Eliap ");
INSERT INTO pon2006a_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","oh nah pwutak kan iei Nemuel, Dadan, oh Apiram. (Deidan oh Apiram, iei ira me pilipildahr sang rehn mehn Israel kan. Ira me uhwong Moses oh Aaron oh iangala iengen Kora ko ni ahnsou me re kahngohdiong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Sampah sarapeseng oh kadaleirahla, ira eri mehla iangahki Kora oh ienge ko ni ahnsou me kisiniei karongehla me 250; irail eri wiahla mehn kapar ehu ong aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ahpw nein Kora pwutak ko sohte iang kamakamala.) ");
INSERT INTO pon2006a_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Kadaudok en Simion: peneineien Nemuel, Samin, Sakin, ");
INSERT INTO pon2006a_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Sera, oh Saul. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Peneinei pwukat koaros patpene me 22,200 ohl. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Kadaudok en kad: peneineien Sepon, Aki, Suni, ");
INSERT INTO pon2006a_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Osni, Eri, ");
INSERT INTO pon2006a_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod, oh Areli. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Peneinei pwukat koaros patpene me 40,500 ohl. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","21","Kadaudok en Suda: peneineien Sela, Peres, Sera, Esron oh Amul. (Riemen nein Suda pwutak, Er oh Onan, ira mehla nan wehin Kenan). ");
INSERT INTO pon2006a_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Peneinei pwukat koaros patpene me 76,500 ohl. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Kadaudok en Isakar: peneineien Tola, Pua, ");
INSERT INTO pon2006a_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Sasup oh Simron. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Peneinei pwukat koaros patpene me 64,300 ohl. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Kadaudok en Sepulon: peneineien Sered, Elon, oh Sapleel. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Peneinei pwukat koaros patpene me 60,500 ohl. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Kadaudok kan en Sosep, me naineki pwutak riemen, Manase oh Epraim. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Kadaudok en Manase. Makir, nein Manase, iei semen Kilead oh peneinei me pahn wad met kan arail pahpa kahlap ako tepisang Kilead: ");
INSERT INTO pon2006a_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Peneinei en Ieser, Elek, ");
INSERT INTO pon2006a_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel, Sekem, ");
INSERT INTO pon2006a_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semida oh Eper. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selopehad, nein Eper, sohte nah pwutak ahpw mie nah serepein; adarail iei Mala, Noha, Okla, Milka oh Tirsa. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Peneinei pwutak koaros patpene me 52,700 ohl. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Kadaudok en Epraim: peneineien Sudela, Peker, oh Tahan. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Peneineien Eran tepisang Sudela. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Peneinei pwukat koaros patpene me 32,500 ohl. Ih peneinei pwukat me tepisang Sosep. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Kadaudok en Pensamin: peneineien Pela, Aspel, Airam, ");
INSERT INTO pon2006a_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sepupam oh Upam. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Peneineien Ard oh Nahman tepisang Pela. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Peneinei pwukat koaros patpene me 45,600 ohl. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Kadaudok en Dan: peneineien Usim, ");
INSERT INTO pon2006a_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","irail koaros me 64,400 ohl. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Kadaudokk en Aser: peneineien Imna, Ispi, oh Peria. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Peneineien Eper oh Malkiel tepisang Peria. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aser naineki serepein men ede Sera. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Peneinei pwukat koaros patpene me 53,400 ohl. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Kadaudok en Napdali: peneineien Saseel, Kuni, ");
INSERT INTO pon2006a_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Seser oh Sillem. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Peneinei pwukat koaros patpene me 45,400 ohl. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Ohlen Israel koaros patpene me 601,730. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Nehkpeseng sahpwo nanpwungen kadaudok pwukat nin duwen tohtohn aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","56","Nehnehn sahpwo pahn wiawi ni usuhs, oh sahpw laud pahn kohieng kadaudok laud, oh sahpw tikitik pahn kohieng kadaudok tikitik.” ");
INSERT INTO pon2006a_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Kadaudok en Lipai, me towe, peneineien Kerson, Kohad oh Merari. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Kadaudokarail kan iei keimw en peneineien Lipni, Epron, Mali, Musi oh Kora. Kohad iei semen Amram, ");
INSERT INTO pon2006a_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","me pwoudiki nein Lipai serepein, Sokeped me ipwidi Isip. E wiahiong Amram pwutak riemen, Aaron oh Moses oh serepein men, Miriam. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaron naineki pwutak pahmen, Nadap, Apihu, Eleasar oh Idamar. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadap oh Apihu mehla ahnsou me ira wiahiong KAUN-O kisiniei me sohte sarawi. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Mehn Lipai ohl me sounpwong ehu kohda koaros patpene me 23,000. Re wadawad tohrohrasang mehn Israel teikan pwehki ar sohte kin ale sohsohn sahpw nan Israel. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Moses oh Eleasar me wia wadawad en peneinei pwukat koaros nan patapat en Mohap ni keilen Pillap Sordan sallahng Seriko. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Sohte ohl emen luhwehdi me iang ntingdier ni wadawad en aramas me Moses oh Aaron wiadahr nan Sapwtehn en Sainai. ");
INSERT INTO pon2006a_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","KAUN-O ketin mahsanih me irail koaros pahn mehla nan sapwtehn, ihte me soh, Kalep nein Sepune oh Sosua, nein Nun. ");
INSERT INTO pon2006a_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Mahla, Noha, Okla, Milka, oh Tirsa, ih serepein pwukat me nein Selopehad, Selopehad, nein Eper, Eper nein Kilead, Kilead, nein Makir, Makir, nein Manase, Manase nein Sosep. ");
INSERT INTO pon2006a_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Irail kohla oh kesihnenda mwohn Moses, samworo Eleasar, kaun akan oh mehn Israel ko koaros ni wenihmwen Impwal me KAUN-O kin ketiket loale oh patohwan, ");
INSERT INTO pon2006a_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“At pahpao mehla nan sapwtehno sohte nah pwutak. E sohte iang iengen Kora ko me kahngohdiong KAUN-O; e mehkihla pein dipe. ");
INSERT INTO pon2006a_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Pwehki eh sohte nah pwutak, ia kahrepen eden at pahpao eh pahn sohrala sang wehin Israel? Kumwail ketikidohng kiht at sohso sang rehn en pahpa peneinei kan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moses eri patohwanohng KAUN-O ar pekipek, ");
INSERT INTO pon2006a_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","KAUN-O ahpw mahsanihong, ");
INSERT INTO pon2006a_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“En nein Selopehad serepein kan ar pekipek me pwung; ke pahn kihong irail arail sohso sang rehn kisehn arail pahpao. En arail pahpa eh sohso en kohieng irail. ");
INSERT INTO pon2006a_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Ndaiong mehn Israel kan me ahnsou me ohl emen pahn kin mehla sohte nah pwutak, nah serepein me pahn ale sohso. ");
INSERT INTO pon2006a_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ma sohte nah serepein, rie pwutak kan me pahn ale sohso. ");
INSERT INTO pon2006a_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ma sohte rie pwutak, rien eh pahpa ohl akan me pahn ale. ");
INSERT INTO pon2006a_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ma sohte rie de rien eh pahpa, a kiseh me keieu karanih me pahn sohsohki oh wiahkihla uhdahn ah. Mehn Israel kan pahn kin kapwaiada koasoandi wet, nin duwen ngehi, KAUN-O, ei mahsanihong uhk.” ");
INSERT INTO pon2006a_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","KAUN-O ketin mahsanihong Moses, “Kohdahwei pohn Nahna Aparim; ke ahpw pahn kilang sang wasao sahpw me I pahn kihong mehn Israel kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Mwurin omw pahn kilang sahpwo, ke pahn mehla, duwehte riomw Aaron, ");
INSERT INTO pon2006a_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","pwehki amwa sapeikiong ei mahseno nan sapwtehn en Sin. Ni ahnsou me mehn Israel koaros pelianiehda nan Meripa, kumwa sohte uhkihda roson en ei manaman sarawi mwohrail.” (Meripa, iei utuhnpihl me mi nan Kades nan sapwtehn en Sin.) ");
INSERT INTO pon2006a_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moses eri kapakap, patohwan, ");
INSERT INTO pon2006a_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Maing KAUN, Koht me wia poahsoan en mour koaros, I peki komwi en ketin kilelehdi ohl emen me pahn kin kaweid aramas pwukat, ");
INSERT INTO pon2006a_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","oh kaunirailda nan mahwen, pwe sapwellimomwi aramas akan en dehr rasehng pelin sihpw me sohte silepahr.” ");
INSERT INTO pon2006a_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","KAUN-O eri mahsanihong Moses, “Ale Sosua, nein Nun, pwe ih ohl koahiek men, kowe eri kidahng pehmw kan pohn moange. ");
INSERT INTO pon2006a_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","E ahpw pahn patohda mwohn samworo Eleasar oh aramas akan koaros. Ke ahpw pahn pakairkihong irail koaros me iei ih wiliepomw. ");
INSERT INTO pon2006a_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ke ahpw pil kihong apalien omw manaman, pwe mehn Israel kan koaros en peikiong. ");
INSERT INTO pon2006a_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","E pahn peikiong samworo Eleasar, me pahn esehkihla kupwurei Urim oh Dumim. Ih duwen met me Eleasar pahn kaweidki Sosua oh pil mehn Israel kan mehkoaros me irail pahn kin wia.” ");
INSERT INTO pon2006a_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moses eri kapwaiada me KAUN-O ketin mahsanihong. Ih eri ale Sosua oh kahrelahng rehn samworo Eleasar mwohn mesen mehn Israel kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","E ahpw kidahng peh ko pohn moangen Sosua, oh pakairkihong aramas ako me iei ih wiliepe, nin duwen me KAUN-O ketin mahsaniher. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","KAUN-O ketin mahsanihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","en kehkehlingkihong mehn Israel kan me re en patohwanohng Koht ar meirong en konot me kin kaparanda kupwure, ni ahnsou kan me kileldier. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Eri, iet kan meirong en konot me kumwail pahn kin patohwandahng KAUN-O: mehn meirong isihs en rahn koaros, sihmpwul wol riemen me sounpar ehu sohte kisin samin kis rehra. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Keieun sihmpwulo pahn meirongala nimenseng, a keriemeno nin soutik; ");
INSERT INTO pon2006a_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ong emenemen mahno ako, kumwail pahn iangahki meirong en wahnsahpw me pahn mihmi ni paun 2 en pilawa me doalki pain 2 en lehn olip kaselel. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ih met meirong en rahn koaros me kin pwonte isihsla, me tepin wiawi nin Nahna Sainai nin duwen meirong isihs, me pwowe kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Wudekihong pohn pei sarawio pain 2 en wain; iei met meirong en wain me pahn iang keieun sihmpwulo. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Nin soutik kumwail pil pahn meirongkihla keriemen en sihmpwulo duwehte mehn nimensengo, iangahki meirong en wain. Met pil wia meirong en konot, me pwowe kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Ni rahnen Sapad kumwail pahn meirongkihla sihmpwul wol riemen me sounpar ehu me sohte kisin samin kis rehra, oh paun 4 pilawa me doal lehn olip nin duwen meirong en wahnsahpw, oh iangahki meirong en waino. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Meirong isihs wet pahn kin wiawi rahnen Sapad koaros pwehn patehng meirong en rahn koaros oh pil meirong en wain. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Ni tepin sounpwong koaros kumwail pahn patohwandahng KAUN-O meirong isihs me pahn mihmi ni koupwul wol riemen, sihpw wol men, sihmpwul wol isimen me sounpar ehu, me sohte kisin samin kis rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Mehn meirong en wahnsahpw pahn mihmi ni pilawa me doal lehn olip, paun 6 ong emenemen kouwol; paun 4 ong emenemen sihpw wolo, ");
INSERT INTO pon2006a_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","oh paun 2 ong emenemen sihmpwul. Meirong isihs pwukat iei meirong en konot, me pwowe kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Meirong en wain me pahn iang mahn pwukat: pain 4 ong emenemen kouwol, pain 3 ong sihpwo, oh pain 2 ong emenemen sihmpwul. Ih met koasoandi en meirong isihs ni keieun rahnen sounpwong koaros erein pahr ehu. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Kumwail pil pahn meirongkihla emen kuht wol mehn wia meirong en dihp, pwehn patehng meirong en rahn koaros, oh pil meirong en wain. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Sarawien Pahsohpa, mehn kauwawih KAUN-O, pahn wiawi ni rahn kaeisek pahieu ni keieun sounpwong. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ni kaeisek limaun rahn iei rahn me sarawi ehu pahn tepida oh wiewiawihki erein rahn isuh. Erein rahn pwukat kumwail pahn tungoale pilawa me sohte doal ihs. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Ni keieun rahn en sarawi wet kumwail pahn pokonpene wia kaudok, oh sohte me pahn doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Meirongkihong KAUN-O meirong isihs wet nin duwen meirong en konot: koupwul wol riemen, sihpw wol men, oh sihmpwul wol isimen me sounpar ehu, me sohte kisin samin kis rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Pil meirongki wahnsahpw me kin wiawi: pilawa me doal lehn olip, paun 6 ong emenemen kou, paun 4 ong sihpw wolo, ");
INSERT INTO pon2006a_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","oh paun 2 ong emenemen sihmpwul. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Pil meirongki emen kuht wol mehn wia meirong en dihp; eri ih duwen amwail pahn wia sarawien kamwakele aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Kumwail pahn kapatahiong mepwukat meirong isihs me kin wiawi nimenseng koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Pil duwehte, erein rahn isuh kumwail pahn meirongkihong KAUN-O meirong en konot, me pwowe kin kaparanda kupwure. Meirong wet pahn patehng meirong isihs en rahn koaros oh pil meirong en wain. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Ni keisuhn rahno kumwail pahn pokonpene pwehn wia kaudok oh sohte me pahn doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Ni keieun rahnen Sarawien Dolung Wahnsahpw, ni amwail pahn kin meirongkihong KAUN-O wahnsahpw kapw, kumwail pahn pokonpene wia kaudok oh sohte doadoahk pahn wiawi rahno. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Kumwail pahn wia meirong isihs ehu, me pwowe kin kaparanda kupwur en KAUN-O: koupwul wol riemen, sihpw wol men, oh sihmpwul wol isimen me sounpar ehu, me sohte kisin samin kis rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Pil meirongki wahnsahpw me kin wiawi, pilawa me doal lehn olip: paun 6 ong emenemen kou, paun 4 ong sihpw wolo, ");
INSERT INTO pon2006a_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","oh paun 2 ong emenemen sihmpwul. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Pil meirongkihla emen kuht wol mehn wia meirong en dihp, met iei duwen amwail pahn wia sarawien kamwakele aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Wia meirong pwukat iangahki meirong en wain pwehn patehng meirong isihs oh meirong en wahnsahpw en rahn koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Ni keieun rahnen keisuhn sounpwong kumwail pahn pokonpene pwehn wia kaudok, oh sohte doadoahk pahn wiawi rahno. Ni rahno sowi kan pahn pepeuk. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Kumwail pahn patohwandahng KAUN-O meirong isihs ehu, me pwowe pahn kin kaparanda kupwure: koupwul wol men, sihpw wol men, oh sihmpwul wol isimen me sounpar ehu, me sohte kisin samin kis rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Pil wia meirong en wahnsahpw me kin wiawi: pilawa doal lehn olip, paun 6 ong kouo, paun 4 ong sihpwo, ");
INSERT INTO pon2006a_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","oh paun 2 ong emenemen sihmpwul. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Kumwail pahn pil meirongki emen kuht wol mehn wia meirong en dihp, met iei duwen amwail pahn wia sarawien kamwakele aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Kumwail pahn meirongki mepwukat pwehn patehng meirong isihs en keieun rahnen sounpwong iangahki meirong en wahnsahpw oh meirong isihs en rahn koaros iangahki meirong en wahnsahpw oh wain. Pwohn meirong en konot pwukat kin kaparanda kupwur en KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Ni kaeisek en rahnen keisuhn sounpwong kumwail pahn pokonpene pwehn wia kaudok, kumwail pahn kaisihsol oh sohte doadoahk pahn wiawi rahno. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Kumwail meirongkihong KAUN-O meirong isihs ehu, me pwowe kin kaparanda kupwure: koupwul wol men, sihpw wol men, oh sihmpwul wol isimen me sounpar ehu, me sohte kisin samin kis rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Kumwail pil pahn meirongki wahnsahpw me kin wiawi: pilawa me doal lehn olip, paun 6 ong kouo, paun 4 ong sihpwo, ");
INSERT INTO pon2006a_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","oh paun 2 ong emenemen sihmpwul. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Kumwail pil pahn meirongki emen kuht wol mehn wia meirong en dihp, me pahn patehng meirong en kuht me kin wia sarawien kamwakele aramas akan, oh meirong isihs en rahn koaros iangahki meirong en wahnsahpw oh wain. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Kumwail pahn pokonpene pwehn wia kaudok ni kaeisek limaun rahnen keisuhn sounpwong. Kumwail pahn wia sarawi wet pwehn kawauwih KAUN-O erein rahn isuh oh sohte me pahn doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Ni keieun rahn pwukat kumwail pahn meirongkihong KAUN-O meirong en konot ehu, me pwowe kin kaparanda kupwure: koupwul wol ehk silimen, sihpw wol riemen, oh sihmpwul wol ehk pahmen me sounpar ehu, me sohte kisin samin kis rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Pil wia meirong en wahnsahpw: pilawa me doal lehn olip, paun 6 ong emenemen kou, paun 4 ong emenemen sihpw wol, ");
INSERT INTO pon2006a_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","oh paun 2 ong emenemen sihmpwul, iangahki meirong en wain kan me koasoandier. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Pil meirongkihla emen kuht wol ong ni meirong en dihp. Meirong pwukat pahn patehng meirong isihs en rahn koaros iangahki meirong en wahnsahpw oh meirong en wain. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Ni keriaun rahn kumwail pahn meirongki koupwul wol ehk riemen, sihpw wol riemen, oh sihmpwul wol ehk pahmen me sounpar ehu, me sohte kisin samin kis rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","19","Kumwail pil iangahki soangen meirong ko me wiawiher ni keieun rahno. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Ni kesiluhn rahn kumwail pahn meirongki koupwul wol ehk emen, sihpw wol riemen, oh sihmpwul wol ehk pahmen, me sohte kisin samin kis rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","22","Kumwail pil iangahki soangen meirong ko me wiawiher ni keieun rahno. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Ni kapahieun rahn kumwail pahn meirongki koupwul wol ehk, sihpw wol riemen, oh sihmpwul wol ehk pahmen, me sohte kisin samin kis rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","25","Kumwail pahn iangahki soangen meirong ko me wiawiher ni keieun rahno. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Ni kelimaun rahn kumwail pahn meirongki koupwul wol duwemen, sihpw wol riemen, oh sihmpwul wol ehk pahmen, me sohte kisin samin kis rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","28","Kumwail pahn iangahki soangen meirong ko me wiawiher ni keieun rahno. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Ni keweneun rahn kumwail pahn meirongki koupwul wol welimen, sihpw wol riemen, oh sihmpwul wol ehk pahmen, me sohte kisin samin kis rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","31","Kumwail pahn iangahki soangen meirong ko me wiawiher ni keieun rahno. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Ni keisuhn rahn kumwail pahn meirongki koupwul wol isimen, sihpw wol riemen, oh sihmpwul wol ehk pahmen, me sohte kisin samin kis rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","34","Kumwail pahn iangahki soangen meirong ko me wiawiher ni keieun rahno. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Ni kawaluhn rahn kumwail pahn pokonpene wia kaudok oh sohte me pahn doadoahk. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Kumwail pahn meirongkihong KAUN-O meirong en konot ehu, me pwowe kin kaparanda kupwure: koupwul wol men, sihpw men, oh sihmpwul wol isimen, me sohte kisin samin kis rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","38","Kumwail pahn iangahki soangen meirong ko me wiawiher ni keieun rahno. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Ih koasoandi pwukat me pid meirong isihs kan, meirong en wahnsahpw, meirong en wain, oh meirong en kaminimin me kumwail pahn kin wiahiong KAUN-O ni rahnen sarawi me kileldier kan. Iei mepwukat me pahn patehng meirong kan me kumwail pahn kin wia pwe kumwail en kapwaiada inou ehu de me kumwail wia ni pein nsenamwail. ");
INSERT INTO pon2006a_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Moses eri patohwanohng mehn Israel ko mekoaros me KAUN-O mahsanihong. ");
INSERT INTO pon2006a_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moses kehkehlingkihong kaunen kadaudok en mehn Israel ko ire pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Ni ahnsou me aramas emen pahn inoukihda en meirongkihong KAUN-O mehkot de kahukihla me e pahn mweisang mehkot, e sohte pahn kauwehla eh inowo, ahpw e pahn kapwaiada mehkot me e inoukidahr. ");
INSERT INTO pon2006a_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Ma peinakapw men me mihmihte rehn eh pahpa inoukihda en wia mehkot ong KAUN-O de kahukihla en mweisang mehkot, ");
INSERT INTO pon2006a_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","e uhdahn pahn kapwaiada mehkoaros me e inoukidahr ma eh pahpa pahn pwungki. ");
INSERT INTO pon2006a_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Ahpw ma eh pahpa esehda duwen eh inou ahpw sohte pwungki, peinakapwo pahn saledeksangehr nan eh inowo. KAUN-O pahn ketin kupwurmahk ong ih, pwehki eh pahpao eh sohte pwungki. ");
INSERT INTO pon2006a_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Ma lih kiripw men wiahda inou ehu sang ni nsene de wia inou mwahl ehu, de ma e kahukihla en mweisang mehkot, a mwuhr eh ahpw pwopwoudida, ");
INSERT INTO pon2006a_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","e pahn kapwaiada mehkoaros me e inoukihda de kahukihla ma eh pwoudo sohte sapwungki ni eh pahn esehda. ");
INSERT INTO pon2006a_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Ahpw ma eh pwoudo pahn irehdihsang eh inowo ni ahnsou me e esehda, eri e saledeksangehr, e sohte pahn kapwaiada. KAUN-O pahn ketin kupwurmahkohng liho. ");
INSERT INTO pon2006a_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Ma liohdi men de lih emen me mweisangehr eh pwoud pahn inoukihda en mweisang mehkot, e uhdahn pahn kapwaiada. ");
INSERT INTO pon2006a_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Ma lih pwopwoud men inoukihda de kahukihla en mweisang mehkot, ");
INSERT INTO pon2006a_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","e pahn kapwaiada mehkoaros me e inoukidahr de kahukilahr ma eh pwoudo pahn esehda ahpw sohte sapwungki. ");
INSERT INTO pon2006a_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Ahpw ma eh pwoudo pahn irehdihsang en kapwaiada inowo ni eh esedahr, liho saledeksangehr eh inowo oh e kakehr sohla kapwaiada. KAUN-O pahn ketin kupwurmahkohng, pwehki eh pwoudo eh irehdihsang. ");
INSERT INTO pon2006a_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Eh pwoudo ahneki pwung en irehdi de kasohrehla inou me liho wiadahr. ");
INSERT INTO pon2006a_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ahpw ma mwurin rahn ehu eh ahpw esehda duwen eh inowo, e ahpw sohte irehdi, liho pahn kapwaiada mehkoaros me e inoukidahr. Ohlo pwungki inowo ni rahn me e esehda ahpw sohte irehdi. ");
INSERT INTO pon2006a_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ahpw ma mwurin inowo ahpw irehdi, e pahn pwukoakihdi ma liho sohte pahn kapwaiada. ");
INSERT INTO pon2006a_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Ih kosonned pwukat me KAUN-O ketikihong Moses me pid duwen inou me lih kiripw men me kin mihmi ni imwen eh pahpa de lih pwopwoud men wiadahr. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Dupukohng mehn Midian kan dahme re wiahiong mehn Israel kan. Mwurin omw pahn kapwaiada met, ke ahpw pahn mehla.” ");
INSERT INTO pon2006a_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moses eri patohwanohng aramas ako, “Kumwail onopada, pwe kumwail en mahweniong mehn Midian kan oh kaloke irail pwehki ar kauwehla kupwuren KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Kumwail pahn pilada ohl kid sang ni ehuehu kadaudok en mehn Israel kan pwe re en onopada ong mahwen.” ");
INSERT INTO pon2006a_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Ohl kid eri pilipilda sang ehuehu kadaudok en mehn Israel ko, koaros patpene me nen riekid me onopada ong mahwen. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moses eri kadar irail pahn kaweidpen Pineas, nein samworo Eleasar, me kolokol dipwisou sarawi ko iangahki sowi ko mehn wia pakair. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Re ahpw tapihada mahweniong mehn Midian duwen KAUN-O eh ketin mahsanihong Moses, oh re kemehla ohl koaros, ");
INSERT INTO pon2006a_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","iangahki nanmwarki limmen en Midian: Epi, Rekem, Sur, Hur, oh Repa. Re pil kemehla Palaam, nain Peor. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Mehn Israel ko eri salihedi lih en Midian ko oh nair seri ko iangahki neirail pelinmen ko, oh kihsang ar dipwisou kan koaros. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Re pil isikala ar kahnimw kan oh imwarail impwal kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Re ahpw ale dipwisou lohdi koaros, iangahki aramas selidi koaros oh pelinmen kan, ");
INSERT INTO pon2006a_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","oh wahla rehn Moses oh Eleasar oh rehn mehn Israel ko me mihmi ni imwarail impwal ko nan patapat en Mohap ni keilen Pillap Sordan sallahng Seriko. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moses, Eleasar oh kaunen mehn Israel koaros ahpw kohieilasang nan ar kahnimpwalo pwe re en kasamwo karis en sounpei ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moses eri lingeringerda pahn kaunen sounpei ko, irail kan me kaweid pwihn kan me sapahldohsang nan mahwen. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","E ahpw idekda rehrail, “Ia kahrepen amwail sohte kemehla lih akan? ");
INSERT INTO pon2006a_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Kumwail tamataman pwe iei irail me idawehnla kaweid en Palaam oh kahrehiong mehn Israel kan ar soaloalopwoat ong KAUN-O nan Peor. Ih kahrepen soumwahu lusulus me KAUN-O ketikidohng pohn mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Eri met kumwail kemehla pwutak koaros oh lih koaros me wiahier nsenen pwopwoud. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Ahpw kumwail kak kolokol ong pein kumwail serepein kan oh lih meipwon kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Eri met kumwail koaros me kemelahr aramas emen de doahkehda aramas mehla men pahn mihmi likin kahnimpwalo erein rahn isuh. Ni kesiluhn rahn oh ni keisuhn rahn kumwail pahn kamwakeleikumwailda iangahki lih akan me kumwail salihedi. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Kumwail pahn pil kamwakelehda likou koaros oh mehkoaros me wiawihda sang kilin kou, kilin kuht de tuhke.” ");
INSERT INTO pon2006a_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Eleasar eri patohwanohng sounpei ko me ahpwtehn pwurodo sang mahwen, “Ih met koasoandi me KAUN-O ketikihong Moses. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","Mehkoaros me sohte kin mwasikala, rasehng kohl, silper, prons, mete, dihn oh leht pahn kohieng nan kisiniei pwehn mwakelekella. Soahng teikan koaros pahn kin kamwakelkihda pilen kamwakel. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Ni keisuhn rahn kumwail pahn lopworada amwail likou kan; kumwail ahpw pahn mwakelekella ong kaudok, oh pwurehng pedolong nan kahnimpwalo.” ");
INSERT INTO pon2006a_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Kowe oh Eleasar iangahki kaun teikan en mehn Israel, pahn wadekedi mehkoaros me lohdi nan mahwen, iangahki aramas selidi kan oh pelinmen kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Kumwail ahpw pahn nehkpeseng ni pahrek, apali pahn kohieng sounpei kan, a apali pahn kohieng mehn Israel teikan. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Daksis pahn kohieng KAUN-O, sang pali me pahn kohieng sounpei kan, eri emen aramas sang nan wad en aramas selidi limepwiki, pil duwehte sang rehn mahn akan, kou, ahs, sihpw, oh kuht kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Patohwanohng samworo Eleasar nin duwen meirong kesempwal ehu ong KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Sang ni pali me pahn kohieng mehn Israel kan, ale emen aramas sang nan wad en aramas selidi limehk, pil duwehte sang rehn mahn akan, kou, ahs, sihpw, oh kuht kan. Mepwukat pahn kohieng mehn Lipai kan me kin apwahpwalih Impwalen KAUN-O.” ");
INSERT INTO pon2006a_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moses oh Eleasar eri kapwaiada dahme KAUN-O ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","35","Iet uwen tohtohn mehkoaros me sounpei kan kalowehdi nan mahwen, likin me emenemen koledi ong pein ih: sihpw oh kuht me 675,000, kou 72,000, ahs 61,000, serepein meipwon 32,000. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","40","Apali me kohieng sounpei ko, sihpw oh kuht 337,500. Sang mepwukat daksis ong KAUN-O me 675: ong sounpei ko kou 36,000, daksis ong KAUN-O 72. Ong sounpei ko ahs 30,500, daksis ong KAUN-O 61. Serepein meipwon ong sounpei ko 16,000, daksis ong KAUN-O 32. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moses eri kihong Eleasar daksis ko mehn wia meirong kesempwal ehu ong KAUN-O, nin duwen KAUN-O eh ketin mahsanih. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","46","Uwen me kohieng mehn Israel ko pil duwehte me kohieng sounpei ko: sihpw oh kuht 337,500, kou 36,000, ahs 30,500 oh serepein meipwon 16,000. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Sang ni pali wet Moses alehsang emen aramas sang ni wad en aramas selidi limehk, pil duwehte ong mahn akan, duwen KAUN-O eh ketin mahsanih, e ahpw patohwanohng mehn Lipai ko me kin apwahpwalih Impwalen KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Kaunen pwihn en sounpei kan eri patohla rehn Moses ");
INSERT INTO pon2006a_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","oh patohwanohng, “Maing, se patohwan wadekehr sounpei ko me emenemen kiht kaunda, oh sohte me salongala. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Eri se patohwandohr kapwat kohl pwukat, luwou, rihng, mehn tiati, oh mwaramwar kan me emenemen kiht aledier. Se patohwan mweidohng KAUN-O pwehn wia at tungoal meirong oh en ketin sinsilei kiht.” ");
INSERT INTO pon2006a_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moses oh Eleasar ahpw ale kohl me mihmi ni kapwat kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Toutou en kapwat pwukat koaros me sounpei ko kihda mihmi pohnangin paun 400. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Koaros me sohte iang sounpei wie kolokolete dipwisou me re koledi ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moses oh Eleasar eri wahla kohl ko ni Impwalo, pwe KAUN-O en kin apwahpwalih oh sinsile mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Kadaudok kan en Reupen oh Kad naineki kiden pelinmen. Ni ar tehkada duwen wehin Saser oh Kilead eh mwahu ong nair kou kan, ");
INSERT INTO pon2006a_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","re ahpw patohla rehn Moses, Eleasar oh kaun teiko en mehn Israel, oh patohwanohng irail, ");
INSERT INTO pon2006a_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“Sahpwet me KAUN-O ketin sewesehki mehn Israel kan pwe re en patopato loale—kahnimw en Atarod, Dipon, Saser, Nimra, Espon, Eleale, Sipma, Nepo, oh Peon—me mwahu ong neitail pelinmen kan, pwe nait pelinmen kan me tohto. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Menlau kumwail kidohng kiht se en sapwenikihla sahpwet, a ieremen se kotehla Pillap Sordan oh kousoanla wasao.” ");
INSERT INTO pon2006a_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moses ahpw sapeng irail, ketihtihki, “Kumwail men mihmihte met nindokon riamwail mehn Israel kan kohkolahng mahwen? ");
INSERT INTO pon2006a_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Ia duwen amwail kak eimah oh song en katikitikihala kapehd en mehn Israel kan ong ar pahn kotehla Pillap Sordan oh kolahng nan sahpw me KAUN-O ketikihong irail? ");
INSERT INTO pon2006a_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Ihme samamwail ko wia ni ei kadarirailsang Kades Parnea pwe re en kolahng kasawih sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Re kohla lel ni Wahun Eskol oh kilangada sahpwo, ahpw ni ar pwurodo, re katikitikihala kapehd en mehn Israel ko pwe re dehr pedolong nan sahpw me KAUN-O ketikihong irail. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","KAUN-O eri engiengda rahno oh ketin wiahda inou ehu: ");
INSERT INTO pon2006a_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘I kahukihla me ni ar sohte loalopwoatohng ie, sohte ohl emen me sounpar rieisek kohda me iang kohdo sang Isip pahn iang pedolong nan sahpw me I inoukihong Eipram, Aisek, oh Seikop. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Eri met pid koaros, likin Kalep, nein Sepune mehn Kenis oh Sosua, nein Nun; ira kelehpw me loalopwoatohng KAUN-O. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","KAUN-O ketin engiengda pahn aramas ako oh kupwurehda re en kakahnseli nan sapwtehn erein sounpar pahisek, dih ko koaros me kahngiangihada KAUN-O lao mehla. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Eri met kumwail wiliandier samamwail ako, wia dih kapw en aramas dipan me kaunopadahngehr pwe engieng en KAUN-O en pwurehng kohdi pohn mehn Israel kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Ma kumwail kadaudok en Reupen oh Kad pahn kahng idawehn ih met, e pahn pwurehng kesehla aramas pwukat nan sapwtehn, kumwail eri pahn pwukoakihdi ar pahn mwomwla.” ");
INSERT INTO pon2006a_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Irail eri keieng mpen Moses oh patohwanohng, “Komw ketin mweidohng kiht mahs se en kauwada kehl takai met ong nait pelinmen kan oh pil wiahda ekei kisin kahnimw me pahn ahneki kehl kehlail ong at tungoal peneinei kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Se ahpw pahn onopada pwe se en iang mehn Israel kan kolahng mahwen oh koasoanediong irail nan sahpw me pahn wiahla uhdakarail. Ahpw at tungoal peneinei kan pahn koukousoan nan kahnimwet dohsang imwintihti kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Se sohte pahn pwurodo ni at tungoal ihmw kan lao mehn Israel koaros pahn alehdi sahpw me pahn kohieng irail. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Se sohte pahn ale mehkot pwe se en ahnekihla palio Pillap Sordan, pwe se aleier pwaisat wasaht palimesehn Sordan. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moses ahpw sapeng irail, ketihtihki, “Ma kumwail uhdahn pahn kapwaiada dahme kumwail ndindahn, eri met mwohn silangin KAUN-O kumwail onopada pwe kumwail en kolahng mahwen. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Noumwail sounpei koaros en kotehwei Sordan pahn kaweidpen KAUN-O; re en mahweniong atail imwintihti kan lao KAUN-O pahn kaloweiraildi, ");
INSERT INTO pon2006a_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","oh alehdi sahpwo. Eri mwuhr, kumwail kak pwurodo, pwehki amwail kapwaiadahr amwail pwukoa ong KAUN-O oh ong riamwail mehn Israel kan. KAUN-O ahpw pahn kadehdehda me sahpwet ni palimesehn Sordan iei sapwamwail. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Ahpw ma kumwail sohte kapwaiada amwail inou, eri kumwail pahn dipada ong KAUN-O, oh kumwail pahn ale kalokolok en dipamwail. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Eri, kumwail kauwada kahnimw kan ong amwail peneinei kan oh kehl kan ong noumwail pelinmen kan oh kapwaiada dahme kumwail inoukidahr!” ");
INSERT INTO pon2006a_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Kadaudok en Reupen oh Kad ahpw patohwan, “Maing, se pahn kapwaiada omwi mahsen. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","At pwoud oh nait seri kan, iangahki nait kou oh sihpw kan pahn mihmite nan kahnimw kat en Kilead. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Ahpw kiht koaros onopadahngehr mahwen duwen KAUN-O eh ketin mahsanih. Se pahn kotehla Pillap Sordan oh iang mahwen nin duwen omwi mahsanih.” ");
INSERT INTO pon2006a_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Moses eri patohwanohng koasoandi pwukat ong Eleasar, Sosua oh kaun teiko en mehn Israel: ");
INSERT INTO pon2006a_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Ma kadaudok en Kad oh Reupen pahn kotehla Sordan pwehn kolahng mahwen duwen KAUN-O eh ketin mahsanih, oh ma sang ni arail sawas kumwail pahn kak kalowehdi sahpwo, eri kumwail kihong irail re en sapwenikihla Kilead. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ahpw ma re sohte kotehla Sordan oh iang mahwen, re pahn ale pwaisarail sang nan wehin Kenan, duwehte kumwail.” ");
INSERT INTO pon2006a_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Kadaudok en Kad oh Reupen ahpw sapeng, patohwan, “Maing, se pahn kapwaiada dahme KAUN-O mahsanih.” ");
INSERT INTO pon2006a_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Se pahn patohla pahn sapwellime kaweid oh kotehla wehin Kenan oh iang mahwen, pwe se en ale sapwat wasaht, ni palimesehn Sordan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Moses eri kilelehiong kadaudok en Kad oh Reupen oh apali en kadaudok en Manase sahpw koaros me mi pahn Sihon, nanmwarkien mehn Amor, oh Ok, nanmwarkien Pasan, iangahki kahnimw kan oh pil sahpw akan me kapilpene. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Kadaudok en Kad ahpw pwurehng onehda sapahl kahnimw kan en Dipon, Atarod, Aroer, ");
INSERT INTO pon2006a_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrod Sopan, Saser, Sokpea, ");
INSERT INTO pon2006a_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Ped Nimra, oh Ped Aran. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Kadaudok en Reupen pwurehng onehda sapahl Espon, Eleale, Kiriadaim, ");
INSERT INTO pon2006a_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nepo, Paal Meon (ahd wet wekidekla), oh Sipma. Re kihong ahd kapw kei ong kahnimw kan me re onehda sapahl. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Peneineien Makir, nein Manase, ahpw mahweniong wehin Kilead, oh kousoanla ie oh kasarehsang mehn Amor ko me koukousoan wasao. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Moses eri kihong peneineien Makir wehin Kilead, irail eri kousoanla wasao. ");
INSERT INTO pon2006a_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Sair, kisehn kadaudok en Manase, ahpw mahweniong oh kalowehdi kisin kousapw kei oh kahdankinirailla “Kousapwen Sair.” ");
INSERT INTO pon2006a_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nopa mahweniong oh kalowehdi Kenad oh kousapw ekei limwah, e ahpw kihong eden wasao Nopa, me iei ede. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Poadopoad me pahn wad met kasalehda eden wasa kan me mehn Israel ko kauwada ie imwarail impwal kan mwurin ar mweselsang Isip ni kadaudok kan pahn kaweidpen Moses oh Aaron. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Sang ni mahsen en KAUN-O Moses ahpw ntingihedi eden wasa kan ahnsou koaros me re kin kauwada ie imwarail impwal kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Mehn Israel ko mweselsang Isip ni kelimaun rahnen keieun sounpwong en pahro, mandahn rahn keieun Pahsohpa. Re mweselsang kahnimw Rameses pahn epwelipen nin limen KAUN-O mwohn mesen mehn Isip kan, ");
INSERT INTO pon2006a_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","me sansarepedi nair mesenih pwutak kan me KAUN-O ketin kemehla. Ni eh ketin wiahda met, e ketin kasalehda duwen eh ketin manaman sang koht en Isip ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Mehn Israel ko mweselsang Rameses oh kauwada imwarail impwal kan nan Sukot. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Mwurin met re kauwada imwarail impwal ko ni Edam ni keilen sapwtehno. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Sang mwo re pwurodohng Pi Airod, paliepeng en Paal Sepon oh kauwada imwarail impwal ko limwahn Mikdol. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Re mweselsang Pi Airod oh kotehla Sehd Weitahtao kolahng nan sapwtehn en Sur; mwurin ar pil seiseiloangki rahn siluh, re ahpw kauwada imwarail impwal kan nan Mara. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Re mweselsang mwo kolahng Elim, wasa re pil kauwada imwarail impwal kan, pwehki eh mie wasao pwarer eisek riau oh nih isiakan. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Re mweselsang Elim oh kauwada imwarail impwal ko limwahn Dahun Sues. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Mwurin met re pil mweselda oh kauwada imwarail impwal ko nan sapwtehn en Sin. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Mwuri nan Dopka, ");
INSERT INTO pon2006a_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","oh mwuri nan Alus. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Mwurin met nan Repidim, wasa me re sohte diar ie pihl en nimpil. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","37","Re mweselsang Repidim kolahng Nahna Or, re ahpw pil kauwada imwaril impwal ko wasa pwukat: Sapwtehn Sainai, Kiprod Attapa (de “Sousou kan en Ineng”), Aserod, Ridma, Rimmon Peres, Lipna, Rissa, Kehelada, Nahna Seper, Arada, Makelod, Tahad, Tera, Midka, Asmona, Moserod, Pen Sahkan, Or Akkidkad, Sotpada, Aprona, Esiongkeper, sapwtehn en Sin (me iei Kades), oh Nahna Or, ni keilen wehin Edom. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","39","Sang ni mahsen en KAUN-O, samworo Aaron ahpw douda pohn Nahna Or. Ni eh sounpar 123 eh ahpw mehla wasao ni keieun rahnen kelimaun sounpwong ni kapahisek en pahr mwurin mehn Israel ko ar mweselsang Isip. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Nanmwarkien Arad, ni palieir en Kenan, ahpw karongehda me mehn Israel ko seiseiloak kohdo. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","49","Sang ni Nahna Or lel nan patapat en Mohap, mehn Israel ko kauwada imwarail impwal kan ni wasa pwukat: Salmona, Punon, Opod, nan mohn ihmw kan en Aparim nan sapwen Mohap, Dipon Kad, Almon Dipladaim, Nahna Aparim limwahn Nahna Nepo, oh nan patapat en Mohap palio Pillap Sordan sallahng Seriko, nan pwungen Ped Sesimod oh Wahun Akasia. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","KAUN-O ketikihong Moses kaweid pwukat, nan patapat en Mohap palio Sordan sallahng Seriko, ");
INSERT INTO pon2006a_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Ni amwail pahn kotehwei Sordan kolahng nan wehin Kenan, ");
INSERT INTO pon2006a_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","kumwail pahn kasarehsang tohn sahpwo koaros. Kamwomwala arail dikedik en eni kan me wiawihkihda takai de mete oh pil ar wasahn kaudok kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Kumwail kalowehdi sahpwo oh kousoanla ie, pwe I kihong kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Kumwail nehkpeseng sahpwo nanpwungen kadaudok kan oh peneinei kan ni usuhs, oh pelien sahpw laud pahn kohieng peneinei me tohto kan, oh pelien sahpw tikitik pahn kohieng peneinei me malaulau kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Ahpw ma kumwail sohte pahn kasarehla tohn sahpwo, irail kan me luhwehdi pahn wiahla mwahi apwal nan pwoaren masamwail oh tuhke tekatek limwahmwail, irail ahpw pahn mahweniong kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Ma kumwail sohte pahn kasareirailla, I pahn kamwomwkumwailla, duwehte ei kupwukupwure I en kamwomwirailla.” ");
INSERT INTO pon2006a_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","KAUN-O ketikihong Moses ");
INSERT INTO pon2006a_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","kaweid pwukat pwehn patohwanohng mehn Israel ko: “Ni amwail pahn pedolong nan Kenan, sahpw me I pahn kihong kumwail, eri, iet pahn mwomwen irepen sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Irepen palieir pahn sang nan sapwtehn en Sin oh peianla irepen wehin Edom. E pahn tepisang ni palimese ni palieir en imwin Sehden Mehla. ");
INSERT INTO pon2006a_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Mwuhr e ahpw pahn wetilahng palieir kolahng Wasahn Kot en Akrappim oh kolahng Sin lellahng palieir en Kades Parnea. Mwuhr e ahpw pahn wet kolahng ni paliepeng en palikapi kolahng Asar Addar oh douluhllahng Asmon, ");
INSERT INTO pon2006a_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","wasa e pahn wet peianla wahwo ni irepen Isip oh ididi ni Sehd Mediderenien. ");
INSERT INTO pon2006a_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“Sehd Mediderenien me pahn wia irepen palikapi. ");
INSERT INTO pon2006a_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“Irepen paliepeng pahn inen sang Sehd Mediderenien lel Nahna Or, ");
INSERT INTO pon2006a_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","oh sang mwo kolahng Wasahn Kot en Amad. E ahpw pahn douluhllahng Sedad, ");
INSERT INTO pon2006a_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","oh kolahng Sipron, oh pahn ididi ni Asar Enan. ");
INSERT INTO pon2006a_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“Irepen palimese pahn inen sang Asar Enan kolahng Sepahm. ");
INSERT INTO pon2006a_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","E ahpw pahn wet kohdilahng palieir ong Arpel, palimese en Ain, ahpw kolahng ni dohl akan ni palimesehn oaroahr en Lehen Kalili, ");
INSERT INTO pon2006a_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ahpw tang kodihla palieir ni keilen Pillap Sordan kolahng Sehden Mehla. “Ih met irepe pahieu en sapwamwail.” ");
INSERT INTO pon2006a_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Moses eri patohwanohng mehn Israel ko, “Ih sahpwo met me kumwail pahn usuhski, sahpw me KAUN-O ketin kilelehiong kadaudok duwau elep. ");
INSERT INTO pon2006a_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Kadaudok kan en Reupen oh Kad oh palimesehn kadaudok en Manase aleier sapwarail, me nehnepesengehr nin duwen ar peneinei kan, ");
INSERT INTO pon2006a_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ni palimesehn Sordan, sallahng Seriko.” ");
INSERT INTO pon2006a_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Samworo Eleasar oh Sosua, nein Nun, pahn nehkpeseng sahpwo ong aramas akan. ");
INSERT INTO pon2006a_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Pil ale emen kaun sang ni ehuehu kadaudok pwe re en sewese nehk sahpwo.” ");
INSERT INTO pon2006a_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","28","Iet ohl akan me KAUN-O ketin pilada: Kadaudok Kaun Suda Kalep, nein Sepune Simion Selumiel, nein Ammihud Pensamin Elidad, nein Kislon Dan Pukki, nein Sokli Manase Anniel, nein Epod Epraim Kemuel, nein Siptan Sepulon Elisapan, nein Parnak Isakar Paltiel, nein Assan Aser Aihud, nein Selomi Napdali Pedael, nein Ammihud. ");
INSERT INTO pon2006a_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Ih ohl pwukat me KAUN-O ketin kilelehdi pwe re en nehkpeseng sahpwo ong mehn Israel kan nan wehin Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","KAUN-O mahsanihong Moses nan patapat en Mohap palio Sordan sallahng Seriko, ");
INSERT INTO pon2006a_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Ndaiong mehn Israel kan me sang ni sahpw me re aleier, re pahn kihong mehn Lipai kan ekei kahnimw me re pahn kousoan loale iangahki sahpw akan me kapilpene kahnimw kan. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Mehn Lipai kan pahn ahnekihla kahnimw pwukat oh re pahn kin kousoan wasao. Neirail mahn akan me pahn kin mihmi nan sahpw akan likin kahnimw ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Sahpw me neirail mahn akan pahn mihmi loale pahn tangasang ni kelen kahnimwo ni iaht limepwiki ni pali koaros, ");
INSERT INTO pon2006a_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","oh wasao pahn keimw pahieu oh iaht kid pali koaros, oh kahnimwo pahn mi nan werenge. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Kumwail pahn kihong mehn Lipai kan kahnimw en rukula weneu, wasa aramas emen kak tangala ie oh rukula ma e depweila oh kemehla aramas emen. Kumwail pil pahn kihong irail kahnimw pahisek riau, ");
INSERT INTO pon2006a_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","iangahki sahpw me neirail mahn akan pahn kin mihmi loale; eri koaros patpene wiahda kahnimw pahisek waluh. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Uwen tohtohn kahnimw en mehn Lipai nan ehuehu kadaudok pahn wiawihda nin duwen uwen laud en sahpwo.” ");
INSERT INTO pon2006a_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","KAUN-O ketin mahsanihong Moses, ");
INSERT INTO pon2006a_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","en patohwanohng mehn Israel ko, “Ni amwail pahn kotehla Pillap Sordan oh pedolong nan wehin Kenan, ");
INSERT INTO pon2006a_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","kumwail pahn pilada ekei kahnimw en rukula me aramas emen kak tangala oh rukula ie ma e depweila oh kemehla aramas emen. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","E pahn poadondoarsang kisehn me melahro me pahn men ikih. Aramas me kadip uhwong me e kemehla aramas, sohte pahn kamakamala ma e sohte pahn ale kopwung mwohn pokon sansal. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Kumwail pilada kahnimw weneu, ");
INSERT INTO pon2006a_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","siluh ni palimesehn Sordan oh siluh nan wehin Kenan. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Kahnimw pwukat pahn wia kahnimw en rukula ong mehn Israel kan oh mehn liki kan me kin koukousoan rehmwail ni lepin ahnsou de poatopoat. Mehmen me pahn depweila oh kemehla aramas emen kak tangala oh rukula nan ehu kahnimw pwukat. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","18","“Ahpw ma emen pahn ale mete de takai de tuhke pwehn kemehkihla emen, e dipikidahr dipen kamaramas oh e pahn kamakamala. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Kisehn aramas mehlao me keieu keren ahneki pwukoahn kemehla aramas dipadao. Ma e pahn diar aramaso e pahn kemehla. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","“Ma aramas emen pahn kailongki emen oh sikendi de katehki takai pwehn kemehla ");
INSERT INTO pon2006a_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","de pakirih, eri, e dipikidahr dipen kamaramas oh e pahn kamakamala. Kisehn aramas mehlao me keieu keren ahneki pwukoahn kemehla aramas dipadao. Ma e diar aramaso e pahn kemehla. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“Ahpw ma aramas emen pahn depweila oh kemehla emen me e sohte kailongki, ni eh sikendi de katehki takai; ");
INSERT INTO pon2006a_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","de ma aramas emen sohte kilang, ahpw koski takai oh depweila kemehkihla aramas emen me kaidehk eh imwintihti. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Ni soangen irair pwukat aramas koaros pahn uhki aramas me kahrehda mehlao, a kaidehk kisehn aramas mehlao me songosong en ikih me mehlao. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Aramas akan pahn doarehla pwe kisehn aramas mehlao de ikih, oh irail pahn kapwurelahng nan kahnimw en rukula me e tangala ieo. Oh e pahn koukousoante wasao lao Samworo Lapalap en ahnsowo pahn mehla. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Ma me kemehla aramaso pahn kohkohlahsang nan kahnimw en rukula me e tangala ieo, ");
INSERT INTO pon2006a_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","oh ma kisehn me kamakamalao diar ih oh kemehla, irair wet sohte mihmi ni dipen kamaramas. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Aramas emen me depweila oh kemehla emen aramas uhdahn pahn mihmite nan kahnimw en rukula lao Samworo Lapalap pahn mehla, eri, mwurin met e kakehr pwurala ni imwe. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Koasoandi pwukat pahn manaman rehmwail oh rehn kadaudokamwail kan wasa koaros me kumwail pahn kousoan ie. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“Aramas emen me kadip uhwong me e kamaramas pahn kak kamakamala ma sounkadehde pahn me riemen de tohtohsang; kadehdepen aramastehmen sohte itar en utungada kadip en kamaramas. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Aramas emen me kamaramas pahn kamakamala. E sohte kak pitkihla ma e pwainkihda mwohni. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Ma aramas emen pahn tangala rukula nan kahnimw en rukula ehu, kumwail dehr mweidohng en pwainki mwohni pwehn pwurala ni imwe mwohn Samworo Lapalap eh pahn mehla. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Ma kumwail pahn wia met, kumwail pahn kasaminehla sahpw me kumwail koukousoan loale. Pwe kamaramas kin kasaminehla sahpw, oh ihte aramaso me kemehla emen aramas pahn kamakamala me kak pwurehng kamwakelehda sahpwo me aramas kamakamala loale. ");
INSERT INTO pon2006a_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Kumwail dehr kasaminehla sahpw me kumwail koukousoan loale, pwe Ngehi KAUN-O oh I kin koukousoan rehn mehn Israel kan.” ");
INSERT INTO pon2006a_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Moangen peneinei kan nan peneineien Kilead, nein Makir me pahpa kahlapki Manase, nein Sosep, ahpw patohla rehn Moses oh kaun teikan en mehn Israel. ");
INSERT INTO pon2006a_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Re ahpw patohwanohng irail, “KAUN-O ketin mahsanih kumwail en nehkpeseng sahpw rehn mehn Israel kan ni usuhs. E pil mahsanihong kumwail en kihong sapwen kisehto, Selopehad, ong nah serepein ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Ahpw kumwail en tamataman pwe ma re pwoudikihda kadaudok en emen ohl tohrohr, sapwarailo pahn wiahla sapwen kadaudok en ohl me re pwoudikihdao, oh sahpw me kohieng kiht pahn tikitikla. ");
INSERT INTO pon2006a_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Ni pahr en Onohnsapahl, ni ahnsou me sahpw koaros me netlahr pahn pwurehng kapwurupwurlahng me uhdahn sapweniki, sapwen nein Selopehad serepein ko pahn wiahla douluhl sapwen kadaudok me re pwoudikihda oh kadaudok en serepein ko pahn katihasang sahpwo.” ");
INSERT INTO pon2006a_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Moses eri patohwanohng mehn Israel ko koasoandi wet sang rehn KAUN-O, “Dahme kadaudok en Manase patohwan me pwung; ");
INSERT INTO pon2006a_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","eri KAUN-O ketin mahsanih me nein Selopehad serepein kan saledeklahr pwe re en pwoudikihda emen sohte lipilipil me re mwahuki ahpw sangete nan arail kadaudok. ");
INSERT INTO pon2006a_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Sapwen mehn Israel koaros pahn mihmihte nan arail kadaudok. ");
INSERT INTO pon2006a_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Lih koaros me sohsohki sahpw nan ehu kadaudok en Israel pahn pwoudikihda ohl en kadaudokohte. Ih duwen mehn Israel koaros ar pahn sohsohki sapwen ar pahpa kahlap ako, ");
INSERT INTO pon2006a_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","oh sahpwo sohte pahn kohsang ni ehu kadaudok kolahng ni ehu. Kadaudok koaros pahn kolokolete sapwarail. ");
INSERT INTO pon2006a_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","11","Eri Mahla, Tirsa, Okla, Milka, oh Noha, nein Selopehad serepein ko, ahpw kapwaiada dahme KAUN-O ketin mahsanihong Moses, re ahpw pwoudikihda me re pahn pirien ko. ");
INSERT INTO pon2006a_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Irail eri pwopwoudpenehte nan arail peneinei kan en kadaudok en Manase, nein Sosep, oh sapwarail ko mihmihte nan sapwen kadaudok en arail pahpao. ");
INSERT INTO pon2006a_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Ih met koasoandi oh kosonned akan me KAUN-O ketikihong Moses nan patapat en Mohap palio Pillap Sordan sallahng Seriko pwehn patohwanohng mehn Israel ko. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Audepen pwuhk wet iei mahsen kan me Moses mahsanihong mehn Israel ko ni ahnsou me re mihmi nan sapwtehn palimesehn Pillap Sordan. Re mihmi nan Wahun Sordan limwahn Sup, nanpwungen kahnimw Paran me mi apali wasa re mihmi ie, a kahnimw kan en Topel, Lapan Aserod, oh Disahp mi apali. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(2 Rahn eisek ehu aramas kin seiloangki sang Nahna Sainai lel Kades Parnea, keid nan wasa nahnahn Edom.) ");
INSERT INTO pon2006a_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Eri, ni rahn keieu en kaeisek ehun sounpwong en kapahisek en pahr mwurin ar mweselsang Isip, Moses ahpw patohwanohng mehn Israel ko mehkoaros me KAUN-O ketin mahsanih en padahkihong irail. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Met wiawiher mwurin KAUN-O eh ketin kalowehdi Sihon, nanmwarkien mehn Amor kan, me kaunda kahnimw Espon, oh Ok, nanmwarkien Pasan, me kaunda kahnimw Astarod oh Edrei. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Eri, ni aramas ako ar mihmi palimesehn Sordan nanpwungen mehn Mohap, Moses tapihada kawehwe sapwellimen Koht kosonned akan oh sapwellime padahk kan. E ketihtihki, ");
INSERT INTO pon2006a_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Ni atail patopato limwahn Nahna Sainai, KAUN-O, atail Koht, mahsanihong kitail, ‘E wereilahr amwail mihmi limwahn nahnaht. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Kumwail mweselda. Kumwail kohwei wasa nahnahn en mehn Amor, oh wasa koaros me mi limwahn sapwarail—nan Wahun Sordan, wasa nahna kan oh wasa patapat akan, ong palieir, oh pil ong oaroahr en Mediderenien. Kumwail kohwei nan wehin Kenan oh paliweisang Nahna kan en Lepanon lelewohng ni lapalahn Pillap Iupreitis. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Pwe ih sahpwo met me ngehi, KAUN-O, inoukihda me I pahn kihong amwail pahpa kahlap ako, Eipraam, Aisek, oh Seikop, oh pil ong kadaudokarail kan. Kumwail kohwei oh sapwenikihla.’” ");
INSERT INTO pon2006a_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Moses patohwanohng aramas ako, “Nindokon atail patopatohte nin Nahna Sainai, I padahkihong kumwail me pwukoahn kahluwai kumwail me nohn toutou ong ie, I sohte kak kelehpw kahluwai kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","KAUN-O, amwail Koht ketin kahngedereikumwailla rasehng usuhn pahnlahng kan. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","KAUN-O, Koht en samamwail ko, en ketin katohtohweikumwailla pahn pak kid oh ketin kupwuramwahwihkumwailla nin duwen eh ketin inoukidahr. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Ahpw ia duwen ei kak kelehpwki pwukoahn kapwungala amwail akupwung kan oh repenpwung kan? ");
INSERT INTO pon2006a_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Kumwail pilada ekei ohl loalokong oh koahiek sang nan ehuehu kadaudok kan, I ahpw pahn koasoanediong irail re en kin apwahpwalih kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Eri, kumwail sapengkinieier me kumwail pwungki ire wet. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Ngehi eri kamanahla ohl loalokong oh koahiek me kumwail piladahr sang nan kadaudok kan, oh koasoanehdi re en apwahpwalih kumwail. Ekei pwukoahki epwelpen aramas kid, ekei epwelpen aramas epwiki, ekei limehk, a ekei ehk. I pil kilelehdi ekei sounsawas sang nan kadaudok kan. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","“Ni ahnsowo I kaweidkin irail, ‘Kumwail rong akupwung kan me kin pwarada nanpwungamwail. Kumwail wia kopwung ni pwung pahrek rehn mehn Israel kan oh pil rehn mehn liki kan me kin kousoan rehmwail. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Kumwail dehr kin uhpalihki emen ni amwail pahn kin koasoanehdi pwunglahn ar repenpwung kan, kumwail wia soahng koaros ni pwung pahrek. Kumwail dehr masak emen aramas, pwe amwail koasoandi kan kin sang rehn Koht. Ma iren kopwung ehu me nohn apwal ong kumwail, a kumwail wadohng ie oh I ahpw pahn koasoanehdi dahme pahn wiawi.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Pil ni ahnsowohte I kaweidkin kumwail dahme pahn kin wiawi ni soahng teikan koaros me kumwail pahn kin wia. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“Kitail patohwan kapwaiadahr dahme KAUN-O ketin mahsanihong kitail. Kitail mweselsang Nahna Sainai oh kotehla sapwtehn kalaimwun oh kamasepwehko kolahng sahpw nahnahn en mehn Amor. Ni atail lelohng Kades Parnea, ");
INSERT INTO pon2006a_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","21","I ndaiong kumwail, ‘Kumwail lelehr sapwen mehn Amor kan, me KAUN-O, atail Koht oh Koht en atail pahpa kahlap ako pahn ketikihong kitail. Io, kumwail kilang. Kumwail kohwei oh sapwenikihla duwen me e ketin mahsaniher. Kumwail dehr peikasal de masepwehk.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","“A kumwail ahpw patohdo rehi oh patohwan, ‘Kitail kadarala mwohtail ekei lipoahrok pwe re en dawih sahpwo, pwe re en padahkihong kitail elen kolahng wasao oh mwomwen kahnimw ko.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","“Ngehi eri pwungki ire wet, I ahpw piladahr ohl ehk riemen, emen sang nan ehuehu kadaudok. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Irail eri kohla nan sahpw nahnahn oh pil lellahng Wahun Eskol oh dawih sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Re wahdo wahntuhke kei me re diarada wasao oh pakairkihdo me sahpw me KAUN-O pahn ketikihong kitail me inenen pwehl mwahu. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“Ahpw kumwail kahngohdiongala mahsen en KAUN-O, amwail Koht, ih me kumwail sohte pahn pedokilong nan sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Kumwail lipahnedihada KAUN-O, ketihtihki, ‘KAUN-O ketin kalahdekin kitail. E ketikinkitaildo sang Isip pwehn ketikihong kitail rehn mehn Amor kan pwe re en kemeikitailla. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Dahme kitail pahn kolahng wia wasao? Se masepwehk. Aramas ako me se kadarala mwo patohwanong kiht me tohn wasao me inenen kehlail oh reireisang kitail, oh dene kelen ar kahnimw kan leldalahng pahnlahng. Re kilangada kodon kei wasao!’ ");
INSERT INTO pon2006a_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","“Ahpw I ndaiong kumwail, ‘Kumwail dehr masak aramas pwuko. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","KAUN-O, amwail Koht pahn ketin kahluwai kumwail oh pahn ketin mahwenkin kumwail, duwehte me e ketin wiahiong kumwail nan Isip oh nan sapwtehno. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Kumwail kilahngehr duwen eh ketin waikumwaildo lel wasaht sohte diar apwal laud, duwehte pahpa men eh kin kahluwa nah seri.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Ahpw ni ei patopatohwan mepwukat, kumwail pil sohte likih KAUN-O, ");
INSERT INTO pon2006a_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","mehnda ma e kin ketin tiengla mwohmwail ahnsou koaros pwehn ketin rapahkihong kumwail wasa kumwail pahn kin kauwada ie imwamwail impwal kan. E ketin tieng mwohmwail nan uhr kisiniei nipwong oh ni uhr en depwek ehu ni rahn, pwehn kasalehiong kumwail ahlo. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“KAUN-O ketin karongehda amwail kaulim kan oh ketin engienghkihda, ih me e ketin mahsanihki oh koasoanehkihdi, ");
INSERT INTO pon2006a_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘Sohte emen kumwail sang dih suwed wet pahn pedolong nan sahpw kaselel me I inoukihda me I pahn kihong amwail pahpa kahlap ako. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Kalepte, nein Sepune me pahn pedolong loale. Pwehki eh loalopwoatohng ie, I pahn kihong ih oh kadaudoke kan sahpw me e dawihero.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Kumwail me pil kahrehda KAUN-O eh ketin engiengda pahi oh mahsanih, ‘Pil kowe, Moses, ke sohte pahn iang pedolong nan sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Ahpw sawasepomw Sosua, nein Nun, iei ih me pahn pedolong. Koangngoangehki met, pwe ih me pahn kahluwa Israel pwehn sapwenikihla sahpwo.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","“KAUN-O eri ketin mahsanihong kitail koaros, ‘Noumwail seri kan me saikinte ese dahme sapwung oh dahme pwung, iei irail me pahn pedolong nan sahpwo—noumwail seri kan me kumwail ndinda dene amwail imwintihti kan pahn koledi, I pahn kihong irail sahpwo, oh irail me pahn kousoanla loale. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Ahpw kumwail, kumwail pwurala nan sapwtehno oh keid nan ahl me kolahng Sehden Akapa.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“Kumwail eri sapeng ie, patohwan, ‘Moses, se dipadahr ong KAUN-O. Se pahn patolahng mahwen met, duwen me KAUN-O ketin mahsanih.’ Eri, emenemen kumwail ahpw onopadahng mahwen oh lemeleme me mehkot mengei ehu alehdi sahpw nahnahno. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","“KAUN-O ahpw ketin mahsanihong ie, ‘Ndaiong irail re dehr mahwen, pwe I sohte pahn iang irail, re pahn lohdiong pahn ar imwintihti kan.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","I patohwanohng kumwail dahme KAUN-O ketin mahsanih, ahpw kumwail sohte men rong. Kumwail kahngohdiong ih oh nan amwail aklapalap kumwail mwesel kolahng nan sahpw nahnahno. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Mehn Amor ko me koukousoan wasa nahnahn pwuko, ahpw kodohng kumwail rasehng mwuten loangalap ehu. Re ahpw pwakihkumwaildo lel Orma oh kaloweikumwaildi nan sahpw nahnahn Edom. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Kumwail eri likweriong KAUN-O oh peki sapwellime sawas, ahpw e sohte mwahn karongei kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","“Eri, mwurin atail mihmihki Kades ahnsou reirehie, ");
INSERT INTO pon2006a_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","kitail ahpw pwurala oh kolahng nan sapwtehno, keid nan ahl me kolahng Sehden Akapa, nin duwen me KAUN-O ketin mahsanih; kitail ahpw seiseiloakseli ahnsou reirei nan sahpw nahnahn Edom. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","“KAUN-O eri ketin mahsanihong ie ");
INSERT INTO pon2006a_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","me e wereilahr atail seiseiloakseli nan sahpw nahnahn ko oh kitail pahn mwekidla paliepeng. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","E mahsanihong ie I en patohwanohng kumwail kaweid pwukat: ‘Kumwail nektehn pahn kotehla sahpw nahnahn Edom, sapwen kisehmwail ko, kadaudok en Esau ko. Irail pahn masak kumwail, ");
INSERT INTO pon2006a_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ahpw kumwail sohte pahn mahweniong irail, pwe I sohte pahn kihong kumwail kisin wasa kis sang nan sapwarail. Pwe I kihongehr kadaudok en Esau ko re en sapweniki Edom. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Kumwail kak pwainsang irail kisin mwenge oh pihl.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","“Kumwail tamataman duwen KAUN-O, amwail Koht eh ketin kupwuramwahwihkumwailahr ni mehkoaros me kumwail wiadahr. E ketin apwalih kumwail nindokon amwail seiseiloakseli nan sapwtehno. E ketin ieiang kumwail erein sounpar pahisek, oh kumwail aledier soahng koaros me kumwail kin anahne. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“Kitail ahpw mweseldahsang nan ahl me tangasang kisin kahnimw kan en Elad oh Esiongkeper kolahng Sehden Mehla, kitail ahpw wet kolahng Mohap ni paliepeng en palimese. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","KAUN-O ketin mahsanihong ie, ‘Dehr kedirapwa mehn Mohap kan, kadaudok en Lohd kan, de pil mahweinong irail. I kihongirailehr kahnimwen Ar, oh I sohte pahn kihong kumwail ekis sang nan sapwarailo.’” (");
INSERT INTO pon2006a_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Keinek kehlail en kodon kei me adaneki mehn Em kin kousoan Ar mahso. Re reirei duwehte mehn Anak, pil ehu keinek en kodon. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Re pil kin adaneki mehn Repa, duwehte mehn Anak, ahpw mehn Mohap kin ekerkin irail mehn Em. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Mahso mehn Hor me kin kousoan Edom, ahpw kadaudok kan en Esau pwakihrailsang wasao, kauwehla arail wehi, oh kousoanla wasao, duwehte mehn Israel ko ar pwakihasang ar imwintihti ko nan sahpw me KAUN-O ketikihong irail.) ");
INSERT INTO pon2006a_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“Mwuhr kitail ahpw kotehla Pillap Sered duwen me KAUN-O ketin mahsanihong kitail. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Met iei sounpar silihsek waluh mwurin atail mweselsang Kades Parnea. Ohl koaros me kin mahwen nan diho melahr, duwen me KAUN-O ketin mahsaniher. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","KAUN-O ketin uhwong irail, e lao ketin kamwomwirailla koaros. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“Mwurin arail melahr koaros, ");
INSERT INTO pon2006a_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","KAUN-O ahpw mahsanihong kitail, ");
INSERT INTO pon2006a_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘Rahnwet kumwail pahn kotehla sapwen mehn Edom kan, kolahng Ar. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Kumwail pahn keid karanihte sapwen mehn Ammon, kadaudok en Lohd, Kumwail dehpa kadirapwa irail de mahweniong irail, pwe I sohte pahn kihong kumwail ekis wasa sang nan sapwarail me I kihongirailehr.’” ( ");
INSERT INTO pon2006a_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Sahpw wet pil kin adaneki sapwen Repa, eden aramas ako me kin kousoan wasao; mehn Ammon kahdanekin irail mehn Samsum. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Re reirei duwehte mehn Anak, Irail me tohto oh wia keinek kehlail. Ahpw KAUN-O ketin kamwomwirailla, oh mehn Ammon ahpw kihsang sapwarailo oh kousoanla wasao. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","KAUN-O pil ketin wiahda soahngohte ong mehn Edom, kadaudok kan en Esau, me kin kousoan nan wasa nahnahn Edom. E ketin kamwomwala mehn Hor, mehn Edom eri alehdi sapwarailo oh kousoanla ie, wasa re mihmihte ie lel met. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Sahpw me mi ni keilen Mediderenieno mehn dekehn Krihd me kihsang oh kousoanla ie. Re kamwomwala mehn Ap, me iei uhdahn tohn wasao, re ahpw kihsang sahpwo pwon lel palieir ni kahnimw en Kasa.) ");
INSERT INTO pon2006a_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Mwurin atail kotelahr sapwen Mohap, KAUN-O ahpw mahsanihong kitail, ‘Met kumwail mwesel oh kotehla Pillap Arnon. I pahn kihong Sihon, nanmwarkien Espon, pahn amwail manaman, iangahki sapwe kan koaros. Kumwail mahweniong oh kousoanla nan sapweo. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Sang met kohla I pahn wiahda pwe aramas akan wasa koaros re en kin masak kumwail. Koaros pahn rerrerki masak ni ar pahn rong adamwail.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“Ngehi eri kadarala meninkeder kei sang nan sapwtehn en Kedemod ong Sihon, nanmwarkien Espon, iangahkihla pekipen meleilei wet: ");
INSERT INTO pon2006a_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘Komw ketin mweidohng kiht se en kotehla mahs nin limomwiet. Se pahn patohwan inenlahte sohte wetsang nan ahllapet. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Se pahn pwain kisin tungoal me se pahn tungoale oh pihl me se pahn nim. Ihte me se men patohwan wia, kotehla nin limomwiet, ");
INSERT INTO pon2006a_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","se lao sipalla palio Sordan ong nan sahpw me KAUN-O pahn ketikihong kiht. Kadaudok en Esau, me kin kousoan nan Edom, oh mehn Mohap me kin kousoan Ar, patohwan mweidohngkitehr se en kotehla sapwarailo.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","“Ahpw Nanmwarki Sihon sohte mweidohng kitail en kotehla sapweo. KAUN-O, amwail Koht ketin kupwurehiong pwe en kahngohdi oh keptakaila, pwe kitail en kak kalowehdi oh adihasang sapweo, iei sahpw me kitail koukousoan ie lel rahnwet. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","“KAUN-O ahpw mahsanihong ie, ‘Kilang, I kaluwetehla Nanmwarki Sihon oh eh wehi. E sohte kak uhwong kumwail; kumwail eri adihasang sapweo oh kousoanla wasao.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Sihon ahpw ketieila iangahki sapwellime karis kan pwe re en mahweniong kitail limwahn kisin kahnimw en Sahas, ");
INSERT INTO pon2006a_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ahpw KAUN-O, atail Koht ketikihong ih pahn atail manaman, ihme kitail patohwan kemehkihla, iangahki sapwellime pwutak kan oh sapwellime sounpei koaros. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Ni ahnsowohte se koledi oh kamwomwala kisin kahnimw koaros oh kemehla towe kan, ohl, lih oh seri koaros. Sohte me luhwehdi rehrail. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Se kihsang pelinmen kan oh kauwehla kisin kahnimw kan. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","KAUN-O atail Koht ketin mweidohng kitail en kalowehdi kisin kahnimw koaros sang Aroer me mi ni keilen Wahun Arnon, oh kahnimwo me mi nanwerengen wahuo, oh pil lellahng Kilead. Sohte kelen kisin kahnimw ehu me kehlail me kitail sohte kin kakohng. ");
INSERT INTO pon2006a_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Ahpw kitail sohte kohla limwahn sapwen mehn Ammon kan de ni keilen Pillap Sappok de nan kisin kahnimw kan en wasa nahnahn de wasa kan me KAUN-O, atail Koht ketin mahsanihong kitail, kitail en dehr kohla ie. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“Mwuhr, kitail ahpw wet kohdalahng wehin Pasan, oh Ok, nanmwarkien Pasan, ahpw ketieido iangahki sapwellime sounpei koaros pwehn mahweniong kiht limwahn kahnimw en Edrei. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","KAUN-O ahpw mahsanihong ie, ‘Ke dehr masak. Pwe I pahn kihong uhk ih iangahki nah sounpei kan oh pil sapwe kan koaros. Wiahiong soahngohte me ke wiahiong Sihon, nanmwarkien mehn Amor, me kakaun Espon.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","“Ih duwen KAUN-O eh pil ketikihong nanmwarki Ok iangahki sapwellime kan koaros pahn atail manaman, kitail eri kemeirailla koaros. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Ni ahnsowohte kitail pil kalowehdi eh kisin kahnimw koaros— sohte ehu me kitail sohte kalowehdi. Kahnimw koaros me kitail kalowehdi patpene me weneisek—wehin Arkop pwon, wasa me Ok, nanmwarkien Pasan, kin kakaun ie. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Kelen kahnimw pwukat koaros me ileile iangahki ewen kehl kan, oh lepin mete me katengehdi ewen kehl kan, pil iangahki kousapw tohto me sohte kele. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Kitail kamwomwalahr kahnimw koaros oh kemelahr ohl, lih oh seri koaros, duwehte me kitail wiahiongehr kahnimw kan me Sihon, nanmwarkien Espon, kin kakaun. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Kitail pil kihsang pelinmen kan oh dipwisou kan, oh kauwehla kisin kahnimw kan. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","“Ni ahnsowo kitail pil kihsang rehn nanmwarkien Amor riemeno sahpw me mi ni palimesehn Pillap Sordan, sang Pillap Arnon kolahng Nahna Ermon. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Mehn Saidon kin kahdaneki Nahna Ermon Sirion, a mehn Amor kin kahdaneki Senir.) ");
INSERT INTO pon2006a_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Kitail kihsangehr sapwen Nanmwarki Ok koaros, me kin kakaun Pasan; iei kahnimw kan nan sahpw patapato, oh sapwen Kilead oh Pasan, oh pil lellahng kisin kahnimw en Saleka oh Edrei ni palimese.” ( ");
INSERT INTO pon2006a_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Nanmwarki Ok me wia kaimwseklahn nanmwarkien Repa. Eh kohpwahn mehla wiawihkihda takai, piht weneu tehlap oh kerenieng piht eisek pahiu reirei, nin duwen sosohng en mehn Ammon. Me mihmihte nan kahnimw en Ammon nan Rappa lel rahnwet.) ");
INSERT INTO pon2006a_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“Ni atail kalowehdi sahpwo, I kihong kadaudok en Reupen oh Kad pwe re en sapwenikihla paliepeng en kisin kahnimw Aroer limwahn Pillap Arnon oh ekis wasa sang nan sahpw nahnahn Kilead iangahki kisin kahnimw kan me mi loale. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","I kihong apali en kadaudok en Manase luhwen wehin Kilead iangahki sahpw koaros nan Pasan, wasa me Nanmwarki Ok kin kakaun, me iei wehin Arkop pwon.” (Mahs Pasan kin adaneki wehin Repa. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Sair, kadaudok en Manase, kihsang wehin Arkop pwon, me iei Pasan, oh pil lellahng ni irepen Kesur oh Maaka. E kihong eden kousapw ako pein edeo, kousapw ako eri adadanekihte Sair lel rahnwet.) ");
INSERT INTO pon2006a_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","“I kihla Kilead ong peneineien Makir sang kadaudok en Manase. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Oh ong kadaudok en Reupen oh Kad I kihla sahpw sang Kilead lel Pillap Arnon. Nanwerengen pillapo me wia irepen palieir, oh Pillap Sappok me wia irepen paliepeng, me kisin wasa kis wia irepen sapwen mehn Ammon. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Ni palikapi en sapwarailo lellahng ni Pillap Sordan, sang Lehen Kalili ni paliepeng kohdilahng ni palieir en Sehden Mehla oh lellahng ni tepin Nahna Piska ni palimese. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“Ni ahnsowohte I kihong irail kaweid pwukat: ‘KAUN-O, atail Koht, ketikihong kumwail palimesehn Sordan pwe kumwail en kousoanla loale. Eri, met kumwail onopada amwail tehtehn mahwen oh noumwail sounpei kan pwe re en kotehla Pillap Sordan mwohn kadaudok en Israel teiko, pwe kumwail en sewese irail ni ar pahn ale sahpwo. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Ihte noumwail pelinmen kan, amwail pwoud kan oh noumwail seri kan—I ese me kumwail naineki pelinmen tohto—irailte me pahn mihmi nan kisin kahnimw kan me I kihongkumwailehr. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Kumwail sewese riamwail mehn Israel kan, re lao pahn alehdi sahpw me KAUN-O pahn ketikihong irail ni palikapi en Sordan oh lao KAUN-O eh pahn ketin mweidohng irail en soandihla wasao ni meleilei, nin duwen me e ketin wiahiong kumwail wasaht. Mwurin mwo, kumwail kakehr pwurodo nan sahpw me I kihongkumwailehr.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","“Ngehi eri kaweidki Sosua: ‘Ke kilangehr mehkoaros me KAUN-O, omw Koht ketin wiahiongehr nanmwarki riemeno, Sihon oh Ok; e pahn pil ketin wiahiong koaros me kumwail pahn kin mahweniong sapwarail kan. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Ke dehr masak irail, pwe KAUN-O, amwail Koht pahn ketin mahwenkin kumwail.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“Ni ahnsowo I ngidingidki ei kapakap, patohwan, ");
INSERT INTO pon2006a_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘Maing KAUN, Wasa Lapalahpie, I patohwan ese me komw ketin kasalehiong ie tepin soahng kapwuriamwei kan me komw pahn ketin wiahda. Sohte emen koht nanleng de sampah me kak wia soahng kapwuriamwei kan me komw ketin wiadahr! ");
INSERT INTO pon2006a_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Maing KAUN, komw ketin mweidohng ie I en kotehla Pillap Sordan oh kilang sahpw kaselel me mi palio, sahpw nahnahn kaselel iangahki Nahnahn Lepanon kan.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","“Ahpw pwehki kumwail KAUN-O ketin engiengda pahi oh sohte men ketin karonge. Ahpw e ketin mahsanih, ‘Erier! Ke dehr pwurehng patohwanda duwen irair wet! ");
INSERT INTO pon2006a_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Kohwei pohn kumwen Nahna Piska oh kilenglahng ni paliepeng oh palieir, ni palimese oh palikapi. Kadehde mwahu dahme ke uduhdiahl, pwe ke sohte pahn kotehla Sordan. ");
INSERT INTO pon2006a_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Kaweidki Sosua dahme eh pahn wia. Kakehlahda kapehde, pwe e pahn kahluwa aramas akan pwe re en kolahng kousoanla nan sahpw me ke kilikilang en.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","“Kiht eri mihmihte nan wahu me sallahng kahnimw Pedpeor.” ");
INSERT INTO pon2006a_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Eri, Moses ahpw mahsanihong aramas ako, “Kumwail rong kanahieng met kosonned kan oh koasoandien tiahk kan me I pahn padahkihong kumwail, oh kapwaiada, pwe kumwail en kak mourla oh kak pedolong oh sapwenikihla sahpwo me KAUN-O, Koht en amwail pahpa kahlap ako, pahn ketikihong kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Kaleke kumwail kapatahiong de pil kihsang elep pwuloi nan ei kosonned kan. Kapwaiada kosonned en KAUN-O, amwail Koht, nin duwen mehkoaros me I kihong kumwail. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Pein kumwail kadehdeier dahme KAUN-O ketin wiadahr nin Nahna Peor, duwen eh ketin kamwomwala irail koaros me kin pwongih Paal wasao. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Ahpw kumwail me loalopwoatohng KAUN-O, amwail Koht, kumwail wie momourte lel rahnwet. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“Eri, I padahkihongkumwailehr kosonned koaros, nin duwen KAUN-O, ei Koht eh ketin mahsanihong ie, pwe kumwail en kin kapwaiada nan sahpwo me kumwail pahn pedolong loale oh sapwenikihla. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Kapwaiada ni loalopwoat, pwe met pahn wiahla kadehdepen amwail loalokong oh kupwurokong nan wehi teikan. Pwe ni ar pahn rong duwen kosonned pwukat koaros, re pahn kapingahla, nda, ‘Sohte wehi ehu me loalokong oh kupwurokong duwehte wehi lapalap wet.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","“Pwe sohte wehi lapalap ehu mie, me eh koht kin kerendohng duwehte KAUN-O, atail Koht, eh kin ketin kerendohng kitail ni ahnsou me kitail kin anahne. E kin ketin sapeng kitail ni atail kin likweriong oh peki sapwellime sawas ahnsou koaros. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Sohte wehi lapalap ehu mie me ahneki kosonned me inenen pwung duwehte kosonned pwukat me I padahkihongkumwailehr rahnwet. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Ahpw kumwail pahn kanahieng, pwe kumwail dehr manokehla ire kesempwal akan me kumwail pein kadehdehkiher masamwail kan. Kumwail dehpa mweidohng re en sohrasang nan kapehdamwail erein amwail mour. A kumwail pahn kin koasoiaiong noumwail seri kan oh nein noumwail seri kan, ");
INSERT INTO pon2006a_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","duwen rahn me kumwail uh limwahn nahna Orep mwohn silangin KAUN-O, amwail Koht; oh duwen eh mahsanihong ie, ‘Kapokonepene aramas akan mwohi, pwe re en rong dahme I pahn mahsanih, oh re en esehla waunekin ie erein ar mour pwe re en padahkihong nair seri kan duwen wauwi.’ ");
INSERT INTO pon2006a_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","“Koasoiaiong noumwail seri kan duwen amwail kohla oh uh ni keilen nahnao me rotorotkihla ediniei mosul oh lullul leldalahng pahnlahng. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Pil duwen en KAUN-O eh mahseniong kumwail sang nan mpwulo, oh duwen amwail rong kapitie, ahpw sohte kilang mwomwe. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","E ketin padahkihong kumwail dahme kumwail en wiewia pwe kumwail en kapwaiada inowo nanpwungen ih oh kumwail—kumwail en peikiong Kosonned Eiseko me e ketin ntingihedi pohn pelien takai riapalio. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","KAUN-O mahsanihong ie I en padahkihong kumwail kosonned koaros me kumwail pahn kin kapwaiada nan sahpw me kumwail nektehn pahn pedolong loale oh sapwenikihla.” ");
INSERT INTO pon2006a_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“Kumwail eri kanahieng. Ni amwail sohte kilang mwohmw ehu ni rahn me KAUN-O ketin mahseniong kumwail nin Nahna Sainai sang nan mpwulo, ");
INSERT INTO pon2006a_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","kahrehda kumwail dehr pein kauweikumwailla ni amwail pahn pein wiahiong kumwail mwohmw de dikedik en eni sohte lipilipil— mwomwen aramas ohl de lih, ");
INSERT INTO pon2006a_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","de mwomwen mahn, menpihr, ");
INSERT INTO pon2006a_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","mahn kerep, de mwahmw. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ni amwail pahn kilengdalahng pahnlahng oh kilang ketipin, maram oh usu kan, kumwail dehpa sapwungala wiahkin irail koht oh pwongih irail. Pwe KAUN-O, amwail Koht ketikihongehr wehi teikan koaros mepwukat pwe re en pwongih. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","A kumwail me KAUN-O ketin pilada oh ketin kahluwaikumwaildo sang Isip, duwehte sang nan kisiniei mwehl ehu me kin kapeipeseng mete, pwe kumwail en wiahla sapwellime aramas, nin duwen me kumwail wiewia rahnwet. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","KAUN-O ahpw ketin engiengda pahi pwehki kumwail, oh ketin kahukihla me I sohte pahn kotehla Pillap Sordan, de I sohte pahn iang pedolong nan sahpw kaselelo me e pahn ketikihong kumwail pwe kumwail en sapwenikihla. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","I pahn mehla nan sahpw wet oh sohte pahn iang kotehla Pillap Sordan, a kumwail pahn mwadang kotehla oh sapwenikihla sahpw kaselelo. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Eri, kumwail kanahieng oh dehr manokehla inowo me KAUN-O, amwail Koht, ketin wiahiongkumwailehr. Kumwail en peikiong sapwellime kosonned pwe kumwail en dehr wiahiong kumwail dikedik en eni men, sohte lipilipil, ");
INSERT INTO pon2006a_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","pwe KAUN-O, amwail Koht, iei Koht emen me rasehng mwehl en kisiniei, pwe ih Koht luwakahk emen. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“Ni amwail pahn soandier nan sahpwo ahnsou reirei oh kilangehr noumwail seri oh pil nein noumwail seri kan, kumwail dehr dipikihda amwail pahn pein wiahiong kumwail dikedik en eni ehu ni soangen mwohmw ehu sohte lipilipil. Met me suwed kowahlap mwohn silangin KAUN-O oh e pahn ketin engiengda. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Eri, rahnwet I kahukihla ni mwaren nanleng oh sampah, me ma kumwail pahn wia soahng pwukat, kumwail uhdahn pahn ohkihla. Kumwail sohte pahn mour werei nan sahpw me kumwail kohkolahng sapwenikihla. Pwe kumwail pahn kamwomwmwomwla douluhl. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","KAUN-O pahn ketin kamwarangkumwailseli nanpwungen wehi kan, oh me malaulau rehmwail me pahn mourla wasao. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Eri, nan wasa ko kumwail pahn kin kaudokiong koht kan me kin wiawihda sang ni pehn aramas, me kin wiawihkihda tuhke de takai, me sohte kak kilang wasa, sohte kak rong wasa, de kang mehkot, de sohte kak ned pwohn mehkot. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Kumwail pahn rapahki KAUN-O, amwail Koht, wasao; eri ma kumwail pahn rapahki ni mohngiong unsek, kumwail pahn diar. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Ni amwail pahn miher nan apwal pwehki soahng pwukat lelohngkumwailehr, eri, kumwail pahn sohpeiong KAUN-O oh kapwaiada sapwellime kosonned akan. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Pwe ih Koht kalahngan emen. E sohte pahn ketin keseikumwailla de kamwomwkumwailla. E sohte pahn likidmeliehla inowo me pein ih ketin wiahiong amwail pahpa kahlap ko. ");
INSERT INTO pon2006a_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“Kumwail kalelapak duwen dahme pweida