﻿USE sofia;
DROP TABLE IF EXISTS sofia.polubg_vpl;
CREATE TABLE polubg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES polubg_vpl WRITE;
INSERT INTO polubg_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Na początku Bóg stworzył niebo i ziemię. ");
INSERT INTO polubg_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","A ziemia była bezkształtna i pusta i ciemność była nad głębią, a Duch Boży unosił się nad wodami. ");
INSERT INTO polubg_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","I Bóg powiedział: Niech stanie się światłość. I stała się światłość. ");
INSERT INTO polubg_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Bóg widział, że światłość była dobra. I oddzielił Bóg światłość od ciemności. ");
INSERT INTO polubg_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","I nazwał Bóg światłość dniem, a ciemność nazwał nocą. I nastał wieczór i poranek, dzień pierwszy. ");
INSERT INTO polubg_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Potem Bóg powiedział: Niech stanie się firmament pośrodku wód i niech oddzieli wody od wód. ");
INSERT INTO polubg_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","I uczynił Bóg firmament, i oddzielił wody, które są pod firmamentem, od wód, które są nad firmamentem. I tak się stało. ");
INSERT INTO polubg_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","I Bóg nazwał firmament niebem. I nastał wieczór i poranek, dzień drugi. ");
INSERT INTO polubg_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Potem Bóg powiedział: Niech się zbiorą w jednym miejscu wody, które są pod niebem, i niech się ukaże sucha powierzchnia. I tak się stało. ");
INSERT INTO polubg_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","I Bóg nazwał suchą powierzchnię ziemią, a zbiorowisko wód – morzami. I Bóg widział, że to było dobre. ");
INSERT INTO polubg_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Potem Bóg powiedział: Niech ziemia zrodzi trawę, rośliny wydające nasiona i drzewo urodzajne przynoszące owoc według swego rodzaju, którego nasienie będzie w nim na ziemi. I tak się stało. ");
INSERT INTO polubg_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","I ziemia wydała trawę, rośliny wydające nasienie według swego rodzaju i drzewo przynoszące owoc, w którym było nasienie według swego rodzaju. I Bóg widział, że to było dobre. ");
INSERT INTO polubg_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","I nastał wieczór i poranek, dzień trzeci. ");
INSERT INTO polubg_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Potem Bóg powiedział: Niech się staną światła na firmamencie nieba, by oddzielały dzień od nocy, i niech stanowią znaki, pory roku, dni i lata. ");
INSERT INTO polubg_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","I niech będą światłami na firmamencie nieba, aby świeciły nad ziemią. I tak się stało. ");
INSERT INTO polubg_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","I Bóg uczynił dwa wielkie światła: światło większe, aby rządziło dniem, i światło mniejsze, aby rządziło nocą, oraz gwiazdy. ");
INSERT INTO polubg_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","I Bóg umieścił je na firmamencie nieba, aby świeciły nad ziemią; ");
INSERT INTO polubg_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","I żeby rządziły dniem i nocą, i oddzielały światłość od ciemności. I Bóg widział, że to było dobre. ");
INSERT INTO polubg_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","I nastał wieczór i poranek, dzień czwarty. ");
INSERT INTO polubg_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Potem Bóg powiedział: Niech wody hojnie wydadzą żywe istoty, a ptactwo niech lata nad ziemią, pod firmamentem nieba. ");
INSERT INTO polubg_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","I Bóg stworzył wielkie wieloryby i wszelkie pływające istoty żywe, które hojnie wydały wody, według ich rodzaju oraz wszelkie ptactwo skrzydlate według jego rodzaju. I Bóg widział, że to było dobre. ");
INSERT INTO polubg_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Bóg błogosławił je, mówiąc: Bądźcie płodne i rozmnażajcie się, i wypełniajcie wody morskie, a ptactwo niech się rozmnaża na ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","I nastał wieczór i poranek, dzień piąty. ");
INSERT INTO polubg_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Bóg powiedział też: Niech ziemia wyda istoty żywe według swego rodzaju: bydło, zwierzęta pełzające i zwierzęta ziemi według swego rodzaju. I tak się stało. ");
INSERT INTO polubg_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","I Bóg uczynił zwierzęta ziemi według swego rodzaju i bydło według swego rodzaju, i wszelkie zwierzęta, które pełzają po ziemi według swego rodzaju. I Bóg widział, że to było dobre. ");
INSERT INTO polubg_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Potem Bóg powiedział: Uczyńmy człowieka na nasz obraz według naszego podobieństwa; niech panuje nad rybami morskimi i ptactwem niebieskim, nad bydłem i całą ziemią oraz nad wszelkimi zwierzętami pełzającymi, które pełzają po ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Stworzył więc Bóg człowieka na swój obraz, na obraz Boga go stworzył; stworzył ich mężczyzną i kobietą. ");
INSERT INTO polubg_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","I Bóg błogosławił im. Potem Bóg powiedział do nich: Bądźcie płodni i rozmnażajcie się, napełniajcie ziemię i czyńcie ją sobie poddaną; panujcie nad rybami morskimi i nad ptactwem niebieskim, i nad wszelkimi zwierzętami, które poruszają się po ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","I Bóg powiedział: Oto dałem wam wszelkie rośliny wydające z siebie nasienie, które są na powierzchni całej ziemi, i wszelkie drzewo mające owoc drzewa, wydające z siebie nasienie – będą one dla was pokarmem. ");
INSERT INTO polubg_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","I wszelkim zwierzętom ziemi, i wszelkiemu ptactwu niebieskiemu, i wszystkiemu, co pełza po ziemi i ma w sobie życie, pokarmem będą wszelkie rośliny zielone. I tak się stało. ");
INSERT INTO polubg_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","I Bóg widział wszystko, co uczynił, a było to bardzo dobre. I nastał wieczór i poranek, dzień szósty. ");
INSERT INTO polubg_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Tak ukończone zostały niebiosa i ziemia oraz wszystkie ich zastępy. ");
INSERT INTO polubg_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","W siódmym dniu Bóg ukończył swe dzieło, które uczynił; i odpoczął siódmego dnia od wszelkiego swego dzieła, które stworzył. ");
INSERT INTO polubg_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","I Bóg błogosławił siódmy dzień, i poświęcił go, bo w nim odpoczął od wszelkiego swego dzieła, które Bóg stworzył i uczynił. ");
INSERT INTO polubg_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Takie są dzieje stworzenia niebios i ziemi w dniu, w którym PAN Bóg uczynił ziemię i niebiosa; ");
INSERT INTO polubg_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Wszelkie krzewy polne, zanim były na ziemi, i wszelkie rośliny polne, nim wzeszły. Bo PAN Bóg jeszcze nie spuścił deszczu na ziemię i nie było człowieka, który by uprawiał ziemię. ");
INSERT INTO polubg_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ale z ziemi wychodziła para, która nawilżała całą powierzchnię ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Wtedy PAN Bóg ukształtował człowieka z prochu ziemi i tchnął w jego nozdrza tchnienie życia. I człowiek stał się żywą duszą. ");
INSERT INTO polubg_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","PAN Bóg zasadził też ogród w Edenie, na wschodzie, i umieścił tam człowieka, którego ukształtował. ");
INSERT INTO polubg_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","I wywiódł PAN Bóg z ziemi wszelkie drzewa miłe dla oka i których owoce były dobre do jedzenia oraz drzewo życia pośrodku ogrodu i drzewo poznania dobra i zła. ");
INSERT INTO polubg_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","A z Edenu wypływała rzeka, aby nawadniać ogród; i stamtąd dzieliła się na cztery główne rzeki. ");
INSERT INTO polubg_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Nazwa pierwszej – Piszon; to ta, która okrąża całą ziemię Chawila, gdzie znajduje się złoto. ");
INSERT INTO polubg_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","A złoto tej ziemi jest wyborne. Tam też jest bdellium i kamień onyksowy. ");
INSERT INTO polubg_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Nazwa drugiej rzeki – Gichon; ta okrąża całą ziemię Kusz. ");
INSERT INTO polubg_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Nazwa zaś trzeciej rzeki – Chiddekel; płynie ona na wschód ku Asyrii. A czwarta rzeka to Eufrat. ");
INSERT INTO polubg_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","PAN Bóg wziął więc człowieka i umieścił go w ogrodzie Eden, aby go uprawiał i strzegł. ");
INSERT INTO polubg_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","I rozkazał PAN Bóg człowiekowi: Możesz jeść do woli z każdego drzewa ogrodu; ");
INSERT INTO polubg_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ale z drzewa poznania dobra i zła jeść nie będziesz, bo tego dnia, kiedy zjesz z niego, na pewno umrzesz. ");
INSERT INTO polubg_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","PAN Bóg powiedział też: Niedobrze, by człowiek był sam; uczynię mu odpowiednią dla niego pomoc. ");
INSERT INTO polubg_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","I ukształtował PAN Bóg z ziemi wszelkie zwierzęta polne i wszelkie ptactwo niebieskie, i przyprowadził je do Adama, aby zobaczyć, jak je nazwie; a jak Adam nazwał każdą istotę żywą, taka była jej nazwa. ");
INSERT INTO polubg_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","I Adam nadał nazwy wszelkiemu bydłu i ptactwu niebieskiemu, i wszelkim zwierzętom polnym. Dla Adama jednak nie znalazła się pomoc odpowiednia dla niego. ");
INSERT INTO polubg_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Wtedy PAN Bóg zesłał głęboki sen na Adama; a gdy zasnął, wyjął jedno z jego żeber i zapełnił ciałem miejsce po nim. ");
INSERT INTO polubg_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","I z tego żebra, które PAN Bóg wyjął z Adama, utworzył kobietę i przyprowadził ją do Adama. ");
INSERT INTO polubg_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","I Adam powiedział: To teraz jest kość z moich kości i ciało z mojego ciała; dlatego będzie nazwana kobietą, bo z mężczyzny została wzięta. ");
INSERT INTO polubg_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Dlatego opuści mężczyzna swojego ojca i swoją matkę i połączy się ze swoją żoną, i będą jednym ciałem. ");
INSERT INTO polubg_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","I oboje, Adam i jego żona, byli nadzy, a nie wstydzili się. ");
INSERT INTO polubg_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","A wąż był bardziej przebiegły niż wszystkie zwierzęta polne, które PAN Bóg uczynił. Powiedział on do kobiety: Czy Bóg rzeczywiście powiedział: Nie wolno wam jeść ze wszystkich drzew tego ogrodu? ");
INSERT INTO polubg_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","I kobieta odpowiedziała wężowi: Możemy jeść owoce z drzew tego ogrodu; ");
INSERT INTO polubg_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ale o owocu drzewa, które jest pośrodku ogrodu, Bóg powiedział: Nie będziecie z niego jeść ani go dotykać, abyście nie umarli. ");
INSERT INTO polubg_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","I wąż powiedział do kobiety: Na pewno nie umrzecie; ");
INSERT INTO polubg_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ale Bóg wie, że tego dnia, gdy z niego zjecie, otworzą się wasze oczy i będziecie jak bogowie znający dobro i zło. ");
INSERT INTO polubg_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","A gdy kobieta spostrzegła, że owoc drzewa był dobry do jedzenia i miły dla oka, a drzewo godne pożądania dla zdobycia wiedzy, wzięła z niego owoc i zjadła; dała też swemu mężowi, który był z nią; i on zjadł. ");
INSERT INTO polubg_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","I otworzyły się im obojgu oczy i poznali, że są nadzy. Spletli więc liście figowe i zrobili sobie przepaski. ");
INSERT INTO polubg_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Wtedy usłyszeli głos PANA Boga chodzącego po ogrodzie w powiewie dziennym. I Adam, i jego żona ukryli się przed obliczem PANA Boga wśród drzew ogrodu. ");
INSERT INTO polubg_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","I PAN Bóg zawołał na Adama, i zapytał go: Gdzie jesteś? ");
INSERT INTO polubg_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","On odpowiedział: Usłyszałem twój głos w ogrodzie i zląkłem się, gdyż jestem nagi, i ukryłem się. ");
INSERT INTO polubg_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Bóg zapytał: Kto ci powiedział, że jesteś nagi? Czy zjadłeś z drzewa, z którego zakazałem ci jeść? ");
INSERT INTO polubg_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adam odpowiedział: Kobieta, którą mi dałeś, aby była ze mną, ona dała mi z tego drzewa i zjadłem. ");
INSERT INTO polubg_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","PAN Bóg zapytał kobietę: Co zrobiłaś? I odpowiedziała kobieta: Wąż mnie zwiódł i zjadłam. ");
INSERT INTO polubg_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Wtedy PAN Bóg powiedział do węża: Ponieważ to uczyniłeś, będziesz przeklęty wśród wszelkiego bydła i wśród wszelkich zwierząt polnych. Na brzuchu będziesz się czołgać i proch będziesz jeść po wszystkie dni swego życia. ");
INSERT INTO polubg_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","I wprowadzę nieprzyjaźń między tobą a kobietą, między twoim potomstwem a jej potomstwem. Ono zrani ci głowę, a ty zranisz mu piętę. ");
INSERT INTO polubg_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","A do kobiety powiedział: Wielce pomnożę twoje cierpienia i twoje poczęcia, w bólu będziesz rodzić dzieci. Twoje pragnienie będzie ku twemu mężowi, a on będzie nad tobą panować. ");
INSERT INTO polubg_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Do Adama zaś powiedział: Ponieważ usłuchałeś głosu swojej żony i zjadłeś z drzewa, o którym ci przykazałem, mówiąc: Nie będziesz z niego jadł – przeklęta będzie ziemia z twego powodu, w trudzie będziesz z niej spożywać po wszystkie dni twego życia. ");
INSERT INTO polubg_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ona będzie ci rodzić ciernie i oset i będziesz spożywał rośliny polne. ");
INSERT INTO polubg_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","W pocie czoła będziesz spożywał chleb, aż wrócisz do ziemi, gdyż z niej zostałeś wzięty. Bo jesteś prochem i w proch się obrócisz. ");
INSERT INTO polubg_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","I Adam nadał swojej żonie imię Ewa, bo ona była matką wszystkich żyjących. ");
INSERT INTO polubg_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","I PAN Bóg sporządził dla Adama i jego żony odzienie ze skór i przyodział ich. ");
INSERT INTO polubg_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Wtedy PAN Bóg powiedział: Oto człowiek stał się jak jeden z nas, znający dobro i zło. Wygnajmy go więc, aby nie wyciągnął swej ręki i nie wziął z drzewa życia, by jeść i żyć na wieki. ");
INSERT INTO polubg_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","PAN Bóg wydalił go więc z ogrodu Eden, aby uprawiał ziemię, z której został wzięty. ");
INSERT INTO polubg_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Tak wygnał człowieka i postawił na wschód od ogrodu Eden cherubinów i płomienisty miecz obracający się we wszystkie strony, aby strzegły drogi do drzewa życia. ");
INSERT INTO polubg_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Potem Adam obcował ze swoją żoną Ewą, a ta poczęła i urodziła Kaina. I powiedziała: Otrzymałam mężczyznę od PANA. ");
INSERT INTO polubg_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","I urodziła jeszcze jego brata Abla. Abel był pasterzem owiec, a Kain był rolnikiem. ");
INSERT INTO polubg_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Z biegiem czasu zdarzyło się, że Kain przyniósł PANU ofiarę z plonów ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Także Abel przyniósł z pierworodnych swej trzody i z ich tłuszczu. A PAN wejrzał na Abla i jego ofiarę. ");
INSERT INTO polubg_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Lecz na Kaina i jego ofiarę nie wejrzał. Kain rozgniewał się bardzo i spochmurniała jego twarz. ");
INSERT INTO polubg_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Wtedy PAN zapytał Kaina: Dlaczego się rozgniewałeś? Czemu spochmurniała twoja twarz? ");
INSERT INTO polubg_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Jeśli będziesz dobrze czynił, czy nie zostaniesz wywyższony? A jeśli nie będziesz dobrze czynił, grzech leży u drzwi; a do ciebie będzie jego pragnienie, a ty będziesz nad nim panować. ");
INSERT INTO polubg_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","I Kain rozmawiał ze swoim bratem Ablem. A gdy byli na polu, Kain powstał przeciwko swemu bratu Ablowi i zabił go. ");
INSERT INTO polubg_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Wtedy PAN zapytał Kaina: Gdzie jest twój brat Abel? On odpowiedział: Nie wiem. Czy ja jestem stróżem mego brata? ");
INSERT INTO polubg_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Bóg zapytał: Cóż uczyniłeś? Głos krwi twego brata woła do mnie z ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Teraz więc przeklęty będziesz na ziemi, która otworzyła swe usta, aby przyjąć krew twego brata przelaną przez twoją rękę. ");
INSERT INTO polubg_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Gdy będziesz uprawiał ziemię, nie da ci już swego plonu. Tułaczem i zbiegiem będziesz na ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Wtedy Kain powiedział do PANA: Zbyt ciężka jest moja kara, bym mógł ją znieść. ");
INSERT INTO polubg_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Oto wyganiasz mnie dziś z powierzchni ziemi, a przed twoją twarzą będę ukryty. Będę tułaczem i zbiegiem na ziemi, a stanie się tak, że ktokolwiek mnie spotka, zabije mnie. ");
INSERT INTO polubg_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","PAN mu odpowiedział: Zaprawdę, ktokolwiek zabije Kaina, poniesie siedmiokrotną zemstę. I nałożył PAN na Kaina piętno, aby nie zabił go nikt, kto by go spotkał. ");
INSERT INTO polubg_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Wtedy odszedł Kain sprzed oblicza PANA i zamieszkał w ziemi Nod, na wschód od Edenu. ");
INSERT INTO polubg_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","I Kain obcował ze swoją żoną, a ona poczęła i urodziła Henocha. Zbudował też miasto i nazwał je imieniem swego syna – Henoch. ");
INSERT INTO polubg_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henochowi urodził się Irad, a Irad spłodził Mechujaela, a Mechujael spłodził Matuszaela, a Matuszael spłodził Lameka. ");
INSERT INTO polubg_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","I Lamek pojął sobie dwie żony. Imię jednej było Ada, a drugiej – Silla. ");
INSERT INTO polubg_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada urodziła Jabala, który był ojcem mieszkających w namiotach i pasterzy. ");
INSERT INTO polubg_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jego brat miał na imię Jubal, a był on ojcem wszystkich grających na harfie i na flecie. ");
INSERT INTO polubg_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silla urodziła Tubalkaina, który był rzemieślnikiem wszelkiej roboty od miedzi i żelaza. Siostrą Tubalkaina była Noema. ");
INSERT INTO polubg_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","I Lamek powiedział swym żonom, Adzie i Silli: Słuchajcie mego głosu, żony Lameka, posłuchajcie moich słów; zabiłem mężczyznę za zranienie mnie i młodzieńca za siniec. ");
INSERT INTO polubg_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Jeśli Kain ma być pomszczony siedem razy, to Lamek siedemdziesiąt siedem razy. ");
INSERT INTO polubg_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","I Adam znów obcował ze swoją żoną, a ona urodziła syna i nadała mu imię Set, mówiąc: Dał mi Bóg inne potomstwo za Abla, którego zabił Kain. ");
INSERT INTO polubg_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Setowi też urodził się syn i nadał mu imię Enosz. Wtedy zaczęto wzywać imienia PANA. ");
INSERT INTO polubg_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","To jest księga rodu Adama. W dniu, w którym Bóg stworzył człowieka, uczynił go na podobieństwo Boga. ");
INSERT INTO polubg_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Stworzył ich mężczyzną i kobietą; błogosławił ich i nadał im imię Adam w dniu, w którym zostali stworzeni. ");
INSERT INTO polubg_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam żył sto trzydzieści lat i spłodził syna na swoje podobieństwo, na swój obraz, i nadał mu imię Set. ");
INSERT INTO polubg_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","A dni Adama po spłodzeniu Seta było osiemset lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","A tak wszystkich dni, które żył Adam, było dziewięćset trzydzieści lat i umarł. ");
INSERT INTO polubg_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set żył sto pięć lat i spłodził Enosza. ");
INSERT INTO polubg_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Po spłodzeniu Enosza Set żył osiemset siedem lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Wszystkich dni Seta było dziewięćset dwanaście lat i umarł. ");
INSERT INTO polubg_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosz żył dziewięćdziesiąt lat i spłodził Kenana. ");
INSERT INTO polubg_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Po spłodzeniu Kenana Enosz żył osiemset piętnaście lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Wszystkich dni Enosza było dziewięćset pięć lat i umarł. ");
INSERT INTO polubg_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan żył siedemdziesiąt lat i spłodził Mahalaleela. ");
INSERT INTO polubg_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Po spłodzeniu Mahalaleela Kenan żył osiemset czterdzieści lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Wszystkich dni Kenana było dziewięćset dziesięć lat i umarł. ");
INSERT INTO polubg_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleel żył sześćdziesiąt pięć lat i spłodził Jareda. ");
INSERT INTO polubg_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Po spłodzeniu Jareda Mahalaleel żył osiemset trzydzieści lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Wszystkich dni Mahalaleela było osiemset dziewięćdziesiąt pięć lat i umarł. ");
INSERT INTO polubg_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared żył sto sześćdziesiąt dwa lata i spłodził Henocha. ");
INSERT INTO polubg_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Po spłodzeniu Henocha Jared żył osiemset lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Wszystkich dni Jareda było dziewięćset sześćdziesiąt dwa lata i umarł. ");
INSERT INTO polubg_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henoch żył sześćdziesiąt pięć lat i spłodził Matuzalema. ");
INSERT INTO polubg_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Po spłodzeniu Matuzalema Henoch chodził z Bogiem trzysta lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Wszystkich dni Henocha było trzysta sześćdziesiąt pięć lat. ");
INSERT INTO polubg_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henoch chodził z Bogiem, a potem już go nie było, bo Bóg go zabrał. ");
INSERT INTO polubg_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matuzalem żył sto osiemdziesiąt siedem lat i spłodził Lameka. ");
INSERT INTO polubg_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Po spłodzeniu Lameka Matuzalem żył siedemset osiemdziesiąt dwa lata i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Wszystkich dni Matuzalema było dziewięćset sześćdziesiąt dziewięć lat i umarł. ");
INSERT INTO polubg_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek żył sto osiemdziesiąt dwa lata i spłodził syna. ");
INSERT INTO polubg_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","I nadał mu imię Noe, mówiąc: Ten nas pocieszy w naszej pracy i w trudzie naszych rąk, z powodu ziemi, którą PAN przeklął. ");
INSERT INTO polubg_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Po spłodzeniu Noego Lamek żył pięćset dziewięćdziesiąt pięć lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Wszystkich dni Lameka było siedemset siedemdziesiąt siedem lat i umarł. ");
INSERT INTO polubg_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","A gdy Noe miał pięćset lat, spłodził Sema, Chama i Jafeta. ");
INSERT INTO polubg_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Gdy ludzie zaczęli się mnożyć na ziemi i rodziły im się córki; ");
INSERT INTO polubg_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Synowie Boży, widząc, że córki ludzkie były piękne, brali sobie za żony wszystkie, które sobie upodobali. ");
INSERT INTO polubg_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","I powiedział PAN: Mój duch nie będzie na zawsze się spierał z człowiekiem, bo jest on ciałem. Będzie więc jego dni sto dwadzieścia lat. ");
INSERT INTO polubg_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","A w tych dniach byli na ziemi olbrzymi; nawet i potem, gdy synowie Boży zbliżali się do córek ludzkich, a one rodziły im synów. To są mocarze, którzy od dawna byli sławnymi mężczyznami. ");
INSERT INTO polubg_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","A gdy PAN widział, że wielka jest niegodziwość ludzi na ziemi i wszystkie zamysły i myśli ich serca były tylko złe po wszystkie dni; ");
INSERT INTO polubg_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Żałował PAN, że uczynił człowieka na ziemi, i ubolewał nad tym całym sercem. ");
INSERT INTO polubg_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","I PAN powiedział: Zgładzę z powierzchni ziemi człowieka, którego stworzyłem, zarówno człowieka, jak i bydło, zwierzęta pełzające i ptactwo niebieskie, bo żałuję, że ich uczyniłem. ");
INSERT INTO polubg_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ale Noe znalazł łaskę w oczach PANA. ");
INSERT INTO polubg_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","To są dzieje rodu Noego: Noe był człowiekiem sprawiedliwym i doskonałym w swoich czasach. I Noe chodził z Bogiem. ");
INSERT INTO polubg_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","A Noe spłodził trzech synów: Sema, Chama i Jafeta. ");
INSERT INTO polubg_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ale ziemia zepsuła się w oczach Boga i napełniła się nieprawością. ");
INSERT INTO polubg_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Wtedy Bóg wejrzał na ziemię, a oto była zepsuta, bo wszelkie ciało wypaczyło swoją drogę na ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","I Bóg powiedział do Noego: Nadszedł koniec wszelkiego ciała przed moim obliczem, bo ziemia przez nie jest pełna nieprawości; wytracę je więc wraz z ziemią. ");
INSERT INTO polubg_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Zbuduj sobie arkę z drewna gofer, zrobisz w arce przegrody i oblejesz ją wewnątrz i na zewnątrz smołą. ");
INSERT INTO polubg_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","A zbudujesz ją w ten sposób: Długość arki będzie na trzysta łokci, pięćdziesiąt łokci – jej szerokość, a trzydzieści łokci – jej wysokość. ");
INSERT INTO polubg_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Zrobisz okno w arce, a zakończysz je na łokieć od góry. Drzwi umieścisz z boku arki, zrobisz w niej dolne, drugie i trzecie piętro. ");
INSERT INTO polubg_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","A ja, oto ja sprowadzę potop wód na ziemię, aby wytracić wszelkie ciało, w którym jest tchnienie życia pod niebem. Wszystko, co jest na ziemi, zginie. ");
INSERT INTO polubg_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ale z tobą zawrę moje przymierze; i wejdziesz do arki, ty i twoi synowie, i twoja żona, i żony twoich synów z tobą. ");
INSERT INTO polubg_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","I ze wszystkich zwierząt wszelkiego ciała po jednej parze wprowadzisz do arki, aby uchowały się z tobą żywe, będą to samiec i samica. ");
INSERT INTO polubg_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Z ptactwa według jego rodzaju i z bydła według jego rodzaju, i z wszelkich ziemskich zwierząt pełzających według ich rodzaju, po parze z każdego rodzaju wejdą z tobą, aby żywe zostały. ");
INSERT INTO polubg_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","A ty weźmiesz ze sobą wszelki pokarm, który się nadaje do jedzenia, i zabierzesz do siebie, i będzie tobie i im na pokarm. ");
INSERT INTO polubg_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","I Noe tak uczynił. Zrobił wszystko tak, jak mu Bóg rozkazał. ");
INSERT INTO polubg_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Potem PAN powiedział do Noego: Wejdź ty wraz z całym twoim domem do arki, gdyż widziałem cię, że jesteś sprawiedliwy przede mną w tym pokoleniu. ");
INSERT INTO polubg_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Z każdego zwierzęcia czystego weź sobie po siedem par, samca i samicę jego; ale ze zwierząt nieczystych – po jednej parze, samca i samicę jego. ");
INSERT INTO polubg_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Także z ptactwa niebieskiego po siedem par, samca i samicę, aby zachować przy życiu ich potomstwo na całej powierzchni ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pozostaje bowiem jeszcze siedem dni, a potem spuszczę deszcz na ziemię, na czterdzieści dni i czterdzieści nocy, i zgładzę z powierzchni ziemi wszelkie stworzenie, które uczyniłem. ");
INSERT INTO polubg_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noe uczynił więc wszystko, co mu PAN rozkazał. ");
INSERT INTO polubg_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noe miał sześćset lat, gdy przyszedł potop wód na ziemię. ");
INSERT INTO polubg_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","I wszedł Noe, a z nim jego synowie, jego żona i żony jego synów do arki ze względu na wody potopu. ");
INSERT INTO polubg_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ze zwierząt czystych i nieczystych i z ptactwa, i ze wszystkiego, co pełza po ziemi; ");
INSERT INTO polubg_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Po parze weszło do Noego do arki, samiec i samica, jak Bóg rozkazał Noemu. ");
INSERT INTO polubg_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","A po siedmiu dniach wody potopu spadły na ziemię. ");
INSERT INTO polubg_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","W sześćsetnym roku życia Noego, w drugim miesiącu, siedemnastego dnia tego miesiąca, w tym właśnie dniu, przerwały się wszystkie źródła wielkiej głębi i otworzyły się okna nieba. ");
INSERT INTO polubg_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","I deszcz padał na ziemię czterdzieści dni i czterdzieści nocy. ");
INSERT INTO polubg_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","W tym właśnie dniu weszli do arki Noe oraz jego synowie – Sem, Cham i Jafet, a z nimi żona Noego i trzy żony jego synów. ");
INSERT INTO polubg_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Oni i wszelkie zwierzęta według swego rodzaju, wszelkie bydło według swego rodzaju, wszelkie zwierzęta pełzające, które pełzają po ziemi według swego rodzaju, wszelkie ptaki według swego rodzaju i wszelkie stworzenia skrzydlate. ");
INSERT INTO polubg_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","I tak weszły do Noego do arki, po parze z każdego ciała, w którym było tchnienie życia. ");
INSERT INTO polubg_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","A te, które weszły, samiec i samica z każdego ciała weszły, jak mu Bóg rozkazał. I zamknął PAN za nim drzwi. ");
INSERT INTO polubg_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","A potop trwał na ziemi czterdzieści dni i wody wezbrały, i podniosły arkę, i unosiła się nad ziemią. ");
INSERT INTO polubg_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Wody wzmogły się i wezbrały bardzo nad ziemią, i pływała arka po wodach. ");
INSERT INTO polubg_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","I wody bardzo się wzmogły nad ziemią, i zakryły wszystkie wysokie góry, które były pod całym niebem. ");
INSERT INTO polubg_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Wody wezbrały na piętnaście łokci wzwyż i góry zostały zakryte. ");
INSERT INTO polubg_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Zginęło więc wszelkie ciało poruszające się na ziemi: ptactwo, bydło, zwierzęta i wszelkie zwierzęta pełzające, które pełzają po ziemi, i wszyscy ludzie. ");
INSERT INTO polubg_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Wszystko, co miało w nozdrzach tchnienie życia, wszystko, co żyło na suchym lądzie, zginęło. ");
INSERT INTO polubg_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Tak zostało zgładzone wszelkie stworzenie, które było na powierzchni ziemi, od człowieka aż do bydła, zwierząt pełzających i ptactwa niebieskiego. Wszystko to zostało zgładzone z ziemi. Pozostał tylko Noe i ci, którzy z nim byli w arce. ");
INSERT INTO polubg_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","A wody wezbrały nad ziemią sto pięćdziesiąt dni. ");
INSERT INTO polubg_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Bóg pamiętał jednak o Noem i wszystkich zwierzętach, i wszelkim bydle, które było z nim w arce, i sprowadził Bóg wiatr na ziemię, a wody zaczęły opadać. ");
INSERT INTO polubg_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","I źródła głębi i okna nieba zamknęły się, i deszcz z nieba został zatrzymany. ");
INSERT INTO polubg_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Wody stopniowo ustępowały z powierzchni ziemi, a po upływie stu pięćdziesięciu dni wody opadły. ");
INSERT INTO polubg_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","I arka osiadła na górach Ararat w siódmym miesiącu, siedemnastego dnia tego miesiąca. ");
INSERT INTO polubg_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","A wody opadały nadal aż do dziesiątego miesiąca. I w dziesiątym miesiącu, pierwszego dnia, ukazały się szczyty gór. ");
INSERT INTO polubg_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Po upływie czterdziestu dni Noe otworzył okno arki, które zrobił. ");
INSERT INTO polubg_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","I wypuścił kruka, który wylatywał i wracał, aż wyschły wody na ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Potem wypuścił gołębicę, aby zobaczyć, czy wody opadły z powierzchni ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","A gdy gołębica nie znalazła dla siebie miejsca spoczynku, wróciła do niego do arki, bo wody były jeszcze na całej powierzchni ziemi. Wyciągnął więc swoją rękę, pochwycił ją i wziął do siebie do arki. ");
INSERT INTO polubg_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","A gdy odczekał jeszcze drugie siedem dni, ponownie wypuścił gołębicę z arki. ");
INSERT INTO polubg_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","I gołębica wróciła do niego pod wieczór, a oto w dziobie zerwany liść oliwny. Tak Noe poznał, że wody opadły z powierzchni ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Odczekał jeszcze drugie siedem dni i wypuścił gołębicę, ale już do niego nie wróciła. ");
INSERT INTO polubg_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","W sześćset pierwszym roku, w pierwszym miesiącu, pierwszego dnia, wyschły wody na ziemi. Wtedy Noe zdjął przykrycie arki i zobaczył, że powierzchnia ziemi była sucha. ");
INSERT INTO polubg_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","A w drugim miesiącu, dwudziestego siódmego dnia tego miesiąca, wyschła ziemia. ");
INSERT INTO polubg_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","I Bóg powiedział do Noego: ");
INSERT INTO polubg_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Wyjdź z arki, ty i z tobą twoja żona, twoi synowie i żony twoich synów. ");
INSERT INTO polubg_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Wyprowadź ze sobą wszystkie zwierzęta, które są z tobą, z wszelkiego ciała, ptactwa, bydła i wszelkich zwierząt pełzających, które pełzają po ziemi, i niech się rozrodzą na ziemi, niech będą płodne i niech się rozmnażają na ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Wyszedł więc Noe i z nim jego synowie, jego żona i żony jego synów. ");
INSERT INTO polubg_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Wyszły także z arki wszelkie bydlęta, wszelkie zwierzęta pełzające, wszelkie ptactwo oraz wszystko, co pełza po ziemi, według swoich rodzajów. ");
INSERT INTO polubg_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Potem Noe zbudował ołtarz dla PANA i wziął z każdego czystego zwierzęcia i z każdego czystego ptactwa, i złożył całopalenia na tym ołtarzu. ");
INSERT INTO polubg_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","I PAN poczuł miłą woń, i PAN powiedział w swoim sercu: Nie będę więcej przeklinał ziemi z powodu człowieka, bo myśl serca człowieka jest zła od jego młodości. Nie wytracę więcej wszystkiego, co żyje, jak teraz uczyniłem. ");
INSERT INTO polubg_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Póki ziemia będzie trwać, nie ustaną siew i żniwo, zimno i gorąco, lato i zima, dzień i noc. ");
INSERT INTO polubg_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","I Bóg błogosławił Noego i jego synów, i powiedział im: Bądźcie płodni i rozmnażajcie się, i napełniajcie ziemię. ");
INSERT INTO polubg_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","A strach i lęk przed wami będzie nad wszelkim zwierzęciem ziemi, nad wszelkim ptactwem nieba, nad wszystkim, co się porusza na ziemi, i nad wszelkimi rybami morza; oddane są w wasze ręce. ");
INSERT INTO polubg_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Wszystko, co się porusza i żyje, będzie dla was pokarmem, podobnie jak rośliny zielone, daję wam to wszystko. ");
INSERT INTO polubg_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Lecz nie będziecie jeść mięsa z jego życiem, to jest z jego krwią. ");
INSERT INTO polubg_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","A ja będę żądał waszej krwi, to jest waszego życia; od każdego zwierzęcia będę jej żądał, jak i od ręki człowieka; od ręki każdego brata jego będę żądał życia człowieka. ");
INSERT INTO polubg_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kto przeleje krew człowieka, przez człowieka będzie przelana jego krew, bo na obraz Boga człowiek został stworzony. ");
INSERT INTO polubg_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Wy zaś bądźcie płodni i rozmnażajcie się; rozradzajcie się na ziemi i rozmnażajcie się na niej. ");
INSERT INTO polubg_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Potem Bóg powiedział do Noego i do jego synów z nim: ");
INSERT INTO polubg_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","A ja, oto ja ustanawiam moje przymierze z wami i z waszym potomstwem po was; ");
INSERT INTO polubg_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","I z wszelką żywą istotą, która jest z wami, z ptactwem, bydłem oraz z wszelkim zwierzęciem ziemi, które jest z wami, od wszystkich, które wyszły z arki, aż do każdego zwierzęcia ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ustanowię moje przymierze z wami. Nie będzie już więcej zgładzone wszelkie ciało wodami potopu ani nie będzie już więcej potopu, który miałby zniszczyć ziemię. ");
INSERT INTO polubg_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","I Bóg powiedział: To jest znak przymierza, które ja ustanawiam między mną a wami i między wszelką żywą istotą, która jest z wami, na wieczne pokolenia. ");
INSERT INTO polubg_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Kładę na obłoku mój łuk, który będzie na znak przymierza między mną a ziemią. ");
INSERT INTO polubg_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","I stanie się, gdy wzbudzę obłok nad ziemią, że ukaże się łuk na obłoku; ");
INSERT INTO polubg_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","I wspomnę na moje przymierze, które jest między mną a wami oraz wszelką żywą istotą cielesną. Nie będzie już więcej wód potopu, który miałby zniszczyć wszelkie ciało. ");
INSERT INTO polubg_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Będzie więc ten łuk na obłoku i spojrzę na niego, aby przypomnieć sobie wieczne przymierze między Bogiem a wszelką żywą istotą cielesną, która jest na ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","I Bóg powiedział do Noego: To jest znak przymierza, które ustanowiłem między mną a wszelkim ciałem, które jest na ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","A synami Noego, którzy wyszli z arki, byli: Sem, Cham i Jafet. Cham jest ojcem Kanaana. ");
INSERT INTO polubg_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","To są trzej synowie Noego, przez których napełniła się ludem cała ziemia. ");
INSERT INTO polubg_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Wtedy Noe zaczął uprawiać ziemię i zasadził winnicę. ");
INSERT INTO polubg_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Potem pił wino i upił się; i leżał odkryty w swoim namiocie. ");
INSERT INTO polubg_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","A Cham, ojciec Kanaana, zobaczył nagość swego ojca i opowiedział o tym dwom swoim braciom na dworze. ");
INSERT INTO polubg_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Wtedy Sem i Jafet wzięli szatę, założyli ją sobie na ramiona, weszli tyłem i zakryli nagość swego ojca; a ich twarze były odwrócone, tak że nie widzieli nagości swego ojca. ");
INSERT INTO polubg_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","A gdy Noe obudził się po winie, dowiedział się, co mu zrobił jego młodszy syn; ");
INSERT INTO polubg_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","I powiedział: Niech będzie przeklęty Kanaan, będzie sługą sług swoich braci. ");
INSERT INTO polubg_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Potem dodał: Niech będzie błogosławiony PAN Bóg Sema, a niech Kanaan będzie jego sługą. ");
INSERT INTO polubg_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Niech Bóg rozprzestrzeni Jafeta i niech mieszka on w namiotach Sema, a niech będzie Kanaan jego sługą. ");
INSERT INTO polubg_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","I Noe żył po potopie trzysta pięćdziesiąt lat. ");
INSERT INTO polubg_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","I wszystkich dni Noego było dziewięćset pięćdziesiąt lat i umarł. ");
INSERT INTO polubg_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Oto dzieje rodu synów Noego: Sema, Chama i Jafeta, którym po potopie urodzili się synowie. ");
INSERT INTO polubg_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Synowie Jafeta: Gomer, Magog, Madaj, Jawan, Tubal, Meszek i Tiras. ");
INSERT INTO polubg_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Synowie Gomera: Aszkenaz, Rifat i Togarma. ");
INSERT INTO polubg_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Synowie Jawana: Elisza, Tarszisz, Kittim i Dodanim. ");
INSERT INTO polubg_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Od nich rozdzielone zostały wyspy narodów po swych ziemiach; każdy według swojego języka i według swoich rodów, w swoich narodach. ");
INSERT INTO polubg_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","A synowie Chama: Kusz, Misraim, Put i Kanaan. ");
INSERT INTO polubg_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Synowie zaś Kusza: Seba, Chawila, Sabta, Rama i Sabteka. Synowie Ramy: Szeba i Dedan. ");
INSERT INTO polubg_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusz spłodził Nimroda, który zaczął być mocarzem na ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ten był mocarnym myśliwym przed PANEM. Dlatego mówi się: Tak jak Nimrod, mocarny myśliwy przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Początkiem jego królestwa były Babel, Erek, Akkad i Kalne w ziemi Szinear. ");
INSERT INTO polubg_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Z tej ziemi wyszedł Assur i zbudował Niniwę i miasto Rechobot, i Kalach. ");
INSERT INTO polubg_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Także wielkie miasto Resan pomiędzy Niniwą i Kalach. ");
INSERT INTO polubg_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim zaś spłodził Ludima, Ananima, Lahabima i Naftuchima; ");
INSERT INTO polubg_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Oraz Patrusyma, Kasluchima (z których pochodzą Filistyni) i Kaftoryma. ");
INSERT INTO polubg_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan zaś spłodził Sydona, swego pierworodnego, i Cheta; ");
INSERT INTO polubg_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","I Jebusytów, Amorytów, i Girgaszytów; ");
INSERT INTO polubg_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","I Chiwwitów, Arkitów, i Sinitów; ");
INSERT INTO polubg_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","I Arwadytów, Semarytów, i Chamatytów. A potem rozproszyły się rody Kananejczyków. ");
INSERT INTO polubg_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","A granica Kananejczyków biegła od Sydonu w kierunku Gerary aż do Gazy, w kierunku Sodomy i Gomory, Adamy i Seboima aż do Leszy. ");
INSERT INTO polubg_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","To są synowie Chama według ich rodów i języków, w ich ziemiach i narodach. ");
INSERT INTO polubg_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","A Semowi, ojcu wszystkich synów Ebera, bratu Jafeta, który był starszy, urodzili się synowie. ");
INSERT INTO polubg_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Synowie Sema: Elam, Assur, Arpachszad, Lud i Aram. ");
INSERT INTO polubg_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Synowie Arama: Us, Chul, Geter i Masz. ");
INSERT INTO polubg_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpachszad zaś spłodził Szelacha, a Szelach spłodził Ebera. ");
INSERT INTO polubg_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberowi urodzili się dwaj synowie: imię jednego – Peleg, gdyż za jego dni ziemia została rozdzielona; a imię jego brata – Joktan. ");
INSERT INTO polubg_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan spłodził Almodada, Szelefa, Chasarmaweta i Jeracha; ");
INSERT INTO polubg_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadorama, Uzala i Diklę; ");
INSERT INTO polubg_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obala, Abimaela i Szeba; ");
INSERT INTO polubg_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofira, Chawilę i Jobaba; ci wszyscy byli synami Joktana. ");
INSERT INTO polubg_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","A obszar ich zamieszkania ciągnął się od Meszy w kierunku Sefar, wschodniej góry. ");
INSERT INTO polubg_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","To są synowie Sema według ich rodów i języków, w ich ziemiach i narodach. ");
INSERT INTO polubg_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","To są rody synów Noego według ich pokoleń i w ich narodach. Od nich wywodzą się narody, które rozprzestrzeniły się na ziemi po potopie. ");
INSERT INTO polubg_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Na całej ziemi był jeden język i jedna mowa. ");
INSERT INTO polubg_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","A gdy wędrowali od wschodu, znaleźli równinę w ziemi Szinear i tam mieszkali. ");
INSERT INTO polubg_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","I mówili jeden do drugiego: Chodźcie, zróbmy cegły i wypalmy je w ogniu; i mieli cegłę zamiast kamienia, a smołę zamiast zaprawy. ");
INSERT INTO polubg_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Potem powiedzieli: Chodźcie, zbudujmy sobie miasto i wieżę, której szczyt sięgałby do nieba, i uczyńmy sobie imię, abyśmy się nie rozproszyli po powierzchni całej ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","A PAN zstąpił, aby zobaczyć miasto i wieżę, które synowie ludzcy budowali. ");
INSERT INTO polubg_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","I PAN powiedział: Oto lud jest jeden i wszyscy mają jeden język, a jest to dopiero początek ich dzieła. Teraz nic nie powstrzyma ich od wykonania tego, co zamierzają uczynić. ");
INSERT INTO polubg_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Zstąpmy więc i pomieszajmy tam ich język, aby jeden nie zrozumiał języka drugiego. ");
INSERT INTO polubg_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","I tak PAN rozproszył ich stamtąd po całej powierzchni ziemi; i przestali budować miasto. ");
INSERT INTO polubg_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Dlatego nazwano je Babel, bo tam PAN pomieszał język całej ziemi. I stamtąd PAN rozproszył ich po całej powierzchni ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","To są dzieje rodu Sema: Gdy Sem miał sto lat, spłodził Arpachszada, dwa lata po potopie. ");
INSERT INTO polubg_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Po spłodzeniu Arpachszada Sem żył pięćset lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpachszad żył trzydzieści pięć lat i spłodził Szelacha. ");
INSERT INTO polubg_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Po spłodzeniu Szelacha Arpachszad żył czterysta trzy lata i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Szelach żył trzydzieści lat i spłodził Ebera. ");
INSERT INTO polubg_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Po spłodzeniu Ebera Szelach żył czterysta trzy lata i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber żył trzydzieści cztery lata i spłodził Pelega. ");
INSERT INTO polubg_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Po spłodzeniu Pelega Eber żył czterysta trzydzieści lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg żył trzydzieści lat i spłodził Reu. ");
INSERT INTO polubg_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Po spłodzeniu Reu Peleg żył dwieście dziewięć lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu żył trzydzieści dwa lata i spłodził Seruga. ");
INSERT INTO polubg_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Po spłodzeniu Seruga Reu żył dwieście siedem lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug żył trzydzieści lat i spłodził Nachora. ");
INSERT INTO polubg_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Po spłodzeniu Nachora Serug żył dwieście lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nachor żył dwadzieścia dziewięć lat i spłodził Teracha. ");
INSERT INTO polubg_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Po spłodzeniu Teracha Nachor żył sto dziewiętnaście lat i spłodził synów i córki. ");
INSERT INTO polubg_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terach żył siedemdziesiąt lat i spłodził Abrama, Nachora i Harana. ");
INSERT INTO polubg_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","A to są rody Teracha: Terach spłodził Abrama, Nachora i Harana. Haran zaś spłodził Lota. ");
INSERT INTO polubg_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","I Haran umarł za życia swego ojca Teracha w ziemi swego urodzenia, w Ur chaldejskim. ");
INSERT INTO polubg_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","I Abram, i Nachor pojęli sobie żony: imię żony Abrama było Saraj, a imię żony Nachora – Milka. Była ona córką Harana, ojca Milki i Jeski. ");
INSERT INTO polubg_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","A Saraj była niepłodna, nie miała dzieci. ");
INSERT INTO polubg_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","I Terach wziął swego syna Abrama i swego wnuka Lota, syna Harana, i swoją synową Saraj, żonę swego syna Abrama; i wyruszyli razem z Ur chaldejskiego, aby udać się do ziemi Kanaan. Gdy przybyli do Charanu, zamieszkali tam. ");
INSERT INTO polubg_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","I dni Teracha było dwieście pięć lat, i umarł w Charanie. ");
INSERT INTO polubg_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","I PAN powiedział do Abrama: Wyjdź z twojej ziemi i od twojej rodziny, i z domu twego ojca do ziemi, którą ci pokażę. ");
INSERT INTO polubg_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","A uczynię z ciebie wielki naród, będę ci błogosławił i rozsławię twoje imię, i będziesz błogosławieństwem. ");
INSERT INTO polubg_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","I będę błogosławił tym, którzy tobie będą błogosławić; a tych, którzy przeklinają ciebie, będę przeklinać. W tobie będą błogosławione wszystkie narody ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Wyszedł więc Abram, jak mu PAN rozkazał, poszedł z nim też Lot. Abram miał siedemdziesiąt pięć lat, gdy wyszedł z Charanu. ");
INSERT INTO polubg_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","I Abram wziął swoją żonę Saraj, Lota, syna brata swego, i cały dobytek, który zgromadzili, i dusze, które nabyli w Charanie, i wyszli, aby udać się do ziemi Kanaan; i przybyli do ziemi Kanaan. ");
INSERT INTO polubg_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram przeszedł tę ziemię aż do miejsca Sychem, do równiny More. Na tej ziemi byli wówczas Kananejczycy. ");
INSERT INTO polubg_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","I PAN ukazał się Abramowi, i powiedział: Twemu potomstwu dam tę ziemię. I Abram zbudował tam ołtarz dla PANA, który mu się ukazał. ");
INSERT INTO polubg_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","A stamtąd przeniósł się do góry na wschód od Betel i tam rozbił swój namiot między Betel od zachodu i Aj od wschodu. Tam również zbudował ołtarz dla PANA i wzywał imienia PANA. ");
INSERT INTO polubg_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Potem Abram wyruszył, idąc ku południu. ");
INSERT INTO polubg_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","A nastał głód na tej ziemi. Abram zstąpił więc do Egiptu, aby tam gościć; ciężki bowiem był głód na ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","A gdy zbliżał się do Egiptu, powiedział do swej żony Saraj: Oto wiem, że jesteś piękną kobietą. ");
INSERT INTO polubg_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Gdy Egipcjanie cię zobaczą, powiedzą: To jego żona; i zabiją mnie, a ciebie zostawią przy życiu. ");
INSERT INTO polubg_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Mów, proszę, że jesteś moją siostrą, aby mi się dobrze wiodło ze względu na ciebie i abym dzięki tobie pozostał przy życiu. ");
INSERT INTO polubg_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Gdy Abram wszedł do Egiptu, Egipcjanie zobaczyli, że ta kobieta jest bardzo piękna. ");
INSERT INTO polubg_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ujrzeli ją też dostojnicy faraona i chwalili ją przed nim. I zabrano tę kobietę do domu faraona. ");
INSERT INTO polubg_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ten dobrze traktował Abrama ze względu na nią. Abram miał więc owce, woły, osły, służących i służące, oślice i wielbłądy. ");
INSERT INTO polubg_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","PAN jednak dotknął faraona i jego dom wielkimi plagami z powodu Saraj, żony Abrama. ");
INSERT INTO polubg_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Faraon wezwał więc Abrama i powiedział: Coś ty mi zrobił? Czemu mi nie powiedziałeś, że ona jest twoją żoną? ");
INSERT INTO polubg_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Dlaczego mówiłeś: Ona jest moją siostrą, tak że mogłem ją wziąć sobie za żonę? A teraz – oto twoja żona, weź ją i idź. ");
INSERT INTO polubg_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","I faraon rozkazał o nim swoim ludziom, i odprawili go wraz z żoną i wszystkim, co było jego. ");
INSERT INTO polubg_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Tak więc Abram wyszedł z Egiptu, on i jego żona, i wszystko, co miał, i Lot z nim, i udali się ku południu. ");
INSERT INTO polubg_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","A Abram był bardzo bogaty w bydło, srebro i złoto. ");
INSERT INTO polubg_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","I szedł, robiąc postoje, od południa aż do Betel, do tego miejsca, gdzie poprzednio był jego namiot, między Betel a Aj; ");
INSERT INTO polubg_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Do miejsca, gdzie poprzednio zbudował ołtarz. Tam wezwał Abram imienia PANA. ");
INSERT INTO polubg_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, który szedł z Abramem, również miał owce, woły i namioty. ");
INSERT INTO polubg_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","A ziemia ta nie mogła ich pomieścić, żeby mieszkali razem, bo ich majątek był tak wielki, że nie mogli mieszkać razem. ");
INSERT INTO polubg_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","I wynikła sprzeczka między pasterzami stad Abrama a pasterzami stad Lota. Kananejczycy i Peryzzyci mieszkali wówczas na tej ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram powiedział więc do Lota: Proszę, niech nie będzie sporu między mną a tobą, także między moimi pasterzami a twoimi pasterzami, bo jesteśmy braćmi. ");
INSERT INTO polubg_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Czyż cała ziemia nie stoi przed tobą? Odłącz się, proszę, ode mnie. Jeśli pójdziesz w lewo, ja pójdę w prawo, a jeśli ty pójdziesz w prawo, ja pójdę w lewo. ");
INSERT INTO polubg_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Wtedy Lot podniósł swe oczy i zobaczył, że cała równina nad Jordanem była dobrze nawodniona – zanim PAN zniszczył Sodomę i Gomorę – jak ogród PANA, jak ziemia Egiptu, aż do Zoar. ");
INSERT INTO polubg_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot wybrał więc sobie całą tę równinę nad Jordanem i udał się na wschód. I rozłączyli się bracia jeden od drugiego. ");
INSERT INTO polubg_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram mieszkał w ziemi Kanaan, a Lot mieszkał w miastach tej równiny i rozbił swój namiot aż do Sodomy. ");
INSERT INTO polubg_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ale mężczyźni Sodomy byli źli i wielkimi grzesznikami przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","I PAN powiedział do Abrama, gdy Lot już odłączył się od niego: Podnieś teraz swe oczy i spójrz z miejsca, na którym teraz jesteś, na północ i na południe, na wschód i na zachód. ");
INSERT INTO polubg_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Bo całą ziemię, którą widzisz, dam tobie i twemu potomstwu na wieki. ");
INSERT INTO polubg_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","I rozmnożę twoje potomstwo jak proch ziemi, tak że jeśli ktoś będzie mógł zliczyć proch ziemi, to również twoje potomstwo będzie policzone. ");
INSERT INTO polubg_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Wstań i przejdź tę ziemię wzdłuż i wszerz, bo dam ci ją. ");
INSERT INTO polubg_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abram zwinął więc namiot, przyszedł i mieszkał na równinach Mamre, które są w Hebronie, i tam zbudował ołtarz dla PANA. ");
INSERT INTO polubg_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Za dni Amrafela, króla Szinearu, Arioka, króla Ellasaru, Kedorlaomera, króla Elamu i Tidala, króla narodów; ");
INSERT INTO polubg_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Prowadzili wojnę z Berą, królem Sodomy, z Birszą, królem Gomory, z Szinabem, królem Admy, z Szemeberem, królem Seboim, i z królem miasta Beli, czyli Soaru. ");
INSERT INTO polubg_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Wszyscy oni połączyli się w dolinie Siddim, gdzie dziś jest Morze Słone. ");
INSERT INTO polubg_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Dwanaście lat służyli Kedorlaomerowi, a w trzynastym roku zbuntowali się. ");
INSERT INTO polubg_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","I tak w roku czternastym nadciągnął Kedorlaomer z królami, którzy z nim byli, i pobił Rafaitów w Asztarot-Karnaim, Zuzytów w Ham, Emitów w Szawe-Kiriataim; ");
INSERT INTO polubg_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","I Chorytów na ich górze Seir aż do równiny Paran, która jest przy pustyni. ");
INSERT INTO polubg_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Potem zawrócili i przybyli do En-Miszpat, czyli Kadesz, i wybili całą krainę Amalekitów, a także Amorytów mieszkających w Chasason-Tamar. ");
INSERT INTO polubg_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Wtedy wyruszyli król Sodomy oraz król Gomory, król Admy, król Seboim i król Beli, czyli Soaru, i ustawili się do bitwy z nimi w dolinie Siddim. ");
INSERT INTO polubg_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Z Kedorlaomerem, królem Elamu, Tidalem, królem narodów, Amrafelem, królem Szinearu i Ariokiem, królem Ellasaru – czterech królów przeciw pięciu. ");
INSERT INTO polubg_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","A dolina Siddim była pełna dołów ze smołą. Gdy uciekali królowie Sodomy i Gomory, wpadli tam, a pozostali uciekli na górę. ");
INSERT INTO polubg_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","A tamci zabrali wszelkie mienie Sodomy i Gomory oraz całą ich żywność i odeszli. ");
INSERT INTO polubg_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Zabrali też Lota, bratanka Abrama, wraz z jego mieniem i odeszli. Mieszkał on bowiem w Sodomie. ");
INSERT INTO polubg_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","I przyszedł jeden zbieg, i oznajmił to Abramowi Hebrajczykowi, który mieszkał na równinach Mamrego Amoryty, brata Eszkola i Anera. Oni bowiem byli sprzymierzeni z Abramem. ");
INSERT INTO polubg_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Gdy Abram usłyszał, że jego brat został pojmany, wyprawił swoich trzystu osiemnastu wyszkolonych sług, urodzonych w jego domu, i ścigał ich aż do Dan. ");
INSERT INTO polubg_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","W nocy podzielili się, on i jego słudzy, napadli na nich i pobili ich. Potem ścigali ich aż do Choby, która leży po lewej stronie Damaszku. ");
INSERT INTO polubg_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Odzyskał całe mienie i odbił swego brata Lota wraz z jego mieniem, a także kobiety i ludzi. ");
INSERT INTO polubg_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Gdy wracał po pobiciu Kedorlaomera i królów, którzy z nim byli, król Sodomy wyszedł mu na spotkanie w dolinie Szawe, czyli w dolinie królewskiej. ");
INSERT INTO polubg_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","A Melchisedek, król Salemu, wyniósł chleb i wino. Był on kapłanem Boga Najwyższego. ");
INSERT INTO polubg_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","I błogosławił mu, mówiąc: Niech będzie błogosławiony Abram przez Boga Najwyższego, właściciela nieba i ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","I niech będzie błogosławiony Bóg Najwyższy, który wydał twoich wrogów w twoje ręce. I Abram dał mu dziesięcinę ze wszystkiego. ");
INSERT INTO polubg_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","A król Sodomy powiedział do Abrama: Oddaj mi ludzi, a mienie weź dla siebie. ");
INSERT INTO polubg_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Lecz Abram odpowiedział królowi Sodomy: Podniosłem swą rękę do PANA Boga Najwyższego, właściciela nieba i ziemi; ");
INSERT INTO polubg_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Że nie wezmę najmniejszej nitki ani rzemyka od obuwia, ani niczego, co należy do ciebie, abyś nie powiedział: Ja wzbogaciłem Abrama. ");
INSERT INTO polubg_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Tylko to, co moi słudzy zjedli, oraz przydział mężczyzn, którzy poszli ze mną: Anera, Eszkola i Mamrego; niech oni wezmą swój przydział. ");
INSERT INTO polubg_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Po tych wydarzeniach słowo PANA doszło do Abrama w widzeniu: Nie bój się, Abramie. Ja jestem twoją tarczą i twoją niezmiernie obfitą nagrodą. ");
INSERT INTO polubg_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","I Abram powiedział: Panie BOŻE, co mi dasz, skoro ja jestem bezdzietny, a szafarzem mego domu jest ten Damasceńczyk Eliezer? ");
INSERT INTO polubg_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram dodał: Oto nie dałeś mi potomka, a sługa urodzony w moim domu będzie moim dziedzicem. ");
INSERT INTO polubg_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","A oto dotarło do niego słowo PANA: Nie on będzie twoim dziedzicem, lecz ten, który wyjdzie z twego wnętrza, będzie twoim dziedzicem. ");
INSERT INTO polubg_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Potem wyprowadził go na dwór i powiedział: Spójrz teraz na niebo i policz gwiazdy, jeśli będziesz mógł je policzyć; i powiedział mu: Takie będzie twoje potomstwo. ");
INSERT INTO polubg_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","I uwierzył PANU, i poczytano mu to za sprawiedliwość. ");
INSERT INTO polubg_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Potem powiedział do niego: Ja jestem PANEM, który cię wyprowadził z Ur chaldejskiego, aby ci dać tę ziemię w posiadanie. ");
INSERT INTO polubg_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram zapytał: Panie BOŻE, po czym poznam, że ją odziedziczę? ");
INSERT INTO polubg_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","I odpowiedział mu: Weź dla mnie trzyletnią jałówkę, trzyletnią kozę i trzyletniego barana, a także synogarlicę i pisklę gołębia. ");
INSERT INTO polubg_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Wziął więc to wszystko i rozciął na połowy; a jedną część położył naprzeciwko drugiej, ale ptaków nie rozcinał. ");
INSERT INTO polubg_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Kiedy zleciało się ptactwo do tej padliny, Abram je odganiał. ");
INSERT INTO polubg_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Gdy słońce zachodziło, głęboki sen ogarnął Abrama i oto groza wielkiej ciemności zapadła na niego. ");
INSERT INTO polubg_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","I PAN powiedział do Abrama: Wiedz o tym dobrze, że twoje potomstwo będzie przybyszem w cudzej ziemi i wezmą je w niewolę, i będzie uciskane przez czterysta lat. ");
INSERT INTO polubg_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","A ja osądzę ten naród, któremu będą służyć; a potem wyjdą stamtąd z wielkim dobytkiem. ");
INSERT INTO polubg_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ale ty odejdziesz w pokoju do twoich ojców i będziesz pochowany w dobrej starości. ");
INSERT INTO polubg_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","A w czwartym pokoleniu wrócą tutaj, bo jeszcze nie dopełniła się nieprawość Amorytów. ");
INSERT INTO polubg_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Gdy słońce zaszło i nastała ciemność, oto ukazał się dymiący piec i ognista pochodnia, która przechodziła między tymi połowami zwierząt. ");
INSERT INTO polubg_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","W tym właśnie dniu PAN zawarł przymierze z Abramem, mówiąc: Twemu potomstwu dam tę ziemię, od rzeki Egiptu aż do wielkiej rzeki, rzeki Eufrat; ");
INSERT INTO polubg_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kenitów, Kenizytów i Kadmonitów; ");
INSERT INTO polubg_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Chetytów, Peryzzytów i Refaitów; ");
INSERT INTO polubg_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorytów, Kananejczyków, Girgaszytów i Jebusytów. ");
INSERT INTO polubg_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saraj, żona Abrama, nie urodziła mu dzieci. Miała zaś służącą Egipcjankę, która miała na imię Hagar. ");
INSERT INTO polubg_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","I powiedziała Saraj do Abrama: Oto PAN nie pozwolił mi urodzić. Wejdź, proszę, do mojej służącej, może z niej będę miała dzieci. I Abram usłuchał głosu Saraj. ");
INSERT INTO polubg_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Wzięła więc Saraj, żona Abrama, swoją służącą Hagar, Egipcjankę, i dała ją swemu mężowi Abramowi za żonę po dziesięciu latach zamieszkania Abrama w ziemi Kanaan. ");
INSERT INTO polubg_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Obcował więc z Hagar, a ona poczęła. A gdy spostrzegła, że poczęła, ze wzgardą patrzyła na swoją panią. ");
INSERT INTO polubg_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","I Saraj powiedziała do Abrama: Jesteś winien mojej krzywdy. Dałam moją służącą w twe ramiona. Ona jednak, widząc, że poczęła, patrzyła na mnie ze wzgardą. Niech PAN rozsądzi między mną a tobą. ");
INSERT INTO polubg_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram powiedział do Saraj: Oto twoja służąca jest w twoim ręku, zrób z nią, co uważasz za słuszne. I gdy Saraj dręczyła ją, uciekła od niej. ");
INSERT INTO polubg_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","I Anioł PANA znalazł ją u źródła wód na pustyni, u źródła przy drodze do Szur. ");
INSERT INTO polubg_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","I zapytał: Hagar, służąco Saraj, skąd przyszłaś i dokąd idziesz? Ona odpowiedziała: Uciekam od swojej pani Saraj. ");
INSERT INTO polubg_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Anioł PANA powiedział jej: Wróć do swojej pani i poddaj się pod jej władzę. ");
INSERT INTO polubg_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Powiedział jej też Anioł PANA: Rozmnożę twoje potomstwo tak bardzo, że z powodu jego mnogości nie będzie go można policzyć. ");
INSERT INTO polubg_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Potem Anioł PANA powiedział jej: Oto poczęłaś i urodzisz syna, a nadasz mu imię Izmael, bo PAN usłyszał twoje cierpienie. ");
INSERT INTO polubg_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Będzie on dzikim człowiekiem: jego ręka będzie przeciwko wszystkim, a ręka wszystkich przeciwko jemu; i będzie mieszkać w obecności wszystkich swoich braci. ");
INSERT INTO polubg_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","I nazwała PANA, który mówił do niej: Ty jesteś Bogiem, który mnie widzi. Powiedziała bowiem: Czyż tu nie spoglądałam na tego, który widzi mnie? ");
INSERT INTO polubg_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Dlatego nazwała tę studnię studnią Żyjącego, który widzi mnie. Jest ona między Kadesz i Bered. ");
INSERT INTO polubg_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Potem Hagar urodziła Abramowi syna. I nadał Abram swemu synowi, którego urodziła Hagar, imię Izmael. ");
INSERT INTO polubg_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","A Abram miał osiemdziesiąt sześć lat, gdy Hagar urodziła mu Izmaela. ");
INSERT INTO polubg_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Gdy Abram miał dziewięćdziesiąt dziewięć lat, PAN ukazał się Abramowi i powiedział do niego: Ja jestem Bogiem Wszechmogącym. Chodź przed moim obliczem i bądź doskonały. ");
INSERT INTO polubg_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","A zawrę moje przymierze między mną a tobą i rozmnożę cię bardzo obficie. ");
INSERT INTO polubg_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Wtedy Abram upadł na twarz, a Bóg powiedział do niego: ");
INSERT INTO polubg_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Oto ja ustanawiam moje przymierze z tobą i będziesz ojcem wielu narodów. ");
INSERT INTO polubg_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nie będziesz już się nazywał Abram, ale twoje imię będzie Abraham, bo ustanowiłem cię ojcem wielu narodów. ");
INSERT INTO polubg_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Uczynię cię niezmiernie płodnym i od ciebie wywiodę narody, i od ciebie będą pochodzić królowie. ");
INSERT INTO polubg_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","I utwierdzę moje przymierze między mną a tobą oraz twoim potomstwem po tobie przez wszystkie pokolenia jako wieczne przymierze, abym był ci Bogiem i twemu potomstwu po tobie. ");
INSERT INTO polubg_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Dam tobie i twemu potomstwu po tobie ziemię, w której teraz przebywasz, całą ziemię Kanaan, jako własność na wieki, i będę ich Bogiem. ");
INSERT INTO polubg_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Potem Bóg powiedział Abrahamowi: Ty zaś zachowuj moje przymierze, ty i twoje potomstwo po tobie przez wszystkie pokolenia. ");
INSERT INTO polubg_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","A takie jest moje przymierze, które będziecie zachowywać, między mną a wami i między twoim potomstwem po tobie: Każdy mężczyzna wśród was ma być obrzezany. ");
INSERT INTO polubg_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Obrzezacie więc ciało waszego napletka; to będzie znakiem przymierza między mną a wami. ");
INSERT INTO polubg_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Każdy syn wśród was w ósmym dniu życia będzie obrzezany, każdy mężczyzna przez wszystkie pokolenia, tak narodzony w domu, jak i nabyty za pieniądze od jakiegokolwiek cudzoziemca, który nie pochodzi z twego potomstwa. ");
INSERT INTO polubg_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Urodzony w twoim domu i nabyty za twoje pieniądze musi być obrzezany. A moje przymierze będzie na waszym ciele jako wieczne przymierze. ");
INSERT INTO polubg_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","A nieobrzezany mężczyzna, któremu nie obrzezano ciała jego napletka, ta dusza będzie wykluczona ze swego ludu, bo złamała moje przymierze. ");
INSERT INTO polubg_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Potem Bóg powiedział do Abrahama: Twojej żony Saraj nie będziesz już nazywał imieniem Saraj, ale jej imię będzie Sara. ");
INSERT INTO polubg_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","I będę jej błogosławił, i dam ci z niej syna. Będę jej błogosławił i będzie matką narodów, i od niej będą pochodzić królowie narodów. ");
INSERT INTO polubg_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Wtedy Abraham upadł na twarz i roześmiał się, i mówił w swoim sercu: Czy stuletniemu człowiekowi urodzi się syn? I czy Sara w wieku dziewięćdziesięciu lat urodzi? ");
INSERT INTO polubg_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","I Abraham powiedział do Boga: Oby tylko Izmael żył przed twoim obliczem! ");
INSERT INTO polubg_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","A Bóg powiedział: Naprawdę, twoja żona Sara urodzi ci syna i nadasz mu imię Izaak. I utwierdzę moje przymierze z nim jako wieczne przymierze i z jego potomstwem po nim. ");
INSERT INTO polubg_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Co do Izmaela też cię wysłuchałem. Oto błogosławiłem mu i uczynię go płodnym, i rozmnożę go bardzo obficie. Spłodzi on dwunastu książąt i uczynię go wielkim narodem. ");
INSERT INTO polubg_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ale moje przymierze utwierdzę z Izaakiem, którego Sara urodzi ci za rok o tej porze. ");
INSERT INTO polubg_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Gdy skończył z nim rozmowę, Bóg wzniósł się nad Abrahama. ");
INSERT INTO polubg_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Wtedy Abraham wziął swego syna Izmaela, wszystkich urodzonych w swym domu oraz wszystkich nabytych za pieniądze, wszystkich mężczyzn wśród domowników Abrahama, i obrzezał ciała ich napletków tego samego dnia, jak Bóg mu mówił. ");
INSERT INTO polubg_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham miał dziewięćdziesiąt dziewięć lat, gdy obrzezano ciało jego napletka. ");
INSERT INTO polubg_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","A jego syn Izmael miał trzynaście lat, gdy obrzezano ciało jego napletka. ");
INSERT INTO polubg_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Tego samego dnia obrzezano Abrahama i jego syna Izmaela. ");
INSERT INTO polubg_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","I wszyscy mężczyźni jego domu, urodzeni w domu i nabyci za pieniądze od cudzoziemców, zostali obrzezani z nim. ");
INSERT INTO polubg_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Potem PAN ukazał mu się na równinie Mamre, a on siedział u wejścia do swego namiotu w najgorętszej porze dnia. ");
INSERT INTO polubg_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","I podniósł swe oczy, i zobaczył, że naprzeciwko niego stanęli trzej mężczyźni. Gdy ich ujrzał, pobiegł od wejścia do namiotu na ich spotkanie i skłonił się do ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","I powiedział: Mój Panie, jeśli znalazłem teraz łaskę w twoich oczach, nie omijaj, proszę, swego sługi. ");
INSERT INTO polubg_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Pozwól, by przyniesiono trochę wody, abyście mogli obmyć sobie nogi, potem odpoczniecie pod drzewem. ");
INSERT INTO polubg_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","I przyniosę kęs chleba, abyście posilili swoje serca. Potem odejdziecie, po to bowiem przyszliście do mnie, swego sługi. A oni powiedzieli: Uczyń tak, jak powiedziałeś. ");
INSERT INTO polubg_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham pospieszył do namiotu, do Sary, i powiedział: Przygotuj szybko trzy miarki najlepszej mąki i zrób podpłomyki. ");
INSERT INTO polubg_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abraham zaś poszedł do stada, wziął młode i wyborne cielę i dał je słudze, który szybko je przyrządził. ");
INSERT INTO polubg_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Wziął też masło, mleko i cielę, które przyrządził, i postawił przed nimi. A gdy oni jedli, on stał przy nich pod drzewem. ");
INSERT INTO polubg_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","I zapytali go: Gdzie jest twoja żona Sara? A on odpowiedział: Jest w namiocie. ");
INSERT INTO polubg_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Wtedy powiedział PAN: Na pewno wrócę do ciebie za rok o tej porze, a oto twoja żona Sara będzie miała syna. A Sara przysłuchiwała się u wejścia do namiotu, które było za nim. ");
INSERT INTO polubg_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham i Sara byli starzy, w podeszłym wieku. I przestało już u Sary bywać według zwyczaju kobiet. ");
INSERT INTO polubg_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara roześmiała się więc w sobie, mówiąc: Teraz, gdy się zestarzałam i mój pan jest starcem, mam doznawać rozkoszy? ");
INSERT INTO polubg_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Wtedy PAN powiedział do Abrahama: Dlaczego Sara roześmiała się, mówiąc: Czy naprawdę urodzę, gdy się zestarzałam? ");
INSERT INTO polubg_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Czy jakakolwiek rzecz jest za trudna dla PANA? W przyszłym roku o tej porze wrócę do ciebie, a Sara będzie miała syna. ");
INSERT INTO polubg_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","I Sara zaparła się, mówiąc: Nie śmiałam się – bo się bała. A on powiedział: Przeciwnie, śmiałaś się. ");
INSERT INTO polubg_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Potem ci mężczyźni wstali stamtąd i skierowali wzrok ku Sodomie. Abraham zaś szedł z nimi, aby ich odprowadzić. ");
INSERT INTO polubg_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Wtedy PAN powiedział: Czy mam zataić przed Abrahamem, co zamierzam uczynić? ");
INSERT INTO polubg_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Przecież Abraham na pewno rozmnoży się w lud wielki i możny, a w nim będą błogosławione wszystkie narody ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Znam go bowiem i wiem, że będzie nakazywał swoim synom i swemu domowi po sobie, aby strzegli drogi PANA oraz czynili sprawiedliwość i sąd; aby PAN sprowadził na Abrahama to, co mu powiedział. ");
INSERT INTO polubg_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Potem PAN powiedział: Ponieważ okrzyk Sodomy i Gomory jest wielki i ich grzech jest bardzo ciężki; ");
INSERT INTO polubg_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Zstąpię teraz i zobaczę, czy postępują według tego okrzyku, który doszedł do mnie. A jeśli nie, dowiem się. ");
INSERT INTO polubg_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Wtedy ci mężczyźni odwrócili wzrok i poszli stamtąd do Sodomy, ale Abraham jeszcze stał przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","I Abraham zbliżył się, i powiedział: Czy wytracisz sprawiedliwego razem z niegodziwym? ");
INSERT INTO polubg_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Jeśli będzie pięćdziesięciu sprawiedliwych w tym mieście, czy je wytracisz i nie oszczędzisz tego miejsca ze względu na pięćdziesięciu sprawiedliwych, którzy w nim są? ");
INSERT INTO polubg_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Niech to będzie dalekie od ciebie, byś miał uczynić coś takiego i zabić sprawiedliwego z niegodziwym, żeby sprawiedliwy był jak niegodziwy. Niech to będzie dalekie od ciebie! Czy Sędzia całej ziemi nie postąpi sprawiedliwie? ");
INSERT INTO polubg_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Wtedy PAN odpowiedział: Jeśli znajdę w Sodomie pięćdziesięciu sprawiedliwych w samym mieście, oszczędzę całe miejsce ze względu na nich. ");
INSERT INTO polubg_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","A Abraham odpowiedział: Oto ośmielam się teraz mówić do mojego Pana, choć jestem prochem i popiołem. ");
INSERT INTO polubg_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Gdyby do tych pięćdziesięciu sprawiedliwych zabrakło pięciu, czy z powodu braku tych pięciu zniszczysz całe miasto? I odrzekł: Nie zniszczę, jeśli znajdę tam czterdziestu pięciu. ");
INSERT INTO polubg_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Odezwał się ponownie do niego i powiedział: A gdyby znalazło się tam czterdziestu? I odpowiedział: Nie uczynię tego ze względu na tych czterdziestu. ");
INSERT INTO polubg_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","I Abraham powiedział: Niech się nie gniewa mój Pan, że zapytam: A gdyby znalazło się tam trzydziestu? Odpowiedział: Nie uczynię tego, jeśli znajdę tam trzydziestu. ");
INSERT INTO polubg_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Rzekł jeszcze: Oto ośmielam się teraz mówić do mego Pana: A gdyby znalazło się tam dwudziestu? Odpowiedział: Nie zniszczę go ze względu na tych dwudziestu. ");
INSERT INTO polubg_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Powiedział: Niech się nie gniewa mój Pan, że jeszcze tylko raz przemówię: A gdyby znalazło się tam dziesięciu? Odpowiedział: Nie zniszczę go ze względu na tych dziesięciu. ");
INSERT INTO polubg_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Gdy PAN skończył rozmowę z Abrahamem, odszedł. Abraham zaś wrócił do siebie. ");
INSERT INTO polubg_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","I dwaj aniołowie przyszli wieczorem do Sodomy, a Lot siedział w bramie Sodomy. Gdy Lot ich zobaczył, wstał i wyszedł im naprzeciw, i skłonił się twarzą do ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","I powiedział: Oto proszę, moi panowie, wstąpcie teraz do domu swego sługi, przenocujcie i umyjcie sobie nogi. Potem rano wstaniecie i pójdziecie w swoją drogę. Oni odpowiedzieli: Nie, przenocujemy na ulicy. ");
INSERT INTO polubg_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Gdy bardzo na nich nalegał, zboczyli do niego i weszli do jego domu. Wtedy wyprawił im ucztę i napiekł przaśnego chleba, i jedli. ");
INSERT INTO polubg_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Lecz zanim się położyli, mężczyźni z miasta, mężczyźni z Sodomy, młodzi i starzy, mieszkańcy ze wszystkich stron, otoczyli dom. ");
INSERT INTO polubg_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","I wołali do Lota, i zapytali go: Gdzie są ci mężczyźni, którzy przyszli do ciebie w nocy? Wyprowadź ich do nas, abyśmy z nimi obcowali. ");
INSERT INTO polubg_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Wtedy Lot wyszedł do nich do wejścia i zamknął za sobą drzwi. ");
INSERT INTO polubg_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","I powiedział: Moi bracia, proszę was, nie czyńcie tak niegodziwie. ");
INSERT INTO polubg_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mam dwie córki, które jeszcze nie obcowały z mężczyzną. Pozwólcie, że wyprowadzę je do was, a czyńcie z nimi, co się wam podoba. Tylko tym mężczyznom nic nie czyńcie, bo dlatego weszli pod cień mego dachu. ");
INSERT INTO polubg_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","A oni odpowiedzieli: Odsuń się! I dodali: Ten przyszedł tu jako przybysz, a nas chce sądzić? Z tobą postąpimy gorzej niż z nimi. I napierali gwałtownie na tego mężczyznę, na Lota, i przybliżyli się, aby wyważyć drzwi. ");
INSERT INTO polubg_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ale ci mężczyźni wysunęli ręce, wciągnęli Lota do siebie, do domu, i zamknęli drzwi. ");
INSERT INTO polubg_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Mężczyzn zaś, którzy byli u drzwi domu, od najmniejszego aż do największego, porazili ślepotą, tak że na próżno usiłowali znaleźć drzwi. ");
INSERT INTO polubg_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Potem ci mężczyźni powiedzieli do Lota: Jeśli masz tu kogoś jeszcze, zięcia, synów i córki lub kogokolwiek innego w mieście, wyprowadź ich z tego miejsca. ");
INSERT INTO polubg_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Zniszczymy bowiem to miejsce, ponieważ ich okrzyk wzmógł się przed PANEM i PAN posłał nas, abyśmy je zniszczyli. ");
INSERT INTO polubg_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot wyszedł więc i powiedział do swoich zięciów, którzy mieli poślubić jego córki: Wstańcie, wyjdźcie z tego miejsca, bo PAN zniszczy to miasto. Ale jego zięciom wydawało się, że żartuje. ");
INSERT INTO polubg_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","A gdy już zaczynało świtać, aniołowie ponaglali Lota, mówiąc: Wstań, weź swoją żonę i swoje dwie córki, które tu są, abyś nie zginął z powodu nieprawości tego miasta. ");
INSERT INTO polubg_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","A gdy się ociągał, ci mężczyźni chwycili jego rękę, rękę jego żony i ręce jego dwóch córek – PAN bowiem ulitował się nad nim – i wyprowadzili go, i pozostawili go poza miastem. ");
INSERT INTO polubg_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","I gdy wyprowadzili ich stamtąd, on powiedział: Uciekaj, abyś ocalił swoje życie. Nie oglądaj się wstecz ani nie zatrzymuj się nigdzie na tej równinie. Uciekaj na górę, abyś nie zginął. ");
INSERT INTO polubg_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","A Lot powiedział do nich: O nie, Panie! ");
INSERT INTO polubg_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Oto twój sługa znalazł łaskę w twoich oczach i pomnożyłeś swoje miłosierdzie, które mi wyświadczyłeś, ratując mi życie; ale ja nie mogę uciec na tę górę, bo może dosięgnie mnie jakieś nieszczęście i zginę. ");
INSERT INTO polubg_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Oto jest tu w pobliżu miasto, do którego mógłbym uciec, i jest małe. Proszę, pozwól mi tam uciec (czyż nie jest ono małe?), a moja dusza będzie żyć. ");
INSERT INTO polubg_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Odpowiedział mu: Oto wysłuchałem cię w tej sprawie. Nie zniszczę tego miasta, o którym mówiłeś. ");
INSERT INTO polubg_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Spiesz się i uchodź tam, bo nie będę mógł nic uczynić, dopóki tam nie dojdziesz. Dlatego dano temu miastu nazwę Soar. ");
INSERT INTO polubg_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Słońce wzeszło nad ziemią, gdy Lot wszedł do Soaru. ");
INSERT INTO polubg_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Wtedy PAN spuścił deszcz siarki i ognia od PANA z nieba na Sodomę i Gomorę. ");
INSERT INTO polubg_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","I zniszczył te miasta, całą tę równinę i wszystkich mieszkańców tych miast, a także roślinność tej ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lecz żona Lota, idąc za nim, obejrzała się wstecz i stała się słupem soli. ");
INSERT INTO polubg_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham zaś wstał rano i udał się na to miejsce, gdzie stał przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Gdy spojrzał w stronę Sodomy i Gomory, i całej ziemi tej równiny, zobaczył, że dym unosił się nad tą ziemią jak dym z pieca. ");
INSERT INTO polubg_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","A gdy Bóg zniszczył miasta tej równiny, pamiętał Bóg o Abrahamie i wybawił Lota z samego środka zagłady, kiedy zniszczył te miasta, w których Lot mieszkał. ");
INSERT INTO polubg_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Potem Lot wyszedł z Soaru i mieszkał na górze ze swoimi dwiema córkami, bo bał się mieszkać w Soarze. Zamieszkał więc w jaskini, on i jego dwie córki. ");
INSERT INTO polubg_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","I starsza powiedziała do młodszej: Nasz ojciec jest stary, a nie ma na ziemi mężczyzny, który by obcował z nami według zwyczaju całej ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Chodź, upójmy naszego ojca winem i położymy się z nim, abyśmy zachowały potomstwo naszego ojca. ");
INSERT INTO polubg_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Upoiły więc swego ojca winem tej nocy. I starsza weszła i spała ze swym ojcem, ale on nie spostrzegł ani kiedy się położyła, ani kiedy wstała. ");
INSERT INTO polubg_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Nazajutrz starsza powiedziała do młodszej: Oto zeszłej nocy spałam ze swym ojcem, upójmy go winem także tej nocy, wtedy wejdź ty i połóż się z nim, a tak zachowamy potomstwo naszego ojca. ");
INSERT INTO polubg_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Upoiły więc swego ojca winem także i tej nocy. Wtedy młodsza poszła i spała z nim, ale on nie spostrzegł ani kiedy się położyła, ani kiedy wstała. ");
INSERT INTO polubg_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Tak obie córki Lota poczęły ze swego ojca. ");
INSERT INTO polubg_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Gdy starsza urodziła syna, nadała mu imię Moab. On jest ojcem dzisiejszych Moabitów. ");
INSERT INTO polubg_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Młodsza również urodziła syna i nadała mu imię Ben-Ammi. On jest ojcem synów dzisiejszych Ammonitów. ");
INSERT INTO polubg_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Potem Abraham wyruszył stamtąd do ziemi południowej i zamieszkał między Kadesz a Szur, i był przybyszem w Gerarze. ");
INSERT INTO polubg_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Tam Abraham powiedział o swej żonie Sarze: Ona jest moją siostrą. Dlatego Abimelek, król Geraru, posłał po Sarę i wziął ją. ");
INSERT INTO polubg_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Lecz Bóg przyszedł do Abimeleka we śnie w nocy i powiedział mu: Umrzesz z powodu tej kobiety, którą wziąłeś, bo ona ma męża. ");
INSERT INTO polubg_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ale Abimelek jeszcze nie zbliżył się do niej i powiedział: Panie, czy zabijesz też lud sprawiedliwy? ");
INSERT INTO polubg_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Czy on sam nie mówił mi: Ona jest moją siostrą? I czy ona również nie mówiła: On jest moim bratem? Uczyniłem to w prostocie mego serca i z czystymi rękami. ");
INSERT INTO polubg_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Wtedy Bóg powiedział mu we śnie: Wiem, że uczyniłeś to w prostocie swego serca. Dlatego powstrzymałem cię, abyś nie zgrzeszył przeciwko mnie, i nie dopuściłem, abyś jej dotknął. ");
INSERT INTO polubg_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Teraz więc zwróć żonę mężowi, bo on jest prorokiem i będzie się modlił za ciebie, a będziesz żył. Jeśli jej nie zwrócisz, wiedz, że na pewno umrzesz, ty i wszystko, co jest twoje. ");
INSERT INTO polubg_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelek wstał zatem wcześnie rano, zwołał wszystkie swoje sługi i do ich uszu opowiedział wszystko. Gdy ci mężczyźni to usłyszeli, bardzo się przestraszyli. ");
INSERT INTO polubg_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Potem Abimelek wezwał Abrahama i powiedział mu: Co nam uczyniłeś? W czym zgrzeszyłem przeciwko tobie, że sprowadziłeś na mnie i na moje królestwo tak wielki grzech? Postąpiłeś ze mną tak, jak nie należy postępować. ");
INSERT INTO polubg_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelek zapytał jeszcze Abrahama: Co widziałeś, że tak postąpiłeś? ");
INSERT INTO polubg_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham odpowiedział: Bo myślałem – na pewno nie ma w tym miejscu bojaźni Bożej i zabiją mnie z powodu mojej żony. ");
INSERT INTO polubg_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Zresztą ona naprawdę jest moją siostrą, córką mego ojca, choć nie córką mojej matki. I została moją żoną. ");
INSERT INTO polubg_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Gdy więc Bóg wyprawił mnie na wędrówkę z domu mego ojca, powiedziałem do niej: Oto przysługa, jaką mi wyświadczysz – w każdym miejscu, do którego przyjdziemy, mów o mnie: To jest mój brat. ");
INSERT INTO polubg_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Wtedy Abimelek wziął owce i woły oraz służących i służące i dał Abrahamowi, i zwrócił mu jego żonę Sarę. ");
INSERT INTO polubg_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","I Abimelek powiedział: Oto moja ziemia jest przed tobą. Zamieszkaj, gdzie ci się podoba. ");
INSERT INTO polubg_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A do Sary powiedział: Dałem twemu bratu tysiąc srebrników. Oto on jest zasłoną twoich oczu u wszystkich, którzy są z tobą, i u wszystkich innych. O tym Sara została pouczona. ");
INSERT INTO polubg_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Wtedy Abraham modlił się do Boga i Bóg uzdrowił Abimeleka, a także jego żonę i jego służące, i one rodziły. ");
INSERT INTO polubg_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","PAN bowiem zamknął wszystkie łona domu Abimeleka z powodu Sary, żony Abrahama. ");
INSERT INTO polubg_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","A PAN nawiedził Sarę, jak powiedział, i uczynił PAN Sarze, jak zapowiedział. ");
INSERT INTO polubg_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara poczęła bowiem i urodziła Abrahamowi syna w jego starości w tym czasie, który przepowiedział mu Bóg. ");
INSERT INTO polubg_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham nadał swemu synowi, który mu się urodził, którego mu urodziła Sara, imię Izaak. ");
INSERT INTO polubg_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","I Abraham obrzezał swego syna Izaaka, gdy ten miał osiem dni, jak Bóg mu rozkazał. ");
INSERT INTO polubg_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","A Abraham miał sto lat, gdy mu się urodził jego syn Izaak. ");
INSERT INTO polubg_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Wtedy Sara powiedziała: Bóg dał mi powód do śmiechu; ktokolwiek o tym usłyszy, będzie się śmiał ze mną. ");
INSERT INTO polubg_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","I dodała: Kto by powiedział Abrahamowi, że Sara będzie karmiła piersią dzieci? Gdyż urodziłam mu syna w jego starości. ");
INSERT INTO polubg_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Dziecko rosło i zostało odstawione od piersi. I Abraham wyprawił wielką ucztę w dniu odstawienia Izaaka. ");
INSERT INTO polubg_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Gdy Sara zobaczyła syna Egipcjanki Hagar, którego ta urodziła Abrahamowi, szydzącego; ");
INSERT INTO polubg_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Powiedziała do Abrahama: Wyrzuć tę niewolnicę i jej syna, bo syn tej niewolnicy nie będzie dziedziczyć z moim synem Izaakiem. ");
INSERT INTO polubg_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Słowa te wydały się Abrahamowi bardzo przykre ze względu na jego syna. ");
INSERT INTO polubg_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Wtedy Bóg powiedział do Abrahama: Niech ci nie będzie przykro z powodu chłopca i twojej niewolnicy. Posłuchaj wszystkiego, co Sara mówi do ciebie, bo w Izaaku będzie nazwane twoje potomstwo. ");
INSERT INTO polubg_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Syna zaś tej niewolnicy również uczynię narodem, bo jest on twoim potomstwem. ");
INSERT INTO polubg_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abraham wstał więc wcześnie rano, wziął chleb i bukłak wody i dał Hagar, wkładając jej to na ramię, oraz wziął dziecko i odprawił ją. Ona zaś odeszła i błąkała się po pustyni Beer-Szeby. ");
INSERT INTO polubg_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","A gdy skończyła się woda w bukłaku, porzuciła dziecko pod jednym z krzewów. ");
INSERT INTO polubg_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Potem odeszła i usiadła naprzeciw niego w odległości strzału z łuku. Mówiła bowiem: Nie będę patrzyła na śmierć dziecka. Usiadła więc naprzeciw niego i zaczęła głośno płakać. ");
INSERT INTO polubg_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","I Bóg usłyszał głos chłopca, i Anioł Boga zawołał na Hagar z nieba: Co ci jest, Hagar? Nie bój się, bo Bóg usłyszał głos chłopca tam, gdzie jest. ");
INSERT INTO polubg_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Wstań, podnieś chłopca i weź go za rękę, bo uczynię go wielkim narodem. ");
INSERT INTO polubg_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Wtedy Bóg otworzył jej oczy i zobaczyła studnię z wodą. Poszła więc, napełniła bukłak wodą i dała chłopcu pić. ");
INSERT INTO polubg_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","I Bóg był z chłopcem. Urósł i mieszkał na pustyni, i stał się łucznikiem. ");
INSERT INTO polubg_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","A mieszkał na pustyni Paran. I jego matka wzięła dla niego żonę z ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","W tym czasie Abimelek wraz z dowódcą swego wojska Pikolem powiedział do Abrahama: Bóg jest z tobą we wszystkim, co czynisz. ");
INSERT INTO polubg_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Teraz więc przysięgnij mi tu na Boga, że nie postąpisz zdradliwie wobec mnie ani mego syna, ani mego wnuka. Ale według miłosierdzia, które ci okazałem, postąpisz ze mną i z ziemią, w której jesteś przybyszem. ");
INSERT INTO polubg_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham odpowiedział: Przysięgam. ");
INSERT INTO polubg_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","I Abraham poskarżył się Abimelekowi z powodu studni z wodą, którą mu przemocą zabrali słudzy Abimeleka. ");
INSERT INTO polubg_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelek powiedział: Nie wiem, kto to uczynił. Ani nie powiedziałeś mi o tym, ani nie słyszałem o tym aż dopiero dziś. ");
INSERT INTO polubg_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham wziął więc owce i woły i dał je Abimelekowi, i obaj zawarli przymierze. ");
INSERT INTO polubg_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","I Abraham wydzielił z trzody siedmioro jagniąt. ");
INSERT INTO polubg_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek zapytał Abrahama: Po co te siedmioro jagniąt, które postawiłeś osobno? ");
INSERT INTO polubg_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","A on odpowiedział: Te siedem owiec weźmiesz z moich rąk, aby były świadectwem, że wykopałem tę studnię. ");
INSERT INTO polubg_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Dlatego nazwano to miejsce Beer-Szeba, bo tam obaj sobie przysięgli. ");
INSERT INTO polubg_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Tak zawarli przymierze w Beer-Szebie. Potem Abimelek i Pikol, dowódca jego wojska, wstali i wrócili do ziemi Filistynów. ");
INSERT INTO polubg_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham zaś zasadził drzewa w Beer-Szebie i wzywał tam imienia PANA, Boga wiecznego. ");
INSERT INTO polubg_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","I Abraham gościł w ziemi Filistynów przez wiele dni. ");
INSERT INTO polubg_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Po tych wydarzeniach Bóg wystawił Abrahama na próbę i powiedział do niego: Abrahamie! A on odpowiedział: Oto jestem. ");
INSERT INTO polubg_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","I Bóg powiedział: Weź teraz swego syna, twego jedynego, którego miłujesz, Izaaka, idź do ziemi Moria i tam złóż go na ofiarę całopalną na jednej górze, o której ci powiem. ");
INSERT INTO polubg_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham wstał więc wcześnie rano, osiodłał swego osła i wziął ze sobą dwóch służących i swego syna Izaaka, narąbał drew na ofiarę całopalną, wstał i poszedł na miejsce, o którym mu Bóg powiedział. ");
INSERT INTO polubg_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","A trzeciego dnia Abraham podniósł swe oczy i zobaczył z daleka to miejsce. ");
INSERT INTO polubg_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Wtedy Abraham powiedział do swoich służących: Zostańcie tu z osłem, a ja i chłopiec pójdziemy tam, oddamy cześć Bogu i wrócimy do was. ");
INSERT INTO polubg_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Wziął więc Abraham drwa na ofiarę całopalną i włożył je na swego syna Izaaka, a sam wziął do ręki ogień i nóż i poszli obaj razem. ");
INSERT INTO polubg_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","I Izaak powiedział do swego ojca Abrahama: Mój ojcze! A on odpowiedział: Oto jestem, mój synu. I Izaak zapytał: Oto ogień i drwa, a gdzie jest baranek na ofiarę całopalną? ");
INSERT INTO polubg_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham odpowiedział: Bóg sobie upatrzy baranka na ofiarę całopalną, mój synu. I szli obaj razem. ");
INSERT INTO polubg_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","A gdy przyszli na miejsce, o którym mu Bóg powiedział, Abraham zbudował tam ołtarz, ułożył na nim drwa, związał swego syna Izaaka i położył go na ołtarzu na drwach. ");
INSERT INTO polubg_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Potem Abraham wyciągnął rękę i wziął nóż, aby zabić swego syna. ");
INSERT INTO polubg_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Lecz Anioł PANA zawołał do niego z nieba: Abrahamie, Abrahamie! A on odpowiedział: Oto jestem. ");
INSERT INTO polubg_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Anioł powiedział: Nie podnoś ręki na chłopca i nic mu nie czyń, bo teraz wiem, że boisz się Boga i nie odmówiłeś mi swego jedynego syna. ");
INSERT INTO polubg_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","A Abraham podniósł swe oczy i spojrzał, a oto za nim baran zaplątał się rogami w zaroślach. Abraham poszedł więc i wziął barana, i złożył go na ofiarę całopalną zamiast swego syna. ");
INSERT INTO polubg_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","I Abraham nadał temu miejscu nazwę: PAN upatrzy. Dlatego po dziś dzień mówią: Na górze PANA będzie upatrzony. ");
INSERT INTO polubg_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Wtedy Anioł PANA ponownie zawołał z nieba na Abrahama: ");
INSERT INTO polubg_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Przysiągłem na siebie samego, mówi PAN: Ponieważ to uczyniłeś i nie odmówiłeś mi swego syna, twego jedynego; ");
INSERT INTO polubg_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Błogosławiąc, będę ci błogosławić, a rozmnażając, rozmnożę twoje potomstwo jak gwiazdy na niebie i jak piasek na brzegu morza; a twoje potomstwo odziedziczy bramy swoich nieprzyjaciół. ");
INSERT INTO polubg_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","I w twoim potomstwie będą błogosławione wszystkie narody ziemi, dlatego że posłuchałeś mojego głosu. ");
INSERT INTO polubg_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abraham wrócił więc do swoich służących i wstali, i wspólnie udali się do Beer-Szeby. Abraham bowiem mieszkał w Beer-Szebie. ");
INSERT INTO polubg_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Po tych wydarzeniach doniesiono Abrahamowi: Oto Milka również urodziła dzieci twemu bratu Nachorowi; ");
INSERT INTO polubg_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Usa, jego pierworodnego, Buza, jego brata, i Kemuela, ojca Arama; ");
INSERT INTO polubg_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","I Keseda, Chazo, Pildasza, Jidlafa i Betuela. ");
INSERT INTO polubg_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel zaś spłodził Rebekę. Tych ośmiu urodziła Milka Nachorowi, bratu Abrahama. ");
INSERT INTO polubg_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","A jego nałożnica, której imię było Reuma, urodziła też Tebacha, Gachama, Tachasza i Maakę. ");
INSERT INTO polubg_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","A Sara dożyła stu dwudziestu siedmiu lat. Tyle było lat życia Sary. ");
INSERT INTO polubg_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara umarła w mieście Kiriat-Arba, czyli w Hebronie, w ziemi Kanaan. I Abraham przyszedł, aby odbyć żałobę po Sarze i opłakiwać ją. ");
INSERT INTO polubg_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Potem Abraham wstał od swej zmarłej i powiedział do synów Cheta: ");
INSERT INTO polubg_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Jestem wśród was przybyszem i przychodniem. Dajcie mi na własność grób między wami, abym pogrzebał moją zmarłą sprzed mojego oblicza. ");
INSERT INTO polubg_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Synowie Cheta odpowiedzieli Abrahamowi: ");
INSERT INTO polubg_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Słuchaj nas, mój panie: Jesteś księciem Boga wśród nas. Pochowaj swoją zmarłą w naszych najlepszych grobach. Nikt z nas nie odmówi ci swego grobu, abyś pochował swoją zmarłą. ");
INSERT INTO polubg_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Wtedy Abraham wstał, pokłonił się ludowi tej ziemi, czyli synom Cheta; ");
INSERT INTO polubg_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","I powiedział do nich: Jeśli zgadzacie się, abym pochował moją zmarłą sprzed mojego oblicza, posłuchajcie mnie i wstawcie się za mną do Efrona, syna Sochara; ");
INSERT INTO polubg_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Aby mi ustąpił swą jaskinię Makpela, która znajduje się na końcu jego pola. Niech mi ją odda za odpowiednią cenę jako grób na własność wśród was. ");
INSERT INTO polubg_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","A Efron siedział wśród synów Cheta. Odpowiedział więc Efron Chetyta Abrahamowi w obecności synów Cheta i wszystkich, którzy wchodzili w bramę jego miasta: ");
INSERT INTO polubg_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Nie, panie mój, posłuchaj mnie. Daję ci to pole i jaskinię, która na nim jest. Daję ją tobie w obecności synów mego ludu. Pochowaj swoją zmarłą. ");
INSERT INTO polubg_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Wtedy Abraham pokłonił się przed ludem tej ziemi; ");
INSERT INTO polubg_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","I powiedział do Efrona w obecności ludu tej ziemi: Raczej jeśli się da, proszę, posłuchaj mnie. Dam ci pieniądze za pole, weź je ode mnie, a pochowam tam moją zmarłą. ");
INSERT INTO polubg_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron odpowiedział Abrahamowi: ");
INSERT INTO polubg_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Mój panie, posłuchaj mnie. Ta ziemia jest warta czterysta syklów srebra, ale cóż to jest między mną a tobą? Pochowaj swoją zmarłą. ");
INSERT INTO polubg_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","I Abraham wysłuchał Efrona. Odważył więc Abraham Efronowi srebro, które ten wymienił w obecności synów Cheta: czterysta syklów srebra, jakie były w obiegu u kupców. ");
INSERT INTO polubg_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Tak więc pole Efrona, które jest w Makpelu naprzeciw Mamre, pole i jaskinia, która na nim jest, i wszystkie drzewa, które były na polu i wkoło na wszystkich jego granicach, przeszły; ");
INSERT INTO polubg_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Na własność Abrahama w obecności synów Cheta i wszystkich, którzy wchodzili w bramę tego miasta. ");
INSERT INTO polubg_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Potem Abraham pochował swoją żonę Sarę w jaskini pola w Makpelu naprzeciwko Mamre, czyli Hebronie, w ziemi Kanaan. ");
INSERT INTO polubg_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","I zostały oddane Abrahamowi pole i jaskinia, która była na nim, jako grób na własność, przez synów Cheta. ");
INSERT INTO polubg_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","A Abraham był stary, w podeszłym wieku, a PAN błogosławił mu we wszystkim. ");
INSERT INTO polubg_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","I Abraham powiedział do swego starszego sługi w swym domu, który zarządzał wszystkim, co miał: Połóż, proszę, swą rękę pod moje biodro; ");
INSERT INTO polubg_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","I przysięgnij mi na PANA, Boga nieba i Boga ziemi, że nie weźmiesz dla mego syna żony z córek Kananejczyków, wśród których mieszkam; ");
INSERT INTO polubg_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ale pójdziesz do mojej ziemi i do mojej rodziny i stamtąd weźmiesz żonę dla mego syna Izaaka. ");
INSERT INTO polubg_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Sługa mu odpowiedział: A jeśli kobieta nie zechce pójść ze mną do tej ziemi, czy wtedy mam zaprowadzić twego syna do ziemi, z której wyszedłeś? ");
INSERT INTO polubg_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham mu odpowiedział: Strzeż się, abyś tam nie zaprowadził mego syna. ");
INSERT INTO polubg_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","PAN Bóg nieba, który mnie wziął z domu mego ojca i z ziemi mojej rodziny i który mówił ze mną, i przysiągł mi: Twemu potomstwu dam tę ziemię; on pośle przed tobą swego anioła i weźmiesz stamtąd żonę dla mego syna. ");
INSERT INTO polubg_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","A jeśli ta kobieta nie zechce pójść z tobą, będziesz zwolniony z mojej przysięgi. Tylko nie prowadź tam mego syna. ");
INSERT INTO polubg_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Wtedy sługa podłożył rękę pod biodro swego pana Abrahama i przysiągł mu to. ");
INSERT INTO polubg_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Potem ów sługa wziął dziesięć wielbłądów z wielbłądów swego pana i poszedł – bo miał w swych rękach wszystkie dobra swego pana. Wstał i udał się do Aram-Naharaim, do miasta Nachora. ");
INSERT INTO polubg_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","I dał wielbłądom odpocząć przy studni poza miastem w wieczornej porze, w tym czasie, kiedy kobiety zwykły wychodzić czerpać wodę. ");
INSERT INTO polubg_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","I powiedział: PANIE, Boże mego pana Abrahama, daj mi, proszę, pomyślne spotkanie i okaż łaskę mojemu panu Abrahamowi. ");
INSERT INTO polubg_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Oto stoję przy studni, a córki mieszkańców tego miasta wyjdą czerpać wodę; ");
INSERT INTO polubg_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Niech dziewczyna, której powiem: Przechyl, proszę, twój dzban, abym mógł się napić, a ona odpowie: Pij i napoję także twoje wielbłądy – będzie tą, którą przeznaczyłeś dla twego sługi Izaaka; a po tym poznam, że okazałeś łaskę mojemu panu. ");
INSERT INTO polubg_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","I zanim przestał mówić, oto wyszła Rebeka, która się urodziła Betuelowi, synowi Milki, żony Nachora, brata Abrahama, z dzbanem na ramieniu. ");
INSERT INTO polubg_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Była ona bardzo piękną dziewczyną, dziewicą, z którą nie obcował żaden mężczyzna. Zeszła do studni, napełniła swój dzban i wracała. ");
INSERT INTO polubg_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Wtedy ów sługa wybiegł do niej i powiedział: Proszę, pozwól mi się napić trochę wody z twego dzbana. ");
INSERT INTO polubg_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","A ona odpowiedziała: Pij, panie mój. I szybko pochyliła swój dzban na swoją rękę, i dała mu pić. ");
INSERT INTO polubg_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","A gdy dała mu się napić, powiedziała: Naczerpię wody także dla twoich wielbłądów, aby napiły się do woli. ");
INSERT INTO polubg_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Wylała prędko wodę ze swego dzbana w koryto i pobiegła znowu do studni czerpać wodę, i naczerpała dla wszystkich jego wielbłądów. ");
INSERT INTO polubg_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","A ów mężczyzna zdumiewał się nią, zastanawiając się w milczeniu, czy PAN poszczęścił jego podróży, czy nie. ");
INSERT INTO polubg_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Gdy więc wielbłądy się napiły, ów mężczyzna wyjął i dał na jej ręce złoty kolczyk ważący pół sykla i dwie bransolety ważące dziesięć syklów złota. ");
INSERT INTO polubg_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","I zapytał: Czyją jesteś córką? Powiedz mi, proszę. Czy jest w domu twego ojca miejsce dla nas na nocleg? ");
INSERT INTO polubg_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","A ona mu odpowiedziała: Jestem córką Betuela, syna Milki, którego urodziła Nachorowi. ");
INSERT INTO polubg_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Po czym dodała: Jest u nas dosyć słomy i paszy oraz miejsce na nocleg. ");
INSERT INTO polubg_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","I ów mężczyzna uklęknął i oddał pokłon PANU; ");
INSERT INTO polubg_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","I powiedział: Błogosławiony PAN, Bóg mego pana Abrahama, który nie oddalił swego miłosierdzia i swojej prawdy od mego pana, bo gdy byłem w drodze, PAN przyprowadził mnie do domu braci mego pana. ");
INSERT INTO polubg_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","I dziewczyna pobiegła, i w domu swej matki oznajmiła, co się stało. ");
INSERT INTO polubg_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","A Rebeka miała brata imieniem Laban. I Laban wybiegł do tego człowieka, do studni. ");
INSERT INTO polubg_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Gdy zobaczył kolczyk i bransolety na rękach swej siostry i usłyszał słowa swej siostry Rebeki: Tak mówił do mnie ten człowiek, podszedł do tego człowieka, a oto on stał przy wielbłądach u studni. ");
INSERT INTO polubg_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","I powiedział do niego: Wejdź, błogosławiony przez PANA. Czemu stoisz na dworze? Przygotowałem już dom i miejsce dla wielbłądów. ");
INSERT INTO polubg_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Wszedł więc ów człowiek do domu. I Laban rozsiodłał wielbłądy, i dał słomy i paszy wielbłądom, i wody do umycia jego nóg oraz nóg tych mężczyzn, którzy z nim byli. ");
INSERT INTO polubg_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","I położył przed nim jedzenie, aby jadł, ale on powiedział: Nie będę jadł, dopóki nie przedstawię swojej sprawy. Laban powiedział: Mów. ");
INSERT INTO polubg_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","I powiedział: Jestem sługą Abrahama. ");
INSERT INTO polubg_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","PAN pobłogosławił bardzo mego pana i stał się on zamożny. Dał mu bowiem owce i woły, srebra i złota, służących i służące, wielbłądy i osły. ");
INSERT INTO polubg_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","A Sara, żona mego pana, urodziła memu panu w jego starości syna, któremu dał wszystko, co ma. ");
INSERT INTO polubg_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","I mój pan kazał mi przysiąc, mówiąc: Nie weźmiesz dla mego syna żony z córek Kananejczyków, w których ziemi mieszkam; ");
INSERT INTO polubg_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ale pójdziesz do domu mego ojca i do moich krewnych i stamtąd weźmiesz żonę dla mojego syna. ");
INSERT INTO polubg_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","I zapytałem mego pana: A jeśli ta kobieta nie zechce pójść ze mną? ");
INSERT INTO polubg_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Odpowiedział mi: PAN, przed którym chodzę, pośle swego anioła z tobą i poszczęści twojej drodze; i weźmiesz dla mego syna żonę spośród moich krewnych i z domu mego ojca. ");
INSERT INTO polubg_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Będziesz jednak zwolniony z mojej przysięgi, jeśli przyjdziesz do moich krewnych, a oni ci jej nie dadzą. Wtedy będziesz wolny od mojej przysięgi. ");
INSERT INTO polubg_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Przyszedłem więc dziś do studni i powiedziałem: PANIE, Boże mego pana Abrahama, jeśli teraz chcesz poszczęścić mojej podróży, którą odbywam; ");
INSERT INTO polubg_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Oto stoję przy studni wody. Niech panna, która wyjdzie czerpać wodę, a której powiem: Daj mi, proszę, napić się trochę wody z twego dzbana; ");
INSERT INTO polubg_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","A ona odpowie mi: I ty pij, naczerpię też dla twoich wielbłądów – niech ona będzie żoną, którą przeznaczył PAN dla syna mego pana. ");
INSERT INTO polubg_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Zanim przestałem mówić w swym sercu, oto przyszła Rebeka, niosąc swój dzban na ramieniu, i zeszła do studni, i czerpała. Powiedziałem do niej: Proszę, daj mi pić. ");
INSERT INTO polubg_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","A ona szybko zdjęła swój dzban i powiedziała: Pij, a twoje wielbłądy też napoję. Piłem więc, a ona napoiła też wielbłądy. ");
INSERT INTO polubg_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","I zapytałem ją: Czyją jesteś córką? Odpowiedziała: Jestem córką Betuela, syna Nachora, którego urodziła mu Milka. Wtedy włożyłem kolczyk na jej twarz i bransolety na jej ręce. ");
INSERT INTO polubg_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Potem uklęknąłem i oddałem pokłon PANU, i błogosławiłem PANA, Boga mego pana Abrahama, który mnie prowadził właściwą drogą, abym wziął córkę brata mego pana dla jego syna. ");
INSERT INTO polubg_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Teraz więc, jeśli chcecie postąpić życzliwie i właściwie wobec mojego pana, powiedzcie mi. A jeśli nie, to też mi powiedzcie, żebym zwrócił się w prawo lub w lewo. ");
INSERT INTO polubg_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Wtedy Laban i Betuel odpowiedzieli: Ta sprawa pochodzi od PANA. My nie możemy ci powiedzieć ani dobrze, ani źle. ");
INSERT INTO polubg_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Oto przed tobą Rebeka, weź ją i idź, niech będzie żoną syna twego pana, jak powiedział PAN. ");
INSERT INTO polubg_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Gdy sługa Abrahama usłyszał ich słowa, uklęknął na ziemi i oddał pokłon PANU. ");
INSERT INTO polubg_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Następnie ów sługa wyjął srebrne i złote klejnoty, i szaty i oddał je Rebece. Dał też kosztowności jej bratu i matce. ");
INSERT INTO polubg_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Potem jedli i pili, on i mężczyźni, którzy z nim byli, i zostali tam na noc. A gdy wstali rano, on powiedział: Odprawcie mnie do mego pana. ");
INSERT INTO polubg_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Jej brat i matka powiedzieli: Niech dziewczyna zostanie z nami chociaż dziesięć dni, a potem pójdzie. ");
INSERT INTO polubg_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","A on powiedział do nich: Nie zatrzymujcie mnie, skoro PAN poszczęścił mojej drodze; odprawcie mnie, abym jechał do mego pana. ");
INSERT INTO polubg_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Odpowiedzieli: Zawołajmy dziewczynę i spytajmy, co na to powie. ");
INSERT INTO polubg_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Zawołali więc Rebekę i zapytali ją: Czy chcesz jechać z tym człowiekiem? A ona odpowiedziała: Pojadę. ");
INSERT INTO polubg_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Wtedy wyprawili swoją siostrę Rebekę, jej mamkę, sługę Abrahama i jego ludzi. ");
INSERT INTO polubg_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","I błogosławili Rebece, mówiąc jej: Jesteś naszą siostrą, rozmnóż się w tysiąc tysięcy, a twoje potomstwo niech posiądzie bramy swych nieprzyjaciół. ");
INSERT INTO polubg_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Potem Rebeka ze swymi służącymi wstała i wsiadła na wielbłądy, i jechały za tym mężczyzną. Sługa ów wziął Rebekę i odjechał. ");
INSERT INTO polubg_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","A Izaak właśnie wracał od studni Lachaj-Roj, bo mieszkał w ziemi południowej. ");
INSERT INTO polubg_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","I wyszedł Izaak na pole pod wieczór, aby rozmyślać. Gdy podniósł swe oczy, zobaczył zbliżające się wielbłądy. ");
INSERT INTO polubg_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka też podniosła swe oczy i zobaczyła Izaaka, i zsiadła z wielbłąda; ");
INSERT INTO polubg_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Bo zapytała sługę: Kim jest ten mężczyzna, który idzie do nas przez pole? I sługa odpowiedział: To jest mój pan. A ona wzięła zasłonę i nakryła się. ");
INSERT INTO polubg_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","I opowiedział ów sługa Izaakowi o wszystkim, co zrobił. ");
INSERT INTO polubg_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","A Izaak wprowadził ją do namiotu swojej matki Sary i wziął Rebekę za żonę, i kochał ją. I Izaak pocieszył się po śmierci swojej matki. ");
INSERT INTO polubg_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Potem Abraham pojął drugą żonę, której było na imię Ketura. ");
INSERT INTO polubg_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ona urodziła mu Zimrana, Jokszana, Medana, Midiana, Jiszbaka i Szuacha. ");
INSERT INTO polubg_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokszan spłodził Szebę i Dedana. A synami Dedana byli Aszszurim, Letuszim i Leummim. ");
INSERT INTO polubg_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Synami Midiana byli: Efa, Efer, Henoch, Abida i Eldaa. Wszyscy oni byli synami Ketury. ");
INSERT INTO polubg_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","I Abraham dał Izaakowi wszystko, co miał. ");
INSERT INTO polubg_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","A synom nałożnic, które miał, Abraham dał upominki i jeszcze za swojego życia wyprawił ich z dala od swego syna Izaaka ku wschodowi, do ziemi wschodniej. ");
INSERT INTO polubg_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Oto liczba lat życia, których dożył Abraham: sto siedemdziesiąt pięć lat. ");
INSERT INTO polubg_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham oddał ducha i umarł w dobrej starości, podeszły w latach i syty życia; i został przyłączony do swego ludu. ");
INSERT INTO polubg_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","I jego synowie, Izaak i Izmael, pochowali go w jaskini Makpela, na polu Efrona, syna Sochara Chetyty, które było naprzeciwko Mamre; ");
INSERT INTO polubg_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Na polu, które Abraham kupił od synów Cheta. Tam zostali pochowani Abraham i Sara, jego żona. ");
INSERT INTO polubg_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","A po śmierci Abrahama Bóg błogosławił jego synowi Izaakowi, a Izaak mieszkał przy studni Lachaj-Roj. ");
INSERT INTO polubg_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","To są dzieje rodu Izmaela, syna Abrahama, którego urodziła Abrahamowi Hagar, Egipcjanka, służąca Sary. ");
INSERT INTO polubg_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","I to są imiona synów Izmaela według ich rodów: Nebajot, pierworodny Izmaela, po nim Kedar, Abdeel i Mibsam; ");
INSERT INTO polubg_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Miszma, Duma i Massa; ");
INSERT INTO polubg_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Chadar, Tema, Jetur, Nafisz i Kedma. ");
INSERT INTO polubg_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","To są synowie Izmaela, a to ich imiona według ich miasteczek i zamków; dwunastu książąt w ich narodach. ");
INSERT INTO polubg_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","A lat życia Izmaela było sto trzydzieści siedem. Oddał ducha i umarł, i został przyłączony do swego ludu. ");
INSERT INTO polubg_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","I mieszkali od Chawila aż do Szur, który leży naprzeciwko Egiptu, na drodze do Asyrii. I umarł w obecności wszystkich swych braci. ");
INSERT INTO polubg_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","To zaś są dzieje rodu Izaaka, syna Abrahama: Abraham spłodził Izaaka. ");
INSERT INTO polubg_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Izaak miał czterdzieści lat, gdy pojął za żonę Rebekę, córkę Betuela Syryjczyka, z Paddan-Aram, siostrę Labana, Syryjczyka. ");
INSERT INTO polubg_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","A Izaak modlił się do PANA za swoją żonę, gdyż była niepłodna. I PAN go wysłuchał, i jego żona Rebeka poczęła. ");
INSERT INTO polubg_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","A gdy dzieci walczyły ze sobą w jej łonie, powiedziała: Jeśli tak się zdarza, dlaczego poczęłam? Poszła więc, aby zapytać PANA. ");
INSERT INTO polubg_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","I PAN jej odpowiedział: Dwa narody są w twoim łonie i dwa ludy wyjdą z twego wnętrza. Jeden lud będzie mocniejszy niż drugi i starszy będzie służył młodszemu. ");
INSERT INTO polubg_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","A gdy nadszedł czas porodu, okazało się, że w jej łonie były bliźnięta. ");
INSERT INTO polubg_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","I wyszedł pierwszy syn czerwony i cały pokryty owłosieniem jak szatą; i nadali mu imię Ezaw. ");
INSERT INTO polubg_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","A potem wyszedł jego brat, trzymając swą ręką za piętę Ezawa, i nadano mu imię Jakub. Izaak miał sześćdziesiąt lat, gdy oni mu się urodzili. ");
INSERT INTO polubg_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","A gdy dzieci urosły, Ezaw został człowiekiem biegłym w myślistwie i człowiekiem pola. Jakub zaś był człowiekiem spokojnym, mieszkającym w namiotach. ");
INSERT INTO polubg_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","I Izaak kochał Ezawa, bo jadał z jego łowu, Rebeka zaś kochała Jakuba. ");
INSERT INTO polubg_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","I Jakub ugotował sobie potrawę, a w tym czasie przyszedł Ezaw z pola spracowany. ");
INSERT INTO polubg_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ezaw powiedział więc do Jakuba: Daj mi jeść, proszę cię, z tej czerwonej potrawy, bo jestem spracowany. Dlatego nadano mu imię Edom. ");
INSERT INTO polubg_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jakub powiedział: Sprzedaj mi dziś twoje pierworództwo. ");
INSERT INTO polubg_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","A Ezaw odpowiedział: Oto jestem bliski śmierci, na cóż mi pierworództwo? ");
INSERT INTO polubg_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakub powiedział: Przysięgnij mi dziś. Przysiągł mu więc i sprzedał Jakubowi swoje pierworództwo. ");
INSERT INTO polubg_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jakub dał więc Ezawowi chleba i potrawę z soczewicy, a on jadł i pił, a potem powstał i poszedł. W ten sposób Ezaw pogardził swoim pierworództwem. ");
INSERT INTO polubg_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Potem nastał głód na ziemi, po tym pierwszym głodzie, który był za dni Abrahama. Izaak udał się więc do Abimeleka, króla Filistynów, do Geraru. ");
INSERT INTO polubg_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Wtedy PAN ukazał mu się i powiedział: Nie idź do Egiptu, ale mieszkaj w ziemi, którą ci wskażę. ");
INSERT INTO polubg_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Bądź przybyszem w tej ziemi, a ja będę z tobą i będę ci błogosławił. Tobie bowiem i twemu potomstwu dam te wszystkie krainy i dotrzymam przysięgi, którą złożyłem twemu ojcu Abrahamowi. ");
INSERT INTO polubg_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I rozmnożę twoje potomstwo jak gwiazdy na niebie, i dam twemu potomstwu wszystkie te krainy. A będą błogosławione w twoim potomstwie wszystkie narody ziemi; ");
INSERT INTO polubg_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Dlatego że Abraham posłuchał mego głosu i strzegł mego nakazu, moich przykazań, moich ustaw i moich praw. ");
INSERT INTO polubg_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Izaak zamieszkał więc w Gerarze. ");
INSERT INTO polubg_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","A gdy mężczyźni tego miejsca pytali o jego żonę, odpowiedział: To moja siostra. Bał się bowiem mówić: To moja żona, by mężczyźni tego miejsca nie zabili go z powodu Rebeki, bo była bardzo piękna. ");
INSERT INTO polubg_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Gdy mieszkał tam już dłuższy czas, król Filistynów Abimelek wyjrzał przez okno i zobaczył, że Izaak pieścił swą żonę Rebekę. ");
INSERT INTO polubg_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelek wezwał więc Izaaka i powiedział: To jest na pewno twoja żona. Dlaczego mówiłeś: To moja siostra? Izaak mu odpowiedział: Bo mówiłem sobie: Abym nie umarł z jej powodu. ");
INSERT INTO polubg_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelek powiedział: Coś ty nam zrobił? Mało brakowało, a ktoś z ludu spałby z twoją żoną i tak sprowadziłbyś na nas grzech. ");
INSERT INTO polubg_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Rozkazał więc Abimelek całemu ludowi: Kto by dotknął tego człowieka albo jego żony, na pewno umrze. ");
INSERT INTO polubg_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Wówczas Izaak posiał w tej ziemi i zebrał w tym roku stokrotny plon, bo PAN mu błogosławił. ");
INSERT INTO polubg_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","I wzbogacił się ów człowiek, i rozwijał się coraz bardziej, aż stał się bardzo zamożny. ");
INSERT INTO polubg_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Miał trzody owiec i stada wołów oraz wiele sług, tak że Filistyni mu zazdrościli. ");
INSERT INTO polubg_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","I wszystkie studnie, które wykopali słudzy jego ojca, za dni jego ojca Abrahama, Filistyni zasypali i napełnili je ziemią. ");
INSERT INTO polubg_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","I Abimelek powiedział do Izaaka: Odejdź od nas, bo jesteś dużo zamożniejszy od nas. ");
INSERT INTO polubg_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Izaak odszedł więc stamtąd i rozbił namioty w dolinie Gerar, i tam zamieszkał. ");
INSERT INTO polubg_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Potem Izaak na nowo odkopał studnie, które wykopali za dni jego ojca Abrahama, a które Filistyni zasypali po śmierci Abrahama, i nadał im te same nazwy, jakie nadał im jego ojciec. ");
INSERT INTO polubg_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Wtedy słudzy Izaaka kopali w tej dolinie i znaleźli tam studnię ze źródlaną wodą. ");
INSERT INTO polubg_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Lecz pasterze z Geraru kłócili się z pasterzami Izaaka, mówiąc: To nasza woda. Nazwał więc tę studnię Esek, bo spierali się z nim. ");
INSERT INTO polubg_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Gdy wykopali drugą studnię, również kłócili się o nią. Dlatego nazwał ją Sitna. ");
INSERT INTO polubg_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Potem przeniósł się stamtąd i wykopał kolejną studnię, o którą już nie było sporu. Nazwał ją więc Rechobot i mówił: Oto teraz PAN dał nam miejsce, abyśmy się rozmnażali na ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","I wyruszył stamtąd do Beer-Szeby. ");
INSERT INTO polubg_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Tej nocy ukazał mu się PAN i powiedział: Ja jestem Bogiem twego ojca Abrahama. Nie bój się, bo jestem z tobą. Będę ci błogosławił i rozmnożę twoje potomstwo ze względu na mego sługę Abrahama. ");
INSERT INTO polubg_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Zbudował więc tam ołtarz i wzywał imienia PANA, i rozbił tam swój namiot. Tam też słudzy Izaaka wykopali studnię. ");
INSERT INTO polubg_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Wtedy przybyli do niego z Geraru Abimelek i Achuzat, jeden z jego przyjaciół, oraz dowódca jego wojska Pikol. ");
INSERT INTO polubg_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Izaak zapytał ich: Po co przybyliście do mnie, skoro mnie nienawidzicie i wypędziliście mnie od siebie? ");
INSERT INTO polubg_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","A oni odpowiedzieli: Zobaczyliśmy naprawdę, że PAN jest z tobą, więc powiedzieliśmy: Niech będzie teraz przysięga między nami, między nami a tobą, i ustanowimy przymierze z tobą; ");
INSERT INTO polubg_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Abyś nam nie czynił nic złego, jak i my też nie dotknęliśmy ciebie i tylko dobrze ci czyniliśmy, i pozwoliliśmy ci odejść w pokoju; a ty teraz jesteś błogosławiony przez PANA. ");
INSERT INTO polubg_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Wtedy wyprawił im ucztę; jedli więc i pili. ");
INSERT INTO polubg_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nazajutrz wstali wcześnie rano i złożyli sobie wzajemnie przysięgę. Potem Izaak pożegnał się z nimi i odeszli od niego w pokoju. ");
INSERT INTO polubg_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Tego samego dnia słudzy Izaaka przyszli i opowiedzieli mu o studni, którą wykopali: Znaleźliśmy wodę. ");
INSERT INTO polubg_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","I nazwał ją Szibea. Dlatego to miasto nazywa się Beer-Szeba aż do dzisiaj. ");
INSERT INTO polubg_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Gdy Ezaw miał czterdzieści lat, pojął sobie za żonę Judytę, córkę Beeriego Chetyty, i Bosmat, córkę Elona Chetyty. ");
INSERT INTO polubg_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Były one przyczyną utrapień Izaaka i Rebeki. ");
INSERT INTO polubg_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","A gdy Izaak się zestarzał i jego oczy osłabły, tak że nie mógł widzieć, wezwał swego starszego syna Ezawa i powiedział do niego: Synu mój! A on odpowiedział: Oto jestem. ");
INSERT INTO polubg_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Izaak powiedział: Oto zestarzałem się już i nie znam dnia swojej śmierci. ");
INSERT INTO polubg_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Teraz więc weź, proszę, swoją broń, kołczan i łuk, wyjdź na pole i upoluj mi zwierzynę. ");
INSERT INTO polubg_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","I przygotuj mi smaczną potrawę, jaką lubię, i przynieś mi ją, a będę jadł, aby moja dusza błogosławiła ci, zanim umrę. ");
INSERT INTO polubg_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","A Rebeka słyszała, gdy Izaak mówił do swego syna Ezawa. I Ezaw wyszedł na pole, aby upolować zwierzynę i ją przynieść. ");
INSERT INTO polubg_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","I Rebeka powiedziała do swego syna Jakuba: Słyszałam, jak twój ojciec mówił do twego brata Ezawa: ");
INSERT INTO polubg_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Przynieś mi zwierzynę i przygotuj mi smaczną potrawę, abym jadł i błogosławił ci przed PANEM, zanim umrę. ");
INSERT INTO polubg_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Teraz więc, mój synu, posłuchaj mego głosu w tym, co ci każę. ");
INSERT INTO polubg_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Idź do trzody i przynieś mi stamtąd dwoje dobrych koźląt, a przygotuję z nich dla twego ojca smaczną potrawę, jaką lubi. ");
INSERT INTO polubg_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","I zaniesiesz twemu ojcu, i będzie jadł, aby ci błogosławił, zanim umrze. ");
INSERT INTO polubg_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Wtedy Jakub powiedział do swej matki Rebeki: Przecież mój brat Ezaw jest człowiekiem owłosionym, a ja jestem człowiekiem gładkim; ");
INSERT INTO polubg_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Jeśli mój ojciec mnie dotknie, okażę się w jego oczach oszustem, ściągnę na siebie przekleństwo, a nie błogosławieństwo. ");
INSERT INTO polubg_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Jego matka odpowiedziała mu: Mój synu, niech na mnie spadnie twoje przekleństwo. Tylko posłuchaj mego głosu, idź i przynieś mi je. ");
INSERT INTO polubg_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Poszedł więc, wziął i przyniósł je swej matce, a ona przygotowała smaczną potrawę, jaką lubił jego ojciec. ");
INSERT INTO polubg_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Potem Rebeka wzięła szaty swego starszego syna Ezawa, najcenniejsze, jakie miała u siebie w domu, i ubrała w nie swego młodszego syna Jakuba. ");
INSERT INTO polubg_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","A skórkami koźląt owinęła mu ręce i gładką szyję. ");
INSERT INTO polubg_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","I dała chleb i smaczną potrawę, którą przygotowała, w ręce swego syna Jakuba. ");
INSERT INTO polubg_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","A on poszedł do swego ojca i powiedział: Mój ojcze! A on odpowiedział: Oto jestem. Kto ty jesteś, mój synu? ");
INSERT INTO polubg_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakub odpowiedział swemu ojcu: Ja jestem Ezaw, twój pierworodny. Zrobiłem, jak mi kazałeś. Podnieś się, proszę, siądź i jedz z mojej zwierzyny, aby mi błogosławiła twoja dusza. ");
INSERT INTO polubg_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Izaak zapytał swego syna: Jakże tak szybko to znalazłeś, mój synu? A on odpowiedział: To PAN, twój Bóg, sprawił, że mi się udało. ");
INSERT INTO polubg_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Potem Izaak powiedział do Jakuba: Zbliż się, proszę, abym cię dotknął, mój synu, czy ty jesteś moim synem Ezawem, czy nie. ");
INSERT INTO polubg_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakub podszedł więc do swego ojca Izaaka, który dotknął go i powiedział: Głos jest głosem Jakuba, ale ręce są rękami Ezawa. ");
INSERT INTO polubg_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","I nie rozpoznał go, bo jego ręce były owłosione jak ręce jego brata Ezawa. I błogosławił mu. ");
INSERT INTO polubg_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","I zapytał: Czy ty jesteś moim synem Ezawem? A on odpowiedział: Jestem. ");
INSERT INTO polubg_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Potem powiedział: Podaj mi, żebym jadł ze zwierzyny mego syna, aby błogosławiła ci moja dusza. Wtedy podał mu i jadł. Przyniósł mu też wina, a on pił. ");
INSERT INTO polubg_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Jego ojciec Izaak powiedział mu: Podejdź teraz i pocałuj mnie, mój synu. ");
INSERT INTO polubg_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Podszedł więc i pocałował go. Gdy poczuł zapach jego szat, błogosławił mu, mówiąc: Oto zapach mego syna jak zapach pola, które PAN błogosławił. ");
INSERT INTO polubg_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Niech Bóg da ci z rosy nieba i żyzność ziemi oraz obfitość zboża i wina. ");
INSERT INTO polubg_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Niech ludzie ci służą i niech ci się kłaniają narody. Bądź panem twoich braci i niech ci się kłaniają synowie twojej matki. Niech będzie przeklęty, kto cię przeklina, a niech będzie błogosławiony, kto cię błogosławi. ");
INSERT INTO polubg_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Gdy Izaak skończył błogosławić Jakuba i ledwie Jakub odszedł sprzed oblicza swego ojca Izaaka, jego brat Ezaw wszedł z łowów. ");
INSERT INTO polubg_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","On także przygotował smaczną potrawę, przyniósł ją swemu ojcu i powiedział mu: Podnieś się, mój ojcze, i jedz ze zwierzyny twego syna, aby błogosławiła mi twoja dusza. ");
INSERT INTO polubg_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Jego ojciec Izaak zapytał go: Kim jesteś? A on odpowiedział: Jestem twoim synem, twoim pierworodnym, Ezawem. ");
INSERT INTO polubg_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Wtedy Izaak bardzo się przeraził i zapytał: Któż to? A gdzie jest ten, co ułowił zwierzynę i przyniósł mi, a ja jadłem ze wszystkiego, zanim ty przyszedłeś, i błogosławiłem mu? Będzie więc błogosławionym. ");
INSERT INTO polubg_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","A gdy Ezaw usłyszał słowa swego ojca, podniósł donośny krzyk pełen goryczy i powiedział swemu ojcu: Błogosław też i mi, mój ojcze. ");
INSERT INTO polubg_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","A on mu powiedział: Twój brat podstępnie przyszedł i wziął twoje błogosławieństwo. ");
INSERT INTO polubg_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ezaw powiedział: Czy nie słusznie nadano mu imię Jakub? Podszedł mnie bowiem już dwukrotnie: wziął moje pierworództwo, a teraz zabrał moje błogosławieństwo. I zapytał: Czy nie zachowałeś dla mnie błogosławieństwa? ");
INSERT INTO polubg_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Izaak odpowiedział Ezawowi: Ustanowiłem go panem nad tobą i wszystkich jego braci dałem mu za sługi, i zapewniłem mu zboże i wino. Cóż więc mogę dla ciebie zrobić, mój synu? ");
INSERT INTO polubg_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","I Ezaw powiedział do swego ojca: Czy masz tylko jedno błogosławieństwo, mój ojcze? Błogosław także i mnie, mój ojcze. I Ezaw podniósł głos i zapłakał. ");
INSERT INTO polubg_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","I jego ojciec Izaak odpowiedział mu: Twoje mieszkanie będzie z żyznej ziemi i z rosy nieba z góry. ");
INSERT INTO polubg_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","A będziesz żył z twego miecza i będziesz służył twemu bratu. Ale gdy stanie się, że będziesz panował, zrzucisz jego jarzmo z twojej szyi. ");
INSERT INTO polubg_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Dlatego Ezaw nienawidził Jakuba z powodu błogosławieństwa, którym mu błogosławił jego ojciec. I Ezaw mówił w swym sercu: Zbliżają się dni żałoby po moim ojcu, wtedy zabiję mego brata Jakuba. ");
INSERT INTO polubg_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","I doniesiono Rebece o słowach jej starszego syna Ezawa. Kazała więc przywołać swego młodszego syna Jakuba i powiedziała do niego: Oto twój brat Ezaw pociesza się tym, że cię zabije. ");
INSERT INTO polubg_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Teraz więc, mój synu, posłuchaj mego głosu, wstań i uciekaj do mego brata Labana, do Charanu; ");
INSERT INTO polubg_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Pozostań u niego przez pewien czas, aż ucichnie gniew twego brata; ");
INSERT INTO polubg_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Aż ustąpi zapalczywość twego brata na ciebie i zapomni o tym, co mu zrobiłeś. Wtedy każę cię stamtąd sprowadzić. Czemu mam być pozbawiona was obu w jednym dniu? ");
INSERT INTO polubg_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","I Rebeka powiedziała do Izaaka: Obrzydło mi życie z powodu córek Cheta. Jeśli Jakub też weźmie sobie żonę z córek Cheta, jakie są na tej ziemi, po co mi życie? ");
INSERT INTO polubg_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Wtedy Izaak wezwał Jakuba i błogosławił mu, i rozkazał: Nie bierz sobie żony z córek Kanaanu. ");
INSERT INTO polubg_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ale wstań i idź do krainy Paddan-Aram, do domu Betuela, ojca twojej matki, i weź sobie stamtąd żonę z córek Labana, brata twojej matki. ");
INSERT INTO polubg_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","A Bóg Wszechmogący niech ci błogosławi i niech cię uczyni płodnym i rozmnoży, abyś stał się licznym ludem; ");
INSERT INTO polubg_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","I niech ci da błogosławieństwo Abrahama, tobie i twemu potomstwu z tobą, abyś odziedziczył ziemię, na której jesteś przybyszem, którą Bóg dał Abrahamowi. ");
INSERT INTO polubg_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","I tak Izaak wysłał Jakuba, który udał się do krainy Paddan-Aram, do Labana, syna Betuela, Syryjczyka, brata Rebeki, matki Jakuba i Ezawa. ");
INSERT INTO polubg_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","A Ezaw widział, że Izaak błogosławił Jakubowi i posłał go do krainy Paddan-Aram, aby stamtąd wziął sobie żonę, i że błogosławiąc mu, przykazał: Nie weźmiesz żony z córek Kanaanu; ");
INSERT INTO polubg_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","I że Jakub był posłuszny swemu ojcu oraz swojej matce, i poszedł do krainy Paddan-Aram; ");
INSERT INTO polubg_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Widział też Ezaw, że córki Kanaanu nie podobają się jego ojcu Izaakowi; ");
INSERT INTO polubg_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Wtedy Ezaw poszedł do Izmaela i oprócz żon, które już miał, wziął za żonę Machalat, córkę Izmaela, syna Abrahama, siostrę Nebajota. ");
INSERT INTO polubg_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","A Jakub wyszedł z Beer-Szeby i udał się do Charanu. ");
INSERT INTO polubg_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Przyszedł na pewne miejsce i tam nocował, bo słońce już zaszło. Wziął jeden z kamieni z tego miejsca, podłożył go sobie pod głowę i zasnął na tym miejscu. ");
INSERT INTO polubg_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","I śniło mu się, że na ziemi stała drabina, a jej szczyt sięgał nieba. A oto aniołowie Boży wstępowali i zstępowali po niej. ");
INSERT INTO polubg_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","A PAN stał nad nią i powiedział: Ja jestem PAN, Bóg twego ojca Abrahama i Bóg Izaaka. Ziemię, na której leżysz, dam tobie i twemu potomstwu. ");
INSERT INTO polubg_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","A twoje potomstwo będzie jak proch ziemi i rozprzestrzenisz się na zachód i na wschód, na północ i na południe. A w tobie i w twoim potomstwie będą błogosławione wszystkie narody ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Oto ja jestem z tobą i będę cię strzegł, gdziekolwiek pójdziesz, i przyprowadzę cię z powrotem do tej ziemi. Bo nie opuszczę cię, aż spełnię to, co ci obiecałem. ");
INSERT INTO polubg_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Gdy Jakub zbudził się ze snu, powiedział: Naprawdę PAN jest na tym miejscu, a ja o tym nie wiedziałem. ");
INSERT INTO polubg_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","I przestraszył się, i powiedział: O, jakie straszne to miejsce! To nie może być nic innego jak dom Boży i brama nieba. ");
INSERT INTO polubg_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","I Jakub wstał wcześnie rano, wziął kamień, który podłożył sobie pod głowę i postawił go na znak, i nalał oliwy na jego wierzch. ");
INSERT INTO polubg_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","I nadał temu miejscu nazwę Betel, lecz przedtem miasto nazywało się Luz. ");
INSERT INTO polubg_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Wtedy Jakub złożył ślub, mówiąc: Jeśli Bóg będzie ze mną i będzie mnie strzegł na tej drodze, którą idę, jeśli da mi chleb do jedzenia i odzież do ubrania; ");
INSERT INTO polubg_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","I jeśli wrócę w pokoju do domu mego ojca, to PAN będzie moim Bogiem. ");
INSERT INTO polubg_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","A ten kamień, który postawiłem na znak, będzie domem Bożym. I ze wszystkiego, co mi dasz, będę ci na pewno oddawał dziesięcinę. ");
INSERT INTO polubg_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Wtedy Jakub wyruszył w drogę i poszedł do ziemi ludów Wschodu. ");
INSERT INTO polubg_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","I spojrzał, a oto w polu studnia i trzy stada owiec leżących przy niej. Z tej studni pojono bowiem stada, a wielki kamień przykrywał wierzch tej studni. ");
INSERT INTO polubg_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","A gdy schodziły się wszystkie stada, odsuwano kamień z wierzchu studni i pojono owce. Potem znów zasuwano kamień na wierzch studni na jego miejsce. ");
INSERT INTO polubg_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakub zapytał ich: Moi bracia, skąd jesteście? I odpowiedzieli: Jesteśmy z Charanu. ");
INSERT INTO polubg_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Zapytał ich: Czy znacie Labana, syna Nachora? Odpowiedzieli: Znamy. ");
INSERT INTO polubg_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Potem zapytał: Czy dobrze się miewa? A oni odpowiedzieli: Dobrze. Oto właśnie jego córka Rachela nadchodzi ze stadem. ");
INSERT INTO polubg_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Wtedy powiedział: Oto jeszcze jest jasny dzień i nie czas zganiać stada. Napójcie owce i idźcie, popaście je. ");
INSERT INTO polubg_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Oni odpowiedzieli: Nie możemy, dopóki nie zbiorą się wszystkie stada i nie odsuną kamienia z wierzchu studni. Wtedy napoimy stada. ");
INSERT INTO polubg_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","A gdy jeszcze tak z nimi rozmawiał, nadeszła Rachela z owcami swego ojca, bo je pasła. ");
INSERT INTO polubg_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","I gdy Jakub ujrzał Rachelę, córkę Labana, brata swej matki, z owcami Labana, brata swej matki, podszedł, odsunął kamień z wierzchu studni i napoił owce Labana, brata swojej matki. ");
INSERT INTO polubg_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Potem Jakub pocałował Rachelę i głośno zapłakał. ");
INSERT INTO polubg_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","I Jakub powiedział Racheli, że jest bratem jej ojca i że jest synem Rebeki. Ona pobiegła więc i oznajmiła to swemu ojcu. ");
INSERT INTO polubg_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","A gdy Laban usłyszał wieść o Jakubie, synu swojej siostry, wybiegł mu naprzeciw, objął go, ucałował i zaprowadził do swego domu. A on opowiedział Labanowi o wszystkim. ");
INSERT INTO polubg_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Wtedy Laban powiedział mu: Ty naprawdę jesteś z moich kości i z mojego ciała. I Jakub mieszkał u niego przez cały miesiąc. ");
INSERT INTO polubg_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Potem Laban powiedział do Jakuba: Czyż dlatego, że jesteś moim bratem, będziesz mi służyć za darmo? Powiedz mi, jaka ma być twoja zapłata. ");
INSERT INTO polubg_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","A Laban miał dwie córki: starsza miała na imię Lea, młodsza zaś Rachela. ");
INSERT INTO polubg_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea miała czułe oczy, Rachela zaś była piękna i miła dla oka. ");
INSERT INTO polubg_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakub kochał Rachelę i powiedział: Będę ci służył siedem lat za twoją młodszą córkę Rachelę. ");
INSERT INTO polubg_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban odpowiedział: Lepiej mi ją dać tobie niż innemu mężczyźnie. Zamieszkaj ze mną. ");
INSERT INTO polubg_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","I Jakub służył za Rachelę siedem lat, które wydawały mu się jak kilka dni, bo ją kochał. ");
INSERT INTO polubg_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Potem Jakub powiedział do Labana: Daj mi moją żonę, bo wypełniły się moje dni, abym z nią obcował. ");
INSERT INTO polubg_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Wtedy Laban zebrał wszystkich mężczyzn tego miejsca i wyprawił ucztę. ");
INSERT INTO polubg_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","A gdy nastał wieczór, wziął swoją córkę Leę i wprowadził ją do Jakuba, a on obcował z nią. ");
INSERT INTO polubg_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban dał też swoją służącą Zilpę swej córce Lei za służącą. ");
INSERT INTO polubg_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Rano okazało się, że to była Lea. Powiedział więc do Labana: Cóż mi zrobiłeś? Czy nie za Rachelę ci służyłem? Dlaczego mnie oszukałeś? ");
INSERT INTO polubg_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban odpowiedział: Nie ma u nas zwyczaju, aby młodszą wydawać za mąż przed starszą. ");
INSERT INTO polubg_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Dopełnij jej tydzień, a dam ci i tę za służbę, którą mi odsłużysz drugie siedem lat. ");
INSERT INTO polubg_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","I Jakub tak zrobił, i dopełnił jej tydzień. Potem Laban dał mu swoją córkę Rachelę za żonę. ");
INSERT INTO polubg_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban dał też swoją służącą Bilhę swej córce Racheli za służącą. ");
INSERT INTO polubg_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Wtedy Jakub obcował też z Rachelą i kochał Rachelę bardziej niż Leę, i służył mu jeszcze drugie siedem lat. ");
INSERT INTO polubg_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","A gdy PAN widział, że Lea była znienawidzona, otworzył jej łono. Rachela zaś była bezpłodna. ");
INSERT INTO polubg_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea poczęła więc i urodziła syna, i nadała mu imię Ruben. Powiedziała bowiem: PAN naprawdę wejrzał na moje utrapienie. Dlatego teraz mój mąż będzie mnie kochać. ");
INSERT INTO polubg_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Gdy znów poczęła i urodziła syna, powiedziała: PAN usłyszał, że byłam znienawidzona. Dlatego dał mi także tego syna. I nadała mu imię Symeon. ");
INSERT INTO polubg_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Potem znów poczęła i urodziła syna, i powiedziała: Tym razem mój mąż przywiąże się do mnie, bo urodziłam mu trzech synów. Dlatego nadała mu imię Lewi. ");
INSERT INTO polubg_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Gdy jeszcze raz poczęła i urodziła syna, powiedziała: Teraz już będę chwalić PANA. Dlatego nadała mu imię Juda. I przestała rodzić. ");
INSERT INTO polubg_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Gdy Rachela widziała, że nie rodzi dzieci Jakubowi, zazdrościła swej siostrze i powiedziała do Jakuba: Daj mi dzieci, bo inaczej umrę. ");
INSERT INTO polubg_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakub rozgniewał się na Rachelę i powiedział: Czy ja jestem Bogiem, który odmówił ci owocu twego łona? ");
INSERT INTO polubg_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","A ona odpowiedziała: Oto moja służąca Bilha. Obcuj z nią i urodzi na moich kolanach, i będę miała z niej dzieci. ");
INSERT INTO polubg_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Dała mu więc swoją służącą Bilhę za żonę, a Jakub z nią obcował. ");
INSERT INTO polubg_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha poczęła i urodziła Jakubowi syna. ");
INSERT INTO polubg_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","I Rachela powiedziała: Bóg mnie osądził i usłyszał mój głos, i dał mi syna. Dlatego nadała mu imię Dan. ");
INSERT INTO polubg_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Potem Bilha, służąca Racheli, znowu poczęła i urodziła Jakubowi drugiego syna. ");
INSERT INTO polubg_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Wtedy Rachela powiedziała: Dzielnie walczyłam z moją siostrą i zwyciężyłam. I nadała mu imię Neftali. ");
INSERT INTO polubg_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","A gdy Lea widziała, że przestała rodzić, wzięła swoją służącą Zilpę i dała ją Jakubowi za żonę. ");
INSERT INTO polubg_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","I Zilpa, służąca Lei, urodziła Jakubowi syna. ");
INSERT INTO polubg_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Wtedy Lea powiedziała: Przyszedł oddział. I nadała mu imię Gad. ");
INSERT INTO polubg_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Potem Zilpa, służąca Lei, urodziła Jakubowi drugiego syna. ");
INSERT INTO polubg_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","I Lea powiedziała: To na moje szczęście, bo kobiety będą mnie nazywać szczęśliwą. I nadała mu imię Aszer. ");
INSERT INTO polubg_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","A w czasie żniwa pszenicznego Ruben wyszedł i znalazł na polu mandragory, i przyniósł je do swojej matki Lei. Wtedy Rachela powiedziała do Lei: Daj mi, proszę, z mandragor twego syna. ");
INSERT INTO polubg_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","A ona jej odpowiedziała: Mało ci, że zabrałaś mi mojego męża, to teraz chcesz też zabrać mandragory mego syna? Wtedy Rachela powiedziała: Niech śpi z tobą tej nocy za mandragory twego syna. ");
INSERT INTO polubg_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","A gdy Jakub wracał wieczorem z pola, Lea wyszła mu naprzeciw i powiedziała: Masz do mnie przyjść, bo nabyłam cię za mandragory mego syna. I spał z nią tej nocy. ");
INSERT INTO polubg_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","A Bóg wysłuchał Leę i poczęła, i urodziła Jakubowi piątego syna. ");
INSERT INTO polubg_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","I Lea powiedziała: Bóg mi oddał moją zapłatę za to, że dałam moją służącą swemu mężowi. I nadała mu imię Issachar. ");
INSERT INTO polubg_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Potem Lea znowu poczęła i urodziła Jakubowi szóstego syna. ");
INSERT INTO polubg_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","I Lea mówiła: Bóg obdarzył mnie wspaniałym darem. Teraz mój mąż będzie ze mną mieszkał, bo urodziłam mu sześciu synów. I nadała mu imię Zebulon. ");
INSERT INTO polubg_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Potem urodziła córkę i nadała jej imię Dina. ");
INSERT INTO polubg_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Bóg wspomniał też na Rachelę i wysłuchał ją Bóg, i otworzył jej łono. ");
INSERT INTO polubg_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Poczęła więc i urodziła syna, i powiedziała: Bóg zabrał moją hańbę. ");
INSERT INTO polubg_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Nadała mu imię Józef i powiedziała: Niech PAN da mi drugiego syna. ");
INSERT INTO polubg_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Gdy Rachela urodziła Józefa, Jakub powiedział do Labana: Puść mnie, abym wrócił do mego miejsca i do mojej ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Daj mi moje żony i moje dzieci, za które ci służyłem, abym mógł iść. Wiesz przecież, jak ci służyłem. ");
INSERT INTO polubg_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","I Laban powiedział do niego: Proszę, jeśli znalazłem łaskę w twoich oczach, zostań ze mną. Doznałem bowiem tego, że PAN mi błogosławił ze względu na ciebie. ");
INSERT INTO polubg_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Mówił dalej: Wyznacz swoją zapłatę, a dam ci ją. ");
INSERT INTO polubg_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Wtedy Jakub mu odpowiedział: Ty wiesz, jak ci służyłem i jaki stał się przy mnie twój dobytek. ");
INSERT INTO polubg_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Miałeś bowiem niewiele przed moim przyjściem, a bardzo się to pomnożyło i PAN błogosławił ci, odkąd tu jestem. Kiedy jednak mam się starać o swój dom? ");
INSERT INTO polubg_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","I Laban zapytał: Cóż mam ci dać? Jakub odpowiedział: Nic mi nie dasz. Ale jeśli zrobisz to, co ci powiem, wtedy wrócę i będę pasł twoje stado, i strzegł go. ");
INSERT INTO polubg_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Obejdę dziś wszystkie twoje stada i odłączę z nich każde bydło pstre i nakrapiane i każde bydło ciemne wśród owiec, a nakrapiane i pstre wśród kóz. To będzie moja zapłata. ");
INSERT INTO polubg_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Potem moja sprawiedliwość da świadectwo o mnie, gdy przyjdzie czas, abyś mi zapłacił. Wszystko, co nie będzie pstre i nakrapiane wśród kóz, a ciemne wśród owiec, niech będzie mi poczytane za kradzież. ");
INSERT INTO polubg_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban powiedział: Niech się stanie według twego słowa. ");
INSERT INTO polubg_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","W tym dniu odłączył kozły prążkowane i nakrapiane i wszystkie kozy pstre i nakrapiane, i wszystkie, które miały jakąś białą plamkę, także i czarne wśród owiec, i oddał je w ręce swych synów. ");
INSERT INTO polubg_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","I Laban odłączył się od Jakuba na odległość trzech dni drogi. A Jakub pasł resztę stada Labana. ");
INSERT INTO polubg_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Wtedy Jakub nabrał zielonych prętów topolowych, laskowych i kasztanowych i miejscami poobdzierał je z kory do białego, obnażając białość, która była na prętach. ");
INSERT INTO polubg_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Gdy stada przychodziły pić, przed stadami nakładł do rynien i koryt z wodą tych prętów, które poobdzierał z kory, aby parzyły się stada, przychodząc pić. ");
INSERT INTO polubg_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","I stada parzyły się przy tych prętach i rodziły jagnięta prążkowane, pstre i nakrapiane. ");
INSERT INTO polubg_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","I Jakub odłączył jagnięta, a owce stawiał przodem do jagniąt prążkowanych i do wszystkich ciemnych w stadzie Labana, a swoje stada stawiał osobno i nie łączył ich ze stadem Labana. ");
INSERT INTO polubg_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","A gdy silniejsze zwierzęta się parzyły, Jakub kładł pręty w koryta, przed oczy zwierząt, aby parzyły się przed prętami. ");
INSERT INTO polubg_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Lecz gdy przychodziły słabsze zwierzęta, nie kładł ich. I słabsze były Labana, a silniejsze Jakuba. ");
INSERT INTO polubg_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","I tak wzbogacił się bardzo ten człowiek, i miał wiele stad, a także służące i służących oraz wielbłądy i osły. ");
INSERT INTO polubg_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Potem Jakub usłyszał, jak synowie Labana mówili: Jakub zabrał wszystko, co należało do naszego ojca, i z tego, co było naszego ojca, zdobył całe to bogactwo. ");
INSERT INTO polubg_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jakub widział też oblicze Labana, że nie było w stosunku do niego takie jak wcześniej. ");
INSERT INTO polubg_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Wtedy PAN powiedział do Jakuba: Wróć do ziemi swoich ojców i do swojej rodziny, a będę z tobą. ");
INSERT INTO polubg_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jakub kazał więc przywołać Rachelę i Leę na pole do swojego stada. ");
INSERT INTO polubg_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","I powiedział im: Widzę oblicze waszego ojca, że nie jest w stosunku do mnie takie jak wcześniej, ale Bóg mego ojca był ze mną. ");
INSERT INTO polubg_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Wy też same wiecie, że ze wszystkich moich sił służyłem waszemu ojcu; ");
INSERT INTO polubg_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ale wasz ojciec oszukał mnie i dziesięć razy zmieniał moją zapłatę. Bóg jednak nie pozwolił mu skrzywdzić mnie. ");
INSERT INTO polubg_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Jeśli powiedział: Pstre będą twoją zapłatą, to wszystkie stada rodziły pstre; a gdy mówił: Prążkowane będą twoją zapłatą, to wszystkie stada rodziły prążkowane. ");
INSERT INTO polubg_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","W ten sposób Bóg odebrał dobytek waszemu ojcu i dał go mnie. ");
INSERT INTO polubg_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Gdy bowiem był czas parzenia się stad, podniosłem swe oczy i widziałem we śnie, że samce łączyły się z bydłami prążkowanymi, pstrymi i biało nakrapianymi. ");
INSERT INTO polubg_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Wtedy Anioł Boga powiedział mi we śnie: Jakubie! A ja odpowiedziałem: Oto jestem. ");
INSERT INTO polubg_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Potem powiedział: Podnieś teraz swe oczy i zobacz wszystkie samce łączące się z owcami prążkowanymi, pstrymi i biało nakrapianymi. Widziałem bowiem wszystko, co Laban ci uczynił. ");
INSERT INTO polubg_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ja jestem Bogiem z Betel, gdzie namaściłeś kamień i gdzie złożyłeś mi ślub. Teraz więc wstań, wyjdź z tej ziemi i wróć do ziemi twojej rodziny. ");
INSERT INTO polubg_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","I Rachela, i Lea odpowiedziały mu: Czy mamy jeszcze jakąś cząstkę i dziedzictwo w domu naszego ojca? ");
INSERT INTO polubg_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Czy nie jesteśmy uważane u niego za obce? Sprzedał nas bowiem i jeszcze przejadł nasz majątek. ");
INSERT INTO polubg_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Bo całe bogactwo, które Bóg odebrał naszemu ojcu, jest nasze i naszych synów. Dlatego teraz zrób wszystko, co ci Bóg rozkazał. ");
INSERT INTO polubg_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Jakub wstał więc i wsadził swych synów i swe żony na wielbłądy. ");
INSERT INTO polubg_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","I zabrał całe swoje stado i cały swój majątek, który zdobył, swój dobytek, który nabył w Paddan-Aram, aby wrócić do swego ojca Izaaka, do ziemi Kanaan. ");
INSERT INTO polubg_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Gdy Laban odszedł strzyc swoje owce, Rachela ukradła posążki należące do jej ojca. ");
INSERT INTO polubg_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","I Jakub wykradł się potajemnie od Labana Syryjczyka, nie oznajmiając mu, że ucieka. ");
INSERT INTO polubg_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Uciekł więc ze wszystkim, co miał. Wstał i przeprawił się przez rzekę, i udał się ku górze Gilead. ");
INSERT INTO polubg_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","A trzeciego dnia doniesiono Labanowi, że Jakub uciekł. ");
INSERT INTO polubg_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Wziął więc ze sobą swoich braci, gonił go przez siedem dni i doścignął go na górze Gilead. ");
INSERT INTO polubg_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Lecz Bóg przyszedł do Labana Syryjczyka tej nocy we śnie i powiedział mu: Strzeż się, abyś nie mówił do Jakuba ani dobrze, ani źle. ");
INSERT INTO polubg_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban dogonił Jakuba, gdy Jakub rozbił swój namiot na górze. Laban ze swoimi braćmi też rozbił namiot na górze Gilead. ");
INSERT INTO polubg_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Wtedy Laban powiedział do Jakuba: Coś ty zrobił, że się wykradłeś potajemnie ode mnie i uprowadziłeś moje córki jak pojmane mieczem? ");
INSERT INTO polubg_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Dlaczego potajemnie uciekłeś i wykradłeś się ode mnie, i nic mi nie powiedziałeś, abym mógł wyprawić cię z radością, z pieśniami, z bębnem i harfą? ");
INSERT INTO polubg_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","I nie pozwoliłeś mi ucałować moich synów i moich córek? Naprawdę głupio postąpiłeś. ");
INSERT INTO polubg_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Jest to w mocy mojej ręki, aby zrobić wam coś złego, ale Bóg waszego ojca powiedział mi zeszłej nocy: Strzeż się, abyś nie mówił do Jakuba ani dobrze, ani źle. ");
INSERT INTO polubg_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","A teraz, gdy chciałeś odejść, bo bardzo tęskniłeś za domem twego ojca, dlaczego ukradłeś moje bożki? ");
INSERT INTO polubg_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","I Jakub odpowiedział Labanowi: Bałem się, bo myślałem, że siłą odbierzesz mi twoje córki. ");
INSERT INTO polubg_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Lecz ten, u kogo znajdziesz twoje bożki, niech umrze. Sprawdź w obecności naszych braci, czy coś twojego jest u mnie, i weź sobie. Jakub nie wiedział bowiem, że Rachela je ukradła. ");
INSERT INTO polubg_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban wszedł więc do namiotu Jakuba i do namiotu Lei, a także do namiotu obu służących, ale nic nie znalazł. Gdy wyszedł z namiotu Lei, wszedł do namiotu Racheli. ");
INSERT INTO polubg_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","A Rachela wzięła posążki, włożyła je pod siodło wielbłądzie i usiadła na nich. Laban przeszukał cały namiot, ale nic nie znalazł. ");
INSERT INTO polubg_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Powiedziała do swego ojca: Niech się mój pan nie gniewa, że nie mogę wstać przed tobą, bo mam kobiecą przypadłość. I szukał, ale nie znalazł posążków. ");
INSERT INTO polubg_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Wtedy Jakub rozgniewał się i zganił Labana. I Jakub powiedział do Labana: Jakie jest moje przestępstwo i jaki mój grzech, że goniłeś mnie w gniewie? ");
INSERT INTO polubg_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Oto przeszukałeś wszystkie moje rzeczy. Co znalazłeś z rzeczy należących do twego domu? Połóż to tutaj przed moimi i twoimi braćmi i niech rozsądzą między nami dwoma. ");
INSERT INTO polubg_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Dwadzieścia lat mieszkałem z tobą. Twoje owce i twoje kozy nie roniły, a baranów z twego stada nie jadłem. ");
INSERT INTO polubg_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Rozszarpanego przez zwierzę nie przynosiłem do ciebie, wynagradzałem ci szkodę; z mojej ręki domagałeś się tego, co było ukradzione we dnie i co było ukradzione w nocy. ");
INSERT INTO polubg_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Bywało, że we dnie męczył mnie upał, a mróz w nocy, tak że sen odchodził od moich oczu. ");
INSERT INTO polubg_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Dwadzieścia lat ci służyłem w twoim domu: czternaście lat za twoje dwie córki, a sześć lat za twoje bydło. A po dziesięć razy zmieniałeś moją zapłatę. ");
INSERT INTO polubg_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Gdyby Bóg mojego ojca, Bóg Abrahama i bojaźń Izaaka, nie był ze mną, pewnie byś mnie teraz odprawił z niczym. Ale Bóg wejrzał na moje utrapienie i na pracę moich rąk i przestrzegł cię zeszłej nocy. ");
INSERT INTO polubg_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Wtedy Laban odpowiedział Jakubowi: Córki te są moimi córkami i dzieci te są moimi dziećmi, i dobytek ten to mój dobytek, i wszystko, co widzisz, jest moje. Ale cóż mogę dziś uczynić tym moim córkom albo dzieciom, które urodziły? ");
INSERT INTO polubg_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Chodź więc, zawrzyjmy przymierze, ja i ty, i niech to będzie świadectwem między mną a tobą. ");
INSERT INTO polubg_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","I Jakub wziął kamień, i postawił go jako pomnik. ");
INSERT INTO polubg_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Potem Jakub powiedział do swoich braci: Nazbierajcie kamieni. Wzięli więc kamienie i zrobili stos, i jedli tam na tym stosie. ");
INSERT INTO polubg_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","I Laban nazwał go Jegar Sahaduta, a Jakub go nazwał Galed. ");
INSERT INTO polubg_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Bo Laban mówił: Ten stos niech będzie dziś świadkiem między mną a tobą. Dlatego Jakub nazwał go Galed; ");
INSERT INTO polubg_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","I Myspa, bo Laban powiedział: Niech PAN czuwa nade mną i nad tobą, gdy się oddalimy od siebie. ");
INSERT INTO polubg_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Jeśli będziesz krzywdził moje córki i jeśli pojmiesz inne żony oprócz moich córek, to choć nie ma tu z nami nikogo, patrz: Bóg jest świadkiem między mną a tobą. ");
INSERT INTO polubg_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","I Laban mówił dalej do Jakuba: Oto ten stos kamieni i oto ten pomnik, który postawiłem między mną a tobą. ");
INSERT INTO polubg_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ten stos jest świadkiem i ten pomnik jest świadkiem tego, że ja do ciebie nie pójdę dalej za ten stos i ty też nie pójdziesz do mnie za ten stos i pomnik w złym zamiarze. ");
INSERT INTO polubg_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Bóg Abrahama i Bóg Nachora, Bóg ich ojca, niech rozsądzi między nami. Jakub przysiągł więc przez bojaźń swego ojca Izaaka. ");
INSERT INTO polubg_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Potem Jakub złożył na wzgórzu ofiarę i wezwał swych braci do jedzenia chleba. Jedli więc chleb i nocowali na tym wzgórzu. ");
INSERT INTO polubg_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Nazajutrz wcześnie rano Laban wstał, ucałował swoich synów i swoje córki i błogosławił im. A Laban odszedł i wrócił na swoje miejsce. ");
INSERT INTO polubg_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jakub też poszedł swoją drogą i spotkali go aniołowie Boga. ");
INSERT INTO polubg_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Gdy Jakub ich ujrzał, powiedział: To obóz Boga. I nadał temu miejscu nazwę Machanaim. ");
INSERT INTO polubg_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Potem Jakub wysłał przed sobą posłańców do swego brata Ezawa, do ziemi Seir, do krainy Edomu. ");
INSERT INTO polubg_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","I rozkazał im: Tak powiecie do mego pana Ezawa: To mówi twój sługa Jakub: Byłem gościem u Labana i przebywałem z nim aż do tego czasu. ");
INSERT INTO polubg_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mam woły, osły i owce, służących i służące, a posyłam oznajmić to memu panu, żebym znalazł łaskę w twoich oczach. ");
INSERT INTO polubg_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Posłańcy wrócili do Jakuba i mówili: Przyszliśmy do twego brata Ezawa, a on też idzie naprzeciwko ciebie, a z nim czterystu mężów. ");
INSERT INTO polubg_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jakub bardzo się przestraszył i ogarnęła go trwoga. Podzielił więc lud, który z nim był, oraz owce, woły i wielbłądy na dwa obozy. ");
INSERT INTO polubg_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","I powiedział: Jeśli Ezaw przyjdzie do jednego obozu i uderzy na niego, to drugi obóz ocaleje. ");
INSERT INTO polubg_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Potem Jakub powiedział: Boże mego ojca Abrahama i Boże mego ojca Izaaka, PANIE, który do mnie powiedziałeś: Wróć do twojej ziemi i do twojej rodziny, a będę ci wyświadczał dobro. ");
INSERT INTO polubg_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Nie jestem godzien wszelkiego miłosierdzia i całej wierności, które okazałeś swemu słudze. Bo tylko o lasce przeszedłem ten Jordan, a teraz mam dwa obozy. ");
INSERT INTO polubg_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Wyrwij mnie, proszę, z ręki mego brata, z ręki Ezawa, bo się go boję, że przyjdzie i zabije mnie i matki z dziećmi. ");
INSERT INTO polubg_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ty bowiem powiedziałeś: Na pewno będę ci wyświadczał dobro i rozmnożę twoje potomstwo jak piasek morski, który nie może być zliczony z powodu jego mnóstwa. ");
INSERT INTO polubg_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","I przenocował tam tej nocy, i wziął z tego, co miał pod ręką, dar dla swego brata Ezawa; ");
INSERT INTO polubg_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Dwieście kóz i dwadzieścia kozłów, dwieście owiec i dwadzieścia baranów; ");
INSERT INTO polubg_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Trzydzieści karmiących wielbłądzic z młodymi, czterdzieści krów i dziesięć wołów, dwadzieścia oślic i dziesięcioro ośląt. ");
INSERT INTO polubg_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","I oddał je w ręce swoich sług, każde stado oddzielnie, i powiedział do swoich sług: Idźcie przede mną i zachowajcie odstęp między stadami. ");
INSERT INTO polubg_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","I rozkazał pierwszemu: Gdy spotka cię mój brat Ezaw, a spyta cię: Czyj jesteś? I dokąd idziesz? A czyje to stado przed tobą? ");
INSERT INTO polubg_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Wtedy odpowiesz: To jest dar od twego sługi Jakuba, posłany memu panu Ezawowi. A oto on sam idzie za nami. ");
INSERT INTO polubg_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Tak też rozkazał drugiemu i trzeciemu, i wszystkim idącym za tymi stadami: Tymi słowy mówcie do Ezawa, gdy go spotkacie. ");
INSERT INTO polubg_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Powiecie mu też: Oto twój sługa Jakub idzie za nami. Myślał bowiem: Przebłagam go darem, który idzie przede mną, a potem zobaczę jego oblicze. Może mnie przyjmie łaskawie. ");
INSERT INTO polubg_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","I poszedł przed nim ten dar, a sam przenocował tej nocy ze swoim obozem. ");
INSERT INTO polubg_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Wstał tej nocy, wziął obie swe żony i dwie swoje służebnice oraz jedenastu swoich synów i przeszedł przez bród Jabboku. ");
INSERT INTO polubg_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","I wziął ich, przeprawił przez tę rzekę i przeprowadził wszystko, co miał. ");
INSERT INTO polubg_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jakub zaś został sam. I walczył z nim pewien mężczyzna aż do wzejścia zorzy. ");
INSERT INTO polubg_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","A widząc, że nie może go pokonać, dotknął go w staw biodrowy i wytrącił biodro Jakubowi ze stawu, gdy się z nim mocował. ");
INSERT INTO polubg_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","I powiedział: Puść mnie, bo już wzeszła zorza. Odpowiedział: Nie puszczę cię, aż mi pobłogosławisz. ");
INSERT INTO polubg_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Wtedy mu powiedział: Jakie jest twoje imię? I odpowiedział: Jakub. ");
INSERT INTO polubg_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","I powiedział: Twoim imieniem nie będzie już Jakub, ale Izrael, bo mężnie zmagałeś się z Bogiem i z ludźmi i zwyciężyłeś. ");
INSERT INTO polubg_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","I Jakub spytał: Powiedz mi, proszę, twoje imię. A on odpowiedział: Czemu pytasz o moje imię? I tam mu błogosławił. ");
INSERT INTO polubg_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakub nadał więc temu miejscu nazwę Penuel, mówiąc: Widziałem bowiem Boga twarzą w twarz, a moja dusza została zachowana. ");
INSERT INTO polubg_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","I kiedy minął miejsce Penuel, wzeszło słońce, a on utykał z powodu swojego biodra. ");
INSERT INTO polubg_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Dlatego do dziś synowie Izraela nie jadają ścięgna, które jest w stawie biodrowym, gdyż dotknął Jakuba w staw biodrowy, w ścięgno, które się skurczyło. ");
INSERT INTO polubg_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Potem Jakub podniósł oczy i zobaczył, że Ezaw nadchodzi, a z nim czterystu mężczyzn. Podzielił więc dzieci między Leę, Rachelę a dwie służące. ");
INSERT INTO polubg_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","I postawił na przodzie służące i ich dzieci, za nimi Leę i jej dzieci, a na końcu Rachelę z Józefem. ");
INSERT INTO polubg_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Sam zaś wyszedł przed nich i pokłonił się siedem razy aż do ziemi, zanim doszedł do swego brata. ");
INSERT INTO polubg_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ale Ezaw wybiegł mu naprzeciw, objął go, rzucił mu się na szyję i całował go. I płakali. ");
INSERT INTO polubg_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Potem podniósł oczy, zobaczył żony i dzieci i zapytał: A kim są ci przy tobie? I odpowiedział: To są dzieci, które Bóg w swej łaskawości dał twemu słudze. ");
INSERT INTO polubg_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Wtedy przybliżyły się służące ze swoimi dziećmi i pokłoniły się. ");
INSERT INTO polubg_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Przybliżyła się też Lea ze swoimi dziećmi i pokłoniły się. Potem przybliżyli się Józef i Rachela i pokłonili się. ");
INSERT INTO polubg_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","I Ezaw zapytał: Co znaczy cały ten obóz, z którym się spotkałem? Jakub odpowiedział: Abym znalazł łaskę w oczach mego pana. ");
INSERT INTO polubg_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Wtedy Ezaw powiedział: Ja mam dosyć, mój bracie, zatrzymaj to, co twoje. ");
INSERT INTO polubg_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","I Jakub powiedział: Nie, proszę, jeśli znalazłem teraz łaskę w twoich oczach, przyjmij dar z mojej ręki, bo gdy zobaczyłem twoje oblicze, to jakbym widział oblicze Boga, i ty łaskawie mnie przyjąłeś. ");
INSERT INTO polubg_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Przyjmij, proszę, mój dar, który ci przyniosłem, bo Bóg hojnie mi błogosławił, a mam dość wszystkiego. I tak nalegał na niego, że to przyjął. ");
INSERT INTO polubg_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ezaw powiedział: Ruszajmy w drogę i chodźmy, a ja pójdę przed tobą. ");
INSERT INTO polubg_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","I Jakub mu odpowiedział: Mój pan wie, że mam ze sobą dzieci wątłe, a owce i krowy karmią młode. Jeśli popędzi się je przez cały dzień, zginie całe stado. ");
INSERT INTO polubg_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Niech mój pan, proszę, idzie przed swoim sługą, a ja będę szedł powoli, jak nadąży stado, które jest przede mną, i jak nadążą dzieci, aż przyjdę do mego pana do Seiru. ");
INSERT INTO polubg_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Wtedy Ezaw powiedział: Zostawię więc przy tobie część ludzi, którzy są ze mną. A on odpowiedział: A na cóż to? Obym znalazł łaskę w oczach mego pana. ");
INSERT INTO polubg_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","I tego dnia Ezaw wrócił swą drogą do Seiru. ");
INSERT INTO polubg_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","A Jakub wyruszył do Sukkot i zbudował sobie dom, i zrobił szałasy dla swoich stad. Dlatego nazwał to miejsce Sukkot. ");
INSERT INTO polubg_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","I Jakub przyszedł szczęśliwie do miasta Sychem, które było w ziemi Kanaan, gdy wrócił z Paddan-Aram, i rozbił obóz przed miastem. ");
INSERT INTO polubg_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","I za sto monet kupił od synów Hemora, ojca Sychema, część pola, na którym rozbił swój namiot. ");
INSERT INTO polubg_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Tam też postawił ołtarz i nazwał go: Mocny Bóg Izraela. ");
INSERT INTO polubg_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","I Dina, córka Lei, którą urodziła Jakubowi, wyszła, aby zobaczyć córki tej ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","A gdy zobaczył ją Sychem, syn Chamora Chiwwity, książę tej ziemi, porwał ją, spał z nią i ją zhańbił. ");
INSERT INTO polubg_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","I przylgnęła jego dusza do Diny, córki Jakuba, a zakochał się w dziewczynie i czule do niej mówił. ");
INSERT INTO polubg_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Potem Sychem powiedział do swego ojca Chamora: Weź mi tę dziewczynę za żonę. ");
INSERT INTO polubg_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","A Jakub usłyszał, że jego córka Dina została zhańbiona, a jego synowie byli przy jego stadach na polu. Jakub więc milczał aż do ich przyjścia. ");
INSERT INTO polubg_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Wtedy Chamor, ojciec Sychema, wyszedł do Jakuba, aby z nim porozmawiać. ");
INSERT INTO polubg_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","A gdy synowie Jakuba przyszli z pola i to usłyszeli, ubolewali nad tym i bardzo się rozgniewali, że dopuścił się haniebnego czynu w Izraelu, śpiąc z córką Jakuba, czego nie wolno robić. ");
INSERT INTO polubg_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","I Chamor powiedział do nich: Mój syn Sychem przylgnął duszą do waszej córki. Dajcie mu ją, proszę, za żonę. ");
INSERT INTO polubg_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Spowinowaćcie się z nami. Dajcie nam wasze córki i bierzcie sobie nasze córki. ");
INSERT INTO polubg_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","I będziecie z nami mieszkać, a ziemia będzie przed wami. Mieszkajcie i handlujcie w niej, i osadzajcie się w niej. ");
INSERT INTO polubg_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","I Sychem mówił też do jej ojca i braci: Niech znajdę łaskę w waszych oczach, a co mi powiecie, to dam. ");
INSERT INTO polubg_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Zażądajcie ode mnie jak największego wiana i darów, a dam, jak mi powiecie; tylko dajcie mi tę dziewczynę za żonę. ");
INSERT INTO polubg_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Wtedy synowie Jakuba odpowiedzieli Sychemowi i jego ojcu Chamorowi, mówiąc podstępnie, bo zhańbił ich siostrę Dinę. ");
INSERT INTO polubg_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","I powiedzieli im: Nie możemy dać naszej siostry nieobrzezanemu mężczyźnie, gdyż byłaby to dla nas hańba. ");
INSERT INTO polubg_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Zgodzimy się z wami tylko w ten sposób, jeśli zechcecie być do nas podobni i każdy z waszych mężczyzn będzie obrzezany. ");
INSERT INTO polubg_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Wtedy damy wam nasze córki, a wasze córki weźmiemy sobie. Zamieszkamy z wami i staniemy się jednym ludem. ");
INSERT INTO polubg_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ale jeśli nas nie usłuchacie i nie dacie się obrzezać, weźmiemy naszą córkę i odejdziemy. ");
INSERT INTO polubg_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","I słowa ich spodobały się Chamorowi i jego synowi Sychemowi. ");
INSERT INTO polubg_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Młodzieniec nie odkładał więc tego, bo zakochał się w córce Jakuba. A był on ze wszystkich najbardziej szanowany w domu swego ojca. ");
INSERT INTO polubg_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Gdy Chamor i jego syn Sychem przyszli do bramy swego miasta, powiedzieli do mężczyzn swego miasta: ");
INSERT INTO polubg_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ci mężczyźni spokojnie z nami żyją. Niech więc mieszkają w tej ziemi i handlują w niej, bo oto nasza ziemia jest dość przestronna dla nich. Będziemy brać sobie ich córki za żony, a nasze córki będziemy im dawać. ");
INSERT INTO polubg_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Zgodzą się ci mężczyźni mieszkać z nami, byśmy byli jednym ludem, ale pod warunkiem, że każdy mężczyzna u nas będzie obrzezany, tak jak i oni są obrzezani. ");
INSERT INTO polubg_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Czyż ich stada i dobytek oraz wszelkie ich bydło nie będą nasze? Na to tylko im pozwólmy, a zamieszkają z nami. ");
INSERT INTO polubg_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","I usłuchali Chamora i jego syna Sychema wszyscy wychodzący z bramy swego miasta. I został obrzezany każdy mężczyzna, który wychodził z bramy swego miasta. ");
INSERT INTO polubg_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","A trzeciego dnia, gdy najbardziej cierpieli, dwaj synowie Jakuba, Symeon i Lewi, bracia Diny, wzięli swoje miecze i śmiało weszli do miasta, i pomordowali wszystkich mężczyzn. ");
INSERT INTO polubg_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Zabili ostrzem miecza także Chamora oraz jego syna Sychema i zabrali Dinę z domu Sychema, i odeszli. ");
INSERT INTO polubg_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Synowie Jakuba wpadli do pomordowanych i złupili miasto za to, że zhańbili ich siostrę. ");
INSERT INTO polubg_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Zabrali ich owce, woły i osły oraz to, co było w mieście i na polu. ");
INSERT INTO polubg_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Cały ich majątek, wszystkie ich dzieci i żony wzięli do niewoli i zrabowali wszystko, co było w domach. ");
INSERT INTO polubg_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Wtedy Jakub powiedział do Symeona i Lewiego: Zaniepokoiliście mnie, czyniąc mnie obrzydliwym u mieszkańców tej ziemi, u Kananejczyków i Peryzzytów. Ja mam niewielką liczbę ludzi, a oni zbiorą się przeciwko mnie i uderzą na mnie. I tak zginę ja i mój dom. ");
INSERT INTO polubg_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","A oni odpowiedzieli: Czyż miał traktować naszą siostrę jak nierządnicę? ");
INSERT INTO polubg_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Potem Bóg powiedział do Jakuba: Wstań, wstąp do Betel i tam zamieszkaj. Zbuduj tam ołtarz Bogu, który ci się ukazał, gdy uciekałeś przed swoim bratem Ezawem. ");
INSERT INTO polubg_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Wtedy Jakub powiedział do swych domowników i do wszystkich, którzy z nim byli: Usuńcie obcych bogów, którzy są wśród was, oczyśćcie się i zmieńcie swoje szaty. ");
INSERT INTO polubg_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Wstańmy i pójdźmy do Betel; tam zbuduję ołtarz Bogu, który mnie wysłuchał w dniu mego utrapienia i był ze mną w drodze, którą chodziłem. ");
INSERT INTO polubg_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Oddali więc Jakubowi wszystkich obcych bogów, których mieli, i kolczyki, które mieli w uszach, i Jakub zakopał je pod tym dębem, który był niedaleko Sychem. ");
INSERT INTO polubg_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Potem wyruszyli w drogę. A strach Boży padł na okoliczne miasta i nie ścigali synów Jakuba. ");
INSERT INTO polubg_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jakub przyszedł więc do Luz, które jest w ziemi Kanaan, czyli do Betel, on i cały lud, który z nim był. ");
INSERT INTO polubg_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","I zbudował tam ołtarz, a nazwał to miejsce El-Betel, bo tam ukazał mu się Bóg, gdy uciekał przed swoim bratem. ");
INSERT INTO polubg_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Wtedy umarła Debora, mamka Rebeki, i została pogrzebana przy Betel pod dębem. I nazwano go Allon-Bachut. ");
INSERT INTO polubg_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","I Bóg znowu ukazał się Jakubowi, gdy ten wracał z Paddan-Aram, i błogosławił mu. ");
INSERT INTO polubg_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","I powiedział mu Bóg: Twoje imię jest Jakub. Nie będziesz już jednak zwany Jakubem, ale twoim imieniem będzie Izrael. I nadał mu imię Izrael. ");
INSERT INTO polubg_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","I Bóg mu powiedział: Ja jestem Bóg Wszechmogący. Bądź płodny i rozmnażaj się. Z ciebie powstanie naród i wiele narodów, a z twoich bioder wyjdą królowie. ");
INSERT INTO polubg_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ziemię, którą dałem Abrahamowi i Izaakowi, dam tobie i twemu potomstwu po tobie dam tę ziemię. ");
INSERT INTO polubg_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","I Bóg odszedł od niego z miejsca, na którym z nim rozmawiał. ");
INSERT INTO polubg_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Potem Jakub postawił pomnik na tym miejscu, gdzie Bóg z nim rozmawiał, pomnik kamienny, i wylał na nim ofiarę z płynów, i polał go oliwą. ");
INSERT INTO polubg_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","I Jakub nadał temu miejscu, gdzie Bóg z nim rozmawiał, nazwę Betel. ");
INSERT INTO polubg_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Potem wyruszyli z Betel i gdy mieli kawałek drogi do Efraty, Rachela zaczęła rodzić, a poród miała ciężki. ");
INSERT INTO polubg_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Gdy rodziła w wielkich bólach, położna powiedziała do niej: Nie bój się, bo i tego syna będziesz miała. ");
INSERT INTO polubg_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Kiedy uchodziła z niej dusza, bo tam umarła, nadała mu imię Benoni; ale jego ojciec nazwał go Beniamin. ");
INSERT INTO polubg_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Tak to umarła Rachela i została pogrzebana na drodze do Efraty, czyli Betlejem. ");
INSERT INTO polubg_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","I Jakub postawił pomnik na jej grobie. To jest pomnik grobu Racheli aż do dziś. ");
INSERT INTO polubg_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Potem Izrael wyruszył stamtąd i rozbił swój namiot za wieżą Eder. ");
INSERT INTO polubg_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","A gdy Izrael mieszkał w tej krainie, Ruben poszedł i spał z Bilhą, nałożnicą swego ojca, i Izrael usłyszał o tym. A synów Jakuba było dwunastu. ");
INSERT INTO polubg_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Synowie Lei: Ruben, pierworodny Jakuba, potem Symeon, Lewi, Juda, Issachar i Zebulon. ");
INSERT INTO polubg_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Synowie Racheli: Józef i Beniamin. ");
INSERT INTO polubg_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","A synowie Bilhy, służącej Racheli: Dan i Neftali. ");
INSERT INTO polubg_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Synowie Zilpy, służącej Lei: Gad i Aszer. To są synowie Jakuba, którzy mu się urodzili w Paddan-Aram. ");
INSERT INTO polubg_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","I Jakub przyszedł do swego ojca Izaaka, do Mamre, do miasta Arba, czyli Hebronu, gdzie przebywali Abraham i Izaak. ");
INSERT INTO polubg_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","A dni Izaaka było sto osiemdziesiąt lat. ");
INSERT INTO polubg_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","I Izaak oddał ducha, i umarł, i został przyłączony do swego ludu, stary i syty dni; a pogrzebali go jego synowie, Ezaw i Jakub. ");
INSERT INTO polubg_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","To są dzieje rodu Ezawa, czyli Edomu. ");
INSERT INTO polubg_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ezaw pojął swoje żony z córek Kanaanu: Adę, córkę Elona Chetyty, Oholibamę, córkę Any, córki Sibeona Chiwwity; ");
INSERT INTO polubg_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","I Basmat, córkę Izmaela, siostrę Nebajota. ");
INSERT INTO polubg_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","I Ada urodziła Ezawowi Elifaza, a Basmat urodziła Rehuela. ");
INSERT INTO polubg_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama urodziła Jeusza, Jalama i Koracha. To są synowie Ezawa, którzy mu się urodzili w ziemi Kanaan. ");
INSERT INTO polubg_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","I Ezaw wziął swoje żony, synów, córki i wszystkich domowników, swoje stada, wszystkie bydła i całe swoje mienie, które zdobył w ziemi Kanaan, i odszedł od swego brata Jakuba do innej ziemi; ");
INSERT INTO polubg_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Bo ich majątek był tak wielki, że nie mogli mieszkać razem, i ziemia, na której przebywali, nie mogła ich utrzymać z powodu mnóstwa ich stad. ");
INSERT INTO polubg_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","I Ezaw zamieszkał na górze Seir. Ezaw to Edom. ");
INSERT INTO polubg_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","A to są dzieje rodu Ezawa, ojca Edomitów, na górze Seir. ");
INSERT INTO polubg_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","I to są imiona synów Ezawa: Elifaz, syn Ady, żony Ezawa, Rehuel, syn Basmat, żony Ezawa. ");
INSERT INTO polubg_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Synami zaś Elifaza byli: Teman, Omar, Sefo, Gatam i Kenaz. ");
INSERT INTO polubg_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","A Timna była nałożnicą Elifaza, syna Ezawa, i urodziła Elifazowi Amaleka. To są synowie Ady, żony Ezawa. ");
INSERT INTO polubg_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","To są synowie Rehuela: Nachat, Zerach, Szamma i Mizza. Byli oni synami Basmat, żony Ezawa. ");
INSERT INTO polubg_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","A ci byli synami żony Ezawa Oholibamy, córki Any, córki Sibeona. Urodziła ona Ezawowi Jeusza, Jalama i Koracha. ");
INSERT INTO polubg_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","To są książęta spośród synów Ezawa, synowie Elifaza, pierworodnego Ezawa: książę Teman, książę Omar, książę Sefo, książę Kenaz. ");
INSERT INTO polubg_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Książę Korach, książę Gatam, książę Amalek. Ci książęta pochodzą z Elifaza, w ziemi Edom, to są synowie Ady. ");
INSERT INTO polubg_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","To są synowie Rehuela, syna Ezawa: książę Nachat, książę Zerach, książę Szamma, książę Mizza. Ci książęta pochodzą z Rehuela, w ziemi Edom. Oni są synami Basmat, żony Ezawa. ");
INSERT INTO polubg_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","A to są synowie Oholibamy, żony Ezawa: książę Jeusz, książę Jalam, książę Korach. Ci książęta pochodzą z Oholibamy, córki Any, żony Ezawa. ");
INSERT INTO polubg_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","To są synowie Ezawa, czyli Edom, i to są ich książęta. ");
INSERT INTO polubg_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","A to są synowie Seira, Choryty, mieszkańcy tej ziemi: Lotan, Szobal, Sibeon i Ana; ");
INSERT INTO polubg_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Diszon, Eser i Diszan. To są książęta Chorytów, synowie Seira w ziemi Edom. ");
INSERT INTO polubg_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Synami Lotana byli: Chori i Hemam; a siostrą Lotana była Tamna. ");
INSERT INTO polubg_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Synowie zaś Szobala: Alwan, Manachat, Ebal, Szefo i Onam. ");
INSERT INTO polubg_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Synami Sibeona są Ajja i Ana. To ten Ana, który znalazł muły na pustyni, gdy pasł osły swego ojca Sibeona. ");
INSERT INTO polubg_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","A to są dzieci Any: Diszon i Oholibama, córka Any. ");
INSERT INTO polubg_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","I synowie Diszona: Chemdan, Eszban, Jitran i Keran. ");
INSERT INTO polubg_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","To są synowie Esera: Bilhan, Zaawan i Akan. ");
INSERT INTO polubg_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","I synowie Diszana: Us i Aran. ");
INSERT INTO polubg_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","To są książęta Chorytów: książę Lotan, książę Szobal, książę Sibeon, książę Ana. ");
INSERT INTO polubg_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Książę Diszon, książę Eser, książę Diszan. Są to książęta Chorytów, według ich księstw, w ziemi Seir. ");
INSERT INTO polubg_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","To są królowie, którzy panowali w ziemi Edom, zanim panował król nad synami Izraela. ");
INSERT INTO polubg_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","W Edomie panował Bela, syn Beora, a nazwa jego miasta – Dinhaba. ");
INSERT INTO polubg_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","I Bela umarł, a w jego miejsce panował Jobab, syn Zeracha z Bosry. ");
INSERT INTO polubg_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab umarł, a w jego miejsce panował Chuszam z ziemi Temanitów. ");
INSERT INTO polubg_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Chuszam umarł, a w jego miejsce panował Hadad, syn Bedada, który pokonał Midianitów na polu Moab, a nazwa jego miasta – Awit. ");
INSERT INTO polubg_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad umarł, a w jego miejsce panował Samla z Masreki. ");
INSERT INTO polubg_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla umarł, a w jego miejsce panował Saul z Rechobot nad Rzeką. ");
INSERT INTO polubg_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul umarł, a w jego miejsce panował Baalchanan, syn Akbora. ");
INSERT INTO polubg_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baalchanan, syn Akbora, umarł, a w jego miejsce panował Hadar, a nazwa jego miasta – Pahu, a imię jego żony to Mehetabel, była to córka Matredy, córki Mezahaba. ");
INSERT INTO polubg_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","To są imiona książąt Ezawa, według ich rodów i miejscowości i według ich imion: książę Timna, książę Alwa, książę Jetet. ");
INSERT INTO polubg_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Książę Oholibama, książę Ela, książę Pinon. ");
INSERT INTO polubg_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Książę Kenaz, książę Teman, książę Mibsar. ");
INSERT INTO polubg_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Książę Magdiel, książę Iram. To są książęta Edomu według miejsca ich zamieszkania w ziemi ich posiadłości. To jest Ezaw, ojciec Edomitów. ");
INSERT INTO polubg_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakub mieszkał w ziemi, gdzie jego ojciec był przybyszem, w ziemi Kanaan. ");
INSERT INTO polubg_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","To są dzieje rodu Jakuba: Gdy Józef miał siedemnaście lat, pasł stada ze swoimi braćmi; młodzieniec był z synami Bilhy i z synami Zilpy, żony swego ojca. I Józef donosił ojcu o ich złej sławie. ");
INSERT INTO polubg_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","A Izrael kochał Józefa najbardziej ze wszystkich swoich synów, bo urodził mu się w starości. I zrobił mu szatę wielobarwną. ");
INSERT INTO polubg_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Gdy jego bracia widzieli, że ojciec kocha go bardziej niż wszystkich jego braci, znienawidzili go i nie potrafili przyjaźnie z nim rozmawiać. ");
INSERT INTO polubg_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Pewnego razu Józefowi przyśnił się sen, a gdy opowiedział go swoim braciom, tym bardziej go znienawidzili. ");
INSERT INTO polubg_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Bo powiedział im: Posłuchajcie, proszę, snu, który mi się przyśnił. ");
INSERT INTO polubg_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Wiązaliśmy snopy na polu, a oto mój snop podniósł się i stanął, a wasze snopy otoczyły go i pokłoniły się mojemu snopowi. ");
INSERT INTO polubg_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","I odpowiedzieli mu jego bracia: Czyżbyś miał królować nad nami? Czyż miałbyś nami rządzić? I jeszcze bardziej go znienawidzili z powodu snów i słów jego. ");
INSERT INTO polubg_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Śnił mu się jeszcze drugi sen i opowiedział go swoim braciom: Znowu śnił mi się sen, a oto słońce, księżyc i jedenaście gwiazd pokłoniły mi się. ");
INSERT INTO polubg_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Gdy opowiedział to swemu ojcu i swoim braciom, jego ojciec zgromił go i powiedział mu: Cóż to za sen, który ci się śnił? Czy ja i twoja matka przyjdziemy z twoimi braćmi, aby ci się kłaniać aż do ziemi? ");
INSERT INTO polubg_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","I jego bracia zazdrościli mu, ale jego ojciec rozważał tę sprawę. ");
INSERT INTO polubg_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Potem jego bracia odeszli, aby paść trzody swego ojca w Sychem. ");
INSERT INTO polubg_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","I Izrael powiedział do Józefa: Czy twoi bracia nie pasą trzody w Sychem? Chodź, a poślę cię do nich. A on odpowiedział: Oto jestem. ");
INSERT INTO polubg_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Wtedy powiedział mu: Idź teraz i dowiedz się, jak się mają twoi bracia i co się dzieje z trzodami, i daj mi znać. Wysłał go więc z doliny Hebronu, a on przyszedł do Sychem. ");
INSERT INTO polubg_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","I spotkał go pewien człowiek, gdy błąkał się po polu. I człowiek ten zapytał go: Czego szukasz? ");
INSERT INTO polubg_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","A on odpowiedział: Szukam moich braci. Powiedz mi, proszę, gdzie oni pasą trzody. ");
INSERT INTO polubg_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Człowiek ten odpowiedział: Odeszli stąd, bo słyszałem, jak mówili: Pójdźmy do Dotan. I Józef poszedł za swoimi braćmi i znalazł ich w Dotan. ");
INSERT INTO polubg_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Gdy ujrzeli go z daleka, zanim do nich przyszedł, naradzali się, aby go zabić. ");
INSERT INTO polubg_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","I mówili jeden do drugiego: Oto idzie mistrz od snów. ");
INSERT INTO polubg_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Teraz więc chodźcie, zabijmy go i wrzućmy do jakiejś studni, i powiemy: Pożarł go zły zwierz. I zobaczymy, co będzie z jego snów. ");
INSERT INTO polubg_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben, gdy to usłyszał, chciał go wybawić z ich rąk i powiedział: Nie zabijajmy go. ");
INSERT INTO polubg_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruben powiedział też do nich: Nie wylewajcie krwi, ale wrzućcie go do tej studni, która jest na pustyni, i nie podnoście na niego ręki. A mówił to, aby go wybawić z ich rąk i przywrócić go swemu ojcu. ");
INSERT INTO polubg_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Gdy Józef przyszedł do swoich braci, obdarli go z jego szaty, z szaty wielobarwnej, którą miał na sobie. ");
INSERT INTO polubg_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Następnie chwycili go i wrzucili do studni, która była pusta, bez wody. ");
INSERT INTO polubg_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Potem usiedli, aby jeść chleb, a gdy podnieśli swoje oczy, zobaczyli grupę Izmaelitów idących z Gileadu. Ich wielbłądy niosły wonne korzenie, kadzidło i mirrę, a szły, aby to zanieść do Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Wtedy Juda powiedział do swoich braci: Jaki pożytek będzie z tego, że zabijemy naszego brata i zataimy jego krew? ");
INSERT INTO polubg_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Chodźcie, sprzedajmy go Izmaelitom, a nie podnośmy na niego naszej ręki, bo to jest nasz brat i nasze ciało. I bracia go usłuchali. ");
INSERT INTO polubg_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","A gdy przechodzili Midianici, kupcy, wyciągnęli Józefa ze studni i sprzedali go Izmaelitom za dwadzieścia srebrników, a oni zaprowadzili Józefa do Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Gdy Ruben wrócił do tej studni, Józefa już w studni nie było. I rozdarł swoje szaty. ");
INSERT INTO polubg_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Potem wrócił do swoich braci i powiedział: Nie ma chłopca, a ja dokąd pójdę? ");
INSERT INTO polubg_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Wtedy wzięli szatę Józefa, zabili kozła i umoczyli szatę we krwi. ");
INSERT INTO polubg_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","I posłali tę wielobarwną szatę, aby ją zaniesiono do jego ojca, i powiedzieli: Znaleźliśmy to. Zobacz, czy to szata twego syna, czy nie. ");
INSERT INTO polubg_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","A on rozpoznał ją i powiedział: To jest szata mego syna, pożarł go zły zwierz. Józef na pewno został rozszarpany. ");
INSERT INTO polubg_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Wtedy Jakub rozdarł swoje szaty, włożył wór na biodra i opłakiwał swego syna przez wiele dni. ");
INSERT INTO polubg_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","I zeszli się wszyscy jego synowie i wszystkie jego córki, aby go pocieszyć, lecz nie dał się pocieszyć, ale mówił: Naprawdę zstąpię za moim synem do grobu. I opłakiwał go jego ojciec. ");
INSERT INTO polubg_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","A Midianici sprzedali Józefa do Egiptu Potifarowi, dworzaninowi faraona, dowódcy straży. ");
INSERT INTO polubg_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","W tym czasie Juda odszedł od swoich braci i wstąpił do pewnego mieszkańca Adullam, który miał na imię Chira. ");
INSERT INTO polubg_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","I Juda zobaczył tam córkę Kananejczyka, który miał na imię Szua; pojął ją i obcował z nią. ");
INSERT INTO polubg_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","A ona poczęła i urodziła syna, i nadał mu imię Er. ");
INSERT INTO polubg_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","I znów poczęła i urodziła syna, i nadała mu imię Onan. ");
INSERT INTO polubg_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Potem znowu urodziła syna i nadała mu imię Szela. A Juda był w Kezib, gdy mu go urodziła. ");
INSERT INTO polubg_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","I Juda wziął dla swojego pierworodnego syna Era żonę imieniem Tamar. ");
INSERT INTO polubg_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","A Er, pierworodny Judy, był zły w oczach PANA, więc PAN go zabił. ");
INSERT INTO polubg_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Wtedy Juda powiedział do Onana: Obcuj z żoną twego brata i ożeń się z nią, i wzbudź twemu bratu potomstwo. ");
INSERT INTO polubg_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Lecz Onan wiedział, że to potomstwo nie miało być jego; gdy obcował z żoną swego brata, wyrzucał swoje nasienie na ziemię, aby nie wzbudzić potomstwa swemu bratu. ");
INSERT INTO polubg_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","I nie podobało się PANU to, co Onan robił, dlatego i jego PAN zabił. ");
INSERT INTO polubg_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Wtedy Juda powiedział do swojej synowej Tamar: Mieszkaj w domu twego ojca jako wdowa, aż dorośnie mój syn Szela. Powiedział bowiem: Oby on też nie umarł jak jego bracia. I Tamar odeszła, i mieszkała w domu swego ojca. ");
INSERT INTO polubg_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Po długim czasie umarła córka Szuy, żona Judy. Gdy Juda już pocieszył się, poszedł wraz ze swoim przyjacielem Chirą Adullamitą do Timny, do tych, co strzygli jego owce. ");
INSERT INTO polubg_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","I powiedziano o tym Tamarze: Oto twój teść idzie do Timny, aby strzyc swoje owce. ");
INSERT INTO polubg_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Zdjęła więc z siebie wdowie szaty, okryła się welonem i tak zasłonięta usiadła na rozstaju drogi, która prowadziła do Timny. Widziała bowiem, że Szela dorósł, a ona nie została mu dana za żonę. ");
INSERT INTO polubg_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","A gdy Juda zobaczył ją, pomyślał, że to nierządnica, bo zakryła swoją twarz. ");
INSERT INTO polubg_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Zszedł więc do niej z drogi i powiedział: Proszę, pozwól mi obcować z tobą. Nie wiedział bowiem, że to była jego synowa. I powiedziała: Co mi dasz, abyś mógł ze mną obcować? ");
INSERT INTO polubg_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","I odpowiedział: Poślę ci koźlątko ze stada. A ona rzekła: Dasz mi zastaw, dopóki nie przyślesz? ");
INSERT INTO polubg_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","I powiedział: Cóż mam ci dać w zastaw? A ona odpowiedziała: Twój pierścień, twój sznur i twoją laskę, którą masz w ręce. Dał jej więc i obcował z nią; a ona poczęła z niego. ");
INSERT INTO polubg_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Potem wstała, odeszła, zdjęła z siebie welon i włożyła wdowie szaty. ");
INSERT INTO polubg_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","A Juda posłał koźlątko przez swego przyjaciela Adullamitę, aby odebrał zastaw z ręki tej kobiety, ale ten jej nie znalazł. ");
INSERT INTO polubg_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","I pytał ludzi w tym miejscu: Gdzie jest ta nierządnica, która była na rozstaju tej drogi? Oni odpowiedzieli: Nie było tu żadnej nierządnicy. ");
INSERT INTO polubg_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Wrócił więc do Judy i powiedział: Nie znalazłem jej. I ludzie w tym miejscu powiedzieli: Nie było tu żadnej nierządnicy. ");
INSERT INTO polubg_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Wtedy Juda powiedział: Niech sobie zatrzyma ten zastaw, abyśmy nie stali się pośmiewiskiem. Oto posyłałem to koźlątko, a ty jej nie znalazłeś. ");
INSERT INTO polubg_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Po upływie około trzech miesięcy powiedziano Judzie: Twoja synowa Tamar stała się nierządnicą i oto jest brzemienna z nierządu. Wtedy Juda powiedział: Wyprowadźcie ją i niech będzie spalona. ");
INSERT INTO polubg_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","A gdy została wyprowadzona, posłała do swego teścia wiadomość: Jestem brzemienna z mężczyzny, do którego należą te rzeczy. Powiedziała przy tym: Rozpoznaj, proszę, czyj to pierścień, sznur i laska. ");
INSERT INTO polubg_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Wtedy Juda rozpoznał je i powiedział: Ona jest sprawiedliwsza ode mnie, ponieważ nie dałem jej memu synowi Szeli. I więcej z nią nie obcował. ");
INSERT INTO polubg_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Gdy nadszedł czas jej porodu, okazało się, że w jej łonie są bliźnięta. ");
INSERT INTO polubg_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","A gdy rodziła, jedno dziecko wytknęło rękę, a położna ujęła ją i zawiązała na ręce czerwoną nić, mówiąc: Ten wyszedł pierwszy. ");
INSERT INTO polubg_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Gdy on cofnął swoją rękę, oto wyszedł jego brat i powiedziała: Jak się przedarłeś? Na tobie niech będzie rozerwanie. I nadała mu imię Peres. ");
INSERT INTO polubg_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","A potem wyszedł jego brat, na którego ręce była czerwona nić. I nadała mu imię Zerach. ");
INSERT INTO polubg_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","A Józef został zaprowadzony do Egiptu. I Potifar, dworzanin faraona, dowódca straży, Egipcjanin, kupił go od Izmaelitów, którzy go tam zaprowadzili. ");
INSERT INTO polubg_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","PAN był z Józefem, tak że stał się człowiekiem, któremu się dobrze powodziło, i mieszkał w domu swego pana Egipcjanina. ");
INSERT INTO polubg_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Jego pan widział, że PAN jest z nim i że PAN szczęści mu we wszystkim, co on czyni. ");
INSERT INTO polubg_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","I Józef znalazł łaskę w jego oczach, i służył mu. Uczynił go zarządcą swego domu i wszystko, co miał, oddał w jego ręce. ");
INSERT INTO polubg_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","A od tego czasu, gdy uczynił go zarządcą swego domu i wszystkiego, co miał, PAN błogosławił domowi Egipcjanina ze względu na Józefa. I błogosławieństwo PANA było nad wszystkim, co miał w domu i na polu. ");
INSERT INTO polubg_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Dlatego oddał wszystko, co miał, w ręce Józefa i o niczym u siebie nie wiedział, tylko o chlebie, który spożywał. A Józef był przystojny i miły dla oka. ");
INSERT INTO polubg_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Po tych wydarzeniach żona jego pana zwróciła swe oczy na Józefa i powiedziała: Połóż się ze mną. ");
INSERT INTO polubg_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ale odmówił i powiedział do żony swego pana: Mój pan nie wie tak dobrze jak ja, co jest w jego domu, bo wszystko, co miał, oddał w moje ręce. ");
INSERT INTO polubg_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","I nie ma w tym domu nikogo większego ode mnie, i nie zabronił mi niczego oprócz ciebie, bo ty jesteś jego żoną. Jak więc mógłbym popełnić tak wielkie zło i zgrzeszyć przeciwko Bogu? ");
INSERT INTO polubg_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","I chociaż namawiała Józefa dzień w dzień, on nie zgadzał się z nią położyć ani z nią być. ");
INSERT INTO polubg_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Pewnego dnia, gdy wszedł do domu, aby wykonać swoje obowiązki, a nie było tam nikogo z domowników; ");
INSERT INTO polubg_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Uchwyciła go za szatę i powiedziała: Połóż się ze mną. Ale on zostawił swoją szatę w jej ręku, uciekł i wyszedł na zewnątrz. ");
INSERT INTO polubg_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","A gdy ona zobaczyła, że zostawił szatę w jej ręku i uciekł na zewnątrz; ");
INSERT INTO polubg_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Zawołała swoich domowników i powiedziała do nich: Patrzcie, pan sprowadził do nas Hebrajczyka, aby nas zelżył. Przyszedł bowiem do mnie, aby się ze mną położyć, ale krzyknęłam donośnym głosem. ");
INSERT INTO polubg_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","A gdy usłyszał, że podnoszę swój głos i wołam, zostawił szatę u mnie, uciekł i wyszedł na zewnątrz. ");
INSERT INTO polubg_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","I zatrzymała u siebie jego szatę, aż przyszedł do domu jego pan; ");
INSERT INTO polubg_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","I powiedziała do niego te słowa: Przyszedł do mnie sługa, ten Hebrajczyk, którego przyprowadziłeś do nas, aby mnie zelżyć. ");
INSERT INTO polubg_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","A gdy podniosłam swój głos i zawołałam, zostawił szatę u mnie i uciekł na zewnątrz. ");
INSERT INTO polubg_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Gdy jego pan usłyszał słowa swojej żony, które do niego powiedziała: Tak mi uczynił twój sługa, rozgniewał się bardzo. ");
INSERT INTO polubg_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Potem pan Józefa wziął go i oddał do więzienia, tam gdzie sadzano więźniów królewskich. I przebywał tam w więzieniu. ");
INSERT INTO polubg_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","A PAN był z Józefem, okazał mu miłosierdzie i dał mu łaskę w oczach przełożonego więzienia. ");
INSERT INTO polubg_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Przełożony więzienia oddał więc pod władzę Józefa wszystkich więźniów, którzy byli w więzieniu; a wszystkim, co tam się działo, on zarządzał. ");
INSERT INTO polubg_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","A przełożony więzienia nie doglądał tego, co mu powierzył, bo PAN był z nim, i co on czynił, to PAN szczęścił. ");
INSERT INTO polubg_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Po tych wydarzeniach podczaszy króla Egiptu i jego piekarz dopuścili się wykroczenia przeciwko swojemu panu, królowi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Faraon więc rozgniewał się na obu swoich dworzan, na przełożonego podczaszych i na przełożonego piekarzy. ");
INSERT INTO polubg_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","I oddał ich do więzienia w domu dowódcy straży, na miejsce, gdzie Józef był więźniem. ");
INSERT INTO polubg_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","A dowódca straży oddał ich pod nadzór Józefa, który im służył. I przebywali jakiś czas w więzieniu. ");
INSERT INTO polubg_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Pewnej nocy obydwaj – podczaszy i piekarz króla Egiptu, którzy byli więźniami w więzieniu – mieli sen, każdy inny, według swego tłumaczenia. ");
INSERT INTO polubg_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","A Józef przyszedł do nich rano i spostrzegł, że są smutni. ");
INSERT INTO polubg_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","I zapytał dworzan faraona, którzy byli z nim w więzieniu, w domu jego pana: Czemu macie dziś tak smutne twarze? ");
INSERT INTO polubg_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","I odpowiedzieli mu: Śnił się nam sen, a nie ma nikogo, kto by go wytłumaczył. Józef powiedział do nich: Czy nie do Boga należą wytłumaczenia? Opowiedzcie mi, proszę. ");
INSERT INTO polubg_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Wtedy przełożony podczaszych opowiedział swój sen Józefowi: Śniło mi się, że przede mną była winorośl; ");
INSERT INTO polubg_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","I na winorośli były trzy gałązki. A ona jakby wypuszczała pąki i wychodził jej kwiat, i jej grona wydały dojrzałe winogrona. ");
INSERT INTO polubg_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","A kubek faraona był w mojej ręce. Wziąłem więc winogrona i wyciskałem je do kubka faraona, i podawałem kubek w ręce faraona. ");
INSERT INTO polubg_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Wtedy Józef powiedział mu: Takie jest wytłumaczenie tego snu: Trzy gałązki to trzy dni. ");
INSERT INTO polubg_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Po trzech dniach faraon wywyższy twą głowę i przywróci cię na twój urząd, i będziesz podawał kubek faraona w jego rękę jak dawniej, gdy byłeś jego podczaszym. ");
INSERT INTO polubg_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tylko wspomnij na mnie, gdy się będziesz miał dobrze, i wyświadcz mi, proszę, tę przysługę i wspomnij o mnie faraonowi, i uwolnij mnie z tego domu; ");
INSERT INTO polubg_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Bo siłą uprowadzono mnie z ziemi hebrajskiej, a do tego nic złego tu nie zrobiłem, żeby mnie wrzucono do tego więzienia. ");
INSERT INTO polubg_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","A przełożony piekarzy, widząc, że dobrze wytłumaczył sen, powiedział do Józefa: Ja też miałem sen, a oto trzy białe kosze na mojej głowie; ");
INSERT INTO polubg_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","A w najwyższym koszu były wszelkie rodzaje pieczywa dla faraona, a ptaki jadły je z kosza, który był na mojej głowie. ");
INSERT INTO polubg_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Wtedy Józef odpowiedział: Takie jest wytłumaczenie snu: Trzy kosze to trzy dni. ");
INSERT INTO polubg_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Po trzech dniach faraon zetnie ci głowę i powiesi cię na drzewie, a ptaki będą jadły twoje ciało. ");
INSERT INTO polubg_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","A trzeciego dnia, w dniu urodzin faraona, urządził on ucztę dla wszystkich swoich sług i w ich obecności kazał sprowadzić przełożonego podczaszych i przełożonego piekarzy. ");
INSERT INTO polubg_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","I przywrócił przełożonego podczaszych na jego urząd, aby podawał kubek do rąk faraona. ");
INSERT INTO polubg_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","A przełożonego piekarzy powiesił, jak im Józef wytłumaczył. ");
INSERT INTO polubg_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Jednak przełożony podczaszych nie pamiętał o Józefie, ale zapomniał o nim. ");
INSERT INTO polubg_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Po upływie dwóch lat śniło się faraonowi, że stał nad rzeką. ");
INSERT INTO polubg_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A oto z rzeki wychodziło siedem pięknych i tłustych krów, które się pasły na łące. ");
INSERT INTO polubg_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Oto też za nimi wychodziło z rzeki siedem innych krów, brzydkich i chudych, które stanęły obok pierwszych krów nad brzegiem rzeki. ");
INSERT INTO polubg_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","I te brzydkie i chude krowy pożarły siedem pięknych i tłustych krów. Wtedy faraon się obudził. ");
INSERT INTO polubg_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","A gdy usnął, śnił po raz drugi. A oto siedem pełnych i cudnych kłosów wyrastało z jednego źdźbła. ");
INSERT INTO polubg_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Oto też siedem kłosów cienkich i wysuszonych od wiatru wschodniego wyrastało za nimi. ");
INSERT INTO polubg_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","I te cienkie kłosy pożarły siedem pięknych i pełnych kłosów. Wtedy faraon się obudził, a był to sen. ");
INSERT INTO polubg_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","A gdy nastał ranek, był zaniepokojony w duchu i kazał wezwać wszystkich wróżbitów i mędrców Egiptu. I opowiedział im faraon swoje sny, ale nie było nikogo, kto by potrafił je faraonowi wytłumaczyć. ");
INSERT INTO polubg_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Wtedy przełożony podczaszych powiedział do faraona: Przypominam sobie dziś moje grzechy. ");
INSERT INTO polubg_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Faraon rozgniewał się na swoje sługi i oddał mnie pod straż w domu dowódcy straży, mnie i przełożonego piekarzy. ");
INSERT INTO polubg_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Tam jednej nocy śnił się nam sen, mnie i jemu; każdemu śnił się sen według jego wytłumaczenia. ");
INSERT INTO polubg_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","A był tam z nami młodzieniec, Hebrajczyk, sługa dowódcy straży, któremu opowiedzieliśmy nasze sny, a on wytłumaczył je nam, każdemu według jego snu. ");
INSERT INTO polubg_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","I stało się tak, jak nam wytłumaczył: Mnie faraon przywrócił na moje miejsce, a tamtego powiesił. ");
INSERT INTO polubg_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Faraon kazał więc wezwać Józefa i prędko go wyprowadzono z więzienia. Ostrzygł się, zmienił szaty i przyszedł do faraona. ");
INSERT INTO polubg_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","I faraon powiedział do Józefa: Śnił mi się sen, a nie ma nikogo, kto potrafi mi go wytłumaczyć. Ale słyszałem, jak mówiono o tobie, że gdy usłyszysz sen, umiesz go wytłumaczyć. ");
INSERT INTO polubg_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Józef odpowiedział faraonowi: To nie ja, ale Bóg da faraonowi szczęśliwą odpowiedź. ");
INSERT INTO polubg_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Faraon powiedział więc do Józefa: Oto w moim śnie stałem na brzegu rzeki. ");
INSERT INTO polubg_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","A z rzeki wychodziło siedem tłustych i pięknych krów i pasły się na łące. ");
INSERT INTO polubg_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Za nimi zaś wychodziło siedem innych krów, nędznych, szpetnych i chudych; w całej ziemi Egiptu nie widziałem tak brzydkich. ");
INSERT INTO polubg_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","I chude i szpetne krowy pożarły siedem pierwszych tłustych krów. ");
INSERT INTO polubg_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","A choć je zjadły, nie było widać, że zjadły, ale były szpetne jak i przedtem. I obudziłem się. ");
INSERT INTO polubg_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Potem widziałem we śnie, jak oto siedem kłosów, pełnych i dorodnych, wyrastało z jednego źdźbła. ");
INSERT INTO polubg_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","A za nimi wyrastało siedem kłosów suchych, cienkich i wyschniętych od wschodniego wiatru. ");
INSERT INTO polubg_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","I te cienkie kłosy pożarły tych siedem dorodnych kłosów. I opowiedziałem to wróżbitom, ale nie było nikogo, kto by potrafił mi to wytłumaczyć. ");
INSERT INTO polubg_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Wtedy Józef powiedział do faraona: Sen faraona jest jeden – Bóg oznajmił faraonowi, co uczyni. ");
INSERT INTO polubg_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Siedem pięknych krów to siedem lat, a siedem dorodnych kłosów to też siedem lat. Jest to jeden sen. ");
INSERT INTO polubg_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Siedem zaś chudych i szpetnych krów, które wychodziły za nimi, to siedem lat; a siedem pustych kłosów i wyschniętych od wschodniego wiatru to będzie siedem lat głodu. ");
INSERT INTO polubg_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","A oto, co powiedziałem faraonowi: Bóg ukazał faraonowi, co uczyni. ");
INSERT INTO polubg_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nadchodzi siedem lat wielkiej obfitości w całej ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","A po nich nastąpi siedem lat głodu i cała obfitość ziemi Egiptu pójdzie w zapomnienie, i głód wytrawi ziemię; ");
INSERT INTO polubg_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Tak że obfitość ziemi nie będzie znana z powodu przyszłego głodu, bo będzie bardzo ciężki. ");
INSERT INTO polubg_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","A skoro sen śnił się faraonowi dwukrotnie, oznacza to, że ta rzecz jest postanowiona przez Boga i Bóg śpieszy ją wykonać. ");
INSERT INTO polubg_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Teraz więc niech faraon znajdzie roztropnego i mądrego człowieka i postawi go nad ziemią Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Niech faraon tak postąpi i ustanowi urzędników nad ziemią, i zbierze piątą część plonów ziemi Egiptu przez te siedem lat obfitości. ");
INSERT INTO polubg_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Niech zbierają wszelką żywność w tych nadchodzących dobrych latach i zgromadzą zboża do dyspozycji faraona, i niech przechowują żywność w miastach. ");
INSERT INTO polubg_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Żywność ta będzie zapasem dla ziemi na te siedem lat głodu, które będą w ziemi Egiptu, aby ziemia nie niszczała od głodu. ");
INSERT INTO polubg_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","I podobało się to faraonowi i wszystkim jego sługom. ");
INSERT INTO polubg_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Faraon zapytał więc swoje sługi: Czy znajdziemy człowieka mu podobnego, w którym jest Duch Boży? ");
INSERT INTO polubg_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Potem faraon powiedział do Józefa: Skoro Bóg oznajmił ci to wszystko, nie ma żadnego tak rozumnego i mądrego jak ty. ");
INSERT INTO polubg_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ty będziesz nad moim domem, a cały mój lud będzie postępować według rozkazu twoich ust. Tylko tronem będę większy od ciebie. ");
INSERT INTO polubg_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Faraon powiedział jeszcze do Józefa: Oto ustanowiłem cię nad całą ziemią Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Zdjął więc faraon pierścień z ręki i włożył go na rękę Józefa, oblekł go też w szatę bisiorową, a na szyję włożył mu złoty łańcuch. ");
INSERT INTO polubg_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","I kazał go wozić na swoim drugim rydwanie, i wołano przed nim: Na kolana! I ustanowił go rządcą całej ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Potem faraon powiedział do Józefa: Ja jestem faraonem, a bez twego pozwolenia nikt na całej ziemi Egiptu nie podniesie ani ręki, ani nogi. ");
INSERT INTO polubg_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","I faraon nadał Józefowi imię Safnat Paneach, i dał mu za żonę Asenat, córkę Poti-Fery, kapłana z On. I Józef wyjechał na całą ziemię Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Józef miał trzydzieści lat, gdy stanął przed faraonem, królem Egiptu. Potem Józef odszedł od faraona i objechał całą ziemię Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","A przez tych siedem urodzajnych lat ziemia rodziła obficie. ");
INSERT INTO polubg_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","I Józef zgromadził całą żywność tych siedmiu lat, która była w ziemi Egiptu, i składał żywność w miastach. Składał w miastach urodzajne plony z otaczających je pól. ");
INSERT INTO polubg_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Józef więc nagromadził zboża tak wiele jak piasku morskiego, aż przestano je liczyć, bo było go bez liku. ");
INSERT INTO polubg_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","A zanim nastały lata głodu, Józefowi urodzili się dwaj synowie, których mu urodziła Asenat, córka Poti-Fery, kapłana z On. ");
INSERT INTO polubg_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Józef nadał pierworodnemu imię Manasses, gdyż mówił: Bóg dał mi zapomnieć o całej mojej udręce i o całym domu mego ojca. ");
INSERT INTO polubg_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A drugiemu nadał imię Efraim, gdyż mówił: Bóg rozmnożył mnie w ziemi mego utrapienia. ");
INSERT INTO polubg_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","I skończyło się siedem lat obfitości, która była w ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","I nadeszło siedem lat głodu, tak jak Józef przepowiedział. I głód był we wszystkich krainach, ale w całej ziemi Egiptu był chleb. ");
INSERT INTO polubg_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Gdy jednak na całej ziemi Egiptu był głód, lud wołał do faraona o chleb. I faraon powiedział wszystkim Egipcjanom: Idźcie do Józefa, a co wam powie, zróbcie. ");
INSERT INTO polubg_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","I na całej ziemi był głód. Józef otworzył więc wszystkie spichlerze, w których było zboże, i sprzedawał Egipcjanom, bo głód wzmógł się w ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","I ze wszystkich krajów przyjeżdżano do Egiptu, by kupować żywność od Józefa, bo wzmógł się głód na całej ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Gdy Jakub dowiedział się, że w Egipcie jest zboże, powiedział do swoich synów: Czemu się patrzycie jeden na drugiego? ");
INSERT INTO polubg_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","I mówił im: Oto słyszałem, że w Egipcie jest zboże. Jedźcie tam i kupcie je nam stamtąd, abyśmy żyli, a nie pomarli. ");
INSERT INTO polubg_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Dziesięciu braci Józefa wyruszyło więc do Egiptu, aby kupić zboże. ");
INSERT INTO polubg_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ale Jakub nie posłał Beniamina, brata Józefa, z jego braćmi, bo powiedział: By nie spotkało go jakieś nieszczęście. ");
INSERT INTO polubg_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Synowie Izraela przybyli więc wraz z innymi, aby kupić zboże, gdyż był głód w ziemi Kanaan. ");
INSERT INTO polubg_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","A Józef był rządcą tej ziemi i to on sprzedawał zboża całej ludności tej ziemi. A gdy przyszli bracia Józefa, pokłonili mu się twarzą do ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Gdy Józef ujrzał swych braci, poznał ich, lecz udawał przed nimi obcego i rozmawiał z nimi surowo. Zapytał ich: Skąd przyszliście? Odpowiedzieli: Z ziemi Kanaan, aby nakupić żywności. ");
INSERT INTO polubg_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Józef rozpoznał swoich braci, ale oni go nie poznali. ");
INSERT INTO polubg_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","I Józef przypomniał sobie sny, które mu się śniły o nich, i powiedział im: Jesteście szpiegami i przyszliście, aby wypatrzyć nieobronne miejsca tej ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","A oni mu odpowiedzieli: Nie, mój panie. Twoi słudzy przyszli, aby nakupić żywności. ");
INSERT INTO polubg_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Wszyscy jesteśmy synami jednego człowieka. Jesteśmy uczciwi. Twoi słudzy nie są szpiegami. ");
INSERT INTO polubg_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","A on powiedział do nich: Nie, ale przyszliście wypatrzyć nieobronne miejsca tej ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Powiedzieli: Było nas, twoich sług, dwunastu braci, synów jednego człowieka w ziemi Kanaan. Najmłodszy jest z naszym ojcem w domu, a jednego już nie ma. ");
INSERT INTO polubg_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Józef rzekł im: Jest tak, jak wam powiedziałem – jesteście szpiegami. ");
INSERT INTO polubg_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Zostaniecie co do tego wybadani: Na życie faraona, nie wyjdziecie stąd, dopóki nie przyjdzie tu wasz młodszy brat. ");
INSERT INTO polubg_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Wyślijcie jednego z was, aby przyprowadził waszego brata, a wy zostaniecie w więzieniu, aż wasze słowa się potwierdzą, czy mówicie prawdę. A jeśli nie, na życie faraona, jesteście szpiegami. ");
INSERT INTO polubg_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","I oddał ich pod straż na trzy dni. ");
INSERT INTO polubg_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","A trzeciego dnia Józef powiedział do nich: Zróbcie tak, a będziecie żyć, bo ja się boję Boga. ");
INSERT INTO polubg_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Jeśli jesteście uczciwi, niech jeden z waszych braci pozostanie związany tu w więzieniu; a wy jedźcie i odnieście zboże, aby się pozbyć głodu z waszych domów. ");
INSERT INTO polubg_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","I przyprowadźcie do mnie waszego najmłodszego brata, a wasze słowa sprawdzą się i nie umrzecie. I tak zrobili. ");
INSERT INTO polubg_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Mówili jeden do drugiego: Naprawdę zgrzeszyliśmy przeciwko naszemu bratu, bo widząc strapienie jego duszy, gdy nas błagał, nie wysłuchaliśmy go. Dlatego przyszło na nas to utrapienie. ");
INSERT INTO polubg_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Wtedy Ruben odpowiedział im: Czyż nie mówiłem wam: Nie grzeszcie przeciw chłopcu? A nie usłuchaliście. Oto teraz żąda się odpowiedzialności za jego krew. ");
INSERT INTO polubg_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Lecz oni nie wiedzieli, że Józef rozumie, bo rozmawiał z nimi przez tłumacza. ");
INSERT INTO polubg_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Wtedy odwrócił się od nich i zapłakał. Potem obrócił się do nich i rozmawiał z nimi. Wziął spośród nich Symeona i związał go na ich oczach. ");
INSERT INTO polubg_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Potem Józef rozkazał, aby napełniono ich wory zbożem i każdemu z nich wrzucono do jego wora pieniądze, i żeby dano im żywność na drogę. I tak zrobiono. ");
INSERT INTO polubg_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Wtedy oni włożyli zboża na swoje osły i odjechali stamtąd. ");
INSERT INTO polubg_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","I gdy jeden z nich rozwiązał swój wór, aby w gospodzie dać karmę swemu osłu, zobaczył swoje pieniądze; były bowiem na wierzchu jego wora. ");
INSERT INTO polubg_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","I powiedział do swoich braci: Zwrócono mi pieniądze, oto są w moim worze. Wtedy zamarło im serce i przerazili się, mówiąc jeden do drugiego: Cóż to nam Bóg uczynił? ");
INSERT INTO polubg_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Potem przyszli do swego ojca Jakuba, do ziemi Kanaan, i opowiedzieli mu wszystko, co im się przydarzyło: ");
INSERT INTO polubg_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Ten człowiek, pan tej ziemi, rozmawiał z nami surowo i wziął nas za szpiegów ziemi; ");
INSERT INTO polubg_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Powiedzieliśmy mu: Jesteśmy uczciwi, nie jesteśmy szpiegami; ");
INSERT INTO polubg_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Było nas dwunastu braci, synów naszego ojca; jednego już nie ma, a najmłodszy jest teraz z naszym ojcem w ziemi Kanaan. ");
INSERT INTO polubg_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","I ten człowiek, pan tej ziemi, powiedział do nas: Po tym poznam, że jesteście uczciwi; zostawcie jednego z waszych braci u mnie, weźcie zboże, aby pozbyć się głodu z waszych domów, i idźcie; ");
INSERT INTO polubg_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Potem przyprowadźcie waszego najmłodszego brata do mnie, abym poznał, że nie jesteście szpiegami, ale ludźmi uczciwymi. Wtedy oddam wam waszego brata, a w tej ziemi będziecie mogli handlować. ");
INSERT INTO polubg_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","A gdy opróżniali swoje wory, każdy znalazł w swoim worze węzeł pieniędzy. Gdy wraz ze swoim ojcem zobaczyli węzły z pieniędzmi, przerazili się. ");
INSERT INTO polubg_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Wtedy ich ojciec Jakub powiedział im: Osierociliście mnie. Nie ma Józefa i Symeona, a weźmiecie Beniamina; całe zło się na mnie zwaliło. ");
INSERT INTO polubg_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben powiedział do swego ojca: Zabij moich dwóch synów, jeśli go z powrotem nie przyprowadzę. Oddaj go pod moją opiekę, a ja ci go zwrócę. ");
INSERT INTO polubg_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ale on powiedział: Mój syn nie pójdzie z wami, gdyż jego brat umarł i tylko on jeden został. Jeśli przydarzy mu się nieszczęście na drodze, którą pójdziecie, w żalu doprowadzicie mnie, osiwiałego, do grobu. ");
INSERT INTO polubg_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","A ciężki głód panował w tej ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","I gdy zużyli zboże, które przynieśli z Egiptu, ich ojciec powiedział do nich: Idźcie znowu i kupcie nam trochę żywności. ");
INSERT INTO polubg_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Juda powiedział do niego: Ten człowiek uroczyście nam oświadczył: Nie zobaczycie mojej twarzy, jeśli nie będzie z wami waszego brata. ");
INSERT INTO polubg_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Jeśli więc poślesz naszego brata z nami, pojedziemy i nakupimy ci żywności; ");
INSERT INTO polubg_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ale jeśli nie poślesz, nie pojedziemy, bo ten człowiek mówił do nas: Nie zobaczycie mojej twarzy, jeśli nie będzie z wami waszego brata. ");
INSERT INTO polubg_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Izrael zapytał: Dlaczego sprawiliście mi ból, mówiąc temu człowiekowi, że macie jeszcze brata? ");
INSERT INTO polubg_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Odpowiedzieli: Ten człowiek dokładnie się wypytał o nas i naszą rodzinę: Żyje jeszcze wasz ojciec? Macie jeszcze jakiegoś brata? I odpowiedzieliśmy mu na jego pytania. Skąd mogliśmy wiedzieć, że powie: Przyprowadźcie mi tu waszego brata? ");
INSERT INTO polubg_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","I Juda powiedział do swego ojca Izraela: Poślij chłopca ze mną. Powstaniemy i pojedziemy, abyśmy żyli, a nie pomarli z głodu, tak my, jak i ty, i nasze dzieci. ");
INSERT INTO polubg_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ja biorę odpowiedzialność za niego, ode mnie się go domagaj. Jeśli nie przyprowadzę go do ciebie i nie stawię go przed tobą, na zawsze będę ponosił za to winę. ");
INSERT INTO polubg_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Gdybyśmy bowiem nie zwlekali, wrócilibyśmy już dwa razy. ");
INSERT INTO polubg_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Wtedy Izrael, ich ojciec, powiedział do nich: Jeśli tak musi być, zróbcie w ten sposób: weźcie z najlepszych owoców ziemi w wasze naczynia i zanieście je temu człowiekowi w darze – trochę balsamu, trochę miodu, wonności, mirry, orzechów i migdałów. ");
INSERT INTO polubg_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Weźcie też ze sobą podwójną sumę pieniędzy, a pieniądze wrzucone na wierzch waszych worów zabierzcie ze sobą, bo może to była pomyłka. ");
INSERT INTO polubg_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Weźcie także waszego brata, wstańcie i jedźcie znowu do tego człowieka; ");
INSERT INTO polubg_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","A niech Bóg Wszechmogący da wam miłosierdzie przed tym człowiekiem, aby wam wypuścił waszego drugiego brata i Beniamina. A jeśli mam stracić swoje dzieci, to je stracę. ");
INSERT INTO polubg_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Mężczyźni wzięli więc ten dar, zabrali ze sobą podwójną sumę pieniędzy oraz Beniamina, wstali i pojechali do Egiptu, i stanęli przed Józefem. ");
INSERT INTO polubg_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","A gdy Józef zobaczył z nimi Beniamina, powiedział do zarządcy jego domu: Wprowadź tych ludzi do domu, zabij bydlę i przyrządź, bo ci ludzie w południe będą jedli ze mną. ");
INSERT INTO polubg_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Człowiek ten zrobił, jak mu Józef rozkazał, i wprowadził tych ludzi do domu Józefa. ");
INSERT INTO polubg_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Gdy zostali wprowadzeni do domu Józefa, bali się i mówili: Wprowadzono nas tu z powodu tych pieniędzy, które za pierwszym razem włożono do naszych worów, aby rzucić na nas oszczerstwo, napaść na nas i wziąć w niewolę nas i nasze osły. ");
INSERT INTO polubg_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Podeszli do zarządcy domu Józefa i rozmawiali z nim w drzwiach domu. ");
INSERT INTO polubg_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","I powiedzieli: Pozwól, panie. Przyjechaliśmy za pierwszym razem kupić żywności. ");
INSERT INTO polubg_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","A gdy przyjechaliśmy do gospody i rozwiązaliśmy nasze wory, pieniądze każdego były na wierzchu jego wora, nasze pieniądze w pełnej wadze. Przywieźliśmy je więc ze sobą. ");
INSERT INTO polubg_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Przywieźliśmy też inne pieniądze ze sobą, aby nakupić żywności. Nie wiemy, kto włożył nasze pieniądze do naszych worów. ");
INSERT INTO polubg_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","A on powiedział: Pokój wam, nie bójcie się. Bóg wasz, Bóg waszego ojca, dał wam skarb do waszych worów. Wasze pieniądze doszły do mnie. I wyprowadził do nich Symeona. ");
INSERT INTO polubg_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Człowiek ten wprowadził tych ludzi do domu Józefa, dał im wody, aby umyli sobie nogi; dał też karmę ich osłom. ");
INSERT INTO polubg_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Potem przygotowali dar, zanim Józef przyszedł w południe. Słyszeli bowiem, że tam mieli jeść chleb. ");
INSERT INTO polubg_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","A gdy Józef wszedł do domu, przynieśli mu dar, który mieli ze sobą w tym domu, i pokłonili mu się aż do ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","I dowiadywał się, jak się im powodzi, i zapytał: Czy wasz ojciec jest zdrowy, ten starzec, o którym mi opowiadaliście? Czy jeszcze żyje? ");
INSERT INTO polubg_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","A oni odpowiedzieli: Twój sługa, nasz ojciec, jest zdrowy, jeszcze żyje. I uklękli, i pokłonili mu się. ");
INSERT INTO polubg_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Wtedy podniósł swe oczy i zobaczył swego brata Beniamina, syna swej matki, i zapytał: Czy to jest wasz najmłodszy brat, o którym mi opowiadaliście? I powiedział mu: Niech Bóg będzie ci miłosierny, miły synu. ");
INSERT INTO polubg_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","I nagle Józef wyszedł, bo wzruszył się do głębi swym bratem, i szukał miejsca, gdzie mógłby zapłakać. Wszedł więc do komnaty i tam płakał. ");
INSERT INTO polubg_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Potem umył swoją twarz, wyszedł i gdy się opanował, powiedział: Kładźcie chleb. ");
INSERT INTO polubg_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Położono jemu osobno, im osobno i osobno Egipcjanom, którzy z nim jedli. Egipcjanie bowiem nie mogą jeść chleba z Hebrajczykami, gdyż to budzi odrazę u Egipcjan. ");
INSERT INTO polubg_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","I usiedli przed nim, pierworodny według swego pierworództwa, a młodszy według swej młodości. I dziwili się ci mężczyźni, patrząc jeden na drugiego. ");
INSERT INTO polubg_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Potem brał potrawy sprzed siebie i kazał im zanieść. A porcja Beniamina była pięciokrotnie większa od porcji ich wszystkich. Pili i podpili sobie z nim. ");
INSERT INTO polubg_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Wtedy Józef rozkazał zarządcy swego domu: Napełnij wory tych ludzi zbożem, ile tylko mogą unieść, a pieniądze każdego włóż na wierzch jego wora. ");
INSERT INTO polubg_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mój kielich też, kielich srebrny, włóż na wierzch wora najmłodszego razem z pieniędzmi za zboże. I zrobił według słów Józefa, jak mu rozkazał. ");
INSERT INTO polubg_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","O świcie wyprawiono tych ludzi razem z ich osłami. ");
INSERT INTO polubg_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Gdy wyszli z miasta i byli niedaleko, Józef powiedział do zarządcy swego domu: Wstań, goń tych ludzi, a gdy ich dogonisz, powiedz do nich: Czemu oddaliście złem za dobro? ");
INSERT INTO polubg_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Czy to nie jest kielich, z którego pija mój pan i z którego wróży? Źle postąpiliście, dopuszczając się tego. ");
INSERT INTO polubg_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ten dogonił ich więc i powiedział do nich te słowa. ");
INSERT INTO polubg_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ale oni mu odpowiedzieli: Dlaczego mój pan mówi takie słowa? Nie daj Boże, aby twoi słudzy mieli tak postąpić. ");
INSERT INTO polubg_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Przecież pieniądze, które znaleźliśmy na wierzchu naszych worów, przynieśliśmy do ciebie z powrotem z ziemi Kanaan. Jakże mielibyśmy kraść z domu twego pana srebro lub złoto? ");
INSERT INTO polubg_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","U którego z twoich sług to się znajdzie, niech umrze, a my będziemy niewolnikami mego pana. ");
INSERT INTO polubg_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","On powiedział: Niech będzie tak, jak mówicie. Przy którym znajdzie się kielich, ten będzie niewolnikiem, a wy będziecie niewinni. ");
INSERT INTO polubg_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Wtedy każdy szybko zdjął swój wór na ziemię i rozwiązał go. ");
INSERT INTO polubg_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","I szukał, zaczynając od starszego, a kończąc na najmłodszym. I znalazł kielich w worze Beniamina. ");
INSERT INTO polubg_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Wtedy rozdarli swoje szaty, każdy załadował swego osła i wrócili do miasta. ");
INSERT INTO polubg_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Przyszedł więc Juda i jego bracia do domu Józefa, który tam jeszcze był. I upadli przed nim na ziemię. ");
INSERT INTO polubg_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","I Józef zapytał ich: Co zrobiliście? Czy nie wiedzieliście, że taki człowiek jak ja potrafi wróżyć? ");
INSERT INTO polubg_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Wtedy Juda odpowiedział: Cóż możemy odpowiedzieć memu panu? Co możemy mówić i jak mamy się usprawiedliwić? Bóg znalazł nieprawość u twoich sług. Oto jesteśmy niewolnikami mego pana, zarówno my, jak i ten, u którego znalazł się kielich. ");
INSERT INTO polubg_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","A on odpowiedział: Nie daj Boże, abym miał tak uczynić. Człowiek, w którego ręku znaleziono kielich, będzie moim niewolnikiem. Wy zaś jedźcie w pokoju do waszego ojca. ");
INSERT INTO polubg_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Wtedy Juda podszedł do niego i powiedział: Mój panie! Pozwól twemu słudze mówić słowo do uszu mego pana, a niech nie zapala się twój gniew na twego sługę, gdyż ty jesteś jak sam faraon. ");
INSERT INTO polubg_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mój pan pytał swoich sług: Czy macie ojca albo brata? ");
INSERT INTO polubg_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Wtedy odpowiedzieliśmy memu panu: Mamy ojca, starca, i chłopca małego spłodzonego w jego starości. Jego brat umarł i tylko on został po swej matce, i jego ojciec go kocha. ");
INSERT INTO polubg_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Potem mówiłeś do nas, swoich sług: Przyprowadźcie go do mnie, abym mógł go zobaczyć własnymi oczyma. ");
INSERT INTO polubg_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","I mówiliśmy do mego pana: Chłopiec nie będzie mógł opuścić swego ojca, bo gdyby opuścił swego ojca, ten by umarł. ");
INSERT INTO polubg_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Wtedy powiedziałeś do swoich sług: Jeśli nie przyjdzie z wami wasz najmłodszy brat, więcej nie zobaczycie mojej twarzy. ");
INSERT INTO polubg_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Gdy więc przyszliśmy do twego sługi, mego ojca, powtórzyliśmy mu te słowa mego pana. ");
INSERT INTO polubg_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Wtedy nasz ojciec powiedział: Jedźcie znowu i kupcie nam trochę żywności. ");
INSERT INTO polubg_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","I powiedzieliśmy: Nie możemy tam iść. Lecz jeśli będzie z nami nasz najmłodszy brat, wtedy pojedziemy. Bo nie będziemy mogli zobaczyć twarzy tego człowieka, jeśli nie będzie z nami naszego najmłodszego brata. ");
INSERT INTO polubg_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","I twój sługa, mój ojciec, powiedział do nas: Wy wiecie, że moja żona urodziła mi dwóch synów. ");
INSERT INTO polubg_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Jeden wyszedł ode mnie i powiedziałem: Na pewno został rozszarpany przez zwierzę i nie widziałem go do dziś. ");
INSERT INTO polubg_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","A jeśli zabierzecie mi też tego i spotka go nieszczęście, wtedy w żalu doprowadzicie mnie, osiwiałego, do grobu. ");
INSERT INTO polubg_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Dlatego jeśli przyjdę do twego sługi, mojego ojca, a nie będzie z nami chłopca, z którym jest bardzo związany; ");
INSERT INTO polubg_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Stanie się tak, że jak tylko zobaczy, że chłopca nie ma, umrze. A twoi słudzy doprowadzą twego sługę, naszego ojca, osiwiałego, z żalu do grobu. ");
INSERT INTO polubg_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Bo twój sługa wziął na siebie odpowiedzialność przed ojcem i mówił: Jeśli go nie przyprowadzę, będę po wszystkie dni winien grzechu przeciw mojemu ojcu. ");
INSERT INTO polubg_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Teraz więc, proszę, niech twój sługa zostanie niewolnikiem mego pana zamiast tego chłopca, a niech chłopak idzie ze swymi braćmi. ");
INSERT INTO polubg_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Bo jak ja mam wrócić do mego ojca, gdy nie będzie ze mną tego chłopca? Nie chciałbym patrzeć na rozpacz, która by dotknęła mego ojca. ");
INSERT INTO polubg_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Wtedy Józef nie mógł się dalej powstrzymać przed wszystkimi, którzy stali przed nim, i zawołał: Wyprowadźcie wszystkich ode mnie. I nikt przy nim nie został, gdy Józef dał się poznać swoim braciom. ");
INSERT INTO polubg_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","I wybuchnął tak głośnym płaczem, że słyszeli to Egipcjanie, słyszał też dom faraona. ");
INSERT INTO polubg_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","I Józef powiedział do swoich braci: Ja jestem Józef. Czy mój ojciec jeszcze żyje? A jego bracia nie mogli mu odpowiedzieć, bo zatrwożyli się wobec niego. ");
INSERT INTO polubg_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Wtedy Józef powiedział do swoich braci: Zbliżcie się, proszę, do mnie. A gdy zbliżyli się, powiedział: Ja jestem Józef, wasz brat, którego sprzedaliście do Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Jednak teraz nie smućcie się ani się nie bójcie, że sprzedaliście mnie tutaj. Bóg bowiem posłał mnie przed wami dla zachowania waszego życia. ");
INSERT INTO polubg_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Bo już dwa lata trwa głód na ziemi, a jeszcze pięć lat zostaje, w których nie będzie ani orki, ani żniwa. ");
INSERT INTO polubg_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Bóg posłał mnie więc przed wami, aby zachować wam potomność na ziemi i żeby ocalić wam życie dzięki wielkiemu wybawieniu. ");
INSERT INTO polubg_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Tak więc nie wy mnie tu posłaliście, ale Bóg, który mnie ustanowił ojcem dla faraona i panem całego jego domu oraz władcą nad całą ziemią Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Idźcie więc szybko do mego ojca i powiedzcie do niego: Tak mówi twój syn Józef: Bóg uczynił mnie panem całego Egiptu, przyjedź do mnie, nie zwlekaj. ");
INSERT INTO polubg_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Będziesz mieszkał w ziemi Goszen i będziesz blisko mnie, ty, twoi synowie i synowie twoich synów, twoje owce i woły, i wszystko, co masz. ");
INSERT INTO polubg_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Będę cię tam żywił, bo będzie jeszcze pięć lat głodu, byś nie zginął z niedostatku ty, twój dom i wszystko, co masz. ");
INSERT INTO polubg_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","A oto wasze oczy i oczy mego brata Beniamina widzą, że moje usta do was mówią. ");
INSERT INTO polubg_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Opowiedzcie też memu ojcu o całej mojej chwale w Egipcie i o wszystkim, co widzieliście; spieszcie się więc i przyprowadźcie tu mego ojca. ");
INSERT INTO polubg_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Potem rzucił się na szyję swemu bratu Beniaminowi i zapłakał. Beniamin też płakał na jego szyi. ");
INSERT INTO polubg_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","I pocałował wszystkich swoich braci, i płakał nad nimi. Potem jego bracia rozmawiali z nim. ");
INSERT INTO polubg_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","I rozgłoszono tę wieść w domu faraona: Przyjechali bracia Józefa. I podobało się to faraonowi i jego sługom. ");
INSERT INTO polubg_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Wtedy faraon powiedział do Józefa: Powiedz swoim braciom: Zróbcie tak: Załadujcie swoje zwierzęta i idźcie, wróćcie do ziemi Kanaan. ");
INSERT INTO polubg_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Zabierzcie waszego ojca i waszych domowników i przyjedźcie do mnie. A dam wam dobre miejsce w ziemi Egiptu i będziecie się żywić tym, co najlepsze z tej ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","I rozkaż im: Tak zróbcie: Weźcie sobie z ziemi Egiptu wozy dla waszych dzieci i dla waszych żon, weźcie też waszego ojca i przyjedźcie tutaj. ");
INSERT INTO polubg_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Nie żałujcie waszych sprzętów, gdyż dobro całej ziemi Egiptu będzie wasze. ");
INSERT INTO polubg_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Tak zrobili więc synowie Izraela. Józef dał im wozy zgodnie z rozkazem faraona, dał im też żywności na drogę. ");
INSERT INTO polubg_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Dał każdemu z nich szaty na zmianę, a Beniaminowi dał trzysta srebrników i pięć szat na zmianę. ");
INSERT INTO polubg_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Posłał też swemu ojcu takie rzeczy: dziesięć osłów niosących najlepsze płody Egiptu i dziesięć oślic niosących zboże, chleb i żywność na drogę dla jego ojca. ");
INSERT INTO polubg_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Wyprawił więc swoich braci i gdy odjeżdżali, powiedział do nich: Nie kłóćcie się po drodze. ");
INSERT INTO polubg_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Wyjechali z Egiptu i przyjechali do ziemi Kanaan, do swego ojca Jakuba. ");
INSERT INTO polubg_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","I oznajmili mu: Józef jeszcze żyje i jest władcą nad całą ziemią Egiptu. I zasłabło jego serce, bo im nie wierzył. ");
INSERT INTO polubg_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Lecz oni powtórzyli mu wszystkie słowa Józefa, które im powiedział. A kiedy zobaczył wozy, które Józef posłał, aby go na nich przywieziono, ożył duch ich ojca Jakuba. ");
INSERT INTO polubg_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","I Izrael powiedział: To mi wystarczy. Mój syn Józef jeszcze żyje. Pójdę i zobaczę go, zanim umrę. ");
INSERT INTO polubg_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Tak więc Izrael wyruszył w drogę ze wszystkim, co miał; a gdy przybył do Beer-Szeby, złożył ofiary Bogu swego ojca Izaaka. ");
INSERT INTO polubg_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Wtedy Bóg powiedział do Izraela w nocnym widzeniu: Jakubie, Jakubie! A on odpowiedział: Oto jestem. ");
INSERT INTO polubg_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","I powiedział: Ja jestem Bogiem, Bogiem twego ojca. Nie bój się zejść do Egiptu, bo tam cię rozmnożę w wielki naród. ");
INSERT INTO polubg_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Pójdę z tobą do Egiptu i wyprowadzę cię stamtąd z powrotem, a Józef położy swoją rękę na twoje oczy. ");
INSERT INTO polubg_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","I Jakub wyruszył z Beer-Szeby. I synowie Izraela wzięli swego ojca Jakuba, swoje dzieci i swe żony na wozy, które faraon posłał, aby go przywieziono. ");
INSERT INTO polubg_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Zebrali też swe stada i swój dobytek, który zdobyli w ziemi Kanaan, i przyjechali do Egiptu, Jakub i całe jego potomstwo razem z nim; ");
INSERT INTO polubg_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Swych synów i synów swoich synów, swoje córki i córki swoich synów oraz całe swoje potomstwo prowadził ze sobą do Egiptu. ");
INSERT INTO polubg_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","A to są imiona synów Izraela, którzy weszli do Egiptu – Jakub i jego synowie: pierworodny Jakuba, Ruben. ");
INSERT INTO polubg_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Synowie Rubena: Henoch, Pallu, Chesron i Karmi. ");
INSERT INTO polubg_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Synowie Symeona: Jemuel, Jamin, Ohad, Jakin, Sochar i Szaul, syn kobiety Kananejki. ");
INSERT INTO polubg_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Synowie Lewiego: Gerszon, Kehat i Merari. ");
INSERT INTO polubg_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Synowie Judy: Er, Onan, Szela, Peres i Zerach. Lecz Er i Onan umarli w ziemi Kanaan. A synami Peresa byli: Chesron i Chamul. ");
INSERT INTO polubg_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Synowie Issachara: Tola, Puwwa, Job i Szimron. ");
INSERT INTO polubg_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Synowie Zebulona: Sered, Elon i Jachleel. ");
INSERT INTO polubg_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","A to są synowie Lei, których – jak i córkę Dinę, urodziła Jakubowi w Paddan-Aram. Wszystkich dusz jego synów i córek było trzydzieści trzy. ");
INSERT INTO polubg_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Synowie Gada: Sifion, Chaggi, Szuni, Esbon, Eri, Arodi i Areli. ");
INSERT INTO polubg_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Synowie Aszera: Jimna, Jiszwa, Jiszwi, Beria i siostra ich Serach. A synowie Berii: Cheber i Malkiel. ");
INSERT INTO polubg_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","To są synowie Zilpy, którą Laban dał swej córce Lei, których ona urodziła Jakubowi – szesnaście dusz. ");
INSERT INTO polubg_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Synowie Racheli, żony Jakuba: Józef i Beniamin. ");
INSERT INTO polubg_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Józefowi zaś urodzili się w ziemi Egiptu Manasses i Efraim, których urodziła Asenat, córka Poti-Fery, kapłana z On. ");
INSERT INTO polubg_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Synowie Beniamina: Bela, Beker, Aszbel, Gera, Naaman, Echi, Rosz, Muppim, Chuppim i Ard. ");
INSERT INTO polubg_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","To są synowie Racheli, którzy się urodzili Jakubowi. Wszystkich dusz – czternaście. ");
INSERT INTO polubg_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Synowie Dana: Chuszim. ");
INSERT INTO polubg_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Synowie Neftalego: Jachseel, Guni, Jeser i Szillem. ");
INSERT INTO polubg_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","To są synowie Bilhy, którą Laban dał swej córce Racheli, i których urodziła Jakubowi. Wszystkich dusz – siedem. ");
INSERT INTO polubg_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Wszystkich, którzy przyszli z Jakubem do Egiptu, pochodzących z jego lędźwi, oprócz żon synów Jakuba, wszystkich dusz było sześćdziesiąt sześć. ");
INSERT INTO polubg_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","A synów Józefa, którzy mu się urodzili w Egipcie, były dwie dusze. I tak wszystkich dusz z domu Jakuba, które weszły do Egiptu, było siedemdziesiąt. ");
INSERT INTO polubg_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","I Jakub posłał przed sobą Judę do Józefa, aby go uprzedził, zanim przybędzie do Goszen. I przybyli do ziemi Goszen. ");
INSERT INTO polubg_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","I Józef zaprzągł swój wóz, i wyjechał naprzeciw swemu ojcu Izraelowi do Goszen. A gdy go zobaczył, rzucił mu się na szyję i długo płakał na jego szyi. ");
INSERT INTO polubg_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Wtedy Izrael powiedział do Józefa: Mogę już umrzeć, skoro ujrzałem twoją twarz, że jeszcze żyjesz. ");
INSERT INTO polubg_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Józef powiedział do swoich braci i do domu swego ojca: Pójdę zawiadomić faraona i powiem mu: Moi bracia i dom mego ojca, którzy byli w ziemi Kanaan, przyjechali do mnie; ");
INSERT INTO polubg_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","A ci mężczyźni są pasterzami, bo zajmowali się hodowlą bydła. Przyprowadzili więc swoje owce i woły, i wszystko, co mieli. ");
INSERT INTO polubg_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","A gdy wezwie was faraon i zapyta: Czym się zajmujecie? ");
INSERT INTO polubg_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Odpowiecie: Twoi słudzy od swego dzieciństwa aż do dziś są pasterzami, my i nasi ojcowie. W ten sposób będziecie mogli mieszkać w ziemi Goszen, bo Egipcjanie brzydzą się każdym pasterzem. ");
INSERT INTO polubg_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Józef więc przyszedł i powiedział faraonowi: Mój ojciec i moi bracia ze swymi owcami, wołami i ze wszystkim, co mają, przybyli z ziemi Kanaan; oto są w ziemi Goszen. ");
INSERT INTO polubg_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","A spośród swych braci wziął pięciu mężczyzn i przedstawił ich faraonowi. ");
INSERT INTO polubg_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","I faraon zapytał jego braci: Czym się zajmujecie? A oni odpowiedzieli faraonowi: Twoi słudzy są pasterzami, my i nasi ojcowie. ");
INSERT INTO polubg_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Powiedzieli jeszcze do faraona: Przyszliśmy, aby przebywać w tej ziemi, bo nie ma paszy dla stad, które mają twoi słudzy, gdyż ciężki głód panuje w ziemi Kanaan. Teraz prosimy, pozwól, aby twoi słudzy mieszkali w ziemi Goszen. ");
INSERT INTO polubg_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Wtedy faraon powiedział do Józefa: Twój ojciec i twoi bracia przybyli do ciebie. ");
INSERT INTO polubg_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ziemia Egiptu jest przed tobą. W najlepszym miejscu tej ziemi osadź twego ojca i twoich braci, niech mieszkają w ziemi Goszen. A jeśli wiesz, że są wśród nich dzielni ludzie, uczyń ich przełożonymi nad moimi stadami. ");
INSERT INTO polubg_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","I Józef przyprowadził swego ojca Jakuba, i postawił go przed faraonem. A Jakub błogosławił faraona. ");
INSERT INTO polubg_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Faraon zapytał Jakuba: Ile lat życia sobie liczysz? ");
INSERT INTO polubg_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakub odpowiedział faraonowi: Liczba lat mego pielgrzymowania to sto trzydzieści. Krótkie i złe były lata mego życia i nie osiągnąłem wieku moich ojców podczas ich pielgrzymowania. ");
INSERT INTO polubg_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Potem Jakub pobłogosławił faraona i odszedł sprzed jego oblicza. ");
INSERT INTO polubg_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Wtedy Józef osiedlił swego ojca i swoich braci i dał im posiadłość w ziemi Egiptu, w najlepszym miejscu tej krainy, w ziemi Ramses, jak rozkazał faraon. ");
INSERT INTO polubg_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","I Józef żywił chlebem swego ojca i swoich braci, i cały dom swego ojca, aż do najmniejszego. ");
INSERT INTO polubg_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","A w całej ziemi nie było chleba, bo panował bardzo ciężki głód i była utrapiona przez głód ziemia Egiptu i ziemia Kanaan. ");
INSERT INTO polubg_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Józef zebrał więc wszystkie pieniądze, które znajdowały się w ziemi Egiptu i w ziemi Kanaan, za żywność, którą kupowano. I Józef wniósł te pieniądze do skarbu faraona. ");
INSERT INTO polubg_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","A gdy zabrakło pieniędzy w ziemi Egiptu i w ziemi Kanaan, wszyscy Egipcjanie przyszli do Józefa i powiedzieli: Daj nam chleba. Dlaczego mamy umierać na twoich oczach? Gdyż nam już zabrakło pieniędzy. ");
INSERT INTO polubg_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Józef na to odpowiedział: Dajcie wasze bydła, a dam wam żywność za wasze bydła, skoro zabrakło wam pieniędzy. ");
INSERT INTO polubg_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Przyprowadzili więc swoje bydła do Józefa; i Józef dał im chleb za konie, za trzody owiec, za stada wołów i za osły. W tym roku zaopatrywał ich w żywność w zamian za wszelkie ich bydło. ");
INSERT INTO polubg_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","A gdy minął ten rok, przyszli do niego w następnym roku i powiedzieli: Nie ukryjemy przed naszym panem, że już skończyły się nam pieniądze, a stada bydła należą do naszego pana. Nie zostaje nam nic przed naszym panem jak tylko nasze ciała i nasze pole. ");
INSERT INTO polubg_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Dlaczego mamy umierać na twoich oczach, zarówno my, jak i nasza ziemia? Kupuj za chleb nas i nasze pole, a my i nasza ziemia będziemy w niewoli u faraona. Daj nam tylko ziarno, abyśmy żyli, a nie pomarli, i by ziemia nie opustoszała. ");
INSERT INTO polubg_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","I tak kupił Józef całą ziemię Egiptu dla faraona, bo każdy Egipcjanin sprzedał swoje pole, gdyż wzmógł się wśród nich głód. I cała ziemia stała się własnością faraona. ");
INSERT INTO polubg_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","I przeniósł lud do miast, od jednego krańca Egiptu do drugiego. ");
INSERT INTO polubg_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Nie kupił tylko ziemi kapłanów, bo kapłani mieli żywność przydzieloną im przez faraona i żywili się swoją żywnością, którą dał im faraon. Dlatego nie sprzedali swej ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Potem Józef powiedział do ludu: Oto teraz kupiłem was i waszą ziemię dla faraona. Macie tu ziarno, obsiejcie nim pola. ");
INSERT INTO polubg_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","A piątą część waszych plonów oddacie faraonowi, cztery zaś części będą wasze – na obsianie pól i na żywność dla tych, którzy są w waszych domach, i na żywność dla waszych dzieci. ");
INSERT INTO polubg_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Wtedy odpowiedzieli: Uratowałeś nam życie! Obyśmy znaleźli łaskę w oczach swego pana, a będziemy niewolnikami faraona. ");
INSERT INTO polubg_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","I Józef ustanowił to jako prawo aż do dziś w ziemi Egiptu, aby faraonowi oddawano piątą część plonów. Tylko ziemia samych kapłanów nie stała się własnością faraona. ");
INSERT INTO polubg_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Izrael mieszkał w ziemi Egiptu, w ziemi Goszen. Nabywali w niej posiadłości na własność, byli płodni i bardzo się rozmnożyli. ");
INSERT INTO polubg_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","I Jakub żył w ziemi Egiptu siedemnaście lat. A w sumie Jakub przeżył sto czterdzieści siedem lat. ");
INSERT INTO polubg_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","I zbliżył się czas śmierci Izraela. Wezwał więc swego syna Józefa i powiedział do niego: Jeśli teraz znalazłem łaskę w twoich oczach, połóż, proszę, twoją rękę pod moje biodro, a wyświadcz mi tę łaskę i wierność: Proszę, nie chowaj mnie w Egipcie; ");
INSERT INTO polubg_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ale gdy zasnę z moimi ojcami, wywieziesz mnie z Egiptu i pochowasz mnie w ich grobie. A on powiedział: Uczynię według twego słowa. ");
INSERT INTO polubg_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","A Jakub powiedział: Przysięgnij mi. I przysiągł mu. Potem Izrael pokłonił się na wezgłowie łoża. ");
INSERT INTO polubg_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Gdy to się stało, dano znać Józefowi: Oto twój ojciec zachorował. Wziął więc ze sobą swoich dwóch synów, Manassesa i Efraima. ");
INSERT INTO polubg_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","I powiedziano Jakubowi: Oto twój syn Józef idzie do ciebie. A Izrael zebrał siłę i usiadł na łożu. ");
INSERT INTO polubg_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Wtedy Jakub powiedział do Józefa: Bóg Wszechmogący ukazał mi się w Luz, w ziemi Kanaan, i błogosławił mi. ");
INSERT INTO polubg_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","I powiedział do mnie: Oto ja uczynię cię płodnym i rozmnożę cię, i wywiodę z ciebie wielki lud. I dam tę ziemię twemu potomstwu po tobie w wieczne dziedzictwo. ");
INSERT INTO polubg_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Dlatego teraz twoi dwaj synowie, Efraim i Manasses, którzy urodzili ci się w ziemi Egiptu, zanim przyszedłem tu do ciebie do Egiptu, są moimi. Będą moi jak Ruben i Symeon. ");
INSERT INTO polubg_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ale twoje dzieci, które spłodzisz po nich, będą twoje; będą zwane w swych posiadłościach imieniem swoich braci. ");
INSERT INTO polubg_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","A gdy wracałem z Paddan, umarła mi Rachela w ziemi Kanaan, w drodze, gdy byłem jeszcze w niewielkiej odległości od Efraty, i pogrzebałem ją tam przy drodze do Efraty, czyli Betlejem. ");
INSERT INTO polubg_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","A gdy Izrael zobaczył synów Józefa, zapytał: Czyi oni są? ");
INSERT INTO polubg_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Józef odpowiedział swemu ojcu: To są moi synowie, których Bóg dał mi tutaj. A on powiedział: Proszę, przyprowadź ich do mnie, abym im błogosławił. ");
INSERT INTO polubg_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","A oczy Izraela były tak słabe ze starości, że nie mógł widzieć. I przyprowadził ich do niego, a Jakub ich pocałował i uścisnął. ");
INSERT INTO polubg_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Potem Izrael powiedział do Józefa: Nie spodziewałem się, że będę jeszcze oglądał twoją twarz, a oto Bóg dał mi widzieć nawet twoje potomstwo. ");
INSERT INTO polubg_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Wtedy Józef odsunął ich od jego kolan i pokłonił się twarzą aż do ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Potem Józef wziął obydwu i postawił Efraima po swojej prawej ręce, czyli po lewej stronie Izraela; a Manassesa po swojej lewej ręce, czyli po prawej stronie Izraela, i przyprowadził ich do niego. ");
INSERT INTO polubg_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Izrael wyciągnął swoją prawą rękę, położył ją na głowę Efraima, który był młodszy, a swoją lewą rękę na głowę Manassesa, umyślnie pokładając swoje ręce, choć pierworodny był Manasses. ");
INSERT INTO polubg_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","I błogosławił Józefowi, mówiąc: Bóg, przed którego obliczem chodzili moi ojcowie, Abraham i Izaak, Bóg, który mnie żywił od mej młodości aż do dziś; ");
INSERT INTO polubg_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Anioł, który wybawił mnie ze wszelkiego zła, niech błogosławi tym chłopcom i niech będą nazywani od mego imienia i od imienia moich ojców, Abrahama i Izaaka, i niech się rozmnożą na ziemi. ");
INSERT INTO polubg_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","A gdy Józef zobaczył, że jego ojciec położył swoją prawą rękę na głowę Efraima, nie podobało mu się to. Wziął więc rękę swego ojca, aby ją przenieść z głowy Efraima na głowę Manassesa. ");
INSERT INTO polubg_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","I Józef powiedział do swego ojca: Nie tak, mój ojcze. Ten bowiem jest pierworodny, połóż swoją prawą rękę na jego głowę. ");
INSERT INTO polubg_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ale jego ojciec wzbraniał się i powiedział: Wiem, mój synu, wiem. Ten też stanie się ludem i on też urośnie, ale jego młodszy brat go przewyższy, a z jego potomstwa wyjdzie mnóstwo narodów. ");
INSERT INTO polubg_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Błogosławił im więc tego dnia, mówiąc: Przez ciebie Izrael będzie błogosławił, mówiąc: Niech Bóg cię uczyni jak Efraim i jak Manasses. Tak wyróżnił Efraima przed Manassesem. ");
INSERT INTO polubg_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Potem Izrael powiedział do Józefa: Oto ja umieram, ale Bóg będzie z wami i przywróci was do ziemi waszych ojców. ");
INSERT INTO polubg_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Oto daję ci jedną część więcej niż twoim braciom, którą nabyłem moim mieczem i moim łukiem z ręki Amorytów. ");
INSERT INTO polubg_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Potem Jakub wezwał swoich synów i powiedział: Zbierzcie się, a oznajmię wam, co was spotka w waszych ostatnich dniach. ");
INSERT INTO polubg_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Zbierzcie się i słuchajcie, synowie Jakuba, a słuchajcie waszego ojca Izraela. ");
INSERT INTO polubg_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubenie, mój pierworodny, ty jesteś moją mocą i początkiem mojej siły, pierwszy dostojeństwem i pierwszy męstwem. ");
INSERT INTO polubg_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Niestabilny jak woda, nie będziesz przodować, bo wstąpiłeś do łoża twego ojca; wstępując do mojego posłania, zbezcześciłeś je. ");
INSERT INTO polubg_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Symeon i Lewi, bracia, ich miecze to narzędzia przemocy. ");
INSERT INTO polubg_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Niech moja dusza nie wchodzi w ich radę, niech moja sława nie jednoczy się z ich zgromadzeniem, bo w swej zapalczywości zabili człowieka, a w samowoli wywrócili mur. ");
INSERT INTO polubg_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Przeklęta ich zapalczywość, bo uparta, i ich gniew, bo zatwardziały. Rozdzielę ich w Jakubie, a rozproszę ich w Izraelu. ");
INSERT INTO polubg_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judo, to ciebie będą chwalić twoi bracia, twoja ręka będzie na karku twoich nieprzyjaciół, synowie twego ojca będą ci się kłaniać. ");
INSERT INTO polubg_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judo, szczenię lwie, wróciłeś od łupu, mój synu. Skłonił się i położył się jak lew i jak lwica. Któż go obudzi? ");
INSERT INTO polubg_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nie będzie odjęte berło od Judy ani prawodawca spomiędzy jego nóg, aż przyjdzie Szylo i jemu będą posłuszne narody. ");
INSERT INTO polubg_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Przywiąże do winorośli swoje oślę, a do wybornej winorośli – oślątko swojej oślicy. Wypierze w winie swoją szatę, a we krwi winogron – swoje odzienie. ");
INSERT INTO polubg_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Jego oczy czerwone od wina, a zęby białe od mleka. ");
INSERT INTO polubg_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulon będzie mieszkać na morskim brzegu, przy porcie okrętów, a jego granice będą aż do Sydonu. ");
INSERT INTO polubg_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issachar jak osioł kościsty leżący między dwoma brzemionami. ");
INSERT INTO polubg_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Zobaczył, że spoczynek jest dobry i ziemię, że jest urocza, nachylił swe ramię, by dźwigać, i stał się sługą składającym daninę. ");
INSERT INTO polubg_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan będzie sądzić swój lud jako jedno z pokoleń Izraela. ");
INSERT INTO polubg_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan będzie wężem na drodze, żmiją na ścieżce kąsającą końskie pięty, tak że jeździec spadnie do tyłu. ");
INSERT INTO polubg_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Oczekuję twego zbawienia, PANIE! ");
INSERT INTO polubg_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad będzie zwyciężony przez wojsko, ale on na koniec zwycięży. ");
INSERT INTO polubg_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Od Aszera będzie tłusty chleb, a on dostarczy przysmaków królewskich. ");
INSERT INTO polubg_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftali jak wypuszczona łania, mówiący piękne słowa. ");
INSERT INTO polubg_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Józef, latorośl płodna, latorośl płodna przy źródle, a jej szczepy rozchodzą się po murze. ");
INSERT INTO polubg_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Choć napoili go goryczą i strzelali do niego, i nienawidzili go strzelcy; ");
INSERT INTO polubg_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Jednak jego łuk został potężny i wzmocniły się ramiona jego rąk dzięki rękom mocnego Boga Jakuba, stamtąd pasterz i opoka Izraela. ");
INSERT INTO polubg_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Od Boga twego ojca, który będzie cię wspomagał, i od Wszechmogącego, który ci pobłogosławi błogosławieństwami nieba z wysoka i błogosławieństwami głębin leżących na dole, i błogosławieństwami piersi i łona. ");
INSERT INTO polubg_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Błogosławieństwa twego ojca będą mocniejsze niż błogosławieństwa moich przodków aż do granic pagórków wiecznych. Będą nad głową Józefa i nad wierzchem głowy odłączonego od swych braci. ");
INSERT INTO polubg_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beniamin jak drapieżny wilk, rano będzie jeść zdobycz, a wieczorem będzie dzielił łupy. ");
INSERT INTO polubg_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Oto wszystkich dwanaście pokoleń Izraela i to, co im powiedział ich ojciec, gdy im błogosławił. Każdemu według jego błogosławieństwa błogosławił. ");
INSERT INTO polubg_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Potem im nakazał: Ja będę przyłączony do mojego ludu. Pogrzebcie mnie z moimi ojcami w jaskini, która jest na polu Efrona Chetyty; ");
INSERT INTO polubg_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","W jaskini, która jest na polu Makpela naprzeciwko Mamre w ziemi Kanaan. Kupił ją wraz z polem Abraham od Efrona Chetyty jako grób na własność. ");
INSERT INTO polubg_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Tam pogrzebano Abrahama i jego żonę Sarę, tam pogrzebano Izaaka i jego żonę Rebekę. Tam też pogrzebałem Leę. ");
INSERT INTO polubg_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Pole to i jaskinię na nim kupiono od synów Cheta. ");
INSERT INTO polubg_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","A gdy Jakub przestał mówić do swoich synów, złożył swoje nogi na łoże i umarł, i został przyłączony do swego ludu. ");
INSERT INTO polubg_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Wtedy Józef przypadł do twarzy swego ojca i płakał nad nim, i całował go. ");
INSERT INTO polubg_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Potem Józef rozkazał swoim sługom, lekarzom, aby zabalsamowali jego ojca. I lekarze zabalsamowali Izraela. ");
INSERT INTO polubg_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","I minęło czterdzieści dni, bo tyle trwa balsamowanie. Egipcjanie opłakiwali go przez siedemdziesiąt dni. ");
INSERT INTO polubg_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Po upływie dni żałoby Józef powiedział do domowników faraona: Jeśli znalazłem teraz łaskę w waszych oczach, powiedzcie, proszę, do uszu faraona: ");
INSERT INTO polubg_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mój ojciec zobowiązał mnie przysięgą i powiedział: Oto ja umieram. Pogrzebiesz mnie w moim grobie, który sobie wykopałem w ziemi Kanaan. Teraz, proszę, pozwól mi pojechać i pogrzebać mego ojca, a potem wrócę. ");
INSERT INTO polubg_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faraon powiedział: Jedź i pogrzeb twego ojca, jak cię zobowiązał przysięgą. ");
INSERT INTO polubg_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Józef pojechał więc, aby pogrzebać swego ojca. Jechali też z nim wszyscy słudzy faraona, także starsi jego domu i wszyscy starsi ziemi Egiptu; ");
INSERT INTO polubg_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","I cały dom Józefa, jego bracia i dom jego ojca. Tylko swoje dzieci, swoje owce i swoje woły zostawili w ziemi Goszen. ");
INSERT INTO polubg_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Wyruszyły też z nimi wozy i wyruszyli jeźdźcy. A orszak był bardzo wielki. ");
INSERT INTO polubg_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","I przyjechali aż do klepiska Atad, które jest za Jordanem, i tam opłakiwali go wielkim i bardzo głębokim lamentem. Józef przez siedem dni obchodził żałobę po swym ojcu. ");
INSERT INTO polubg_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","A gdy obywatele ziemi Kanaan zobaczyli tę żałobę na klepisku Atad, mówili: To ciężka żałoba Egipcjan. Dlatego nazwano to miejsce Ebel-Misraim; leży ono za Jordanem. ");
INSERT INTO polubg_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jego synowie uczynili więc z nim tak, jak im rozkazał. ");
INSERT INTO polubg_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Jego synowie zawieźli go do ziemi Kanaan i pogrzebali go w jaskini na polu Makpela naprzeciwko Mamre, którą kupił Abraham wraz z polem od Efrona Chetyty jako grób na własność. ");
INSERT INTO polubg_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Po pogrzebie swego ojca Józef wrócił do Egiptu wraz ze swymi braćmi i ze wszystkimi, którzy pojechali z nim na pogrzeb jego ojca. ");
INSERT INTO polubg_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","A bracia Józefa, widząc, że ich ojciec umarł, mówili: Może Józef będzie nas nienawidził i odpłaci nam sowicie za to wszystko zło, które mu uczyniliśmy. ");
INSERT INTO polubg_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kazali więc powiedzieć do Józefa: Twój ojciec, zanim umarł, nakazał: ");
INSERT INTO polubg_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Tak powiedzcie Józefowi: Proszę, wybacz teraz przestępstwo twoich braci i ich grzech, że wyrządzili ci zło. Proszę, wybacz teraz występek sługom Boga twego ojca. I Józef płakał, gdy to mówili do niego. ");
INSERT INTO polubg_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","I jego bracia podeszli, i upadli przed nim, mówiąc: Oto jesteśmy twoimi sługami. ");
INSERT INTO polubg_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Józef powiedział do nich: Nie bójcie się. Czyż ja jestem na miejscu Boga? ");
INSERT INTO polubg_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Obmyśliliście zło przeciwko mnie, ale Bóg obrócił to w dobro, żeby sprawić to, co się dziś dzieje, aby zachować tak wielki lud. ");
INSERT INTO polubg_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Teraz więc nie bójcie się. Ja będę żywić was i wasze dzieci. I tak ich pocieszał, i serdecznie z nimi rozmawiał. ");
INSERT INTO polubg_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","I Józef mieszkał w Egipcie, on sam i dom jego ojca. A Józef żył sto dziesięć lat. ");
INSERT INTO polubg_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Józef oglądał synów Efraima aż do trzeciego pokolenia. Także synowie Makira, syna Manassesa, wychowali się na kolanach Józefa. ");
INSERT INTO polubg_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Potem Józef powiedział do swoich braci: Ja umrę, ale Bóg na pewno was nawiedzi i wyprowadzi z tej ziemi do ziemi, którą przysiągł Abrahamowi, Izaakowi i Jakubowi. ");
INSERT INTO polubg_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Józef zobowiązał więc przysięgą synów Izraela i powiedział: Bóg na pewno was nawiedzi, a wtedy zabierzcie stąd moje kości. ");
INSERT INTO polubg_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","I Józef umarł, mając sto dziesięć lat. Zabalsamowano go i złożono do trumny w Egipcie. ");
INSERT INTO polubg_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Oto imiona synów Izraela, którzy przybyli z Jakubem do Egiptu; każdy przybył ze swoją rodziną: ");
INSERT INTO polubg_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Symeon, Lewi i Juda; ");
INSERT INTO polubg_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulon i Beniamin; ");
INSERT INTO polubg_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neftali, Gad i Aszer. ");
INSERT INTO polubg_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","A wszystkich dusz, które wyszły z bioder Jakuba, było siedemdziesiąt. Józef zaś już był w Egipcie. ");
INSERT INTO polubg_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Potem umarli Józef, wszyscy jego bracia i całe to pokolenie. ");
INSERT INTO polubg_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","A synowie Izraela byli płodni, rozrodzili się, rozmnożyli i bardzo umacniali, a ziemia była ich pełna. ");
INSERT INTO polubg_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Wówczas nastał nad Egiptem nowy król, który nie znał Józefa. ");
INSERT INTO polubg_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","I powiedział do swego ludu: Oto lud synów Izraela stał się liczniejszy i potężniejszy od nas. ");
INSERT INTO polubg_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Postąpmy więc z nimi mądrze, by się nie rozmnożyli, bo gdyby przyszła wojna, mogliby przyłączyć się do naszych wrogów i walczyć przeciwko nam, i opuścić ziemię. ");
INSERT INTO polubg_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ustanowiono więc nad nimi nadzorców, aby ich gnębili ciężarami. I lud Izraela zbudował dla faraona miasta na składy: Pitom i Ramzes. ");
INSERT INTO polubg_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ale im bardziej ich gnębili, tym bardziej się rozmnażali i rośli, tak że zatrwożyli się z powodu synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","I Egipcjanie zmuszali synów Izraela do ciężkiej pracy. ");
INSERT INTO polubg_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","I uprzykrzali im życie uciążliwą pracą przy glinie i przy cegłach, i przy każdej robocie na polu. Do wszelkiej pracy zmuszali ich bez litości. ");
INSERT INTO polubg_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","I król Egiptu rozkazał hebrajskim położnym, z których jedna miała na imię Szifra, a druga Pua; ");
INSERT INTO polubg_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Powiedział: Gdy będziecie przy porodach hebrajskich kobiet i zobaczycie, że urodził się syn, zabijcie go, a jeśli córka, niech zostanie przy życiu. ");
INSERT INTO polubg_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Lecz położne bały się Boga i nie robiły tak, jak im rozkazał król Egiptu, ale pozostawiały chłopców przy życiu. ");
INSERT INTO polubg_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Wtedy król Egiptu wezwał położne i powiedział do nich: Dlaczego tak postąpiłyście, że pozostawiłyście chłopców przy życiu? ");
INSERT INTO polubg_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Położne odpowiedziały faraonowi: Hebrajskie kobiety nie są takie jak egipskie kobiety. Są bowiem żywotne, rodzą wcześniej, zanim przyjdzie do nich położna. ");
INSERT INTO polubg_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","I Bóg dobrze czynił tym położnym, a lud się mnożył i bardzo się wzmocnił. ");
INSERT INTO polubg_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","A ponieważ położne bały się Boga, zbudował im domy. ");
INSERT INTO polubg_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Wtedy faraon rozkazał całemu swemu ludowi: Każdego syna, który się urodzi, wrzućcie do rzeki, a każdą córkę pozostawcie przy życiu. ");
INSERT INTO polubg_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Pewien mężczyzna z rodu Lewiego pojął za żonę córkę z rodu Lewiego. ");
INSERT INTO polubg_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Kobieta ta poczęła i urodziła syna, a gdy zobaczyła, że jest piękny, ukrywała go przez trzy miesiące. ");
INSERT INTO polubg_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ale gdy nie mogła go dłużej ukrywać, wzięła koszyk z sitowia, wysmarowała żywicą i smołą, włożyła do niego dziecko i umieściła między trzcinami na brzegu rzeki. ");
INSERT INTO polubg_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","A jego siostra stała daleko, aby wiedzieć, co się z nim stanie. ");
INSERT INTO polubg_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Wtedy zeszła do rzeki córka faraona, aby się wykąpać, a jej służące przechadzały się po brzegu rzeki. Gdy zobaczyła koszyk w trzcinie, posłała swą służącą, aby go wzięła. ");
INSERT INTO polubg_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Kiedy go otworzyła, zobaczyła dziecko, a chłopiec płakał. Ulitowała się nad nim i powiedziała: To jedno z hebrajskich dzieci. ");
INSERT INTO polubg_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Wówczas jego siostra zapytała córkę faraona: Czy mam pójść i zawołać ci mamkę spośród hebrajskich kobiet, aby ci wykarmiła to dziecko? ");
INSERT INTO polubg_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Córka faraona odpowiedziała jej: Idź. Dziewczynka poszła więc i zawołała matkę tego dziecka. ");
INSERT INTO polubg_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Do niej powiedziała córka faraona: Weź to dziecko i wykarm mi je, a ja dam ci należną zapłatę. Kobieta wzięła więc dziecko i wykarmiła je. ");
INSERT INTO polubg_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","A gdy dziecko podrosło, przyprowadziła je do córki faraona i stało się jej synem. I nadała mu imię Mojżesz, bo mówiła: Wyciągnęłam go z wody. ");
INSERT INTO polubg_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Kiedy Mojżesz dorósł, wyszedł do swych braci i widział ich ciężary. Zobaczył też Egipcjanina, który bił Hebrajczyka, jednego z jego braci. ");
INSERT INTO polubg_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Rozejrzał się na wszystkie strony, a gdy zobaczył, że nikogo nie ma, zabił Egipcjanina i ukrył go w piasku. ");
INSERT INTO polubg_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","A gdy wyszedł następnego dnia, oto kłócili się dwaj Hebrajczycy. Wtedy zapytał tego, który wyrządzał krzywdę: Dlaczego bijesz swego bliźniego? ");
INSERT INTO polubg_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ten mu odpowiedział: Któż cię ustanowił przełożonym i sędzią nad nami? Czy zamierzasz mnie zabić, jak zabiłeś Egipcjanina? Wtedy Mojżesz zląkł się i powiedział: Na pewno sprawa wyszła na jaw. ");
INSERT INTO polubg_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Gdy faraon usłyszał o sprawie, usiłował zabić Mojżesza. Lecz Mojżesz uciekł przed faraonem i zamieszkał w ziemi Midian. I zatrzymał się tam przy pewnej studni. ");
INSERT INTO polubg_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","A kapłan Midianitów miał siedem córek. Przyszły one, naczerpały wody i napełniły koryta, aby napoić stado swego ojca; ");
INSERT INTO polubg_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ale nadeszli pasterze i odganiali je. Wtedy Mojżesz wstał, obronił je i napoił ich bydło. ");
INSERT INTO polubg_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Gdy wróciły do swego ojca Reuela, ten zapytał: Dlaczego dziś przyszłyście tak szybko? ");
INSERT INTO polubg_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","One odpowiedziały: Jakiś Egipcjanin wybawił nas z rąk pasterzy, naczerpał nam też wody i napoił stado. ");
INSERT INTO polubg_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Wtedy zapytał swoje córki: A gdzie on jest? Dlaczego zostawiłyście tego człowieka? Zawołajcie go, aby zjadł chleb. ");
INSERT INTO polubg_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mojżesz zgodził się zamieszkać u tego człowieka, a ten dał Mojżeszowi swoją córkę Seforę. ");
INSERT INTO polubg_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ta urodziła mu syna, któremu nadał imię Gerszom, bo mówił: Byłem przybyszem w obcej ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Po dłuższym czasie umarł król Egiptu, a synowie Izraela wzdychali i wołali z powodu niewoli. Ich wołanie z powodu niewoli dotarło do Boga. ");
INSERT INTO polubg_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Bóg usłyszał ich jęk i wspomniał Bóg na swoje przymierze z Abrahamem, Izaakiem i Jakubem. ");
INSERT INTO polubg_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","I spojrzał Bóg na synów Izraela, i miał Bóg na nich wzgląd. ");
INSERT INTO polubg_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mojżesz pasał stado swego teścia Jetra, kapłana Midianitów. Zaprowadził stado na drugą stronę pustyni i przyszedł do góry Bożej, do Horebu. ");
INSERT INTO polubg_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","I Anioł PANA ukazał mu się w płomieniu ognia, ze środka krzewu. Spojrzał, a oto krzew płonął ogniem, lecz nie spłonął. ");
INSERT INTO polubg_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Wtedy Mojżesz powiedział: Podejdę i zobaczę to wielkie zjawisko, dlaczego ten krzew się nie spala. ");
INSERT INTO polubg_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","A gdy PAN widział, że podchodził, aby to zobaczyć, zawołał do niego Bóg ze środka tego krzewu: Mojżeszu, Mojżeszu! A on odpowiedział: Oto jestem. ");
INSERT INTO polubg_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Wtedy powiedział: Nie zbliżaj się tu. Zdejmij buty z nóg, bo miejsce, na którym stoisz, jest ziemią świętą. ");
INSERT INTO polubg_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","I dodał: Ja jestem Bogiem twego ojca, Bogiem Abrahama, Bogiem Izaaka i Bogiem Jakuba. I Mojżesz zakrył twarz, bo bał się patrzeć na Boga. ");
INSERT INTO polubg_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","PAN powiedział: Przyjrzałem się utrapieniom mojego ludu, który jest w Egipcie, i słyszałem ich krzyk z powodu nadzorców, gdyż znam jego cierpienia. ");
INSERT INTO polubg_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Dlatego zstąpiłem, aby wybawić go z ręki Egipcjan i wyprowadzić z tej ziemi do ziemi dobrej i przestronnej, do ziemi opływającej mlekiem i miodem, na miejsce Kananejczyków, Chetytów, Amorytów, Peryzzytów, Chiwwitów i Jebusytów. ");
INSERT INTO polubg_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Teraz oto dotarł do mnie krzyk synów Izraela. Widziałem też ucisk, jakim dręczą ich Egipcjanie. ");
INSERT INTO polubg_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Dlatego teraz idź, poślę cię do faraona, abyś wyprowadził mój lud, synów Izraela, z Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mojżesz powiedział do Boga: Kimże ja jestem, abym miał iść do faraona i wyprowadzić synów Izraela z Egiptu? ");
INSERT INTO polubg_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Bóg odpowiedział: Oto ja będę z tobą, a to będzie znakiem dla ciebie, że ja cię posłałem: gdy wyprowadzisz ten lud z Egiptu, będziecie służyć Bogu na tej górze. ");
INSERT INTO polubg_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mojżesz powiedział do Boga: Kiedy pójdę do synów Izraela i powiem im: Bóg waszych ojców posłał mnie do was, a oni zapytają mnie, jakie jest jego imię, cóż im odpowiem? ");
INSERT INTO polubg_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Wtedy Bóg odrzekł do Mojżesza: JESTEM, KTÓRY JESTEM. I dodał: Tak powiesz synom Izraela: JESTEM posłał mnie do was. ");
INSERT INTO polubg_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","I mówił jeszcze Bóg do Mojżesza: Tak powiesz synom Izraela: PAN, Bóg waszych ojców, Bóg Abrahama, Bóg Izaaka i Bóg Jakuba, posłał mnie do was. To jest moje imię na wieki i takim ma pozostać w pamięci po wszystkie pokolenia. ");
INSERT INTO polubg_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Idź, zgromadź starszych Izraela i mów do nich: Ukazał mi się PAN, Bóg waszych ojców, Bóg Abrahama, Izaaka i Jakuba, i powiedział: Nawiedziłem was i widziałem, co wam uczyniono w Egipcie. ");
INSERT INTO polubg_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","I postanowiłem: Wyprowadzę was z utrapienia Egiptu do ziemi Kananejczyków, Chetytów, Amorytów, Peryzzytów, Chiwwitów i Jebusytów, do ziemi opływającej mlekiem i miodem. ");
INSERT INTO polubg_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Wtedy usłuchają twego głosu. I pójdziesz ty i starsi Izraela do króla Egiptu i powiecie do niego: PAN, Bóg Hebrajczyków, spotkał się z nami. Dlatego teraz pozwól nam pójść, proszę, w trzy dni drogi na pustynię, aby złożyć ofiarę PANU, naszemu Bogu. ");
INSERT INTO polubg_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Wiem, że król Egiptu nie pozwoli wam odejść, chyba że przez potężną rękę. ");
INSERT INTO polubg_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Wyciągnę więc rękę i uderzę Egipt wszystkimi moimi cudami, które będę czynił pośród niego. A potem was wypuści. ");
INSERT INTO polubg_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Sprawię, że ten lud znajdzie przychylność w oczach Egipcjan. I stanie się tak, gdy będziecie wychodzić, że nie wyjdziecie z pustymi rękami. ");
INSERT INTO polubg_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ale każda kobieta pożyczy od swojej sąsiadki i od tej, która u niej przebywa, srebrne i złote przedmioty oraz szaty. Włożycie je na waszych synów i na wasze córki i złupicie Egipt. ");
INSERT INTO polubg_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Potem Mojżesz odpowiedział: Lecz oni mi nie uwierzą i nie usłuchają mego głosu, bo powiedzą: PAN ci się nie ukazał. ");
INSERT INTO polubg_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","PAN zapytał go: Co masz w swojej ręce? Odpowiedział: Laskę. ");
INSERT INTO polubg_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","I rozkazał: Rzuć ją na ziemię. Rzucił ją więc na ziemię i zamieniła się w węża; i Mojżesz przed nim uciekał. ");
INSERT INTO polubg_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Następnie PAN powiedział do Mojżesza: Wyciągnij rękę i chwyć go za ogon. Wyciągnął więc rękę i chwycił go, i ten zamienił się w laskę w jego ręce. ");
INSERT INTO polubg_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Uczyń tak, aby uwierzyli, że ukazał ci się PAN, Bóg ich ojców, Bóg Abrahama, Bóg Izaaka i Bóg Jakuba. ");
INSERT INTO polubg_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","PAN powiedział mu jeszcze: Włóż teraz rękę w zanadrze. Włożył więc rękę w zanadrze, a gdy ją wyjął, była pokryta trądem jak śniegiem. ");
INSERT INTO polubg_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","I powiedział: Włóż ponownie rękę w zanadrze. I włożył znowu rękę w zanadrze, a gdy ją wyjął, stała się znowu jak reszta jego ciała. ");
INSERT INTO polubg_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Jeśli więc ci nie uwierzą i nie usłuchają głosu pierwszego znaku, to uwierzą głosowi drugiego znaku. ");
INSERT INTO polubg_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","A jeśli nie uwierzą obu tym znakom i nie usłuchają twego głosu, to weźmiesz wody z rzeki i wylejesz ją na ziemię. Wtedy ta woda, którą weźmiesz z rzeki, zamieni się na ziemi w krew. ");
INSERT INTO polubg_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mojżesz powiedział do PANA: Proszę, Panie, nie jestem wymowny – ani przedtem, ani odkąd przemówiłeś do twego sługi, bo mam powolną mowę i ociężały język. ");
INSERT INTO polubg_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","PAN mu odpowiedział: Któż uczynił usta człowieka? Albo kto czyni niemego lub głuchego, widzącego lub ślepego? Czyż nie ja, PAN? ");
INSERT INTO polubg_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Teraz więc idź, a ja będę przy twoich ustach i pouczę cię, co masz mówić. ");
INSERT INTO polubg_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mojżesz powiedział: Proszę, Panie, poślij tego, kogo masz posłać. ");
INSERT INTO polubg_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Wtedy zapalił się gniew PANA na Mojżesza i powiedział: Czyż Aaron, Lewita, nie jest twoim bratem? Wiem, że on potrafi dobrze mówić. Oto on wyjdzie ci na spotkanie, a gdy cię zobaczy, uraduje się w swoim sercu. ");
INSERT INTO polubg_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ty będziesz mówił do niego i włożysz słowa w jego usta. A ja będę przy twoich ustach i przy jego ustach i pouczę was, co macie czynić. ");
INSERT INTO polubg_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","On będzie mówił za ciebie do ludu. On będzie dla ciebie jakby ustami, a ty dla niego będziesz jakby Bogiem. ");
INSERT INTO polubg_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","I weź w rękę tę laskę, którą będziesz czynił znaki. ");
INSERT INTO polubg_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Odszedł więc Mojżesz i wrócił do swego teścia Jetra, i powiedział do niego: Pozwól mi wrócić do moich braci, którzy są w Egipcie, aby zobaczyć, czy jeszcze żyją. Jetro odpowiedział Mojżeszowi: Idź w pokoju. ");
INSERT INTO polubg_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","PAN rzekł do Mojżesza w ziemi Midian: Idź, wróć do Egiptu, bo pomarli wszyscy, którzy czyhali na twoje życie. ");
INSERT INTO polubg_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mojżesz więc wziął swoją żonę i swoich synów, wsadził ich na osła i wyruszył do ziemi Egiptu. Wziął też Mojżesz laskę Boga do ręki. ");
INSERT INTO polubg_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","PAN powiedział do Mojżesza: Gdy pójdziesz i wrócisz do Egiptu, dopilnuj, abyś wszystkich cudów, które dałem ci do ręki, dokonał przed faraonem. A ja zatwardzę jego serce, tak że nie wypuści ludu. ");
INSERT INTO polubg_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","I powiesz do faraona: Tak mówi PAN: Izrael jest moim synem, moim pierworodnym. ");
INSERT INTO polubg_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Mówię ci: Wypuść mego syna, aby mi służył. Jeśli będziesz się wzbraniał wypuścić go, zabiję twojego syna, twego pierworodnego. ");
INSERT INTO polubg_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","A w czasie drogi, w gospodzie, PAN zastąpił drogę Mojżeszowi i chciał go zabić. ");
INSERT INTO polubg_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Wtedy Sefora wzięła ostry kamień, odcięła napletek swego syna i rzuciła do jego stóp, i powiedziała: Naprawdę jesteś dla mnie oblubieńcem krwi. ");
INSERT INTO polubg_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","I PAN odstąpił od niego. Wtedy nazwała go oblubieńcem krwi z powodu obrzezania. ");
INSERT INTO polubg_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","A do Aarona PAN powiedział: Wyjdź naprzeciw Mojżeszowi na pustynię. Wyszedł więc i spotkał go na górze Boga, i pocałował go. ");
INSERT INTO polubg_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Wtedy Mojżesz powtórzył Aaronowi wszystkie słowa PANA, który go posłał, i wszystkie znaki, które nakazał mu uczynić. ");
INSERT INTO polubg_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mojżesz i Aaron poszli więc i zebrali wszystkich starszych synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","I Aaron powiedział wszystkie słowa, które PAN mówił do Mojżesza, a Mojżesz czynił znaki na oczach ludu. ");
INSERT INTO polubg_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","I lud uwierzył. I gdy usłyszeli, że PAN nawiedził synów Izraela i że wejrzał na ich utrapienie, pochylili się i oddali pokłon. ");
INSERT INTO polubg_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Potem Mojżesz i Aaron przyszli do faraona i powiedzieli: Tak mówi PAN, Bóg Izraela: Wypuść mój lud, aby dla mnie obchodził święto na pustyni. ");
INSERT INTO polubg_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Faraon odparł: Któż to jest PAN, abym miał słuchać jego głosu i wypuścić Izraela? Nie znam PANA, a Izraela też nie wypuszczę. ");
INSERT INTO polubg_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","I odpowiedzieli: Bóg Hebrajczyków ukazał się nam. Pozwól nam iść trzy dni drogą na pustynię i złożyć ofiarę PANU, naszemu Bogu, by nie nawiedził nas zarazą albo mieczem. ");
INSERT INTO polubg_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Król Egiptu zapytał ich: Dlaczego wy, Mojżeszu i Aaronie, odrywacie lud od pracy? Idźcie do waszych robót. ");
INSERT INTO polubg_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","I faraon dodał: Oto lud tej ziemi jest teraz liczny, a wy go odrywacie od robót. ");
INSERT INTO polubg_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Rozkazał więc faraon tego dnia nadzorcom ludu i jego przełożonym: ");
INSERT INTO polubg_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Już więcej nie będziecie dawać ludowi słomy do wyrobu cegły, jak dotychczas. Niech sami idą i zbierają sobie słomę. ");
INSERT INTO polubg_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Wyznaczcie im tę samą liczbę cegieł, jaką wyrabiali poprzednio, nic nie zmniejszajcie. Próżnują bowiem i dlatego wołają: Pozwól nam pójść i złożyć ofiarę naszemu Bogu. ");
INSERT INTO polubg_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Niech praca tych ludzi będzie cięższa, aby byli nią zajęci, a nie ufali kłamliwym słowom. ");
INSERT INTO polubg_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Wtedy wyszli nadzorcy ludu i jego przełożeni i powiedzieli do ludu: Tak mówi faraon: Nie będę wam dawał słomy. ");
INSERT INTO polubg_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Sami idźcie, zbierajcie sobie słomę, gdzie ją możecie znaleźć. Mimo to nic nie będzie odjęte z waszej pracy. ");
INSERT INTO polubg_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Lud rozproszył się więc po całej ziemi Egiptu, aby zbierać ścierń zamiast słomy. ");
INSERT INTO polubg_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","A nadzorcy przynaglali, mówiąc: Wykonujcie wasze roboty, codzienną pracę jak wtedy, gdy wam dawano słomę. ");
INSERT INTO polubg_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","I bito przełożonych spośród synów Izraela, których nadzorcy faraona postawili nad nimi, i pytano ich: Dlaczego ani wczoraj, ani dzisiaj nie wykonaliście tej ilości cegieł jak poprzednio? ");
INSERT INTO polubg_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Przełożeni spośród synów Izraela przyszli więc do faraona i wołali: Czemu postępujesz tak ze swoimi sługami? ");
INSERT INTO polubg_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Nie dają twoim sługom słomy, a mówią: Róbcie cegłę. I oto biją twe sługi, a to wina twojego ludu. ");
INSERT INTO polubg_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","On odpowiedział: Próżnujecie, próżnujecie i dlatego mówicie: Pozwól nam pójść i złożyć ofiarę PANU. ");
INSERT INTO polubg_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Teraz więc idźcie i pracujcie. Słomy wam nie dadzą, ale macie dostarczać taką samą ilość cegieł. ");
INSERT INTO polubg_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","A przełożeni spośród synów Izraela zobaczyli, że są w złym położeniu, ponieważ mówiono: Nie zmniejszacie nic z dziennego wyrobu cegieł. ");
INSERT INTO polubg_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Gdy wychodzili od faraona, spotkali Mojżesza i Aarona, którzy na nich czekali. ");
INSERT INTO polubg_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","I powiedzieli do nich: Niech PAN wejrzy na was i osądzi, bo sprawiliście, że staliśmy się wstrętni w oczach faraona i w oczach jego sług, i daliście im do ręki miecz, aby nas zabili. ");
INSERT INTO polubg_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Wtedy Mojżesz wrócił do PANA i powiedział: Panie, dlaczego wyrządziłeś to zło twojemu ludowi? Dlaczego mnie tu posłałeś? ");
INSERT INTO polubg_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Odkąd bowiem poszedłem do faraona, aby mówić w twoim imieniu, gorzej się obchodzi z tym ludem; a ty nie wybawiłeś swego ludu. ");
INSERT INTO polubg_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Wtedy PAN powiedział do Mojżesza: Teraz zobaczysz, co uczynię faraonowi. Mocną ręką bowiem wypuści ich i mocną ręką wypędzi ich ze swojej ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nadto Bóg mówił do Mojżesza: Ja jestem PANEM. ");
INSERT INTO polubg_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Objawiłem się Abrahamowi, Izaakowi i Jakubowi pod tym imieniem: Bóg Wszechmogący, ale z mojego imienia JEHOWA nie byłem przez nich poznany. ");
INSERT INTO polubg_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ustanowiłem też z nimi moje przymierze, aby dać im ziemię Kanaan, ziemię ich pielgrzymowania, w której przebywali jako obcy. ");
INSERT INTO polubg_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Usłyszałem także jęk synów Izraela, których Egipcjanie trzymają w niewoli, i wspomniałem na moje przymierze. ");
INSERT INTO polubg_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Dlatego powiedz synom Izraela: Ja jestem PAN, wyprowadzę was spod ciężarów Egipcjan, wyrwę was z ich niewoli i wybawię was wyciągniętym ramieniem i przez wielkie sądy. ");
INSERT INTO polubg_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Wezmę was sobie za lud i będę wam Bogiem. Poznacie, że ja jestem PAN, wasz Bóg, który was wyprowadza spod ciężarów Egipcjan. ");
INSERT INTO polubg_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","I wprowadzę was do ziemi, którą przysiągłem dać Abrahamowi, Izaakowi i Jakubowi; i dam ją wam w dziedzictwo. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","I Mojżesz mówił tak do synów Izraela, ale nie usłuchali go z powodu udręki ducha i ciężkiej niewoli. ");
INSERT INTO polubg_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Wtedy PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Idź, powiedz faraonowi, królowi Egiptu, żeby wypuścił synów Izraela ze swej ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mojżesz zaś odpowiedział przed PANEM: Oto synowie Izraela nie posłuchali mnie, jakże więc posłucha mnie faraon? Jestem przecież nieobrzezanych warg. ");
INSERT INTO polubg_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Wtedy PAN przemówił do Mojżesza i Aarona i dał im rozkaz dla synów Izraela i dla faraona, króla Egiptu, aby wyprowadzili synów Izraela z ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Oto naczelnicy domów ich ojców: synowie Rubena, pierworodnego Izraela: Henoch, Pallu, Chesron i Karmi. To są rodziny Rubena. ");
INSERT INTO polubg_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Synowie Symeona: Jemuel, Jamin, Ohad, Jakin, Sochar i Szaul, syn Kananejki. To są rodziny Symeona. ");
INSERT INTO polubg_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Oto imiona synów Lewiego według ich pokoleń: Gerszon, Kehat i Merari. A lat życia Lewiego było sto trzydzieści siedem. ");
INSERT INTO polubg_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Synowie Gerszona: Libni i Szimei, według ich rodzin. ");
INSERT INTO polubg_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Synowie Kehata: Amram, Ishar, Chebron i Uzziel. A lat życia Kehata było sto trzydzieści trzy. ");
INSERT INTO polubg_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Synowie Merariego: Machli i Muszi. To są rodziny Lewiego według ich pokoleń. ");
INSERT INTO polubg_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","I Amram pojął za żonę Jokebed, swoją ciotkę, która urodziła mu Aarona i Mojżesza. A lat życia Amrama było sto trzydzieści siedem. ");
INSERT INTO polubg_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Synowie Ishara: Korach, Nefeg i Zikri. ");
INSERT INTO polubg_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Synowie Uzziela: Miszael, Elsafan i Sitri. ");
INSERT INTO polubg_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","I Aaron pojął za żonę Eliszebę, córkę Aminadaba, siostrę Nachszona. Ona mu urodziła Nadaba, Abihu, Eleazara i Itamara. ");
INSERT INTO polubg_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","A synowie Koracha: Assir, Elkana i Abiasaf. To są rodziny Korachitów. ");
INSERT INTO polubg_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","I Eleazar, syn Aarona, pojął za żonę jedną z córek Putiela. Ona mu urodziła Pinchasa. Oto są naczelnicy ojców Lewitów według ich rodzin. ");
INSERT INTO polubg_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","To są ci właśnie Aaron i Mojżesz, do których mówił PAN: Wyprowadźcie synów Izraela z ziemi Egiptu według ich zastępów. ");
INSERT INTO polubg_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","To oni mówili do faraona, króla Egiptu, aby wyprowadzić synów Izraela z Egiptu. To jest właśnie Mojżesz i Aaron. ");
INSERT INTO polubg_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","A w tym dniu, kiedy PAN mówił do Mojżesza w ziemi Egiptu; ");
INSERT INTO polubg_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","PAN powiedział do niego: Ja jestem PAN. Mów do faraona, króla Egiptu, wszystko, co do ciebie mówię. ");
INSERT INTO polubg_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mojżesz zaś odpowiedział przed PANEM: Oto jestem nieobrzezanych warg, jakże posłucha mnie faraon? ");
INSERT INTO polubg_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","I PAN powiedział do Mojżesza: Oto ustanowiłem cię bogiem dla faraona, a twój brat Aaron będzie twoim prorokiem. ");
INSERT INTO polubg_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ty powiesz wszystko, co ci rozkażę. A twój brat Aaron będzie mówił do faraona, aby wypuścił synów Izraela ze swojej ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","A ja zatwardzę serce faraona i pomnożę moje znaki i cuda w ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Faraon was nie posłucha, lecz ja położę moją rękę na Egipcie i wyprowadzę moje zastępy, mój lud, synów Izraela, z ziemi Egiptu przez wielkie sądy. ");
INSERT INTO polubg_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","A Egipcjanie poznają, że ja jestem PAN, gdy wyciągnę rękę na Egipt i wyprowadzę synów Izraela spośród nich. ");
INSERT INTO polubg_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mojżesz i Aaron uczynili więc, jak im PAN przykazał; tak właśnie uczynili. ");
INSERT INTO polubg_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mojżesz miał osiemdziesiąt lat, a Aaron osiemdziesiąt trzy lata, gdy mówili do faraona. ");
INSERT INTO polubg_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Wtedy PAN powiedział do Mojżesza i Aarona: ");
INSERT INTO polubg_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Gdy faraon powie wam: Uczyńcie jakiś cud, wtedy powiesz do Aarona: Weź swą laskę i rzuć ją przed faraonem, a zamieni się w węża. ");
INSERT INTO polubg_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mojżesz i Aaron przyszli do faraona i uczynili tak, jak PAN rozkazał. Aaron rzucił swoją laskę przed faraonem i jego sługami, a ona zamieniła się w węża. ");
INSERT INTO polubg_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Wtedy faraon wezwał mędrców i czarowników. I ci egipscy czarownicy uczynili to samo swoimi czarami. ");
INSERT INTO polubg_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Każdy z nich rzucił swoją laskę, a zamieniły się w węże. Lecz laska Aarona pożarła ich laski. ");
INSERT INTO polubg_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Serce faraona stało się jednak zatwardziałe i nie posłuchał ich, jak PAN zapowiedział. ");
INSERT INTO polubg_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Potem PAN powiedział do Mojżesza: Serce faraona jest zatwardziałe, wzbrania się wypuścić lud. ");
INSERT INTO polubg_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Idź do faraona rankiem, kiedy wyjdzie nad wodę. Staniesz naprzeciwko niego nad brzegiem rzeki i weźmiesz do ręki laskę, która się zamieniła w węża; ");
INSERT INTO polubg_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","I powiesz mu: PAN, Bóg Hebrajczyków, posłał mnie do ciebie, mówiąc: Wypuść mój lud, aby mi służył na pustyni, a oto dotąd nie posłuchałeś. ");
INSERT INTO polubg_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Dlatego tak mówi PAN: Po tym poznasz, że ja jestem PAN. Oto uderzę laską, która jest w mojej ręce, w wody, które są w rzece, a one zamienią się w krew. ");
INSERT INTO polubg_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ryby, które są w rzece, pozdychają i rzeka będzie cuchnąć. Egipcjanie się zmęczą poszukiwaniem wody z rzeki do picia. ");
INSERT INTO polubg_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","PAN mówił dalej do Mojżesza: Powiedz Aaronowi: Weź swoją laskę i wyciągnij rękę nad wody Egiptu, nad ich rzeki, nad ich strugi, nad ich jeziora i nad wszelkie zbiorowiska wód, a one zamienią się w krew. Krew będzie na całej ziemi Egiptu, tak w naczyniach drewnianych, jak i w kamiennych. ");
INSERT INTO polubg_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mojżesz i Aaron uczynili tak, jak PAN rozkazał. Aaron podniósł laskę i uderzył wody rzeki na oczach faraona i jego sług. I wszystkie wody rzeki zamieniły się w krew. ");
INSERT INTO polubg_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ryby, które były w rzece, pozdychały i rzeka zaczęła cuchnąć, tak że Egipcjanie nie mogli pić z niej wody. A krew była w całej ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Lecz egipscy czarownicy uczynili to samo swoimi czarami. Pozostało więc zatwardziałe serce faraona i nie posłuchał ich, jak PAN zapowiedział. ");
INSERT INTO polubg_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Faraon odwrócił się i poszedł do swego domu, i tego również nie wziął sobie do serca. ");
INSERT INTO polubg_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","I wszyscy Egipcjanie kopali wokół rzeki w poszukiwaniu wody do picia, bo nie mogli pić wody z rzeki. ");
INSERT INTO polubg_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","I upłynęło siedem dni od chwili, gdy PAN uderzył rzekę. ");
INSERT INTO polubg_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Potem PAN powiedział do Mojżesza: Idź do faraona i powiedz mu: Tak mówi PAN: Wypuść mój lud, aby mi służył. ");
INSERT INTO polubg_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","A jeśli będziesz się wzbraniał wypuścić go, oto dotknę żabami wszystkich twoich granic. ");
INSERT INTO polubg_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Rzeka zaroi się od żab, które wypełzną i wedrą się do twego domu, do twej sypialni, na twoje łoże, do domu twoich sług, między twój lud, do twoich pieców i w twoje dzieże. ");
INSERT INTO polubg_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Żaby wpełzną zarówno na ciebie, jak i na twój lud i na wszystkie twoje sługi. ");
INSERT INTO polubg_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","PAN dalej mówił do Mojżesza: Powiedz Aaronowi: Wyciągnij rękę ze swą laską nad rzeki, nad strugi i nad jeziora i sprowadź żaby na ziemię Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaron wyciągnął więc rękę nad wody Egiptu, a żaby wypełzły i pokryły ziemię Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Lecz czarownicy uczynili to samo swoimi czarami i sprowadzili żaby na ziemię Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Potem faraon wezwał Mojżesza i Aarona i powiedział: Módlcie się do PANA, aby oddalił żaby ode mnie i od mojego ludu, a wypuszczę lud, aby złożył ofiarę PANU. ");
INSERT INTO polubg_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mojżesz odpowiedział faraonowi: Dam ci ten zaszczyt. Powiedz, kiedy mam się modlić za ciebie, za twoje sługi i za twój lud, aby wyginęły żaby u ciebie i w twoich domach, a zostały tylko te w rzece. ");
INSERT INTO polubg_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","A on powiedział: Jutro. Wtedy Mojżesz odpowiedział: Stanie się według twego słowa, abyś wiedział, że nie ma nikogo jak PAN, nasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Żaby odejdą od ciebie, z twoich domów, od twoich sług i twego ludu, zostaną tylko w rzece. ");
INSERT INTO polubg_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Wtedy Mojżesz i Aaron wyszli od faraona. I Mojżesz zawołał do PANA z powodu żab, które zesłał na faraona. ");
INSERT INTO polubg_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","I PAN uczynił według słowa Mojżesza, że żaby wyginęły z domów, ze wsi i z pól. ");
INSERT INTO polubg_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Zbierano je na stosy i ziemia zaczęła cuchnąć. ");
INSERT INTO polubg_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Gdy faraon zauważył, że nadeszło wytchnienie, zatwardził swoje serce i nie posłuchał ich, jak PAN zapowiedział. ");
INSERT INTO polubg_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","I PAN powiedział do Mojżesza: Powiedz Aaronowi: Wyciągnij swoją laskę i uderz pył ziemi, aby zamienił się we wszy na całej ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","I tak uczynili. Aaron wyciągnął rękę ze swoją laską i uderzył pył ziemi, który zamienił się we wszy na ludziach i na bydle. Wszelki pył ziemi zamienił się we wszy na całej ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Czarownicy czynili to samo swoimi czarami, aby sprowadzić wszy, ale nie mogli. I wszy były na ludziach i na bydle. ");
INSERT INTO polubg_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Wtedy czarownicy powiedzieli do faraona: To jest palec Boży. Ale serce faraona pozostało zatwardziałe i nie posłuchał ich, jak PAN zapowiedział. ");
INSERT INTO polubg_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","I PAN powiedział do Mojżesza: Wstań rano i stań przed faraonem, kiedy wyjdzie nad wodę, i powiedz mu: Tak mówi PAN: Wypuść mój lud, aby mi służył; ");
INSERT INTO polubg_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Bo jeśli nie wypuścisz mego ludu, ześlę rozmaite muchy na ciebie, na twe sługi, na twój lud i na twoje domy. I domy Egipcjan, a także ziemia, na której są, będą pełne rozmaitych much. ");
INSERT INTO polubg_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","W owym dniu oddzielę ziemię Goszen, w której mieszka mój lud, aby tam nie było rozmaitych much. I poznasz, że ja jestem PAN pośrodku ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Oddzielę znakiem odkupienia mój lud od twojego ludu. Jutro ten znak nastąpi. ");
INSERT INTO polubg_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","I PAN tak uczynił. Rozmaite uciążliwe muchy naszły dom faraona, domy jego sług i całą ziemię Egiptu. I ziemia została zniszczona przez rozmaite muchy. ");
INSERT INTO polubg_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Faraon wezwał wówczas Mojżesza i Aarona i powiedział: Idźcie, złóżcie na tej ziemi ofiarę waszemu Bogu. ");
INSERT INTO polubg_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mojżesz odpowiedział: Nie godzi się tak czynić; bo to, co złożylibyśmy w ofierze PANU, naszemu Bogu, byłoby zgorszeniem dla Egipcjan. A gdybyśmy na oczach Egipcjan złożyli w ofierze to, co jest zgorszeniem, czyż nie ukamienowaliby nas? ");
INSERT INTO polubg_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Pójdziemy w trzy dni drogi na pustynię i złożymy ofiarę PANU, naszemu Bogu, jak nam rozkaże. ");
INSERT INTO polubg_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Faraon odpowiedział: Wypuszczę was, abyście mogli złożyć ofiarę PANU, waszemu Bogu, na pustyni, tylko nie oddalajcie się zbytnio. Wstawcie się też za mną. ");
INSERT INTO polubg_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mojżesz powiedział: Wychodzę od ciebie i wstawię się za tobą u PANA, aby rozmaite muchy odeszły jutro od faraona, od jego sług i od jego ludu. Tylko niech faraon już więcej nie oszukuje, nie chcąc wypuścić ludu, by złożył ofiarę PANU. ");
INSERT INTO polubg_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mojżesz wyszedł więc od faraona i wstawił się u PANA. ");
INSERT INTO polubg_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","I PAN uczynił według słowa Mojżesza, i oddalił rozmaite muchy od faraona, od jego sług i od jego ludu. Nie została ani jedna. ");
INSERT INTO polubg_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Jednak faraon i tym razem zatwardził swe serce i nie wypuścił ludu. ");
INSERT INTO polubg_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Potem PAN powiedział do Mojżesza: Idź do faraona i powiedz mu: Tak mówi PAN, Bóg Hebrajczyków: Wypuść mój lud, aby mi służył; ");
INSERT INTO polubg_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Bo jeśli będziesz się wzbraniał go wypuścić i nadal będziesz go zatrzymywał; ");
INSERT INTO polubg_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Oto ręka PANA będzie na twoje stada, które są na polu, na koniach, na osłach, na wielbłądach, na wołach i na owcach. Będzie bardzo ciężka zaraza. ");
INSERT INTO polubg_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","PAN rozdzieli stada Izraela i stada Egiptu, aby nie zdechło nic ze wszystkiego, co należy do synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","I PAN wyznaczył czas, mówiąc: Jutro PAN to uczyni na tej ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Nazajutrz PAN tak uczynił. Pozdychały wszystkie stada Egiptu, lecz ze stad synów Izraela nie zdechło ani jedno. ");
INSERT INTO polubg_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faraon posłał więc na zwiady, a oto z bydła Izraela nie zdechło ani jedno. Ale serce faraona pozostało zatwardziałe i nie wypuścił ludu. ");
INSERT INTO polubg_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Potem PAN powiedział do Mojżesza i Aarona: Weźcie pełne garści popiołu z pieca i niech Mojżesz rozrzuci go ku niebu na oczach faraona. ");
INSERT INTO polubg_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Zamieni się w pył na całej ziemi Egiptu, który spowoduje wrzody pęczniejące ropą na ludziach i na zwierzętach na całej ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Wzięli więc popiół z pieca i stanęli przed faraonem, a Mojżesz rozrzucił popiół ku niebu i powstały wrzody pęczniejące ropą na ludziach i na zwierzętach. ");
INSERT INTO polubg_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Czarownicy zaś nie mogli stanąć przed Mojżeszem z powodu wrzodów, bo wrzody były na nich i na wszystkich Egipcjanach. ");
INSERT INTO polubg_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","I PAN zatwardził serce faraona, i ten nie posłuchał ich, jak PAN zapowiedział Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","PAN powiedział do Mojżesza: Wstań rano, stań przed faraonem i powiedz mu: Tak mówi PAN, Bóg Hebrajczyków: Wypuść mój lud, aby mi służył; ");
INSERT INTO polubg_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Tym razem bowiem ześlę wszystkie moje plagi na twoje serce, na twoje sługi i na twój lud, abyś wiedział, że nie ma równego mi na całej ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Bo teraz wyciągnę rękę i uderzę ciebie i twój lud zarazą, i będziesz wytracony z ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Lecz dlatego cię postawiłem, aby okazać na tobie moją moc i żeby rozgłaszano moje imię na całej ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","A ty jeszcze się wynosisz i stajesz przeciw memu ludowi, nie chcąc go wypuścić? ");
INSERT INTO polubg_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Jutro o tej porze spuszczę bardzo ciężki grad, jakiego nie było w Egipcie od dnia jego założenia aż do tego czasu. ");
INSERT INTO polubg_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Poślij więc teraz i zgromadź swoje bydło i wszystko, co masz na polu; bo każdy człowiek i każde zwierzę, które znajdzie się na polu, a nie zostanie zegnane do domu, zginie, gdy na nich spadnie grad. ");
INSERT INTO polubg_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kto więc ze sług faraona uląkł się słowa PANA, kazał uciekać swym sługom wraz z bydłem do domu; ");
INSERT INTO polubg_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ale kto nie wziął do serca słowa PANA, ten zostawił swe sługi i bydło na polu. ");
INSERT INTO polubg_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","PAN powiedział do Mojżesza: Wyciągnij rękę ku niebu, by spadł grad na całej ziemi Egiptu, na ludzi, na bydło i na wszelkie rośliny polne w ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","I Mojżesz wyciągnął swą laskę ku niebu, a PAN zesłał grzmoty i grad i na ziemię zstąpił ogień. PAN spuścił grad na ziemię Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","I był grad i ogień zmieszany z bardzo ciężkim gradem, jakiego nie było w całej ziemi Egiptu, odkąd stał się narodem. ");
INSERT INTO polubg_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Grad poraził na całej ziemi Egiptu cokolwiek było na polu, od człowieka aż do zwierzęcia. Poraził też wszelkie rośliny polne i połamał wszystkie drzewa na polu; ");
INSERT INTO polubg_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Tylko w ziemi Goszen, gdzie mieszkali synowie Izraela, nie było gradu. ");
INSERT INTO polubg_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Faraon kazał więc wezwać Mojżesza i Aarona i powiedział do nich: Tym razem zgrzeszyłem. PAN jest sprawiedliwy, a ja i mój lud jesteśmy niegodziwi. ");
INSERT INTO polubg_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Wstawcie się u PANA, aby ustały Boże grzmoty i grad, bo już dość. Wypuszczę was i nie będziecie tu dłużej mieszkać. ");
INSERT INTO polubg_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mojżesz powiedział do niego: Gdy wyjdę z miasta, wyciągnę ręce do PANA, a grzmoty ustaną i nie będzie więcej gradu, abyś wiedział, że ziemia należy do PANA. ");
INSERT INTO polubg_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ale wiem, że ty i twoi słudzy jeszcze nie boicie się PANA Boga. ");
INSERT INTO polubg_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Len i jęczmień zostały zbite, bo jęczmień miał już kłosy, a len zakwitł. ");
INSERT INTO polubg_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Pszenica jednak i żyto nie zostały zbite, bo były późniejsze. ");
INSERT INTO polubg_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mojżesz wyszedł więc od faraona za miasto i wyciągnął ręce do PANA. Ustały wtedy grzmoty i grad, a deszcz nie padał na ziemię. ");
INSERT INTO polubg_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kiedy faraon zobaczył, że deszcz, grad i grzmoty ustały, jeszcze bardziej zgrzeszył i zatwardził serce, on i jego słudzy. ");
INSERT INTO polubg_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","I serce faraona pozostało zatwardziałe i nie wypuścił synów Izraela, jak PAN zapowiedział przez Mojżesza. ");
INSERT INTO polubg_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Potem PAN powiedział do Mojżesza: Idź do faraona, bo zatwardziłem jego serce i serca jego sług, abym czynił te moje znaki wśród nich; ");
INSERT INTO polubg_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","I abyś opowiadał do uszu swoich synów i wnuków, co uczyniłem w Egipcie i o moich znakach, których wśród nich dokonałem, abyście wiedzieli, że ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mojżesz i Aaron poszli więc do faraona i mówili mu: Tak mówi PAN, Bóg Hebrajczyków: Jak długo będziesz się wzbraniał uniżyć przede mną? Wypuść mój lud, aby mi służył. ");
INSERT INTO polubg_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Bo jeśli będziesz się wzbraniał wypuścić mój lud, oto sprowadzę jutro szarańczę w twoje granice. ");
INSERT INTO polubg_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ona przykryje powierzchnię ziemi tak, że nie będzie jej widać, i pożre resztki, jakie wam zostały po gradzie, i strawi każde drzewo rosnące na polu. ");
INSERT INTO polubg_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Napełni twoje domy, domy wszystkich twoich sług i domy wszystkich Egipcjan, czego nie widzieli twoi ojcowie ani ojcowie twoich ojców od początku swego pobytu na ziemi aż do tego dnia. Potem odwrócił się i wyszedł od faraona. ");
INSERT INTO polubg_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Wtedy słudzy faraona powiedzieli do niego: Jak długo ten człowiek będzie dla nas sidłem? Wypuść tych ludzi, aby służyli PANU, swemu Bogu. Czy jeszcze nie wiesz, że Egipt został zniszczony? ");
INSERT INTO polubg_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Wezwano więc ponownie Mojżesza z Aaronem do faraona, a on powiedział do nich: Idźcie, służcie PANU, waszemu Bogu. Którzy to mają iść? ");
INSERT INTO polubg_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mojżesz odpowiedział: Pójdziemy z naszymi dziećmi i starcami, z naszymi synami i córkami, z naszymi trzodami i bydłem, bo musimy obchodzić święto dla PANA. ");
INSERT INTO polubg_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Powiedział im: Niech PAN tak będzie z wami, jak ja wypuszczę was i wasze dzieci. Patrzcie, bo coś złego macie przed sobą. ");
INSERT INTO polubg_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nie tak! Idźcie sami mężczyźni i służcie PANU, tego właśnie chcieliście. I wypędzono ich sprzed oblicza faraona. ");
INSERT INTO polubg_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Potem PAN powiedział do Mojżesza: Wyciągnij rękę nad ziemię Egiptu po szarańczę, aby spadła na ziemię Egiptu i pożarła wszelkie rośliny ziemi, wszystko to, co pozostało po gradzie. ");
INSERT INTO polubg_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","I Mojżesz wyciągnął swoją laskę nad ziemię Egiptu, a PAN sprowadził na ziemię wschodni wiatr na cały ten dzień i całą noc. Gdy nadszedł ranek, wschodni wiatr przyniósł szarańczę. ");
INSERT INTO polubg_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Szarańcza pojawiła się na całej ziemi Egiptu i obsiadła wszystkie granice Egiptu. Była ona tak uciążliwa, że podobnej szarańczy nigdy przedtem nie było i po niej takiej nie będzie. ");
INSERT INTO polubg_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Pokryła powierzchnię całej ziemi, tak że ziemia pociemniała. Pożarła całą roślinność ziemi i wszelkie owoce drzew, które zostały po gradzie. Nie pozostało nic zielonego na drzewach ani z roślinności polnej w całej ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Dlatego faraon czym prędzej wezwał Mojżesza i Aarona i powiedział: Zgrzeszyłem przeciwko PANU, waszemu Bogu, i przeciwko wam. ");
INSERT INTO polubg_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Teraz więc wybaczcie, proszę, mój grzech jeszcze ten raz i wstawcie się u PANA, waszego Boga, aby tylko oddalił ode mnie tę śmierć. ");
INSERT INTO polubg_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","I Mojżesz wyszedł od faraona i wstawił się u PANA. ");
INSERT INTO polubg_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","A PAN odwrócił bardzo silny wiatr zachodni, który porwał szarańczę i wrzucił ją do Morza Czerwonego. Nie została ani jedna szarańcza we wszystkich granicach Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","PAN jednak zatwardził serce faraona i ten nie wypuścił synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Wtedy PAN powiedział do Mojżesza: Wyciągnij rękę ku niebu, a nastanie na ziemi Egiptu taka ciemność, że będzie można jej dotknąć. ");
INSERT INTO polubg_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","I Mojżesz wyciągnął rękę ku niebu, i nastała gęsta ciemność w całej ziemi Egiptu, która trwała trzy dni. ");
INSERT INTO polubg_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Jeden nie widział drugiego i nikt przez te trzy dni nie podniósł się ze swego miejsca. Lecz w domach wszystkich synów Izraela było światło. ");
INSERT INTO polubg_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","A faraon wezwał Mojżesza i powiedział: Idźcie, służcie PANU. Tylko niech wasze trzody i bydła zostaną i niech idą z wami wasze dzieci. ");
INSERT INTO polubg_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","I Mojżesz odpowiedział: Dasz nam także ofiary i całopalenia, które złożymy w ofierze PANU, naszemu Bogu. ");
INSERT INTO polubg_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Pójdzie więc też z nami nasz dobytek, nie zostanie nawet kopyto. Z niego bowiem weźmiemy, aby służyć PANU, naszemu Bogu, gdyż nie wiemy, czym mamy służyć PANU, dopóki tam nie przyjdziemy. ");
INSERT INTO polubg_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Lecz PAN zatwardził serce faraona i ten nie chciał ich wypuścić. ");
INSERT INTO polubg_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Faraon powiedział do Mojżesza: Idź ode mnie i strzeż się, abyś więcej nie widział mego oblicza. Tego dnia bowiem, w którym zobaczysz moje oblicze, umrzesz. ");
INSERT INTO polubg_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mojżesz odpowiedział: Dobrze powiedziałeś. Nie zobaczę więcej twego oblicza. ");
INSERT INTO polubg_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","I PAN powiedział do Mojżesza: Sprowadzę jeszcze jedną plagę na faraona i na Egipt, potem wypuści was stąd. A gdy was wypuści, całkowicie was stąd wypędzi. ");
INSERT INTO polubg_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Powiedz teraz do uszu ludu, aby każdy mężczyzna pożyczył od swego sąsiada i każda kobieta od swej sąsiadki srebrne i złote przedmioty. ");
INSERT INTO polubg_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","A PAN dał ludowi łaskę w oczach Egipcjan. Mojżesz także był bardzo wielkim mężem w ziemi Egiptu w oczach sług faraona i w oczach ludu. ");
INSERT INTO polubg_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Wtedy Mojżesz powiedział: Tak mówi PAN: O północy przejdę przez Egipt. ");
INSERT INTO polubg_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","I umrze wszystko, co pierworodne w ziemi Egiptu, od pierworodnego syna faraona, który miał zasiadać na jego tronie, aż do pierworodnego niewolnicy, która jest przy żarnach, i wszelkie pierworodne bydła. ");
INSERT INTO polubg_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","I będzie wielki krzyk w całej ziemi Egiptu, jakiego nigdy przedtem nie było i jakiego potem nie będzie. ");
INSERT INTO polubg_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ale na nikogo z synów Izraela pies nie ruszy swym językiem, ani na człowieka, ani na bydlę, abyście wiedzieli, że PAN uczynił różnicę między Egipcjanami a Izraelem. ");
INSERT INTO polubg_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","I przyjdą do mnie wszyscy twoi słudzy, i będą mi się kłaniać, mówiąc: Wyjdź ty i cały lud, który jest pod twoim przywództwem. Potem wyjdę. I wyszedł od faraona z wielkim gniewem. ");
INSERT INTO polubg_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","PAN powiedział do Mojżesza: Faraon nie posłucha was, aby mnożyły się moje cuda w ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mojżesz i Aaron czynili więc te wszystkie cuda przed faraonem. Lecz PAN zatwardził serce faraona i ten nie wypuścił synów Izraela ze swojej ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","PAN powiedział jeszcze do Mojżesza i Aarona w ziemi Egiptu: ");
INSERT INTO polubg_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Ten miesiąc będzie dla was początkiem miesięcy, będzie dla was pierwszym miesiącem roku. ");
INSERT INTO polubg_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Powiedzcie całemu zgromadzeniu Izraela: Dziesiątego dnia tego miesiąca każdy weźmie sobie baranka dla rodziny, jednego baranka dla domu. ");
INSERT INTO polubg_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","A jeśli rodzina jest zbyt mała, aby zjeść baranka, niech dobierze go razem z sąsiadem, który jest najbliższy jej domu, według liczby dusz, naliczywszy tyle osób, ile mogłoby zjeść baranka. ");
INSERT INTO polubg_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Wasz baranek ma być bez skazy, jednoroczny samiec. Weźmiecie go spośród owiec albo kóz. ");
INSERT INTO polubg_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Będziecie go strzegli aż do czternastego dnia tego miesiąca, a wtedy całe zgromadzenie Izraela zabije go pod wieczór. ");
INSERT INTO polubg_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Potem wezmą z jego krwi i pokropią oba węgary i nadproże domu, w którym będą go spożywać. ");
INSERT INTO polubg_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","I będą jeść tej nocy mięso pieczone przy ogniu i przaśny chleb; będą je jeść z gorzkimi ziołami. ");
INSERT INTO polubg_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Nie jedzcie z niego nic surowego ani ugotowanego w wodzie, lecz tylko upieczone przy ogniu, z jego głową, nogami i wnętrznościami. ");
INSERT INTO polubg_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Nie zostawicie z niego niczego do rana; a jeśliby coś z niego zostało do rana, spalicie to w ogniu. ");
INSERT INTO polubg_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Tak oto będziecie go spożywać: Wasze biodra będą przepasane, obuwie na waszych nogach i laska w waszym ręku. Będziecie go jeść pośpiesznie. To Pascha PANA. ");
INSERT INTO polubg_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Gdyż tej nocy przejdę przez ziemię Egiptu i zabiję wszystko, co pierworodne w ziemi Egiptu, od człowieka aż do zwierzęcia, a nad wszystkimi bogami Egiptu dokonam sądu, ja, PAN. ");
INSERT INTO polubg_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","A ta krew będzie dla was znakiem na domach, w których będziecie. Gdy bowiem ujrzę krew, ominę was i nie dotknie was plaga zniszczenia, gdy będę zabijał w ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ten dzień będzie dla was pamiątką i będziecie go obchodzić jako święto dla PANA po wszystkie pokolenia. Będziecie go obchodzić jako ustawę wieczną. ");
INSERT INTO polubg_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Przez siedem dni będziecie jeść przaśny chleb. Już w pierwszym dniu usuniecie zakwas z waszych domów, bo ktokolwiek będzie jadł coś kwaszonego, od pierwszego dnia aż do siódmego, ta dusza zostanie wykluczona z Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","W tym pierwszym dniu będzie święte zgromadzenie, także siódmego dnia będziecie mieć święte zgromadzenie. W tych dniach nie będziecie wykonywać żadnej pracy. Będzie wam tylko wolno przygotować to, czego każdy potrzebuje do jedzenia. ");
INSERT INTO polubg_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","I będziecie obchodzić Święto Przaśników, bo w tym właśnie dniu wyprowadziłem wasze zastępy z ziemi Egiptu. Dlatego będziecie obchodzić ten dzień po wszystkie pokolenia jako ustawę wieczną. ");
INSERT INTO polubg_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","W pierwszym miesiącu, od wieczora czternastego dnia tego miesiąca do wieczora dnia dwudziestego pierwszego tego miesiąca, będziecie jeść przaśny chleb. ");
INSERT INTO polubg_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Przez siedem dni nie znajdzie się żaden zakwas w waszych domach. Ktokolwiek bowiem będzie jadł coś kwaszonego, ta dusza zostanie wykluczona ze zgromadzenia Izraela, zarówno przybysz, jak i urodzony w tej ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Nie będziecie jeść nic kwaszonego; we wszystkich waszych domach będziecie jeść przaśne chleby. ");
INSERT INTO polubg_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Wtedy Mojżesz wezwał wszystkich starszych Izraela i powiedział im: Wybierzcie i weźcie sobie baranka dla swych rodzin i zabijcie go jako paschę. ");
INSERT INTO polubg_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Weźmiecie też wiązkę hizopu i zanurzycie we krwi, która jest w misie, i pokropicie nadproże i oba węgary tą krwią, która jest w misie. Niech nikt z was nie wychodzi za drzwi swego domu aż do rana. ");
INSERT INTO polubg_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","PAN bowiem przejdzie, aby zabijać Egipcjan, a gdy ujrzy krew na nadprożu i na obu węgarach, PAN ominie drzwi i nie pozwoli niszczycielowi wejść do waszych domów, aby was zabić. ");
INSERT INTO polubg_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Będziecie przestrzegać tego jako ustawy dla ciebie i twoich synów aż na wieki. ");
INSERT INTO polubg_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Kiedy wejdziecie do ziemi, którą da wam PAN, jak to obiecał, będziecie przestrzegać tego obrzędu. ");
INSERT INTO polubg_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","A gdy wasi synowie zapytają was: Co oznacza ten wasz obrzęd? ");
INSERT INTO polubg_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Wtedy odpowiecie: To ofiara paschy PANA, który ominął domy synów Izraela w Egipcie, gdy zabijał Egipcjan, a nasze domy ocalił. Potem lud schylił się i oddał pokłon. ");
INSERT INTO polubg_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","I synowie Izraela odeszli, i uczynili, jak PAN rozkazał Mojżeszowi i Aaronowi, tak właśnie zrobili. ");
INSERT INTO polubg_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","A o północy PAN zabił wszystko, co pierworodne w ziemi Egiptu, od pierworodnego syna faraona, zasiadającego na jego tronie, aż do pierworodnego więźnia, który był w więzieniu, oraz wszystko, co pierworodne z bydła. ");
INSERT INTO polubg_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Wstał tej nocy faraon, a z nim wszyscy jego słudzy oraz wszyscy Egipcjanie; i podniósł się w Egipcie wielki krzyk, bo nie było domu, w którym nie byłoby umarłego. ");
INSERT INTO polubg_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Faraon wezwał Mojżesza i Aarona w nocy i powiedział: Wstańcie, wyjdźcie spośród mego ludu, wy i synowie Izraela. Idźcie i służcie PANU, jak mówiliście. ");
INSERT INTO polubg_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Zabierzcie też swoje trzody i bydła, jak żądaliście, i idźcie. Mnie też błogosławcie. ");
INSERT INTO polubg_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","I Egipcjanie przynaglali lud, aby ich jak najszybciej wyprawić z ziemi, bo mówili: Wszyscy pomrzemy. ");
INSERT INTO polubg_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Wziął więc lud swoje ciasto, zanim się zakwasiło, i dzieże owinięte w swoje szaty i kładli je na swoje ramiona. ");
INSERT INTO polubg_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Synowie Izraela postąpili według nakazu Mojżesza i pożyczyli od Egipcjan srebrne i złote przedmioty oraz szaty. ");
INSERT INTO polubg_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","A PAN dał ludowi łaskę w oczach Egipcjan, tak że im pożyczyli. I złupili Egipcjan. ");
INSERT INTO polubg_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Wyruszyli więc synowie Izraela z Ramzes do Sukkot, około sześciuset tysięcy pieszych mężczyzn, nie licząc dzieci. ");
INSERT INTO polubg_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ale szło z nimi też mnóstwo obcego ludu oraz owce i bydło, bardzo liczny dobytek. ");
INSERT INTO polubg_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","I popiekli przaśne placki z ciasta, które wynieśli z Egiptu, bo nie było zakwaszone. Ponieważ zostali wygnani z Egiptu, nie mogli zwlekać i nie przygotowali sobie też żadnej żywności. ");
INSERT INTO polubg_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","A czas przebywania synów Izraela, którzy mieszkali w Egipcie, wynosił czterysta trzydzieści lat. ");
INSERT INTO polubg_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","I stało się tak, że po upływie czterystu trzydziestu lat, tego samego dnia, wszystkie zastępy PANA wyszły z ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ta noc ma być obchodzona dla PANA, dlatego że wyprowadził ich z ziemi Egiptu. Ta noc ma być więc obchodzona dla PANA przez wszystkich synów Izraela po wszystkie ich pokolenia. ");
INSERT INTO polubg_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","I PAN powiedział do Mojżesza i Aarona: Taka jest ustawa Paschy: Żaden obcy nie będzie z niej spożywał. ");
INSERT INTO polubg_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Każdy jednak wasz sługa nabyty za pieniądze będzie mógł z niej spożywać, jeśli tylko go obrzezacie. ");
INSERT INTO polubg_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Cudzoziemiec i najemnik nie będą z niej spożywać. ");
INSERT INTO polubg_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","W jednym domu będzie spożywany baranek. Nie wyniesiesz z domu nic z jego mięsa i nie złamiecie jego kości. ");
INSERT INTO polubg_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Całe zgromadzenie Izraela tak z nim postąpi. ");
INSERT INTO polubg_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","A jeśli jakiś cudzoziemiec będzie twoim gościem i będzie chciał obchodzić Paschę dla PANA, niech najpierw zostanie obrzezany każdy mężczyzna jego domu, a potem niech przystąpi i obchodzi ją. Wtedy będzie jak urodzony w tej ziemi. A ktokolwiek nie jest obrzezany, nie będzie z niej spożywał. ");
INSERT INTO polubg_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Jedno prawo będzie dla urodzonego w ziemi i dla cudzoziemca, który jest gościem wśród was. ");
INSERT INTO polubg_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Wszyscy synowie Izraela uczynili więc, jak PAN rozkazał Mojżeszowi i Aaronowi, tak właśnie uczynili. ");
INSERT INTO polubg_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Tego samego dnia PAN wyprowadził synów Izraela z ziemi Egiptu według ich zastępów. ");
INSERT INTO polubg_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Poświęć mi wszystko, co pierworodne. Wszystko, co otwiera łono u synów Izraela, tak wśród ludzi, jak i wśród bydła. To należy do mnie. ");
INSERT INTO polubg_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mojżesz powiedział więc do ludu: Pamiętajcie ten dzień, w którym wyszliście z Egiptu, z domu niewoli. PAN bowiem potężną ręką wyprowadził was stamtąd. Nie będziecie jeść nic kwaszonego. ");
INSERT INTO polubg_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Dziś wychodzicie, w miesiącu Abib. ");
INSERT INTO polubg_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","A gdy PAN wprowadzi cię do ziemi Kananejczyków, Chetytów, Amorytów, Chiwwitów i Jebusytów, którą przysiągł dać waszym ojcom, ziemię opływającą mlekiem i miodem, wtedy będziesz obchodził ten obrzęd w tym samym miesiącu. ");
INSERT INTO polubg_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Przez siedem dni będziesz jeść przaśny chleb, a siódmego dnia będzie święto dla PANA. ");
INSERT INTO polubg_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Będziesz jadł przaśny chleb przez siedem dni i nie może znaleźć się u ciebie nic kwaszonego ani żaden zakwas nie może być widziany we wszystkich twoich granicach. ");
INSERT INTO polubg_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","W tym dniu opowiesz swemu synowi: Obchodzę to ze względu na to, co PAN dla mnie uczynił, gdy wychodziłem z Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","To będzie jako znak na twojej ręce i jako pamiątka przed twoimi oczyma, aby prawo PANA było na twoich ustach. PAN bowiem potężną ręką wyprowadził cię z Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Będziesz przestrzegał tej ustawy w wyznaczonym czasie, z roku na rok. ");
INSERT INTO polubg_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","A gdy PAN wprowadzi cię do ziemi Kanaan, jak przysiągł tobie i twoim ojcom, i da ją tobie; ");
INSERT INTO polubg_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Wtedy przeznaczysz dla PANA wszystko, co otwiera łono, i każdy płód otwierający łono z twojego bydła, każdy samiec będzie dla PANA. ");
INSERT INTO polubg_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Każde zaś pierworodne oślę wykupisz barankiem, a jeśli nie wykupisz, złamiesz mu kark. Wykupisz też każdego pierworodnego człowieka wśród twoich synów. ");
INSERT INTO polubg_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","A gdy w przyszłości twój syn cię zapyta: Cóż to jest? Wtedy odpowiesz mu: PAN wyprowadził nas potężną ręką z Egiptu, z domu niewoli. ");
INSERT INTO polubg_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Gdy bowiem faraon stał się twardy i wzbraniał się nas wypuścić, wtedy PAN zabił wszystko, co pierworodne w ziemi Egiptu, od pierworodnego z ludzi aż do pierworodnego z bydła. Dlatego składam w ofierze PANU wszystkie samce otwierające łono, ale każdego pierworodnego z moich synów wykupuję. ");
INSERT INTO polubg_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","To będzie jako znak na twojej ręce i jako przepaska ozdobna między twoimi oczyma, że PAN potężną ręką wyprowadził nas z Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","A stało się tak, że gdy faraon wypuścił lud, Bóg nie prowadził go drogą przez ziemię Filistynów, chociaż była bliższa. Bóg bowiem powiedział: Żeby lud na widok wojny nie żałował i nie wrócił do Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ale Bóg prowadził lud okrężną drogą przez pustynię nad Morzem Czerwonym. I synowie Izraela wyszli z ziemi Egiptu w bojowym szyku. ");
INSERT INTO polubg_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mojżesz wziął też ze sobą kości Józefa, gdyż ten zobowiązał synów Izraela przysięgą, mówiąc: Na pewno Bóg was nawiedzi. Zabierzcie więc stąd ze sobą moje kości. ");
INSERT INTO polubg_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Wyruszyli z Sukkot i rozbili obóz w Etam, na skraju pustyni. ");
INSERT INTO polubg_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","A PAN szedł przed nimi za dnia w słupie obłoku, by prowadzić ich drogą, a nocą w słupie ognia, by im świecić, żeby mogli iść dniem i nocą. ");
INSERT INTO polubg_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Nie oddalał od ludu ani słupa obłoku za dnia, ani słupa ognia nocą. ");
INSERT INTO polubg_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Powiedz synom Izraela, aby zawrócili i rozbili obóz przed Pi-Hachirot, pomiędzy Migdol a morzem, naprzeciw Baal-Sefon. Rozbijcie obóz naprzeciw niego nad morzem. ");
INSERT INTO polubg_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Faraon bowiem powie o synach Izraela: Pobłądzili w ziemi, pustynia ich zamknęła. ");
INSERT INTO polubg_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","I zatwardzę serce faraona, tak że będzie ich ścigać. I będę wysławiony dzięki faraonowi i dzięki całemu jego wojsku, a Egipcjanie poznają, że ja jestem PAN. I tak uczynili. ");
INSERT INTO polubg_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Gdy doniesiono królowi Egiptu, że lud ucieka, odmieniło się serce faraona i jego sług przeciw ludowi i powiedzieli: Co zrobiliśmy, że zwolniliśmy Izraela od służenia nam? ");
INSERT INTO polubg_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Zaprzągł więc swój rydwan i wziął ze sobą swoich ludzi. ");
INSERT INTO polubg_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Wziął też sześćset wyborowych rydwanów i wszystkie rydwany Egiptu oraz przełożonych nad każdym z nich. ");
INSERT INTO polubg_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","I PAN zatwardził serce faraona, króla Egiptu, który ścigał synów Izraela, synowie Izraela wyszli jednak pod potężną ręką. ");
INSERT INTO polubg_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","I Egipcjanie ścigali ich: wszystkie konie i rydwany faraona, jego jeźdźcy i wojska, i dogonili ich w obozie nad morzem, niedaleko Pi-Hachirot, naprzeciw Baal-Sefon. ");
INSERT INTO polubg_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","A gdy faraon zbliżył się, synowie Izraela podnieśli swe oczy i spostrzegli, że oto Egipcjanie ciągną za nimi, i bardzo się przerazili. Wtedy synowie Izraela wołali do PANA. ");
INSERT INTO polubg_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","I mówili do Mojżesza: Czy dlatego, że nie było grobów w Egipcie, wyprowadziłeś nas, abyśmy pomarli na pustyni? Dlaczego nam to uczyniłeś, że nas wyprowadziłeś z Egiptu? ");
INSERT INTO polubg_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Czyż nie mówiliśmy ci tego w Egipcie: Zostaw nas w spokoju, abyśmy służyli Egipcjanom? Bo lepiej nam było służyć Egipcjanom, niż umierać na pustyni. ");
INSERT INTO polubg_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mojżesz odpowiedział ludowi: Nie bójcie się, stójcie i patrzcie na wybawienie PANA, które wam dziś okaże. Egipcjan bowiem, których teraz widzicie, nie zobaczycie nigdy więcej. ");
INSERT INTO polubg_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","PAN będzie za was walczył, a wy będziecie milczeć. ");
INSERT INTO polubg_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","I PAN powiedział do Mojżesza: Dlaczego wołasz do mnie? Powiedz synom Izraela, aby ruszyli; ");
INSERT INTO polubg_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ty zaś podnieś swą laskę, wyciągnij rękę nad morze i rozdziel je. A synowie Izraela niech idą środkiem morza po suchej ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","A oto ja, ja zatwardzę serca Egipcjan, że wejdą za nimi. I będę wysławiony dzięki faraonowi i całemu jego wojsku, jego rydwanom i jeźdźcom. ");
INSERT INTO polubg_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","I Egipcjanie poznają, że ja jestem PAN, gdy będę wysławiony dzięki faraonowi, jego rydwanom i jeźdźcom. ");
INSERT INTO polubg_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Wówczas Anioł Boga, który szedł przed obozem Izraela, przeszedł na jego tyły. Słup obłoku również odszedł sprzed niego i stanął za nim. ");
INSERT INTO polubg_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Wszedł więc między obóz Egipcjan i obóz Izraela. Ten był dla Egipcjan obłokiem ciemności, ale Izraelitom oświetlał noc. W ten sposób jedni do drugich nie zbliżyli się przez całą noc. ");
INSERT INTO polubg_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Wtedy Mojżesz wyciągnął rękę nad morze, a PAN rozpędził morze silnym wiatrem wschodnim, który wiał przez całą noc, i osuszył morze, a wody się rozstąpiły. ");
INSERT INTO polubg_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","I synowie Izraela szli środkiem morza po suchej ziemi. Wody były dla nich murem, po ich prawej i lewej stronie. ");
INSERT INTO polubg_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Egipcjanie zaś ścigali ich i weszli za nimi, wszystkie konie faraona, jego rydwany i jeźdźcy, w sam środek morza. ");
INSERT INTO polubg_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","O straży porannej PAN spojrzał na obóz Egipcjan ze słupa ognia i obłoku i pomieszał wojsko Egipcjan. ");
INSERT INTO polubg_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","I odrywał koła ich rydwanów, tak że z trudem je wlekli. Egipcjanie powiedzieli więc: Uciekajmy przed Izraelem, gdyż PAN walczy za niego przeciw Egipcjanom. ");
INSERT INTO polubg_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","PAN powiedział do Mojżesza: Wyciągnij rękę nad morze, aby wody wróciły na Egipcjan, na ich rydwany i na ich jeźdźców. ");
INSERT INTO polubg_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mojżesz wyciągnął więc rękę nad morze, a ono o poranku powróciło do swojej mocy, Egipcjanie zaś uciekali mu naprzeciw. Tak PAN pogrążył Egipcjan w środku morza. ");
INSERT INTO polubg_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Wtedy wody wróciły i okryły rydwany i jeźdźców, i całe wojsko faraona, które weszło za nimi w morze. Nie pozostał ani jeden z nich. ");
INSERT INTO polubg_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Lecz synowie Izraela szli po suchej ziemi środkiem morza, a wody były dla nich murem, po ich prawej i lewej stronie. ");
INSERT INTO polubg_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Tak PAN w tym dniu wybawił Izraela z ręki Egipcjan. I Izraelici widzieli martwych Egipcjan na brzegu morza. ");
INSERT INTO polubg_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Izrael widział to wielkie dzieło, którego PAN dokonał nad Egipcjanami. I lud się bał PANA, i uwierzył PANU oraz Mojżeszowi, jego słudze. ");
INSERT INTO polubg_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Wówczas Mojżesz i synowie Izraela zaśpiewali PANU tę pieśń: Będę śpiewał PANU, bo bardzo się wywyższył. Konia i jego jeźdźca wrzucił w morze. ");
INSERT INTO polubg_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","PAN moją mocą i moją chwałą, bo stał się dla mnie zbawieniem. To mój Bóg, dlatego zbuduję mu przybytek, to Bóg mego ojca, dlatego będę go wywyższał. ");
INSERT INTO polubg_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","PAN jest wojownikiem, PAN to jego imię. ");
INSERT INTO polubg_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Rydwany faraona i jego wojsko wrzucił w morze, a jego wyborni wodzowie zostali potopieni w Morzu Czerwonym. ");
INSERT INTO polubg_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Okryły ich głębiny, poszli w głębię jak kamień. ");
INSERT INTO polubg_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Twoja prawica, PANIE, jest uwielbiona w mocy. Twoja prawica, PANIE, starła nieprzyjaciela. ");
INSERT INTO polubg_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","A w wielkości twego majestatu powaliłeś swoich przeciwników. Zesłałeś swój gniew, który pożarł ich jak słomę. ");
INSERT INTO polubg_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Pod tchnieniem twoich nozdrzy zebrały się wody, cieknące wody stanęły jak wał i głębiny osiadły pośrodku morza. ");
INSERT INTO polubg_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Nieprzyjaciel mówił: Będę ścigał, dogonię, będę dzielił łupy; nasyci się nimi moja dusza, dobędę swój miecz, zgładzi ich moja ręka. ");
INSERT INTO polubg_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Powiałeś swoim wiatrem, okryło ich morze. Zatonęli jak ołów w potężnych wodach. ");
INSERT INTO polubg_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Któż jest podobny do ciebie wśród bogów, PANIE? Któż jest jak ty, wspaniały w świętości, straszliwy w chwale, czyniący cuda? ");
INSERT INTO polubg_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Wyciągnąłeś swoją prawicę, pochłonęła ich ziemia. ");
INSERT INTO polubg_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Wiedziesz w swoim miłosierdziu ten lud, który odkupiłeś. Prowadzisz w swej potędze do swego świętego przybytku. ");
INSERT INTO polubg_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Usłyszą o tym narody i zadrżą. Smutek przejmie obywateli Filistei. ");
INSERT INTO polubg_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Wtedy zlękną się książęta Edomu, mocarzy Moabu ogarnie strach; struchleją wszyscy obywatele Kanaanu. ");
INSERT INTO polubg_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Padnie na nich strach i lęk; z powodu potęgi twego ramienia zamilkną jak kamień, aż przejdzie twój lud, PANIE, aż przejdzie lud, który sobie nabyłeś. ");
INSERT INTO polubg_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Wprowadzisz go i zasadzisz na górze twego dziedzictwa, na miejscu, PANIE, które uczyniłeś swoim mieszkaniem, w świątyni, Panie, którą umocniły twoje ręce. ");
INSERT INTO polubg_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","PAN będzie królował na wieki wieków. ");
INSERT INTO polubg_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Weszły bowiem konie faraona z jego rydwanami i z jego jeźdźcami w morze, a PAN skierował na nich wody morskie; synowie Izraela zaś szli po suchej ziemi środkiem morza. ");
INSERT INTO polubg_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Wtedy prorokini Miriam, siostra Aarona, wzięła bęben w rękę, a wszystkie kobiety wyszły za nią z bębnami i w pląsach. ");
INSERT INTO polubg_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","I Miriam powiedziała do nich: Śpiewajcie PANU, bo jest bardzo wywyższony; konia i jego jeźdźca wrzucił do morza. ");
INSERT INTO polubg_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Potem Mojżesz poprowadził Izraela znad Morza Czerwonego i wyszli na pustynię Szur. Szli trzy dni przez pustynię i nie znaleźli wody. ");
INSERT INTO polubg_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","A gdy przybyli do Mary, nie mogli pić z wód Mary, bo były gorzkie. Dlatego nazwano to miejsce Mara. ");
INSERT INTO polubg_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Wtedy lud szemrał przeciw Mojżeszowi, mówiąc: Cóż będziemy pić? ");
INSERT INTO polubg_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","I Mojżesz wołał do PANA, a PAN wskazał mu drzewo, które on wrzucił do wody, a woda stała się słodka. Tam ustanowił dla nich ustawę i prawo i tam ich wystawił na próbę; ");
INSERT INTO polubg_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","I powiedział: Jeśli będziesz pilnie słuchał głosu PANA, twego Boga, i będziesz robił to, co prawe w jego oczach, i nakłonisz uszy ku jego przykazaniom, i będziesz przestrzegał wszystkich jego ustaw, to nie ześlę na ciebie żadnej choroby, jaką zesłałem na Egipt, gdyż ja jestem PAN, który cię uzdrawia. ");
INSERT INTO polubg_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","I przybyli do Elim, gdzie było dwanaście źródeł wody i siedemdziesiąt palm; tam rozbili obóz nad wodami. ");
INSERT INTO polubg_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Potem wyruszyli z Elim i całe zgromadzenie synów Izraela przybyło na pustynię Sin, która leży między Elim a Synajem, piętnastego dnia drugiego miesiąca po ich wyjściu z ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","I całe zgromadzenie synów Izraela szemrało przeciw Mojżeszowi i Aaronowi na pustyni. ");
INSERT INTO polubg_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Synowie Izraela mówili do nich: Obyśmy pomarli z ręki PANA w ziemi Egiptu, gdy siadaliśmy nad garncami mięsa, gdy najadaliśmy się chleba do syta! Bo wyprowadziliście nas na tę pustynię, by całą tę rzeszę zamorzyć głodem. ");
INSERT INTO polubg_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Wtedy PAN powiedział do Mojżesza: Oto spuszczę wam jak deszcz chleb z nieba. Lud będzie wychodził i każdego dnia będzie zbierał według potrzeby dziennej, abym mógł go wystawić na próbę, czy będzie postępował zgodnie z moim prawem, czy nie. ");
INSERT INTO polubg_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","A szóstego dnia przyrządzą to, co przyniosą, a będzie tego dwa razy tyle, co zbierają codziennie. ");
INSERT INTO polubg_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mojżesz i Aaron mówili do wszystkich synów Izraela: Wieczorem poznacie, że PAN wyprowadził was z ziemi Egiptu; ");
INSERT INTO polubg_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","A rano ujrzycie chwałę PANA, usłyszał bowiem wasze szemrania przeciw PANU. A my, czym jesteśmy, że szemrzecie przeciwko nam? ");
INSERT INTO polubg_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mojżesz mówił dalej: PAN da wam wieczorem mięso do jedzenia, a rano chleb do syta. PAN bowiem usłyszał wasze szemrania, które podnosicie przeciw niemu. A my, czym jesteśmy? Wasze szemrania nie są przeciwko nam, ale przeciwko PANU. ");
INSERT INTO polubg_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mojżesz powiedział do Aarona: Powiedz całemu zgromadzeniu synów Izraela: Zbliżcie się przed oblicze PANA, gdyż usłyszał wasze szemranie. ");
INSERT INTO polubg_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Gdy Aaron mówił do całego zgromadzenia synów Izraela, spojrzeli w stronę pustyni, a oto chwała PANA ukazała się w obłoku. ");
INSERT INTO polubg_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Usłyszałem szemranie synów Izraela. Powiedz do nich: Pod wieczór będziecie jeść mięso, a rano będziecie nasyceni chlebem. I poznacie, że ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Wieczorem stało się tak, że zleciały się przepiórki i pokryły obóz, a rano dokoła obozu leżała rosa; ");
INSERT INTO polubg_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","A gdy warstwa rosy się uniosła, ukazało się na powierzchni pustyni coś bardzo małego, okrągłego, drobnego jak szron na ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Gdy synowie Izraela to zobaczyli, mówili jeden do drugiego: To manna, gdyż nie wiedzieli, co to było. I Mojżesz powiedział do nich: To jest chleb, który PAN dał wam do jedzenia. ");
INSERT INTO polubg_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Oto co PAN rozkazał: Niech każdy zbiera z niego tyle, ile trzeba do jedzenia, omer na osobę, według liczby osób. Niech każdy zbiera dla tych, którzy są w jego namiocie. ");
INSERT INTO polubg_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","I synowie Izraela tak uczynili, i zbierali jedni więcej, drudzy mniej. ");
INSERT INTO polubg_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","A gdy to mierzyli omerem, to ten, kto nazbierał więcej, nie miał nadmiaru, temu zaś, kto nazbierał mało, nie zabrakło. Każdy zbierał według tego, co mógł zjeść. ");
INSERT INTO polubg_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mojżesz mówił też do nich: Niech nikt nie pozostawia z tego nic do rana. ");
INSERT INTO polubg_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Jednak nie usłuchali Mojżesza i zostawili niektórzy z tego aż do rana, i zamieniło się w robaki, i cuchnęło. I Mojżesz rozgniewał się na nich. ");
INSERT INTO polubg_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Zbierali to więc każdego ranka, każdy według tego, co mógł zjeść. A gdy słońce zaczynało grzać, topniało. ");
INSERT INTO polubg_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","A gdy nastał szósty dzień, zbierali dwa razy więcej chleba, po dwa omery na każdego. I wszyscy przełożeni zgromadzenia przyszli i powiedzieli o tym Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","On zaś powiedział im: Oto co PAN mówił: Jutro będzie odpoczynek, święty szabat dla PANA. Upieczcie, co macie upiec, ugotujcie, co macie ugotować, a co zostanie, zostawcie sobie i zachowajcie do jutra. ");
INSERT INTO polubg_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Zostawili więc to do rana, jak Mojżesz rozkazał, i nie cuchnęło ani nie było w tym robaków. ");
INSERT INTO polubg_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","I Mojżesz powiedział: Jedzcie to dziś, bo dziś jest szabat dla PANA. Dziś nie znajdziecie tego na polu. ");
INSERT INTO polubg_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Przez sześć dni będziecie to zbierać, a w siódmym dniu jest szabat, w nim tego nie będzie. ");
INSERT INTO polubg_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","A siódmego dnia niektórzy z ludu wyszli, aby zbierać, ale nic nie znaleźli. ");
INSERT INTO polubg_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Wtedy PAN powiedział do Mojżesza: Jak długo będziecie się wzbraniać przed przestrzeganiem moich przykazań i moich praw? ");
INSERT INTO polubg_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Patrzcie, PAN dał wam szabat, dlatego w szóstym dniu daje wam chleb na dwa dni. Niech każdy zostanie na swoim miejscu, niech nikt nie wychodzi ze swego miejsca w siódmym dniu. ");
INSERT INTO polubg_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Odpoczywał więc lud siódmego dnia. ");
INSERT INTO polubg_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","I dom Izraela nadał temu pokarmowi nazwę manna. Była jak nasienie kolendry, biała, o smaku placków z miodem. ");
INSERT INTO polubg_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mojżesz powiedział: Tak rozkazał PAN: Napełnij nim omer na przechowanie dla waszych przyszłych pokoleń, aby widziały ten chleb, którym was karmiłem na pustyni, gdy wyprowadziłem was z ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Potem Mojżesz powiedział do Aarona: Weź naczynie, wsyp do niego pełen omer manny i postaw je przed PANEM na przechowanie dla waszych przyszłych pokoleń. ");
INSERT INTO polubg_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Jak PAN przykazał Mojżeszowi, tak Aaron postawił je przed Świadectwem na przechowanie. ");
INSERT INTO polubg_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","A synowie Izraela jedli mannę przez czterdzieści lat, aż przybyli do ziemi zamieszkałej. Jedli mannę, aż przybyli do granic ziemi Kanaan. ");
INSERT INTO polubg_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","A omer to dziesiąta część efy. ");
INSERT INTO polubg_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Całe zgromadzenie synów Izraela wyruszyło z pustyni Sin, robiąc postoje, według rozkazu PANA, i rozbili obóz w Refidim, gdzie nie było wody, aby lud mógł się napić. ");
INSERT INTO polubg_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Dlatego lud spierał się z Mojżeszem, mówiąc: Dajcie nam wody, abyśmy się napili. Mojżesz odpowiedział im: Dlaczego kłócicie się ze mną? Czemu wystawiacie PANA na próbę? ");
INSERT INTO polubg_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Lud zaś pragnął tam wody i szemrał przeciwko Mojżeszowi, mówiąc: Po co wyprowadziłeś nas z Egiptu, aby uśmiercić nas, nasze dzieci i nasze bydło pragnieniem? ");
INSERT INTO polubg_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Wtedy Mojżesz zawołał do PANA: Cóż mam uczynić z tym ludem? Jeszcze trochę, a mnie ukamienują. ");
INSERT INTO polubg_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","I PAN powiedział do Mojżesza: Idź przed ludem i weź ze sobą niektórych ze starszych Izraela. Weź także w rękę swoją laskę, którą uderzyłeś w rzekę, i idź. ");
INSERT INTO polubg_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Oto stanę przed tobą tam, na skale na Horebie, i uderzysz w skałę, a wypłynie z niej woda, którą lud będzie pił. I Mojżesz uczynił tak na oczach starszych Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","I nadał temu miejscu nazwę Massa i Meriba z powodu kłótni synów Izraela i dlatego, że wystawili na próbę PANA, mówiąc: Czy PAN jest wśród nas, czy nie? ");
INSERT INTO polubg_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Tymczasem Amalek nadciągnął, aby walczyć z Izraelem w Refidim. ");
INSERT INTO polubg_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","I Mojżesz powiedział do Jozuego: Wybierz nam mężczyzn, wyrusz i stocz bitwę z Amalekiem. Ja zaś jutro stanę na szczycie wzgórza z laską Boga w ręku. ");
INSERT INTO polubg_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Jozue uczynił więc, jak mu Mojżesz rozkazał, i stoczył bitwę z Amalekiem. A Mojżesz, Aaron i Chur weszli na szczyt wzgórza. ");
INSERT INTO polubg_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Gdy Mojżesz podnosił rękę, przeważał Izrael, a gdy opuszczał rękę, przeważał Amalek. ");
INSERT INTO polubg_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ale ręce Mojżesza były ociężałe. Wzięli więc kamień i podłożyli pod niego, i usiadł na nim. A Aaron i Chur podpierali jego ręce, jeden z jednej, drugi z drugiej strony. I jego ręce były stale podniesione aż do zachodu słońca. ");
INSERT INTO polubg_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Jozue rozgromił więc Amaleka i jego lud ostrzem miecza. ");
INSERT INTO polubg_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Wtedy PAN powiedział do Mojżesza: Zapisz to na pamiątkę w księdze i powtórz do uszu Jozuego, że wymażę zupełnie pamięć o Amaleku pod niebem. ");
INSERT INTO polubg_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Potem Mojżesz zbudował ołtarz i nadał mu nazwę: PAN moją chorągwią; ");
INSERT INTO polubg_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Bo powiedział: Ręka tronu PANA i wojna PANA będzie przeciwko Amalekowi z pokolenia na pokolenie. ");
INSERT INTO polubg_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","A gdy teść Mojżesza Jetro, kapłan Midianitów, usłyszał o wszystkim, co Bóg uczynił dla Mojżesza i swego ludu Izraela, że PAN wyprowadził Izraela z Egiptu; ");
INSERT INTO polubg_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Wtedy Jetro, teść Mojżesza, wziął żonę Mojżesza Seforę, którą ten wcześniej odesłał; ");
INSERT INTO polubg_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Oraz jej dwóch synów, z których jednemu było na imię Gerszom, bo Mojżesz powiedział: Jestem przybyszem w cudzej ziemi; ");
INSERT INTO polubg_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Drugi zaś miał na imię Eliezer, bo mówił: Bóg mego ojca był moją pomocą i wybawił mnie od miecza faraona. ");
INSERT INTO polubg_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jetro, teść Mojżesza, przybył wraz z jego synami i żoną do Mojżesza na pustynię, gdzie obozował przy górze Boga. ");
INSERT INTO polubg_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","I kazał powiedzieć Mojżeszowi: Ja, twój teść Jetro, idę do ciebie wraz z twoją żoną i z oboma jej synami. ");
INSERT INTO polubg_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mojżesz wyszedł więc swemu teściowi naprzeciw, pokłonił się i ucałował go. Potem wypytywali się wzajemnie o powodzenie i weszli do namiotu. ");
INSERT INTO polubg_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mojżesz opowiedział swemu teściowi wszystko, co PAN uczynił faraonowi i Egipcjanom ze względu na Izraela, o całym trudzie, który ich spotkał w drodze, i jak PAN ich wybawił. ");
INSERT INTO polubg_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetro cieszył się ze wszelkiego dobra, które PAN uczynił Izraelowi, że wybawił go z ręki Egipcjan. ");
INSERT INTO polubg_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","I Jetro powiedział: Niech będzie błogosławiony PAN, który was wybawił z ręki Egipcjan i z ręki faraona i który wybawił lud z niewoli egipskiej. ");
INSERT INTO polubg_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Teraz wiem, że PAN jest większy od wszystkich bogów, bo gdy oni zuchwale powstawali przeciwko niemu, to od tego poginęli. ");
INSERT INTO polubg_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Potem Jetro, teść Mojżesza, wziął całopalenie i ofiary dla Boga. Przyszedł też Aaron i wszyscy starsi Izraela, aby jeść chleb z teściem Mojżesza przed Bogiem. ");
INSERT INTO polubg_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Nazajutrz Mojżesz usiadł, aby sądzić lud. I lud stał przed Mojżeszem od rana aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Gdy teść Mojżesza zobaczył wszystko, co on czynił dla ludu, powiedział: Cóż to jest, co ty czynisz dla ludu? Dlaczego ty siedzisz sam, a cały lud stoi przed tobą od rana aż do wieczora? ");
INSERT INTO polubg_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Wtedy Mojżesz odpowiedział swemu teściowi: Bo lud przychodzi do mnie, aby się radzić Boga. ");
INSERT INTO polubg_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Gdy mają jakąś sprawę, przychodzą do mnie, a ja rozsądzam między nimi i oznajmiam ustawy Boga i jego prawa. ");
INSERT INTO polubg_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Teść Mojżesza powiedział do niego: Niedobra to rzecz, którą czynisz. ");
INSERT INTO polubg_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Zamęczycie się i ty, i ten lud, który jest z tobą, bo ta sprawa jest zbyt ciężka dla ciebie. Sam jej nie podołasz. ");
INSERT INTO polubg_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Dlatego posłuchaj teraz mego głosu, poradzę ci, a Bóg będzie z tobą. Wstawiaj się za ludem przed Bogiem i zanoś sprawy Bogu; ");
INSERT INTO polubg_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Nauczaj go też ustaw i praw, wskazuj im drogę, którą mają chodzić, i czyny, które mają spełniać. ");
INSERT INTO polubg_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Upatrz też sobie wśród całego ludu mężczyzn dzielnych i bojących się Boga, mężczyzn prawdomównych, którzy nienawidzą chciwości, i ustanów ich przełożonymi nad tysiącem, nad setką, nad pięćdziesiątką i nad dziesiątką. ");
INSERT INTO polubg_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Niech oni sądzą lud w każdym czasie. A gdy będzie ważniejsza sprawa, zaniosą ją do ciebie, ale każdą mniej ważną sprawę sami będą sądzić. W ten sposób ulżysz sobie, gdy poniosą ciężar z tobą. ");
INSERT INTO polubg_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Jeśli tak uczynisz, a Bóg tak ci nakaże, wytrwasz i cały ten lud będzie wracać na swoje miejsce w pokoju. ");
INSERT INTO polubg_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mojżesz usłuchał więc rady swego teścia i uczynił wszystko, jak mu powiedział. ");
INSERT INTO polubg_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","I Mojżesz wybrał z całego Izraela dzielnych mężczyzn, i ustanowił ich przełożonymi nad ludem, nad tysiącem, nad setką, nad pięćdziesiątką i nad dziesiątką; ");
INSERT INTO polubg_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","I sądzili lud w każdym czasie. Trudne sprawy zanosili do Mojżesza, a każdą drobniejszą sprawę sami sądzili. ");
INSERT INTO polubg_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Potem Mojżesz odprawił swego teścia, który odszedł do swej ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","W trzecim miesiącu od wyjścia synów Izraela z ziemi Egiptu, w tym samym dniu, przyszli na pustynię Synaj. ");
INSERT INTO polubg_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Bo wyruszyli z Refidim i po przybyciu na pustynię Synaj rozbili obóz na pustyni; tam Izrael obozował naprzeciw góry. ");
INSERT INTO polubg_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","A Mojżesz wstąpił do Boga i PAN zawołał do niego z góry: Tak powiesz domowi Jakuba i oznajmisz synom Izraela: ");
INSERT INTO polubg_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Widzieliście, co uczyniłem Egipcjanom i jak niosłem was na skrzydłach orłów, i przyprowadziłem was do siebie. ");
INSERT INTO polubg_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Dlatego teraz, jeśli posłuchacie mego głosu i będziecie przestrzegać mojego przymierza, będziecie moją szczególną własnością ponad wszystkie narody, bo do mnie należy cała ziemia. ");
INSERT INTO polubg_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","A wy będziecie mi królestwem kapłanów i narodem świętym. To są słowa, które będziesz mówić do synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Wtedy Mojżesz przyszedł i zwołał starszych ludu, i wyłożył im wszystkie te słowa, które mu PAN nakazał. ");
INSERT INTO polubg_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Cały lud odpowiedział wspólnie: Uczynimy wszystko, co PAN powiedział. I Mojżesz zaniósł słowa ludu do PANA. ");
INSERT INTO polubg_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","PAN powiedział do Mojżesza: Oto przyjdę do ciebie w gęstym obłoku, aby lud słyszał, gdy będę z tobą rozmawiał, i uwierzył ci na zawsze. A Mojżesz przekazał PANU słowa ludu. ");
INSERT INTO polubg_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","PAN zaś mówił do Mojżesza: Idź do ludu i uświęć ich dziś i jutro, i niech wypiorą swoje szaty. ");
INSERT INTO polubg_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Niech będą gotowi na trzeci dzień. Trzeciego dnia bowiem PAN zstąpi na oczach całego ludu na górę Synaj. ");
INSERT INTO polubg_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","I wyznaczysz ludowi granice dokoła, mówiąc: Strzeżcie się, abyście nie wstępowali na górę ani nie dotykali jej podnóża. Każdy, kto dotknie góry, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Nie dotknie go ręka, ale ukamienują go albo przeszyją strzałami; czy to zwierzę, czy człowiek, nie będzie żyć. Gdy przeciągle będą trąbić, niech podejdą do góry. ");
INSERT INTO polubg_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mojżesz zstąpił więc z góry do ludu i uświęcił lud, a oni uprali swoje szaty. ");
INSERT INTO polubg_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","I mówił do ludu: Bądźcie gotowi na trzeci dzień, nie zbliżajcie się do żon. ");
INSERT INTO polubg_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Trzeciego dnia o poranku pojawiły się grzmoty i błyskawice, i gęsty obłok nad górą, i bardzo potężny głos trąby, tak że cały lud, który był w obozie, zadrżał. ");
INSERT INTO polubg_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","I Mojżesz wyprowadził lud z obozu na spotkanie z Bogiem, i stanęli u stóp góry. ");
INSERT INTO polubg_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","A góra Synaj cała dymiła, gdyż PAN zstąpił na nią w ogniu. Dym unosił się z niej jak dym z pieca i cała góra bardzo się trzęsła. ");
INSERT INTO polubg_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","A gdy głos trąby się przeciągał i coraz bardziej się rozlegał, Mojżesz mówił, a Bóg odpowiadał mu głosem. ");
INSERT INTO polubg_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","I PAN zstąpił na górę Synaj, na szczyt góry. Wtedy PAN wezwał Mojżesza na szczyt góry i Mojżesz tam wstąpił. ");
INSERT INTO polubg_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Potem PAN powiedział do Mojżesza: Zejdź, przestrzeż lud, by nie przekroczył granicy, aby zobaczyć PANA, i aby wielu z nich nie zginęło. ");
INSERT INTO polubg_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Nawet kapłani, którzy zbliżają się do PANA, niech się uświęcą, by ich PAN nie wytracił. ");
INSERT INTO polubg_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","I Mojżesz powiedział do PANA: Lud nie może wejść na górę Synaj, ponieważ ty nas przestrzegłeś, mówiąc: Wyznacz granice wokół góry i uświęć ją. ");
INSERT INTO polubg_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","PAN powiedział do niego: Idź, zejdź, a potem wstąpisz ty i Aaron z tobą. Lecz kapłani i lud niech nie przekraczają granicy, by wstąpić do PANA, aby ich nie wytracił. ");
INSERT INTO polubg_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mojżesz zszedł więc do ludu i powiedział im to. ");
INSERT INTO polubg_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","I Bóg mówił te wszystkie słowa: ");
INSERT INTO polubg_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ja jestem PAN, twój Bóg, który cię wyprowadził z ziemi Egiptu, z domu niewoli. ");
INSERT INTO polubg_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Nie będziesz miał innych bogów przede mną. ");
INSERT INTO polubg_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Nie będziesz czynił sobie żadnego rzeźbionego posągu ani żadnej podobizny czegokolwiek, co jest w górze na niebie, co jest nisko na ziemi ani co jest w wodach pod ziemią. ");
INSERT INTO polubg_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Nie będziesz oddawał im pokłonu ani nie będziesz im służył, bo ja jestem PAN, twój Bóg, Bóg zazdrosny, nawiedzający nieprawość ojców na synach do trzeciego i czwartego pokolenia tych, którzy mnie nienawidzą; ");
INSERT INTO polubg_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","A okazujący miłosierdzie tysiącom tych, którzy mnie miłują i strzegą moich przykazań. ");
INSERT INTO polubg_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Nie będziesz brał imienia PANA, twego Boga, nadaremnie, gdyż PAN nie zostawi bez kary tego, który bierze jego imię nadaremnie. ");
INSERT INTO polubg_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Pamiętaj o dniu szabatu, aby go święcić. ");
INSERT INTO polubg_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Sześć dni będziesz pracować i wykonywać wszystkie swoje prace; ");
INSERT INTO polubg_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ale siódmy dzień jest szabatem PANA, twego Boga. W tym dniu nie będziesz wykonywał żadnej pracy – ani ty, ani twój syn, ani twoja córka, ani twój sługa, ani twoja służąca, ani twoje bydło, ani twój gość, który jest w obrębie twoich bram. ");
INSERT INTO polubg_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","PAN bowiem przez sześć dni stworzył niebo i ziemię, morze i wszystko, co jest w nich, a siódmego dnia odpoczął. Dlatego PAN błogosławił dzień szabatu i uświęcił go. ");
INSERT INTO polubg_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Czcij swego ojca i swoją matkę, aby twoje dni były długie na ziemi, którą PAN, twój Bóg, da tobie. ");
INSERT INTO polubg_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Nie będziesz zabijał. ");
INSERT INTO polubg_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Nie będziesz cudzołożył. ");
INSERT INTO polubg_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Nie będziesz kradł. ");
INSERT INTO polubg_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Nie będziesz fałszywie świadczył przeciw twemu bliźniemu. ");
INSERT INTO polubg_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Nie będziesz pożądał domu twego bliźniego ani nie będziesz pożądał żony twego bliźniego, ani jego sługi, ani jego służącej, ani jego wołu, ani jego osła, ani żadnej rzeczy, która należy do twego bliźniego. ");
INSERT INTO polubg_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Wtedy cały lud widział gromy i błyskawice i słyszał głos trąby, i dostrzegał dymiącą górę. Gdy lud to widział, cofnął się i stanął z daleka. ");
INSERT INTO polubg_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","I mówił do Mojżesza: Ty mów do nas, a będziemy słuchać, ale niech Bóg do nas nie mówi, byśmy nie pomarli. ");
INSERT INTO polubg_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mojżesz odpowiedział ludowi: Nie bójcie się. Bóg bowiem przyszedł, aby was wystawić na próbę i żeby jego bojaźń była przed waszym obliczem, byście nie grzeszyli. ");
INSERT INTO polubg_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Stał więc lud z daleka, a Mojżesz zbliżył się do gęstego mroku, w którym był Bóg. ");
INSERT INTO polubg_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","I PAN powiedział do Mojżesza: Tak powiesz synom Izraela: Widzieliście, że mówiłem do was z nieba. ");
INSERT INTO polubg_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Nie będziecie czynić przy mnie bogów ze srebra ani bogów ze złota nie będziecie sobie czynić. ");
INSERT INTO polubg_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Uczynisz mi ołtarz z ziemi i będziesz składać na nim twoje całopalenia i twoje ofiary pojednawcze, twoje owce i twoje bydło. Na każdym miejscu, gdzie upamiętnię swoje imię, przyjdę do ciebie i będę ci błogosławił. ");
INSERT INTO polubg_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","A jeśli uczynisz mi ołtarz kamienny, nie buduj go z ciosanego kamienia. Jeśli bowiem przyłożysz do niego żelazne narzędzie, zbezcześcisz go. ");
INSERT INTO polubg_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Nie będziesz wstępował po stopniach do mojego ołtarza, aby twoja nagość nie była przy nim odkryta. ");
INSERT INTO polubg_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","A oto prawa, które im przedstawisz. ");
INSERT INTO polubg_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Jeśli kupisz niewolnika – Hebrajczyka, sześć lat będzie ci służyć, a w siódmym roku wyjdzie na wolność bez wykupu. ");
INSERT INTO polubg_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Jeśli sam przyszedł, sam odejdzie; a jeśli miał żonę, jego żona odejdzie z nim. ");
INSERT INTO polubg_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Jeśli jego pan dał mu żonę, a ona urodziła mu synów lub córki, to jego żona i dzieci będą należały do jego pana, a on odejdzie sam. ");
INSERT INTO polubg_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","A jeśli niewolnik powie: Kocham mojego pana, moją żonę i moich synów, nie wyjdę na wolność; ");
INSERT INTO polubg_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Wtedy jego pan zaprowadzi go do sędziów i przyprowadzi go do drzwi albo do ich słupka; i jego pan szydłem przekłuje mu ucho, i będzie jego niewolnikiem na zawsze. ");
INSERT INTO polubg_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Jeśli zaś kto sprzeda swoją córkę, aby była niewolnicą, nie odejdzie ona, jak odchodzą niewolnicy. ");
INSERT INTO polubg_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Jeśli się nie spodoba swemu panu, który zamierzał ją poślubić, niech pozwoli, aby została odkupiona. Nie ma prawa sprzedać jej obcemu ludowi, ponieważ zrobiłby jej krzywdę. ");
INSERT INTO polubg_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","A jeśli przeznaczył ją dla swego syna, to postąpi z nią według prawa córek. ");
INSERT INTO polubg_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Jeśli weźmie sobie za żonę jeszcze inną, nie umniejszy jej pożywienia, jej ubrania ani prawa małżeńskiego. ");
INSERT INTO polubg_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","A jeśli nie zapewni jej tych trzech rzeczy, wtedy wyjdzie ona darmo bez okupu. ");
INSERT INTO polubg_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Kto uderzy człowieka tak, że ten umrze, poniesie śmierć; ");
INSERT INTO polubg_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","A jeśli nie czyhał na niego, ale Bóg podał go w jego rękę, wyznaczę miejsce, do którego będzie mógł uciec. ");
INSERT INTO polubg_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ale jeśli ktoś czyha na swego bliźniego i podstępnie go zabija, to nawet od mojego ołtarza go weźmiesz, aby umarł. ");
INSERT INTO polubg_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Kto uderzy swego ojca albo swoją matkę, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Kto uprowadzi człowieka i sprzeda go lub zostanie on znaleziony w jego ręku, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Kto złorzeczy swemu ojcu lub swojej matce, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","A jeśli mężczyźni się pokłócą i jeden uderzy drugiego kamieniem lub pięścią, tak że ten nie umrze, ale musi położyć się w łóżku; ");
INSERT INTO polubg_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","To jeśli wstanie i będzie mógł chodzić po ulicy o lasce, ten, który uderzył, będzie niewinny; wypłaci mu tylko odszkodowanie i będzie łożyć na jego leczenie. ");
INSERT INTO polubg_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Jeśli zaś ktoś uderzy kijem swego niewolnika lub swoją niewolnicę tak, że umrą pod jego ręką, musi ponieść karę; ");
INSERT INTO polubg_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Jeśli jednak niewolnik zostaje przy życiu dzień lub dwa, nie będzie karany; bo niewolnik to jego pieniądze. ");
INSERT INTO polubg_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Jeśli mężczyźni się pokłócą i uderzą kobietę brzemienną, tak że wyjdzie z niej płód, jednak bez żadnej szkody, to musi ponieść karę, jaką nałoży na niego mąż tej kobiety, a da według uznania sędziów. ");
INSERT INTO polubg_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Jeśli jednak dojdzie do szkody, wtedy dasz życie za życie; ");
INSERT INTO polubg_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Oko za oko, ząb za ząb, rękę za rękę, nogę za nogę; ");
INSERT INTO polubg_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Oparzenie za oparzenie, ranę za ranę, siniec za siniec. ");
INSERT INTO polubg_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Jeśli ktoś uderzy w oko swego niewolnika lub w oko swojej niewolnicy, tak że je wybije, za jego oko wypuści go na wolność. ");
INSERT INTO polubg_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Jeśli też ktoś wybije ząb swemu niewolnikowi lub ząb swojej niewolnicy, za jego ząb wypuści go na wolność. ");
INSERT INTO polubg_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Jeśli czyjś wół ubodzie na śmierć mężczyznę lub kobietę, ten wół musi zostać ukamienowany, a jego mięsa nie wolno jeść. Właściciel wołu zaś będzie niewinny. ");
INSERT INTO polubg_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Jeśli jednak wół bódł przedtem i ostrzegano o tym jego właściciela, ten zaś nie pilnował go, i wół zabił mężczyznę lub kobietę, wół będzie ukamienowany i jego właściciel poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Jeśli nałożono mu karę pieniężną, wtedy da za swoją duszę okup, jaki na niego nałożą. ");
INSERT INTO polubg_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Choćby ubódł syna lub córkę, postąpią z nim według tego samego prawa. ");
INSERT INTO polubg_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Jeśli wół ubodzie niewolnika lub niewolnicę, da ich panu trzydzieści syklów srebra, a wół będzie ukamienowany. ");
INSERT INTO polubg_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Jeśli ktoś zostawi studnię odkrytą lub jeśli ktoś wykopie studnię i nie nakryje jej, a wpadnie w nią wół lub osioł; ");
INSERT INTO polubg_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Właściciel tej studni musi wyrównać stratę i wynagrodzi ich właścicielowi, a zdechłe zwierzę będzie należeć do niego. ");
INSERT INTO polubg_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Także jeśli czyjś wół ubodzie na śmierć wołu jego sąsiada, wtedy sprzedadzą żywego wołu i podzielą się zapłatą za niego; podzielą się też tym zdechłym. ");
INSERT INTO polubg_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ale jeśli było wiadomo, że ten wół bódł przedtem, a jego właściciel nie pilnował go, musi oddać wołu za wołu, a zdechłe zwierzę będzie należeć do niego. ");
INSERT INTO polubg_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Jeśli ktoś ukradnie wołu lub owcę i zabije je albo sprzeda, odda pięć wołów za jednego wołu i cztery owce za jedną owcę. ");
INSERT INTO polubg_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Jeśli złodziej zostanie przyłapany przy włamaniu i tak pobity, że umrze, ten, kto zabił, nie będzie winien przelanej krwi. ");
INSERT INTO polubg_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Jeśli to zrobi po wschodzie słońca, będzie winien krwi, gdyż złodziej powinien wypłacić odszkodowanie. Jeśli nic nie ma, będzie sprzedany za swoją kradzież. ");
INSERT INTO polubg_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Jeśli zostaną znalezione w jego ręku skradzione dobra jeszcze żywe, czy to wół, czy osioł, czy owca, zwróci podwójnie. ");
INSERT INTO polubg_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Gdyby ktoś wypasł pole lub winnicę, bo puścił swoje bydło, aby się pasło na cudzym polu, wypłaci odszkodowanie z najlepszych plonów swego pola i z najlepszych plonów swej winnicy. ");
INSERT INTO polubg_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Jeśli wybuchnie ogień, a trafi na ciernie i spali stóg lub zboże na pniu, lub samo pole, ten, co wzniecił ogień, musi wypłacić odszkodowanie. ");
INSERT INTO polubg_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Jeśli ktoś da swemu bliźniemu pieniądze lub przedmioty do przechowania i zostanie to ukradzione z domu tego człowieka, to jeśli złodziej zostanie znaleziony, zwróci podwójnie. ");
INSERT INTO polubg_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Jeśli złodziej nie zostanie znaleziony, pan tego domu stawi się przed sędziami, by okazało się, czy nie wyciągnął ręki po własność swego bliźniego. ");
INSERT INTO polubg_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","W każdej spornej sprawie o wołu, osła, owcę, szatę czy jakąkolwiek zgubę, gdyby ktoś powiedział, że to jest jego, sprawa obydwu ma trafić do sędziów; kogo sędziowie uznają winnym, ten wynagrodzi podwójnie swemu bliźniemu. ");
INSERT INTO polubg_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Jeśli ktoś odda swemu bliźniemu na przechowanie osła, wołu, owcę lub inne zwierzę, a ono zdechnie, zostanie okaleczone lub uprowadzone i nikt tego nie zobaczy; ");
INSERT INTO polubg_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Wówczas przysięga przed PANEM rozstrzygnie między obydwoma, że nie wyciągnął ręki po własność swego bliźniego. Właściciel przyjmie tę przysięgę, a drugi nie wypłaci odszkodowania. ");
INSERT INTO polubg_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Jeśli jednak to zostało mu skradzione, wypłaci właścicielowi odszkodowanie. ");
INSERT INTO polubg_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Jeśli zostało rozszarpane, to przyniesie je jako dowód, a za rozszarpane nie zapłaci. ");
INSERT INTO polubg_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Jeśli ktoś pożyczy zwierzę od swego bliźniego, a ono zostanie okaleczone lub zdechnie podczas nieobecności jego właściciela, musi wypłacić odszkodowanie. ");
INSERT INTO polubg_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Jeśli jego właściciel był przy nim, nie zapłaci; a jeśli było wynajęte, zapłaci tylko za wynajem. ");
INSERT INTO polubg_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Jeśli ktoś uwiedzie dziewicę, która nie jest poślubiona, i położy się z nią, musi jej dać posag i weźmie ją sobie za żonę. ");
INSERT INTO polubg_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Jeśli jej ojciec żadną miarą nie zgodzi się dać mu jej, odważy pieniądze według zwyczaju panieńskiego posagu. ");
INSERT INTO polubg_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Nie zostawisz czarownicy przy życiu. ");
INSERT INTO polubg_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Każdy, kto spółkuje ze zwierzęciem, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Kto składa ofiary bogom, poza samym PANEM, zostanie stracony. ");
INSERT INTO polubg_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Nie zrobisz krzywdy przybyszowi ani nie będziesz go uciskać, gdyż i wy byliście przybyszami w ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Nie będziecie dręczyć żadnej wdowy ani sieroty. ");
INSERT INTO polubg_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Jeśli będziesz je dręczył, a one będą wołać do mnie, na pewno wysłucham ich wołania. ");
INSERT INTO polubg_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Wtedy rozpali się mój gniew i pobiję was mieczem, i wasze żony będą wdowami, a wasi synowie sierotami. ");
INSERT INTO polubg_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Jeśli pożyczysz pieniądze ubogiemu z mego ludu, który mieszka wśród was, nie postąpisz wobec niego jak lichwiarz, nie będziesz go obciążać lichwą. ");
INSERT INTO polubg_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Jeśli weźmiesz w zastaw szatę twego bliźniego, oddasz mu ją przed zachodem słońca; ");
INSERT INTO polubg_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Bo to ubranie jest jedynym okryciem jego ciała, w tym też śpi. Jeśli będzie do mnie wołał, wysłucham go, bo jestem litościwy. ");
INSERT INTO polubg_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Nie będziesz złorzeczyć sędziom, a przełożonego twego ludu nie będziesz przeklinać. ");
INSERT INTO polubg_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Nie będziesz zwlekał ze złożeniem pierwocin twego zboża i płynnych zbiorów. Oddasz mi pierworodnego z twoich synów. ");
INSERT INTO polubg_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","To samo zrobisz z twoimi wołami i owcami. Siedem dni pierworodny będzie ze swoją matką, a ósmego dnia oddasz mi go. ");
INSERT INTO polubg_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Będziecie dla mnie świętym ludem i nie będziecie jeść mięsa rozszarpanego na polu; wyrzucicie je psom. ");
INSERT INTO polubg_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Nie będziesz rozgłaszał fałszywych wieści. Nie wchodź w spółkę z bezbożnym, by być fałszywym świadkiem. ");
INSERT INTO polubg_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Nie idź za większością, aby wyrządzić zło, i nie zeznawaj w sprawie, ulegając zdaniu większości, by naginać sąd. ");
INSERT INTO polubg_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","I nie okazuj przychylności ubogiemu w jego sprawie. ");
INSERT INTO polubg_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Jeśli napotkasz błądzącego wołu swego wroga lub jego osła, musisz odprowadzić go do niego. ");
INSERT INTO polubg_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Jeśli zobaczysz, że osioł tego, który cię nienawidzi, leży pod swoim ciężarem, nie odmówisz mu pomocy. Owszem, masz mu z nim pomóc. ");
INSERT INTO polubg_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Nie naginaj sądu twego ubogiego w jego sprawie. ");
INSERT INTO polubg_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Trzymaj się z dala od nieuczciwej sprawy. Nie zabijaj niewinnego i sprawiedliwego, bo nie usprawiedliwię bezbożnego. ");
INSERT INTO polubg_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Nie będziesz też brać darów, ponieważ dar zaślepia mądrych i wypacza słowa sprawiedliwych. ");
INSERT INTO polubg_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Nie uciskaj również przybysza, bo sami wiecie, jak się czuje przybysz, gdyż byliście przybyszami w ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Przez sześć lat będziesz obsiewał swoją ziemię i zbierał jej plony; ");
INSERT INTO polubg_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","A w siódmym roku zostawisz ją odłogiem, żeby odpoczęła, aby jedli ubodzy twego ludu, a co zostanie po nich, zjedzą zwierzęta polne. Tak też postąpisz ze swoją winnicą i swoim sadem oliwnym. ");
INSERT INTO polubg_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Przez sześć dni będziesz wykonywać swoją pracę, ale siódmego dnia odpoczniesz, aby odpoczął twój wół i twój osioł i żeby odetchnął syn twojej niewolnicy i przybysz. ");
INSERT INTO polubg_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","A we wszystkim, co wam powiedziałem, bądźcie ostrożni. Nie wspominajcie też imienia obcych bogów, niech nie będzie słyszane z twoich ust. ");
INSERT INTO polubg_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Trzy razy w roku będziesz obchodzić dla mnie święto. ");
INSERT INTO polubg_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Będziesz obchodzić Święto Przaśników. Siedem dni będziesz jeść przaśniki, jak ci nakazałem, w miesiącu Abib, bo w nim wyszedłeś z Egiptu. Nie pokażecie się przede mną z pustymi rękami. ");
INSERT INTO polubg_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","I Święto Żniw, pierwocin twojej pracy, tego, co posiałeś na polu. I także Święto Zbiorów pod koniec roku, gdy zbierzesz z pola owoce swojej pracy. ");
INSERT INTO polubg_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Trzy razy w roku wszyscy twoi mężczyźni mają się pokazać przed Panem BOGIEM. ");
INSERT INTO polubg_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Nie będziesz ofiarował krwi mojej ofiary z chlebem kwaszonym, a tłuszcz mojej ofiary nie zostanie przez noc aż do poranka. ");
INSERT INTO polubg_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Przyniesiesz do domu PANA, twego Boga, pierwociny z pierwszych plonów swojej ziemi. Nie będziesz gotował koźlęcia w mleku jego matki. ");
INSERT INTO polubg_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Oto posyłam Anioła przed tobą, aby cię strzegł w drodze i doprowadził do miejsca, które przygotowałem. ");
INSERT INTO polubg_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Zważaj na niego i słuchaj jego głosu; nie pobudzaj go do gniewu, bo nie przebaczy waszych przestępstw, gdyż moje imię jest w nim. ");
INSERT INTO polubg_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Bo jeśli będziesz pilnie słuchać jego głosu i uczynisz wszystko, co powiem, będę wrogiem twoich wrogów i będę dręczyć tych, którzy cię dręczyli. ");
INSERT INTO polubg_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mój Anioł bowiem pójdzie przed tobą i wprowadzi cię do Amorytów, Chetytów, Peryzzytów, Kananejczyków, Chiwwitów i Jebusytów, i wytracę ich. ");
INSERT INTO polubg_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Nie będziesz oddawał pokłonu ich bogom ani nie będziesz im służył, ani nie postępuj według ich czynów, ale do gruntu zburz ich i doszczętnie pokrusz ich posągi. ");
INSERT INTO polubg_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Będziecie służyć PANU, waszemu Bogu, a on będzie błogosławić twój chleb i twoją wodę; i oddalę od ciebie chorobę. ");
INSERT INTO polubg_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Nie będzie w twojej ziemi roniącej ani niepłodnej. Dopełnię liczbę twoich dni. ");
INSERT INTO polubg_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Poślę mój strach przed tobą i strwożę wszelki lud, przeciw któremu pójdziesz, i sprawię, że wszyscy twoi wrogowie uciekną przed tobą. ");
INSERT INTO polubg_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Poślę też przed tobą szerszenie, które wypędzą Chiwwitów, Kananejczyków i Chetytów sprzed twego oblicza. ");
INSERT INTO polubg_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Nie wypędzę ich sprzed twojego oblicza w jednym roku, by ziemia nie zmieniła się w pustynię i nie namnożył się przeciwko tobie dziki zwierz. ");
INSERT INTO polubg_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Pomału będę ich wypędzał sprzed twego oblicza, aż się rozmnożysz i posiądziesz ziemię. ");
INSERT INTO polubg_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","A ustanowię twoje granice od Morza Czerwonego aż do Morza Filistynów, od pustyni aż do rzeki. Oddam bowiem w wasze ręce mieszkańców tej ziemi, a ty wypędzisz ich sprzed twego oblicza. ");
INSERT INTO polubg_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Nie zawrzesz przymierza z nimi ani z ich bogami. ");
INSERT INTO polubg_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Nie wolno im mieszkać w twojej ziemi, by cię nie doprowadzili do grzechu przeciwko mnie. Jeśli bowiem będziesz służył ich bogom, będzie to dla ciebie sidłem. ");
INSERT INTO polubg_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","I powiedział do Mojżesza: Wstąpcie do PANA ty i Aaron, Nadab i Abihu oraz siedemdziesięciu ze starszych Izraela i oddajcie pokłon z daleka. ");
INSERT INTO polubg_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Tylko sam Mojżesz zbliży się do PANA. Oni zaś nie zbliżą się ani lud nie wstąpi z nim. ");
INSERT INTO polubg_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mojżesz przyszedł więc i opowiedział ludowi wszystkie słowa PANA i wszystkie prawa. I cały lud odpowiedział jednym głosem: Wypełnimy wszystkie słowa, które PAN powiedział. ");
INSERT INTO polubg_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Wtedy Mojżesz spisał wszystkie słowa PANA. A kiedy rano wstał, zbudował ołtarz u stóp góry i ustawił dwanaście słupów, według liczby dwunastu pokoleń Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","I posłał młodzieńców z synów Izraela, i ci ofiarowali całopalenia, i złożyli PANU cielce jako ofiary pojednawcze. ");
INSERT INTO polubg_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Potem Mojżesz wziął połowę krwi i wlał do czaszy, a drugą połową pokropił ołtarz. ");
INSERT INTO polubg_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Następnie wziął księgę przymierza i czytał ludowi, a oni powiedzieli: Wypełnimy wszystko, co PAN mówił, i będziemy posłuszni. ");
INSERT INTO polubg_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mojżesz wziął też krew i pokropił lud, mówiąc: Oto krew przymierza, które PAN zawarł z wami, według wszystkich tych słów. ");
INSERT INTO polubg_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","I wstąpili Mojżesz, Aaron, Nadab i Abihu oraz siedemdziesięciu ze starszych Izraela; ");
INSERT INTO polubg_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","I widzieli Boga Izraela, a pod jego nogami było jakby dzieło z szafirowego kamienia jak niebo, gdy jest jasne. ");
INSERT INTO polubg_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","A na przywódców synów Izraela PAN nie wyciągnął swej ręki, choć widzieli Boga, jedli i pili. ");
INSERT INTO polubg_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Wtedy PAN powiedział do Mojżesza: Wstąp do mnie na górę i bądź tam, a dam ci kamienne tablice, prawo i przykazania, które napisałem, abyś ich nauczał. ");
INSERT INTO polubg_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mojżesz wstał więc wraz z Jozuem, swoim sługą; i Mojżesz wstąpił na górę Boga. ");
INSERT INTO polubg_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","A do starszych powiedział: Zostańcie tu, aż wrócimy do was. A oto Aaron i Chur będą z wami. Kto by miał jakąś sprawę, niech idzie do nich. ");
INSERT INTO polubg_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Wtedy Mojżesz wstąpił na górę, a obłok zakrył górę. ");
INSERT INTO polubg_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","I chwała PANA spoczęła na górze Synaj, a obłok okrywał ją przez sześć dni. W siódmym dniu PAN zawołał na Mojżesza spośród obłoku. ");
INSERT INTO polubg_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","A wygląd chwały PANA w oczach synów Izraela był jak ogień pożerający na szczycie góry. ");
INSERT INTO polubg_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","I Mojżesz wszedł w środek obłoku, i wstąpił na górę. A był Mojżesz na górze czterdzieści dni i czterdzieści nocy. ");
INSERT INTO polubg_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Powiedz synom Izraela, aby przynieśli mi dar. Od każdego człowieka, który daje dobrowolnie ze swego serca, zbierzcie dar dla mnie. ");
INSERT INTO polubg_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","A to są dary, które zbierzecie od nich: złoto, srebro i miedź; ");
INSERT INTO polubg_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Błękitna tkanina, purpura, karmazyn, bisior i sierść kozia; ");
INSERT INTO polubg_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Skóry baranie farbowane na czerwono, skóry borsucze i drewno akacjowe; ");
INSERT INTO polubg_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Oliwa do oświetlenia, wonności na olejek do namaszczania i na wonne kadzidło; ");
INSERT INTO polubg_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Kamienie onyksowe i kamienie do osadzenia efodu i pektorału. ");
INSERT INTO polubg_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","I zbudują mi świątynię, abym mieszkał pośród nich. ");
INSERT INTO polubg_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Według wszystkiego, co ci ukażę, według wzoru przybytku i wzoru wszystkich jego naczyń, tak uczynicie. ");
INSERT INTO polubg_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Uczynią też arkę z drewna akacjowego. Jej długość będzie na dwa i pół łokcia, jej szerokość – na półtora łokcia, a jej wysokość – na półtora łokcia. ");
INSERT INTO polubg_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","I pokryjesz ją szczerym złotem, wewnątrz i na zewnątrz pokryjesz ją, a na niej dokoła uczynisz złotą listwę. ");
INSERT INTO polubg_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Odlejesz też do niej cztery złote pierścienie, które przymocujesz do czterech jej narożników: dwa pierścienie do jednego jej boku i dwa pierścienie do drugiego jej boku. ");
INSERT INTO polubg_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Uczynisz drążki z drewna akacjowego i pokryjesz je złotem. ");
INSERT INTO polubg_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","I włożysz drążki w pierścienie na bokach arki, aby na nich noszono arkę. ");
INSERT INTO polubg_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Drążki te pozostaną w pierścieniach arki; nie będą z niej wyjmowane. ");
INSERT INTO polubg_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","W arkę włożysz świadectwo, które ci dam. ");
INSERT INTO polubg_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Uczynisz też przebłagalnię ze szczerego złota. Jej długość będzie na dwa i pół łokcia, a jej szerokość – na półtora łokcia. ");
INSERT INTO polubg_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","I uczynisz dwa złote cherubiny: wykujesz je ze złota na obu końcach przebłagalni. ");
INSERT INTO polubg_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Jednego cherubina uczynisz na jednym końcu, a drugiego cherubina na drugim końcu. Z samej przebłagalni uczynicie cherubiny na obu jej końcach. ");
INSERT INTO polubg_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","A cherubiny będą mieć skrzydła rozpostarte ku górze, zakrywając swymi skrzydłami przebłagalnię. Ich twarze zaś będą zwrócone ku sobie, twarze cherubinów będą zwrócone ku przebłagalni. ");
INSERT INTO polubg_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","I położysz przebłagalnię na wierzchu arki, a w arkę włożysz świadectwo, które ci dam. ");
INSERT INTO polubg_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Tam będę się z tobą spotykać i sponad przebłagalni, spomiędzy dwóch cherubinów, którzy są nad arką świadectwa, będę z tobą rozmawiać o wszystkim, co ci rozkażę dla synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Uczynisz też stół z drewna akacjowego. Jego długość będzie na dwa łokcie, jego szerokość – na jeden łokieć, a jego wysokość – na półtora łokcia. ");
INSERT INTO polubg_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","I pokryjesz go szczerym złotem, i uczynisz dokoła niego złotą listwę. ");
INSERT INTO polubg_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Uczynisz też dokoła niego obramowanie szerokie na cztery palce i złotą listwę dokoła obramowania. ");
INSERT INTO polubg_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Uczynisz też do niego cztery złote pierścienie i przymocujesz je na czterech narożnikach, które są przy jego czterech nogach. ");
INSERT INTO polubg_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Przy tym obramowaniu będą pierścienie, przez które przewloką drążki do noszenia stołu. ");
INSERT INTO polubg_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","A te drążki uczynisz z drewna akacjowego i pokryjesz je złotem, i będzie na nich noszony stół. ");
INSERT INTO polubg_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Uczynisz też jego misy, czasze, przykrycia i kubki do nalewania; wykonasz je ze szczerego złota. ");
INSERT INTO polubg_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","I na ten stół nieustannie będziesz kłaść przede mną chleby pokładne. ");
INSERT INTO polubg_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Uczynisz też świecznik ze szczerego złota. Ów świecznik będzie wykuty: jego podstawa, ramiona, kielichy, gałki i kwiaty będą z tej samej bryły. ");
INSERT INTO polubg_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Z jego boków będzie wychodzić sześć ramion: trzy ramiona świecznika z jednego boku i trzy ramiona świecznika z drugiego boku. ");
INSERT INTO polubg_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Trzy kielichy na kształt migdału na jednym ramieniu, wraz z gałką i kwiatem; i trzy kielichy na kształt migdału na drugim ramieniu, wraz z gałką i kwiatem. Tak będzie na wszystkich sześciu ramionach wychodzących ze świecznika. ");
INSERT INTO polubg_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ale na trzonie świecznika będą cztery kielichy na kształt migdału, z gałkami i kwiatami. ");
INSERT INTO polubg_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","I będzie gałka pod dwoma jego ramionami, także gałka pod następnymi dwoma ramionami i gałka pod innymi dwoma ramionami: tak będzie pod sześcioma ramionami wychodzącymi ze świecznika. ");
INSERT INTO polubg_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Z niego samego będą wychodzić gałki i ramiona, wszystko to w całości będzie wykute ze szczerego złota. ");
INSERT INTO polubg_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Uczynisz też do niego siedem lamp i zapalisz je, aby świeciły w przeciwległą stronę. ");
INSERT INTO polubg_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Także jego szczypce i naczynia na popiół mają być ze szczerego złota. ");
INSERT INTO polubg_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Uczynisz go i wszystkie naczynia z talentu szczerego złota. ");
INSERT INTO polubg_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Uważaj, abyś uczynił wszystko według wzoru tego, co ci ukazano na górze. ");
INSERT INTO polubg_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Uczynisz też przybytek z dziesięciu zasłon ze skręconego bisioru, z błękitnej tkaniny oraz z purpury i karmazynu, na których wyhaftujesz cherubiny. ");
INSERT INTO polubg_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Długość jednej zasłony ma wynosić dwadzieścia osiem łokci, a szerokość jednej zasłony – cztery łokcie. Wszystkie zasłony będą miały jednakowe wymiary. ");
INSERT INTO polubg_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pięć zasłon będzie spiętych jedna z drugą; także drugie pięć zasłon będzie spiętych jedna z drugą. ");
INSERT INTO polubg_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","I uczynisz błękitne pętle na brzegu jednej zasłony, gdzie skraje mają się spinać. Uczynisz je też na brzegu drugiej zasłony, gdzie skraje mają się spinać. ");
INSERT INTO polubg_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Pięćdziesiąt pętli uczynisz na jednej zasłonie i pięćdziesiąt pętli uczynisz na brzegu drugiej zasłony, w miejscu, gdzie ma być spięta z drugą. Pętle będą jedna naprzeciw drugiej. ");
INSERT INTO polubg_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Uczynisz też pięćdziesiąt złotych haczyków i złączysz jedną zasłonę z drugą tymi haczykami. I tak przybytek będzie stanowił jedną całość. ");
INSERT INTO polubg_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Uczynisz też zasłony z koziej sierści do przykrycia przybytku z wierzchu. Uczynisz jedenaście takich zasłon. ");
INSERT INTO polubg_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Długość jednej zasłony ma wynosić trzydzieści łokci, a szerokość jednej zasłony – cztery łokcie. Wszystkie jedenaście zasłon będzie mieć jednakowe wymiary. ");
INSERT INTO polubg_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","I zepniesz pięć zasłon osobno, a sześć zasłon osobno. Szóstą zasłonę złożysz we dwoje na przodzie namiotu. ");
INSERT INTO polubg_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Uczynisz też pięćdziesiąt pętli na brzegu jednej zasłony, na końcu, gdzie ma być spięta, i pięćdziesiąt pętli z brzegu drugiej zasłony do spinania drugiego brzegu. ");
INSERT INTO polubg_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Uczynisz też pięćdziesiąt miedzianych haczyków i włożysz haczyki w pętle, i zepniesz namiot, aby stanowił jedną całość. ");
INSERT INTO polubg_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","A część, która zbywa z zasłon namiotu, to jest pozostała połowa zasłony, będzie zwisać z tyłu przybytku. ");
INSERT INTO polubg_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","A łokieć z jednej i łokieć z drugiej strony, który zbywa z długości zasłon namiotu, będzie wisiał po obu stronach przybytku, po jednej i drugiej, żeby go okrywać. ");
INSERT INTO polubg_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Uczynisz też przykrycie na namiot ze skór baranich farbowanych na czerwono i przykrycie ze skór borsuczych na wierzch. ");
INSERT INTO polubg_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Uczynisz też do przybytku prosto stojące deski z drewna akacjowego. ");
INSERT INTO polubg_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Długość jednej deski ma wynosić dziesięć łokci, a szerokość jednej deski – półtora łokcia. ");
INSERT INTO polubg_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Jedna deska będzie miała dwa czopy, ułożone jeden naprzeciw drugiego. Tak uczynisz przy wszystkich deskach przybytku. ");
INSERT INTO polubg_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Uczynisz więc deski do przybytku: dwadzieścia desek na stronę południową, ku południu. ");
INSERT INTO polubg_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Uczynisz też czterdzieści srebrnych podstawek pod tych dwadzieścia desek; dwie podstawki pod jedną deskę do dwóch jej czopów, także do drugiej deski dwie podstawki do dwóch jej czopów. ");
INSERT INTO polubg_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Na drugim boku przybytku od strony północnej uczynisz dwadzieścia desek. ");
INSERT INTO polubg_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","A do nich czterdzieści srebrnych podstawek: dwie podstawki pod jedną deskę i dwie podstawki pod drugą deskę. ");
INSERT INTO polubg_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","A na zachodnią stronę przybytku uczynisz sześć desek. ");
INSERT INTO polubg_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Uczynisz dwie deski jako narożniki przybytku po obydwu stronach. ");
INSERT INTO polubg_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Będą one złączone od spodu, będą także złączone u góry do jednego pierścienia. Tak będzie przy tych obu, będą dla dwóch narożników. ");
INSERT INTO polubg_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","I tak będzie osiem desek, a ich srebrnych podstawek szesnaście, dwie podstawki pod jedną deską i dwie podstawki pod drugą deską. ");
INSERT INTO polubg_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Uczynisz też drążki z drewna akacjowego: będzie ich pięć do desek jednej strony przybytku; ");
INSERT INTO polubg_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Pięć także drążków do desek drugiej strony przybytku, a także pięć drążków do desek zachodniej strony przybytku. ");
INSERT INTO polubg_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Środkowy drążek w połowie wysokości desek będzie przechodzić od jednego końca do drugiego. ");
INSERT INTO polubg_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Deski pokryjesz złotem i uczynisz do nich złote pierścienie, przez które mają przechodzić drążki. Drążki też pokryjesz złotem. ");
INSERT INTO polubg_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Wystawisz więc przybytek według wzoru, który ci ukazano na górze. ");
INSERT INTO polubg_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Uczynisz też zasłonę z błękitnej tkaniny, purpury, karmazynu i skręconego bisioru; na niej wyhaftujesz cherubiny. ");
INSERT INTO polubg_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","I zawiesisz ją na czterech słupach z drewna akacjowego pokrytych złotem – ich haki też będą złote – stojących na czterech srebrnych podstawkach. ");
INSERT INTO polubg_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","A zasłonę zawiesisz na haczykach i wniesiesz za zasłonę arkę świadectwa, a ta zasłona będzie oddzielać wam Miejsce Święte od Najświętszego. ");
INSERT INTO polubg_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Położysz też przebłagalnię na arce świadectwa w Miejscu Najświętszym. ");
INSERT INTO polubg_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","A przed zasłoną postawisz stół, a naprzeciw stołu, po południowej stronie przybytku – świecznik, a stół postawisz po stronie północnej. ");
INSERT INTO polubg_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Uczynisz też do wejścia namiotu zasłonę z błękitnej tkaniny, purpury, karmazynu i skręconego bisioru, haftowaną. ");
INSERT INTO polubg_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","A do tej zasłony uczynisz pięć słupów z drewna akacjowego, które pokryjesz złotem, i ich haki będą złote. I ulejesz do nich pięć miedzianych podstawek. ");
INSERT INTO polubg_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Uczynisz też ołtarz z drewna akacjowego, długi na pięć łokci i szeroki na pięć łokci. Ołtarz będzie kwadratowy i wysoki na trzy łokcie. ");
INSERT INTO polubg_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","I uczynisz rogi na jego czterech narożnikach; jego rogi będą z tego samego. I pokryjesz go miedzią. ");
INSERT INTO polubg_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Uczynisz też do niego kociołki do zsypywania popiołu oraz szufle, miednice, widełki i łopaty na rozżarzone węgle. Wszystkie naczynia do niego uczynisz z miedzi. ");
INSERT INTO polubg_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Uczynisz też do niego miedzianą kratę na kształt sieci, a na tej kracie, na czterech jej narożnikach, uczynisz cztery miedziane pierścienie. ");
INSERT INTO polubg_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","I umieścisz ją u dołu pod obramowaniem ołtarza, tak aby krata sięgała do połowy ołtarza. ");
INSERT INTO polubg_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Uczynisz też drążki do ołtarza, drążki z drewna akacjowego, i pokryjesz je miedzią. ");
INSERT INTO polubg_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Drążki te będą włożone w pierścienie i będą one na obydwu stronach ołtarza, aby można go było nosić. ");
INSERT INTO polubg_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Uczynisz go z desek, aby był pusty wewnątrz. Niech go uczynią tak, jak ci pokazano na górze. ");
INSERT INTO polubg_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Uczynisz też dziedziniec przybytku. Na południu po prawej stronie zasłony dziedzińca będą ze skręconego bisioru o długości stu łokci na jedną stronę. ");
INSERT INTO polubg_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Do tego dwadzieścia słupów i dwadzieścia miedzianych podstawek. Haczyki na słupach i ich klamry będą ze srebra. ");
INSERT INTO polubg_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Podobnie wzdłuż strony północnej będą zasłony o długości stu łokci, do tego dwadzieścia słupów i dwadzieścia miedzianych podstawek. Haczyki na słupach i ich klamry będą ze srebra. ");
INSERT INTO polubg_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","A na szerokości dziedzińca od strony zachodniej będą zasłony na pięćdziesiąt łokci, a do tego dziesięć słupów i dziesięć podstawek. ");
INSERT INTO polubg_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Szerokość dziedzińca z przodu, po stronie wschodniej, będzie wynosić pięćdziesiąt łokci. ");
INSERT INTO polubg_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Po jednej stronie wejścia będą zasłony na piętnaście łokci, a do tego trzy słupy i trzy podstawki. ");
INSERT INTO polubg_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Po drugiej stronie będą zasłony na piętnaście łokci, a do tego trzy słupy i trzy podstawki. ");
INSERT INTO polubg_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","A do wejścia dziedzińca będzie zasłona na dwadzieścia łokci z błękitnej tkaniny, z purpury i karmazynu oraz skręconego bisioru, haftowana. Do tego cztery słupy i cztery podstawki. ");
INSERT INTO polubg_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Wszystkie słupy dokoła dziedzińca będą miały srebrne klamry. Ich haczyki będą ze srebra, a ich podstawki – z miedzi. ");
INSERT INTO polubg_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Długość dziedzińca będzie wynosić sto łokci, a szerokość – pięćdziesiąt, wszędzie jednakowa, a wysokość – pięć łokci, zasłony będą ze skręconego bisioru, jej podstawki zaś z miedzi. ");
INSERT INTO polubg_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Wszystkie naczynia przybytku do wszelkiej służby w nim i wszystkie jego kołki, i wszystkie kołki dziedzińca będą z miedzi. ");
INSERT INTO polubg_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Rozkażesz synom Izraela, aby przynieśli do ciebie czystą, wytłoczoną oliwę do oświetlenia, aby lampy zawsze się paliły. ");
INSERT INTO polubg_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","W Namiocie Zgromadzenia przed zasłoną, za którą jest arka świadectwa, Aaron i jego synowie będą je stawiać przed PANEM od wieczora aż do poranka. Będzie to wieczna ustawa wśród ich potomków dla synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Przywołaj do siebie twego brata Aarona i wraz z nim jego synów, spośród synów Izraela, aby sprawowali dla mnie urząd kapłański: Aarona, Nadaba i Abihu, Eleazara i Itamara, synów Aarona. ");
INSERT INTO polubg_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Uczynisz święte szaty dla twego brata Aarona, na cześć i na ozdobę. ");
INSERT INTO polubg_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Porozmawiasz też ze wszystkimi zdolnymi rzemieślnikami, których napełniłem duchem mądrości, aby wykonali szaty dla Aarona na jego poświęcenie, aby mi sprawował urząd kapłański. ");
INSERT INTO polubg_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Oto szaty, które wykonają: pektorał, efod, ornat, tunika haftowana, mitra i pas. I uczynią te święte szaty dla twego brata Aarona i jego synów, aby mi sprawowali urząd kapłański. ");
INSERT INTO polubg_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","I wezmą złoto, błękitną tkaninę, purpurę, karmazyn i bisior. ");
INSERT INTO polubg_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","I uczynią efod ze złota, błękitnej tkaniny, purpury, karmazynu i skręconego bisioru, haftowany. ");
INSERT INTO polubg_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Będzie on miał dwa naramienniki zszyte na dwóch końcach i tak będą razem połączone. ");
INSERT INTO polubg_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","A pas, którym będzie przepasany efod, zostanie podobnie uczyniony ze złota, błękitnej tkaniny, purpury, karmazynu i skręconego bisioru. ");
INSERT INTO polubg_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","I weźmiesz dwa kamienie onyksu i wyryjesz na nich imiona synów Izraela; ");
INSERT INTO polubg_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Sześć ich imion na jednym kamieniu i sześć pozostałych imion na drugim kamieniu, według kolejności ich narodzenia. ");
INSERT INTO polubg_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Tak jak rytownik, który wykuwa pieczęć, wyryjesz na obu kamieniach imiona synów Izraela i osadzisz je w złotych oprawach. ");
INSERT INTO polubg_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","I umieścisz te dwa kamienie na naramiennikach efodu jako kamienie pamiątkowe dla synów Izraela. I Aaron będzie nosić ich imiona przed PANEM na obu swych ramionach na pamiątkę. ");
INSERT INTO polubg_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Uczynisz też złote oprawy; ");
INSERT INTO polubg_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","A także dwa łańcuszki ze szczerego złota. Upleciesz je i przymocujesz te plecione łańcuszki do opraw. ");
INSERT INTO polubg_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Uczynisz też pektorał wyrokowania, wyhaftowany, podobnie jak efod. Uczynisz go ze złota, błękitnej tkaniny, purpury, karmazynu i skręconego bisioru. ");
INSERT INTO polubg_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Będzie kwadratowy, złożony we dwoje, na piędź długości i na piędź szerokości. ");
INSERT INTO polubg_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","I uczynisz w nim oprawy dla kamieni, cztery rzędy kamieni, w tym porządku: karneol, topaz i szmaragd w pierwszym rzędzie; ");
INSERT INTO polubg_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","W drugim zaś rzędzie: karbunkuł, szafir i diament; ");
INSERT INTO polubg_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","W trzecim rzędzie: hiacynt, agat i ametyst; ");
INSERT INTO polubg_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","W czwartym rzędzie: beryl, onyks i jaspis. Będą one osadzone w złotych oprawach. ");
INSERT INTO polubg_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","A tych kamieni z imionami synów Izraela będzie dwanaście, według ich imion. Będą ryte jak na pieczęci, każdy z własnym imieniem, według dwunastu pokoleń. ");
INSERT INTO polubg_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Uczynisz do pektorału łańcuszki plecione ze szczerego złota. ");
INSERT INTO polubg_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Do pektorału uczynisz też dwa złote pierścienie i przymocujesz te dwa pierścienie do obu jego rogów. ");
INSERT INTO polubg_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","I przewleczesz dwa złote łańcuszki przez oba pierścienie na rogach pektorału. ");
INSERT INTO polubg_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Drugie zaś końce obu łańcuszków przymocujesz do dwóch opraw i przytwierdzisz z przodu do naramienników efodu. ");
INSERT INTO polubg_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Uczynisz też dwa złote pierścienie, które przymocujesz do dwóch rogów pektorału na wewnętrznym brzegu, który jest od strony efodu. ");
INSERT INTO polubg_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Do tego uczynisz kolejne dwa złote pierścienie, które przymocujesz do dwóch stron efodu u dołu, naprzeciwko jego połączenia, powyżej pasa efodu. ");
INSERT INTO polubg_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Te pierścienie zwiążą pektorał z pierścieniami efodu sznurem z błękitnej tkaniny, aby był nad pasem efodu, żeby pektorał nie odstawał od efodu. ");
INSERT INTO polubg_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","I Aaron będzie nosił imiona synów Izraela na pektorale wyrokowania, na swych piersiach, gdy będzie wchodził do Miejsca Świętego, na wieczną pamiątkę przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Włożysz też do pektorału wyrokowania Urim i Tummim, które będą na sercu Aarona, gdy będzie wchodził przed PANA. I Aaron nieustannie będzie nosił na sercu przed PANEM sąd synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Uczynisz też ornat pod efod, cały z błękitnej tkaniny. ");
INSERT INTO polubg_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","A na wierzchu w środku będzie miał otwór. Dokoła otworu będzie pleciona obwódka na wzór pancerza, aby się nie rozdzierał. ");
INSERT INTO polubg_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Uczynisz też u jego dołu jabłka granatu z błękitnej tkaniny, purpury i karmazynu dokoła brzegu, a między nimi dokoła złote dzwonki; ");
INSERT INTO polubg_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Złoty dzwonek i jabłko granatu i znowu złoty dzwonek i jabłko granatu, dokoła dolnego brzegu ornatu. ");
INSERT INTO polubg_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","I Aaron będzie to miał na sobie podczas służby, aby słychać było jego dźwięk, gdy będzie wchodził do Miejsca Świętego przed PANA i gdy będzie wychodzić, żeby nie umarł. ");
INSERT INTO polubg_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Uczynisz też blaszkę ze szczerego złota, a na niej wyryjesz jak na pieczęci: Świętość PANU. ");
INSERT INTO polubg_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Przymocujesz ją do sznura z błękitnej tkaniny i będzie na mitrze, będzie na przodzie mitry. ");
INSERT INTO polubg_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","I będzie na czole Aarona, aby nosił Aaron nieprawość poświęconych rzeczy, które synowie Izraela poświęcać będą przy wszystkich świętych darach. Będzie nieustannie na jego czole, aby im zjednał łaskę u PANA. ");
INSERT INTO polubg_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Utkasz tunikę z bisioru, mitrę także uczynisz z bisioru, wyhaftujesz też pas. ");
INSERT INTO polubg_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Również dla synów Aarona wykonasz szaty, też pasy i mitry uczynisz im na cześć i na ozdobę. ");
INSERT INTO polubg_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","I ubierzesz w nie twego brata Aarona i wraz z nim jego synów. Namaścisz ich, poświęcisz i uświęcisz, aby mi sprawowali urząd kapłański. ");
INSERT INTO polubg_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Wykonasz im też lniane spodnie dla zakrycia nagości ciała. Będą od bioder aż po uda. ");
INSERT INTO polubg_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","A będą one na Aaronie i na jego synach, gdy będą wchodzić do Namiotu Zgromadzenia lub gdy będą przystępować do ołtarza, aby służyć w Miejscu Świętym, aby nie ściągnęli na siebie winy i nie pomarli. Będzie to wieczna ustawa dla niego i jego potomstwa po nim. ");
INSERT INTO polubg_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Oto co masz uczynić, aby poświęcić ich do sprawowania mi urzędu kapłańskiego: Weź jednego młodego cielca i dwa barany bez skazy; ");
INSERT INTO polubg_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","I przaśne chleby, przaśne placki zaprawione oliwą i przaśne podpłomyki posmarowane oliwą. Uczynisz je z wybornej mąki pszennej. ");
INSERT INTO polubg_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Włożysz je do jednego kosza i przyniesiesz je w tym koszu z cielcem i z dwoma baranami. ");
INSERT INTO polubg_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Aaronowi i jego synom każesz zbliżyć się do wejścia do Namiotu Zgromadzenia i obmyjesz ich wodą. ");
INSERT INTO polubg_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Potem weźmiesz szaty i ubierzesz Aarona w tunikę, w ornat pod efod, w efod i pektorał i opaszesz go pasem efodu; ");
INSERT INTO polubg_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","I włożysz mu na głowę mitrę, a na mitrę wstawisz świętą koronę. ");
INSERT INTO polubg_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Następnie weźmiesz olejek do namaszczenia i wylejesz na jego głowę, i namaścisz go. ");
INSERT INTO polubg_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Potem każesz się przybliżyć jego synom i ubierzesz ich w szaty; ");
INSERT INTO polubg_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","I przepaszesz ich pasem, Aarona i jego synów, i włożysz na nich mitry, i będzie do nich należało kapłaństwo na mocy wiecznej ustawy. Poświęcisz też Aarona i jego synów. ");
INSERT INTO polubg_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Przyprowadzisz też cielca przed Namiot Zgromadzenia i Aaron oraz jego synowie włożą swoje ręce na głowę cielca. ");
INSERT INTO polubg_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","I zabijesz cielca przed PANEM u wejścia do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Potem weźmiesz krew cielca i pomażesz swym palcem rogi ołtarza, a resztkę krwi wylejesz u podnóża ołtarza. ");
INSERT INTO polubg_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Weźmiesz też cały tłuszcz okrywający wnętrzności, płat wątroby i obie nerki z tłuszczem na nich i spalisz to na ołtarzu. ");
INSERT INTO polubg_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","A mięso cielca, jego skórę i jego odchody spalisz w ogniu za obozem, bo to jest ofiara za grzech. ");
INSERT INTO polubg_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Weźmiesz także jednego barana, na którego głowę Aaron i jego synowie włożą swoje ręce. ");
INSERT INTO polubg_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Następnie zabijesz tego barana i weźmiesz jego krew, i pokropisz dokoła wierzch ołtarza. ");
INSERT INTO polubg_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Barana porąbiesz na części, opłuczesz jego trzewia i nogi i położysz je na jego częściach i na jego głowie. ");
INSERT INTO polubg_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","I spalisz całego tego barana na ołtarzu. Jest to całopalenie dla PANA, miła woń, ofiara spalona dla PANA. ");
INSERT INTO polubg_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Potem weźmiesz drugiego barana, a Aaron i jego synowie włożą swoje ręce na głowę barana. ");
INSERT INTO polubg_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Wtedy zabijesz tego barana, weźmiesz nieco z jego krwi i posmarujesz koniec ucha Aarona, końce prawych uszu jego synów i wielkie palce ich prawych rąk, także wielkie palce ich prawych stóp, i pokropisz tą krwią ołtarz dokoła. ");
INSERT INTO polubg_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Weźmiesz też nieco z krwi, która jest na ołtarzu, także z olejku do namaszczenia, i pokropisz Aarona, jego szaty oraz jego synów i szaty jego synów wraz z nim. Tak zostanie poświęcony on i jego szaty, a wraz z nim jego synowie i szaty jego synów. ");
INSERT INTO polubg_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Potem weźmiesz z barana łój, ogon, tłuszcz okrywający wnętrzności, płat wątroby, obie nerki, łój, który jest na nich, i prawą łopatkę, bo to jest baran poświęcenia; ");
INSERT INTO polubg_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","I jeden bochen chleba, jeden placek chlebowy na oliwie i jeden podpłomyk z kosza przaśników, który jest przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","To wszystko położysz na ręce Aarona i na ręce jego synów i będziesz tym kołysać jako ofiarą kołysania przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Potem weźmiesz to z ich rąk i spalisz na ołtarzu jako całopalenie, na miłą woń przed PANEM. Jest to ofiara spalona dla PANA. ");
INSERT INTO polubg_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Weźmiesz też pierś barana poświęcenia Aarona i będziesz ją kołysać jako ofiarą kołysania przed PANEM. A to będzie twój dział. ");
INSERT INTO polubg_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Poświęcisz też pierś kołysania i łopatkę wzniesienia, którą kołysano i którą wznoszono, z barana poświęcenia dla Aarona i dla jego synów. ");
INSERT INTO polubg_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","A będzie to dla Aarona i jego synów od synów Izraela na mocy wiecznej ustawy, gdyż jest to ofiara wzniesienia. Ofiara wzniesienia będzie wzięta od synów Izraela z ich ofiar pojednawczych. To będzie ich ofiara wzniesienia dla PANA. ");
INSERT INTO polubg_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","A święte szaty Aarona będą należeć po nim do jego synów, aby byli w nich namaszczeni i poświęceni. ");
INSERT INTO polubg_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Siedem dni będzie w nich chodził kapłan, jego syn, który zajmie jego miejsce, gdy będzie wchodził do Namiotu Zgromadzenia, aby służyć w Miejscu Świętym. ");
INSERT INTO polubg_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Weźmiesz też barana poświęcenia i ugotujesz jego mięso w miejscu świętym. ");
INSERT INTO polubg_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron i jego synowie będą jeść mięso tego barana i chleb, który jest w koszu, przy wejściu do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Będą jeść to, czym dokonano przebłagania, gdy ich poświęcono i uświęcono. Obcy zaś nie będzie z tego jadł, bo jest to rzecz święta. ");
INSERT INTO polubg_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","A jeśli zostałoby coś z mięsa poświęcenia lub z chleba aż do poranka, spalisz resztki w ogniu. Nie wolno tego jeść, bo jest to rzecz święta. ");
INSERT INTO polubg_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Tak więc postąpisz z Aaronem i jego synami według wszystkiego, co ci przykazałem. Przez siedem dni będziesz ich poświęcać. ");
INSERT INTO polubg_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Każdego dnia złożysz cielca na ofiarę za grzech dla przebłagania. Oczyścisz ołtarz, dokonując na nim przebłagania, i namaścisz go, aby go poświęcić. ");
INSERT INTO polubg_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Siedem dni będziesz dokonywał przebłagania za ołtarz i poświęcisz go, i będzie to ołtarz najświętszy. Ktokolwiek dotknie się ołtarza, musi być poświęcony. ");
INSERT INTO polubg_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Oto co masz składać na ołtarzu: dwa roczne baranki, codziennie i ustawicznie. ");
INSERT INTO polubg_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Jednego baranka złożysz w ofierze rano, a drugiego baranka złożysz w ofierze wieczorem; ");
INSERT INTO polubg_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","I wraz z pierwszym barankiem dziesiątą część efy mąki pszennej zmieszanej z czwartą częścią hinu wytłoczonej oliwy, a na ofiarę z płynów czwartą część hinu wina. ");
INSERT INTO polubg_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","A drugiego baranka złożysz w ofierze wieczorem według obrzędu porannej ofiary i według ofiary z płynów, jako miłą woń i spaloną ofiarę dla PANA. ");
INSERT INTO polubg_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","To będzie nieustanne całopalenie przez wszystkie pokolenia u wejścia do Namiotu Zgromadzenia przed PANEM, gdzie będę się z wami spotykać, aby tam z tobą rozmawiać. ");
INSERT INTO polubg_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Tam też będę się spotykać z synami Izraela i to miejsce zostanie poświęcone moją chwałą. ");
INSERT INTO polubg_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Bo poświęcę Namiot Zgromadzenia i ołtarz, poświęcę też Aarona i jego synów, aby mi sprawowali urząd kapłański. ");
INSERT INTO polubg_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","I będę mieszkał pośród synów Izraela, i będę ich Bogiem. ");
INSERT INTO polubg_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","I poznają, że ja jestem PAN, ich Bóg, który wyprowadził ich z ziemi Egiptu, aby mieszkać pośród nich, ja, PAN, ich Bóg. ");
INSERT INTO polubg_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Uczynisz też ołtarz do spalania kadzidła. Uczynisz go z drewna akacjowego. ");
INSERT INTO polubg_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Na łokieć długi i na łokieć szeroki, będzie kwadratowy, na dwa łokcie wysoki. Jego rogi będą z tego samego. ");
INSERT INTO polubg_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Pokryjesz go szczerym złotem, jego wierzch i ściany wokoło oraz rogi. Uczynisz też dokoła niego złotą listwę. ");
INSERT INTO polubg_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Pod listwą, na dwóch jego narożnikach, po obu jego stronach, uczynisz też dwa złote pierścienie, a przez nie przewleczesz drążki, aby był na nich noszony. ");
INSERT INTO polubg_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Drążki te uczynisz z drewna akacjowego i pokryjesz je złotem. ");
INSERT INTO polubg_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Następnie postawisz go przed zasłoną, za którą jest arka świadectwa, przed przebłagalnią, która jest nad świadectwem, gdzie będę się z tobą spotykać. ");
INSERT INTO polubg_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","I każdego poranka Aaron będzie spalał na nim wonne kadzidło. Gdy będzie przygotowywał lampy, będzie je spalał. ");
INSERT INTO polubg_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Także wieczorem, gdy Aaron rozpali lampy, będzie spalał kadzidło, będzie to ustawiczne kadzenie przed PANEM przez wszystkie wasze pokolenia. ");
INSERT INTO polubg_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Nie składajcie na nim obcego kadzidła ani całopalenia, ani ofiary pokarmowej, nie będziecie też na nim składać ofiary z płynów. ");
INSERT INTO polubg_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Tylko raz do roku Aaron dokona na jego rogach przebłagania krwią z ofiary na przebłaganie grzechu. Raz do roku odprawi przebłaganie na nim przez wszystkie wasze pokolenia. Będzie to najświętsza rzecz dla PANA. ");
INSERT INTO polubg_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Gdy przeliczysz synów Izraela podlegających spisowi, każdy da PANU okup za swą duszę podczas spisu, aby nie dotknęła ich plaga, gdy będą zliczeni. ");
INSERT INTO polubg_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","To będzie dawać każdy, kto podlega spisowi: pół sykla według sykla świątynnego – sykl to dwadzieścia ger. Pół sykla wyniesie więc ofiara dla PANA. ");
INSERT INTO polubg_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Każdy podległy spisowi, od dwudziestego roku życia wzwyż, odda PANU ofiarę. ");
INSERT INTO polubg_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Bogaty nie da więcej, a ubogi nie da mniej niż pół sykla, gdy będą dawać PANU ofiarę na przebłaganie za swoje dusze. ");
INSERT INTO polubg_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","A weźmiesz pieniądze przebłagania od synów Izraela i dasz je na służbę Namiotu Zgromadzenia. Będzie to dla synów Izraela pamiątką przed PANEM, na przebłaganie za wasze dusze. ");
INSERT INTO polubg_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Uczynisz też miedzianą kadź do obmywania i do niej miedzianą podstawę i postawisz ją między Namiotem Zgromadzenia a ołtarzem, i nalejesz do niej wody. ");
INSERT INTO polubg_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaron i jego synowie będą w niej obmywać swoje ręce i nogi. ");
INSERT INTO polubg_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Gdy będą wchodzić do Namiotu Zgromadzenia, obmyją się wodą, aby nie pomarli. Podobnie gdy będą przystępować do ołtarza, aby służyć i spalać ofiarę ogniową dla PANA; ");
INSERT INTO polubg_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Obmyją swoje ręce i nogi, aby nie pomarli. Będzie to dla nich wieczną ustawą, dla niego i jego potomstwa, przez wszystkie ich pokolenia. ");
INSERT INTO polubg_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","PAN powiedział jeszcze do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Weź sobie też najlepsze wonności: pięćset syklów najczystszej mirry, połowę tego, czyli dwieście pięćdziesiąt syklów, wonnego cynamonu i dwieście pięćdziesiąt syklów ziela tataraku; ");
INSERT INTO polubg_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Pięćset syklów kasji według sykla świątynnego i hin oliwy z oliwek. ");
INSERT INTO polubg_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Uczynisz z tego święty olejek do namaszczenia, wyborną maść, dzieło zielarza. Będzie to święty olejek do namaszczenia. ");
INSERT INTO polubg_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Namaścisz nim Namiot Zgromadzenia i arkę świadectwa; ");
INSERT INTO polubg_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","I stół wraz ze wszystkimi jego naczyniami, świecznik i jego przybory oraz ołtarz kadzenia; ");
INSERT INTO polubg_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Ołtarz do całopalenia ze wszystkimi jego naczyniami i kadź z jej podstawą. ");
INSERT INTO polubg_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","I poświęcisz je, aby stały się najświętsze. Ktokolwiek się ich dotknie, musi być poświęcony. ");
INSERT INTO polubg_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Namaścisz też Aarona i jego synów i poświęcisz ich, aby mi sprawowali urząd kapłański. ");
INSERT INTO polubg_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Synom Izraela powiesz: To będzie dla mnie świętym olejkiem namaszczenia przez wszystkie wasze pokolenia; ");
INSERT INTO polubg_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Nie wolno go wylewać na ciało człowieka i nie wolno sporządzić innego o podobnym składzie, bo jest święty i dla was będzie święty. ");
INSERT INTO polubg_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ktokolwiek sporządzi podobny i namaści nim kogoś obcego, będzie wykluczony ze swego ludu. ");
INSERT INTO polubg_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","I PAN powiedział do Mojżesza: Weź sobie wonności: balsam, onychę, wonne galbanum i czyste kadzidło, wszystko o takiej samej wadze; ");
INSERT INTO polubg_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","I uczynisz z tego wonne kadzidło, dzieło zielarza, dobrze mieszane, czyste i święte. ");
INSERT INTO polubg_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Część z niego zetrzesz na proszek i będziesz go kłaść przed świadectwem w Namiocie Zgromadzenia, gdzie będę się z tobą spotykać. Będzie to najświętsze. ");
INSERT INTO polubg_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Kadzideł, które sporządzicie według tego składu, nie sporządzicie dla siebie. Będzie to święte dla PANA. ");
INSERT INTO polubg_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ktokolwiek by uczynił coś podobnego, aby rozkoszować się jego wonią, będzie wykluczony ze swego ludu. ");
INSERT INTO polubg_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Oto powołałem po imieniu Besalela, syna Uriego, syna Chura, z pokolenia Judy; ");
INSERT INTO polubg_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","I napełniłem go Duchem Bożym, mądrością, rozumem, wiedzą i znajomością we wszelkim rzemiośle; ");
INSERT INTO polubg_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Aby umiejętnie obmyślał projekty, do wyrobu ze złota, srebra i miedzi; ");
INSERT INTO polubg_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Do obrabiania kamieni do oprawy i do ciosania drewna, aby wykonał wszelkie rodzaje dzieła. ");
INSERT INTO polubg_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Oto dałem mu Oholiaba, syna Achisamaka, z pokolenia Dana. Wlałem też mądrość w serce każdego uzdolnionego, aby uczynili wszystko, co ci przykazałem: ");
INSERT INTO polubg_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Namiot Zgromadzenia, arkę świadectwa, przebłagalnię, która ma być nad nią, i wszystkie sprzęty namiotu; ");
INSERT INTO polubg_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Stół i naczynia do niego, szczerozłoty świecznik ze wszystkimi naczyniami do niego i ołtarz kadzenia; ");
INSERT INTO polubg_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Ołtarz całopalenia ze wszystkimi naczyniami do niego i kadź wraz z jej podstawą; ");
INSERT INTO polubg_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Szaty do służby, święte szaty dla Aarona, kapłana, i szaty dla jego synów do sprawowania kapłaństwa; ");
INSERT INTO polubg_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Olejek namaszczenia i wonne kadzidło do Miejsca Świętego. Wykonają według wszystkiego, co ci przykazałem. ");
INSERT INTO polubg_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Powiedz też synom Izraela: Koniecznie macie przestrzegać moich szabatów, bo to jest znak między mną a wami przez wszystkie wasze pokolenia, abyście wiedzieli, że ja jestem PAN, który was uświęca. ");
INSERT INTO polubg_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Przestrzegajcie więc szabatu, gdyż jest on dla was święty. Kto by go naruszył, poniesie śmierć. Każdy bowiem, kto wykonuje pracę w tym dniu, zostanie wytracony spośród swego ludu. ");
INSERT INTO polubg_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Przez sześć dni będzie się wykonywać pracę, ale siódmy dzień jest szabatem odpoczynku, świętym dla PANA. Ktokolwiek wykona pracę w dniu szabatu, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Dlatego synowie Izraela będą przestrzegać szabatu, zachowując szabat przez wszystkie pokolenia jako wieczną ustawę. ");
INSERT INTO polubg_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Jest on wiecznym znakiem między mną a synami Izraela, bo w sześć dni PAN uczynił niebo i ziemię, a siódmego dnia przestał i odpoczął. ");
INSERT INTO polubg_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","A gdy dokończył rozmowę z Mojżeszem na górze Synaj, PAN dał mu dwie tablice świadectwa, tablice kamienne napisane palcem Boga. ");
INSERT INTO polubg_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","A gdy lud widział, że Mojżesz opóźnia swoje zejście z góry, zebrał się przed Aaronem i mówił do niego: Wstań, zrób nam bogów, którzy by szli przed nami, bo nie wiemy, co się stało z Mojżeszem, tym mężem, który nas wyprowadził z ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Wtedy Aaron im powiedział: Zdejmijcie złote kolczyki, które są w uszach waszych żon, waszych synów i córek, i przynieście do mnie. ");
INSERT INTO polubg_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","I cały lud pozdejmował złote kolczyki, które były w ich uszach, i zanieśli je do Aarona. ");
INSERT INTO polubg_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Gdy on przyjął je z ich rąk, ukształtował je rylcem i uczynił z nich odlanego cielca. I powiedzieli: Oto są twoi bogowie, Izraelu, którzy cię wyprowadzili z ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Widząc to, Aaron zbudował przed nim ołtarz i zawołał: Jutro będzie święto PANA. ");
INSERT INTO polubg_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","A nazajutrz wstali wcześnie rano, ofiarowali całopalenia i przynieśli ofiary pojednawcze. I lud usiadł, aby jeść i pić, i wstał, aby się bawić. ");
INSERT INTO polubg_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Wtedy PAN powiedział do Mojżesza: Idź, zejdź na dół, bo zepsuł się twój lud, który wyprowadziłeś z ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Szybko zboczyli z drogi, którą im przykazałem. Zrobili sobie odlanego cielca, oddali mu pokłon i złożyli mu ofiary, mówiąc: Oto są twoi bogowie, Izraelu, którzy cię wyprowadzili z ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","PAN mówił dalej do Mojżesza: Widziałem ten lud, a oto jest on ludem twardego karku. ");
INSERT INTO polubg_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Teraz więc zostaw mnie, aby się rozpalił mój gniew na nich i abym ich zgładził, a z ciebie uczynię wielki naród. ");
INSERT INTO polubg_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","I Mojżesz modlił się do PANA, swego Boga, i powiedział: Dlaczego, PANIE, rozpala się twój gniew przeciwko twemu ludowi, który wyprowadziłeś z ziemi Egiptu wielką mocą i potężną ręką? ");
INSERT INTO polubg_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Dlaczego Egipcjanie mieliby mówić: Wyprowadził ich ku złemu, aby ich pozabijać w górach i aby zgładzić ich z powierzchni ziemi? Odwróć się od zapalczywości twojego gniewu i żałuj nieszczęścia, jakie chcesz zesłać na twój lud. ");
INSERT INTO polubg_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Wspomnij na Abrahama, Izaaka i Izraela, twoje sługi, którym przysiągłeś na samego siebie i mówiłeś do nich: Rozmnożę wasze potomstwo jak gwiazdy na niebie i całą tę ziemię, o której mówiłem, dam waszemu potomstwu i odziedziczą ją na wieki. ");
INSERT INTO polubg_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","I PAN żałował nieszczęścia, które miał zesłać na swój lud. ");
INSERT INTO polubg_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mojżesz odwrócił się więc i zszedł z góry, mając w ręku dwie tablice świadectwa, tablice zapisane po obu stronach. Były zapisane i na jednej, i na drugiej stronie. ");
INSERT INTO polubg_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Tablice te były dziełem Boga, a pismo też było pismem Boga wyrytym na tablicach. ");
INSERT INTO polubg_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Gdy Jozue usłyszał głos wołającego ludu, powiedział do Mojżesza: Odgłosy bitwy w obozie. ");
INSERT INTO polubg_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","On odpowiedział: Nie jest to głos zwyciężających ani głos pokonanych. Słyszę raczej głos śpiewających. ");
INSERT INTO polubg_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Gdy się przybliżył do obozu, zobaczył cielca i tańce. Mojżesz wówczas rozgniewał się bardzo, rzucił z rąk tablice i stłukł je pod górą. ");
INSERT INTO polubg_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Wziął też cielca, którego zrobili, spalił go w ogniu, skruszył na proch, wysypał na wodę i kazał ją pić synom Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Potem Mojżesz powiedział do Aarona: Cóż ci ten lud zrobił, że sprowadziłeś na niego tak wielki grzech? ");
INSERT INTO polubg_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron odpowiedział: Niech się nie rozpala gniew mego pana. Ty znasz ten lud i wiesz, jak jest skłonny do zła. ");
INSERT INTO polubg_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Mówili mi bowiem: Zrób nam bogów, którzy by szli przed nami, gdyż nie wiemy, co się stało z Mojżeszem, tym mężem, który nas wyprowadził z ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","I odpowiedziałem im: Kto ma złoto, niech je zdejmie z siebie. Dali mi je i wrzuciłem je w ogień, i tak powstał ten cielec. ");
INSERT INTO polubg_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Gdy Mojżesz widział obnażony lud, bo Aaron uczynił go nagim ku jego hańbie wobec jego wrogów; ");
INSERT INTO polubg_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Wtedy Mojżesz stanął w bramie obozu i powiedział: Kto jest za PANEM, niech przystąpi do mnie. I zebrali się przy nim wszyscy synowie Lewiego. ");
INSERT INTO polubg_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","I powiedział do nich: Tak mówi PAN, Bóg Izraela: Niech każdy przypasze swój miecz do swojego boku. Przejdźcie przez obóz tam i z powrotem, od jednej bramy do drugiej, i zabijajcie każdy swego brata i każdy swego przyjaciela, i każdy swego bliźniego. ");
INSERT INTO polubg_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","I synowie Lewiego postąpili według słowa Mojżesza. Tego dnia poległo z ludu około trzech tysięcy mężczyzn. ");
INSERT INTO polubg_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Bo Mojżesz powiedział: Poświęćcie dziś PANU swoje ręce, każdy na swego syna i na swego brata, aby dał wam dziś błogosławieństwo. ");
INSERT INTO polubg_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Nazajutrz zaś Mojżesz powiedział do ludu: Popełniliście wielki grzech. Wstąpię teraz do PANA, może go przebłagam za wasz grzech. ");
INSERT INTO polubg_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mojżesz więc wrócił do PANA i powiedział: Proszę, ten lud popełnił wielki grzech, bo zrobił sobie bogów ze złota. ");
INSERT INTO polubg_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Teraz jednak przebacz ich grzech, a jeśli nie, wymaż mnie, proszę, z twojej księgi, którą napisałeś. ");
INSERT INTO polubg_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","PAN powiedział do Mojżesza: Tego wymażę z mojej księgi, kto zgrzeszył przeciwko mnie. ");
INSERT INTO polubg_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Idź teraz, prowadź ten lud, gdzie ci rozkazałem. Oto mój Anioł pójdzie przed tobą. Ale w dniu mego nawiedzenia ich też nawiedzę za ich grzech. ");
INSERT INTO polubg_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","PAN ukarał więc lud za to, że zrobił cielca, którego sporządził Aaron. ");
INSERT INTO polubg_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Potem PAN mówił do Mojżesza: Idź, wyrusz stąd, ty i lud, który wyprowadziłeś z ziemi Egiptu, do ziemi, którą przysiągłem Abrahamowi, Izaakowi i Jakubowi, mówiąc: Dam ją twemu potomstwu. ");
INSERT INTO polubg_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Poślę przed tobą Anioła i wyrzucę Kananejczyka, Amorytę, Chetytę, Peryzzytę, Chiwwitę i Jebusytę; ");
INSERT INTO polubg_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Do ziemi opływającej mlekiem i miodem. Lecz sam nie pójdę z tobą, bo jesteś ludem twardego karku, bym cię w drodze nie wytracił. ");
INSERT INTO polubg_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Gdy lud usłyszał te złe wieści, zasmucił się i nikt nie włożył na siebie swoich ozdób. ");
INSERT INTO polubg_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","PAN bowiem powiedział do Mojżesza: Powiedz synom Izraela: Jesteście ludem twardego karku. Przyjdę niespodziewanie pośród ciebie i wytracę cię. Teraz więc zdejmij z siebie swoje ozdoby, abym wiedział, co mam ci uczynić. ");
INSERT INTO polubg_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","I synowie Izraela zdjęli swoje ozdoby przy górze Horeb. ");
INSERT INTO polubg_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","A Mojżesz wziął namiot i rozbił go poza obozem, z dala od obozu, i nazwał go Namiotem Zgromadzenia. Każdy, kto chciał się poradzić PANA, wychodził do Namiotu Zgromadzenia, który był poza obozem. ");
INSERT INTO polubg_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","A gdy Mojżesz wychodził do namiotu, cały lud powstawał i każdy stał u wejścia do swego namiotu, i patrzył na Mojżesza, aż wszedł do namiotu. ");
INSERT INTO polubg_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Gdy Mojżesz wchodził do namiotu, słup obłoku zstępował i stawał u wejścia do namiotu, i PAN rozmawiał z Mojżeszem. ");
INSERT INTO polubg_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","A cały lud widział słup obłoku stojący u wejścia do namiotu. Wtedy cały lud powstawał i oddawał pokłon, każdy u wejścia do swego namiotu. ");
INSERT INTO polubg_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","I PAN rozmawiał z Mojżeszem twarzą w twarz, jak człowiek rozmawia ze swoim przyjacielem. Potem Mojżesz wracał do obozu, a jego sługa Jozue, syn Nuna, młodzieniec, nie opuszczał namiotu. ");
INSERT INTO polubg_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","I Mojżesz powiedział do PANA: Oto mówisz mi: Prowadź ten lud, a nie oznajmiłeś mi, kogo poślesz ze mną. Ponadto powiedziałeś: Znam cię po imieniu, znalazłeś też łaskę w moich oczach. ");
INSERT INTO polubg_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Teraz więc, jeśli znalazłem łaskę w twoich oczach, ukaż mi, proszę, twoją drogę, żebym cię poznał i żebym znalazł łaskę w twoich oczach. Zważ także, że ten naród jest twoim ludem. ");
INSERT INTO polubg_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","I PAN odpowiedział: Moje oblicze pójdzie przed tobą i dam ci odpoczynek. ");
INSERT INTO polubg_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mojżesz powiedział do niego: Jeśli twoje oblicze nie pójdzie z nami, nie wyprowadzaj nas stąd. ");
INSERT INTO polubg_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Po czym bowiem będzie można poznać, że ja i twój lud znaleźliśmy łaskę w twoich oczach? Czy nie po tym, że pójdziesz z nami? W ten sposób ja i twój lud będziemy wyróżnieni spośród wszystkich ludów, które są na ziemi. ");
INSERT INTO polubg_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","I PAN powiedział do Mojżesza: Uczynię także to, o czym mówiłeś, bo znalazłeś łaskę w moich oczach i znam cię po imieniu. ");
INSERT INTO polubg_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mojżesz powiedział też: Ukaż mi, proszę, twoją chwałę. ");
INSERT INTO polubg_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","A on odpowiedział: Sprawię, że cała moja dobroć przejdzie przed twoją twarzą, i wypowiem imię PANA przed tobą. Zmiłuję się, nad kim się zmiłuję, i zlituję się, nad kim się zlituję. ");
INSERT INTO polubg_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","I dodał: Nie będziesz mógł widzieć mego oblicza, bo nie może człowiek ujrzeć mnie i pozostać przy życiu. ");
INSERT INTO polubg_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","PAN mówił dalej: Oto miejsce przy mnie, staniesz na skale. ");
INSERT INTO polubg_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","A gdy będzie przechodzić moja chwała, postawię cię w rozpadlinie skalnej i zakryję cię swoją dłonią, aż przejdę. ");
INSERT INTO polubg_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Potem odejmę dłoń i ujrzysz mnie od tyłu, ale moje oblicze nie będzie widziane. ");
INSERT INTO polubg_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","I PAN powiedział do Mojżesza: Wyciosaj sobie dwie kamienne tablice, podobne do pierwszych, a napiszę na tych tablicach słowa, które były na pierwszych tablicach, które stłukłeś. ");
INSERT INTO polubg_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","A bądź gotów jutro rano i wstąp rankiem na górę Synaj; staniesz przede mną na szczycie tej góry. ");
INSERT INTO polubg_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ale niech nikt nie wchodzi z tobą, niech nikt też nie będzie widziany na całej górze; również owce i woły niech się nie pasą naprzeciwko tej góry. ");
INSERT INTO polubg_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mojżesz wyciosał więc dwie kamienne tablice podobne do pierwszych, a gdy wstał rano, wstąpił na górę Synaj, jak PAN mu rozkazał, i wziął w ręce dwie kamienne tablice. ");
INSERT INTO polubg_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","I PAN zstąpił w obłoku, stanął tam z nim, i wypowiedział imię PANA. ");
INSERT INTO polubg_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Wtedy przechodził PAN przed nim i wołał: PAN, PAN, Bóg miłosierny i litościwy, nieskory do gniewu, a bogaty w miłosierdzie i prawdę; ");
INSERT INTO polubg_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Zachowujący miłosierdzie nad tysiącami, przebaczający nieprawość, przestępstwo i grzech, lecz nieusprawiedliwiający winnego, nawiedzający nieprawość ojców na synach i na synach ich synów do trzeciego i czwartego pokolenia. ");
INSERT INTO polubg_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mojżesz więc spiesznie pochylił się do ziemi i oddał pokłon; ");
INSERT INTO polubg_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","I powiedział: Jeśli znalazłem teraz łaskę w twoich oczach, Panie, niech Pan idzie, proszę, pośród nas, bo ten lud jest twardego karku. Wybacz nasze nieprawości i nasz grzech, a weź nas za dziedzictwo. ");
INSERT INTO polubg_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Odpowiedział: Oto ustanowię przymierze. Przed całym twoim ludem będę czynił cuda, jakie nie były dokonane na całej ziemi i w żadnym narodzie. I cały lud, wśród którego przebywasz, zobaczy dzieło PANA, gdyż straszne będzie to, co uczynię z tobą. ");
INSERT INTO polubg_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Przestrzegaj tego, co dziś ci rozkazuję: Oto wypędzę sprzed twojego oblicza Amorytę, Kananejczyka, Chetytę, Peryzzytę, Chiwwitę i Jebusytę. ");
INSERT INTO polubg_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Strzeż się, abyś nie zawarł przymierza z obywatelami tej ziemi, do której wejdziesz, żeby to nie było sidłem pośród ciebie. ");
INSERT INTO polubg_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Dlatego zburzycie ich ołtarze, połamiecie ich bożki i wyrąbiecie ich święte gaje. ");
INSERT INTO polubg_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Nie będziesz oddawał pokłonu innemu bogu, bo PAN, którego imię jest Zazdrosny, jest Bogiem zazdrosnym; ");
INSERT INTO polubg_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Abyś nie zawierał przymierza z mieszkańcami tej ziemi, abyś – gdy oni popełniają nierząd ze swymi bogami i składają ofiary swym bogom – nie został zawołany, by jeść z ich ofiar; ");
INSERT INTO polubg_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","I nie brał spośród ich córek żony dla swych synów, a wtedy cudzołożyłyby ich córki ze swymi bogami i doprowadziłyby twoich synów do nierządu ze swymi bogami. ");
INSERT INTO polubg_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Nie będziesz czynił sobie odlewanych bożków. ");
INSERT INTO polubg_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Będziesz zachowywał Święto Przaśników. Przez siedem dni będziesz jeść przaśniki, jak ci rozkazałem, w miesiącu Abib, gdyż w miesiącu Abib wyszedłeś z Egiptu. ");
INSERT INTO polubg_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Wszystko, co otwiera łono, jest moje, a także każdy pierworodny samiec z twego dobytku, zarówno spośród owiec, jak i wołów; ");
INSERT INTO polubg_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ale pierworodne oślę odkupisz owcą, a jeśli go nie odkupisz, złamiesz mu kark. Odkupisz każdego pierworodnego z twych synów i nie pokażą się przede mną z pustymi rękami. ");
INSERT INTO polubg_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Sześć dni będziesz pracować, a siódmego dnia odpoczniesz; odpoczniesz w czasie orania i w czasie żniwa. ");
INSERT INTO polubg_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Będziesz obchodził też Święto Tygodni, pierwociny żniwa pszenicy, i Święto Zbiorów na koniec roku. ");
INSERT INTO polubg_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Trzy razy do roku wszyscy twoi mężczyźni pokażą się przed obliczem Pana BOGA, Boga Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Bo wypędzę przed tobą narody i rozszerzę twoje granice; nikt nie będzie pożądał twojej ziemi, gdy trzy razy do roku pójdziesz, aby pokazać się przed obliczem PANA, twego Boga. ");
INSERT INTO polubg_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Nie będziesz składał krwi mojej ofiary razem z zakwasem i nic z ofiary obchodu święta Paschy nie zostanie do rana. ");
INSERT INTO polubg_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Przyniesiesz do domu PANA, twego Boga, pierwociny plonów twej ziemi. Nie będziesz gotował koźlęcia w mleku jego matki. ");
INSERT INTO polubg_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Potem PAN powiedział do Mojżesza: Zapisz sobie te słowa, bo według tych słów ustanowiłem przymierze z tobą i Izraelem. ");
INSERT INTO polubg_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","I był tam z PANEM czterdzieści dni i czterdzieści nocy, nie jadł chleba i nie pił wody. I PAN napisał na tablicach słowa przymierza, dziesięć przykazań. ");
INSERT INTO polubg_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","I gdy Mojżesz zstępował z góry Synaj – a miał Mojżesz w ręku dwie tablice świadectwa, gdy zstępował z góry – Mojżesz nie wiedział, że skóra jego twarzy lśniła, gdy PAN z nim rozmawiał. ");
INSERT INTO polubg_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaron i wszyscy synowie Izraela zobaczyli Mojżesza, a oto skóra jego twarzy lśniła, i bali się zbliżyć do niego. ");
INSERT INTO polubg_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ale Mojżesz zawołał ich i Aaron oraz wszyscy przywódcy zgromadzenia Izraela wrócili do niego. I Mojżesz rozmawiał z nimi. ");
INSERT INTO polubg_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Potem podeszli też wszyscy synowie Izraela, a on przykazał im wszystko, o czym PAN z nim rozmawiał na górze Synaj. ");
INSERT INTO polubg_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","A póki Mojżesz z nimi rozmawiał, miał na swojej twarzy zasłonę; ");
INSERT INTO polubg_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ale gdy Mojżesz wchodził przed oblicze PANA, aby z nim rozmawiać, zdejmował zasłonę, póki nie wyszedł. Gdy zaś wyszedł, mówił do synów Izraela, co mu nakazano. ");
INSERT INTO polubg_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","I synowie Izraela patrzyli na twarz Mojżesza, a skóra twarzy Mojżesza lśniła. I Mojżesz znowu kładł zasłonę na swoją twarz, póki nie wszedł, aby z nim rozmawiać. ");
INSERT INTO polubg_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Potem Mojżesz zebrał całe zgromadzenie synów Izraela i mówił do nich: Oto są słowa, które PAN rozkazał, abyście je wypełnili. ");
INSERT INTO polubg_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Przez sześć dni będzie wykonywana praca, ale siódmy dzień będzie dla was świętem, szabatem odpoczynku dla PANA. Kto w nim wykona pracę, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Nie rozniecicie ognia w żadnym z waszych mieszkań w dzień szabatu. ");
INSERT INTO polubg_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mojżesz powiedział też do całego zgromadzenia synów Izraela: Oto słowo, które PAN przykazał: ");
INSERT INTO polubg_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Złóżcie PANU dar od siebie: każdy, kto jest ochotnego serca, niech przyniesie PANU dar: złoto, srebro i miedź; ");
INSERT INTO polubg_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Błękitną tkaninę, purpurę, karmazyn, bisior i kozią sierść; ");
INSERT INTO polubg_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","I skóry baranie farbowane na czerwono i skóry borsucze, i drewno akacjowe; ");
INSERT INTO polubg_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Oliwę do oświetlenia, wonności na olejek do namaszczania i na wonne kadzidło; ");
INSERT INTO polubg_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Kamienie onyksu i kamienie do osadzenia efodu i pektorału. ");
INSERT INTO polubg_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","A wszyscy spośród was, którzy są uzdolnieni, przyjdą i będą robić wszystko, co PAN rozkazał: ");
INSERT INTO polubg_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Przybytek, jego namiot i przykrycie, haczyki do niego i deski, drążki do niego, słupy i podstawki; ");
INSERT INTO polubg_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Arkę i drążki do niej, przebłagalnię i zasłonę do osłonięcia; ");
INSERT INTO polubg_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Stół i drążki do niego, wszystkie jego naczynia i chleby pokładne; ");
INSERT INTO polubg_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Świecznik do oświetlenia i jego przybory, lampy do niego i oliwę do świecenia. ");
INSERT INTO polubg_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Także ołtarz kadzenia z drążkami do niego, olejek do namaszczania, wonne kadzidło i zasłonę do wejścia do przybytku; ");
INSERT INTO polubg_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Ołtarz całopalenia, miedzianą kratę do niego, drążki i wszystkie naczynia do niego, kadź i jej podstawę; ");
INSERT INTO polubg_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Zasłony do dziedzińca, słupy i podstawki do nich, zasłonę do wejścia na dziedziniec. ");
INSERT INTO polubg_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Kołki do przybytku i kołki do dziedzińca z ich sznurami. ");
INSERT INTO polubg_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Szaty służebne do usługiwania w Miejscu Świętym, święte szaty kapłana Aarona i szaty dla jego synów, do sprawowania urzędu kapłańskiego. ");
INSERT INTO polubg_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Wtedy całe zgromadzenie synów Izraela odeszło od Mojżesza. ");
INSERT INTO polubg_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","I przyszedł każdy, kogo serce pobudziło, i każdy, w którym duch był ochoczy; i przynieśli PANU dar do wykonania Namiotu Zgromadzenia, na wszelką służbę w nim i na święte szaty. ");
INSERT INTO polubg_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Przychodzili więc mężczyźni i kobiety, każdy, kto był ochotnego serca, i przynosili bransoletki, kolczyki, pierścienie, naszyjniki i wszelkie złote przedmioty i każdy przynosił PANU ofiarę ze złota. ");
INSERT INTO polubg_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Każdy też, kto miał błękitną tkaninę, purpurę, karmazyn, bisior, kozią sierść, skóry baranie farbowane na czerwono i skóry borsucze, przynosił je. ");
INSERT INTO polubg_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Każdy, kto ofiarował dar ze srebra i miedzi, przynosił na ofiarę dla PANA; każdy też, kto miał drewno akacjowe, do wszelkiej pracy tej służby, przynosił je. ");
INSERT INTO polubg_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","I wszystkie uzdolnione kobiety przędły swymi rękami i przynosiły to, co naprzędły: z błękitnej tkaniny, purpury, karmazynu i bisioru. ");
INSERT INTO polubg_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","A wszystkie kobiety, których serca były obdarzone zdolnością, przędły kozią sierść. ");
INSERT INTO polubg_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Przełożeni zaś przynosili kamienie onyksu i kamienie do osadzenia efodu i pektorału; ");
INSERT INTO polubg_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Także wonności i oliwę do świecenia i na olejek do namaszczania, i na wonne kadzidła. ");
INSERT INTO polubg_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Wszyscy synowie Izraela przynosili PANU dobrowolną ofiarę, każdy mężczyzna i każda kobieta, w których było serce ochocze do składania ofiar na każde dzieło, które PAN przez Mojżesza rozkazał wykonać. ");
INSERT INTO polubg_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Potem Mojżesz powiedział do synów Izraela: Oto PAN powołał po imieniu Besalela, syna Uriego, syna Chura, z pokolenia Judy; ");
INSERT INTO polubg_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","I napełnił go Duchem Bożym, mądrością, rozumem i umiejętnością we wszelkim rzemiośle; ");
INSERT INTO polubg_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Aby umiejętnie wymyślał wzory, aby wyrabiał ze złota, srebra i miedzi; ");
INSERT INTO polubg_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Do obrabiania kamieni do oprawy, do ciosania drewna, aby wykonał wszelkie rodzaje dzieła. ");
INSERT INTO polubg_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Włożył mu w serce też zdolność, aby mógł uczyć innych, on, i Oholiab, syn Achisamaka, z pokolenia Dana. ");
INSERT INTO polubg_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Napełnił ich mądrością serca, aby wykonywali wszelkie rzemiosło rytownicze, obmyślania projektów, hafciarskie z błękitnej tkaniny, purpury, karmazynu i bisioru i tkackie, aby obmyślali i zręcznie wykonywali każdą pracę. ");
INSERT INTO polubg_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Tak więc wykonali Besalel i Oholiab, i wszyscy uzdolnieni mężczyźni, którym Bóg dał mądrość i rozum, aby umieli wykonać każdą pracę do służby w świątyni, według wszystkiego, co PAN rozkazał. ");
INSERT INTO polubg_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","I Mojżesz wezwał Besalela i Oholiaba, i każdego uzdolnionego mężczyznę, któremu PAN włożył w serce mądrość, którego serce pobudziło, aby przystąpić do wykonywania tej pracy. ");
INSERT INTO polubg_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","I wzięli od Mojżesza wszystkie dary, które synowie Izraela przynieśli na dzieło służby w świątyni, aby ją wykonać. Oni zaś nadal przynosili mu dobrowolne dary każdego poranka. ");
INSERT INTO polubg_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Przyszli więc wszyscy uzdolnieni, którzy wykonywali wszelką pracę przy świątyni, każdy od swojej pracy, którą wykonywał; ");
INSERT INTO polubg_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","I powiedzieli do Mojżesza: Lud przynosi dużo więcej niż potrzeba do wykonania tej służby, którą PAN rozkazał uczynić. ");
INSERT INTO polubg_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Mojżesz rozkazał więc, aby ogłoszono w obozie: Niech już ani mężczyzna, ani kobieta nie przynosi więcej ofiar na budowę świątyni. I powstrzymano lud od ich przynoszenia. ");
INSERT INTO polubg_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Bo to, co mieli, wystarczyło do wykonania wszelkiej pracy, a nawet zbywało. ");
INSERT INTO polubg_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","I wszyscy uzdolnieni rzemieślnicy wykonali pracę przybytku: dziesięć zasłon ze skręconego bisioru, błękitnej tkaniny, purpury i karmazynu. Zrobili je z haftowanymi cherubinami. ");
INSERT INTO polubg_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Długość jednej zasłony była na dwadzieścia osiem łokci, a jej szerokość – na cztery łokcie. Wszystkie zasłony miały jednakowe wymiary. ");
INSERT INTO polubg_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","I spięli pięć zasłon jedną z drugą, także drugie pięć zasłon spięli jedną z drugą. ");
INSERT INTO polubg_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Porobili też pętle z błękitnej tkaniny na brzegu jednej zasłony, na końcu, gdzie mają się spinać. Zrobili je także na brzegu drugiej zasłony, na końcu, gdzie mają się spinać. ");
INSERT INTO polubg_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Pięćdziesiąt pętli zrobili na jednej zasłonie i pięćdziesiąt pętli zrobili na brzegu zasłony, w miejscu, gdzie ma być spięta z drugą. Pętle były jedna naprzeciw drugiej. ");
INSERT INTO polubg_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Zrobili też pięćdziesiąt złotych haczyków i spięli jedną zasłonę z drugą tymi haczykami. I tak przybytek stanowił jedną całość. ");
INSERT INTO polubg_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Wykonali też zasłony z koziej sierści na namiot do przykrycia przybytku z wierzchu, zrobili jedenaście zasłon. ");
INSERT INTO polubg_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Długość jednej zasłony była na trzydzieści łokci, a jej szerokość – na cztery łokcie. Jedenaście zasłon miało jednakowe wymiary. ");
INSERT INTO polubg_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","I spięli pięć zasłon osobno, a sześć zasłon osobno. ");
INSERT INTO polubg_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Zrobili też pięćdziesiąt pętli na brzegu jednej zasłony, na końcu, gdzie ma być spięta, i pięćdziesiąt pętli zrobili na brzegu drugiej zasłony do spięcia. ");
INSERT INTO polubg_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Zrobili też pięćdziesiąt miedzianych haczyków do spięcia namiotu, aby stanowił jedną całość. ");
INSERT INTO polubg_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Zrobili ponadto przykrycie na namiot ze skór baranich czerwono farbowanych i przykrycie ze skór borsuczych na wierzch. ");
INSERT INTO polubg_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Zrobili też prosto stojące deski do przybytku z drewna akacjowego. ");
INSERT INTO polubg_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Długość jednej deski wynosiła dziesięć łokci, a jej szerokość – półtora łokcia. ");
INSERT INTO polubg_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Jedna deska miała dwa czopy ułożone jeden naprzeciw drugiego. Tak zrobili przy wszystkich deskach przybytku. ");
INSERT INTO polubg_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Zrobili też deski do przybytku, dwadzieścia desek na stronę południową, ku południowemu wiatrowi. ");
INSERT INTO polubg_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","I zrobili ze srebra czterdzieści podstawek pod dwadzieścia desek: dwie podstawki pod jedną deskę do dwóch jej czopów, także dwie podstawki pod drugą deskę do dwóch jej czopów. ");
INSERT INTO polubg_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Także na drugim boku przybytku od strony północnej zrobili dwadzieścia desek; ");
INSERT INTO polubg_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","I do nich czterdzieści srebrnych podstawek: dwie podstawki pod jedną deskę i dwie podstawki pod drugą deskę. ");
INSERT INTO polubg_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ale po zachodniej stronie przybytku zrobili sześć desek. ");
INSERT INTO polubg_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Dwie deski zrobili na narożniki przybytku po obydwu stronach; ");
INSERT INTO polubg_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","A były złączone od spodu, były też złączone u góry do jednego pierścienia. Tak zrobili po obu stronach na dwóch narożnikach. ");
INSERT INTO polubg_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Było więc osiem desek i do nich szesnaście srebrnych podstawek, po dwie podstawki pod każdą deską. ");
INSERT INTO polubg_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Zrobili też drążki z drewna akacjowego; pięć do desek jednej strony przybytku; ");
INSERT INTO polubg_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","A także pięć drążków do desek drugiej strony przybytku, również pięć drążków do desek zachodniej strony przybytku. ");
INSERT INTO polubg_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","I zrobili też środkowy drążek, aby przechodził przez środek desek od końca do końca. ");
INSERT INTO polubg_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","A deski pokryli złotem i zrobili do nich pierścienie ze złota jako uchwyty dla drążków, i drążki pokryli złotem. ");
INSERT INTO polubg_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Zrobili też zasłonę z błękitnej tkaniny, purpury, karmazynu i skręconego bisioru. Zrobili ją z misternie wyhaftowanymi cherubinami. ");
INSERT INTO polubg_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","A do niej zrobili cztery słupy z drewna akacjowego i pokryli je złotem, haki do nich też były ze złota, i odlali do nich cztery srebrne podstawki. ");
INSERT INTO polubg_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Zrobili też zasłonę do wejścia do namiotu z błękitnej tkaniny, purpury, karmazynu i skręconego bisioru, haftowaną; ");
INSERT INTO polubg_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","A do niej pięć słupów z haczykami i pokryli złotem ich głowice i klamry, a pięć podstawek do nich było z miedzi. ");
INSERT INTO polubg_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","I Besalel zrobił arkę z drewna akacjowego, a jej długość była na dwa i pół łokcia, a jej szerokość – na półtora łokcia, także jej wysokość to półtora łokcia. ");
INSERT INTO polubg_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","I pokrył ją szczerym złotem wewnątrz i na zewnątrz i zrobił wokół niej złotą listwę. ");
INSERT INTO polubg_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Odlał też do niej cztery złote pierścienie do czterech jej narożników: dwa pierścienie po jednej jej stronie, a dwa pierścienie po drugiej jej stronie. ");
INSERT INTO polubg_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Zrobił również drążki z drewna akacjowego i pokrył je złotem. ");
INSERT INTO polubg_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","I włożył drążki w pierścienie po obu stronach arki, aby arka była na nich noszona. ");
INSERT INTO polubg_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Zrobił też przebłagalnię ze szczerego złota: jej długość była na dwa i pół łokcia, a jej szerokość – na półtora łokcia. ");
INSERT INTO polubg_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Zrobił dwa cherubiny wykute ze złota na obu końcach przebłagalni. ");
INSERT INTO polubg_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Jednego cherubina na jednym końcu, a drugiego cherubina na drugim końcu. Zrobił cherubiny z przebłagalni wystające na obu jej końcach. ");
INSERT INTO polubg_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","A cherubiny miały rozpostarte skrzydła, z wierzchu zakrywały swymi skrzydłami przebłagalnię, a ich twarze były zwrócone ku sobie, twarze cherubinów były zwrócone ku przebłagalni. ");
INSERT INTO polubg_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Zrobił też stół z drewna akacjowego, jego długość była na dwa łokcie, jego szerokość – na jeden łokieć, a wysokość – na półtora łokcia. ");
INSERT INTO polubg_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","I pokrył go szczerym złotem, i zrobił wokół niego złotą listwę. ");
INSERT INTO polubg_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Zrobił wokół niego też listwę o szerokości dłoni; zrobił również złote obramowanie wokoło tej listwy. ");
INSERT INTO polubg_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","I odlał do niego cztery złote pierścienie, i przyprawił je do czterech narożników u jego czterech nóg. ");
INSERT INTO polubg_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Naprzeciwko tej listwy były pierścienie, przez które przewleczono drążki do noszenia stołu. ");
INSERT INTO polubg_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Porobił drążki z drewna akacjowego do noszenia stołu i powlókł je złotem. ");
INSERT INTO polubg_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Zrobił też ze szczerego złota naczynia do stołu, misy do niego, czasze, przykrycia i kubki do nalewania. ");
INSERT INTO polubg_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Zrobił także świecznik ze szczerego złota. Wykuł ze złota ten świecznik. Jego podstawa, ramiona, kielichy, gałki i kwiaty były z tej samej bryły. ");
INSERT INTO polubg_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Sześć ramion wychodziło z obu boków: trzy ramiona z jednego boku świecznika i trzy ramiona z drugiego boku świecznika. ");
INSERT INTO polubg_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Trzy kielichy na kształt migdała na jednym ramieniu, także gałka i kwiat; i trzy kielichy na kształt migdała na drugim ramieniu, także gałka i kwiat. Tak było na wszystkich sześciu ramionach wychodzących ze świecznika. ");
INSERT INTO polubg_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ale na samym świeczniku były cztery kielichy na kształt migdała, jego gałki i jego kwiaty. ");
INSERT INTO polubg_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","I była gałka pod dwoma jego ramionami, także gałka pod następnymi dwoma jego ramionami, i znów gałka pod dwoma innymi jego ramionami. Tak było pod sześcioma ramionami wychodzącymi z niego. ");
INSERT INTO polubg_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ich gałki i ramiona były z tej samej bryły. Wszystko to w całości było wykute ze szczerego złota. ");
INSERT INTO polubg_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Zrobił też do niego siedem lamp oraz szczypce i naczynia na popiół ze szczerego złota. ");
INSERT INTO polubg_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Zrobił go i wszystkie naczynia do niego z talentu szczerego złota. ");
INSERT INTO polubg_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Zrobił także ołtarz do kadzenia z drewna akacjowego, na łokieć długi i na łokieć szeroki, kwadratowy, na dwa łokcie wysoki, a z niego wychodziły rogi. ");
INSERT INTO polubg_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","I pokrył go szczerym złotem – jego wierzch, jego ściany wokoło i jego rogi. Zrobił też dokoła niego złotą listwę. ");
INSERT INTO polubg_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Zrobił dwa złote pierścienie do niego, pod jego listwą, na dwóch jego narożnikach, po obu bokach, przez które przewleczono drążki, aby był na nich noszony. ");
INSERT INTO polubg_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Zrobił także drążki z drewna akacjowego i pokrył je złotem. ");
INSERT INTO polubg_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Sporządził też olejek do świętego namaszczenia i wonne kadzidło, tak jak się robi wonności. ");
INSERT INTO polubg_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Zrobił również ołtarz do całopalenia z drewna akacjowego, na pięć łokci długi i na pięć łokci szeroki, kwadratowy, na trzy łokcie wysoki. ");
INSERT INTO polubg_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","I zrobił rogi na jego czterech narożnikach, rogi wychodziły z niego. I pokrył go miedzią. ");
INSERT INTO polubg_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Zrobił też wszystkie naczynia do ołtarza, kociołki, szufle, miednice, widełki i łopaty na rozżarzone węgle. Wszystkie naczynia do niego zrobił z miedzi. ");
INSERT INTO polubg_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Zrobił także do ołtarza miedzianą kratę na kształt sieci pod obramowaniem, od spodu aż do połowy wysokości. ");
INSERT INTO polubg_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","I odlał cztery pierścienie na czterech rogach miedzianej kraty jako uchwyty na drążki. ");
INSERT INTO polubg_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Porobił również drążki z drewna akacjowego i pokrył je miedzią. ");
INSERT INTO polubg_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","I włożył drążki w te pierścienie po obu bokach ołtarza, aby był na nich noszony; zrobił go z desek, wewnątrz był pusty. ");
INSERT INTO polubg_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Zrobił też kadź z miedzi i do niej miedzianą podstawę ze zwierciadeł kobiet, które gromadnie przychodziły przed wejście do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Zrobił także dziedziniec: na południu po prawej stronie zasłony dziedzińca były ze skręconego bisioru, na sto łokci; ");
INSERT INTO polubg_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Do nich dwadzieścia słupów, a do nich dwadzieścia miedzianych podstawek; haki na słupach i ich klamry ze srebra. ");
INSERT INTO polubg_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Także po stronie północnej zasłony na sto łokci; do nich dwadzieścia słupów i do nich dwadzieścia miedzianych podstawek; haki na słupach i ich klamry ze srebra. ");
INSERT INTO polubg_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","A od zachodniej strony były zasłony na pięćdziesiąt łokci; do nich dziesięć słupów i do nich dziesięć podstawek; haki na słupach i ich klamry ze srebra. ");
INSERT INTO polubg_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","A z przodu po stronie wschodniej były zasłony na pięćdziesiąt łokci. ");
INSERT INTO polubg_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Zasłony na piętnaście łokci były po jednej stronie, do nich trzy słupy i trzy podstawki. ");
INSERT INTO polubg_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","I po drugiej stronie bramy dziedzińca, z jednej i z drugiej strony, piętnaście łokci zasłon, do nich trzy słupy i trzy podstawki. ");
INSERT INTO polubg_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Wszystkie zasłony dziedzińca wokoło były ze skręconego bisioru; ");
INSERT INTO polubg_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","A podstawki słupów z miedzi, haki na słupach i klamry ze srebra, także pokrycia ich głowic ze srebra; wszystkie słupy dziedzińca były oklamrowane srebrem. ");
INSERT INTO polubg_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Zasłona do bramy dziedzińca była haftowana, z błękitnej tkaniny, purpury, karmazynu i skręconego bisioru; długa na dwadzieścia łokci, wysoka na pięć łokci jak inne zasłony dziedzińca. ");
INSERT INTO polubg_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","A do nich cztery słupy i cztery miedziane podstawki; haki do nich były ze srebra, pokrycia ich głowic i klamry też były ze srebra. ");
INSERT INTO polubg_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Wszystkie kołki przybytku i dziedzińca wokoło były z miedzi. ");
INSERT INTO polubg_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Oto obliczenie rzeczy do przybytku, do Przybytku Świadectwa, które zostały obliczone na rozkaz Mojżesza przez Itamara, syna kapłana Aarona, do służby Lewitów. ");
INSERT INTO polubg_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","A Besalel, syn Uriego, syna Chura, z pokolenia Judy, zrobił wszystko, co PAN rozkazał Mojżeszowi; ");
INSERT INTO polubg_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","A z nim Oholiab, syn Achisamaka, z pokolenia Dana, rytownik, wybitny rzemieślnik i haftujący na błękitnej tkaninie, na purpurze, na karmazynie i na bisiorze. ");
INSERT INTO polubg_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Całego złota zużytego na wykonanie wszelkich robót świątyni – złota z darów – było dwadzieścia dziewięć talentów i siedemset trzydzieści syklów według sykla świątynnego. ");
INSERT INTO polubg_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Srebra zaś od przeliczonych spośród zgromadzenia było sto talentów i tysiąc siedemset siedemdziesiąt pięć syklów według sykla świątynnego. ");
INSERT INTO polubg_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Od każdej głowy pół sykla według sykla świątynnego, od wszystkich, którzy zostali policzeni, od dwudziestu lat i wyżej, a ludzi tych było sześćset trzy tysiące pięciuset pięćdziesięciu. ");
INSERT INTO polubg_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","A było sto talentów srebra do odlewania podstawek świątyni i podstawek zasłony; sto podstawek ze stu talentów; talent na podstawkę. ");
INSERT INTO polubg_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","A z tysiąca siedmiuset siedemdziesięciu pięciu syklów zrobił haki na słupy i pokrył ich głowice, i oklamrował je. ");
INSERT INTO polubg_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Miedzi zaś złożonej w ofierze było siedemdziesiąt talentów i dwa tysiące czterysta syklów. ");
INSERT INTO polubg_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","I odlał z niej podstawki do wejścia do Namiotu Zgromadzenia i miedziany ołtarz, i do niego miedzianą kratę oraz wszystkie naczynia do ołtarza. ");
INSERT INTO polubg_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","I podstawki do dziedzińca wokoło, podstawki do bramy dziedzińca, wszystkie kołki przybytku oraz kołki dziedzińca wokoło. ");
INSERT INTO polubg_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Także z błękitnej tkaniny, purpury i karmazynu zrobili szaty do służby, do posługiwania w świątyni. Zrobili też święte szaty dla Aarona, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","I zrobili efod ze złota, błękitnej tkaniny, purpury, karmazynu i skręconego bisioru. ");
INSERT INTO polubg_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Naklepali też złote blaszki i nacięli z nich nici do przetykania haftem błękitnej tkaniny, purpury, karmazynu i bisioru. ");
INSERT INTO polubg_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Zrobili do niego naramienniki, aby się jeden z drugim mógł złączyć. Łączyły się na dwóch końcach. ");
INSERT INTO polubg_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Także pas do efodu, który był na nim, z tego samego był i tak samo zrobiony: ze złota, błękitnej tkaniny, purpury, karmazynu i skręconego bisioru, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Do tego obrobili kamienie onyksu osadzone w złotych oprawkach, wyryte tak jak pieczęci bywają ryte, z imionami synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","I umieścili je na naramiennikach efodu, aby były kamieniami pamiątkowymi dla synów Izraela, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Zrobili też haftowany pektorał podobnie jak efod: ze złota, błękitnej tkaniny, purpury, karmazynu i skręconego bisioru. ");
INSERT INTO polubg_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Był kwadratowy; zrobili podwójny pektorał, na piędź długości i na piędź szerokości, złożony we dwoje. ");
INSERT INTO polubg_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","I osadzili w nim cztery rzędy kamieni w tym porządku: karneol, topaz i szmaragd w pierwszym rzędzie. ");
INSERT INTO polubg_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","A w drugim rzędzie: karbunkuł, szafir i diament. ");
INSERT INTO polubg_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","A w trzecim rzędzie: hiacynt, agat i ametyst. ");
INSERT INTO polubg_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","A w czwartym rzędzie: beryl, onyks i jaspis, wszystkie osadzone w złotych oprawach. ");
INSERT INTO polubg_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","A tych kamieni z imionami synów Izraela było dwanaście, według ich imion, które ryte były jak na pieczęci; każdy według swego imienia, według dwunastu pokoleń. ");
INSERT INTO polubg_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Zrobili też do pektorału łańcuszki plecione ze szczerego złota. ");
INSERT INTO polubg_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Zrobili także dwie złote oprawki i dwa złote pierścienie i przyczepili te dwa pierścienie do obu rogów pektorału. ");
INSERT INTO polubg_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","I włożyli te dwa złote łańcuszki w oba pierścienie u rogów pektorału. ");
INSERT INTO polubg_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Drugie zaś końce obu łańcuszków przymocowali do tych dwóch oprawek i przyprawili z przodu do naramienników efodu. ");
INSERT INTO polubg_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Zrobili również dwa złote pierścienie, które przymocowali do dwóch rogów pektorału na jego wewnętrznym brzegu, który był od strony efodu. ");
INSERT INTO polubg_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Zrobili jeszcze dwa złote pierścienie, które przyprawili na dwie strony efodu, u dołu, naprzeciwko jego spojenia, ponad pasem efodu. ");
INSERT INTO polubg_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","I przywiązali pektorał jego pierścieniami do pierścieni efodu sznurem błękitnym, aby był nad pasem efodu, żeby pektorał nie odstawał od efodu, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Zrobili także tkany płaszcz pod efod, cały z błękitnej tkaniny; ");
INSERT INTO polubg_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","A pośrodku płaszcza otwór, jak otwór w pancerzu, i obwódkę dokoła brzegu, aby się nie rozdzierał. ");
INSERT INTO polubg_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Także u dołu tego płaszcza zrobili jabłka granatu z błękitnej tkaniny, purpury, karmazynu i skręconego bisioru. ");
INSERT INTO polubg_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Zrobili też dzwonki ze szczerego złota i pozawieszali te dzwonki między te jabłka granatu u dołu dokoła płaszcza, pośród jabłek granatu; ");
INSERT INTO polubg_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Dzwonek, a potem jabłko granatu i znów dzwonek, i jabłko granatu, u dołu dokoła płaszcza do usługiwania, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Zrobili też dla Aarona i jego synów szaty tkane z bisioru. ");
INSERT INTO polubg_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Mitrę także z bisioru i ozdobne mitry z bisioru, i spodnie ze skręconego bisioru. ");
INSERT INTO polubg_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Pas także ze skręconego bisioru, błękitnej tkaniny, purpury i karmazynu, haftowany, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Zrobili też blaszkę do świętej korony ze szczerego złota i wyryli na niej napis jak na pieczęci: Świętość PANU. ");
INSERT INTO polubg_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","A przymocowali do niej sznur z błękitnej tkaniny, aby była przywiązana na przodzie mitry, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","I tak skończyły się wszystkie prace około przybytku, czyli Namiotu Zgromadzenia. I synowie Izraela zrobili wszystko, jak PAN rozkazał Mojżeszowi; tak zrobili. ");
INSERT INTO polubg_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","I przynieśli ten przybytek do Mojżesza, namiot i wszystkie naczynia do niego, jego haki, deski, drążki, słupy i podstawki; ");
INSERT INTO polubg_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Przykrycie ze skór baranich farbowanych na czerwono, przykrycie ze skór borsuczych i zasłonę do osłonięcia; ");
INSERT INTO polubg_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Arkę świadectwa i drążki do niej, i przebłagalnię; ");
INSERT INTO polubg_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Stół, wszystkie naczynia do niego i chleb pokładny; ");
INSERT INTO polubg_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Szczerozłoty świecznik, lampy do niego – lampy ustawione w porządku – i wszystkie naczynia do niego, i oliwę do świecenia; ");
INSERT INTO polubg_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Także złoty ołtarz, olejek do namaszczania, wonne kadzidło i zasłonę do wejścia do namiotu; ");
INSERT INTO polubg_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Miedziany ołtarz i do niego miedzianą kratę, drążki i wszystkie naczynia do niego, kadź i podstawę do niej. ");
INSERT INTO polubg_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Zasłony do dziedzińca, słupy i podstawki do niego, zasłonę do bramy dziedzińca, sznury i kołki do niej i wszelkie naczynia do służby w przybytku, czyli do Namiotu Zgromadzenia; ");
INSERT INTO polubg_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Szaty do służby w posługiwaniu w świątyni, święte szaty dla kapłana Aarona i szaty jego synów do sprawowania urzędu kapłańskiego. ");
INSERT INTO polubg_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Według wszystkiego, co PAN rozkazał Mojżeszowi, tak synowie Izraela wykonali całą tę pracę. ");
INSERT INTO polubg_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","I Mojżesz obejrzał tę całą robotę, a zrobili ją, jak PAN rozkazał; tak właśnie zrobili. I Mojżesz im błogosławił. ");
INSERT INTO polubg_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","W pierwszym dniu, pierwszego miesiąca, wystawisz przybytek, czyli Namiot Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","I postawisz tam arkę świadectwa, i zakryjesz ją zasłoną. ");
INSERT INTO polubg_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Wstawisz stół i ustawisz na nim to, co należy; wniesiesz także świecznik i zapalisz jego lampy. ");
INSERT INTO polubg_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Postawisz też złoty ołtarz do kadzenia przed arką świadectwa i zawiesisz zasłonę przy wejściu do przybytku. ");
INSERT INTO polubg_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Postawisz także ołtarz całopalenia przed wejściem do przybytku, do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Postawisz też kadź między Namiotem Zgromadzenia a ołtarzem i nalejesz do niej wody. ");
INSERT INTO polubg_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Wystawisz również i dziedziniec wokoło i zawiesisz zasłonę w bramie dziedzińca. ");
INSERT INTO polubg_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Potem weźmiesz olejek do namaszczania i namaścisz przybytek i wszystko, co w nim jest, i poświęcisz go ze wszystkimi jego naczyniami, a będzie święty. ");
INSERT INTO polubg_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Namaścisz też ołtarz całopalenia i wszystkie jego naczynia i poświęcisz ołtarz, a stanie się najświętszym ołtarzem. ");
INSERT INTO polubg_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","I namaścisz kadź i jej podstawę, i poświęcisz ją. ");
INSERT INTO polubg_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Potem każesz podejść Aaronowi i jego synom przed wejście do Namiotu Zgromadzenia i umyjesz ich wodą. ");
INSERT INTO polubg_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Obleczesz Aarona w święte szaty i namaścisz go, i poświęcisz go, aby mi sprawował urząd kapłański. ");
INSERT INTO polubg_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Także jego synom każesz podejść i obleczesz ich w szaty; ");
INSERT INTO polubg_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","I namaścisz ich, jak namaściłeś ich ojca, aby mi sprawowali urząd kapłański. A ich namaszczenie będzie dla nich wiecznym kapłaństwem po wszystkie ich pokolenia. ");
INSERT INTO polubg_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mojżesz uczynił więc wszystko, jak mu PAN rozkazał; tak uczynił. ");
INSERT INTO polubg_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","I tak pierwszego miesiąca, drugiego roku, pierwszego dnia miesiąca, został wzniesiony przybytek. ");
INSERT INTO polubg_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","I Mojżesz wystawił przybytek, podstawił jego podstawki, postawił deski, włożył drążki i postawił jego słupy. ");
INSERT INTO polubg_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Rozciągnął też namiot nad przybytkiem i z wierzchu nałożył przykrycie namiotu nad nim, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Potem wziął świadectwo i włożył je do arki, i włożył drążki u arki, i umieścił przebłagalnię z wierzchu na arce. ");
INSERT INTO polubg_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","I wniósł arkę do przybytku, i zawiesił zasłonę zakrywającą, i zasłonił arkę świadectwa, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Postawił też stół w Namiocie Zgromadzenia po północnej stronie przybytku przed zasłoną. ");
INSERT INTO polubg_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","I poukładał na nim chleby przed PANEM, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Postawił też świecznik w Namiocie Zgromadzenia naprzeciwko stołu, po południowej stronie przybytku. ");
INSERT INTO polubg_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Zapalił też lampy przed PANEM, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ustawił i złoty ołtarz w Namiocie Zgromadzenia przed zasłoną; ");
INSERT INTO polubg_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","I zapalił na nim wonne kadzidło, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Potem zawiesił zasłonę u wejścia do przybytku. ");
INSERT INTO polubg_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Postawił też ołtarz całopalenia u wejścia do przybytku, czyli do Namiotu Zgromadzenia, i złożył na nim całopalenie i ofiarę pokarmową, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Potem umieścił kadź między Namiotem Zgromadzenia a ołtarzem i nalał do niej wody do obmywania. ");
INSERT INTO polubg_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","I Mojżesz, Aaron i jego synowie obmyli w niej swoje ręce i nogi. ");
INSERT INTO polubg_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Gdy wchodzili do Namiotu Zgromadzenia i gdy zbliżali się do ołtarza, obmywali się, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Na koniec wystawił dziedziniec dokoła przybytku i ołtarza oraz zawiesił zasłonę w bramie dziedzińca. I tak Mojżesz zakończył tę pracę. ");
INSERT INTO polubg_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Wtedy obłok okrył Namiot Zgromadzenia, a chwała PANA napełniła przybytek. ");
INSERT INTO polubg_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","I Mojżesz nie mógł wejść do Namiotu Zgromadzenia, bo spoczywał nad nim obłok, a chwała PANA napełniła przybytek. ");
INSERT INTO polubg_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","A gdy obłok wznosił się znad przybytku, synowie Izraela wyruszali w swoje wędrówki. ");
INSERT INTO polubg_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","A jeśli obłok nie wznosił się, nie wyruszali aż do dnia, kiedy się unosił. ");
INSERT INTO polubg_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","A obłok PANA był nad przybytkiem w ciągu dnia, w nocy zaś ogień był nad nim na oczach całego domu Izraela, w czasie całej ich wędrówki. ");
INSERT INTO polubg_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","I PAN zawołał do Mojżesza, i powiedział do niego z Namiotu Zgromadzenia: ");
INSERT INTO polubg_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Przemów do synów Izraela i powiedz im: Jeśli ktoś z was zechce złożyć PANU ofiarę, niech złoży ją z bydła, ze stada albo z trzody. ");
INSERT INTO polubg_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Jeśli jego ofiara całopalna będzie ze stada, niech złoży samca bez skazy. Niech go złoży dobrowolnie przed PANEM u wejścia do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","I położy swą rękę na głowie ofiary całopalnej, a zostanie przyjęta jako przebłaganie za niego. ");
INSERT INTO polubg_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Potem zabije tego cielca przed PANEM. A kapłani, synowie Aarona, ofiarują krew i pokropią tą krwią z wierzchu dokoła ołtarz, który jest przed wejściem do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","I obedrze ofiarę całopalną ze skóry, i pokroi ją na części. ");
INSERT INTO polubg_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Wtedy synowie kapłana Aarona położą ogień na ołtarzu i ułożą drwa na ogniu. ");
INSERT INTO polubg_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Potem kapłani, synowie Aarona, porządnie ułożą te części oraz głowę i tłuszcz na drwach leżących na ogniu na ołtarzu. ");
INSERT INTO polubg_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","A jego wnętrzności i nogi obmyje wodą. I kapłan spali to wszystko na ołtarzu. To jest całopalenie, ofiara ogniowa, miła woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","A jeśli jego ofiara na całopalenie będzie z trzody, owiec lub kóz, niech weźmie samca bez skazy; ");
INSERT INTO polubg_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","I zabije go obok ołtarza po północnej stronie przed PANEM. A kapłani, synowie Aarona, pokropią jego krwią z wierzchu ołtarz dokoła. ");
INSERT INTO polubg_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Potem pokroi go na części wraz z jego głową i tłuszczem. A kapłan ułoży je porządnie na drwach leżących na ogniu na ołtarzu. ");
INSERT INTO polubg_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Wnętrzności zaś i nogi obmyje wodą. I kapłan weźmie to wszystko, i spali na ołtarzu. To jest całopalenie, ofiara ogniowa, miła woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","A jeśli jego ofiara na całopalenie dla PANA będzie z ptactwa, niech weźmie swoją ofiarę z synogarlic albo z młodych gołębi. ");
INSERT INTO polubg_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kapłan przyniesie go do ołtarza, ukręci mu głowę i spali na ołtarzu, a jego krew wyciśnie na ścianę ołtarza. ");
INSERT INTO polubg_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","I usunie wole wraz z jego pierzem i wyrzuci je na popielisko, obok ołtarza po wschodniej stronie; ");
INSERT INTO polubg_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","I naderwie jego skrzydła, ale ich nie oderwie. I kapłan spali to na ołtarzu, na drwach leżących na ogniu. To jest całopalenie, ofiara ogniowa, miła woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Gdy ktoś zechce złożyć PANU ofiarę pokarmową, niech jego ofiara będzie z mąki pszennej. Niech poleje ją oliwą i położy na niej kadzidła. ");
INSERT INTO polubg_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","I przyniesie ją do synów Aarona, kapłanów, a kapłan weźmie stamtąd pełną garść tej mąki pszennej wraz z oliwą i całym kadzidłem i spali to na ołtarzu jako pamiątkę. To jest ofiara ogniowa, miła woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","To zaś, co zostanie z tej ofiary pokarmowej, będzie dla Aarona i jego synów. Jest to najświętsza część z ofiar ogniowych dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","A jeśli będziesz składał ofiarę pokarmową upieczoną w piecu, niech to będą przaśne placki z mąki pszennej zmieszane z oliwą albo przaśne podpłomyki skropione oliwą. ");
INSERT INTO polubg_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Jeśli zaś będziesz składał ofiarę pokarmową smażoną na patelni, niech będzie ona z mąki pszennej niezakwaszonej, zmieszanej z oliwą. ");
INSERT INTO polubg_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Połamiesz ją na kawałki i polejesz oliwą. To jest ofiara pokarmowa. ");
INSERT INTO polubg_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","A jeśli będziesz składał ofiarę pokarmową gotowaną w rondlu, niech ona będzie z mąki pszennej z oliwą. ");
INSERT INTO polubg_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","I przyniesiesz PANU ofiarę pokarmową tak przyrządzoną. Oddasz ją kapłanowi, a on odniesie ją do ołtarza. ");
INSERT INTO polubg_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","I kapłan weźmie z tej ofiary pokarmowej część na pamiątkę i spali na ołtarzu. To jest ofiara ogniowa, miła woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","To zaś, co pozostanie z ofiary pokarmowej, będzie należeć do Aarona i jego synów. Jest to najświętsza część z ofiar ogniowych dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Żadna ofiara pokarmowa, jaką będziecie składać PANU, nie będzie przygotowywana z zakwasem, bo żadnego zakwasu ani żadnego miodu nie będziecie spalać na ofiarę ogniową dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Możecie je składać PANU jako ofiarę pierwocin, ale nie będziecie ich kłaść na ołtarzu na miłą woń. ");
INSERT INTO polubg_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Każdą z ofiar pokarmowych posolisz i nie pozbawisz soli przymierza twego Boga swej ofiary pokarmowej. Przy każdej twojej ofierze złożysz sól. ");
INSERT INTO polubg_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","A jeśli będziesz składał PANU ofiarę pokarmową z pierwocin, to złożysz świeże kłosy prażone na ogniu, zboże wykruszone ze świeżych kłosów jako ofiarę pokarmową z twoich pierwszych plonów; ");
INSERT INTO polubg_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Nalejesz na nią oliwy i położysz na nią kadzidła. To jest ofiara pokarmowa. ");
INSERT INTO polubg_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Wtedy kapłan spali na pamiątkę trochę jej wykruszonego zboża i oliwy wraz z całym jej kadzidłem. To jest ofiara ogniowa dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","A jeśli ktoś będzie chciał złożyć ofiarę pojednawczą, a byłaby ze stada – czy to samca, czy samicę – niech złoży ją bez skazy przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","I położy rękę na głowie swojej ofiary, i zabije ją przed wejściem do Namiotu Zgromadzenia. I synowie Aarona, kapłani, pokropią krwią z wierzchu dokoła ołtarz. ");
INSERT INTO polubg_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Potem z ofiary pojednawczej złoży PANU ofiarę ogniową: tłuszcz okrywający wnętrzności i cały tłuszcz, który jest na nich; ");
INSERT INTO polubg_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Obie nerki z tłuszczem, który jest na nich i na lędźwiach, i płat tłuszczu na wątrobie oddzieli wraz z nerkami. ");
INSERT INTO polubg_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","I synowie Aarona spalą to na ołtarzu razem z ofiarą całopalną, która jest na drwach leżących na ogniu. To jest ofiara ogniowa na miłą woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Jeśli zaś jego ofiara na ofiarę pojednawczą dla PANA będzie z trzody, czy to samiec, czy samica, niech złoży ją bez skazy. ");
INSERT INTO polubg_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Jeśli składa owcę na swoją ofiarę, niech złoży ją przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","I położy rękę na głowie swojej ofiary, i zabije ją przed Namiotem Zgromadzenia. I synowie Aarona pokropią jej krwią z wierzchu dokoła ołtarz. ");
INSERT INTO polubg_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","I z ofiary pojednawczej złoży PANU ofiarę ogniową: jej tłuszcz, cały ogon, który odetnie przy samej kości ogonowej, tłuszcz okrywający wnętrzności oraz cały tłuszcz na wnętrznościach; ");
INSERT INTO polubg_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Obie nerki z tłuszczem, który jest na nich i na lędźwiach, i płat tłuszczu na wątrobie, który oddzieli wraz z nerkami. ");
INSERT INTO polubg_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","I kapłan spali to na ołtarzu. To jest pokarm ofiary ogniowej dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Jeśli zaś jego ofiara będzie kozą, niech złoży ją przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Położy rękę na jej głowie i zabije ją przed Namiotem Zgromadzenia. I synowie Aarona pokropią jej krwią ołtarz dokoła. ");
INSERT INTO polubg_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","I złoży z niej PANU swoją ofiarę na ofiarę ogniową: tłuszcz okrywający wnętrzności i cały tłuszcz na wnętrznościach; ");
INSERT INTO polubg_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Obie nerki z tłuszczem, który jest na nich i na lędźwiach, i płat tłuszczu na wątrobie, który oddzieli wraz z nerkami. ");
INSERT INTO polubg_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","I kapłan spali to na ołtarzu. To jest pokarm ofiary ogniowej na miłą woń. Wszelki bowiem tłuszcz należy do PANA. ");
INSERT INTO polubg_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","To jest wieczna ustawa dla waszych pokoleń, we wszystkich waszych mieszkaniach: Nie będziecie jeść żadnego tłuszczu ani żadnej krwi. ");
INSERT INTO polubg_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Przemów do synów Izraela i powiedz im: Gdyby ktoś zgrzeszył nieświadomie przeciw któremuś z przykazań PANA i zrobił coś, czego nie wolno robić, i przekroczyłby jedno z nich: ");
INSERT INTO polubg_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Jeśli to namaszczony kapłan zgrzeszył jak ktoś z ludu, niech złoży PANU za swój grzech, którego się dopuścił, młodego cielca bez skazy jako ofiarę za grzech. ");
INSERT INTO polubg_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","I przyprowadzi tego cielca przed wejście do Namiotu Zgromadzenia przed PANA, położy rękę na głowie tego cielca i zabije go przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","I namaszczony kapłan weźmie nieco krwi tego cielca, i wniesie ją do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Potem kapłan umoczy swój palec we krwi i siedem razy pokropi tą krwią przed PANEM, przed zasłoną Miejsca Świętego. ");
INSERT INTO polubg_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","I kapłan pomaże tą krwią rogi ołtarza wonnego kadzidła, który jest przed PANEM w Namiocie Zgromadzenia; resztę zaś krwi tego cielca wyleje u podstawy ołtarza całopalenia, który jest przy wejściu do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","A cały tłuszcz wyjmie z cielca na ofiarę za grzech: tłuszcz okrywający wnętrzności i cały tłuszcz, który jest na wnętrznościach; ");
INSERT INTO polubg_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Obie nerki z tłuszczem, który jest na nich i na lędźwiach, i płat tłuszczu na wątrobie, który oddzieli wraz z nerkami; ");
INSERT INTO polubg_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Tak jak wyjmuje się go z cielca ofiary pojednawczej. I kapłan spali to na ołtarzu całopalenia. ");
INSERT INTO polubg_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Skórę zaś tego cielca i całe jego mięso wraz z głową i nogami, jego wnętrzności i odchody; ");
INSERT INTO polubg_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","A więc całego cielca, wyniesie poza obóz na miejsce czyste, gdzie wysypuje się popiół, i spali go na drwach, na ogniu. Będzie spalony tam, gdzie wysypują popiół. ");
INSERT INTO polubg_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Gdyby całe zgromadzenie Izraela zgrzeszyło nieświadomie, a sprawa była ukryta przed oczami zgromadzenia, i uczynili coś przeciw któremuś z przykazań PANA, czego nie wolno czynić, i w ten sposób zawinili; ");
INSERT INTO polubg_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Kiedy grzech, którego się dopuścili, wyjdzie na jaw, wtedy zgromadzenie złoży młodego cielca jako ofiarę za grzech i przyprowadzi go przed Namiot Zgromadzenia; ");
INSERT INTO polubg_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","A starsi zgromadzenia włożą ręce na głowę cielca przed PANEM. I zabiją tego cielca przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Wtedy namaszczony kapłan wniesie nieco krwi cielca do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","I kapłan umoczy swój palec w tej krwi, i pokropi nią siedem razy przed PANEM, przed zasłoną. ");
INSERT INTO polubg_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Potem pomaże tą krwią rogi ołtarza, który jest przed PANEM w Namiocie Zgromadzenia; resztę zaś krwi wyleje u podstawy ołtarza całopalenia, który jest przy wejściu do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Cały tłuszcz wyjmie z niego i spali na ołtarzu. ");
INSERT INTO polubg_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","I postąpi z tym cielcem tak samo jak postąpił z cielcem złożonym za grzech; tak właśnie z nim postąpi. W ten sposób kapłan dokona za nich przebłagania i będzie im przebaczone. ");
INSERT INTO polubg_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Potem wyniesie tego cielca poza obóz i spali go, tak jak spalił pierwszego cielca. To jest ofiara za grzech zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Gdyby przełożony ludu zgrzeszył nieświadomie i przekroczył jedno z przykazań PANA, swego Boga, czyniąc coś, czego nie wolno czynić, i w ten sposób zawinił; ");
INSERT INTO polubg_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Lub gdyby uświadomił sobie swój grzech, który popełnił, to przyprowadzi na ofiarę kozła z kóz, samca bez skazy; ");
INSERT INTO polubg_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Położy rękę na głowie tego kozła i zabije go na tym miejscu, gdzie się zabija ofiary całopalne przed PANEM. To jest ofiara za grzech. ");
INSERT INTO polubg_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","I kapłan weźmie na palec nieco krwi ofiary za grzech, i pomaże rogi ołtarza całopalenia, a resztę krwi wyleje u podstawy ołtarza całopalenia. ");
INSERT INTO polubg_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Cały zaś jego tłuszcz spali na ołtarzu, tak jak tłuszcz ofiary pojednawczej. W ten sposób kapłan dokona za niego przebłagania za jego grzech i będzie mu przebaczony. ");
INSERT INTO polubg_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Gdyby ktoś spośród ludu zgrzeszył nieświadomie i przekroczył jedno z przykazań PANA, czyniąc coś, czego nie wolno czynić, i w ten sposób zawinił; ");
INSERT INTO polubg_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Lub gdyby uświadomił sobie swój grzech, który popełnił, to przyprowadzi na ofiarę kozę z kóz, samicę bez skazy, za swój grzech, którego się dopuścił. ");
INSERT INTO polubg_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Potem położy rękę na głowie tej ofiary za grzech i zabije ją na miejscu ofiar całopalnych. ");
INSERT INTO polubg_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Kapłan zaś weźmie na palec nieco jej krwi i pomaże rogi ołtarza całopalenia, a resztę krwi wyleje u podstawy ołtarza. ");
INSERT INTO polubg_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Cały jej tłuszcz oddzieli – tak jak oddziela się tłuszcz z ofiary pojednawczej – i kapłan spali to na ołtarzu na miłą woń dla PANA. Tak kapłan dokona przebłagania za niego i będzie mu przebaczone. ");
INSERT INTO polubg_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","A jeśli przyprowadzi owcę na ofiarę za grzech, niech przyprowadzi samicę bez skazy. ");
INSERT INTO polubg_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","I położy rękę na głowie tej ofiary za grzech, i zabije ją jako ofiarę za grzech na tym miejscu, gdzie się zabija ofiary całopalne. ");
INSERT INTO polubg_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Potem kapłan weźmie na palec nieco krwi ofiary za grzech i pomaże rogi ołtarza całopalenia, a resztę krwi wyleje u podstawy ołtarza. ");
INSERT INTO polubg_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","I cały jej tłuszcz oddzieli – tak jak oddziela się tłuszcz z owcy ofiary pojednawczej – i kapłan spali to na ołtarzu, na ofiarach całopalnych dla PANA. W ten sposób kapłan dokona za niego przebłagania za jego grzech, którego się dopuścił, i będzie mu przebaczony. ");
INSERT INTO polubg_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Gdyby ktoś zgrzeszył przez to, że usłyszał przekleństwo i był tego świadkiem lub widział czy dowiedział się o tym, a tego nie oznajmił, będzie obciążony nieprawością; ");
INSERT INTO polubg_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Albo jeśli ktoś dotknął czegoś nieczystego, czy to padliny nieczystego zwierzęcia, czy padliny nieczystego bydlęcia, czy padliny nieczystego zwierzęcia pełzającego, a nie jest tego świadomy, i tak będzie nieczysty i winny; ");
INSERT INTO polubg_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Lub jeśli ktoś dotknął jakiejkolwiek nieczystości ludzkiej, przez którą stanie się nieczysty, a nie jest tego świadomy, a potem się o tym dowie, będzie winny; ");
INSERT INTO polubg_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Albo jeśli ktoś przysiągł, mówiąc wargami, że źle lub dobrze uczyni w czymkolwiek, co ów człowiek powie w przysiędze, a nie jest tego świadomy, lecz potem sobie uświadomi, będzie winny w jednej z tych rzeczy. ");
INSERT INTO polubg_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Jeśli więc jest winny jednej z tych rzeczy, ma wyznać swój grzech; ");
INSERT INTO polubg_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","I przyprowadzi PANU ofiarę za przewinienie z powodu swego grzechu, który popełnił: samicę z trzody, owcę albo kozę na ofiarę za grzech, a kapłan dokona za niego przebłagania za jego grzech. ");
INSERT INTO polubg_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","A jeśli nie stać go na owcę, niech przyniesie PANU jako ofiarę za swoje przewinienie, które popełnił, dwie synogarlice lub dwa młode gołębie: jednego na ofiarę za grzech, a drugiego na całopalenie; ");
INSERT INTO polubg_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","I przyniesie je do kapłana, a on najpierw złoży to, co ma być na ofiarę za grzech, i ukręci jego głowę przy szyi, ale jej nie oddzieli. ");
INSERT INTO polubg_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","I pokropi krwią tej ofiary za grzech ścianę ołtarza, a resztę krwi wyciśnie u podstawy ołtarza. To jest ofiara za grzech. ");
INSERT INTO polubg_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Drugiego zaś złoży jako całopalenie według przepisu. W ten sposób kapłan dokona za niego przebłagania za jego grzech, który popełnił, i będzie mu przebaczony. ");
INSERT INTO polubg_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","A jeśli nie stać go na dwie synogarlice lub dwa młode gołębie, niech ten, który zgrzeszył, przyniesie na swoją ofiarę dziesiątą część efy mąki pszennej na ofiarę za swój grzech. Nie naleje jednak na nią oliwy ani nie położy na nią kadzidła, gdyż jest to ofiara za grzech. ");
INSERT INTO polubg_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Przyniesie ją do kapłana, a kapłan nabierze z niej pełną garść jako pamiątkę i spali ją na ołtarzu na ofiarach całopalnych dla PANA. To jest ofiara za grzech. ");
INSERT INTO polubg_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","I kapłan dokona za niego przebłagania za jego grzech, który popełnił w jednej z tych spraw, i będzie mu przebaczony. Reszta zaś będzie dla kapłana, jak przy ofierze pokarmowej. ");
INSERT INTO polubg_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","PAN powiedział jeszcze do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Jeśli ktoś popełni przewinienie i zgrzeszy nieświadomie przy rzeczach poświęconych PANU, to przyprowadzi PANU jako ofiarę za swoje przewinienie barana bez skazy z trzody oraz twoje oszacowanie w syklach srebra według sykla świątynnego na ofiarę za przewinienie. ");
INSERT INTO polubg_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","I odda kapłanowi za to, czym przewinił przy rzeczach poświęconych, i dołoży do tego jedną piątą. I kapłan dokona za niego przebłagania baranem, będącym ofiarą za przewinienie, a będzie mu przebaczone. ");
INSERT INTO polubg_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Jeśli ktoś zgrzeszy i przekroczy nieświadomie którekolwiek z przykazań PANA, czyniąc to, czego nie wolno, stanie się winny i będzie obciążony nieprawością. ");
INSERT INTO polubg_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Przyprowadzi do kapłana barana z trzody bez skazy według twojego oszacowania na ofiarę za przewinienie. A kapłan dokona za niego przebłagania za jego uchybienie, którego nieświadomie się dopuścił, i będzie mu przebaczone. ");
INSERT INTO polubg_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Jest to ofiara za przewinienie, gdyż w istocie zawinił przeciwko PANU. ");
INSERT INTO polubg_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Jeśli ktoś zgrzeszy i popełni przewinienie przeciwko PANU przez to, że zaprze się wobec bliźniego rzeczy powierzonej lub oddanej do przechowania, lub zrabowanej, albo przez to, że oszukał bliźniego; ");
INSERT INTO polubg_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Albo jeśli znalazł rzecz zgubioną i zaprzeczał temu lub przysięgał fałszywie w jakiejkolwiek z tych spraw, które człowiek czyni, i przez to grzeszy; ");
INSERT INTO polubg_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Skoro więc tak zgrzeszył i stał się winnym, zwróci to, co zrabował lub zdobył przez oszustwo, lub to, co mu powierzono, lub rzecz zgubioną, którą znalazł; ");
INSERT INTO polubg_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Albo to, o czymkolwiek fałszywie przysięgał. Zwróci całą należność i dołoży do niej jedną piątą, i odda temu, do kogo to należało, w dniu swojej ofiary za przewinienie. ");
INSERT INTO polubg_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","A do kapłana przyprowadzi PANU ofiarę za swoje przewinienie: barana z trzody bez skazy według twego oszacowania na ofiarę za przewinienie. ");
INSERT INTO polubg_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","I kapłan dokona za niego przebłagania przed PANEM, i będzie mu przebaczone, cokolwiek uczynił, przez co stał się winny. ");
INSERT INTO polubg_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Rozkaż Aaronowi i jego synom: Takie jest prawo całopalenia: Jest to całopalenie, bo będzie palone na ołtarzu przez całą noc aż do rana; a ogień na ołtarzu nieustannie będzie płonął. ");
INSERT INTO polubg_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","I kapłan włoży swoją lnianą szatę i na swoje ciało lniane spodnie oraz zbierze popiół z całopalenia, które ogień strawił na ołtarzu, i wysypie go obok ołtarza. ");
INSERT INTO polubg_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Potem zdejmie swe szaty i ubierze się w inne, i wyniesie popiół za obóz, na czyste miejsce. ");
INSERT INTO polubg_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","A ogień na ołtarzu będzie płonął nieustannie, nie będzie gaszony. Kapłan rozpali na nim drwa każdego ranka i położy na nim ofiarę całopalną, i spali na nim tłuszcz ofiar pojednawczych. ");
INSERT INTO polubg_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Ogień będzie płonął na ołtarzu nieustannie, nie będzie gaszony. ");
INSERT INTO polubg_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Takie jest prawo ofiary pokarmowej: Synowie Aarona będą ją składać przed PANEM, przed ołtarzem. ");
INSERT INTO polubg_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Kapłan weźmie garść mąki z ofiary pokarmowej wraz z oliwą i całym kadzidłem, które będzie na ofierze pokarmowej, i spali to na ołtarzu jako pamiątkę na miłą woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","A to, co z niej zostanie, będą jeść Aaron i jego synowie. Będzie to spożywane bez zakwasu na miejscu świętym, spożyją to na dziedzińcu Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Nie będą tego piec na zakwasie. Dałem to im bowiem jako ich dział z moich ofiar ogniowych; jest to rzecz najświętsza, tak jak ofiara za grzech i ofiara za przewinienie. ");
INSERT INTO polubg_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Każdy mężczyzna spośród synów Aarona będzie to spożywać. Jest to ustawa wieczna dla waszych pokoleń, dotycząca ofiar ogniowych PANA. Każdy, kto ich dotknie, będzie poświęcony. ");
INSERT INTO polubg_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Taka jest ofiara Aarona i jego synów, którą będą składać PANU w dniu swego namaszczenia: dziesiąta część efy mąki pszennej jako nieustanna ofiara pokarmowa, połowa jej rano, a połowa wieczorem. ");
INSERT INTO polubg_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Będzie ona przyrządzona na patelni z oliwą. Przyniesiesz ją smażoną i będziesz składać w kawałkach jako ofiarę pokarmową na miłą woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Kapłan namaszczony na jego miejsce spośród jego synów będzie ją składać. Jest to ustawa wieczna dla PANA, cała będzie spalona. ");
INSERT INTO polubg_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","I każda kapłańska ofiara pokarmowa będzie spalona w całości. Nie może być spożywana. ");
INSERT INTO polubg_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Powiedz Aaronowi i jego synom: Takie jest prawo ofiary za grzech: Na miejscu, gdzie będzie zabijana ofiara całopalna, zostanie zabita przed PANEM ofiara za grzech. Jest to rzecz najświętsza. ");
INSERT INTO polubg_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Kapłan, który będzie ją składał za grzech, będzie ją jeść. Będzie spożywana na miejscu świętym, na dziedzińcu Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Każdy, kto dotknie jej mięsa, będzie poświęcony. A jeśli szata będzie opryskana jej krwią, wypierzesz na miejscu świętym to, co zostało opryskane. ");
INSERT INTO polubg_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","A naczynie gliniane, w którym ją gotowano, zostanie stłuczone. A jeśli była gotowana w naczyniu miedzianym, zostanie wyszorowane i wypłukane wodą. ");
INSERT INTO polubg_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Każdy mężczyzna spośród kapłanów będzie ją jeść. Jest to rzecz najświętsza. ");
INSERT INTO polubg_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","A żadna ofiara za grzech, której krew wnosi się do Namiotu Zgromadzenia dla oczyszczenia w świątyni, nie będzie jedzona, lecz zostanie spalona w ogniu. ");
INSERT INTO polubg_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Takie jest prawo ofiary za przewinienie: jest to rzecz najświętsza. ");
INSERT INTO polubg_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Na miejscu, gdzie zabijają ofiarę całopalną, zabiją ofiarę za przewinienie, a pokropią jej krwią z wierzchu dokoła ołtarz. ");
INSERT INTO polubg_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","I kapłan złoży w ofierze cały jej tłuszcz, ogon i tłuszcz pokrywający wnętrzności; ");
INSERT INTO polubg_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Obie nerki z tłuszczem, który jest na nich i na lędźwiach, i płat tłuszczu na wątrobie, który oddzieli wraz z nerkami. ");
INSERT INTO polubg_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","I kapłan spali to na ołtarzu jako ofiarę ogniową dla PANA. To jest ofiara za przewinienie. ");
INSERT INTO polubg_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Każdy mężczyzna spośród kapłanów będzie z niej jeść, będzie spożywana na miejscu świętym. Jest to rzecz najświętsza. ");
INSERT INTO polubg_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Zarówno do ofiary za grzech, jak i do ofiary za przewinienie odnosi się jednakowe prawo: będą one należeć do tego kapłana, który dokonuje przebłagania. ");
INSERT INTO polubg_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Do kapłana, który składa czyjąś ofiarę całopalną, będzie należeć skóra tej ofiary, którą złożył. ");
INSERT INTO polubg_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Także każda ofiara pokarmowa upieczona w piecu i wszystko, co przyrządzone w rondlu albo na patelni, będzie należeć do kapłana, który je składa. ");
INSERT INTO polubg_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Lecz każda ofiara pokarmowa zmieszana z oliwą albo sucha będzie należeć do wszystkich synów Aarona, do każdego w równej części. ");
INSERT INTO polubg_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","A takie jest prawo ofiary pojednawczej, którą będzie się składać PANU. ");
INSERT INTO polubg_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Jeśli ktoś składa ją jako ofiarę dziękczynną, złoży z ofiarą dziękczynną przaśne placki zmieszane z oliwą, przaśne podpłomyki pomazane oliwą i placki z mąki pszennej zmieszane z oliwą i smażone. ");
INSERT INTO polubg_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Oprócz tych placków złoży jako ofiarę chleb zakwaszony wraz z ofiarą dziękczynną ze swoich ofiar pojednawczych. ");
INSERT INTO polubg_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","I z niego będzie składał PANU po jednym chlebie z każdej ofiary jako ofiarę wzniesienia. Będzie to należeć do kapłana, który kropi krwią ofiar pojednawczych. ");
INSERT INTO polubg_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Mięso z dziękczynnej ofiary pojednawczej należy spożyć w dniu składania jego ofiary; nic z niego nie zostawią do rana. ");
INSERT INTO polubg_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","A jeśli jego ofiara jest darem ślubowanym lub dobrowolnym, należy ją spożyć w dniu jej złożenia; a to, co z niej zostanie, spożyją nazajutrz. ");
INSERT INTO polubg_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Lecz jeśli coś z mięsa tej ofiary zostanie do trzeciego dnia, będzie spalone w ogniu. ");
INSERT INTO polubg_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","A jeśli ktoś zje mięso tej ofiary pojednawczej trzeciego dnia, nie zostanie przyjęta ani nie zostanie policzona temu, który ją złożył. Będzie to obrzydliwością, a kto ją spożyje, będzie obciążony nieprawością. ");
INSERT INTO polubg_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Mięso, które dotknie czegoś nieczystego, nie będzie spożywane, ale zostanie spalone w ogniu. Inne mięso zaś może jeść każdy, kto jest czysty. ");
INSERT INTO polubg_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","A ktokolwiek spożyje mięso z ofiary pojednawczej, która należy do PANA, będąc nieczysty, to taki człowiek zostanie wykluczony ze swego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","A kto dotknie czegoś nieczystego: nieczystości ludzkiej lub nieczystego zwierzęcia lub jakiejkolwiek nieczystej obrzydliwości, a spożyje mięso z ofiary pojednawczej, która należy do PANA, to taki człowiek zostanie wykluczony ze swego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","PAN powiedział jeszcze do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Powiedz synom Izraela: Nie będziecie jedli żadnego tłuszczu wołu, owcy ani kozy; ");
INSERT INTO polubg_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Tłuszcz zwierzęcia padłego lub tłuszcz rozszarpanego może być używany do wszelkich celów, ale spożywać go nie wolno. ");
INSERT INTO polubg_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ktokolwiek bowiem spożyje tłuszcz zwierzęcia złożonego PANU jako ofiarę ogniową, ten zostanie wykluczony ze swego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Żadnej krwi nie będziecie jeść we wszystkich waszych mieszkaniach – ani z ptaków, ani ze zwierząt. ");
INSERT INTO polubg_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Każdy człowiek, który spożyje jakąkolwiek krew, zostanie wykluczony ze swego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","PAN powiedział jeszcze do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Powiedz synom Izraela: Kto będzie składał PANU ofiarę pojednawczą, niech przyniesie PANU swoją ofiarę ze swoich ofiar pojednawczych. ");
INSERT INTO polubg_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Własnoręcznie przyniesie PANU ofiarę ogniową; przyniesie tłuszcz wraz z mostkiem, aby kołysać nim jako ofiarą kołysaną przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Potem kapłan spali tłuszcz na ołtarzu, a mostek będzie należał do Aarona i jego synów. ");
INSERT INTO polubg_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","A prawą łopatkę oddacie kapłanowi jako ofiarę wzniesienia z waszych ofiar pojednawczych. ");
INSERT INTO polubg_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Kto spośród synów Aarona będzie składał krew ofiar pojednawczych i tłuszcz, weźmie jako swoją część prawą łopatkę. ");
INSERT INTO polubg_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Gdyż mostek kołysania i łopatkę wzniesienia wziąłem od synów Izraela z ich ofiar pojednawczych i dałem je kapłanowi Aaronowi oraz jego synom od synów Izraela na mocy wiecznej ustawy. ");
INSERT INTO polubg_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","To jest część z ofiar ogniowych PANA z powodu namaszczenia Aarona i jego synów od dnia, kiedy przyprowadził ich, aby pełnili służbę kapłańską dla PANA; ");
INSERT INTO polubg_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","O którym PAN rozkazał, aby im dawano od synów Izraela w dniu, w którym ich namaścił, na mocy wiecznej ustawy dla ich pokoleń. ");
INSERT INTO polubg_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Takie jest prawo całopalenia, ofiary pokarmowej, ofiary za grzech, ofiary za przewinienie, ofiary poświęcenia i ofiary pojednawczej; ");
INSERT INTO polubg_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Które PAN nadał Mojżeszowi na górze Synaj w dniu, kiedy nakazał synom Izraela, aby składali swoje ofiary PANU na pustyni Synaj. ");
INSERT INTO polubg_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Weź Aarona i z nim jego synów, ich szaty, oliwę do namaszczenia, cielca na ofiarę za grzech, dwa barany i kosz przaśnych chlebów; ");
INSERT INTO polubg_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","I zgromadź cały lud przy wejściu do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","I Mojżesz zrobił tak, jak mu PAN rozkazał; i zgromadził się cały lud przy wejściu do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Wtedy Mojżesz powiedział do zgromadzenia: Oto co PAN rozkazał uczynić. ");
INSERT INTO polubg_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","I kazał Mojżesz zbliżyć się Aaronowi i jego synom, i obmył ich wodą; ");
INSERT INTO polubg_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Potem włożył tunikę na niego i przepasał go pasem, ubrał go w płaszcz, nałożył na niego efod i przepasał go pasem efodu, i przymocował go nim. ");
INSERT INTO polubg_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Włożył też na niego pektorał i do pektorału włożył Urim i Tummim. ");
INSERT INTO polubg_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Włożył także na jego głowę mitrę, a na mitrze z przodu umieścił złotą blaszkę, świętą koronę, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Mojżesz wziął też oliwę do namaszczenia i namaścił przybytek oraz wszystkie rzeczy, które w nim były, i poświęcił je. ");
INSERT INTO polubg_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Potem pokropił nią ołtarz siedem razy i namaścił ołtarz wraz ze wszystkimi jego przyborami, również kadź i jej podstawę, aby je poświęcić. ");
INSERT INTO polubg_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Wylał także oliwę do namaszczenia na głowę Aarona i namaścił go, aby go poświęcić. ");
INSERT INTO polubg_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Potem Mojżesz kazał zbliżyć się synom Aarona, włożył na nich tuniki, przepasał ich pasami i włożył im na głowy mitry, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Przyprowadził też cielca na ofiarę za grzech, a Aaron i jego synowie włożyli ręce na głowę cielca ofiary za grzech. ");
INSERT INTO polubg_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Następnie Mojżesz zabił go, wziął jego krew i pomazał palcem rogi ołtarza dokoła, i oczyścił ołtarz. Resztę zaś krwi wylał u podstawy ołtarza i poświęcił go dla dokonywania na nim przebłagania. ");
INSERT INTO polubg_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Potem wziął cały tłuszcz pokrywający wnętrzności, płat tłuszczu na wątrobie i obie nerki razem z ich tłuszczem i spalił to Mojżesz na ołtarzu. ");
INSERT INTO polubg_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","A cielca, jego skórę, mięso i odchody spalił w ogniu poza obozem, tak jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Potem przyprowadził barana na całopalenie. I Aaron, i jego synowie włożyli ręce na głowę tego barana. ");
INSERT INTO polubg_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mojżesz zabił go i pokropił jego krwią ołtarz dokoła. ");
INSERT INTO polubg_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Potem podzielił barana na części i spalił Mojżesz głowę, części i tłuszcz. ");
INSERT INTO polubg_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Wnętrzności zaś i nogi opłukał wodą; i Mojżesz spalił całego barana na ołtarzu. Jest to całopalenie na miłą woń, ofiara ogniowa dla PANA, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Potem kazał przyprowadzić drugiego barana, barana poświęcenia. I Aaron, i jego synowie włożyli ręce na głowę tego barana. ");
INSERT INTO polubg_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","I Mojżesz zabił go, wziął nieco z jego krwi i pomazał nią koniec prawego ucha Aarona, kciuk jego prawej ręki i wielki palec jego prawej nogi. ");
INSERT INTO polubg_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Kazał też zbliżyć się synom Aarona i pomazał Mojżesz tą krwią koniec ich prawego ucha, kciuki ich prawej ręki i wielkie palce ich prawej nogi. I Mojżesz pokropił krwią dokoła ołtarza. ");
INSERT INTO polubg_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Potem wziął tłuszcz, ogon, cały tłuszcz pokrywający wnętrzności, płat tłuszczu na wątrobie oraz obie nerki z ich tłuszczem i prawą łopatkę. ");
INSERT INTO polubg_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Także z kosza przaśnych chlebów, który był przed PANEM, wziął jeden przaśny placek, jeden placek chleba z oliwą oraz jeden podpłomyk i położył je na kawałki tłuszczu i na prawej łopatce. ");
INSERT INTO polubg_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","I dał to wszystko do rąk Aarona i do rąk jego synów i kołysał to jako ofiarę kołysaną przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Następnie Mojżesz wziął to z ich rąk i spalił na ołtarzu na ofierze całopalnej. To była ofiara poświęcenia na miłą woń, ofiara ogniowa dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Mojżesz wziął też mostek i kołysał go jako ofiarę kołysaną przed PANEM. Była to bowiem część Mojżesza z barana poświęcenia, jak mu PAN rozkazał. ");
INSERT INTO polubg_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Wziął też Mojżesz trochę oliwy do namaszczenia i nieco krwi z ołtarza, i pokropił nimi Aarona i jego szaty, a także jego synów i ich szaty. Tak poświęcił Aarona i jego szaty, jego synów i ich szaty. ");
INSERT INTO polubg_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","I Mojżesz powiedział do Aarona i jego synów: Ugotujcie to mięso przy wejściu do Namiotu Zgromadzenia i tam je spożywajcie wraz z chlebem, który jest w koszu poświęcenia, jak przykazałem: Aaron i jego synowie będą to spożywać. ");
INSERT INTO polubg_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","A to, co pozostanie z mięsa i chleba, spalicie w ogniu. ");
INSERT INTO polubg_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Nie odchodźcie od wejścia do Namiotu Zgromadzenia przez siedem dni, aż do dnia, kiedy wypełni się czas waszego poświęcenia. Przez siedem dni bowiem będziecie poświęcani. ");
INSERT INTO polubg_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Tak jak dziś uczyniono, tak PAN nakazał czynić, aby dokonać za was przebłagania. ");
INSERT INTO polubg_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Dlatego przy wejściu do Namiotu Zgromadzenia będziecie przebywać dzień i noc przez siedem dni i będziecie pełnili straż PANA, abyście nie pomarli. Tak mi bowiem rozkazano. ");
INSERT INTO polubg_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","I Aaron oraz jego synowie uczynili to wszystko, co im PAN rozkazał przez Mojżesza. ");
INSERT INTO polubg_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","A ósmego dnia Mojżesz wezwał Aarona, jego synów i starszych Izraela. ");
INSERT INTO polubg_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","I powiedział do Aarona: Weź sobie młodego cielca na ofiarę za grzech i barana na całopalenie, oba bez skazy, i złóż je w ofierze przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","A do synów Izraela powiesz: Weźcie kozła z kóz na ofiarę za grzech oraz cielca i barana, jednoroczne i bez skazy, na całopalenie; ");
INSERT INTO polubg_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Także wołu i barana na ofiary pojednawcze, by złożyć je przed PANEM, i ofiarę pokarmową zmieszaną z oliwą; bo dziś PAN wam się ukaże. ");
INSERT INTO polubg_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","I przyprowadzili to, co Mojżesz rozkazał, przed Namiot Zgromadzenia. A cały lud zbliżył się i stanął przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Wtedy Mojżesz powiedział: Oto co PAN nakazał wam uczynić; a ukaże się wam chwała PANA. ");
INSERT INTO polubg_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Do Aarona zaś Mojżesz powiedział: Zbliż się do ołtarza i złóż swoją ofiarę za grzech i swoje całopalenie, i dokonaj przebłagania za siebie i lud. Złóż też ofiarę ludu i dokonaj za niego przebłagania, jak PAN rozkazał. ");
INSERT INTO polubg_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aaron zbliżył się więc do ołtarza i zabił cielca na ofiarę za grzech za siebie. ");
INSERT INTO polubg_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","I synowie Aarona podali mu krew, a on umoczył swój palec we krwi i pomazał nią rogi ołtarza, a resztę krwi wylał u podstawy ołtarza; ");
INSERT INTO polubg_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ale tłuszcz, nerki i płat tłuszczu na wątrobie z ofiary za grzech spalił na ołtarzu, jak PAN rozkazał Mojżeszowi; ");
INSERT INTO polubg_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Mięso zaś i skórę spalił w ogniu poza obozem. ");
INSERT INTO polubg_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Zabił też ofiarę całopalną, a synowie Aarona podali mu krew, którą pokropił ołtarz dokoła. ");
INSERT INTO polubg_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Przynieśli mu też ofiarę całopalną podzieloną na części wraz z głową, a on spalił to na ołtarzu; ");
INSERT INTO polubg_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Obmył też wnętrzności oraz nogi i spalił je z ofiarą całopalną na ołtarzu. ");
INSERT INTO polubg_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Potem przyprowadził ofiarę ludu. Wziął kozła przeznaczonego na ofiarę za grzech za lud, zabił go i złożył na ofiarę za grzech, tak jak poprzednio. ");
INSERT INTO polubg_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Przyprowadził też ofiarę całopalną i uczynił z nią według przepisu. ");
INSERT INTO polubg_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Przyprowadził też ofiarę pokarmową. Wziął z niej pełną garść i spalił na ołtarzu, oprócz ofiary całopalnej porannej. ");
INSERT INTO polubg_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Zabił też wołu i barana jako ofiarę pojednawczą za lud. I synowie Aarona podali mu krew, którą pokropił ołtarz dokoła. ");
INSERT INTO polubg_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Podali mu także tłuszcz z wołu i barana, ogon, tłuszcz pokrywający wnętrzności oraz nerki i płat tłuszczu na wątrobie. ");
INSERT INTO polubg_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Włożyli też tłuszcz na mostkach, a on spalił tłuszcz na ołtarzu; ");
INSERT INTO polubg_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Mostki zaś i prawą łopatkę Aaron kołysał na ofiarę kołysaną przed PANEM, jak Mojżesz nakazał. ");
INSERT INTO polubg_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Potem Aaron podniósł ręce w stronę ludu i pobłogosławił go, a po złożeniu ofiary za grzech, ofiary całopalnej i ofiary pojednawczej zszedł na dół. ");
INSERT INTO polubg_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Wtedy Mojżesz i Aaron weszli do Namiotu Zgromadzenia, potem wyszli i pobłogosławili lud. I chwała PANA ukazała się całemu ludowi. ");
INSERT INTO polubg_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","I wyszedł ogień sprzed PANA, i strawił na ołtarzu ofiarę całopalną oraz tłuszcz. A gdy cały lud to ujrzał, krzyknął z radości i upadł na twarz. ");
INSERT INTO polubg_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","A Nadab i Abihu, synowie Aarona, wzięli każdy swoją kadzielnicę, włożyli do nich ogień, nałożyli na nie kadzidła i ofiarowali przed PANEM obcy ogień, którego im nie nakazał. ");
INSERT INTO polubg_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Wtedy wyszedł ogień sprzed PANA i pochłonął ich, i pomarli przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Wówczas Mojżesz powiedział do Aarona: Oto co PAN powiedział: W tych, którzy zbliżają się do mnie, będę uświęcony i będę uwielbiony przed całym ludem. I Aaron zamilkł. ");
INSERT INTO polubg_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mojżesz wezwał Miszaela i Elsafana, synów Uzziela, stryja Aarona, i powiedział do nich: Zbliżcie się i wynieście waszych braci sprzed świątyni poza obóz. ");
INSERT INTO polubg_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Podeszli więc i wynieśli ich w ich tunikach poza obóz, jak Mojżesz nakazał. ");
INSERT INTO polubg_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Potem Mojżesz powiedział do Aarona i jego synów, Eleazara i Itamara: Nie obnażajcie swoich głów ani nie rozdzierajcie swoich szat, abyście nie pomarli i aby Bóg nie rozgniewał się na całe zgromadzenie. Lecz wasi bracia, cały dom Izraela, niech opłakują ten pożar, który PAN rozpalił. ");
INSERT INTO polubg_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Nie odchodźcie od wejścia do Namiotu Zgromadzenia, abyście nie pomarli, ponieważ oliwa namaszczenia PANA jest na was. I postąpili według słowa Mojżesza. ");
INSERT INTO polubg_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Następnie PAN powiedział do Aarona: ");
INSERT INTO polubg_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Nie pij wina ani mocnego napoju, ani ty, ani twoi synowie z tobą, gdy będziecie wchodzić do Namiotu Zgromadzenia, abyście nie pomarli. To będzie ustawa wieczna dla wszystkich waszych pokoleń; ");
INSERT INTO polubg_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Abyście mogli rozróżniać między tym, co święte, a tym, co pospolite, między tym, co nieczyste, a tym, co czyste; ");
INSERT INTO polubg_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","I abyście nauczali synów Izraela wszystkich ustaw, które PAN nakazał im przez Mojżesza. ");
INSERT INTO polubg_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","I Mojżesz powiedział do Aarona oraz jego pozostałych synów, Eleazara i Itamara: Weźcie ofiarę pokarmową, która pozostała z ofiar ogniowych PANA, i jedzcie ją bez zakwasu przy ołtarzu. Jest to bowiem rzecz najświętsza. ");
INSERT INTO polubg_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Będziecie ją spożywać w miejscu świętym, bo jest to część należna tobie i twoim synom z ofiar ogniowych PANA. Tak mi bowiem rozkazano. ");
INSERT INTO polubg_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Także mostek kołysania i łopatkę wzniesienia będziecie spożywać w miejscu czystym, ty, twoi synowie i twoje córki z tobą. To bowiem należy się tobie, a także twoim synom, dane wam z ofiar pojednawczych synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Przyniosą łopatkę wzniesienia i mostek kołysania wraz z tłuszczem z ofiar ogniowych, aby kołysać je przed PANEM; a będzie to dla ciebie i twoich synów z tobą na mocy ustawy wiecznej, tak jak PAN rozkazał. ");
INSERT INTO polubg_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Potem Mojżesz pilnie szukał kozła na ofiarę za grzech, ale okazało się, że został on już spalony. I rozgniewał się na synów Aarona, Eleazara i Itamara, którzy mu pozostali, i mówił: ");
INSERT INTO polubg_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Dlaczego nie zjedliście ofiary za grzech w miejscu świętym? Przecież jest ona rzeczą najświętszą, którą dano wam, abyście nosili nieprawość całego ludu, abyście dokonali za niego przebłagania przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Oto jej krwi nie wniesiono do wnętrza miejsca świętego. Powinniście byli ją jeść na miejscu świętym, jak nakazałem. ");
INSERT INTO polubg_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Wtedy Aaron odpowiedział Mojżeszowi: Oto dziś złożyli swoją ofiarę za grzech i swoją ofiarę całopalną przed PANEM, a taka rzecz mnie spotkała. Gdybym dziś spożył ofiarę za grzech, czy to by się spodobało PANU? ");
INSERT INTO polubg_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Gdy Mojżesz to usłyszał, uznał to za słuszne. ");
INSERT INTO polubg_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Potem PAN przemówił do Mojżesza i Aarona tymi słowy: ");
INSERT INTO polubg_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Powiedzcie synom Izraela: Oto są zwierzęta, które będziecie mogli jeść spośród wszystkich zwierząt, które są na ziemi; ");
INSERT INTO polubg_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Wszystkie zwierzęta, które mają rozdzielone kopyta i racice oraz przeżuwają – je możecie jeść. ");
INSERT INTO polubg_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Jednak spośród tych, które przeżuwają albo mają tylko rozdzielone kopyta, nie będziecie jedli: wielbłąda, który choć przeżuwa, ale nie ma rozdzielonego kopyta – będzie dla was nieczysty. ");
INSERT INTO polubg_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Także królika, który choć przeżuwa, ale nie ma rozdzielonego kopyta – będzie dla was nieczysty. ");
INSERT INTO polubg_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Również zająca, który choć przeżuwa, ale nie ma rozdzielonego kopyta – będzie dla was nieczysty. ");
INSERT INTO polubg_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Świni, która choć ma rozdzielone kopyto i racice, ale nie przeżuwa – będzie dla was nieczysta. ");
INSERT INTO polubg_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Nie będziecie jeść ich mięsa ani dotykać ich padliny – będą dla was nieczyste. ");
INSERT INTO polubg_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","To będziecie jeść spośród wszystkiego, co żyje w wodach: wszystko, co w wodach – w morzach i rzekach – ma płetwy i łuski. To będziecie jeść. ");
INSERT INTO polubg_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Wszystko zaś, co nie ma płetw ani łusek w morzach i rzekach spośród wszystkiego, co się porusza w wodach, i spośród wszystkich stworzeń wodnych, będzie dla was obrzydliwością. ");
INSERT INTO polubg_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Będą dla was obrzydliwością; nie będziecie jedli ich mięsa, a ich padliną będziecie się brzydzić. ");
INSERT INTO polubg_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Wszystko w wodach, co nie ma płetw ani łusek, będzie dla was obrzydliwością. ");
INSERT INTO polubg_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Tymi zaś będziecie się brzydzić z ptactwa i jeść ich nie będziecie, bo są obrzydliwością: orzeł, orłosęp i rybołów; ");
INSERT INTO polubg_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","Sęp i kania według ich rodzaju; ");
INSERT INTO polubg_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Wszelki kruk według jego rodzaju; ");
INSERT INTO polubg_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Struś, sowa, mewa i jastrząb według ich rodzaju; ");
INSERT INTO polubg_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Puszczyk, kormoran i puchacz; ");
INSERT INTO polubg_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","Łabędź, pelikan i ścierwnik; ");
INSERT INTO polubg_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Bocian, czapla według jej rodzaju, dudek i nietoperz. ");
INSERT INTO polubg_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Wszelkie skrzydlate owady chodzące na czterech odnóżach będą dla was obrzydliwością. ");
INSERT INTO polubg_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Jednak spośród wszystkich skrzydlatych owadów, które mają cztery odnóża, możecie jeść te, które mają z tyłu przedłużone odnóża do skakania po ziemi. ");
INSERT INTO polubg_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Te z nich możecie jeść: szarańcza według jej rodzaju, szarańcza pustynna według jej rodzaju, skoczek według jego rodzaju i konik polny według jego rodzaju. ");
INSERT INTO polubg_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Wszelkie zaś inne skrzydlate pełzające istoty mające cztery odnóża będą dla was obrzydliwością. ");
INSERT INTO polubg_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Przez nie staniecie się nieczyści. Każdy, kto dotknie ich padliny, będzie nieczysty aż do wieczora; ");
INSERT INTO polubg_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","A ktokolwiek będzie nosił ich padlinę, upierze swoje szaty i będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Padlina wszystkich zwierząt, które mają rozdzielone kopyto, ale nie mają racicy i nie przeżuwają, będzie dla was nieczysta. Każdy, kto jej dotknie, będzie nieczysty. ");
INSERT INTO polubg_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","A wszystko, co chodzi na łapach spośród wszystkich zwierząt chodzących na czterech nogach, będzie dla was nieczyste. Kto dotknie ich padliny, będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","A kto będzie nosił ich padlinę, upierze swoje szaty i będzie nieczysty aż do wieczora. Są one dla was nieczyste. ");
INSERT INTO polubg_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Także spośród zwierząt, które pełzają po ziemi, będą dla was nieczyste: łasica, mysz i żółw według ich rodzaju; ");
INSERT INTO polubg_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","Jeż, jaszczurka, tchórz, ślimak i kret. ");
INSERT INTO polubg_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Te będą dla was nieczyste spośród wszystkich pełzających zwierząt. Kto ich dotknie, gdy są martwe, będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","A każda rzecz, na którą upadnie coś zdechłego z nich, będzie nieczysta, zarówno drewniane naczynie, jak i szata, a także skóra, worek lub jakikolwiek inny przedmiot, którym wykonuje się pracę; należy je włożyć do wody i będzie nieczyste aż do wieczora. Potem będzie czyste. ");
INSERT INTO polubg_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Wszelkie zaś gliniane naczynie, do którego wpadnie którekolwiek z nich, wraz ze wszystkim, co znajduje się w nim, będzie nieczyste, a naczynie rozbijecie. ");
INSERT INTO polubg_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Każdy pokarm, który się spożywa, do którego dostanie się woda z tego naczynia, będzie nieczysty. I wszelki napój, który by się piło z takiego naczynia, będzie nieczysty. ");
INSERT INTO polubg_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Wszystko, na co upadnie cokolwiek z ich padlin, będzie nieczyste, czy to piec, czy palenisko; mają być zniszczone. Są bowiem nieczyste i będą dla was nieczyste. ");
INSERT INTO polubg_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Lecz źródło i studnie, zbiorniki wody, będą czyste. Cokolwiek jednak dotknie ich padliny, będzie nieczyste. ");
INSERT INTO polubg_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","A jeśli coś z ich padliny upadnie na jakiekolwiek ziarno przeznaczone do siewu, to pozostanie czyste. ");
INSERT INTO polubg_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Jeśli jednak coś z ich padliny upadnie na ziarno zmoczone wodą, będzie ono dla was nieczyste. ");
INSERT INTO polubg_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Jeśli zdechnie zwierzę, które możecie jeść, to ten, kto dotknie jego padliny, będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","A kto by jadł jego padlinę, upierze swoje szaty i będzie nieczysty aż do wieczora. Ten, kto by wynosił tę padlinę, upierze swoje szaty i będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Także wszelkie zwierzęta pełzające po ziemi są obrzydliwością; nie będziecie ich jeść. ");
INSERT INTO polubg_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Niczego, co pełza na brzuchu, i niczego, co chodzi na czterech lub więcej odnóżach spośród wszystkich zwierząt pełzających po ziemi, nie będziecie jeść, bo są obrzydliwością. ");
INSERT INTO polubg_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Nie plugawcie siebie samych przez wszelkie te zwierzęta pełzające po ziemi i nie zanieczyszczajcie się nimi, byście nie stali się nieczyści; ");
INSERT INTO polubg_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Gdyż ja jestem PAN, wasz Bóg. Uświęcajcie się więc i bądźcie świętymi, bo ja jestem święty. I nie zanieczyszczajcie się żadnym zwierzęciem pełzającym po ziemi. ");
INSERT INTO polubg_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Gdyż ja jestem PAN, który was wyprowadził z ziemi Egiptu, aby być waszym Bogiem. Bądźcie więc świętymi, bo ja jestem święty. ");
INSERT INTO polubg_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","To jest prawo dotyczące zwierząt, ptactwa i wszelkich żywych istot poruszających się w wodach, a także wszelkich istot pełzających po ziemi; ");
INSERT INTO polubg_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Dla rozróżnienia między nieczystym a czystym, między zwierzętami, które można jeść, a których jeść nie wolno. ");
INSERT INTO polubg_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","I PAN przemówił do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Powiedz synom Izraela: Jeśli kobieta pocznie i urodzi chłopca, będzie nieczysta przez siedem dni; jak w dniach jej odłączenia z powodu swej miesięcznej słabości, będzie nieczysta. ");
INSERT INTO polubg_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","A ósmego dnia zostanie obrzezany jego napletek. ");
INSERT INTO polubg_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Potem ona pozostanie przez trzydzieści trzy dni we krwi swego oczyszczenia; nie dotknie żadnej świętej rzeczy ani nie wejdzie do świątyni, aż wypełnią się dni jej oczyszczenia. ");
INSERT INTO polubg_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","A jeśli urodzi dziewczynkę, będzie nieczysta przez dwa tygodnie, jak podczas jej odłączenia. Potem pozostanie przez sześćdziesiąt sześć dni we krwi swego oczyszczenia. ");
INSERT INTO polubg_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","A gdy wypełnią się dni jej oczyszczenia po synu lub po córce, przyniesie do kapłana przed wejście do Namiotu Zgromadzenia rocznego baranka na całopalenie i młodego gołębia lub synogarlicę na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Ten złoży to w ofierze przed PANEM i dokona za nią przebłagania; i tak będzie oczyszczona od upływu swojej krwi. Takie jest prawo dla tej, która urodziła chłopca lub dziewczynkę. ");
INSERT INTO polubg_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","A jeśli nie może przynieść baranka, to przyniesie dwie synogarlice lub dwa młode gołębie: jednego na całopalenie, a drugiego na ofiarę za grzech. I kapłan dokona za nią przebłagania i będzie czysta. ");
INSERT INTO polubg_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","PAN powiedział dalej do Mojżesza i Aarona: ");
INSERT INTO polubg_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Gdyby człowiek miał na skórze swego ciała nabrzmienie, wysypkę lub białą plamę i będzie to wyglądało na skórze jego ciała jak plaga trądu, zostanie przyprowadzony do kapłana Aarona lub do któregoś z jego synów, kapłanów. ");
INSERT INTO polubg_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Wtedy kapłan obejrzy chore miejsce na skórze jego ciała. Jeśli włos w tym miejscu zbielał i to miejsce zdaje się być bardziej wklęsłe niż pozostała skóra ciała, to jest to plaga trądu. Gdy kapłan go obejrzy, uzna go za nieczystego. ");
INSERT INTO polubg_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","A jeśli plama na skórze jego ciała jest biała i z wyglądu nie jest głębsza niż skóra, i włosy na niej nie zbielały, wtedy kapłan odosobni chorego na siedem dni. ");
INSERT INTO polubg_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Potem kapłan obejrzy go siódmego dnia. Jeśli wydaje mu się, że chore miejsce zatrzymało się i nie rozszerzyło na skórze, wtedy kapłan odosobni go na kolejne siedem dni. ");
INSERT INTO polubg_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","I kapłan ponownie obejrzy go siódmego dnia. Jeśli chore miejsce przyciemniało i nie rozszerzyło się na skórze, wtedy kapłan uzna go za czystego. Jest to wysypka. Wypierze on swoje szaty i będzie czysty. ");
INSERT INTO polubg_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Jeśli jednak wysypka mocno się rozszerzyła na skórze po obejrzeniu przez kapłana w celu oczyszczenia, pokaże się znowu kapłanowi. ");
INSERT INTO polubg_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Jeśli kapłan zobaczy, że wysypka rozszerzyła się na skórze, uzna go za nieczystego. Jest to trąd. ");
INSERT INTO polubg_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Gdy plaga trądu pojawi się na człowieku, zostanie przyprowadzony do kapłana; ");
INSERT INTO polubg_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","I kapłan obejrzy go. A jeśli jest na skórze białe nabrzmienie, przez które włosy zbielały, i na tym nabrzmieniu jest żywe mięso; ");
INSERT INTO polubg_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Jest to zastarzały trąd na skórze jego ciała; i kapłan uzna go za nieczystego, a nie odosobni go, gdyż jest nieczysty. ");
INSERT INTO polubg_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","A jeśli trąd rozszerza się na skórze i pokryje całą skórę zarażonego od głowy aż do stóp, gdziekolwiek kapłan spojrzy; ");
INSERT INTO polubg_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Wtedy kapłan obejrzy; a jeśli trąd pokrył całe jego ciało, uzna zarażonego za czystego. Cały zbielał, więc jest czysty. ");
INSERT INTO polubg_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Jednak w dniu, gdy ukaże się na nim żywe mięso, będzie nieczysty. ");
INSERT INTO polubg_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","I kapłan obejrzy żywe mięso i uzna go za nieczystego. Żywe mięso bowiem jest nieczyste. Jest to trąd. ");
INSERT INTO polubg_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Jeśli jednak żywe mięso ustąpi i stanie się białe, wtedy przyjdzie do kapłana. ");
INSERT INTO polubg_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","I kapłan obejrzy go. Jeśli chore miejsce zbielało, kapłan uzna zarażonego za czystego. Jest on czysty. ");
INSERT INTO polubg_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Jeśli zaś na skórze pojawił się wrzód, a potem się zagoił; ");
INSERT INTO polubg_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","A na miejscu tego wrzodu pojawi się białe nabrzmienie lub białoczerwonawa plama, wtedy zostanie pokazana kapłanowi. ");
INSERT INTO polubg_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","I kapłan obejrzy ją, a jeśli z wyglądu jest głębsza niż skóra i włosy na niej zbielały, kapłan uzna go za nieczystego. Jest to plaga trądu, która rozwinęła się na wrzodzie. ");
INSERT INTO polubg_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Jeśli jednak kapłan zobaczy, że nie ma na niej białych włosów i że nie jest głębsza niż skóra, ale pociemniała, wtedy kapłan odosobni go na siedem dni. ");
INSERT INTO polubg_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","A jeśli rozszerza się mocno na skórze, kapłan uzna go za nieczystego. Jest to plaga trądu. ");
INSERT INTO polubg_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Jeśli jednak ta biała plama pozostanie na swoim miejscu i nie rozszerzy się, jest to zapalenie wrzodu; i kapłan uzna go za czystego. ");
INSERT INTO polubg_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Jeśli ktoś ma na skórze oparzelinę i na żywym mięsie pojawi się plama białoczerwonawa lub biała; ");
INSERT INTO polubg_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","To kapłan obejrzy ją. Jeśli włos na plamie zbielał i z wyglądu jest ona głębsza niż skóra, jest to trąd, który rozwinął się na oparzelinie. Kapłan uzna go więc za nieczystego. Jest to plaga trądu. ");
INSERT INTO polubg_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","A jeśli kapłan zobaczy, że na tej plamie nie ma białych włosów ani nie jest ona głębsza niż skóra, ale pociemniała, to kapłan odosobni go na siedem dni. ");
INSERT INTO polubg_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","W siódmym dniu kapłan go obejrzy. Jeśli mocno rozszerzyła się na skórze, kapłan uzna go za nieczystego. Jest to plaga trądu. ");
INSERT INTO polubg_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","A jeśli ta plama pozostanie na swoim miejscu, a nie rozszerzyła się na skórze, ale pociemniała, jest to nabrzmienie po oparzeniu; i kapłan uzna go za czystego. Jest to zapalenie po oparzeniu. ");
INSERT INTO polubg_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Jeśli na głowie lub brodzie mężczyzny albo kobiety pojawi się chore miejsce; ");
INSERT INTO polubg_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","To kapłan obejrzy to miejsce. Jeśli z wyglądu jest głębsze niż skóra i włos na niej jest żółty i cienki, wtedy kapłan uzna takiego za nieczystego. Jest to łuszczyca, trąd na głowie lub na brodzie. ");
INSERT INTO polubg_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Jeśli jednak kapłan obejrzy miejsce tego liszaju, a z wyglądu nie jest ono głębsze niż skóra i nie ma na nim czarnych włosów, to kapłan odosobni dotkniętego plagą liszaju na siedem dni. ");
INSERT INTO polubg_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","W siódmym dniu kapłan obejrzy to miejsce. Jeśli liszaj nie rozszerzył się i nie ma na nim żółtych włosów, i liszaj z wyglądu nie jest głębszy niż skóra; ");
INSERT INTO polubg_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","To ten człowiek będzie ogolony, ale liszaju nie będzie golić; i kapłan odosobni dotkniętego liszajem na kolejne siedem dni. ");
INSERT INTO polubg_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Siódmego dnia kapłan obejrzy ten liszaj. Jeśli liszaj nie rozszerzył się na skórze i z wyglądu nie jest głębszy niż skóra, kapłan uzna go za czystego, a on wypierze swoje ubranie i będzie czysty. ");
INSERT INTO polubg_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","A jeśli liszaj mocno się rozszerzył na skórze po jego oczyszczeniu; ");
INSERT INTO polubg_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","To kapłan obejrzy go. Jeśli liszaj rozszerza się na skórze, kapłan nie będzie już szukał żółtego włosa, jest on nieczysty. ");
INSERT INTO polubg_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Jeśli jednak wydaje mu się, że liszaj pozostał bez zmiany i wyrosły na nim czarne włosy, to liszaj został wyleczony, jest on czysty i kapłan uzna go za czystego. ");
INSERT INTO polubg_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Jeśli u mężczyzny lub kobiety ukażą się na skórze ciała białe plamy; ");
INSERT INTO polubg_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","To kapłan je obejrzy. Jeśli te białe plamy na skórze ich ciała są przyciemnione, jest to wyrzut, który się rozwinął na skórze; jest on czysty. ");
INSERT INTO polubg_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Także mężczyzna, któremu włosy wypadły z głowy, jest łysy, ale czysty. ");
INSERT INTO polubg_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","A jeśli wypadły mu włosy z przodu głowy, to ma łyse czoło, ale jest czysty. ");
INSERT INTO polubg_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Jeśli jednak na łysinie albo na łysym czole pojawi się białoczerwonawa rana, jest to trąd, który się rozwinął na jego łysinie albo na łysym czole. ");
INSERT INTO polubg_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","I kapłan go obejrzy. Jeśli nabrzmienie rany jest białoczerwonawe na jego łysinie albo na łysym czole, jak wygląda trąd na skórze ciała; ");
INSERT INTO polubg_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","To taki człowiek jest trędowaty, jest on nieczysty. I kapłan uzna go za całkowicie nieczystego, bo na jego głowie jest jego trąd. ");
INSERT INTO polubg_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Trędowaty zaś, który ma na sobie tę plagę, będzie miał rozdarte szaty, jego głowa będzie odkryta, zakryje sobie usta i będzie wołał: Nieczysty! Nieczysty! ");
INSERT INTO polubg_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Przez wszystkie dni, póki jest na nim plaga, będzie skalany, bo jest nieczysty. Będzie mieszkał sam; jego mieszkanie będzie poza obozem. ");
INSERT INTO polubg_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Jeśli też na szacie będzie plaga trądu, na szacie wełnianej lub lnianej; ");
INSERT INTO polubg_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Czy to na osnowie, czy na wątku z lnu lub wełny, czy też na skórze, czy na jakimkolwiek wyrobie skórzanym; ");
INSERT INTO polubg_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","A będzie to plaga zielonkawa albo czerwonawa na szacie lub na skórze, na osnowie lub na wątku, lub na jakimkolwiek przedmiocie skórzanym, jest to plaga trądu i będzie pokazana kapłanowi. ");
INSERT INTO polubg_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kapłan obejrzy tę plagę i odosobni zarażoną rzecz na siedem dni. ");
INSERT INTO polubg_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","W siódmym dniu obejrzy tę plagę. Jeśli plaga rozszerzyła się na szacie czy na osnowie albo wątku, na skórze lub na jakimś przedmiocie wykonanym ze skóry, jest to plaga trądu złośliwego, przedmiot jest nieczysty. ");
INSERT INTO polubg_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Spali więc tę szatę czy osnowę albo wątek, czy to z wełny, czy z lnu, czy z jakiegokolwiek przedmiotu skórzanego, na którym jest plaga. Jest to bowiem trąd złośliwy, będzie spalony w ogniu. ");
INSERT INTO polubg_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Jeśli jednak kapłan zobaczy, że ta plaga nie rozszerzyła się na szacie ani na osnowie, ani na wątku, ani na jakimkolwiek przedmiocie skórzanym; ");
INSERT INTO polubg_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","To kapłan rozkaże, aby wyprano to, na czym jest plaga, i odosobni to na kolejne siedem dni. ");
INSERT INTO polubg_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","I kapłan obejrzy plagę po wypraniu. Jeśli ta plaga nie zmieniła swojej barwy, choćby plaga nie rozszerzyła się, to jest to rzecz nieczysta, spalisz ją w ogniu; rzecz jest przeżarta bądź z wierzchniej, bądź ze spodniej strony. ");
INSERT INTO polubg_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Jeśli jednak kapłan zobaczy, że po wypraniu plaga pociemniała, oderwie ją z szaty lub ze skóry czy z osnowy, czy z wątku. ");
INSERT INTO polubg_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","A jeśli nadal będzie widoczna na szacie czy na osnowie lub na wątku, albo na jakimś przedmiocie skórzanym, jest to szerzący się trąd. Spalisz w ogniu to, na czym jest ta plaga. ");
INSERT INTO polubg_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Szatę zaś lub osnowę czy wątek albo każdy przedmiot skórzany, z którego po wypraniu odeszłaby plaga, wypierzesz powtórnie i będzie to czyste. ");
INSERT INTO polubg_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","To jest prawo dotyczące plagi trądu na szacie wełnianej lub lnianej czy na osnowie, czy wątku albo na jakimkolwiek przedmiocie skórzanym, aby uznać je za czyste lub nieczyste. ");
INSERT INTO polubg_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Takie będzie prawo dotyczące trędowatego w dniu jego oczyszczenia: będzie przyprowadzony do kapłana. ");
INSERT INTO polubg_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","A kapłan wyjdzie poza obóz. Jeśli kapłan zobaczy, że plaga trądu została uleczona na trędowatym; ");
INSERT INTO polubg_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","To kapłan każe, by wziąć dla oczyszczającego się dwa żywe i czyste ptaki, drewno cedrowe, karmazyn i hizop. ");
INSERT INTO polubg_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","I kapłan każe zabić jednego ptaka nad naczyniem glinianym, nad wodą źródlaną. ");
INSERT INTO polubg_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Następnie weźmie żywego ptaka, drewno cedrowe, karmazyn i hizop i umoczy to wszystko z żywym ptakiem we krwi ptaka zabitego nad źródlaną wodą. ");
INSERT INTO polubg_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","I pokropi siedem razy oczyszczającego się od trądu, i uzna go za czystego, a żywego ptaka wypuści na otwarte pole. ");
INSERT INTO polubg_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ten, który się poddaje oczyszczeniu, upierze swoje szaty, ogoli wszystkie swoje włosy, umyje się wodą i będzie czysty. Potem wejdzie do obozu i będzie mieszkał przez siedem dni poza swoim namiotem. ");
INSERT INTO polubg_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","A siódmego dnia ogoli wszystkie swoje włosy, głowę, brodę i brwi nad swoimi oczami i ogoli wszystkie inne włosy. Potem wypierze swoje szaty i obmyje swoje ciało w wodzie, i będzie czysty. ");
INSERT INTO polubg_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Ósmego dnia weźmie dwa baranki bez skazy i jedną owcę jednoroczną bez skazy, trzy dziesiąte efy mąki pszennej zmieszanej z oliwą na ofiarę pokarmową i jeden log oliwy. ");
INSERT INTO polubg_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","A kapłan dokonujący oczyszczenia postawi człowieka, który ma być oczyszczony, oraz to wszystko przed PANEM, u wejścia do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Potem kapłan weźmie jednego baranka i złoży go w ofierze za przewinienie wraz z logiem oliwy, i będzie to kołysał na ofiarę kołysania przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Potem zabije tego baranka na miejscu, gdzie się zabija ofiarę za grzech i ofiarę całopalną, na miejscu świętym. Zarówno bowiem ofiara za grzech, jak i ofiara za przewinienie należą do kapłana. Jest to rzecz najświętsza. ");
INSERT INTO polubg_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Następnie kapłan weźmie nieco krwi z ofiary za przewinienie i pomaże nią koniuszek prawego ucha oczyszczającego się, kciuk jego prawej ręki i wielki palec jego prawej nogi. ");
INSERT INTO polubg_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Kapłan weźmie też nieco z logu oliwy i wyleje na swoją lewą dłoń; ");
INSERT INTO polubg_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","I umoczy swój prawy palec w oliwie, która jest na jego lewej dłoni, i tym palcem pokropi oliwą siedem razy przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","A z reszty oliwy, która jest na jego dłoni, kapłan pomaże koniuszek prawego ucha oczyszczającego się, kciuk jego prawej ręki i wielki palec jego prawej nogi nad miejscem pomazanym krwią ofiary za przewinienie. ");
INSERT INTO polubg_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","A resztę oliwy, która jest na dłoni kapłana, wyleje na głowę oczyszczającego się. Tak kapłan dokona za niego przebłagania przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Kapłan złoży także ofiarę za grzech i dokona przebłagania za oczyszczającego się ze swojej nieczystości, po czym zabije ofiarę całopalną. ");
INSERT INTO polubg_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","I kapłan złoży na ołtarzu ofiarę całopalną i ofiarę pokarmową. Tak kapłan dokona za niego przebłagania i będzie on czysty. ");
INSERT INTO polubg_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Jeśli jednak jest on tak ubogi, że nie stać go na to, wtedy weźmie jednego baranka na ofiarę za przewinienie, na kołysanie, by dokonano za niego przebłagania, i jedną dziesiątą efy mąki pszennej zmieszanej z oliwą na ofiarę pokarmową oraz log oliwy; ");
INSERT INTO polubg_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","I dwie synogarlice albo dwa młode gołębie, na co go stać; jeden będzie na ofiarę za grzech, a drugi na ofiarę całopalną; ");
INSERT INTO polubg_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","I przyniesie je ósmego dnia dla swego oczyszczenia do kapłana, przed wejście do Namiotu Zgromadzenia przed PANA. ");
INSERT INTO polubg_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kapłan weźmie baranka na ofiarę za przewinienie oraz log oliwy i kapłan będzie to kołysał na ofiarę kołysania przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Potem zabije baranka na ofiarę za przewinienie i kapłan weźmie nieco krwi ofiary za przewinienie, i pomaże koniuszek prawego ucha oczyszczającego się, kciuk jego prawej ręki i wielki palec jego prawej nogi. ");
INSERT INTO polubg_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Kapłan naleje także oliwy na swoją lewą dłoń. ");
INSERT INTO polubg_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","I oliwą, która jest na jego lewej dłoni, kapłan będzie kropić siedem razy swoim prawym palcem przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Kapłan też pomaże tą oliwą, która jest na jego dłoni, koniuszek prawego ucha oczyszczającego się, kciuk jego prawej ręki i wielki palec jego prawej nogi nad miejscem pomazanym krwią ofiary za przewinienie. ");
INSERT INTO polubg_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","A resztą oliwy, która jest na dłoni kapłana, pomaże głowę oczyszczającego się, aby dokonać za niego przebłagania przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Potem złoży jedną synogarlicę albo jednego młodego gołębia, na co go było stać. ");
INSERT INTO polubg_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Z tego, na co go stać, jedno będzie na ofiarę za grzech, a drugie na ofiarę całopalną razem z ofiarą pokarmową. I tak kapłan dokona przebłagania za oczyszczającego się przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","To jest prawo dotyczące tego, na którym będzie plaga trądu, a którego nie stać na ofiarę za swoje oczyszczenie. ");
INSERT INTO polubg_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Potem PAN powiedział do Mojżesza i Aarona: ");
INSERT INTO polubg_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Gdy wejdziecie do ziemi Kanaan, którą daję wam w posiadanie, a ja dopuszczę plagę trądu na jakimś domu z waszej posiadłości; ");
INSERT INTO polubg_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","To właściciel domu przyjdzie i powie kapłanowi: Zdaje mi się, jakby plaga trądu jest w moim domu. ");
INSERT INTO polubg_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Wówczas kapłan każe opróżnić dom, zanim sam wejdzie, aby obejrzeć tę plagę, żeby się nie zanieczyściło to wszystko, co jest w domu. Potem kapłan wejdzie, aby obejrzeć ten dom. ");
INSERT INTO polubg_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","I obejrzy tę plagę. Jeśli zobaczy na ścianach domu, że plaga występuje jak dołki zielonkawe lub czerwonawe, które wydają się być głębsze niż ściana; ");
INSERT INTO polubg_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Wtedy kapłan wyjdzie przed drzwi tego domu i zamknie ten dom na siedem dni. ");
INSERT INTO polubg_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Siódmego dnia kapłan wróci i obejrzy. Jeśli plaga rozszerzyła się na ścianach tego domu; ");
INSERT INTO polubg_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Kapłan każe wyrwać te kamienie, na których jest plaga, i wyrzucić je poza miasto na miejsce nieczyste; ");
INSERT INTO polubg_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","A dom każe oskrobać wewnątrz dokoła; i wysypią proch, który oskrobali, poza miasto na miejsce nieczyste; ");
INSERT INTO polubg_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Potem wezmą inne kamienie i wstawią je na miejsce tamtych kamieni; wezmą też inny tynk i otynkują dom. ");
INSERT INTO polubg_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","A jeśli ta plaga się odnowi i rozszerzy się w domu po wyrzuceniu kamienia, po oskrobaniu domu i po jego otynkowaniu; ");
INSERT INTO polubg_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Wtedy wejdzie kapłan i obejrzy. Jeśli zobaczy, że plaga się rozszerzyła w domu, jest to złośliwy trąd w tym domu. Jest on nieczysty. ");
INSERT INTO polubg_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Potem zburzy ten dom, jego kamienie, jego drewno i cały tynk tego domu, i wyniesie poza miasto na miejsce nieczyste. ");
INSERT INTO polubg_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","A kto by wszedł do tego domu podczas jego zamknięcia, będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Kto by spał w tym domu, wypierze swoje szaty, a kto by jadł w tym domu, wypierze swoje szaty. ");
INSERT INTO polubg_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Lecz jeśli kapłan wejdzie i zobaczy, że plaga nie szerzy się w domu po jego tynkowaniu, to kapłan uzna, że ten dom jest czysty, gdyż plaga została uleczona. ");
INSERT INTO polubg_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","A weźmie na oczyszczenie tego domu dwa ptaki, drewno cedrowe, karmazyn i hizop; ");
INSERT INTO polubg_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","I zabije jednego ptaka nad glinianym naczyniem, nad wodą źródlaną; ");
INSERT INTO polubg_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Potem weźmie drewno cedrowe, hizop, karmazyn oraz żywego ptaka i umoczy to wszystko we krwi zabitego ptaka i w źródlanej wodzie i pokropi ten dom siedem razy. ");
INSERT INTO polubg_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","I tak oczyści ten dom krwią tego ptaka, źródlaną wodą, żywym ptakiem, drewnem cedrowym, hizopem i karmazynem. ");
INSERT INTO polubg_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Żywego zaś ptaka wypuści poza miasto na otwarte pole. Tak dokona przebłagania za ten dom i będzie on czysty. ");
INSERT INTO polubg_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Takie jest prawo dotyczące każdej plagi trądu i liszaju: ");
INSERT INTO polubg_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","Trądu na ubraniu i w domu; ");
INSERT INTO polubg_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Nabrzmienia, wysypki i białej plamy; ");
INSERT INTO polubg_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Aby pouczać, kiedy coś jest nieczyste, a kiedy czyste. To jest prawo dotyczące trądu. ");
INSERT INTO polubg_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Potem PAN powiedział do Mojżesza i Aarona: ");
INSERT INTO polubg_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Przemówcie do synów Izraela i powiedzcie im: Jeśli mężczyzna ma wyciek ze swego ciała, to jest on nieczysty. ");
INSERT INTO polubg_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","A na tym będzie polegała nieczystość jego wycieku: Jeśli jego ciało wypuszcza wyciek albo jeśli jego ciało zatrzymuje wyciek, to jest jego nieczystość. ");
INSERT INTO polubg_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Każde posłanie, na którym będzie leżał chory na wyciek, będzie nieczyste, i wszystko, na czym usiądzie, będzie nieczyste. ");
INSERT INTO polubg_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Kto dotknie jego posłania, wypierze swoje szaty i umyje się w wodzie, i będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","A kto usiądzie na tym, na czym siedział chory na wyciek, wypierze swoje szaty i umyje się w wodzie, i będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","A kto dotknie ciała mężczyzny chorego na wyciek, wypierze swoje szaty i umyje się w wodzie, i będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","A jeśli chory na wyciek plunie na człowieka czystego, ten wypierze swoje szaty i umyje się w wodzie, i będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Każde też siodło, na którym będzie siedział chory na wyciek, będzie nieczyste. ");
INSERT INTO polubg_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Kto dotknie jakiejkolwiek rzeczy, która była pod nim, będzie nieczysty aż do wieczora. A kto przenosi cokolwiek z tego, wypierze swoje szaty i umyje się w wodzie, i będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Każdy też, kogo dotknie chory na wyciek, który nie umył swoich rąk w wodzie, wypierze swoje szaty i umyje się w wodzie, i będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","A naczynie gliniane, którego dotknie chory na wyciek, będzie stłuczone, a każde drewniane naczynie będzie umyte wodą. ");
INSERT INTO polubg_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","A gdy chory na wyciek zostanie oczyszczony od swego wycieku, odliczy sobie siedem dni na swoje oczyszczenie, wypierze swe szaty i obmyje swoje ciało źródlaną wodą, i będzie czysty. ");
INSERT INTO polubg_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ósmego dnia weźmie sobie dwie synogarlice albo dwa młode gołębie, przyjdzie przed PANA do wejścia do Namiotu Zgromadzenia i odda je kapłanowi. ");
INSERT INTO polubg_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","A kapłan złoży je w ofierze: jednego na ofiarę za grzech, a drugiego na ofiarę całopalną. Tak dokona kapłan przebłagania za niego przed PANEM z powodu jego wycieku. ");
INSERT INTO polubg_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Jeśli mężczyźnie wypłynie nasienie obcowania, obmyje w wodzie całe swe ciało i będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Każda też szata i każda skóra, na których będzie nasienie obcowania, będą wyprane wodą i będą nieczyste aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Dotyczy to także kobiety, z którą obcuje mężczyzna mający wypływ nasienia obcowania: oboje umyją się w wodzie i będą nieczyści aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","A jeśli kobieta ma upływ, a jest to upływ krwi z jej ciała, to przez siedem dni będzie w swojej nieczystości. Każdy, kto jej dotknie, będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Wszystko, na czym się położy w trakcie swojej nieczystości, będzie nieczyste. Wszystko, na czym usiądzie, będzie nieczyste. ");
INSERT INTO polubg_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Każdy, kto dotknie jej posłania, wypierze swoje szaty i umyje się wodą, i będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Każdy, kto dotknie tego, na czym siedziała, wypierze swoje szaty i umyje się wodą, i będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Jeśli coś było na jej posłaniu albo na czymkolwiek siedziała, a ktoś tego dotknie, będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","A jeśli mężczyzna położy się z nią, a jej nieczystość będzie na nim, to będzie on nieczysty przez siedem dni i każde posłanie, na którym się położy, będzie nieczyste. ");
INSERT INTO polubg_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Jeśli kobieta będzie miała upływ krwi przez wiele dni poza czasem swej nieczystości albo jeśli upływ krwi będzie trwał dłużej niż czas jej odłączenia, wtedy będzie nieczysta przez wszystkie dni upływu jej nieczystości jak w czasie jej odłączenia. ");
INSERT INTO polubg_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Każde posłanie, na którym się położy przez wszystkie dni swojego upływu, będzie dla niej jak posłanie jej odłączenia. I wszystko, na czym usiądzie, będzie nieczyste tak jak nieczystość jej odłączenia. ");
INSERT INTO polubg_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ktokolwiek dotknie tych rzeczy, będzie nieczysty, i wypierze swoje szaty, i umyje się w wodzie, i będzie nieczysty aż do wieczora. ");
INSERT INTO polubg_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","A gdy będzie oczyszczona ze swego upływu, odliczy sobie siedem dni, a potem będzie czysta. ");
INSERT INTO polubg_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","A dnia ósmego weźmie sobie dwie synogarlice lub dwa młode gołębie i przyniesie je kapłanowi przed wejście do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","A kapłan złoży jednego na ofiarę za grzech i drugiego na ofiarę całopalną: tak dokona kapłan przebłagania za nią przed PANEM z powodu upływu jej nieczystości. ");
INSERT INTO polubg_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Tak będziecie odłączać synów Izraela od ich nieczystości, aby nie pomarli w swojej nieczystości, gdy zanieczyszczają mój przybytek, który jest wśród nich. ");
INSERT INTO polubg_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Takie jest prawo dotyczące tego, który ma wyciek i z którego wypływa nasienie spółkowania, przez co staje się nieczysty; ");
INSERT INTO polubg_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Oraz kobiety w czasie jej nieczystości i osoby, która ma wyciek, tak mężczyzny, jak i niewiasty, i mężczyzny, który się położy z kobietą nieczystą. ");
INSERT INTO polubg_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Potem PAN mówił do Mojżesza po śmierci dwóch synów Aarona, którzy umarli, gdy złożyli ofiarę przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","I PAN powiedział do Mojżesza: Powiedz swojemu bratu Aaronowi, żeby nie wchodził w każdym czasie do Miejsca Świętego poza zasłonę przed przebłagalnią, która jest na arce, aby nie umarł. W obłoku bowiem będę się ukazywać nad przebłagalnią. ");
INSERT INTO polubg_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Oto w taki sposób Aaron będzie wchodzić do Świętego Miejsca: z młodym cielcem na ofiarę za grzech i z baranem na całopalenie. ");
INSERT INTO polubg_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ubierze się w świętą lnianą tunikę, na ciele będzie miał lniane spodnie, opasze się lnianym pasem i włoży na głowę lnianą mitrę. To są święte szaty; obmyje więc swoje ciało w wodzie i założy je. ");
INSERT INTO polubg_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","A od zgromadzenia synów Izraela weźmie dwa kozły na ofiarę za grzech i jednego baranka na całopalenie. ");
INSERT INTO polubg_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","I Aaron złoży swego cielca na ofiarę za grzech za siebie samego, i dokona przebłagania za siebie i swój dom. ");
INSERT INTO polubg_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Weźmie też dwa kozły i postawi je przed PANEM u wejścia do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","I Aaron rzuci losy o dwa kozły, jeden los dla PANA, a drugi los dla kozła ofiarnego. ");
INSERT INTO polubg_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","I przyprowadzi Aaron tego kozła, na którego padł los dla PANA, i złoży go w ofierze za grzech. ");
INSERT INTO polubg_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ale kozła, na którego padł los dla kozła ofiarnego, postawi żywego przed PANEM, aby nim dokonać przebłagania i wypuścić go na pustynię jako kozła ofiarnego. ");
INSERT INTO polubg_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","I przyprowadzi Aaron cielca na ofiarę za grzech za siebie samego, i dokona przebłagania za siebie i swój dom, i zabije cielca na ofiarę za grzech za siebie samego. ");
INSERT INTO polubg_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Następnie weźmie pełną kadzielnicę węgla rozpalonego z ołtarza przed PANEM oraz dwie pełne garści wonnego utłuczonego kadzidła i wniesie poza zasłonę. ");
INSERT INTO polubg_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","I nasypie kadzidło na ogień przed PANEM, aby obłok kadzidła okrył przebłagalnię, która jest nad arką, aby nie umarł. ");
INSERT INTO polubg_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Potem weźmie z krwi tego cielca i pokropi swym palcem nad przebłagalnią ku wschodowi. Przed przebłagalnią będzie kropić tą krwią siedem razy swym palcem. ");
INSERT INTO polubg_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Następnie zabije kozła na ofiarę za grzech za lud i wniesie jego krew poza zasłonę, i uczyni z jego krwią, jak uczynił z krwią cielca: pokropi nią nad przebłagalnią i przed przebłagalnią. ");
INSERT INTO polubg_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Tak dokona przebłagania nad Miejscem Świętym za nieczystości synów Izraela, za ich przestępstwa i za wszystkie ich grzechy. Tak też uczyni z Namiotem Zgromadzenia, który jest wśród nich, pośrodku ich nieczystości. ");
INSERT INTO polubg_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","A żaden człowiek nie może przebywać w Namiocie Zgromadzenia, gdy on będzie wchodzić do Miejsca Świętego, by dokonać przebłagania, aż wyjdzie i dokona przebłagania sam za siebie, swój dom i za całe zgromadzenie Izraela. ");
INSERT INTO polubg_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Potem wyjdzie do ołtarza, który jest przed PANEM, i dokona za niego przebłagania: weźmie nieco krwi cielca i krwi kozła i pomaże rogi ołtarza dokoła. ");
INSERT INTO polubg_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Pokropi go z wierzchu tą krwią swym palcem siedem razy, oczyści go i poświęci go od nieczystości synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","A gdy dokona przebłagania za Miejsce Święte, Namiot Zgromadzenia i ołtarz, przyprowadzi żywego kozła. ");
INSERT INTO polubg_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","I Aaron położy obie ręce na głowie żywego kozła, wyznawać będzie nad nim wszystkie nieprawości synów Izraela i wszystkie ich przestępstwa ze wszystkimi ich grzechami i złoży je na głowę tego kozła, i wypuści go przez wyznaczonego człowieka na pustynię. ");
INSERT INTO polubg_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Tak poniesie ten kozioł na sobie wszystkie ich nieprawości do ziemi pustej. I wypuści tego kozła na pustynię. ");
INSERT INTO polubg_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Potem Aaron wejdzie do Namiotu Zgromadzenia, zdejmie z siebie lniane szaty, które włożył, gdy wszedł do Miejsca Świętego, i zostawi je tam. ");
INSERT INTO polubg_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Obmyje też swoje ciało w wodzie na Miejscu Świętym i włoży swoje szaty, wyjdzie i złoży swoje całopalenie i całopalenie ludu i dokona przebłagania za siebie i za lud. ");
INSERT INTO polubg_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","A tłuszcz ofiary za grzech spali na ołtarzu. ");
INSERT INTO polubg_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","A ten, który wypuścił kozła jako kozła ofiarnego, wypierze swoje szaty i obmyje swoje ciało w wodzie, potem wejdzie do obozu. ");
INSERT INTO polubg_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Cielca zaś ofiary za grzech i kozła ofiary za grzech, których krew została wniesiona do Miejsca Świętego dla przebłagania, wyniosą poza obóz i spalą w ogniu ich skóry, ich mięso i ich gnój. ");
INSERT INTO polubg_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","A ten, który je spali, wypierze swoje szaty i obmyje swoje ciało w wodzie, potem wejdzie do obozu. ");
INSERT INTO polubg_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","To będzie dla was wieczną ustawą: W dziesiątym dniu tego siódmego miesiąca będziecie trapić swoje dusze i nie będziecie wykonywać żadnej pracy, zarówno rodowity mieszkaniec, jak i przybysz, który gości wśród was; ");
INSERT INTO polubg_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Bo w tym dniu kapłan dokona za was przebłagania, aby was oczyścić od wszystkich waszych grzechów, abyście byli oczyszczeni przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Będzie to dla was szabatem odpoczynku i będziecie trapić wasze dusze ustawą wieczną. ");
INSERT INTO polubg_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","A dokona przebłagania kapłan, który jest namaszczony i poświęcony do pełnienia służby na miejsce swego ojca, a włoży lniane szaty, szaty święte; ");
INSERT INTO polubg_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","I dokona przebłagania za Miejsce Najświętsze i Namiot Zgromadzenia, i za ołtarz, dokona też przebłagania za kapłanów i cały lud zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","I będzie to dla was wieczną ustawą, aby raz w roku dokonywać za synów Izraela przebłagania za wszystkie ich grzechy. I uczynił Mojżesz tak, jak mu PAN rozkazał. ");
INSERT INTO polubg_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Wtedy PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Mów do Aarona i do jego synów, i do wszystkich synów Izraela i powiedz im: Oto co PAN nakazał: ");
INSERT INTO polubg_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ktokolwiek z domu Izraela zabije wołu, owcę albo kozę w obozie lub zabije je poza obozem; ");
INSERT INTO polubg_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","A nie przyprowadzi tego przed wejście do Namiotu Zgromadzenia, aby złożyć w ofierze PANU przed przybytkiem PANA, to będzie on winien krwi, bo przelał krew. Ten człowiek zostanie wykluczony spośród swego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ma tak być, aby synowie Izraela przyprowadzili swoje ofiary, które dotychczas zabijali na polu, by przyprowadzili je do PANA przed wejście do Namiotu Zgromadzenia, do kapłana, i złożyli je jako ofiary pojednawcze PANU. ");
INSERT INTO polubg_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Kapłan pokropi krwią ołtarz PANA u wejścia do Namiotu Zgromadzenia, a tłuszcz spali jako miłą woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","I nie będą już więcej składać swoich ofiar demonom, z którymi uprawiali nierząd. To będzie dla nich wieczna ustawa przez wszystkie ich pokolenia. ");
INSERT INTO polubg_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Powiedz im jeszcze: Jeśli ktokolwiek z domu Izraela albo z przybyszów mieszkających wśród was będzie składał całopalenie lub inną ofiarę; ");
INSERT INTO polubg_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","A nie przyprowadzi jej przed wejście do Namiotu Zgromadzenia, aby ją złożyć PANU, to człowiek ten będzie wykluczony ze swego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","A gdyby ktokolwiek z domu Izraela lub z przybyszów, którzy goszczą wśród was, spożywał jakąkolwiek krew, to zwrócę swoje oblicze przeciw człowiekowi, który spożywa krew, i wykluczę go spośród jego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Życie wszelkiego ciała bowiem jest we krwi. Ja dałem ją wam na ołtarz dla dokonywania przebłagania za wasze dusze, gdyż to krew dokonuje przebłagania za duszę. ");
INSERT INTO polubg_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Dlatego powiedziałem synom Izraela: Żadna dusza wśród was nie będzie spożywała krwi ani żaden przybysz, który gości wśród was, nie będzie spożywał krwi. ");
INSERT INTO polubg_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","I ktokolwiek z synów Izraela lub z przybyszów, którzy goszczą wśród was, upoluje jakieś zwierzę lub ptaka, które wolno jeść, to wypuści jego krew i przykryje ją piaskiem. ");
INSERT INTO polubg_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Gdyż to jest życie wszelkiego ciała, krew stanowi jego życie. Dlatego powiedziałem synom Izraela: Krwi wszelkiego ciała spożywać nie będziecie, bo życiem wszelkiego ciała jest jego krew. Ktokolwiek ją spożywa, zostanie wytracony. ");
INSERT INTO polubg_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Każda dusza, która spożywa zwierzę padłe lub rozszarpane, czy to rodowity mieszkaniec, czy przybysz, wypierze swoje szaty i obmyje się w wodzie, i będzie nieczysta aż do wieczora. Potem będzie czysta. ");
INSERT INTO polubg_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ale jeśli nie wypierze swoich szat ani nie obmyje swego ciała, obciąży się nieprawością. ");
INSERT INTO polubg_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","PAN powiedział jeszcze do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Przemów do synów Izraela i powiedz im: Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Nie czyńcie według zwyczajów ziemi Egiptu, w której mieszkaliście, ani według zwyczajów ziemi Kanaan, do której was prowadzę, też nie czyńcie, a według ich ustaw nie postępujcie. ");
INSERT INTO polubg_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Wypełniajcie moje prawa i przestrzegajcie moich ustaw, abyście postępowali według nich. Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Przestrzegajcie więc moich ustaw i moich praw, bo jeśli człowiek je wypełnia, będzie przez nie żył. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Nikt z was nie będzie zbliżał się do swojego krewnego, by odsłonić jego nagość. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Nie będziesz odsłaniał nagości swego ojca lub matki; ona jest twoją matką, nie odkryjesz jej nagości. ");
INSERT INTO polubg_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Nie będziesz odsłaniał nagości żony twego ojca; to jest nagość twego ojca. ");
INSERT INTO polubg_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Nie będziesz odsłaniał nagości córki twego ojca lub córki twojej matki, czy urodziła się w domu, czy poza domem – nie odkryjesz ich nagości. ");
INSERT INTO polubg_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Nie będziesz odsłaniał nagości córki twego syna lub nagości córki twojej córki, bo są one twoją nagością. ");
INSERT INTO polubg_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Nie będziesz odsłaniał nagości córki żony twego ojca, która się narodziła z twego ojca, bo ona jest twoją siostrą, nie odkryjesz jej nagości. ");
INSERT INTO polubg_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Nie będziesz odsłaniał nagości siostry twego ojca, bo jest ona bliską krewną twego ojca. ");
INSERT INTO polubg_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Nie będziesz odsłaniał nagości siostry twojej matki, bo ona jest bliską krewną twojej matki. ");
INSERT INTO polubg_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Nie będziesz odsłaniał nagości brata twego ojca, nie zbliżysz się do jego żony; ona jest twoją ciocią. ");
INSERT INTO polubg_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Nie będziesz odsłaniał nagości twojej synowej; ona jest żoną twego syna, nie odkryjesz jej nagości. ");
INSERT INTO polubg_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Nie będziesz odsłaniał nagości żony twego brata, bo to jest nagość twego brata. ");
INSERT INTO polubg_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Nie będziesz odsłaniał nagości kobiety i jej córki; nie weźmiesz córki jej syna ani córki jej córki, aby odkryć jej nagość, bo są one jej bliskimi krewnymi. Jest to niegodziwość. ");
INSERT INTO polubg_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Nie weźmiesz siostry twej żony, abyś jej nie trapił, odsłaniając jej nagość za jej życia. ");
INSERT INTO polubg_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Nie zbliżaj się do kobiety, aby odsłaniać jej nagość w czasie jej odłączenia z powodu nieczystości. ");
INSERT INTO polubg_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Nie będziesz obcował z żoną twego bliźniego, bo stałbyś się nią nieczysty. ");
INSERT INTO polubg_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Nie pozwalaj żadnemu z twoich potomków przejść przez ogień dla Molocha, abyś nie bezcześcił imienia twego Boga. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Nie będziesz obcował z mężczyzną jak z kobietą. Jest to obrzydliwość. ");
INSERT INTO polubg_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Nie będziesz też obcował z żadnym zwierzęciem, bo stałbyś się tym nieczysty. Kobieta nie będzie stawać przed zwierzęciem w celu obcowania z nim. Jest to zboczenie. ");
INSERT INTO polubg_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Nie kalajcie się tym wszystkim, gdyż tym wszystkim kalały się narody, które wypędzam przed wami. ");
INSERT INTO polubg_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Także i ziemia stała się skalana. Nawiedziłem więc jej nieprawość w niej i ziemia zwymiotowała swoich mieszkańców. ");
INSERT INTO polubg_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Przestrzegajcie więc moich ustaw i moich praw i nie dopuszczajcie się żadnych z tych obrzydliwości, ani rodowity mieszkaniec, ani przybysz, który gości wśród was; ");
INSERT INTO polubg_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(Wszystkich bowiem tych obrzydliwości dopuszczali się ludzie tej ziemi, którzy byli przed wami, i ziemia stała się skalana); ");
INSERT INTO polubg_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Aby was ziemia nie zwymiotowała, gdy ją zanieczyścicie, jak zwymiotowała narody, które były przed wami. ");
INSERT INTO polubg_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Bo ktokolwiek dopuści się jakiejś z tych wszystkich obrzydliwości, wszyscy, którzy tak czynią, zostaną wykluczeni spośród swego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Przestrzegajcie więc moich ustaw, aby nie czynić żadnego z obrzydliwych zwyczajów, które były czynione przed wami, abyście nie skalali się nimi. Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Przemów do całego zgromadzenia synów Izraela i powiedz im: Bądźcie święci, bo ja, PAN, wasz Bóg, jestem święty. ");
INSERT INTO polubg_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Niech każdy z was boi się swojej matki i swojego ojca i niech przestrzega moich szabatów. Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Nie będziecie się zwracać do bożków i nie czyńcie sobie odlewanych bogów. Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","A gdy będziecie składać PANU ofiarę pojednawczą, składajcie ją dobrowolnie. ");
INSERT INTO polubg_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Będziecie ją spożywali w dniu, w którym ją złożycie w ofierze, i nazajutrz. A co pozostanie do trzeciego dnia, będzie spalone w ogniu. ");
INSERT INTO polubg_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","A jeśli spożyjecie ją trzeciego dnia, będzie obrzydliwa i nie zostanie przyjęta. ");
INSERT INTO polubg_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ktokolwiek ją spożyje, obciąży się nieprawością, bo zbezcześcił świętość PANA. Ta dusza będzie wykluczona spośród swego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Gdy będziecie żąć zboża waszej ziemi, nie będziesz żął swego pola do samego skraju ani nie będziesz zbierał pokłosia po swoim żniwie. ");
INSERT INTO polubg_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Także gron swej winnicy nie będziesz obierał całkowicie i nie zbieraj z winnicy winogron, które upadły; zostawisz je dla ubogiego i przybysza. Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Nie będziecie kraść, nie będziecie oszukiwać i nie będziecie okłamywać jeden drugiego. ");
INSERT INTO polubg_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Nie będziecie przysięgać fałszywie na moje imię i nie będziecie bezcześcić imienia swego Boga. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Nie będziesz uciskać swego bliźniego i nie będziesz go wyzyskiwać. Zapłata najemnika nie zostanie u ciebie aż do rana. ");
INSERT INTO polubg_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Nie będziesz złorzeczył głuchemu, a przed ślepym nie będziesz stawiał przeszkody, ale będziesz się bał swego Boga. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Nie będziesz postępował niesłusznie w sądzie. Nie będziesz miał względu na osobę ubogiego i nie wyróżniaj osoby bogatego. Sprawiedliwie będziesz sądził swego bliźniego. ");
INSERT INTO polubg_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Nie będziesz szerzył oszczerstw wśród swego ludu. Nie będziesz nastawał na krew swego bliźniego. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Nie będziesz w swoim sercu nienawidził swego brata. Będziesz upominał swego bliźniego i nie zniesiesz u niego grzechu. ");
INSERT INTO polubg_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Nie będziesz się mścił i nie będziesz chować urazy do synów swego ludu, lecz będziesz miłował swego bliźniego jak samego siebie. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Będziesz przestrzegać moich ustaw. Nie będziesz parzył swego bydła z bydłem innego rodzaju. Nie będziesz obsiewał swego pola dwoma rodzajami ziarna. Także nie będziesz wkładał na siebie szaty utkanej z dwóch różnych przędzy, jak z wełny i lnu. ");
INSERT INTO polubg_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Jeśli mężczyzna obcuje z kobietą, która jest niewolnicą, poślubioną mężowi, lecz jeszcze niewykupioną ani nieobdarzoną wolnością, oboje będą karani, ale nie zostaną zabici, ponieważ nie była wolna. ");
INSERT INTO polubg_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","I przyprowadzi PANU ofiarę za swoje przewinienie przed wejście do Namiotu Zgromadzenia, to jest barana za przewinienie. ");
INSERT INTO polubg_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Wówczas kapłan dokona przed PANEM przebłagania za niego przez barana za przewinienie za jego grzech, którego się dopuścił. I będzie mu odpuszczony jego grzech, który popełnił. ");
INSERT INTO polubg_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","A gdy wejdziecie do ziemi i zasadzicie wszelkie drzewa dające owoc, wtedy będziecie uważać ich owoce za nieobrzezane. Przez trzy lata będziecie je mieć za nieobrzezane, nie będziecie ich jeść. ");
INSERT INTO polubg_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Lecz w czwartym roku wszystkie ich owoce będą poświęcone jako ofiara na chwałę PANA. ");
INSERT INTO polubg_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","A w piątym roku będziecie jeść ich owoc, aby mnożył się wam jego urodzaj. Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Nie będziecie jeść niczego z krwią. Nie będziecie uprawiać wróżbiarstwa ani czarów. ");
INSERT INTO polubg_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Nie będziecie obcinać włosów dokoła waszej głowy ani nie będziecie przycinać końców swojej brody. ");
INSERT INTO polubg_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Nie będziecie robić żadnych nacięć na swoim ciele za umarłych ani czynić żadnego piętna na sobie. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Nie będziesz hańbił swojej córki, nakłaniając ją do nierządu, aby ziemia nie uległa nierządowi i nie napełniła się rozpustą. ");
INSERT INTO polubg_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Będziecie przestrzegać moich szabatów i moją świątynię będziecie czcić. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Nie będziecie się zwracać do czarowników ani szukać rady u wróżbitów, abyście się przez nich nie skalali. Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Przed siwizną wstaniesz i uczcisz osobę starca, i bój się swego Boga. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Jeśli przybysz będzie mieszkał z tobą w waszej ziemi, nie czyńcie mu krzywdy; ");
INSERT INTO polubg_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Przybysz, który gości u was, będzie jak jeden urodzony wśród was. Będziesz go miłować jak samego siebie, bo i wy byliście przybyszami w ziemi Egiptu. Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Nie czyńcie nieprawości w sądzie, w miarach, w wagach i w objętości. ");
INSERT INTO polubg_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Wagi sprawiedliwe, odważniki sprawiedliwe, efę sprawiedliwą i kwartę sprawiedliwą będziecie mieć. Ja jestem PAN, wasz Bóg, który wyprowadził was z ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Będziecie więc przestrzegać wszystkich moich ustaw i wszystkich moich praw i będziecie je wypełniać. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Powiedz synom Izraela: Ktokolwiek z synów Izraela albo z przybyszów mieszkających w Izraelu złoży Molochowi w ofierze kogoś ze swego potomstwa, poniesie śmierć. Lud tej ziemi go ukamienuje. ");
INSERT INTO polubg_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","I ja zwrócę moje oblicze przeciwko temu człowiekowi i wyłączę go spośród jego ludu, dlatego że złożył ofiarę Molochowi ze swego potomstwa, by zanieczyścić moją świątynię i zbezcześcić moje święte imię. ");
INSERT INTO polubg_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","A jeśli lud tej ziemi zasłoni swe oczy przed takim człowiekiem, który złożył Molochowi ofiarę ze swego potomstwa, i nie zabije go; ");
INSERT INTO polubg_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","To zwrócę swoje oblicze przeciw temu człowiekowi i przeciw jego domowi i wyłączę go oraz wszystkich, którzy cudzołożyli za jego przykładem, by uprawiać nierząd z Molochem, spośród ich ludu. ");
INSERT INTO polubg_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Przeciwko człowiekowi, który zwróci się do czarowników i wróżbitów, by cudzołożyć za ich przykładem, zwrócę swoje oblicze i wyłączę go spośród jego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Uświęcajcie się więc i bądźcie święci, bo ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Będziecie przestrzegać moich ustaw i wypełniać je. Ja jestem PAN, który was uświęca. ");
INSERT INTO polubg_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ktokolwiek bowiem złorzeczy swemu ojcu albo swej matce, poniesie śmierć. Złorzeczył swemu ojcu i swej matce, więc jego krew spadnie na niego. ");
INSERT INTO polubg_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Mężczyzna, który dopuści się cudzołóstwa z czyjąś żoną, ponieważ cudzołożył z żoną swego bliźniego, poniesie śmierć, zarówno cudzołożnik, jak i cudzołożnica. ");
INSERT INTO polubg_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Mężczyzna, który położy się z żoną swego ojca, odsłonił nagość swego ojca: oboje poniosą śmierć, ich krew spadnie na nich. ");
INSERT INTO polubg_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Jeśli mężczyzna położy się ze swoją synową, oboje poniosą śmierć. Dopuścili się zboczenia, ich krew spadnie na nich. ");
INSERT INTO polubg_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Także jeśli mężczyzna obcuje z mężczyzną tak jak z kobietą, to obaj popełnili obrzydliwość. Poniosą śmierć, ich krew spadnie na nich. ");
INSERT INTO polubg_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Jeśli mężczyzna pojmie za żonę kobietę i jej matkę, to jest to niegodziwość. W ogniu spalą i jego, i je, aby nie było tej niegodziwości wśród was. ");
INSERT INTO polubg_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Także mężczyzna, jeśli się położy ze zwierzęciem, poniesie śmierć. Zwierzę też zabijecie. ");
INSERT INTO polubg_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Jeśli kobieta zbliża się do jakiegoś zwierzęcia, aby się z nim położyć, zabijesz kobietę i zwierzę. Poniosą śmierć, ich krew będzie na nich. ");
INSERT INTO polubg_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Jeśli mężczyzna pojmie swoją siostrę, córkę swego ojca albo córkę swej matki i zobaczy jej nagość, i ona zobaczy jego nagość, to jest to hańba. Będą wytraceni na oczach swego ludu. Odsłonił nagość swej siostry, obciążył się swoją nieprawością. ");
INSERT INTO polubg_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","A jeśli mężczyzna położy się z kobietą w czasie jej słabości i odkryje jej nagość, i obnaży jej źródło, a ona też odsłoni źródło swojej krwi, to oboje zostaną wykluczeni spośród swego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Nie będziesz odsłaniał nagości siostry swej matki ani siostry swego ojca, bo kto obnaża swoją krewną, obciąża się swoją nieprawością. ");
INSERT INTO polubg_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Jeśli mężczyzna kładzie się z żoną swego stryja, odsłania nagość swego stryja. Obciążą się swoim grzechem, umrą bez dzieci. ");
INSERT INTO polubg_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Także jeśli mężczyzna pojmie żonę swego brata, to jest to nieczystość. Odsłania nagość swego brata, będą bezdzietni. ");
INSERT INTO polubg_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Przestrzegajcie więc wszystkich moich ustaw i wszystkich moich praw i wypełniajcie je, aby was nie wyrzuciła ziemia, do której was wprowadzę, abyście w niej mieszkali. ");
INSERT INTO polubg_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","A nie postępujcie według obyczajów tego narodu, który wypędzam przed wami. To wszystko bowiem czynili i obrzydziłem ich sobie. ");
INSERT INTO polubg_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Wam zaś powiedziałem: Wy posiądziecie ich ziemię i dam ją wam jako posiadłość – ziemię opływającą mlekiem i miodem. Ja jestem PAN, wasz Bóg, który oddzielił was od innych narodów. ");
INSERT INTO polubg_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Będziecie więc rozróżniać między zwierzęciem czystym a nieczystym i między ptakiem nieczystym a czystym. Nie kalajcie waszych dusz przez zwierzęta i ptactwo, i wszystko, co pełza po ziemi, co oddzieliłem od was jako nieczyste. ");
INSERT INTO polubg_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","I będziecie dla mnie święci, bo ja, PAN, jestem święty i oddzieliłem was od innych narodów, abyście byli moimi. ");
INSERT INTO polubg_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Mężczyzna lub kobieta, w których będzie duch czarownika albo wróżbity, poniosą śmierć: będą ukamienowani, ich krew spadnie na nich. ");
INSERT INTO polubg_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","PAN powiedział też do Mojżesza: Mów do kapłanów, synów Aarona i powiedz im: Niech nikt z was nie zanieczyści się z powodu umarłych spośród swego ludu; ");
INSERT INTO polubg_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Z wyjątkiem najbliższych krewnych, czyli swej matki, swego ojca, swego syna, swej córki i swego brata; ");
INSERT INTO polubg_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","A także swej siostry dziewicy, bliskiej mu, która nie miała męża; z jej powodu może się zanieczyścić. ");
INSERT INTO polubg_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Jako przełożony wśród swego ludu nie zanieczyści się, tak żeby był skalany. ");
INSERT INTO polubg_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Nie będą sobie czynili łysiny na swej głowie ani nie będą golić skrajów swej brody, ani nie będą nacinać swego ciała. ");
INSERT INTO polubg_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Będą święci dla swego Boga i nie będą bezcześcili imienia swego Boga, składają bowiem ofiary PANA spalane w ogniu oraz chleb swego Boga. Będą więc święci. ");
INSERT INTO polubg_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Nie pojmą sobie za żonę nierządnicy lub naruszonej w panieństwie; nie będą także pojmować kobiety oddalonej przez jej męża, gdyż każdy z nich jest święty dla swego Boga. ");
INSERT INTO polubg_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Miej go więc za świętego, bo on składa w ofierze chleb twego Boga; dlatego będzie święty dla ciebie, bo ja, PAN, który was poświęca, jestem święty. ");
INSERT INTO polubg_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Jeśli córka kapłana zbezcześci się przez nierząd, zbezcześci swego ojca. Będzie spalona w ogniu. ");
INSERT INTO polubg_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Najwyższy kapłan wśród swoich braci, na którego głowę została wylana oliwa namaszczenia i który został poświęcony, aby wkładać na siebie święte szaty, nie będzie odsłaniał swej głowy i nie rozedrze swoich szat; ");
INSERT INTO polubg_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","I nie zbliży się do żadnego zmarłego, nawet nie zanieczyści się z powodu swego ojca lub z powodu swej matki. ");
INSERT INTO polubg_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Nie wyjdzie ze świątyni i nie zbezcześci świątyni swego Boga, gdyż korona oliwy namaszczenia swego Boga jest na nim: Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","I weźmie sobie dziewicę za żonę. ");
INSERT INTO polubg_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Nie weźmie sobie ani wdowy, ani oddalonej, ani zhańbionej, ani nierządnicy, lecz weźmie sobie za żonę dziewicę ze swego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","I nie zbezcześci swego potomstwa wśród swego ludu, bo ja jestem PAN, który go uświęca. ");
INSERT INTO polubg_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Przemówił dalej PAN do Mojżesza, mówiąc: ");
INSERT INTO polubg_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Powiedz Aaronowi tymi słowy: Ktokolwiek z twego potomstwa w ich pokoleniach miał jakąś wadę, niech nie zbliża się, aby składać w ofierze chleb swego Boga. ");
INSERT INTO polubg_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Żaden mężczyzna, który ma jakąś wadę, nie zbliży się: ani niewidomy, ani chromy, ani mający płaski nos, ani nieproporcjonalnie zbudowany; ");
INSERT INTO polubg_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Ani ten, który ma złamaną nogę lub rękę; ");
INSERT INTO polubg_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Ani garbaty, ani z bielmem na oku, ani chory na świerzb, ani pokryty liszajami, ani eunuch: ");
INSERT INTO polubg_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Żaden mężczyzna z potomków kapłana Aarona, który ma jakąś wadę, nie zbliży się, by składać ofiary PANA spalane w ogniu. Ma wadę, więc nie zbliży się, aby składać w ofierze chleb swego Boga. ");
INSERT INTO polubg_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Może jednak spożywać chleb swego Boga, zarówno święty, jak i najświętszy. ");
INSERT INTO polubg_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Lecz nie może wchodzić poza zasłonę ani zbliżać się do ołtarza, bo ma wadę, żeby nie zbezcześcił mojej świątyni. Ja bowiem jestem PAN, który ją poświęca. ");
INSERT INTO polubg_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","I Mojżesz powiedział to Aaronowi, jego synom i wszystkim synom Izraela. ");
INSERT INTO polubg_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","I powiedział PAN do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Powiedz Aaronowi i jego synom, aby powstrzymywali się od świętych rzeczy synów Izraela i nie zbezcześcili mojego świętego imienia w tym, co mi poświęcają. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Powiedz im: Ktokolwiek z waszego potomstwa w waszych pokoleniach zbliży się do świętych rzeczy, które synowie Izraela poświęcają PANU, będąc nieczystym, ten będzie wytracony sprzed mego oblicza. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ktokolwiek z potomstwa Aarona będzie trędowaty albo będzie cierpiał na wyciek, nie będzie spożywał z rzeczy poświęconych, dopóki nie stanie się czysty. A kto dotknie jakiejś nieczystości z powodu zmarłego lub tego, z którego wypływa nasienie; ");
INSERT INTO polubg_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Lub kto dotknie czegoś, co pełza po ziemi, przez co stanie się nieczysty, lub człowieka, który uczyni go nieczystym z powodu jakiejkolwiek jego nieczystości; ");
INSERT INTO polubg_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ten, kto dotknie czegoś takiego, będzie nieczysty aż do wieczora i nie będzie jadł z rzeczy poświęconych, aż obmyje swoje ciało w wodzie. ");
INSERT INTO polubg_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Po zachodzie słońca będzie czysty i potem będzie jeść z rzeczy poświęconych, bo to jest jego pokarm. ");
INSERT INTO polubg_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Nie będzie jadł padliny ani mięsa rozszarpanego przez zwierzę, aby się tym nie zanieczyścić. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Będą więc przestrzegać mojego nakazu, aby nie obciążyli się grzechem i nie umarli za to, że go zbezcześcili. Ja jestem PAN, który ich poświęca. ");
INSERT INTO polubg_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Żaden obcy nie będzie jadł z rzeczy świętych: ani gość kapłana, ani jego najemnik nie będzie jadł z rzeczy świętych. ");
INSERT INTO polubg_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","A jeśli kapłan kupi człowieka za swoje pieniądze, to ten może je jeść, również urodzony w jego domu; oni mogą jeść z jego pokarmów. ");
INSERT INTO polubg_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","A jeśli córka kapłana wyjdzie za mąż za obcego, to nie będzie ona jeść z ofiar rzeczy świętych. ");
INSERT INTO polubg_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Jeśli zaś córka kapłana zostanie wdową albo zostanie oddalona przez męża i nie ma dzieci, a wróci do domu swego ojca jak w swojej młodości, to będzie mogła jeść chleb swego ojca, lecz żaden obcy nie będzie z niego jadł. ");
INSERT INTO polubg_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","A jeśli ktoś przez nieuwagę zje z rzeczy świętych, to doda do tego jedną piątą i odda kapłanowi wraz z rzeczą świętą. ");
INSERT INTO polubg_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Nie będą bezcześcić rzeczy świętych, które synowie Izraela ofiarują PANU; ");
INSERT INTO polubg_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","I tak obciążać ich nieprawością za występek, gdy będą jedli ich święte rzeczy, gdyż ja, PAN, ich uświęcam. ");
INSERT INTO polubg_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Przemów do Aarona, jego synów i wszystkich synów Izraela i powiedz im: Ktokolwiek z domu Izraela lub spośród przybyszów w Izraelu złoży swoją ofiarę zgodnie ze wszystkimi swoimi ślubami lub wszystkimi dobrowolnymi darami, które złoży PANU na ofiarę całopalenia; ");
INSERT INTO polubg_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","To złoży ze swojej woli samca bez skazy, z bydła, owiec lub kóz. ");
INSERT INTO polubg_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Nie będziecie ofiarować niczego, co ma wadę, bo nie zostanie przyjęte od was. ");
INSERT INTO polubg_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Jeśli ktoś składa PANU ofiarę pojednawczą, wypełniając ślub lub jako dobrowolny dar z bydła albo z trzody, musi to być bez wady, aby zostało przyjęte. Nie będzie na nim żadnej zmazy. ");
INSERT INTO polubg_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Nie będziecie ofiarowywać PANU zwierzęcia ślepego, kulawego, okaleczonego, owrzodzonego, chorego na świerzb, pokrytego liszajami. Nie będziecie też składać go PANU na ołtarz jako ofiary spalanej. ");
INSERT INTO polubg_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Wołu albo jagnię niekształtne lub niewyrośnięte możesz złożyć jako ofiarę dobrowolną, ale jako ofiara ślubowana nie będą przyjęte. ");
INSERT INTO polubg_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Nie będziecie ofiarowywać PANU nic zgniecionego, posiniaczonego, rozerwanego lub skaleczonego. Nie będziecie tego czynić w waszej ziemi. ");
INSERT INTO polubg_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Nie będziecie też ofiarowywać na chleb waszego Boga z ręki cudzoziemca takich zwierząt, bo jest w nich skaza, mają wadę. Nie zostaną przyjęte od was. ");
INSERT INTO polubg_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Gdy się urodzi wół, owca lub koza, to będzie przez siedem dni przy swej matce, a od ósmego dnia i dalej będzie przyjęte jako ofiara spalona dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Nie zabijajcie w tym samym dniu krowy lub owcy wraz z jej małym. ");
INSERT INTO polubg_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","A gdy będziecie składali PANU ofiarę dziękczynną, będziecie ją składać z własnej woli. ");
INSERT INTO polubg_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Tego samego dnia zostanie spożyta; nie zostawicie z niej nic do rana. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Dlatego będziecie przestrzegać moich przykazań i wypełniać je. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","I nie będziecie bezcześcić mojego świętego imienia, bo będę uświęcony pośród synów Izraela. Ja jestem PAN, który was uświęca; ");
INSERT INTO polubg_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Który was wyprowadził z ziemi Egiptu, aby być waszym Bogiem. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Przemów do synów Izraela i powiedz im: Uroczyste święta PANA, które będziecie ogłaszać jako święte zgromadzenia. One są moimi uroczystymi świętami. ");
INSERT INTO polubg_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Przez sześć dni będziecie wykonywać pracę, ale siódmy dzień będzie szabatem odpoczynku, świętym zgromadzeniem, nie będziecie wykonywać wtedy żadnej pracy. Jest to szabat PANA we wszystkich waszych domach. ");
INSERT INTO polubg_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Oto uroczyste święta PANA, święte zgromadzenia, które będziecie ogłaszać w ich oznaczonych porach: ");
INSERT INTO polubg_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","W pierwszym miesiącu, czternastego dnia tego miesiąca, o zmierzchu, jest Pascha PANA. ");
INSERT INTO polubg_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","A piętnastego dnia tego miesiąca będzie Święto Przaśników dla PANA. Przez siedem dni będziecie jeść przaśne chleby. ");
INSERT INTO polubg_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Pierwszego dnia będziecie mieć święte zgromadzenie. Nie będziecie wykonywać żadnej uciążliwej pracy. ");
INSERT INTO polubg_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Lecz będziecie składali PANU ofiarę spalaną przez siedem dni. Siódmego dnia będzie święte zgromadzenie. Nie będziecie wykonywać żadnej ciężkiej pracy. ");
INSERT INTO polubg_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Przemów do synów Izraela i powiedz im: Gdy wejdziecie do ziemi, którą wam daję, i będziecie zbierać plony, wtedy przyniesiecie do kapłana snop z pierwocin waszego plonu. ");
INSERT INTO polubg_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","I on będzie kołysał tym snopem przed PANEM, aby był przyjęty za was. Nazajutrz po sabacie kapłan będzie nim kołysał. ");
INSERT INTO polubg_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","W dniu kołysania tym snopem złożycie w ofierze rocznego baranka bez skazy jako całopalenie dla PANA; ");
INSERT INTO polubg_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Wraz z nim na ofiarę pokarmową dwie dziesiąte efy mąki pszennej zmieszanej z oliwą jako ofiarę spalaną PANU na miłą woń, a do tego także ofiarę z płynów, jedną czwartą hinu wina. ");
INSERT INTO polubg_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Nie będziecie jeść chleba ani prażonego ziarna, ani świeżych kłosów aż do dnia, w którym przyniesiecie ofiarę waszemu Bogu. Będzie to wieczna ustawa przez wszystkie wasze pokolenia, we wszystkich waszych mieszkaniach. ");
INSERT INTO polubg_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","I odliczycie sobie od pierwszego dnia po szabacie, od dnia, w którym przynieśliście snop kołysania, siedem pełnych tygodni. ");
INSERT INTO polubg_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Aż do pierwszego dnia po siódmym szabacie odliczycie pięćdziesiąt dni i wtedy złożycie PANU nową ofiarę pokarmową. ");
INSERT INTO polubg_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Przyniesiecie z waszych domów dwa chleby na ofiarę kołysania. Będą one z dwóch dziesiątych efy mąki pszennej, upieczone na zakwasie; to będą pierwociny dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Razem z tym chlebem złożycie w ofierze siedem rocznych baranków bez skazy, jednego młodego cielca i dwa barany. Będą one na ofiarę całopalenia dla PANA wraz z ich ofiarą pokarmową i ofiarami z płynów. Będzie to ofiara spalana na miłą woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Złożycie też jednego kozła na ofiarę za grzech i dwa roczne baranki na ofiarę pojednawczą. ");
INSERT INTO polubg_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","I kapłan będzie je kołysał razem z chlebem pierwocin na ofiarę kołysania przed PANEM wraz z dwoma barankami. One będą poświęcone PANU, przeznaczone dla kapłana. ");
INSERT INTO polubg_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","I ogłosicie w tym dniu święto; będzie to dla was święte zgromadzenie. Nie będziecie wykonywać żadnej uciążliwej pracy. To będzie wieczysta ustawa we wszystkich waszych domach, przez wszystkie wasze pokolenia. ");
INSERT INTO polubg_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","A gdy będziecie zbierać plony waszej ziemi, nie będziesz wycinać doszczętnie skraju twego pola i nie będziesz zbierać pokłosia twoich plonów. Zostawisz je dla ubogiego i przybysza. Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","PAN dalej mówił do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Przemów do synów Izraela i powiedz im: W siódmym miesiącu, pierwszego dnia tego miesiąca, będziecie mieli szabat, upamiętnienie przez trąbienie, święte zgromadzenie. ");
INSERT INTO polubg_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Nie będziecie wykonywać żadnej uciążliwej pracy, lecz złożycie PANU ofiarę spalaną. ");
INSERT INTO polubg_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","PAN powiedział jeszcze do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Lecz dziesiątego dnia tego siódmego miesiąca będzie Dzień Przebłagania. Będzie to dla was święte zgromadzenie; będziecie trapić swoje dusze i składać PANU ofiarę spalaną. ");
INSERT INTO polubg_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","W tym dniu nie będziecie wykonywać żadnej pracy, gdyż jest to Dzień Przebłagania, żeby dokonano dla was przebłagania przed PANEM, waszym Bogiem. ");
INSERT INTO polubg_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Każdy bowiem człowiek, który nie będzie trapił swojej duszy tego dnia, zostanie wykluczony ze swego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Także każdego, kto będzie wykonywał jakąkolwiek pracę w tym dniu, zgładzę spośród jego ludu. ");
INSERT INTO polubg_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Nie będziecie wykonywać żadnej pracy; będzie to wieczysta ustawa przez wszystkie wasze pokolenia, we wszystkich waszych domach. ");
INSERT INTO polubg_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Będzie to dla was szabat odpoczynku i będziecie trapić swoje dusze. Dziewiątego dnia tego miesiąca, wieczorem, od wieczora aż do wieczora, będziecie obchodzić wasz szabat. ");
INSERT INTO polubg_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","PAN dalej mówił do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Przemów do synów Izraela i powiedz im: Piętnastego dnia tego siódmego miesiąca będzie Święto Namiotów przez siedem dni dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Pierwszego dnia będzie święte zgromadzenie. Nie będziecie wykonywać żadnej uciążliwej pracy. ");
INSERT INTO polubg_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Przez siedem dni będziecie składać PANU ofiarę spalaną. Ósmego dnia będziecie mieć święte zgromadzenie i będziecie składać PANU ofiarę spalaną. Jest to święto, żadnej uciążliwej pracy nie będziecie wykonywać. ");
INSERT INTO polubg_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","To są święta PANA, które ogłosicie jako święte zgromadzenia, abyście składali PANU ofiarę spalaną, całopalenie, ofiarę pokarmową, ofiarę pojednawczą i ofiary z płynów, każdą w swój dzień; ");
INSERT INTO polubg_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Oprócz szabatów PANA, oprócz waszych darów, oprócz wszystkich waszych ślubów i wszystkich waszych dobrowolnych ofiar, które będziecie składać PANU. ");
INSERT INTO polubg_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Piętnastego dnia siódmego miesiąca, gdy zbierzecie plony ziemi, będziecie obchodzili święto dla PANA przez siedem dni; w pierwszym dniu będzie odpoczynek, także w ósmym dniu będzie odpoczynek. ");
INSERT INTO polubg_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Pierwszego dnia weźmiecie sobie owoce z najlepszych drzew, gałązki palmowe, gałązki gęstych drzew i wierzbiny znad potoku i będziecie się weselić przed PANEM, waszym Bogiem, przez siedem dni. ");
INSERT INTO polubg_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Będziecie obchodzić to święto dla PANA przez siedem dni, co rok. Będzie to wieczysta ustawa przez wszystkie wasze pokolenia. W siódmym miesiącu będziecie je obchodzić. ");
INSERT INTO polubg_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Przez siedem dni będziecie mieszkać w szałasach. Wszyscy urodzeni Izraelici będą mieszkać w szałasach; ");
INSERT INTO polubg_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Aby wasze pokolenia wiedziały, że kazałem synom Izraela mieszkać w szałasach, gdy wyprowadziłem ich z ziemi Egiptu. Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","I ogłosił Mojżesz synom Izraela te święta PANA. ");
INSERT INTO polubg_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Rozkaż synom Izraela, aby przynieśli ci czystą, wyciśniętą oliwę z oliwek, na oświetlenie, aby lampy ciągle się paliły. ");
INSERT INTO polubg_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aaron sporządzi je na zewnątrz zasłony Świadectwa, w Namiocie Zgromadzenia, aby się paliły od wieczora aż do poranka przed PANEM nieustannie. Będzie to wieczysta ustawa przez wszystkie wasze pokolenia. ");
INSERT INTO polubg_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Będzie ustawiał lampy na czystym świeczniku przed PANEM nieustannie. ");
INSERT INTO polubg_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Weźmiesz też mąki pszennej i upieczesz z niej dwanaście placków, każdy placek będzie z dwóch dziesiątych efy. ");
INSERT INTO polubg_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Potem ułożysz je w dwóch rzędach, po sześć w każdym rzędzie, na czystym stole przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Na każdy rząd położysz czystego kadzidła, aby było pamiątką na chlebie, ofiarą spaloną dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","W każdy dzień szabatu kapłan będzie je nieustannie układać przed PANEM, biorąc je od synów Izraela jako wieczne przymierze. ");
INSERT INTO polubg_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","I będą należały do Aarona i jego synów: będą je jeść w miejscu świętym, gdyż jest to dla nich najświętsza rzecz ze spalanych ofiar PANA jako wieczysta ustawa. ");
INSERT INTO polubg_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","W tym czasie syn Izraelitki, którego ojcem był Egipcjanin, wyszedł między synów Izraela. I pokłócił się w obozie syn tej Izraelitki z pewnym Izraelitą. ");
INSERT INTO polubg_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","I syn Izraelitki bluźnił imieniu PANA i przeklinał. Przyprowadzono go więc do Mojżesza. A jego matce było na imię Szelomit, była córką Dibriego, z pokolenia Dana. ");
INSERT INTO polubg_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","I osadzili go pod strażą, żeby im oznajmiono, co PAN rozkaże uczynić. ");
INSERT INTO polubg_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Wtedy PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Wyprowadź bluźniercę poza obóz i niech wszyscy, którzy to słyszeli, położą swoje ręce na jego głowie i niech ukamienuje go całe zgromadzenie. ");
INSERT INTO polubg_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","A synom Izraela powiedz tak: Ktokolwiek przeklnie swego Boga, obciąży się swym grzechem. ");
INSERT INTO polubg_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ten również, kto zbluźnił imieniu PANA, poniesie śmierć: Ukamienuje go całe zgromadzenie. Zarówno przybysz, jak i rodowity mieszkaniec, jeśli zbluźni imieniu PANA, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Każdy, kto zabije jakiegokolwiek człowieka, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","A kto zabije zwierzę, zwróci inne: zwierzę za zwierzę. ");
INSERT INTO polubg_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Kto też ranił swego bliźniego, niech mu uczynią tak, jak on uczynił. ");
INSERT INTO polubg_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Złamanie za złamanie, oko za oko, ząb za ząb; jak ranił człowieka, tak niech mu oddadzą. ");
INSERT INTO polubg_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Kto zabije zwierzę, zwróci inne; lecz kto zabije człowieka, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Będziecie mieli jedno prawo zarówno dla przybysza, jak i dla rodowitego mieszkańca, gdyż ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","I Mojżesz przemówił do synów Izraela, a wyprowadzili bluźniercę poza obóz i ukamienowali go. I synowie Izraela uczynili tak, jak PAN przykazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Potem PAN powiedział do Mojżesza na górze Synaj: ");
INSERT INTO polubg_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Przemów do synów Izraela i powiedz im: Gdy wejdziecie do ziemi, którą wam daję, wtedy ziemia będzie obchodzić szabat dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Przez sześć lat będziesz obsiewał swoje pole i przez sześć lat będziesz obcinał swoją winnicę, i zbierał z niej plony; ");
INSERT INTO polubg_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Lecz w siódmym roku ziemia będzie mieć szabat odpoczynku, szabat dla PANA. Nie będziesz obsiewał swego pola ani obcinał swojej winnicy. ");
INSERT INTO polubg_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Nie będziesz żął tego, co samo wyrośnie po twoich żniwach, ani nie będziesz zbierał winogron twojej zaniechanej winnicy. To będzie rok odpoczynku dla ziemi. ");
INSERT INTO polubg_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","I szabat ziemi będzie dla was pokarmem: dla ciebie, dla twego sługi, dla twojej służącej, dla twego najemnika i dla przybysza, który mieszka u ciebie. ");
INSERT INTO polubg_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Także dla twego bydła i zwierząt, które są w twojej ziemi; cały jej plon będzie służyć za pokarm. ");
INSERT INTO polubg_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Policzysz też sobie siedem lat szabatowych, to jest siedem razy po siedem lat; okres siedmiu szabatowych lat będzie wynosił czterdzieści dziewięć lat. ");
INSERT INTO polubg_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Wtedy w dziesiątym dniu siódmego miesiąca każesz zatrąbić w trąbę o donośnym dźwięku; w Dniu Przebłagania zatrąbicie po całej waszej ziemi. ");
INSERT INTO polubg_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Poświęcicie pięćdziesiąty rok i ogłosicie wolność w ziemi wszystkim jej mieszkańcom. Będzie to dla was rok jubileuszowy. Każdy z was wróci do swojej posiadłości i do swojej rodziny. ");
INSERT INTO polubg_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Rok pięćdziesiąty będzie dla was rokiem jubileuszowym. Nie będziecie siać ani żąć tego, co samo wyrosło, ani zbierać winogron z winnic zaniechanych. ");
INSERT INTO polubg_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Jest to bowiem rok jubileuszowy, będzie dla was święty. Będziecie jeść to, co na polu urośnie. ");
INSERT INTO polubg_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","W tym roku jubileuszowym każdy z was wróci do swojej posiadłości. ");
INSERT INTO polubg_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Jeśli sprzedasz coś swemu bliźniemu albo kupisz coś od niego, niech jeden nie oszukuje drugiego. ");
INSERT INTO polubg_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Według liczby lat po roku jubileuszowym kupisz od swego bliźniego i według liczby lat plonów on sprzeda tobie. ");
INSERT INTO polubg_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Im więcej będzie lat, tym wyższa będzie cena, a im mniej będzie lat, tym niższa będzie cena, ponieważ on sprzedaje ci ilość rocznych plonów. ");
INSERT INTO polubg_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Nie będziecie oszukiwać jeden drugiego, lecz będziesz się bał swego Boga, gdyż ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Wykonujcie moje ustawy i przestrzegajcie moich praw, i wypełniajcie je, a będziecie mieszkać w tej ziemi bezpiecznie. ");
INSERT INTO polubg_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ziemia wyda swój plon i będziecie jedli do syta, i będziecie bezpiecznie w niej mieszkać. ");
INSERT INTO polubg_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","A jeśli powiecie: Cóż będziemy jeść w siódmym roku, jeśli nie będziemy siać ani zbierać naszych plonów? ");
INSERT INTO polubg_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Wtedy rozkażę, żeby moje błogosławieństwo przyszło na was w szóstym roku i wyda plon na trzy lata. ");
INSERT INTO polubg_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","I będziecie siać w ósmym roku, ale będziecie jeść ze starego plonu aż do dziewiątego roku; dopóki nie nadejdą jego plony, będziecie jeść stare. ");
INSERT INTO polubg_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Ziemia nie będzie sprzedawana na zawsze, gdyż ziemia należy do mnie, a wy jesteście u mnie gośćmi i przybyszami. ");
INSERT INTO polubg_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","A w całej ziemi waszej posiadłości ustanowicie dla ziemi prawo wykupu. ");
INSERT INTO polubg_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Jeśli twój brat zubożeje, a sprzeda coś ze swojej własności i przyjdzie najbliższy krewny, mający prawo wykupu, to niech wykupi, co jego brat sprzedał. ");
INSERT INTO polubg_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","A jeśli ktoś nie ma nikogo, kto może to wykupić, lecz sam będzie mógł i znajdzie środki na wykup; ");
INSERT INTO polubg_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","To odliczy lat od swojej sprzedaży, zwróci resztę temu, komu sprzedał, i wróci do swojej posiadłości. ");
INSERT INTO polubg_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Lecz jeśli nie ma środków, aby zwrócić, to pozostanie to, co sprzedał, w ręku tego, który to kupił aż do roku jubileuszowego. W roku jubileuszowym zwolni mu to, a ten wróci do swojej posiadłości. ");
INSERT INTO polubg_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Jeśli ktoś sprzeda dom mieszkalny w mieście otoczonym murami, będzie miał prawo wykupu do końca roku sprzedaży; będzie miał prawo wykupu przez cały rok. ");
INSERT INTO polubg_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","A jeśli nie zostanie wykupiony do końca roku, wtedy ten dom w mieście otoczonym murami zostanie własnością na zawsze tego, który go kupił, oraz jego potomków. Nie będzie zwolniony w roku jubileuszowym. ");
INSERT INTO polubg_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ale domy we wsiach, które nie są otoczone murami, będą traktowane na równi z polami ziemi. Będą podlegały prawu wykupu i w roku jubileuszowym zostaną zwolnione. ");
INSERT INTO polubg_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Co do miast Lewitów i domów w miastach ich posiadłości, to Lewitom zawsze przysługuje prawo wykupu. ");
INSERT INTO polubg_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","A jeśli ktoś kupuje od Lewitów, to kupiony dom lub miejska posiadłość zostaną zwolnione w roku jubileuszowym, gdyż domy miast Lewitów są ich posiadłością pośród synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ale pole wokół ich miast nie będzie sprzedawane, gdyż jest ich wieczystą posiadłością. ");
INSERT INTO polubg_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Jeśli twój brat zubożeje i jego ręka osłabnie przy tobie, wspomożesz go, aby mógł żyć przy tobie jako gość lub przybysz. ");
INSERT INTO polubg_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Nie bierz od niego lichwy ani odsetek, lecz bój się swego Boga, aby twój brat mógł się żywić przy tobie. ");
INSERT INTO polubg_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Nie dasz mu swoich pieniędzy na lichwę ani nie pożyczysz mu swojej żywności dla zysku. ");
INSERT INTO polubg_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ja jestem PAN, wasz Bóg, który was wyprowadził z ziemi Egiptu, aby dać wam ziemię Kanaan i być waszym Bogiem. ");
INSERT INTO polubg_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Jeśli też zubożeje twój brat przy tobie i zaprzeda się tobie, nie będziesz go obarczał niewolniczą pracą; ");
INSERT INTO polubg_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Będzie u ciebie jako najemnik i jako przybysz; aż do roku jubileuszowego będzie ci służyć. ");
INSERT INTO polubg_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Potem odejdzie od ciebie, on i jego dzieci z nim, i wróci do swojej rodziny i do posiadłości swoich przodków. ");
INSERT INTO polubg_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Oni bowiem są moimi sługami, których wyprowadziłem z ziemi Egiptu. Nie będą sprzedawani jako niewolnicy. ");
INSERT INTO polubg_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Nie będziesz srogo panował nad nimi, ale będziesz się bał swego Boga. ");
INSERT INTO polubg_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Twój niewolnik i twoja niewolnica, których będziesz miał, będą z tych narodów, które są wokoło was; od nich będziecie kupować niewolnika i niewolnicę. ");
INSERT INTO polubg_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Także spośród synów przybyszów mieszkających wśród was będziecie kupować i z potomstwa tych, którzy są z wami, urodzonych w waszej ziemi. Oni będą waszą własnością. ");
INSERT INTO polubg_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Będziecie ich przekazywać waszym dzieciom w dziedzictwie, na dziedziczną własność; będą wam służyć na zawsze. Lecz nad waszymi braćmi, synami Izraela, nikt z was nie będzie srogo panował. ");
INSERT INTO polubg_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","A jeśli gość lub przybysz wzbogaci się przy tobie, a twój brat zubożeje przy nim i sprzeda się gościowi lub przybyszowi przy tobie lub potomstwu rodziny przybysza; ");
INSERT INTO polubg_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","To po sprzedaniu może zostać wykupiony; ktokolwiek z jego braci może go wykupić; ");
INSERT INTO polubg_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Albo jego stryj, albo syn jego stryja może go wykupić, albo ktokolwiek z jego bliskich krewnych z jego rodziny może go wykupić, albo jeśli go stać, sam siebie wykupi. ");
INSERT INTO polubg_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","I rozliczy się ze swoim nabywcą od roku swego sprzedania aż do roku jubileuszowego; a pieniądze, za które się sprzedał, zostaną obliczone według liczby lat; postąpi z nim jak z najemnikiem. ");
INSERT INTO polubg_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Jeśli zostało jeszcze wiele lat, to według ich liczby zwróci swój wykup z pieniędzy, za które został kupiony. ");
INSERT INTO polubg_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","A jeśli do roku jubileuszowego zostało niewiele lat, to rozliczy się z nim i według ich liczby tych lat zwróci swój wykup. ");
INSERT INTO polubg_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Będzie u niego jako najemnik, rok po roku; nie będzie nad nim srogo panował na twoich oczach. ");
INSERT INTO polubg_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","A jeśli nie zostanie wykupiony tymi sposobami, wtedy wyjdzie wolny w roku jubileuszowym, on razem ze swoimi dziećmi; ");
INSERT INTO polubg_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Bo synowie Izraela są moimi sługami. Są moimi sługami, których wyprowadziłem z ziemi Egiptu. Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Nie czyńcie sobie bożków ani rzeźbionego posągu ani nie stawiajcie stel, ani kamiennych rzeźb w waszej ziemi, by im oddawać pokłon, bo ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Będziecie zachowywać moje szabaty i czcić moją świątynię. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Jeśli będziecie postępować według moich ustaw i przestrzegać moich przykazań, i wykonywać je; ");
INSERT INTO polubg_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","To ześlę wam deszcze we właściwym czasie i ziemia wyda swój plon, i drzewa polne wydadzą swój owoc; ");
INSERT INTO polubg_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Młocka będzie trwać do winobrania, a winobranie do siewu; będziecie jeść swój chleb do syta i mieszkać bezpiecznie w swojej ziemi. ");
INSERT INTO polubg_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Udzielę ziemi pokoju, położycie się i nikt was nie będzie straszył. Usunę z ziemi groźne zwierzę i miecz nie przejdzie przez waszą ziemię. ");
INSERT INTO polubg_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Będziecie ścigać waszych wrogów i upadną przed wami od miecza. ");
INSERT INTO polubg_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Pięciu z was będzie ścigać stu, a stu z was będzie ścigać dziesięć tysięcy. I wasi wrogowie padną przed wami od miecza. ");
INSERT INTO polubg_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Zwrócę się bowiem ku wam i rozplenię was, rozmnożę was i utwierdzę moje przymierze z wami. ");
INSERT INTO polubg_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","I będziecie jedli zboże z poprzednich zbiorów, potem wyniesiecie stare, gdy nastaną nowe. ");
INSERT INTO polubg_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Umieszczę też mój przybytek wśród was i moja dusza nie obrzydzi was sobie. ");
INSERT INTO polubg_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","I będę przechadzał się wśród was, i będę waszym Bogiem, a wy będziecie moim ludem. ");
INSERT INTO polubg_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ja jestem PAN, wasz Bóg, który wyprowadził was z ziemi Egiptu, abyście już nie byli ich niewolnikami; i połamałem więzy waszego jarzma, abyście chodzili wyprostowani. ");
INSERT INTO polubg_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Jeśli jednak nie posłuchacie mnie i nie wykonacie wszystkich tych przykazań; ");
INSERT INTO polubg_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","I jeśli wzgardzicie moimi ustawami, i wasza dusza będzie się brzydzić moimi sądami, tak że nie wykonacie wszystkich moich przykazań i złamiecie moje przymierze; ");
INSERT INTO polubg_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","To i ja z wami tak postąpię: Dotknę was przerażeniem, wycieńczeniem i gorączką, które wyniszczą wam oczy i napełnią wasze dusze boleścią. Na próżno będziecie siać wasze ziarno, bo zjedzą je wasi wrogowie; ");
INSERT INTO polubg_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","I zwrócę moje oblicze przeciwko wam, i zostaniecie pobici przez waszych wrogów. Ci, którzy was nienawidzą, będą panować nad wami i będziecie uciekali, choć nikt was nie będzie ścigać. ");
INSERT INTO polubg_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","A jeśli mimo to nie posłuchacie mnie, będę karał was siedem razy więcej za wasze grzechy; ");
INSERT INTO polubg_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Złamię pychę waszej potęgi i niebo nad wami uczynię jak z żelaza, a waszą ziemię jak z miedzi; ");
INSERT INTO polubg_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","I wasza praca będzie szła na próżno, bo wasza ziemia nie wyda swego plonu, a drzewa ziemi nie wydadzą swego owocu. ");
INSERT INTO polubg_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","A jeśli będziecie postępować na przekór mnie i nie zechcecie mnie słuchać, to przydam wam siedem razy więcej plag za wasze grzechy. ");
INSERT INTO polubg_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ześlę też na was dzikie zwierzęta, które was osierocą, wyniszczą wasze bydło i zmniejszą waszą liczbę, tak że opustoszeją wasze drogi. ");
INSERT INTO polubg_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","A jeśli przez to nie poprawicie się, ale będziecie postępować na przekór mnie; ");
INSERT INTO polubg_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","To i ja postąpię na przekór wam i będę was karał siedmiokrotnie za wasze grzechy; ");
INSERT INTO polubg_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","I sprowadzę na was miecz, który pomści złamane przymierze; gdy zbierzecie się w swych miastach, wtedy ześlę zarazę pomiędzy was i będziecie wydani w ręce wroga. ");
INSERT INTO polubg_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","A gdy złamię podporę waszego chleba, dziesięć kobiet będzie piec wasz chleb w jednym piecu i będą wam wydzielać wasz chleb na wagę; będziecie jeść, lecz się nie nasycicie. ");
INSERT INTO polubg_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","A jeśli mimo to nie posłuchacie mnie, ale będziecie postępować na przekór mnie; ");
INSERT INTO polubg_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","To ja też postąpię na przekór wam z gniewem; też będę was karać siedmiokrotnie za wasze grzechy. ");
INSERT INTO polubg_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","I będziecie jeść ciało waszych synów i ciało waszych córek. ");
INSERT INTO polubg_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Zniszczę wasze wyżyny, zburzę wasze posągi i rzucę wasze szczątki na szczątki waszych bożków, a moja dusza będzie się wami brzydzić. ");
INSERT INTO polubg_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","I zamienię wasze miasta w ruiny, i zburzę wasze świątynie, i więcej nie przyjmę waszych wdzięcznych wonności. ");
INSERT INTO polubg_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","I spustoszę ziemię tak, że zdumieją się nad nią wasi wrogowie, którzy w niej mieszkają. ");
INSERT INTO polubg_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","A was rozproszę między narodami i dobędę miecz za wami; wasza ziemia będzie spustoszona i wasze miasta zburzone. ");
INSERT INTO polubg_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Wtedy ziemia ucieszy się swoimi szabatami przez wszystkie dni swojego spustoszenia, a wy będziecie w ziemi waszych wrogów. Wtedy ziemia odpocznie i ucieszy się swoimi szabatami. ");
INSERT INTO polubg_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Przez wszystkie dni swojego spustoszenia będzie odpoczywać, gdyż nie odpoczywała w czasie waszych szabatów, kiedy w niej mieszkaliście. ");
INSERT INTO polubg_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","A tym, którzy z was pozostaną, ześlę do ich serc lękliwość w ziemiach ich wrogów, tak że będzie ich ścigać szelest opadającego liścia i będą uciekać jak przed mieczem, i będą padać, chociaż nikt nie będzie ich ścigać. ");
INSERT INTO polubg_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","I padną jeden na drugiego jakby od miecza, choć nikt ich nie będzie ścigać. Nie będziecie mogli się ostać przed waszymi wrogami. ");
INSERT INTO polubg_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Zginiecie wśród narodów i pożre was ziemia waszych wrogów. ");
INSERT INTO polubg_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","A ci z was, którzy zostaną, zgniją z powodu swojej nieprawości w ziemi swoich wrogów; także z powodu nieprawości swoich ojców zgniją wraz z nimi. ");
INSERT INTO polubg_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ale jeśli wyznają swoją nieprawość i nieprawość swoich ojców oraz przewinienie, którymi wystąpili przeciwko mnie, oraz to, że postępowali na przekór mnie; ");
INSERT INTO polubg_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","I że ja postępowałem na przekór im, i wprowadziłem ich do ziemi ich wrogów; jeśli wtedy ukorzą się ich nieobrzezane serca i będą znosić karę za swoje nieprawości; ");
INSERT INTO polubg_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Wtedy wspomnę na moje przymierze z Jakubem i na moje przymierze z Izaakiem, wspomnę też na moje przymierze z Abrahamem, wspomnę i na tę ziemię. ");
INSERT INTO polubg_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","A ziemia będzie przez nich opuszczona i ucieszy się swoimi szabatami, gdy będzie spustoszona z ich powodu. Będą cierpliwie nosić karę za swoją nieprawość, ponieważ wzgardzili moimi sądami i ich dusza obrzydziła sobie moje ustawy. ");
INSERT INTO polubg_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Lecz mimo tego wszystkiego, gdy będą w ziemi swoich wrogów, nie odrzucę ich ani nie obrzydzę ich sobie tak, by ich wytępić i złamać moje przymierze z nimi, gdyż ja jestem PAN, ich Bóg. ");
INSERT INTO polubg_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ale dla nich wspomnę na przymierze ich przodków, których wyprowadziłem z ziemi Egiptu na oczach pogan, aby być ich Bogiem. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","To są ustawy, sądy i prawa, które ustanowił PAN między sobą a synami Izraela na górze Synaj za pośrednictwem Mojżesza. ");
INSERT INTO polubg_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Przemów do synów Izraela i powiedz im: Jeśli ktoś złoży PANU szczególny ślub, da okup według twojego oszacowania. ");
INSERT INTO polubg_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","A takie będzie twoje oszacowanie: Za mężczyznę w wieku od dwudziestu do sześćdziesięciu lat będzie wynosiło pięćdziesiąt syklów srebra według sykla świątynnego. ");
INSERT INTO polubg_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","A jeśli to jest kobieta, twoje oszacowanie będzie wynosiło trzydzieści syklów; ");
INSERT INTO polubg_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","A jeśli to będzie ktoś w wieku od pięciu do dwudziestu lat, wtedy twoje oszacowanie za osobę płci męskiej będzie wynosiło dwadzieścia syklów, a za osobę płci żeńskiej – dziesięć syklów. ");
INSERT INTO polubg_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","A jeśli to jest dziecko w wieku od jednego miesiąca do pięciu lat, wtedy twoje oszacowanie za chłopca będzie wynosiło pięć syklów srebra, a za dziewczynkę twoje oszacowanie będzie wynosiło trzy sykle srebra. ");
INSERT INTO polubg_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","A jeśli to jest ktoś w wieku od sześćdziesięciu lat wzwyż, jeśli to jest mężczyzna, wtedy twoje szacowanie będzie wynosiło piętnaście syklów, a za kobietę – dziesięć syklów. ");
INSERT INTO polubg_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Lecz jeśli jest tak ubogi, że nie może zapłacić twego oszacowania, wtedy postawią go przed kapłanem i kapłan go oszacuje. Według możności tego, który ślubował, oszacuje go kapłan. ");
INSERT INTO polubg_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Jeśli to, co będzie PANU składane w ofierze, jest ze zwierząt, to wszystko z tego, które będzie oddane PANU, będzie święte; ");
INSERT INTO polubg_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Nie zamieni go ani nie zastąpi go czym innym, ani lepszego gorszym, ani gorszego lepszym. Jeśli jednak nawet zastąpi zwierzę innym zwierzęciem, to ono i to, czym zostało zastąpione, będzie święte. ");
INSERT INTO polubg_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","A jeśli to będzie nieczyste zwierzę, którego nie składa się PANU w ofierze, wtedy stawi to zwierzę przed kapłanem; ");
INSERT INTO polubg_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","I kapłan je oszacuje, według tego, czy jest dobre, czy marne. Jak ty, kapłanie, je oszacujesz, tak będzie. ");
INSERT INTO polubg_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","A jeśli zechce je wykupić, to doda jedną piątą do twojego oszacowania. ");
INSERT INTO polubg_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Jeśli ktoś poświęci swój dom, żeby był święty dla PANA, wtedy kapłan oszacuje go według tego, czy jest dobry, czy marny. Jak kapłan go oszacuje, tak zostanie. ");
INSERT INTO polubg_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","A jeśli ten, który poświęcił, zechce wykupić swój dom, to doda jedną piątą wartości twego oszacowania i dom będzie jego. ");
INSERT INTO polubg_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Jeśli ktoś poświęci PANU część pola swojej posiadłości, wtedy twoje oszacowanie będzie według ilości wysianego ziarna; chomer jęczmienia odpowiada pięćdziesięciu syklom srebra. ");
INSERT INTO polubg_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Jeśli poświęcił swoje pole do roku jubileuszowego, to zostanie według twego oszacowania. ");
INSERT INTO polubg_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ale jeśli poświęcił swoje pole po roku jubileuszowym, wtedy kapłan obliczy mu pieniądze według lat, które zostają do roku jubileuszowego, i zostanie to odjęte od twego szacowania. ");
INSERT INTO polubg_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","A jeśli ten, który poświęcił pole, zechce je wykupić, to doda jedną piątą wartości twego oszacowania i pole będzie jego. ");
INSERT INTO polubg_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ale jeśli nie wykupi pola, lecz będzie ono sprzedane komuś innemu, nie może być już wykupione. ");
INSERT INTO polubg_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","I to pole, gdy stanie się wolne w roku jubileuszowym, będzie święte dla PANA jako pole poświęcone; stanie się posiadłością kapłana. ");
INSERT INTO polubg_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","A jeśli ktoś poświęca PANU kupione pole, które nie należy do pól jego posiadłości; ");
INSERT INTO polubg_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Wówczas kapłan obliczy mu wysokość oszacowania aż do roku jubileuszowego i on tego samego dnia odda sumę twego szacowania jako rzecz świętą PANU. ");
INSERT INTO polubg_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","A w roku jubileuszowym pole wróci do tego, od którego zostało kupione, do którego posiadłość tej ziemi należy. ");
INSERT INTO polubg_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","A każde twoje oszacowanie będzie według sykla świątynnego. Jeden sykl będzie wynosił dwadzieścia ger. ");
INSERT INTO polubg_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Jednak pierworodnego ze zwierząt, które jako pierworodne należą do PANA, nikt nie poświęci, czy to wołu, czy owcy; należy do PANA. ");
INSERT INTO polubg_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","A jeśli będzie ze zwierząt nieczystych, to wykupi je według twego oszacowania i doda do tego jedną piątą; a jeśli nie zostanie wykupione, niech zostanie sprzedane według twego oszacowania. ");
INSERT INTO polubg_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Natomiast każda rzecz poświęcona, którą kto poświęca PANU ze wszystkiego, co ma – czy to z ludzi, czy ze zwierząt, czy z pola swojej posiadłości – nie będzie sprzedawana ani wykupiona, bo wszelka rzecz poświęcona jest najświętsza dla PANA. ");
INSERT INTO polubg_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","To, co poświęcone, które będzie poświęcone przez człowieka, nie będzie odkupione, ale poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Wszelka dziesięcina ziemi – czy to z nasienia ziemi, czy z owocu drzewa – należy do PANA. Jest ona poświęcona PANU. ");
INSERT INTO polubg_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ale jeśli ktoś zechce wykupić część swoich dziesięcin, doda do nich jedną piątą. ");
INSERT INTO polubg_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Także wszelka dziesięcina z bydła i z trzody, ze wszystkiego, co przechodzi pod laską pasterską, każde dziesiąte będzie poświęcone PANU. ");
INSERT INTO polubg_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Nikt nie będzie przebierał między dobrym a marnym ani nie będzie go zamieniać; a jeśli je nawet zamieni, to ono i to, na co zostało zamienione, będzie święte. Nie można tego wykupić. ");
INSERT INTO polubg_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","To są przykazania, które PAN rozkazał Mojżeszowi dla synów Izraela na górze Synaj. ");
INSERT INTO polubg_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","PAN przemówił do Mojżesza na pustyni Synaj, w Namiocie Zgromadzenia, pierwszego dnia drugiego miesiąca, w drugim roku po ich wyjściu z ziemi Egiptu, tymi słowy: ");
INSERT INTO polubg_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Policzcie całe zgromadzenie synów Izraela według ich rodzin i według domów ich ojców, licząc imiona wszystkich mężczyzn, głowa po głowie; ");
INSERT INTO polubg_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Od dwudziestu lat wzwyż, wszystkich w Izraelu zdolnych do walki. Ty i Aaron policzycie ich według ich oddziałów. ");
INSERT INTO polubg_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","I będzie z wami jeden mężczyzna z każdego pokolenia, głowa domu swoich ojców. ");
INSERT INTO polubg_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","A oto imiona mężczyzn, którzy będą z wami: z pokolenia Rubena – Elizur, syn Szedeura; ");
INSERT INTO polubg_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Z Symeona – Szelumiel, syn Suriszaddaja; ");
INSERT INTO polubg_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Z Judy – Nachszon, syn Amminadaba; ");
INSERT INTO polubg_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Z Issachara – Netaneel, syn Suara; ");
INSERT INTO polubg_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Z Zebulona – Eliab, syn Chelona; ");
INSERT INTO polubg_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Z synów Józefa: z Efraima – Eliszama, syn Ammihuda, z Manassesa – Gamliel, syn Pedahsura; ");
INSERT INTO polubg_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Z Beniamina – Abidan, syn Gideoniego; ");
INSERT INTO polubg_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Z Dana – Achiezer, syn Ammiszaddaja; ");
INSERT INTO polubg_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Z Aszera – Pagiel, syn Okrana; ");
INSERT INTO polubg_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Z Gada – Eliasaf, syn Deuela; ");
INSERT INTO polubg_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Z Neftalego – Achira, syn Enana. ");
INSERT INTO polubg_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ci powołani, sławni spośród zgromadzenia, byli naczelnikami pokoleń swych ojców, wodzami tysięcy w Izraelu. ");
INSERT INTO polubg_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mojżesz i Aaron przyjęli więc tych mężczyzn, którzy zostali imiennie wyznaczeni. ");
INSERT INTO polubg_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","I zebrali całe zgromadzenie w pierwszym dniu drugiego miesiąca, a każdy podawał swoje pochodzenie według swych rodzin, według domów swych ojców i według liczby imion, od dwudziestu lat wzwyż, głowa po głowie. ");
INSERT INTO polubg_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Jak PAN rozkazał Mojżeszowi, tak policzył ich na pustyni Synaj. ");
INSERT INTO polubg_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Synów Rubena, pierworodnego Izraela, ich potomków według ich rodzin, według domów ich ojców, według liczby imion, głowa po głowie, wszystkich mężczyzn od dwudziestu lat wzwyż, wszystkich zdolnych do walki; ");
INSERT INTO polubg_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Naliczono z pokolenia Rubena czterdzieści sześć tysięcy pięciuset. ");
INSERT INTO polubg_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Synów Symeona, ich potomków według ich rodzin, według domów ich ojców, naliczonych według liczby imion, głowa po głowie, wszystkich mężczyzn od dwudziestu lat wzwyż, wszystkich zdolnych do walki; ");
INSERT INTO polubg_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Naliczono z pokolenia Symeona pięćdziesiąt dziewięć tysięcy trzystu. ");
INSERT INTO polubg_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Synów Gada, ich potomków według ich rodzin, według domów ich ojców, według liczby imion, od dwudziestu lat wzwyż, wszystkich zdolnych do walki; ");
INSERT INTO polubg_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Naliczono z pokolenia Gada czterdzieści pięć tysięcy sześciuset pięćdziesięciu. ");
INSERT INTO polubg_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Synów Judy, ich potomków według ich rodzin, według domów ich ojców, według liczby imion, od dwudziestu lat wzwyż, wszystkich zdolnych do walki; ");
INSERT INTO polubg_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Naliczono z pokolenia Judy siedemdziesiąt cztery tysiące sześciuset. ");
INSERT INTO polubg_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Synów Issachara, ich potomków według ich rodzin, według domów ich ojców, według liczby imion, od dwudziestu lat wzwyż, wszystkich zdolnych do walki; ");
INSERT INTO polubg_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Naliczono z pokolenia Issachara pięćdziesiąt cztery tysiące czterystu. ");
INSERT INTO polubg_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Synów Zebulona, ich potomków według ich rodzin, według domów ich ojców, według liczby imion, od dwudziestu lat wzwyż, wszystkich zdolnych do walki; ");
INSERT INTO polubg_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Naliczono z pokolenia Zebulona pięćdziesiąt siedem tysięcy czterystu. ");
INSERT INTO polubg_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Synów Józefa, z synów Efraima, ich potomków według ich rodzin, według domów ich ojców, według liczby imion, od dwudziestu lat wzwyż, wszystkich zdolnych do walki; ");
INSERT INTO polubg_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Naliczono z pokolenia Efraima czterdzieści tysięcy pięciuset. ");
INSERT INTO polubg_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Synów Manassesa, ich potomków według ich rodzin, według domów ich ojców, według liczby imion, od dwudziestu lat wzwyż, wszystkich zdolnych do walki; ");
INSERT INTO polubg_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Naliczono z pokolenia Manassesa trzydzieści dwa tysiące dwustu. ");
INSERT INTO polubg_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Synów Beniamina, ich potomków według ich rodzin, według domów ich ojców, według liczby imion, od dwudziestu lat wzwyż, wszystkich zdolnych do walki; ");
INSERT INTO polubg_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Naliczono z pokolenia Beniamina trzydzieści pięć tysięcy czterystu. ");
INSERT INTO polubg_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Synów Dana, ich potomków według ich rodzin, według domów ich ojców, według liczby imion, od dwudziestu lat wzwyż, wszystkich zdolnych do walki; ");
INSERT INTO polubg_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Naliczono z pokolenia Dana sześćdziesiąt dwa tysiące siedmiuset. ");
INSERT INTO polubg_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Synów Aszera, ich potomków według ich rodzin, według domów ich ojców, według liczby imion, od dwudziestu lat wzwyż, wszystkich zdolnych do walki; ");
INSERT INTO polubg_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Naliczono z pokolenia Aszera czterdzieści jeden tysięcy pięciuset. ");
INSERT INTO polubg_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Synów Neftalego, ich potomków według ich rodzin, według domów ich ojców, według liczby imion, od dwudziestu lat wzwyż, wszystkich zdolnych do walki; ");
INSERT INTO polubg_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Naliczono z pokolenia Neftalego pięćdziesiąt trzy tysiące czterystu. ");
INSERT INTO polubg_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","To są ci, których policzyli Mojżesz, Aaron i książęta Izraela, dwunastu mężczyzn, po jednym z każdego domu swych ojców. ");
INSERT INTO polubg_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","I było wszystkich policzonych synów Izraela, według domów ich ojców, od dwudziestu lat wzwyż, wszystkich zdolnych do walki w Izraelu; ");
INSERT INTO polubg_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Wszystkich policzonych było sześćset trzy tysiące pięciuset pięćdziesięciu. ");
INSERT INTO polubg_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Lecz Lewici nie zostali policzeni z nimi według pokolenia swych ojców. ");
INSERT INTO polubg_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","PAN rozkazał bowiem Mojżeszowi: ");
INSERT INTO polubg_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Tylko pokolenia Lewiego nie spisuj i nie licz go razem z synami Izraela; ");
INSERT INTO polubg_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Lecz ustanowisz Lewitów nad Przybytkiem Świadectwa i nad wszystkimi jego naczyniami, i nad wszystkim, co do niego należy. Oni będą nosić przybytek i wszystkie jego sprzęty; oni też będą go obsługiwać i rozbijać obóz dokoła przybytku. ");
INSERT INTO polubg_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","A gdy przybytek będzie miał wyruszyć, Lewici go rozbiorą; także gdy przybytek ma być wznoszony, Lewici ustawią go; a obcy, który się do niego zbliży, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","I synowie Izraela będą rozbijać namioty, każdy w swoim obozie i każdy pod swoim sztandarem, według swych zastępów. ");
INSERT INTO polubg_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Lecz Lewici rozbiją obóz wokół Przybytku Świadectwa, aby gniew nie spadł na zgromadzenie synów Izraela. Lewici będą pełnić straż przy Przybytku Świadectwa. ");
INSERT INTO polubg_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","I synowie Izraela uczynili zgodnie ze wszystkim, co PAN rozkazał Mojżeszowi, tak właśnie uczynili. ");
INSERT INTO polubg_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Potem PAN przemówił do Mojżesza i Aarona: ");
INSERT INTO polubg_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Każdy z synów Izraela rozbije obóz przy swoim sztandarze, pod znakami domów swych ojców. Będą rozbijać obóz w pewnej odległości od Namiotu Zgromadzenia, wokół niego. ");
INSERT INTO polubg_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Od strony wschodniej rozbiją obóz ludzie pod sztandarem obozu Judy, według swych oddziałów, a wodzem nad synami Judy będzie Nachszon, syn Amminadaba; ");
INSERT INTO polubg_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","A jego policzony zastęp wynosił siedemdziesiąt cztery tysiące sześciuset ludzi. ");
INSERT INTO polubg_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Obok niego rozbije obóz pokolenie Issachara, a wodzem synów Issachara będzie Netaneel, syn Suara; ");
INSERT INTO polubg_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","A jego policzony zastęp wynosił pięćdziesiąt cztery tysiące czterystu ludzi. ");
INSERT INTO polubg_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Obok nich – pokolenie Zebulona, a wodzem synów Zebulona będzie Eliab, syn Chelona; ");
INSERT INTO polubg_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","A jego policzony zastęp wynosił pięćdziesiąt siedem tysięcy czterystu ludzi. ");
INSERT INTO polubg_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Wszystkich policzonych w obozie Judy, według ich zastępów, było sto osiemdziesiąt sześć tysięcy czterystu. Oni wyruszą pierwsi. ");
INSERT INTO polubg_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Od strony południowej będzie sztandar obozu Rubena, według swych zastępów, a wodzem synów Rubena będzie Elisur, syn Szedeura; ");
INSERT INTO polubg_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","A jego policzony zastęp wynosił czterdzieści sześć tysięcy pięciuset ludzi. ");
INSERT INTO polubg_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Obok niego rozbije obóz pokolenie Symeona, a wodzem synów Symeona będzie Szelumiel, syn Suriszaddaja; ");
INSERT INTO polubg_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","A jego policzony zastęp wynosił pięćdziesiąt dziewięć tysięcy trzystu ludzi. ");
INSERT INTO polubg_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Następnie pokolenie Gada, a wodzem synów Gada będzie Eliasaf, syn Reuela; ");
INSERT INTO polubg_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","A jego policzony zastęp wynosił czterdzieści pięć tysięcy sześciuset pięćdziesięciu ludzi. ");
INSERT INTO polubg_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Wszystkich policzonych w obozie Rubena, według ich zastępów, było sto pięćdziesiąt jeden tysięcy czterystu pięćdziesięciu. Oni wyruszą w drugiej kolejności. ");
INSERT INTO polubg_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Następnie wyruszy Namiot Zgromadzenia z obozem Lewitów pośrodku obozu. Jak będą obozować, tak będą wyruszać, każdy na swoim miejscu, pod swoim sztandarem. ");
INSERT INTO polubg_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Od strony zachodniej będzie sztandar obozu Efraima, według swych zastępów, a wodzem synów Efraima będzie Eliszama, syn Ammihuda; ");
INSERT INTO polubg_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","A jego policzony zastęp wynosił czterdzieści tysięcy pięciuset ludzi. ");
INSERT INTO polubg_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Obok niego pokolenie Manassesa, a wodzem synów Manassesa będzie Gamliel, syn Pedahsura. ");
INSERT INTO polubg_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","A jego policzony zastęp wynosił trzydzieści dwa tysiące dwustu ludzi. ");
INSERT INTO polubg_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Następnie pokolenie Beniamina, a wodzem synów Beniamina będzie Abidan, syn Gideoniego; ");
INSERT INTO polubg_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","A jego policzony zastęp wynosił trzydzieści pięć tysięcy czterystu ludzi. ");
INSERT INTO polubg_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Wszystkich policzonych w obozie Efraima było sto osiem tysięcy stu według swoich zastępów. Oni wyruszą w trzeciej kolejności. ");
INSERT INTO polubg_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Od strony północnej będzie sztandar obozu Dana, według swych zastępów, a wodzem synów Dana będzie Achiezer, syn Ammiszadaja; ");
INSERT INTO polubg_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","A jego policzony zastęp wynosił sześćdziesiąt dwa tysiące siedmiuset ludzi. ");
INSERT INTO polubg_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Obok niego rozbije obóz pokolenie Aszera, a wodzem synów Aszera będzie Pagiel, syn Okrana; ");
INSERT INTO polubg_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","A jego policzony zastęp wynosił czterdzieści jeden tysięcy pięciuset ludzi. ");
INSERT INTO polubg_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Następnie pokolenie Neftalego, a wodzem synów Neftalego będzie Achira, syn Enana; ");
INSERT INTO polubg_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","A jego policzony zastęp wynosił pięćdziesiąt trzy tysiące czterystu ludzi. ");
INSERT INTO polubg_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Wszystkich policzonych w obozie Dana było sto pięćdziesiąt siedem tysięcy sześciuset. Oni wyruszą ostatni pod swoimi sztandarami. ");
INSERT INTO polubg_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","To są policzeni spośród synów Izraela według domów ich ojców. Wszystkich policzonych w obozach, według ich zastępów, było sześćset trzy tysiące pięciuset pięćdziesięciu. ");
INSERT INTO polubg_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Lewitów zaś nie liczono wśród synów Izraela, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","I synowie Izraela uczynili zgodnie ze wszystkim, co PAN rozkazał Mojżeszowi: tak rozbijali obozy przy swych sztandarach i tak wyruszali, każdy według swych rodzin i według domów swych ojców. ");
INSERT INTO polubg_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","To są dzieje rodu Aarona i Mojżesza w dniu, w którym PAN rozmawiał z Mojżeszem na górze Synaj. ");
INSERT INTO polubg_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","A to są imiona synów Aarona: pierworodny Nadab, potem Abihu, Eleazar i Itamar. ");
INSERT INTO polubg_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","To są imiona synów Aarona, namaszczonych kapłanów, których poświęcił, aby pełnili urząd kapłański. ");
INSERT INTO polubg_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Lecz Nadab i Abihu umarli przed PANEM, gdy ofiarowali inny ogień przed PANEM na pustyni Synaj, i odeszli bez potomków. Eleazar i Itamar pełnili więc urząd kapłański przed obliczem swego ojca Aarona. ");
INSERT INTO polubg_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Wtedy PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Każ się zbliżyć pokoleniu Lewiego i postaw ich przed kapłanem Aaronem, aby mu służyli; ");
INSERT INTO polubg_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","I pełnili straż, która go obowiązuje oraz straż całego zgromadzenia, przed Namiotem Zgromadzenia, wykonując służbę przybytku. ");
INSERT INTO polubg_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Będą strzec wszystkich sprzętów Namiotu Zgromadzenia i pełnić straż synów Izraela, wykonując służbę przybytku. ");
INSERT INTO polubg_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Oddasz więc Lewitów Aaronowi i jego synom; będą mu całkowicie oddani spośród synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aarona zaś i jego synów ustanowisz, aby pełnili swoje kapłaństwo. A obcy, który się zbliży, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Oto wziąłem Lewitów spośród synów Izraela na miejsce wszystkich pierworodnych, którzy otwierają łono wśród synów Izraela, i dlatego Lewici będą należeć do mnie. ");
INSERT INTO polubg_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Do mnie bowiem należy wszystko, co pierworodne. W dniu, kiedy zabiłem wszystko, co pierworodne w ziemi Egiptu, poświęciłem sobie wszystko, co pierworodne w Izraelu, od człowieka aż do zwierzęcia. Będą należeć do mnie; ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","PAN powiedział też do Mojżesza na pustyni Synaj: ");
INSERT INTO polubg_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Policz synów Lewiego według domów ich ojców i według ich rodzin. Policzysz każdego mężczyznę w wieku od jednego miesiąca wzwyż. ");
INSERT INTO polubg_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","I Mojżesz policzył ich według słowa PANA, jak mu rozkazano. ");
INSERT INTO polubg_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Oto imiona synów Lewiego: Gerszon, Kehat i Merari. ");
INSERT INTO polubg_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","A imiona synów Gerszona według ich domów: Libni i Szimei. ");
INSERT INTO polubg_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","A synowie Kehata według swych domów: Amram, Ishar, Chebron i Uzziel. ");
INSERT INTO polubg_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Synowie zaś Merariego według swych domów: Machli i Muszi. To są rodziny Lewiego według domów ich ojców. ");
INSERT INTO polubg_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Od Gerszona pochodzi rodzina Libnitów i rodzina Szimeitów. To są rodziny Gerszonitów. ");
INSERT INTO polubg_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Liczba wszystkich policzonych mężczyzn w wieku od jednego miesiąca wzwyż wynosiła u nich siedem tysięcy pięciuset. ");
INSERT INTO polubg_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Rodziny Gerszonitów rozbiją obóz za przybytkiem od strony zachodniej. ");
INSERT INTO polubg_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","A wodzem domu ojca Gerszonitów będzie Eliasaf, syn Laela. ");
INSERT INTO polubg_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","A pod strażą synów Gerszona w Namiocie Zgromadzenia będzie przybytek i namiot, jego przykrycie i zasłona u wejścia do Namiotu Zgromadzenia; ");
INSERT INTO polubg_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","I zasłony dziedzińca, zasłona u wejścia na dziedziniec, który otacza przybytek i ołtarz wokoło, oraz jego sznury potrzebne do wszelkich prac. ");
INSERT INTO polubg_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Od Kehata zaś pochodzą rodziny: Amramitów, Isharytów, Chebronitów i Uzzielitów. To są rodziny Kehatytów. ");
INSERT INTO polubg_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Liczba wszystkich mężczyzn w wieku od jednego miesiąca wzwyż wynosiła osiem tysięcy sześciuset pełniących straż w świątyni. ");
INSERT INTO polubg_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Rodziny synów Kehata rozbiją obóz po południowej stronie przybytku; ");
INSERT INTO polubg_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","A wodzem domu ojca rodziny Kehatytów będzie Elisafan, syn Uzziela. ");
INSERT INTO polubg_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Pod ich strażą będzie arka, stół, świecznik, ołtarze i sprzęty świątyni, którymi będą usługiwać, oraz zasłona wraz z całą jej obsługą. ");
INSERT INTO polubg_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Naczelnym wodzem Lewitów będzie Eleazar, syn kapłana Aarona, on będzie miał nadzór nad tymi, którzy pełnią straż w świątyni. ");
INSERT INTO polubg_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Od Merariego pochodzą zaś rodziny Machlitów i Muszytów. To są rodziny Merarytów. ");
INSERT INTO polubg_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","A liczba wszystkich policzonych mężczyzn w wieku od jednego miesiąca wzwyż wynosiła u nich sześć tysięcy dwustu. ");
INSERT INTO polubg_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Wodzem zaś domu ojca rodzin Merariego był Suriel, syn Abichaila. Oni rozbiją obóz po stronie północnej przybytku. ");
INSERT INTO polubg_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","A pod nadzorem i strażą synów Merariego będą deski przybytku, jego drążki, słupy i podstawki oraz wszystkie jego sprzęty wraz z całą jego obsługą; ");
INSERT INTO polubg_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Także słupy wokoło dziedzińca, ich podstawki, kołki i ich sznury. ");
INSERT INTO polubg_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","A przed przybytkiem od strony wschodniej, przed Namiotem Zgromadzenia, rozbiją obóz Mojżesz, Aaron i jego synowie, pełniący straż w świątyni za synów Izraela; a obcy, który się zbliży, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Wszystkich Lewitów policzonych przez Mojżesza i Aarona na rozkaz PANA według ich rodzin, wszystkich mężczyzn w wieku od jednego miesiąca wzwyż było dwadzieścia dwa tysiące. ");
INSERT INTO polubg_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Wtedy PAN powiedział do Mojżesza: Policz wszystkich pierworodnych mężczyzn spośród synów Izraela w wieku od jednego miesiąca wzwyż i sporządź spis ich imion. ");
INSERT INTO polubg_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","I weźmiesz dla mnie Lewitów – ja jestem PAN – w zamian za wszystkich pierworodnych spośród synów Izraela, a także bydła Lewitów zamiast wszystkiego, co pierworodne, wśród bydła synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Mojżesz policzył więc wszystkich pierworodnych spośród synów Izraela, tak jak PAN mu rozkazał. ");
INSERT INTO polubg_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","A liczba wszystkich pierworodnych mężczyzn w wieku od jednego miesiąca wzwyż, według liczby imion, wynosiła dwadzieścia dwa tysiące dwieście siedemdziesiąt trzy. ");
INSERT INTO polubg_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Weź Lewitów na miejsce wszystkich pierworodnych spośród synów Izraela, a także bydło Lewitów na miejsce ich bydła; i Lewici będą należeć do mnie. Ja jestem PAN. ");
INSERT INTO polubg_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","A jako wykup za tych dwustu siedemdziesięciu trzech pierworodnych spośród synów Izraela, którzy przewyższają liczbę Lewitów; ");
INSERT INTO polubg_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Weźmiesz po pięć syklów na głowę według sykla świątynnego: sykl po dwadzieścia ger. ");
INSERT INTO polubg_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","I oddasz te pieniądze Aaronowi i jego synom jako wykup za tych, którzy przewyższają ich liczbę. ");
INSERT INTO polubg_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Mojżesz wziął więc pieniądze wykupu od tych, którzy przewyższali liczbę wykupionych przez Lewitów. ");
INSERT INTO polubg_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Od pierworodnych synów Izraela wziął tysiąc trzysta sześćdziesiąt pięć syklów według sykla świątynnego. ");
INSERT INTO polubg_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","I Mojżesz oddał te pieniądze wykupu Aaronowi i jego synom według słowa PANA, tak jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","I PAN przemówił do Mojżesza i Aarona tymi słowy: ");
INSERT INTO polubg_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Policz synów Kehata spośród synów Lewiego według ich rodzin i według domów ich ojców; ");
INSERT INTO polubg_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Od trzydziestego roku życia wzwyż aż do pięćdziesiątego roku życia; wszystkich, którzy są zdolni do służby, aby wykonywali pracę w Namiocie Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Służbą synów Kehata w Namiocie Zgromadzenia będzie troska o rzeczy najświętsze. ");
INSERT INTO polubg_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Gdy obóz będzie ruszał, przyjdzie Aaron ze swymi synami i zdejmą zasłonę okrywającą, którą okryją arkę świadectwa. ");
INSERT INTO polubg_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","A położą na niej przykrycie ze skór borsuczych i na tym rozciągną nakrycie z błękitnej tkaniny, i założą jej drążki. ");
INSERT INTO polubg_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Stół chlebów pokładnych również przykryją tkaniną z błękitu i położą na nim misy, czasze, przystawki i kubki do nalewania; a będzie na nim nieustanny chleb. ");
INSERT INTO polubg_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","I rozciągną na tym tkaninę karmazynową i przykryją to przykryciem ze skór borsuczych, i założą jego drążki. ");
INSERT INTO polubg_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Wezmą też tkaninę z błękitu, którą okryją świecznik do świecenia i jego lampy, szczypce, naczynia na popiół oraz wszystkie jego naczynia na oliwę, których się przy nim używa; ");
INSERT INTO polubg_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","I owiną go wraz ze wszystkimi jego naczyniami przykryciem ze skór borsuczych i umieszczą na drążkach. ");
INSERT INTO polubg_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Rozciągną nad złotym ołtarzem tkaninę z błękitu i przykryją go przykryciem ze skór borsuczych, i założą jego drążki. ");
INSERT INTO polubg_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Wezmą też wszystkie sprzęty do służby, którymi służą w świątyni, owiną je tkaniną z błękitu, przykryją je okryciem ze skór borsuczych i umieszczą na drążkach. ");
INSERT INTO polubg_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Następnie oczyszczą ołtarz z popiołu i rozciągną na nim purpurową tkaninę; ");
INSERT INTO polubg_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","I położą na nim wszystkie jego sprzęty używane do służby przy nim: kadzielnice, widełki, łopatki i kropielnice, wszystkie naczynia ołtarza, i rozciągną na nim przykrycie ze skór borsuczych, i założą jego drążki. ");
INSERT INTO polubg_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Kiedy Aaron i jego synowie skończą przykrywanie świątyni wraz ze wszystkimi jej naczyniami, gdy obóz będzie miał wyruszyć, wtedy przyjdą synowie Kehata, aby je nieść. Lecz nie będą dotykać świętych przedmiotów, aby nie umarli. To jest służba synów Kehata przy Namiocie Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","A Eleazar, syn kapłana Aarona, będzie troszczył się o oliwę do oświetlenia, wonne kadzidło, stałą ofiarę pokarmową i oliwę do namaszczania oraz będzie doglądał przybytku i wszystkiego, co w nim jest, i w miejscu świętym i przy jego naczyniach. ");
INSERT INTO polubg_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Potem PAN powiedział do Mojżesza i Aarona: ");
INSERT INTO polubg_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Nie pozwólcie, by pokolenie rodzin Kehatytów zostało wycięte spośród Lewitów. ");
INSERT INTO polubg_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ale to im uczynicie, aby żyli i nie pomarli, gdy będą się zbliżać do rzeczy najświętszych: Aaron i jego synowie przyjdą i wyznaczą każdemu z nich, co ma czynić i co ma nieść. ");
INSERT INTO polubg_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Lecz niech nie wchodzą się przyglądać, kiedy rzeczy święte będą przykrywane, by nie pomarli. ");
INSERT INTO polubg_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","PAN dalej mówił do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Policz synów Gerszona według domów ich ojców i według ich rodzin; ");
INSERT INTO polubg_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Policz tych, którzy są w wieku od trzydziestu lat wzwyż aż do lat pięćdziesięciu; wszystkich, którzy są zdolni do tej pracy, aby mogli pełnić służbę przy Namiocie Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","A to będzie zadanie rodzin Gerszonitów, do służby i do noszenia. ");
INSERT INTO polubg_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Będą nosić zasłony przybytku, Namiot Zgromadzenia, jego przykrycie i przykrycie borsucze, które jest na wierzchu, oraz zasłonę u wejścia do Namiotu Zgromadzenia; ");
INSERT INTO polubg_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Zasłony dziedzińca i zasłonę u bramy wejściowej na dziedziniec, który otacza przybytek i ołtarz wokoło, ich sznury i wszystkie przybory do pracy przy nich oraz wszystko, co jest do tego zrobione; tak będą służyć. ");
INSERT INTO polubg_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Wszelka służba synów Gerszonitów związana ze wszystkimi ich ciężarami oraz z całą ich służbą ma odbywać się zgodnie z rozkazem Aarona i jego synów; i powierzycie im troskę o wszystkie ich ciężary. ");
INSERT INTO polubg_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","To będzie zadanie rodzin synów Gerszonitów w Namiocie Zgromadzenia, a nadzór nad nimi będzie miał Itamar, syn kapłana Aarona. ");
INSERT INTO polubg_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","A synów Merariego policzysz według ich rodzin i według domów ich ojców; ");
INSERT INTO polubg_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Policzysz tych, którzy są w wieku od trzydziestu lat wzwyż aż do lat pięćdziesięciu, wszystkich zdolnych do tej pracy, aby mogli pełnić służbę przy Namiocie Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","A to będzie ich zadanie przy służbie w Namiocie Zgromadzenia: będą nosić deski przybytku, jego drążki, słupy i podstawki; ");
INSERT INTO polubg_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Słupy otaczające dziedziniec, ich podstawki, kołki i sznury wraz ze wszystkimi ich przyborami oraz wszystko, co należy do ich służby. A z przedmiotów, które są im powierzone do noszenia, zrobicie wykaz według nazw. ");
INSERT INTO polubg_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","To będzie zadanie rodzin synów Merariego według całej ich służby przy Namiocie Zgromadzenia pod nadzorem Itamara, syna kapłana Aarona. ");
INSERT INTO polubg_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Mojżesz, Aaron i naczelnicy zgromadzenia policzyli synów Kehata według ich rodzin i według domów ich ojców; ");
INSERT INTO polubg_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Tych będących w wieku od trzydziestu lat wzwyż aż do lat pięćdziesięciu, którzy byli zdolni do tej pracy, aby mogli pełnić służbę przy Namiocie Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","A policzonych według ich rodzin było dwa tysiące siedmiuset pięćdziesięciu. ");
INSERT INTO polubg_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Byli to ci policzeni z rodzin Kehatytów, wszyscy, którzy mieli pełnić służbę przy Namiocie Zgromadzenia, których policzyli Mojżesz i Aaron zgodnie z rozkazem PANA przekazanym przez Mojżesza. ");
INSERT INTO polubg_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","A policzonych synów Gerszona według ich rodzin i według domów ich ojców; ");
INSERT INTO polubg_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Tych, którzy byli w wieku od trzydziestu lat wzwyż aż do lat pięćdziesięciu, zdolnych do pracy, aby mogli pełnić służbę przy Namiocie Zgromadzenia; ");
INSERT INTO polubg_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Policzonych według ich rodzin i domów ich ojców było dwa tysiące sześciuset trzydziestu. ");
INSERT INTO polubg_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Byli to ci policzeni z rodzin synów Gerszona, wszyscy, którzy mieli pełnić służbę w Namiocie Zgromadzenia, których policzyli Mojżesz i Aaron zgodnie z rozkazem PANA. ");
INSERT INTO polubg_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","A policzonych z rodzin synów Merariego według ich rodzin i domów ich ojców; ");
INSERT INTO polubg_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Tych, którzy byli w wieku trzydziestu lat wzwyż aż do lat pięćdziesięciu, zdolnych do pracy, aby mogli pełnić służbę przy Namiocie Zgromadzenia; ");
INSERT INTO polubg_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","A policzonych według ich rodzin było trzy tysiące dwustu. ");
INSERT INTO polubg_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","A to są policzeni z rodzin synów Merariego, których policzyli Mojżesz i Aaron zgodnie z rozkazem PANA przekazanym przez Mojżesza. ");
INSERT INTO polubg_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Wszystkich Lewitów policzonych, których policzyli Mojżesz, Aaron i naczelnicy Izraela według ich rodzin i domów ich ojców; ");
INSERT INTO polubg_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","W wieku trzydziestu lat wzwyż aż do lat pięćdziesięciu; wszystkich policzonych, którzy przychodzili pełnić zadanie służby i noszenia ciężarów w Namiocie Zgromadzenia; ");
INSERT INTO polubg_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Było osiem tysięcy pięciuset osiemdziesięciu. ");
INSERT INTO polubg_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Zgodnie z rozkazem PANA zostali policzeni przez Mojżesza, każdy z osobna według jego służby i według jego ciężaru. Policzono tych, których PAN rozkazał liczyć Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Rozkaż synom Izraela, aby usunęli z obozu każdego trędowatego, każdego cierpiącego na wyciek i każdego, który zanieczyścił się przy umarłym. ");
INSERT INTO polubg_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Usuniecie zarówno mężczyznę, jak i kobietę; usuniecie ich poza obóz, aby nie zanieczyścili obozu tych, wśród których mieszkam. ");
INSERT INTO polubg_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","I synowie Izraela tak uczynili, i usunęli ich poza obóz. Jak PAN rozkazał Mojżeszowi, tak uczynili synowie Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","I powiedział PAN do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Powiedz synom Izraela: Jeśli mężczyzna lub kobieta popełnią jakikolwiek grzech ludzki, popełniając występek przeciwko PANU, a ta osoba byłaby winna; ");
INSERT INTO polubg_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Wtedy wyzna swój grzech, którego się dopuściła, i zwróci w całości to, czym zawiniła, dodając do tego jedną piątą, i odda temu, wobec kogo zgrzeszyła. ");
INSERT INTO polubg_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","A jeśli człowiek ten nie ma krewnego, któremu można by zwrócić odszkodowanie, niech będzie ono oddane PANU i niech przypadnie kapłanowi z wyjątkiem barana przebłagania, którym dokona za niego przebłagania. ");
INSERT INTO polubg_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Każda też ofiara ze wszystkich poświęconych rzeczy synów Izraela, które przyniosą do kapłana, będzie należeć do niego. ");
INSERT INTO polubg_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Poświęcone rzeczy każdego człowieka będą należeć do niego; cokolwiek ktoś odda kapłanowi, będzie należeć do niego. ");
INSERT INTO polubg_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Przemów do synów Izraela i powiedz im: Jeśli czyjaś żona zbłądzi i dopuści się grzechu przeciwko niemu; ");
INSERT INTO polubg_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","A inny mężczyzna obcuje z nią, lecz będzie to ukryte przed oczami jej męża i tajne, i stanie się ona nieczysta, a nie będzie żadnego świadka przeciwko niej ani nie zostanie ona przyłapana; ");
INSERT INTO polubg_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Gdyby dopadł go duch zazdrości i podejrzewałby swoją żonę, która stała się nieczysta, albo gdyby dopadł go duch zazdrości i podejrzewałby ją, choć nie stała się nieczysta; ");
INSERT INTO polubg_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Wówczas ten mąż przyprowadzi swoją żonę do kapłana i przyniesie ofiarę za nią – jedną dziesiątą efy mąki jęczmiennej. Nie wyleje na nią oliwy ani nie nałoży na nią kadzidła, gdyż jest to ofiara podejrzenia, ofiara pamięci, przypominająca grzech. ");
INSERT INTO polubg_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","A kapłan każe się jej zbliżyć i stawi ją przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","I kapłan wleje wodę poświęconą do glinianego naczynia, weźmie też trochę prochu, który jest na podłodze przybytku, i doda do wody. ");
INSERT INTO polubg_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Potem kapłan postawi kobietę przed PANEM, odkryje jej głowę i położy na jej rękach ofiarę pamięci, czyli ofiarę podejrzenia. Kapłan zaś będzie miał w ręku wodę gorzką, niosącą przekleństwa. ");
INSERT INTO polubg_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","I kapłan zaprzysięgnie ją, i powie do kobiety: Jeśli nie położył się z tobą inny mężczyzna i jeśli nie dopuściłaś się grzechu nieczystości wobec swego męża, to bądź nietknięta przez tę wodę gorzką niosącą przekleństwa; ");
INSERT INTO polubg_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Jeśli jednak byłaś niewierna swemu mężowi i stałaś się nieczysta, ponieważ oprócz twego męża obcował z tobą inny mężczyzna; ");
INSERT INTO polubg_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Wtedy kapłan zaprzysięgnie tę kobietę przysięgą przekleństwa i powie do niej: Niech PAN uczyni cię przekleństwem i klątwą wśród twego ludu, gdy PAN sprawi, że twoje biodro zwiotczeje i twoje łono spuchnie. ");
INSERT INTO polubg_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Niech ta woda niosąca przekleństwo przeniknie twoje wnętrzności, aby spuchło twoje łono i zwiotczało twoje biodro. I odpowie kobieta: Amen, amen. ");
INSERT INTO polubg_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Potem kapłan napisze te przekleństwa w księdze i zmyje je tą gorzką wodą; ");
INSERT INTO polubg_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","I da wypić kobiecie gorzką wodę niosącą przekleństwo; i woda przekleństwa przeniknie ją, i zamieni się w gorycz. ");
INSERT INTO polubg_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Potem kapłan weźmie z rąk tej kobiety ofiarę podejrzenia i będzie ją kołysał przed PANEM, i złoży ją na ołtarzu. ");
INSERT INTO polubg_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Kapłan weźmie też pełną garść ofiary jako pamiątkę i spali to na ołtarzu, potem da kobiecie wypić tę wodę. ");
INSERT INTO polubg_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","A gdy da jej wypić tę wodę, stanie się tak, że jeśli stała się nieczysta i sprzeniewierzyła się swemu mężowi, to woda przekleństwa przeniknie ją i zamieni się w gorycz, i spuchnie jej łono, i zwiotczeje jej biodro, i kobieta stanie się przekleństwem wśród swego ludu. ");
INSERT INTO polubg_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Jeśli jednak kobieta ta nie stała się nieczysta, ale jest czysta, to będzie bez winy i będzie rodzić dzieci. ");
INSERT INTO polubg_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Takie jest prawo dotyczące podejrzenia, gdy żona będzie niewierna swemu mężowi i stanie się nieczysta; ");
INSERT INTO polubg_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Albo gdy dopadnie męża duch zazdrości i będzie podejrzewał swoją żonę, i stawi ją przed PANEM, a kapłan postąpi z nią według tego prawa; ");
INSERT INTO polubg_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Wówczas mąż nie będzie winny grzechu, a kobieta obciąży się nieprawością. ");
INSERT INTO polubg_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Przemów do synów Izraela i powiedz do nich: Gdy mężczyzna albo kobieta złoży szczególny ślub nazirejczyka, aby się poświęcić PANU; ");
INSERT INTO polubg_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Niech powstrzyma się od wina i mocnego napoju; nie będzie pił octu z wina i octu z mocnego napoju; nie będzie pił żadnego soku z winogron i nie będzie jeść winogron, ani świeżych, ani suszonych. ");
INSERT INTO polubg_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Przez wszystkie dni swego oddzielenia nie będzie jeść niczego, co pochodzi z winorośli, od ziarenka aż do łupiny. ");
INSERT INTO polubg_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Przez wszystkie dni ślubu swego oddzielenia brzytwa nie dotknie jego głowy. Dopóki nie wypełni się czas, na który poświęcił się PANU, będzie święty i zapuści włosy na swojej głowie. ");
INSERT INTO polubg_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Nie zbliży się do umarłego przez cały okres swego oddzielenia dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Nie zanieczyści się przy ojcu, matce, bracie czy siostrze, którzy umarli, gdyż ma na głowie poświęcenie dla swego Boga. ");
INSERT INTO polubg_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Przez wszystkie dni swego oddzielenia będzie świętym dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","I gdyby ktoś nagle przy nim umarł i zanieczyścił jego poświęconą głowę, to ogoli swoją głowę w dniu swego oczyszczenia; ogoli ją siódmego dnia. ");
INSERT INTO polubg_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","A ósmego dnia przyniesie dwie synogarlice lub dwa młode gołębie do kapłana, przed wejście do Namiotu Zgromadzenia; ");
INSERT INTO polubg_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","I kapłan złoży jednego na ofiarę za grzech, a drugiego na ofiarę całopalenia, i dokona za niego przebłagania za to, że zgrzeszył przy umarłym, i tego samego dnia poświęci jego głowę. ");
INSERT INTO polubg_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Potem poświęci PANU dni swego oddzielenia i przyniesie rocznego baranka za przewinienie. Minione dni jednak przepadną, gdyż jego oddzielenie zostało zanieczyszczone. ");
INSERT INTO polubg_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","A takie jest prawo nazirejczyka: Gdy wypełnią się dni jego oddzielenia, przyprowadzi się go przed wejście do Namiotu Zgromadzenia; ");
INSERT INTO polubg_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","I złoży PANU w ofierze jednego rocznego baranka bez skazy na ofiarę całopalenia, jedną roczną owcę bez skazy na ofiarę za grzech i jednego barana bez skazy na ofiarę pojednawczą; ");
INSERT INTO polubg_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Do tego kosz przaśnych chlebów z mąki pszennej, placki zmieszane z oliwą oraz przaśne podpłomyki pomazane oliwą z ich ofiarą pokarmową i ofiarą z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","I kapłan przyniesie to przed PANA i złoży jego ofiarę za grzech oraz jego całopalenie. ");
INSERT INTO polubg_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Barana zaś złoży PANU na ofiarę pojednawczą wraz z koszem przaśnych chlebów. Kapłan złoży też jego ofiarę pokarmową oraz jego ofiarę z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","I nazirejczyk ogoli swoją poświęconą głowę u wejścia do Namiotu Zgromadzenia i weźmie włosy ze swojej poświęconej głowy, i położy je na ogień, który jest pod ofiarą pojednawczą. ");
INSERT INTO polubg_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Następnie kapłan weźmie ugotowaną łopatkę barana, jeden przaśny placek z kosza i jeden przaśny podpłomyk i złoży to w ręce nazirejczyka, gdy ten ogoli swoje poświęcone włosy; ");
INSERT INTO polubg_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","I kapłan będzie to kołysał jako ofiarę kołysania przed PANEM; jest to święta rzecz i należy do kapłana wraz z mostkiem kołysania i łopatką wzniesienia. Potem nazirejczyk będzie mógł pić wino. ");
INSERT INTO polubg_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Takie jest prawo dotyczące nazirejczyka, który składa ślub, jak i jego ofiary dla PANA za jego oddzielenie, oprócz tego, na co go stać. Zgodnie ze swoim ślubem, który złożył, tak uczyni według prawa swego oddzielenia. ");
INSERT INTO polubg_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Powiedz Aaronowi i jego synom: Tak będziecie błogosławić synów Izraela, mówiąc do nich: ");
INSERT INTO polubg_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Niech ci błogosławi PAN i niech cię strzeże; ");
INSERT INTO polubg_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Niech PAN rozjaśni nad tobą swoje oblicze i niech ci będzie łaskawy; ");
INSERT INTO polubg_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Niech PAN zwróci ku tobie swoje oblicze i niech da ci pokój. ");
INSERT INTO polubg_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","I będą wzywać mojego imienia nad synami Izraela, a ja im będę błogosławił. ");
INSERT INTO polubg_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","W dniu, w którym Mojżesz zakończył wznoszenie przybytku, namaścił go i poświęcił wraz ze wszystkimi jego sprzętami, a także ołtarz ze wszystkimi jego naczyniami, namaścił je i poświęcił. ");
INSERT INTO polubg_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Naczelnicy Izraela, głowy domów swoich ojców, którzy byli naczelnikami z każdego pokolenia i przełożonymi nad tymi, którzy zostali spisani, złożyli ofiary. ");
INSERT INTO polubg_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Przynieśli swoje ofiary przed PANA: sześć krytych wozów, dwanaście wołów, po jednym wozie na dwóch naczelników i po jednym wole na każdego, i przyprowadzili to przed przybytek. ");
INSERT INTO polubg_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Wtedy PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Weź to od nich na potrzebę służby w Namiocie Zgromadzenia i oddaj to Lewitom, każdemu według potrzeby jego służby. ");
INSERT INTO polubg_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Mojżesz wziął więc te wozy i woły i oddał je Lewitom. ");
INSERT INTO polubg_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Dwa wozy i cztery woły dał synom Gerszona według potrzeby ich służby. ");
INSERT INTO polubg_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Cztery zaś wozy i osiem wołów dał synom Merariego według potrzeby ich służby, pod nadzorem Itamara, syna kapłana Aarona. ");
INSERT INTO polubg_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ale synom Kehata nie dał nic, bo ich służba w świątyni polegała na noszeniu na ramionach. ");
INSERT INTO polubg_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Naczelnicy ofiarowali swoje dary przed ołtarzem na jego poświęcenie, w tym dniu, w którym został namaszczony. ");
INSERT INTO polubg_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","I PAN powiedział do Mojżesza: Niech złożą swoje ofiary, inny naczelnik każdego dnia, na poświęcenie ołtarza. ");
INSERT INTO polubg_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Pierwszego dnia swoją ofiarę złożył Nachszon, syn Amminadaba, z pokolenia Judy. ");
INSERT INTO polubg_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","A jego ofiarę stanowiły: jedna srebrna misa wagi stu trzydziestu syklów, jedna srebrna czasza wagi siedemdziesięciu syklów według sykla świątynnego, obydwie pełne mąki pszennej zmieszanej z oliwą, na ofiarę pokarmową; ");
INSERT INTO polubg_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Jedna czara z dziesięciu syklów złota pełna kadzidła; ");
INSERT INTO polubg_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Jeden młody cielec, jeden baran i jedno roczne jagnię na ofiarę całopalną; ");
INSERT INTO polubg_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Jeden kozioł z kóz na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","A na ofiarę pojednawczą – dwa woły, pięć baranów, pięć kozłów i pięć jednorocznych jagniąt. To była ofiara Nachszona, syna Amminadaba. ");
INSERT INTO polubg_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Drugiego dnia ofiarę złożył Netaneel, syn Suara, naczelnik z pokolenia Issachara. ");
INSERT INTO polubg_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Złożył on w ofierze jedną srebrną misę wagi stu trzydziestu syklów, jedną srebrną czaszę wagi siedemdziesięciu syklów według sykla świątynnego, obydwie pełne mąki pszennej zmieszanej z oliwą, na ofiarę pokarmową; ");
INSERT INTO polubg_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Jedną czarę z dziesięciu syklów złota pełną kadzidła; ");
INSERT INTO polubg_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Jednego młodego cielca, jednego barana i jedno roczne jagnię na ofiarę całopalną; ");
INSERT INTO polubg_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Jednego kozła z kóz na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","A na ofiarę pojednawczą – dwa woły, pięć baranów, pięć kozłów i pięć jednorocznych jagniąt. To była ofiara Netaneela, syna Suara. ");
INSERT INTO polubg_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Trzeciego dnia ofiarę złożył naczelnik synów Zebulona Eliab, syn Chelona. ");
INSERT INTO polubg_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Jego ofiarę stanowiły: jedna srebrna misa wagi stu trzydziestu syklów, jedna srebrna czasza wagi siedemdziesięciu syklów według sykla świątynnego, obydwie pełne mąki pszennej zmieszanej z oliwą, na ofiarę pokarmową; ");
INSERT INTO polubg_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Jedna czara z dziesięciu syklów złota pełna kadzidła; ");
INSERT INTO polubg_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Jeden młody cielec, jeden baran i jedno roczne jagnię na ofiarę całopalną; ");
INSERT INTO polubg_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Jeden kozioł z kóz na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","A na ofiarę pojednawczą – dwa woły, pięć baranów, pięć kozłów i pięć jednorocznych jagniąt. To była ofiara Eliaba, syna Chelona. ");
INSERT INTO polubg_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Czwartego dnia ofiarę złożył naczelnik synów Rubena Elizur, syn Szedeura. ");
INSERT INTO polubg_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Jego ofiarę stanowiły: jedna srebrna misa wagi stu trzydziestu syklów, jedna srebrna czasza wagi siedemdziesięciu syklów według sykla świątynnego, obydwie pełne mąki pszennej zmieszanej z oliwą, na ofiarę pokarmową; ");
INSERT INTO polubg_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Jedna czara z dziesięciu syklów złota pełna kadzidła; ");
INSERT INTO polubg_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Jeden młody cielec, jeden baran i jedno roczne jagnię na ofiarę całopalną; ");
INSERT INTO polubg_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Jeden kozioł z kóz na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","A na ofiarę pojednawczą – dwa woły, pięć baranów, pięć kozłów i pięć jednorocznych jagniąt. To była ofiara Elizura, syna Szedeura. ");
INSERT INTO polubg_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Piątego dnia ofiarę złożył naczelnik synów Symeona Szelumiel, syn Suriszaddaja. ");
INSERT INTO polubg_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Jego ofiarę stanowiły: jedna srebrna misa wagi stu trzydziestu syklów, jedna srebrna czasza wagi siedemdziesięciu syklów według sykla świątynnego, obydwie pełne mąki pszennej zmieszanej z oliwą, na ofiarę pokarmową; ");
INSERT INTO polubg_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Jedna czara z dziesięciu syklów złota pełna kadzidła; ");
INSERT INTO polubg_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Jeden młody cielec, jeden baran i jedno roczne jagnię na ofiarę całopalną; ");
INSERT INTO polubg_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Jeden kozioł z kóz na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","A na ofiarę pojednawczą – dwa woły, pięć baranów, pięć kozłów i pięć jednorocznych jagniąt. To była ofiara Szelumiela, syna Suriszaddaja. ");
INSERT INTO polubg_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Szóstego dnia ofiarę złożył naczelny synów Gada Eliasaf, syn Deuela. ");
INSERT INTO polubg_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Jego ofiarę stanowiły: jedna srebrna misa wagi stu trzydziestu syklów, jedna srebrna czasza wagi siedemdziesięciu syklów według sykla świątynnego, obydwie pełne mąki pszennej zmieszanej z oliwą, na ofiarę pokarmową; ");
INSERT INTO polubg_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Jedna czara z dziesięciu syklów złota pełna kadzidła; ");
INSERT INTO polubg_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Jeden młody cielec, jeden baran i jedno roczne jagnię na ofiarę całopalną; ");
INSERT INTO polubg_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Jeden kozioł z kóz na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","A na ofiarę pojednawczą – dwa woły, pięć baranów, pięć kozłów i pięć jednorocznych jagniąt. To była ofiara Eliasafa, syna Deuela. ");
INSERT INTO polubg_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Siódmego dnia ofiarę złożył naczelnik synów Efraima Eliszama, syn Ammihuda. ");
INSERT INTO polubg_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Jego ofiarę stanowiły: jedna srebrna misa wagi stu trzydziestu syklów, jedna srebrna czasza wagi siedemdziesięciu syklów według sykla świątynnego, obydwie pełne mąki pszennej zmieszanej z oliwą, na ofiarę pokarmową; ");
INSERT INTO polubg_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Jedna czara z dziesięciu syklów złota pełna kadzidła; ");
INSERT INTO polubg_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Jeden młody cielec, jeden baran i jedno roczne jagnię na ofiarę całopalną; ");
INSERT INTO polubg_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Jeden kozioł z kóz na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","A na ofiarę pojednawczą – dwa woły, pięć baranów, pięć kozłów i pięć jednorocznych jagniąt. To była ofiara Eliszamy, syna Ammihuda. ");
INSERT INTO polubg_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ósmego dnia ofiarę złożył naczelnik synów Manassesa Gamliel, syn Pedahsura. ");
INSERT INTO polubg_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Jego ofiarę stanowiły: jedna srebrna misa wagi stu trzydziestu syklów, jedna srebrna czasza wagi siedemdziesięciu syklów według sykla świątynnego, obydwie pełne mąki pszennej zmieszanej z oliwą, na ofiarę pokarmową; ");
INSERT INTO polubg_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Jedna czara z dziesięciu syklów złota pełna kadzidła; ");
INSERT INTO polubg_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Jeden młody cielec, jeden baran i jedno roczne jagnię na ofiarę całopalną; ");
INSERT INTO polubg_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Jeden kozioł z kóz na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","A na ofiarę pojednawczą – dwa woły, pięć baranów, pięć kozłów i pięć jednorocznych jagniąt. To była ofiara Gamliela, syna Pedahsura. ");
INSERT INTO polubg_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Dziewiątego dnia ofiarę złożył naczelnik synów Beniamina Abidan, syn Gideoniego. ");
INSERT INTO polubg_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Jego ofiarę stanowiły: jedna srebrna misa wagi stu trzydziestu syklów, jedna srebrna czasza wagi siedemdziesięciu syklów według sykla świątynnego, obydwie pełne mąki pszennej zmieszanej z oliwą, na ofiarę pokarmową; ");
INSERT INTO polubg_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Jedna czara z dziesięciu syklów złota pełna kadzidła; ");
INSERT INTO polubg_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Jeden młody cielec, jeden baran i jedno roczne jagnię na ofiarę całopalną; ");
INSERT INTO polubg_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Jeden kozioł z kóz na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","A na ofiarę pojednawczą – dwa woły, pięć baranów, pięć kozłów i pięć jednorocznych jagniąt. To była ofiara Abidana, syna Gideoniego. ");
INSERT INTO polubg_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Dziesiątego dnia ofiarę złożył naczelnik synów Dana Achiezer, syn Ammiszaddaja. ");
INSERT INTO polubg_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Jego ofiarę stanowiły: jedna srebrna misa wagi stu trzydziestu syklów, jedna srebrna czasza wagi siedemdziesięciu syklów według sykla świątynnego, obydwie pełne mąki pszennej zmieszanej z oliwą, na ofiarę pokarmową; ");
INSERT INTO polubg_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Jedna czara z dziesięciu syklów złota pełna kadzidła; ");
INSERT INTO polubg_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Jeden młody cielec, jeden baran i jedno roczne jagnię na ofiarę całopalną; ");
INSERT INTO polubg_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Jeden kozioł z kóz na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","A na ofiarę pojednawczą – dwa woły, pięć baranów, pięć kozłów i pięć jednorocznych jagniąt. To była ofiara Achiezera, syna Ammiszadaja. ");
INSERT INTO polubg_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Jedenastego dnia ofiarę złożył naczelnik synów Aszera Pagiel, syn Okrana. ");
INSERT INTO polubg_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Jego ofiarę stanowiły: jedna srebrna misa wagi stu trzydziestu syklów, jedna srebrna czasza wagi siedemdziesięciu syklów według sykla świątynnego, obydwie pełne mąki pszennej zmieszanej z oliwą, na ofiarę pokarmową; ");
INSERT INTO polubg_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Jedna czara z dziesięciu syklów złota pełna kadzidła; ");
INSERT INTO polubg_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Jeden młody cielec, jeden baran i jedno roczne jagnię na ofiarę całopalną; ");
INSERT INTO polubg_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Jeden kozioł z kóz na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","A na ofiarę pojednawczą – dwa woły, pięć baranów, pięć kozłów i pięć jednorocznych jagniąt. To była ofiara Pagiela, syna Okrana. ");
INSERT INTO polubg_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Dwunastego dnia ofiarę złożył naczelnik synów Neftalego Achira, syn Enana. ");
INSERT INTO polubg_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Jego ofiarę stanowiły: jedna srebrna misa wagi stu trzydziestu syklów, jedna srebrna czasza wagi siedemdziesięciu syklów według sykla świątynnego, obydwie pełne mąki pszennej zmieszanej z oliwą, na ofiarę pokarmową; ");
INSERT INTO polubg_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Jedna czara z dziesięciu syklów złota pełna kadzidła; ");
INSERT INTO polubg_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Jeden młody cielec, jeden baran i jedno roczne jagnię na ofiarę całopalną; ");
INSERT INTO polubg_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Jeden kozioł z kóz na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","A na ofiarę pojednawczą – dwa woły, pięć baranów, pięć kozłów i pięć jednorocznych jagniąt. To była ofiara Achiry, syna Enana. ");
INSERT INTO polubg_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","To było poświęcenie ołtarza, w tym dniu, w którym został namaszczony przez naczelników Izraela: dwanaście srebrnych mis, dwanaście srebrnych czasz, dwanaście złotych czar; ");
INSERT INTO polubg_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Każda srebrna misa ważyła sto trzydzieści syklów, każda czasza – siedemdziesiąt syklów. Całego srebra w tych naczyniach było dwa tysiące czterysta syklów według sykla świątynnego; ");
INSERT INTO polubg_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Złotych czar było dwanaście, pełnych kadzidła; każda ważyła dziesięć syklów według sykla świątynnego. Całego złota w tych czarach było sto dwadzieścia syklów. ");
INSERT INTO polubg_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Wszystkich zwierząt na ofiarę całopalną było: dwanaście cielców, dwanaście baranów, dwanaście jednorocznych jagniąt wraz z ich ofiarą pokarmową i dwanaście kozłów z kóz na ofiarę za grzech. ");
INSERT INTO polubg_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","A wszystkich zwierząt na ofiarę pojednawczą było: dwadzieścia cztery woły, sześćdziesiąt baranów, sześćdziesiąt kozłów i sześćdziesiąt jednorocznych jagniąt. To było poświęcenie ołtarza po jego namaszczeniu. ");
INSERT INTO polubg_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","A gdy Mojżesz wchodził do Namiotu Zgromadzenia, aby rozmawiać z Bogiem, wtedy słyszał głos mówiącego do niego z przebłagalni, która była nad arką świadectwa, spomiędzy dwóch cherubinów. I przemawiał do niego. ");
INSERT INTO polubg_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","I PAN przemówił do Mojżesza tymi słowy: ");
INSERT INTO polubg_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Powiedz Aaronowi: Gdy zapalisz lampy, siedem lamp ma rzucać światło na przednią stronę świecznika. ");
INSERT INTO polubg_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","I Aaron tak uczynił. Z przedniej strony świecznika zapalił lampy, tak jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Świecznik był wykuty ze złota, od trzonu aż po kwiaty był kuty. Zgodnie ze wzorem, który PAN pokazał Mojżeszowi, tak zrobił świecznik. ");
INSERT INTO polubg_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Weź Lewitów spośród synów Izraela i oczyść ich. ");
INSERT INTO polubg_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","I tak postąpisz z nimi, aby ich oczyścić: Pokrop ich wodą oczyszczenia, a oni niech ogolą całe swoje ciało i wypiorą swoje szaty, wtedy będą czyści. ");
INSERT INTO polubg_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Następnie niech wezmą młodego cielca wraz z jego ofiarą pokarmową z mąki pszennej zmieszanej z oliwą, drugiego zaś młodego cielca weźmiesz na ofiarę za grzech. ");
INSERT INTO polubg_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","I przyprowadzisz Lewitów przed Namiot Zgromadzenia, i zbierzesz całe zgromadzenie synów Izraela; ");
INSERT INTO polubg_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","I przyprowadzisz Lewitów przed PANA, a synowie Izraela położą na nich swoje ręce. ");
INSERT INTO polubg_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Wtedy Aaron przedstawi Lewitów przed PANEM jako ofiarę od synów Izraela, aby pełnili służbę dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Lewici zaś położą swoje ręce na głowy cielców. Ty złożysz jednego na ofiarę za grzech, a drugiego na ofiarę całopalną dla PANA, aby dokonać przebłagania za Lewitów. ");
INSERT INTO polubg_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Następnie postawisz Lewitów przed Aaronem i przed jego synami i przedstawisz ich jako ofiarę dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","W ten sposób oddzielisz Lewitów spośród synów Izraela i Lewici będą należeć do mnie. ");
INSERT INTO polubg_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Potem Lewici wejdą, aby służyć w Namiocie Zgromadzenia, gdy ich oczyścisz i przedstawisz jako ofiarę. ");
INSERT INTO polubg_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Oni bowiem są mi oddani spośród synów Izraela; w miejsce każdego, kto otwiera łono, w miejsce wszystkich pierworodnych synów Izraela wziąłem ich sobie. ");
INSERT INTO polubg_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Gdyż do mnie należy wszystko, co pierworodne wśród synów Izraela, zarówno z ludzi, jak i ze zwierząt. Poświęciłem ich sobie w dniu, w którym zabiłem wszystko, co pierworodne w ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Wziąłem Lewitów w zamian za wszystkich pierworodnych wśród synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","I dałem Lewitów jako dar Aaronowi i jego synom spośród synów Izraela, aby pełnili służbę synów Izraela w Namiocie Zgromadzenia i dokonywali przebłagania za nich, aby nie spadła na synów Izraela żadna kara, gdy będą zbliżać się do świątyni. ");
INSERT INTO polubg_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Wtedy Mojżesz i Aaron oraz całe zgromadzenie synów Izraela postąpili z Lewitami tak, jak PAN rozkazał Mojżeszowi o Lewitach; tak postąpili z nimi synowie Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lewici oczyścili się i wyprali swoje szaty, a Aaron przedstawił ich jako ofiarę przed PANEM i dokonał przebłagania za nich, aby ich oczyścić. ");
INSERT INTO polubg_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Potem Lewici weszli, aby pełnić swoją służbę w Namiocie Zgromadzenia przed Aaronem i przed jego synami. Jak PAN rozkazał Mojżeszowi odnośnie do Lewitów, tak z nimi postąpili. ");
INSERT INTO polubg_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Oto co dotyczy Lewitów: Od dwudziestego piątego roku życia wzwyż przystąpią, by pełnić służbę w Namiocie Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","A od pięćdziesiątego roku życia przestaną pełnić służbę i więcej nie będą służyć. ");
INSERT INTO polubg_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Będą jednak usługiwać swym braciom w Namiocie Zgromadzenia w pełnieniu straży, lecz samej służby nie będą pełnić. Tak postąpisz z Lewitami w sprawie ich służby. ");
INSERT INTO polubg_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","I przemówił PAN do Mojżesza na pustyni Synaj, w pierwszym miesiącu drugiego roku po ich wyjściu z ziemi Egiptu, tymi słowy: ");
INSERT INTO polubg_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Niech synowie Izraela obchodzą Paschę w wyznaczonym czasie. ");
INSERT INTO polubg_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Będziecie ją obchodzić w wyznaczonym czasie, czternastego dnia tego miesiąca pod wieczór; macie ją obchodzić według wszystkich jej obrzędów i wszystkich jej ceremonii. ");
INSERT INTO polubg_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Mojżesz nakazał więc synom Izraela, aby obchodzili Paschę. ");
INSERT INTO polubg_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","I obchodzili Paschę w pierwszym miesiącu, czternastego dnia, pod wieczór, na pustyni Synaj. Zgodnie ze wszystkim, co PAN nakazał Mojżeszowi, tak synowie Izraela uczynili. ");
INSERT INTO polubg_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Byli jednak pewni ludzie, którzy zanieczyścili się przy zwłokach ludzkich, i nie mogli obchodzić Paschy tego dnia. Przyszli więc w tym dniu do Mojżesza i Aarona; ");
INSERT INTO polubg_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","I powiedzieli do niego: Zanieczyściliśmy się przy zwłokach ludzkich. Czemu nie będzie nam wolno złożyć PANU ofiar w wyznaczonym czasie wspólnie z synami Izraela? ");
INSERT INTO polubg_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mojżesz odpowiedział im: Stójcie, a ja posłucham, co PAN rozkaże o was. ");
INSERT INTO polubg_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Wtedy PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Powiedz synom Izraela tak: Jeśli kto z was lub z waszych potomków zanieczyści się przy zmarłym albo też będzie w dalekiej podróży, mimo to będzie obchodził Paschę dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Będą ją obchodzić w drugim miesiącu, czternastego dnia, pod wieczór, i będą ją jeść z przaśnymi chlebami i z gorzkimi ziołami. ");
INSERT INTO polubg_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Nie pozostawią z niej nic do rana ani nie połamią jej kości. Zgodnie ze wszystkimi przepisami Paschy będą ją obchodzić. ");
INSERT INTO polubg_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Lecz człowiek, który jest czysty, a nie znajduje się w drodze, i nie będzie obchodził Paschy, to ta dusza będzie wykluczona ze swego ludu, bo ofiary PANA nie złożyła w wyznaczonym czasie. Ten człowiek obciąża się grzechem. ");
INSERT INTO polubg_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","A jeśli przybysz, który mieszka pośród was, będzie obchodził Paschę dla PANA, to ma ją obchodzić według ustawy i zwyczajów Paschy. Będzie jedna ustawa dla was, zarówno dla przybysza, jak i dla rodowitego mieszkańca ziemi. ");
INSERT INTO polubg_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","W dniu, w którym wystawiono przybytek, obłok okrył przybytek, czyli Namiot Świadectwa, a wieczorem był nad przybytkiem i przypominał z wyglądu ogień, aż do rana. ");
INSERT INTO polubg_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Tak było stale: obłok okrywał go w dzień, a w nocy jakby ogień. ");
INSERT INTO polubg_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","A gdy obłok unosił się znad namiotu, wtedy synowie Izraela wyruszali, a gdziekolwiek obłok zatrzymał się, tam synowie Izraela rozbijali obóz. ");
INSERT INTO polubg_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Na rozkaz PANA synowie Izraela wyruszali i na rozkaz PANA rozbijali obóz. Przez wszystkie dni, w których obłok pozostawał nad przybytkiem, stali obozem. ");
INSERT INTO polubg_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","A kiedy obłok pozostawał nad przybytkiem przez wiele dni, wtedy synowie Izraela przestrzegali rozkazu PANA i nie wyruszali. ");
INSERT INTO polubg_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Lecz gdy obłok pozostawał nad przybytkiem przez kilka dni, na rozkaz PANA stawali obozem i na rozkaz PANA wyruszali. ");
INSERT INTO polubg_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","A gdy obłok pozostawał od wieczora do rana i unosił się rano, wówczas wyruszali. Czy obłok unosił się za dnia, czy w nocy, oni wyruszali. ");
INSERT INTO polubg_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","A jeśli obłok trwał i pozostawał nad przybytkiem przez dwa dni albo przez miesiąc bądź też przez rok, synowie Izraela stali obozem i nie wyruszali, lecz gdy się unosił, wyruszali. ");
INSERT INTO polubg_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Na rozkaz PANA stawali obozem i na rozkaz PANA wyruszali. Przestrzegali nakazu PANA, tak jak PAN rozkazał przez Mojżesza. ");
INSERT INTO polubg_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Zrób sobie dwie srebrne trąby. Wykonasz je robotą kutą, a będą ci służyć do zwoływania ludu i do nawoływania w drogę obozów. ");
INSERT INTO polubg_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","A gdy w nie zadmą, wtedy cały lud zgromadzi się do ciebie, u wejścia do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","A jeśli zadmą tylko w jedną trąbę, zejdą się do ciebie wodzowie, naczelnicy tysięcy Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Gdy zatrąbicie, wydając urwany dźwięk, wtedy wyruszą obozy rozłożone po stronie wschodniej. ");
INSERT INTO polubg_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","A gdy drugi raz zatrąbicie, wydając urwany głos, wyruszą obozy rozłożone po stronie południowej. Będą trąbić, wydając urwany dźwięk, kiedy mają wyruszyć. ");
INSERT INTO polubg_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ale gdy będziecie zwoływać lud, zatrąbicie bez wydawania urywanego dźwięku. ");
INSERT INTO polubg_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","A synowie Aarona, kapłani, zadmą w trąby. Będzie to wieczysta ustawa dla was przez wszystkie wasze pokolenia. ");
INSERT INTO polubg_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","A gdy w waszej ziemi wyruszycie na wojnę przeciw wrogowi, który was gnębi, zadmiecie w trąby urwanym dźwiękiem; a przypomnicie się PANU, waszemu Bogu, i zostaniecie wybawieni od waszych wrogów. ");
INSERT INTO polubg_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Także w dniu waszej radości, w wasze uroczyste święta oraz podczas waszych nowiów zadmiecie w trąby przy waszych ofiarach całopalnych i przy waszych ofiarach pojednawczych; będą one dla was pamiątką przed waszym Bogiem. Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","I w drugim roku, drugiego miesiąca, dwudziestego dnia tego miesiąca uniósł się obłok znad Przybytku Świadectwa. ");
INSERT INTO polubg_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","I synowie Izraela wyruszyli z pustyni Synaj, a obłok zatrzymał się na pustyni Paran. ");
INSERT INTO polubg_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","I po raz pierwszy wyruszyli tak, jak PAN rozkazał przez Mojżesza. ");
INSERT INTO polubg_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Pierwsza ruszyła chorągiew obozu synów Judy według swoich zastępów, a na czele jego wojska był Nachszon, syn Amminadaba. ");
INSERT INTO polubg_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Na czele wojska pokolenia synów Issachara był Netaneel, syn Suara. ");
INSERT INTO polubg_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Na czele wojska pokolenia synów Zebulona był Eliab, syn Chelona. ");
INSERT INTO polubg_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Potem złożono przybytek i wyruszyli synowie Gerszona i synowie Merariego, niosąc przybytek. ");
INSERT INTO polubg_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Następnie ruszyła chorągiew obozu Rubena według swoich zastępów, a na czele jego wojska był Elizur, syn Szedeura. ");
INSERT INTO polubg_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Na czele wojska pokolenia synów Symeona był Szelumiel, syn Suriszaddaja. ");
INSERT INTO polubg_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Na czele wojska pokolenia synów Gada był Eliasaf, syn Duela. ");
INSERT INTO polubg_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Następnie wyruszyli Kehatyci, niosąc świątynię. Zanim przyszli, inni ustawiali przybytek. ");
INSERT INTO polubg_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Potem ruszyła chorągiew obozu synów Efraima według swoich zastępów, a na czele jego wojska był Eliszama, syn Ammihuda. ");
INSERT INTO polubg_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Na czele wojsk pokolenia synów Manassesa był Gamliel, syn Pedahsura. ");
INSERT INTO polubg_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Na czele wojska pokolenia synów Beniamina był Abidan, syn Gideoniego. ");
INSERT INTO polubg_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Następnie ruszyła chorągiew obozu synów Dana, tworząc tylną straż wszystkich obozów, według swoich zastępów, a na czele jego wojska był Achiezer, syn Ammiszaddaja. ");
INSERT INTO polubg_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Na czele wojska pokolenia synów Aszera był Pagiel, syn Okrana. ");
INSERT INTO polubg_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Na czele wojska pokolenia synów Neftalego był Achira, syn Enana. ");
INSERT INTO polubg_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Taki był porządek marszu synów Izraela według ich zastępów i tak ruszali. ");
INSERT INTO polubg_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Potem Mojżesz powiedział do Chobaba, syna Reuela Midianity, swego teścia: Wyruszamy do miejsca, o którym PAN powiedział: Dam je wam. Chodź z nami, a wyświadczymy ci dobro, ponieważ PAN obiecał wiele dobrego Izraelowi. ");
INSERT INTO polubg_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ten mu odpowiedział: Nie pójdę, lecz wrócę do mojej ziemi i do mojej rodziny. ");
INSERT INTO polubg_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mojżesz powiedział: Proszę, nie opuszczaj nas, bo ty wiesz, gdzie na pustyni możemy rozbić obóz, i możesz być naszym przewodnikiem. ");
INSERT INTO polubg_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Jeśli pójdziesz z nami, wyświadczymy ci to dobro, które PAN nam uczyni. ");
INSERT INTO polubg_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","I wyruszyli od góry PANA w drogę na trzy dni, a arka przymierza PANA szła przed nimi podczas tych trzech dni drogi, aby upatrzyć dla nich miejsce odpoczynku. ");
INSERT INTO polubg_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","A obłok PANA był nad nimi za dnia, gdy wyruszali z obozu. ");
INSERT INTO polubg_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","A gdy arka miała ruszyć, wtedy Mojżesz mówił: Powstań, PANIE, a niech rozproszą się twoi wrogowie i niech uciekają przed tobą ci, którzy cię nienawidzą. ");
INSERT INTO polubg_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Gdy zaś się zatrzymywała, wtedy mówił: Wróć, PANIE, do niezliczonych tysięcy Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","A lud zaczął się skarżyć, co się PANU nie podobało. Gdy więc PAN to usłyszał, bardzo się rozgniewał. I ogień PANA zapalił się przeciwko niemu i pochłonął krańce obozu. ");
INSERT INTO polubg_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Wtedy wołał lud na Mojżesza, a Mojżesz pomodlił się do PANA i ogień zgasł. ");
INSERT INTO polubg_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","I nazwał to miejsce Tabera, bo ogień PANA zapalił się przeciwko nim. ");
INSERT INTO polubg_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","A pospólstwo, które było wśród nich, ogarnęło pragnienie. Synowie Izraela też płakali na nowo i mówili: Któż nas nakarmi mięsem? ");
INSERT INTO polubg_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Wspominamy ryby, które jedliśmy w Egipcie za darmo, ogórki, melony, pory, cebulę i czosnek. ");
INSERT INTO polubg_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","A teraz nasza dusza wyschła, bo nic innego przed oczami nie mamy oprócz tej manny. ");
INSERT INTO polubg_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","A manna była jak nasienie kolendry, a jej kolor jak kolor bdellium. ");
INSERT INTO polubg_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Ludzie wychodzili i zbierali ją, i mełli w żarnach albo tłukli w moździerzach, potem gotowali w kotłach i robili z niej placki. Jej smak był jak smak świeżej oliwy. ");
INSERT INTO polubg_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Gdy bowiem nocą opadała rosa na obóz, spadała też na niego manna. ");
INSERT INTO polubg_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Wtedy Mojżesz usłyszał, że lud płacze w swoich rodzinach, każdy przy wejściu do swojego namiotu. Wówczas mocno zapłonął gniew PANA, a i Mojżeszowi to się nie podobało. ");
INSERT INTO polubg_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","I Mojżesz powiedział do PANA: Dlaczego tak źle się obchodzisz ze swoim sługą? Dlaczego nie znalazłem łaski w twoich oczach, że włożyłeś na mnie ciężar całego tego ludu? ");
INSERT INTO polubg_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Czy ja począłem cały ten lud? Czy ja go zrodziłem, że mówisz do mnie: Nieś go na swoim łonie jak opiekun nosi niemowlę do ziemi, którą przysiągłeś ich ojcom? ");
INSERT INTO polubg_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Skąd wezmę mięso, aby dać całemu temu ludowi? Płaczą bowiem przede mną i mówią: Daj nam mięsa, abyśmy mogli jeść. ");
INSERT INTO polubg_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Nie mogę sam znosić całego tego ludu, gdyż jest dla mnie zbyt ciężki. ");
INSERT INTO polubg_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","A jeśli tak ze mną postępujesz, to raczej zabij mnie, proszę, jeśli znalazłem łaskę w twoich oczach, abym nie patrzył na swoją niedolę. ");
INSERT INTO polubg_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","I PAN powiedział do Mojżesza: Zbierz mi siedemdziesięciu mężczyzn spośród starszych Izraela, o których wiesz, że są starszymi ludu oraz jego przełożonymi, przyprowadź ich do Namiotu Zgromadzenia i niech tam staną wraz z tobą. ");
INSERT INTO polubg_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","A ja zstąpię i będę tam z tobą rozmawiał. Potem wezmę z ducha, który jest na tobie, i złożę na nich. Będą nosić razem z tobą brzemię ludu, abyś nie musiał go nosić ty sam. ");
INSERT INTO polubg_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","A do ludu powiesz: Poświęćcie się na jutro, a będziecie jeść mięso. Płakaliście bowiem, a to dotarło do uszu PANA: Któż nas nakarmi mięsem? Bo było nam lepiej w Egipcie! PAN da wam więc mięso i będziecie jeść. ");
INSERT INTO polubg_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Będziecie je jeść nie przez jeden dzień ani nie przez dwa dni, ani przez pięć, ani przez dziesięć dni, ani przez dwadzieścia dni; ");
INSERT INTO polubg_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Lecz przez cały miesiąc, aż wam wyjdzie przez nozdrza i zupełnie wam obrzydnie. Wzgardziliście bowiem PANEM, który jest wśród was, i płakaliście przed nim, mówiąc: Po co wyszliśmy z Egiptu? ");
INSERT INTO polubg_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mojżesz powiedział: Sześćset tysięcy pieszych liczy ten lud, pośród którego mieszkam, a ty powiedziałeś: Dam im mięsa i będą jeść przez cały miesiąc. ");
INSERT INTO polubg_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Czy można zabić tyle owiec i wołów, aby im wystarczyło? Czy można dla nich zebrać wszystkie ryby morskie, aby mieli dosyć? ");
INSERT INTO polubg_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","PAN powiedział do Mojżesza: Czy ręka PANA jest zbyt krótka? Teraz zobaczysz, czy moje słowo się wypełni, czy też nie. ");
INSERT INTO polubg_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mojżesz wyszedł więc i opowiedział ludowi słowa PANA. Następnie zebrał siedemdziesięciu mężczyzn spośród starszych ludu i postawił ich wokół namiotu. ");
INSERT INTO polubg_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Wtedy PAN zstąpił w obłoku i przemówił do niego. Potem wziął z ducha, który był na nim, i dał go siedemdziesięciu starszym. A gdy spoczął na nich duch, prorokowali i nie przestali. ");
INSERT INTO polubg_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Lecz dwaj mężczyźni pozostali w obozie: jeden miał na imię Eldad, a drugi – Medad. Na nich też spoczął duch, bo oni byli wśród spisanych, choć nie przybyli do namiotu. Prorokowali jednak w obozie. ");
INSERT INTO polubg_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Wtedy młodzieniec przybiegł i powiedział do Mojżesza: Eldad i Medad prorokują w obozie. ");
INSERT INTO polubg_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","A Jozue, syn Nuna, sługa Mojżesza i jeden z jego młodzieńców, powiedział: Mojżeszu, panie mój, zabroń im. ");
INSERT INTO polubg_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mojżesz odpowiedział: Czy jesteś zazdrosny o mnie? Oby cały lud PANA zamienił się w proroków, aby PAN złożył na nim swego ducha! ");
INSERT INTO polubg_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Wtedy Mojżesz wrócił do obozu wraz ze starszymi Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","I zerwał się wiatr od PANA, który porwał od morza przepiórki i zrzucił je na obóz, na jeden dzień drogi z jednej strony i na jeden dzień drogi z drugiej strony, wokół obozu, wysoko na dwa łokcie nad ziemią. ");
INSERT INTO polubg_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Lud stał przez cały dzień, przez całą noc i przez cały następny dzień i zbierał przepiórki. Ten, kto zebrał najmniej, miał dziesięć chomerów. I rozłożyli je sobie wokół obozu. ");
INSERT INTO polubg_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Lecz gdy mięso było między ich zębami, jeszcze nieprzeżute, gniew PANA zapłonął przeciw ludowi i uderzył go wielką plagą. ");
INSERT INTO polubg_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","I nazwano to miejsce Kibrot-Hattaawa, bo tam pochowano lud, który zapragnął mięsa. ");
INSERT INTO polubg_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","A z Kibrot-Hattaawy lud wyruszył do Chaserot; i mieszkał w Chaserot. ");
INSERT INTO polubg_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Wtedy Miriam i Aaron mówili źle przeciwko Mojżeszowi z powodu etiopskiej kobiety, którą pojął. Pojął bowiem za żonę Etiopkę; ");
INSERT INTO polubg_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","I mówili: Czy PAN przemawiał tylko przez Mojżesza? Czy nie przemawiał też przez nas? A PAN to usłyszał. ");
INSERT INTO polubg_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","A Mojżesz był człowiekiem bardzo pokornym, najbardziej ze wszystkich ludzi, którzy żyli na ziemi. ");
INSERT INTO polubg_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","I nagle PAN powiedział do Mojżesza, Aarona i Miriam: Wyjdźcie we troje do Namiotu Zgromadzenia. I wyszli we troje. ");
INSERT INTO polubg_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Wtedy PAN zstąpił w słupie obłoku, stanął u wejścia do namiotu i wezwał Aarona i Miriam; a oni przyszli oboje. ");
INSERT INTO polubg_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","I powiedział do nich: Słuchajcie teraz moich słów: Jeśli będzie wśród was prorok, ja, PAN, objawię mu się w widzeniu, będę mówił do niego we śnie. ");
INSERT INTO polubg_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Lecz nie tak jest z moim sługą Mojżeszem, który jest wierny w całym moim domu. ");
INSERT INTO polubg_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Z ust do ust mówię do niego, jawnie, a nie w zagadkach; on ogląda postać PANA. Dlaczego nie baliście się mówić źle przeciwko memu słudze Mojżeszowi? ");
INSERT INTO polubg_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","I zapłonął gniew PANA przeciwko nim, i odszedł. ");
INSERT INTO polubg_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Obłok także odstąpił znad namiotu i oto Miriam stała się trędowata, biała jak śnieg. Gdy Aaron spojrzał na Miriam, oto była trędowata. ");
INSERT INTO polubg_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Wtedy Aaron powiedział do Mojżesza: Ach, mój panie! Proszę, nie poczytaj nam tego grzechu, że głupio postąpiliśmy i zgrzeszyliśmy. ");
INSERT INTO polubg_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Niech ona nie będzie jak martwy płód, którego ciało jest już na wpół rozłożone, gdy wychodzi z łona swojej matki. ");
INSERT INTO polubg_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Wtedy Mojżesz zawołał do PANA: Boże, proszę, uzdrów ją teraz. ");
INSERT INTO polubg_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","I PAN odpowiedział Mojżeszowi: Gdyby jej ojciec plunął jej w twarz, czyż nie musiałaby się wstydzić przez siedem dni? Niech przez siedem dni będzie wyłączona z obozu, a potem zostanie przyjęta. ");
INSERT INTO polubg_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","I Miriam została wyłączona z obozu na siedem dni. Lud jednak nie wyruszył, póki Miriam nie została przyjęta. ");
INSERT INTO polubg_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Potem lud wyruszył z Chaserot i rozbił obóz na pustyni Paran. ");
INSERT INTO polubg_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Wyślij mężczyzn, aby wyszpiegowali ziemię Kanaan, którą daję synom Izraela. Z każdego pokolenia ich ojców wyślecie po jednym mężczyźnie; tych, którzy są wśród nich wodzami. ");
INSERT INTO polubg_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Wysłał ich więc Mojżesz z pustyni Paran, zgodnie z rozkazem PANA. Wszyscy ci mężczyźni byli naczelnikami wśród synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","A oto są ich imiona: z pokolenia Rubena – Szamua, syn Zakkura. ");
INSERT INTO polubg_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Z pokolenia Symeona – Szafat, syn Choriego. ");
INSERT INTO polubg_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Z pokolenia Judy – Kaleb, syn Jefunnego. ");
INSERT INTO polubg_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Z pokolenia Issachara – Jigal, syn Józefa. ");
INSERT INTO polubg_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Z pokolenia Efraima – Ozeasz, syn Nuna. ");
INSERT INTO polubg_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Z pokolenia Beniamina – Palti, syn Rafua. ");
INSERT INTO polubg_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Z pokolenia Zebulona – Gaddiel, syn Sodiego. ");
INSERT INTO polubg_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Z pokolenia Józefa, to jest z potomstwa Manassesa – Gaddi, syn Susiego. ");
INSERT INTO polubg_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Z pokolenia Dana – Ammiel, syn Gemalliego. ");
INSERT INTO polubg_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Z pokolenia Aszera – Setur, syn Mikaela. ");
INSERT INTO polubg_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Z pokolenia Neftalego – Nachbi, syn Wafsiego. ");
INSERT INTO polubg_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Z pokolenia Gada – Geuel, syn Makiego. ");
INSERT INTO polubg_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","To są imiona mężczyzn, których Mojżesz wysłał, aby wyszpiegowali ziemię. A Ozeaszowi, synowi Nuna, nadał imię Jozue. ");
INSERT INTO polubg_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","A gdy Mojżesz wysłał ich, aby wyszpiegowali ziemię Kanaan, powiedział do nich: Idźcie w tę stronę, na południe, i wejdźcie na górę; ");
INSERT INTO polubg_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","I obejrzyjcie ziemię, jaka ona jest, oraz lud, który w niej mieszka, czy jest silny, czy słaby, czy jest ich mało, czy wielu. ");
INSERT INTO polubg_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","I jaka jest ziemia, w której mieszkają: czy jest dobra, czy zła. I jakie są miasta, w których mieszkają: czy to są obozowiska, czy warownie. ");
INSERT INTO polubg_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","I jaka jest ziemia: czy urodzajna, czy jałowa; czy są na niej drzewa, czy nie. Bądźcie odważni i przynieście nam z owocu tamtej ziemi. A był to czas dojrzewania winogron. ");
INSERT INTO polubg_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Poszli więc i wyszpiegowali ziemię, od pustyni Syn aż do Rechob, którędy wchodzi się do Chamat. ");
INSERT INTO polubg_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","A kierując się na południe, dotarli do Hebronu, gdzie byli Achiman, Szeszaj i Talmaj, synowie Anaka; a Hebron zbudowano siedem lat przed Soan w Egipcie. ");
INSERT INTO polubg_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Potem przybyli do potoku Eszkol i ucięli tam gałąź z jedną kiścią winogron, i nieśli ją we dwóch na drążku; wzięli też jabłka granatu i figi. ");
INSERT INTO polubg_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","I nazwano to miejsce potokiem Eszkol od winogrona, które synowie Izraela tam ucięli. ");
INSERT INTO polubg_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","I po czterdziestu dniach wrócili z wyszpiegowania ziemi. ");
INSERT INTO polubg_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","A kiedy wrócili, przyszli do Mojżesza, Aarona i całego zgromadzenia synów Izraela na pustynię Paran, do Kadesz; zdali sprawę im oraz całemu zgromadzeniu, pokazali im też owoce tej ziemi. ");
INSERT INTO polubg_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","I opowiedzieli mu: Przyszliśmy do ziemi, do której nas wysłałeś. Ona rzeczywiście opływa mlekiem i miodem, a to są jej owoce; ");
INSERT INTO polubg_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Tylko że lud, który mieszka w tej ziemi, jest silny, a miasta są obwarowane i bardzo wielkie; widzieliśmy tam również synów Anaka. ");
INSERT INTO polubg_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalekici mieszkają w południowej części ziemi, a Chetyci, Jebusyci, Amoryci mieszkają w górach; Kananejczycy zaś mieszkają nad morzem i nad brzegiem Jordanu. ");
INSERT INTO polubg_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Wtedy Kaleb uspokajał lud szemrzący przeciw Mojżeszowi i mówił: Pójdźmy i posiądźmy ziemię, bo zdołamy ją podbić. ");
INSERT INTO polubg_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Lecz mężczyźni, którzy z nim poszli, powiedzieli: Nie możemy wyruszyć przeciw tamtemu ludowi, bo jest silniejszy od nas. ");
INSERT INTO polubg_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","I rozpuścili wśród synów Izraela złą wieść o ziemi, którą wyszpiegowali, mówiąc: Ziemia, przez którą przeszliśmy, aby ją zbadać, jest ziemią, która pożera swoich mieszkańców, a wszyscy ludzie, których w niej widzieliśmy, to ludzie wysokiego wzrostu. ");
INSERT INTO polubg_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Tam też widzieliśmy olbrzymów, synów Anaka, pochodzących od olbrzymów. Przy nich wydaliśmy się sobie jak szarańcza, takimi też byliśmy w ich oczach. ");
INSERT INTO polubg_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Wtedy całe zgromadzenie podniosło donośny lament i lud płakał tej nocy. ");
INSERT INTO polubg_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","I wszyscy synowie Izraela szemrali przeciwko Mojżeszowi i Aaronowi; i całe zgromadzenie mówiło do nich: Obyśmy pomarli w ziemi Egiptu albo na tej pustyni! ");
INSERT INTO polubg_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Po co PAN prowadzi nas do tej ziemi? Abyśmy padli od miecza? Aby nasze żony i dzieci stały się łupem? Czy nie lepiej nam wrócić do Egiptu? ");
INSERT INTO polubg_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","I mówili między sobą: Ustanówmy sobie wodza i wróćmy do Egiptu. ");
INSERT INTO polubg_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Wtedy Mojżesz i Aaron upadli na twarz przed całym zgromadzeniem synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","A Jozue, syn Nuna, i Kaleb, syn Jefunnego, którzy byli wśród tych, co wyszpiegowali ziemię, rozdarli swoje szaty; ");
INSERT INTO polubg_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","I powiedzieli do całego zgromadzenia synów Izraela: Ziemia, przez którą przeszliśmy, aby ją wyszpiegować, jest ziemią bardzo dobrą. ");
INSERT INTO polubg_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Jeśli PAN upodoba nas sobie, to wprowadzi nas do tej ziemi i da ją nam – tę ziemię, która opływa mlekiem i miodem. ");
INSERT INTO polubg_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Tylko nie buntujcie się przeciwko PANU ani nie bójcie się ludu tej ziemi, bo będą naszym chlebem; ich obrona odwróciła się od nich, a PAN jest z nami. Nie bójcie się ich. ");
INSERT INTO polubg_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","I całe zgromadzenie mówiło, aby ich ukamienować; ale chwała PANA ukazała się wszystkim synom Izraela nad Namiotem Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","I PAN powiedział do Mojżesza: Jak długo ten lud będzie mnie drażnić? Jak długo nie będzie mi wierzyć pomimo tych wszystkich znaków, które wśród nich uczyniłem? ");
INSERT INTO polubg_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Uderzę ich zarazą i wydziedziczę, a ciebie uczynię narodem większym i silniejszym niż oni. ");
INSERT INTO polubg_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Lecz Mojżesz powiedział do PANA: Usłyszą o tym Egipcjanie, spośród których wyprowadziłeś ten lud swoją mocą; ");
INSERT INTO polubg_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","I opowiedzą o tym obywatelom tej ziemi. Gdyż słyszeli, że ty, PANIE, jesteś pośród tego ludu, że ty, PANIE, bywasz widziany twarzą w twarz, że twój obłok stoi nad nimi i że kroczysz przed nimi w słupie obłoku za dnia, a w słupie ognia w nocy. ");
INSERT INTO polubg_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Gdybyś więc zabił ten lud jak jednego człowieka, to narody, które słyszały o twojej sławie, mówiłyby tak: ");
INSERT INTO polubg_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Ponieważ PAN nie mógł wprowadzić tego ludu do ziemi, którą im przysiągł, to zabił ich na pustyni. ");
INSERT INTO polubg_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Teraz więc proszę, niech się okaże wielka moc mojego PANA, jak powiedziałeś: ");
INSERT INTO polubg_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","PAN nierychły do gniewu i pełen wielkiego miłosierdzia, przebaczający nieprawość i przestępstwo, który nie uniewinnia winnego, lecz nawiedza nieprawość ojców na synach do trzeciego i czwartego pokolenia. ");
INSERT INTO polubg_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Przebacz, proszę, nieprawość twego ludu według wielkości twego miłosierdzia, tak jak przebaczałeś temu ludowi od Egiptu aż dotąd. ");
INSERT INTO polubg_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Wtedy PAN powiedział: Przebaczyłem według twego słowa. ");
INSERT INTO polubg_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ale jak żyję i jak cała ziemia jest napełniona chwałą PANA; ");
INSERT INTO polubg_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Tak wszyscy, którzy widzieli moją chwałę i moje znaki, które czyniłem w Egipcie i na pustyni, a wystawiali mnie na próbę już dziesięciokrotnie i nie słuchali mego głosu; ");
INSERT INTO polubg_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Nie zobaczą tej ziemi, którą przysiągłem ich ojcom, a żaden z tych, którzy mnie rozdrażnili, nie zobaczy jej. ");
INSERT INTO polubg_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ale mojego sługę Kaleba za to, że był w nim inny duch i trwał całkowicie przy mnie, wprowadzę do ziemi, do której wszedł, a jego potomstwo ją odziedziczy. ");
INSERT INTO polubg_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","A ponieważ Amalekici i Kananejczycy mieszkają w dolinie, to jutro zawróćcie i wyruszcie na pustynię, w kierunku Morza Czerwonego. ");
INSERT INTO polubg_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ponadto PAN powiedział do Mojżesza i Aarona: ");
INSERT INTO polubg_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Jak długo mam znosić ten zły lud, który szemrze przeciwko mnie? Słyszałem szemrania synów Izraela, jakie mówią przeciwko mnie. ");
INSERT INTO polubg_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Powiedz im: Jak żyję, mówi PAN, uczynię wam, jak mówiliście do moich uszu. ");
INSERT INTO polubg_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Na tej pustyni legną wasze trupy i wszyscy spisani wśród was, w pełnej liczbie, od dwudziestu lat wzwyż, którzy szemraliście przeciwko mnie; ");
INSERT INTO polubg_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Nie wejdziecie do tej ziemi, którą przysiągłem dać wam na mieszkanie, z wyjątkiem Kaleba, syna Jefunnego, i Jozuego, syna Nuna; ");
INSERT INTO polubg_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","A wasze dzieci, o których mówiliście, że staną się łupem, te wprowadzę i one zobaczą ziemię, którą wy wzgardziliście. ");
INSERT INTO polubg_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Wasze trupy zaś legną na tej pustyni; ");
INSERT INTO polubg_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","A wasi synowie będą się tułali po tej pustyni przez czterdzieści lat i poniosą karę za wasze cudzołóstwa, aż wasze trupy zniszczeją na pustyni. ");
INSERT INTO polubg_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Według liczby dni, w ciągu których wyszpiegowaliście ziemię, to znaczy czterdzieści dni, dzień za rok, będziecie ponosić karę za wasze nieprawości przez czterdzieści lat i poznacie pomstę za odstąpienie ode mnie. ");
INSERT INTO polubg_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ja, PAN, powiedziałem, że tak postąpię z całym tym niegodziwym zgromadzeniem, które się zmówiło przeciwko mnie; na tej pustyni zginą i tu pomrą. ");
INSERT INTO polubg_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Wtedy mężczyźni, których Mojżesz wysłał na wyszpiegowanie ziemi, a po powrocie pobudzili całe zgromadzenie do szemrania przeciwko niemu, rozpuszczając złą wieść o tej ziemi; ");
INSERT INTO polubg_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Ci mężczyźni, którzy rozpowiadali złą wieść o ziemi, pomarli przed PANEM wskutek plagi. ");
INSERT INTO polubg_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Lecz Jozue, syn Nuna, i Kaleb, syn Jefunnego, pozostali żywi spośród tych mężczyzn, którzy poszli wyszpiegować ziemię. ");
INSERT INTO polubg_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","I Mojżesz powtórzył te słowa wszystkim synom Izraela, i lud bardzo płakał. ");
INSERT INTO polubg_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Wstali więc wcześnie rano, wstąpili na szczyt góry i powiedzieli: Oto jesteśmy, pójdziemy na to miejsce, o którym PAN nam powiedział, bo zgrzeszyliśmy. ");
INSERT INTO polubg_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Lecz Mojżesz powiedział im: Dlaczego przekraczacie słowo PANA? To się wam nie uda. ");
INSERT INTO polubg_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Nie wyruszajcie, ponieważ nie ma PANA wśród was, abyście nie zostali pobici przez waszych wrogów. ");
INSERT INTO polubg_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Gdyż Amalekici i Kananejczycy są tam przed wami i polegniecie od miecza. Ponieważ odwróciliście się od PANA, to PAN nie będzie z wami. ");
INSERT INTO polubg_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Oni jednak uparli się, by wejść na szczyt góry. Lecz arka przymierza PANA i Mojżesz nie oddalili się z obozu. ");
INSERT INTO polubg_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Wtedy Amalekici i Kananejczycy mieszkający na tej górze zstąpili, pobili ich i ścigali aż do Chormy. ");
INSERT INTO polubg_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Przemów do synów Izraela i powiedz im: Gdy przyjdziecie do ziemi waszego mieszkania, którą wam daję; ");
INSERT INTO polubg_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","I będziecie chcieli złożyć PANU ofiarę spalaną na całopalenie, ofiarę bądź poślubioną, bądź dobrowolną lub też w wasze uroczyste święta, aby złożyć PANU miłą woń z wołów albo z owiec; ");
INSERT INTO polubg_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","To niech składający PANU ofiarę złoży na ofiarę pokarmową dziesiątą część efy mąki pszennej zmieszanej z czwartą częścią hinu oliwy. ");
INSERT INTO polubg_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","A czwartą część hinu wina na ofiarę z płynów przygotujesz przy całopaleniu lub innej ofierze na każde jagnię. ");
INSERT INTO polubg_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Przy baranie zaś złożysz na ofiarę pokarmową dwie dziesiąte efy mąki pszennej zmieszanej z trzecią częścią hinu oliwy. ");
INSERT INTO polubg_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","A na ofiarę z płynów złożysz jedną trzecią hinu wina jako miłą woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Gdy zaś będziesz składał cielca na ofiarę całopalną lub na ofiarę wypełnienia ślubu albo na ofiarę pojednawczą dla PANA; ");
INSERT INTO polubg_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Wtedy wraz z cielcem złożysz na ofiarę pokarmową trzy dziesiąte efy mąki pszennej zmieszanej z połową hinu oliwy. ");
INSERT INTO polubg_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Na ofiarę pokarmową złożysz też połowę hinu wina, na ofiarę spalaną jako miłą woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Tak należy postąpić przy każdym wole, przy każdym baranie, jagnięciu lub koźlęciu. ");
INSERT INTO polubg_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Według liczby, którą składacie, tak uczynicie z każdą ich sztuką według ich liczby. ");
INSERT INTO polubg_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Każdy rodowity mieszkaniec postąpi w ten sposób, gdy będzie składał ofiarę spalaną jako miłą woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","A jeśli obcy gości u was lub mieszka z wami od pokoleń i będzie chciał złożyć ofiarę spalaną jako miłą woń dla PANA, uczyni to tak, jak wy czynicie. ");
INSERT INTO polubg_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Będzie jedna ustawa dla was i dla przybysza, który mieszka wśród was; będzie to ustawa wieczysta przez wszystkie wasze pokolenia. Przybysz będzie przed PANEM tak jak wy. ");
INSERT INTO polubg_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Będzie jedno prawo i jeden sąd dla was i przybysza, który mieszka wśród was. ");
INSERT INTO polubg_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Przemów do synów Izraela i powiedz im: Gdy wejdziecie do ziemi, do której was wprowadzę; ");
INSERT INTO polubg_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","A będziecie jeść chleb tej ziemi, to złożycie PANU ofiarę wzniesienia. ");
INSERT INTO polubg_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Złożycie jako ofiarę wzniesienia placek z pierwocin waszych ciast; złożycie go tak jak ofiarę wzniesienia z klepiska. ");
INSERT INTO polubg_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Będziecie składać PANU ofiarę wzniesienia z pierwocin waszych ciast przez wszystkie wasze pokolenia. ");
INSERT INTO polubg_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","A gdybyście zbłądzili i nie wypełnili wszystkich tych przykazań, które PAN nadał przez Mojżesza; ");
INSERT INTO polubg_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Tego wszystkiego, co PAN wam rozkazał przez Mojżesza, od tego dnia, w którym PAN to nakazał, i potem przez wszystkie wasze pokolenia; ");
INSERT INTO polubg_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Jeśli popełniono ten błąd nieświadomie przez zgromadzenia, to całe zgromadzenie złoży jednego młodego cielca na całopalenie, na miłą woń dla PANA, wraz z jego ofiarą pokarmową i ofiarą z płynów według zwyczaju, oraz jednego kozła ze stada na ofiarę za grzech. ");
INSERT INTO polubg_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","I kapłan dokona przebłagania za całe zgromadzenie synów Izraela, i będzie im przebaczone, gdyż stało się to nieświadomie. A oni przyniosą PANU swoją ofiarę na ofiarę spalaną i swoją ofiarę za grzech przed PANEM za swój błąd. ");
INSERT INTO polubg_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","I będzie przebaczone całemu zgromadzeniu synów Izraela i przybyszowi, który mieszka pośród nich, ponieważ cały lud popełnił to nieświadomie. ");
INSERT INTO polubg_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","A jeśli tylko jedna osoba zgrzeszy nieświadomie, wtedy przyniesie roczną kozę na ofiarę za grzech; ");
INSERT INTO polubg_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","I kapłan dokona przebłagania za człowieka, który zbłądził, grzesząc wobec PANA nieświadomie; dokona za niego przebłagania i będzie mu przebaczone. ");
INSERT INTO polubg_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Będzie jedno prawo dla tego, który grzeszy nieświadomie, zarówno dla rodowitego mieszkańca wśród synów Izraela, jak i dla przybysza, który mieszka pośród nich. ");
INSERT INTO polubg_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Lecz człowiek, który bezczelnie zgrzeszy świadomie, zarówno rodowity mieszkaniec, jak i przybysz, znieważa PANA; człowiek ten zostanie wykluczony spośród swego ludu. ");
INSERT INTO polubg_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Wzgardził bowiem słowem PANA i złamał jego przykazanie; taki człowiek musi zostać wykluczony; na nim ciąży jego nieprawość. ");
INSERT INTO polubg_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","A gdy synowie Izraela byli na pustyni, spotkali człowieka zbierającego drwa w dzień szabatu. ");
INSERT INTO polubg_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","I ci, którzy go spotkali zbierającego drwa, przyprowadzili go do Mojżesza i Aarona, i do całego zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","I osadzili go pod strażą, bo jeszcze im nie oznajmiono, jak należy z takim postąpić. ");
INSERT INTO polubg_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Wtedy PAN powiedział do Mojżesza: Ten człowiek musi ponieść śmierć; niech całe zgromadzenie go ukamienuje poza obozem. ");
INSERT INTO polubg_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Całe zgromadzenie wyprowadziło go poza obóz i ukamienowało, i umarł, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Przemów do synów Izraela i powiedz im, aby robili sobie frędzle na skrajach swoich szat przez wszystkie pokolenia, a do frędzli niech przyprawią sznurek z błękitnej tkaniny. ");
INSERT INTO polubg_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","I będziecie mieć te frędzle, żebyście na nie spoglądali i przypominali sobie wszystkie przykazania PANA, aby je wypełnić, a nie podążali za własnym sercem i własnymi oczami, za którymi idąc, cudzołożylibyście; ");
INSERT INTO polubg_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Abyście pamiętali i wypełniali wszystkie moje przykazania, i byli święci dla waszego Boga. ");
INSERT INTO polubg_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ja jestem PAN, wasz Bóg, który was wyprowadził z ziemi Egiptu, aby być waszym Bogiem. Ja jestem PAN, wasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Wtedy Korach, syn Ishara, syna Kehata, syna Lewiego, oraz Datan i Abiram, synowie Eliaba, i On, syn Peleta, synowie Rubena, wzięli ludzi; ");
INSERT INTO polubg_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","I powstali przeciw Mojżeszowi, a wraz z nimi dwustu pięćdziesięciu mężczyzn spośród synów Izraela, naczelników zgromadzenia powołanych do rady, ludzi poważanych. ");
INSERT INTO polubg_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Zebrali się oni przeciw Mojżeszowi i Aaronowi i powiedzieli do nich: Bierzecie zbyt dużo na siebie! Przecież całe to zgromadzenie, wszyscy oni są święci i wśród nich jest PAN. Dlaczego więc wynosicie się ponad zgromadzenie PANA? ");
INSERT INTO polubg_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Gdy Mojżesz to usłyszał, upadł na twarz; ");
INSERT INTO polubg_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","I powiedział do Koracha i do całej jego gromady: Jutro rano PAN pokaże, kto jest jego, kto jest święty i może zbliżyć się do niego. Kogo bowiem wybrał, temu pozwoli zbliżyć się do siebie. ");
INSERT INTO polubg_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Tak więc uczynicie: Weźcie sobie kadzielnice, ty, Korach i cała twoja gromada. ");
INSERT INTO polubg_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","I włóżcie w nie ogień, i jutro umieśćcie w nich kadzidło przed PANEM; a ten człowiek, którego PAN wybierze, będzie święty. Bierzecie zbyt dużo na siebie, synowie Lewiego. ");
INSERT INTO polubg_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","I powiedział Mojżesz do Koracha: Słuchajcie, proszę, synowie Lewiego; ");
INSERT INTO polubg_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Czy wam to mało, że Bóg Izraela oddzielił was od zgromadzenia Izraela, aby zbliżyć was do siebie, abyście pełnili służbę w przybytku PANA i abyście stali przed zgromadzeniem, i mu służyli? ");
INSERT INTO polubg_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","I ciebie, a wraz z tobą wszystkich twoich braci, synów Lewiego, zbliżył do siebie, a wy jeszcze zabiegacie o kapłaństwo? ");
INSERT INTO polubg_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Dlatego ty i cała twoja gromada zbuntowaliście się przeciw PANU, bo kim jest Aaron, że szemracie przeciw niemu? ");
INSERT INTO polubg_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Wtedy Mojżesz kazał przywołać Datana i Abirama, synów Eliaba, lecz oni odpowiedzieli: Nie przyjdziemy. ");
INSERT INTO polubg_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Nie dość, że nas wyprowadziłeś z ziemi opływającej mlekiem i miodem, aby nas uśmiercić na tej pustyni, to jeszcze chcesz obwołać się naszym władcą? ");
INSERT INTO polubg_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ponadto nie wprowadziłeś nas do ziemi opływającej mlekiem i miodem ani nie dałeś nam w dziedzictwo pól i winnic. Czy chcesz tym mężczyznom wyłupić oczy? Nie przyjdziemy. ");
INSERT INTO polubg_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Wtedy Mojżesz bardzo się rozgniewał i powiedział do PANA: Nie zważaj na ich ofiarę. Nie wziąłem od nich żadnego osła ani też nikogo z nich nie skrzywdziłem. ");
INSERT INTO polubg_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Potem Mojżesz powiedział do Koracha: Ty i cała twoja gromada stawcie się jutro przed PANEM; ty, oni i Aaron: ");
INSERT INTO polubg_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Każdy z was niech weźmie swoją kadzielnicę i nałoży w nią kadzidła, i niech każdy przyniesie przed PANA swoją kadzielnicę, razem dwieście pięćdziesiąt kadzielnic, również ty i Aaron; każdy przyniesie swoją kadzielnicę. ");
INSERT INTO polubg_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Każdy więc wziął swoją kadzielnicę, włożył w nią ogień, nałożył na niego kadzidła i stanęli u wejścia do Namiotu Zgromadzenia wraz z Mojżeszem i Aaronem. ");
INSERT INTO polubg_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","A Korach zebrał przeciwko nim całe zgromadzenie u wejścia do Namiotu Zgromadzenia i wtedy chwała PANA ukazała się całemu ludowi. ");
INSERT INTO polubg_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","I PAN powiedział do Mojżesza i Aarona: ");
INSERT INTO polubg_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Odłączcie się od tego zgromadzenia, abym mógł je w jednej chwili zniszczyć. ");
INSERT INTO polubg_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Lecz oni upadli na twarz i powiedzieli: O Boże, Boże duchów wszelkiego ciała! Czy jeśli zgrzeszy jeden człowiek, będziesz się gniewał na całe zgromadzenie? ");
INSERT INTO polubg_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Przemów do zgromadzenia i powiedz im: Oddalcie się od namiotu Koracha, Datana i Abirama. ");
INSERT INTO polubg_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mojżesz wstał więc i podszedł do Datana i Abirama, a za nim poszli starsi Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","I powiedział do zgromadzenia: Oddalcie się, proszę, od namiotów tych bezbożnych ludzi i nie dotykajcie niczego, co do nich należy, abyście nie zginęli przez wszystkie ich grzechy. ");
INSERT INTO polubg_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","I oddalili się od namiotów Koracha, Datana i Abirama z każdej strony. Datan zaś i Abiram wyszli i stali u wejścia do swoich namiotów razem ze swoimi żonami, synami i małymi dziećmi. ");
INSERT INTO polubg_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Wtedy Mojżesz powiedział: Po tym poznacie, że PAN mnie posłał, abym dokonał wszystkich tych dzieł, i że nic z własnej woli nie czynię. ");
INSERT INTO polubg_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Jeśli ci ludzie umrą taką śmiercią jak wszyscy ludzie albo zostaną ukarani tak jak inni, to nie PAN mnie posłał. ");
INSERT INTO polubg_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ale jeśli PAN uczyni coś nowego i ziemia otworzy swoją paszczę, i pochłonie ich oraz wszystko, co do nich należy, i żywcem zstąpią do piekła, wtedy poznacie, że ci mężczyźni rozdrażnili PANA. ");
INSERT INTO polubg_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Gdy tylko skończył wypowiadać wszystkie te słowa, ziemia rozstąpiła się pod nimi. ");
INSERT INTO polubg_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","A ziemia otworzyła swoją paszczę, i pochłonęła ich oraz ich domy i wszystkich ludzi, którzy byli przy Korachu, i cały ich dobytek. ");
INSERT INTO polubg_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","I zstąpili oni razem ze wszystkim, co mieli, żywcem do piekła, i ziemia ich okryła; tak zginęli spośród zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Wszyscy zaś Izraelici, którzy stali wokół nich, uciekli na ich krzyk, bo mówili: By i nas ziemia nie pochłonęła. ");
INSERT INTO polubg_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Wyszedł też ogień od PANA i pochłonął tych dwustu pięćdziesięciu mężczyzn, którzy ofiarowali kadzidło. ");
INSERT INTO polubg_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Powiedz do Eleazara, syna kapłana Aarona, niech pozbiera kadzielnice z tego pogorzeliska, a ogień niech rozrzuci dalej. Są bowiem poświęcone. ");
INSERT INTO polubg_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","A kadzielnice tych, którzy zgrzeszyli przeciwko własnym duszom, rozbijcie na blachy na pokrycie ołtarza. Ofiarowali je bowiem przed PANEM, są więc poświęcone. Dlatego będą znakiem dla synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Pozbierał więc kapłan Eleazar miedziane kadzielnice, w których ofiarowali ci, którzy spłonęli, i rozbito je na blachy na pokrycie ołtarza; ");
INSERT INTO polubg_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Na pamiątkę dla synów Izraela, aby żaden obcy, który nie jest z potomstwa Aarona, nie zbliżał się do składania kadzidła przed PANEM i żeby go nie spotkało to, co spotkało Koracha i jego gromady, jak PAN mu powiedział przez Mojżesza. ");
INSERT INTO polubg_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","A nazajutrz całe zgromadzenie synów Izraela szemrało przeciwko Mojżeszowi i Aaronowi: Wy spowodowaliście śmierć ludu PANA. ");
INSERT INTO polubg_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","I gdy zgromadzenie zbierało się przeciw Mojżeszowi i Aaronowi, spojrzeli w stronę Namiotu Zgromadzenia, a oto okrył go obłok i ukazała się chwała PANA. ");
INSERT INTO polubg_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Wtedy Mojżesz z Aaronem przyszli przed Namiot Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Wyjdźcie spośród tego zgromadzenia, a zniszczę je w mgnieniu oka; i upadli na twarz. ");
INSERT INTO polubg_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Potem Mojżesz powiedział do Aarona: Weź kadzielnicę, włóż w nią ogień z ołtarza, nałóż też kadzidła i pójdź szybko do zgromadzenia, i zrób przebłaganie za nich, bo już wyszedł gniew od PANA i już zaczęła się plaga. ");
INSERT INTO polubg_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aaron wziął więc kadzielnicę, jak mu rozkazał Mojżesz, i pobiegł w środek zgromadzenia, a oto już zaczęła się plaga wśród ludzi; nałożył kadzidła i dokonał przebłagania za lud. ");
INSERT INTO polubg_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","I Aaron stał między umarłymi i żywymi i plaga została powstrzymana. ");
INSERT INTO polubg_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Tych, co umarli od tej plagi, było czternaście tysięcy siedemset, oprócz tych, którzy umarli w związku ze sprawą Koracha. ");
INSERT INTO polubg_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Potem Aaron wrócił do Mojżesza przed wejście do Namiotu Zgromadzenia, a plaga została zatrzymana. ");
INSERT INTO polubg_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Mów do synów Izraela i weź od każdego z nich po lasce według domów ich ojców, od wszystkich ich naczelników według domów ich ojców dwanaście lasek, a imię każdego napisz na jego lasce. ");
INSERT INTO polubg_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","A imię Aarona napiszesz na lasce Lewiego, gdyż jedna laska będzie dla każdego naczelnika z domu ich ojców. ");
INSERT INTO polubg_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","I położysz je w Namiocie Zgromadzenia przed Świadectwem, gdzie się z wami spotykam. ");
INSERT INTO polubg_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","I stanie się tak, że laska tego, kogo wybiorę, zakwitnie; i uśmierzę przed sobą szemrania synów Izraela, jakie kierują przeciwko wam. ");
INSERT INTO polubg_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Gdy Mojżesz przekazał to synom Izraela, wszyscy ich naczelnicy oddali mu swoje laski, po jednej lasce od każdego naczelnika z domu swego ojca, razem dwanaście lasek. Wśród ich lasek była też laska Aarona. ");
INSERT INTO polubg_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Potem Mojżesz złożył te laski przed PANEM w Namiocie Świadectwa. ");
INSERT INTO polubg_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Nazajutrz, gdy Mojżesz przyszedł do Namiotu Świadectwa, oto laska Aarona, z domu Lewiego, zakwitła, wypuściła pączki, wydała kwiat i dojrzałe migdały. ");
INSERT INTO polubg_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Wtedy Mojżesz wyniósł wszystkie laski sprzed PANA do wszystkich synów Izraela; a gdy je ujrzeli, każdy z nich wziął swoją laskę. ");
INSERT INTO polubg_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","I PAN powiedział do Mojżesza: Połóż laskę Aarona z powrotem przed Świadectwem, aby była zachowana na znak dla buntowników, a położysz kres ich szemraniu przeciwko mnie, aby nie pomarli. ");
INSERT INTO polubg_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","I Mojżesz tak uczynił; jak PAN mu rozkazał, tak uczynił. ");
INSERT INTO polubg_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","I synowie Izraela powiedzieli do Mojżesza: Oto umieramy, giniemy, wszyscy giniemy; ");
INSERT INTO polubg_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Każdy, kto zbliża się do przybytku PANA, umrze. Czy mamy doszczętnie zginąć? ");
INSERT INTO polubg_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Potem PAN powiedział do Aarona: Ty, twoi synowie i dom twego ojca z tobą, odpowiecie za nieprawość świątyni. Ty i twoi synowie z tobą również odpowiecie za nieprawość waszego kapłaństwa. ");
INSERT INTO polubg_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","A twoim braciom z pokolenia Lewiego, z rodu twego ojca, pozwól do siebie przychodzić, aby dołączyli do ciebie i usługiwali tobie; ty zaś i twoi synowie z tobą będziecie pełnić służbę przed Namiotem Świadectwa. ");
INSERT INTO polubg_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Oni będą przestrzegać twego nakazu i pełnić straż nad całym namiotem. Nie mogą jednak zbliżać się do sprzętów świątyni i do ołtarza, żeby nie pomarli ani oni, ani wy. ");
INSERT INTO polubg_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Przyłączą się do ciebie i będą pełnić straż przy Namiocie Zgromadzenia, przy każdej służbie namiotu. Lecz żaden obcy niech się do was nie zbliża. ");
INSERT INTO polubg_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Wy będziecie pełnić straż w świątyni i straż przy ołtarzu, aby już nie spadł gniew na synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Oto wziąłem waszych braci Lewitów spośród synów Izraela. Oni są wam oddani jako dar dla PANA, aby pełnili służbę w Namiocie Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ty zaś i twoi synowie z tobą będziecie strzec waszego kapłaństwa przy każdej służbie ołtarza i poza zasłoną, i będziecie służyć. Dałem wam urząd waszego kapłaństwa jako dar; obcy, który się zbliży, poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","PAN mówił dalej do Aarona: Oto dałem tobie pod straż moje ofiary wzniesione ze wszystkich poświęconych rzeczy synów Izraela. Z powodu namaszczenia dałem je tobie i twoim synom prawem wieczystym. ");
INSERT INTO polubg_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","To będzie należeć do ciebie z rzeczy najświętszych, które nie zostaną spalone: każda ich ofiara, każda ich ofiara pokarmowa, każda ich ofiara za grzech i każda ich ofiara za przewinienie, które będą mi składać, będą to rzeczy najświętsze dla ciebie i twoich synów. ");
INSERT INTO polubg_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","W miejscu najświętszym będziesz to jeść; wszyscy mężczyźni będą z tego jedli. Będzie to dla ciebie rzeczą świętą. ");
INSERT INTO polubg_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","To też będzie dla ciebie: ofiara wzniesienia ich darów ze wszystkimi ofiarami kołysania synów Izraela. Daję je tobie, twoim synom i twoim córkom z tobą prawem wieczystym. Każdy czysty w twoim domu będzie je spożywać. ");
INSERT INTO polubg_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Wszystko, co najlepsze z oliwy, i wszystko, co najlepsze z wina, oraz zboże, ich pierwociny, które ofiarują PANU, dałem tobie. ");
INSERT INTO polubg_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Pierwociny ze wszystkich rzeczy znajdujących się w ich ziemi, które przyniosą PANU, będą twoje. Każdy czysty w twoim domu będzie je spożywać. ");
INSERT INTO polubg_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Wszystko, co jest poświęcone w Izraelu, będzie twoje. ");
INSERT INTO polubg_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Wszystko, co otwiera łono wszelkiego ciała, które przynoszą PANU, zarówno z ludzi, jak i z bydła, będzie twoje; lecz pierworodnego z ludzi wykupisz, także pierworodne z nieczystych zwierząt wykupisz. ");
INSERT INTO polubg_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","A wykup tego, który ma jeden miesiąc, dasz według twego oszacowania pięć syklów srebra według sykla świątynnego, który wynosi dwadzieścia ger. ");
INSERT INTO polubg_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Ale pierworodnego z krowy, pierworodnego z owcy lub pierworodnego z kozy nie wykupisz; są one święte. Ich krew wylejesz na ołtarz, a ich tłuszcz zapalisz jako ofiarę spaloną, jako miłą woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ale ich mięso będzie twoje, podobnie jak mostek wzniesienia i prawa łopatka są twoje. ");
INSERT INTO polubg_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Wszystkie ofiary wzniesienia z poświęconych rzeczy, które będą przynosić PANU synowie Izraela, daję tobie, twoim synom i twoim córkom z tobą prawem wieczystym. Jest to wieczyste przymierze soli przed PANEM, dla ciebie i twojego potomstwa wraz z tobą. ");
INSERT INTO polubg_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Potem PAN powiedział do Aarona: Nie będziesz miał dziedzictwa w ich ziemi i nie będziesz miał żadnego działu wśród nich. Ja jestem twoim działem i twoim dziedzictwem pośród synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Oto zaś synom Lewiego dałem jako dziedzictwo wszystkie dziesięciny w Izraelu za ich służbę, którą pełnią w Namiocie Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","A niech synowie Izraela nie zbliżają się już do Namiotu Zgromadzenia, aby nie obciążyli się grzechem i nie umarli; ");
INSERT INTO polubg_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ale sami Lewici będą pełnić służbę w Namiocie Zgromadzenia i sami poniosą karę za swoją nieprawość. Będzie to ustawa wieczysta przez wszystkie wasze pokolenia, że Lewici nie będą mieli dziedzictwa pośród synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Dałem bowiem Lewitom w dziedzictwo dziesięciny synów Izraela, które przynoszą PANU jako ofiarę wzniesienia. Dlatego powiedziałem o nich: Nie będą mieli dziedzictwa pośród synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Przemów do Lewitów i powiedz im: Gdy przyjmujecie od synów Izraela dziesięciny, które dałem wam od nich jako wasze dziedzictwo, wtedy złożycie PANU jako ofiarę wzniesienia dziesiątą część z dziesięciny. ");
INSERT INTO polubg_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","A wasza ofiara wzniesienia będzie wam poczytana za zboże z klepiska i za obfitość z tłoczni winnej. ");
INSERT INTO polubg_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","W ten sposób też i wy macie składać PANU ofiarę wzniesienia ze wszystkich waszych dziesięcin, które przyjmujecie od synów Izraela; kapłanowi Aaronowi oddacie z nich ofiarę wzniesienia należną PANU. ");
INSERT INTO polubg_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ze wszystkich waszych darów będziecie składać PANU wszelką ofiarę wzniesienia; ze wszystkiego, co najlepsze, ofiarujcie jego poświęconą część. ");
INSERT INTO polubg_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Powiesz im też: Gdy będziecie oddawać z tego, co najlepsze, wtedy będzie to poczytane Lewitom jako plon z klepiska i jako plon z tłoczni winnej. ");
INSERT INTO polubg_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","I będziecie to jeść na każdym miejscu, wy i wasi domownicy, ponieważ to jest wasza zapłata za waszą służbę w Namiocie Zgromadzenia; ");
INSERT INTO polubg_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","I nie obciążycie się grzechem za to, gdy będziecie składać, co najlepsze z tego, i nie splugawicie rzeczy poświęconych synów Izraela, i nie umrzecie. ");
INSERT INTO polubg_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","I PAN powiedział do Mojżesza i Aarona: ");
INSERT INTO polubg_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","To jest ustawa prawa, którą nadał PAN: Powiedz synom Izraela, aby przyprowadzili do ciebie czerwoną jałówkę, zdrową i bez skazy, na której jeszcze nie było jarzma. ");
INSERT INTO polubg_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Oddacie ją kapłanowi Eleazarowi, który ją wyprowadzi poza obóz, i zostanie przed nim zabita. ");
INSERT INTO polubg_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","A kapłan Eleazar weźmie nieco z jej krwi na swój palec i pokropi nią siedem razy na wprost przed Namiotem Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Potem każe spalić jałówkę na swoich oczach: spali jej skórę, mięso, krew wraz z jej odchodami. ");
INSERT INTO polubg_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","I kapłan weźmie drewno cedrowe, hizop i karmazyn i wrzuci to do ognia, w którym płonie jałówka. ");
INSERT INTO polubg_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Wtedy kapłan wypierze swoje szaty i umyje swoje ciało wodą; potem wejdzie do obozu i będzie nieczysty do wieczora. ");
INSERT INTO polubg_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Również ten, który ją będzie palić, wypierze swoje szaty w wodzie i umyje swoje ciało wodą, i będzie nieczysty do wieczora. ");
INSERT INTO polubg_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Człowiek czysty zbierze popiół tej jałówki i złoży go poza obozem na miejscu czystym; będzie on przechowywany dla zgromadzenia synów Izraela do wody oczyszczenia; jest to ofiara za grzech. ");
INSERT INTO polubg_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ten, który zbierał popiół jałówki, wypierze swoje szaty i będzie nieczysty do wieczora. Będzie to ustawa wieczysta dla synów Izraela i dla przybysza mieszkającego wśród was. ");
INSERT INTO polubg_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Kto dotknie jakiegokolwiek ludzkiego trupa, będzie nieczysty przez siedem dni. ");
INSERT INTO polubg_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Taki oczyści się tą wodą w trzecim i siódmym dniu i będzie czysty. Jeśli jednak nie oczyści się w trzecim i siódmym dniu, będzie nieczysty. ");
INSERT INTO polubg_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Kto dotknie zwłok człowieka zmarłego, a nie oczyści się, ten zanieczyści przybytek PANA; ta dusza będzie wykluczona z Izraela. Człowiek ten nie został bowiem pokropiony wodą oczyszczenia; będzie nieczysty, a jego nieczystość pozostanie na nim. ");
INSERT INTO polubg_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Taka jest ustawa, gdy człowiek umrze w namiocie: ktokolwiek wejdzie do tego namiotu i cokolwiek znajduje się w tym namiocie będzie nieczyste przez siedem dni. ");
INSERT INTO polubg_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Każde naczynie odkryte, które nie ma przymocowanej pokrywy, będzie nieczyste. ");
INSERT INTO polubg_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Kto dotknie na polu zabitego mieczem lub umarłego, lub kości ludzkich, lub grobu będzie nieczysty przez siedem dni. ");
INSERT INTO polubg_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Wezmą dla tego nieczystego nieco popiołu jałówki spalonej za grzech i na to wleją do naczynia źródlanej wody. ");
INSERT INTO polubg_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Człowiek czysty weźmie hizop, zmoczy go w tej wodzie i pokropi namiot oraz wszystkie naczynia i wszystkich ludzi, którzy tam byli, także tego, który dotknął kości lub zabitego, lub zmarłego, lub grobu. ");
INSERT INTO polubg_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Człowiek czysty pokropi nieczystego w trzecim i siódmym dniu, a gdy go oczyści w siódmym dniu, wypierze on swoje szaty i umyje się wodą, i wieczorem będzie czysty. ");
INSERT INTO polubg_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","A człowiek, który stał się nieczysty, a nie oczyścił się, zostanie wykluczony spośród zgromadzenia, gdyż ta dusza zbezcześciła świątynię PANA. Człowiek ten nie został pokropiony wodą oczyszczenia i jest nieczysty. ");
INSERT INTO polubg_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Będzie to dla nich ustawą wieczystą: kto skrapia wodą oczyszczenia, wypierze swoje szaty, a kto dotknie tej wody oczyszczenia, będzie nieczysty do wieczora. ");
INSERT INTO polubg_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Czegokolwiek dotknie nieczysty, będzie nieczyste; również człowiek, który tego dotknie, będzie nieczysty do wieczora. ");
INSERT INTO polubg_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","I przyszło całe zgromadzenie synów Izraela na pustynię Syn w pierwszym miesiącu. I lud zamieszkał w Kadesz. Tam umarła Miriam i tam została pogrzebana. ");
INSERT INTO polubg_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","A gdy zabrakło wody dla ludu, zebrali się przeciw Mojżeszowi i Aaronowi. ");
INSERT INTO polubg_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Lud spierał się z Mojżeszem, mówiąc: Obyśmy umarli, gdy nasi bracia umarli przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Dlaczego przyprowadziliście to zgromadzenie PANA na tę pustynię, abyśmy tu pomarli wraz z naszym bydłem? ");
INSERT INTO polubg_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Po co wyprowadziliście nas z Egiptu, aby nas wprowadzić na to złe miejsce; na miejsce, w którym nie ma ani zboża, ani fig, ani winogron, ani jabłek granatu, nie ma nawet wody do picia? ");
INSERT INTO polubg_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Wtedy Mojżesz i Aaron przeszli sprzed ludu przed wejście do Namiotu Zgromadzenia i upadli na twarze. A chwała PANA ukazała się im. ");
INSERT INTO polubg_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Weź laskę, zgromadźcie cały lud, ty i twój brat Aaron, i przemówcie na ich oczach do tej skały, a ona wyda z siebie wodę; wydobędziesz dla nich wodę ze skały i dasz pić całemu zgromadzeniu oraz ich zwierzętom. ");
INSERT INTO polubg_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Wziął więc Mojżesz laskę sprzed oblicza PANA, tak jak mu rozkazał. ");
INSERT INTO polubg_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","I Mojżesz z Aaronem zgromadzili cały lud przed skałą, i Mojżesz mówił do nich: Słuchajcie teraz, buntownicy! Czy z tej skały mamy wyprowadzić dla was wodę? ");
INSERT INTO polubg_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Następnie Mojżesz podniósł rękę i uderzył swoją laską dwa razy w skałę. Wtedy wypłynęła obficie woda i napiło się zgromadzenie oraz jego bydło. ");
INSERT INTO polubg_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","I PAN powiedział do Mojżesza i Aarona: Ponieważ nie uwierzyliście mi, by mnie uświęcić na oczach synów Izraela, dlatego nie wprowadzicie tego zgromadzenia do ziemi, którą im daję. ");
INSERT INTO polubg_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","To są wody Meriba, gdzie synowie Izraela spierali się z PANEM i został uświęcony w nich. ");
INSERT INTO polubg_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Potem Mojżesz wysłał z Kadesz posłańców do króla Edomu, mówiąc: Tak mówi twój brat Izrael: Ty znasz całą udrękę, która nas spotkała; ");
INSERT INTO polubg_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Jak nasi ojcowie zstąpili do Egiptu i mieszkaliśmy w Egipcie wiele lat; i Egipcjanie dręczyli nas i naszych ojców; ");
INSERT INTO polubg_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","I wołaliśmy do PANA, a wysłuchał naszego głosu i posłał Anioła, i wyprowadził nas z Egiptu. Teraz jesteśmy w Kadesz, w mieście przy twojej granicy. ");
INSERT INTO polubg_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Pozwól nam, proszę, przejść przez twoją ziemię; nie pójdziemy przez pola ani przez winnice i nie będziemy pić wód ze studni. Pójdziemy drogą królewską, nie zboczymy ani w prawo, ani w lewo, dopóki nie przejdziemy twoich granic. ");
INSERT INTO polubg_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edom odpowiedział mu: Nie przejdziesz przez moją ziemię, bo inaczej wyjdę przeciwko tobie z mieczem. ");
INSERT INTO polubg_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","I synowie Izraela powiedzieli mu: Pójdziemy główną drogą, a jeśli będziemy pili twoją wodę, my i nasze zwierzęta, zapłacimy za to. Niczego innego nie żądamy; tylko przejdziemy pieszo. ");
INSERT INTO polubg_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","A on odpowiedział: Nie przejdziesz. I Edom wyruszył naprzeciwko nim z licznym ludem i mocną ręką. ");
INSERT INTO polubg_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Tak Edom nie pozwolił Izraelowi przejść przez swoje granice. Izrael więc odstąpił od niego. ");
INSERT INTO polubg_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","I synowie Izraela, całe zgromadzenie, wyruszyli z Kadesz i przyszli do góry Hor. ");
INSERT INTO polubg_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","I PAN powiedział do Mojżesza i Aarona na górze Hor, na granicy ziemi Edomu: ");
INSERT INTO polubg_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aaron zostanie przyłączony do swego ludu; nie wejdzie bowiem do ziemi, którą dałem synom Izraela, ponieważ sprzeciwiliście się mojemu słowu przy wodach Meriba. ");
INSERT INTO polubg_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Weź Aarona i jego syna Eleazara i przyprowadź ich na górę Hor; ");
INSERT INTO polubg_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","I zdejmij z Aarona jego szaty, a ubierz w nie jego syna Eleazara. Aaron zaś zostanie przyłączony do swego ludu i tam umrze. ");
INSERT INTO polubg_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","I Mojżesz uczynił tak, jak PAN rozkazał; i wstąpili na górę Hor na oczach całego zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mojżesz zdjął z Aarona jego szaty i ubrał w nie jego syna Eleazara. Aaron umarł tam na wierzchu góry, a Mojżesz i Eleazar zeszli z góry. ");
INSERT INTO polubg_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Gdy całe zgromadzenie zobaczyło, że Aaron nie żyje, opłakiwał Aarona cały dom Izraela przez trzydzieści dni. ");
INSERT INTO polubg_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","A gdy król Aradu, Kananejczyk, który mieszkał na południu, usłyszał, że Izrael nadciąga drogą, którą przeszli szpiedzy, stoczył walkę z Izraelem i wziął jeńców. ");
INSERT INTO polubg_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Wtedy Izrael złożył PANU ślub, mówiąc: Jeśli wydasz ten lud w moje ręce, całkowicie zniszczę ich miasta. ");
INSERT INTO polubg_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","I PAN wysłuchał głosu Izraela, i wydał mu Kananejczyków. Całkowicie zniszczyli ich oraz ich miasta, a nadano temu miejscu nazwę Chorma. ");
INSERT INTO polubg_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Potem wyruszyli od góry Hor w kierunku Morza Czerwonego, aby obejść ziemię Edom. I lud bardzo się zniechęcił w drodze. ");
INSERT INTO polubg_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Lud zaczął więc mówić przeciw Bogu i Mojżeszowi: Dlaczego wyprowadziliście nas z Egiptu, abyśmy pomarli na tej pustyni? Bo nie ma chleba ani wody, a nasza dusza obrzydziła sobie ten cienki chleb. ");
INSERT INTO polubg_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Zesłał więc PAN na lud węże jadowite, które go kąsały; i pomarło wiele osób z Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","I lud przyszedł do Mojżesza, i powiedział: Zgrzeszyliśmy przez to, że mówiliśmy przeciw PANU i przeciw tobie. Módl się do PANA, aby oddalił od nas te węże. I Mojżesz modlił się za lud. ");
INSERT INTO polubg_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Wtedy PAN powiedział do Mojżesza: Wykonaj jadowitego węża i umieść go na drzewcu. I stanie się tak, że każdy ukąszony, kiedy spojrzy na niego, będzie żył. ");
INSERT INTO polubg_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Mojżesz wykonał więc węża miedzianego i umieścił go na drzewcu; gdy wąż kogoś ukąsił, a ten spojrzał na węża miedzianego, pozostawał przy życiu. ");
INSERT INTO polubg_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","I wyruszyli synowie Izraela, i rozbili obóz w Obot. ");
INSERT INTO polubg_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","A z Obot wyruszyli i rozbili obóz w Ijje-Haabarim na pustyni, która leży naprzeciw Moabu ku wschodowi słońca. ");
INSERT INTO polubg_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Stamtąd wyruszyli i rozbili obóz nad potokiem Zered. ");
INSERT INTO polubg_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Stamtąd wyruszyli i rozbili obóz po drugiej stronie rzeki Arnon, która wypływa na pustyni od granicy Amorytów; Arnon stanowi bowiem granicę Moabu między Moabitami a Amorytami. ");
INSERT INTO polubg_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Dlatego jest powiedziane w księdze wojen PANA: Jak uczynił w Morzu Czerwonym i w potokach Arnonu; ");
INSERT INTO polubg_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","U ujścia tych potoków, które ciągnie się ku osadzie Ar i przylega do granicy Moabu. ");
INSERT INTO polubg_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Stamtąd udali się do Beer; to jest ta studnia, o której PAN powiedział do Mojżesza: Zgromadź lud, a dam mu wody. ");
INSERT INTO polubg_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Wtedy Izrael śpiewał tę pieśń: Wzbierz studnio! Śpiewajcie o niej. ");
INSERT INTO polubg_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","To studnia, którą wykopali naczelnicy; wykopali ją dostojnicy ludu wraz z prawodawcą swoimi laskami. A z tej pustyni poszli do Mattany; ");
INSERT INTO polubg_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","A z Mattany do Nahalielu, a z Nahalielu do Bamot; ");
INSERT INTO polubg_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","A z Bamot do kotliny, która jest w ziemi Moabu, i do szczytu Pizga wznoszącego się nad Jeszimonem. ");
INSERT INTO polubg_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","I Izrael wysłał posłańców do Sichona, króla Amorytów, mówiąc: ");
INSERT INTO polubg_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Pozwól nam przejść przez twoją ziemię; nie pójdziemy ani przez pola, ani przez winnice; nie będziemy pić wód ze studni. Pójdziemy drogą królewską, dopóki nie przejdziemy twoich granic. ");
INSERT INTO polubg_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sichon jednak nie pozwolił Izraelowi przejść przez swoją granicę; Sichon zebrał cały swój lud i wyszedł przeciw Izraelowi na pustynię, a gdy przyszedł do Jahazy, stoczył bitwę z Izraelem. ");
INSERT INTO polubg_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","I Izrael pobił go ostrzem miecza, i wziął w posiadanie jego ziemię od Arnonu do Jabboku, aż do ziemi synów Ammona, gdyż granica Ammonitów była silna. ");
INSERT INTO polubg_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Wtedy Izrael zdobył wszystkie te miasta i zamieszkał we wszystkich miastach Amorytów, w Cheszbonie i we wszystkich przylegających do niego wsiach. ");
INSERT INTO polubg_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Cheszbon był miastem Sichona, króla Amorytów, który walczył z królem Moabu i zabrał mu z rąk całą jego ziemię aż po Arnon. ");
INSERT INTO polubg_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Dlatego mówią w przypowieści: Wejdźcie do Cheszbonu i niech się odbuduje, i umocni miasto Sichona. ");
INSERT INTO polubg_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Ponieważ ogień wyszedł z Cheszbonu, płomień z miasta Sichona; i pochłonął Ar moabskie oraz wzgórza Arnonu. ");
INSERT INTO polubg_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Biada tobie, Moabie! Zginąłeś, ludu Kemosza! Wydał swoich synów na tułaczkę i swoje córki w niewolę Sichonowi, królowi Amorytów. ");
INSERT INTO polubg_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Strzelaliśmy do nich, zginął Cheszbon aż po Dibon; a zburzyliśmy je aż do Nofach, które idzie aż do Medeby. ");
INSERT INTO polubg_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Tak to Izrael zamieszkał w ziemi Amorytów. ");
INSERT INTO polubg_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Wtedy Mojżesz wysłał wywiadowców do Jazer na wyszpiegowanie, a oni zdobyli jego wsie i wypędzili Amorytów, którzy tam byli. ");
INSERT INTO polubg_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Potem zawrócili i poszli w kierunku Baszanu; tam Og, król Baszanu, wyszedł przeciwko nim, on i cały jego lud, do walki w Edre. ");
INSERT INTO polubg_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Wtedy PAN powiedział do Mojżesza: Nie bój się go, gdyż wydałem go w twoje ręce wraz z całym jego ludem i ziemią i uczynisz z nim tak, jak uczyniłeś z Sichonem, królem Amorytów, który mieszkał w Cheszbonie. ");
INSERT INTO polubg_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","I pobili go i jego synów oraz cały jego lud, tak że nikogo z niego nie pozostawili przy życiu, i wzięli w posiadanie jego ziemię. ");
INSERT INTO polubg_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Potem synowie Izraela wyruszyli i rozbili obóz na równinach Moabu, z tej strony Jordanu naprzeciw Jerycha. ");
INSERT INTO polubg_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","A Balak, syn Sippora, widział wszystko, co Izrael uczynił Amorytom. ");
INSERT INTO polubg_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Wtedy Moab bardzo się zląkł tego ludu, bo był liczny; i zatrwożył się Moab z powodu synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Powiedział więc Moab do starszych Midianu: Teraz to mnóstwo pożre wszystko wokół nas, jak wół pożera trawę na polu. A w tym czasie królem Moabu był Balak, syn Sippora. ");
INSERT INTO polubg_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","I wysłał posłańców do Balaama, syna Beora, do Petor, które leży nad rzeką ziemi synów jego ludu, aby go wezwać tymi słowy: Oto z Egiptu wyszedł lud, który okrył powierzchnię ziemi i stanął naprzeciwko mnie. ");
INSERT INTO polubg_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Dlatego teraz przyjdź, proszę, i przeklnij mi ten lud, bo jest silniejszy ode mnie. Może zdołam go pobić i wypędzić z ziemi, bo wiem, że komu błogosławisz, będzie błogosławiony, a kogo przeklinasz, będzie przeklęty. ");
INSERT INTO polubg_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Wtedy starsi Moabu i starsi Midianu wybrali się w drogę, mając w swych rękach zapłatę za wróżbę. Przyszli do Balaama i przekazali mu słowa Balaka. ");
INSERT INTO polubg_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","On zaś powiedział do nich: Pozostańcie tu na noc, a dam wam odpowiedź, jaką mi oznajmi PAN. I zostali książęta Moabu u Balaama. ");
INSERT INTO polubg_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","I przyszedł Bóg do Balaama, i powiedział: Cóż to za ludzie są u ciebie? ");
INSERT INTO polubg_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam odpowiedział Bogu: Balak, syn Sippora, król Moabu, wysłał ich do mnie, mówiąc: ");
INSERT INTO polubg_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Oto z Egiptu wyszedł lud, który okrył powierzchnię ziemi. Przyjdź więc teraz, przeklnij mi go; może zdołam go pokonać i wypędzić. ");
INSERT INTO polubg_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Bóg powiedział do Balaama: Nie idź z nimi i nie przeklnij tego ludu, bo jest on błogosławiony. ");
INSERT INTO polubg_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Gdy Balaam wstał rano, powiedział do książąt Balaka: Wracajcie do waszej ziemi, bo PAN nie pozwala mi iść z wami. ");
INSERT INTO polubg_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Wstali więc książęta Moabu, przyszli do Balaka i powiedzieli: Balaam nie chciał iść z nami. ");
INSERT INTO polubg_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Wtedy Balak ponownie wysłał książąt – liczniejszych i dostojniejszych od pierwszych. ");
INSERT INTO polubg_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Przybyli oni do Balaama i powiedzieli mu: Tak mówi Balak, syn Sippora: Nie zwlekaj z przyjściem do mnie; ");
INSERT INTO polubg_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Ja bowiem wielce cię uczczę i uczynię wszystko, co mi powiesz, tylko przyjdź, proszę, i przeklnij mi ten lud. ");
INSERT INTO polubg_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam odpowiedział sługom Balaka: Choćby Balak dał mi swój dom pełen srebra i złota, nie mógłbym przekroczyć słowa PANA, mego Boga, i uczynić przeciwko niemu czegoś małego czy wielkiego. ");
INSERT INTO polubg_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Lecz zostańcie tu i wy, proszę, na noc, a dowiem się, co PAN jeszcze będzie do mnie mówił. ");
INSERT INTO polubg_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","I przyszedł Bóg do Balaama w nocy, i powiedział do niego: Jeśli ci mężczyźni przyjdą, aby cię wezwać, wstań i idź z nimi; uczynisz jednak, co ci rozkażę. ");
INSERT INTO polubg_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Wstał więc Balaam rano, osiodłał swoją oślicę i pojechał z książętami Moabu. ");
INSERT INTO polubg_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","I zapłonął gniew Boga, że on poszedł; i stanął Anioł PANA na drodze jako przeciwnik. On zaś jechał na swojej oślicy i z nim dwaj jego słudzy. ");
INSERT INTO polubg_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","A gdy oślica zobaczyła Anioła PANA stojącego na drodze z obnażonym mieczem w ręku, zboczyła z drogi i poszła w pole. Balaam zaś bił oślicę, aby ją zawrócić na drogę. ");
INSERT INTO polubg_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Wtedy Anioł PANA stanął na ścieżce między winnicami, a płot był z jednej i z drugiej strony. ");
INSERT INTO polubg_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","A gdy oślica zobaczyła Anioła PANA, przyparła do muru i przygniotła do niego nogę Balaama; a on znowu ją bił. ");
INSERT INTO polubg_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Potem Anioł PANA poszedł dalej i stanął w ciasnym miejscu, gdzie nie można go było wyminąć ani z prawej, ani z lewej strony; ");
INSERT INTO polubg_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","A gdy oślica zobaczyła Anioła PANA, padła pod Balaamem. Wtedy Balaam bardzo się rozgniewał i bił oślicę kijem. ");
INSERT INTO polubg_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Wtedy PAN otworzył usta tej oślicy, a ona powiedziała do Balaama: Cóż ci uczyniłam, że już trzy razy mnie zbiłeś? ");
INSERT INTO polubg_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam odpowiedział oślicy: Ponieważ drwisz ze mnie. Gdybym miał miecz w ręku, teraz bym cię zabił. ");
INSERT INTO polubg_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Oślica powiedziała do Balaama: Czy nie jestem twoją oślicą, na której jeździsz, odkąd mnie dostałeś aż do dziś? Czy miałam zwyczaj tak tobie czynić? A on odpowiedział: Nie. ");
INSERT INTO polubg_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Wówczas PAN otworzył oczy Balaama i zobaczył Anioła PANA stojącego na drodze z obnażonym mieczem w ręku; i pochylił się, i upadł na twarz. ");
INSERT INTO polubg_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","A Anioł PANA powiedział do niego: Dlaczego zbiłeś swoją oślicę trzy razy? Oto wyszedłem, by się tobie sprzeciwić, bo twoja droga jest przewrotna przede mną; ");
INSERT INTO polubg_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","A oślica widziała mnie i ustępowała przede mną trzy razy; gdyby nie ustąpiła przede mną, już bym cię teraz zabił, a ją pozostawił przy życiu. ");
INSERT INTO polubg_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam powiedział więc do Anioła PANA: Zgrzeszyłem, bo nie wiedziałem, że stanąłeś naprzeciwko mnie na drodze; dlatego teraz, jeśli to ci się nie podoba, zawrócę. ");
INSERT INTO polubg_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Lecz Anioł PANA powiedział do Balaama: Jedź z tymi ludźmi, ale będziesz mówił tylko to, co tobie powiem. I poszedł Balaam z książętami Balaka. ");
INSERT INTO polubg_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","A gdy Balak usłyszał, że Balaam nadchodzi, wyszedł mu naprzeciw, do pewnego miasta Moabu, które leżało na granicy Arnonu, na końcu granicy. ");
INSERT INTO polubg_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","I Balak powiedział do Balaama: Czyż nie posłałem do ciebie pilnie, aby cię wezwać? Dlaczego nie przyszedłeś do mnie? Czyż nie potrafię cię uczcić? ");
INSERT INTO polubg_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam odpowiedział Balakowi: Oto przybyłem do ciebie. Czy mogę cokolwiek powiedzieć? Będę mówił słowo, które Bóg włoży w moje usta. ");
INSERT INTO polubg_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Poszedł więc Balaam z Balakiem i przyszli do Kiriat-Chusot. ");
INSERT INTO polubg_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak złożył w ofierze woły i owce i posłał do Balaama oraz do książąt, którzy z nim byli. ");
INSERT INTO polubg_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","A nazajutrz Balak zabrał Balaama i zaprowadził go na wyżyny Baala, skąd mógł widzieć kraniec obozu ludu. ");
INSERT INTO polubg_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","I Balaam powiedział do Balaka: Zbuduj mi tu siedem ołtarzy i przygotuj mi tu siedem cielców i siedem baranów. ");
INSERT INTO polubg_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Uczynił więc Balak tak, jak powiedział Balaam; potem Balak i Balaam ofiarowali po jednym cielcu i jednym baranie na każdym ołtarzu. ");
INSERT INTO polubg_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Wtedy Balaam powiedział do Balaka: Pozostań przy swoim całopaleniu, a ja pójdę; może PAN spotka się ze mną, a cokolwiek mi objawi, powiem ci. I poszedł na wzgórze. ");
INSERT INTO polubg_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","I Bóg spotkał się z Balaamem; i Balaam powiedział do niego: Postawiłem siedem ołtarzy i ofiarowałem po jednym cielcu i jednym baranie na każdym ołtarzu. ");
INSERT INTO polubg_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Wówczas PAN włożył słowa w usta Balaama i powiedział: Wróć do Balaka i tak mu powiedz. ");
INSERT INTO polubg_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","I wrócił do niego, a oto stał przy swoim całopaleniu, on i wszyscy książęta Moabu. ");
INSERT INTO polubg_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","I rozpoczął swą przypowieść, mówiąc: Balak, król Moabu, sprowadził mnie z Aramu, z gór wschodnich tymi słowy: Przyjdź, przeklnij mi Jakuba, przyjdź, złorzecz Izraelowi. ");
INSERT INTO polubg_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Jakże mam przeklinać tego, kogo Bóg nie przeklął? I jak mam złorzeczyć temu, komu PAN nie złorzeczył? ");
INSERT INTO polubg_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Gdyż widzę go ze szczytu skał, spoglądam na niego z pagórków; oto ten lud będzie mieszkać osobno, do innych narodów nie będzie zaliczony. ");
INSERT INTO polubg_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Któż policzy proch Jakuba, któż policzy choćby czwartą część Izraela? Niech umrę śmiercią sprawiedliwych i niech mój koniec będzie taki jak ich. ");
INSERT INTO polubg_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Wtedy Balak powiedział do Balaama: Cóż mi uczyniłeś? Sprowadziłem cię, abyś przeklął moich wrogów, a oto ty im wielce błogosławiłeś. ");
INSERT INTO polubg_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","A on odpowiedział: Czy nie mam pilnować tego, by mówić to, co PAN włożył w moje usta? ");
INSERT INTO polubg_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","I Balak powiedział do niego: Chodź, proszę, ze mną na inne miejsce, z którego będziesz mógł ich widzieć; zobaczysz tylko ich skraj, wszystkich nie zobaczysz. Przeklnij mi ich stamtąd. ");
INSERT INTO polubg_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","I zaprowadził go na pole Sofim, na szczyt góry Pizga; tam zbudował siedem ołtarzy i ofiarował po jednym cielcu i jednym baranie na każdym ołtarzu. ");
INSERT INTO polubg_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","I powiedział do Balaka: Pozostań tu przy swoim całopaleniu, a ja pójdę tam na spotkanie PANA. ");
INSERT INTO polubg_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","I PAN wyszedł na spotkanie z Balaamem, włożył słowa w jego usta i powiedział: Wróć do Balaka i tak mu powiedz. ");
INSERT INTO polubg_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Przyszedł więc do niego, a oto on stał przy swoim całopaleniu, a z nim książęta Moabu. I Balak zapytał go: Cóż ci PAN powiedział? ");
INSERT INTO polubg_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","I rozpoczął swą przypowieść tymi słowy: Wstań, Balaku, i słuchaj; nakłoń swego ucha, synu Sippora. ");
INSERT INTO polubg_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Bóg nie jest człowiekiem, aby miał kłamać, ani synem człowieczym, żeby miał żałować. Czy on powie coś, a tego nie uczyni? Czy wypowie, a nie spełni? ");
INSERT INTO polubg_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Oto otrzymałem rozkaz, żeby błogosławić; on błogosławił, a ja tego nie mogę odwrócić. ");
INSERT INTO polubg_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Nie dostrzegł nieprawości w Jakubie ani nie widział przestępstwa w Izraelu. PAN, jego Bóg, jest z nim, a okrzyk króla – przy nim. ");
INSERT INTO polubg_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Bóg wyprowadził ich z Egiptu, jego moc jest jak u jednorożca. ");
INSERT INTO polubg_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Nie ma bowiem zaklęcia przeciw Jakubowi ani wróżby przeciw Izraelowi. Już od tego czasu będzie się mówić o Jakubie i o Izraelu: Czego dokonał Bóg! ");
INSERT INTO polubg_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Oto lud powstanie jak silny lew, jak młody lew się podnosi; nie położy się, aż pożre zdobycz i wypije krew zabitych. ");
INSERT INTO polubg_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Wtedy Balak powiedział do Balaama: Ani ich nie przeklinaj więcej, ani im też nie błogosław. ");
INSERT INTO polubg_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","I Balaam odpowiedział Balakowi: Czy nie powiedziałem ci, że cokolwiek powie PAN, to uczynię? ");
INSERT INTO polubg_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak powiedział do Balaama: Chodź, proszę, zaprowadzę cię na inne miejsce, może się spodoba Bogu, żebyś ich stamtąd przeklął. ");
INSERT INTO polubg_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Wtedy Balak wziął Balaama na szczyt Peor, który wznosi się nad pustynią. ");
INSERT INTO polubg_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","I Balaam powiedział do Balaka: Zbuduj mi siedem ołtarzy i przygotuj mi tu siedem cielców i siedem baranów. ");
INSERT INTO polubg_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak uczynił więc tak, jak mu rozkazał Balaam, i ofiarował po jednym cielcu i jednym baranie na każdym ołtarzu. ");
INSERT INTO polubg_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Gdy Balaam zauważył, że PAN upodobał sobie błogosławić Izraela, nie poszedł jak przedtem szukać wróżby, lecz zwrócił swoją twarz ku pustyni. ");
INSERT INTO polubg_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","I Balaam podniósł swoje oczy, i zobaczył Izraela obozującego według swoich pokoleń. Wtedy Duch Boży spoczął na nim. ");
INSERT INTO polubg_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","I rozpoczął swoją przypowieść tymi słowy: Wypowiedź Balaama, syna Beora, wypowiedź człowieka, który ma otwarte oczy; ");
INSERT INTO polubg_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Wypowiedź tego, który słyszał słowa Boga, który miał widzenie Wszechmocnego, a padając, miał otwarte oczy: ");
INSERT INTO polubg_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Jak piękne są twoje namioty, Jakubie, twoje przybytki, Izraelu! ");
INSERT INTO polubg_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Rozciągnęły się jak doliny, jak ogrody przy rzece, jak aloesy, które PAN zasadził, jak cedry nad wodami. ");
INSERT INTO polubg_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Popłynie woda z jego wiadra, jego nasienie będzie w wielu wodach, jego król przewyższy Agaga i jego królestwo będzie wyniesione. ");
INSERT INTO polubg_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Bóg wyprowadził go z Egiptu, jego moc jest jak u jednorożca; pożre wrogie sobie narody, pokruszy ich kości i przeszyje je swymi strzałami. ");
INSERT INTO polubg_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Położył się, leży jak lew, jak silny lew: któż go obudzi? Błogosławiony ten, kto cię błogosławi, a przeklęty ten, kto cię przeklina. ");
INSERT INTO polubg_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Wtedy zapłonął gniew Balaka na Balaama i klasnął w dłonie. I Balak powiedział do Balaama: Wezwałem cię, abyś przeklinał moich wrogów, a oto już trzy razy ich błogosławiłeś. ");
INSERT INTO polubg_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Uciekaj więc teraz do siebie. Powiedziałem, że wielce cię uczczę, lecz oto PAN pozbawił cię tej czci. ");
INSERT INTO polubg_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","I Balaam powiedział do Balaka: Czy i twoim posłom, których do mnie wysłałeś, nie powiedziałem: ");
INSERT INTO polubg_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Choćby Balak dał mi swój dom pełen srebra i złota, nie będę mógł przekroczyć słowa PANA, bym sam z siebie uczynił coś dobrego lub złego; co PAN mi powie, to będę mówił. ");
INSERT INTO polubg_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Teraz idę do mego ludu, ale chodź i oznajmię ci, co ten lud uczyni twemu ludowi w przyszłości. ");
INSERT INTO polubg_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","I rozpoczął swoją przypowieść tymi słowy: Wypowiedź Balaama, syna Beora, wypowiedź człowieka, który ma otwarte oczy; ");
INSERT INTO polubg_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Wypowiedź tego, który słyszał słowa Boga, który ma wiedzę o Najwyższym, który miał widzenie Wszechmocnego, a padając, miał otwarte oczy: ");
INSERT INTO polubg_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ujrzę go, ale nie teraz; zobaczę go, ale nie z bliska; gwiazda wzejdzie z Jakuba, berło powstanie z Izraela i pobije książąt Moabu oraz wytraci wszystkich synów Seta. ");
INSERT INTO polubg_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom stanie się posiadłością, Seir też stanie się posiadłością swoich wrogów, a Izrael będzie sobie poczynał mężnie. ");
INSERT INTO polubg_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Z Jakuba powstanie władca i wyniszczy resztki miasta. ");
INSERT INTO polubg_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","A gdy spojrzał na Amaleka, rozpoczął swą przypowieść tymi słowy: Amalek był pierwszym z narodów, lecz jego końcem będzie wieczna zguba. ");
INSERT INTO polubg_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Potem spojrzał na Kenitów i rozpoczął swą przypowieść tymi słowy: Twoje mieszkanie jest mocne, a swoje gniazdo założyłeś na skale; ");
INSERT INTO polubg_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","A jednak Kenita będzie spustoszony, aż Aszszur weźmie cię w niewolę. ");
INSERT INTO polubg_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Znowu rozpoczął swą przypowieść tymi słowy: Ach! Któż żyw zostanie, gdy Bóg to uczyni? ");
INSERT INTO polubg_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Przypłyną bowiem okręty od wybrzeża Kittim i pognębią Aszszur, pognębią też Eber; lecz i oni sami zginą na zawsze. ");
INSERT INTO polubg_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Potem Balaam wstał i odszedł, i wrócił do siebie. Balak także poszedł swoją drogą. ");
INSERT INTO polubg_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Potem Izrael zamieszkał w Szittim i lud zaczął uprawiać nierząd z córkami Moabu. ");
INSERT INTO polubg_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","One zapraszały lud do ofiar swoich bogów. A lud jadł i oddawał pokłon ich bogom. ");
INSERT INTO polubg_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","I Izrael przyłączył się do Baal-Peora, i PAN bardzo rozgniewał się na Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Wtedy PAN powiedział do Mojżesza: Zbierz wszystkich naczelników ludu i powieś ich przed PANEM na słońcu, aby zapalczywość gniewu PANA odwróciła się od Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Mojżesz powiedział więc do sędziów Izraela: Niech każdy z was zabije swoich ludzi, którzy przyłączyli się do Baal-Peora. ");
INSERT INTO polubg_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","A oto jeden z synów Izraela przyszedł i przyprowadził do swoich braci Midianitkę na oczach Mojżesza i na oczach całego zgromadzenia synów Izraela, którzy płakali przed wejściem do Namiotu Zgromadzenia. ");
INSERT INTO polubg_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Gdy zobaczył to Pinchas, syn Eleazara, syna Aarona, kapłana, wstał spośród zgromadzenia i wziął do ręki oszczep. ");
INSERT INTO polubg_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","I poszedł za tym Izraelitą do namiotu, przebił oboje, tego Izraelitę oraz kobietę przez jej podbrzusze. I plaga wśród synów Izraela została powstrzymana. ");
INSERT INTO polubg_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","A tych, którzy umarli od tej plagi, było dwadzieścia cztery tysiące. ");
INSERT INTO polubg_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Pinchas, syn Eleazara, syna Aarona, kapłana, odwrócił mój gniew od synów Izraela, gdyż okazał wśród nich gorliwość ze względu na mnie, tak że nie wytraciłem synów Izraela w mojej zazdrości. ");
INSERT INTO polubg_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Dlatego powiedz mu: Oto zawieram z nim moje przymierze pokoju; ");
INSERT INTO polubg_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Będzie to dla niego i dla jego potomstwa po nim przymierze wiecznego kapłaństwa, ponieważ okazał gorliwość o swego Boga i dokonał przebłagania za synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","A imię tego Izraelity, który został zabity wraz z Midianitką, było Zimri; był to syn Salu, naczelnika domu swego ojca, z pokolenia Symeona. ");
INSERT INTO polubg_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Imię zabitej Midianitki było Kozbi, była to córka Sura, naczelnika w swoim narodzie i w domu swego ojca w Midianie. ");
INSERT INTO polubg_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Odnoście się wrogo do Midianitów i pobijcie ich; ");
INSERT INTO polubg_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Ponieważ oni odnosili się wrogo do was przez swoje podstępy, a podeszli was przez Baal-Peora i przez ich siostrę Kozbi, córkę księcia Midianu, która została zabita w dniu plagi z powodu Peora. ");
INSERT INTO polubg_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","A po tej pladze PAN powiedział do Mojżesza i Eleazara, syna Aarona, kapłana: ");
INSERT INTO polubg_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Policzcie całe zgromadzenie synów Izraela, od dwudziestego roku życia wzwyż, według domów ich ojców, wszystkich zdolnych do walki w Izraelu. ");
INSERT INTO polubg_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Przemówił więc Mojżesz i kapłan Eleazar do nich na równinach Moabu, nad Jordanem, naprzeciw Jerycha: ");
INSERT INTO polubg_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Policzcie lud, od dwudziestego roku życia wzwyż, jak PAN rozkazał Mojżeszowi i synom Izraela, którzy wyszli z ziemi Egiptu. ");
INSERT INTO polubg_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, pierworodny Izraela: synowie Rubena to Henoch, od którego pochodzi rodzina Henochitów; Pallu, od którego pochodzi rodzina Palluitów; ");
INSERT INTO polubg_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Chesron, od którego pochodzi rodzina Chesronitów, i Karmi, od którego pochodzi rodzina Karmitów. ");
INSERT INTO polubg_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","To są rodziny Rubenitów; a było ich policzonych czterdzieści trzy tysiące siedmiuset trzydziestu. ");
INSERT INTO polubg_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","A synowie Pallu to Eliab. ");
INSERT INTO polubg_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Synowie zaś Eliaba to Nemuel, Datan i Abiram. To ten Datan i Abiram, osławieni wśród zgromadzenia, którzy zbuntowali się przeciwko Mojżeszowi i Aaronowi z gromadą Koracha, gdy zbuntowali się przeciwko PANU. ");
INSERT INTO polubg_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","I ziemia otworzyła swoją paszczę, i pochłonęła ich razem z Korachem, podczas gdy cała gromada zginęła; ogień pochłonął dwustu pięćdziesięciu mężczyzn. Stali się oni znakiem; ");
INSERT INTO polubg_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Lecz synowie Koracha nie umarli. ");
INSERT INTO polubg_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Synowie Symeona według swych rodzin to: Nemuel, od którego pochodzi rodzina Nemuelitów, Jamin, od którego rodzina Jaminitów, Jachin, od którego rodzina Jachinitów; ");
INSERT INTO polubg_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zerach, od którego rodzina Zerachitów, Szaul, od którego rodzina Szaulitów. ");
INSERT INTO polubg_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","To są rodziny Symeonitów; a było ich dwadzieścia dwa tysiące dwustu. ");
INSERT INTO polubg_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Synowie Gada według swych rodzin to: Sefon, od którego pochodzi rodzina Sefonitów, Chaggi, od którego rodzina Chaggitów, Szuni, od którego rodzina Szunitów; ");
INSERT INTO polubg_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni, od którego rodzina Oznitów, Er, od którego rodzina Erytów; ");
INSERT INTO polubg_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod, od którego rodzina Arodytów, Ariel, od którego rodzina Arielitów. ");
INSERT INTO polubg_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","To są rodziny synów Gada według ich spisu, czterdzieści tysięcy pięciuset. ");
INSERT INTO polubg_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Synowie Judy to Er i Onan. Er i Onan umarli w ziemi Kanaan. ");
INSERT INTO polubg_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Synowie Judy według swych rodzin to: Szela, od którego pochodzi rodzina Szelitów, Peres, od którego rodzina Peresytów, Zerach, od którego rodzina Zerachitów; ");
INSERT INTO polubg_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Synowie Peresa to: Chesron, od którego rodzina Chesronitów, Chamul, od którego rodzina Chamulitów. ");
INSERT INTO polubg_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","To są rodziny Judy według ich spisu, siedemdziesiąt sześć tysięcy pięciuset. ");
INSERT INTO polubg_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Synowie Issachara według swych rodzin to: Tola, od którego pochodzi rodzina Tolaitów, Puwwa, od którego rodzina Puwwitów; ");
INSERT INTO polubg_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jaszub, od którego rodzina Jaszubitów, Szimrona, od którego rodzina Szimronitów. ");
INSERT INTO polubg_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","To są rodziny Issachara według ich spisu, sześćdziesiąt cztery tysiące trzystu. ");
INSERT INTO polubg_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Synowie Zebulona według swych rodzin to: Sered, od którego pochodzi rodzina Seredytów, Elon, od którego rodzina Elonitów, Jachleel, od którego rodzina Jachleelitów. ");
INSERT INTO polubg_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","A to są rodziny Zebulonitów według ich spisu, sześćdziesiąt tysięcy pięciuset. ");
INSERT INTO polubg_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Synowie Józefa według swych rodzin to Manasses i Efraim. ");
INSERT INTO polubg_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Synowie Manassesa to: Makir, od którego pochodzi rodzina Makirytów; a Makir spłodził Gileada, od Gileada pochodzi rodzina Gileadczyków; ");
INSERT INTO polubg_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","To są synowie Gileada: Jezer, od którego rodzina Jezerytów, Chelek, od którego rodzina Chelekitów; ");
INSERT INTO polubg_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel, od którego rodzina Asrielitów, Szechem, od którego rodzina Szechemitów; ");
INSERT INTO polubg_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Szemida, od którego rodzina Szemidaitów, oraz Chefer, od którego rodzina Cheferytów. ");
INSERT INTO polubg_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","A Selofchad, syn Chefera, nie miał synów, lecz tylko córki, a imiona córek Selofchada to: Machla, Noa, Chogla, Milka i Tirsa. ");
INSERT INTO polubg_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","To są rodziny Manassesa według ich spisu, pięćdziesiąt dwa tysiące siedmiuset. ");
INSERT INTO polubg_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","To są synowie Efraima według swych rodzin: Szutelach, od którego pochodzi rodzina Szutelachitów, Becher, od którego rodzina Becherytów, Tachan, od którego rodzina Tachanitów; ");
INSERT INTO polubg_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","A to są synowie Szutelacha: Eran, od którego rodzina Eranitów. ");
INSERT INTO polubg_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","To są rodziny synów Efraima według ich spisu: trzydzieści dwa tysiące pięciuset. To są synowie Józefa według swych rodzin. ");
INSERT INTO polubg_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","A synowie Beniamina według swych rodzin to: Bela, od którego pochodzi rodzina Belaitów, Aszbel, od którego rodzina Aszbelitów, Achiram, od którego rodzina Achiramitów; ");
INSERT INTO polubg_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Szufam, od którego rodzina Szufamitów, Chufam, od którego rodzina Chufamitów. ");
INSERT INTO polubg_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Synowie Beli to Ard i Naaman, od Arda rodzina Ardytów, a od Naamana rodzina Naamitów. ");
INSERT INTO polubg_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","To są synowie Beniamina według swych rodzin. Ich liczba wynosi czterdzieści pięć tysięcy sześciuset. ");
INSERT INTO polubg_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","To są synowie Dana według swych rodzin: Szucham, od którego pochodzi rodzina Szuchamitów. To są rodziny Dana według swych rodzin. ");
INSERT INTO polubg_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Wszystkich rodzin Szuchamitów według ich spisu było sześćdziesiąt cztery tysiące czterystu. ");
INSERT INTO polubg_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Synowie Aszera według swych rodzin to: Jimna, od którego pochodzi rodzina Jimnaitów, Jiszwi, od którego rodzina Jiszwitów, Beria, od którego rodzina Beriaitów; ");
INSERT INTO polubg_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Synowie Berii to: Cheber, od którego rodzina Cheberytów, Malkiel, od którego rodzina Malkielitów. ");
INSERT INTO polubg_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","A córce Aszera było na imię Sarach. ");
INSERT INTO polubg_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","To są rodziny synów Aszera według ich spisu: pięćdziesiąt trzy tysiące czterystu. ");
INSERT INTO polubg_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Synowie Neftalego według swych rodzin to: Jachseel, od którego pochodzi rodzina Jachseelitów, Guni, od którego rodzina Gunitów; ");
INSERT INTO polubg_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jeser, od którego rodzina Jeserytów, Szillem, od którego rodzina Szillemitów. ");
INSERT INTO polubg_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","To są rodziny Neftalego według ich rodzin. Ich liczba wynosi czterdzieści pięć tysięcy czterystu. ");
INSERT INTO polubg_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","To jest liczba synów Izraela: sześćset jeden tysięcy siedmiuset trzydziestu. ");
INSERT INTO polubg_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Pomiędzy nich zostanie podzielona ziemia jako dziedzictwo według liczby imion. ");
INSERT INTO polubg_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Liczniejszemu dasz większe dziedzictwo, a mniej licznemu dasz mniejsze dziedzictwo. Każdemu będzie dane jego dziedzictwo według liczby policzonych. ");
INSERT INTO polubg_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ziemia jednak będzie rozdzielona przez losowanie; otrzymają dziedzictwo według imion pokoleń swoich ojców. ");
INSERT INTO polubg_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Zgodnie z losem będzie rozdzielone dziedzictwo pomiędzy liczne i nieliczne. ");
INSERT INTO polubg_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Oto policzeni z Lewitów według swych rodzin: Gerszon, od którego pochodzi rodzina Gerszonitów, Kehat, od którego rodzina Kehatytów, Merari, od którego rodzina Meraritów. ");
INSERT INTO polubg_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","To są rodziny Lewiego: rodzina Libnitów, rodzina Chebronitów, rodzina Machlitów, rodzina Muszitów, rodzina Korachitów; a Kehat spłodził Amrama. ");
INSERT INTO polubg_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","A żonie Amrama było na imię Jochebed, była to córka Lewiego, która mu się urodziła w Egipcie; to ona urodziła Amramowi Aarona i Mojżesza oraz ich siostrę Miriam. ");
INSERT INTO polubg_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaronowi urodzili się Nadab i Abihu, Eleazar i Itamar. ");
INSERT INTO polubg_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Ale Nadab i Abihu umarli, gdy ofiarowali inny ogień przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","A ich liczba wynosiła dwadzieścia trzy tysiące, wszystkich mężczyzn od miesiąca wzwyż; nie zostali jednak policzeni wśród synów Izraela, gdyż nie dano im dziedzictwa pośród synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","To są ci policzeni przez Mojżesza i kapłana Eleazara; oni policzyli synów Izraela na równinach Moabu, nad Jordanem, naprzeciw Jerycha. ");
INSERT INTO polubg_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Lecz wśród nich nie było nikogo z tych policzonych przez Mojżesza i kapłana Aarona, gdy policzyli synów Izraela na pustyni Synaj; ");
INSERT INTO polubg_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","PAN bowiem powiedział o nich: Z pewnością umrą na pustyni. I nie pozostał żaden z nich oprócz Kaleba, syna Jefunnego, i Jozuego, syna Nuna. ");
INSERT INTO polubg_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Wtedy przyszły córki Selofchada, syna Chefera, syna Gileada, syna Makira, syna Manassesa, z rodu Manassesa, syna Józefa; a to są imiona jego córek: Machla, Noa, Chogla, Milka i Tirsa. ");
INSERT INTO polubg_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","I stanęły przed Mojżeszem, przed kapłanem Eleazarem, przed naczelnikami i całym zgromadzeniem u wejścia do Namiotu Zgromadzenia i powiedziały: ");
INSERT INTO polubg_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Nasz ojciec umarł na pustyni, ale nie należał do zgrai tych, którzy zbuntowali się przeciw PANU w gromadzie Koracha. Umarł za własny grzech, a nie miał synów. ");
INSERT INTO polubg_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Dlaczego imię naszego ojca miałoby zniknąć z jego rodziny przez to, że nie miał syna? Dajcie nam posiadłość pośród braci naszego ojca. ");
INSERT INTO polubg_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Mojżesz przedstawił więc ich sprawę PANU. ");
INSERT INTO polubg_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Córki Selofchada słusznie mówią: Daj im koniecznie dziedziczną posiadłość pośród braci ich ojca, a przenieś na nie dziedzictwo ich ojca. ");
INSERT INTO polubg_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","I przemów do synów Izraela tak: Jeśli ktoś umrze, a nie miał syna, wtedy przeniesiecie jego dziedzictwo na jego córkę. ");
INSERT INTO polubg_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","A jeśli nie miał córki, to dacie jego dziedzictwo jego braciom. ");
INSERT INTO polubg_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","A jeśli nie miał braci, to dacie jego dziedzictwo braciom jego ojca. ");
INSERT INTO polubg_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","A jeśli jego ojciec nie miał braci, to dacie jego dziedzictwo najbliższemu krewnemu z jego rodziny, aby je odziedziczył. I będzie to dla synów Izraela ustawą prawną, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Potem PAN powiedział do Mojżesza: Wstąp na tę górę Abarim i spójrz na ziemię, którą dałem synom Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","A gdy ją zobaczysz, zostaniesz i ty przyłączony do swego ludu, jak został przyłączony twój brat Aaron. ");
INSERT INTO polubg_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Dlatego że sprzeciwiliście się mojemu rozkazowi na pustyni Syn, podczas buntu zgromadzenia, i nie uświęciliście mnie na ich oczach u tych wód. To są wody Meriba w Kadesz, na pustyni Syn. ");
INSERT INTO polubg_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Wtedy Mojżesz powiedział do PANA: ");
INSERT INTO polubg_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Niech PAN, Bóg duchów wszelkiego ciała, ustanowi męża nad zgromadzeniem; ");
INSERT INTO polubg_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Który będzie wychodził przed nim i który będzie wchodził przed nim, który będzie je wyprowadzał i który będzie je przyprowadzał, aby zgromadzenie PANA nie było jak owce, które nie mają pasterza. ");
INSERT INTO polubg_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","PAN powiedział do Mojżesza: Weź do siebie Jozuego, syna Nuna, męża, w którym jest mój Duch, i połóż na nim swoją rękę; ");
INSERT INTO polubg_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","I postaw go przed kapłanem Eleazarem i przed całym zgromadzeniem, i na ich oczach daj mu polecenie; ");
INSERT INTO polubg_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","I przenieś na niego część swojej godności, aby go słuchało całe zgromadzenie synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Będzie on stawał przed kapłanem Eleazarem, aby ten za niego radził się przed PANEM za pośrednictwem sądu Urim. Na jego rozkaz będą wychodzić i na jego rozkaz będą wchodzić – on, a z nim wszyscy synowie Izraela, całe zgromadzenie. ");
INSERT INTO polubg_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","I Mojżesz uczynił tak, jak PAN mu rozkazał. Wziął Jozuego i postawił go przed kapłanem Eleazarem i przed całym zgromadzeniem. ");
INSERT INTO polubg_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Następnie położył na niego swoje ręce i dał mu polecenie, tak jak PAN nakazał przez Mojżesza. ");
INSERT INTO polubg_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Rozkaż synom Izraela i powiedz im: Przestrzegajcie składania mi w wyznaczonym czasie mojej ofiary, mojego pokarmu dla moich spalanych ofiar na miłą woń dla mnie. ");
INSERT INTO polubg_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","I powiedz im: To jest ofiara spalana, którą będziecie składać PANU: dwa roczne baranki bez skazy codziennie, na nieustanne całopalenie; ");
INSERT INTO polubg_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Jednego baranka będziesz składać rankiem, a drugiego wieczorem. ");
INSERT INTO polubg_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Do tego na ofiarę pokarmową jedną dziesiątą efy mąki pszennej zmieszanej z jedną czwartą hinu wytłoczonej oliwy. ");
INSERT INTO polubg_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","To jest nieustanne całopalenie, które ustalono na górze Synaj jako miłą woń, ofiarę spalaną dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","A jej ofiarą z płynów będzie jedna czwarta hinu na jednego baranka; ofiarę z płynów, z mocnego napoju, wylejesz w miejscu świętym dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Drugiego baranka będziesz składał wieczorem; złożysz go podobnie jak poranną ofiarę pokarmową i ofiarę z płynów – jako ofiarę spalaną na miłą woń dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Lecz w dniu szabatu złożysz dwa roczne baranki bez skazy i dwie dziesiąte efy mąki pszennej zmieszanej z oliwą na ofiarę z pokarmów wraz z jej ofiarą z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","To jest całopalenie sobotnie w każdy szabat, oprócz nieustannego całopalenia i jego ofiary z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","A na początku każdego waszego miesiąca będziecie składać PANU całopalenie: dwa młode cielce, jednego barana, siedem rocznych baranków bez skazy; ");
INSERT INTO polubg_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","I trzy dziesiąte efy mąki pszennej zmieszanej z oliwą na ofiarę pokarmową na każdego cielca oraz dwie dziesiąte efy mąki pszennej zmieszanej z oliwą na ofiarę pokarmową na każdego barana; ");
INSERT INTO polubg_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","I jedną dziesiątą efy mąki pszennej zmieszanej z oliwą na ofiarę pokarmową na każdego baranka jako całopalenie na miłą woń, ofiarę spalaną dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ich ofiarami z płynów będą: pół hinu wina na każdego cielca, jedna trzecia hinu na każdego barana i jedna czwarta hinu na każdego baranka; to jest całopalenie na nowiu księżyca przez wszystkie miesiące roku. ");
INSERT INTO polubg_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Także jednego kozła ze stada jako ofiarę za grzech będziecie składać PANU oprócz nieustannego całopalenia oraz jego ofiary z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","A pierwszego miesiąca, czternastego dnia, jest Pascha PANA. ");
INSERT INTO polubg_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","A piętnastego dnia tego miesiąca jest uroczyste święto: przez siedem dni będziecie jeść przaśne chleby. ");
INSERT INTO polubg_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Pierwszego dnia będzie święte zgromadzenie, nie będziecie wykonywać żadnej ciężkiej pracy. ");
INSERT INTO polubg_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Lecz złożycie PANU ofiarę spalaną na całopalenie: dwa młode cielce, jednego barana i siedem rocznych baranków. Mają być bez skazy. ");
INSERT INTO polubg_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","A ich ofiara pokarmowa będzie z mąki pszennej zmieszanej z oliwą: będziecie składać trzy dziesiąte efy na każdego cielca, a dwie dziesiąte na każdego barana; ");
INSERT INTO polubg_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Po jednej dziesiątej efy złożysz na każdego baranka z tych siedmiu baranków; ");
INSERT INTO polubg_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","I jednego kozła na ofiarę za grzech, na dokonanie przebłagania za was. ");
INSERT INTO polubg_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Będziecie to wszystko składać oprócz porannego całopalenia, które jest nieustannym całopaleniem. ");
INSERT INTO polubg_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Tak każdego dnia przez te siedem dni będziecie składać pokarm ofiary spalanej na miłą woń dla PANA. Będziecie to składać oprócz nieustannego całopalenia i jego ofiary z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","A siódmego dnia będziecie mieli święte zgromadzenie; nie będziecie wykonywać żadnej ciężkiej pracy. ");
INSERT INTO polubg_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","A w dniu pierwocin, gdy będziecie składać PANU nową ofiarę pokarmową, gdy się wypełnią wasze tygodnie, będziecie mieli święte zgromadzenie; nie będziecie wykonywać żadnej ciężkiej pracy. ");
INSERT INTO polubg_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","I złożycie PANU całopalenie na miłą woń: dwa młode cielce, jednego barana, siedem rocznych baranków. ");
INSERT INTO polubg_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","A na ich ofiarę pokarmową z mąki pszennej zmieszanej z oliwą: trzy dziesiąte efy na każdego cielca, dwie dziesiąte na każdego barana; ");
INSERT INTO polubg_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Po jednej dziesiątej na każdego baranka z tych siedmiu baranków; ");
INSERT INTO polubg_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","I jednego kozła z kóz na dokonanie przebłagania za was. ");
INSERT INTO polubg_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Będziecie to wszystko składać oprócz nieustannego całopalenia i jego ofiary pokarmowej, które mają być bez skazy, wraz z ich ofiarami z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Pierwszego dnia siódmego miesiąca będziecie mieli święte zgromadzenie; nie będziecie wykonywać żadnej ciężkiej pracy. Będzie to dla was dzień wesołego trąbienia. ");
INSERT INTO polubg_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","I złożycie jako całopalenie, na miłą woń dla PANA, jednego młodego cielca, jednego barana oraz siedem rocznych baranków bez skazy; ");
INSERT INTO polubg_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","A ich ofiarą pokarmową z mąki pszennej zmieszanej z oliwą będzie: trzy dziesiąte efy na cielca, dwie dziesiąte części na barana; ");
INSERT INTO polubg_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","I jedna dziesiąta na każdego baranka z tych siedmiu baranków; ");
INSERT INTO polubg_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Oraz jednego kozła z kóz jako ofiarę za grzech, by dokonać za was przebłagania; ");
INSERT INTO polubg_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Oprócz comiesięcznego całopalenia i jego ofiary pokarmowej, oprócz nieustannego całopalenia i jego ofiary pokarmowej oraz ich ofiar z płynów, zgodnie z ich przepisem, na miłą woń; będzie to ofiara spalana dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Dziesiątego dnia tego siódmego miesiąca będziecie mieć święte zgromadzenie i będziecie trapić swoje dusze. Nie będziecie wykonywać żadnej ciężkiej pracy. ");
INSERT INTO polubg_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","I złożycie PANU całopalenie, na miłą woń, jednego młodego cielca, jednego barana i siedem rocznych baranków. Mają być bez skazy. ");
INSERT INTO polubg_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","A ich ofiarą pokarmową z mąki pszennej zmieszanej z oliwą będzie: trzy dziesiąte efy na cielca, dwie dziesiąte na barana; ");
INSERT INTO polubg_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","I jedna dziesiąta na każdego baranka z tych siedmiu baranków; ");
INSERT INTO polubg_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Oraz jednego kozła z kóz na ofiarę za grzech oprócz ofiary za grzech na przebłaganie i oprócz nieustannego całopalenia i jego ofiary pokarmowej oraz ich ofiar z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","A piętnastego dnia tego siódmego miesiąca będziecie mieć święte zgromadzenie. Nie będziecie wykonywać żadnej ciężkiej pracy, lecz będziecie obchodzić święto dla PANA przez siedem dni. ");
INSERT INTO polubg_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","I złożycie całopalenie jako ofiarę spalaną, na miłą woń dla PANA, trzynaście młodych cielców, dwa barany i czternaście rocznych baranków. Mają być bez skazy. ");
INSERT INTO polubg_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","A ich ofiarą pokarmową z mąki pszennej zmieszanej z oliwą będzie: trzy dziesiąte efy na każdego cielca z tych trzynastu cielców i dwie dziesiąte na każdego barana z tych dwóch baranów; ");
INSERT INTO polubg_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","I jedna dziesiąta na każdego baranka z tych czternastu baranków; ");
INSERT INTO polubg_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Oraz jednego kozła z kóz na ofiarę za grzech oprócz nieustannego całopalenia, jego ofiary pokarmowej i jego ofiary z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","A drugiego dnia złożycie dwanaście młodych cielców, dwa barany, czternaście rocznych baranków bez skazy; ");
INSERT INTO polubg_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","I ich ofiarę pokarmową, i ich ofiary z płynów do każdego cielca, do każdego barana i do każdego baranka, według ich liczby i według ich przepisów; ");
INSERT INTO polubg_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Oraz jednego kozła z kóz na ofiarę za grzech, oprócz nieustannego całopalenia, jego ofiary pokarmowej i ich ofiar z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","A trzeciego dnia złożycie jedenaście cielców, dwa barany, czternaście rocznych baranków bez skazy; ");
INSERT INTO polubg_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","I ich ofiarę pokarmową, i ich ofiary z płynów do każdego cielca, do każdego barana i do każdego baranka, według ich liczby i według ich przepisów; ");
INSERT INTO polubg_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Oraz jednego kozła na ofiarę za grzech oprócz nieustannego całopalenia, jego ofiary pokarmowej i jego ofiary z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","A czwartego dnia złożycie dziesięć cielców, dwa barany, czternaście rocznych baranków bez skazy; ");
INSERT INTO polubg_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Ich ofiarę pokarmową i ich ofiary z płynów do każdego cielca, do każdego barana i do każdego baranka, według ich liczby i według ich przepisów; ");
INSERT INTO polubg_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Oraz jednego kozła z kóz na ofiarę za grzech oprócz nieustannego całopalenia, jego ofiary pokarmowej i jego ofiary z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","A piątego dnia złożycie dziewięć cielców, dwa barany, czternaście rocznych baranków bez skazy; ");
INSERT INTO polubg_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","I ich ofiarę pokarmową, i ich ofiary z płynów do każdego cielca, do każdego barana i do każdego baranka, według ich liczby i według ich przepisów; ");
INSERT INTO polubg_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Oraz jednego kozła na ofiarę za grzech oprócz nieustannego całopalenia, jego ofiary pokarmowej i jego ofiary z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","A szóstego dnia złożycie osiem cielców, dwa barany, czternaście rocznych baranków bez skazy; ");
INSERT INTO polubg_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","I ich ofiarę pokarmową, i ich ofiary z płynów do każdego cielca, do każdego barana i do każdego baranka, według ich liczby i według ich przepisów; ");
INSERT INTO polubg_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Oraz jednego kozła na ofiarę za grzech oprócz nieustannego całopalenia, jego ofiary pokarmowej i jego ofiar z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","A siódmego dnia złożycie siedem cielców, dwa barany, czternaście rocznych baranków bez skazy; ");
INSERT INTO polubg_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","I ich ofiarę pokarmową, i ich ofiary z płynów do każdego cielca, do każdego barana i do każdego baranka, według ich liczby i według ich przepisów; ");
INSERT INTO polubg_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Oraz jednego kozła na ofiarę za grzech oprócz nieustannego całopalenia, jego ofiary pokarmowej i jego ofiary z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","A ósmego dnia będziecie mieli uroczyste święto. Nie będziecie wykonywać żadnej ciężkiej pracy. ");
INSERT INTO polubg_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Złożycie całopalenie jako ofiarę spalaną, na miłą woń dla PANA, jednego cielca, jednego barana, siedem rocznych baranków bez skazy; ");
INSERT INTO polubg_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Ich ofiarę pokarmową i ich ofiary z płynów do cielca, do barana i do każdego baranka, według ich liczby i według ich przepisów; ");
INSERT INTO polubg_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Oraz jednego kozła na ofiarę za grzech oprócz nieustannego całopalenia, jego ofiary pokarmowej i jego ofiary z płynów. ");
INSERT INTO polubg_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","To wszystko będziecie składać PANU podczas waszych uroczystych świąt oprócz waszych ślubów i dobrowolnych ofiar na wasze całopalenia, na wasze ofiary pokarmowe, na wasze ofiary z płynów i na wasze ofiary pojednawcze. ");
INSERT INTO polubg_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","I Mojżesz powiedział synom Izraela wszystko, co PAN mu rozkazał. ");
INSERT INTO polubg_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Potem Mojżesz powiedział do naczelników pokoleń pośród synów Izraela: Oto co PAN rozkazał. ");
INSERT INTO polubg_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Jeśli mężczyzna złoży PANU ślub lub przysięgę i zwiąże swoją duszę zobowiązaniem, to nie złamie swego słowa; wypełni wszystko według tego, co wyszło z jego ust. ");
INSERT INTO polubg_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Jeśli kobieta złoży PANU ślub i zwiąże się zobowiązaniem w domu swego ojca, w swojej młodości; ");
INSERT INTO polubg_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","A jej ojciec usłyszy ślub i zobowiązanie, którym związała swoją duszę, a jej ojciec będzie milczał o tym, wtedy wszystkie jej śluby będą ważne i każde zobowiązanie, którym związała swą duszę, będzie ważne. ");
INSERT INTO polubg_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Lecz jeśli jej ojciec sprzeciwi się jej w dniu, kiedy usłyszy o wszystkich jej ślubach i zobowiązaniach, którymi związała swoją duszę, wtedy nie będą ważne; PAN przebaczy jej, gdyż jej ojciec sprzeciwił się temu. ");
INSERT INTO polubg_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Ale jeśli mając męża, złożyła ślub lub wypowiedziała swymi ustami coś, czym związała swoją duszę; ");
INSERT INTO polubg_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","A jej mąż to usłyszał i milczał o tym w dniu, gdy to usłyszał, to jej śluby będą ważne i jej zobowiązania, którymi związała swoją duszę, będą ważne. ");
INSERT INTO polubg_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Lecz jeśli w dniu, gdy jej mąż usłyszał o tym, sprzeciwił się temu, to unieważnia jej ślub, który złożyła, i to, co wypowiedziała swymi ustami, czym związała swoją duszę; a PAN jej przebaczy. ");
INSERT INTO polubg_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Ale każdy ślub wdowy i rozwiedzionej, którym związały swoją duszę, będzie ważny. ");
INSERT INTO polubg_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Lecz jeśli w domu swego męża złożyła ślub lub związała swoją duszę zobowiązaniem przysięgi; ");
INSERT INTO polubg_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","A jej mąż usłyszał to i milczał o tym, i nie sprzeciwił się temu, wtedy wszystkie jej śluby będą ważne i każdy obowiązek, którym zobowiązała swoją duszę, będzie ważny. ");
INSERT INTO polubg_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Ale jeśli jej mąż sprzeciwił się temu w dniu, kiedy to usłyszał, to wszelki ślub i zobowiązanie, jakie padły z jej ust, będą nieważne; jej mąż je unieważnił; a PAN jej przebaczy. ");
INSERT INTO polubg_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Wszelki ślub i wszelką przysięgę zobowiązania na trapienie duszy może jej mąż potwierdzić lub może unieważnić. ");
INSERT INTO polubg_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","A jeśli jej mąż będzie milczał dzień po dniu, to potwierdza wszystkie jej śluby i wszystkie jej zobowiązania, które ją wiążą. Potwierdza je, ponieważ milczał o tym w dniu, kiedy je usłyszał; ");
INSERT INTO polubg_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Lecz jeśli je usłyszał i dopiero później unieważni, to poniesie jej nieprawość. ");
INSERT INTO polubg_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","To są ustawy, które PAN przykazał Mojżeszowi, między mężem a jego żoną, między ojcem a jego córką w jej młodości, póki jest w domu swego ojca. ");
INSERT INTO polubg_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Pomścij krzywdy synów Izraela na Midianitach. Potem zostaniesz przyłączony do swego ludu. ");
INSERT INTO polubg_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Mojżesz powiedział więc do ludu: Przygotujcie spośród siebie mężczyzn do bitwy, aby wyruszyli przeciw Midianitom i dokonali na nich zemsty PANA. ");
INSERT INTO polubg_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Wyślecie na wojnę po tysiącu z każdego pokolenia, ze wszystkich pokoleń Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","I wyznaczono z tysięcy Izraela po tysiącu z każdego pokolenia, dwanaście tysięcy gotowych do walki. ");
INSERT INTO polubg_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","I Mojżesz wysłał ich na wojnę po tysiącu z każdego pokolenia; posłał też z nimi Pinchasa, syna kapłana Eleazara, na wojnę, a w jego ręku były święte sprzęty i trąby sygnałowe. ");
INSERT INTO polubg_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Wtedy walczyli z Midianitami, jak PAN rozkazał Mojżeszowi, i pozabijali wszystkich mężczyzn. ");
INSERT INTO polubg_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Oprócz innych zabitych, zabili też królów Midianu: Ewiego, Rekema, Sura, Chura i Rebę – pięciu królów Midianu. Zabili też mieczem Balaama, syna Beora. ");
INSERT INTO polubg_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Synowie Izraela wzięli do niewoli kobiety Midianu i ich dzieci; zabrali też całe ich bydło i trzody, i cały ich majątek; ");
INSERT INTO polubg_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Spalili też ogniem wszystkie ich miasta, w których mieszkali, oraz wszystkie ich zamki; ");
INSERT INTO polubg_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","I zabrali cały łup oraz całą zdobycz zarówno z ludzi, jak i ze zwierząt; ");
INSERT INTO polubg_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","I przyprowadzili więźniów, zdobycz i łup do Mojżesza, do kapłana Eleazara i do zgromadzenia synów Izraela, do obozu na równinach Moabu, które są nad Jordanem, naprzeciw Jerycha. ");
INSERT INTO polubg_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","A Mojżesz, kapłan Eleazar i wszyscy naczelnicy zgromadzenia wyszli im naprzeciw poza obóz. ");
INSERT INTO polubg_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","I Mojżesz bardzo się rozgniewał na dowódców wojska, tysiączników i setników, którzy wrócili z walki. ");
INSERT INTO polubg_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","I mówił do nich Mojżesz: Czy zostawiliście przy życiu wszystkie kobiety? ");
INSERT INTO polubg_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Oto one za radą Balaama spowodowały, że synowie Izraela dopuścili się przewinienia przeciwko PANU w związku z Peorem, a to sprowadziło plagę na zgromadzenie PANA. ");
INSERT INTO polubg_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Zabijcie więc teraz wszystkich chłopców spośród dzieci, zabijcie też każdą kobietę, która obcowała z mężczyzną; ");
INSERT INTO polubg_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Lecz wszystkie dziewczyny, które nie obcowały z mężczyzną, zostawcie przy życiu dla siebie. ");
INSERT INTO polubg_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","A wy sami zostańcie przez siedem dni poza obozem. Każdy, kto zabił człowieka, i każdy, kto dotknął zabitego, niech się oczyści trzeciego i siódmego dnia, wy i wasi jeńcy. ");
INSERT INTO polubg_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Oczyśćcie również każdą szatę, wszelkie przedmioty skórzane i wszystko, co wykonano z koziej sierści, a także wszelkie drewniane przedmioty. ");
INSERT INTO polubg_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Potem kapłan Eleazar powiedział do wojowników, którzy wyruszyli na wojnę: Taka jest ustawa prawa, którą PAN nadał Mojżeszowi: ");
INSERT INTO polubg_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Tylko złoto, srebro, miedź, żelazo, cynę i ołów; ");
INSERT INTO polubg_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","Wszystko, co może znieść ogień, przeprowadzicie przez ogień i będzie czyste; jednak najpierw będzie oczyszczone wodą oczyszczenia. Wszystko zaś, co nie może znieść ognia, oczyścicie wodą. ");
INSERT INTO polubg_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Siódmego dnia wypierzecie też swoje szaty i będziecie czyści, a potem wejdziecie do obozu. ");
INSERT INTO polubg_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Następnie PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Razem z kapłanem Eleazarem i głowami spośród ojców zgromadzenia policz całą zdobycz uprowadzoną w ludziach i zwierzętach; ");
INSERT INTO polubg_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","I podziel zdobycz na dwie części: pomiędzy tych, którzy wyruszyli na wojnę, i pomiędzy całe zgromadzenie. ");
INSERT INTO polubg_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Od wojowników, którzy wyruszyli na wojnę, pobierz też daninę dla PANA, po jednym na pięćset, tak z ludzi, jak i wołów, osłów i owiec; ");
INSERT INTO polubg_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Weź to z ich połowy i oddaj kapłanowi Eleazarowi na ofiarę wzniesienia dla PANA. ");
INSERT INTO polubg_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","A z połowy synów Izraela weź po jednym z pięćdziesięciu z ludzi, wołów, osłów, owiec, słowem ze wszystkich zwierząt, i oddaj to Lewitom, którzy pełnią straż przy przybytku PANA. ");
INSERT INTO polubg_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","I Mojżesz, i kapłan Eleazar uczynili tak, jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","A zdobycz z pozostałego łupu, który zdobyli wojownicy, wynosiła sześćset siedemdziesiąt pięć tysięcy owiec; ");
INSERT INTO polubg_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","Siedemdziesiąt dwa tysiące wołów; ");
INSERT INTO polubg_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","Sześćdziesiąt jeden tysięcy osłów; ");
INSERT INTO polubg_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","I trzydzieści dwa tysiące kobiet, które nie obcowały z mężczyzną. ");
INSERT INTO polubg_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Połowa przypadająca w udziale tym, którzy wyruszyli na wojnę, wynosiła trzysta trzydzieści siedem tysięcy pięćset owiec. ");
INSERT INTO polubg_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Danina dla PANA z tych owiec wynosiła sześćset siedemdziesiąt pięć sztuk. ");
INSERT INTO polubg_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Wołów było trzydzieści sześć tysięcy, a z tego danina dla PANA – siedemdziesiąt dwie; ");
INSERT INTO polubg_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Osłów było trzydzieści tysięcy pięćset, a z tego danina dla PANA – sześćdziesiąt jeden. ");
INSERT INTO polubg_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Ludzi było szesnaście tysięcy, a z tego danina dla PANA – trzydzieści dwie osoby. ");
INSERT INTO polubg_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","I Mojżesz oddał kapłanowi Eleazarowi daninę na ofiarę wzniesienia dla PANA, tak jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","A z połowy należącej do synów Izraela, którą Mojżesz oddzielił od tych, którzy wyruszyli na wojnę; ");
INSERT INTO polubg_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","(Połowa należąca do zgromadzenia wynosiła trzysta trzydzieści siedem tysięcy pięćset owiec; ");
INSERT INTO polubg_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","Trzydzieści sześć tysięcy wołów; ");
INSERT INTO polubg_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","Trzydzieści tysięcy pięćset osłów; ");
INSERT INTO polubg_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","I szesnaście tysięcy osób). ");
INSERT INTO polubg_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Z tej połowy należącej do synów Izraela Mojżesz wziął po jednym na pięćdziesiąt z ludzi i zwierząt, i dał to Lewitom pełniącym straż przy przybytku PANA, tak jak PAN rozkazał Mojżeszowi. ");
INSERT INTO polubg_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Wtedy przyszli do Mojżesza dowódcy wojska, tysiącznicy i setnicy. ");
INSERT INTO polubg_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","I powiedzieli do niego: My, twoi słudzy, policzyliśmy wojowników, którzy byli pod naszym dowództwem, i nie brakuje z nas ani jednego. ");
INSERT INTO polubg_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Dlatego przynieśliśmy na ofiarę dla PANA to, co każdy zdobył: złote przedmioty, łańcuszki, bransolety, pierścienie, kolczyki i naszyjniki, by dokonać przebłagania za nasze dusze przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mojżesz i kapłan Eleazar przyjęli więc od nich to złoto, wszystkie wykonane przedmioty. ");
INSERT INTO polubg_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","A całego złota tej ofiary, którą oddali PANU, od tysiączników i setników, było szesnaście tysięcy siedemset pięćdziesiąt syklów. ");
INSERT INTO polubg_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Wojownicy bowiem zatrzymali łup, każdy dla siebie. ");
INSERT INTO polubg_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Mojżesz i kapłan Eleazar przyjęli to złoto od tysiączników i setników i zanieśli do Namiotu Zgromadzenia jako pamiątkę synów Izraela przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","A synowie Rubena i synowie Gada mieli bardzo liczne stada. Gdy zobaczyli ziemię Jazer i ziemię Gilead, że jest to miejsce odpowiednie dla bydła; ");
INSERT INTO polubg_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Przyszli ci synowie Gada i synowie Rubena i powiedzieli do Mojżesza, kapłana Eleazara oraz do naczelników zgromadzenia: ");
INSERT INTO polubg_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Atarot, Dibon, Jazer, Nimra, Cheszbon, Eleale, Sebam, Nebo i Beon; ");
INSERT INTO polubg_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Ziemia, którą PAN podbił przed zgromadzeniem Izraela, jest ziemią odpowiednią dla bydła, a twoi słudzy mają liczne bydło. ");
INSERT INTO polubg_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Mówili dalej: Jeśli znaleźliśmy łaskę w twoich oczach, niech ta ziemia będzie dana twoim sługom w posiadanie, a nie przeprowadzaj nas za Jordan. ");
INSERT INTO polubg_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Wtedy Mojżesz odpowiedział synom Gada i synom Rubena: Czy wasi bracia pójdą na wojnę, a wy tu będziecie siedzieć? ");
INSERT INTO polubg_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Dlaczego zniechęcacie serca synów Izraela, aby nie przeprawili się do ziemi, którą dał im PAN? ");
INSERT INTO polubg_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Tak właśnie postępowali wasi ojcowie, gdy ich posłałem z Kadesz-Barnea, aby wyszpiegowali tę ziemię. ");
INSERT INTO polubg_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Kiedy dotarli aż do doliny Eszkol i zobaczyli ziemię, zniechęcili serca synów Izraela, aby nie weszli do ziemi, którą PAN im dał; ");
INSERT INTO polubg_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Dlatego w tym dniu zapłonął gniew PANA i przysiągł: ");
INSERT INTO polubg_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Na pewno nikt z tych ludzi, którzy wyszli z Egiptu, od dwudziestego roku życia wzwyż, nie ujrzy tej ziemi, którą przysiągłem Abrahamowi, Izaakowi i Jakubowi, ponieważ nie szli za mną w pełni; ");
INSERT INTO polubg_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Oprócz Kaleba, syna Jefunnego, Kenizyty, i Jozuego, syna Nuna, ponieważ oni w pełni szli za PANEM. ");
INSERT INTO polubg_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","I zapłonął gniew PANA na Izraela, i sprawił, że tułali się po pustyni przez czterdzieści lat, aż wyginęło całe pokolenie, które czyniło źle w oczach PANA. ");
INSERT INTO polubg_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","A oto powstaliście w miejsce waszych ojców jako plemię grzesznych ludzi, aby jeszcze bardziej wzmóc zapalczywość gniewu PANA przeciw Izraelowi. ");
INSERT INTO polubg_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Jeśli bowiem odwrócicie się od kroczenia za nim, wtedy on znowu pozostawi ich na tej pustyni, a w ten sposób zgubicie cały ten lud. ");
INSERT INTO polubg_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Wtedy zbliżyli się do niego i powiedzieli: Tu zbudujemy zagrody dla naszego bydła i miasta dla naszych dzieci; ");
INSERT INTO polubg_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","My zaś sami zbrojnie i ochoczo pójdziemy przed synami Izraela, aż zaprowadzimy ich na ich miejsce, a nasze dzieci będą mieszkały w miastach obwarowanych ze względu na mieszkańców tej ziemi. ");
INSERT INTO polubg_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Nie wrócimy do swoich domów, dopóki każdy spośród synów Izraela nie otrzyma swojego dziedzictwa; ");
INSERT INTO polubg_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Nie weźmiemy dziedzictwa razem z nimi po tamtej stronie Jordanu i dalej, ponieważ nasze dziedzictwo przypadło nam po tej stronie Jordanu, po stronie wschodniej. ");
INSERT INTO polubg_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mojżesz powiedział im: Jeśli uczynicie to, co powiedzieliście, i uzbrojeni pójdziecie przed PANEM na wojnę; ");
INSERT INTO polubg_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","I każdy z was zbrojnie przejdzie Jordan przed PANEM, aż wypędzi swoich wrogów przed sobą; ");
INSERT INTO polubg_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","I ziemia zostanie podbita przed PANEM, a potem wrócicie, to będziecie niewinni przed PANEM i przed Izraelem; a ta ziemia będzie waszą posiadłością przed PANEM. ");
INSERT INTO polubg_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Lecz jeśli nie uczynicie tego, oto zgrzeszycie przeciw PANU, a wiedzcie, że wasz grzech was znajdzie. ");
INSERT INTO polubg_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Budujcie więc miasta dla waszych dzieci i zagrody dla waszych owiec; uczyńcie to, co wyszło z waszych ust. ");
INSERT INTO polubg_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Wtedy synowie Gada i synowie Rubena powiedzieli do Mojżesza: Twoi słudzy uczynią tak, jak nasz pan rozkazuje. ");
INSERT INTO polubg_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nasze dzieci, nasze żony, nasze trzody i całe nasze bydło pozostaną tu, w miastach Gileadu; ");
INSERT INTO polubg_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Twoi słudzy natomiast, wszyscy uzbrojeni na wojnę, pójdą przed PANEM, jak mówi nasz pan. ");
INSERT INTO polubg_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","I Mojżesz wydał rozkaz o nich kapłanowi Eleazarowi, Jozuemu, synowi Nuna, i naczelnikom spośród ojców pokoleń synów Izraela; ");
INSERT INTO polubg_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Mojżesz powiedział im: Jeśli synowie Gada i synowie Rubena przejdą z wami za Jordan, wszyscy uzbrojeni do wojny przed PANEM, a ziemia zostanie podbita przed wami, wtedy dacie im ziemię Gilead w posiadanie; ");
INSERT INTO polubg_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Lecz jeśli uzbrojeni nie przejdą z wami, wtedy otrzymają dziedzictwo pośród was w ziemi Kanaan. ");
INSERT INTO polubg_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Synowie Gada i synowie Rubena odpowiedzieli: Uczynimy to, co PAN powiedział do twoich sług; ");
INSERT INTO polubg_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Pójdziemy uzbrojeni przed PANEM do ziemi Kanaan, a posiadłość naszego dziedzictwa zostanie po tej stronie Jordanu. ");
INSERT INTO polubg_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Mojżesz dał wtedy synom Gada, synom Rubena i połowie pokolenia Manassesa, syna Józefa, królestwo Sichona, króla Amorytów, i królestwo Oga, króla Baszanu, ziemię z jej miastami i granicami, a także miasta tej ziemi dokoła. ");
INSERT INTO polubg_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","I synowie Gada odbudowali Dibon, Atarot i Aroer; ");
INSERT INTO polubg_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrot, Szofan, Jazer i Jogboha; ");
INSERT INTO polubg_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet-Nimra, Bet-Haran, miasta warowne i zagrody dla stad. ");
INSERT INTO polubg_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Synowie Rubena zaś odbudowali Cheszbon, Eleale i Kiriataim; ");
INSERT INTO polubg_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal-Meon, ich nazwy zmieniono, także Sybma; a miasta, które zbudowali, nazwali od swoich imion. ");
INSERT INTO polubg_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Synowie Makira, syna Manassesa, poszli do Gileadu, zdobyli go i wypędzili Amorytów, którzy tam mieszkali. ");
INSERT INTO polubg_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","I Mojżesz dał Gilead Makirowi, synowi Manassesa, a ten w nim zamieszkał. ");
INSERT INTO polubg_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Potem Jair, syn Manassesa, poszedł i zdobył ich wsie, które nazwał Chawot-Jair. ");
INSERT INTO polubg_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Także i Nobe poszedł i zdobył Kenat z jego wioskami, które nazwał Nobe, od swojego imienia. ");
INSERT INTO polubg_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Oto miejsca postojów synów Izraela, którzy wyszli z ziemi Egiptu ze swymi zastępami pod wodzą Mojżesza i Aarona. ");
INSERT INTO polubg_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Na rozkaz PANA Mojżesz spisał ich wymarsze według etapów. A oto ich wymarsze według etapów: ");
INSERT INTO polubg_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Wyruszyli z Ramses w pierwszym miesiącu, piętnastego dnia tego pierwszego miesiąca; nazajutrz po święcie Paschy synowie Izraela wyszli pod potężną ręką na oczach wszystkich Egipcjan; ");
INSERT INTO polubg_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Podczas gdy Egipcjanie grzebali wszystkich pierworodnych, których PAN zabił wśród nich. Także i nad ich bogami PAN dokonał sądu. ");
INSERT INTO polubg_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Wyruszyli więc synowie Izraela z Ramses i rozbili obóz w Sukkot. ");
INSERT INTO polubg_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Wyruszyli z Sukkot i rozbili obóz w Etam, które leży na skraju pustyni. ");
INSERT INTO polubg_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Wyruszyli z Etam i wrócili do Pi-Hachirot, które leży naprzeciw Baal-Sefon, i rozbili obóz przed Migdol. ");
INSERT INTO polubg_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Wyruszyli z Pi-Hachirot, przeszli przez środek morza na pustyni i po trzech dniach drogi po pustyni Etam rozbili obóz w Mara. ");
INSERT INTO polubg_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Wyruszyli z Mara i przyszli do Elim. A w Elim było dwanaście źródeł wody i siedemdziesiąt palm i tam rozbili obóz. ");
INSERT INTO polubg_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Wyruszyli z Elim i rozbili obóz nad Morzem Czerwonym. ");
INSERT INTO polubg_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Wyruszyli znad Morza Czerwonego i rozbili obóz na pustyni Sin. ");
INSERT INTO polubg_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Wyruszyli z pustyni Sin i rozbili obóz w Dofka. ");
INSERT INTO polubg_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Wyruszyli z Dofka i rozbili obóz w Alusz. ");
INSERT INTO polubg_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Wyruszyli z Alusz i rozbili obóz w Refidim, gdzie lud nie miał wody do picia. ");
INSERT INTO polubg_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Wyruszyli z Refidim i rozbili obóz na pustyni Synaj. ");
INSERT INTO polubg_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Wyruszyli z pustyni Synaj i rozbili obóz w Kibrot-Hattaawa. ");
INSERT INTO polubg_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Wyruszyli z Kibrot-Hattaawa i rozbili obóz w Chaserot. ");
INSERT INTO polubg_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Wyruszyli z Chaserot i rozbili obóz w Ritma. ");
INSERT INTO polubg_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Wyruszyli z Ritma i rozbili obóz w Rimmon-Peres. ");
INSERT INTO polubg_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Wyruszyli z Rimmon-Peres i rozbili obóz w Libnie. ");
INSERT INTO polubg_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Wyruszyli z Libny i rozbili obóz w Rissa. ");
INSERT INTO polubg_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Wyruszyli z Rissa i rozbili obóz w Kehelata. ");
INSERT INTO polubg_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Wyruszyli z Kehelata i rozbili obóz na górze Szefer. ");
INSERT INTO polubg_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Wyruszyli z góry Szefer i rozbili obóz w Charada. ");
INSERT INTO polubg_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Wyruszyli z Charada i rozbili obóz w Makhelot. ");
INSERT INTO polubg_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Wyruszyli z Makhelot i rozbili obóz w Tachat. ");
INSERT INTO polubg_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Wyruszyli z Tachat i rozbili obóz w Terach. ");
INSERT INTO polubg_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Wyruszyli z Terach i rozbili obóz w Mitka. ");
INSERT INTO polubg_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Wyruszyli z Mitka i rozbili obóz w Chaszmona. ");
INSERT INTO polubg_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Wyruszyli z Chaszmona i rozbili obóz w Moserot. ");
INSERT INTO polubg_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Wyruszyli z Moserot i rozbili obóz w Bene-Jaakan. ");
INSERT INTO polubg_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Wyruszyli z Bene-Jaakan i rozbili obóz w Chor-Haggidgad. ");
INSERT INTO polubg_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Wyruszyli z Chor-Haggidgad i rozbili obóz w Jotbata. ");
INSERT INTO polubg_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Wyruszyli z Jotbata i rozbili obóz w Abrona. ");
INSERT INTO polubg_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Wyruszyli z Abrona i rozbili obóz w Esjon-Geber. ");
INSERT INTO polubg_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Wyruszyli z Esjon-Geber i rozbili obóz na pustyni Syn, to jest w Kadesz. ");
INSERT INTO polubg_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Wyruszyli z Kadesz i rozbili obóz na górze Hor, na granicy ziemi Edomu. ");
INSERT INTO polubg_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Wtedy wstąpił kapłan Aaron na górę Hor na rozkaz PANA i tam umarł w czterdziestym roku po wyjściu synów Izraela z ziemi Egiptu, w pierwszym dniu piątego miesiąca. ");
INSERT INTO polubg_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaron miał sto dwadzieścia trzy lata, kiedy umarł na górze Hor. ");
INSERT INTO polubg_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","A król Aradu, Kananejczyk, który mieszkał na południu w ziemi Kanaan, usłyszał, że nadciągają synowie Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Wyruszyli z góry Hor i rozbili obóz w Salmona. ");
INSERT INTO polubg_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Wyruszyli z Salmona i rozbili obóz w Punon. ");
INSERT INTO polubg_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Wyruszyli z Punon i rozbili obóz w Obot. ");
INSERT INTO polubg_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Wyruszyli z Obot i rozbili obóz w Ijje-Abarim, na granicy Moabu. ");
INSERT INTO polubg_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Wyruszyli z Ijjim i rozbili obóz w Dibon-Gad. ");
INSERT INTO polubg_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Wyruszyli z Dibon-Gad i rozbili obóz w Almon-Diblataim. ");
INSERT INTO polubg_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Wyruszyli z Almon-Diblataim i rozbili obóz na górach Abarim, naprzeciwko Nebo. ");
INSERT INTO polubg_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Wyruszyli z gór Abarim i rozbili obóz na równinach Moabu, nad Jordanem, naprzeciw Jerycha. ");
INSERT INTO polubg_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","I rozłożyli się nad Jordanem, od Bet-Jeszimot aż do Abel-Szittim, na równinach Moabu. ");
INSERT INTO polubg_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","I PAN przemówił do Mojżesza na równinach Moabu, nad Jordanem, naprzeciw Jerycha, tymi słowy: ");
INSERT INTO polubg_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Przemów do synów Izraela i powiedz im: Gdy przeprawicie się przez Jordan do ziemi Kanaan; ");
INSERT INTO polubg_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","Wtedy wypędzicie przed sobą wszystkich mieszkańców tej ziemi i zniszczycie wszystkie ich obrazy i wszystkie ich odlane posągi i spustoszycie wszystkie ich wyżyny. ");
INSERT INTO polubg_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","A wypędziwszy mieszkańców ziemi, zamieszkacie w niej, gdyż dałem wam tę ziemię w posiadanie. ");
INSERT INTO polubg_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","I rozdzielicie tę ziemię przez losowanie jako dziedzictwo, według waszych rodzin. Liczniejszemu dacie większe dziedzictwo, a mniej licznemu dacie mniejsze dziedzictwo. Gdzie komu los przypadnie, to będzie jego; otrzymacie dziedzictwo według pokolenia waszych ojców. ");
INSERT INTO polubg_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Jeśli jednak nie wypędzicie przed sobą mieszkańców tej ziemi, wtedy ci, których z nich pozostawicie, będą jak ciernie w waszych oczach i jak kolce dla waszych boków i będą was gnębić w tej ziemi, w której będziecie mieszkać. ");
INSERT INTO polubg_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Wtedy uczynię wam to, co zamierzałem uczynić im. ");
INSERT INTO polubg_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Rozkaż synom Izraela i powiedz im: Gdy wejdziecie do ziemi Kanaan, to jest ziemia, która wam przypadnie jako dziedzictwo, ziemia Kanaan w swoich granicach; ");
INSERT INTO polubg_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Wasza południowa granica będzie od pustyni Syn wzdłuż granic Edomu, a granica południowa pobiegnie od brzegu Morza Słonego, od wschodu. ");
INSERT INTO polubg_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Granica ta skręci od południa ku Maale-Akrabbim i pobiegnie aż do Syn, i dojdzie od południa do Kadesz-Barnea. Stamtąd pobiegnie do Chasar-Addar i przejdzie aż do Asmon. ");
INSERT INTO polubg_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","A ta granica skręci od Asmon aż do rzeki Egiptu, a skończy się przy morzu. ");
INSERT INTO polubg_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Jako zachodnią granicę będziecie mieli Morze Wielkie – ono będzie waszą zachodnią granicą. ");
INSERT INTO polubg_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","A to będzie wasza północna granica: od Morza Wielkiego wymierzycie sobie do góry Hor. ");
INSERT INTO polubg_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Potem od góry Hor wymierzycie granicę aż do wejścia do Hemat; a krańce tej granicy sięgną do Sedada. ");
INSERT INTO polubg_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Następnie granica ta pobiegnie aż do Zifronu, a skończy się w Chasar-Enan. To będzie wasza północna granica. ");
INSERT INTO polubg_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","A wschodnią granicę wymierzycie od Chasar-Enan do Szefam. ");
INSERT INTO polubg_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Granica ta pobiegnie od Szefam aż do Ribla, od wschodu Ain; i ta granica zejdzie w dół, i dosięgnie brzegu morza Kinneret od wschodu. ");
INSERT INTO polubg_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Następnie ta granica zejdzie ku Jordanowi, a zakończy się przy Morzu Słonym. To będzie wasza ziemia ze swymi granicami wokoło. ");
INSERT INTO polubg_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Wtedy Mojżesz rozkazał synom Izraela: To jest ziemia, którą odziedziczycie przez losowanie, którą PAN rozkazał dać dziewięciu i pół pokoleniu. ");
INSERT INTO polubg_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Bo pokolenie synów Rubena według domów swych ojców i pokolenie synów Gada według domów swych ojców już otrzymały swoje dziedzictwo i połowa pokolenia Manassesa już otrzymała swoje dziedzictwo. ");
INSERT INTO polubg_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Te dwa i pół pokolenia otrzymały swoje dziedzictwo po tej stronie Jordanu, naprzeciw Jerycha, na wschodzie. ");
INSERT INTO polubg_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","I PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Oto imiona mężczyzn, którzy rozdzielą wam ziemię: kapłan Eleazar i Jozue, syn Nuna. ");
INSERT INTO polubg_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Weźmiecie też po jednym naczelniku z każdego pokolenia do rozdzielenia ziemi w dziedzictwo. ");
INSERT INTO polubg_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","A oto imiona tych mężczyzn: z pokolenia Judy – Kaleb, syn Jefunnego. ");
INSERT INTO polubg_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Z pokolenia synów Symeona – Samuel, syn Ammihuda. ");
INSERT INTO polubg_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Z pokolenia Beniamina – Eliad, syn Kislona. ");
INSERT INTO polubg_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Z pokolenia synów Dana – naczelnik Bukki, syn Jogliego. ");
INSERT INTO polubg_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Z synów Józefa, z pokolenia synów Manassesa – naczelnik Channiel, syn Efoda; ");
INSERT INTO polubg_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","A z pokolenia synów Efraima – naczelnik Kemuel, syn Sziftana. ");
INSERT INTO polubg_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Z pokolenia Zebulona – naczelnik Elisafan, syn Parnacha. ");
INSERT INTO polubg_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Z pokolenia synów Issachara – naczelnik Paltiel, syn Azzana. ");
INSERT INTO polubg_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Z pokolenia synów Aszera – naczelnik Achihud, syn Szelomiego. ");
INSERT INTO polubg_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","A z pokolenia synów Neftalego – naczelnik Pedahel, syn Ammihuda. ");
INSERT INTO polubg_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","To są ci, którym PAN rozkazał rozdzielić dziedzictwo synom Izraela w ziemi Kanaan. ");
INSERT INTO polubg_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","I PAN powiedział do Mojżesza na równinach Moabu, nad Jordanem, naprzeciw Jerycha: ");
INSERT INTO polubg_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Rozkaż synom Izraela, aby dali Lewitom ze swej dziedzicznej posiadłości miasta na zamieszkanie, dacie Lewitom też pastwiska dokoła ich miast. ");
INSERT INTO polubg_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Będą mieli miasta na mieszkanie, a ich pastwiska będą dla ich bydła, dla ich dobytku i dla wszystkich ich zwierząt. ");
INSERT INTO polubg_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Pastwiska miast, które dacie Lewitom, będą rozciągać się na tysiąc łokci wokół murów miasta. ");
INSERT INTO polubg_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Odmierzycie również poza miastem dwa tysiące łokci po stronie wschodniej, po stronie południowej też dwa tysiące łokci, także po stronie zachodniej dwa tysiące łokci i po stronie północnej dwa tysiące łokci, a miasto będzie w środku. To będą pastwiska ich miast. ");
INSERT INTO polubg_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","A spośród tych miast, które dacie Lewitom, sześć będzie miastami schronienia, które przekażecie, aby mógł tam uciec zabójca. Oprócz nich dacie im czterdzieści dwa miasta. ");
INSERT INTO polubg_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Wszystkich miast, które dacie Lewitom, będzie czterdzieści osiem wraz z ich pastwiskami. ");
INSERT INTO polubg_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","A miasta, które im dacie, będą pochodziły z posiadłości synów Izraela; od liczniejszego dacie więcej, a od mniej licznego dacie mniej; każdy da Lewitom ze swoich miast stosownie do otrzymanego dziedzictwa. ");
INSERT INTO polubg_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Potem PAN powiedział do Mojżesza: ");
INSERT INTO polubg_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Przemów do synów Izraela i powiedz im: Gdy przejdziecie przez Jordan do ziemi Kanaan; ");
INSERT INTO polubg_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","Wyznaczcie sobie miasta, które będą dla was miastami schronienia, aby mógł tam uciec zabójca, który zabił kogoś nieumyślnie. ");
INSERT INTO polubg_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Te miasta będą dla was miastami schronienia przed mścicielem, aby zabójca nie poniósł śmierci, zanim nie stanie przed zgromadzeniem na sąd. ");
INSERT INTO polubg_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","A z miast, które oddacie, sześć będzie dla was miastami schronienia. ");
INSERT INTO polubg_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Trzy miasta dacie z tej strony Jordanu, a trzy miasta dacie w ziemi Kanaan; będą one miastami schronienia. ");
INSERT INTO polubg_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Tych sześć miast będzie schronieniem dla synów Izraela, dla obcego i dla przybysza, który mieszka wśród was, aby mógł tam uciec każdy, kto by zabił człowieka nieumyślnie. ");
INSERT INTO polubg_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Jeśli jednak uderzy go przedmiotem żelaznym, tak że ten umrze, jest mordercą. Morderca poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Jeśli uderzy go kamieniem, który ma w ręce i którym można zabić, a ten umrze, jest mordercą. Morderca poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Albo jeśli uderzy go ręcznym przedmiotem drewnianym, którym można zabić, a ten umrze, jest mordercą. Morderca poniesie śmierć. ");
INSERT INTO polubg_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Mściciel krwi sam zabije tego mordercę. Gdziekolwiek go spotka, sam go zabije. ");
INSERT INTO polubg_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Jeśli z nienawiści popchnie go albo rzuci w niego czymś z zasadzki, a ten umrze; ");
INSERT INTO polubg_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","Albo jeśli z wrogości uderzy go ręką, a ten umrze, to ten, który uderzył, poniesie śmierć, bo jest mordercą. Mściciel krwi zabije mordercę, gdziekolwiek go spotka. ");
INSERT INTO polubg_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Lecz jeśli niespodziewanie i bez wrogości go popchnie albo rzuci w niego czymkolwiek bez zasadzki; ");
INSERT INTO polubg_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","Albo jeśli nie widząc, upuści na niego jakiś kamień, którym można zabić, a ten umrze, chociaż nie był jego wrogiem ani nie szukał jego krzywdy; ");
INSERT INTO polubg_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Wtedy zgromadzenie rozsądzi pomiędzy tym, który zabił, a między mścicielem krwi według tych praw. ");
INSERT INTO polubg_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","I zgromadzenie wybawi zabójcę z rąk mściciela krwi; zgromadzenie też przekaże go miastu schronienia, do którego uciekł. Tam będzie mieszkał aż do śmierci najwyższego kapłana, namaszczonego olejem świętym. ");
INSERT INTO polubg_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Lecz jeśli zabójca wyjdzie poza granice swojego miasta schronienia, do którego uciekł; ");
INSERT INTO polubg_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","I mściciel trafi tam na niego poza granicą jego miasta schronienia, i zabije zabójcę, to nie będzie winien krwi. ");
INSERT INTO polubg_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Ten bowiem ma mieszkać w swoim mieście schronienia aż do śmierci najwyższego kapłana. Lecz po śmierci najwyższego kapłana zabójca może wrócić do ziemi swojej posiadłości. ");
INSERT INTO polubg_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","To będzie dla was ustawa prawna przez wszystkie wasze pokolenia, we wszystkich waszych domach. ");
INSERT INTO polubg_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Ktokolwiek zabije człowieka, to na podstawie zeznania świadków zostanie zabity zabójca. Lecz jeden świadek nie może świadczyć przeciwko komuś, by skazać go na śmierć. ");
INSERT INTO polubg_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Nie weźmiecie też okupu za życie zabójcy, który zasługuje na śmierć. Musi ponieść śmierć. ");
INSERT INTO polubg_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Nie weźmiecie też okupu od tego, który uciekł do swojego miasta schronienia, aby mógł wrócić i zamieszkać w swojej ziemi, zanim umrze kapłan; ");
INSERT INTO polubg_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Abyście nie bezcześcili ziemi, w której będziecie, gdyż krew bezcześci ziemię; a ziemia nie może być inaczej oczyszczona od przelanej w niej krwi jak tylko krwią tego, który ją przelał. ");
INSERT INTO polubg_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Nie zanieczyszczajcie więc ziemi, w której mieszkacie, w której przebywam też ja. Ja bowiem jestem PAN, który przebywa wśród synów Izraela. ");
INSERT INTO polubg_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Wtedy przystąpili naczelnicy spośród ojców synów Gileada, syna Makira, syna Manassesa, z domów Józefa, i mówili przed Mojżeszem i przed książętami, naczelnikami ojców synów Izraela: ");
INSERT INTO polubg_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","PAN nakazał memu panu rozdzielić ziemię w dziedzictwo synom Izraela przez losowanie; mojemu panu rozkazano też przez PANA dać dziedzictwo naszego brata Selofchada jego córkom. ");
INSERT INTO polubg_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Jeśli więc któryś z synów innego pokolenia synów Izraela pojmie je za żony, to ich dziedzictwo zostanie odjęte od dziedzictwa naszych ojców i przyłączone do dziedzictwa pokolenia, do którego będą należeć; w ten sposób nasze dziedzictwo się zmniejszy. ");
INSERT INTO polubg_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","A gdy nadejdzie rok jubileuszowy dla synów Izraela, wtedy ich dziedzictwo zostanie przyłączone do dziedzictwa pokolenia, do którego będą należeć; i tak ich dziedzictwo zostanie odjęte od dziedzictwa pokolenia naszych ojców. ");
INSERT INTO polubg_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Wtedy Mojżesz rozkazał synom Izraela zgodnie ze słowem PANA: Słusznie mówi pokolenie synów Józefa. ");
INSERT INTO polubg_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Oto co PAN rozkazał w sprawie córek Selofchada: Niech wychodzą za mąż, za kogo chcą, ale mogą wyjść tylko za kogoś z domu pokolenia swoich ojców; ");
INSERT INTO polubg_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Aby dziedzictwo synów Izraela nie było przenoszone z jednego pokolenia na drugie pokolenie. Każdy bowiem z synów Izraela ma pozostać przy dziedzictwie pokolenia swoich ojców. ");
INSERT INTO polubg_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","I każda córka, która posiada dziedzictwo w jakimś pokoleniu synów Izraela, wyjdzie za mąż za kogoś z domu pokolenia swego ojca, aby synowie Izraela dziedziczyli, każdy dziedzictwo swoich ojców. ");
INSERT INTO polubg_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Dziedzictwo bowiem nie będzie przenoszone z jednego pokolenia na drugie pokolenie, lecz każde z pokoleń synów Izraela ma pozostać przy swoim dziedzictwie. ");
INSERT INTO polubg_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Jak PAN rozkazał Mojżeszowi, tak uczyniły córki Selofchada. ");
INSERT INTO polubg_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Bo Machla, Tirsa, Chogla, Milka i Noa, córki Selofchada, wyszły za mąż za synów swoich stryjów. ");
INSERT INTO polubg_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Wyszły za mąż w rodzinach synów Manassesa, syna Józefa; w ten sposób ich dziedzictwo pozostało przy pokoleniu domu ich ojca. ");
INSERT INTO polubg_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","To są przykazania i prawa, które PAN nakazał synom Izraela przez Mojżesza na równinach Moabu, nad Jordanem, naprzeciw Jerycha. ");
INSERT INTO polubg_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Oto słowa, które Mojżesz wypowiedział do całego Izraela po tej stronie Jordanu na pustyni, na równinie, naprzeciw Morza Czerwonego, pomiędzy Faran, Tofel, Laban, Chaserot a Dizahab. ");
INSERT INTO polubg_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","A jedenaście dni drogi jest od Horebu przez górę Seir do Kadesz-Barnea. ");
INSERT INTO polubg_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","W czterdziestym roku, jedenastego miesiąca, pierwszego dnia tego miesiąca, Mojżesz powiedział synom Izraela to wszystko, co PAN mu dla nich rozkazał. ");
INSERT INTO polubg_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Gdy pobił Sichona, króla Amorytów, który mieszkał w Cheszbonie, i Oga, króla Baszanu, który mieszkał w Asztarot w Edrei; ");
INSERT INTO polubg_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Po tej stronie Jordanu, w ziemi Moabu, Mojżesz zaczął objaśniać to prawo: ");
INSERT INTO polubg_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","PAN, nasz Bóg, przemówił do nas na Horebie: Dość długo przebywacie na tej górze. ");
INSERT INTO polubg_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Zawróćcie i wyruszcie, a idźcie w stronę góry Amorytów oraz do wszystkich miejsc leżących w jej pobliżu, na równinie, w górach i w dolinie, na południu i na wybrzeżu morza, do ziemi Kanaan i do Libanu, aż do wielkiej rzeki, rzeki Eufrat. ");
INSERT INTO polubg_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Oto położyłem przed wami tę ziemię. Wejdźcie do niej i weźcie w posiadanie tę ziemię, którą PAN przysiągł dać waszym ojcom: Abrahamowi, Izaakowi i Jakubowi oraz ich potomstwu po nich. ");
INSERT INTO polubg_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","I powiedziałem wam w tamtym czasie: Nie mogę już sam was nosić. ");
INSERT INTO polubg_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","PAN, wasz Bóg, rozmnożył was, a oto jesteście dziś tak liczni jak gwiazdy na niebie. ");
INSERT INTO polubg_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Niech PAN, Bóg waszych ojców, rozmnoży was jeszcze tysiąckroć i błogosławi wam, tak jak wam obiecał. ");
INSERT INTO polubg_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Jak mogę sam znosić troskę o was, wasz ciężar i wasze spory? ");
INSERT INTO polubg_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Wybierzcie spośród siebie mężczyzn mądrych, rozumnych i doświadczonych w waszych pokoleniach, a ja ustanowię ich waszymi przywódcami. ");
INSERT INTO polubg_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Wtedy odpowiedzieliście mi: Dobra to rzecz, którą nakazałeś uczynić. ");
INSERT INTO polubg_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","I wybrałem naczelników z waszych pokoleń, mężczyzn mądrych i doświadczonych, i ustanowiłem ich waszymi zwierzchnikami: przełożonymi nad tysiącami, nad setkami, nad pięćdziesięcioma i nad dziesięcioma oraz urzędnikami dla waszych pokoleń. ");
INSERT INTO polubg_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","I rozkazałem waszym sędziom w tym czasie: Wysłuchujcie spraw między waszymi braćmi i sądźcie sprawiedliwie pomiędzy każdym mężczyzną a jego bratem czy obcym. ");
INSERT INTO polubg_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Nie miejcie względu na osoby w sądzie; wysłuchujcie zarówno małego, jak i wielkiego. Nie bójcie się nikogo, ponieważ jest to sąd Boga. Jeśli sprawa będzie dla was zbyt trudna, przedstawcie ją mnie i ja jej wysłucham. ");
INSERT INTO polubg_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","I przykazałem wam w tamtym czasie wszystko, co macie czynić. ");
INSERT INTO polubg_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Potem wyruszyliśmy z Horebu i przeszliśmy przez całą tę wielką i straszną pustynię, którą widzieliście po drodze do góry Amorytów, jak nakazał nam PAN, nasz Bóg, i przyszliśmy aż do Kadesz-Barnea. ");
INSERT INTO polubg_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","I powiedziałem do was: Przyszliście do góry Amorytów, którą daje nam PAN, nasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Oto PAN, twój Bóg, położył przed tobą tę ziemię. Idź i weź ją w posiadanie, jak ci powiedział PAN, Bóg twoich ojców; nie bój się i nie lękaj się. ");
INSERT INTO polubg_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","I przyszliście do mnie wszyscy, i tak powiedzieliście: Wyślijmy mężczyzn przed sobą, aby wyszpiegowali nam tę ziemię i zdali nam sprawę o drodze, którą mamy iść, i o miastach, do których mamy wejść. ");
INSERT INTO polubg_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","To mi się spodobało, więc wybrałem spośród was dwunastu mężczyzn, po jednym z każdego pokolenia. ");
INSERT INTO polubg_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Oni zaś wyruszyli i weszli na górę, potem dotarli do doliny Eszkol i przebadali ziemię. ");
INSERT INTO polubg_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Zabrali też ze sobą owoc tej ziemi i przynieśli do nas, i zdając nam o tym sprawę, powiedzieli: Ziemia, którą daje nam PAN, nasz Bóg, jest dobra. ");
INSERT INTO polubg_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Lecz nie chcieliście iść i buntowaliście się przeciw nakazowi PANA, swojego Boga. ");
INSERT INTO polubg_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","I szemraliście w swoich namiotach, mówiąc: Z nienawiści do nas PAN wyprowadził nas z ziemi Egiptu, aby nas wydać w ręce Amorytów na naszą zgubę. ");
INSERT INTO polubg_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Dokąd pójdziemy? Nasi bracia napełnili nasze serca strachem, gdy mówili: Ten lud jest wyższy i roślejszy od nas, miasta są wielkie i obwarowane aż do nieba, a ponadto widzieliśmy tam synów Anakitów. ");
INSERT INTO polubg_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Wtedy mówiłem do was: Nie lękajcie się ani nie bójcie się ich. ");
INSERT INTO polubg_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","PAN, wasz Bóg, który idzie przed wami, będzie walczyć za was, tak jak wam uczynił w Egipcie na waszych oczach; ");
INSERT INTO polubg_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","I na pustyni, gdzie widziałeś, jak PAN, twój Bóg, nosił cię tak, jak ojciec nosi swego syna, przez całą drogę, którą szliście, aż przybyliście na to miejsce. ");
INSERT INTO polubg_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Lecz mimo to nie uwierzyliście PANU, swojemu Bogu; ");
INSERT INTO polubg_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","Który szedł przed wami w drodze, wypatrując dla was miejsca do rozbicia obozu, nocą w ogniu, aby wskazać wam drogę, którą macie iść, we dnie zaś w obłoku. ");
INSERT INTO polubg_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","A PAN usłyszał głos waszych słów i bardzo się rozgniewał, i przysiągł tymi słowy: ");
INSERT INTO polubg_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","Żaden człowiek z tego złego pokolenia nie zobaczy tej dobrej ziemi, którą przysiągłem dać waszym ojcom; ");
INSERT INTO polubg_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Oprócz Kaleba, syna Jefunnego; on ją zobaczy i jemu dam ziemię, którą stąpał, a także jego synom, gdyż chodził całkowicie za PANEM. ");
INSERT INTO polubg_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Także na mnie rozgniewał się PAN z waszego powodu, mówiąc: Ty również tam nie wejdziesz. ");
INSERT INTO polubg_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Jozue, syn Nuna, który ci służy, on tam wejdzie. Umacniaj go, gdyż on ją poda w dziedzictwo Izraelowi. ");
INSERT INTO polubg_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Także wasze dzieci, o których mówiliście, że staną się łupem, i wasi synowie, którzy w tym dniu nie odróżniali dobra od zła, oni tam wejdą i im ją oddam, a oni ją wezmą w posiadanie; ");
INSERT INTO polubg_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","A wy zawróćcie i idźcie na pustynię drogą ku Morzu Czerwonemu. ");
INSERT INTO polubg_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Wtedy odpowiedzieliście mi: Zgrzeszyliśmy przeciwko PANU, pójdziemy i będziemy walczyć zgodnie z tym wszystkim, co nakazał nam PAN, nasz Bóg. I każdy z was przypasał sobie broń wojenną i chcieliście wejść na górę. ");
INSERT INTO polubg_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","I PAN powiedział do mnie: Powiedz im: Nie wstępujcie ani nie walczcie, gdyż nie ma mnie wśród was, abyście nie byli pobici przez swoich wrogów. ");
INSERT INTO polubg_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Powiedziałem wam o tym, lecz nie słuchaliście, ale zbuntowaliście się przeciw nakazowi PANA i uparliście się, i weszliście na górę. ");
INSERT INTO polubg_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Wtedy Amoryci, którzy mieszkali na tej górze, wystąpili przeciwko wam i ścigali was, jak to czynią pszczoły, i pobili was w Seirze aż do Chorma. ");
INSERT INTO polubg_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Potem wróciliście i płakaliście przed PANEM; lecz PAN nie wysłuchał waszego głosu i nie nakłonił ku wam swego ucha. ");
INSERT INTO polubg_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","I mieszkaliście w Kadesz przez wiele dni, według liczby dni, ile tam mieszkaliście. ");
INSERT INTO polubg_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Potem zawróciliśmy i wyruszyliśmy na pustynię, drogą w kierunku Morza Czerwonego, tak jak mi PAN powiedział, i przez wiele dni krążyliśmy dokoła góry Seir. ");
INSERT INTO polubg_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","I PAN powiedział do mnie: ");
INSERT INTO polubg_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","Dosyć krążyliście dokoła tej góry. Skierujcie się na północ; ");
INSERT INTO polubg_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","I rozkaż ludowi: Będziecie przechodzić przez granicę waszych braci, synów Ezawa, którzy mieszkają w Seirze. Oni będą się was bać, lecz wy strzeżcie się bardzo. ");
INSERT INTO polubg_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Nie prowokujcie ich, gdyż nie dam wam ich ziemi nawet na szerokość stopy, bo Ezawowi dałem w posiadanie górę Seir. ");
INSERT INTO polubg_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Żywność będziecie kupowali od nich za pieniądze, abyście mieli co jeść; także wodę od nich będziecie kupować za pieniądze, abyście mieli co pić. ");
INSERT INTO polubg_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Gdyż PAN, twój Bóg, błogosławił cię w każdym dziele twoich rąk i znał twoją drogę na tej wielkiej pustyni. Już przez czterdzieści lat PAN, twój Bóg, był z tobą, a niczego ci nie brakowało. ");
INSERT INTO polubg_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Ominęliśmy więc naszych braci, synów Ezawa, mieszkających w Seirze, drogą równinną od Elat i od Esjon-Geber, po czym skręciliśmy i udaliśmy się w stronę pustyni Moabu. ");
INSERT INTO polubg_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","I PAN powiedział do mnie: Nie napadaj na Moabitów ani nie rozniecaj z nimi wojny, bo nie dam ci ich ziemi w posiadanie; Ar bowiem dałem w posiadanie synom Lota. ");
INSERT INTO polubg_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Poprzednio mieszkali w niej Emici, lud potężny, liczny i wysoki jak Anakici; ");
INSERT INTO polubg_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Uważano ich też za olbrzymów jak Anakitów, lecz Moabici nazywają ich Emitami. ");
INSERT INTO polubg_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Przedtem w Seirze mieszkali również Choryci, ale synowie Ezawa wypędzili ich i wyniszczyli przed sobą, po czym zamieszkali na ich miejscu, jak uczynił Izrael w ziemi swego posiadania, którą dał im PAN. ");
INSERT INTO polubg_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Wstańcie więc i przeprawcie się przez potok Zered. I przeprawiliśmy się przez potok Zered. ");
INSERT INTO polubg_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","A czas, który upłynął od naszego wyjścia z Kadesz-Barnea aż do przeprawienia się przez potok Zered, wynosił trzydzieści osiem lat, aż wyginęło z obozu całe pokolenie wojowników, tak jak im to PAN poprzysiągł. ");
INSERT INTO polubg_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Ręka PANA bowiem zaciążyła nad nimi, aby wyniszczyć ich z obozu, aż wyginęli. ");
INSERT INTO polubg_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","A gdy wszyscy wojownicy spośród ludu wyginęli i umarli; ");
INSERT INTO polubg_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","PAN przemówił do mnie: ");
INSERT INTO polubg_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Dziś przejdziesz przez Ar, granicę Moabu; ");
INSERT INTO polubg_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","I zbliżysz się do synów Ammona; nie napadaj na nich i nie rozniecaj z nimi wojny, bo nie dam ci w posiadanie ziemi synów Ammona, dałem ją bowiem w posiadanie synom Lota. ");
INSERT INTO polubg_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Także i tę ziemię uważano za ziemię olbrzymów. Olbrzymi mieszkali w niej wcześniej, a Ammonici nazywają ich Zamzummitami; ");
INSERT INTO polubg_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Lud potężny, liczny i wysoki jak Anakici; lecz PAN wygubił ich przed nimi, a Ammonici ich wypędzili i zamieszkali na ich miejscu; ");
INSERT INTO polubg_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Podobnie jak uczynił synom Ezawa mieszkającym w Seirze, przed którymi wytracił Chorytów; i wypędzili ich, i zamieszkali na ich miejscu aż do dziś. ");
INSERT INTO polubg_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Także Awwitów, którzy mieszkali w Chazerim aż do Gazy, wytracili Kaftoryci, którzy wyszli z Kaftor, i zamieszkali na ich miejscu). ");
INSERT INTO polubg_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Wstańcie więc, wyruszcie i przeprawcie się przez rzekę Arnon. Oto daję w twoje ręce Sichona, króla Cheszbonu, Amorytę, oraz jego ziemię. Zacznij ją zajmować i rozpocznij z nim wojnę. ");
INSERT INTO polubg_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Od dziś zacznę wzbudzać strach i lęk przed tobą wśród narodów, które są pod całym niebem; kiedy usłyszą wieść o tobie, będą drżeć i będą się ciebie lękać. ");
INSERT INTO polubg_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Wysłałem więc posłańców z pustyni Kedemot do Sichona, króla Cheszbonu, ze słowami pokoju: ");
INSERT INTO polubg_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Pozwól mi przejść przez twoją ziemię. Pójdę tylko drogą, nie zboczę ani na prawo, ani na lewo. ");
INSERT INTO polubg_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Sprzedasz mi za pieniądze żywność, abym mógł się pożywić; wody także za pieniądze mi dasz, abym pił. Tylko przejdę pieszo; ");
INSERT INTO polubg_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Jak mi to uczynili synowie Ezawa, którzy mieszkają w Seirze, i Moabici, którzy mieszkają w Ar, aż się przeprawię przez Jordan, do ziemi, którą daje nam PAN, nasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Lecz Sichon, król Cheszbonu, nie pozwolił nam przejść przez swoją ziemię, gdyż PAN, twój Bóg, zatwardził jego ducha i uczynił jego serce uparte, aby go wydać w twoje ręce, jak to dzisiaj widzisz. ");
INSERT INTO polubg_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Wtedy PAN powiedział do mnie: Oto zacząłem już wydawać ci Sichona i jego ziemię. Zacznij ją zajmować, abyś odziedziczył jego ziemię. ");
INSERT INTO polubg_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Wtedy Sichon wyruszył przeciwko nam, on i cały jego lud, aby zmierzyć się z nami w bitwie w Jahaz; ");
INSERT INTO polubg_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Lecz PAN, nasz Bóg, wydał go nam i pobiliśmy go, jego synów i cały jego lud. ");
INSERT INTO polubg_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","I zdobyliśmy w tym czasie wszystkie jego miasta, i zniszczyliśmy doszczętnie we wszystkich miastach mężczyzn, kobiety i dzieci; nie pozostawiliśmy spośród nich nikogo. ");
INSERT INTO polubg_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Tylko bydło zagarnęliśmy dla siebie i łupy z miast, które zdobyliśmy. ");
INSERT INTO polubg_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Od Aroeru, leżącego nad brzegiem rzeki Arnon, i od miasta położonego w dolinie aż do Gileadu nie było miasta nie do zdobycia; wszystkie wydał nam PAN, nasz Bóg. ");
INSERT INTO polubg_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Tylko do ziemi synów Ammona nie zbliżyłeś się, do żadnego miejsca na brzegu rzeki Jabbok ani do miast w górach, ani do żadnych miejsc, których PAN, nasz Bóg, nam zabronił. ");
INSERT INTO polubg_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Potem zawróciliśmy i poszliśmy drogą w kierunku Baszanu. I wyszedł nam naprzeciw Og, król Baszanu – on i cały jego lud – by stoczyć z nami bitwę w Edrei. ");
INSERT INTO polubg_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Wtedy PAN powiedział do mnie: Nie bój się go, gdyż wydałem go w twoje ręce wraz z całym jego ludem i ziemią; uczynisz mu, jak uczyniłeś Sichonowi, królowi Amorytów, który mieszkał w Cheszbonie. ");
INSERT INTO polubg_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","PAN, nasz Bóg, wydał więc w nasze ręce również Oga, króla Baszanu, i cały jego lud. Pobiliśmy go tak, że nikt po nim nie pozostał. ");
INSERT INTO polubg_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Zdobyliśmy w tym czasie wszystkie jego miasta; nie było miasta, którego im nie zabraliśmy: sześćdziesiąt miast, całą krainę Argob, królestwo Oga w Baszanie. ");
INSERT INTO polubg_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Wszystkie te miasta były obwarowane wysokimi murami, bramami i ryglami, a oprócz tego było bardzo wiele nieobwarowanych miasteczek. ");
INSERT INTO polubg_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","I spustoszyliśmy je, jak uczyniliśmy Sichonowi, królowi Cheszbonu, zniszczyliśmy we wszystkich miastach mężczyzn, kobiety i dzieci. ");
INSERT INTO polubg_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Lecz całe bydło i łupy z miast zgarnęliśmy dla siebie. ");
INSERT INTO polubg_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","W tym czasie wzięliśmy również z ręki dwóch królów Amorytów ziemię, która leży po tej stronie Jordanu, od rzeki Arnon aż do góry Hermon; ");
INSERT INTO polubg_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Sydończycy nazywają Hermon Sirionem, a Amoryci – Sanirem). ");
INSERT INTO polubg_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Wszystkie miasta na równinie i cały Gilead oraz cały Baszan aż do Salka i Edrei, miasta królestwa Oga w Baszanie. ");
INSERT INTO polubg_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Gdyż tylko sam Og, król Baszanu, pozostał z olbrzymów; a jego łoże, łoże żelazne, czy nie znajduje się w Rabbie synów Ammona? Długie na dziewięć łokci, a szerokie na cztery łokcie, według łokcia męskiego. ");
INSERT INTO polubg_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","A ziemię, którą wzięliśmy w posiadanie w tym czasie od Aroeru, który leży nad rzeką Arnon, i połowę góry Gilead oraz jej miasta dałem Rubenitom i Gadytom. ");
INSERT INTO polubg_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","A resztę Gileadu i cały Baszan, królestwa Oga, dałem połowie pokolenia Manassesa: całą krainę Argob i cały Baszan nazwano ziemią olbrzymów. ");
INSERT INTO polubg_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jair, syn Manassesa, posiadł całą krainę Argob aż do granicy Geszurytów i Machaty i nazwał ją od swego imienia Baszan-Chawot-Jair; nazywa się tak aż do dziś. ");
INSERT INTO polubg_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Makirowi zaś dałem Gilead. ");
INSERT INTO polubg_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","A Rubenitom i Gadytom dałem krainę od Gileadu aż do rzeki Arnon, ze środkiem rzeki jako granicą, aż do rzeki Jabbok, która jest granicą synów Ammona; ");
INSERT INTO polubg_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Do tego równinę i Jordan z granicą od Kinneret aż do Morza Równinnego, czyli Morza Słonego, pod górą Pizga na wschodzie. ");
INSERT INTO polubg_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","W tym czasie rozkazałem wam: PAN, wasz Bóg, dał wam tę ziemię w posiadanie. Pójdziecie uzbrojeni przed waszymi braćmi, synami Izraela, wszyscy wojownicy. ");
INSERT INTO polubg_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Tylko wasze żony i dzieci oraz wasze bydło (gdyż wiem, że macie wiele stad) zostaną w waszych miastach, które wam dałem. ");
INSERT INTO polubg_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Aż PAN da odpoczynek waszym braciom, jak również wam, i aż oni posiądą ziemię, którą PAN, wasz Bóg, dał im za Jordanem. Wtedy każdy wróci do swojej posiadłości, którą wam dałem. ");
INSERT INTO polubg_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","W tym czasie przykazałem też Jozuemu: Twoje oczy widziały wszystko, co PAN, wasz Bóg, uczynił tym dwom królom. Tak samo uczyni PAN wszystkim królestwom, do których pójdziesz. ");
INSERT INTO polubg_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Nie bójcie się ich, ponieważ sam PAN, wasz Bóg, walczy za was. ");
INSERT INTO polubg_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","I prosiłem PANA w tym czasie: ");
INSERT INTO polubg_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","Panie BOŻE, ty zacząłeś okazywać twemu słudze swoją wielkość i swoją potężną rękę; któryż bóg na niebie albo na ziemi potrafi czynić takie potężne dzieła jak ty? ");
INSERT INTO polubg_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Pozwól mi, proszę, przejść i zobaczyć tę dobrą ziemię, która jest za Jordanem, tę dobrą górę i Liban. ");
INSERT INTO polubg_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Lecz PAN rozgniewał się na mnie z waszego powodu i nie wysłuchał mnie. I PAN powiedział do mnie: Dosyć, nie mów już do mnie w tej sprawie. ");
INSERT INTO polubg_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Wejdź na szczyt góry Pizga i podnieś oczy na zachód, na północ, na południe i na wschód, i przypatrz się temu własnymi oczami, gdyż nie przejdziesz tego Jordanu; ");
INSERT INTO polubg_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Ale rozkaż Jozuemu, zachęć go i wzmocnij, gdyż on pójdzie przed tym ludem i on da mu w dziedzictwo ziemię, którą zobaczysz. ");
INSERT INTO polubg_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Mieszkaliśmy więc w dolinie naprzeciw Bet-Peor. ");
INSERT INTO polubg_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Teraz więc, o Izraelu, słuchaj nakazów i praw, których uczę was wypełniać, abyście żyli i weszli, i posiedli ziemię, którą daje wam PAN, Bóg waszych ojców. ");
INSERT INTO polubg_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Nie dodawajcie do słowa, które ja wam nakazuję, ani z niego nie ujmujcie, abyście przestrzegali przykazań PANA, waszego Boga, które ja wam nakazuję. ");
INSERT INTO polubg_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Wasze oczy widziały, co PAN uczynił z powodu Baal-Peora, jak każdego człowieka, który poszedł za Baal-Peorem, PAN, twój Bóg, wytracił spośród was. ");
INSERT INTO polubg_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","A wy, którzy przylgnęliście do PANA, swojego Boga, żyjecie wszyscy aż do dziś. ");
INSERT INTO polubg_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Spójrzcie, nauczyłem was nakazów i praw, jak mi nakazał PAN, mój Bóg, abyście tak czynili w tej ziemi, do której wchodzicie, aby ją wziąć w posiadanie. ");
INSERT INTO polubg_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Przestrzegajcie ich więc i wypełniajcie je; to bowiem jest wasza mądrość i wasz rozum w oczach narodów, które usłyszą o wszystkich tych nakazach i powiedzą: Zaprawdę, ten wielki naród jest mądrym i rozumnym ludem. ");
INSERT INTO polubg_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Który bowiem naród jest tak wielki, by mieć bogów tak bliskich jak PAN, nasz Bóg, we wszystkim, ilekroć go wzywamy? ");
INSERT INTO polubg_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Albo który naród jest tak wielki, by mieć nakazy i prawa tak sprawiedliwe jak całe to prawo, które dziś wam przedkładam? ");
INSERT INTO polubg_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Tylko miej się na baczności i strzeż swej duszy pilnie, abyś nie zapomniał o tych rzeczach, które twoje oczy widziały, i aby nie odstępowały one od twego serca po wszystkie dni twego życia. Ale ucz ich swoich synów i synów swoich synów. ");
INSERT INTO polubg_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Nie zapominaj o dniu, w którym stałeś przed PANEM, swoim Bogiem, na Horebie, gdy PAN powiedział do mnie: Zgromadź mi lud, abym im przekazał swoje słowa, aby nauczyli się mnie bać przez wszystkie dni swego życia na ziemi i żeby uczyli tego swoich synów. ");
INSERT INTO polubg_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Wtedy zbliżyliście się i stanęliście pod górą, a góra płonęła ogniem aż po samo niebo, okryta ciemnością, obłokiem i mrokiem. ");
INSERT INTO polubg_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","I PAN przemówił do was spośród ognia. Usłyszeliście dźwięk słów, lecz nie widzieliście żadnej postaci, tylko głos usłyszeliście. ");
INSERT INTO polubg_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Wówczas oznajmił wam swoje przymierze, które nakazał wam wypełniać, dziesięć przykazań, które napisał na dwóch kamiennych tablicach. ");
INSERT INTO polubg_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","W tym czasie PAN rozkazał mi nauczać was nakazów i praw, abyście je wypełniali w ziemi, do której idziecie, aby ją wziąć w posiadanie. ");
INSERT INTO polubg_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Strzeżcie więc pilnie swoich dusz, gdyż nie widzieliście żadnej postaci w dniu, w którym PAN przemówił do was na Horebie spośród ognia; ");
INSERT INTO polubg_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Abyście się nie zepsuli i nie czynili sobie rzeźbionego posągu, podobizny wszelkiej postaci w kształcie mężczyzny lub kobiety; ");
INSERT INTO polubg_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","W kształcie jakiegokolwiek zwierzęcia, które jest na ziemi, w kształcie wszelkiego ptaka skrzydlatego, który lata w powietrzu; ");
INSERT INTO polubg_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","W kształcie czegokolwiek, co pełza po ziemi, w kształcie wszelkiej ryby, która jest w wodach pod ziemią. ");
INSERT INTO polubg_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","I abyś – gdy podniesiesz swoje oczy ku niebu i ujrzysz słońce, księżyc i gwiazdy, cały zastęp niebios – nie dał się zwieść, by oddać im pokłon i im służyć, ponieważ PAN, twój Bóg, przydzielił je wszystkim ludom pod całym niebem. ");
INSERT INTO polubg_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Lecz PAN was wziął i wyprowadził z pieca do topienia żelaza, z Egiptu, abyście byli jego ludem, jego dziedzictwem, jak dziś jesteście. ");
INSERT INTO polubg_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","I PAN rozgniewał się na mnie z waszego powodu, i przysiągł, że nie przejdę Jordanu i nie wejdę do tej dobrej ziemi, którą PAN, twój Bóg, daje tobie w dziedzictwo. ");
INSERT INTO polubg_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Ja bowiem umrę w tej ziemi, nie przejdę Jordanu. Wy zaś przejdziecie i posiądziecie tę dobrą ziemię. ");
INSERT INTO polubg_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Strzeżcie się, abyście nie zapomnieli o przymierzu PANA, swojego Boga, które z wami zawarł, i nie czynili sobie żadnego rzeźbionego posągu lub podobizny czegokolwiek, czego ci zakazał PAN, twój Bóg. ");
INSERT INTO polubg_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Bo PAN, twój Bóg, jest ogniem trawiącym, Bogiem zazdrosnym. ");
INSERT INTO polubg_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Gdy urodzisz synów i wnuki i zestarzejecie się w tej ziemi, jeśli popsujecie się i uczynicie sobie rzeźbiony posąg lub podobiznę czegokolwiek, i dopuścicie się zła w oczach PANA, swojego Boga, pobudzając go do gniewu; ");
INSERT INTO polubg_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","To biorę dziś na świadków przeciwko wam niebo i ziemię, że prędko wyginiecie doszczętnie z ziemi, do której przejdziecie przez Jordan, aby ją posiąść; nie przedłużycie w niej swych dni, bo zostaniecie całkowicie wytępieni. ");
INSERT INTO polubg_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","PAN rozproszy was między narodami i mało z was zostanie pośród narodów, do których PAN was zaprowadzi. ");
INSERT INTO polubg_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Tam będziecie służyli bogom, dziełom ludzkich rąk, drewnu i kamieniowi, które nie widzą ani nie słyszą, nie jedzą ani nie wąchają. ");
INSERT INTO polubg_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Jeśli jednak stamtąd będziesz szukać PANA, swego Boga, wtedy znajdziesz go, jeśli będziesz go szukał całym swym sercem i całą swą duszą. ");
INSERT INTO polubg_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Gdy znajdziesz się w ucisku i spotka cię to wszystko w ostatnich dniach, jeśli wtedy zawrócisz do PANA, swego Boga, i będziesz słuchał jego głosu; ");
INSERT INTO polubg_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Ponieważ PAN, twój Bóg, jest miłosiernym Bogiem, nie opuści cię ani cię nie zniszczy, ani nie zapomni o przymierzu z twoimi ojcami, które im poprzysiągł. ");
INSERT INTO polubg_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Zapytaj się bowiem dawnych czasów, które były przed tobą od dnia, kiedy Bóg stworzył człowieka na ziemi, i od jednego krańca nieba aż do drugiego, czy stała się kiedykolwiek rzecz podobna do tej tak wielkiej albo czy słyszano kiedykolwiek o czymś takim? ");
INSERT INTO polubg_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Czy słyszał kiedykolwiek jakiś naród głos Boga mówiącego spośród ognia, tak jak ty słyszałeś, i pozostał żywy? ");
INSERT INTO polubg_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Albo czy Bóg spróbował przyjść i wziąć sobie naród spośród innego narodu przez doświadczenia, przez znaki, przez cuda i przez wojny, potężną ręką i wyciągniętym ramieniem, wśród wielkich i strasznych dzieł jak to wszystko, co na twoich oczach PAN, wasz Bóg, uczynił dla was w Egipcie? ");
INSERT INTO polubg_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Tobie to ukazano, abyś wiedział, że PAN jest Bogiem i nie ma innego oprócz niego. ");
INSERT INTO polubg_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Dał ci słyszeć swój głos z nieba, aby cię pouczyć, a na ziemi ukazał ci swój wielki ogień i usłyszałeś jego słowa spośród ognia. ");
INSERT INTO polubg_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","A ponieważ umiłował twoich ojców, wybrał ich potomstwo po nich i wyprowadził cię z Egiptu przed sobą swoją wielką mocą; ");
INSERT INTO polubg_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Aby wypędzić przed tobą narody większe i potężniejsze od ciebie, by cię wprowadzić i dać ci ich ziemię w dziedzictwo, jak to jest dzisiaj. ");
INSERT INTO polubg_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Poznaj więc dziś i weź to sobie do swego serca, że PAN jest Bogiem wysoko na niebie i nisko na ziemi. Nie ma innego. ");
INSERT INTO polubg_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Przestrzegaj więc jego nakazów i przykazań, które dziś tobie nakładam, aby się dobrze powodziło tobie i twoim synom po tobie; abyś też przedłużył swe dni na ziemi, którą PAN, twój Bóg, daje tobie przez wszystkie dni. ");
INSERT INTO polubg_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Wtedy Mojżesz wydzielił trzy miasta po tej stronie Jordanu na wschodzie; ");
INSERT INTO polubg_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","Aby mógł tam uciec zabójca, który zabił swego bliźniego nieumyślnie i wcześniej nie nienawidził go, aby uciekł on do jednego z tych miast i pozostał żywy: ");
INSERT INTO polubg_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Beser na pustyni, w ziemi równinnej Rubenitów, Ramot w Gileadzie Gadytów i Golan w Baszanie Manassytów. ");
INSERT INTO polubg_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Oto prawo, które Mojżesz przedłożył synom Izraela. ");
INSERT INTO polubg_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","To są świadectwa, nakazy i prawa, które Mojżesz ogłosił synom Izraela, kiedy wyszli z Egiptu; ");
INSERT INTO polubg_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Po tej stronie Jordanu, w dolinie naprzeciw Bet-Peor, w ziemi Sichona, króla Amorytów, mieszkającego w Cheszbonie, którego Mojżesz i synowie Izraela pobili po wyjściu z Egiptu; ");
INSERT INTO polubg_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","I posiedli jego ziemię i ziemię Oga, króla Baszanu – dwóch królów Amorytów, którzy byli po tej stronie Jordanu na wschodzie; ");
INSERT INTO polubg_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Od Aroeru, leżącego nad brzegiem rzeki Arnon, aż do góry Sirion, czyli Hermon; ");
INSERT INTO polubg_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","I całą równinę po tej stronie Jordanu na wschodzie aż do Morza Pustego, pod zdrojami Pizga. ");
INSERT INTO polubg_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","I Mojżesz zwołał całego Izraela, i powiedział do nich: Słuchaj, Izraelu, nakazów i praw, które dziś mówię do twoich uszu; nauczcie się ich i przestrzegajcie, i wypełniajcie je. ");
INSERT INTO polubg_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","PAN, nasz Bóg, zawarł z nami przymierze na Horebie. ");
INSERT INTO polubg_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","PAN zawarł to przymierze nie z naszymi ojcami, ale z nami, którzy tu wszyscy dziś jesteśmy przy życiu. ");
INSERT INTO polubg_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Twarzą w twarz rozmawiał z wami PAN na górze spośród ognia; ");
INSERT INTO polubg_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Ja stałem w tym czasie pomiędzy PANEM a wami, aby oznajmić wam słowo PANA, gdyż baliście się ognia i nie wstąpiliście na górę. A on powiedział: ");
INSERT INTO polubg_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Ja jestem PAN, twój Bóg, który cię wyprowadził z ziemi Egiptu, z domu niewoli. ");
INSERT INTO polubg_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Nie będziesz miał innych bogów przede mną. ");
INSERT INTO polubg_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Nie czyń sobie rzeźbionego posągu ani żadnej podobizny czegokolwiek, co jest w górze na niebie, co jest nisko na ziemi ani tego, co jest w wodach pod ziemią; ");
INSERT INTO polubg_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Nie będziesz oddawał im pokłonu ani nie będziesz im służył, gdyż ja jestem PAN, twój Bóg, Bóg zazdrosny, nawiedzający nieprawość ojców na synach do trzeciego i czwartego pokolenia tych, którzy mnie nienawidzą; ");
INSERT INTO polubg_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","A okazujący miłosierdzie tysiącom tych, którzy mnie miłują i strzegą moich przykazań. ");
INSERT INTO polubg_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Nie będziesz brał imienia PANA, twego Boga, nadaremnie, gdyż PAN nie zostawi bez kary tego, który bierze jego imię nadaremnie. ");
INSERT INTO polubg_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Przestrzegaj dnia szabatu, abyś go święcił, tak jak ci nakazał PAN, twój Bóg. ");
INSERT INTO polubg_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Przez sześć dni będziesz pracował i wykonywał wszelką swoją pracę; ");
INSERT INTO polubg_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Lecz siódmy dzień jest szabatem PANA, twego Boga. Nie będziesz wykonywał żadnej pracy w tym dniu ani ty, ani twój syn, ani twoja córka, ani twój sługa, ani twoja służąca, ani twój wół, ani twój osioł, ani żadne twoje bydło, ani twój gość, który jest w twych bramach; aby odpoczął twój sługa i twoja służąca – jak i ty. ");
INSERT INTO polubg_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","I pamiętaj, że byłeś niewolnikiem w ziemi Egiptu i że PAN, twój Bóg, wyprowadził cię stamtąd potężną ręką i wyciągniętym ramieniem. Dlatego PAN, twój Bóg, nakazał ci obchodzić dzień szabatu. ");
INSERT INTO polubg_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Czcij swego ojca i swoją matkę, tak jak nakazał ci PAN, twój Bóg, aby przedłużone były twoje dni i żeby ci się dobrze powodziło na ziemi, którą PAN, twój Bóg, da tobie. ");
INSERT INTO polubg_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Nie będziesz zabijał. ");
INSERT INTO polubg_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Nie będziesz cudzołożył. ");
INSERT INTO polubg_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Nie będziesz kradł. ");
INSERT INTO polubg_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Nie będziesz mówił fałszywego świadectwa przeciw twemu bliźniemu. ");
INSERT INTO polubg_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Nie będziesz pragnął żony swego bliźniego ani nie będziesz pożądał domu swego bliźniego, ani jego pola, ani jego sługi czy służącej, ani jego wołu czy osła, ani żadnej rzeczy, która należy do twego bliźniego. ");
INSERT INTO polubg_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Te słowa wypowiedział PAN do całego waszego zgromadzenia na górze spośród ognia, obłoku i ciemności donośnym głosem. I nic nie dodał. Potem napisał je na dwóch tablicach kamiennych i dał mi je. ");
INSERT INTO polubg_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","A gdy usłyszeliście głos spośród ciemności, a góra płonęła ogniem, zbliżyliście się do mnie, wszyscy naczelnicy waszych pokoleń oraz starsi; ");
INSERT INTO polubg_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","I powiedzieliście: Oto PAN, nasz Bóg, ukazał nam swoją chwałę i wielkość i słyszeliśmy jego głos spośród ognia. Dziś widzieliśmy, że Bóg przemawia do człowieka, a ten pozostaje przy życiu. ");
INSERT INTO polubg_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Dlaczego więc teraz mamy umrzeć? Bo ten wielki ogień nas pochłonie. Jeśli nadal będziemy słyszeć głos PANA, naszego Boga, pomrzemy. ");
INSERT INTO polubg_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Któż bowiem spośród wszelkiego ciała słyszał głos Boga żywego mówiącego spośród ognia, tak jak my, a pozostał przy życiu? ");
INSERT INTO polubg_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Zbliż się ty i wysłuchaj wszystkiego, co będzie mówił PAN, nasz Bóg. Ty zaś powiesz nam wszystko, co powie do ciebie PAN, nasz Bóg, a my posłuchamy i wykonamy to. ");
INSERT INTO polubg_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","I PAN wysłuchał głosu waszych słów, kiedy mówiliście do mnie, i powiedział PAN do mnie: Słyszałem głos słów tego ludu, które wypowiedzieli do ciebie. Wszystko, co powiedzieli, jest słuszne. ");
INSERT INTO polubg_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Oby ich serce było takie, by się mnie bali i przestrzegali wszystkich moich przykazań przez wszystkie dni, aby dobrze się powodziło im i ich synom na wieki. ");
INSERT INTO polubg_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Idź i powiedz im: Wróćcie do swoich namiotów. ");
INSERT INTO polubg_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","A ty zostań tu przy mnie, a powiem ci wszystkie przykazania, nakazy i prawa, których będziesz ich nauczał, aby je wypełniali w ziemi, którą daję im w posiadanie. ");
INSERT INTO polubg_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Dopilnujcie wypełniania tego tak, jak wam nakazał PAN, wasz Bóg. Nie zbaczajcie ani w prawo, ani w lewo. ");
INSERT INTO polubg_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Będziecie chodzić wszelką drogą, którą wam nakazał PAN, wasz Bóg, abyście żyli, aby dobrze się wam powodziło i żebyście przedłużyli swoje dni na ziemi, którą posiądziecie. ");
INSERT INTO polubg_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","A oto przykazania, nakazy i prawa, których PAN, wasz Bóg, nakazał was nauczyć, żebyście je wypełniali w ziemi, do której idziecie, by ją posiąść; ");
INSERT INTO polubg_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Ażebyś bał się PANA, swego Boga, tak byś przestrzegał wszystkich jego nakazów i przykazań, które tobie nakazuję, tobie, twojemu synowi i synowi twego syna, po wszystkie dni twego życia, i aby twoje dni się przedłużyły. ");
INSERT INTO polubg_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Słuchaj więc, Izraelu, i pilnuj wypełniania tego, aby dobrze ci się powodziło i żebyście się bardzo rozmnożyli, tak jak obiecał ci PAN, Bóg twoich ojców, w ziemi opływającej mlekiem i miodem. ");
INSERT INTO polubg_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Słuchaj, Izraelu! PAN, nasz Bóg, PAN jest jeden. ");
INSERT INTO polubg_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Będziesz miłował PANA, swego Boga, całym swym sercem, całą swą duszą i z całej swej siły; ");
INSERT INTO polubg_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","A te słowa, które ja dziś nakazuję tobie, będą w twoim sercu; ");
INSERT INTO polubg_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","I będziesz je często przypominał swoim synom i rozmawiał o nich, przebywając w swoim domu, idąc drogą, kładąc się i wstając. ");
INSERT INTO polubg_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Przywiążesz je jako znak do swoich rąk i będą jako przepaski między twymi oczami. ");
INSERT INTO polubg_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Wypiszesz je też na odrzwiach swego domu i na swoich bramach. ");
INSERT INTO polubg_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","A gdy PAN, twój Bóg, wprowadzi cię do ziemi, którą poprzysiągł twoim ojcom: Abrahamowi, Izaakowi i Jakubowi, że da tobie miasta wielkie i dobre, których nie budowałeś; ");
INSERT INTO polubg_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","I wypełnione dobrami domy, których nie napełniałeś, i wykute studnie, których nie wykuwałeś, winnice i ogrody oliwne, których nie sadziłeś; gdy więc będziesz jadł do syta; ");
INSERT INTO polubg_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","Strzeż się, abyś nie zapomniał PANA, który cię wyprowadził z ziemi Egiptu, z domu niewoli. ");
INSERT INTO polubg_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Będziesz się bał PANA, swego Boga, i będziesz mu służyć, i na jego imię przysięgać. ");
INSERT INTO polubg_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Nie pójdziecie za obcymi bogami, za bogami narodów, które są dokoła was; ");
INSERT INTO polubg_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","(PAN bowiem, twój Bóg, znajdujący się pośród ciebie, jest Bogiem zazdrosnym), by nie rozpalił się gniew PANA, twego Boga, przeciw tobie i aby nie wytępił cię z powierzchni ziemi. ");
INSERT INTO polubg_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Nie będziecie wystawiać na próbę PANA, swojego Boga, tak jak go wystawialiście na próbę w Massa. ");
INSERT INTO polubg_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Będziecie pilnie przestrzegać przykazań PANA, swojego Boga, jego świadectw i nakazów, które ci nakazał. ");
INSERT INTO polubg_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","A czyń to, co jest prawe i dobre w oczach PANA, aby ci się dobrze powodziło, abyś wszedł i posiadł tę dobrą ziemię, którą PAN przysiągł twoim ojcom; ");
INSERT INTO polubg_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Aby wypędzić przed tobą wszystkich twoich wrogów, jak to PAN powiedział. ");
INSERT INTO polubg_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","A gdy twój syn zapyta cię kiedyś: Co to za świadectwa, nakazy i prawa, które wam nakazał PAN, nasz Bóg? ");
INSERT INTO polubg_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Wtedy powiesz swemu synowi: Byliśmy niewolnikami faraona w Egipcie i PAN wyprowadził nas z Egiptu potężną ręką. ");
INSERT INTO polubg_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","I na naszych oczach PAN czynił w Egipcie znaki i cuda, wielkie i dotkliwe, nad faraonem i nad całym jego domem. ");
INSERT INTO polubg_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Lecz wyprowadził nas stamtąd, aby nas wprowadzić i dać nam tę ziemię, którą przysiągł naszym ojcom. ");
INSERT INTO polubg_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","I PAN nakazał nam wypełniać wszystkie te nakazy i bać się PANA, naszego Boga, żeby nam się dobrze powodziło po wszystkie dni, aby nas zachować przy życiu, tak jak dziś. ");
INSERT INTO polubg_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","I będzie to nasza sprawiedliwość, gdy będziemy przestrzegać wszystkich tych przykazań i wypełniać je przed PANEM, naszym Bogiem, tak jak nam nakazał. ");
INSERT INTO polubg_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Gdy PAN, twój Bóg, wprowadzi cię do ziemi, do której wchodzisz, by ją posiąść, i gdy wypędzi przed tobą wiele narodów: Chetytów, Girgaszytów, Amorytów, Kananejczyków, Peryzzytów, Chiwwitów i Jebusytów – siedem narodów liczniejszych i p