﻿USE sofia;
DROP TABLE IF EXISTS sofia.polsz_vpl;
CREATE TABLE polsz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES polsz_vpl WRITE;
INSERT INTO polsz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Oto rodowód Jezusa Chrystusa, pochodzącego z rodu króla Dawida, potomka Abrahama: ");
INSERT INTO polsz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham był ojcem Izaaka, Izaak—ojcem Jakuba, a Jakub—ojcem Judy i jego braci. ");
INSERT INTO polsz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Kolejni potomkowie Judy to: Fares i jego brat Zara (ich matką była Tamar), Ezrom, Aram, ");
INSERT INTO polsz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminadab, Naasson, Salmon, ");
INSERT INTO polsz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Booz (jego matką była Rachab), Jobed (jego matką była Rut), Jesse ");
INSERT INTO polsz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","i król Dawid. Dawid był ojcem króla Salomona (jego matką była dawna żona Uriasza), a po nim byli: ");
INSERT INTO polsz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Roboam, Abiasz, Asa, ");
INSERT INTO polsz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jozafat, Joram, Ozjasz, ");
INSERT INTO polsz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Joatam, Achaz, Ezechiasz, ");
INSERT INTO polsz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manasses, Amos i Jozjasz. ");
INSERT INTO polsz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jozjasz był ojcem Jechoniasza i jego braci (był to czas przesiedlenia Żydów do Babilonu). ");
INSERT INTO polsz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Potomkowie Jechoniasza po przesiedleniu to: Salatiel, Zorobabel, ");
INSERT INTO polsz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abijud, Eliakim, Azor, ");
INSERT INTO polsz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sadok, Achim, Eliud, ");
INSERT INTO polsz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eleazar, Mattan i Jakub. ");
INSERT INTO polsz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakub zaś był ojcem Józefa, męża Marii, która urodziła Jezusa, zwanego Chrystusem. ");
INSERT INTO polsz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tak więc wszystkich pokoleń, od Abrahama do Dawida, było czternaście, od Dawida do przesiedlenia babilońskiego—czternaście, i od przesiedlenia do Chrystusa—również czternaście. ");
INSERT INTO polsz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jezus Chrystus urodził się w takich oto okolicznościach: Jego matka, Maria, była zaręczona z Józefem. Ale zanim wspólnie zamieszkali, za sprawą Ducha Świętego zaszła w ciążę. ");
INSERT INTO polsz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Józef, jej narzeczony, był prawym człowiekiem. Postanowił zerwać zaręczyny, ale chciał to uczynić potajemnie, by nie narażać Marii na publiczne oskarżenia. ");
INSERT INTO polsz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Gdy już to postanowił, we śnie ukazał mu się anioł Pana, który rzekł: —Józefie, potomku króla Dawida! Nie bój się ożenić z Marią, twoją narzeczoną! Bo to Duch Święty sprawił, że poczęła dziecko. ");
INSERT INTO polsz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Urodzi syna, któremu nadasz imię Jezus (czyli „Bóg zbawia”), bo to On wybawi od grzechów swój naród. ");
INSERT INTO polsz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Stało się tak, aby wypełniło się to, co Pan przepowiedział przez proroka: ");
INSERT INTO polsz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","„Oto dziewica pocznie i urodzi Syna i nazwą Go Emmanuel” (co znaczy: „Bóg jest z nami”). ");
INSERT INTO polsz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Gdy Józef się obudził, zgodnie z poleceniem anioła przyjął Marię, jako żonę, do swojego domu. ");
INSERT INTO polsz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nie współżył z nią jednak aż do czasu, gdy urodziła Syna. I dał Mu na imię Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jezus urodził się w miasteczku Betlejem, w Judei, za panowania króla Heroda. Właśnie w tym czasie przybyli do Jerozolimy mędrcy ze Wschodu. ");
INSERT INTO polsz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","—Gdzie znajduje się nowo narodzony Król Żydów?—pytali. —Ujrzeliśmy u nas, na Wschodzie, Jego gwiazdę i przybyliśmy złożyć Mu hołd. ");
INSERT INTO polsz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wiadomość o tym bardzo zaniepokoiła Heroda i całą Jerozolimę. ");
INSERT INTO polsz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Zwołał więc wszystkich najwyższych kapłanów oraz przywódców religijnych i pytał, gdzie ma się narodzić Mesjasz. ");
INSERT INTO polsz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","—W Betlejem w Judei—odpowiedzieli mu. —Bo tak napisał prorok ");
INSERT INTO polsz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","„A ty, Betlejem w Judzie, wcale nie jesteś najgorsze wśród miast Judy, gdyż z ciebie pochodzić będzie Władca, który będzie pasterzem mojego ludu—Izraela”. ");
INSERT INTO polsz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Wtedy Herod potajemnie wezwał do siebie mędrców i dowiedział się, kiedy ujrzeli gwiazdę. ");
INSERT INTO polsz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Następnie skierował ich do Betlejem mówiąc: —Idźcie i dokładnie wypytujcie o dziecko. Gdy je znajdziecie, powiadomcie mnie, abym i ja mógł złożyć mu hołd. ");
INSERT INTO polsz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Po rozmowie z królem mędrcy wyruszyli w drogę. Znowu ukazała się im gwiazda, którą zobaczyli na Wschodzie, i prowadziła ich. W końcu zatrzymała się nad miejscem, gdzie znajdowało się Dziecko. ");
INSERT INTO polsz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Widok gwiazdy napełnił ich ogromną radością. ");
INSERT INTO polsz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Gdy weszli do domu, zobaczyli Dziecko i Jego matkę, Marię. Pokłonili Mu się nisko, otworzyli szkatułki z kosztownościami i ofiarowali Mu w darze złoto, kadzidło oraz mirrę. ");
INSERT INTO polsz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Później we śnie otrzymali nakaz, by nie wracać do Heroda. Dlatego inną drogą udali się do swojego kraju. ");
INSERT INTO polsz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Gdy oddalili się, również Józefowi we śnie ukazał się anioł Pana: —Wstawaj, Józefie!—powiedział. —Weź Dziecko oraz Jego matkę i uciekaj do Egiptu. Czekaj tam, aż dam ci znać. Herod bowiem szuka Jezusa i chce Go zabić. ");
INSERT INTO polsz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jeszcze tej nocy Józef wstał i wyruszył razem z Marią i Dzieckiem do Egiptu. ");
INSERT INTO polsz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pozostał tam aż do śmierci króla Heroda—w ten sposób miały się spełnić słowa Pana wypowiedziane przez proroka: „Z Egiptu wezwałem mojego Syna”. ");
INSERT INTO polsz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod zorientował się, że mędrcy go zawiedli, i wpadł w gniew. Wysłał żołnierzy, którzy w Betlejem i całej okolicy pozabijali wszystkich chłopców do drugiego roku życia—od mędrców bowiem wiedział, w jakim wieku jest dziecko. ");
INSERT INTO polsz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tak spełniło się proroctwo Jeremiasza: ");
INSERT INTO polsz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","„Krzyk rozlega się w Rama, słychać tam płacz i rozpacz. To Rachel opłakuje swoje dzieci i nie daje się pocieszyć, bo już ich nie ma”. ");
INSERT INTO polsz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Po śmierci Heroda anioł Pana ponownie ukazał się we śnie Józefowi, przebywającemu w Egipcie. ");
INSERT INTO polsz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Wstawaj, Józefie!—powiedział. —Weź Dziecko i Jego matkę i ruszajcie do Izraela, bo umarli już ci, którzy chcieli Je zabić. ");
INSERT INTO polsz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Józef wstał, wziął Dziecko oraz Jego matkę i wyruszył do ziemi izraelskiej. ");
INSERT INTO polsz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","W drodze dowiedział się, że w Judei panuje Archelaos, syn Heroda. Bał się więc tam wracać. Otrzymał jednak we śnie kolejne polecenie i udał się do Galilei. ");
INSERT INTO polsz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tam osiedlił się w Nazarecie. I znowu spełniła się zapowiedź proroków, mówiąca, że Mesjasz będzie nazwany Nazarejczykiem. ");
INSERT INTO polsz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","W owych czasach na pustyni judejskiej rozpoczął działalność Jan Chrzciciel. ");
INSERT INTO polsz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nawoływał: —Opamiętajcie się, bo nadchodzi królestwo niebieskie! ");
INSERT INTO polsz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","To właśnie o nim mówił prorok Izajasz: „Głos wołającego na pustyni: Przygotujcie Panu drogę, wyrównajcie przed Nim ścieżki!”. ");
INSERT INTO polsz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jan żył bardzo skromnie: nosił ubranie z wielbłądziej wełny oraz skórzany pas, żywił się szarańczą i leśnym miodem. ");
INSERT INTO polsz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Z Jerozolimy, z całej Judei i z doliny Jordanu przychodziły do niego tłumy. ");
INSERT INTO polsz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","On zaś zanurzał w wodach Jordanu tych, którzy przyznawali się do swoich grzechów. ");
INSERT INTO polsz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Zauważył jednak, że również wielu faryzeuszy i saduceuszy przychodzi się ochrzcić. Napominał więc ich: —Przebiegłe węże! Kto wam powiedział, jak uciec przed nadchodzącą karą Boga?! ");
INSERT INTO polsz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Najpierw pokażcie poprzez wasze uczynki, że naprawdę się opamiętaliście! ");
INSERT INTO polsz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nie oszukujcie się, powtarzając: „Jesteśmy potomkami samego Abrahama”. Zapewniam was, że Bóg może stworzyć potomków Abrahama nawet z tych kamieni! ");
INSERT INTO polsz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Siekiera Bożego sądu już jest przyłożona do pnia. I każde drzewo, które nie wydaje owocu, zostanie wycięte i rzucone w ogień. ");
INSERT INTO polsz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ja was zanurzam w wodzie na znak opamiętania. Lecz niebawem nadejdzie Ktoś potężniejszy ode mnie. Ktoś, komu nie jestem nawet godzien nosić butów! On będzie was zanurzał w Duchu Świętym i w ogniu. ");
INSERT INTO polsz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","On potrafi oddzielić plewy od ziarna i wszystko oczyścić—ziarno zbierze do magazynu, a plewy spali w niegasnącym ogniu. ");
INSERT INTO polsz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","W tym czasie Jezus opuścił Galileę i przyszedł nad Jordan, aby Jan mógł Go ochrzcić. ");
INSERT INTO polsz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lecz ten sprzeciwiał się: —To ja powinienem być zanurzony przez Ciebie! A Ty przychodzisz po chrzest do mnie? ");
INSERT INTO polsz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","—Uczyń to—odpowiedział mu Jezus—musimy bowiem wypełnić to, co należy. Wtedy Jan zgodził się. ");
INSERT INTO polsz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Po zanurzeniu, Jezus od razu wyszedł z wody. Nagle otworzyło się niebo i ujrzał Ducha Bożego, który, jak gołąb, zstąpił w dół i spoczął na Nim. ");
INSERT INTO polsz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","A z nieba rozległ się głos: —Jesteś moim ukochanym Synem, moją największą radością! ");
INSERT INTO polsz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Potem Duch Święty zaprowadził Jezusa na pustynię, gdzie miał być kuszony przez diabła. ");
INSERT INTO polsz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Przez czterdzieści dni i nocy nic nie jadł aż w końcu poczuł głód. ");
INSERT INTO polsz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Zbliżył się więc do Niego kusiciel i powiedział: —Jeśli rzeczywiście jesteś Synem Bożym, rozkaż tym kamieniom, aby zamieniły się w chleb. ");
INSERT INTO polsz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","—Pismo uczy: „Nie tylko chlebem żywi się człowiek, ale również każdym słowem wypowiedzianym przez Boga”—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Wtedy diabeł przeniósł Go do Jerozolimy—świętego miasta—i postawił na szczycie świątyni. ");
INSERT INTO polsz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—Jeśli rzeczywiście jesteś Synem Bożym, skocz w dół—kusił. —Przecież Pismo mówi: „Bóg rozkaże swoim aniołom, aby chroniły Cię. I będą Cię nosić na rękach, abyś nie skaleczył nogi o kamień”. ");
INSERT INTO polsz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","—To samo Pismo uczy: „Nie będziesz wystawiał Boga na próbę”—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","W końcu diabeł zabrał Jezusa na wysoką górę i pokazał Mu wszystkie królestwa świata, w całym ich przepychu. ");
INSERT INTO polsz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—Wszystko to będzie Twoje—powiedział—jeśli oddasz mi pokłon. ");
INSERT INTO polsz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","—Odejdź, szatanie!—rozkazał Jezus. —Pismo uczy: „Pokłon i cześć oddawał będziesz Bogu, swemu Panu, i tylko Jemu będziesz posłuszny”. ");
INSERT INTO polsz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Wtedy diabeł odszedł, a zjawili się aniołowie i służyli Mu. ");
INSERT INTO polsz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Po pewnym czasie Jezus dowiedział się, że aresztowano Jana Chrzciciela. Dlatego udał się do Galilei. ");
INSERT INTO polsz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Opuścił jednak Nazaret i przeniósł się nad jezioro do Kafarnaum, leżącego na terenach Zabulona i Neftalego. ");
INSERT INTO polsz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","W ten sposób spełniło się proroctwo Izajasza: ");
INSERT INTO polsz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","„Ziemia Zabulona i ziemia Neftalego, położone nad morskim szlakiem, kraina za Jordanem i cała pogańska Galilea ");
INSERT INTO polsz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","—ten lud żyjący w ciemnościach, ujrzał wielkie światło. Jasność rozbłysnęła wśród tych, którzy żyli w krainie cienia i śmierci”. ");
INSERT INTO polsz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Od tego czasu Jezus zaczął nauczać: —Opamiętajcie się! Nadchodzi królestwo niebieskie! ");
INSERT INTO polsz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Pewnego dnia, idąc brzegiem Jeziora Galilejskiego, zauważył dwóch braci, Szymona, zwanego Piotrem, i Andrzeja. Zarzucali sieci, bo byli rybakami. ");
INSERT INTO polsz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—Chodźcie ze Mną!—zawołał do nich. —Uczynię was rybakami ludzi! ");
INSERT INTO polsz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bez wahania rzucili sieci i poszli z Nim. ");
INSERT INTO polsz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nieco dalej zobaczył dwóch innych braci, Jakuba i Jana. Ze swoim ojcem, Zebedeuszem, siedzieli w łodzi i naprawiali sieci. Ich także zawołał, ");
INSERT INTO polsz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","a oni poszli z Nim, zostawiając łódź i ojca. ");
INSERT INTO polsz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jezus przemierzał całą Galileę: nauczał w synagogach, głosił dobrą nowinę o królestwie oraz uzdrawiał chorych i cierpiących. ");
INSERT INTO polsz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wieść o Nim rozeszła się aż po całej Syrii. Wkrótce zaczęto przyprowadzać do Niego wszystkich chorych, cierpiących z powodu różnych dolegliwości, zniewolonych przez demony, epileptyków i sparaliżowanych. A Jezus wszystkich uzdrawiał. ");
INSERT INTO polsz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wszędzie towarzyszyły Mu ogromne tłumy ludzi przybyłych z Galilei, Dekapolu, Jerozolimy, Judei, a nawet z terenów za Jordanem. ");
INSERT INTO polsz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pewnego dnia Jezus, widząc gromadzące się wokół Niego tłumy, wszedł na wzgórze i usiadł. ");
INSERT INTO polsz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Uczniowie otoczyli Go, a On zaczął nauczać: ");
INSERT INTO polsz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Szczęśliwi ubodzy w duchu, bo do nich należy królestwo niebieskie. ");
INSERT INTO polsz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Szczęśliwi smutni, bo zostaną pocieszeni. ");
INSERT INTO polsz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Szczęśliwi cisi, bo odziedziczą całą ziemię. ");
INSERT INTO polsz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Szczęśliwi ci, którzy pragną sprawiedliwości, bo zostaną nasyceni. ");
INSERT INTO polsz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Szczęśliwi ci, którzy okazują innym miłość, bo sami zostaną obdarzeni miłością. ");
INSERT INTO polsz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Szczęśliwi ci, którzy mają czyste serce, bo zobaczą samego Boga. ");
INSERT INTO polsz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Szczęśliwi ci, którzy wprowadzają pokój, bo zostaną nazwani dziećmi Boga. ");
INSERT INTO polsz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Szczęśliwi prześladowani za prawość, bo do nich należy królestwo niebieskie. ");
INSERT INTO polsz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Macie ogromne szczęście, gdy ludzie was znieważają, prześladują i oczerniają z mojego powodu. ");
INSERT INTO polsz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cieszcie się i skaczcie z radości, bo w niebie czeka was wielka nagroda. Właśnie tak prześladowano kiedyś proroków Boga! ");
INSERT INTO polsz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesteście solą tej ziemi! Lecz jeśli sól utraci swój smak, staje się bezwartościowa. Dlatego wyrzuca się ją na ścieżkę, gdzie zostaje podeptana przez ludzi. ");
INSERT INTO polsz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Jesteście światłem dla świata! Nie można ukryć miasta położonego na wzgórzu. ");
INSERT INTO polsz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nie zapala się też lampy, aby ją zaraz zasłonić, ale stawia się ją na podwyższeniu, aby świeciła wszystkim, którzy są w domu. ");
INSERT INTO polsz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wasze światło niech również świeci wszystkim ludziom, aby widzieli wasze dobre postępowanie i oddawali chwałę waszemu Ojcu w niebie. ");
INSERT INTO polsz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nie myślcie, że przyszedłem znieść Prawo Mojżesza albo pisma proroków. Nie znieść, ale wypełnić! ");
INSERT INTO polsz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Zapewniam was, że prędzej niebo i ziemia przestaną istnieć, niż zmieni się najmniejsza literka w Prawie—zanim wszystko zostanie do końca wypełnione. ");
INSERT INTO polsz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jeśli więc ktoś usunąłby nawet najmniej ważne przykazanie Prawa i tak nauczał innych, będzie najmniej ważny w królestwie niebieskim. A kto sam wypełnia wszystko i uczy tego innych, będzie wielki w królestwie niebieskim. ");
INSERT INTO polsz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ostrzegam was więc: jeśli wasza prawość nie będzie większa od prawości faryzeuszy i przywódców religijnych, nie wejdziecie do królestwa niebieskiego. ");
INSERT INTO polsz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Słyszeliście, że powiedziano przodkom: „Nie zabijaj”, a kto zabije, pójdzie pod sąd. ");
INSERT INTO polsz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","A ja wam mówię: Każdy, kto się na kogoś gniewa, pójdzie pod sąd! A kto nazywa go głupcem, stanie przed Wysoką Radą. A kto nazwałby go idiotą, zasługuje na ogień piekielny. ");
INSERT INTO polsz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jeśli więc, przynosząc dar na ołtarz w świątyni, przypomniałbyś sobie, że ktoś ci coś zarzuca, ");
INSERT INTO polsz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","zostaw swój dar przy ołtarzu i idź się pogodzić z tym człowiekiem. Potem wróć i złóż dar Bogu. ");
INSERT INTO polsz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Póki jest na to czas, staraj się polubownie załatwić sprawę ze swoim oskarżycielem. W przeciwnym bowiem razie sędzia cię skaże i zostaniesz wtrącony do więzienia. ");
INSERT INTO polsz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Zapewniam cię, że nie wyjdziesz stamtąd, aż spłacisz cały dług—co do grosza. ");
INSERT INTO polsz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Słyszeliście, że w Prawie Mojżesza powiedziano: „Bądź wierny w małżeństwie”. ");
INSERT INTO polsz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","A Ja wam mówię: Kto spogląda na kobietę i pożąda jej, w sercu już się dopuścił niewierności. ");
INSERT INTO polsz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jeśli więc twoje prawe oko skłania cię do grzechu, wyłup je i odrzuć. Lepiej bowiem, gdy zginie jakaś część twojego ciała, niż byś z całym ciałem miał być wrzucony do piekła. ");
INSERT INTO polsz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","I jeśli twoja prawa ręka skłania cię do grzechu, odetnij ją i odrzuć. Lepiej bowiem, gdy zginie jakaś część twojego ciała, niż byś z całym ciałem miał znaleźć się w piekle. ");
INSERT INTO polsz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","W Prawie Mojżesza powiedziano też: „Kto chce się rozwieść z żoną, niech jej wręczy dokument rozwodowy”. ");
INSERT INTO polsz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","A Ja wam mówię: Kto rozwodzi się z żoną (z wyjątkiem przypadku rozwiązłości seksualnej), naraża ją na grzech niewierności. Kto zaś żeni się z rozwódką, również dopuszcza się grzechu niewierności małżeńskiej. ");
INSERT INTO polsz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Słyszeliście również, że powiedziano przodkom: „Nie przysięgaj fałszywie, lecz dotrzymaj przysięgi danej Panu”. ");
INSERT INTO polsz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","A Ja wam mówię: W ogóle nie przysięgajcie: ani na niebo—bo jest tronem Boga; ");
INSERT INTO polsz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ani na ziemię—bo jest Jego podnóżkiem; ani na Jerozolimę—bo jest miastem wielkiego Króla! ");
INSERT INTO polsz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nawet na własną głowę nie przysięgaj—bo nie możesz jednego włosa uczynić białym lub czarnym. ");
INSERT INTO polsz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mów prawdę: niech twoje „tak” znaczy „tak”, a „nie” znaczy „nie”. Każde oszustwo pochodzi od szatana. ");
INSERT INTO polsz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Słyszeliście, że w Prawie Mojżesza powiedziano: „Oko za oko, ząb za ząb”. ");
INSERT INTO polsz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","A Ja wam mówię: Nie rewanżujcie się za doznane zło! Jeśli ktoś cię obrazi, uderzając w policzek, nadstaw mu drugi. ");
INSERT INTO polsz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Jeśli ktoś chce się z tobą sądzić o koszulę, daj mu od razu i płaszcz. ");
INSERT INTO polsz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Jeśli ktoś cię zmusza, byś niósł mu bagaż kilometr, nieś mu i dwa. ");
INSERT INTO polsz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Daj temu, kto cię prosi, i nie odwracaj się od tego, kto chce od ciebie coś pożyczyć. ");
INSERT INTO polsz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Słyszeliście, że powiedziano: „Kochaj przyjaciół, nienawidź wrogów”. ");
INSERT INTO polsz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","A Ja wam mówię: Kochajcie waszych wrogów i módlcie się za tych, którzy was prześladują— ");
INSERT INTO polsz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tak postępują dzieci waszego Ojca w niebie. On bowiem sprawia, że słońce wschodzi dla dobrych i dla złych. A deszcz pada dla prawych i dla nieprawych. ");
INSERT INTO polsz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Czy sądzicie, że zasługujecie na nagrodę, bo kochacie tych, którzy was kochają? Czy nawet źli ludzie tak nie postępują? ");
INSERT INTO polsz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jeśli jesteście mili tylko dla przyjaciół, w czym jesteście lepsi? Czy poganie tak nie postępują? ");
INSERT INTO polsz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bądźcie więc doskonali, tak jak wasz Ojciec w niebie. ");
INSERT INTO polsz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Uważajcie, by nie być dobrymi tylko na pokaz. Jeśli tak będziecie postępować, nie otrzymacie nagrody od waszego Ojca w niebie. ");
INSERT INTO polsz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Gdy obdarowujesz biednego, nie rozgłaszaj tego, jak to czynią obłudnicy w synagogach i na ulicach, by zyskać poklask u ludzi. Zapewniam was: oni teraz odbierają za to nagrodę. ");
INSERT INTO polsz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wspierając potrzebującego, czyń to dyskretnie. Niech twoja lewa ręka nie wie, co robi prawa, ");
INSERT INTO polsz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","aby twoja pomoc pozostała w ukryciu. A Ojciec twój, który wszystko widzi, nagrodzi cię. ");
INSERT INTO polsz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Gdy się modlicie, nie zachowujcie się jak obłudnicy. Oni uwielbiają to robić w synagogach i na rogach ulic—na pokaz. Zapewniam was: już teraz odbierają za to nagrodę. ");
INSERT INTO polsz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ty zaś zamknij się w swoim pokoju i módl się do Ojca, który wszystko widzi—On cię nagrodzi. ");
INSERT INTO polsz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nie róbcie z modlitwy paplaniny—jak poganie, którzy sądzą, że wysłuchanie ich próśb zależy od ilości wypowiedzianych słów. ");
INSERT INTO polsz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nie bądźcie do nich podobni! Wasz Ojciec doskonale zna wasze potrzeby, zanim jeszcze Go o coś poprosicie! ");
INSERT INTO polsz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Zwracajcie się do Boga tak: Nasz Ojcze w niebie, niech Twoje święte imię będzie uwielbione! ");
INSERT INTO polsz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Niech nadejdzie Twoje królestwo. Niech Twoja wola wypełnia się na ziemi tak, jak w niebie. ");
INSERT INTO polsz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Zapewnij nam codzienny pokarm. ");
INSERT INTO polsz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Przebacz nam nasze grzechy, tak jak my przebaczamy tym, którzy zawinili wobec nas. ");
INSERT INTO polsz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nie pozwól, byśmy ulegli pokusie i wybaw nas od złego. ");
INSERT INTO polsz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jeśli bowiem wybaczycie innym ich zło, to i wam wybaczy wasz Ojciec w niebie. ");
INSERT INTO polsz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lecz jeśli nie wybaczycie, i On wam nie wybaczy. ");
INSERT INTO polsz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Gdy powstrzymujecie się od posiłków, nie róbcie tego na pokaz—jak obłudnicy, którzy starają się wyglądać ponuro i mizernie. Zapewniam was: oni już teraz odbierają za to nagrodę. ");
INSERT INTO polsz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Gdy więc pościsz, zadbaj o włosy i umyj twarz, ");
INSERT INTO polsz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","by pokazać swój post Ojcu, a nie ludziom. On wszystko widzi i nagrodzi cię. ");
INSERT INTO polsz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nie gromadźcie bogactw tu, na ziemi, gdzie mogą ulec zniszczeniu lub zostać skradzione przez złodziei. ");
INSERT INTO polsz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Gromadźcie je w niebie—tam nic ich nie zniszczy i nikt się nie włamie, by je ukraść. ");
INSERT INTO polsz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gdzie jest wasz skarb, tam będzie wasze serce. ");
INSERT INTO polsz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Oko jest dla ciała jak lampa. Jeśli jest zdrowe, światło napełnia całe ciało. ");
INSERT INTO polsz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Jeśli jednak jest chore, całe ciało jest pogrążone w ciemnościach. Jeżeli więc twoje światło jest ciemnością, to jest to ciemność nieprzenikniona. ");
INSERT INTO polsz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nie da się lojalnie służyć dwóm panom. Albo jednego nienawidzisz, a drugiego kochasz, albo na odwrót—drugiego szanujesz, a pierwszego lekceważysz. Nie możecie równocześnie żyć dla Boga i dla pieniędzy! ");
INSERT INTO polsz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Dlatego radzę wam: Nie martwcie się o swoje życie—o to, co będziecie jeść i pić, ani o ciało—w co się ubierzecie. Czy życie ogranicza się tylko do jedzenia, a ciało—tylko do ubrania? ");
INSERT INTO polsz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Spójrzcie na ptaki: Nie sieją ziarna, nie magazynują zapasów, a wasz Ojciec w niebie żywi je! Czy wy nie jesteście ważniejsi od ptaków? ");
INSERT INTO polsz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Czy ktokolwiek, poprzez zamartwianie się, potrafi przedłużyć swoje życie choćby o jedną chwilę? ");
INSERT INTO polsz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Dlaczego martwicie się o ubranie? Uczcie się od polnych kwiatów: Nie pracują i nie troszczą się o swój ubiór. ");
INSERT INTO polsz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","A zapewniam was, że nawet król Salomon, w całym swym przepychu, nie był tak pięknie ubrany jak one. ");
INSERT INTO polsz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jeśli więc Bóg tak wspaniale ubiera polne kwiaty, które dzisiaj kwitną, a jutro więdną i idą na spalenie, to czy tym bardziej nie zatroszczy się o was, nieufni?! ");
INSERT INTO polsz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nie martwcie się więc i nie powtarzajcie: Co będziemy jeść i pić? W co się ubierzemy? ");
INSERT INTO polsz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","O te sprawy zabiegają poganie. Wasz Ojciec w niebie dobrze wie, że tego potrzebujecie. ");
INSERT INTO polsz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","W pierwszej kolejności zabiegajcie o Jego królestwo i prawość, a wtedy Bóg zatroszczy się o pozostałe rzeczy. ");
INSERT INTO polsz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nie martwcie się więc o to, co będzie jutro, bo dzień jutrzejszy zatroszczy się o siebie. Dziś macie już wystarczająco wiele zmartwień. ");
INSERT INTO polsz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nie krytykujcie innych, to i sami tego nie doświadczycie. ");
INSERT INTO polsz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Osądzą was bowiem tak, jak wy osądzacie, i odmierzą wam taką miarą, jaką sami mierzycie. ");
INSERT INTO polsz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Dlaczego zwracasz uwagę na rzęsę w czyimś oku, jeśli w twoim własnym tkwi cała belka? ");
INSERT INTO polsz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Jak możesz powiedzieć: „Przyjacielu, pozwól, że wyciągnę ci rzęsę”, podczas gdy sam masz w oku belkę? ");
INSERT INTO polsz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Obłudniku! Usuń najpierw belkę ze swojego oka, a wtedy przejrzysz i pomożesz mu wyjąć rzęsę z jego oka. ");
INSERT INTO polsz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nie dawajcie psom tego, co święte, i nie rzucajcie pereł przed świnie. Bo i tak je podepczą, a was mogą zaatakować. ");
INSERT INTO polsz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Proście, a dostaniecie. Szukajcie, a znajdziecie. Pukajcie, a otworzą wam. ");
INSERT INTO polsz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Każdy bowiem, kto prosi—dostaje; kto szuka—znajduje; a temu, kto puka—otwierają. ");
INSERT INTO polsz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kto z was dałby swojemu dziecku kamień, gdy ono prosi o chleb? ");
INSERT INTO polsz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Albo węża, gdy poprosi o rybę? ");
INSERT INTO polsz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Skoro wy, źli ludzie, dajecie dzieciom to, co dobre, to tym bardziej wasz Ojciec w niebie da dobre rzeczy tym, którzy Go proszą. ");
INSERT INTO polsz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Czyńcie innym to, czego sami od nich oczekujecie. Na tym polega cała nauka Prawa i proroków. ");
INSERT INTO polsz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Brama do nieba jest ciasna! Wielu ludzi wchodzi przez szeroką bramę i idzie przestronną drogą, która prowadzi do śmierci. ");
INSERT INTO polsz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Niewielu jednak odnajduje ciasną bramę i wąską drogę prowadzącą do życia. ");
INSERT INTO polsz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Strzeżcie się fałszywych proroków, którzy przychodzą do was jak wilki przebrane za owce. ");
INSERT INTO polsz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Rozpoznacie ich po ich czynach. Czy zbiera się winogrona albo figi z dzikich krzewów? ");
INSERT INTO polsz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Szlachetne drzewo rodzi dobre owoce, a dzikie drzewo—gorzkie. ");
INSERT INTO polsz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ani to pierwsze nie może rodzić cierpkich owoców, ani to drugie—dobrych. ");
INSERT INTO polsz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","A drzewo nie dające dobrego owocu wycina się i pali. ");
INSERT INTO polsz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Fałszywych proroków również rozpoznacie po ich owocach. ");
INSERT INTO polsz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nie każdy, kto nazywa Mnie swoim Panem, wejdzie do królestwa niebieskiego—tylko ten, kto wypełnia wolę mojego Ojca w niebie. ");
INSERT INTO polsz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","W dniu sądu wielu mi powie: „Panie, czy w Twoim imieniu nie prorokowaliśmy, nie wypędzaliśmy demonów i nie dokonywaliśmy wielkich dzieł?”. ");
INSERT INTO polsz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ale Ja im odpowiem: „Nigdy was nie znałem. Odejdźcie stąd wy wszyscy, którzy czynicie zło!”. ");
INSERT INTO polsz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ten, kto Mnie słucha, i postępuje według moich słów, jest jak człowiek rozsądny, który swój dom zbudował na mocnym fundamencie. ");
INSERT INTO polsz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Gdy przyszła ulewa, a powódź i wicher uderzyły w ten dom, nie runął, bo miał solidny fundament. ");
INSERT INTO polsz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kto zaś słucha Mnie, ale nie postępuje według tego, co słyszy, jest jak człowiek głupi, który swój dom zbudował bezpośrednio na piasku—bez fundamentów. ");
INSERT INTO polsz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Gdy przyszła ulewa, a powódź i wicher uderzyły w ten dom, on zawalił się—a była to wielka katastrofa. ");
INSERT INTO polsz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Gdy Jezus skończył, tłumy były zdumione Jego nauczaniem. ");
INSERT INTO polsz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mówił bowiem do nich nie jak ich przywódcy religijni, ale jak ktoś, kto ma prawdziwą władzę nad ludźmi. ");
INSERT INTO polsz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jezus zszedł ze wzgórza, a ogromne tłumy poszły za Nim. ");
INSERT INTO polsz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wtem podszedł do Niego jakiś trędowaty, pokłonił Mu się i poprosił: —Panie! Jeśli zechcesz, możesz mnie uzdrowić. ");
INSERT INTO polsz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jezus dotknął go i powiedział: —Chcę. Bądź uzdrowiony! I w jednej chwili trąd zniknął. ");
INSERT INTO polsz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","—Nie mów o tym nikomu!—dodał Jezus. —Idź i poproś, aby zbadał cię kapłan. A na dowód tego, że wyzdrowiałeś, zanieś ofiarę, jaką Mojżesz wyznaczył uleczonemu z trądu. ");
INSERT INTO polsz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Gdy Jezus przybył do Kafarnaum, podszedł do Niego rzymski dowódca oddziału z prośbą: ");
INSERT INTO polsz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Panie, mój sługa leży w domu, jest sparaliżowany i strasznie cierpi. ");
INSERT INTO polsz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—Dobrze, pójdę go uzdrowić—rzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","—Panie—powiedział dowódca—nie jestem godny przyjmować Ciebie w moim domu. Wystarczy, że powiesz jedno słowo, a on wyzdrowieje. ");
INSERT INTO polsz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wiem to, bo sam podlegam władzy i mam pod sobą żołnierzy. Jeśli powiem któremuś: „Idź!”, on idzie, a jeśli powiem któremuś: „Przyjdź tu!”, przychodzi. I jak powiem słudze: „Wykonać!”, to wykonuje polecenie. ");
INSERT INTO polsz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Słysząc taką odpowiedź, Jezus zdziwił się. Rzekł więc do tłumu: —Zapewniam was: Tak wielkiej wiary nie spotkałem u nikogo w Izraelu! ");
INSERT INTO polsz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Przyjdzie czas, że wielu pogan z całego świata zasiądzie w królestwie niebieskim razem z Abrahamem, Izaakiem i Jakubem. ");
INSERT INTO polsz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Natomiast ci, dla których to królestwo było przygotowane, zostaną wyrzuceni na zewnątrz—w ciemności, gdzie panuje rozpacz i lament. ");
INSERT INTO polsz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dowódcy zaś powiedział: —Idź do domu. Niech stanie się tak, jak uwierzyłeś. I właśnie o tej godzinie jego sługa odzyskał zdrowie. ");
INSERT INTO polsz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Potem Jezus poszedł do domu Piotra. Gdy wszedł do środka, zauważył, że teściowa Piotra leży na łóżku i ma wysoką gorączkę. ");
INSERT INTO polsz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dotknął jej ręki i temperatura natychmiast spadła, a teściowa wstała i przygotowała im posiłek. ");
INSERT INTO polsz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wieczorem przyprowadzono do Jezusa wielu zniewolonych przez demony. Rozkazał demonom wyjść z ludzi i uzdrowił wszystkich chorych. ");
INSERT INTO polsz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tak spełniło się proroctwo Izajasza: „On wziął na Siebie nasze słabości i niósł nasze choroby”. ");
INSERT INTO polsz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tłumy wokół Jezusa zaczęły rosnąć. Polecił więc uczniom przeprawić się na drugi brzeg jeziora. ");
INSERT INTO polsz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wówczas podszedł do Niego jeden z przywódców religijnych i powiedział: —Nauczycielu, pójdę z Tobą, dokądkolwiek się udasz! ");
INSERT INTO polsz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","—Lisy mają nory, a ptaki gniazda—odrzekł mu Jezus—lecz ja, Syn Człowieczy, nie mam własnego kąta, gdzie mógłbym odpocząć. ");
INSERT INTO polsz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A któryś z uczniów powiedział: —Panie, pozwól mi tylko pójść i pochować zmarłego ojca! ");
INSERT INTO polsz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","—Chodź ze Mną!—odpowiedział Jezus. —Niech umarli grzebią umarłych. ");
INSERT INTO polsz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Następnie wsiadł z uczniami do łodzi i wypłynęli na jezioro. ");
INSERT INTO polsz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","W pewnej chwili zerwała się tak silna burza, że fale zalewały łódź. Jezus wtedy spał. ");
INSERT INTO polsz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Zaczęli więc Go budzić: —Panie, ratuj nas, toniemy! ");
INSERT INTO polsz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","—Dlaczego się tak boicie, nieufni?!—rzekł Jezus. Wstał i rozkazał wiatrowi oraz wodzie zamilknąć. I zaległa głęboka cisza. ");
INSERT INTO polsz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","—Kim On jest—dziwili się wszyscy—że nawet wiatr i jezioro są Mu posłuszne? ");
INSERT INTO polsz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Gdy przybyli na drugi brzeg jeziora, do krainy Gadareńczyków, wybiegło Jezusowi naprzeciw dwóch opętanych. Mieszkali w grobowcach i byli tak niebezpieczni, że nikt nie miał odwagi tamtędy chodzić. ");
INSERT INTO polsz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","—Czego od nas chcesz, Synu Boży?—zaczęli krzyczeć. —Czemu przyszedłeś przed czasem nas dręczyć?! ");
INSERT INTO polsz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","W oddali zaś pasło się wielkie stado świń. ");
INSERT INTO polsz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","—Jeśli już nas wypędzasz, poślij nas w te świnie—prosiły demony. ");
INSERT INTO polsz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Dobrze!—zezwolił im. —Idźcie! Opuściły więc ludzi i weszły w świnie, po czym całe stado rzuciło się pędem ze stromego zbocza wprost do jeziora i utonęło. ");
INSERT INTO polsz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pasterze stada uciekli wtedy do pobliskiego miasta i o wszystkim tam opowiedzieli—również o opętanych. ");
INSERT INTO polsz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wkrótce całe miasto wyszło Jezusowi na spotkanie. Gdy Go zobaczyli, zaczęli prosić, aby odszedł z ich okolic. ");
INSERT INTO polsz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jezus wsiadł więc do łodzi i odpłynął do swojego miasta, Kafarnaum. ");
INSERT INTO polsz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tam kilku mężczyzn przyniosło do Niego na noszach sparaliżowanego. Widząc ich wiarę, Jezus rzekł do chorego: —Bądź dobrej myśli, synu. Odpuszczam ci grzechy! ");
INSERT INTO polsz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","„To jawne bluźnierstwo!”—z oburzeniem pomyślało sobie kilku przywódców religijnych. ");
INSERT INTO polsz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jezus, znając ich myśli, zapytał: —Dlaczego was to oburza? ");
INSERT INTO polsz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Co jest łatwiej powiedzieć: „Odpuszczam ci grzechy” czy: „Wstań i chodź!”? ");
INSERT INTO polsz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Udowodnię wam, że Ja, Syn Człowieczy, mogę odpuszczać grzechy. I zwrócił się do sparaliżowanego: —Jesteś uzdrowiony! Zabierz swoje nosze i idź do domu! ");
INSERT INTO polsz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","A chory wstał i odszedł do domu. ");
INSERT INTO polsz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Po zebranych przeszedł dreszcz lęku. I wielbili Boga za to, że dał taką moc człowiekowi! ");
INSERT INTO polsz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Odchodząc stamtąd, Jezus zobaczył niejakiego Mateusza, poborcę podatkowego, który właśnie tam pracował. —Chodź ze Mną—zwrócił się do niego. A on natychmiast wstał i poszedł z Jezusem. ");
INSERT INTO polsz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Później, gdy Jezus i Jego uczniowie byli u niego w domu, zebrało się wokół stołu wielu nieuczciwych poborców podatkowych i innych ludzi, uważanych za grzeszników. ");
INSERT INTO polsz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Widząc to, faryzeusze mówili do uczniów: —Dlaczego wasz nauczyciel zadaje się z takimi ludźmi? ");
INSERT INTO polsz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jezus usłyszał to i odpowiedział: —To chorzy potrzebują lekarza, a nie zdrowi! ");
INSERT INTO polsz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Idźcie i zastanówcie się nad słowami Pisma: „Pragnę waszej miłości, a nie ofiar”. Nie przyszedłem wzywać do opamiętania się tych, którzy uważają się za dobrych, ale właśnie grzeszników. ");
INSERT INTO polsz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pewnego razu przyszli do Jezusa uczniowie Jana Chrzciciela i zapytali Go: —My i faryzeusze, stosując się do religijnych zaleceń, często powstrzymujemy się od posiłków. Dlaczego Twoi uczniowie tego nie czynią? ");
INSERT INTO polsz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","—Przecież goście na weselu, będąc z panem młodym, nie mogą się smucić!—odrzekł Jezus. —Ale nadejdzie czas, gdy zabiorą im pana młodego. Wtedy będą pościć. ");
INSERT INTO polsz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nikt nie używa nowego materiału do łatania starego ubrania, bo nowa łata się kurczy i jeszcze bardziej rozdziera ubranie. ");
INSERT INTO polsz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nie wlewa się też świeżego wina do starych, stwardniałych bukłaków. Mogłyby przecież popękać, a wtedy i wino by się rozlało, i bukłaki zniszczyły. Świeże wino wlewa się do nowych, miękkich bukłaków. W ten sposób i jedno, i drugie się zachowuje. ");
INSERT INTO polsz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Gdy jeszcze o tym mówił, podszedł do Niego przełożony miejscowej synagogi. Pokłonił się i powiedział: —Przed chwilą zmarła moja córeczka. Ale jeśli przyjdziesz i dotkniesz jej, ożyje. ");
INSERT INTO polsz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jezus wstał i wraz z uczniami poszedł za przełożonym. ");
INSERT INTO polsz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tymczasem pewna kobieta, od dwunastu lat cierpiąca na krwotok, podeszła do Niego od tyłu i dotknęła Jego ubrania. ");
INSERT INTO polsz_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Pomyślała bowiem: „Jeśli tylko dotknę Jego płaszcza, zostanę uzdrowiona”. ");
INSERT INTO polsz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jezus odwrócił się, dostrzegł ją i rzekł: —Bądź dobrej myśli, córko! Uwierzyłaś, więc zostałaś uzdrowiona! I w tej samej chwili kobieta odzyskała zdrowie. ");
INSERT INTO polsz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Gdy przybył do domu przełożonego synagogi, zobaczył żałobników i lamentujący tłum. ");
INSERT INTO polsz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","—Odejdźcie stąd—powiedział. —Dziewczynka nie umarła, tylko śpi. Ale oni śmiali się z Niego. ");
INSERT INTO polsz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","W końcu jednak wyproszono tłum. Jezus wszedł do środka, wziął dziewczynkę za rękę, a ona natychmiast wstała! ");
INSERT INTO polsz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wieść o tym obiegła całą okolicę. ");
INSERT INTO polsz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jezus właśnie stamtąd odchodził, gdy zjawili się dwaj niewidomi, którzy wołali za Nim: —Potomku króla Dawida, zmiłuj się nad nami! ");
INSERT INTO polsz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Szli tak za Nim aż do domu, gdzie się zatrzymał. Wtedy podeszli bliżej, a On ich zapytał: —Wierzycie, że mogę to zrobić? —Tak, Panie!—odpowiedzieli. ");
INSERT INTO polsz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","—Niech będzie tak, jak wierzycie—powiedział Jezus i dotknął ich oczu. ");
INSERT INTO polsz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","I nagle przejrzeli! Wówczas On surowo im nakazał: —Nikomu o tym nie mówcie. ");
INSERT INTO polsz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ale oni odeszli i zaraz wszędzie o tym opowiedzieli. ");
INSERT INTO polsz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","W tym właśnie czasie przyprowadzono do Jezusa kolejnego człowieka—niemowę zniewolonego przez demona. ");
INSERT INTO polsz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Po wypędzeniu demona, człowiek ten zaczął mówić. A tłumy nie mogły wyjść z podziwu: —Coś takiego nigdy się nie zdarzyło w całym Izraelu! ");
INSERT INTO polsz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","—Wypędza demony, bo władca demonów Mu w tym pomaga—twierdzili natomiast faryzeusze. ");
INSERT INTO polsz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","A Jezus odwiedzał wszystkie okoliczne miasta i wioski. Nauczał w synagogach, głosił dobrą nowinę o królestwie i uzdrawiał z każdej choroby i słabości. ");
INSERT INTO polsz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Gdy patrzył na otaczające Go tłumy, ogarniała Go litość. Ludzie byli bowiem udręczeni i zagubieni jak owce bez pasterza. ");
INSERT INTO polsz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","—Żniwo jest wielkie—mówił uczniom—a tak mało pracujących! ");
INSERT INTO polsz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Proście więc gospodarza, aby posłał więcej pracowników na żniwa. ");
INSERT INTO polsz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pewnego dnia Jezus przywołał dwunastu uczniów i dał im władzę uwalniania ludzi od złych duchów i uzdrawiania wszelkich chorób i dolegliwości. ");
INSERT INTO polsz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Byli to: Szymon (zwany też Piotrem) i Andrzej—jego brat, Jakub i Jan—synowie Zebedeusza, ");
INSERT INTO polsz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Bartłomiej, Tomasz, Mateusz (poborca podatkowy), Jakub—syn Alfeusza, Tadeusz, ");
INSERT INTO polsz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Szymon Gorliwy i Judasz z Kariotu—ten, który później wydał Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tych dwunastu uczniów Jezus posłał, dając im następujące wskazówki: —Nie chodźcie do pogan ani do miast Samarii. ");
INSERT INTO polsz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Idźcie jedynie do Izraelitów, którzy jak zagubione owce odeszli od Boga. ");
INSERT INTO polsz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mówcie im: „Nadchodzi królestwo niebieskie!”. ");
INSERT INTO polsz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Uzdrawiajcie chorych, wskrzeszajcie zmarłych, leczcie trędowatych i uwalniajcie od demonów. Róbcie to za darmo, bo za darmo to otrzymaliście! ");
INSERT INTO polsz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nie bierzcie ze sobą pieniędzy, ");
INSERT INTO polsz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","torby z zapasową odzieżą i obuwiem ani laski podróżnej. Ten bowiem, kto pracuje, powinien otrzymać to, co mu się należy. ");
INSERT INTO polsz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Wchodząc do jakiegoś miasta lub wsi, dowiedzcie się, kto tam jest godnym człowiekiem. Pozostańcie u niego aż do opuszczenia tej miejscowości. ");
INSERT INTO polsz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wchodząc do jego domu, pozdrówcie tych, którzy w nim mieszkają. ");
INSERT INTO polsz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jeśli to pobożni ludzie, Bóg obdarzy ich pokojem. Jeśli nie—pokój pozostanie z wami. ");
INSERT INTO polsz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jeśli nie zostaniecie przyjęci i nie będą chcieli was słuchać, odchodząc z tego domu i miasta, strząśnijcie z nóg nawet tamtejszy kurz. ");
INSERT INTO polsz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Zapewniam was: W dniu sądu złym mieszkańcom Sodomy i Gomory lżej będzie niż temu miastu. ");
INSERT INTO polsz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Posyłam was jak owce między wilki. Bądźcie więc sprytni jak węże, ale nieskazitelni jak gołębie. ");
INSERT INTO polsz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Uważajcie na siebie! Postawią was przed sądami, będą was biczować w synagogach ");
INSERT INTO polsz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","oraz oskarżać przed władzami za to, że Mnie naśladujecie. Będzie to dla was okazja do przedstawienia im dobrej nowiny. W ten sposób dotrze ona do wielu narodów. ");
INSERT INTO polsz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nie martwcie się jednak, co i jak macie mówić. We właściwym czasie otrzymacie stosowne słowa. ");
INSERT INTO polsz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bo to nie wy będziecie mówić, lecz Duch waszego Ojca będzie mówił przez was! ");
INSERT INTO polsz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Bracia będą wzajemnie się wydawać na śmierć, ojcowie zdradzą własne dzieci, a dzieci—rodziców. ");
INSERT INTO polsz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wszyscy was znienawidzą za to, że należycie do Mnie. Ale ci, którzy wytrwają do końca i nie zaprą się Mnie, zostaną uratowani! ");
INSERT INTO polsz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Gdy spotka was prześladowanie w jednym mieście, uciekajcie do drugiego! Zapewniam was: Nie zdążycie obejść wszystkich miast Izraela, a Ja, Syn Człowieczy powrócę. ");
INSERT INTO polsz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Uczeń nie przewyższa nauczyciela, a sługa—swego pana. ");
INSERT INTO polsz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wystarczy, że będą jak ich nauczyciel lub pan. Skoro Mnie, pana domu, nazwano Belzebubem, władcą demonów, to tym bardziej spotka to domowników. ");
INSERT INTO polsz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ale nie bójcie się ich! Nie ma bowiem niczego ukrytego, co by ostatecznie nie wyszło na jaw. ");
INSERT INTO polsz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","To, co teraz mówię wam pod osłoną nocy, rozpowiadajcie z nastaniem dnia. To, co słyszycie na ucho, rozgłaszajcie publicznie! ");
INSERT INTO polsz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nie bójcie się tych, którzy uśmiercają ciało, lecz nie mogą zabić duszy! Lękajcie się Boga, który i duszę, i ciało może zatracić w piekle. ");
INSERT INTO polsz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ile kosztuje para wróbli? Można ją kupić już za kilka drobnych monet. A jednak żaden z nich nie spadnie na ziemię bez wiedzy waszego Ojca w niebie. ");
INSERT INTO polsz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Przecież On wie nawet ile macie włosów na głowie! ");
INSERT INTO polsz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nie bójcie się więc! Jesteście dla Niego cenniejsi niż całe stado wróbli! ");
INSERT INTO polsz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jeśli więc jakiś człowiek wyzna przed innymi ludźmi, że należy do Mnie, to i Ja przyznam się do Niego przed moim Ojcem w niebie. ");
INSERT INTO polsz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lecz jeśli ktoś wyprze się Mnie wobec ludzi, i Ja się go wyprę przed moim Ojcem w niebie. ");
INSERT INTO polsz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nie myślcie, że przyszedłem przynieść na ziemię pokój! Wręcz przeciwnie—miecz podziału! ");
INSERT INTO polsz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Przyszedłem poróżnić syna z ojcem, córkę—z matką, a synową—z teściową. ");
INSERT INTO polsz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nawet najbliżsi staną się wrogami! ");
INSERT INTO polsz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kto kocha ojca lub matkę bardziej niż Mnie, nie jesteś Mnie godny. I kto kocha syna lub córkę bardziej niż Mnie, nie jest Mnie godny. ");
INSERT INTO polsz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kto nie bierze swojego krzyża i nie idzie ze Mną, nie jest Mnie godny. ");
INSERT INTO polsz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kto zabiega o swoje życie, utraci je. Lecz ten, kto poświęci życie dla Mnie, odnajdzie je. ");
INSERT INTO polsz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Kto was przyjmuje, Mnie przyjmuje. A kto Mnie przyjmuje, przyjmuje Ojca, który Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kto przyjmuje proroka—dlatego, że jest on prorokiem—otrzyma nagrodę należną prorokowi. Kto przyjmuje prawego człowieka—dlatego, że jest on prawy—otrzyma nagrodę należną prawemu człowiekowi. ");
INSERT INTO polsz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nawet jeśli ktoś poda kubek wody najmniejszemu z moich uczniów—właśnie dlatego, że jest on moim uczniem—zapewniam was: nie ominie go nagroda! ");
INSERT INTO polsz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Gdy Jezus zakończył wydawanie poleceń dwunastu uczniom, udał się do okolicznych miast, aby tam nauczać. ");
INSERT INTO polsz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jan Chrzciciel, będąc w więzieniu, usłyszał o dokonaniach Mesjasza i posłał do Niego swoich uczniów ");
INSERT INTO polsz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","z pytaniem: „Czy to Ty jesteś spodziewanym Mesjaszem, czy też mamy oczekiwać kogoś innego?”. ");
INSERT INTO polsz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","—Wracajcie do Jana—rzekł im Jezus—i powiedzcie o tym, co widzicie i słyszycie: ");
INSERT INTO polsz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","niewidomi widzą, kalecy chodzą, trędowaci odzyskują zdrowie, głusi słyszą, umarli powracają do życia, ubogim głoszona jest dobra nowina. ");
INSERT INTO polsz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Szczęśliwy jest ten, kto nie straci wiary we Mnie. ");
INSERT INTO polsz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Gdy oni odeszli, Jezus zaczął mówić do tłumu o Janie: —Kogo chcieliście zobaczyć, idąc na pustynię? Kogoś chwiejnego jak trzcina na wietrze? ");
INSERT INTO polsz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kogo przyszliście obejrzeć? Dobrze ubranego człowieka? Tacy mieszkają w królewskich pałacach, nie na pustyni. ");
INSERT INTO polsz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","A może proroka się spodziewaliście? Zapewniam was, że Jan to nawet ktoś większy niż prorok. ");
INSERT INTO polsz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","To o nim mówi Pismo: „Oto wysyłam przed Tobą mojego posłańca, który przygotuje dla Ciebie drogę”. ");
INSERT INTO polsz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Zapewniam was: Nie urodził się na ziemi człowiek większy od Jana Chrzciciela. A jednak najmniejszy obywatel królestwa niebieskiego jest większy od niego! ");
INSERT INTO polsz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Od czasu pojawienia się Jana, aż do teraz, wielu ludzi usilnie stara się dostać do królestwa niebieskiego. ");
INSERT INTO polsz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Księgi Prawa i proroków zapowiadały co ma się wydarzyć aż do nadejścia Jana. ");
INSERT INTO polsz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Możecie się zgodzić lub nie, ale to właśnie on jest zapowiedzianym Eliaszem. ");
INSERT INTO polsz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kto ma uszy do słuchania, niech słucha uważnie! ");
INSERT INTO polsz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Do kogo można porównać to pokolenie?—kontynuował Jezus. —Do bawiących się na placu dzieci, które narzekają na rówieśników: ");
INSERT INTO polsz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","„Graliśmy wam wesołą melodię, a nie tańczyliście. Zagraliśmy smutną, a nie płakaliście”. ");
INSERT INTO polsz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gdy pojawił się Jan Chrzciciel, nie pił wina i powstrzymywał się od posiłków. Powiedzieli więc: „Jest zniewolony przez demona”. ");
INSERT INTO polsz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Gdy Ja, Syn Człowieczy, jem i piję—mówią: „Co za żarłok i pijak, przyjaciel poborców podatkowych i innych grzeszników!”. No cóż, mądrość poznaje się po wypływających z niej czynach. ");
INSERT INTO polsz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Wtedy zaczął czynić wyrzuty miastom, w których dokonał najwięcej cudów, że mimo to się nie opamiętały. ");
INSERT INTO polsz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Marny wasz los, Korozain i Betsaido! Gdyby cuda, których u was dokonałem, wydarzyły się w zepsutym Tyrze i Sydonie, ich mieszkańcy już dawno by się opamiętali, siedząc w worze pokutnym i popiele. ");
INSERT INTO polsz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wiedzcie, że w dniu sądu Tyrowi i Sydonowi będzie lżej niż wam! ");
INSERT INTO polsz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A ty, Kafarnaum? Chcesz być wywyższone aż do nieba? Upadniesz aż do piekła! Gdyby cuda, które się tu wydarzyły, działy się w Sodomie, przetrwałaby do dziś. ");
INSERT INTO polsz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Wiedz zatem: W dniu sądu Sodomie będzie lżej niż tobie! ");
INSERT INTO polsz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Następnie Jezus modlił się: „Uwielbiam Cię, Ojcze, Panie nieba i ziemi! Ukryłeś bowiem swoją prawdę przed mędrcami i znawcami, a objawiłeś ją prostym ludziom. ");
INSERT INTO polsz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tego właśnie pragnąłeś”. ");
INSERT INTO polsz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","—Ojciec powierzył Mi całą prawdę—wyjaśniał Jezus zebranym. —Nikt nie zna Syna, tylko Ojciec. I nikt nie zna Ojca, tylko Syn oraz ten, komu On zechce Go objawić. ");
INSERT INTO polsz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Przyjdźcie do Mnie wy wszyscy, którzy jesteście zmęczeni i przeciążeni, a ja zapewnię wam odpoczynek! ");
INSERT INTO polsz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Weźcie na siebie moje jarzmo i uczcie się ode Mnie, bo jestem łagodny i pokorny—a wasze dusze odetchną. ");
INSERT INTO polsz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Moje jarzmo jest wygodne, a mój ciężar lekki. ");
INSERT INTO polsz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pewnego razu, w szabat, Jezus szedł przez pole. Idący z Nim uczniowie poczuli głód. Zaczęli więc zrywać kłosy i jeść ziarno. ");
INSERT INTO polsz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Zauważyli to oczywiście faryzeusze i oburzyli się: —Twoi uczniowie robią rzeczy niedozwolone w szabat! ");
INSERT INTO polsz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","—Czy nie czytaliście, co zrobił król Dawid, gdy wraz z towarzyszami podróży poczuł głód?—odpowiedział im Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","—Wszedł do świątyni i wziął dla siebie oraz swoich towarzyszy poświęcony chleb, który wolno było jeść tylko kapłanom. ");
INSERT INTO polsz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Czy nie czytaliście w Prawie Mojżesza, że kapłani, pracujący w szabat w świątyni, łamią nakaz odpoczynku, a mimo to są niewinni? ");
INSERT INTO polsz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mówię wam: Macie tu do czynienia z czymś ważniejszym niż świątynia! ");
INSERT INTO polsz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Gdybyście wiedzieli, co znaczą słowa: „Pragnę waszej miłości, a nie ofiar”, wówczas nie potępialibyście niewinnych. ");
INSERT INTO polsz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ja, Syn Człowieczy, mam władzę nad szabatem. ");
INSERT INTO polsz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Następnie udał się stamtąd do synagogi. ");
INSERT INTO polsz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Znajdował się tam człowiek ze sparaliżowaną ręką, faryzeusze zapytali więc Jezusa: —Czy taką pracę, jak uzdrawianie, również można wykonywać w szabat?—szukali bowiem pretekstu do oskarżenia Go. ");
INSERT INTO polsz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","—Czy jeśli któraś z waszych owiec wpadłaby w szabat do dołu, to nie wyciągnęlibyście jej?—zapytał Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","—O ile bardziej cenny jest człowiek! Oczywiście, że w szabat wolno czynić dobro. ");
INSERT INTO polsz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","—Wyciągnij rękę!—zwrócił się do chorego. Ten posłuchał i natychmiast jego ręka stała się równie zdrowa jak druga. ");
INSERT INTO polsz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Wtedy faryzeusze odeszli i zaczęli się naradzać, jak Go zabić. ");
INSERT INTO polsz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","On jednak poznał ich plany i opuścił synagogę. Tłum podążył za Nim i wszyscy chorzy zostali uzdrowieni. ");
INSERT INTO polsz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Zabronił im jednak opowiadać o tym innym. ");
INSERT INTO polsz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","W ten sposób spełniło się proroctwo Izajasza: ");
INSERT INTO polsz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","„To jest mój Sługa, którego wybrałem, mój ukochany, w którym mam upodobanie! Dam Mu swojego Ducha, by sądził narody. ");
INSERT INTO polsz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nie będzie się sprzeczał ani krzyczał, nikt nie usłyszy Jego podniesionego głosu. ");
INSERT INTO polsz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","On nie dołamie nawet nadłamanej trzciny ani nie zgasi wątłego płomyka. Zwycięsko przeprowadzi swój sąd, ");
INSERT INTO polsz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","a Jego imię będzie źródłem nadziei dla narodów”. ");
INSERT INTO polsz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Przyprowadzono wtedy do Jezusa człowieka niemego i ślepego—zniewolonego przez demona. Jezus uzdrowił go, przywracając mu wzrok i mowę, ");
INSERT INTO polsz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","a cały tłum wpadł w podziw, mówiąc: —Czyż On nie jest Mesjaszem, potomkiem króla Dawida? ");
INSERT INTO polsz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Gdy faryzeusze dowiedzieli się o tym cudzie, stwierdzili: —Wypędza demony, bo Belzebub, władca demonów, mu w tym pomaga. ");
INSERT INTO polsz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","—Każde królestwo, które jest wewnętrznie skłócone, upadnie—odparł Jezus, znając ich myśli. —I żadne miasto ani dom nie przetrwają, jeśli panuje w nich niezgoda. ");
INSERT INTO polsz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jeśli szatan wypędza szatana, to zwalcza siebie samego. Jak więc jego królestwo może przetrwać? ");
INSERT INTO polsz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Skoro ja wypędzam demony mocą Belzebuba, to dzięki komu robią to wasi synowie? To oni was osądzą! ");
INSERT INTO polsz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Lecz jeśli wypędzam demony mocą Ducha Bożego, znaczy to, że przyszło do was królestwo Boże. ");
INSERT INTO polsz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Jak można wejść do domu siłacza i okraść go, jeśli się go najpierw nie obezwładni? Dopiero wtedy można zabrać jego rzeczy. ");
INSERT INTO polsz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kto nie jest po mojej stronie, jest przeciwko Mnie. A kto ze Mną nie zbiera, ten rozprasza. ");
INSERT INTO polsz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Dlatego ostrzegam: Każdy grzech i bluźnierstwo mogą być przebaczone, lecz bluźnierstwo przeciwko Duchowi Świętemu nie będzie przebaczone! ");
INSERT INTO polsz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jeśli ktoś powiedziałby coś przeciwko Mnie, Synowi Człowieczemu, może otrzymać przebaczenie. Ale jeśli ktoś powiedziałby coś przeciwko Duchowi Świętemu, nie otrzyma przebaczenia ani w tym, ani w przyszłym życiu. ");
INSERT INTO polsz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Albo uznajcie, że drzewo jest dobre—i wtedy daje dobry owoc, albo uznajcie, że jest złe—a wtedy i jego owoc jest zły. Drzewo rozpoznaje się przecież po owocach. ");
INSERT INTO polsz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Jesteście podli! Zresztą jak wy, źli ludzie, możecie mówić coś dobrego? Przecież usta, gdy mówią, czerpią z serca. ");
INSERT INTO polsz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Człowiek dobry wyciąga ze swojego skarbca dobre rzeczy, a człowiek zły—złe rzeczy. ");
INSERT INTO polsz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ostrzegam was: W dniu sądu ludzie zdadzą sprawę z każdego niepotrzebnego słowa, które wypowiedzieli. ");
INSERT INTO polsz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Na podstawie twoich własnych słów zostaniesz uniewinniony albo skazany! ");
INSERT INTO polsz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pewnego dnia kilku przywódców religijnych z ugrupowania faryzeuszy powiedziało do Jezusa: —Nauczycielu! Chcemy, abyś dokonał jakiegoś szczególnego cudu. ");
INSERT INTO polsz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","—To złe i niewierne Bogu pokolenie domaga się cudu!—odpowiedział Jezus. —Ale nie zobaczy go, z wyjątkiem znaku proroka Jonasza. ");
INSERT INTO polsz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tak jak Jonasz przebywał w brzuchu wielkiej ryby trzy dni i trzy noce, tak też Ja, Syn Człowieczy, pozostanę w ziemi trzy dni i trzy noce. ");
INSERT INTO polsz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mieszkańcy Niniwy podczas sądu wystąpią z oskarżeniem przeciw temu pokoleniu. Bo oni opamiętali się, słuchając Jonasza, a do was mówi ktoś o wiele większy niż on. ");
INSERT INTO polsz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Również królowa Południa powstanie na sądzie i oskarży to pokolenie. Ona przybyła z końca świata, by słuchać mądrości Salomona. Wy zaś macie przed sobą kogoś większego niż on. ");
INSERT INTO polsz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jezus kontynuował: —Gdy demon wyjdzie z człowieka, błąka się po pustkowiach, szukając wytchnienia, ale go tam nie znajduje. ");
INSERT INTO polsz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Wówczas mówi sobie: „Wrócę do mojego domu, z którego wyszedłem”. Przychodzi więc i widzi, że dom nie jest zajęty, że jest wysprzątany i ozdobiony. ");
INSERT INTO polsz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Przyprowadza więc ze sobą siedem innych, gorszych od siebie demonów i razem zamieszkują. A wtedy stan takiego człowieka jest o wiele gorszy niż na początku. Podobnie będzie i z tym złym pokoleniem. ");
INSERT INTO polsz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Podczas gdy Jezus przemawiał do tłumu, na zewnątrz domu czekała Jego matka i bracia. Chcieli z Nim porozmawiać. ");
INSERT INTO polsz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ktoś powiadomił więc Jezusa: —Twoja matka i bracia czekają na zewnątrz i chcą z Tobą porozmawiać. ");
INSERT INTO polsz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","—Kto jest moją matką i moimi braćmi?—zapytał Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","I wskazując na uczniów, rzekł: —Oto moja matka i moi bracia! ");
INSERT INTO polsz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Moim bratem i siostrą, i matką jest każdy, kto wypełnia wolę mojego Ojca w niebie. ");
INSERT INTO polsz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jeszcze tego samego dnia Jezus wyszedł z domu i usiadł nad jeziorem, ");
INSERT INTO polsz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","gdzie wkrótce zgromadziły się ogromne tłumy. Wsiadł więc do łodzi, a ludzie pozostali na brzegu. ");
INSERT INTO polsz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Zaczął ich wtedy nauczać posługując się przypowieściami: —Pewien rolnik postanowił zasiać ziarno. ");
INSERT INTO polsz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Gdy rozsiewał je na polu, niektóre nasiona upadły na udeptaną ścieżkę. Zaraz przyleciały ptaki i wydziobały je. ");
INSERT INTO polsz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Inne upadły na cienką warstwę gleby, pod którą była skała. ");
INSERT INTO polsz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Te, choć szybko wyrosły, wkrótce zwiędły w słonecznym upale i zginęły, ponieważ w płytkiej glebie ich korzenie nie znalazły dosyć wody. ");
INSERT INTO polsz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Jeszcze inne upadły między chwasty i niebawem zostały przez nie zagłuszone. ");
INSERT INTO polsz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Niektóre jednak trafiły na dobrą glebę i dały po sto, sześćdziesiąt lub trzydzieści ziaren plonu. ");
INSERT INTO polsz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kto ma uszy do słuchania, niech słucha uważnie! ");
INSERT INTO polsz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Uczniowie podeszli do Jezusa i zapytali: —Dlaczego nauczasz ludzi poprzez przypowieści? ");
INSERT INTO polsz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","—Wam dano zrozumieć tajemnice dotyczące królestwa niebieskiego—wyjaśnił. ");
INSERT INTO polsz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","—Kto ma Bożą mądrość, otrzyma jej więcej i będzie opływał w dostatek. A ten, kto jej nie ma, straci nawet tę odrobinę, którą posiada. ");
INSERT INTO polsz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mówię do nich poprzez przypowieści, bo choć widzą i słyszą, niczego nie rozumieją. ");
INSERT INTO polsz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Wypełnia się więc na nich proroctwo Izajasza: „Będziecie słuchać, lecz nie zrozumiecie, będziecie patrzeć, lecz nie zobaczycie. ");
INSERT INTO polsz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ludzie ci mają twarde serca, zapchane uszy i zmrużone oczy —nic nie widzą, nic nie słyszą i niczego nie rozumieją. Dlatego nie chcą się opamiętać i zostać przeze Mnie uzdrowieni”. ");
INSERT INTO polsz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Bóg was ogromnie wyróżnił, pozwalając wam to wszystko widzieć i słyszeć—kontynuował Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Zapewniam was, że w przeszłości wielu proroków i innych ludzi kochających Boga pragnęło zobaczyć i usłyszeć to, co wy, ale nie mogli. ");
INSERT INTO polsz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Teraz poznajcie znaczenie przypowieści o siewcy. ");
INSERT INTO polsz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Gdy ktoś słucha słów o królestwie i nie rozumie ich, przychodzi do niego szatan i wykrada to, co zapadło w jego sercu. Tak jest z ziarnem posianym na udeptanej ścieżce. ");
INSERT INTO polsz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ziarno na gruncie skalistym oznacza tego, kto słucha i z radością przyjmuje słowo. ");
INSERT INTO polsz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Brak mu jednak mocnych korzeni. Jest niestały i w obliczu trudności lub prześladowań z powodu słowa załamuje się. ");
INSERT INTO polsz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ziarnem posianym wśród chwastów jest człowiek, który słucha słowa, ale zmartwienia i pogoń za bogactwem zagłuszają je, tak że nie przynosi ono w jego życiu żadnego plonu. ");
INSERT INTO polsz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Dobra gleba natomiast to człowiek, który słucha słowa, rozumie je i wydaje obfity plon: sto, sześćdziesiąt lub trzydzieści razy większy. ");
INSERT INTO polsz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Potem Jezus przedstawił kolejną przypowieść: —Królestwo niebieskie podobne jest do człowieka, który posiał na polu dobre ziarno. ");
INSERT INTO polsz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lecz gdy wszyscy spali, zakradł się jego wróg i między pszenicę posiał chwasty. ");
INSERT INTO polsz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Gdy nasiona wzeszły i zaczęły pojawiać się kłosy, wyrosły także chwasty. ");
INSERT INTO polsz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Wówczas przyszli do właściciela pracownicy i powiedzieli: „Czy nie posiałeś dobrego ziarna? Skąd w takim razie na polu wzięły się chwasty?”. ");
INSERT INTO polsz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","„Musiał to zrobić mój nieprzyjaciel”—wyjaśnił. „Czy więc chcesz, abyśmy poszli i usunęli chwasty?”—zapytali pracownicy. ");
INSERT INTO polsz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","„Nie”—odpowiedział—„Przypadkiem moglibyście powyrywać zboże. ");
INSERT INTO polsz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Niech rosną razem aż do żniw, a wtedy powiem żniwiarzom: Zbierzcie najpierw chwasty—w wiązki przeznaczone do spalenia, a pszenicę zwieźcie do magazynów”. ");
INSERT INTO polsz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jeszcze inną przypowieść opowiedział im Jezus: —Królestwo niebieskie jest podobne do ziarna gorczycy, które rolnik zasiał na polu. ");
INSERT INTO polsz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mimo że jest ono chyba najmniejsze ze wszystkich nasion, wyrasta na krzew zaliczany do największych, a na jego rozłożystych gałęziach ptaki budują sobie gniazda. ");
INSERT INTO polsz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Przedstawił im też taką przypowieść: —Królestwo niebieskie jest podobne do kwasu chlebowego, który kobieta zmieszała z całym workiem mąki i który przeniknął całe ciasto. ");
INSERT INTO polsz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Cokolwiek Jezus mówił do tłumów, posługiwał się przypowieściami. Inaczej nie nauczał. ");
INSERT INTO polsz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","W ten sposób miały się wypełnić słowa proroka: „Będę nauczać w przypowieściach, opowiem o tajemnicach ukrytych od początku świata”. ");
INSERT INTO polsz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Potem opuścił zebranych i udał się do domu. Wówczas uczniowie podeszli do Niego, prosząc: —Wyjaśnij nam przypowieść o chwastach na polu. ");
INSERT INTO polsz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","—Siejącym dobre ziarno jestem Ja, Syn Człowieczy—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","—Polem jest świat, a dobre ziarno to ci, którzy należą do królestwa. Chwasty to ci, którzy należą do diabła, ");
INSERT INTO polsz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","a nieprzyjacielem, który je posiał, jest sam diabeł. Żniwa to koniec świata, a żniwiarze to aniołowie. ");
INSERT INTO polsz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Koniec czasów podobny będzie do zbioru i spalenia chwastów. ");
INSERT INTO polsz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ja, Syn Człowieczy, wyślę wtedy swoich aniołów—a oni usuną z królestwa tych, którzy czynili zło i prowadzili do zła innych. ");
INSERT INTO polsz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Wrzucą ich do rozpalonego pieca. Tam będzie lament i rozpacz. ");
INSERT INTO polsz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","A ludzie prawi zabłysną jak słońce w królestwie swojego Ojca. Kto ma uszy do słuchania, niech słucha uważnie! ");
INSERT INTO polsz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Królestwo niebieskie podobne jest do skarbu znalezionego na polu—mówił Jezus. —Ten, kto go odkrył, ukrył go ponownie i z radości poszedł sprzedać wszystko, co posiadał, aby kupić to pole. ");
INSERT INTO polsz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Królestwo niebieskie podobne jest również do kolekcjonera pięknych pereł. ");
INSERT INTO polsz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Gdy natrafił na niezwykle cenną perłę, poszedł sprzedać cały majątek i kupił ją. ");
INSERT INTO polsz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Królestwo niebieskie można również porównać do sieci rzuconej w morze, w którą wpadają różne ryby. ");
INSERT INTO polsz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Gdy już się napełni, wyciąga się ją na brzeg i przebiera ryby: dobre kładzie się do skrzyni, a niedobre się wyrzuca. ");
INSERT INTO polsz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Podobnie będzie przy końcu czasów—aniołowie oddzielą ludzi złych od prawych. ");
INSERT INTO polsz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","I wrzucą tych pierwszych w ogień, gdzie będzie lament i rozpacz. ");
INSERT INTO polsz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Czy zrozumieliście? —Tak—odpowiedzieli uczniowie. ");
INSERT INTO polsz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jezus kontynuował: —Każdy przywódca religijny, znawca Pism, który staje się uczniem królestwa niebios, jest podobny do bogatego właściciela. Podobnie jak on, wydobywa ze swojego skarbca stare i nowe kosztowności. ");
INSERT INTO polsz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Gdy Jezus skończył tam nauczać, ");
INSERT INTO polsz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","powrócił w rodzinne strony i przemawiał w tamtejszej synagodze. A słuchający ze zdumieniem powtarzali: —Skąd u niego taka mądrość i moc? ");
INSERT INTO polsz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Przecież jest synem cieśli! Znamy dobrze jego matkę, Marię, i braci: Jakuba, Józefa, Szymona i Judę. ");
INSERT INTO polsz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Przecież i jego siostry tu są?! Skąd się więc u niego to wszystko wzięło? ");
INSERT INTO polsz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","I nie mogli się z tym pogodzić. Wtedy Jezus powiedział: —Prorok może cieszyć się poważaniem wszędzie, z wyjątkiem swojego miasta i rodziny. ");
INSERT INTO polsz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","I z powodu ich niewiary nie dokonał tam wielu cudów. ");
INSERT INTO polsz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Gdy Herod, zarządca prowincji, usłyszał wieści o Jezusie, rzekł do swoich dworzan: ");
INSERT INTO polsz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","—To musi być zmartwychwstały Jan Chrzciciel. Dlatego potrafi czynić takie cuda. ");
INSERT INTO polsz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Wcześniej bowiem to właśnie on kazał aresztować i uwięzić Jana. A stało się to z powodu Herodiady, żony jego brata Filipa. ");
INSERT INTO polsz_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jan bowiem ciągle mu wypominał: „Nie wolno ci żyć z żoną swojego brata!”. ");
INSERT INTO polsz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod postanowił zabić Jana, bał się jednak tłumów, które uważały go za proroka. ");
INSERT INTO polsz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Zdarzyło się, że podczas uczty urodzinowej Heroda wystąpiła córka Herodiady, a jej taniec bardzo mu się spodobał. ");
INSERT INTO polsz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","I uroczyście przyrzekł spełnić każde jej życzenie. ");
INSERT INTO polsz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Namówiona przez matkę, dziewczyna poprosiła: —Daj mi na tacy głowę Jana Chrzciciela. ");
INSERT INTO polsz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Zasmuciło to króla, lecz ze względu na przysięgę złożoną w obecności gości rozkazał spełnić tę prośbę. ");
INSERT INTO polsz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ścięto więc Jana w więzieniu, ");
INSERT INTO polsz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","a jego głowę przyniesiono na tacy dziewczynie, ona zaś oddała ją matce. ");
INSERT INTO polsz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Uczniowie Jana zabrali jego ciało, pogrzebali je i powiadomili o wszystkim Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na wieść o tym Jezus odpłynął łodzią w odludne miejsce. Chciał być sam. Ludzie wypatrzyli Go jednak i z różnych miasteczek podążyli za Nim pieszo. ");
INSERT INTO polsz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Wychodząc więc z łodzi, Jezus znów zastał tłumy ludzi. Poruszony współczuciem uzdrowił wszystkich obecnych tam chorych. ");
INSERT INTO polsz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pod wieczór uczniowie zwrócili się do Niego: —Każ ludziom rozejść się do pobliskich wiosek i osad. Niech sobie kupią coś do jedzenia, bo na tym pustkowiu nie ma żywności, a robi się już późno. ");
INSERT INTO polsz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Nie muszą odchodzić. —odparł Jezus—Wy dajcie im jeść! ");
INSERT INTO polsz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Ale co?!—wykrzyknęli. —Nic nie mamy! Tylko pięć chlebów i dwie ryby! ");
INSERT INTO polsz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Przynieście je więc tutaj—powiedział. ");
INSERT INTO polsz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Polecił ludziom usiąść na trawie, a sam wziął pięć chlebów i dwie ryby. Spojrzał w niebo, podziękował Bogu i podzielił chleb. Podał go uczniom, a oni ludziom. ");
INSERT INTO polsz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","W ten sposób wszyscy najedli się do syta i zebrano jeszcze dwanaście pełnych koszy resztek, ");
INSERT INTO polsz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","choć w posiłku tym brało udział około pięciu tysięcy samych tylko mężczyzn—nie licząc kobiet i dzieci. ");
INSERT INTO polsz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Zaraz potem Jezus nakazał uczniom, aby przeprawili się łodzią na drugą stronę jeziora, dokąd On sam miał przybyć później. Chciał bowiem pozostać na miejscu do czasu, aż ludzie rozejdą się do domów. ");
INSERT INTO polsz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Gdy wszyscy już odeszli, wszedł na wzgórze, aby się modlić. Zapadł zmrok i Jezus był zupełnie sam. ");
INSERT INTO polsz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tymczasem łódź uczniów była już daleko od brzegu. Miotały nią fale, bo wiatr był przeciwny. ");
INSERT INTO polsz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Około trzeciej nad ranem poszedł więc do nich po wodzie. ");
INSERT INTO polsz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Przerażeni uczniowie, widząc że idzie po wodzie, krzyknęli: —To duch! ");
INSERT INTO polsz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","—Spokojnie! Nie bójcie się, to Ja!—szybko odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","—Panie, jeśli to naprawdę Ty, każ mi przyjść do siebie po wodzie—zawołał w odpowiedzi Piotr. ");
INSERT INTO polsz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Dobrze, chodź!—rzekł. Piotr wyszedł z łodzi, zaczął iść po wodzie i zbliżył się do Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lecz gdy poczuł silne uderzenie wiatru, przestraszył się i zaczął tonąć. —Panie, ratuj mnie!—krzyczał. ");
INSERT INTO polsz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jezus natychmiast wyciągnął do niego rękę i wydobył go z wody. —Gdzie jest twoja wiara? Dlaczego zwątpiłeś?—zapytał Piotra. ");
INSERT INTO polsz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Gdy weszli do łodzi, wiatr nagle ucichł. ");
INSERT INTO polsz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wtedy uczniowie padli przed Jezusem na twarz. —Naprawdę jesteś Synem Boga!—wyznali. ");
INSERT INTO polsz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Niebawem przypłynęli do krainy Genezaret. ");
INSERT INTO polsz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tamtejsi mieszkańcy rozpoznali Jezusa i po całej okolicy rozeszła się wiadomość o Jego przybyciu. Przyprowadzono do Niego wszystkich chorych ");
INSERT INTO polsz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","i proszono Go, aby pozwolił im przynajmniej dotknąć swojego płaszcza. A wszyscy, którzy Go dotknęli, odzyskali zdrowie. ");
INSERT INTO polsz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kilku faryzeuszy i przywódców religijnych, przybyłych z Jerozolimy, zwróciło się wtedy do Jezusa z pytaniem: ");
INSERT INTO polsz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Dlaczego Twoi uczniowie nie przestrzegają naszych odwiecznych zwyczajów i nie dokonują obrzędu obmycia rąk przed jedzeniem? ");
INSERT INTO polsz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","—A dlaczego wy, w imię własnych tradycji, łamiecie nakazy Boga?—zapytał Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","—Bóg przecież powiedział: „Szanuj rodziców” oraz „Kto znieważa ojca lub matkę, musi umrzeć”. ");
INSERT INTO polsz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lecz wy twierdzicie, że jeśli ktoś powie ojcu lub matce: „Niestety, nie mogę wam pomóc, bo przecież to, co miałem dla was, oddałem w darze Bogu do Jego świątyni”— ");
INSERT INTO polsz_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nie musi się o nich troszczyć. W ten sposób wasza tradycja unieważnia Boży nakaz. ");
INSERT INTO polsz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Obłudnicy! Dobrze was określił prorok Izajasz, mówiąc: ");
INSERT INTO polsz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","„Ludzie ci bardzo pięknie o Mnie mówią, ale w ich sercach nie ma miłości do Mnie. ");
INSERT INTO polsz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na próżno jednak oddają Mi cześć. Nauczają bowiem przykazań, które sami wymyślili.” ");
INSERT INTO polsz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Następnie zawołał zgromadzonych i rzekł: —Słuchajcie uważnie i postarajcie się to zrozumieć: ");
INSERT INTO polsz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nie to, co wchodzi do ust, ale to, co z nich wychodzi, sprawia, że człowiek jest nieczysty. ");
INSERT INTO polsz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","—Czy wiesz, że Twoje słowa uraziły faryzeuszy?—powiedzieli Mu uczniowie. ");
INSERT INTO polsz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","—Każda roślina, której nie posadził mój Ojciec w niebie, zostanie usunięta. ");
INSERT INTO polsz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nie przejmujcie się nimi. To ślepi przewodnicy ślepych! A jeśli ślepy prowadzi ślepego, to obaj wpadną w dół. ");
INSERT INTO polsz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","—Wyjaśnij nam ten przykład o pokarmie—poprosił wtedy Piotr. ");
INSERT INTO polsz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","—Wy też jeszcze tego nie rozumiecie?—zapytał Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","—Nie wiecie, że wszystko, co się wkłada do ust, trafia do żołądka, po czym zostaje wydalone? ");
INSERT INTO polsz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Natomiast to, co wychodzi z ust, pochodzi z serca. I to właśnie zanieczyszcza człowieka. ");
INSERT INTO polsz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bo z serca pochodzą złe myśli, prowadzące do morderstw, niewierności małżeńskiej, rozwiązłości, kradzieży, kłamstw i pomówień. ");
INSERT INTO polsz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","To właśnie sprawia, że człowiek staje się nieczysty. Jedzenie nieumytymi rękami nie ma tu nic do rzeczy. ");
INSERT INTO polsz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jezus opuścił tamte okolice i udał się na tereny Tyru i Sydonu. ");
INSERT INTO polsz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tam przyszła do Niego pewna kobieta pochodzenia kananejskiego, a więc należąca do pogan, których Żydzi mają w pogardzie. Z rozpaczą w głosie zawołała: —Panie, potomku króla Dawida, zmiłuj się nade mną! Moją córkę opanował zły duch. ");
INSERT INTO polsz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lecz Jezus nie odpowiedział jej ani słowem. Uczniowie zaś namawiali Go: —Odpraw ją, bo nie daje nam spokoju. ");
INSERT INTO polsz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","—Nie zostałem posłany do pogan—odezwał się Jezus do kobiety—ale do zagubionych owiec ze stada Izraela. ");
INSERT INTO polsz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","—Panie, pomóż mi!—nalegała kobieta i błagała Go na kolanach. ");
INSERT INTO polsz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","—Nie jest dobrze odbierać chleb dzieciom i rzucać szczeniętom—odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—To prawda, Panie!—opowiedziała. —Jednak nawet psom trafiają się kawałki, które spadną ze stołu ich właścicieli. ");
INSERT INTO polsz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","—Kobieto! Jak wielka jest twoja wiara!—zawołał Jezus. —Niech się stanie to, czego pragniesz I natychmiast jej córka odzyskała zdrowie. ");
INSERT INTO polsz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Wracając stamtąd, Jezus przyszedł nad Jezioro Galilejskie, wszedł na wzgórze i usiadł. ");
INSERT INTO polsz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","I znów ściągnęły do Niego nieprzebrane tłumy ludzi, prowadzących ze sobą kulawych, niewidomych, głuchoniemych oraz innych niepełnosprawnych i chorych. Kładziono ich przed Jezusem, a On ich uzdrawiał. ");
INSERT INTO polsz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tłum wpadł w podziw i wielbił Boga Izraela widząc jak głuchoniemi mówią, niepełnosprawni wracają do zdrowia, kulawi dobrze chodzą a niewidomi widzą. ");
INSERT INTO polsz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jezus zaś zawołał uczniów i rzekł: —Żal mi tych ludzi! Są tu od trzech dni i nie mają już nic do jedzenia. Jeśli odejdą stąd głodni, mogą zasłabnąć w drodze do domu. ");
INSERT INTO polsz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","—Skąd tu, na pustyni, weźmiemy tyle jedzenia?—spytali uczniowie. ");
INSERT INTO polsz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—A ile macie chleba?—zapytał Jezus. —Siedem bochenków. Mamy też kilka ryb—odparli. ");
INSERT INTO polsz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Wtedy Jezus polecił ludziom, aby usiedli na ziemi. ");
INSERT INTO polsz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sam zaś wziął te siedem chlebów oraz ryby i podziękował za nie Bogu. Następnie połamał je na kawałki i podał uczniom, a oni—ludziom. ");
INSERT INTO polsz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","I tak wszyscy najedli się do syta, a zebranymi resztkami napełniono aż siedem koszy. ");
INSERT INTO polsz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A nakarmionych zostało cztery tysiące samych tylko mężczyzn, nie licząc kobiet i dzieci. ");
INSERT INTO polsz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Potem Jezus rozesłał ludzi do domu, sam zaś wsiadł do łodzi i popłynął w okolice Magadanu. ");
INSERT INTO polsz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pewnego dnia przyszli do Jezusa faryzeusze i saduceusze. Chcąc wystawić Go na próbę, poprosili, by pokazał im jakiś nadzwyczajny znak na niebie. ");
INSERT INTO polsz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","—Gdy zapada wieczór—odparł Jezus—mówicie: Jutro będzie pogoda, bo niebo jest czerwone. ");
INSERT INTO polsz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A z rana mówicie: Niebo jest czerwone i zachmurzone, będzie burza. Trafnie prognozujecie pogodę po wyglądzie nieba, ale znaków czasu nie potraficie rozpoznać! ");
INSERT INTO polsz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","To złe i niewierne Bogu pokolenie domaga się cudu. Ale nie zobaczy go—z wyjątkiem znaku proroka Jonasza. I zostawił ich samych. ");
INSERT INTO polsz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Płynąc na drugi brzeg, uczniowie zorientowali się, że zapomnieli dokupić chleba. ");
INSERT INTO polsz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","—Bądźcie ostrożni i wystrzegajcie się kwasu faryzeuszy i saduceuszy—ostrzegł ich Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ale oni mówili między sobą: —No właśnie, zapomnieliśmy chleba. ");
INSERT INTO polsz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","—Gdzie jest wasza wiara!—odezwał się Jezus, bo wiedział, o czym rozmawiają. —Czemu martwicie się o chleb? ");
INSERT INTO polsz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Niczego nie zrozumieliście? Czy nie pamiętacie tych pięciu tysięcy ludzi, których nakarmiłem pięcioma bochenkami chleba? Ile wtedy zebraliście resztek? ");
INSERT INTO polsz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","A gdy siedmioma bochenkami nakarmiłem cztery tysiące ludzi, to ile jeszcze pozostało? ");
INSERT INTO polsz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nie rozumiecie, że nie mówię o chlebie? Strzeżcie się kwasu faryzeuszy i saduceuszy. ");
INSERT INTO polsz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Wtedy dotarło do nich, że nie mówi o kwasie chlebowym, ale o nauce faryzeuszy i saduceuszy. ");
INSERT INTO polsz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Po przybyciu na tereny Cezarei Filipowej Jezus zadał uczniom następujące pytanie: —Za kogo Mnie, Syna Człowieczego, uważają ludzie? ");
INSERT INTO polsz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—Jedni sądzą, że jesteś Janem Chrzcicielem—odrzekli uczniowie—inni, że Eliaszem, jeszcze inni, że Jeremiaszem albo innym prorokiem. ");
INSERT INTO polsz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—A wy? Za kogo Mnie uważacie?—zapytał ich wprost. ");
INSERT INTO polsz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","—Jesteś Mesjaszem, Synem żywego Boga—odpowiedział Szymon Piotr. ");
INSERT INTO polsz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—Szczęśliwy jesteś Szymonie, synu Jana—odrzekł mu Jezus—bo nie doszedłeś do tego ludzkim rozumowaniem, ale objawił ci to mój Ojciec w niebie. ");
INSERT INTO polsz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Dlatego mówię ci: Ty jesteś Piotr—skała—i na tej skale zbuduję mój Kościół. A bramy piekła nie powstrzymają go. ");
INSERT INTO polsz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","I dam ci klucze do królestwa niebieskiego: Cokolwiek postanowisz na ziemi, będzie postanowione w niebie. A co rozstrzygniesz na ziemi, i będzie rozstrzygnięte w niebie! ");
INSERT INTO polsz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nakazał jednak uczniom, by nikomu nie mówili, że jest Mesjaszem. ");
INSERT INTO polsz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Od tego czasu Jezus zaczął wyraźnie mówić im, że musi pójść do Jerozolimy, że spotkają Go tam straszne cierpienia z rąk starszych, najwyższych kapłanów i przywódców religijnych, że zostanie zabity, ale że trzeciego dnia zmartwychwstanie. ");
INSERT INTO polsz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Wtedy Piotr wziął Go na bok i zaczął upominać: —Ależ Panie! Nie może Cię to spotkać! ");
INSERT INTO polsz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","—Precz, szatanie!—odrzekł Jezus, odwracając się. —Przeszkadzasz mi, bo patrzysz na to jedynie z ludzkiego punktu widzenia i nie jesteś w stanie zrozumieć Bożych planów. ");
INSERT INTO polsz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Potem zwrócił się do uczniów: —Jeśli ktoś chce Mnie naśladować, niech przestanie myśleć wyłącznie o sobie. Niech weźmie swój krzyż i idzie ze Mną. ");
INSERT INTO polsz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Jeśli ktoś chce wygrać życie, przegra je. Ale kto przegra życie ze względu na Mnie, naprawdę je wygra. ");
INSERT INTO polsz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Co z tego, że ktoś zdobędzie cały świat, jeśli po drodze zatraci życie? Czy dla człowieka istnieje coś cenniejszego niż on sam? ");
INSERT INTO polsz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ja, Syn Człowieczy, powrócę tu z aniołami, otoczony chwałą Ojca, i wtedy osądzę każdego na podstawie jego czynów. ");
INSERT INTO polsz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Zapewniam was: Niektórzy z obecnych tu, jeszcze za swego życia zobaczą Mnie, Syna Człowieczego, nadchodzącego ze swoim królestwem. ");
INSERT INTO polsz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sześć dni później Jezus wziął ze sobą na szczyt pewnej góry Piotra, Jakuba i jego brata—Jana. Poza nimi nie było tam nikogo. ");
INSERT INTO polsz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nagle, na ich oczach, przemienił się: Jego twarz zajaśniała jak słońce, a Jego płaszcz stał się olśniewająco biały. ");
INSERT INTO polsz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Potem zjawili się Eliasz i Mojżesz, którzy zaczęli z Nim rozmawiać. ");
INSERT INTO polsz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","—Panie, jak dobrze, że tu jesteśmy!—wykrzyknął Piotr do Jezusa. —Jeśli chcesz, zbuduję trzy szałasy: dla Ciebie, dla Mojżesza i dla Eliasza. ");
INSERT INTO polsz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ale zanim skończył mówić, otoczył ich jasny obłok, z którego rozległ się głos: —Oto mój ukochany Syn, moja największa radość. Słuchajcie Go! ");
INSERT INTO polsz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Słysząc to, uczniowie z wielkim lękiem padli na twarz. ");
INSERT INTO polsz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jezus podszedł do nich, dotknął ich i powiedział: —Wstańcie, nie bójcie się! ");
INSERT INTO polsz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Gdy się rozejrzeli, stwierdzili, że poza Jezusem nie ma już nikogo. ");
INSERT INTO polsz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Schodząc z góry, Jezus nakazał im, aby do czasu Jego zmartwychwstania nikomu nie opowiadali o tym, co widzieli. ");
INSERT INTO polsz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wtedy uczniowi zapytali: —Dlaczego przywódcy religijni twierdzą, że przed przyjściem Mesjasza musi pojawić się Eliasz? ");
INSERT INTO polsz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","—Mają rację—odparł Jezus. —Eliasz musi przyjść i wszystko przygotować. ");
INSERT INTO polsz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mówię wam jednak: On już przyszedł, ale nie rozpoznali go! Co więcej, haniebnie go potraktowali! Również i Mnie, Syna Człowieczego, czeka cierpienie z ich rąk. ");
INSERT INTO polsz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wtedy uczniowie zrozumieli, że Jezus mówił o Janie Chrzcicielu. ");
INSERT INTO polsz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Gdy zeszli z góry, z czekającego już tłumu podszedł do Jezusa jakiś mężczyzna i padł na kolana. ");
INSERT INTO polsz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Panie, zmiłuj się nad moim synem—powiedział. —Cierpi na epilepsję i bardzo się męczy. Często wpada w ogień lub w wodę. ");
INSERT INTO polsz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Przyprowadziłem go do Twoich uczniów, ale nie mogli mu pomóc. ");
INSERT INTO polsz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","—Czemu wciąż nie dowierzacie i jesteście tak przewrotni?—zwrócił się do nich Jezus. —Jak długo jeszcze muszę być z wami, żebyście wreszcie uwierzyli? Przyprowadźcie tu chłopca! ");
INSERT INTO polsz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","I Jezus rozkazał demonowi, a ten opuścił chłopca, który w tej samej chwili odzyskał zdrowie. ");
INSERT INTO polsz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Później, gdy Jezus był sam na sam z uczniami, zapytali Go: —Dlaczego my nie mogliśmy wypędzić tego demona? ");
INSERT INTO polsz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Z powodu waszej małej wiary!—odrzekł Jezus. —Zapewniam was: Gdybyście mieli wiarę choćby jak ziarnko gorczycy, moglibyście rozkazać tej górze: „Przesuń się gdzieś indziej!” i zrobiłaby to. Nie byłoby dla was rzeczy niemożliwych. ");
INSERT INTO polsz_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Takiego rodzaju złych duchów nie uda się wypędzić bez modlitwy i powstrzymywania się od posiłków. ");
INSERT INTO polsz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pewnego dnia, gdy przebywali jeszcze w Galilei, Jezus powiedział: —Ja, Syn Człowieczy, zostanę wkrótce wydany w ręce ludzi, ");
INSERT INTO polsz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","którzy Mnie zabiją, ale trzeciego dnia zmartwychwstanę. Słowa te napełniły uczniów wielkim smutkiem. ");
INSERT INTO polsz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Gdy przybyli do Kafarnaum, podeszli do Piotra poborcy składki świątynnej i zapytali: —Czy wasz Nauczyciel nie płaci składki na rzecz świątyni? ");
INSERT INTO polsz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Oczywiście, że płaci!—odparł Piotr. Następnie poszedł do domu, ale zanim jeszcze zdążył cokolwiek powiedzieć, Jezus zapytał go: —Jak sądzisz, Piotrze, od kogo władcy ściągają podatki i daniny: od własnych obywateli czy od obcych? ");
INSERT INTO polsz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Od obcych—odparł Piotr. —A zatem obywatele są z nich zwolnieni!—rzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","—Aby jednak nikogo nie urazić, idź nad jezioro i zarzuć wędkę. W pysku pierwszej złapanej ryby znajdziesz monetę. Weź ją i zapłać składkę za nas obu. ");
INSERT INTO polsz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","W tym samym czasie uczniowie zwrócili się do Jezusa z pytaniem: —Kto z nas będzie najważniejszy w królestwie niebios? ");
INSERT INTO polsz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jezus zawołał jakieś dziecko, postawił je pośrodku ");
INSERT INTO polsz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","i powiedział: —Zapewniam was, że jeśli się nie nawrócicie i nie staniecie się jak dzieci, nie wejdziecie do królestwa niebieskiego. ");
INSERT INTO polsz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Największy w nim będzie ten, kto stanie się jak to małe dziecko. ");
INSERT INTO polsz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","A każdy, kto przyjmie nawet takie małe dziecko ze względu na Mnie, ten Mnie przyjmie. ");
INSERT INTO polsz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Lecz jeśli z czyjegoś powodu upadnie choćby jeden z najmniejszych moich uczniów, to lepiej byłoby, aby takiemu człowiekowi przywiązano do szyi kamień młyński i utopiono go w morzu. ");
INSERT INTO polsz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Zepsucie jest nieszczęściem świata! Musi ono nadejść, ale marny los człowieka, który nakłania innych do grzechu. ");
INSERT INTO polsz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jeśli więc twoja własna ręka albo noga skłania cię do grzechu, odetnij ją i wyrzuć! Lepiej kalekim wejść do nieba, niż mając obie ręce i nogi zostać wrzuconym do piekła. ");
INSERT INTO polsz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A jeśli twoje oko skłania cię do grzechu, wyłup je i wyrzuć! Lepiej z jednym okiem wejść do nieba niż z dwojgiem zostać wrzuconym do piekła. ");
INSERT INTO polsz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Uważajcie, aby nie zlekceważyć nikogo z tych najmniejszych! Wiedzcie, że ich aniołowie stoją w niebie w pobliżu mego Ojca. ");
INSERT INTO polsz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ja, Syn Człowieczy, przyszedłem ocalić tych, którzy byli zgubieni. ");
INSERT INTO polsz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Zastanówcie się! Jeśli ktoś ma sto owiec i zgubi mu się jedna, czy nie zostawia pozostałych dziewięćdziesięciu dziewięciu i nie wyrusza szukać zagubionej? ");
INSERT INTO polsz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A gdy ją znajdzie, to zapewniam was, że cieszy się tą jedną bardziej niż dziewięćdziesięcioma dziewięcioma, które nie zginęły! ");
INSERT INTO polsz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Podobnie Ojciec wasz w niebie nie chce, aby zginął choć jeden z tych najmniejszych. ");
INSERT INTO polsz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Gdy inny wierzący zgrzeszy—kontynuował Jezus—idź do niego i w cztery oczy upomnij go. Jeśli cię posłucha, odzyskałeś go! ");
INSERT INTO polsz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","A jeśli cię nie posłucha, weź ze sobą jeszcze jednego lub dwóch świadków, aby mogli poświadczyć jak się przedstawia sprawa. ");
INSERT INTO polsz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jeśli również ich nie posłucha, przedstaw to kościołowi. A jeżeli nie usłucha nawet kościoła, traktuj go jak niewierzącego. ");
INSERT INTO polsz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Zapewniam was: Cokolwiek postanowicie na ziemi, będzie postanowione w niebie, i cokolwiek rozstrzygniecie na ziemi, zostanie rozstrzygnięte w niebie. ");
INSERT INTO polsz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Jeszcze raz was zapewniam: Jeśli dwaj z was, tu na ziemi, jednomyślnie będą się o coś modlić, mój Ojciec w niebie spełni ich prośbę. ");
INSERT INTO polsz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gdy dwóch albo trzech zbierze się w Moim imieniu, Ja będę wśród nich. ");
INSERT INTO polsz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Wtedy zapytał Go Piotr: —Panie, ile razy mam wybaczyć przyjacielowi, jeśli w czymś zawini? Czy wystarczy, gdy zrobię to siedem razy? ");
INSERT INTO polsz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","—Nie siedem, lecz siedemdziesiąt razy siedem!—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","—Królestwo niebieskie można porównać do władcy, który postanowił rozliczyć się ze sługami. ");
INSERT INTO polsz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","W trakcie kontroli przyprowadzono do niego dłużnika, winnego mu sto milionów. ");
INSERT INTO polsz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","A ponieważ nie był w stanie oddać długu, władca kazał go sprzedać w niewolę razem z żoną, dziećmi i wszystkim, co posiadał. ");
INSERT INTO polsz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Lecz on padł przed nim na twarz i błagał: „Panie, okaż mi trochę cierpliwości, a wszystko spłacę!”. ");
INSERT INTO polsz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wówczas władca zlitował się nad sługą, umorzył mu cały dług i puścił go wolno. ");
INSERT INTO polsz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","On zaś po drodze odszukał współpracownika, który był mu winien równowartość dniówki. Chwycił go za gardło i zawołał: „Oddaj, coś winien!”. ");
INSERT INTO polsz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Współpracownik upadł przed nim i błagał: „Okaż mi trochę cierpliwości, a spłacę dług!”. ");
INSERT INTO polsz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ale ten nie chciał czekać. Kazał go wtrącić do więzienia, aż do czasu spłacenia długu. ");
INSERT INTO polsz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Zobaczyli to koledzy tego biedaka i bardzo się zmartwili. Poszli do władcy i zdali mu ze wszystkiego relację. ");
INSERT INTO polsz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ten, gdy to usłyszał, wezwał do siebie pierwszego sługę i powiedział: „Ty łajdaku! Umorzyłem ci cały dług, bo mnie o to błagałeś. ");
INSERT INTO polsz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Czy więc i ty nie mogłeś zlitować się nad twoim dłużnikiem—jak ja nad tobą?”. ");
INSERT INTO polsz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","I rozgniewany wtrącił go do więzienia, gdzie miał pozostać do czasu spłacenia całego długu. ");
INSERT INTO polsz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tak właśnie mój Ojciec w niebie postąpi z wami, jeśli z całego serca nie będziecie przebaczać swoim przyjaciołom. ");
INSERT INTO polsz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Gdy Jezus skończył nauczanie, opuścił Galileę i skierował się do Judei na tereny leżące po drugiej stronie Jordanu. ");
INSERT INTO polsz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Podążały za Nim tłumy, a On uzdrawiał chorych. ");
INSERT INTO polsz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Zjawili się tam także faryzeusze i—chcąc Go sprowokować do jakiejś niefortunnej wypowiedzi—zapytali: —Czy zezwalasz na rozwody z dowolnego powodu? ");
INSERT INTO polsz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","—Czyżbyście nie czytali w Piśmie, że na początku „Bóg stworzył mężczyznę i kobietę”?—odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","—Bóg powiedział również: „Dlatego mężczyzna opuści rodziców i złączy się z żoną, tak że ci dwoje staną się jednym ciałem”. ");
INSERT INTO polsz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nie są więc już dwojgiem ludzi, lecz jednym ciałem! Niech człowiek nie rozdziela tego, co złączył sam Bóg! ");
INSERT INTO polsz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","—Dlaczego więc Mojżesz nakazał wręczyć żonie dokument rozwodowy i odprawić ją?—kontynuowali. ");
INSERT INTO polsz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","—Mojżesz pozwolił wam na rozwód tylko z powodu waszych zatwardziałych serc—odparł Jezus. —Ale nie taki był Boży zamiar. ");
INSERT INTO polsz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Dlatego mówię wam: Jeśli ktoś rozwodzi się żoną (z wyjątkiem przypadku rozwiązłości seksualnej) i poślubia inną kobietę, dopuszcza się grzechu niewierności małżeńskiej. ");
INSERT INTO polsz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Na to uczniowie rzekli do Jezusa: —Jeśli sprawa wygląda aż tak poważnie, to nie warto się żenić! ");
INSERT INTO polsz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","—Nie wszyscy mogą pozostać samotni—rzekł Jezus—tylko ci, którzy mają taki dar. ");
INSERT INTO polsz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Niektórzy są samotni, bo od urodzenia są niezdolni do małżeństwa. Inni pozostają samotni, bo ludzie uczynili ich niezdolnymi do tego. A jeszcze inni decydują się żyć samotnie ze względu na królestwo niebieskie. Kto może, niech stara się to pojąć. ");
INSERT INTO polsz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Przyprowadzano też do Jezusa dzieci, aby je pobłogosławił i modlił się o nie. Uczniowie jednak odsuwali je, nie chcąc, aby Mu przeszkadzały. ");
INSERT INTO polsz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ale Jezus powiedział: —Nie zabraniajcie dzieciom przychodzić do Mnie, gdyż do takich jak one należy królestwo niebieskie. ");
INSERT INTO polsz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Powiedziawszy to, pobłogosławił je i ruszył dalej. ");
INSERT INTO polsz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pewnego dnia podszedł do Jezusa jakiś człowiek i zapytał: —Nauczycielu, co dobrego mam uczynić, aby otrzymać życie wieczne? ");
INSERT INTO polsz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—Dlaczego pytasz Mnie o dobro? Naprawdę dobry jest tylko Bóg. Jeśli chcesz otrzymać życie wieczne, wypełniaj Jego przykazania. ");
INSERT INTO polsz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—Ale które?—zapytał rozmówca. —„Nie zabijaj, bądź wierny w małżeństwie, nie kradnij, nie składaj fałszywych zeznań, ");
INSERT INTO polsz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","szanuj rodziców!” oraz „Kochaj innych ludzi jak samego siebie!”—odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Nigdy nie przekroczyłem żadnego z nich—odparł młody człowiek. —Czego jeszcze mi brakuje? ");
INSERT INTO polsz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Jeśli chcesz być doskonały—rzekł Jezus—idź, sprzedaj swój majątek, a pieniądze rozdaj biednym. To zapewni ci skarb w niebie. Potem wróć i chodź ze Mną. ");
INSERT INTO polsz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Słysząc to, młody człowiek spochmurniał i odszedł zasmucony; był bowiem bardzo bogaty. ");
INSERT INTO polsz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jezus rzekł wtedy do uczniów: —Oto jak trudno jest bogatym wejść do królestwa niebieskiego. ");
INSERT INTO polsz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Łatwiej wielbłądowi przejść przez ucho od igły, niż bogatemu człowiekowi wejść do królestwa Bożego. ");
INSERT INTO polsz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Słowa te poważnie zastanowiły uczniów: —Kto więc może być zbawiony?—pytali. ");
INSERT INTO polsz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jezus spojrzał na nich i rzekł: —To przekracza ludzkie możliwości, ale dla Boga wszystko jest możliwe. ");
INSERT INTO polsz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","—My zostawiliśmy wszystko i poszliśmy za Tobą—odezwał się Piotr. —Co więc z nami będzie? ");
INSERT INTO polsz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","—Zapewniam was—odpowiedział Jezus—że w przyszłym świecie, gdy Ja, Syn Człowieczy, zasiądę na tronie chwały, wy, moi uczniowie, zasiądziecie na dwunastu tronach, by sądzić dwanaście rodów Izraela. ");
INSERT INTO polsz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","A każdy, kto z miłości do Mnie pozostawi dom, braci, siostry, ojca, matkę, żonę, dzieci albo posiadłości, otrzyma w zamian sto razy tyle i odziedziczy życie wieczne w przyszłym świecie. ");
INSERT INTO polsz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Wtedy wielu ludzi, obecnie uznawanych za wielkich, przestanie się liczyć, a inni, teraz uznawani za najmniejszych, będą wielkimi. ");
INSERT INTO polsz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jezus kontynuował: —Królestwo niebieskie podobne jest do właściciela winnicy, który o świcie wyszedł z domu, by zatrudnić ludzi do pracy. ");
INSERT INTO polsz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Uzgodnił z nimi dniówkę i wysłał na pole. ");
INSERT INTO polsz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Gdy wyszedł o dziewiątej, zobaczył na rynku innych ludzi bez pracy. ");
INSERT INTO polsz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","„Idźcie pracować w mojej winnicy”, powiedział. „Uczciwie wam zapłacę”. ");
INSERT INTO polsz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Poszli więc pracować. Właściciel zrobił to samo około dwunastej i trzeciej po południu. ");
INSERT INTO polsz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Gdy wychodził około piątej, spotkał kolejnych ludzi i zapytał: „Czemu staliście tu bezczynnie cały dzień?”. ");
INSERT INTO polsz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","„Ponieważ nikt nas nie zatrudnił”—odpowiedzieli. „No to idźcie szybko do mojej winnicy!”. ");
INSERT INTO polsz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Wieczorem właściciel powiedział zarządcy: „Zwołaj pracowników i wypłać im należność—zaczynając od tych ostatnich, a kończąc na pierwszych”. ");
INSERT INTO polsz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Podeszli więc ci, którzy przyszli o piątej, i dostali całą dniówkę. ");
INSERT INTO polsz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Gdy przyszła kolej na pierwszych zatrudnionych, spodziewali się, że dostaną więcej. Ale oni również otrzymali dniówkę. ");
INSERT INTO polsz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wzięli pieniądze, ale robili właścicielowi wymówki: ");
INSERT INTO polsz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","„Jak to? Ci ostatni pracowali tylko godzinę, a dałeś im tyle samo co nam, którzy przez cały dzień ciężko pracowaliśmy w upale!”. ");
INSERT INTO polsz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","„Przyjacielu, przecież cię nie skrzywdziłem”—zwrócił się do jednego z nich właściciel. „Czy nie umówiliśmy się na dniówkę? ");
INSERT INTO polsz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Weź swoje pieniądze i wracaj do domu! Chcę temu ostatniemu pracownikowi dać tyle samo, co tobie. ");
INSERT INTO polsz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Czy nie mam prawa wydawać swoich pieniędzy tak, jak chcę? Nie podoba ci się, że jestem dobry?”. ");
INSERT INTO polsz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","W przyszłym świecie będzie podobnie. Wielu ludzi, obecnie uznawanych za wielkich, przestanie się liczyć, a inni, teraz uznawani za najmniejszych, będą wielkimi. ");
INSERT INTO polsz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","W drodze do Jerozolimy Jezus wziął na bok Dwunastu i powiedział im: ");
INSERT INTO polsz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Gdy znajdziemy się w Jerozolimie, Ja, Syn Człowieczy, zostanę schwytany i postawiony przed najwyższymi kapłanami i przywódcami religijnymi, którzy skażą Mnie na śmierć i wydadzą w ręce Rzymian, aby Mnie zabili. ");
INSERT INTO polsz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Będą śmiać się ze Mnie i pluć na Mnie; ubiczują Mnie i zabiją. Lecz po trzech dniach powrócę do życia. ");
INSERT INTO polsz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Wtedy podeszła do Jezusa żona Zebedeusza z synami (Jakubem i Janem). Pokłoniła się i powiedziała, że ma do Niego pewną prośbę. ");
INSERT INTO polsz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—Jaka to prośba?—zapytał. —Pozwól, by moi synowie zasiedli w Twoim królestwie tuż obok Ciebie—po prawej i lewej stronie. ");
INSERT INTO polsz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","—Nie wiecie, o co prosicie!—odrzekł Jezus. —Czy jesteście gotowi wypić mój „kielich cierpienia”? —Tak—odpowiedzieli bracia. ");
INSERT INTO polsz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Rzeczywiście, wypijecie ten kielich—kontynuował Jezus—ale nie mam prawa posadzić was na tronie obok siebie. Te miejsca są już rozdzielone przez mojego Ojca. ");
INSERT INTO polsz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Gdy pozostałych dziesięciu uczniów dowiedziało się o tej prośbie, oburzyli się na braci. ");
INSERT INTO polsz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Wtedy Jezus zawołał wszystkich do siebie i powiedział: —Jak wiecie, wielcy tego świata nadużywają swojej władzy nad ludźmi. ");
INSERT INTO polsz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lecz wśród was powinno być inaczej. Jeśli ktoś z was chce być wielki, powinien stać się sługą. ");
INSERT INTO polsz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","A kto chce być największy ze wszystkich, musi stać się niewolnikiem wszystkich. ");
INSERT INTO polsz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Przecież nawet Ja, Syn Człowieczy, nie przyszedłem po to, aby Mi służono, lecz aby służyć innym i złożyć własne życie jako okup za wielu ludzi. ");
INSERT INTO polsz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Gdy wychodzili z Jerycha, za Jezusem ciągnął wielki tłum. ");
INSERT INTO polsz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","A przy drodze siedzieli dwaj niewidomi. Gdy usłyszeli, że zbliża się Jezus, zaczęli wołać: —Potomku króla Dawida, zmiłuj się nad nami! ");
INSERT INTO polsz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","—Cicho bądźcie!—krzyczeli na nich ludzie. Oni jednak tym głośniej wołali: —Pomóż nam, Panie, potomku Dawida! ");
INSERT INTO polsz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jezus zatrzymał się, zawołał ich i zapytał: —Co mogę dla was zrobić? ");
INSERT INTO polsz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Panie, chcemy odzyskać wzrok!—prosili. ");
INSERT INTO polsz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ogarnięty współczuciem, Jezus dotknął ich oczu. Natychmiast odzyskali wzrok i poszli z Nim. ");
INSERT INTO polsz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Gdy zbliżali się do Jerozolimy i byli już w Betfage na Górze Oliwnej, Jezus wysłał przed sobą dwóch uczniów. ");
INSERT INTO polsz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Idźcie do najbliższej wsi—powiedział. —Zaraz przy wejściu do niej znajdziecie uwiązaną oślicę, a przy niej osiołka. Odwiążcie je i przyprowadźcie do Mnie. ");
INSERT INTO polsz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Gdyby ktoś zwrócił na to uwagę, powiedzcie po prostu: „Pan ich potrzebuje i zaraz odprowadzi”. ");
INSERT INTO polsz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","W ten sposób miały się spełnić słowa proroka: ");
INSERT INTO polsz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","„Powiedzcie córce Syjonu: Oto przybywa twój Król, łagodny, jadący na osiołku —źrebięciu oślicy!”. ");
INSERT INTO polsz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Uczniowie poszli i zrobili tak, jak im polecił Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Przyprowadzili zwierzęta i zarzucili na nie płaszcze, tak by Jezus mógł na nich usiąść. ");
INSERT INTO polsz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mnóstwo ludzi rozkładało zaś na ziemi swoje płaszcze, inni obcinali gałązki z drzew i rzucali je na drogę. ");
INSERT INTO polsz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A cały tłum przed Nim i wokół Niego wołał: —Niech żyje Król, potomek Dawida! Błogosławiony Ten, który przychodzi w imieniu Pana! Chwała Królowi! ");
INSERT INTO polsz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Gdy wjechał do Jerozolimy, całe miasto było już poruszone. —Kto to taki?—pytali jedni. ");
INSERT INTO polsz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","—To Jezus, prorok z Nazaretu w Galilei—odpowiadali drudzy. ");
INSERT INTO polsz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jezus zaś wszedł do świątyni i wypędził z niej wszystkich sprzedawców oraz kupujących. Powywracał stoły wymieniających pieniądze oraz stragany sprzedawców gołębi. ");
INSERT INTO polsz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Powiedział do nich: —Pismo mówi: „Moja świątynia ma być domem modlitwy dla wszystkich narodów, a wy zrobiliście z niej kryjówkę złodziei”. ");
INSERT INTO polsz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","W świątyni podchodzili do Niego niewidomi i kalecy, a On ich uzdrawiał. ");
INSERT INTO polsz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lecz gdy najwyżsi kapłani oraz przywódcy religijni zobaczyli te cuda i usłyszeli dzieci wykrzykujące: „Niech żyje Król, potomek Dawida!”—bardzo się oburzyli. —Czy słyszysz, co oni wykrzykują?—pytali. ");
INSERT INTO polsz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","—Słyszę—odrzekł Jezus. —A czy nie czytaliście nigdy w Piśmie słów: „Przyjąłeś chwałę z ust dzieci i niemowląt”? ");
INSERT INTO polsz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","I odszedł od nich. Następnie opuścił miasto i udał się na nocleg do Betanii. ");
INSERT INTO polsz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Rano, wracając do miasta, Jezus poczuł głód. ");
INSERT INTO polsz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Zauważył przy drodze drzewo figowe. Podszedł więc do niego, ale nie znalazł tam nic oprócz liści. Wtedy powiedział do drzewa: —Już nigdy więcej nie przyniesiesz owocu! I drzewo od razu uschło. ");
INSERT INTO polsz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Uczniowie zdziwili się: —Tak szybko uschło?—mówili. ");
INSERT INTO polsz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","—Zapewniam was—odpowiedział Jezus—że jeśli będziecie mieć prawdziwą wiarę, pozbawioną zwątpień, to nie tylko z drzewem figowym tak zrobicie. Możecie nawet rozkazać tej oto górze: „Unieś się i rzuć w morze!”—a uczyni to. ");
INSERT INTO polsz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","O cokolwiek poprosicie z wiarą, to otrzymacie. ");
INSERT INTO polsz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Gdy Jezus ponownie znalazł się w świątyni i nauczał, najwyżsi kapłani i przywódcy religijni zapytali Go: —Jakim prawem wyrzuciłeś ze świątyni sprzedawców? Kto dał ci taką władzę? ");
INSERT INTO polsz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","—Odpowiem wam, jeśli i wy odpowiecie na moje pytanie—odparł Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","—Czy chrzest, do którego wzywał Jan Chrzciciel, pochodził od Boga, czy był tylko ludzkim wymysłem? Wtedy zaczęli się naradzać nad odpowiedzią: —Jeśli powiemy, że pochodził od Boga, to zapyta nas: „Czemu go nie przyjęliście?”. ");
INSERT INTO polsz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A jeśli powiemy, że był ludzkim wymysłem, to tłumy się oburzą, bo wszyscy wierzą, że Jan był prorokiem. W końcu rzekli: ");
INSERT INTO polsz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","—Nie potrafimy na to odpowiedzieć. —Wobec tego i Ja nie odpowiem na wasze pytanie—odparł Jezus ");
INSERT INTO polsz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","—ale pozwólcie, że wam coś opowiem. Pewien człowiek miał dwóch synów. Udał się do jednego i poprosił: „Synu, idź dziś do pracy w winnicy”. ");
INSERT INTO polsz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","„Nie chce mi się”—powiedział syn, ale później żałował tego i udał się do pracy. ");
INSERT INTO polsz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ojciec poszedł też do drugiego syna i poprosił o to samo. Ten odpowiedział: „Oczywiście, ojcze”, ale nie poszedł. ");
INSERT INTO polsz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Który z nich był posłuszny ojcu? —Ten pierwszy—odpowiedzieli. —Zapewniam was, że pogardzani przez wszystkich poborcy podatkowi i prostytutki prędzej niż wy wejdą do królestwa Bożego—podsumował Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","—Jan Chrzciciel nawoływał do prawego życia, ale mu nie uwierzyliście. Natomiast poborcy i prostytutki uwierzyli! A wy, choć to widzieliście, nie chcieliście się opamiętać i uwierzyć. ");
INSERT INTO polsz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jezus kontynuował: —Posłuchajcie jeszcze jednej przypowieści: Pewien właściciel założył winnicę. Ogrodził ją murem, zbudował tłocznię i wieżę strażniczą, po czym wynajął ją rolnikom i wyjechał. ");
INSERT INTO polsz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Gdy nadszedł czas zbiorów, wysłał swoich ludzi, aby odebrali należną mu część plonów. ");
INSERT INTO polsz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Lecz rolnicy rzucili się na nich: jednego pobili, drugiego zabili, a innego obrzucili kamieniami. ");
INSERT INTO polsz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Właściciel wysłał więc innych pełnomocników, jeszcze większą grupą. Lecz rolnicy zrobili z nimi to samo. ");
INSERT INTO polsz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","W końcu posłał do nich swojego syna, sądząc że przynajmniej jemu okażą szacunek. ");
INSERT INTO polsz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lecz rolnicy, widząc nadchodzącego syna, powiedzieli sobie: „To ten, który ma przejąć winnicę. Zabijmy go, a winnica będzie nasza!”. ");
INSERT INTO polsz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wywlekli go poza winnicę i zabili. ");
INSERT INTO polsz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jak sądzicie, co zrobi właściciel z rolnikami, gdy powróci? ");
INSERT INTO polsz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","—Ukarze ich śmiercią, a winnicę wydzierżawi innym, którzy będą się z nim rozliczać na czas—odpowiedzieli. ");
INSERT INTO polsz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","—Przypomnijcie sobie następujące słowa z Pisma—odrzekł Jezus: „Kamień, odrzucony przez budujących, stał się kamieniem węgielnym, najważniejszym w całym budynku! Dokonał tego Pan i jest to zdumiewające”. ");
INSERT INTO polsz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Oświadczam wam, że królestwo Boże zostanie wam odebrane, a przekazane ludziom, którzy wydają owoc. ");
INSERT INTO polsz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Każdy, kto upadnie na ten kamień, roztrzaska się o niego, a jeśli on na kogoś spadnie, zetrze go na proch. ");
INSERT INTO polsz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Najwyżsi kapłani i faryzeusze zrozumieli, że to ich Jezus miał na myśli, opowiadając przypowieść o złych rolnikach. ");
INSERT INTO polsz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Dlatego chcieli Go natychmiast aresztować, ale obawiali się reakcji tłumu, który uważał Jezusa za proroka. ");
INSERT INTO polsz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jezus przedstawił jeszcze jedną przypowieść: ");
INSERT INTO polsz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Królestwo niebieskie jest podobne do władcy, który wyprawił synowi wesele. ");
INSERT INTO polsz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Posłał służących, aby powiadomili zaproszonych, ale ci nie chcieli przyjść. ");
INSERT INTO polsz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Poprzez innych służących wysłał im więc następującą wiadomość: „Uczta gotowa, mięso na rożnach—wszystko przygotowane! Zapraszam na wesele!”. ");
INSERT INTO polsz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ale goście zlekceważyli zaproszenie: jeden poszedł na pole, inny—do swojego sklepu. ");
INSERT INTO polsz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A niektórzy nawet naubliżali posłańcom i zabili ich. ");
INSERT INTO polsz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Władca wpadł w gniew: wysłał wojsko, zgładził zabójców i spalił ich miasto. ");
INSERT INTO polsz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Potem rzekł sługom: „Uczta weselna została przygotowana, ale zaproszeni okazali się jej niegodni. ");
INSERT INTO polsz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Wyjdźcie więc na ulice i zaproście na wesele wszystkich, których spotkacie”. ");
INSERT INTO polsz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Poszli więc i przyprowadzili z ulic wszystkich napotkanych ludzi—zarówno złych, jak i dobrych. W ten sposób sala biesiadna zapełniła się gośćmi. ");
INSERT INTO polsz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Gdy władca wszedł, aby ich zobaczyć, zauważył człowieka, który nie miał na sobie weselnego ubrania. ");
INSERT INTO polsz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","„Przyjacielu!”—zwrócił się do niego. —„Jak się tu znalazłeś, nie mając weselnego ubrania?”. On jednak nic nie odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Wówczas władca rozkazał sługom: „Zwiążcie mu ręce i nogi i wyrzućcie go na zewnątrz, w ciemności, gdzie panuje lament i rozpacz!”. ");
INSERT INTO polsz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Wielu jest bowiem zaproszonych, ale mało wybranych. ");
INSERT INTO polsz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tymczasem faryzeusze naradzali się, jak sprowokować Jezusa do jakiejś niefortunnej wypowiedzi. Potrzebny był im bowiem pretekst do oskarżenia Go. ");
INSERT INTO polsz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wysłali więc swoich ludzi oraz zwolenników Heroda z takim pytaniem: —Nauczycielu! Wiemy, że nie boisz się mówić prawdy. Nie dostosowujesz się też do opinii ludzi ani do ich oczekiwań, lecz uczciwie nauczasz prawd Bożych. ");
INSERT INTO polsz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Powiedz nam więc, czy słusznie płacimy podatki Rzymowi, czy nie? ");
INSERT INTO polsz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","—Obłudnicy! Chcecie Mnie pogrążyć?!—powiedział Jezus, zdając sobie sprawę z ich podstępu. ");
INSERT INTO polsz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","—Pokażcie Mi najpierw monetę! Gdy Mu ją podano, zapytał: ");
INSERT INTO polsz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","—Czyją podobiznę i tytuł na niej widzicie? ");
INSERT INTO polsz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Cezara—odpowiedzieli. —Oddawajcie więc cezarowi to, co jego, a Bogu—co należy do Boga! ");
INSERT INTO polsz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ta odpowiedź tak ich zaskoczyła, że zaraz stamtąd odeszli. ");
INSERT INTO polsz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jeszcze tego samego dnia przyszli do Jezusa saduceusze—przedstawiciele ugrupowania nauczającego, że nie będzie zmartwychwstania. ");
INSERT INTO polsz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Nauczycielu!—zwrócili się do Niego. —Prawo Mojżesza naucza: „Jeśli umrze mężczyzna i nie pozostawi po sobie potomstwa, jego brat powinien ożenić się z wdową po zmarłym i mieć z nią potomstwo”. ");
INSERT INTO polsz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Otóż żyło kiedyś u nas siedmiu braci. Najstarszy z nich ożenił się, ale wkrótce zmarł, nie pozostawiając dzieci. Wdowa została żoną młodszego brata. ");
INSERT INTO polsz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","I tak było z drugim, trzecim i resztą braci. ");
INSERT INTO polsz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","W końcu zmarła także ta kobieta. ");
INSERT INTO polsz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jeśli rzeczywiście umarli zmartwychwstaną, to czyją będzie wtedy żoną, skoro wszyscy bracia się z nią ożenili? ");
INSERT INTO polsz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","—Cała trudność polega na tym—odparł Jezus—że nie znacie Pisma ani mocy Bożej! ");
INSERT INTO polsz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Po zmartwychwstaniu więzy małżeńskie nie będą obowiązywać ani tych siedmiu braci, ani kobiety, bo wszyscy pod tym względem będą podobni do aniołów. ");
INSERT INTO polsz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Jeśli zaś chodzi o samo zmartwychwstanie, to czy nigdy nie czytaliście, że Bóg powiedział: ");
INSERT INTO polsz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","„Jestem Bogiem Abrahama, Bogiem Izaaka i Bogiem Jakuba”? Przecież nie nazwałby siebie Bogiem tych, którzy już nie istnieją!! ");
INSERT INTO polsz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Zgromadzeni, słysząc Jego odpowiedź, nie mogli wyjść z podziwu. ");
INSERT INTO polsz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Faryzeusze dowiedzieli się, że Jezus zamknął usta saduceuszom. Przyszli więc tam ");
INSERT INTO polsz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","i jeden z nich—przywódca religijny—zadał Mu podchwytliwe pytanie: ");
INSERT INTO polsz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Nauczycielu, które z przykazań Prawa Mojżesza jest najważniejsze? ");
INSERT INTO polsz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","—„Kochaj twojego Pana i Boga całym sercem, duszą i umysłem!”—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","—To jest pierwsze i najważniejsze przykazanie. ");
INSERT INTO polsz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Drugie jest podobne: „Kochaj innych tak, jak kochasz samego siebie!”. ");
INSERT INTO polsz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Na tych dwóch przykazaniach opiera się całe Prawo Mojżesza i księgi proroków. ");
INSERT INTO polsz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Następnie sam zapytał otaczających Go faryzeuszy: ");
INSERT INTO polsz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Jak sądzicie? Skąd ma pochodzić Mesjasz? —Z rodu króla Dawida—odrzekli. ");
INSERT INTO polsz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—To dlaczego sam Dawid, a przez jego usta Duch Święty, nazywa Go Panem?—zapytał Jezus. —Dawid powiedział przecież: ");
INSERT INTO polsz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","„Bóg rzekł do mojego Pana: Zasiądź po mojej prawej stronie, dopóki nie rzucę Ci pod nogi Twoich nieprzyjaciół”. ");
INSERT INTO polsz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Skoro więc Dawid nazwał Go Panem, to jak Mesjasz może być jego potomkiem? ");
INSERT INTO polsz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nikt nie potrafił Mu na to odpowiedzieć. Dlatego też nikt już więcej nie śmiał Go o nic pytać. ");
INSERT INTO polsz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Wówczas Jezus zwrócił się do tłumu i do swoich uczniów: ");
INSERT INTO polsz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Przywódcy religijni i faryzeusze zajęli miejsce samego Mojżesza. ");
INSERT INTO polsz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Dlatego postępujcie zgodnie z ich nauką, lecz nie bierzcie z nich przykładu. Bo nauczają, ale sami tego nie przestrzegają. ");
INSERT INTO polsz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wymyślają bowiem niewykonalne obowiązki i narzucają je innym, a sami nie kiwną nawet palcem, aby im pomóc. ");
INSERT INTO polsz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","To, co robią, czynią tylko na pokaz. Starają się pobożnie wyglądać—zakładają na ramiona szkatułki z tekstami modlitw i chodzą w szatach z długimi frędzlami. ");
INSERT INTO polsz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Oczekują zaszczytnych miejsc na przyjęciach i w synagogach ");
INSERT INTO polsz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","oraz wyrazów szacunku ze strony innych ludzi. Lubią, gdy inni zwracają się do nich: „nauczycielu”. ");
INSERT INTO polsz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lecz wy nie pozwalajcie, by was tak nazywano. Macie tylko jednego Nauczyciela, a wy jesteście sobie równi jak bracia. ");
INSERT INTO polsz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","I do nikogo na ziemi nie zwracajcie się „ojcze”, bo macie tylko jednego Ojca, w niebie. ");
INSERT INTO polsz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nie pozwalajcie też, aby nazywano was „mistrzami”, gdyż macie tylko jednego Mistrza—Mesjasza. ");
INSERT INTO polsz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Największy z was niech będzie waszym sługą. ");
INSERT INTO polsz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kto sam siebie wywyższa, zostanie poniżony. A kto się uniża, zostanie wywyższony. ");
INSERT INTO polsz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Marny wasz los, przywódcy religijni i faryzeusze! Jesteście obłudnikami! Zamykacie ludziom dostęp do królestwa niebieskiego! Sami nie wchodzicie i innym nie pozwalacie wejść! ");
INSERT INTO polsz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Marny wasz los, przywódcy religijni i faryzeusze! Jesteście obłudnikami! Obchodzicie cały świat, aby nawrócić jednego człowieka. A gdy już się tak stanie, robicie z niego syna piekła, dwa razy gorszego niż wy sami. ");
INSERT INTO polsz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Marny wasz los, ślepi przewodnicy! Mówicie: „Kto przysięga na świątynię Bożą, do niczego nie jest zobowiązany. Ale kto składa przysięgę na złoto w świątyni, musi ją wypełnić”. ");
INSERT INTO polsz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Głupi ślepcy! Co jest ważniejsze: złoto czy świątynia, która uświęca złoto? ");
INSERT INTO polsz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Twierdzicie też: „Przysięga na ołtarz do niczego nie zobowiązuje. Ale przysięga na dar na ołtarzu jest wiążąca”. ");
INSERT INTO polsz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ślepcy! Co jest ważniejsze; dar czy ołtarz, który uświęca złożony na nim dar? ");
INSERT INTO polsz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kto przysięga „na ołtarz”, przysięga na wszystko, co się na nim znajduje. ");
INSERT INTO polsz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","A kto przysięga „na świątynię”, przysięga na nią i na Boga, który w niej mieszka. ");
INSERT INTO polsz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ten zaś, kto przysięga „na niebo”, przysięga na tron Boży i na Tego, który na nim zasiada. ");
INSERT INTO polsz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Marny wasz los, przywódcy religijni i faryzeusze! Jesteście obłudnikami! Skrupulatnie dajecie Bogu dziesiątą część swoich najdrobniejszych nawet dochodów, a lekceważycie to, co w Prawie Mojżesza jest najważniejsze: prawość, miłość i wiarę. A jednego i drugiego nie należy zaniedbywać! ");
INSERT INTO polsz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ślepi przewodnicy! Odcedzacie komara, a połykacie wielbłąda. ");
INSERT INTO polsz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Marny wasz los, przywódcy religijni i faryzeusze! Jesteście obłudnikami! Usilnie dbacie o zewnętrzną czystość naczyń, ale wasze brudne wnętrze aż się lepi od chciwości i pożądania. ");
INSERT INTO polsz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ślepy faryzeuszu! Oczyść najpierw wnętrze kubka, to i na zewnętrz będzie czysty! ");
INSERT INTO polsz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Marny wasz los, przywódcy religijni i faryzeusze! Jesteście obłudnikami! Przypominacie odnowione grobowce—z zewnątrz piękne, a w środku pełne rozkładających się szczątków! ");
INSERT INTO polsz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Robicie przed ludźmi wrażenie świętych, lecz w środku jesteście pełni obłudy i nieprawości! ");
INSERT INTO polsz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Marny wasz los, przywódcy religijni i faryzeusze! Jesteście obłudnikami! Stawiacie i zdobicie grobowce prorokom oraz innym ludziom, którzy kochali Boga, ");
INSERT INTO polsz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","mówiąc: „Gdybyśmy my żyli w czasach naszych przodków, nie mordowalibyśmy proroków tak jak oni”. ");
INSERT INTO polsz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","W ten sposób przyznajecie, że jesteście potomkami morderców. ");
INSERT INTO polsz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dorównajcie im! ");
INSERT INTO polsz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Czy tacy podli ludzie mogą uniknąć kary piekła? ");
INSERT INTO polsz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Wyślę do was proroków, mędrców i nauczycieli, ale jednych zabijecie, krzyżując ich, innych ubiczujecie w swoich synagogach i będziecie prześladować po miastach. ");
INSERT INTO polsz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Spadnie na was wina za przelaną krew wszystkich, którzy kochali Boga! Począwszy od prawego Abla, aż po Zachariasza, syna Barachiasza, którego zabiliście między ołtarzem a miejscem świętym. ");
INSERT INTO polsz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Zapewniam was, że kara za to wszystko spadnie na głowy tego pokolenia. ");
INSERT INTO polsz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerozolimo, Jerozolimo!—zawołał Jezus. —Zabijasz proroków i obrzucasz kamieniami Bożych posłańców! Ileż to razy chciałem przygarnąć twoje dzieci, tak jak kura, która pod skrzydłami chroni swoje pisklęta. Ale nie pozwoliłaś! ");
INSERT INTO polsz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Zbliża się czas, w którym twój dom opustoszeje. ");
INSERT INTO polsz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mówię wam: Nie zobaczycie Mnie do chwili, gdy zawołacie: „Błogosławiony, który przychodzi w imieniu samego Pana!”. ");
INSERT INTO polsz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Gdy Jezus opuszczał świątynię, uczniowie chcieli Mu pokazać różne jej zabudowania. ");
INSERT INTO polsz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","On im odpowiedział: —To, co teraz podziwiacie, legnie w gruzach i nie pozostanie tu nawet kamień na kamieniu. ");
INSERT INTO polsz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Później, gdy siedział na zboczu Góry Oliwnej, uczniowie podeszli do Niego i dyskretnie spytali: —Kiedy wydarzy się to, o czym mówiłeś? Po czym poznamy, że zbliża się Twoje przyjście i koniec tego świata? ");
INSERT INTO polsz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","—Nie dajcie się nikomu oszukać!—przestrzegł ich Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","—Wielu bowiem będzie się podawać za Mesjasza i oszuka mnóstwo ludzi. ");
INSERT INTO polsz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Na świecie wybuchną wojny i będą rozchodzić się wieści o walkach. Uważajcie i nie dajcie się zastraszyć, to jeszcze nie będzie koniec! ");
INSERT INTO polsz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Narody i państwa będą walczyć przeciwko sobie, a wiele krajów nawiedzi głód oraz trzęsienia ziemi. ");
INSERT INTO polsz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ale to będzie dopiero początek tragedii. ");
INSERT INTO polsz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Będą was torturować i zabijać! Wszystkie narody was znienawidzą z mojego powodu! ");
INSERT INTO polsz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wielu ponownie wpadnie w sidła grzechu i będzie nienawidzić oraz zdradzać innych. ");
INSERT INTO polsz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pojawi się też wielu fałszywych proroków, którzy zwiodą całe rzesze ludzi. ");
INSERT INTO polsz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Z powodu tak wielkiego zła oziębnie miłość wielu wierzących. ");
INSERT INTO polsz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ale ci, którzy wytrwają do końca i nie zaprą się Mnie, zostaną uratowani! ");
INSERT INTO polsz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","A dobra nowina o królestwie Bożym będzie głoszona na całym świecie jako świadectwo dla wszystkich narodów. I wtedy nadejdzie koniec. ");
INSERT INTO polsz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Gdy zobaczycie w świątyni „ohydę spustoszenia”, o której mówił prorok Daniel—kto to czyta, niech uważa— ");
INSERT INTO polsz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","wtedy ci, którzy przebywają w Judei, niech uciekają w góry. ");
INSERT INTO polsz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","I śpieszcie się! Jeśli będziecie na tarasie, nie wchodźcie do domu, aby się spakować. ");
INSERT INTO polsz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jeśli będziecie na polu, nie wracajcie po pieniądze czy ubranie. ");
INSERT INTO polsz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ciężko będzie wtedy kobietom w ciąży i matkom karmiącym niemowlęta. ");
INSERT INTO polsz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Módlcie się, żeby wasza ucieczka nie wypadła zimą albo w szabat. ");
INSERT INTO polsz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Będą to bowiem dni tak straszliwe, jakich nie było od początku świata i już nigdy potem nie będzie. ");
INSERT INTO polsz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","I gdyby czas tej klęski nie został skrócony, nikt by się nie uratował. Lecz ze względu na wybranych czas ten zostanie skrócony. ");
INSERT INTO polsz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Jeśli wtedy ktoś wam powie: „Tu jest Mesjasz”—nie wierzcie! ");
INSERT INTO polsz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pojawi się bowiem wielu fałszywych mesjaszy i proroków, którzy będą czynić wielkie cuda, starając się oszukać nawet wybranych przez Boga. ");
INSERT INTO polsz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pamiętajcie więc, że was ostrzegałem. ");
INSERT INTO polsz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jeśli więc ktoś wam powie: „Mesjasz jest na pustyni”—nie szukajcie Mnie tam. I nie wierzcie, gdy powiedzą: „Tam się ukrywa!”. ");
INSERT INTO polsz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Gdy powtórnie przyjdę, będzie to bowiem tak widoczne, jak błyskawica na niebie. ");
INSERT INTO polsz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gdzie jest padlina, tam w naturalny sposób pojawiają się i sępy. Wy również rozpoznacie nadchodzący koniec! ");
INSERT INTO polsz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Zaraz po zakończeniu tego strasznego czasu nastąpi zaćmienie słońca, a księżyc straci swój blask. Gwiazdy będą spadać z nieba i zachwieje się cały porządek wszechświata. ");
INSERT INTO polsz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Wtedy pojawi się na niebie znak mojego przyjścia i wszystkich ogarnie skrucha, bo cała ludzkość ujrzy Mnie, Syna Człowieczego, przybywającego na obłokach w wielkiej mocy i chwale. ");
INSERT INTO polsz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Rozlegnie się wtedy potężny dźwięk trąb. I poślę aniołów, żeby zgromadzili Moich wybranych z całego świata, z najdalszych zakątków ziemi. ");
INSERT INTO polsz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Niech to drzewo figowe stanie się dla was przykładem—kontynuował Jezus. —Gdy jego pączki miękną, a listki zaczynają się rozwijać, mówicie, że zbliża się lato. ");
INSERT INTO polsz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Gdy więc zobaczycie wszystko, co wam zapowiedziałem, bądźcie pewni, że mój powrót jest bliski, że jestem tuż u drzwi. ");
INSERT INTO polsz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Zapewniam was: Nie wymrze to pokolenie, a wszystko to się dokona. ");
INSERT INTO polsz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Niebo i ziemia przeminą, lecz moje słowa pozostaną na wieki. ");
INSERT INTO polsz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nikt jednak nie zna dnia ani czasu, w którym się to stanie—ani aniołowie w niebie, ani nawet Ja—Syn. Wie o tym tylko mój Ojciec. ");
INSERT INTO polsz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Czas mojego przybycia będzie podobny do czasów Noego. ");
INSERT INTO polsz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ludzie wtedy zwyczajnie jedli i pili, zawierali małżeństwa—aż do chwili, gdy Noe wszedł do arki. ");
INSERT INTO polsz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nie wiedzieli, że to potop—i wszyscy zginęli. Tak samo będzie w dniu, w którym Ja, Syn Człowieczy, powrócę na ziemię. ");
INSERT INTO polsz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Z dwóch ludzi pracujących w polu, jeden zostanie wzięty, a drugi pozostawiony. ");
INSERT INTO polsz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Z dwóch kobiet, pracujących w domu, jedna zostanie wzięta, druga zaś pozostawiona. ");
INSERT INTO polsz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Uważajcie więc, bo nie wiecie, którego dnia Ja, wasz Pan, przyjdę. ");
INSERT INTO polsz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pomyślcie: Gdyby właściciel domu wiedział, kiedy złodziej przyjdzie go okraść, pilnowałby dobytku i nie dopuściłby do włamania. ");
INSERT INTO polsz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wy również musicie uważać, bo nie wiecie, kiedy Ja, Syn Człowieczy, powrócę! ");
INSERT INTO polsz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kim jest ten wierny i mądry sługa, któremu Pan powierzył opiekę nad innymi swoimi sługami, by na czas o nich dbał? ");
INSERT INTO polsz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nagrodzi go, gdy po powrocie zobaczy dobrze wykonaną pracę. ");
INSERT INTO polsz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Zapewniam was, że da mu w zarządzanie cały swój majątek. ");
INSERT INTO polsz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Gdyby jednak ten sługa pomyślał sobie: ");
INSERT INTO polsz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","„Nieprędko wróci właściciel, nie muszę się więc go obawiać” i zaczął znęcać się nad powierzonymi sobie ludźmi, zabawiać się i upijać, ");
INSERT INTO polsz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","to jego pan powróci w najmniej oczekiwanej chwili. ");
INSERT INTO polsz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Surowo się wtedy z nim rozprawi i osądzi go wraz z innymi obłudnikami. Będzie tam lament i rozpacz. ");
INSERT INTO polsz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Królestwo niebieskie można porównać do dziesięciu dziewcząt, które jako druhny wyszły z lampami na spotkanie pana młodego. ");
INSERT INTO polsz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pięć z nich było głupich, a pięć mądrych. ");
INSERT INTO polsz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Głupie zabrały lampy, ale nie wzięły do nich zapasowej oliwy. ");
INSERT INTO polsz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mądre zaś zabrały lampy i zapasową oliwę w naczyniach. ");
INSERT INTO polsz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ponieważ pan młody się spóźniał, zdrzemnęły się wszystkie. ");
INSERT INTO polsz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nagle o północy obudziło je wołanie: „Nadchodzi pan młody! Wyjdźcie mu na spotkanie!”. ");
INSERT INTO polsz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dziewczęta zerwały się i przygotowały lampy. ");
INSERT INTO polsz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Niemądre zwróciły się do pozostałych: „Dajcie nam trochę oliwy, bo nasze lampy gasną!”. ");
INSERT INTO polsz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mądre odpowiedziały jednak: „Jeśli damy wam, nie wystarczy ani dla nas, ani dla was. Idźcie lepiej sobie kupić!”. ");
INSERT INTO polsz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Gdy poszły to zrobić, przybył pan młody. Te, które były gotowe, weszły z nim na przyjęcie weselne—a drzwi zamknięto. ");
INSERT INTO polsz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Po pewnym czasie wróciły pozostałe dziewczęta i zaczęły wołać: „Panie, otwórz nam!”. ");
INSERT INTO polsz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lecz on odpowiedział: „Niestety nie znam was, odejdźcie stąd!”. ");
INSERT INTO polsz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Uważajcie więc, bo nie znacie dnia ani czasu mojego powrotu! ");
INSERT INTO polsz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Królestwo niebieskie jest jak człowiek, który odjeżdżając w daleką podróż zwołał swoich podwładnych i powierzył im na ten czas swój majątek. ");
INSERT INTO polsz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jednemu przekazał pięć tysięcy, drugiemu dwa tysiące, a trzeciemu tysiąc—każdemu zgodnie z jego możliwościami. I odjechał. ");
INSERT INTO polsz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pierwszy zaczął obracać pięcioma tysiącami i po pewnym czasie zarobił kolejne pięć tysięcy. ");
INSERT INTO polsz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Drugi również zainwestował pieniądze i zyskał kolejne dwa tysiące. ");
INSERT INTO polsz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Natomiast ten, który miał zarządzać tysiącem, ukrył go w bezpiecznym miejscu. ");
INSERT INTO polsz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Po dłuższym czasie pan powrócił i chciał się z nimi rozliczyć. ");
INSERT INTO polsz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Wtedy ten, któremu powierzył pięć tysięcy, przyniósł dodatkowe pięć i powiedział: „Panie! Powierzyłeś mi pięć tysięcy. Oto osiągnąłem zysk w wysokości kolejnych pięciu tysięcy”. ");
INSERT INTO polsz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","„Bardzo dobrze!”—rzekł pan. „Jesteś dobrym i wiernym pracownikiem. Okazałeś wierność w małej sprawie, więc teraz powierzę ci bardziej odpowiedzialne zadanie. Ciesz się razem ze mną”. ");
INSERT INTO polsz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Następnie przyszedł ten, który otrzymał dwa tysiące i powiedział: „Panie! Powierzyłeś mi dwa tysiące, oto podwoiłem tę sumę”. ");
INSERT INTO polsz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","„Bardzo dobrze!”—rzekł pan. „Jesteś dobrym i wiernym pracownikiem. Okazałeś wierność w małej sprawie, więc teraz powierzę ci bardziej odpowiedzialne zadanie. Ciesz się razem ze mną”. ");
INSERT INTO polsz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Wreszcie przyszedł ten, który otrzymał jeden tysiąc i powiedział: „Panie! Wiedziałem, że masz twardą rękę w interesach i że będziesz chciał mieć zysk z tego, nad czym sam nie pracowałeś. ");
INSERT INTO polsz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bałem się ciebie, dlatego bezpiecznie przechowałem twoje pieniądze. Oto one”. ");
INSERT INTO polsz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","„Jesteś leniem i złym pracownikiem!”—odrzekł pan. „Wiedziałeś, że chcę mieć zysk nawet jeśli sam na niego nie pracowałem! ");
INSERT INTO polsz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mogłeś więc zanieść ten tysiąc do banku, wtedy miałbym przynajmniej jakieś odsetki. ");
INSERT INTO polsz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Zabierzcie mu pieniądze i dajcie temu, który ma dziesięć tysięcy. ");
INSERT INTO polsz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bo każdy, kto przynosi zyski, otrzyma więcej i będzie opływał w dostatki. A temu, kto nie przynosi zysku, odbiorą i to, co posiada. ");
INSERT INTO polsz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Wyrzućcie tego lenia na zewnątrz, w ciemności! Tam będzie rozpacz i lament”. ");
INSERT INTO polsz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Gdy Ja, Syn Człowieczy, przybędę w chwale, wraz ze wszystkimi aniołami, zasiądę na swoim tronie pełnym chwały. ");
INSERT INTO polsz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","I zgromadzą się przede Mną wszystkie narody, a Ja rozdzielę ludzi na dwie grupy, tak jak pasterz rozdziela owce i kozły. ");
INSERT INTO polsz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","„Owce” postawię po prawej stronie, a „kozły” po lewej. ");
INSERT INTO polsz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wówczas jako Król powiem do tych po prawej: „Mój ojciec obdarzył was wielkim szczęściem! Wejdźcie do królestwa, które zostało dla was przygotowane zanim jeszcze zaistniał świat! ");
INSERT INTO polsz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bo gdy byłem głodny, nakarmiliście Mnie. Gdy byłem spragniony, daliście Mi pić. Gdy byłem w podróży, ugościliście Mnie. ");
INSERT INTO polsz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Gdy nie miałem się w co ubrać, daliście Mi odzież, a gdy byłem chory oraz gdy przebywałem w więzieniu, odwiedzaliście Mnie”. ");
INSERT INTO polsz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","„Panie!”—zapytają prawi. „Kiedy widzieliśmy Cię głodnego i nakarmiliśmy Cię? Kiedy daliśmy Ci pić, gdy byłeś spragniony? ");
INSERT INTO polsz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Albo kiedy ugościliśmy Cię podczas podróży lub daliśmy Ci odzież, gdy nie miałeś w co się ubrać? ");
INSERT INTO polsz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kiedy to było, gdy odwiedziliśmy Cię w czasie choroby lub w więzieniu?”. ");
INSERT INTO polsz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","„Zapewniam was”—odpowiem wtedy—„że cokolwiek zrobiliście jednemu z moich braci, choćby najmniejszemu, Mnie to uczyniliście”. ");
INSERT INTO polsz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Następnie jako Król zwrócę się do tych po lewej stronie: „Jesteście przeklęci przez Boga! Idźcie w ogień wieczny, przygotowany dla diabła i jego aniołów! ");
INSERT INTO polsz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gdy byłem głodny, nie nakarmiliście Mnie, gdy byłem spragniony, nie daliście Mi pić. ");
INSERT INTO polsz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Byłem w podróży, a odmówiliście Mi gościny, nie miałem się w co ubrać, a nie pomogliście Mi; byłem chory i w więzieniu, a nie odwiedziliście Mnie”. ");
INSERT INTO polsz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","„Panie!”—powiedzą. „Kiedy widzieliśmy Cię głodnego, spragnionego, w podróży, pozbawionego ubrań, chorego albo w więzieniu, a nie okazaliśmy Ci pomocy?”. ");
INSERT INTO polsz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","„Zapewniam was”—odpowiem wtedy—„że gdy odmówiliście pomocy najmniejszemu z moich braci, Mnie jej pozbawiliście”. ");
INSERT INTO polsz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","I pójdą oni na wieczne potępienie, prawi zaś—do życia wiecznego. ");
INSERT INTO polsz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Po zakończeniu tego nauczania Jezus rzekł do uczniów: ");
INSERT INTO polsz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Za dwa dni rozpoczyna się święto Paschy i Ja, Syn Człowieczy, zostanę zdradzony i ukrzyżowany. ");
INSERT INTO polsz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tymczasem na dziedzińcu rezydencji najwyższego kapłana, Kajfasza, zebrali się inni kapłani oraz starsi. ");
INSERT INTO polsz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Postanowili potajemnie uwięzić i zabić Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—Nie możemy jednak zrobić tego podczas święta—mówili—bo spowoduje to rozruchy. ");
INSERT INTO polsz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jezus tymczasem zatrzymał się w Betanii, w domu Szymona Trędowatego. ");
INSERT INTO polsz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Wtedy właśnie przyszła tam pewna kobieta z butelką bardzo drogiego, wonnego olejku i wylała go na głowę Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Widząc to, uczniowie oburzyli się: —Co za marnotrawstwo! ");
INSERT INTO polsz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Przecież można było sprzedać te perfumy i rozdać pieniądze biednym! ");
INSERT INTO polsz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","—Dlaczego ją krytykujecie?—zapytał Jezus, widząc ich reakcję. —Przecież spełniła dobry uczynek! ");
INSERT INTO polsz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","—Biedni zawsze będą wśród was, a Mnie już wkrótce zabraknie. ");
INSERT INTO polsz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Namaszczając tym olejkiem, przygotowała Mnie na pogrzeb. ");
INSERT INTO polsz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Zapewniam was: Gdziekolwiek na świecie będzie głoszona dobra nowina, wszędzie będzie się mówić o tym, co zrobiła, i będzie się o niej pamiętać. ");
INSERT INTO polsz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tymczasem Judasz z Kariotu, jeden z Dwunastu, poszedł do najwyższych kapłanów ");
INSERT INTO polsz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","i zapytał: —Ile mi zapłacicie, jeśli wydam wam Jezusa? I dali mu trzydzieści srebrnych monet. ");
INSERT INTO polsz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Od tej chwili Judasz czekał już tylko na sprzyjającą okazję, aby wydać Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","W pierwszym dniu święta Paschy, uczniowie zapytali Jezusa: —Gdzie mamy przygotować kolację paschalną? ");
INSERT INTO polsz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","—Idźcie do miasta!—powiedział. —Udajcie się do naszego znajomego i powiedzcie mu: „Nasz Nauczyciel zawiadamia: Nadchodzi już czas! U ciebie chcę spożyć z moimi uczniami świąteczną kolację”. ");
INSERT INTO polsz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Uczniowie zrobili tak, jak im polecił, i zajęli się przygotowaniem posiłku. ");
INSERT INTO polsz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Wieczorem, wraz z Dwunastoma, Jezus zajął miejsce przy stole. ");
INSERT INTO polsz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Gdy zaczęli posiłek, powiedział: —Mówię wam: Jeden z was, siedzących tu ze Mną, zdradzi Mnie. ");
INSERT INTO polsz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","—Ale to chyba nie ja, Panie?—mówili zasmuceni jeden przez drugiego. ");
INSERT INTO polsz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","—To ten, który jednocześnie ze Mną sięga do półmiska—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","—Ja, Syn Człowieczy, muszę umrzeć, zgodnie z tym, co dawno zapowiedzieli prorocy. Marny jednak los tego, kto Mnie wyda. Lepiej byłoby, aby się wcale nie urodził! ");
INSERT INTO polsz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judasz również Go zapytał: —To ja, Nauczycielu? —Sam to powiedziałeś—odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Później, podczas kolacji, Jezus wziął do rąk chleb. Podziękował za niego Bogu, połamał go na kawałki, i podał uczniom, mówiąc: —Weźcie i jedzcie, to jest moje ciało. ");
INSERT INTO polsz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wziął też do ręki kielich z winem. Podziękował, podał uczniom, i powiedział: —Pijcie z niego wszyscy. ");
INSERT INTO polsz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","To jest moja krew, pieczętująca przymierze. Przelewam ją, aby wielu otrzymało przebaczenie grzechów. ");
INSERT INTO polsz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mówię wam, że nie skosztuję już wina do dnia, gdy będę pił nowe wino w królestwie mojego Ojca. ");
INSERT INTO polsz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Potem zaśpiewali pieśń i poszli na Górę Oliwną. Wtedy Jezus powiedział: ");
INSERT INTO polsz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","—Jeszcze tej nocy wszyscy Mnie opuścicie. Stanie się tak, jak Bóg zapowiedział ustami proroków: „Uderzę pasterza i rozproszą się owce jego stada”. ");
INSERT INTO polsz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lecz gdy znów powrócę do życia, udam się do Galilei i tam się z wami spotkam. ");
INSERT INTO polsz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","—Ja nigdy Cię nie opuszczę!—zapewniał Piotr. —Nawet jeśli inni odejdą od Ciebie! ");
INSERT INTO polsz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","—Zapewniam cię, że jeszcze tej nocy, zanim o świcie zapieje kogut, trzy razy zaprzeczysz, że Mnie znasz—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Nigdy!—zaprotestował Piotr. —Nie wyprę się Ciebie, nawet gdybym miał iść z Tobą na śmierć! Pozostali również przysięgali wierność Jezusowi. ");
INSERT INTO polsz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Następnie wszyscy razem udali się do ogrodu Getsemane. Gdy dotarli na miejsce, Jezus rzekł: —Usiądźcie tutaj, a ja pójdę tam się modlić. ");
INSERT INTO polsz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Zabrał ze sobą tylko Piotra oraz synów Zebedeusza—Jakuba i Jana. I ogarnął Go smutek oraz głęboki niepokój. ");
INSERT INTO polsz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","—Moją duszę ogarnął śmiertelny smutek—powiedział. —Zostańcie ze Mną i czuwajcie. ");
INSERT INTO polsz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Odszedł na bok, padł na twarz i modlił się: —Ojcze mój, jeśli to możliwe, oddal ode Mnie ten „kielich cierpienia”. Jednak to Twoja wola niech się stanie, a nie to, czego ja chcę. ");
INSERT INTO polsz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wrócił do trzech uczniów i zastał ich śpiących. Wtedy powiedział do Piotra: —Nie daliście rady czuwać ze Mną nawet przez godzinę? ");
INSERT INTO polsz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Uważajcie i módlcie się, abyście nie poddali się pokusie! Duch jest gorliwy, ale ciało słabe. ");
INSERT INTO polsz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ponownie odszedł i modlił się: —Ojcze mój, jeśli nie może Mnie ominąć ten „kielich”, to niech się stanie Twoja wola. ");
INSERT INTO polsz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Lecz uczniowie byli tak bardzo zmęczeni, że gdy do nich wrócił, znowu spali. ");
INSERT INTO polsz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Odszedł więc po raz trzeci i raz jeszcze modlił się o to samo. ");
INSERT INTO polsz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Po skończeniu modlitwy wrócił do nich i powiedział: —Wciąż spokojnie śpicie i odpoczywacie? Wybiła moja godzina. Teraz Ja, Syn Człowieczy, zostanę wydany w ręce grzeszników. ");
INSERT INTO polsz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wstańcie, chodźmy! Nadchodzi już ten, który Mnie zdradził! ");
INSERT INTO polsz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ledwie skończył mówić, stanął przed Nim Judasz, jeden z Dwunastu, na czele zgrai uzbrojonej w miecze i pałki, wysłanej przez najwyższych kapłanów i starszych. ");
INSERT INTO polsz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ten zdrajca tak się z nimi umówił: „Łapcie tego, którego pocałuję na powitanie”. ");
INSERT INTO polsz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Gdy więc tylko się zbliżyli, Judasz podszedł do Jezusa. —Witaj, Mistrzu!—rzekł i przywitał Go pocałunkiem. ");
INSERT INTO polsz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","—Przyjacielu!—rzekł Jezus. —Po co przyszedłeś? Wówczas pozostali rzucili się na Niego i złapali Go. ");
INSERT INTO polsz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Wtedy jeden z uczniów szybko wyjął miecz, zamachnął się i odciął ucho słudze najwyższego kapłana. ");
INSERT INTO polsz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","—Schowaj miecz!—powiedział Jezus. —Ci, którzy mieczem walczą, od miecza giną. ");
INSERT INTO polsz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Myślisz, że na moją prośbę Ojciec nie posłałby tu dwunastu oddziałów aniołów? ");
INSERT INTO polsz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ale czy wtedy wypełniłyby się zapowiedzi Pisma? ");
INSERT INTO polsz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Następnie zwrócił się do tych, którzy Go aresztowali: —Czy jestem jakimś groźnym przestępcą, że przyszliście po Mnie aż tak uzbrojeni? Dlaczego nie zatrzymaliście Mnie w świątyni? Przecież codziennie tam nauczałem! ");
INSERT INTO polsz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wszystko jednak dzieje się zgodnie z tym, co przepowiedziały o Mnie proroctwa. Wtedy wszyscy uczniowie opuścili Go i uciekli. ");
INSERT INTO polsz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Napastnicy zaprowadzili Jezusa do rezydencji Kajfasza, u którego wkrótce zebrali się przywódcy religijni i starsi. ");
INSERT INTO polsz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piotr zaś, który podążał za Jezusem, trzymając się z daleka, wszedł za nimi i usiadł razem z żołnierzami. Czekał, co będzie dalej. ");
INSERT INTO polsz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Najwyżsi kapłani wraz z całą Wysoką Radą przesłuchiwali świadków, by znaleźć jakieś fałszywe oskarżenie przeciw Jezusowi i skazać Go na śmierć. ");
INSERT INTO polsz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ale pomimo wielu fałszywych zeznań nie udało się im to. W końcu znalazło się dwóch, ");
INSERT INTO polsz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","którzy zgodnie oświadczyli: —Ten człowiek powiedział: „Mogę zburzyć Bożą świątynię i w trzy dni ją odbudować!”. ");
INSERT INTO polsz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wtedy najwyższy kapłan wstał i zapytał Jezusa: —Nie będziesz się bronił wobec tych oskarżeń? ");
INSERT INTO polsz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lecz Jezus milczał. Wtedy najwyższy kapłan zadał mu kolejne pytanie: —W imię żyjącego Boga żądam, abyś odpowiedział: Jesteś Mesjaszem, Synem Bożym? ");
INSERT INTO polsz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","—Sam to potwierdziłeś—rzekł Jezus. —Mówię wam: Wkrótce zobaczycie Mnie, Syna Człowieczego, zasiadającego na tronie z Bogiem i powracającego w obłokach na ziemię. ");
INSERT INTO polsz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Słysząc to, najwyższy kapłan rozdarł szaty i powiedział: —To bluźnierstwo! Czego więcej trzeba? Po co nam świadkowie? Sami słyszeliście bluźnierstwo! ");
INSERT INTO polsz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Jaki jest wasz wyrok? —Kara śmierci!—zawołali. ");
INSERT INTO polsz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","I zaczęli pluć Jezusowi w twarz i bić po głowie. Ci, którzy Go bili, ");
INSERT INTO polsz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","szyderczo wołali: —Teraz prorokuj, Mesjaszu! Zgadnij, kto Cię teraz uderzył? ");
INSERT INTO polsz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tymczasem Piotr wciąż przebywał na dziedzińcu rezydencji. Nagle podeszła do niego jakaś dziewczyna i powiedziała: —Ty też byłeś z Jezusem z Galilei! ");
INSERT INTO polsz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","—Nie wiem, o czym mówisz!—zaprzeczył wobec wszystkich Piotr. ");
INSERT INTO polsz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Odszedł do bramy wejściowej, ale zauważyła go tam inna służąca. —On był z Jezusem z Nazaretu!—powiedziała do stojących. ");
INSERT INTO polsz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","—Nawet nie znam tego Człowieka!—przysięgając zaprzeczył Piotr. ");
INSERT INTO polsz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Po pewnej chwili stojący tam ludzie podeszli do niego i stwierdzili: —Na pewno i ty jesteś jednym z jego uczniów. Twój galilejski akcent cię zradza. ");
INSERT INTO polsz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","—Naprawdę Go nie znam!!!—znowu zaczął się zaklinać i przysięgać. I wtedy właśnie zapiał kogut. ");
INSERT INTO polsz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Wówczas Piotr przypomniał sobie słowa Jezusa: „Zanim o świcie zapieje kogut, trzy razy zaprzeczysz, że Mnie znasz”. Odszedł stamtąd i gorzko zapłakał. ");
INSERT INTO polsz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Następnego dnia, wczesnym rankiem, najwyżsi kapłani i starsi ponownie zebrali się, aby ustalić, jak doprowadzą do wykonania na Jezusie wyroku śmierci. ");
INSERT INTO polsz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ostatecznie postanowili przekazać Jezusa pod zbrojną eskortą Piłatowi, rzymskiemu gubernatorowi. ");
INSERT INTO polsz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Gdy Judasz, zdrajca, dowiedział, że Jezus został skazany za śmierć, zaczął żałować swojego czynu i odniósł pieniądze—trzydzieści srebrnych monet—najwyższym kapłanom i starszym. ");
INSERT INTO polsz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Zgrzeszyłem!—oświadczył. —Wydałem niewinnego człowieka. —Co nas to obchodzi? To twój problem!—odparli. ");
INSERT INTO polsz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judasz rzucił wtedy pieniądze na posadzkę świątyni, wybiegł i powiesił się. ");
INSERT INTO polsz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kapłani podnieśli srebrniki. —Nie można ich umieścić w skarbcu—orzekli—bo są zapłatą za morderstwo. ");
INSERT INTO polsz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Po naradzie postanowili przeznaczyć je na zakup Pola Garncarzy i założyć tam cmentarz dla cudzoziemców. ");
INSERT INTO polsz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Dlatego miejsce to do dzisiaj nazywa się Polem Krwi. ");
INSERT INTO polsz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","W ten sposób spełniło się proroctwo Jeremiasza: „Wzięli trzydzieści srebrnych monet, bo na tyle Go wycenili synowie Izraela, ");
INSERT INTO polsz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","i kupili Pole Garncarzy—jak im rozkazał Pan”. ");
INSERT INTO polsz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gdy Jezus stanął przed gubernatorem Piłatem, ten zapytał Go: —Jesteś Królem Żydów? —Sam to potwierdzasz—odpowiedział mu Jezus. ");
INSERT INTO polsz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","A obecni tam najwyżsi kapłani i starsi wysuwali przeciwko Niemu wiele zarzutów, ale Jezus nie odpowiadał. Wtedy Piłat zwrócił się do Niego: ");
INSERT INTO polsz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","—Czy nie słyszysz tych wszystkich oskarżeń? ");
INSERT INTO polsz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lecz, ku jego wielkiemu zdziwieniu, Jezus nie odpowiedział na żaden z zarzutów. ");
INSERT INTO polsz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","A był zwyczaj, że raz w roku, na święto Paschy, gubernator uwalniał na prośbę ludu jednego żydowskiego więźnia. ");
INSERT INTO polsz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","W tym czasie przebywał właśnie w więzieniu znany przestępca—Barabasz. ");
INSERT INTO polsz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Gdy więc przed rezydencją Piłata zebrali się ludzie, ten zapytał ich: —Kogo mam wam wypuścić? Barabasza czy Jezusa, zwanego Mesjaszem? ");
INSERT INTO polsz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Zorientował się bowiem, że to z nienawiści uknuto ten spisek przeciw Jezusowi. ");
INSERT INTO polsz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Gdy tak siedział na fotelu sędziowskim, żona przysłała mu wiadomość: —Zostaw w spokoju tego prawego człowieka. Dziś w nocy miałam z jego powodu straszny sen! ");
INSERT INTO polsz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tymczasem kapłani i starsi przekonali tłum, aby prosił o uwolnienie Barabasza i żądał śmierci dla Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","—Którego z nich mam wam wypuścić?—spytał ponownie gubernator. —Barabasza!—zawołali. ");
INSERT INTO polsz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—Co mam zatem zrobić z Jezusem Mesjaszem? —Ukrzyżuj go!—zawołali w odpowiedzi. ");
INSERT INTO polsz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—Ale dlaczego?—dopytywał Piłat. —Jakie przestępstwo popełnił? Oni jednak nie słuchali go i coraz głośniej wołali: —Ukrzyżuj go!!! ");
INSERT INTO polsz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Piłat, widząc, że nic nie wskóra i że robi się coraz większe zamieszanie, na oczach tłumu umył ręce i rzekł: —Nie jestem winien jego śmierci! To wasza odpowiedzialność! ");
INSERT INTO polsz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","—Dobrze! Bierzemy ją na siebie i naszych potomków!—zawołał cały tłum. ");
INSERT INTO polsz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wypuścił więc Barabasza, a Jezusa kazał ubiczować i skazał Go na śmierć przez ukrzyżowanie. ");
INSERT INTO polsz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Żołnierze gubernatora wyprowadzili Go na dziedziniec i zwołali cały oddział. ");
INSERT INTO polsz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ubrali Go w szkarłatny płaszcz ");
INSERT INTO polsz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","i włożyli na Jego głowę koronę uplecioną z długich, ostrych cierni, a do prawej ręki dali kij. I klękali przed Nim, naśmiewając się: —Niech żyje Król Żydów! ");
INSERT INTO polsz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Opluwali Go też, brali Jego kij i bili Go po głowie. ");
INSERT INTO polsz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kiedy im się to znudziło, ściągnęli z Niego płaszcz, nałożyli Mu z powrotem Jego własne ubranie i poprowadzili na ukrzyżowanie. ");
INSERT INTO polsz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Po drodze zatrzymali niejakiego Szymona z Cyreny i zmusili go, aby niósł Jego krzyż. ");
INSERT INTO polsz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","W ten sposób doprowadzili Jezusa na miejsce zwane Golgotą (to znaczy: „Czaszką”). ");
INSERT INTO polsz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tam podali Mu do picia kwaśne wino. Spróbował, ale nie chciał go pić. ");
INSERT INTO polsz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Potem Go ukrzyżowali, a o Jego ubranie rzucili losy. ");
INSERT INTO polsz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Następnie usiedli i pilnowali Go. ");
INSERT INTO polsz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A nad Jego głową przybili do krzyża tabliczkę z opisem winy: „to jest jezus, król żydów”. ");
INSERT INTO polsz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Po obu stronach Jezusa ukrzyżowano dwóch przestępców. ");
INSERT INTO polsz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Przechodzący obok ludzie śmiali się z Niego. Patrzyli z pogardą i wołali: ");
INSERT INTO polsz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Widzisz, jak skończyłeś? Mówiłeś, że potrafisz zburzyć i w trzy dni odbudować świątynię! Skoro jesteś taki mocny, uratuj teraz siebie samego i zejdź z krzyża! Podobno jesteś Synem Bożym! ");
INSERT INTO polsz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Stali tam również najwyżsi kapłani i inni przywódcy religijni. Oni także naśmiewali się z Jezusa: ");
INSERT INTO polsz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Innych potrafił ratować, a siebie uratować nie może! Taki z niego Król Izraela? Niech zejdzie z krzyża, to mu uwierzymy! ");
INSERT INTO polsz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tak ufał Bogu, to niech go teraz uratuje, o ile zechce. Przecież powtarzał: „Jestem Synem Boga”. ");
INSERT INTO polsz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tak samo naśmiewali się z Niego wiszący obok przestępcy. ");
INSERT INTO polsz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nagle, około południa całą ziemię okrył mrok i aż do godziny trzeciej było ciemno. ");
INSERT INTO polsz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wtedy właśnie Jezus głośno zawołał: —Eloi, Eloi, lema sabachthani! (co znaczy: „Boże mój, Boże mój, czemu Mnie opuściłeś?”). ");
INSERT INTO polsz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Stojący w pobliżu ludzie sądzili, że woła proroka Eliasza. ");
INSERT INTO polsz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jeden z nich podbiegł po gąbkę, nasączył ją kwaśnym winem i na kiju podał Jezusowi, żeby się napił. ");
INSERT INTO polsz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Lecz pozostali mówili: —Zostaw go! Zobaczymy, czy zjawi się Eliasz, żeby go uratować. ");
INSERT INTO polsz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Lecz Jezus wydał jeszcze jeden okrzyk i skonał. ");
INSERT INTO polsz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","W tej samej chwili zasłona w świątyni, oddzielająca miejsce najświętsze, rozdarła się na dwie części—od góry aż do dołu. Zatrzęsła się również ziemia i popękały skały. ");
INSERT INTO polsz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Otworzyły się groby i wielu umarłych, którzy byli ludźmi kochającymi Boga, powstało z martwych. ");
INSERT INTO polsz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Później, po zmartwychwstaniu Jezusa, udali się do Jerozolimy, świętego miasta, gdzie widziało ich wielu ludzi. ");
INSERT INTO polsz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Rzymski dowódca i jego żołnierze pilnujący Jezusa na widok trzęsienia ziemi i wszystkich tych zjawisk przerazili się. —To naprawdę był Syn Boży!—wołali. ");
INSERT INTO polsz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wiele kobiet, które przyszły z Jezusem z Galilei, aby Mu pomagać, przyglądało się temu wszystkiemu z daleka. ");
INSERT INTO polsz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wśród nich były Maria z Magdali, Maria—matka Jakuba i Józefa, oraz matka synów Zebedeusza. ");
INSERT INTO polsz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Gdy zapadł wieczór, pewien bogaty człowiek—Józef z Arymatei, będący uczniem Jezusa— ");
INSERT INTO polsz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","udał się do Piłata i poprosił o ciało Jezusa. Ten polecił mu je wydać. ");
INSERT INTO polsz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Józef wziął je, owinął w długie lniane płótno ");
INSERT INTO polsz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","i złożył w swoim nowym grobowcu, wykutym w skale. ");
INSERT INTO polsz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria z Magdali i druga Maria zostały tam, siedząc naprzeciwko grobu. ");
INSERT INTO polsz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nazajutrz, pierwszego dnia święta Paschy, najwyżsi kapłani i faryzeusze udali się do Piłata ");
INSERT INTO polsz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","i oznajmili: —Panie, przypomnieliśmy sobie, że ten kłamca mówił jeszcze za życia: „Po trzech dniach zmartwychwstanę”. ");
INSERT INTO polsz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Wydaj więc rozkaz opieczętowania grobu na trzy dni, aby przypadkiem jego uczniowie nie wykradli ciała i nie rozgłaszali tłumom: „On zmartwychwstał!”. Bo to ostatnie kłamstwo byłoby gorsze od pierwszego. ");
INSERT INTO polsz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","—Weźcie straż i zabezpieczcie miejsce najlepiej, jak potraficie—odrzekł Piłat. ");
INSERT INTO polsz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Poszli więc do grobowca, zapieczętowali kamień zamykający wejście i postawili straże. ");
INSERT INTO polsz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Po szabacie, pierwszego dnia tygodnia, wczesnym rankiem Maria z Magdali i druga Maria poszły obejrzeć grobowiec. ");
INSERT INTO polsz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nagle gwałtownie zatrzęsła się ziemia. Anioł Pana zstąpił z nieba, odsunął kamień od grobowca i usiadł na nim. ");
INSERT INTO polsz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wyglądał jak błyskawica, a jego szata—jak śnieg. ");
INSERT INTO polsz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na jego widok strażnicy zadrżeli ze strachu i padli na ziemię jak martwi. ");
INSERT INTO polsz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Wtedy anioł odezwał się do kobiet: —Nie bójcie się! Wiem, że szukacie Jezusa, którego ukrzyżowano. ");
INSERT INTO polsz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nie ma Go tutaj! Powstał z martwych, jak zapowiedział. Wejdźcie i zobaczcie miejsce, gdzie był złożony! ");
INSERT INTO polsz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Teraz zaś szybko wracajcie do Jego uczniów i powiedzcie im: „On zmartwychwstał i oczekuje was w Galilei. Tam właśnie was spotka”. To miałem wam przekazać. ");
INSERT INTO polsz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Przestraszone, ale pełne radości, kobiety odeszły od grobowca i pobiegły powiedzieć o tym uczniom. ");
INSERT INTO polsz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nagle na ich drodze stanął Jezus. —Witajcie!—powiedział. One zaś podeszły, padły Mu do nóg i oddały pokłon. ");
INSERT INTO polsz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Wtedy rzekł do nich: —Nie bójcie się! Idźcie i powiedzcie moim braciom, aby udali się do Galilei. Tam się zobaczymy. ");
INSERT INTO polsz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Gdy były jeszcze w drodze, niektórzy strażnicy pilnujący grobowca udali się do miasta i opowiedzieli najwyższym kapłanom o wszystkim, co zaszło. ");
INSERT INTO polsz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ci, po naradzie ze starszymi, dali strażnikom sporą łapówkę. ");
INSERT INTO polsz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Rozpowiadajcie tak: Nocą, gdy spaliśmy, jego uczniowie przyszli i wykradli ciało—powiedzieli. ");
INSERT INTO polsz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","—A gdyby gubernator usłyszał, że spaliście na służbie, obronimy was i uwolnimy od kłopotów. ");
INSERT INTO polsz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Strażnicy wzięli pieniądze i zrobili tak, jak im powiedziano. W ten sposób ta plotka rozeszła się wśród wszystkich mieszkańców Judei i trwa po dziś dzień. ");
INSERT INTO polsz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Natomiast jedenastu uczniów, zgodnie z poleceniem Jezusa, udało się do Galilei, na górę. ");
INSERT INTO polsz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Gdy Go zobaczyli, oddali Mu pokłon, ale niektórzy z nich wciąż jeszcze wątpili. ");
INSERT INTO polsz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jezus zbliżył się do nich i powiedział: —Otrzymałem wszelką władzę w niebie i na ziemi. ");
INSERT INTO polsz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Idźcie więc i pozyskujcie uczniów ze wszystkich narodów, chrzcząc ich w imię Ojca i Syna, i Ducha Świętego. ");
INSERT INTO polsz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Uczcie ich przestrzegać wszystkiego, co wam poleciłem. Ja zaś będę z wami przez wszystkie dni—aż do końca czasów.");
INSERT INTO polsz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Oto niezwykła opowieść o Jezusie—Mesjaszu, Synu Bożym. ");
INSERT INTO polsz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Już przez proroka Izajasza Bóg zapowiedział: „Oto Ja posyłam przed Tobą mojego wysłańca; on przygotuje Twoją drogę”. ");
INSERT INTO polsz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","„Głos wołającego na pustyni: Przygotujcie drogę dla Pana, prostujcie dla Niego ścieżki!” ");
INSERT INTO polsz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Posłańcem tym był Jan Chrzciciel. Mieszkał na pustyni i przekonywał ludzi, że muszą zmienić swoje grzeszne życie. Na znak zerwania z grzechem powinni pozwolić zanurzyć się w wodzie. ");
INSERT INTO polsz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mieszkańcy Jerozolimy i całej Judei podążali na Pustynię Judejską, aby zobaczyć i posłuchać Jana. Wielu z nich wyznawało swoje grzechy, a on chrzcił ich w Jordanie. ");
INSERT INTO polsz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jan nosił ubranie z wielbłądziej wełny i skórzany pas. Żywił się wyłącznie szarańczą i leśnym miodem. ");
INSERT INTO polsz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Często mówił: —Wkrótce przyjdzie Ktoś o wiele większy ode mnie—tak wielki, że ja nie jestem nawet godzien rozwiązać rzemyka Jego sandałów. ");
INSERT INTO polsz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ja zanurzam was w wodzie, lecz On zanurzy was w Duchu Świętym! ");
INSERT INTO polsz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pewnego dnia przyszedł do Jana Jezus z Nazaretu i został ochrzczony w Jordanie. ");
INSERT INTO polsz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Gdy wychodził z wody, ujrzał otwarte niebo i Ducha Świętego, który zstąpił na Niego jak gołąb. ");
INSERT INTO polsz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A z nieba rozległ się głos: —Jesteś moim ukochanym Synem, moją największą radością. ");
INSERT INTO polsz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Zaraz też Jezus, prowadzony przez Ducha Świętego, udał się na pustynię. ");
INSERT INTO polsz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tam, otoczony tylko przez pustynne zwierzęta, spędził samotnie czterdzieści dni i był kuszony przez szatana. Potem zaś przyszli do Niego aniołowie i służyli Mu. ");
INSERT INTO polsz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","A gdy król Herod uwięził Jana, Jezus udał się do Galilei, by tam głosić Bożą dobrą nowinę. ");
INSERT INTO polsz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","—Nadszedł już czas!—mówił. —Zbliża się królestwo Boże! Porzućcie grzechy i uwierzcie w dobrą nowinę! ");
INSERT INTO polsz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Pewnego dnia, idąc brzegiem Jeziora Galilejskiego, Jezus spotkał dwóch rybaków: Szymona i jego brata, Andrzeja, którzy łowili ryby. ");
INSERT INTO polsz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","—Chodźcie ze Mną!—rzekł do nich. —Uczynię was rybakami ludzi! ");
INSERT INTO polsz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Oni natychmiast zastawili sieci i poszli z Nim. ");
INSERT INTO polsz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nieco dalej zobaczył Jakuba i Jana, synów Zebedeusza, którzy siedzieli w łodzi i naprawiali sieci. ");
INSERT INTO polsz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ich również zawołał, a oni poszli z Nim, zostawiając ojca i jego pomocników. ");
INSERT INTO polsz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Razem udali się do miasta Kafarnaum. W szabat weszli do synagogi, a Jezus zaczął nauczać. ");
INSERT INTO polsz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wszyscy byli zdumieni Jego nauką. Mówił bowiem do nich nie jak ich przywódcy religijni, ale jak ktoś, kto ma władzę nad ludźmi. ");
INSERT INTO polsz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nagle jakiś człowiek, będący pod wpływem demona, zaczął wykrzykiwać: ");
INSERT INTO polsz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Dlaczego nas niepokoisz, Jezusie z Nazaretu? Czy przyszedłeś nas zniszczyć? Wiem, kim jesteś! Świętym Synem Boga! ");
INSERT INTO polsz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","—Milcz i wyjdź z tego człowieka!—rozkazał Jezus duchowi. ");
INSERT INTO polsz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Zły duch szarpnął nim gwałtownie i z krzykiem go opuścił. ");
INSERT INTO polsz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Świadkowie tego zdarzenia oniemieli z wrażenia, a następnie komentowali to, co ujrzeli: —Jaka moc jest w Jego słowach, skoro słuchają Go nawet złe duchy? ");
INSERT INTO polsz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","A wiadomość o tym wydarzeniu lotem błyskawicy obiegła Galileę i całą okolicę. ");
INSERT INTO polsz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jezus wyszedł z synagogi i wraz z Jakubem oraz Janem udał się do domu Szymona i Andrzeja. ");
INSERT INTO polsz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Teściowa Szymona miała akurat wysoką gorączkę i leżała w łóżku. Gdy powiedziano o tym Jezusowi, ");
INSERT INTO polsz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","On podszedł do chorej, wziął ją za rękę i pomógł jej się podnieść. Temperatura natychmiast spadła, a teściowa wstała i przygotowała im posiłek. ");
INSERT INTO polsz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wieczorem, już po zachodzie słońca, przyprowadzono do Jezusa wielu chorych i zniewolonych przez demony. ");
INSERT INTO polsz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Przed bramą zaś zgromadził się ogromny tłum mieszkańców, ciekawych nadchodzących wydarzeń. ");
INSERT INTO polsz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jezus uzdrowił wielu chorych i wielu demonom rozkazał opuścić swe ofiary. A ponieważ demony wiedziały, kim On jest, zabronił im cokolwiek mówić. ");
INSERT INTO polsz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Następnego dnia wstał jeszcze przed świtem i udał się na pustynię, aby się modlić. ");
INSERT INTO polsz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Po jakimś czasie odnalazł Go Szymon i pozostali uczniowie. ");
INSERT INTO polsz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","—Wszyscy o Ciebie pytają—mówili. ");
INSERT INTO polsz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","—Musimy odwiedzić także inne miasta, aby i tam nauczać!—odpowiedział Jezus. —Po to przecież przyszedłem. ");
INSERT INTO polsz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Przemierzał więc całą krainę galilejską, przemawiając w synagogach oraz uwalniając wielu ludzi od demonów. ");
INSERT INTO polsz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pewnego razu podszedł do Niego trędowaty i na kolanach błagał o uzdrowienie: —Jeśli tylko zechcesz, możesz mnie uzdrowić—prosił. ");
INSERT INTO polsz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jezus, ogarnięty współczuciem, dotknął go i rzekł: —Chcę. Bądź uzdrowiony! ");
INSERT INTO polsz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Trąd natychmiast zniknął i w jednej chwili człowiek ten odzyskał zdrowie. ");
INSERT INTO polsz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jezus zaraz go odprawił, surowo przykazując mu: ");
INSERT INTO polsz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Nie mów o tym nikomu. Idź i poproś, aby zbadał cię kapłan. A na dowód tego, że wyzdrowiałeś, zanieś ofiarę, jaką Mojżesz wyznaczył uleczonemu z trądu. ");
INSERT INTO polsz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lecz człowiek ten, idąc, opowiadał wszystkim o swoim cudownym uzdrowieniu. A Jezus, z powodu rozgłosu, nie mógł już swobodnie pokazywać się w miastach—schronił się więc na pustyni. Lecz nawet tam przychodzili do Niego ludzie. ");
INSERT INTO polsz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gdy po kilku dniach powrócił do Kafarnaum, wieść o Jego przybyciu szybko obiegła całe miasto. ");
INSERT INTO polsz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wkrótce w domu, w którym się zatrzymał, zebrało się tak wielu ludzi, że nawet przed drzwiami nie było wolnego miejsca. A Jezus głosił im słowo Boże. ");
INSERT INTO polsz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wtedy właśnie czterej mężczyźni przynieśli na noszach sparaliżowanego. ");
INSERT INTO polsz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nie mogąc przecisnąć się do Jezusa, zrobili otwór w dachu i spuścili w dół nosze z chorym. ");
INSERT INTO polsz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Gdy Jezus ujrzał ich zdecydowaną wiarę, powiedział do chorego: —Synu, odpuszczam ci grzechy! ");
INSERT INTO polsz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lecz kilku obecnych tam przywódców religijnych pomyślało z oburzeniem: ");
INSERT INTO polsz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","„Dlaczego on tak mówi?! To jawne bluźnierstwo! Przecież tylko Bóg może odpuszczać grzechy”. ");
INSERT INTO polsz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jezus, znając ich myśli, odpowiedział: —Dlaczego was to oburza? ");
INSERT INTO polsz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Co jest łatwiej powiedzieć: „Odpuszczam ci grzechy” czy „Wstań, zabierz swoje nosze i chodź!”? ");
INSERT INTO polsz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Udowodnię wam, że Ja, Syn Człowieczy, mogę odpuszczać grzechy. ");
INSERT INTO polsz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","I zwrócił się do sparaliżowanego: —Jesteś uzdrowiony! Zabierz swoje nosze i idź do domu! ");
INSERT INTO polsz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A chory wstał, wziął nosze i na oczach zebranych odszedł do domu. Wszyscy byli poruszeni tym do głębi i wielbili Boga, mówiąc: —Nigdy nie widzieliśmy czegoś podobnego! ");
INSERT INTO polsz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Wkrótce po tym wydarzeniu Jezus znowu udał się nad jezioro, by nauczać zgromadzone tam tłumy. ");
INSERT INTO polsz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Idąc brzegiem, zobaczył Lewiego—syna Alfeusza, poborcę podatkowego, który właśnie tam pracował. —Chodź ze Mną—zwrócił się do niego. A on natychmiast wstał i poszedł z Jezusem. ");
INSERT INTO polsz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Później, gdy Jezus i Jego uczniowie byli u niego w domu, zebrało się wokół stołu wielu nieuczciwych poborców podatkowych i innych ludzi, uważanych za grzeszników. Wiele takich osób znajdowało się bowiem w tłumie, który podążał za Jezusem. ");
INSERT INTO polsz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Niektórzy przywódcy religijni z ugrupowania faryzeuszy—widząc, że Jezus zasiada do stołu z ludźmi o złej reputacji—pytali uczniów: —Dlaczego wasz nauczyciel zadaje się z takimi ludźmi? ");
INSERT INTO polsz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jezus usłyszał to i odpowiedział: —To chorzy potrzebują lekarza, a nie zdrowi! Nie przyszedłem wzywać do opamiętania tych, którzy uważają się za dobrych, ale właśnie grzeszników. ");
INSERT INTO polsz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Uczniowie Jana i faryzeusze, stosując się do religijnych zaleceń, często powstrzymywali się od posiłków. Pewnego dnia kilku z nich przyszło do Jezusa, pytając: —Uczniowie Jana i faryzeusze powstrzymują się od posiłków. Dlaczego Twoi uczniowie tego nie czynią? ");
INSERT INTO polsz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","—Przecież goście na weselu, będąc z panem młodym, nie mogą odmawiać spożywania potraw!—odrzekł Jezus. —Czy mają powód do smutku, skoro on jest z nimi? ");
INSERT INTO polsz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ale nadejdzie czas, gdy zabiorą im pana młodego. Wtedy będą pościć. ");
INSERT INTO polsz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nikt nie używa nowego materiału do łatania starego ubrania, bo nowa łata się kurczy i jeszcze bardziej rozdziera ubranie. ");
INSERT INTO polsz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nikt też nie wlewa świeżego wina do starych, stwardniałych bukłaków. Mogłyby przecież popękać, a wtedy i wino by się rozlało, i bukłaki zniszczyły. Świeże wino wlewa się do nowych, miękkich bukłaków. ");
INSERT INTO polsz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Innym razem, uczniowie—idąc z Jezusem przez pole—zaczęli zrywać kłosy i jeść ziarna. A był to akurat święty dzień szabatu. ");
INSERT INTO polsz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Widząc to, przywódcy religijni zwrócili się do Jezusa z zarzutem: —Dlaczego Twoi uczniowie robią rzeczy niedozwolone w szabat? ");
INSERT INTO polsz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","—Czy nigdy nie czytaliście, co zrobił król Dawid, gdy wraz z towarzyszami podróży poczuł głód?—odpowiedział im Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","—Za czasów najwyższego kapłana Abiatara wszedł do świątyni i wziął dla siebie oraz swoich towarzyszy poświęcony chleb, który wolno było jeść tylko kapłanom. To również było niezgodne z Prawem. ");
INSERT INTO polsz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","To szabat jest dla człowieka, nie odwrotnie. ");
INSERT INTO polsz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ja, Syn Człowieczy, mam władzę nad szabatem. ");
INSERT INTO polsz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Będąc ponownie w Kafarnaum, Jezus udał się do synagogi. Zauważył tam człowieka ze sparaliżowaną ręką. ");
INSERT INTO polsz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","A ponieważ był to dzień szabatu, wrogowie uważnie Go obserwowali, chcąc oskarżyć Go, gdyby uzdrowił tego człowieka. ");
INSERT INTO polsz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jezus zawołał go, postawił przed zebranymi ");
INSERT INTO polsz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","i, zwracając się do swoich wrogów, zapytał: —Czy czynienie dobra w szabat jest przestępstwem? A może lepiej w tym dniu wyrządzać innym krzywdę? Czy w takim dniu należy ratować życie, czy raczej je niszczyć? A oni nie znaleźli na to odpowiedzi. ");
INSERT INTO polsz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ich obojętność na ludzką niedolę poruszyła Jezusa do głębi. Gniewnie spojrzał na nich, a potem rzekł do chorego: —Wyciągnij rękę! Ten posłuchał i natychmiast jego ręka stała się zdrowa. ");
INSERT INTO polsz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wtedy faryzeusze odeszli i zaczęli się naradzać ze zwolennikami rodziny królewskiej, jak zabić Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Tymczasem Jezus wraz z uczniami udał się nad jezioro. Podążały za nimi ogromne tłumy z Galilei, Judei, ");
INSERT INTO polsz_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerozolimy, Idumei, z krainy za Jordanem, a nawet z Tyru i Sydonu. Wieść o Jego cudach rozeszła się bowiem bardzo daleko i zewsząd schodzili się ludzie, aby zobaczyć Go na własne oczy. ");
INSERT INTO polsz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jezus polecił więc uczniom, by przygotowali łódź, z której mógłby przemawiać, gdyby tłum mocno na Niego napierał. ");
INSERT INTO polsz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tego dnia miało miejsce wiele uzdrowień i ogromna liczba chorych tłoczyła się wokół Niego, pragnąc Go przynajmniej dotknąć. ");
INSERT INTO polsz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na widok Jezusa, ludzie opanowani przez złe duchy padali przed Nim na twarz, krzycząc: —Jesteś Synem Bożym! ");
INSERT INTO polsz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Lecz On surowo zabraniał im to mówić. ");
INSERT INTO polsz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Potem wszedł na górę i przywołał do siebie tych, których wybrał. ");
INSERT INTO polsz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A gdy przyszli, wyznaczył spośród nich dwunastu uczniów, którzy mieli Mu zawsze towarzyszyć oraz głosić Jego naukę ");
INSERT INTO polsz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","i uwalniać ludzi od demonów. ");
INSERT INTO polsz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Oto ich imiona: Szymon, któremu Jezus nadał imię Piotr, ");
INSERT INTO polsz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakub i Jan—synowie Zebedeusza, nazwani przez Jezusa Synami Gromu, ");
INSERT INTO polsz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrzej, Filip, Bartłomiej, Mateusz, Tomasz, Jakub—syn Alfeusza, Tadeusz, Szymon Gorliwy ");
INSERT INTO polsz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","i Judasz z Kariotu—ten, który później wydał Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Gdy zaś powrócił z nimi do domu, w którym udzielono Mu gościny, znów zaczęły nadchodzić tłumy. I wkrótce było tylu ludzi, że Jezus z uczniami nie mieli nawet czasu, by cokolwiek zjeść. ");
INSERT INTO polsz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Gdy Jego krewni usłyszeli, co się dzieje, przyszli z zamiarem zabrania Go do domu. —Musiał postradać zmysły!—mówili. ");
INSERT INTO polsz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Natomiast przywódcy religijni, którzy przybyli z Jerozolimy, stwierdzili: —On jest opętany przez Belzebuba! Wypędza demony, bo władca demonów Mu w tym pomaga. ");
INSERT INTO polsz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jezus przywołał ich i w prosty sposób wyjaśnił: —Jak szatan może wypędzać szatana? ");
INSERT INTO polsz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Każde królestwo, które jest wewnętrznie skłócone, upadnie. ");
INSERT INTO polsz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Dom pełen kłótni i podziałów jest przecież skazany na zagładę. ");
INSERT INTO polsz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Gdyby szatan walczył sam ze sobą, jak mógłby przetrwać? ");
INSERT INTO polsz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Chcąc przeszukać i okraść dom siłacza, trzeba go przecież najpierw obezwładnić! ");
INSERT INTO polsz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Oświadczam wam, że każdy grzech może zostać odpuszczony człowiekowi, nawet jeśli jest to bluźnierstwo pod adresem mojego Ojca. ");
INSERT INTO polsz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Jeśli jednak ktoś bluźni przeciwko Duchowi Świętemu, nigdy nie otrzyma odpuszczenia i na wieki pozostanie winien grzechu. ");
INSERT INTO polsz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","A powiedział to, ponieważ twierdzili, że cuda, których dokonuje, mają miejsce za sprawą szatana. ");
INSERT INTO polsz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Gdy Jezus nauczał, Jego matka i bracia przyszli do zatłoczonego domu i prosili, aby Go wywołano na zewnątrz, gdyż chcieli z Nim porozmawiać. ");
INSERT INTO polsz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","—Twoja matka i bracia szukają Cię—doniesiono Jezusowi. ");
INSERT INTO polsz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","—Kto jest moją matką i moimi braćmi?—zapytał Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Patrząc na siedzących wokół Niego ludzi, rzekł: —Oto moja matka i moi bracia! ");
INSERT INTO polsz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Moim bratem i siostrą, i matką jest każdy, kto wypełnia wolę Boga. ");
INSERT INTO polsz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Gdy ponownie przyszedł nad jezioro, aby nauczać, zgromadził się wokół Niego wielki tłum ludzi. Poprosił więc o łódź, usiadł w niej i stamtąd mówił do zebranych. ");
INSERT INTO polsz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Przemawiając, posługiwał się przypowieściami: ");
INSERT INTO polsz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Posłuchajcie! Pewien rolnik postanowił zasiać ziarno. Gdy rozsiewał je na polu, ");
INSERT INTO polsz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","niektóre nasiona upadły na udeptaną ścieżkę i zostały wydziobane przez ptaki. ");
INSERT INTO polsz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Inne ziarna upadły na cienką warstwę gleby, pod którą była skała. ");
INSERT INTO polsz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Te, choć szybko wyrosły, wkrótce zwiędły w słonecznym upale i zginęły, ponieważ w płytkiej glebie ich korzenie nie znalazły dosyć wody. ");
INSERT INTO polsz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Jeszcze inne upadły między chwasty i niebawem zostały przez nie zagłuszone, tak że nie dały żadnego plonu. ");
INSERT INTO polsz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Niektóre jednak trafiły na dobrą glebę. Wzeszły, wyrosły i dały po trzydzieści, po sześćdziesiąt, a nawet po sto ziaren plonu. ");
INSERT INTO polsz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kto ma uszy do słuchania, niech słucha uważnie! ");
INSERT INTO polsz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Później, gdy znalazł się sam na sam z Dwunastoma i innymi uczniami, zapytali Go: —Co oznacza Twoja przypowieść? ");
INSERT INTO polsz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","—Wam dano zrozumieć tajemnice dotyczące królestwa Bożego—wyjaśnił. —Ale ludzie, którzy do niego nie należą, nie rozumieją ich. ");
INSERT INTO polsz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Będą patrzeć, lecz nie zobaczą, będą słuchać, lecz nie usłyszą. Niczego nie zrozumieją i nie zwrócą się do Boga, aby przebaczył ich grzechy. ");
INSERT INTO polsz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jeśli jednak nie potraficie zrozumieć tego prostego przykładu, jakże pojmiecie inne przypowieści, które wam jeszcze opowiem? ");
INSERT INTO polsz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Siewca sieje słowo. ");
INSERT INTO polsz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ziarno posiane na udeptanej ścieżce to ci, którzy słyszą słowo, ale natychmiast zjawia się przy nich szatan i wykrada to, co zapadło w sercu. ");
INSERT INTO polsz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ziarno na gruncie skalistym oznacza tych, którzy słuchają i z radością przyjmują słowo. ");
INSERT INTO polsz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Brak im jednak mocnych korzeni. Są niestali i w obliczu trudności lub prześladowań z powodu słowa załamują się. ");
INSERT INTO polsz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ziarnem posianym wśród chwastów są ludzie, którzy słuchają słowa, ");
INSERT INTO polsz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ale zmartwienia, pogoń za bogactwem i inne rzeczy zagłuszają je, tak że nie przynosi ono w ich życiu żadnego plonu. ");
INSERT INTO polsz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dobra gleba oznacza natomiast tych, którzy słuchają słowa, przyjmują je i wydają obfity plon: trzydzieści, sześćdziesiąt, a nawet sto razy większy. ");
INSERT INTO polsz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Później Jezus zapytał ich: —Czy ktoś zapala lampę, aby ją zaraz zasłonić? Przecież nie mógłby korzystać z jej światła?! Stawia ją raczej wysoko, aby wszystko oświetlała i była użyteczna. ");
INSERT INTO polsz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wszystko, co jest teraz ukryte, wyjdzie kiedyś na światło dzienne. ");
INSERT INTO polsz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kto ma uszy do słuchania, niech słucha uważnie! ");
INSERT INTO polsz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Dobrze zastanówcie się nad tym, co słyszycie: jaką miarą mierzycie, taką wam odmierzą i jeszcze wam dodadzą. ");
INSERT INTO polsz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ten, kto ma, otrzyma jeszcze więcej, a temu, kto nie ma, zostanie odebrane nawet to, co posiada. ");
INSERT INTO polsz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Posłuchajcie! Z królestwem Bożym dzieje się tak, jak z posianym przez rolnika ziarnem. ");
INSERT INTO polsz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","W miarę upływu czasu nasiona kiełkują i rosną—bez jego pomocy! ");
INSERT INTO polsz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sprawia to sama ziemia. Najpierw ukazują się źdźbła, potem kształtują się kłosy, a w końcu dojrzewa ziarno. ");
INSERT INTO polsz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wtedy przychodzi rolnik i kosi pole, bo jest pora na żniwo. ");
INSERT INTO polsz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jak inaczej mam wam opisać Boże królestwo?—zapytał Jezus. —Z czym jeszcze można je porównać? ");
INSERT INTO polsz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Podobne jest ono do małego ziarnka gorczycy, które—będąc chyba najmniejszym z ziaren— ");
INSERT INTO polsz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","wyrasta na krzew zaliczany do największych, a na jego rozłożystych gałęziach ptaki budują sobie gniazda. ");
INSERT INTO polsz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Takimi przypowieściami posługiwał się Jezus, by w jak najbardziej przystępny sposób przekazać ludziom Bożą naukę i by byli w stanie ją pojąć. ");
INSERT INTO polsz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nauczając ludzi publicznie, używał wyłącznie przypowieści, lecz później, gdy był sam z uczniami, wszystko im wyjaśniał. ");
INSERT INTO polsz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Gdy zapadł wieczór, Jezus zwrócił się do uczniów: —Przepłyńmy na drugi brzeg jeziora. ");
INSERT INTO polsz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","I natychmiast wyruszyli, pozostawiając tłum na brzegu, a Jego—tak jak był—zabrali do łodzi. Także kilka innych łodzi popłynęło za nimi. ");
INSERT INTO polsz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Niebawem zerwała się straszliwa burza. Wysokie fale zalewały łódź, tak że zaczęła tonąć. ");
INSERT INTO polsz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jezus tymczasem spał w tylnej części łodzi. Zrozpaczeni uczniowie obudzili Go krzycząc: —Mistrzu! Czy nie obchodzi Cię to, że zaraz utoniemy? ");
INSERT INTO polsz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","On wstał, wstrzymał wiatr, a morzu rozkazał: —Ucisz się! Wiatr natychmiast ustał i zaległa głęboka cisza. ");
INSERT INTO polsz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","—Dlaczego się tak boicie?—zapytał uczniów. —Czy jeszcze nie macie wiary? ");
INSERT INTO polsz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","—Kim On jest—zastanawiali się, przejęci lękiem—że nawet wiatr i jezioro są Mu posłuszne? ");
INSERT INTO polsz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Gdy przybyli na drugi brzeg jeziora, do krainy Gerazeńczyków, ");
INSERT INTO polsz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","i gdy Jezus wysiadł z łodzi, z pobliskiego cmentarza przybiegł człowiek opanowany przez nieczyste duchy. ");
INSERT INTO polsz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mężczyzna ten mieszkał w grobowcach i był tak silny, że gdy zakuwano jego ręce i nogi w kajdany ");
INSERT INTO polsz_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","—co zdarzało się bardzo często—rozrywał je i uciekał. Nikt też nie miał dość siły, żeby go obezwładnić. ");
INSERT INTO polsz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dniami i nocami błąkał się wśród grobów i wzgórz, krzycząc i kalecząc się ostrymi kamieniami. ");
INSERT INTO polsz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Gdy z daleka zobaczył Jezusa, przybiegł, padł przez Nim na twarz ");
INSERT INTO polsz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","i głośno krzyknął: —Czego ode mnie chcesz, Jezusie, Synu Najwyższego Boga? Błagam, nie męcz mnie! ");
INSERT INTO polsz_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jezus zwrócił się do demona: —Wyjdź z niego, duchu nieczysty! ");
INSERT INTO polsz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Zapytał też go: —Jak ci na imię? —Legion, bo jest nas wielu w tym człowieku—odrzekł. ");
INSERT INTO polsz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","I błagały Go demony, żeby ich nie wyrzucał z tamtej okolicy. ");
INSERT INTO polsz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A na pobliskim wzgórzu, nad jeziorem, pasło się właśnie wielkie stado świń. ");
INSERT INTO polsz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","—Pozwól nam wejść w te świnie—prosiły. ");
INSERT INTO polsz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A gdy Jezus zgodził się, złe duchy opuściły człowieka i weszły w świnie, po czym całe stado, liczące około dwa tysiące sztuk, rzuciło się pędem ze stromego zbocza wprost do jeziora i utonęło. ");
INSERT INTO polsz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pasterze stada uciekli wtedy do pobliskiego miasta i okolicznych wiosek, opowiadając wszystkim o tym, co się stało. Ludzie wyszli z domów, aby zobaczyć, co się dzieje, ");
INSERT INTO polsz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","i wkrótce wokół Jezusa zgromadził się spory tłum. A gdy dostrzegli szaleńca, który siedział teraz ubrany, spokojny i w pełni władz umysłowych, przestraszyli się. ");
INSERT INTO polsz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Naoczni świadkowie opowiedzieli przybyłym o wszystkim, co się wydarzyło. ");
INSERT INTO polsz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wówczas tłum zaczął błagać Jezusa, żeby opuścił ich okolicę. ");
INSERT INTO polsz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jezus wszedł więc do łodzi, a wtedy uzdrowiony zapytał Go, czy może z Nim pozostać. ");
INSERT INTO polsz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jezus jednak odmówił: —Wracaj do domu, do swoich krewnych—powiedział—i opowiedz im, co zrobił dla ciebie Pan i jak wielkie okazał ci miłosierdzie. ");
INSERT INTO polsz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Poszedł więc i opowiadał w Dekapolu o tym, co Jezus dla niego uczynił; a ludzie słuchali go pełni zdumienia. ");
INSERT INTO polsz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Gdy Jezus przeprawił się na drugą stronę jeziora, na brzegu czekał na Niego wielki tłum. ");
INSERT INTO polsz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Był tam także Jair, przełożony miejscowej synagogi, który padł przed Jezusem na twarz i błagał o uzdrowienie swojej córeczki. ");
INSERT INTO polsz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Jest umierająca—mówił zrozpaczony. —Proszę, połóż na nią ręce i przywróć ją do życia! ");
INSERT INTO polsz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jezus poszedł więc z Jairem, a za nim—wielki tłum ludzi. ");
INSERT INTO polsz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wśród nich znajdowała się kobieta, która od dwunastu lat cierpiała na krwotok. ");
INSERT INTO polsz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Lekarze zadali jej wiele cierpień, ale choć wydała na nich wszystkie pieniądze, nie było poprawy—przeciwnie, jej stan się pogorszył. ");
INSERT INTO polsz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Gdy więc usłyszała o nadzwyczajnych cudach Jezusa, przecisnęła się przez tłum i dotknęła z tyłu Jego ubrania. ");
INSERT INTO polsz_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Myślała bowiem: „Jeśli tylko dotknę Jego płaszcza, zostanę uzdrowiona”. ");
INSERT INTO polsz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Gdy Go dotknęła, krwotok natychmiast ustał i poczuła, że jest już zdrowa. ");
INSERT INTO polsz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jezus od razu zorientował się, że wyszła z Niego uzdrawiająca moc. Odwrócił się więc do tłumu i zapytał: —Kto dotknął mojego płaszcza? ");
INSERT INTO polsz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Na to Jego uczniowie odpowiedzieli: —Mnóstwo ludzi tłoczy się wokół Ciebie, a Ty pytasz, kto Cię dotknął? ");
INSERT INTO polsz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lecz On nadal rozglądał się za tym, kto to zrobił. ");
INSERT INTO polsz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wówczas kobieta, będąc ciągle pod wrażeniem tego, co zaszło, drżąc ze strachu, upadła Mu do nóg i przyznała się do wszystkiego. ");
INSERT INTO polsz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","—Córko! Uwierzyłaś, więc zostałaś uzdrowiona. Idź w pokoju i ciesz się zdrowiem!—odrzekł jej Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","A gdy jeszcze z nią rozmawiał, przybyli posłańcy z domu Jaira z wiadomością, że jego córka umarła i nie ma już po co fatygować Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Lecz Jezus, nie zważając na to, co mówią, rzekł do Jaira: —Uwierz Mi i niczego się nie bój! ");
INSERT INTO polsz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Powstrzymał idący tłum i udał się do jego domu, biorąc ze sobą tylko Piotra, Jakuba i Jana. ");
INSERT INTO polsz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Panowało tam zamieszanie, słychać było płacz i zawodzenie. ");
INSERT INTO polsz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jezus wszedł do środka i rzekł: —Po co ten lament i popłoch? Dziecko przecież nie umarło, tylko śpi! ");
INSERT INTO polsz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Słysząc to, wyśmiewali Go. Lecz On rozkazał, by wszyscy wyszli, a sam z trzema uczniami oraz ojcem i matką dziewczynki wszedł do pokoju, gdzie leżała. ");
INSERT INTO polsz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wziął ją za rękę i powiedział: —Talitha kum! (co znaczy: „Dziewczynko, mówię ci: Wstań!”). ");
INSERT INTO polsz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ona natychmiast wstała z łóżka i zaczęła biegać, miała bowiem dwanaście lat. Rodzice oniemieli. ");
INSERT INTO polsz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jezus zaś surowo im przykazał, aby nikomu nie mówili o tym wydarzeniu, i polecił, by dano jej coś do jedzenia. ");
INSERT INTO polsz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Wkrótce potem opuścił tę okolicę i powrócił z uczniami do rodzinnego Nazaretu. ");
INSERT INTO polsz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","W dzień szabatu poszedł do synagogi i tam nauczał. Jego mądrość i cuda, jakie czynił, zastanawiały ludzi. Był przecież jednym z nich—zwyczajnym mieszkańcem tego miasteczka. ");
INSERT INTO polsz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mówili więc między sobą: —Czy on jest lepszy od nas? Przecież to zwyczajny cieśla, syn Marii, a brat Jakuba, Józefa, Judy i Szymona; jego siostry także przecież tutaj mieszkają. I nie byli w stanie uwierzyć w Jego moc. ");
INSERT INTO polsz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Wtedy Jezus rzekł do nich: —Prorok może cieszyć się poważaniem wszędzie, z wyjątkiem swojego miasta, swojej rodziny i krewnych. ");
INSERT INTO polsz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","I ze względu na ich niewiarę nie mógł uczynić żadnego wielkiego cudu, uzdrowił tylko kilku chorych, kładąc na nich ręce. ");
INSERT INTO polsz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","I dziwił się, że nie chcieli Mu uwierzyć. Odszedł więc stamtąd, aby odwiedzać okoliczne wioski i nauczać w nich. ");
INSERT INTO polsz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Następnie zebrał Dwunastu i rozesłał ich po dwóch, udzielając im mocy wypędzania demonów. ");
INSERT INTO polsz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nie pozwolił im jednak wziąć ze sobą niczego oprócz laski podróżnej: ani żywności, ani torby, ani pieniędzy, ");
INSERT INTO polsz_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ani nawet obuwia czy ubrania na zmianę. ");
INSERT INTO polsz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","—Gdy zatrzymacie się w jakimś miejscu—powiedział—nie przenoście się z domu do domu, lecz cały czas mieszkajcie w tym samym. ");
INSERT INTO polsz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","A jeśli was nie przyjmą i nie zechcą was słuchać, odchodząc strząśnijcie kurz ze swoich stóp. Będzie to oznaczało, że pozostawiacie tych ludzi ich własnemu losowi. ");
INSERT INTO polsz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Poszli więc i mówili wszystkim napotkanym, że powinni odwrócić się od grzechu. ");
INSERT INTO polsz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Uwalniali też ludzi od wielu złych duchów i uzdrawiali chorych, namaszczając ich olejkiem. ");
INSERT INTO polsz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ponieważ wszędzie było głośno o cudach, których dokonywał Jezus, wieść o Nim dotarła również do króla Heroda. Sądził on jednak, że Jezus to zmartwychwstały Jan Chrzciciel. Podobnie zresztą myślało wielu ludzi. Mówili: „Nic dziwnego, że potrafi czynić takie cuda”. ");
INSERT INTO polsz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Inni uważali Jezusa za Eliasza, dawnego proroka. Jeszcze inni twierdzili, że to jakiś nowy wielki prorok, podobny do tych, znanych z historii. ");
INSERT INTO polsz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","—To na pewno Jan, którego kazałem ściąć—mówił Herod. —Widocznie powstał z martwych. ");
INSERT INTO polsz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Jakiś czas wcześniej bowiem Herod wysłał żołnierzy, aby zatrzymali i aresztowali Jana Chrzciciela. Powodem tego była Herodiada, żona jego brata—Filipa, z którą Herod się ożenił. ");
INSERT INTO polsz_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jan bowiem ciągle wypominał Herodowi: „Nie wolno ci żyć z żoną swojego brata!”. ");
INSERT INTO polsz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodiada, przepełniona żądzą zemsty, chciała zabić Jana, lecz bez zgody Heroda nie mogła mu nic zrobić. ");
INSERT INTO polsz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Tymczasem on sam odnosił się do Jana z szacunkiem i chronił go. Wierzył bowiem, że to święty i dobry człowiek. Wprawdzie rozmowy z Janem wzniecały w nim niepokój, ale mimo to lubił go słuchać. ");
INSERT INTO polsz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wreszcie nadszedł długo oczekiwany przez Herodiadę moment. Z okazji swoich urodzin Herod wydał przyjęcie dla dworzan, oficerów i wybitnych obywateli Galilei. ");
INSERT INTO polsz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Przed gośćmi wystąpiła córka Herodiady i swym tańcem wzbudziła ogólny zachwyt. ");
INSERT INTO polsz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","—Proś mnie, o co tylko zechcesz, a dam ci to: nawet połowę królestwa—przysiągł król. ");
INSERT INTO polsz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dziewczyna poszła poradzić się matki, a ta jej szepnęła: —Proś o głowę Jana Chrzciciela. ");
INSERT INTO polsz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wtedy przybiegła do króla ze słowami: —Chcę mieć zaraz na tacy głowę Jana Chrzciciela! ");
INSERT INTO polsz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mimo że król nie chciał tego, to jednak nie miał odwagi złamać przysięgi danej w obecności gości. ");
INSERT INTO polsz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Posłał więc strażnika, aby ściął Janowi głowę i przyniósł ją. Żołnierz dokonał egzekucji Jana w więzieniu, ");
INSERT INTO polsz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","przyniósł jego głowę na tacy i podał dziewczynie, a ta zaniosła ją matce. ");
INSERT INTO polsz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Gdy się o tym dowiedzieli uczniowie Jana, przyszli po jego ciało i pochowali je. ");
INSERT INTO polsz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostołowie wrócili do Jezusa i opowiedzieli o tym, czego dokonali i co mówili ludziom, których odwiedzili. ");
INSERT INTO polsz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wówczas Jezus zaproponował: —Zostawmy na jakiś czas tłumy i odpocznijmy. Tak wielu bowiem otaczało ich ludzi, że nie mieli nawet czasu na posiłek. ");
INSERT INTO polsz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wyruszyli więc łodzią w poszukiwaniu jakiegoś ustronnego miejsca. ");
INSERT INTO polsz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Jednak niektórzy z obecnych zauważyli, że odpływają, i pobiegli wzdłuż brzegu, aby spotkać ich tam, gdzie dopłyną. ");
INSERT INTO polsz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wychodząc z łodzi, Jezus znów zastał więc tłumy ludzi. Gdy spojrzał na zebranych, ogarnęła Go litość, byli bowiem jak owce bez pasterza. Zaczął więc nauczać ich wielu ważnych prawd. ");
INSERT INTO polsz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Pod wieczór uczniowie zwrócili się do Niego: —Każ ludziom rozejść się do pobliskich wiosek i osad. Niech kupią sobie coś do jedzenia, bo na tym pustkowiu nie ma żywności, a robi się już późno. ");
INSERT INTO polsz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Wy dajcie im jeść—rzekł Jezus. —Ale co?! Trzeba by całej fortuny, aby kupić dość żywności dla takiej rzeszy!—wykrzyknęli. ");
INSERT INTO polsz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—Zobaczcie najpierw, co mamy do jedzenia—odpowiedział. —Mamy tylko pięć chlebów i dwie ryby!—donieśli Mu po chwili. ");
INSERT INTO polsz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wtedy Jezus polecił ludziom usiąść na zielonej trawie. ");
INSERT INTO polsz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Rozsiedli się więc w grupach po pięćdziesiąt i sto osób. ");
INSERT INTO polsz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","A On wziął pięć chlebów i dwie ryby. Popatrzył w niebo, podziękował za nie Bogu, po czym dawał uczniom, a oni rozdawali ludziom. ");
INSERT INTO polsz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","W ten sposób wszyscy najedli się do syta! ");
INSERT INTO polsz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","I zebrano jeszcze dwanaście koszy resztek chleba i ryb, ");
INSERT INTO polsz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","choć w posiłku tym brało udział około pięciu tysięcy samych tylko mężczyzn—nie licząc kobiet i dzieci. ");
INSERT INTO polsz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Zaraz potem Jezus nakazał uczniom, aby przeprawili się łodzią na drugą stronę jeziora—do Betsaidy, dokąd On sam miał przybyć później. Chciał bowiem pozostać na miejscu do czasu, aż ludzie rozejdą się do domów. ");
INSERT INTO polsz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Gdy wszyscy już odeszli, wszedł na wzgórze, aby się modlić. ");
INSERT INTO polsz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Zapadł zmrok i Jezus był zupełnie sam. Tymczasem uczniowie wiosłowali, płynąc łodzią przez środek jeziora. ");
INSERT INTO polsz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","49","Jezus zobaczył, że znaleźli się w trudnej sytuacji, walcząc z silnym wiatrem i falami. Około trzeciej nad ranem poszedł więc do nich po wodzie. Gdy uczniowie zobaczyli mijającego ich Jezusa, krzyknęli z przerażenia: —To duch! ");
INSERT INTO polsz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","—Spokojnie! Nie bójcie się, to Ja!—szybko odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Gdy wszedł do łodzi, wiatr nagle ucichł. Uczniowie byli zdumieni. ");
INSERT INTO polsz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mimo że poprzedniego wieczoru byli świadkami cudu, nie mogli w to uwierzyć. Wciąż jeszcze nie byli w stanie pojąć, kim On jest. ");
INSERT INTO polsz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Niebawem przypłynęli do krainy Genezaret ");
INSERT INTO polsz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","i wyszli na brzeg. Stojący tam ludzie natychmiast rozpoznali Jezusa ");
INSERT INTO polsz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","i po całej okolicy rozeszła się wiadomość o Jego przybyciu. Wtedy ze wszystkich stron zaczęto przynosić do Niego chorych. ");
INSERT INTO polsz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gdziekolwiek się pojawił—w wioskach i miastach, a nawet w odległych osadach—wszędzie wynoszono chorych na place i ulice. Proszono Go, aby pozwolił im przynajmniej dotknąć swojego płaszcza. A wszyscy, którzy Go dotykali, odzyskiwali zdrowie. ");
INSERT INTO polsz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pewnego dnia, celem sprawdzenia nauki głoszonej przez Jezusa, przybyli z Jerozolimy przywódcy religijni i faryzeusze. ");
INSERT INTO polsz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Od razu zauważyli, że niektórzy z Jego uczniów nie przestrzegają żydowskich zwyczajów obowiązujących przy jedzeniu. ");
INSERT INTO polsz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Zgodnie bowiem z tradycją, Żydzi—a szczególnie faryzeusze—przed rozpoczęciem jedzenia polewają wodą dłonie. ");
INSERT INTO polsz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Po każdym powrocie do domu, zanim dotkną jedzenia, muszą się umyć—a to tylko jeden przykład tych przepisów. Przewidują one nawet ceremonie oczyszczenia garnków, kubków i talerzy. ");
INSERT INTO polsz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Przybysze zapytali Go więc: —Dlaczego Twoi uczniowie nie przestrzegają naszych odwiecznych zwyczajów? Dlaczego siadają do stołu, nie dokonawszy obrzędu obmywania rąk? ");
INSERT INTO polsz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Odpowiedź Jezusa była ostra i natychmiastowa: —Obłudnicy! Dobrze was określił prorok Izajasz, mówiąc: „Ludzie ci bardzo pięknie o Mnie mówią, ale w ich sercach nie ma miłości do Mnie. ");
INSERT INTO polsz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Na próżno jednak oddają Mi cześć. Nauczają bowiem przykazań, które sami wymyślili.” Nie mylił się Izajasz! ");
INSERT INTO polsz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Omijacie prawdziwe Boże przykazania, zastępując je waszą własną tradycją. ");
INSERT INTO polsz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","W imię tradycji odrzucacie i po prostu depczecie Boże prawa! ");
INSERT INTO polsz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mojżesz przekazał wam od Boga prawo: „Szanuj rodziców!”. Powiedział również: „Kto znieważa ojca lub matkę, musi umrzeć”. ");
INSERT INTO polsz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Natomiast wy uważacie za normalne, gdy ktoś zaniedbuje swoich rodziców będących w potrzebie, tłumacząc się: „Niestety, nie mogę wam pomóc, bo przecież to, co miałem dla was, oddałem w darze Bogu do Jego świątyni”. ");
INSERT INTO polsz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","I nie pozwalacie mu już nic uczynić dla ojca i matki. ");
INSERT INTO polsz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chcąc przestrzegać własnej tradycji, łamiecie Boże prawo. A jest to tylko jeden z wielu przykładów. ");
INSERT INTO polsz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Następnie zawołał zgromadzonych i rzekł: —Słuchajcie wszyscy i postarajcie się to zrozumieć. ");
INSERT INTO polsz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nie to, co w was wchodzi, może wam przynieść szkodę, lecz to, co z was wychodzi. ");
INSERT INTO polsz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kto ma uszy do słuchania, niech słucha uważnie! ");
INSERT INTO polsz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Gdy opuścił zgromadzonych i wszedł do domu, uczniowie zapytali Go o znaczenie słów, jakie właśnie wypowiedział. ");
INSERT INTO polsz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","—Wy też tego nie rozumiecie?—zapytał. —Czy nie pojmujecie, że to nie jedzenie was zanieczyszcza? ");
INSERT INTO polsz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Przecież pokarm nie wchodzi do ludzkiego serca! Trafia tylko do żołądka, po czym zostaje wydalony. W ten sposób dał im do zrozumienia, że każdy rodzaj pożywienia uznaje za czysty. ");
INSERT INTO polsz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mówił też dalej: —Człowieka zanieczyszcza to, co z niego wychodzi. ");
INSERT INTO polsz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","To w jego wnętrzu, w sercu, rodzą się bowiem złe myśli prowadzące do rozwiązłości, kradzieży, morderstw, niewierności małżeńskiej, ");
INSERT INTO polsz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","a także zachłanności, podłości, podstępów, rozpusty i zawiści. ");
INSERT INTO polsz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Te wszystkie brudy pochodzą z ludzkiego serca i to one czynią człowieka nieczystym. ");
INSERT INTO polsz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Potem Jezus opuścił Galileę, udając się w okolice Tyru i Sydonu. Chociaż chciał utrzymać swoją obecność w tajemnicy, bardzo szybko—jak zwykle—rozeszła się wieść o Jego przybyciu. ");
INSERT INTO polsz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","I przyszła do Niego kobieta, której córka była opanowana przez złego ducha. A ponieważ słyszała o cudach Jezusa, padła Mu do nóg ");
INSERT INTO polsz_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","i błagała, aby uwolnił jej dziecko od demona. Była to Syrofenicjanka, a więc należała do pogan, których Żydzi mają w pogardzie. ");
INSERT INTO polsz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jezus powiedział do niej: —Przede wszystkim pozwól Mi najpierw zadbać o własnych domowników—Żydów. Byłoby przecież niedobrze odbierać chleb dzieciom i rzucić go szczeniętom. ");
INSERT INTO polsz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—To prawda, Panie!—odpowiedziała. —Jednak nawet psy dostają resztki ze stołu, przy którym jedzą dzieci. ");
INSERT INTO polsz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—Masz rację! Możesz wrócić do domu. Twoja córka jest zdrowa. Zły duch już z niej wyszedł—powiedział wtedy Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A gdy kobieta wróciła do domu, dziewczynka leżała spokojnie w łóżku, a po demonie nie było najmniejszego śladu. ");
INSERT INTO polsz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Z Tyru Jezus udał się do Sydonu, po czym przemierzając krainę Dekapolu wrócił znowu nad Jezioro Galilejskie. ");
INSERT INTO polsz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tam ludzie przyprowadzili do Niego człowieka, który był głuchoniemy. Wszyscy prosili, żeby położył na niego ręce i uzdrowił go. ");
INSERT INTO polsz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Odszedł więc z nim na bok, włożył palce w jego uszy i śliną zwilżył mu język. ");
INSERT INTO polsz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Potem spojrzał w niebo, westchnął i rzekł do niego: —Effatha! (to znaczy: „Otwórz się!”). ");
INSERT INTO polsz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","I otworzyły się uszy tego człowieka i odzyskał słuch i normalną mowę. ");
INSERT INTO polsz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jezus nie chciał, aby ktokolwiek z tłumu o tym rozpowiadał, lecz im surowiej zakazywał, tym bardziej to rozgłaszano. ");
INSERT INTO polsz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wszyscy byli bowiem bardzo przejęci tym, co widzieli. Nieustannie powtarzali: —To, co On czyni, jest cudowne! Leczy nawet głuchoniemych! ");
INSERT INTO polsz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Innym razem, gdy zebrał się spory tłum i znowu zabrakło jedzenia, Jezus zawołał uczniów i rzekł: ");
INSERT INTO polsz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Żal mi tych ludzi! Są tu od trzech dni i nie mają już nic do jedzenia. ");
INSERT INTO polsz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Jeśli odejdą stąd głodni, mogą zasłabnąć w drodze do domu. Niektórzy przecież przyszli tu z daleka. ");
INSERT INTO polsz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—Skąd tu, na pustyni, weźmiemy tyle jedzenia?—spytali uczniowie. ");
INSERT INTO polsz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—A ile macie chleba?—zapytał Jezus. —Siedem bochenków—odparli. ");
INSERT INTO polsz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Wtedy Jezus polecił ludziom, aby usiedli na ziemi. Sam zaś wziął te siedem chlebów i podziękował za nie Bogu. Następnie łamał je na kawałki i podawał uczniom, a oni kładli je przed ludźmi. ");
INSERT INTO polsz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Znalazło się też kilka małych rybek. Jezus pobłogosławił je i również kazał rozdać zgromadzonym. ");
INSERT INTO polsz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","I tak wszyscy najedli się do syta, a zebranymi resztkami napełniono aż siedem koszy. ");
INSERT INTO polsz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A było tam około czterech tysięcy osób. ");
INSERT INTO polsz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Potem Jezus wsiadł z uczniami do łodzi i popłynął w okolice Dalmanuty. ");
INSERT INTO polsz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Gdy miejscowi faryzeusze usłyszeli o Jego przybyciu, postanowili Go poddać próbie. —Uczyń cud!—prosili. —Jeżeli ukaże się jakiś znak na niebie, wówczas Ci uwierzymy. ");
INSERT INTO polsz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jezus westchnął i zapytał: —Dlaczego żądacie znaku? Mówię wam, że żaden znak nie będzie dany temu pokoleniu. ");
INSERT INTO polsz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Zostawił ich samych, wsiadł do łodzi i odpłynął na drugi brzeg jeziora. ");
INSERT INTO polsz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A uczniowie mieli ze sobą tylko jeden bochenek chleba, bo zapomnieli dokupić żywności. ");
INSERT INTO polsz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Gdy płynęli, Jezus przestrzegł ich: —Bądźcie ostrożni i wystrzegajcie się kwasu króla Heroda i faryzeuszy. ");
INSERT INTO polsz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","—Co On chce przez to powiedzieć?—zastanawiali się uczniowie. W końcu doszli do wniosku, że pewnie chodzi o to, że nie kupili chleba. ");
INSERT INTO polsz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Widząc ich zakłopotanie, Jezus wyjaśnił: —Nie chodzi mi o chleb! Czy wy wciąż nie rozumiecie? Czy aż tak twarde są wasze serca? ");
INSERT INTO polsz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","„Macie oczy, żeby widzieć”—mówił Izajasz. „Czemu więc nie patrzycie? Czemu nie nadstawiacie uszu, aby usłyszeć?” Czy już zdążyliście wszystko zapomnieć? ");
INSERT INTO polsz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Czy nie pamiętacie tych pięciu tysięcy ludzi, których nakarmiłem pięcioma bochenkami chleba? Ile wtedy zebraliście resztek? —Dwanaście koszy—odpowiedzieli. ");
INSERT INTO polsz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—A gdy siedmioma bochenkami nakarmiłem cztery tysiące ludzi, to ile jeszcze pozostało? —Siedem koszy resztek—odrzekli uczniowie. ");
INSERT INTO polsz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—Czy więc nadal sądzicie, że mógłbym się martwić z powodu braku chleba? ");
INSERT INTO polsz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Gdy przybyli do Betsaidy, ludzie przyprowadzili do Niego niewidomego i prosili, żeby go dotknął i uzdrowił. ");
INSERT INTO polsz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jezus wziął go za rękę i wyprowadził za wioskę. Zwilżył śliną jego oczy i dotknął ich. —Czy teraz coś widzisz? ");
INSERT INTO polsz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Niewidomy popatrzył wokoło. —Widzę ludzi—powiedział—ale niewyraźnie. Wyglądają jak chodzące drzewa. ");
INSERT INTO polsz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Wtedy Jezus ponownie dotknął dłońmi jego oczu, a gdy ślepy wytężył wzrok, doznał zupełnego uzdrowienia. Mógł teraz widzieć całkiem wyraźnie i cieszył się tym, co widział dokoła. ");
INSERT INTO polsz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jezus odesłał go więc do domu, do rodziny. —Po drodze nawet nie wstępuj do wioski—przykazał mu. ");
INSERT INTO polsz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Opuściwszy Galileę, Jezus wraz z uczniami udał się do wiosek wokół Cezarei Filipowej. W drodze zadał im pytanie: —Za kogo uważają Mnie ludzie? ");
INSERT INTO polsz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","—Jedni sądzą, że jesteś Janem Chrzcicielem—odrzekli uczniowie—inni, że Eliaszem lub jakimś innym dawnym prorokiem, który powstał z martwych. ");
INSERT INTO polsz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—A wy? Za kogo Mnie uważacie?—zapytał ich wprost. —Jesteś Mesjaszem—powiedział Piotr. ");
INSERT INTO polsz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—Nikomu o tym nie mówcie—przykazał im Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wtedy właśnie zaczął im mówić o strasznych cierpieniach, jakie Go czekają, i o tym, że zostanie odrzucony przez starszych, najwyższych kapłanów i innych przywódców religijnych, że będzie zabity, ale że po trzech dniach zmartwychwstanie. ");
INSERT INTO polsz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mówił im o tym zupełnie otwarcie, więc Piotr wziął Go na bok i prosił, żeby Jezus nawet nie wspominał o takich rzeczach. ");
INSERT INTO polsz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wówczas Jezus odwrócił się, spojrzał na uczniów i surowo zganił Piotra: —Precz, szatanie! Patrzysz na to jedynie z ludzkiego punktu widzenia i nie jesteś w stanie zrozumieć Bożych planów. ");
INSERT INTO polsz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Potem zawołał uczniów oraz cały tłum, by podeszli bliżej i słuchali. —Jeśli ktoś z was chce Mnie naśladować, niech przestanie myśleć wyłącznie o sobie. Niech weźmie swój krzyż i idzie ze Mną. ");
INSERT INTO polsz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jeśli ktoś chce wygrać życie, przegra je. Ale kto przegra życie ze względu na Mnie i dobrą nowinę, naprawdę je wygra. ");
INSERT INTO polsz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Co z tego, że ktoś zdobędzie cały świat, jeśli po drodze zatraci życie? ");
INSERT INTO polsz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Czy dla człowieka istnieje coś cenniejszego niż on sam? ");
INSERT INTO polsz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kto wstydzi się Mnie i mojej nauki przed tymi niewiernymi i grzesznymi ludźmi, tego i Ja, Syn Człowieczy, będę się wstydzić, gdy powrócę tu ze świętymi aniołami, otoczony chwałą mojego Ojca. ");
INSERT INTO polsz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","—Zapewniam was: Niektórzy z obecnych tu—mówił dalej do uczniów—jeszcze za swojego życia ujrzą potęgę nadchodzącego królestwa Bożego! ");
INSERT INTO polsz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sześć dni później Jezus wziął ze sobą na szczyt pewnej góry Piotra, Jakuba i Jana. Poza nimi nie było tam nikogo. Nagle, na ich oczach, przemienił się: ");
INSERT INTO polsz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jego płaszcz zalśnił taką nieziemską bielą, jakiej nie zdołałby osiągnąć żaden farbiarz. ");
INSERT INTO polsz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Potem zjawili się Eliasz i Mojżesz, którzy zaczęli z Nim rozmawiać. ");
INSERT INTO polsz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","—Nauczycielu, jak dobrze, że tu jesteśmy!—wykrzyknął Piotr do Jezusa. —Jeśli chcesz, zbuduję trzy szałasy: dla Ciebie, dla Mojżesza i dla Eliasza. ");
INSERT INTO polsz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Powiedział tak, gdyż—podobnie jak pozostali—był sparaliżowany strachem i nie wiedział, co mówić. ");
INSERT INTO polsz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ale zanim skończył, otoczył ich jasny obłok, z którego rozległ się głos: —Oto mój ukochany Syn. Słuchajcie Go! ");
INSERT INTO polsz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Po chwili, gdy się rozejrzeli, stwierdzili, że poza Jezusem nie ma już nikogo. ");
INSERT INTO polsz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Schodząc z góry, Jezus nakazał im, aby do czasu Jego zmartwychwstania nikomu nie opowiadali o tym, co widzieli. ");
INSERT INTO polsz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Zatrzymali to więc dla siebie, ale często rozmawiali o tym we własnym gronie i zastanawiali się, co Jezus miał na myśli, mówiąc o zmartwychwstaniu. ");
INSERT INTO polsz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Zapytali Go też, dlaczego przywódcy religijni twierdzą, że przed przyjściem Mesjasza musi pojawić się Eliasz. ");
INSERT INTO polsz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","—Mają rację—odparł Jezus. —Eliasz musi przyjść i wszystko przygotować. A co prorocy napisali o Mnie, Synu Człowieczym? Mam cierpieć i być odrzucony! ");
INSERT INTO polsz_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mówię wam: Eliasz już przyszedł, ale—zgodnie z tym, co przepowiedzieli prorocy—został haniebnie potraktowany! ");
INSERT INTO polsz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","U podnóża góry zastali ogromny tłum, otaczający pozostałych dziewięciu uczniów, żywo dyskutujących z przywódcami religijnymi. ");
INSERT INTO polsz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ludzie, uradowani widokiem Jezusa, przybiegli Go powitać. ");
INSERT INTO polsz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","—O co chodzi?—zapytał. ");
INSERT INTO polsz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","—Nauczycielu!—odezwał się ktoś z tłumu. —Przyprowadziłem tu mojego syna, żebyś go uzdrowił. Opanował go zły duch i nie może mówić. ");
INSERT INTO polsz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gdy go napada, chłopiec rzuca się na ziemię z pianą na ustach, zgrzyta zębami i sztywnieje. Prosiłem Twoich uczniów, żeby wypędzili demona, lecz oni nie potrafili. ");
INSERT INTO polsz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","—Dlaczego wciąż brakuje wam wiary?—zwrócił się do nich Jezus. —Jak długo jeszcze muszę być z wami, żebyście wreszcie uwierzyli? Jak długo mam was znosić? Przyprowadźcie tu chłopca! ");
INSERT INTO polsz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ujrzawszy Jezusa, demon rzucił chłopca na ziemię tak gwałtownie, że ten wił się w konwulsjach, z pianą na ustach. ");
INSERT INTO polsz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","—Jak długo na to cierpi?—zapytał Jezus ojca. —Od dzieciństwa. ");
INSERT INTO polsz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Zły duch często usiłuje go zabić, rzucając go w ogień lub wodę. Zmiłuj się nad nami i jeśli możesz, zrób coś! ");
INSERT INTO polsz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—„Jeśli możesz”?—powtórzył Jezus. —Dla tego, kto wierzy, wszystko jest możliwe! ");
INSERT INTO polsz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","—Wierzę!—gorąco zapewnił ojciec. —Ale, proszę, pomóż mi wierzyć jeszcze mocniej! ");
INSERT INTO polsz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","A ponieważ tłum gęstniał coraz bardziej, Jezus zwrócił się do demona: —Duchu niemy i głuchy! Rozkazuję ci: Opuść to dziecko raz na zawsze! ");
INSERT INTO polsz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Demon przeraźliwie krzyknął, targnął chłopcem i wyszedł z niego, pozostawiając go leżącego nieruchomo i bezwładnie, jak gdyby był martwy. Przez tłum przebiegł szmer: —Nie żyje… ");
INSERT INTO polsz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lecz Jezus wziął go za rękę i podniósł. Chłopiec był całkowicie uzdrowiony! ");
INSERT INTO polsz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Później, gdy Jezus znalazł się w domu sam na sam z uczniami, zapytali Go: —Dlaczego my nie mogliśmy wypędzić tego demona? ");
INSERT INTO polsz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Takiego rodzaju złych duchów nie uda się wypędzić bez modlitwy—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Gdy opuścili to miejsce, przemierzali dalej Galileę, lecz Jezus unikał tłumów. Chciał bowiem poświęcić czas przygotowaniu uczniów na to, co miało nastąpić. ");
INSERT INTO polsz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mówił im: —Ja, Syn Człowieczy, zostanę wkrótce wydany w ręce ludzi, którzy Mnie zabiją, ale trzeciego dnia zmartwychwstanę. ");
INSERT INTO polsz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Uczniowie nie rozumieli tego, lecz bali się prosić Go o wyjaśnienie. ");
INSERT INTO polsz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tak doszli do Kafarnaum. Gdy rozgościli się w domu, gdzie ich przyjęto, Jezus zapytał: —O czym to dyskutowaliście w drodze? ");
INSERT INTO polsz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lecz oni wstydzili się odpowiedzieć, ponieważ spierali się o to, który z nich jest najważniejszy. ");
INSERT INTO polsz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Wtedy Jezus usiadł, zebrał Dwunastu wokół siebie i rzekł: —Kto chce być największy, musi stać się sługą wszystkich! ");
INSERT INTO polsz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Postawił wśród nich dziecko i obejmując je ramieniem powiedział: ");
INSERT INTO polsz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Każdy, kto ze względu na Mnie przyjmie nawet takie małe dziecko, Mnie przyjmie; a kto Mnie przyjmie—przyjmie samego Ojca, który Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Niedługo potem Jan—jeden z uczniów—zwrócił się do Jezusa: —Nauczycielu, spotkaliśmy człowieka, który w Twoim imieniu wypędza demony, i zabroniliśmy mu działać. Nie należy bowiem do naszego grona. ");
INSERT INTO polsz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","—Nie zabraniajcie mu—odparł Jezus. —Kto w moim imieniu czyni cuda, nieprędko wystąpi przeciwko Mnie. ");
INSERT INTO polsz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Każdy, kto nie jest nam przeciwny, jest naszym sprzymierzeńcem. ");
INSERT INTO polsz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Zapewniam was, że jeśli ktoś poda wam choćby kubek wody—dlatego, że należycie do Mnie—nie ominie go nagroda! ");
INSERT INTO polsz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Lecz jeśli z czyjegoś powodu upadnie choćby jeden z najmniejszych moich uczniów, to lepiej byłoby, aby takiemu człowiekowi przywiązano do szyi kamień młyński i wrzucono go do morza. ");
INSERT INTO polsz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Jeśli więc twoja własna ręka skłania cię do grzechu—odetnij ją; lepiej bowiem wejść do nieba z jedną ręką, niż mając dwie znaleźć się w ogniu piekielnym, który nigdy nie gaśnie. ");
INSERT INTO polsz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Podobnie, jeśli twoja noga skłania cię do grzechu—odetnij ją; lepiej jest dla ciebie kalekim wejść do nieba, niż z obiema nogami zostać wrzuconym do piekła. ");
INSERT INTO polsz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jeśli twoje oko skłania cię do grzechu—wyłup je; lepiej bowiem wejść do królestwa Bożego z jednym okiem, niż z dwojgiem oczu być wrzuconym do piekła, ");
INSERT INTO polsz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","gdzie udręka się nie kończy i ogień nigdy nie gaśnie. ");
INSERT INTO polsz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tam wszyscy zostaną „posoleni” ogniem cierpień. ");
INSERT INTO polsz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sól jest dobra; lecz jeśli utraci swój smak, staje się bezwartościowa. Nie utraćcie więc i wy swoich właściwości, ale zachowajcie pokój między sobą. ");
INSERT INTO polsz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Wychodząc z Kafarnaum Jezus skierował się na południe, do Judei i w okolice leżące po drugiej stronie Jordanu. A gdy nauczał, jak zwykle otoczony przez tłumy, ");
INSERT INTO polsz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","podeszli faryzeusze i—chcąc Go sprowokować do jakiejś niefortunnej wypowiedzi—zapytali Go: —Czy zezwalasz na rozwody? ");
INSERT INTO polsz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—A co na ten temat powiedział Mojżesz?—spytał ich Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—Pozwolił wręczyć żonie dokument rozwodowy i odprawić ją—odrzekli. ");
INSERT INTO polsz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","—Mojżesz zezwolił na to tylko z powodu waszych zatwardziałych serc—odparł Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","—Ale nie taki był Boży zamiar. Już na samym początku Bóg stworzył bowiem mężczyznę i kobietę. ");
INSERT INTO polsz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Dlatego właśnie mężczyzna powinien opuścić rodziców ");
INSERT INTO polsz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","i złączyć się z żoną, aby ci dwoje stali się jednym ciałem. ");
INSERT INTO polsz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Żaden człowiek nie ma prawa rozdzielać tego, co połączył Bóg. ");
INSERT INTO polsz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Gdy później znalazł się z uczniami w domu, ci powrócili do tego tematu. ");
INSERT INTO polsz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wtedy im powiedział: —Jeśli mężczyzna rozwodzi się z żoną i poślubia inną kobietę, dopuszcza się grzechu niewierności małżeńskiej. ");
INSERT INTO polsz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Podobnie żona, jeśli porzuca męża, aby powtórnie wyjść za mąż, dopuszcza się grzechu niewierności. ");
INSERT INTO polsz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Zdarzyło się też, że przyprowadzono do Jezusa dzieci, prosząc, aby je pobłogosławił. Uczniowie jednak odsuwali je, nie chcąc, aby Mu przeszkadzały. ");
INSERT INTO polsz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Widząc to, Jezus oburzył się na nich i rzekł: —Nie zabraniajcie dzieciom przychodzić do Mnie, gdyż do takich jak one należy królestwo Boże. ");
INSERT INTO polsz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Zapewniam was: Jeśli ktoś nie przyjdzie do Boga tak, jak dziecko przychodzi do ojca, nie będzie miał wstępu do Jego królestwa. ");
INSERT INTO polsz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","I przytulał dzieci, i kładł na nie ręce, błogosławiąc je. ");
INSERT INTO polsz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","W trakcie przygotowań do dalszej drogi przybiegł do Jezusa jakiś młody człowiek. Ukląkł przed Nim i zapytał: —Dobry nauczycielu, co mam czynić, aby osiągnąć życie wieczne? ");
INSERT INTO polsz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","—Dlaczego nazywasz Mnie „dobrym”?—zapytał Jezus. —Naprawdę dobry jest tylko Bóg. ");
INSERT INTO polsz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jeśli zaś chodzi o twoje pytanie, to znasz chyba przykazania: „Nie zabijaj, bądź wierny w małżeństwie, nie kradnij, nie składaj fałszywych zeznań, szanuj rodziców!”? ");
INSERT INTO polsz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Nauczycielu! Nigdy nie przekroczyłem żadnego z nich—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jezus spojrzał na niego z głęboką miłością i rzekł: —Zatem jedno pozostało ci do zrobienia: Idź i sprzedaj swój majątek, a pieniądze rozdaj biednym. To zapewni ci skarb w niebie. Potem wróć i chodź ze Mną. ");
INSERT INTO polsz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Na te słowa młody człowiek spochmurniał i odszedł zasmucony; był bowiem bardzo bogaty. ");
INSERT INTO polsz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jezus odprowadził go wzrokiem i powiedział do uczniów: —Oto jak trudno jest bogatym wejść do królestwa Bożego. ");
INSERT INTO polsz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A ponieważ zdumiało to uczniów, dodał: —Nie sposób wejść do Bożego królestwa, jeśli pokłada się nadzieję w bogactwie. ");
INSERT INTO polsz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Łatwiej wielbłądowi przejść przez ucho od igły, niż bogatemu człowiekowi wejść do królestwa Bożego. ");
INSERT INTO polsz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Słowa te poważnie zastanowiły uczniów: —Kto więc może być zbawiony?—pytali. ");
INSERT INTO polsz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jezus spojrzał na nich i rzekł: —To przekracza ludzkie możliwości, ale dla Boga wszystko jest możliwe. ");
INSERT INTO polsz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","—My zostawiliśmy wszystko i poszliśmy za Tobą—odezwał się Piotr. ");
INSERT INTO polsz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","—Zapewniam was—odpowiedział Jezus—że każdy, kto z miłości do Mnie i w celu głoszenia dobrej nowiny opuścił dom, braci, siostry, matkę, ojca, dzieci albo posiadłości, ");
INSERT INTO polsz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","otrzyma w zamian sto razy więcej domów, braci, sióstr, matek, dzieci oraz posiadłości, ale spotkają go też prześladowania! Oprócz tego, co otrzyma tu, na ziemi, czeka go życie wieczne w przyszłym świecie. ");
INSERT INTO polsz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wtedy wielu ludzi, obecnie uznawanych za wielkich, przestanie się liczyć, a inni, teraz uznawani za najmniejszych, będą wielkimi. ");
INSERT INTO polsz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Podążali teraz w kierunku Jerozolimy. Jezus szedł przodem, a za Nim uczniowie, pełni lęku i trwogi. Wtedy wziął Dwunastu na bok i jeszcze raz powiedział im o wszystkim, co Go czeka: ");
INSERT INTO polsz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Gdy znajdziemy się w Jerozolimie—mówił—Ja, Syn Człowieczy, zostanę schwytany i postawiony przed najwyższymi kapłanami i przywódcami religijnymi, którzy skażą Mnie na śmierć i wydadzą w ręce Rzymian, aby Mnie zabili. ");
INSERT INTO polsz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Będą śmiać się ze Mnie i pluć na Mnie; ubiczują Mnie i w końcu zabiją. Lecz po trzech dniach powrócę do życia. ");
INSERT INTO polsz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Potem podeszli do Niego Jakub i Jan, synowie Zebedeusza, i rzekli: —Nauczycielu! Mamy do Ciebie prośbę. ");
INSERT INTO polsz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—Jaką?—zapytał. ");
INSERT INTO polsz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Chcielibyśmy zasiadać w Twoim królestwie tuż obok Ciebie—po prawej i lewej stronie. ");
INSERT INTO polsz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—Nie wiecie, o co prosicie!—odrzekł im Jezus. —Czy jesteście gotowi wypić mój „kielich cierpienia”? Albo przejść chrzest, jaki jest dla Mnie przeznaczony? ");
INSERT INTO polsz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Tak—opowiedzieli bracia. —Rzeczywiście, wypijecie ten „kielich” i przejdziecie ten chrzest—kontynuował Jezus— ");
INSERT INTO polsz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ale nie mam prawa posadzić was na tronie obok siebie. Te miejsca są już rozdzielone. ");
INSERT INTO polsz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Gdy pozostałych dziesięciu uczniów dowiedziało się o tej prośbie, oburzyli się na Jakuba i Jana. ");
INSERT INTO polsz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Wtedy Jezus zawołał wszystkich do siebie i powiedział: —Jak wiecie, wielcy tego świata nadużywają swojej władzy nad ludźmi. ");
INSERT INTO polsz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lecz wśród was powinno być inaczej. Jeśli ktoś z was chce być wielki, powinien stać się sługą. ");
INSERT INTO polsz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","A kto chce być największy ze wszystkich, musi stać się niewolnikiem wszystkich. ");
INSERT INTO polsz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Przecież nawet Ja, Syn Człowieczy, nie przyszedłem po to, żeby Mi służono, lecz aby służyć innym i złożyć własne życie jako okup za wielu ludzi. ");
INSERT INTO polsz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Rozmawiając, dotarli do Jerycha. Gdy wychodzili z miasta, ciągnął już za nimi wielki tłum. A pewien niewidomy żebrak, Bartymeusz (to znaczy: syn Tymeusza) siedział tam przy drodze. ");
INSERT INTO polsz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Usłyszał, że Jezus z Nazaretu znajduje się w pobliżu, i zaczął wołać: —Jezusie, potomku króla Dawida, zmiłuj się nade mną! ");
INSERT INTO polsz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","—Cicho bądź!—krzyczeli na niego ludzie. On jednak tym głośniej wołał: —Potomku Dawida, zmiłuj się nade mną! ");
INSERT INTO polsz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jezus zatrzymał się i rzekł: —Zawołajcie go tutaj! Poszli więc po niego i powiedzieli: —Masz szczęście, człowieku! Chodź, On cię woła! ");
INSERT INTO polsz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartymeusz zrzucił płaszcz, zerwał się na nogi i ruszył do Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","—Co mogę dla ciebie zrobić?—zapytał Jezus. —Nauczycielu!—prosił niewidomy. —Chciałbym widzieć! ");
INSERT INTO polsz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Dobrze, niech się tak stanie!—powiedział Jezus. —Twoja wiara cię uzdrowiła. I natychmiast niewidomy odzyskał wzrok i poszedł z Nim. ");
INSERT INTO polsz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Gdy zbliżali się do Betfage i Betanii w pobliżu Jerozolimy i znaleźli się pod Górą Oliwną, Jezus wysłał przed sobą dwóch uczniów: ");
INSERT INTO polsz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Idźcie do najbliższej wsi—powiedział. —Zaraz przy wejściu do niej znajdziecie uwiązanego osiołka, na którym jeszcze nikt nie jechał. Odwiążcie go i przyprowadźcie tutaj. ");
INSERT INTO polsz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A gdyby ktoś was pytał, po co go bierzecie, powiedzcie po prostu: „Pan go potrzebuje i zaraz odprowadzi”. ");
INSERT INTO polsz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Poszli więc i znaleźli osiołka uwiązanego przed domem. Gdy go odwiązali, ");
INSERT INTO polsz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","stojący tam ludzie zapytali: —Czemu go zabieracie? ");
INSERT INTO polsz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Odpowiedzieli, że Jezus im tak rozkazał, a wtedy ludzie ci już im nie przeszkadzali. ");
INSERT INTO polsz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Gdy przyprowadzili osiołka, zarzucili płaszcze na jego grzbiet, tak by Jezus mógł na nim siedzieć. ");
INSERT INTO polsz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wielu zaś ludzi rozkładało na drodze swoje płaszcze i rzucało zielone gałązki. ");
INSERT INTO polsz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","A cały tłum przed Nim i wokół Niego wołał: —Niech żyje Król! Błogosławiony Ten, który przychodzi w imieniu Pana! ");
INSERT INTO polsz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Błogosławione królestwo, które On ustanowi, królestwo naszego przodka Dawida! Chwała Królowi! ");
INSERT INTO polsz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","W ten sposób Jezus wjechał do Jerozolimy. Wszedł do świątyni, rozejrzał się dokładnie i wyszedł, ponieważ zbliżał się wieczór, a On wraz z Dwunastoma miał jeszcze udać się do Betanii. ");
INSERT INTO polsz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Następnego dnia rano, wychodząc z Betanii, Jezus poczuł głód. ");
INSERT INTO polsz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","W pobliżu zauważył zazielenione drzewo figowe. Podszedł więc, by zobaczyć, czy nie znajdzie na nim fig. Na drzewie były jednak tylko liście, bo nie była to pora owocowania. ");
INSERT INTO polsz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Wtedy Jezus powiedział do drzewa: —Już nigdy więcej nie przyniesiesz owocu! Uczniowie zapamiętali te słowa. ");
INSERT INTO polsz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Gdy powrócili do Jerozolimy, Jezus wszedł do świątyni i zaczął wypędzać z niej wszystkich sprzedawców oraz kupujących. Powywracał stoły wymieniających pieniądze oraz stragany sprzedawców gołębi, ");
INSERT INTO polsz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","a tym, którzy wnosili różne towary, zabronił wchodzić. ");
INSERT INTO polsz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Powiedział do nich: —Pismo mówi: „Moja świątynia ma być domem modlitwy dla wszystkich narodów, a wy zrobiliście z niej kryjówkę złodziei”. ");
INSERT INTO polsz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Gdy najwyżsi kapłani i inni przywódcy religijni dowiedzieli się o tym, poczuli się zagrożeni. Usiłowali więc znaleźć sposób, aby się pozbyć Jezusa. Byli jednak bardzo ostrożni, ponieważ bali się rozruchów. Tłumy bowiem były zachwycone Jego nauką. ");
INSERT INTO polsz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tak jak poprzednio, również i tego wieczoru Jezus wraz z uczniami opuścił miasto. ");
INSERT INTO polsz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Następnego dnia rano, gdy przechodzili obok tego samego drzewa figowego, spostrzegli, że uschło aż od korzeni. ");
INSERT INTO polsz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Wtedy Piotr, przypomniał sobie, co poprzedniego dnia Jezus powiedział do drzewa, i krzyknął: —Nauczycielu, patrz! Drzewo, które przekląłeś, uschło! ");
INSERT INTO polsz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","—Jeśli będziecie mieć wiarę w Boga—odpowiedział Jezus ");
INSERT INTO polsz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","—rozkażecie tej oto górze: „Unieś się i rzuć w morze!”—a uczyni to. Wasza wiara musi być jednak prawdziwa, pozbawiona zwątpień. ");
INSERT INTO polsz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Pamiętajcie: Jeśli prosicie o coś w modlitwie, wierzcie, że już to otrzymaliście, a wasza prośba zostanie spełniona. ");
INSERT INTO polsz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Lecz zanim będziecie się modlić, przebaczcie najpierw winy innym ludziom, aby wasz Ojciec w niebie i wam przebaczył grzechy. ");
INSERT INTO polsz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Bo jeśli wy nie darujecie innym, również Ojciec w niebie nie przebaczy wam waszych win. ");
INSERT INTO polsz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Gdy ponownie przybyli do Jerozolimy i Jezus spacerował po terenie świątyni, podeszli do Niego najwyżsi kapłani wraz z innymi przywódcami religijnymi i starszymi, ");
INSERT INTO polsz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","pytając Go: —Jakim prawem wyrzuciłeś ze świątyni sprzedawców? Kto dał ci taką władzę? ");
INSERT INTO polsz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","—Odpowiem wam, jeśli i wy odpowiecie na moje pytanie—odparł Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","—Czy chrzest, do którego wzywał Jan Chrzciciel, pochodził od Boga, czy był tylko ludzkim wymysłem? ");
INSERT INTO polsz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wtedy zaczęli się naradzać nad odpowiedzią: —Jeśli powiemy, że pochodził od Boga, to zapyta nas „Czemu go nie przyjęliście?”. ");
INSERT INTO polsz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A jeśli powiemy, że był ludzkim wymysłem, to tłumy się oburzą, bo wszyscy przecież wierzą, że Jan był prorokiem. ");
INSERT INTO polsz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","—Nie potrafimy na to odpowiedzieć—rzekli w końcu. —Wobec tego i Ja nie odpowiem na wasze pytanie—odparł Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Wtedy opowiedział im następującą przypowieść: —Pewien człowiek założył winnicę. Ogrodził ją murem, zbudował tłocznię i wieżę strażniczą, po czym wynajął ją rolnikom i wyjechał. ");
INSERT INTO polsz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Gdy nastał czas zbiorów, wysłał jednego ze swoich ludzi, aby odebrał należną mu część plonów. ");
INSERT INTO polsz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lecz rolnicy pobili posłańca i odesłali go z pustymi rękami. ");
INSERT INTO polsz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Właściciel wysłał więc innego pełnomocnika, lecz z nim postąpili podobnie, a nawet gorzej, raniąc go poważnie w głowę. ");
INSERT INTO polsz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kolejnego posłańca zabito, a i następnych spotkała śmierć lub pobicie. ");
INSERT INTO polsz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","W końcu pozostał mu tylko jego jedyny syn. Posłał go więc, sądząc, że przynajmniej jemu okażą szacunek. ");
INSERT INTO polsz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lecz rolnicy, widząc nadchodzącego syna, powiedzieli sobie: „To ten, który ma przejąć winnicę. Zabijmy go, a winnica będzie nasza!”. ");
INSERT INTO polsz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Napadli go więc i zabili, a ciało wyrzucili poza winnicę. ");
INSERT INTO polsz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jak sądzicie, co zrobi właściciel, gdy się o tym dowie? Przyjdzie i ukarze wszystkich śmiercią, a winnicę da innym! ");
INSERT INTO polsz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Przypomnijcie sobie następujące słowa z Pisma: „Kamień odrzucony przez budujących stał się kamieniem węgielnym, najważniejszym w całym budynku! ");
INSERT INTO polsz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dokonał tego Pan i jest to zdumiewające”. ");
INSERT INTO polsz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Przywódcy zrozumieli, że to ich Jezus miał na myśli, opowiadając przypowieść o złych rolnikach. Dlatego chcieli Go natychmiast aresztować, ale obawiali się reakcji tłumu. Ostatecznie jednak zostawili Go i odeszli. ");
INSERT INTO polsz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chcąc sprowokować Jezusa do jakiejś niefortunnej wypowiedzi, wysłali do Niego faryzeuszy i zwolenników rodziny królewskiej. Potrzebny był im bowiem pretekst do oskarżenia Go. Gdy przybyli na miejsce, zapytali Jezusa: ");
INSERT INTO polsz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","—Nauczycielu! Wiemy, że nie boisz się mówić prawdy. Nie dostosowujesz się też do opinii ludzi ani do ich oczekiwań, lecz uczciwie nauczasz Bożych prawd. Powiedz nam więc, czy słusznie płacimy podatki Rzymowi, czy nie? ");
INSERT INTO polsz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jezus zdając sobie sprawę z ich podstępu, powiedział: —Chcecie Mnie pogrążyć?! Pokażcie Mi najpierw monetę! Chciałbym ją zobaczyć. ");
INSERT INTO polsz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Gdy Mu ją podano, zapytał: —Czyją podobiznę i tytuł na niej widzicie? —Cezara—odpowiedzieli. ");
INSERT INTO polsz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Oddawajcie więc cezarowi to, co jego, a Bogu—co należy do Boga! Odpowiedź ta zupełnie ich zaskoczyła. ");
INSERT INTO polsz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wtedy przyszli do Jezusa saduceusze—przedstawiciele ugrupowania nauczającego, że nie będzie zmartwychwstania: ");
INSERT INTO polsz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Nauczycielu!—zwrócili się do Jezusa. —Prawo Mojżesza naucza: „Jeśli umrze mężczyzna, nie pozostawiając potomstwa, jego brat powinien ożenić się z wdową po zmarłym i mieć z nią potomstwo”. ");
INSERT INTO polsz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Otóż żyło kiedyś siedmiu braci. Najstarszy z nich ożenił się, ale wkrótce zmarł, nie pozostawiając dzieci. ");
INSERT INTO polsz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wówczas z wdową ożenił się drugi brat, lecz i on wkrótce zmarł bezdzietnie. ");
INSERT INTO polsz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Potem ożenił się z nią następny i kolejny—i wszyscy poumierali bezdzietnie. W końcu umarła także ta kobieta. ");
INSERT INTO polsz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jeśli rzeczywiście umarli zmartwychwstaną, to czyją będzie wtedy żoną, skoro wszyscy bracia się z nią ożenili? ");
INSERT INTO polsz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","—Cała trudność polega na tym—odparł Jezus—że nie znacie Pisma ani mocy Bożej. ");
INSERT INTO polsz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Po zmartwychwstaniu więzy małżeńskie nie będą obowiązywać ani tych siedmiu braci, ani kobiety, bo wszyscy pod tym względem będą podobni do aniołów. ");
INSERT INTO polsz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Jeśli zaś chodzi o samo zmartwychwstanie, to czy nigdy nie czytaliście historii o Mojżeszu i płonącym krzaku? Bóg powiedział wtedy: „Jestem Bogiem Abrahama, Bogiem Izaaka i Bogiem Jakuba”. ");
INSERT INTO polsz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Przecież nie nazwałby siebie Bogiem tych, którzy już nie istnieją!! Jesteście w wielkim błędzie. ");
INSERT INTO polsz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Pewien przywódca religijny przysłuchiwał się tej dyskusji i był pełen uznania dla odpowiedzi Jezusa. Zadał Mu więc kolejne pytanie: —Które z przykazań jest najważniejsze? ");
INSERT INTO polsz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jezus odpowiedział: —Najważniejsze jest to, które mówi: „Słuchaj, Izraelu! Twój Pan i Bóg jest jedynym Bogiem. ");
INSERT INTO polsz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kochaj Go całym sercem, całą duszą i całym umysłem—z całych swoich sił”. ");
INSERT INTO polsz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","I drugie, które brzmi: „Kochaj innych tak, jak kochasz samego siebie”. Te dwa przykazania są najważniejsze ze wszystkich. ");
INSERT INTO polsz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","—Masz rację—powiedział rozmówca. —Jest tylko jeden Bóg i nie ma innego. ");
INSERT INTO polsz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","I jestem przekonany, że kochanie Go całym sercem i umysłem, ze wszystkich sił, a innych ludzi tak, jak samego siebie, jest o wiele ważniejsze niż składanie ofiar na ołtarzu w świątyni. ");
INSERT INTO polsz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","—Jesteś blisko królestwa Bożego!—powiedział Jezus, widząc jego mądrość. I nikt więcej nie śmiał zadawać Mu pytań. ");
INSERT INTO polsz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Później, w dalszym ciągu nauczając na terenie świątyni, Jezus zapytał ludzi: —Dlaczego wasi przywódcy religijni twierdzą, że Mesjasz ma pochodzić z rodu króla Dawida? ");
INSERT INTO polsz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Przecież sam Dawid, a przez jego usta Duch Święty, powiedział: „Bóg rzekł do mojego Pana: Zasiądź po mojej prawej stronie, dopóki nie rzucę Ci pod nogi Twoich nieprzyjaciół”. ");
INSERT INTO polsz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Skoro więc Dawid nazwał Go Panem—kontynuował Jezus—to jak Mesjasz może być jego potomkiem? Tłum ludzi słuchał tych nauk z wielkim zainteresowaniem. ");
INSERT INTO polsz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jezus przemawiał więc dalej: —Strzeżcie się przywódców religijnych! Oni lubią nosić wytworne szaty, oczekują wyrazów szacunku ze strony innych ludzi ");
INSERT INTO polsz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","oraz najlepszych miejsc w synagogach i na przyjęciach. ");
INSERT INTO polsz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bezwstydnie okradają biedne wdowy! Udają przy tym pobożnych i wygłaszają długie modlitwy, aby ukryć, kim są naprawdę. Tym większa spotka ich kara! ");
INSERT INTO polsz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jezus zbliżył się do skarbony świątynnej i usiadł, obserwując ludzi, którzy wrzucali tam pieniądze. I chociaż przychodzili bogaci ludzie i wrzucali duże sumy, On zwrócił uwagę na pewną wdowę. ");
INSERT INTO polsz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Była biedna i wrzuciła tylko dwie małe monety. ");
INSERT INTO polsz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Wtedy przywołał swoich uczniów i powiedział: —Zapewniam was: Ta biedna wdowa dała więcej niż wszyscy bogacze razem wzięci! ");
INSERT INTO polsz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Oni bowiem wrzucili tylko część tego, co mieli w nadmiarze, ona zaś oddała wszystko, co miała na życie. ");
INSERT INTO polsz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Gdy opuszczali świątynię, jeden z uczniów zachwycał się: —Nauczycielu, spójrz, co to za wspaniała budowla! Co za kamienie! ");
INSERT INTO polsz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","—To, co teraz podziwiacie, legnie w gruzach i nie pozostanie tu nawet kamień na kamieniu—odparł Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Później, gdy siedział na zboczu Góry Oliwnej, mając przed sobą widok na Jerozolimę, Piotr, Jakub, Jan i Andrzej dyskretnie zapytali Go: ");
INSERT INTO polsz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Kiedy wydarzy się to, o czym mówiłeś? Po czym poznamy nadejście tego czasu? ");
INSERT INTO polsz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","—Nie dajcie się nikomu oszukać!—przestrzegł ich Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","—Wielu bowiem będzie podawać się za Mesjasza i oszuka mnóstwo ludzi. ");
INSERT INTO polsz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Na świecie wybuchną wojny i będą rozchodzić się wieści o walkach. Nie dajcie się jednak zastraszyć, to jeszcze nie będzie koniec! ");
INSERT INTO polsz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Narody i państwa będą walczyć przeciwko sobie, a wiele krajów nawiedzą trzęsienia ziemi oraz głód. Ale to będzie dopiero początek tragedii. ");
INSERT INTO polsz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Przygotujcie się na to, co nastąpi! Postawią was przed sądami, będą was biczować w synagogach oraz oskarżać przed władzami o to, że Mnie naśladujecie. Będzie to dla was okazja do przedstawienia im dobrej nowiny. ");
INSERT INTO polsz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bo zanim nadejdzie koniec, muszą usłyszeć ją wszystkie narody. ");
INSERT INTO polsz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Gdy was aresztują i postawią przed sądem, nie martwcie się o to, co i jak macie mówić. Bo to nie wy będziecie mówić, lecz Duch Święty będzie mówił przez was! ");
INSERT INTO polsz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Bracia będą wzajemnie się wydawać na śmierć, ojcowie zdradzą własne dzieci, a dzieci—rodziców. ");
INSERT INTO polsz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wszyscy was znienawidzą za to, że należycie do Mnie. Ale ci, którzy wytrwają do końca i nie zaprą się Mnie, zostaną uratowani! ");
INSERT INTO polsz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Gdy zobaczycie w świątyni „ohydę spustoszenia”—kto to czyta, niech uważa—wtedy ci, którzy będą w Judei, niech uciekają w góry. ");
INSERT INTO polsz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","I śpieszcie się! Jeśli będziecie na tarasie, nie wchodźcie do domu, aby się spakować. ");
INSERT INTO polsz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jeśli będziecie na polu, nie wracajcie po pieniądze czy ubranie. ");
INSERT INTO polsz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ciężko będzie wtedy kobietom w ciąży i matkom karmiącym niemowlęta. ");
INSERT INTO polsz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Módlcie się, żeby wasza ucieczka nie wypadła zimą. ");
INSERT INTO polsz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Będą to bowiem dni tak straszliwe, jakich nie było od początku świata i już nigdy potem nie będzie. ");
INSERT INTO polsz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","I gdyby Pan nie skrócił czasu tej klęski, nikt by się nie uratował. Lecz On skróci te dni ze względu na swoich wybranych. ");
INSERT INTO polsz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Jeśli wtedy ktoś wam powie: „Tu jest Mesjasz”—nie wierzcie! ");
INSERT INTO polsz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Pojawi się bowiem wielu fałszywych mesjaszy i proroków, którzy będą czynić wielkie cuda, starając się oszukać nawet wybranych przez Boga. ");
INSERT INTO polsz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Dlatego uważajcie i pamiętajcie, że was ostrzegałem! ");
INSERT INTO polsz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Zaraz po zakończeniu tego strasznego czasu nastąpi zaćmienie słońca, a księżyc straci swój blask. ");
INSERT INTO polsz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Gwiazdy będą spadać z nieba i zachwieje się cały porządek wszechświata. ");
INSERT INTO polsz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Wtedy cała ludzkość ujrzy Mnie, Syna Człowieczego, przybywającego na obłokach w wielkiej mocy i chwale. ");
INSERT INTO polsz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","I poślę aniołów, żeby zgromadzili Moich wybranych z całego świata, z najdalszych zakątków ziemi. ");
INSERT INTO polsz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Niech to drzewo figowe stanie się dla was przykładem: Gdy jego pączki miękną, a listki zaczynają się rozwijać, mówicie, że zbliża się lato. ");
INSERT INTO polsz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Gdy więc zobaczycie wszystko, co wam zapowiedziałem, bądźcie pewni, że mój powrót jest bliski, że jestem tuż u drzwi. ");
INSERT INTO polsz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Zapewniam was: Nie wymrze to pokolenie, a wszystko to się dokona. ");
INSERT INTO polsz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Niebo i ziemia przeminą, lecz moje słowa pozostaną na wieki. ");
INSERT INTO polsz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nikt jednak nie zna dnia ani czasu, kiedy się to stanie—ani aniołowie w niebie, ani nawet Ja—Syn. Wie o tym tylko mój Ojciec. ");
INSERT INTO polsz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Skoro więc nie wiecie, kiedy się to wydarzy—uważajcie i wyczekujcie mojego powrotu! ");
INSERT INTO polsz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Moje drugie przyjście można porównać do powrotu człowieka, który wyjechał w podróż do innego kraju. Powyznaczał pracownikom ich zadania, stróżowi zaś nakazał czuwać aż do swego przyjazdu. ");
INSERT INTO polsz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Uważajcie więc, bo wy również nie wiecie, kiedy przyjdę: wieczorem, o północy, o świcie czy po wschodzie słońca. ");
INSERT INTO polsz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nie dopuśćcie, abym zastał was śpiących. ");
INSERT INTO polsz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Czekajcie i bądźcie przygotowani—oto moje przykazanie dla wszystkich, którzy we Mnie wierzą. ");
INSERT INTO polsz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Dwa dni później rozpoczęła się Pascha—doroczne święto Żydów, w czasie którego jedzą oni chleb pieczony z niekwaszonego ciasta. Najwyżsi kapłani i inni przywódcy religijni nadal szukali okazji, aby potajemnie aresztować i zabić Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—Nie możemy jednak zrobić tego podczas święta—mówili—bo spowoduje to rozruchy. ");
INSERT INTO polsz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jezus tymczasem zatrzymał się w Betanii, w domu Szymona Trędowatego. W czasie kolacji weszła tam pewna kobieta z butelką bardzo drogiego, wonnego olejku. Stłukła szyjkę i wylała olejek na głowę Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Widząc to, niektórzy oburzyli się i ostro ją skrytykowali: —Co za marnotrawstwo! Przecież można było sprzedać te perfumy i uzyskaną w ten sposób znaczną sumę rozdać biednym! ");
INSERT INTO polsz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","—Dajcie jej spokój—powiedział Jezus. —Dlaczego ją krytykujecie? Przecież spełniła dobry uczynek! ");
INSERT INTO polsz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Biedni zawsze będą wśród was i będziecie mogli im pomagać, kiedy tylko zechcecie, ale Mnie już wkrótce zabraknie. ");
INSERT INTO polsz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ona dała to, co miała. Namaszczając tym olejkiem, przygotowała Mnie na pogrzeb. ");
INSERT INTO polsz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Zapewniam was: Gdziekolwiek na świecie będzie głoszona dobra nowina, wszędzie będzie się mówić o tym, co zrobiła, i będą pamiętać o niej. ");
INSERT INTO polsz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wtedy Judasz z Kariotu, jeden z Dwunastu, wyszedł i udał się do najwyższych kapłanów, aby im zaproponować, że wyda Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ucieszeni tą propozycją, kapłani obiecali mu nagrodę. On zaś czekał już tylko na sprzyjającą okazję, aby wydać Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pierwszego dnia Paschy, gdy zgodnie ze zwyczajem zabijano i spożywano baranka, uczniowie spytali Jezusa, gdzie chciałby spożyć kolację paschalną. ");
INSERT INTO polsz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wysłał więc dwóch uczniów, by poczynili niezbędne przygotowania. —Idźcie do miasta!—powiedział. —A gdy spotkacie mężczyznę z dzbanem wody, pójdźcie za nim. ");
INSERT INTO polsz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wejdźcie do domu, do którego on wejdzie, i powiedzcie właścicielowi: „Nasz Nauczyciel prosi, abyśmy obejrzeli pokój przygotowany dla nas na świąteczną kolację”. ");
INSERT INTO polsz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wtedy zaprowadzi was na górę do dużego, wysprzątanego pomieszczenia. Tam przygotujcie posiłek. ");
INSERT INTO polsz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Poszli więc do miasta i zastali wszystko tak, jak powiedział Jezus. I zajęli się przygotowaniem kolacji. ");
INSERT INTO polsz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wieczorem przybył Jezus wraz z Dwunastoma. ");
INSERT INTO polsz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Gdy zaczęli posiłek, powiedział: —Mówię wam: Jeden z was, siedzących tu ze Mną, zdradzi Mnie. ");
INSERT INTO polsz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","—Ale to chyba nie ja, Panie?—mówili zasmuceni jeden przez drugiego. ");
INSERT INTO polsz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Jeden z was, Dwunastu! Ten, który jednocześnie ze Mną sięga do półmiska—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","—Ja, Syn Człowieczy, muszę umrzeć, zgodnie z tym, co dawno zapowiedzieli prorocy. Marny jednak los tego, kto Mnie wyda. Lepiej byłoby, aby się wcale nie urodził! ");
INSERT INTO polsz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Później, podczas kolacji, Jezus wziął do rąk chleb. Podziękował za niego Bogu, połamał go na kawałki, i podał uczniom, mówiąc: —Weźcie, to jest moje ciało. ");
INSERT INTO polsz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wziął też do ręki kielich z winem. Podziękował, podał im, i wszyscy z niego pili. ");
INSERT INTO polsz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—To jest moja krew, pieczętująca przymierze. —powiedział. —Przelewam ją, aby wielu otrzymało przebaczenie grzechów. ");
INSERT INTO polsz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Oświadczam wam, że nie skosztuję już wina do dnia, gdy będę pił nowe wino w królestwie Bożym. ");
INSERT INTO polsz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Potem zaśpiewali pieśń i poszli na Górę Oliwną. ");
INSERT INTO polsz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","—Wszyscy Mnie opuścicie—mówił do nich Jezus. —Stanie się tak, jak Bóg zapowiedział ustami proroków: „Uderzę pasterza i rozproszą się owce jego stada”. ");
INSERT INTO polsz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lecz gdy znów powrócę do życia, udam się do Galilei i tam się z wami spotkam. ");
INSERT INTO polsz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","—Ja Cię nigdy nie opuszczę!—zapewniał Piotr. —Nawet jeśli inni odejdą! ");
INSERT INTO polsz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","—Zapewniam cię, że jeszcze tej nocy, zanim o świcie dwa razy zapieje kogut, trzy razy zaprzeczysz, że Mnie znasz—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","—Nigdy!—zdecydowanie zaprotestował Piotr. —Nie wyprę się Ciebie, nawet gdybym miał iść z Tobą na śmierć! Pozostali również przysięgali wierność Jezusowi. ");
INSERT INTO polsz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wszyscy razem udali się do ogrodu zwanego Getsemane. Jezus rzekł wtedy: —Usiądźcie tutaj, a ja pójdę się modlić. ");
INSERT INTO polsz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Zabrał ze sobą tylko Piotra, Jakuba i Jana. I ogarnął Go lęk oraz głęboki niepokój. ");
INSERT INTO polsz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","—Moją duszę ogarnął śmiertelny smutek—powiedział. —Zostańcie ze Mną i czuwajcie. ");
INSERT INTO polsz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Odszedł na bok, padł na ziemię i zaczął się modlić, aby, jeżeli to możliwe, ominęła Go ta straszna chwila. ");
INSERT INTO polsz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Ojcze!—mówił. —Ty możesz wszystko! Oddal ode Mnie ten „kielich cierpienia”. Jednak to Twoja wola niech się stanie, a nie to, czego ja chcę. ");
INSERT INTO polsz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wrócił do trzech uczniów i zastał ich śpiących. Wtedy powiedział do Piotra: —Szymonie, śpisz? Nie dałeś rady czuwać ze Mną nawet przez godzinę? ");
INSERT INTO polsz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Czuwajcie i módlcie się, abyście nie poddali się pokusie! Duch jest gorliwy, ale ciało słabe. ");
INSERT INTO polsz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ponownie odszedł i dalej się modlił. ");
INSERT INTO polsz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Lecz uczniowie byli tak bardzo zmęczeni, że gdy do nich wrócił, znowu spali. Zawstydzeni tym, nie próbowali nawet się tłumaczyć. ");
INSERT INTO polsz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A gdy przyszedł do nich po raz trzeci, powiedział: —Wciąż spokojnie śpicie i odpoczywacie? Starczy już! Wybiła moja godzina. Teraz Ja, Syn Człowieczy, zostanę wydany w ręce grzeszników. ");
INSERT INTO polsz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wstańcie, chodźmy! Nadchodzi już ten, który Mnie zdradził! ");
INSERT INTO polsz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ledwie skończył mówić, stanął przed Nim Judasz, jeden z Dwunastu, na czele zgrai uzbrojonej w miecze i pałki, wysłanej przez najwyższych kapłanów, przywódców religijnych i starszych. ");
INSERT INTO polsz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ten zdrajca tak się z nimi umówił: „Łapcie i aresztujcie tego, którego pocałuję na powitanie”. ");
INSERT INTO polsz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Gdy się więc tylko zbliżyli, Judasz podszedł do Jezusa. —Mistrzu!—rzekł i przywitał Go pocałunkiem. ");
INSERT INTO polsz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wówczas pozostali rzucili się na Niego i złapali Go. ");
INSERT INTO polsz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wtedy jeden z uczniów wyjął miecz, zamachnął się i odciął ucho słudze najwyższego kapłana. ");
INSERT INTO polsz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","—Czy jestem jakimś groźnym przestępcą, że przyszliście po Mnie aż tak uzbrojeni?—zapytał Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","—Dlaczego nie zatrzymaliście Mnie w świątyni? Przecież codziennie tam nauczałem! Wszystko jednak dzieje się zgodnie z tym, co przepowiedziały o Mnie proroctwa. ");
INSERT INTO polsz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wtedy wszyscy uczniowie opuścili Go i uciekli. ");
INSERT INTO polsz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jedynie z tyłu, w pewnym oddaleniu, szedł za nimi jakiś młody człowiek w lekko narzuconej na siebie koszuli. Lecz gdy napastnicy próbowali go schwytać, ");
INSERT INTO polsz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","uciekł nagi, pozostawiając w ich rękach tylko podartą koszulę. ");
INSERT INTO polsz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jezusa zaprowadzono zaś do rezydencji najwyższego kapłana, u którego wkrótce zebrali się inni ważniejsi kapłani, przywódcy religijni i starsi. ");
INSERT INTO polsz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piotr, który szedł za Jezusem, trzymając się z daleka, wszedł na teren rezydencji i usiadł przy ognisku razem ze służbą. ");
INSERT INTO polsz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Obradujący wewnątrz kapłani i cała Wysoka Rada usiłowali znaleźć przeciw Jezusowi jakiś zarzut, który dałby im prawo skazania Go na śmierć. Jednak ich wysiłki były daremne. ");
INSERT INTO polsz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wprawdzie głos zabierało wielu fałszywych świadków, ale ich zeznania były sprzeczne. ");
INSERT INTO polsz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","W końcu kilku z nich wystąpiło z następującym oskarżeniem: ");
INSERT INTO polsz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Słyszeliśmy, jak Jezus mówił: „Zburzę tę świątynię, zbudowaną przez ludzi, i bez pomocy ludzkich rąk w trzy dni zbuduję nową!”. ");
INSERT INTO polsz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ale i w tym ich relacje nie były zgodne. ");
INSERT INTO polsz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wtedy najwyższy kapłan wstał i w obecności całej Rady zapytał Jezusa: —Nie będziesz się bronił wobec tych oskarżeń? ");
INSERT INTO polsz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lecz Jezus milczał i nic nie odpowiedział. Wtedy najwyższy kapłan zadał mu kolejne pytanie: —Jesteś Mesjaszem, Synem Bożym? ");
INSERT INTO polsz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Tak, jestem!—rzekł Jezus. —Wkrótce zobaczycie Mnie, Syna Człowieczego, zasiadającego na tronie z Bogiem i powracającego w obłokach na ziemię. ");
INSERT INTO polsz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Słysząc to, najwyższy kapłan rozdarł szaty i głośno zapytał: —Czego więcej trzeba? Po co nam świadkowie? ");
INSERT INTO polsz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sami słyszeliście to bluźnierstwo! Jaki będzie wasz wyrok? —Kara śmierci!—zawołali. ");
INSERT INTO polsz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","I zaczęli pluć na Jezusa. Zawiązali Mu oczy, bili Go po twarzy i szyderczo wołali: —Teraz prorokuj! Również strażnicy, którzy pilnowali Jezusa, znęcali się nad Nim. ");
INSERT INTO polsz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tymczasem Piotr wciąż przebywał na dziedzińcu rezydencji. Gdy grzał się przy ogniu, zauważyła go jedna z dziewczyn służących u najwyższego kapłana. ");
INSERT INTO polsz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Przyjrzała mu się uważnie i oświadczyła: —Ty również byłeś z Jezusem z Nazaretu! ");
INSERT INTO polsz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","—Nie wiem, o czym mówisz!—zaprzeczył Piotr i szybko usunął się w najdalszy kąt dziedzińca. Wtedy właśnie rozległo się pianie koguta. ");
INSERT INTO polsz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dziewczyna, widząc stojącego na uboczu Piotra, pokazała go innym. —Tam jest ten uczeń Jezusa! ");
INSERT INTO polsz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ale Piotr znowu zaprzeczył. Po pewnej chwili stojący tam ludzie podeszli do niego i stwierdzili: —Ty również jesteś jednym z nich! Przecież pochodzisz z Galilei. ");
INSERT INTO polsz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","—Naprawdę nie znam tego Człowieka!!!—znowu zaczął się zaklinać i przysięgać. ");
INSERT INTO polsz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","I ponownie zapiał kogut. Wtedy Piotr przypomniał sobie słowa Jezusa: „Zanim o świcie dwa razy zapieje kogut, trzy razy zaprzeczysz, że Mnie znasz”. I wybuchnął płaczem. ");
INSERT INTO polsz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Następnego dnia, wczesnym rankiem, najwyżsi kapłani, starsi i przywódcy religijni zebrali się razem z całą Wysoką Radą i postanowili przekazać Jezusa pod zbrojną eskortą Piłatowi, rzymskiemu gubernatorowi. ");
INSERT INTO polsz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","A gdy przyprowadzono Jezusa do Piłata, ten zapytał Go: —Jesteś Królem Żydów? —Sam to potwierdzasz—odpowiedział mu Jezus. ");
INSERT INTO polsz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","A ponieważ, obecni tam, najwyżsi kapłani ciągle wysuwali przeciwko Niemu wiele zarzutów, ");
INSERT INTO polsz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Piłat zapytał Go: —Czemu nic nie mówisz? Czy nie słyszysz tych wszystkich oskarżeń? ");
INSERT INTO polsz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lecz, ku jego wielkiemu zdziwieniu, Jezus nie odezwał się już ani słowem. ");
INSERT INTO polsz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","A był zwyczaj, że raz w roku, na święto Paschy, Piłat uwalniał na prośbę ludu jednego żydowskiego więźnia. ");
INSERT INTO polsz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","W tym czasie przebywał właśnie w więzieniu Barabasz, skazany wraz z innymi za morderstwo popełnione podczas rozruchów. ");
INSERT INTO polsz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Gdy więc, jak co roku, przed rezydencją Piłata, zebrali się ludzie proszący o uwolnienie więźnia, gubernator zapytał ich: ");
INSERT INTO polsz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","—Czy chcecie, abym uwolnił Króla Żydów? ");
INSERT INTO polsz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Zorientował się bowiem, że to najwyżsi kapłani z nienawiści uknuli ten spisek przeciwko Jezusowi. ");
INSERT INTO polsz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kapłani jednak podburzyli tłum i ten, zamiast o Jezusa, prosił o uwolnienie Barabasza. ");
INSERT INTO polsz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","—Co mam zatem zrobić z Królem Żydów?—kontynuował Piłat. ");
INSERT INTO polsz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—Ukrzyżuj go!—zawołali w odpowiedzi. ");
INSERT INTO polsz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—Ale dlaczego?—dopytywał Piłat. —Jakie przestępstwo popełnił? Oni jednak nie słuchali go i coraz głośniej wołali: —Ukrzyżuj go!!! ");
INSERT INTO polsz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Chcąc więc zadowolić tłum, Piłat uwolnił Barabasza. Jezusa natomiast kazał ubiczować i skazał na śmierć przez ukrzyżowanie. ");
INSERT INTO polsz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Żołnierze wyprowadzili Go na dziedziniec i zwołali cały oddział. ");
INSERT INTO polsz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ubrali Go w purpurowy płaszcz i włożyli na Jego głowę koronę uplecioną z długich, ostrych cierni. ");
INSERT INTO polsz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Potem, niby to oddając Mu honory, wykrzykiwali: —Niech żyje Król Żydów! ");
INSERT INTO polsz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","I bili Go po głowie trzcinowym kijem, pluli na Niego i drwiąc padali na kolana, aby oddać Mu pokłon. ");
INSERT INTO polsz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Gdy im się to znudziło, ściągnęli z Niego purpurowy płaszcz, nałożyli Mu z powrotem Jego własne ubranie i poprowadzili na ukrzyżowanie. ");
INSERT INTO polsz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Po drodze zmusili przechodzącego tamtędy Szymona z Cyreny, ojca Aleksandra i Rufusa, aby niósł Jego krzyż. ");
INSERT INTO polsz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","W ten sposób doprowadzili Jezusa na miejsce zwane Golgotą (to znaczy: „Czaszką”). ");
INSERT INTO polsz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tam podali Mu do picia wino zaprawione gorzkimi ziołami, ale nie chciał go pić. ");
INSERT INTO polsz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Potem Go ukrzyżowali, a o Jego ubranie rzucili losy, aby ustalić, co kto ma wziąć. ");
INSERT INTO polsz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Była godzina dziewiąta rano. ");
INSERT INTO polsz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Do krzyża przybito tabliczkę z opisem Jego winy: „Król Żydów”. ");
INSERT INTO polsz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Po obu stronach Jezusa ukrzyżowano dwóch przestępców. ");
INSERT INTO polsz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","I tak spełniły się słowa Pisma: „Zaliczono Go do przestępców”. ");
INSERT INTO polsz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Przechodzący obok ludzie śmiali się z Niego. Patrzyli z pogardą i wołali: —Widzisz, jak skończyłeś? Mówiłeś, że potrafisz zburzyć i w trzy dni odbudować świątynię! ");
INSERT INTO polsz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Skoro jesteś taki mocny, uratuj teraz siebie samego i zejdź z krzyża! ");
INSERT INTO polsz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Stali tam również najwyżsi kapłani i inni przywódcy religijni. Oni także naśmiewali się z Jezusa: —Innych potrafił ratować, a siebie uratować nie może! ");
INSERT INTO polsz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Taki z niego Mesjasz, Król Izraela? Niech zejdzie z krzyża. Jeśli to zrobi, uwierzymy mu! Również przestępcy, wiszący obok Jezusa, naśmiewali się z Niego. ");
INSERT INTO polsz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nagle, około południa, całą ziemię okrył mrok i aż do godziny trzeciej było ciemno. ");
INSERT INTO polsz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wtedy właśnie Jezus głośno zawołał: —Eloi, Eloi, lema sabachthani! (co znaczy: „Boże mój, Boże mój, czemu Mnie opuściłeś?”). ");
INSERT INTO polsz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Stojący w pobliżu ludzie sądzili, że woła proroka Eliasza. ");
INSERT INTO polsz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jakiś człowiek pobiegł nawet po gąbkę, nasączył ją kwaśnym winem i podał Jezusowi, żeby się napił. —Zobaczmy, czy zjawi się Eliasz i pomoże mu zejść!—wytłumaczył zebranym. ");
INSERT INTO polsz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Lecz Jezus wydał jeszcze jeden okrzyk i skonał. ");
INSERT INTO polsz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","W tej samej chwili zasłona w świątyni, oddzielająca miejsce najświętsze, rozdarła się na dwie części—od góry aż do dołu. ");
INSERT INTO polsz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","A rzymski dowódca, który stał obok krzyża i widział, jak Jezus umiera, zawołał: —To naprawdę był Syn Boży! ");
INSERT INTO polsz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kilka kobiet z daleka przyglądało się temu wszystkiemu—między innymi Maria z Magdali, Maria—matka Jakuba Mniejszego i Józefa, oraz Salome. ");
INSERT INTO polsz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wierzyły one w Jezusa i służyły Mu pomocą, gdy przebywał w Galilei. A teraz, wraz z wieloma innymi kobietami, przyszły za Nim do Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ponieważ wszystko to wydarzyło się w dniu poprzedzającym szabat, ");
INSERT INTO polsz_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","pewien powszechnie szanowany członek Wysokiej Rady, Józef z Arymatei, oczekujący nadejścia królestwa Bożego, zdobył się na odwagę i pod wieczór przyszedł do Piłata z prośbą o wydanie mu ciała Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Piłat nie wierzył, że Jezus już nie żyje. Aby sprawdzić tę wiadomość, wezwał dowódcę odpowiedzialnego za ukrzyżowanie. ");
INSERT INTO polsz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Gdy uzyskał od niego potwierdzenie, zezwolił Józefowi zabrać ciało. ");
INSERT INTO polsz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Wtedy Józef kupił długie lniane płótno, owinął nim zdjęte z krzyża ciało Jezusa i złożył je w grobie, który był wykuty w skale. Wejście do grobu zamknięto przy pomocy ogromnego kamienia. ");
INSERT INTO polsz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria z Magdali oraz Maria—matka Józefa, dokładnie zobaczyły, gdzie położono Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Gdy skończył się szabat, Maria z Magdali wraz z Salome i Marią—matką Jakuba, zakupiły wonne zioła, pragnąc namaścić nimi ciało Jezusa. ");
INSERT INTO polsz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wczesnym rankiem, gdy tylko wzeszło słońce, udały się do grobu. ");
INSERT INTO polsz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Po drodze zastanawiały się, jak sobie poradzą z głazem zamykającym wejście. ");
INSERT INTO polsz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Gdy jednak przybyły na miejsce, zauważyły, że potężny kamień został przesunięty i wejście do grobu jest otwarte. ");
INSERT INTO polsz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Weszły więc do środka i ujrzały młodzieńca w białej szacie, siedzącego po prawej stronie. A ponieważ bardzo się przestraszyły, ");
INSERT INTO polsz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","rzekł on do nich: —Nie bójcie się! Czy szukacie Jezusa z Nazaretu, który został ukrzyżowany? Nie ma Go tutaj. Powstał z martwych! Spójrzcie, oto miejsce, gdzie leżało Jego ciało. ");
INSERT INTO polsz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Idźcie teraz i powiedzcie Piotrowi oraz pozostałym uczniom: „Jezus oczekuje was w Galilei i tam właśnie was spotka, tak jak zapowiedział przed śmiercią”. ");
INSERT INTO polsz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Drżąc ze strachu, kobiety uciekły od grobu i w oszołomieniu nikomu nie powiedziały ani słowa. ");
INSERT INTO polsz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Zmartwychwstały Jezus po raz pierwszy ukazał się w niedzielę rano. Najpierw ujrzała Go Maria z Magdali—ta sama, z której wypędził siedem demonów. ");
INSERT INTO polsz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Odnalazła zapłakanych, pogrążonych w smutku uczniów ");
INSERT INTO polsz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","i powiedziała im, że widziała Jezusa i że On żyje. Oni jednak nie uwierzyli jej. ");
INSERT INTO polsz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tego samego dnia Jezus ukazał się także dwóm innym uczniom, będącym w drodze. Z początku nie poznali Go, gdyż zmienił swój wygląd. ");
INSERT INTO polsz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Gdy jednak zrozumieli, kim jest, wrócili, aby powiadomić o tym pozostałych. Nadal jednak nikt nie chciał w to uwierzyć. ");
INSERT INTO polsz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Następnie Jezus ukazał się jedenastu uczniom, gdy razem jedli posiłek, i wypominał im ich niewiarę oraz upór, bo nie chcieli uwierzyć świadkom Jego zmartwychwstania. ");
INSERT INTO polsz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Potem rzekł do nich: —Idźcie na cały świat i przekazujcie wszystkim dobrą nowinę. ");
INSERT INTO polsz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ci, którzy uwierzą i dadzą się ochrzcić, zostaną zbawieni, a ci, którzy nie uwierzą, będą potępieni. ");
INSERT INTO polsz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wierzący, mocą mojego autorytetu, będą wypędzać demony i mówić nowymi językami. ");
INSERT INTO polsz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Będą nawet mogli brać do rąk węże, a jeśli wypiją coś trującego, nic im się nie stanie. Będą też mogli uzdrawiać chorych, kładąc na nich ręce. ");
INSERT INTO polsz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Gdy Jezus skończył z nimi rozmawiać, został wzięty do nieba i zasiadł po prawej stronie Boga. ");
INSERT INTO polsz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Uczniowie zaś wyruszyli, by wszędzie głosić dobrą nowinę. A Pan współdziałał z nimi i poprzez cuda potwierdzał, że to, co mówią, jest prawdą.");
INSERT INTO polsz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Dostojny Teofilu! Wielu już starało się uporządkować wydarzenia z życia Chrystusa, ");
INSERT INTO polsz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","zgodnie z tym, co przekazali naoczni świadkowie i pierwsi głosiciele słowa. ");
INSERT INTO polsz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ja również uznałem za słuszne przestudiować je, od pierwszego do ostatniego, i dokładnie opisać wszystko po kolei, ");
INSERT INTO polsz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","abyś był pewien tego, czego się nauczyłeś. ");
INSERT INTO polsz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Zacznę od historii o pewnym kapłanie, Zachariaszu, który żył w Judei za panowania króla Heroda. Należał on do kapłańskiej grupy Abiasza. Z kapłańskiego rodu Aarona pochodziła również jego żona, Elżbieta. ");
INSERT INTO polsz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Byli to ludzie prawi w oczach Boga, żyjący w zgodzie zarówno z duchem, jak i z literą całego Bożego Prawa. ");
INSERT INTO polsz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Oboje dożyli sędziwego wieku, ale nie mieli dzieci, gdyż Elżbieta była bezpłodna. ");
INSERT INTO polsz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pewnego dnia, grupa Zachariasza pełniła służbę w świątyni, jemu zaś w drodze losowania ");
INSERT INTO polsz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","przypadł zaszczyt wejścia do miejsca świętego i złożenia Panu ofiary z kadzidła. ");
INSERT INTO polsz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","W tym czasie na dziedzińcu znajdowało się wielu modlących się ludzi. ");
INSERT INTO polsz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Będąc w świątyni, Zachariasz ujrzał nagle anioła Bożego stojącego po prawej stronie ołtarza kadzenia. ");
INSERT INTO polsz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ogarnęły go zdumienie i strach. ");
INSERT INTO polsz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lecz anioł powiedział: —Nie bój się, Zachariaszu! Przyszedłem ci oznajmić, że Bóg wysłuchał twojej modlitwy: Elżbieta, twoja żona, urodzi syna. Daj mu na imię Jan. ");
INSERT INTO polsz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Stanie się on przyczyną radości nie tylko dla was, ale także dla wielu innych ludzi. ");
INSERT INTO polsz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Będzie wielki w oczach Pana. Nie będzie pił wina ani innych tego rodzaju napojów i już w łonie matki zostanie napełniony Duchem Świętym. ");
INSERT INTO polsz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Przekona on wielu potomków Izraela, aby powrócili do Pana, swojego Boga. ");
INSERT INTO polsz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Będzie się odznaczał nieugiętym duchem i mocą proroka Eliasza. To on poprzedzi nadejście Mesjasza i przygotuje ludzi dla Pana, nauczając ich prawości. Pogodzi również rodziców z dziećmi. ");
INSERT INTO polsz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","—To chyba niemożliwe?—odpowiedział Zachariasz aniołowi. —Jestem już przecież stary, a moja żona również jest w podeszłym wieku. ");
INSERT INTO polsz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","—Ja jestem Gabriel—rzekł wtedy anioł. —Przebywam w najbliższym otoczeniu Boga. To On posłał mnie do ciebie z tą dobrą nowiną. ");
INSERT INTO polsz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ponieważ mi jednak nie uwierzyłeś, staniesz się niemy aż do czasu spełnienia się wszystkiego, co zapowiedziałem. ");
INSERT INTO polsz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tymczasem ludzie na dziedzińcu czekali na Zachariasza i dziwili się, dlaczego jeszcze nie wychodzi. ");
INSERT INTO polsz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Gdy się wreszcie ukazał, nie był w stanie wypowiedzieć ani słowa. Po jego gestach zebrani zorientowali się, że właśnie widział anioła. ");
INSERT INTO polsz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zachariasz pozostał w świątyni jeszcze kilka dni i dopiero po zakończeniu swojej kapłańskiej służby powrócił do domu. ");
INSERT INTO polsz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wkrótce jego żona zaszła w ciążę i przez pięć następnych miesięcy żyła w odosobnieniu. ");
INSERT INTO polsz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Jakże dobry jest Pan!—cieszyła się. —Zdjął ze mnie hańbę bezdzietności. ");
INSERT INTO polsz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Gdy Elżbieta była w szóstym miesiącu ciąży, Bóg posłał anioła Gabriela do galilejskiego miasteczka Nazaret, ");
INSERT INTO polsz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","do pewnej panny o imieniu Maria, która była narzeczoną Józefa, potomka króla Dawida. ");
INSERT INTO polsz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel, stanąwszy przed nią, powiedział: —Witaj! Pan jest z tobą i obdarzył cię szczególną łaską! ");
INSERT INTO polsz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Oszołomiona Maria zastanawiała się, co miałoby oznaczać takie powitanie. ");
INSERT INTO polsz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","—Nie bój się, Mario!—rzekł wtedy anioł. —Bóg zechciał ci okazać wyjątkową łaskę! ");
INSERT INTO polsz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wkrótce poczniesz i urodzisz syna, któremu dasz na imię Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Będzie On wielki i nazwą Go Synem Najwyższego. Bóg da Mu tron Jego przodka, króla Dawida. ");
INSERT INTO polsz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Będzie wiecznie panował nad Izraelem, a Jego królestwo nie będzie miało końca! ");
INSERT INTO polsz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","—Ale jak to się stanie?—zapytała Maria. —Jestem jeszcze dziewicą! ");
INSERT INTO polsz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","—Zstąpi na ciebie Duch Święty i osłoni cię moc Boga. Dlatego dziecko, które urodzisz, będzie świętym Synem Boga. ");
INSERT INTO polsz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Sześć miesięcy temu twoja krewna Elżbieta, uważana za bezpłodną, również zaszła w ciążę, mimo podeszłego wieku. ");
INSERT INTO polsz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dla Boga bowiem wszystko jest możliwe. ");
INSERT INTO polsz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","—Chcę służyć mojemu Panu—rzekła Maria—i jestem gotowa na wszystko, co się Jemu podoba. Niech się stanie tak, jak powiedziałeś. Wtedy anioł odszedł. ");
INSERT INTO polsz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maria szybko udała się do rodzinnego miasta Zachariasza, położonego w górzystej krainie Judei, ");
INSERT INTO polsz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","aby odwiedzić Elżbietę. ");
INSERT INTO polsz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Gdy tylko wypowiedziała słowa pozdrowienia, na dźwięk jej głosu poruszyło się w łonie Elżbiety dziecko, a ona sama została napełniona Duchem Świętym. ");
INSERT INTO polsz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Zawołała z radości i powiedziała do Marii: —Jak bardzo Bóg wyróżnił cię spośród wszystkich kobiet i jak szczęśliwe jest twoje dziecko! ");
INSERT INTO polsz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","To dla mnie zaszczyt, że odwiedziła mnie matka mojego Pana! ");
INSERT INTO polsz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gdy tylko usłyszałam twoje pozdrowienie, z radości poruszyło się we mnie dzieciątko! ");
INSERT INTO polsz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Naprawdę Bóg obdarzył cię wyjątkowym szczęściem, bo uwierzyłaś, że spełnią się Jego słowa. Maria powiedziała wtedy: ");
INSERT INTO polsz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","—Z całej duszy wielbię Pana, ");
INSERT INTO polsz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mojego Boga i Zbawiciela! Obdarzył mnie bowiem wielką radością ");
INSERT INTO polsz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","i dostrzegł swoją pokorną służebnicę! Dlatego od tej pory wszystkie pokolenia będą mnie nazywać szczęśliwą. ");
INSERT INTO polsz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Wszechmocny i Święty dokonał bowiem w moim życiu wspaniałych rzeczy. ");
INSERT INTO polsz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","On w każdym pokoleniu okazuje miłość tym, którzy są Mu posłuszni. ");
INSERT INTO polsz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Jego moc jest niezwyciężona! Rozproszył ludzi dumnych i wyniosłych. ");
INSERT INTO polsz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Zrzucił z tronu władców, a wywyższył pokornych. ");
INSERT INTO polsz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nakarmił głodnych, a bogatych odesłał z pustymi rękami. ");
INSERT INTO polsz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Pomógł swojemu słudze, Izraelowi i nie zapomniał o miłości, ");
INSERT INTO polsz_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","którą na zawsze przyrzekł Abrahamowi oraz jego dzieciom, naszym przodkom. ");
INSERT INTO polsz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria przebywała u Elżbiety około trzech miesięcy, po czym wróciła do domu. ");
INSERT INTO polsz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Gdy nadszedł czas, Elżbieta urodziła syna. ");
INSERT INTO polsz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wiadomość o łasce, okazanej jej przez Pana, dotarła wkrótce do krewnych i znajomych i wszyscy bardzo się ucieszyli. ");
INSERT INTO polsz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ósmego dnia po urodzeniu zeszli się na uroczystość obrzezania. Chcieli, aby dziecko otrzymało imię ojca—Zachariasza, ");
INSERT INTO polsz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ale Elżbieta sprzeciwiła się temu: —Nie! Damy mu na imię Jan—rzekła. ");
INSERT INTO polsz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—Dlaczego? Przecież w całej twojej rodzinie nie ma ani jednej osoby o takim imieniu! ");
INSERT INTO polsz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Zwrócili się więc do Zachariasza, ojca dziecka. ");
INSERT INTO polsz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","On zaś gestem poprosił, aby mu podano tabliczkę, i ku zdziwieniu obecnych napisał: „Niech się nazywa Jan”. ");
INSERT INTO polsz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","W tej samej chwili odzyskał mowę i zaczął wielbić Boga. ");
INSERT INTO polsz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wszystkich zebranych ogarnął lęk i podziw, a wiadomość o tym zdarzeniu szybko rozeszła się po całej okolicy ");
INSERT INTO polsz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","i zastanawiano się: —Kim będzie to dziecko? Widać, że Bóg naprawdę nad nim czuwa. ");
INSERT INTO polsz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wielbiąc Boga, Zachariasz został napełniony Duchem Świętym i zaczął prorokować: ");
INSERT INTO polsz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Chwała Panu, Bogu Izraela! Przyszedł bowiem, aby uratować swój lud. ");
INSERT INTO polsz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Tak, jak niegdyś obiecał przez swoich świętych proroków, posłał potężnego Zbawiciela z rodu króla Dawida, swojego sługi. ");
INSERT INTO polsz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","On nas wybawi z rąk naszych wrogów i tych, którzy nas nienawidzą. ");
INSERT INTO polsz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bóg zmiłował się nad naszymi przodkami, pamiętając o swoim świętym przymierzu. ");
INSERT INTO polsz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","I dotrzymał przysięgi, którą złożył Abrahamowi, naszemu przodkowi, ");
INSERT INTO polsz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","że uwolni nas od wrogów i pozwoli, abyśmy bez lęku, w świętości i prawości, mogli służyć Mu aż do końca naszych dni. ");
INSERT INTO polsz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A ty, synku, zostaniesz prorokiem Najwyższego. Pójdziesz przed Panem i przygotujesz Mu drogę. ");
INSERT INTO polsz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","I pokażesz ludziom Boże zbawienie, dokonujące się przez odpuszczenie grzechów, ");
INSERT INTO polsz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","dzięki łasce naszego Boga. Ona to zabłyśnie jak niebiańska światłość, ");
INSERT INTO polsz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","i oświeci pogrążonych w ciemności i mroku śmierci. Ona też wprowadzi nas na drogę pokoju! ");
INSERT INTO polsz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Czas upływał, a chłopiec rozwijał się i wzmacniał duchowo. Gdy dorósł, zamieszkał samotnie na pustyni i przebywał tam aż do chwili rozpoczęcia swojej publicznej działalności w Izraelu. ");
INSERT INTO polsz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tymczasem August, rzymski cezar, wydał dekret o powszechnym spisie ludności w swoim państwie. ");
INSERT INTO polsz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Był to pierwszy taki spis od chwili, gdy Kwiryniusz został gubernatorem Syrii. ");
INSERT INTO polsz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wszyscy udawali się więc do swoich rodzinnych miejscowości, aby dać się tam zapisać. ");
INSERT INTO polsz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Józef musiał wyruszyć z Nazaretu w Galilei do Betlejem w Judei, rodzinnego miasta króla Dawida. Pochodził bowiem z jego rodu. ");
INSERT INTO polsz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Wybrał się więc w drogę wraz z Marią, swoją narzeczoną, która była już w zaawansowanej ciąży. ");
INSERT INTO polsz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Gdy tam dotarli, nadszedł czas porodu ");
INSERT INTO polsz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","i Maria urodziła swojego pierwszego Syna. Owinęła Go w pieluszki i położyła w stajennym żłobie, gdyż nie było już dla nich miejsca w tamtejszym zajeździe. ");
INSERT INTO polsz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tej właśnie nocy, na pobliskich łąkach pasterze pilnowali owiec. ");
INSERT INTO polsz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nagle stanął pośród nich anioł, a wokół zajaśniała chwała Pana. Bardzo się przestraszyli, ");
INSERT INTO polsz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","lecz anioł rzekł: —Nie bójcie się! Przynoszę wam radosną nowinę, która dotyczy wszystkich ludzi. ");
INSERT INTO polsz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dzisiaj w Betlejem narodził się Zbawiciel, długo oczekiwany Mesjasz i Pan! ");
INSERT INTO polsz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Oto jak Go rozpoznacie: Ujrzycie Niemowlę owinięte w pieluszki, leżące w żłobie. ");
INSERT INTO polsz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","W tym momencie pojawiło się całe mnóstwo aniołów, którzy wielbili Boga: ");
INSERT INTO polsz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Chwała Bogu w niebie, a na ziemi pokój tym, których On kocha! ");
INSERT INTO polsz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Gdy aniołowie powrócili do nieba, pasterze powiedzieli: —Chodźmy do Betlejem i zobaczmy ten cud, o którym usłyszeliśmy. ");
INSERT INTO polsz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pobiegli do miasteczka i odnaleźli Marię z Józefem. Zobaczyli też leżące w żłobie Niemowlę. ");
INSERT INTO polsz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","A wszystkim napotkanym ludziom opowiadali o tym, co przeżyli i co anioł mówił o Dziecku. ");
INSERT INTO polsz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Słuchający ich nie mogli wyjść z podziwu, ");
INSERT INTO polsz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","a Maria zachowywała to wszystko w swoim sercu i wiele o tym rozmyślała. ");
INSERT INTO polsz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pasterze zaś powrócili do swoich stad, wielbiąc Boga za to, że usłyszeli i zobaczyli dokładnie to, co im zapowiedział anioł. ");
INSERT INTO polsz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Po ośmiu dniach, podczas ceremonii obrzezania, nadano Dziecku imię Jezus, zgodnie z tym, co nakazał anioł, zanim jeszcze się poczęło. ");
INSERT INTO polsz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Gdy zakończył się okres poporodowego oczyszczenia, ustalony w Prawie Mojżesza, rodzice zanieśli Jezusa do Jerozolimy, aby Go poświęcić Panu. ");
INSERT INTO polsz_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","W Prawie napisano bowiem: „Każdego pierwszego syna poświęcicie Panu”. ");
INSERT INTO polsz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Złożyli też ofiarę oczyszczenia, którą według Prawa mogła być para synogarlic lub dwa młode gołębie. ");
INSERT INTO polsz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A mieszkał wtedy w Jerozolimie niejaki Symeon. Był to człowiek prawy, bardzo pobożny i posłuszny Duchowi Świętemu. Nieustannie oczekiwał nadejścia upragnionego przez Żydów Mesjasza. ");
INSERT INTO polsz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Duch Święty objawił mu, że nie umrze, dopóki Go nie ujrzy. ");
INSERT INTO polsz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tego właśnie dnia Symeon, kierowany przez Ducha, przyszedł do świątyni. Gdy więc rodzice przynieśli Jezusa, by zgodnie z Prawem poświęcić Go Panu, ");
INSERT INTO polsz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","spotkali Symeona. On zaś wziął Dziecko na ręce i uwielbił Boga, mówiąc: ");
INSERT INTO polsz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Teraz, Wszechmocny Panie, mogę spokojnie umrzeć. ");
INSERT INTO polsz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Zobaczyłem bowiem Zbawiciela, ");
INSERT INTO polsz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","którego dałeś wszystkim ludom. ");
INSERT INTO polsz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","On jest światłem dla narodów i chwałą Twojego ludu, Izraela! ");
INSERT INTO polsz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Słysząc te słowa o Jezusie, Józef i Maria zdumieli się. ");
INSERT INTO polsz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Symeon zaś pobłogosławił ich i rzekł do Marii: —Ten Chłopiec stanie się przyczyną kontrowersji w Izraelu: jedni Go odrzucą, ściągając na siebie zgubę, a inni z radością Go przyjmą. ");
INSERT INTO polsz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","W ten sposób wyjdą na jaw najskrytsze ludzkie myśli. Twoją zaś duszę przeniknie miecz cierpienia. ");
INSERT INTO polsz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tego dnia była również w świątyni prorokini Anna, córka Fanuela, z rodu Asera. Została ona wdową po siedmiu latach małżeństwa, ");
INSERT INTO polsz_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","a obecnie miała już osiemdziesiąt cztery lata—była więc w podeszłym wieku. Przez cały czas nie opuszczała jednak świątyni—dniem i nocą służyła bowiem Bogu, modląc się i powstrzymując się od posiłków. ");
INSERT INTO polsz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Gdy spotkała Marię z małym Jezusem, zaczęła wychwalać Boga. Potem zaś wszystkim mieszkańcom Jerozolimy, którzy oczekiwali przyjścia Zbawiciela, mówiła, że Mesjasz już się narodził. ");
INSERT INTO polsz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Po spełnieniu wszystkich wymogów Bożego Prawa, rodzice Jezusa powrócili do rodzinnego Nazaretu w Galilei. ");
INSERT INTO polsz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Z upływem czasu Chłopiec dorastał, nabierał sił i stawał się coraz mądrzejszy, a Bóg nieustannie mu błogosławił. ");
INSERT INTO polsz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jego rodzice każdego roku udawali się do Jerozolimy na święto Paschy. ");
INSERT INTO polsz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Gdy Jezus ukończył dwanaście lat, zabrali Go ze sobą. ");
INSERT INTO polsz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Po skończonych uroczystościach wszyscy udali się w drogę powrotną, ale Jezus został w Jerozolimie. Początkowo rodzice tego nie zauważyli. ");
INSERT INTO polsz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Szukali Go wśród krewnych i przyjaciół, bo sądzili, że idzie gdzieś w tłumie. ");
INSERT INTO polsz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Gdy Go nie znaleźli, wrócili do Jerozolimy, by tam kontynuować poszukiwania. ");
INSERT INTO polsz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dopiero po trzech dniach odnaleźli Jezusa. Siedział w świątyni, w gronie nauczycieli Prawa Mojżesza. Słuchał ich i zadawał im pytania, ");
INSERT INTO polsz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","a wszystkich obecnych zadziwiał swoimi wypowiedziami i mądrością. ");
INSERT INTO polsz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Rodzice byli zaskoczeni tym widokiem. —Synu—powiedziała matka—dlaczego tak postąpiłeś? Szukaliśmy Cię z ojcem i bardzo się niepokoiliśmy. ");
INSERT INTO polsz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","—Dlaczego Mnie szukaliście?—zapytał. —Nie wiedzieliście, że powinienem zajmować się sprawami mojego Ojca? ");
INSERT INTO polsz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ale oni nie zrozumieli, co chciał przez to powiedzieć. ");
INSERT INTO polsz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wrócił razem z nimi do Nazaretu i był im posłuszny, a Jego matka wszystko to zachowywała w swoim sercu. ");
INSERT INTO polsz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jezus zaś rósł i nabierał mądrości, ciesząc się przychylnością Boga i ludzi. ");
INSERT INTO polsz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Był piętnasty rok rządów Tyberiusza, rzymskiego cezara. W tym czasie gubernatorem prowincji Judei był Piłat, zarządcą Galilei—Herod Antypas, zarządcą Iturei i Trachonu—jego brat Filip, a zarządcą Abileny—Lizaniasz. ");
INSERT INTO polsz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Urząd najwyższego kapłana Izraela sprawowali Annasz i Kajfasz. Wtedy właśnie Jan, syn Zachariasza, mieszkający dotąd na pustyni, otrzymał od Boga misję. ");
INSERT INTO polsz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wędrując brzegiem Jordanu, wzywał ludzi do opamiętania się i przyjęcia Bożego przebaczenia. Swoją przemianę mieli poświadczyć zanurzeniem w wodzie. ");
INSERT INTO polsz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","To właśnie o nim mówił prorok Izajasz: „Głos wołającego na pustyni: Przygotujcie Panu drogę, wyrównajcie przed Nim ścieżki! ");
INSERT INTO polsz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Zrównajcie góry, zasypcie doliny, wyprostujcie zakręty, usuńcie wyboje! ");
INSERT INTO polsz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","A wtedy wszyscy zobaczą Boże zbawienie”. ");
INSERT INTO polsz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Całe tłumy przychodziły do Jana, aby dać się zanurzyć, a on mówił do nich: —Przebiegłe węże! Kto wam powiedział, jak uciec przed nadchodzącą karą Boga?! ");
INSERT INTO polsz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Najpierw pokażcie poprzez wasze uczynki, że naprawdę się opamiętaliście! Nie oszukujcie się, powtarzając: „Jesteśmy potomkami samego Abrahama”. Zapewniam was, że Bóg może stworzyć potomków Abrahama nawet z tych kamieni! ");
INSERT INTO polsz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Siekiera Bożego sądu już jest przyłożona do pnia. I każde drzewo, które nie wydaje owocu, zostanie wycięte i rzucone w ogień. ");
INSERT INTO polsz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","—Co więc mamy czynić?—pytały tłumy. ");
INSERT INTO polsz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","—Jeśli masz dwa ubrania, daj jedno biednemu. Jeśli masz co jeść, podziel się z głodnym—odpowiadał Jan. ");
INSERT INTO polsz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A przychodzili do niego nawet znani z nieuczciwości poborcy podatkowi, chcąc przyjąć chrzest. I pytali Go: —Nauczycielu, co mamy czynić? ");
INSERT INTO polsz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—Nie pobierajcie większych podatków niż ustalono—odpowiadał im. ");
INSERT INTO polsz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","—A co z nami?—pytali żołnierze. —Od nikogo nie wymuszajcie pieniędzy. Zadowólcie się swoim żołdem!—odpowiedział. —I nikogo fałszywie nie oskarżajcie. ");
INSERT INTO polsz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ponieważ wszyscy oczekiwali przyjścia Mesjasza, zaczęto się zastanawiać, czy przypadkiem to Jan Nim nie jest. ");
INSERT INTO polsz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","On jednak zaprzeczył temu: —Ja was zanurzam w wodzie. Lecz niebawem nadejdzie ktoś potężniejszy ode mnie. Ktoś, komu nie jestem nawet godzien zdjąć butów! On będzie was zanurzał w Duchu Świętym i w ogniu. ");
INSERT INTO polsz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","On potrafi oddzielić plewy od ziarna i wszystko oczyścić—ziarno zbierze do magazynu, a plewy spali w niegasnącym ogniu. ");
INSERT INTO polsz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jan wiele razy w podobny sposób ostrzegał ludzi i głosił im dobrą nowinę. ");
INSERT INTO polsz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Krytykował natomiast króla Heroda Antypasa za to, że ożenił się z Herodiadą, żoną swojego brata, oraz za inne złe czyny. ");
INSERT INTO polsz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","W późniejszym czasie król jeszcze dalej posunął się w swoim grzechu i uwięził Jana. ");
INSERT INTO polsz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pewnego dnia, gdy Jan zanurzał ludzi w wodzie, znalazł się wśród nich sam Jezus. Gdy został ochrzczony i modlił się, nagle otworzyło się niebo ");
INSERT INTO polsz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","i Duch Święty zstąpił na Niego jak gołąb. A z nieba rozległ się głos: —Jesteś moim ukochanym Synem, moją największą radością. ");
INSERT INTO polsz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Gdy Jezus rozpoczynał swoją publiczną działalność, miał około trzydziestu lat. Uważano Go za syna Józefa. Ojcem zaś Józefa był Heli, a ojcem Helego ");
INSERT INTO polsz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","—Mattat. Kolejni ich przodkowie to: Lewi, Melchi, Jannaj, Józef, ");
INSERT INTO polsz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatiasz, Amos, Nahum, Chesli, Naggaj, ");
INSERT INTO polsz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maat, Matatiasz, Semea, Josech, Joda, ");
INSERT INTO polsz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jan, Resa, Zorobabel, Salatiel, Neri, ");
INSERT INTO polsz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melchi, Addi, Kosam, Elmadan, Her, ");
INSERT INTO polsz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Jezus, Eliezer, Jorim, Mattat, Lewi, ");
INSERT INTO polsz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Symeon, Juda, Józef, Jonam, Eliakim, ");
INSERT INTO polsz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meleasz, Menna, Mattat, Natan, król Dawid, ");
INSERT INTO polsz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesse, Jobed, Booz, Sala, Naasson, ");
INSERT INTO polsz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadab, Admin, Arni, Ezrom, Fares, Juda, ");
INSERT INTO polsz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jakub, Izaak, Abraham, Tare, Nachor, ");
INSERT INTO polsz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruch, Ragau, Falek, Eber, Sala, ");
INSERT INTO polsz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kainam, Arfaksad, Sem, Noe, Lamech, ");
INSERT INTO polsz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matusala, Henoch, Jaret, Maleleel, Kainam, ");
INSERT INTO polsz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos, Set i Adam. Adam zaś pochodził od Boga. ");
INSERT INTO polsz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Po chrzcie, napełniony Duchem Świętym, Jezus opuścił okolice Jordanu. Duch poprowadził Go na pustynię, gdzie przebywał przez czterdzieści dni. Tam też kusił Go diabeł. ");
INSERT INTO polsz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Przez cały ten czas nic nie jadł, aż w końcu poczuł głód. ");
INSERT INTO polsz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Wtedy diabeł powiedział do Niego: —Jeśli rzeczywiście jesteś Synem Bożym, rozkaż temu kamieniowi, aby zamienił się w chleb. ");
INSERT INTO polsz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","—Pismo uczy: „Nie tylko chlebem żywi się człowiek”—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Następnie diabeł wziął Go na górę, skąd w mgnieniu oka pokazał Mu wszystkie królestwa świata ");
INSERT INTO polsz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","i zaproponował: —Dam Ci te wszystkie potężne królestwa świata z całym ich przepychem. Do mnie należą i mogę je dać, komu tylko zechcę. ");
INSERT INTO polsz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jeśli oddasz mi pokłon, wszystko będzie Twoje. ");
INSERT INTO polsz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","—Pismo uczy: „Pokłon i cześć oddawał będziesz Bogu, swojemu Panu, i tylko Jemu będziesz posłuszny”—odrzekł na to Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","W końcu diabeł przeniósł Go do Jerozolimy i postawił na szczycie świątyni. —Jeśli rzeczywiście jesteś Synem Bożym, skocz w dół—kusił. ");
INSERT INTO polsz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","—Przecież Pismo mówi: „Bóg rozkaże swoim aniołom, aby chroniły Cię. ");
INSERT INTO polsz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","I będą Cię nosić na rękach, abyś nie skaleczył nogi o kamień”. ");
INSERT INTO polsz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","—To samo Pismo uczy: „Nie będziesz wystawiał Boga na próbę”—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Diabeł widząc, że nic nie wskóra, na jakiś czas pozostawił Jezusa w spokoju. ");
INSERT INTO polsz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jezus, pełen mocy Ducha Świętego, powrócił do Galilei. ");
INSERT INTO polsz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Dzięki swoim wystąpieniom w synagogach stał się wkrótce znany w całej okolicy i wszyscy ludzie chwalili Go. ");
INSERT INTO polsz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Gdy przybył do rodzinnego Nazaretu, jak zwykle w szabat udał się do synagogi. Podczas nabożeństwa wstał, aby przeczytać tekst z Pisma. ");
INSERT INTO polsz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Podano Mu księgę proroka Izajasza, a On otworzył ją i przeczytał następujący fragment: ");
INSERT INTO polsz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—„Duch Pana jest ze Mną. On wybrał Mnie, abym przekazał biednym dobrą nowinę. Posłał Mnie, abym ogłosił, że więźniowie odzyskają wolność, niewidomi—wzrok, a zniewoleni będą uwolnieni od tych, którzy ich gnębią. ");
INSERT INTO polsz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mam również obwieścić wszystkim, że nadszedł czas szczególnej łaski od Pana”. ");
INSERT INTO polsz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Potem zamknął księgę, oddał ją słudze i usiadł. A wszyscy obecni w synagodze z napięciem wpatrywali się w Niego. ");
INSERT INTO polsz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wtedy zaczął mówić: —Dziś jesteście świadkami spełnienia się tych słów! ");
INSERT INTO polsz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Słuchający byli pełni uznania, ale dziwili się, że wypowiedział tak niezwykłe słowa. —Jak to możliwe?—zastanawiali się. —Przecież to syn Józefa! ");
INSERT INTO polsz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","On jednak powiedział do nich: —Być może przypomnicie mi przysłowie: „Lekarzu, wylecz najpierw samego siebie”. Powiecie też: „Tyle słyszeliśmy o cudach, których dokonałeś w Kafarnaum. Zrób coś i dla swojego rodzinnego miasta”. ");
INSERT INTO polsz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Posłuchajcie uważnie: Dotychczas żaden prorok nie cieszył się uznaniem w swojej własnej ojczyźnie. ");
INSERT INTO polsz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Chociaż wiele wdów żyło w Izraelu za czasów proroka Eliasza i wszystkie potrzebowały wsparcia w dniach głodu, gdy przez trzy i pół roku nie spadła ani jedna kropla deszczu, ");
INSERT INTO polsz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","to Eliasz nie został posłany do żadnej z nich. Uczynił natomiast cud, aby pomóc obcej wdowie z Sarepty w Sydonie. ");
INSERT INTO polsz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","W podobnej sytuacji był prorok Elizeusz, który uzdrowił Syryjczyka—Naamana, choć w Izraelu wielu trędowatych również potrzebowało pomocy. ");
INSERT INTO polsz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na te słowa wszyscy siedzący w synagodze wpadli w szał. ");
INSERT INTO polsz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Zerwali się z miejsc, chwycili Jezusa i zaciągnęli na zbocze skalistego wzgórza z zamiarem strącenia Go w przepaść. ");
INSERT INTO polsz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","On jednak przeszedł przez sam środek zbiegowiska i oddalił się. ");
INSERT INTO polsz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Stamtąd udał do galilejskiego miasteczka Kafarnaum i w szabat zaczął nauczać w synagodze. ");
INSERT INTO polsz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Słuchający Go byli pełni zdumienia, bo Jezus przemawiał jak ktoś, kto ma władzę nad ludźmi. ");
INSERT INTO polsz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nagle jakiś człowiek, opanowany przez demona, zaczął wykrzykiwać: ");
INSERT INTO polsz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Dlaczego nas niepokoisz, Jezusie z Nazaretu? Czy przyszedłeś nas zniszczyć? Wiem, kim jesteś! Świętym Synem Boga! ");
INSERT INTO polsz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","—Milcz i wyjdź z tego człowieka!—rozkazał Jezus duchowi. Ten powalił człowieka na ziemię i wyszedł, nie wyrządzając mu jednak żadnej krzywdy. ");
INSERT INTO polsz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Świadkowie tego zdarzenia oniemieli z wrażenia, a następnie komentowali to, co ujrzeli: —W Jego słowach jest niesamowita moc—słuchają Go nawet złe duchy! ");
INSERT INTO polsz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","A wieść o tym wydarzeniu lotem błyskawicy obiegła całą okolicę. ");
INSERT INTO polsz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jezus wyszedł z synagogi i udał się do domu Szymona i Andrzeja. Teściowa Szymona miała akurat wysoką gorączkę. Prosili więc Go, aby ją uzdrowił. ");
INSERT INTO polsz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jezus podszedł do chorej i rozkazał, aby gorączka ją opuściła. Temperatura natychmiast spadła, a teściowa wstała i przygotowała im posiłek. ");
INSERT INTO polsz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wieczorem, już po zachodzie słońca, mieszkańcy miasteczka przyprowadzili do Jezusa wszystkich chorych, jacy tylko się tam znajdowali, a byli wśród nich cierpiący na wiele różnych dolegliwości. On zaś kładł na nich ręce i wszystkich uzdrawiał. ");
INSERT INTO polsz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","A wiele demonów, na rozkaz Jezusa, opuściło swoje ofiary, wołając: —Jesteś Synem Boga! Demony wiedziały bowiem, że jest Mesjaszem. On jednak zakazywał im cokolwiek mówić. ");
INSERT INTO polsz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Następnego dnia, wczesnym rankiem, udał się na pustynię. Ludzie wszędzie Go szukali, a gdy Go znaleźli, prosili, by ich nie opuszczał i pozostał w Kafarnaum. ");
INSERT INTO polsz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","On jednak odpowiedział im: —Także w innych miastach muszę głosić dobrą nowinę o królestwie Bożym, bo po to zostałem posłany. ");
INSERT INTO polsz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","I wędrując po całej Judei, przemawiał w synagogach. ");
INSERT INTO polsz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pewnego dnia, gdy nauczał nad jeziorem Genezaret, napierało na Niego mnóstwo ludzi. Wszyscy bowiem bardzo pragnęli słuchać słowa Bożego. ");
INSERT INTO polsz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wtedy spostrzegł przy brzegu dwie łodzie, zostawione przez rybaków, którzy płukali sieci. ");
INSERT INTO polsz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wszedł do jednej z nich i poprosił Szymona, jej właściciela, aby wypchnął ją nieco na wodę. Sam zaś usiadł i przemawiał z niej do tłumów. ");
INSERT INTO polsz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Gdy skończył, zwrócił się do Szymona: —Wypłyń teraz na jezioro i zarzuć sieci. ");
INSERT INTO polsz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","—Panie!—odparł Szymon. —Całą noc ciężko pracowaliśmy i niczego nie złowiliśmy. Skoro jednak Ty tak mówisz, zrobię to. ");
INSERT INTO polsz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Zarzucili więc sieci, ale tym razem były tak pełne, że aż się rwały. ");
INSERT INTO polsz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Zawołali więc na pomoc wspólników z drugiej łodzi. Wkrótce obie łodzie były tak zapełnione rybami, że prawie tonęły. ");
INSERT INTO polsz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Widząc to wszystko, Szymon Piotr upadł przed Jezusem na kolana i prosił: —Panie, odejdź ode mnie, bo jestem zbyt grzeszny, aby z Tobą przebywać. ");
INSERT INTO polsz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mówił tak, bo ilość złapanych ryb wywarła na nim ogromne wrażenie. Zdumienie ogarnęło również innych rybaków, ");
INSERT INTO polsz_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","wśród nich także wspólników Szymona—Jakuba i Jana, synów Zebedeusza. Jezus odpowiedział jednak: —Niczego się nie obawiaj! Odtąd będziesz łowił ludzi! ");
INSERT INTO polsz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Gdy tylko przybili do brzegu, zostawili wszystko i poszli z Jezusem. ");
INSERT INTO polsz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Będąc w pewnym miasteczku, Jezus spotkał człowieka, który od stóp do głów był pokryty trądem. Gdy zobaczył on Jezusa, padł przed Nim na twarz i poprosił: —Panie! Jeśli zechcesz, możesz mnie uzdrowić! ");
INSERT INTO polsz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jezus dotknął go i powiedział: —Chcę. Bądź uzdrowiony! I w jednej chwili trąd zniknął. ");
INSERT INTO polsz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jezus nakazał mu, aby nikomu o tym nie mówił. —Idź i poproś, aby zbadał cię kapłan—dodał. —A na dowód tego, że wyzdrowiałeś, zanieś ofiarę, jaką Mojżesz wyznaczył uleczonemu z trądu. ");
INSERT INTO polsz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jednak wieść o tym rozniosła się bardzo szybko i ogromne tłumy ludzi przychodziły do Jezusa, aby Go słuchać i doznawać uzdrowienia z chorób. ");
INSERT INTO polsz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Dlatego Jezus często usuwał się na pustynię, aby móc się spokojnie modlić. ");
INSERT INTO polsz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pewnego dnia, gdy nauczał, usiedli przy Nim faryzeusze i przywódcy religijni. Przyszli z wielu miejscowości w Galilei i Judei, a także z Jerozolimy. Jezus mocą Boga uzdrawiał właśnie wielu ludzi. ");
INSERT INTO polsz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","W pewnej chwili, jacyś mężczyźni przynieśli na noszach sparaliżowanego, ale bezskutecznie próbowali przecisnąć się przez tłum, by dotrzeć do Jezusa. ");
INSERT INTO polsz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Weszli więc na tarasowy dach, rozebrali jego fragment i spuścili nosze z chorym w dół, tuż przed Jezusa. ");
INSERT INTO polsz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Widząc ich wiarę, Jezus rzekł do chorego: —Przyjacielu, odpuszczam ci grzechy! ");
INSERT INTO polsz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Siedzący tam faryzeusze i przywódcy religijni pomyśleli z oburzeniem: „Za kogo on się uważa?! To jawne bluźnierstwo! Przecież tylko Bóg może odpuszczać grzechy”. ");
INSERT INTO polsz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jezus, znając ich myśli, odpowiedział: —Dlaczego was to oburza? ");
INSERT INTO polsz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Co jest łatwiej powiedzieć: „Odpuszczam ci grzechy” czy „Wstań i chodź!”? ");
INSERT INTO polsz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Udowodnię wam jednak, że Ja, Syn Człowieczy, mogę odpuszczać grzechy. I zwrócił się do sparaliżowanego: —Jesteś uzdrowiony! Zabierz swoje nosze i idź do domu! ");
INSERT INTO polsz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","A chory, na oczach wszystkich, wstał, wziął nosze i odszedł do domu, wielbiąc Boga. ");
INSERT INTO polsz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wszyscy byli poruszeni tym do głębi i przerażeni. Wielbili Boga, mówiąc: —Dziś zobaczyliśmy coś niezwykłego! ");
INSERT INTO polsz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Idąc drogą, Jezus spotkał Lewiego, poborcę podatkowego, który właśnie tam pracował. —Chodź ze Mną!—zwrócił się do niego. ");
INSERT INTO polsz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A on natychmiast wstał, zostawił wszystko i poszedł z Jezusem. ");
INSERT INTO polsz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Wkrótce potem wydał na Jego cześć przyjęcie i wokół stołu zebrało się wielu znanych z nieuczciwości poborców podatkowych, jego znajomych. ");
INSERT INTO polsz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Oburzeni tym, faryzeusze i przywódcy religijni czynili wyrzuty uczniom Jezusa, mówiąc: —Dlaczego zadajecie się z takimi ludźmi? ");
INSERT INTO polsz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","—To chorzy potrzebują lekarza, a nie zdrowi!—odpowiedział im Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","—Nie przyszedłem wzywać do opamiętania tych, którzy uważają się za dobrych, ale właśnie grzeszników. ");
INSERT INTO polsz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wtedy zmienili temat i powiedzieli: —Uczniowie Jana Chrzciciela i uczniowie faryzeuszy, stosując się do religijnych zaleceń, często modlą się i powstrzymują od posiłków. Twoi zaś tylko jedzą i piją! ");
INSERT INTO polsz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","—Czy można wymagać, aby goście na weselu, będąc z panem młodym, nie spożywali potraw?—zapytał Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","—Nadejdzie jednak czas, gdy zabiorą im pana młodego. Wtedy będą pościć. ");
INSERT INTO polsz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Następnie posłużył się taką przypowieścią: —Nikt nie drze nowego ubrania, aby zrobić z niego łatę do starego. W ten sposób przecież zniszczyłby nowe ubranie, a do starego łata i tak by nie pasowała. ");
INSERT INTO polsz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nikt też nie wlewa świeżego wina do starych, stwardniałych bukłaków. Mogłyby przecież popękać, a wtedy i wino by się rozlało, i bukłaki zniszczyły. ");
INSERT INTO polsz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Świeże wino wlewa się do nowych, miękkich bukłaków. ");
INSERT INTO polsz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ktoś, kto spróbował starego wina, nie ma już ochoty na młode. Mówi bowiem: „Nie ma to jak stare, dobre wino”. ");
INSERT INTO polsz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pewnego razu uczniowie, idąc z Jezusem przez pole, zaczęli zrywać kłosy, rozcierać je w dłoniach i jeść ziarno. A był to akurat święty dzień szabatu. Widząc to, przywódcy religijni zwrócili się do nich z zarzutem: ");
INSERT INTO polsz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","—Dlaczego robicie rzeczy niedozwolone w szabat? ");
INSERT INTO polsz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","—Czy nie czytaliście, co zrobił król Dawid, gdy wraz z towarzyszami podróży poczuł głód?—odpowiedział im Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","—Wszedł do świątyni i wziął dla siebie oraz swoich towarzyszy poświęcony chleb, który wolno było jeść tylko kapłanom. ");
INSERT INTO polsz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wiedzcie, że Ja, Syn Człowieczy, mam władzę nad szabatem. ");
INSERT INTO polsz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Innym razem, również w szabat, udał się do synagogi i nauczał. Zauważył tam człowieka ze sparaliżowaną ręką. ");
INSERT INTO polsz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","A przywódcy religijni i faryzeusze uważnie obserwowali Jezusa, chcąc oskarżyć Go, gdyby uzdrowił tego człowieka. ");
INSERT INTO polsz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jezus jednak dokładnie znał ich myśli. Dlatego zawołał go, a gdy ten podszedł, postawił go przed zebranymi. ");
INSERT INTO polsz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Następnie zwrócił się do swoich wrogów: —Chciałbym was o coś zapytać. Czy czynienie dobra w szabat jest przestępstwem? A może lepiej w tym dniu wyrządzać innym krzywdę? Czy w takim dniu należy ratować życie, czy raczej je niszczyć? ");
INSERT INTO polsz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Następnie spojrzał na nich, a potem rzekł do chorego: —Wyciągnij rękę! Ten posłuchał i natychmiast jego ręka stała się zdrowa. ");
INSERT INTO polsz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Widząc to, wrogowie Jezusa pobledli ze złości, po czym zaczęli się naradzać, jakby Mu zaszkodzić. ");
INSERT INTO polsz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kilka dni później, Jezus udał się na wzgórze i przez całą noc modlił się do Boga. ");
INSERT INTO polsz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","O świcie spotkał się ze swoimi uczniami i wybrał spośród nich dwunastu, których nazwał apostołami. ");
INSERT INTO polsz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Oto ich imiona: Szymon, któremu Jezus nadał imię Piotr, Andrzej—jego brat, Jakub, Jan, Filip, Bartłomiej, ");
INSERT INTO polsz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateusz, Tomasz, Jakub—syn Alfeusza, Szymon Gorliwy, Juda—syn Jakuba ");
INSERT INTO polsz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","i Judasz z Kariotu—ten, który później stał się zdrajcą. ");
INSERT INTO polsz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Gdy zeszli ze wzgórza, zatrzymali się na rozległej równinie, gdzie otoczyło ich liczne grono pozostałych uczniów oraz nieprzebrane tłumy ludzi. Z całej Judei, z Jerozolimy, a nawet z nadmorskich okolic Tyru i Sydonu przybywali bowiem ludzie, ");
INSERT INTO polsz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","żeby słuchać Jezusa i dostąpić uzdrowienia. Ci zaś, którzy byli dręczeni przez złe duchy, odzyskiwali spokój. ");
INSERT INTO polsz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Każdy z obecnych usiłował Go dotknąć, bo swoją mocą przywracał wszystkim zdrowie. ");
INSERT INTO polsz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Wtedy Jezus spojrzał na uczniów i powiedział: —Szczęśliwi jesteście wy, ubodzy, bo do was należy królestwo Boże! ");
INSERT INTO polsz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Szczęśliwi jesteście wy, którzy teraz cierpicie głód, bo zostaniecie nasyceni. Szczęśliwi jesteście wy, którzy teraz płaczecie, bo nadejdzie czas, gdy będziecie się radować. ");
INSERT INTO polsz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Szczęśliwi jesteście, gdy ludzie was nienawidzą, gdy odsuwają się od was i znieważają was, oraz gdy oczerniają was z Mojego powodu. ");
INSERT INTO polsz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Cieszcie się wtedy i skaczcie z radości, bo w niebie czeka was wspaniała nagroda. W taki sam sposób prześladowano bowiem kiedyś proroków Boga! ");
INSERT INTO polsz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lecz marny wasz los, bogacze, bo cała wasza radość jest tylko tu, na ziemi. ");
INSERT INTO polsz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Marny wasz los, wy, którzy teraz żyjecie w dostatku, bo będziecie jeszcze cierpieć głód. Marny wasz los, wy, którzy teraz beztrosko się śmiejecie, bo nadejdzie czas, gdy gorzko zapłaczecie. ");
INSERT INTO polsz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Marny wasz los, wy, którzy jesteście przez wszystkich chwaleni. Tak samo bowiem w przeszłości traktowano fałszywych proroków. ");
INSERT INTO polsz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mówię wam: Okazujcie miłość swoim wrogom i czyńcie dobro tym, którzy was nienawidzą. ");
INSERT INTO polsz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Dobrze mówcie o tych, którzy was przeklinają, i módlcie się o tych, którzy was krzywdzą. ");
INSERT INTO polsz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jeśli ktoś cię obrazi, uderzając w policzek, nadstaw mu drugi. A jeśli zabiera twój płaszcz, oddaj mu również koszulę. ");
INSERT INTO polsz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Daj temu, kto cię o coś prosi, a jeśli ktoś ci coś zabierze, nie żądaj zwrotu. ");
INSERT INTO polsz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Czyńcie innym to, czego sami od nich oczekujecie. ");
INSERT INTO polsz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Czy sądzicie, że zasługujecie na uznanie, bo kochacie ludzi, którzy was kochają? Tak przecież postępują nawet grzesznicy! ");
INSERT INTO polsz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Cóż w tym nadzwyczajnego, że wyświadczacie dobro tym, którzy tak samo postępują w stosunku do was? Na to stać nawet grzeszników. ");
INSERT INTO polsz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jeśli pożyczacie pieniądze tylko tym, od których spodziewacie się zwrotu, jakiego możecie oczekiwać uznania? Nawet najgorsi grzesznicy pożyczają sobie pieniądze i chcą dostać z powrotem tyle samo. ");
INSERT INTO polsz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Wy zaś czyńcie coś więcej: Kochajcie nawet swoich wrogów. Wyświadczajcie im dobro i pożyczajcie im, nie oczekując w zamian niczego. Wasza nagroda w niebie będzie wtedy wielka i będziecie zachowywać się tak, jak przystoi dzieciom Boga. On przecież jest dobry również dla ludzi niewdzięcznych i złych! ");
INSERT INTO polsz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bądźcie miłosierni, tak jak wasz Ojciec w niebie. ");
INSERT INTO polsz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nie krytykujcie ani nie potępiajcie innych, to i sami tego nie doświadczycie. Bądźcie wyrozumiali, a i wam Bóg okaże wyrozumiałość. ");
INSERT INTO polsz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Hojnie dawajcie, a dużo otrzymacie. Dar wasz powróci do was i będzie bardzo obfity. Jaką miarą sami mierzycie, taką odmierzą i wam. ");
INSERT INTO polsz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Następnie przedstawił im kilka przypowieści na ten temat: —Ślepy nie może prowadzić ślepego, bo obaj wpadną w dół. ");
INSERT INTO polsz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Uczeń nie przewyższa nauczyciela. Dopiero z czasem stanie się jak on. ");
INSERT INTO polsz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Dlaczego zwracasz uwagę na rzęsę w czyimś oku—kontynuował Jezus—jeśli w twoim własnym tkwi cała belka? ");
INSERT INTO polsz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Jak możesz powiedzieć: „Przyjacielu, pozwól, że wyciągnę ci rzęsę”, podczas gdy sam nie widzisz belki tkwiącej w twoim własnym oku? Obłudniku! Usuń najpierw belkę ze swojego oka, a wtedy przejrzysz i pomożesz mu wyjąć rzęsę z jego oka. ");
INSERT INTO polsz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Szlachetne drzewo nie rodzi gorzkich owoców, a owoce dzikiego drzewa nie są smaczne. ");
INSERT INTO polsz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Każde drzewo łatwo rozpoznać po jego owocach. Fig nie zbiera się z dzikich krzewów, a winogron—z krzaku jeżyn. ");
INSERT INTO polsz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Podobnie jest z ludźmi—prawy człowiek postępuje szlachetnie, bo jego słowa i czyny wypływają z dobrego serca. Natomiast postępowanie i wypowiedzi człowieka złego obnażają jego gorzkie wnętrze. Z ust wypływa bowiem to, co się kryje w ludzkim sercu. ");
INSERT INTO polsz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Dlaczego nazywacie Mnie swoim Panem, skoro nie jesteście posłuszni temu, co mówię? ");
INSERT INTO polsz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Każdego, kto do Mnie przychodzi, słucha Mnie i postępuje według moich słów, można porównać do człowieka, ");
INSERT INTO polsz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","który przygotował głęboki, solidny fundament i na nim postawił swój dom. Gdy nadeszła powódź, nawet wzburzone wody rzeki nie ruszyły go z miejsca, bo był solidnie zbudowany. ");
INSERT INTO polsz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Natomiast ten, kto Mnie słucha, ale nie postępuje według tego, co słyszy, podobny jest do człowieka, który zbudował swój dom bezpośrednio na piasku—bez fundamentów. Gdy wylała rzeka, dom zawalił się—a była to wielka katastrofa. ");
INSERT INTO polsz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Gdy Jezus skończył nauczać lud, powrócił do Kafarnaum. ");
INSERT INTO polsz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Właśnie wtedy ulubiony sługa pewnego rzymskiego dowódcy poważnie zachorował i był bliski śmierci. ");
INSERT INTO polsz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Gdy dowódca usłyszał o Jezusie, wysłał do Niego kilku przedstawicieli żydowskiej starszyzny z prośbą, aby zechciał przyjść i uzdrowić chorego. ");
INSERT INTO polsz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Spotkawszy Jezusa, gorąco prosili: —Pomóż mu, bo zasługuje na to. ");
INSERT INTO polsz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Bardzo szanuje nasz naród i nawet własnym kosztem wybudował nam synagogę! ");
INSERT INTO polsz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jezus wyruszył z nimi w drogę, ale zanim zdołał dotrzeć do domu, dowódca wysłał swoich przyjaciół ze słowami: ");
INSERT INTO polsz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","—Panie, nie zadawaj sobie trudu, bo nie jestem godny przyjmować Ciebie w moim domu. Właśnie dlatego sam nie wyszedłem Ci na spotkanie. Wystarczy, że powiesz jedno słowo, a on wyzdrowieje. ");
INSERT INTO polsz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Wiem to, bo sam podlegam władzy i mam pod sobą żołnierzy. Jeśli powiem któremuś: „Idź!”, on idzie, a jeśli powiem któremuś: „Przyjdź tu!”, przychodzi. I gdy powiem słudze: „Wykonać!”, to wykonuje polecenie. ");
INSERT INTO polsz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Słysząc taką odpowiedź, Jezus zdumiał się. Rzekł więc do tłumu: —Mówię wam: Tak wielkiej wiary nie spotkałem u nikogo w Izraelu! ");
INSERT INTO polsz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Gdy przyjaciele dowódcy wrócili do domu, sługa był już zupełnie zdrowy. ");
INSERT INTO polsz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Następnego dnia Jezus udał się wraz z uczniami do miasteczka Nain. Jak zwykle podążał za nimi wielki tłum ludzi. ");
INSERT INTO polsz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Gdy zbliżyli się do bramy miasta, ujrzeli wychodzący stamtąd orszak żałobny. Za zmarłym chłopcem, jedynakiem, szła jego matka, która była wdową, oraz wielu mieszkańców miasteczka. ");
INSERT INTO polsz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Gdy Jezus zobaczył ją, ogarnięty wielkim współczuciem, rzekł do niej: —Nie płacz! ");
INSERT INTO polsz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Następnie podszedł do trumny i dotknął jej, a niosący ją zatrzymali się. —Chłopcze!—powiedział. —Wstań! ");
INSERT INTO polsz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","I nagle zmarły ożył, usiadł i zaczął rozmawiać, a Jezus powierzył go matce. ");
INSERT INTO polsz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wtedy strach ogarnął wszystkich, którzy to widzieli. Wielbili Boga i mówili: —Wielki prorok pojawił się wśród nas! Bóg zatroszczył się dziś o swój lud! ");
INSERT INTO polsz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wieść o tym cudzie szybko rozeszła się po całej Judei, a nawet poza jej granicami. ");
INSERT INTO polsz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Również uczniowie Jana Chrzciciela opowiedzieli mu o tym. ");
INSERT INTO polsz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","On zaś wysłał do Jezusa dwóch z nich z pytaniem: „Czy to Ty jesteś spodziewanym Mesjaszem, czy też mamy oczekiwać kogoś innego?”. ");
INSERT INTO polsz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Uczniowie ci przybyli do Jezusa i powiedzieli: —Jan przysłał nas do Ciebie z pytaniem: Czy to Ty jesteś spodziewanym Mesjaszem, czy też mamy oczekiwać kogoś innego? ");
INSERT INTO polsz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","A w tym właśnie czasie, Jezus uzdrawiał wielu ludzi z różnych chorób, uwalniał ich od złych duchów, a niewidomym przywracał wzrok. ");
INSERT INTO polsz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","—Wracajcie do Jana—odrzekł—i powiedzcie o tym, co usłyszeliście i zobaczyliście: niewidomi widzą, kalecy chodzą, trędowaci odzyskują zdrowie, głusi słyszą, umarli powracają do życia, ubogim głoszona jest dobra nowina. ");
INSERT INTO polsz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Szczęśliwy jest ten, kto nie straci wiary we Mnie. ");
INSERT INTO polsz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Gdy oni odeszli, Jezus zaczął mówić do tłumu o Janie: —Kogo chcieliście zobaczyć, idąc na pustynię? Kogoś chwiejnego jak trzcina na wietrze? ");
INSERT INTO polsz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kogo przyszliście obejrzeć? Ładnie ubranego człowieka? Ci, którzy dobrze się ubierają i żyją w przepychu, mieszkają w królewskich pałacach, nie na pustyni. ");
INSERT INTO polsz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","A może proroka się spodziewaliście? Zapewniam was, że Jan to nawet ktoś większy niż prorok. ");
INSERT INTO polsz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","To o nim mówi Pismo: „Oto wysyłam przed Tobą mojego posłańca, który przygotuje dla Ciebie drogę”. ");
INSERT INTO polsz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mówię wam: Nie urodził się na ziemi człowiek większy od Jana Chrzciciela. A jednak najmniejszy obywatel królestwa Bożego jest większy od niego! ");
INSERT INTO polsz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wszyscy, którzy słuchali Jana, nawet znani z nieuczciwości poborcy podatkowi, przyznawali, że Boże wymagania są słuszne, i przyjmowali jego chrzest. ");
INSERT INTO polsz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wyjątek stanowili tylko faryzeusze i przywódcy religijni, którzy odrzucili Bożą drogę i nie chcieli, aby Jan zanurzył ich w wodzie. ");
INSERT INTO polsz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jezus kontynuował: —Do kogo można porównać ludzi tego pokolenia? Do kogo są podobni? ");
INSERT INTO polsz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Do bawiących się na placu dzieci, które narzekają na rówieśników: „Graliśmy wam wesołą melodię, a nie tańczyliście. Zagraliśmy smutną, a nie płakaliście”. ");
INSERT INTO polsz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Gdy pojawił się Jan Chrzciciel, nie pił wina i powstrzymywał się od posiłków. Powiedzieli więc: „Jest opanowany przez demona”. ");
INSERT INTO polsz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Gdy Ja, Syn Człowieczy, jem i piję—mówią: „Co za żarłok i pijak, przyjaciel poborców podatkowych i innych grzeszników!”. ");
INSERT INTO polsz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","No cóż, mądrość poznaje się po wypływających z niej czynach. ");
INSERT INTO polsz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jeden z faryzeuszy zaprosił Jezusa do swojego domu na posiłek. Gdy już zasiedli do stołu, ");
INSERT INTO polsz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","pewna kobieta lekkich obyczajów dowiedziała się o miejscu pobytu Jezusa i weszła tam z butelką bardzo drogiego, wonnego olejku. ");
INSERT INTO polsz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Uklękła z płaczem u Jego stóp, a jej łzy kapały na nie. Wtedy własnymi włosami je wytarła, po czym zaczęła całować i namaszczać je olejkiem. ");
INSERT INTO polsz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Widząc to, faryzeusz pomyślał sobie: „Jeśli on nie wie, kim jest ta grzeszna kobieta, która go dotyka, to kiepski z niego prorok”. ");
INSERT INTO polsz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Lecz Jezus, znając jego myśli, rzekł: —Szymonie, chciałbym ci o czymś opowiedzieć. —Dobrze, Nauczycielu, powiedz—odparł Szymon. ");
INSERT INTO polsz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","—Pewien człowiek miał dwóch dłużników: jeden był mu winien równowartość kilku dni pracy, a drugi kilku godzin. ");
INSERT INTO polsz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ponieważ żaden z nich nie był w stanie zwrócić pieniędzy, łaskawie darował im dług. Jak myślisz, który z nich będzie mu bardziej wdzięczny? ");
INSERT INTO polsz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Sądzę, że ten, któremu umorzył większy dług—odpowiedział Szymon. —Masz rację—potwierdził Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wtedy wskazał Szymonowi kobietę i rzekł: —Popatrz na nią. Gdy wszedłem do twojego domu, nie podałeś Mi wody do obmycia stóp z kurzu. Ona zaś obmyła je własnymi łzami i otarła włosami. ");
INSERT INTO polsz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nie przywitałeś Mnie tradycyjnym pocałunkiem, a ona nie przestaje całować moich stóp. ");
INSERT INTO polsz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nie namaściłeś Mi głowy olejkiem, a ona wylała na moje stopy drogie perfumy. ");
INSERT INTO polsz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ponieważ wybaczono jej wiele grzechów, okazała wielką miłość. Ten zaś, komu mało się wybacza, okazuje niewielką miłość. ");
INSERT INTO polsz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Do kobiety zaś rzekł: —Odpuszczam ci grzechy. ");
INSERT INTO polsz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Zaproszeni goście zaczęli wtedy mówić między sobą: —Za kogo on się uważa, że innym odpuszcza grzechy? ");
INSERT INTO polsz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jezus natomiast powiedział kobiecie: —Uwierzyłaś, więc zostałaś ocalona. Odejdź w pokoju. ");
INSERT INTO polsz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Po pewnym czasie Jezus wraz z Dwunastoma udał się w dalszą drogę. Odwiedzał okoliczne miasta i wioski, wszędzie głosząc nadejście królestwa Bożego. ");
INSERT INTO polsz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Towarzyszyły Mu również kobiety, które uzdrowił i uwolnił od złych duchów. Wśród nich były: Maria z Magdali, którą uwolnił aż od siedmiu złych duchów, ");
INSERT INTO polsz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joanna, żona Chuzy, zarządcy w pałacu Heroda Antypasa, Zuzanna i wiele innych. Wędrowały one z Jezusem i Jego uczniami i służyły im pomocą. ");
INSERT INTO polsz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pewnego dnia, gdy zgromadzony wokół Jezusa tłum nadal się powiększał, a z okolicznych miasteczek ciągle jeszcze napływali nowi ludzie, On opowiedział im następującą przypowieść: ");
INSERT INTO polsz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Pewien rolnik postanowił zasiać ziarno. Gdy rozsiewał je na polu, niektóre nasiona upadły na udeptaną ścieżkę, gdzie zostały zdeptane i wydziobane przez ptaki. ");
INSERT INTO polsz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Inne ziarna upadły na cienką warstwę gleby, pod którą była skała. Zaczęły wprawdzie rosnąć, lecz były pozbawione wilgoci i wkrótce zwiędły. ");
INSERT INTO polsz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Jeszcze inne upadły między chwasty. Wyrosły, ale niebawem zostały przez nie zagłuszone. ");
INSERT INTO polsz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Niektóre jednak trafiły na dobrą glebę. Wyrosły i dały sto ziaren plonu. Kto ma uszy do słuchania, niech słucha uważnie! ");
INSERT INTO polsz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Gdy uczniowie zapytali Go, co oznacza ta przypowieść, ");
INSERT INTO polsz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jezus odpowiedział: —Wam dano zrozumieć tajemnice dotyczące królestwa Bożego, inni zaś poznają je tylko poprzez przypowieści. Będą patrzeć, lecz nie zobaczą, będą słuchać, lecz nie usłyszą. ");
INSERT INTO polsz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Znaczenie tej przypowieści jest następujące: Ziarno oznacza słowo Boże. ");
INSERT INTO polsz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Udeptana ścieżka to ci, którzy słyszą słowo, ale natychmiast zjawia się przy nich diabeł i wykrada to, co zapadło w sercu. Przez to nie potrafią uwierzyć, dlatego nie dostępują zbawienia. ");
INSERT INTO polsz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ziarno na gruncie skalistym oznacza tych, którzy słuchają i z radością przyjmują słowo. Brak im jednak mocnych korzeni. Są niestali i w czasie próby poddają się. ");
INSERT INTO polsz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ziarnem posianym wśród chwastów są ludzie, którzy słuchają słowa, lecz z czasem zmartwienia, pogoń za bogactwem i przyjemności życia tłumią ich wiarę. Dlatego nie osiągają dojrzałości. ");
INSERT INTO polsz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Dobra gleba natomiast oznacza ludzi o dobrym i szlachetnym sercu. Ci słuchają słowa Bożego, pielęgnują je w sobie i przez wytrwałość przynoszą plon. ");
INSERT INTO polsz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jezus nauczał dalej: —Nikt nie zapala lampy po to, by ją czymś zasłonić lub postawić pod łóżkiem. Przeciwnie, stawia się ją w widocznym miejscu, aby wszystkim świeciła. ");
INSERT INTO polsz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wszystko, co jest teraz ukryte, wyjdzie kiedyś na światło dzienne. ");
INSERT INTO polsz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Dobrze zastanówcie się więc nad tym, co słyszycie! Ten, kto ma, otrzyma jeszcze więcej, a temu, kto nie ma, zostanie odebrane nawet to, co mu się wydaje, że posiada. ");
INSERT INTO polsz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pewnego dnia matka i bracia Jezusa przyszli do Niego, ale nie mogli dostać się do zatłoczonego domu, w którym nauczał. ");
INSERT INTO polsz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ktoś powiedział więc Jezusowi: —Twoja matka i bracia szukają Cię. ");
INSERT INTO polsz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","—Moją matką i moimi braćmi—odpowiedział Jezus—są ci, którzy słuchają słowa Bożego i są mu posłuszni. ");
INSERT INTO polsz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kilka dni później Jezus powiedział uczniom: —Przepłyńmy na drugi brzeg jeziora. Wsiedli więc do łodzi i wypłynęli. ");
INSERT INTO polsz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","W czasie podróży Jezus zdrzemnął się i wtedy zerwała się straszna burza. Wysokie fale zalewały łódź, tak że zaczęła tonąć. ");
INSERT INTO polsz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Uczniowie obudzili Go więc krzycząc: —Mistrzu, Mistrzu! Toniemy! On zaś, gdy się ocknął, wstrzymał wiatr i fale. Sztorm natychmiast ustał i zaległa głęboka cisza. ");
INSERT INTO polsz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Wówczas zwrócił się do uczniów: —Gdzie jest wasza wiara? —Kim On jest—zastanawiali się, przejęci lękiem—że rozkazuje nawet wiatrom i jezioru, a te są Mu posłuszne? ");
INSERT INTO polsz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tak przybyli do krainy Gerazeńczyków, leżącej po drugiej stronie jeziora, naprzeciw Galilei. ");
INSERT INTO polsz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Gdy Jezus schodził na brzeg, podbiegł do Niego człowiek, mieszkaniec pobliskiego miasta, opanowany przez złego ducha. Już od dłuższego czasu chodził nago i nie mieszkał w swoim domu, ale w cmentarnych grobowcach. ");
INSERT INTO polsz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Gdy tylko zobaczył Jezusa, upadł przed Nim na ziemię i głośno krzyknął: —Czego ode mnie chcesz, Jezusie, Synu Najwyższego Boga? Błagam, nie męcz mnie! ");
INSERT INTO polsz_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jezus rozkazał bowiem złemu duchowi wyjść z tego człowieka. Wcześniej mężczyzna ten wiele razy tracił panowanie nad sobą i choć zakuwano jego ręce i nogi w kajdany, pod wpływem tego ducha, rozrywał je i uciekał na pustynię. ");
INSERT INTO polsz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","—Jak ci na imię?—spytał Jezus. —Legion—odparł zły duch, gdyż w człowieka tego weszło wiele duchów. ");
INSERT INTO polsz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Demony błagały Jezusa, aby nie odsyłał ich do otchłani. ");
INSERT INTO polsz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A na pobliskim wzgórzu, nad jeziorem, pasło się właśnie wielkie stado świń. Złe duchy prosiły więc, aby pozwolił im w nie wejść. A gdy Jezus zgodził się, ");
INSERT INTO polsz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","duchy opuściły człowieka i weszły w świnie, po czym całe stado rzuciło się pędem ze stromego zbocza wprost do jeziora i utonęło. ");
INSERT INTO polsz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Widząc to, pasterze stada uciekli do pobliskiego miasta i okolicznych wiosek z wieścią o tym, co się stało. ");
INSERT INTO polsz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ludzie wyszli z domów, aby to zobaczyć, i wkrótce wokół Jezusa zgromadził się spory tłum. A gdy dostrzegli szaleńca, który siedział teraz przy Jezusie—ubrany, spokojny i w pełni władz umysłowych, przestraszyli się. ");
INSERT INTO polsz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Naoczni świadkowie opowiedzieli przybyłym, w jaki sposób został uzdrowiony. ");
INSERT INTO polsz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wówczas tłum Gerazeńczyków zaczął błagać Jezusa, żeby opuścił ich okolicę, ludzie byli bowiem przerażeni. Jezus wszedł więc do łodzi, ");
INSERT INTO polsz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","a wtedy podszedł do Niego uzdrowiony z pytaniem, czy może z Nim pozostać. Jezus jednak odmówił: ");
INSERT INTO polsz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Wracaj do domu—powiedział—i opowiedz innym, co zrobił dla ciebie Bóg. Poszedł więc i opowiadał w mieście o tym, co Jezus dla niego uczynił. ");
INSERT INTO polsz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na przeciwległym brzegu przywitał Jezusa tłum ludzi, którzy od dłuższego czasu czekali na Jego przybycie. ");
INSERT INTO polsz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Był tam także Jair, przełożony miejscowej synagogi. Padł przed Jezusem na twarz i błagał, aby poszedł z nim do domu. ");
INSERT INTO polsz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jego dwunastoletnia córeczka, jedynaczka, była umierająca. Jezus poszedł więc z Jairem, z trudem torując sobie drogę w tłumie. ");
INSERT INTO polsz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wśród ludzi znajdowała się kobieta, która od dwunastu lat cierpiała na krwotok. Wszystkie swoje pieniądze wydała na lekarzy, ale nikt nie był w stanie jej pomóc. ");
INSERT INTO polsz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Przecisnęła się przez tłum i dotknęła z tyłu Jego ubrania. Gdy to zrobiła, natychmiast krwotok ustał. Wtedy Jezus zapytał: ");
INSERT INTO polsz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","—Kto dotknął mojego płaszcza? Nikt się jednak nie przyznawał. Wtedy Piotr wyraził zdziwienie: —Mistrzu, przecież mnóstwo ludzi tłoczy się wokół Ciebie. ");
INSERT INTO polsz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ale Jezus powtórzył: —Ktoś dotknął Mnie świadomie. Wiem, że moja moc kogoś uzdrowiła. ");
INSERT INTO polsz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wówczas kobieta zrozumiała, że nie zdoła niczego ukryć. Drżąc ze strachu, upadła Mu do nóg i przed wszystkimi ludźmi wyjaśniła, dlaczego Go dotknęła. Powiedziała też, że doznała natychmiastowego uzdrowienia. ");
INSERT INTO polsz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","—Córko! Uwierzyłaś, więc odzyskałaś zdrowie. Idź w pokoju! ");
INSERT INTO polsz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","A gdy jeszcze z nią rozmawiał, przybył jakiś posłaniec z domu Jaira z wiadomością, że jego córka umarła i nie ma już po co fatygować Jezusa. ");
INSERT INTO polsz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Lecz On, nie zważając na to, co mówią, rzekł do Jaira: —Uwierz Mi i niczego się nie bój! Dziecko będzie żyło. ");
INSERT INTO polsz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Gdy dotarli do domu Jaira, Jezus nie pozwolił wejść do pokoju dziewczynki nikomu oprócz Piotra, Jakuba, Jana oraz jej rodziców. ");
INSERT INTO polsz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wokół słychać było płacz i zawodzenie. —Przestańcie płakać!—rzekł do nich Jezus. —Ona nie umarła, tylko śpi! ");
INSERT INTO polsz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Słysząc to, wyśmiewali Go, gdyż wszyscy wiedzieli, że dziewczynka jest martwa. ");
INSERT INTO polsz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wtedy Jezus wziął ją za rękę i powiedział: —Dziewczynko, wstań! ");
INSERT INTO polsz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","W tej samej chwili powróciło do niej życie i wstała. —Dajcie jej coś do jedzenia!—powiedział. ");
INSERT INTO polsz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Rodzice oniemieli, a Jezus zabronił im opowiadać o tym wydarzeniu. ");
INSERT INTO polsz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pewnego dnia Jezus zebrał Dwunastu i udzielił im mocy wypędzania demonów i leczenia wszelkich chorób. ");
INSERT INTO polsz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Potem posłał ich, aby głosili nadejście królestwa Bożego i uzdrawiali chorych. ");
INSERT INTO polsz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","—Niczego ze sobą nie bierzcie—mówił im—ani laski podróżnej, ani torby, ani żywności, ani pieniędzy, ani nawet ubrania na zmianę. ");
INSERT INTO polsz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Gdy zatrzymacie się w jakimś miejscu, nie przenoście się z domu do domu, lecz cały czas mieszkajcie w tym samym. ");
INSERT INTO polsz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A jeśli was nie przyjmą, odchodząc strząśnijcie kurz ze swoich stóp. Będzie to oznaczało, że pozostawiacie tych ludzi ich własnemu losowi. ");
INSERT INTO polsz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Poszli więc i odwiedzali wsie, głosząc dobrą nowinę i uzdrawiając chorych. ");
INSERT INTO polsz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tymczasem wieści o cudach dokonywanych przez Jezusa dotarły do Heroda Antypasa. Niepokoił się nimi, ponieważ niektórzy mówili, że to Jan Chrzciciel zmartwychwstał. ");
INSERT INTO polsz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Inni uważali Jezusa za Eliasza, dawnego proroka. A byli też tacy, którzy twierdzili, że to jakiś inny zmartwychwstały prorok. ");
INSERT INTO polsz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","—Przecież Jan został ścięty na mój rozkaz!—mówił Herod. —Kim więc jest człowiek, o którym słyszę te dziwne wieści? Dlatego bardzo chciał Go zobaczyć. ");
INSERT INTO polsz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Gdy apostołowie powrócili, opowiedzieli Jezusowi o wszystkim, czego dokonali. Wtedy On postanowił zabrać ich do Betsaidy w poszukiwaniu jakiegoś ustronnego miejsca. ");
INSERT INTO polsz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tłumy zorientowały się jednak, dokąd poszli, i podążyły za nimi. Jezus życzliwie przyjął tych, którzy przyszli i nauczał ich o królestwie Bożym oraz uzdrawiał cierpiących. ");
INSERT INTO polsz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pod wieczór uczniowie zwrócili się do Niego: —Każ ludziom rozejść się do pobliskich wiosek i osad. Niech sobie kupią coś do jedzenia i poszukają miejsc na nocleg, bo na tym pustkowiu, nic nie znajdą. ");
INSERT INTO polsz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","—Wy dajcie im jeść—rzekł Jezus. —Ale co?!—wykrzyknęli. —Nic nie mamy! Tylko pięć chlebów i dwie ryby! Chyba nie chcesz, żebyśmy im wszystkim kupili coś do jedzenia?! ");
INSERT INTO polsz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Samych mężczyzn było tam bowiem około pięciu tysięcy. Wtedy Jezus polecił uczniom: —Powiedzcie ludziom, aby usiedli w grupach po pięćdziesiąt osób. ");
INSERT INTO polsz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","A gdy uczniowie podzielili tłum na grupy, ");
INSERT INTO polsz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jezus wziął pięć chlebów i dwie ryby, popatrzył w niebo, podziękował za nie Bogu i połamał chleb na kawałki. Następnie podał go uczniom, a oni ludziom. ");
INSERT INTO polsz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","W ten sposób wszyscy najedli się do syta i zebrano jeszcze dwanaście koszy resztek. ");
INSERT INTO polsz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pewnego dnia, gdy Jezus samotnie się modlił, w pobliżu byli tylko Jego uczniowie. Wtedy zapytał ich: —Za kogo ludzie Mnie uważają? ");
INSERT INTO polsz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—Jedni sądzą, że jesteś Janem Chrzcicielem—odrzekli—drudzy, że Eliaszem lub jakimś innym dawnym prorokiem, który powstał z martwych. ");
INSERT INTO polsz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—A wy? Za kogo Mnie uważacie?—zapytał ich wprost. —Jesteś Bożym Mesjaszem—powiedział Piotr. ");
INSERT INTO polsz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","—Nikomu o tym nie mówcie!—przykazał im Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","—Czekają Mnie straszne cierpienia. Zostanę odrzucony przez starszych, najwyższych kapłanów i innych przywódców religijnych. Zabiją Mnie, ale po trzech dniach zmartwychwstanę! ");
INSERT INTO polsz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Potem, już w obecności tłumów, powiedział: —Jeśli ktoś z was chce Mnie naśladować, niech przestanie myśleć wyłącznie o sobie. Niech weźmie swój krzyż i idzie ze Mną. ");
INSERT INTO polsz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jeśli ktoś chce wygrać życie, przegra je. Ale kto przegra życie ze względu na Mnie, naprawdę je wygra. ");
INSERT INTO polsz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Co z tego, że ktoś zdobędzie cały świat, jeśli po drodze zatraci życie? ");
INSERT INTO polsz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kto wstydzi się Mnie i mojej nauki, tego i Ja, Syn Człowieczy, będę się wstydzić, gdy powrócę tu ze świętymi aniołami w blasku swojej chwały oraz otoczony chwałą mojego Ojca. ");
INSERT INTO polsz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Wierzcie Mi! Niektórzy z obecnych tu, jeszcze za swojego życia ujrzą potęgę królestwa Bożego! ");
INSERT INTO polsz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Około ośmiu dni później Jezus zabrał ze sobą Piotra, Jakuba oraz Jana i wszedł na górę, aby się modlić. ");
INSERT INTO polsz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Podczas modlitwy Jego twarz zajaśniała blaskiem, a Jego płaszcz stał się olśniewająco biały. ");
INSERT INTO polsz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Potem zjawili się dwaj mężczyźni i zaczęli z Nim rozmawiać. Byli to Mojżesz i Eliasz. ");
INSERT INTO polsz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Stali tak w aureoli chwały i rozmawiali o Jego śmierci, która miała wkrótce nastąpić w Jerozolimie. ");
INSERT INTO polsz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tymczasem Piotr i jego towarzysze zdrzemnęli się. Po przebudzeniu zobaczyli Jezusa promieniejącego jasnością i chwałą oraz dwóch stojących przy Nim mężczyzn. ");
INSERT INTO polsz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Gdy Mojżesz i Eliasz oddalili się od Jezusa, Piotr, nie wiedząc z wrażenia, co mówi, zaproponował: —Mistrzu, jak dobrze, że tu jesteśmy! Jeśli chcesz, zbuduję trzy szałasy: dla Ciebie, dla Mojżesza i dla Eliasza. ");
INSERT INTO polsz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ale zanim skończył, otoczył ich jasny obłok, a uczniowie przerazili się. ");
INSERT INTO polsz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Z obłoku zaś rozległ się głos: —Oto mój Syn, Wybrany! Słuchajcie Go! ");
INSERT INTO polsz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Gdy głos umilkł, stwierdzili, że poza Jezusem nie ma już nikogo. Przejęci uczniowie milczeli i przez długi czas nikomu nie opowiadali o tym, co widzieli. ");
INSERT INTO polsz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Następnego dnia, gdy zeszli z góry, wyszedł im na spotkanie ogromny tłum ludzi. ");
INSERT INTO polsz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","—Nauczycielu!—odezwał się ktoś z zebranych. —Zechciej spojrzeć na mojego jedynego syna! ");
INSERT INTO polsz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Często napada go zły duch, a wtedy chłopiec przeraźliwie krzyczy i rzuca się na ziemię z pianą na ustach. Rzadko kiedy duch ten daje mu spokój, ciągle go dręczy. ");
INSERT INTO polsz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Prosiłem Twoich uczniów, żeby wypędzili demona, lecz oni nie potrafili. ");
INSERT INTO polsz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","—Czemu jesteście tak przewrotni i wciąż nie wierzycie?—zwrócił się do nich Jezus. —Jak długo jeszcze muszę być z wami, żebyście wreszcie uwierzyli? Jak długo mam was znosić? Przyprowadź tu syna!—dodał do ojca. ");
INSERT INTO polsz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Gdy chłopiec się zbliżał, zły duch znowu rzucił go na ziemię i zaczął nim gwałtownie targać. Wtedy Jezus rozkazał duchowi, żeby opuścił chłopca, i natychmiast chory został uzdrowiony. ");
INSERT INTO polsz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wszystkich zaś ogarnęło ogromne zdumienie na widok takiego działania mocy Bożej. Gdy tłumy wciąż jeszcze były zachwycone tym cudem, Jezus zwrócił się do uczniów: ");
INSERT INTO polsz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Słuchajcie uważnie: Ja, Syn Człowieczy, zostanę wkrótce wydany w ręce ludzi. ");
INSERT INTO polsz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Uczniowie jednak nie rozumieli tego, bo było to na razie przed nimi ukryte, a bali się prosić Go o wyjaśnienie. ");
INSERT INTO polsz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pewnego razu uczniowie posprzeczali się między sobą o to, który z nich będzie najważniejszy. ");
INSERT INTO polsz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Wtedy Jezus, znając ich myśli, zawołał jakieś dziecko, postawił przy sobie ");
INSERT INTO polsz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","i powiedział: —Każdy, kto ze względu na Mnie przyjmie takie małe dziecko, ten przyjmie Mnie. A kto Mnie przyjmie, przyjmie samego Ojca, który Mnie posłał. W oczach Boga wielkim jest ten, kto potrafi stać się najmniej ważny. ");
INSERT INTO polsz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wtedy Jan powiedział: —Mistrzu, spotkaliśmy człowieka, który w Twoim imieniu wypędza demony, i zabroniliśmy mu działać. Nie należy bowiem do naszego grona. ");
INSERT INTO polsz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","—Nie zabraniajcie mu!—odparł Jezus. —Każdy, kto nie jest wam przeciwny, jest waszym sprzymierzeńcem. ");
INSERT INTO polsz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Im bardziej zbliżał się czas odejścia Jezusa do nieba, tym bardziej kierował się On w stronę Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Któregoś dnia wysłał przed sobą uczniów, aby przygotowali Mu nocleg w pewnej samarytańskiej wiosce. ");
INSERT INTO polsz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mieszkańcy odmówili Mu jednak gościny, ponieważ szedł w kierunku Jerozolimy, a oni nie darzyli tego miasta sympatią. ");
INSERT INTO polsz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Gdy Jakub i Jan to usłyszeli, z oburzeniem zwrócili się do Jezusa: —Mistrzu! Czy chcesz, abyśmy sprowadzili ogień z nieba i spalili tę wioskę? ");
INSERT INTO polsz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Lecz Jezus surowo ich za to upomniał. ");
INSERT INTO polsz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Potem udali się do innej miejscowości. ");
INSERT INTO polsz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Podczas drogi ktoś powiedział do Jezusa: —Pójdę z Tobą, dokądkolwiek się udasz! ");
INSERT INTO polsz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","—Lisy mają nory, a ptaki gniazda—odrzekł mu Jezus—lecz ja, Syn Człowieczy, nie mam własnego kąta, gdzie mógłbym odpocząć. ");
INSERT INTO polsz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Innym razem Jezus sam zwrócił się do pewnego człowieka: —Chodź ze Mną! —Panie—odpowiedział—pozwól mi tylko pójść i pochować zmarłego ojca! ");
INSERT INTO polsz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","—Niech umarli grzebią umarłych—odpowiedział Jezus. —Ty zaś zajmij się głoszeniem królestwa Bożego. ");
INSERT INTO polsz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ktoś inny z wędrujących powiedział: —Panie, pójdę z Tobą, lecz pozwól mi najpierw pożegnać się z rodziną. ");
INSERT INTO polsz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","—Nie można prosto orać, oglądając się ciągle do tyłu—odpowiedział Jezus. —Kto tak czyni, nie nadaje się do pracy w królestwie Bożym. ");
INSERT INTO polsz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Potem Pan wybrał siedemdziesięciu uczniów i wysłał ich po dwóch do miast i wiosek, które zamierzał odwiedzić. ");
INSERT INTO polsz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","—Żniwo jest wielkie—mówił im—a tak mało pracujących! Proście więc gospodarza, aby posłał więcej pracowników na żniwa. ");
INSERT INTO polsz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Idźcie! Posyłam was jak owce między wilki. ");
INSERT INTO polsz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nie bierzcie ze sobą pieniędzy ani torby podróżnej, ani nawet zapasowego obuwia. Wędrując, nie traćcie ani chwili, nawet na tradycyjne przywitanie się z napotkanymi ludźmi. ");
INSERT INTO polsz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gdy odwiedzicie jakiś dom, życzcie wszystkim pokoju. ");
INSERT INTO polsz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jeśli to pobożni ludzie, odpowiedzą wam tym samym. Jeśli nie—pokój pozostanie z wami. ");
INSERT INTO polsz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nie zmieniajcie miejsca pobytu, ale pozostańcie w jednym domu aż do opuszczenia tej miejscowości. Jedzcie tam i pijcie bez skrępowania, gdyż jako robotnicy macie prawo do zapłaty. ");
INSERT INTO polsz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","W jakimkolwiek mieście was przyjmą, korzystajcie z ich gościnności. ");
INSERT INTO polsz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Uzdrawiajcie chorych i mówcie: „Nadchodzi królestwo Boże!”. ");
INSERT INTO polsz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lecz jeśli gdzieś nie zostaniecie przyjęci, stańcie na rynku i powiedzcie: ");
INSERT INTO polsz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","„Nawet kurz waszego miasta strząsamy z naszych stóp. Wiedzcie, że odrzucacie królestwo Boże, które było tak blisko was”. ");
INSERT INTO polsz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mówię wam, że w dniu sądu grzesznym mieszkańcom Sodomy i Gomory będzie lżej niż temu miastu. ");
INSERT INTO polsz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Następnie Jezus dodał: —Marny wasz los, Korozain i Betsaido! Gdyby cuda, których u was dokonałem, wydarzyły się wśród grzesznych mieszkańców Tyru i Sydonu, już dawno by się opamiętali, siedząc w worze pokutnym i popiele. ");
INSERT INTO polsz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Wiedzcie, że w dniu sądu mieszkańcom Tyru i Sydonu będzie łatwiej niż wam! ");
INSERT INTO polsz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A ty, Kafarnaum? Chcesz być wywyższone aż do nieba? Upadniesz aż do piekła! ");
INSERT INTO polsz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Potem powiedział do uczniów: —Kto was słucha, Mnie słucha. A kto się od was odwraca, odrzuca także Mnie, a tym samym Ojca, który Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Po pewnym czasie powróciło siedemdziesięciu uczniów i z radością oznajmiło: —Panie, ze względu na Ciebie nawet złe duchy były nam posłuszne! ");
INSERT INTO polsz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","—Tak, widziałem szatana spadającego z nieba z szybkością błyskawicy!—rzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","—Dałem wam władzę nad wszelką jego mocą, abyście mogli chodzić po wężach i skorpionach, nie doznając żadnej krzywdy. ");
INSERT INTO polsz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nie fascynujcie się jednak tym, że złe duchy są wam posłuszne. Cieszcie się raczej z tego, że wasze imiona wpisane są do księgi obywateli nieba. ");
INSERT INTO polsz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Następnie, napełniony radością Ducha Świętego, Jezus powiedział: —Uwielbiam Cię, Ojcze, Panie nieba i ziemi! Ty ukryłeś swoją prawdę przed mędrcami i znawcami, a objawiłeś ją prostym ludziom. Tego właśnie pragnąłeś! ");
INSERT INTO polsz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","—Ojciec powierzył Mi całą prawdę—wyjaśniał Jezus zebranym. —Nikt nie zna Mnie, Syna, tylko mój Ojciec. I nikt nie zna mojego Ojca, tylko Ja, Syn oraz ten, komu zechcę Go objawić. ");
INSERT INTO polsz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jakiś czas później, gdy byli już sami, rzekł do uczniów: —Bóg was ogromnie wyróżnił, pozwalając wam to wszystko widzieć. ");
INSERT INTO polsz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","W przeszłości wielu proroków i władców pragnęło zobaczyć i usłyszeć to, co wy, ale nie mogli. ");
INSERT INTO polsz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pewien przywódca religijny przyszedł do Jezusa i zadał Mu podchwytliwe pytanie: —Nauczycielu, co mam czynić, aby otrzymać życie wieczne? ");
INSERT INTO polsz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","—Co na ten temat mówi Prawo Mojżesza? Co w nim czytasz?—zapytał Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","—„Kochaj twojego Pana i Boga całym sercem, całą duszą, z całych swoich sił oraz całym umysłem, a bliźnich kochaj tak, jak kochasz samego siebie!”—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—Dobrze powiedziałeś—odrzekł Jezus. —Tak postępuj, a będziesz żył wiecznie! ");
INSERT INTO polsz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","—A kto jest moim bliźnim?—zapytał rozmówca, chcąc się usprawiedliwić. ");
INSERT INTO polsz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Wtedy Jezus opowiedział mu następującą historię: —Pewnego człowieka, idącego z Jerozolimy do Jerycha, napadli bandyci. Zdarli z niego odzież, pobili, okradli i bliskiego śmierci zostawili przy drodze. ");
INSERT INTO polsz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Przypadkiem przechodził tamtędy kapłan. Zauważył biedaka, lecz przeszedł na drugą stronę drogi i ominął go. ");
INSERT INTO polsz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tak samo postąpił lewita, dozorca świątyni—po prostu minął go. ");
INSERT INTO polsz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Przejeżdżał też tamtędy człowiek z pogardzanej przez wszystkich Samarii. Podszedł do rannego, popatrzył i zrobiło mu się go żal. ");
INSERT INTO polsz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Obmył jego rany winem i oliwą, przewiązał je, a potem posadził rannego na swojego osła i przewiózł go do zajazdu, gdzie dalej się nim zajmował. ");
INSERT INTO polsz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Następnego dnia wręczył gospodarzowi sporą sumę pieniędzy i poprosił: „Zaopiekuj się nim, a jeśli wydasz więcej—pokryję to w drodze powrotnej”. ");
INSERT INTO polsz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kończąc opowieść, Jezus zwrócił się do rozmówcy: —Który z tych trzech, twoim zdaniem, okazał się bliźnim napadniętego przez bandytów? ");
INSERT INTO polsz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—Ten, który mu pomógł. —Więc i ty postępuj podobnie—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kontynuując podróż do Jerozolimy, Jezus zatrzymał się w pewnej wiosce. Skorzystał z zaproszenia niejakiej Marty. ");
INSERT INTO polsz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jej siostra, Maria, usiadła u stóp Jezusa i słuchała Go. ");
INSERT INTO polsz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta zaś była bardzo zajęta przygotowaniem posiłku. W końcu podeszła do Niego i zapytała: —Czy nie razi Cię to, Panie, że moja siostra siedzi bezczynnie, podczas gdy ja mam tyle pracy? Powiedz jej, żeby mi pomogła! ");
INSERT INTO polsz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","—Droga Marto, zabiegasz o tak wiele rzeczy—rzekł do niej ");
INSERT INTO polsz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","—a przecież tak naprawdę liczy się tylko jedno. To właśnie wybrała Maria i nie zostanie jej to odebrane. ");
INSERT INTO polsz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pewnego dnia, gdy Jezus skończył modlitwę na osobności, jeden z uczniów poprosił Go: —Panie, naucz nas modlić się, tak jak Jan Chrzciciel nauczył swoich uczniów. ");
INSERT INTO polsz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wtedy Jezus powiedział: —Gdy zwracacie się do Boga, mówcie: „Nasz Ojcze w niebie, niech Twoje święte imię będzie uwielbione i niech nadejdzie Twoje królestwo! ");
INSERT INTO polsz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Zapewnij nam codzienny pokarm ");
INSERT INTO polsz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","i przebacz nasze grzechy, tak jak my przebaczamy tym, którzy zawinili wobec nas. Nie pozwól też, byśmy ulegli pokusie”. ");
INSERT INTO polsz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Następnie dodał: —Załóżmy, że o północy ktoś z was idzie pod dom przyjaciela i woła: „Pożycz mi trochę chleba! ");
INSERT INTO polsz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Właśnie przyjechał do mnie gość, a nie mam czym go poczęstować”. ");
INSERT INTO polsz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Przyjaciel zaś odpowiada z łóżka: „Nie żądaj ode mnie, żebym teraz wstawał. Drzwi są już zamknięte i wszyscy śpimy. Tym razem nie mogę ci pomóc”. ");
INSERT INTO polsz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Zapewniam was, że gdyby nawet nie chciał mu pomóc ze względu na przyjaźń, to ze względu na jego uporczywe prośby w końcu wstanie i da mu tyle chleba, ile potrzebuje. ");
INSERT INTO polsz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Podobnie jest z Bogiem. Proście więc, a dostaniecie; szukajcie, a znajdziecie; pukajcie, a otworzą wam! ");
INSERT INTO polsz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Każdy bowiem, kto prosi—dostaje, kto szuka—znajduje, a temu, kto puka—otwierają. ");
INSERT INTO polsz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Który z was, ojców, dałby swojemu dziecku węża, gdy ono prosi o rybę? ");
INSERT INTO polsz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Albo skorpiona, gdy poprosi o jajko? ");
INSERT INTO polsz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Skoro wy, źli ludzie, dajecie dzieciom to, co dobre, to tym bardziej wasz Ojciec w niebie da Ducha Świętego tym, którzy Go proszą. ");
INSERT INTO polsz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pewnego dnia Jezus uwolnił od złego ducha niemego człowieka, który natychmiast odzyskał mowę. Tłum zaś wpadł w podziw, ");
INSERT INTO polsz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","niektórzy jednak mówili: —Wypędza demony, bo Belzebub, władca demonów, mu w tym pomaga. ");
INSERT INTO polsz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Inni zaś chcieli Go wypróbować i oczekiwali jakiegoś znaku z nieba, od Boga. ");
INSERT INTO polsz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jezus znał ich myśli i odpowiedział: —Każde królestwo, które jest wewnętrznie skłócone, upadnie, a jego domy runą. ");
INSERT INTO polsz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mówicie, że dzięki Belzebubowi uwalniam ludzi od złych duchów. Jeśli jednak szatan zwalcza siebie samego, to jak jego królestwo może przetrwać? ");
INSERT INTO polsz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Skoro ja wypędzam demony mocą Belzebuba, to dzięki komu robią to wasi synowie? To oni was osądzą! ");
INSERT INTO polsz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lecz jeśli wypędzam demony mocą Boga, znaczy to, że przyszło do was królestwo Boże. ");
INSERT INTO polsz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Gdy jakiś uzbrojony siłacz pilnuje swojej własności, jest o nią spokojny. ");
INSERT INTO polsz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Jeśli jednak pokona go ktoś mocniejszy, będzie mógł całkowicie go rozbroić i rozdać innym zdobycz. ");
INSERT INTO polsz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kto nie jest po mojej stronie, jest przeciwko Mnie, a kto ze Mną nie zbiera, ten rozprasza. Potem dodał takie ostrzeżenie: ");
INSERT INTO polsz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","—Gdy demon wyjdzie z człowieka, błąka się po pustkowiach, szukając wytchnienia, ale go tam nie znajduje. Wówczas mówi sobie: „Wrócę do mojego domu, z którego wyszedłem”. ");
INSERT INTO polsz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Przychodzi więc i zastaje swój dawny dom wysprzątany i ozdobiony. ");
INSERT INTO polsz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Przyprowadza więc ze sobą siedem innych demonów, gorszych od siebie, i razem zamieszkują. Wtedy stan takiego człowieka jest o wiele gorszy niż na początku. ");
INSERT INTO polsz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Gdy to mówił, jakaś kobieta z tłumu zawołała: —Szczęśliwa ta, która nosiła cię pod sercem i karmiła własną piersią! ");
INSERT INTO polsz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","—Naprawdę szczęśliwi są ci—odparł Jezus—którzy słuchają słowa Bożego i żyją nim. ");
INSERT INTO polsz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Widząc, że tłum ludzi coraz bardziej się powiększa, powiedział: —To złe pokolenie domaga się cudu. Ale nie zobaczy go, z wyjątkiem znaku proroka Jonasza. ");
INSERT INTO polsz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonasz był znakiem dla mieszkańców Niniwy. Podobnie Ja, Syn Człowieczy, będę Bożym znakiem dla tego pokolenia. ");
INSERT INTO polsz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Królowa Południa powstanie na sądzie i oskarży to pokolenie. Ona przybyła bowiem z końca świata, by słuchać mądrości Salomona. Wy zaś macie przed sobą kogoś większego niż on. ");
INSERT INTO polsz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Również mieszkańcy Niniwy podczas sądu wystąpią z oskarżeniem przeciw temu pokoleniu. Bo oni opamiętali się słuchając Jonasza, a do was mówi ktoś o wiele większy niż on. ");
INSERT INTO polsz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Zapalonej lampy nie stawia się w ukryciu, ale na podwyższeniu, aby świeciła wszystkim, którzy są w domu. ");
INSERT INTO polsz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Oko jest dla ciała jak lampa. Jeśli jest zdrowe, światło napełnia całe ciało. Jeśli jednak jest chore, całe ciało jest pogrążone w ciemnościach. ");
INSERT INTO polsz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Upewnij się więc, że masz w sobie światło, a nie ciemność! ");
INSERT INTO polsz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jeśli rozświetla cię światło i nie masz w sobie żadnych ciemnych zakamarków, całe twoje życie będzie promieniowało niczym jasno świecąca lampa. ");
INSERT INTO polsz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Gdy Jezus skończył mówić, pewien faryzeusz zaprosił Go na obiad. Przybyli do domu, a Jezus od razu zajął swoje miejsce. ");
INSERT INTO polsz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Gospodarz zdziwił się, że przed posiłkiem nie dokonał obrzędu obmycia rąk. ");
INSERT INTO polsz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Wtedy Jezus powiedział mu: —Wy, faryzeusze, dbacie usilnie o zewnętrzną czystość naczyń, ale wasze brudne wnętrze aż się lepi od chciwości i zła. ");
INSERT INTO polsz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nierozumni! Czy Bóg nie stworzył zarówno tego, co na zewnątrz, jak i tego, co w środku? ");
INSERT INTO polsz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","O wewnętrznej czystości najlepiej świadczy zaś szczodrość człowieka. ");
INSERT INTO polsz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Lecz marny wasz los, faryzeusze! Bo chociaż skrupulatnie dajecie Bogu dziesiątą część swoich najdrobniejszych nawet dochodów, to lekceważycie Bożą prawość i miłość. A to jest przecież najważniejsze, choć o dziesięcinie również nie należy zapominać. ");
INSERT INTO polsz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Marny wasz los, bo oczekujecie zaszczytnych miejsc w synagogach oraz wyrazów szacunku ze strony innych ludzi! ");
INSERT INTO polsz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Marny wasz los, bo przypominacie opuszczone, niewidoczne groby! Przechodzący po nich ludzie nie mają nawet pojęcia, że stąpają po rozkładających się szczątkach. ");
INSERT INTO polsz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","—Nauczycielu!—powiedział pewien obecny tam przywódca religijny. —Twoje słowa obrażają również i nas. ");
INSERT INTO polsz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","—Was także czeka marny los!—odpowiedział Jezus. —Wymyślacie bowiem niewykonalne obowiązki i narzucacie je innym, a sami palcem nie kiwniecie, aby im pomóc. ");
INSERT INTO polsz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Marny wasz los, bo stawiacie grobowce prorokom, których kiedyś zamordowali wasi przodkowie! ");
INSERT INTO polsz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pochwalacie ich czyny, upamiętniając je nagrobkami. ");
INSERT INTO polsz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","To o was powiedział Bóg w swojej mądrości: „Wyślę do nich proroków i posłańców, a oni jednych zabiją, a innych będą prześladować”. ");
INSERT INTO polsz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Spadnie na was wina za przelaną krew wszystkich Bożych proroków, zabitych od początku świata, ");
INSERT INTO polsz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","począwszy od Abla, aż po Zachariasza, zgładzonego między ołtarzem a miejscem świętym. Mówię wam: Kara za to wszystko spadnie na głowy tego pokolenia! ");
INSERT INTO polsz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Marny wasz los, przywódcy religijni! Ukryliście bowiem przed ludźmi klucz do bramy Bożej prawdy. Sami nie wchodzicie i innym nie pozwalacie przez nią wejść! ");
INSERT INTO polsz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Gdy Jezus odszedł stamtąd, faryzeusze i przywódcy znienawidzili Go za te słowa. Od tej chwili stawiali Mu wiele podchwytliwych pytań, ");
INSERT INTO polsz_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","by móc Go o coś oskarżyć. ");
INSERT INTO polsz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tymczasem wokół Jezusa gromadziły się coraz większe tłumy—były to już tysiące ludzi, którzy z powodu ścisku aż deptali sobie po nogach. On zaś zwrócił się najpierw do uczniów: —Wystrzegajcie się kwasu faryzeuszy, którym jest ich obłuda! ");
INSERT INTO polsz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nie ma bowiem niczego ukrytego, co ostatecznie nie wyszłoby na jaw. ");
INSERT INTO polsz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Cokolwiek powiedziano pod osłoną nocy, wyjdzie na jaw z nastaniem dnia, a co powiedziano na ucho, zostanie ogłoszone publicznie. ");
INSERT INTO polsz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mówię wam jak przyjaciołom: Nie bójcie się tych, którzy uśmiercają ciało, lecz nie mogą zrobić nic więcej! ");
INSERT INTO polsz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Powiem wam jednak, przed kim macie czuć trwogę: Lękajcie się Boga, który po śmierci może wtrącić człowieka do piekła! Miejcie dla Niego respekt! ");
INSERT INTO polsz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ile kosztuje pięć wróbli? Można je kupić już za kilka drobnych monet. A jednak Bóg nie zapomina o żadnym z nich. ");
INSERT INTO polsz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Przecież On wie nawet, ile macie włosów na głowie! Nie bójcie się więc! Jesteście dla Niego cenniejsi niż całe stado wróbli. ");
INSERT INTO polsz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mówię wam: Jeśli jakiś człowiek wyzna przed innymi ludźmi, że należy do Mnie, to i Ja, Syn Człowieczy, przyznam się do niego w obecności aniołów Bożych. ");
INSERT INTO polsz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lecz jeśli ktoś wyprze się Mnie wobec ludzi, i Ja się go wyprę przed aniołami Boga. ");
INSERT INTO polsz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Jeśli ktoś powiedziałby coś przeciwko Mnie, Synowi Człowieczemu, może otrzymać przebaczenie. Ale jeśli ktoś powiedziałby coś przeciwko Duchowi Świętemu, nie otrzyma przebaczenia. ");
INSERT INTO polsz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Gdy jako moi uczniowie będziecie oskarżeni przed przełożonymi synagog lub przed innymi władzami, nie martwcie się o to, jak się bronić i co macie powiedzieć. ");
INSERT INTO polsz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Duch Święty pomoże wam wtedy znaleźć właściwe słowa. ");
INSERT INTO polsz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tymczasem ktoś z tłumu zawołał: —Nauczycielu! Powiedz mojemu bratu, aby podzielił się ze mną majątkiem, który odziedziczył po ojcu! ");
INSERT INTO polsz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","—Przyjacielu! Kto dał Mi prawo rozstrzygania waszych spraw?—odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","—Potem, zwracając się do wszystkich, dodał: —Wystrzegajcie się wszelkiej chciwości, bo prawdziwe życie nie zależy od rzeczy materialnych! ");
INSERT INTO polsz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Następnie opowiedział im taką przypowieść: —Pewien bogaty człowiek zebrał jednego roku szczególnie obfite plony. ");
INSERT INTO polsz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Zastanawiał się więc: „Co tu robić? Nie mam gdzie tego pomieścić”. ");
INSERT INTO polsz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","W końcu wpadł na pomysł: „Już wiem! Zburzę stare magazyny i zbuduję większe. W nich umieszczę tegoroczne zboże i wszystkie inne zbiory. ");
INSERT INTO polsz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A gdy to zrobię, usiądę i powiem sobie: ‚No, przyjacielu, zgromadziłeś zapasy na wiele lat. Teraz możesz jeść, pić i używać życia’ ”. ");
INSERT INTO polsz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lecz Bóg rzekł do niego: „Głupcze! Umrzesz jeszcze tej nocy. Komu więc to wszystko zostawisz?”. ");
INSERT INTO polsz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Oto przykład głupiego człowieka, który gromadzi majątek na ziemi, a nie jest bogaty przed Bogiem. ");
INSERT INTO polsz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Potem, zwracając się do uczniów, Jezus rzekł: —Nie martwcie się o swoje życie—o to, co będziecie jeść, ani o ciało—w co się ubierzecie. ");
INSERT INTO polsz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Życie to nie tylko pokarm i ubranie. ");
INSERT INTO polsz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Spójrzcie na ptaki: Nie sieją ziarna, nie magazynują zapasów, a Bóg żywi je! Przecież wy jesteście ważniejsi od ptaków! ");
INSERT INTO polsz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Czy ktokolwiek, poprzez zamartwianie się, potrafi przedłużyć swoje życie choćby o jedną chwilę? ");
INSERT INTO polsz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Jeśli więc nie możecie uczynić tak drobnej rzeczy, to jaki jest sens martwić się o większe sprawy? ");
INSERT INTO polsz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Uczcie się od polnych kwiatów: Nie pracują i nie troszczą się o swój ubiór. A zapewniam was, że nawet król Salomon, w całym swoim przepychu, nie był tak pięknie ubrany jak one. ");
INSERT INTO polsz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jeśli więc Bóg tak wspaniale ubiera polne kwiaty, które dzisiaj kwitną, a jutro więdną i idą na spalenie, to czy tym bardziej nie zatroszczy się o was, nieufni?! ");
INSERT INTO polsz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nie martwcie się więc o to, co będziecie jeść i pić. ");
INSERT INTO polsz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","O te sprawy zabiegają poganie. Wasz Ojciec w niebie dobrze wie, że tego potrzebujecie. ");
INSERT INTO polsz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Zabiegajcie więc o Jego królestwo, a wtedy Bóg zatroszczy się o pozostałe rzeczy. ");
INSERT INTO polsz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nie lękajcie się, choć jest was niewielu, bo Ojciec w niebie daje królestwo właśnie wam! ");
INSERT INTO polsz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sprzedajcie to, co posiadacie, i rozdajcie potrzebującym! Wtedy wasze portfele staną się niezniszczalne i wasze bogactwa w niebie będą bezpieczne—nikt się nie włamie, aby je ukraść, i nic ich nie zniszczy. ");
INSERT INTO polsz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gdzie jest wasz skarb, tam będzie wasze serce. ");
INSERT INTO polsz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Bądźcie gotowi na mój powrót i czuwajcie—jak słudzy, będący w gotowości, z lampami w rękach ");
INSERT INTO polsz_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","i oczekujący powrotu swojego pana z uczty weselnej. Gdy przybędzie i zapuka, natychmiast otworzą mu drzwi. ");
INSERT INTO polsz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","A wtedy spotka ich wielki zaszczyt. Zapewniam was: ich pan się przebierze, zaprosi ich do uczty i sam będzie im usługiwał. Bez względu na to, czy przyjdzie o północy, czy nad ranem, wyróżni tych, których zastanie gotowych na jego powrót. ");
INSERT INTO polsz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pomyślcie: Gdyby właściciel domu wiedział, kiedy złodziej przyjdzie go okraść, nie dopuściłby do włamania. ");
INSERT INTO polsz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wy również musicie uważać, bo nie wiecie, kiedy ja, Syn Człowieczy, powrócę! ");
INSERT INTO polsz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","—Panie—zapytał Piotr—czy tę opowieść kierujesz tylko do nas, czy do wszystkich? ");
INSERT INTO polsz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","—A kim jest ten wierny i mądry sługa—powiedział Jezus—któremu Pan powierzył opiekę nad innymi swoimi sługami, aby dbał o nich w czasie jego nieobecności? ");
INSERT INTO polsz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nagrodzi go, gdy po powrocie zobaczy dobrze wykonaną pracę. ");
INSERT INTO polsz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Z pewnością da mu w zarządzanie cały swój majątek. ");
INSERT INTO polsz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Gdyby jednak ten sługa pomyślał sobie: „Nieprędko wróci właściciel, nie muszę się więc go obawiać” i zaczął znęcać się nad powierzonymi sobie ludźmi, zabawiać się i upijać, ");
INSERT INTO polsz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","to jego pan powróci w najmniej oczekiwanej chwili. Surowo się z nim wtedy rozprawi i osądzi go wraz z innymi niewiernymi. ");
INSERT INTO polsz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Sługę, który znał wymagania właściciela, a nie wykonał ich, spotka większa kara. ");
INSERT INTO polsz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Natomiast tego, który ich nie poznał, a też uczynił coś nagannego, spotka mniejsza kara. Im więcej się komuś powierza, tym więcej się od niego wymaga. ");
INSERT INTO polsz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Przyszedłem—mówił dalej Jezus—wzniecić na ziemi ogień i bardzo bym chciał, aby on już zapłonął. ");
INSERT INTO polsz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mam zostać „ochrzczony” i czekam na ten „chrzest” w wielkiej udręce! ");
INSERT INTO polsz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sądzicie, że przyszedłem przynieść na ziemię pokój? Wręcz przeciwnie—niezgodę! ");
INSERT INTO polsz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Odtąd nawet wśród najbliższych nastąpią podziały: spośród pięciu osób troje poróżni się z dwojgiem, a dwoje z trojgiem; ");
INSERT INTO polsz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ojciec poróżni się z synem, matka z córką, a teściowa z synową. ");
INSERT INTO polsz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Następnie rzekł do tłumu: —Widząc, że od zachodu nadciągają chmury, mówicie: „Będzie deszcz”. I rzeczywiście pada! ");
INSERT INTO polsz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Gdy wieje wiatr z południa, mówicie: „Będzie upał”. I to też się sprawdza. ");
INSERT INTO polsz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Obłudnicy! Trafnie prognozujecie pogodę po wyglądzie nieba i ziemi, ale działania Boga widocznego w obecnych czasach nie potraficie rozpoznać! ");
INSERT INTO polsz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Dlaczego sami nie rozsądzacie, co jest słuszne? ");
INSERT INTO polsz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Jeśli w drodze do sądu spotkasz się ze swoim oskarżycielem, staraj się załatwić sprawę polubownie. W przeciwnym bowiem razie, sędzia skaże cię i zostaniesz wtrącony do więzienia. ");
INSERT INTO polsz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mówię ci, że nie wyjdziesz stamtąd, aż spłacisz cały dług—co do grosza. ");
INSERT INTO polsz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wtedy właśnie niektórzy słuchający donieśli Jezusowi, że Piłat zamordował kilku mieszkańców Galilei, gdy ci składali ofiary w świątyni w Jerozolimie. ");
INSERT INTO polsz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","—Czy sądzicie, że byli oni większymi grzesznikami niż pozostali mieszkańcy Galilei, bo spotkał ich taki los?—zapytał. ");
INSERT INTO polsz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","—Wiedzcie, że wszyscy podobnie zginiecie, jeśli się nie opamiętacie. ");
INSERT INTO polsz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","A może uważacie, że tych osiemnastu, którzy ostatnio zginęli pod gruzami wieży w Siloe, było gorszymi grzesznikami niż reszta mieszkańców Jerozolimy? ");
INSERT INTO polsz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wiedzcie, że czeka was taki sam koniec, jeśli się nie opamiętacie. ");
INSERT INTO polsz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Następnie opowiedział im przypowieść: —Pewien człowiek zasadził w ogrodzie drzewo figowe. Co jakiś czas sprawdzał, czy już wydało owoce, ale nigdy ich nie znajdował. ");
INSERT INTO polsz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","W końcu powiedział ogrodnikowi: „Już od trzech lat bezskutecznie szukam na tym drzewie owoców. Wytnij je. Po co marnować ziemię!”. ");
INSERT INTO polsz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","„Daj mu jeszcze jedną szansę”—poprosił ogrodnik. „Pozostaw je do przyszłego roku, a ja starannie je okopię i obłożę nawozem. ");
INSERT INTO polsz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Może w końcu zaowocuje. Jeśli nie—każ je wyciąć”. ");
INSERT INTO polsz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jakiś czas później Jezus nauczał w szabat w synagodze. ");
INSERT INTO polsz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","A przebywała tam również pewna przygarbiona kobieta, która od osiemnastu lat nie mogła się wyprostować. ");
INSERT INTO polsz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Gdy Jezus ją zobaczył, rzekł: —Kobieto, uwalniam cię od tego! ");
INSERT INTO polsz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Gdy położył na nią ręce, natychmiast się wyprostowała i jednocześnie zaczęła wychwalać za to Boga. ");
INSERT INTO polsz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","A ponieważ miało to miejsce w szabat, przełożony tamtejszej synagogi z oburzeniem zawołał do tłumu: —Jest sześć dni roboczych! W te dni załatwiajcie swoje uzdrowienia, a nie w święty dzień szabatu! ");
INSERT INTO polsz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","—Obłudnicy!—odrzekł Jezus. —Przecież każdy z was tego dnia odwiązuje bydło i wyprowadza je z obory, aby mogło się napić. ");
INSERT INTO polsz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A tu oto stoi potomkini Abrahama, którą szatan przez osiemnaście lat trzymał w swoich więzach! Czyż więc nie powinienem ich rozwiązać i uwolnić jej właśnie w święty dzień szabatu?! ");
INSERT INTO polsz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Słowa te zawstydziły wszystkich wrogów Jezusa, a ludzie z tłumu cieszyli się z powodu Jego wielkich cudów. ");
INSERT INTO polsz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Zaczął więc ich nauczać: —Do czego można porównać królestwo Boże i jak można je opisać? ");
INSERT INTO polsz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Podobne jest ono do małego ziarnka gorczycy, które pewien człowiek zasiał w swoim ogrodzie. Gdy wyrosło, stało się tak dużym krzewem, że na jego gałęziach ptaki zbudowały sobie gniazda. ");
INSERT INTO polsz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Do czego jeszcze można porównać królestwo Boże?—mówił dalej Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","—Podobne jest ono do kwasu chlebowego, który kobieta zmieszała z całym workiem mąki a on przeniknął całe ciasto. ");
INSERT INTO polsz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kontynuując podróż do Jerozolimy, Jezus nauczał po drodze we wszystkich miastach i wioskach. ");
INSERT INTO polsz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pewnego razu ktoś Go zapytał: —Panie, czy to prawda, że tylko nieliczni będą zbawieni? ");
INSERT INTO polsz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Drzwi do nieba są wąskie—odpowiedział Jezus. —Dołóżcie zatem wszelkich starań, aby przez nie wejść. Wielu bowiem zechce to zrobić, ale gdy Ja, pan domu, zamknę drzwi, będzie już za późno. ");
INSERT INTO polsz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","I chociaż będziecie stać pod drzwiami, pukać i prosić: „Panie, otwórz nam”, Ja odpowiem: „Nie znam was, więc nie otworzę”. ");
INSERT INTO polsz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","„Jak to? Przecież jadaliśmy z Tobą i nauczałeś na naszych ulicach?”—powiecie. ");
INSERT INTO polsz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lecz Ja powtórzę: „Naprawdę was nie znam. Odejdźcie stąd wy wszyscy, którzy czynicie zło!”. ");
INSERT INTO polsz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tam będzie rozpacz i lament! Zobaczycie bowiem w królestwie Bożym Abrahama, Izaaka, Jakuba i wszystkich proroków, sami zaś będziecie wyrzuceni na zewnątrz. ");
INSERT INTO polsz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","A ludzie ze wszystkich stron świata—ze wschodu i zachodu, z północy i południa—przybędą i zajmą miejsce w królestwie Bożym. ");
INSERT INTO polsz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Wtedy wielu z tych, którzy są obecnie uznawani za wielkich, przestanie się liczyć, a inni, teraz uznawani za najmniejszych, będą wielkimi. ");
INSERT INTO polsz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wtedy nadeszli jacyś faryzeusze i powiedzieli Mu: —Lepiej stąd uciekaj, bo Herod Antypas chce Cię zabić. ");
INSERT INTO polsz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","—To wy idźcie—rzekł Jezus—i powiedzcie temu przebiegłemu lisowi: „Jeszcze dziś i jutro będę uzdrawiał ludzi i uwalniał ich od złych duchów, a pojutrze skończę. ");
INSERT INTO polsz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Muszę jednak przez te trzy dni kontynuować swoją podróż, bo żaden Boży prorok nie może przecież zginąć poza Jerozolimą”. ");
INSERT INTO polsz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","—Jerozolimo, Jerozolimo!—kontynuował Jezus. —Zabijasz proroków i obrzucasz kamieniami Bożych posłańców! Ileż to razy chciałem przygarnąć twoje dzieci, tak jak kura chroni pod skrzydłami pisklęta. Ale nie pozwoliłaś! ");
INSERT INTO polsz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Zbliża się czas, w którym twój dom opustoszeje. Mówię wam: Nie zobaczycie Mnie do chwili, gdy zawołacie: „Błogosławiony, który przychodzi w imieniu samego Pana!”. ");
INSERT INTO polsz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pewnego razu, w święty dzień szabatu, Jezus gościł w domu jednego z przywódców faryzeuszy. Obecni tam goście śledzili każdy Jego ruch. ");
INSERT INTO polsz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wtedy stanął przed Nim człowiek cierpiący na wodną puchlinę. ");
INSERT INTO polsz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jezus zapytał więc zebranych tam faryzeuszy i przywódców religijnych: —Czy Prawo Mojżesza zezwala na uzdrowienie kogoś w szabat, czy nie? ");
INSERT INTO polsz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Oni jednak nie opowiedzieli ani słowem. Wtedy Jezus wziął chorego za rękę, uzdrowił go i odesłał do domu. ");
INSERT INTO polsz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Następnie powiedział: —Jeśli wasze dziecko lub zwierzę wpadnie w głęboki dół, to czy natychmiast ich nie wyciągacie, nawet w święty dzień szabatu? ");
INSERT INTO polsz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","I znowu nie potrafili Mu odpowiedzieć. ");
INSERT INTO polsz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Widząc zaproszonych gości, którzy wybierali sobie jak najlepsze miejsca, Jezus dał im następującą radę: ");
INSERT INTO polsz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Jeśli ktoś cię zaprosi na wesele, nie zajmuj od razu najlepszego miejsca. Bo gdy wejdzie gość znaczniejszy od ciebie, ");
INSERT INTO polsz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","gospodarz domu powie ci: „Proszę, ustąp mu miejsca”. Zawstydzony, będziesz musiał wtedy zająć miejsce na szarym końcu. ");
INSERT INTO polsz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Jeśli więc zostaniesz zaproszony, zajmij najpierw ostatnie miejsce. Gdy zjawi się pan domu, podejdzie i zaproponuje ci: „Przyjacielu, mam dla ciebie lepsze miejsce!”. W ten sposób zostaniesz uhonorowany wobec wszystkich gości. ");
INSERT INTO polsz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Każdy, kto się teraz ubiega o wyróżnienie, będzie upokorzony, a ten, kto teraz okazuje pokorę, zostanie wyróżniony. ");
INSERT INTO polsz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Następnie zwrócił się do gospodarza: —Gdy wydajesz przyjęcie, nie zapraszaj wyłącznie przyjaciół, krewnych i bogatych sąsiadów—z nadzieją, że zrewanżują się tym samym. ");
INSERT INTO polsz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Zaproś również ubogich, kalekich, ułomnych i niewidomych. ");
INSERT INTO polsz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Będziesz szczęśliwy, bo tacy ludzie nie mają czym ci się odwdzięczyć, a nagrodę otrzymasz po zmartwychwstaniu prawych. ");
INSERT INTO polsz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Słuchając tych słów, któryś z gości rzekł do Jezusa: —Szczęśliwy będzie ten, kto zasiądzie do uczty w królestwie Bożym! ");
INSERT INTO polsz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Na to Jezus opowiedział mu taką historię: —Pewien człowiek zamierzał urządzić wielkie przyjęcie i rozesłał mnóstwo zaproszeń. ");
INSERT INTO polsz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tuż przed rozpoczęciem wysłał do zaproszonych sługę z wiadomością: „Przygotowania zakończone! Zapraszam!”. ");
INSERT INTO polsz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Wszyscy jednak zaczęli się wykręcać. Jeden powiedział: „Właśnie kupiłem pole i koniecznie muszę je obejrzeć. Proszę, wybacz mi moją nieobecność”. ");
INSERT INTO polsz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Drugi powiedział: „Właśnie kupiłem pięć par wołów i akurat wychodzę je wypróbować. Proszę, wybacz mi moją nieobecność”. ");
INSERT INTO polsz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jeszcze inny tak się usprawiedliwił: „Właśnie się ożeniłem. Chyba rozumiesz, że nie mogę przyjść”. ");
INSERT INTO polsz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Sługa wrócił i powtórzył wszystko swojemu panu. Ten, słysząc takie wymówki, rozgniewał się i nakazał: „Natychmiast idź na rynek oraz na ulice miasta i przyprowadź tu biednych, kalekich, ułomnych i niewidomych”. ");
INSERT INTO polsz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Po wykonaniu polecenia sługa oznajmił: „Panie, stało się tak, jak sobie życzyłeś, lecz mimo to pozostały jeszcze wolne miejsca”. ");
INSERT INTO polsz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","„Wobec tego—rzekł pan—idź poza miasto i nakłaniaj napotkanych do przyjścia, tak aby mój dom był pełen gości. ");
INSERT INTO polsz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Z tych bowiem, których wcześniej zaprosiłem, nikt nie skosztuje przygotowanych potraw!”. ");
INSERT INTO polsz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Gdy Jezus udał się w dalszą drogę, razem z Nim szły nieprzebrane tłumy ludzi. Skierował więc do nich takie słowa: ");
INSERT INTO polsz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Nikt nie może być moim uczniem, jeśli nie kocha Mnie bardziej niż swojego ojca, matkę, żonę, dzieci, braci czy siostry, a nawet bardziej niż samego siebie. ");
INSERT INTO polsz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kto nie bierze swojego krzyża i nie idzie ze Mną, nie może być moim uczniem. ");
INSERT INTO polsz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Rozważcie więc swoją decyzję! Gdy ktoś z was chce rozpocząć budowę, to czy najpierw nie oblicza kosztów i nie upewnia się, że starczy mu na jej ukończenie? ");
INSERT INTO polsz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","W przeciwnym razie już po położeniu fundamentów może mu zabraknąć pieniędzy. A wtedy stanie się obiektem kpin i żartów. ");
INSERT INTO polsz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","„Cóż za brak rozsądku!”—powiedzą ludzie. „Zaczął budować i nie skończył, bo nie ma już pieniędzy”. ");
INSERT INTO polsz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Który władca rozpocznie wojnę nie zastanawiając się najpierw, czy swą dziesięciotysięczną armią zdoła pokonać nadciągające dwadzieścia tysięcy żołnierzy wroga? ");
INSERT INTO polsz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Jeśli nie jest w stanie, rozpoczyna rokowania pokojowe, dopóki nieprzyjaciel jest jeszcze daleko. ");
INSERT INTO polsz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nikt z was nie może więc zostać moim uczniem, jeśli nie wyrzeknie się dla Mnie wszystkiego, co ma. ");
INSERT INTO polsz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sól jest dobra—mówił dalej Jezus—lecz jeśli utraci swój smak, staje się bezwartościowa. ");
INSERT INTO polsz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Do niczego już się nie nadaje, nawet do nawożenia gleby. Trzeba ją po prostu wyrzucić. Kto ma uszy, niech słucha uważnie! ");
INSERT INTO polsz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Do Jezusa przychodzili wszyscy nieuczciwi poborcy podatkowi oraz inni ludzie znani z grzesznego życia—i uważnie słuchali Go. ");
INSERT INTO polsz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Oburzeni faryzeusze i nauczyciele religijni mówili: —Dlaczego on się zadaje z takimi ludźmi?! ");
INSERT INTO polsz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jezus odpowiedział im przypowieścią: ");
INSERT INTO polsz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Kto z was, mając sto owiec, nie zostawi dziewięćdziesięciu dziewięciu i nie szuka jednej, zaginionej na pustkowiu, tak długo, aż ją znajdzie? ");
INSERT INTO polsz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A znalazłszy, kładzie ją na swoje ramiona i z radością ");
INSERT INTO polsz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","wraca do domu! Zaprasza wtedy przyjaciół oraz sąsiadów i mówi: „Cieszcie się razem ze mną! Znalazłem zgubioną owcę!”. ");
INSERT INTO polsz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Zapewniam was, że w niebie jest większa radość z jednego zagubionego grzesznika, który się opamięta i wróci do Boga, niż z dziewięćdziesięciu dziewięciu prawych, którzy nie zbłądzili! ");
INSERT INTO polsz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jezus mówił dalej: —Jeśli kobieta zgubi jedną ze swoich dziesięciu cennych monet, to czy nie zapala w domu światła, nie sprząta i nie przeszukuje wszystkich miejsc tak długo, aż znajdzie zgubę? ");
INSERT INTO polsz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A wtedy zwołuje przyjaciółki i sąsiadki i mówi: „Cieszcie się razem ze mną! Znalazłam zgubioną monetę!”. ");
INSERT INTO polsz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tak właśnie cieszą się Boży aniołowie, gdy jeden grzesznik opamięta się i wróci do Boga. ");
INSERT INTO polsz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jezus opowiedział też następną historię: —Pewien człowiek miał dwóch synów. ");
INSERT INTO polsz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Młodszy z nich powiedział: „Ojcze, daj mi już teraz przypadającą na mnie część majątku”. Ojciec zgodził się; podzielił majątek i przekazał synom. ");
INSERT INTO polsz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kilka dni później młodszy zabrał swoją część i udał się w podróż do dalekiego kraju. Niebawem, prowadząc rozwiązłe życie, roztrwonił cały majątek. ");
INSERT INTO polsz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Po pewnym jednak czasie w kraju tym zapanował dotkliwy głód, który i jemu dał się we znaki. ");
INSERT INTO polsz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Wtedy postarał się u miejscowego rolnika o pracę przy świniach. ");
INSERT INTO polsz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Był tak bardzo wygłodniały, że chciał się żywić tym, co jadły świnie, ale nawet tego nikt mu nie dawał. ");
INSERT INTO polsz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Opamiętał się wtedy i powiedział sobie: „Zwykli robotnicy mojego ojca mają jedzenia pod dostatkiem, a ja tu przymieram głodem! ");
INSERT INTO polsz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wrócę do domu i powiem: ‚Ojcze, zgrzeszyłem wobec Boga i wobec ciebie. ");
INSERT INTO polsz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nie jestem już godny nazywać się twoim synem, ale przyjmij mnie, proszę, do pracy w twoim gospodarstwie’ ”. ");
INSERT INTO polsz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Wstał więc i wyruszył w drogę. Gdy był jeszcze daleko od domu, ojciec dostrzegł go i—ogarnięty współczuciem—wybiegł mu na spotkanie. Rzucił mu się na szyję i ucałował go. ");
INSERT INTO polsz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","„Ojcze, zgrzeszyłem przeciw Bogu i przeciw tobie. Nie jestem już godny nazywać się twoim synem…”—zaczął. ");
INSERT INTO polsz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","„Przynieście tu szybko najlepsze ubranie i przebierzcie go!”—rozkazał ojciec służbie. „Dajcie mu rodzinny pierścień na rękę i buty na nogi. ");
INSERT INTO polsz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Zabijcie też najdorodniejsze cielę! Musimy to uczcić. ");
INSERT INTO polsz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mój syn był bowiem jak martwy, ale ożył; był zgubiony, ale się odnalazł!”. I rozpoczęła się uczta. ");
INSERT INTO polsz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tymczasem starszy syn pracował w polu. Wracając do domu, usłyszał odgłosy muzyki i tańców. ");
INSERT INTO polsz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Zawołał więc jednego ze służących i spytał, co się wydarzyło. ");
INSERT INTO polsz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","„Twój brat powrócił cały i zdrowy. A ojciec z radości kazał przygotować na przyjęcie najdorodniejsze cielę”. ");
INSERT INTO polsz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Rozgniewało to starszego brata i nie chciał wejść do domu. Ojciec wyszedł więc do niego i prosił, aby jednak wszedł. ");
INSERT INTO polsz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Syn zaczął wtedy narzekać: „Już tyle lat uczciwie dla ciebie pracuję i nigdy nie zlekceważyłem twojego polecenia! Ale ty nie dałeś mi nawet koźlęcia, abym mógł przygotować przyjęcie i zaprosić swoich przyjaciół. ");
INSERT INTO polsz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Gdy jednak wrócił ten wyrodny syn, który roztrwonił twoje pieniądze na prostytutki, ty przygotowałeś dla niego najdorodniejsze cielę!”. ");
INSERT INTO polsz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","„Synku!”—rzekł ojciec. —„Ty zawsze jesteś ze mną i wszystko, co posiadam, należy już do ciebie. ");
INSERT INTO polsz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dzisiaj jednak mamy powód do radości, bo twój brat, który był jak martwy, ożył; był zgubiony, ale się odnalazł!”. ");
INSERT INTO polsz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nieco później uczniowie usłyszeli od Jezusa jeszcze jedną historię: —Pewien bogaty właściciel zatrudniał zarządcę, który został później oskarżony o złe gospodarowanie majątkiem. ");
INSERT INTO polsz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Wezwał go więc i oznajmił mu: „Słyszę o tobie różne złe rzeczy. Przygotuj rozliczenie, bo nie będziesz już u mnie pracował!”. ");
INSERT INTO polsz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","„Straciłem taką posadę! Co ja teraz zrobię?”—myślał zarządca. „Nie mam siły do pracy fizycznej, a nie będę przecież żebrać… ");
INSERT INTO polsz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Już wiem, co zrobić, aby niektórzy ludzie pomogli mi i przyjęli mnie do swojego domu, gdy stąd odejdę!”. ");
INSERT INTO polsz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Wezwał wszystkich dłużników swojego pracodawcy. „Ile jesteś winien?”—zapytał pierwszego. ");
INSERT INTO polsz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","„Sto beczek oliwy”—odparł tamten. „Weź więc zobowiązanie”—rzekł zarządca—„i napisz: Winien pięćdziesiąt beczek—resztę umorzono”. ");
INSERT INTO polsz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","„A ty, ile jesteś winien?”—zapytał następnego dłużnika. „Dziesięć ton pszenicy”—odpowiedział. „Weź swoje zobowiązanie i napisz: Winien osiem ton—resztę umorzono”. ");
INSERT INTO polsz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Właściciel dowiedział się o tym i pochwalił złego zarządcę za spryt. Jest bowiem prawdą, że ludzie tego świata wykazują tu, na ziemi, więcej sprytu niż ludzie należący do Boga. ");
INSERT INTO polsz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Dobrze więc wam radzę: Zjednujcie sobie przyjaciół nawet przy pomocy dóbr materialnych i pieniędzy, aby mogli was przyjąć w niebiańskim domu, gdy zakończycie swoją ziemską pracę. ");
INSERT INTO polsz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kto jest wierny w małych sprawach, będzie wierny również w wielkich. A kto jest nieuczciwy w drobnych sprawach, będzie nieuczciwy i w dużych. ");
INSERT INTO polsz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jeśli więc nie zarządzacie uczciwie dobrami materialnymi, kto wam powierzy prawdziwe dobra w niebie? ");
INSERT INTO polsz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Skoro nie potraficie rzetelnie gospodarować cudzym majątkiem, kto wam da coś na własność? ");
INSERT INTO polsz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nie da się lojalnie służyć dwóm panom. Albo jednego nienawidzisz, a drugiego kochasz, albo na odwrót—drugiego szanujesz, a pierwszego lekceważysz. Nie możecie równocześnie żyć dla Boga i dla pieniędzy! ");
INSERT INTO polsz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Słuchali tego wszystkiego faryzeusze, którzy byli bardzo przywiązani do pieniędzy, i śmiali się z Jezusa. ");
INSERT INTO polsz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Wtedy zwrócił się do nich: —Udajecie prawych, ale Bóg zna wasze przewrotne serca. Tym jednak, co świat podziwia, Bóg się brzydzi. ");
INSERT INTO polsz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Dotychczas waszym przewodnikiem było Prawo Mojżesza i pisma proroków—kontynuował Jezus—lecz gdy od czasu Jana Chrzciciela głoszona jest dobra nowina o królestwie Bożym, wszyscy usilnie starają się do niego dostać. ");
INSERT INTO polsz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","W Prawie nie zmieni się jednak nawet najmniejsza literka. Prędzej niebo i ziemia przestaną istnieć! ");
INSERT INTO polsz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Dlatego ten, kto rozwodzi się z żoną i łączy się z inną kobietą, dopuszcza się grzechu niewierności małżeńskiej. To samo dotyczy tego, kto się żeni z rozwódką. ");
INSERT INTO polsz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jezus mówił dalej: —Żył pewien bogaty człowiek, który wytwornie się ubierał i codziennie wyprawiał przyjęcia. ");
INSERT INTO polsz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Natomiast przy bramie jego domu leżał schorowany żebrak imieniem Łazarz, ");
INSERT INTO polsz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","który chciał zjeść choć trochę resztek ze stołu bogacza. Przychodziły do niego jednak tylko psy i lizały jego owrzodzone rany. ");
INSERT INTO polsz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","W końcu żebrak umarł i aniołowie przenieśli go do nieba, tam, gdzie przebywa Abraham. Umarł także bogacz i został pogrzebany. ");
INSERT INTO polsz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Znalazł się jednak w piekle, gdzie przeżywał straszliwe cierpienia. Gdy spojrzał w górę, zobaczył w oddali Łazarza w towarzystwie Abrahama. ");
INSERT INTO polsz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","„Ojcze Abrahamie, okaż mi trochę litości!”—zawołał. „Wyślij tu Łazarza, żeby chociaż zamoczył palec w wodzie i ochłodził mój język, gdyż przeżywam w tych płomieniach straszliwe męki!”. ");
INSERT INTO polsz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Lecz Abraham odpowiedział: „Synu! Przypomnij sobie, że za życia było ci dobrze, natomiast Łazarzowi żyło się bardzo źle. Teraz on doznaje pociechy, a ty cierpisz. ");
INSERT INTO polsz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Poza tym dzieli nas ogromna przepaść, aby nikt od nas nie mógł przejść do was ani nikt od was—do nas”. ");
INSERT INTO polsz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Wtedy bogacz błagał: „Proszę cię, ojcze Abrahamie, poślij Łazarza do domu mojego ojca. ");
INSERT INTO polsz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mam jeszcze pięciu braci. Niech ich ostrzeże przed tym miejscem cierpień, aby i oni nie trafili tutaj po śmierci”. ");
INSERT INTO polsz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Lecz Abraham odpowiedział: „Wystarczy, że mają Prawo Mojżesza i pisma proroków. Niech przestrzegają tego, co tam napisano”. ");
INSERT INTO polsz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","„Ojcze Abrahamie!”—rzekł bogacz. „To nie wystarczy. Gdyby jednak powiedział im o tym ktoś z umarłych, wtedy się opamiętają”. ");
INSERT INTO polsz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ale Abraham zaprzeczył: „Skoro nie chcą słuchać Mojżesza i proroków, to nie przekona ich nawet ktoś, kto zmartwychwstał”. ");
INSERT INTO polsz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Innym razem rzekł Jezus do uczniów: —Zepsucie jest nieuniknione, ale marny los człowieka, który nakłania innych do grzechu! ");
INSERT INTO polsz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Lepiej byłoby, aby przywiązano mu do szyi młyński kamień i utopiono go w morzu, niż żeby z jego powodu upadł choćby jeden z najmniejszych moich uczniów. ");
INSERT INTO polsz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Uważajcie na siebie!—kontynuował. —Jeśli inny wierzący zgrzeszy, upomnij go, a jeśli się opamięta, okaż mu przebaczenie. ");
INSERT INTO polsz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nawet gdyby grzeszył przeciw tobie siedem razy dziennie, lecz za każdym razem przychodził mówiąc: „Opamiętałem się, wybacz mi!”, przebacz mu. ");
INSERT INTO polsz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostołowie zwrócili się wtedy do Jezusa: —Panie, spraw, byśmy mocniej wierzyli. ");
INSERT INTO polsz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","—Gdybyście mieli wiarę choćby jak ziarnko gorczycy—odpowiedział—moglibyście powiedzieć do tego drzewa morwowego: „Wyrwij się z korzeniami i rzuć się do morza!”, a ono by was posłuchało. ");
INSERT INTO polsz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","I dodał: —Jeśli wasz sługa wraca do domu po pracy w polu lub na pastwisku, czy mówicie mu: „Idź i odpocznij”? ");
INSERT INTO polsz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nie. Mówicie raczej: „Teraz przygotuj kolację i usługuj mi, aż się najem i napiję. A potem ty będziesz mógł zjeść”. ");
INSERT INTO polsz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Przecież nie dziękujecie słudze za wykonanie tego, co jest jego normalnym obowiązkiem. ");
INSERT INTO polsz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Dlatego i wy nie spodziewajcie się pochwały, gdy wykonacie to, co wam poleciłem, ale mówcie: „Jesteśmy sługami. Spełniliśmy jedynie nasz obowiązek”. ");
INSERT INTO polsz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Podążając w kierunku Jerozolimy, Jezus przechodził przez graniczne tereny Galilei i Samarii. ");
INSERT INTO polsz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Gdy wchodził do pewnej wioski, spotkał dziesięciu trędowatych. ");
INSERT INTO polsz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ci, zachowując obowiązujący dystans, zawołali: —Jezusie, Mistrzu, zlituj się nad nami! ");
INSERT INTO polsz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","On spojrzał na nich i rzekł: —Idźcie i poproście, aby zbadali was kapłani. A gdy byli jeszcze w drodze, zostali całkowicie uzdrowieni. ");
INSERT INTO polsz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jeden z nich, widząc, co się stało, szybko powrócił do Jezusa, głośno wielbiąc Boga. ");
INSERT INTO polsz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Rzucił się Mu do stóp i gorąco dziękował za uzdrowienie. A był to człowiek z pogardzanej przez wszystkich Samarii. ");
INSERT INTO polsz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","—Czy nie uzdrowiłem dziesięciu?—zapytał Jezus. —Gdzie jest pozostałych dziewięciu? ");
INSERT INTO polsz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Dlaczego i oni nie wrócili, aby podziękować za to Bogu—tylko ten cudzoziemiec? ");
INSERT INTO polsz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Potem zwrócił się do uzdrowionego: —Możesz odejść. Uwierzyłeś i dlatego odzyskałeś zdrowie. ");
INSERT INTO polsz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pewnego razu faryzeusze zapytali Jezusa, kiedy nastanie królestwo Boże. —Królestwo Boże nadejdzie niezauważalnie—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","—Nikt nie powie: „Tu jest!” albo: „Jest tam!”. Królestwo Boże jest bowiem wśród was. ");
INSERT INTO polsz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Później, zwracając się do uczniów, powiedział: —Przyjdzie czas, że zapragniecie abym Ja, Syn Człowieczy, choć na chwilę znów był z wami, ale nie będzie Mnie. ");
INSERT INTO polsz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Będą wam mówili: „Mesjasz jest tam!” albo: „Tu się pojawił!”, ale nie biegajcie i nie szukajcie Mnie. ");
INSERT INTO polsz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gdy powtórnie przyjdę, będzie to tak widoczne, jak błyskawica na niebie. ");
INSERT INTO polsz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Najpierw jednak spotkają Mnie straszne cierpienia i zostanę odrzucony przez to pokolenie. ");
INSERT INTO polsz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Czas mojego przybycia będzie podobny do czasów Noego. ");
INSERT INTO polsz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ludzie wtedy zwyczajnie jedli i pili, zawierali małżeństwa—aż do chwili, gdy Noe wszedł do arki. Wtedy przyszedł potop i wszyscy zginęli. ");
INSERT INTO polsz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Czas ten będzie również podobny do czasów Lota, kiedy to ludzie jak zwykle jedli, pili, kupowali, sprzedawali, uprawiali ziemię, budowali ");
INSERT INTO polsz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","—aż do dnia, gdy Lot opuścił grzeszną Sodomę. Wtedy na miasto spadł z nieba ogień z siarką i wszystkich wytracił. ");
INSERT INTO polsz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tak samo będzie w czasie mojego objawienia. ");
INSERT INTO polsz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Jeśli tego dnia będziecie na tarasie, nie wchodźcie do domu, aby zabrać swoje rzeczy. Jeśli będziecie na polu, również nie wracajcie do domu. ");
INSERT INTO polsz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Przypomnijcie sobie, co spotkało żonę Lota. ");
INSERT INTO polsz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kto kocha swoje życie, utraci je. Lecz ten, kto poświęci życie dla Mnie, odnajdzie je. ");
INSERT INTO polsz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Wiedzcie, że w noc mojego powrotu z dwóch osób śpiących w jednym łóżku jedna będzie zabrana, a druga pozostawiona. ");
INSERT INTO polsz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Z dwóch kobiet, pracujących w domu, jedna zostanie wzięta, druga zaś pozostawiona. ");
INSERT INTO polsz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Z dwóch ludzi pracujących w polu, jeden zostanie wzięty, a drugi pozostawiony. ");
INSERT INTO polsz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","—Panie, gdzie się to wszystko wydarzy?—zapytali uczniowie. —Gdzie jest padlina, tam w naturalny sposób pojawiają się i sępy—odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pewnego dnia Jezus, mówiąc o potrzebie wytrwałej modlitwy, opowiedział uczniom następującą przypowieść: ");
INSERT INTO polsz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Żył w pewnym mieście sędzia—człowiek nieprzejmujący się Bogiem i lekceważący ludzi. ");
INSERT INTO polsz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Często przychodziła do niego pewna wdowa z tego miasta i błagała: „Bądź moim obrońcą przed tym, który mnie oskarża”. ");
INSERT INTO polsz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Sędzia przez pewien czas nie chciał tego uczynić. W końcu jednak pomyślał sobie: „Chociaż nie przejmuję się Bogiem i nie obchodzą mnie ludzie, ");
INSERT INTO polsz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","to pomogę tej natrętnej kobiecie, żeby mi więcej nie zawracała głowy”. ");
INSERT INTO polsz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Widzicie, co ten zły sędzia sobie pomyślał?—kontynuował Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","—Czyż więc Bóg nie weźmie w obronę swoich wybranych, którzy Go o to błagają dniem i nocą? I czy będzie z tym zwlekał? ");
INSERT INTO polsz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Z pewnością szybko przyjdzie im z pomocą! Ale czy ludzie będą jeszcze wierzyć Bogu, gdy Ja, Syn Człowieczy, powtórnie powrócę na ziemię? ");
INSERT INTO polsz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Następnie, zwracając się do tych, którzy szczycili się własną doskonałością, a pogardzali innymi, opowiedział następującą przypowieść: ");
INSERT INTO polsz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Dwóch ludzi przyszło do świątyni, aby się modlić: szanowany przez wszystkich faryzeusz i pogardzany poborca podatkowy. ");
INSERT INTO polsz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pierwszy stanął z przodu i tak się modlił: „Dziękuję Ci, Boże, że nie jestem grzesznikiem, jak inni ludzie—chciwi, bezbożni, niewierni w małżeństwie albo jak ten nędzny poborca podatkowy! ");
INSERT INTO polsz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aż dwa razy w tygodniu powstrzymuję się od posiłków i składam w ofierze dziesięć procent moich dochodów”. ");
INSERT INTO polsz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","W tym czasie poborca podatkowy stał z daleka i nie śmiał nawet podnieść oczu ku niebu. Bił się z żalem w piersi i błagał: „Boże, okaż mi, grzesznikowi, litość!”. ");
INSERT INTO polsz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Zapewniam was, że ten drugi odszedł do domu z Bożym przebaczeniem, nie pierwszy! Każdy bowiem, kto sam siebie wywyższa, zostanie poniżony. A kto się uniża, zostanie wywyższony. ");
INSERT INTO polsz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Zdarzyło się też, że przyprowadzono do Jezusa dzieci, aby je pobłogosławił. Uczniowie jednak odsuwali je, nie chcąc, aby Mu przeszkadzały. ");
INSERT INTO polsz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Widząc to, Jezus przywołał je do siebie, i rzekł: —Nie zabraniajcie dzieciom przychodzić do Mnie, gdyż do takich jak one należy królestwo Boże. ");
INSERT INTO polsz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Zapewniam was: Jeśli ktoś nie przyjdzie do Boga tak, jak dziecko przychodzi do ojca, nie będzie miał wstępu do Jego królestwa. ");
INSERT INTO polsz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Innym razem pewien wysoko postawiony człowiek zapytał Jezusa: —Dobry Nauczycielu, co mam czynić, aby osiągnąć życie wieczne? ");
INSERT INTO polsz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","—Dlaczego nazywasz Mnie dobrym?—zapytał Jezus. —Naprawdę dobry jest tylko Bóg. ");
INSERT INTO polsz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Jeśli zaś chodzi o twoje pytanie, to znasz chyba przykazania: „Bądź wierny w małżeństwie, nie zabijaj, nie kradnij, nie składaj fałszywych zeznań, szanuj rodziców!”? ");
INSERT INTO polsz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Nauczycielu! Nigdy nie przekroczyłem żadnego z nich—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","—Zatem jedno pozostało ci do zrobienia—powiedział Jezus. —Sprzedaj swój majątek, a pieniądze rozdaj biednym. To zapewni ci skarb w niebie. Potem wróć i chodź ze Mną. ");
INSERT INTO polsz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Na te słowa rozmówca spochmurniał; był bowiem bardzo bogaty. ");
INSERT INTO polsz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jezus odprowadził go wzrokiem i powiedział: —Oto jak trudno jest bogatym wejść do królestwa Bożego. ");
INSERT INTO polsz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Łatwiej wielbłądowi przejść przez ucho od igły, niż bogatemu człowiekowi wejść do królestwa Bożego. ");
INSERT INTO polsz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ludzie, którzy słyszeli te słowa, zapytali: —Kto więc może być zbawiony? ");
INSERT INTO polsz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","—To przekracza ludzkie możliwości, ale dla Boga wszystko jest możliwe—odparł Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","—My zostawiliśmy wszystko i poszliśmy za Tobą—odezwał się Piotr. ");
INSERT INTO polsz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","—Zapewniam was—odpowiedział Jezus—że każdy, kto dla sprawy królestwa Bożego, opuścił dom, żonę, braci, rodziców lub dzieci, ");
INSERT INTO polsz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","otrzyma w zamian o wiele więcej już teraz, a w przyszłym świecie czeka go życie wieczne. ");
INSERT INTO polsz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Potem wziął Dwunastu na bok i powiedział im: —Gdy znajdziemy się w Jerozolimie, spełnią się wszystkie przepowiednie proroków mówiące o tym, że Ja, Syn Człowieczy, ");
INSERT INTO polsz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","zostanę wydany w ręce Rzymian. Będą śmiać się ze Mnie, znieważać i pluć na Mnie; ");
INSERT INTO polsz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ubiczują Mnie i w końcu zabiją. Lecz po trzech dniach powrócę do życia! ");
INSERT INTO polsz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Oni jednak nie rozumieli tego i nie mogli odkryć sensu tych słów. ");
INSERT INTO polsz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Gdy zbliżali się do Jerycha, minęli pewnego niewidomego żebraka, siedzącego przy drodze. ");
INSERT INTO polsz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Słysząc gwar przechodzącego tłumu, pytał, co się dzieje. ");
INSERT INTO polsz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Powiedziano mu więc, że przechodzi tędy Jezus z Nazaretu. ");
INSERT INTO polsz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Na to on zaczął wołać: —Jezusie, potomku króla Dawida, zmiłuj się nade mną! ");
INSERT INTO polsz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ci, którzy szli przodem, uciszali go, on jednak tym głośniej wołał: —Potomku Dawida, zmiłuj się! ");
INSERT INTO polsz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jezus zatrzymał się i polecił go przyprowadzić. Potem zapytał: ");
INSERT INTO polsz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Co mogę dla ciebie zrobić? —Panie!—prosił niewidomy. —Chciałbym widzieć! ");
INSERT INTO polsz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Zatem przejrzyj!—powiedział Jezus. —Twoja wiara cię uzdrowiła. ");
INSERT INTO polsz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","I natychmiast niewidomy odzyskał wzrok i poszedł z Nim, wielbiąc Boga. Również cały tłum, który był świadkiem tego cudu, dziękował Bogu. ");
INSERT INTO polsz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","I tak dotarli do Jerycha. ");
INSERT INTO polsz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mieszkał tam pewien przełożony poborców podatkowych, Zacheusz—człowiek bardzo bogaty. ");
INSERT INTO polsz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zapragnął zobaczyć Jezusa i dowiedzieć się, kim On jest, lecz z powodu niskiego wzrostu nie mógł Go dojrzeć w tłumie. ");
INSERT INTO polsz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pobiegł więc naprzód i wdrapał się na przydrożne drzewo (sykomorę), z którego mógł dobrze widzieć przechodzącego Jezusa. ");
INSERT INTO polsz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tymczasem Jezus zbliżył się do tego miejsca, spojrzał w górę i powiedział do niego: —Zacheuszu! Zejdź szybko na dół! Dzisiaj bowiem muszę być twoim gościem. ");
INSERT INTO polsz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zacheusz pospiesznie zszedł z drzewa i z ogromną radością przyjął Jezusa w swoim domu. ");
INSERT INTO polsz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ludzie jednak byli tym oburzeni: —Poszedł do domu takiego grzesznika—szeptali. ");
INSERT INTO polsz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","W pewnym momencie Zacheusz wstał i powiedział: —Panie! Postanowiłem rozdać biednym połowę mojego majątku, a tym, których oszukałem pobierając zawyżony podatek, oddam cztery razy tyle, ile zabrałem. ");
INSERT INTO polsz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","—Dziś zbawienie zawitało do tego domu—powiedział Jezus—bo i ten człowiek jest potomkiem Abrahama. ");
INSERT INTO polsz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ja, Syn Człowieczy, przyszedłem właśnie po to, aby szukać i ratować tych, którzy się zgubili. ");
INSERT INTO polsz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wszyscy przysłuchiwali się tym słowom. A ponieważ Jerozolima była już niedaleko, Jezus postanowił wyjaśnić im, że są w błędzie, sądząc, iż królestwo Boże nadejdzie już teraz. Dlatego opowiedział im następującą przypowieść: ");
INSERT INTO polsz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Pewien wysoko postawiony człowiek miał się udać w daleką podróż, aby przyjąć nominację na gubernatora prowincji, po czym miał wrócić do domu. ");
INSERT INTO polsz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Wezwał więc dziesięciu podwładnych i przekazał im na ten czas dziesięć udziałów pieniężnych—każdemu po jednym. Powiedział: „Zajmijcie się interesami do czasu mojego powrotu”. ");
INSERT INTO polsz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lecz niektórzy obywatele nienawidzili go i wysłali po jego wyjeździe delegację z protestem: „Nie chcemy takiego władcy”. ");
INSERT INTO polsz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Po pewnym czasie, gdy człowiek ten wrócił już jako gubernator, polecił wezwać tych, którym powierzył pieniądze, aby ocenić zyski. ");
INSERT INTO polsz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Przybył więc pierwszy z nich i poinformował: „Panie, zainwestowałem twoje pieniądze i mam teraz dziesięć razy tyle”. ");
INSERT INTO polsz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","„Bardzo dobrze!”—rzekł władca. „Jesteś dobrym pracownikiem. Okazałeś wierność w małej sprawie, więc teraz dam ci władzę nad dziesięcioma miastami”. ");
INSERT INTO polsz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Drugi podwładny tak powiedział: „Panie, ja też zainwestowałem pieniądze. Teraz mam pięć razy tyle”. ");
INSERT INTO polsz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","„Dobrze!”—powiedział władca. „Ty będziesz zarządzać pięcioma miastami”. ");
INSERT INTO polsz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Następny jednak podszedł i powiedział: „Panie, oto twoje pieniądze, bezpiecznie je przechowałem. ");
INSERT INTO polsz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bałem się ciebie, bo masz twardą rękę w interesach i chcesz mieć zysk z tego, nad czym sam nie pracowałeś”. ");
INSERT INTO polsz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","„Jesteś złym pracownikiem!”—odrzekł władca. „Osądzę cię według twoich własnych słów! Wiedziałeś, że jestem bezwzględny w interesach i chcę mieć zysk nawet jeśli sam na niego nie pracowałem! ");
INSERT INTO polsz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mogłeś więc zanieść moje pieniądze do banku, wtedy miałbym przynajmniej jakieś odsetki”. ");
INSERT INTO polsz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","I zwracając się do stojących tam ludzi, rozkazał: „Zabierzcie mu pieniądze i dajcie temu, który zarobił dziesięć razy tyle!”. ");
INSERT INTO polsz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","„Ależ panie! On i tak ma dużo”—odpowiedzieli mu. ");
INSERT INTO polsz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","„Każdy, kto przynosi zyski, otrzyma więcej. A temu, kto nie przynosi zysku, odbiorą i to, co posiada”—odpowiedział gubernator. ");
INSERT INTO polsz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","„A teraz przyprowadźcie tu tych moich wrogów, którzy nie chcieli, abym został ich władcą. Straćcie ich na moich oczach!”. ");
INSERT INTO polsz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Powiedziawszy to, Jezus wstał i ruszył w kierunku Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Gdy zbliżyli się do Betfage i Betanii, wiosek leżących na Górze Oliwnej, wysłał przed sobą dwóch uczniów, ");
INSERT INTO polsz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","mówiąc: —Idźcie do najbliższej wsi. Zaraz przy wejściu do niej znajdziecie uwiązanego osiołka, na którym jeszcze nikt nie jechał. Odwiążcie go i przyprowadźcie tutaj. ");
INSERT INTO polsz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","A gdyby ktoś was pytał, po co go bierzecie, powiedzcie po prostu: „Pan go potrzebuje”. ");
INSERT INTO polsz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Poszli więc i zastali wszystko tak, jak im Jezus powiedział. ");
INSERT INTO polsz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Gdy odwiązywali zwierzę, jego właściciele zapytali: —Dlaczego odwiązujecie naszego osła? ");
INSERT INTO polsz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Pan go potrzebuje—odpowiedzieli im uczniowie. ");
INSERT INTO polsz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Gdy przyprowadzili osiołka, zarzucili na jego grzbiet płaszcze i pomogli Jezusowi go dosiąść. ");
INSERT INTO polsz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ludzie, na widok jadącego Jezusa, rozkładali na drodze swoje płaszcze. ");
INSERT INTO polsz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","A gdy zaczął już zjeżdżać z Góry Oliwnej, pojawił się cały tłum Jego uczniów. Z radością wykrzykiwali oni na cześć Boga i wielbili Go za wszystkie cuda Jezusa, które widzieli: ");
INSERT INTO polsz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Niech żyje Król, który przychodzi w imieniu Pana! Pokój w niebie, i chwała na wysokościach! ");
INSERT INTO polsz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Lecz niektórzy faryzeusze, znajdujący się w tłumie, mówili: —Nauczycielu, ucisz swoich uczniów! Słyszysz, co oni wykrzykują? ");
INSERT INTO polsz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","—Zapewniam was, że jeśli oni zamilkną, kamienie zaczną wołać!—odparł Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Gdy byli tuż przed Jerozolimą, spojrzał na nią i pełen smutku powiedział: ");
INSERT INTO polsz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—O, gdybyś dziś zrozumiała, co prowadzi do pokoju! Ale teraz zostało to przed tobą zakryte. ");
INSERT INTO polsz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Niebawem nadejdą dni, gdy ze wszystkich stron otoczą cię wrogowie i będą oblegać twoje mury. ");
INSERT INTO polsz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Potem zrównają cię z ziemią i wymordują twoich mieszkańców. Nie pozostawią kamienia na kamieniu, bo nie rozpoznałaś chwili, w której przyszedł do ciebie Pan. ");
INSERT INTO polsz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Będąc już w mieście, Jezus wszedł do świątyni i zaczął wypędzać z niej wszystkich sprzedawców. ");
INSERT INTO polsz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Powiedział do nich: —Pismo mówi: „Moja świątynia ma być domem modlitwy, a wy zrobiliście z niej kryjówkę złodziei”. ");
INSERT INTO polsz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Gdy przez kilka następnych dni nauczał w świątyni, najwyżsi kapłani, przywódcy religijni oraz starsi usiłowali znaleźć sposób, aby się Go pozbyć. ");
INSERT INTO polsz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Niczego jednak nie mogli Mu zrobić, bali się bowiem tłumów, które były zachwycone Jego nauką. ");
INSERT INTO polsz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Gdy Jezus ponownie znalazł się w świątyni i nauczał lud oraz głosił dobrą nowinę, najwyżsi kapłani, przywódcy religijni i starsi ");
INSERT INTO polsz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","zapytali Go: —Jakim prawem wyrzuciłeś ze świątyni sprzedawców? Kto dał ci taką władzę? ");
INSERT INTO polsz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","—Ja też zadam wam pytanie—odparł. ");
INSERT INTO polsz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","—Czy chrzest, do którego wzywał Jan Chrzciciel, pochodził od Boga, czy był tylko ludzkim wymysłem? ");
INSERT INTO polsz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wtedy zaczęli się naradzać nad odpowiedzią: —Jeśli powiemy, że pochodził od Boga, to zapyta nas: „Czemu go nie przyjęliście?”. ");
INSERT INTO polsz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A jeśli powiemy, że był ludzkim wymysłem, to tłumy obrzucą nas kamieniami, bo wszyscy wierzą, że Jan był prorokiem. ");
INSERT INTO polsz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","—Nie potrafimy na to odpowiedzieć—rzekli w końcu. ");
INSERT INTO polsz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","—Wobec tego i Ja nie odpowiem na wasze pytanie—odparł Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Następnie, zwracając się do wszystkich, opowiedział przypowieść: —Pewien człowiek założył winnicę, po czym wynajął ją rolnikom, sam zaś wyjechał na długi czas. ");
INSERT INTO polsz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Gdy nastała pora zbiorów, wysłał jednego ze swoich ludzi, aby odebrał należną mu część plonów. Lecz rolnicy pobili posłańca i odesłali go z pustymi rękami. ");
INSERT INTO polsz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Właściciel wysłał więc innego pełnomocnika, lecz z nim postąpili podobnie—pobili go, znieważyli i odesłali z niczym. ");
INSERT INTO polsz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Potem posłał jeszcze trzeciego, ale jego także zranili i wyrzucili. ");
INSERT INTO polsz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","„Co robić?”—zastanawiał się właściciel. „Już wiem! Wyślę mojego ukochanego syna. Przynajmniej jemu chyba okażą szacunek”. ");
INSERT INTO polsz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lecz rolnicy, widząc nadchodzącego syna, powiedzieli sobie: „To ten, który ma przejąć winnicę. Zabijmy go, a winnica będzie nasza!”. ");
INSERT INTO polsz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Napadli go więc, wywlekli poza winnicę i zabili. Co zrobi właściciel gdy się o tym dowie?—kontynuował Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","—Przyjdzie i ukarze wszystkich śmiercią, a winnicę da innym! —Oby nie!—zawołali słuchacze. ");
INSERT INTO polsz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wówczas Jezus spojrzał na nich uważnie i rzekł: —A co znaczą te słowa Pisma: „Kamień odrzucony przez budujących stał się kamieniem węgielnym, najważniejszym w całym budynku!” ");
INSERT INTO polsz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","I dodał: —Każdy, kto upadnie na ten kamień, roztrzaska się o niego, a jeśli on na kogoś spadnie, zetrze go na proch. ");
INSERT INTO polsz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Przywódcy religijni i najwyżsi kapłani zrozumieli, że to ich Jezus miał na myśli, opowiadając przypowieść o złych rolnikach. Dlatego chcieli Go natychmiast aresztować, ale obawiali się reakcji tłumu. ");
INSERT INTO polsz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Postanowili więc sprowokować Go do jakiejś niefortunnej wypowiedzi. Potrzebny był im bowiem pretekst do oskarżenia Go przed rzymskim gubernatorem i aresztowania Go. Wysłali więc szpiegów, udających pobożnych ludzi, ");
INSERT INTO polsz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","którzy zadali Mu takie pytanie: —Nauczycielu! Wiemy, że nauczasz prawdy. Nie dostosowujesz się też do opinii ludzi ani do ich oczekiwań, lecz uczciwie nauczasz prawd Bożych. ");
INSERT INTO polsz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Powiedz nam więc, czy słusznie płacimy podatki Rzymowi, czy nie? ");
INSERT INTO polsz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jezus, zdając sobie sprawę z ich podstępu, powiedział: ");
INSERT INTO polsz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Pokażcie mi najpierw monetę. Czyją podobiznę i tytuł na niej widzicie? —Cezara—odpowiedzieli. ");
INSERT INTO polsz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—Oddajcie więc cezarowi to, co jego, a Bogu—co należy do Boga! ");
INSERT INTO polsz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nie udało im się więc na oczach ludzi sprowokować Go do jakiejś niefortunnej wypowiedzi na temat podatków. A zaskoczeni Jego odpowiedzią, zamilkli. ");
INSERT INTO polsz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Wtedy przyszli do Jezusa saduceusze—przedstawiciele ugrupowania nauczającego, że nie będzie zmartwychwstania: ");
INSERT INTO polsz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Nauczycielu!—zwrócili się do Jezusa. —Prawo Mojżesza naucza: „Jeśli umrze mężczyzna, nie pozostawiając potomstwa, jego brat powinien ożenić się z wdową po zmarłym i mieć z nią potomstwo”. ");
INSERT INTO polsz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Otóż żyło kiedyś siedmiu braci. Najstarszy z nich ożenił się, ale wkrótce zmarł, nie pozostawiając dzieci. ");
INSERT INTO polsz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wówczas z wdową ożenił się drugi, ");
INSERT INTO polsz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","potem trzeci brat, potem następny i kolejny—aż do siódmego—lecz wszyscy zmarli bezdzietnie. ");
INSERT INTO polsz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","W końcu umarła także ta kobieta. ");
INSERT INTO polsz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jeśli rzeczywiście umarli zmartwychwstaną, to czyją będzie wtedy żoną, skoro wszyscy bracia się z nią ożenili? ");
INSERT INTO polsz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","—Ludzie żenią się i wychodzą za mąż tylko tu, na ziemi. —odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","—Natomiast ci, którzy okażą się godnymi nieba i zmartwychwstania, nie będą zawierać małżeństw. ");
INSERT INTO polsz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pod tym względem będą podobni do aniołów: nie umrą po raz drugi i będą synami Boga, zmartwychwstałymi do nowego życia. ");
INSERT INTO polsz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A to, że umarli zmartwychwstają, udowodnił już Mojżesz. Opisując swoje spotkanie z Bogiem przy płonącym krzaku, nazywa Go „Bogiem Abrahama, Bogiem Izaaka i Bogiem Jakuba”. ");
INSERT INTO polsz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bóg nie jest przecież Bogiem tych, którzy już nie istnieją! Dla Niego wszyscy żyją. ");
INSERT INTO polsz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","—Nauczycielu! Dobrze odpowiedziałeś!—przyznali stojący tam przywódcy religijni. ");
INSERT INTO polsz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","I już nikt nie miał odwagi zadawać Mu więcej pytań. ");
INSERT INTO polsz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Wtedy Jezus zapytał ich: —Dlaczego niektórzy twierdzą, że Mesjasz ma pochodzić z rodu króla Dawida? ");
INSERT INTO polsz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Przecież sam Dawid napisał o Nim w Księdze Psalmów: „Bóg rzekł do mojego Pana: Zasiądź po mojej prawej stronie, ");
INSERT INTO polsz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","dopóki nie rzucę Ci pod nogi Twoich nieprzyjaciół”. ");
INSERT INTO polsz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Skoro Dawid nazwał Go Panem, to jak Mesjasz może być jego potomkiem? ");
INSERT INTO polsz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tłum ludzi słuchał tych nauk z wielkim zainteresowaniem. Wtedy Jezus zwrócił się do uczniów: ");
INSERT INTO polsz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Strzeżcie się przywódców religijnych! Oni lubią nosić wytworne szaty, oczekują wyrazów szacunku ze strony innych ludzi oraz najlepszych miejsc w synagogach i na przyjęciach. ");
INSERT INTO polsz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bezwstydnie okradają biedne wdowy! Udają przy tym pobożnych i wygłaszają długie modlitwy, aby ukryć, kim są naprawdę. Tym większa spotka ich kara! ");
INSERT INTO polsz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Gdy stali w świątyni, Jezus zwrócił uwagę na bogatych ludzi wrzucających pieniądze do skarbony świątynnej. ");
INSERT INTO polsz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Zauważył też pewną biedną wdowę, która wrzuciła tylko dwie małe monety. ");
INSERT INTO polsz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","—Posłuchajcie!—rzekł Jezus. —Ta biedna wdowa dała więcej niż wszyscy bogacze razem wzięci! ");
INSERT INTO polsz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Oni bowiem wrzucili tylko część tego, co mieli w nadmiarze, ona zaś oddała wszystko, co miała na życie. ");
INSERT INTO polsz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tymczasem kilku uczniów zaczęło zachwycać się świątynią—jej pięknymi kamieniami i ornamentami zdobiącymi ściany. ");
INSERT INTO polsz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Jezus powiedział wtedy: —Nadejdzie czas, gdy to, co teraz podziwiacie, legnie w gruzach i nie pozostanie tu nawet kamień na kamieniu. ");
INSERT INTO polsz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","—Mistrzu!—zawołali. —Kiedy to się wydarzy? Po czym poznamy nadejście tego czasu? ");
INSERT INTO polsz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","—Nie dajcie się nikomu oszukać!—przestrzegł ich Jezus. —Wielu bowiem będzie podawać się za Mesjasza i ogłaszać, że koniec jest już bliski. Nie wierzcie im! ");
INSERT INTO polsz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na świecie wybuchną wojny i będą rozchodzić się wieści o rozruchach. Nie dajcie się jednak zastraszyć, to jeszcze nie będzie koniec! ");
INSERT INTO polsz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Narody i państwa będą walczyć przeciwko sobie, ");
INSERT INTO polsz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","a wiele krajów nawiedzą trzęsienia ziemi, głód oraz epidemie. Będą miały miejsce przerażające zjawiska, a na niebie pojawią się cudowne znaki. ");
INSERT INTO polsz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Lecz zanim to wszystko się stanie, będziecie prześladowani. Zaciągną was do synagog i więzień oraz oskarżą przed władzami o to, że Mnie naśladujecie. ");
INSERT INTO polsz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Będzie to dla was okazja do przedstawienia im dobrej nowiny. ");
INSERT INTO polsz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pamiętajcie, aby się wtedy nie martwić, jak odpierać stawiane wam zarzuty. ");
INSERT INTO polsz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ja dam wam bowiem właściwe słowa i taką mądrość, że nikt z przeciwników nie zdoła odeprzeć waszych argumentów. ");
INSERT INTO polsz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A nawet najbliżsi—rodzice, bracia, krewni i przyjaciele—będą was zdradzać i wydawać w ręce prześladowców, przez co niektórzy z was zostaną zabici. ");
INSERT INTO polsz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Wszyscy znienawidzą was za to, że należycie do Mnie, ");
INSERT INTO polsz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ale bez zgody Boga nie spadnie wam nawet włos z głowy. ");
INSERT INTO polsz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ci, którzy wytrwają i nie zaprą się Mnie, zostaną uratowani! ");
INSERT INTO polsz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Gdy jednak zobaczycie, że wojska otaczają Jerozolimę, możecie być pewni, że nadszedł czas jej zagłady. ");
INSERT INTO polsz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wtedy ci, którzy przebywają w Judei, niech uciekają w góry. Ci, którzy będą w Jerozolimie, niech ją natychmiast opuszczą, a żyjący w okolicznych wioskach niech do niej nie wchodzą. ");
INSERT INTO polsz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Będą to bowiem dni Bożej kary, zapowiedzianej niegdyś w Piśmie przez proroków. ");
INSERT INTO polsz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ciężko będzie wtedy kobietom w ciąży i matkom karmiącym niemowlęta. Będą to straszne dni, a gniew Boga spadnie na ten naród. ");
INSERT INTO polsz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Niektórzy zostaną zabici, inni—z powodu niewoli—rozproszą się po wszystkich krajach świata. Natomiast pokonana Jerozolima pozostanie w rękach pogan—aż upłynie czas ich dominacji. ");
INSERT INTO polsz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Oprócz tego, dziwne znaki pojawią się na słońcu, księżycu i gwiazdach. Na ziemi zaś wszystkie narody przerażą się z powodu rozszalałych mórz i nawałnic. ");
INSERT INTO polsz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","W oczekiwaniu mających nawiedzić ziemię okropności, ludzi ogarnie strach, bo zachwieje się cały porządek wszechświata. ");
INSERT INTO polsz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Wtedy cała ludzkość ujrzy Mnie, Syna Człowieczego, przybywającego na obłokach w wielkiej mocy i chwale. ");
INSERT INTO polsz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Gdy więc to wszystko zacznie się dziać, nie traćcie nadziei, ponieważ wasze ocalenie będzie bliskie! ");
INSERT INTO polsz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","I wyjaśnił to następującą przypowieścią: —Spójrzcie na drzewo figowe albo na inne drzewa. ");
INSERT INTO polsz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Gdy zaczynają pączkować, mówicie, że zbliża się lato. ");
INSERT INTO polsz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Gdy więc zobaczycie wszystko, co wam zapowiedziałem, bądźcie pewni, że nadejście królestwa Bożego jest bliskie. ");
INSERT INTO polsz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Zapewniam was: Nie wymrze to pokolenie, a wszystko to się dokona. ");
INSERT INTO polsz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Niebo i ziemia przeminą, lecz moje słowa pozostaną na wieki. ");
INSERT INTO polsz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Uważajcie!—kontynuował Jezus. —Jeśli zaczniecie bawić się, pić i zajmować się tylko sprawami tego życia, to ten dzień was zaskoczy. ");
INSERT INTO polsz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nadejdzie on bowiem nagle i jednocześnie dla wszystkich mieszkańców ziemi. ");
INSERT INTO polsz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Uważajcie więc i proście Boga o to, abyście mogli uniknąć tych okropności oraz stanąć przede Mną—Synem Człowieczym. ");
INSERT INTO polsz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Jezus codziennie przychodził do świątyni i nauczał tłumy, które gromadziły się tam już od rana. Każdego wieczoru wracał zaś na Górę Oliwną, gdzie spędzał noc. ");
INSERT INTO polsz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Zbliżała się Pascha—doroczne święto Żydów, w czasie którego jedzą oni chleb pieczony z niekwaszonego ciasta. ");
INSERT INTO polsz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Najwyżsi kapłani i inni przywódcy religijni nadal szukali okazji, aby zabić Jezusa. Chcieli to jednak zrobić potajemnie, obawiali się bowiem reakcji tłumów. ");
INSERT INTO polsz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Właśnie wtedy szatan zwiódł Judasza z Kariotu, jednego z Dwunastu. ");
INSERT INTO polsz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Udał się on do najwyższych kapłanów i dowódców straży świątynnej, aby omówić najdogodniejszy sposób wydania im Jezusa. ");
INSERT INTO polsz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ucieszeni tą propozycją, kapłani obiecali mu nagrodę. ");
INSERT INTO polsz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judasz zgodził się na taki układ i czekał już tylko na sprzyjającą okazję, aby wydać Jezusa w chwili, gdy nie będzie wokół Niego tłumu ludzi. ");
INSERT INTO polsz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gdy nadszedł pierwszy dzień Paschy, w którym zgodnie ze zwyczajem zabijano i spożywano baranka, ");
INSERT INTO polsz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jezus wysłał Piotra i Jana mówiąc: —Idźcie przygotować dla nas kolację paschalną. ");
INSERT INTO polsz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—Gdzie to mamy zrobić?—zapytali. ");
INSERT INTO polsz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","—Gdy tylko wejdziecie do miasta—odrzekł Jezus—spotkacie mężczyznę z dzbanem wody. Pójdźcie za nim do domu, do którego się uda, ");
INSERT INTO polsz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","i powiedzcie właścicielowi: „Nasz Nauczyciel prosi, abyśmy obejrzeli pokój przygotowany dla nas na świąteczną kolację”. ");
INSERT INTO polsz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wtedy zaprowadzi was na górę, do dużego, wysprzątanego pomieszczenia. Tam przygotujcie posiłek. ");
INSERT INTO polsz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Poszli więc i zastali wszystko tak, jak powiedział Jezus. I zajęli się przygotowaniem kolacji. ");
INSERT INTO polsz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Gdy nadszedł czas, Jezus zajął miejsce przy stole. Przyszli również apostołowie. ");
INSERT INTO polsz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wtedy rzekł: —Tak bardzo pragnąłem spożyć z wami tę kolację paschalną, zanim będę cierpiał. ");
INSERT INTO polsz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Wiedzcie, że nie będę jej już spożywał aż do czasu, gdy odbędzie się w królestwie Bożym. ");
INSERT INTO polsz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Następnie wziął kielich z winem, podziękował za nie Bogu i rzekł: —Podajcie sobie ten kielich i pijcie. ");
INSERT INTO polsz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nie będę bowiem więcej pił tego wina, aż do czasu, gdy nadejdzie królestwo Boże. ");
INSERT INTO polsz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Potem wziął do rąk chleb, podziękował za niego Bogu, połamał go na kawałki, i podał uczniom mówiąc: —To jest moje ciało, które oddaję za was. Spożywajcie go, pamiętając o Mnie. ");
INSERT INTO polsz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Po posiłku podał im następny kielich z winem i rzekł: —Ten kielich jest nowym przymierzem. Przypieczętuję je przelewając własną krew, abyście otrzymali przebaczenie grzechów. ");
INSERT INTO polsz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ten, który Mnie zdradzi—dodał Jezus—siedzi teraz razem ze Mną przy stole. ");
INSERT INTO polsz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ja, Syn Człowieczy, muszę umrzeć, zgodnie z Bożym planem. Marny jednak los tego, kto Mnie wyda. ");
INSERT INTO polsz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Wtedy uczniowie starali się odgadnąć, który z nich miałby to zrobić. ");
INSERT INTO polsz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","W trakcie posiłku zaczęli się również sprzeczać ze sobą o to, kto z nich jest najważniejszy. ");
INSERT INTO polsz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Lecz Jezus powiedział im: —Wielcy tego świata nadużywają swojej władzy nad ludźmi, a rządzący chcą aby ich uznawano za „dobroczyńców ludu”. ");
INSERT INTO polsz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lecz wśród was powinno być inaczej. Najważniejszy niech postępuje jak najmniej ważny, a przywódca niech służy innym. ");
INSERT INTO polsz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kto waszym zdaniem jest ważniejszy: ten, który zasiada przy stole, czy ten, który mu służy? Czy nie ten pierwszy? Ja jestem wśród was tym, który służy. ");
INSERT INTO polsz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Pozostaliście Mi wierni w tych ciężkich dla Mnie dniach. ");
INSERT INTO polsz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Dlatego tak jak Ojciec postanowił dać mi królestwo, tak teraz ja postanawiam, ");
INSERT INTO polsz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","że będziecie w nim jeść i pić przy moim stole i zasiądziecie na tronach, sądząc dwanaście rodów Izraela. ");
INSERT INTO polsz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Następnie Jezus rzekł do Szymona Piotra: —Szymonie, szatan domagał się, aby was przesiać jak pszenicę i odrzucić plewy. ");
INSERT INTO polsz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ja jednak modliłem się, abyś nie załamał się w wierze. Gdy się więc opamiętasz, umacniaj wiarę innych wierzących we Mnie. ");
INSERT INTO polsz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","—Panie, jestem gotów iść z Tobą do więzienia, a nawet na śmierć!—odpowiedział Szymon. ");
INSERT INTO polsz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—Posłuchaj, Piotrze!—odparł Jezus. —Zanim jutro rano zapieje kogut, aż trzy razy zaprzeczysz, że Mnie znasz. ");
INSERT INTO polsz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Potem zapytał wszystkich: —Czy brakowało wam czegoś, gdy bez pieniędzy, bez torby i butów na zmianę wysłałem was, abyście głosili ludziom dobrą nowinę? —Nie, niczego—odpowiedzieli. ");
INSERT INTO polsz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—Teraz jednak—powiedział—kto z was ma pieniądze lub torbę, niech je weźmie. A kto nie ma pieniędzy, niech sprzeda swój płaszcz i kupi sobie miecz. ");
INSERT INTO polsz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Zapewniam was, że niebawem wypełni się proroctwo: „Zaliczono Go do grona przestępców”. Spełnią się również inne proroctwa o Mnie. ");
INSERT INTO polsz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","—Panie!—odpowiedzieli. —Mamy tutaj dwa miecze. —Wystarczy—odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Po kolacji, w towarzystwie uczniów, Jezus udał się jak zwykle na Górę Oliwną. ");
INSERT INTO polsz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Gdy tam dotarli, powiedział im: —Módlcie się, abyście się nie poddali pokusie! ");
INSERT INTO polsz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Potem oddalił się na pewną odległość, ukląkł i tak się modlił: ");
INSERT INTO polsz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Ojcze! Jeśli chcesz, oddal ode Mnie ten „kielich cierpienia”. Jednak to Twoja wola niech się stanie, a nie to, czego Ja chcę. ");
INSERT INTO polsz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","W tym momencie zstąpił z nieba anioł, by podnieść Go na duchu. ");
INSERT INTO polsz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Przeżywając ogromną udrękę, Jezus tak gorliwie się modlił, że Jego pot kapał na ziemię jak wielkie krople krwi. ");
INSERT INTO polsz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","W końcu podniósł się, wrócił do uczniów i zastał ich śpiących, byli bowiem bardzo przygnębieni. ");
INSERT INTO polsz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","—Dlaczego śpicie?!—zapytał. —Wstańcie i módlcie się, abyście się nie poddali pokusie! ");
INSERT INTO polsz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ledwie skończył mówić, nadeszła zgraja ludzi prowadzona przez Judasza, jednego z Dwunastu. Ten zbliżył się do Jezusa i przywitał Go pocałunkiem. ");
INSERT INTO polsz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","—Judaszu, pocałunkiem zdradzasz Mnie, Syna Człowieczego?—zapytał Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Widząc, na co się zanosi, pozostali uczniowie krzyknęli: —Mistrzu, czy mamy użyć miecza? ");
INSERT INTO polsz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","W tej samej chwili jeden z nich zamachnął się mieczem i odciął prawe ucho słudze najwyższego kapłana. ");
INSERT INTO polsz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","—Nie stawiajcie im oporu!—odpowiedział Jezus, po czym dotknął rany i uleczył ucho. ");
INSERT INTO polsz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Następnie zwrócił się do najwyższych kapłanów, dowódców straży świątynnej oraz starszych, którzy przyszli na to miejsce: —Czy jestem jakimś groźnym przestępcą, że przyszliście po Mnie aż tak uzbrojeni? ");
INSERT INTO polsz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Dlaczego nie zatrzymaliście Mnie w świątyni? Przecież codziennie byłem tam wśród was! Teraz jednak nadszedł wasz czas—czas władcy ciemności! ");
INSERT INTO polsz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Aresztowano więc Jezusa i zaprowadzono Go do rezydencji najwyższego kapłana. Piotr zaś szedł za Jezusem, trzymając się z daleka. ");
INSERT INTO polsz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na środku dziedzińca rozpalono ognisko i wszyscy usiedli przy nim. Przysiadł się tam również Piotr. ");
INSERT INTO polsz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nagle, w blasku płomieni, jakaś służąca dostrzegła jego twarz. Uważnie mu się przyjrzała i powiedziała: —Ten człowiek był z Jezusem! ");
INSERT INTO polsz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","—Kobieto, nawet Go nie znam!—zaprzeczył Piotr. ");
INSERT INTO polsz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Po chwili ktoś inny spojrzał na niego i rzekł: —Jesteś jednym z jego uczniów! —Człowieku! Nie jestem!—odparł Piotr. ");
INSERT INTO polsz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mniej więcej po godzinie ktoś inny stwierdził: —On jest jednym z nich. Przecież pochodzi z Galilei. ");
INSERT INTO polsz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","—Człowieku! Nie wiem, o czym mówisz!—zaprzeczył Piotr. W tej samej chwili, gdy jeszcze to mówił, zapiał kogut. ");
INSERT INTO polsz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jezus odwrócił się i spojrzał na Piotra, a on przypomniał sobie Jego słowa: „Zanim jutro rano zapieje kogut, aż trzy razy zaprzeczysz, że Mnie znasz”. ");
INSERT INTO polsz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Natychmiast opuścił dziedziniec i z żalu gorzko zapłakał. ");
INSERT INTO polsz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tymczasem strażnicy, pilnujący Jezusa, śmiali się z Niego. ");
INSERT INTO polsz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Zawiązali Mu oczy i bili Go, pytając: —Prorokuj! Zgadnij, kto Cię teraz uderzył? ");
INSERT INTO polsz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Obrzucali Go też wieloma wyzwiskami. ");
INSERT INTO polsz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Następnego dnia, wczesnym rankiem, zebrała się Wysoka Rada złożona ze starszych, najwyższych kapłanów i przywódców religijnych. Gdy wprowadzono przed nich Jezusa, ");
INSERT INTO polsz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","powiedzieli: —Jeśli jesteś Mesjaszem, powiedz nam to wprost. —Jeśli wam to powiem, nie uwierzycie Mi. ");
INSERT INTO polsz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A jeśli zapytam o powód, nie odpowiecie—odrzekł. ");
INSERT INTO polsz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","—Lecz nadszedł czas, abym Ja, Syn Człowieczy, zasiadł na tronie z Bogiem. ");
INSERT INTO polsz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","—Jesteś więc Synem Bożym?—zapytali. —Sami to potwierdzacie! Jestem Nim—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","—Czego więcej trzeba? Po co nam dowody? Sami słyszeliście, co powiedział!—zawołali. ");
INSERT INTO polsz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Wtedy wszyscy razem zaprowadzili Jezusa do Piłata, rzymskiego gubernatora, ");
INSERT INTO polsz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","i oskarżyli Go: —Stwierdziliśmy, że ten oto człowiek podburza nasz naród, bo zabrania ludziom płacenia podatków cezarowi i twierdzi, że jest naszym Mesjaszem i Królem. ");
INSERT INTO polsz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Na to Piłat zapytał: —Jesteś Królem Żydów? —Sam to potwierdzasz—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Wówczas Piłat zwrócił się do najwyższych kapłanów i tłumu: —Nie znajduję żadnej winy w tym człowieku! ");
INSERT INTO polsz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","—Przecież naucza po całej Judei i buntuje lud—upierali się. —Zaczął w Galilei i dotarł aż tutaj! ");
INSERT INTO polsz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Słysząc to, Piłat zapytał, czy Jezus rzeczywiście pochodzi z Galilei. ");
INSERT INTO polsz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Gdy to potwierdzono, odesłał Go do Heroda Antypasa, ponieważ Galilea podlegała jego jurysdykcji, a on sam akurat przebywał w Jerozolimie. ");
INSERT INTO polsz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod bardzo się ucieszył na widok Jezusa, bo wiele o Nim słyszał i już od dłuższego czasu chciał Go poznać. Spodziewał się, że na jego oczach Jezus dokona jakiegoś cudu. ");
INSERT INTO polsz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Zasypywał Go więc pytaniami, lecz On w ogóle nie odpowiadał. ");
INSERT INTO polsz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tymczasem obecni tam najwyżsi kapłani i przywódcy religijni bezlitośnie oskarżali Jezusa. ");
INSERT INTO polsz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","W końcu Herod ze swoimi żołnierzami zaczął wyśmiewać Go. Ubrał Jezusa w królewski płaszcz i z powrotem odesłał do Piłata. ");
INSERT INTO polsz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Od tego dnia Herod i Piłat stali się przyjaciółmi, mimo że dotychczas byli do siebie wrogo nastawieni. ");
INSERT INTO polsz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Piłat zwołał najwyższych kapłanów, członków Rady oraz lud ");
INSERT INTO polsz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","i rzekł: —Przyprowadziliście do mnie tego człowieka, oskarżając go o podburzanie ludu przeciwko rzymskiej władzy. W waszej obecności przesłuchałem go jednak i nie znalazłem w nim żadnej winy, ");
INSERT INTO polsz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","podobnie jak Herod, który odesłał go do mnie. Stwierdzam więc, że nie zrobił nic, co zasługuje na karę śmierci. ");
INSERT INTO polsz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Każę go więc wychłostać i wypuszczę. ");
INSERT INTO polsz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Był bowiem zobowiązany zwolnić jakiegoś więźnia z okazji święta. ");
INSERT INTO polsz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wszyscy zaczęli jednak krzyczeć: —Nie! Jego zabij, a wypuść nam Barabasza! ");
INSERT INTO polsz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasz zaś był uwięziony za wywołanie w Jerozolimie rozruchów oraz za morderstwo. ");
INSERT INTO polsz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ponieważ Piłat chciał uwolnić Jezusa, ponownie przedstawił im swoje stanowisko. ");
INSERT INTO polsz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lecz oni nalegali, wołając: —Ukrzyżuj, ukrzyżuj go! ");
INSERT INTO polsz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","—Co złego uczynił?—zapytał ich więc już po raz trzeci. —Ja nie znalazłem żadnego powodu, aby skazać go na śmierć. Każę go wychłostać i wypuszczę. ");
INSERT INTO polsz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lecz tłum coraz głośniej domagał się ukrzyżowania Jezusa. ");
INSERT INTO polsz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","W końcu Piłat uległ ich żądaniu i wydał wyrok. ");
INSERT INTO polsz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wypuścił z więzienia Barabasza, skazanego za wywołanie rozruchów i morderstwo, a Jezusa oddał w ich ręce. ");
INSERT INTO polsz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tłum poprowadził więc Jezusa na miejsce egzekucji. Tą samą drogą wracał właśnie z pola do Jerozolimy niejaki Szymon z Cyreny. Żołnierze zmusili go do niesienia za Jezusem Jego krzyża. ");
INSERT INTO polsz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A podążały za nimi ogromne tłumy, wśród nich wiele kobiet, rozpaczających nad losem Jezusa. ");
INSERT INTO polsz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","On w pewnym momencie odwrócił się i rzekł do nich: —Kobiety z Jerozolimy! Nie płaczcie nade Mną, ale nad sobą i waszymi dziećmi. ");
INSERT INTO polsz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nadchodzą bowiem dni, gdy będą mówić: „Szczęśliwe są bezpłodne kobiety i te, które jeszcze nie rodziły i nie karmiły”. ");
INSERT INTO polsz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ludzie będą wtedy ze strachu błagać góry i pagórki: „Padnijcie na nas i zasypcie na zawsze”. ");
INSERT INTO polsz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jeśli takie rzeczy robią z żywym jeszcze drzewem, to jak potraktują drzewo suche? ");
INSERT INTO polsz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Razem z Jezusem prowadzono na śmierć dwóch przestępców. ");
INSERT INTO polsz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Gdy dotarli na miejsce zwane Czaszką, ukrzyżowali ich wszystkich—Jezusa w środku, a dwóch skazanych po Jego prawej i lewej stronie. ");
INSERT INTO polsz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jezus modlił się: —Ojcze, przebacz im, bo nie wiedzą, co robią. Ci zaś, którzy Go ukrzyżowali, rzucili losy o Jego ubranie, aby ustalić, co kto ma wziąć. ");
INSERT INTO polsz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Całej egzekucji przyglądał się niemały tłum, a przywódcy naśmiewali się z Jezusa: —Innych potrafił ratować, niech więc teraz uratuje siebie, skoro jest Mesjaszem, Bożym wybrańcem! ");
INSERT INTO polsz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Również żołnierze, podając Mu kwaśne wino, śmiali się z Niego: ");
INSERT INTO polsz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Jeśli jesteś Królem Żydów, uratuj się! ");
INSERT INTO polsz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nad głową Jezusa znajdowała się bowiem tabliczka z napisem: „To jest król Żydów”. ");
INSERT INTO polsz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jeden z przestępców, wiszących obok Jezusa, również naśmiewał się z Niego: —Przecież jesteś Mesjaszem! Ratuj się więc! A przy okazji nas! ");
INSERT INTO polsz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","—Czy dlatego nie boisz się już Boga, że zostałeś skazany razem z Jezusem?—upomniał go drugi. ");
INSERT INTO polsz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","—My za swoje czyny zasłużyliśmy na śmierć, ale On nie uczynił nic złego. ");
INSERT INTO polsz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jezusie, pamiętaj o mnie, gdy znajdziesz się w swoim królestwie!—dodał. ");
INSERT INTO polsz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","—Zapewniam cię, że jeszcze dziś będziesz ze Mną w raju—odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nagle, około południa, całą ziemię okrył mrok i aż do godziny trzeciej było ciemno. ");
INSERT INTO polsz_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Słońce utraciło swój blask, a zasłona w świątyni, oddzielająca miejsce najświętsze, rozdarła się na dwie części. ");
INSERT INTO polsz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Wtedy Jezus głośno zawołał: —Ojcze, Tobie oddaję mojego ducha!—i po tych słowach skonał. ");
INSERT INTO polsz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","A rzymski dowódca, widząc, co się dzieje, oddał chwałę Bogu, mówiąc: —To był prawy człowiek! ");
INSERT INTO polsz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ludzie, którzy tłumnie zebrali się, aby zobaczyć ukrzyżowanie Jezusa, wracali do domu w głębokim smutku. ");
INSERT INTO polsz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Natomiast przyjaciele Jezusa—wśród nich kobiety, które towarzyszyły Mu aż od Galilei—przyglądali się wszystkiemu z daleka. ");
INSERT INTO polsz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Był wśród nich Józef, dobry i prawy człowiek, pochodzący z judejskiego miasta—Arymatei. Oczekiwał on nadejścia królestwa Bożego. Mimo że sam był członkiem Wysokiej Rady, sprzeciwiał się jej decyzjom oraz działaniom. ");
INSERT INTO polsz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Po śmierci Jezusa udał się do Piłata z prośbą o wydanie mu Jego ciała. ");
INSERT INTO polsz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Następnie zdjął je z krzyża, owinął w długie lniane płótno i złożył w nieużywanym dotąd grobie, który był wykuty w skale. ");
INSERT INTO polsz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Był to piątkowy wieczór, czas przygotowania do szabatu. ");
INSERT INTO polsz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kobiety z Galilei, które towarzyszyły wcześniej Jezusowi, obejrzały grób oraz jak złożono Jego ciało. ");
INSERT INTO polsz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Gdy wróciły do domu, przygotowały wonne zioła i olejki do namaszczania zwłok. W czasie szabatu jednak, zgodnie z przepisami religijnymi, nie mogły zajmować się zmarłym. ");
INSERT INTO polsz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dopiero w niedzielę, wczesnym ranem, zaniosły do grobu przygotowane olejki. ");
INSERT INTO polsz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Zobaczyły, że głaz zamykający wejście jest odsunięty. ");
INSERT INTO polsz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Weszły więc do wnętrza, ale nie znalazły ciała Jezusa. ");
INSERT INTO polsz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Stały oszołomione, gdy nagle obok nich zjawili się dwaj mężczyźni, ubrani w lśniące szaty. ");
INSERT INTO polsz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Przerażone, pokłoniły się im nisko. Oni zaś zapytali: —Dlaczego szukacie w grobie Tego, który żyje? ");
INSERT INTO polsz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nie ma Go tutaj. Powstał z martwych! Przypomnijcie sobie, jak wam mówił, będąc jeszcze w Galilei, ");
INSERT INTO polsz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","że Syn Człowieczy zostanie wydany w ręce grzesznych ludzi i zabity przez nich, ale trzeciego dnia zmartwychwstanie. ");
INSERT INTO polsz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Wtedy przypomniały sobie te słowa. ");
INSERT INTO polsz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wróciły do Jerozolimy i opowiedziały o wszystkim jedenastu apostołom i pozostałym uczniom. ");
INSERT INTO polsz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","A były to: Maria z Magdali, Joanna, Maria (matka Jakuba) oraz kilka innych kobiet. ");
INSERT INTO polsz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Słuchający sądzili jednak, że to jakaś zmyślona historia, i nie uwierzyli im. ");
INSERT INTO polsz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mimo to, Piotr pobiegł jednak do grobowca. Zajrzał do środka i zobaczył same płótna. Wrócił więc do domu, zdziwiony tym, co zaszło. ");
INSERT INTO polsz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jeszcze tego samego dnia dwaj uczniowie Jezusa szli do wioski Emaus, odległej o jedenaście kilometrów od Jerozolimy, ");
INSERT INTO polsz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","i rozmawiali o ostatnich wydarzeniach. ");
INSERT INTO polsz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Gdy tak żywo dyskutowali, sam Jezus podszedł i przyłączył się do nich. ");
INSERT INTO polsz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Oni jednak nie rozpoznali Go. ");
INSERT INTO polsz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","—O czym rozmawiacie?—zapytał. Wtedy ze smutku przystanęli ");
INSERT INTO polsz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","i jeden z nich, Kleofas, powiedział: —Jesteś chyba jedyną osobą w całej Jerozolimie, która nie słyszała o wydarzeniach z ostatnich kilku dni. ");
INSERT INTO polsz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—A o czym nie wiem?—zapytał Jezus. —O tym, co się stało z Jezusem z Nazaretu—odrzekli. —Był On prorokiem, potężnym w czynie i słowie, cieszącym się uznaniem Boga i ludzi. ");
INSERT INTO polsz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nasi najwyżsi kapłani i przywódcy religijni wydali Go jednak Rzymianom, którzy skazali Go na śmierć i ukrzyżowali. ");
INSERT INTO polsz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","A my mieliśmy nadzieję, że to właśnie On jest Mesjaszem, mającym wyzwolić Izrael. Dziś mija już trzeci dzień od tych wydarzeń. ");
INSERT INTO polsz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Na dodatek kilka kobiet wprawiło nas w osłupienie. Powiedziały, że były o świcie przy grobowcu, ");
INSERT INTO polsz_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ale nie znalazły Jego ciała. Ponadto widziały tam aniołów twierdzących, że Jezus żyje. ");
INSERT INTO polsz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Niektórzy z nas pobiegli tam zaraz i zastali wszystko tak, jak powiedziały kobiety: ciała rzeczywiście nie było. ");
INSERT INTO polsz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wtedy Jezus rzekł im: —Jacy jesteście niemądrzy! Tak trudno uwierzyć wam w to, co prorocy powiedzieli w Piśmie! ");
INSERT INTO polsz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Przecież Mesjasz miał to wszystko wycierpieć, zanim zostanie otoczony chwałą! ");
INSERT INTO polsz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","I zaczynając od pism Mojżesza i proroków, wyjaśniał im wszystkie fragmenty Pisma, które mówiły o Nim jako Mesjaszu. ");
INSERT INTO polsz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Gdy doszli do Emaus, Jezus dał do zrozumienia, że idzie dalej. ");
INSERT INTO polsz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Oni jednak nalegali: —Zostań z nami na noc. Jest już późno i robi się ciemno. Wszedł więc z nimi do domu. ");
INSERT INTO polsz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","A gdy zasiedli do kolacji, wziął chleb, podziękował za niego Bogu, połamał go na kawałki i podał im. ");
INSERT INTO polsz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Wtedy przejrzeli na oczy i rozpoznali Go, ale On zniknął. ");
INSERT INTO polsz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Zaczęli więc mówić jeden do drugiego: —Czy serce nie biło nam mocniej, gdy podczas drogi rozmawiał z nami i wyjaśniał Pismo? ");
INSERT INTO polsz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jeszcze tej samej godziny wyruszyli z powrotem do Jerozolimy. Tam spotkali zebranych jedenastu apostołów i pozostałych uczniów, ");
INSERT INTO polsz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","którzy potwierdzili, że Jezus rzeczywiście zmartwychwstał i że ukazał się Piotrowi. ");
INSERT INTO polsz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wówczas ci dwaj opowiedzieli im o swoim spotkaniu z Jezusem i o tym, jak rozpoznali Go podczas łamania chleba. ");
INSERT INTO polsz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Gdy jeszcze mówili, sam Jezus nagle stanął pośród nich i powiedział: —Pokój wam! ");
INSERT INTO polsz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wszyscy się bardzo przestraszyli, sądząc, że widzą ducha. ");
INSERT INTO polsz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","—Czemu jesteście tacy przerażeni?—zapytał. —Dlaczego wątpicie, że to jestem Ja? ");
INSERT INTO polsz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Zobaczcie rany na moich rękach i nogach! Przecież to Ja, we własnej osobie! Dotknijcie Mnie, a przekonacie się, że nie jestem duchem. Duch przecież nie ma ciała ani kości, a Ja mam! ");
INSERT INTO polsz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mówiąc to, pokazał im swoje ręce i nogi. ");
INSERT INTO polsz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Uczniowie byli tak szczęśliwi i zdziwieni, że aż nie mogli uwierzyć w to, co widzieli. Wtedy Jezus zapytał ich: —Czy macie tu coś do jedzenia? ");
INSERT INTO polsz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Podali Mu więc kawałek pieczonej ryby, ");
INSERT INTO polsz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","a On zjadł ją na ich oczach. ");
INSERT INTO polsz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Następnie powiedział do uczniów: —Gdy jeszcze przed ukrzyżowaniem byłem z wami, mówiłem, że musi się spełnić to, co jest o Mnie napisane w Prawie Mojżesza, pismach proroków i w Psalmach. ");
INSERT INTO polsz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wtedy rozjaśnił ich umysły, by to wszystko zrozumieli. ");
INSERT INTO polsz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","I dodał: —Napisane jest, że Mesjasz będzie cierpiał, że umrze i trzeciego dnia powstanie z martwych. ");
INSERT INTO polsz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Wszystkie narody, począwszy od Jerozolimy, będą w Jego imieniu wzywane do opamiętania i przyjęcia odpuszczenia grzechów. ");
INSERT INTO polsz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Wy jesteście świadkami spełnienia się tych proroctw. ");
INSERT INTO polsz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Już niedługo ześlę wam to, co obiecał mój Ojciec. Na razie pozostańcie tu, w mieście, aż napełni was moc z nieba. ");
INSERT INTO polsz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Potem wyprowadził uczniów z miasta w stronę Betanii. Wzniósł ręce i pobłogosławił ich. ");
INSERT INTO polsz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Czyniąc to, zaczął unosić się w górę i tak odszedł do nieba. ");
INSERT INTO polsz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Oni zaś oddali Mu pokłon i pełni radości powrócili do Jerozolimy, ");
INSERT INTO polsz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","gdzie przez cały czas przebywali w świątyni i wielbili Boga.");
INSERT INTO polsz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na początku było Słowo. Było ono u Boga i było Bogiem. ");
INSERT INTO polsz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Od samego początku było razem z Bogiem. ");
INSERT INTO polsz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ono powołało wszystko do istnienia. I nic, co zostało stworzone, nie zaistniało bez Niego. ");
INSERT INTO polsz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","W Nim było życie, a życie jest dla ludzi światłem. ");
INSERT INTO polsz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","To Światło świeci w ciemnościach, a mrok nie był w stanie Go pochłonąć. ");
INSERT INTO polsz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bóg posłał swojego człowieka, imieniem Jan, ");
INSERT INTO polsz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","aby powiedział ludziom o prawdziwym Świetle i aby dzięki niemu wszyscy uwierzyli. ");
INSERT INTO polsz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Sam Jan nie był Światłem, lecz miał o Nim opowiedzieć. ");
INSERT INTO polsz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","I nadeszło prawdziwe Światło, które oświeca każdego człowieka, przychodzącego na świat. ");
INSERT INTO polsz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pojawiło się na świecie, który dzięki Niemu powstał, ale świat Go nie rozpoznał. ");
INSERT INTO polsz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Przyszło do swojej własności, ale swoi Go nie przyjęli. ");
INSERT INTO polsz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tym jednak, którzy Je przyjęli, i uwierzyli Mu dało prawo stać się dziećmi Bożymi, ");
INSERT INTO polsz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","które narodziły się nie fizycznie —w wyniku namiętności czy ludzkich planów—ale z Boga. ");
INSERT INTO polsz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Słowo stało się ciałem i jako człowiek zamieszkało wśród nas. Ujrzeliśmy więc Jego chwałę—chwałę, jaką Ojciec obdarzył swojego jedynego Syna, pełnego łaski i prawdy. ");
INSERT INTO polsz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jan Chrzciciel powiedział o Nim, wołając do zebranych wokół niego ludzi: —To właśnie o Nim mówiłem: „Nadchodzi ktoś większy ode mnie, bo istniał wcześniej niż ja!”. ");
INSERT INTO polsz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Z Jego bogactwa wszyscy otrzymaliśmy wiele łask. ");
INSERT INTO polsz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mojżesz dał nam Prawo, natomiast dzięki Jezusowi Chrystusowi nadeszła łaska i prawda. ");
INSERT INTO polsz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Boga nikt nigdy nie widział, a pokazał Go nam Jedyny Syn—Bóg, który stanowi jedno z Ojcem. ");
INSERT INTO polsz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Żydowscy przywódcy z Jerozolimy wysłali do Jana Chrzciciela kapłanów i ich pomocników z pytaniem: —Kim właściwie jesteś? ");
INSERT INTO polsz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wtedy on jednoznacznie i dobitnie odpowiedział: —Nie jestem Mesjaszem! ");
INSERT INTO polsz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","—No to kim? Eliaszem?—pytali. —Nie. —To może prorokiem? —Też nie—odpowiedział Jan. ");
INSERT INTO polsz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—Kim więc jesteś? Co mamy powiedzieć tym, którzy nas wysłali? Co możesz o sobie powiedzieć?—dopytywali go. ");
INSERT INTO polsz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","—Jak powiedział prorok Izajasz: „Jestem głosem wołającego na pustyni: Przygotujcie Panu drogę!”—odrzekł Jan. ");
INSERT INTO polsz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Niektórzy wysłannicy, należący do ugrupowania faryzeuszy, ");
INSERT INTO polsz_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","zapytali go: —Dlaczego więc chrzcisz, skoro nie jesteś ani Mesjaszem, ani Eliaszem, ani prorokiem? ");
INSERT INTO polsz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","—Ja zanurzam tylko w wodzie—odparł Jan. —Lecz niebawem nadejdzie ktoś, kto już jest wśród was, ale na razie nie dał się wam poznać. Ja nie jestem nawet godzien zdjąć Mu butów! ");
INSERT INTO polsz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Miało to miejsce po drugiej stronie Jordanu, w Betanii, gdzie Jan udzielał ludziom chrztu. ");
INSERT INTO polsz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Następnego dnia Jan ujrzał nadchodzącego Jezusa i rzekł: —Oto Baranek, którego Bóg złoży w ofierze, aby usunąć grzech świata! ");
INSERT INTO polsz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","To Jego miałem na myśli mówiąc, że „nadchodzi ktoś większy ode mnie, bo istniał wcześniej niż ja!”. ");
INSERT INTO polsz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nie wiedziałem, że to On, ale po to właśnie przyszedłem i zacząłem chrzcić ludzi, aby ogłosić Izraelowi Jego nadejście. ");
INSERT INTO polsz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jan kontynuował: —Widziałem Ducha, który zstąpił na Niego z nieba jak gołąb. ");
INSERT INTO polsz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nie wiedziałem, że to On, ale Bóg, który mnie posłał, abym zanurzał ludzi w wodzie, powiedział: „Ten, na którego zstąpi Duch i spocznie na Nim, będzie zanurzał ludzi w Duchu Świętym”. ");
INSERT INTO polsz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Widziałem to i dlatego oświadczam, że On jest Synem Boga! ");
INSERT INTO polsz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Następnego dnia Jan stał z dwoma uczniami. ");
INSERT INTO polsz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Gdy zobaczył idącego Jezusa, powiedział: —Oto Baranek, którego Bóg złoży w ofierze! ");
INSERT INTO polsz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Obaj uczniowie usłyszeli to i poszli za Jezusem. ");
INSERT INTO polsz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","On obejrzał się i widząc, że za Nim idą, zapytał: —Czego szukacie? —Rabbi! (to znaczy: „Nauczycielu!”). Gdzie się zatrzymałeś na nocleg?—zapytali. ");
INSERT INTO polsz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Chodźcie i zobaczcie—odpowiedział Jezus. Poszli więc z Nim, a ponieważ było już około czwartej po południu, zostali u Niego do końca dnia. ");
INSERT INTO polsz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jednym z nich był Andrzej, brat Szymona Piotra. ");
INSERT INTO polsz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Odszukał on później Szymona i powiedział: —Znaleźliśmy Mesjasza! (to znaczy: „Chrystusa”). ");
INSERT INTO polsz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","I zaprowadził go do Jezusa, a On spojrzał na niego i rzekł: —Ty jesteś Szymon, syn Jana. Ale od teraz będziesz się nazywał Kefas (to znaczy: „Piotr”—„skała”). ");
INSERT INTO polsz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Następnego dnia Jezus postanowił pójść do Galilei. Po drodze spotkał Filipa i rzekł do niego: —Chodź ze Mną. ");
INSERT INTO polsz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip pochodził z Betsaidy, rodzinnego miasteczka Andrzeja i Piotra. ");
INSERT INTO polsz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Spotkał on później Natanaela i powiedział mu: —Znaleźliśmy Tego, o którym pisał Mojżesz i prorocy! To Jezus, syn Józefa z Nazaretu! ");
INSERT INTO polsz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—Z Nazaretu?!—zdziwił się Natanael. —Czy stamtąd może pochodzić coś dobrego? —Sam się przekonaj!—odrzekł Filip. ");
INSERT INTO polsz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Gdy zbliżali się do Jezusa, On zobaczył Natanaela i powiedział: —Oto prawdziwy Izraelita, w którym nie ma fałszu. ");
INSERT INTO polsz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","—Skąd mnie znasz?—zdumiał się Natanael. —Widziałem cię pod drzewem figowym, zanim spotkał cię Filip—odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Nauczycielu! Jesteś Synem Boga! Jesteś Królem Izraela! ");
INSERT INTO polsz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","—Wierzysz w to, ponieważ powiedziałem, że widziałem cię, gdy byłeś pod drzewem figowym?—odparł Jezus. —Ujrzysz jeszcze więcej! ");
INSERT INTO polsz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Zapewniam was: Zobaczycie otwarte niebo i aniołów Boga wstępujących i zstępujących na Mnie, Syna Człowieczego. ");
INSERT INTO polsz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dwa dni później, w Kanie Galilejskiej, odbywało się wesele, w którym uczestniczyła matka Jezusa. ");
INSERT INTO polsz_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Zaproszono na nie również Jezusa i Jego uczniów. ");
INSERT INTO polsz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","I zdarzyło się tak, że zabrakło wina. Matka powiedziała o tym Jezusowi: —Nie mają już wina. ");
INSERT INTO polsz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—To chyba nie jest ani mój, ani twój problem—odpowiedział. —Jeszcze nie przyszła na Mnie pora. ");
INSERT INTO polsz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ona jednak poleciła służbie: —Zróbcie wszystko, co wam powie. ");
INSERT INTO polsz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","A stało tam sześć kamiennych dzbanów, przygotowanych do żydowskiego obrzędu oczyszczenia. Każdy z nich mógł pomieścić jakieś osiemdziesiąt lub sto litrów. ");
INSERT INTO polsz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jezus powiedział więc: —Napełnijcie je wodą. A gdy słudzy nalali wody aż po brzegi, dodał: ");
INSERT INTO polsz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","—Zaczerpnijcie teraz i zanieście gospodarzowi wesela. ");
INSERT INTO polsz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Gdy gospodarz skosztował wody przemienionej w wino (nie wiedząc, skąd się wzięło, choć słudzy wiedzieli), zawołał pana młodego i rzekł: ");
INSERT INTO polsz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Zazwyczaj najpierw podaje się lepsze wino. Później, gdy goście już sobie podpiją—trochę gorsze. A ty najlepsze zostawiłeś na koniec. ");
INSERT INTO polsz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","W ten oto sposób w Kanie Galilejskiej Jezus dokonał pierwszego cudu. Objawił przez to swoją chwałę i uwierzyli w Niego Jego uczniowie. ");
INSERT INTO polsz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Po weselu, razem z matką, braćmi i uczniami udał się na kilka dni do Kafarnaum. ");
INSERT INTO polsz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ponieważ zbliżało się święto Paschy, Jezus poszedł do Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","W świątyni natknął się na kupców sprzedających bydło, owce i gołębie ofiarne. Spotkał tam też ludzi zajmujących się wymianą pieniędzy. ");
INSERT INTO polsz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Zrobił więc sobie bicz ze sznurów i zaczął wszystkich wyganiać ze świątyni—zwierzęta też. Powywracał stoły wymieniających pieniądze i porozrzucał monety. ");
INSERT INTO polsz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sprzedającym gołębie rozkazał: —Zabierajcie się stąd! Nie róbcie targowiska z domu mojego Ojca! ");
INSERT INTO polsz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wtedy uczniowie przypomnieli sobie słowa Pisma: „Jestem pochłonięty troską o Twój dom”. ");
INSERT INTO polsz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Żydowscy przywódcy dopytywali Jezusa: —Jakim prawem wyrzuciłeś ze świątyni sprzedawców? Czy uwiarygodnisz to jakimś znakiem z nieba? ");
INSERT INTO polsz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","—Tak—odpowiedział Jezus. —Zburzcie tę świątynię, a Ja w trzy dni ją odbuduję. ");
INSERT INTO polsz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—Co takiego?!—wykrzyknęli. —Budowano ją czterdzieści sześć lat, a ty odbudujesz ją w trzy dni?! ");
INSERT INTO polsz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lecz Jezus, mówiąc o świątyni, miał na myśli własne ciało. ");
INSERT INTO polsz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Gdy zmartwychwstał, uczniowie przypomnieli sobie tę wypowiedź i uwierzyli Pismu i słowom Jezusa. ");
INSERT INTO polsz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","W czasie tego święta wielu ludzi uwierzyło w Niego. Widzieli bowiem cuda, jakie czynił w Jerozolimie. ");
INSERT INTO polsz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ale Jezus nie ufał im, bo znał serca wszystkich ludzi. ");
INSERT INTO polsz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nie potrzebował też, aby ktoś Go przekonywał o swoich intencjach. Dokładnie bowiem wiedział, co się kryje w każdym człowieku. ");
INSERT INTO polsz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wśród faryzeuszy był pewien człowiek imieniem Nikodem, który był żydowskim przywódcą. ");
INSERT INTO polsz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Pewnej nocy przyszedł do Jezusa i powiedział: —Nauczycielu! Wiemy, że zostałeś posłany przez Boga, bo nikt nie mógłby czynić takich cudów, jakie Ty czynisz, gdyby On go nie posłał. ");
INSERT INTO polsz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","—Zapewniam cię—rzekł Jezus—że jeśli się ktoś nie narodzi na nowo, nie ujrzy królestwa Bożego. ");
INSERT INTO polsz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—Urodzić się na nowo?—zdumiał się Nikodem. —Będąc starcem? Czy można powtórnie wejść do łona matki i urodzić się? ");
INSERT INTO polsz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","—Jeszcze raz cię zapewniam—powtórzył Jezus—że jeśli człowiek nie narodzi się z wody i z Ducha, nie wejdzie do królestwa Bożego. ");
INSERT INTO polsz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kto się narodził fizycznie, żyje tylko fizycznie. Kto się jednak narodził z Ducha, żyje także duchowo! ");
INSERT INTO polsz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nie dziw się więc, że powiedziałem, iż trzeba się narodzić na nowo. ");
INSERT INTO polsz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wiatr wieje, gdzie chce. Słyszysz go, ale nie wiesz, skąd i dokąd wieje. Podobnie jest z narodzeniem z Ducha—widzisz skutki, ale nie widzisz przyczyny. ");
INSERT INTO polsz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—Ale jak to się dzieje?—pytał dalej Nikodem. ");
INSERT INTO polsz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","—Jesteś nauczycielem narodu i nie wiesz tego?—odparł Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","—Zapewniam cię, że mówię o tym, co dobrze znam i co sam widziałem, ale wy nie uznajecie tego. ");
INSERT INTO polsz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Jeśli nie wierzycie w to, co mówię o sprawach ziemskich, to jak uwierzycie w to, co powiem o sprawach niebiańskich? ");
INSERT INTO polsz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nikt jednak nie wstąpił do nieba oprócz Mnie, Syna Człowieczego. Stamtąd bowiem przyszedłem. ");
INSERT INTO polsz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Podobnie jak wąż, który na pustyni został podniesiony w górę przez Mojżesza, tak i Ja, Syn Człowieczy, również muszę zostać podniesiony w górę, ");
INSERT INTO polsz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","aby każdy, kto Mi uwierzy, otrzymał życie wieczne. ");
INSERT INTO polsz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tak bowiem Bóg ukochał świat, że oddał swojego jedynego Syna, aby każdy, kto Mu uwierzy, nie zginął, ale miał życie wieczne. ");
INSERT INTO polsz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Bóg nie posłał Syna, aby potępił świat, lecz aby go zbawił. ");
INSERT INTO polsz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ten, kto Mu wierzy, nie podlega potępieniu. Ale ten, kto Mu nie wierzy, już został osądzony, bo nie uwierzył jedynemu Synowi Bożemu. ");
INSERT INTO polsz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wyrok taki zapadł dlatego, że chociaż na świat przyszło światło, ludzie bardziej pokochali ciemność, bo ich czyny były złe. ");
INSERT INTO polsz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ten, kto czyni zło, nienawidzi światła i nie zbliża się do niego, aby nie wyszły na jaw jego czyny. ");
INSERT INTO polsz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kto zaś postępuje zgodnie z prawdą, zbliża się do światła, aby ujawniły się jego czyny, które podobają się Bogu. ");
INSERT INTO polsz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jakiś czas później Jezus wraz z uczniami udał się na tereny Judei. Zatrzymał się tam i udzielał ludziom chrztu. ");
INSERT INTO polsz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Niedaleko Salim, w Ainon, przebywał również Jan Chrzciciel. On także chrzcił, bo w tych okolicach było dużo wody i wielu ludzi przychodziło do niego, aby ich w niej zanurzył. ");
INSERT INTO polsz_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","W tym czasie Jan był bowiem jeszcze na wolności. ");
INSERT INTO polsz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pewnego dnia ktoś posprzeczał się z uczniami Jana o sprawy dotyczące rytualnych oczyszczeń. ");
INSERT INTO polsz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Przyszli więc do Jana i zapytali: —Nauczycielu! Ten, którego spotkałeś na drugim brzegu Jordanu i o którym powiedziałeś, że jest Mesjaszem, także chrzci i teraz wszyscy idą do Niego. ");
INSERT INTO polsz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","—Nikt nie może wziąć czegoś, czego nie otrzymał z nieba—odpowiedział Jan. ");
INSERT INTO polsz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","—Sami możecie potwierdzić, że powiedziałem: „Nie jestem Mesjaszem. Zostałem tylko wysłany przed Nim”. ");
INSERT INTO polsz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Panna młoda należy przecież do pana młodego. A przyjaciel pana młodego cieszy się z tego, że może przy nim stać i słuchać go. Obecnie w całej pełni doświadczam takiej właśnie radości. ");
INSERT INTO polsz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Teraz On będzie się stawał coraz ważniejszy, ja zaś muszę schodzić ze sceny. ");
INSERT INTO polsz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ten, kto przychodzi z góry, przewyższa wszystkich. Ten zaś, kto pochodzi z ziemi, jest ograniczony do rzeczy ziemskich. ");
INSERT INTO polsz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ten, kto przybywa z nieba, mówi o tym, co widział i słyszał w niebie. Ludzie nie chcą Go słuchać, ");
INSERT INTO polsz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ci jednak, którzy Mu uwierzyli, uznali, że Bóg mówi prawdę. ");
INSERT INTO polsz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ten bowiem, kto został wysłany przez Boga, przemawia w Jego imieniu. A Bóg w pełni obdarza Go swoim Duchem. ");
INSERT INTO polsz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ojciec kocha Syna i wszystko Mu powierzył. ");
INSERT INTO polsz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ten, kto wierzy Synowi Bożemu, ma życie wieczne. Ten zaś, kto Mu nie wierzy, nawet nie ujrzy tego życia—przeciwnie: zobaczy gniew Boga. ");
INSERT INTO polsz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Wkrótce Jezus otrzymał wiadomość, że faryzeusze już wiedzą, iż pozyskuje i chrzci więcej uczniów niż Jan ");
INSERT INTO polsz_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(chociaż Jezus osobiście nikogo nie chrzcił, ale czynili to Jego uczniowie). ");
INSERT INTO polsz_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Dlatego opuścił Judeę i skierował się do Galilei. ");
INSERT INTO polsz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Chciał jednak przejść przez Samarię. ");
INSERT INTO polsz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Zbliżył się więc do samarytańskiego miasteczka Sychar, położonego w pobliżu terenów, które dawno temu patriarcha Jakub przekazał swojemu synowi, Józefowi. ");
INSERT INTO polsz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Znajdowała się tam studnia Jakuba. Zmęczony drogą, Jezus usiadł przy niej, a było to samo południe. ");
INSERT INTO polsz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Wtedy właśnie przyszła tam po wodę pewna Samarytanka. Jezus poprosił ją: —Możesz dać Mi się napić? ");
INSERT INTO polsz_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Uczniowie w tym czasie poszli do miasteczka kupić coś do jedzenia. ");
INSERT INTO polsz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kobieta odrzekła: —Prosisz mnie o wodę?! Przecież Żydzi i Samarytanie nawet z sobą nie rozmawiają. ");
INSERT INTO polsz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","—Gdybyś wiedziała, jak wspaniały dar przygotował Bóg dla ludzi oraz kto do ciebie mówi, prosiłabyś Go, a dałby ci wodę życia—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Panie, przecież nie masz nawet czym zaczerpnąć wody, a studnia jest głęboka. Skąd więc weźmiesz tę wodę życia? ");
INSERT INTO polsz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Czyżbyś był większy od naszego przodka Jakuba, który dał nam tę studnię? On sam pił z niej wodę, a także jego dzieci oraz całe jego stada. ");
INSERT INTO polsz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","—Każdy, kto pije tę wodę, po jakimś czasie znowu będzie mieć pragnienie—odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","—Ale kto napije się mojej wody, już nigdy nie będzie spragniony. Wręcz przeciwnie! Moja woda wytryśnie z niego i stanie się źródłem życia wiecznego. ");
INSERT INTO polsz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Panie, daj mi więc tej wody—poprosiła kobieta—abym już nie była spragniona i nie musiała przychodzić do tej studni. ");
INSERT INTO polsz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Idź najpierw i przyprowadź męża—rzekł do niej Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Nie mam męża—odparła. —Słusznie mówisz: „Nie mam męża”. ");
INSERT INTO polsz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Miałaś bowiem pięciu mężów, a mężczyzna, z którym teraz żyjesz, nie jest twoim mężem. Powiedziałaś więc prawdę. ");
INSERT INTO polsz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Panie, widzę, że jesteś prorokiem!—powiedziała. ");
INSERT INTO polsz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","—Nasi przodkowie czcili Boga na tej górze. A wy, Żydzi, twierdzicie, że Jerozolima jest właściwym miejscem oddawania Mu czci. ");
INSERT INTO polsz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—Uwierz Mi, kobieto, że nadchodzi czas, gdy ani na tej górze, ani w Jerozolimie nie będziecie czcili Ojca. ");
INSERT INTO polsz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Wy nie wiecie, kim jest Ten, komu oddajecie cześć. My znamy Go, bo zbawienie wywodzi się od Żydów. ");
INSERT INTO polsz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nadchodzi jednak czas—właściwie już nadszedł—gdy prawdziwi czciciele Ojca będą oddawać Mu cześć w duchu i w prawdzie. Właśnie takich czcicieli On pragnie. ");
INSERT INTO polsz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Bóg jest duchem. Dlatego ci, którzy oddają Mu cześć, mają to robić w duchu i w prawdzie. ");
INSERT INTO polsz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","—Wiem, że pewnego dnia ma przyjść Mesjasz (to znaczy: „Chrystus”)—odrzekła kobieta. —A gdy On nadejdzie, wszystko nam wyjaśni. ");
INSERT INTO polsz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Właśnie z Nim rozmawiasz! To Ja Nim jestem—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","W tym momencie nadeszli uczniowie i zdziwili się, że Jezus rozmawia z samarytańską kobietą. Żaden z nich jednak nie zapytał: „Po co z nią rozmawiasz?”. ");
INSERT INTO polsz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ona zaś zostawiła dzban i pobiegła do miasteczka, wołając: ");
INSERT INTO polsz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Chodźcie zobaczyć człowieka, który powiedział mi wszystko, co zrobiłam w życiu! To musi być Mesjasz! ");
INSERT INTO polsz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mieszkańcy wyszli więc z miasteczka i szli zobaczyć Jezusa. ");
INSERT INTO polsz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tymczasem uczniowie zachęcali Go: —Nauczycielu! Zjedz coś. ");
INSERT INTO polsz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Ja mam pokarm, o którym nie wiecie—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","—Czyżby ktoś przyniósł Mu jedzenie?—zastanawiali się między sobą. ");
INSERT INTO polsz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","—Moim pokarmem jest wypełnianie woli Tego, który Mnie posłał, i wykonywanie Jego dzieła—odparł Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","—Czy nie mówicie: Już za cztery miesiące zaczną się żniwa? Ja wam mówię: Rozejrzyjcie się dookoła i zobaczcie, że pola już teraz są gotowe do żniw. ");
INSERT INTO polsz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Żniwiarz odbiera zapłatę za pracę i zbiera wieczny plon. A ten, który siał, cieszy się razem z nim. ");
INSERT INTO polsz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Prawdziwe jest powiedzenie: „Jeden sieje, drugi zbiera”. ");
INSERT INTO polsz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Oto posłałem was do zbierania tego, czego nie sialiście. Inni się przy tym napracowali, a wy zbieracie plon ich pracy. ");
INSERT INTO polsz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wielu Samarytan z tego miasteczka uwierzyło Jezusowi dzięki słowom kobiety: „Powiedział mi wszystko, co zrobiłam w życiu!”. ");
INSERT INTO polsz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Gdy więc przyszli do Niego, prosili, żeby się u nich zatrzymał. Został więc tam dwa dni. ");
INSERT INTO polsz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Oni zaś słuchali Jego nauki i jeszcze więcej z nich uwierzyło Mu. ");
INSERT INTO polsz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kobiecie zaś mówili: „Wierzymy teraz nie tylko dzięki twoim słowom. Sami bowiem Go słyszeliśmy i wiemy, że to właśnie On jest Zbawicielem świata”. ");
INSERT INTO polsz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Po upływie dwóch dni Jezus udał się do Galilei, ");
INSERT INTO polsz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","mówił bowiem, że prorok nie może znaleźć szacunku we własnej ojczyźnie. ");
INSERT INTO polsz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mieszkańcy Galilei przyjęli Go z otwartymi ramionami. Byli bowiem w Jerozolimie na święcie Paschy i widzieli wszystko, czego tam dokonał. ");
INSERT INTO polsz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jezus ponownie poszedł do Kany Galilejskiej, gdzie poprzednio przemienił wodę w wino. W pobliskim Kafarnaum mieszkał pewien urzędnik państwowy, którego syn akurat poważnie chorował. ");
INSERT INTO polsz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Usłyszał on wcześniej, że Jezus zmierza z Judei do Galilei. Przyszedł więc do Kany i błagał Go, aby udał się do Kafarnaum i uzdrowił jego umierającego syna. ");
INSERT INTO polsz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jezus rzekł do niego: —Jeśli nie zobaczycie cudów, nie uwierzycie Mi. ");
INSERT INTO polsz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","—Panie, zechciej przyjść, zanim moje dziecko umrze—błagał urzędnik. ");
INSERT INTO polsz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Wracaj do domu! Twój syn będzie żył—odpowiedział Jezus. Urzędnik uwierzył Jezusowi na słowo i odszedł. ");
INSERT INTO polsz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Gdy był jeszcze w drodze, wybiegli mu na spotkanie słudzy z wieścią, że jego syn wyzdrowiał. ");
INSERT INTO polsz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Zapytał więc, o której godzinie poczuł się lepiej. —Wczoraj o pierwszej po południu spadła mu gorączka—odpowiedzieli. ");
INSERT INTO polsz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ojciec uświadomił sobie wówczas, że właśnie o tej godzinie Jezus powiedział mu: „Twój syn będzie żył”. Wtedy on sam i cały jego dom uwierzył Jezusowi. ");
INSERT INTO polsz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Był to drugi cud Jezusa od Jego powrotu z Judei do Galilei. ");
INSERT INTO polsz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nadeszło kolejne żydowskie święto i Jezus udał się do Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Obok Owczej Bramy znajdowała się w mieście sadzawka otoczona pięcioma krużgankami, zwana po hebrajsku Betezda. ");
INSERT INTO polsz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Leżało tam wielu chorych—niewidomych, kalekich i sparaliżowanych. ");
INSERT INTO polsz_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","A anioł Pana zstępował od czasu do czasu do sadzawki i poruszał wodę. ");
INSERT INTO polsz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Był tam również pewien człowiek, który chorował od trzydziestu ośmiu lat. ");
INSERT INTO polsz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Zobaczywszy go, Jezus od razu poznał, że choruje od bardzo długiego czasu. I zapytał go: —Czy chcesz wyzdrowieć? ");
INSERT INTO polsz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Panie, nie mam nikogo, kto by mi pomógł wejść do sadzawki, gdy anioł poruszy wodę. Zanim dojdę, ktoś inny mnie wyprzedza i doznaje uzdrowienia. ");
INSERT INTO polsz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—Wstań, zwiń swoją matę i chodź o własnych siłach!—rzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","I człowiek ten natychmiast wyzdrowiał. Zwinął matę i zaczął chodzić. A był to akurat święty dzień szabatu. ");
INSERT INTO polsz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Gdy żydowscy przywódcy zobaczyli go, powiedzieli: —Jest szabat! Nie wolno ci nosić maty! To wbrew przykazaniom! ");
INSERT INTO polsz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—To człowiek, który mnie uzdrowił, powiedział: „Zwiń matę i chodź”—odrzekł uzdrowiony. ");
INSERT INTO polsz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—Kto ośmielił się coś takiego ci rozkazać?—dociekali. ");
INSERT INTO polsz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Uzdrowiony nie potrafił odpowiedzieć, bo Jezus zniknął w otaczającym ich tłumie. ");
INSERT INTO polsz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Jakiś czas potem Jezus odnalazł go w świątyni i powiedział: —Wyzdrowiałeś. Teraz nie grzesz, żeby nie spotkało cię coś gorszego! ");
INSERT INTO polsz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wówczas człowiek ten udał się do przywódców i oznajmił im, że to Jezus go uzdrowił. ");
INSERT INTO polsz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Wtedy oni zaczęli oskarżać Jezusa, że uczynił to w szabat. ");
INSERT INTO polsz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ale On odpowiedział im: —Mój Ojciec teraz działa, więc Ja również działam. ");
INSERT INTO polsz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Na te słowa jeszcze bardziej utwierdzili się w zamiarze zabicia Go. Nie tylko bowiem łamał przepisy dotyczące szabatu, ale Boga nazywał swoim Ojcem, czyniąc się w ten sposób równym Bogu. ");
INSERT INTO polsz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jezus powiedział więc: —Zapewniam was: Syn Boży sam z siebie niczego nie może uczynić. Robi tylko to, co widzi u Ojca. Co więc czyni Ojciec, to robi i Syn. ");
INSERT INTO polsz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ojciec kocha Syna i pokazuje Mu wszystko, czego sam dokonuje. Z resztą pokaże Mu jeszcze większe dzieła, abyście Go podziwiali. ");
INSERT INTO polsz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Podobnie jak Ojciec wskrzesza umarłych i daje im życie, tak i Syn daje życie tym, którym sam chce. ");
INSERT INTO polsz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ojciec nikogo też nie sądzi, bo wszelki sąd przekazał Synowi, ");
INSERT INTO polsz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","aby wszyscy ludzie czcili Go tak, jak czczą Ojca. Kto więc nie czci Syna, nie czci również Ojca, który Go posłał. ");
INSERT INTO polsz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Zapewniam was: Każdy, kto Mnie słucha i wierzy Ojcu, który Mnie posłał, ma życie wieczne. Nie zostanie potępiony, bo przeszedł już ze śmierci do życia. ");
INSERT INTO polsz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Zapewniam was również, że zbliża się czas, a właściwie już nadszedł, gdy umarli usłyszą głos Syna Bożego, a ci którzy usłyszą—ożyją. ");
INSERT INTO polsz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ojciec, który ma w sobie życie, dał je Synowi, aby i On je miał. ");
INSERT INTO polsz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Dał Mu też władzę sądzenia, ponieważ jest On Synem Człowieczym. ");
INSERT INTO polsz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nie dziwcie się temu, ponieważ nadchodzi czas, gdy wszyscy umarli usłyszą Jego głos. ");
INSERT INTO polsz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","I powstaną z martwych: ci, którzy dobrze postępowali—do wiecznego życia; ci zaś, którzy popełniali zło—na sąd. ");
INSERT INTO polsz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ja niczego nie czynię sam z siebie. Osądzam tak, jak Mi mówi Ojciec, i mój osąd jest sprawiedliwy, gdyż nie kieruję się swoją wolą, lecz wolą Tego, który Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Gdybym sam przedstawiał dowody na swój temat, nie byłbym wiarygodny—kontynuował Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","—Dowody takie przedstawia jednak Ojciec, a On jest przecież prawdomówny. ");
INSERT INTO polsz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Wysłaliście do Jana Chrzciciela ludzi z pytaniem o Mnie, a on powiedział wam prawdę. ");
INSERT INTO polsz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nie polegam jednak na dowodach od ludzi. Wspominam o tym tylko po to, abyście dostąpili zbawienia. ");
INSERT INTO polsz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jan był płonąca lampą, a wy cieszyliście się jego światłem. ");
INSERT INTO polsz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Istnieją jednak większe dowody niż słowa Jana. Są to czyny zlecone mi przez Ojca, których Ja dokonuję. Potwierdzają one, że zostałem przez Niego posłany. ");
INSERT INTO polsz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Potwierdził to również sam Ojciec! Wy jednak nigdy nie słyszeliście Jego głosu ani Go nie widzieliście. ");
INSERT INTO polsz_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nie przyjęliście też Jego słowa, bo nie wierzycie Temu, którego On posłał. ");
INSERT INTO polsz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Studiujecie Pisma, bo wydaje się wam, że odnajdziecie w nich życie wieczne. A one przecież mówią o Mnie! ");
INSERT INTO polsz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wy jednak nie chcecie do Mnie przyjść, aby otrzymać to życie. ");
INSERT INTO polsz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ja nie potrzebuję uznania ze strony ludzi. ");
INSERT INTO polsz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","I wiem, że nie macie w sobie Bożej miłości. ");
INSERT INTO polsz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Przyszedłem do was w imieniu Ojca, lecz odrzucacie Mnie. Jeśli jednak ktoś przychodzi we własnym imieniu, chętnie go słuchacie. ");
INSERT INTO polsz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nic dziwnego, że nie możecie uwierzyć! Zabiegacie o ludzki szacunek, zupełnie nie troszcząc się o uznanie w oczach Boga. ");
INSERT INTO polsz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ale nie myślcie, że to Ja będę was obwiniał przed Ojcem. Oskarży was Mojżesz, w którym pokładacie nadzieję na wieczność. ");
INSERT INTO polsz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Gdybyście bowiem naprawdę mu wierzyli, uwierzylibyście i Mnie, gdyż on pisał właśnie o Mnie. ");
INSERT INTO polsz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ale jak możecie uwierzyć moim słowom, skoro nie wierzycie nawet jego pismom? ");
INSERT INTO polsz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Potem Jezus przeprawił się na drugą stronę Jeziora Galilejskiego, zwanego też Jeziorem Tyberiadzkim. ");
INSERT INTO polsz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Towarzyszyły Mu tłumy, bo ludzie widzieli, jak w cudowny sposób uzdrawiał chorych. ");
INSERT INTO polsz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jezus wszedł na górę i usiadł tam ze swoimi uczniami. ");
INSERT INTO polsz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","A zbliżało się wtedy żydowskie święto Paschy. ");
INSERT INTO polsz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Gdy Jezus rozejrzał się i zobaczył, nadchodzące ogromne tłumy ludzi, powiedział do Filipa: —Gdzie kupimy chleb, aby ci ludzie mogli coś zjeść? ");
INSERT INTO polsz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Zapytał o to, aby wystawić go na próbę. Wiedział bowiem, co ma robić. ");
INSERT INTO polsz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","—Nawet fortuna nie wystarczyłaby, aby każdy mógł dostać chociaż kawałek chleba—odrzekł Filip. ");
INSERT INTO polsz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Wtedy do rozmowy włączył się inny uczeń—Andrzej, brat Szymona Piotra: ");
INSERT INTO polsz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Jest tu chłopiec, który ma pięć jęczmiennych chlebów i dwie ryby. Ale co to jest dla takiego tłumu? ");
INSERT INTO polsz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—Każcie wszystkim usiąść!—powiedział Jezus. Ludzie usiedli więc na trawie, a samych tylko mężczyzn było tam około pięciu tysięcy. ");
INSERT INTO polsz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jezus wziął chleby, podziękował za nie Bogu i polecił rozdać je siedzącym—każdemu tyle, ile chciał. To samo zrobił z rybami. ");
INSERT INTO polsz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Gdy już wszyscy się najedli, powiedział uczniom: —Pozbierajcie resztki, aby nic się nie zmarnowało. ");
INSERT INTO polsz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","I z pięciu jęczmiennych chlebów zebrano aż dwanaście koszy resztek chleba! ");
INSERT INTO polsz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Gdy ludzie uświadomili sobie, jakiego cudu dokonał Jezus, zaczęli wołać: —To na pewno jest ten prorok, który miał nadejść! ");
INSERT INTO polsz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Lecz Jezus zorientował się, że chcą Go zabrać i obwołać królem. Dlatego samotnie oddalił się na górę. ");
INSERT INTO polsz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Wieczorem uczniowie zeszli na brzeg, ");
INSERT INTO polsz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","wsiedli do łodzi i popłynęli w kierunku Kafarnaum. ");
INSERT INTO polsz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wkrótce zerwał się silny wiatr i jezioro bardzo się wzburzyło. ");
INSERT INTO polsz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Intensywnie wiosłując, przepłynęli jakieś pięć kilometrów. Nagle zobaczyli Jezusa idącego po wodzie i będącego już blisko łodzi. Przerazili się, ");
INSERT INTO polsz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","lecz On zawołał: —Nie bójcie się, to Ja! ");
INSERT INTO polsz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chcieli Go wziąć do łodzi, ale okazało się, że właśnie dobijają do brzegu—do miejsca, do którego płynęli. ");
INSERT INTO polsz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Następnego dnia, tłum ludzi, zebrany na przeciwległym brzegu, zorientował się, że poza jedną łodzią, którą odpłynęli uczniowie, nie było innej. Wiedzieli też, że Jezus nie wsiadł do łodzi z uczniami, bo odpłynęli sami. ");
INSERT INTO polsz_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tymczasem na miejsce, w którym Jezus nakarmił ludzi chlebem, przypłynęły z Tyberiady inne łodzie. ");
INSERT INTO polsz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Gdy ludzie zauważyli, że nie ma ani Jezusa, ani uczniów, wsiedli do łodzi i popłynęli do Kafarnaum, aby Go odnaleźć. ");
INSERT INTO polsz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Gdy Go znaleźli, zapytali: —Nauczycielu! Kiedy zdążyłeś tu przybyć? ");
INSERT INTO polsz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","—Zapewniam was, że szukacie Mnie nie dlatego, że ujrzeliście cud, lecz dlatego, że najedliście się do syta—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","—Starajcie się jednak nie o ten nietrwały pokarm, ale o pokarm dający życie wieczne, który Ja, Syn Człowieczy, mogę wam zapewnić. Po to właśnie posłał Mnie Bóg Ojciec! ");
INSERT INTO polsz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","—A co mamy zrobić, żeby wypełnić wolę Boga?—pytali. ");
INSERT INTO polsz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Wolą Boga jest to, abyście wierzyli Temu, którego On posłał—odparł Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","—Jakiego cudu dokonasz więc, abyśmy mogli go zobaczyć i uwierzyć ci? ");
INSERT INTO polsz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nasi przodkowie codziennie jedli mannę na pustyni. Pismo mówi: „Dał im do jedzenia chleb z nieba”. ");
INSERT INTO polsz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","—Zapewniam was, że to nie Mojżesz dawał chleb z nieba—odrzekł Jezus—ale mój Ojciec daje wam teraz prawdziwy chleb z nieba. ");
INSERT INTO polsz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Chlebem od Boga jest bowiem Ten, który przychodzi z nieba—to On daje światu życie. ");
INSERT INTO polsz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Panie, dawaj nam zawsze ten chleb—prosili Go. ");
INSERT INTO polsz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","—To Ja jestem chlebem życia!—odpowiedział Jezus. —Kto do Mnie przychodzi, nie będzie głodny. A kto wierzy Mi, nie zazna pragnienia. ");
INSERT INTO polsz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ale nie pierwszy raz o tym mówię, a wy patrzycie na Mnie i nadal nie wierzycie. ");
INSERT INTO polsz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Jednak ci wszyscy, których dał Mi Ojciec, przyjdą do Mnie. A Ja nikogo z nich nie odtrącę. ");
INSERT INTO polsz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Przyszedłem bowiem z nieba nie po to, aby działać na własną rękę, lecz żeby wypełnić wolę Ojca, który Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","On nie chce, abym kogoś stracił, ale pragnie, abym wszystkich ożywił w dniu ostatecznym. ");
INSERT INTO polsz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wolą mojego Ojca jest to, aby każdy, kto widzi Syna i wierzy Mu, miał życie wieczne i abym ożywił go w dniu ostatecznym. ");
INSERT INTO polsz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Słysząc to, ludzie zaczęli się oburzać, ponieważ powiedział: „To Ja jestem chlebem, który zstąpił z nieba”. ");
INSERT INTO polsz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—Przecież to tylko Jezus, syn Józefa!—wykrzykiwali. —Znamy jego ojca i matkę. Jak on może mówić: „Zstąpiłem z nieba?”. ");
INSERT INTO polsz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","—Dlaczego jesteście oburzeni?—zapytał Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","—Nikt nie może do Mnie przyjść, jeśli nie zostanie przyprowadzony przez Ojca, który Mnie posłał. Tych zaś, którzy przyjdą do Mnie, ożywię w dniu ostatecznym. ");
INSERT INTO polsz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","W księgach proroków napisano przecież: „Oni wszyscy będą uczniami Boga”. Każdy więc, kto słuchał Ojca i uczył się od Niego, przyjdzie do Mnie. ");
INSERT INTO polsz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nie znaczy to, że ktokolwiek widział Boga Ojca—oprócz Tego, który od Niego przyszedł. ");
INSERT INTO polsz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Raz jeszcze zapewniam was: Kto wierzy, ma życie wieczne! ");
INSERT INTO polsz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ja jestem chlebem życia! ");
INSERT INTO polsz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wasi przodkowie jedli wprawdzie mannę na pustyni, ale poumierali. ");
INSERT INTO polsz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Natomiast każdy, kto je ten chleb z nieba, nie umrze. ");
INSERT INTO polsz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","To Ja jestem chlebem życia, przysłanym z nieba. Kto się nim posili, będzie żyć na wieki. Chlebem tym jest moje ciało, które poświęcam, aby dać światu życie. ");
INSERT INTO polsz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Wtedy słuchający Go zaczęli się między sobą sprzeczać: —Jak on może dać nam do jedzenia swoje ciało? ");
INSERT INTO polsz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","—Zapewniam was: Jeżeli nie spożyjecie ciała i krwi Syna Człowieczego—odpowiedział Jezus—nie będziecie mieć w sobie życia. ");
INSERT INTO polsz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kto spożywa moje ciało i krew, już ma życie wieczne, a Ja go ożywię w dniu ostatecznym. ");
INSERT INTO polsz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ciało moje to prawdziwy pokarm, a moja krew to prawdziwy napój. ");
INSERT INTO polsz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kto spożywa moje ciało i krew, jest trwale połączony ze Mną, a Ja—z nim. ");
INSERT INTO polsz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ja żyję dzięki żyjącemu Ojcu, który Mnie posłał. Tak samo ten, kto się Mną karmi, będzie żyć dzięki Mnie. ");
INSERT INTO polsz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","To właśnie jest chleb z nieba—nie taki, jaki jedli wasi przodkowie i poumierali. Każdy, kto spożywa ten chleb, będzie żył wiecznie. ");
INSERT INTO polsz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tego wszystkiego Jezus nauczał w synagodze w Kafarnaum. ");
INSERT INTO polsz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Słysząc to, wielu Jego uczniów, mówiło: —To jest zbyt trudne! Któż jest w stanie to pojąć? ");
INSERT INTO polsz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jezus wiedział, że im się to nie podoba. Spytał więc: —Jesteście zniechęceni tym? ");
INSERT INTO polsz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Co w takim razie powiecie, gdy zobaczycie Mnie, Syna Człowieczego, wracającego tam, skąd przyszedłem? ");
INSERT INTO polsz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Zrozumcie: to Duch daje życie—ludzkie wysiłki nie mają znaczenia. Słowa, które wam powiedziałem, pochodzą właśnie od Ducha i prowadzą do życia. ");
INSERT INTO polsz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ale niektórzy z was nadal Mi nie wierzą. Jezus od początku wiedział bowiem, kto Mu nie wierzy oraz kto Go zdradzi. ");
INSERT INTO polsz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Powiedział więc: —To właśnie miałem na myśli, mówiąc, że nikt nie jest w stanie przyjść do Mnie, jeśli go nie przyprowadzi Ojciec. ");
INSERT INTO polsz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Po tych słowach wielu uczniów opuściło Jezusa i już z Nim nie chodziło. ");
INSERT INTO polsz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Wtedy On zwrócił się do Dwunastu: —Czy i wy chcecie odejść? ");
INSERT INTO polsz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","—Panie, a do kogo pójdziemy?—odpowiedział Szymon Piotr. —Twoje słowa prowadzą do życia wiecznego! ");
INSERT INTO polsz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Uwierzyliśmy Ci i wiemy, że jesteś Świętym Synem Boga. ");
INSERT INTO polsz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","—Wybrałem was Dwunastu—rzekł Jezus—ale jeden z was jest sługą diabła. ");
INSERT INTO polsz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Mówiąc to, miał na myśli Judasza, syna Szymona z Kariotu. To on bowiem, jako należący do grona Dwunastu, miał Go później zdradzić. ");
INSERT INTO polsz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Po tych wydarzeniach Jezus wędrował po Galilei. Nie chciał iść do Judei, ponieważ tamtejsi przywódcy chcieli Go zabić. ");
INSERT INTO polsz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A zbliżało się kolejne żydowskie święto—Święto Namiotów. ");
INSERT INTO polsz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Bracia Jezusa namawiali Go: —Rusz się stąd i idź do Judei! Niech i Twoi uczniowie zobaczą cuda. ");
INSERT INTO polsz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Jeśli ktoś chce być sławny, nie może się kryć po kątach. Skoro naprawdę robisz takie rzeczy, niech Cię zobaczy cały świat. ");
INSERT INTO polsz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mówili tak, bo nie wierzyli Mu. Jezus odpowiedział im jednak: ");
INSERT INTO polsz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","—Mój czas jeszcze nie nadszedł, ale dla was każdy dzień jest dobry. ");
INSERT INTO polsz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Świat nie ma powodu, aby was nienawidzić. Mnie nienawidzi, bo ujawniam jego złe czyny. ");
INSERT INTO polsz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Idźcie więc na uroczystości. Ja na razie nie pójdę, bo jeszcze nie przyszła na Mnie pora. ");
INSERT INTO polsz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tak im odpowiedział i sam został w Galilei. ");
INSERT INTO polsz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Gdy bracia udali się na święto, Jezus też tam przyszedł, ale nie jawnie. ");
INSERT INTO polsz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tymczasem przywódcy szukali Go w czasie uroczystości i wypytywali o Niego. ");
INSERT INTO polsz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A wśród tłumów krążyły na Jego temat różne wieści. —To wspaniały człowiek!—twierdzili jedni. —Nieprawda! Manipuluje tłumem—mówili inni. ");
INSERT INTO polsz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Jednak ze strachu przed przywódcami nikt nie mówił o Nim publicznie. ");
INSERT INTO polsz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mniej więcej w połowie wszystkich uroczystości Jezus wszedł do świątyni i zaczął otwarcie nauczać. ");
INSERT INTO polsz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","—Skąd on tak dobrze zna Pisma?—nie mogli wyjść z podziwu przywódcy. —Przecież nie ma wykształcenia! ");
INSERT INTO polsz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","—Ja nie głoszę własnej nauki, lecz słowo Boga, który Mnie posłał—odparł Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","—Ten, kto jest gotów wypełniać Jego wolę, rozpozna, czy to, co mówię, pochodzi od Boga, czy sam to wymyśliłem. ");
INSERT INTO polsz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kto głosi własne poglądy, zabiega o uznanie dla siebie. Ale kto zabiega o uznanie dla tego, który go posłał, mówi prawdę i jest bez zarzutu. ");
INSERT INTO polsz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Czy Mojżesz nie zostawił wam przykazań? Jednak nikt z was ich nie przestrzega. Chcecie Mnie zabić? ");
INSERT INTO polsz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—Chyba oszalałeś! Kto chce cię zabić?—rozległy się głosy z tłumu. ");
INSERT INTO polsz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","—Oburzacie się, że dokonałem jednego cudu w szabat—mówił dalej Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","—Mojżesz dał wam nakaz, aby dokonywać obrzezania, i już wasi przodkowie robili to nawet w szabat. ");
INSERT INTO polsz_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Skoro więc w tym świętym dniu dokonuje się tej małej czynności, żeby przestrzegać Prawa Mojżesza, to dlaczego oburzacie się na Mnie, że w szabat uzdrowiłem całego człowieka? ");
INSERT INTO polsz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nie oceniajcie po pozorach, ale bądźcie rzetelni w swoim osądzie. ");
INSERT INTO polsz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Niektórzy z mieszkańców Jerozolimy mówili wtedy między sobą: —To chyba ten, którego planują zabić? ");
INSERT INTO polsz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Dziwne, że teraz publicznie naucza i nie sprzeciwiają mu się. Może i nasi przywódcy doszli do wniosku, że on jest Mesjaszem? ");
INSERT INTO polsz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ale przecież wiemy, skąd on pochodzi. Gdy zaś przyjdzie Mesjasz, nikt nie będzie tego wiedział. ");
INSERT INTO polsz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","—Tak, znacie Mnie i wiecie, skąd jestem—zawołał podczas nauczania w świątyni Jezus. —Nie przyszedłem tu jednak z własnej inicjatywy. Posłał Mnie Ten, który jest prawdziwy, a którego wy nie znacie. ");
INSERT INTO polsz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ja Go znam, ponieważ byłem z Nim i to On Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Wówczas przywódcy próbowali Go aresztować. Nikt jednak nie ośmielił się podnieść na Niego ręki, bo nie nadszedł jeszcze Jego czas. ");
INSERT INTO polsz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wtedy wielu spośród zgromadzonych uwierzyło Mu. —Czy można się spodziewać, że Mesjasz miałby uczynić więcej cudów niż On?—argumentowali. ");
INSERT INTO polsz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Faryzeusze dowiedzieli się, jakie nastroje panują wśród tłumów, i wspólnie z najwyższymi kapłanami wysłali strażników, aby aresztowali Jezusa. ");
INSERT INTO polsz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","On jednak powiedział im: —Jeszcze przez krótki czas będę z wami, a później wrócę do Tego, który Mnie do was posłał. ");
INSERT INTO polsz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Będziecie Mnie szukać, ale nie znajdziecie. Tam, dokąd idę, wy nie możecie pójść. ");
INSERT INTO polsz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","—Dokąd on zamierza odejść, skoro mamy go nie znaleźć?—zastanawiali się między sobą. —Czyżby zamierzał udać się za granicę i nauczać pogan oraz naszych rodaków żyjących na emigracji? ");
INSERT INTO polsz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Co ma na myśli, mówiąc: „Będziecie Mnie szukać, ale nie znajdziecie” i „Tam, gdzie się udaję, wy nie możecie pójść”? ");
INSERT INTO polsz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","W ostatnim, najważniejszym dniu święta Jezus zawołał do tłumów: —Jeśli ktoś jest spragniony, niech przyjdzie do Mnie i pije. ");
INSERT INTO polsz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Jak mówi Pismo, jeśli ktoś uwierzy Mi, to z jego wnętrza wypłyną rzeki żywej wody. ");
INSERT INTO polsz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mówił tak o Duchu Świętym, którego mieli otrzymać wierzący Mu. Duch bowiem nie był jeszcze zesłany, ponieważ Jezus nie został jeszcze otoczony chwałą. ");
INSERT INTO polsz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Słysząc te słowa, niektórzy z tłumu mówili: —To na pewno prorok. ");
INSERT INTO polsz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","—To jest Mesjasz!—twierdzili inni. —Jak to? Mesjasz z Galilei?—mówili jeszcze inni. ");
INSERT INTO polsz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","—Przecież Pismo mówi, że Mesjasz będzie potomkiem króla Dawida i będzie pochodził z Betlejem, jego rodzinnej miejscowości. ");
INSERT INTO polsz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tak więc zdania ludzi były podzielone. ");
INSERT INTO polsz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Niektórzy chcieli Go nawet aresztować, ale nikt nie ośmielił się Go dotknąć. ");
INSERT INTO polsz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Strażnicy, którzy mieli zatrzymać Jezusa, wrócili więc do najwyższych kapłanów i faryzeuszy z pustymi rękami. —Dlaczego nie przyprowadziliście go?—wołali przełożeni. ");
INSERT INTO polsz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—Nigdy jeszcze nie słyszeliśmy, żeby jakiś człowiek przemawiał tak jak On!—odpowiedzieli strażnicy. ");
INSERT INTO polsz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","—Więc i was oszukał?—krzyczeli faryzeusze. ");
INSERT INTO polsz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","—Czy słyszeliście, żeby ktoś z przełożonych lub faryzeuszy uwierzył Mu? ");
INSERT INTO polsz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","A ten motłoch, który w ogóle nie zna Prawa Mojżesza, niech będzie przeklęty! ");
INSERT INTO polsz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Wtedy zabrał głos Nikodem, jeden z przywódców, który kiedyś odwiedził Jezusa. ");
INSERT INTO polsz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Czy nasze Prawo zezwala na skazanie kogoś bez dokładnego przyjrzenia się jego czynom i zapewnienia oskarżonemu możliwości obrony? ");
INSERT INTO polsz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","—A może i ty jesteś z Galilei?—odparli. —Sam sprawdź Pismo i przekonaj się, że stamtąd nie pochodził żaden prorok. ");
INSERT INTO polsz_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Po tych słowach rozeszli się do domów. ");
INSERT INTO polsz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jezus natomiast udał się na Górę Oliwną. ");
INSERT INTO polsz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Następnego ranka znów jednak pojawił się w świątyni. Wkrótce zebrał się tam tłum, więc Jezus usiadł i zaczął przemawiać. ");
INSERT INTO polsz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wtedy właśnie przywódcy religijni i faryzeusze przyprowadzili do Niego kobietę, którą znaleziono w łóżku z mężczyzną, który nie był jej mężem. Postawili ją na samym środku ");
INSERT INTO polsz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","i powiedzieli: —Nauczycielu, złapaliśmy ją na gorącym uczynku. ");
INSERT INTO polsz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mojżesz w swoim Prawie nakazał, aby taką osobę obrzucić kamieniami i zabić. A ty jak nauczasz? ");
INSERT INTO polsz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Była to prowokacja, która miała dostarczyć podstaw do oskarżenia Jezusa. Lecz On schylił się i zaczął pisać palcem po ziemi. ");
INSERT INTO polsz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Gdy jednak uparcie domagali się odpowiedzi, podniósł się i rzekł: —Kto z was nie dopuścił się żadnego grzechu, niech pierwszy rzuci w nią kamieniem. ");
INSERT INTO polsz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","I znowu schylił się i pisał po ziemi. ");
INSERT INTO polsz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tymczasem zebrani, jeden po drugim, począwszy od przełożonych, zaczęli odchodzić. W końcu został tylko Jezus i stojąca na środku owa kobieta. ");
INSERT INTO polsz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","—Gdzie oni są? Nikt cię nie potępił?—spytał Jezus, podnosząc się. ");
INSERT INTO polsz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Nikt, Panie—odrzekła. —Ja też cię nie potępiam. Idź i już więcej nie grzesz. ");
INSERT INTO polsz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Innym razem Jezus przemówił do zgromadzonych: —Jestem światłem świata. Kto idzie za Mną, nie będzie chodził w ciemnościach, lecz będzie miał światło życia. ");
INSERT INTO polsz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","—Przechwalasz się! To nie prawda—zawołali faryzeusze. ");
INSERT INTO polsz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","—Chociaż mówię sam o sobie, mówię prawdę, bo wiem, skąd przyszedłem i dokąd zmierzam. ");
INSERT INTO polsz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Wy osądzacie według tego, co zewnętrzne. Ja zaś nikogo nie sądzę. ");
INSERT INTO polsz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","A nawet gdybym sądził, mój osąd jest prawdziwy, bo nie robię tego sam, ale razem z Ojcem, który Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","W waszym Prawie jest napisane, że zgodne zeznania dwóch świadków uznaje się za prawdziwe. ");
INSERT INTO polsz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jednym świadkiem jestem Ja, a drugim—Ojciec, który Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—A gdzież jest ten twój ojciec?—pytali Go. —Nie znacie ani Mnie, ani Jego—odpowiedział Jezus. —Gdybyście Mnie znali, znalibyście także i mojego Ojca. ");
INSERT INTO polsz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jezus mówił o tym, będąc w świątyni, w pobliżu skarbca. Nie zatrzymano Go jednak, bo jeszcze nie nadszedł na to czas. ");
INSERT INTO polsz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Później powiedział im: —Wkrótce odejdę! Będziecie Mnie szukać, ale umrzecie w swoich grzechach. Nie możecie bowiem pójść tam, dokąd idę. ");
INSERT INTO polsz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","—Czyżby chciał się zabić?—zastanawiali się przywódcy. —Powiedział przecież: „Nie możecie pójść tam, dokąd idę”. ");
INSERT INTO polsz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","—Wy jesteście z dołu, Ja pochodzę z góry—kontynuował Jezus. —Należycie do tego świata, Ja—nie. ");
INSERT INTO polsz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Właśnie dlatego powiedziałem, że umrzecie w swoich grzechach. Jeśli nie uwierzycie, że JA JESTEM, tak właśnie się stanie. ");
INSERT INTO polsz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—A kim jesteś?—pytali. —Po co Ja jeszcze z wami rozmawiam?! ");
INSERT INTO polsz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mógłbym was oskarżyć o wiele rzeczy, wielu też mógłbym was nauczyć. Ten, który Mnie posłał, jest bowiem prawdomówny. Dlatego powtarzam światu to, co od Niego usłyszałem. ");
INSERT INTO polsz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Oni jednak nadal nie rozumieli, że mówił o swoim Ojcu. ");
INSERT INTO polsz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","—Gdy podniesiecie Mnie w górę—kontynuował Jezus—wtedy poznacie, że JA JESTEM i że nie robię niczego z własnej inicjatywy. Powtarzam tylko to, czego nauczył Mnie Ojciec. ");
INSERT INTO polsz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","On Mnie posłał i zawsze jest ze Mną. Nie opuszcza Mnie, bo zawsze robię to, co się Mu podoba. ");
INSERT INTO polsz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Słuchając Go, wielu ludzi uwierzyło Mu. ");
INSERT INTO polsz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Wtedy Jezus zwrócił się do Żydów, którzy Mu uwierzyli: —Jeżeli będziecie żyć według moich słów, będziecie naprawdę moimi uczniami ");
INSERT INTO polsz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","i poznacie prawdę, a prawda was uwolni. ");
INSERT INTO polsz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","—Jak to?!—oburzyli się. —Jesteśmy przecież potomkami Abrahama i nigdy nie byliśmy niczyimi niewolnikami. Jak więc możesz mówić, że zostaniemy uwolnieni? ");
INSERT INTO polsz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","—Zapewniam was, że każdy, kto grzeszy, jest niewolnikiem grzechu—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","—Niewolnik nie jest w domu na zawsze, ale syn—tak. ");
INSERT INTO polsz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jeśli więc Syn Boży da wam wolność, wtedy staniecie się naprawdę wolni. ");
INSERT INTO polsz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Wiem, że jesteście potomkami Abrahama! Ale chcecie Mnie zabić—bo nie przyjęliście moich słów. ");
INSERT INTO polsz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ja mówię to, co wiem od mojego Ojca. Wy zaś robicie to, co usłyszeliście od waszego ojca. ");
INSERT INTO polsz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Naszym przodkiem jest Abraham—oświadczyli. —Gdybyście byli potomkami Abrahama—odrzekł Jezus—robilibyście to, co on. ");
INSERT INTO polsz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","A przecież usiłujecie Mnie zabić tylko dlatego, że powiedziałem wam prawdę, jaką usłyszałem od Boga. Abraham tak nie postępował. ");
INSERT INTO polsz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Wy postępujecie tak, jak wasz prawdziwy ojciec! —Nie pochodzimy z nieprawego łoża—oburzyli się. —Naszym Ojcem jest Bóg! ");
INSERT INTO polsz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","—Gdyby Bóg był waszym Ojcem, okazywalibyście Mi miłość—odpowiedział Jezus. —Przyszedłem przecież od Niego. Nie jestem tu z własnej inicjatywy—to On Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Wy jednak nie możecie pojąć moich słów. Co więcej, nawet nie chcecie ich wysłuchać! ");
INSERT INTO polsz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Waszym prawdziwym ojcem jest diabeł—oszczerca! Dlatego chcecie robić to, co on. Od początku był on mordercą i nie wytrwał w prawdzie, bo nie przyjął jej. Gdy kłamie, mówi z serca, bo jest kłamcą i ojcem kłamstwa. ");
INSERT INTO polsz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Wy również nie wierzycie Mi, bo mówię prawdę. ");
INSERT INTO polsz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kto z was mógłby zarzucić Mi jakiś grzech? Skoro mówię prawdę, dlaczego Mi nie wierzycie? ");
INSERT INTO polsz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ten, kto należy do Boga, słucha Jego słów. Wy zaś ich nie słuchacie, bo nie jesteście Jego dziećmi. ");
INSERT INTO polsz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","—Ty Samarytaninie!—oburzyli się przywódcy. —Mieliśmy rację mówiąc, że demon odebrał ci rozum! ");
INSERT INTO polsz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—Nie jestem opętany—odpowiedział Jezus. —Dbam o dobre imię mojego Ojca, a wy Mnie obrażacie. ");
INSERT INTO polsz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nie zależy Mi na tym, abyście otoczyli Mnie chwałą. Jest jednak Ktoś, komu na tym zależy. To On jest sędzią. ");
INSERT INTO polsz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Zapewniam was: Kto jest posłuszny moim słowom, nigdy nie umrze! ");
INSERT INTO polsz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","—Teraz mamy pewność, że jesteś opanowany przez demona—odrzekli przywódcy. —Przecież nawet Abraham i najwięksi prorocy umarli, a ty twierdzisz: „Kto jest posłuszny moim słowom, nigdy nie umrze”. ");
INSERT INTO polsz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Czy jesteś większy od naszego przodka, Abrahama? On przecież umarł, podobnie jak nasi wielcy prorocy! Za kogo ty się uważasz?! ");
INSERT INTO polsz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","—Gdybym sam siebie wywyższał, nie miałoby to żadnego znaczenia—odparł Jezus. —Mnie jednak wywyższa Ojciec, którego wy nazywacie swoim Bogiem. ");
INSERT INTO polsz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Wcale Go jednak nie znacie—ale Ja Go znam. Gdybym mówił, że Go nie znam, byłbym kłamcą, tak jak wy. Ja jednak naprawdę Go znam i zawsze zachowuję Jego słowa. ");
INSERT INTO polsz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Wasz przodek, Abraham, ucieszył się z tego, że ujrzy mój dzień. I ogromnie się rozradował, gdy go zobaczył. ");
INSERT INTO polsz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","—Jak mogłeś widzieć Abrahama, skoro nie masz nawet pięćdziesięciu lat?!—zawołali przywódcy. ");
INSERT INTO polsz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Zapewniam was: Zanim Abraham się narodził, JA JESTEM—odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Słysząc to, chwycili kamienie, aby Go zabić. Ale Jezus zniknął im z oczu i opuścił świątynię. ");
INSERT INTO polsz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Idąc drogą, Jezus zobaczył człowieka niewidomego od urodzenia. ");
INSERT INTO polsz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","—Nauczycielu!—zapytali uczniowie. —Kto dopuścił się grzechu, że urodził się niewidomy: on sam czy jego rodzice? ");
INSERT INTO polsz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","—To nie jest kara za grzech, jego lub jego rodziców—odpowiedział Jezus. —Stało się tak, aby mogło się na nim objawić działanie Boga. ");
INSERT INTO polsz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Musimy wykonywać dzieło Tego, który Mnie posłał, póki jeszcze jest dzień. Nadchodzi bowiem noc i wtedy nikt nie będzie mógł działać. ");
INSERT INTO polsz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Dopóki jednak jestem na świecie, rozjaśniam go swoim światłem. ");
INSERT INTO polsz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Następnie plunął na ziemię, zrobił błoto i wysmarował nim oczy niewidomego. ");
INSERT INTO polsz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","—Idź i umyj się w sadzawce Siloam (to znaczy: „Posłany”)—rzekł Jezus. Niewidomy poszedł, zmył błoto i wrócił uzdrowiony. ");
INSERT INTO polsz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Sąsiedzi oraz ci, którzy znali go jako żebraka, zastanawiali się: —Czy to nie ten, który tu siedział i żebrał? ");
INSERT INTO polsz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Tak, to on!—mówili jedni. —Nie, jest tylko do niego podobny—zaprzeczali inni. —Tak, to ja!—odpowiadał jednak uzdrowiony. ");
INSERT INTO polsz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—Jak to się stało, że widzisz?—pytali go. ");
INSERT INTO polsz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Niejaki Jezus wysmarował mi oczy błotem i powiedział: „Idź do sadzawki Siloam i umyj się”. Poszedłem, obmyłem oczy i zacząłem widzieć! ");
INSERT INTO polsz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—Gdzie on teraz jest?—dopytywali. —Nie wiem—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Zaprowadzili więc uzdrowionego do faryzeuszy. ");
INSERT INTO polsz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","A dzień, w którym Jezus zrobił błoto i przywrócił niewidomemu wzrok, był akurat dniem szabatu. ");
INSERT INTO polsz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Faryzeusze dopytywali, w jaki sposób odzyskał wzrok. Uzdrowiony powtórzył więc: —Wysmarował mi oczy błotem, umyłem się i widzę. ");
INSERT INTO polsz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","—Ten człowiek nie pochodzi od Boga, bo nie przestrzega świętego dnia szabatu—stwierdzili niektórzy faryzeusze. —Ale w jaki sposób grzeszny człowiek mógłby czynić takie cuda?—argumentowali inni. I pojawił się między nimi podział. ");
INSERT INTO polsz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wtedy po raz kolejny zwrócili się do uzdrowionego: —A ty, co sądzisz o człowieku, który otworzył ci oczy? —To prorok!—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Lecz przywódcy nie wierzyli, że człowiek ten był niewidomy i odzyskał wzrok. Wezwali więc jego rodziców. ");
INSERT INTO polsz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—Czy to wasz syn?—wypytywali ich. —Twierdzicie, że urodził się niewidomy. W jaki więc sposób odzyskał wzrok? ");
INSERT INTO polsz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Wiemy tylko tyle, że to jest nasz syn—odparli—i że urodził się niewidomy. ");
INSERT INTO polsz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ale jak odzyskał wzrok i kto mu otworzył oczy—tego nie wiemy. Spytajcie go. Jest dorosły, niech mówi sam za siebie. ");
INSERT INTO polsz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Powiedzieli tak, bo bali się przywódców. Ci bowiem już wcześniej postanowili, że każdy, kto uzna, że Jezus jest Mesjaszem, zostanie usunięty z synagogi. ");
INSERT INTO polsz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Właśnie dlatego rodzice powiedzieli: „Jest dorosły, niech mówi sam za siebie”. ");
INSERT INTO polsz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Po raz drugi wezwali więc uzdrowionego i nakazali mu: —Przysięgnij na samego Boga i powiedz prawdę. My wiemy, że ten, który cię uzdrowił, jest grzesznikiem. ");
INSERT INTO polsz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Nie wiem, czy jest grzesznikiem—odpowiedział uzdrowiony. —Wiem tylko tyle: byłem niewidomy, a teraz widzę. ");
INSERT INTO polsz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—Co on zrobił? Jak cię uzdrowił?—pytali. ");
INSERT INTO polsz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Już wam o tym mówiłem—odpowiedział—ale mnie nie słuchaliście. Dlaczego znowu o to pytacie? Może też chcecie zostać jego uczniami? ");
INSERT INTO polsz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","—Sam sobie bądź jego uczniem—odpowiedzieli zdenerwowani. —My jesteśmy uczniami Mojżesza. ");
INSERT INTO polsz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wiemy, że do Mojżesza przemawiał Bóg. A o tym człowieku nic nie wiemy. ");
INSERT INTO polsz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—To naprawdę dziwne—rzekł uzdrowiony—że nie wiecie, kim jest człowiek, który przywrócił mi wzrok. ");
INSERT INTO polsz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Wiadomo przecież, że Bóg nie wysłuchuje grzeszników—ale wysłuchuje tych, którzy są pobożni i wypełniają Jego wolę. ");
INSERT INTO polsz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Od wieków nie słyszano, żeby ktoś uzdrowił niewidomego od urodzenia. ");
INSERT INTO polsz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Gdyby więc ten człowiek nie był posłany przez Boga, nic by nie mógł zrobić! ");
INSERT INTO polsz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","—Ty grzeszniku! Od urodzenia tkwisz w grzechu, a chcesz nas pouczać?!—zawołali faryzeusze i wyrzucili go. ");
INSERT INTO polsz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jezus dowiedział się, że tak potraktowano uzdrowionego, więc odszukał go i zapytał: —Czy wierzysz Synowi Człowieczemu? ");
INSERT INTO polsz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—A kto to jest, Panie? Chcę Mu uwierzyć. ");
INSERT INTO polsz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Masz Go przed oczami—rzekł Jezus. —Właśnie z tobą rozmawia. ");
INSERT INTO polsz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Tak, Panie! Wierzę—odrzekł i pokłonił się Jezusowi. ");
INSERT INTO polsz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","—Przyszedłem na ten świat po to, aby go osądzić—kontynuował Jezus—aby niewidomi przejrzeli, a widzący oślepli. ");
INSERT INTO polsz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Usłyszeli to stojący w pobliżu faryzeusze i zapytali: —Czy to nas masz na myśli? Czy to my jesteśmy ślepi? ");
INSERT INTO polsz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—Gdybyście byli niewidomi, nie mielibyście grzechu—odpowiedział Jezus. —Ponieważ jednak twierdzicie: „My widzimy”, trwacie w grzechu. ");
INSERT INTO polsz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Następnie powiedział: —Zapewniam was: Kto nie wchodzi do owczarni przez bramę, lecz przez płot, jest złodziejem i przestępcą. ");
INSERT INTO polsz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kto wchodzi przez bramę, jest pasterzem. ");
INSERT INTO polsz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Stróż otwiera mu drzwi, a owce reagują na jego głos. Woła je po imieniu i wyprowadza na pastwisko. ");
INSERT INTO polsz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Gdy już wszystkie wyprowadzi, staje na ich czele, a owce podążają za nim, bo znają jego głos. ");
INSERT INTO polsz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Za obcym natomiast nie pójdą. Spłoszą się, bo nie znają jego głosu. ");
INSERT INTO polsz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Słuchacze nie zrozumieli tej przypowieści opowiedzianej przez Jezusa. ");
INSERT INTO polsz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Wyjaśnił więc: —Zapewniam was: To Ja jestem bramą owczarni. ");
INSERT INTO polsz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wszyscy, którzy przyszli przede Mną, to złodzieje i przestępcy, więc owce nie chciały ich słuchać. ");
INSERT INTO polsz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ja jestem bramą. Kto przeze Mnie wejdzie, zostanie ocalony. Przejdzie przeze Mnie i znajdzie pokarm. ");
INSERT INTO polsz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Złodziej przychodzi, aby kraść, zabijać i niszczyć. Ja przyszedłem, aby owce miały życie—i to życie w obfitości. ");
INSERT INTO polsz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ja jestem dobrym pasterzem, który oddaje życie za swoje owce. ");
INSERT INTO polsz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Najemnik, który nie jest pasterzem i właścicielem owiec, gdy zobaczy zbliżającego się wilka, zostawia owce i ucieka. Wtedy wilk napada na stado i rozprasza je. ");
INSERT INTO polsz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Najemnik jest tylko pracownikiem, więc nie zależy mu na owcach. ");
INSERT INTO polsz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ja jestem dobrym pasterzem. Znam swoje owce i one też Mnie znają ");
INSERT INTO polsz_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","—tak jak Ojciec zna Mnie, a Ja Ojca. Jestem gotów oddać za nie życie. ");
INSERT INTO polsz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mam także inne owce, które nie są z tej owczarni. Je również muszę przyprowadzić, aby słuchały mojego głosu. Wtedy będzie jedna owczarnia i jeden pasterz. ");
INSERT INTO polsz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ojciec kocha Mnie, ponieważ Ja oddaję swoje życie za owce. Ale z powrotem odzyskam życie. ");
INSERT INTO polsz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nikt Mnie do tego nie zmusza—z własnej woli się poświęcam. Mam władzę, aby oddać swoje życie i aby je odzyskać. Takie polecenie otrzymałem od Ojca. ");
INSERT INTO polsz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","I znowu słowa Jezusa spowodowały podział wśród przywódców. ");
INSERT INTO polsz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Jest opanowany przez demona i oszalał—twierdzili jedni. ");
INSERT INTO polsz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","—Czy tak mówi człowiek opanowany przez demona?—komentowali drudzy. —Zastanówcie się! Czy ktoś, kto jest opętany, może uzdrawiać niewidomych? ");
INSERT INTO polsz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","W Jerozolimie obchodzono wtedy święto Poświęcenia Świątyni. Była zima. ");
INSERT INTO polsz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Gdy Jezus spacerował po krużganku Salomona w świątyni, ");
INSERT INTO polsz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","otoczyli Go żydowscy przywódcy i zapytali: —Jak długo będziesz trzymać nas w niepewności? Powiedz nam wprost: Jesteś Mesjaszem? ");
INSERT INTO polsz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","—Przecież już powiedziałem, ale nie uwierzyliście—odrzekł Jezus. —W imieniu mojego Ojca dokonałem również wielu cudów. ");
INSERT INTO polsz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Lecz wy Mi nie wierzycie, bo nie należycie do moich owiec. ");
INSERT INTO polsz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","One Mnie słuchają i podążają za Mną, a Ja je znam. ");
INSERT INTO polsz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nigdy nie zginą, bo daję im wieczne życie. Nikt też nie jest w stanie wyrwać ich z mojej ręki. ");
INSERT INTO polsz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mój Ojciec, który Mi je powierzył, jest najpotężniejszy. I nikt nie wyrwie ich z ręki mojego Ojca. ");
INSERT INTO polsz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ja i Ojciec stanowimy jedno. ");
INSERT INTO polsz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Wtedy przywódcy chwycili kamienie, aby zabić Jezusa. ");
INSERT INTO polsz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","On zaś zapytał ich: —Dokonałem w waszej obecności wielu dobrych czynów w imieniu mojego Ojca. Za który z nich chcecie Mnie zabić? ");
INSERT INTO polsz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Nie za dobre czyny chcemy cię ukamienować, lecz za bluźnierstwo—odpowiedzieli. —Za to, że będąc człowiekiem, nazywasz siebie Bogiem! ");
INSERT INTO polsz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","—Przecież w Prawie Mojżesza jest napisane: „Ja mówię: Bogami jesteście”—odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","—Bóg nazywał tam bogami tych, do których skierował swoje słowo—a przecież Pisma nie wolno lekceważyć. ");
INSERT INTO polsz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Jak więc możecie oskarżać Mnie za to, że powiedziałem: „Jestem Synem Bożym”? Przecież to Ojciec poświęcił Mnie i posłał na świat! ");
INSERT INTO polsz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Jeśli nie wykonuję dzieł mojego Ojca, możecie Mi nie wierzyć. ");
INSERT INTO polsz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Jeśli jednak wykonuję je, to nawet jeśli nie wierzycie Mi, uwierzcie tym dziełom i przekonajcie się, że Ojciec jest we Mnie, a Ja w Nim. ");
INSERT INTO polsz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wtedy raz jeszcze chcieli Go aresztować, ale Jezus wymknął się im. ");
INSERT INTO polsz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Przeprawił się na drugi brzeg Jordanu i zatrzymał się w miejscu, w którym poprzednio Jan Chrzciciel udzielał chrztu. ");
INSERT INTO polsz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","I przychodziło do Niego wielu ludzi, mówiąc: —Jan nie czynił wprawdzie cudów, ale wszystko, co powiedział o Jezusie, dokładnie się sprawdziło. ");
INSERT INTO polsz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","I wielu uwierzyło Mu. ");
INSERT INTO polsz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Pewnego dnia zachorował Łazarz, brat Marii i Marty z Betanii. ");
INSERT INTO polsz_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria była tą kobietą, która namaściła olejkiem stopy Pana i wytarła je swoimi włosami. ");
INSERT INTO polsz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Siostry wysłały do Jezusa wiadomość: „Panie, Twój bliski przyjaciel zachorował”. ");
INSERT INTO polsz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Gdy Jezus to usłyszał, powiedział: —Ta choroba nie zakończy się śmiercią, lecz przyniesie chwałę Bogu i Ja, Syn Człowieczy, również zostanę dzięki niej otoczony chwałą. ");
INSERT INTO polsz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jezus bardzo kochał całą trójkę: Martę, jej siostrę—Marię oraz Łazarza. ");
INSERT INTO polsz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jednak jeszcze dwa dni pozostał tam, gdzie zastała Go ta wiadomość. ");
INSERT INTO polsz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Dopiero wtedy oznajmił uczniom: —Chodźmy jeszcze raz do Judei. ");
INSERT INTO polsz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","—Nauczycielu! Przecież tamtejsi przywódcy chcieli Cię zabić, a Ty znowu tam idziesz?—zaprotestowali. ");
INSERT INTO polsz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","—Czy dzień nie ma dwunastu godzin?—odpowiedział Jezus. —Kto chodzi w ciągu dnia, nie potknie się, bo jest jasno. ");
INSERT INTO polsz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kto zaś chodzi nocą, potyka się, bo panuje ciemność. ");
INSERT INTO polsz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nasz przyjaciel Łazarz zasnął, muszę więc pójść, aby go obudzić. ");
INSERT INTO polsz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Panie! Jeśli zasnął, to znaczy, że powraca do zdrowia—ucieszyli się uczniowie. ");
INSERT INTO polsz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jezus jednak miał na myśli śmierć Łazarza. Oni natomiast myśleli, że mówi o zwykłym śnie. ");
INSERT INTO polsz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Wyjaśnił im więc: —Łazarz umarł. ");
INSERT INTO polsz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ale ze względu na was cieszę się, że Mnie tam nie było. Chcę bowiem, abyście uwierzyli. Chodźmy do niego! ");
INSERT INTO polsz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","—Chodźmy więc! Najwyżej umrzemy razem z nim—odezwał się Tomasz, zwany Bliźniakiem. ");
INSERT INTO polsz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Gdy Jezus dotarł na miejsce, Łazarz już od czterech dni spoczywał w grobie. ");
INSERT INTO polsz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","A Betania leżała blisko Jerozolimy, w odległości niecałych trzech kilometrów, ");
INSERT INTO polsz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","dlatego wielu ludzi z Jerozolimy przyszło do Marty i Marii, aby wyrazić im swoje współczucie po stracie brata. ");
INSERT INTO polsz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Gdy Marta dowiedziała się, że nadchodzi Jezus, wybiegła Mu na spotkanie. Maria zaś została w domu. ");
INSERT INTO polsz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Spotkawszy Jezusa, Marta powiedziała: —Panie, gdybyś tu był, mój brat by nie umarł! ");
INSERT INTO polsz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ale jestem przekonana, że nawet teraz Bóg da Ci to, o co Go poprosisz. ");
INSERT INTO polsz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Twój brat zmartwychwstanie—powiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Tak, wiem o tym—odrzekła Marta. —Ożyje w dniu ostatecznego zmartwychwstania. ");
INSERT INTO polsz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","—To Ja jestem zmartwychwstaniem i życiem—oznajmił Jezus. —Kto wierzy Mi, choćby umarł, będzie żyć. ");
INSERT INTO polsz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","A każdy, kto żyje i wierzy Mi, nigdy nie umrze. Czy wierzysz w to? ");
INSERT INTO polsz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Tak, Panie—odrzekła Marta—wierzę, że jesteś Synem Boga, Mesjaszem, który miał przyjść na świat. ");
INSERT INTO polsz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Po tych słowach odeszła. Zawołała siostrę, Marię, i na osobności powiedziała jej: —Nauczyciel już przyszedł i chce się z tobą zobaczyć. ");
INSERT INTO polsz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria natychmiast wstała i pobiegła do Niego. ");
INSERT INTO polsz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jezus nie wszedł jeszcze do wsi, ale czekał tam, gdzie Go spotkała Marta. ");
INSERT INTO polsz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Przybysze z Jerozolimy, którzy byli z Marią w domu i pocieszali ją, zauważyli, że w pośpiechu wstała i wyszła. Pomyśleli więc, że idzie wypłakać się przy grobie Łazarza, dlatego poszli za nią. ");
INSERT INTO polsz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Gdy Maria doszła do Jezusa i zobaczyła Go, upadła Mu do nóg i powiedziała: —Panie, gdybyś tu był, mój brat by nie umarł. ");
INSERT INTO polsz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jezus zobaczył, jak Maria płacze, a wraz z nią ci, którzy za nią przyszli. Wtedy głęboko się wzruszył i zasmucił. ");
INSERT INTO polsz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—Gdzie go pochowaliście?—zapytał. —Panie, chodź i zobacz—odpowiedzieli. ");
INSERT INTO polsz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Wtedy Jezus zapłakał. ");
INSERT INTO polsz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","—Musiał być mu bardzo bliski!—zauważyli przybysze z Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","—Przecież przywrócił wzrok niewidomemu! Nie mógł więc sprawić, żeby Łazarz nie umarł?—mówili z wyrzutem niektórzy. ");
INSERT INTO polsz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Poruszony do głębi, Jezus dotarł do grobowca. Była to grota, a jej wejście zamykał głaz. ");
INSERT INTO polsz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Odsuńcie głaz!—polecił Jezus. —Panie, ciało już cuchnie! Leży tam już bowiem od czterech dni—zawołała Marta, siostra zmarłego. ");
INSERT INTO polsz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—Przecież powiedziałem ci, że jeśli uwierzysz, ujrzysz Bożą chwałę—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Odsunięto więc głaz. A Jezus podniósł oczy ku górze i rzekł: —Ojcze, dziękuję Ci, że Mnie wysłuchałeś. ");
INSERT INTO polsz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ja wiem, że zawsze Mnie wysłuchujesz, ale mówię to ze względu na tych ludzi, aby uwierzyli, że to Ty Mnie posłałeś. ");
INSERT INTO polsz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Potem zawołał donośnym głosem: —Łazarzu! Wyjdź! ");
INSERT INTO polsz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wtedy zmarły wyszedł z grobu. Jego stopy i ręce były jeszcze powiązane płóciennymi opaskami, a twarz owinięta chustą. —Rozwiążcie go i pozwólcie mu chodzić—rzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Wówczas wielu ludzi z Jerozolimy, którzy przyszli z Marią i zobaczyli ten cud, uwierzyło Jezusowi. ");
INSERT INTO polsz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Niektórzy jednak odeszli stamtąd i powiadomili o wszystkim faryzeuszy. ");
INSERT INTO polsz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ci zaś, razem z najwyższymi kapłanami, zwołali posiedzenie Wysokiej Rady. —Co robić?—zastanawiali się. —Ten człowiek dokonuje tak wielu cudów. ");
INSERT INTO polsz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jeżeli nic z nim nie zrobimy, wszyscy Mu uwierzą! A wtedy nadciągną Rzymianie i odbiorą nam świątynię i władzę nad krajem. ");
INSERT INTO polsz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","W tym momencie głos zabrał niejaki Kajfasz, który tego roku sprawował urząd najwyższego kapłana: —Nic nie rozumiecie! ");
INSERT INTO polsz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Przecież lepiej będzie, jeśli jeden człowiek umrze za naród, niż miałby zginąć cały naród. ");
INSERT INTO polsz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nie powiedział tego sam od siebie. Jako najwyższy kapłan wypowiedział proroctwo, że Jezus ma umrzeć za cały naród. ");
INSERT INTO polsz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","I nie tylko za naród, lecz również po to, aby zgromadzić razem wszystkie Boże dzieci rozproszone po świecie. ");
INSERT INTO polsz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tego dnia przywódcy postanowili więc, że zabiją Jezusa. ");
INSERT INTO polsz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Dlatego przestał On jawnie poruszać się po Judei. Skierował się natomiast wraz z uczniami do Efraim, miasteczka położonego blisko pustyni, i tam się zatrzymał. ");
INSERT INTO polsz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Zbliżało się właśnie święto Paschy. I mnóstwo ludzi z całego kraju napływało do Jerozolimy jeszcze przed świętem, aby dopełnić ceremonii oczyszczenia. ");
INSERT INTO polsz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Wszyscy wypatrywali także Jezusa i będąc w świątyni pytali siebie nawzajem: —Jak myślicie, czy przyjdzie na uroczystości? ");
INSERT INTO polsz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Najwyżsi kapłani i faryzeusze publicznie ogłosili wtedy, że każdy, kto zobaczy Jezusa, ma ich natychmiast o tym poinformować, aby można Go było aresztować. ");
INSERT INTO polsz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na sześć dni przed rozpoczęciem Paschy Jezus przybył do Betanii, do Łazarza, którego niedawno wskrzesił z martwych. ");
INSERT INTO polsz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Przygotowano z tej okazji kolację. Marta im usługiwała, Łazarz siedział razem z Jezusem, ");
INSERT INTO polsz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","natomiast Maria przyniosła butelkę bardzo drogiego olejku nardowego, namaściła nim stopy Jezusa i otarła je własnymi włosami. Cały dom napełnił się wspaniałym zapachem. ");
INSERT INTO polsz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na to Judasz, jeden z uczniów Jezusa (ten, który Go później zdradził), powiedział: ");
INSERT INTO polsz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Przecież można było sprzedać te perfumy i uzyskaną w ten sposób znaczną sumę rozdać biednym! ");
INSERT INTO polsz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Powiedział to jednak nie z troski o biednych, ale dlatego, że był złodziejem. Jako skarbnik trzymał wspólną kasę i wykradał z niej pieniądze. ");
INSERT INTO polsz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","—Daj jej spokój!—odrzekł Jezus. —Przygotowała to na dzień mojego pogrzebu. ");
INSERT INTO polsz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Biedni zawsze będą wśród was, ale Mnie już wkrótce zabraknie. ");
INSERT INTO polsz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Gdy mieszkańcy Jerozolimy dowiedzieli się, że Jezus jest w Betanii, przybyli tam. Chcieli się bowiem z Nim spotkać, ale także zobaczyć Łazarza, którego wzbudził z martwych. ");
INSERT INTO polsz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Wówczas najwyżsi kapłani postanowili zabić również Łazarza, ");
INSERT INTO polsz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","bo z jego powodu wielu Żydów uwierzyło Jezusowi. ");
INSERT INTO polsz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Następnego dnia wśród tłumów, które przybyły na święto, rozeszła się wieść, że Jezus zbliża się do miasta. ");
INSERT INTO polsz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ludzie wzięli więc liście palmowe, wyszli Mu na spotkanie i powitali Go wołając: —Niech żyje Król Izraela! Błogosławiony Ten, który przychodzi w imieniu Pana! ");
INSERT INTO polsz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","A Jezus dosiadł osiołka i jechał na nim, spełniając w ten sposób zapowiedź Pisma: ");
INSERT INTO polsz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","„Nie bój się, córko Syjonu! Oto nadchodzi twój król —jadąc na osiołku!”. ");
INSERT INTO polsz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wtedy jeszcze uczniowie nie rozumieli tego zdarzenia. Ale później, gdy Jezus został otoczony chwałą, przypomnieli sobie, że to o Nim mówiło Pismo. ");
INSERT INTO polsz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ci, którzy wcześniej na własne oczy widzieli, jak Jezus zawołał Łazarza i wskrzesił go z martwych, opowiadali o tym innym. ");
INSERT INTO polsz_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Dlatego aż tak wielki tłum wyszedł powitać Jezusa. Ludzie bowiem dowiedzieli się, że dokonał tego cudu. ");
INSERT INTO polsz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Faryzeusze zaś mówili między sobą: —Chyba nie da się już nic zrobić. Cały świat poszedł za Nim. ");
INSERT INTO polsz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","W tym czasie przybyli na święto pewni Grecy, aby oddać chwałę Bogu. ");
INSERT INTO polsz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Podeszli do Filipa, pochodzącego z Betsaidy w Galilei, i prosili go: —Chcielibyśmy spotkać się z Jezusem. ");
INSERT INTO polsz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip porozmawiał z Andrzejem i razem powiedzieli o tym Jezusowi. ");
INSERT INTO polsz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","—Nadszedł czas, abym Ja, Syn Człowieczy, został otoczony chwałą—odpowiedział im Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","—Zapewniam was: Jeśli ziarno pszenicy wpada w ziemię i nie obumiera, pozostaje samo. Jeśli obumiera, przynosi obfity plon. ");
INSERT INTO polsz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kto kocha ziemskie życie, utraci je. Lecz kto nie przywiązuje wagi do życia na tym świecie, otrzyma życie wieczne. ");
INSERT INTO polsz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kto chce Mi służyć, niech idzie ze Mną. A tam, gdzie Ja będę, będzie i mój sługa. Mój Ojciec doceni bowiem tych, którzy Mi służą. ");
INSERT INTO polsz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Teraz zaś przeżywam wielkie rozdarcie. Czy mam prosić: „Ojcze, uchroń Mnie przed tą chwilą”? Przecież właśnie z jej powodu przyszedłem na świat! ");
INSERT INTO polsz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ojcze, otocz swoje imię chwałą! Wówczas dał się słyszeć głos z nieba: —Już je otoczyłem chwałą i ponownie otoczę. ");
INSERT INTO polsz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","—Zagrzmiało!—powiedzieli niektórzy, słysząc ten głos. —To anioł przemówił—twierdzili inni. ");
INSERT INTO polsz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","—Ten głos odezwał się nie ze względu na Mnie, ale na was—odpowiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","—Nadszedł bowiem czas sądu nad światem. Teraz jego władca zostanie z niego wyrzucony. ");
INSERT INTO polsz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","A Ja, gdy zostanę podniesiony w górę, przyciągnę wszystkich do siebie. ");
INSERT INTO polsz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mówiąc o podniesieniu, dał im do zrozumienia, w jaki sposób umrze. ");
INSERT INTO polsz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Wtedy ludzie z tłumu pytali Go: —Z Prawa Mojżesza wiemy, że Mesjasz będzie żyć wiecznie. Dlaczego więc mówisz, że Syn Człowieczy zostanie podniesiony w górę? Kim On właściwie jest? ");
INSERT INTO polsz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","—Jeszcze tylko przez chwilę będziecie mieli wśród siebie światło—odpowiedział Jezus. —Dopóki możecie, chodźcie więc w jego blasku, aby nie ogarnął was mrok. Kto bowiem chodzi w ciemności, nie wie, dokąd zmierza. ");
INSERT INTO polsz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Póki macie światło, uwierzcie w nie, abyście stali się dziećmi światła. Po tych słowach Jezus odszedł i ukrył się przed tłumem. ");
INSERT INTO polsz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Chociaż dokonał na oczach ludzi wielu cudów, nie wszyscy Mu uwierzyli. ");
INSERT INTO polsz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","W ten sposób spełniły się słowa proroka Izajasza, który powiedział: „Panie, kto uwierzy naszym słowom? Kto rozpoznał Twoje działanie?”. ");
INSERT INTO polsz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nie mogli jednak uwierzyć, ponieważ Izajasz powiedział również: ");
INSERT INTO polsz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","„Pan zaślepił ich oczy i uczynił twardymi ich serca, aby niczego nie widzieli i niczego nie zrozumieli. Dlatego nie chcą się opamiętać i zostać przeze Mnie uzdrowieni”. ");
INSERT INTO polsz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tak właśnie powiedział Izajasz, bo ujrzał Bożą chwałę. ");
INSERT INTO polsz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mimo to wielu przywódców uwierzyło Jezusowi. Nie przyznawali się jednak do tego w obawie przed faryzeuszami, którzy mogli wyrzucić ich z synagogi. ");
INSERT INTO polsz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ludzkie uznanie cenili bowiem bardziej niż przychylność Boga. ");
INSERT INTO polsz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Dalej nauczając, Jezus zawołał do tłumów: —Kto wierzy Mi, wierzy również Temu, który Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","A kto Mnie widzi, widzi także Tego, który Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Przyszedłem na świat jako światło, aby każdy, kto Mi wierzy, nie musiał tkwić w ciemności. ");
INSERT INTO polsz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jeśli ktoś Mnie słucha, ale nie jest Mi posłuszny, nie będę go sądzić. Nie przyszedłem bowiem na świat po to, aby potępić ludzi, ale aby ich zbawić. ");
INSERT INTO polsz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kto odrzuca Mnie i moje słowa, będzie miał jednak innego sędziego: będą nim słowa, które wypowiedziałem. To one osądzą go w dniu ostatecznym. ");
INSERT INTO polsz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nie przemawiałem bowiem z własnej inicjatywy. Ten, który Mnie posłał, przekazał Mi, co i jak mam mówić. ");
INSERT INTO polsz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Przykazania mojego Ojca prowadzą do wiecznego życia, dlatego przekazuję wam, to, co Mi polecił. ");
INSERT INTO polsz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","W przeddzień święta Paschy Jezus wiedział już, że nadszedł Jego czas—czas odejścia ze świata do Ojca. Tym, których ukochał, chciał okazać miłość aż do samego końca. ");
INSERT INTO polsz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","W czasie uroczystej kolacji diabeł zawładnął sercem Judasza (syna Szymona z Kariotu) i pobudził go do zdrady. ");
INSERT INTO polsz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jezus wiedział, że Ojciec wszystko Mu powierzył. Wiedział również, że przyszedł od Ojca i do Niego odchodzi. ");
INSERT INTO polsz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Dlatego wstał od kolacji, przebrał się, przepasał ręcznikiem, ");
INSERT INTO polsz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","a potem nalał wody do miski i zaczął myć uczniom nogi, wycierając je ręcznikiem, który miał na sobie. ");
INSERT INTO polsz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Gdy podszedł do Szymona Piotra, ten zawołał: —Panie, Ty myjesz mi nogi?! ");
INSERT INTO polsz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Teraz nie zrozumiesz tego, co robię—odpowiedział Jezus. —Ale później zrozumiesz. ");
INSERT INTO polsz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—O, nie!—protestował Piotr. —Nigdy nie będziesz mi mył nóg! —Jeśli tego nie zrobię, nie będziesz do Mnie należał—odrzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—W takim razie umyj nie tylko moje nogi, ale także ręce i głowę! ");
INSERT INTO polsz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","—Wykąpany nie musi się myć, bo jest już czysty. Wystarczy, że opłucze nogi. Wy jesteście już czyści—jednak nie wszyscy. ");
INSERT INTO polsz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Wiedział bowiem, kto Go zdradzi. Dlatego powiedział: „Nie wszyscy jesteście czyści”. ");
INSERT INTO polsz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Po umyciu im nóg Jezus z powrotem się przebrał, usiadł z nimi i zapytał: —Czy rozumiecie, co zrobiłem? ");
INSERT INTO polsz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nazywacie Mnie „Nauczycielem” oraz „Panem” i macie rację, bo Nim jestem. ");
INSERT INTO polsz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Skoro więc Ja, wasz Pan i Nauczyciel, umyłem wam nogi, to i wy powinniście czynić podobnie. ");
INSERT INTO polsz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dałem wam przykład, abyście postępowali wobec siebie tak, jak Ja. ");
INSERT INTO polsz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Zapewniam was: Sługa nie jest ważniejszy od swojego pana, a posłaniec—od tego, kto go posłał. ");
INSERT INTO polsz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jeśli będziecie o tym pamiętać i tak postępować—będziecie szczęśliwi. ");
INSERT INTO polsz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nie do wszystkich jednak odnosi się to, co powiedziałem. Wiem bowiem, kogo wybrałem. Muszą się jednak wypełnić słowa Pisma: „Ten, który jadł ze Mną chleb, zwrócił się przeciwko Mnie”. ");
INSERT INTO polsz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mówię o tym już teraz, abyście—gdy tak się stanie—uwierzyli, że JA JESTEM. ");
INSERT INTO polsz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Zapewniam was: Kto przyjmuje mojego posłańca, Mnie samego przyjmuje. A kto Mnie przyjmuje, przyjmuje Tego, który Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Potem, przejęty do głębi, powtórzył raz jeszcze: —Zapewniam was: Jeden z was Mnie zdradzi! ");
INSERT INTO polsz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Zaniepokojeni uczniowie popatrzyli po sobie, zastanawiając się, o kim mówi. ");
INSERT INTO polsz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jeden z nich, najbliższy przyjaciel Jezusa, siedział tuż przy Nim. ");
INSERT INTO polsz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Szymon Piotr dał mu więc znak, aby zapytał, o kogo chodzi. ");
INSERT INTO polsz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ten więc nachylił się i zapytał: —Panie, kto to? ");
INSERT INTO polsz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—To ten, któremu podam kawałek umoczonego w sosie chleba—odrzekł Jezus. Umoczył więc kawałek i podał Judaszowi. ");
INSERT INTO polsz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","On zjadł i wtedy opanował go szatan. Jezus zaś powiedział do Judasza: —Zrób szybko to, co zamierzasz. ");
INSERT INTO polsz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nikt jednak tego nie zrozumiał. ");
INSERT INTO polsz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ponieważ Judasz był skarbnikiem, niektórzy myśleli, że Jezus wydał mu polecenie: „Kup rzeczy potrzebne na święto” lub „Zanieś pieniądze biednym”. ");
INSERT INTO polsz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Gdy więc Judasz zjadł podany kawałek chleba, natychmiast wyszedł. A była już noc. ");
INSERT INTO polsz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Po jego wyjściu Jezus powiedział: —Ja, Syn Człowieczy, zostałem teraz otoczony chwałą. I otoczę chwałą Boga. ");
INSERT INTO polsz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","On zaś wkrótce otoczy chwałą Mnie. ");
INSERT INTO polsz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kochani! Będę z wami jeszcze tylko chwilę. Potem będziecie Mnie szukać, ale jak powiedziałem przywódcom, tak i wam powtarzam: Tam, gdzie idę, nie możecie pójść. ");
INSERT INTO polsz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Daję wam nowe przykazanie, abyście się wzajemnie kochali. Jak Ja was ukochałem, tak wy macie kochać jedni drugich. ");
INSERT INTO polsz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Jeśli będziecie okazywać sobie nawzajem miłość, wszyscy rozpoznają, że naprawdę jesteście moimi uczniami. ");
INSERT INTO polsz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","—Panie, ale dokąd odchodzisz?—zaniepokoił się Szymon Piotr. —Teraz nie możesz iść tam razem ze Mną—odpowiedział Jezus—ale kiedyś pójdziesz. ");
INSERT INTO polsz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—Dlaczego nie teraz, Panie? Oddam za Ciebie życie! ");
INSERT INTO polsz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—Oddasz za Mnie życie?—odparł Jezus. —Zapewniam cię, że zanim rano zapieje kogut, trzy razy zaprzeczysz, że Mnie znasz. ");
INSERT INTO polsz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Niech wasze serca nie drżą ze strachu. Wierzcie Bogu—i Mi wierzcie! ");
INSERT INTO polsz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","W domu mojego Ojca jest wiele mieszkań. Gdyby tak nie było, to czy mówiłbym wam, że idę przygotować wam miejsce? ");
INSERT INTO polsz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","A gdy odejdę i wszystko przygotuję, wrócę i zabiorę was ze sobą, abyście byli tam, gdzie Ja. ");
INSERT INTO polsz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Przecież znacie drogę prowadzącą tam, dokąd odchodzę. ");
INSERT INTO polsz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","—Panie, nie mamy pojęcia, dokąd odchodzisz—odezwał się Tomasz. —Jak więc możemy znać drogę? ");
INSERT INTO polsz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","—Ja jestem drogą, prawdą i życiem—odpowiedział mu Jezus. —Nikt nie przychodzi do Ojca inaczej, jak tylko przeze Mnie. ");
INSERT INTO polsz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jeśli Mnie poznaliście, będziecie znać także mojego Ojca. Zresztą już Go znacie, bo Go zobaczyliście. ");
INSERT INTO polsz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","—Panie, pokaż nam Ojca, a to nam wystarczy—rzekł Filip. ");
INSERT INTO polsz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","—Filipie! Tak długo z wami przebywam, a wciąż jeszcze nie wiesz, kim jestem?—odpowiedział Jezus. —Kto Mnie zobaczył, zobaczył również Ojca. Dlaczego więc prosisz: Pokaż nam Ojca? ");
INSERT INTO polsz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Czy nie wierzysz, że jestem w Ojcu, a Ojciec we Mnie? Dzieła, o których wam mówię, nie są moją inicjatywą. Dokonuje ich Ojciec, który jest we Mnie. ");
INSERT INTO polsz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Uwierzcie, że jestem w Ojcu, a Ojciec we Mnie. A jeśli nie chcecie wierzyć Mi na słowo, uwierzcie ze względu na dzieła Ojca. ");
INSERT INTO polsz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Zapewniam was: Kto Mi wierzy, będzie czynił cuda takie, jak Ja—a nawet jeszcze większe, bo już odchodzę do Ojca. ");
INSERT INTO polsz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","I zrobię to, o co poprosicie w moim imieniu—w ten sposób otoczę mojego Ojca chwałą. ");
INSERT INTO polsz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Jeśli będziecie Mnie o coś prosić w moim imieniu, zrobię to. ");
INSERT INTO polsz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jeśli Mnie kochacie, będziecie posłuszni moim nakazom. ");
INSERT INTO polsz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","A Ja poproszę Ojca, aby dał wam innego Pocieszyciela—takiego, który pozostanie z wami na zawsze. ");
INSERT INTO polsz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jest to Duch prawdy, którego świat nie może przyjąć, bo Go nie dostrzega i nie zna. Wy jednak Go znacie, bo już jest z wami, a będzie także w was. ");
INSERT INTO polsz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nie zostawię was samych—przyjdę do was. ");
INSERT INTO polsz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Już za chwilę zniknę z oczu świata. Ale wy Mnie widzicie, bo żyję—i wy też będziecie żyć. ");
INSERT INTO polsz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","W tym dniu przekonacie się, że Ja jestem w Ojcu, wy—we Mnie, a Ja—w was. ");
INSERT INTO polsz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Pamiętajcie: Ten Mnie naprawdę kocha, kto zna moje nakazy i stosuje się do nich. A kto Mnie kocha, tego kocha również mój Ojciec, i Ja go kocham, i objawię mu siebie. ");
INSERT INTO polsz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Zapytał Go wtedy Juda (nie ten z Kariotu): —Panie, dlaczego nie objawisz się światu, a tylko nam? ");
INSERT INTO polsz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","—Kto Mnie kocha, będzie posłuszny moim słowom—odparł Jezus. —Mój Ojciec też będzie go kochał i przyjdziemy do niego, i w nim zamieszkamy. ");
INSERT INTO polsz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kto zaś nie kocha Mnie, nie będzie posłuszny moim słowom. A moje słowa nie pochodzą ode Mnie, ale od Ojca, który Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mówię o tym teraz, dopóki jestem z wami. ");
INSERT INTO polsz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Gdy Ojciec pośle do was w moim imieniu Pocieszyciela—Ducha Świętego—to On wszystkiego was nauczy i przypomni to, o czym wcześniej mówiłem. ");
INSERT INTO polsz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Zostawiam wam mój pokój i daję go wam. Nie jest to pokój, jaki oferuje świat, ale pokój pochodzący ode Mnie. Niech więc wasze serca nie drżą ze strachu i niech się nie lękają. ");
INSERT INTO polsz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Pamiętacie, że powiedziałem wam: Odchodzę, ale przyjdę do was znowu. Gdybyście Mnie szczerze kochali, cieszylibyście się, że wracam do Ojca, który jest większy ode Mnie. ");
INSERT INTO polsz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tak więc uprzedziłem was o tym, co nastąpi, abyście uwierzyli Mi, gdy to się stanie. ");
INSERT INTO polsz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Musimy jednak kończyć tę rozmowę, bo zbliża się władca tego świata. Nie ma on jednak nade Mną żadnej władzy. ");
INSERT INTO polsz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Chcę, aby cały świat zobaczył, że kocham Ojca i robię wszystko, co Mi polecił. Teraz jednak wstańmy i chodźmy stąd! ");
INSERT INTO polsz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Potem Jezus powiedział: —Ja jestem prawdziwym krzewem winorośli, a mój Ojciec—ogrodnikiem. ");
INSERT INTO polsz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Odcina każdą gałązkę, która nie owocuje, a tę, która już owocuje, oczyszcza, aby owocowała jeszcze lepiej. ");
INSERT INTO polsz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Wy już jesteście oczyszczeni dzięki temu, co wam powiedziałem. ");
INSERT INTO polsz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Trwajcie we Mnie, a Ja będę trwał w was. Tak jak gałązka nie może owocować sama z siebie, jeśli nie trwa w krzewie, tak i wy—jeśli nie trwacie we Mnie. ");
INSERT INTO polsz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ja jestem krzewem winorośli, a wy—jego gałązkami. Kto trwa we Mnie, a Ja w nim, ten obficie owocuje. Beze Mnie jednak nic nie możecie zrobić. ");
INSERT INTO polsz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jeżeli ktoś nie trwa we Mnie, zostanie odrzucony—tak jak gałązka, która usycha. Zbiera się takie, wrzuca do ognia i spala. ");
INSERT INTO polsz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Jeśli jednak będziecie we Mnie trwać, a moje słowa—w was, proście o cokolwiek chcecie, a tak się stanie. ");
INSERT INTO polsz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mój Ojciec dozna chwały przez to, że obficie zaowocujecie i staniecie się moimi uczniami. ");
INSERT INTO polsz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ukochałem was tak, jak Mnie ukochał Ojciec. Trwajcie więc w mojej miłości. ");
INSERT INTO polsz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","A będziecie w niej trwać, gdy okażecie posłuszeństwo moim nakazom—tak jak Ja jestem posłuszny nakazom mojego Ojca i trwam w Jego miłości. ");
INSERT INTO polsz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mówię o tym po to, abyście mieli w sobie moją radość i abyście byli nią napełnieni. ");
INSERT INTO polsz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Daję wam moje przykazanie, abyście kochali się nawzajem, tak jak Ja was ukochałem. ");
INSERT INTO polsz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nikt nie kocha bardziej niż ten, kto oddaje swoje życie za przyjaciół. ");
INSERT INTO polsz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Wy jesteście moimi przyjaciółmi, jeśli robicie to, co wam nakazuję. ");
INSERT INTO polsz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Już nie nazywam was sługami, bo sługa nie wie, co zamierza jego pan. Nazwałem was przyjaciółmi, bo powiedziałem wam wszystko, co usłyszałem od Ojca. ");
INSERT INTO polsz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","To nie wy Mnie wybraliście, ale Ja was. Przeznaczyłem was do tego, abyście szli i przynosili owoc—trwały owoc!—i aby Ojciec dał wam to, o co Go poprosicie w moim imieniu. ");
INSERT INTO polsz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nakazuję wam więc, abyście kochali jedni drugich! ");
INSERT INTO polsz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jeśli świat was nienawidzi, to pamiętajcie, że Mnie najpierw znienawidził. ");
INSERT INTO polsz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Gdybyście należeli do świata, kochałby was. Ponieważ jednak nie należycie do niego—bo Ja was wybrałem dla siebie—nienawidzi was. ");
INSERT INTO polsz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Przypomnijcie sobie, co wam niedawno powiedziałem: Sługa nie jest ważniejszy od swojego pana. Skoro Mnie prześladowali, i was będą prześladować. A jeśli słuchali moich słów, i waszych posłuchają. ");
INSERT INTO polsz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ze względu na Mnie będą was prześladować, bo nie znają Tego, który Mnie posłał. ");
INSERT INTO polsz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Gdybym nie przyszedł i nie mówił do nich, nie mieliby grzechu. Lecz teraz już nie mogą się usprawiedliwić. ");
INSERT INTO polsz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kto Mnie nienawidzi, nienawidzi także mojego Ojca. ");
INSERT INTO polsz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nie mieliby grzechu, gdybym nie uczynił na ich oczach cudów, których nikt nigdy nie dokonał. Oni jednak widzieli je, a mimo to znienawidzili i Mnie, i Ojca. ");
INSERT INTO polsz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","W ten sposób sprawdziły się słowa zapisane w Piśmie: „Znienawidzili Mnie bez powodu”. ");
INSERT INTO polsz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Lecz Pocieszyciel—Duch prawdy, którego poślę wam od mojego Ojca, opowie wam o Mnie, ");
INSERT INTO polsz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","a wy opowiecie o Mnie innym, bo jesteście ze Mną od samego początku. ");
INSERT INTO polsz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Powiedziałem wam o tym, abyście się nie załamali. ");
INSERT INTO polsz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wyrzucą was bowiem z synagogi. Co więcej, nadchodzi czas, gdy ludzie chcący was zabić będą przekonani, że ich działanie podoba się Bogu. ");
INSERT INTO polsz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Będą tak postępować, bo nigdy nie poznali ani Ojca, ani Mnie. ");
INSERT INTO polsz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mówię o tym teraz, zanim ten czas nastanie, abyście pamiętali, że was ostrzegałem. Nie mówiłem o tym wcześniej, bo byłem z wami. ");
INSERT INTO polsz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Teraz jednak odchodzę do Tego, który Mnie posłał. Nie pytacie już: „Dokąd odchodzisz?”. ");
INSERT INTO polsz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Powiedziałem wam bowiem o tym i smutek wypełnił wasze serca. ");
INSERT INTO polsz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Zapewniam was jednak, że moje odejście jest dla was korzystne. Jeśli bowiem nie odejdę, Pocieszyciel do was nie przyjdzie. Ale gdy odejdę, przyślę Go do was. ");
INSERT INTO polsz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Wtedy On przekona świat o grzechu, o prawości i o sądzie. ");
INSERT INTO polsz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","O grzechu—bo ludzie Mi nie wierzą. ");
INSERT INTO polsz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","O prawości—bo odchodzę do Ojca i już Mnie nie ujrzycie. ");
INSERT INTO polsz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","O sądzie—bo władca tego świata już został skazany. ");
INSERT INTO polsz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Tak wiele chciałbym wam jeszcze powiedzieć, lecz teraz nie jesteście w stanie tego zrozumieć. ");
INSERT INTO polsz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Gdy jednak przyjdzie Duch prawdy, wprowadzi was w całą prawdę. Nie będzie mówił sam od siebie, lecz przekaże wam to, co usłyszał. Powie wam także o tym, co przyniesie przyszłość. ");
INSERT INTO polsz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","On otoczy Mnie chwałą, bo przekaże wam to, co do Mnie należy. ");
INSERT INTO polsz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wszystko, co ma Ojciec, jest moje. Dlatego powiedziałem, że Duch weźmie ode Mnie i wam to przekaże. ");
INSERT INTO polsz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Już niebawem odejdę. Ale wkrótce zobaczycie Mnie znowu! ");
INSERT INTO polsz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","—O co Mu chodzi?—zastanawiali się uczniowie. —„Już niebawem odejdę. Ale wkrótce zobaczycie Mnie znowu” albo „Odchodzę do Ojca”? ");
INSERT INTO polsz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Co ma na myśli, mówiąc: „Już niebawem”? Nie rozumiemy tego. ");
INSERT INTO polsz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jezus wiedział, że chcieli Go o to zapytać. Powiedział więc: —Zastanawiacie się, co miałem na myśli, mówiąc: „Już niebawem odejdę. Ale wkrótce zobaczycie Mnie znowu”? ");
INSERT INTO polsz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Zapewniam was: Wkrótce będziecie płakać i smucić się, a świat będzie się cieszyć. Wasz smutek zostanie jednak przemieniony w radość. ");
INSERT INTO polsz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Gdy kobieta rodzi, doznaje smutku, bo nadszedł czas rozwiązania. Ale gdy już urodzi, z radości zapomina o bólu, bo jej dziecko przyszło na świat. ");
INSERT INTO polsz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Teraz przytłacza was smutek, ale gdy zobaczę was znowu, wasze serca napełnią się radością—radością, której już nikt nie zdoła wam odebrać. ");
INSERT INTO polsz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Wtedy nie będziecie Mnie już o nic pytać. Zapewniam was: Jeśli wtedy poprosicie o coś Ojca w moim imieniu, da wam to. ");
INSERT INTO polsz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dotychczas nie prosiliście Go o nic w moim imieniu. Teraz proście, a otrzymacie, i wasza radość nie będzie miała granic! ");
INSERT INTO polsz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","O wielu rzeczach mówiłem wam za pomocą przypowieści. Nadchodzi jednak czas, gdy o sprawach dotyczących Ojca będę wam mówił wprost—bez porównań. ");
INSERT INTO polsz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wtedy będziecie prosić w moim imieniu, a Ja nie będę musiał o to prosić Ojca. ");
INSERT INTO polsz_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","On sam was kocha, ponieważ wy Mnie ukochaliście i uwierzyliście, że przyszedłem od Niego. ");
INSERT INTO polsz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tak, przyszedłem na świat od Ojca i opuszczam świat, aby do Niego powrócić. ");
INSERT INTO polsz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","—Teraz wszystko mówisz nam wprost, bez porównań—odrzekli uczniowie. ");
INSERT INTO polsz_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","—Nareszcie rozumiemy, że wszystko wiesz i nie potrzebujesz, aby ktokolwiek zadawał Ci pytania. Wierzymy, że przyszedłeś od Boga. ");
INSERT INTO polsz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","—Mówicie, że wierzycie?—rzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","—Oto nadchodzi czas, a właściwie już nadszedł, gdy pouciekacie do swoich domów i zostawicie Mnie samego. Nie będę jednak sam, ponieważ jest ze Mną Ojciec. ");
INSERT INTO polsz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Powiedziałem wam o tym wszystkim, abyście dzięki Mnie doświadczali pokoju. Na świecie czeka was cierpienie. Ale bądźcie odważni—Ja zwyciężyłem ten świat. ");
INSERT INTO polsz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Gdy Jezus skończył rozmowę z nimi, spojrzał w niebo i rzekł: —Ojcze, nadszedł już czas. Otocz swojego Syna chwałą, aby i On otoczył chwałą Ciebie. ");
INSERT INTO polsz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Udzieliłeś Mi władzy nad każdym człowiekiem po to, abym dał życie wieczne wszystkim, których Mi powierzyłeś. ");
INSERT INTO polsz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A życie wieczne polega na poznaniu Ciebie—jedynego, prawdziwego Boga, i Jezusa Chrystusa, którego posłałeś. ");
INSERT INTO polsz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Otoczyłem Cię chwałą na ziemi, bo wykonałem zadanie, które Mi zleciłeś. ");
INSERT INTO polsz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Teraz więc, Ojcze, otocz Mnie tą chwałą, którą miałem u Ciebie, zanim powstał świat. ");
INSERT INTO polsz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Objawiłem Cię ludziom, których Mi dałeś ze świata. Należeli do Ciebie i powierzyłeś Mi ich, a oni zachowali Twoje słowo. ");
INSERT INTO polsz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Już wiedzą, że wszystko, co mam, pochodzi od Ciebie. ");
INSERT INTO polsz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Przekazałem im Twoje polecenia, a oni je przyjęli i rozpoznali, że to Ty Mnie posłałeś. ");
INSERT INTO polsz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Właśnie za nich się modlę. Nie za świat, lecz za tych, których Mi powierzyłeś, bo należą do Ciebie. ");
INSERT INTO polsz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Wszystko, co należy do Mnie, jest Twoje, a Twoje—jest moje. Oni zaś oddają Mi chwałę. ");
INSERT INTO polsz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ja opuszczam ten świat i idę do Ciebie, ale oni zostają. Dlatego, Ojcze święty, ochraniaj ich mocą Twojego imienia, które Mi dałeś. I spraw, aby żyli w takiej jedności, jak My. ");
INSERT INTO polsz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Dopóki z nimi byłem, sam ochraniałem ich mocą Twojego imienia, którą Mi dałeś. Strzegłem ich i nie zginął nikt z nich, z wyjątkiem syna zatracenia—jak przepowiedziało Pismo. ");
INSERT INTO polsz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Teraz zaś idę do Ciebie i mówię im o tym, aby napełniała ich moja radość. ");
INSERT INTO polsz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Przekazałem im Twoje słowo, a świat ich znienawidzi, ponieważ—tak jak Ja—nie należą do niego. ");
INSERT INTO polsz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nie proszę, abyś ich stąd zabrał, lecz abyś chronił ich przed złem. ");
INSERT INTO polsz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tak jak i Ja, nie należą oni do świata. ");
INSERT INTO polsz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Spraw, aby byli oddani prawdzie, którą jest Twoje słowo. ");
INSERT INTO polsz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tak jak Ty posłałeś Mnie na świat, tak teraz Ja posyłam ich do innych ludzi. ");
INSERT INTO polsz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Za nich też poświęcam siebie, aby byli oddani prawdzie. ");
INSERT INTO polsz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Modlę się nie tylko za nich, ale także za tych, którzy dzięki ich słowom uwierzą Mi. ");
INSERT INTO polsz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ojcze, niech wszyscy oni żyją w jedności, jak Ty we Mnie, a Ja w Tobie. Niech będą w jedności z nami, aby świat uwierzył, że to Ty Mnie posłałeś! ");
INSERT INTO polsz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Obdarzyłem ich też chwałą, którą Mi dałeś, aby żyli w jedności, tak jak My: ");
INSERT INTO polsz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ja w nich, a Ty we Mnie—aby żyli w doskonałej jedności, wtedy bowiem świat zrozumie, że Mnie posłałeś i że ukochałeś ich tak jak Mnie. ");
INSERT INTO polsz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ojcze, chcę, aby ci, których Mi powierzyłeś, byli ze Mną tam, gdzie Ja będę, i aby mogli widzieć chwałę, którą Mi dałeś. Ukochałeś Mnie bowiem, zanim powstał świat. ");
INSERT INTO polsz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Sprawiedliwy Ojcze! Świat Cię nie poznał, ale Ja Cię znam. I oni również wiedzą, że to Ty Mnie posłałeś. ");
INSERT INTO polsz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Objawiłem im bowiem Ciebie i nadal będę objawiać, aby doświadczyli tej wspaniałej miłości, jaką Mnie obdarzasz, i abym mógł w nich trwać. ");
INSERT INTO polsz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Potem Jezus udał się z uczniami do ogrodu, znajdującego się za potokiem Cedron. ");
INSERT INTO polsz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judasz, zdrajca, znał to miejsce, bo Jezus często odwiedzał je z uczniami. ");
INSERT INTO polsz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Przyszedł więc tam wraz z rzymskim oddziałem oraz strażą, wysłaną przez najwyższych kapłanów i faryzeuszy. Uzbrojeni, nieśli pochodnie i latarnie. ");
INSERT INTO polsz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jezus wiedząc, co Go czeka, wyszedł im na spotkanie ");
INSERT INTO polsz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","i zapytał: —Kogo szukacie? —Jezusa z Nazaretu—powiedzieli. —JA JESTEM—odrzekł Jezus. W tłumie stał również Judasz—zdrajca. ");
INSERT INTO polsz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","A gdy Jezus powiedział: „JA JESTEM”, wszyscy cofnęli się i padli na ziemię. ");
INSERT INTO polsz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","—Kogo szukacie?—powtórzył Jezus. —Jezusa z Nazaretu—odpowiedzieli. ");
INSERT INTO polsz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Mówię wam, że to Ja—powiedział Jezus. —Skoro szukacie Mnie, pozwólcie reszcie odejść. ");
INSERT INTO polsz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Powiedział to, aby wypełniła się zapowiedź proroka: „Nie utraciłem ani jednego z tych, których Mi dałeś”. ");
INSERT INTO polsz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Wtedy Szymon Piotr wyjął miecz, zamachnął się i odciął prawe ucho słudze najwyższego kapłana, Malchusowi. ");
INSERT INTO polsz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","—Schowaj miecz—rzekł do niego Jezus. —Czyż nie mam pić z kielicha, który podaje Mi Ojciec? ");
INSERT INTO polsz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Wtedy żołnierze, ich dowódca oraz strażnicy wysłani przez kapłanów złapali Jezusa, związali Go ");
INSERT INTO polsz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","i zaprowadzili najpierw do Annasza, który był teściem Kajfasza, sprawującego tego roku urząd najwyższego kapłana. ");
INSERT INTO polsz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","To właśnie Kajfasz powiedział wcześniej żydowskim przywódcom, że lepiej będzie, aby jeden człowiek umarł za cały naród. ");
INSERT INTO polsz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Za Jezusem podążał Szymon Piotr i jeszcze jeden uczeń, który był znajomym najwyższego kapłana. Dzięki temu wszedł razem z Jezusem na dziedziniec rezydencji najwyższego kapłana. ");
INSERT INTO polsz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Tymczasem Piotr został za bramą. Drugi uczeń porozmawiał jednak z kobietą pełniącą służbę przy drzwiach i po chwili wprowadził na dziedziniec również Piotra. ");
INSERT INTO polsz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","—Ty chyba jesteś jednym z uczniów tego człowieka?—zapytała Piotra służąca. —Ależ skąd!—zaprzeczył. ");
INSERT INTO polsz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Było zimno, więc słudzy oraz strażnicy rozpalili ognisko i grzali się przy nim. Wśród nich stał również Piotr. ");
INSERT INTO polsz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","W tym czasie najwyższy kapłan wypytywał Jezusa o Jego naukę i zwolenników. ");
INSERT INTO polsz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","—Nauczałem publicznie—odpowiedział Jezus. —Przemawiałem w synagodze i w świątyni, wśród wielu ludzi. Niczego nie mówiłem po kryjomu. ");
INSERT INTO polsz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Dlaczego Mnie więc o to pytasz? Zapytaj tych, którzy Mnie słuchali. Oni wiedzą, co mówiłem. ");
INSERT INTO polsz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","—Jak się odzywasz do najwyższego kapłana?!—zawołał stojący w pobliżu sługa i uderzył Jezusa w twarz. ");
INSERT INTO polsz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","—Jeśli powiedziałem coś złego, udowodnij to—odrzekł Jezus. —A jeśli nie, to dlaczego Mnie uderzyłeś? ");
INSERT INTO polsz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Wtedy Annasz odesłał związanego Jezusa do najwyższego kapłana, Kajfasza. ");
INSERT INTO polsz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tymczasem Piotr nadal grzał się przy ognisku. —Nie jesteś przypadkiem jednym z uczniów Jezusa?—zapytano go. —Oczywiście, że nie—wyparł się Piotr. ");
INSERT INTO polsz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ale jeden ze służących najwyższego kapłana, krewny tego, któremu Piotr odciął ucho, stwierdził: —Chyba widziałem ciebie razem z nim w ogrodzie?! ");
INSERT INTO polsz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piotr znowu zaprzeczył. I wtedy właśnie zapiał kogut. ");
INSERT INTO polsz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Było już rano. Od Kajfasza zaprowadzono Jezusa do rezydencji gubernatora. Oskarżyciele jednak nie weszli do środka, aby nie narazić się na rytualną nieczystość. Chcieli bowiem uczestniczyć w kolacji paschalnej. ");
INSERT INTO polsz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Piłat, rzymski gubernator, wyszedł więc do nich i zapytał: —Jakie zarzuty stawiacie temu człowiekowi? ");
INSERT INTO polsz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Gdyby nie był przestępcą, nie przyprowadzalibyśmy go do ciebie—odpowiedzieli. ");
INSERT INTO polsz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","—Zabierzcie go sobie i sądźcie według własnego prawa—odrzekł Piłat. —Przecież wiesz, że bez twojej zgody nie wolno nam nikogo skazać na śmierć—tłumaczyli. ");
INSERT INTO polsz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","W ten sposób spełniła się zapowiedź Jezusa, dotycząca sposobu, w jaki zostanie zabity. ");
INSERT INTO polsz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Piłat wrócił więc do rezydencji i polecił, aby przyprowadzono Jezusa. —Jesteś Królem Żydów?—zapytał. ");
INSERT INTO polsz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","—Sam tak uważasz czy tylko powtarzasz, co ci powiedziano?—odpowiedział pytaniem Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—Czy ja jestem Żydem?—odparł Piłat. —To twój naród i jego przywódcy przyprowadzili cię do mnie. Co zrobiłeś? ");
INSERT INTO polsz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—Moje królestwo nie pochodzi z tego świata—rzekł Jezus. —Gdyby tak było, moi słudzy walczyliby, żebym nie wpadł w ręce przywódców. Teraz moje królestwo nie jest jednak z tego świata. ");
INSERT INTO polsz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—Więc jednak jesteś królem? —Sam to potwierdzasz. Po to się narodziłem i po to przyszedłem na świat, aby opowiedzieć ludziom o prawdzie. A każdy, kto kocha prawdę, słucha Mnie. ");
INSERT INTO polsz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—Co to jest prawda?—zapytał Piłat. Następnie wyszedł do zebranych i powiedział: —Nie znajduję w nim żadnej winy! ");
INSERT INTO polsz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Jest zwyczaj, że na święto Paschy uwalniam wam jednego z waszych więźniów. Jeśli więc chcecie, tym razem uwolnię Króla Żydów. ");
INSERT INTO polsz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","—Nie! Nie tego! Wypuść raczej Barabasza!—zaczęli krzyczeć. A Barabasz był buntownikiem. ");
INSERT INTO polsz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Piłat kazał więc wyprowadzić Jezusa i ubiczować. ");
INSERT INTO polsz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Żołnierze włożyli na Jego głowę koronę uplecioną z długich, ostrych cierni i ubrali Go w purpurowy płaszcz. ");
INSERT INTO polsz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Podchodzili do Niego, bili po twarzy i wykrzykiwali: —Niech żyje Król Żydów! ");
INSERT INTO polsz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Potem Piłat raz jeszcze wyszedł do tłumu mówiąc: —Wyprowadzam go tu, żebyście zobaczyli, że nie znajduję w nim żadnej winy. ");
INSERT INTO polsz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Wtedy Jezus wyszedł na zewnątrz—w purpurowym płaszczu i koronie cierniowej na głowie. —Oto człowiek!—rzekł Piłat. ");
INSERT INTO polsz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","—Ukrzyżuj! Ukrzyżuj go!—zaczęli krzyczeć kapłani i ich strażnicy na widok Jezusa. —Sami go ukrzyżujcie! Ja nie znajduję w nim żadnej winy!—odpowiedział Piłat. ");
INSERT INTO polsz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","—My też mamy Prawo. I według naszego Prawa powinien zginąć, bo nazywał siebie Synem Bożym!—wołali. ");
INSERT INTO polsz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Te słowa jeszcze bardziej przestraszyły Piłata. ");
INSERT INTO polsz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ponownie wszedł do rezydencji i zapytał Jezusa: —Skąd pochodzisz? Ale Jezus nic mu nie odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","—Nie chcesz ze mną rozmawiać?—dziwił się. —Czy nie wiesz, że mam prawo cię uwolnić albo ukrzyżować? ");
INSERT INTO polsz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—Nie miałbyś nade Mną władzy, gdyby nie dano ci jej z góry—odrzekł Jezus. —Dlatego większy grzech popełnił ten, który oddał Mnie w twoje ręce. ");
INSERT INTO polsz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Od tego momentu Piłat starał się uwolnić Jezusa, ale żydowscy przywódcy ostro się temu sprzeciwiali: —Jeśli go uwolnisz, nie będziesz przyjacielem cezara. Kto obwołuje się królem, występuje przecież przeciwko cezarowi. ");
INSERT INTO polsz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Usłyszawszy to, Piłat znowu wyprowadził Jezusa na zewnątrz, sam zaś usiadł na fotelu sędziowskim, w miejscu zwanym Kamienny Bruk (po hebrajsku: „Gabbata”). ");
INSERT INTO polsz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Było około południa, następnego dnia rozpoczynała się Pascha. Wtedy rzekł do zebranych: —Oto wasz król! ");
INSERT INTO polsz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","—Precz z nim! Przecz! Ukrzyżuj go!—krzyczeli. —Mam ukrzyżować waszego króla?!—pytał Piłat. —Nie mamy żadnego króla oprócz cezara!—zawołali najwyżsi kapłani. ");
INSERT INTO polsz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Wówczas Piłat wydał im Jezusa, aby Go ukrzyżowali. I zabrali Go. ");
INSERT INTO polsz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jezus niósł swój krzyż na miejsce zwane Czaszką (po hebrajsku: „Golgota”). ");
INSERT INTO polsz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Gdy dotarł na miejsce, ukrzyżowano Go razem z dwoma innymi skazańcami: Jezusa w środku, a tych dwóch po Jego prawej i lewej stronie. ");
INSERT INTO polsz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Piłat zaś przygotował i kazał umieścić na krzyżu tabliczkę z napisem: „Jezus z Nazaretu, Król Żydów”. ");
INSERT INTO polsz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wielu Żydów mogło więc przeczytać ten opis Jego winy (sporządzony po hebrajsku, łacinie i grecku), bowiem miejsce, gdzie ukrzyżowano Jezusa, znajdowało się w pobliżu miasta. ");
INSERT INTO polsz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kapłani jednak domagali się od Piłata: —Nie pisz: „Król Żydów”, ale: „Twierdził, że jest Królem Żydów”. ");
INSERT INTO polsz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—Napisałem i koniec!—odrzekł Piłat. ");
INSERT INTO polsz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Po ukrzyżowaniu Jezusa, żołnierze zabrali Jego ubrania i podzielili je na cztery części—dla każdego po jednej. Wzięli też tunikę, która była utkana w całości—bez szwów. ");
INSERT INTO polsz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","—Nie rozdzierajmy jej—mówili między sobą—ale rzućmy o nią losy. Zobaczymy, kto ją wygra. W ten sposób spełniło się proroctwo: „Rozdzielają między siebie moje ubrania i rzucają losy o moją tunikę”. Tak właśnie uczynili żołnierze. ");
INSERT INTO polsz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","A obok krzyża Jezusa stały: Jego matka, Jego ciotka—Maria (żona Kleofasa) i Maria z Magdali. ");
INSERT INTO polsz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Gdy Jezus zobaczył matkę stojącą obok ucznia, który był Jego najbliższym przyjacielem, rzekł do niej: —To jest twój syn! ");
INSERT INTO polsz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","A do ucznia: —To jest twoja matka! I od tego momentu uczeń wziął ją do swojego domu. ");
INSERT INTO polsz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wiedząc, że Jego dzieło dobiegło już końca, Jezus—wypełniając zapowiedź Pisma—rzekł: —Jestem spragniony. ");
INSERT INTO polsz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","A stał tam dzban z kwaśnym winem. Nasączono nim więc gąbkę i na kiju podano Mu do ust. ");
INSERT INTO polsz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Gdy Jezus skosztował, rzekł: —Wykonało się. Po tych słowach opuścił głowę i skonał. ");
INSERT INTO polsz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ponieważ był to dzień poprzedzający szabat i wielkie święto, żydowscy przywódcy nie chcieli zostawić martwych ciał na krzyżach do następnego dnia. Poprosili więc Piłata, aby połamano skazańcom nogi, przyspieszając ich śmierć, i usunięto ciała. ");
INSERT INTO polsz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Przyszli więc żołnierze i połamali nogi—najpierw jednemu skazańcowi ukrzyżowanemu z Jezusem, potem drugiemu. ");
INSERT INTO polsz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Gdy podeszli do Jezusa, zobaczyli, że już umarł. Nie łamali Mu więc nóg. ");
INSERT INTO polsz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Jeden z żołnierzy przebił jednak włócznią Jego bok, z którego wypłynęła krew i woda. ");
INSERT INTO polsz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wiemy, że tak było, ponieważ potwierdził to naoczny świadek, a jego opis jest zgodny z prawdą. On wie, że przekazuje prawdę, abyście i wy uwierzyli. ");
INSERT INTO polsz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Stało się tak, aby spełniły się słowa Pisma: „Kości Jego nie zostaną połamane”. ");
INSERT INTO polsz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","A także: „Będą patrzeć na Tego, którego przebili”. ");
INSERT INTO polsz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Po tym wszystkim niejaki Józef z Arymatei poprosił Piłata o zgodę na zabranie ciała Jezusa. Józef był Jego uczniem, jednak ukrywał się przed przywódcami, ponieważ się ich bał. ");
INSERT INTO polsz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Przybył tam również Nikodem—ten, który kiedyś odwiedził Jezusa nocą i przyniósł z sobą około trzydziestu kilogramów mieszaniny mirry i aloesu. ");
INSERT INTO polsz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Zabrali więc ciało Jezusa i—zgodnie z żydowskim zwyczajem pogrzebowym—obwiązali je lnianymi płótnami oraz obsypali balsamem. ");
INSERT INTO polsz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Niedaleko miejsca ukrzyżowania, w ogrodzie, znajdował się nowy, nieużywany dotąd grobowiec. ");
INSERT INTO polsz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Złożyli w nim więc ciało Jezusa, bo spieszyli się, aby zdążyć przed nastaniem szabatu. ");
INSERT INTO polsz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","W niedzielę, wczesnym rankiem, gdy jeszcze było ciemno, przyszła do grobu Maria z Magdali. Zobaczyła, że głaz zamykający wejście jest odsunięty. ");
INSERT INTO polsz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pobiegła więc do Szymona Piotra i do ucznia, który był najbliższym przyjacielem Jezusa, ze słowami: —Ktoś zabrał z grobu Pana i nie wiem, gdzie Go położono! ");
INSERT INTO polsz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piotr wraz z tym uczniem szybko wybrali się do grobu. ");
INSERT INTO polsz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Biegli razem, ale tamten wyprzedził Piotra i pierwszy dobiegł na miejsce. ");
INSERT INTO polsz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Zajrzał i zobaczył leżące płótna, ale nie wszedł do środka. ");
INSERT INTO polsz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Po chwili nadbiegł Szymon Piotr. Wszedł do grobowca i zaczął oglądać płótna ");
INSERT INTO polsz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","oraz chustę okrywającą głowę Jezusa, która leżała zwinięta nie z płótnami, ale osobno. ");
INSERT INTO polsz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Potem również uczeń, który pierwszy dobiegł na miejsce, wszedł do środka. Zobaczył pusty grób i uwierzył. ");
INSERT INTO polsz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Do tej pory nie rozumieli bowiem słów Pisma, mówiących, że Jezus ma zmartwychwstać. ");
INSERT INTO polsz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Po tym wszystkim uczniowie wrócili do domu. ");
INSERT INTO polsz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria z Magdali stała natomiast przed wejściem do grobu i płakała. Po chwili, gdy zajrzała do środka, ");
INSERT INTO polsz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","zobaczyła dwóch aniołów w białych szatach. Jeden siedział w miejscu, w którym leżała głowa Jezusa, drugi—w miejscu, w którym były Jego stopy. ");
INSERT INTO polsz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","—Dlaczego płaczesz?—zapytali ją aniołowie. —Ktoś zabrał mojego Pana i nie wiem, gdzie Go położył—odpowiedziała. ");
INSERT INTO polsz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Następnie odwróciła się i zobaczyła stojącego Jezusa, ale Go nie poznała. ");
INSERT INTO polsz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","—Dlaczego płaczesz? Kogo szukasz?—zapytał Jezus. —Panie, jeśli to ty Go wyniosłeś, powiedz, gdzie Go położyłeś, a ja Go stamtąd wezmę—powiedziała Maria, myśląc, że to ogrodnik. ");
INSERT INTO polsz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","—Mario!—rzekł Jezus. —Rabbuni! (to znaczy: „Nauczycielu!”)—powiedziała Maria. ");
INSERT INTO polsz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","—Nie zatrzymuj Mnie—rzekł Jezus. —Jeszcze nie wstąpiłem do Ojca. Idź natomiast do moich braci i powiedz im: Idę do mojego Ojca i do waszego Ojca, do mojego Boga i do waszego Boga. ");
INSERT INTO polsz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Wtedy Maria udała się do uczniów i oznajmiła: —Widziałam Pana!—i powtórzyła im, co jej powiedział. ");
INSERT INTO polsz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jeszcze tego samego dnia, wieczorem, uczniowie zebrali się w jednym miejscu. Bali się przywódców, więc spotkali się za zamkniętymi drzwiami. Nagle do pomieszczenia, w którym byli, wszedł Jezus—stanął pośrodku nich i powiedział: —Pokój wam! ");
INSERT INTO polsz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","I pokazał im przebite ręce oraz bok. Na widok żywego Pana ogarnęła ich radość. ");
INSERT INTO polsz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","On zaś powtórzył: —Pokój wam! Jak Ojciec posłał Mnie, tak i Ja posyłam was. ");
INSERT INTO polsz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Po tych słowach tchnął na nich i rzekł: —Weźcie Ducha Świętego! ");
INSERT INTO polsz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ci, których uwolnicie od grzechów, będą od nich wolni, ci zaś, których nie uwolnicie, pozostaną w grzechach. ");
INSERT INTO polsz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nie było wtedy wśród nich jednego ucznia—Tomasza, zwanego Bliźniakiem. ");
INSERT INTO polsz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Pozostali powiedzieli mu więc: —Słuchaj! Widzieliśmy Pana! —Co takiego?!—zawołał Tomasz. —Jeżeli nie zobaczę na Jego rękach śladów po gwoździach i nie włożę w nie palca, nie uwierzę! Jeśli nie włożę ręki w Jego przebity bok—nie uwierzę! ");
INSERT INTO polsz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Minęło osiem dni i uczniowie znowu zebrali się w jednym miejscu. Tym razem Tomasz był z nimi. Podobnie jak poprzednio, Jezus wszedł pomimo zamkniętych drzwi, stanął pośrodku i powiedział: —Pokój wam! ");
INSERT INTO polsz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Następnie rzekł do Tomasza: —Włóż palec w moje ręce. Włóż rękę w mój bok. I nie bądź już niedowiarkiem, ale uwierz! ");
INSERT INTO polsz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","—Jesteś moim Panem i Bogiem!—zawołał Tomasz. ");
INSERT INTO polsz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","—Uwierzyłeś, bo Mnie zobaczyłeś?—odparł Jezus. —Szczęśliwi są jednak ci, którzy uwierzyli, chociaż Mnie nie widzieli! ");
INSERT INTO polsz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jezus uczynił na oczach uczniów o wiele więcej cudów niż to opisano w tej księdze. ");
INSERT INTO polsz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Te jednak, które się w niej znalazły, zostały zapisane po to, abyście uwierzyli, że Jezus jest Mesjaszem, Synem Boga, i abyście wierząc Mu otrzymali życie wieczne. ");
INSERT INTO polsz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Po jakimś czasie Jezus po raz kolejny ukazał się uczniom. Było to nad Jeziorem Tyberiadzkim. ");
INSERT INTO polsz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Przebywali wtedy razem: Szymon Piotr, Tomasz, zwany Bliźniakiem, Natanael z Kany Galilejskiej, synowie Zebedeusza—Jakub i Jan, oraz jeszcze dwóch innych uczniów. ");
INSERT INTO polsz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","—Idę łowić ryby—rzekł do nich Piotr. —Idziemy z tobą—odpowiedzieli. Weszli więc do łodzi i wypłynęli, ale przez całą noc nic nie złapali. ");
INSERT INTO polsz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","O świcie na brzegu pojawił się Jezus. Uczniowie jednak nie rozpoznali Go. ");
INSERT INTO polsz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Wtedy On zawołał do nich: —Kochani! Macie coś do jedzenia? —Nie, nic—odpowiedzieli. ");
INSERT INTO polsz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Zarzućcie więc sieci z prawej strony łodzi, a coś złapiecie! Zrobili to i wkrótce mieli tyle ryb, że nie mogli wyciągnąć sieci. ");
INSERT INTO polsz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","—To Pan!—powiedział do Piotra uczeń, który był najbliższym przyjacielem Jezusa. Na te słowa Szymon Piotr natychmiast założył koszulę, był bowiem rozebrany, i rzucił się wpław do brzegu. ");
INSERT INTO polsz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pozostali płynęli łodzią, ciągnąc za sobą sieci pełne ryb. Byli bowiem tylko jakieś sto metrów od brzegu. ");
INSERT INTO polsz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Gdy wyszli z łodzi, ujrzeli rozpalone ognisko, na którym piekła się ryba oraz chleb. ");
INSERT INTO polsz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","—Przynieście kilka ryb, które teraz złowiliście—poprosił Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Szymon Piotr poszedł więc i wyciągnął sieć na brzeg. Jak się okazało, w sieci były sto pięćdziesiąt trzy ogromne ryby, a mimo to sieć nie pękła. ");
INSERT INTO polsz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","—Podejdźcie i zjedzcie coś—zachęcił Jezus. Żaden z nich nie śmiał Go pytać, czy to rzeczywiście On. Byli bowiem pewni, że to jest Pan. ");
INSERT INTO polsz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jezus tymczasem podchodził do każdego, częstując chlebem i rybą. ");
INSERT INTO polsz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","W ten sposób, już po raz trzeci od czasu swojego zmartwychwstania, Jezus ukazał się uczniom. ");
INSERT INTO polsz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Po śniadaniu Jezus zwrócił się do Szymona Piotra: —Szymonie, synu Jana, czy kochasz Mnie bardziej niż inni? —Tak, Panie—odparł Piotr. —Wiesz, że Cię kocham. —Paś więc moje baranki—rzekł Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Zapytał go jednak drugi raz: —Szymonie, synu Jana, czy kochasz Mnie? —Tak, Panie. Wiesz, że Cię kocham. —Opiekuj się więc moimi owcami. ");
INSERT INTO polsz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","I zapytał go po raz trzeci: —Szymonie, synu Jana, czy kochasz Mnie? Słysząc trzeci raz to samo pytanie, Piotr zasmucił się, ale odpowiedział: —Panie! Ty wiesz wszystko. Wiesz, że Cię kocham! —Paś więc moje owce—powiedział Jezus. ");
INSERT INTO polsz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","—Zapewniam cię: Gdy byłeś młodszy, sam o sobie decydowałeś i chodziłeś, dokąd chciałeś. Ale na starość ktoś inny zadecyduje o tobie i poprowadzi cię tam, dokąd byś nie chciał pójść. ");
INSERT INTO polsz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Mówiąc to, Jezus dał mu do zrozumienia, jaką śmiercią uwielbi Boga. I dodał: —Pójdź w moje ślady! ");
INSERT INTO polsz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piotr odwrócił się i zobaczył ucznia, który był najbliższym przyjacielem Jezusa. To on, podczas kolacji, był blisko Niego i zapytał: „Panie, kto Cię zdradzi?”. ");
INSERT INTO polsz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Wtedy Piotr powiedział: —Panie! A co będzie z nim? ");
INSERT INTO polsz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","—Może zechcę, aby pozostał na ziemi aż do mojego powtórnego przyjścia? Po co ci to wiedzieć? Ty masz pójść w moje ślady. ");
INSERT INTO polsz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Z tego powodu rozeszła się wśród uczniów pogłoska, że uczeń ten nie umrze. Ale Jezus nie powiedział, że on nie umrze, tylko: „Może zechcę, aby pozostał aż do mojego powtórnego przyjścia? Po co ci to wiedzieć?”. ");
INSERT INTO polsz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ten właśnie uczeń opowiedział o tym wszystkim i to on napisał tę księgę. A wiemy, że mówi prawdę. ");
INSERT INTO polsz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jezus dokonał jeszcze wielu innych rzeczy. A gdyby chciano je wszystkie szczegółowo opisać, cały świat nie pomieściłby chyba ksiąg.");
INSERT INTO polsz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Dostojny Teofilu! W pierwszej księdze napisałem ci o tym, co Jezus czynił i czego nauczał ");
INSERT INTO polsz_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","aż do dnia, w którym mocą Ducha Świętego przekazał wybranym przez siebie apostołom ostatnie polecenia i został wzięty do nieba. ");
INSERT INTO polsz_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Im też dał wiele dowodów na to, że żyje, pomimo doznanych cierpień i śmierci. Przez czterdzieści dni ukazywał się im i rozmawiał z nimi o królestwie Bożym. ");
INSERT INTO polsz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Podczas jednego ze wspólnych posiłków polecił im, aby jeszcze nie opuszczali Jerozolimy, ale poczekali na spełnienie się obietnicy danej przez Ojca. ");
INSERT INTO polsz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","—Już o niej słyszeliście—wyjaśnił. —Mówiłem wam, że Jan Chrzciciel zanurzał w wodzie, lecz wy za kilka dni zostaniecie zanurzeni w Duchu Świętym. ");
INSERT INTO polsz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Innym razem, gdy spotkali się z Jezusem, zapytali Go: —Panie, czy teraz wyzwolisz Izrael i przywrócisz nasze królestwo? ");
INSERT INTO polsz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","—Nie musicie znać czasu i daty. Mój Ojciec ma władzę nad wszystkim i to On je ustalił—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","—Wy otrzymacie moc Ducha Świętego, gdy zstąpi na was, i będziecie opowiadać o mnie innym ludziom. Najpierw w Jerozolimie i całej Judei, później w Samarii, a potem wyruszycie aż po krańce ziemi. ");
INSERT INTO polsz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Po tych słowach wzniósł się na oczach uczniów i zniknął w obłoku. ");
INSERT INTO polsz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","A gdy wpatrywali się za Nim w niebo, nagle stanęli przy nich dwaj ubrani na biało mężczyźni, ");
INSERT INTO polsz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","którzy zapytali: —Galilejczycy! Po co tak stoicie i wpatrujecie się w niebo? Ten sam Jezus, zabrany od was do nieba, pewnego dnia powróci w taki sam sposób, w jaki widzieliście Go odchodzącego. ");
INSERT INTO polsz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Działo się to na Górze Oliwnej, oddalonej od Jerozolimy o kilometr. Apostołowie wrócili do miasta ");
INSERT INTO polsz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","i zebrali się w swoim pokoju na piętrze. Byli tam: Piotr, Jan, Jakub, Andrzej, Filip, Tomasz, Bartłomiej, Mateusz, Jakub—syn Alfeusza, Szymon Gorliwy i Juda—syn Jakuba. ");
INSERT INTO polsz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wszyscy oni, razem z kobietami oraz Marią—matką Jezusa, i Jego braćmi, nieustannie spędzali czas na wspólnej modlitwie. ");
INSERT INTO polsz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Gdy pewnego razu zebrało się około stu dwudziestu wierzących, Piotr wstał i rzekł: ");
INSERT INTO polsz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Przyjaciele! Musiało się wypełnić proroctwo Pisma, które Duch Święty, poprzez króla Dawida, wypowiedział o Judaszu. To on doprowadził do aresztowania Jezusa, ");
INSERT INTO polsz_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","bo był jednym z nas, apostołów, i miał udział w tej służbie. ");
INSERT INTO polsz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","On to, za pieniądze splamione krwią, kupił pole. A potem zabił się, spadając głową w dół. Spotkał go straszny koniec: pękł na pół a jego wnętrzności wypłynęły na zewnątrz. ");
INSERT INTO polsz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Wieść o tym dotarła do wszystkich mieszkańców Jerozolimy i nazwano to miejsce po hebrajsku Hakeldamach (to znaczy: „Pole Krwi”). ");
INSERT INTO polsz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Księga Psalmów mówi: „Niech opustoszeje jego dom i niech nikt w nim nie mieszka.” Oraz „Jego służbę niech przejmie ktoś inny”. ");
INSERT INTO polsz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Teraz, jako świadek zmartwychwstania Jezusa, musi dołączyć do nas ktoś, kto tak jak my był z Panem od samego początku ");
INSERT INTO polsz_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","—od dnia, w którym Jan Chrzciciel zanurzył Go w wodzie aż do chwili, w której został wzięty do nieba. ");
INSERT INTO polsz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Wybrali dwóch kandydatów: Józefa (zwanego Barsabą, noszącego też pseudonim „Justus”) i Macieja, ");
INSERT INTO polsz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","po czym zaczęli się modlić: —Panie, Ty znasz każde serce. Wskaż nam, którego z nich wybrałeś ");
INSERT INTO polsz_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","do tej apostolskiej służby, którą Judasz porzucił, poszedłszy własną drogą. ");
INSERT INTO polsz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Następnie podali im losy. Oznaczony los został wyciągnięty przez Macieja. Za aprobatą wszystkich dołączył więc do grona jedenastu apostołów. ");
INSERT INTO polsz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kilka dni później nadeszło święto Pięćdziesiątnicy. Wszyscy wierzący znowu byli razem w tym samym miejscu. ");
INSERT INTO polsz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nagle dał się słyszeć z nieba szum jakby potężnego huraganu, który wypełnił cały dom. ");
INSERT INTO polsz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ukazały się im także jakby języki ognia, które się rozdzieliły i osiadły na każdym z nich. ");
INSERT INTO polsz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wszyscy zostali wtedy napełnieni Duchem Świętym i zaczęli mówić obcymi im językami, zgodnie z wolą Ducha. ");
INSERT INTO polsz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","W tym czasie przebywali w Jerozolimie pobożni Żydzi, pochodzący z wielu różnych krajów świata. ");
INSERT INTO polsz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Gdy usłyszeli hałas, tłumnie zbiegli się i stanęli oszołomieni. Każdy z nich słyszał bowiem, jak uczniowie mówią w ich własnym języku. ");
INSERT INTO polsz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","—Jak to możliwe?—dziwili się. —Przecież wszyscy ci ludzie pochodzą z Galilei? ");
INSERT INTO polsz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Dlaczego więc słyszymy swój własny język, język kraju, w którym się urodziliśmy? ");
INSERT INTO polsz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Partowie, Medowie i Elamici, mieszkańcy Mezopotamii, Judei, Kapadocji, Pontu, Azji, ");
INSERT INTO polsz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frygii, Pamfilii, Egiptu, mieszkańcy Libii z okolic Cyreny, przybysze z Rzymu (zarówno Żydzi, jak i poganie nawróceni na judaizm), ");
INSERT INTO polsz_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kreteńczycy i Arabowie—wszyscy słyszymy, jak mówią w naszych ojczystych językach o wielkich dziełach Boga! ");
INSERT INTO polsz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Oszołomieni i zdezorientowani pytali siebie nawzajem: —Co to może znaczyć? ");
INSERT INTO polsz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","—Upili się niedojrzałym winem—drwili jednak niektórzy. ");
INSERT INTO polsz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Wtedy wystąpił Piotr z pozostałymi jedenastoma apostołami i zawołał do zebranych: —Posłuchajcie mnie uważnie mieszkańcy Jerozolimy i wszyscy przybysze! ");
INSERT INTO polsz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ci ludzie nie są pijani, jak niektórzy podejrzewają. Jest przecież dopiero dziewiąta rano! ");
INSERT INTO polsz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","To, co widzicie, zostało przed wiekami zapowiedziane przez proroka Joela: ");
INSERT INTO polsz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","„W ostatnich dniach—mówi Bóg —ześlę mojego Ducha na wielu ludzi: wasi synowie i córki będą prorokować, młodzieńcy będą mieć widzenia, a starcy—sny. ");
INSERT INTO polsz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ześlę mojego Ducha na wszystkie moje sługi, na mężczyzn i kobiety, i będą prorokować. ");
INSERT INTO polsz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","I sprawię, że zobaczycie cudowne znaki, zarówno na niebie, jak i na ziemi. Zobaczycie krew, ogień i kłęby dymu. ");
INSERT INTO polsz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Na niebie zaś zgaśnie słońce, a księżyc stanie się krwawoczerwony. Wszystko to poprzedzi nadejście wielkiego i wspaniałego Dnia Pana. ");
INSERT INTO polsz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Lecz każdy, kto wezwie imienia Pana, będzie zbawiony”. ");
INSERT INTO polsz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Posłuchajcie mnie, Izraelici!—kontynuował Piotr. —Bóg w oczywisty sposób udzielił poparcia Jezusowi z Nazaretu, przez którego uczynił wśród was wielkie cuda i znaki, o czym doskonale wiecie. ");
INSERT INTO polsz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Zgodnie ze swoim odwiecznym zamiarem i postanowieniem pozwolił, aby Jezus został wam wydany przez bezbożnych Rzymian. A wy przybiliście Go do krzyża i zamordowaliście! ");
INSERT INTO polsz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bóg jednak wyrwał Go z rąk śmierci i ożywił, gdyż śmierć nie mogła Go pokonać. ");
INSERT INTO polsz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Już król Dawid zapowiedział to, mówiąc: „Zawsze widziałem obok siebie Pana. Jest blisko mnie, abym się nie zachwiał. ");
INSERT INTO polsz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Dlatego z całego serca ucieszyłem się, i moje usta napełniły się radością. Moje ciało będzie bowiem spoczywać z nadzieją! ");
INSERT INTO polsz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bo nie pozostawisz mojej duszy wśród umarłych i nie pozwolisz, aby ciało Twojego Świętego uległo rozkładowi. ");
INSERT INTO polsz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pokazałeś mi ścieżkę życia, a Twoja obecność napełnia mnie radością”. ");
INSERT INTO polsz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Przyjaciele!—mówił Piotr. —Mogę to wam otwarcie przypomnieć, że król Dawid umarł, miał pogrzeb, a jego grób po dziś dzień się tu znajduje. ");
INSERT INTO polsz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Był jednak prorokiem i pamiętał, że Bóg złożył mu przysięgę, obiecując królewski tron jego potomkowi. ");
INSERT INTO polsz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Gdy więc zobaczył przyszłe zmartwychwstanie Mesjasza, przepowiedział, że nie pozostanie On w grobie, a Jego ciało nie ulegnie rozkładowi. ");
INSERT INTO polsz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","My wszyscy jesteśmy świadkami tego, że to właśnie Jezusa Bóg wskrzesił z martwych. ");
INSERT INTO polsz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Wyróżniony przez Boga najwyższą w niebie godnością, wypełnił obietnicę Ojca i posłał Ducha Świętego. To Jego cudowne działanie teraz widzicie i słyszycie. ");
INSERT INTO polsz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","I chociaż Dawid nie był w niebie, to jednak powiedział: „Bóg rzekł do mojego Pana: Zasiądź po mojej prawej stronie, ");
INSERT INTO polsz_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","dopóki nie rzucę Ci pod nogi Twoich nieprzyjaciół”. ");
INSERT INTO polsz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Niech więc to będzie jasne dla całego Izraela—dodał Piotr—że Jezusa, którego wy ukrzyżowaliście, Bóg uczynił Panem i Mesjaszem! ");
INSERT INTO polsz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Słowa te tak wstrząsnęły słuchaczami, że zapytali Piotra i pozostałych apostołów: —Przyjaciele! Co w takim razie mamy zrobić? ");
INSERT INTO polsz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","—Opamiętać się—odrzekł Piotr—i dać się zanurzyć w wodzie w imię Jezusa Chrystusa, na znak uwolnienia od grzechów. Wtedy otrzymacie dar Ducha Świętego, ");
INSERT INTO polsz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","bo został On obiecany właśnie wam i waszym dzieciom, a nawet poganom—wszystkim, których wezwie Pan, nasz Bóg! ");
INSERT INTO polsz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","I długo jeszcze Piotr mówił do nich, wzywając: —Ratujcie się przez Bożym sądem, który spadnie na to złe pokolenie. ");
INSERT INTO polsz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ci, którzy dzięki słowom Piotra uwierzyli w Jezusa, zostali ochrzczeni. I tego dnia przyłączyło się do grupy wierzących około trzech tysięcy osób. ");
INSERT INTO polsz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Z oddaniem trzymali się oni nauki apostołów, żyli we wspólnocie, dzielili się chlebem i razem modlili się. ");
INSERT INTO polsz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mieszkańcy miasta odczuwali lęk, ponieważ apostołowie czynili wiele cudów. ");
INSERT INTO polsz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Natomiast wszyscy wierzący przebywali razem i dzielili się tym, co mieli. ");
INSERT INTO polsz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Często sprzedawali swoje posiadłości i wspomagali innych wierzących, w zależności od potrzeb. ");
INSERT INTO polsz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Byli jednomyślni i codziennie zbierali się w świątyni. W domach zaś dzielili się chlebem i z radością oraz otwartością spożywali wspólnie posiłki. ");
INSERT INTO polsz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","W tym wszystkim oddawali chwałę Bogu i cieszyli się dobrą opinią ze strony innych mieszkańców. Pan zaś sprawiał, że codziennie nowi ludzie przyjmowali zbawienie i przyłączali się do wspólnoty. ");
INSERT INTO polsz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pewnego dnia Piotr i Jan szli do świątyni na popołudniową modlitwę o godzinie trzeciej. ");
INSERT INTO polsz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Właśnie wtedy niesiono pewnego człowieka, który od urodzenia nie mógł chodzić. Codziennie kładziono go pod bramą świątyni, zwaną Piękną, aby mógł prosić wchodzących o wsparcie. ");
INSERT INTO polsz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Widząc, że Piotr i Jan mają zamiar wejść, poprosił ich o datek. ");
INSERT INTO polsz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Wtedy uważnie spojrzeli na niego, a Piotr rzekł: —Popatrz na nas. ");
INSERT INTO polsz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kaleka spojrzał na nich z nadzieją, że zaraz coś od nich dostanie. ");
INSERT INTO polsz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ale Piotr powiedział: —Nie mam złota ani srebra. Ale dam ci to, co mam. W imieniu Jezusa Chrystusa z Nazaretu mówię ci: Wstań i chodź! ");
INSERT INTO polsz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Następnie podał mu prawą rękę i pomógł mu wstać. Chory natychmiast odzyskał władzę w stopach i kostkach. ");
INSERT INTO polsz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Z radości podskoczył i zaczął chodzić! Następnie wszedł razem z nimi do świątyni, podskakując i wielbiąc Boga. ");
INSERT INTO polsz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wszyscy obecni zobaczyli, że chodzi i chwali Boga. ");
INSERT INTO polsz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","I rozpoznali w nim tego, który siedział przy Pięknej Bramie i żebrał. Wtedy ogarnęło ich zdumienie z powodu tego, co zobaczyli. ");
INSERT INTO polsz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ponieważ uzdrowiony trzymał się blisko Piotra i Jana, wszyscy ruszyli za nimi do krużganka Salomona. ");
INSERT INTO polsz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Widząc to, Piotr zwrócił się do tłumu: —Izraelici! Dlaczego tak się dziwicie? I dlaczego wpatrujecie się w nas tak, jakbyśmy własną mocą lub pobożnością sprawili, że ten człowiek chodzi? ");
INSERT INTO polsz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Bóg Abrahama, Izaaka i Jakuba—Bóg naszych przodków—otoczył chwałą swojego sługę, Jezusa. Wy Go wydaliście Piłatowi i odrzuciliście, chociaż on chciał Go uwolnić. ");
INSERT INTO polsz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Wzgardziliście Świętym i Prawym, a zażądaliście uwolnienia mordercy. ");
INSERT INTO polsz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Zabiliście Dawcę życia! Bóg jednak wzbudził Go z martwych, czego my jesteśmy naocznymi świadkami! ");
INSERT INTO polsz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Właśnie przez wiarę w tego Jezusa człowiek, którego tu widzicie i którego dobrze znacie, został uzdrowiony. Dzięki Jezusowi, na oczach was wszystkich, odzyskał pełną władzę w nogach! ");
INSERT INTO polsz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Przyjaciele! Teraz jednak wiem, że działaliście w nieświadomości, tak jak i wasi przywódcy. ");
INSERT INTO polsz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Bóg jednak wypełnił to, co wszyscy prorocy kiedyś zapowiedzieli o cierpieniu Mesjasza. ");
INSERT INTO polsz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Opamiętajcie się więc i zwróćcie się do Boga, aby oczyścił was z grzechów. ");
INSERT INTO polsz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Może pocieszy was wtedy i pośle do was Jezusa, Mesjasza. ");
INSERT INTO polsz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Teraz jednak musi On pozostać w niebie aż do czasu ostatecznego odnowienia wszystkich rzeczy. Bóg dawno temu zapowiedział to poprzez swoich świętych proroków. ");
INSERT INTO polsz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Już Mojżesz powiedział bowiem: „Bóg, wasz Pan, powoła spośród was proroka podobnego do mnie. Słuchajcie uważnie wszystkiego, co wam powie. ");
INSERT INTO polsz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Każdy bowiem, kto nie będzie Mu posłuszny, zostanie wyłączony z ludu i ulegnie zagładzie”. ");
INSERT INTO polsz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Począwszy od Samuela, wszyscy kolejni prorocy zapowiadali wydarzenia minionych dni—kontynuował Piotr. ");
INSERT INTO polsz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","—Wy zaś jesteście potomkami tych proroków i uczestnikami przymierza, które Bóg zawarł z waszymi przodkami. On powiedział Abrahamowi: „Przez twojego potomka będą błogosławieni wszyscy ludzie na ziemi”. ");
INSERT INTO polsz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","To dla was, jako pierwszych—wyjaśniał Piotr—Bóg wskrzesił swojego Sługę, Jezusa, i posłał Go, aby każdemu z was błogosławił, pomagając zerwać z grzesznym życiem. ");
INSERT INTO polsz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Gdy Piotr i Jan przemawiali do zgromadzonych, podeszli do nich kapłani, wraz z dowódcą straży świątynnej i kilkoma saduceuszami. ");
INSERT INTO polsz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Oburzyli się słysząc, że nauczają zebranych i głoszą im zmartwychwstanie w Jezusie. ");
INSERT INTO polsz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Aresztowali ich więc, a ponieważ był już wieczór, zamknęli w więzieniu do następnego dnia. ");
INSERT INTO polsz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mimo to, wielu ludzi, którzy słuchali ich słów, uwierzyło w Jezusa, zwiększając liczbę samych tylko wierzących mężczyzn do około pięciu tysięcy. ");
INSERT INTO polsz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Następnego dnia zebrali się w Jerozolimie przełożeni, starsi i przywódcy religijni, ");
INSERT INTO polsz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","a wśród nich: Annasz—najwyższy kapłan, Kajfasz, Jan, Aleksander i wszyscy inni, spokrewnieni z najwyższym kapłanem. ");
INSERT INTO polsz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Postawili apostołów na środku i przesłuchiwali: —Jakim prawem i z czyjego polecenia to robiliście? ");
INSERT INTO polsz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","—Dostojni przywódcy naszego narodu!—odpowiedział Piotr, napełniony Duchem Świętym. ");
INSERT INTO polsz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","—Skoro przesłuchujecie nas dzisiaj z powodu dobrego czynu, dzięki któremu ten chory człowiek odzyskał zdrowie, ");
INSERT INTO polsz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","to wiedzcie—wy wszyscy i cały naród Izraela—że stoi on przed wami zdrowy dzięki mocy Jezusa Chrystusa z Nazaretu. Wy Go ukrzyżowaliście, ale Bóg wskrzesił Go z martwych. ");
INSERT INTO polsz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","To On jest tym, zapowiedzianym w Piśmie: „Kamieniem, odrzuconym przez budujących, który stał się kamieniem węgielnym, najważniejszym w całym budynku!”. ");
INSERT INTO polsz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","W nikim innym nie ma zbawienia!—dodał Piotr. —Bo nie dano ludziom na ziemi żadnego innego imienia, przez które moglibyśmy uzyskać zbawienie. ");
INSERT INTO polsz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Przywódcy zdumieli się na widok odwagi Piotra i Jana. Przypomnieli sobie, że są to ludzie prości oraz niewykształceni i rozpoznali, że to oni przebywali z Jezusem. ");
INSERT INTO polsz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Jednak widok stojącego z nimi uzdrowionego człowieka zamknął im usta. ");
INSERT INTO polsz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Polecili więc im opuścić salę obrad i naradzali się między sobą: ");
INSERT INTO polsz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—Co z nimi zrobić? Nie możemy zaprzeczyć, że dokonali cudu. Wiedzą o tym już wszyscy mieszkańcy Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Żeby jednak nie rozchodziło się to dalej, zabrońmy im rozmawiania z kimkolwiek o Jezusie. ");
INSERT INTO polsz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wezwali ich więc ponownie i zakazali im mówić i nauczać o Jezusie. ");
INSERT INTO polsz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","—Sami oceńcie, co jest słuszne w oczach Boga! Powinniśmy słuchać was czy też Jego?—odrzekli Piotr i Jan. ");
INSERT INTO polsz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","—My nie możemy przestać mówić o tym, co sami widzieliśmy i słyszeliśmy od Jezusa. ");
INSERT INTO polsz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ponawiając groźbę, przywódcy wypuścili ich. Nie potrafili bowiem znaleźć takiego powodu do ich ukarania, który by nie oburzył ludzi. Wszyscy bowiem oddawali Bogu chwałę za to, co uczynił. ");
INSERT INTO polsz_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Bo przecież tylko On mógł cudownie uzdrowić człowieka, który od ponad czterdziestu lat był kaleką. ");
INSERT INTO polsz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Zaraz po uwolnieniu, Piotr i Jan poszli do innych wierzących i opowiedzieli im, co mówili najwyżsi kapłani i starsi. ");
INSERT INTO polsz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Słysząc to, wszyscy jednomyślnie zawołali do Boga: —Panie, Stwórco nieba, ziemi, morza i wszystkiego, co istnieje! ");
INSERT INTO polsz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ty przez Ducha Świętego, ustami naszego przodka, króla Dawida, który był Twoim sługą, powiedziałeś: „Dlaczego wzburzyły się narody, i ludy zaczęły planować zło? ");
INSERT INTO polsz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ziemscy władcy zjednoczyli się do walki, a przywódcy zebrali się razem, aby wystąpić przeciw Panu i Jego Mesjaszowi”. ");
INSERT INTO polsz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tak właśnie stało się w tym mieście!—modlili się. —Oto król Herod i gubernator Poncjusz Piłat, wraz z Rzymianami i żydowskimi przywódcami, zjednoczyli się przeciwko Twojemu świętemu Słudze—Jezusowi, którego ustanowiłeś Mesjaszem. ");
INSERT INTO polsz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","I wypełnili wszystko to, co w swojej mocy i woli zaplanowałeś. ");
INSERT INTO polsz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Zobacz więc, Panie, jak grożą Twoim sługom, i pozwól nam z odwagą głosić Twoje słowo, ");
INSERT INTO polsz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","gdy Ty będziesz uzdrawiał swoją mocą i w imieniu swojego świętego Sługi, Jezusa, dokonywał cudów. ");
INSERT INTO polsz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Gdy skończyli modlitwę, budynek, w którym się zebrali, zadrżał. A wszyscy zostali napełnieni Duchem Świętym i odważnie głosili słowo Boże. ");
INSERT INTO polsz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Wszystkich wierzących łączyło jedno serce i jedna myśl. Nikt nie uważał tego, co posiadał, za swoją wyłączną własność, ale każdy dzielił się wszystkim z innymi. ");
INSERT INTO polsz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apostołowie z ogromną mocą opowiadali innym o zmartwychwstaniu Jezusa, a wszyscy wierzący doświadczali ogromnej łaski. ");
INSERT INTO polsz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nie było wśród nich nikogo, kto by cierpiał biedę, bo wielu posiadających ziemię lub domy sprzedawało je, ");
INSERT INTO polsz_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","a pieniądze powierzało apostołom. I każdy otrzymywał tyle, ile potrzebował. ");
INSERT INTO polsz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tak uczynił Józef, Lewita pochodzący z Cypru, nazywany przez apostołów Barnabą (to znaczy: „tym, który jest zachętą dla innych”). ");
INSERT INTO polsz_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Sprzedał on swoje pole i pieniądze oddał apostołom. ");
INSERT INTO polsz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Również inny człowiek, niejaki Ananiasz, wraz z żoną Safirą, sprzedał swoją posiadłość. ");
INSERT INTO polsz_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Za jej zgodą wziął jednak część pieniędzy dla siebie, a resztę zaniósł apostołom, mówiąc, że to cała kwota. ");
INSERT INTO polsz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Piotr powiedział mu na to: —Ananiaszu! Dlaczego pozwoliłeś, aby szatan opanował twoje serce? Okłamałeś Ducha Świętego, bo zatrzymałeś dla siebie część pieniędzy. ");
INSERT INTO polsz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Czy posiadłość nie należała do ciebie? I czy pieniądze po sprzedaży nie były nadal twoje? Dlaczego więc w swoim sercu postanowiłeś to zrobić? To nie nas okłamałeś, ale Boga. ");
INSERT INTO polsz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Gdy tylko Ananiasz usłyszał te słowa, padł martwy na ziemię. Wszystkich obecnych ogarnęło zaś przerażenie. ");
INSERT INTO polsz_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Młodsi mężczyźni zawinęli ciało Ananiasza, wynieśli je i pogrzebali. ");
INSERT INTO polsz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Jakieś trzy godziny później przyszła jego żona, nie wiedząc o tym, co się wydarzyło. ");
INSERT INTO polsz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","—Powiedz mi, czy za taką sumę sprzedaliście posiadłość?—spytał ją Piotr. —Tak!—odpowiedziała. —Za taką. ");
INSERT INTO polsz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","—Dlaczego zmówiliście się—odrzekł Piotr—żeby wystawić na próbę Ducha Pana? Właśnie przed wejściem słychać kroki tych, którzy pochowali twojego męża. Zaraz wyniosą również ciebie. ");
INSERT INTO polsz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Safira natychmiast padła martwa u stóp Piotra. Wtedy weszli młodzieńcy i widząc, że umarła, wynieśli ją i pochowali obok męża. ");
INSERT INTO polsz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Wówczas przerażenie ogarnęło cały kościół i wszystkich, którzy usłyszeli, co się stało. ");
INSERT INTO polsz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apostołowie, na oczach ludzi, dokonywali wielu niezwykłych cudów. A razem z innymi wierzącymi spotykali się na terenie świątyni, w krużganku Salomona. ");
INSERT INTO polsz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ludzie spoza kościoła nie mieli odwagi się do nich przyłączyć, ale darzyli ich wielkim szacunkiem. ");
INSERT INTO polsz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Liczba uczniów wciąż jednak wzrastała, ponieważ wiele nowych mężczyzn i kobiet wyznawało wiarę w Pana. ");
INSERT INTO polsz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na ulice wynoszono chorych. Kładziono ich tam na łóżkach i matach, aby choć cień przechodzącego Piotra mógł paść na któregoś z nich i uleczyć go. ");
INSERT INTO polsz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Również z miast położonych wokół Jerozolimy przychodziło mnóstwo ludzi, którzy przyprowadzali chorych i zniewolonych przez demony. I wszyscy doznawali uzdrowienia. ");
INSERT INTO polsz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tymczasem najwyższy kapłan i ludzie z jego otoczenia, którzy należeli do ugrupowania saduceuszy, byli pełni nienawiści do apostołów. ");
INSERT INTO polsz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Dlatego ponownie zatrzymali ich i wtrącili do więzienia. ");
INSERT INTO polsz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Lecz nocą zjawił się anioł Pana. Otworzył bramy więzienia, wyprowadził apostołów i powiedział: ");
INSERT INTO polsz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Idźcie do świątyni i przekazujcie ludziom wszystkie te słowa, które prowadzą do życia! ");
INSERT INTO polsz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Okazując posłuszeństwo temu nakazowi, o świcie weszli do świątyni i nauczali. Tymczasem rano najwyższy kapłan, wraz z ludźmi ze swojego otoczenia, zwołał posiedzenie Wysokiej Rady i starszych Izraela. Posłano też straż świątynną do więzienia, aby przyprowadziła apostołów na przesłuchanie. ");
INSERT INTO polsz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Gdy jednak członkowie straży dotarli na miejsce, nie znaleźli aresztowanych. Wrócili więc i zameldowali: ");
INSERT INTO polsz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Brama więzienia była zamknięta i strzeżona przez wartowników. Ale gdy ją otworzyliśmy, nikogo w środku nie było. ");
INSERT INTO polsz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dowódca straży i najwyżsi kapłani, słysząc to, zastanawiali się, co mogło się z nimi stać. ");
INSERT INTO polsz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Wtedy nadszedł ktoś z wiadomością: —Ci, których uwięziliście, są teraz w świątyni i nauczają ludzi. ");
INSERT INTO polsz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dowódca natychmiast poszedł tam ze strażnikami, aby ich przyprowadzić. Zrobili to jednak bez użycia siły, ponieważ bali się, że tłum obrzuci ich kamieniami. ");
INSERT INTO polsz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Gdy apostołowie stanęli przed Radą, najwyższy kapłan zaczął ich przesłuchiwać: ");
INSERT INTO polsz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Czy nie zakazaliśmy wam nauczać o tym człowieku? Tymczasem wy zaraziliście swoją nauką całą Jerozolimę i chcecie obarczyć nas winą za jego śmierć! ");
INSERT INTO polsz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","—Trzeba być bardziej posłusznym Bogu niż ludziom—odparli Piotr i apostołowie. ");
INSERT INTO polsz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","—Bóg naszych przodków wskrzesił z martwych Jezusa, którego wy zabiliście, wieszając na drewnianym krzyżu. ");
INSERT INTO polsz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Co więcej, swoją potężną mocą wywyższył Go i ustanowił Władcą i Zbawicielem, aby Izrael mógł się opamiętać i otrzymać przebaczenie grzechów. ");
INSERT INTO polsz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Świadkami tego jesteśmy my oraz Duch Święty, dany przez Boga tym, którzy są Mu posłuszni. ");
INSERT INTO polsz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Słysząc to, Rada wpadła we wściekłość i postanowiła ich zabić. ");
INSERT INTO polsz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lecz wtedy wstał niejaki Gamaliel, jeden z jej członków, będący faryzeuszem i bardzo poważanym przywódcą religijnym. Polecił wyprowadzić na chwilę apostołów, ");
INSERT INTO polsz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","po czym przemówił: —Izraelici! Dobrze się zastanówcie, co zrobić z tymi ludźmi. ");
INSERT INTO polsz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Jakiś czas temu bowiem wystąpił przeciw Rzymianom niejaki Teudas, który uważał się za kogoś niezwykłego. Zgromadził wokół siebie około czterystu uczniów, ale gdy go stracono, wszyscy jego zwolennicy rozproszyli się i nic z tego nie wynikło. ");
INSERT INTO polsz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Później, w czasie spisu ludności, zbuntował się Judasz Galilejczyk i pociągnął za sobą innych ludzi. On również zginął, a wszyscy jego zwolennicy pouciekali. ");
INSERT INTO polsz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Dlatego dobrze wam radzę: uwolnijcie tych ludzi i zostawcie ich w spokoju. Jeśli ich nauka i czyny mają tylko ludzkie źródło, to wkrótce utracą znaczenie. ");
INSERT INTO polsz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ale jeśli to pochodzi od Boga, nie będziecie w stanie ich zwalczyć i może się okazać, że walczycie przeciwko Bogu. Słowa Gamaliela przekonały Radę. ");
INSERT INTO polsz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wezwali więc ponownie apostołów i kazali ich ubiczować. Zabronili im też przemawiać w imieniu Jezusa i wypuścili ich. ");
INSERT INTO polsz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Oni zaś wyszli z sali obrad ciesząc się, że Bóg uznał ich za godnych znoszenia cierpień z powodu Jezusa. ");
INSERT INTO polsz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","I codziennie w świątyni i w domach nie przestawali nauczać i głosić, że Jezus jest Mesjaszem. ");
INSERT INTO polsz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Wraz z szybkim wzrostem liczby uczniów podnosiły się głosy niezadowolenia. Ci, którzy mówili po grecku, narzekali, że wierzący, którzy mówili po hebrajsku, pomijają ich wdowy przy codziennym podziale żywności dla potrzebujących. ");
INSERT INTO polsz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Wtedy Dwunastu zwołało wszystkich uczniów i rzekło: —Nie byłoby to właściwe, gdybyśmy zaniedbali głoszenie słowa Bożego, a zajęli się rozdzielaniem żywności. ");
INSERT INTO polsz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Rozejrzyjcie się więc, drodzy przyjaciele, i wybierzcie spośród siebie siedmiu zaufanych, mądrych i napełnionych Duchem Świętym mężczyzn. Im zlecimy to zajęcie. ");
INSERT INTO polsz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","My zaś całkowicie poświęcimy się modlitwie i głoszeniu słowa Bożego. ");
INSERT INTO polsz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Wszystkim spodobała się ta propozycja. Wybrali więc Szczepana—człowieka o wyjątkowej wierze i pełnego Ducha Świętego, Filipa, Prochora, Nikanora, Tymona, Parmenasa i Mikołaja z Antiochii, który wcześniej był poganinem nawróconym na judaizm. ");
INSERT INTO polsz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Przedstawiono ich apostołom, ci zaś modlili się za nich i posłali ich do tej służby, kładąc na nich ręce. ");
INSERT INTO polsz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tymczasem wpływ słowa Bożego był coraz większy i liczba uczniów w Jerozolimie szybko wzrastała i nawet wielu kapłanów przyjmowało wiarę w Jezusa. ");
INSERT INTO polsz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Szczepan, jeden z Siedmiu, człowiek obdarzony przez Boga szczególną łaską i mocą, dokonywał na oczach ludzi wielkich cudów. ");
INSERT INTO polsz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ale niektórzy członkowie Synagogi Wyzwolonych—byłych niewolników, pochodzących z Cyreny, Aleksandrii, Cylicji oraz Azji—chcieli go skompromitować w dyskusji. ");
INSERT INTO polsz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nie byli jednak w stanie dorównać jego mądrości i Duchowi, pod wpływem którego Szczepan przemawiał. ");
INSERT INTO polsz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Podstawili więc fałszywych świadków, którzy zeznali: —Słyszeliśmy, jak ten człowiek przeklinał Mojżesza i Boga. ");
INSERT INTO polsz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","W ten sposób zbuntowali przeciwko Szczepanowi cały tłum ludzi oraz starszych i przywódców religijnych. Następnie aresztowali go i postawili przed Wysoką Radą. ");
INSERT INTO polsz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Wtedy świadkowie ponownie fałszywie zeznali: —Ten człowiek nie przestaje wypowiadać się przeciwko świątyni i Prawu Mojżesza. ");
INSERT INTO polsz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Słyszeliśmy nawet, jak mówił, że Jezus z Nazaretu zburzy świątynię i zmieni zwyczaje, przekazane nam przez Mojżesza. ");
INSERT INTO polsz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","W tym momencie wszyscy zgromadzeni skierowali wzrok na Szczepana, jego twarz była bowiem podobna do twarzy anioła. ");
INSERT INTO polsz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","—Czy te oskarżenia są prawdziwe?—zapytał Szczepana najwyższy kapłan. ");
INSERT INTO polsz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","—Wysłuchajcie mnie, drodzy przyjaciele i starsi—odpowiedział Szczepan. —Bóg, któremu należy się chwała, ukazał się naszemu przodkowi Abrahamowi w Mezopotamii, zanim jeszcze ten przeniósł się do Charanu. ");
INSERT INTO polsz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Powiedział mu wtedy: „Opuść swój kraj i krewnych i idź do miejsca, które ci wskażę”. ");
INSERT INTO polsz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Pozostawił więc Abraham kraj Chaldejczyków i zamieszkał w Charanie. Po śmierci jego ojca, Bóg przyprowadził go tutaj, do kraju, w którym teraz mieszkacie, ");
INSERT INTO polsz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ale nie dał mu w posiadanie nawet skrawka tej ziemi. Obiecał jednak dać cały ten kraj jemu i jego potomstwu, mimo że Abraham nie miał wtedy jeszcze dzieci! ");
INSERT INTO polsz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Bóg powiedział również, że jego potomkowie przeniosą się do innego kraju, tam staną się niewolnikami i przez czterysta lat będą żyć w cierpieniu. ");
INSERT INTO polsz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","„Lecz Ja ukarzę naród, który ich zniewoli”—powiedział Bóg. „I ostatecznie mój lud go opuści, i będzie Mi służyć na tej ziemi”. ");
INSERT INTO polsz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Wtedy też Bóg zawarł z Abrahamem przymierze, którego znakiem było obrzezanie. Gdy więc urodził mu się syn Izaak, Abraham obrzezał go ósmego dnia po urodzeniu. Tak samo postąpił Izaak z synem Jakubem, a Jakub—z dwunastoma synami, przodkami narodu Izraela. ");
INSERT INTO polsz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Oni to z zazdrości sprzedali Józefa w niewolę do Egiptu. Lecz Bóg czuwał nad nim. ");
INSERT INTO polsz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Wybawił go ze wszystkich nieszczęść, dał mu mądrość i obdarzył przychylnością faraona, władcy Egiptu. W końcu sprawił, że Józef otrzymał władzę nad całym krajem i nad dworem faraona. ");
INSERT INTO polsz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Po pewnym czasie w Egipcie i w Kanaanie zapanował straszny głód. Nasi przodkowie nie mieli co jeść. ");
INSERT INTO polsz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Gdy więc Jakub dowiedział się, że w Egipcie są jeszcze zapasy zboża, posłał tam swoich synów, aby kupili je. ");
INSERT INTO polsz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Gdy po raz kolejny pojechali do Egiptu, Józef dał się rozpoznać braciom i przedstawił ich faraonowi. ");
INSERT INTO polsz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Następnie posłał po swojego ojca, Jakuba, i resztę rodziny. W sumie sprowadził do Egiptu siedemdziesiąt pięć osób. ");
INSERT INTO polsz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jakub przybył więc do Egiptu i już tam zmarł. Pomarli też jego synowie. ");
INSERT INTO polsz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ich ciała przeniesiono do Sychem i pochowano w grobowcu, który Abraham kupił od synów Chamora. ");
INSERT INTO polsz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Gdy zbliżał się czas wypełnienia Bożej obietnicy, danej Abrahamowi, liczba Izraelitów w Egipcie szybko wzrosła. ");
INSERT INTO polsz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Wtedy właśnie rozpoczął rządy nowy władca, który nie znał Józefa i jego zasług. ");
INSERT INTO polsz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Zaczął prześladować nasz naród i zmuszał rodziców do porzucania swoich niemowląt, powodując ich śmierć. ");
INSERT INTO polsz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","W tym właśnie czasie urodził się Mojżesz—dziecko ukochane przez Boga. Przez trzy miesiące trzymano go potajemnie w domu rodzinnym, ");
INSERT INTO polsz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","a gdy już został porzucony, znalazła go córka faraona. Zaopiekowała się nim i uczyniła swoim synem. ");
INSERT INTO polsz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Dzięki temu Mojżesz zdobył całą wiedzę Egiptu i stał się potężny zarówno w słowach, jak i czynach. ");
INSERT INTO polsz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Pewnego dnia, gdy miał już prawie czterdzieści lat, postanowił odwiedzić swoich rodaków—Izraelitów. ");
INSERT INTO polsz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Zobaczył wtedy, jak pewien Egipcjanin znęca się nad Izraelitą. Stanął w jego obronie i zabił Egipcjanina. ");
INSERT INTO polsz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Spodziewał się, że rodacy zrozumieją, iż przez niego sam Bóg przychodzi im na ratunek. Ale oni tego nie pojęli. ");
INSERT INTO polsz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Następnego dnia Mojżesz zobaczył dwóch bijących się Izraelitów. Próbował ich pogodzić, wołając: „Jesteście przecież rodakami! Dlaczego więc krzywdzicie się nawzajem?”. ");
INSERT INTO polsz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Wtedy ten, który bił drugiego, odepchnął Mojżesza i powiedział: „Kto cię ustanowił naszym przywódcą i sędzią? ");
INSERT INTO polsz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Może i mnie chcesz zabić, tak jak wczoraj tego Egipcjanina?”. ");
INSERT INTO polsz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Słysząc to, Mojżesz uciekł z Egiptu i zamieszkał jako cudzoziemiec w kraju Madian. Tam urodziło mu się dwóch synów. ");
INSERT INTO polsz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Czterdzieści lat później, na pustyni, w pobliżu góry Synaj, ukazał mu się anioł—w krzaku, który płonął, ale się nie spalał. ");
INSERT INTO polsz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Zaciekawiony tym widokiem, Mojżesz podszedł bliżej i wtedy usłyszał głos Pana: ");
INSERT INTO polsz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","„Jestem Bogiem twoich przodków—Abrahama, Izaaka i Jakuba”. Mojżesz przeraził się i nie miał odwagi dłużej na to patrzeć. ");
INSERT INTO polsz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","„Zdejmij buty—powiedział Pan—bo miejsce, na którym stoisz, to święta ziemia. ");
INSERT INTO polsz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Widziałem cierpienia mojego ludu w Egipcie i słyszałem jego jęki. Zstąpiłem więc, aby go wyzwolić. Chodź, poślę cię teraz do Egiptu”. ");
INSERT INTO polsz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Właśnie tego Mojżesza, którego Izraelici odrzucili, mówiąc: „Kto cię ustanowił naszym przywódcą i sędzią?”, Bóg posłał jako przywódcę i wybawiciela swojego narodu, pod opieką anioła, którego zobaczył w płonącym krzaku. ");
INSERT INTO polsz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","I to właśnie on wyprowadził Izraelitów z niewoli, dokonując przy tym wielu niezwykłych cudów, zarówno w Egipcie, jaki i przy przejściu przez Morze Czerwone oraz podczas czterdziestu lat wędrówki przez pustynię. ");
INSERT INTO polsz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","To właśnie Mojżesz powiedział Izraelitom: „Bóg powoła spośród was proroka podobnego do mnie”. ");
INSERT INTO polsz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","I to on był na pustyni pośrednikiem między aniołem, który przemawiał do niego na górze Synaj, a zgromadzeniem Izraela. Od niego otrzymał słowa dające życie—Boże Prawo, aby przekazać je również nam. ");
INSERT INTO polsz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Lecz nasi przodkowie nie chcieli słuchać Mojżesza. Gdy na pewien czas ich opuścił, odrzucili go i zapragnęli wrócić do Egiptu. ");
INSERT INTO polsz_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Powiedzieli Aaronowi: „Zrób nam podobizny bogów! Niech nas poprowadzą z powrotem, bo nie wiemy, co się stało z Mojżeszem, który wyprowadził nas z Egiptu”. ");
INSERT INTO polsz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Zrobili więc bożka, złożyli mu ofiarę i cieszyli się ze swojego dzieła. ");
INSERT INTO polsz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Wtedy Bóg odwrócił się od nich i dopuścił, aby oddawali cześć gwiazdom na niebie. Opisane to jest w księdze jednego z proroków: „Izraelici! Czy to dla Mnie składaliście ofiary będąc przez całe czterdzieści lat na pustyni? ");
INSERT INTO polsz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nie! Czciliście bożka Molocha w jego namiocie i gwiazdę bożka Refana. Kłanialiście się figurom, które sami sobie zrobiliście. Dlatego pójdziecie w niewolę, daleko, aż za Babilon”. ");
INSERT INTO polsz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Nasi przodkowie mieli na pustyni namiot przymierza, dowód obecności Boga—kontynuował Szczepan. —To On nakazał Mojżeszowi wykonać go dokładnie według przedstawionego wzoru. ");
INSERT INTO polsz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Później pod wodzą Jozuego podbili oni ziemię narodów, które Bóg przed nimi wypędził. Wtedy wnieśli ten namiot do Kanaanu i mieli go aż do czasów króla Dawida. ");
INSERT INTO polsz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawid cieszył się przychylnością Boga Jakuba i prosił Go o zgodę na wybudowanie dla Niego świątyni, ");
INSERT INTO polsz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ale zrobił to dopiero Salomon. ");
INSERT INTO polsz_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Najwyższy Bóg nie mieszka jednak w świątyniach wzniesionych przez ludzi. Prorok Izajasz powiedział: ");
INSERT INTO polsz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","„Bóg mówi: Niebo jest moim tronem, a ziemia jedynie moim podnóżkiem. Jaki więc dom Mi zbudujecie? Jakie miejsce odpoczynku? ");
INSERT INTO polsz_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Czy ziemia i niebo nie są moim dziełem?”. ");
INSERT INTO polsz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Jesteście uparci—mówił dalej Szczepan—a wasze serca i uszy są nieczułe jak u pogan! Zawsze sprzeciwiacie się Duchowi Świętemu, tak samo jak wasi przodkowie. ");
INSERT INTO polsz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Który prorok nie był przez nich prześladowany? Zabili nawet tych, którzy przepowiadali nadejście Prawego, czyli Jezusa. A wy Jego samego zdradziliście i zamordowaliście! ");
INSERT INTO polsz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nie przestrzegaliście Prawa Mojżesza, chociaż otrzymaliście je z rąk aniołów. ");
INSERT INTO polsz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Przywódcy, słysząc słowa Szczepana, wpadli w gniew. ");
INSERT INTO polsz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lecz on, pełen Ducha Świętego, wpatrywał się w niebo. I ujrzał chwałę Boga oraz Jezusa, stojącego po Jego prawej stronie. ");
INSERT INTO polsz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","—Widzę otwarte niebo—powiedział—i Syna Człowieczego stojącego po prawej stronie Boga. ");
INSERT INTO polsz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tego już nie mogli znieść. Zaczęli krzyczeć, zatkali sobie uszy i wszyscy razem rzucili się na Szczepana. ");
INSERT INTO polsz_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Wywlekli go za miasto i zaczęli obrzucać kamieniami. Oficjalni świadkowie tej egzekucji zdjęli swoje płaszcze i zostawili je u młodego człowieka imieniem Szaweł. ");
INSERT INTO polsz_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Gdy rzucali w Szczepana kamieniami, on zawołał: —Panie Jezu! Przyjmij mojego ducha! ");
INSERT INTO polsz_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Chwilę później, osuwając się na kolana, zawołał jeszcze głośniej: —Panie! Nie policz im tego grzechu! Po tych słowach umarł. ");
INSERT INTO polsz_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Przyglądający się temu Szaweł w pełni akceptował karę śmierci wymierzoną Szczepanowi. Tego dnia rozpoczęło się masowe prześladowanie kościoła w Jerozolimie. Wszyscy, z wyjątkiem apostołów, rozproszyli się po Judei i Samarii. ");
INSERT INTO polsz_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ciało Szczepana zostało zaś w wielkim żalu pochowane przez kilku pobożnych ludzi. ");
INSERT INTO polsz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Szaweł w tym czasie zaczął wszędzie tępić członków kościoła. Wpadał do domów, wywlekał wierzących—mężczyzn oraz kobiety—i osadzał ich w więzieniu. ");
INSERT INTO polsz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ci, którzy uciekli z Jerozolimy, w drodze głosili dobrą nowinę. ");
INSERT INTO polsz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip zaszedł wtedy do pewnego miasta w Samarii i opowiadał tam o Mesjaszu. ");
INSERT INTO polsz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","A przychodziły do niego wielkie tłumy, bo ludzie słyszeli już o czynionych przez niego cudach. ");
INSERT INTO polsz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Złe duchy z wielkim krzykiem opuszczały bowiem zniewolonych przez siebie ludzi, a wielu sparaliżowanych i niemogących chodzić odzyskiwało zdrowie. ");
INSERT INTO polsz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Z tego powodu wielka radość napełniła całe to miasto. ");
INSERT INTO polsz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mieszkał tam również niejaki Szymon, który od dawna uprawiał czarną magię. Zadziwiał Samarytan i twierdził, że jest kimś niezwykłym. ");
INSERT INTO polsz_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Wszyscy więc, od najmniejszego do największego, darzyli go ogromnym szacunkiem, mówiąc: „Ten człowiek ma potężną moc Boga”. ");
INSERT INTO polsz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Liczono się z nim, ponieważ już od dłuższego czasu ludzie byli zdumieni jego magią. ");
INSERT INTO polsz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Teraz jednak wielu uwierzyło Filipowi, głoszącemu dobrą nowinę o królestwie Bożym i o Jezusie Chrystusie. W rezultacie tego, wielu mieszkańców—zarówno mężczyzn, jak i kobiet—zostało zanurzonych w wodzie. ");
INSERT INTO polsz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Wśród nich był Szymon—on także uwierzył i przyjął chrzest. Potem zaś wiernie towarzyszył Filipowi, a widząc jego potężne cuda, nie mógł się im nadziwić. ");
INSERT INTO polsz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Gdy apostołowie w Jerozolimie dowiedzieli się, że mieszkańcy Samarii przyjęli słowo Boże, posłali do nich Piotra i Jana. ");
INSERT INTO polsz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ci modlili się, aby nowi wierzący otrzymali Ducha Świętego. ");
INSERT INTO polsz_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Na nikogo z nich bowiem Duch jeszcze nie zstąpił. Byli jedynie zanurzeni w wodzie w imię Jezusa, Pana. ");
INSERT INTO polsz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Piotr i Jan kładli więc na nich ręce, a ci przyjmowali Ducha Świętego. ");
INSERT INTO polsz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Szymon, widząc, że apostołowie przez nałożenie rąk udzielają innym Ducha, przyniósł im pieniądze i powiedział: ");
INSERT INTO polsz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","—Sprzedajcie mi tę moc i sprawcie, aby ten, na którego nałożę ręce, otrzymywał Ducha Świętego. ");
INSERT INTO polsz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","—Przepadnij razem ze swoimi pieniędzmi!—odparł Piotr. —Jak mogłeś sądzić, że dar Boga można kupić! ");
INSERT INTO polsz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nie masz żadnego udziału w głoszonym tu słowie Bożym, bo twoje serce nie jest szczere wobec Boga. ");
INSERT INTO polsz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Opamiętaj się więc, zerwij ze złem i proś Pana, a może przebaczy ci ten nikczemny pomysł. ");
INSERT INTO polsz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Widzę bowiem, że jesteś pogrążony w zgorzknieniu i nieprawości. ");
INSERT INTO polsz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","—Módlcie się za mnie do Pana—zawołał Szymon—żeby nie spotkało mnie to, o czym powiedzieliście. ");
INSERT INTO polsz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Piotr i Jan potwierdzili wiarę Samarytan i przekazali im słowo Boże. A w drodze powrotnej do Jerozolimy jeszcze w wielu samarytańskich wioskach głosili dobrą nowinę. ");
INSERT INTO polsz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","W tym czasie Filip otrzymał następujące polecenie od anioła Pana: —Idź na południe, na pustynną drogę prowadzącą z Jerozolimy do Gazy. ");
INSERT INTO polsz_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filip wstał więc i poszedł. Właśnie wtedy wracał tą drogą wysoki urzędnik etiopskiej królowej Kandaki, który zarządzał jej finansami. Odwiedził on Jerozolimę, aby w świątyni oddać pokłon Bogu. ");
INSERT INTO polsz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Siedząc w swoim powozie, czytał na głos księgę proroka Izajasza. ");
INSERT INTO polsz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Wtedy Duch Święty powiedział Filipowi: —Zbliż się do niego i idź obok powozu. ");
INSERT INTO polsz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Gdy Filip podbiegł, usłyszał, że urzędnik czyta księgę. Zapytał więc: —Czy rozumiesz to, co czytasz? ");
INSERT INTO polsz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","—Jak mogę rozumieć, skoro nikt mi tego nie wyjaśnia?—odpowiedział urzędnik. Następnie poprosił Filipa, aby usiadł przy nim w powozie. ");
INSERT INTO polsz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A czytał właśnie następujący fragment Pisma: „Jak owca prowadzona na rzeź i jak baranek milczący wobec strzygących Go, tak On nie otwiera swoich ust. ");
INSERT INTO polsz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Poniżono Go i odmówiono Mu sprawiedliwości. Jak mógłby doczekać potomków, skoro mordując, usunięto Go ze świata?”. ");
INSERT INTO polsz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","—Wyjaśnij mi, czy prorok Izajasz mówi tu o sobie, czy o kimś innym—poprosił urzędnik. ");
INSERT INTO polsz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Wówczas Filip, zaczynając od tego fragmentu, przedstawił mu dobrą nowinę o Jezusie. ");
INSERT INTO polsz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","W końcu, w trakcie podróży dotarli nad jakąś wodę. —Spójrz, tu jest woda!—zawołał urzędnik. —Co stoi na przeszkodzie, abym został w niej zanurzony? ");
INSERT INTO polsz_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Następnie polecił zatrzymać powóz. Obaj zeszli do wody i Filip ochrzcił urzędnika. ");
INSERT INTO polsz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","A gdy wyszli z wody, Duch Pana zabrał Filipa i urzędnik już go więcej nie zobaczył. Mimo to pełen radości udał się w dalszą drogę. ");
INSERT INTO polsz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip natomiast znalazł się w Azocie. I kierując się w stronę Cezarei, głosił dobrą nowinę we wszystkich tamtejszych miastach. ");
INSERT INTO polsz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tymczasem Szaweł był nadal niebezpieczny dla kościoła i w dalszym ciągu pragnął mordować uczniów Jezusa. Zjawił się u najwyższego kapłana ");
INSERT INTO polsz_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","i poprosił go o listy do synagog w rejonie Damaszku. Dzięki nim pragnął aresztować i doprowadzić do Jerozolimy tamtejszych zwolenników drogi Jezusa: zarówno mężczyzn, jak i kobiety. ");
INSERT INTO polsz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Gdy wyruszył w drogę do Damaszku i zbliżał się już do miasta, nagle oślepił go blask z nieba. ");
INSERT INTO polsz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wtedy upadł na ziemię i usłyszał głos: —Szawle, Szawle! Dlaczego Mnie prześladujesz? ");
INSERT INTO polsz_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","—Kim jesteś, Panie?—zapytał. —Jestem Jezus, Ten, którego prześladujesz!—odrzekł głos. ");
INSERT INTO polsz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","—Wstań teraz i idź do miasta. Tam ci powiedzą, co masz dalej robić. ");
INSERT INTO polsz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ludzie towarzyszący Szawłowi oniemieli ze zdumienia. Słyszeli bowiem czyjś głos, ale nikogo nie widzieli. ");
INSERT INTO polsz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Szaweł natomiast podniósł się z ziemi, ale chociaż miał otwarte oczy, nic nie widział. Poprowadzono go więc za rękę do Damaszku. ");
INSERT INTO polsz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","I przez trzy dni był niewidomy. Nic w tym czasie nie jadł ani nie pił. ");
INSERT INTO polsz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","W Damaszku mieszkał pewien uczeń Jezusa, niejaki Ananiasz. Jemu to właśnie ukazał się w widzeniu Pan i powiedział: —Ananiaszu! —Słucham, Panie—odpowiedział uczeń. ");
INSERT INTO polsz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","—Idź na ulicę Prostą, do domu Judy i odszukaj tam Szawła z Tarsu. Właśnie się modli. ");
INSERT INTO polsz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","W tym momencie Szaweł w widzeniu zobaczył, jak Ananiasz przychodzi i kładzie na niego ręce, aby mógł odzyskać wzrok. ");
INSERT INTO polsz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","—Panie!—zawołał Ananiasz. —Słyszałem od wielu ludzi, że ten człowiek wyrządził wiele zła Twoim świętym w Jerozolimie. ");
INSERT INTO polsz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Podobno ma zgodę od najwyższych kapłanów, aby i tutaj aresztować wszystkich, którzy Tobie ufają. ");
INSERT INTO polsz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","—Idź, Ananiaszu!—odrzekł Pan. —Właśnie jego wybrałem sobie za narzędzie. On zaniesie wiadomość o Mnie innym narodom i ich władcom, a także Izraelowi. ");
INSERT INTO polsz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","I pokażę mu, ile będzie musiał wycierpieć z mojego powodu. ");
INSERT INTO polsz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiasz poszedł więc, udał się do domu, w którym był Szaweł, położył na niego ręce i rzekł: —Szawle, przyjacielu! Jezus, który ukazał ci się w drodze, przysłał mnie do ciebie, abyś odzyskał wzrok i został napełniony Duchem Świętym. ");
INSERT INTO polsz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","I natychmiast spadły mu z oczu jakby łuski. Odzyskał wzrok, po czym wstał i dał się ochrzcić. ");
INSERT INTO polsz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Następnie zjadł posiłek i odzyskał siły. Przez kilka dni Szaweł pozostał z uczniami w Damaszku. ");
INSERT INTO polsz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","I od razu zaczął głosić w okolicznych synagogach, że Jezus naprawdę jest Synem Boga. ");
INSERT INTO polsz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Wszyscy, którzy go słuchali, byli tym wręcz oszołomieni i pytali: —Czy to nie ten sam człowiek, który w Jerozolimie prześladował wyznawców Jezusa? Przecież przybył tu, żeby ich aresztować i doprowadzić do najwyższych kapłanów? ");
INSERT INTO polsz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ale on przemawiał z coraz większą mocą i wprawiał w zakłopotanie żydowskich mieszkańców Damaszku, dowodząc, że Jezus jest Mesjaszem. ");
INSERT INTO polsz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Po pewnym czasie postanowili go zabić. ");
INSERT INTO polsz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Szaweł jednak dowiedział się o tym spisku i usłyszał, że dniem i nocą pilnują bram miasta. ");
INSERT INTO polsz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Wtedy uczniowie pomogli mu przedostać się nocą przez mur otaczający miasto, spuszczając go na dół w koszu. ");
INSERT INTO polsz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Po przybyciu do Jerozolimy, Szaweł próbował nawiązać kontakt z uczniami Jezusa. Wszyscy jednak się go bali i nie wierzyli, że został Jego uczniem. ");
INSERT INTO polsz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Dopiero Barnaba zaprowadził go do apostołów. Opowiedział im o tym, jak w drodze do Damaszku Szaweł ujrzał Jezusa, o tym, co Pan mu powiedział, i jak w Damaszku Szaweł otwarcie przemawiał w Jego imieniu. ");
INSERT INTO polsz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Dzięki Barnabie mógł przebywać z nimi w Jerozolimie. ");
INSERT INTO polsz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Szaweł prowadził tam ostre dyskusje z Żydami mówiącymi po grecku, którzy w końcu postanowili go zabić. ");
INSERT INTO polsz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Gdy wierzący dowiedzieli się o tym, odprowadzili go do Cezarei, a stamtąd wysłali do Tarsu, skąd pochodził. ");
INSERT INTO polsz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Wtedy w całej Judei, Galilei i Samarii nastał okres pokoju dla wierzących. Kościół zaś umacniał się i rozrastał, a uczniowie Jezusa, wzmacniani przez Ducha Świętego, swoim życiem oddawali chwałę Panu. ");
INSERT INTO polsz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tymczasem Piotr, odwiedzając wierzących w różnych miejscach, zawitał także do świętych w Liddzie. ");
INSERT INTO polsz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Spotkał tam niejakiego Eneasza, który z powodu paraliżu od ośmiu lat nie wstawał z łóżka. ");
INSERT INTO polsz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","—Eneaszu!—rzekł do niego. —Jezus Chrystus cię uzdrawia! Wstań i sam zaściel swoje łóżko. A ten natychmiast wstał. ");
INSERT INTO polsz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Gdy wszyscy mieszkańcy Liddy i Saronu zobaczyli uzdrowionego Eneasza, nawrócili się do Pana. ");
INSERT INTO polsz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","W Jaffie zaś mieszkała pewna uczennica Jezusa imieniem Tabita (to znaczy: „gazela”). Czyniła wiele dobra, szczególnie troszcząc się o biednych. ");
INSERT INTO polsz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Akurat w tym czasie zachorowała i umarła. Jej ciało przygotowano więc do pogrzebu i ułożono w pokoju na piętrze. ");
INSERT INTO polsz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ponieważ Lidda leży blisko Jaffy, tamtejsi uczniowie dowiedzieli się, że jest tam Piotr, i wysłali do niego dwóch ludzi z prośbą: „Przybądź do nas jak najszybciej”. ");
INSERT INTO polsz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Razem z posłańcami przyszedł więc do Jaffy. Gdy był już na miejscu, zaprowadzono go na piętro, gdzie obstąpiły go płaczące wdowy, pokazujące tuniki i płaszcze, które za życia wykonała dla nich Tabita. ");
INSERT INTO polsz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Wtedy Piotr polecił wszystkim opuścić pokój, a sam padł na kolana i modlił się. Potem odwrócił się w stronę ciała i powiedział: „Tabito, wstań!”. A ona otworzyła oczy! Gdy zobaczyła Piotra, usiadła. ");
INSERT INTO polsz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Wtedy podał jej rękę i pomógł wstać, po czym zawołał wdowy oraz innych świętych i pokazał im, że żyje. ");
INSERT INTO polsz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Wieść o tym rozeszła się po całym mieście i wielu ludzi uwierzyło w Pana. ");
INSERT INTO polsz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Po tym wydarzeniu Piotr jeszcze długo przebywał w Jaffie, mieszkając u pewnego miejscowego garbarza—Szymona. ");
INSERT INTO polsz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","W Cezarei mieszkał niejaki Korneliusz, rzymski dowódca oddziału zwanego Italskim. ");
INSERT INTO polsz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Był to człowiek bardzo pobożny. Razem z całym swoim domem bardzo poważnie traktował Boga, nieustannie modlił się do Niego i hojne wspierał biednych. ");
INSERT INTO polsz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pewnego razu, około trzeciej po południu, miał widzenie: wyraźnie ujrzał anioła, który zbliżył się do niego i powiedział: —Korneliuszu! ");
INSERT INTO polsz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","—Słucham cię, panie!—odpowiedział przestraszony i wpatrzony w niego dowódca. —Twoje modlitwy i ofiarność zostały zauważone przez Boga—rzekł anioł. ");
INSERT INTO polsz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","—Wyślij teraz do Jaffy swoich ludzi i zaproś do siebie Szymona Piotra, ");
INSERT INTO polsz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","który jest gościem innego Szymona, garbarza z Jaffy. Jego dom znajduje się nad brzegiem morza. ");
INSERT INTO polsz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Gdy tylko anioł odszedł, Korneliusz zawołał dwóch służących i pewnego pobożnego żołnierza ze swojej straży przybocznej. ");
INSERT INTO polsz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Opowiedział im o wszystkim i wysłał do Jaffy. ");
INSERT INTO polsz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Następnego dnia, gdy posłańcy byli jeszcze w drodze, ale zbliżali się już do miasta, Piotr wyszedł na taras domu, aby się modlić. Było to około dwunastej. ");
INSERT INTO polsz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Poczuł wtedy głód i miał ochotę coś zjeść. A gdy przygotowywano posiłek, doznał widzenia. ");
INSERT INTO polsz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ujrzał otwarte niebo i jakby olbrzymią płachtę, opuszczaną za cztery rogi ku ziemi. ");
INSERT INTO polsz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Były na niej wszelkiego rodzaju zwierzęta, płazy i ptaki. ");
INSERT INTO polsz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","I usłyszał głos: —Rusz się, Piotrze. Zabij je i jedz. ");
INSERT INTO polsz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","—Nigdy w życiu, Panie! Nigdy nie jadłem żadnych nieczystych stworzeń, bo zabrania tego Prawo Mojżesza! ");
INSERT INTO polsz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","—Nie uważaj za nieczyste tego, co Bóg oczyścił—odpowiedział głos. ");
INSERT INTO polsz_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","To samo powtórzyło się trzykrotnie, po czym płachta została z powrotem wzięta do nieba. ");
INSERT INTO polsz_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piotr z dużą niepewnością zastanawiał się nad znaczeniem tej wizji. Właśnie wtedy posłańcy Korneliusza stanęli przy bramie wejściowej. Zdążyli się już bowiem dowiedzieć, gdzie się znajduje dom Szymona, garbarza, ");
INSERT INTO polsz_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","i teraz pytali, czy zatrzymał się tu Szymon Piotr. ");
INSERT INTO polsz_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","A gdy on ciągle jeszcze zastanawiał się nad wizją, Duch Święty powiedział do niego: —Szuka cię trzech ludzi. ");
INSERT INTO polsz_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Zejdź na dół i idź z nimi bez wahania. To Ja ich posłałem. ");
INSERT INTO polsz_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piotr zszedł więc i zwrócił się do przybyłych: —To mnie szukacie. Co was sprowadza? ");
INSERT INTO polsz_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","—Wzywa cię Korneliusz—odpowiedzieli—rzymski dowódca, człowiek prawy i poważnie traktujący Boga, mający dobrą opinię wśród Żydów. Właśnie jemu anioł polecił wezwać cię do jego domu i posłuchać tego, co masz do powiedzenia. ");
INSERT INTO polsz_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piotr zaprosił ich do środka i udzielił noclegu. Następnego zaś dnia, wraz z kilkoma wierzącymi z Jaffy, ruszyli w drogę. ");
INSERT INTO polsz_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Dzień później przybyli do Cezarei. Korneliusz czekał już na nich razem z zaproszonymi krewnymi i przyjaciółmi. ");
INSERT INTO polsz_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Gdy Piotr wchodził do jego domu, wyszedł mu na spotkanie i padł mu do nóg, oddając cześć. ");
INSERT INTO polsz_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Lecz Piotr rzekł: —Wstań! Ja też jestem tylko człowiekiem! ");
INSERT INTO polsz_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","I rozmawiając z Korneliuszem, wszedł do środka, gdzie czekało już wiele osób. ");
INSERT INTO polsz_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wtedy przemówił do nich: —Dobrze wiecie, że nam, Żydom, nie wolno kontaktować się ani nawet zbliżać do pogan. Bóg jednak objawił mi, że nikogo nie należy uważać za nieczystego i gorszego. ");
INSERT INTO polsz_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Dlatego przyszedłem bez sprzeciwu. Powiedzcie więc, dlaczego mnie wezwaliście. ");
INSERT INTO polsz_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","—Cztery dni temu—odrzekł Korneliusz—modliłem się tu, w domu, około trzeciej po południu, gdy nagle stanął przede mną człowiek ubrany w lśniącą szatę ");
INSERT INTO polsz_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","i rzekł: „Korneliuszu, twoje modlitwy i ofiarność zostały zauważone przez Boga! ");
INSERT INTO polsz_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Wyślij więc do Jaffy swoich ludzi i zaproś do siebie Szymona Piotra, który jest gościem innego Szymona, garbarza z Jaffy. Jego dom znajduje się nad brzegiem morza”. ");
INSERT INTO polsz_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Dlatego natychmiast po ciebie posłałem i dobrze zrobiłeś, że przybyłeś. Zebraliśmy się więc tu, w obecności Boga, aby wysłuchać wszystkiego, co Pan ci przekazał! ");
INSERT INTO polsz_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","—Teraz naprawdę rozumiem—rzekł Piotr—że Bóg nie jest stronniczy, ");
INSERT INTO polsz_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ale w każdym narodzie podoba Mu się ten, kto traktuje Go poważnie i jest prawy. ");
INSERT INTO polsz_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","On to przekazał Izraelowi dobrą nowinę o pokoju darowanym przez Jezusa Chrystusa, Pana wszystkich ludzi. ");
INSERT INTO polsz_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Od czasu, w którym Jan Chrzciciel wzywał ludzi do opamiętania, nowina o Jezusie rozeszła się po całej żydowskiej ziemi, począwszy od Galilei. ");
INSERT INTO polsz_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Wiecie zapewne, że Bóg w szczególny sposób obdarzył Duchem Świętym i mocą Jezusa z Nazaretu. On, żyjąc na ziemi, czynił dobro i uzdrawiał wszystkich zniewolonych przez diabła, ponieważ wspierał Go Bóg. ");
INSERT INTO polsz_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","My, apostołowie, jesteśmy naocznymi świadkami tego wszystkiego, co uczynił w Judei i w Jerozolimie, gdzie Go zabito przez ukrzyżowanie. ");
INSERT INTO polsz_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Trzeciego dnia po śmierci, Bóg ożywił Go i pozwolił Mu się ukazać ludziom ");
INSERT INTO polsz_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","—nie wszystkim, ale tylko nam jako wcześniej wybranym świadkom. Po Jego zmartwychwstaniu jedliśmy i piliśmy razem z Nim. ");
INSERT INTO polsz_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","A On nakazał nam ogłosić i zaświadczyć Żydom, że Bóg ustanowił Go sędzią wszystkich ludzi, zarówno żywych, jak i umarłych. ");
INSERT INTO polsz_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Również prorocy przepowiedzieli w Piśmie, że każdy, kto uwierzy w Jezusa, ze względu na Niego otrzyma przebaczenie grzechów. ");
INSERT INTO polsz_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piotr jeszcze mówił, gdy nagle na wszystkich słuchaczy zstąpił Duch Święty. ");
INSERT INTO polsz_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wierzący żydowskiego pochodzenia, którzy przybyli z Piotrem, bardzo się zdziwili, że także poganie otrzymali dar Ducha Świętego. ");
INSERT INTO polsz_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Słyszeli bowiem, jak mówią obcymi językami i wielbią Boga. ");
INSERT INTO polsz_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Czy ktoś mógłby zabronić ochrzczenia tych, którzy otrzymali Ducha Świętego tak samo jak my, Żydzi?—zapytał Piotr. ");
INSERT INTO polsz_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","I polecił, aby zanurzono ich w wodzie w imię Jezusa Chrystusa. Po tym wszystkim poprosili Piotra, aby został z nimi jeszcze kilka dni. ");
INSERT INTO polsz_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Wkrótce wiadomość o tym, że również poganie przyjęli słowo Boże, dotarła do apostołów i innych wierzących w Judei. ");
INSERT INTO polsz_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","A gdy Piotr wrócił do Jerozolimy, uczniowie pochodzenia żydowskiego zaczęli stawiać mu zarzuty. ");
INSERT INTO polsz_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","—Przebywałeś wśród pogan i nawet jadłeś z nimi!—oburzali się. ");
INSERT INTO polsz_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","5","—Pewnego dnia w Jaffie, gdy się modliłem, miałem widzenie—zaczął opowiadać Piotr. —Z nieba prosto na mnie spuszczone zostało coś jakby ogromna płachta, trzymana za cztery rogi. ");
INSERT INTO polsz_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Zajrzałem do środka i zobaczyłem w niej różne gatunki zwierząt, płazów i ptaków. ");
INSERT INTO polsz_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Usłyszałem też głos, mówiący do mnie: „Rusz się, Piotrze. Zabij je i jedz”. ");
INSERT INTO polsz_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Odpowiedziałem na to: „Nigdy w życiu, Panie! Nigdy nie jadłem żadnych nieczystych stworzeń, bo zabrania tego Prawo Mojżesza!”. ");
INSERT INTO polsz_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Lecz głos z nieba odezwał się znowu: „Nie uważaj za nieczyste tego, co Bóg oczyścił”. ");
INSERT INTO polsz_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Powtórzyło się to trzy razy, po czym wszystko zostało z powrotem zabrane do nieba. ");
INSERT INTO polsz_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Wtedy właśnie przed domem, w którym mieszkaliśmy, stanęli trzej ludzie, wysłani do mnie z Cezarei. ");
INSERT INTO polsz_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Duch Święty powiedział mi, abym poszedł z nimi, nie zważając na to, że są poganami. Towarzyszyło mi tych oto sześciu wierzących. Gdy dotarliśmy do domu tego człowieka, ");
INSERT INTO polsz_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","opowiedział nam, że ukazał mu się anioł, który powiedział: „Wyślij swoich ludzi do Jaffy i zaproś Szymona Piotra. ");
INSERT INTO polsz_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","On powie ci coś, dzięki czemu ty i twoi domownicy zostaniecie zbawieni”. ");
INSERT INTO polsz_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Gdy, przybywszy do nich, zacząłem mówić, zstąpił na nich Duch Święty, tak samo jak na nas podczas święta Pięćdziesiątnicy. ");
INSERT INTO polsz_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Przypomniałem sobie wtedy słowa Pana: „Jan Chrzciciel zanurzał w wodzie, lecz wy zostaniecie zanurzeni w Duchu Świętym”. ");
INSERT INTO polsz_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Skoro więc poganom Bóg dał ten sam dar, co nam, którzy uwierzyliśmy w Jezusa Chrystusa, to czy mogłem sprzeciwić się Bogu? ");
INSERT INTO polsz_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Po tych słowach zapadła cisza, następnie zaś wszyscy zaczęli wielbić Boga, mówiąc: —A więc również poganom Bóg dał możliwość opamiętania się i otrzymania życia wiecznego! ");
INSERT INTO polsz_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tymczasem wierzący, którzy po śmierci Szczepana uciekli z Jerozolimy przed prześladowaniami, dotarli aż do Fenicji, na Cypr i do Antiochii. Po drodze głosili słowo Boże, ale wyłącznie Żydom. ");
INSERT INTO polsz_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ci jednak, którzy pochodzili z Cypru i z Cyreny, przybywszy do Antiochii, dzielili się dobrą nowiną o Jezusie także z Grekami. ");
INSERT INTO polsz_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","A Pan bardzo im w tym pomagał i dzięki ich słowom wielu ludzi uwierzyło i nawróciło się do Jezusa. ");
INSERT INTO polsz_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Wieść o tym dotarła do kościoła w Jerozolimie. Wysłano więc tam Barnabę. ");
INSERT INTO polsz_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Gdy przybył na miejsce i zobaczył działanie Bożej łaski, ogromnie się ucieszył i gorąco wszystkich zachęcał, aby całym sercem trwali w wierze w Pana. ");
INSERT INTO polsz_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Był on bowiem dobrym człowiekiem, pełnym Ducha Świętego i wiary. Dzięki jego słowom zachęty wielu nowych ludzi nawróciło się do Pana. ");
INSERT INTO polsz_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Potem Barnaba udał się do Tarsu, aby odszukać Szawła. ");
INSERT INTO polsz_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Gdy go znalazł, przyprowadził go do Antiochii. Tam przez cały rok spotykali się razem z kościołem i nauczali liczne grono wierzących. To właśnie w Antiochii po raz pierwszy nazwano uczniów chrześcijanami, czyli „należącymi do Chrystusa”. ");
INSERT INTO polsz_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","W tym czasie przybyło z Jerozolimy do Antiochii kilku proroków. ");
INSERT INTO polsz_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jeden z nich, niejaki Agabos, natchniony przez Ducha, przepowiedział, że na całym świecie nastanie wielki głód. Jego słowa spełniły się za panowania rzymskiego cezara Klaudiusza. ");
INSERT INTO polsz_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Uczniowie postanowili więc udzielić pomocy wierzącym w Judei, dając to, na co każdego było stać. ");
INSERT INTO polsz_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Zebrane dary wysłali następnie starszym w Judei za pośrednictwem Barnaby i Szawła. ");
INSERT INTO polsz_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mniej więcej w tym samym czasie król Herod Agryppa zaczął prześladować niektórych wierzących z kościoła z Jerozolimie. ");
INSERT INTO polsz_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Najpierw ściął apostoła Jakuba, brata Jana. ");
INSERT INTO polsz_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Gdy jednak zauważył, że spodobało się to żydowskim przywódcom, aresztował także Piotra. A zbliżało się święto Paschy. ");
INSERT INTO polsz_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herod polecił go związać i wtrącić do więzienia, a czterem czteroosobowym oddziałom żołnierzy rozkazał pilnować go. Po święcie bowiem zamierzał urządzić mu publiczny proces. ");
INSERT INTO polsz_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piotr siedział więc w więzieniu, a wierzący gorliwie modlili się do Boga w jego sprawie. ");
INSERT INTO polsz_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","W noc poprzedzającą planowany przez Heroda proces Piotr spał między dwoma żołnierzami, przykuty do nich łańcuchami. Reszta żołnierzy pełniła straż przed bramami więzienia. ");
INSERT INTO polsz_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nagle w celi zrobiło się jasno i przy Piotrze stanął anioł Pana. Trąceniem w bok obudził go i powiedział: —Szybko wstawaj! W tym samym momencie z rąk Piotra opadły łańcuchy. ");
INSERT INTO polsz_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","—Ubierz się i załóż buty—dodał anioł. Gdy Piotr był już gotowy, anioł powiedział: —A teraz narzuć płaszcz i chodź za mną. ");
INSERT INTO polsz_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piotr wyszedł z celi i szedł za nim. Nie zdawał sobie jednak sprawy, że wszystko, co anioł robił, działo się naprawdę. Sądził bowiem, że ma jakieś widzenie. ");
INSERT INTO polsz_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tak minęli pierwszą oraz drugą straż i doszli do żelaznej bramy, prowadzącej do miasta. Ta sama się przed nimi otworzyła. Wyszli więc i gdy przeszli ulicę, anioł niespodziewanie opuścił Piotra. ");
INSERT INTO polsz_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Dopiero wtedy uświadomił sobie, co się stało. —Więc Pan naprawdę posłał swojego anioła—powiedział sam do siebie—aby wyrwał mnie z rąk Heroda i ocalił przed tym, na co czekali żydowscy przywódcy. ");
INSERT INTO polsz_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Po zastanowieniu się, poszedł do domu Marii, matki Jana Marka, gdzie akurat wiele osób zebrało się na wspólną modlitwę. ");
INSERT INTO polsz_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Gdy zapukał do drzwi, służąca Rode podeszła sprawdzić, kto to. ");
INSERT INTO polsz_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Poznała po głosie, że to Piotr, dlatego biegiem wróciła do zebranych i powiedziała, że przed drzwiami stoi Piotr. Z radości jednak zapomniała mu otworzyć. ");
INSERT INTO polsz_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","—To niemożliwe! Chyba oszalałaś—odpowiedzieli jej. Gdy jednak nadal twierdziła, że to naprawdę Piotr, powiedzieli: —W takim razie to musiał być jego anioł. Widocznie Piotr już nie żyje. ");
INSERT INTO polsz_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ale Piotr nie przestawał pukać. Gdy w końcu otworzyli drzwi, doznali szoku. ");
INSERT INTO polsz_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Piotr dał im ręką znak, aby umilkli, i opowiedział, w jaki sposób Pan wyprowadził go z więzienia. —Powiedzcie o tym Jakubowi i innym wierzącym—rzekł, po czym udał się w inne miejsce. ");
INSERT INTO polsz_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Rano w więzieniu powstało wielkie zamieszanie. Żołnierze zastanawiali się, gdzie się podział Piotr. ");
INSERT INTO polsz_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod Agryppa kazał przeszukać więzienie i gdy nie znalazł Piotra, postawił strażników przed sądem i rozkazał ich zabić. Sam zaś opuścił Judeę i zatrzymał się w Cezarei. ");
INSERT INTO polsz_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod był skłócony z mieszkańcami pobliskiego Tyru i Sydonu. Ich przedstawiciele przybyli więc do niego, próbując załagodzić konflikt. Zdobyli przychylność królewskiego sekretarza, Blasta, i dzięki niemu przedstawili Herodowi swą prośbę o pokój. Byli bowiem uzależnieni od dostaw żywności z jego państwa. ");
INSERT INTO polsz_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","W dniu wyznaczonym na odpowiedź, Agryppa włożył królewskie szaty, zasiadł na tronie i publicznie do nich przemówił. ");
INSERT INTO polsz_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Gdy skończył, zgromadzeni ludzie zawołali pełni zachwytu: —To głos Boga, nie człowieka! ");
INSERT INTO polsz_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wtedy anioł Pana poraził Heroda chorobą za to, że przyjął chwałę należną Bogu. Niebawem zmarł, żywcem zjedzony przez robactwo. ");
INSERT INTO polsz_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tymczasem wpływ słowa Bożego wzmacniał się i rozszerzał. ");
INSERT INTO polsz_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnaba z Pawłem zawieźli dary do Jerozolimy i wrócili do Antiochii, zabierając ze sobą Jana Marka. ");
INSERT INTO polsz_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","W kościele w Antiochii prorokami i nauczycielami byli: Barnaba, Szymon—zwany Nigrem, Lucjusz z Cyreny, Manaen, który wychowywał się razem z zarządcą Herodem Antypasem, oraz Szaweł. ");
INSERT INTO polsz_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pewnego dnia, gdy uwielbiali Pana i powstrzymywali się od posiłków, Duch Święty powiedział im: —Przeznaczcie Barnabę i Szawła do specjalnego zadania, do którego ich powołałem. ");
INSERT INTO polsz_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Po dalszym poście i modlitwie położyli na nich ręce na znak posłania i wyprawili w drogę. ");
INSERT INTO polsz_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Wysłani przez Ducha Świętego, Barnaba i Szaweł udali się do portu w Seleucji, skąd popłynęli na Cypr. ");
INSERT INTO polsz_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Gdy znaleźli się w Salaminie, głosili słowo Boże w tamtejszych synagogach. A mieli ze sobą do pomocy Jana Marka. ");
INSERT INTO polsz_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Głosząc dobrą nowinę, przeszli całą wyspę i dotarli do Pafos. Tam natknęli się na niejakiego Bar-Jezusa, maga, który był fałszywym żydowskim prorokiem. ");
INSERT INTO polsz_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Należał on do otoczenia zarządcy Sergiusza Pawła, człowieka bardzo rozsądnego. Ten zaprosił do siebie Barnabę i Szawła, chcąc posłuchać słowa Bożego. ");
INSERT INTO polsz_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ale Bar-Jezus—zwany też Elimasem—starał się nie dopuścić do nawrócenia zarządcy. ");
INSERT INTO polsz_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Wówczas Szaweł—znany później jako Paweł—napełniony Duchem Świętym, spojrzał mu prosto w oczy i rzekł: ");
INSERT INTO polsz_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","—Synu diabła, przesiąknięty podstępem i oszustwem! Wrogu prawości! Czy nie przestaniesz wykrzywiać prostych dróg Pana? ");
INSERT INTO polsz_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Oto On sam cię ukarze i zostaniesz na pewien czas porażony ślepotą! Natychmiast stracił wzrok i miotał się po omacku, szukając kogoś, kto by go mógł poprowadzić. ");
INSERT INTO polsz_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Widząc, co się stało, zarządca uwierzył w Jezusa, zdumiony mocą nauki Pana. ");
INSERT INTO polsz_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Potem Paweł i jego towarzysze odpłynęli z Pafos i przybili do portu Perge w Pamfilii. Tam Jan Marek odłączył się od nich i wrócił do Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Oni natomiast udali się dalej do Antiochii w Pizydii. W szabat poszli do synagogi na nabożeństwo, ");
INSERT INTO polsz_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","gdzie po odczytaniu fragmentów z Prawa Mojżesza i pism proroków przełożeni synagogi zaproponowali im: —Przyjaciele! Jeśli macie dla nas jakieś słowo zachęty, to mówcie! ");
INSERT INTO polsz_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Wtedy Paweł wstał i dał ręką znak, że zaczyna: —Drodzy Izraelici i wy wszyscy, którzy macie respekt dla Boga! ");
INSERT INTO polsz_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Bóg Izraela wybrał naszych przodków i wyciągnął do nich rękę, w cudowny sposób wyprowadzając ich z niewoli egipskiej. ");
INSERT INTO polsz_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Potem, przez blisko czterdzieści lat, znosił ich na pustyni. ");
INSERT INTO polsz_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Wytępił także siedem plemion ziemi Kanaan i dał ten kraj Izraelowi. ");
INSERT INTO polsz_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Trwało to około czterysta pięćdziesiąt lat. Następnie dawał im przywódców, aż do czasów proroka Samuela. ");
INSERT INTO polsz_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Wtedy Izrael zażądał od Boga króla. Dał im więc na czterdzieści lat króla Saula, syna Kisza, pochodzącego z pokolenia Beniamina. ");
INSERT INTO polsz_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Potem jednak odrzucił go i powołał króla Dawida, o którym powiedział: „Znalazłem Dawida, syna Jessego, człowieka bliskiego memu sercu. On wypełni wszystkie moje zamiary”. ");
INSERT INTO polsz_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","To właśnie jego potomek, Jezus—kontynuował Paweł—jest obiecanym Zbawicielem Izraela! ");
INSERT INTO polsz_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Przed Jego nadejściem Jan Chrzciciel wzywał cały nasz naród do zanurzenia się w wodzie na znak opamiętania. ");
INSERT INTO polsz_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Pod koniec swojej misji Jan oznajmił: „Ja nie jestem Tym, za kogo mnie uważacie. Niebawem nadejdzie jednak Ktoś, komu nie jestem nawet godzien zdjąć butów!”. ");
INSERT INTO polsz_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Drodzy przyjaciele, potomkowie Abrahama, i wy, poganie, którzy macie respekt dla Boga! To do nas została posłana wieść o zbawieniu! ");
INSERT INTO polsz_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mieszkańcy Jerozolimy i ich przywódcy nie rozpoznali jednak w Jezusie Mesjasza. A skazując Go na śmierć, wypełnili słowa proroków, które dotychczas czytali w każdy szabat. ");
INSERT INTO polsz_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Choć nie znaleźli powodów wydania Go na śmierć, domagali się, aby Piłat Go stracił. ");
INSERT INTO polsz_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","A gdy już wykonali wszystko, co o Nim przepowiedzieli prorocy, zdjęli Jego ciało z krzyża i złożyli w grobowcu. ");
INSERT INTO polsz_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ale Bóg przywrócił Go do życia! ");
INSERT INTO polsz_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Potem przez wiele dni ukazywał się tym, którzy wcześniej szli z Nim z Galilei do Jerozolimy. To oni są teraz Jego świadkami przed Izraelem. ");
INSERT INTO polsz_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","My przynosimy wam tę właśnie dobrą nowinę! Wskrzeszając Jezusa, Bóg spełnił w naszych czasach obietnice dane przodkom! ");
INSERT INTO polsz_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","To o Jezusie napisano w psalmie drugim: „Ty jesteś moim Synem, Ciebie dziś zrodziłem”. ");
INSERT INTO polsz_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Bóg przepowiedział również—mówił dalej Paweł—że wskrzesi Jezusa, i że On już nigdy nie powróci do grobu. Napisano bowiem: „Uczynię coś cudownego, tak jak obiecałem Dawidowi”. ");
INSERT INTO polsz_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","W innym psalmie—kontynuował Paweł—napisano zaś: „Nie pozwolisz, aby Twój Święty obrócił się w proch”. ");
INSERT INTO polsz_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Jednak Dawid, po spełnieniu swojej służby, zgodnie z wolą Boga zmarł i został pochowany, a jego ciało obróciło się w proch—wyjaśniał Paweł. ");
INSERT INTO polsz_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","—Jednak ciało Jezusa, którego Bóg wskrzesił z martwych, nie uległo zniszczeniu. ");
INSERT INTO polsz_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Przyjaciele, słuchajcie! To właśnie dzięki Jezusowi możecie otrzymać przebaczenie grzechów! ");
INSERT INTO polsz_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Każdy, kto Mu uwierzy, zostanie uniewinniony ze wszystkich przestępstw, od których nie mogło was uwolnić Prawo Mojżesza. ");
INSERT INTO polsz_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Uważajcie jednak, aby nie spełniły się na was następujące słowa proroków: ");
INSERT INTO polsz_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","„Wy, którzy gardzicie prawdą, spójrzcie i odejdźcie ode Mnie, bo za waszych dni uczynię coś, czemu nie zechcecie uwierzyć, chociaż będzie to wam głoszone”. ");
INSERT INTO polsz_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Gdy Paweł skończył, proszono go, aby nauczał o tym również w następny szabat. ");
INSERT INTO polsz_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Po nabożeństwie wielu Żydów i pogan nawróconych na judaizm poszło razem z Pawłem i Barnabą, a ci nakłaniali ich do trwania w łasce Boga. ");
INSERT INTO polsz_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Za tydzień prawie całe miasto zebrało się, aby słuchać słowa Bożego. ");
INSERT INTO polsz_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ale gdy żydowscy przywódcy zobaczyli tłumy ludzi, opanowała ich zazdrość i, obrzucając Pawła obelgami, zaprzeczali wszystkiemu, co mówił. ");
INSERT INTO polsz_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Wówczas on, razem z Barnabą, powiedział wprost: —To wam, w pierwszej kolejności, należało przekazać dobrą nowinę od Boga. Skoro jednak ją odrzucacie i uważacie siebie za niegodnych życia wiecznego, zaniesiemy ją poganom. ");
INSERT INTO polsz_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Pan powiedział bowiem: „Uczyniłem Cię światłem dla pogan, abyś zaniósł zbawienie aż po krańce ziemi”. ");
INSERT INTO polsz_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Słysząc to, poganie z radością przyjęli słowo i wszyscy, którzy byli przeznaczeni do życia wiecznego, uwierzyli w Jezusa. ");
INSERT INTO polsz_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","A słowo Pana szerzyło się po całej okolicy. ");
INSERT INTO polsz_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Wówczas żydowscy przywódcy zbuntowali pobożne i wpływowe kobiety oraz władze miasta i zaczęli prześladować Pawła i Barnabę, doprowadzając do ich wypędzenia. ");
INSERT INTO polsz_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Oni jednak tylko strząsnęli z nóg tamtejszy kurz i udali się do Ikonium. ");
INSERT INTO polsz_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Uczniowie zaś, którzy pozostali w Antiochii, byli pełni radości i Ducha Świętego. ");
INSERT INTO polsz_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","W Ikonium apostołowie również udali się do synagogi. Dzięki ich nauczaniu mnóstwo Żydów i pogan uwierzyło Jezusowi. ");
INSERT INTO polsz_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ale niektórzy Żydzi odrzucili dobrą nowinę i zbuntowali przeciwko nim także pogan. ");
INSERT INTO polsz_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mimo to Paweł i Barnaba zostali tam na dłużej i odważnie mówili o Panu. On zaś dokonywał przez nich wielu cudów, potwierdzając, że to, co mówią o Jego łasce, jest prawdą. ");
INSERT INTO polsz_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Z tego powodu miasto podzieliło się: jedni byli po stronie żydowskich przywódców, drudzy—po stronie apostołów. ");
INSERT INTO polsz_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Gdy jednak Paweł i Barnaba dowiedzieli się, że niektórzy poganie oraz Żydzi, wraz z miejscowymi przywódcami, chcą ich znieważyć a potem—obrzucając kamieniami—zabić, ");
INSERT INTO polsz_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","szybko uciekli do miast Likaonii: do Listry i Derbe, ");
INSERT INTO polsz_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","gdzie dalej głosili dobrą nowinę. ");
INSERT INTO polsz_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","W Listrze mieszkał pewien człowiek, który od urodzenia miał sparaliżowane nogi i nie mógł chodzić. ");
INSERT INTO polsz_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Bardzo dokładnie słuchał słów Pawła. Ten zaś zauważył go i dostrzegł w nim wiarę potrzebną do uzdrowienia. ");
INSERT INTO polsz_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Zawołał więc do niego: —Wstań na nogi! Chory zaś dosłownie podskoczył i natychmiast zaczął chodzić. ");
INSERT INTO polsz_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Wtedy zgromadzone tłumy, na widok czynu Pawła, zaczęły krzyczeć po likaońsku: —Pod postacią tych ludzi nawiedzili nas bogowie! ");
INSERT INTO polsz_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabę uznali za Zeusa, a Pawła za Hermesa, bo to on głównie przemawiał. ");
INSERT INTO polsz_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Wtedy miejscowy kapłan świątyni Zeusa, położonej na peryferiach Listry, przyprowadził do bram miasta woły ustrojone girlandami kwiatów, aby razem z ludem złożyć je im w ofierze. ");
INSERT INTO polsz_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Gdy Barnaba i Paweł spostrzegli, co się dzieje, na znak oburzenia rozdarli ubrania i wbiegli w tłum, krzycząc: ");
INSERT INTO polsz_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Ludzie! Co robicie?! Tak samo jak wy, jesteśmy tylko ludźmi! Przynieśliśmy wam dobrą nowinę, abyście odwrócili się od tych martwych bożków i zwrócili się ku żywemu Bogu, który stworzył niebo, ziemię, morze oraz wszystko, co w nich jest. ");
INSERT INTO polsz_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","W przeszłości przyzwalał On wszystkim narodom chodzić własnymi drogami, ");
INSERT INTO polsz_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ale nigdy nie przestał dawać o sobie znać. Zawsze robił coś dobrego: zsyłał deszcze i dobre plony, dawał wam żywność i napełniał serca radością. ");
INSERT INTO polsz_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Z trudem udało im się powstrzymać lud od złożenia im ofiary. ");
INSERT INTO polsz_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Wkrótce jednak przybyli z Antiochii i Ikonium żydowscy przywódcy, którzy podburzyli tłumy. Wtedy obrzucono Pawła kamieniami i wywleczono go za miasto, sądząc, że nie żyje. ");
INSERT INTO polsz_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Lecz gdy otoczyli go wierzący, podniósł się i powrócił do miasta. A następnego dnia udał się wraz z Barnabą do Derbe. ");
INSERT INTO polsz_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tam głosili dobrą nowinę i pozyskali wielu uczniów, po czym wrócili do Listry, Ikonium i Antiochii, ");
INSERT INTO polsz_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","gdzie umacniali uczniów w wierze i zachęcali ich do ufania Jezusowi. Przypominali im też, że droga do królestwa Bożego prowadzi przez wiele cierpień. ");
INSERT INTO polsz_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Wyznaczyli tam również starszych, którzy mieli być przywódcami poszczególnych kościołów, a powstrzymując się od posiłków i modląc się, powierzyli ich opiece Pana, któremu uwierzyli. ");
INSERT INTO polsz_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Potem przez Pizydię przybyli z powrotem do Pamfilii. ");
INSERT INTO polsz_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Dzielili się słowem Bożym w Perge, po czym udali się do Attalii. ");
INSERT INTO polsz_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Stamtąd zaś popłynęli do Antiochii, w której rozpoczęli to dzieło, powierzone im dzięki łasce Boga. ");
INSERT INTO polsz_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Gdy się tam znaleźli, zebrali wszystkich wierzących i opowiedzieli im o tym, co Bóg uczynił przez nich i jak otworzył poganom drzwi do wiary. ");
INSERT INTO polsz_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","I pozostali z tamtejszymi wierzącymi przez dłuższy czas. ");
INSERT INTO polsz_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tymczasem przyszło z Judei kilku ludzi, którzy zaczęli nauczać wierzących: „Jeśli nie poddacie się obrzędowi obrzezania, nakazanemu przez Mojżesza, nie będziecie zbawieni”. ");
INSERT INTO polsz_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Początkowo Paweł i Barnaba prowadzili z nimi długie dyskusje. W końcu jednak postanowiono, że razem z kilkoma innymi wierzącymi wyruszą do Jerozolimy, aby całą sprawę przedstawić do rozstrzygnięcia apostołom i starszym kościoła. ");
INSERT INTO polsz_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Wysłani przez kościół, szli przez Fenicję i Samarię, odwiedzając po drodze wierzących. Słysząc od Pawła i Barnaby o tym, że również poganie zwracają się do Boga, wszyscy wierzący odczuwali wielką radość. ");
INSERT INTO polsz_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","W Jerozolimie spotkali się z apostołami i starszymi kościoła i przekazali im relację o tym, co Bóg uczynił przez nich wśród pogan. ");
INSERT INTO polsz_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Wtedy kilku wierzących, którzy należeli do ugrupowania faryzeuszy, oświadczyło, że nawróceni poganie muszą zostać obrzezani i zacząć przestrzegać Prawa Mojżesza. ");
INSERT INTO polsz_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Apostołowie i starsi zebrali się więc ponownie, aby rozpatrzyć ten problem. ");
INSERT INTO polsz_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Po długiej dyskusji głos zabrał Piotr: —Przyjaciele! Wiecie dobrze, że już dawno Bóg wybrał mnie spośród was, abym mógł przekazać dobrą nowinę także poganom. ");
INSERT INTO polsz_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Bóg, który zna ludzkie serca, okazał im przychylność, dając im, podobnie jak nam, Ducha Świętego. ");
INSERT INTO polsz_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nie uczynił między nami żadnej różnicy i przez wiarę oczyścił ich serca. ");
INSERT INTO polsz_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Dlaczego więc teraz macie zamiar poprawiać Boga i nakładać na nawróconych pogan ciężar, którego ani nasi ojcowie, ani my sami nie potrafiliśmy udźwignąć? ");
INSERT INTO polsz_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Przecież wierzymy, że zarówno oni, jak i my, jesteśmy zbawieni tylko dzięki łasce Jezusa, naszego Pana. ");
INSERT INTO polsz_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Wtedy wszyscy zamilkli i słuchali opowiadania Barnaby i Pawła o cudach, których Bóg dokonał przez nich wśród pogan. ");
INSERT INTO polsz_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Gdy skończyli, głos zabrał Jakub: —Posłuchajcie mnie, przyjaciele! ");
INSERT INTO polsz_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Szymon Piotr opowiedział nam, jak Bóg wybrał pogan do swojego kościoła. ");
INSERT INTO polsz_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Zgadzają się z tym następujące słowa proroków: ");
INSERT INTO polsz_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","„Potem wrócę i odbuduję zniszczony dom Dawida, ");
INSERT INTO polsz_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","aby także poganie mogli znaleźć Pana —wszyscy ci, których uznałem za swoich. Tak mówi Pan, który dokonuje tego, ");
INSERT INTO polsz_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","co zaplanował na samym początku”. ");
INSERT INTO polsz_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Dlatego sądzę, że nie powinniśmy przeszkadzać poganom przychodzącym do Boga—mówił dalej Jakub. ");
INSERT INTO polsz_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","—Napiszmy im tylko, aby powstrzymali się od spożywania pokarmów ofiarowanych bożkom, mięsa uduszonych zwierząt i krwi oraz aby unikali rozwiązłości seksualnej. ");
INSERT INTO polsz_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bo od wieków we wszystkich miastach są synagogi, w których co szabat zbierają się Żydzi przestrzegający tych nakazów. ");
INSERT INTO polsz_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Wtedy apostołowie wraz ze starszymi i całym kościołem postanowili wybrać kilku wierzących i wysłać ich z Pawłem i Barnabą do Antiochii. Wybrano więc Judę, zwanego Barsabą, i Sylasa—cieszących się dużym uznaniem wśród wierzących ");
INSERT INTO polsz_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","—i przekazano przez nich list tej treści: „Apostołowie i starsi z Jerozolimy pozdrawiają wierzących w Antiochii, Syrii i Cylicji! ");
INSERT INTO polsz_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Dowiedzieliśmy się, że niektórzy wierzący z Judei—bez naszej wiedzy—siali wśród was niepokój i wzbudzali wątpliwości. ");
INSERT INTO polsz_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Dlatego właśnie jednomyślnie postanowiliśmy wybrać dwóch mężczyzn i posłać ich do was, razem z naszymi bliskim przyjaciółmi—Barnabą i Pawłem, ");
INSERT INTO polsz_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","którzy dla naszego Pana ryzykowali życie. ");
INSERT INTO polsz_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Wysyłamy więc do was Judę i Sylasa, którzy osobiście potwierdzą wam nasze stanowisko w tej sprawie. ");
INSERT INTO polsz_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Postanowiliśmy bowiem—Duch Święty i my—nie obarczać was dodatkowymi obowiązkami oprócz tego, co niezbędne. ");
INSERT INTO polsz_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Powstrzymajcie się od spożywania pokarmów ofiarowanych bożkom, mięsa uduszonych zwierząt i krwi oraz unikajcie rozwiązłości seksualnej. Dobrze zrobicie, jeśli całkowicie zerwiecie z tym wszystkim. Pozdrawiamy was”. ");
INSERT INTO polsz_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Posłańcy udali się zatem do Antiochii, gdzie zwołali wszystkich wierzących i wręczyli im list. ");
INSERT INTO polsz_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","A gdy go przeczytano, zapanowała wielka radość. ");
INSERT INTO polsz_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Wtedy Juda i Sylas, którzy byli prorokami, umacniali ich wiarę słowami pełnymi zachęty. ");
INSERT INTO polsz_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Spędzili z nimi jeszcze jakiś czas, po czym pożegnali ich i wrócili do Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","35","Paweł i Barnaba pozostali zaś w Antiochii, aby wraz z innymi głosić słowo Pana i nauczać. ");
INSERT INTO polsz_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Jakiś czas później Paweł zaproponował Barnabie: —Odwiedźmy wszystkie miasta, w których głosiliśmy słowo Boże i sprawdźmy, jak miewają się wierzący. ");
INSERT INTO polsz_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba zasugerował, aby zabrać również Jana, zwanego Markiem. ");
INSERT INTO polsz_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Jednak Paweł nie chciał się na to zgodzić, ponieważ Marek, podczas poprzedniej wyprawy, odszedł od nich w Pamfilii i nie brał udziału w ich pracy. ");
INSERT INTO polsz_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Powstał więc konflikt. Ostatecznie apostołowie rozdzielili się. Barnaba z Markiem odpłynęli na Cypr. ");
INSERT INTO polsz_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paweł natomiast wziął ze sobą Sylasa i—powierzony przez wierzących opiece Pana ");
INSERT INTO polsz_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","—przemierzał Syrię i Cylicję, dodając otuchy tamtejszym kościołom. ");
INSERT INTO polsz_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Najpierw udał się do Derbe i Listry. Spotkał tam pewnego ucznia imieniem Tymoteusz, będącego synem Żydówki, która uwierzyła w Jezusa, oraz ojca poganina. ");
INSERT INTO polsz_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Wierzący z Listry i Ikonium wydawali mu dobrą opinię. ");
INSERT INTO polsz_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paweł zaproponował mu więc, aby przyłączył się niego w podróży. Najpierw jednak poddał go obrzędowi obrzezania—ze względu na Żydów zamieszkujących te okolice. Wszyscy bowiem wiedzieli, że jego ojciec był poganinem. ");
INSERT INTO polsz_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Odwiedzając miasta, zachęcali wierzących do przestrzegania postanowień apostołów i starszych z Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","A kościoły z dnia na dzień wzrastały liczebnie i coraz bardziej wierzyły Panu. ");
INSERT INTO polsz_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Następnie podróżowali przez Frygię i Galację, gdyż tym razem Duch Święty nie pozwolił im nauczać w Azji. ");
INSERT INTO polsz_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Szli wzdłuż granicy Myzji i chcieli skierować się do prowincji zwanej Bitynią, lecz Duch Jezusa znowu na to nie pozwolił. ");
INSERT INTO polsz_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Poszli więc przez Myzję do Troady. ");
INSERT INTO polsz_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","W nocy Paweł miał widzenie. Ujrzał Macedończyka, który stał i błagał: „Przybądź do Macedonii i pomóż nam!”. ");
INSERT INTO polsz_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","To sprawiło, że postanowiliśmy udać się do Macedonii. Uznaliśmy bowiem, że to sam Bóg posyła nas, abyśmy głosili tam dobrą nowinę. ");
INSERT INTO polsz_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Z Troady popłynęliśmy prosto do Samotraki, a następnego dnia—do Neapolis. ");
INSERT INTO polsz_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","W końcu dotarliśmy do Filippi, miasta będącego stolicą tej części Macedonii i rzymską kolonią. Tam zatrzymaliśmy się na kilka dni. ");
INSERT INTO polsz_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","W szabat udaliśmy się za miasto, nad rzekę, gdzie—jak sądziliśmy—ludzie zbierają się na modlitwę. Usiedliśmy i rozmawialiśmy z zebranymi tam kobietami. ");
INSERT INTO polsz_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Przysłuchiwała się nam niejaka Lidia z Tiatyry, która handlowała purpurą. Znała już Boga, a Pan sprawił, że chętnie słuchała tego, o czym mówił Paweł. ");
INSERT INTO polsz_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Została ochrzczona razem ze swoimi domownikami, a potem zaprosiła nas do siebie. —Jeśli wierzycie w moją wierność Panu—powiedziała—przyjdźcie i zamieszkajcie w moim domu. Zgodziliśmy się więc i zatrzymaliśmy się u niej. ");
INSERT INTO polsz_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Pewnego dnia, w drodze na miejsce modlitwy, natknęliśmy się na niewolnicę, opanowaną przez demona. Przynosiła ona swoim właścicielom niezłe dochody, bo przepowiadała przyszłość. ");
INSERT INTO polsz_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Szła za Pawłem i za nami, krzycząc: —Ci ludzie to słudzy Najwyższego Boga! Oni głoszą wam drogę do zbawienia! ");
INSERT INTO polsz_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Powtarzało się to przez wiele dni. W końcu Paweł, zmęczony tą sytuacją, odwrócił się i rzekł do demona: —W imieniu Jezusa Chrystusa rozkazuję ci: Wyjdź z niej! Wówczas demon natychmiast ją opuścił. ");
INSERT INTO polsz_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Gdy jednak właściciele niewolnicy zobaczyli, że przepadła ich nadzieja na dalsze dochody, schwytali Pawła oraz Sylasa i zaciągnęli ich na rynek, do władz miasta. ");
INSERT INTO polsz_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Następnie postawili ich przed sędziami i powiedzieli: —Ci ludzie zakłócają porządek publiczny w naszym mieście! ");
INSERT INTO polsz_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Są Żydami i propagują styl życia, którego nam, Rzymianom, nie wolno przyjmować! ");
INSERT INTO polsz_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Cały tłum zwrócił się wtedy przeciwko Pawłowi i Sylasowi, a sędziowie nakazali zedrzeć z nich ubranie i ubiczować ich. ");
INSERT INTO polsz_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Gdy już im wymierzono karę, wtrącili ich do więzienia, a strażnikowi nakazali dobrze ich strzec. ");
INSERT INTO polsz_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Słysząc taki rozkaz, strażnik umieścił ich w celi mieszczącej się w środku budynku, a ich nogi zakuł w dyby. ");
INSERT INTO polsz_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Około północy Paweł i Sylas wielbili Boga modlitwą i pieśniami, a wszyscy współwięźniowie przysłuchiwali się im. ");
INSERT INTO polsz_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nagle powstało tak wielkie trzęsienie ziemi, że zadrżały fundamenty więzienia. Wszystkie drzwi same się otworzyły, a kajdany wszystkich więźniów rozerwały się. ");
INSERT INTO polsz_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Obudziło to również strażnika. Gdy zobaczył otwarte bramy, uznał, że więźniowie uciekli, i z przerażenia chwycił miecz, aby się zabić. ");
INSERT INTO polsz_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Wtedy Paweł głośno zawołał: —Nie rób sobie krzywdy! Wszyscy tu jesteśmy! ");
INSERT INTO polsz_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Strażnik zażądał światła i drżąc ze strachu padł do nóg Pawła i Sylasa. ");
INSERT INTO polsz_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Wyprowadził ich z celi na zewnątrz i zapytał: —Panowie! Co mam robić, żeby osiągnąć zbawienie? ");
INSERT INTO polsz_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","—Uwierz w Jezusa jako Pana—odpowiedzieli—a będziesz zbawiony ty i cały twój dom. ");
INSERT INTO polsz_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","I przedstawili jemu i wszystkim jego domownikom dobrą nowinę. ");
INSERT INTO polsz_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Zaraz też strażnik zaprosił ich do siebie i opatrzył rany po biczowaniu, a następnie dał się ochrzcić wraz z całą rodziną. ");
INSERT INTO polsz_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Następnie ugościł ich w swoim domu, razem ze wszystkimi ciesząc się z tego, że uwierzył Bogu. ");
INSERT INTO polsz_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Następnego dnia sędziowie wysłali do strażnika żołnierzy z rozkazem: —Uwolnij tych ludzi! ");
INSERT INTO polsz_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","—Sędziowie wydali rozkaz, żeby was uwolnić—powiedział strażnik do Pawła. —Idźcie więc w pokoju. ");
INSERT INTO polsz_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","—O nie!—zaprotestował Paweł. —Nie zważając na to, że jesteśmy rzymskimi obywatelami, bez wyroku kazali nas ubiczować i wtrącić do więzienia. A teraz ukradkiem próbują się nas pozbyć? Niech sami przyjdą i nas uwolnią. ");
INSERT INTO polsz_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Żołnierze przekazali tę odpowiedź sędziom. Ci zaś przestraszyli się, słysząc, że apostołowie mają rzymskie obywatelstwo. ");
INSERT INTO polsz_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Przyszli więc osobiście i prosili ich o opuszczenie więzienia, a następnie błagali ich, aby wyjechali z miasta. ");
INSERT INTO polsz_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paweł i Sylas, po wyjściu z więzienia, udali się jednak do domu Lidii. Spotkali się tam z wierzącymi, dodali im otuchy i dopiero wtedy opuścili miasto. ");
INSERT INTO polsz_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Idąc dalej, minęli miasta Amfipolis oraz Apolonię i dotarli do Tesaloniki, gdzie znajdowała się żydowska synagoga. ");
INSERT INTO polsz_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Zgodnie ze swoim zwyczajem, Paweł chodził do niej przez kolejne trzy szabaty i przedstawiał zgromadzonym znaczenie Pisma. ");
INSERT INTO polsz_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Dowodził, że Mesjasz miał cierpieć i zmartwychwstać. Mówił: —Tym Mesjaszem jest Jezus, którego wam głoszę! ");
INSERT INTO polsz_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Niektórzy słuchacze, w tym również wielu pogan, którzy mieli respekt dla Boga, i niemało wpływowych kobiet, dało się przekonać i przyłączyło się do Pawła i Sylasa. ");
INSERT INTO polsz_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ale żydowscy przywódcy, kierowani zazdrością, namówili kilku awanturników, aby wywołali zbiegowisko i wszczęli w mieście rozruchy. Otoczyli oni dom Jazona i szukali apostołów, chcąc ich postawić przed zgromadzeniem. ");
INSERT INTO polsz_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ponieważ ich jednak nie znaleźli, zaciągnęli Jazona i kilku wierzących do władz miasta. —Ci ludzie sieją zamęt na całym świecie!—krzyczeli. —A teraz przyszli do naszego miasta ");
INSERT INTO polsz_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","i Jazon przyjął ich do swojego domu. Oni przeciwstawiają się decyzjom cezara, bo uważają za króla jakiegoś Jezusa! ");
INSERT INTO polsz_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Oskarżenia te zaniepokoiły zarówno zebranych, jak i władze. ");
INSERT INTO polsz_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ostatecznie jednak zwolnili ich, ale dopiero po otrzymaniu sporej kaucji od Jazona i pozostałych. ");
INSERT INTO polsz_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nocą wierzący szybko wyprawili Pawła i Sylasa do Berei. Ci, jak zwykle, skierowali się do synagogi. ");
INSERT INTO polsz_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tamtejsi mieszkańcy byli bardziej otwarci niż Tesaloniczanie. Całym sercem przyjęli słowo Boże i codziennie sprawdzali w Piśmie, czy to, co słyszeli, jest prawdą. ");
INSERT INTO polsz_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Wielu z nich uwierzyło, w tym również spore grono wpływowych kobiet oraz mężczyzn, będących poganami. ");
INSERT INTO polsz_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Gdy jednak żydowscy przywódcy z Tesaloniki dowiedzieli się, że Paweł przebywa teraz w Berei i naucza słowa Bożego, przyszli tam i wywołali kolejne rozruchy. ");
INSERT INTO polsz_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Wierzący natychmiast wysłali Pawła na wybrzeże. Sylas i Tymoteusz pozostali zaś na miejscu. ");
INSERT INTO polsz_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ci, którzy towarzyszyli Pawłowi, odprowadzili go aż do Aten, po czym wrócili z poleceniem dla Sylasa i Tymoteusza, aby oni również szybko dołączyli do Pawła. ");
INSERT INTO polsz_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Czekając na nich w Atenach, Paweł był oburzony, widząc miasto pełne bożków. ");
INSERT INTO polsz_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","W synagodze spotykał się i rozmawiał z Żydami oraz poganami mającymi respekt dla Boga. Codziennie też dyskutował z różnymi ludźmi na rynku. ");
INSERT INTO polsz_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Byli wśród nich filozofowie ze szkoły epikurejskiej i stoickiej, którzy rozmawiali między sobą: —O czym ten gaduła chce nam powiedzieć? —Chyba głosi jakieś nowe bóstwa—mówili drudzy, Paweł mówił bowiem o Jezusie i zmartwychwstaniu. ");
INSERT INTO polsz_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Zabrali więc go na Areopag i spytali: —Możesz nam wyjaśnić, jaką to nową religię głosisz? ");
INSERT INTO polsz_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Wkładasz nam bowiem do głowy jakieś niesłychane historie. ");
INSERT INTO polsz_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","A wszyscy Ateńczycy i przybysze poświęcają większość czasu na dyskusje i słuchanie nowych wieści. ");
INSERT INTO polsz_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paweł stanął więc pośrodku Areopagu i przemówił: —Ateńczycy! Zauważyłem, że jesteście bardzo religijni. ");
INSERT INTO polsz_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Spacerując po mieście i oglądając wasze ołtarze, natknąłem się nawet na ołtarz poświęcony „Nieznanemu Bogu”. Właśnie o tym Bogu, którego czcicie nie znając Go, chcę wam dziś opowiedzieć. ");
INSERT INTO polsz_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","On stworzył cały świat i wszystko, co na nim istnieje. Jest Panem nieba i ziemi, więc nie mieszka w ziemskich świątyniach! ");
INSERT INTO polsz_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","On nie potrzebuje żadnej pomocy od ludzi, bo to On sam daje nam życie, sprawia, że oddychamy, i obdarza nas wszystkim, czego potrzebujemy. ");
INSERT INTO polsz_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","To dzięki Niemu wszyscy ludzie na świecie wzięli początek od jednego człowieka. On też rozmieścił na całej ziemi narody, wyznaczając im czas i miejsce. ");
INSERT INTO polsz_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Uczynił tak, aby ludzie szukali Go, choćby po omacku, i znajdowali—bo On jest blisko każdego z nas. ");
INSERT INTO polsz_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","W Nim bowiem istniejemy, żyjemy i poruszamy się! Jak to ujął jeden z waszych poetów: „Jesteśmy z Jego rodu”. ");
INSERT INTO polsz_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","A skoro jesteśmy z rodu Boga, nie powinniśmy sądzić, że jest On podobny do bożka ze złota, srebra lub kamienia, wykonanego według ludzkiego pomysłu. ");
INSERT INTO polsz_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Bóg dotychczas znosił ludzką niewiedzę, ale teraz wzywa wszystkich do opamiętania się, ");
INSERT INTO polsz_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ponieważ wyznaczył już dzień, w którym sprawiedliwie osądzi cały świat. Uczyni to przez Człowieka, którego wybrał i uwiarygodnił przez wskrzeszenie Go z martwych. ");
INSERT INTO polsz_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Gdy zebrani usłyszeli o zmartwychwstaniu umarłych, jedni zaczęli się z tego śmiać, a inni powiedzieli: —Wiesz, chyba jednak posłuchamy cię innym razem. ");
INSERT INTO polsz_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Wtedy Paweł opuścił Areopag. ");
INSERT INTO polsz_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lecz kilka osób uwierzyło i przyłączyło się do niego. Wśród nich byli: Dionizy, członek rady Areopagu, oraz kobieta imieniem Damaris. ");
INSERT INTO polsz_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Potem Paweł opuścił Ateny i udał się do Koryntu. ");
INSERT INTO polsz_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tam spotkał Akwilę, Żyda rodem z Pontu, który wraz z żoną Pryscyllą przybył niedawno z Italii. Nakazem cezara Klaudiusza wysiedlano bowiem z Rzymu wszystkich Żydów. Paweł odwiedził Akwilę i Pryscyllę, ");
INSERT INTO polsz_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","a ponieważ, podobnie jak oni, zajmował się wyrobem namiotów, zamieszkał u nich i zaczął razem z nimi pracować. ");
INSERT INTO polsz_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Każdy szabat spędzał w synagodze, gdzie nauczał i przekonywał zarówno Żydów, jak i Greków. ");
INSERT INTO polsz_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Gdy Sylas i Tymoteusz przybyli z Macedonii, Paweł poświęcił się głównie nauczaniu i udowadniał Żydom, że Jezus jest Mesjaszem. ");
INSERT INTO polsz_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ponieważ jednak byli mu przeciwni i lekceważyli Jezusa, strząsnął kurz z płaszcza i powiedział: —Sami jesteście sobie winni. Spełniłem swój obowiązek. Od tej chwili będę nauczał pogan. ");
INSERT INTO polsz_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Odszedł stamtąd i udał się do domu niejakiego Tycjusza Justusa, człowieka bardzo pobożnego, który mieszkał obok synagogi. ");
INSERT INTO polsz_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kryspus, przełożony synagogi, uwierzył w Pana wraz z całym domem. Także wielu innych Koryntian uwierzyło i przyjęło chrzest. ");
INSERT INTO polsz_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","W nocy Paweł miał widzenie, w którym Pan powiedział: —Nie obawiaj się! Nadal przemawiaj i nie poddawaj się! ");
INSERT INTO polsz_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Jestem z tobą i nikt nie zrobi ci krzywdy. Wielu ludzi w tym mieście należy do Mnie. ");
INSERT INTO polsz_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paweł pozostał tam więc jeszcze półtora roku, nauczając słowa Bożego. ");
INSERT INTO polsz_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gdy zarządcą Achai był Gallio, przywódcy żydowscy zorganizowali wspólną akcję przeciwko Pawłowi i postawili go przed sądem. ");
INSERT INTO polsz_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","—Ten człowiek namawia ludzi, aby czcili Boga niezgodnie z Prawem Mojżesza—oskarżali go. ");
INSERT INTO polsz_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paweł właśnie chciał coś opowiedzieć, gdy Gallio zwrócił się do nich: —Słuchajcie, Żydzi! Gdyby tu chodziło o jakieś przestępstwo, oszustwo czy inne bezprawie, z pewnością dokładnie bym was wysłuchał. ");
INSERT INTO polsz_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ale skoro jest to spór o słowa, imiona i o wasze Prawo, radźcie sobie sami. Ja nie będę się tym zajmował! ");
INSERT INTO polsz_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","I wyprosił ich z sądu. ");
INSERT INTO polsz_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Wtedy tłum rzucił się na nowego przełożonego synagogi, Sostenesa, i bił go tuż przed budynkiem sądu. Ale Gallio nie zwracał na to najmniejszej uwagi. ");
INSERT INTO polsz_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paweł dość długo pozostał w Koryncie, po czym pożegnał wierzących i wraz z Pryscyllą i Akwilą popłynął do Syrii. W Kenchrach, zgodnie ze złożoną wcześniej obietnicą, ogolił głowę. ");
INSERT INTO polsz_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Stamtąd udali się do Efezu. Zostawił towarzyszy na statku, a sam wszedł do synagogi i nauczał Żydów. ");
INSERT INTO polsz_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Prosili go, żeby został na dłużej, lecz odmówił. ");
INSERT INTO polsz_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","—Jeśli Bóg pozwoli, wrócę do was—powiedział, po czym pożegnał się i odpłynął z Efezu. ");
INSERT INTO polsz_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Następnie odwiedził kościół w Cezarei. Przekazał wierzącym pozdrowienia i udał się do Antiochii. ");
INSERT INTO polsz_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tam zatrzymał się na pewien czas. Potem jednak znowu wyruszył w podróż, przemierzając Galację i Frygię, gdzie dodawał otuchy wierzącym. ");
INSERT INTO polsz_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tymczasem do Efezu przybył niejaki Apollos, Żyd z Aleksandrii, który był dobrym mówcą i doskonale znał Pisma. ");
INSERT INTO polsz_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Sporo już wiedział o „drodze Pana” i z wielkim zapałem przemawiał na temat Jezusa, choć znał tylko chrzest Jana Chrzciciela. ");
INSERT INTO polsz_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apollos zaczął odważnie nauczać w synagodze w Efezie. Gdy Pryscylla i Akwila usłyszeli go, zabrali go do siebie i dokładnie przedstawili mu „drogę Boga”. ");
INSERT INTO polsz_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","A ponieważ chciał odwiedzić Achaję, wierzący napisali mu list polecający, aby go tam przyjęto. Po przybyciu, bardzo pomógł wszystkim, którzy zaufali łasce Pana. ");
INSERT INTO polsz_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Z odwagą dyskutował z tamtejszymi Żydami, publicznie wykazując na podstawie Pisma, że Jezus naprawdę jest Mesjaszem. ");
INSERT INTO polsz_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Podczas gdy Apollos przebywał w Koryncie, Paweł podróżował przez okoliczne wzgórza i przybył do Efezu, gdzie natknął się na grupę wierzących. ");
INSERT INTO polsz_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","—Czy otrzymaliście Ducha Świętego, gdy uwierzyliście?—zapytał ich. —Nawet nie słyszeliśmy o Duchu Świętym!—odpowiedzieli mu. ");
INSERT INTO polsz_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","—To jaki chrzest przyjęliście? —Chrzest Jana Chrzciciela—powiedzieli. ");
INSERT INTO polsz_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","—Jan zanurzał ludzi w wodzie na znak opamiętania, wzywając ich, aby uwierzyli w Tego, który przyjdzie po nim, czyli w Jezusa—wyjaśnił Paweł. ");
INSERT INTO polsz_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Gdy tylko o tym usłyszeli, zaraz dali się zanurzyć w imię Jezusa. ");
INSERT INTO polsz_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paweł położył na nich ręce, a wtedy zstąpił na nich Duch Święty i zaczęli mówić obcymi językami i prorokować. ");
INSERT INTO polsz_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","A grupa ta liczyła około dwunastu mężczyzn. ");
INSERT INTO polsz_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Następnie Paweł poszedł do synagogi i przez trzy miesiące śmiało nauczał w niej o królestwie Bożym. ");
INSERT INTO polsz_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ale niektórzy stawiali opór. Zamiast się opamiętać, publicznie wyśmiewali drogę Pana. Paweł odszedł więc od nich, zabierając ze sobą wierzących. Odtąd codziennie przemawiał w szkole Tyrannosa. ");
INSERT INTO polsz_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Trwało to dwa lata, aż wszyscy mieszkańcy prowincji Azja, zarówno Żydzi, jak i poganie, usłyszeli słowo Pana. ");
INSERT INTO polsz_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","A Bóg dokonywał przez Pawła niezwykłych cudów. ");
INSERT INTO polsz_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nawet chusty i części jego odzieży kładzione na chorych powodowały uzdrowienie lub uwolnienie od demonów. ");
INSERT INTO polsz_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Tymczasem jacyś wędrowni żydowscy egzorcyści próbowali uwalniać ludzi od demonów, powołując się na imię Jezusa. Mówili: —Rozkazuję ci, demonie, przez Jezusa, którego głosi Paweł! ");
INSERT INTO polsz_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Robiło to siedmiu synów Skewasa, żydowskiego najwyższego kapłana. ");
INSERT INTO polsz_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Jednak demon tak im odpowiedział: —Znam Jezusa i znam Pawła, a wy, kim jesteście? ");
INSERT INTO polsz_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","I człowiek opanowany przez demona rzucił się na nich. Pobił ich tak dotkliwie, że nadzy i poranieni uciekli z domu, w którym to miało miejsce. ");
INSERT INTO polsz_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Wieść o tym szybko rozeszła się wśród wszystkich Żydów i pogan, żyjących w Efezie. Ogarnął ich lęk i z szacunkiem odnosili się do imienia Jezusa. ");
INSERT INTO polsz_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Wielu zaś nowych wierzących wyznawało publicznie swoje złe czyny. ");
INSERT INTO polsz_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Spora grupa tych, którzy uprawiali czarną magię, przyniosła swoje tajemne księgi i publicznie je spaliła, mimo że miały one znaczną wartość. Oszacowano, że na ich zakup trzeba było przeznaczyć wynagrodzenie za wiele miesięcy ciężkiej pracy. ");
INSERT INTO polsz_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Przykład ten pokazuje jak bardzo rozszerzał się wpływ słowa Bożego i jak potężne było jego oddziaływanie na ludzi. ");
INSERT INTO polsz_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Po tych wydarzeniach Paweł postanowił, że odwiedzi Macedonię i Achaję, a następnie uda się do Jerozolimy. Dodał też: —Potem, gdy już tam tym przybędę, muszę jeszcze odwiedzić Rzym. ");
INSERT INTO polsz_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Następnie wysłał swoich pomocników—Tymoteusza i Erasta—do Macedonii, sam zaś przez pewien czas pozostał jeszcze w prowincji Azja. ");
INSERT INTO polsz_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Właśnie w tym czasie powstały w Efezie ogromne zamieszki spowodowane „drogą Pana”. ");
INSERT INTO polsz_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Niejaki Demetriusz zatrudniał wielu rzemieślników przy wyrobie srebrnych miniaturek świątyni bogini Artemidy. ");
INSERT INTO polsz_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Zwołał więc pracowników oraz innych rzemieślników tej branży i powiedział: —Słuchajcie! Nasz fach przynosi nam duże zyski. ");
INSERT INTO polsz_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Sami jednak widzieliście i słyszeliście, że nie tylko w Efezie, ale i w całej naszej prowincji niejaki Paweł przewraca ludziom w głowach. Twierdzi bowiem, że bogowie nie mogą być dziełem ludzkich rąk. ");
INSERT INTO polsz_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Jego działalność zagraża naszym interesom. Co więcej, może doprowadzić do tego, że świątynia wielkiej bogini Artemidy zostanie zlekceważona, a sama Artemida zostanie pozbawiona czci, jaką oddaje jej prowincja Azja i cały świat. ");
INSERT INTO polsz_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Słysząc to, zebrani wpadli w gniew i zaczęli wołać: —Wielka Artemida Efeska! ");
INSERT INTO polsz_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Wkrótce rozruchy ogarnęły całe miasto. Tłum porwał Gajusa i Arystarcha, dwóch towarzyszy podróży Pawła, i zaciągnął ich do teatru, było to bowiem główne miejsce spotkań mieszkańców miasta. ");
INSERT INTO polsz_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Chciał tam pójść i Paweł, ale wierzący nie pozwolili mu. ");
INSERT INTO polsz_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Również zaprzyjaźnieni z nim przedstawiciele władz prowincji prosili go przez posłańców, aby nie ryzykował życia i by pozostał w domu. ");
INSERT INTO polsz_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","A każdy z zebranych krzyczał coś innego. Panowało ogromne zamieszanie, a większość ludzi w ogóle nawet nie wiedziała, po co się zebrano. ");
INSERT INTO polsz_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Kilku Żydów wyciągnęło z tłumu Aleksandra i wypchnęło go naprzód. On dał znak ręką, prosząc o ciszę i możliwość obrony. ");
INSERT INTO polsz_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Gdy jednak ludzie zobaczyli, że jest Żydem, wszyscy zaczęli krzyczeć: —Wielka Artemida Efeska!—i trwało to prawie dwie godziny. ");
INSERT INTO polsz_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Wreszcie sekretarzowi rady miasta udało się uciszyć tłum. —Obywatele Efezu!—zaczął. —Czy istnieje jeszcze ktoś, kto nie wiedziałby, że Efez stoi na straży świątyni wielkiej Artemidy, której posąg zesłał nam z nieba sam Zeus? ");
INSERT INTO polsz_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Skoro jest to oczywiste, zachowajmy spokój i nie czyńmy niczego pochopnie. ");
INSERT INTO polsz_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ludzie, których tu przywlekliście, ani nie ukradli niczego w świątyni Artemidy, ani nie obrazili bogini. ");
INSERT INTO polsz_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","A jeśli Demetriusz i inni rzemieślnicy mają przeciw nim jakieś zarzuty, niech zgłoszą się do sądu i wniosą stosowne oskarżenie. ");
INSERT INTO polsz_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Jeśli zaś są jakieś inne skargi, rada miasta rozpatrzy je na najbliższym posiedzeniu. ");
INSERT INTO polsz_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Z powodu dzisiejszych wydarzeń grozi nam jednak oskarżenie o wszczynanie rozruchów. Jak bowiem wyjaśnimy powód naszego dzisiejszego zbiegowiska? ");
INSERT INTO polsz_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","I tymi słowami rozwiązał zgromadzenie. ");
INSERT INTO polsz_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Po ustaniu zamieszek, Paweł zwołał wierzących. Żegnając ich, dodał im otuchy i wyruszył do Macedonii. ");
INSERT INTO polsz_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Obszedł okoliczne tereny, pokrzepiając tamtejszych uczniów Jezusa, a następnie udał się do Grecji. ");
INSERT INTO polsz_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Spędził tam trzy miesiące i chciał popłynąć do Syrii. Gdy jednak dowiedział się o spisku żydowskich przywódców przeciw niemu, postanowił wrócić przez Macedonię. ");
INSERT INTO polsz_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Towarzyszyli mu: Sopater—syn Pyrrusa z Berei, Arystarch i Sekundus—z Tesaloniki, Gajus—z Derbe, oraz Tymoteusz, Tychik i Trofim—z prowincji Azja. ");
INSERT INTO polsz_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Oni to wyruszyli pierwsi i czekali na nas w Troadzie. ");
INSERT INTO polsz_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","My zaś, po święcie Paschy, odpłynęliśmy z Filippi i pięć dni później byliśmy już z nimi w Troadzie, gdzie spędziliśmy tydzień. ");
INSERT INTO polsz_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","W niedzielę zebraliśmy się wszyscy na łamanie chleba. Paweł przemawiał, a ponieważ następnego dnia odjeżdżał, przeciągnął swoją mowę aż do północy. ");
INSERT INTO polsz_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Pokój na górze, gdzie się zebraliśmy, oświetlony był wieloma lampami. ");
INSERT INTO polsz_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","W trakcie długiej mowy Pawła, pewien chłopiec imieniem Eutych, siedzący na oknie, zasnął, spadł z trzeciego piętra i zabił się. ");
INSERT INTO polsz_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paweł szybko zszedł na dół i objął go. —Nie martwcie się!—powiedział. —Będzie żył. ");
INSERT INTO polsz_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Następnie wrócił na górę, połamał chleb i jadł z nami, a potem dalej przemawiał—aż do wschodu słońca. Gdy skończył, wyruszył w drogę. ");
INSERT INTO polsz_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wtedy wierzący odprowadzili chłopca—całego i zdrowego—do domu, ciesząc się, że żyje. ");
INSERT INTO polsz_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","My już wcześniej udaliśmy się na statek, którym popłynęliśmy do Assos. Właśnie stamtąd mieliśmy zabrać Pawła. Postanowił bowiem, że dotrze tam pieszo. ");
INSERT INTO polsz_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Zgodnie z planem, spotkaliśmy się z nim w Assos, zabraliśmy go na pokład i popłynęliśmy do Mityleny. ");
INSERT INTO polsz_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Następnego dnia minęliśmy wyspę Chios, a kolejnego dnia przybiliśmy do wyspy Samos, skąd dzień później dopłynęliśmy do Miletu. ");
INSERT INTO polsz_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paweł postanowił nie zatrzymywać się w Efezie i nie spędzać więcej czasu w prowincji Azja. Chciał bowiem, w miarę możliwości, zdążyć do Jerozolimy na święto Pięćdziesiątnicy. ");
INSERT INTO polsz_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Dlatego z Miletu wezwał do siebie starszych kościoła w Efezie. ");
INSERT INTO polsz_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Gdy przybyli, rzekł: —Wiecie, że od pierwszej chwili, tu w Azji, przez cały czas byłem z wami, ");
INSERT INTO polsz_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","służąc Panu z całą pokorą, mimo cierpień oraz prześladowań i podstępów ze strony żydowskich przywódców. ");
INSERT INTO polsz_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nie uchylałem się od mówienia wam wszystkiego, co pożyteczne. Nauczałem publicznie i prywatnie—w domach. ");
INSERT INTO polsz_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mówiłem Żydom i poganom, że muszą się zwrócić do Boga i uwierzyć Jezusowi, naszemu Panu. ");
INSERT INTO polsz_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Teraz zaś, kierowany przez Ducha, udaję się do Jerozolimy. A nie wiem, co mnie tam spotka. ");
INSERT INTO polsz_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Zgodnie z proroctwami, które słyszałem w wielu miastach, mogę być tylko pewien aresztowania i cierpień. ");
INSERT INTO polsz_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ale moje życie nie jest przecież najważniejsze. Liczy się tylko to, abym dobrze zakończył bieg i służbę, powierzoną mi przez Jezusa, naszego Pana. Jej celem jest głoszenie dobrej nowiny o tym, że Bóg okazał ludziom łaskę. ");
INSERT INTO polsz_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Wiem już, że wy, którym podczas moich podróży opowiadałem o królestwie, nigdy mnie już nie zobaczycie. ");
INSERT INTO polsz_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Dlatego dziś oświadczam wam, że nie mam niczego na sumieniu, ");
INSERT INTO polsz_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","bo nie wahałem się w pełni przedstawić wam woli Boga. ");
INSERT INTO polsz_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Uważajcie na siebie i na stado, które Duch Święty powierzył wam, przywódcom! Bądźcie dla Bożego kościoła tym, kim jest pasterz dla stada. Bóg bowiem kupił kościół płacąc za niego własną krwią. ");
INSERT INTO polsz_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Niestety wiem, że po moim odejściu pojawią się wśród was fałszywi nauczyciele, którzy będą jak drapieżne wilki wśród stada. ");
INSERT INTO polsz_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Również niektórzy z was samych porzucą prawdę i zaczną nauczać kłamstw, aby tylko pozyskać zwolenników. ");
INSERT INTO polsz_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Uważajcie więc i miejcie w pamięci te trzy lata, które spędziłem z wami, dniem i nocą pouczając każdego ze łzami w oczach. ");
INSERT INTO polsz_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Teraz powierzam was Bogu i Jego cudownemu słowu, które może was umocnić i zapewnić wam—razem ze wszystkimi świętymi—Boży dar. ");
INSERT INTO polsz_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nigdy od nikogo nie żądałem ani pieniędzy, ani odzieży. ");
INSERT INTO polsz_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Wiecie przecież, że własnymi rękami zarabiałem na swoje utrzymanie i na potrzeby moich towarzyszy. ");
INSERT INTO polsz_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Dałem wam w ten sposób przykład, jak należy pracować i wspierać potrzebujących, pamiętając o słowach naszego Pana, który powiedział: „Dawanie przynosi więcej szczęścia niż branie”. ");
INSERT INTO polsz_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Następnie padł na kolana i modlił się z nimi. ");
INSERT INTO polsz_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Oni zaś z głośnym płaczem rzucili mu się na szyję i ucałowali go. ");
INSERT INTO polsz_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Najbardziej zasmuciła ich zapowiedź Pawła, że już nigdy go nie zobaczą. Po pożegnaniu odprowadzili go na statek. ");
INSERT INTO polsz_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Po rozstaniu ze starszymi, popłynęliśmy do Kos. Następnego dnia ruszyliśmy w kierunku Rodos, a stamtąd do Patary. ");
INSERT INTO polsz_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tam natrafiliśmy na statek płynący do Fenicji i wsiedliśmy na niego. ");
INSERT INTO polsz_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Minęliśmy Cypr, zostawiając go po lewej burcie, i popłynęliśmy do Syrii. Zawinęliśmy do portu w Tyrze, gdzie rozładowano statek. ");
INSERT INTO polsz_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Odszukaliśmy tam miejscowych wierzących i postanowiliśmy zatrzymać się u nich przez tydzień. Z natchnienia Ducha Świętego mówili oni Pawłowi o niebezpieczeństwie podróży do Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Po tygodniu wyruszyliśmy z miasta i udaliśmy się do portu, a wszyscy wierzący—mężczyźni wraz z żonami i dziećmi—odprowadzili nas. Nad brzegiem morza uklękliśmy i wspólnie modliliśmy się. ");
INSERT INTO polsz_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Po pożegnaniu wsiedliśmy na statek, oni zaś powrócili do domów. ");
INSERT INTO polsz_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kontynuując podróż, odpłynęliśmy z Tyru i dobiliśmy do Ptolemaidy. Odwiedziliśmy tamtejszych wierzących i zostaliśmy u nich jeden dzień, ");
INSERT INTO polsz_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","nazajutrz zaś odpłynęliśmy do Cezarei. Zatrzymaliśmy się tam w domu Filipa, który był jednym z siedmiu pomocników, wybranych przez apostołów, i zajmował się głoszeniem dobrej nowiny. ");
INSERT INTO polsz_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filip miał cztery niezamężne córki, które były prorokiniami. ");
INSERT INTO polsz_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Podczas naszego dłuższego pobytu w Cezarei przybył tam również z Judei niejaki Agabos, prorok. ");
INSERT INTO polsz_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Gdy nas odwiedził, wziął pas Pawła, związał nim swoje ręce oraz nogi i rzekł: —Tak mówi Duch Święty: „Człowiek, do którego należy ten pas, zostanie związany w Jerozolimie przez żydowskich przywódców i wydany w ręce pogan”. ");
INSERT INTO polsz_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Gdy to usłyszeliśmy—my i miejscowi wierzący—błagaliśmy Pawła, aby nie szedł do Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","—Po co płaczecie i ranicie mi serce?—odrzekł Paweł. —Przecież dla Jezusa, mojego Pana, gotów jestem nie tylko na więzienie w Jerozolimie, ale i na śmierć! ");
INSERT INTO polsz_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nie mogąc go przekonać, ustąpiliśmy, mówiąc: —Niech się dzieje wola Pana! ");
INSERT INTO polsz_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Wkrótce potem spakowaliśmy się i wyruszyliśmy do Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","W drodze towarzyszyło nam kilku uczniów z Cezarei. Po przybyciu na miejsce, zatrzymaliśmy się u pewnego Cypryjczyka, Mnazona, jednego z pierwszych uczniów Jezusa. ");
INSERT INTO polsz_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Wierzący w Jerozolimie serdecznie nas przywitali. ");
INSERT INTO polsz_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Następnego dnia udaliśmy się z Pawłem na spotkanie z Jakubem, na które przyszli również wszyscy starsi kościoła w Jerozolimie. ");
INSERT INTO polsz_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Po przywitaniu, Paweł szczegółowo opowiedział im o tym, czego Bóg, poprzez jego pracę, dokonał wśród pogan. ");
INSERT INTO polsz_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Słysząc to, oddali chwałę Bogu. Potem powiedzieli mu jednak: —Posłuchaj, drogi przyjacielu! Wiele tysięcy tutejszych Żydów uwierzyło Jezusowi, a wszyscy oni nadal skrupulatnie przestrzegają Prawa Mojżesza. ");
INSERT INTO polsz_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Słyszeli jednak, że ty wzywasz Żydów mieszkających wśród pogan do odrzucenia Prawa—do rezygnacji z dokonywania obrzędu obrzezania i nieprzestrzegania naszych zwyczajów. ");
INSERT INTO polsz_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Jak więc powinniśmy teraz postąpić? Na pewno przecież dowiedzą się o twoim przybyciu. ");
INSERT INTO polsz_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Posłuchaj naszej rady: Jest wśród nas czterech mężczyzn, którzy złożyli Bogu specjalną obietnicę. ");
INSERT INTO polsz_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Dołącz do nich, przejdźcie razem obrzęd oczyszczenia i zapłać za ostrzyżenie was wszystkich. Wtedy wszyscy będą wiedzieć, że pogłoski na twój temat są fałszywe i że razem z innymi Żydami przestrzegasz Prawa Mojżesza. ");
INSERT INTO polsz_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Jeśli zaś chodzi o wierzących pogan, to już załatwiliśmy tę sprawę. Napisaliśmy im, aby powstrzymali się od spożywania pokarmów ofiarowanych bożkom, mięsa uduszonych zwierząt i krwi oraz aby unikali rozwiązłości seksualnej. ");
INSERT INTO polsz_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Paweł posłuchał ich i następnego dnia, razem z tymi czterema mężczyznami, poddał się obrzędowi oczyszczenia i udał się do świątyni, aby zgłosić termin zakończenia dni oczyszczenia i złożenia ofiary. ");
INSERT INTO polsz_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Gdy siedmiodniowy czas oczyszczenia dobiegał końca, kilku Żydów z prowincji Azja ujrzało Pawła w świątyni. Podburzyli oni tłum i rzucili się na niego krzycząc: ");
INSERT INTO polsz_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","—Izraelici! Pomóżcie nam! Ten człowiek wszędzie i wszystkich nastawia przeciwko naszemu narodowi, Prawu i świątyni. Na domiar złego wprowadził tu pogan, bezczeszcząc to święte miejsce! ");
INSERT INTO polsz_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Wcześniej bowiem widzieli w mieście Pawła z Trofimem z Efezu i sądzili, że wprowadził go do świątyni. ");
INSERT INTO polsz_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Całe miasto było poruszone i powstało wielkie zamieszanie. Wywleczono Pawła ze świątyni i zatrzaśnięto za nim bramy. ");
INSERT INTO polsz_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","A gdy już mieli go zabić, wiadomość o rozruchach w całej Jerozolimie dotarła do dowódcy rzymskiego oddziału. ");
INSERT INTO polsz_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Zebrał więc szybko podległych sobie dowódców oraz żołnierzy i wszyscy razem wbiegli w tłum. Na widok wojska przestano bić Pawła. ");
INSERT INTO polsz_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Wtedy dowódca podszedł, aresztował Pawła i kazał go zakuć w podwójne kajdany. Dopytywał też, kim jest i co uczynił. ");
INSERT INTO polsz_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ale ludzie w tłumie wykrzykiwali różne rzeczy. Nie mogąc się w tym zgiełku niczego dowiedzieć, rozkazał zabrać Pawła do koszar. ");
INSERT INTO polsz_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Gdy dotarli do schodów, tłum tak bardzo napierał, że żołnierze musieli Pawła nieść. ");
INSERT INTO polsz_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ludzie zaś wciąż podążali za nimi, wołając: —Precz z nim! ");
INSERT INTO polsz_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Tuż przed wejściem do koszar, Paweł rzekł do dowódcy: —Czy mógłbym coś im powiedzieć? —To ty mówisz po grecku? ");
INSERT INTO polsz_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nie jesteś więc tym Egipcjaninem, który jakiś czas temu wywołał powstanie, a potem wraz z czterema tysiącami buntowników wycofał się na pustynię? ");
INSERT INTO polsz_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","—Ja jestem Żydem z Tarsu, znanego miasta w Cylicji. Proszę, pozwól mi przemówić do tych ludzi. ");
INSERT INTO polsz_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Wtedy dowódca wyraził zgodę. Paweł stanął więc na schodach i dał ręką znak, że będzie mówił. Gdy zaległa cisza, zwrócił się do nich po hebrajsku: ");
INSERT INTO polsz_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Drodzy przyjaciele i starsi! Posłuchajcie tego, co mam na swoją obronę! ");
INSERT INTO polsz_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Gdy usłyszeli, że mówi po hebrajsku, uciszyli się jeszcze bardziej. Paweł zaś mówił dalej: ");
INSERT INTO polsz_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Jestem Żydem urodzonym w Tarsie, w Cylicji, ale wychowałem się tu, w Jerozolimie. Pod okiem Gamaliela uczyłem się dokładnie przestrzegać Prawa Mojżesza. Byłem całkowicie oddany Bogu—tak samo jak wy dziś. ");
INSERT INTO polsz_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Prześladowałem zwolenników tej drogi: ścigałem ich, więziłem i zabijałem mężczyzn i kobiety. ");
INSERT INTO polsz_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Może to poświadczyć najwyższy kapłan oraz starsi. To od nich bowiem otrzymałem listy do przywódców w Damaszku, chciałem bowiem udać się tam, aby aresztować tamtejszych uczniów Jezusa i związanych oddać pod sąd w Jerozolimie. ");
INSERT INTO polsz_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ale gdy zbliżałem się do Damaszku, w samo południe oślepiła mnie ogromna jasność z nieba. ");
INSERT INTO polsz_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Padłem wtedy na ziemię i usłyszałem głos: „Szawle, Szawle! Dlaczego Mnie prześladujesz?”. ");
INSERT INTO polsz_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","„Kim jesteś, Panie?”—zapytałem. „Jestem Jezus z Nazaretu, którego prześladujesz”—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Moi towarzysze podróży, którzy stali obok, widzieli jasność, ale nie słyszeli żadnego głosu. ");
INSERT INTO polsz_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","„Co mam robić, Panie?”—zapytałem. „Wstań i idź do Damaszku”—rzekł Pan. „Tam się dowiesz, co masz robić”. ");
INSERT INTO polsz_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ponieważ zostałem oślepiony blaskiem tego światła, do Damaszku zaprowadzili mnie moi towarzysze. ");
INSERT INTO polsz_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Tam przyszedł do mnie niejaki Ananiasz, człowiek kochający Boga i dokładnie przestrzegający Prawa Mojżesza, co potwierdzają wszyscy tamtejsi Żydzi. ");
INSERT INTO polsz_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Stanął przede mną i rzekł: „Szawle, przyjacielu! Przejrzyj!”. W tej samej chwili odzyskałem wzrok i mogłem już go widzieć. ");
INSERT INTO polsz_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Wtedy on powiedział: „Bóg naszych przodków wybrał cię, abyś poznał Jego wolę oraz ujrzał Tego, który jest Prawy i byś usłyszał Jego głos. ");
INSERT INTO polsz_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Odtąd będziesz mówił o Nim wszystkim ludziom, opowiadając także o tym, co widziałeś i słyszałeś. ");
INSERT INTO polsz_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nie zwlekaj więc! Wstań i daj się ochrzcić. Niech imię Pana obmyje cię ze wszystkich twoich grzechów”. ");
INSERT INTO polsz_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Gdy wróciłem do Jerozolimy i modliłem się w świątyni, miałem wizję. ");
INSERT INTO polsz_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Pan rzekł do mnie: „Szybko opuść miasto, ponieważ ci ludzie nie będą słuchać tego, co im o Mnie opowiesz”. ");
INSERT INTO polsz_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","„Ależ Panie!”—protestowałem. „Przecież oni wiedzą, że wtrącałem do więzień i biczowałem w synagogach tych, którzy Ci uwierzyli. ");
INSERT INTO polsz_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Uczestniczyłem przecież nawet w zabójstwie Szczepana, który opowiadał ludziom o Tobie. Popierałem to morderstwo i pilnowałem ubrań tych, którzy zadawali mu śmierć”. ");
INSERT INTO polsz_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Bóg rzekł jednak do mnie: „Wyjedź z Jerozolimy, bo chcę cię posłać daleko stąd, do pogan!”. ");
INSERT INTO polsz_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Tłum, który do tego momentu spokojnie słuchał słów Pawła, teraz zaczął krzyczeć: —Precz z nim! On nie zasługuje na życie! ");
INSERT INTO polsz_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Krzyczeli, wymachiwali ubraniami i zdenerwowani rzucali piaskiem. ");
INSERT INTO polsz_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Dowódca zabrał więc Pawła do koszar i rozkazał biczowaniem wydobyć z niego zeznania, aby dowiedzieć się dlaczego tłum tak go nienawidzi. ");
INSERT INTO polsz_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Gdy żołnierze związali go już do biczowania, Paweł zapytał stojącego obok dowódcę: —Czy wolno wam biczować rzymskiego obywatela i to bez procesu? ");
INSERT INTO polsz_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ten udał się do dowódcy oddziału i powiedział: —Uważaj, co robisz! Ten człowiek to Rzymianin! ");
INSERT INTO polsz_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Dowódca podszedł więc do Pawła i zapytał: —Naprawdę jesteś Rzymianinem? —Tak—odparł Paweł. ");
INSERT INTO polsz_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","—Mnie rzymskie obywatelstwo kosztowało majątek!—rzekł. —A ja mam je od urodzenia—odpowiedział Paweł. ");
INSERT INTO polsz_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ci, którzy chcieli przesłuchiwać Pawła, natychmiast się usunęli. A dowódca przestraszył się, że aresztował rzymskiego obywatela. ");
INSERT INTO polsz_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Następnego dnia, chcąc się dowiedzieć o co żydowscy przywódcy oskarżają Pawła, dowódca zdjął z niego więzy i zarządził zebranie najwyższych kapłanów oraz Wysokiej Rady. Następnie postawił przed nimi Pawła. ");
INSERT INTO polsz_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paweł spojrzał na członków Rady i powiedział: —Przyjaciele! Żyję z czystym sumieniem przed Bogiem! ");
INSERT INTO polsz_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Na to najwyższy kapłan polecił stojącym obok Pawła uderzyć go w twarz. ");
INSERT INTO polsz_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","—I ciebie, obłudniku, uderzy Bóg!—odpowiedział Paweł. —Sądzisz mnie na podstawie Prawa Mojżesza, a jednocześnie łamiesz je, każąc mnie bić! ");
INSERT INTO polsz_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","—Znieważasz najwyższego kapłana?!—odezwali się stojący obok Pawła. ");
INSERT INTO polsz_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","—Przyjaciele! Nie wiedziałem, że to najwyższy kapłan—rzekł Paweł. —Napisane jest przecież w Prawie Mojżesza: „Nie będziesz mówił nic złego o przełożonym ludu”. ");
INSERT INTO polsz_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Gdy się zorientował, że Rada składa się z saduceuszy i faryzeuszy, zawołał: —Drodzy przyjaciele! Podobnie jak moi przodkowie, jestem faryzeuszem. A dziś jestem sądzony dlatego, że wierzę w zmartwychwstanie! ");
INSERT INTO polsz_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Słowa te od razu skłóciły przedstawicieli dwóch ugrupowań i powstał miedzy nimi rozłam. ");
INSERT INTO polsz_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saduceusze bowiem, w przeciwieństwie do faryzeuszy, nie wierzą w zmartwychwstanie, aniołów ani życie po śmierci. ");
INSERT INTO polsz_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Powstało więc ogromne zamieszanie. Niektórzy przywódcy religijni z ugrupowania faryzeuszy wołali: —On nic złego nie zrobił. Może rzeczywiście przemówił do niego duch albo anioł! ");
INSERT INTO polsz_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kłótnia między członkami Rady stawała się coraz bardziej zawzięta. W końcu dowódca, obawiając się, że rozerwą Pawła na kawałki, kazał żołnierzom zabrać go z sali obrad i zaprowadzić do koszar. ");
INSERT INTO polsz_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Tej nocy Pan stanął przed Pawłem i rzekł: —Odwagi! Musisz opowiedzieć o Mnie nie tylko tu, w Jerozolimie, ale także w Rzymie! ");
INSERT INTO polsz_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Następnego dnia zebrała się grupa czterdziestu Żydów, którzy złożyli przysięgę, że nie będą ani jeść, ani pić, dopóki nie zabiją Pawła. ");
INSERT INTO polsz_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Udali się do najwyższych kapłanów oraz starszych i rzekli: —Złożyliśmy przysięgę, że nie weźmiemy nic do ust, dopóki nie zgładzimy Pawła. ");
INSERT INTO polsz_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Poproście więc dowódcę, żeby jeszcze raz przyprowadził Pawła na posiedzenie Wysokiej Rady, celem dokładniejszego przesłuchania go. My zaś zabijemy go w drodze. ");
INSERT INTO polsz_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","O planowanym zamachu dowiedział się jednak siostrzeniec Pawła. Przyszedł więc do koszar i uprzedził go o tym. ");
INSERT INTO polsz_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","On zaś zawołał jednego z dowódców. —Zaprowadź tego chłopca do dowódcy oddziału—powiedział. —Ma dla niego ważną informację. ");
INSERT INTO polsz_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ten udał się więc z nim do dowódcy oddziału i powiedział: —Więzień Paweł prosił mnie, bym przyprowadził tu tego młodzieńca, bo ma dla ciebie jakąś wiadomość. ");
INSERT INTO polsz_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Dowódca wziął chłopca za rękę, odprowadził na bok i zapytał: —O czym chcesz mi powiedzieć? ");
INSERT INTO polsz_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","—Żydowscy przywódcy postanowili poprosić cię, żebyś jutro przyprowadził Pawła na posiedzenie Wysokiej Rady w celu rzekomego przesłuchania go. ");
INSERT INTO polsz_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nie zgódź się jednak na to! Ponad czterdziestu ludzi przygotowało bowiem na niego zasadzkę. Przysięgli sobie nawet, że nie będą jeść i pić, dopóki go nie zabiją. Są już gotowi i czekają tylko na twoją zgodę. ");
INSERT INTO polsz_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","—Nie mów nikomu, że mi o tym powiedziałeś—ostrzegł go dowódca i wypuścił. ");
INSERT INTO polsz_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Potem wezwał dwóch podległych sobie dowódców i rozkazał im: —Na dziewiątą wieczorem przygotujcie dwustu żołnierzy, dwustu oszczepników i siedemdziesięciu jezdnych. Wyruszą do Cezarei. ");
INSERT INTO polsz_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Przygotujcie też konia dla Pawła i bezpiecznie doprowadźcie go do gubernatora Feliksa. ");
INSERT INTO polsz_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Do gubernatora zaś napisał list następującej treści: ");
INSERT INTO polsz_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","„Pozdrowienia od Klaudiusza Lizjasza dla gubernatora Feliksa! ");
INSERT INTO polsz_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Grupa Żydów schwytała tego oto człowieka i już chciała go zabić. Gdy się dowiedziałem, że jest Rzymianinem, posłałem żołnierzy i uratowałem go. ");
INSERT INTO polsz_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Potem postawiłem go przed ich Wysoką Radą, żeby poznać stawiane mu zarzuty. ");
INSERT INTO polsz_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Stwierdziłem jednak, że oskarżenia dotyczą jakichś spornych kwestii z ich religijnego prawa, a nie czynu podlegającego karze śmierci lub więzienia. ");
INSERT INTO polsz_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ponieważ dowiedziałem się o spisku na jego życie, niezwłocznie posłałem go do ciebie, informując jego oskarżycieli, że mają postawić mu zarzuty przed tobą”. ");
INSERT INTO polsz_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Nocą, zgodnie z rozkazem, żołnierze wyruszyli więc z Pawłem i odprowadzili go do Antipatris. ");
INSERT INTO polsz_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Sami wrócili rano do koszar, jeźdźcom zaś polecili odstawić go na miejsce. ");
INSERT INTO polsz_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ci więc, po przybyciu do Cezarei, przekazali Pawła gubernatorowi i wręczyli mu list od dowódcy. ");
INSERT INTO polsz_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Przeczytawszy list, gubernator zapytał Pawła, z jakiej pochodzi prowincji. Gdy się zaś dowiedział, że jest z Cylicji, powiedział: ");
INSERT INTO polsz_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","—Przesłucham cię, gdy przybędą twoi oskarżyciele. Następnie rozkazał pilnować go w celi pałacu Heroda. ");
INSERT INTO polsz_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pięć dni później, przybył najwyższy kapłan Ananiasz razem ze starszymi oraz z prawnikiem Tertullosem. Oni to wnieśli przed gubernatorem oskarżenie przeciw Pawłowi. ");
INSERT INTO polsz_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Gdy go wprowadzono, Tertullos rozpoczął mowę oskarżycielską: —Dostojny Feliksie! Zapewniłeś nam pokój i pomyślność, ");
INSERT INTO polsz_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","za co jesteśmy ci bardzo wdzięczni. ");
INSERT INTO polsz_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nie chcemy nadużywać twojej cierpliwości i życzliwości. Zechciej jednak krótko nas wysłuchać. ");
INSERT INTO polsz_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Stwierdziliśmy, że ten człowiek, siejący niezgodę wśród wszystkich Żydów na świecie, jest przywódcą sekty nazarejczyków. ");
INSERT INTO polsz_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Co więcej, usiłował on zbezcześcić naszą świątynię i dlatego go zatrzymaliśmy. ");
INSERT INTO polsz_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","8","Sam zresztą możesz go przesłuchać i przekonać się o prawdziwości naszych oskarżeń. ");
INSERT INTO polsz_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Gdy skończył, ci którzy przybyli z najwyższym kapłanem, poświadczyli, że to prawda. ");
INSERT INTO polsz_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Wówczas gubernator dał Pawłowi znak, że może się bronić: —Wiem, że od wielu lat rozstrzygasz sprawy dotyczące naszego narodu—rzekł Paweł—dlatego z tym większym zaufaniem mogę mówić w swojej obronie. ");
INSERT INTO polsz_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Możesz bowiem łatwo sprawdzić, że przybyłem do Jerozolimy nie więcej niż dwanaście dni temu, aby w świątyni oddać chwałę Bogu. ");
INSERT INTO polsz_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ani tam, ani w żadnej synagodze, ani nigdzie indziej w Jerozolimie nie nauczałem i nie podburzałem tłumów. ");
INSERT INTO polsz_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nie ma więc żadnych dowodów na te wszystkie oskarżenia. ");
INSERT INTO polsz_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Przyznaję się natomiast przed tobą, że służę naszemu Bogu według drogi zbawienia nazywanej przez nich sektą. Wierzę we wszystko, co jest napisane w Prawie Mojżesza i księgach proroków. ");
INSERT INTO polsz_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","I, podobnie jak moi oskarżyciele, z nadzieją oczekuję zmartwychwstania wszystkich ludzi—dobrych i złych. ");
INSERT INTO polsz_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Dlatego ze wszystkich sił staram się zachować czyste sumienie przed Bogiem i ludźmi. ");
INSERT INTO polsz_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Do Jerozolimy zaś przybyłem po raz pierwszy od wielu lat, aby przynieść moim rodakom pomoc materialną i złożyć ofiarę Bogu. ");
INSERT INTO polsz_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Wtedy właśnie zobaczyli mnie w świątyni, po obrzędzie oczyszczenia—ale nie w tłumie i nie wzniecającego rozruchy. ");
INSERT INTO polsz_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Byli tam obecni Żydzi z prowincji Azja i to oni, jako świadkowie, powinni tu być i przedstawiać rzekome oskarżenia. ");
INSERT INTO polsz_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Zresztą i ci ludzie mogą powiedzieć, czy Wysoka Rada wysunęła przeciwko mnie jakiekolwiek zarzuty, ");
INSERT INTO polsz_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","prócz tego, że publicznie zawołałem: „Jestem sądzony dlatego, że wierzę w zmartwychwstanie!”. ");
INSERT INTO polsz_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks wiele już słyszał o drodze Pana. Odrzucił więc wszystkie oskarżenia i powiedział: —Zajmę się waszą sprawą, gdy przybędzie tu dowódca Lizjasz! ");
INSERT INTO polsz_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Rozkazał też podległemu sobie dowódcy pilnować Pawła, dobrze go traktować i nie przeszkadzać jego przyjaciołom w odwiedzaniu go i służeniu mu pomocą. ");
INSERT INTO polsz_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Po kilku dniach Feliks przybył wraz z żoną, Druzyllą, która była Żydówką, i polecili wezwać Pawła. Chciał bowiem posłuchać jego nauki o wierze w Jezusa Chrystusa. ");
INSERT INTO polsz_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Gdy jednak Paweł zaczął mówić o prawości, czystości i nadchodzącym Bożym sądzie, Feliks poczuł strach. —Odejdź już—powiedział. —Posłucham cię kiedy indziej. ");
INSERT INTO polsz_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Liczył jednak, że Paweł da mu jakąś łapówkę, toteż często go wzywał i rozmawiał z nim. ");
INSERT INTO polsz_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Dwa lata później urząd gubernatora objął następca Feliksa, Porcjusz Festus. Odchodząc, Feliks pozostawił jednak Pawła w więzieniu. Chciał bowiem utrzymać dobre stosunki z żydowskimi przywódcami. ");
INSERT INTO polsz_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","W trzy dni po objęciu urzędu w Cezarei, Festus udał się do Jerozolimy. ");
INSERT INTO polsz_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Wówczas najwyżsi kapłani i wpływowi przywódcy żydowscy przedstawili mu zarzuty wobec Pawła. Poprosili też, ");
INSERT INTO polsz_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","aby zrobił im przysługę i sprowadził go do Jerozolimy. Mieli bowiem zamiar urządzić po drodze zasadzkę i zabić go. ");
INSERT INTO polsz_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ale Festus odpowiedział, że Paweł pozostanie w Cezarei i że on sam też się tam wkrótce udaje. Zaproponował więc: ");
INSERT INTO polsz_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","—Niech wasi przedstawiciele pojadą ze mną i wniosą oskarżenie, jeśli Paweł jest winny. ");
INSERT INTO polsz_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Osiem lub dziesięć dni później wrócił do Cezarei. Następnego dnia zasiadł na fotelu sędziowskim i polecił, aby przyprowadzono Pawła. ");
INSERT INTO polsz_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Żydowscy przywódcy, którzy przybyli z Jerozolimy, natychmiast otoczyli go i zaczęli stawiać mu wiele poważnych zarzutów. Niczego jednak nie potrafili udowodnić. ");
INSERT INTO polsz_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","—Nie zgrzeszyłem ani przeciw naszemu Prawu—bronił się Paweł—ani przeciw świątyni, ani przeciw cezarowi! ");
INSERT INTO polsz_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","—Czy chciałbyś więc zeznawać przede mną w Jerozolimie?—zapytał go Festus, chcąc zadowolić żydowskich przywódców. ");
INSERT INTO polsz_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","—Nie!—odrzekł Paweł. —Przysługuje mi prawo osądzenia mojej sprawy przez samego cezara. Dobrze wiesz, że nie popełniłem żadnego przestępstwa przeciw mojemu narodowi. ");
INSERT INTO polsz_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Jeśli dopuściłem się czynu zasługującego na śmierć, nie waham się umrzeć. Lecz jeśli nie zrobiłem niczego, o co mnie oskarżają, nikt nie ma prawa mnie im wydać. Odwołuję się do cezara! ");
INSERT INTO polsz_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Po omówieniu sytuacji ze swoją radą, Festus rzekł: —Skoro się odwołałeś, staniesz przed cezarem. ");
INSERT INTO polsz_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Jakiś czas później przybyli do Festusa w odwiedziny król Agryppa wraz z żoną Berenike. ");
INSERT INTO polsz_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Po kilku dniach Festus przedstawił królowi sprawę Pawła. —Mam tu więźnia—powiedział—którego pozostawił mi Feliks. ");
INSERT INTO polsz_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Gdy byłem w Jerozolimie, najwyżsi kapłani i żydowscy starsi wnieśli przeciwko niemu oskarżenie i zażądali ukarania go. ");
INSERT INTO polsz_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Wyjaśniłem im oczywiście, że Rzymianie nie mają zwyczaju nikogo skazywać na śmierć, jeśli oskarżony nie stanie najpierw przed swoimi oskarżycielami i nie będzie miał prawa do obrony. ");
INSERT INTO polsz_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","A gdy wszyscy tu przybyli, nie odraczałem sprawy. Zająłem miejsce w fotelu sędziowskim i poleciłem przyprowadzić więźnia. ");
INSERT INTO polsz_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Oskarżyciele nie postawili mu jednak żadnego z zarzutów, których się spodziewałem. ");
INSERT INTO polsz_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Oskarżali go tylko o kwestie natury religijnej, dotyczące jakiegoś zmarłego Jezusa, o którym Paweł twierdzi, że żyje. ");
INSERT INTO polsz_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Przyznam, że byłem bezradny wobec tych dociekań. Zaproponowałem więc Pawłowi, żeby poszedł do Jerozolimy i tam zeznawał. ");
INSERT INTO polsz_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","On jednak odwołał się do cezara, dlatego poleciłem pilnować go aż do czasu odesłania do Rzymu. ");
INSERT INTO polsz_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","—Chętnie posłuchałbym tego człowieka—powiedział Agryppa. —Dobrze. Jutro go usłyszysz—odrzekł Festus. ");
INSERT INTO polsz_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Następnego dnia król Agryppa wraz z Berenike uroczyście wkroczyli na salę rozpraw. Towarzyszyło im wiele dowódców i wybitnych osobistości miasta. Festus rozkazał wprowadzić Pawła. ");
INSERT INTO polsz_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","—Królu Agryppo i wszyscy zebrani!—rozpoczął Festus. —Oto człowiek, którego śmierci domagają się tłumy Żydów, zarówno z Jerozolimy, jak i z naszego miasta. ");
INSERT INTO polsz_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Według mnie nie popełnił on żadnego przestępstwa podlegającego karze śmierci. Ponieważ jednak odwołał się do cezara, postanowiłem go wysłać do Rzymu, ");
INSERT INTO polsz_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ale nie wiem, co na jego temat napisać cezarowi. Dlatego postawiłem go przed wami wszystkimi, a szczególnie przed tobą, królu Agryppo, abyście go przesłuchali i poradzili mi, co napisać. ");
INSERT INTO polsz_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nierozsądne byłoby bowiem wysyłać więźnia do cezara, nie podając, o co się go oskarża. ");
INSERT INTO polsz_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","—Powiedz, co masz na swoją obronę—zwrócił się Agryppa do Pawła. Ten dał ręką znak, że zaczyna, i rozpoczął mowę obronną: ");
INSERT INTO polsz_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Cieszę się, królu Agryppo, że mogę bronić się przed zarzutami żydowskich przywódców w twojej obecności. ");
INSERT INTO polsz_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Doskonale bowiem znasz ich zwyczaje i spory. Proszę więc, racz cierpliwie mnie wysłuchać. ");
INSERT INTO polsz_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Mieszkańcy Jerozolimy znają mnie od dziecka i wiedzą jak od najmłodszych lat wychowywałem się w Jerozolimie, wśród moich rodaków—Żydów. ");
INSERT INTO polsz_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Gdyby tylko chcieli, mogliby potwierdzić, że jako faryzeusz bardzo ściśle przestrzegałem praw i zwyczajów tego najsurowszego żydowskiego ugrupowania religijnego. ");
INSERT INTO polsz_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ale prawdziwym powodem tej rozprawy jest to, że oczekuję spełnienia obietnicy, którą Bóg dał naszym przodkom. ");
INSERT INTO polsz_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Dwanaście rodów Izraela dniem i nocą służyło Bogu, oczekując wypełnienia jej. Królu, żydowscy przywódcy oskarżają mnie właśnie z powodu tej nadziei. ");
INSERT INTO polsz_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Dlaczego jednak uznaje się za nieprawdopodobne to, że Bóg wskrzesza umarłych? ");
INSERT INTO polsz_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Osobiście byłem przekonany, że powinienem zdecydowanie przeciwstawiać się Jezusowi z Nazaretu. ");
INSERT INTO polsz_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Zacząłem od Jerozolimy. Z upoważnienia najwyższych kapłanów aresztowałem wielu świętych. Głosowałem przeciwko nim, gdy ich skazywano na śmierć. ");
INSERT INTO polsz_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ścigając ich po wszystkich synagogach, torturami zmuszałem ich do przeklinania imienia Jezusa. Byłem ich tak zaciętym wrogiem, że prześladowałem ich nawet w miastach poza Izraelem. ");
INSERT INTO polsz_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Z takim właśnie zamiarem jechałem do Damaszku, mając autorytet i pełnomocnictwo najwyższych kapłanów. ");
INSERT INTO polsz_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Królu! Podczas tej podróży, w południe, ujrzałem światło z nieba, jaśniejsze od słońca, które ogarnęło mnie i moich towarzyszy podróży. ");
INSERT INTO polsz_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Padliśmy na ziemię i usłyszałem głos, mówiący do mnie po hebrajsku: „Szawle, Szawle, dlaczego mnie prześladujesz? Wierzgasz jak trafione strzałą zwierzę i ranisz samego siebie”. ");
INSERT INTO polsz_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","„Panie, kim jesteś?”—zapytałem. „Jestem Jezus, którego prześladujesz”—odpowiedział. ");
INSERT INTO polsz_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","„Teraz wstań! Ukazałem ci się, bo wybrałem cię na swojego sługę i świadka. Będziesz opowiadał innym o tym, co widziałeś i co jeszcze zobaczysz. ");
INSERT INTO polsz_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Będę cię chronić przed twoim własnym narodem oraz przed poganami, do których cię poślę. ");
INSERT INTO polsz_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Otworzysz im oczy, aby zwrócili się od ciemności do światła oraz od władzy szatana do Boga. Gdy to uczynią, odpuszczę im grzechy i obdarzę ich darem, który otrzymają wszyscy święci”. ");
INSERT INTO polsz_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Królu Agryppo, nie mogłem sprzeciwić się Bożemu objawieniu! ");
INSERT INTO polsz_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Dlatego wzywałem ludzi—najpierw mieszkańców Damaszku, następnie Jerozolimy i całej Judei, a potem również pogan—do opamiętania się, zwrócenia do Boga i zmiany życia. ");
INSERT INTO polsz_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Właśnie z tego powodu żydowscy przywódcy zatrzymali mnie w świątyni i usiłowali zabić. ");
INSERT INTO polsz_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ale Bóg ochronił mnie i dziś nadal mogę opowiadać o tym wszystkim ludziom—małym i wielkim. A to, co mówię, zgodne jest z zapowiedziami proroków i Mojżesza, którzy przepowiedzieli, ");
INSERT INTO polsz_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","że Mesjasz będzie cierpiał i pierwszy powstanie z martwych, aby przynieść światło zarówno Żydom, jak i poganom. ");
INSERT INTO polsz_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Gdy Paweł się tak bronił, Festus nagle zawołał: —Chyba oszalałeś, Pawle! Ogromna wiedza pomieszała ci w głowie! ");
INSERT INTO polsz_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","—Nie oszalałem, dostojny Festusie—odrzekł Paweł. —To, co mówię, jest logiczne i zgodne z prawdą. ");
INSERT INTO polsz_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Król Agryppa dobrze wie o tych sprawach. Mówię o nich zupełnie otwarcie, jestem bowiem przekonany, że te wydarzenia nie uszły jego uwadze. Nie miały bowiem miejsca w jakimś zapadłym kącie! ");
INSERT INTO polsz_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Królu Agryppo, czy wierzysz prorokom? Wiem, że wierzysz. ");
INSERT INTO polsz_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","—Czy myślisz, że tak szybko uda ci się zrobić ze mnie chrześcijanina?—zapytał Agryppa. ");
INSERT INTO polsz_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","—Byłbym wdzięczny Bogu—odpowiedział Paweł—gdybyś zarówno ty, jak i wszyscy słuchający mnie tu, prędzej czy później mogli stać się takimi jak ja, oczywiście z wyjątkiem tych kajdan. ");
INSERT INTO polsz_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Po tych słowach król, gubernator, Berenike i wszyscy pozostali podnieśli się z miejsc. ");
INSERT INTO polsz_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","A wychodząc z sali, mówili między sobą: —Ten człowiek nie uczynił niczego zasługującego na śmierć lub więzienie. ");
INSERT INTO polsz_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agryppa zaś powiedział do Festusa: —Gdyby się nie odwoływał do cezara, można by go było uwolnić. ");
INSERT INTO polsz_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Gdy już zapadła decyzja o naszej podróży do Italii, przekazano Pawła i innych więźniów pod nadzór niejakiemu Juliuszowi, dowódcy oddziału cezara. ");
INSERT INTO polsz_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Wsiedliśmy na statek płynący z Adramyttion i wypłynęliśmy w kierunku Azji. Towarzyszył nam również Arystarch, Macedończyk z Tesaloniki. ");
INSERT INTO polsz_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Następnego dnia, gdy zawinęliśmy do Sydonu, Juliusz, który był przychylny Pawłowi, pozwolił mu odwiedzić przyjaciół i skorzystać z ich gościny. ");
INSERT INTO polsz_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Z Sydonu skierowaliśmy się na północ ku Cyprowi, bo natknęliśmy się na przeciwne wiatry. ");
INSERT INTO polsz_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Opłynęliśmy wybrzeże Cylicji i Pamfilii i przybyliśmy do Myry w prowincji Licja. ");
INSERT INTO polsz_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Tam dowódca znalazł statek płynący z Aleksandrii do Italii i umieścił nas na nim. ");
INSERT INTO polsz_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Przez wiele dni powoli płynęliśmy ku portowi w Knidos. Ponieważ jednak wiatr nam nie sprzyjał, skierowaliśmy się na Kretę, mijając port Salmone. ");
INSERT INTO polsz_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Z trudem płynęliśmy wzdłuż południowego brzegu, aż przybyliśmy do miejsca o nazwie Piękna Przystań, w pobliżu miasta Lasaia. ");
INSERT INTO polsz_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Minęło sporo czasu, a dalsze kontynuowanie rejsu było niebezpieczne, minął już bowiem Dzień Pojednania. Paweł przestrzegał więc: ");
INSERT INTO polsz_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","—Panowie! Uważam, że dalsza podróż będzie niebezpieczna nie tylko dla statku i ładunku, ale i dla naszego życia. ");
INSERT INTO polsz_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ale Juliusz bardziej niż Pawłowi ufał sternikowi i właścicielowi statku. ");
INSERT INTO polsz_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Piękna Przystań nie nadawała się do spędzenia w niej zimy. Dlatego większość załogi uznała, że trzeba ją opuścić i spróbować dopłynąć do portu Feniks na Krecie, wystawionego na południowo-zachodnie i północno-zachodnie wiatry. ");
INSERT INTO polsz_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Gdy zaczął wiać lekki południowy wiatr, zgodnie z postanowieniem, podnieśli kotwicę i popłynęli wzdłuż brzegu wyspy. ");
INSERT INTO polsz_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Jednak dość szybko od strony lądu zaczął wiać huragan Eurakilon. ");
INSERT INTO polsz_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Statek zaczął tracić kurs i nie mógł stawić czoła wiatrowi. Musieliśmy więc poddać się mu i pozwolić nieść prądowi morskiemu. ");
INSERT INTO polsz_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Wreszcie podpłynęliśmy do wyspy Kauda, gdzie z trudem wciągnęliśmy na pokład łódź ratunkową ");
INSERT INTO polsz_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","i wzmocniliśmy statek linami. W obawie przed wpadnięciem na wyspę Sytrę, opuszczono pływającą kotwicę i tak dryfowaliśmy. ");
INSERT INTO polsz_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Następnego dnia, sztorm stał się jeszcze silniejszy, załoga wyrzuciła więc za burtę ładunek. ");
INSERT INTO polsz_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Kolejnego dnia wyrzucono także sprzęt okrętowy. ");
INSERT INTO polsz_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Przez wiele dni nie było widać ani słońca, ani gwiazd, a sztorm nie ustawał. Traciliśmy już więc nadzieję na ocalenie. ");
INSERT INTO polsz_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nikt nie był w stanie nawet jeść. W końcu Paweł powiedział do załogi: —Mogliście mnie posłuchać i nie wypływać z Krety. W ten sposób uniknęlibyście tego nieszczęścia i strat. ");
INSERT INTO polsz_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ale bądźcie dobrej myśli! Statek wprawdzie zatonie, ale nikt z nas nie zginie. ");
INSERT INTO polsz_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Dziś w nocy ukazał mi się anioł Boga, do którego należę i któremu służę, ");
INSERT INTO polsz_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","i powiedział: „Nie bój się, Pawle, bo na pewno staniesz przed cezarem! Co więcej, ze względu na ciebie Bóg ocali wszystkich, którzy z tobą płyną”. ");
INSERT INTO polsz_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Bądźcie więc dobrej myśli! Ufam Bogu, że zrobi to, co powiedział, ");
INSERT INTO polsz_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","i zostaniemy wyrzuceni na brzeg jakiejś wyspy. ");
INSERT INTO polsz_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Była już czternasta noc sztormu, a my nadal dryfowaliśmy po Adriatyku. W środku nocy marynarze zorientowali się, że zbliżamy się do lądu. ");
INSERT INTO polsz_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Spuścili sondę i stwierdzili, że głębokość wynosi 37 metrów. Po chwili zmierzyli ją ponownie—wynosiła 28 metrów. ");
INSERT INTO polsz_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bojąc się rozbicia o przybrzeżne skały, zrzucili z rufy cztery kotwice, pragnąc przetrwać tak do rana. ");
INSERT INTO polsz_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Niektórzy członkowie załogi chcieli jednak uciec ze statku i—pod pozorem zrzucania kotwic na dziobie okrętu—zaczęli spuszczać na wodę łódź ratunkową. ");
INSERT INTO polsz_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Wtedy Paweł powiedział do dowódcy i żołnierzy: —Jeśli oni nie zostaną na statku, wszyscy pasażerowie zginą, wy również. ");
INSERT INTO polsz_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Żołnierze odcięli więc liny i łódź spadła do morza. ");
INSERT INTO polsz_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Tuż przed świtem Paweł zachęcił wszystkich, żeby coś zjedli. —Przez czternaście dni nie braliście nic do ust. ");
INSERT INTO polsz_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Proszę, dla waszego dobra zjedzcie coś! Zapewniam, że nikomu z was nie spadnie wam nawet włos z głowy! ");
INSERT INTO polsz_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Po tych słowach wziął do rąk chleb i wobec wszystkich podziękował za niego Bogu. Odłamał kawałek i zaczął jeść. ");
INSERT INTO polsz_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Zaraz wszyscy poczuli się lepiej i również zaczęli jeść, ");
INSERT INTO polsz_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","a było nas na statku dwieście siedemdziesiąt sześć osób. ");
INSERT INTO polsz_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Po posiłku załoga jeszcze bardziej odciążyła statek, wyrzucając za burtę ładunek zboża. ");
INSERT INTO polsz_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Gdy nastał dzień, nie mogli rozpoznać lądu. Dostrzegli jednak zatokę z płaskim wybrzeżem i zastanawiali się, czy udałoby się tam zacumować statek. ");
INSERT INTO polsz_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Odcięli więc kotwice, zostawiając je w morzu, uwolnili ster z lin oraz postawili przedni żagiel. Wówczas okręt zaczął płynąć w kierunku lądu. ");
INSERT INTO polsz_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ale statek utknął na mieliźnie między dwoma prądami morskimi. Dziób został unieruchomiony, natomiast rufa zaczęła się rozpadać pod naporem silnie uderzających fal. ");
INSERT INTO polsz_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Wtedy żołnierze postanowili zabić więźniów, aby żaden z nich nie uciekł. ");
INSERT INTO polsz_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ale Juliusz, chcąc oszczędzić Pawła, zabronił im tego. Wszystkim umiejącym pływać rozkazał wyskoczyć za burtę i dopłynąć do brzegu. ");
INSERT INTO polsz_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Pozostałym zaś polecił, aby ratowali się na deskach i innych częściach statku. W ten sposób wszyscy bezpiecznie dotarli do brzegu wyspy. ");
INSERT INTO polsz_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Gdy znaleźliśmy się na lądzie, dowiedzieliśmy się, że jesteśmy na Malcie. ");
INSERT INTO polsz_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Mieszkańcy wyspy byli niezwykle uprzejmi. Od razu rozpalili ognisko i zaopiekowali się nami, bo było zimno oraz padał deszcz. ");
INSERT INTO polsz_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Gdy Paweł nazbierał chrustu i dorzucił do ogniska, z powodu gorąca wypełzła spod gałęzi żmija i uczepiła się jego ręki. ");
INSERT INTO polsz_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Widząc to, wyspiarze mówili między sobą: —To musi być morderca, bo chociaż ocalał z morza, bogini sprawiedliwości i tak upomniała się o jego życie. ");
INSERT INTO polsz_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ale Paweł strząsnął żmiję w ogień i nic mu się nie stało. ");
INSERT INTO polsz_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ludzie spodziewali się, że opuchnie lub padnie martwy. Upłynęło jednak sporo czasu, a nic takiego się nie wydarzyło. Dlatego zmienili zdanie i uznali, że jest bogiem. ");
INSERT INTO polsz_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","W pobliżu tego miejsca znajdowała się posiadłość gubernatora wyspy, Publiusza. Zaprosił on nas do siebie i serdecznie gościł przez trzy dni. ");
INSERT INTO polsz_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ojciec Publiusza leżał właśnie chory i cierpiał z powodu biegunki i gorączki. Paweł odwiedził go, pomodlił się za niego i—kładąc na niego ręce—uzdrowił go. ");
INSERT INTO polsz_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Wtedy zaczęli przychodzić do niego również inni chorzy mieszkańcy wyspy i oni także zostali uzdrowieni. ");
INSERT INTO polsz_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ludzie ci okazali nam wielki szacunek, a przed dalszą podróżą zaopatrzyli na drogę. ");
INSERT INTO polsz_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Po trzech miesiącach pobytu na Malcie, opuściliśmy ją na statku z godłem bliźniaczych bogów, Kastora i Polluksa, płynącym z Aleksandrii. Okręt ten w czasie zimy cumował bowiem na wyspie. ");
INSERT INTO polsz_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Najpierw zawinęliśmy do Syrakuz i zatrzymaliśmy się tam na trzy dni. ");
INSERT INTO polsz_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Stamtąd popłynęliśmy do Regium. Dzień później zaczął wiać południowy wiatr, więc następnego dnia przybiliśmy do Puteoli. ");
INSERT INTO polsz_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Tam spotkaliśmy kilku wierzących, którzy zaprosili nas do siebie na cały tydzień. Stamtąd zaś udaliśmy się już do Rzymu. ");
INSERT INTO polsz_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Gdy tamtejsi wierzący dowiedzieli się o naszym przybyciu, wyszli nam na spotkanie aż do Forum Appiusza i do „Trzech Tawern”. Zobaczywszy ich, Paweł oddał chwałę Bogu i nabrał otuchy. ");
INSERT INTO polsz_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","W Rzymie zaś pozwolono mu zamieszkać w prywatnym domu pod nadzorem żołnierza. ");
INSERT INTO polsz_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Trzy dni później Paweł zaprosił do siebie miejscowych przywódców żydowskich. Gdy się zebrali u niego, przemówił: —Przyjaciele! Nie uczyniłem nic przeciwko naszemu narodowi ani tradycjom, choć w Jerozolimie aresztowano mnie i wydano Rzymianom. ");
INSERT INTO polsz_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ci postawili mnie przed sądem, ale chcieli uwolnić, bo nie znaleźli podstaw do skazania mnie na śmierć. ");
INSERT INTO polsz_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Wobec sprzeciwu ze strony żydowskich przywódców, musiałem odwołać się do cezara. Nie uczyniłem jednak tego po to, aby oskarżać własny naród! ");
INSERT INTO polsz_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Zaprosiłem więc was, aby wam powiedzieć, że zostałem zakuty w te kajdany z powodu nadziei, którą ma cały Izrael. ");
INSERT INTO polsz_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","—Nie otrzymaliśmy z Judei żadnych oskarżających cię listów. Również nikt z rodaków, którzy nas odwiedzają, ani ktokolwiek inny nie przekazał nam żadnych zarzutów przeciwko tobie. ");
INSERT INTO polsz_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Chętnie więc poznamy twoje poglądy, słyszeliśmy już bowiem o tej sekcie i wiemy, że wszędzie spotyka się ze sprzeciwem. ");
INSERT INTO polsz_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Umówili się na następne spotkanie i w wyznaczonym dniu, w jeszcze większym gronie, przybyli do jego domu. A Paweł od rana aż do wieczora opowiadał im o królestwie Bożym i przedstawiał osobę Jezusa w świetle Prawa Mojżesza i ksiąg proroków. ");
INSERT INTO polsz_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Niektórzy z obecnych uwierzyli, inni nie. ");
INSERT INTO polsz_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Gdy, skłóceni, rozchodzili się do domów, Paweł dodał: —Trafnie Duch Święty powiedział waszym przodkom przez proroka Izajasza: ");
INSERT INTO polsz_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","„Idź do mojego ludu i powiedz mu: Będziecie słuchać, lecz nie zrozumiecie, będziecie patrzeć, lecz nie zobaczycie. ");
INSERT INTO polsz_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ludzie ci mają twarde serca, zapchane uszy i zmrużone oczy —nic nie widzą, nic nie słyszą i niczego nie rozumieją. Dlatego nie chcą się opamiętać i zostać przeze Mnie uzdrowieni”. ");
INSERT INTO polsz_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Wiedzcie więc, że Bóg skieruje to zbawienie do pogan, a oni chętnie je przyjmą. ");
INSERT INTO polsz_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Przez dwa następne lata Paweł mieszkał w wynajętym domu, gdzie mógł przyjmować wszystkich, którzy pragnęli go odwiedzić. ");
INSERT INTO polsz_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","W ten sposób, zupełnie swobodnie i bez przeszkód, mówił ludziom o królestwie Bożym i nauczał o Jezusie Chrystusie—naszym Panu.");
INSERT INTO polsz_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Piszę do was ja, Paweł, sługa Chrystusa Jezusa, powołany na apostoła, aby głosić dobrą nowinę od Boga. ");
INSERT INTO polsz_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Zapowiadali ją już Jego prorocy w świętych księgach. ");
INSERT INTO polsz_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Jest to dobra nowina o Jego Synu, potomku króla Dawida—Jezusie Chrystusie, naszym Panu. On to, dzięki Duchowi Świętemu, przez zmartwychwstanie okazał się pełnym mocy Synem Bożym. ");
INSERT INTO polsz_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","To od Niego otrzymaliśmy łaskę i misję apostolską, aby przez wiarę doprowadzić do posłuszeństwa Mu wszystkich pogan. ");
INSERT INTO polsz_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Wśród nich jesteście i wy, powołani przez Jezusa Chrystusa. ");
INSERT INTO polsz_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Wszystkim wam, mieszkającym w Rzymie, ukochanym przez Boga, powołanym i świętym, przekazuję życzenia łaski i pokoju od Boga Ojca i naszego Pana, Jezusa Chrystusa. ");
INSERT INTO polsz_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Już na wstępie pragnę podziękować Bogu przez Jezusa Chrystusa za was wszystkich, za to, że wasza wiara jest znana na całym świecie. ");
INSERT INTO polsz_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Bóg, któremu służę całym sercem, głosząc dobrą nowinę o Jego Synu, jest mi świadkiem, że nieustannie o was myślę! ");
INSERT INTO polsz_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Stale proszę Go o to, aby jeśli taka jest Jego wola, pozwolił mi w końcu was odwiedzić. ");
INSERT INTO polsz_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Gorąco pragnę was zobaczyć i podzielić się z wami duchowym darem dla waszego umocnienia, ");
INSERT INTO polsz_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","abyśmy wzajemnie zachęcili się swoją wiarą: wy moją, a ja waszą. ");
INSERT INTO polsz_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Drodzy przyjaciele! Wiedzcie, że wiele razy zamierzałem już do was przybyć, aby i wśród was—podobnie jak wśród innych pogan—zebrać duchowy owoc, ale jak dotąd zawsze pojawiały się jakieś przeszkody. ");
INSERT INTO polsz_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Czuję się dłużnikiem Greków i nie—Greków, uczonych i niewykształconych. ");
INSERT INTO polsz_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Dlatego tak bardzo chciałbym przedstawić dobrą nowinę również wam, mieszkańcom Rzymu. ");
INSERT INTO polsz_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nie wstydzę się jej. Jest ona bowiem mocą Boga niosącą zbawienie wszystkim, którzy uwierzą: zarówno Żydom, jak i poganom. ");
INSERT INTO polsz_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Poprzez dobrą nowinę Bóg ogłosił uniewinnienie grzeszników, które bierze początek z wiary i do wiary prowadzi. Pismo mówi bowiem: „Prawy człowiek będzie żył dzięki wierze”. ");
INSERT INTO polsz_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Bóg okazuje jednak również swój gniew z powodu wszelkiego grzechu i nieprawości ludzi, którzy poprzez swoje złe czyny zaciemniają prawdę. ");
INSERT INTO polsz_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Wiedzą oni, jak można poznać Boga, bo On sam im to pokazał. ");
INSERT INTO polsz_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Od czasów stworzenia bowiem niewidzialne cechy Boga—Jego odwieczną moc i boskość—można dostrzec w Jego dziełach. Nikt więc nie może się wykręcać, mówiąc, że Go nie poznał. ");
INSERT INTO polsz_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Zatem ludzie poznali Boga, ale nie chcieli oddawać Mu czci ani dziękować. Popadli w bezsensowne rozmyślania i pogrążyli swoje serca w ciemnościach. ");
INSERT INTO polsz_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Uważając się za mądrych, w rzeczywistości stali się głupcami. ");
INSERT INTO polsz_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Zamiast oddawać cześć wiecznemu Bogu, zaczęli otaczać kultem podobizny przemijającego człowieka oraz ptaków, czworonożnych zwierząt i płazów. ");
INSERT INTO polsz_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Dlatego Bóg dopuścił, aby poddali się własnym pragnieniom i by hańbili swoje ciała. ");
INSERT INTO polsz_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bożą prawdę zamienili bowiem na kłamstwo i zaczęli czcić stworzenie zamiast Stwórcy, który jest błogosławiony na całe wieki! Amen! ");
INSERT INTO polsz_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Dlatego właśnie Bóg dopuścił, aby poddali się bezwstydnym pragnieniom. Kobiety porzuciły współżycie zgodne z naturą i zaczęły grzeszyć przeciw naturze. ");
INSERT INTO polsz_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Podobnie mężczyźni, odrzucili normalne współżycie z kobietami i zaczęli pragnąć siebie nawzajem, grzesząc z innymi mężczyznami i ponosząc na sobie samych karę, na jaką zasłużyli. ");
INSERT INTO polsz_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ponieważ ludzie nie chcieli otaczać Boga należnym Mu szacunkiem, On dopuścił, aby czynili wszystko, co tylko ich nikczemne umysły mogły wymyślić. ");
INSERT INTO polsz_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Napełnili się więc wszelką nieprawością, złem, chciwością, zachłannością, nienawiścią, dążeniem do morderstw, kłótnią, podstępem, złośliwością i plotkarstwem. ");
INSERT INTO polsz_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ludzie ci nienawidzą Boga, są zuchwali, uparci, pyszni, pomysłowi w czynieniu zła i nieposłuszni rodzicom. ");
INSERT INTO polsz_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Są głupi, podstępni, pozbawieni serca i litości dla innych. ");
INSERT INTO polsz_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Dobrze wiedzą, że ci, którzy popełniają takie przestępstwa, zgodnie z Bożym wyrokiem podlegają karze śmierci. Mimo to jednak nadal grzeszą w ten sposób a nawet popierają innych, którzy tak postępują. ");
INSERT INTO polsz_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Dlatego kimkolwiek jesteś, ty, który osądzasz innych, sam nie dasz rady się wybronić. Osądzając kogoś innego, skazujesz samego siebie, bo dopuszczasz się tych samych czynów. ");
INSERT INTO polsz_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Wiemy zaś, że Bóg sprawiedliwie ukarze każdego popełniającego te czyny. ");
INSERT INTO polsz_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","A może liczysz na to, sędzio i przestępco w jednej osobie, że unikniesz Bożego sądu? ");
INSERT INTO polsz_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Lub może lekceważysz Jego ogromną dobroć, cierpliwość i wielkoduszność? Czy nie zdajesz sobie sprawy z tego, że Bóg w swojej dobroci pragnie doprowadzić cię do opamiętania? ");
INSERT INTO polsz_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Poprzez swój upór i serce niezdolne do opamiętania skazujesz się na straszliwą karę. Nadejdzie bowiem dzień gniewu, który będzie czasem sprawiedliwego sądu Bożego. ");
INSERT INTO polsz_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Wtedy to Bóg da każdemu to, na co zasłużył. ");
INSERT INTO polsz_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Tym, którzy wytrwale czynili dobro, pragnąc doświadczyć Bożej chwały, uznania i nieśmiertelności, da życie wieczne. ");
INSERT INTO polsz_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Tym zaś, którzy sprzeciwiają się Bogu, są nieposłuszni prawdzie i idą drogą nieprawości, okaże swój gniew i oburzenie. ");
INSERT INTO polsz_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Rozpacz i cierpienie czeka każdego, kto dopuszcza się zła, bez względu na to, czy jest Żydem czy poganinem. ");
INSERT INTO polsz_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Chwała zaś, cześć i pokój będą udziałem tego, kto czyni dobro—zarówno Żyda, jak i poganina. ");
INSERT INTO polsz_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Bóg traktuje wszystkich ludzi w taki sam sposób! ");
INSERT INTO polsz_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ci, którzy zgrzeszyli nie znając Prawa Mojżesza, bez niego poniosą karę. Ci zaś, którzy zgrzeszyli znając Prawo, zostaną skazani według Prawa. ");
INSERT INTO polsz_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Uniewinnieni przed Bogiem nie są ci, którzy Prawo znają, lecz ci, którzy go przestrzegają. ");
INSERT INTO polsz_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Skoro więc poganie, którzy nie znają Prawa Mojżesza, z natury wypełniają je, stają się prawem sami dla siebie. ");
INSERT INTO polsz_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Wskazują w ten sposób, że prawe postępowanie jest zapisane w ich sercach, bo ich sumienie pokazuje im, że dany czyn jest dobry lub zły. ");
INSERT INTO polsz_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","A wszystkie ukryte działania wyjdą na jaw w dniu, w którym Bóg będzie sądził świat poprzez Jezusa Chrystusa. Jest to treść głoszonej przeze mnie dobrej nowiny. ");
INSERT INTO polsz_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Teraz kilka słów do tych z was, którzy są Żydami. Jesteście dumni z waszego pochodzenia, polegacie na Prawie, szczycicie się Bogiem, ");
INSERT INTO polsz_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","znacie Jego wolę i—pouczeni przez Prawo Mojżesza—wiecie co najlepsze. ");
INSERT INTO polsz_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Uważacie się za przewodników dla ślepych, za światło w ciemnościach tego świata, ");
INSERT INTO polsz_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","za wychowawców ludzi niemądrych i nauczycieli dzieci, bo dzięki Prawu znacie już całą prawdę. ");
INSERT INTO polsz_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Chcesz pouczać innych? A dlaczego nie siebie?! Mówisz innym, żeby nie kradli, a sam kradniesz! ");
INSERT INTO polsz_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Mówisz, żeby byli wierni w małżeństwie, a sam nie jesteś! Czujesz wstręt do posągów bożków, a obrażasz Boga? ");
INSERT INTO polsz_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Jesteś dumny ze znajomości Prawa, a łamiąc je znieważasz Boga! ");
INSERT INTO polsz_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Nic więc dziwnego, że Pismo mówi: „To z waszego powodu poganie bluźnią przeciwko Bogu”. ");
INSERT INTO polsz_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Znak obrzezania to przywilej, o ile przestrzegasz Prawa Mojżesza. Jeśli jednak je łamiesz, nie ma on żadnego znaczenia. ");
INSERT INTO polsz_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","A jeżeli nieobrzezany poganin przestrzegałby Prawa, to czy nie zostanie potraktowany jak obrzezany Żyd? ");
INSERT INTO polsz_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","I wtedy taki nieobrzezany poganin, przestrzegający Prawa, będzie sądzić ciebie, obrzezanego i znającego Prawo Żyda, który nie przestrzega Bożych nakazów. ");
INSERT INTO polsz_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Prawdziwym Żydem nie jest bowiem ten, kto jest nim na zewnątrz. A prawdziwym obrzezaniem nie jest to, które jest widoczne na ciele. ");
INSERT INTO polsz_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Prawdziwym Żydem jest ten, kto jest nim wewnątrz, a prawdziwym obrzezaniem jest przemiana serca, dokonująca się dzięki Duchowi, a nie literze Prawa. Taki człowiek podoba się Bogu i nie potrzebuje pochwały od ludzi. ");
INSERT INTO polsz_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Na czym więc polega przewaga Żyda nad poganinem? I jaką korzyść daje obrzezanie? ");
INSERT INTO polsz_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ogromną i to pod każdym względem! Należy pamiętać, że to Żydom Bóg przekazał swoje słowa. ");
INSERT INTO polsz_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Co z tego, że niektórzy z nich nie dochowali im wierności? Czy z tego powodu Bóg przestaje dotrzymywać swoich obietnic? ");
INSERT INTO polsz_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Oczywiście, że nie! Bóg bowiem jest prawdomówny, a każdy człowiek jest kłamcą, jak mówi Pismo: „Boże, Twoje słowa okażą się sprawiedliwe i oddalisz od siebie wszelkie oskarżenia”. ");
INSERT INTO polsz_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Jeśli poprzez naszą nieprawość objawiona zostaje prawość Boga, to jaki stąd wniosek? Czy Bóg jest niesprawiedliwy, gdy okazuje gniew? Tak rozumują ludzie. ");
INSERT INTO polsz_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Oczywiście, że nie jest niesprawiedliwy, bo gdyby tak było, to jak Bóg mógłby sądzić świat? ");
INSERT INTO polsz_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Zapytasz może: „Skoro moje kłamstwo sprawia, że objawiona zostaje Boża prawda i Bóg odbiera z tego chwałę, to dlaczego ja mam być sądzony za grzech?”. ");
INSERT INTO polsz_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Czy mamy twierdzić: „Popełniajmy zło, aby pojawiło się dobro”? Niektórzy oskarżają nas, że tak mówimy. Nie unikną jednak kary. ");
INSERT INTO polsz_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Czy wobec tego my, Żydzi, jesteśmy lepsi od pogan? Oczywiście, że nie. Wykazaliśmy już, że zarówno Żydzi, jak i poganie, są grzesznikami. ");
INSERT INTO polsz_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Potwierdza to zresztą Pismo: „Nie ma człowieka, który byłby prawy, ");
INSERT INTO polsz_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","nie ma takiego, który byłby rozumny, ani takiego, który szukałby Boga. ");
INSERT INTO polsz_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Wszyscy zbłądzili i upadli. Nie ma nikogo, ani jednego, kto by dobrze postępował. ");
INSERT INTO polsz_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Słowa ludzi są jak grób, a ich język jest pełen kłamstw; w ustach mają jad węża. ");
INSERT INTO polsz_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Wypowiadają przekleństwa i gorzkie słowa. ");
INSERT INTO polsz_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Są skłonni do morderstwa, ");
INSERT INTO polsz_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","zostawiają za sobą zniszczenie i nędzę. ");
INSERT INTO polsz_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Nigdy nie weszli na ścieżkę pokoju ");
INSERT INTO polsz_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","i nie odczuwają nawet lęku przed Bogiem”. ");
INSERT INTO polsz_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Wiemy dobrze, że Prawo Mojżesza obowiązuje tych, którzy mu podlegają. I dlatego każde usta muszą zamilknąć i cały świat musi się uniżyć przed Bogiem. ");
INSERT INTO polsz_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","On bowiem nie uniewinni żadnego człowieka ze względu na to, że przestrzegał on Prawa Mojżesza. Prawo uświadamia nam tylko nasz grzech. ");
INSERT INTO polsz_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Teraz jednak Bóg wskazał inny sposób uniewinnienia—bez przestrzegania Prawa Mojżesza, ale poświadczony przez to Prawo i przez proroków. ");
INSERT INTO polsz_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Uniewinnienie to pochodzi od Boga i obejmuje tych, którzy wierzą Jezusowi Chrystusowi. Jest ono dostępne dla wszystkich, którzy Mu wierzą. Bo nie ma żadnej różnicy: ");
INSERT INTO polsz_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","wszyscy ludzie zgrzeszyli i daleko im do Bożego ideału. ");
INSERT INTO polsz_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","A zostają uniewinnieni za darmo, dzięki Bożej łasce i dzięki odkupieniu, jakiego dokonał Jezus Chrystus. ");
INSERT INTO polsz_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","To Jego Bóg uczynił narzędziem przebłagania za grzechy. Aby dostąpić tego uniewinnienia, musimy uwierzyć, że Jego przelana krew może nas pojednać z Bogiem. Bóg ogłosił uniewinnienie, odpuszczając grzechy przeszłości. Cierpliwie czekał bowiem, aż Chrystus—w obecnym czasie—zgładzi je. Okazał się więc sprawiedliwy i uniewinnia każdego, kto uwierzy Jezusowi. ");
INSERT INTO polsz_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Gdzie jest więc powód do dumy? Został uchylony! Czy przez Prawo uczynków? Nie, przez prawo wiary! ");
INSERT INTO polsz_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Jesteśmy bowiem przekonani, że człowiek zostaje uniewinniony dzięki wierze, a nie dzięki spełnianiu uczynków wymaganych przez Prawo. ");
INSERT INTO polsz_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Czy Bóg przygotował to tylko dla Żydów? A może i dla pogan? Oczywiście, że również dla pogan! ");
INSERT INTO polsz_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Bóg jest jeden i w ten sam sposób—dzięki wierze!—uniewinnia zarówno Żydów, jak i pogan. ");
INSERT INTO polsz_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Czy więc z powodu uniewinnienia, otrzymanego dzięki wierze, lekceważymy Prawo Mojżesza? Absolutnie nie! Umieszczamy je tylko we właściwym miejscu. ");
INSERT INTO polsz_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Jak wyglądała ta sprawa w przypadku Abrahama, naszego przodka? ");
INSERT INTO polsz_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Jeśli został uniewinniony na podstawie swoich czynów, to ma powód do dumy—ale nie przed Bogiem! ");
INSERT INTO polsz_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Co o tym mówi Pismo? Czytamy w nim: „Abraham uwierzył Bogu i został uniewinniony”. ");
INSERT INTO polsz_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Pracownikowi należy się zapłata za pracę—bez żadnej łaski. ");
INSERT INTO polsz_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","W przypadku zaś tego, kto nie pracuje, ale wierzy Bogu, który uniewinnia grzesznika, właśnie jego wiara jest podstawą do uniewinnienia. ");
INSERT INTO polsz_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Król Dawid tak opisał szczęście człowieka, którego Bóg uniewinnił niezależnie od uczynków: ");
INSERT INTO polsz_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","„Szczęśliwi są ci, którym przebaczono grzechy i zapomniano przewinienia. ");
INSERT INTO polsz_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Szczęśliwy jest człowiek, któremu Pan nie wypomni grzechów”. ");
INSERT INTO polsz_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Czy to szczęście dotyczy tylko obrzezanych, czy również nieobrzezanych? Powiedzieliśmy już, że: „Abraham uwierzył Bogu i został uniewinniony”. ");
INSERT INTO polsz_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Kiedy to się wydarzyło? Przed czy po jego obrzezaniu? Oczywiście, że przed! ");
INSERT INTO polsz_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Obrzezanie otrzymał jako dowód uniewinnienia dzięki wierze—gdy był jeszcze nieobrzezany. W ten sposób stał się duchowym ojcem tych, którzy przyjmują Boże uniewinnienie jako nieobrzezani, ");
INSERT INTO polsz_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","oraz tych, którzy są obrzezani, ale nie opierają się na tym, bo mają także wiarę, którą okazał Abraham. ");
INSERT INTO polsz_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Bóg obiecał Abrahamowi i jego potomkom, że da im w posiadanie całą ziemię. Obietnica ta nie była jednak uzależniona od wypełniania Prawa, ale wynikała z uniewinnienia Abrahama dzięki wierze. ");
INSERT INTO polsz_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Jeśliby wypełnienie tej obietnicy zależałoby od przestrzegania Prawa, to wiara Abrahama straciłaby sens, a obietnica stałaby się pusta. ");
INSERT INTO polsz_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Prawo wiąże się z karą, a tam, gdzie nie ma Prawa, nie ma i przestępstwa. ");
INSERT INTO polsz_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Dlatego obietnica dla wszystkich potomków Abrahama wypływa z wiary oraz łaski od Boga. Dotyczy ona nie tylko tego, który przestrzega Prawa, ale i tego, kto wierzy Bogu, podobnie jak Abraham, nasz wspólny przodek. ");
INSERT INTO polsz_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Bóg powiedział bowiem o nim: „Uczyniłem cię ojcem wielu narodów”. Abraham uwierzył Bogu jako Temu, który ożywia umarłych i powołuje do istnienia to, czego nie ma. ");
INSERT INTO polsz_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Nie mając dowodów na to, że tak się stanie, Abraham uwierzył, że będzie ojcem wielu narodów. Powiedziano Mu bowiem: „Takie właśnie będzie twoje potomstwo”. ");
INSERT INTO polsz_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Nie stracił wiary, choć widział, że on sam się starzeje—miał już wtedy bowiem prawie sto lat—i że Sara nie może już mieć dzieci. ");
INSERT INTO polsz_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ani przez chwilę nie zwątpił jednak w Bożą obietnicę. Przeciwnie, jego wiara wzrosła, przynosząc chwałę Bogu. ");
INSERT INTO polsz_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Był przekonany, że Bóg jest w stanie spełnić to, co obiecał. ");
INSERT INTO polsz_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","I właśnie dzięki temu został przez Niego uniewinniony. ");
INSERT INTO polsz_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Te wspaniałe Boże słowa o uniewinnieniu zostały skierowane nie tylko do niego, ");
INSERT INTO polsz_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ale także do nas, którzy dostąpiliśmy uniewinnienia dzięki temu, że uwierzyliśmy Bogu, który wskrzesił Jezusa, naszego Pana. ");
INSERT INTO polsz_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","On został wydany za nasze grzechy i zmartwychwstał, aby nas uniewinnić. ");
INSERT INTO polsz_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Teraz więc, gdy dzięki wierze zostaliśmy uniewinnieni przez Boga, żyjemy z Nim w pokoju. Stało się to możliwe dzięki naszemu Panu, Jezusowi Chrystusowi. ");
INSERT INTO polsz_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Tylko dzięki Niemu—przez wiarę—dostąpiliśmy Bożej łaski! Ona postawiła nas na nogi i daje radość z oczekiwania na Bożą chwałę. ");
INSERT INTO polsz_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ale to nie wszystko! Jesteśmy również dumni ze spotykających nas trudności. Wiemy bowiem, że uczą nas one wytrwałości, ");
INSERT INTO polsz_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","która owocuje wypróbowanym charakterem. On z kolei utrwala naszą nadzieję. ");
INSERT INTO polsz_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","A nadzieja ta jest niezawodna, bo opiera się na miłości samego Boga, którą Duch Święty—zesłany nam przez Boga—wlał w nasze serca. ");
INSERT INTO polsz_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Jako grzesznicy nie mieliśmy przed Bogiem żadnych szans, jednak Chrystus w wyznaczonym przez Boga czasie umarł za nas. ");
INSERT INTO polsz_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Nam trudno byłoby oddać życie nawet za kogoś szlachetnego. Być może chętniej oddalibyśmy je za kogoś bardzo dobrego. ");
INSERT INTO polsz_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ale Bóg dał dowód swojej wielkiej miłości do nas: Chrystus oddał za nas życie, gdy byliśmy jeszcze grzesznikami! ");
INSERT INTO polsz_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Jeśli więc dzięki Jego przelanej krwi zostaliśmy uniewinnieni, to tym bardziej ocali nas ona przed gniewem Boga. ");
INSERT INTO polsz_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Skoro jako wrogowie Boga zostaliśmy z Nim pojednani przez śmierć Jego Syna, to tym bardziej będziemy uratowani dzięki Jego życiu! ");
INSERT INTO polsz_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ale to nie wszystko! Możemy teraz być dumni z naszego Boga, który pojednał nas ze sobą przez Jezusa Chrystusa, naszego Pana. ");
INSERT INTO polsz_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Z powodu jednego tylko człowieka, Adama, grzech wdarł się na świat, a wraz z nim śmierć. W ten sposób śmierć przeszła na wszystkich ludzi, bo wszyscy zgrzeszyli. ");
INSERT INTO polsz_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Grzech był obecny jeszcze przed ustanowieniem Prawa Mojżesza, ale tam, gdzie nie ma Prawa, nie można stwierdzić grzechu. ");
INSERT INTO polsz_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Śmierć zapanowała nad wszystkimi ludźmi—od Adama do Mojżesza—nawet nad tymi, którzy nie zgrzeszyli tak jak Adam, będący pod pewnym względem zapowiedzią Chrystusa. ");
INSERT INTO polsz_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Istnieje jednak ogromna różnica pomiędzy grzechem a Bożym darem. Z powodu grzechu jednego człowieka wszyscy ludzie dostali się pod panowanie śmierci. Tym bardziej więc łaska Boga i jej dar przyniosą wspaniały owoc w życiu wszystkich ludzi, a stanie się to dzięki jednemu Człowiekowi—Jezusowi Chrystusowi. ");
INSERT INTO polsz_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Jeden grzech Adama sprowadził karę śmierci na mnóstwo ludzi, natomiast Chrystus usuwa grzechy i daje nam wieczne życie. ");
INSERT INTO polsz_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Z powodu grzechu jednego człowieka śmierć zapanowała nad wszystkimi ludźmi. Tym bardziej więc ci, którzy przyjmują Boże przebaczenie i uniewinnienie, staną się królami życia dzięki jednemu tylko Człowiekowi—Jezusowi Chrystusowi. ");
INSERT INTO polsz_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Grzech jednego ściągnął na wszystkich potępienie. Dlatego prawość Jednego przynosi wszystkim uniewinnienie. ");
INSERT INTO polsz_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Przez nieposłuszeństwo jednego mnóstwo ludzi stało się grzesznikami. Dzięki posłuszeństwu Jednego mnóstwo zostanie uniewinnionych. ");
INSERT INTO polsz_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Natomiast Prawo Mojżesza zostało ustanowione po to, aby uwidocznić grzech. Tam zaś, gdzie się uwidocznił grzech, jeszcze bardziej objawiła się Boża łaska. ");
INSERT INTO polsz_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Grzech zapanował nad wszystkimi ludźmi, niosąc śmierć. Natomiast Boża łaska przyniosła ludziom uniewinnienie i życie wieczne w Jezusie Chrystusie, naszym Panu. ");
INSERT INTO polsz_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Czy wobec tego mamy nadal grzeszyć, aby łaska stała się bardziej widoczna? ");
INSERT INTO polsz_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Oczywiście, że nie! Skoro umarliśmy dla grzechu, to jak możemy nadal w nim żyć? ");
INSERT INTO polsz_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Czy nie rozumiecie tego, że gdy przyjmując chrzest utożsamiliśmy się z Chrystusem Jezusem, zjednoczyliśmy się z Nim również w Jego śmierci? ");
INSERT INTO polsz_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Przez chrzest zostaliśmy razem z Nim pogrzebani, zanurzając się w Jego śmierci. A skoro Bóg Ojciec swoją potężną mocą wzbudził Jezusa do życia, to również my powinniśmy żyć nowym życiem. ");
INSERT INTO polsz_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Skoro zostaliśmy złączeni z Jezusem w śmierci, to będziemy z Nim złączeni również w zmartwychwstaniu. ");
INSERT INTO polsz_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Pamiętajmy o tym, że nasze dawne życie zostało wraz z Jezusem przybite do krzyża, a nasza grzeszna natura została obezwładniona, abyśmy już nie służyli grzechowi. ");
INSERT INTO polsz_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kto umiera, staje się wolny od grzechu. ");
INSERT INTO polsz_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Skoro więc umarliśmy z Chrystusem, to wierzymy, że razem z Nim będziemy żyli. ");
INSERT INTO polsz_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Wiemy bowiem, że Jezus, powstawszy z martwych, już nigdy nie umrze—śmierć nie ma nad Nim żadnej władzy. ");
INSERT INTO polsz_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Umarł tylko raz, aby pokonać grzech, a teraz żyje dla Boga. ");
INSERT INTO polsz_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Dlatego wy również uważajcie siebie za martwych dla grzechu, a żyjących dla Boga, dzięki Chrystusowi Jezusowi. ");
INSERT INTO polsz_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Niech więc grzech nie panuje już nad waszym doczesnym ciałem—nie poddawajcie się grzesznym pragnieniom! ");
INSERT INTO polsz_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Nie czyńcie z żadnej części ciała narzędzia grzechu, lecz całkowicie powierzcie się Bogu! Byliście martwi, a ożyliście, więc niech całe wasze ciało będzie teraz narzędziem działania Boga. ");
INSERT INTO polsz_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Grzech nie musi być już dłużej waszym władcą, gdyż nie podlegacie przepisom Prawa Mojżesza, lecz Bożej łasce. ");
INSERT INTO polsz_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Czy zatem możemy swobodnie grzeszyć, dlatego że nie podlegamy Prawu, ale łasce? W żadnym wypadku! ");
INSERT INTO polsz_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Czy nie wiecie, że jesteście zależni od tego, komu służycie? Albo wybieracie grzech i śmierć, albo posłuszeństwo i prawość. ");
INSERT INTO polsz_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Dziękuję Bogu za to, że chociaż kiedyś byliście niewolnikami grzechu, całym sercem przyjęliście przekazaną wam Bożą naukę. ");
INSERT INTO polsz_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","I zostaliście uwolnieni spod władzy grzechu, aby teraz być niewolnikami prawości. ");
INSERT INTO polsz_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Pozwólcie, że tak to wyjaśnię: Kiedyś różne części ciała traktowaliście jak niewolników spełniających wasze grzeszne pragnienia. Teraz jednak wykorzystujcie je jako niewolników wykonujących to, co słuszne i święte. ");
INSERT INTO polsz_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Będąc w niewoli zła, nie musieliście postępować w sposób dobry i prawy. ");
INSERT INTO polsz_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ale jaki był skutek waszych czynów, których teraz tak się wstydzicie? Wieczna śmierć! ");
INSERT INTO polsz_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Jako uwolnieni spod władzy grzechu jesteście poddanymi Boga, a to doprowadzi was do świętości i wiecznego życia. ");
INSERT INTO polsz_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Zapłatą za grzech jest śmierć, ale Bóg darował nam życie wieczne w Jezusie Chrystusie, naszym Panu! ");
INSERT INTO polsz_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Przyjaciele! Dobrze znacie Prawo Mojżesza. Czy nie wiecie więc, że obowiązuje ono człowieka tylko za życia? ");
INSERT INTO polsz_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Dlatego zamężna kobieta, zgodnie z Prawem, związana jest z mężem aż do śmierci. Jeśli jednak jej małżonek umrze, w świetle Prawa przestaje być mężatką. ");
INSERT INTO polsz_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Gdyby za jego życia chciała zmienić męża, dopuściłaby się grzechu niewierności małżeńskiej. Jeśli jednak on umrze, jest wolna i zgodnie z Prawem może powtórnie wyjść za mąż—bez narażania się na grzech niewierności. ");
INSERT INTO polsz_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Wy właśnie, moi przyjaciele, będąc częścią ciała Chrystusa, umarliście dla Prawa, aby żyć dla Tego, który zmartwychwstał, i aby wydawać w życiu duchowe owoce dla Boga. ");
INSERT INTO polsz_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Gdy żyliśmy dla naszego grzesznego ciała, Prawo pobudzało nas do grzechu, co z kolei prowadziło nas do śmierci. ");
INSERT INTO polsz_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ale teraz nie podlegamy Prawu, bo jesteśmy dla niego martwi. Możemy więc służyć Bogu jako nowi ludzie, poddający się Duchowi, a nie jak dawniej, zgodnie z samą literą Prawa. ");
INSERT INTO polsz_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Czy można zatem powiedzieć, że Prawo Mojżesza jest grzeszne? Ależ skąd! Gdyby nie ono, nie zrozumiałbym czym jest grzech. Nie wiedziałbym nawet, czym jest grzeszne pragnienie, gdyby Prawo nie mówiło: „Nie pożądaj”. ");
INSERT INTO polsz_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ale sprytny grzech dzięki przykazaniu wzbudził we mnie grzeszne pragnienia. Bez Prawa bowiem grzech jest martwy. ");
INSERT INTO polsz_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Kiedyś żyłem nie podlegając Prawu. Gdy jednak poznałem przykazania, grzech we mnie ożył, ");
INSERT INTO polsz_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","a ja umarłem. Przykazania, które odkryłem, zamiast dać mi życie, doprowadziły mnie do śmierci. ");
INSERT INTO polsz_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Grzech oszukał mnie, wykorzystując przykazanie, i doprowadził mnie do śmierci! ");
INSERT INTO polsz_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ale Prawo samo w sobie pozostało święte, tak jak święte, słuszne i dobre są jego przykazania. ");
INSERT INTO polsz_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Czy zatem to, co dobre, doprowadziło mnie do śmierci? Absolutnie nie! To grzech, ujawniając swoją naturę, zadał mi śmierć przez to, co jest dobre. W ten sposób, dzięki przykazaniu, wyszła na jaw jego przewrotność. ");
INSERT INTO polsz_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Wiemy więc, że Prawo Mojżesza dotyczy ducha, a ja jestem istotą cielesną i niewolnikiem grzechu. ");
INSERT INTO polsz_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Zupełnie nie rozumiem siebie i tego, co czynię. Nie robię bowiem tego, co chcę, ale to, czego nienawidzę! ");
INSERT INTO polsz_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Jeśli robię więc coś, czego nie chcę, to przyznaję Prawu rację, ");
INSERT INTO polsz_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","bo to nie ja tak postępuję, ale mieszkający we mnie grzech. ");
INSERT INTO polsz_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Wiem, że we mnie, to znaczy w moim ciele, nie mieszka dobro. Pragnę postępować dobrze, ale nie potrafię tego wykonać! ");
INSERT INTO polsz_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Nie czynię dobra, którego pragnę, ale popełniam zło, którego nie chcę! ");
INSERT INTO polsz_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Jeśli robię więc to, czego nie chcę, znaczy to, że nie ja to czynię, ale mieszkający we mnie grzech. ");
INSERT INTO polsz_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Widzę więc taką prawidłowość: chcę dobra, a narzuca mi się zło. ");
INSERT INTO polsz_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","W głębi serca Boże Prawo sprawia mi radość. ");
INSERT INTO polsz_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Natomiast w moim ciele dostrzegam inne prawo, które walczy z moim umysłem i zwycięża, czyniąc ze mnie niewolnika grzechu. ");
INSERT INTO polsz_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Marny mój los! Kto mnie wyrwie z tego śmiertelnego ciała? ");
INSERT INTO polsz_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Dzięki niech będą Bogu, który posłał Jezusa Chrystusa, naszego Pana! Podsumowując więc: Umysłem służę Prawu Bożemu, a ciałem—prawu grzechu. ");
INSERT INTO polsz_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Teraz żadne potępienie nie grozi już tym, którzy należą do Chrystusa Jezusa. ");
INSERT INTO polsz_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Prawo Ducha, prowadzące do życia i darowane mi przez Jezusa, wyzwoliło mnie z bezradności wobec prawa grzechu i śmierci. ");
INSERT INTO polsz_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Właśnie tę nieskuteczność Prawa, wypływającą ze słabości ciała, pokonał Bóg. Posłał On własnego Syna, podobnego do grzesznego człowieka, i położył kres panowaniu grzechu. ");
INSERT INTO polsz_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","W ten sposób możemy być posłuszni nakazom Prawa, bo poddajemy się Duchowi Świętemu, nie zaś bezsilnemu ciału. ");
INSERT INTO polsz_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ci, którzy żyją zgodnie z ludzką naturą, myślą tylko o tym, jak zaspokoić swoje ludzkie pragnienia. Ci zaś, którzy są posłuszni Duchowi Świętemu, myślą o rzeczach duchowych. ");
INSERT INTO polsz_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Poddawanie się ludzkim pragnieniom prowadzi do śmierci. Posłuszeństwo Duchowi prowadzi natomiast do prawdziwego życia i pokoju. ");
INSERT INTO polsz_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Dążenia ciała i ludzkiej natury są przeciwne Bogu—nie poddają się Jego Prawu ani nawet nie są w stanie tego zrobić. ");
INSERT INTO polsz_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Dlatego ci, którzy żyją realizując tylko swoje ludzkie pragnienia, nie mogą podobać się Bogu. ");
INSERT INTO polsz_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Wy jednak nie żyjecie po to, aby zaspokajać swoje ludzkie pragnienia, bo mieszka w was Duch Boga. Jeżeli zaś w kimś nie ma Ducha Chrystusa, ten w ogóle do Niego nie należy. ");
INSERT INTO polsz_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Jeśli jednak macie w sobie Chrystusa, to chociaż ciało jest martwe z powodu grzechu, wasz duch jest żywy dzięki temu, że zostaliście uniewinnieni przez Jezusa. ");
INSERT INTO polsz_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Jeśli przebywa w was Duch Boga, który wskrzesił Jezusa z martwych, to i wasze śmiertelne ciała zostaną ożywione mocą tego samego Ducha. ");
INSERT INTO polsz_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","13","Przyjaciele, nie musicie poddawać się waszym grzesznym pragnieniom. Takie życie nieuchronnie prowadzi do śmierci. Ale jeśli dzięki mocy Ducha stawiacie opór grzesznym pragnieniom waszego ciała, będziecie żyli. ");
INSERT INTO polsz_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ci bowiem, których prowadzi Duch Boga, są jego dziećmi. ");
INSERT INTO polsz_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Nie staliście się przecież zastraszonymi niewolnikami Boga, lecz otrzymaliście Ducha, który uczynił was Jego dziećmi! Dzięki temu możecie zwracać się do Boga, mówiąc: „Abba, Tato!”. ");
INSERT INTO polsz_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","To właśnie Duch Święty daje nam tę pewność, że naprawdę jesteśmy dziećmi Boga. ");
INSERT INTO polsz_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","A skoro jesteśmy Jego dziećmi, to i dziedzicami: dziedzicami Boga, a współdziedzicami z Chrystusem. Bo jeśli razem z Nim cierpimy, to razem z Nim będziemy otoczeni chwałą. ");
INSERT INTO polsz_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Obecne cierpienia są jednak niczym w porównaniu z chwałą, jaka nas czeka. ");
INSERT INTO polsz_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Całe stworzenie tęskni bowiem za dniem wspaniałego objawienia się dzieci Boga. ");
INSERT INTO polsz_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Wbrew swojej woli, ale z woli Boga, doświadcza ono skutków grzechu. ");
INSERT INTO polsz_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Ma jednak nadzieję, że i ono zostanie uwolnione od przekleństwa śmierci i będzie żyć w wolności i chwale dzieci Boga. ");
INSERT INTO polsz_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Wiemy bowiem, że po dziś dzień nawet przyroda ciężko wzdycha i doznaje bólów rodzenia. ");
INSERT INTO polsz_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Zresztą i my, wierzący, choć posiadamy Ducha Świętego jako przedsmak przyszłej chwały, również ciężko wzdychamy, czekając na dzień pełnego wejścia do Bożej rodziny i na odkupienie naszych ciał! ");
INSERT INTO polsz_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Zostaliśmy bowiem zbawieni z nadzieją na przyszłość. A tego, na co się z nadzieją czeka, jeszcze nie widać. Jeśli zaś coś już jest i to widać, to po co na to czekać? ");
INSERT INTO polsz_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Jeżeli więc mamy nadzieję na coś, czego jeszcze nie widać, to oczekujmy tego wytrwale! ");
INSERT INTO polsz_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Duch Święty przychodzi nam z pomocą w pokonywaniu naszych słabości. Często nie wiemy bowiem, o co i jak się modlić. Ale Duch ponad miarę wstawia się za nami w westchnieniach, których nie można wyrazić słowami. ");
INSERT INTO polsz_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ojciec, który zna serca wszystkich ludzi, zna zamiary Ducha i wie, że wstawia się On za świętymi zgodnie z Jego wolą. ");
INSERT INTO polsz_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Wiemy, że Bóg kieruje wszystkim tak, aby działało to na korzyść tych, którzy Go kochają i którzy zgodnie z Jego wolą zostali powołani. ");
INSERT INTO polsz_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Tych bowiem, których poznał już przed wiekami, przeznaczył do tego, aby stali się podobni do Jego Syna, który jest pierwszym wśród dzieci Boga. ");
INSERT INTO polsz_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Tych zaś, których dla siebie przeznaczył, tych również powołał, uniewinnił i otoczył swoją chwałą. ");
INSERT INTO polsz_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Co tu dużo mówić. Jeśli Bóg jest po naszej stronie, to co z tego, że ktoś jest przeciwko nam? ");
INSERT INTO polsz_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Czy Ten, który nie oszczędził nawet własnego Syna, lecz poświęcił Go dla nas wszystkich, mógłby nam czegokolwiek odmówić? ");
INSERT INTO polsz_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Kto może oskarżyć wybrańców samego Boga? Przecież Bóg nas uniewinnił! ");
INSERT INTO polsz_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Kto może nas potępić? Przecież Jezus Chrystus za nas umarł, zmartwychwstał, a potem zasiadł po prawej stronie Boga Ojca i wstawia się za nami! ");
INSERT INTO polsz_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kto może nas oddzielić od miłości Chrystusa? Jakieś kłopoty, klęski, prześladowania, głód, niedostatek, niebezpieczeństwa, groźba śmierci? ");
INSERT INTO polsz_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Pismo mówi: „Z Twojego powodu przez cały dzień usiłują nas zabić, traktują nas jak owce przeznaczone na rzeź”. ");
INSERT INTO polsz_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","My jednak przezwyciężamy te wszystkie przeszkody dzięki Temu, który tak bardzo nas ukochał. ");
INSERT INTO polsz_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Jestem bowiem pewien, że ani śmierć, ani życie, ani aniołowie, ani żadne duchowe moce, ani teraźniejszość, ani przyszłość, ");
INSERT INTO polsz_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ani to, co wywyższone, ani to, co poniżone, ani żadne inne stworzenie nie jest w stanie oddzielić nas od miłości Boga, objawionej w Chrystusie Jezusie, naszym Panu. ");
INSERT INTO polsz_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Stojąc przed obliczem Chrystusa, chcę zgodnie z prawdą i bez kłamstwa, z czystym sumieniem i w Duchu Świętym, powiedzieć, ");
INSERT INTO polsz_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","że noszę w sercu głęboki smutek i ból. ");
INSERT INTO polsz_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Nawet sam chciałbym być odłączony od Chrystusa, gdyby to pomogło moim rodakom, ");
INSERT INTO polsz_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Izraelitom! To ich właśnie wybrał Bóg, otoczył ich chwałą, zawarł z nimi przymierze, przekazał im Prawo, pokazał, jak mają Mu służyć, i dał tak wiele obietnic. ");
INSERT INTO polsz_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Ich przodkowie kochali Boga i z tego narodu pochodzi Chrystus—Ten, który jest ponad wszystkim, Bóg uwielbiony na wieki. Amen! ");
INSERT INTO polsz_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Boże obietnice się spełniły. Nie wszyscy bowiem, którzy pochodzą z Izraela, są prawdziwymi Izraelitami. ");
INSERT INTO polsz_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","I nie każdy potomek Abrahama jest rzeczywiście jego dzieckiem—Bóg uznał bowiem za jego potomków tylko tych, którzy pochodzą od jego syna Izaaka. ");
INSERT INTO polsz_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Oznacza to, że nie wszystkie dzieci Abrahama są dziećmi Boga, a jedynie te, które urodziły się zgodnie ze złożoną wcześniej Bożą obietnicą. ");
INSERT INTO polsz_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Brzmiała ona tak: „Za rok o tej porze Sara będzie miała syna”. ");
INSERT INTO polsz_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Również Rebeka, żona naszego przodka Izaaka, urodziła chłopców—bliźniaków. ");
INSERT INTO polsz_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Ale zanim się jeszcze urodzili i zanim cokolwiek zrobili—dobrego czy złego—Bóg okazał swoją wolę i wybór, ");
INSERT INTO polsz_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","niezależny od ludzkich czynów. Powiedział Rebece: „Starszy brat będzie służył młodszemu”. ");
INSERT INTO polsz_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Czytamy w Piśmie: „Ukochałem Jakuba, a odrzuciłem Ezawa”. ");
INSERT INTO polsz_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Jaki z tego wniosek? Czy Bóg jest niesprawiedliwy? Absolutnie nie! ");
INSERT INTO polsz_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Powiedział przecież Mojżeszowi: „Komu chcę, okazuję miłość, a komu chcę, okazuję litość”. ");
INSERT INTO polsz_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Wybór zależy więc nie od tego, który go pragnie lub się o niego stara, ale od Boga, który okazuje łaskę. ");
INSERT INTO polsz_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Czytamy przecież w Piśmie, że Bóg powiedział faraonowi: „Powołałem cię po to, aby pokazać ci moją moc i aby poznał Mnie cały świat”. ");
INSERT INTO polsz_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Bóg okazuje więc miłość temu, komu chce, a tego, kogo zechce, czyni upartym. ");
INSERT INTO polsz_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Wiem, że zaraz powiesz: „Dlaczego więc Bóg ma do ludzi pretensje o to, że zachowują się tak, a nie inaczej? Czy ludzie mogą sprzeciwiać się Jego decyzjom?”. ");
INSERT INTO polsz_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Człowieku! Nawet nie pytaj w ten sposób! Kim jesteś, żeby krytykować Boga? Czy gliniany garnek może powiedzieć garncarzowi: „Dlaczego mnie takim ulepiłeś?”. ");
INSERT INTO polsz_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Czy garncarz nie ma prawa z tej samej gliny ulepić naczynia na specjalne okazje i naczynia do użytku codziennego? ");
INSERT INTO polsz_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Bóg, chcąc okazać swój gniew i ogromną moc, cierpliwie znosił ludzi przeznaczonych na gniew i zmierzających do zagłady. ");
INSERT INTO polsz_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Ma też prawo wyrazić swoją dobroć tym, z których uczynił naczynia do przechowywania bogactw swojej chwały. ");
INSERT INTO polsz_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Powołał nas nie tylko spośród Żydów, ale i spośród pogan. ");
INSERT INTO polsz_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Dawno temu, zapowiedział bowiem przez proroka Ozeasza: „Nazwę swoim ludem tych, którzy nie należeli do Mnie, i pokocham tych, którzy nie byli kochani”. ");
INSERT INTO polsz_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Pismo mówi także: „Kiedyś mówiono wam, że nie jesteście moim ludem. Teraz zaś zostaniecie nazwani, dziećmi żywego Boga”. ");
INSERT INTO polsz_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Również prorok Izajasz zapowiedział: „Choćby liczba potomków Izraela była tak wielka, jak ilość ziaren piasku nad morzem, to tylko garstka zostanie ocalona. ");
INSERT INTO polsz_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Pan szybko wykona na ziemi swój wyrok i sprawiedliwie zakończy swoje dzieło”. ");
INSERT INTO polsz_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","W innym miejscu Izajasz powiedział: „Gdyby Pan nieba nie pozostawił z nas garstki, zostalibyśmy wytraceni jak mieszkańcy Sodomy, i spotkałaby nas ta sama kara, co mieszkańców Gomory”. ");
INSERT INTO polsz_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Jaki więc płynie z tego wniosek? Taki, że chociaż poganie nie zabiegali o uniewinnienie przez Boga, otrzymali je—przez wiarę. ");
INSERT INTO polsz_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Izrael zaś, pragnąc uzyskać uniewinnienie dzięki Prawu Mojżesza, nie osiągnął go. ");
INSERT INTO polsz_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Dlaczego? Bo czynił to nie przez wiarę, ale przez uczynki. Potknęli się o „kamień obrazy”, ");
INSERT INTO polsz_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","o którym Pismo mówi: „Kładę na górze Syjon kamień obrazy i skałę, o którą wielu się potknie. Ten jednak, kto mu uwierzy, nie zawiedzie się”. ");
INSERT INTO polsz_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Przyjaciele, z całego serca pragnę i błagam Boga o zbawienie dla Izraelitów. ");
INSERT INTO polsz_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Mogę zaświadczyć, że z zapałem chcą służyć Bogu, ale brakuje im właściwego rozeznania. ");
INSERT INTO polsz_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Nie rozpoznali bowiem uniewinnienia zaoferowanego im przez Boga, a chcąc osiągnąć je własnymi siłami, nie przyjęli tego, co dał im Bóg. ");
INSERT INTO polsz_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","A przecież Chrystus jest uwieńczeniem Prawa Mojżesza i to On uniewinnia każdego, kto Mu wierzy. ");
INSERT INTO polsz_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mojżesz tak napisał o uniewinnieniu płynącym z Prawa: „Kto je wypełni, będzie dzięki niemu żyć”. ");
INSERT INTO polsz_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Uniewinnienie pochodzące z wiary wyraża się natomiast w słowach: „Nie pytaj, kto może wstąpić do nieba”—aby sprowadzić Chrystusa na ziemię, ");
INSERT INTO polsz_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","oraz: „Nie pytaj, kto może zejść do otchłani”—aby wyprowadzić Chrystusa spośród umarłych. ");
INSERT INTO polsz_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Uniewinnieni przez Boga mówią: „Słowo to jest blisko ciebie, na twoich ustach i w twoim sercu”. My głosimy właśnie to słowo, mówiące o wierze. ");
INSERT INTO polsz_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Jeśli bowiem własnymi ustami wyznasz, że Jezus jest twoim Panem, i jeśli w sercu uwierzysz, że Bóg wskrzesił Go z martwych, zostaniesz zbawiony. ");
INSERT INTO polsz_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Wiara w sercu prowadzi do uniewinnienia, a wyznanie jej ustami—do zbawienia. ");
INSERT INTO polsz_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Pismo mówi przecież: „Każdy, kto Mu uwierzy, nie zawiedzie się”. ");
INSERT INTO polsz_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Nie ważne jest więc, kto jest Żydem, a kto poganinem. Wszyscy bowiem mają tego samego Pana, który hojnie obdarza swoimi bogactwami tych, którzy Go wzywają. ");
INSERT INTO polsz_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Każdy, kto wezwie Pana, będzie zbawiony. ");
INSERT INTO polsz_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ale jak ludzie mogą wzywać Tego, któremu jeszcze nie uwierzyli? A jak mają uwierzyć, skoro o Nim nie słyszeli? Jak mogą usłyszeć, jeśli nie ma tego, kto im o tym powie? ");
INSERT INTO polsz_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","A jak ktoś ma mówić, skoro nie został do tego powołany? Pismo mówi: „Wspaniale jest widzieć ludzi głoszących dobrą nowinę o pokoju”. ");
INSERT INTO polsz_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Nie wszyscy jednak przyjęli dobrą nowinę. Już prorok Izajasz powiedział: „Panie, czy ktoś uwierzył temu, co mówiliśmy?”. ");
INSERT INTO polsz_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Wiara rodzi się podczas słuchania dobrej nowiny o Chrystusie. ");
INSERT INTO polsz_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Spytam więc: Czy Żydzi nie słyszeli jej? Oczywiście, że słyszeli! „Głos nauczających rozszedł się po całej ziemi, a ich słowa dotarły aż do krańców świata”. ");
INSERT INTO polsz_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Znowu zapytam: Czy Izrael tego nie zrozumiał? Już Mojżesz odpowiedział na to pytanie, przekazując następujące słowa od Boga: „Sprawię, że będziecie zazdrośni o pogan, i że będziecie się gniewać na tych, którzy niczego nie rozumieją”. ");
INSERT INTO polsz_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Izajasz zaś odważył się przekazać takie słowa od Boga: „Pozwoliłem się znaleźć tym, którzy Mnie nie szukali, i pokazałem się tym, którzy o Mnie nie pytali”. ");
INSERT INTO polsz_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Izraelowi natomiast przekazał następujące poselstwo: „Cały dzień wyciągałem ręce do mojego ludu, ale on nie słuchał i był Mi przeciwny”. ");
INSERT INTO polsz_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Czyżby więc Bóg odrzucił swój własny naród? Absolutnie nie! Przecież ja sam jestem Żydem, potomkiem Abrahama, pochodzącym z rodu Beniamina. ");
INSERT INTO polsz_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Bóg nie porzucił wybranego przez siebie narodu. Czy nie pamiętacie, co Pismo mówi o Eliaszu? Prorok żalił się Bogu na Izraela: ");
INSERT INTO polsz_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","„Panie, pozabijali Twoich proroków i zburzyli Twoje ołtarze. Zostałem sam, a oni chcą zabić także mnie”. ");
INSERT INTO polsz_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ale Bóg odpowiedział mu: „Nie jesteś sam! Zachowałem jeszcze siedem tysięcy ludzi, którzy nie pokłonili się bożkowi Baalowi”. ");
INSERT INTO polsz_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Podobnie jest i dzisiaj. Została garstka wybranych przez Boga—dzięki Jego łasce. ");
INSERT INTO polsz_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Jeśli więc dzięki łasce, to nie ze względu na dobre postępowanie, bo wtedy dar łaski przestałby być darem. ");
INSERT INTO polsz_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Mamy więc taką sytuację: Izrael nie osiągnął tego, czego pragnął. Tylko wybrana garstka Żydów znalazła łaskę Boga—większość zaś stała się nieczuła. ");
INSERT INTO polsz_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Pismo mówi: „Bóg zesłał na nich otępienie, zamknął im oczy i uszy —i trwa to do dziś”. ");
INSERT INTO polsz_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Mówi o tym również król Dawid: „Zasiądą do posiłku, ale wpadną w pułapkę, i pogrążą się w niej, bo na to zasłużyli. ");
INSERT INTO polsz_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Ich oczy zaćmią się i niczego nie zobaczą, a ich grzbiet zegnie się pod ciężarem”. ");
INSERT INTO polsz_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Czy jednak Żydzi aż tak się potknęli, że zupełnie upadli? Absolutnie nie! Ich potknięcie sprawiło, że zbawienie stało się dostępne dla pogan, aby Izrael pozazdrościł im i również go zapragnął. ");
INSERT INTO polsz_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Pomyślcie więc: Jeśli ich potknięcie przyniosło światu korzyść i jeśli ich poniżenie obdarzyło pogan bogactwem, to jak wielkie szczęście przyniesie światu ich powstanie! ");
INSERT INTO polsz_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Teraz kilka słów do was, wierzących pogan. Ciągle podkreślam, że jestem apostołem posłanym do pogan. ");
INSERT INTO polsz_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Mam nadzieję, że wzbudzę w ten sposób zazdrość moich rodaków i doprowadzę do zbawienia przynajmniej niektórych z nich. ");
INSERT INTO polsz_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Jeśli bowiem ich odrzucenie przyniosło światu pojednanie z Bogiem, to ich ponowne przyjęcie będzie przejściem ze śmierci do życia. ");
INSERT INTO polsz_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Skoro zaczyn ciasta jest święty, to i całe ciasto! Jeśli święte są korzenie, to i gałęzie drzewa! ");
INSERT INTO polsz_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Niektóre gałązki z oliwnego drzewa Abrahama zostały odcięte, abyś ty, jako poganin, będący gałązką z dzikiego drzewa, został wszczepiony w szlachetną oliwkę i obficie czerpał soki z jej korzenia. ");
INSERT INTO polsz_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Ale nie pogardzaj odciętymi gałęziami i nie wywyższaj się! To nie ty przecież utrzymujesz korzeń, ale korzeń ciebie. ");
INSERT INTO polsz_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Pewnie powiesz: „Inne gałęzie zostały wycięte, abym ja mógł zostać wszczepiony w ich miejsce”. ");
INSERT INTO polsz_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Masz rację! Z powodu niewiary tamte gałęzie zostały usunięte, a ty dzięki wierze zająłeś ich miejsce. Ale nie wywyższaj się i nie bądź zbyt pewny siebie! ");
INSERT INTO polsz_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Jeśli bowiem Bóg nie oszczędził naturalnych gałęzi, to może wyciąć także ciebie. ");
INSERT INTO polsz_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Zwróć uwagę na dobroć i surowość Boga: był surowy dla wyciętych gałęzi, a jest dobry dla ciebie—o ile trwasz w tej dobroci, bo i ciebie może spotkać podobny los. ");
INSERT INTO polsz_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Żydzi zaś, jeśli porzucą swoją niewiarę, zostaną ponownie wszczepieni. Bóg jest w stanie tego dokonać! ");
INSERT INTO polsz_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Skoro ty, jako gałązka wycięta z dzikiego drzewa, wbrew naturze zostałeś wszczepiony w szlachetną oliwkę, to tym bardziej oni mogą zostać z powrotem wszczepieni w swoje własne drzewo. ");
INSERT INTO polsz_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Przyjaciele, bardzo chcę, abyście znali tę tajemnicę i myśleli o sobie w rozsądny sposób. Wiedzcie więc o tym, że Izrael będzie okazywać upór tylko do czasu, gdy do Chrystusa przyjdą już wszyscy poganie, którzy mają Go znaleźć. ");
INSERT INTO polsz_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","A wtedy cały Izrael zostanie zbawiony. Bóg mówi o tym w Piśmie: „Z Syjonu przyjdzie Zbawiciel, który odwróci Izraela od bezbożności. ");
INSERT INTO polsz_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","I dotrzymam zawartego przymierza, oczyszczając ich z grzechów”. ");
INSERT INTO polsz_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Jeśli chodzi o dobrą nowinę, Żydzi są teraz wrogami Boga—ale to dla waszego dobra. Jeśli jednak chodzi o dawne Boże wybranie—są Jego ukochanym ludem, ze względu na przodków. ");
INSERT INTO polsz_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Bóg bowiem nie odbiera ludziom swoich darów i powołania. ");
INSERT INTO polsz_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Wy niegdyś buntowaliście się przeciw Niemu, ale teraz, z powodu uporu ze strony Żydów, doznaliście Jego miłości. ");
INSERT INTO polsz_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Oni, teraz zbuntowani z powodu okazanej wam miłości, również doznają Bożej łaski. ");
INSERT INTO polsz_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Bóg pozwolił na to, żeby wszyscy się zbuntowali, aby wszystkim okazać swoją miłość. ");
INSERT INTO polsz_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Jak niezgłębiona jest mądrość, wiedza i bogactwo Boga! Jak niedościgłe Jego decyzje i sposoby działania! ");
INSERT INTO polsz_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Kto ogarnie myśli Pana? Kto może zostać Jego doradcą? ");
INSERT INTO polsz_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","I kto Go czymś obdarował, aby oczekiwać czegoś w zamian? ");
INSERT INTO polsz_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Wszystko przecież pochodzi od Niego, dzięki Niemu istnieje i do Niego zmierza. Jemu niech będzie wieczna chwała! Amen! ");
INSERT INTO polsz_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Przyjaciele! Ze względu na miłość, jaką okazał nam Bóg, wzywam was, abyście złożyli Mu swoje ciała jako żywą, świętą i podobającą się Mu ofiarę. Taka jest natura waszej służby. ");
INSERT INTO polsz_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Nie naśladujcie tego świata i zmieńcie wasz sposób myślenia, abyście wiedzieli, jaka jest wola Boga: co jest dobre, co Mu się podoba i co jest doskonałe. ");
INSERT INTO polsz_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Jako sługa Boga, z Jego łaski, radzę każdemu z was: nie myślcie o sobie, że jesteście lepsi niż naprawdę jesteście, ale zachowujcie w tej kwestii rozsądek, zgodnie z miarą wyznaczoną wam przez Boga. ");
INSERT INTO polsz_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Jako ludzie składamy się z wielu różnych części ciała, a żadna z nich nie spełnia tych samych funkcji, co inne. ");
INSERT INTO polsz_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Tak samo stanowimy jedno ciało w Chrystusie i choć jest nas wielu, jesteśmy różnymi częściami tego samego ciała. ");
INSERT INTO polsz_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Dzięki łaskawości Boga otrzymaliśmy też różne dary—do korzystania zgodnie z ich przeznaczeniem. Jeśli ktoś ma dar proroctwa, niech go wykorzystuje zgodnie z wiarą; ");
INSERT INTO polsz_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","jeśli ktoś ma dar służby—niech pomaga innym; jeśli ktoś ma dar nauczania—niech uczy; ");
INSERT INTO polsz_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","jeśli ktoś ma dar zachęcania—niech będzie dla innych zachętą; jeśli ktoś ma dar dawania—niech daje bezinteresownie; jeśli ktoś ma dar przewodzenia innym—niech sprawuje władzę z gorliwością; jeśli zaś ktoś ma dar miłości—niech okazuje ją z radością. ");
INSERT INTO polsz_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Nie udawajcie miłości, ale naprawdę kochajcie innych ludzi. Brzydźcie się złem, a wybierajcie dobro. ");
INSERT INTO polsz_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Bądźcie dla siebie życzliwi i okazujcie sobie przyjacielską miłość oraz szacunek. ");
INSERT INTO polsz_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Niech wasza gorliwość nie słabnie i z całym zapałem służcie Panu. ");
INSERT INTO polsz_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Cieszcie się z darowanej wam nadziei, okazujcie cierpliwość w trudnościach i wytrwałość w modlitwie. ");
INSERT INTO polsz_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Pomagajcie innym wierzącym i prześcigajcie się w okazywaniu innym gościnności. ");
INSERT INTO polsz_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Dobrze życzcie tym, którzy was prześladują—nie przeklinajcie ich! ");
INSERT INTO polsz_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Cieszcie się z tymi, którzy doznają radości, a płaczcie ze smutnymi. ");
INSERT INTO polsz_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Żyjcie ze sobą w zgodzie. Nie bądźcie zarozumiali, ale zabiegajcie o przyjaźń prostych ludzi. I nie wywyższajcie się myśląc, że wszystko już wiecie. ");
INSERT INTO polsz_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Nie odpłacajcie złem za zło, ale dla wszystkich bądźcie dobrzy. ");
INSERT INTO polsz_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Jeśli to możliwe i od was to zależy, żyjcie w zgodzie ze wszystkimi ludźmi. ");
INSERT INTO polsz_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Kochani, sami nie wymierzajcie sprawiedliwości, ale pozostawcie to Bogu. Pismo mówi bowiem: „Ja wymierzam karę i Ja za wszystko odpłacam—mówi Pan”. Napisane jest również: ");
INSERT INTO polsz_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","„Jeśli twój wróg jest głodny—nakarm go; jeśli jest spragniony—daj mu pić. W ten sposób zawstydzisz go swoim postępowaniem”. ");
INSERT INTO polsz_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Nie daj się pokonać przez zło, lecz zwyciężaj je dobrem. ");
INSERT INTO polsz_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Bądźcie posłuszni władzom sprawującym rządy. Każda władza pochodzi bowiem od Boga. Ci, którym podlegacie, również zostali więc powołani przez Niego. ");
INSERT INTO polsz_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Kto przeciwstawia się władzy, burzy porządek ustanowiony przez Boga i sam ściąga na siebie karę. ");
INSERT INTO polsz_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Ludzie sprawujący władzę nie są postrachem dla tych, którzy postępują dobrze, ale dla czyniących zło. Nie chcesz żyć w strachu przed władzą? Czyń dobrze, a otrzymasz od niej pochwałę! ");
INSERT INTO polsz_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Bóg ustanowił rządzących dla twojego dobra. Ale jeśli łamiesz prawo, masz się czego bać! Władza potrafi bowiem przywołać przestępców do porządku. Będąc na usługach Boga, wymierza karę tym, którzy postępują źle. ");
INSERT INTO polsz_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Dlatego należy się jej podporządkować—nie tylko z powodu możliwej kary, ale ze względu na własne sumienie. ");
INSERT INTO polsz_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Z tego samego powodu należy płacić podatki. Urzędnicy państwowi pełnią bowiem swoją służbę z Bożego polecenia. ");
INSERT INTO polsz_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Oddawajcie więc każdemu to, co mu się należy: płaćcie podatki i inne należności oraz okazujcie respekt i szacunek tym, którzy na to zasługują. ");
INSERT INTO polsz_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Nie miejcie wobec nikogo żadnych długów—z wyjątkiem długu wzajemnej miłości. Kto bowiem kocha innych, ten wypełnia Prawo Mojżesza. ");
INSERT INTO polsz_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Przykazania: „Bądź wierny w małżeństwie, nie zabijaj, nie kradnij, nie pożądaj” i wszystkie inne sprowadzają się do jednego: „Kochaj innych tak, jak kochasz samego siebie”. ");
INSERT INTO polsz_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Jeśli ktoś kocha innych ludzi, nie będzie wyrządzał im krzywdy—w ten sposób spełnia więc wymogi Prawa. ");
INSERT INTO polsz_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Przebudźcie się, bo czas już jest bliski! Nadejście naszego zbawienia jest teraz bliższe niż wtedy, gdy uwierzyliśmy. ");
INSERT INTO polsz_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Noc już się kończy i zbliża się dzień. Odrzućmy więc czyny ciemności i włóżmy na siebie zbroję światła. ");
INSERT INTO polsz_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Postępujmy z godnością, jak w czasie dnia. Unikajmy hucznych zabaw, pijaństwa, rozwiązłości, nieprzyzwoitego zachowania, sporów i zazdrości. ");
INSERT INTO polsz_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Bądźcie blisko naszego Pana, Jezusa Chrystusa, i nie poświęcajcie przesadnej uwagi waszemu ciału i zaspokajaniu jego pragnień. ");
INSERT INTO polsz_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Słabego w wierze otaczajcie troską bez spierania się o jego poglądy. ");
INSERT INTO polsz_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Jeden spożywa każdy pokarm, słaby zaś jest wegetarianinem. ");
INSERT INTO polsz_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Pierwszy niech nie pogardza drugim, a drugi niech nie potępia pierwszego—Bóg go przecież do siebie przygarnął. ");
INSERT INTO polsz_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Kim jesteś, że potępiasz czyjegoś sługę? Jego Pan podtrzymuje go lub pozwala mu upaść. Ostatecznie i tak postawi go na nogi, bo ma taką moc. ");
INSERT INTO polsz_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Dla jednego wszystkie dni tygodnia są takie same, dla innego niektóre z nich mają szczególne znaczenie. Każdy niech się trzyma własnego przekonania. ");
INSERT INTO polsz_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Kto uważa pewne dni za szczególne, robi to dla Pana. I kto spożywa każdy pokarm, również czyni to ze względu na Pana—bo dziękuje Bogu za jedzenie. Ten zaś, kto nie je wszystkiego, też robi to dla Pana i on także Mu dziękuje. ");
INSERT INTO polsz_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Nikt z nas nie żyje dla siebie ani dla siebie nie umiera. ");
INSERT INTO polsz_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Czy żyjemy, czy umieramy—wszystko robimy dla Pana. I w życiu, i w śmierci—zawsze należymy do Niego! ");
INSERT INTO polsz_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Chrystus umarł i powstał z martwych właśnie po to, aby być Panem życia i śmierci. ");
INSERT INTO polsz_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Dlaczego więc potępiasz innego wierzącego? Albo dlaczego gardzisz nim? Przecież wszyscy staniemy przed tym samym sądem Bożym. ");
INSERT INTO polsz_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Czytamy przecież: „Przysięgam na swoje życie—mówi Pan —że przede Mną ugnie się każde kolano, a każdy język uczci Boga”. ");
INSERT INTO polsz_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Każdy z nas odpowie przed Bogiem za siebie. ");
INSERT INTO polsz_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Nie oskarżajcie się więc nawzajem, ale raczej starajcie się nie być przeszkodą lub zniechęceniem dla innych wierzących. ");
INSERT INTO polsz_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Osobiście wiem i jestem głęboko przekonany na podstawie autorytetu naszego Pana, że żaden pokarm, sam w sobie, nie jest nieczysty. Może jedynie być nieczysty dla tego, kto go za taki uważa. ");
INSERT INTO polsz_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Jeśli jednak z powodu jedzenia wzbudzasz niepokój w innym wierzącym, nie kierujesz się miłością. Z powodu pokarmu nie osłabiaj duchowo tego, za którego umarł Chrystus. ");
INSERT INTO polsz_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Niech wasze dobre przekonanie nie będzie dla innych powodem do bluźnierstwa. ");
INSERT INTO polsz_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Istotą królestwa Bożego nie są przecież przepisy dotyczące jedzenia i picia, ale prawość, pokój i radość w Duchu Świętym. ");
INSERT INTO polsz_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Kto w taki sposób służy Chrystusowi, podoba się Bogu i będzie się cieszył uznaniem ludzi. ");
INSERT INTO polsz_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Starajcie się więc o to, co sprzyja pokojowi i wzajemnemu umacnianiu się w wierze. ");
INSERT INTO polsz_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Nie niszczcie Bożego dzieła poprzez wasz stosunek do pokarmów! Wszystko jest dobre, ale staje się źródłem zła, jeśli z tego powodu ktoś duchowo upada. ");
INSERT INTO polsz_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Dlatego dobrze jest nie jeść mięsa, nie pić wina i nie robić niczego, co mogłoby doprowadzić kogoś do grzechu. ");
INSERT INTO polsz_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Własne przekonanie zachowaj dla siebie i Boga. Szczęśliwy jest człowiek, który postępuje zgodnie z własnym przekonaniem i nie ma wyrzutów sumienia. ");
INSERT INTO polsz_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Kto jednak spożywa jakiś pokarm wbrew swojemu przekonaniu, ten odczuwa z tego powodu wyrzuty sumienia. A wszystko, co nie wypływa z przekonania, jest grzechem. ");
INSERT INTO polsz_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Zatem my, utwierdzeni w wierze, mamy obowiązek wspierać słabych w ich zmaganiach, nie zaś myśleć tylko o sobie. ");
INSERT INTO polsz_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Każdy powinien dbać o dobro innych i wzmacniać ich duchowo. ");
INSERT INTO polsz_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Przecież i Chrystus nie dbał tylko o siebie. Czytamy bowiem: „Zniewagi tych, którzy Ciebie znieważają, spadły również na Mnie”. ");
INSERT INTO polsz_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","To, co od dawna zawarte jest w Piśmie, zostało zapisane również ze względu na nas, abyśmy ucząc się cierpliwości i czerpiąc zachętę z Pisma, wzmacniali nadzieję na przyszłość. ");
INSERT INTO polsz_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Niech więc Bóg—źródło cierpliwości i zachęty—pomoże wam traktować siebie nawzajem tak, jak to robił Chrystus. ");
INSERT INTO polsz_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Wtedy wszyscy jednomyślnie będziemy wielbić Boga—Ojca naszego Pana, Jezusa Chrystusa. ");
INSERT INTO polsz_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Okazujcie sobie akceptację, tak jak Chrystus okazał ją wam, oddając przez to chwałę Bogu. ");
INSERT INTO polsz_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","On przyszedł do Izraela jako sługa, aby potwierdzić, że Bóg jest wierny i dotrzymuje obietnic danych przodkom. ");
INSERT INTO polsz_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Przyszedł również po to, aby poganie wielbili Boga za okazaną im miłość. Pismo mówi bowiem: „Z tego powodu poganie będą Cię wielbić i śpiewać pieśni na cześć Twojego imienia”. ");
INSERT INTO polsz_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","W innym zaś miejscu napisano: „Radujcie się poganie razem z Jego narodem”, ");
INSERT INTO polsz_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","a także: „Chwalcie Pana, wszystkie narody, uwielbiajcie Go wszystkie ludy”. ");
INSERT INTO polsz_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Prorok Izajasz powiedział: „Przyjdzie potomek Jessego, który będzie królem nad poganami. W Nim poganie pokładać będą nadzieję”. ");
INSERT INTO polsz_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Niech więc Bóg, który obdarza ludzi nadzieją, napełnia radością i pokojem wszystkich was, którzy Mu wierzycie. Niech daruje wam również nadzieję płynącą z mocy Ducha Świętego. ");
INSERT INTO polsz_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Przyjaciele, jestem przekonany, że macie w sobie życzliwość dla innych. Macie też niezbędną wiedzę i możecie pomagać sobie nawzajem. ");
INSERT INTO polsz_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Nie wahałem się jednak zwrócić waszej uwagi na tych kilka spraw, bo wiem, że wystarczy tylko wam o tym przypomnieć. Dzięki Bożej łasce ");
INSERT INTO polsz_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","jestem bowiem sługą Jezusa Chrystusa posłanym do pogan, aby głosić im dobrą nowinę i aby Duch Święty przemienił ich w wonną ofiarę dla Boga. ");
INSERT INTO polsz_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Jestem dumny z tego, czego dokonał przeze mnie Jezus Chrystus w tej Bożej służbie ");
INSERT INTO polsz_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","i nie ośmielę się mówić o czymkolwiek innym. Pragnę tylko opowiadać o tym, czego Bóg dokonał przeze mnie, prowadząc pogan do posłuszeństwa Mu. A działał On przez moje słowa i czyny ");
INSERT INTO polsz_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","oraz przez cudowne znaki dokonywane mocą Ducha Świętego. W ten sposób rozniosłem dobrą nowinę o Chrystusie od Jerozolimy aż po Ilirię. ");
INSERT INTO polsz_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","A zawsze zależało mi na tym, aby głosić Chrystusa tam, gdzie wieść o Nim jeszcze nie dotarła. Nie chciałem bowiem wchodzić na teren czyjejś służby, ");
INSERT INTO polsz_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ale pragnąłem działać według słów Pisma: „Zobaczą Go i poznają ci, którzy Go nigdy nie widzieli ani nigdy o Nim nie słyszeli”. ");
INSERT INTO polsz_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Teraz wiecie już, dlaczego jeszcze nigdy was nie odwiedziłem. ");
INSERT INTO polsz_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ale skończyłem już tutaj moją pracę i nareszcie, po tak wielu latach, gotów jestem do was przyjechać. ");
INSERT INTO polsz_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Wybieram się bowiem do Hiszpanii i chciałbym po drodze was zobaczyć. Mam też nadzieję, że gdy się wami nacieszę, wyprawicie mnie w dalszą podróż. ");
INSERT INTO polsz_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Teraz udaję się do Jerozolimy z pomocą materialną dla wierzących. ");
INSERT INTO polsz_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Kościoły Macedonii i Grecji postanowiły bowiem wesprzeć tamtejszych wierzących, którzy są w potrzebie. ");
INSERT INTO polsz_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Zapragnęły tego, bo mają wobec nich dług wdzięczności: skoro jako poganie mają udział w ich dobrach duchowych, powinni zadbać o ich potrzeby materialne. ");
INSERT INTO polsz_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Gdy tylko przekażę ich dar i doprowadzę sprawę do końca, odwiedzę was w drodze do Hiszpanii. ");
INSERT INTO polsz_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","A jestem przekonany, że przyjadę do was z błogosławieństwem Chrystusa. ");
INSERT INTO polsz_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Bardzo was jednak proszę—ze względu na naszego Pana, Jezusa Chrystusa, i na miłość Ducha Świętego—abyście udzielili mi pomocy modląc się za mnie do Boga. ");
INSERT INTO polsz_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Proście Go, aby uchronił mnie przed wrogami w Judei i aby wierzący w Jerozolimie życzliwie przyjęli ofiarowaną im pomoc. ");
INSERT INTO polsz_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Módlcie się również o to, abym—zgodnie z wolą Pana—przybył do was z radością w sercu i abyśmy mogli nawzajem się pokrzepić. ");
INSERT INTO polsz_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Niech Bóg, który obdarza ludzi pokojem, będzie z wami wszystkimi. Amen! ");
INSERT INTO polsz_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Wkrótce odwiedzi was Feba, która wierzy Panu i pomaga kościołowi w Kenchrach. ");
INSERT INTO polsz_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Przyjmijcie ją serdecznie i z godnością—jak samego Pana. Okażcie jej wszelką pomoc, bo bardzo troszczyła się zarówno o mnie, jak i o wielu innych wierzących. ");
INSERT INTO polsz_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Przekażcie moje pozdrowienia Pryscylli i Akwili, moim współpracownikom w służbie Chrystusowi. ");
INSERT INTO polsz_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Narażali dla mnie życie i nie tylko ja mam wobec nich dług wdzięczności, ale i wszystkie kościoły pochodzenia pogańskiego. ");
INSERT INTO polsz_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Pozdrówcie też kościół, który spotyka się w ich domu. Pozdrawiam drogiego mi Epeneta, który jako pierwszy w całej prowincji Azja uwierzył Chrystusowi. ");
INSERT INTO polsz_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Pozdrówcie też: Marię, która z oddaniem służyła waszej sprawie; ");
INSERT INTO polsz_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Andronika i Juniasa—moich rodaków i współwięźniów, którzy cieszą się szacunkiem apostołów i wcześniej niż ja uwierzyli Panu; ");
INSERT INTO polsz_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Ampliata—tak drogiego mi w Panu; ");
INSERT INTO polsz_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Urbana—naszego współpracownika w służbie; drogiego mi Stachysa; ");
INSERT INTO polsz_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Apellesa, który sprawdził się jako sługa Chrystusa; wszystkich z domu Arystobula; ");
INSERT INTO polsz_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Herodiona—mojego rodaka, i wszystkich z domu Narcyza. ");
INSERT INTO polsz_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Pozdrówcie: Tryfenę, Tryfozę i drogą Persydę, które tak wiele napracowały się dla Pana; ");
INSERT INTO polsz_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Rufusa—wybranego przez Pana, i jego matkę, która i dla mnie jest jak prawdziwa matka; ");
INSERT INTO polsz_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Asynkryta, Flegonta, Hermesa, Patrobę, Hermasa i pozostałych wierzących, którzy są z nimi; ");
INSERT INTO polsz_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Filologa i Julię; Nereusza i jego siostrę; Olimpasa oraz wszystkich wierzących, którzy są z nimi. ");
INSERT INTO polsz_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Pozdrówcie się nawzajem przyjacielskim pocałunkiem. Również wszystkie tutejsze kościoły przesyłają wam pozdrowienia. ");
INSERT INTO polsz_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Na koniec, przyjaciele, chcę wam przypomnieć jeszcze jedno: Unikajcie tych, którzy wywołują podziały i doprowadzają innych do upadku, postępując wbrew nauce, którą przyjęliście. ");
INSERT INTO polsz_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Oni nie służą Chrystusowi, naszemu Panu, ale własnemu brzuchowi! Miłymi słowami i pochlebstwami zwodzą łatwowiernych ludzi. ");
INSERT INTO polsz_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Ale wasze posłuszeństwo Bogu jest znane wszystkim—tak bardzo się z tego cieszę! Pragnę też, abyście byli pełni mądrości i czynili dobro, a trzymali się z dala od wszelkiego zła. ");
INSERT INTO polsz_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Już wkrótce Bóg, który obdarza ludzi pokojem, zmiażdży szatana pod waszymi stopami. Niech Jezus, nasz Pan, obdarza was swoją łaską! ");
INSERT INTO polsz_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Tymoteusz—mój współpracownik, oraz Lucjusz, Jazon i Sozypater—moi rodacy, przesyłają wam najlepsze życzenia. ");
INSERT INTO polsz_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Pozdrawiam was również ja, Tercjusz, który jako sekretarz Pawła pisałem ten list. ");
INSERT INTO polsz_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Także Gajus prosi o przekazanie wam pozdrowień. Jestem teraz gościem w jego domu, w którym spotyka się także tutejszy kościół. ");
INSERT INTO polsz_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Pozdrowienia przesyła wam Erast—skarbnik miejski, oraz Kwartus—wasz przyjaciel. ");
INSERT INTO polsz_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Bóg może wzmocnić waszą wiarę! Taka jest treść głoszonej przeze mnie dobrej nowiny o Jezusie Chrystusie. Przez wieki była ona okryta tajemnicą, ");
INSERT INTO polsz_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","a teraz, dzięki pismom proroków, została ujawniona na rozkaz odwiecznego Boga. Bóg objawił ją po to, aby także poganie uwierzyli Jezusowi i okazali Mu posłuszeństwo. ");
INSERT INTO polsz_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Jedynemu Bogu, w którym jest pełnia mądrości, niech będzie wieczna chwała, przez Jezusa Chrystusa—naszego Pana. Amen!");
INSERT INTO polsz_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Ja, Paweł, powołany przez Boga na apostoła Chrystusa Jezusa, wraz z Sostenesem, uczniem Pana, ");
INSERT INTO polsz_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","piszę do kościoła Bożego w Koryncie. Zostaliście wybrani przez Chrystusa Jezusa, wezwani przez Niego i—razem ze wszystkimi innymi wyznawcami naszego wspólnego Pana—oddzieleni dla Boga. ");
INSERT INTO polsz_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Niech Bóg, nasz Ojciec, i Pan, Jezus Chrystus, obdarzają was swoją łaską i pokojem! ");
INSERT INTO polsz_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Wciąż nieustannie dziękuję Bogu za was i za łaskę, którą okazał wam dzięki Chrystusowi. ");
INSERT INTO polsz_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","On sprawił, że możecie mówić o Nim i rozumieć sprawy duchowe. ");
INSERT INTO polsz_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","On też wzmocnił waszą wiarę w Niego. ");
INSERT INTO polsz_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Nie brakuje wam również żadnego duchowego daru w tym okresie oczekiwania na Jego powrót. ");
INSERT INTO polsz_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","A On będzie wzmacniał was aż do końca, abyście w dniu Jego powrotu byli bez zarzutu. ");
INSERT INTO polsz_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Bóg jest wierny i dokona tego—bo to On powołał was do przyjaźni ze swoim Synem, Jezusem Chrystusem, naszym Panem. ");
INSERT INTO polsz_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Wzywam was, przyjaciele, w imieniu naszego Pana, abyście żyli w zgodzie. Unikajcie podziałów, bądźcie jednomyślni i miejcie wspólny cel. ");
INSERT INTO polsz_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Piszę o tym, ponieważ od domowników Chloe dowiedziałem się o waszych kłótniach. ");
INSERT INTO polsz_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Mam na myśli to, że mówicie o sobie: „Ja jestem uczniem Pawła”, „Ja—Apollosa”, „Ja—Piotra”, „A ja należę do samego Chrystusa”. ");
INSERT INTO polsz_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Czy Chrystusa można podzielić? Czy ja zostałem za was ukrzyżowany? Czy w moim imieniu zostaliście ochrzczeni? ");
INSERT INTO polsz_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Jestem wdzięczny Bogu za to, że oprócz Kryspusa i Gajusa nikogo z was nie ochrzciłem. ");
INSERT INTO polsz_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Nikt więc nie może powiedzieć, że ochrzciłem go w swoim imieniu. ");
INSERT INTO polsz_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Ochrzciłem jeszcze rodzinę Stefanasa, ale więcej nikogo sobie nie przypominam. ");
INSERT INTO polsz_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Chrystus nie posłał mnie bowiem, abym chrzcił, lecz abym głosił dobrą nowinę—i to nie w wielkich słowach, aby ludzka błyskotliwość nie przyćmiewała mocy krzyża Chrystusa. ");
INSERT INTO polsz_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Dla tych, którzy idą na potępienie, wiara w śmierć Jezusa na krzyżu jest głupotą. Ale dla nas, przyjmujących zbawienie, krzyż jest przejawem mocy samego Boga. ");
INSERT INTO polsz_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Czytamy o tym w Piśmie: „Zniszczę mądrość mędrców i odrzucę ludzką błyskotliwość”. ");
INSERT INTO polsz_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Gdzie są ci wszyscy mędrcy, uczeni i wybitni znawcy spraw tego świata? Czy Bóg nie udowodnił, że cała ta wielka mądrość jest zwykłą głupotą? ");
INSERT INTO polsz_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Skoro mądry świat nie poznał mądrego Boga, postanowił On, przez głupie opowiadanie dobrej nowiny, zbawić tych, którzy uwierzą. ");
INSERT INTO polsz_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Żydzi żądają znaku z nieba, Grecy szukają mądrości, ");
INSERT INTO polsz_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","a my opowiadamy o Chrystusie, który został ukrzyżowany. Dla pierwszych jest to skandal, dla drugich—nonsens. ");
INSERT INTO polsz_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Ale dla nas, powołanych zarówno spośród Żydów, jak i Greków, jest On Mesjaszem—mocą i mądrością samego Boga. ");
INSERT INTO polsz_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","To bowiem, co jest dla Boga głupstwem, góruje nad mądrością człowieka, a to, co jest dla Boga słabością, przewyższa ludzką siłę. ");
INSERT INTO polsz_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Zauważcie, przyjaciele, że niewielu spośród was uchodzi za mądrych, posiada władzę lub szlachetne pochodzenie. ");
INSERT INTO polsz_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Bóg świadomie wybrał tych, których świat uważa za głupich, słabych i nieważnych, aby zawstydzić mądrych, silnych i ważnych. ");
INSERT INTO polsz_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","On wybrał tych, którzy w oczach świata są nikim, aby pokazać marność tych, którzy myślą, że są kimś. ");
INSERT INTO polsz_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","W ten sposób pozbawił ludzi powodów do dumy. ");
INSERT INTO polsz_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","To przecież dzięki Bogu żyjecie teraz w Chrystusie Jezusie! I to On jest naszą mądrością, prawością, świętością i zbawieniem—wszystko to mamy od Boga. ");
INSERT INTO polsz_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Pismo mówi: „Jedynym powodem do dumy jest nasz Pan”. ");
INSERT INTO polsz_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Przyjaciele, ja także, gdy do was przybyłem i opowiadałem wam o Bożej tajemnicy, nie używałem wielkich słów i błyskotliwych myśli. ");
INSERT INTO polsz_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Postanowiłem bowiem mówić tylko o Jezusie Chrystusie i Jego śmierci na krzyżu. ");
INSERT INTO polsz_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Stanąłem przed wami jako słaby człowiek—nieśmiały i drżący ze strachu. ");
INSERT INTO polsz_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Moje nauczanie nie było podobne do przemówień mędrców, ale było za to pełne Ducha i mocy Boga. ");
INSERT INTO polsz_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Chciałem bowiem, aby wasza wiara opierała się właśnie na Jego mocy, a nie na ludzkiej mądrości. ");
INSERT INTO polsz_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","A jednak to, co głosimy, ludzie dojrzali w wierze przyjmują jako mądrość, choć nie jest to mądrość tego świata ani jego przemijających przywódców. ");
INSERT INTO polsz_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Mówimy bowiem o tajemnej mądrości samego Boga, która, ze względu na nas, była ukryta przez całe wieki. ");
INSERT INTO polsz_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Żaden z przywódców tego świata jej nie pojął, bo gdyby było inaczej, nie ukrzyżowaliby Pana chwały. ");
INSERT INTO polsz_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Pismo mówi: „Dla tych, którzy kochają Boga, przygotował On rzeczy, jakich nikt nigdy nie widział, o jakich nikt nigdy nie słyszał, i jakie nikomu nawet nie przyszły na myśl”. ");
INSERT INTO polsz_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Bóg objawił to nam przez swojego Ducha! On bowiem przenika wszystko i zna najgłębsze Boże tajemnice. ");
INSERT INTO polsz_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Kto wie, co kryje się w człowieku, jeśli nie on sam, czyli jego duch? Podobnie nikt, poza Duchem Bożym, nie może wniknąć w Boga. ");
INSERT INTO polsz_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Nie przyjęliśmy przecież ducha tego świata. Otrzymaliśmy Ducha Boga, abyśmy mogli zrozumieć, czym nas obdarował. ");
INSERT INTO polsz_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","I mówimy o tym nie w błyskotliwych słowach ludzkiej mądrości, ale słowami pochodzącymi od Ducha Świętego—duchowe sprawy wyrażając w duchowy sposób. ");
INSERT INTO polsz_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Człowiek, kierujący się tylko zmysłami, nie rozumie rzeczy pochodzących od Ducha Bożego. Wydają mu się głupie i nie jest w stanie ich pojąć, bo można je zrozumieć tylko dzięki Duchowi. ");
INSERT INTO polsz_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Człowiek kierowany przez Ducha Świętego rozumie zaś to wszystko, ale inni go nie rozumieją. ");
INSERT INTO polsz_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Pismo mówi: „Kto ogarnie myśli Pana? Kto może zostać Jego doradcą?”. My znamy zamiary Chrystusa! ");
INSERT INTO polsz_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Przyjaciele, będąc między wami, nie mogłem mówić do was jak do ludzi duchowo dojrzałych. Traktowałem was jak myślących tylko po ludzku, bo w waszej wierze w Chrystusa byliście na poziomie niemowląt. ");
INSERT INTO polsz_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Karmiłem was mlekiem, a nie stałym pokarmem, bo jeszcze nie byliście na to gotowi. Z resztą nadal nie jesteście! ");
INSERT INTO polsz_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Ciągle żyjecie tylko po ludzku! Skoro się kłócicie i zazdrościcie sobie, to czy nie zachowujecie się tylko po ludzku, czyli tak samo, jak ludzie niewierzący? ");
INSERT INTO polsz_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Czy dowodem na to nie są wasze słowa: „Ja jestem uczniem Pawła”, „A ja—Apollosa”? ");
INSERT INTO polsz_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Kim jesteśmy ja i Apollos, żeby się o nas kłócić? Tylko sługami Pana, którym powierzył zadanie. ");
INSERT INTO polsz_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Ja siałem, Apollos podlewał, ale to Bóg dawał duchowy wzrost. ");
INSERT INTO polsz_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Tak naprawdę to ani siejący, ani podlewający nie jest ważny—tylko Bóg, który powoduje wzrost. ");
INSERT INTO polsz_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","A słudzy Pana—czy sieją, czy podlewają—pracują wspólnie i każdy z nich otrzyma nagrodę za swoją pracę. ");
INSERT INTO polsz_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Jesteśmy bowiem współpracownikami Boga, a wy—Bożą uprawą i Bożą budowlą. ");
INSERT INTO polsz_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Dzięki łasce Boga, jako doświadczony budowniczy, położyłem fundament, na którym kolejny fachowiec wznosi budowlę. Każdy jednak niech buduje uważnie, ");
INSERT INTO polsz_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","bo nie można już położyć innego fundamentu. Jedynym fundamentem jest Jezus Chrystus! ");
INSERT INTO polsz_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Można budować na Nim używając różnych materiałów: złota, srebra i szlachetnych kamieni lub drewna, słomy i siana. ");
INSERT INTO polsz_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","W dniu sądu okaże się z czego kto budował, bo dzieło każdego z nas przejdzie próbę ognia. ");
INSERT INTO polsz_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Czyja budowla przetrwa, ten otrzyma nagrodę. ");
INSERT INTO polsz_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Czyja spłonie, ten poniesie stratę. Sam wprawdzie ocaleje, ale przejdzie trudną dla niego próbę ognia. ");
INSERT INTO polsz_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Czy nie wiecie, że wszyscy razem stanowicie świątynię Boga i że mieszka w was Jego Duch? ");
INSERT INTO polsz_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Bóg zniszczy każdego, kto bezcześci i niszczy Jego świątynię. Jest bowiem święta—a to wy nią jesteście. ");
INSERT INTO polsz_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Przestańcie się więc łudzić. Jeśli ktoś jest dumny ze swojej mądrości, niech lepiej stanie się głupcem, aby zdobyć prawdziwą mądrość. ");
INSERT INTO polsz_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Mądrość tego świata jest bowiem dla Boga głupstwem—napisano bowiem: „Bóg złapał mądrych w pułapkę ich własnej mądrości” ");
INSERT INTO polsz_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","oraz: „Pan dobrze zna myśli mądrych i wie, że są jałowe”. ");
INSERT INTO polsz_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Nie szczyćcie się więc uznaniem innych ludzi. Wszystko bowiem należy do was: ");
INSERT INTO polsz_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Paweł, Apollos, Piotr i cały świat, a nawet życie i śmierć, przeszłość i przyszłość. Wszystko jest wasze, ");
INSERT INTO polsz_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","wy zaś należycie do Chrystusa, a Chrystus—do Boga. ");
INSERT INTO polsz_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Traktujcie nas więc jako tych, którzy służą Chrystusowi i wyjaśniają innym Boże tajemnice. ");
INSERT INTO polsz_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Naszym najważniejszym obowiązkiem jest lojalność wobec Tego, któremu służymy. ");
INSERT INTO polsz_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Dlatego nie martwię się tym, jak mnie ocenicie lub co myślą o mnie inni ludzie. Zresztą nawet ja sam nie oceniam mojej służby. ");
INSERT INTO polsz_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Wprawdzie niczego nie mogę sobie zarzucić, ale to nie wystarcza. Ocenić musi mnie sam Pan. ");
INSERT INTO polsz_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Nie osądzajcie więc nikogo przedwcześnie—zanim On nie powróci i nie rozświetli tego, co ukryte w ciemnościach, i nie ujawni prawdziwych ludzkich zamiarów. Wtedy każdy z nas otrzyma od Boga należną pochwałę. ");
INSERT INTO polsz_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Na przykładzie własnym i Apollosa pokazałem wam, że nie wolno wykraczać ponad to, co mówi Pismo, i wywyższać jednych nauczycieli, poniżając drugich. ");
INSERT INTO polsz_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Jaki masz powód do dumy? Czy masz coś, czego nie otrzymałeś w darze? A skoro wszystko, co masz, jest darem, dlaczego szczycisz się tym tak, jakbyś sam to zdobył? ");
INSERT INTO polsz_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Wszystko już macie? Jesteście bogaci? Nie czekając na nas, zaczynacie już królować? Chciałbym, abyście rzeczywiście królowali—a my z wami. ");
INSERT INTO polsz_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Jestem przekonany, że nas, apostołów, Bóg umieścił na samym końcu. Jesteśmy jak skazańcy czekający na egzekucje, wystawieni na widok publiczny przed całym światem—przed ludźmi i aniołami. ");
INSERT INTO polsz_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","My z powodu Chrystusa jesteśmy uważani za głupców—wy staliście się dzięki Niemu mądrzy; my słabniemy—wy nabieracie sił; my jesteśmy pogardzani—wy otaczani szacunkiem. ");
INSERT INTO polsz_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Stale jesteśmy głodni i spragnieni, pozbawieni ubrań, poniżani i bezdomni. ");
INSERT INTO polsz_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Ciężko pracujemy, aby zarobić na życie. Gdy ludzie nas znieważają—my życzymy im szczęścia, gdy nas prześladują—znosimy to, ");
INSERT INTO polsz_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","gdy nas zniesławiają—modlimy się za nich. Wciąż jesteśmy jak śmieci i odpadki tego świata. ");
INSERT INTO polsz_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Nie piszę o tym wszystkim, aby was zawstydzić, ale żeby was pouczyć jako ukochane dzieci. ");
INSERT INTO polsz_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Bo chociaż możecie mieć tysiące nauczycieli, to duchowych ojców macie niewielu. Przecież to ja „zrodziłem” was dla Chrystusa, głosząc wam dobrą nowinę. ");
INSERT INTO polsz_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Gorąco więc proszę was: Naśladujcie nas! ");
INSERT INTO polsz_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Dlatego właśnie posyłam Tymoteusza, żeby wam w tym pomógł. On jest wiernym sługą Pana i kocham go jak własnego syna. On przypomni wam to, czego nauczam we wszystkich kościołach, które odwiedzam. ");
INSERT INTO polsz_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Ponieważ nie odwiedzałem was, niektórzy zaczęli popadać w pychę. ");
INSERT INTO polsz_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Jeśli jednak Pan pozwoli, już niebawem do was przyjadę, a wtedy będę mógł stwierdzić czy ci, którzy tak się przechwalają, potrafią tylko dużo mówić, czy też naprawdę mają moc od Boga. ");
INSERT INTO polsz_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Królestwo Boże nie opiera się bowiem na słowach, ale na mocy. ");
INSERT INTO polsz_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Sami wybierzcie: Czy mam do was przyjść ze słowami nagany, czy też z miłością i łagodnością? ");
INSERT INTO polsz_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Wszędzie już słychać o tolerowanym przez was przypadku rozwiązłości seksualnej, mianowicie o mężczyźnie żyjącym ze swoją macochą. Jest to rzecz, jakiej nie dopuszczają się nawet poganie. ");
INSERT INTO polsz_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Wy zaś, dumni ze swojej tolerancji, nie martwicie się z tego powodu i nie usuwacie tego człowieka z waszego grona. ");
INSERT INTO polsz_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Ja—chociaż nieobecny fizycznie, ale sercem będący przy was—w imieniu samego Jezusa, naszego Pana, już oceniłem postępowanie tego człowieka. ");
INSERT INTO polsz_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Wy również zbierzcie się i, mając moje poparcie, na mocy autorytetu naszego Pana ");
INSERT INTO polsz_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","usuńcie go z kościoła, oddając go w ręce szatana. Jego ciału będzie grozić zagłada, ale jego duch zostanie uratowany w dniu powrotu naszego Pana. ");
INSERT INTO polsz_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Jak możecie się szczycić czymś takim?! Czy nie rozumiecie, że odrobina kwasu przenika całe ciasto? ");
INSERT INTO polsz_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Usuńcie spośród siebie stary kwas, czyli zło, abyście byli czyści jak świeże ciasto. Zostaliście przecież oczyszczeni przez samego Chrystusa, który stał się naszą ofiarą paschalną! ");
INSERT INTO polsz_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Świętujmy więc naszą Paschę nie w starym kwasie złości i obłudy, ale w czystości i prawdzie. ");
INSERT INTO polsz_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Wcześniej napisałem wam, abyście unikali towarzystwa ludzi, którzy prowadzą rozwiązłe życie. ");
INSERT INTO polsz_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Nie miałem wtedy na myśli wszystkich rozwiązłych ludzi tego świata—wszystkich złodziei, wszystkich, którzy są zachłanni, lub wszystkich, którzy oddają cześć podobiznom bożków. Jeśliby tak było, musielibyście chyba zniknąć z tego świata. ");
INSERT INTO polsz_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Pisząc o tym, miałem na myśli ludzi, którzy uważają się za wierzących, a prowadzą rozwiązłe życie, są zachłanni, oszukują innych, oddają cześć podobiznom bożków, są pijakami lub obrażają Boga. Unikajcie towarzystwa takich ludzi i nie siadajcie nawet z nimi do stołu! ");
INSERT INTO polsz_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Dlaczego mielibyśmy zajmować się osądzaniem tych, którzy są poza kościołem? Waszym zadaniem jest rozsądzać sprawy wewnątrz kościoła. ");
INSERT INTO polsz_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Tych, którzy są poza kościołem, osądzi Bóg. Wy zaś usuńcie złego spośród siebie! ");
INSERT INTO polsz_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Czemu dopuszczacie do tego, że ktoś, oskarżając innego wierzącego, idzie do pogańskiego sądu, zamiast przyjść po pomoc do świętych? ");
INSERT INTO polsz_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Czy nie wiecie, że my, święci, będziemy w przyszłości sądzić ten świat? Skoro więc będziecie sędziami świata, to czy nie możecie rozstrzygać także drobniejszych spraw? ");
INSERT INTO polsz_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Przecież będziemy osądzać nawet aniołów w niebie, a co dopiero zwykłe sprawy! ");
INSERT INTO polsz_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Po co więc chodzicie z takimi problemami do sędziów, którzy przecież nie są wierzący? ");
INSERT INTO polsz_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Jak widzicie, próbuję was zawstydzić. Czy wśród was nie ma nikogo na tyle mądrego, żeby mógł rozstrzygnąć spór? ");
INSERT INTO polsz_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Czy musicie oskarżać się przed niewierzącymi? ");
INSERT INTO polsz_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Już samo procesowanie się między wierzącymi jest godne potępienia. Dlaczego nie chcecie raczej doznać niesprawiedliwości i krzywdy? ");
INSERT INTO polsz_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Tymczasem to wy krzywdzicie i wyrządzacie szkodę innym wierzącym! ");
INSERT INTO polsz_vpl VALUES ("C16_9","076_6_9","1CO","6","9","10","Czy nie wiecie, że nieprawi nie będą mieli udziału w królestwie Bożym? Nie łudźcie się! Do królestwa nie wejdą ci, którzy prowadzą rozwiązłe życie lub oddają cześć podobiznom bożków. Nie wejdą tam także ci, którzy popełniają grzech niewierności małżeńskiej, żyją niemoralnie albo są homoseksualistami. W królestwie tym nie będzie również miejsca dla złodziei, ludzi zachłannych, pijaków i tych, którzy obmawiają lub oszukują innych. ");
INSERT INTO polsz_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","A wy tacy właśnie byliście! Wasze grzechy zostały jednak zmyte i zostaliście przeznaczeni dla Boga oraz uniewinnieni dzięki naszemu Panu, Jezusowi Chrystusowi, i Duchowi naszego Boga. ");
INSERT INTO polsz_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Wszystko mi wolno, ale nie wszystko przynosi pożytek. Wszystko mi wolno, ale ja niczemu nie dam się zniewolić. ");
INSERT INTO polsz_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Istnieje jedzenie i jest żołądek, do którego ono trafia. Ale i jedno, i drugie nie będzie trwać wiecznie. Pamiętajcie, że ciała nie otrzymaliśmy po to, aby prowadzić rozwiązłe życie. Nasze ciało należy do Pana, a On troszczy się o nie. ");
INSERT INTO polsz_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Bóg swoją mocą wskrzesi nasze martwe ciała do życia, podobnie jak wskrzesił naszego Pana. ");
INSERT INTO polsz_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Nie zapominajcie, że wasze ciała są częściami ciała Chrystusa. Czy można je więc oderwać od ciała Chrystusa i połączyć z prostytutką? Przenigdy! ");
INSERT INTO polsz_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Pamiętajcie! Ten, kto łączy się z prostytutką staje się z nią jednym ciałem! Przecież Pismo mówi wyraźnie: „Ci dwoje staną się jednym ciałem”. ");
INSERT INTO polsz_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Kto zaś łączy się z Panem, trwa w duchowej jedności z Nim. ");
INSERT INTO polsz_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Unikajcie rozwiązłości seksualnej jak ognia! Każdy popełniony grzech ostatecznie zostaje poza naszym ciałem. Natomiast grzech seksualny godzi w nasze ciało. ");
INSERT INTO polsz_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Czy nie rozumiecie, że wasze ciało jest świątynią, w której mieszka Duch Święty, dany wam przez Boga, i że nie należycie już do siebie samych? ");
INSERT INTO polsz_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Zostaliście wykupieni za wysoką cenę! Niech więc wasze ciała przynoszą chwałę Bogu! ");
INSERT INTO polsz_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Teraz chciałbym odpowiedzieć na pytania z waszego listu. Uważam, że najlepiej jest się nie żenić. ");
INSERT INTO polsz_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Ale ze względu na niebezpieczeństwo rozwiązłości seksualnej niech każdy mężczyzna ma żonę, a kobieta—męża. ");
INSERT INTO polsz_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Mąż ma dbać o seksualną stronę życia żony, a żona—męża. ");
INSERT INTO polsz_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Żona przekazuje władzę nad swoim ciałem mężowi, a mąż—żonie. ");
INSERT INTO polsz_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Nie zaprzestawajcie współżycia ze sobą, chyba że za wspólną zgodą na krótki czas, aby skupić się na modlitwie. Potem jednak powróćcie do siebie, aby szatan nie kusił was, wykorzystując to, że nie potraficie zapanować nad waszymi pragnieniami. ");
INSERT INTO polsz_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Jest to tylko moje zalecenie, nie absolutny nakaz. ");
INSERT INTO polsz_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Chciałbym bowiem, żeby wszyscy, tak jak ja, mogli obejść się bez małżeństwa. Ale każdy z nas ma inny dar od Boga: jeden taki jak ja, drugi—inny. ");
INSERT INTO polsz_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Tym, którzy jeszcze nie zawarli małżeństwa, i tym, którzy owdowieli, radzę, aby pozostali w stanie wolnym, tak jak ja. ");
INSERT INTO polsz_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Jeśli jednak trudno im wytrzymać, niech wstąpią w związek małżeński. Lepiej jest tak postąpić, niż płonąć wskutek niezaspokojonych pragnień. ");
INSERT INTO polsz_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Małżonkom nakazuję—już nie ja, ale sam Pan: Żona niech nie odchodzi od męża. ");
INSERT INTO polsz_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Jeśli jednak odejdzie, niech pozostanie samotna albo niech się pogodzi z mężem. Także mąż niech nie porzuca swojej żony. ");
INSERT INTO polsz_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Pozostałym małżonkom mówię teraz od siebie, nie z nakazu Pana: Jeśli wierzący mężczyzna ma niewierzącą żonę, a ona chce z nim żyć, niech jej nie opuszcza. ");
INSERT INTO polsz_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","I jeśli wierząca żona ma niewierzącego męża, a ten chce z nią zostać, też niech go nie opuszcza. ");
INSERT INTO polsz_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Wierząca żona przybliża bowiem do Boga niewierzącego męża, a wierzący mąż przybliża do Boga niewierzącą żonę. W przeciwnym razie dzieci należałoby uznać za nieprawe, a tak—są święte. ");
INSERT INTO polsz_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Jeśli jednak niewierząca strona chce odejść, niech to zrobi. Strona wierząca nie musi pozostawać w tym małżeństwie—Bóg powołał was bowiem do życia w pokoju. ");
INSERT INTO polsz_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Przecież nie masz pewności, żono, że doprowadzisz niewierzącego męża do zbawienia. Ani ty, mężu, nie jesteś pewien, że twoja żona przyjmie zbawienie. ");
INSERT INTO polsz_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Poza tym, niech każdy pozostanie w takim stanie, w jakim Pan go do siebie powołał. Takie zalecenie zostawiam we wszystkich kościołach. ");
INSERT INTO polsz_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Jeśli ktoś uwierzył Panu, będąc obrzezanym, niech takim pozostanie. Jeśli jednak był nieobrzezany, niech nie dokonuje obrzezania. ");
INSERT INTO polsz_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Ani obrzezanie, ani jego brak nie mają bowiem znaczenia. Ważne jest tylko to, aby podobać się Bogu i przestrzegać Jego przykazań. ");
INSERT INTO polsz_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Niech więc każdy pozostanie w takim stanie, w jakim Bóg go do siebie powołał. ");
INSERT INTO polsz_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Uwierzyłeś jako niewolnik? Nie martw się tym. Jeśli jednak możesz odzyskać wolność, skorzystaj z tego. ");
INSERT INTO polsz_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Wierzący niewolnik jest wolny dla Pana, a wolny wierzący staje się niewolnikiem Pana. ");
INSERT INTO polsz_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Zostaliście wykupieni za wysoką cenę. Nie stawajcie się więc niewolnikami ludzi! ");
INSERT INTO polsz_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","A zatem, przyjaciele, niezależnie od stanu, w jakim kto uwierzył, niech każdy z was żyje dla Boga. ");
INSERT INTO polsz_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","W sprawie niezamężnych dziewcząt nie mam nakazu od Pana. Chciałbym wam jednak coś poradzić jako ten, który doświadczył Jego miłości i jest godny zaufania. ");
INSERT INTO polsz_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Sądzę, że w obecnej, trudnej sytuacji dobrze jest stosować taką zasadę: ");
INSERT INTO polsz_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Jeśli jesteś żonaty, nie dąż do separacji. Jeśli nie jesteś żonaty, nie żeń się. ");
INSERT INTO polsz_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Jeśli się jednak ożenisz, nie grzeszysz. Również dziewczyna, która wyjdzie za mąż, nie popełnia grzechu. Jednak małżonkowie narażają się na trudności życiowe, których chciałbym wam oszczędzić. ");
INSERT INTO polsz_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Przyjaciele, zostało niewiele czasu. Dlatego nawet żonaci powinni być do dyspozycji Pana. ");
INSERT INTO polsz_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Nie pozwólcie, aby smutek, radość, praca zawodowa ");
INSERT INTO polsz_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","lub przyjemności tego świata odciągały was od pracy dla Niego. Ten świat wkrótce przeminie, ");
INSERT INTO polsz_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","a ja chciałbym oszczędzić wam kłopotów. Nieżonaty mężczyzna skupia się na sprawach Pana i chce się Mu podobać. ");
INSERT INTO polsz_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Żonaty troszczy się również o sprawy tego świata, o to, jak podobać się żonie. ");
INSERT INTO polsz_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Doznaje przez to rozterek. Podobnie kobieta niezamężna zajmuje się służbą dla Pana i zabiega o świętość ciała i ducha. Mężatka zaś troszczy się o sprawy przyziemne i o to, aby podobać się mężowi. ");
INSERT INTO polsz_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Mówię to tylko dla waszego dobra, nie po to, aby narzucić wam jakiś ciężar. Pragnę bowiem, abyście godnie i wytrwale służyli Panu. ");
INSERT INTO polsz_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Jeśli więc ktoś czuje, że powinien się ożenić z narzeczoną, bo nie jest w stanie opanować swoich pragnień, niech to zrobi. Małżeństwo nie jest grzechem. ");
INSERT INTO polsz_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Ale jeśli ktoś postanowi w sercu—bez przymusu, dobrowolnie i panując nad sobą—że chce pozostać wolnym, też dobrze zrobi. ");
INSERT INTO polsz_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Zatem dobrze robi ten, kto się żeni. Lecz kto w obecnej sytuacji nie zawiera związku małżeńskiego, dokonuje lepszego wyboru. ");
INSERT INTO polsz_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Żona związana jest z mężem aż do jego śmierci. Gdy jednak on umrze, może ponownie wyjść za mąż za kogo chce, pod warunkiem, że mężczyzna ten również wierzy Panu. ");
INSERT INTO polsz_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Moim zdaniem będzie jednak szczęśliwsza, jeżeli nie wyjdzie za mąż, a w moich radach również poddaję się kierownictwu Ducha Świętego. ");
INSERT INTO polsz_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Teraz chciałbym poruszyć problem mięsa ze zwierząt, które były ofiarowane pogańskim bożkom. Wszyscy mamy wiedzę na ten temat. Wiedza sprawia jednak, że człowiek popada w pychę. Tym zaś, co wzmacnia wiarę innych, jest miłość. ");
INSERT INTO polsz_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Jeśli ktoś uważa, że wszystko już wie, może być pewien, że tak nie jest. ");
INSERT INTO polsz_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Ten zaś, kto kocha Boga, znajduje u Niego uznanie. ");
INSERT INTO polsz_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Wracając do tematu: Wiemy, że pogańskie bóstwa są niczym i że istnieje tylko jeden prawdziwy Bóg. ");
INSERT INTO polsz_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Niektórzy uważają za bogów różne rzeczy na niebie i na ziemi—takich bóstw i panów jest wiele. ");
INSERT INTO polsz_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","Dla nas istnieje jednak tylko jeden Bóg—Ojciec, od którego wszystko pochodzi i do którego należymy. Mamy też tylko jednego Pana, dzięki któremu wszystko zaistniało i który dał nam życie. ");
INSERT INTO polsz_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Niestety nie wszyscy wierzący o tym wiedzą. Niektórzy spożywają mięso ofiarowane bożkom w przekonaniu, że czyniąc tak, oddają im cześć. W ten sposób postępują wbrew sumieniu. ");
INSERT INTO polsz_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Tymczasem spożywanie mięsa nie ma żadnego wpływu na nasze duchowe życie. Nic nie tracimy nie jedząc go; nic też nie zyskujemy spożywając je. ");
INSERT INTO polsz_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Uważajcie jednak, aby wasza wolność nie przyniosła szkody innemu wierzącemu, który jest słabszy w wierze. ");
INSERT INTO polsz_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Załóżmy bowiem, że zauważy on ciebie, „mającego wiedzę”, jak spożywasz w świątyni pokarm ofiarowany bożkom. Czy jego słabe sumienie zostanie wzmocnione, gdy weźmie z ciebie przykład i, wbrew własnemu sumieniu, też będzie jadł? ");
INSERT INTO polsz_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Wręcz przeciwnie, twoja wiedza wyrządzi mu szkodę, a przecież za niego także umarł Chrystus. ");
INSERT INTO polsz_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Gdy więc grzeszycie przeciw innym wierzącym, narażając na szkodę ich słabe sumienie, w rzeczywistości grzeszycie przeciw samemu Chrystusowi. ");
INSERT INTO polsz_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Jeżeli więc przez spożywanie pokarmu miałbym skrzywdzić innego wierzącego, to nigdy nie będę jadł mięsa ofiarowanego bożkom, aby w ten sposób nie doprowadzić nikogo do upadku. ");
INSERT INTO polsz_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Czy nie jestem zupełnie wolny? Czy nie jestem apostołem? Czy nie widziałem na własne oczy Jezusa, naszego Pana? Czy to nie dzięki mojej służbie należycie do Niego? ");
INSERT INTO polsz_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Nawet jeśli inni nie uważają mnie za apostoła, to wy jesteście żywym dowodem tego, że jako apostoł służę Panu. ");
INSERT INTO polsz_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Moja linia obrony wobec oskarżających mnie będzie taka: ");
INSERT INTO polsz_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Czy nie wolno nam korzystać z waszej gościnności? ");
INSERT INTO polsz_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Czy nie wolno nam poślubić wierzącej kobiety i zabrać jej ze sobą w podróż? Tak przecież czynią inni apostołowie oraz bracia naszego Pana. Podobnie postąpił również Piotr. ");
INSERT INTO polsz_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Czy tylko ja i Barnaba musimy za